﻿USE sofia;
DROP TABLE IF EXISTS sofia.nit_vpl;
CREATE TABLE nit_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nit_vpl WRITE;
INSERT INTO nit_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ఇదా ఎన్నె యేసు క్రీస్తునె దొడలె పేల్లె పట్టి ఇమ్దు దావిద్నె రాజక్నె పాడితంద్ ఎన్నెంద్ అని దావిద్ అబ్రాహామ్ పాడితంద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","అబ్రాహామ్ ఇస్సాక్నె బాంద్ ఎన్నెంద్. ఇస్సాక్‍ యాకోబ్నె బాంద్ ఎన్నెంద్. యాకోబ్‍ యూదాక్ అని అమ్నె తోరెంద్నె బాంద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","యూదాక్, తామారున్‍ వాలడ్‍ జన్మిల్తార్ పెరేసున్, జెరున్ ఎన్నెర్, పెరేసక్నె పోరక్ ఎస్రోమ్ ఎన్నెంద్, ఎస్రోము అరామ్నె బాంద్ ఎన్నెంద్, ");
INSERT INTO nit_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","అరామ్ అమ్మీనాదాబ్నె బాంద్ ఎన్నెంద్, అమ్మీనాదాబ్ నయస్సోన్నె బాంద్ ఎన్నెంద్, నయస్సొన్‍ సల్మానె బాంద్ ఎన్నెంద్, ");
INSERT INTO nit_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","సల్మాన్ రాహాబున్ వాలడ్ జన్మిల్త బోయజు. బోయజు రూతున్ వాలడ్‍ జన్మిల్త ఓబేద్, ఓబేద్ యెసయక్నె బాంద్, ");
INSERT INTO nit_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","యెసయ దావిద్నె రాజక్నె బాంద్ ఎన్నెంద్. దావిద్, ఊరియాక్నె మాసలెంద్‍ అదున్వాలడ్ జన్మిల్తద్ సొలొమోను ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","రెహబాము బాంద్ సొలొమోను ఎన్నెంద్. ఆబియక్నె బాంద్ రెహబాము ఎన్నెంద్. ఆసాక్నె బాంద్ ఆబియక్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","యెహోసాపాతక్నె బాంద్ ఆసాక్ ఎన్నెంద్. యెహోరామాక్నె బాంద్ యెహోసాపాతక్ ఎన్నెంద్. ఉజ్జియక్నె బాంద్ యెహోరామక్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","యోతామాక్నె బాంద్ ఉజ్జియక్ ఎన్నెంద్. ఆహాజక్నె బాంద్ యోతామక్ ఎన్నెంద్. హిజికియక్నె బాంద్ ఆహాజ్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","మనస్సెయక్నె బాంద్ హిజికియక్ ఎన్నెంద్. ఆమొసక్నె బాంద్ మనస్సెయక్ ఎన్నెంద్. యోసియక్నె బాంద్ ఆమొసక్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","యూదులున్ బబులోనుంఙ్ కొసెక కాలముత్ యోసియకుంఙ్, యెకొన్యాక్, అని ఔరె దాదకేర్ జన్మిల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ఇస్రాయేల్ బబులోన్ దేసెముంఙ్ సెద్ద వెన్కత్, యెకొన్యాకుంఙ్ సయల్తీయెల్ జన్మిల్తెంద్. జెరుబ్బాబెల్ బాంద్ సయల్తీయెలు ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","అబీహుదక్నె బాంద్ జెరుబ్బాబెల్ ఎన్నెంద్. ఎల్యాకిముక్నె బాంద్ అబీహుదక్ ఎన్నెంద్. అజొరక్నె బాంద్ ఎల్యాకిమ్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","సాదొక్నె బాంద్ అజొరక్ ఎన్నెంద్. ఆకీమ్నె బాంద్ సాదొక్ ఎన్నెంద్. ఎలీహుద్నె బాంద్ ఆకీమ్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ఎలియాజర్నె బాంద్ ఎలీహుద్ ఎన్నెంద్. మత్తాన్నె బాంద్ ఎలియాజర్ ఎన్నెంద్. యాకోబ్నె బాంద్ మత్తాన్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","యోసేప్నె బాంద్ యాకోబ్‍ ఎన్నెంద్. క్రీస్తు ఇనేక యేసుంద్ యోసేప్నె మాస మరియకున్ వాలడ్ జన్మిల్తెద్. ");
INSERT INTO nit_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ఇనంఙ్ అబ్రాహామ్ తనట్ దావిదుంఙ్ ఎన్ చౌదా పీడిక్ ఎద్దె, అని దావిద్ రాజక్నె కాడ్ తన్న యూదు మన్కకెరుంన్ బబులోన్ దేసుంఙ్ సెద్ద కాలందూక్‍ క్రీస్తునె చౌదా పిడిక్ ఎద్దె. యూదు మన్కకెరుంఙ్ బబులోన్ దేసెముంఙ్ కొస్తకాడ తన్నట్ మాన్వాలెంఙ్ ఎంత్ చౌదా పిడిక్ ఎద్దె. ");
INSERT INTO nit_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","మల్ల యేసు క్రీస్తునె జన్మ వరెకద్ ఇనంఙ్ ఎద్దిన్ అమ్నె అమ్మ మరియక్నె సోయ్‍రిక్ యోసేపున్ వెంట ఎత్త అండిన్. గని అమ్నె పెండ్లి ఎరేఙ్ పేలె ఆ పిల్ల పవిత్ర ఆత్మనాడ్‍ పెట్టెనడ్ అనెకద్ కడ్కెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","మల్ల అద్నె మాస్ యోసేప్ నీతి మన్కక్ మంజె సదర్ నేకికున్ అడగిపెకద్ అండెద్, మన్కకెర్ అమ్నున్ లజ్జంఙ్ కొరెంఙ్ తోద్ ఇసా లొల్లి కాల్‍సెట సోయ్‍రికున్ మోడిపెక్ విచార్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","గని అముదు ఇనంఙ్ విచార్ కలెంఙ్, అమ్నుఙ్ ప్రబునె దూత్ ఒక్కొద్ కలనడ్ కడ్కెద్దిన్. అముదు ఇంతిన్ దావిద్ రాజక్నె పాడితంద్ యోసేప్ మరియకున్ వెంట జొడిలెంఙ్ అర్సనెం. తానుంఙ్ ఇంతె అముదు పవిత్ర ఆత్మనాడ్‍ పెట్టెనడ్ అస్సద్ మరొక్కొ పడ్సనడ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","అద్ ఒక్కొద్ పోరకున్ జన్మ తప్పద్ మల్ల నీ అమ్నున్ యేసుంద్ పేర్ ఇడెఙ్. తానుంఙ్ ఇంతె అముదు అమ్నె మన్కకెరున్ పాప్ ఇదర్తదుఙ్ బత్కిప్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ప్రబు ప్రవక్త వాలడ్ ఇడ్త గొట్టిక్ కరే ఎరెంఙ్ ఇసా ఇదా సదర్ ఎద్ద. ");
INSERT INTO nit_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ఓల్ కువారి పిల్ల పెట్టెనడ్ అందద్ అని ఒక్కొ పోరకున్ జన్మ సియద్ అని అమ్నున్ ఇమనుయెల్ పేర్ ఇడ్దర్. ఆ పేర్‍నే ఆర్తం దెయ్యం నేండున్‍ వెంట అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","మల్ల యోసేప్ మంఙ్ సుల్తవెన్కత్, అముదు ప్రబునె దూత్ ఎనంఙ్ ఇడ్తిన్, అనెంఙ్ కతెంద్ అని మరియకున్ జొడిల్తెంద్ అని ఎల్లంఙ్ తోడ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","గని అద్ పిల్ల పడ్స ఎన్నంతెంఙ్ అదున్ వెంట కలయెతెంద్. యోసెప్ అమ్నున్ యేసుంద్ ఇసా పేర్ ఇట్టెద్. ");
INSERT INTO nit_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","హేరోద్ రాజక్నె కాడుత్ యేసుంద్ యూదియ దేస్త బేత్లెహేమ్ ఊరున్ జన్మిల్తె, బుద్దిత్ మన్కకెర్ కొన్సెం మద్ది పొద్కురిన వాలాడ్ యెరూసలేముంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","ఔర్ వేల్తెర్. యూదులె రాజక్ జన్మిల్తెంద్. తానుంఙ్ ఇంతె అమ్నె పొద్కురిన పకంఙ్‍ చుక్కన్ ఓలుత్న అమ్నున్ మొక్కెంఙ్ వత్తమ్. ఆ పోరక్ ఎత్తి అన్సాంద్? ");
INSERT INTO nit_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","హేరోద్ రాజక్ ఈ గొట్టిన్ వింత్న మల్ల సదర్ యెరూసలేంతర్ అమ్నున్ వెంట గాబ్రిల్తేర్. ");
INSERT INTO nit_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","అని అముదు సదర్ దండి దెయ్యలక్ అని సాస్త్రి మన్కకెరున్ కూగ్తెంద్ అని క్రీస్తునె ఎత్తి జన్మిలెకద్ అన్సాద్ అదున్ బదోల్ వెల్తొల్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“ఔరు అమ్నున్ ఇంతెర్,” యూదియతా బేత్లెహేమ్ ఊరుఙ్ జన్మిల్‍సాంద్. తానుంఙ్ ఇంతె ప్రవక్త ఇనంఙ్ వయ్తెంద్, ");
INSERT INTO nit_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","యూదియ దేస్త బేత్లెహేమ్ ఊరా! యూదియ మెన్ పట్నత నీ తనయ్ కమితని ఎరె. అన్నె ఇస్రాయేల్త మందిన్ గాయ్కిలంఙ్‍ పొరయెకాంద్ ఇత్తిని జన్మిల్దంద్ ఇసా ప్రవక్తకెర్ వాయ్తెర్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","అపుడ్ హేరోద్ ఆ సుక్క కడ్కెరెక కాలమ్‍ ఔరడ్ జబాబ్‍లంఙ్ ఒర్కికతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","నీర్ సెత్న ఆ పొరకున్ బదోల్ ఉసరడ్ వెల్తొలుత్ ఒర్కి పడెఙయ్, అన్ వత్న, అమ్నున్ పూజ కత్తెతి అనుంఙ్ మొక్ కొర్రిసా ఔరున్ బేత్లెహేముంఙ్ పన్కతెంద్ ");
INSERT INTO nit_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ఔరు రాజక్నె గొట్టిన్ వింత్న సెసనన్నెంఙ్ ఇదొ పొద్కురినా వాల దేసెంత్తర్ ఒల్త సుక్క ఆ పొరకున్‍వై సర్కక్‍ వత్న ఇల్‍నంత్తెంఙ్ ఔరుంఙ్ ముడటి అడ్గుంద్‍. ");
INSERT INTO nit_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ఔరు ఆ సుక్కన్ ఓలుత్, గుల్ కుసింఙ్ వత్తెర్, ");
INSERT INTO nit_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ఎల్లంఙ్‍ సెత్న, పోరకున్ అని అమ్నె అమ్మ మరియకున్ ఓలుత్ కుసీంఙ్ వత్ మొక్సర్. తమ్మె సందొకన్‍ పుస్సుత్ బఙ్ఙర్, దూప్, అత్తర్ దాన్ లాంఙ్ అమ్ముంఙ్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","హేరోద్వై మలయుత్ సెరెంఙ్ తోద్ ఇసా దెయ్యం ఔరుంఙ్ కలత్ అర్పులిపెకదుంఙ్ వాలడ్ ఔర్ మరొక్కొ పావడ్ తమ్మె సొత దేసముత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ఔరు చెద్ద వెన్కత్ ప్రబునె దూత్ యోసేపున్ కలనడ్ కన్కెత్న, “సులుత్ పోరకున్ ఆమ్మన్ తోడ ఐగుప్తుంఙ్ తూల్‍ సే. అన్ ఇనుంఙ్ పెనా ఇడ్నంతెంఙ్ అత్తిని అన్. తానుంఙ్ ఇంతె హేరోద్ ఈ పోరకున్ అల్ఙెంఙ్ ఇసా కిరవ్సద్ ఇసా” అమ్నుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","యోసేప్ సులుత్న సింతె తా వేలంఙ్ పొరకున్ సుముత్ ఐగుప్తుంఙ్ తోడసెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","హేరోద్ తిక్నంతెంఙ్ అత్తిని అండెంద్. “ఐగుప్తు తన్న అన్నె పోరకున్ కూ‍గ్తన్” ఇసా ప్రవక్త కెర్ ప్రబుద్ ఇడ్త గొట్టిక్ ఇనంఙ్ ఎద్దె. ");
INSERT INTO nit_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ఆ గ్యానుల్ తమున్ మోసమ్ కత్తెర్ ఇసా హేరోద్ ఒర్కిలుత్ రగ్గుంఙ్ వతెంద్. తాన్ గ్యానిన్ తన్న ఒర్కిలెకా కాలముంఙ్ బేత్లెహేమ్, అదున్ తిర్గొర్ అనెక ఊల్లా ఇందిగుంఙ్‍ కమ్మి వయస్తా చిన్నం పోరకరున్ అలంఙ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","యిర్మీయా ప్రవక్తకున్ వాలడ్ ఇడ్త గొట్టిక్ ఇనంఙ్ ఎద్దె. ");
INSERT INTO nit_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","అర్రెకదుంఙ్‍, దుక్కమడ్ రామ పట్నముత్ లెంఙ్ విన్కవాత్తిన్. రాహేల్ తన్నె పొరకెరుంఙ్ సటీ ఆర్సనసాద్. ఔరున్ బుడపుత్న సొసిప్సెట ఆదారెత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","హేరోద్ తిక్తా వెన్కత్ ప్రబునె దూత్, ఐగుప్తుత్ యోసేపుంఙ్ కలత్ వత్తంద్. ");
INSERT INTO nit_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“మల్ల సులుత్, పోరకున్ అని అమ్మన్ సుమ్ముత్ ఇస్రాయేల్ దేసుంఙ్ సె. పోరక్నె పానం సుమ్మెంఙ్ ఓల్తర్ తిక్నేర్” ఆసా ఇడ్తేర్. ");
INSERT INTO nit_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","అప్పుడ్ అముదు, పోరకున్ అమ్మన్ సుమ్మత్ ఇస్రాయేల్ దేసెముంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ఇంతె అర్కెలాయ తన్నె బాంద్ హేరోద్నె జాగత్ యూదియ దేసెముత్ వాగిప్సాంద్ ఇసా వింత్, అత్తి సెరె ఇసా యోసేప్ అర్సతెంద్ దెయ్యం అమ్మున్ కలత్ అరపులిప్తిన్ గలిలీయ బార్సంఙ్‍ సెత్న, ");
INSERT INTO nit_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","నజరేత్ ఇనెక ఊరుంఙ్ బతుక్తెంద్. యేసునున్ “నజరేయక్ ఇసా కూగ్సర్” ఇసా ప్రవక్త ఇడ్త గొట్టి ఇనంఙ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ఆ దినాలుంఙ్ బాప్తిస్మ సియెక యోహాన్ వత్న యూదియ దేస్త బట్టిత్ వత్ గొట్టిక్ ఇడ్స వతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“పరలోక రాజ్యం మేరం వత్తిన్, అదుఙి మన్ బద్లిపుర్!” అముదు ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ప్రవక్త ఇనేక యెసయకున్ వాలడ్ ఇడ్డెకాంద్ ఇమ్‍ది, ప్రబునె పావ్ తయార్ కలుర్, అమ్నె పావ్ సార్కక్ కలుర్ ఇసా బాట్టిత్ వపొయుత్ ఇడ్డెక లెంఙ్‍ విన్కవత్తిన్, అని అమ్‍ది యోహాన్ బదోల్ ఇడ్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ఈ యోహాన్ ఓట్నె బూర్త జుఙ్ఙె తొడనెంద్ అని ముల్కెత్ తోల్నె పట్ట కట్నెంద్. అమ్నె తినెకద్ మింటె అని అడవి తా తెనే ఎంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","పెల్లెటర్ యెరూసలేంతర్ అని పెల్లెటర్ యూదియ బార్సతర్ అని యోర్దన్ పేనింఙ్ తిర్‍గొర్ అనెక సదర్ జాగల మన్కకెర్ అమ్నున్‍వై వన్నెర్, ");
INSERT INTO nit_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ఔర్ ఏనెత్‍ అముదు పాప్ ఇదర్తదుఙ్ ఓలుత్న అమ్నున్ వలడ యోర్దన్ పేనిత్ బాప్తిస్మ సుమ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","గని అముదు పెలెటర్ పరుసి మన్కకెర్ అని సద్దుకి మన్కకెర్ బాప్తిస్మ సుమెంఙ్ వరెకరున్ ఓల్తెంద్, ఆ వరెన్ ఇంతెద్. ఏ పామ్నె కొవ్వెలాంఙ్ మనకకెర్, వారెక్ రగ్తన్న కురియుత్ తులెంఙ్ ఇసా ఏంద్ ఇమున్ ఉసార్ కతెంద్? ");
INSERT INTO nit_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","అదుంఙ్ సటీ, ఇమ్మెపాపు తన నీర్ మన్ బద్లిపెకాద్ ఇసా ఓలిపెంఙ్ ఇసా ఇదా ఇదరూర్. ");
INSERT INTO nit_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","అని అబ్రాహామ్ అమ్మె బాంద్ అన్సాద్ అమ్ మరొక్కొరుంఙ్ ఎన సోయ్ అన్సాంతుమ్ ఇనంఙ్ ఇమ్మె మనుత్ విచార్ కన్నెర్. తానుంఙ్ ఇంతె అన్ ఇముంఙ్ ఇడసత్, దెయ్యం అబ్రాహాముంఙ్ ఈ గుండ్ల వాలడ్ పోరకేర్ బనపెంఙ్ సాల్‍సద్. ");
INSERT INTO nit_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","పఙ్ఙిని మాక్నె మడ్డత్ గొల్లి అన్సాద్. అదుంఙ్ ఎత్తి, సోయ్ కైసెటండె సదర్ మాక్ పనింఙ్ వర్సెట కత్కుత్ కిసుత్ జొపిడ్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","మన్ బద్లిపెకాద్ ఇముంఙ్ అన్ ఈరడ్ బాప్తిస్మ సియత్. గని అనుంఙ్ ఎన సక్తితద్ ఒక్కొద్ అనుంఙ్ వెన్కత్ వర్సనన్సాంద్. అమ్నె కెర్రిక్ పుసెంఙ్ గిన హక్ తోతెన్. అముదు ఇముంఙ్ పవిత్ర ఆత్మనాడ్‍ అని కిసాడ్ బాప్తిస్మ సియ్‍దద్. ");
INSERT INTO nit_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ఆమ్నె కేత్ ఆమ్నె కెయ్యుత్ అన్సాద్ అని అముదు అమ్నె కలవె తవున్ సోయ్‍ అయ్యుత్న అమ్నె గొద్మలున్ మిరపుత్న గుమ్మిత్ వాఙ్సాద్, గని అముదు పొట్టున్ కిట్‍సెట కిసాడ్‍ కిసిడద్ ఇసా ఔరుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","మల్ల యేసుంద్ యోర్దన్ పేనిత్ యోహాన్ కెయ్యడ్ బాప్తిస్మ సుమొంఙ్ గలిలీయ బార్సతనట్ యోర్దన్ పేనింఙ్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","అనఙెద్దె యోహాన్ అమ్నున్ తోద్‍ గని ఇన్నె కెయ్యాడ్ సుమ్మెకరన్ అనెంఙ్, నీ తానుంఙ్ అన్నె కెయ్యాడ్ బాప్తిస్మ సుమెంఙ్ వాత్తివ? ");
INSERT INTO nit_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","గని యేసుంద్ ఇంతెంద్, ఇండి ఇనాయ్ ఎరెఙీడ్; నీతి సిమ్కనఙ్ సాటి ఇనంఙ్ కలెకద్ నెడుంఙ్ సొయ్ ఇసా అమ్నుంఙ్ ఉత్తర్ సియ్తెంద్ అదుంఙ్ ఎత్తి అముదు అనయ్‍ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","యేసు బాప్తిస్మ సుముత్ ఈర్తన పొద్దె కురియ్‍తెంద్, వెటాయ్ ఆబార్ పాయ్‍తిన్, అని దెయ్యమ్నె ఆత్మ పారెవనె రూపాడ్ అమ్నున్ పొయ్ డిగెకదున్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","మల్ల పరలోకం తన ఒక్కొ విన్కవతిన్ నీ అన్నె లాడ్త పోరక్ ఎన్ని. ఇన్ వాలడ్ అనుంఙ్ కుసీ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","మల్ల యేసున్ సైతన్‍ పరిక్స సుమ్మెఙ్ ఇసా దెయ్యమ్నె ఆత్మనడ్ యేసునున్ బట్టింఙ్ పన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","అమునున్ సాడిస్ దిన పాతె అని సింతె ఉపాస్ అనెంఙ్‍, అమ్నుంఙ్ కర్‍వెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","మల్ల సైతన్ వత్న అమ్నున్ ఇంతిన్ నీ దెయ్యమ్నె పోరక్ ఎన్నివ్ ఎరతె, ఈ గుండ్లున్ నిపట్టె ఎర్గల్ ఇసా ఇడుర్ ");
INSERT INTO nit_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","గని అముదు ఇతెద్: లెకనమూత్ ఇనంఙ్ వాయుత్ అన్సాద్. మన్కక్ బత్కెకాద్ వట్టి నిపట్టెనడ్ తోద్‍ గని దెయ్యమ్నె మూతి తన కురియేకంద్ ఒకొక్కొ గొట్టినాడ్ బాత్కదాద్ ");
INSERT INTO nit_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","మల్ల బూత్ అత్రన అమ్నున్ పవిత్ర పట్నం యెరూసలేముంఙ్ కొసుత్న గుడిత జుట్టిత్ ఇల్పతిన్. ");
INSERT INTO nit_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","అని అమ్నున్ ఇంతిన్ నీ దెయ్యమ్నె పోరక్ ఎనివెర్‍తె, ఇత్రనట్ బూడున్ ఉర్కు ఇనుంఙ్ తనయ్ ఎరెద్. తానుంఙ్ ఇంతె దూతు గొట్టిక్‍ వాయుత్ అన్సాద్. ఇనుంఙ్ సటీ దెయ్యం తన్నె దూతులున్ ఉకూమ్ సియద్ అని ఇన్నె గెట్టలున్ గుండ్లునాయ్ తకెంఙ్‍తొద్ ఇసా అదవ్ ఇంన్ కెయ్యులెంఙ్ హస్‍ద. ");
INSERT INTO nit_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","యేసుంద్ అమ్నున్ ఇంతెంద్. తోద్‍ గని పుస్తకుత్ ఇనంఙ్ వాయుత్ అన్సాద్ నీ ఇన్నె దెయ్యం ప్రబుక్నె పరిక్స ఓల్‍నెమ్. ");
INSERT INTO nit_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","పెన్న బూత్ అమ్నున్ దండి మెట్పొయ్ కొస్తిన్ అని దున్యత్ రాజ్యలున్, అదావ్లె సొబాన్ సిమ్కన ఓలిప్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","అని అముదు అమ్నున్ ఇంతిన్ నీ అన్నె కాల్కు మొక్తి వింతె, దున్యత్ అనెకా ఇద సదరున్ ఇనుంఙ్ ‍సియత్. ");
INSERT INTO nit_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","మల్ల యేసుంద్ అమ్నున్ ఇంతెంద్: కురియుత్ సె సైతన్. కారన్ దెయ్యమ్నె గొట్టక్ ఇనంఙ్ వాయుత్ అన్సాద్. నిస్తొ ప్రబుది ఇన్నె దెయ్యం అమ్నె కాల్‍కు మొక్కెంఙ్ అని అమ్నెతి సేవ కలెంఙ్ ఇసా వాయుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","మల్ల బూత్ అమ్నతన్న కురియ్తిన్ అని దూత్ వత్న అమ్నె సేవ కన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","హెరొద్ రాజక్ పాపం కతెంద్ ఇసా యోహాన్ ఇడ్‍తెంద్ అమ్నున్ కొడప్తెర్ ఇసా యేసుంద్ వింత్తె, అముదు గలిలుంఙ్ మలయుత్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","నజరేతు ఊర్తన్న కురియుత్న అముదు మడ్గవై అనెక్ జెబూలూన్ అని నప్తాలి బార్స మెర అనెక కపర్నహూమ్త ఊరుంఙ్ సెత్న అత్తి అన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","జెబూలూన్ దేసమున్ నప్తాలి దేసమున్, యొర్దానుంఙ్ అలపకంఙ్ అన్నెక సముదురుంఙ్ సిమ్కన మంది బత్కెక గలిలయతర్. యెసయక్ ప్రవక్త ");
INSERT INTO nit_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“జెబూలూన్ జాగా అని నప్తాలి జాగా యోర్దన్ పేని పొల పకంఙ్‍, గలిలయ సముద్రంఙ్ అల పకంఙ్ అనెక్ యూదులెర్సెటార్ మన్కకెర్ వస్తి కల్సనన్సార్, ");
INSERT INTO nit_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","సిర్మనత్ అనెక్క మన్కకెర్ దండి వెల్ఙున్ ఓలెంఙ్ ఇడ్సాంద్ అని తిక్తనె నిడత్ అని జాగత్ అనెకర్ పొయ్ వెల్ఙు తరియ్ద.” ");
INSERT INTO nit_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","అపుడ్ తన యేసుంద్ గొట్టిక్ ఇడ్డెంఙ్ ఎద్దెంద్ మన్ బద్లిపుర్ తానుంఙ్ ఇంతె పరలోక రాజ్యం కలెక మెర వత్త అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","మల్ల యేసుంద్ గలిలీయ సముద్ర మెరనడ్ అడగ్స సెరెఙ, అముదు ఇద్దరున్ మంజె సీమోన్ ఇమ్నున్ పేతురుంద్ ఇన్నేర్ అని అమ్నె తోరెంద్ అంద్రెయక్ ఇవ్రు సముద్రత్ జాల్ తప్పెంఙ్ ఓల్తెద్. తానుంఙ్ ఇంతె ఔర్ దీవల్ ఎన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","యేసుంద్ ఇంతెంద్. అన్ వెంట వర్ర. అన్ ఇమున్ మన్కకెరున్ అనవై కొరెకర్ బానప్సత్. ");
INSERT INTO nit_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","అముదు అపుడ్ ఔర్ తమ్మె రాజ్ కలెక జాల్లున్ సాయుత్న అమ్నున్ వెంట సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","యేసుంద్ అంతె తనట్ సెరెఙ, అమ్నుంఙ్ మరొక్కొర్ ఇద్దర్ రొంబట్టెర్. ఔర్ జెబెదయి ఇనెక పోరకేర్ యాకోబ్‍ అని అమ్నె తోరెంద్ యోహాన్ ఎన్నెర్. ఔరె బాంద్ జబదకుంన్ వెంట రూకుత్ ఉదుత్న ఔరె జాల్లున్ సుద్రిప్‍నెర్ అని యేసుంద్ ఔరున్ కూగ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","అముదు అపుడ్ ఔరె రూకున్ అని ఔరె బానున్ సాయుత్ అమ్నున్ వెంట సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","యేసుంద్ గలిలయత్ సదర్ జాగలెంఙ్ సెత్న ఔరె యూదులె సావ్డిక్లెంఙ్ కర్పసాద్ అని రాజ్యం కలెక సోయ్త గొట్టికున్ ఇడ్తెంద్ అని మన్కకెర్ లోప అనెక్ సదర్ దుక్కములున్ అని రొగులున్ సోయ్ కన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","అని అమ్నున్ బదోల్ కబుర్‍ సదర్ సిరియ దేసముత్ నెర్యతిన్ అని మన్కకెర్ రంఙ్ రంఙ్త దుక్కలకెర్, రంఙ్ రంఙ్త బేమరి అని తక్లిబాడ్ అనెక్ మన్కకెర్, బూతు సుమ్‍తర్, గురెలకెర్ అని కుంటికూన్ అన్వై తోడ వత్తెర్ అని అముదు ఔరున్ సోయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","గలిలయ దెకపొలి బార్స, పది పట్నాల బార్స, యెరూసలేం పట్నం, యూదియ బార్స అని యోర్దన్ పేనింఙ్ అల పక్క తర్ పెరెత్ మన్కకెర్ అమ్నున్ వెంట సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","యేసుంద్ పెరెత్‍ మందిన్ ఓలుత్న మెట్పొయ్ సెత్న ఉద్తెంద్. అమ్నె సిసు అమ్నున్వై వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","అని అముదు ఔరున్‍ కరపెంఙ్ ఎద్దెంద్, ");
INSERT INTO nit_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","ఆత్మ లోప గరీబున్ కరిపెకద్ అముదు దన్యుల్ అన్సాంతిర్. తానుంఙ్ ఇంతె పరలోక రాజ్యం ఔరెతి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","దుక్క పడేకార్ దన్యుల్ అన్సాంతిర్. తానుంఙ్ ఇంతె దెయ్యం ఔరున్ ఆదారెర్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","సాంతి నడానెకార్ దన్యుల్ అన్సాంతిర్. తానుంఙ్ ఇంతె దెయ్యం కాబులి కత్త బూమిన్ ఔరెత్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","నీతి కలెంఙిసా దండి ఆసనాడ్ అనెకార్‍ దన్యుల్‍ అన్సాంతిర్. తానుంఙ్ ఇంతె ఔర్ దనియ్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","కివ్ కలెకర్ దన్యుల్ అన్సాంతిర్. తనుంఙ్ ఇంతె దెయ్యమున్ వాలడ్ ఔరుంఙ్ కివ్ రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","మన్ సాపనేకార్‍ దన్యుల్ అన్సాంతిర్. తానుంఙ్ ఇంతె ఔర్ దెయ్యమున్ ఓల్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","సమాదాన్ కలెకర్ దన్యుల్‍ అన్సార్. తానుంఙ్ ఇంతె ఔర్ దెయ్యమ్నె పోరకేర్ ఎద్దర్. ");
INSERT INTO nit_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","నీతి ఆస పూర కలెకారుంఙ్ తక్లిబ్ వాత్తె అముదు సోయ్‍కలెకాంద్ దన్యుడు. తానుంఙ్ ఇంతె పరలోక రాజ్యం కలెక ఔరెతి అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","నీర్ అన్ వెంటతర్ ఎత్న మన్కకెర్ ఇమున్ బద్నాం ముడుత్, తక్లిబ్ సియ్యుత్, విరోద్ కత్ లబాడ్ పురవ ఇడుత్ బద్నం కత్తెరింతె, నీర్ దన్యుల్ అన్సాంతిర్. ");
INSERT INTO nit_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","అప్పుడ్ కుసినడ్ అనంద్ కలుర్! గులెనా కుసీంఙ్ వార్ తానుంఙ్ ఇంతె పరలోకముత్ ఇముంఙ్ దండి ఇనామ్ రొంబడ్సాద్. అనాయ్ పేలెతర్ ప్రవక్తకేరున్ నాయ్ మన్కకెర్‍ అనాయ్‍ తక్లిబ్ సియెతేర్ తా. ");
INSERT INTO nit_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","నీర్ బూమి తరుంఙ్ సుప్‍లంఙ్ అన్సాంతిర్ గని సుప్నెసుప్పె సెదిన్ ఇంతె, ఎనంఙ్ సుప్పె కలాతిర్? అద్దడ్ తనయ్ పైదహ తోతెద్. అంటదున్ వాక జొపిడ్‍దర్. మల్ల మన్కకెర్ గెట్టలడ్‍ విద్గెంఙ్ దెకుల్ పని పడెద్. ");
INSERT INTO nit_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","నీర్ దున్యత్ తరుంఙ్ వెల్ఙులాఙ్ అన్సాంతిర్. మెట్పొల ఊరున్ డాపెంఙ్ వారెద్. ");
INSERT INTO nit_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ఎరి మన్కకెర్ దీవే తర్పుత్ అదున్ కొనొడత్ ఇడుర్ గని ఆ ఎల్లత్ అనెకర్ సదరుంఙ్ వెలుంఙ్ సియెంఙ్ ఇసా క్కొనొడ పొయ్ ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","అనాయ్, మన్కకెర్ ఇమ్మె మన్కకెర్ ముండట్ ఇమ్మె వెల్ఙు తరియెకద్ కన్కెరెంఙ్ పాజె ఇసా సోయ్త పనికున్ ఓలుత్న పరలోకముత్ అనెక ఇమ్మె బానెత్ స్తుతి కలెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","మోసెన్నె నియమ్ సాస్త్రనే, ప్రవక్తకెరె గొట్టికునేకద్ మోడిపెంఙ్ వాత్తన్ ఇసా విచార్ కన్నెర్. మోడిపెంఙ్ వరెతన్ గని అన్న బదోల్ ఇడ్తవున్ సిమ్కనాన్ కరే కలెంఙ్ వాత్తాన్. ");
INSERT INTO nit_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","తానుంఙ్ ఇంతె అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్. ఆబార్ అని బూమి నాస్ ఎరద్ గని నియమ్ సాస్త్రనెత్ ఎనంతెంఙ్ అత్తద్ సిన్నం అకడన్నాయ్ నాస్ ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","అదుంఙ్ ఎత్తి, ఆ ఆగ్య లోప ఒక్కొద్ సిన్నం నెకి ఎంద్ ఎన మోడిపుత్ మరొక్కొరునయ్ కరప్తెంద్ ఎర, అమ్నుంఙ్ పరలోక రాజ్యముత్ కలెక సిన్నం ఎద్దంద్. గని ఏంద్ ఈ నేకికున్ పారిపుత్న అని కరపుత్న, అమ్నుంఙ్ పరలోకముత్ దండి రాజ్యం కలెక ఎద్దంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","తానుంఙ్ ఇంతె అన్ ఇముంఙ్ ఇడ్సత్. ఇమ్మె నీతి నియం సాస్త్ర గురు, పరుసి మన్కకెరుంఙ్ ఎన జాస్తి తోసెటండె, నీర్‍ పరలోక రాజ్యముత్ ఏ మాత్రం సెరెంఙ్‍ సాలెర్‍, ఇసా ఇముంఙ్ ఇడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","అలఙ్నెమ్ అని మరొక్కొనున్; అల్ఙెకనెత్ సిక్స తాన్న ఎరద్ ఇసా పేలెతరుంఙ్ ఇడ్తా గొట్టి నీర్ వింత్త అండ్డిర్. ");
INSERT INTO nit_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","గని అన్ ఇముంఙ్ ఇడత్. ఎంద అమ్నె దాదక్ బాయిన్ పొయ్య అగమ్మి రాగ్గుంఙ్ వరద్ అమ్నె సిక్స సదర్‍ దెయ్యం తన్నట్ ఎరద్. అని ఎంద తన్నెదాదక్‍నెత్ బద్నం కద్దంద్ అమ్నుంఙ్ పరలోకముత్ న్యాయ్ సబాతన్ న్యాయ్ ఎరద అని ఎద్దెన అమ్నె దాదకున్ బైతడ్ ఇందద్ అముదు నరకమ్ కిస్త నెగడింఙ్ సెద్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","అదుంఙ్ ఎత్తి, నీ ఇన్నె బావ్ సియేక పీట కొత్తి, గని ఇన్నె దాదక్ ఇన్నె విరోద్ అన్సాంద్ ఇసా ఇనుంఙ్ అది వత్తిన్ ఇంతె, ");
INSERT INTO nit_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ఇన్నె మొక్కున్ అదెని బావ్ సియేక పీట ముదర్వై సాయుత్న సె. అని పేలె దాదక్ వెంట మాప్కలిన్. అని మల్ల వత్న ఇన్నె మొక్కున్ సియ్. ");
INSERT INTO nit_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ఇన్ పొయ్ కసుర్ జొపిట మన్కక్ వెంట నీ కొరొటుంఙ్ సెరెంఙ్, పేలెయ్ అమ్నున్ జాలద్ ఆప్సికల్సంద్. తోద్తె ఇన్పొయ్ అరొప్ జొపిట మన్కక్ ఇన్ న్యాయ్ కలెకంద్ సిపయినె కేయ్యుత్ సియ్యుత్ జేలుత్ కొండప్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","కరెయ్ అన్ ఇమ్ముంఙ్ ఇడ్సత్ ఇన్నె ఆక్రి పైసె కట్‍నంతెంఙ్ నీ జెల్తనట్ కురియెంఙ్ సాలే. ");
INSERT INTO nit_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","చినలి కన్నెమ్ ఇసా వింతరుఙ్ ఇడ్‍త గొట్టిన్ నీర్ విత్న అన్సాంతిర్. ");
INSERT INTO nit_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","గని అన్ ఇముంఙ్ ఇడ్సత్ చినలి ఎందెనా ఒక్కొ పిల్లన్ ఓల్తెంద్ ఎరతె, అముదు అమ్నె మన్నుత్ ఆ పిల్లన్ వెంటా సినాలి కత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ఇన్నె ఉన్న కన్‍ ఇన్‍ పాప్ కాల్లెంఙ్ ఇట్టినింతె, అదున్ పుసుత్ జొపిడ్. కారన్ న్యాయ్ సబా ఇన్నె పూర సరీర్ నరకముత్ జొపిడెకదుంఙ్ ఎన ఇన్నె మేన్త ఒక్కొ అవయున్ నాస్ ఎరెకద్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","అని ఇన్నె ఉన్నా కెయ్య పాప్ కల్సదెరతె, అదున్ పుసుత్ జొపిడ్. కారన్ న్యాయ్ సబా ఇన్నె పూర సరీర్ నరకముత్ జొపిడెకదుంఙ్ ఎన ఇన్నె మెన్‍త ఒక్కొ అవయ్ నాస్ ఎరెకద్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","మల్ల ఇటద్ నాయ్ దెయ్యమ్నెకి ఇడ్సద్ ఎద్ తన్నె మాసలున్ సాయ్‍దాద్, అముదు అదుంఙ్ పర్కత్‍నామా సియెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","గని అన్ ఇముంఙ్ ఇడ్సత్ చినలిన్ నిమిత్ సివయ్ మరొక్కొ నిమితడ్ ఎంద్ తన్నె మసాలున్ సాయ్దంద్, దెయ్యమున్ ముండట్ అముదు అదున్ చినలి కలెంఙ్ ఇడ్డెకద్ ఎరాద్ అని ఎంద్ సాయ్‍త పిల్లన్ కద్దాంద్, అముదు దెయ్యమున్ ముండట్ చినలి కల్లెకంద్ ఎద్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","పెనా అగమి కబుల్‍ కలెకద్ తోద్ గని నిర్‍ కబుల్‍ కత్తిర్ ఎరా, బరాబర్ ప్రబునుంఙ్ సియుర్ ఇసా ఇడ్త పేలెతరుంఙ్ ఇడ్‍త గొట్టిక్ నీర్ వింత్ అన్సాంతిర్. ");
INSERT INTO nit_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","గని అన్ ఇముంఙ్ ఇడ్సత్ దెయ్యమ్నె సింహాసనమ్ ముండట్ కబుల్ కన్నెర్. పరలోక రాజ్యం తానుంఙ్ ఇంతె అద్‍ దెయ్యమ్నె ఉద్దెక జగ ఎంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","బూమినె పెరాడ్ కబులి కన్నెర్ తానుంఙ్ ఇంతె బూమి దెయ్యమ్నె గెట్ట ఇడెకా పీటా ఎంద్. యెరూసలేంనె పెరాడ కబూలి కన్నెర్. తానుంఙ్ ఇంతె అద్ దండి రాజక్నె పట్నం ఎంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ఇమ్మె తల్పొల ఒక్కొ తిరున్‍నాయ్ తెలోడి ఎక్కద్, కారి ఎక్కద్ కలెంఙ్ సాలెర్. గని, ఇమ్మె తల్పొయ్ ప్రమానం కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","నీర్ అనాయిసా ఇంతిరింతె అయ్ తోదిసా ఇందతి‍త్తె తోద్. ఇంతెతి, అనాంఙ్ అన్సె టాండె సైతానుంఙ్ కలైది. ");
INSERT INTO nit_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","కంనుఙ్ బదోల్ కంన్ పుసెకాద్ పల్లుంఙ్ బదోల్ పల్లు పుసెకాద్ ఇసా ఇడ్తదున్ నీర్ వింతిర్ తా. ");
INSERT INTO nit_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","గని అన్ ఇడ్డెకాద్ తన్నెద్ ఇంతె దుస్మన్‍లున్ ఇల్పెకాదుంఙ్ కోసీద్ కన్నెర్. ఇమున్ ఎరేనా ఉన్న చెంపన్ లగప్తె ఎడమ పకతా చెంపనాయ్ అమ్నుంఙ్ ఓలిపుర్. ");
INSERT INTO nit_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ఎందెన ఇన్నె కోటున్ కొసుత్ ఇన్నె జుఙ్ఙెన్ వేత్తెంఙ్ కిరవ్సాంద్ ఎరత్తె అమ్నుంఙ్ ఇన్నె జుఙ్ఙెన్ సియ్‍. ");
INSERT INTO nit_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ఎందేనా ఇన్ వరెంఙ్ జబర్దస్తి కత్న ఒక్కొ కోస్‍ కొస్తెంద్ ఇంతె అమ్నున్ వెంటా ఇందీ కోసు సె. ");
INSERT INTO nit_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","వేలెకరుంఙ్ సియుర్. ఇమున్వై పోయ్ వేలెంఙ్ వత్తనుంఙ్ తోదిన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","సంఙ్తకేర్ వెంటా ప్రేమడ్ అండ్ర, విరోద్ కలెకారున్ విరోద్ కలుర్ ఇసా ఇడ్డెకదున్ నీర్ వింత్తిర్ తా. ");
INSERT INTO nit_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","గని అన్ ఇండి ఇడ్డెకాద్ తనెదింతె, ఇమ్మె దుస్మడ్లున్ ప్రేమ్ కలుర్ ఇమున్ విరోద్ కలెకరుంఙ్ సటీ పార్తన కలుర్, ");
INSERT INTO nit_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","అపుడ్‍ నమ్సెటాంద్ నీర్‍ ఇమ్మె పరలోకముత్ అనెకా ఇమ్మె బానె పోరకేర్ ఎరతిర్. తానుంఙ్ ఇంతె దెయ్యం నీతి అనెకరుంఙ్నాయ్ కరాబ్ అనెకరుంఙ్నాయ్ వెలుంఙ్ తయార్ కత్తంద్. సోయ్ తరుంనాయ్ కరాబ్ అనెకరుంఙ్నాయ్ వాన వరెంఙ్ ఇట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ఇముంన్ ప్రేమ్ కలేకారున్ నీర్ ప్రేమ్ కత్తిరింత్తె ఇముంఙ్ తనెద్ పైదా రొంబడ్సాద్? అప్త వసూల్ కలెకార్నాయ్ అనంఙ్ కాల్సార్ తా? ");
INSERT INTO nit_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ఇమ్మె దాదకెరుని నీర్ సోయ్‍ ఓలెర్తె మరొక్కొరుంఙ్ ఎన నీర్ తన్నె సోయ్ కల్సతీర్? యూదులెర్సెటర్ ఔర్నాయ్ ఇనంఙ్ కల్‍సార్ త! ");
INSERT INTO nit_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","పరలొకముత్ అనెకా ఇమ్మె బాంద్ సోయ్తంద్ నీర్‍ నాయ్ అమ్లంఙ్ అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","ఉసారడ్ అండ్రు! దెయ్యముంఙ్ ముండట్ ఇమ్మె మన్నాడ్ నీతి పనిక్ కలెఙ మన్కకెర్ ఓలెంఙ్ ఇసా ఔరున్ ముండట్ కలెంఙ్ తోద్. ఆనంఙ్ నీర్ కత్తిరింతె, పరలోకముత్ అనెక ఇమ్మె బానత్తన ఇముంఙ్ తనయ్ కుల్కడ్ రొంబాడెద్. ");
INSERT INTO nit_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","అదుంఙ్ ఎత్తి, నీర్ గర్జ పట్టరుంఙ్ సియెఙ, కప్టి మన్కకెర్ కలెకద్‍లాఙ్ మన్కకెర్ తన్నె మాన్ రొంబాడెంఙ్ ఇసా ఊరా యూదులె సావ్డిక్లెంఙ్ పెంప్రె మొరప్నెర్. అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్ ఔరుంఙ్ ఔరె కుల్కడ్ రొంబట్టిన్ ఎకా. ");
INSERT INTO nit_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","గని నీర్ సియెకద్ సియెంఙ, ఇన్నె వెంట తరుంఙ్ ఒర్కి ఎరెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","అనాయ్ నీర్ నాయ్ ఒర్కితోసెట సియెంఙ్. అపుడ్ ఎరుఙి ఒర్కితోసెట నీ కత్త పనిన్ ఓలుత్న ఇమ్మె బాంద్ ఇముంఙ్ కుల్కడ్ సియ్‍దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","మల్ల నీర్‍ పార్తన కలేఙ కప్టి మన్కకెర్‍ లంఙ్ తోద్ తనుంఙ్ ఇంతే ఔర్ మన్కకెర్ ఓలెంఙ్ ఇసా యూదులె సావ్డిక్లెంఙ్ అని బజల్లెంఙ్ టొఙ్ఙెల్‍ టేకిపుత్ పార్తన కాలేఙ్ ప్రేమ కాల్సర్. అన్ ఇముంఙ్ కరె ఇడ్సత్. ఔరుంఙ్ ఔరె కుల్కడ్ రొంబట్టిన్. ");
INSERT INTO nit_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","అనంఙ్ ఎరతె నీర్ నీర్ పార్తన కాలేఙ్ ఇమ్మె ఎల్లత కోలి లోప సెత్న కవాడ్ గెత్తుత్న మన్కకేరుంఙ్ కండ్కెర్సెట ఇమ్మె బానుంఙ్ పార్తన కలూర్. మల్ల మన్కకెరుంఙ్ ఒర్కి తోసెట నీర్ కత్త ఇమ్మె పనిక్లున్ ఓలుత్న ఇమ్మె బాంద్ ఇముంఙ్ కుల్కడ్ సియ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","అని నీర్ పార్తన కాలెఙ యూదులెర్సెటర్ కలెకదలాంఙ్ ఆగమి పెలె గొట్టిక్ ముడేకాద్ తోద్. తానుంఙ్ ఇంతె పేలె గొట్టిక్ ముడేఙ్ దెయ్యం ఔరేత్ విసాద్ ఇసా ఔరె విచార్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ఔర్లంఙ్ అనేంఙ్ తోద్. తానుంఙ్ ఇంతె నీర్ వేలెంఙ్ పేలె ఇముంఙ్ తనె పజె అదా ఇమ్మె బానుంఙ్ ఒర్కి అన్సా. ");
INSERT INTO nit_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","మల్ల నీర్ ఇనంఙ్ పార్తన కలుర్, పరలోకముత్ అనెకా అమ్మె దెయ్యం బాంద్, ఇన్నె పేర్ పవిత్రనాడ్ మాన్ ఎక్కాద్. ");
INSERT INTO nit_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ఇన్నె రాజ్యం కలెక వాకత్. పరలోకముత్ ఎరెకద్ లంఙ్ బూమిత్‍నాయ్ ఇన్నె మంతా ఎక్క. ");
INSERT INTO nit_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","అమ్మె రోజి తా నిపట్టెన్ ఇన్నెడ్ అముంఙ్ కో. ");
INSERT INTO nit_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","అముంఙ్ కర్జ ఎత్న మాప్ కలెకరున్ మాప్కల్ అమ్ సుక్కితమొ అనాయ్ అమ్మె పాపులుంనయ్ సుక్కిల్తం అమ్మెనయ్ సుక్కిప్ ");
INSERT INTO nit_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","అమున్ పరిక్సత్ రాలెంఙ్ ఇడ్నెమ్ గని దుస్మన్ తనట్ అమున్ సొడప్. తనుంఙ్ ఇనత్తి రాజ, సక్తి అని మాన్ ఎపుడి అనెకాది ఇనత్తి అన్సాద్ ఆమెన్. ");
INSERT INTO nit_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","మన్కకెరె గలతులున్ నీర్ మాప్కల్ కత్తిరింత్తె పరలొకముత్ అనెకా ఇమ్మె బాంద్ ఇమ్మె గలతులున్ మాప్ కల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","గని నీర్ మరొక్కొరున్ కర్జ మాప్ కల్సెటండె ఇమ్మె బాంద్ ఇమ్మెకత్తవున్ మాప్ కలెంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","కప్టిక్ ఉపాస్ కలెంఙ్ మంది ఓలెంఙ్ ఇసా తమ్మె మోకలున్‍ నారాజడ్ అప్‍దార్. నీర్ ఉపాస్ కలెంఙ ఇనంఙ్ కలుర్. ఇద్ సత్తెం, ఔరుంఙ్ పాజె అదున్ సుమ్‍త్తెర్. పేనా తనయ్ రొబాడెద్. ");
INSERT INTO nit_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","నీ ఉపాస్ అనేఙ ఉపాస్ మన్కకెరుంఙ్‍ కన్కెర్సెట ఇమ్మె మొకమ్ ఒడుత్న, తలుత్ నూనె దీటుర్. ");
INSERT INTO nit_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","అనంఙ్ కత్తిరింత్తె, నీర్ ఉపాస్ కలెకార్ లంఙ్ మందింఙ్ కండ్కెరెద్. గని కన్కెర్సెటా ఇమ్మె బానుంఙ్ మాత్రమ్ నీర్ ఉపాస్ సుమ్‍సార్ ఇసా ఒర్కి. అదుంఙ్ ఎత్తి కారేఓల్‍త్తె ఇమ్మె బాంద్ ఇముంఙ్ పలం సియ్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","నీర్ బూమిన్ పొయ్ ఇముంఙ్ సటీ సంపదాన్ మిరపూత్ ఇడెంఙ్ తోద్. ఇత్తి సెదా తినూత్ నుస్సి తిందా, అని డొంఙ వత్ కొస్సార్. ");
INSERT INTO nit_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","పరలోకముత్ ఇముంఙ్ సటీ సంపదాన్ ఇడుర్, అత్తి సెదాల్ తినెద్, నుస్సి తినెద్, డొంఙ్ కొసెర్. ");
INSERT INTO nit_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","తానుంఙ్ ఇంతె ఇమ్మె సంపదాన్ ఎత్తి అండె ఎప్పుడి ఇన్నె మన్ అత్తిని అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","కన్ సరిరుంఙ్ ఒక్కొ దీవేలంఙ్. ఇమ్మె కండ్లు సోయ్‍ అండె ఇమ్మె సరీర్ సిమ్కన వెలుంఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","గని ఇమ్మె కడ్లు సోయ్‍ తోసెట అండె ఇమ్మె సరీర్ పురా సిర్మన ఎరాద్. ఇమత్తి అనెకా వెలుంఙ్ సీకటి ఎద్దిన్‍ ఇంతె ఆ సీకటి ఎంత్ అరివరెకాద్లాంఙ్ అన్సాద్ తొదా. ");
INSERT INTO nit_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","ఒక్కొంది గడియక్ ఇద్దర్ మాల్కకెరె పని కలెంఙ్ సాలెంద్. అనంఙ్ కత్తె అముదు ఒక్కొనున్ ప్రేమ్‌ కద్దాంద్ పెనొక్కొనున్ ప్రేమ్ కలెంద్. తోదింతె ఒక్కొనె పనిన్ నమిప్దాంద్ అని, ఇంక్కొకొనున్ నమిప్సెటందాన్. నీర్ దెయ్యముంఙ్‍, అని పైసెలుంఙ్ సెవాకల్సాత్ ఇన్నెకద్ సోయ్‍ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","అదుంఙ్ ఎత్తి అన్ ఇడ్డెకద్‍ తానెద్ ఇంత్తె, ఇమ్మె పానం తినెకదున్‍ బదోల్ ఎక్కద్, ఇమ్మె సరిరుంఙ్ తొడెకా జుఙ్ఙెలున్ బదోల్ ఎక్కద్ విచార్ కన్నెర్. అంబలుంఙ్ ఎన కిమ్మతాద్ పానం, జుఙ్ఙెలున్ ఎన, కిమ్మతా సరీర్ ఎరెవా! ");
INSERT INTO nit_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ఆబార్‍ పొయ్‍ తులెకా పిట్టలున్ ఓలుర్. అదా వితనం విత్తుత్న పంటన్ పండిపె. దానెలున్ గుమ్మిత్ వాఙుత్ ఇడే. గని అదవుఙెన ఎన పరలొకముత్ అనెకా ఇమ్మె బాంద్ అదవ్లుంఙ్ తినెంఙ్ సియ్సాద్. నీర్ అదవుంఙ్ ఎన కిమ్మతార్ ఎరెరా! ");
INSERT INTO nit_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","విచార్ కల్సా తన్నె బత్కెకదున్ ఒక్కొజామ్‍ సర్కిపెంఙ్ సాలేకంద్ ఇమ్మతి ఎదెనా అన్సాద్? ");
INSERT INTO nit_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","అనాయ్ నీర్ జుఙ్ఙెలున్ బదోల్ తనుంఙ్ విచార్ కల్సాతిర్? గడ్డిత్ పూయెకా పూతలున్ ఓలుర్. అదా పనికత్న నారపెండె, ");
INSERT INTO nit_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ఎన, అన్ ఇడ్డెకాద్, తన సొబా సిమ్కనాత్ తానెద్ ఇంతె సొలొమోన్ రాజక్నె మాగ్త సమాన్ ఎన ఈ పూతలుంఙ్ బరాబర్ తోతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ఇనెడ్ ఇడూత్ వెగేడ్ కిసుత్ జొపిడెకా ఈ గడ్డి దెయ్యం అంతె సోయ్‍ ఓల్‍త్తె ఇమున్ ఇంకా ఎత్తె సోయ్ ఓల్‍దంద్ ఎరా! ఇముంఙ్ ఉసుటినాయ్ విస్వాసం తొతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","తనెన్ తిందుమ్? తనెన్ ఉందతుమ్? తనెన్ తొడ్‍దుమ్? ఇసా విచార్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","దెయ్యమున్ ఒర్కిల్సెటా మంది ఏకుని అదవున్ వెంట తూల్సార్. పరలొకముత్ అనెకా ఇమ్మె బానుంఙ్ ఇదాసదర్ ఇముంఙ్ పాజె ఇసా ఎర్కయ్. ");
INSERT INTO nit_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","గని పేలె అమ్నె రాజ్యం కలెక అని నీతిన్ సటీ జట్టిలూర్; అపుడ్ అదా సిమ్కన దెయ్యం ఇముంఙ్ సియాద్. ");
INSERT INTO nit_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","వేగెడీతదున్ బదోల్ విచార్ కన్నెర్. వేగెడీతద్ వేగెడి. ఏ జీర్తదుంఙ్ ఆజిరి తక్లిబ్ ఆజిరి ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","మారొక్కొరెత్ న్యాయ్ కలెంఙ్ తోద్. మల్ల దెయ్యంనయ్‍ ఇనుంఙ్ నయ్ న్యాయ్ కలెద్. ");
INSERT INTO nit_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","తానుంఙ్ ఇంతె ఎనంఙ్ నీర్ మారొక్కొనె న్యాయ్ కల్సతిర్ అనాయ్ దెయ్యం నాయ్ ఇమున్ న్యాయ్ కల్సాద్ ");
INSERT INTO nit_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ఇన్నె కన్నుత్ అనెకా దులె ఓల్‍సెటా ఇన్నె పక్కత దాదక్నె కన్‍త కిస్కటమున్ తనుంఙ్‍ ఓల్‍సతివ్? ");
INSERT INTO nit_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ఇనె కన్నుత్ దులె ఇడుత్న ఇన్నె దాదక్నె కన్త కిస్కటమూన్ పుస్‍గలీసతివా? ");
INSERT INTO nit_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","కప్టినివా పేలె ఇన్నె కన్నత దులెన్ పుస్‍, అప్పుడ్ ఇన్నె దాదక్నె కిస్కటమున్ పుసెంఙ్ అద్‍ ఇనుంఙ్ సోయ్‍ కండ్కెరాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","పవిత్ర తదిసా ఆతెలుంఙ్ ఇడ్నెర్. ఇమ్మె ముత్యాలు తుర్రెలె ముండట్ జొపిడ్‍నెర్. అనంఙ్ కత్తే అదా అదవున్ గెట్టాలడ్ విద్గుత్. మల్ల ఇమ్మున్‍ పొయ్ రాలుత్న ఇమ్మున్ సిరిప్సవొ యెనఙొ. ");
INSERT INTO nit_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","వేలుర్ ఇముంఙ్ సియెకాద్ ఎరాద్. కిరవుర్, ఇముంఙ్ రొంబాడద్. కుడుకుర్ ఇముంఙ్ గుయున్ పుసెకద్ ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","వేలెక ప్రతి ఒక్కొనుంఙ్ రొంబాడద్. కిరవేకనుంఙ్ రొంబాడద్. కుడుకెకానుంఙ్ గుయున్ పుసాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ఇమత్తి ఎరేనా, ఇమ్మె పోరక్ నిపట్టెన్ వేల్తే గుండ్లున్ సియతిరా? ");
INSERT INTO nit_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","తోద్తె అముదు కయ్యెన్ వేలెఙ పామున్‍ సియతిరా? ");
INSERT INTO nit_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","నీర్ కరాబు ఎద్దెనా ఇమ్మె పోరకెరుంఙ్ సొయాతవున్ సియెంఙ ఇనెకాద ఒర్కియ్ తా! అనంఙ్ ఎదే పరలోకముత్ అనెక ఇమ్మె బాన్ తన్ వేలెకానుంఙ్ అమ్నుంఙ్ ఎన సొయ్తా తప్పతోసెటా సియ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","అదుంఙ్‍ ఎత్తి మన్కకెర్ ఇమున్ తాగలెంఙ్ ఇసా నీర్ కోర్సారొ అనాయ్ నీర్ ఔరున్ అనాయ్ ఇదరూర్. నియమ్ సాస్త్రమ్త, ప్రవక్తక్నె సందేస్ ఇద్ది. ");
INSERT INTO nit_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","సంకొడి పావడ్ ఆడుగుర్‍. నాస్‍వై సెరేకా దార్వొజా వెల్పు, పావ్ దవాడత్తి. అత్తి పెరెత్ మంది సెరెంఙ్ సాల్సర్. ");
INSERT INTO nit_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ఎపుడి అనెక పానం సంకొడి అన్సాద్ ఆ పావడ్‍ సెరెకర్‍ మంది కొన్సెమి ");
INSERT INTO nit_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","పైలి కబుర్లకెర్ బదోల్ ఉసారడ్‍ అండ్రు. ఔరు వాక గొర్రెనె తోల్ పొర్కుత్ లోపా లండిగక్లంఙ్ ఇమున్‍వై వద్దర్. గని మన్‍లోపా కపట్ లాండిగకె. ");
INSERT INTO nit_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ఔరె పనికున్‍ వాలడ్ ఔరున్ ఒర్కిలెంఙ్ వంద్. సాల్ల తుట్టి అంగుల్ కయ్యె గని పల్లెరు సెట్ మెడి పండ్లున్ పుద్సారా? ");
INSERT INTO nit_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","అనాయ్ ప్రతి ఒక్కొ సోయ్త మాక్ సోయ్తది పండ్లు కైద. పనింఙ్ పడ్సెట మాక్ పనింఙ్ పడ్సెట పండ్లు కైసాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","సోయ్త మాక్ సోయ్త పండ్లు కైసాద్. మాక్ పనింఙ్ వర్సెట సోయ్త పడ్ కయ్యెద్. ");
INSERT INTO nit_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","సోయ్త పండ్లు కైసెటా ప్రతి ఒక్కొ మాక్ పనింఙ్ వర్సెట కత్కుత్ కిసుత్ తప్పుర్, ");
INSERT INTO nit_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","అదుఙి ఇనంఙ్ నీర్ ఔరె పలమున్ వాలడ్ ఔరున్ ఒర్కిల్‍ సాతిర్, విస్వాస్ తోసెటా మూతిత గొట్టిక్ వాలడ్ లాబం తోతెద్ ");
INSERT INTO nit_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ప్రబు, ప్రబూ, ఇసా అన్ కుగెకర్‍ సిమనమంది పరలోకముంఙ్ చేరెర్‍. గని పరలోకముత్ అనెక అన్నె బానే మన్నాడ్ కలెకాంది సెద్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ఆ దినముంఙ్ జీర్ గుల్‍మంది, ప్రబూ, ప్రబు, అమ్ ఇన్నె గొట్టికున్ ఇడ్డెతాన్? ఇన్నె పేరడ్‍ బూతులున్ ఎదగెతన? ఇన్నె గుల్ సమత్కాల్ కలెతన్? ఇసార్. ");
INSERT INTO nit_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","అపుడ్ అన్, కరాబ్ పనిక్లకేర్, నీర్‍ ఎరొ అనుంఙ్ ఒర్కితొద్. అంతనట్ కురియుత్ సెర్ ఇసాత్. ");
INSERT INTO nit_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","అదుంఙ్ ఎత్తి ఇద అన్నె గొట్టికున్ విత్న అనాయ్ బత్కెకర్ గుండ్ జాగత్ ఎల్ల కట్‍తా ఉసార్‍లంఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","వాన వత్తెన బూరం వాత్తెన, సురగాలి ఆ ఎల్ల పొయ్ వత్ తాక్తిన్ ఎన ఆ బునజి గుండ్ పొయ్ కట్తెర్ అదుంఙ్ ఎత్తి అద్ రాలెతిన్. ");
INSERT INTO nit_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","అన్నె ఈ గొట్టికున్ విత్న అనాయ్ అడుగ్సెటాంద్ ప్రతి ఒక్కొంద్ ఉసుకా పొయ్ తన్నె ఎల్ల కట్‍తా తెలివి తోచెటాంద్‍ లాఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","వాన వత్ బూరం వాత్తె. గాలి దుదడ్ ఆ ఎల్లన్ తాక్తె. అద్ ఓద్రిల్తిన్. అద్ గుల్ అరివనెత్తి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","అపుడ్ యేసుంద్ ఈ గొట్టిక్ ఇడుత్ మోడిల్తత్తి మంది అమ్నె బొదన్ కమాల్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","తానుంఙ్ ఇంతె అముదు ఔరె నియమ్ సాస్త్ర గురున్లాఙ్ ఎరెకాడి అదికార్ లాంఙ్ ఔరుంఙ్ బొదా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","అముదు మెట్పొలడ్ డిగుత్ వరెఙ, డేగ్గు డేగ్గు మన్కకెరె గర్ది అమ్నున్‍వై వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","పెర్‍దుకమ్ ఒక్కొద్ అమ్నున్‍వై వత్న, అమ్నున్ మొక్కుత్ ఇంతెంద్. ప్రబు, ఇనుంఙ్ మన్న అండినింతె, అన్ సోయ్‍ కలెంఙ్ సాలతివ. ");
INSERT INTO nit_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","యేసుంద్ కెయ్య సాపుత్న పుడ్‍క్తెంద్ అని ఇంతెంద్. “అనుంఙ్ మన్ అన్సాద్ నీ సోయ్ ఎర్” వెంటాయ్ అముదు తన్నె పెర్‍దుకమ్ తన్న సోయ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","మల్ల యేసుంద్ అమ్నున్ ఇంతెంద్. ఏరుఙి ఇదున్‍ బదోల్ తానయ్ ఇడ్నెమ్. గని సె అని దెయ్యలకుంఙ్ ఇన్నె సాక్సం ఓలిపుత్న మోసేనె నేకినడ్‍ ఎద్ అన్ సియెకాద్ అన్సాద్ అదున్ పురవ ఇంత్న సియ్. ");
INSERT INTO nit_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","యేసుంద్ కపర్నహూమ్ ఊరుఙ్ సెరెంఙ, ఒక్కొంద్ నూర్‍ సైనిక్లె దొడంద్ అమ్నున్‍వై వాత్న, ");
INSERT INTO nit_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","యేసుకున్ వింత్తి కతెంద్. ప్రబు, అన్నె గడియాక్ ఎల్లత్ దుక్కమడ్ తెరుత్ మడీయుత్ అన్సాద్. అముదు సులెంసల్సెటా గుల్లెనా పరిసానడ్ అన్సదిసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","యేసుంద్ ఇంతెంద్ అన్ వత్న అమ్నున్ సోయ్‍ కల్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","గని రోమా సైనిక్లె దొడంద్ ఇంతెంద్. ప్రబునీ అన్నె ఎల్లంఙ్ వరెంఙ్ తోతెన్. గని ఒక్కొ గొట్టి మాత్రం ఇడ్ అన్నె గడియాక్ సోయ్ ఎర్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","తానుంఙ్ ఇంతె అనుంఙ్ దండి అదికార్ అన్సార్ ఎన అనుంఙ్ బుడునయ్ సైనిక్ అంసార్. అన్ ఒక్కొనుంన్ సె ఇన్నెంఙ, అముదు సెసాద్. మరొక్కొనున్ వా ఇన్నెంఙ అముదు వర్సద్ అని గడియకున్ ఇదున్ కల్ ఇంతె అముదు కల్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","యేసుంద్‍ అమ్నెతున్ వింత్నకమల్ కత్తెంద్ అని పవడ్ అంమమ్నున్ వెంట వత్తరున్ ఇంతెంద్. కరెయ్ “అన్ ఇముంఙ్ ఇడ్డత్ ఇస్రాయేల్ మందిన్ లోప నయ్ ఇట దండి విస్వాసున్ ఓలెతన్” ");
INSERT INTO nit_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","అన్ ఇముంఙ్ కారె ఇడ్‍సాత్. పెలెటర్ మర్‍జతి మన్కకెర్ పొద్ కురినా పకతర్ అని పొద్ ఉర్కున వాలర్ వత్న పరలోక రాజ్యం కలెక లోప అబ్రాహామ్, ఇస్సాక్నె అని యాకోబ్‍ వెంట తినెంఙ్ ఉద్సార్. ");
INSERT INTO nit_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","గని రాజ్యం కలెక వారిసులున్ మత్రం వాక సిర్మనత్ జొపిడెకద్ ఎరద్. అత్తి మన్కకెర్ అర్దర్ అని పల్కూ కొర్‍క్దర్. ");
INSERT INTO nit_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","మల్ల యేసుంద్ రోమా సైనిక్లె దొడనున్ ఇంతెంద్. ఎల్లంఙ్‍ సె అన్పొయ్ ఇనుంఙ్ అనెక్ బరొసనాడ్ ఇనంఙ్ ఎరద్. అమ్నె గడియాక్ అద్ది వెలంఙ్ సోయ్ ఎదెద్. ");
INSERT INTO nit_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","మల్ల యేసుంద్ పేతురునె ఎల్లంఙ్‍ సెద్దెంద్ అని వెసానడ్ అనెకఅమ్నె పొదలున్ ఓల్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","యేసుంద్ అద్నె కెయ్యున్‍ పుడ్కతెంద్ తె అద్నెవెస్ససాయ్తిన్. అని అద్ సులుత్ ఔర్ సేవ కలెంఙ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","సింతె వేల పెలెటర్ బూతు అట్త మన్కకెరున్ అమ్నున్వై తోడ వత్తెర్. అముదు ఒక్కొది గొటినడ్ బుతులుంన్ ఎద్గతెంద్ అని సదరి దుకలకెరున్ సోయ్‍ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ప్రవక్త ఇడ్డెక యెసయక్ ఇడ్తగొట్టిక్ కరే ఎరెంఙ్ ఇత్న ఇద ఎద్దె. “అముదు నేండె దుక్కలున్ సోయ్ కత్తెంద్ అని నేండె రొగులున్ అముదు కుంన్తెంద్.” ");
INSERT INTO nit_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","యేసుంద్ అమ్నున్ తిర్‍గొర్ అనెకరున్ ఓలుత్న పేనిత అల డర్డింఙ్ సెరెకదుంఙ్ అంమ్నె సిసులున్ ఉక్కుమ్ సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","అపుడ్ ఒక్కొ సాస్త్రి మన్కక్ వాత్న అమ్నున్ ఇంతెంద్, గురుజి నీ ఎదె సెరతి అదెని వర్సత్. ");
INSERT INTO nit_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","గని యేసుంద్ ఇంతెంద్. కొయ్లక్ డఙెఙ కడ్ల అన్సా అని ఆబార్ తా పిట్టలుంఙ్ తుప్ప అన్సా గని మన్కనె పోరక్ తల్లున్‍ ఇడెంఙ్ జాగ తొతెద్ ");
INSERT INTO nit_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","మరొక్కొ సిసుంద్‍ అమ్నున్ ఇంతెంద్. ప్రబు, పేలె అన్నే సెతన్ అన్నె బానున్ పుర్‍పెంఙ్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","గని యేసుంద్ అమ్నున్ ఇంతెంద్. అన్ వెంట వా. ఆత్మ లోప తిక్తరున్ పుర్‍పెంఙ్ తిక్తార్ అన్సార్ ఇసా ఇంతేంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","యేసుంద్ ఆ రూకుత్ ఉద్తెంద్. అంమ్నె సిసు అమ్నున్ వెంట రూకుత్ ఉద్తెర్ మల్ల ఔర్ సమ్దురుత్ సెరెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","అపుడ్ దండి సురగాలి సముద్రత్ వత్తిన్ అని ఆలావ రూకుత్ తాక్తె గని యేసుంద్ మంఙ్ సాని అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","సిసూ అమ్నున్‍వై సెత్న అమ్నున్ సుల్పతెర్ అని ఇంతెర్ “ప్రబు” అముంన్ బత్కిప్ నేండ్‍ సదర్‍ మంది సముద్రత్ ముల్ఙగంసా నంసాతుమ్, ");
INSERT INTO nit_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","మల్ల అముదు ఔరున్ ఇంతెంద్, ఉసుటినాయ్ విస్వాసం కొన్సెం అనెకర్ నీర్ తనుంఙ్ అర్సాతీర్? మల్ల అముదు సుల్తెంద్ అని గాలీన్ అని దుందాడున్ దట్టిప్తెంద్ అని సిమ్కన సుయ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","మన్కకెర్ కమాల్ కత్తెర్ అని ఇంతెర్ ఇమ్‌దు ఎంటదొ? గాలి అని దుందడ్ ఇమ్నెతున్ విసా. ");
INSERT INTO nit_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","గదరేనీయ దేసెముత్ ఆలా డర్డింఙ్ యేసుంద్ వత్తెందింతె, తప్నె తనట్ వత్తర్ ఇద్దర్ బూతు సుంత మన్కకెర్ అమ్నుంఙ్ బేటి ఎద్దేర్ ఔర్ గుల్లెన రగ్టకెర్ అండెర్, ఆ పావడ్ ఎరి సెరెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ఔర్ వపొయుత్ ఇంతెర్, ఏ దెయ్యమ్నె పోరక్! అన్నతి ఇన్నెత్ తనెద్ అన్సాద్? వేల వరెంఙ్ పేలెయ్ అనుంఙ్ తక్లిబ్ సియెంఙ్ వత్తివా? ");
INSERT INTO nit_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ఔరుంఙ్ మెర తుర్రెలె గూల్ దండి మంద మెయ్సనంద్. ");
INSERT INTO nit_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ఆ బూతు యేసునున్ వింతి కత్తె అమున్ ఎద్గసాతి ఎర తె, ఆ తుర్రెలె మందత్ అమున్ పన్కు. ");
INSERT INTO nit_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","మల్ల అముదు అదవ్లున్ సెర్ ఇతెంద్. మల్ల అద బూతు కురియ్తె అని తుర్రెలె సొంఙ్ తె. ఆ మందత తుర్రె సిమ్కన డుబ్లె తన తూల్‍ వత్ సందూర్ లోప ఉర్కూత్ తిక్తె. ");
INSERT INTO nit_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","తుర్రె మెపెకర్ తుటెర్ అని ఊరుఙ్ లోప సెత్ సిమన్ గొట్టికున్ అని బూతు సుమ్త మన్కకెరున్ జర్గిల్తదున్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","మల్ల సిమన్ ఊరార్ యేసునున్ ఓలెంఙ్ కురియుత్ వత్తేర్. ఔర్ అమ్నున్ ఓలుత్న ఔరె బార్సాంఙ్ తనట్ కుర్యుత్ సెరెంఙ్ ఇసా అమ్నున్ వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","మల్ల యేసుంద్ తన్నె సిసులున్ వెంట రూకుత్ సొకుత్న పెన ఇల డర్డింఙ్ తన్నె సొత పట్నముంఙ్ మలయుత్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","కొన్సెం మంది మన్కకెర్ ఒక్కొద్ తెరుత్ అనెక్ కుంటిన్ తొడవాతెర్. యేసుంద్ అమ్నున్ సోయ్ కలెంఙ్ సాల్సద్ ఇసా ఔరె విస్వాసమున్ ఓలుత్న ఇంతెంద్ ఇమ్మత్ సుముర్, అన్నె పాప్ ఇదర్తదుఙ్ ఇన్నె కర్జ ఎరత్ మాప్కల్ ఇదర్తదుఙ్ కడిల్తె. ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","కొన్సెం మంది నియం సాస్త్ర గురు మన్కకెర్ ఔరెత్ అవ్రి ఇన్నెర్ అముదు దెయ్యందుతునె బద్నం కల్‍సా నంసద్. ");
INSERT INTO nit_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","యేసుంద్ ఔరె విసరున్ ఒర్కిలుత్న ఇతెంద్ “తనుంఙ్ ఇంమ్మె మన్నుత్ కరాబ్ విచార్ కల్సతి రె? ");
INSERT INTO nit_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ఎద్ద సస్తె అన్సాద్? ఇన్నె పాప్ ఇదర్తదుఙ్ మాప్కల్ ఇదర్తదుఙ్ కాడిల్ తె ఇన్నెకద్ మరి సుల్ అడగ్ ఇన్నెకదె? ");
INSERT INTO nit_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","గని ఇముంఙ్ ఓరకి ఎరెంఙ్ ఇసా పాప్ ఇదర్తదుఙ్ బూమిపొలా మాప్కల్ ఇదర్తదుఙ్ కడిపెంఙ్ మన్కనె పోరక్ అదికార్ అన్సాద్. మల్ల అముదు లెండకున్ ఇంతెంద్. సుల్ ఇన్నె తెరుత్ పెతుత్న ఎల్లంఙ్ సె” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ఆ మన్కక్ సుల్తెంద్ అని ఎల్లంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","మన్కకెరె గార్ది అమ్నున్ ఓలుత్న అర్సతెంద్ కాంతెర్ అని అమన్కకెరుంఙ్ ఇంట అదికార్ సియత దెయ్యముంఙ్ స్తుతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","యేసుంద్ అత్రనట్ కురియుత్ సెరెంఙ, నాక జగత్ ఉద్దుత్ అనెక మత్తయ్యకున్ ఓల్తెంద్ యేసుంద్ అమ్నున్ ఇంతెంద్. అన్న వెంట వా అని మత్తయ్యక్ సుల్తెంద్ అని యేసుకున్ వెంట సెదెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","మల్ల యేసుంద్, మత్తయ్‍నె ఎల్లత్ జెవున్ తినెంఙ్‍, పెలెటర్ అప్త వసూల్ కలెకార్నాయ్ అని పాప్ మన్కకెర్ వత్న యేసుంద్ అని అమ్నె సిసులుంన్ వెంట తినెంఙ్ ఉద్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","పరుసి ఇదున్ ఓలుత్న అంమ్నె సిసులంత్తి వెలుత్ ఓల్తర్. తనుంఙ్ ఇమ్మె గురుజి అప్త వసూల్ కలెకార్నాయ్, పాప్ మన్కకెర్ వెంట తిన్నెంద్? ఇసా వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","యేసుంద్ ఆ గొట్టిన్ వింత్న ఇంతెంద్. సుకామడ్ అనెకనుంఙ్ మందులక్ అవ్సరం తోద్ గని దుక్కం అనెక్ మన్కంఙ్ మదులక్ అవ్సరం. ఇసా ఔరుఙ్ సమాదనం ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","సాస్త్ర నెత్ ఈ గొట్ట్టిన్ కరిపుర్ అన్ పాపులె పచ్చతాపలున్ కూగెంఙ్ వత్తన్, తానుంఙ్ ఇంతె అనుంఙ్ బావ్ లగ్గెద్ గని అన్ నీతి అనెకరుంఙ్ తోద్ గని గరిబులుంఙ్ అని కివ్ ఓలిపెంఙ్ మన్కకెరుంఙ్ కూగెంఙ్ వత్సతున్. ");
INSERT INTO nit_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","మల్ల బాప్తిస్మ సియెక యోహాన్నె సిసు వత్న యేసునున్ వెల్ నెర్. అమ్ అని పరుసియు ఉపాస్ కల్స నంసాతుమ్ గని తనుంఙ్ ఇనె సిసు ఉపాస్ సుమెతెర్? ");
INSERT INTO nit_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","యేసుంద్ ఔరున్ ఇతెంద్. నొవ్రక్ ఔర్ వెంట అన్నంతేంఙ్ పెండ్లి వత్త సుట్ట ఉపాస్ అనేర్? గని నొవ్రకున్ ఔర్‍వత్న పుసుత్ కొసెక దినం వత్తిన్. మల్ల ఔర్ ఉపాస్ సుమ్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","పాత జుఙ్ఙె ఇరియ్‍తత్తి ఎంది కొత్త జుఙ్ఙెనె తుక్డెన్ కుట్టెర్. తానుంఙ్ ఇంతె పాత జుఙ్ఙెత్ కుట్తె కొత్త జుఙ్ఙె దండి బొగ్గ కల్సద్. ");
INSERT INTO nit_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","అనాయ్ కొత్త అగుంర్నె రసాన్ పాత తోల్నె తైలిత్ వాఙెర్ వాఙ్తెరింతె, కొత్త రసత తోల్నె తైలి ఇరిసాద్ అని రస కుల్సద్. అని సంసి కరాబ్ ఎర్సద్. గని కొత్త అగుర్ రస్సన్ కొత్త దుట్టిత్ వగ్సర్. ");
INSERT INTO nit_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","యేసుంద్ ఈ గొట్టిక్ ఇడ్డెఙ, ఒక్కొంద్ యూదులె గురు వత్న అమ్నున్ ముదర్వై మొక్స ఇంతెంద్. అన్నె పిల్ల పఙ్ఙిని తిక్తిన్. గని నీ వత్న అదున్ బత్కింతివింతె అద్‍ పెన్న పానమ్ ఎర్సద్. ");
INSERT INTO nit_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","మల్ల యేసుంద్ సుల్తెంద్ అని అమ్నున్ వెంట సెద్దెంద్. అమ్నె సిసునాయ్ అమ్నున్ వెంట సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","అపుడి బార సాల్కుతనట్‍ మాల దుక్కమడ్ అనెక్ పిల్ల అమ్నున్ వెన్కవాలడ్ వత్న యేసునె జుఙ్ఙె డఙ్ఙున్ పుడ్కతిన్. ");
INSERT INTO nit_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","తానుంఙ్ ఇంతె అద్‍ అద్నె మనుత్ ఇంతిన్. అన్ అమ్నె జుఙ్ఙెన్ పుడక్తనింతె, అన్ సోయ్ ఎరత్ ఇసా తనేత్ తాని ఇత్న, అమ్నె జుఙ్ఙెనె మూలన్ తాక్తిన్, ");
INSERT INTO nit_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","యేసుంద్ తిరుగుత్ ఓలుత్ ఇతెంద్ ఇమ్మత్ సుమ్, బాయి, ఇన్నె విస్వాసడ్ నీ సోయ్ ఎద్ది. అపుడ్‍తద్ అపుడి ఆ పిల్ల సొయ్‍ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","యేసుంద్ గురునె ఎల్లంఙ్ వతెంద్ అని తిక్తనుంఙ్ మొరపెకరున్ అని లొల్లి ఆర్రెకరున్ ఓల్ తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","అముదు ఇంతెంద్ కురియుర్. కారన్ ఈ కొమ్మ తికెతిన్. అద్ మంగుత్ అన్సాద్. గని ఔర్ అమ్నున్ కయింఙ్ తేర్. ");
INSERT INTO nit_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","మల్ల మన్కకెరె గర్దిన్ వక పుస్తెంద్ అని యేసుంద్ అదున్ ఇట్ట జాగంఙ్ సెదెంద్ అని కొమ్మాలె కెయ్యున్ సుమ్తెంద్ తె, ఆ కొమ్మాసుల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","అని ఈ కాబుర్ అత్త జాగ లత్తి నెరయ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","యేసుంద్ అత్రనట్ కురియుత్ అడ్సా సెరెంఙ్‍, ఇదర్ గుండిక్ వపొయ్‍సా అమ్నున్ వెన్కవై వాతెర్ దావిద్నె పోర నీ, అమున్ పొయ్ కివ్ కాల్. ");
INSERT INTO nit_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","యేసునె ఎల్ల లోప సెదత్తి ఔర్ గుడ్డిక్ అమ్నున్‍వై వత్తెర్. అముదు ఔరున్ ఇంతెంద్: అన్ ఇమున్ సోయ్ కలెంఙ్ సాల్‍సాత్ ఇసా నీర్ బరొస ఇడతిర? ఔర్ ఇంతెర్. అయ్ ప్రబు, ");
INSERT INTO nit_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","మల్ల అముదు ఔరె కడ్లున్ పుడుకుత్న ఇంతెంద్ ఇన్నె విస్వాసమడ్ నీ సోయ్ ఎర్. ");
INSERT INTO nit_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","అని ఔరుంఙ్ నదుర్ వాతిన్. యేసుంద్ ఔరున్ అర్పులిపుత్ ఇన్తెంద్ ఇదున్ బదోల్ ఎరుంగి ఇడ్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","గని ఔర్ కురియ్‍తెర్ అని యేసుకున్ బదోల్‍ తా గొట్టికున్ అల్ల సదర్ జాగలెంఙ్ నెర్‍ప్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ఔర్ అత్రనట్ కురియుంత్ సెరెంఙ్‍, కొంచెం మంది మన్కకెర్ ఒక్కొ మన్కన్ ముకా దెయ్యమ్ యేసొన్వై కొత్తెర్. తానుంఙ్ ఇంతె అముదు బూత్ అంట్‍త మన్కక్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","అముదు ఆ బూతులున్ ఎద్గతత్తి, ఆ మూకక్ ముడెంఙ్ ఎదెంద్. మంది సింకన్ కామల్ కత్న ఇతెర్. ఇస్రాయేల్‍ దేసుత్ ఇట గొట్టికున్ ఎపుడి వినెతం ఇసా ఇంతెర్ ");
INSERT INTO nit_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","గని పరుసి గురు మన్కకెర్ ఇతెర్. ఇమ్‌ద బూతులె దొడద్ మదతడ్ బూతులున్ ఎద్గసా నంసాద్. ");
INSERT INTO nit_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","యేసుంద్ సదర్ యూదులె సావ్డిక్లెంఙ్ అని సదర్ పట్నలెంఙ్ రాజ్యం కలెక సోయ్త గొట్టిక్ కరప్సాంద్ ఇడ్డుర్ రంఙ్ రంఙ్త తక్లిబు, దుక్కం తరున్ సోయ్ కన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","మన్కకెరె గార్దిన్ ఓలుత్న అమ్నుంఙ్ కివ్ వాద్. తానుంఙ్ ఇంతె ఔర్ నెర్ జడ్ ఎద్ద మన్కకెర్, మదత్ కాల్‍సెటర్ లంఙ్ కన్నెర్. మంజె, గాయ్కి తోసెట్ గొర్రెలంక్ లాంఙ్ అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","మల్ల అముదు తన్నె సిసులున్ ఇంతెంద్ పంట పెరెత్ అన్సాద్ గని పని కలెకర్ కొన్సెంమంది అసార్. ");
INSERT INTO nit_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","అదుంఙ్‍ ఎత్తి పంటనె మాల్కక్ తన్నె పంటన్ అర్కెంఙ్ ఇసా పని కలెకరున్ పాన్కెంఙ్ ఇసా పార్తన కలుర్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","యేసుంద్ పన్నెండు మంది సిసులుంన్ అమ్నున్వై కూగ్తెంద్ అని ఔరున్ కరబ్ ఆత్మా ఎద్గెకా అదికార్ సియ్‍తెంద్ అని సదర్ రొగుల బేమరికున్ సోయ్ కలెకా అదికరం సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ఇద్ద ఎన్నె ఔర్ పన్నెండు మంది అపొస్తులున్ సిసులె పేర్ ఇవ్రు ప్రెసిత్ ఇనెక సిసులెంనెర్. పెలెనితద్ సీమోన్ ఇనెకా పేతురు ఇసార్ అని అమ్నె తోరెంద్ అంద్రెయక్, జెబెదయి క్నె పోరకేర్ యాకోబ్‍ అని అమ్నె తొరెంద్ యోహాన్ ");
INSERT INTO nit_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","పిలిప్‍, బర్తొలొమయి, తోమక్ అని అప్త వసూల్ కలెకార్నాయ్ మత్తయ్యక్ అని అల్పయినె పోరక్ యాకోబ్, తద్దయి, ");
INSERT INTO nit_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","సీమోన్ కనానీయక్ అని యేసుకున్ సుముంత్ సియెక ఇస్కరియోత్ యూదక్. ");
INSERT INTO nit_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","యేసుంద్ పన్నెండు మందిన్ కూగుత్న ఔరున్ ఇంతెంద్. నీర్‍ యూదులెర్సెట ప్రాతలెంఙ్‍ సెనెర్‍. సమరయ అనెక ప్రాతం తనట్ ఏ పట్నముంఙ్‍ సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","గని దవ్డిల్త గొర్రెలంఙ్ ఆనెక ఇస్రాయేల్‍ మన్కకెర్వై సెర్. ");
INSERT INTO nit_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","నీర్ సెరెంఙ, ఈ గొట్టికున్ ఇడ్డుర్. పరలోక రాజ్యం కలెక మేర వత్తిన్. ఇసా ఔరుగ్ ఇడ్డుర్. ");
INSERT INTO nit_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","కుస్టి దుక్కలకెరున్ సోయ్ కలుర్, తిక్తరున్ సుల్‍పుర్, పెర్ దుకమ్ తనుంన్ సోయ్ కలుర్, బూతులున్ ఎద్గుర్. ఇనాయ్ ఇముంఙ్ రొబ్బట్టిన్ ఇనాయ్ సియుర్. ");
INSERT INTO nit_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ముల్కెత్, బఙ్ఙర్నె, అని వెండినెవ్ తోద్‍తె పితుడ్నె బందికున్ కొస్నెర్, ");
INSERT INTO nit_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ఇమ్మె సెరెకదుంఙ్ సటీ ఒక్కొ జుఙ్ఙె తైలి అని ఇంది జాగ్గె, కెర్రిక్, కోలా ఇదవ్ ఎరెకడ్ తనెని తోడ సెనెర్. తానుంఙ్ ఇంతె పని కలెకనుంఙ్ పని కత్ సియెకనతనట్ కుల్కడ్ నక్కి రొంబడెంఙ్ పట్టిన్. ");
INSERT INTO nit_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","నీర్ ఎద్దేన పట్నముత్ తొదిన్తే ఊరుర్ సెరెకాపుడ్ అత్తి వేలుత్ ఒర్కిలుర్. అంతే తన సెన్నంతెం అన్నె ఎల్లత్ దొడంద్ లాఙ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ఆ ఎల్లంఙ్‍ సెసా ఎల్ల తరున్ సోయ్ ముడుర్. ");
INSERT INTO nit_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ఆ ఎల్ల సోయ్త ఎద్ద ఇమ్మె సాంతి అదుంఙ్ పొదె వర్సాద్. అత్తి యోగ్యత తొసేటంన్టె ఇమ్మె సాంతి ఇముంఙ్ మలయుత్ వర్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ఎరేనా ఇమున్ ముడ్‍సెటండె ఇమ్మె గొట్టికున్ విన్సేటండే నీర్ ఆ ఎల్లన్ ఎక్కద్ ఆ ఊరున్ ఎక్కద్, సాయుత్ సేరెగ ఇమ్మె గెట్టత దుర్రన్ జడిపుర్. ");
INSERT INTO nit_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","తిక్పెక దినముంఙ్ ఆ జాగ సుమ్మెకా గతి సొదొమ గొమొర్రా నగరాలత్తి న్యాయంలఙ్ అన్సాద్ ఇముంఙ్ కరెయ్ ఇడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","ఓలుర్ లండిగకె నడుమున్ గొర్రెలున్ పన్కతెత్తి అన్ ఇమున్ పన్కసాత్. అదుంఙ్ ఎత్తి పాములంఙ్ ఉసారడ్‍, పారెవలంఙ్ కపట్ తోసెటా అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","మన్కకె రత్తి ఉసారడ్ అండ్రు. ఔర్ ఇమున్ జేలుత్ తప్దర్ యూదులె న్యాయ్ కలెకర్వై సియ్‍దర్, ఔరె యూదులె సావ్డిక్లెంఙ్ మంది ఇమున్ సాట్లడ్‍ దనప్‍గదర్. ");
INSERT INTO nit_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ఔరుంఙ్ యూదులెర్సెటర్ సాక్సం అనుంఙ్ సటీ ఇమున్ అదిపత్తిక్‍వై రాజకున్వై కొద్దర్. మల్ల నీర్ సొయ్త కబుర్ ఇడ్సతీర్ ");
INSERT INTO nit_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ఔర్ ఇమున్ సియెంఙ, ఎనంఙ్ ముడెకాద్? ఇసా విచార్ కన్నెర్. నీర్ తనెద్ ఇండెకదొ అద్నే వెలన్ ఇముంఙ్ ఇడ్డద్. ");
INSERT INTO nit_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ముడెకార్ నీర్ తోద్, ఇమ్మె బానె ఆత్మ ఇమున్ లోపా అంత్ ముడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","దాదక్ దాదకున్, బాంద్ కీకెన్ అంల్గెంఙ్ సియ్‍దద్. పోరకేర్ అమ్మబనున్ పొయ్ సులుత్ ఔరున్ అల్ఙుగద్దార్. ");
INSERT INTO nit_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","అన్నె పేర్ వాలడ్ సిమ్కన మంది ఇమున్ విరోద్ కద్దర్. గని ఆక్రిదూక్ ఏర్ సాయిన్ కల్‍సారొ ఔరి బత్కదర్. ");
INSERT INTO nit_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ఔర్ ఈ పట్నముత్ ఇమున్ విరోద్ కత్తె మరొక్కొ పట్నముంఙ్ తులుర్. మన్కనె పోరక్ వంనంత్తెంఙ్ నీర్ ఇస్రాయేల్‍ పట్నలెంఙ్ సెత్నఅన్నెర్ ఇసా ఇముంఙ్ అన్ సత్తెం ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","గురునుంఙ్ ఎన సిసుద్ మాల్కకుంఙ్ ఎన గడియక్ దండిక్ తాన ఎరెర్. ");
INSERT INTO nit_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","సిసుంద్ తన్నె గురులంఙ్‍, గడియక్ తన్నె మాల్కక్ లంఙ్ అండె సోయ్. ఇంతె ఎల్లత మాల్కకున్ బయెల్జెబూలు ఇసా ఔరె పేర్ ఇట్టె అమ్నె ఎల్లతర్ ఎంత్తెయో ఇందర్ తా! ");
INSERT INTO nit_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","అదుంఙ్‍ ఎత్తి నీర్ మన్కకెరుంఙ్ అర్సనెర్. డపుత్ అనెకద్ తనెది ఒర్కితోసెటా అనెద్. డపుత్ ఇటద్ ఎద్ది రొబడసెటా అనెద్. ");
INSERT INTO nit_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ఇముంఙ్ అన్ సీకటిత్ ఇడ్డెకదున్ వెల్‍ఙుత్ ఇడుర్. ఇమ్మె కెవ్వులెంఙ్ విన్కవారెకద్ ఎల్ల పొయ్ ఇడుర్. ");
INSERT INTO nit_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ఆత్మన్ సరీర్ అలంసెట సెత్తన్ అలఙెకరుంఙ్ అర్సనెర్. గని న్యాయ్ సబా ఆత్మన్ సరీర్ నరకముత్ తప్పుత్ నాస్ కలెకనునీ దెయ్యముఙి అర్సుర్. ");
INSERT INTO nit_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ఇంది కొడ్కెపిట్ట ఒక్క చిన్నం పైసెఙ్ విరెకద్ ఎరద్ తా. ఎన ఇమ్మె బానె ఉక్కుమ్ సివయ్ అదాలోపా ఒక్కొద్నయ్ బూమిత్ రాలెద్. ");
INSERT INTO nit_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ఇమ్మె తల్త తిల్ ఎన్ని అసావొ అన్నీనాయ్ అమ్నుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","అదుంఙ్ ఎత్తి అర్సనెర్. నీర్ సిమ్కన కొడ్కెపిట్ట లుంఙ్ ఎన ఎంతెయొ కిమ్మతర్ ఎన్నిర్. ");
INSERT INTO nit_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","మన్కకెర్ ముండట్ అన్ ఒపెకనున్ పరలోకముత్ అనెక అన్నె బాన్ ముండట్ అన్ ఒప్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","మందిన్ ముండట్ ఎంద్ అన్ ఒర్కితొదిసాదొ అమ్నున్ పరలోకముత్ అనెక అన్నె బాన్ ముండట్ అనాయ్ ఒర్కిలెన్‍ ఇసాత్. ");
INSERT INTO nit_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","అన్ బూమిపొయ్ సాంతిన్ కొరెంఙ్ వత్తన్ ఇంన్నెర్. తల్వార్ కొరెంఙ్ వత్తన్ గని సాంతి తోతెంద్ ");
INSERT INTO nit_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ఇంతె ఒక్కొ మన్కంఙ్ అమ్నె బాన్ద, కీకెనాడ్ కొంమ్మ తన్నె అమ్మనాడ్, కొర్రా తన్నె పొదలడ్ గుల్ విరోద్ ఎర్‍గలెగి వత్తన్. ");
INSERT INTO nit_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ఒక్కొ మన్కకుంఙ్ ఏల్లతరి అంనుంఙ్ విరోద్ ఇల్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","అనుంఙ్ ఎన ఎక్వ బానున్ ఎక్కద్ అమ్మన్ ఎక్కద్ ప్రేమ కలెకంద్ అన్నె సిసుంద్ ఎరెంఙ్ సాలెంద్. అనాయ్ అనుంఙ్ ఎన ఎక్వ పోరకున్ ఎక్కద్ పిల్లన్ ఎక్కద్ మన్నుంఙ్ కలెకాద్ అన్నె సిసుంద్ ఎరెఙ్ సాల్దంద్. ");
INSERT INTO nit_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","తన్నె సిలువన్ కాజుత్న అన్ వెంట వర్సెటద్ ఔర్ అన్నె సిసుంద్ ఎరెఙ్ సాలెంద్. ");
INSERT INTO nit_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","తన్నె పానం బత్కిపెకద్ అదున్ గమప్సద్. గని తన్నె పానమున్ సియెకాద్ అదున్ దక్కిప్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","ఇమున్ కొరెకాంద్ అన్ కొద్దాంద్. అన్ కొరెకాంద్ అన్ పన్కతనున్వై కొద్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ప్రవక్త ఇసా ఒక్కొ కబులకున్ ఇట్టడెంద్ కబులకుంఙ్ వారెకా ప్రతిపలమున్ సుమ్దంద్. మల్ల నీతి ఇసా ఒక్కొ నీతి దారున్ ఇటెద్ ఇమందర్ మన్కక్ ప్రతి పలమ్ సుందద్. ");
INSERT INTO nit_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","సిసులున్ మన్ సియెకాద్ ఏంది ఎక్కద్ సాదరన్ మన్కకెరుంఙ్ ఎరుంఙ్ ఎన గిలసెడ్ ఈర్ ఉనెంఙ్ సియ్సాదొ అమ్‍ది తన్నె ప్రతిపలమున్ సెరెంఙ్ ఇడెంద్ ఇసా కరెయ్ ఇడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","యేసుంద్ తన్నె పన్నెండు మంది సిసులున్ సందేస్ ఇడ్డెకాద్ ఎద్ద వెన్కత్ ఔరె పట్నలెంఙ్ ఇడ్స ఇడెంఙ్‍, కరపెంఙ్ అత్రనట్ కురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","క్రీస్తునె కలెకా పనికున్‍ వాలడ్ యోహాన్నున్ జేలుత్ అనేఙా వింత్ తన్నె సిసులున్ పవిటెద్, ");
INSERT INTO nit_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","తోదింతె అమ్ మరొక్కొనున్ పావొలెకాద ఇసా అంనున్ వేలెంఙ్ తన్నె సిసులున్ పన్కతెద్. ");
INSERT INTO nit_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","అదుఙి యేసుంద్ ఔరడ్ ఇంతెంద్ “నీర్ చెత్న వింతవున్ ఓల్‍తవున్ యోహాన్నుంఙ్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","గుడ్డిక్ ఓల్సనంసార్, కుంటిక్ అడ్‍గసానంసార్, కుస్టి దుక్కమడ్ సోయ్‍ ఎర్సనంసార్, సెవ్డకేర్ విచార్, తిక్తర్ పెన పానం ఎర్సర్, గరిబులుంఙ్ కబుర్ సెసనంసాద్. ");
INSERT INTO nit_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","అన్ బదోల్ తనయ్ అన్మనం తెసెటార్ దన్యుడు” ఇసా సమాదనం ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ఔర్ సెరెంఙ్ యేసుంద్ యోహానున్ బదోల్ మందిఙ్ ఇనంఙ్ ఇడ్‍తెంద్, నీర్ తనెన్ ఓలెంఙ్ బాటివై సెద్దిర్? గాలింఙ్ మెలగెకా గడ్డిన్ రెకాన్ ఓలెంఙ్ సెసతిర? ");
INSERT INTO nit_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","తోద్‍తె ఇంక తనెన్ ఓలెంఙ్ సెదిర్? సోయ్త జుఙ్ఙె తొట్ట మన్కక్? సోయ్త జుఙ్ఙె తొట్టద్ రాజక్నె వాడత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","మరి ఇంక తనెన్ ఓలెంఙ్ సెద్దిరె? ప్రవక్త? సోయ్ గని, ఇమ్‌ద కబులకుంఙ్ ఎన దండి ఇసా ఇముంఙ్ ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","అన్ అనె దూతున్ ఇనుంఙ్ సటీ ముడటి పన్కత్, అముదు ఇనుంఙ్ ఎన ముడటి సెత్న పవున్ తయార్ కద్దంద్ ఇసా వాయుత్ అన్సాద్ యోహానున్ బదొలి. ");
INSERT INTO nit_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","పిల్లంఙ్ జన్మిల్‍తంద్ ఔరున్ లోపా బాప్తిస్మ సియెక యోహానుంఙ్ ఎన దండి జన్మిలెతెంద్ ఇసా ఇముంఙ్ కరెయ్ ఇడ్‍సాత్. అముదు పరలోక రాజ్యం కలెక గుల్ దొడద్ అమ్నుంఙ్ ఎన దండి. ");
INSERT INTO nit_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","బాప్తిస్మ సియెక యోహాన్నె కలమ్ తన ఇండిదూక్ పరలోకముత్ రాజ్యం కలెక దాడులుంఙ్ పల్ ఎద్దిన్. సక్తి తోసెటర్ జులుమెనా అత్తి సొఙ్సనాసర్. ");
INSERT INTO nit_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","తానుంఙ్ ‍ఇంతె యోహాన్నె కలముంఙ్ ఎత్ ప్రవక్త కెరె, నియమ్ సాస్త్రనె ఇసొబడి వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ఈ గటనన్ నాంమెఙ్ ఇముంఙ్ మన్ అండె వారెక ఏలీయాక్ యోహాన్. ");
INSERT INTO nit_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","వినెంఙ్ కెవులనెకర్ విండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","ఇండి ఈ పిడితరున్ ఎనంఙ్ ఇడ్డెకాద్? పొరకెర పెండ్లిత్ అడ్‍సా ఇముంఙ్ సటీ వంస్ ఉంతమ్ గని నీర్ ఎదెతిర్. ");
INSERT INTO nit_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ఇముంఙ్ వంస్ మొరప్తమ్ గని నీర్ ఎందెతీర్, అర్రేక పాట మొరప్తమ్ గని నీర్ అర్రేతీర్, ");
INSERT INTO nit_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","తానుంఙ్ ఇంతె యోహాన్ వత్న నిపట్టె తింసెటా, అంగుర్‍నె రాస ఉన్సెట అన్నెద్. అమ్నుంఙ్ బూత్ అట్‍తిన్ ఇసా ఔరు ఇసార్. ");
INSERT INTO nit_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","మన్కనె పోరక్ తిసా ఉసా వతెంద్. అదుంఙ్ ఎత్తి ఇమ్‍దు కయ్‍వొడ, జింఙలక్, అప్త వసూల్ కలెకార్నాయ్ పాప్ లుంఙ్ సంఙ్తక్ ఇసా ఔర ఇసార్. బుద్ది పనికున్ వాలడ్. ");
INSERT INTO nit_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","అపుడ్ అముదు ఎ పట్నములెంఙ్ పెరెత్ సమత్కాల్ దేసముత్ ఆ పట్నముత్ అర్పులిపెంఙ్ మొదల్ ఇట్టంద్. తానుంఙ్ ఇంతె అదా మన్ బద్లిపుర్ కురితంద్. ");
INSERT INTO nit_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“అయ్యో కొరాజీను! ఇనుఙ్ అర్రివిన్ సిక్సయ సుక్కిలెద్. అయ్యో బెత్సయిదా! ఇనుంఙ్ సిక్స సుకీలెద్. ఇంమతీ జర్గీలెక సమత్కాల్ తూరు, సీదోను పట్నముత్ ఎరెంఙ్ అండె అంతి మన్కకెర్ పేలె సల్కులున్ ముడటీ తమ్మె పాపులున్‍ మన్ బద్లిపుర్ ఒర్కినడ్ గొనె జుఙ్ఙె తోడుత్ బుగ్గీ దీటెకార్.” ");
INSERT INTO nit_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","అన్ ఇడ్డెకద్ తానెంద్ ఇంతె అక్రీ దీనంమున్ ఇంమున్ సుంమెక గతి తనేంద్ ఇంతే తూరు, సీదోను పట్నంముత్ ఔరె గతి నాడీపెకంద్లన్ ఎర్సంద్ ఇస అన్ ఇంమడ్ ఇడ్సత్. ");
INSERT INTO nit_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","కపర్న పట్నముంఙ్‍, పరలోకముంఙ్ తొడసెరెంఙ్ సాలత్ ఇసా నీఇసాతివా? నీ పాతాలముంఙ్ సెరతి. ఇనంతి జర్గిల్‍ తా సమత్కాల్ సొదొముత్ ఎరెంఙ్ ఎద్దె అద్ ఇండిదూక్ ఇల్లుతి అంతనద్! ");
INSERT INTO nit_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","అన్ కరె ఇడ్సా నండాత్ న్యాయ్ దినముంఙ్ ఇనుంఙ్ వరెక గతింఙ్ ఎన సొదొమ జాగ వరెక గతియ్ నాడిపెకద్‍ ఎరద్, అని ఇముంఙ్‍ ఇడ్‍సాత్‍. ");
INSERT INTO nit_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ఆ వేలంఙ్ యేసుంద్ ఇనంఙ్ ఇంతెంద్ “బాంద పరలోకముంఙ్ బూమిఙ్ ప్రబుంద్, నీ గ్యానులుంఙ్ బుద్దితరుంఙ్ ఈ గట్నలున్ మద్దుత్ బుద్ది తోసెటారున్‍ ఒర్కికత్. అదుంఙ్ ఎత్తి ఇన్ అన్‍ మొక్‍సాత్.” ");
INSERT INTO nit_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","అయ్‍ బబా, ఇనాయ్ కలెకద్ ఇనుంఙ్ గుల్ కుసీ. ");
INSERT INTO nit_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","దున్యన్ అన్నె బాంద్ అనుంఙ్ సియ్తెంద్. బాంద్ తప్ప పోరకున్ ఎంది ఒర్కిలెద్. పోరక్, ఎరుంఙ్ పవిడెంఙ్ కీకెన్ నెమిప్‍తంద్ తప్ప ఎది బానున్ ఒర్కిలెంద్ ");
INSERT INTO nit_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","కొసెంఙ్ సాల్‍సెటా వెకమున్ కొస అలయ్‍తర్ నీర్ సిమ్కన మంది అన్‍వై వార్ర. అన్ ఇముంఙ్ సుకమున్ సియత్. ");
INSERT INTO nit_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","తానుంఙ్ ఇంతె అన్‍ గరిబ్‍నన్, సోయ్ మన్నుత్ బుద్దితరన్. అదుంఙ్ ఎత్తి ఇమున్ పొయ్‍ అన్నె కావ్డి సుముత్ అన్నతి కారపుర్. అపుడ్ ఇమ్మె ఆత్మన్ సుకమ్ రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","తానుంఙ్ ఇంతె అన్నె కావ్డి అల్కే. అన్నె మోప్ అల్‍కె అన్సాద్ ");
INSERT INTO nit_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","మల్ల ఇనంఙ్ ఎద్దిన్. యేసుంద్ ఒక్కొ ఆలపుసేక జీర్ కెన్‍వై సెద్దెంద్. అమ్నె సిసులుంఙ్ కరువ్ వత్తిన్ అని ఔర్ మల్ల ఔర్ ఉడ్డా కిసుత్న తినెంఙ్ ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","గని పరుసి మన్కకెర్ అమ్నున్ ఓలుత్న అమ్నున్ ఇంతెర్. ఓల్, నియమ సాస్త్రం ఇడ్డతెతి, ఆలపుసేక జీర్ ఇదర్సెటదున్ తనుంఙ్ ఇన్నె సిసు కల్సర్? ");
INSERT INTO nit_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","యేసుంద్ ఔరున్ ఇంతెంద్. దావిద్ అని అమ్నె సంఙ్ ‍తకేర్ కర్వుత్ అనెఙ, తాగత్తెర్ అదున్ బదోల్ నీర్ వాసిపెతిరా? ");
INSERT INTO nit_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","తే అముదు దెయ్యమ్నె మందిరుంఙ్ సేత్ దెయ్యలకెర్‍ సివాయి ఎద్నయి తిన్నెంఙ్ తోద్ అద నివోద్ ఇట్ట నిప్పలున్ తిందెద్ అని అమ్నె దొస్తులునాయి తినేప్తెంద్, ");
INSERT INTO nit_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","అనాయి గుడిత్ సేవకలేకన్ దెయ్యలకేర్ ఆలపుసేక జీర్ మొక్కెర్ ఎనగ నీర్ నేకిన్ మొడిపేతేర్ గని నేక్కి మొడిల్సెట ఎన నేకి నియమ్ సాస్త్రముత్ వాయుత గొట్టిక్ నీర్ వాసిపెతిరా. ");
INSERT INTO nit_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","అన్ ఈ గుడిత్ మందిరుఙ్ నాయ్ దండి ఇత్తి అస్సంద్. ఇసా ఇముంఙ్ ఇడ్సా నన్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","అనుంఙ్ బావ్ లగ్సతొతెద్ గని అనుంఙ్ కివ్ ఇస్టంవార్సద్ ఇనేక గోట్టి నీర్ ఒర్కిల్తీర్ ఇంతె, నిర్‍ దొసి మన్కకేరున్ దోసి ఎర్సెటార్. ");
INSERT INTO nit_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","మన్కనె పోరక్ ఆలపుసేక జీర్నాయ్ ప్రబు అస్సాన్. ");
INSERT INTO nit_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","యేసు మల్ల అత్తరనా సెత్న ఔరె యూదులె సావ్డిక్లెంఙ్ సెరెంఙ, ఇమ్దొ అర్త కేయ్యతంద్ ఒక్కొంద్ కడ్కెదెంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","అని అత్తిన్ అర్తకేయ్యెతంద్ ఒక్కొంద్ అండేన్ పరుసి మన్కకెర్ అమ్నున్ దొసి నెమిప్తేర్ ఇసా అమ్నున్ వేల్తేర్ ఆలపుసేక జీర్ సోయ్ కలెకాద్ సోయిత. ");
INSERT INTO nit_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","అముదు ఔరున్ ఇసాంద్ గని ఇమును లోప ఎరుంఙ్ ఎనా ఒక్కొ గొర్రె అండిన్ అని అముదు ఆలపుసేక జీర్ పొక్కత్ రాటినింతె అముదు అదున్ పుసూత్ కొస్ఆతొతేంద్ పొస్సతొతెన్. ");
INSERT INTO nit_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ఒక్కొ గొర్రె ఎన ఒక్కొ మన్కక్ ఎంతె ఎక్కువ దర అస్సద్ అదుంఙ్ వాలడ్ ఆలపుసేక జీర్ సోయ్ పనికుల్ కలేకద్ న్యాయం ఇంతేంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","మల్ల యేసునున్ అర్ తా కేయ్యితనున్ ఇసాంద్. ఇన్నె కేయ్యున్ సాప్ అముదు సాప్సన్ అని అమ్నే అర్ తా కేయ్యి మర్ ఒక్కొ కేయ్ల్యింఙ్ సోయ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","అని పరుసియు వాక సేద్దెర్, అని యేసునున్ ఎనంఙ్ కత్ హల్గెకాద్ ఇనుత్ విచార్ కన్నేర్. ");
INSERT INTO nit_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","యేసునున్ అముదు గొట్టిన్ ఒర్కిలుత్న అముదు జాగ తన కురుయుత్ సేసాంద్. గులేన మన్కకెర్ అమ్నున్ వెంట సేన్నెర్ అని అముదు ఔర్ సట్టముని సోయ్ కల్సాంద్ కాల్సాన్. ");
INSERT INTO nit_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","గని అముదు ఎంద్ ఎన్నెంద్ అదున్ బదోల్ ఎరుఙినాయ్ ఇడ్డెకాద్ తోద్ అని ఆగ్య సియుత్ ఇడ్నేంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ప్రవక్త యెసయక్ ఇడ్త గొట్టిక్ కారే ఎరేఙ్ ఇసా ఇద గొట్టిక్ ఎద్దె యెసయాక్నెగొట్టిక్ ఇద ఎన్నె. ");
INSERT INTO nit_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","అముదు అన్‍ ఇదార్త అన్నె గడియాక్ అన్నె లాడ్కాక్ ఎన్నెంద్ ఇనున్ బదోల్ ఇముంఙ్ లాడ్ అన్సాంద్. అన్ అన్నె ఆత్మన్ ఇమ్నున్ పోయ్ ఉద్దెంఙ్ ఇడ్సతును అని అముదు యూదు లెర్సెటరుంఙ్ న్యాయ్ కలెంఙ్ ఇడ్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","అముదు జగ్డా కల్సా తోతెంద్ అని వాపోయేన్ అమ్నే లొల్లి మేడవా జాగత్ ఎరుఙి విన్కువరేద్. ");
INSERT INTO nit_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","అముదు జల్ జల్ తరియేక వత్తిన్ కిట్టిపేకాద్ అని రెకాన్ కినుకుత్. న్యాయ్ గేల్ నంతెంఙ్ అముదు అనంఙ్ కాల్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","అమ్నే పేర్ పోయ్ యూదులెర్సెటర్ బరోస ఇడ్సార్. ");
INSERT INTO nit_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","మల్ల కొన్సెం మంది మన్కకెర్‍ బూత్ అంట్త మన్కకున్ యేసుకున్వై కొర్సర్. అముదు మన్కాక్ అని గుడ్డి అనేద్ అని యేసుంద్ అమ్నున్ సోయ్ కాల్సంద్, అముదు ముడేంఙ్ అని ఓలెంఙ్ ఎద్దాంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","సట్టం మన్కకెర్ గుల్లెన ఏద్దెర్ అని ఇసార్. ఇమ్‍దు దావిద్ పాడితంద్ ఎన్నేం తా. ");
INSERT INTO nit_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","గని పరుసియు ఇదున్ వింత్ గురు ఇసార్. ఇమ్‍దు బుతులే దండి బయెల్జెబూలు సయమాడ్ బూతులున్ ఎదుగ్సా నన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","యేసుంద్‍ ఔరె మన్నులున్ ఒర్కిలుత్న ఔరున్ ఇసాంద్. రాజ్యం కలెక తమ్మెత్ తమి విరొది ఏత్నా ఇదే అదే ఎద్దె రాజే నాస్టం ఎరాద్. ఒక్కొ ఊర్త ఎక్కద్ ఎల్లత్ లోప విరొది కత్తెర్ రింతే అముదు టిక్కిలేంఙ్ సాలేంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","అని సైతన్ తన బూతులును ఎద్గెతెంద్, తన్ లోప పుట్టుపట్టిన్. మల్ల అద్నె రాజ్యం కలెక ఏనంఙ్ టిక్కిలాద్? ");
INSERT INTO nit_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","అన్‍ బయెల్జెబూలు సయమడ్ బూతులున్ ఎదగ్సంద్ ఏరతే, ఇమ్మె సిస్సులున్ తామట్ అదవులున్ ఎదుగ్సా నన్నేర్? అదుంఙ్ వల్లడ్ అవురి ఇమున్ న్యాయ్ కలేకర్ ఎద్దర్. ");
INSERT INTO nit_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","గని అన్ దెయ్యమ్నె ఆత్మనాడ్ బూతులున్ ఎదుగ్సంద్ ఎరాతే, మల్ల దెయ్యమ్నె రాజ్యం కలెక ఇమ్మతి వాత్ అస్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","తాకద్ వలెనే పేలె కండ్కెద్దతిని ఎంది ఏంటాది తాకత్వాలె ఎల్లత్ సొగుత్న అమ్నె బిరాడున్ డొంఙకలెంఙ్ సాలేంద్. గని పేలె తక్కదవలెన్ కట్తె దింతె డొంఙ కలెంఙ్ సాల్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ఏంద్ అన్వెంట అన్సెటంద్, అముదు అనుంఙ్ విరొది అస్సాంద్. ఎంద్ అన్వై మిరప్సెటంద్, అముదు నెరజాడ్ కాలేకాంద్ ఎన్నెంద్. ఇంతే ఎంద్ అన్ వెంట మన్కకేరుంఙ్ దెయ్యముంఙ్ వవాలడ్ మిరయుత్ తొతేంద్, అముదు మన్కకేరుంఙ్ దెయ్యం తన దౌ కలెకాంద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","అదుంఙ్ ఎత్తి, అన్ ఇముంఙ్ ఇడ్సత్, మన్కకెర్ సట్టం పాప్ ఇదర్తదుఙ్ మాప్కల్ ఇదర్తదుఙ్ అని బద్నం కాలేక గొట్టిక్ మాపిరోబ్బడాద్. గని పవిత్ర ఆత్మనేంత్ బదానమ్‍ కాలేకనుఙ్ మాపి రొబ్బడేద్. ");
INSERT INTO nit_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","గని మన్కనె పోరక్ విరొది ముడెకనుంఙ్ కర్జ ఎత్న మాప్కల్ రొబడ్సాద్. గని పవిత్ర ఆత్మనాడ్‍ బాద్నం కాలేకనుంఙ్ ఇద్ కాడుత్ అని వరేక కాడుత్ నాయ్ మాపి రొబ్బడేద్. ");
INSERT INTO nit_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","మాక్ సోయ్ అండి నింతే, అద్నె పండ్లనాయ్ సోయ్ అస్సా. మాక్ పనింఙ్ వర్సెట అండి నింతే, అద్నెపండ్లునయ్ కరాబ్ అస్సా. తనుంఙ్ ఇంతే మాకున్ అద్నె కాయ్తదున్ ఓలుత్న ఒర్కిలెంఙ్ వర్సద్. ");
INSERT INTO nit_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","మల్ల ఏ పామ్‌నె కొవ్వెలాంఙ్ మన్కకెర్, కరాబ్ మన్కకెర్ నీర్ ఎనఙ్ సోయ్ గొట్టికున్ ముడ్సతిర్? మాన్ లోప ఎద నిండుత్ అస్సా అదా గొట్టిక్ ఇమ్మె మూతితన కురిస్సా. ");
INSERT INTO nit_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","సోయ్ మన్కకక్నె మన్నుత్ సోయ్ గొట్టిక్ కురిస్సా. గని కరాబ్ మన్కక్నే మాన్ తన కరాబ్ గొట్టిక్ కురిస్సా. ");
INSERT INTO nit_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","అన్ ఇముంఙ్ ఇడ్సత్. మన్కకెర్ ఆగమిముడేక ప్రతి ఒక్కొ గొట్టినే లెక్క న్యాయ్ కలెక దినముంఙ్ ఇండేఙ్ పడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","ఇమ్మె సోయ్ గొట్ట్టికులాడ్ ఇమున్ ఇమాన్దాల్ ఇందార్ అని ఇమ్మె కరాబ్ గొట్టిక్ వాలడ్ ఇమున్ దొసి టయ్‍రిప్సత్. ");
INSERT INTO nit_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ఒక్కొ దినం కొన్సెం పరుసి మన్కకెర్ అని సాస్త్రి మన్కకెర్ అమ్నున్ ఇసార్ “గురువు” ఇన్ వల్లడ్ ఒక్కొంద్ సమత్కర్ అముంఙ్ ఓలిప్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","గని అముదు ఔరున్ ఇసాంద్. చినలి పడితర్ సిమ్నన్ వేల్సర్ గని యోనా ప్రవక్త ఎంది సిన్నం సివాయ్ మరొక్కొంద్ సమత్కర్ ఇవ్రుంఙ్ రొబ్బడెంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ఎనంఙ్ యోనాక్ ముంది దిన సింతె తొల్లి ఒక్కొ దాండి కాయ్యెనే పెట్టెత్ అండేంద్. అనాయ్ మన్కనె పోరక్ నాయ్ బూమిత్ ముంది దిన సింతె తొల్లి అండెంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","న్యాయ్ కాలేకా నినెవె ఊర్త ఈ పిడితరున్ ఓలుత్న దోస్ ఇసార్. యోనక్ గొట్టి ఇండేఙ ఔరు మన్ బద్లిపుర్ ఓలుర్, యోనాకుంఙ్ దండి అన్ ఇత్తి అస్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","సల్మొన్ రాజక్నే బుద్దిత గొట్టికున్ వినెంఙ్ నొవ్రాక్ దక్సిన జాగత రాని న్యాయ్ కాలేక దినాముత్ ఇద్ పిడిత మన్కకెర్ వెంట ఇల్లుత్న అవ్రున దోసి ఇన్తెంద్. అముదు బూలోకముత్ పకాట్ తాన్ సొల్మొన్నే రాజక్నే గోట్టికున్ వినెంఙ్ వాత్. ఓలుర్, సొలొమోనుంఙ్ ఎన దండి అన్ ఇత్తి అస్సాతును. ");
INSERT INTO nit_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ఒక్కొద్ కరబ్ ఆత్మా ఒక్కొంద్ మన్కన్ సాయుత్న కురుయుతు సేరెగ్న. బట్టి జాగలెంఙ్ తిరగుత్న అలాయుత్ సుమ్మేఙ్ వాలడ్ ఓలుంద్ గని అదుంఙ్ తనయ్ రొంబడెతిన్. ");
INSERT INTO nit_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","మల్ల అముదు ఇసాంద్. అన్‍ సాయుత్న నొవ్రాక్ అన్నె ఏల్లంఙ్ వపస్‍ వర్సత్. అముదు వారుతు ఓలేఙ, అందనే ఏల్ల రికమ్ అనెకాదున్, అయుత్తిన్ సట్టంనాడ్ అనెకాదున్ ఓలుతి. ");
INSERT INTO nit_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","మల్ల అముదు సేత్న తనుంఙ్ ఏన కారబుల్ మరొక్కొ ఏడ్ బూతులున్ తన్ వెంట తోడ వాత్ అని సొగుత్న అత్తి వాస్తు కొర్సవ్. అముదు మన్కక్నే వేన్కతంద్ ముడటనుంఙ్ ఏన గుల్లెన కరాబ్ అన్సాంద్. అనాయి ఇద్ కరాబ్ పిడ్డితారుంఙ్ నాయ్ ఏరద్. ");
INSERT INTO nit_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","అముదు ఇంకా ముడ్సని అన్సాద్. అపుడ్ అమ్నె అమ్మ, అని తోరెంద్ అమ్నడ ముడెంఙ్ ఇసా వత్న వాకా ఇల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ఒక్కొంద్ యేసున్, ఇన్నె అమ్మ, అని తోరెంద్ మానడ్ ముడెంఙ్ ఇసా వత్న వాక ఇల్లుత్‍ కయ్సనంసార్. ");
INSERT INTO nit_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","యేసుంద్ ఇనంఙ్ ఇడ్సా ఎద్ అన్నె అమ్మ? ఎర్ అన్నె తోరెండ్లు ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","తన్నె సిసువై ఓల్సా ఇవ్రి అన్నె అమ్మ అన్నె తోరెండ్లు. ");
INSERT INTO nit_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ఎద్ ఎన్నె పరలోక తా అన్నె బానె అసనడ్ అడుగ్సారొ అవ్రి తోర్దా అన్నె తోరెంద్, అన్నె అమ్మ ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","అదీ జీర్ యేసుంద్ ఎల్ల తన్నా కురియుత్న గాలిల్ సముద్ర మెరా ఉద్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","గుల్ పేలెటర్ మన్కకెర్ అమ్నున్వై మిర్యతెర్, అముదు రూకుత్ సొక్తెంద్ సదర్ మన్కకెరున్ కరపెంఙ్ ఇసా అత్తి ఉద్తెర్. సిమ్కన మన్కకెర్ డర్డిత్ ఇల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","అని అముదు పెల్లె గొట్టికున్ ఉపమానం ఇడ్‍నెద్. అముదు ఇంతెంద్. వాయెకద్ ఒక్కొంద్ వాయెంఙ్ కురియ్‍తెద్. సందూర్డార్డిత్ మంది గుంపుత్ యేసుంద్ ఇడ్డెకద్ సందూర్డార్డిత్ మంది గుంపుత్ యేసుంద్ ఇడ్డెకద్ ");
INSERT INTO nit_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","అముదు వాయెంఙ్‍, కొన్ని వితన్నా పవుత్ రాటే. పిట్ట వత్న అదవున్ తిందే. ");
INSERT INTO nit_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","కొన్ని వితన్నా దూర్ర ఎక్వ తోసెట్ బట్టి జాగత్ రాటే. అత్తి పెరెత్ దూర్ర తొత్తీన్ ఇసా, జల్‍దినీ మోలయ్తె. ");
INSERT INTO nit_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","గని దుపరీ ఎద్దిన్ అని ఉబ్బంఙ్ అదా కౌక్ తే. వేల్ తొతే అదా అర్తే. ");
INSERT INTO nit_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","గని కొన్ని వితన సాల్ల తుట్టిత్ ఉర్కతే. సల్లే తుట్టి పెర్గుత్ అదవున్ పెర్గెంఙ్ ఇడెతె. ");
INSERT INTO nit_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","మల్ల కొన్ని వితన సోయ్త బూమిత్ ఉర్కతె. మేలాయ్తే అదవ్లత్తి కొన్ని తిస్‍ గొనె కొన్ని సాట్‍ గొనె కొన్ని నూర్‍ గొనె పంటాన్ సియ్‍త్తే. ");
INSERT INTO nit_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","విన్నెకార్ విడ్ర. ");
INSERT INTO nit_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","సిసు వత్న యేసునున్ “నీర్ మందిన్‍ వెంటా ఉపమానం తనుంఙ్ ముడ్సన్సాతి” ఇసా వెలుత్‍ ఓల్‍త్తర్. ");
INSERT INTO nit_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","అముదు ఇనంఙ్ సామదనం ఇడ్‍తెంద్. పరలోక రాజ్యం కలెక ఒర్కితోసెటా ఇముంఙ్ సితెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","రొంబటనున్ ఔరుంఙ్ ఎక్వ సియ్యెకద్ ఎరద్. అతనికి సంమ్రుద్ది అన్సాద్. గని తోసెటరత్తన అమ్నున్ మెర అనెక కొన్సెం పుసెకాద్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ఇదుంఙ్ సటీని అన్ ఔరుంఙ్ ఉపమానం ఇడ్సాతున్. ఔర్ ఓల్సనండార్ గని కరేన్ ఓలేర్. విచార్ గని కరెన్ వినేర్, అర్తం కలేర్. ");
INSERT INTO nit_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","యెసయక్ ఇడ్త గొట్టి ఇవ్రె గొట్టి కరె ఎద్దిన్. ఔరె కండ్లు గుడ్డిక్ ఎద్దె. ఔరె కండ్లాడ్ ఓలుత్, కెవ్వులాడ్ వినుత్, మన్నాడ్ విచార్ కత్, మన్నూన్ బద్లిపుత్ అనున్ వాలడ్ సోయ్ ఎరెంఙ్ వీల్ తోసెట ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ఈ మందినె మున్సూత్ సెద్దిన్. ఔరుంఙ్ కెవ్వు సెద్దర్ లాంఙ్ అన్సాద్. ఔరె కండ్లు గుడ్ఇక్ ఎద్దె. ఔరె కండ్లాడ్ ఓలుత్, కెవ్వులాడ్ వినుత్, మన్నాడ్ విచార్ కత్, మన్నూన్ బద్లిపుత్ అనున్ వాలడ్ సోయ్ ఎరెంఙ్ వీల్ తోసెట ఎద్దిన్. అద అన్వై తిర్గత్ అనెఙ్ అండె సోయ్ ఇదర్తనెరన్. ");
INSERT INTO nit_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","ఇంతే ఇమ్మె కండ్లు అస్సనండా అదుఙి అద దన్యులు. ఇమ్మె కెవ్వు విసనండా, అదుఙి అద దన్యులు. ");
INSERT INTO nit_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ఇమ్మాడ్ కరెయ్ ఇడ్సనండాత్ గుల్ మంది ఈ ప్రవక్తకెర్ నీతి మంతు నీర్ ఓలెక అదవున్ ఓలెంఙ్ ఇసా అస కల్సార్ గని ఓలెంఙ్ సలెతేర్. నీర్ వినెక అదవున్ వినెంఙ్ ఇసా ఇంతీర్ గని వినెంఙ్ సలెతిర్. ");
INSERT INTO nit_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","విత్తన సల్లెకనున్ గురించి ఉపమానం అర్తం వినుర్. ");
INSERT INTO nit_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ఎరేనా రాజ్యం కలెక వాలడ్ వింత్ గిన విసెటాండె దుస్మన్ అమ్నె ఔరె మన్నుత్ విత్తెకవున్ తోడ సెసంద్. పవుత్ సల్త విత్తనలున్ ఇవ్రి. ");
INSERT INTO nit_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","బట్టి జాగత్ సల్త వితన ఏర్ ఇంతె, వాక్యం వింత్ వెంటని కుసినడ్ అదున్ సుమ్మెకార్. ");
INSERT INTO nit_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ఇంతే అమ్నత్తి వేల్లు తోసెట కడితుంఙ్ కొన్ని గొల్లి ఇల్లుత్ అన్సార్. వాక్యం కారన్ వాలడ్ గని హింస గని వరెంఙయ్ గుల్ ఎర్సార్. ");
INSERT INTO nit_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","సాల్ల తుట్టిత్ సల్త విత్తన ఎర్ ఇంతె, వాక్యం వసార్ గని ఈ కాడుత్ సింతలున్, సంపదాన్ మోసమి అద్ వాక్యమున్ పకంఙ్ ఇడ్సార్. అదుఙి ఔర్ పండ్సెట ఎద్దార్. ");
INSERT INTO nit_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ఇంతె సోయ్త బూమిత్ ఉర్క తా విత్తన ఏర్ ఇంతె, గొట్టి వింత్ అదున్ అర్తం కలెకాంద్. అనటార్ కరెయ్ పండుదాద్, మల్ల కొన్సెం మంది ముపై రెట్లు పుస్సార్. ");
INSERT INTO nit_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","అముదు పెనొకొ ఉపమానం ఔరడ్ ఇడ్తెంద్ “పరలోక రాజ్యం కలెక తన్నె కెనుత్ సోయ్త విత్తన సల్ తాద్లంఙ్ అన్సాద్.” ");
INSERT INTO nit_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ఒక్కొ జీర్ సింతె మన్కకెర్ మగ్సా అనెఙ అమ్నె విరోద్ దుస్మన్లు వత్ గొద్మలున్ నడుమ్ గడ్డినె రొప్ సల్లుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","గొద్మ మొలయుత్ పెర్గుత్ దొడా ఎద్దపుడ్ గడ్డి కండ్క్‌ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","అపుడ్ ఆ కెనుత్ పని కలెక మన్కక్ అంనున్‍ వై వత్ మాల్కక్ నీ ఇన్నె కెనుత్ సోయ్త విత్తన సల్ గత్తి త, అత్తి గడ్డి ఎనంఙ్ వత్తిన్ ఇసా వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ఇద్ ఎంద్ ఎన విరోద్ ఇదార్త పని ఇసా అముదు ఔరడ్ ఇంతెంద్. ఆ పని కలెకంద్ అమ్ సెత్న ఆ గడ్ఇ రొపున్ సెత్న వెద్దుమా ఇసా అమ్నున్ వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","అదుఙి అముదు మాల్కక్ జమిలె. గడ్డి రొపున్ వెంట గొద్మలున్ మొలక గిన వెద్సాతిరో తందో. ");
INSERT INTO nit_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","కొన్నిగోల్ ఇందిగున్ నాయ్ పెర్గెంఙ్ ఇడుర్. కొన్నికొల్త పెలెత కలాప్త గడ్డిన్ పిడియా కట్టుత్ కిస్సిడుర్. గొద్మలున్ అన్నె గుమ్మిత్ కొర్, ఇసా అర్కెకరుంఙ్ ఇడ్సాత్ ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","అముదు యేసు పెనొకొ ఉపమానం ఇడ్తెంద్. పరలోకంత రాజ్యం కలెక ఇనంఙ్ అన్సాద్. ఒక్కొంద్ తన్నె కెనుత్ ఒక్కొ ఓవనె వితనం ఎనుప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","అద్ విత్తన సిమ్కనతి సిన్నమి గని పెరుగ్తపూడ్ గిన సెట్ ఎన గుల్ దండి మాక్ ఎర్సాద్. ఆబారుత్ ఉడలెక పిట్టా వత్ అద్నె కొమ్ములెంఙ్ వత్ తుప్ప కట్సా. ");
INSERT INTO nit_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","అముదు పెనొకొ ఉపమానం ఔరడ్ ఇడ్తెంద్ “పరలోక రాజ్యం కలెక ఒక్కొ పిల్ల ముది ముంత పిండిత్ తప్పుత్ కలపుత్ అద్ సిమ్కన పుల్లె ఎన్ననంఙ్ ఇదార్తెంద్ పిలియ్త పిండిలంఙ్ అన్సద్” ");
INSERT INTO nit_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","యేసుంద్ అన్నె మూతిన్ ఉపమానం మందిన్ ముండట్ ఇడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","అముదు కబుల్లకెరున్ ఇడ్త దున్యత్ మొదలిట్ట రహస్యం అన్సెటండె గిన గొట్టిక్ ఇడ్సాతున్. ఇసా ప్రవక్త ఇడ్త గొట్టి కరే ఎరెకాద్లంఙ్ యేసుంద్ ఈ గొట్టికున్ మందింఙ్ ఉపమానలంఙ్ ఇడ్తెంఙ్. ఉపమానం తోసెటా అముదు ఔరుంఙ్ తనెని ఇడ్డెతెంద్ఇ. ");
INSERT INTO nit_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","అపుడ్ అముదు మందిన్ పనుకుత్, ఎల్లంఙ్ సెద్దపుడ్ అమ్నె సిసులున్ అమ్నున్వై వత్ “కెనుత్ గడ్డి వయ్త విత్నలున్ గురించి ఉపమానం అర్తం అముంఙ్ ఇడ్” ఇసా వేలుర్. ");
INSERT INTO nit_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","అదుంఙ్ ఎత్తి అముదు ఇనంఙ్ ఇంతెంద్, సోయ్త విత్తన విత్తెకద్ మన్కనె పోరక్. ");
INSERT INTO nit_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","కెన్ ఈ దున్యత్ సోయ్త విత్తన పరలొకమున్ రాజ్యం కలెక బదోల్‍ తరె. గడ్డి విత్తన దుస్మన్ మన్కకెర్లంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","గడ్డి మొలక సల్లెకా విరోద్ దుస్మన్లు బూత్ నుంఙ్ బరబార్. కిస్సెకా లొకముత్ ఆక్రి దెయ్యమ్నె దూదూతులుంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","గడ్డి మొలకలున్ అర్కుత్ మొపుకాటుత్న కిస్సిట్టెతి ఈ లొకముత్ ఆక్రి గిన ఇనంఙ్ ఎద్దాద్. ");
INSERT INTO nit_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","మన్కనె పోరక్ తన్నె దూతులుంఙ్ పవిడ్సంద్. ఔర్ అమ్నె రాజ్యం కలెక తన పాపముంఙ్ కారనం ఎద్దర్ ప్రతి ఒక్కొద్ ఇదున్ కరాబ్ పనిక్ ఇదరెకర్ ఔర్ సిమ్కన మిరపుత్ గల్సాంద్, ");
INSERT INTO nit_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","అత్తి అర్సాని పల్కుకొర్సర్ కిస్తగుండముత్ జొపిడ్సార్. ");
INSERT INTO nit_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","అపుడ్ నీతి మంతూ తమ్మె బానె రాజ్యం కలెక మాకులెంఙ్ వెలుంఙ్ ఎర్గల్సంద్. వినెంఙ్ సల్త కేవ్వులనెకాంద్ నీ వినెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","పరలోక రాజ్యం కలెక సంపదాన్ డప్తత్లంఙ్ అన్సాంద్. ఒక్కొ మన్కక్ అదున్ ఓలుత్న, అద్ రొబాట కుసినడ్ సెత్, తన్నతి అనెకాద్ సిమ్కనన్ ఆ కెనున్ సుంసంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","పరలోక రాజ్యం కలెక సోయ్త ముత్యలున్ సుమ్మెంఙ్ కిరవెకంద్ ఒక్కొ‍ వ్యాపరిలంఙ్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","అముదు గుల్ విలువతంద్ ఒక్కొ ముత్యం కడుకెఙయ్ సెత్ తన్నతి అనెకాద్ సిమ్కనన్ విరుత్ అదున్ సుంసంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","పరలోక రాజ్యం కలెక సముద్రముత్ తప్పెక జాల్లంఙ్ పొలి అంసాంద్. అత్తి రంఙ్ రాంఙ్త కయ్యె పడ్సా. ");
INSERT INTO nit_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","అత్తి నిండ్ తపున్ డర్డివై తివ్వుత్, సోయ్తవున్ పర్డాత్ ఇడుత్ కరాబ్ అనెకవున్ జొపిడ్సర్. ");
INSERT INTO nit_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","అనాయ్ ఇద్ లొకముత్ ఆక్రి ఎరాద్. దెయ్యమ్నె దూత్ వత్ నీతి మంతున్ తన దుస్మలున్ పకంఙ్ ఇదరుత్. ");
INSERT INTO nit_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ఔరున్ కిస్త నెగడిత్ జొపిడ్సార్. అత్తి అర్సా పల్కుకొరుక్స అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ఇద సిమ్కనన్ నీర్ వింతీర్ ఇసా అముదు ఔరున్ వెల్తపుడ్ ఔర్ జవాబ్ సియ్స “వింతమ్” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","అముదు “అదుఙి పరలోక రాజ్యం కలెక బదోల్ ఉపదేసం సుమ్ముత్ ప్రతి నియమ్ సాస్త్ర తా గురు ఒక్కొ మన్కక్ సమాన్ ఇడ్డెక కోలి తన తన్నె దాన్ దవ్లాత్ తన కొత్తన్ వస్తులున్ ఇడుత్ పాతన్ వస్తులున్ వాక పుసుత్ ఎల్లత మాల్కక్ లాంఙ్ అంసాంద్” ఇసా ఔరడ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","యేసుంద్ ఇద ఉపమానం ఇడ్డుత్ సూయ్ ఎద్దె వెన్కత్, ");
INSERT INTO nit_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","అముదు అత్తరన సెత్ తనె సొంత ఊరుంఙ్ వత్, యూదులె సావ్డిక్లెంఙ్ వత్ బొద ఇడ్డె ఙ. వింతర్ ఔర్ సిమ్కన గుల్ సమత్కాల్ ఎద్దెర్ “ఇ బుద్ది, ఇద సమత్కాల్ ఇమ్నుంఙ్ ఎత్తరన వత్తె?” ");
INSERT INTO nit_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ఇమ్‍దు వడెగినె పోరక్ ఎరెందా? ఇమ్నె అమ్మనె పేర్ మరియక్ తె ఎరెద్నా? యాకోబ్‍ యోసేప్, సీమోన్, యూద అని ఔర్ మరొక్కొ దాదక్ తె ఎరెర్నా. ");
INSERT INTO nit_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","అమ్నె తోర్దాసిక్ సిమ్కన నేండ్ వెంటని అండా తా! అమ్నుంఙ్ అదా సిమ్కన ఎలడ్ వత్తె ఇసా ఇడ్డుత్ అముదు గొట్టిత్ గబ్రిల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","తే యేసు “ఒక్కొ ప్రవక్తన్ తన్నె సొత దెసెముత్, అమ్నె సొంత ఎల్లన్ తప్ప మిగ్త సిమ్కన జాగలెంఙ్ సోయ్త పేర్ రొబడాద్” ఇసా ఔరడ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ఔరె అవిస్వాసున్ సుమ్ముత్ అముదు అత్తి ఎక్వ సమత్కాల్ కలెతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ఆ వెలంఙ్ హేరోద్ రాజక్నె పోరక్ హేరోద్ అంట్టిపస్ రాజక్ యేసుంద్ కత్త పనిక్‍ బదోల్ వింతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","అని అముదు ఔరె ఆదికరిక్లాడ్ ఇంతెంద్. ఈ మన్కక్ బాప్తిస్మ సియెకా యోహాన్ ఎన్నెదా. ఇమ్‌ద తిక్తరున్ సుల్పుతెంద్. అదుంఙ్ ఎత్తి, ఇదా దండి సమత్కాల్ ఇమున్ వాలడ ఎర్సాన్సా. యెరొద్ రాజక్ గడియాక్ రుంఙ్ ఇనంఙ్ విచార్ కలెకద్నె కారాన్ ఇద్ ఎంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","యోహాన్ హేరోదున్ ఇంతెంద్. నీ ఇన్నె తోరెనే మాసలున్ ఆపెకాద్ సోయ్‍తోద్. ఎరొద్నె తోరెంద్ పిలిప్నె మాస హేరోదియ లుంఙ్ సటీ జేలుత్ తప్పుర్ అముదు అనంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ఎరొదియలున్ కుసీ కలెంఙ్ ఇసా ఎరొద్ సిపాయికులున్ పన్‍కుత్న యోహానున్ సుమ్‍తెంద్ అని కట్టతెంద్ అని కొడ్‍ప్తెంద్‍. ");
INSERT INTO nit_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ఎరొద్ యోహానున్ అల్ఙేఙ్ ఓల్‍నెద్ గని మన్కకెరుంఙ్ అర్సతెంద్. తానుంఙ్ ఇంతె మన్కకెర్ అమ్నున్ ప్రవక్త ఇసా మాన్ ఇడ్నేర్. ");
INSERT INTO nit_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","గని హేరోద్నె జన్మ దినముంఙ్ హేరోదియలె పిల్ల సదరుంఙ్ ముండట్ ఎద్‍తిన్ అని హేరోదుంఙ్ కుసీ కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","అదుంఙ్ ఎత్తిఎరొద్ ఆదుంఙ్ వసన్ సియుత్న కబులి కతెంద్. నీతనెని వెల్. అన్ ఇనుంఙ్ సియ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","అద్నె అమ్మ ఎనంఙ్ కరప్‍త్తిన్ అనాయ్ అద్దీ ఇడ్‍తిన్, బాప్తిస్మ సియెకా యోహాన్నే తల్లున్ కోజత్ ఇడుత్ అనుంఙ్ కో. అముదు తిక్‍తెంద్ ఇసా కరిలెంఙ్ ఇసా అమ్‍లంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","రాజక్ నరజ్‍ ఎద్దెంద్ గని తన్నె కత్త కబులి గొట్టినాడ్ అని మన్కకెర్ ముండట్ అముదు ఇడ్‍తెంద్ అనాయ్‍ కాలెంఙ్ ఉక్కుమ్‍ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ఎరొద్ సిపాయిన్ జేలుంఙ్ పన్కుత్న యోహాన్నే మక్కున్ పుత్తెంఙ్ ఇడ్‍తెంద్. ఔర్ అనాయ్‍ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","అని యోవంనె తల్లున్ తైలత్‍ కొత్ పిల్లంఙ్ సియ్‍తెంద్. పిల్ల తన్నె అమ్మంఙ్ సియ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","యోహాన్నే సిసు వత్తెర్ అని అమ్నె సెత్తన్ కొసుత్న పుర్పతెర్. మల్ల ఔర్ సెత్న యేసునుంఙ్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","అపుడ్ యేసుంద్ యోహానుంఙ్ ఎద్దదున్ విత్న ఒక్కొ రూకుత్ ఉదుత్న అత్రనా కురియుత్ మన్కకెర్ తోసెటా జాగంఙ్ సెద్దెంద్. గని మంది సిమ్కన అమ్నున్ వింత్న ఔరె ఉల్‍ తన అడ్‍గ్సా యేసుకున్‍ వెంట సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","యేసుంద్‍ రూక్‍ తన డిగెఙ్‍, అమ్దు పెరేత్ మందిన్ ఓల్తెంద్. ఔరున్ పొయ్ అమ్నుంఙ్ కివ్ వత్తిన్ అని దుకలకెరున్‍ సోయ్‍ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","సింత్తెవెలా అమ్నె సిసు అమ్నున్వై వత్న ఇంతెర్, ఇద్‍ మన్కకెర్ తోసెటా జాగహెంద్. పొద్‍నాయ్ ఉర్కెంఙ్‍ కల్సాన్సాద్. ఊరున్‍సేత్న ఔరుంఙ్ అంబ కొరెంఙ్ మన్కకెరున్ పన్క. ");
INSERT INTO nit_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","యేసుంద్ ఇంతెంద్, ఔరు సెరెంఙ్ లగ్గెద్ “నిర్‍ ఔరుంఙ్ తనెన్‍ ఎక్కద్ తినెంఙ్ సియుర్” ");
INSERT INTO nit_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ఔర్ అమ్నున్ ఇంతెర్, అమత్తి పక్త ఐద్‍ నిప్పల్ అని ఇందీ కయ్యె అండా ఇస ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","అముదు ఔరున్ ఇంతెంద్, అదవున్ ఇదె అన్‍వై తోడవర్ ఇస ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","మల్ల అముదు మందిన్ గడ్డి పొయ్ ఉద్గతెంద్. మల్ల అముదు అదా ఐద్‍ నిప్పలున్ అని ఇందీ కయ్యెన్ సుముత్న పొయ్ ఆబార్వై ఓలుత్ దెయ్యమ్నె ఆసిర్వదున్ వెలుత్న ఆ నిప్పలున్ మురుకుత్న తన్నె సిసులుంఙ్ సియ్‍తెంద్. సిసు అదవున్ మందింఙ్ పయుత్‍ సియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ఔర్ సిమనా మంది తింత్న దన్యితెర్. మిక్త తుక్‍డే బరా డలా నిండ నిడ్‍ప్‍తేర్. ");
INSERT INTO nit_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","పిల్లకున్ అని పోరకేరున్‍ సాయుత్న ఐద్‍ హజల్‍ మంది తిందెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","మల్ల అముదు సిసులున్ రూకుత్ ఉదిపుత్ తనుంఙ్ ఎన ముండట్ ఆలడర్‍డింఙ్ సెరెంఙ్ ఇడ్‍తెంద్. మల్ల అముదు మందిన్ సెరెంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","మన్కకెరె గర్దిన్ సెరెంఙ్ ఇడుత్, అముదు ఒక్కొందీ పార్తన కలెంఙ్ మెట్పొయ్‍ సెద్దెంద్. సింత్తెవెలా అముదు అత్తి ఒక్కొదీ అండెద్. ");
INSERT INTO nit_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","గని రూకు బూమిత్ దావ్‍ అండిన్. గని ముదర్‍ వాలడ్‍ జల్క వత్న అదున్ తక్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","తొల్లిని కమ్మి జాస్తి 3-6 వెలుంఙ్ లోపా యేసుంద్ సమ్‍దుర్త ఈర్‍పొయ్ అడ్‍గ్సా ఔరున్‍వై వతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","గని సందూర్‍ పొయ్ అడ్‍గెకనున్ ఓల్త సిసు అరస్తెంద్ ఇంతెర్, ఇద్‍ బూత్‍ ఎంద్ ఇసా అరినాడ్ వపొయ్‍ తెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","గని జల్దియ్ యేసుంద్ ఔరున్ ఇంతెంద్, ఇమ్మత్ సుముర్. అని ఎందున్. అర్సనెం. ");
INSERT INTO nit_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","అని పేతురుంద్ అమ్నున్ ఇంతెంద్, ప్రబు నివ్‍ ఎన్నివ్ ఎరతే అన్నాయ్ ఈర్ పొయ్ అడ్‍గెంఙ్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","యేసుంద్ వా ఇంతెంద్. మల్ల పేతురుంద్ రూకుతన డిగుత్న, ఈర్‍పొయ్ అడ్‍గ్‍నెద్ అని యేసుకున్‍వై సెరెంఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","గని అముదు దుదడున్‍ ఓలుత్న అర్సతెంద్ అని ముల్ఙెఙ్ ఎద్దెంద్ వపొయ్తెంద్. ప్రబు, అన్ బత్కిప్. ");
INSERT INTO nit_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","జాలదీ యేసుంద్ తన్నె కెయున్ సాపుత్న అమ్నున్ సుమ్‍తెద్ అని ఇంతెంద్, ఏ ఉసుటినాయ్ విస్వాసి అనెకనివా, తనుంఙ్ ఇముంఙ్ అన్‍మన్ వత్తిన్? అన్‍ఇన్ ముల్ఙెఙ్ ఇడెన్ ఇసా తనుంఙ్ నీ బరొస ఇడెత్తివా? ");
INSERT INTO nit_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","మల్ల యేసు, పేతుర్ రూకుత్ ఉద్‍త్తెర్ అని గాలి దుదడ్ పాయ్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","అని రూకుత్ అనెకార్ అమ్నున్ మొక్తెర్ అని అమ్నున్ ఇంతెర్. సత్తెం కారెతద్ నీ దెయ్యమ్నె పోరక్ని వెన్నీ. ");
INSERT INTO nit_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","మల్ల ఔర్ సమ్‍దురున్ దటుత్న గెన్నేసరెత్ దేస్త బూమిత్ వత్న గదియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ఆ జాగత్ అమ్నున్ మన్కకెర్ ఓర్‍కిల్‍త్తెర్ అని బెతలిత్ సిమ్కన జాగలెంఙ్ యేసుంద్ వాత్న అన్సాద్ ఇస మన్కకెర్ సదర్‍ దుకలకెరున్ అమ్నున్‍వై తోడవాతెర్. ");
INSERT INTO nit_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","అని యేసునె జుఙ్ఙెనె మూలన్‍ పుడ్‍కెంఙ్ ఇడా ఇసా అమ్నున్ వింతి కన్నెర్. ఎంత్తె మంది అమ్నున్ పుడ్‍క్‍త్తెర్ అంత్తె మంది సోయ్‍ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","మల్ల కొన్సెం పరుసి మన్కకెర్ అని నియం సాస్త్ర గురు యెరూసలేం తన యేసున్‍వై వత్న ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","దొడలె నెకిన్ తనుంఙ్ ఇన్నె సిసు మోడిప్సరా? ఇవ్రు తినెంఙ్ కెయ్యు ఒడెతెర్‍ తా ఇసా యేసునున్ వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","యేసుంద్ ఔరున్ ఇంతెంద్. నీర్ ఇమ్మె దొడలె నెకిన్ సుముత్న తనుంఙ్ దెయ్యమ్నె ఆగ్య తనుంఙ్ మోడిప్‍సాతిరా? ");
INSERT INTO nit_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","తనుంఙ్ ఇంత్తే దెయ్యం ఇంతిన్. ఇన్నెబాదమ్మన్ మన్‍సియ్ అని బాదమ్మన్ సిరొప్ సియెకాద్ తికెంఙ్ పాడద్. ");
INSERT INTO nit_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","గని నీర్ ఇసాతిరా, ఎద్దెనా తన్నె బాదమ్మన్ ఓలుత్న అన్‍ వాలడ్ ఇనుంఙ్ బాదమ్మన్ ఓలుత్న అన్‍ వలడా ఇనుంఙ్ ఎరెకా దాన్ పైసెలున్ “దెయ్యమ్నెవి ఇసా ఇడ్‍తెద్” ");
INSERT INTO nit_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","అనాయ్ ఇమ్మె దొడలె నెకిన్ డ్ ఔరుంఙ్ మదత్ కల్‍సెటా దెయ్యమ్నె గొట్టిన్ మోడిపెతిర్. ");
INSERT INTO nit_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ఏ కప్టి మన్కకెర్, ఇముంన్ బదోల్ దెయ్యమ్నె నేకికున్ ఇడ్డెకాద్ యెసయక్ ప్రవక్త బరాబర్ ఇడ్‍తెంద్. ఇసా అముదు ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ఈ మన్కకెర్ తమ్మె గొట్టినాడ్‍ అన్నె మన్ కాల్సర్ గని ఇవ్రె మన్ తన్న దావ్‍ అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","అగమీ అన్నె బక్తి కల్సార్ మంన్జె మన్కకెర్ బనప్త నేకికున్ దెయ్యంమ్నె గొట్టి ఎంద్‍ ఇసా కరాప్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","మల్ల యేసుంద్ మందిన్ తన్‍వై కూగుత్న ఔరున్ ఇంతెంద్. విండ్ర అని ఒర్కిలుత్ సుముర్. ");
INSERT INTO nit_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ముతీ లోపా సెరెకా మన్కన్ అపవిత్ర కలెద్ గని మూతితన కురియెకావి మన్కన్ అపవిత్ర కల్స. ");
INSERT INTO nit_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","అమ్నె సిసు వత్న అమ్నున్ ఇంతెర్ ఇద్ ఇనుంఙ్ ఒర్కి అన్సాదా? పరుసి మన్కకెర్ ఇన్నె గొట్టిన్ విత్న నరజ్‍ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","యేసుంద్ ఇంతెంద్. అన్నె పరలొకముత్ బాంద్ ఎనుప్త ప్రతెక్ సెట్ వేల్ కలపి మల్‍దద్. ");
INSERT INTO nit_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","అదుంఙ్‍ ఎతి ఔరున్ సాయుర్. ఔర్ గుడ్డి మన్కకెర్ గుడ్డి మన్కకెరుంఙ్ పావ్‍ ఓలిప్‍సా నన్సార్. గుడ్డి మన్కక్ గుడ్డి మన్కన్ పావ్‍ ఓలిప్‍తెంద్ ఇంతె, ఔర్ ఇద్దర్‍నాయ్ పొక్కత్ ఉర్కసార్. ");
INSERT INTO nit_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","గని పేతురుంద్ అమ్నున్ ఇంతెంద్, ఈ ఉపమానం అముంఙ్ కరిల్‍నెతి ఇడ్డా. ");
INSERT INTO nit_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","మల్ల యేసుంద్ ఔరున్ ఇంతెంద్, ఇముంఙ్ నాయ్ ఇంక కరిలెతినా? మరొక్కొరుంఙ్ ఎన దత్తమి బుద్ది తోసెటార్. ");
INSERT INTO nit_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","గని లోప తనెవె సెరెక సిమ్కన మాన్ లోపా సెత్న వాకా కురియ్‍సా. తిందదున్ వాక సెరెకాద్? ");
INSERT INTO nit_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","గని మూతి తన కురియెకా కరాబ్ గొట్టిక్ మన్‍ తన కురియ్‍సా. అదవి మన్కన్ అపవిత్ర. ");
INSERT INTO nit_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","తానుంఙ్ ఇంతె మన్ తన కరబ్ విసర్కున్, కరబ్ పనిక్, పాప్ విసల్, డొంఙ కలెకంద్ లాబడ్‍ముడెకాద్ అని సాడిగొట్టిక్ మరొక్కొరున్ విరోద్ ముడెకా గొట్టిక్ కురియ్‍సా. ");
INSERT INTO nit_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","మన్కన్ అపవిత్ర కలెకా ఇదవి గని కెయ్యుల్‍ ఒడ్‍సెటా అంబ తినెకాద్ తోద్ ఇసా ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","మల్ల యేసుంద్ తన్నె సిసూ వెంటా అత్రనాట్ పట్నముంఙ్ అని తూరు సీదోను దేసుంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ఆ ఎరెయత్‍ అనెకా కనన్ ఊర ఒక్కొ పిల్ల అమ్నున్‍వై వాత్న వపొయుత్ ఇంత్తిన్, ప్రబు, దావిద్నెకీకె, అన్‍పొయ్ కివ్‍కల్. అన్నె పిల్లఙ్ బూత్ అంట్త గుల్‍ తక్‍లిబ్ సియ్‍సానన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","గని యేసుంద్ అదుంఙ్ తనయ్ ఇడెతెంద్. అన్నె సిసువత్న అమ్నున్ వింతికల్ ఇంతెర్, అదున్ పనుక్ తానుంఙ్ ఇంతె అద్‍ వపోయ్సా అమ్నున్ వెంట వర్సానన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","అముదు అదున్ ఇంతెంద్. ఎకున్ దడ్విల్‍తా గొర్రెలంఙ్ అనెకా ఇస్రాయేల్‍ మన్కకెరుంఙ్ సటీని అన్ పనుక్స అన్సాంత్. మరొక్కొరుంఙ్ సటీ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","గని అద్ వత్న యేసున్ ముండట్ మొక్కుత్ ఇంతిన్. ప్రబు, అన్‍పొయ్ దయాకల్. ");
INSERT INTO nit_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","అముదు ఇంతెంద్, పోరకేరె నిపట్టెన్ పెతుత్న ఆతెలుంఙ్ జొపిడెకాద్‍లంఙ్ దెయ్యంన్నె పోరకేరె అసిర్వదున్ మర్జత్తి ఇముంఙ్ సియెకాద్ సోయ్‍తోద్‍ తా. ");
INSERT INTO nit_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","అద్‍, ప్రబూ, కరెయ్ గని! మాల్కక్నె టెబల్ తన ఉర్కతా తుక్డెలున్ ఆతె తిసాత ఇసా ఇంతిన్ ");
INSERT INTO nit_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","మల్ల యేసుంద్ ఇంతెంద్ బాయి, అన్‍పొయ్‍ ఇన్నె విస్వాస్ దండి అన్సాద్. నీ ఎనంఙ్ వెల్సత్తి అనాయ్ ఎక్కద్. అంత్తెతి అద్నె పిల్ల సోయ్‍ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","యేసుంద్ అత్రనట్ కురియుత్ గలిలీయ సముద్ర డర్డివాలడ్ అడగ్సా సెద్దెంద్. మల్ల అముదు ఒక్కొ మెట్ పొయ్‍సెత్న ఉతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","పెరెత్ మంది అమ్నున్‍వై వత్తెర్ అని కుంటిక్, లులకెర్, గుడ్డిమన్కకెర్, ముకకెర్ ఇటార్ పెల్లెటార్ మన్కకెరున్ తోడవన్నెర్ అని యేసునె గెట్టలెంఙ్ ఔరున్ ఇడ్‍నెర్. తె, అముదు ఔరున్ సోయ్‍ కన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","ముకాకెర్ ముడ్సర్, లులకెర్ సోయ్‍ఎద్దెర్, కుంట్టిక్ ఆడగాసార్ అని గుడ్డిమన్కకెర్ ఓల్సార్. ఔరున్ మన్కకెర్ ఓలుత్న కమల్ కల్సార్ అని ఇస్రాయేల్‍ నె దెయ్యముంఙ్ స్తుతి వావా సియుర్. ");
INSERT INTO nit_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","యేసుంద్ అమ్నె సిసులున్ కూగుత్న ఇంతెంద్. అనుంఙ్ ఈ మన్కకెర్ పొయ్ కివ్ వార్సాద్. తానుంఙ్ ఇంతె ఇవ్రు అన్‍ వెంట ముడొలండెర్ అని ఇవ్రుంఙ్ తినెంఙ్ తనయ్‍తొతెద్. ఔరె తినెకద్ పురా తిర్తిన్. ఇవ్రున్ కర్వుత్ పావిడెంఙ్ అనుంఙ్ మన్ తోతెద్ తానుంఙ్ ఇంతె ఔర్ పావుత్ జింగ వత్న రాల్‍దార్. ");
INSERT INTO nit_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","సిసు అమ్నున్ ఇంతెర్, మన్కకెర్ తోసెటా జాగ ఇత్తి ఇంతె మంది మన్కకెరుంన్ తినిపెంఙ్ ఎత్రనటా నిప్పల్ కొరెకదే? ");
INSERT INTO nit_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","యేసుంద్ ఇంతెద్, ఇమ్మత్తి ఎన్ని నిప్పల్ అన్సా? ఔర్ ఇంతెర్, ఏడ్‍ నిప్పల్ అని కొన్ని కయ్యె అన్సా. ");
INSERT INTO nit_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","యేసుంద్ మందిన్ బూమి పొయ్ ఉద్దూర్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","అని అదా ఏడ్‍ నిప్పలున్ అని కయ్యెలున్ సుముత్న దన్యావద్ సియుత్న, అదవున్ ముర్కుత్ అమ్నె సిసులుంఙ్ సియ్‍తెంద్ అని సిసు మన్కకెరుంఙ్ సియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ఔర్ సిమనా తిందెర్ అని దనియ్‍త్తెర్ అని సిన్నా పోరకేర్ అని పిల్లకున్ తిందె మిక్త ఏడ్‍ డాలలెంఙ్ నీడ్‍ప్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","పిల్లక్ అని పోరకేర్‍ సాయుత్న నాలిఙ్ అజ్జల్‍ మంది తిందెర్. ");
INSERT INTO nit_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","యేసుంద్ మందిన్ ఎల్లవై పాన్కతెంద్ అని అముదు తన్నె సిసువెంటా రూకుత్ ఉదుత్న మగదాన్‍ ఇనెక బర్సాంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","పరుసి మన్కకెర్ అని సద్దుకి మన్కకెర్ యేసుకున్‍వై వాత్న అమ్నె పరిక్స ఓలెంఙ్ ఇసా. పరలోకం తన వతెంద్ ఇసా నమ్మెంఙ్ సటీ ఒక్కొద్ సమత్కరున్ ఓలిప్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","గని అముదు ఇంతెంద్, సింతెవేలా ఆబార్ ఎరొడి కండ్కెదిన్‍ ఇంతె, వానా వారెద్‍ ఇసా ఇసాతిరా. ");
INSERT INTO nit_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","తొల్లిని ఆబార్ వత్తిన్, ఎరొడి అండినింతె, ఇనెడ్ వానావర్సద్ ఇసాతిరా. ఆబరున్ ఓలుత్న ఇనటా ఎరెకా గొట్టికున్ బదోల్ ఇడ్డెకాంద్ ఇముంఙ్ ఒర్కి అండద్ గని ఈ కండ్కెరెక సమత్కర్ ఒర్కిలెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ఇవ్రు సమత్కర్ వెల్సర్ చినలి తరము గని యోనాక్నె చిన్న సివాయ్ మరొక్కొంద్ చిన్న ఇవ్రుంఙ్ రొంబాడెద్. ఇనంఙ్ యోనాక్ ముండొల్‍ కాయ్యెనె పెట్టెత్ అత్న పెన పానం వతెంద్ అనాయ్ ముండొల్ ఎల్లత్ అత్న పెన పానం ఎద్దెంద్ మల్ల యేసుంద్ ఔరున్ సాయుత్న సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","సిసు ఆలడర్డింఙ్‍ వత్న గదియ్‍త్తెర్ అని ఔర్ నింప్పల్ కొరెకాద్ మద్‍తమ్ ఇసా ఓర్‍కిల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","అపుడ్ యేసుంద్ ఔరున్ ఇంతెంద్, పరుసి అని సద్దుకి మన్కకెరె కమిరున్ మంజె, పసెంఙ్ కలెకాంద్ పుల్లె పిడ్డి బదోల్ ఉసారడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","గని సిసు తమ్మెత్ తామ్మి ఇనంఙ్ విచార్ కాన్నెర్. నేండ్‍ నిప్పల్ కొరెంఙ్ మద్‍తమ్ ఇసా ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","గని యేసుంద్ ఔరె గొట్టిన్ ఒర్కిలుత్న ఇంతెద్. ఏ ఉసుటినాయ్ విస్వాస్‍ అనెకార్, ఇమంత్తి నిప్పల్ తోతెవ్ ఇసా విచార్ కాల్సతిరా? ");
INSERT INTO nit_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ఇక్కాఇముంఙ్ కరిలెదిహ? ఐద్‍నిప్పల్ ఐద్‍హజల్‍మందీ తిత్నదనియ్‍తే ఎన్ని డలలెంఙ్ నిడ్పతెర్ అద్నెఅది ఇముంఙ్‍ తోతెదా? ");
INSERT INTO nit_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","మల్ల ఏడ్ నిప్పలున్ నాలి హజల్ మందీ తింత్న దనియ్‍తెరింతే ఎన్ని డాలలెంఙ్ నిండుప్తెర్ అద్నెహదీ ఇముంఙ్ తొతెదా? ");
INSERT INTO nit_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","అన్ ఇముంఙ్ వెంట్ నిప్పల్ బదోల్ ముడెతన్ ఇసా తనుంఙ్‍ నీర్‍ ఓర్కిలెతిర్? గని పరుసి మన్కకెర్ అని సద్దుకి మన్కకెరె కమిరున్ బదోల్ ఉసారాడ్‍ అండ్రు ఇసా అన్‍ ఇడ్‍తన్‍ఎకా. ");
INSERT INTO nit_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","పిండి పిజ్గెఙ్ కల్‍పెకా పుల్యిపెకాద్ బదోల్ అముదు ఇడ్‍తెంద్ గని పరుసి సద్దుకి అని మన్కకెర్ కారపెకా కరాబ్ గొట్టిక్‍ బదోల్ అముదు ఇడ్నెంద్ ఇసా మల్ల ఔరుంఙ్‍ కరిల్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","మల్ల యేసుంద్ కైసరియ పిలీప్పి బర్సంఙ్ మెరం అనెక జాగత్ సెరెఙ, అముదు తన్నె సిసులున్ వేల్తొల్తెంద్. మన్కనె పోరక్ అన్ బదోల్ మంది తానెద్‍ ఇసార్? ");
INSERT INTO nit_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ఔర్ ఇంతెర్, కొన్సెం మంది ఇసార్ బాప్తిస్మ సియెకా యోహాన్. మల్ల కొన్సెం మంది నీ సందేస్టక్ ఏలీయాక్ ఇసార్ మల్ల కొన్సెం సందేస్టక్ తొద యిర్మీయా తొదా ప్రవక్త ఇడ్డెకద్ లోపా ఒక్కొద్ ఇసార్. ");
INSERT INTO nit_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","అముదు ఔరున్ ఇంతెంద్. గని నీర్ అన్ బదోల్ తన్నెద్ ఇసాతిర్? అన్ ఎద్ ఎద్దున్ ఇంతెంద్? ");
INSERT INTO nit_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","సీమోన్ పేతురు ఇంతెంద్, నీ పానం దెయ్యమ్నె పోరక్, దెయ్యమ్నె క్రీస్తునె ఎనివా. ");
INSERT INTO nit_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","యేసుంద్ ఇంతెంద్. ఏ యోనక్నె పొరా సీమోన్, నీ దన్యుడు ఎన్నివా. తానుంఙ్ ఇంతె ఇంన్ వెలిప్దర్ గని పరలోక అనెకా అనె బాంద్ నెత్తుర్ ముర్య ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","అన్ ఇముంఙ్ ఇడ్సా. నీ పేతురుక్ ఎన్నివా పేతురుక్ ఇంతె గుడి నీ అని ఈ గున్డ పొదె అన్ సంగమ్ బునది కట్సత్ అని పాతాలముంఙ్ నాయ్ అదున్ కరాబ్‍కలెంఙ్ సాలెంద్. ");
INSERT INTO nit_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","అన్ ఇముంఙ్ పరలోక రాజ్యం కిల్లిక్ జాగన్ సియ్‍సాత్. నీ బూమి తగలెంఙ్ కాట్సతీ అద్ స్వర్గుత్న కట్‍తద అన్సాద్ అని ఎల్లత్ నీ తగలెంఙ్ ఉడ్‍పతీ అద్‍ స్వర్గుత్ నాయ్ ఉడ్‍పుత్ అన్సాద్ ");
INSERT INTO nit_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","తన్న క్రీస్తునె ఇన్నెద్ ఈ గొట్టి యెరుంగీ ఇడ్డెకాద్‍ తోద్ ఇసా అముదు అమ్నె సిసులున్ గుల్లెనా ఆర్‍ పులిపుత్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","మల్ల యేసుంద్ యెరూసలేముంఙ్‍ సెత్న మన్‍వలె, బార్స దెయ్యలకెర్ అని నియం సాస్త్ర గురు మన్కకెర్‍తన రంఙ్‍రంఙ్త తక్‍లిబులున్ సెర్గలెంఙ్ అని ఔరు అదున్ అల్ఙేఙ్ అని ముండొలుంఙ్ తిక్తతన ‍సులాత్ ఇసా తన్నె సిసులుంఙ్ ఇడ్డెంఙ్‍ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","యేసుంద్ ప్రబు ఎద్దద్ ఇసా పేతురుక్ మనుత్ ఇత్‍ అండెద్, అముదు యేసునున్ పకంఙ్ కొసుత్న అమ్నున్ సెయెంఙ్ ఎద్దెంద్ అని ఇంతెంద్. ప్రబు, దెయ్యంఇన్ ఈగొట్టి తన సుంమెకాద్. ఇదా ఇనుంఙ్ ఎరెంఙ్ తోద్ అర్పులిపూత్. ");
INSERT INTO nit_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","యేసుంద్ పేతురున్‍ వై తిర్గుత్ ఇంతెంద్. ఏ సైతన్‍లఙ్ ఇడ్డెకని అనంతనట్ కురియుత్ సే. నీ అనుంఙ్ ఆడ్డమ్ వత్తివా ఇసా ఇంతిన్. గని ఇదా దెయ్యం తన వత్త గ్యాన్ ఎరేద్ గని మన్కకెర్ తన వత్తవెన్నే. ");
INSERT INTO nit_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","మల్ల యేసుంద్ అమ్నె సిసులున్ ఇంతెంద్. ఎదెనా అన్ వెంట వరెంఙ్ ఓల్సదెరతే, అముదు తన్నెతున్ సాయుత్న తన్నె సిలువన్ కాజుత్న అన్‍ వెంట వరెంఙ్ పాజె. ");
INSERT INTO nit_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","తనుంఙ్‍ ఇంతె ఎంద్‍ తన్నె పానమున్ బత్కిప్ సాలద్, అముదు అదున్ బూడు తప్దాంద్. గని ఎద్‍ అనుంఙ్ సటీ తన్నె పానం గమప్దాంద్ అమ్నుంఙ్ ఆ ఎపుడి అనెకా పానం రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","తానుంఙ్ ఇంతె మన్కక్ సిమనా దున్యత్ అగ్టిపుత్ తన్నె పానం నాస్ ఎరెంఙ్‍ ఇట్టెంద్‍ ఇంతె, అమ్నుంఙ్ తా పయ్‍దా? మన్కక్‍ తన్నె పానముంఙ్‍ సటీ తనెన్ సియెంఙ్ సాల్దాంద్? ");
INSERT INTO nit_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","అన్ మన్కనె పోరక్ అన్నె బాంద్ సియెకా మహిమనడ్ అన్నె దూత్ వెంట వర్సత్. మల్ల అన్ ఎరె అవ్ర పనిక్‍లె ఇసొబడ్ కుల్కడున్ మన్కకెరుంఙ్ సియ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","అన్ ఇముంఙ్ కరెయ్ ఇత్తి ఇలుత్ అన్నె కార్‍లోపా ఒక్కొంద్ అన్, మన్కనె పోరక్నె రాజ్యం కలెక తిర్గుత్ వరెకాదున్ ఓలెంఙ్ పేలె తిక్కెన్. ");
INSERT INTO nit_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ఆర్‍ దినాలుంఙ్ యేసుంద్ తన్‍వెంట పేతురుక్, యాకోబ్‍ అని అమ్నె తోరెంద్ యోహాన్ ఇవ్రున్ ఒక్కొ మెట్టా పొయ్ ఒక్కొపకంఙ్ కొస్‍తెంద్ అత్తి ఔర్రి అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ఔరున్ ముండట్ అమ్నెరుపం బద్లిల్తిన్ అని అమ్నె మెన్ పొద్‍ లంఙ్ తరియ్‍తిన్ అని అమ్నె జుఙ్ఙె వేలంఙ్ సక్ సక్ తర్యితే. ");
INSERT INTO nit_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","అపుడ్ మోసేన్ వెంటా ఏలీయాక్ ఔర్ యేసునున్ వెంట ముడెకరున్ ముగ్గుర్ సిసూ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","అప్పుడ్ పేతురుంద్ యేసుకున్ ఇంతెంద్. ప్రబు, నేండ్‍ ఇత్తి అనెకాద్ సోయ్. ఇనుంఙ్ మంన్ అన్సాద్ ఎరత్తె, అమ్ ముదీ కుప్పిక్ ఇడ్సతుమ్. ఇనుంఙ్ ఒక్కొద్, మోసేఙ్ ఒక్కొద్ అని ఏలీయాక్ కుంఙ్ ఒక్కొద్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","అముదు ముడ్సఅనెంఙ్‍, ఓక్కోతరియెకా డమ్మ నిడనాడ్‍ పుస్తిన్ అని డమ్మలత్తనట్ ఒక్కొ అవజ్ వత్తిన్. ఇమ్‌ద అన్నె లాడ్త పోరక్ ఎన్నెంద్. ఇమ్నుంఙ్ బదోల్ అనుంఙ్ కుసీ అన్సాద్. ఇమ్నెత్ విండ్ర. ");
INSERT INTO nit_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","సిసులున్ ఆగొట్టిన్ వింత్న గుల్‍ అర్సతెంద్ అని అవ్ర బూమి పొయ్ బొల్లా రాటెర్. ");
INSERT INTO nit_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","గని యేసుంద్ వత్న ఔరున్ పుడ్కతెంద్ అని ఇంతెంద్. సులుర్ అర్సనెం ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","అపుడ్ ఔర్ తమ్మె తల్లకులున్ ఎత్తుత్ ఓలెంఙ్ యేసుంది ఎరెకాడ్ మరొక్కొర్ ఎరి కండ్కెరెతెర్. ");
INSERT INTO nit_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","అపుడ్ ఔర్ మెట్తన డిగెఙ అముదు ఔరున్ ఉకూమ్ సియ్‍తెంద్. అన్ మన్కనె పోరక్ తిక్తతన తాన్ సుల్‍నంత్తెంఙ్ ఈ ఓల్త దర్సనున్ బదోల్ ఎరుంగీ ఈడ్‍నెర్ ఇసా యేసుంద్ దంకి సెయ్తెంత్. ");
INSERT INTO nit_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","సిసు అమ్నున్ ఇంతెర్. ఇనంఙ్ ఎరాతె ఏలీయాక్ వారెంఙ్ పాజె ఇసా తనుంఙ్ నియమ్ సాస్త్ర గురు ఇడ్‍సార్ ఇసా వెల్తెర్? ");
INSERT INTO nit_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","అముదు ఇంతెంద్. తప్ప తోసెటా ఏలీయాక్ వరెకాద్నాయ్ కారెఅన్సాద్ అని అముదు సదర్ గొట్టికున్‍నై సోయ్‍ కలెకాద్ నాయ్‍ కరెయ్‍. ");
INSERT INTO nit_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","గని అన్ ఇముంఙ్ ఇడ్సత్. ఏలీయాక్ వతెంద్ గని ఔర్ అమ్నున్ ఒర్కిలెతెర్ అని ఔర్ అమ్నుంఙ్ మన్నుంఙ్ వన్నెతి పనికున్ కత్తెర్. అనాయ్, మన్కనె పోరక్ నాయ్ కల్సాంద్ ");
INSERT INTO nit_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","మల్ల ఇద్‍యేసుంద్ బాప్తిస్మసియెకా యోహానున్ బదోల్ ముడెకా గొట్టి ఎంద్ ఇసా సిసులుంఙ్ కారింల్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ఔర్ మందిన్‍వై వారెంఙ్ ఒక్కొ మన్కక్ యేసుకున్‍వై వతెంద్ అని అమ్నున్ ముండట్ ముడుసు ఇడుత్న ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ప్రబు, అన్నె పోరకున్ పొయ్ కివ్ కాల తానుంఙ్ ఇంతె అముదు గురెదుక్క మడ్ గులెనా తక్లిబ్‍ సుమ్సన్సాద్. అముదు గడిగడి కిసుత్ అని ఇరుత్ రాల్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","అమ్నున్ అన్ ఇన్నె సిసులున్‍వై తోడా వత్తన్ గని ఔర్ అమ్నున్ సోయ్‍ కలెంఙ్ సాలెతెర్. ");
INSERT INTO nit_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","యేసుంద్ ఇంతెంద్. ఏ విస్వాస్ తోసెటార్ ముర్కాకెరార, ఎన్‍గడి అన్నె ఇముంఙ్ బదోల్ విస్వాస్ ఇడ్‍నంత్తెంఙ్ అన్ ఇమున్‍వెంటా అన్‍దాత్? అని ఇమ్మెత్ ఎన్ని సాల్కు అమునున్ ఎన్ని దిన సొసిప్ దున్? అమ్నున్ ఇద్దె అన్‍వైతొడా వర్ర. ");
INSERT INTO nit_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","యేసుంద్ బూతులున్ దట్టిప్తెంద్ అద్‍ చిన్నం పోరక్ తన కురియ్‍తి అని ఆ గట్కతి అముదు సోయ్‍ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","మల్ల సిసు యేసుంద్ ఒక్కొది అనెంఙ్ అమ్నున్ వేలుత్‍ ఓల్‍తెర్. అమ్ తనుంఙ్ బూతులున్ ఎద్గెంఙ్‍ సాలెతమ్? ");
INSERT INTO nit_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","అముదు ఔరున్ ఇంతెంద్: ఇముంఙ్ కొన్సెం విస్వాసం అన్సాద్‍ ఇసా నీర్ సాలెతిర్. తానుంఙ్ ఇంతె సత్తెం అన్ ఇముంఙ్ ఇడ్సత్. ఇమ్మె విస్వాస్ ఒక్కొ ఓవనె వితనంనంత్తె అడినింతెనా ఈ మెట్ తనట్ ఆతొర్ సార్కిల్ అనెక అద్ అనాయ్ సార్కిలద్ అని ఇమ్మడ ఎరెద్ ఇన్నెకా తనయ్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","గని ఈ జాతి తా బూత్ ఉపాస్ పార్తన కత్తసివ్వ కురియెద్. ");
INSERT INTO nit_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","మల్ల సిసు సిమ్కన గలిలీయ ఎరియ మిరయ్‍తత్తి యేసుంద్ ఔరున్ ఇంతెంద్. అన్, మన్కనె పోరక్ మన్కకెరె కెయుత్ సుముత్ సియ్యెకార్ అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","అని ఔర్ అమ్నున్ అలంఙ్‍దార్ అని ముండొలుంఙ్ అముదు తిక్తతన సుల్సంద్. మల్ల సిసు గుల్లెనా నారాజ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","సుసి కపర్న ఊరుంఙ్ వత్తెర్, మందిర్త వసులి కలెకార్ పేతురుక్ నంత్తి వత్న ఇంతెర్. ఇమ్మె గురుజి మందిర్నె పన్ను కట్తె దా ఇసా వెల్తెంద్? ");
INSERT INTO nit_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","పేతురుంద్ ఇంతెంద్ అముదు పన్ను కట్‌దాద్. మల్ల పేతురుక్ ఎల్ల లోప సెద్దెంద్ యేసుంద్ ఇసాతి వా? సీమోన్ ఈ బూమితరాజక్ ఎరంత్తి పన్ను వెల్సార్? ఔరె మన్కకెర్ తనట్టి తొద మరొక్కొర్‍ తన? ");
INSERT INTO nit_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","పేతురుంద్ ఇంతెద్. మరొక్కొరున్ వెల్సార్ మల్ల యేసుంద్ అమ్నున్ ఇంతెంద్: మరి అమ్నె సొతామాల్కకెర్ కార్ నిడ్‍పెంఙ్ లగెద్ తా. ");
INSERT INTO nit_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","గని నేండ్ ఇవ్రుంఙ్ నారాజ్ కల్సెటా. నీ సెరువుంఙ్ సెత్న గరీ తప్ప. అని పేలె రొబడెకా కయ్యెన్ సుముత్ అద్నె మూతిన్ వెర్ఙుత్. మూతిలొపా ఒక్కొ సాదినే దెనార రొంబాడద్. అన్నెత్ అని ఇమ్మెత్ కరా అదుంఙ్ ఔరుఙ్ సియ్. ");
INSERT INTO nit_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","అప్పుడ సిసులున్ యేసుకున్‍వై వత్న ఇంతెర్: పరలోక రాజ్యం కలెక ఎద్ దొడద్ అన్దద్ ఎరా? ");
INSERT INTO nit_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","అముదు ఒక్కొ సిన్నం పోరకున్ కూగుత్న ఔరున్ నాడుమున్ ఇల్పతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","అని ఇంతెద్. సత్తెం అన్ ఇముంఙ్ ఇడ్సత్. ఇమ్మె మన్లున్ బద్లిపుత్ ఈ సిన్నం పోరకేరె మన్లాఙ్ ఎరత్తె నీర్ నంక్కి పరలోక రాజ్యం కలెక సొంగెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ఎద్ సిన్నం పోరక్ లాంఙ్ మన్నున్ కమ్మి ఎద్దద్ అముదు పరలోక రాజ్యం కలెక దండి అన్‍దాద్. ");
INSERT INTO nit_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","అని ఎద్‍ఎన్న, ఈట్టా ఒక్కొ పోరకున్ అన్నె పేర్ రుంఙ్ సటీ సుమ్‍సాద్ ఎరత్తె, అముదు అన్న సుమ్మెకాద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","గని ఎద్ద ఎన అన్నె బరొస ఇడ్డెకా సినలున్ లోపా ఒక్కొనున్ పాప్ కాలెంఙ్ కారన్ ఎరతె, అమ్నె మక్కత్ తిర్గలున్ కట్టుత్న అమ్నున్ సమ్‍దురుత్ జొపిడెకాద్ అమ్నుంఙ్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","పాప్ కలెంఙ్ కొసెకా ఈ దున్యత్ నాస్ ఎక్కా. పాప్‍వై తొడసెరెకా పరిక్సవార్స గని ఎరున్‍ వాలడ ఆ పరిక్సవార్సవెర, అమ్మెత్ నాస్ ఎక్కద్. ");
INSERT INTO nit_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ఇన్నె కేయ్యు, ఎక్కద్ ఇన్నెగెట్టా ఎక్కద్ ఇన్‍ పాప్ కలెంఙ్ కారన్ ఎద్దె, అదున్ ముర్కుత్ జొపిడుర్. ఎప్పుడి అనెకా పానం లంఙ్ పవిడెకద్ ఇనుంఙ్ సొయ. ");
INSERT INTO nit_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","ఇన్నె కంన్ ఇన్‍ పాప్‍వై కారన్ ఎరత్తె, అదున్ పుసుత్ జొపిడ్. న్యాయ్ సబా ఇద్ కడ్లత్న ఎప్పుడి అనెక నరకమ్ కిస్సుత్ జొపిడెకదుంఙ్ ఎన గుడ్డి పానం ఎత్న పరలోకాముంఙ్ సెరెకద్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","ఈ సిన్నలున్ ఎనున్‍ నై కామ్మి సమ్‍జిలెంఙ్‍ తోద్ ఇసాత్. తానుంఙ్ ఇంతె అన్ ఇముంఙ్ ఇడ్‍సాత్. పరలోక ఔరె దూత్ ఎప్పుడిస్వర్గుత్ అనెకా అన్నె బాన్నె మోకామున్ ఓల్సన్సా. ");
INSERT INTO nit_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","మన్కన్నె పోరక్ దవ్వడిల్‍ తరున్ బాత్కిపెంఙ్ వాత్తన్. ");
INSERT INTO nit_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","ఇముంఙ్ ఎనంఙ్ కరిల్సద్? ఒక్కొ మన్కంఙ్ నుర్ గొర్రె అన్సా అని అదవున్ లోపా ఒక్కొద్ దవ్‍డిల్‍తిన్ ఇంతె, నొవ్విన్నొవ్వ గొర్రెలున్ సాయుత్న దవ్‍డిల్‍త ఆ ఒక్కొదున్ కిరవెంఙ్ సెరెదా? ");
INSERT INTO nit_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","అని అమ్నుంఙ్ ఆ గొర్రె రొబ్బట్టిన్‍ ఇంతె, అన్ ఇముంఙ్ కరె ఇడ్సాత్. ఏ గొర్రె దవ్‍డిలెతె, అదవుంఙ్ ఎన దవ్‍డిల్‍త ఆ గొర్రె రొబ్బట్టె అమ్నుంఙ్ గుల్‍కుసీ వరద్. ఇముంఙ్ సత్తెం ఇడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","అనాయ్ ఇవ్రు సిన్నతన ఒక్కొద్‍నాయ్ దడ్‍ విలెకాద్ పరలోకముత్ అనెకా అన్నె బాంద్‍ నుంఙ్ కుసీ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","ఇన్నె విస్వాసి దాదక్ ఇన్ విరోద్ కతెంద్ ఎర, నీ అమ్నున్‍వై సెత్న అముదు ఒక్కొదీ అనెంఙ్ అముదు కత్త కరాబులున్ అమ్నుంఙ్ కరిప్. అముదు ఇన్నె గొట్టిన్ వింతెంద్ ఇంతె, నీ ఇన్నె దాదకున్ కరిప్‍తివింత్తె అముదు ఇన్నె ప్రియ ఇస్వసి దాదక్ పెన్న కమయ్ కలెకద్ అన్డె. ");
INSERT INTO nit_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","గని అముదు ఇన్నెతున్ వింతెంద్ ఇంతె, ఇద్దర్ ముగ్గుర్ గవాదర్లున్ మన్కకెరున్ గొట్టి కొస్ అని అముదు కత్త కరాబున్ కరిల్‍నెత్తి ఇడ్. తానుంఙ్ ఇంతె లెకానముత్ వాయుత్ అన్సాద్. ఇద్దర్ ముగ్గుర్ పురవలకెర్ తోసెటా ఎరునీ దొస్ కలెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ఇంక్కా ఆ మన్కక్ విన్నెంద్ ఇసాద్ ఎర్ర అముదు కత్తదున్ సంగమ్ తరుంఙ్ ఇడుర్ అముదు మందీనెత్నయ్ విన్నెంద్‍తే, అప్త వసూల్ కలెకార్నాయ్ అమ్నున్ సమాజ్ తన్న ఎడపుర్. ");
INSERT INTO nit_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","అన్‍ ఇముంఙ్ సత్తెం ఇడ్‍సాత్. బూమిపొయ్ నీర్ తగలెంఙ్ కట్‍సాతిర్, అద్ పరలోకముత్ కట్‍తద్ అన్సాద్ అని ఎల్లన్ నీర్ తగలెంఙ్ కరాబ్‍కల్సాతిర్, అద్ స్వర్గుత్నయ్ కరాబ్‍కత్తద్ అందద్. ");
INSERT INTO nit_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","పెన్నఅన్ ఇముంఙ్ సత్తెం ఇడ్సాత్. ఇముంన్ లోపా ఎరేనా బూమి పొయ్ ఇద్దర్ మన్కకెర్ ఒక్కొదీ మంనడ్ ఇత్తి ఇలుత్ తన్నెన్ వెల్సా పార్తన కత్తదున్ వాలడ్ పరలోక అనెకా బాంద్ సియ్‍దద్. ");
INSERT INTO nit_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","తానుంఙ్ ఇంతె ఎత్తి ఇద్దర్‍ తోద్‍ ముగ్గుర్ అన్నె పేర్ రడ్ మిరయుత్ బక్తి కత్తె అత్తి ఔరె నడుమున్ అన్ అన్సాంత్. ");
INSERT INTO nit_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","మల్ల పేతురుంద్ యేసుకున్ వత్న ఇంతెంద్. ప్రబు, అన్నె దాదక్ అనుంఙ్ విరోద్ కర్జ ఎత్న మాప్కల్, ఎన్ని గుసాల్ అన్ అమ్నెమాప్ కల్సాఅనేకదే? ఏడ్ ఉసాల్‍ కత్తంద్ ఇంతె ఎరాద్? ");
INSERT INTO nit_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","యేసుంద్ ఇంతెంద్. ఏడ్ సాల్‍తొద్‍ గని ఏడ్‍ అని డెబై ఏడ్ ఉసాల్ కాలుర్ ఇసాత్. ");
INSERT INTO nit_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","తానుంఙ్ ఇంతె పరలోక రాజ్యెమ్ ఇనంఙ్ అన్సాద్. ఒక్కొ రాజ్యం కలెక కార్జ పుస్త గడియకెరె ఇసొబ్ కలెక రాజక్‍ లంఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","రాజక్ గడియకెరె ఇసొబ్ కాలెంఙ్ ఎద్దెంద్. పది హజర్ వెండినె రుప్యి ఉదర్ కొస్త గడియక్ ఒక్కొనున్ అమ్నున్‍వై తోడవత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","అమ్నుంఙ్ మలపుత్ రాజక్నె కాడిపెంఙ్ సాటీ అన్‍త్తి పైసె తొతే. అదుంఙ్‍ఎత్తి రాజక్ ఇంతెంద్. ఇన్నె మాసలున్ విర్, పోరకేరున్ విర్, అనెకా సిమ్కనన్ విర్ గని పైసె మలపుత్ సియ్ ఇసా ఉక్కుమ్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","గని ఆ గడియక్ రాజక్నె కాల్‍కు మొక్కుత్ వింత్తి కత్న ఇంతెంద్. ప్రబు, అన్‍ పొయ్ కివ్ కాల్. అన్ ఇన్నె సిమనా పైసెలున్ ఇన్నె ఇనుంఙ్ సియ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","మల్ల రాజుంఙ్ గడియకున్ కివ్ వత్తిన్ అని మాప్కల్ కార్జ కడిల్‍తిన్ సే ఇసా అమ్నున్ సేరెంఙ్ ఇట్టెద్. ");
INSERT INTO nit_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","గని ఆ మన్కక్ ఇనంఙ్ కతెంద్: అముదు రాజక్‍నాంతన కురియుత్ సెరెంఙ్‍, నూర్ వెండి దెనార కరజ పుస్తద్ ఒక్కొ గడియకున్ ఓల్‍తెంద్ అని వెంట పనికలెకద్ అమ్నె మక్కున్ సుముత్న ఇంతెంద్. అనుంఙ్ సియెకా పైసెలున్ మలపుత్ సియ్. ");
INSERT INTO nit_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ఆ వెంట పనికలెకద్ గడియక్ వింతి కలుర్ ఇంతెంద్ అన్‍పొయ్ కివ్కాల్ అన్ మలపుత్‍సియ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","గని అముదు అమ్నున్ తోద్‍ ఇంతెంద్. అమ్నున్ కొసుత్న అముదు కరజ మలపుత్‍ సియ్‍నంత్తెఙ్ జేలుత్ అమ్నున్ కొడప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ఈ గొట్టిన్ వెంట పనికలెకద్ గడియకెర్ ఓలుత్న, నారాజ్ ఎద్దెంద్ అని ఔర్ సెత్న రాజునుంఙ్ ఎద్దపురగొట్టికున్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","అపుడ్ రాజక్ ఆ గడియకున్ కుగ్‍తెంద్ అని ఇంతెంద్. ఏ కరాబ్ గడియ, నీ అన్నత్తి వింతి కల్సతివా, అన్‍ఇన్నె సిమ్కన కర్జ ఎత్న మాప్కల్ కార్జా కాడిప్‍తన్ తా! ");
INSERT INTO nit_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","వెంట పని కలెకాంద్ అన్ ఎనంఙ్ ఇన్‍ పొయ్‍ కివ్ కత్తన్ అనంఙ్ నీనాయ్ ఇన్నె గడియకున్‍పొయ్ కివ్ కలెకద్‍ తొదా? ");
INSERT INTO nit_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","మల్ల రగ్గడ్ అమ్నె రాజక్ అమ్నున్ కొడపుత్న రాజక్‍నె కరజ కాడిల్‍ నంత్తెఙ్ అమ్నుంఙ్ గుల్లెనా తక్లిబ్ రొబ్బాట్టిన్. ");
INSERT INTO nit_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","అనాయ్ నీర్ ఇమ్మె దాదకున్ ఇమ్మె మన్నుత్ మాప్కల్ సెటఅండిరింత్తె, పరలొకముత్ అనెకా అన్నె బాంద్‍ నాయ్ ఇమ్మె కర్జ ఎత్న పాపులె మపి కాలెద్. ");
INSERT INTO nit_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","యేసుంద్ ఈ గొట్టిక్ ఇడ్డ తా వెన్‍కాత్, తన్నె సిసు వెంట గలిలీయ బర్స తనట్ కురియుత్న యోర్దన్ పేనింఙ్ ఆలా పక్కంఙ్ యూదియ బార్సంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","గుల్‍ పేలెటర్ మన్కకెర్ అమ్నున్ వెంట సెన్నెర్ అని అత్తి అముదు దుకలకెరున్ సోయ్‍ కన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ఒక్కొ జీర్, కొన్సెం మంది పరుసి మన్కకెర్ అమ్నె పరిక్స ఓలెంఙ్‍ఇసా అమ్నె గొట్టినాడ్ అమ్నున్ అడ్‍గిపెంఙ్ ఇసా అమ్నున్ ఇంతెర్. తన్నెద్‍ఎన్న మిసాడ్‍మన్కక్ తన్నె మాసలున్ పర్కత్ సియ్యెకద్ నియం సాస్త్రవాలడ్ బరబర్‍ అన్సాదా తొదా? ");
INSERT INTO nit_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","అముదు ఇంతెంద్. దున్యన్ గడిప్త వెన్కత్ దెయ్యం ఒక్కొ పడ్స అని పిల్లన్ గడిప్‍తిన్ ఇసా సాస్త్రత్ ఇడ్సాద్, ఆ గొట్టిన్ వసిపెతిరా? ");
INSERT INTO nit_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","అదుఙి మల్ల దెయ్యం ఇంత్తిన్. ఇదుంఙ్‍ ఎత్తి మన్కక్ పెండ్లి కత్తె తన్నె బాదమ్మన్ సాయుత్న మాస వెంట కాలయుత్ అన్సాద్. ఔర్ ఇద్దరనాయ్ ఒక్కొది సెత్త ఎద్దన్. ");
INSERT INTO nit_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ఔర్ ఇద్దర్‍నాయ్ ఇద్దర్ ఎరెర్ గని ఒక్కొది సెత్త ఎన్నెర్. అదుంఙ్ ఎత్తి పేలెని దెయ్యం జొడిప్తదున్ ఎరి పయ్‍పెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","పరిసీక్ అమ్నున్ ఇంతెర్. మరీ తనుంఙ్ మోసే పర్‍కత్తనమ పుస్తకుత్ వాయుత్ ఉకూమ్ సియుత్ మాసలున్‍ పర్కంత్ సియెంఙ్ ఇసా నేకిసియ్‍తెంద్? ");
INSERT INTO nit_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","అముదు ఔరున్ ఇంతెంద్. నిర్‍ మన్నుత్ కటిన్ అన్సాంతిర్ ఇసా, ఇమ్మె మాసలున్ సయెఙ్ పర్‍వంగి సియ్‍తెంద్ గని మోసే పేలెతన అనంఙ్ తొత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","అన్ ఇనుంఙ్ ఇడ్‍సాత్. చినలి కత్తినింత్తె, మాసలున్ సయెఙ్ గని మరొక్కొ కారనుంఙ్ ఎద్దెనా తన్నె మసాలున్ సాయుత్న కరబ్ కత్తెందిత్తె, అముదు ఆ పిల్లన్ ముండట్ చినాలి కత్తెతి. ");
INSERT INTO nit_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","మల్ల యేసునె సిసు అమ్నున్ ఇంతెర్. మరిమస్‍మసాలె గొట్టి ఇనంఙ్ అన్సాద్ ఎరతె, పెండ్లి కాల్‍సెటా బత్కెకాద్‍ సోయ్ ఇసా అమ్‍నుంఙ్ ఇడ్తెం. ");
INSERT INTO nit_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","గని యేసుంద్ ఔరున్ ఇంతెంద్. సిమ్కన మన్కకెర్ అనంఙ్ అనెంఙ్ సాలెర్. తానుంఙ్ ఇంతె కొన్సెంమంది ముండాకేర్ జన్మిల్సార్. ");
INSERT INTO nit_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","అమ్మనె పెట్టె తన జన్మిల్సార్. ముండక్ బనప్‍సార్. పరలోక రాజ్యం సటీ కొన్సెంమంది పెండ్లి కాలెర్ అని ముండక్ లాఙ్ అన్దర్. దెయ్యంన్నె సేవ కలెంఙ్ ఇసా కొన్సెంమంది ముండక్ లాఙ్ పోరకేర్ ఎర్‍సెటా రికమి అన్సార్. ఈ గొట్టిన్ సుమ్మెంఙ్ ఎద్ సాల్సాదొ అముదు సుమ్‍కాద్. ");
INSERT INTO nit_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","మల్ల సిన్నా పోరకేర్‍ పొయ్‍ కేయ్యులిడెంఙ్ అని పార్తన కాలెంఙ్ ఇసా యేసుకున్‍వై తొడవత్తెర్. అమ్నె సిసు ఔర్ కొర్రెకరున్ అర్పులిపూత్, ");
INSERT INTO nit_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","గని యేసుంద్ ఇంతెంద్. పోరకేరున్ అన్‍వై వారెంఙ్‍ ఇడుర్. ఔరున్ తోద్ ఇన్నెర్. తానుంఙ్ ఇంతె పరలోక రాజ్యం కలెక ఇట్టారుఙి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","అని అముదు ఔరున్‍ పొద్దె తన్నె కేయ్యులిడుత్న ఆసిర్వాద్ కతెంద్. అని అత్రనాట్ కురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","మల్ల ఒక్కొ మిండెగి పోరక్ యేసుకున్‍వై వత్న వెలుత్‍ఓల్‍నెద్. గురుజి, ఎప్పుడి తిక్సెట పానం రొంబడెంఙ్ ఇంతె అన్ తా సోయ్ పని కలెకాద్? ");
INSERT INTO nit_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","యేసుంద్ ఇంతెంద్. తనుంఙ్ అన్‍త్తి సోయ్ తన్నెద్ ఎద్ద ఇత్న అదున్ బదోల్‍ వేల్తొల్తెంద్? దెయ్యం సివయ్య ఎద్ది సోయ్‍ తోతెద్. నీ దెయ్యం వెంట ఎపుడి అనెకా పానం రొంబడెంఙ్ ఇసా ఓల్సాతివెరా, ఆగ్యలున్ పడిప్. ");
INSERT INTO nit_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","అముదు వెలుత్‍ ఓల్తెంద్. ఎద్దా అగ్యిలున్ పడిపెకాద్? యేసుంద్ ఇంతెంద్: హత్య కన్నెమ్, చినలి కన్నెమ్, డొంగ కన్నెమ్, లబడున్ ముడ్‍నెమ్, ");
INSERT INTO nit_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ఇన్నె బాదమ్మనె మన్ ఇడ్‍ అని నీ ఇన్న ప్రేమ్ కలెకద్‍లాంఙ్ ఇన్నె మెరాతరున్ పొయ్‍ ప్రేమ్ కలుర్, ఇన్తెంద్ ");
INSERT INTO nit_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ఆ మిండెగి పోరక్ యేసునుంన్ ఇంతెంద్. ఇదా సిమ్కన అన్ నీ ఇడ్తవున్ కల్సావత్తన్. అన్ పెనా ఎప్పుడి అనెకా పానముంఙ్ సటీ తగలెకద్? ");
INSERT INTO nit_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","యేసుంద్ అమ్నున్ ఇంతెంద్. దెయ్యంముడట్ నీ పురాఎరెంఙ్ ఓల్సతివెరత్తె, సె అని ఇన్నె ఇస్టెదున్ విరుత్న గరిబులుంఙ్ పయుత్‍సియ్. మల్ల ఇన్నె ఇస్టెద్ పరలోకముత్ ఇనున్ సంపదాన్ అన్సాద్. మల్ల అన్నవెంటవ. ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","గని ఆ జవన్ పోరక్ దనవంతక్ అండెద్ అదుంఙ్ ఎత్తి యేసుంద్ ఇడ్‍తదున్ వింత్న నరజడ మలయుత్‍ సెద్దెంద్. తానుంఙ్ ఇంతె మరొక్కొరుంఙ్ సియెకాద్ అమ్నుంఙ్ మన్ తొత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","అని యేసుంద్ తన్నె సిసులున్ ఇంతెంద్. సత్తెం అన్ ఇముంఙ్ ఇడ్సాత్: ఒక్కొద్ స్రిమంతకుంఙ్ పరలోకముత్ రాజ్యం కలెక సెరెకదుంఙ్ మంజె గులెనా కటిన్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","పెన్న అన్ ఇముంఙ్ ఇడ్సత్. పైసెలక్ దెయ్యమ్నె రాజ్యం కలెక లోపా సెరెకదుంఙ్ ఎన ఓట్ సూదినె బొగ్గనాడ్ సొఙెకద్ సాస్తె అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","సిసు ఇదున్ వింత్న బత్కిప్ అని ఇంతెర్. మల్ల ఎరెత్ తరన్ ఎరెంఙ్ సాలాద్? దెయ్యముంఙ్ మనుంఙ్ వత్త మన్కకెరుంఙ్ దెయ్యంఇట్టద్ సియ్‍ద ఇసా యూదు మన్కకెర్ సమ్జిల్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","యేసుంద్ ఔర్ ఓలుత్న ఇంతెంద్. మన్కకెరాడ్ ఇద్దాఎరెద్ గని దెయ్యమున్‍ వాలడ్ సిమ్కన గొట్టిక్ ఎర్సా ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","మల్ల పేతురుంద్ అమ్నున్ ఇంతెంద్. ఓల్, అమ్ సాదరున్‍సాయుత్న ఇన్ వెంట వత్తమ్. అదుంఙ్‍ఎత్తి అముంఙ్ తనెద్ రొబడ్సాద్? ");
INSERT INTO nit_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","యేసుంద్ ఔరున్ ఇంతెంద్. సత్తెం అన్ ఇముంఙ్ ఇసొబడ్ ఇడ్సాత్: కొత్త ఆబార్ కొత్త బూమి వరెఙ మన్కనె పోరక్ తల్లున్‍ తన్నె మహిమతా సింహాసన్ పొయ్ ఉద్దుంత్, అన్ను వెంట సెరెకద్ నీర్ నై పంనెండు సింహాసల్ పొయ్ ఉద్దుంద్ ఇస్రాయేల్‍ బార పడిక్లకెరున్ న్యాయ్ కల్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","అన్నె పేర్ రుంఙ్ సటీ తోర్దా అన్నె తోరెంద్ అమ్మ, బనున్, పోరకేరున్, బూమిన్ ఎల్లన్ సాయుత్ ప్రతి ఒక్కొద్ అటద్ నుర్ రెట్లు సుమ్‍దంద్. అదున్ వెంట ఎప్పుడి తిక్సెట పానం కాద్ సుందద్. ");
INSERT INTO nit_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","గని పేలె అనెకరతన గుల్‍ మంది వెన్క సెద్దెర్. గని ఇండి వెన్కత్ అనెకర్ గుల్ మంది ముదర్‍వై వత్తెర్! ఇసా ఇంత్ఎద్. ");
INSERT INTO nit_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","పరలోక రాజ్యం ఇనంఙ్ అసాద. ఒక్కొ మాల్కక్ తాన్నె అంగుర్నె వాడి పని కలెకదుంఙ్ మన్కకెరున్ కూగెంఙ్ ఇసా తొల్లిని కురియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","తే పనిన్ కుల్కడ్ రొజితద్ ఒక్కొ దెనార ఇంతెంద్ గొట్టి ఎద్దె, అముదు ఔరున్ తన్నె అంగుర్నె వాడి పనుక్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","పెన అముదు తొలిని తొమ్మిది గంట్టలుంఙ్ అంఙడి జాగంఙ్ కొసుత్న అతి సురుమ్ ఇలుత్ అనెకర్ కొన్సెం మందిన్ ఆగమి అనెకారున్ ఓలుత్నఅనెకరున్ ఓల్తెద్. ");
INSERT INTO nit_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","నీర్ నయ్ సెత్న అన్నె అంగుర్నె వాడి పని కలుర్ అన్ నీతి బరబార్ కుల్‍కడ్ సియ్ సాత్. మల్ల ఔర్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","పెన అముదు బార గట్టలుంఙ్ నాయ్ అని ముడు గంట్టలుంఙ్ నాయ్ సెదెంర్ అని అనాయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","పెన సింతె వెల కమ్మి జాస్తి ఐదు గంట్టలుంఙ్ అముదు సెత్న అంఙడి అనెకారున్ కొన్సెం మంది ఆగమి ఇలుత్ అనెకరున్ ఓలుత్న, ఔరున్ ఇంతెంద్. తనుంఙ్ పని తోసెట్ పొద్‍సెన్న ఇల్లుత్న అన్సాంతిర్? ");
INSERT INTO nit_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ఔర్ అమ్నున్ ఇంతెర్: తానుంఙ్ ఇంతె అమున్ ఎరి పనింఙ్ కుగెతెర్. అముదు ఔరున్ ఇంతెంద్. నీర్ నాయ్ సెత్న అన్నె అంగుర్నె వాడి పని కలుర్ అన్ ఇముంఙ్ కుల్కడ్ సియ్‍సాత్. ఔర్ మల్ల వడింఙ్ సెత్న పని కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","సింత్తె వెల ఎద్దె, అంగుర్నె వాడి మాల్కక్ తన్నె గడియకున్ ఇంతెంద్. పని కత్త మన్కకెరుంన్ కూగుత్న ఎరెత్ ఔరుంఙ్ కుల్కడ్ సియ్. ");
INSERT INTO nit_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ఐదు గంట్టలుంఙ్ పనింఙ్ వత్త మన్కకెరుంఙ్ ఆ దినంమ్నె కుల్కడ్ ఒక్కొకొ వెండి దెనార సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","మల్ల పేలె పని కలెంఙ్ వాత్తర్ వత్తెర్. ఔరుంఙ్ పెరెత్ కుల్కడ్ రొబడ్సద్ ఎర్ర ఇంతెర్ గని ఔరుంఙ్ నాయ్ ఒక్కొది వెండి దెనార కుల్కడ్ రొబట్టిన్. ");
INSERT INTO nit_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ఔర్ అమ్నున్ సుముత్న మాల్కకున్ కుర్‍కుర్ కలెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ఔర్ ఇంతెర్. ఇవ్రు వత్తర్ ఒక్కొ జామి పాని కత్తెర్ గని పొద్‍సెన్ అని ఉబ్బత్ పాని కత్తర్ అముంఙ్ అని ఔరుంఙ్ బరాబరి కుల్కడ సియ్తి వా. ఇద్ బరాబర్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","గని ఔరున్ లోప ఒక్కొనున్ మాల్కక్ ఇంతెంద్. సంఙ్త, అన్ ఇంన్ అన్యాయ్. ఒక్కొ జీర్త కుల్కడ ఒక్కొ దెనార సియత్ ఇసా ఇన్న వెంట అన్ గొట్టి కత్తన తొదా? ");
INSERT INTO nit_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ఇన్నె కుల్కడ సుముత్ సె. అన్ ఇనుంఙ్ ఎనంఙ్ సియ్తన్ వెన్కత్ వత్తరుంఙ్ నాయ్ సియెకద్ సోయ్ ఇసా అన్నె మన్న ముట్టిన్. ");
INSERT INTO nit_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","అన్నె పైసెలున్ అన్ మంత్తద్ ఇదరెంఙ్ అనుంఙ్ అదికారం తోతెదా? అన్ సోయ్ మన్ కత్తన్ తె ఇన్నె కడ్ల తనుంఙ్ ఓయ్‍సావ్? ");
INSERT INTO nit_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","గని ఇండి ముండట్ అనెకర్ పరలోకముత్ వెన్క పడ్దర్ అని ఇండి వెంకత్ అనెకర్ పరలోకముత్ ముండట్ పడదర్. ");
INSERT INTO nit_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","మల్ల యేసుద యెరూసలేముంఙ్ సెరెంఙ, అముదు సిసులున్ పకంఙ్ కొసుత్న ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ఓలుర్ నేండ్ యెరూసలేముంఙ్ సెసా నంసాతుమ్. అత్తి అన్న మన్కనె పోరక్ సుముత్ బర్స దెయ్యలకెర్ అని నియం సాస్త్ర గురు మన్కకెరె కేయ్యుత్ సియ్దర్. ఔర్ అమ్నున్ అల్ఙెంఙ్ సిక్స కద్దర్. ");
INSERT INTO nit_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","మల్ల అమ్నున్ బద్నాం కత్న, సాటడ్ లగపెఙ్ అని సిలువత్ సియెంఙ్ ఇసా రొమియులె కెయుత్ సియ్దర్ గని ముండొలుంఙ్ అముదు తిక్తతన సుల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","మల్ల జెబెదయి య్యనె మాస అని ఔరె పొరకెర యోహాన్ అని యాకోబ్నె యేసుకున్‍వై పోరకేర్ వెంట వాత్న అమ్నె కల్ మొక్తిన్ అని అమ్‍నంత్తి ఒక్కొ మదతుంఙ్ సటీ వింత్తి కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","అముదు అదున్ వెలుత్‍ ఓల్‍తెద్. ఇనుంఙ్ తన్నెద్ పాజె? అద్ అమ్నున్ ఇంత్తిన్ ఇన్నె రాజ్యం కాలెంఙ్‍, అన్నె ఇవ్రు ఇద్దర్ పోరకేర్ లోప ఒక్కొనున్ ఇన్నె ఉన్న పకంఙ్ అని పెన్న ఒక్కొనున్ ఇన్నె ఎడమ పకంఙ్ ఉదిపత్ ఇసా గొట్టి సియ్యెకాద్. ");
INSERT INTO nit_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","గని యేసుంద్ ఇంతెంద్. నీర్ తనెన్ వెల్సతిర్ అదా ఇముంఙ్ ఒర్కి తోతెద. అన్ ఉనేకద్ గిలస్ తా! ఈర్ నీర్ ఉనెంఙ్ సాలతిరా? ఇసా ఔరున్ వెల్తెర్ ఔర్ “సల్సతుం” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","మల్ల యేసుంద్ ఔరున్ ఇంతెంద్. కర్రెయ్ అన్న వెంట తక్లిబ్ సొసిప్‍సాతిర్ గని అన్నె ఉన్న బజుత్ అని ఎడమ పకంఙ్ ఉద్దెంఙ్ ఇడ్డెకద్ అనంఙ్ తోతెద్. అముదు అన్నె బాంద్ ఎరుంఙ్ సటీ నెమిప్‍తెద్ అవ్రుంగి రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","పది మంది సిసు ఇదున్ విత్న ఔర్ ఇద్దర్ దాదకున్ పొయ్‍ రాగుంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","గని యేసుంద్ ఔరున్ మెరా కూగుత్న ఔరుంఙ్ ఇడ్‍తెద్. ఇముంఙ్ ఒర్కి అండదాగ. మార్జాతి అదికార్ అండె ఔవ్రె మన్కకెర్ పొయ్ గుల్ జోర తా సాత్త అడ్గిప్సర్. అని ఔరె గురు మన్కకెర్ ఔరున్ పొయ్ గుల్‍ జొరతా అదికార్లంఙ్ అండె. ");
INSERT INTO nit_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","గని ఇమున్ లోపా అనంఙ్ కలేకద్‍తొద్. ఇమున్ లోపా ఎద్‍ ఎన దండి మన్కక్ ఎరెంఙ్ ఓల్సద్ ఎరత్తె, అముదు ఇన్నె గడియక్ లాంఙ్ ఎరెంఙ్ పాజె. ");
INSERT INTO nit_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ఎందెనా దెయ్యమున్ ముండట్ అనెంఙ్ ఓల్సంద్ ఎరాతె, అముదు ఇమ్మె గడియక్‍లంఙ్ ఎరెంఙ్ పాజె. ");
INSERT INTO nit_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","అనాయ్, అన్ మన్కనె పోరక్ సేవా కత్త సుమెంఙ్ వారెతన్ గని సేవ కలెంఙ్ అని పేలెటర్ మన్కక్నె పోరక్ తల్లున్‍ పాపులున్ కడిపెంఙ్ ఇసా అన్నె పానం సియెంఙ్ వా తాన్. మంజె, ఇమ్మె పాపులె న్యాయ్ తన ఇముంన్ సాయ్‍గలెంఙ్ వా తాన్. ");
INSERT INTO nit_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","మల్ల ఔర్ యేరికొ ఉర్‍ తన సెరెంఙ, గుల్ మంది మన్కకెర్ అమ్నున్‍ వెంట సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","అత్తి పవుత్ ఇద్దర్ గుడ్డి మన్కకెర్ ఉదుత్ అండెర్. యేసుంద్ ఆ పవడ్ సెసా నంసద్ ఇసా వింత్న జోరకత్ వాపొయ్‍తెర్. ప్రబు దావిద్నె పొరా అమున్ పొయ్ కివ్‍కల్. ఇసా వపొయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","సెరెకా మన్కకెర్ ఔరున్ సురుమ్ అండ్ర ఇసా అర్పులినేర్. గని ఔర్ సెగి జోర్‍కంత్ వపొయ్‍తెర్. ప్రబు, దావిద్ రాజక్నె పొరా, అమున్ పొయ్ కివ్ కల్. ");
INSERT INTO nit_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","యేసుంద్ ఇల్‍తెంద్ అని ఔరున్ కుగ్ తెద్. మల్ల ఇంతెద్. అన్ ఇముంఙ్ సటీ తా గద్దున్ ఇసాతిర్? ");
INSERT INTO nit_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ఔర్ ఇంతెర్. ప్రబు అముంఙ్ నదుర్ సీయ్. ");
INSERT INTO nit_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","యేసునుంఙ్ కివ్ వత్తిన్ అని ఔరె కడ్లున్ పుడ్కతెద్. జల్ది ఔరుంఙ్ నదుర్ వత్తిన్ అని ఔర్ అమ్నున్ వెంటా సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ఔర్ యెరూసలేంతన్న ఒలీవ మాక్ గుబ్బె మెరా అనెకా బేత్పగేంఙ్ వత్తెర్. అత్తి యేసుంద్ ఇద్దర్ సిసులున్ కూగుత్, ");
INSERT INTO nit_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ఇముంఙ్ ముదర్‍వై కన్కెరెకా ఉర్‍వై చెర్. చెరెగయ్ కట్టుత్ అనెకా ఒక్కొ గాడ్దినె, కొవ్వె ఇముంఙ్ కన్కెరద్. అదున్ ఉడుపుత్ అన్‍వై తోడవర్‍. ");
INSERT INTO nit_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ఎరేనా ఇమున్ అదున్ బదోల్‍ వెల్‍త్తె, అద్ ప్రబునుంఙ్ పాజె ఇసా ఇడ్డుర్, అపుడ్‍ అముదు వెంటాయ్ అదున్ ఇమున్ కొరెంఙ్ సియ్‍సాంద్ ఇసా ఇడుత్ ఔరున్ పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ప్రవక్త ఇడ్త గొట్టిక్ జరగిలెంఙ్ ఇసా ఇనంఙ్ ఎద్దిన్, ఆ గొట్టిక్ ఎద్దెవింతె, ");
INSERT INTO nit_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ఇదొ ఇన్నె రాజక్ గరిబెత్న, గాడ్దినె కొవ్వెన్ పొయ్ ఉదుత్ ఇన్‍వై వర్‍సానంసాద్ ఇసా సియోనె పోరకుంఙ్ ఇడ్డూర్.” ");
INSERT INTO nit_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","అపుడ్ సిసు యేసుంద్ ఆగ్య సియ్‍తెతియ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ఔర్ ఆ గాడ్దిన్, అని అద్నె కొవ్వెన్ తోడా వత్ అదున్ పొయ్ తమ్మె జుఙ్ఙెలున్ తడుత్. అదున్‍ పొయ్ యేసుంద్ ఉద్‍తెంద్ ");
INSERT INTO nit_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","మంది నత్తి సిమ్కన మంది తమ్మె జుఙ్ఙెలున్ పావుత్ పొడమి బూమి పొయ్ తాడనెర్. కొన్సెం మంది మాక్ కొమ్ములున్ కత్కుత్ పావుత్ తడనెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","మందినత్తి అంనుంఙ్ ముదర్‍వై, వెన్కవై అడగ్సా “దావిద్ కీకెంఙ్ మహిమ! దెయ్యమున్ స్తుతి ఎరెంఙ్ ఇస ప్రబునె పేర్ రడ్ వారెకనుంఙ్ స్తుతి, సోయ్త జాగంఙ్ జెయ్” ఇసా వాపొయ్‍సా వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","యేసుంద్ యెరూసలేముంఙ్ వతవెన్కత పట్నంతర్ సిమ్కన మంది, “ఎరెతంద్?” లొలినడ నిడతిన్. ");
INSERT INTO nit_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","అమ్నున్ వెంట వత్త మంది, “ఇంద యేసుంద్ గలిలీయత నజరేత్ తన్న వత్త ప్రవక్త” యేసుంద్ ఇసా ఔరుంఙ్ ఇడతెద్. ");
INSERT INTO nit_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","యేసుంద్ గుడిత్ సెత్న అత్తి విరెకరున్ సుమ్మెకారున్ సిమ్కన మందిన్ పుస్‍తెద్. పైసె దిడినడ్ సుమ్మెకరె టెబల్‍కున్, పారెవలున్ విరెకారె పిటలున్ జొపిటెద్. ");
INSERT INTO nit_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ఔరున్ ఇనంఙ్ ఇంతెంద్, “అన్నె మందిర్, ‘సదర్‍ మందింఙ్ సటి పార్తన ఎల్ల’ ఇసావాయుత్ అండద్, గని నీర్ అదున్ డొఙలె కిల్ల బనప్‍తిర్.” ");
INSERT INTO nit_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","అత్తి అనెకా కుట్టిక్ గుడిక్ యేసున్ మెర వత్తెర్, అంద ఔరసాదరున్‍ సోయ్‍ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","దొడా మన్‍వలె దెయ్యలకెర్, నియమ్ సాస్త్ర గురు అద్బు తాలున్ ఓల్‍తెర్. ఔర్ “దావిద్నె కీకెంఙ్ స్తుతి” ఇసా గుడిత్ వాపొయెకా చిన్నం పోరక్ రున్ ఓలుత్న రగ్గుంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ఇవ్రి తానెవిసా వపొయ్‍సరొ విసతివా? ఇసా అమ్మున్ వెల్‍తెర్. అదుఙి యేసుంద్, “విసాతి, ‘పోరకేర్, సిన్న పోరకేరె మూతిక్‍లెంఙ్ స్తుతికున్ నిడప్‍తి’ ఇనెకా గొట్టి నీర్ ఎప్పుడి లెకనముత్ వసిపెతిరా?” ఇసా ఔరుంఙ్ ఇడ్డుత్! ");
INSERT INTO nit_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","యేసుంద్ ఆ పట్నం తన కురియుత్ బేతనియఙ్ వాక సెత్ ఆ సింతె అత్తి అండెద్. ");
INSERT INTO nit_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","వెగ్‍త వెన్కత అముదు పెన్న పట్నముంఙ్ వరెంఙ అమ్నుంఙ్ కర్వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","అప్పుడ్ ఆ పావ్ పకంఙ్ ఒక్కొ మెడి మాకున్ కొమ్ము ఓల్‍తెంద్. అముదు అదున్ మెర సెత్న ఓల్‍తె, అద్‍నంతి ఎగులి ఎరెకడ తనయ్ కన్‍కెరెతె. అముదు అదున్, “ఇక ముండట్ నీ ఎప్పుడి కాయె!” ఇంతెంద్. వెంటాయ్ ఆ మేడి మాక్ అరతిన్. ");
INSERT INTO nit_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","అదున్ ఓలుత్, సిసు కామల్ కత్తెర్, “ఆ మేడి మాక్ ఒక్కొది మట్ ఎనంఙ్ అర్తినెరా!” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","అదుంఙి యేసుంద్ “ఇముంఙ్ విస్వాసం ఇట్టె, తానయ్, అన్మాన్ కల్‍సెట అండె, ఈ మేడి మాక్ కతదున్ నిర్‍నాయ్ కలెంఙ్ సాలతిర్. అతెయ్ మత్రమ్ తోద్, ఈ గుబ్బెన్, నీ సులుత్ సమ్‍దురుత్ ఉర్క ఇంతె అనంఙ్ కరెయ్ గడిలద్. ");
INSERT INTO nit_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","నీర్ పార్తన కలెంఙ్ ఎద్ పాజె ఇసాతిరొ అద్ రొబడ్‍దవిసా బరొస ఇంతె అద ఇముంఙ్ రొబడ్‍ద” ఇసా ఔరుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","యేసుంద్ గుడిత్ ఇడ్సఅనెంఙ్ దెయ్యలకెర్, మన్‍వలె మందినె దెయ్యలకెర్ అమ్నున్‍వై వత్న, ఏ అదికారడ్ ఈ పనిక్ కల్‍సాతి? ఈ అదికార్ ఇనుంఙ్ ఎద్ సియ్తెంద్? ఇసా వెల్ తెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","యేసుంద్ అనాయ్ ఇమున్ ఒక్కొ ప్రస్న వేల్తొల్తెంద్. అదుంఙ్ నీర్ సామదనం సియ్‍తె అన్ ఏ అదికార్ రడ్ ఈ పనిక్ కల్సాతొ ఇముంఙ్ ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","యోహాన్ సియ్‍ తా బాప్తిస్మ పరలోక తన వత్తినా? తోద్‍తె మన్కతన వత్తినే? ఇసా ఔరున్ వెల్‍తెద్. అపుడ్ ఔరు, నేండ్‍ దెయ్యంతన ఇసా ఇడ్‍తె, నీర్ తనుంఙ్ యోహానున్‍ పొయ్ బరొస ఇడెతిర్? ఇసా ఇందద్. ");
INSERT INTO nit_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","మన్కకెతన ఇసా ఇడ్‍తె ఈ మంది సిమ్కన యోహానున్ ఒక్కొ ప్రవక్త ఇసా ఇందర్ అదుంఙ్ ఏత్తి ఔర్ తగల్‍సారొ ఇసా అర్రివార్సద్ ఇసా తమ్మెత్‍ తామీ సాయ్‍గుత్, ");
INSERT INTO nit_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","అదుఙి అముంఙ్ ఒర్కి తోద్ ఇంతెర్. అప్పుడ యేసుంద్ అనంఙ్ ఎదే అన్ ఏ అదికార్ రడ్ ఇదా కల్‍సాతొ ఇండెన్. ");
INSERT INTO nit_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","అముదు ఔరున్ వెంట ముడ్‍సా, “ఇముంఙ్ ఎనంఙ్ కరిల్‍సాద్? ఒక్కొ మన్కంఙ్ ఇద్దర్ పోరకేర్ అండెర్. బంద్ద దొడంద్ పోరకున్, కుగూత్ బాపు, సెత్న ఇనెడ్ అంగుర్నె వాడి పని కల్ ఇంతెంద్.” ");
INSERT INTO nit_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","అముదు, అన్ సెరెన్ ఇసా ఇంతెంద్ గని మల్ల మన్ బద్లిపుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","అపుడ్ బాంద్ తన్నె పెనొకొ పొరకున్‍వై వత్న అనాయ్ వెల్తెంద్. అముదు, అన్ సెసాత్ ఇంతెంద్‍ గని సెరెతెద్. ");
INSERT INTO nit_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ఇవ్రు ఇద్దర్‍లోప ఎంద్ ఆ బానెత్ గొట్టిన్ వింతెతి? ఇసా ఔరున్ యేసుంద్ వెల్ తెంద్. ఔర్, “పేలెతంది” ఇసా ఇంతెర్. యేసుంద్, అన్ ఇముంఙ్ సత్తెం ఇడ్డెకద్ తానెద్ ఇంతె, అప్త వసూల్ కలెకార్నాయ్, వేసంతర్ ఇముంఙ ఎన ముడటి దెయ్యమ్నె రాజ్యముంఙ్ సెదర్. ");
INSERT INTO nit_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","యోహాన్ నీతినె లూక్గమున్ ఓలిపెఙ్ వతెంద్ గని అమ్నున్ నీర్‍ నంమెతిర్. గని అప్త వసూల్ కలెకార్నాయ్, డొఙులున్ బరొస. అదున్ ఓలుత్ ఎన నీర్ ఉమ్‍జిలెతిర్, అమ్నున్ మన్ బద్లిపుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","పెన ఒక్కొ ఉపమానం విండ్ర, ఒక్కొ మాల్కక్ తన్నె దండి వాడిత్ అంగుర్నె వాడి ఎదప్‍గత్న, అదున్ తిర్గొర జాప్ కల్గతెంద్. అత్తి అంగుర్నె వాడిత్ నడ్‍మున్ దండి పొక్క తయార్ కల్సర్, అత్తి కాయెకనున్ నెమిపుత్న, కాయెంఙ్ పొడమ్ ఏగర్ ఇడ్‍గత్న, అదున్ బాటయడ్ సియుత్ దావ్‍త దేసెముంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","కిస్సెక కాలమ్ వత్తె పంట తా తన్నె ఇస తోడవా ఇసా ఆ బటెయడ్ సియ్‍తన్వై తన్నె గడియకేరున్ పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ఆ కెన్ సుల్‍పెకార్ అమ్నె గడియకేరున్ సుముత్, ఒక్కొనున్ లగప్‍తెర్, ఒక్కొనున్ అలంఙ్తెర్. ఇంకొక్కొనున్ గుండ్ల లగప్తేర్. ");
INSERT INTO nit_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","అప్పుడ్ అముదు పేలెతరుంఙ్ ఎన పెరెత్ మంది గడియకెరున్ పన్కతెంద్. గని ఔర్ ఇవ్రున్‍నాయ్ పేలెతరున్లాఙి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ఆక్రింఙ్ ఆ మాల్కక్ అన్నె కీకెంఙ్ ఎన ఔర్ మన్ సియ్‍దర్ ఇంత్న, తన్నె కీకెన్ ఔరున్‍వై పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","తే ఆ బాటయడ్ సుంతర్ అమ్నున్ ఓలుత్న, అముదు, వరస అన్నెద్. అమ్నున్ అలుఙుత్ అమ్నె పూర ఇస్టెదున్ వెంత్నర్, వార్ ఇసా తమ్మెత్ తమి ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ఔర్ అమ్నున్ సుముత్ అల్ఙుత్ అంగుర్నె వాడి పకంఙ్ జొపిటెర్, ");
INSERT INTO nit_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ఇండి ఆ అంగుర్నె వాడినె మాల్కక్ వత్ ఆ కెన్ సుల్‍పెకరున్ తగల్‍సాద్? ఇసా ఔరున్ వెల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“అముదు ఆ కరాబ్ మన్కరెరున్ అర్సెటా అల్తెంద్. కిస్సెకా కలముత్ తానుంఙ్ వరెక ఇసా మక్త పై సెలున్ పద్దతినడ్ సియ్యుత్న మరొక్కొ సెత్కరికున్ ఆ అంగుర్నె వాడి మక్తనడ్ సియ్తెంద్” ఇసా అంనుఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","అపుడ్ యేసుంద్ ఔరున్ ఇంతెంద్, ఎల్ల కట్టెకద్ పనిత్ పడ్సెట గుండున్ ఆక్రింఙ్ మొదలిడెకా బునదిత గుండు ఎద్దిన్. ఇదున్ ప్రబుది బనప్‍తెంద్. ఇద్‍ నేండుంఙ్ కమల్‍ తాద్ ఎద్దిన్ నీర్ లేకనముత్ ఇడ్తెతి ఎపుడి వసిపెతిరా? ");
INSERT INTO nit_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","అదుంఙ్ ఎత్తి దెయ్యమ్నె రాజ్యం మున్ ఇమత్తనట్ పుసుత్, అద్నె పంటన్ పెన సియెకా మందింఙ్ సియ్‍సాత్ ఇసా ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ఈ గుండ్ పొయ్ రాలెకర్ తుక్డె ఎద్దర్ గని అద్ ఎరున్ పొయ్ రాల్సదొ అమ్నున్ సుర్రా బనల్దార్. ");
INSERT INTO nit_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","అముదు ఇడ్‍త ఉపమానం తమున్ బదోలి ఇడ్డెకదుంఙ్ మెన్ దెయ్యలకెర్, పరుసియు ఒర్కిల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","అదుఙి ఔర్ అమ్నున్ సుమెంఙ్ మెకా ఓల్‍నెర్ గని మందింఙ్ అర్సతెంద్. తానుంఙ్ ఇంతె మంది సిమ్కన అమ్నున్ ఒక్కొ ప్రవక్త ఇసార్. గని మన్కకెరున్ ఓలుత్ అరుస్తేర్. ");
INSERT INTO nit_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","యేసునుంఙ్ ఉత్తర్ సియ్స మల్ల ఉపమానం ఇనంఙ్ ముడేఙ్ ఎద్దెంద్, ");
INSERT INTO nit_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","పరలోక రాజ్యం ముత్ ఒక్కొ రాజక్ రాజ్ కలెక తన కీకె సెత్న జెవొన్ తయార్ ఇదర్తెతి అండాద్. ");
INSERT INTO nit_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","ఆ జెవొనుఙ్ కుగ్ తరున్ ఔరున్ కూగెంఙ్ అముదు తన్నె గడియకేరున్ పావిట్టెద్. తే ఔరేరి వారెతెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","అపుడ్ ఆ రాజూ, ఇద్దొ, అన్నె జెవొన్ తయార్ అండద్. కొందలున్, కొరూవ్త జన్వల్లున్ తర్గుత్ పేండ్లి జెవొన్ తయార్కత్తమ్, వర్ ఇసా ఇడ్డెఙ కొన్సెం మంది గడియకేరున్ పవిట్టెర్ ");
INSERT INTO nit_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","గని అముదు లెక్క కల్సెటా, ఒక్కొద్ తన్నె కెనున్, మరొక్కొంద్ తన్నె వ్యాపారమున్ చేరెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","మిక్తార్ అంనే గడియకేరున్ సుంనేంమిసా లజ్జన్ సెర్పతెర్ అలుంఙ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","అదుఙి రాజక్ రగ్గుంఙ్ వత్ తన్నె సైనీయమ్మున్ పవిడుత్, ఆ కరాబ్ మన్కన్ అల్ఙుంత్, ఔర్ పట్నమున్ కిసిడుత్. ");
INSERT INTO nit_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","అప్పుడ్ అముదు, తన్నె గడియకేరున్ పెండ్లి జెవొన్ తయార్ అండాద్ గని అన్ కుగ్తెనా గడియెంఙ్ సలేతెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","అదుఙి నీర్ నడుంపవుత్ సెత్ నీర్ ఇంకెన్తె కన్కెద్ద మందియొ సందీక్ పెండ్లిఙ్ జెవొనుఙ్ కుగ్నెర్ తన్నె తొరెనుంఙ్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ఆ గడియకెరె నడుమ్ పవుత్ సేత్ కరాబులున్, సోయ్ తరున్ తానుంఙ్ ఇంకెంతె మందినొ మిరప్తెంద్. ఆంద్ ఎల్ల సిమ్కన పెండ్లి జెవొనుఙ్ వత్తరున్ సాదరుని నింతిన్. ");
INSERT INTO nit_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","రాజక్ అత్తి ఉద్తెనా ఔరున్ ఓలెఙ్ లోప వతెంద్. అత్తి సెత్ జుఙ్ఙె తొడ్సెటా ఉద్దుత్ అనెకాంద్ ఒక్కొద్ అనుఙ్ కడ్కెదెంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","రాజక్ అంనడ్, సంఙ్త, పెండ్లి జుఙ్ఙె తోసెటా నీ లోపా ఎనంఙ్ వత్తి? ఇసా వెల్తెంద్. గని అముదు సురుమ్ అండెంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","అదుఙి రాజక్, ఇమ్నె గెట్టలున్, కెయ్యులున్ కట్టుత్ వాక సిర్మనత్ డగ్లిపుర్. అత్తి అముదు అర్ మూతి కత్ అంకంద్ ఇస తన్నె గడియక్ కుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","కుగెకద్ వింతర్ ఔర్ గుల్ మంది అండార్ గని నివ్డిప్తర్‍ కొన్సెం మందియ్. ");
INSERT INTO nit_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","యేసునున్ పరుసియు సెత్, యేసుంద్ అమ్నున్ ముడెఙ ఎదున్ బదోల్ పసిపెకాదా ఇసా విచార్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","అప్పుడు ఔర్ తమ్మె అనుసరలను కొన్సెం మంది సిసులున్ హేరోదు మన్కకెర్ వెంట అమ్మున్వై పవిట్టెర్. ఔర్ అమ్నడ్ “ఇడ్డెకని, నీ సత్తెం తా రిసా దెయ్యమ్నె మర్గం బరబర్ ఇడ్డెకాంద్, ఎరుని లెక్కకలెవ్ ఇసా, ఎంటది బెత్బవ్ ఓలిపే ఇసా అముంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","రొమ రాజక్ పన్ను సియ్యెకాద్ న్యాయమా? ఎందా? ఈ గొట్టిత్ బదోల్ ఇన్నె మన్ అముంఙ్ ఇడ్” ఇసా వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","యేసుంద్ వెంటాని ఔరె కరాబ్ విచార్ ఒర్కిల్ “కప్టి మన్కరెర్, అన్ తానుంఙ్ వెతొల్సర్? ");
INSERT INTO nit_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","పన్ కట్టెంఙ్ కొత్ తా దెనార ఒక్కొద్ అనున్ ఓలిపుర్” ఇన్తెంద్. ఔర్ అముదు దగ్గరికి ఒక పన్ను దేనారం తోడవత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","అముదు “ఇదున్ పొయ్ అనెకా బొమ్మ, అక్సెరా ఎరె” అదా అమ్నున్ వెల్తెంద్. ఔర్ “అదా రోమ రాజకున్” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","అపుడ్ తప్పెతెర్ అముదు వెంటని “అనగ్ ఎంద్దె రొమ రాజక్నె రాజుఙి, దెయ్యమి దెయ్యమున్ సియ్యుర్” ఇసా ఔరడ్ ఇడ్డెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ఔరె గొట్టిన్ వింత్ కమల్ ఎందెర్ అమ్నను సాయుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","అద్ది దీనం, తిక్తరున్ ఔరున్ తిక్తార్ బత్కెకర్ ఇడ్డెకా సద్దుకియ్యు అమ్నున్‍ వై సేత్, ");
INSERT INTO nit_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“బొద ఇడ్డెకంద్ ‘ఒక్కొ మన్కక్ పొకాకెర్ తొసేట తిక్తెంద్ అమ్నె తోరెంద్ అమ్నె మాసలున్ పాట్ ఇదర్ రుత్ తన్నే తొరెనుఙ్ పిల్లపడస్ ఎర్గలెంఙ్’ ఇసా మోసే ఇడ్డెంద్ తా.” ");
INSERT INTO nit_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","అమున్ ఒర్కిలుర్ అన్నక్ తోరెంద్ అన్నెర్. పేలెతంద్ పాట్లు ఎత్ పిల్లాపడ్ ఎర్సెటయ్ తిక్తెంద్ అమ్నె తొరెంద్ మాసలున్ పాట్లు ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ఇమ్‍దు రెండవ వలేంఙ్‍, మల్ల మూడవ వాలే మల్ల సాదరి అనఙ్ ఇదరుత్ తిక్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ఔర్ సాదరి మల్ల అద్ పిల్ల నయ్ తిక్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","తిక్ తార్ బక్కెర్ మల్ల సుల్తె ఆ ఏడ్గురె లోపా అద్ ఎరుఙ్ మాస ఎరద్ ఇసా వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","అదుఙి యేసుంద్ “ఇముంఙ్ లేకనమున్, దెయ్యమున్ సక్తి ఒర్కితొద్ అదుఙి నీర్ లగ్కిపడ్సాతిర.” ");
INSERT INTO nit_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","తిక్ తార్ బక్కెర్ జర్గిల్త మల్ల ఎరి పెండ్లి ఇదరెర్, పెండ్లి ఎర్గాలెర్ ఔరు పరలోకముత్ దెవదూత్లాఙ్ అంసార్. ");
INSERT INTO nit_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","తిక్ తార్ బక్కెర్ ఔరె పానం ఎరెకద్ ఎదె దెయ్యం, అన్ అబ్రాహామ్నె దెయ్యంనన్, ఇస్సాక్‍నె దెయ్యంనన్, యాకోబ్నె దెయ్యంనన్ ఇసా ఇడ్‍త గొట్టి నీర్ వసిపెతిరా? ");
INSERT INTO nit_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","తిక్ తార్ పానమ్ ఎదే దెయ్యం అన్ అబ్రాహామ్నె దెయ్యం, ఇస్సాక్నె దెయ్యం, యాకోబ్‍ దెయ్యం ఇసా ఇడ్త గొట్టి నీర్ వసిపెతిరా? అముదు బత్కుత్ అనెకరుంఙి దెయ్యం, తిక్తరుంఙ్ తోద్ ఇసా ఔరుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ఈ గొట్టికున్ వింత మంది అమ్నె ఇడ్డెకదున్ కమల్‍ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","అపూడ్ యేసుంద్ సద్దుకి య్యులె మూతికున్‍ బంద కతెంద్ ఇసా పరుసియు అమ్నున్‍ మెర వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ఔరతి నియమ్ సాస్త్రి మన్కక్ అమ్నునె పరిక్స సుమెంఙ్‍, వెలుత్ ఓలెకా ");
INSERT INTO nit_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","ఇడ్డెక నివ, నియమ్ సాస్త్రత్ పేలె దన్డి ఆగ్యలున్ ఎద? ఇసా వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","అమ్నుఙి యేసుంద్ ఇన్నె పూర మన్నుత్, పూర ఆత్మన్, పూర మంనడ్ ఇన్నె ప్రబు దెయ్యమున్ ప్రేమ్ కల్ఇనెకది. ");
INSERT INTO nit_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ఇద్ కిమ్తత్ ఆగ్యల్ తాద్, పేలెతంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ఇమ్మెత్ నిరి ఎత్తె ప్రేమ్‍ కత్తిరొ అంతె ఇమ్మె మెరతరున్ ప్రేమ్‌కల్ ఇనెకది రెండవ ఆగ్యనాయ్ అటది. ");
INSERT INTO nit_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ఇద ఇంది ఆగ్యలున్ మోసే నియమ్ సాస్త్ర పురాఙ్‍, ప్రవక్తకెరె వాయెకవుంఙ్ ఇద ఇంది ఆగ్యలెంఙి అదర్ ఎత్నఅన్సా. ");
INSERT INTO nit_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","పేన ఒక్కొసట్ పరుసియు ఒక్కొ జాగత్‍ మిరయుత్ అనెంఙ్‍, యేసుంద్ ఔరున్ ఇంన్తెంద్ “క్రీస్తున్ బదోల్ నీ తనెద్ ఇసాతి? అముదు ఎరె కీకె” ");
INSERT INTO nit_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","ఔర్ “క్రీస్తునె దావిద్నె కీకె” ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","అని దావిద్ అమ్నుంఙ్ దెయ్యమ్నె ఆత్మనడ్ ప్రబుంద్ తానుంఙ్ ఇడ్తెంద్? ");
INSERT INTO nit_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","నీ అన్నె ఉన్న పకంఙ్ ఉద్ ఇసా ప్రబుంద్ అన్నె ప్రబున్ ముట్టెద్ అదుంఎత్తి యేసుంద్, అన్ ఇన్నె విరోద్ ఇన్నె గెటా బూడున్ ఇడ్‍నంత్తెంఙ్ ");
INSERT INTO nit_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","దావిద్ అమ్నున్ ప్రబువు ఇసా కుగ్గెంఙ అముదు అమ్నున్ ఏనంఙ్ కీకె ఏరతీ? ఇసా ఔరున్ వేల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","అముదు గొట్టిగ్ ఎద్దీ సమాదనం సియెంఙ్ సాలేతెంద్. అంత్తె ఎరెకడ్, ఆ దినంతన అమ్నుంఙ్ ఒక్కొ గొట్టినయ్ వెలుత్ ఓలెంఙ్ ఎరుఙి దైర్యం ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","అపుడ్ యేసుంద్ మందీనంతి, తన్నె సిసులున్ వెంట ఇనంఙ్ ఇంతెంద్, ");
INSERT INTO nit_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","నియంసాస్త్రంలెంఙ్ గురు, పరుసియు మోసేనె పిటలెంఙ్ సాస్త్రమున్ ఇడ్డెంఙ్ అదికార్ సుమ్ముత్ అండాంద్, ఇసా ఇడ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","అదిహి ఔర్ ఇమ్మడ్ ఇడ్డెకా అదా సిమ్కన వింత్ అడుగూర్. తే ఔర్ ఇదార్త పనిక్ మాత్రం ఇదరూర్ తానుంఙ్ ఇంతె, ఔర్ ఇడ్తవున్ ఇదరేర్. ");
INSERT INTO nit_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","కుంతెంఙ్ సలేర్ గని వెకమ్ మన్కకెరున్ పొయ్ ఇడ్సార్ గని అదవున్ కుంతెంఙ్ సంఙ్ తమ్మె సిట్కరె వెందెనడ్ గిన మదత్ కలెంఙ్ మనుంఙ్ కొరెర్. ");
INSERT INTO nit_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ఔర్ ఇదరెక పనిక్ మందిఙ్ కండ్కఎరెంఙ్ ఇసా ఇదార్సర్. తమ్మె కేయ్ పొయ్ వక్యలున్ వాయుత్ అనెక తల్లుత్ కట్టుత్ బత్కిపెకద్ దావ్వడ్, తమ్మె జుఙెలె బొగ్గ నెరప్ సార్. ");
INSERT INTO nit_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ప్రేమనాడ్ మిరయుత్ తినెకత్తి సోయ్ మన్నుంఙ్ అనెక జాగలత్తి యూదులె సావ్డిక్లెంఙ్ అనెంఙ్ ఇసా కోర్సార్. ");
INSERT INTO nit_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","అఙడి అనెకత్తి మాన్ సియ్యెకాంద్ లాఙ్‍, మందినె కెయ్యులాడ్ గురు, ఇసా కూగ్ గలెకద్ ఔరుంఙ్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","నీర్ మాత్రం గురు ఇసా కుగ్ గన్నేర్. సదార్ మందింఙ్ ఒక్కొది గురు. నీర్ సిమ్కన దాదకేర్. ");
INSERT INTO nit_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","పెన, బూమి పొయ్ ఎరుని బాంద్ ఇసా కూగెంఙ్ తోద్. పరలొకముత్ అనెక దెయ్యం ఒక్కొంద్ ఇమ్మె బాంద్. ");
INSERT INTO nit_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","అంతెయ్ తోద్‍గ, నీర్ మాల్కక్ ఇసా కుగ్ గన్నెర్. క్రీస్తునె ఒక్కొది ఇమ్మె మాల్కక్. ");
INSERT INTO nit_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ఇమ్మతి సదార్ మందిన్ దండి ఇముంఙ్ గడియక్ లంఙ్ అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","తన్నెత్ తాన్ దండి ఇదరెకనున్ సిన్నం కలెకాద్, సిన్నం కలెకదున్ దండి కలెకాద్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","అమ్మొ, నియమ్ సాస్త్ర గురు, పరుసియు, నీర్ కప్టి గునలకేర్. ఇమున్ సిక్స సుకిలెద్. తానుంఙ్ ఇంతె మన్కకెర్ పరలోక రాజ్యంముత్ సోఙెం నీర్ అడ్డం అండతిర్. ");
INSERT INTO nit_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ఔర్ రండెరాసికున్ తమ్మున్వై ఇదరుత్ అదవ్లె ఎల్లకున్ వెద్తదున్ వాలాడ్ ఇవ్రు గుల్ దండి పాప్ కత్తర్ ");
INSERT INTO nit_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","అమ్మొ, న్యాయ్ సబా సాస్త్ర గురు, పరుసియు, నీర్ కప్టి గునలకెర్. ఒక్కొ మన్కకున్ ఇమ్మతి కలపెంఙ్ సటీ నీర్ సందూర్, బూమిన్ తిర్గొరా వన్నంతె పని ఇదర్సతిర్. సితం అముదు ఇమంతి మిరైత్తతి అముదు ఇమఙ్ ఎన ఇందిఙ్ అంతూ నరకముత్ సిక్స ఇదర్సార్. ");
INSERT INTO nit_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","అయ్యో, గడ్డి మార్గదర్సకెలర, ఇముంఙ్ సిక్స సుక్కిలెంద్ నీర్ ఇసాతిర్ తా ఎరేనా దెయ్యమ్నె మందిరముంఙ్ జీమెదర్ సుంతే తనయ్ ఎరెద్ గని ఆ మందిరున్ వెంట్ బఙ్ఙర్ రుత్ జీమెదర్ ఇసా గొట్టి సియ్తేర్ గని అదున్ సుమ్ముత్ గెల్లెంఙ్ ఇసా నీర్ ఇడ్సతిర్. ");
INSERT INTO nit_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","బుద్ది తోసెటార! గుడ్డి అనెకార! బఙ్ఙర్, ఆ బఙ్ఙరున్ పవిత్ర ఇడ్డెకాద్ దెయ్యమ్నె మందిర్? ఏద్ దండి? ");
INSERT INTO nit_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","అనాయ్ బావ్ సియేక పీట తొడ్ గని ఒట్టు తప్తె తనయ్ ఎరెద్ గని, అదున్ పొదె అనెక బావ్ సియ్యెకాద్ తొడ్ అని ఒట్టు తప్తి వింతే మత్రం అదున్ సుమ్ముత్ అనెంఙ్ పాజె ఇస నీర్ ఇడ్సనండతిర్. ");
INSERT INTO nit_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","గుడ్డిక్లార! ఏద్ దండి? సియ్త వస్తు, అదున్ పవిత్ర ఇదరెక బావ్ సియేక పీట? ");
INSERT INTO nit_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","బావ్ సియేక పీట పొయ్ ఒట్టు ఇట్టె, అదున్ వెంట ఇసా, అదున్ వెంట అనెక అదా సిమ్కన్ పొయ్ ఒట్టు ఇడ్సనండార్. ");
INSERT INTO nit_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","అనాయ్ యూదులె మందిర్ పొయ్ ఒట్టు ఇట్టె, అదున్ వెంట అనెకంద్ అమ్నున్ ఒట్టు ఇడ్స నండాంద్. ");
INSERT INTO nit_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ఆబారున్ పొయ్ ఒట్టు ఇడ్నెంద్ దెయ్యమ్నె సింహాసన్, పొయ్ ఉద్దుత్ అనెక అద సిమ్కనన్ పొయ్ ఒట్టు ఇడ్సనండాంద్. ");
INSERT INTO nit_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","అయ్యో, నియమ్ సాస్త్త్రతా గురు, పరుసియు, నీర్ కప్టి గునలకేర్. ఇముంఙ్ సిక్స సుక్కిలెద్. ఇమ్మె పుదిన, సోపు, జిలకర్ర, పది అంసులద్ సియ్యుత్, గని నియమ్ సాస్త్రముత్ కరెత గొట్టిక్ న్యాయ్, కలెకారున్, కివ్ ఇనెకాద్ విస్వాసమున్ సయ్తెర్. దసమ బాగం సియ్యెకాద్ నేండుంఙ్ గిన ఇద్ అన్సంద్ ఇసా ఇదవున్ పాట్ కల్సననెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","పేలె గుడ్డిక్లుంఙ్ మార్గదర్సముత్ అనెకర్, నీర్ సిన్నం ఉమ్మె సుమ్ముత్ సాయుత్ దండి ఓటున్ మింఙెకర్ నీరి. ");
INSERT INTO nit_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","అయ్యె నియమ్ సాస్త్ర గురు లున్, పరుసియు, నీర్ కప్టి గునలకెర్. ఇమున్ సిక్స సుకిలెద్. నీర్ తాలి అని కొజాన్ వకా సక్కనా ఇదర్సతి గని లోప డొంఙ లంఙ్ అగం అసనడ్ నిండుత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","గుండి పరుసియు, తాలి, కొజా, పేలె లోప ఒడ్ ఇదర్. అపుడ్ అద గిన వకా సక్కనా ఎర్సద్. ");
INSERT INTO nit_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","అయ్యె, నియమ్ సాస్త్రీ గురు, లర పరుసియు ఇముంఙ్ సిక్స సుక్కిలెంద్ నీర్ కప్టి సునం దిట్త తప్నెలున్ లన్ అండతిర్. అద వక సొబతావి కన్కెర్స. గని, లోప తిక్తరె బొక్కాలడ్, ముర్గుత్ నిండుత్ అంసా. ");
INSERT INTO nit_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","అనాయ్ నీర్ గిన వకా అనెక మన్కకెరున్ నీతి తర్‍లంఙ్‍ కన్కెర్సర్. గని, నీర్ లోపా కరాబ్ పనిక్, కప్టి నాడ్ నిండుత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","అయ్యె, నియమ్ సాస్త్ర గురు, పరుసి మన్కకెర్, నీర్ కప్టి గునలకెర్. నీతి సిక్స సుకిలెద్. నీర్ ప్రవక్తకెరె తప్నెలున్ కట్సతిర్, ఇమన్ దరడ్ తప్నెలున్ రంఙ్ దిట్సతిర్. ");
INSERT INTO nit_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","అమీ గీన అమే పేలెనిత దొడా బత్కుత్ అండె ప్రవక్తకెర్ అల్ఙెకంద్ గొట్టి అవ్రుతీ కలయెకర్ ఎరెమ్ ఇసా ఇడ్స నండర్. ");
INSERT INTO nit_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","కరెయ్ నీర్ ప్రవక్తకెరున్ అలుంఙ్తెరె పొరకెర్ ఇమున్ పొదెని సాక్సం ఇడ్సనంసాద్. ");
INSERT INTO nit_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ఇంకతనెద్, నీర్ పెలెనితరె దొసులున్ నీర్ మొత్తం ఇదరెంఙ్ బాంద్కలూర్. ");
INSERT INTO nit_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","న్యాయ్ సబా “కరాబ్ గున లకెర్, పామ్నె కొవ్వెలర! నీర్ నరకమున్ ఎనంఙ్ గెల్లెంఙ్ సాలతిర్.” ");
INSERT INTO nit_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","అదుఙి నీర్ విండ్రు! అన్ ఇమున్ మెర ప్రవక్తకెరున్, బుద్ది అనెకర్, నియమ్ సాస్త్ర గురులున్ పవిడ్సతున్. నీర్ ఔరతి కొన్సెం మందీన్ అలుఙ్‍సర్. సిలువత్ కుడ్‍కెంఙ్. కొన్సెం మందిన్ ఇమ్మె యూదులె సావ్డిక్లెంఙ్ సట్లడ్ కుడ్సర్. మల్ల కొన్సెం మందిన్ ఊర్ తన ఔరున్ పుసుత్ ఎద్గసర్. ");
INSERT INTO nit_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ఇమన్ దారడ్ అనెకద్ హేబెలున్ నెత్తురడ్ మోదలిడుర్, నీర్ గుడి, బావ్ సియేక పీట అల్ఙుత్ జొపీట బరకీయ పోరక్ జెకర్యనె నెత్తుర్ ఎన్ ఈ బూమి పొదె అనెక నీతి దరులున్ నెత్తుర్‍నే ఉండ ఇమున్ పొదె వరద్. ");
INSERT INTO nit_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","అద సదర్ ఈ పడితర్ పొదెని వర్సద్ ఇస ఇమతీ కరెయ్ ఇడ్సతున్ ");
INSERT INTO nit_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ఏ యెరూసలేం, యెరూసలేం, ప్రవక్తకెరున్ అంలుత్, దెయ్యం ఇన్ మెర పవిట్టనున్ ఔరున్ గుండ్లడ్ కుడ్కుత్ అలఙెఙ, కోర్ తనే పిట్టలున్ ఎనంఙ్ తనె రెప్ప బూడున్ మిరపుత్ డాప్సదొ అదుంఙ్ ఎతి ఇనంఙ్ అన్ గిన ఇన్నె కొవ్వె గదిప్సాత్ ఇసా ఓల్తన్ గని నీ ఇస్టపడెతి. ");
INSERT INTO nit_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ఇందో, ఇండి ఇమ్మె గుడి ఇముఙి సియ్సనండతున్ ");
INSERT INTO nit_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","పంఙి తన నీర్ ‘ప్రబునె పేర్ రడ్ వరెకనున్ స్తుతి ఎరెంఙ్ ఇస’ ఇడ్నంతెత్ నీర్ అంన్ ఓలెర్ ఇస అన్ ఇమ్మడ్ ఇడ్సతున్” ");
INSERT INTO nit_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","యేసుంద్ గుడితన సెరెంఙ్‍, అముదు సిసులున్ ఆ గుడిన్ కట్తద్ అమ్నుంఙ్ ఓలిప్ తెర్. ");
INSERT INTO nit_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","అదుంఙ్ గి, నీర్ ఇదసదరున్ ఓలతిర్ తా. అన్ సత్తెం ఇడ్డెకద్ తానెద్ ఇంతె, ఇతి గుండ్ పొయ్ గుండ్ ఒక్కొద్‍ నై తోసెటా ఒద్రిల్ లెకాద్ ఎరద్ ఇసా ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","అముదు ఒలీవ మాక్ పొయ్ ఉదుత్ అనెంఙ్ సిసు అమ్నున్‍వై వత్న, నీ ఇడ్‍ తా ఎపుడ్‍ ఎదా? “ఇన్నె వరెకదున్, లొకముత్ ఆక్రి సిన్న అముంఙ్‍ ఇడ్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","యేసుంద్ ఔరున్ ఇనంఙ్ ఇంతెంద్, ఎరి ఇమున్ పసిపెంఙ్ తోద్ ఇసా ఉసరాడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","గుల్‍మంది అన్నె పేర్ రడ్ వత్న అని క్రీస్తునె ఇసా ఇడుత్ సిమ్కన మందిన్ పసిపతెర్. ");
INSERT INTO nit_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","గని నీర్ లాడెయులున్ లాడెయున్ వాలడ్ విసతిర్. అద వాలడ్ వర్తలున్ విసతిర్. అపుడ్ అదికలెంఙ్ తోద్. ఇద సదర్ జర్గిలెక తిరెంఙ్‍పాజె గని అంతె జల్దిని వరె. ");
INSERT INTO nit_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","మందిన్ పొదె మంది, రాజ్యం మున్ పొదె రాజ్ కలెక సుల్సా. అత్తి అత్తీ కరువు బుకంప వర్స. ");
INSERT INTO nit_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","పిల్ల పడ్సు జన్మిలెఙ కస్టెం వర్సదొ అనాయ్ మల్ల ఆక్రి దినాలుంఙ్ నాయ్ అనాయ్ కస్టెం వర్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","అప్పుడ్ మన్కకెర్ ఇంమున్ తక్లిబ్ హింస ఇదరెఙ, అలుంఙ్ సార్. అన్నె పేరడ్ మంది సిమ్కన ఇమున్ విరోద్ కల్సార్. ");
INSERT INTO nit_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ఆ కలముత్ గుల్ మంది వెన్కవై సర్కిల్సార్, ఒక్కొనెత్ ఒక్కొంద్ విరోద్ కల్సార్ ఒక్కొనెత్ ఒక్కొంద్ దుస్మంల్లు తయార్ కల్సార్. ");
INSERT INTO nit_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","పెర్రెత్ మంది నత్తి పైలి కబుర్లకెర్ వత్న గుల్ మందిన్ పసిప్సార్. ");
INSERT INTO nit_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","కరాబ్ పనిక్, ఎక్వ ఎత్నా అద్నె పలితమాడ్ గుల్ మంది నత్తి ప్రేమ్ కమ్మి ఎర్సద్. ");
INSERT INTO nit_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","గని ఆక్రిదూక్ ఎర్ ఇల్లుత్ అన్సారొ ఔరెతి బత్కిప్ తెంద్ ");
INSERT INTO nit_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","పరలోక రాజ్యం బదోల్ సోయ్త గొట్టి మందిన్ సిమ్కన దెసెం సాక్సం ఇడ్డెకద్ ఎరద్. సదర్ దున్యంఙ్ విన్కవర్సద్. ఎద్ద వెన్కత్ అదా సిమ్కన వర్సా. ");
INSERT INTO nit_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","అదుఙి దెయ్యం దానియేల్ ప్రవక్తకున్ వాలడ్ ఇడ్డుత్ గుల్ రిస్కాలేకాంద్ తా వస్తువు ఎనా గుల్ పవిత్రత జాగాత్ ఇల్లెకాద్ నీర్ ఓలెఙయ్ వసిపెకంద్ అర్తం కల్సాంద్, ");
INSERT INTO nit_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","అపుడ్ యూదియ దేస్త అనెక మంది మేట్వై తుల్ సెద్దేర్. ");
INSERT INTO nit_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ఎల్ల పొయ్ అనెకర్ ఎల్ల లోప వాత్ తనె నేన కొసెంఙ్ కోసీద్ కన్నేర్. ");
INSERT INTO nit_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","కేన్వై అనెకాంద్ తన్నె జుఙ్ఙె కొసెంఙ్ ఎల్లవై వరెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","అయ్యొ, ఆ దినా పిల్లకున్ పెట్టెనాడ్ అనెకావుంఙ్ అని పాల్ ఉర్తెక పిల్లంఙ్ కస్టం వర్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","అప్పుడ ఆ బాంద్ ఎదా. అదుంఙ్ ఎత్తి నీర్ తులెకా వెల టండి కలముత్ ఎకద్ ఆలపుసేక జీర్ ఎకద్ వరెంఙ్ తోద్ ఇసా పార్తన కలుర్. ");
INSERT INTO nit_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","తానుంఙ్ ఇంతె అంత్తెనడ్ దున్యత్ పెలెతన పంఙిదూక్ వరెతిన్ పెన ముదర్‍వై వరెద్. ");
INSERT INTO nit_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ఆ దినలున్ దెయ్యం కమ్మి కల్‍సెటా అండె సరీరాడ్ అనెకద్ ఒక్కొద్‍ నై సుకడిలెంఙ్ సాలెర్. తానుంఙ్ ఇంతె, అముదు నివ్డిప్తరున్ బదోల్ ఆ దినలున్ దెయ్యం బత్కిప్. ");
INSERT INTO nit_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","అపుడ్ ఆ కలముత్ ఎద్దెన, ఇమ్‌దొ, క్రీస్తునె ఇత్తి అన్సాద్, అత్తి అన్సాద్ ఇసా ఇడ్‍తె బరొస ఇడ్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","తానుంఙ్ ఇంతె పైలి క్రీస్తు, పైలి కబుర్లకెర్ వత్న, జమిల్తె దెయ్యమున్ నివ్డిప్తరున్ మొసం కలెంఙ్ సోయ్త కార్యి, గుల్ సిన్న ఓలిప్సార్. ");
INSERT INTO nit_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","విండ్ర ఇదవొ, ఇదసిమ్కన అన్ పేలెయ్ ఇముంఙ్ ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","అదుంఙ్ ఎత్తి ఎంద్ ఎన ఇమ్‌దొ, క్రీస్తుంద్ బటిత్ అన్సాద్ ఇసా ఇడ్‍తెనా, ఇమ్‌దొ, ఈ ఎల్లత కోలి లోప అన్సాద్ ఇసా ఇడ్‍తెనా నీర్ బరొస‍ ఇడ్‍నెర్. ఔరున్ వెంట సెనెర్. ");
INSERT INTO nit_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","మెర్‍పెకాద్ ఆబార్ పొయ్ పొద్ కురినా వాలాడ్ బుడిడుత్న పొద్ పడ్నావై తిర్‍సాదొ, అనాయ్ మన్కనె పోరక్ వారెకద్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","సెత్త్త్త ఎత్తి అంసాదొ అత్తిని రయ్యకె డిగ్సా. ");
INSERT INTO nit_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","ఆ బాద సిమ్కన ఎద్ద వెన్కత్ పొద్దున్ అడ్డమ్ ఎరద్ అని సిర్మనా ఎరద్. నెల వెలుంఙున్ సియసెట అందద్. ఆబార్ తన సుకా రల్‍దా. ఆబార్త సక్తిక్ నెరజడ్‍ ఎదా. సమత్కాల్ ");
INSERT INTO nit_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","అపుడ్ మన్కనె కీకెనె సమత్కర్ అబరుత్ కన్కెదా. అప్పుడ్ మన్కనె పోరక్ గుల్‍ దొడంద్ మహిమనడ్ ఆబార్‍ డమపొయ్ వరెకనున్ ఓలుత్, బూమి పొయ్ సక్తి అనెకా సిమ్కన జతిక్లా మంది సాక్కున్ కుడుక్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","అముదు సోయ్ వాజ దాండి వాన్సా తన్నె దూత్ లున్ పన్కసార్. ఔర్ ఆబార్త ఆములతన ఇముంలాఙ్‍ఎంత నాలి మూలలత్తన అముదు నివ్డిప్తరున్ దెయ్యం మిరప్సాద్ ");
INSERT INTO nit_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","మేడి మాక్ బదోల్ ఉపమానం కరపుర్. అద్నె కొమ్ము నిగ్రిడుత్ కొమ్ము పెర్గెంఙ్ ఉబ్బ డొయ్ కాలం మెరా వత్తిన్ ఇసా నీర్ ఒర్కిల్‍సతిర్. ");
INSERT INTO nit_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","అనాయ్ ఈ గట్నలున్ ఎరెకవున్ ఓల్‍తె అముదు ఇమున్ మెరయ్ కవాడ్ మెరమి అన్సాద్ ఇసా ఒర్కిలుర్. ");
INSERT INTO nit_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ఈద సదర్ ఎంనంత్తెంఙ్ ఇద జాతిక్ తిరే ఇసా అన్ ఇముంఙ్ సత్తెం ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","ఆబార్‍ బూమి డుబిలద్ గని అన్నె గొట్టిక్ ఎపుడి డుబిలె. ");
INSERT INTO nit_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","ఆ దినమ్, ఆ వెల ఎప్పుడొ బానుంఙి మాత్రం ఒర్కి గని ఏ మన్కకుగి ఒర్కి తోద్. ఆక్రింఙ్ పరలోకంత దూతులుంఙ్ అని పోరకుఙ్ నాయ్ ఒర్కితోద్. ");
INSERT INTO nit_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","నొవక్నె దినా ఎనంఙ్ అండెవొ మన్కనె పోరక్ వరెకా దినమ్‍నాయ్ అనాయ్ ఎర్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","జల్నిండుత్ వరెంఙ్ పేలె నొవక్నె రూకుత్ సెరెకా దినముంఙ్ ఎంత్, మన్కకెర్ తిసా, ఉసా, పెండ్లి కల్‍సా, సియుత్ వెల్స అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","జల్నిండుత్ ఔర్ సిమ్కన మందిన్ కొస్‍నంతెంఙ్ ఔరుంఙ్ కరిలెద్ అనాయ్ మన్కనె పోరక్ వారెకద్ ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ఆ దినముత్, కేనుత్ ఇద్దర్ మన్కకెర్ పని కల్సనండేర్, ఒక్కొనున్ కొసెకద్‍ ఎరాద్, ఒక్కొనున్ సాయెకద్‍ ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ఇరా పిల్లక్ తిర్గలుత్ పరయ్‍సా అండె, ఒక్కొ పిల్ల కొసెకద్‍ ఎరాద్, ఒక్కొదున్ సాయెకద్‍ ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","అదుఙి ఏ దినమ్ ఇమ్మె ప్రబుంద్ వర్‍సందొ ఇముంఙ్ ఒర్కి తోద్ అదుంఙ్ ఎత్తి ఉసారడ్ అండ్ర. ");
INSERT INTO nit_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","డొంఙ ఏ వెలుంఙ్ వర్సద్ ఎల్లత మాల్కకుంఙ్ పేలెయ్ ఒర్కి అండె అముదు ఉసరి అన్త డొంఙ్ కలెంఙ్ ఇడ్‍గలసెటా అందద్! ");
INSERT INTO nit_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","నీర్ పనొల్‍సెటా వేలలెఙి మన్కనె పోరక్ తల్లున్‍ వర్సద్ అదుంఙ్ ఎత్తి నిర్నాయ్ తయారెత్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","పంఙి ఒక్కొ మాల్కక్ తన్నె ఎల్లత్ పని కలెకనున్ వేలఙ్ అంబ సియెంఙ్ నెమిప్‍త నమ్మకమడ్ అన్నెక గడియక్ ఎంద్‍? ");
INSERT INTO nit_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","మాల్కక్ ఎల్లఙ్ వత్తె గడియక్ అనంఙ్ కలెకనున్ ఓల్‍సందో ఆ గడియక్ ఎంతె దన్యుడు. ");
INSERT INTO nit_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ఆ మాల్కక్ తన్నె రప్తిరలున్ పొయ్ ఆ గడియకున్ నెమిప్‍సాద్ ఇసా ఇముంఙ్ కరెయ్ ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","గని ఆ గడియక్ కరాబ్‍ అనెంఙ్ ఎద్దె, అన్నె ఆస్తిన్ మాల్కక్ కొర్‍మడ్ వర్సద్ ఇసా తన్నె మన్నుత్ ఇన్తన ");
INSERT INTO nit_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","తన్నె వెంట పని కలెకాంద్ సోయ్త గడియకెరున్ కుడుక్‍సా, జిఙ్ఙలకెర్ వెంట కలయుత్ తిసా ఉసా అండె, ");
INSERT INTO nit_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ఆ గడియక్ పవొల్‍సెటా దినములెంఙ్‍, ఒర్కి తోసెటా వేలంఙ్ అమ్నె మాల్కక్ వర్‍సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","అమ్నున్ తుక్డె కత్కుత్న కప్టి గునాలకెర్ వెంట అమ్నుంఙ్ సిక్స సియ్‍సాద్. అత్తి అరేకద్ పల్కుకొర్కెకద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","పరలోక రాజ్యం కలెక ఇనంఙ్ ఇడెంఙ్ వద్. పది మంది కువారి పిలక్ నొవ్రకున్ బెటెరెంఙ్ దీవేన్ సుముత్ సెన్నే. ");
INSERT INTO nit_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ఈ పది మందిన్ లోప సెయ తెలివి తోసెట, సెయ తెలివి అనెక. ");
INSERT INTO nit_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","తెలివి తోసెట జవన్ పిల్లక్ తమ్మె దీవెలున్ సుమ్‍తె గని తమున్ వెంట ఒలీవ నూనె సుముత్ సెరెతె. ");
INSERT INTO nit_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","తెలివి అనెక జవన్ పిల్లక్ తమ్మె దీవే వెంట సీసాలెంఙ్ ఒలీవ నూనె తొడ సెసర్. ");
INSERT INTO nit_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","నొవ్రక్ వారెకద్ కొరమ్ ఎరెక వెలంఙ్ ఔర్ సిమ్కన మంది తుర్సా మంఙ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","సర్సామాలె, ఇమ్‌దొ, నొవ్రక్ వర్సనంసాద్. అమ్నున్ ముండట్ సెర్ ఇనెక లేఙ్ విన్కవత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","అప్పుడ పది మంది కువారి పిల్లక్ సిమ్కన సులుత్ దీవెలున్ సవరిప్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","అప్పు తెలివి తోసెట, అమ్మె దీవే కిట్‍సానంస, ఇమ్మె ఒలీవ నూనె లత్రనట్ కొన్సెం అముంఙ్ నాయ్‍ సియసాతిరా? ఇసా తెలివి అనెకవున్ వెల్‍తె. ");
INSERT INTO nit_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","అప్పుడ్ అద, అంమత్తి అనెక నూనె నేండ్‍ ఇద్దరుంఙ్ పురలెద్‍ఎర, నీర్ సెత్న నూనె విరెక రత్త నూనె సుమ్ముత్ కొర్ ఇసా ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","అదా సుమ్మెంఙ్ సెరెంఙయ్ నొవ్రక్ వతెంద్. అప్పుడ తయార్ అనెక సెయ్యా జవన్ పిల్లక్ అమ్నున్ కలయుత్ పెండ్లి ఎల్ల లోప సెదె. వెంటాయ్ కవాడ్ గెద్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","అదుంఙ్ వెన్కత మిక్త కువారి పిల్లక్ వత్న, ప్రబు, ప్రబు, అముంఙ్ గుయున్ పుస్ ఇసా జోరనట్ వపొయ్‍తే. ");
INSERT INTO nit_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","గని అముదు, అన్ సత్తెం ఇడ్‍సాత్, నీర్ ఎరొ అనుంఙ్ ఒర్కి తోద్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ఆ దినమ్ ఆ వెల ఇముంఙ్ ఒర్కి తోద్ అదుంఙ్ ఎత్తి ఉసారడ్‍ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","పరలోక రాజం ఇనంఙ్ అన్సాద్, ఒక్కొ మన్కక్ దవ్ దేసెముంఙ్ సెత్ తన్నె గడియకున్ కూగుత్ తన్నె ఆస్తిన్ ఔరుంఙ్ సియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ఔర్ ఔరె సక్తి నడ్ ఒక్కొనుఙ్ ఐద్ హజర్ బఙ్ఙర్నె పైసె ఇకొక్కొనుఙ్ ఇంది హజర్ బఙ్ఙర్నె పైసె పెనఓక్కొనున్ ఒక్కొ హజార్ బఙ్ఙర్నె పైసె సియుత్, వెంటని సెదెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ఐద్ హజర్ సుంతంద్ అదవున్ విరుత్, ఇక్క ఐద్ హజర్ ఎక్వ కమప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","అనాయ్ ఇద్ది హజర్ సుంతంద్ అముదు ఇక్క ఇద్ది కమయ్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","పెన ఒక్కొద్ హజర్ బఙ్ఙర్నె పైసె సుంతంద్ సెత్న బూమిత్ పొక్క తౌవుత్ తన్నె మాల్కక్నె పైసెలున్ డాపుత్ ఇట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","పేలె సాల్కు ఎద్ద వెన్కత్ ఆ మాల్కక్ పెనా వతెంద్ తన్నె గడియకెరున్ ఇసొబ్ వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","అపుడ్ ఐద్ హజర్ పైసె సొంతంద్ పెన ఐద్ నుల్‍ కాలపుత్ మాల్క, గురు నీ అనుంఙ్ ఐద్ హజర్ పైసె సియ్తీ తా, అదా ఎరెకడ్ పేనా అన్ ఐద్ హజర్ కమ్పతన్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","అమ్నె మాల్కక్, సబ్బస్! నీ సోయ్త గడియక్! నీ ఈ చిన్నలెఙి నమ్మకమడ్ అన్సాంతి. అదుంఙ్ ఎత్తి ఇన్ ఎక్వ పనిక్ పొయ్ నెమిప్‍సాత్. ఇన్నె మాల్కక్నె కుసిత్ నీనాయ్ బగ్ సుమ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","అనాయ్ ఇంది హజర్ బఙ్ఙర్నె పైసె సుమ్తంద్ వత్న, మాల్క, గురు నీ అనుంఙ్ ఇంది హజర్ బఙ్ఙర్నె పైసె సియ్‍తడితా, అదవి ఎరెకడ్ అన్‍ పెన ఇంది హజర్ బఙ్ఙర్నె పైసె కమప్‍తన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","మాల్కక్ ఆహా! నీ సోయ్త గడియక్! నీ ఈ చిన్నలెఙి నమ్మకమడ్ అన్సాంతి. అదుంఙ్ ఎత్తి ఇన్ ఎక్వ పనిక్ పొయ్‍ నెమిప్‍సాత్ ఇన్నె మాల్కక్నె కుసిత్ నీనాయ్ బగ్ సుమ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","మల్ల హజర్ బఙ్ఙర్నె పైసె సుమ్‍తద్ వతెంద్. అముదు ఇంతెంద్, ప్రబు, నీ వితన తప్‍సెట జాగత్ పంట పుసెకని, తప్‍సెట జాగత్‍ పంట మిరపెంఙ్‍ ఓలెక మన్‍లకెరరా అనుంఙ్ ఒర్కి తా ");
INSERT INTO nit_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","అనుంఙ్ అర్సతెంద్, నీ సియ్‍త బఙ్ఙర్నె పైసెలున్ బూమిత్ తవ్వుత్ డపుత్ ఇట్టాడన్. ఇదావొ, ఇన్నె బఙ్ఙర్నె పైసె సుమ్‍ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ఆ మాల్కక్ అమ్నున్, నీ బొందడి! సుకడ్యిక గడియక్‍ని. అన్ వయ్‍సెట జాగతవున్ అర్కెకారన్, ఇడ్‍సేట జాగత్ పంటన్ మిరపుత్ ఇడ్డెకారన్ ఇసా ఇనుంఙ్ ఒర్కియ్‍ తా! ");
INSERT INTO nit_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","అనంఙ్ ఎదే నీ అన్నె బఙ్ఙర్‍నె పైసెలున్ దెడినడ్ సియెకన్‍వై ఇడెంఙ్ అండిన్. అపుడ్‍ అన్ వత్న అదున్ దెడికలపి సుమ్‍తనెరన్ ఇసా ఇడుత్, ");
INSERT INTO nit_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ఆహజర్ బఙ్ఙర్నె పైసెలున్ అమ్నతన వెలుత్న పది బఙ్ఙర్నె పైసె అనెకన్‍వై సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","గని అనెకా ప్రతి ఒక్కొనుంఙ్ సియెకద్ వరద్‍ తోసెట నత్తన అనెకదున్‍నై పుసెకద్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","పని పడ్‍సెట ఆ గడియకున్ వాక సిర్మనవై డగ్లిపుర్. అత్తి అర్రెకాద్ పల్కుకొర్‍కెకద్ అంసా. ");
INSERT INTO nit_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","అపుడ్ మన్కనె పోరక్ తన్నె మయ్మనడ, తన్నె దేవాదూత్ లడ్ వరెంఙ అముదు తన్నె మహిమనడ్ సింహాసన్ పోయ్ ఉదుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","సదార్ దెసెం తార్ మంది సిమ్కనన్ మిరపుత్ అమ్నున్ ముండట్ ఇల్పదర్. అప్పుడ ఒక్కొ గొర్రెలక్ తన్నె మందత మేకెలున్, గొర్రెలున్ అలది కత్తెతి. ");
INSERT INTO nit_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","గొర్రెలక్ తన్నె ఉన్న పకంఙ్ ఇమన్దలున్, ఎడమ పకంఙ్ బెయ్మన్లున్ అనెంఙ్ ఇసా అలది కత్న ఇల్పసాద్. ");
INSERT INTO nit_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","మల్ల రాజక్ తన్నె ఉన్న పకంఙ్ అనెకరున్ ఓలుత్న, అన్నెబాంద్ ఆసిర్వద్ సియ్‍తర్, వర్. దున్యత్ గడిలెంఙయ్ ఇముంఙ్ సటీ తయార్‍ కత్త రాజ్యం మున్ గెల్లుర్. ");
INSERT INTO nit_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","తానుంఙ్ ఇంతె అనుంఙ కర్వెదె నిరి అనుంఙ్ తినెంఙ్ సియ్‍తిర్. అన్ ఇరడుత్ అనెంఙ్ ఈర్ ఉనెంఙ్ సియ్‍తిర్. అదర్తోసెటంద్ అనెంఙ్ అస్ర ఎదిర్. ");
INSERT INTO nit_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","జుఙ్ఙె తోసెట డుండకి అనెంఙ్ అనుంఙ్ జుఙ్ఙె సియ్‍తి. దుకమడ్ అనెంఙ్ అన్ సొయ్‍కత్తి. జేలుత్ అనెంఙ్ అన్‍వై వత్న ముడ్‍గతీ ఇసా ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","అప్పుడ నీతి ప్రబు, ఎప్పుడ్‍ ఇన్ కర్వుత్ అనెకనున్ ఓలుత్ తిన్నెంఙ్ సియ్‍తమా? ఎప్పుడ్‍ ఈర్ తనున్ ఓలుత్ ఈర్ సియ్‍తమా? ");
INSERT INTO nit_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ఎప్పుడ్‍ అదర్ తోసెటనుంఙ్ ఓలుత్న ఆస్రకతమా? ఎప్పుడ్‍ డుడకిన్ ఓలుత్ జుఙ్ఙె సియ్‍తమా? ");
INSERT INTO nit_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ఎప్పుడ్‍ దుకమడ్ అనెంఙ్‍, జేలుత్‍ అనెకద్ ఓలుత్ ఇన్‍వై వత్నడమ్? ఇసా అమ్నున్ వెల్సర్. ");
INSERT INTO nit_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","అదుంఙ్ ఎత్తి రాజక్, ఇముంఙ్ కరెయ్ ఇడ్డెకద్ తనెంద్‍ ఇంతె, గరిబు ఇవ్ర అన్నెదాదకేర్‍ తన ఒక్కొనున్ ఇనంఙ్ కత్తె అన్ నాయ్‍ కత్తెతి ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","మల్ల అముదు ఎడమవై అనెకరున్ ఓలుత్, సపంఅనెకరార, అన్ సాయుత్ సెర్! బూత్ నుంఙ్ అద్నె దూతులుంఙ్ తయార్ కత్త ఎప్పుడి అనెక కిసుంఙ్ సెర్. ");
INSERT INTO nit_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","అనంఙ్ ఇంతె అనుంఙ్ కర్వెద్దె నీర్ అనుంఙ్ తినెంఙ్ సియెతిర్. అన్ ఈర్ అడ్డుత్ అనెంఙ అనుంఙ్ ఈర్‍సియెతీ. ");
INSERT INTO nit_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","అదర్ తోసెటర్ అన్నెంఙ అనుంఙ్ అస్ర కలెతి, జుఙ్ఙె తోసెట డుడకి అన్నెంఙ అనుంఙ్ జుఙ్ఙె సియెతీ. దుకమడ్‍అన్నెంఙ అన్ ఓలేతి. జేలుత్ అనెంఙ అన్‍వై వత్న ముడెతీ ఇసా ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","అదుంఙ్ ఎత్తి ఔర్నాయ్, ప్రబు, అమ్ ఎపుడ్‍ నీ కరువుత్ అనెకద్, యిరడుత్ అనెకద్, సేవక్ పరదేస్ అనెకద్, డుడకి అనెకద్, దుకమడ్ జేలుత్ అనెకద్ ఓలుత్ ఇన్ మదత్ కలెతన్? ఇసా వెల్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","అదుంఙ్‍ ఎత్తి రాజక్ కరెయ్ ఇడ్డెకద్ తన్నెదింతె, నీర్ గరిబు ఎద్ద ఈ సంఙ్తకేర్ తన ఒక్కొనున్ ఇనంఙ్ కలెన్ అదుంఙ్ ఎత్తి అన్‍ నాయ్ కత్తెతి ఇసా ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ఇవ్రు ఎప్పుడి సిక్స, నీతి తిక్తవై పానం అనెకవై సెదర్. ");
INSERT INTO nit_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ఈ గొట్టికున్ యేసుంద్ ఇడ్‍తెహె, అముదు తాన్నె సిసులున్ ఇనంఙ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","పస్క పండ్గుంఙ్ ఇంక ఇంన్నా అన్సాద్ ఇసా ఇముంఙ్ ఒర్కి అన్సాద్. మన్కనె పోరకున్ సిలువత్ కుడ్‍కెంఙ్ ఇసా అన్న సుముత్ సియ్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ఆ వెలంఙ్ కయపక్ ఇన్నెకా పుడరి దెయ్యలకెర్ ఎల్లత్‍, దొడా, దెయ్యలకెర్, బార్స కలైతేర్‍. ");
INSERT INTO nit_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","అన్‍ ఇరుగ్గునాయి ఎరక్‍ తొస్సెట యేసును ఎనఙ్ సుముత్న హల్గెకద్ ఇంతె కరాబ్‍ విచ్చర్ కల్సర్. ");
INSERT INTO nit_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","గని అవుర్ ఇస్సర్ పండుగ్ దినముల్లుగు నేండ్ అనఙ్ కాలేకద్ తొంద్ కత్తమింతే మన్కకెర్‍ లోప గడ్‍బడ్‍ ఏరద్. ");
INSERT INTO nit_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","మల్ల యేసును బేతనియ ఊర్త కుస్టి దుక్కమ్‍తన సోయ్ ఎద్దా సీమోన్నె ఎల్లత్ తినెఙ్ ఉద్దుత్ అనెఙ. ");
INSERT INTO nit_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ఒక్కొద్ పిల్ల తెల్లొడి గుండ్నె సిసాత్ నిండుపత్ గులెన దరతద్ అత్తర్ నునెన్‍ కొత్న, సిసాన్ ఓలుత్న యేసునె తల్పొయి పెయిత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","గని సిసులున్ అదున్ ఓల్సర్ అని రగ్గడ్ ఇసార్. తనుంఙ్ ఇదున్ కరాబ్‍ కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","అద్ అత్తర్ నునెన్ ఎక్కువ పైసెలుంఙ్ విరుత్న గరిబులుంఙ్ సియెంఙ్ అండిన్‍. ");
INSERT INTO nit_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","గని యేసుంద్ అదున్ ఒర్కిలుత్న ఔరున్ ఇస్సాంద్. ఇద్ పిల్లఙ్ తానుంఙ్ తక్లిబ్ సియిస్సాత్తిర్? తనుంఙ్ ఇంతే ఇద్ పిల్ల అనుంఙ్ ఒక్క సొబత్ పని కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","తనుమఙ్ ఇంతే గరిబు ఎప్పుడి ఇమున్ వెంట అస్సార్ గని అన్ ఎప్పుడి ఇమున్ వెంట అనేన్. ");
INSERT INTO nit_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","అనుంఙ్ పరిపేంఙ్ సేస్స అండేర్ గని ఇద్ పిల్ల అనే మెన్‍ అత్తర్ నునేన్ పెయ్యితిన్. ");
INSERT INTO nit_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","అని అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్ సట్టం దున్యత ఎత్తి అత్తి ఇద్ సొయ్త కబుర్ దెయ్యమ్నె సోయ్త గొట్టిన్ ఇడ్సర్ అత్తి ఇద్ పిల్లన్ హద్ది కత్న అద్ కత్తదున్ ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","మల్ల బార మందినలోప ఒక్కొంద్ ఇస్కరియోత్ యూదక్ ఇనేక బర్స దెయ్యలకెర్వై సేస్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","అని ఇస్సాంద్ యేసున్ అన్ దండి యజకులుంఙ్‍ సుమ్ముత్ సియ్తె నీర్ అనుంఙ్ తనేన్ సియ్సతిర్? అని ఔర అమ్నుంఙ్ తీస్ వేండి పైసె సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","అని ఆ దినంతన అముదు యేసునున్ అవ్రే కెయ్యుత్ సుముత్ సియెంఙ్ ఇస్సా మొక ఓల్స అన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","సాదే నిప్పల పండ్గుంఙ్ ముడట దినముగు సిసులున్ యేసుకున్‍వై వత్న ఇస్సార్. నీవ్ పస్కపడగ్నె జేవును కాలేకాద్ అమ్ ఎత్తి తయార్ కాల్‍ ఇస్సాతివ? ");
INSERT INTO nit_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","అముదు ఔరున్ లోప ఒక్కొ మన్కక్ సెత్ అమ్నున్ ఇండ్రు. అంమే గురు ఇడ్స నంస్సాద్. అనే దినమ్ వత్తిన్ అన్ అనే సిసులున్ వెంట పస్కపండగ్నె తినేకాద్ ఇనే ఏల్లత కాల్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","యేసుంద్; ఏనంఙ్ ఇడ్సద్ అనాయ్ అమ్నె సిసులున్ కాల్సర్. అని ఔరున్ పస్కపండుగ్నెత్‍ తినేకాంద్ తయార్ కాల్సర్. ");
INSERT INTO nit_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","సింతేవేల్ల వతెంద్, యేసున్ బరా సిసులున్ వెంట తీనెంఙ్ ఉద్ తెద్. ");
INSERT INTO nit_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ఔర్ తినెంఙ్ ఉద్దుత్ అనెంఙ్ యేసున్ ఇస్సాన్. సత్తెం అన్ ఇముంఙ్ ఇడ్సత్ ఇమునులోప అన్ సుమ్మత్ సియ్సంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ఔర్ సట్టం గులేన నారాజ్ ఎదేర్ అని ఒక్కొనుంఙ్ వెన్క ఒక్కొంద్ ఇనేఙ్ ఎద్దెర్ ప్రబు అన్ ఏందునా? ");
INSERT INTO nit_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","అముదు ఇస్సాద్ అన్ను వెంట కొజా తనే కేయ్యున్ ముప్పెకాన్ అముదు ఎన్నెంద్ అన్ను సుమ్ముత్ సియ్యెకాంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","మన్కనె పోరక్ అన్ బదుల్ సాస్త్రత్ ఎనఙ్ వాయ్యుతుఅస్సద్ అనఙ్ అన్ సెరెంఙ్ పజే గని ఎరే కేయ్యడ్ అనేత్ సుమ్ముత్ సియ్యెకాంద్ ఎద్దాంద్ అమ్నుంఙ్ ఎంత్తె సిక్స వర్సద్. అముదు పుట్సెటండే సోయ్ ఏత్తన్నంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","అని యేసున్ సుమ్ముత్ సియ్యెకాంద్ యూదక్ ఇసాంద్. గురు అన్ ఎందున? యేసుంద్ ఇస్సాంద్. ఇంనే మన్నుత్ అనెకాదున్ నీవ్ ఇడ్‍తి. ");
INSERT INTO nit_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","మల్ల ఔర్ తిస్సఅనేగ్న, యేసుంద్ నిప్పటేన్ సుముత్న దన్యావద్ సియ్యుత్న ముర్తెంద్ అని సిసులున్వై సియ్యుత్న ఇసాంద్. ఎకుర్ అని తిండ్రు ఇద్ అన్నె మెన్‍ ఏంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","మల్ల అముదు అంగుర్ రస నిండ్పతా గిలసున్ సుముత్న దన్యావద్ ఇండుత్న అవురుంఙ్ సియ్యుత్ ఇసాంద్. ఇదున్ లోప అనెకాదున్ నీర్ సట్టమి ఉడ్రు. ");
INSERT INTO nit_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ఇంతే అనే ఇదర్తా దెయ్యమ్నె కరార్ ఇది అన్నె నెత్తురున్ ఇద్ అంగుర్‍ రాస్స ఇడ్సనంస్సాద్. పేరేత్ మన్కకేరే పాపులున్ కండిపేకదుంఙ్ వల్లడ్ కుల్పత అనే నెత్తుర్ ఏంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","అన్‍ ఇముంఙ్ ఇడ్సత్. అనే బాంద్ దెయ్యమ్నెత్ రాజ్యం త్ అన్ కత్ తా అంగుర్నె రసాన్ ఇమున్ వెంట ఉందుత్న అదా దినలేంఙ్ ఇంతే అంగుర్న రాసాన్ ఉస్సాతొతేంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","మల్ల ఔర్ స్తుతిపాట పడుత్‍ ఒలీవ మేట్వయి సేద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","మల్ల యేసుంద్ ఔరున్ ఇసాద్. ఇనేడ్ సింతే నిర్‍ సట్టం అన్‍ సాయుత్ సేరతిర్. గని సాస్త్రత్ ఇనంఙ్ వాయ్యుత్ అన్సాంద్. గొర్రెలాంఙ్ అన్ తక్లిబ్ సుముదున్. అని గొర్రెల్ ఇదే అదే ఎర్స. ");
INSERT INTO nit_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","గని అన్‍ తిక్కుత్ సుల్తె వెన్కత్ ఇముంఙ్‍ ముండట్ గలిలీయ బర్సంఙ్ సేరతుమ్. ");
INSERT INTO nit_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","పేతురుంద్ ఇస్సాంద్. ఇన్ సాటంసాయుత్న సేద్దెర్ గని అన్ ఇన్ సాయుత్ సెరెన్ ఇస యేసుంద్ సమాదనం ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","యేసుంద్ పేతురున్ ఇస్సాంద్. అన్‍ ఇనుంఙ్ సత్తెం ఇడ్సత్. ఇనెడ్‍ సింతే పోత్ కూగెంఙ్ పేలె అముదు అనుంఙ్‍ ఓరికి తోద్. ఇనంఙ్ ముద్ది గుస్సాల్ ఇద్దతి ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","పేతురుంద్ ఇస్సాంద్. అన్‍ ఇన్ వెంట తిక్సత్ గని ఇమ్‌ది ఓరకి‍ తోద్ ఇస్సా అన్ ఇన్ ఇడ్డెన్. అని సిమన సిసులున్ అనాయి ఇడ్నేర్. ");
INSERT INTO nit_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","మల్ల యేసుంద్ గేత్సేమన్ ఇనేక జగ్గగ ఔర్ వెంట సెస్సన్. అముదు తనే సిసులున్ ఇసాద్ నీర్ ఇత్తి ఉద్దుత్ అండ్రు అన్ అయ్ సెత్న పార్తన కాల్సత్. ");
INSERT INTO nit_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","అముదు తన్‍వెంట పేతురుంద్ జెబెదయి యినే పోరకేర్ యాకోబ్‍ అని యేహన్ కొస్తెంద్. మల్ల అముదు నారాజ్ ఎత్న సింబిలేంఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","అని అముదు ఔరున్ ఇసాంద్. అనె ఆత్మన్ తిక్కెకద్‍లంఙ్ గుల్లెన నారాజ్ అన్సాంద్. అన్ వెంట ఇత్తి అండ్రు అని అన్ వెంట ఉసరడ్ అండ్ర. ");
INSERT INTO nit_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","అని కొన్సెం ముండట్ సేత్ తన్ బొల్లా పడుత్న ఇనంఙ్ పార్తన కాల్సంద్. అన్నె బాంద్ దెయ్యం ఎంద్ ఎరతే ఇద్ తక్లిబ్ అనంతన కురియుత్‍ సెకాద్. గని అన్ అన్నె మన్తద్ తొంద్. ఇనే మన్తద్ ఎక్కద్. ");
INSERT INTO nit_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","సిసు మెర వత్న, ఔరు తుర్రెకారున్ ఓలుత్నా ఔరున్ అన్‍ వెంట మిరయుత్‍ ఒక్కొ గంట దెకుల్ ఉసారడ్ అనేంఙ్. సాలేరా? ");
INSERT INTO nit_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","నీర్ పరిక్సత్ పడెంఙ్ తోంద్ ఇత్న ఉసారడ్ అండ్రు అని పార్తన కలూర్. ఆత్మంఙ్ కారే అస అన్సాంద్. గని సరీరాడ్ కమజొర్ అస్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","మల్ల యేసుంద్ అత్తి సెత్ పార్తన కాల్సద్ అన్నె బాంద్ దెయ్యం ఇద్ తక్లిబుంఙ్ అన్ బొగిల్తా సివాయ్ ఇద్ అంన్ తన సేరెంద్ ఎర. ఇన్నె మన్తద్ ఎక్కద్. ");
INSERT INTO nit_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","మల్ల వాత్ ఔరు తుర్రెకారున్ ఓల్సాంద్ ఔవ్రె కండ్ల గుల్లెన సిన్న ఎత్నా అండే. ");
INSERT INTO nit_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","అముదు ఔరున్ సాయుత్ సేద్దెంద్. మల్ల అదా గొట్టిక్ ముద్దిగుసాల్ ఇడుత్న పార్తన కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","మల్ల యేసుంద్ సిసులున్వై వాత్న ఇడతేద్ నీర్ ఇంక మడ్డియుతి అస్సాతిర్ ఓలుర్. మన్కనె పోరక్ పాపులుంఙ్ కేయ్యుత్ సముత్ సియ్యెక దినం వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","సుల్లుర్ నేండ్ సెన్నెర్ ఓలుర్ అన్ సుముత్ సియ్యెకాద్ మెరం వాత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","యేసును ముడ్సఅనెంఙ్‍ బార మంది సిసులున్ లోప ఒక్కొంద్ యూదక్ ఇనేకంద్ వత్తంద్ అమ్నున్ వెంట బర్స దెయ్యలకెర్ అని మన్కనే మన్‍వలె పన్క తా దండి గార్దిత్ తల్వర్‍ అని టేగ్రిక్ సుముత్ వర్సద్. ");
INSERT INTO nit_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","యేసున్ సుమ్ముత్ సియ్యెకాన్ ఔరుంఙ్ ఒక్కద్ సమత్కర్ ఇడ్సన్ అన్ ఏరును ముద్ ఇడ్సత్ అముదు యేసుంద్ ఎన్నెంద్. అమునున్ బరాబర్ సుమ్ముర్. ");
INSERT INTO nit_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","యూదక్‍వత్న జల్లిది యేసునున్‍ సేత్న జై గురు ఇత్న ముద్దు ఇంటేద్ ");
INSERT INTO nit_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","యేసుంద్‍ అమ్నున్ ఇస్సాద్. సంఙ్త నీ తగలెంఙ్ ఇసాతివొ ఇసా అమ్నున్ ఇడెంఙ్‍ ఔరున్‍ మెర వత్న అమ్నున్ అరిపుత్ సుంతెర్‍. ");
INSERT INTO nit_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","జల్ది జల్ది యేసును వెంట అనెకర్ లోప ఒక్కొంద్ వర్సన్ తల్వరును పుస్తున్ పుడారి దెయ్యలకెరె గడియకున్ దానుపుతు అమనే కేవును పుతేద్. ");
INSERT INTO nit_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","యేసుంద్ అమ్నున్ ఇస్సాన్. ఇనే తల్వరును అదనే జాగత్ఇడ్. తల్వరును వాడేకార్ తల్వరడ్ నాస్టం ఏద్దర్. ");
INSERT INTO nit_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","అన్ అనే బాంన్ దెయ్యమున్ వింతి కత్తెదింతే. అద్ బార మంది గుమ్పులే సైనిక్ ఎక్కువ దూతులుంఙ్ పవిడుత్న నేడున్ సాబడిప్ద ఇస్సా ఇముంఙ్ ఒర్కి తొతేద్? ");
INSERT INTO nit_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","గని అన్‍ అనఙ్ కత్తనితే. ఇదవ్‍ సట్టం గొట్టికులు ఎరేఙ్ పడ్సద్ ఇస్సా సాస్త్రత్ వాయ్త లేకనమున్ ఏనఙ్ కరే ఎద్దద్? ");
INSERT INTO nit_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","మల్ల యేసుంద్ మన్కకేరే గారిదిత్ గాదియ్‍తేద్. డొగ్గన్ సుమేకారలాంఙ్ తల్వరసిల్, టేగ్రిక్ కొరుతు అనును సుమేకాదుగు కురుయుతు వర్సర్ అర్దినంఅన్ గుడిత్ ఉద్దుత్న ఇముంఙ్ కారప్స అనేగ్న నీర్ అనును తనుంఙ్ సుమేతిర్ ");
INSERT INTO nit_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","అనును బదులు ప్రవక్త లె వాయ్యుడు లేకనమున్ సట్టం కరే ఏరేంఙ్ ఇసా ఇదవ్‍ లేకనమున్ ఏర్సనస్సవ్‍. అని అమనే సిసులున్ సట్టం అమదును సాయుత్న తుట్టెర్. ");
INSERT INTO nit_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","యేసున్ సముడు మన్కకెర్ అమదును పుడారి దెయ్యలకెర్ కయపక్ ఇనేకనత్తిన్ కొసార్. అత్తిన సట్టం నియం సాస్త్ర గురు మన్కకెర్ మన్‍వలె మిరయుత్ అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","గని పేతురున్‍ యేసున్ వెంట దౌతన, దొడా దెయ్యలకెర్ ఎల్లతా బోయ్దఙెంత్ సేసాంద్. మల్ల అమ్మున్ లోప సేత్, తనేద్ ఎద్దద్ ఎన ఓలెఙ్ ఇస్సా మందిరిత సిప్పాయిల్‍ వెంట ఉత్సన్. ");
INSERT INTO nit_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","బార్స దెయ్యలకెర్ అని మిరయుడు బార్స మన్వలేల్ న్యాయసబతర్ సట్టం యేసుకును అల్ఙేఙ్ ఇస్సా పకట్ సాక్సములున్ వల్లడ్ కిరవ్నేర్, ");
INSERT INTO nit_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","గని ఔరుంఙ్ తనయ్ రొబ్బడేత్తిన్. గులేన పకట్ సాక్సమ్ వల్లెల్ సుముతు వత్తెర్ గని ఔరుంఙ్ తానయి గునా రొబ్బడేత్తిన్ ఆకారి ఇద్దర్ మన్కకేరును సుముతు వత్తన్. ");
INSERT INTO nit_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","తనేర్ దెయ్యమ్నె మందిర్ ఇదును అన్ కసిప్తన్ ముద్దిఙ్ దినాలుంఙ్ ఇప్సతును అనఙ్ ఇమ్ద అనెకనున్ అమ్ విత్తమ్. ");
INSERT INTO nit_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","అపుడు దండి దెయ్యలకెర్ ఇల్లుత్న యేసున్ వేలుత్ ఓల్తన్న ఔర్ ఇముంఙ్ విరోద్ ముడస్సర్ ఇద్ తనేద్ ఎద్ జావబ్ సియెకదుంఙ్ తనయ్ తొతేద్. ");
INSERT INTO nit_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","గని యేసు క్రీస్తుంద్ సురుమి అండెంద్ అని పుడారి దెయ్యలకెర్ అమ్నున్ ఇసాన్‍. నివ్ దెయ్యమ్నె మనవాలె దెయ్యమ్నె పోరక్ ఎన్నివ్. పానం అనెక దెయ్యమ్నె పేరడ్ అన్ ఇన్ వేలుతోల్సాత్‍ అదును అముగు ఇడ్. ");
INSERT INTO nit_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","యేసుంద్ అమ్నున్ ఇసాంద్. నివ్ ఎనఙ్ ఇడత్తివ్ అనయి గని అన్‍ ఇనుంఙ్ ఇడ్సత్ ఇదుంఙ్ ముండట్ పూర సక్తి తందనే ఉన్నా పక్కఙ్ మన్కనె పోరక్ అన్ ఉందుతు అనెకనున్ ఓలతిర్ అని సేరేకాద్ తన ఆబార్ డమ్మ వెంట వారేకానున్ ఓల్త్తిర్. ");
INSERT INTO nit_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","అపుడ్ పుడారి దెయ్యలకెర్ రగ్గవారుతు తనే జుఙ్ఙెలును ఇరక్తన్ ఇసాన్‍. ఇమద్ దెయ్యం బద్నం అన్ అస్సతును ఇసా దెయ్యమ్నె బద్నం కాల్సనస్సన్ తనుంఙ్ నేండుంఙ్ ఇంక గావదర్లున్ వల్లల్ పని తోతెద్? ");
INSERT INTO nit_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","నీర్ తనేద్ ఇత్తిర్ ఔర్ ఇసార్? ఔర్ ఇసార్. అముదు తిక్కెఙ్ పడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","మల్ల ఔర్ అమ్నే మొకముత్ ఎవుర్ ఊస్తెర్ అని బుక్కిక్లాడ్‍ దనప్తేర్ అని కొన్సెం పెల్లె సియ్యితేర్. ");
INSERT INTO nit_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","అని ఇసార్ క్రీస్తునె ప్రవక్తక్ పుదుతు ఇండ్ ఎంద్ ఇంన్? కుడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","మల్ల పేతురుక్ బోయ్ద వాడత్ ఉద్దుత్న అనేన్ ఒక్కొద్ గడియాక్ దొడా వాత్ ఇసాద్. అముదు గలిలీయ త్ యేసున్ వెంట నివ్ నాయ్యి అండి. ");
INSERT INTO nit_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","అని అముదు ఔర్ సట్టమున్ ముండట్ తొంద్ ఇంత్ నీర్ తనేంద్ ఇత్తిర్ అద్ ఇముంఙ్ తోతెద్ ఇసాన్. ");
INSERT INTO nit_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","అని అముదు బొయ్దతన వాకహ సేద్దె మల్ల ఒక్కొద్ రాప్తిరాల్ అమదును ఓలుత్న అదును మేర్రం ఇల్లుత్న అనెకారున్ మల్ల ఇండ్తిన్. నజరేత్ తంద్ యేసును వెంట ఇమద్ మన్కనై అస్సాన్. ");
INSERT INTO nit_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","అముదు మల్ల తోద్ ఇస్సాన్. అని కబులి మన్కక్ అనుగు ఏరక్‍తొతెన్, ఇస్సా పుడుకుత్న ఇండ్తేన్. ");
INSERT INTO nit_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ఒక్కొజామ్ లోప మల్ల, మేర్రం ఇల్లుత్న అనెకర్ పేతురున్‍వై వత్ ఇస్సార్. సత్తెం అమనే సిసులున్ వెంట నినాయ్‍ అండి. అముగు ఏరక్‍ అన్సాంద్. తనుంఙ్ఇంతే నీవ్ గలేలియతర్ మడెకదలంఙ్ ముడుస్సాత్తివ్. ");
INSERT INTO nit_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","మల్ల అముదు అన్‍ పకట్ ముట్టమింతే, దెయ్యం ఓల్సద్ ఇసా. నీవ్‍ ఇండేకాదున్ బదోల్ అనుంఙ్ ఒర్కి తోతెద్, ఎన్ అముదు ఒట్టు ఇడ్నేంద్ పోత్ కూగెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","అని పేతురు యేసును ఇండత గొట్టి అదివత్తిన్ నీవ్‍ పోత్ కూగెంఙ్ ముండట్టి నీవ్‍ అన్న ఒర్కితొద్ ఇసా ముద్దిఙ్ గుసాల్ ఇస్సాతి. మల్ల అముదు వాక కురిత్ నారాజ్ ఎత్న అర్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","మల్ల తొల్లిని పొద్‍ కురియెఙాయ్, సిమ్కన బార్స దెయ్యలకెర్ అని మన్కకెరె మన్‍వలె మిరయ్‍తెర్ అని యేసునున్ అల్ఙేఙ్ విచార్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","అని ఔర్ యేసునున్ సుమ్‍తెర్ అని రొమి రాజ్‍పాల్ పిలాత్‍నె కెయ్యుత్ సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","యేసునున్ సుముత్ సియ్‍ తా యూదక్, యేసునున్ అలంఙెంఙ్ సిక్స ఇసా ఒర్కిలుత్న గులెంన మన్ బద్లిపుత్ సెద్దెంద్. అని ముపై చందినె కల్దలున్ బార్స దెయ్యలకెర్వై అని మన్‍వలె వై కొస్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","అని ఇంతెంద్, దొస్ తోసెట నెత్తుర్‍నే మన్కకున్ అన్ సుముత్ సియ్యుత్ పాప్ కత్తన్. గని ఔర్ ఇంతెర్, అముంఙ్ అద్ తానెద్ ఎందె? నీ అమ్నుంఙ్ జిమ్మెదార్ అన్సాంతి. ");
INSERT INTO nit_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","యెవుదాక్ ఆ కల్దలున్ గుడిత్ జొపిడుత్. సెత్న అముదు పాసి వెల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","గని బార్స దెయ్యలకెర్ ఆ కల్దలున్ పెతుత్న ఇంతెర్, గుడిత దన్‍ సాదొకత్ ఇదవుంన్ నియం సాస్త్ర ప్రకార్ తాపెంఙ్ తెయ్యెదా. తానుంఙ్ ఇంతె ఒక్కొ మన్కన్ అల్ఙెకంద్ ఇసా సియ్‍త ఎంన్నె. ");
INSERT INTO nit_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","మల్ల ఆ పైసెలున్ కుమరినె కెనున్ సుమెంఙ్ ఇసా ఔర్ విచార్ కత్తెర్. ఆ జాగాత్ మరొక్కొ మన్కకెరున్ పుర్‍పెక తప్‍నెలె జాగా కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","అదుంఙ్ ఎత్తి ఇన్నెడ్‍దూక్ ఆ జాగా నెత్తుర్‍నే జాగా ఇసార్. ");
INSERT INTO nit_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","అనాయ్, సిసు ప్రవక్త యిర్మీయా ఇడ్త గొట్టిక్ కరె ఎద్దె, ఔర్ ముపై చందినె కల్దలున్ సుమ్‍తెర్. ఇస్రాయేల్‍ మన్కకెర్ అమ్నున్ అంత్తె కిమ్మత్ ఇసా వాయ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ఎనంఙ్ ప్రబు ఔరుంఙ్ ఇడ్‍తెద్, అనాయ్ ఆ పైసెలున్ ఔర్ కుమరినె కేనున్ సుమ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","మల్ల యేసునున్ దొడంద్ రాజ్‍పల్ ముండట్ ఇల్‍ప్తెర్ అని ఆ యేసునున్ ఇంతెర్. యూదు మన్కకెరె రాజక్ నీ ఎన్ని వా ఇసా యేసుంద్ ఇంతెంద్ నీ ఎనంఙ్ ఇసాతి అనాయ్. ");
INSERT INTO nit_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","గని బార్స దెయ్యలకెర్ అని దొడా అమ్నున్ పొయ్ దొసి టైరిప్తెర్, అముదు సురుమి అండెద్. ");
INSERT INTO nit_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","మల్ల పిలాత్ అమ్నున్ ఇంతెంద్, ఔర్ ఇన్న పొయ్ పేలె గున తపుత్‍ అంసార్, అదున్‍ నీ వినెతి వా? ");
INSERT INTO nit_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","గని అముదు తనయ్ ఒక్కొ గొట్టినయ్ ఇడ్డెతెంద్. పిలాత్ కమల్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","సాలుంఙ్ వాలండన్ పడ్గ వాకతుంఙ్ కొడప్‍తర్ లోప మన్కకెరె మంతనున్ ఒక్కొనున్ కైదిన్ సాయ్ ఇసా రాజ్‍పల్ ఔరుంఙ్ సటీ సాయ్‍నెద్. ");
INSERT INTO nit_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ఆ సాలుంఙ్‍, బరబ్బ యేసు ఇన్నెక పేర్తంద్ మన్కక్ కొండలుత్ అండెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ఆ దినముంఙ్ పిలాత్నె వాడిత్ మన్కకెర్ మిరయ్యుత్ అనెంఙ్‍, అముదు ఔరున్ ఇంతెంద్ బరబ్బ తొదా మన్‍వలె ఇన్నెక యేసుంద్ క్రీస్తునె ఇవ్రు ఇద్దర్ లోప ఎనున్ సాయెంఙ్ ఇసాతిర్? ");
INSERT INTO nit_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","తానుంఙ్ ఇంతె అముదు ఒర్కిల్‍ తెంద్, ఔర్ రగ్గడ్ యేసునున్ తాన్నె కెయ్యుత్ సుముత్ సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","అపుడ్‍ పిలాత్ న్యాయ్‍పీట ఉదుత్‍ అనెంఙ్ అమ్నె మాస అమ్నుఙ్ నీతి సియ్‍తిన్: ఆ ఇమాన్‍దారి మన్కన్ తానయ్ కన్నెమ్. తానుంఙ్ ఇంతె ఇనెడ్‍ సింతె అమ్నున్ బదోల్ కాల ఓలుత్న తర్సిల్‍తన్. ");
INSERT INTO nit_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","బార్స దెయ్యలకెర్ అని మన్‍వలె మన్కకెరె మందిన్ సాడిపుత్‍ సియుత్న అయ్ ఇన్నగాత్తెంర్, బరబ్బ కున్ సాయుర్ అని యేసునున్ అల్ఙెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ఆ పిలాత్ ఔరున్ పెన వేల్తెంద్, ఈ ఇద్దరున్ లోప ఎరున్ ఇముంఙ్ సటీ సాయెంఙ్ ఇసాతిర్? ఔర్ బరబ్బ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","పిలాత్ ఔరున్ ఇంతెంద్, అన్ అనంఙ్ కత్త నింతె, మాన్‍దర్ ఇనెకహ యేసు క్రీస్తునె అన్ తాగలెకాద్? ఔర్ సదర్ ఇంతెర్, అమ్నున్ సిలువత్‍ కుడుకుర్. ");
INSERT INTO nit_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","మల్ల పిలాత్ ఇంతెంద్, తనుంఙ్‍, ఇమ్‌ద తా కరాబ్ పనిక్ కతెంద్? గని ఔర్ గుల్ వాపొయ్‍తెర్, అని అమ్నున్ సిలువత్ కుడుకుర్, ఇసా ఇంతెర్, ");
INSERT INTO nit_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","గడ్‍ బడ్ పెరెత్ ఎర్స నన్సంద్ అని అముదు తనయ్ కలెంఙ్ సాలెంద్ ఇసా పిలాత్ ఒర్కిల్తెంద్. అమ్నుంఙ్ సటీ ఇమ్‌దు మన్కకెర్ ముండట్ తన్నె కెయ్యున్ ఈరడ్ ఒడుత్న ఇంతెంద్, ఇమ్నున్ అల్ఙెకంద్ దొస్ అన్ పొయ్ వారెంఙ్ తోద్. నీర్ అమ్నుంఙ్ జబబ్దార్ అన్సాంతిర్. ");
INSERT INTO nit_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","సిమ్కన మన్కకెర్ ఇంతెర్. అమ్నున్ అల్ఙెకంద్ దొస్ అముంన్ పొయ్ అని అమ్మె పోరకేరున్ పొయ్ వాక్కద్. ");
INSERT INTO nit_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","అదుంఙ్ ఎత్తి పిలాత్ బరబ్బ కున్ ఔరుంఙ్ సటీ సాయ్‍తెంద్ అని యేసునున్ లాగ్గమడ్ లగహపుత్న సిలువత్ కుడ్‍కెంఙ్ ఉకుంమ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","మల్ల రాజ్ పల్నె సిపయిక్ కొన్సెం మంది యేసుకున్ సిపయ్‍లె పుడరినె వాడంఙ్ కొస్తెర్ అని సిమ్కన సిపయిక్ యేసుకున్ తిర్‍గొర ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","అమ్నున్ రాజక్ ఇసా సడిప్స అమ్నె జుఙ్ఙె పుస్తెర్ అని ఎరొడి రంఙ్త పొడమ్ జుఙ్ఙెలున్ తొడ్పతెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","అని ఔర్ సాల్ల కొమ్ములాడ్ టొపి అలుత్న అమ్నె తల్లుత్ తొడ్పతెర్ అని అమ్నె ఉన్న కెయ్యుత్ ఒక్కొ రెకా కొలన్ సియుత్న, అమ్నున్ ముండట్ ముడుసు టెకిపుత్న, అమ్నున్ టింగల్ కత్న ఇంతెర్. యూదు మన్కకెరె రాజకున్ జయ! ");
INSERT INTO nit_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","అమ్నె మోకముత్ ఎవుర్ ఊస్‍తెర్ అని రెకా కొలన్ సుముత్ అమ్నె తల్లున్ లగప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","అమ్నున్ టింగల్ కత్తె, ఔర్ తొడ్పత దండి జాగన్ పుస్తెర్ అని అమ్నె జుఙ్ఙెలున్ అమ్నుంఙ్ తొడ్పతెర్ అని అమ్నున్ సిలువత్ కుడ్‍కెంఙ్ కొస్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ఔర్ సెరెంఙ్‍, వాకకురెంఙ కురెని ఇనెక సీమోన్ ఇన్నె మన్కక్ ఓలుత్న అమ్నున్ జబర్‍దస్తి సిలువన్ కాజుత్న. ");
INSERT INTO nit_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ఔర్ గొల్గొతా మంజె, తాల్త టొపుర్కె ఇనెకహ జాగాంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","మల్ల ఔర్ అమ్నుంఙ్ సెద్‍నె కలప్తహ అంగుర్‍నె రసాన్ ఉనెంఙ్ సియ్‍తెర్. గని అముదు అదున్ సవ్వి ఓలుత్ ఉనెంఙ్ ఇసాల్సెటా సురుమ్ అన్నేంద్ ");
INSERT INTO nit_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","అని ఔర్ యేసునున్ సిలువత్ కుడ్కతెర్ అని జుఙ్ఙెలుఙ్ సటీ సిట్టిక్ తపుత్ తాముంఙ్ పైతెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","మల్ల అవ్రుర్ అత్తి ఉదుత్న కయ్‍స అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","అమ్నె తల్ల పొయ్ ఒక్కొ పట్టెత్ అమ్నె గున పత్రన్ ఇనంఙ్ వయ్‍తెర్, యేసుంద్ యూద మన్కకెరె రాజక్. ");
INSERT INTO nit_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","మల్ల అమ్నున్ వెంట ఇద్దర్ డొంఙ్ లున్ నాయ్ కుడ్కతెర్. ఒక్కొనున్ ఉన్న పకంఙ్ అని మల్ల ఒక్కొనున్ ఎడమ పకంఙ్ ఇసా ఔరున్ సిలువత్ కుడ్‍కెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","మల్ల అపావ్ సెరెకర్ వారెకర్ అమ్నె బద్నం కత్న తమ్మె తాల్కులున్ మెలప్సా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ఎ, మందిరున్ ఓద్‍రిపుత్న ముడొలుఙ్ ఇల్‍పెకని ఎన్నివా? నీ దెయ్యమ్నె పోరక్ ఎన్నివ్ ఎరత్తె, సిలువా తన్న డిగ్గుత్ వా ఇన్నెత్ నీ బత్కిప్. ");
INSERT INTO nit_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","అనాయ్, బార్స దెయ్యలకెర్, నియం సాస్త్ర గురు మన్కకెర్ అని మన్‍వలె అమ్నున్ డవరి కల్స ఇన్నెర్, ");
INSERT INTO nit_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","ఇమ్‌ద మరొక్కొరున్ బాత్కిప్‍తెంద్ గని సొతన్ బత్కిప్ సాలెంద్? ఇమ్‌ద ఇస్రాయేల్‍ రాజక్ ఎటె. ఇమ్‌ద సిలువ తన్న డిగ్కంద్. మల్ల అమ్ ఇమ్నున్ పొయ్ బరొస ఇడెంఙ్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ఇమ్‌ద దెయ్యం పొయ్ బరోసా ఇట్ అడద్. దెయ్యముంఙ్ ఇమ్‌ద పాజె ఎర్ర, అద్ వత్న ఇమ్నున్ సొడపెకాదా. తానుంఙ్ ఇంతె ఇమ్‌ద ఇమ్మత్ తంద్ ఎన్నెంద్. అన్ దెయయంన్నె పోరక్ నాన్ ఎందున్. ");
INSERT INTO nit_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","అనాయ్ అమ్నున్ వెంటా పాసి సియ్‍తర్‍ నాయ్ అమ్నున్ బాద్నమ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","పాతె బార గంట తానా ముడు గంటలుంఙ్ ఎత్ జాగపొయ్ సిర్మనా ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ముడు గంటలుంఙ్ యేసుంద్ జోరానట్ వాపొయ్‍తెద్, ఎలయి ఎలయి లామా సబక్తానీ మంజె అన్నె దెయ్యం, అన్నె దెయ్యం తానుంఙ్ అన్ సాయ్‍తీ? ");
INSERT INTO nit_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","అపుడ్ మెరా ఇలుత్ అనెకర్ అమ్నెత్ విత్న ఇన్నెర్. విండ్ర, సందేస్టక్ ఏలీయాక్ కున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ఔర్ లోపా ఒక్కొద్ జాల్ది తుటెద్ అని రుయ్యున్ పుల్లె రసాత్ ముంపుత్న రెకా కొలాత్ సికిపుత్న అమ్నుంఙ్ ఉముర్సెంఙ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","గని కొన్సెం మంది ఇంతెర్. అమ్నున్ సాయ్. ఏలీయాక్ వత్న అమ్నున్ సొడ్పదాద్ అదున్ నేండ్ బత్కిప్. ");
INSERT INTO nit_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","మల్ల యేసుంద్ పెనా జోరకత్న వపొయ్‍తెద్ పానం సయ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ఆ వెలంఙ్ గుడి తా పాడ్ద ఇరియుత్న పొలడ్ బుడుండ్ ఎంత్ ఇద్ది తుక్డె ఎద్దిన్. బూమిత్ మెల్గతిన్ అని మోట్టా తా గుండ్ల ఓడ్‍తే. ");
INSERT INTO nit_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","అపుడ్ తప్నె పర్గతే అని పేలెటర్ తిక్ తార్ పవిత్ర మన్కకెరె మెడ్లు పెనా పానమడ్ సుల్తే. ");
INSERT INTO nit_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","యేసుద తిక్తతన సుల్‍తాతీ, ఔర్ తప్నె తానా కురియుత్న పవిత్ర పట్నం యెరుస్‍లెముంఙ్ సెత్న పేలెటర్ మన్కకెరుంఙ్ కండ్కెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","సైనిక్లె దొడంద్ అని అమ్నున్ వెంటా యేసునున్ కాయ్యతా మన్కకెర్, ఎద్ద ఈ గొట్టికున్ అని బూకంపలున్ ఓలుత్న గుల్ అర్సనెం. కరెయ్ ఇమ్‌ద దెయ్యమ్నె పోరక్ అన్సాద్. ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","అత్తి పెల్లెటా పిల్లక్ అండే. అదా గలిలీయ బార్సంఙ్ వత్తే అని అమ్నే సేవ కన్నే. యేసుంద్ దావ్ ఇల్లుత్న ఇద్వున్ ఓల్‍తే. ");
INSERT INTO nit_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ఆదా లోపా మగ్దలేనే మరియక్, అని యాకోబ్‍ అని యోసేప్ ఇవ్రె అమ్మ మర్యీ, అని జెబెదయి క్నె మాస, మంజె యాకోబ్ అని యోహాన్ ఇవ్రె అమ్మ అండే. ");
INSERT INTO nit_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","సిత్తె వేలా అరిమతయి ఉర స్రిమంతక్ యోసేప్ ఇన్నెకంద్ వతెంద్. అముదు నాయ్ యేసుక్నె సిసుద్ ఎత్ తా అండెద్. ");
INSERT INTO nit_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","అముదు పిలాతున్వై సెత్న యేసుక్‍నె సెత్ తాన్ వెల్‍తెద్. మల్ల పిలాత్ అమ్నుంఙ్ మెన్‍ సియెంఙ్ ఇసా ఉకుంమ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","అని యోసేప్ మెన్‍ సుముత్న తెలొడి సక్కనా జుఙ్ఙెనాడ్ అదున్ గుడ్పతెద్. ");
INSERT INTO nit_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","అని తనుంఙ్ సటీ కత్త కొత్త కన్నకత్త గుండ్‍ తా తప్నెత్ ఇట్టెద్. తప్నెనె బొయ్‌దన్ ఒక్కొ దా దండి గుండ్లున్ డగ్లిపుత్ గెద్తెంద్ అని కురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","మగ్దలేనే మరియక్‍ అని మరొక్కొద్ మరియక్ ఇదా ఇరా తప్నెలున్ మెరా ఉదుత్ అంత్ ఓల్‍తే. ");
INSERT INTO nit_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","మరొక్కొ జీర్, ఆలపుసేక జీర్ బార్స దెయ్యలకెర్ అని పరుసి మన్కకెర్ పిలాతున్ ముడ్‍ట్ మిర్ యతెర్. ");
INSERT INTO nit_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","అని ఇంతెర్. ప్రబు, అముదు పసిపెకద్ పానం అనెంఙ్ అన్ ముండొలుంఙ్ పెనా పానమడ్ సులాత్ ఎరాత్ ఇసా అముదు ఇడ్త గొట్టిక్ అముంఙ్ అది వత్తె. ");
INSERT INTO nit_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","అదుంఙ్ ఎత్తి సిపయిక్ ముడొల్ అమ్నె తప్నెన్ కయ్యెంఙ్ ఇసా ఉక్కుమ్ సియ్‍ తొద్‍త్తె అమ్నె సిసులున్ వాత్న అమ్నె సెత్ తాన్ డొంఙ కదర్ అని కొసుత్ డపుత్ ఇడ్‍దర్, మల్ల అముదు తిక్తతన సుల్‍తెంద్ ఇసా వాపొయ్‍దార్. ఇనంఙ్ ఔర్ ఆక్రింఙ్ పసిప్తెర్ ఇంతె అద్ద ఔరె పెలెతదుంఙ్ ఎన బెకర్ అందాద్. ");
INSERT INTO nit_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","పిలాత్ ఇంతెంద్ “కయ్యెకర్ అన్డర్ తా నీర్ సెత్ ఇమ్మె సక్తి మేర సమదికట్టుర్ సోయ్ ఇదారుర్” ఇసా ఔరుఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ఔర్ సెత్న గుండుత్ ముద్ర తప్పెంఙ్ తప్నెన్ కాయెకనున్ నెమిప్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ఆలపుసేక జీర్ ఎద్ది నింత్తె, ఐతరం జీర్ మగ్దలేనే మరియక్ అని మరొక్కొ మరియక్ తప్నెన్ సెదెహె. ");
INSERT INTO nit_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","అపుడ్ గుల్ దండి బుకంపం ఎద్దిన్. తనుంఙ్‍ ఇంతె ప్రబుక్నె దూత్ పరలోకం తన్నా డిగుత్ వత్నా తప్నె తా మూతిత్‍ గెతుత్ అనెక గుండున్ డగ్లిపుత్నా అదున్ పొయ్ ఉద్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","అద్నె మోకమ్ మెర్‍పెకద్‍లంఙ్‍ తరియుత్ అని అద్నె జుఙ్ఙె బర్పలంఙ్ గుల్ తెలొడిక్ అండ్డె నా. ");
INSERT INTO nit_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","అదున్ ఓలుత్నా సిపయిక్ అరస్తెంద్ వాడక్తెర్ అని తిక్ తార్ లంఙ్‍ ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","గని దెవ దూత్ పిల్లకున్ ఇంత్తిన్. అర్సనెం. తానుంఙ్ ఇంతె అనుంఙ్ ఒర్కి అన్సాద్: సిలువత్ కుడ్కత యేసునున్ నీర్ కిర్వ సా నంసాతిర్. ");
INSERT INTO nit_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","అముదు ఇత్తి తొతేద్. తనుంఙ్‍ ఇంతె అముదు ఎనంఙ్‍ ఇడ్‍తెంద్ అనాయ్ సుల్‍తెంద్. నీర్ ఇట్ట జాగన్ వత్త ఓలుర్. ");
INSERT INTO nit_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ఇండ్డి నీర్ జల్‍ది సెత్నా ఇమ్నె సిసులుంన్ ఇడ్డుర్. యేసుంద్ తిక్తతన సుల్తెంద్ అని అముదు ఇముంఙ్‍ ముండట్టి గలిలీయ సెసానంసాద్ అని నీర్ అమ్నున్ అత్తి ఓలతిర్. విండ్ర, పగియ్ అన్ ఇముంఙ్‍ ఇడ్తన్. ");
INSERT INTO nit_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ఆ పిల్లక్ అరస్తెంద్ గుల్‍ కుసినడ్ తప్నె తన్నకురియ్తె అని తుల్సని సిసువై సెద్దె. ");
INSERT INTO nit_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","అద సెరెంఙ్, వెంటాయ్ యేసుంద్ అదవుంఙ్‍ బెట్ ఎదెద్ అని ఇంతెంద్. సుకమడ్ అండ్ర. అద అమ్నున్వై వత్తె అని అమ్నె గెట్ట సుముతన్న అమ్నె కాల్ మొక్తె ");
INSERT INTO nit_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","మల్ల యేసుంద్ అదవున్ ఇంతెంద్. అర్సనెం. నీర్ సెతన్న అన్నె దాదకున్ గలిలీయ సెరెంఙ్‍ ఇడుర్. అత్తి అన్ అవ్ఉన్ బెటిలత్. ");
INSERT INTO nit_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","మల్ల పిల్లక్ పావడ సెద్దె. కొన్సెం మంది సిపాయిక్ పట్నం లోప సెత్నా ఎద్ద సదర్ ఈ గొట్టికున్ బార్స దెయ్యలకెర్ రుంఙ్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","దండి దెయ్యలకెర్ మన్‍ వాలెలున్ మిరప్‍తెర్ అని గొట్టి కత్తెర్ అని సిపాయికుంఙ్ పేలె పైసె సియుత్నా ఔరున్ ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","నీర్ ఇనంఙ్‍ ఇడ్డెంఙ్. సింత్తె అమ్ మంఙుత్ అనెంఙ్‍, అమ్నె సిసు వత్నా అమ్నున్ డొంఙ్ కత్త కొస్తెర్ ఇసా ఇడ్డుర్. ");
INSERT INTO nit_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","పౌలుంఙ్ ఈ గొట్టిక్ ఒర్కి ఎద్దె, అమ్ ఇముంఙ్‍ సటీ అయ్ ఇన్నగాల్సాతుమ్ అని ఇముంఙ్‍ తక్లిబ్ వారెంఙ్‍ ఇడెమ్. ");
INSERT INTO nit_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","అదుంఙ్ ఎత్తి సిపాయిక్ పైసెలున్ సుమ్తెర్ అని ఔర్ ఎనంఙ్ ఇడ్‍తెర్ అనాయ్ ఔర్ కత్తెర్ అని ఇండి దూక్ అద్ కత్త యూదు మన్కకెర్ లోప నెరయ్‍స నంసాద్. ");
INSERT INTO nit_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","మల్ల అక్రా మంది సిసు యేసుంద్ ఔరుంఙ్‍ ఇడ్త గలిలీయత మెట్వై సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ఔర్ అమ్నున్ ఓలుత్ అమ్నె గెట్ట మొక్తెర్ గని కొన్సెం మంది సెక్ సుమ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","మల్ల యేసుంద్ ఔరున్వై వత్నా ఇంతెంద్. పరలోకముత్ అని బూమిత్ సదర్ అదికార్ దైయ్యం అనుంఙ్ సియుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","అదుంఙ్‍ ఎత్తి నీర్ సెత్నా సాటం జాగల మంది సిసు లాంఙ్ కాలుర్. తక్ దెయ్యమ్ అని పోరక్ యేసుదనే పవిత్ర ఆత్మనె పేరడ్ ఔరుంఙ్‍ బాప్తిస్మ సియుర్. ");
INSERT INTO nit_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","అని అన్ ఇముంఙ్‍ ఇడ్త సాదరి ఉకూమ్ గొంట్టికున్ పడిపెంఙ్ ఔరుంఙ్‍ కారాపుర్. అని ఈ లొకముత్ ఆక్రి కిస్సెకా కలముంఙ్ దూక్ అన్ ఇమున్ వెంట అంసాత్.");
INSERT INTO nit_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","దెయ్యమ్నె పోరక్ యేసు క్రీస్తున్ బదోల్ సువార్త మొదల్ఎరేకాద్. ");
INSERT INTO nit_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","యెసయక్ తొల్లె పుస్తకూత్ ఇనంఙ్ వయ్‍తెర్. ఇమ్‍దు‍ అన్నె కబుర్లకూన్ ఇనుంఙ్ ఎనంఙ్ మూడటి పన్కతెంద్‍. అమ్దు ఇముంఙ్ సటీ పావ్‍ తయార్ కత్నఇట్టేంద్. ఇసా దెయ్యమ్నె కీకెన్ వెంట ఇడ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ఒక్కొ మన్కక్ వపొయ్‍సంద్ ప్రబునే పావ్‍ సొయ్‍ కలుర్ అమ్నె పావున్ సార్కక్ కలుర్ అని బట్టిత్ వాపొయెక ఒక్కొలెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","అనంఙ్ కబుర్లకెర్ వాపొయ్‍తెతి అముదు‍ బాప్తిస్మ సియెకన్ యోహాన్ బట్టిత్ ఇడ్స కత్త పాప్ లున్‍ ఒప్పుత్ మన్ బద్లిపుర్ బాప్తిస్మ సుమ్‍తెరింతె ఆ పాపులె మాపి రొంబాడద్ ఇసా అముదు గొట్టి ఇడ్సానంసాద్. ");
INSERT INTO nit_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","తె యూదియ యేరియ తన అని యెరూసలేం ఆజుబాజు తన పేలెటర్ మన్కకెర్ వత్న ఔర్ తమ్మె పాప్ ఒప్త వెన్కత్ యోహాన్ అముదు యోర్దన్ గంఙత్ ఔర్ సిమ్కన మందిన్ యోహానున్వై వత్న మనున్ బద్లిపుత్న యోహాన్ కెయ్యడ్ యోర్దన్ గంగత బాప్తిస్మ సుమ్‍తెర్ ");
INSERT INTO nit_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","యోహాన్ ఓట్నె బూరడ్ తయార్ కత్త. జుఙ్ఙె ఊర్నేంద్ అని తోలడ్ తయార్కత్త పట్ట ముల్కెత్‍ తొడ్నేంద్. అముదు మింటె అని తెనే తిసా బత్కనేంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","అముదు యోహాన్ అనుంఙ్ ఎన దండి సక్తితంద్ వెన్కత్ వారేకాంద్ అన్సాంద్. అమ్నే గెట్టల కెర్రిక్లె పట్టలున్ నాయ్ అన్ ఉడ్పెంఙ్ పని సియెన్ ఇసా బోద ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","అన్ ఇమ్ముంఙ్ ఈరడ్‍ పవిత్ర ఇరుత్ ముల్పుత్ సియ్‍సనన్‍సాత్ గని అనుంఙ్ వెన్కత్ వరెకాద్ దెయ్యం పవిత్ర ఆత్మనాడ్ బాప్తిస్మ సియ్‍నెంద్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ఆ కాలముత్ యేసుంద్ గలిలీయ నజరేత్‍ యోహానున్ తన్నా వత్న యోర్దన్ గంఙ్ఙత్ బాప్తిస్మ సుమ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","అనంఙ్ బాప్తిస్మ సియుత్న యేసుంద్ ఈర్‍తన వాక వరేఙాయ్‍ ఆబార్ వాక్కెలెత్న పరలోకమ్ తన దెయ్యమ్నె పరిసుద్దత్మ ఒక్కొద్ పారెవలఙ్ యేసున్ పోయ్ డిగ్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","ఇసా పరలోకమ్ తన ఒక్కొలేంఙ్ విన్కువత్తిన్ అపూడ్‍ యేసుకున్ నీ అన్నె లాడ్త పోరక్ని ఎన్ని. ఇన్‍వాలాడ్‍ అన్ ఎంతెయో కుసినడ్ అన్సాంత్. ");
INSERT INTO nit_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","అద్‍ ఎద్ద వెన్కత్ వెంటని దెయ్యమ్నె ఆత్మ యేసున్ బట్టింఙ్ పన్కతీన్. ");
INSERT INTO nit_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","అత్తి నాల్‍పైదిన జన్వర్‍లుంఙ్ నడుమ్ అనెంఙ్. సైతన్‍ యేసుకున్‍వై వత్న పరిక్స కల్సా నీ దెయ్యమ్నె దూత్ అమ్నె సేవ కల్సానన్నేద్. ");
INSERT INTO nit_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","యోహానున్ జేలుత్ తప్త వెన్కత్. యేసు గలిలీయ వత్న దెయ్యం రాజ్త సువార్త ఇడ్సా ఇనంఙ్ ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","అముదు, దెయ్యమ్నె రాజ్యం వర్సనంసద్. ఆ టయ్ముంఙ్ మెర వత్తిన్. మన్ బద్లిపుర్ సొయ్త సువార్త నమ్ముర్ ఇస ఇడ్డెంఙ్ మొదలిట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","యేసు గలిలీయ సమ్దుర్త డర్డినాడ్‍ యేసుంద్ అడగ్సా అనేఙా సీమోన్ అని అన్నె తోరెంద్ అంద్రెయక్ జల్‍తప్పుత్ కయ్యేసుమ్మెంఙ్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","యేసు, అన్ వెంట వర్ అన్ ఇమున్ మన్కకేరున్ సుమ్మెక దీవరిక్లాంఙ్ తయార్ కల్సత్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ఔర్ అద్ గొట్టిన్ విత్న వెంటని ఆ జాల్లున్ సాయుత్న యేసుక్నే సుముత్నఅడ్గేంఙ్ ఎద్దేర్. ");
INSERT INTO nit_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","అమ్దు కొన్సెం ముందర్‍వై సెద్దేంద్ తె జెబెదయి నేంద్ యాకోబ్‍ అని యోహాన్ తోరెంద్ రూకుత్ పొదె జాల్లున్ సుద్రిప్‍సా అనెకర్ కన్కెదెర్. ");
INSERT INTO nit_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","యేసుంద్ ఔరున్ ఓలుత్న కూఙ్ తెంద్. అప్పూడ్‍ తన్నే బాంద్ జెబెదయిన్ అని కుల్కలకేరున్ రూకుతి సాయుత్న ఔర్నాయ్ యేసుకున్ వెంట సెద్దేర్. ");
INSERT INTO nit_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","యేసుంద్ అని అమ్నెసిసులున్ మిరయుత్నా కపర్న ఇనెకా పట్నముంఙ్ సెద్దేర్. అత్తి ఆలపుసేక దినం యేసుంద్ యూదులె సావ్డిక్లెంఙ్ సెత్నా బోద ఇడ్డెంఙ్ మొదలిట్టెన్. ");
INSERT INTO nit_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","నియమ్ సాస్త్రి బదోల్ ఇడ్డెకద్లాఙ్ ఆ బోద ఇడ్‍తెంద్ గని తానుంఙ్ అదికార్ అండెతి ఇడ్డెతెంద్. ఆ బోదన్ వింత్నా గుల్ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ఆ వెలఙ్ బూత్ అంట్తంద్ అముదు ఒక్కొంద్ యూదులె సావ్డిక్లెంఙ్ వపొయ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","నజరేత్ అమ్మడ్ ఇముంఙ్త పని నివ్ ఎనివ్ ఎన్నివొ అనుంఙ్ ఒర్కి యేసుంద్ అని దెయ్యం న్నె పవిత్రక్ ఎన్నివ్ అమ్మత్తి నడుమున్ తనుంఙ్ సొంఙ్ తి? ");
INSERT INTO nit_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","యేసుక్ ఉక్కుమ్ సియ్తెంద్‍ దట్టిపుత్ ముడ్నెమ్, ఇమ్నున్ సయ్యుత్ సే ఇసా ఇంత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","అమ్దు ఆపవిత్ర ఆత్మ మాన్కకున్ గజ గజా మెలప్సా జోరకత్ వాపొయుత్ వక కురియుత్ సెదిన్. ");
INSERT INTO nit_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ఇదున్ ఓలుత్. ఔర్ పబ్లిక్. ఇద్ ఇనంఙ్ ఎనంఙ్ ఎర్సనాన్సద్? ఇమ్‍ద్ తన్నె అదికార్ రడ్ బొద ఇడ్సనంసాద్. అని బూతు సుమ్తరత్తన అదవున్ సెర్ ఇనెఙయ్ సెసానన్సాద్ ఇసా ఒక్కొనెత్ ఒక్కొంద్ ముడ్స గుల్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","గలిలీయ బార్సత్‍ అనెక అవ్రుసిమ్మన అమ్దు గురించి ఒర్కి ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ఆ యూదు మన్కకెర్ మిరయెక యూదులె సావ్డితార్ వాకావత్న సిసుల్ అని యాకోబ్‍. యోహాన్ అని యేసుంద్ మిరయుత్ సీమోన్ అని అంద్రెయక్ ఎల్లంఙ్ సెద్దేర్. ");
INSERT INTO nit_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","సీమోన్నె పొద్దల్‍. వెస్సానడ్ తెరుత్‍ మడియుత్ అండిన. యేసుంద్ వరెంఙయ్ మన్కకెర్ ఆ గొట్టిన్ ఇడ్తెంర్. ");
INSERT INTO nit_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","అమ్దు సెత్ అద్నె కేయున్ సుముత్ ఉదేంఙ్ ఇసా సాయం కతెంద్. అపుడ్ వెంటని వెస్స సయతిన్. తె అద్ ఔరె సర్‍బార్ కాలేంఙ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","అది జీర్ పొద్ ఉర్‍కేకా వెలంఙ్ మంజె పొదుర్‍కేకావెలంఙ్ బూతు సుమ్‍తరున్ అని దుకలకేరున్ యేసుకున్వై తోడవత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ఆ ఉరర్‍ అమ్దు అనెకా ఎల్లత బొయ్ద మెర వత్తెర్‍. రంత దుకలకెరుంఙ్ యేసుంద్‍ సాయం కత్తంద్. ఎన్నిగొ అపవిత్ర ఆత్మలున్‍ పుస్తెద్‍. అమ్దు అదవున్ ముడెంఙ్ ఇడెతెంద్. ఇమ్‌ద ఎదొ అదవుంఙ్ ఓర్‍కియ్‍. ");
INSERT INTO nit_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","రంఙ్ రంఙ్త దుకలకెరున్ యేసుంద్ సోయ్ కల్‍సాద్. ఎన్నిగొ బూతులున్ పుసుత్ ఎద్‍గతెద్. అమసద ఎదొ ఆ దెయ్యలుంఙ్ ఒర్కియ్ అదుంఙ్ ఎత్తి అముదు అదవున్ ముడెంఙ్ ఇడెతెద్. ");
INSERT INTO nit_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","యేసుక్ మరొక్కొ జీర్‍ బయియ్ ఎరేంఙ్ఙయి సులుత్ ఎరి మాన్కాకెర్ తోసెట జాగంఙ్ సెత్న అత్తి పార్తన కల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","సీమోన్‍ అని అమ్నె సంఙ్‍తకేర్ సుల్త వెనకత్ యేసుకున్ కిరవెంసటి సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","అవురుంఙ్ యేసుంద్ కండ్కేద్ వెనకత్. ఇనుంఙ్ సటీ సిమనమంది కిరవ్వసన్సార్‍ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","యేసుంద్ ఈ అజుబాజుత ఉలంత్తి సెనర్. ఊలెంఙ్ అన్‍బొదఇడత్. ఇముంఙ్ సటీ అన్ వాత్తనసే ఇసా అవురుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","అమ్దు గలిలీయ అనెకా ఊల్లున్ తిర్‍గస. అత్తి యూదు మిరయెక యూదులె సావ్డిఙ్ సేత్న గొట్టి ఇడ్స. అపవిత్ర ఆత్మ సుమ్‍తరున్ అవ్‍రంతన్ అదవున్ పుసుత్ ఎదఙ్‍సెన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ఒక్కొ పెర్‍దుకమాడ్ అనెక్ మన్కక్ యేసుకున్వై వాత్న ముద్ది దిన అత్న. ఇనుంఙ్ మనుంగి అండినింతె అన్న సోయ్ కాల్‍. ఇసా వింతి కతెంద్ ");
INSERT INTO nit_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","యేసునుంఙ్ అమ్నున్ పొయ్ దయ ఎత్న నీ సోయ్ ఎరేంఙ్ అనుంఙ్ మనుంగిఇసా కేయ్‍సుముత్ సోయ్ ఎర్ ఇసా అమ్నున్ పుడకతెద్. ");
INSERT INTO nit_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","వెంటాయ్ పెర్‍దుకమ్ అమ్నున్ సాయుత్న. అమ్దు సోయ్‍ ఎదెద్. ");
INSERT INTO nit_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","యేసుంద్ ఔరున్ ఇనంఙ్ అర్పులిపుత్ పవింటెద్. ");
INSERT INTO nit_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ఓల్. ఎరుగ్గి తనయ్యి ఇండనెమ్. గని సె. అని దెయ్యలకుంఙ్ ఇనే సరిరున్ ఓలిపుత్న వేలంఙ్ కాల్లెఙ్ ఇస్సా మోసేనె నియమడ్ బావు సియెకావ్. అదవున్ సాక్సం. ఇస్సా సియ్యి. ");
INSERT INTO nit_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","గని అద్ సెత్న సదర్‍ మందింఙ్ ఇడ్‍తెంద్‍. ఆ కరనాడ్‍ యేసుంద్‍ ఇడ్సద్ ఆ ఉలెంఙ్ ఉజగరి సొంగెంఙ్ సాలెతెంద్‍. ఆ ఉల్‍ పకంఙ్ బట్టిజాగత్ వస్తి కతెంద్. ఆమ్నెమంది సిమ్కన జాగ ‍తన ఆమ్నున్‍వై వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","కొన్ని దినా ఎద్దె అమ్దు మల్ల కపర్నఙ్ పట్నముంఙ్ సెద్దెంద్ అమ్నె ఎల్లంఙ్ వతెంద్ ఇసా మందిఙ్ కరిల్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","గుల్ మంద్ది మిరయుత్ వత్తె బొయ్దత జాగగినా పురయెతిన్ వకా గిన్‍జాగపుర్యెత్తిన్. యేసుంద్ ఔరుంఙ్ దెయ్యమ్నె బొద ఇడ్‍నెద్. ");
INSERT INTO nit_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","అపుడు నాల్గుర్‍ మన్కాకెర్‍ లక్వ ఇట్టమన్కకున్ చప్రత తడకత్ కేపుత్న తోడవాతెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","గని గుల్ పేరేత్ మంది నిండుత్ అండ కాడితుంఙ్ ఆ మన్కాకున్‍ యోసుకున్వై కొరేంఙ్ సాలేతెర్. అదుంఙ్ ఎత్తి ఔర్ ఎల్లపొదె సొకుత్నదండి బొగ్గ కత్న బరబార్ యోసుక్ నత్తి అమ్నున్ నారలడ్ చప్ర తడకత్ డింప్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","యేసుంద్ ఔరె విస్వాసున్ ఓలుత్న. యోసుక్ లక్వ ఇట్టనున్‍ ఇన్నె పాప్ మాప్కల్. ఇసా ఇతెద్. ");
INSERT INTO nit_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","అదున్ విత్న అతి అనెకర్ ఔర్ సాస్త్రిక్ తమ్నె‍త్‍ తమ్మి మన్‍లొప ఇనంఙ్ ఇన్నెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","ఇమ్‌ద తనుంఙ్ ఇనంఙ్ ముడసాద్? ఇమ్‌ద దెయ్యమ్నె బద్నం కల్సనసాద్. దెయ్యం సివయి ఎది పాప్ లును మాప్కల్ ఎర్? ");
INSERT INTO nit_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ఔర్ తమ్మె మన్నుత్ ఇనంఙ్ విచార్ కల్సరిసా యేసునె మన్నుత్ ఒర్కిల్‍తిన్. అముదు ఔరున్. నీర్ ఇదున్ వాలడ్‍ తనుంఙ్ విచార్ కల్సాతిర్? ");
INSERT INTO nit_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ఎద్‍సోయ్ ఇన్నె పాప్ కండిల్తె మాప్కల్? ఇన్నె తేరున్ సుముత్ సె ఇన్నెకాదసోయ్? ");
INSERT INTO nit_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","దున్యత్ పాపులున్ మాప్కల్ మన్కనె పోరకుంఙ్ అదికార్ హస్సద్. ఇసా నీర్ ఒర్కిలెంఙ్. ఇసా ఇంతెంద్. లక్వతనుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","అన్ ఇడ్‍సాత్. సులుత్ ఇన్నె చప్ర తడకన్ సుముత్ ఎల్లంఙ్ సె. ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","వెంటని ఆ లక్విట్టద్ సులుత్ ఇల్లత్ తన్నె చప్ర తడకన్ సుముత్ సిమ్కన మంది ఓలెంఙ్ అడసా కురియుత్ సెద్దెంద్. అదున్ ఓలుత్న అత్తి అనెకార్ సిమ్కన కమ్‍ల్‍ఎద్దెర్. అమ్ ఇటదున్ ఎప్పుడి ఓలెతమ్ ఇసా దెయ్యముంఙ్ స్తుతికత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","యేసుంద్ పెన్నా గలిలియ గంగడర్డింనడ్ అడ్గసా సెరెంఙ్. గుల్‍మంది మన్కాకెర్ అమ్నున్‍వై వత్తెర్. అమ్దు ఔరుంఙ్ బొద ఇడ్డెంఙ్ మోదలిట్టెద్. ");
INSERT INTO nit_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","యేసుంద్ అత్రనా కురియుత్న ముదర్‍వై సెరెంఙ్ అల్పయి క్నె పోరక్ లేవి పన్నుల్‍ వసులి కలెకా ఎల్లత్‍ అనెకనున్ ఓల్తెంద్. యేసుంద్ అమ్నున్. సులుత్ అన్ వెంటవ ఇసా ఇంతెంద్. లెవి సులుత్ అమ్నున్ వెంట సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","యేసుంద్ అమ్నె సిసు లేవినె ఎల్లత్ తిసాన్సార్. ఇవ్రలోపా పేలెటర్ యేసున్ వెంట అన్నెర్. అమ్నున్ వెంట పెల్లెటర్ పన్ను వసులి కలెకార్. పపి కత్తర్‍న వెంట తిసాన్సార్. ఇవ్రత్తి పెరెత్ మంది అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","పరుసిక్ సాస్త్రిక్ యేసుంద్ పాపమ్‍ కత్తరున్ వెంట. పన్నుల్ వెలెకర్ వెంట తిన్నెకారున్ ఓల్‍త్తెర్. ఔర్ అమ్నె సిసు వెంట. అముదు పాపమ్ కత్తరున్ వెంట. పన్ను వసులి కలెకార్‍ వెంట తనుంఙ్ కలయుత్ తిసాద్? ఇసావెలుత్‍ఓల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ఇదున్ వింత్న యేసుంద్ సుకామడ్ అనెకనుంఙ్ వైదక్నె గర్జతొతెద్. దుఃకమడ్‍ అనెకనుంగీ వైదక్నె గర్జ అన్సాద్. అన్ నీతి నాడ్ అనెకరుంఙ్ సటీ వరెతన్. గని పప్‍కలెకరున్ కూగెంఙ్ నివ్డిపెంఙ్ వత్తన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","యోహాన్నె సిసు. పరుసి. ఉపాస్ కన్నెర్. కొన్సెం యేసున్‍వై వత్న. యోహాన్నె సిసు. పరిసియులె సిసు ఉపాస్ కల్‍సార్‍తా! ఇన్నె సిసు తనుంఙ్ కలెంర్? ఇసా వెలుత్‍ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","యేసుంద్ ఔరున్ ఇస్‍న్ద నొవ్రకున్ వెంట అంనంతెంఙ్ ఎల్లతర్ అని సుట్ట ఉపాస్ కాలెర్ తా. ");
INSERT INTO nit_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","నొవ్రకున్ ఔర్ తన పుసుత్‍కొసెకా దినా వర్సా. ఆ దినలెంఙ్ ఉపాస్ కల్సర్. ");
INSERT INTO nit_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","పాత జుఙ్ఙె ఇరియ్‍త జాగత్‍ కొత్త జుఙ్ఙెనె తుక్డె తపెద్‍ కొత్త జుఙ్ఙెనె పాత జుఙ్ఙెనె బొగ్గ దండి ఎర్రద్. ");
INSERT INTO nit_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","పాత తోల్నె తైలి కొత్ అంగుర్ రస్సన్ ఎరి వగుత్ ఇడెర్. అనంఙ్ వగుత్‍ ఇట్టె కొత్త అంగుర్‍న్నె రసా ఆ తోల్నె ఇర్కసాద్. తోల్నె తైలి అని అంగుర్‍న్నె రస్సఇందినాయ్ నాస్ ఎర్సా. కొత్త తోల్నె తైలిత్‍ పేయ్యిస్సార్. ");
INSERT INTO nit_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ఒక్కొ ఆలపుసేక దినంయేసుంద్ సొంన వయ్‍తా కేడ్లడ్ సెసానంన్నెంఙ్ అమ్నె సిసునాయ్‍ అమ్నున్ వెంట అన్నెర్. ఔర్ తిన్నెంఙ్ ఉడ్డా సుడ్‍న్నెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ఇన్నె సిసు కలెకాద్‍ నియమ్ సాస్త్ర విరోద్ పరుసిక్ అమ్నున్, ఇవ్రున్ “ఓలుర్‍ ఔర్ ఆలపుసేక జీర్‍ కన్నెర్ ఇన్నెకా పనిన్‍తనుంఙ్ కల్సార్‍!” ఇసా వెల్‍త్తెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","అదుంఙి ఔరున్ ఇనంఙ్ ఇంతెంద్ తన్ తనుంఙ్ వెంట అన్నెకరుంఙ్ వాలడ్ ఔరుం కర్వత్తిన్, దావిదుంఙ్ తన్నె ఔసరమున్ వాలడ్ అముదు‍ కత్తదున్ నీర్ వాసిపెతిరా? ");
INSERT INTO nit_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","అబ్యుతర్ దెయ్యలకెర్ గినా అనెక కలముత్ దావిద్ దెయ్యమ్నె మందిరుఙ్ సేరుతు దెయ్యం ముదర్వై వత్తర్ సివ్వెఇ ఇద్నెఇ తినెగతొద్ అద నిపట్టె మరొక్కొర్ తినెంఙ్ తోద్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","యేసుంద్ ఔరడ్ పెనా ఇనంఙ్ ఇంతెంద్. ఆలపుసేక దినం సోయ్త సటీ కతెంద్. గని మన్కాకెరె ఆలపుసేక దినముంఙ్ సటీ ఇదరెతెంద్ మల్ల అవురును ఇస్సన్ మొకెరె దినం మన్కకెర ");
INSERT INTO nit_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","అదుంఙ్ ఎత్తి మన్కనె పోరకుంఙ్ ఆలపుసేక జీర్నాయ్ ప్రబుంది! ఇసా ఔరుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ఒక్కొ దినం యేసున్ యూదులె సావ్డింఙ్ సెస్సన్ అత్తి హరతహ కెయీతన్‍ ఓకొన్ మల్ల అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","మంది అత్తి యేసును పొయి దొసి ఇదరెఙ ఇసా. ఆలపుసేక దినముత్ అర్తకెయితనున్ అముదు సోయ్ కాల్సద తొద ఓల్సనియి టపిలుతి అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","యేసుంద్ అర్తకెయీతనున్ ఇసన్ద నివ్ సులుకుత్ నాడుమున్ ఇల్. ");
INSERT INTO nit_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","అపుడ్ యేసుంద్ అంత్ ఈ అనెకర్ వెంట మల్ల నియమ్ సాస్త్ర ఇడ్డెకద్లాఙ్ ఆలపుసేక దినముత్ సోయ్ కలెకద్? తొత్తె కరాబ్ కలెకా? బత్కిపెకద్ నియమ్, తోద్‍తె అల్ఙెకదా? ఇసా ఇంతెంద్ గని ఔర్ ఎద్ది సమాదనం ఇడ్డెతెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ఔర్ మన్లున్ ఓలుత్న యేసును నారాజ్ ఎత్ ఔరున్ రగ్గడ్ ఓల్సన్. అర్త కేయ్తనున్ ఇసాద్. ఇనే కెయున్ సాప్. అముదు సాప్సన్ హన్ని అమ్మనే కెయి సొయి ఏదిన్. ");
INSERT INTO nit_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","జల్దిని పరుసి మన్కకెర్ వాకా కురిస్సర్. యేసున్ ఎట్టద్ హల్గెకాద్ ఎనంఙ్ హేరోదు యుల. మన్కకెరే వెంట విరోద్ విచ్చరం కాలెంఙ్ ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","యేసుంద్‍ తనే‍ సిసులున్ వెంట. గలిలీయ సముదురుంఙ్ సెరెంఙ్. గలెలియదెసెమ్ తన యూదియ గులెనా పెరేత్ మన్కకకెరే అమ్నున్‍ వెంట సెస్సర్. ");
INSERT INTO nit_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","యేసుంద్ కాలేకవున్ విన్‍త గులేనమంది యూద తన. యెరూసలేం తన. ఇదూమియ తన. యోర్దన్ గంగ అలా పక్కఙ్త యేరియ తన. తూరు. సీదోను పట్నంల తిర్గొర్ తన అమ్నున్ మెరంవత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","గర్ది దబ్బిలెంఙ్‍ తోదిసా యేసుంద్ తనే సిసు ఒక్కొ రూకున్ తయార్ అప్పెఙ్ ఇడ్సద్ ");
INSERT INTO nit_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","తానుంఙ్ ఇంతె అముదు పేలెటర్‍ మన్కకెరున్ సోయ్‍ కతెంద్ అని ఇంతెంద్ రొగులకెరే అమ్నున్ పుడుకెంఙ్‍ ఇసానుక్‍లాడసా వర్సాన్సార్. ");
INSERT INTO nit_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","కరాబ్ ఆపవిత్ర ఆత్మ అన్‍ట్త మన్కకెరే అమ్నున్‍ ఓల్సార్. అప్పూడి ఔర్ అమ్నె ముండట్ గెట్ట మొక్కుత్నా వాపొయూత్‍ ఇస్సార్ నీవ్ దెయ్యమ్నె పోరక్‍న్నీవ్. ");
INSERT INTO nit_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","యేసుంద్ తాన్ ఎదొ ఎరుంగి ఇడ్నెమ్ ఇసా ఆ మన్కకెరుంఙ్ జోరనట్ ఆగ్య సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","యేసుంద్ మెట్‍పొయ్ సొక్కూత్ అమ్నుంఙ్‍ ఎర్ఎర్ పాజె ఔరున్‍ కూగ్తెర్. ఔర్ అమ్నున్‍వై సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","అముదు పన్నెడు మందిన్ తన్నె సిసులంఙ్ సువర్త ఇడ్డెంఙ్ నివ్డిప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ఆ బూతులున్ పుసెకా అదికార్ ఔరుంఙ్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","అముదు నివ్‍డిప్తా పన్నెండుమందిన్నె పెల్‍ సీమోన్ ఇమ్నున్‍ పేతురు ఇస్సా పేర్‍ ఇట్టెద్. ");
INSERT INTO nit_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","జెబెదయినె దాదకేర్ యాకోబ్‍ అని అమ్‍నే తొరేన్ యోహాన్. ఇవ్రూ ఇద్దరుంఙ్‍ అముదు బొయనెర్గెసు ఇసా పేర్ ఇట్టెద్. బొయనేర్గెసు ఇంతె గుడ్‍మెకాద్ పోరకెర్ ఇసా అర్తం. ");
INSERT INTO nit_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","అంద్రెయక్. పిలిప్పి. బర్తొలొమయి. మత్తయ్. తోమక్. అల్పయినె ఇద్దర్‍ పోరకేర్ యాకోబ్. తద్దయి. సీమోన్ కనానీయక్. ");
INSERT INTO nit_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","యేసున్‍ సుమ్మూత్‍ సియ్యికా ఇస్కరియోత్ యూద. ");
INSERT INTO nit_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","మల్ల యేసుంద్ ఎల్లవాయ్‍ సేద్దేద్. అత్తీ ఇంతె మన్కకెర్ మిరయ్‍తెర్‍ అమ్నుంఙ్ అని అమ్నె సిసులుంఙ్ తినెఙ్‍నాయ్‍ మొకా రొంబడెతిన్. ");
INSERT INTO nit_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","మంది అమ్నున్ మదతమ్‍ ఇసాఅనంఙ్ ఇసా అమ్నె సుట్ట అమ్నున్ బారం ఇదరెంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","యెరూసలెమ్‍తన వత్ తా సాస్త్రిక్. అమ్నున్‍ బయెల్జెబూలు బూత్ సుమ్‍త్తిన్. బూతులె అదికారి సాయమాడ్ బూతులూన్‍ ఎదగ్సనాన్సంద్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","అప్పూడ్‍ యేసున్‍ అవ్రూన్‍ తన్‍ మెరం కూగుత్నా ఉదహరన ఇడ్సాద్ సైతన్ ఎనంఙ్ సైతానున్ ఎదగ్సంద్. ");
INSERT INTO nit_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ఒక్కొ రాజ్యం తంమ్మెత్ తమ్మి విరోద్ ఎత్న ఇదే అదే ఎదే ఆ రాజ్యం టికిలెద్. ");
INSERT INTO nit_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ఒక్కొ ఎల్ల కుటుంబతర్ విరొది ఎత్‍ ఇదే అదే ఎద్దెరింతె అద్ ఎల్ల కుటుంబ టిక్కిలేంఙ్‍సాలెద్. ");
INSERT INTO nit_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","సైతన్ లోపా విరొది ఎత్న ఇదే అదే ఎదినింతె గిన అద్నాయ్‍ టిక్కిల్‍సెట అందద్ అద్‍నెత్నాయ్‍ ఆక్రిఎరద్. ");
INSERT INTO nit_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","బలం వాలేన్ పేలె కట్‍తాసివాయ్‍ ఎది బలం వాల్లెనే ఎల్లాత్‍ సొగుత్న అమ్నే ఆస్తిన్‍ డొంఙ్ కలెంఙ్‍ సాలేర్. పేలె బలంవాల్లెన్‍ కట్తెయ్ డొంఙ్ కాలెంఙ్‍ సాల్దర్. ");
INSERT INTO nit_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","కరెయ్ అన్ ఇమ్మూంఙ్‍ ఇడ్సాత్; మన్కకేరే కత్త సట్టం పాప్ లున్‍ అని దెయ్యమ్నె బద్నం. దెయ్యం మాప్కల్ కాల్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","గని పవిత్ర ఆత్మన్ ఎంద్ బద్నం కాల్సాదొ అముదు ఎప్పుడి మాప్ తోతెద్ తానుంఙ్ ఇంతె ఔర్ గుల్ పాప్ కత్తసార్. అద్ అమ్నుంఙ్‍ నిత్యజీవంత పాప్నే దోసి ఎర్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","సాస్త్రి యేసునంత్తి ఆపవిత్ర ఆత్మ అన్సాద్‍ ఇసా ఇన్నెకాదుంఙ్ వాలడ్‍ అమ్నున్ ఇనంఙ్ ఇంతెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","యేసునే అమ్మ, అమ్నె దాదకేర్ అత్తి వత్తెర్. వాక ఇల్లూత్‍ యేసునున్‍ కుంఙ్ ఇసా ఒక్కొనున్‍ లోపా పన్కతెర్. ");
INSERT INTO nit_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","అమ్నున్ తిర్గొర్ మంది అన్సార్, ఔర్ అమ్నున్, “ఇమ్మె అమ్మ అని తోర్దాసిక్ తోరెంద్ ఇమ్ముంఙ్ సటీ వాక ఇలుత్ అన్సార్ ఇసా ఇంతెర్.” ");
INSERT INTO nit_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","అముదు అవ్రూన్‍ ఇస్సాద్. ఎద్ అన్నే అమ్మ? ఎరే అన్నే తోరెంద్ తొరెడ్లు? ");
INSERT INTO nit_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","అముదు తిరగొర ఉద్దూత్‍ అన్సార్ ఔరున్‍ ఓలుత్నా అమ్నున్ ఇస్సాద్ ఇవ్రిఎన్నేర్‍ అన్నే అమ్మ అని తోరెంద్. ");
INSERT INTO nit_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ఎద్ద దెయ్యం న్నె మన్‍తదున్ కాల్సర్ ఔవ్రి అన్నే తోరెంద్. తోర్దాసిక్ అని అమ్మ లఙ్. ");
INSERT INTO nit_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","అముదు సముద్రం మెరం కారపేంఙ్ లాక్సర్. గులేన్‍ మన్కకెరె అంనత్తి మిరయుత్ అముదు సముద్రంత అనెక రూకుత్‍సొకుత్‍ ఉద్‍సాద్‍ మన్కకెరే సట్టం సముద్రంత దర్డిత్‍ హన్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","అముదు ఎన్నిగొ ఉదహరనాడ్ పేల్గెఙ్ గొట్టిక్ కారపెంఙ్ ఎదెద్. ఇసా బొదిడ్తెంద్. ఇసా ఇనంఙ్ బొదఇడుత్. ");
INSERT INTO nit_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","వినుర్‍ ఒక్కొద్ విత్తన సాల్లెఙ్ కురితెద్. ");
INSERT INTO nit_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","అముదు సాల్లెంఙ్ కొన్నిఙ్ విత్తనల్ పావుతు రల్సవ్. పిట్టల్ వారుతు అదవ్లున్ తిస్సావ్. ");
INSERT INTO nit_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","కొన్నిఙ్ విత్తనల్ దుబ్బ ఏక్కువ తొస్సెట్ బట్టి జాగత్ రటవ్. అత్తి పెరెత్‍ దుబ్బ తొస్సెట జల్ది జల్ది మొల్లిస్సవ్. ");
INSERT INTO nit_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","దుపరి ఏత్న ఉబ్బంఙ్ అద సివ్కసావ్ వేల్ తొస్సెటవ్ అద అర్సవ్. ");
INSERT INTO nit_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","కొన్నిఙ్ విత్తన సాల్ల తుట్టిత్‍ రల్సవ్. సాల్లె మకూతు అదవెంట పెరుగుత్ దటిప్సవ్ అని అద తనయ్‍ పలితం సియ్‍ఙ్ సాలేతెవ్. ");
INSERT INTO nit_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","కొన్ని విత్తనల్ సోయ్ జాగత్ రల్సవ్ అద సోయ్‍ మొలయ్యితెవ్. అని పెరగ్సవ్ అని పలితం సియ్‍తెవ్. అద లోప కొన్నిఙ్ ముప్పయి దంతల్ కొన్నిఙ్ సాట్‍ దంతల్ అని కొన్నిఙ్ నుర్ దంతల్ పలితం సియ్‍తెవ్. ");
INSERT INTO nit_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","యేసును ఇసాన్ద ఔరుంఙ్ వినేకాదుగు కెవ్వూ అన్సా అముదు వినేఙ్‍ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","అముదు ఒక్కొంది అనేఙ. పన్నెండు మంది సిష్యుల్‍ అని యేసున్‍ వెంట ఏర్ అస్సార్ ఇవ్రు అమతీన్ అద్ ఉదహరన్‍ గొట్టి బదోల్‍ వేల్తొల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ఔరున్ వెలుత్‍ ఓల్తెంద్ గని. దెయ్యమ్నె రాజ్యం నేత్ డప్త గొట్టి ఇమ్మూంఙ్ కులుత్ సియ్యుతు అన్సాద్‍. గని ఏర్ వాకా అన్సార్‍. ఔరుంఙ్‍ అద సట్టం ఉదహరనాడ్ అన్సాద్‍. ");
INSERT INTO nit_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ఔరుంఙ్ ఓలేఙా అవురూఙ్‍ కాడ్కేరెంఙ్‍తోద్ అని వినేగఙా అవురూఙ్‍ కారిలేఙ్‍తోద్. ఔర్ వినుతు దెయ్యంవై తిరిగ్సార్ అనిఔరె మాప్కల్. ");
INSERT INTO nit_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","యేసుంద్ ఔరడ్ ఇనంఙ్ ఇంతెంద్. ఇముంఙ్ ఉపమానంనె కరిలెతినా? మల్ల మిక్తఉపమనలున్ ఎనంఙ్ అర్త కల్సతి? ");
INSERT INTO nit_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","విత్తన విత్తెకాంద్ లాఙ్‍ అన్సాంద్ దెయ్యమ్నె గొట్టిన్‍ ఇడ్డెకాంద్. ");
INSERT INTO nit_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","పావుత్ వాయి తా విత్తన విత్‍సాద్‍. మన్కకెర్‍ ఇవ్రు ఇస్సార్ ఔర్ దెయ్యమ్నె గొట్టిన్ వింతదూన్ సైతన్ వత్త ఔరె లోపా వాయితా గోట్టిన్ ఎత్తుత్ కొస్దద్. ");
INSERT INTO nit_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","మల్ల అనాయ్ కొన్సెం మంది అనాయ్ బట్టి జాగత్ వాయ్యిత విత్తన మన్కకేరే ఇవ్రులంఙ్. ఔర్ దెయ్యమ్నె గొట్టీన్ వింత వెంటని కుసినడ్‍ వింత్ సుంసార్‍. ");
INSERT INTO nit_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","గని ఔర్ లోపా వేల్తోస్సేటడె. ఔర్ కొని గొల్‍ టిల్సార్‍ గొట్టినాడ్ తరస్ తక్లీబ్. ఎద్దె ఔర్ రల్సార్. ");
INSERT INTO nit_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","మల్ల కొన్సెం మంది సాల్ల తుట్టిత్‍ వాయ్యిత విత్తనలంఙ్. ఔర్ దెయ్యమ్నె గోట్టిన్ వినసర్. ");
INSERT INTO nit_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","గని కాడుత్ చింత పైసేల లోబ్‍ అని రంఙ్ రంఙ్త అస ఔర్ లోపా వత్న దెయ్యమ్నె గొట్టిన్ దటిప్సద్ అని ఔర్ తానయ్ పలితం సీయేంఙ్ సాలేర్. ");
INSERT INTO nit_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ఇంక్ కొన్సెం మంది సోయ్ జాగత్ వాయ్యిత విత్తన లంఙ్‍ ఇవ్రు ఎన్నెర్ ఔర్ దెయ్యమ్నె గోట్టిన్ వింత్ అదూన్ సుమ్‍సార్ అని ముపైయి దంతల్ సాట్‍ దంతల్ నూర్ దంతల్ పలితం సీయ్సర్. ");
INSERT INTO nit_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","అముదు మల్ల ఔరున్ ఇసన్ద. ఎందేనా దీవెన్ తరుపూత్ తెర్ బుడున్ దీవే ఇడెక లంన పొయ్‍ ఇడ్సా ర్ తా. ");
INSERT INTO nit_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ఏర్క సుమ్మెఙ్‍ సాలేర్ అనంఙ్. తానాయి డపూత్‍ గోట్టితోతెద్. పుందెంఙ్‍ సాలేర్‍ అనంఙ్‍ తానాయి మున్సతా గోట్టి తోతెంద్ కురిద. ");
INSERT INTO nit_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ఔరుంఙ్ వీనేకాదుగు కేవ్వు అన్సా. అముదు విన్నెఙ్. ");
INSERT INTO nit_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","నీర్ ఎ మాపాడ్ కుల్లాతీర్ అద్ మాపాడ్ ఇమ్మూంఙ్‍ నాయి కుల్లేకాద్‍ వరద్‍. అద నాయి ఇమ్మూంఙ్‍ రొంబడ్సా. ");
INSERT INTO nit_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","తానుంఙ్ ఇంతె ఏరుంఙ్‍ అన్సా అవురుంఙ్‍ ఎక్కువ రొబడ్ససెస్సా. గనితోస్సెట నత్తన అనెకా తోస్సెటనాయి పుస్సేకాద్‍ఏరద్. ");
INSERT INTO nit_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","యేసుంద్‍ మల్ల ఇడ్‍సాద్‍. దెయ్యమ్నె రాజ్యం ఇనంఙ్ అన్సద్. ఒక్కొ మన్కక్ కేనుత్‍ వయ్‍ తా వితన సాలుత్. ");
INSERT INTO nit_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","అముదు సింత్తె పత్తె మంగుత్ సులెంఙ్ అమ్నుంఙ్ ఎర్కతోసెట వితన మోలయుత్ పెర్గసా. అద ఎనంఙ్ పెర్గసావొ అమ్నుంఙ్ ఎర్కతొద్. ");
INSERT INTO nit_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","బూమి తన్నే మన్నాడ్ తని పీక్ సీసాద్‍. మొదల్ మొలక కురియుత్ మల్ల పొట్రంఙ్‍ ఉడ్డమ్ ఎత్నాకిసెంఙ్ వర్సాద్‍. ");
INSERT INTO nit_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","పంటపండెకా కలమ్ వత్తిన్ అప్పుడ్‍ ఆ మన్కక్ కిసెకదుంఙ్ కొడ్వా కొసుత్‍ కిస్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","యేసుంద్ మల్ల ఇనంఙ్ ఇసాన్ద. దెయ్యమ్నె రాజ్యం ఎనంఙ్ అన్సాద్ ఇసా ఇడ్డెకాద్? అదున్‍ ఏ ఉదహరనడ్ ఇడ్డెకాంద్? ");
INSERT INTO nit_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","అద్ ఇనంఙ్ అన్సాద్ ఒక్కొ మన్కక్ బూమిత్ వయ్‍ తా వితన లంఙ్ అన్సాద్. అద్ బూమి పొయి అనెకా సింకానా విత్తనలుంఙ్‍ ఎనా సిన్నం అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","అద్ బూమిత్‍ రలుత్ మొలయుత్‍ పెరుగ్తిన్ కేన్‍ తా సెట్లు దండి ఎరసాద్‍. కొమ్ము పెర్గుత్ దండిక్ ఎత్న అద్నె నిడత్ పిట్ట వత్న అద్నె కొమ్ములేంఙ్‍ తుప్ప ఇందర్సా. ");
INSERT INTO nit_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","యేసుంద్ ఇట ఉదహరనలున్ ఎన్నిగొ ఉదరనాలడ్. బొదన్ అర్తం కన్నంత్తెఙ్ ఔరుంఙ్ ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ఉదహరనడ్‍ సివాయ్ అవురుంఙ్‍ బొద ఇడ్సాంద్‍. గని సిసులున్ వెంట ఒక్కొంది అనేఙా అవురుంఙ్‍ పోడిలుతు ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","అది దినం సియితె వేలఙ్ యేసుంద్ తన్నె సిసులున్ ఇస్సాద్. గంగఙ్ అల దర్డిఙ్ సేనర్! ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","సిసు. అత్తి అనెకా మందిన్ సాయుత్ యేసుంద్‍ అనెకా రూకుత్ ఉదుత్‍ సెద్దెర్. మల్ల కొన్ని రూకునాయ్‍ ఔరున్‍ వెంట సెదె. ");
INSERT INTO nit_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","అపుడి ఒక్కొదండి దుదడ్ వర్సద్. అనయి అల్లవ రూకున్ తక్‍సా రూకుత్. ఈర్ నిడ్స వర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ఆ వెలంఙ్ రూకుత్ వెన్కా పకంఙ్ యేసుంద్ తలపా ఇడుత్. మంఙ్సానంసాద్. ఔర్ యేసునున్‍ సులుపుత్ ఇస్సార్‍ గురువు నేండ్ ముంలగ్సతుమ్ అద్నే చింత ఇనుంఙ్ తోతెద? ");
INSERT INTO nit_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","యేసుంద్ సులుత్నగాలిన్. దట్టిపుత్ ఆ గంగత అలవలున్ ఇడ్సాద్. సిమ్కెర్‍ అపుడ్ గాలి సిమ్కు ఎర్సద్ అని సిమ్మసామ్మె ఏర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","మల్ల అముదు ఔరున్ విస్వాస తనుంఙ్ నీర్ అర్సతిర్. ఇమ్ముంఙ్ బరొస తోతెద! ");
INSERT INTO nit_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ఔరుంఙ్ గుల్‍ అర్రి వత్తిన్. తమ్మెత్‍ తమ్మి. ఇనంఙ్ ఇన్నెంఙ్ ఎద్దెర్ ఇమ్‌ద ఏద్ ఎన్నెదొ! గాలి అని గంగనాయ్ ఇమ్నె గొట్టికున్ విసా. ");
INSERT INTO nit_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","అపుడ్ ఔర్ గంగన్ దటుత్న గెరాసేను దేసెముంఙ్‍సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","యేసుంద్ రూక్‍ తన బూడున్‍డిగెంఙయ్ బూత్ అట్‍తద్‍ఓక్కొద్ తప్నెతంద్ అమ్నున్‍వై వత్‍ కలయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","అముదు తప్నెలెంఙ్ బత్కన్నెద్. సంకేలలాడ్ కట్‍తెనాయ్. అమ్నున్ ఎరి అవరిపెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","అమ్నున్ పేలెగుసాల్ సంకేలాడ్‍ అని నారనాడ్ కట్టుత్ అండెర్ గని అముదు సంకెలలున్ నారలున్ పుంత్‍స్సాద్ ఎరి అమ్నున్‍ గట్టిపెంఙ్ సాలెతెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","అముదు సీంతె తొల్లి తప్నె అని మెట్లెఙ్ వాపొయ్‍సా అన్నెద్ అని గుండ్‍లడ్ తనే మెనున్‍ తని తర్గసాద్‍, దనప్సన్. ");
INSERT INTO nit_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","అముదు యేసునున్ దవ్‍తన ఓలుత్న తుల్‍సెత్న అమ్నున్ ముండట్ ముడుసులడ్ అత్న మొక్తి. ");
INSERT INTO nit_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","అని జోరకత్ వాపొయ్యుత్ ముడ్సా ఏ యేసు గుల్‍ దండి దెయ్యమ్నె పోరక్ అనంత్తి ఇనుంఙ్‍ తా పని? దెయ్యమ్నె పేరడ్‍ ఇడ్సాత్‍ అనుంఙ్ తక్లిబ్ సియ్యినేమ్. ");
INSERT INTO nit_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","అదుంఙ్ ఎత్తి యేసుంద్ అదున్. ఓ సైతన్! ఆ మన్కన్‍ తన వాకా వా! ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","అపుడ్‍ యేసుంద్ అమ్నున్ ఇనగ వేలుత్ ఓల్తెంద్. ఇనే పేర్ తనేద్! హస్సాద్? అముదు ఇసాద్ అనే పేర్; సేన; తానుంఙ్ ఇంతె అమ్‍ పేరేత్‍ అన్సాంతుమ్. ");
INSERT INTO nit_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","మల్ల మల్ల యేసునున్ చరన కనేన్. అమున్ ఆ దేసెంతన ఎద్గనెమ్. ఇసా వింతి కతెంద్ ");
INSERT INTO nit_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ఆ మెట్వై పెల్ల తుర్రెలె మంద మెయ్‍సానంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","అదుంఙ్ ఎత్తి అమున్ ఆ తుర్రెలంత్తి పన్క ఇసా వింతి కత్తె ");
INSERT INTO nit_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","యేసుంద్ అదవున్ పన్కుత్‍. మల్ల ఆ బూతు వాకా కురియుత్నతురేలేంఙ్ సొంఙ్సా. అని అద తుర్రె సమ్‍దుర్ ముల్గుంత్. తిక్‍సా. అద కాలపుత్ అద్దెజా ఇంది హజహల్ తుర్రే అన్సా. ");
INSERT INTO nit_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ఆ తుర్రె మెయ్‍పెకార్ తుల్‍సెత్న. పట్నముత్ ఉలెంఙ్. ఈ గట్టనాన్ బదోల్ ఇడ్‍తెర్. మంది జర్గిల్‍తదున్ ఓలెంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ఔర్ యేసున్‍వై వత్న సేన సుమ్‍తనున్‍ ఓలుత్న అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ఎద్దదున్ పూర ఓల్‍తర్. బూతులంట్‍తరున్ జర్గిల్‍తదున్ బదోల్. తుర్రె బదోల్ ఔర్ సదరుంఙ్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","అప్పుడ యేసుంద్ తమె ముల్కతన సయుత్‍ సెరెంఙ్ అనంఙ్ వింతి కలెంఙ్ ఎద్దెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","యేసుంద్‍ రూకుత్ ఉదేంఙ బూత్ హటుత్ అనెకా. ఆ మన్కక్ యేసునున్ వింతి కాల్సద్ అన్న ఇన్ వెంట అనేఙఇడ్; ");
INSERT INTO nit_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","గని యేసుంద్ అదున్ ఓపెతెంద్. అమ్నున్. ప్రబుంద్ ఇనుంఙ్ ఎత్తె సహయం కత్తెదొ. ఇన్‍పొయ్ ఎత్తె దయా ఓలిప్‍తెదొ ఇన్నెఎల్లంఙ్ సెత్న ఎల్లతరుంఙ్ ఇడ్‍ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","అముదు సెత్న యేసుంద్‍ తనుంఙ్ కత్తదున్‍ దెకపొలి ప్రతముత్ ఇడ్తెంద్‍. సిమనా మంది గులేనా కామల్‍కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","అపుడ్‍ యేసుంద్ రూకుత్‍సొకుత్ గంఙన్ దటుత్ అలా డర్‍డింఙ్ గదియ్తెంద్. పెరెత్ మందిన్నె అమ్నున్ తిర్‍గొర ఎద్దెర్. అముదు ఇంకా గంగమెరమి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ఇంతెతి మందినె అదికారినెంద్ ఒక్కొద్ అత్తి వతెంద్. అమ్నె పేర్ యాయీర్. అముదు యేసునున్ ఓలుత్న అమ్నె గెట్టలెంఙ్ వత్న. ");
INSERT INTO nit_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","అన్నె పిల్ల తిక్కెంఙ్ కల్సాన్సాద్‍. నిర్‍ దయకత్న వత్ ఇమ్మె కేయ్యు అదున్ పొయ్‍ఇట్టె అద్ సోయ్‍ ఏత్న బత్కిప్. ఇసా నమ్రనాడ్ వింతి కత్తె. ");
INSERT INTO nit_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","యేసుంద్ అమ్నున్‍ వెంట సెద్దెంద్. మన్కకేరే గర్ది ఒక్కొనెత్ ఒక్కొద్ డగ్లిప్‍సా అమ్నున్‍వై సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","పది ఇన్ది 12 సాల్కుతన నెత్తుర్ సెరెక మల ఏరేకా దుకమడ్ బాదపడెకా ఒక్కొ పిల్ల ఆ మందినత్తి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","అదగుల్ మంది వయ్‍దులకెరునాయ్ ఓలిప్‍త్తిన్ గని అద్నె దుక్కం తనయ్ సోయ్‍ ఎరెత్తిన్. తనత్తి అనెకా బకి సిమ్కన తిర్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ఆ పిల్ల యేసున్ బదోల్ గోట్టి విన్‍త్న గర్‍దిత్ అమ్నున్ వెంట సేత్. జుఙ్ఙెన్‍ పుడ్తిన్ ");
INSERT INTO nit_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","అద్ అమ్నె మనుత్ ఇనంఙ్ ఇస్సాద్. అన్‍ అమ్నె జుఙ్ఙెన్ పుడ్‍కుత్ ఎనా సోయ్ ఎరత్. ");
INSERT INTO nit_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","అపుడు అద్ పుడ్‍కెంఙయ్ అదనేతె మల్ల సేరేకాద్ బాన్దు ఏదె. అదుంఙ్ అదనే మనుత్ ఇనగ కార్రిల్తిన్. అన్ ఆ దుక్కం తనహ సోయ్ ఏదన్. ఇసా అదుంఙ్ కరిల్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","వెంటాయ్ యేసు నత్తన సక్తి సెదెత్తి కరిల్‍త్తిన్. తిర్‍గొర్‍ అనెకా మందిన్‍వై ఓలుత్న. అన్నె జుఙ్ఙెలున్ ఎర్‍ పుడ్క్ తిన్ ఇసా ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","అమ్నె సిసు అమ్నున్ ఇస్సార్. ఇన్ మన్కకేరే గర్దిత్ ఎత్తెఓ మంది అండెరె. అద్ నివ్ ఓల్‍తిత హన్ ఏద్ పుడ్కతెంద్ ఇస్సాతివ్? ");
INSERT INTO nit_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","గని యేసుంద్. ఎర్‍పుడక్‍త్తెరొ? ఇసా తిర్‍గొర ఓల్సానీ అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","అపుడ్ పిల్ల తన్ సోయ్‍ ఎద్దదున్ ఒర్కిలుత్న. అర్రినాడ్ వడక్‍సా వత్న యేసునె గెట్టలున్ మొకుత్ తనుంఙ్ జర్గిల్‍తద్ సిమ్కనన్ సత్తెం ఇడ్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","యేసుంద్ అదున్ ఇస్సాన్, బాయి! ఇనే విస్వాసి ఇన్‍ సోయ్‍ కత్తిన్‍. సాంతినాడ్ సె. ఇన్నె దుక్కం సోయ్ ఎద్దిన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","యేసుంద్ ఇంక ముడ్స అనేఙ బక్తి సావ్డిత అదికారి యాయిర్‍నె ఏల్లతన్నా కబుంల్ ఇడ్డె కార్‍ వత్న యాయిరున్. ఇన్నె పిల్ల తిక్తిన్‍ గురుజి పంఙి తక్కలిబ్ సియ్యిస్సతివ్? ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","యేసుంద్ ఔర్ ఇడ్‍తదున్‍ విత్న లెక్కకల్సెట బక్తి సావడితా అదికారి యాయిరున్ ఇంతెంద్. అర్సనెమ్ బరొస ఇడ్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","యేసుంద్ పేతురుంద్. యాకోబున్. యాకోబ్నె దాదక్ యోహాన్ తప్ప ఎరుని తన్న వెంట వరెంఙ్ ఇడెతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ఔర్ బక్తి సావ్డి అదికారి యాయిరినె ఎల్లంఙ్ వత్తతి అత్తి అనెకార్ జోరకత్‍ ఆర్స లొల్లికలెకరున్ యేసుంద్ ఓల్తెంద్. తనయ్ కరిల్‍సెట సిమ్కన మంది సుయ్అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","అముదు ఎల్లలోపా సొంగుత్‍ ఔరున్‍. తనుంఙ్ నారాజ్? తనుంఙ్ ఎర్సతి? ఆ పిల్ల తిక్కేతిన్ మంఙుత్ అన్సాంద్. ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","అపుడ్‍ ఔర్ కైయ్గతెరె గని యేసుంద్ ఔరున్‍ సట్టమున్‍ వాకా పన్కుత్ పిల్లనే అమ్మ బన్దు అని తన్ వెంట అనెకా సిసులున్ తోడ అద్‍ అనెకా కోలింఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","42","అద్నె కేయ్యున్ తన్నె కేయ్యడ్ సుముత్ తలీ తాకుమీ! ఇసా ఇన్‍తెంద్. తలీ తాకుమీ ఇంతె “సిన్నం పిల్ల అన్‍ ఇడ్‍సాత్‍ నీ సుల్‍!” ఇసా అర్తం. అద్ సులుత్న వెంటాయ్ అడ్గెంఙ్ ఎద్దిన్. అద్నె వయ్ బరసాల్‍కు అదున్ ఓలుత్న సిమ్కన మదింఙ్ కామల్‍కరిల్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ఈ గోట్టిన్ బదోల్ ఏరుంఙి ఏరక్ ఎరేంఙ్‍ తొద్ ఇనంఙ్ యేసుంద్ ఔరుంఙ్ దటిపుత్ ఇడ్సద్. అదుంఙ్ తినేంఙ్ తన్నెద్‍ ఎన సియుర్ ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","యేసుంద్ ఆ జాగన్‍ సాయుత్ సిసు వెంట కలయుత్ సొత ఊలెంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ఆలపుసేక దినమ్‍ వరెంగయ్ బక్తి యూదులె సావ్డిత్ అమ్నె గొట్టిన్ ఇడెంఙ్ ఎద్దెంద్. గుల్‍మంది అముదు ఇడ్‍తవున్‍ వింత్‍ కమల్‍ ఎద్దెర్‍. అవ్ర ఇనంఙ్ ముట్టెర్. ఇంమ్నుంఙ్ ఇద సిమన ఎనంఙ్ వత్తె? ఈ ఙనం ఎంటద్? ఇమ్‌ద సమత్కార్ ఎనంఙ్ కల్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ఇమ్‍దు వడెగి తా! మరియక్నె పోరక్ తా! యాకోబ్, యోసే, యూద, సీమోన్ తోరెంద్ ఇమ్‌ద. ఇంమ్మనే తోర్దాసిక్ సిక్ ఇత్తి నేడున్ వెంటాయ్ అస్సావ్. త! ఇనంఙ్ ఇసా అమ్నున్ విరొద్‍ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","అపుడ్ యేసుంద్ ఔరున్ ఇస్సాన్. దెయ్యమ్నె కబుర్లకూన్ సట్టం జాగలెంఙ్ మన్ రొంబాడద్ గని తమ్మె మెరతర్‍ తమ్మె ఎల్లత తప్ప సిమ్కన జాగలెంఙ్ మన్ రొంబడ్సాద్‍ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","యేసుంద్ కొన్సెం మంది దుకలాకేరున్ పోయ్యి కేయ్యులిడుత్న ఔరున్ సోయ్ కలెకాద్. తప్ప మరొక్కొ తానయ్‍ సమత్కార్ కలెంఙ్ సాలెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","అవ్రత్తి విస్వాసం తోసెటదున్‍ ఓలుత్న అమ్నుంఙ్ కమల్ వాట్టిల్‍తిన్. అపుడ్ యేసుంద్ మెర మెరత ఉల్ ఉల్లెంఙ్ సెత్న గొట్టి ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","యేసుంద్‍ బరమంది సిసులున్ తన్వై కూగుత్న ఔరుంఙ్‍ ఇద్దర్‍ ఇద్దరున్‍ పన్కుత్న ఔరుంఙ్ బూతులున్ పోయ్ అదికార్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","యేసుంద్ ఔరుంఙ్ ఇనంఙ్ ఉక్కుమ్ సియ్యిస్సాద్. ఎయ్‍ ఎన సెరెంఙ్ కేయ్యుత్‍ కోలా సివాయ్ మరొక్కొద్‍ తానయ్‍ కొసెంఙ్ తోద్. నిప్పటే, పైసెల సంచి, జుఙ్ఙెల తైలి తోడసెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","కేర్రికున్ తోడుర్ గని మరొక్కొ జుఙ్ఙె తోడ సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ఎరెత్తి ఎల్లంఙ్ సెసెట్ట ఆ ఊరున్ సాయుత్ సెంనంత్తెంఙ్ ఆ ఎల్లత్తి అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ఒక్కొ ఊరర్ ఇంముంఙ్ మాన్ సియ్‍సెటండె. తొద ఇమ్మె బొదన్ విసెట అండ్డె నీర్ ఆ ఊరున్ సాయుత్ సెరెంఙ్. అవ్రుంన్ బదోల్ సాక్సం ఇమ్మె గెట్టలెంఙ్ అంట్‍త దుబ్బన్ జడిపుర్. ");
INSERT INTO nit_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ఔర్ సెత్న మందింన్ మన్ బద్లిపుర్ ఇసా బొద ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","అని ఎన్నిగొ బూతులున్ పుసుత్ ఏద్గత్తెర్. పేలెటర్ దుకలకేరున్ ఒలీవ నూనె దీటుత్ సోయ్‍ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","యేసునే పేర్ గులేనహ నేరయ్‍త్తిన్. హేరోద్ రాజక్ అమ్నున్ బదోల్ విత్న ఇసాద్. బాప్తిస్మ సియెకా యోహాన్ తిక్కుత్ పానమ్ ఎద్దేంద్. అదుంఙ్ వల్లడ్ ఇంమ్నత్తి ఇంతె దండి దండికి సమత్కార్ ఏర్సనంసా. ");
INSERT INTO nit_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","కోచెం మంది ఇస్సార్. ఇమ్‌ద ఏలీయాక్ ఏన్నెద్. మల్ల కొన్సెం మంది ఇస్సార్ ఇమ్‌ద తొల్లె వత్త దెయ్యమ్నె గొట్టిక్ ఇండెకార్ లోపా ఒక్కొంద్ ఏన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","గని హేరోద్ అదున్‍ వింత్ ఇసాద్. హన్ మక్కున్ పుద్తద్ అముదు బాప్తిస్మ సియెకా యోహాన్ తిక్కుత్ పానమ్ ఎద్దేంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","హేరోద్నె తోరెంద్ పిలిప్పునే మాసల్ హేరోదియ లున్ అపేకాద్ యోహాన్ నీతి అదుంఙ్ ఎత్తి ఇన్నె దొస్తునె మాసలున్‍ అపెకద్‍ సోయ్‍తోద్. ఇసా. ఇంతెంద్. బాప్తిస్మ సియెకా యోహాన్ హెరొదికి గని అమ్నున్‍ జేలుత్ తపెంఙ్ సాలెతిన్. తనుంఙ్‍ ఇంతె అముదు పవిత్రు ఇసా ఒర్కిలుత్‍ హెరొద్‍ అమ్నున్‍ అర్స అమ్నున్‍ గెల్పెతెద్‍. అముదు యోవనె గొట్టిక్‍ వింతదున్‍ వాలడ్‍ సిమ్కనన్‍ అముదు కతదున్‍ కుసినడ్‍ అముదు అమ్నె గొట్టికున్‍ వింతెద్‍. ");
INSERT INTO nit_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","మల్ల హేరొదికుంఙ్ మొక్క రొబ్బటిన్ హేరోద్ తనే రజంముత్ మెన్అదికాలున్‍. సిప్పాయికున్ గలిలీయ మెన్‍ దండి దండి మన్కకేరున్ కూగుత్న తన్నె పుట్‍తాదినంజేవున్ సియిస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","అప్పడ్ హేరోదియ లె పిల్ల ఎద్‍తిన్. అద్ హేరోద్నె కుసీ వత్న రాజక్ అదున్ ఇంతెంద్. ఇనుంఙ్ పాజె అదున్ వెల్ సియ్‍సాత్ ఇసా ఇంతెంద్. నీ తన్నెన్ వెల్‍త్తెనా సియ్‍సాత్ ఇసా రాజ్యం ద్ సారె! ఇసా ప్రమనం కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","అపుడ్ ఆ పిల్ల సెత్న తన్నె అమ్మన్. అన్‍ తన్నెన్‍ వెల్‍దున్‍? ఇసా వెలుత్ ఓల్‍త్తిన్‍ బాప్తిస్మ సిఏక యోహాన్నే తల్లున్ వెల్! ఇసా అద్‍ఇడ్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","అపుడ్ అద్ వెంటాయ్‍ రాజక్వై తుల్‍సెత్న. బాప్తిస్మ సియ్యెకా యోహాన్నే తల్లున్‍ పుతుత్న కోజత్ ఇండుత్ పంఙి కొరేఙ్. ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","అపుడ్ రాజక్ నుంఙ్ గుల్ నారాజ్ ఎద్దిన్. గని తన్‍ కత్త కబుల్లి అని వెంట ఉద్దుత్ అండ సుట్టలుంఙ్ వాలడ్ అముదు తోద్ ఇనేంఙ్ సాలేతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","అపుడ్‍ అదుంఙ్ ఎత్తి రాజక్ వెంటనీ యోహాన్నే తల్లున్ కొరేఙ్ ఉక్కుమ్ సియుత్. ఒక్కొనున్ పన్కతెంద్. సిపాయిక్ జేలుంఙ్ సెత్న యోహాన్నే తల్లున్‍ మక్కుత్తి పుతుత్న. ");
INSERT INTO nit_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ఆ తల్లున్ ఒక్కొ కోజత ఇడుత్‍ తోడవత్న అదుంఙ్ సియ్‍సాద్. ఆ పిల్ల అదున్‍ తనే అమ్మఙ్ సియిస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ఆ గొట్టిన్ విత్నయెహనే సిసు వార్సర్. అని అమ్నె సరిరమున్ ఎత్తుత్ కొసుత్ తప్నెత్ ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","అపొస్తులున్ యేసున్‍వై వత్న తమ్మె కత్తవ్లున్. బదోల్ బొద ఇడ్‍తదున్ పురఅమ్నుంఙ్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ఔరున్‍వై గుల్‍మంది వర్సాసెసానంన్నెర్ అదుంఙ్ ఎత్తి ఔరుంఙ్ తిన్నెనాయ్ పురుసుద్ రొంబడెతిన్. అదుంఎత్తి యేసుంద్ అని అమ్నె సిసుల్. ఇసార్ ఎకున్ నీర్ అన్న వెంట వర్. మన్కకెర్ తోసెట జాగంఙ్ వత్న అలపుసుర్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","అదుంఙ్ ఎత్తి మల్ల ఔర్ మన్కకేరె తొస్సెట జాగంఙ్ తమ్మె రూకుత్ ఉద్దుత్ సేస్సార్. ");
INSERT INTO nit_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","గని. ఔర్ సెరెంఙ్ గుల్‍మంది ఓల్‍త్తెర్. సెరెకరున్ ఒర్కిలుత్‍ సింకానా ఊల్‍ తన తుల్‍సెత్న. ఔరుంఙ్ ఎన్నా ముండట్టి ఆమన్కకెర్ తోసెట జాగంఙ్ గదియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","యేసుంద్ రూక్‍ తన డిగ్గెగ మన్కకేరె గర్దిన్ ఓల్తెంద్. గయ్‍కి తోసెట గొర్రెలంఙ్ అనెకా ఆ మందిన్ ఓలుత్ అమ్నునుంఙ్ కివ్ వత్తిన్. అదుంఙ్ ఎత్తి ఔరుంఙ్ ఎన్నిగొ విసయలడ్‍ బొదఇడెంఙ్ మోదలిటెద్. ");
INSERT INTO nit_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","పోద్దు పడెగహ అమ్నె సిసు అమ్నున్ వత్‍ ఇస్సార్; ఇద్ మన్కకేరే తొస్సెట జాగ ఎంద్. గుల్‍సిర్మననాయ్ ఎద్దిన్‍. ");
INSERT INTO nit_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","నిర్‍ మందిన్‍ పన్కత్తె ఔర్ తిర్‍గొరఅనెకా ఉల్‍లెంఙ్ సెత్న తన్నెన్‍ ఎన్నా సుముత్‍ తిసార్‍ఇసా ఇడ్‍తెంద్‍. ");
INSERT INTO nit_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","గని యేసుంద్. ఔరుంఙ్ ఇడ్సద్. నీర్ ఔరుంఙ్ తినెంఙ్ తన్నెన్‍ ఎన్నాసియ్యుర్. ఇసా సామదనం ఇడ్‍తెంద్? దోన్సె వెండి కల్దల్ నిప్పల్ సుముత్ పాయ్‍ ఇసాతివ? ఇసా అమ్నున్ వెలుత్‍ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","యేసుంద్ ఔరున్ ఇస్సాద్ ఇంమత్తి ఏన్ని నిప్పల్ అస్సా? సేత్న ఓలుర్. ఔర్ ఓలుత్న ఇడ్సర్ అయిద్ నిప్పల్ అని ఇంది కయ్యె అస్సా. ");
INSERT INTO nit_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","అపుడ్ యేసుంద్ ఔర్ సట్టమున్ బూమి పొయ్ గడ్డి పొయ్ తినేంఙ్ ఇస్సా తిర్రగొర్ర ఉదేంఙ్ ఇడ్సన్. ");
INSERT INTO nit_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","నూర్ నూర్ అని పన్నాస్‍ పన్నాస్ ఇనంఙ్ పంగతు ఉత్సర్. ");
INSERT INTO nit_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","యేసుంద్ అద అయిద్ నిప్పల్ అని ఇందిఙ్ కయ్యెలున్ సుమ్ముతు పోయ్యి స్వర్గున్ ఓలుత్న దన్యవాద కత్న అద నిప్పలున్ మురుకుత్న పయెంఙ్ ఇస్సా తనే సిసులత్తి సియ్యిస్సా. అద ఇంది కయ్యెలున్ నాయ్యి ఔరుంఙ్ పయ్యుత్ సియ్యిస్సాన్. ");
INSERT INTO nit_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ఔర్ సట్టం మంది తిన్‍త దనిస్సార్. ");
INSERT INTO nit_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","మల్ల ఔర్ మిక్కత నిపల్లె తుకుడె అని కయ్యెలె గడ్డకా బార గంపలేఙ్ నీడప్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","అద నిప్పల్లుంన్ తినదర్ అయిదు వెల మంది పడ్సులు అస్సార్. ");
INSERT INTO nit_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","మల్ల అముదు మన్కకేరే గరిదిన్ సేరెంఙ్ ఇడ్సద్ అని తనే సిసులున్ జంల్లది రూకుత్ ఉద్దుత్ తనుంఙ్ ముండట్ అల్ల పక్కఙ్ బెత్సయిదా సెరువుంఙ్ సేరేంఙ్ ఇసా ఇడ్‍తెంద్. యేసుంద్ మందిన్ ఎరె ఎల్లక్లెంఙ్ ఔర్ సెర్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","యేసుంద్ ఔరున్‍ పన్కుకుత్‍ పార్తన కాలేంఙ్ మెట్ పొయ్యి సేస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ఆ సింతె వెలా ఆ రూకుత్ సెరువు నాడుమున్ అడిన్. యేసుంద్ ఒక్కొది ఆ జాగత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","గాలి ముదర్ వల్లడ్ వాత్తె తక్కిలిబడ్ ఈ రూకున్ తెడ్లడ్‍ తివ్వెకారున్ అముదు ఓలుత్న అని అముదు ఒక్కొ రూకుతనుంఙ్ ముద్దిఙ్ నాల్లిఙ్ గంటల్ లోపా సమ్దుర్త ఈర్‍ పొయ్యి అడగ్సని వార్సన. ఔరున్ మెర వర్రంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ఔర్ సముదురున్ పొయ్యి అడగేకానున్ ఓలుత్న అముదు బూతు ఎద్ ఇంత్న వాపొయ్యిసార్. ");
INSERT INTO nit_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ఔర్ సట్టం అమ్నున్ ఓలుత్న అర్సనెర్. గని యేసుంద్ ఔరున్ ఇస్సాన్. ఇమ్మత్ ఏక్కురు అని ఎదున్ని అర్సనేర్ ఇసా ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","అని అముదు ఔరెతి రూకుత్ ఉత్సన్. అపుడు గాలి మద్సద్. సిసు గులేనా కమల్‍ ఏర్సర్. గని తనయ్ కాలేతిన్. ");
INSERT INTO nit_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","తనుంఙ్ ఇంతే నిపటె పయ్త సమ్తకరున్ ఔర్ ఓల్తెర్ గని, ఔరె మనుత్ గుండ్ ఎదిన్ అదుంఙ్ ఎత్తి నీపటెలున్ బదొల్ ఔరు ఓర్కిలెతేర్. ");
INSERT INTO nit_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ఔరుంఙ్ సముద్రమును అపకంఙ్ రూకున్ కటుత్న గెన్నేసరెత్ దేసెమ్‍త దర్డిఙ్‍ వత్‍ అడ్‍గసా సెరెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ఔర్ రూక్ తన డింగతె మన్కకేరే యేసునున్ ఒర్కిలుత్. ");
INSERT INTO nit_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ఉలెంఙ్ తుల్సా తిరుగుత్ యేసును ఇంత్త అండెన్ ఏత్తినా ఔర్ వింతెర అత్తి దుకలాకేరును తేర్ పోయ్యి కొస్సెఙ్ ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","అముదు ఎద్ ఊరుఙ్ ఏక్కద్ పట్నముంఙ్ ఏక్కద్ కేనుత్ ఏల్లత సేదేనా. అత్తి దుకలాకేరున్ నిండత అంఙడి జాగత కొత్ ఇడ్సర్ అని యేసునే జుఙ్ఙెనె మూలన్ ఎన పుడుకేఙ్‍ ఇడ్డెఙా ఇనాత్ అమ్నున్ వింతి కాల్సార్. ఎత్తెయో అమ్నున్‍ పుడక్‍సార్ ఔర్ సట్టం సోయ్‍ ఏర్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","యెరూసలేమ్తన కొన్సెం మంది సాస్త్రి మన్కకెర్ వెంట పరుసి మన్కకెర్‍ వత్న యేసునాత్తి మిరయతెర్. ");
INSERT INTO nit_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ఔర్ యేసునే సిసు లోప కొన్సెంమంది కేయ్యు ఒడ్సెట ఔర్ తినేకారున్ ఓల్సార్. ");
INSERT INTO nit_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","పరుసి మన్కకెర్ అని యూద మన్కకెర్ తమ్మె దొడలె నేక్కిన్ సుమ్ముత్ సోయ్‍ కేయ్యులున్ ఒట్ట సివ్వాయ్ ఔర్ తినేర్. ");
INSERT INTO nit_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","అంఙడి కత్త వారుడుంఙ్ ఔర్ ఈర్ ఒట్ట సివ్వాయ్ తినేర్. అద వెంట మల్ల కొన్ని నేక్కికునాయ్ కన్నెర్. కన్స కొజ్జల్ అని దుత తెర్ అని తాలి నాయ్ ఒడ్‍నేర్. ");
INSERT INTO nit_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","అపుడ్ పరుసిక్ అని సాస్త్రి కులు యేసున్ ఇస్సార్. తనుంఙ్ ఇనే సిసు నేండె దొడలె నేక్కినాడ్ అడ్గనెర్ అని ఇనాయ్ ఒడుసేట్ట కేయ్యులాడ్ తిస్సార్? ");
INSERT INTO nit_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","యేసుంద్ ఔరున్ ఇస్సాన్. దెయ్యమ్నె గొట్టిక్ ఇండెకాద్ యెసయక్ నీర్ కప్టి మన్కకెర్ బదోల్ సోయ్ ఇసా ఈ మన్కకెర్ తమ్మె ముత్తినాడ్ అనేత్ మాన్ కాల్సార్ గని ఇవ్రె మన్‍ అమ్నత్త దవ్‍ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ఆగమి అనే బక్తి కాల్సార్ ఇంతె మన్కకేరే నివుడిప్‍తా నేక్కిన్ దెయ్యమ్నె గొట్టి ఏంద్. ఇంత్ కారపుత్ సియ్యుర్. ");
INSERT INTO nit_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","నీర్‍ కారే దెయ్యమ్నె ఆగ్యన్ సాయెతీర్ దొడలెనేక్కిన్ పక్క సుమ్‍త్తిర్. ");
INSERT INTO nit_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","యేసుంద్‍ ఔరున్‍ మల్ల ఇస్సాద్. దొడలె నేక్కిన్ కాల్లెంఙ్ సట్టి దెయ్యమ్నె ఆగ్యన్ మొడిపేకాదుంఙ్ ఇముంఙ్ సోయ్ ఏరకాఅన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","మోసే ఇనంఙ్ ఇంత్ అండెద్ ఇన్నె అమ్మ బానుంఙ్ మన్ ఇడ్ అని అమ్మ బానుంఙ్‍ సిరొప్ సియ్యెకాంద్ తిక్కెంఙ్ పడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","గని ఒక్కొమన్కక్ నంత్తి. తన్నె అమ్మ బానుంఙ్ సాయమ్‍ కలెంఙ్ కొన్సెం ఆస్తి అనెకాద్‍ అముదు ఔరున్. ఇద్‍ దెయ్యముంఙ్ సియెకాద్‍ ఇంతె. ");
INSERT INTO nit_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ఆ మన్కక్‍ తనే అమ్మ బానున్‍ సాయం కలెంఙ్ తోద్ ఇసా నీర్ అమ్నున్ సాడిప్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ఇమ్మె దొడలె నేకికున్ దెయ్యమ్నె ఆగ్యలున్‍ రద్ కల్‍సార్. ఇంట నీర్ ఎన్నిగొ మరొక్కొరుంఙ్ కాల్‍సాతిర్‍ ఇసా‍. ");
INSERT INTO nit_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","అపుడ్ యేసుంద్ మన్కకేరున్ తన వై కూగుత్న ఇస్సాద్. నీర్‍ సాట్టం అనేత్ విడ్ర అని ఒర్‍కిల్లుత్ సుముర్. ");
INSERT INTO nit_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","వాకా అనెకా మన్కన్‍లోపాసెదె అద మన్కన్‍ బద్‍లిపె. గని ఎదవెనా అమ్నె మన్‍తన వరెకా దెయ్యమున్ ముండట్‍ అపవిత్ర కలే. ");
INSERT INTO nit_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","మన్క నాత్తన వాకా వరెకా. అమ్నున్ అపవిత్ర కల్‍సా ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","యేసుంద్‍ మందిన్ సాయుత్‍ ఎల్లంఙ్ సెసెట్ట అమ్నె సిసులుంఙ్ ఆ ఉదహరనాన్ బదోల్ వెలుత్‍ ఓల్తెంద్‍. ");
INSERT INTO nit_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","యేసుంద్ ఔరున్ ఇస్సాన్. నీర్‍ సిమనా ఆగ్యలున్! వాకా అనెకాద్‍ మన్కన్ లోపా సేరేకా ఎదవి అమ్నున్ అపవిత్ర కలెంఙ్‍ సాలే ఇసా ఇముంఙ్ ఎర్‍కా తొద? ");
INSERT INTO nit_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","అద్ మన్కనె మన్నుత్ సెరెద్. పెట్టెక్ సెసద్ అంతె తన వాక సెసద్ ఇస ఇడ్డెన్ ఇనంఙ్ ఇడ్డెకద్ వాలడ్ అన్నిఙ్ పదర్తలున్ తినెంఙ్ పవిత్రత ఇస యేసు ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","అముదు మల్ల ఇనంఙ్ ఇంతెంద్. మన్కకేరే తన వాకా కురిస్సా అదవి మన్కకేరున్ అపవిత్ర కల్‍సా. ");
INSERT INTO nit_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","తానుంఙ్ ఇంతె మన్కకెరె మన్ తన వారెకా. ఇద వాయిట్ విచ్చర్ కరబ్ విచార్‍ డొగ్గబుదిన్ కునీ చిన్నలి కమ్. ");
INSERT INTO nit_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","లోబి, చినాలి, కప్ట్టి, దుస్మన్, ఏవ్వ, బద్నం, గర్వ సాడిగొట్ ముయ్యుజొర్ బుద్ది తోసెట వాకా వర్సా. ");
INSERT INTO nit_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ఇదవి సట్టం కరాబు. లోపా తన కురియ్యుత్ మన్కన్ అపవిత్ర కల్‍సా. ");
INSERT INTO nit_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","యేసుంద్ అత్తరనా కురుయ్యుత్న సేరెంఙ్ తూరు సిదొన్‍ బర్సెఙ్ సెస్సద్ అత్తి అముదు ఒక్కొనె ఎల్లత్ సొగుత్. ఆ గొట్టి ఏరుగి ఏరక్ ఏరెంఙ్ తోద్ ఇసాద్ గని డపేంఙ్ సాలేతెద్. ");
INSERT INTO nit_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ఒక్కొపిల్ల వెంటాయ్‍ యేసున్ బదోల్‍ వింతిన్‍. అద్నె పిల్లన్‍ ఆపవిత్ర ఆత్మ బూత్ అట్‍తిన్. అద్ అమ్నున్‍ వీంత్తికత్న అమ్నెగేట్ట మొక్సద్. ");
INSERT INTO nit_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ఆ గ్రీకు పిల్ల సిర్యి ఇన్నెకా పొనెసియ్‍దెస్‍తద్‍. జన్మిల్‍త పిలన్ ఆ బూత్ అట్‍తదున్ పుచెంఙ్ యేసునున్ వింతి కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","యేసుంద్ అదున్ ఇస్సాద్. ముండట్ పోరకేర్ తినత్ దనికార్. పోరకేరే అంబ్బలున్ పేతుకుత్ ఆతెలుంఙ్ జొపిడెకాదలంఙ్ దెయ్యమ్నె పోరకేరె అసిర్‍వదున్ ప్రబుంద్ ఇనుఙ్ సియెకాద్ సోయ్ తోద్ తా. ");
INSERT INTO nit_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","గని అద్ అమ్నున్ ఇసాద్. కారేయ్ ప్రబు గని పోరకేర్ రప్త మెత్తకుల్లున్ తెర్‍బుడ్ అనెక ఆతె తిస్సా! ఇసా అద్ సామదనం ఇడ్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","అపుడ్ యేసుంద్ అదున్. ఇసాద్ ఇనట సమాదనం ఇడ్‍తి. గని సే. బూత్ ఇన్నె పిల్ల సాయుత్ సెదిన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","అద్ ఏల్లఙ్ సెత్నతన్నె పిల్ల తెరుత్ మడియుత్ అనెకాదున్‍ ఓల్తిన్. బూత్ కరెయ్‍ అద్‍నంతన కురియుత్ సేదిన్. ");
INSERT INTO nit_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","మల్ల యేసుంద్ తూరు ప్రతమున్‍ సయుత్‍. సీదోనుంఙ్ సెత్న అత్రనట్‍ దెకపొలి బర్సనాడ్ గలిలీయ యత సముద్రంఙ్ గదియ్‍తెద్‍. ");
INSERT INTO nit_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","అత్తి కొన్సెం చెవ్డకెర్ ఒక్కొతొంత్తె మన్కకున్ యేసుకున్‍ మెర తోడవత్తెర్‍. అని అమ్నున్‍ పోయ్ కేయ్ ఇడెగ వింతి కాల్సర్. ");
INSERT INTO nit_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","అపుడు యేసును అమ్నున్ మంది తన్నా పకంఙ్ కొసుత్ అమ్నే కేవులోపా వెందెన్ కామతెన్ అని ఎవుర్ ఊసుత్న ఆ మన్కనె నాల్కన్ పుడక్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","పోయ్ స్వర్గును ఓలుత్న సోయ్త బదన్‍ పుస్తెద్‍ ఎపుడీతా ఇసా ఇంతెంద్ ఎప్పత ఇనెకద్ ఇంతె పుస్ ఇసా అర్తం. ");
INSERT INTO nit_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","అపుడి అమ్నె కేవులుంఙ్ విన్కవర్సద్. అమ్నె నాలక్ సోయ్‍ ఎర్సాద్. అముదు సోయ్ ముడెఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","అపుడ్ యేసును ఇద్ ఏరుంగి ఏరక్ ఏరేంఙ్ తోద్ అనఙ్ దట్టపుత్ ఇడ్సన్. గని ఏంతె అముదు ఇడ్‍తకొది ఔర్ అదున్ బదోల్‍ ఇంకా ఎక్కవన్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ఔరుంఙ్ గులెనా విచిత్రం తక్కుత్న. ఔర్. ఇమ్‌ద సట్టం గొట్టిన్ సోయ్ కాల్సన్. సేవుడకున్ నై విన్ గల్సద్ ముక్కకునాయ్ ముడెంఙ్ ఇడ్‍సాద్‍. ");
INSERT INTO nit_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ఆ దినలేంఙ్ పెనా మంది మిరయుత్ అస్సార్. ఔరుంఙ్ తినేంఙ్ తానయ్ తొత్తినా యేసుంద్‍ తనే సిసులున్ తనత్తిన్ కూగుత్న ఔరున్ ఇసాద్. ");
INSERT INTO nit_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","అనుగు ఇవుర్ మన్కకెర్ పొయి కివ్ వర్సద్. ఇవుర్ ముద్దిఙ్ దినల్ అనుగు వెంట అస్సర్ అని ఇవురుఙ్ తినెంఙ్ తనయ్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","అన్ ఇవ్రున్‍ కర్వుత్ ఏల్లంఙ్ పన్కతనింత్తె పావుత్ జిగ వాత్న రల్దర్. ఇవుర్ లోపా కొన్సెం దవు తన వాత్ అన్సార్. ");
INSERT INTO nit_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","అమ్మనే సిసు ఇస్సర్ మన్కకెర్ తొస్సెట్ జాగంఙ్ ఇత్తి ఇవ్రు మన్కకేరుంఙ్ తిన్నిపేంఙ్ ఏత్తరనా నిప్పల్ కొరేకాద్? ");
INSERT INTO nit_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","అముదు ఔరున్ వేల్తెంద్. ఇమ్మత్తి ఏన్ని నిప్పల్ అన్సా? ఔర్ ఇసార్ ఏడ. ");
INSERT INTO nit_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","మల్ల అముదు మన్కకేరే గరిదిన్ బూమిపొయ్ ఊదేంఙ్ ఇడ్సద్ అని అద ఏడ్ నిప్పలున్ సుమ్ముత్న దన్యావాద్‍ కత్న ముర్కుత్న వాడిపేంఙ్ ఇస్సా తనే సిసుంఙ్ సియ్‍సాద్. ఔర్ మన్కకేరె మందిన్‍వై వాడిప్సర్. ");
INSERT INTO nit_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","అవ్రతి కొన్ని సిన్నా కయ్యెనాయ్ అన్సా. అదవున్ నాయ్ అముదు దన్యావాద్‍ సియుత్న వాడిపెంఙ్ ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ఔర్ మన్కకెర్ తిన్త దనిసార్. మిక్త తుకుడె ఏడ్ దండి గంపలేఙ్ నిడప్సర్. ");
INSERT INTO nit_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","అత్తి నాల్లిఙ్ హజర్ల మన్కకెర్ అస్సర్. యేసుంద్ వెంటన్ని పన్కుత్. ");
INSERT INTO nit_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","మల్ల అముదు ఔరున్ పావిడుత్ సియ్యుత్. పావిడుత్తి అముదు తనే సిసులున్ వెంట రూకుత్ ఉద్దుత్ దల్మనూత జాగంఙ్ సేస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","పరుసిక్ వత్నమ్నున్ వెంట జగ్డ కల్సార్. అన్ అమ్నున్ పరిక్స ఓలేంఙ్ ఇసా ఆబార్ తన సిన్న ఒక్కొద్ ఓలిపేంఙ్ ఇస్సార్. ");
INSERT INTO nit_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","అపుడ్ యేసుంద్ తనే ఆత్మ లోపా నారాజ్ ఏత్న ఇస్సాద్. ఇవ్రు తనుంఙ్ సిన్నవెల్సర్? అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్ ఇవ్రుంగ ఒక్కొ సిన్న రొంబడెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","అముదు ఔరున్ సాయ్యుత్న మల్ల రుక్కుత్ ఉద్దుత్ హల్లహ పక్కఙ్ సేస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","సిసు తమున్ వెంట నిపటె కొరెకద్ మద్తెర్. ఔరతి రూకుత్ ఒక్కొ నిపటె సివయ్ తనయ్ తొతేద్. ");
INSERT INTO nit_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","యేసుంద్ ఔరున్ అర్‍పులిపుత్ ఇసాద్. ఓలుర్ పరుసి మన్కకేరే అని హేరోద్ ఇవ్రున్ కమ్మిర్ ఇంతె. పసెంఙ్ కాలేక పుల్లె పిండినె బదోలడ్ ఉస్సరడ్‍అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","గని ఔర్ ఒక్కొనేత్ ఒక్కొద్ ముడ్‍సార్ నేడత్తి నిప్పల్ నాయ్ తోతె ఇసా ద. ");
INSERT INTO nit_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ఔరె మనున్ ఒర్కిలుత్న యేసుంద్ ఇస్సాద్. ఇమ్మత్తి నిప్పల్ తోతె అనంఙ్ తనుంఙ్ విచ్చర్ కాల్సత్తిర్? ఇముంఙ్‍ ఇంక కరిలెదియ్య ఇంకనాయ్యి నీర్ ఒర్‍కిలెతిర్? నీర్ గొర్రెల్ ఏదిర్ ఏనంగే? ");
INSERT INTO nit_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","కాడ్ల అన్‍త ఓలెర? కేవ్వు అన్‍త్ వినేర? ఇమ్ముంఙ్ హద్ది తోతెద్? ");
INSERT INTO nit_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","అని ఐద్ నిప్పలున్ ముర్కుత్న ఐద్‍హజల్ మందింఙ్ పైఎంఙ్ మిక్త తుక్‍డె ఏనీ డలా నిడపత్తిరి? ఔర్ ఇసార్ బర. ");
INSERT INTO nit_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","ఏడ్ నిప్పలున్ నాల్లిఙ్ హజల్ మందింఙ్ పైఎంఙ్ మిక్కత తుక్‍డె ఏని దండి డాల నిండిపత్తిర్? ఔర్ ఇస్సార్ ఏడ్‍. ");
INSERT INTO nit_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","మల్ల అముదు ఔరున్‍ ఇసాద్. ఇమ్ముఙ్ ఇంకనాయ్ కారిలేత్తినా? ");
INSERT INTO nit_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","యేసుంద్ సిసులున్‍ బెత్సయిదా ఊరుంఙ్ వర్సద్. అత్తమంది గుడ్డిమన్కకున్ యేసున్‍వై తోడ వత్తెర్. అమ్నున్ తక్‍ ఇసా ఔర్ వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","యేసుంద్ ఆ గుడ్డినే కేయ్యున్ సుముత్న. ఊరు వాకా కోసుత్ అమ్నెకాడ్లెంఙ్ ఎవుర్ ఊసుత్న అమ్నున్ పోయ్ కేయ్ ఇడుత్న వేలుత్ ఓల్సద్ ఇనుంఙ్ తనేదెనా కాన్కెర్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","అముదు గుడ్డి కాడ్ల పుసుత్ పొయ్ ఓలుత్ ఇసాద్. మన్కకెర్ అనుంఙ్ కాడక్సర్. గని మాక్ లాఙ్ అడ్‍గేకారును ఓల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","యేసుంద్ మల్ల అమ్నె కాడ్ల పోయ్ కేయ్యున్ ఇడ్సద్ అపుడ్ అముదు సోయ్ ఏర్‍సాద్ ఓలెంఙ్ ఏదేంద్ సట్టమున్ని సోయ్ ఓలెంఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","యేసుంద్ అమ్నున్ ఏల్లఙ్ పన్‍కుత్ ఇసాద్. ఊర్ లోపా సేరేంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","మల్ల యేసును తనే సిసు వెంట కైసరియ పిలీప్పి జాగత్ ఇల్లుత్న సెరెంఙ్‍ తనే సిసున్ వేలుత్ ఓల్సన్. అన్న మన్కకేరే ఏంద్ ఏన్నెన్ ఇసా ముడ్నెర్? ");
INSERT INTO nit_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ఔర్ ఇసార్ బాప్తిస్మ సియ్యెకాన్ యోహాన్. మల్ల కొన్సెం నీవ్ దెయ్యమ్నె ప్రవక్త ఏలీయాక్ ఇసర్ మల్ల కొన్సెం నీవ్ దెయ్యమ్నె గొట్టికులు ఇండెకాన్ లోప ఒక్కొంద్ ఏన్నేన్ ఇస్సార్. ");
INSERT INTO nit_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","అముదు ఔర్ వేలుత్ ఓల్సద్ గని నీర్‍ అన్ ఎంద్ ఏన్నెద్ ఇసాతిర్. పేతురుంద్ జవాబ్ సియుత్న ఇసాద్. నీ నెమిప్త క్రీస్తుద్ ఏన్ని. ");
INSERT INTO nit_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","అప్పుడ్ అముదు ఔరుంఙ్ అర్‍పులిపుత్‍ ఇడ్సద్ అన్ బదోల్‍ ఏరుంగి ఇండెఙ్ తోద్, ఔరున్ దట్టిప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","మల్ల యేసుంద్ ఔరున్‍ బొద ఇడ్డెంఙ్ మొదలిట్టెంద్. మన్కనె పోరక్ అన్ రంఙ్‍ రంఙ్‍ తా తక్కిలిబున్ సొస్సిపేంఙ్ పడ్సద్. మన్ వాల్లెల్ బర్స దెయ్యలకేర్ అని సాస్త్రిక్ అన్న ఇడొలుంఙ్ హల్లెగేకార్ అన్సార్. గని ముద్దిఙ్ దినాలుంఙ్ అన్ తిక్‍త తాన సులత్‍. ");
INSERT INTO nit_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ఈ గొట్టి అముదు కులా ఇడ్సద్. పేతురుంద్‍ అమ్నున్ పక్కంఙ్ కొసుత్ అమ్నున్ సిరయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","అపుడ్ యేసుంద్ తిరుగుత్న తనే సిసులున్ ఓలుత్ పేతురు దట్టిపుత్ ఇసాద్. ఏ సైతన్ అన్ తన నీ కురూయుత్ సే నీ మన్కకెరే గొట్టిత వాయ్ గ్యాన్ గని దెయ్యమ్నె గొట్టిన్ వాయ్ గ్యాన్ ఇండెతి. ");
INSERT INTO nit_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","మల్ల అముదు తనే సిసు వెంట మన్కకేరే గరిదిన్ కూగుత్న ఔరుంఙ్ ఇడ్సద్. ఏదేన్ అన్న వెంట వారెంగ ఓల్సద్ ఏరతె అముదు తనే తున్ సాయ్యుత్న తనే సిలువ ఇంతె తరస్ తక్కిలిబున్ కాజుత్న అన్ వెంట వెరెంఙ్ పజే. ");
INSERT INTO nit_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ఏద్‍ తనే పానమున్ బత్కిపేంఙ్ ఓల్‍ సాదొ అముదు అదున్ బుడప్సద్. గని అన్నె సువార్త బదోల్ ఏదెక్కద్ తనే పానమున్ గమప్సద్ అముదు అదున్ బంతికిప్సద్. ");
INSERT INTO nit_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","మన్కక్ సట్టం దున్యన్ ఒక్కొరిప్తద్ తనే పానమున్ నాస్టం ఏరేంఙ్ ఇటేదింతె అమ్నుంఙ్ లాబం అన్సాంద్. మన్కక్ తనే పానముంఙ్ ఇస్సా తనేద్ సియ్యెంఙ్ సాల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","మన్కక్ తనే పానముంఙ్ ఇస్సా తనేద్ సియ్యెంగ సాల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","చినలి, పాప్ ఎరెకా ఈ పిడిత్ ఎరెన అన్ బదొల్ అన్నె గొట్టికున్ బదొల్ లజంఙ్ వత్తె మన్కనె పోరక్ తన్నె బానె మహిమనడ్ పవిత్ర దెయ్యనె దూతులాడ్ కలయుత్ వరెఙ ఆ మన్కక్ లజంఙ్ వార్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","యేసుంద్ ఔరుంఙ్ ఇడ్సద్. అన్ ఇమ్ముంగు కరెయ్ ఇడ్సత్. ఇత్తి ఇల్లుత్ అనెకర్ లోపా కొన్సెంమంది దెయ్యమ్నె సక్తిత రాజ్యమున్ ఓల్‍సెట ఔర్ తికెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","మల్ల ఆర్ దినాలుంఙ్ వెన్కత్‍ యేసుంద్ తన వెంట పేతురు. యాకోబ్‍ అని యోహాన్ ఇవ్రున్ ఒక్కొద్ దండి మెట్‍ పోయ్ పక్కంఙ్ కొసుత్. అని ఔరె వెంట అనెంఙ కొన్సెం యేసుంద్ బద్లిలెకాదున్అవ్రు ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","మల్ల అమ్నె జుఙ్ఙె ఇంతె సక్ తెలొడి తరియ్నె అంతె తెలొడిన్ ఇద్‍ దున్యత వట్టిద్ గిన ఇంతె తెలొడి సెల్పెంఙ్ సాలేన్‍. ");
INSERT INTO nit_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","అపుడ్ ఏలీయాక్ అని మోసే యేసుంన్ వెంట ముడెకదున్ ఔర్ సిసు ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","అపుడ్ పేతురు యేసుకున్ ఇసాద్. గురు. నేండ్ ఇత్తి అనెకాద్ సోయ్. అమ్ ముద్ది గుడిసే ఇడ్సతుమ్ ఇనుఙ్ ఒక్కొద్ అని మోసేఙ్ ఒక్కొద్ ఏలీయా కుఙ్ ఒక్కొద్. ");
INSERT INTO nit_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ఔర్ గులేనా అర్సుత్ అన్సార్ తన్‍ ముడెకాద్ పేతురునుంఙ్ కరిలేతిన్ అనంఙ్‍ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","అపుడ్‍ ఒక్కొద్ ఆబార్ వర్సద్ అని ఔరున్ నిండనాడ్ ముంస్‍సాద్. అపుడ్ ఆబార్ తన. ఇనంఙ్ విన్క వత్తిన్ ఇమ్‌ద అనే లాడ్త పోరక్ ఏన్నెద్. ఇమనేత్ విడ్ర? ");
INSERT INTO nit_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","అపుడి ఔర్ ఒక్కొది ఉస్సట్ తిర్రగొర్ ఓలేంగ ఎది కండ్కెరెతెద్‍ గని యేసున్ సివాయ్ ఏది కన్కెరేతిన్. ");
INSERT INTO nit_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ఔర్ మెట్ తన డిగ్గెంగ యేసుంద్ ఔరుంఙ్ ఇడ్సద్ మన్కనె పోరక్ అన్ తిక్‍త తన సులేకాదున్ నీర్ ఓలుర్ ఇమ్‍దున్ ఏరుంగి ఇండనేర్ ఇసా ఆగ్య సియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","అదుంఙ్ ఎత్తి ఔరె గొట్టిన్ తమ్మతిని డపుత్‍. తికుత్‍ బత్కుత్‍ వరెకదుంఙ్ బదోల్‍ ముడ్‍నెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ఔర్ యేసునున్ వేలుత్ ఓల్సర్. సాస్త్రి మన్కకెర్ ఇనంఙ్ తనుంఙ్ ఇనేరే? ఏలీయాక్ వారేంఙ్ పాజె ఇసా తనుంఙ్‍ ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","అముదు ఔరుంఙ్ ఇడ్సద్. ఏలీయాక్ ముండట్ వాత్న సట్టం గొట్టిన్ సోయ్ కాల్సనంసాద్ ఈ గొట్టి కారే అన్సాంద్. గని మన్కనె పోరక్‍ రంఙ్ రంఙ్ తా తరస్ తక్కిలిబులున్ సొసిప్దన్ అని అమ్నెత్ మనిలేర్‍ తా అనంఙ్ వాయ్యుత్ తోతె వా? ");
INSERT INTO nit_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","అన్ ఇముంఙ్ ఇడ్సత్ ఏలీయాక్ నాయ్ వతెంద్. అమ్నున్ బదోల్ వాయ్‍త గొట్టినే లెక్కనడ్ ఔరుంఙ్ ఇడ్సద్ అనంఙ్ అముదు లంఙ్ కల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","మల్ల యేసుంద్ సిసుంఙ్ వత్న ఔరున్‍ తిర్‍గొర్ అనెక్ మన్కకేరే గరిదిన్ అని ఔరున్‍ వెంట జగ్గడ్హ కాలేకార్ సాస్త్రికున్ ఓల్సన్. ");
INSERT INTO nit_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","అపుడి యేసునున్‍ ఓలెంఙ్ య్‍ మన్కకెర్ సట్టం గులేనా విచిత్రం ఏత్న అమ్నున్‍వై తులుస్సా సేత్న అమ్నున్‍ ముజర సుమ్‍స్సార్. ");
INSERT INTO nit_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","యేసుంద్ ఔర్ సిసులున్ ఇసాద్. తనేదుంఙ్ వాలడ్ జగ్గడ్ కత్తిర్? ");
INSERT INTO nit_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","మన్కకేరే గరిది తన గురు అమ్‍నుంఙ్ జవాబ్ సిస్ద్‍ అన్ ఇన వాయ్ అనే పోరకున్ తొడ వత్తన్. ఇమ్నున్ అపవిత్ర ఆత్మ అంట్‍తనున్ మూకక్ కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","అద్ ఇమ్నున్ ఎత్తి ఎత్తి సుమ్‍సాద్ అత్తి బూడున్ రప్సద్. అపుడి అముదు పల్కులున్ కొర్‍కుత్‍ ముత్తిత్ పేస్ కొత్న తిక్‍తద్ లంఙ్ అని తండెకాదలంఙ్ ఏత్న రల్సద్. అపవిత్ర ఆత్మ పుస్సెఙ్ ఇస్సా ఇనే సిసులున్ ఇడుత్ గిన ఔర్ సాలేతెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","యేసుంద్ ఔరున్‍ ఇసాద్ ఏ విస్వాస్ తోసెట పడితార్. ఏతెంగడి అన్ ఇమున్‍ వెంట అదున్? ఎతెగడి ఇమ్మెత్ సోయ్యున్ కాలేకాద్? ఆ పోరకును అన్‍వై తోడవర్‍ ");
INSERT INTO nit_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ఔర్ పోరకున్ అమ్నున్‍వై తోడవర్సర్. అముదు అమ్నున్ ఓల్త వెంటాయ్ ఆ బూత్ అమ్నున్ విల్విల్ ఎద్దెంద్, అముదు బూడున్ రాలుత్ననొల్లంగెఙ్ ముత్తిత్ పేస్ కొత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","యేసుంద్‍ అమ్నెతక్కున్ వేలుత్ ఓల్‍నేద్. ఇమ్నుంఙ్ అనంఙ్ ఎత్నఏన్నిగొల్ ఎర్సద్? అముదు ఇసాద్ సిన్నం తన. ");
INSERT INTO nit_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","అద్ ఇమ్నున్ నాసకత్న అల్ఙెంఙ్ కాలేకాదుంఙ్ ఇసా పెల్లెగుసల్ కిస్సుత్ అని ఇరుత్ జొపిటిన్ గని ఇనేడ్ అద్ ఏర్‍సాద్‍ఎరత్తె అమ్నున్ పోయ్ కివ్ కత్న అమ్నున్ సాయం కాల్. ");
INSERT INTO nit_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","యేసుంద్ అమ్నుంన్ ఇసాద్ “నీ విస్వాస్ ఇట్టె దెయ్యముంఙ్ సిమ్కన ఎర్స” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","వెంటాయ్‍ ఆ పోరక్‍నె బద్‍ ఔరున్ వాపొయుత్ ఇసాద్. అన్ విస్వాసం ఇడ్‍సాత్ గని పెరెత్తొద్ అన్నె విస్వాసం పెర్గెంఙ్ ఇసా యేసునున్ వెల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","అపుడి పేరెత్ మన్కకెర్ మిరయుత్ తుల్‍స్స వారెకారున్ యేసుంద్ ఓలుత్న అద్ ఆపవిత్ర ఆత్మ అట్తనున్‍ దట్టిపుత్న ఇసాద్ ఏ ముక్కి సేవుడ్ అపవిత్ర ఆత్మ. ఇనుంఙ్ అన్ ఇడ్సత్. ఇమ్నున్ తన కురుయుత్ సే. మల్ల ఏపుడి ఇమ్నున్ లోపా సొంగనేమ్. ");
INSERT INTO nit_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","అద్ వపొయుత్న అముదు పోరకున్ గులేనా గుర్రె వాత్న వాకా కురియ్‍సాద్ అత్తి అనెక మన్కకెర్ ఇమ్‌ద తిక్‍సాద్ ఇసా ఇన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","యేసుంద్ అమనే కేయ్యున్ సుమ్ముత్ అమ్నున్ సులుప్సద్ అముదు సులుత్ ఇల్సాన్. ");
INSERT INTO nit_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","యేసుంద్ ఏల్లవాయ్ సేద్దె అమ్నె సిసు ఒక్కొది అనేంఙ్ అమ్నున్ వేలుత్ ఓల్సర్ తనుంఙ్ అమ్ అపవిత్ర ఆత్మలున్ ఏదగెంఙ్ సాలేతమ్? ");
INSERT INTO nit_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","యేసుంద్ ఔరున్‍ ఇడ్సన్ ఇద్ జత్తిత అపవిత్ర ఆత్మలున్‍ ఉపాస్ పార్తన సివయ్ తనేదనాడ్ నాయ్ కురిస్సాతొతెద్. ");
INSERT INTO nit_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","యేసుంద్ అమ్నె సిసు అత్తరన కురుత్న గలిలీయ బర్సనాడ్ సేస్సర్ గని యేసునే ఇనంఙ్ సెసద్‍ ఇసా ఎరుఙ్నాయ్ ఒర్కి ఎరెఙ్ తోద్. తానుంఙ్ ఇంతె తనే సిసులున్ కారప్‍సా ఇసాద్. అన్ మన్కనె పోరకున్ మన్కకేరే కెయ్యుత్ సుమ్ముత్ సియెకాద్ వర్సాద్. గని ముంది దినములుంఙ్ అముదు తిక్తతన సుల్‍దద్. ");
INSERT INTO nit_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","గని ఔరుంఙ్ ఈ గొట్టి కారిలేత్తిన్ అని ఆ గొట్టి బదోల్ అమ్నున్ వేలుత్ ఓలెంఙ్ అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ఔర్ కపర్నఊరుమఙ్ వర్సర్ అత్తి ఔర్ ఎల్లత్ అనేంగ అముదు ఔరున్ వేలుత్ ఓల్సద్. పావుత్ నీర్ తనేద్ బదోల్ గోట్టి ముడనిర్? ");
INSERT INTO nit_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ఔర్ దబ్ ఎస్సర్. ఔర్ పావుత్ తమ్మె లోపా ఎద్ దండి ఎన్నెంద్ అనంఙ్ ఔరేత్ అవురి గొట్టి ముడ్ససర్. ");
INSERT INTO nit_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","యేసుంద్ ఉద్దుత్ బర మందిన్ కూగుత్న ఇసాద్. ఏద్ ముండట్ ఏరేంఙ్ ఓల్సద్. అముదు సటముఙి వెన్కతద్ ఏరేంఙ్ అని నీ సట్టముంఙి సిన్నం సట్టముంఙ్ బూడున్ గడియక్ లంఙ్ అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","మల్ల అముదు ఒక్కొ సిన్నమ్ పోరకున్ సుముత్న ఔరె నాడ్మన్ ఇల్‍ప్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","ఏద్ అనే పేరడ్ ఈ సిన్నం పోరకేర్ లంఙ్ అంసాదొ అముదు అన్ ఒర్కిలెకద్ లంఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","యోహాన్ అమ్నున్ ఇసాద్. గురుజి ఇనే పేరడ్ అపవిత్ర ఆత్మలున్‍ ఏదెగేకాద్ ఒక్కొనున్ ఓలుతమ్. అముదు నేడతద్ ఎరేంద్ అమ్నున్ తోద్ ఇంతమ్. ");
INSERT INTO nit_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","గని యేసుంద్ ఇసాద్. అమ్నున్ తోద్ ఇనేర్ ఎందేనా అనే పేరడ్ సమత్కాల్ కాల్సద్ అముదు అనుంఙ్ విరొది ముడెంఙ్ సాలేద్. ");
INSERT INTO nit_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ఏద్‍ నేడుంఙ్ విరొది తోతెద్. అముదు నేండెరి అసార్. ");
INSERT INTO nit_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","అన్‍ కరెయ్ ఇడ్సత్‍ ఎద్‍ క్రీస్తునె పేరున్‍ సుముత్ వర్సదొ ఉనెఙ్ ఒక్కొ గిలసెడ్ ఈర్ సియ్‍తెరింత్తె అమ్నుంఙ్ ఆసిర్వాద్ రొంబాడద్‍. ");
INSERT INTO nit_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ఎరేనా ఈ సిన్న లొపవిస్వాస్ ఇడ్డెకారున్ ఒక్కొనున్ విస్వాసుత్ అడ్డమెద్దె. అమ్నె మకుత్ దండి తిర్గలున్ కాటుత్న అమ్నున్ గంగత్‍ జొప్పిడెకాద్ అద్ అమ్నుంఙ్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ఇనే కేయ్ పాప్ కలేంఙ్ కారన్ ఎద్దె, అదున్ ముర్‍కుత్ జొప్పిడ్. ఇన్నెఇందిగ్ని కేయ్యు అన్‍త నరకముంఙ్ ఇంతె కిస్‍కిట్‍సెట్ట కిసుంఙ్ సేరెకదుంఙ్ ఏన్న కుట్టిక్ ఏత్న నిత్యజివముంఙ్ సేరేకాద్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","నరకముత్ పుర్రె తిక్కె కిస్ కిట్టెద్. ");
INSERT INTO nit_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ఇనే గెట్ట ఇన్న పాప కాలేంఙ్ కారన్ ఎద్దె అదున్ ముర్కుత్‍ జొపిడెకద్ సోయ్. ఇందిగ్న గేట్ట అన్‍త్న ఇన్ నరకముత్ జొప్పిడెకాదుంఙ్ ఏన్న కుంట్టి ఏత్న నిత్యజివముంఙ్ సేరేకాద్ అద్ ఇనుంఙ్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","నరకముత్ పుర్రె తికె కిస్ కిట్టెద్. ");
INSERT INTO nit_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ఇనే కాన్న ఇన్ పాప్ కలేంఙ్ కారన్ ఎద్దె అదున్ పుసుత్‍ జొప్పిడ్. ఇందిగ్న కాడ్ల అన్‍త ఇన్ నరకముంఙ్ జొప్పిడెకాదుంఙ్ ఏన్న గుడ్డి ఏత్న దెయ్యమ్నె రాజ్యముంఙ్ సేరేకాద్ ఇనుంఙ్ సోయ్. ");
INSERT INTO nit_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","నారకముత్ పుర్రె తిసద్‍ అద్‍ తిక్సతొతె అని తరియెక కిస్స కిట్సతొతెద్. ");
INSERT INTO nit_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ప్రత్యెక్ మన్కక్ ఈ కిసుత్ అనుబవ్‍ సుమ్దద్‍. ఎనంఙ్ సుపున్ రుసి ఓల్‍సారొ అనాయ్ ప్రతి ఒక్కొనున్ పర్సి కలెకద్ వరద్. ");
INSERT INTO nit_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","సుపు సోయ్ గని అదనే రుసి సేదిన్ ఇంతె ఏనఙ్ రుసిన్ కొరెంఙ్ సలతిర్‍? అదుంఙ ఎత్తి నిర్‍ సోయ్త సుప్‍లంఙ్ అండ్రు ఒక్కొనెత్‍ ఒక్కొద్‍ సమాదానడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","యేసుంద్ అంతె తన కురియుత్న యూదియ దేసెంముంఙ్ సెదెఙ్ అత్రనట్‍ యోర్దన్ పేనింఙ్ అల పక్కంఙ్‍ సెద్దెంద్. ఎత్తెయొ మంది మన్కకెర్ అమ్నున్వై మిరయ్సర్. యేసుంద్ ఏపుడి కరపేకద్లాంఙ్ అముదు ఔరుంఙ్ కారపేంఙ్ లాక్సద్. ");
INSERT INTO nit_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","కొన్సెం మంది పరుసియు అమ్నున్ పరిక్స ఓలెంఙ్ ఇసా వత్న అమ్నున్ వేలుతొల్సార్. మన్కక్ తన్నె మాసలూన్‍ పర్‍కత్‍ నామ సియెకాద్‍ బరబార్ అన్సద తొద? ఇసా వెలుత్‍ ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","యేసుంద్ ఔరున్ వేలుత్‍ ఓల్సాంద్. మోసే ఇమ్ముంఙ్ ఇడ్‍త ఆగ్య తానెద్ ఎంద్? ");
INSERT INTO nit_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ఔర్ ఇస్సార్ సిక్‍పుత్తెక్ ఉత్తర్ వాయుత్ మాసలున్ సాయ్యెఙ్ మోసేనె నేక్కి సియుత్ అన్సాద్ ");
INSERT INTO nit_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","యేసుంద్ ఔరున్ ఇస్సాంద్ నీర్ ముడెకదున్ వింసెటర్‍లఙ్‍ అముదు ఈ ఆగ్య వాయితెంద్. ");
INSERT INTO nit_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","దెయ్యం దున్యన్ గడిప్తే పిల్ల అని పడ్సున్ గడిప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ఇదుంఙ్‍ వల్లాడ్ మన్కక్ తనే అమ్మ బానున్‍ సాయుత్న మాసలూన్‍ వెంట కలయుత్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ఔర్ ఇదర్న ఒక్కొది సరిరం ఏర్సార్. ఔర్ ఇద్దర్‍ ఇంది సరీరాడ్ ఏరేర్ గని ఒక్కొది సరీరాడ్ ఎన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ఇదుంఙ్‍ వాల్లాడ్ ఒక్కొద్‍ ఎద్దరున్‍ దెయ్యం జొడిప్తదూన్‍ మన్కకెర్‍ పయ్‍పెంఙ్ సాలెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","యేసుంద్ ఎల్లఙ్‍ వర్సార్. అమ్నే మల్ల సిసున్ ఆ గొట్టిన్ బదోల్‍ వేలూత్‍ ఓల్సార్. ");
INSERT INTO nit_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","యేసుంద్ ఔరున్ ఇసాద్ ఏద్ తనే మాసలున్ సాయుత్న మరొక్కొదున్‍ కాల్సన్. అముదు పేండ్లిత మాసలుంఙ్. విరొది చినలి కాలేకాంద్ ఏర్సన్. ");
INSERT INTO nit_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","అని మాస తనే మాసున్ సాయుత్న మరొక్కొనున్ కత్తినింతె అద్ నాయ్ చినలి కాలేకాద్ ఏర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","మల్ల మన్కకెర్ సిన్న పోరకేరున్ యేసుంద్ కూగుత్న అమ్నున్‍వై తోడవానేర్. అమ్నె సిసు ఔరున్ కొరేకారున్ దట్టిప్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","అదున్ ఓలుత్ యేసునుంఙ్ గులేనా వాయిట్ వాట్టిల్సద్ అని ఔరున్‍ ఇసాద్. పోరకేరున్ అన్‍వై వారేంఙ్ ఇడుర్. ఔరున్‍ తోద్ ఇనేంఙ్ తోద్ దెయ్యమ్నె రాజ్యం ఇంటర్ లంగీఅన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్. ఏద్ దెయ్యమ్నె రాజ్యమున్ సిన్నమ్ పోరక్ లంఙ్ సుముత్‍ తోతెద్. అముదు అత్తి స్వర్గముత్ సెరెంఙ్ సాలేద్. ");
INSERT INTO nit_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","అముదు పోరకేరున్ ఏల్లంఙ్ కూగుత్న ఔరున్‍ పోయ్ కేయ్ ఇడుత్న ఔరుంఙ్ ఆసిర్వాద్ సియిస్సద్. ");
INSERT INTO nit_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","యేసుంద్ కురియుత్న పావడ్ సేరేంఙ ఒక్కొద్ మన్కక్ తుల్ వాత్న అమ్నె ముండట్ ముడ్సు టేక్కిపుత్ అమ్నున్‍ వేలుత్ ఓల్సద్. సోయ్త గురుజి ఎప్పుడి పానం రొబ్బడెకాదుంఙ్ అన్ తనెద్ కాల్లెకాద్? ఇసా వెల్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","యేసుంద్ అమ్నున్ ఇసాద్. అన్నా తనుంఙ్ నీ సోయ్ తంద్ ఇసాతి. దెయ్యం సివాయ్ ఏద్ నాయ్ సోయ్ తద్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","దెయ్యమ్నె ఆగ్య ఇనుంఙ్ ఎరకాయ్ అన్సాత. హత్య కానేమ్. చినలి కన్నెమ్. పుస్సడ్ సాక్సమ్ సియినేమ్. పసిప్నెమ్. ఇనేఅమ్మ బావునేత్ మన్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","అముదు ఇసాద్. ఓ గురుజి అన్ సిన్నం తన అద నేక్కికుల్లున్ కాల్సన్ని వత్తన్. ");
INSERT INTO nit_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","యేసుంద్ అమ్నున్‍ ఓలుత్న, అమ్నున్‍ ప్రేమ్ కత్ ఇసాద్. ఇనత్తి ఒక్కొద్ తుట్టి కానకెర్‍సాద్‍. సే అని ఇనుంఙ్ స్వర్గదిపుత్ పూర దనం అనెంఙ్ ఇసా ఇనే సట్టమున్ సాయుత్‍ అన్ వెంట వా. ");
INSERT INTO nit_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","అదున్ విత్నఅమ్నె చేర సిబ్బిలుత్న అముదు గుంలేన దనవంతక్ అన్సాద్. నారాజడ్ కురియుత్ సెసాద్. ");
INSERT INTO nit_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","అపుడి యేసుంద్ తిరగొర్ ఓలుత్న సిసులున్ ఇసాద్. పైసెలకుంఙ్ దెయ్యమ్నె రాజ్యంఙ్ వారేంఙ్ ఇంతె కాట్టిన్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","సిసు అమ్నె గొట్టికుంన్ కామల్‍ కత్న. యేసుంద్ మల్ల. సిసులరా! దెయ్యమ్నె రాజ్యముంఙ్ సెరెకాద్ ఎత్తె కట్టినొ? ");
INSERT INTO nit_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","పైస్సెల్ వల్లెల్ దెయ్యమ్నె రాజ్యం త్ సోగ్గెకాదుగు ఏన్నహ ఓట్ సూదినె బొగ్గనాడ్ కురుఎకాద్ సాస్సతె అస్సాదహ. ");
INSERT INTO nit_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","అపుడ ఔర్ గులేనాకమల్ కత్న ఒక్కొనేత్ ఒక్కొద్ ఇనెంఙ్ ఎద్దెర్ తె ఎరెత్ తరన్ ఎరద్? ");
INSERT INTO nit_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","యేసుంద్ ఔరున్‍ ఓలుత్ ఇసాద్. మన్కకెర్ సాలేర్ గని దెయ్యం సాల్‍సాద్ తానుంఙ్ ఇంతె దెయ్యం సాట్టం గొట్టిత్ సాక్కిల్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","పేతురు అమ్నున్‍ ఇసాద్ ఓల్ అమ్ సట్టమున్ సాయుత్న ఇన్ వెంట వార్సన్సాతుమ్. ");
INSERT INTO nit_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","యేసుంద్ ఇసాద్ అన్ ఇమ్ముగు కరెయ్ ఇడ్సత్. అనుంఙ్ సటీ అని సువార్తఙ్‍ సటీ, ఎంద్ తన్నె ఎల్లన్, తోరెంద్ ఎక్కద్, తోర్దాసిక్ ఎక్కద్, అమ్మన్, బానున్, మాసలున్, పోరకేరున్, ఎన సాయ్‍దాంద్. ");
INSERT INTO nit_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","అమ్నుంఙ్ కాడుత్ తక్లిబు వెంట నురంతల్లు ఎల్లకున్ అని తోరెంద్ అని తోర్దాసిక్ లున్. అని అమ్మలును. పోరకేరును అని కెడ్లును అని వెనకత్ వారేకహ దినములుగు ఎప్పుడి పానం పక్క రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","గని పంఙి ముదర్ అనెకర్ స్వర్గుతు వెనకహ పడ్సర్. అని పంఙి వెనకహ అనెకర్ స్వర్గుతు ముండట్ పడ్సర్. ");
INSERT INTO nit_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ఔర్ యెరూసలేమ్ ఉర్‍ పావుతు సేరెంఙ్ యేసుంద్ ఔరుంఙ్ ముండట్ సేన్నెద్. ఔరున్‍ కామల్‍ వాట్టిలుత్న. అమ్నున్‍ వెనక సేరెకార్ అర్సార్. అముదు బర మందిన్ పక్కంఙ్ కత్న ఔరుంఙ్ తనుంఙ్ ఏద గడిల్తె అద ముండట్ గొట్టికున్ బదోల్ ఇండెఙ్ లాక్సద్. ");
INSERT INTO nit_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ఓలుర్ నేండ్ యెరూసలేముంఙ్ సెస్సనంసతుమ్. అత్తి మన్కనె పోరక్ అన్ బర్స దెయ్యలకేర్ అని సాస్త్రి మన్కకరే కేయ్యుత్ సియ్‍దర్. ఔర్ అన్‍ అల్లంఙెంఙ్ తయ్యరేత్ యూదులెర్సెటార్ కెయ్యుత్ సియిసార్. ");
INSERT INTO nit_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ఔర్ అమ్నున్ అప్మాన్ కత్న అమ్నున్ పోయ్ ఏవుర్ ఊసుత్న సాటడ్ దనప్సర్ అని హల్గస్సర్. గని ముద్ది దినాలుంఙ్ అన్ తిక్త తన సులత్. ");
INSERT INTO nit_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","జెబెదయినె పోరకేరును యోహాన్ అని యాకోబ్‍ యేసును మెర వాత్న ఇసాద్. గురుజి అమ్ ఇన్నతి తనేన్ ఏనా వెల్‍సాత్ అద్ నీ అముంఙ్ వల్లడ్ ఇందరేంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","యేసుంద్ ఇసాన్ అన్ ఇముంఙ్ వాలడ్ తనేద్ కాలేంఙ్ అనుంఙ్ ఇమ్మె అసా అన్సాంద్? ");
INSERT INTO nit_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ఔర్ ఇన్నె మహిమన్ అమ్నున్ ఇస్సార్. ఇనే ఏరకతద్ ఇంతె ఇనేత్ మనిలేకాద్. దినముత్ అమున్ లోపా ఒక్కొనున్ ఇనే ఉన్న పక్కంఙ్ అని ఒక్కొనున్ ఇనే ఎడమాపక్కంఙ్ ఉదెంఙ్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","గని యేసుంద్ ఔరున్‍ ఇసాద్. నీర్ తనేన్ వెలాతిర్ అద్ ఇముంఙ్ ఏరక తోతెద్. ఏంద్ తక్లిబున్‍ సొస్సిపుత్న అంసత్ అదున్ నీర్ సొస్సిపేంఙ్ సాల్సతిర్? అని ఏద్ బాప్తిస్మ నీర్ సుమ్మెంఙ్ సాల్సతిర్? ");
INSERT INTO nit_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ఔర్ అమ్నున్‍ ఇస్సార్ సాల్సతుమ్ మల్ల యేసుంద్ ఔరున్‍ ఇస్సాద్. కారే. అన్న వెంట తక్లిబున్‍ సొసిప్సతిర్. అని ఏద్ బాప్తిస్మ నాడ్ అనేత్ బాప్తిస్మ ఏర్సద్ అద్ బాప్తిస్మ నీర్ సుమ్‍తిర్ కారే. ");
INSERT INTO nit_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","గని అనే ఉన్న పక్కంఙ్ అని ఎడమ పక్కంఙ్ ఉందేంఙ్ ఇండెకాద్. తోతెద్ అద్ ఏరుంఙ్ దెయ్యం వల్లడ్ తయార్ కత్న అన్సాద్ అవ్రుంగి రొంబడ్సాద్‍. ");
INSERT INTO nit_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ఇద్‍ వింతదున్‍ మిక్కతర్ ఇంతె పదిమంది సిసు ఇదున్ వింత్న యాకోబ్‍ అని యోహాన్ పోయ్ రగుంఙ్ వార్సర్. ");
INSERT INTO nit_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","యేసుంద్ ఔరున్‍ మెరంకూగుత్న ఔరున్‍ ఇడ్సద్. ఇముంఙ్ ఏర్క అన్సాద్. యూదులెర్సెటర్ అదికల్ ఔరె మన్కకెర్ పోయ్ గులేనా జోరానట్ సాత్త అడిగప్సర్. అని ఔరె దొడమన్కకెర్ ఔరున్‍ పోయ్యి గులేనహ జోరానడ్ అదికార్ కాల్సర్. ");
INSERT INTO nit_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","గని ఇమున్‍ లోపా అనంఙ్ ఏర్రెంఙ్ తోద్. ఇమున్ లోపా ఏదేన దొడద్‍ మన్కక్ ఏరేంఙ్ ఓల్సద్ ఏరతె అముదు ఇమ్మె గడియక్ లాఙ్ ఏరేంఙ్ పజే. ");
INSERT INTO nit_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ఏదెనా ఇముంన్ లోపా ముండట్ అనేంఙ్ ఓల్సద్ ఏరతె అముదు సట్టముంఙ్ సిన్నం సేవకలెకద్ ఏరేంఙ్ పడ్సద్. ");
INSERT INTO nit_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","అదుంఙ్ ఎత్తి మన్కనె పోరక్ సేవ కత్న సుమ్మెంఙ్ వారెతద్ గని తన్నె పానమున్ సియెంఙ్ వతెంద్‍. ");
INSERT INTO nit_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ఔర్ యేరికొ ఊరుంఙ్ వార్సర్ మల్ల అముదు తనే సిసు అని మన్కకెర్ దండి గరిది వెంట యేరికొ ఉర్ తన కురియుత్ సేరెంఙ్ తీమయినే పోరక్ బార్తమియక్ పేర్‍తద్ గుడ్డి బిచ్చేగండ్ పావుత్ ఉద్దుత్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","అముదు సేరెకా నజరేత్ ఊరున్ యేసుంద్ ఇస్సాద్. అనఙ్ వింత్న వాపొయుత్ ఇస్సాద్. ఏ యేసు దావిద్ పోర అన్ పోయ్ కివ్ కాల్. ");
INSERT INTO nit_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","పేలెటర్ మన్కకెర్ అమ్నున్‍ దబ్బ అన్ ఇసా అర్పులిప్‍సార్‍ గని అముదు గులేనా వాపొయుత్ ఇసాద్. ఏ దావిద్ రజునే పోర. అన్ పోయ్ కివ్ కాల్. ");
INSERT INTO nit_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","యేసుంద్ ఇల్లుత్న ఇడ్సద్. అమ్నున్‍ కూగుర్ ఔర్ అముదు గుడ్డిన్ కూగుత్న ఇస్సాద్. ఇమ్మత్ ఏక్. సుల్ అముదు ఇన్ కూగ్సనంస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","అపుడ్ అముదు తనే జుఙ్ఙె జొప్పిడుత్ జంల్లిది సులుత్న యేసున్ వై వర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","యేసుంద్ అమ్నున్‍ ఇస్సాద్. అన్ ఇనుంఙ్ వాలడ్ తనేద్ కాలేకాద్ ఇసాతి? అముదు యేసునున్‍ ఇసాద్. గురుజి అనుంఙ్ నాదుర్ రొంబడెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","యేసుంద్ అమ్నున్‍ ఇస్సాద్. సే ఇనే విస్వాసడ్ నీ సోయ్ ఏది అపుడ్‍తద్ అపుడి అమ్నుంఙ్ నాదుర్ వార్‍సాద్. అముదు పవడ్ యేసుకున్ వెంట సేరేంఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ఔర్ యెరూసలెమ్ గదియుత్న బేత్పగేంఙ్ అని బేతనియ ఉల్లేంఙ్ ఒలీవ మెటుంఙ్. వరెంఙ్ అముదు తన్నెఇద్దర్ సిసులున్ పేలెయ్‍ పన్కుత్ ఇస్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","నీర్‍ ముడట్ ఊరుంఙ్‍ సేర్ నీర్ ఉర్ లోపా సేరెంఙ్ఙయ్‍ అత్తి ఏది మన్కక్ ఉంద్సేటద్. అంటద్ ఒక్కొద్ కట్‍త గాడ్దినె కొవ్వె ఇముంఙ్ రొంబాడద్. అదున్ ఉడుపుత్ తోడవర్. ");
INSERT INTO nit_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","తనుంఙ్ ఇనంఙ్ కాల్సాతిర్ అనంఙ్ ఏదెన్ ఇమున్ ఇంతె దింత్తె ఇనంఙ్ ఇడ్ర. మాల్కకుంఙ్ ఇద్నే గరజ్ అన్సాద్. అమ్నె పని ఏదిన్‍ ఇంతె వెంటని పన్కసాతుమ్. ");
INSERT INTO nit_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ఔర్ కురియుత్ సేస్సర్ అని పావుత బొయ్ద ముండట్ కాట్‍త గాడ్దినె కొవ్వె ఔరుంఙ్ కాడక్ ఏర్‍సాద్. అని ఔర్ అదున్ ఊడుప్సర్. ");
INSERT INTO nit_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","అతి ఇల్లుత్ అనెకర్ ఔరున్ వేలుతు ఓల్సర్. తా గల్సాతిర్? గాడ్దినె కొవ్వెన్ తానుంఙ్ ఊడుప్సతిర్. ");
INSERT INTO nit_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","యేసును ఏనఙ్ ఇసాద్ సిసు ఇడ్సర్. ఔర్ కొసెంఙ్ ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","మల్ల ఔర్ అద్‍ గడిదినే కొవ్వెన్ యేసుకుంన్‍వై కొత్న తమె జుఙ్ఙెలున్ అదున్‍ పోయ్ తప్సర్. అముదు అదున్ పోయ్ ఉద్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","మల్ల పెరెత్ మన్కకెర్ తమె జుఙ్ఙెలున్ పావుత్ తాడ్‍సర్. మల్ల కొన్సెంమంది అడవిత మాకులె కొమ్ములున్ పుంతుత్ నేరప్సర్. ");
INSERT INTO nit_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ముండట్ సేరేకార్ అని వెనకత్ వరేకార్ వాపొయినేర్. ఒస్సాన్. ప్రబునే పేరడ్ వారేకాంద్ బాగ్యివన్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","వారేకద్ రాజ్యం నేండె వెడ్లక్ దావిద్ రజే బాగ్యివన్తద్ అన్సాద్. ఇసా జొరనట్ వాపొయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","యేసుంద్ యెరూసలెమ్ వాత్ మందిర్ లోపా సేస్సద్. అత్తర్ తిరగొర్ ఓలుత్. సింతెవేల ఏదిన్ బరమంది వెంట బేతనియ రుగు కురియుత్‍సేస్సద్. ");
INSERT INTO nit_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","మల్ల ఓకొదినం ఔర్ బేతనియ తన కురియుత్న వారెంఙ యేసునుంఙ్ కార్వువర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","అపుడి సెట్‍లడ్‍ నిడ్త ఒక్కొ మేడి మాకున్ అముదు దవ్‍తన ఓలుత్ అత్తి సేత్న. ఏగు సివయ్. తనయ్‍రొబ్బడెత్తిన్. తానుంఙ్ ఇంతె మెడికాయ్యెక్ దినమి ఇంకవరేత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","అపుడ్ అముదు అద్‍ మాకున్ ఇస్సాద్. ఇదుఙ్ ముండట్ ఇన్నేత్ కాయ్‍తదున్‍ ఏంది తిస్స తోత్తంద్. ఇద్ గొట్టిన్ అమ్నె సిసు విస్సానండెర్. ");
INSERT INTO nit_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","మల్ల యెరూసలేముంఙ్ వార్సర్, యేసుంద్‍ మందిర్ లోపా సేత్న అత్తి విరేంఙ్ సుమెంఙ్. కలేకరున్ వాక పుసెంఙ్ ఎదెంద్. అని దుగనింన్‍ బదల్లిపుత్ సియ్యెకారున్ బల్లలున్, పారెవ విరెకరున్ ఉందెక్ పిటలున్ రాప్సర్. ");
INSERT INTO nit_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","మందిర్నాడ్ తనే వెన వాస్తులున్‍ తొడ సేరేకారున్ అముదు సేరేంఙ్ ఇడెతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","అముదు ఔరుంఙ్ కారప్స ఇసాంద్. అనే ఏల్లన్ సాటం దున్యత మన్కకెర్ పార్తన మందిర్ ఇస్సార్. అనంఙ్ వాయుత్ తోతెద్? గని నీర్ అదున్ డొఙ్ఙలె ఎల్ల బనప్తిర్. ");
INSERT INTO nit_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","బర్స దెయ్యలకెర్ అని సాస్త్రి మన్కకెర్ అదున్ విస్సార్ అని అమ్నున్‍ అల్ఙేఙ్ ఇసా ఒజ్జిపెంఙ్ ఎద్దెర్‍. గని మన్కకేరే గర్ది అమ్నె కరపెకద్ బదోల్ గులేన సామత్కల్‍ ఏత్న అన్సార్. ఔరుంఙ్ వాలడ్ అమ్నున్‍ అర్సనెర్. ");
INSERT INTO nit_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","మల్ల సింతె వేల ఔర్ పట్నం వాక సేన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","మరొక్కొ జీర్‍ తొల్లిని ఔర్ పావ్‍డ్ సేరెంఙ్ ఆ మేడి మాక్ మొదల్ తన అర్తదున్‍ ఓల్సర్. ");
INSERT INTO nit_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","పేతురు అద్ది కత్న యేసునున్ ఇసాద్. గురుజి ఓల్. నీ సాపం సియ్‍తా ఈ మేడి మాక్ అరత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","యేసుంద్ ఔరుంఙ్ జవాబ్ సియుత్ ఇసాద్. దెయ్యం పొయ్ విస్వాస్ అపుర్. ");
INSERT INTO nit_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","అన్ కరె ఇడ్సత్ ఏదెనా ఈ మెటున్ నీ సులుపుత్ సముద్రముత్ రల్. అనంఙ్ తనే మనతద్ ఇండుత్ అన్మాన్ తోసెట. తనే ఇడ్‍త గొట్టిన్ బరొస ఇట్టె అనంఙ్ ఎదెంద్ ఎరత్తె కారే అద్ అమ్నుంఙ్ ఏర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ఇదుంఙ్ వాలడ్ అన్‍ ఇముంఙ్ ఇడ్సత్. నీర్ పార్తన కలెంఙా నీర్ ఏద్‍వెలతిర్‍ అద అనుంఙ్ రొబ్బడ్స. అనంఙ్ విస్వాసం అండిరింతె అద ఇముంఙ్ రొబ్బడ్సద. ");
INSERT INTO nit_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","అని నీ ఏపుడెన పార్తన. కాలేంకద్ వల్లడ్ ఇలేంఙ. అపుడి ఇమ్మె మనతద్ ఏరుంఙ ఏన్న గలత్ తనేన్ ఏన్న అండినింతె అమ్నెత్ మొదల్ మాప్కల్. ఇమ్మెత్ స్వర్గత ఇమ్మె బానె ఇమ్మె పాపులే మాపి కాల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","నీర్‍ మపి కాలేత్తిర్ ఎరతె ఇమ్మెత్ స్వర్గుత్న ఇమ్మెత్ పాపులే మపి కలెంద్. ");
INSERT INTO nit_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ఔరు మల్ల యెరూసలేముంఙ్ వార్సర్. అముదు మందిర్త తిరగనేన్ బర్స దెయ్యలకెరె సాస్త్రి మన్కకెర్ అని మాన్వలె అమ్నున్వై వత్న. ");
INSERT INTO nit_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","అమ్నున్ ఇస్సాద్. ఏద్ అదికారమడ్ ఈ పనికున్ నీవ్‍ కల్‍సాత్తివ్? ఇద పనిక్ కాల్లెఙ్ ఎద్ ఇనుంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","యేసుంద్ ఔరున్ ఇసాద్. అన్ ఇమున్ ఒక్కొ గొట్టి వెలుత్న. అనుంఙ్ జవాబ్ సియ్యుర్. మల్ల అన్ ఎద్ అదికారమడ్ ఇద పనిక్ కాల్సత్ అద్ ఇముంఙ్ ఇడ్సత్. ");
INSERT INTO nit_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","యోహానుంఙ్ బాప్తిస్మ దెయ్యం తన వత్తిన మన్కకెర్ తన వత్తినా ఎది ఏక్కద్ మన్కకేరె తన వత్తద్ ఎంద్ అనుంఙ్ ఇడ్డుర్. ");
INSERT INTO nit_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","మల్ల ఔరెత్ ఔరి విచార్ ఎద్దెర్‍ నేండ్ స్వర్గతన అండిన్ అనఙ్ ఇంమ్మెత్. తనుంఙ్ అమ్నున్ పోయ్ విస్వాస్ ఇండతెర్‍రింత్తె ఏదిన్. ");
INSERT INTO nit_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","మన్కకెర్తన అండిన్ అనఙ్ ఇంతమ్ ఇంతె మన్కకేరే అర్రి ఔరుంఙ్ వార్సద్. ఇంతె యోహాన్ కారేదెయ్యమ్నె గొట్టిక్ ఇండెకంద్ అన్సాంద్. అనంఙ్‍సట్టం మన్కకెర్ అమ్నెత్ మన్ ఇండనేర్. ");
INSERT INTO nit_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","మల్ల ఔర్ యేసునుంఙ్ ఇడ్సర్. అముంఙ్ ఏర్క తోతెద్; యేసుంద్ ఔరున్‍ ఇస్సాద్. అన్ ఎద్ అదికార్ రడ్ పనికులుకాంత్తన్ అద్నాయ్ ఇముంఙ్ ఇడ్సతొతెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","మల్ల యేసుంద్ ఔరున్‍ వెంట సంఙ్ ఎత్త ఉదహరనడ్ ముడెంఙ్ ఎద్దెంద్. ఒక్కొ మన్కక్ అంగుర్నె వాడి తిగు ఎద్పుత్న వడి తిర్‍గొర జాప్ కతెంద్. అంగుర్ పండ్లున్ కుడ్కెంఙ్ సటి గాన తొడ్డె కట్టుత్, అత్తిని ఒక్కొ జాగ్లి కాయ్యెంఙ్ ఏగర్ దెకుల్ కట్టెంద్, అని ఆ అంగుర్నె వాడిన్ టెకనడ్ సియ్యుత్ దౌ దేసెముంఙ్ సెదెంద్. ");
INSERT INTO nit_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","పంట్టత వాకతుంఙ్ గడియకున్ పని కలెకర్వై పన్కుత్న. వడిత కొన్ని అంగుర్నె వాడి పండ్లున్ కొరెంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ఔర్ గడియకున్ సుముత్ తడ్తెర్ అని రికమ్ కెయ్యులడ్ పన్కతెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","పెన్న ఒక్కొ గడియకున్ అముదు ఔరున్వై పన్కతెద్. ఔర్ అమ్నె తాలున్ ఓటుత్న అమ్నె అప్మన్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","మల్ల ఒక్కొనున్ పన్కతెద్. ఔర్ అమ్నున్ అలంఙ్ తెర్. ఇనంఙ్ పేలెటర్ గడ్యికెరు పన్కతెంద్. కొన్సెం మందిన్ తడ్తెర్ అని కొన్సెం మందిన్ అల్గతెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ఇంకనయ్ అమ్నత్తి ఒక్కొద అండెద్. అముదు అమ్నె లాడ్త పోరక్ ఎన్నెంద్. అమ్నునయ్ అవ్రువై పన్కతెంద్ అని మనుత్ ఇంతెద్. ఇవ్రు అన్నె పోరకుంఙ్ మన్ సియ్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","గని ఆ మన్కకెర్ ఒక్కొనెత్ ఒక్కొద్ ఇంతెర్. ఇమ్‌ద వరిస్ ఎన్నెంద్. నేండ్‍ ఇమ్నున్ అల్గంఙ్ నర్. మల్ల ఇస్టెద్ నేండుంఙ్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","మల్ల అమ్నున్ సుముత్ అల్గుత్ అంగుర్నె వాడి వకా జొపిటెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","తె అంగుర్నె వాడి మాల్కక్ తనెగందద్? అముదు వత్న వడిత మన్కకెరున్ నసానం కద్దద్ అని వడిన్ మరొక్కొరుంఙ్ సియ్‍దద్. ");
INSERT INTO nit_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","నీర్ లేకనమ్ చదువెర? కట్టెకర్ జమ్మిలెద్ ఇంత్త గుండ్ ఎల్లనె ముల గుండ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","అద్ ప్రబున్ వాలడ్ ఎద్దిన్. నెండె కడ్లుంఙ్ ఈ గొట్టి గుంల్ కమ్లతద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","అపుడ్ బర్సదెయ్యలకెరుంఙ్ కరిల్‍తిన్. ఆ ఉదహరన ఔరున్ బదోల్ అడ్డిన్. ఔర్ యేసునుంన్ సుమ్మెంఙ్ కిర్వనెర్ గని మన్కకెరున్ అర్సుత్న అమ్నున్ సాయుత్‍సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","మల్ల ఔర్ యేసునున్ గొట్టిత్ సుమ్మెంఙ్ ఇసా పరుసిక్ కొన్సెం మందిన్ అని హేరోదు యుల్ రాజక్నె పల్టిత మన్కకెరున్ పన్కతెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ఔర్ వత్న అమ్నున్ ఇంతెర్. గురుజి. మన్కకెరున్ ఓలుత్న సత్తెం కలెకని ఎరెవ అని ఎరుంగి అర్సెవ. ఇండ్డి అముంఙ్ ఇడ్డ. నేండె రొమ చక్రవర్తినె దెయ్యం పన్ను సియెకద్ బరబర్ అంసాద తొద? అమ్ ఔరుంఙ్ కర్ సియెంఙ్ తొద? ");
INSERT INTO nit_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ఔరె రగ్గున్ ఒర్కిలుత్న యేసుంద్ ఔరున్ ఇంతెంద్. అన్నె పరిక్స తనుంఙ్ ఓల్‍సాతిర్? అనుంఙ్ ఒక్కొ కల్దరున్ తోడ వర్ర. అన్ అదున్ ఓలత్. ");
INSERT INTO nit_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ఒక్కొ కలదరున్ కొతెర్ ఔరున్ ఇంతెంద్. ఇత్తి వయ్తద్ అని రూప్ ఎరెత్ అన్సాద్? ఔర్ ఇంతెర్ రొమ రాజునెత్. ");
INSERT INTO nit_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","యేసుంద్ ఔరున్ ఇంతెంద్. రొమ రాజుంఙ్‍ దెయ్యమ్నెత్‍ దెయ్యముంఙ్‍ సియుర్. అపుడ్ ఔర్ యేసునున్‍ బదోల్ గుంల్ కమల్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","సద్దుకి మన్కకెర్ అమ్నున్వై వత్తెర్. ఈ తిక్కెకర్. సులెర్ ఇనెక ఎవుది మన్కకెర్ ఎన్నెర్. ఔర్ అమ్నున్ వెలుత్ ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","గురుజి. మోసే అముంఙ్ వాయుత్ సియ్తెద్. ఒక్కొ మన్కనె దదక్నె పోరకేర్ తోసెట తిక్‍తెంద్ అని అంమ్నె మాస అండిన్‍ తె. ఆ మన్కక్ అదున్ మాస కత్న అదుంఙ్‍ పొరకెర్ ఎత్న దాదకున్ వరిసు ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ఇనంఙ్ ఎదిన. అన్న ఏడ్గుర్ తోరెంద్ అండెర్ దొడంద మాస కత్న పోరకేర్ ఎర్సెటయ్ తిక్తెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","అమ్నున్ వెన్కతద్ అదున్ మాస కత్న పోరకేర్ ఎర్సెటయ్ తిక్తెద్. మల్ల అమ్నున్ వెన్కతద్ నాయ్ అనాయ్ తిక్తెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ఇనంఙ్ ఏడ్గురుంఙ్ నాయ్ అదున్‍ పెండ్లి ఎత్‍ పోరకేర్ తొంత్తెర్ ఆక్రింఙ్ ఆ పిల్ల నాయ్ తిక్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","తిక్‍తర్ సులెంఙ్ అపిల్ల ఔర్ ఏడ్గుర్ లోప ఎర్రె మాస ఎంద? తానుంఙ్ ఇంతె ఏడ్గుర్ నాయ్ అదున్ మాస కత్తండెర్ తా ");
INSERT INTO nit_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","యేసుద ఔరున్ ఇంతెంద్. ఇముంఙ్ దెయ్యమ్నె లేకన ఒర్కి తోతెవా అని దెయ్యమ్నె సక్తి నాయ్ ఒర్కి తోతెద్ ఇసా నీర్ సుకిల్సతిర్. ");
INSERT INTO nit_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","తానుంఙ్ ఇంతె తిక్తార్ సులెంఙా ఔర్ పరలోకముత్ దెయ్యమ్నె దూత్ లంఙ్ అసార్. ");
INSERT INTO nit_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","తిక్తార్ సులెకద్ బదోల్ రంబిలెక తుట్టిన్‍ బదోల్‍ మోసేనె పుస్తకుత్ నీర్ వసిపెతిరా? మోసె ఇనంఙ్ ఇంత్తిద్. అన్ అబ్రాహామ్నె దెయ్యం ఇస్సాక్నె దెయ్యం అని యాకోబ్నె దెయ్యం ఎందున్. ");
INSERT INTO nit_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","తానుంఙ్ ఇంతె దెయ్యం తిక్తన్నె దెయ్యం ఎరెద్ గని పనలెత్ అంసాద. ఇమ్నె గొట్టి కరె తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ఒక్కొ సాస్త్రి మన్కక్ వాత్న ఔరె గొట్టికున్‍ వింతెద యేసుంద్ సోయ్త గొట్టి ఇడ్డెకదుంఙ్ విత్న యేసుంద్‍ సోయ్త గొట్టిన్‍ ఇడ్‍సాద్. సిమ్కన ఆగ్యలుంఙ్ పేలె ఆగ్య ఎద్ద? ");
INSERT INTO nit_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","యేసుంద్ అముంఙ్ ఇడ్‍తెంద్. పేలె ఆగ్య ఇద్ ఎద్ద. ఎ ఇస్రాయేల్ విడ్ర. నేండె దెయ్యం ప్రబుద్ ఒక్కొది దెయ్యం అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ఇన్నె దెయ్యం ప్రబునున్ పొయ్ ప్రేమ్ కలెంఙ్. పూర మనాడ్ పూర ఆత్మ పూర బుద్దినడ్ అని పూర తాకతడ్ ప్రేమ కాల్. ");
INSERT INTO nit_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","రెండవ ఆగ్య ఇద్ద ఎంద. ఎనంఙ్ తన్న పొయ్ ప్రేమ్ కల్సతివొ అనంఙ్ ఇన్నె మెరతరున్ పొయ్ నాయ్ కల్. అదవ్లుంఙ్ ఎన దండి ఆగ్య మారొక్కొద్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","అపుడ్ ఆ సాస్త్రి మన్కక్ యేసునుంన్ ఇంతెంద్. గురుజి. ఇన్నెతి కారెఅన్సాద్. నివ్‍ ఎనంఙ్ ఇంతివొ అనాయ్ సత్తెం దెయ్యం ఒక్కొది అన్సాద్. అముదు సివయ్ మరొక్కొద్ ఎద్ది తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","అని దెయ్యమున్ పూర మనాడ్ పూర బుద్దినడ్ పూర తాకతడ్ తన్నెత్‍ లంఙ్ తనే సేజర్యకున్ పోయ్ ప్రేమ్ కాలేంఙ్ పడ్‍సాద్, ఇనంఙ్ కాలేకాద్ మొక్కులున్ అని బావులున్ సియ్యెకాదుంఙ్ ఏన్న దండి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","యేసుంద్ ఉసరడ్ ఇడ్సన్. అదున్ అముదు విత్న అమ్నున్‍ ఇసాద్. నీ దెయ్యమ్నె రాజ్యం తన దవ్ తోతె అపుడ్ తన యేసునున్ తనెది వేలుత్ ఓలెంఙ్ ఏరుంఙ్ నాయ్ దైర్యం వరేత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","మల్ల యేసును మందిర్ ముడట్ ఇడ్‍సా ఇనంఙ్ ఇంతెంద్. క్రీస్తుద్ దావిద్నె పోరక్ ఇసా సాస్త్రిక్ ఇసార్? ");
INSERT INTO nit_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","గని దావిద్ పవిత్ర ఆత్మనాడ్ ఇడ్సన్. ప్రబునాడ్ అనే ఇస్వరకున్ ఇసాంద్. ఇనే విరోద్ కాలేకారున్ ఇనే గేట్టల్ బూడున్ కోన్నెలా నీవ్ అనే ఉన్న పక్కఙ్ ఉంద్. ");
INSERT INTO nit_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","దావిద్ సేత్న ఇస్వవరకున్ ప్రబు ఇసాంద్‍. మల్ల దావిద్నె పోరక్ ఏనంఙ్ ఏర్సద్? మన్కకేరే యేసుంద్‍ అమ్నేత్ కుసినడ్ విచార్. ");
INSERT INTO nit_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","యేసుంద్ ఇమకా ఎన్నిగొ రితిక్‍లడ్ బొద ఔరుంఙ్ ఇడ్సన్. సాస్త్రి మన్కకెర్ బదులు ఉసరాడ్ అనురు. పొడమ్ జుఙ్ఙెల్ తొడుత్న ముజుర సుంమ్మెంఙ్ వల్లడ్ ఓల్సర్. ");
INSERT INTO nit_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","యూదులె సావ్డిక్లెంఙ్ ముందర్ ఉదేకాదుంఙ్ అని జేవ్వునుంఙ్ వల్లడ్ కూగుస్సార్. తె మనత జగ్గలేంఙ్ ఉందేంఙ్ పతక్సర్. ");
INSERT INTO nit_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","అని రడెరస్సిక్‍లే ఎల్లకున్‍ అగ్టిపుత్ సుముత్న ఔరె కంపటున్ ముంసెంఙ్ వల్లడ్ పొడమ్ పార్తన కాల్సర్. ఔరుంఙ్ ఏక్కువ న్యాయ్ రొబడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","యేసుంద్. బక్తి సావ్డి ముండట్ ఉద్దుత్ మన్కకేరే గర్ది పెటిత్ పైస్సె తంపేకారున్ ఓల్స అనేద్. గులేన పైస్సె వల్లె పేంల్లెంఙ్ పైసె తప్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ఒక్కొద్ గరిబ్ రండెర వత్తిన్ అని ఇంది రగి పైసె పెటిత్ తంపేకాదున్ ఓల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","యేసుంద్ తనే సిసులున్ మెరకుగుత్న ఇస్సాద్. అన్‍ ఇముంఙ్ కరెయ్ ఇడ్సత్‍ దన్ పెటిత్ పైస్సె ఔర్ సట్టముంఙ్ ఏన్న ఇద్‍ గరిబ్ రండెర ఏక్కువ తంప్త్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ఔర్ సాటం తమ్మె కామయ్‍తన కొన్ని పైస్సె సియ్‍సార్. గని ఇద్ పిల్ల తన గరిబ్ అత్నతన్నె బంతుకుంఙ్ కామప్‍తదున్ ఆస్తి సట్టముని తప్‍త్తిన్‍. ");
INSERT INTO nit_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","అముదు మందిర్తన వాకా కురియెంఙ్ అమ్నె సిసు లోపా ఒక్కొద్ యేసునున్‍ ఇసాద్. గురుజి ఓల్. ఎత్తె సొబత్ పాడిగుడ్లు అని ఎత్తె సొబతద్ కట్తద్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","యేసుంద్ అమ్నున్‍ ఇసాద్. ఇద దండిదండి మాడి కట్తద్ ఓల్తివ్‍ ఇదవున్ మన్కకెర్ నాస్టం కాల్సర్. ఇత్తి గుండ పోయ్‍ గుండ్ ఒక్కొద్‍నై అన్నెద్‍ సట్టం ఓద్రిల్సా. ");
INSERT INTO nit_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","అముదు ఒలీవ మెట్‍ పోయ్ మందిరవై ఓల్స ఉద్దుత్ అనెంఙ్ఙ పేతురు. యాకోబ్‍. యోహాన్ అని అంద్రెయక్ యేసునున్ వేలుత్ ఓల్సర్? ");
INSERT INTO nit_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ఇద గొట్టిక్ ఏపుడ్ ఎద అని ఇద సట్టం ఎరేక్ సిన్న వంత్తిన్‍ ఇంతె తగలెకాద్. ");
INSERT INTO nit_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","యేసుంద్ ఔరున్‍ ఇనేంఙ్ ఇంతెంద్. ఏరి ఇమ్మున్ పసిపెంఙ్ తోద్ ఇసా ఉసరడ్‍ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","పేలెటర్ మన్కకెర్ అనే పేరడ్ వత్న అన్ దెయ్యం యేసుంద్ ఏందున్ ఇసా ఇడ్‍దర్ అని పేలెటర్‍ మన్కకేరున్ పసిప్‍దర్‍. ");
INSERT INTO nit_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","మల్ల నీర్ లాడెయు బదోల్ వినేంగ ఏక్కద్ లాడెయ్‍నే వాపోయేకాద్ వినెంగ దంద్రిలెంఙ్ తోద్. అద గొట్టిక్ ఏరేంపజ్జె గని ఇద్ ఆక్రి ఏరేద్. ");
INSERT INTO nit_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","దేసుంఙ్ విరోద్ దేస్‍ సుల్‍ద, అని రాజ్యంఙ్ విరోద్ రాజే సుల్‍ద్. ఇదె హదే బుకంప ఏరసా అని దుస్కాడ్ వర్సద్. ఇద సట్టం గొట్టిక్ ఏరేంఙ్ తక్కిలిబ్ సురు ఏదిన్ ఇసా సామ్‍జిల్లుర్. ");
INSERT INTO nit_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","నీర్ ఉసరడ్ అండ్రు. ఇమ్మున్‍ ఉరమన్ వల్లె లె కేయ్యుత్‍ సియుత్న యూదులె సావ్డిత్‍ ఉదిప్‍సార్. ఔరున్‍ సాక్సం సియెంఙ్ ఇత్న అని గొలుంఙ్ అదికారిక్ అని రాజక్ ముండట్ ఇమ్మున్ ఇల్‍ప్‍దర్. ");
INSERT INTO nit_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ఆక్రికాడ్ వానంత్తెంఙ్ సాటం జాతి తరున్ యేసునే సోయ్ సువార్త ముండట్టి ఇడ్డెంఙ్ పజే. ");
INSERT INTO nit_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ఏపుడ్ ఏన్న ఇమ్మున్ సుమ్ముత్ కొసుత్ బర్సత మన్‍వలె లే కేయుత్‍ సియేఙా. అపుడ్ తనేదున్‍ ముడెకాద్ అనంఙ్ విచ్చర్ కానేర్ అద్దిగట్కత్ మంజే నీర్ ఇడెంఙ్‍పడ్సద్ అద్ ఇముంఙ్ దెయ్యం సియ్‍సాద్ ముడెకార్ నీర్ ఎరెర్ గని పవిత్ర ఆత్మ ఎంద్. ");
INSERT INTO nit_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","అన్నదములున్‍ సుముత్న సియ్‍సాద్. బాంద్ దాదకేర్ సుముత్ సియ్‍సాద్. అని పోరకేర్ అమ్మ బానున్ హల్గెంఙ్ సుమ్ముత్ సియ్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","అనే పేరుంఙ్ వాలడ్ సాటం మన్కకెర్ ఇమున్‍ విరొద్‍ కాల్సర్. గని ఆక్రింఙ్ ఎంత్‍ టిక్కిలేకానేత్ రక్సన ఏరద్. ");
INSERT INTO nit_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","గని నాస్టం కలేకాద్ అని దెయ్యమున్‍ రిస్కాలేకాంద్ ఇనుత్‍ బనలెద్‍ అత్తి ఇల్లుకుత్ అనెకాదున్ ఓల్సర్. చదవెకారుంఙ్ ఇద్ కారిలేంఙ్ అపుడి యూదియ దేసెముత్ అనెకర్ మెట్వై కురియుత్‍ తులెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","మాడి పొయ్ అనెకాద్ బూడున్ డిగెఙ్‍ తోద్. తన్‍ వెంట కొస్సెకాదుంఙ్ తనే ఎల్ల లోపా సొంఙ్ ఙెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","కేనుతు అనెకాన్ తనే జుఙ్ఙెనె కొస్సెఙ్ ఇస్సా వెనకత్ తిరుగుత్న వారేంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","అద పెటెనడనెకా అనెక్ పిల్లకుల్లుంఙ్ ఎత్తెఓ సిక్స ఏరద్. ");
INSERT INTO nit_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","మల్ల టడ్డి దినమువరెంఙ్ తోద్ ఇసా దెయ్యముంఙ్ పార్తన కాలుర్. ");
INSERT INTO nit_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","అద దినముల్లెంఙ్ గులేన తక్కలిబ్ ఏరద్ ముండట్ దెయ్యం కాల్లిన్ గడిప్త్తిన్. అద్ దినంతన అట తక్లిబ్‍ పంఙిదూక్ ఏద్‍ ఎత్తి. అని ముండట్ నాయ్ ఎర్స తోతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","దెయ్యం అద దినాలుంఙ్ తక్కువ కలేన్ తే. సరీరాడ్ అనేకార్ ఏర్‍ అద్ సుకడిలేంఙ్‍ సాలెర్. గని ఔర్ నివ్డిప్త మన్కకేరున్ వాలడ్ అద్ అద దినముల్లును తక్కువ కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","అపుడ్ ఇమ్మును ఇస్సాన్ ఓలుర్. మన్ వల్లె ఇంతిన్ అన్సాంద్. ఓలుర్ క్రీస్తుద్ అత్తిన్ అస్సాన్ అనఙ్ ఇంతెర్తె అద్ కారే ఇనుత్ బరొస అప్నేర్. ");
INSERT INTO nit_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","పైలి క్రీస్తుద్‍ అని పైలి కబుర్లకెర్ ఇండెకార్ సులుత్న దెయ్యమ్నె గొట్టిక్ ఇండెకార్‍ సులుత్న సమత్కలున్‍ ఓలిపుత్న నివ్డిప్త మన్కకేరున్‍నాయ్ పస్సిపేంఙ్ పతక్సర్. ");
INSERT INTO nit_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","నీర్ ఉసరాడ్ అనురు. అన్ ఇమ్ముఙ్ సట్టం ముండటి ఇడ్తన్. ");
INSERT INTO nit_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","గని అద దినములుంఙ్ తక్లిబు ఏదే పోద్‍కురి పడ్సద్ నేల వేలంఙ్ సియ్‍సాతొతెద్. ");
INSERT INTO nit_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ఆబార్ తన సుక్క రల్ సా అని ఆబార్త సక్తినాడ్‍ మెలఙ్ సా. ");
INSERT INTO nit_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","అపుడి మన్కనె పోరక్ అన్ గులేన సక్తి మడ్ అని మహిమనడ్ హబ్బరత్ డిగ్గుత్ వరేకారును ఓల్సర్. ");
INSERT INTO nit_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","అపుడి అన్అనే దూతులుంఙ్ పనుకుత్న ఇల్లుత్ ఆక్రితద్ స్వర్గుతు ఆక్రింఙ్ ఏంత్సట్టం దున్యత అనెక అనే నివ్డిప్త మన్కకేరును మిరప్సతును. ");
INSERT INTO nit_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","మేడి మాక్త ఉదహరన తన నీర్‍ కారపేంఙ్ అద్‍ మాక్త లేత కొమ్ము వత్న నిగ్రిడెంఙా మెర వాత్తిన్ ఇనంఙ్ నీర్ ఒర్‍కిల్తిర్. ");
INSERT INTO nit_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","అనాయ్ ఇద ఏరేకావున్ ఓలేంఙ్. అన్ మెరం బొయ్ద అన్సాత్ అనంఙ్ ఒర్కిలుత్‍. ");
INSERT INTO nit_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","అన్‍ కరెయ్ ఇడ్ సాత్ ఇద సట్టం ఏరేకాదున్ ఓల్తా సివయ్ ఇద్ పిడ్డి నాస్టం ఎర్సా తోతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ఆబార్ అని బూమి నాస్టం ఏద గని అన్నె గొట్టిక్ నాస్టం ఎరె. ");
INSERT INTO nit_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ఆ దినం అని ఏరుంఙి ఏరక్‍ తోతెంద్. పరలోకాముత్‍ అనెకా దెయ్యమ్నె దూతులుంఙ్‍ నాయ్ ఏరక్ తోతెంద్ అని దెయ్యమ్నె పోరకుంఙ్‍నాయ్ తోద్ గని బానుంఙ్ ఏరక్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ఉసారడ్ అండ్రు. ఓల్సని అండ్రు. ఆ వేల ఏపుడి వర్సదొ ఇముంఙ్ ఏరక్ తొతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ఇద్ ఇనంఙ్ అన్సద్. సేరేక మన్కక్ తన్నెఏల్లన్ సాయుత్‍ సేరేంఙ్ తనే. గడియక్ అదికార్ సియుత్న ఏరేత్ అమ్నుంఙ్‍ పనిక్ ఇండుత్న ఎల్లబొయిదన్ కయ్యెకరున్ ఇనంఙ్ ఉకూమ్‍ సియ్‍స్సాదొ. ఉసారడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","అనంఙ్ నీర్ నాయ్ ఉసరడ్ అండ్రు. ఎల్లత మాల్కక్ ఏపుడ్ వార్‍సాద్ ఇంతె సింతె వెలా ఏక్కద్. సార్‍సామలె ఎక్కద్‍ పోద్ కురియెంఙ్ ఏక్కద్ తోల్లిని ఇద్ ఇముంఙ్ ఏరక్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","అని అముదు ఒక్కొది ఉస్సాట్ వత్న నీర్ మడ్డియుత్ అనెకారున్ ఓలెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","అన్‍ ఏద ఇముంఙ్ ఇడ్సాత్ అద సట్టముంఙి ఇడ్ సాత్ ఉసారడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","పస్కక్ పండ్గుంఙ్ అని పురున్ నిపట్టెలె పండఙ్ వరెంఙ్ ఇన్నల్ అనెంఙ. బార్స దెయ్యలకెర్ అని సాస్త్రి మన్నకెర్ యేసునున్ ఎనంఙ్ సుమెకద్ అని ఎనంఙ్ అల్‍గెంకద్ ఇసా ఓల్ సాని అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","గని ఔర్ ఇన్నెర్. పండ్గుఙ్ అనంఙ్ కల్లెంఙ తోద్. కత్తమింతె మన్కకెరత్తి లొంల్లి ఎరద్. ");
INSERT INTO nit_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","యేసుంద్ బేతనియ ఊరద్ పెర్‍దుకమ్ తన్న సోయ్‍ ఎద్ద సీమోన్నె ఎల్లత్ తినెంఙ్ ఉతండెర్. ఆపుడ్ ఒక్కొ పిల్ల తెల్లొడి గుండ్నె సిసాత్ నిడ్ పుత్నగులెన మాగ్త అత్తర్ నునెన్ తోడ. సిసాన్ ఓటుత్న యేసునె తల్ పొయ్ వంఙ్ తిన్. ");
INSERT INTO nit_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","గని అత్తి కొసెం మంది మన్కకెర్ రగ్గడ్ ఒక్కొనెత్ ఒక్కొంద్ ఇంన్నెర్. ఆ పిల్ల తగలెంఙ్ అత్తర్ నునెన్ కరాబ్‍ కత్తిన్? ");
INSERT INTO nit_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ఈ అత్తర్ నునెన్ ముదినుల్ వెండ్డినె కల్దల్ పొయ్ విరుత్న గరిబులుంఙ్ సియెంఙ్ వత్తనద్. ఆ దినాలుంఙ్ ఒక్కొ సాల్‍త కుల్కడ్ ముదినుల్ అండిన్. ఔర్ ఆ పిల్లన్ సిరయ్ తెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","అదుంఙ్ ఎత్తి యేసుంద్ ఇనంఙ్ ఇంతెంద్. అదున్ సాయుర్. తనుంఙ్ అదుంఙ్ తక్లిబ్ సియ్‍సాతిర్? ఈ పిల్ల అనుంఙ్ ఒక్కొ సోయ్త పాని కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","అన్‍ ఇమున్‍ వెంట అన్నెన్‍ తానుంఙ్ ఇంతె గరిబు ఎపుడి ఇమున్ వెంట అంసార్. ఇముంఙ్ మన్నుంఙ్ వరద్. అపుడ్ ఔరుంఙ్ సోయ్ కలెంఙ్ వరద్. ");
INSERT INTO nit_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","అదున్ వాలడ్ ఎత్తె సాల్ తిన్ అత్తె కత్తిన్. అన్న పుర్పెంఙ్ పేలె అన్నె సెత్తన్ అత్తర్ నునే దిట్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","అన్ కరెయ్ ఇముంఙ్ ఇడ్సత. సిమ్కన దున్యత్ ఎత్తి ఎత్తి సువార్త దెయ్యమ్నె సోయ్త గొట్టి ఇడ్సర్. అత్తి ఈ పిల్లన్ అది కతన్న అద్ కత్తదున్ ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","మల్ల బర మందిన్ లోపా ఒక్కొద్ ఇస్కరియోత్ యూదక్ ఇన్నెకద్ బార్స దెయ్యలకెరె కెయ్యుత్ యేసుకున్ సుముత్ సియెంఙ్ సాయం కలెంఙ్ ఇసా సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","అదున్ వింత్న బార్స దెయ్యలకెరుంఙ్ గుల్ కుసీ వత్తిన్. అని అమ్నుంఙ్ పైసెల్ సియెంఙ్ కబుల్ ఎద్దెర్. మల్ల యూదక్‍ యేసున్ సుముత్ సియెంఙ్ సటీ మొకన్ ఓల్నెద్. ");
INSERT INTO nit_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","పుల్లెనిపట్టెల పండ్గుంఙ్ పేలె జీర్ పస్క పండ్గుంఙ్ గొర్రెనె కొవ్వెన్ తర్గతెర్ ఇంతె యేసునె సిసు అమ్నున్ ఇన్నెర్. నీర్ పుల్లెనిపట్టెలె పండుగ్నె జెవున్ కలెకదుంఙ్ అమ్ ఎత్తి సెత్న తయార్ కలుర్ ఇసాతి? ");
INSERT INTO nit_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","యేసుంద్‍ ఇద్దర్ సిసులున్ పన్కుత్ ఇంతెంద్. సెర్ లోపా సెర్. ఒక్కొద్‍ దుత్తత్ ఈర్ కొసెకద్ ఇముంఙ్ రొబడదద్. అమ్నున్ వెంట సెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","అముదు సొంఙెక ఎల్లత మాల్కకుంఙ్ ఇడుర్. అమ్మె గురుజి ఇసాద్. అన్ అన్నె సిసులున్ వెంట పస్క పండగ్నె జెవున్ కలెకదుంఙ్ సుట్టలుంఙ్ కోలి ఎద్దె అన్సాద? ");
INSERT INTO nit_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","అముదు ఇముంఙ్ తడుత్న తయార్ కత్తద్ ఒక్కొ మాడిపొదె అనెకద్ మీద్దె పొల కోలి ఇడ్సద్. అత్తి నేండుంఙ్ సటీ తయ్యర్కలుర్. ");
INSERT INTO nit_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","సిసు అత్రనట్ కురియుత్ పట్నముంఙ్ సెద్దెర్. యేసుంద్ ఎనంఙ్ ఇడతెదొ అనాయ్ ఓల్ తెర్ అని పస్క పండుగ్నె జెవున్ తయ్యర్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","సింతెవెల బర మందిన్ వెంట యేసుంద్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ఔర్ ఉదుత్న తిసా అనెంఙ్ యేసుంద్ ఇంతెంద్. అన్ కరెయ్ ఇడ్ సాత్. ఇమున్ లోపా ఒక్కొద్ అన్ సుంముత్ సియ్దద్! అముదు అన్ వెంట తినెకాద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ఔర్ గుంలెన్ నారాజ్ ఎద్దెర్ అని ఒక్కొనున్ వెన్కత్ ఒక్కొద యేసునున్ ఇనెంఙ్ ఎదెర్. అన్ఎందున? ");
INSERT INTO nit_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","యేసుంద్ ఔరున్ ఇంతెంద్. అముదు బరమంది లోపా ఒక్కొద్ మంజె అన్ వెంట కొజా పటెన్ ముంపుత్ అన్సాద్ అముదు. ");
INSERT INTO nit_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","మన్కనె పోరక్ అన్‍ బదోల్ బైబిలుత్ ఎనంఙ్ వాయుత్ అన్సాదొ అనాయ్ అన్ సెరెంఙ్ పాజె. గని ఎరెకేయ్యడ్ మన్కనె పోరక్ అన్న సుముత్ సియెకద్ ఎరద్ అమ్నుంఙ్ ఎత్తె సిక్స ఎరద్. అముదు జన్మిలెంఙ్ తోసెట అనెంఙ్ ఎద్దె సోయ్ ఎత్తనద్. ");
INSERT INTO nit_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ఔర్ తినెంఙ్ ఉంత్తె యేసుంద్ నిపట్టెన్ సుముత్న దన్యావద్ సియుత్న అదున్ ముర్కుత్న ఔరుంఙ్ సియుత్న ఇంతెంద్. సుముర్ ఇద్ అన్నె సెత్త ఎంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","మల్ల అముదు గిలసున్ సుముత్న దన్యివాద సియుత్న ఔరుంఙ్ సియ్ తెద్. ఔర్ సిమన మంది గిల్సతదున్ ఉండ్డెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","మల్ల అముదు ఔరున్ ఇంతెంద్. ఇద్ పేలెటర్ మన్కకెరుంఙ్ సటీ కుల్పత అన్నెనెత్తుర్ అన్సద్. ఇద్ పాపి‍ క్సమా వల్లడ్ కరార్ నెత్తుర్. ");
INSERT INTO nit_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్. దెయ్యమ్నె రాజ్యం ముంత్ అన్ కొత్త అంగుర్నె రసాన్ ఈ రసాన్ ఏపుడి ఉనెన్. ");
INSERT INTO nit_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","మల్ల ఔర్ ఒక్కొ స్తుతి పాట పాడుత్న ఒలీవ మెట్ వయ్ కురియ్యుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","యేసుంద్ ఔరున్ ఇంతెంద్. నీర్ సిమన్నమంది దద్రిల్ తిర్. తానుంఙ్ ఇంతె ఇనంఙ్ వాయుత్‍ అన్సాద్. గొర్రె లకున్ దెయ్యం హల్గెంతె మల్ల గొర్రెఇద్దె అద్దెఎద్ద. ");
INSERT INTO nit_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","గని అన్ తిక్తతనట్ సుల్తన్ ఇంతె ఇముంఙ్ ముద్‍ర్వై గలిలీయ బార్సంఙ్ సెస్సాత్. ");
INSERT INTO nit_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","పేతురుంద్ యేసుకున్ ఇంతెంద్. సిమ్కన సాయ్యుత్ సెద్దర్ ఎన అన్ సాయెన్. ");
INSERT INTO nit_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","యేసునున్ పేతురుంద్‍ ఇంతెంద్. అన్ కరెయ్ ఇడ్సత్ ఇనెడ్ సింత్తె నిమట్ పోత్ కూగెంఙ్ పేలె అముదు అనుంఙ్ ఒర్కి తోతెద్ ఇసా ముదిగుసాల్ ఇందతి. ");
INSERT INTO nit_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","పెన్న పేతురుంద్‍ గుల్ ఇమతడ్ ఇడ్‍నెద్. అన్ ఇన్‍ వెంట తికత్ గని ఇమ్‌ద ఒర్కితొతెద్ ఇసా అన్ఇన్ ఇడ్నెంద్. సిమ్కన సిసు అనాయ్ ఇన్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ఔర్ గేత్సేమన్ పేర్ జాగంఙ్ సెందెర్. యేసుంద్ తన్నె సిసులున్ ఇంతెంద్ అన్ పార్తన కలెంఙ్ నీర్ ఇత్తి ఉదుత్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","యేసుంద్ తన్న వెంట పేతురుక్ యాకోబ్‍ అని యోహాన్ నున్ తోడసెదెద్. అని అముదు నారాజ్ ఎత్న సుయ్ పడ్ నంసాద్. ");
INSERT INTO nit_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","అముదు ఔరున్ ఇంతెంద్. బరమందినెత్న పానం తికేకద్ లంఙ్ గుల్ నారాజ్ ఎత్ అన్సాద్. ఇత్తిని అండ్రు అని ఉసరి అండ్రు. ");
INSERT INTO nit_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","మల్ల కొన్సెం మంది సెత్న అముదు బూమిత్‍ గొగుత్న ఇనంఙ్ పార్తన కతెంద్. ఎరెసద్ ఎరత్తె ఆ దుక్కం అన్నతన్న కురియుత్ సెరెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","అని అముదు ఇంతెంద్. బబా ఇన్నాడ్ ఎర్సెటద్ ఎద్ది తోతెద్. ఈ తక్లిబ్‍నె మొపున్ అన్నంతన్న కురియెంఙ్ ఇడ్. గని అన్నె మన్నడ్ తోద్. ఇన్నె మంన్నడ ఎక్కద్. ");
INSERT INTO nit_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","మల్ల అముదు వాతన్న ఆ తురెకరున్ ఓలుత్న సీమోన్ పేతురుంద్ ఇంతెంద్. ఎ సిమోన నీ మంఙ్ తివా? ఒక్కొ గట్ట ఎన ఉసర్ అనెంఙ్ సాలేవ? ");
INSERT INTO nit_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","నీర్ పరిక్స పడెంఙ్ తోద్ ఇసా ఉసారడ అండ్రు అని పార్తన కలుర్. ఆత్మంఙ్ కర్రె ఆసా అన్సాద్ గని సెత్త అల్కె అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","యేసుంద్ పెన్న సెతన్న ఆ గొట్టికుని ముడుత్ పార్తన కతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","పెన్నవాతన్న ఔర్ తురెకరున్ ఓల్ తెద్. ఔరె కడ్ల గుంల్ సినా ఎతండ్డె. అదుంఙ్ ఎత్తి తన్నెద్ ఇడ్డెకద్ అద్ద ఔరుంఙ్ కరిలెది. ");
INSERT INTO nit_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","మూందిగుస్సాలుంఙ్‍ యేసుంద్ ఔరున్ ఇంతెంద్. ఇంక్క నీర్ మంగుతి అన్సాతిర? మన్కనె పోరక్ పాపి మన్కకెరె కెయ్యుత్ సుముత్ సియెక మొక్కవత్తిన. ");
INSERT INTO nit_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","సులుర్. నేండ్నెంరన్. ఓలుర్. అన్న సుముత్ సియెకద్ మెర్ర వార్సనంసాద్. ");
INSERT INTO nit_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","యేసుంద్ ఇక్క ముడసానిఅన్నెంఙ్ బరమందిన్ లోపా ఒక్కొద్ యూదక్ వతెంద్. అమ్నున్ వెంట బార్స దెయ్యలకెర్. సాస్త్రి మన్కకెర్ అని మన్‍ వాల్లె పన్కత మంది తల్వల్ అని టేగ్రిక్ సుముత్న వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","యేసునున్ సుముత్ సియెకా ఒక్కొ ఒర్కి ఇడతెద్. అన్ ఎనున్ ముద్ ఇడసాత్ అముదు యేసుంద్ ఎన్నెంద్. అమ్నున్ సుముత్ పక్కకటుత్న కొసుర్. ");
INSERT INTO nit_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","యూదక్ వతెంద్ తె జల్ది యేసుకున్వై సెత్న గురుజి ఇంత్న ముదిటెద్. ");
INSERT INTO nit_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","మల్ల ఔర్ యేసునున్ కట్టుత్‍ సుముత్‍ కొసార్. ");
INSERT INTO nit_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","అపుడ్ యేసునున్ మెర్రం ఇల్లుకుత్ అనెకద్. లోప ఒక్కొంద్ తనే తల్‍వరున్ పుసుత్న పుడరి దెయ్యలక్నే గడియకెరె కేవున్ పుత్సద్. ");
INSERT INTO nit_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","యేసుంద్ ఔరున్‍ ఇస్సాద్. డొగ్గన్ సుమ్మెకార్ లాఙ్ తల్‍వల్. టేగ్రిక్ తోడ అన్నసుమ్మెకాదుంఙ్ కుర్యిత్ వర్సతిర్? ");
INSERT INTO nit_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","అన్‍ రోజ్‍ ఇమున్ వెంట మందిరుత్ కారప్‍సా అనేంఙ్ నీర్ అన్న సుమ్మెతిర్. గని లేకనముత్ వాయుత్ సిమ్కన ఏరేంఙ్ ఇసా. ఇనంఙ్ గండిల్‍సానంసా. ");
INSERT INTO nit_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","అని సిసు సట్టం యేసునున్ సాయుత్న తుల్‍సార్. ");
INSERT INTO nit_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","జవ్వన్ పోరక్ ఒక్కొంద్ డుడకి అండెన్ గని దొత్తిన్ పొరుకుత్న యేసుకున్ వెనక్ సేన్నేన్. ఔర్ అమ్నున్‍ కట్టెంఙ్ సుమెంఙ్‍కన్నెర్‍. ");
INSERT INTO nit_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","అపుడ్ అమ్నున్‍ సుమ్మెగె కాలేంగ దొత్తిన్ సాయుత్న ఉల్‍వై కురియుత్ తుల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ఔర్ యేసునున్‍ పుడరి దెయ్యలక్నె ఎల్లంఙ్ కొస్‍త్తెర్‍. కొర్‍సర్ సట్టం పుడరి దెయ్యలక్ మన్ వల్లె అని సాస్త్రి మన్కకెర్ మిరయుత్న అన్సార్‍. ");
INSERT INTO nit_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","పేతురుంద్‍ యేసుకున్ వెన్క దవ్‍డి సేత్న పుడరి దెయ్యలక్నే ఎల్లత్ ముండట్ సిపాయిక్ వెంట ఉద్దుత్ కిస్ అద్స అన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","బర్‍సా దెయ్యలకేర్ అని మిరయ్‍తర్ బర్‍సా మన్ వల్లే సట్టం. యేసునున్ హల్గెంఙ్ ఇసా పైలి సాక్సములున్ కిరవ్‍నేర్‍ గని ఒక్కొ గలతిత్‍ గిన రొంబడెతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","గుల్లెన మన్కకెర్ పైలి సాక్సములున్ సియ్యితెర్ గని ఔరె సాక్సం కలయేతె. ");
INSERT INTO nit_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","అని కొన్సెంమంది ఇల్లుత్న అమ్నున్‍ విరోద్ పైలి సాక్సం సియుత్న ఇసార్. ");
INSERT INTO nit_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","మన్కకెర్ కట్‍తా మందిరున్ ఓద్రిపుత్న ముద్ది దినాలుంఙ్ ఇల్‍ప్ సాత్ అనంఙ్ ఇమ్‌దు ఇనేకాదున్ విత్తమ్. ");
INSERT INTO nit_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","గని ఎనాయ్ ఎక్కద్ ఔరె సాక్సము పడెతె. ");
INSERT INTO nit_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","అపుడ్ పుడారి దెయ్యలక్ నడమ్ ఇల్లుత్న యేసునున్. వేలుత్ ఓలెఙ. ఇవ్రు ఇన్న విరొది ముడ్సర్ ఇద్ తనేద్ ఏంద్ ఔర్ సియ్యెకాదున్ ఇనుంఙ్ తనయ్ తోతెద. ");
INSERT INTO nit_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","గని యేసుంద్ దబ్బి అండెద్. తనయ్ ముడెతెన్. మల్ల పుడారి దెయ్యలక్ అమ్నున్‍ వేలుత్ ఓల్నెర్. నీ దెయ్యమ్నె పోరక్ ఏన్నివా? యూదులె క్రీస్తు నివా? ");
INSERT INTO nit_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","అపుడ్ యేసుంద్ ఇసాద్. అన్ ఏదున్. సట్టం సక్తితనే ఉన్న పక్కంఙ్ మన్కనె పోరక్ ఉద్దుత్ అనెకనున్ ఓలతిర్. అని స్వర్గ తన ఆబార్ వెంట వరేకానున్ ఓలతిర్. ");
INSERT INTO nit_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","అపుడ్ పుడారి దెయ్యలక్ రగ్గుంఙ్ వత్న తన్నె జుఙ్ఙెన్ ఇరుకుత్న ఇసాంద్. తానుంఙ్ నేడుంఙ్ ఇంక్ సాక్సం వాలె తాగలెంఙ్? ");
INSERT INTO nit_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ఇమ్‌దు దెయ్యం విరొద్ అప్మాన్ ముడెకానున్ వింత్న అసాతిర్. నీర్ తానెద్ ఇసాతిర్? అపుడ్ సట్టం బర్ లర్‍ మన్ వల్లె ఇనంఙ్ ఇల్‍ప్ త్తిర్‍ అమ్నున్‍ అల్గెకాద్ సోయ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","కొన్సెంమంది అమ్నున్‍ ఏవుర్ ఊసెంఙ్ ఎద్దెర్‍. అని అమ్నె కండ్లున్ కాటుత్న యేసునున్ దన్‍పుత్నఇసార్. పుందేవె ఇన్ దన్పతద్ ఏంద్? సిపాయిక్ అమ్నున్‍ కొస్సెంఙ్‍ చెంపలేంఙ్ సియిసార్. ");
INSERT INTO nit_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","పేతురుంద్ బూడున్ బోయ్దత్ అనేంఙ్ బార్స దెయ్యలక్నె రప్తిరాసిక్ లోప ఒక్కొద్ అమ్నున్‍వై వర్సద్. ");
INSERT INTO nit_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","పేతురుంద్ కిస్ అదెంఙ ఆ పిల్ల అమ్నున్‍ గులేన ఓలుత్న ఇస్సాద్. అముదు నజరేత్ ఊరద్ యేసుకున్ వెంట తనివితా! ");
INSERT INTO nit_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","అముదు తోద్ ఇత్న నీ తనేద్ ఇసాతివొ అనుంఙ్ ఏరక్ తోద్ అనంఙ్ ఇత్న ఔర్ తన అవర వై సేసాద్ పోత్ కూగెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ఆ రప్త్తిరాలున్ ఓలుత్న మెరం ఇలుత్ అనెకారున్ మల్ల డఙ్ఙెంఙ్ ఎదెంద్‍. ఇమ్‌ద మన్కక్ ఔరె వెంట తద్ ఏన్నెద్. ");
INSERT INTO nit_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","అముదు మల్ల తోద్ ఇసాద్. జమట్టినాడ్ మల్ల మెరం ఇల్లుత్ అనెకారున్ పేతురుంద్‍ ఇసాద్. కారే నీ ఔరె వెంటతరి ఏన్న. కారే గలిలీయ తని ఏన్నివ్. ");
INSERT INTO nit_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","అన్ పైలిన్‍ ముట్టనింతె దెయ్యం ఓల్సద్ ఇనుత్ సాపత్ ఇడ్సద్. నీ ఇండెకానున్ బదోల్ అనుంఙ్ ఏరక్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","వెంటని ఇదిగుసాల్‍ పోత్ కూగెంఙ్. అపుడ్ యేసుంద్ తనుంఙ్ ఇడ్‍ తా గొట్టిక్ పేతురునుంఙ్ అదివాత్తె. పొత్ నిమట్ కూగెంఙ్ పేలెయ్ అన్ ఎందొ ఒర్కి తోద్ ఇసా ముదిగుసాల్ ఇందత్తి. పేతురునుంఙ్ దుక్కమడ్ అరెంఙ్ మోదలిటెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","తొల్లిని దండి దెయ్యలకెర్. సాస్త్రిక్ అని దండి మనకకెర్ ఔర్ సదర్ అదికారిక్ మిరయుత్ యేసునున్ సుముత్ పిలాతున్‍ ముండట్ కొసుత్న అవల కానర్ ఇసా ఇతెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","అద్ వకతుంఙ్ పిలాతు యేసుకున్ ఓలుత్న నీ యూదకెరె రాజక్నివా? ఇసా వెలుత్ ఓల్నెంద్ తె నీ ఇంతేతియ్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","అపుడ్ ఔర్ దండి దెయ్యలకెర్‍ పేలె కరాబ్ పానిక్ కతెంద్ ఇసా బద్నమ్ కత్తెర్ ");
INSERT INTO nit_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","అద్ద విత్న పిలాత్ ఓల్ ఇన్ పొయ్ ఎన్నిగొ రంఙులడ బద్నమ్ కల్సనాంసరొ నీ ఔరున్ తనయ్ ఇన్నెతివ? ఇసా వెలుత్ ఓల్ తెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ఎన గని అముదు యేసుంద్ దబ్బ అండెద్. పిలాత్ అమ్నున్ ఓలుత్న గుల్‍ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ఆ పస్క పండ్గుంఙ్ జీర్ ఔర్ ఇడ్డెక గొట్టినడ్ ఓలతె జెల్ తన ఎందెన్ ఒక్కొనున్ సయెక కయ్‍ద అడ్డిన్. ");
INSERT INTO nit_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","బరబ్బ ఇన్నెకద్ ఒక్కొమన్కక్ రోమ సర్కరున్ విరోద్ ఎత్న తన్నె దొస్తాకెర ఎంతె ఓ మందిన్ అల్ఙుత్ ఔరున్ బరబర్ జేలుత్‍ అండెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","సాలుంఙ్ ఒక్కొనున్ జెల్‍తన సాయ్‍తెతి ఇసాల్‍నాయ్ ఒక్కొనున్ సాయెంఙ్ ఇసా పిలాత్ ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","పిలాత్ ఔరున్ ఇంతెంద్. యూదులె రాజక్ కున్ ఇముంఙ్ సటీ సాయెంఙ్ ఇసాతిర? ");
INSERT INTO nit_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ఔర్ దండి దెయ్యలకెర్ అముదు యేసున్ కుర్‍కుర్‍కత్న చిర్‍వర్ఎత్న అనుంఙ్ ఇడ్‍తెర్ ఇసా పిలాతుంఙ్ ఒర్కి కత్తెర్. యూదులె రాజుద్ ఇసా కూగుతెంద్ అముదు యేసునున్ అన్త గలుడ్? ఇసా వెలుత్ ఓల్తెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","గని మన్కకెరె గర్దిన్ బార్స దెయ్యలకెరున్ ఔర్ ఇంతెర్ అముంఙ్ సటీ బరబ్బ కున్ సాయెంఙ్. ");
INSERT INTO nit_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","పిలాత్ పెన్న మందిన్ ఇంతెంద్. యూదు మన్కకెరె రాజక్ కున్ అన్‍ తగద్దున్? ");
INSERT INTO nit_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ఔర్ పెన్న ఇనంఙ్ వపొయ్‍తెర్. అమ్నున్ సిలువత్ కుడుకుర్. ");
INSERT INTO nit_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","అదున్ వింత్ పిలాత్తనుంఙ్! ఇమ్నున్ అలుంగుర్! ఇసా ఇసాతిర్? ఇమతద్ కసుర్ కతెంద్? ఇసా ఔరున్ వెలుత్ ఓల్తెద్. తె ఔరె పర్జు వపొయెకద్ ఇక్క జోర్‍కత్న అమ్నున్ మోద్నె సిలువత్ వెల్లిడుత్ అల్ఙెంఙ్ ఇసా వపొయ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ఔర్ సదరె గొట్టిన్ వింత్న. పిలాత్ జేలుత్‍ అనెక బరబ్బ కున్ సాయెంఙ్ ఇడ్‍తెర్ అని యేసున్ సాట్లడ లగపుత్న మోద్నె సిలువత్ వెల్లిపుత్ అలంగెంఙ్ ఇసా సిపయిక్లె కేయ్యుత్ సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ఔర్ సైనిక్‍ యేసునుంన్ దొడా అనెక మజ్లిత్ కొసుత్న. అనెకర్ సదర్ మంది సైనికున్‍ అవ్రత్తి మిరప్ తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ఔర్ సదర్ మిరయుత్న యేసునున్ రాజక్ నీడ రంఙ్త జుఙ్ఙె తొడప్‍తెర్. అని సాల్ల టొపి తొడప్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ఔర్ యూదులె రాజక్ ఇనుంఙ్ జెయ్ జెయ్ కార్ఇసా వపొయ్‍తెర్ ఎపుడి బత్క. ");
INSERT INTO nit_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","రెకా కోలనడ్ తల్లున్ లగప్నెర్ అని ఎవుర్ ఉసనెర్ అని బొల్ల పడుత్ అమ్నె కాల్‍ మొక్నెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","అనంఙ్ ఎద్ద వెన్కత్. అమ్నున్ అప్మాన్‍ రాజక్ నీడ రంఙ్త జుఙ్ఙెలున్ పుసుత్న. అమ్నె జుఙ్ఙె అమ్నుంఙ్ తొడుపుత్. అమ్నె పానమ్ ఎకెంఙ్ ఇసా మోద్నె సిలువత్ వెల్లిపెంఙ్ వాకా తోడ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","అపుడ కురెని పవతద్ అలెగ్జాండర్ అని రూపసునె బాంద్ సీమోన్ కెన్‍ తానా కురెని పట్నంముంఙ్ కలయ్‍త వరెంఙ్ అలెక్ జండఇనెక మన్కక్నె బాంద్‍ వాకవత్న అత్తి వార్స నానెంఙ్. ఔర్ సిపయిక్ యేసుంద్ కాజుత్ అనెక మొద్నె సిలువన అమ్నుంఙ్‍ జులుమ్మి కాజిప్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","మల్ల ఔర్ యేసునుంన్ గొల్గొత ఇనెక జాగంత్ సుముత్ వాతెర్. గొల్గొతా ఇంతె తలత టొర్‍కె ఇసా అర్తం ");
INSERT INTO nit_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","అత్తి ఆంగుంల్లె రసా బోలమున్ కలపుత్ ఔర్ ఉనెంఙ్ సియితెర్ గని యేసుంద్ ఉనెత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","తె అద్ద ఎద్ద వెన్కత్ జుఙ్ఙెలున్. పుసుత్న ఔర్ అమ్నున్ మోలలాడ్ కుడుకుత్న మొద్నె సిలువత్ వెల్లిప్‍తెర్ అని అద జుఙ్ఙె తన ఎనుంఙ్ ఎద పాజె ఇసా సిట్టిక్ తపుతెర అని పైతెర్ ");
INSERT INTO nit_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","తొల్లిని తొమ్మిది గంటల టయిముంఙ్ యేసునుంన్ మొద్నె సిలువత్ వెల్లిప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","అమ్నున్ పొదె తప్‍త కసురున్ యూదులె రాజక్ ఇసా పట్టెత్ వయ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","యేసుకున్ వెంట ఇద్దర్ డొంగలున్ ఉన్న పకంఙ్ ఓకొనున్ ఎడమ పకంఙ్ ఓకొనున్ మొద్నె సిలువత్ వెలిప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ఇడ్‍ తా గొట్టిక్ పూర ఎద్దెతి డొంఙ్ బరబర్ సామనం ");
INSERT INTO nit_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","మల్ల ఆ పవడ్ సెరెకర్ వరెకర్ అమ్నె దుసన్ కత్న తమ్మె తల్లున్ వంపుత్ వంపుత్ ఇంతెర్ ఓ ఓ. గుడిన్ ఓద్రిపుత్న ముండొలుంఙ్ ఇల్‍పెకని నివి ఎన్ని వా ఇసా తల్కు మెలప్‍సార్? ");
INSERT INTO nit_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","పావి సెరెంగ వారెంగ కలెకర్ కొన్సెం మంది తమ్మె తల్కులున్ మెల్‍ప్సా అయ్అయ్ ఇమ్‌దు గుడికున్ ఓద్రిపుత్ ముండొలుంఙ్ పెన్న కటెంఙ్ సాలసాద గని ఇండి తన్నెత్ తని మొద్నె సిలువతన్న డిగుత్ తన్నె పానమున్ బత్కిపెంఙ్ సాలెద ఇసా ఇనంఙ్ ఇన్నెర్ ");
INSERT INTO nit_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ఔర్ లాఙి దండి దెయ్యలకెర్ అని సాస్త్రిక్ మరొక్కొరున్ బత్కిప్ తెంద్ గని ఇండి తనెత్ తని బత్కిపెంఙ్ సాలెంద గయె. ");
INSERT INTO nit_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ఇమ్‌ద కరెయ్ ఇస్రాయేలె రాజక్ క్రీస్తుద్ ఎనెద ఎరత్తె ఆ మొద్నె సిలువతన డిగుత్ వాకద్ అపుడ్ అమ్ అమ్నున్ పొయ్ బరొస ఇడ్సాతుమ్ ఇసా గమత్ కత్తెర్. యేసుకున్ వెంట అనెక ఇద్దర్ డొంఙ్ గిన అమ్నున్ ఇనంఙ్ గమత్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ఆ దేసెముత్ దుపరి బరగంట్ట తన్న ముది గంట్టలుంఙ్ ఎంత చిరిమ్ చికటి ఎత్తడిన్. ");
INSERT INTO nit_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","అనాయ్ దుపారి ముది గంట్టలుంఙ్ యేసుంద్ యెలొయి లామ సబక్తని. ఇసా జోరనట్ వాపొయ్‍తెద్. ఇద్నె అర్తం అన్నె దెయ్యం అన్నె దెయ్యం అన్ తనుంఙ్ సయ్‍తి? ");
INSERT INTO nit_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ఇన్నెంఙ్ కొన్సెంమంది ఇంతెర్ ఇమ్‌దు ఏలీయా ప్రవక్త కున్ కుఙ్సాద్ ఇసా తప్ విచార్‍ కత్న ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","అవ్రతద్ ఒక్కొద తుల్ సెత్న పుల్లె అంగుర్నెరసాత్ రుయ్యున్ ముంపుత్ అదున్ ఒక్కొ పొడమ్ రెకా కొలత్ సికిపుత్న యేసుక్నె మూతిత్ ఉర్తెద్. గని మల్ల ఒక్కొద మన్కక్ అమ్నున్ ఏలీయా ప్రవక్త వాత్న కాపడ్సదొ తనెదొ ఇసా ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ఆ గట్కంఙ్ యేసుంద్ గుల్‍జొరకత్త వపొయుత్న తన్నె ప్రనున్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","అపుడ్ యెరుస్‍లెముత్ అనెక దెయ్యమ్నె మందిర్‍ తా పాడ్ద పొలడ్ బుడుంఙ్ ఎంత్ ఇరియుత్ ఇద్ది తుక్డె ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ఆ గట్ కంఙ్ నుర్ మందినె సిపయి పుడరి మొద్నె సిలువ ముండట్ ఇల్లుత్ అండెద్. అముదు యేసునె తికె కదున్ ఓలుత్న ఇమ్‌ద కరెయ్ దెయ్యమ్నె పోరక్ ఎంన్నెద్ ఇసా జోరకత్న ఓప్తెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","అద్ అనంఙ్ జరిగిలెకద్ సదరున్. మగ్దలెని మరియ. యాకోబ్ అని యోసేపుంఙ్ అమ్మ ఎరెక మరియ్యక్ అని సలొమి ఇన్నెక మంది పిల్లక్ దవడ ఓల్‍సా అనేఙా. ");
INSERT INTO nit_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ఇద్ద పిల్లక్ గలిలీయ అనెంఙ్ అమ్నె సర్న సుముత్న బక్తినడ సేవ కలసనంనెక వెన్నె. ఇదవి ఎరెకడ పేన యేసున్ వెంట యెరూసలేముంఙ్ వాత్త పిల్లక్ గిన అండె ");
INSERT INTO nit_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ఆ ఆలపుసేక దినమ్ ముండట్ సింతెవెలామ్ దినమ్ అడ్డిన్. ");
INSERT INTO nit_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","అరిమతయి ఉర్‍త యోసేప్ ఇనెక న్యాయ్ సాబాత్ మెంబర్ అండెద్. అముదు సెత్న దెయ్యమ్నె రాజ్యం మున్ పవొల్‍నెద్. సింతెవేల యోసేప్ దర్యిం కత్న పిలాతున్‍వై సెత్న యేసునె సెత్తన్ వెల్ తెద్. ");
INSERT INTO nit_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","పిలాతుంఙ్ కమల్ ఎద్దిన్. యేసుంద్ ఇంతెనడి ఎనంఙ్ తిక్తెద్. అముదు నుర్ సిపయిక్లె పుడరిన్ కూగుత్న వెలుత్ ఇల్తెద్. కరెయ్ యేసుంద్ తిక్తెద్? ");
INSERT INTO nit_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","సిపయిక్లె పుడరి తన్న యేసునె తిక్త కబుర్ విత్న. పిలాత్ యేసునె సెత్తన్ యోసేప్నె కెయుత్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","యోసేప్ ఒక్కొ కండ్‍వా సుముత్న యేసునున్ డింపుత్ కవాడ్ అమ్నున్ గుడపుత్న కన్న కత్త గుడుత తప్నెత ఇట్టెర్ అని తప్నెనె మూతిత్ గుండ గెంతెర్. ");
INSERT INTO nit_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","యేసునున్ ఎత్తి ఇట్టెర్ అజాగన్ మగ్దలెని మరియ అని యోసేప్నె అమ్మ మరియక ఓల్నెహ. ");
INSERT INTO nit_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ఆలపుసేక దినమ్ ఎద్ద వెన్కత ఇంతె అదుంఙ్ పేలె ఐతరం దినముంఙ్ కొర్‍ కూతఙి, యోసేప్ అని యాకోబ్నె అమ్మ మరియ. మగ్దలెని మర్యక్ అని సలొమి సులుత్న. గమ్మగమ్మ అత్తర్ నూనె దీటుత్ సుముత్ యేసునె కుర్యుత్ దిటెంఙ్ ఇసా తప్‍నెంఙ్ సెరెంఙ్ కురియ్‍తె. ");
INSERT INTO nit_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","అనాయ్ ఐతరం తొల్లిని పొద్ కురియెంఙ్‍ పేలె పావి సెసాననెఙ ఔర్ యేసునె తప్నెంఙ్ వర్సనండర్. ");
INSERT INTO nit_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","గని ఆ తప్నెత్ ఇట్ట దండి గుండున్ ఏర్ సర్కిప్దర్ ఇసా ఒక్కొద్నెత్ ఒక్కొద్ ముడ్స వర్సనన్నె. ");
INSERT INTO nit_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","గని తప్నె మేరమ్‍ సెత్న ఓలెఙ ఆ గెద్త దండి గుండ్ పకంఙ్ సర్కిలుత్ కండ్కెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","తె తప్నె లోప ఓల్నర్‍ సెండ్ ఇసా మెరమ్ సెత్న ఓలెంఙ్. అదవ్లె ఉన్న బాజుంఙ్ చక్‍తెలొడి పొడా జుఙ్ఙే తొడుత్ దూత్ జవాన్లంఙ్ ఉదుత్ కండ్కెద్దెంద్. అమ్నున్ ఓలుత్ గుల్ ఎద్దె. ");
INSERT INTO nit_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","తె అన్న ఓలుత్ ఆర్సనెర్. మోద్నె సిలువత్ వెల్లిపుత్ అలంఙ్తెర్. అముదు నజరేత్తంద్ యేసునున్ కిరవ్సతిర్ ఇసా ఒర్కియ్. అముదు ఈ తప్నెత్ తోతెద్. అముదు పెన పానమ్ ఎద్దేంద్ ఇదొ అమ్నున్ ఇట్ట జాగన్ ఓలుర్ ఇసా ఆ దూత్ ఓలిప్తిన్. ");
INSERT INTO nit_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","యేసుంద్ ఇముంఙ్ ఎన్న కరెయ్ ముండట్టి గలిలీయ సెసనంసాద్. పేలె ఇడతెతి ఇముంఙ్ అత్తి కలయ్‍దంద్. ఇన్నెకర్. అమ్నె సిసులూన్ అని ఔరత పేతురునున్తె మద్‍సెట ఇడుర్ ");
INSERT INTO nit_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ఇసా పిల్లకున్ రక్స ఇడతెద్. తె అద పిల్లక్ గుల్ అర్సుత్ తప్నెతనట్ వాక కురియుత్ తుల్ సెదె. ఆ సత్తెం ఓలుత్ అర్సుత్న అదున్ బదోల్ ఎరుఙి ఇడ్డెతీన్. ");
INSERT INTO nit_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ఐతరం జీర్ తొల్లిని యేసుంద్ పానం ఎద వెనకత్. ఏడ్ బూతులున్‍ పుస్త మగ్దలెని మరియకుంఙ్ పవింలుత్ కండ్కెద్దెద్. ");
INSERT INTO nit_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ఆ పిల్ల యేసుక్నె సిసువై సెదిన్. అపుడ ఔర్ సదర్ గుల్ దుక్కడ్ అర్స నంనెర్. అదుంఙ్ జర్గిల్‍త్ గటనన్ ఔరుంఙ్ ఇడతిన్. ");
INSERT INTO nit_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ఎన గని యేసుంద్ పానం ఎద్దెంద్ ఇసా ఔర్ అదున్ నంమెతెర్. ");
INSERT INTO nit_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","అదుంఙ్ వెన్కత్ ఇద్దర్ సిసులుంఙ్ యెరూసలేమ్‍ పవడ్ సెరెక ఒక్కొ ఉర్ ఇద్దర్‍ మన్కకెరుంఙ్ కండ్కెద్దెద్‍. మరొక్కొ రూపడ అనెంఙ్ ఔర్ యేసునున్ ఓర్‍కిలెతెర్. ");
INSERT INTO nit_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ఔర్ మలయుత్ సెత్న అనెక సిసులుంఙ్ అదున్ బదోల్ ఇడతెర్. గని ఔర్ ఎరి ఔరె గొట్టిన్ నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","అనంఙ్ ఎద్ద వెనకత్ యేసుంద్ తన్నె అక్ర మంది సిసు. తిసననెకరత్తి వాత్న ఔరుంఙ్ పావింల్‍తెద్. అని తిక్కుత్ పానమ్ ఎద్దేంద్ ఆ గొటిన్ పేలెటర్ ఇముంఙ్ ఇడతెర్ గని తనుంఙ్ నమ్మెరి? ఇమ్మె వ్రుదయ్‍త మందిర్క గుడ్లలఙ్ ఎదె ఇసా దమ్కి సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","పర్‍పంసం పూర దున్యత్ ఇద్ద అన్ తికుత్ పానమ్ ఎర్ర సువార్త సదరుంఙ్ ఇడ్డుర్ ఇసా ఉకుంమ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ఇద్ద సోయ్త కబురున్ వింత్న ఎంద్ అదున్ పొయ్య విస్వాస్ ఇడుత్న పరిసుద్ద ఆత్మనాడ్ బాప్తిస్మ సుమ్ సార్. ఔరుంఙ్ దెయ్యం సిక్సతన కాపడద్ అని ఎర్ అదున్ పొయ్ విస్వాస్ ఇడెర్ ఔరున్ దెయ్యం సిక్స సియ్‍ద. ");
INSERT INTO nit_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","అన్నె బక్తకెర్ ఇంట్ట సమత్కలున్ సిన్నకతర్. విస్వాసు అన్నె పేర్త సక్తినడ్ మరొక్కొ రంఙ్త బూతులున్ పుసుత్న ఎద్గతెర్ అని మరొక్కొ మరొక్కొ గొట్టిక్ లాడ్ ముడెంఙ్ సల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","తమ్మె కెయులడ పాములుంన్ సుమ్మెంఙ్ సాల్‍దర్. విసముంన్ ఉండె గిన ఔరుంఙ్ తనయ్ ఎరెద్. ఇది ఎరెకడ్ అన్నె బక్తకెర్ వెస్సలకెరుంన్ పొయ్ కెయ్య ఇడుత్ పార్తన కత్తెరింత్తె ఔర్ సోయ్ ఎద్దర్. ఇదహ సదర్ కాము అన్నె బక్తకెర్ కలెంఙ్ సాల్‍దర్ ఇసా ఇడతెద్. ");
INSERT INTO nit_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","యేసు ప్రబుద్ తన్నె సిసులుంన్ ఇద్ద సదర్ గొట్టిక్ ఇడ్డెక ఎద్ద వెన్కత్ అత్తి పొయ్ పరలోకముత్ సెత్న తన్నె బాంద్ దెయ్యమ్నె ఉన్న పకంఙ్ ఉద్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","అనంఙ్ ఎద్దవెంన్కత్ సిసు సిమ్కన మంది మరొక్కొ మరొక్కొ జాగలెంఙ్ ఇమ్‌ద యేసుంద్ తికుత్న పానం ఎద్ద సోయ్త కబురున్ సదరుంఙ్ ఇడసా సెద్దెర్. ఈ కాబుర్ కరెయ్ ఇసా ఒర్కిలెంఙ్ సటీ. ప్రబు ఎన్నిగొ సమత్కల్ ఔరె కెయ్యులడ్ కత్త ఇడ్తెంద్ అమెన్.");
INSERT INTO nit_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","మన్ వాలే తియొపియెలుంఙ్ నెడత్తి జర్గిల్త గట్న పేలెతన కండ్లాడ్ ఓలుత, దెయ్యమ్నె కార్యలున్ ఓల్తర్ నేండుంఙ్ అదవున్ గదిప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ఆనయ్ కబుల్లున్ బదోల్ వయెంఙ పేలెటర్ మన్కకెర్ సుల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","అద్దుఙ్ సటీ కొన్నిగొల్లడ్ ఆనా తపసి పుత్ ఓల్తవ్ సాదరి గొట్టికున్ ఇనుంఙ్ సర్ నీ వయెకద్ సోయ్ ఇత్తన్. ");
INSERT INTO nit_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","తానుంఙ్ ఇంతె ఇనుంఙ్ ఇడ్త గొట్టిక్లెత్ ఇనుంఙ్ క్రమసిక్సన్ వారెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","యూదు దేస్త హేరోద్ రాజక్ అడ్గిపెంఙ్, అబియక్ ఇనెకద్ దెయ్యలకెరె బాక్తక్ జకర్యక్ ఇనెక పేర్తంద్ ఒక్కొంద్ దేలక్ అండేంద్. అమ్నె మాస అహరోను పాడితద్ ఎంద్. అద్నె పేర్ ఎలీజబెత్. ");
INSERT INTO nit_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ఔర్ ఇద్దర్ నయ్ దెయ్యనె ఆగ్య నత్తి ఇమ్దర్ మన్కకెర్ అండెంర్, అని ప్రబుక్నె నేకి నీతిమాన్‍లత్తి ఇసొబడ్ సోయ్ అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ఎలీజబెత్ గొడ్డెర అండిన్ అదుంఙ్ సటీ ఔరుఙ్ పోరకేర్ తోతెర్ వహి ఎతండిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","మల్ల ఇనంఙ్ ఎద్దిన్ జకయ్యక్నె కామ్ దెయ్య లకెరె సేవ కాలెంఙ్ పాడి వత్తిన్ అముదు దెయ్యమ్నె సేవ కానెద్. ");
INSERT INTO nit_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","దేలక్నే నియమ్ దెయ్య లక్కెరె సేవనె ఇసొబాడ్ ప్రబునే గుడి లోప సెత్న దూప్ కిసిడెక పనిఙ్ సటీ చిట్టిక్ తపెంఙ్ అమ్నె పెరడ కురియ్ తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","దూప్ కిసిడెక్ వేలఙ్ మన్కకెరె గారది వాక పార్తన కాన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ఒక్కొద్ ప్రబు దూత్ దూప్ కిసిడెక జాగత ఉన్న పకంఙ్ ఇల్లుత్న అనెకద అమ్నుంఙ్ కండ్కెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","దూతున్ ఓలుత్న జకర్యక్ దద్రిల్ తెంద్ అని అమ్నుంఙ్ అరివత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","దూత్ అమ్నున్ ఇంతిన్ జకర్యక్ అర్సనెమ్ నీ పార్తన కత్త దెయ్యం వింత్తిన్ ఇన్నె మాస ఎలీజబెత్ కుంఙ్ ఒక్కొ పోరక్ జాన్మిల్ సాద అమ్నె పేర్ యోహాన్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ఇనుంఙ్ అనంద్ అని కుసీ ఎరద్. దడ్డి దానం రొబడద్. అముదు జన్మిలెకదున్ వలడ్ గుల్ మంది కుసింఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","తానుంఙ్ ఇంతె అముదు ప్రబునున్ ముండట్ దండి అన్సాద్. పుల్లె అంగుర్ రసాన్ అని కల్లున్ ఉన్నెద్ అమ్మనె పేట్టె లోపా తనటి పరిసుద్ద నాడ నిండుత్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","అముదు ఇస్రాయేల్ మన్కకేరున్ ఔరె ప్రబు దెయ్యమున్వై మలపుత్న కొద్దద్. ");
INSERT INTO nit_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","అని అముదు బానె మనున్ పోరక్లంఙ్ అని గొట్టి విసెటరున్ ఇమన్దల్లె బుద్దిన్ ఇడుత్న నీతి కుంఙ్ సటీ సవరిల్త మన్కకెరుంఙ్ తయార్ కాల్లెకదుంఙ్ ఏలీయా క్నె ఆత్మనడ్ అని తాకతడ్ పెర్గదద్. ప్రబున్ ");
INSERT INTO nit_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","అపుడ జకర్యక్ దెయ్యమ్నె దూత్ ఇంతెంద్ ఈ గొట్టి అనుంఙ్ ఎనంఙ్ కరిలద్? అన్ పబ్గు ఎద్దన అని అన్నె మాస లెత్నయ్ వాయి ఎద్దిన ");
INSERT INTO nit_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","దూత్ అమ్నున్ ఇంతిన్ అన్ దెయ్యమున్ ముండట్ ఇల్లెక గాబ్రియెల్ దుత్ ఎందున్ ఈ సోయ్త గొట్టిన్ తోడ ఇముంఙ్ ఇడ్డెకదుంఙ్ పన్కతరన్ ఎందున్. ");
INSERT INTO nit_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","అన్నె ఇడ్త గొట్టిన్ పొయ్ బరొస ఇడెతి ఇద కరే వెలంఙ్ అన్నె గొట్టిక్ కరె ఎనంతెంఙ్ నీ ముకక్ అద్దతి. ");
INSERT INTO nit_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ఆ వెలంఙ్ మన్కకెర్ జకర్యక్ వాక పావోల్నెర్. గుడిలోప అముదు తనుంఙ్ కోర్ము కతెంద్ ఎర్ర ఇసా ఔరుఙ్ కామల్ తక్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","మల్ల అముదు వకహవత్తె అమ్నుఙ్ ముడెఙ్ వరెద్ అమ్నుఙ్ గుడి లొపదర్సన్ ఎద్దిన్ ఇత్న ఔరుఙ్ కరిల్‍తిన్ అముదు ఔరున్ కెయ్యడ్ ఇడెంఙ్ ఎదెద్ అని అముదు ముకక్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","మల్ల ఇనంఙ్ ఎద్దిన అమ్నె సేవనె దిన ఎద్దె మల్ల అముదు తన్నె ఎల్లంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ఆ కొన్ని గొలుంఙ్ జక్కయక్నె మాస ఎలీజబెత్ పెటెనడ్ అండిన్ అని ఐద్ నెలదుక్ ఆద్ద ఎల్లతన కకా కురియెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","మన్కకెరె డవరి కలెక్ గొట్టి తన్న ప్రబు గెల్పెంఙ్ ఇసా దెయ్యం అన్నవై లక్స సియ్తిన్ అన్న అనుంఙ్ పవింల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ఆలిసిబా ఆర్‍ నెల ఎత్త అనెంఙ్ నజరేత్ ఊర్త జవ్వన్ పిల్లన్వై దెయ్యం గాబ్రియెల్ గలిలీయ దూత్ పాన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","దావిద్ రాజక్నె పాడితంద్ యోసేప్ పేర్తన్ వెంట ఆ పిల్లనె సోయ్‍రిక్ ఎత్తడిన్ అద్ద జవన్ పిల్లనె పేర్ మరియక్ అండిన్ కాబుర్ ఇడ్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","అని దెయ్యంమ్నె దుత్ అద్‍నత్తి వత్న. ఇంతిన్ దెయ్యం కివ్ కత్త పిల్ల ఇనుంఙ్ సొయ్ ఎక్కద్ ప్రబు ఇన్వెంట అన్సాద్. పిల్లక్లత్తి నీ బాగ్యివన్ అన్సాతి. ");
INSERT INTO nit_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ఆ దుత్నె గొట్టిన్ మరియక్ గుల్ గాబ్రిల్‍తిన్ అని ఇగొట్టిక్ తన్నెద్ బదోల్ తా ఎన్నెవ్ ఎర్ర ఇసా తన్నె మన్ లోప విచార్ కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","అని దెయ్యమ్నె దూత్ అదున్ ఇంతిన్ మరియక్ అర్సనెమ్ తానుంఙ్ ఇంతె దెయ్యం కృప ఇముంఙ్ రొబటిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ఓల్ నీ పెట్టెనడ్ అందత్తి అని ఇనుంఙ్ పోరక్ జాన్మిల్దాద్ నీ అమ్నె పేర్ యేసుంద్ ఇడెఙ్. ");
INSERT INTO nit_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","అముదు కుబ్బి మన్‍వలె అద్దద్ అని అమ్నున్ దండి దెయ్యమ్నె పోరక్ ఇదర్ అని ఈ ప్రబు దెయ్యం అమ్నుఙ్ దావిద్నె రాజ్ సియదద్ ");
INSERT INTO nit_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ఆమ్దు యాకోబనె కుటుంబతర్ పొదె ఎప్పుడి రాజ్యం కదద్ అని అమ్నె రాజ్ మొడిలెకద్ ఎరెద్ ");
INSERT INTO nit_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","మల్ల మరియక్ దూత్ ఇంతిన్ ఇద్ద ఎనంఙ్ ఎర్రద? అన్ పడ్స నే మొకమునాయ్ ఓలెతన్ తా. ");
INSERT INTO nit_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","అని దూత్ అదున్ ఇంతిన్ పవిత్ర దెయ్యం ఇన్న పొదె వారద అని సక్తి దండి దెయ్యమ్నె నిడ ఇన్‍పొయ్‍ముసాద్ అదుంఙ్ ఎత్తి ఇన్నుంఙ్ పరిస్దు పోరక్ జన్మిలెకద్ అన్సాద్ అమ్నున్ దెయ్యమ్నె పోరక్ ఇందర్. ");
INSERT INTO nit_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ఓల్ మన్కకెర్ గొడ్డెర ఇన్నెక్ ఇన్నె గంన్‍గొత్ ఎలీజబెత్ వై విడ్‍తద్ అడిన్ ఎన కరెయ్ ఇండ్డి పెట్టెనడ్ అన్సాద్. అదుంఙ్ ఆర్ నేల ఎద్దె ");
INSERT INTO nit_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","దెయ్యంమ్నడ్ ఎర్రెద్ ఇన్నెకద తానయ్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","అదుఙి మరియక్ ఇంతిన్ అన్ ప్రబు సేవక్రలన్ ఇన్నె గొట్టి లాఙి అనుంఙ్ ఎర్సాద్. ఎక్కద్ ఇంత్తిన్ అప్పుడ్ దెవ్ దూత్ కురియుత్ సెదిన్. అనాయ్ అనుంఙ్ ఎక్కద్. మల్ల దెయ్యంమ్నె దూత్ ఆ పిల్ల నత్తన కురియుత్ సెదిన్ ");
INSERT INTO nit_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","దినాలుంఙ్ మరియక్ సవరిలుత్న జల్‍ది యూదియ తా మెట్ పొదె అనెక్ ఊరుఙ్ సెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","అని అద్ద జకర్యక్ ఎల్లంఙ్ సెత్న ఎలీజబెత్ కుంఙ్ సాలమ్ ఇడతిన్ ");
INSERT INTO nit_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ఎలీజబెత్ మరియక్ ఇడత సలమున్ వినెంఙయ్ అద్నె పెట్టె లోప అనెక్ పోరక్ మెలగ్తెంద్ అని ఎలీజబెత్ దెయ్యంమ్నె పరిసుద్ద ఆత్మనడ్ నిండ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","అని అద్ద జోరకత్ వాపొయుత్ ఇంతిన్ పిల్లక్ లోపదెయ్యం ఆసిర్వద్ సియుత్ అసాతి అని ఇన్నె పెట్టెత పోరక్ దెయ్యం ఆసిర్వద్ సియ్తద్ అడ్డద్ ");
INSERT INTO nit_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","అన్నె ప్రబుక్నె అమ్మ అన్నవై వత్తిన్ ఈ మాన్ ఇముంఙ్ రొబాడెంఙ్ అన్ తనెద్ క తాన్? ");
INSERT INTO nit_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","నీ సాలమ్ ఇడత్ లొల్లిన్ కెవ్వు వినెంఙ్ అన్నె పెట్టెత పోరక్ కుసినడ్ మెలగ్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ప్రబున్ వాలడ్ ఇడ్త గొట్టిక్ పూర కరే ఎద్దే ఇసా బరొస ఇట్ట పిల్ల ఎత్తె బాగ్యివతంద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","మల్ల మరియక్ ఇంతిన్ అన్నె ఆత్మ ప్రబున్ స్తుతి కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","అనుంఙ్ రక్సన సియ్త దెయ్యమ్ నత్తి అన్నె ఆత్మ అన్‍ ఒలెక దెయ్యం లోప కుసీ కలస నంసాద్ ");
INSERT INTO nit_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ఇతెతనట్ మన్కకెర్ అన్న దన్యురాలిందర్! దెయ్యం అద్నె రప్తిరాలె గారిబ్ మన్నున్ ఒరకిలతిన్ అని ఇండి తన్న సదర్ మన్క కెర్ అన్న బాగ్యివతంద్ ఇద్దర్! ");
INSERT INTO nit_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","పవిత్ర దెయ్యం తానుంఙ్ ఇంతె సదర్ సాలెక్ అనుంఙ్ కుబిదండి పన్ని కత్తిన్. అని అద్నె పేర్ పవిత్ర దెయ్యంద అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ఆని అదుంఙ్ మాన్ సియెకర్ సదర్ పడిక్లకెర్ పొయ్‍ కివ్ కలద్. ");
INSERT INTO nit_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","అమ్దు తన్నె కెయ్యులడ సక్తిత పనికున్ కతెంద్. అని తమ్మె మన్లున్ సియెకరె విసలున్ కలపదర్. ");
INSERT INTO nit_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","తాకత్ వల్లెలున్ ఔరె కుర్సి తన్న ఉర్కిపుత్న గరిబులున్ దండిక్ కత్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","అద్ కరువుత్ అనెకరున్ సోయ్త తినిప్తిన్ అని స్రిమంతకెరున్ రికమ్ పన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","అబ్రాహామున్ అమ్నె సంతానామున్ ఏపుడి కివ్ కత్ ఒలుత్, ఔరున్ అదికల్సాత్ ఇసా నేండె దొడలుంఙ్ గొట్టి సియ్తెతి, అముదు తన్నె సేవకినెకద్ ఇస్రాయేలుంఙ్ మదత్ కత్తెంద్. గడియకున్ ఇస్రాయేల్ నె పోరకెరుంఙ్ మదత్ కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","తానుంఙ్ ఇంతె సిమ్కన దిన ఔరున్ పొదె దయ కలత్ ఇసా నేండె దొడంద్ అబ్రాహామ్ అని ఆమ్నె గొట్టి తరున్ ఎప్పుడి అన్నెక కారనాడ్ ఓలుత్ ఔరున్ అదికలుత్ ఇసా నేడె దొడలే గొట్టి సియ్తెతి, అముదు తన్నె సేవక్ ఇన్నెకా. ");
INSERT INTO nit_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","మరియక్ ఆలిసిబాకున్ వెంట ముద్ది నెల అండిన్ మల్ల ఎల్లంఙ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","బాప్తిస్మ సియెకా యోహనె జన్మ మల్ల ఎలీజబెత్ ములంఙ్ సెరెక్ వేలఙ్ అద్ద ఒక్కొ పోరకున్ జాన్మ సియతిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","అని అద్నె మెరతర్ అని అద్నె చూట్ట ప్రబుంద్‍ అదుంఙ్ కత్త దండి దయన్ వింత్తెర్ అని అదున్ వెంట కుసీకత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","మల్ల అముదు పుటుత్ ఎన్మిది దినాలుంఙ్ ఔరు పోరక్నె సున్నతి కాలేంఙ్ వత్తెర్ అని అమ్నె బాంద్ జకర్యక్ పేర్ అమ్నుఙ్ ఇడెంఙ్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","గని అమ్నె అమ్మ ఇంతిన్ అనంఙ్ తోద్ సున్నతి కాయ్ దా ఆమ్నె పేర్ యోహాన్ ఇడెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","మల్ల ఔర్ అదున్ ఇంతెర్ ఇమ్నె కాలముత్ ఎరుంగి ఇటా పేర్ తొత్తిన్ తా. ");
INSERT INTO nit_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","మల్ల ఔర్ సైగ్స అమ్నె బానున్ ఇంతెర్ పోరకున్ తా పేర్ ఇడెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","అముదు ఒక్కొద్ వాయెక పట్టెన్ వెలుత్న వయ్‍తెంద్ పోరక్నె పేర్ యోహాన్. ఔర్ సదర్ కామల్‍ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","అపుడ్తద్ అపుడి అమ్నె జాబన్ ఓడ్తిన్ అని అంమ్నె నాల్‍క అట్టిన్ అని అముదు ముడెంఙ్ ఎద్దెంద్ అని దెయ్యముంఙ్ దన్యవదలు ఇడతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","మల్ల సెజరికుంఙ్ సదరుంఙ్ అర్రి వత్తిన్ అని ఇద్ద సదర్ గొట్టికున్ మెట్ పొదె అనెక్ సదర్ యూదు ఊలెంఙ్ నెరయ్‍తె. ");
INSERT INTO nit_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","గొట్టి వింతర్ సదర్ ప్రబు ఇదవున్ మన్నుత్ ఇడుత్ ఇన్తెర ఈ పోరక్ ఎట్టద్ ఎద్దద్ ఎర్ర? తానుంఙ్ ఇంతె దెయ్యం అమ్నున్ వెంట అండ్డిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","అని యోహనె బాంద్ జకర్యక్ పరిసుద్ద ఆత్మనడ్ నిండుత్న దెయ్యం అమ్నుఙ్ సియ్త గొట్టిన్ ఇడ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","ఇస్రాయేల్‍ దెయ్యం ప్రబునున్ స్తుతి కన్నెర్. తానుంఙ్ ఇంతె అద్ద తన్నె మందింఙ్ మదత్ ఇల్లుత్న సొడపెంఙ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","పేలెతనట్ తన్నె గడియాక్ ఎదా దావిద్నె పాడితంద్ నేడుంఙ్ సటీ రక్సక్ ఎనంఙ్ ఇడతిన్ అనాయ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","పేలెనిత కాలముత్ నేండున్‍ విరోద్ కలెకార్ అని నేండున్‍ కుర్కుర్ కలెకార్ కెయ్ తన నేండున్‍ సుటపెంఙ్ పవిత్ర ప్రవక్త కెర్ ఇసా ");
INSERT INTO nit_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","దెయ్యంన్నె తన్నె విరొదికున్ విరోద్ కత్న నేండున్‍ విరొదకలెకర్‍తన్న రక్స. ");
INSERT INTO nit_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","నేండె దొడలున్ పవిత్ర దెయ్యం కరార్ కత్న ఓలిపెకదుంఙ్‍ కివ్ కత్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","అని నేండె దొడంద్ అబ్రాహాముంఙ్ గొట్టి సియుత్ తన్నె కత్తా పరిసుద్ద కర్రున్ దెయ్యం అది కత్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","నేండె విరోద్లె కెయ్తన నేండున్‍ దెయ్యం సొడపెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","నేండె జిందగన్ లోపా సింకాన దినలుంన్ దెయ్యం ముండట్ పరిసుద్దనడ్, అని నీతినాడ అమ్నున్ ముండట్ అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","బాపు ఇన్నె సదరుంఙ్ పొదె అనెక దెయ్యంన్నె కబుర్లకెర్ ఇద్దర్. తానుంఙ్ ఇంతె నీ ప్రబుక్నె పావ్ తయార్ కలెంఙ్ ఇసా ఇమున్ ముండట్ సెరెకనివ్ అన్సతివ్. ");
INSERT INTO nit_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ప్రబుక్నె మన్కకెరుంఙ్ పాప్ లె మాప్ ఎరెకదుంఙ్ వలడ్ ఔరుంఙ్ రక్సన బదొల్ ఇన్ వలడ్ ఓర్కిపటిన్. ");
INSERT INTO nit_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","అమ్మె దెయ్యంన్నె దండి దయనడ్ అని కివడ్ అందకురియెక పొదలంఙ్ పరలోకంతన రక్సన వెలుంఙన్ పన్కసాద్. ");
INSERT INTO nit_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","యెరూసలేం లోప తిక్తనె నిడత్ ఉదుత్ అన్సర్ ఔరుంఙ్ వెల్గ్ సియెకదుంఙ్ అని నేండె గెట్టలె సాంతి మర్గముత్ అడిపెంఙ్ ఇసా సొబత దెయ్యమ్నె పొదె కుర్యుత్ వత్న సడున్ బెటిల్తినా. ");
INSERT INTO nit_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ఆ పోరక్ పెరుగుత్న దెయ్యమ్నె మదతున్ కాలన ఆత్మనాడ్ మజ్బుత్ ఎరస సెద్దెంద్ అని ఇస్రాయేల్ మన్కకెరుంఙ్ ఇడ్డెకా దిన వానంతెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ఆ దినాలుంఙ్ సదర్ దున్యంఙ్ మందింఙ్ రొమ సీజర్ అగస్తు ఒక్కొ ఉక్కుమ్ సితెంద్ అన్నె రాజ్యమున్ అన్నెకార్ సదర్ మన్కకెర్ ఎరెత్ ఔరు పేర్ నొందని కాలుర్. ");
INSERT INTO nit_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","కురెనియ సిరియ దేసెముంఙ్ రోమ రాజు అగస్తు అనెంఙ్ పేలె పేర్ నొందని కలెంఙ్ ఆడిప్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","అపుడ్ సదర్ మన్కకెర్ పేర్ నొందిపెంఙ్ ఎరె ఊరుంఙ్ ఔర్ సెద్దేర్. ");
INSERT INTO nit_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","యోసేప్‍ గలిలీయ నజరేత్ ఇనెకా ఊర్ తన యూదియ బేత్లెహేమ్ మంజె దావిద్ జన్మిలత నజరేతు ఊరుఙ్ సెద్దెంద్ ఇంతె దావిద్నె ఎల్లతద్ అని అమ్నె పాడితంద్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","అమ్మున్ వెంట సోయ్‍రిక్ కత్తె మరియకున్ వెంట అముదు నొందని కలెంఙ్ సెద్దెంద్. అద్ పెటెనడ్ అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","మల్ల ఔర్ అదె అనెంఙ్ మరియక్నెత్ ములంఙ్ సెరెక వేల వత్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","అద పేలె పోరకున్ ఎద్దిన్, అమ్నున్ జుఙ్ఙెలాడ్ గుడపుత్న కొడకత్ ఇట్టిన్. తానుంఙ్ ఇంతె ఔరుంఙ్ దర్మసాత్రం జాగ రొంబడెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ఆ ఊర్ మేరత కెండ్లత గొర్రెలకెర్ సింతె తమ్మె మందలున్ కయ్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","అని ఒక్కొ దూత్ ఔరుంఙ్ కండ్కెద్దిన్ అని ప్రబునె మహిమా ఔరుంఙ్ తిర్‍గొర తరియ్‍తిన్ మల్ల ఔర్ గుల్లెన అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ఆ దూత్ ఔరున్ ఇంతిన్ అర్సనెర్ సదర్ మందింఙ్ కుసి కాలెంఙ్ సోయ్త కబురున్‍ అన్ కొత్తన్ ఓలుర్. ");
INSERT INTO nit_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ఇనెడ్ దావిద్నె ఊరుఙ్ ఇముంఙ్ సటీ ఒక్కొద్ రక్స కలెకద్ జన్మిల్తెంద్ అమ్‍ది ప్రబు బత్కిపెక క్రీస్తుద్ ప్రబు. ");
INSERT INTO nit_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","అని ఇముంఙ్ ఒర్కి ఇంద్ద ఎనెద్ నీర్ జుఙ్ఙెలెంఙ్ గుడపుత్న కొడకత్ ఇట్ట పోరకున్ రొబపత్తిర్. ");
INSERT INTO nit_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","జాల్‍ది ఆ దూత్ వెంట పేలె పరలొకంత దూతు కండ్క ఎదె. అదవ్ దెయ్యమున్ స్తుతి కత్న ఇంతె ");
INSERT INTO nit_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","సదరుంఙ్ పొదె దెయ్యముంఙ్ మహిమ ఎకద్‍ మన్కకెరుంఙ్ బూమి పొయ్ సాంతి సమదాన్. అనెంఙ్! ఇసా దెయ్యముంఙ్ స్తుతికతేర్. ");
INSERT INTO nit_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","దూత్ ఔర్ తన పరలోకముంఙ్ సెద్దెవింత్తె గొర్రెలకెర్ ఒక్కొనెత్ ఒక్కొంద్ ఇన్నెర్ నేండుంఙ్ ప్రబుంద్ ఒర్కి సియ్త అదా ఎద్దెగొ గొట్టిన్ ఓలెంఙ్ బేత్లెహేమ్ సెన్నర్ సెద్దె. ");
INSERT INTO nit_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","అని ఔర్ జల్ది సెద్దెర్ మరియక్ కున్ అని యోసేపున్ అని కొడకత్ ఇట్ట పోరకున్ రొబప్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ఓలుత్న ఆ పోరకున్ బదోల్ దూత్ ఇడ్డత్ గొట్టికున్ ఔర్ మందిన్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","అని వింతర్ సదర్ మంది ఆ గొర్రెలకెర్ ఇడ్త గొట్టికున్ బదోల్ కమాల్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","గని మరియక్ ఇదాసదర్ గొట్టికున్ మన్నుత్ ఇడుత్ విచార్ కద్దర్. ");
INSERT INTO nit_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","గొర్రెలకెరుంఙ్ దూతు ఇడతెతి ఇసొబడ్ ఔర్ పావుత్ వింత గొట్టిన్ బదోల్ దెయ్యముంఙ్ మాన్ సియుత్న స్తుతి కత్న ఔర్ మలయుత్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ఎన్దీ దినాలుంఙ్ యేసునెత్ సున్నతి కలెంఙ్ అమ్నుంఙ్ యేసుక్ పేర్ ఇడ్తెర్. అద్ పేర్ అమునున్ జన్మిలెంఙ్ పేలె దూత్ సియ్త పేర్ అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","మల్ల కొన్ని దినాలడ్ మోసేనె నెకినాడ్ వేలంఙ్ కలెక్ దినమ్ వత్తిన్ ఆమ్నె బాంద్ అమ్మ యేసుకున్ సమర్పన్ కలెంఙ్ ఇసా యెరూసలేముంఙ్ ప్రబునె మందిరుంఙ్ కొస్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ఇంతె ప్రబునె నెకినె ఇసొబా పోరక్ ఎన్నెంద్ ఇసా ప్రబునే పవిత్ర దెయ్యం ఎన్నెమద్ ఇనెమ్. ");
INSERT INTO nit_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","బొరి పిట్టలె జొడి ఎన తోద్ తె ఇంది పారెవ పిట్టలె బావ్ సియెంఙ్ ఇసా ఔరు యేరుస్‍లెమ్త గుడింఙ్ కొస్తడెర్. తానుంఙ్ ఇంతె ప్రబునె ఇడ్ తా ఈ నెకి ప్రబునె స స్త్రాత్ ఇడ్త ఈ గోట్టిలంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","యెరూసలెమ్‍ లోప సుమెయోనను పేర్తంద్ ఒక్కొద్ అండెద్. ఆమ్ద నీతి ఇస్రాయే అడ్గిపెకనున్ ఆదార్ సటి దెయ్యం పన్కెక వేల్ఙంఙున్ పావ్ ఓల్నెద్ అని అమ్నున్ పొయ్ పరిసుద్ద ఆత్మ అడిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","క్రీస్తు ప్రబునె మన్ వలెన్ ఓలెంఙ్ పేలె అముదు తిక్కెద్ ఇసా పవిత్ర దెయ్యం నాడ్ అమ్నుంఙ్ ఓరకి అడిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","అని ఆత్మ అమ్నున్ ఇడతిన్ అముదు గుడింఙ్ వతెంద్. నెకినె ఇసొబాడ్ కాలెంఙ్ ఇసా అమ్నె బాంద్ అమ్మ గుడి లోప సిన్నం పోరక్ యేసునుంన్ తోడ వత్తెర్ ");
INSERT INTO nit_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","సిమియోన్ ఆ పోరకున్ తన్నె కెయ్యుత్ సుమ్ముత్ దెయ్యముంఙ్ దన్యవాద్ కత్ ఇంతెంద్; ");
INSERT INTO nit_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","ఎ ప్రబు ఇండి ఇన్నె గొట్టినాడ్ ఇన్నె గడియకున్ సాంతినడ్నీసెరెంఙ్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","సిమ్కన మందిఙ్ ఇన్ ఒర్కి పర్తె వెలంఙలంఙ్ ఇన్నె మందిన్ ముడట్ తయ్యర కత ఇన్నె రక్సనాన్ అన్ కడ్లడ్ ఓల్తన్. ఇంతె అన్నె కాడ్ల ఇన్ తనుంఙ్ ఓల్తె. ");
INSERT INTO nit_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","నీర్ సదర్ మందిన్ ముడట్‍ తయర్‍ కత్తదున్‍ ఆ తక్లిబున్ సదర్ మన్కకెర్ ఓలెంఙ్ ఇసా తయార్ కత్తివ ");
INSERT INTO nit_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","అముదు యూదులెర్సెటర్ పావ్ ఓలిపెంఙ్ ఇసా వేలాంఙ్ లాంఙ్ అండ్డద్ అని ఇన్నె ఇస్రాయేలుంఙ్ మహిమ మన్కకెర్ ముడట్ తయర కత్త ఇన్నె సాబడిపెకరన్ అన్ కడ్లడ్ ఒల్తన్ మాన్ రొంబాడద్ ");
INSERT INTO nit_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","అమ్మె బాంద్ అని అమ్మె అమ్మ యేసుకున్ బదోల్ ఇడ్డత్ ఈ గొట్టిన్ వింత్న కామల్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","సుమెయోనను ఔరుంఙ్ ఆసిర్వద్ సియుత్న అమ్మె అమ్మ మరియక్ ఇంతెంద్ ఓల్ ఇస్రాయేల్ లోప పెరెత్ మన్కకెరున్ తిక్తార్ బత్కసార్ అని విరోద్ ముడేకరుంఙ్ దెయ్యంన్నె సిన్న ఒర్కి ఎరెంఙ్ ఇసా ఇమ్‍దు ఆసతా పోరక్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ఇముంఙ్ వాలడ్ పేలెటర్ మన్కకెరె మంత విచార్ కురియద్ అని ఒక్కొ రుసి ఇన్నె పెట్టెలోపా సోఙ్‍తెతి ఆత్మ మెలగద్. ");
INSERT INTO nit_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","అత్తి అన్న పేరద్ ఒక్కొద్ సొయ్త ప్రవక్త రా అండిన్. అద్ అసేర్ పాడితంద్ పనుయెల్నె పిల్ల అండిన్. అద్నే పెండ్లి ఎత్న మాస వెంట ఏడ్ సల్కు బత్కతిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","అని ఎనబైనాల్గు సాల్కులద్ ఆండిన్. అద్ రెడెర గుడి సయుత్ సెరెద్ అని ఎపుడి అలెంఙ్ పతె ఉసార్ అర్సని గుడిత్ అన్తన ఉపాస్ పార్తన కల్సా సేవా కంద్. ");
INSERT INTO nit_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ఆ వెలంఙ్ ఆ ముర్తనాయ్ మెర వత్న దెయ్యముంఙ్ దన్యావద్ ఇడ్తిన్. అని యెరూసలెమ్ పట్నం లోపా దెయ్యంన్నె తరనుంఙ్ సటీ పవొలెక సదర్ మన్కకెరుంఙ్ అద్ అమున్ బదోల్ ఇడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","మల్ల ప్రబునె నెకినాడ్ సదర్ కత్తె యేసుక్నె అమ్మ బాంద్ గలిలీయ బర్సంఙ్ నజరేత్ మలయుత్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","అని అముదు పోరక్ దండి ఎద్దెంద్ అని తకద్తంద్ ఎద్దెన్ అని బుద్దినాడ్ నిండుత్ అండెద్. దెయ్యంన్నె దయ అమ్నున్ పొయ్ అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","మల్ల ఇనంఙ్ ఎద్దిన్ సాల్‍ సాలుంఙ్ అమ్నె బాంద్ అమ్మన్ వలడా అన్ పస్క పాండ్గుంన్ యెరూసలేముంఙ్ సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","అపుడ్ యేసుంద్ పన్నెండు సంవ్సరలద్ అన్నెంద్ పండ్గ నె రితినాడ్ ఔర్ అమ్నున్ కొత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","పండఙ్ ఎద్దినింతె ఔర్ మలయుత్ వరెంఙ్ బాలక్ యేసుంద్ యెరూసలెముత్తి అండెద్ అమ్నె అమ్మ బానుంఙ్ అద్ ఒర్కి తొతిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","మలయుత్ అమ్మె ఊరుఙ్ వరెకరున్ వెంట అంస్సద్ ఎర ఇసా ఔరు పొద్సెన్ అడక్స సెద్దెర్ అని తమ్మె మెరతర్ అని ఒర్కితరత్తి అమ్నున్ కిరవ్సా ఎరుసలెముంఙ్ మలయుత్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","అముదు కడ్కెరెతెంద్ అదుంఙ్‍ ఎత్తీ ఔర్ కిరవ్సా యెరూసలెముంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","మల్ల ఔర్ అమ్నున్ ముడొలుంఙ్ అమ్నున్ గుడిత్ రొబప్తెర్. అముదు దెయ్యంన్నె గొట్టిక్ కారపేకర్ వెంట ఉద్దుత్న ఔరె గొట్టికున్ వినెకనుంఙ్ అని ఔరున్ వెల్తొలేకనున్ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","అమ్మెత్ వినేకర్ సదర్ అమునున్ గియన్ అని జావబ్ సియెకాదున్ బదోల్ కామల్ కాన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","అమ్మె బాంద్ అమ్మ అమ్నున్ ఓలెంఙ్ గుల్ కామల్ కత్తిర్ అని అమ్మె అమ్మ అమ్నున్ ఇంతిన్ బపు తనుంఙ్ ఇనంఙ్ కతి ఓల్? అన్ అని అన్నె బాంద్ కుబ్ నరజడ్ ఇన్ కిరవదుమ్. ");
INSERT INTO nit_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","అముదు ఔరున్ ఇంతెంద్ తనుంఙ్ అన్నె కిరవ్తేర్. అన్ అన్నె బానే ఎల్లత్ అనెంఙ్ పాయీజె ఇసా ఇముంఙ్ ఒర్కి తోద్? ");
INSERT INTO nit_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","అముదు ఔరున్ వెంట ముట్టెంద్ అద్ గొట్టి ఔరుంఙ్ కారిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","అని అముదు ఔరున్ వెంట సెద్దెంద్ అని నజరేత్ ఊరుంఙ్ వత్న ఔర్ వెంట అండెద్. అమ్నె అమ్మ ఇద్ సదర్ గొట్టికున్ తన్నె మన్నుత్ అప్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","అని యేసుంద్ దండి ఎద్దెంద్ అని బుద్దినాడ్ అని దెయ్యంన్నె దయ నడ్‍ అని మన్కకెరె దయ నాడ్‍ పెర్గదద్ పొద్దున్ ");
INSERT INTO nit_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","తిబెరియస్ పెరకాద్ రొమ రాజు పద్రా సల్కు రాజ్ కత్తెదింతె పత పిలాతుక్ యూదులె రాజ అదికరి అండెద్. హేరోద్ గలిలీయత రాజక్ అండెద్ అమ్మె దాదక్ పిలిప్పు ఇతురియ అని తరొని ఈ బార్సల రాజక్ అండెద్ అని ఆ బిలిని బర్న లూసానియ రాజక్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","అన్నస్ మల్ల కయపక్ దండి దెయ్యలకెర్‍ అనెంఙ్ జకర్యక్ పోరక్ యోహాన్ వైరాన్ జాగత్ అనెంఙ్ దెయ్యంన్నె గొట్టి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","అని అముదు యోర్దన్ పేని మెర అన్నె సదర్ బర్సలెంఙ్ సెత్న ఇడ్నెంద్ ఇమ్మె పాప్ మాప్కల్ ఇసా మన్ బద్లిపెకాద్ అని బాప్తిస్మ బదొల్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","దెయ్యంన్నె గొట్టిక్ ఇడ్డెకా యెసయక్ నె పుస్తకుత్ ఇద్ గొట్టి వాయుత్ అంస్సద్ ప్రబునె పావ్ తయార్ కాలుర్. అమ్మె పవున్ సార్కక్ కలుర్ ఇనంఙ్ తెల్ల జాగత్ వాపొయ్స ఇడ్డెకనెత్ వనుక్ వారద్. ");
INSERT INTO nit_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","లొవ సదర్ పురద అని సదర్ మెట్ల అని డుబ్లె నెరయద్. మొడి పావ్ సార్కక్ ఎద్దద్ అని బర్గటె నుయుంఙ్ ఎద్దద్. ");
INSERT INTO nit_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","అని సదర్ సరీరాడ్ మన్కకెర్ దెయ్యంన్నె రక్సనాన్ ఓల్దర్. ");
INSERT INTO nit_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","అపుడ యోహాన్ తన్నతి బాప్తిస్మ యిర్ ఒడెంఙ్. వరెక మందిన్ ఇన్నెద్ ఊరుఙ్ సరాపొత్నె కొవ్వె లంఙ్ అనెక్ మన్కకెర్? వారెక్ రాగ్గ తనట్ కురియుత్ తులెంఙ్ ఇసా ఎద ఉసర్ కతెద్? ");
INSERT INTO nit_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ఇమ్మె పాపులున్ మన్ బద్లిపెకాద్‍ ఓలిపెంఙ్ సటీ సోయ్త పనిక్ కాలుర్ అని అబ్రాహామ్ అమ్మె బాంద్ ఆసాద్ అమ్ మరొక్కొరుంఙ్ ఎన సోయ్ అసతుమ్ ఇనంఙ్ ఇమ్మె మన్ లోప విచార్ కానెర్. తానుంఙ్ ఇంతె ఈ గుండ్లతన్న అబ్రాహాముంఙ్ పోరకేర్ బనాపెంఙ్ దెయ్యం సాల్‍సద ");
INSERT INTO nit_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ఇడి మక్నె మొదలుత్ గొల్లి అన్సాద్. అదుంఙ్ సటీ సోయ్ కయ్యసెట్ మాక్ కున్ కత్కుత్న కిసుత్ జొపిడ సార్. ");
INSERT INTO nit_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","అపుడ్ మన్కకెర్ అమ్నున్ వెలుతొల్తెర్ ఇండి హమ్ తా గాదుమ్‍ ఇంతెర్? ");
INSERT INTO nit_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","అముదు అవ్రున ఇంతెంద్ ఎరత్తి ఇంది జుఙ్ఙె అసాహ అముదు తోసెటనుంఙ్ ఒక్కొద్ సియెంఙ్ అని ఎరత్తి అంబ్బలంసాద్ అంనాయ్ పయెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","నాక వలెనయ్ బాప్తిస్మ సుమెంఙ్ వత్తెర్ అని అమ్నున్ వెలుత్‍ ఓల్‍నెర్ ప్రబు అమ్ తాగద్దుమ్? ");
INSERT INTO nit_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","అముదు ఔరున్ ఇంతెంద్ ఇముంఙ్ ఎంతె వసులి కలెంఙ్ ఇడ్‍తెర్ అదుంఙ్ జాస్తి కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","సైనిక్‍నయ్ అమ్మున్ వెల్తొల్నెర్? అమ్ తాగద్దుమ్? అముదు ఔరున్ ఇంతెంద్. జాబర్ దస్తినాడ్ తోద్ వాటి అగమి ఆరొప్ లయుపుత్న ఎరేవుని లుటిప్నెర్ అమ్మె జీతమ్ అముంఙ్ ఎర్‍సద్ ఇడ్ర. ");
INSERT INTO nit_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","అని క్రీస్తుంద్ దెయ్యంన్నె మంతనున్ పావ్‍ ఓల్స అన్నెర్ యోహాన్ బదోల్ ఇంద్ దెయ్యంన్నె మన్‍వలె ఎన్నెంద్ ఎర ఇసా సదర్ మన్కకెర్ ఔరె మన్నుత్ విచార్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","యోహాన్ ఔర్ సదరున్ ఇంతెంద్ అన్ ఇముంఙ్ ఇరాడ్ బాప్తిస్మ సియ్‍సత్‍ గని అనుంఙ్ ఎనా కుబ్ సక్తితంద్ ఒక్కొద్ వర్సన్సాద్. అమ్మె కెర్రి త పట్టన్నాయ్ పుసెకదుంఙ్ అన్ పనితరన్ తోతెన్. అముదు ఇముంఙ్ పరిసుద్ద ఆత్మనాడ అని కిసాడ పవిత్ర కల్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","గొద్మ అసెకద్ లంఙ్ దెయ్యం అన్సాద్. అదనే కేత్ అద్నె కేయ్యుత్ అన్సాద్. అద అద్నె కలవె తవున్ సోయ్‍ అయ్యుత్న గొద్మలున్ మిరపుత్న అద్నె గుమ్మిత్ వాఙద్. గని పొట్టున్ బూడున్ కిట్‍సెటహ కిసుత్ కిసిడద్. ");
INSERT INTO nit_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","అని అముదు ఇడత పేలె గొట్టిక్ లాడ్ బుద్ది ఇడుత్న మందింఙ్ వింతి కత్నసోయ్త గొట్టిక్ ఇడతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","గని హేరోద్ రాజక్నె దాదక్ కొర్ర హేరోదియ రాల్ గురించి అని ఎరొద కత్త సదరి కబుర్ పనిక్ వాలడ్ యోహన అమ్నున్ సెయుత్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ఎరొద్ ఇద పనికుంఙ్ జాస్తి ఒక్కొ పని కతెంద్ యోహానున్ జేలుత్ తప్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","మల్ల ఇనంఙ్ ఎద్దిన్ సదర్ మన్కకెర్ పవిత్ర యి ర్ ఓట్టెర్ బాప్తిస్మ సుమ్‍తెద్. యేసుంద్ నాయ్ పవిత్ర యిర్ ఒడుత్న పార్తన కల్స అనెంఙ్ ఆబార్ పయ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","అని పరిసుద్ద ఆత్మ పారెవనె రూపాడ్ అమ్నున్ లాడ్ డిగ్తిన్ అని పరలోకంత దెయ్యం నాత్తన విన్క వత్తిన. నివ అన్నె లాడ్త పోరక్ ఎన్ని ఇన్ బదోల్ అనుంఙ్ కుసీ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","యేసుంద్ తన్నె సిసులున్ నివ్డిపెంఙ్ అముదు కామ్మి జాస్తి ముపై సాల్కులాంద్ అండెంద్; అముదు యోసేప్నె పోరక్ ఇనంఙ్ సమ్జిల్‍తెర్. ఇమ్‌ద యోసేప్ హేలీక్నె పోరక్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","హేలీ మత్తతుక్నె పోరక్. మత్తతు లేవినె పోరక్. లేవి మెల్కీనె పోరక్; మెల్కీనె యన్నాయక్నె పోరక్; యన్నాయక్ యోసేపక్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","యోసేపక్ మత్తతీయక్నె పోరక్; మత్తతీయ ఆమొస్నె పోరక్; ఆమొస్ నహోమునె పోరక్; నహోము ఎస్లినె పోరక్; ఎస్లి నగ్గయినె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","నగ్గయి మయతుక్నె పోరక్; మయతుక్ మత్తతీనె పోరక్; మత్తతీ సిమియక్నె పోరక్; సిమియ యోసేనె పోరక్; యోసేక్ యోదానే పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","యోదా యొహన్నానె పోరక్; యొహన్నా రెసానె పోరక్; రెసా జెరుబ్బాబెల్‍నె పోరక్; జెరుబ్బాబెలు సాయల్తియెల్నె పోరక్; సాయల్తియెల్ నెరినే పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","నెరి మెల్కినె పోరక్; మెల్కి అదినె పోరక్; ఆది కొసామ్‍నె పోరక్; కొసామ్ ఎల్మదాక్నె పోరక్; ఎల్మదాక్ ఏరునె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ఏరు యెహోసువనె పోరక్; యెహోసువ ఎలీయెజెర్నె పోరక్; ఎలీయెజెర్ యోరినె పోరక్; యోరి మత్తతుక్నె పోరక్; మత్తతుక్ లేవినే పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","లెవి సీమియోన్నె పోరక్; సీమియోన్ యూదక్నె పోరక్; యూదాక్ యోసేప్నె పోరక్; యోసేప్ యోనామ్నె పోరక్; యోనామ్ ఎల్యాకిమ్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ఎల్యాకిమ్ మెల్యాక్నె పోరక్; మెల్యాక్ మెన్నాక్నె పోరక్; మెన్నా మత్తకునె పోరక్; మత్తకు నా తాన్నె పోరక్; నాతాన్ దావిద్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","దావిద్ యెసయక్నె పోరక్; యెసయక్ ఓబెద్నె పోరక్; ఓబేద్‍ బోయజునె పోరక్; బోయజు సల్మోనునె పోరక్; సల్మోను నయస్సోనునె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","నయస్సోను అమ్మీనాదాబునె పోరక్, అమ్మీనాదాబు ఆదమినె పోరక్; ఆదమి ఆరామునె పోరక్; ఆరాము ఎస్రోమునె పోరక్, ఎస్రోము పెరేసునె పోరక్; పెరేసు యూదాక్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","యూదక్నె యాకోబ్నె పోరక్; యాకోబ్‍ ఇస్సాక్‍నె పోరక్; ఇస్సాక్‍ అబ్రాహామ్నె పోరక్; అబ్రాహామ్ తెరహునె పోరక్; నాహోరు ");
INSERT INTO nit_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","తెరహు నాహోరునె పోరక్; నాహోరు సెరూక్నె పోరక్; సెరూక్ రయ్యునె పోరక్; రయ్యు పేలెగునె పోరక్; పెలరగు హెబెరునె పోరక్; హెబెరు సెలహుక్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","సెతు కెయినాక్నె పోరక్; కెయినాకు అర్పక్సదునె పోరక్; అర్పక్సదు సేముక్నె పోరక్; సేము నొవక్నె పోరక్; నోవ లెమెక్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","లెమెక్ మతుసేలునె పోరక్; మతుసేలు హనోక్నె పోరక్; హనోక్ యెరెదునె పోరక్; యెరెదు మహలయేలునే పోరక్; మహలయేలు కెయినాకు పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","కెయినాకు ఏనోసునె పోరక్; ఏనోసు సేతునె పోరక్; సేతు అదామ్నె పోరక్; ఆదామ్ దెయ్యమ్నె పోరక్; ");
INSERT INTO nit_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","యేసుద పరిసుద్దత్మన్ నిండుత్న యోర్దన్ నుంఙ్ మలయుత్ వతెంద్. ఆత్మ అమ్నున్ బట్టి వై పవింటిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","సాలిస్ దిన సైతన్ అమ్నున్ పరిక్స ఓల్‍తిన్. ఆ దినాలుంఙ్ అముదు తనయ్ తినెతెంద్ ఆ దినం ఎద్దతి అమ్నుంఙ్ కారువు వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","అపుడ్ సైతన్ అమ్నున్ ఇంతిన్ నీ దెయ్యమ్నె పోరక్ ఎన్నివ్ ఎర్రతె ఈ గుండ్‍లున్ నిపట్టె ఎర్‍గల్. ఆగ్య సియ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","యేసుంద్ ఇంతెంద్ మన్కక్ బత్కెకదుంఙ్ వట్టి నిపట్టెనాడ్ తోద్ గని నియమ్ సాస్రముత్ వాయుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","పెన సైతన్ అమ్నున్ డుబ్లెంఙ్ కొస్తిన్ అని సదర్ దున్యంఙ్ రాజ్యం అమ్నుంఙ్ ఒక్కొ గట్కతి ఓలిప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","అని అమ్నున్ ఇంతిన్ సదర్ అదికార్ అని అదావ్లె, సొబాన్ పూర అన్ ఇనుంఙ్ సియుత్. సైతన్ ఇంతె అదహ అనుంఙ్ సియుత్ అంసాహ అదవున్ ఎరుంఙ్ సియెంఙ్ అన్నె మన్‍ ముడ్సద అమ్నుంఙ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","అదుంఙ్ ఎత్తి నీ అన్నే గెట్టలున్ కాల్‍ మొక్తి వింతె ఇనుంఙ్ ఎద్దహ. ");
INSERT INTO nit_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","యేసుంద్ ఇంతెంద్ ప్రబున్ ఇన్నె దెయ్యమ్నె కాల్‍కు మొక్కెంఙ్ అని అమ్నెతి సేవ నీ కలెంఙ్ ఇనంఙ్ నియమ్ సాస్రముత్ వాయుత్ అన్సాద్ తా. ");
INSERT INTO nit_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","మల్ల అద యేసుకున్ యెరూసలెముంఙ్ కొస్తిన్ అని గుడిత జుట్టి పొదె ఇల్పతిన్ అని అమ్నున్ ఇంతిన్ నీ దెయ్యమ్నె పోరక్ ఎన్నివెరతె ఇత్రనట్ బూడున్ ఉర్కు? ");
INSERT INTO nit_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ఇనంఙ్ వాయుత్ అండాద్ తా అముదు ఇనుంఙ్ కాపాడెంఙ్‍ ఇసా ఇనుంఙ్ వాలడ్ తన్నె దూత్ లున్ ఆగ్య సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","తానుంఙ్ ఇంతె నియమ్ సాస్రముత్ ఇనంఙ్ వాయుత్ అంసాద తానుంఙ్ ఇంతె ఇన్నె. దెయ్యం తన్నె దూతులున్ ఉకుంమ్ సియద అని ఇన్నె గెట్టలున్ గుడ్ గిన తక్‍గల్సెట్ అదా ఇన్న కెయుత్ సుమ్‍దా. ");
INSERT INTO nit_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","యేసుంద్ అమ్నున్ ఇంతెంద్ నీ ఇన్నె దెయ్యం ప్రబునున్ పరిక్స ఓల్‍నెమ్ ఇనంఙ్ సస్రత్ ఇడ్సద త. ");
INSERT INTO nit_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","మల్ల కొన్నీ దినాలుంఙ్ సైతన్ సిమ్కన పరిక్స తిర్తత్తి కొన్ని గొల్‍ అమ్నున్ సాయుత్న సెదిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","మల్ల యేసుంద్ పవిత్ర ఆత్మనె తాకతడ్ నిండుత్న గలిలీయ బార్ సంఙ్ మలయుత్ వత్తెద. అమ్నున్ బదోల్ తిర్‍గొరా అనెక సదర్ ఊల్లెంఙ్ కబుర్ ఓరికి ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","అముదు యూదులె సావ్డిత్ కారప్‍నెద్. అని సదర్ మన్కకెర్ అమ్నుఙ్ మాన్ సియ్యేకద్. ");
INSERT INTO nit_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","మల్ల తన్ దండి ఎద్ద నజరేత్ ఊరుఙ్ అముదు వతెంద్ అని ఎపుడితెత్తి అముదు కాన్నెద్ అనాయ్ ఆలపుసేక జీర్ యూదులె సావ్డిఙ్ సెత్న బైబిల్ వసిపెంఙ్ ముదర్వై ఇల్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","అమ్నుంఙ్ సందెసం సియెక యెసయక్ కబుర్ల పుస్తక్. అముదు అమ్నె పుస్తక్. అత్తి అమ్నుంఙ్ ఇనంఙ్ వయ్‍తద్ రొబాట్టిన్ ");
INSERT INTO nit_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","ప్రబునె ఆత్మ అన్‍పొయ్ అండద్ గరిబులుంఙ్ సోయ్త గొట్టి ఇడ్డెంఙ్ అన్ అబిసేకం కత్తెద్ అని కొడాల్త మన్కకెరున్ కురియెంఙ్ ఇసా లొల్లికలె ఇసా గుడ్డికున్ మన్కకెరుంఙ్ నదుర్ సియెఇసా దబిల్త మన్కకెరుంఙ్ ఇసా. ");
INSERT INTO nit_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ప్రబున్ అద్నె మన్కకెరుంఙ్ సొడపెక దినామ్ వత్తినిసా ఇడ్డెంఙ్ సటీ దెయ్యం అన్‍పన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","మల్ల అముదు తొలుత్ వయ్త పుస్తకున్ గడ్పుత్నా ఇట్టెంద్ అని అముదు. యూదులె సావ్డితా కబులకుంఙ్ సితెంద్ అని కుత్‍తెంద్ సవ్డిత అనెక మన్కకెరె కడ్లున్ సిమ్కన అమ్నున్‍వై ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","మల్ల అముదు ఔరున్ ఇనంఙ్ ఇడ్త; ఇనెడ్ నీర్ వింత ఇదా సాస్త్ర తా లేకనమ్‍ కారె ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","సిమ్కన మన్కకెర్ అమ్నున్ బదోల్ సోయ్ ఇడ్నెర్ అని అమ్నె మూతి తాన కురియెక కృప గొట్టిక్ బదోల్ కమల్ కన్నెర్ అని ఇన్నెర్; ఇంద్ యోసేప్నె పొఒరక్ ఎన్నెన్‍త. ");
INSERT INTO nit_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","పెనా యేసుంద్ ఔరున్ ఇంతెంద్; మంద్దులకెర్ ఇన్నెతున్ నీ సోయ్‍కల్ ఇనెక ఉదహరన నీర్ అనుంఙ్ కరె ఇడ్సాతిర్ అని కపర్న ఊరుత్ అనాన్ తనెద్ కత్తనిసా నీర్ వింతిర్ అదవ్లున్ ఇంతినా తన్నె సొత ఉర్నాయ్ కాల్‍ఇందతివ్. ");
INSERT INTO nit_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","మల్ల అముదు ఇంతెంద్; కరెయ్ అన్ ఇముంఙ్ ఇడ్సాత్ దెయ్యమ్నె గొట్టిక్ ఇడ్డెకనుంఙ్ అమ్నె సొతా ఊరున్ మన్ రొంబాడెద్. ");
INSERT INTO nit_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","తనుంఙ్ ఇంన్తె సత్తెం అన్ ఇముంఙ్ ఇడ్సాత్; ఏలీయాక్నె దినాలుంఙ్ సడెమూంది సాల్‍కు ఆబారెత్ వాన వరెతిన్ సిమ్కన ఇస్రాయేల్ దేసెముంఙ్ దండి దుస్కడ్ వత్తండిన్ సిమ్మన రాండెరసిక్ అండెనాయ్. ");
INSERT INTO nit_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","దెయ్యం ఏలీయాకున్ పనుక్తిన్ గని మరొక్కొదుంవై పన్కెతిన్. సిదొంత దేసెంత సారెపతు ఇనెక ఊరుత్‍ అనెక్ ఒక్కొ రడెరా పిల్లన్‍ వై పన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","అనాయ్ సందేస్ ఇడ్డెకంద్ ఎలీసా ప్రవక్తకెరె కాలముత్‍ ఇస్రాయేల్‍ లోప పెర్‍దుకమ్ తార్ పేలెటర్ అన్నెర్ ఎనా ఔర్ ఎరి సోయ్ ఎరెతెర్ గని సిరియా దేసంతన నయమాను ఒక్కొంది మాత్రం సోయ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","అదున్న వింత్న యూదులె సావ్డి మిరయ్తర్ సిమ్కన రగ్గున్ వత్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ఔర్ సులుత్న అమ్నున్ ఉర్ వాక పుస్తెర్ అని ఔరె ఉరున్ అనెక మెట్త జుటింఙ్ కొస్తెర్ అని అత్తరనాట్ డగ్లిపెంఙ్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","గని అముదు ఔరున్ తన కురియూత్‍ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","మల్ల అముదు గలిలీయత కపర్న ఊరుఙ్ సెద్దెంద్ ఆలపుసేక జీర్ అముదు మన్కకెరున్ కరపెంఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","అని ఔర్ అమ్నె కరపెంకదును కమల్ కాన్నెర్ తానుంఙ్ ఇంతె అమ్నె గొట్టి అదికారడ్ అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ఆ యూదులె సావ్డిత్ అపవిత్ర ఆత్మ ఒక్కొద్ అండెద్. అముదు గుల్ జోరనాట్ వపొయ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","ఎ నజరేత్ యేసు అమత్తి ఇనుంఙ్ తనెద్ ఆసాద్? నీ ఎంద్ ఎన్ని అద్ద అముంఙ్ ఒరికి ఆసాద్ నీ దెయ్యమ్నె పవిత్ర దెయ్యం ఎన్ని. ");
INSERT INTO nit_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","గని యేసుంద్ అమ్నున్ దట్టిపుత్న ఇంతెద్: సురుమ్ అన్ ఇమ్నతన్ కురుయుత్నఅ బూత్ అమ్నును లోప. అదుఙి యేసుంద్ నీ సురుమ అండీ జొపిడుత్ అమ్నతన కురియెతిన్ అని అమ్నుంఙ్ తనయ్ మర్ పొద్దెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ఔర్ సిమ్కన కమల్ కతెర్ అని ఒక్కొనెత ఒక్కొద్ ఇసర్: ఇద్ద తనెద్ గొట్టి ఎందె. అదికార్ అని తాకతడ్ ఇమ్‌ద ఈ బూతులును ఉక్కుమ్ సియ్‍సాంద్ అని అదా కురియుత్ తుల్సా. ");
INSERT INTO nit_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","అని అమ్నున్ బదోల్ తిర్గొర అనెక ఊల్లెంఙ్ ఓరకి ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","అముదు సుల్తెంద్ అని యూదులె సావ్డి తన కురుయుత్న సీమోన్‍నె ఎల్లంఙ్ సెద్దెంద్ అత్తి సీమోన్‍నె పొద్ గుల్ వెస్సనాడ్ అండిన్ అని ఔర్ అదుంఙ్ సట్టి అమ్నున్ వింతి కల్సర్. ");
INSERT INTO nit_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","మల్ల అముదు అద్నేతల్లమెర ఇల్లుత్నవెస్సన్ దట్టిప్తెంద్ అనివెస్స అదున్ తన కురితీన్‍ అని జల్దీ అద్‍ సూలుత్‍నా అవ్రే సేవ కలేంఙ్ ఎద్దీన్‍. ");
INSERT INTO nit_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","పొద్ ఊరుక్‍తత్తీ మన్కకెర్‍ రంఙ్‍ రంఙ్త దుక్కలకేర్ సిమ్‍కానా యేసున్‍వై కొత్తేర్‍ అని మల్లా అముదు ఒక్కొనెత్ ఒక్కొన్ ‍ పోయ్ కెయ్యులిడూత్‍ అముదు ఔరున్‍ సోయ్కత్తేంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","బూత్‍నాయి పెర్రెత్ మన్కకేరుంఙ్ తన కుర్యుత్ సెద్దిన్. నీ దెయ్యమ్నె పోరక్‍ ఎన్నివిసా వాపొయ్తాన్‍ అదా కురియుత్ సెన్నే గని అముదు అదవున్‍ దట్టిపుత్నా ముడేంఙ్ ఇడేతేంద్‍ తానుంఙ్ ఇంతే క్రీస్తు ఇన్నే సిమ్మనతద్‍ ఎన్నేంద్‍ ఇసా అదావుంఙ్‍ ఒర్‍కీఅండీన్‍. ");
INSERT INTO nit_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","కొర్కూతంఙ్‍ అముదు మన్కకెర్‍ తోసెటా జాగాంఙ్‍ సెద్దేంద్. మన్కకెర్‍ అమ్నూన్‍ కిరావ్‍నేర్‍ అని అమ్నూన్‍ వాయివత్నా అముదు సెరేకనూన్‍ ఇలప్‍నేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","గని అముదు ఔరున్ ఇంతేద్ మారొక్కో ఊల్లకెరూంఙ్‍ నాయి అన్ దెయ్యమ్నె రాజ్యం ఎద్దావ్‍ బదోల్‍ సోయ్త గొట్టి ఇడ్డేకాద్‍ అన్సాంద్‍. అదుంఙ్‍ ఎత్తీ అన్‍ పన్కుత్‍ అన్‍సాతూన్‍. ");
INSERT INTO nit_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","మల్ల అముదు యూదులె సావ్డిత్ గొట్టిక్‍ ఇడ్స వత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","మల్ల ఇనంఙ్‍ ఎద్దీన్ మందీ దెయ్యమ్నె గొట్టీన్‍ వినెంఙ్‍ అమ్‍నూన్‍ మేరమ్‍ గర్‍దీ కలెంఙా అముదు గెన్నేసరేత్ సం‍దూర్ దర్డీత్‍ ఇల్లూత్నా అన్నేంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","అముదు సందూర్‍ మెరా ఇల్లూత్‍ అనెకా ఇందీ రూకూలూంఙ్‍ ఒల్‍ తెంద్. గని కయ్యేలకేర్‍ రూక్‍ తన డిగ్గూత్‍ తమ్మే జాల్లున్ ఓడ్‍నేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","అముదు ఒక్కో రూకుత్ ఉత్తేంద్‍ అదా సీమోన్‍నె రూకేంద్‍. యేసుంద్‍ ఆ రూకున్ డర్డితన ఉసూటే డగ్లీపేంఙ్‍ వింతి కల్సీమోనున్ ఇడ్‍తేంద్ అని అముదు రూకుత్ ఉద్దూత్నా మన్కకేరుంఙ్ కరప్‍నేంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","అముదు‍ గొట్టిక్‍ ఇడ్తేంద్‍ ఇంతే సీమోనున్ ఇంతేంద్‍ గుండివాయ్‍ తోడాసెమ్‍ అని ఇమ్మే జాల్లున్ కయ్యేసుమ్మేంఙ్‍ ఒగ్గు. ");
INSERT INTO nit_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","సీమోన్ ఇంతేంద్ గురు నిండ్లాలే ఆమ్‍ కొంచెమ్‍ కస్టేమ్‍ కత్తామ్‍ అమూంఙ్‍ తానాయ్‍ కయ్యే రొంబాడెతే గని ఇన్నె గొట్టిన్ ఆమ్‍ జాల్లున్ ఒగ్‍సాతూమ్‍ ఇంత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ఔర్ అనాయ్‍ కత్తెర్‍ అని గుల్ పేలె కయ్యె పట్టే అని జాల్‍ ఇరియేంఙ్‍ ఎద్దే. ");
INSERT INTO nit_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","మారొక్కో రూక్ తా మన్కకెర్ వత్నా సంఙెరేంఙ్‍ ఇసా అవురూన్ కైతేర్‍. ఔర్‍ వత్తేర్‍ అని అదా ఇందిగ్నా రూకు ములుంఙ్నంతేంఙ్ కయ్యె నిడ్పతే. ");
INSERT INTO nit_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","సీమోన్‍ పేతురుక్ అమ్నూన్‍ ఓలుత్‍నా యేసునే కాల్‍కూ మొక్కుత్నా ఇన్తెంద్ ప్రబు అన్‍ సాయుత్‍ సే తానుంఙ్ ఇంతే అన్‍ పాప్ మన్కక్ అన్సాత్‍. ");
INSERT INTO nit_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","తానుంఙ్ ఇంతే అముదు‍ అని అమ్నూన్‍ వెంటతార్‍ సిమ్కన ఔరు సుమ్త పెల్లే కయ్యెలె డెగ్గున్ ఓలుత్‍ గుల్లేనా కమాల్‍ కత్తర్‍. ");
INSERT INTO nit_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","సీమోన్‍నె సంఙ్తకేర్ యాకోబ్‍ ని యోహాన్ నై అదూన్‍ బదోల్‍ కమాల్‍ కత్తెర్‍ ఇవ్రు జెబెదయక్నె పోరకేర్‍ ఎన్నేర్‍. యేసుంద్‍ సీమోనున్ ఇంతేద్‍ నీ అర్సనెమ్‍. ఇండితన నీ మన్కకేరూంన్‍ సుమ్మేకనీ ఎరాత్తీ. ");
INSERT INTO nit_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ఔర్ రూకులున్ డర్డింఙ్ తోడా వత్తె అదవున్ సాయుత్న. ");
INSERT INTO nit_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","మల్ల ఇనంఙ్ ఎద్దిన్ అముదు ఒక్కొ పట్నముత్ అనేంగ పెర్ దుక్క నిండుత్ అనెకద్ ఒక్కొద్ వతెంద్ అని అముదు ప్రబునున్ ఓలుత్ యేసునె కాల్‍కు మొక్తెంద్ అని వింతి కతెంద్; ప్రబు ఇనుంఙ్ మన్ అండిన్ ఇంతె నీ అన్నె సోయ్ కాలెంఙ్ సాల్సతి. ");
INSERT INTO nit_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","మల్ల యేసుంద్ కెయ్యున్ సాపుత్న అమ్నున్ తక్తెంద్ అని ఇంతెంద్ అనుంఙ్ మన్ అన్సాద్. సామ ఎరా జల్ది అమ్మె పెర్‍దుకమ్ సోయ్ ఎద్దిన్ ");
INSERT INTO nit_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","యేసుంద్ అమ్నున్ అర్పులిపుత్ ఇంతెంద్ ఎరుంఙ్ ఇడ్ నెమ్ గని సె అని దెయ్యలకెరున్ సాక్సం వేలంఙ్ కలెంఙ్ ఇసా మోసేనె నెకినాడ్ ఎద్ బావుసియెకాద్ అన్సాద్ అదవున్ సదర్ మన్కకెరుంఙ్ పురవ ఇసా సియ్. ");
INSERT INTO nit_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ఎనా యేసునున్ బదోల్ ఇంకా జాస్తి లొల్లి ఎద్దిన్. అమ్మెత్ వినెంఙ్ అని తమ్మె దుక్క తనట్ సోయ్ ఎర్రెంఙ్ ఇసా గుల్ పెల్లెటార్ మన్కకెర్ మిరయుత్న వన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","గని యేసుంద్ ఎపుడ్ అపుడ్ ఔరున్ సాయుత్న ఏరి తోసెట జాగాంఙ్ సెంనెద్ అని పార్తన కన్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","మరొక్కొ దినం ప్రబుద్ కారప్స అనెంహా గలిలీయ అని యూదులె, బార్సలా ఊర్తన అని యెరూసలేమ్ పట్నం తన వాత్ పరుసి మన్కకెర్ అని నియం సాస్త్రి మన్కకెర్ ఉదుత్ అండెర్. మన్కకెర్ దుక్క తన ఔరున్ సోయ్ కాలెంఙ్ దెయ్యమ్నె తాకత్ అమ్మున్ వెంటా అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","అపుడ్ కొన్సెం మంది మన్కకెర్ ఒక్కొ కుంటిన్ తెరుత్ తోడ వత్తెర్. ఔర్ అమ్నున్ ఎల్ల లోపా కొసుత్ యేసుకున్ ముండట్ ఇడెంఙ్ ఓల్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","గని పెరెత్ మంది అండెర్ అదుంఙ్ ఎతి అమ్నున్ ఎల్ల లోప కొసెంఙ్ సలెతెర్ అదుంఙ్ ఎతి ఔర్ యేసుంద్ అన్నెద్ ఆ ఎల్ల పొయ్ సొక్కుత్న కౌలాన్ పుసుత్న కుంటిన్ తెర్ కలపి మన్కకెర్ నడుమున్ యేసున్ ముండట్ డింప్ తెర్. ");
INSERT INTO nit_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","అముదు ఔరె విస్వాసమున్ ఓలుత్న కుంటిన్ ఇంతెంద్ దదా ఇన్నె పాప్ మాప్కల్. ");
INSERT INTO nit_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","పరుసి మన్కెకెర్ అని సాస్త్రి మన్కకెర్ తమ్మె మనుత్ ఇనంఙ్ విచార్ కలెంఙ్ ఎద్దెర్ దెయ్యంన్నె బద్నం కలెకద్ ఇంద్ ఎద్ ఎన్నెంద్ దెయ్యముంఙ్ సివమ్ ఎద్ది పాప్ మాప్కల్. ");
INSERT INTO nit_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","యేసుంద్ ఔరె విచారున్ ఒర్కిలుత్న ఔరున్ ఇంతెంద్ తనుంఙ్ ఇమ్మె మన్నుత్ విచార్ కల్‍సతిర్. ");
INSERT INTO nit_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ఎద్ సోయ్ అన్సాద్ ఇన్నె పాప్ మాప్కల్ ఇనెకదా సులుత్ అడగ్ ఇనెకద్ సొయ. ");
INSERT INTO nit_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ఇంత్తె మన్కనె పోరక్ బూమి పొదె పాపులున్ మాప్ కలెకా అదికార్ అన్సాదిసా నిర్ ఓర్కిలెంఙ్ ఇంతేద్. మల్ల లుంలకున్ ఒలుత్న, “సులుత్, ఇన్నె తెరున్ సుముత్ ఎల్లంఙ్ సే” ఇంతేద్. ");
INSERT INTO nit_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","అపుడ్‍తద్ అపుడి ఔరున్ ముండట్ అముదు సుల్తెంద్ అని అముదు ఇంతెంద్ మడియుత్ అనెకా తెరున్ పెతుత్న దెయ్యమున్ స్తుతి కల్‍సా ఎల్లంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ఔర్ సదార్ కామాల్ ఎద్దేర్ అని దెయ్యమున్ మన్ స్తుతి కత్తెర్. ఔర్ దెయ్యమున్ అర్సుత్ ఇంతెంద్ మరొక్కొ గొట్టికున్ అమ్ ఇనెడ్ ఓల్‍తమ్. ");
INSERT INTO nit_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","మల్ల యేసునె ఎల్ల తన కురియెతెంద్ అని లేవి పేర్ కంద్ నాక వలెన్ నాక జగత్ ఉద్దుత్ అనెకనున్ ఓల్‍తెంద్ అమ్నున్ ఇంతెంద్ అన్ వెంటా వా. ");
INSERT INTO nit_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","అని లెవి సింకాన సాయుత్నా సుల్‍తెంద్ అని అమ్నున్ వెంటా సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","లేవి తాన్నె ఎల్లత్ గుల్ దండి జెవున్ యేసునుంఙ్‍ కతెంద్ అని పేలెటర్ నాక వలె అని మరొక్కొర్ ఔరున్ వెంట తినెంఙ్‍ ఉదుత్ అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","అపుడ్‍ పరుసి మన్కకెర్ అని సాస్త్రి మన్కకెర్ అమ్నె సిసులత్తి కుర్‍కుర్ కతన్న ఇన్నెర్ తనుంఙ్‍ నీర్ నాక వలె అని పాప్ మన్కకెర్ వెంట తినెంఙ్‍ ఉన్నెంఙ్‍ కల్సతిర? ");
INSERT INTO nit_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","యేసుంద్ ఔరున్ ఇంతెంద్ సోయ్‍ అనెకరున్ మందులక్ అవసరం తోద్ గని రొగులకెరుంఙ్ అవసరం. ");
INSERT INTO nit_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","అన్ పాపులకెర్ మన్ బద్లిపెకాద్‍ మన్కకెరున్ కూగెంఙ్ వత్ తాన్ గని నీతి మన్కకెరున్ ఒర్కిలెంఙ్‍ సటీ వరె తాన్. ");
INSERT INTO nit_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ఔర్ అమ్నున్ ఇంతెర్. యోహాన్నె సిసు ఎపుడి ఉపాస్ కతన్న పార్తన కల్సర్ అని పరుసి మన్కకెరె సిసునాయ్ అనంఙ్ కల్సర్ గని ఇమ్మెర్ తిసార్ ఉసార్. ");
INSERT INTO nit_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","మల్ల యేసుంద్ ఔరున్ ఇంతెంద్ నొవ్రక్ వెంట అనెంఙ్ పెడ్లింఙ్ వత్త సుట్ట ఉపాస్ కలుర్ ఇసా ఇడ్డెంఙ్ సాలతిర్? అనేర్ ");
INSERT INTO nit_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","గని నొవ్రకున్ ఔర్ తాన్న పుసుత్ కొసెక దినహవార్సహ. అపుడ్ అదహ దినాహలెంఙ్ ఔర్ ఉపాస్ సుమ్‍సార్. ");
INSERT INTO nit_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","యేసుంద్ ఔరుంఙ్ ఈ ఉదహరనడ్ ఇడ్తెంద్ ఎది కొత్త తుక్డె బొగ్గత్ పాత జుఙ్ఙెనె ఇరియ్త జాగత్ కుట్టెర్. ఒక్కొ వెల అనంఙ్ కుట్తె కొత్త జుఙ్ఙెన్ ఇర్కెకద్ ఎరద్. కొత్తతనట్ పుస్త తుక్డె పాతత్ కలయెద్. ");
INSERT INTO nit_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","గని ఎది కొత్త అగుంర్నె రసాన్ పాత తోల్నె తైలి వాఙెర్. అనంఙ్ వఙ్తెదింతె కొత్త రసత తోల్నె తైలిన్ ఒట్సద్. రసా కుల్సద్ అని తోల్నె తైలినాయ్ కరాబ్ ఎర్సద్. ");
INSERT INTO nit_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","గని కొత్త అగుంర్నె రసాన్ కొత్త తోల్నె తైలి వాఙ్‍సర్. ");
INSERT INTO nit_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ఎద్ది పాత అంగుర్ రసాన్ కొత్తన్ మెస్సెంద్. తానుంఙ్ ఇంతె అముదు ఇసాద్ పాత అల్కే అండ్డిన్. ");
INSERT INTO nit_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ఆలపుసేక దినముంఙ్ యేసు కెడ్లడ్ సెరెంఙ్ అంమ్నె సిసుల్ సెన్నున్ కిస్నెర్ అని తమ్మె కెయ్యుత్ పుయ్ముత్ అదవున్ తిన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","అపుడ్ కొన్సెం మంది పరుసి మన్కకెర్ ఇంతెర్ నియమ్ సాస్త్ర ఆలపుసేక దినముంఙ్ పని కలెంఙ్ జమిలెద్ తా. తనుంఙ్ నీర్ సెన్కు కిసాతిర్? ");
INSERT INTO nit_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","యేసుంద్ ఔరున్ ఇంతెంద్. దావిద్ రాజ్‍క్ అని అమ్నె దొస్తు కర్వుత్ అన్నెఙ్ తన్నెద్ కత్తెర్ అదున్ బదోల్ నీర్ వాసిపెతిర్? ");
INSERT INTO nit_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","అముదు దెయ్యంమ్నె గుడిఙ్ సెత్న దెలక్ సివయ్ ఎదునయ్ తినెంఙ్ తోద్ అద నివొద్ ఇట్ట నిపట్టెలున్ సుముత్న తిందెద్ అని అమ్నె దోస్తులుంఙ్ నాయ్ తినిప్ నేంద్ తా. ");
INSERT INTO nit_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","మల్ల అముదు ఔరున్ ఇంతెంద్ మన్కనె పోరక్ ఆలపుసేక దినలుంఙ్ నాయ్ ప్రబున్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","మల్ల ఇనంఙ్ ఎద్దిన్. మరొక్కొ ఆలపుసేక దినముంత్ అముదు యూదులె సావ్డిఙ్ సెత్న కరపెంఙ ఉన్నకెయ్య ఆర్‍తద్ ఒక్కొద్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","సాస్త్రి మన్కకెర్ అని పరుసి మన్కకెర్ యేసునుంన్ పొయ్ దొస్ తప్పెంఙ్ ఇసా అమ్నున్ ఆలపుసేక దినముంఙ్ సోయ్ కల్సద్ తోద ఇసా ఓల్సని టపిలుత్ అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","గని అముదు ఔరె మంతదున్ ఒర్కిలుత్న అముదు ఆర్త కెయ్తనున్ ఇంతెంద్. సులుత్న మందిన్ ముదర్వై ఇల్ అముదు సుల్తెంద్ అని అత్తి ఇల్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","అపుడ్ యేసు ఔరున్ ఇంతెద్. నీర్ అనుంఙ్ ఇడుర్ ఆలపుసేక దినమ్ ఎద్ ఇదర్స జమిల్సద్ సోయ్ తద్ కరాబా పానమున్ బత్కిప్ మరి అలెంకద? ");
INSERT INTO nit_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","మల్ల ఔర్ సదరున్ అముదు తిర్గొర్ ఓలుత్న ఆ మన్కకున్ ఇంతెంద్. ఇన్నె కెయ్యున్ సాప్ అముదు అనాయ్ కతెంద్ ఆని అమ్నె కెయ్యి సోయ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","గని పరుసి మన్కకెర్ అని సాస్త్రి మన్కకెర్ గుల్ రగ్ విడుత్న యేసునున్ తా గలెంకద్ ఇసా ఒక్కొ నెత్ ఒక్కొద్ విచార్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","మల్ల ఇనంఙ్ ఎద్దిన్ ఆ దినాలుంఙ్ అముదు పార్తన కలెంఙ్ మెట్ పొయ్ సెత్ పూర సింతె అముదు దెయ్యమున్ పార్తన కల్సని వెగ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","పొద్ కురియ్‍తె అముదు తన్నె సిసులూన్ తన్నవై కుగ్తెంద్ అని ఔరున్ లోప పన్నెండు మందిన్ ఆస్తెంద్ అని ఔరున్ ప్రెసిత్ మంజె పన్కత అపొస్తులున్ ఇసా పేర్ ఇటెద్. ");
INSERT INTO nit_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","యేసుంద్ నివుడిప్త పన్నెడు మంది ప్రెసిత్ సిసు ఇవ్రు ఎన్నెర్ సీమోన ఇమ్నుంఙ్ యేసుంద్ ఇట్ట పేర్ పేతురుక్ అండిన్ అని అమ్నె దాదక్ అంద్రెయక్ అని యాకోబ్‍ పిలిప్ యోహాన్ బర్తొలొమయి ");
INSERT INTO nit_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","మత్తయ్ తోమక్ అల్పయినె పోరక్ యాకోబ్‍ జేల్త సీమోన్ ");
INSERT INTO nit_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","యాకోబ్నె పోరక్ యూదక్ అని యేసునున్ సుముంత్ సియెక ఇస్కరియోత్ యెవుదాక్. ");
INSERT INTO nit_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","మల్ల అముదు ఔరున్ వెంట మెట్ తనట్ డిడ్తెంద్ అని అత్తి అమ్నె సిసు దండి గర్దిత్ తెల్ల జాగత్ అముదు ఇల్లుత్ అండెద్ యూద దేస్ అని యెరూసలేమ్ అని పట్ట్నం సీదోనున్ ఇనెక దవ్ సందూర్ మెరత ఊల్ తనట్ గుంల్ మంది మన్కకెర్ నాయ్ అమ్నె గొట్టిన్ వినెంఙ్ ఆని తమ్మె దుక్క తనట్ సోయ్ ఎరెంఙ్ ఇసా వాత్త అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","అమ్నె గొట్టిన్ వినెంఙ్ ఆని తమ్మె దుక్క తనట్ సోయ్ ఎరెంఙ్ ఇసా వాత్త అండెర్ బూత్ సుమ్త తక్లిబ్ సుమ్త మన్కకెర్ నాయ్ సోయ్ ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","సదర్ మన్కకెర్ అమ్నున్ పుడ్కెంఙ్ కోసీద్ కన్నెర్. మల్ల తాకత్ అమ్నతన్ కుర్యియుత్న సదర్ మందిన్ సోయ్ కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","అపుడ్ యేసున్ తన్నె సిసులున్ ఓలుత్న ఇన్తెంద్ గారిబ్ అనెకర్ నీర్ దన్యుల్ లసాతిర్. తనుంఙ్ ఇంతె దెయ్యమ్నె రాజ్యం ఇమ్మెత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","పంగి కవ్రుత్ అనెకర్ నీర్ దన్యుల్ లసాతిర్. తానుంఙ్ ఇంతె నీర్ దన్యతిర్. ఇండి అర్రెకార్ నీర్ దన్యుల్ లసాతిర్. తానుంఙ్ ఇంతె నీర్ కయ్‍ గత్తిర్. ");
INSERT INTO nit_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","నీర్ మన్కనె పోరక్నె సిసుల్ అన్సాతిర్ ఇసా మన్కకెర్ ఇమున్ విరోద్ కత్న ఇమున్ ఎడపుత్న, ఇమ్ను పొయ్ బాద్నం కత్న ఇమ్మె పేరున్ కరాబ్ కత్ జొపిటె రింతె దన్యుల్ లసాతిర్. ");
INSERT INTO nit_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ఆ దినాలుంఙ్ కుసీ కలుర్ కుసినడ్ ఎద్దుర్. తానుంఙ్ ఇంతె పరలోకముత్ ఇముంఙ్ మన్ దండి అందాద్. ఔవ్రె దొడనాయ్ ప్రవక్తకెరున్ అనాయ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","అయ్యె, స్రీమంతకెరర, ఇముంఙ్ సిక్స వారద్ సుక్కిలెద్! ఇమ్మె ఆదార్ ఇదుంఙ్ పేలెయ్ సుమ్తిర్. తానుంఙ్ ఇంతె ఇమ్మెద్ నడిపెకద్ ఇముంఙ్ రొంబ్బటిన్. ");
INSERT INTO nit_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","ఇండి దన్యుత్ అనెకర్ ఇముంఙ్ నాసనం ఎక్కద్. తానుంఙ్ ఇంతె నీర్ కర్వుత్ అందతిర్. ఇండి కయ్గెకర్ ఇముంఙ్ నుస్కన్ ఎక్కద్ తానుంఙ్ ఇంతె నీర్ నారాజ్ ఎరతిర్ అని అర్రతిర్. ");
INSERT INTO nit_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","సిమ్కన మన్కకెర్ ఇమున్ సోయ్‍ ఇందర్ తె ఇముంఙ్ నాసనం ఎక్కద్. తానుంఙ్ ఇంతె అనాయ్ అవ్రురె ముదుల్‍ పైలి కబుర్లకెర్ బదోల్ ఇడ్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","గని అన్నెతున్ విన్నెకర్ ఇముంఙ్ అన్ ఇడ్సత్ ఇమ్మె విరోదులున్ ప్రేమ్ కలుర్. ఇమున్ కుర్‍కుర్ కలెకరుంన్ సోయ్ కలుర్. ");
INSERT INTO nit_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ఇమున్ సిరొప్ సియెకరున్ ఆసిర్వాద్ సియుర్ ఇమ్మెత్ బాద్నం కలెకరుంఙ్ సటీ పార్తన కలుర్. ");
INSERT INTO nit_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ఇన్న ఒక్కొ చెంప్ప సియెకనుంఙ్ అమ్నుంఙ్‍ లాజ్జ వారెంఙ్ ఇసా పెనొక్కొ‍ చెంపన్ ఓలిపుర్ ఇమ్మె జుఙ్ఙెన్ పుసుత్ కొసెకద్ ఇమ్మె జాగన్ కొసెంఙ్ కతెంద్ ఇంతె తోద్ ఇన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ఇన్ వెలెకనుంఙ్ సాదరుని సియుర్ అని ఇమ్మె వస్తులున్ వెతుత్ కసెకరున్ తన్న అదవ్లున్ పెనహ వెల్నెమ్. ");
INSERT INTO nit_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","మన్కకెరడ్ నీర్ ఎనంఙ్ కలెంఙ్ ఇసతీర్ అనంఙ్ ఇవ్రడ్ ఇముంఙ్ తానెద్ కాలెంఙ్ ఇసాతిర్ అదున్ నీర్ పేలె ఔరుంఙ్ కలుర్. ");
INSERT INTO nit_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ఇమున్ ప్రేమ్ కలెకరున్ నీర్ ప్రేమ్ కత్తిరింతె అత్తి తానాయ్ కమల్ తోతెద్. తానుంఙ్ ఇంతె పాప్ మన్కకెర్ నాయ్ ఔరున్ ప్రేమ్ కలెకరున్ ప్రేమ్ కల్సర్. ");
INSERT INTO nit_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","అని దెయ్యం సోయ్ కలెకద్ రున్ నీర్ సోయ్ కలెంఙ్ అత్తి తనయ్ కమల్ తోతెద్. ఇనుంఙ్ రోబడ? పాప్ మన్కకెర్ నాయ్ అనాయ్ ప్రేమ్ కల్సర్ తా. ");
INSERT INTO nit_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","బరోస నడ్ మల్లపుత్ సియ్‍దార్ ఇన్నెకారుంన్ నీర్ పొయ్ సియెకర్ ఎద్దిర్ ఇంతె అత్తి తానాయ్ కమల్ తోతెద్. పాపి మన్కకెర్ నై బరొస ఇడుత్ బరబర్ రొంబాడద్ ఇన్త్న పాపి మన్కకెరుంఙ్ ప్రేమ్ కల్సర్. ");
INSERT INTO nit_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","గని ఇమ్మె విరోదికున్ ప్రేమ్ కలుర్ అని ఔరుంఙ్ సోయ్ కలెకద్. మల్ల పరలోకముత్ ఇముంఙ్ ఇనమ్ దండి అందద్ అని ఇముంన్ అల్కే దండి దెయ్యం పోరకేర్ ఇద్దర్. తానుంఙ్ ఇంతె బెయ్మాన్ అని కరాబ్ మన్కకెర్ పొదె దేయుంద్ కివ్ కల్స ద్! ");
INSERT INTO nit_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ఇమ్మె బాంద్ కివ్ కలెకంద్ లంఙ్‍ నీర్ నాయ్ కివ్ కాలుర్. ");
INSERT INTO nit_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ముదుర్ మన్కకెరె న్యాయ్ కన్నెర్. మల్ల ఇమ్మెత్ నాయ్ న్యాయ్ కల్లెర్. మరొక్కొరున్ దొసి టయ్యిరిపెంఙ్ తోద్. మల్ల ఇమ్మెత్‍ నై దొసి టయ్యిరిపెర్. మాప్ కలుర్. అపుడ్ ఇమ్మెత్నయ్ మపి కల్సర్. ");
INSERT INTO nit_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","సియ్యుర్ మల్ల ఇముంఙ్ నాయ్ దెయ్యం సియద్. సోయ్‍మెలప్స అదుమ్స నిడ్పుత్న కుల్లాద్. ");
INSERT INTO nit_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","అముదు ఔరున్ ఈ ఉదహరనడ్ ఇడ్‍తెంద్ గుడ్డి మన్కక్ గుడ్డి మన్కకుంఙ్ పావ్ ఓలిపెంఙ్ సాల్సందా? అవ్రిద్దరనాయ్ పొక్కత్ ఉర్కదర్ తొదా? ");
INSERT INTO nit_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","సిసుద్ గురుంఙ్ ఎన దండి ఎరెంద్ గని పక్క కరాపుడుంఙ్ సిసుద్ తన్నె గురులంఙ్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","ఇన్నె కన్నుత్ అనెక దులెన్ ఓలె గని ఇన్నె దాదక్నె కండ్లెంఙ్ అనెకహ కిస్కటమున్ తనుంఙ్ ఓల్సతి వె? ");
INSERT INTO nit_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ఇన్నె సొత్త కండ్లెంఙ్ అనెకహ దులెమున్ సొతహ ఓల్సెట నీ ఎనంఙ్ ఇన్నె తోరెనున్ ఓలుత్న బాపుహు ఇన్నె కండ్లెంఙ్ అనెక కిస్కటమున్ అన్ పుసాత్ ఇసాతి వె? ఏ కప్టి మన్కకెర్ పేలె ఇన్నె సొత్త అనెక కిస్కటమున్ పుస్. మల్ల ఇన్నె దాదక్నె కండ్లెంఙ్ అనెకహ కిస్కటమున్ పుసెంఙ్ సటీ ఇన్నుంఙ్ సోయ్ కన్కెరద్ పేలె ఇన్నె జింద్దగిన్ సుద్రిప్. మల్ల మరొక్కొరె జింద్దగిత్ సినా పాపులున్ సుద్రిపెంఙ్ నీ సాలతి. ");
INSERT INTO nit_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","సోయ్త మాక్నయ్ కరాబ్ పండ్లు కయ్యెద్. అనాయ్ కరాబ్ మాక్ సోయ్త పండ్లు కయ్యెద్. ");
INSERT INTO nit_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","తానుంఙ్ ఇంతె ఎద్ది మాకున్ అద్నె సొత పండ్లు తన్న ఒర్కిలెంఙ్ వార్సద్. సాల్ల తుట్టి తన్న మెడి పండ్లు పుసెమ్. దంత్తి తుట్టి తనట్ అంగుర్ పుసెర్. ");
INSERT INTO nit_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","సోయ్త మన్కక్ తనట్ సోయ్త గొట్టిక్ కురియ్‍సా. కరాబ్ మన్కన్నె మన్ తనట్ కరాబ్ గొట్టిక్ కురియ్‍సా. తానుంఙ్ ఇంతె లోప ఎద నిండుత్ అండ అదవి అమ్నె మూతి ముడ్సద్. ");
INSERT INTO nit_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","నీర్ అన్ ప్రబు ప్రబు ఇసాతిర్ గని అన్నె గొట్టిన్ తనుంఙ్ కల్లెర్? ");
INSERT INTO nit_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","అన్వై వాత్ అన్నె గొట్టికున్ విత్న అనాయ్ కద్దద్ అముదు ఎద్ద లంఙ్ అన్సాద్ అదున్ అన్ ఇముంఙ్ ఇడ్సత్. ");
INSERT INTO nit_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","అముదు బాట్టి జాగత్ గూడి బునజి తవుత్న ఎల్ల కట్టెకద్ లంఙ్ అన్సాద్ కయ్యత బూరమ్ వాత్న ఎల్లన్ జోరకత్ పొద్దతె నాయ్ ఎల్లన్ మెలపెంఙ్ సాలేతిన్. తానుంఙ్ ఇంతె అద్నె బునజి గట్టి జామిన్ పొయ్యి అండిన్ ");
INSERT INTO nit_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","గని ఎద్ద గొట్టిన్ వింత్ అనంఙ్ కలెంద్ అముదు బునజి తోసెట వరు జాగ తాన్నె ఎల్లన్ కట్టెకంద్ లంఙ్ అన్సాద్ ఆ ఎల్లన్ బూరమ్ జోరకత్ పొంద్తిన్ అని అపుడ్తద్ అపుడి అద్ రట్టిన్ అని గుల్లెన నాస్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","యేసుంద్ సిమ్కన గొట్టికున్ మన్కకెరుంఙ్ ఇడ్‍తెంద్ అముదు కపర్న ఊరుంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","అత్తి నురా సైనిక్లె దొడంద్ ఒక్కొద్ మనుంఙ్ వత్తద్ గడియక్ దుక్కమడ్ తికెంఙ్ కాన్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","అముదు యేసుకున్ బదోల్ వినుత్ యూదు మన్కకెరె దొడలున్ యేసుకున్వై పన్కుత్న యేసుంద్ వారెంఙ్ అని తాన్నె గడియకున్ సోయ్ కాలెంఙ్ వింతి కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","మల్ల ఔర్ యేసుకున్వై వాత్న అదినాడ వింతి కత్తెర్ ఇదున్ నీ అమ్నుంఙ్ కలెంఙ్ అముదు సాల్‍దద్. ");
INSERT INTO nit_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","తానుంఙ్ ఇంతె అముదు నేండె యూదులె ప్రేమ్ కలెకద్ అన్సాద్ అని నెండుంఙ్ సటీ ఒక్కొద్ యూదులె సావ్డి అముదు కట్టుత్ సియ్తెంద్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","మల్ల యేసుంద్ ఔరున్ వెంట సెన్నెద్ అని ఎల్లంఙ్ మెర్మ వాత్తె నుర్ సైనిక్లె దొడంద్ అమ్నె సంఙ్తకెరున్ ప్రబున్ వై పనుకుత్న అమ్నున్ ఇంతెంద్ ప్రబు నీర్ ఇంక తక్లిబ్ సుమ్నెమ్. తానుంఙ్ ఇంతె నీ అన్నె ఎల్లంఙ్ వారెంఙ్ అన్ అరహతన తోతెన్. ");
INSERT INTO nit_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","అన్ ఇన్నవై వరెంఙ్ సాలె తాన్ ఇసా ఇన్నెన్ గని ఒక్కొ గొట్టి మత్రమ్ ఇడ్ అన్నె గడియాక్ సోయ్‍ ఎద్దద్. ");
INSERT INTO nit_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","తానుంఙ్ ఇంతె అనుంఙ్ దండి అదికార్ అన్సార్ ఎన అనుంఙ్ బూడున్ నాయ్ సైనిక్ అన్సార్ అన్ ఒక్కొనున్ సె ఇన్నెంఙ్ అముదు సెసాద్ అని మరొక్కొనున్ వా ఇన్నెంఙ్ అముదు వార్సద్ అని గడియక్ ఇద్ కల్ ఇన్నెంఙ్ అముదు కల్సద్. ");
INSERT INTO nit_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","అదున్ యేసుంద్ వింత్న అమ్నున్ బదోల్ కమల్ కతెంద్ అని తిర్గొర తిర్గుత్న తన్న వెంట వారెక మందిన్ ఇంతెంద్ అన్ ఇముంఙ్ ఇడ్సత్. ఇస్రాయేల్ జాతి లోపాహ ఇట్ట దండి విస్వాసున్ ఓలెతన్. ");
INSERT INTO nit_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","మల్ల పవింట్ట మన్కకెర్ అమ్నె ఎల్లంఙ్‍ సెత్న సోయ్ ఎద్దహ గడియకున్ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","మరొక్కొ జీర్‍ యేసుంద్‍ నాయీన ఇనెక ఊరుఙ్‍ సెద్దెంద్ అమ్నె సిసు అని మనక్కకేర్‍ గార్డి అమ్మున్‍ వెంట చెన్నేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","అముదు ఊర్ మెరా వారెంఙ్‍ తిక్ తా మన్కక్‍ ఒక్కొరున్‍ మన్కకెర్‍ కొస్నేర్‍. తిక్ తా మన్కక్‍ అమ్నే అమ్మంఙ్‍ ఒక్కొది పోరక్‍ అండేద్‍ అని అద్ద రాడేరహ పిల్లా అండిన్‍ ఊర్‍ మంది అమ్నువెంట అండేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ప్రబుద్ అమ్ను ఓలుత్న అమ్మున్‍ పోయ్‍ కివ్ కత్నా అమున్‍ ఇత్తేంద్‍ అర్నేమ్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","యేసుంద్‍ వాత్నా సాటాన్‍ పుడుక్తెంద్. కొసేక మన్కకెర్‍ ఇల్తేర్‍ మల్ల అముదు ఇంతేంద్‍ ఎ మిడెగి పొర అన్ ఇనుంఙ్ ఇడ్సత్ సుల్. ");
INSERT INTO nit_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","తిక్త పోరక్ సుల్తెంద్ అని ఉద్దూత్ ముడెంఙ్ ఎద్దెంద్ యేసుంద్ అమ్నున్ అమ్నె అమ్మ నత్తి సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ఔరుంఙ్ అర్రి వత్తిన్ అని ఔర్ దెయ్యముంఙ్ స్తుతి కత్న ఇంతెర్ దండి సందేస్టక్ నేండున్‍ లోప ప్రవక్తక్ సుల్‍తెంద్ అని దెయ్యం తన్నె మన్కకెరున్ మదత్ కాలెంఙ్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","యేసునున్ బదోల్ గొట్టిక్ సిమ్కన యూదు అని తిర్‍గొరత సిమ్కన బార్సలెంఙ్ అని ఊలెంఙ్ నెరయ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","యేసుంద్ కత్త గొట్టికున్ బదోల్ యోహాన్నె సిసు యోహానుంఙ్ ఇడత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","అపుడ్ యోహాన్ తన్నె సిసుల్ ఇద్దరున్ తన్నవై కూగుత్న ప్రబున్ వై పన్కుత్ ఇడ్‍తెద్, వారెకని నివి ఎనివా మరొక్కొనున్ పావ్ ఓల్‍దుమె ఇసా వెలుత్ ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","మల్ల ఔర్ యేసుకున్వై వత్న వెలుత్ ఓల్‍తెర్ బాప్తిస్మ సియెక యోహాన్ వారెకని నివి ఎన్నివా తోద్ ఇంతె మరొక్కొనున్ పావ్‍ ఓల్దుమ ఇసా వేలెంఙ్ అమున్ పావింటెద్. ");
INSERT INTO nit_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ఆ వకతుంఙ్ పెలెటార్ మన్కకెర్ దుక్కలకెర్ రొగులకెర్ సంకట్ దుక్కమడ్ అని బూతు అంట్‍తరున్ అముదు సోయ్ కత్న అండెద్ అని పెలెటార్ గుడ్డి మన్కకెరుంఙ్ పుకమెయ్ నదుర్ సియ్యుత్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","యేసుంద్ ఔరుంఙ్ ఇడతెద్. సెర్ర అని నీర్ తనెన్ ఓల్‍తిర్ అని తన్నెన్ వింతిర్ అదున్ యోహానుంఙ్ ఇడుర్. అన్న వాలడ గుడ్డి మన్కకెరుంఙ్ నదుర్ వత్తిన్ కుంటిక్ అడగ్‍సా నంసార్ పెర్‍దుకమ్ తర్ సోయ్ ఎదెర్ చెవ్డకెర్ విన్నెర్ తిక్తర్ సుల్‍తెర్ గరిబులుంఙ్ సోయ్త గొట్టి ఇడ్సనంసాద్ ఇసా సెత్న ఇడుర్. ");
INSERT INTO nit_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","అన్న బదోల్ గొట్టి కురియెంఙ్ ఎంద్ రాలెదొ అన్న పొదె అనెక విస్వాసమున్ సాయెంద్ అముదు బాగ్యివాన్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","యోహాన్ తన్న వాత్త కాబుంలకెర్ సెద్ద వెన్కత్ యేసుంద్ యోహాన్ బదోల్ మన్కకెర్ మందిత గార్దిత్ ఇడెంఙ్ ఎద్దెంద్ తనెన్ ఓలెంఙ్ తెల్ల జాగంఙ్ సెత్తండిర్? గాలినాడ మెలగెకా రెకాన్ ఓలెంఙ్ సెనిర? ");
INSERT INTO nit_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","మరి తన్నెన్‍ ఓలెంఙ్‍ సెనీర్‍? మాగ్త జుఙ్ఙే తొట్ట మన్కన్‍ ఓలెంఙ్‍ ఇసా హా? ఓలుర్‍ మగ్‍త జుఙ్ఙె తోడుత్న మజా కల్స బత్కిపెకార్‍ జాజ్‍ వాడతార్‍ ఎన్నేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","మల్ల తన్నేన్‍ ఓలెంఙ్‍ సెదిర్? గొట్టి సియ్యెకనూన్‍ ఓలెంఙ్ ఇసా సెదమ్‍ ఇసాతీర్‍ ఎర కారే సందేస సియ్యెక దండిన్ ఓలెఙ్‍ సెన్నీర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ఇమ్నున్‍ బదోల్‍ ఇనంఙ్‍ వాయుత్‍ అండెతి ఓలుత్‍ అన్‍ అన్నె కబుర్లకూన్‍ ఇన్నముండట్‍ పన్కత్‍ అముదు ఇనుంఙ్‍ ముడటి సెత్నా ఇన్నె పావ్‍ తయార్‍ కాదద్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","అన్‍ ఇముంఙ్‍ ఇడసాద్‍ పిల్లనే పేట్టె తన్న జన్మ వత్త మన్కకెర్‍ లోపాహ బాప్తిస్మ సియెకా యోహానున్‍ ఎన దండి ఎదియి తోతేద్‍ గని దెయ్యమ్నె రాజ్యం లోపా గుల్‍ సిన్నాం మన్కక్‍ గిన అమ్ముంఙ్‍ ఎన్నదండి అంనాద్‍ ");
INSERT INTO nit_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","అమ్నె తున్‍ వింత్న పేరెత్‍ మంది నాక వలె నాయ్‍ దెయ్యం కారే అన్సద్ ఇసా కబుల్‍ కత్న యోహాన్నే కెయ్యడ్ బాప్తిస్మ సుంతేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","గని పరుసి మన్కకెర్ అని సాస్త్రి మన్కకెర్‍ ఎన్నాంఙ్‍ దెయ్యం అండీన్‍ అదున్‍ ఔర్ తొద ఇత్న బాప్తిస్మ సుమ్మెతిర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","మల్ల యేసుంద్‍ ఇన్తెంద్ ఈ పడిత మన్కకేరున్‍ అన్ ఎరున్‍ వెంట కాలపుత్నముడదున ఎర్ర? ఇవ్రు ఎటారే? ");
INSERT INTO nit_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","అంఙడి బజారుత్‍ ఉద్దుత్‍ అనెక పోరకేర్‍ లాగీ ఇవ్రు అంసార్‍. అమ్‍ వన్సు మొరప్దుమ్ గని నిర్‍ వినేతిర్‍? అము వాపోయ్త అర్తం గని అమున్నె వెంట నిర అర్రెతీర్‍ ఇసా కుర్‍కుర్‍ కాలేక్‍ పోరక్‍ లాంఙ్‍ అంసార్‍ ");
INSERT INTO nit_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","బాప్తిస్మ సియ్యెక యోహాన్ వతెంద్‍ అముదు తినేక‍ నిపట్ట అన్నె అంగుర్‍ రసాన్ బదోల్‍ అముదు విచార్ కాలేతేద్‍. అమ్మున్‍ బదోల్‍ నిర్‍ ఇంతెర్‍ అముదు బూతు సుమ్‍త మన్కక్‍ అన్సాద్‍ ");
INSERT INTO nit_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","మన్కనె పోరక్ అన్ తిన్నెంఙ్‍ ఉన్నెంఙ్‍ కత్తనింతో ఓలుర్‍ ఇమ్‌దు తినెకదున్ పుసాద కాల్ల జింగలక్‍ నాక వలె అని పాప్ మన్కకెరుంఙ్ దొస్తు అండాద్‍ ఇసా పేరు సియ్సంద్. ");
INSERT INTO nit_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","గని దెయ్యమ్నె బుద్ది గొట్టిన్‍ కారె కలెకాద్‍ నీతి అన్నేకరీ కెయ్యుత్‍ అండద్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","పరుసిక్లతి ఒక్కొద్ యేసునున్ తన్నె ఎల్లంఙ్ తినెంఙ్ వా ఇసా కూగ్తెంద్. మల్ల పరుసి సిమోను మన్కకెర్‍ లోపా ఒక్కొ యేసునున్‍ తిన్నెంఙ్‍ ఉద్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","అముదు పరుసి మన్కనే ఎల్లత తిసాద్‍ ఇసా ఔర్ ఒక్కొ పాప్ పిల్లంఙ్‍ ఒర్కి ఎద్దిన్‍ తెల్లొడి గుండ్ తయార్‍ కత్తె ఒక్కొ అత్తరనే సీసా ఆ పిల్ల కొత్తీన్‍ ");
INSERT INTO nit_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","అని అమ్నె గెట్టవై ఆ పిల్ల ఇల్లుత్న అర్స ఆర్సా అమ్నె గెట్టలున్ తన్నె కడ్లు ఈరడ్‍ పస్సి కత్తిన్‍ అద్నే తల్త తిరడ అమ్నె గెట్టలున్‍ ఉసుమ్‍తిన్‍. అమ్నె గెట్ట ముందర్‍వై వత్తిన్ అని ముద్దిడుత్ అత్తర్ నూనె దీట్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","అమ్మన్‍ తినెంఙ్‍ కూ‍గ్త పరుసి మన్కక్‍ అదున్‍ ఓలుత్న తన్నె మన్‍ లోపా ఇనుంఙ్‍ ముడనెంద్‍ ఈ మన్కక్‍ ఒక్కొ కబుర్లక్ ఎన్నేద్‍ ఎరెత్తె అమున్‍ పుడకెక్‍ పిల్ల ఎద ఎందొ ఒర్కిల్తనంద్‍. ఇది పాపి పిల్ల ఎద్ తా. ");
INSERT INTO nit_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","యేసుంద్‍ అమ్మున్‍ ఇన్తెంద్ ఎ సీమోన్నె అన్‍ ఇనుంఙ్‍ ఒక్కొ గొట్టి ఇడ్డేకద్‍ అన్సాంద్‍. అముదు ఇంతేద్‍ గురూజీ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ఒక్కొ సావ్‍కార్‍ తన్నె ఇద్దర్‍ మన్కకెర్‍ కరజ కొత్తేర్ ఒక్కొద్‍ ఐద్‍ చాందినె కల్దల్‍ కొత్తండాద్‍. మల్ల ఒక్కొద్‍ పన్నస్‍ చాందినె కాల్దల్‍ కొంతడేద్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ఔరుంఙ్‍ పుకమెయ్ మలపుత్‍ సియ్యెకదుంఙ్‍ సోయ్‍ తొత్తిన్న. అముదు ఇమ్‍ ఔర్ ఇద్దరె కర్జన్‍ మాప్‍ కత్తద్‍. అనుంఙ్‍ ఇడ్ ఔర్ ఇద్దరున్‍ లోపా ఎందీ సవకారున్‍ పేరెత్‍ ప్రేమ్ కాల్సాదొ ఇడ్? ");
INSERT INTO nit_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","“అదుంఙ్ సీమోన్‍ ఇనంఙ్ ఇంతేద్‍ అమ్ద ఎరున్ ఎక్వ మాప్కతెదొ అంది అని అనుంఙ్ కరిల్సానంసద్” ఇంతెద్. అదుంఙ్ యేసుంద్ “సొయ్ విసార్ కత్తివ్” ఇసా అంనడ్ ఇడుత్. ");
INSERT INTO nit_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","మల్ల అముదు ఆ పిల్ల వై తిరుగుత్న సీమోనున్‍ ఇంత్తేద్‍ ఈ పిల్లన్‍ నీ ఓల్‍తి త? అన్‍ ఇన్నె ఎల్లా లోపా సొంఙ్తన్‍. అన్నెగెట్టాలూన్‍ ఓట్టిన్‍ అన్నె తానె తల్త తిరాడ్‍ అన్నె గెట్టలున్ ఉసుమ్‍తిన్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","అన్న ముద్దిడెతి గని ఆ పిల్ల అన్నె లోపా వాత్న అతనట్‍ అన్నె గెట్ట‍లున్‍ ముద్ ఇడేకదూన్‍ సయెతిన్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","అన్నె తల్లూత్‍ నీ నునె దిటేతి గని ఈ పిల్ల అన్నె గెట్టెలేంఙ్‍ అత్తర్‍ ఒలీవ నూనె దీట్‍తీన్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","అదుంఙ్ సటీ అన్‍ ఇముంఙ్‍ ఇడసత్‍. ఈ పిల్ల క తా పేల్లె పాప్ కాడిల్తేహె తనుంఙ్‍ ఇత్తేద్‍ ఈ పిల్ల గుల్‍ ప్రేమ్ కత్తిన్‍. ఎరుంఙ్‍ కోసమ్‍ మాప్కల్ రొబట్టీన్‍ కొన్సెమి ప్రేమ్ కాదర్‍. ");
INSERT INTO nit_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","మల్ల అముదు ఆ పిల్లంఙ్‍ ఇంతేద్‍ ఇన్నె పాప్ మాప్కల్. ");
INSERT INTO nit_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","అమ్మున్‍ వెంట తినెంఙ్‍ ఉద్త మన్కకెర్‍ ఔర్ లోపా ఇనంఙ్‍ ఇన్నెంఙ్‍ ఎద్దేర్ పాపులున్ మాప్కల్ ఇముదు ఎద్ద ఎన్నెంద్‍.‍ ");
INSERT INTO nit_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","మల్ల అముదు ఆ పిల్లన్‍ ఇంతేద్‍ ఇన్నె విస్వాస్ ఇన్ బత్కిప్తిన్‍ సాంతినడ్ సే ఇస ఇడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","మల్ల ఇనుంఙ్‍ ఎద్దిన్‍ యేసుంద్‍ ఉల్లెంఙ్ అని పట్నముంఙ్‍ సెత్న దెయ్యమ్నె రాజ్యం బదోల్‍ సోయ్త గొట్టిక్‍ ఇడ్నెంద్‍. అన్నే పన్నెండు మంది సిసు నాయ్ అమ్మున్‍ వెంట అండేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","బూతు తన్నె అని రోగు తన్న సోయ్‍ ఎద్ద గూల్ మంది పిల్లక్‍ అమ్నున్ వెంట అండా అని ఏడు బూతు తనట్‍ కురియ్‍త మగ్దలేనే పేరద్ మరియ. ");
INSERT INTO nit_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","సుసాన్న అని హేరోద్ రాజక్నే దివంజి కుజక్నే మాస యోహాన్ మల్ల పెల్లెట పిల్లక్‍ నాయ్ అమ్మూన్‍ వెంట అన్నె. ఔసిమ్కన మంది, ఇమత్ సియ్సా అంనున్, అముదు సిసులె సేవ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","గుల్‍ మంది మిరయ్‍తేర్‍ అని ఉర్‍ఉర్ ‍తన్నె మన్కకెర్‍ యేసుక్‍వాయై వాత్తేర్‍ అని అముదు‍ ఒక్కొ ఉదహరన్‍ ఇడ్తెంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ఒక్కొద్‍ వాయెకద్‍ తన్నె వితనాలున్‍ వాయెంఙ్‍ కురియ్‍తేద్‍ అముదు వాయెంఙ్‍ కొన్ని పావుత ఉర్కతే అదవూంఙ్‍ మన్కకెర్‍ విదగతేర్‍ అని పిట్టా వాత్న అదవున్ తిందే. ");
INSERT INTO nit_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","కొన్ని బట్టి జాగాత్‍ ఉర్కతే మొలయేఙ అర్తే. తనుంఙ్‍ ఇంతే అత్ పాసి తొత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","కొన్ని సాల్ల తుట్టిత్‍ ఉర్కతే అని సాల్ల తుట్టి అదవున్ వెంటా పెర్గతె అదవున్ దటిప్తే. ");
INSERT INTO nit_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","మల్ల కొన్ని సోయి తా జాగత్‍ ఉర్కతే. అదా మొలకయుత్నా నూర్‍ పాంటన్ పిక్‍ సీయ్‍తే. ఇనుంఙ్‍ ఇడుత్న వాపోయుత్ ఇడతోద్‍ ఎరూంఙ్ వినెంఙ్ కెవ్వు అంసా ఔర్ వినెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","యేసున్ వై సిసు ఈ ఉదహరననె అర్తం తనెద్? ఇసా వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","అముదు ఇంతేద్, దెయ్యమ్నె రాజ్యం బదోల్ డప్‍త గొట్టిక్‍ ఓర్కిలేకద్‍ ఇనుంఙ్‍ రొంబట్టిన్‍ గని మిక్తర్‍ ఓలేంఙ్‍ ఔరుంఙ్ ఓల్సెటర్లాంఙ్, వినుత్ గని కరిల్సెటర్లాంఙ్ అనేంఙ్ ఔరుంఙ్‍అదా ఉదహరనడ్‍ ఇడ్సార్.‍ ");
INSERT INTO nit_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ఉదహరనాడ్ ఇడ్డుత్ అర్తం తనెద్ ఇంతె వితన దెయ్యమ్నె గొట్టిక్‍ ఎన్నె. ");
INSERT INTO nit_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","పావుత్‍ వాయ్‍త గొట్టిన్‍ వినేకర్ అన్సాద్‍ గని ఔర్ విస్వాసం ఇడుత్న సోయ్‍ ఎర్రెంఙ్‍ తోద్‍ ఇత్న సైతన్‍ వత్న ఔర్ మన్ తనట్‍ దెయ్యమ్నె గొట్టిన్‍ పుస్సార్. ");
INSERT INTO nit_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","బట్టిత్‍ వాయ్‍తర్‍ ఇవ్రు ఏర్‍ ఔర్ గొట్టిన్‍ వింత్న కుసినడ్‍ సియ్‍తేర్‍ గని ఔరుంఙ్‍ వేల తోతే ఇత్న జామ్‍ విస్వాసం ఇడసార్‍ అని పరిసాన్‍ ఎత్న రాల్సర్‍. ");
INSERT INTO nit_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","సాల్ల తుట్టిత్‍ ఉర్కత విత్తన లాఙ్ ఔర్ ఎర్ ఇంత్తె వింత్, కొన్నిగొల్ ఎద్దె ఔర్ బత్కెక విచార్ చింతానాడ్‍ పైసెలె అసా అని దున్యత్‍ మజనాడ్‍, పనింఙ్ వర్సెటద్ లాంఙ్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","సోయ్త జాగత్‍ వాయ్‍త వితన ఏర్ ఇంతె ఇమాన్‍ దార్‍ అని సోయ్‍ మన్నడ్ ఇడ్సార్ పక్క సుయుత్న పీక్ సీయేకద్ గొట్టిఙ్ అండేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ఎది దీవేన్ తర్పుత్ ముంస్సుత్ ఇడేర్ అని తెర్ బూడున్ ఇడేర్ గని ఎల్ల లోపా వారెకరుంఙ్ వెలుంఙ్ కండ్కెరెంఙ్ ఇసా ఆ దీవెన్ కొనొడా పొయ్ ఇడ్ సార్. ");
INSERT INTO nit_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","తానుంఙ్ ఇంతె ఒర్కితొద్ ఇనుంఙ్ తనయ్ డాపుత్ గొట్టి తోతెద్. కరిలెంఙ్ తోద్ అని ఒర్కి ఎరెంఙ్ తోద్ అనంఙ్ తనయ్ డపుత్ గొట్టి తోతెద్. ");
INSERT INTO nit_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","నీర్ తనెన్ విచార్ అదున్ బదోల్ ఉసరడ్ అండ్ర. తానుంఙ్ ఇంతె ఎరుంఙ్ అన్సాద్ ఔరుంఙ్ పెర్రెత్ రొంబాడద్ అని తోసెటా వత్తన్ అన్నె కదున్ నాయ్ పుసుత్ కొసెదాద్. ");
INSERT INTO nit_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","మల్ల అమ్నె అమ్మ అని అమ్నె దాదక్ కేర్ అమ్నున్‍వై వత్తెర్ గని గార్‍ది అండిన్ ఇంత్న అమ్నున్‍వై వారెంఙ్ సాలెతెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","అమ్నుంఙ్ కబుర్ ఇడ్‍తెర్ ఇన్నె అమ్మ అని ఇన్నె దాదక్ కేర్ ఇన్ ఓలెంఙ్ కలయెంఙ్ ఇసా వాకా ఇలుత్ అంన్సార్. ");
INSERT INTO nit_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","గని అముదు ఔరున్ ఇంతెంద్ దెయ్యమ్నె గొట్టిన్ వింత్న అడగెకరి అన్నె అమ్మ అని అన్నె దాదక్. ");
INSERT INTO nit_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","మరొక్కొ జీర్ ఇనంఙ్ ఎద్దిన్ యేసుంద్ అని అమ్నె సిసు రూకుత్ ఉద్తెర్ అని అముదు ఔరున్ ఇంతెంద్ చెండా అలా డర్డింఙ్ సెన్నర్ మల్ల ఔర్ కురియుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","మల్ల ఔర్ ఈరడ్ సెరెంఙ్ యేసుంద్ మంఙ్ నెద్. అపుడ్ దండి దుందాడ్ వత్తిన్ ఇసా రుక్ ఈరడ్ నిండుత్ ఎద్దిన్. ఔరుంఙ్ సాంకటం వాత్ అంన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ఔర్ సెత్నా యేసుకున్ సుల్పుత్ ఇనెంఙ్ ఎద్దెర్ ప్రబు ప్రబు నేండ్‍ మూలుగ్సా అన్సాతుమ్. అముదు సుల్తెంద్ అని దుందాడున్ అని జల్కంఙ్ దట్టిపెంఙ్ అదా మగ్తె ఆని సిమ్ సామ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","అముదు ఔరున్ ఇంతెంద్ ఇమ్మె విస్వాసం ఎదె సెద్దిన్? ఔర్ అర్సతెర్ అని కామల్ కత్తెర్ అని ఒక్కొనెత్ ఒక్కొద్ ఇనంఙ్ ఎద్దెర్ ఇంద్ ఎంద్‍ ఎన్నెంద్? గాలి తుపనున్ ఉక్కుమ్ సిసాంద్ అని ఇదనాయ్ ఇమ్మెతున్ విసా. ");
INSERT INTO nit_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","యేసుంద్ అని అమ్నె సెలకేర్ గలిలీయ ముండట్ అనెకా గెరాసేను ప్రతముంఙ్ గదీతేర్. ");
INSERT INTO nit_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ఔరు డర్డిన్ డిగ్గేంఙాయ్ పేలె దినా తన బూత్ అంట్త మన్కక్ అతరనాడ్ అమ్నున్‍వై వతెంద్. అముదు తానాయ్ జుఙ్ఙె తొడెంద్ అని అమ్మె వస్తి ఎల్లత్ తొత్తిన్ గని తప్నెలెంఙ్ అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","అముదు యేసునున్ ఓలుత్న జోరకత్ వపొయుత్ అమ్నె గెట్టలత్తి రాటెంద్ అని జోరకత్ ఇంతెంద్ యేసు ఎప్పుడి అనెక దెయ్యమ్నె పోరక్నీ అన్నతి ఇనంఙ్ తానెద్ ఎంద్? అన్ ఇనున్ వింత కాల్సత్నిఅన్న తక్లిబ్ సియ్నెమ్. ");
INSERT INTO nit_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","తానుంఙ్ ఇంతె యేసుంద్ ఆ బూత్ అంట్త ఆత్మన్ ఆ మన్కక్ తన్నె కురియెంఙ్ ఉక్కుమ్ సియుత్ అండెద్. ఆ సంకెలలడ్ కెయ్యు గెట్టా కట్టుత్ కొడ్పతెర్ ఎనా అముదు అదవున్ పూస్నెద్ అని బూత్ అమ్నున్ అడవిత్ కొస్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","మల్ల యేసుంద్ అమ్నున్ ఇంతెంద్ ఇన్నె పేర్ తనెద్ అన్సాద్ అముదు ఇంతెంద్; సైన్యి; కారన్ పేల్లె బూత్ అమ్నున్ లోపా సొహుత్ అండె. ");
INSERT INTO nit_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","పతల్ దిపుత్ సెరెంఙ్ ఇడ్నెమ్ ఇసా అద్ అమ్నుంఙ్ వింతి కత్తె. ");
INSERT INTO nit_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","అపుడ్ మెట్వై తుర్రెలెత్ పెరెత్ మంద్ మెయ్సనంసా అదాలోపా సెరెంఙ్ ఇడ్ ఇసా అదా బూత్ వింతి కత్తె అముదు కరాబ్ ఆత్మ సే ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","మల్ల బూత్ ఆ మన్కక్‍ తన కురియుత్ తుర్రెలా మందాత్ లోపా సెద్దె ఆని ఆ మందా డుబ్లె తన తూల్‍ వాత్నా సముద్రముత్ ముల్ఙుత్ తిక్తె. ");
INSERT INTO nit_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","తుర్రె మెయ్‍పెకర్ తనెద్ ఎద్దిన్ అమ్నున్ ఓలుత్న తుట్టెర్ అని ఊల్లరున్ అని పట్నం తరుంఙ్ మన్కకెరున్ అని దొడలుంఙ్ ఇడ్‍దర్. ");
INSERT INTO nit_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","మన్కకెర్ తనెద్ ఎద్దిన్ అదున్ ఓలెంఙ్‍ కురియుత్ వత్తెర్. ఔర్ యేసుకున్వై వత్తెర్ తె బూతు అంట్త కురియ్‍త మన్కక్ జుంఙ్ తొడుత్న సోయ్ ఎత్న సొబానాడ్ యేసునే గెట్టమేర ఉద్దూత్‍ అనెకానున్ ఓల్‍తేర్‍ ఔరుంఙ్ అర్రి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","బూత్ అంట్త మన్కకాక్ ఎనాంఙ్ సోయ్ ఎదెంద్ అదున్ ఓల్‍త మన్కకెర్ ఔరుంఙ్ ఇడ్‍తెర్ ");
INSERT INTO nit_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","అపుడ్ గెరాసేను పట్నం మెరత బర్సతర్ సిమ్కన మన్కకెర్ యేసునున్ ఔరున్ తన కుర్యుత్ సెరెంఙ్ వింతి కత్తెర్. రూక్ తానుంఙ్ ఇంతె ఔరుంఙ్ దండి అర్రి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","గని బూతు తన సొయెద్దా మన్కకక్ ఇమున్ వెంటా అన్సత్ ఇసా వింతి కన్నెన్ గని యేసుంద్ అమ్నున్ సెరెంఙ్ ఇడుత్న ఇనంఙ్ ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ఇన్నె ఎల్లంఙ్ సే అని దెయ్యం ఇనుంఙ్ ఎంన్తె దండి పాని కత్తిన్ అదున్ ఇడ్. అముదు కురిత్ సెద్దెంద్ అని యేసుంద్ అమ్నుంఙ్ ఎంతె దండి పాని కత్తంద్ అదున్ ఉరరుంఙ్ లొల్లి ఇడ్తంద్. ");
INSERT INTO nit_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","యేసుంద్ మలయుత్ వతెంద్ మన్కకెరె గర్ది కూగుత్ సుమ్‍తెంద్ తానుంఙ్ ఇంతె సిమ్కన అమ్నున్ పావ్ ఓల్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","అపుడ యూదులె సావ్డి అదికారి యాయీర్ పేరద్ యేసుకున్వై వాత్న అమ్నె గెట్టలున్ మొక్కుత్న యేసునున్ అన్నే ఎలంఙ్ వరెంఙ్ ఇసా వింతి కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","అపుడ్‍ ఇంతె అదుంఙ్ బార సల్‍కులద్ ఒక్కొది పిల్ల అండిన్ అని ఆ పిల్ల తికెంఙ్ కల్సాద్. అముదు సెరెంఙ్ మన్కకెర్ అమ్నున్ తిర్గొర గర్ది కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","అపుడ్ బరసల్కుత నెత్తుర్ సెరెక దుక్కంత ఒక్కొ పిల్ల అడ్డిన్. అద్ అద్నె సిమ్కన ఇస్టెదున్ మంద్దులకెరుంఙ్ సియుత్ తిర్పితిన్ ఎనా ఎరి ఆ పిల్లన్ సోయ్‍ కలెఙ్ సాలేతెర్. ");
INSERT INTO nit_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ఆ పిల్ల అమ్నున్ వెన్క వాలడ్‍ వత్న యేసునె జుఙ్ఙెనె డఙ్ఙున్ పుడుక్తిన్. అపుడ్తద్ అపుడి అద్నె నెత్తుర్ సెరెకద్ బాంద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","మల్ల యేసుంద్ ఇంతెంద్ మన్కకెర్ సిమ్కన అముఙ్ ఒర్కితొద్ ఇన్నెర్ పేతురుక్ ఇంతెంద్ ప్రబు పేలెటర్ మన్కకెర్ ఇన్ తిర్‍గొర మిరయుత్ గర్ది కన్నెత. ");
INSERT INTO nit_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","మల్ల యేసుంద్ ఇంతెంద్ ఎదొ అన్ పుడ్కతెంద్ తానుంఙ్ ఇంతె అన్ తన తాకత్ కురియ్‍తిన్ అనుంఙ్ కరిల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","మల్ల ఆ పిల్ల డఙెంఙ్ సాలెన్ ఇసా ఒర్కిలుత్న వాడ్కసా వాత్న అమ్నె గెట్టాలున్ మొక్తిన్ తనుంఙ్ ఇంత్తే అమ్నున్ పుడ్కత వెంటని అద్ సోయ్ ఎద్దిన్ అదున్ సిమ్కన మన్కకెర్ ముండట్ ఇడ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","మల్ల యేసుంద్ అదున్ ఇంతెంద్ బాయి ఇన్నె విస్వాసడ్ నీ సోయ్ ఎద్ది. సాంతినడ్‍ సె. ");
INSERT INTO nit_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","అద్ ముడ్స అనెంఙ్ బక్తి సావ్డి అదికారి ఎల్లతద్ ఒక్కొద్ వాత్న ఇంతెంద్ ఇన్నె పిల్ల తిక్తిన్. గురున్ పంగి తక్లిబ్ సియ్నెమ్. ");
INSERT INTO nit_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","గని యేసుంద్ అదున్ విత్న అయిరున్ ఇంతెంద్ అర్సనెమ్. మత్రమ్ బరొస ఇడ్ అని అద్ద సోయ్‍ ఎరంద్. ");
INSERT INTO nit_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","అముదు ఎల్ల లోపా వతెంద్ పిల్లనె బాంద్‍ అమ్మ పేతురుక్ యోహాన్ అని యాకోబ్‍ ఇవ్రు సివాయ్ యెరుని అమ్నున్ వెంటా వరెంఙ్ ఇడెతెద్. ");
INSERT INTO nit_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","సిమ్కన మన్కకెర్ వాపొయ్‍సా అర్సనన్నేర్ అని సాక్కున్ కుడుక్స గని యేసుంద్ ఇంతెంద్ అర్రనెర్. తానుంఙ్ ఇంతె ఆ సిన్నం పిల్ల తికేతిన్ గని మఙ్సానంసాద్. ");
INSERT INTO nit_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ఔర్ అమ్నున్ కైంఙ్నెర్. తానుంఙ్ ఇంతె ఔరుంఙ్ సిన్నం పిల్ల తిక్తిన్ ఇసా ఒర్కి అండ్డిన్. ");
INSERT INTO nit_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","గని యేసుంద్ పిల్లనె కెయ్యున్ సుముత్న ఇన్తెంద్ బాయ్యి సూల్ ఇసా ఇన్ఞెంద్. ");
INSERT INTO nit_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","అద్ పానం ఏద్దిన్ అని జల్దిని అద్ సల్‍తిన్ యేసుంద్ ఇన్తెంద్ అదుంఙ్ తనెన్ తినెంఙ్ ఎక్కద్ సియెంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","అద్నె బాంద్ అమ్మ కమల్ కత్తెర్ గని తనెద్ ఎద్దిన్ అదున్ ఎరుంగి ఇడ్డెంఙ్ తోద్ ఇసా అముదు ఔరుంఙ్ ఉక్కుమ్ సియ్యతెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","మల్ల యేసుక్ పన్నెండు మంది సిసులున్ కూగుత్ మిరపుత్ సిమ్కన బూతులున్ పొయ్ సక్తి అదికార్ మున్ సితెంద్ దుక్కమున్ సోయ్‍కలెకాద్ సక్తి అని అదికరముంన్ అముదు ఔరుంఙ్ సితెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","దెయ్యమ్నె రాజ్యం మున్ బదోల్ సోయ్త గొట్టి ఇడ్డెంఙ్ అని దుక్కలకెరుంన్ సోయ్‍ కలెంఙ్ అముదు ఔరున్ పనక్తెన్. ");
INSERT INTO nit_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","అపూడ్ అముదు ఔరున్ ఇంతెంద్ పరలోకము తనెని కొస్నెర్. కోలానాయ్, సంచి, తినెకా, పెన పైసెనాయ్ ఇంది జుఙ్ఙె కొస్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ఆ ఊరున్ సయుత్ సెన్నంతెత్ నీర్ ఆ ఎల్లతి అండ్రు; ");
INSERT INTO nit_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ఎత్తి ఎన మన్కకెర్ సుమ్తేర్ ఇంతె ఆ ఉర్ తన కురియెంఙ్ ఔరుంఙ్‍, విరోద్ సాక్సం ఇసా ఇమ్మె గెట్టత దుబ్బన్ జడిపుర్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ఔర్ కురియుత్న, ఊర్ ఊరుంఙ్ సెత్న సొయ్త కబుర్ గొట్టి ఇడ్నెర్ అని సదర్ జాగలెంఙ్ దుక్కలకెరున్ సోయ్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","గలిలీయత్ బత్కెక హేరోద్ రాజక్ యేసుంద్ కత్తసిమ్కన గొట్టికున్ వింత్న దంద్రిల్‍తెంద్. తానుంఙ్ ఇంతె. యోహాన్ తిక్తతన పెన సుల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","మల్ల కొన్సెం దెయ్యమ్నె కబుర్లకేర్ ఏలీయాక్ పెన వతెంద్ ఇన్నేర్ మల్ల కొన్సెం తొలెనితర్ దెయ్యమ్నె కబుల్లకేర్ లోప ఒక్కొంద్ సుల్తెంద్ ఇన్నేర్. ");
INSERT INTO nit_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","హేరోద్ ఇంతెంద్. అన్ యోహాన్నె మక్కున్ కత్కెద్‍ గని గడిలెక ఈ గొట్టికున్ బదోల్ అన్ విసత్ అముదు ఎద్ ఎన్నెంద్? అదుంఙ్ సటీ హెరొద్ యేసునున్ ఓలెంఙ్ ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","అపొస్తులున్ సిసు మలయుత్ వత్న అముదు కత్త సిమ్కనన్ అమ్నుంఙ్ ఇడ్‍నెర్. అముదు ఔరున్ గర్ది తన్న పకంఙ్ పుసుత్ బెత్సయిదా ఊరుంఙ్ కొస్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","మన్కకెరె గర్గి అమ్నున్ ఒర్కిలుత్ అమ్నున్ వెంట సెద్దెర్. అముదు ఔరున్ స్వికర్ కతెంద్ అని దెయ్యమ్నె రాజ్యం బదోల్ ఇడ్‍నెద్ అని సోయ్‍ ఎరెకద్నె గర్జ అనె కరుంఙ్ సోయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","పొద్ ఉర్కేఙా పన్నెండు ప్రెసిత్ అమ్నున్‍వై వత్న ఇంతెర్‍ మన్కకేరే గర్దీ తిర్గొరా తా ఊల్లేంఙ్ అని కేండ్లేంఙ్‍ సెత్నా అనేంఙ్‍ అని తినెకదుంఙ్ తానేవ్ ఎన సుమ్మెంఙ్ సే ఇన్. తానుంఙ్ ఇంతే నేండ్‍ ఇత్తీ మన్కకెర్‍ తోసెటా జాగాత్‍ అన్సతూమ్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","గని అముదు అవ్రూన్‍ ఇంతేంద్‍ నీర్ ఔరుంఙ్‍ తానెవెన తినెంఙ్‍ సియుర్. ఔర్ ఇంతెర్‍ ఆమ్‍ సెత్నా ఇవ్రూ సదర్‍ మన్కకెరుంఙ్ అంబా తోడా వందూక్‍ ఇండీ అమ్మత్తీ ఐదు నిపట్టే అని ఇందీ కయ్యెలూంఙ్‍ జాస్తి తోతే. ");
INSERT INTO nit_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","అత్తి కమ్మి జాస్తి ఐద్ హజాల్ పడ్సిల్ అండేర్. అందూ అమ్నే సిసులున్‍ ఇంతేంద్‍ ఔరుంఙ్ యాబై మంది ఉద్దేంఙ్‍ ఇడూర్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ఔర్ అనంఙ్‍ కత్తెర్‍ అని ఔర్ సదర్‍ మంది ఉద్దేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","మల్ల అముదు‍ అదా ఐదు నిప్పలున్ అని ఇంది కయ్యెలూన్ సుమూత్‍ పొదె పరలోకం వై ఓలుత్నా దన్యావాద్‍ కత్నా అదవున్‍ మూర్కుత్న సిసునాయ్ మన్కకేరుంఙ్ పయెంఙ్‍ ఇసా ప్రిసిత్ సీతేంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ఔర్ మన్కకెర్‍ తినుత్ దనీతేర్‍ మల్ల సిసు మిక్తా తుక్డేలున్ పన్నెండూ డలలెంఙ్ నిడ్‍ప్తెర్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","మల్ల ఇనంఙ్‍ ఎద్దీన్‍ యేసుంద్‍ ఒక్కొందీ సెత్నా పార్తన కలేఙా అమ్నే సిసులూన్ అమ్నున్‍వై వత్తేర్. అముదు‍ అవ్రూన్‍ వేల్తెంద్ మన్కకెర్‍ అన్‍ ఏద్‍ ఎన్నేంద్‍ ఇసార్‍? ");
INSERT INTO nit_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ఔర్ ఇంతెర్‍ బాప్తిస్మ ఓడ్పెకా యోహాన్. గని మల్ల కొన్సెం మంది ఏలీయాక్‍ ఇన్నేద్ అని మల్ల కొన్సెం మంది పేలెనిత కబుర్లకేర్ లోపా ఒక్కోంద్‍ పెన సుల్‍తేంద్‍ ఇసా ఇన్నేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","అముదు‍ ఔరున్ ఇన్తెంద్ గని నీర్‍ అమ్నూన్‍ ఏద్ ఎన్నెంద్ ఇసతీర్? పేతురుక్ ఇంతేంద్‍, “నీ దెయ్యమ్నె మన్ తా క్రీస్తునివ్ ఎన్నివా.” ");
INSERT INTO nit_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","గని అముదు‍ ఈ గొట్టీన్‍ ఏరూఙీ ఇడ్డేంఙ్‍ తోద్‍ ఇసా ఔరుంఙ్ ఆగ్య సీతేంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","అని ఇంతేంద్ ‍మన్కనె పోరక్ రంఙ్ రంఙ్త తక్లిబున్‍ సోసిపేంఙ్‍ పడ్సద్ అని మాన్‍ వాలే బార్సా దెయ్యలకెర్‍ అని సాస్త్రి మన్కకెర్‍ అన్‍ పనిత్ పడ్సెట అల్ఙేకార్‍ అన్సార్ గని అముదు ముండోల్లుంఙ్‍ పెనా సులాత్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","మల్లా ఔర్ సదారున్ ఇన్తెంద్ ఏద్‍ ఎనా అన్‍ వెంటా వరెంఙ్‍ ఓల్సంద్‍ ఎరాతే అముదు‍ తన్నెతున్ సాయుత్నా తన్నే సిలువా మంజే తక్లిబున్ ఎప్పూడి కాంజూత్ అన్‍ వెంటా ‍వరెంఙ్‍ పాజే. ");
INSERT INTO nit_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","తానుఙ్‍ ఇంతే ఏద్‍ తన్నే పానమున్ బత్కిపేంఙ్‍ ఓల్‍సాందో అముదు అదూన్‍ గమప్సంద్ గని ఏదు అనుంఙ్ సటీ తన్నే పానమున్ గమప్సంద్ అముదు‍ అదూన్‍ బత్కిప్ సాంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","తానుంఙ్ ఇంతే మన్కక్‍ సిమ్‍కానా దున్యన్‍ ఒకిరిపుత్నా తన్నే పానమున్‍ గమపూత్‍ నాస్ ‍ ఎరేంఙ్‍ ఇట్టేంద్‍ ఇంతే అమ్నూంఙ్‍ తానేద్‍ లాబమే? ");
INSERT INTO nit_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","తానుంఙ్ ఇంతే అన్‍ అని అన్నె గొట్టికున్ బదోల్‍ లజ్జాంఙ్‍ వద్దాంద్‍ అమ్నూన్‍ మన్కనె పోరక్ అన్‍ అన్నె మహిమనాడ్‍ బానె మానాడ్ అని పవిత్ర దెయ్యమ్నె దూత్ లే మహిమనాడ్‍ వరేఙా అన్ నాయ్ లజ్జంఙ్ వరాత్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","గని అన్‍ ఇమ్మూంఙ్‍ కరెయ్ ఇడ్‍సాత్‍ ఇత్తీ ఇలూత్‍ అనెకర్‍ లోపా కొన్సెం మంది మన్కకెర్‍ దెయ్యమ్నె రాజ్యమున్ ఓల్త సివాయ్‍ తిక్కేంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ఇదా గొట్టిక్‍ అముదు ఇడ్డూత్నా కమ్మి జాస్తి ఎనెమ్ది దినా ఎద్దే యేసున్‍ అమ్నూన్‍ వెంటా పేతురుంద్‍ యోహాన్ అని యాకోబ్‍ పార్తన కల్లేంఙ్‍ మెట్పోయ్‍ కొస్‍తేంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ఔర్ పార్తన కల్సా అనేఙా అమ్నె మోకం తా రుప్ బద్లిల్‍తీన్‍ అని అమ్నే జుఙ్ఙె తెలోడి ఎత్నా తరీనె. ");
INSERT INTO nit_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","అప్పూడ్‍ మోసే అని ఏలీయా ఏలీయాక్‍ ఇవ్రు ఇద్దార్‍ అమ్నున్ వెంట ముడెంఙ కనుక్నేర్. ");
INSERT INTO nit_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ఔర్ సిమ్కన మహిమానడ్ కడుక్ ఎద్దేర్ అని యెరూసలేముత్‍ అమ్నున్ అల్ఙెకద్ ఇసా ముడ్నేర్.‍ ");
INSERT INTO nit_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","పేతురుంద్ అని అన్‍ వెంట అనెకర్‍ తుర్సననేఙా ఔర్ సులెఙా అమ్నే మహిమా అని అమ్నూన్‍ వెంటా ఇలూత్‍ అనెకర్‍ ఇద్దారూన్ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","మల్ల ఔర్ ఇద్దర్‍ మన్కకెర్‍ అమ్నూన్‍ తన కురియూత్‍ సరేఙా పేతురుంద్ యేసునూన్‍ ఇంతేంద్. మారాజా నేండ్‍ ఇత్తీ అనెకాద్ సోయ్‍. ఆమ్‍ మూన్దీ కుప్పీక్‍ ఇడసాతుమ్‍. ఇనుంఙ్‍ ఒక్కొద్‍ మోసేఙ్ ఒక్కొద్‍ అని ఏలీయా కుంఙ్‍ ఒక్కొద్‍ ఔర్ తనే ఇడ్సా నండారొ అమ్నుంఙ్ కరిలెతీన్. ");
INSERT INTO nit_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","అముదు‍ ఇనంఙ్‍ ముడ్సా అనేఙా ఒక్కొ ఆబార్‍ వత్మా ఔర్ పొదె నిడలాంఙ్‍ మున్సుతీన్‍. ఆ ఆబార్ ఔరున్ లోపా సొంఙ్ తిన్ అని సిసు అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","అని ఆబార్‍ డామ్మ తన ఒక్కొద్‍ విన్కవత్తిన్ ఇంద్‍ అన్‍ ఆస్త అన్నే పోరక్‍ ఎన్నేంద్‍. ఇమ్నేతూన్‍ విండ్రూ. ");
INSERT INTO nit_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","అముదు‍ వినుక్ వంతెని యేసుక్ ఓకొది అండెద్ ఔర్ సురుమ్ అండెర్ అని అదా దినాములడ్ ఔర్ ఓల్త ఎరుంఙ్ నాయ్ ఇడ్డెతెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","మల్ల ఎనంఙ్ ఎద్దిన్‍ మరొక్కొజీర్ ఔర్ మెట్ తన డిగ్గుత్ వరెంఙ్ యేసున్ ఓలెంఙ్ గుల్‍ దండి గుంపు అమ్నున్ వయ బెటెద్దిన్ ");
INSERT INTO nit_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","మన్కకెరె గర్ది తన ఒక్కొంద్ వపొయుత్ ఇడ్నెద్ గురు అనె పోరకున్ ఓలెంఙ్ వా ఇసావింతి కల్సాత్ కారన్ అముదు అనుంఙ్ ఒక్కొంది పోరక్ అంన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ఒక్కొద్ బూత్ అమ్నున్ అంట్త ఏపుడ్ ఇంతె అపూడి అముదు గుల్ వపొయ్‍ సాంద్ అమ్నుంఙ్ గురె వత్ మూతిత్ పెస్ కొతెంద్ అని అద్ అమ్నున్ సయెద్ అని గుల్ రిపి రిపీ కల్సన్సద్. ");
INSERT INTO nit_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","అదున్ ఎద్గెన్ ఇన్నె సిసులున్ ఇడ్ తన్ గని ఔర్ సలెతెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","యేసుంద్ ఇంతెంద్ విస్వాస్ తోసెటార్ అని కరాబ్ పాడి తార్ ఎంతె గాడి అన్ ఇమున్ వెంటా అన్ సైన్ అందతున్? అని ఇమ్నెత్ మపి కత్న? ఇన్నె పోరకున్ తొడా వా. ");
INSERT INTO nit_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","అముదు వరెంఙ ఆ బూత్ అమ్నున్ ఎలున్ రప్తిన్ గురె వత్తిన్ గని యేసుంద్ అద్ బూతున్ దట్టిప్తత్తెంద్ పోరకున్ సోయ్ కతెంద్ అని అమ్నె బాంద్ వై సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ఔర్ సిమ్కన దెయ్యమ్నె దండి కార్యలున్ ఓలుత్ అముదు సిమ్కన పరిసాన్ ఎద్దేర్ సిమ్కన మంది కమాల్ ఎద్ద యేసుంద్ అమ్నె సిసు ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ఈ గొట్టికున్ నీర్ ఉసారాడ్ వినుర్ మన్కనె పోరక్ అనుంఙ్ మన్కకెరుంఙ్ సుమ్ముత్ సియెకరాన్సార్. ");
INSERT INTO nit_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","గని ఈ గొట్టి ఔరుంఙ్ కరిలెతిన్. ఔరుంఙ్ కరిలెంఙ్ తోద్ ఇసా అవ్రవ్రి ఇనుత్ అండిన్. ఔర్ ఆ గొట్టన్ బదోల్ అమ్నున్ వేల్తొలెంఙ్ అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","మల్ల ఔరున్ లోపా ఎంద్ దండి ఎన్నెంద్? ఇసా జాగ్డ కాన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","గని యేసుంద్ ఔరె మన్తా విసరున్ ఒర్కిలుత్ ఒక్కొద్ సిన్నం పోరకున్ ఒఙ్ఙుత్న అమ్నున్ మెరా ఇల్పుత్న ");
INSERT INTO nit_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ఔరున్ ఇంతెంద్ అన్నె పేరాడ్ ఈట్ట పోరకున్ ఎదా సుమ్మెకద్ ఎన్నెదె. ఎంద్ అన్ సుమ్సాంద్ అముదు అన్ సుమ్మెకద్ ఎన్నెదా తానుంఙ్ ఇంతె ఇమ్మున్ లోపా సిమ్కనంఙ్ సినమ్ అనెకంద్ సిమ్కనంఙ్ దండి ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","యోహాన్ ఇంతెంద్ మాల్క ఇన్నె పేరడ్ బూతులుంన్ ఎద్గెకానున్ ఒక్కొనున్ ఓల్‍తమ్. అముదు నెడత్తంద్ ఎరెంద్ అమ్నున్ తోద్‍ ఇంత్తమ్. ");
INSERT INTO nit_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","గని యేసుంద్ అమ్నున్ ఇంతెంద్ అమ్నున్ అని మరొక్కొ సిసు తోద్ ఇన్నేర్. తానుంఙ్ ఇంతె ఎద్ నేండుంఙ్ విరోద్ తోతెంద్ అముదు నెండున్‍‍ వై అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","యేసు స్వర్గున్వై మలయ్యుత్ సెరెకా వెలా మెరా వత్తిన్. అపుడ్ అముదు యెరూసలేముంఙ్ సెరెంఙ్ నిర్నయ్ సుమ్‍తడెద్ అనుంఙ్ ముండట్ తన్నె కబుల్‍లాకెరున్ పన్కతెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","తె ఔర్ యేసునుంఙ్ సటీ సిమ్కన తయార్ కనార్ ఇసా సమరయ ఇనెక ఊరుంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","గని ఆ ఊరున్ యేసుంద్ ఓప్తెంద్. తానుంఙ్ ఇంతె యేసుంద్ యెరూసలేముంఙ్ సెరెంఙ్ ఇసొబడ్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","సిసుల్ ఇనెక యాకోబ్‍ అని యోహాన్ ఇనెకర్ అదున్ ఓలుత్ ప్రబు! ఇవ్రున్ నాస్ కలెఙ్ ఆబార్ తన కిస్ వార్గలుర్ ఇసాతివా? ఇసా వెలుత్ ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","గని యేసుంద్ ఔరున్‍వై తిర్గుత్ ఔరున్ సిరయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","సెయ్త వెన్కత్ ఔర్ అత్రనట్ కురియుత్న మరొక్కొ ఊరుంఙ్ సెరెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","అనంఙ్ సెసా అనెంఙ్ ఒక్కొ మన్కక్ యేసునున్ వెంటా ప్రబు! నీ ఎత్తింఙ్ సెరతి అత్తింఙ్ అన్‍నాయ్ వార్సత్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","తె యేసుంద్ కొయ్లక్‍కె అనెంఙ్ కడ్ల అంసా ఆబార్ పోయ్ ఉడలెక పిట్టలుంఙ్ తుప్ప అంసా. గని మన్కనె పోరక్ మత్రమ్ మంఙెంఙ్ జాగనాయ్ తోతెంద్ ఇసా అమ్నుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","అని పెనా ఒక్కొనున్ ఇంతెంద్ అన్ వెంటా వా ఇసా ఇంతెంద్. గని అముదు ప్రబు! అన్నె బాంద్ తిక్‍త వెన్కత్ అమ్నె మతి కత్ అన్ సెరెంఙ్ ఇడూర్. ");
INSERT INTO nit_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","తె యేసుంద్ తిక్‍తరి ఔరున్ తమ్మె తిక్‍తరున్ మతి కలెంఙ్ ఇడ్. నీ సెత్న దెయ్యమ్నె రాజ్యం బదోల్ ప్రచర కల్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","పెన ఒక్కొద్ ప్రబు! అన్ ఇన్ వెంటా వార్సత్. గని పేలె కుటుంబ తరున్ ఇడ్డుత్ వారెంఙ్ ఇడ్ ఇసా వెలుత్ ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","తె యేసుంద్ అమ్నున్ వెంటా ఎరి ఎకద్ బూమిన్ నాగెలి ఉర్రెంఙ్ వెన్క వై ఓల్‍సా అడెదింత్తె దెయ్యమ్నె రాజ్యం ముత్ పనిఅటామన్కక్ తన్ఎదుంగి పని సియెద్. అనంఙ్ కలెకద్ త్న సాయుత్ వతెంద్ అదున్ ఓల్సఅన్సద్ ఎరతె ");
INSERT INTO nit_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ఇదవ్ ఏదెవ్ ఇంతే ప్రబు మల్ల డేబ్బయి మన్కకేరున్ నివడిప్తెంద్ అని తహన్ సోత సేరేకద్ అండేన్ అదవ్‍ సదర్ ఊల్లెంఙ్ అని జాగలెంఙ్ అవురుంఙ్ తనుంఙ్ ముండట్ సేరేగ ఇసా ఇద్దర్ ఇద్దరున్ పనతేద్. ");
INSERT INTO nit_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ఔరున్ పన్కసా అముదు ఔరడ్ ఇనంఙ్ ఇంతేద్ కొసెం పెరెత్ అన్సాద్. పనికలెకర్ కొన్సెంమంది అన్సార్. అదుంఙ్ ఎత్తి పనికలెకరున్ పన్క ఇసా అర్కెక మాల్కకున్ వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","సెర్ లండిగకే లోపా గొర్రెలే కొవ్వెన్‍ పన్కెకద్లంఙ్‍ అన్‍ ఇమూన్‍ పన్కసాత్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","పైసెలె సంచి ఎక్కాద్‍ తైలి ఎక్కాద్‍ కెర్రికూన్‍ కొస్నేర్‍ పావ్‍ తా ఎరేత్‍ ఎరుంఙ్‍ నాయ్‍ అండమ్ సోఙ్‍నేర్‍ ఎత్తినాయ్‍ ఇల్నేర్. ");
INSERT INTO nit_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ఎద్ది ఎల్లాలోపా సోంఙ్‍ తిర్గతె ముండట్‍ ఆ ఎల్లాతరున్‍ సాంతిఎక్కాద్‍ ఇనూర్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","అత్తీన్‍ సాంతింఙ్ తా పోరక్‍ అన్సాన్‍ ఎరాతే ఇమ్మే సమాదాన్‍ అమ్‍నున్‍ వెంటా అందాద్‍. తోతేనెరా అద్దు ఇమ్మూన్‍ వెంటా వాపాస్‍ వరాద్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ఒక్కొది ఎల్లతి అంత్నా ఔర్ ఎదూన్‍ సియ్తె అదున్‍ తినెంఙ్‍ ఉనేంఙ్‍ కల్సా అండ్రు. పని కలేకనున్‍ కుల్కాడ్ రొంబాడద్‍ ఎల్లాక్‍ తిర్గనేర్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ఒక్కొ ఊరుఙ్‍ నీర్‍ సెరెఙా ఔర్ ఇమూన్‍ సోయ్‍ వత్తేర్‍ ఇనుత్నా ఎదూన్‍ ఇమ్మూంఙ్‍ సియ్‍సార్ అదుంఙ్‍ తినూర్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","అత్తి అనెకా రోగులకేరూంఙ్‍ సోయ్‍ కత్నా అవురూంఙ్‍ ఇడ్డూర్‍ దెయ్యమ్నె రాజ్యం ఇమున్ మేరమ్‍ వత్‍ అన్‍సాద్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","గని ఒక్కోంద్‍ ఊరుఙ్‍ సరేంఙా ఔర్ ఇమ్మూన్‍ స్వీకార్‍ కలేతేర్‍ తే అత్ సడ్‍కులెంఙ్‍ సెత్నా ఇడ్డూర్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","అమ్మె గెట్టలేంఙ్‍అట్టూత్ ఇమ్మే ఊర్ తా దుబ్బాన్‍ గిన ఇమ్మూంఙ్‍ విరోది ఎరూత్‍ జడిప్‍సా జొపిటమ్‍. గని ఇమ్ముంఙ్‍ కరిలెంఙ్ దెయ్యమ్నె రాజ్యం మేరమ్‍ వత్‍ అన్సాద్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","అన్‍ ఇమ్మూంఙ్‍ ఇడ్సత్ ఆ ఊరుంఙ్‍ ఎరేకదూన్‍ ఎనా దెయ్యమ్నె న్యాయ్ కల్‍సాంద్‍ దినామ్‍ సొదొమ ఊరుఙ్‍ తక్లిబ్ ఎనా తక్కువ అన్దదా. ");
INSERT INTO nit_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","అయ్యో కొరాజీనా ఊరు ఇన్నేత్‍ నాసనం ఎక్కాద్‍ అయ్యో బెత్సయిదా ఊరు ఇన్నేత్‍ నుక్‍సాన్ ఎక్కాద్‍ ఇమ్మతీ ఎద దండి సమత్కారున్ సట్టమ్‍ అని తూరు సీదోనున్‍ ఊర్లేంఙ్‍ ఎర్‍సనండింతే ఔర్ అపుడీ గొనె జుఙ్ఙె పొర్‍కుత్నా బుగ్గీత్‍ ఉత్నా కబుల్ ఎత్న దెయ్యమున్‍వై మన్ బద్లిపుర్. ");
INSERT INTO nit_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","గని ఇమ్ముంఙ్‍ ఎదా న్యాయ్ ఎరేకాద్‍ అన్సాద్‍ అదూన్‍ ఓలెంఙ సట్టమ్‍ అని సీదోన్ తరున్ ఎరేకా న్యాయ్ సాస్తె అంన్సాద్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ఏ కపర్న ఊరార్‍ నీర్‍ పరలోకముంఙ్ ఎంతే పోయ్‍ కొస్తెర్? తొదా నీర్‍ పాతాలముంఙ్ ఎంతె బూడూంఙ్‍ డిగ్గతీర్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","మల్ల అముదు‍ సిసులున్‍ ఇసాద్ ఏంద్‍ ఇమ్మెత్‍ విసాద్ అముదు అన్నేత్‍ విసాద్. ఏంద్‍ ఇమ్మున్ తోద్‍ ఇసాద్ అముదు‍ అన్‍ తోద్‍ ఇసాద్ ");
INSERT INTO nit_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","మల్ల డెబై మందీన్‍ కుసినడ్‍ మలయుత్ వాత్న ఇసార్‍ ప్రబు ఇన్నే పేరాడ్‍ బూతు నాయ్ అమ్మేత్‍ విసా. ");
INSERT INTO nit_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","మల్ల యేసుంద్ ఔరున్‍ ఇసాద్ సైతన్‍ పరలోకంతన మెరెపెకద్లంఙ్‍ ఉర్కెకదున్ అన్‍ ఓల్‍తాన్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","వినుర్ పాము అని టుటొల్ విద్‍గేంఙ్‍ అని విరోదినే సాటం తాకత్‍ పోయ్‍ అన్‍ ఇమ్మూంఙ్‍ పూర అదికార్ సియ్‍తన్‍ ఇమ్మూంఙ్‍ అదా తనాయ్ కలేంఙ్‍సాలే. ");
INSERT INTO nit_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","గని బూతు ఇమ్మెత్‍ విసా ఇంత్‍ కుసీంఙ్‍ వాన్నేర్‍. గని ఇమ్మే పేల్ పరలోకముత్‍ వాయుత్‍ అన్సా ఇసా కుసీకలుర్. ");
INSERT INTO nit_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ఆ వాకతుంఙ్ యేసుంద్ పరిసుద్ద ఆత్మనాడ్ కుసీంఙ్‍ వతెంద్‍ బా! పరలోకముంఙ్ అని బూమింఙ్ ప్రబుద్ ఈ గొట్టికున్ నీర్ బుద్దితర్ అని కరిలెక మన్కకెరుంఙ్ డపుత్న సినపొరకెరుంఙ్ కరిపుత్ ఇడ్ తివ. కరెయ్ బబా అద్ ఇన్నె మన్తద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","సదర్‍ బాంద్ దెయ్యం అనుంఙ్ సియుత్ అన్సాద్. బాన్ దెయ్యం సివయ్ పోరక్ సివాయ్ ఎరి ఓరికిలెంఙ్ సలెర్ అన్‍ సివయ్ ఎది బాద్ దెయ్యమున్ ఓరికిలెంఙ్ సలెద్ గని అన్ నివ్‍డిప్త మన్కకెర్ తక్ దెయ్యమున్ ఒర్కిల్సర్. ");
INSERT INTO nit_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","మల్ల అద్ తన్నె సిసులూన్ పకంఙ్ కూగుత్ ఇడ్తెంద్ ఔరున్ ఇంతెంద్ నీ ఓలెకదున్ ఓలెక కండ్ల బాగ్యివన్ అంన్సా. ");
INSERT INTO nit_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","తానుంఙ్ ఇంతె పెర్రెత్ సందేస్టకెర్ అని రాజకేర్ నీర్ ఎద్ అన్ కలెకదున్ ఓల్సతిర్ అదున్ ఓలెంఙ్ కిరవ్నెర్ గని సాలెతెర్ అని నీర్ ఎదా అన్నె గొట్టికున్ విసతిర్ అదున్ వినెంఙ్ కిరవ్నెర్ గని సాలెతెర్. ");
INSERT INTO nit_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","అపుడ్ సాస్త్రి మన్కక్ ఒక్కొద్ సులుత్న అమ్నున్ పరిక్స ఓలెంఙ్ సటీ ఇంతెంద్ ప్రబు పరలోక రాజ్యం ఎప్పుడి తిక్సెట పానం రొంబడెకదుంఙ్ అన్ తగలెకద్ ఇసాంద్? ");
INSERT INTO nit_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","యేసుంద్ అమునున్ ఇంతెంద్ నెకి సాస్త్రత్ తనెద్ ఇండ్సద్? సాస్త్రత్ లోప తానె వాసిప్తి? ");
INSERT INTO nit_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","అముదు ఇంతెంద్ ఇన్నె దెయ్యం ప్రబుకున్ పొయ్ పూర మన్నాడ్ పూర ఆత్మనడ్ పూర తాకతడ్ పూర బుద్దినడ్ ప్రేమ్‍ కాల్ అని తన్ పొయ్ ప్రమ్ కలెకద్‍లాంఙ్ సెజరిన్ పొయ్ నయ్ ప్రేమ్ కల్. ");
INSERT INTO nit_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","యేసుంద్ అమ్నున్ ఇంతెంద్ నీ బరబర్ ఇడ్‍తి. అనాయ్ కల్. అపుడ్ నీ బత్కసతి. ");
INSERT INTO nit_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","గని అముదు అన్ నీతిమన్ అంసత్ ఇసా ఓలిపెంఙ్ సటీ యేసునున్ ఇంతెంద్ ఎద్ అమ్నె సెజరి? ");
INSERT INTO nit_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","యేసుంద్ అమ్నున్ ఇడెంఙ ఇంతెంద్ ఒక్కొ మన్కక్ యెరూసలేమ్ తన యేరికొ పట్నం ఎరికొ ఊరుంఙ్ సెరెంఙ డొంఙలె కెయ్యుత్ రొబటెద్. ఔర్ అమ్నె జుఙ్ఙెలున్ నయ్ పుస్తెర్ అని లగప్‍తెర్ అని అమ్నున్ తిక్తనున్‍ లంఙ్ కత్న కురియుత్‍ సెద్దేర్. ");
INSERT INTO nit_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","మల్ల ఒక్కొ దెయ్యలక్ అద్ది పవాడ్ ఇనాయ్ సేనేర్ అముదు ఇమ్నున్ ఓలుత్న పక్కఙ్ కురుయుత్ సేస్సద్. ");
INSERT INTO nit_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","అనాయ్ ఒక్కొంద్ లేవి మన్కక్ అద్ది జాగత్ వత్ అమ్నున్ ఓలుత్న అముదు నాయ్ పక్కఙ్ కురుయుత్ సెసాంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","గని మరొక్కొ సమరయు మన్కక్ అమ్‍ది పావడ్ సెరెంఙ అమ్నున్ ఓలుత్ అమ్నున్ పొయ్ కివ్ వర్సద్. ");
INSERT INTO nit_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","అని అమ్నున్ మెర వాత్ ఒలీవ నూనె అని అంగురు రసాన్ పేయ్యుతు అమ్నె పుండ్లున్ కట్సద్ మల్ల అమ్నున్ సోత తన్నె గాడ్దిన్ పోయ్ అమ్నున్ ఉద్దిపుత్న అమ్నున్ ఒక్కొ ఏల్లంఙ్ తోడవాత్ అమనే సోయ్ కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","మరొక్కొ దినం అముదు ఇంది వెండి కల్దర్ సుముత్న అముదు ఎల్లతరుంఙ్ సియ్యుత్న ఇసాంద్ ఇమ్నేత్ సోయ్‍కల్ ఇదుంఙ్ ఏక్కువ నివ్ కర్చ కత్తివింతె అన్ వపస్ వరెంఙ ఇనుంఙ్ నిండ్పుత్ సియ్‍సాత్ మల్ల యేసుంద్ ఇస్సాంద్కి. ");
INSERT INTO nit_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ఇనుంఙ్ ఏనఙ్ కారిల్సద్ ఇవుర్ ముగ్గుర్ లోప డొంఙలె కేయ్త యేసుంద్ రొంబడుత్ మన్కకున్ సేజరిలాఙ్ సంమజిలెకంద్ ఏర్సద్. ");
INSERT INTO nit_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","అముదు ఇసాంద్ ఏంద్ అమ్నున్ పొయ్ కివ్ కల్సాంద్ అమ్‍ది ఎర్సాంద్ మల్ల యేసుంద్ అమ్నూన్ ఇసాంద్ సే అని అనాయ్‍కల్. ");
INSERT INTO nit_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","మల్ల ఔర్ ఔరె పవడ్ సెరెఙా ఒక్కొ ఊరుఙ్ వరెఙ మార్తక్ పేర్త ఒక్కొ పిల్ల అద్నె ఎల్లంఙ్‍ అమనున్ కూగుత్న. ");
INSERT INTO nit_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","అదుఙ్ మరియ ఇనెక పేర్త తోర్దా అండిన అద్ యేసునే గేట్ట మేర ఉదుత్న అమనే గొట్టికున్ వింద్. ");
INSERT INTO nit_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","గని మార్తక్ ఎక్కువ సేవ పోయ్ ద్యానం కాల్సద్ అని యేసున్‍ వై వాత్న ఇసాద్ ప్రబు మరియ ఇనెక పేర్త తోర్దా సాటం అనుంఙ్ సంఙ్ ఏర్ ఇసా దంద్రిల్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","గని యేసుంద్ అదున్ ఇసాద్ మార్తక్ నివ్ పనినే కాడ్జి కాల్సతివ్ అని దాందరిల్త్తివ్. ");
INSERT INTO nit_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ఒక్కొది పాని పజ్జె మరియక్ సోయ్ వట్టన్ ఆస్తిన్ అదూన్ అద్న తన తనయ్ పుస్సెంఙ్ సాలేర్. ");
INSERT INTO nit_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","మల్ల ఇనంఙ్ ఎద్దిన్ యేసుంద్ ఒక్కొ జాగత్ పార్తన కత్న మోడిల్‍తె. అమ్నె సిసులొప ఒక్కొద్ అమ్నున్ ఇంతెంద్ ప్రబు యోహాన్ తాన్నె సిసులున్ పార్తన కలెకద్‍ బదోల్ కర్పనెంద్. అనాయ్ అమున్ కారాప్. ");
INSERT INTO nit_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","అముదు ఔరున్ ఇంతెంద్ నీర్ పార్తన కలెంఙా ఇనంఙ్ కలుర్ సొర్గతా అమ్మె బబా! ఇన్నె పేర్ పవిత్రనాడ్ అండ కాడితుంఙ్ ఇనుంఙ్ దండి మన్ వాకద్. ఇన్నె రాజ్యం వాకాద్. ");
INSERT INTO nit_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","రోజ్‍ అమ్మున్వెంటా అండా అద్ చందిన్ సియ్. ");
INSERT INTO nit_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","అమ్మున్ ఉల్ట పాప్ కత్తరున్ మాప్ కల్సతుమ్. అనాయ్ అమ్మె పాపులునాయ్ మాప్‍కాల్. అమ్ముంఙ్ కరాబ్ ఆసలెంఙ్ కొసె టా బత్కిప్, ఇసా కరప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","అని యేసుంద్ ఇంక గినా ఔరున్ వెంటా ఇమున్‍లోపా ఎనుఙి ఒక్కొద్ దొస్త అండెద్ ఇడ్ర, అముదు ఒక్కొ జీర్‍సింతె పావీ సెరెంఙ్ ఇన్నెఎల్లత్ ఇల్‍తెర్ ఇసా. ");
INSERT INTO nit_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","అమ్నుంఙ్ తినెంఙ్ తనయ్ తోసెటా అండ్డె ఇన్నె ఎల్ల మెర తా దొస్తన్వై సెత్న అన్నె ఎల్లత్ తిన్నెంఙ్ తనయ్ తోతెంద్ అనుంఙ్ ముది నిప్పలా ఇసా వెలుత్ఓల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","అపుడ్ అముదు లోపలడి, అమున్ పరిసాన్ కన్నెమ్! గుయ్‍గెత్తుత్ అన్సాద్ అన్ అనిఅన్నెసినాహపొరకెర్ మంగుత్అంసాతుమ్. అన్‍ సులుత్ ఇనుంఙ్ తనయ్ సియెంఙ్‍ సాలెన్, ఇసా ఇడ్తెంద్ ఇడ్ర. ");
INSERT INTO nit_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","అపుడ్ అముదు ఇన్నె దొస్త ఎద్దకాడీతుంఙ్‍, అముదు సులుత్ సియెంఙ్ సాల్‍సెటా అండేనాయ్ లజ్జంఙ్ వర్సెటా సురుమ్ వెలెంఙ? ఇనుంఙ్ వెన్కత్ అనెకా సిమ్కన తపతోసెటా ఇముంఙ్ సియ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","అదుంఙ్ ఎత్తి నిర్నయ్ దెయ్యమున్ వేలుర్, తపతోసెటా ఇముంఙ్ సియ్‍దాద్. కిరవుర్ ఇముంఙ్ రొంబాడద్. గుయున్ కుడుకుర్‍ ఇముంఙ్‍ సటీ పుసాద్. ");
INSERT INTO nit_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","తానుంఙ్ ఇంతె వెలుత్ ఓలెకా అర్ ఒక్కొనుంఙ్ సియిసాద్. కిరవెకనుంఙ్ రొంబాడద్. గుయున్ కుడ్కెకనుంఙ్ గుయ్ కురియద్. ");
INSERT INTO nit_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ఇమున్ లోపా బాంద్ ఎద్దర్ ఎర్రి ఎక్కద్ ఇమ్మె పోరక్ నిపాటె సియ్ ఇసా వేలెఙ గుడున్ సియతిరా? అనాయ్ కయ్యె వేలెఙ అదున్ బదోల్ పామున్ సియతిరా? ");
INSERT INTO nit_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","తోద్‍తె సంకు వేలెఙ టుటొలున్ సియతిరా? తోద్, సియెరా! ");
INSERT INTO nit_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","నీర్ కరాబు అంసతిర్ ఎన ఇమ్మె పోరకెరుంఙ్ సోయ్త వస్తులున్ సియెకద్ ఇముంఙ్ ఒర్కి అన్సాద్. అనాయ్ స్వర్గతా ఇమ్మె బాన్, తన్ వెలెకద్ సిమ్కనఙ్ పవిత్ర ఆత్మ తపతోసెటా సియ్‍సాద్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ముకీ అనెక ఒక్కొ మన్కనంతన ముకి బూతున్ పుసుత్ ఎద్గసా అండెద్. అద్ కురియుత్ సెదవెనకత్. ఆమన్కక్ ముడెంఙ్ ఎద్దెంద్, ");
INSERT INTO nit_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","గని ఔర్తన కొన్సెం, “బూతులె దండి బయెల్జెబూలు సక్తినాడ్ ఆ బూతులున్ అముదు పుసుత్ ఎద్గసానాంసాద్” ఇసాముట్టెర్. ");
INSERT INTO nit_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","పెనా కొన్సెం మంది అమ్నె పరిక్స కలెంఙ్‍, అముంఙ్ దెయ్యం తన ఒక్కొ మయ్మత సమత్కర్ ఇడ్. ఇసా వెల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","తె యేసుంద్ ఔరె మంతదున్ ఒర్కిలుత్, ఎది ఎక్కద్ రాజ్యం దుస్మన్ ఎత్నా నసానం ఎర్సాద్, ఎద్ది ఎల్ల ఎక్కద్ అద్నేంద్ అద్ది ఒద్రిలద్. ");
INSERT INTO nit_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","సైతన్‍ తనెత్ తని బయెల్జెబూలు ఎద్దె, అమ్నె రాజ్యం ఎనంఙ్ ఇలెంఙ్ సాలద్? ఇల్లెంఙ్ సాలెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ఇల్లెంఙ్ సాలెద్ నిర్‍అన్న బయెల్జెబూలు సక్తినాడ్ బూతులున్ పుస్సాత్ ఇసా నీర్ ఇసాతిర్ ఎద్గసనంనెద్ ఇంతిరింతె. ఇమ్మె మంది ఎరె సక్తినాడ బూతులున్ పుసుత్ ఎద్గసానాంసార్? అదుంఙ్ ఎత్తినీర్ ఇనెకాద్ తప్ ఇసా ఇమ్మెరి విరోద్‍ కల్సనాంసార్. ");
INSERT INTO nit_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","గని అన్‍మత్రమ్ దెయ్యమ్నె సక్తినాడ బూతులున్ పుసుత్ ఎద్గతె దెయ్యం ఇమత్తివత్న, ఇమ్మెదిల్‍కులెంఙ్ రాజ్యం అడ్గిపెక వెలావత్తిన్ ఇసా కరిపుర్. ");
INSERT INTO nit_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ఒక్కొద్‍ సక్తితద్ తల్వర్ సుముత్ తన్నెఎల్లత బోయ్దలోప కైసానెంఙ్‍, ఎదివెత్తెంఙ్ సాలెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","గని అమ్నుంఙ్‍ ఎన సక్తివంతక్ వాత్న అమ్నున్ వెంటా లడెయ్ కత్నగెల్సద్ అని అముదు బరోసా ఇడుత్ అనెకా తల్వర్కున్ సిమ్కన వెద్‍తెద్. ఆ జయ్జతున్ లుటిపుత్, మరొక్కొరుంఙ్ పాయ్యుత్‍ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","యేసుంద్ పెనా గినా ఇడ్డెకద్ సాలు కతెంద్; అన్నె బాజుంఙ్ అన్నెద్ అముదు అన్న పొయ్‍ సులెంకద్ ఎన్నెంద్. నెరయుత్ అనెకరున్ అన్న వెంటా ఎరి మిరపెర్; అముదు డగ్లిపెకద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“కరెబక్ బూత్ ఒక్కొనత్తన కురియుత్ సెదావెన్కత్, అద్‍ ఈర్‍ తోసెటా ఆజాగత్ అలా పుసత్ ఇసా తిర్గసాద్. గని అలపుసెంఙ్ సాల్సెటా సెత్న, ‘సాయుత్ సెదా ఆ ఎల్లంఙ్ తిర్గుత్ సెరత్‍’ ఇసా ఇంత్తిన్‍. ");
INSERT INTO nit_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","మల్ల సెత్‍ఓల్‍తె ఆ ఎల్లసోయ్‍ చక్కన ఐయుత్న సిమ్కన సావరిపుత్‍ అనెకద్ అదుంఙ్ కండ్కెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","అపుడ తనుంఙ్ ఎన పేలె కరెబాలిక్ పెన్న ఏడ్ బూతులున్ తన్న వెంట సుముత్ వాతిన్. అదాసిమనా ఆ ఎల్లత్ సొగుత్ అనెంఙ్ ఎద్దె. ఇదున్ వాలడ్ అముదు మన్కక్‍నె గత్తి పేలెతదుంఙ్ ఎనా ఇంకాపెరెత్ కరాబ్ ఎద్దిన్ ఇసా ఇడ్‍తెద్.” ");
INSERT INTO nit_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","అనంఙ్ ఇడ్స అనెంఙ్ మందితాన ఒక్కొ పిల్ల, “ఇన్ జల్మ సియుత్ పాల్ ఉర్త అమ్మన్ దెయ్యమ్నె ఆసిర్వాద్ సియ్‍కాద్ ఇసా జోర్‍నాట్ ఇంత్తిన్.” ");
INSERT INTO nit_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","యేసుంద్, “అయ్ గని, దెయ్యమ్నె వచనున్ వింత్న అదున్ సుముత్ ఆడగెకర్ పెనా జాస్తి ఆసిర్వాదున్ సుమ్‍దర్ ఇసా అదుంఙ్ ఇడ్తెంద్.” ");
INSERT INTO nit_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","మన్కకెరె గర్ది పెరెత్ ఎద్దిన్. అపుడ్ అముదు ఇనెంఙ్ ఎదెంద్ ఈ పిడితర్ కరాబూ ఎద్ద కడితుంఙ్‍, మయ్మత సమత్కరుంఙ్ సటీ వెలుత్ ఓల్సనాంసర్ గని యోనాక్నె గొట్టి సివయ్ మారొక్కొద్ ఎది నిసాన్ ఇముంఙ్ ఇడ్డెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","తానుంఙ్ ఇంతె యోనాక్ నినెవె నగుర్‍త నిసన్‍లాంఙ్ అన్సాద్. అనాయ్ స్వర్గత మన్కనె పోరక్ నాయ్ ఈ పిడితరున్ సిన్న లాంఙ్ అన్సాద్. యోనక్ బొద ఇడెంగయ్ నిన్‍వెతర్ తమ్మె పానముత్ సుకిలుత్ అంసార్. ఇండి పంగి ఇలుత్ అనెకా యోనాకుంఙ్ ఎన దండి వలె ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","దక్సిన దేసం రాని తిర్పు దినముంఙ్ జీర్ పంఙితరుంఙ్ వెంట ఇల్లుత్ ఇవ్వుర్ పొయ్ నేరం తప్పెకాద్. అద్ సొలొమోన్ బుద్దిత గొట్టిక్ వినెర్ అదుంఙ్ సటీ న్యాయ్ కలెకా దినముంఙ్ జీర్ వరెకా ఈ పిడితరున్ బరబర్ సులుత్ ఇవ్రు తప్ కత్తెర్ ఇసా విరోద్‍ కత్తిన్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ఎనా గని నీర్ సుకిలెతిర్. అదుంఙ్ సటీ న్యాయ్ కలెకా దినముంఙ్ జీర్ నినెవె నగుర్‍ తార్ సిమ్కన, ఈ పిడితర్ బరబర్ సులుత్ ఇవ్రు గల్‍తి కత్తెర్ ఇసా విరోద్ కల్సర్. అది తిరాడ కాలవెనె బాజుంఙ్ అనెకా దేస్‍ తా రాని యోనా గియనున్ ఇడ్డెకదున్ వినెంఙ్ మన్ బద్లిపుర్. ");
INSERT INTO nit_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ఎరి ఎక్కద్ దీవే తర్పుత్ డపెర్ అని అడ్డెనాడ్ ముచెర్. గని లోపావరెకరుంఙ్ అద్‍ వెలాంఙ్ సియ్‍కద్ ఇసా లంనపొయ్ ఇడ్సర్. కొనొడ పొయ్ ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ఇన్నె మెనుంఙ్ దీవే కడ్ల ఎద్ద కాడితుంఙ్. ఇన్నె కడ్ల సోయ్‍అండెయ్ మెనుంఙ్ సిమ్కన వెలుంఙ్ అందద్. ఆ కడ్ల సోయ్‍ తోసెటా అండె, ఇనె మెన్ పూర సీకటి ఎరద్. ");
INSERT INTO nit_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","అదుంఙ్ ఎత్తి ఈ మున్ లోపా అనెకాద్ వెలుంఙ్ ఎపుడి సీకటి ఎరెంఙ్‍ఇడ్‍సెటా గియనాడ్ ఓలుర్. ");
INSERT INTO nit_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ఇమ్మెమెన్ పూరా వెలుంఙ్ నిండుత్ అండ్డె ఎద్ది బగముత్ ఉచుటినాయ్ సీకటి తోసెటా అద్ బరపుర్ వెలుంఙ్ సియ్సనాందద్. దీవే తరియ్‍సాని ఇముంఙ్ వెలుంఙ్ సియ్‍తెతి ఇమ్మె మెన్ సిమనా వెలుంఙ్ నిండుత్ అన్సాద్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","అనంఙ్ ఇడ్సని అన్నెంఙ్‍, పరుసి జాతితద్ ఒక్కొంద్ “అన్నె ఎల్లంఙ్ తిన్నెంఙ్ వా” ఇసా యేసునున్ కూగ్తెంద్. తెయేసుంద్ సెత్న తినెంఙ్ ఉద్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","పరుసి జాతితర్ సుదుడ్ ఎరెకా నెకిన్ సుముత్, తినెంఙ్ పేలె యేసుంద్ కెయ్యుగెట్టా ఒడెతెంద్ ఇసా ఓలుత్, పరిసయ్ జాతితద్‍ గుల్‍ ఎద్దెంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","అపుడ యేసుంద్ పరుసిక్ వెంటా, “ఇమ్మెఓర్కి తానుంఙ్ బాసొండ్లు, కోజలున్ వాకలడ్ చకనా ఓడ్సతిర్. గని ఇముంన్ లోపా అంసా అని కరాబ్ గునలడ్ నిండుత్ అన్సాతిర్.” ");
INSERT INTO nit_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","దెయ్యం పిసకెరూన్! వాకలదున్ నివ్డిపెకది లోపాలదున్ నాయ్ నివ్డిప్సదా తొదా? అయ్ నివ్డిప్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","గని ఇమంతి అనెకవున్ బర్పుర్ దిలాడ గరిబులుంఙ్ సియ్‍తిరింత్తె, అపుడ దెయ్యమ్నె నెత్తురడ్‍ నీర్ మన్ సాపనేకార్ ఎరతిర్. ");
INSERT INTO nit_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ఎయ్, పరుసిక్ వర్గతర్! ఇముంఙ్ సిక్స సుకిలెద్. తానుంఙ్ ఇంతె నీర్ పుదిన సెట్, జీరె ఎన్నెర్ మిక్తా సిమానాతన పది తన ఒక్కొద్ ఈసా దెయ్యమున్ సియ్‍సానాంసాతిర్. గని న్యాయమున్ అని దెయ్యమ్నె ప్రేమ్ సయ్సనాంసాతిర్. అదవు కల్స ఇదవున్ సాయ్‍సెటఅండిరింత్తె సోయ్‍ అందాద్. ");
INSERT INTO nit_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ఎయ్, పరుసి వర్గతర్! ఇముంఙ్ సిక్స సుకిలెద్. నీర్ యూదులె సావ్డి ఇసాతిర్ అని బాజలెంఙ్ సిమ్కన ఇముంఙ్ మానిపెంఙ్ ఇసా కొర్స‍తమ్. ");
INSERT INTO nit_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ఎయ్! ఇముంఙ్ సిక్స సుకిలెద్. నీర్ కండ్కెర్సెట అనెకా తప్నెలాంఙ్ అన్సార్ తప్నె ఇసా ఒర్కితోసెటా సెత్న, మన్కకెర్ అదవున్ పొలడ్ అడ్సనాంనెర్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","అపుడ ఒక్కొ నియమ్ సాస్త్రి మన్కక్, “గురుజి! ఇనంఙ్ ఇడ్స అమ్మె ఇజతున్ నాయ్ పుత్సతివా” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","తె యేసుంద్, ఎయ్, నియమ్ సాస్త్రి మన్కక్ ఇముంఙ్ సిక్స సుకిలెద్, సొసిపెంఙ్ సల్సెట మొపున్ మందిన్ పొయ్ ఇడ్సతీర్ గని ఆ వేకమున్ సుల్పెకదుంఙ్ నీర్ చిట్కరె వెందెనడ్ దెకుల్ మదత్ కలెర్. ");
INSERT INTO nit_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","అయ్యొ! ఇమ్మె తొలెనితర్ అలుంఙ్త ప్రవక్తకెరున్, నీర్ ఔరె తప్నెలున్ కట్సనంసాతిర్. ");
INSERT INTO nit_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","కరెయ్ నీర్ సాక్సులాంఙ్‍ ఇమ్మె తొలెనితర్ కత్త పనికున్ పారిప్స నంసాతిర్, ఎనంఙ్ ఇంతె ఔర్ అలుంఙ్ తెర్ నీర్ తప్నెలున్ కట్సతీర్. ");
INSERT INTO nit_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","అదుంఙ్ సటీ దెయ్యం తన్నె గ్యానడ్ ఇడ్డెకద్ తానేదింతె, అన్ ఔర్వై ప్రవక్తకెరున్ అని కబుల్లాకెర్ పన్కసాత్. ఔర్ కొన్సెం మందిన్ అలుంఙ్తెర్ అని పెనా కొన్సెం మందిన్ సిక్స సియ్‍తెర్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ఈ తిరాడ ఈ దున్యత బునదినె అర్తం అపుడ్‍తన సదర్ ప్రవక్తకెర్ అల్ఙెకంద్ అదుఙి, ఈ పిడితర్ జిమెదల్ నిరి. ");
INSERT INTO nit_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","హేబెలున్ నెత్తుర్ రాడ్ మోదల్‍ ఎత్న, బావ్‍ సియెకా బొలాత్ అని గుడి నడ్డుమున్ కుటా జెకర్య నెతుర్ పయ్‍తర్, అవ్రి సిమనా మందినె నెత్తుర్‍నె జమా ఈ పిడితరి సుమ్మెంఙ్ పాజె ఇసా ఇడ్సనాంసాత్. ");
INSERT INTO nit_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ఎయ్ నియమ్ సాస్త్రి మన్కక్ ఇముంఙ్ సిక్స సుకిలెద్. గియన్ వాలె ఎల్లత కిల్లి ఇమ్మతిని ఇట్టిర్. నీర్ లోపా సొంఙెతిర్ అని సొంగెకరున్‍నై నీర్ సొంగెంఙ్ ఇడెతిర్ ఇసా యేసుంద్ ఔరుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","అనంఙ్ ఇడ్‍తెంద్ అపుడ్‍తన నియం సాస్త్ర గురు, పరుసిక్ యేసుకున్ ఉల్ట ఎద్దెర్ అని అమ్నున్ దుస్క సియ్‍సా, సవల్క వెలుత్ తొలెంఙ్‍ మోదలింటెర్. ");
INSERT INTO nit_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","యేసున్ పొయ్ కుర్ర ఇటెర్. అని అముదు ఇడ్డెకా గొట్టి క్లంత్తి తప్‍రొబపుత్ సుమ్‍నర్ ఇసా ఓల్సనాంనెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","మల్ల హజార్ మన్కకెర్ మిర్యతెర్ తె గర్ది ఎద్దిన్ అని ఒక్కొనెత్ ఒక్కొద్ విద్గెంఙ్ ఎద్దెర్. అపుడ యేసుంద్ పేలె తన్నె సిసులున్ ఇనెంఙ్ ఎద్దెంద్. కప్టి పరుసి మన్కకెర్ పసెంఙ్ కలెక పుల్లె పిండి మంజె ఔరె కపటున్ బదోల్ ఉసరడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ఔర్ కలెకా పనిక్ అని డపుత్ అనెకా ఎదవీ వకాకురియ్‍చెటా డపుత్ అనే. తానుంఙ్ ఇంతె డపుత్ ఇడ్డెకా సిమ్కన గినా ఒర్కి పడ్‍దా. ");
INSERT INTO nit_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","అదుంఙ్ ఎత్తి నీర్ సీకటిత్ ఇడ్‍ తా హర్ ఒక్కొ వెలంఙుత్ విన్క వరద్. లోప కోలిత్ కుసీ ముడ్సా ఎల్లపొలడ్ ఇడ్సా. ");
INSERT INTO nit_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","అన్నె సంఙ్తకెర్! ఇముంఙ్ ఇండెకాద్ తానెద్ ఇంతె, మెనున్ అంల్ఙెకరున్ అర్సనెర్. తిక్తవెన్కత్, ఔర్ తనయ్ కలెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","గని తిక్తా వెన్కత్ న్యాయ్‍ ఇమున్ నరకమ్‍త తపెకా అదికార్ తా దెయ్యమున్ అర్సుర్. సిరిప్ అమ్నుని అర్సెంఙ్ ఇసా ఇముంఙ్ ఇడ్సనాంసాత్. ");
INSERT INTO nit_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","ఐద్ పైసె పిట్టా ఇదపైసెలుంఙ్ సుమెరియె? తప్పతోసెటా సుమ్‍తెర్. గని అత్రనటా ఒక్కొదున్ నాయ్ దెయ్యం మదెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","గుల్ పేలె పిట్టలుంఙ్ ఎన్నాజస్తి విల్వతర్ ఎన్నిర్. ఇమ్మె తల్లుత్ అనెకా తిల్ గినా లెక్కుత్ అంసా. అదుంఙ్ ఎత్తి నిర్‍ అర్సనెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","అన్ ఇడ్డెకాద్ తనెద్ ఇంతె, ఎది ఎక్కద్ అన్ బదోల్ ఒర్కియ్ ఇసా సిమనా మందిన్ ముండట్ కబులిల్తెందింతె, మన్కనె పోరక్ నాయ్ అముదు ఒర్కియ్ ఇసా దెయ్యమ్నె దూత్ లుంఙ్ ముండట్ కబులిల్‍తన్. ");
INSERT INTO nit_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","గని పబ్లిక్‍ ముడట అన్న కబులిదద్ అమ్నున్ అన్ నాయ్ దెయ్యమ్నె దూత్ ముండట్ అమ్నున్ కబుల్ కలెంఙ్ ఇసా ఇడ్సనాంసత్. ");
INSERT INTO nit_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","మన్కనె పోరక్ ఎది తిప్పుత్ ముడ్‍దద్తె, అమ్నుంఙ్ మాప్ రొంబాడద్. గని పవిత్ర ఆత్మన్‍ దుసన్ ఎరి తిపుత్‍ ముడ్దర్తె అమ్నుంఙ్ మాప్కల్. ");
INSERT INTO nit_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","మన్కకెర్ ఇముంన్ యూదులె సావ్డి సుముత్‍ కొస్తె, దండిక్, అడ్గిపెకాంద్, అదికాల్ ముండట్‍ ఇమున్ న్యాయ్ కలెంఙ్ కొసెంఙ, ఎనంఙ్‍, తానెద్ ఇడ్దున్ ఇసా పరిసాన్ ఎన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","తానుంఙ్ ఇంతె నీర్ తనెన్ ఇడ్డెకాద్ ఇనెకద్ పవిత్ర ఆత్మ అద్ది వెలంఙ్ ఇమ్ముంఙ్ కర్పసాద్ ఇసా ఇడ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ఆ మంది తన ఒక్కొద్, “గురుజి! బాంద్ కమయ్ కత్త జాయ్జతున్ పైయ్ ఇసా అమ్మె దాదక్ కున్ ఇడ్డ” ఇసా ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","అపుడ యేసుంద్, “దాద కేర్! ఇమ్మె తస్వ కలెఙ్ తోద్‍తె ఇమ్మె నాడుమ్‍ ముడెకాంద్ పుత్తెంఙ్ అన్న ఎరా నెమిప్‍తెర్?” ఇసా అమ్నున్ వెలుతొల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","మల్ల యేసుంద్ మాందిన్ వెంటా, “విడ్ర! నరిమన్కక్నె పానం కద్ పెరెత్ దాన్ కామప్తదున్ పొయ్‍ అదర్‍ఎత్ తోతెద్. లాలుసాడ్ అనెకర్ గియానాడ్ అడ్ర” ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","అని ఔరున్ పెనా ఒక్కొ ఉదహరన ఇనంఙ్ ఇడ్డెకాద్ సురు కతెంద్. ఒక్కొ దనవంతక్ అండెద్. అమ్నె కేనుత్ పెరెత్‍ పట్ట పండ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","అపుడ అముదు తన్నెత్ తని ఈ పట్టాత రాసిన్ ఇడెంఙ్ జాగా తోతెద్. ఇండి తాగలుడ్? ");
INSERT INTO nit_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ఇసా గుమ్మిత్, ఇనంఙ్ అమ్నె మనుంఙ్ వత్తిన్. తన్నెద్ ఇంతె పాత సిమనా గొదములున్ కర్బకత్న, అదవి జాగలెంఙ్ దండి గొదమూ కట్టుత్న, పట్ట నె రాసిన్ అని అన్నె వాస్తులున్ ఇడత్. ");
INSERT INTO nit_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","అపుడ్‍ అన్నె పానమున్ వెంట, అన్నె పానం నివా అన్ ఇనుఙ్ పేలె సాల్కులుంఙ్ సటీ ఆస్తి కమయ్ కత్న ఇట్టాన్. సుకమడ్ అన్, తిన్, ఉన్ అని అనంద్ కాల్ ఇసా ఇడ్తన్‍ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","గని దెయ్యం అమ్నున్, యే పిస! ఈ సింతే ఇన్నె పానం సెరద్. అపుడ నీ కమాయ్ కత్ తా ఆస్తి ఎరెత్ ఎరాద్? ఇసా వెలుత్‍ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","దెయ్యమున్ సాయుత్న, కారబులున్ పొయ్‍ లక్స సియెకనే గతి ఇనంఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ఇనంఙ్ ఇడుత్ యేసుంద్ తన్నె సిసులున్ ఇనంఙ్ ఇంతెంద్, “అదుంఙ్ ఎత్తి అన్ ఇడ్డెకద్ తన్నెద్ ఇంతె బత్కెకదుంఙ్ తన్నెన్ తినేకాద్?” అమ్మె పానమ్ తన్నెన్ తోడెకద్? ఎనెంద్ తొడ్దుమ్ ఇస ఇమ్మె సరీరున్ ఇసా సింత కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ఇమ్మె పానం తిన్నెకదుంఙ్ ఎన ముక్యమ్ అన్సాద్. మెన్త జుఙ్ఙెలుంఙ్ ఎన కిమత్‍ తాద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","కాకా ఓలుర్. అదా వితన తప్పె. పంటన్ కిసే. గుమ్మిత్ తన్నెవి తిన్నెకా తొతే. దెయ్యం అదవుంఙ్ తినెంఙ్ పురప్‍సాద్. నీర్ ఆ పిట్టలుంఙ్ ఎన కిమత్తర్ అన్సాతిర్. ");
INSERT INTO nit_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","చిమ్ననంఙ్ సటీ చింత కత్న తమ్మె పానమున్ ఒక్కొ గంట వడిపెకర్ ఇమ్‍త్తి ఎరేనా అన్సారా? ");
INSERT INTO nit_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","నీర్ ఇంతె చినమున్ కలెంఙ్ సాలెర్ అదున్ బదోల్ తనుంఙ్ విచార్ కల్సతిర్? ");
INSERT INTO nit_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","పుత ఎనంఙ్ పెర్గసావొ ఓలుర్. అదా పని కలే. జుఙ్ఙే అల్లె. ఎన తన్నె సొబాన్‍ పూరతి ఇంతె సొలొమోన్ రాజక్‍ తొడేకా మాగ్త జుఙ్ఙెలున్‍ నాయ్ ఏ పూతంఙ్ నాయ్ సామనం తొతేద్. ఇసా ఇడ్తన్. ");
INSERT INTO nit_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ఇమత్తి ఉసిటినయ్‍ విస్వాసం తొత్తెదా? ఇన్నెడ అత్న వెగెడ్‍ కిసుత్ వేయ్యెకా గడ్డిని దెయ్యం అంతే సోయ్ ఓల్తెంద్‍ తా! మరీ ఇమున్ ఎంత్తె సోయ్ ఓల్‍దాద్‍ ఎర్ర విచార్ కలుర్. ");
INSERT INTO nit_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","అదుంఙ్ ఎత్తి తన్నెన్ తిందుమ్, తన్నెన్ ఉందుమ్ ఇసా విచార్ కంన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","దున్యత్ అనెకార్ ప్రతి ఒక్కొద్ అదుంఙ్ సటీ తడ్లడ్‍సార్. ఇమ్మె బానుంఙ్ ఇముంఙ్ తనెద్ పాజె హొ ఓర్‍కియ్. ");
INSERT INTO nit_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","అమ్నె రాజ్యం మున్, నీతిన్ జటిలుర్. అపుడ్ దెయ్యం ఇముంఙ్ ఇదవున్‍ నాయ్ సియ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“నీర్ అర్‍సెకా చిన్నం మందలంఙ్. గని అర్సనెర్. ఇమ్మె బాంద్ తన్నె రాజ్యమున్ ఇముంఙ్ కుసినడ్ సియ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ఇమ్మె ఆస్తిన్ విరుత్న గరిబులుంఙ్ దర్‍మమ్ కలుర్. ఎపుడి అనెకద్ ఆస్తిన్ తయార్ కలుర్. ఇమ్మె దనమున్ పరలోకముత్ డపుర్. అత్తి అదా కరాబ్ ఎరే డొంఙా అదవున్ పుడ్‍కెర్. ఆ ఆస్తిన్ సెదాల్ తిన్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ఇమ్మె దనం అనెకార్వైనీ ఇమ్మె మన్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“ఇమ్ దీవేలున్ తర్పుత్ తయరాడ్ అండ్ర. ");
INSERT INTO nit_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","పెండ్లిఙ్ సెత్న ఎల్లంఙ్ వరెకా మాల్కకుంఙ్ సటీ కయ్‍సా అనెకా సేవకెర్ లంఙ్ అడ్ర. అనంఙ్ కత్తె మాల్కక్ వత్న గుయ్యున్ కుడకెంగాయ్ అమ్నుంఙ్ సటీ నీర్ గుయ్యున్ పుసెంఙ్ సాలతిర్. ");
INSERT INTO nit_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","మాల్కక్ వరెకా వెలంఙ్ ఉసార్ అనెకా సేవకెర్ దన్యులు. ఇద్ కరెయ్. ");
INSERT INTO nit_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","అముదు ఏ సార్సమలెయో మరి కోరుకుతంఙ్ వరెంఙ్ తయరుత్ అనెకా సేవకెర్ మంసెట అనెకద్. ఔరుంఙ్ సోయ్ జర్గిలద్. అనెకదున్ ఒల్సదొ ఆ సేవకెర్ దన్యులు. ");
INSERT INTO nit_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","గని ఇదున్ అర్తం కలుర్. డొంగ ఏ వెలంఙ్ వర్‍సాదొ ఎల్లత మాల్కకుంఙ్ ఒర్కిఅండె తన్నె ఎల్లంఙ్ డొంఙా వరెంఙ్ ఇడెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","నిర్‍నాయ్ తయరడ్ అడ్ర. తానుంఙ్ ఇంతె మన్కనె పోరక్ ఇముంఙ్ ఒర్కి తోసెటా వెలంగి వార్‍సాద్.” ");
INSERT INTO nit_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","పేతురు, “ప్రబు! నీ ఈ ఉదహరన్ అముంఙ్ సటీ ఇడ్‍సాతివా సదర్‍ మందింఙ్ సటియే?” ఇసా వెలుత్ ఓల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ప్రబుంద్ ఇనంఙ్ సామదనం ఇడ్‍తెంద్. తెలివి అనెకా ఇమన్దర్ సేవక్ ఎందా? ఆ మాల్కక్ మల్ల వతెంద్ ఇంతె తన్ బరొస తరుంఙ్, తెలివి అనెకరుంఙ్ తన్నె మరొక్కొర్ సేవకెరున్ సోయ్తదున్ తిన్నెంఙ్ సియెకాదుంఙ్ ఔరున్ పొయ్ అదికార్ లంఙ్ సియ్దద్. ");
INSERT INTO nit_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ఆ మాల్కక్ వతెంద్ ఇంతె, అముదు ఇడ్‍తెత్తి అడ్‍గెకా సేవక్ దన్యుడు. ");
INSERT INTO nit_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ఇద్ కరెయ్. ఆ మాల్కక్ అమ్నె సేవక్నె ఆస్తి సిమ్కన అదికార్ లంఙ్ నెమిప్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","గని ఒక్కొ వెల ఆ గడియాక్ రప్తిరా తన్నెత్ తనీ, అన్నె మాల్కక్ జల్‍ది వారెద్ ఇసా మన్నుత్ ఇత్న తనుంఙ్ బూడున్ పని కలెకారున్ మర్కమ్ ఎరెంగయ్ ఎద్ది విచార్ కల్‍సెటా దన్‍పుత్, తిన్త్నా ఉన్నెకాద్ మోదల్ ఇడ్‍సాద్ ఇడ్ర. ");
INSERT INTO nit_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","మాల్కక్నె ఆసేవక్ పావొలెకా దినా పత్తతోసెట వత్న తరుగ్సాత్ ఇసా అర్పులిపుత్ ఆ సేవకున్ విస్వాస్ తోసెటార్ గుంపుత్ సెరెంఙ్ ఇడ్‍దద్. ");
INSERT INTO nit_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","తన్నె మాల్కక్నె మన్నున్ ఒర్కిలుత్ గినా, అమ్నుంఙ్ మనుంఙ్ తోసెటా పని కలెకా సేవకుంఙ్ ఎక్కువ పెట్ల తక్ తా. ");
INSERT INTO nit_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","గని ఒర్కి తోసెటా కరాబ్ పనిక్ కత్తనుంఙ్ కామ్తి పెట్ల తక్ తా. దెయ్యం తముంఙ్ ఎక్వ సియ్తన్ తన కొన్సెమి వెల్‍దంద్. పేరెత్ సియ్‍త నంతనట్ సియ్‍తదుంఙ్ ఎన ఎక్వ వెల్‍దంద్. ");
INSERT INTO nit_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","అన్ ఈ బూమి పొయ్‍ కిస్‍ ఇడెంఙ్ వత్తన్. ఆ కిస్ ఇత్తింఙ్ ఎంత్తి అనెంఙ్ ఇసా అసా కత్తన్. ");
INSERT INTO nit_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","గని అన్ సుమెకా కటింత బాప్తిస్మ అన్సాద్. అద్ జర్గిల్‍నంతెంఙ్ అన్నె సింత సుకిలెద్. ");
INSERT INTO nit_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","సాంతిన్ సియెంఙ్ అన్ ఈ బూమి పొయ్‍ వత్త నీసాతిరా? తోద్. ఇదున్ పయెంఙ్ వతన్. ");
INSERT INTO nit_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ఇండితన ఒక్కొకుటుంముత్ ఐద్‍గుర్ అండే, ఔర్ పయుత్న, ముగ్గుర్ ఒక్కొవై ఎద్దె ఇద్దర్ ఒక్కొవై. ఇద్దర్ ఒక్కొవై అండే ముగ్గుర్ ఒక్కొవై ఎత్న జగ్డా కాదర్. ");
INSERT INTO nit_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","బాన్ద కీకెనాడ్, కీకె బానాడ్, అమ్మ కొంమలడ్, కొంమ్మ అమ్మనాడ్, పొద కొర్రలడ్, కొర్ర పొదలడ్ జగ్డా కాదర్. ");
INSERT INTO nit_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","యేసుంద్ అత్తి అనెకా మందిన్ వెంటా, “నీర్ పొద్ ఉర్కెకావై ఆబార్ డమ్మ ఎరెకావున్ ఓల్‍ తా వెంటాయ్ వన వత్తిన్ ఇసా ఇందత్తిర్. ");
INSERT INTO nit_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","దక్సిన వాలడ్ గలివరెంఙయ్, ‘వేడి ఎక్‍వా ఎర్సద్’ ఇసా ఇసార్. నిర్‍ ఇం త్త్తెతియ్‍ ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","యే! కప్టిక్! బూమి అని ఆబారున్ ఓలుత్న, ముదర్వై జర్గిలెకవున్ ఇడ్సాతిర్. గని దెయ్యం ఇండిత కలముత్ కలెకావున్ ఓలుత్, తనుంఙ్ బరబర్ సమ్జిల్సెటా తోతెరే?” ఇసా ఔరుంఙ్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","పెనా యేసుంద్, “ఇమ్మెత్‍ నిరీ ఎద్ నీతి ఇనెకద్ తనుంఙ్ న్యాయ్ కాలెరె? ");
INSERT INTO nit_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ఇమ్మె బెయ్‍మాన్‍దర్ ఇమ్మున్ తస్వ కలెకన్‍వై తివ్సా కొసెంఙ్, నడుమ్ పావుత్ అమ్నున్ వెంటా మిరయెంఙ్ ఓలుర్. తొద్తె ఇమ్మున్ తస్వకలెకాద్ ఇమున్ జెల్త అదికారినె కెయ్యుత్ అవలి కాల్సాద్. అముదు అదికారి ఇమున్ కొసుత్ జేలుత్ తప్దాంద్. ");
INSERT INTO nit_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","అపుడ్ ఆక్రిత పైసె బర్పయ్ కన్నంతెంఙ్‍, కరెయ్‍ అన్ ఇముంఙ్ ఇడ్సాత్ నీర్ జెల్ తాన కురియెర్” ఇసా ఔరుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","కొన్సెం మంది గలిలీయత మన్కకెర్ మందిరుత్ బావ్ సియ్యెఙా పిలాతు తన్నె సైనికులున్పనుకుత్ ఔరున్ అలుంఙ్ తేర్. మందినె నెత్తుర్ అని జన్వల్లె నెత్తుర్ కలయ్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","తె యేసు, “ఔరె ఇనంఙ్‍ ఇంతెంద్‍ ఇ గలిలియతర్ సిరొపులకెరి గలిలీయతర్ సిమ్కనంఙ్ ఎన ఎక్కువా పాప్ కత్తెర్ ఇసాతిరా?” ");
INSERT INTO nit_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","గని ఔర్ కలెతెర్ ఇసా అన్ ఇంతన్. పాప్‍తన కబలిల్సెటండె నీర్ నాయ్ మన్ బద్లిపుర్. ");
INSERT INTO nit_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","అనాయ్ సిలోయంత మడి ఒద్రిలుత్ తిక్తార్ ఔర్ అట్ర మందినె గొట్టితదున్ తనెద్ ఇసాతిరె? యెరూసలేముత్ అనెకర్ సిమనా మందింఙ్ ఎనా ఎకావ పాప్ కత్తెర్ ఇసాతిరా? ");
INSERT INTO nit_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","గని ఔర్ కలెతెర్ ఇసా అన్ ఇసాత్. పాప్‍తన మన్ బద్లిపుర్ అండె నీర్ నాయ్ అనాయ్ నాసానం ఎరతిర్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","అనంఙ్ ఇడ్త వెన్కత్ యేసుంద్ ఈ ఉదహరన ఇడ్తెద్. ఒక్కొ మన్కక్ తన్నె వాడిత్ ఒక్కొ మేడి మాకు ఎదప్తెద్. అదా పెర్గత వెన్కత్ అపుడ్ అపుడ్ ఆదవై సెత్న, పండ్లుంఙ్ సటీ ఓల్‍నెద్. గని అంమ్నుంఙ్ ఎపుడి పండ్లు కండ్కకెరెతె. ");
INSERT INTO nit_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","తె అముదు మాల్కక్ గడియకున్ వెంటా, “ఇదెఓల్ ముది సాల్కుతన ఈ మేడి మాకులత్తి పండ్లు కయెతిన్. ఈ మాక్ పెర్గుత్ అగమి వాడి తా జాగన్ అగొటిప్స నాంసాద్. ఇదున్ కత్కుత్ జొపిడ్!” ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","తె అముదు గడియక్, మాల్క! ఈ సాల్ అద్ అనెంఙ్ ఇడ్. మాకుంఙ్ తిర్‍గొరా వపాకత్న కత్ వాఙాత్. ");
INSERT INTO nit_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","వారెకా సాల్ కయ్‍తిన్‍ ఇంతె సోయ్ గొట్టి. కయ్‍సెటా అండె నీ అదున్ కత్కుత్ జొపిడ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ఒక్కొ ఆలపుసేక జీర్ యేసుంద్ యూదులె సావ్డిత బొద ఇడ్‍సానాంనెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","అత్తి అట్ర సాల్కుతన బూత్‍ సుమ్ముత్ బేమరినాడ్ ఒక్కొ పిల్ల అండిన్. అద్ బెమరినడ సార్కక్ ఇలెంఙ్ వర్సెటా ముల్కె గుడలుతి అదా. ");
INSERT INTO nit_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","యేసుంద్ అదున్ ఓలుత్ తన్నా మెరా కూగుత్, “బాయి ఇన్నె బేమరితన సోయ్‍ ఎర్!” ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","అని అదున్ పొయ్ కెయ్యు ఇట్టెద్ అనంఙ్ ఇడెఙాయ్ అద్ సార్కక్ ఇల్‍తిన్. వెంటని అద్ కుసీ కలెకద్ దెయ్యమున్ స్తుతి కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","ఆలపుసేక జీర్ యేసుంద్ ఆ పిల్లన్ సోయ్ కంత్త కాడితుంఙ్ ఆ సావ్డిత అదికారింఙ్ దండి రగ్ వత్తిన్. తె అముదు మందిన్ వెంటా, “వారముంఙ్ ఆర్ దినా పనికలెంఙ్‍, అన్సా. ఆ దినాలుంఙ్ ఎపుడనాయ్ ఒక్కొజీర్ వాత్న, సోయ్‍ ఎర. గని ఆలపుసేక జీర్ ఎన్నెర్” ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","అపుడ్ యేసుంద్ యె కప్టిక్! ఇమ్మ తాన ఎరి కొదలున్ ఎక్కద్, గాడ్దిన్ ఎక్కద్ ఆలపుసేక జీర్ ఎరి ఎక్కద్ కొడ్కా తన సాయుత్, యిర్ ఉర్తెంఙ్ తొదా? తప్పతోసెటా కొస్తిర్! ");
INSERT INTO nit_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ఆట్ర సాల్‍తన బూత్ అంట్‍తా ఆ పిల్ల అబ్రాహామ్నె సంతాన్ ఎరెకా ఈ పిల్ల, ఆలపుసేక దినాముంఙ్ జీర్ సైతన్నె కెయ్తన సోయ్ ఎరెతినా? ఇసా వెలుత్ ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ఆ గొట్టిక్ వింత్న అమ్‍నె దుస్మండ్ల సిర్‍మింద్ ఎద్దెర్. గని అత్తి అనెకా మంది అముదు కత్త మహిమత కాములుంన్ ఓలుత్ కుసీ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","అనంఙ్ ఎద్దా వెన్కత్ యేసుంద్, “దెయ్యమ్నె రాజ్యం ఎనంఙ్ అన్సాద్? అద్ తానెద్లంఙ్ అన్సాద్ ఇసా ఇడుడ్? ");
INSERT INTO nit_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","అద్ ఇనంఙ్ అన్దద్. ఒక్కొ మన్కక్ తన్నె వాడిత్ మోర్యిదనెన్ తప్తెంద్. అద్ పెర్గూత్ దండి సేట్ ఎద్దిన్. ఆబార్ పొల పిట్టా ఆ మాక్ కొమ్ములెంఙ్ తుప్ప కల్సా. దెయ్యమ్నె రాజ్యం గిన అనాయ్ అన్సాద్” ఇసా ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","అని పెనా గినా యేసుంద్, దెయ్యమ్నె రాజ్యం తానెద్ లంఙ్ అన్సాద్ ఇసా ఇడ్‍తెద్? ");
INSERT INTO nit_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","అద్ ఇనంఙ్ అంన్సాద్. ఒక్కొ పిల్ల మూదీ అడ్డె పిండి బొకిపుత్న పుల్లె వారెకా వస్తు ఉసుటి తప్‍తిన్ తె అద్ పూరా పిడ్డిత్ నెర్యతిన్. దెయ్యమ్నె రాజ్యం అనాయ్ అన్సాద్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","అనంఙ్ ఎద్దా వెన్కత్ యేసు పట్నములెంఙ్ అని ఉలెంఙ్ తిర్గసా, బొద కాల్సా యెరూసలేముంఙ్ సెసా అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","అపుడ ఒక్కొ మన్కక్, ప్రబు! పాపమ్ తన బత్కెకర్ కొన్సెమి మందియా తనెదె? ఇసా వెలుత్‍ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","గూల్ మంది కుతుడ్కె బొయ్ద సొంఙెక అన్సాద్. ఆ దర్యొజ తన సొంగెంఙ్ పెరెత్ కోసీద్ కాలుర్. పేలెటర్ ఆ దర్యొజ తన సొంగెంఙ్ తక్సెటా ఓల్సార్. గని ఔరడ్ ఎరెంఙ్ సాలేద్. ");
INSERT INTO nit_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","అపుడ్ ఆ ఎల్లత మాల్కక్ సులుత్, కవాడున్ గెంసాద్. అనంఙ్ ఎద్ద వెన్కత్ నీర్ వాకా ఇలుత్, మల్క! మల్క! అముంఙ్ సటీ కవడున్ పుసా ఇసా కవడున్ కుడుకెంఙ్ మోదలెందెర్. అపుడ అముదు మాల్కక్ నీర్ ఎరెంనిరొ, ఎత్రనాట్ వత్తిరొ, అనుంఙ్ ఒర్కి తొదా ఇసా ఉత్తర్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","అపుడ్ ఔర్, ఇన్‍వెంటా తిందమ్ ఉడమ్. నీ అంమ్మె పట్నలెంఙ్ బొదగినా కత్తి ఇసా ఇడెంఙ్ మోదలింటి. ");
INSERT INTO nit_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","గని ఆ మాల్కక్, నిర్‍ ఎరెంనిరొ అని ఎత్రనాట్ వాత్తిరొ అనుంఙ్ ఒర్కి తోద్. కరాబ్ పనిక్ కలెకర్! నీర్ సదార్ అనం తాన సెర్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","అపుడ అత్రనాట్ ఓలెంఙ్ ఇముంఙ్‍, అబ్రాహామ్, ఇస్సాక్, యాకోబ్‍ అని సిమ్కన ప్రవక్తకెర్ దెయ్యమ్నె రాజ్యం ముత్ కండ్కెర్సార్. గని నీర్ అత్తి వాకలి అంత్ అత్తి పల్కు కొర్కసా గుల్‍ నొపినాడ్ అర్సా అదత్తిర్. ");
INSERT INTO nit_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","పెన పొద్కురినవాయ్ అని పొద్ ఊరుక్నవాయ్ దెయ్యమ్నె రాజ్యం ముత్ తినెంఙ్ ఉద్సతీర్, మరొక్కొ మన్కకెర్. ");
INSERT INTO nit_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ఇదె విండ్ర! ఆక్రి అనెకర్ పేలె ఎద్దార్ పేలె అనెకకార్ ఆక్రి ఎద్దర్ ఇస యేసు జవాబ్ సియ్యతేద్. ");
INSERT INTO nit_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ఆ వేలఙ్ కొంచెమ్ మంది పరుసిక్ యేసున్ వెంట వత్న, హేరోద్ ఇన్ అల్‍ఙెంసా ఓల్నెర్. ఇత్తరనట్ సయుత్ సే ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","తే ఔర్‍వెంటా యేసుంద్ ఈ దినాలుంఙ్ జీర్ బూతులున్ పూసుత్‍ ఎద్గసా దుక్కం అనెకరుంఙ్‍ సోయ్ కల్సాత్. మున్ది దిన ఎద్దవెన్కత్‍ అన్నె కార్యి బార్పుర్‍ కత్‍అంసత్ ఇసాద్ ఇసా కొయ్లక్లాంఙ్ హెరొదున్వై సెత్న ఇడ్డుర్‍ ఇసా ఇసాద్‍. ");
INSERT INTO nit_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ఏనాగని అన్ ఇన్నెడ్, వెగేడ్ ఆని మర్నెడ్‍ యెరూసలేమ్ జత్ర కల్సనిసెరెగ్‍ఎద్దెర్‍. తనుంఙ్ ఇంతే పక్త యెరూసలేముతీ ప్రవక్తకెరూన్ అలుంఙ్ తేర్. ");
INSERT INTO nit_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","యే! యెరూసులేంతరా! నీర్ ప్రవక్తకెరూన్ అలుఙస నీ బగవత్తక్ ఇమ్‍వై పావిటరున్ గుండ్లాడ్ లగాప్స అల్ఙెకాద్ కోర్‍ తత్నే పిట్టలున్ మెర కక్తెతీయ్‍ ఏన్నిగుసల్ ఇమున్‍ మెర కలెంఙ్ ఇసా ఓల్తద్. గని నిర్‍ ఓప్పెతిర్‍. ఇదె విడ్రి! బగవన్తక్‍ ఇంమే నగురున్‍ పడ్ ఎరెంఙ్‍ సాయ్‍తెద్. యెహొవనే ఆదికరడ్ వరెకనుఙ్‍ బగవన్‍తక్‍ ఆసీర్వద్‍ సీయ్కద్‍ ఇసా నిర్‍ ఇనంత్తెంఙ్, కరెయ్‍ అన్ పెన ఏక్కొసట్‍ ఓలేర్‍ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","ఇన్నె పార్తన జాగ ఇనుంఙ్ సటీ ఇన్నె పార్తన జాగ దెయ్యమ్నె పార్తన జాగ. ప్రబునె పేరడ్ వతద్ దాన్యుని ఇన్నంతెంఙ్ నీ అన్‍ ఓలెవ్. ");
INSERT INTO nit_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ఒక్కొ ఆలపుసేక దినం అముదు ఒక్కొ పరుసిక్ దండినె ఎల్లత్ జెవున్ తినెంఙ్ సెదెద్. అత్తి అంనున్ సిమ్కన మంది ఒల్సర్. ");
INSERT INTO nit_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ఒక్కొ ఆరం జీర్‍ పరిసాయులత్తద్‍ ఒక్కొద్ అదికార్నే ఎల్లంఙ్‍ జెవొన్ కలెఙ్‍ యేసుంద్‍ సెద్దెంద్. అత్తీ అనెకర్ అమ్నుఙ్‍ గియనడ్ ఓల్సనంసార్‍. అత్తీ ఒక్కొద్‍ మెన్ ‍ వయ్యేకా దుక్కమాడ్ యేసున్వై వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","తే యేసుంద్ అత్తి అనెకా సాస్త్రిక్‍ అని పరుసిక్ ఓలుత్. నియమ్ సాస్త్రనే నియమున్‍ సుమూత్‍. ఆలపుసేక దినముంఙ్‍ జీర్‍ దుక్కలకెరున్‍ సోయ్‍ కలేకదా? తొదా? ఇసవెల్తొల్తెద్‍. ");
INSERT INTO nit_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","గని ఔర్‍ దాబ్‍ అండేర్‍. తే యేసుంద్‍ అముదు‍ వైయెక దుక్కంతనున్ పూడుకుత్నా. సోయ్‍ కత్తంద్. అని అత్తరన అనున్‍ పన్క్తేద్. ");
INSERT INTO nit_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","అపుడ్‍ యేసుంద్‍, ఆలపుసేక దినముంఙ్ జీర్‍ ఇన్నె కీకె ఎకాద్‍ కొద ఎకాద్ నువిత్‍ రాటే, నీర్‍ పుసెరా? ఈసా ఔరూన్‍ వేలుత్‍ ఓల్తేద్‍. ");
INSERT INTO nit_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","అదూన్‍ ఔర్‍ తానై జావబ్‍ సియెంఙ్‍ సాలేతెంద్‍ ");
INSERT INTO nit_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ఆ జెవున్ ఇట్టార్ సూట్టా ఉద్దెకా సోయ్త జాగన్ ఆస్తదున్ ఓలుత్, యేసుంద్ ఔరున్ ఉదహరన ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ఎరి ఇమున్ పెండ్లి జెవునుంఙ్ కుగ్‍తె, దొడా ఉదెకా జాగత్ ఉద్నెమ్. తనుంఙ్ ఇంత్తే ఎల్లతర్ ఇనుంఙ్ ఎనా దొడలున్ కుగ్తెర్ ఎరాత. ");
INSERT INTO nit_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","అనంఙ్ ఉద్‍తివింత్తె సిమ్కనన్ కుగె‍కా మన్కక్ ఇన్‍వై వాత్న, ఇత్తీ ఇమ్నున్ ఉదెంఙ్‍ ఇడ్ ఇసా ఇనెంఙ్ వారెదా. అపుడ్‍ నాయ్ సిర్‍మిందీ ఎత్న ఆక్రి అనెకా జాగత్ ఉదెంఙ్ పడ్సద్. ");
INSERT INTO nit_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","అదుంఙ్ ఎత్తి ఇమున్ ఎరి కుగ్‍తె, ఆక్రి అనెకా జాగత్ ఉదా. అపుడి ఇన్‍ కుగెకాద్ ఇన్‍వై వాత్న, అన్నె దొస్తు! ఆద్ దొడా ఉందెకా సోయ్త జాగత్ సెత్న ఉద్ ఇసా ఇడ్‍తెర్. ఆ వేలంఙ్ ఇన్‍ బరబర్ ఉదెకార్ ముండట్ ఇనుంఙ్ దొడంద్ మాన్ రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","తన్నెత్ తాని దండి ఎరెకాద్ సినామ్ ఎద్దాద్ అని తాన్నెత్ తాని సినామ్ ఎరెకాద్ దండి ఎరెకాద్ వారద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","అపుడ్ యేసుంద్ తన్నా కుగ్‍తన్ వెంటా, సిత్తె, ఎకద్. తొల్లి ఎకాద్ జెవుంన్ కాలెంఙ్‍, ఇన్నె దొస్తులున్ ఎక్కద్, ఇన్నె దాదక్ తొరెంద్ ఎక్కద్, ఇన్నె చుటలెక్కాద్, ఇన్నె పకతర్ ఎక్కాద్ ఇన్ ఇడ్డేర్ కుగ్నెమ్ ఒక్కొ మోకా ఔర్ తన బదోల్ గుగ్తెర్. అపుడ నీ సియ్‍తాద్నె బర్‍పై ఎర్సద్. ");
INSERT INTO nit_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","గని నీ జెవుంన్ సియెంఙ్ గరిబులుంఙ్ కుంట్టికున్, గుడ్డికున్ కుఙ్. ");
INSERT INTO nit_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ఔర్ ఇనుంఙ్ తిరుగుత్ తిండి సియ్‍ తా కడితుంఙ్‍, నీ తిక్ తార్ బత్కసార్ దినం బగ్వన్‍తక్నె మన్లాంఙ్ అడగెకర్ వెంటా అడగెంఙ, నీతి సియ్తదున్ నీ ఎరుంఙ్ తినెంఙ్ సియ్తెవొ ఔర్ ఇనుంఙ్ తినెంఙ్ సియ్సెటండె అపుడ్ ఇనుంఙ్ ఆసిర్వాద్ రొబడాద్. ");
INSERT INTO nit_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","అపుడ యేసున్ వెంటా ఉదుత్ అనెకా తన ఒక్కొద్ ఆ గొట్టికున్ విత్న, “దెయ్యమ్నె రాజ్యం ముత్ జెవుంన్ కలెకద్ గుల్ పెరెత్ ఆసిర్వాద్ సుమెకాద్ ఎరాద్” ఇసా ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","తే యేసుంద్ “ఓక్కొ మన్కనా గలెనా దండి జెవున్ సియెంఙ్ నిర్నయ్ కతెంద్. పేలెటరున్ కుగ్‍తెద్.” ");
INSERT INTO nit_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","అని జెవున్‍ తా వేలా ఎరెంఙ, కబుర్ ఇడుత్ అనెకరున్, వర్! ఇన్డి జెవున్ కలెంఙ్‍, సిమనా తయార్‍ అంన్సాద్‍. ఇసా సిసున్ పవింటెద్. ");
INSERT INTO nit_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","గని ఔర్ సిమ్కన జెవునుంఙ్ సెరెంఙ్ బోదుంఙ్ ఒక్కొది తిరడ్ వట్టి ఆగమీ ఇనంఙ్ ఇడెంఙ్ ఎద్దెర్. ఔర్తన పేలెతంద్, అన్ కెన్ సుమ్తన్. సెత్ ఓలెంపజె. అనుంఙ్ మాప్ కల్ ఇస అముదు వేల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","మల్ల ఒక్కొంద్‍, అన్ ఐద్ జొడిక్ కొద సుమ్తన్. అదా ఎనక్‍ పని కల్సావొ సెత్. ఓలెఙ్ పజె. అనుంఙ్ మాప్ కల్ ఇసా వేల్తొల్తెంద్ ఇసా ఇన్తేంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ఇంకా ఒక్కొద్, అన్ ఇండిని పెండ్లి ఎద్దిన్. అన్ వారెంఙ్‍ సాలెన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","అపుడ్ అముదు సిసుద్ తన్నె మాల్కకున్‍ వై రగ్ తిర్గుత్ వత్, సిసున్‍ వెంటా, నీ వెంటాయ్ నగురుత్ సంది నల్గూర్ గొందిన్ సెత్న, గరిబులున్, కుంటికున్ అని గుడ్డికున్ కూగుత్ తోడా వా ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ఔర్ అముదు గడియక్ ప్రబున్ మలైయుత్ వాత్న, ప్రబున్ నీ అత్తి సియ్‍తెతి లాంఙ్ అన్ కత్తన్. ఎనాగని అనా గని ఎల్ల ఇంకాగినా నిండెంఙ్ అన్సాద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","అపుడ్ ఆ మాల్కక్ గడియకున్ వెంటా, అన్నె ఎల్లత్ మంది నిండెగి పాహజే. అదుంఙ్ ఎత్తి నీ నగురుంఙ్ వాకా సెత్న, జాప్ అని కెనుత్ అనెకారున్ జులుమ్ కత్న కో ");
INSERT INTO nit_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ఇదుంఙ్ ముండట్ కబుర్ ఎక్సెటర్ అతాన ఒక్కొద్‍నాయ్ అన్ సియెకా జెవున్నె సవ్వీ ఓలెర్ ఇసా ఆ మన్కక్ ఇసాద్ ఇసా యేసుంద్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","పెరెత్ మంది యేసున్‍ వెంట వార్సనాంనెర్. తె యేసు ఔర్ పకంఙ్ మలయుత్, ");
INSERT INTO nit_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ఎర్‍ అన్‍ వై వార్సరొ, అముదు తన్నె అమ్మ బానున్, తన్నె మాసలున్, కీకె కొమ్మలున్, అన్నక్ తొరెండ్లున్ తోర్దా దాదక్ కెరున్ అని తన్నె పానముంఙ్ ఎన ఎక్కవా అన్ ప్రేమ్ కలెంద్ అముదు అన్నె సిసుద్ ఎరెంఙ్ సాలెద్. ");
INSERT INTO nit_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ఎర్ ఎన తన్నె సిలువన్ కున్తుత్ అన్ వెంట వర్సదొ అముదు అన్నె సిసుంద్ ఎరెంఙ్ సలెంద్. తన్నెత్ తాని తక్లిబ్ బొగిల్సెటాంద్ అముదు అన్నె సిసుద్ ఎరెంఙ్ సాలెంద్. ");
INSERT INTO nit_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ఇముంన్ లోపా ఎది ఒక్కొ మడి కట్టెంఙ్ ఇసా అండెద్ ఇండ్రు. తే అమ్నతీ కట్టుత్ అనెంఙ్‍, వెన్కత్ అండిన్ అంత్తె అండినా తొదా ఇసా లెక్కా కత్న ఓలెదా? తప్పతోసెటా ఓల్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ఒక్కొ మోకా ఓల్‍సెటా బునజి తపుత్, అముదు అదున్ పురా కట్టెంఙ్ సాల్సదో తోదో అదున్ ఓలుత్ సిమ్కన మంది కాయుంఙ్ సార్. ");
INSERT INTO nit_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ఓలెకార్ సదరి ఇమ్‍దు కట్టెంఙ్ మొద ఇట్టెంద్ గని అదున్ పురా కలెంఙ్ సాలేతెద్ ఇసా అమ్నున్ చడిప్తెర్ అని కాయుంఙ్ సార్. ");
INSERT INTO nit_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","అది ఎరెకడ్ ఒక్కొద్ రాజక్ మల్ల మరొక్కొద్ రాజకున్ వెంటా లడెయ్ కలెంఙ్‍, తనత్తి అనెకా పది హజల్ సిపాయిక్ గదియ్తె రా తొదా ఇసా విచార్ కలెరా? తక్సెటా అముదు విచార్ కతెంద్. ఈర్వె హజల్ మంది సిపాయిక్ వెంటా వార్సననెంద్. ఇంతె అమ్నున్ వెంటా లడెయ్ కలెంఙ్ సెరెకా, ");
INSERT INTO nit_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","తన్నె సక్తి గదియెద్ ఇంతే, ఆ రాజుంద్ ఇంక గుల్ దవ్ అనెఙయ్ ఇమ్ద కలయెంఙ్ వాయతదున్ పన్కుత్ సాంతి కల్ ఇసా వింతి కత్తెంద్ తా. ");
INSERT INTO nit_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","అపుడ్‍ ఇమాతననాయ్ ఎరి ఎక్కద్ అన్నె సిసుద్ ఎరత్‍ ఇంతె, అముదు గియనాడ్ విచార్ కత్న, ఇన్నతి అనెకాద్ సాదరున్ సాయుత్ వారెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","సుపుత్ ఎన్ని గొల్ సావ్వి అన్సాద్ అని గొల్ కామ్ సియ్‍సాద్. గని అద్నె సవాద్ సవద్ సెదిన్ ‍ఇంతె, మల్ల అద్నె సవదున్ కొరెంఙ్ వరెద్. ");
INSERT INTO nit_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ఆ సుప్పున్ బూమిత్‍ తపెంఙ్ కామ్‍ సియెద్ అని బిదిత్ జొపిడెంఙ్ కామ్‍సియెద్. మన్కకెర్ అదున్ వాకా జొపిడ్సార్. కెవ్వు తోసెటార్ అదున్ జొపిడ్సార్ కెవ్వు అనెకర్ అదున్ విచార్. ");
INSERT INTO nit_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ఒక్కొఉసాట్ నాక వలె అని మరొక్కొర్ పాప్ యేసుంద్ ఇడ్డెకా గొట్టిక్ వినెంఙ్‍, అమ్నాత్తి మిరయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","అదున్ ఓలుత్ పరుసిక్ అని సాస్త్రిక్ ఈ యేసుంద్ పాప్ కున్ మెరా కల్సాంద్. అని ఔరున్ వెంట మిరాయుత్ తిందెద్. ఇసా సైగ్సా ఇన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","అపుడ్ యేసుంద్ ఔరుంఙ్ ఈ ఉదహరన ఇడ్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ఇమంతనట్ ఒక్కొనత్తి నూర్ ర్గొర్రె అండే ఇడ్. అదవున్ తన ఒక్కొ గొర్రె దావ్డిల్‍తె, అముదు అదా నొవ్వద్‍తొమ్మిద్ది గొర్రెలున్ బట్టిత్ సాయుత్, దవ్డిల్త గొర్రె రొంబడ్‍ నంత్తెంఙ్ కిరవెంఙ్ సెరెదా తనెద్? తక్సెటా కిరావెంఙ్ సెసద్! ");
INSERT INTO nit_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","అద్ రొంబట వెన్కత్ సాట్టత్ కాజుత్, కుసినడ్ ఎల్లంఙ్ తోడా వతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","అని అమ్నె సంఙ్తకెరున్, అజు బాజుతరున్ కూగుత్న, అన్నె దవ్డిల్తా ఆ గొర్రె రొబాటిన్ అదుంఙ్ ఎత్తి అన్ బరాబర్ కుసీ కలుర్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","అనాయ్ పాప్ తన మన్ బద్లిపుర్ జరురత్ తోతెంద్ ఔర్ నొవ్వద్ అని తోమ్ది నీతితరుంఙ్ ఎన్న, కబ్లిలెకాద్ ఒక్కొద్ పాపి మన్ బద్లిపెకాద్‍ బదోల్ స్వర్గుత్ పెరెత్ కుసి ఆనందడ్ అన్దర్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ఓక్కొ పిల్లనత్తి పది కూరనే దుగని అండే ఇడ్ర. అత్రనట్ ఒక్కొ దుగని ఎదొయో రట్టిన్‍. తే ఆ పిల్ల దీవే తర్పుత్, దుగని రొబాడ్ నంతెత్, ఎల్లన్ పురా ఐయుత్ కిర్వసెట్టా ఆదాద? తప్పతోసెటా కరవ్ సాద్! ");
INSERT INTO nit_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ఆద్ రొంబటాద్ వెన్కత్ తన్నె సంఙ్తకెరున్ అని ఆజు బాజు తా పిల్లకున్ కూగుత్న, ‘అన్ రాప్త దుగని అనుంఙ్ రొబ్బటిన్. అదుంఙ్ ఎత్తి అన్‍ బరబర్ నిర్‍నాయ్ కుసీ కలుర్’ ఇసా ఇడ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","అది తిరడ్ మన్ బద్లిపుర్ ఒక్కొద్ పాప్ స్టకున్ బదోల్, దెయ్యమున్ ముండట్ దూత్ తప్ తోసెటా కుసి సుమ్‍సర్” ఇసా యేసుంద్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","యేసుంద్ పెనా గిన ఇనంఙ్ ఇడ్‍తెద్. ఒక్కొ మన్కంఙ్ ఇద్దర్ కీకె అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ఔర్తన సిన్నం బానున్ వెంటా, బబా! ఆస్తి తన అనుంఙ్ వరెకా ఇసా పయుత్ ఇదే సియ్ ఇసా వెలుత్ ఓల్‍తెద్. తే బాంద్ ఔర్ ఇద్దరుంఙ్‍నై ఆ ఆస్తిన్ పైయుత్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","కొన్ని దినాలడ్‍ అముదు సిన్నం తన్నె ఇసన్‍ విరుత్, పైసె సుముత్ దావ్ తా దేసెముంఙ్ సెద్దెంద్. అత్తి సుకమ్తా బత్క బొగిల్సా బాత్కెంఙ్‍, కరాబ్ ఆదతు కరపుత్న, పైసె సిమ్కన తిర్పుత్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","అమ్నె సిమ్కన పైసె తిర్‍ తా వెన్కత్, ఆ దేసుత్ గుల్ దండి కరువ్‍ పట్టిన్. అపుడ్ అమ్నత్తీ తినెంఙ్ ఉనెంఙ్ తనయ్‍ తొత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ఆ దేసుత్ ఒక్కొ మన్కనంత్తి సెత్న పని వెలుత్బ ఓల్‍తెద్. అపుడ్‍ ఆ మన్కక్ తన్నె తుర్రె తినెకాద్ ఉనెకాద్నె కయ్యెకదుంఙ్ అమ్నున్ కెన్‍వై పావిట్టెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","తే అముదు గుల్ కారవ్రుత్‍ అండకాడితుంఙ్‍, తుర్రె తినెకా పొట్టున్ ఎన తిత్న పెట్టెన్ నిడ్పత్ ఇసా ఓల్‍నెద్. గని అమ్నుంఙ్ ఎరి తనయ్ తినెంఙ్ సియెతెర్. ");
INSERT INTO nit_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","అమ్నుంఙ్ బుద్ది వత్తిన్ అప్పుడ్, అన్నె బానె ఎల్లత్ ఎత్తెఓ మంది కుల్కలకెరున్ సుకమ్‍ తా సంది అన్సాద్. గని అన్ ఇత్తి సంది తోసెటా తిక్సనాంసాత్. ");
INSERT INTO nit_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","అన్ ఈ దేసున్ సాయుత్న, అన్నె బానాత్తి సెరత్ అని, బబా అన్ పరలోకముంఙ్ ఉల్ట ఎత్న, ఇన్నె నదురుంఙ్ ముండట్ పాప్ కత్తన్. ");
INSERT INTO nit_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ఇండి తన ఇన్నె కీకె ఇసా కూగెంఙ్ పని సియెన్. ఇన్నె కుల్కలకెరున్ ఒక్కొద్ ఇసా ఇడ్ ఇందత్ ఇసా విచార్ కత్న, వెంటాయ్ బాన్‍వై సెరెంఙ్ కురియ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","గని అముదు గుల్ దావ్వ అనెంఙ్‍ బాంద్ అమ్నున్ ఓల్తెంద్. తే అమ్నున్ పొయ్ కివ్ వత్తిన్. అపుడ్ కీకెన్‍వై తుల్ సెద్దెంద్ అని ముదిడుత్ కలయ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","అపుడ్‍ ఆ కీకె బానున్‍ వెంటా, బబా! అన్ పరలోకముంఙ్ వెంటా విరోద్ ఎత్న, ఇన్నె నదురుంఙ్ ముండట్ పాప్ కత్తన. ఇత్రనాట్ ఇన్నె కీకె ఇసా కూగెంఙ్ కామ్ సియెన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","గని బాంద్ తన్నె గడియకెరున్ వెంటా, సపాన సెత్న, సిమ్కనంఙ్ ఎనా సోయ్త జుఙ్ఙే కొత్న తొడుపుర్. అమ్నె వెందెంఙ్ ఒంఙెరం తొడుపుర్, గెట్టలుంఙ్ కెర్రిక్ తొడుపుర్. ");
INSERT INTO nit_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","అని సోయ్‍ కొరువ్ తా పడ్డన్ కొత్న తర్గుర్. నేండ్‍ సిమ్కన కుసినడ్ జెవున్ కాన్నర్. ");
INSERT INTO nit_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","తికుత్ పానం ఎదెత్తి అని దవ్డిలుత్ సెత్న రొంబట్టెతి, ఇమ్‌ద అన్నె కీకె ఎన్నెంద్ ఇసా ఇడ్‍తెద్. అపుడ్ ఔర్ కుసినడ్ జెవుంనె పని సురు కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","అది వాకతుంఙ్ దొడంద్ కీకె కెన్‍ వాలడ్ పని కత్ వార్సనాంనెద్. తే అమ్మె ఎల్లతన వాజ గజనాడ్, పాట్టా పాడెకర్ అని ఎదెకారె నాంద్ అమ్నుంఙ్ విన్క వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ఒక్కొ సేవకున్ కూగుత్న, తానెద్ ఎర్సానాంసాద్? ఇసా వేలుత్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","అముదు సిసుద్, ఇన్నె దాదక్ వతెంద్. ఎల్లంఙ్ ఎత్ సోయ్ తిర్గుత్ వాత్త కాడితుంఙ్‍, ఇమ్మె బాంద్ కొరువ్ తా లెఙ తర్గుత్ జెవున్ సియ్‍సాన్సాద్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","అదున్ విత్న అముదు దండిఙ్ రాగ్ వత్తిన్. తే అముదు ఎల్లలోపా సొగె తెంద్. అదుంఙ్ ఎత్తి బాందీ వాకా వత్న, లోపా వా బాపు ఇసా అమ్నున్ వింతి కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","అపుడ్ బానున్ వెంటా, ఇదొ బబా! ఇన్ని సాల్కుతన సిసుద్ లాగ్ ఇన్నె చాక్రి కాల్సనండన్. ఇన్నె ఆగ్యి ఎపుడి సాయుత్ అడగెతాన్. ఎనా గని “ఇన్నె సంఙ్తకేర్ వెంటా దావత్ కత్న తిన్” ఇసా ఒక్కొ సిన్నం మేకె నాయ్ అనుంఙ్ సియెతీ. ");
INSERT INTO nit_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","గని ఇన్నె ఆస్తి పూర కొసుత్న కార్సిప్త ఇన్నె కీకె ఎల్లంఙ్ వతెంద్ తే అమ్నుంఙ్ ఇసా, కొరువ్ త లెఙ తర్గతీ ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","అదుంఙ్ ఎత్తి బాంద్ బాపు! నీ ఎపుడీ అనత్తిని అన్సాతి. అనత్తి అనెకా సిమానా ఇన్నెవి ఎన్నె తా. ");
INSERT INTO nit_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","గని తికుత్ పానమ్ ఎద్దద్ అని దవ్డిలుత్ రొబ్బాటాద్, ఇన్నె దాదక్ అండెద్. అదుంఙ్‍ ఎత్తి నేండ్‍ కుసినడ్ ఈ జెవున్ తినెకాద్ బారబరి ఎంద్ ఇసా ఇడ్‍తెంద్ ఇసా యేసుంద్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","యేసుంద్ తన్నె సిసు వెంటా, ఒక్కొ దన్‍వంతక్నె ఎల్లత్ ఒక్కొనుంఙ్ మాల్కక్నెకామ్ కన్నెద్. ఒక్కొ జీర్ కొన్సెం మంది, అముదు ఇన్నె ఆస్తిన్ ఆగమి కరాబ్ కల్సానాంసాద్ ఇసా కార్‍బారిన్ బదోల్ దనవంతక్ విరోద్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","తే దన్‍వంతక్ అమ్నున్ కూగుత్న, ఇన్ బదోల్ ఇడ్డెకా కరాబ్ కాము కరెయ్ ఎన్నెవా? నీ ఇండిదూక్ కత్త కార్బరినె లెక్క అనుంఙ్ ఇడ్. ఇండి తన అనత్తి కామ్ కాన్నెమ్ ఇసా అమ్నుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","తే అముదు కారబరి తన్నెత్ తని మనుత్, కార్బరినె కామ్‍ తన అన్నె మాల్కక్ అన్ పుసాన్సాద్. అనుంఙ్ తె కెన్‍త కామ్ కన్నెత్తి సక్తి తోతెద్. బిసెమ్ వేలెఙ ఇంతె లజా వర్సాద్. ఇండి తాగలుడ్? ");
INSERT INTO nit_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","అన్ కార్బరితన పుస్త వెన్కత్, దొస్తూ తమ్మె ఎల్లక్‍లెంఙ్ అనుంఙ్ మాన్ సియ్నెతి, తాగలెకాదొ అనుంఙ్ ఒర్కి ఇసా విచార్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","అని తన్నె మాల్కకున్ కరజ అనెకరతన ఒక్కొంద్ ఒక్కొనున్ కుగ్‍తెంద్ ఔర్ వాత్త వెన్కత్ పేలెతనున్ ఇంతెంద్ నీ మాల్కకుంఙ్ ఎత్తె బాకి అండ్డి? ఇసా వెలుత్ ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","తే ఆమన్కక్ నూర్ దంతులీ బాకి అండిన్, ఇసా ఇడ్‍తెద్. అపుడ్‍ కార్బారి, ఈరసిద్ సుమ్ అని అత్తి ఉదుత్ వెంటాయ్ పన్నాస్ దంతూ ఇసా వాయ్ ఇసా ఇడ్‍తెద్. ఒలీవ నూనె ");
INSERT INTO nit_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","అనంఙ్ ఎదా వెన్కత్ పెన ఒక్కొనున్ ఇంతెంద్ నీ ఎన్ని కరజ అండీ? ఇసా వెలుత్ ఓల్‍తెంద్. తే ఆ మన్కక్, నుర్ పొతే గొద్మలే కరజ అన్సాత్? ఇసా ఇడ్‍తెంద్. తే కారబారి, ఈరసిద్ సమ్ అని అదున్ అంన్సీ పొతే ఇసా వాయ్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","రితితోసెటా కరాబ్ అడ్‍గెకా ఈ కార్‍బారి ఇనంఙ్ గుమిప్‍తెద్‍ ఎన్నా, అమ్నె మాల్కక్ అమ్నున్ మెస్‍తెంద్. తానుంఙ్ ఇంతె ఈ దున్యతరున్ బదోల్‍ తమ్మెరున్ బదోల్ దెయ్యమ్నె మందిఙ్ ఎన ఎత్తెఒ సత్తురడ్ అన్సార్. ఈ గొట్టత్ వెల్ఙుత్ అనెకదుంఙ్ ఏన లోపముత్ అనెకర్ గూల్ ఉసార్. ");
INSERT INTO nit_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","యేసుంద్ ఇనంఙ్ ఇడ్తెంద్, అదుంఙ్ ఎత్తి అన్ ఇడ్డెకాద్ తనెద్ ఇంతె, ఈ దున్యత్ అన్యాయ్ ఆస్తిన్ మరొక్కొరుంఙ్ మదత్ కత్న సంఙ్తకెరుంఙ్ కామయ్ కాలుర్. తే అపుడ్ ఎప్పుడి తిక్సెట పానం అనెకా స్వర్గుత్ నీర్ సెదా వెన్కత్, దెయ్యం ఇమున్ మెరా కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","సిన్నం గొట్టిక్ లత్తి నమ్సెటాంద్ అనెకర్ దండి గొట్టిక్‍లెంఙ్ నాయ్ నమకమాడ్‍ అమ్నున్. చిన్న గొట్టిక్ లత్తి పాసిప్‍తె, దండి గొట్టిక్ లత్తి నాయ్ పసిప్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ఆది ఇదదాడ్ నీర్ ఈ దున్యత ఆస్తిత గొట్టితి నమ్సెటాంద్, స్వర్గంనె కరెయ్ ఆస్తినె గొట్టి పొయ్ ఇముంన్ ఎర్ నంసార్? ");
INSERT INTO nit_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","నీర్ మరొక్కొరె ఆస్తినె గొట్టిత్ నమ్మకమాడ్ అనెర్, ఇన్నె ఆస్తి ఇమ్మెత్తి సొంతమ్ ఇసా ఎర్ సియ్‍దార్? ");
INSERT INTO nit_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","ఒక్కొ గడియక్ ఇద్దర్ మాల్కకెరె సేవ కలెంఙ్ సాలెంద్. ఒక్కొనున్ ప్రేమ్నాడ్ ఓలుత్, పెనా ఒక్కొనున్ మెస్సెంద్. ఒక్కొనె సేవా బరొసనడ్ కల్సాద్ అని పెనా ఒక్కొనున్ సిన్నం పానడ్ ఓల్సాద్. నీర్ దనమున్ ప్రేమనడ్ ఓల్‍తిరింత్తె, దెయ్యమున్ ప్రేమ్ మాడ్ ఓలెంఙ్‍ సాలెర్ ఇసా యేసుంద్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","పైసె ఇంతె ప్రేమనడ్ కలెకార్ పరుసిక్, యేసుంద్ ఇడ్త గొట్టికున్ విత్న, అమ్నున్ చడిప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","తె యేసుంద్ ఔరున్ వెంటా, నీర్ మందిన్ ముండట్ నీతితర్ ఎందుమ్ ఇసా ఇడెంఙ్ ఓలిప్‍సాతిర్. గని ఇమ్మె మన్లెఙ్ తనెద్ అన్సాద్ ఇనెకద్ దెయ్యమున్ ఒర్కియ్. లొకూ పెరెత్ మనిప్సరా. అదుంఙ్ బదోల్ దెయ్యమున్ నాదురుత్ కరాబ్ ఎర్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","బాప్తిస్మ సియ్యెక యోహాన్ వంనంత్తెంఙ్ దెయ్యం మోసెంఙ్ సియ్‍ తా నియ్యమ్‍లాఙ్ అని పర్‍వక్తకెర్ వాయ్తా గొట్టిక్లెంఙ్ అడ్‍గెకంద్ అన్సాద్. అని ప్రతి ఓక్కొద్ దెయ్యమ్నె కబురున్ ఓప్పుత్న, తమ్మె మన్లున్ దెయ్యమ్నె రాజ్యం అడ్గిపెకాంద్ ఇసా పెరెత్ కోసీద్ కాల్సన్సార్. ");
INSERT INTO nit_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","గని విడ్ర! ఈ బూమి అని ఆబార్ నాస్ ఎరద్ ఎన గని, మోసెనె నియమ్ సాస్త్రత్ నియముత్ వాయుత్ అనెకా ఒక్కొ సిన్నం గొట్టి గిన తప్సెరెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","ఇదా ఎపుడి ఇలుత్ అన్సా ఇనెకా ఒక్కొ నామోనా. తన్నె మాసలున్ పార్కత్ సీయుత్, మరొక్కొ పిల్లన్ కలెకర్ హర్ ఒక్కొద్ చినలి వార్సాద్. పార్కత్ ఎత్‍ అనెకా పిల్లన్ కలెకద్‍ గిన పెట్టె కొత్త లెకఙ్ఙి వార్సాద్ ఇసా యేసుంద్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","అనంఙ్ ఇంత వెన్కత్ యేసుంద్ ఈ కత్ తా సురు కతెంద్. పేలె ఒక్కొ దనవంతక్ అండెద్. అముదు గుల్ కిమ్మత్త జుఙ్ఙె తొడ్‍నెద్, సుకమడ్ సాంతినాడ సోయ్ తిసా బత్కసానంనెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","అముదు దనవతక్నె ఎల్ల బొయ్ద మెర పాటకుక్నె బజుంఙ్ లాజర్ ఇన్నెకా పేర్త బిచె గాండ్ అన్నెద్. అమ్నె మెన్ పురా పుండ్లడ్ నిండుత్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","దనవంతక్ తినెంఙ్ అమ్నె టెబల్‍ తన బూడున్ రాలెకా మెతకులున్‍ ఎన తింద్దత్ ఇసా అసానాడ్ అన్నెద్. అతెయ్ ఎరెకాడ్, ఆతె వాత్న అమ్నెమెన్తా పుండ్లున్ నాక్నే. ");
INSERT INTO nit_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ఆ బిసెగాండ తిక్‍తెద్. తే దెయ్యమ్నె దూత్ అమ్నున్ కొసుత్న అబ్రాహామ్నె బాజుంఙ్ ఉదిప్‍తెర్. అనంఙ్ ఎద్ దవెన్కత్ కొన్ని దినాలడ్ అముదు దనవంతక్‍నాయ్ తిక్‍తెంద్ అని అమ్నె తప్నె ఇదర్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","తే అమ్నున్ పుర్పెతెర్. అబ్రాహామ్ దనవంతక్ పాతాలముంఙ్ దుకమ్ బొగిల్సా తల్లున్‍ ఎత్తుత్ పొయ్ ఓల్‍తెద్. అపుడ్ గుల్‍ దావ్ అబ్రాహామ్ అని అమ్నె బాజుంఙ్ లాజర్ ఉద్దుత్ అనెకాంద్ కాడ్కెదెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","తే అముదు దనవంతక్ అబ్రాహామ్ దాద! అన్‍ పొయ్‍ దయ కల్. ఈ కిసుత్ దుకమడ్ తలతల ఎర్సన్సాత్. అదుంఙ్‍ ఎత్తి ఇన్నె వెందెన్ ఇరుత్ ముంపుత్, అన్నె నాల్కన్ టడ్డి కాలెంఙ్ లాజరున్ పాన్కా ఇసా జులుమ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","గని అబ్రాహామ్ పోరక్, నీ బూమిత్‍ పొయ్ పానంత అన్నంతెంఙ్ సోయ్‍ సుకమడ్ అండి. గని అప్పుడ్ లాజర్ పెరెత్‍ తక్లిబ్ బొగిల్తెంద్. ఆ గొట్టిన్ ఆదికాల్. ఇండి అముదు అరంసుమ్‍సాన్సాద్. నీ దుకమడ్ తలతల ఎర్సా నంసతీ. ");
INSERT INTO nit_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ఇద్ది ఎరెకడ్ పెనా ఒక్కొ తనెద్ ఇంతె ఇనుంఙ్ అనుంఙ్ నడమున్ ఒక్కొద్‍ గుల్‍ దండి లొవ అన్సాద్. ఇదున్‍ వాలడ్ ఇలర్ ఇమున్వై వరెంఙ్ సాలెర్ అని అలర్ ఇదె విడుత్ వరెంఙ్ సాలెర్, ఇసా అబ్రామ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","అపుడ్‍ దనవంతక్, అనంఙ్‍ ఎరతె దాద, అముదు లాజరున్ అన్నె బానె ఎల్లంఙ్ పన్క ఇసా ఇన్ వేల్సాత్ ఇంత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","తానుంఙ్ ఇంతె అనుంఙ్ ఐదుగుర్ దాదక్ కేర్ తొరెంల్‍ అన్సార్. దుకమడ్ గల్ మెల్ ఎరెకా జాగత్‍ వారెంఙ్‍ ఇడ్‍సెటా అవ్రతి సెత్న, సాక్సం సియెంఙ్ లాజర్ అమ్మె ఎలంఙ్ పన్క ఇసా ఇన్ కొసిద్ కతన్. ");
INSERT INTO nit_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","గని అబ్రాహామ్, మోసే అని మరొక్కొ ప్రవక్త కెర్ ఇడ్ తా వచండ్లు అవ్రత్తి అన్సా. ఆ వచండ్లు సుముత్ అడ్గెకార్ ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","తే అముదు దనవంతక్, అనంఙ్ ఎరెద్, అబ్రాహామ్ బబా! తిక్తరంతన ఎద్ది ఎక్కద్ ఒక్కొద్ అవ్రత్తి సెద్దె, ఔర్ పాప్‍ తన మన్ బద్లిపుర్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","అప్పుడ్‍ అబ్రాహామ్ మోసేనె గొట్టిక్ అని ప్రవక్తకెరె గొట్టికున్ పాడిపుత్ ఔరు విన్సెట అండె, తిక్తరంతన ఒక్కొద్ పానమ్‍ ఎత్న సెద్దె గినా ఔర్ నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","అముదు తన్నె సిసులున్‍ వెంటా, “ఇనంఙ్ ఇంత్తెద్ అడ్డమ్ వరెంద్ ఇడ్సెట జర్గిలెద్. గని అదా ఎరున్ వాలడ్‍ వార్సావొ అమ్నుంఙ్ సిక్స సుక్కిలెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","అన్ పొయ్ బరొస ఇడ్డెకార్ ఇటర్ సిన్న అనెకరతన ఒక్కొనున్ పాప్‍ కాలెంఙ్ ఇసా, ఒక్కొ మోకా ఎరి కారన్ ఎద్దెరింత్తె, ఆట్టా మన్కన్ మక్కుత్ ఒక్కొ దండి తిర్గల్‍ గుడున్ కట్టుత్న, సమ్‍దురుత్ జొపిడెకాద్ సోయ్‍ అందద్. ");
INSERT INTO nit_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ఆదుంఙ్‍ ఎత్తి ఇమ్మెత్‍ ఇముంగీ గియనాడ్‍ అండ్రు. ఇమతద్‍ ఎది సిన్నం దాదక్ పాప్ కాదద్‍ తె, ఔరుంఙ్ దమ్కి సియుర్. అని అముదు పాప్‍ తన మన్ బద్లిపుర్, మాప్ కాల్. ");
INSERT INTO nit_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","అముదు ఒక్కొ జీర్‍ విరోద్ ఏడ్ సాల్ గలత్ కత్తె అన్ ఇన్నత్తి వాత్న, ఏడ్ సాల్ ‘అన్ మన్ బద్లిపుర్’ ఇందత్తె, అమ్నున్ మాప్‍ కలెంఙ్” పాజె. ");
INSERT INTO nit_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ప్రబుంద్ ఇనంఙ్ ఇంతెంద్ అపొస్తులున్, “అమ్మె విస్వాసున్ పెర్‍ గిప్” ఇసా యేసునున్ కొర్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","తే యేసుంద్, ఇముంఙ్ మోర్యిదనె నంతె విస్వాస్ అండిన్ ఇంతె గీ ఎరాద్. ఈ దండి మరోడ్ మాకున్‍ వెంటా యే! మక్నే వేల్ కాలపి సమ్‍దురుత్‍ సెత్నరాల్ ఇంతె గీ, అద్‍ అమ్మె గొట్టిన్ వింత్నరాల్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ఇన్నె కెన్‍ ఉర్రేకా సేవక్ ఎక్కద్, తోద్తే ఇన్నెగొర్రె మెపెకా గాయ్కింద్ ఎక్కద్, కామ్‍ తన ఎల్లంఙ్ వత్తెదింతె అమ్నున్ వెంటా, జల్ది వాత్న జెవున్‍ కాలెంఙ్ ఉద్దా! ఇసా ఇసాతివా? తప్‍ తోసెట ఇనెమ్. ");
INSERT INTO nit_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","అనంఙ్ ఇనెకా బదోల్ ఇముంఙ్ తినెంఙ్ అంబా నెంజెంఙ్‍ వెయ్‍గల్. మరొక్కొ జుఙ్ఙె తొడుత్, అనుంఙ్ సేవ కల్. అన్‍ తిందా వెన్కత్ నీ తిన్ ఇసా ఇసాతీ. ");
INSERT INTO nit_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","నీ ఇడ్తెతి ఆ సేవ కతెంద్ ఇసా కుసీ కతెంద్ ఇసా, అమ్నున్ నీ ప్రేమ్ కల్సర్? నీ తప్ప తోసెటా ఇడ్డా. ");
INSERT INTO nit_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","నీర్‍ నై ఇడ్త తిర్ నిబప్‍త వెన్కత్, అమ్ సదర్ సేవకెర్ ఎందుమ్. అమ్మున్ లోపా అనెకాద జీమెదరి నిబప్తమ్ అత్తెయ్ ఇడెంఙ్ ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","యేసుంద్ యెరూసలేముంఙ్ సెరెంఙ్‍, సమరయా గలిలీయ నడూమ్ తా బార్సలెంఙ్‍ నాయ్‍ చేసనంన్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ఒక్కొ ఊరుఙ్ ఔర్ యేసునున్ ఓలుత్, అముదు‍ సెసనంనెర్ పెర్‍దుకమాడ్ అనెకర్ పది మంది పడసిల్ ముదార్ వాలడ్ వర్సనండాద్. ");
INSERT INTO nit_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","దావి ఇలుత్. అని, యేసు! అమ్మె మాల్క! అమ్మున్‍పొయ్ దయ ఓలిప్! ఇంతేర్ ఓలిపుత్, అమున్ సోయ్ కాల్ ఇసా జోరకత్ వపొయ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","తే యేసుంద్ ఔరున్ ఓలుత్, నీర్ సెత్న దెలకెరుంఙ్ ఓలిపుర్ ఇసా ఇడ్‍తెద్. అనంఙ్ సెసననెంఙ్‍, ఔర్ సోయ్‍ ఎదెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","అపుడ్ అవ్ర తన ఒక్కొద్ తన్నె సోయ్‍ ఎద్దదున్ ఓలుత్, జోరకత్న “దెయ్యమున్ మహిమ వక్కద్!” ఇసా, వెన్కవై మలయుత్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","అని యేసునే గెట్టలత్తి రాలుత్న, దనెవద్ ఇడ్‍తెద్. ఆమన్కక్ సమరయ యేర్యితద్ ఎన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","అదుంఙ్‍ ఎత్తి యేసుంద్, “పురా పది మంది సోయ్‍ ఎద్దిర్‍ తా? మంజే మిక్తర్ తొమ్మది మంది ఎదే? ");
INSERT INTO nit_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","దెయ్యమున్ మహిమన్ వింతి కత్న కుసీ కలెకాద్, ఇమ్‌ద సమరియ జాతితనున్ సాయుత్న, మిక్తర్ సోయ్‍ ఎద్దర్ ఎరి వారెతెర్?” ఇసా అమ్నున్ వెలుత్‍ ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","అని నీ సులుత్న సే. ఇన్నె విస్వాసి ఇన్ సోయ్‍ కత్తినా ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","కొన్సెం పరుసిక్ దెయ్యమ్నె రాజ్యం ఎపుడ్‍ వార్సాద్? ఇసా యేసుకున్ వేలుత్‍ ఓల్‍తెర్ తే యేసుంద్, “మన్కకెర్ ఓలెఙా దెయ్యమ్నె రాజ్ కండ్కెరెంఙ్ వారెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ఇదొ, ఇత్తి అన్సాద్! అదొ అత్తి అన్సాద్! ఇసా దెయ్యమ్నె రాజ్యమున్ బదోల్ ఇడెంఙ్ వారెద్. తానుంఙ్ ఇంతె ఇండి దెయ్యం ఇమ్మతి అత్న, ఇమ్మె మన్నుత్ అత్ రాజ్ అడ్గిప్సంద్” ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","అనంఙ్ ఎద్దవెన్కత్ తన్నె సిసులున్ వెంటా, బవిసతుత్ మన్కనె పోరక్ వరెకా దినలున్ నీర్ ఓలెంఙ్ ఇసా గుల్ అసా కత్తిర్. గని ఆ దినామున్ ఓలెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","అపుడ్‍ ఇమ్మ తాన, “మంది ఇంతెర్ ఇమోందొ ఇత్తి అన్సాంద్! తోద్‍తె అముదు, అత్తి అన్సాంద్!” ఇసా ఇసార్. గని నీర్ ఔరె గొట్టి వినెర్ గని ఔరున్ వెంటా నీర్ సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ఆబారుత్ మెర్పెకాదున్ ఎనంఙ్‍, ఓల్సరొ, అనాయ్‍ మన్కనె పోరక్, పెనా ఒక్కొ ఉసాట్ మలయుత్ వారెంఙ్‍, సిమ్కన మంది ఓల్సార్. ");
INSERT INTO nit_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","గని ఇద సదర్ జర్గిలెంఙ్‍ పేలె, ఈ పిడితర్ అన్ బద్లిలెంఙ్ ఎరెంఙ్ పాజె అని అన్ పనిత్ పడ్సెట బొగీలెంఙ్ పాడ్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","నొవక్నె కాలముత్ జర్గిల్‍ తా తిరాడ మన్కనె పోరక్ కాలమ్‍ నాయ్ జర్గిలద్. ");
INSERT INTO nit_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ఆ నొవక్నె రూకుత్ సొఙ్‍నంత్తెంఙ్‍, తిసా, ఉసా, పెండ్లిక్‍ ఎర్స, పేడ్లిక్‍ కల్సా అండెర్. ఆ గట్కంఙ్ జల్నె గండమ్ వాత్న, సిమ్కన మందిన్ నాసానం కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","లోతునె కాలముత్ నాయ్ అనాయ్ జర్గసాద్. అపుడ్‍ ఔర్ తిసా, ఉసా, సుమ్సా, విర్సా, ఉర్స ఎల్లక్ కట్‍సా బత్కసా నన్నేర్. ");
INSERT INTO nit_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","గని లోతు సొదొమ నగురున్ సాయుత్‍ సెద్ద జిరి, ఆబార్‍ తన తరియెకా అబరుత్ అని కిస్నె నిప్కాలె వాన వాత్న, లొతునె ఎరెకాడ్ సిమ్కన మందిన్‍ నాసెనం కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","మన్కనె పోరక్ పావిలెకా దినముంఙ్ జీర్‍ నాయ్, అనాయ్ జర్గిలద్. ");
INSERT INTO nit_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","అజిరి తా ఎల్లత మిద్దెపొయ్ అనెకాద్, తన్నె సామనున్ కొరెంఙ్ ఇసా నాయ్ బూడున్ డిగెంఙ్ తోద్. అనాయ్‍ కెనుత్ అనెకా ఎద్వున్‍ నాయ్ కొరెంఙ్ ఇసా మలయుత్ సెన్నెర్. తానుంఙ్ ఇంతె వాస్తు బదోల్ గినా విచార్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","లోతునె మాసలుంఙ్ తనేద్ ఎద్దినొ అదున్ ఆదికాల్! ");
INSERT INTO nit_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","తన్నె దన్ దవ్లతున్‍ అని తన్నె పానమున్ బత్కిప్సాంద్ ఇనెకానున్ ఎప్పుడి అనెకా పానం రొబ్బడెద్ గని అనుంఙ్ సటీ తన్నె పానం సియెకానున్ ఎప్పుడి అనెకా పానం రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ఇముంఙ్ ఇడ్డెకాద్ తానెద్ ఇంతె. అజిరి తా రాతుత్ ఇద్దర్ తెర్‍ పొయ్ అన్సార్. అవ్ర తన ఒక్కొనున్ సాయుత్, పెనా ఒక్కొనున్ కొసెకాద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ఈర పిల్లక్ మిరయుత్ తిర్గలుత్ పర్యసానాంసా. ఒక్కొదున్ సాయుత్న, పెన ఓక్కొదున్ కొసెకాద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ఇద్దర్ నాయ్ ఒక్కొది కెనుత్ అన్సార్. అవ్ర తన ఒక్కొనున్ సాయుత్న, పెనా ఒక్కొనున్ కొసెకాద్ ఎర్రద్ ఇసా యేసుంద్ ఇడ్‍తెద్. తే సిసూ, ఇదాసదర్ ఎత్తి జర్గిల్‍దా ప్రబు? ఇసా వెలుత్‍ ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","సిసు వెల్తేర్ అపుడ్‍ యేసుంద్ ఇంతెంద్, “ఎత్తి జన్వర్నె తిక్ తా సెత్త అన్సాదొ అత్తి రయ్యకె మిర్‍య్సా” ఇసా ఉత్తర్ సియ్‍తెంద్ ");
INSERT INTO nit_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","అట్టిల్‍సెటా ఎప్పుడి పార్తన కల్సననెంఙ్ ఇసా ఇడెంఙ్ యేసుంద్ సిసులుంఙ్ ఈ ఉదహరన ఇడ్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","ఒక్కొపట్నముత్ ఒక్కొ న్యాయ్ అదికారి అండెద్. దెయ్యం ఇంతె అమ్నుంఙ్ అర్రితొద్. అని వరెకరున్ మనిళ్సెట అనెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","అది పట్నముత్ ఒక్కొ రాడెర పిల్ల అండిన్. ఆ రాడెర పిల్ల, అముదు న్యాయ్ అదికారున్‍వై గడి గడీ వార్స, “సాబ్! అన్ అని అన్నె సెలకేరె గొట్టిన్ న్యాయం కాల్” ఇసా నన్నేంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","కొన్ని దినాల అద్నె గొట్టికున్ వినెతెంద్. గని ఆక్రింఙ్ దెయ్యం ఇంతె అనుంఙ్ అర్రితొద్, ");
INSERT INTO nit_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","అన్ తోద్ ఇంతె నా ఈ రాడెర పిల్ల నాత్తి వత్న తక్లిబున్ సియ్‍సా నంసాద్. అదుంఙ్‍ ఎత్తి ఈ పిల్లంఙ్ న్యాయ్ కల్సాత్ నత్తి గడి గడీ వత్న కిస కీస కాలెంఙ్ తొద్ ఇసా తన్నె మనుత్ ఇన్‍ తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","అనంఙ్ ఇడ్‍ తా వెన్కత్ యేసుంద్ ప్రబు, కరాబ్ రితినాడ్ అనెకర్ ఔర్ కిస కీస కలెకా న్యాయ్ కలెక అదికార్ ఇంత్త గొట్టికున్ విద్దతిర్. ");
INSERT INTO nit_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","దెయ్యం తన్‍ నివ్డిప్త సింతె తొల్లి తనుంఙ్ పార్తన కల్సానండె, ఔరుంఙ్ తప్ప తోసెటా న్యాయం జర్గెంగెద్? అముదు కొరుమ్ కద్దద్? ");
INSERT INTO nit_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ఔరుంఙ్ సటీ దెయ్యం వెంటాయ్ న్యాయం జర్గిప్‍దద్ ఇసా ఇముంఙ్ ఇడ్సనాంసాత్. గని మన్కనె పోరక్ దెయ్యం తానా మలయుత్ వారెంఙ్‍, అంనత్తి విస్వాస్ ఇట్టర్ ఎరి బూమి పొయ్ కండ్కెద్దరి? ఇసా వెలుత్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","అని తమి నీతి మంతకెర్ ఇసా తమ్మెత్ తమి బరోసా ఇడ్సా, మరొక్కొరున్ సిన్నం పానడ్ ఓలెకరున్ బదోల్ యేసుంద్ ఈ ఉదహరన ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“పార్తన కాల్లెంఙ్ ఇసా ఇద్దర్ మన్కకెర్ మందిరుంఙ్ సెద్దెర్. అవ్ర ఇద్దర్ తన ఒక్కొద్ పరుసి జాతితద్ అని పెనా ఓక్కొద్ నాక వలె.” ");
INSERT INTO nit_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","పరుసిక్ ఇలుత్ దేవా అన్ ఈ డొంఙలంఙ్, అన్యాయ్ కలెకర్ లాంఙ్, సినలి కలెకర్ లాంఙ్ మల్ల ఈ నాక వలె లాంఙ్ ఎరెంఙ్ ఇడ్సెట అన్ అప్తదుంఙ్ ఇనుంఙి వందనాలు ఇడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","అన్ అఙడి వొన్తుంఙ్ ఇంది గుసాల్ ఉపాస్ సుమ్‍సాత్. అనుంఙ్ వరెకా సిమ్కన బలంమ్‍ వత్తె పది తన ఒక్కొద్ ఇసా సియ్‍సా నన్సాత్ ఇసా పార్తన కల్సద్. ");
INSERT INTO nit_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","గని అముదు నాక వలె తన దావ్ ఇల్లుత్, ఆబార్వై ఓలెంఙ్ ఇంమాత్ ఎర్‍సెటాసెత్న, తన్నె సాక్కున్ కుడ్‍క్సా, దేవా! అన్ పాప్ నాన్. అన్‍ పొయ్ దయా ఓలిప్ ఇసా పార్తన కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ప్రబునే నదురుంఙ్ పరిసయుంఙ్ ఏన ఇమ్‌దు టెక్సవసులి కలెకద్ ఇద్దర్ ఎత్న, నీతిమంతున్ సెద్దెంద్ ఇసా ఇముంఙ్ ఇడ్‍తన్. తనుంఙ్‍ ఇంతె ఎద్తన్నెత్తని దండీ ఇసాద్, దెయ్యం అమ్నున్ చిన్నంకల్సాద్. అని ఎంద్‍ చినం ఎద్దద్అంమ్నుంఙ్ దండి మన్‍ రొంబాడద్ ఇసా ఇడ్‍తెంద్‍. ");
INSERT INTO nit_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","యేసుంద్ సిన్నం పోరకేరత్తి కెయ్యులిడుత్ ఆసిర్వాద్ సియెంఙ్ ఇసా తన్నె ఔరున్‍ తోడా వతెంద్. అదున్ ఓలుత్ అమ్నె సిసు ఔరున్ సెయ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","గని యేసుంద్ ఔరున్ తన్‍వై కూగుత్న, “సిన్నం పోరకేరున్ అన్‍వై వరెంఙ్ ఇడుర్ ఔరున్ అప్‍నెర్. తానుంఙ్ ఇంతె దెయ్యమ్నె రాజ్యం ముత్ ఇవ్ర చిన్న పోరకేర్‍ పిల్లక్‍ లఙ్ ఎంద ");
INSERT INTO nit_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","చిన్న పోరకేర్‍ లంఙ్ తన్నె పానముత్ దెయ్యమున్ రాజ్ అడ్‍గిపెంఙ్ వొప్పెరొ, అవ్ర కరెయ్ ఆ రాజ్యం ముత్ సొంగెంఙ్ సాలెర్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","అదికారి ఒక్కొద్ యేసున్‍, “సోయ్త గురుజి అనుంఙ్ ఎప్పుడి అనెకా పానం రొంబడెంఙ్ ఇంత్తే తాగలెకాద్?” ఇసా వెలుత్‍ ఓల్‍త్తేద్. ");
INSERT INTO nit_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","యేసుంద్, “అన్ తనుంఙ్ సోయ్త గురుజి? ఇసాతీ. దెయ్యం ఒక్కొదీ సోయ్త ద్, మరొక్కొర్ ఎరీఎర్రెర్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ఆగ్య ఇనుంఙ్ ఒర్కియ్ చినలి కలెంగవరెద్, అత్యి కలెంగవరెద్, డొంఙ్‍ కలెంఙ్ తోద్‍ పయిలిన్. ఇడెంఙ్ తోద్, ఇన్నె బాంద్‍ అమ్మనె మాన్‍ కల్లెంఙ్ ఇసా యేసుంద్ అమ్నున్ వెలుత్‍ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“అన్ సిన్నం తన ఇద్ద సిమనాన్ పడిప్‍సాని అంన్సాత్‍” ఇసా ఇడ్తేద్. ");
INSERT INTO nit_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","అదున్ విత్న యేసుంద్, “నీ పెన్నాఓక్కొ గొట్టి సుముత్ అడతి. అద్‍ తానెద్ ఇంతె, ఇనంత్తి అనెకా జాజత్‍ సిమనన్ విరుత్న, ఇన్నత్తి అనెకాద్ సిమ్కన గరిబులుంఙ్ సియ్. అని అన్నెసారన సుముత్ అడ్గు. అప్పుడ్ ఇనుంఙ్ స్వర్గత్ దన్‍రొబాడ్సాద్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","గని అమ్నత్తి పెరెత్ ఆస్తి అండ కడితుంఙ్‍, అముదు గోట్టి వింత బరబర్ అమ్నుంఙ్ గుల్ దుక్‍లగ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","అమ్నున్‍వై ఓలుత్‍ యేసుంద్, యేసుంద్ ఔరున్ ఓలుత్ రగ్గున్ వత్ అనంఙ్ ఇంతెంద్ “దన్ దవ్లతున్ ఎరతి అన్సాదొ ఔర్ దెయ్యమ్నె రాజ్యంముత్ సెరెంఙ్ సలేర్ ఇసా గుల్ కాటిన్.” ");
INSERT INTO nit_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ఒక్కొ ఓట్ సూదినె బొగ్గనాడ్ ఎనంఙ్ సల్సదొ, అనాయ్‍ దెయ్యం తన్నె మాన్నుత్ రాజ్యం అడ్గిపెంఙ్, ఒక్కొ దనవంతక్ ఒప్పెకద్ గుల్‍ కటిన్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","అదున్ వింతర్‍ ఔర్, “మంజె! ఎర్‍ బత్కుత, సొంగెంఙ్ సాల్దర్?” ఇసా వెల్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","అపుడ్‍ యేసుంద్ ఇంతెంద్, “నరిమన్కక్నె కెయ్యడ్ ఇట్టా కామ్ ఎరెంఙ్ సాలెద్. గని సిరిప్ దెయ్యం ఇట్టా కామ్ కలెంఙ్ సాల్దద్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","పేతురున్ ఇసాంద్ ఇన్నె అమత్తి అనెకా సదరునీ సాయుత్న వత్తం ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","అప్పుడ్ యేసుంద్ ఇద్ కరెయ్ ఎంద్ దెయ్యమ్నె రాజ్యంఙ్ సటీ, తన్నె ఎల్లన్, మాసలున్, దాదక్ తొరెండ్లున్, అమ్మ బానున్, మల్ల పోరకేరున్ సాయుత్ నఅడగెకద్ ప్రతి ఒక్కొనుంఙ్‍, ");
INSERT INTO nit_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ఈ లొకముత్ ఎన్నిగో పండ్లు వారెక లోకముత్ ఎప్పుడి అనెకా పానం నాయ్ రొబడ్‍సాద్ ఇసా ఇముంఙ్ కరెన్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","యేసుంద్ తన్నె బరా మంది సిసులున్ పకంఙ్ కూగుత్న, ఇదె విండ్ర! నేండ్‍ యెరూసలేముంఙ్ సెసాన్సాతుమ్. అత్తి మన్కనె పోరక్ మన్కకున్ పోరక్ బదోల్‍ తొల్లె ప్రవక్తకెర్ వయ్‍త సిమ్కన వచండ్లు బర్పుర్ జర్గిల్‍దా. ");
INSERT INTO nit_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ఎనంఙ్ ఇంతె, అమ్నున్ యూదులెర్సెటార్ కెయ్యుత్ హవలి కత్తెర్. ఔర్ అమ్నున్ సాడిపుత్, అమ్నె ఇజతున్ కొస్తెర్. అమ్నున్ పొయ్య ఉస్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","అమ్నున్ సాట్‍లాడ్‍ లగప్‍తెర్. ఆక్రింఙ్ అమ్నున్ అలుంఙ్తెర్. గని ముదీ దినాలుంఙ్ పానమ్‍ ఎద్దెంద్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","గని ఆ సిసులుంఙ్ అముదు ఇడ్‍తద్ జర్గిల్త అర్తమ్ ఎరెతిన్. ఆ గొట్టిన్ డప్‍త కడితుంఙ్‍, ఔరుంఙ్ అద్ కరిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","యేసుంద్ యేరికొ పట్నం మెర గదియెంఙ్, అత్తి పావుంఙ్‍ పకంఙ్ ఒక్కొంద్ ఉదుత్ బిసెంవెల్సా అండెద్. ");
INSERT INTO nit_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","మాంది విడుత్ సెరెకా సపుడున్ వింత్న, “తానెద్ఎర్సన్సాద్?” ఇసా వెలుత్‍ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","తే ఔర్, “నజరేత్ యేసుంద్ ఈ పావడ్‍ సెసాన్సాద్” ఇసా ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","అప్పుడ అముదు గుడ్డి, “యేసు, దావిద్ పోరక్ ఎన్నివ! అన్ పొయ్ దయాఓలిప్!” ఇసా జోరకత్న వాపొయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","తే అమ్నుంఙ్ ముండటడ్‍ విడెకర్ “దబ్ అన్” ఇసా సెయ్‍తెర్. గని అముదు పెన్న ఇంకా జోరనట్, “దావిద్ పోరక్ ఎన్నివ! అన్ పొయ్‍ దయ్‍దయాఓలిప్!” ఇసా వాపొయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","తే యేసుంద్ ఇలుత్, “అమ్నున్ అన్నవై సుముత్ కొర్ర” ఇసా గొట్టి సియ్‍తెంద్ ఇసా యేసుంద్ అమ్నున్ వెలుత్‍ ఓల్తెంద్ ఇసా తే అముదు గుడ్డిన్ ఔర్ కొత్త వెన్కత్, ");
INSERT INTO nit_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“అన్ ఇనుంఙ్ సటీ తగల్ ఇసాతీ?” అప్పుడ్‍ అముదు, ఇసా యేసుంద్ అమ్నున్ వెలుత్‍ ఓల్‍తెంద్ ప్రబు! అనుంఙ్ నదుర్‍పాజె ఇసా ఇన్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","యేసుంద్ ఇంతెంద్ “ఇన్నె కండ్లడ్ నీ ఓల్! ఇన్నె విస్వాసి ఇన్ సోయ్‍ కత్తిన్” ఇసా ఇడ్‍తెంద్ ");
INSERT INTO nit_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","అప్పుడ్‍ వెంటాయ్ అమ్నె కండ్లు సోయ్‍ ఎద్దే. అముదు దెయ్యమున్ దనెవాద్ ఇడ్‍తెంద్, యేసునున్ వెంటాయ్‍ సెద్దెంద్. సిమన మంది ఇదున్ ఓలుత్న, దెయ్యమున్ మహిమ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","యేసుంద్ యేరికొ పట్నం సొగుత్న వడ్సా అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ఇదే విండ్ర! ఆ పట్నం జకయ్య ఇనెకా ఒక్కొ మన్కక్ అండెద్. అముదు టెక్సవసులికలెకారె దండి అదికరి ఎన్నెంద్ అని అంనంత్తి పెరెత్ జాయ్జత్ అండ్డిన్. ");
INSERT INTO nit_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ఆ గట్కంఙ్ యేసుంద్ ఎద్‍ ఎన్నెంద్ ఎర్ర? ఇసా ఓలెంఙ్ కోసీద్ కతెంద్. గని అముదు గుల్లెనా టుగ్రి అడ్డకడితుంఙ్‍, మాంది నత్తి అనెకా యేసునున్ ఓలెంఙ్ సాలెతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ఆ పవడ్‍ వర్సద్ ఇసా ఒర్కిలుత్న, ముదర్‍వై తుల్‍ సెద్దెంద్ అని మెడి మకుత్ సొక్కుత్, ఓల్‍సా నంనెద్. ");
INSERT INTO nit_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","యేసుంద్ ఆ జాగంఙ్ గదియ్‍త వెంటాయ్‍, పొయ్‍ ఓల్తెంద్. అని అమ్నున్, “ఇంతెంద్ జకయ్య జల్ది బూడున్ డిగ్! ఇన్నెడ్‍ ఇన్నె ఎల్లత్ అన్ ముకమ్ కలెంఙ్” ఇసా ఇసాత్. ");
INSERT INTO nit_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","అప్పుడ్‍ వెంటాయ్ జకయ్యక్ మాక్ తన డిగుత్న, కుసినడ్‍ యేసునున్ తన్నే ఎల్లంఙ్ కొస్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","సిమనా మంది ఓలుత్, పాపి నె ఎల్లంఙ్ తనుంఙ్ సెద్దెంద్ ఎర! ఇసా యేసున్ బదోల్ ముల్గతెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ఎల్లంఙ్ వత వెన్కత్ జకయ్య ఇలుత్, “ఇదొ ప్రబు! అన్నె ఆస్తి తన సార్సమ్ ఈసా గరిబులుంఙ్ సియ్‍సాత్. అన్ ఎనుని పసిపుత్, తనెని ఎక్కద్ సుమ్‍ తన్‍ ఎరతె, అమ్నుంఙ్ నాలిఇసా జాస్తి మలపుత్ సియత్” ఇసా యేసునుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","యేసుంద్, ఇన్నెడ్ నివ్‍ అని ఇన్నె ఎల్లత్, “ఇనెడ్ రక్సన వతిన్ తనుంఙ్ ఇంత్తే నినాయ్ అబ్రాహామ్ లాఙ్ బగవంతకుంన్ పొయ్య బరొస కత్తీ. ");
INSERT INTO nit_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","మన్కనె పోరక్ పావ్‍బులిలుత్ అనెకరున్ కిరవుత్ బత్కిపెంగీ వతెంద్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","సిమ్కన మంది ఈ గొట్టి ఉదహరనన్ ఇడ్డెఙా విసనంనెర్. యేసుంద్ యెరూసలేముంఙ్ వాత్త కడితుంఙ్‍, దెయ్యమ్నె రాజ్యం వారెకద్ గుల్‍మెర అన్సాద్ ఇసానంనెర్‍. ");
INSERT INTO nit_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","అదుంఙ్ ఎత్తీ యేసుంద్ ఔరున్ ఈ నమునా ఇడ్‍తెంద్, “రాజ కెర్‍లాంఙ్ ఒక్కొ మన్కక్ రాజకెరె కన్‍దన్‍తద్, ఒక్కొ రాజక్నె పోరక్ మన్కక్ రోమ రాజక్నె కెయ్యుత్ తన్ రాజ్యం ఎత్న, తన్నె దేసుంఙ్ మలయుత్ తన్నె ఎల్లంఙ్ వతెంద్.” ");
INSERT INTO nit_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","అప్పుడ్‍ తన్నెపది మంది సిసులున్ కూగుత్న, ఒక్కొనుంఙ్ ఒక్కొద్ ఒక్కొద్ పది బఙ్ఙర్నె దుగనిక్ సియుత్, అన్‍మలయుత్‍ వంనంత్తెంఙ్ బేపరి కలుర్ ఇసా ఇడుత్‍ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","గని అమ్నె మంది అమ్నున్ మెస్సెటన్నేర్. అదుంఙ్‍ ఎత్తి ఇమ్‌ద అమున్ లోపా రాజ్యం అడిగిపెకాంద్ అముంఙ్ ఇస్టంతొద్‍ ఇసా రోమ రాజక్‍ నత్తి అమ్నున్ వెంటాయ్‍ కాబుర్‍ సియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ఎన్ గని అముదు రాజ్యం ఎత్న మలయుత్ వతెంద్. అనంఙ్ వత్త వెన్కత్ తన్ సియ్‍త పైసె ఎంద్‍ ఎన్ని కామయ్ కత్తెదొ? ఒర్కిలెంఙ్ ఇసా ఔర్ సిసులున్ కుగ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","తే పేలెతంద్‍ వత్న, ప్రబు! నీ సియ్‍త ఆ బఙ్ఙార్నె దుగని మెహ్నత్ కత్న, అదున్ బరాబర్ పది బఙ్ఙార్నె దుగనిక్ కామయకత్తన్ ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","అపుడ్ రాజక్ ఆహనివ్! సోయ్త పని కత్తివ్. ఉసుటెగి నమ్మకమడ్ అండీ, పది పట్నలున్ పొదె అదికార్ నీ ఎత్న మాన్ ఇస సిసునున్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ఇంక ఒక్కొద్ వత్న, ప్రబు నివ్ సియ్త బఙ్ఙర్నె దుగని తన ఇక్క ఐద్ బఙ్ఙర్నె దుగనిక్ కామయకత్తన్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ప్రబుంద్ అన్నున్ వెంటా, నినయ్ ఐద్ పట్నలుంఙ్ పొదె‍ అదికారిని అత్నమన్ఇస ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","అపుడ్ ఇంక ఒక్కొద్ సిసుంద్ వత్న, ప్రబు! ఇద్దొ ఇన్నె బఙ్ఙర్నె దుగని. ఇదున్ అన్ జుఙ్ఙెత్‍ గుడాపుత్ డపుత్ ఇట్టన్. ");
INSERT INTO nit_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","తానుంఙ్ ఇంతె నీ కుబ్ కట్టిన్‍తనివ్ ఎన్నివ్. ఇడెతన్ అదున్ తవ్వున్న అని విత్తుత్న అదున్ అర్కెకనీ ఎన్ని. అదుంఙ్ సటీని నివింతె అనుంఙ్ కుబ్ అర్రి ఇసా ఇడ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","అపుడ్ అముదు రాజక్, కరాబ్ సిసుంద్! నీ ఇన్నె మూతితన కురియెకా గొట్టినాడ్‍ న్యాయ్ కల్సత్. అన్ కట్టిన్‍తన్ ఎందున్. ఇడెతన్ అదున్ సులుపుత్. ఇంతె తన అదున్ తరస్ ఇసా ఈనుంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","అన్నె బఙ్ఙార్నె దుగని బద్లిపుత్న పైసె ఎకుత్న బెంకుత్ తనుంఙ్ తప్పెతి? అనంఙ్ తప్పెంగెందె అన్నె దుగనిక్ పైసె బరాబర్ వడ్డినాడ్‍ అనుంఙ్‍ వన్నె ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","అని మెరా ఇలుత్‍ అనెకర్ సేవకేర్ వెంట, ఇమ్న తన ఈ బఙ్ఙర్నె దుగని సుముత్, బఙ్ఙర్నె పది దుగని కమయ్ కల్సాత్ కేయ్యుత్‍సియ్‍ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ప్రబు! అమ్నత్తి పది బఙ్ఙార్నె దుగని అన్సావా! ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","అదుంఙ్‍ ఎత్తి రాజక్, అన్‍ ఇడ్డెకాద్ తానెద్ ఇంతె. ఏనత్తి పేలె అన్సావొ అమ్నుంఙ్ పెన పేలె సియెకాద్ వరద్ గని ఎనంత్తి కొన్ని అన్సవొ, అమ్నతన డాప్తవున్ కొన్నికున్ గిన నాయ్ పుసెకాదా వారాద్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","అని అన్ రాజ్ అడ్గిపెకాద్ ఇస్టం తోతెంద్ ఔరున్ విరోద్ అన్ ముండట్ అల్ఙుర్ ఇసా ఇడ్‍తెంద్ ఇసా యేసుంద్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","యేసుంద్ ఈ నామునా ఇడుత్న, యెరూసలేమ్‍ వై సొకుత్ సెరెంఙ్‍ కుర్యితెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ఒలీవ మాకులె మెట్పొల ఎల్లక్‍, బేత్పగేంఙ్ అని బేతనియ మెరమ్ గదితెర్‍ తన్నె సిసులూన్ ఇద్దర్ కుగ్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","అప్పుడ్ యేసుంద్ తన్నె సేవకేర్ తన్నా ఇద్దరున్ ముండట్ పన్కదాంద్. ఇదొ! ఆ కన్కెరెకా ఊరున్‍ సొఙెఙాయ్, అత్తి ఒక్కొ సిన్నం గాడ్దిన్ కట్టుత్ అనెకాద్ ఇముంఙ్ కండ్కెరాద్. అదున్‍ పొయ్ పంగి దూక్ ఏరి ఉద్దెతెద్. అదున్ ఉడ్‍పుత్‍తొడా వర్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ఆ గాడ్దిన్ ఉడ్పెఙయ్, తనుంఙ్ ఉడ్‍ప్సాన్సాతిర్? ఇసా ఎరేనా వేల్తొల్తెర్ ఇంతె, ఇద్ ప్రబునుంఙ్ పాజె ఇసా ఇడుర్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ఔర్ పన్కతర్ సెత్‍ ఓలెంఙ్‍, యేసుంద్ ఇడ్తెతియ్ అద్‍ కొయ్యత్ కట్టుత్ అనెకాద్ కన్కెదిన్. ");
INSERT INTO nit_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ఆ గాడ్దినె కొవ్వె ఊడుప్సనేఙ ఓలుత్న, అద్నె మాల్కకెర్, నీర్ తనుంఙ్ గాడ్దిన్ ఊడుప్సనంసాతిర్? ఇసా వెలుతొల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ఔర్, “ఇద్ ప్రబునుంఙ్ పాజె ఇసా ఇంతెర్” సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","అపుడ్ ఆ సిన్నం గాడ్దిన్ యేసున్‍వై తోడా వత్తెర్. అని అదున్‍ పొయ్ తమ్మె జుఙ్ఙె తప్పుత్న, యేసునున్ ఉదిప్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","యేసుంద్ అనాయ్ పవీ సెసననెఙా, మందితమ్మె జుఙ్ఙెలున్ పావుత్ తటెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","అనంఙ్ యేసుంద్ ఒలీవ మాకులె మెట్ పొలడ్ బూడున్ డిగ్గెక పావుత్ అమ్నున్ వెంట వరెకార్ పెర్రెత్ మంది సిసుల్ అముదు ఇదార్త సమత్కర్లున్ ఓలుత్ జోరనాట్ కుసినడ్‍ దెయ్యమున్, మొక్కెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ప్రబునె పేరాడ్ వరెకాంద్ దన్యు” రాజక్ మహిమ అని పరలోకం సాంతి ఎక్కాద్ ఇసా వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","అపుడ్‍ ఆ మందినంత్తి అనెకార్ కొన్సెం మంది పరుసిక్, “ప్రబు! ఇన్నె సిసులున్‍ సురుమండ్ర ఇసా సిరయ్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","యేసుంద్ అన్ ఇడ్డెకాద్ తన్నె ఇంతె. మోకా ఇవ్రు సుయ్‍అడెరింత్తె, తమ్మెత్ తమ్మి గుండ్లా వపొయెంఙ్ మోదల్ కాద్దా ఇసా ఇడ్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","యేసుంద్ యెరూసలేమ్ పట్నం మెరం గదియ్‍తా వెన్‍కత్ ఆర్సా, యెరూసలేమ్ తార్! గని ఇండి ఇదుంన్‍ నీర్ ");
INSERT INTO nit_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","గని ఇండి ఇదుంన్ సాంతితవున్‍ కరిపెకాద్‍ ఇంతె ఇముంఙ్‍ సోయ్‍ ఆదా నీర్ కరిపెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ప్రబుంద్ ఇన్ దర్సన్ సియ్త కాలముంఙ్ నీ ఒర్కిలెతి అదుఙెత్తి ఇన్నె విరోదు ఇన్ తిర్గొర దురనె డెగ్గు సియ్సా కటుత్ అన్ తిర్గొర ఎత్న సిమ్కన పకంఙ్ అన్ అదుమ్సార్. ఇన్ ఇనత్తి ఇన్నె పొరకెరున్ దురగ్ సియ్దర్. ");
INSERT INTO nit_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ఇమంత్తి అనెకర్ నీర్ ఇమ్మె పోరకేర్ గోడలుంఙ్ పొయ్ ఇల్‍సెట అందాద్ ఇసా ఇడ్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","అని యెరూసలేమ్‍త పార్తన కలెక జాగంఙ్ సెత్న, అత్తి సుమ్ముత్ విరెక బెపరి కలెకార్ వెంటా, ఈ మందిర్ అన్నె ఎంద్ అని పార్తన కలెకా జాగ ఎంద్, ఇసా నియమ్ సాస్త్రత్ వాయుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","అపుడ్ అముదు మందిరుత్ వత్న అత్తి విరెకర్ వంట అన్నె మందిర్ పార్తన మందిర్ ఇసా వాయుత్ అండద్, గని నిర్ అదున్ డొంఙలె మందిర్ లాంఙ్ బనప్తిర్. ఇసా ఔరున్ అత్రనట్ పుసెకద్ ఎదిన్. ");
INSERT INTO nit_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","అనంఙ్ ఎద్ద వెన్కత్ అముదు రోజి మందిరుంఙ్ సెత్న, బొదా ఇడ్సానంన్నెంద్. గని దండి దెయ్యలకెర్, సాస్త్రిక్ అని యూదులె దొడా అమ్నున్ ఎనంఙ్ అల్ఙేఙ్ ఇసా ఔర్ పిలన్‍తప్పెకాద్ మొదలిట్టేర్. ");
INSERT INTO nit_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","గని సదర్ మంది యేసుంద్ ఇడ్డెకా గొట్టికున్ గియనాడ్ విసనన్నెంఙ్‍, యేసునున్ ఎనంఙ్ నసానం కలెకాదొ ఔరుంఙ్ కారిలెతిని. ");
INSERT INTO nit_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ఒక్క జీర్‍ మందిర్ ఆవరత్‍ యేసుంద్‍ బొదా ఇడ్సా, సోయ్త కబురున్ ఇడ్సానంన్నెద్. అప్పుడ్ అమ్నంత్తి దండి దెయ్యలకెర్, సాస్త్రిక్ అని యూదులె దండి వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","నీ ఏ ఆదికరాడ్‍ ఈ కామ్ కాల్సానంసతి? ఈ అదికార్ ఇనుంఙ్ ఎంద్‍ సియ్‍తెంద్? అముంఙ్ ఇడ్ ఇసా యేసునుంన్ వెలుత్ ‍ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","“అన్ ఇమున్ ఒక్కొ సావల్ వేల్తొలెంఙ్ ఇడుర్. ");
INSERT INTO nit_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","యోహాన్ సియ్‍త బాప్తిస్మ పరలోకమ్ తన వత్తినా? మన్కకెర్ తన వత్తినా? ఇడ్డుర్” ఇసా ఔరున్‍ వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ఔర్ తమ్మెత్ తమి ఇసార్, పరలోకమ్ తన వత్తం ఇసా ఇంత మింత్తె, తనుంఙ్ యోహానున్ పొయ్ బరొస ఇడెతిర్? ఇసా అముదు వెల్తొల్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","గని ఒక్కొమోకా, మన్కక్ తన ఇంత మింత్తె, నేండున్‍ సదర్‍ మంది గుండ్లడ్‍ ఇడదర్. తానుంఙ్ ఇంతె యోహాన్ కబుర్లకేర్ ఇసా సిమ్కన నక్కి బరోసా ఇడ్దర్. ");
INSERT INTO nit_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","అదుంఙ్ ఎత్తి ఔర్, “ఎత్రనట్ వత్తినొ అముంఙ్ ఒర్కితొద్” ఇసా యేసునున్ జవాబ్ సియ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","అదున్‍ యేసుంద్, “అన్నయ్ ఏ అదికార్ రడ్ ఇద్దా కాల్సాతొ ఇముంఙ్ ఇడ్డెన్” ఇసా జవాబ్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","అనంఙ్ ఎద్ద వెన్కత్ యేసుంద్ ఈ ఉదహరన ఇడ్డెంఙ్ సురు కతెంద్. ఒక్కొ మన్కక్ అంగుర్నె వాడి తయార్‍కత్న, మరొక్కొనున్ జీతమ్ ఇట్టెద్. అని ఎల్లన్ సాయుత్ మరొక్కొ దేసుంఙ్ పేలె సాల్‍కులుంఙ్ సటీ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","అంగుర్నె వాడిత పడ్ల పుత్తెక కాలం వాత్త వెన్కత్ ఆ మన్కక్ తన్నె ఈస కో ఇసా ఒక్కొ సేవకున్ మునప సుమ్తన్వై పన్కతెంద్. గని ఔర్ ఆ సేవకున్ లగపుత్, రికమ్ కెయ్యులాడ్ పనుక్తేంర్. ");
INSERT INTO nit_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","అముదు పెనా ఒక్కొ సేవకున్ పన్కతెంద్. గని అమ్నున్‍ నాయ్ లగప్త్తెర్. అమ్నెఇజ్జతున్ పుస్తేర్ అని, రికమ్ కెయ్యులాడ్ పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","అపుడ్ ఆ మన్కక్ పేన ఒక్కొ సేవకున్ పనులుతెంద్. గని ఔర్ అమ్నున్ నెత్తుర్‍ వంన్‍ లగపుత్న వాకా డగ్లిప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ఆ అంగుర్నె వాడి మాల్కక్ లాడ్తంద్ తన్నెత్ తని, “తగద్దున్? తన్నెలాడ్తంద్ ఇన్అపుడ. ఔర్ అమ్నుంఙ్ మనింల్‍దర్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","గని మునపనాడ్ సుమ్‍ తెంద్ అముదు తన్‍వై వరెకానున్ ఓలుత్న ఇమ్‌ద మాల్కక్నె కీకె ఎన్నెంద్. ఇమ్నున్ అలంఙ్తె, ఈ ఆస్తి నేండెతి ఎరద్ ఇసా నిర్నయ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ఔర్ అమ్నున్ అంగుర్నె వాడి తన వాకా డగ్లిపుత్నా, అమ్నున్ అలుంఙ్ తేర్. అపుడ్ ఆ వాడిత మాల్కాక్ ఔరున్‍ తాగతెంద్‍ ఇసాతిరా? ");
INSERT INTO nit_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ఆ మాల్కక్ వాత్, ఔరున్ నాస్ కతెంద్ అంగుర్నె వాడి మరొక్కొరుంఙ్ మునపనాడ్ సియ్తెంద్ ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. అదున్ వినుత్ అనుంఙ్ ఏపుడి ఇనంఙ్ ఎరెంఙ్ తోద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ఔరున్ సార్కక్ ఓల్సా, “ఎల్ల కట్టెకార్ తన్ఎదుంగి పని సియెద్ ఇసా మనుంఙ్ కొర్‍సెట గుండ్, సిమ్కనంఙ్ ఎన పనిత్ పడ్సెట గుండ్ ఏత్ ఇల్‍త్తిన్ ఇనెకాద్‍ నియమ్ సాస్త్రత్ అనెకా ఈ గొట్టిక్నె సంగతి తనెద్ ఇసాతిర్?” ");
INSERT INTO nit_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ఆ గుండ్ పొయ్ రాలెకార్ సిమ్కన తుక్డెలెద్దార్. ఒక్కొ మోకా ఆ గుండ్‍ ఏన్ పొయ్నీ రాటినింతె, అమ్నున్ దుబ్బా కల్సాద్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","అదున్ వినుత్ ఆ దండి దెయ్యలకెర్, సాస్త్రిక్ అమున్ బదోలి ఈ ఉదహరన ఇడ్తెంద్ ఇసా కరిప్‍త్తెర్. అని ఆ గట్కఙి అమ్నున్ సుమ్మెంఙ్ ఓల్నేర్ గని మందిన్‍ ఓలుత్ అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","అది నీతి అమ్నున్ పొయ్ నదుర్‍ తప్పుత్ ఇంతెర్. అమ్నె గొట్టిక్‍లెంఙ్ గలత్ పుసుత్న, అమ్నున్ రోమ్ అదికారముంఙ్ సుమ్ముత్ సియెంఙ్ కాద్ ఇసా ఔరె పిలన్ అండిన్. తే ఔర్ కటొడాకెర్ అని సాస్త్రిక్ గుల్‍ సోయ్‍ తర్లంఙ్ ఇడ్డెకరున్ మంది యేసున్‍వై పన్కతెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ఔర్ అమ్నతి వత్, “ప్రబూ! నీ ముడెకద్ అని బొదా కలెకద్ సత్తెం ఎద్ద. ఎన్నెతి బేత్బావు ఓలెకాని ఎరె. దెయ్యమ్నె కరెయ్ మార్గముతగ ఎనంఙ్ అనాయ్ ఇడ్డెకని నీ ఎన్ని ఇసా అముంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ఇండి అమ్ సిమ్కన మంది రొమ రాజుఙ్ పన్ను కట్టెకాద్ న్యాయ్ మా తొదా?” ఇసా వెల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","అన్ ముడెకాదున్ తప్పు గడిపెకంద్ ఓల్సానన్నేర్ యేసుంద్ కరిపుత్న, “అనుంఙ్ ఒక్కొంద్ వేండి దుగని ఓలిపుర్” ఇసా వెల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","ఔర్ కల్దర్ సియ్‍ తా వెనకత్, “ఇత్తి ఎన పేర్ అని ఎన్నె రూప్ అన్సాద్?” ఇసా వెల్తొల్తెంద్. తే ఔర్ రొమ రాజక్నెత్ ఇసా ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","తే యేసుంద్, “రొమ రాజక్నెత్ రోమ రాజకుఙి సియుర్ అని దెయ్యమ్నెత్‍ దెయ్యముఙి సియుర్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ఇనంఙ్ ఇడ్తదున్ ఔర్ అదికాలె మందిన్‍ ముండట్ అమ్నున్‍ గొట్టిత్ తప్పుత గట్టిపెంఙ్ సాలేతెర్. అదీ ఎరెకాడ్ అముదు ఇడ్‍ తా జవాబున్ వింత్న గుల్‍ ఎత్న, పెనా సురుమి అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","అనంఙ్ ఎద్ద వెన్కత్ ఎరి తిక్తార్ బక్సర్ ఇన్నెకర్ సద్దుకి యేసున్‍వై వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“బొదకా! నియమ్ సాస్త్రత్ మోసే ‘దాదక్ తిక్‍త్తే అమ్నె తొరెంద్ వన్నాన్ మాస కత్న తన్నె దాదకుంఙ్ సటీ పిల్ల పడ్స ఎరెంఙ్‍ పాజె. ఆ పిల్ల పడ్స దాదక్నె సత్తన్‍ తా లెక్కంఙ్ వార్‍సార్’ ఇసా వాయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ఒక్కొ వెలా ఏడ్గుర్ దాదక్ తొరెండ్ల అండెర్ ఇడ్ర. ఔర్తన దండి వాలె పెండ్లిక్ ఎద్దెంద్. గని పిల్ల పడ్స ఎర్‍సెటాయ్ తిక్‍తెంద్ ఇడ్ర. ");
INSERT INTO nit_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","అనాయ్ వెన్కతద్‍నై అదునీ మాస కత్న, పిల్ల పడ్స ఎర్‍సెటాయ్ తిక్‍తెంద్ ఇండ్రు. ");
INSERT INTO nit_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","అనంఙ్ ఒక్కొంది ఒక్కొంది ఏడ్గుర్‍ నాయ్‍ అదున్ మాస కత్న పిల్ల పడ్స ఎర్‍సెటాయ్ తిక్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ఆక్రింఙ్ ఆ పిల్ల నాయ్ తిక్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","తిక్ తార్ బక్సర్ వెన్కత్ ఆ పిల్ల ఔర్ ఏడ్గుర్ లోప అనుంఙ్ మాస ఎద్దిన్?” ఇసా యేసునున్ వెల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","యేసుంద్ ఔరుంఙ్ ఉత్తర్ సియ్‍సా, ఈ కాడుత్ పిల్లన్ సియెకాద్ అని పడ్సనె పెండ్లిక్ కలెకా ఎర్సాని అన్సా. ");
INSERT INTO nit_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","గని కాడుత్ తిక్ తార్ బక్సర్ ఎరి పెండ్లిక్ ఎరెర్ అని పెండ్లి క్ కాలెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","తిక్కుత్ పానం ఎరెర్, ఔర్ దెయ్యమ్నె పిల్ల పడ్స ఎద్దర్. ఇవ్రు పెన్న ఒక్కొ మట్ తిక్ తార్ బక్సర్. తానుంఙ్ ఇంతె స్వర్గుత్ అనెకా దూతులంఙ్ అన్సార్. ");
INSERT INTO nit_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","తిక్తర్ పానమ్‍ ఎరెకాదున్ బదోల్ మోసేనె కేయ్యుత్ నియమ్ సాస్త్రత్, ప్రబుద్ అబ్రాహామ్, ఇస్సాక్నె అని యాకోబ్‍ చర్న దెయ్యం ఎద్దున్ ఇసా రాబిలెకా తుట్టి తాన దెయ్యం వయ్‍గత్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ఔర్ సదర్‍ మంది దెయ్యమ్నె నదురడ్ సుమ్‍త లెక్కనడి వత్తెర్. తే ఔర్ ఉసలి దెయ్యం ఎరెంద్ గని ");
INSERT INTO nit_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","కొన్సెం మంది సాస్త్రిక్, “బొద ఇడ్డెకానీ వా! సోయ్‍ ఇడ్‍త్తీ” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ఇడ్డెకని, నీ గుల్ సోయ్‍ ఇడ్‍తి ఇంతెర్ ");
INSERT INTO nit_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ఆదుంఙ్ వెన్కత్ యేసుంద్ ఔరున్, క్రీస్తు దావిద్‍ నె కికే ఇసా ఔర్ తనుంఙ్ ఇసార్? ");
INSERT INTO nit_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","అన్ ఇన్నె విరొదికున్ ఇన్నె గెట్టలెంఙ్ ఇడ్‍నంత్తెంఙ్ అన్నె ఉన్న పకంఙ్ ఉద్దెద్ ఇసా ప్రబుంద్ అన్నె దెయ్యమున్ ఇడ్నెద్ పుస్తకుత్ దావిద్ ఇడ్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","అన్‍ ఎన్నె విరోద్ కలెకనున్ ఎన్నె గెట్ట బూడున్ ఇడ్నంత్తెత్, దావిద్ తన్నె కిర్తనలత్తి ఇనంఙ్ వయ్‍ తెంద్‍ తా! ");
INSERT INTO nit_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","దావిద్ అమ్నున్ ప్రబుంద్ ఇసా ఇంతెంద్ తా! ఆ అప్పుడ్ అముదు దావిద్‍నే కీకె ఎనంఙ్ ఎద్దద్? ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","మంది యేసుంద్ ఇడ్డెకావున్ విసా అత్తీని అన్సార్. అముదు తన్నె సిసులూన్ ఇనంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","సాస్ర్రిక్ బదోల్ గియనాడ్ అడ్ర! ఔర్ పొలాడ్ తే బుడుంఙ్ ఎంత్ పొడా జుఙ్ఙే తొడుత్ బాజల్‍లెంఙ్ అని తమున్ మనిపుత్న, తముంఙ్ ప్రేమ సియెంఙ్ కొర్సార్ మందినె యూదులె సావ్డిత్ జెవునులెంఙ్ తమ్మె దండి పానున్ ఇడెంఙ్ ఇసా, ఔర్ సాస్త్రిక్ ముండట్ అనెకార్ ఉద్దెకా కుర్చిక్లత్తి ");
INSERT INTO nit_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","రాడెరాసికున్ పసిపుత్న, అదవ్లె దన్ దవ్లతున్ ఎల్లన్ లుటిప్‍తెర్. ఇదున్ డపెంఙ్ ఇసా పొయ్ పొయ్ బక్తిన్ ఓలిప్‍సా, మందిన్ ముండట్ పెర్‍గడి పార్తన కల్సా అన్సార్. ఇదా ఇటావుంఙ్‍వాలడ్ ఔరుంఙ్ దెయ్యం పెన్న దండి సిక్స తప్పెంద్, ఇసా యేసుంద్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","యేసుంద్ ఓలాసా అనెంఙ్‍, దనవంతకెర్ దాన్ పెటిత్ దాన్ ఔర్ తాపెకరున్ ఓల్సద. ");
INSERT INTO nit_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ఒక్కొ గరిబ్ రాడెరా ఇంది సిన్నా పైసె దాన్ పెటిత్ తపెకదున్ అముదు ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","మల్ల అముదు ఇంతెంద్. అన్ ఇముంఙ్ కరెయ్ ఇడ్సత్. ఇగరిబ్‍రాడెరా ఔర్ సదరుంఙ్ ఎన జాస్తి తాప్తీన్. ");
INSERT INTO nit_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ఔర్ సదర్ తమ్మె పేలె పైసె తన కొన్ని సియ్‍తెర్ గని ఈ పిల్ల తాన్ గరిబ్‍ అత్న, తాన్నె బాతుకుంఙ్ సటీ కమప్‍ తదున్ ఆస్తి సిమ్కన తాప్తీన్. ");
INSERT INTO nit_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","సోయ్త గుండ్లడ్ అని దెయ్యముంఙ్ సియ్‍త దానా మందిరుత్ సింగరిపుత్ అండెర్. అదుంఙ్ బదోల్ కొన్సెం మంది ముడెంఙా, అముదు ఇంతెంద్: ");
INSERT INTO nit_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","అపుడ్ యేసుంద్ ఔరున్ ఇంతెంద్, ఇటా దినా వరెకా అన్సా: నీర్ ఓలతిర్, ఇత్తి ఒక్కొద్ గుండ్ పొయ్ ఒక్కొగుండ్ నాయ్ అనే. సిమ్కన ఓద్రిలెకా అంసా. ");
INSERT INTO nit_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","మల్ల ఔర్ అమ్నున్ వెలుత్ ఓల్‍నెర్. ప్రబు, ఇద్ ఎపుడ్ ఎరాద్? ఇద్ ఎరెకా వెలా వత్తిన్ ఇంతె ఎనంఙ్ సిన్న ఒర్కిలెకద్? ");
INSERT INTO nit_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","అముదు ఇసాద్. ఎది ఇమున్ పసిపెంఙ్ తోద్ ఇసా ఉసారడ్ అండ్రు. తానుంఙ్ ఇంతె పేలెటర్ మన్కకెర్ అన్నె పేరడ్ వత్న అన్ దెయ్యమ్నె మన్‍వలె ఎందున్ అని ఆ వకత్ మెరా వత్ అన్సాద్ ఇసా ఇడ్సర్. ఔరున్ వెంట్టసెనెర్. ");
INSERT INTO nit_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","లడెయ్ అని జులుసూ బదోల్ విన్క వరెంఙ గబ్రిల్‍నెర్. తానుంఙ్ ఇంతె అదా పేలె ఎర్రెంఙ్ పాజె గని ఆక్రి జాలద్ ఎరెద్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","మల్ల అముదు ఔరున్ ఇంతెంద్. దేసుంఙ్ విరోద్ దేస్‍ సులాద్ రాజ్యంఙ్ విరోద్ రాజ్ సుల్సా. ");
INSERT INTO nit_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","గుల్‍ దండి బుకంపము ఎద్ద. ఎత్తి అత్తి దుస్కడ్ వత్తిన్. రోగు వత్న ఉల్ మురాయ్సా. అర్పులిపెకా గొట్టిక్ అని దండి సిన్న పరలోకమ్ తన ఎదా. ");
INSERT INTO nit_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","గని ఇదా సదర్ ముండట్ ఇవ్రు ఇమున్ సుముత్ కొసుత్న తక్లిబ్ సియ్‍దర్. నీర్ అన్నె పేరుంఙ్ వెంట్టతరెంనీర్ ఇసా, ఇమున్ యూదులె సావ్డిక్లెంఙ్ కొసుత్ ఇల్పదర్, జేలుత్ కొడపెకరె కెయ్యుత్ సియ్యతెర్ అని ఇమున్ రాజక్ కెర్ అని రాజునె అదికల్ ముండట్ కొస్సార్. ");
INSERT INTO nit_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ఇద్ ఇముంఙ్ సాక్సం ఇడ్డెకా వెలా రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ఎనంఙ్ ఇడెంఙ్ ఇత్న నీర్ పేలెయ్ వసర్ కలెంఙ్ తోద్ ఇసా పక్క మనుత్ అపుర్. ");
INSERT INTO nit_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","తానుంఙ్ ఇంతె అన్ ఇముంఙ్ గొట్టి అని బుద్ది సియ్యసాత్. అదున్ ఇమ్మె విరొదిక్ ఎరీ ఇముంఙ్ విరోద్ ముడెంఙ్ అని గటిపెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ఇమ్మె బాంద్‍ అమ్మ, దాదక్ కలయ్‍తర్ సంఙ్తకేర్ నాయ్ సుముత్ సియ్‍సార్ అని ఇమున్ లోపా కొన్సెంమందిన్ ఔర్ అలఙ్‍దార్. ");
INSERT INTO nit_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","నీర్ అన్నె పేరాడ్, సిమ్కన మన్కకెర్ ఇమున్ విరోద్ కల్సర్‍. ");
INSERT INTO nit_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","గని ఇమ్మె తల్త ఒక్కొ తిర్‍నాయ్ నాస్ ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","నీర్ ఇమ్మెలోపా సహిన్ వాలడ్ నీర్ ఇమ్మె పానమున్ బత్కిప్సతీర్‍. ");
INSERT INTO nit_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","అద్ ఎదహ వెన్కత్ యేసుంద్, “ఎపుడ్ యెరూసలేమ్ ఊరున్ సిర్ముట్ సిపాయిక్ గేర్‍సియుత్ అనెకరున్ ఓల్‍సతివొ, అపుడ తన్నె నాస్ ఎరెకద్ మెరా వత్తిన్ ఇసా కరిపుర్.” ");
INSERT INTO nit_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ఆ వాకతుంఙ్ యూదియత్ అనెకర్ మెట్వై పరర్ ఎత్న. ఈ నాగురుత్ అనెకర్ వాక సెరెంఙ్ వాక అనెకర్ సిమ్కన ఈ నగురున్ లోపా సొంగెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","తానుంఙ్ ఇంతె సిక్స సియెకా దినాఎంన్నె. న్యాయ్ సాస్త్రత్ వాయ్‍తా వచండ్లు పూర అనంతెంఙ్ జర్గిల్‍దా. ");
INSERT INTO nit_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ఆ దినాలుంఙ్ పెట్టెనడ్ అనెకవున్ అని పాల్ సియెకా పిల్లకున్ పెరెత్ కస్టమ్ ఎరద్. తానుంఙ్ ఇంతె దెసెముత్ గుల్ తక్లిబ్ వారద్. ఈ దేస్తర్ పొయ్ తన్నె రగ్గున్ ఓలిప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","బెయ్మన్ మన్కకెర్ లడెయుత్ ఔర్తన కొన్సెంమందిన్ తల్వల్కలాడ్ అల్గంతెర్. అని పేలెటరున్ దాసి పాన్ కలెకదుంఙ్‍, మరొక్కొ దేసులెంఙ్ సుముత్ కొస్సర్. ప్రబు యూదులెర్సెటర్‍ సియ్త వెలంఙ్ యెరూసలేమ్ అని ఇస్రాయేల్ తమ్మె అదికారున్ బూడున్ ఇట్టెర్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","అని “పొద్ నెలా అని సుక్కలత్తి ఎపుడి. జర్గిలెతిన్ సిన్న జర్గిల్‍తె. బూమి పొయ్ సముద్ర త ఆవజున్ అని అద్నె అలావ వాడిల్స వాలడ్ సదర్ దేసులకెర్ అర్సుత్, దుస్కడ. ");
INSERT INTO nit_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","అపూడ ఆబార్‍ పొయ్ సక్తిక్ ఈ దున్యత పొయ్‍ అనెక సిమ్కన మెలగెకవున్ వాలడ్, ముదర్‍వై జర్గిలెకా గట్నలేం అర్రి మంది తోసెటా ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ఆ వాకతుంఙ్ స్వర్గత మన్కనె పోరక్ సక్తితద్ అని దండి మహిమనడ్ వెలంఙ్ డంమ పొయ్ వారెకనున్ సిమ్కన ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ఎపుడ్ ఈ గట్న సురుఎర్సవొఅపుడ్, ఇంమతాడ్ ఇలుత్ తల్లున్ ఎత్తుత్ అడ్ర. తానుంఙ్ ఇంతె దెయ్యం ఇమున్‍ బత్కిపెక వెలా అందద్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","అద్ ఇడ్త వెన్కత్ యేసుంద్ ఈ ఉదహరన ఇడ్తెంద్. మేడి మాకున్ అని మరొక్కొ మాక్ లున్ తొల్లిత పూట ఓలుర్. ");
INSERT INTO nit_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ఆ మకుత క్కొమ్ములానిగుర్ ఓలుత్న, ఉబ్బ కలమ్ వారెకద్ అన్సాద్ ఇసా నీర్ కరిప్‍తిర్. తా! ");
INSERT INTO nit_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","అదీ తిరాడ్ ఇదా సిమనా గట్నా ఎరెకవున్ ఓల్సా, దెయ్యమ్నె రాజ్యం మెరా వార్స నాంసాద్ ఇసా ఒర్కిలుర్. ");
INSERT INTO nit_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","ఇదా సిమనా జర్గిల్‍ ఇద్ ఇండి అనెకా కరెయ్ నరిమన్కక్నె జనాబ మురలుత్‍సెరెద్. ");
INSERT INTO nit_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ఈ ఆబార్ అని బూమిత సిమ్కన మురయుత్ సెదా గని అన్నె గొట్టిక్‍ఎప్పుడ్‍నాయ్ ఇల్లుత్‍అన్దా. ఇద్‍ సాత్తెంఎంద్. ");
INSERT INTO nit_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","తినెకద్ ఉనెకాద్ వాలడ్ కల్సా మజనడ్ అనెంఙ్ ఈ లోకంత అసానడ్ అనెక మన్లున్ మొపుకత్త అనెంఙ్‍, ఆ దినమ్ అప్పుడి ఇమున్ పొయ్ వర్సెట ఓలుర్. ");
INSERT INTO nit_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","అని బూమిత్ బత్కెకర్ నిర్‍ సదర్ పొయ్ అచానక్ అన్ వారెకా దినా అంన్సా. ");
INSERT INTO nit_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ముదర్వై జర్గిలెకా ఇదాసిమనాతన్న నీర్ సుకిపుత్, మన్కనె పోరక్ ముండట్ ఇల్లెంఙ్ సటీ సక్తితంద్ ఎరెంఙ్ ఇసా ఎపుడి పార్తన కల్సఅడ్ర ఇసా యేసుంద్ ఔరుంఙ్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","అనంఙ్ యేసుంద్ రోజ్‍ మందిరుత్ బొదా ఇడ్‍నెద్. అని చింత్తె ఒలీవ మాకులె మెట్‍పొయ్ సెత్న, ఆలా పుస అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","సిమ్కన మంది అముదు ఇడ్డెకా బొదాన్ వినెంఙ్ ఇసా తొల్లిని మందిరుంఙ్ వాంన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","పస్క ఇనెక పుల్లె నిప్పలె పండ్గ మెర వతిన్. ");
INSERT INTO nit_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","దండి దెయ్యలకెర్, సాస్త్రిక్ యేసుకున్ ఎనంఙ్ అంలంఙెకద్ ఇసా విచార్ కత్తెర్. తె ఔరు మందిన్ అర్సనెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","అప్పుడ బరా మంది సిసకేర్ లోప ఒక్కొంద్ ఇస్కరియోత్ యూదక్నత్తి సైతన్ సొంఙ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","అదుగి యూదక్ చెత్న అమ్నున్ ఎనంఙ్ ఔరుంఙ్ సుముత్ సియెకద్ ఇసా దండి దెయ్యలక్, దెయ్యమ్నె పార్తన త అదికలడ్ ముటెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","అదుంఙ్ ఔర్ కుసీంఙ్ వత్తెర్. అమ్నుంఙ్ పైసె సియెంఙ్ ఒపతెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","యూదక్ అదున్ ఓప్పుత్న మంది తోసెటాపుడ్ అమ్నున్ ఔరుంఙ్ సుముత్ సియెంఙ్ మొక ఓల్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","పొంఙ్‍సెటా నీప్పలె పస్క గొర్రెనె కొవ్వెలున్ తర్గెక పండ్గు మిసెమాడ్ పస్క ఇనెక దినమ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","యేసుంద్ పేతురు యోహాన్ వెంట, “నీర్ సెత్న నేండుంఙ్ తినెంఙ్ పస్కన్ తయార్ కలుర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ఔర్, “అమ్ అదున్ ఎత్తి తయ్యర్ కదుమ్?” ఇసా వెల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","అముదు, “నీర్ పట్నముంఙ్ సెరెంఙ్ దుత్తత్ ఈర్ కొసెకద్ ఒక్కొ మన్కక్ ఇముంఙ్ అడ్డమ వద్దద్.” అమ్ను వెంటాయ్ అమ్నె ఎల్లంఙ్ చెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","అమ్మె ప్రబు, అన్ అన్నె సిసులడ్ కలయుత్ పస్క అంబ తినెంఙ్ ఆలపుసేక కోలి ఎత్తిఅన్సాద్? ఇసా వెలసాద్ ఇసా ఆ ఎల్లతనుంఙ్ ఇడుర్ ");
INSERT INTO nit_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","అముదు సిమన తయర అనెక ఒక్కొ మీద్దె పొల కోలి ఇముంఙ్ ఓలిప్‍దాద్ పస్క పండ్గు. అత్తి తయార్ కలుర్ ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","బరబర్ అముదు ఔరుంఙ్ ఇడ్‍తెతియ్ సిమ్కన జర్గిల్‍తె. అదుంఙ్‍ ఎత్తి అముదు ఇడ్‍తెతియ్ ఔర్ పస్క అంబ తయార్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","వేల వరెంఙయ్ అముదు అమ్నునాయ్ అపొస్తులున్ తిన్నెంఙ్ ఉద్తేర్. ");
INSERT INTO nit_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","అప్పుడ్ అముదు, “అన్ సిక్స సుమెంఙ్ పేలెయ్ ఇమున్‍ వెంట కలయుత్ ఈ పస్క జెవున్ తిందత్ ఇసా గుల్ ఆసాకల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","తానుంఙ్ ఇంతె ఇడ్త దెయ్యమ్నె రాజ్యం వంనంత్తెంఙ్ మల్ల అదున్ తినెన్ ఇసా ఇముంఙ్ కరెయ్ ఇడ్సాతున్.” ");
INSERT INTO nit_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","పెన అముదు ఒక్కొ గిలసున్ సుముత్ దన్యివద ఇడుత్, నీర్ ఇదున్ సుముత్ పైయ్యుర్. ");
INSERT INTO nit_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ఇక దెయ్యమ్నె రాజ్యం వంనంత్తెంఙ్ అన్ ఎపుడి అంగుర్నె రసాన్ ఉనెన్ ఇసా ఇముంఙ్ ఇడసాత్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","అదుంఙ్ వెన్కత్ ఒక్కొ నిపట్టెన్ సుముత్న దెయ్యముంఙ్ దన్యివద ఇడ్డుత్ అదున్ ముర్కుత్ ఔరుంఙ్‍ సియుత్, “ఇద్ ఇముంఙ్‍ సటీ అన్నె సరీర్. అన్ అదికలెకదుంఙ్ ఇదున్” కలుర్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","అనాయ్ తింద వెన్కత్ అముదు ఆ గిలసున్ సుముత్, “ఈ గిలస్తద్ ఇముంఙ్‍ సటీ కులుప్తద్ నెత్తుర్ డ్ వత్త తయార్ కలెకాద్ ఇద్ అన్నె కొత్త కరార్. ");
INSERT INTO nit_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ఓలుర్. అన్ సుమెకద్ నాయ్ అన్ వెంట ఈ టెబల్ మెరయ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","దెయ్యమ్నె నిర్నయ్‍ లంఙ్‍ మన్కనె పోరక్ తిక్కెకాద్ అన్సంద్. గని అమ్నున్ సుముత్ సియెక ఆ మన్కంఙ్ మత్రం సిక్స సుకిలెద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","అపుడ్ ఔర్ లోప ఎదొ అటద్ తన్నెత్ తన్ని విచార్ కలెంఙ్ సురు ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","అవ్రతి ఎద సోయ్ ఇనెక బెదం అవ్రత్తి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","అప్పుడ్ అముదు ఔరున్ ఇనంఙ్ ఇంతెంద్, మార్జాతిత మన్కకెర్ రాజక్ కెర్ తమ్మె మంది పొయ్ సార్కర్ కల్సార్. మందిన్ పొయ్ అదికార్ అడ్గిపెంఙ్ ఇసా అసా కల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","నీర్ అనంఙ్ అనెంఙ్ తోద్. ఇమున్‍ లోప మెన్‍మన్కక్ కమ్మి తంద్‍లంఙ్‍, దొడంద్ సేవక్లంఙ్‍ అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","అసల్ సోయ్‍తద్ ఎద్ ఇంతెంద్? తినెంఙ్ ఉద్దెక దా తొదె సేవ కలెక రా? తినెంఙ్ ఉద్దెతది తా! ఎన గని అన్ ఇమున్ నడుమున్ సేవ కలెకారన్‍ లాంఙ్ అన్సాత్. ");
INSERT INTO nit_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","అనుంఙ్ ఎద విసయున్ కస్టంనాయ్ నిరి అంనడ్ ఇలుత్ అన్సాతిర్. ");
INSERT INTO nit_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","అన్నె బాంద్ అనుంఙ్‍ రాజున్ నెమిప్‍తెర్. అన్నె రాజ్యం ముత్ అన్నె మెరా అన్సంత్ ");
INSERT INTO nit_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","రాజునె సింహాసనముత్ ఉదుత్ ఇస్రాయేల్ బర పడికున్ నీర్ న్యాయ్ కలెంఙ్ అనాయ్ ఇముంఙ్ రాజ్యం మున్ తయార్ కల్సత్. ");
INSERT INTO nit_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","సీమోన్, సీమోన్ ఇదె విన్ కేతి కలెకాంద్ ఎనంఙ్ గొద్మలాఙ్ ఆస్సదో అనాయ్ సైతన్ ఇమున్ అసెంఙ్ నెమిప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","సీమోన్ ఇన్నె విస్వాస్ కమ్మి ఎరెంఙ్ తోద్ ఇసా అన్ ఇమ్ముంఙ్ సటీ పార్తన కత్తన్. నీ పెన దెయ్యమున్వై తిర్గత వెన్కత్ ఇన్నె దాదక్ కెరున్ సోయ్‍కల్. ");
INSERT INTO nit_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","గని పేతురు, “ప్రబు, ఇన్ వెంట జేలుంఙ్ సెరెంఙ్ నాయ్ తికెంఙ్ నాయ్ అన్ తయార్ అన్సాత్” ఇసా అమ్నున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","అప్పుడ్ అముదు పేతురునున్, ఇసాద్ నీవెనివొ అనుంఙ్ ఒర్కి తోద్ ఇసా ముది గుసాల్ ఇంతవెన్కతి పోత్ కూగెంఙ్ ఇసా ఇనుంఙ్ ఇడసాత్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ఇంక అముదు, “అన్ పైసెల సంచి, కెర్రిక్ తోసెటా ఇమున్ పవిట్టె ఇముంఙ్ తనెదెన్న కమ్మి ఎదినా? ఇసా వెలుత్ ఓల్‍తెద్. అదున్ ఔర్, తనయ్ కమ్తి ఎరెతిన్” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","అముదు, గని ఇండి పైసేల సంచి తైలీ అనెకది అదున్ తోడ చెరెకది. రుసి తోసెటద్ తన్నె జుఙ్ఙెనె విరుత్న రుసి సుమ్మెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","అమ్నుంన్ కరాబ్ కలెకనున్ ఒక్కొనుని సాయ్‍తెర్ ఇసా వాయ్‍త లెక్కనడ్ అన్న బదోల్ నెరయెంఙ్. అన్న బదోల్ ఇదవున్ బదోల్ నియమ్ సాస్త్రముంఙ్ విరోద్ ఎద్దవిసా ఇముంఙ్ ఇడ్సాత్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","సిసుల్ ప్రబు ఇత్తి ఇంది రుసిక్ అన్సా ఇంతెర్. అముదు “ఎరద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","తినెకద్ ఎద్ద వెన్కత్ అముదు సెరెంఙ్ తన్నె అల్వొటలంఙ్ ఒలీవ మెట్‍ పొయ్‍ సెరెంఙ. అమ్నె సిసునాయ్ అమ్నున్ వెంట చెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ఔర్అదె గదియ్‍త వెన్కత్ అముదు ఔరున్, నీర్ విసారుత్ పడెంఙ్ తోద్ ఇసా పార్తన కలుర్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","అవ్రంతన అముదు సింత్తె వేల కొన్సెం దౌ చెత్న అత్తి ముడుసు టెకిపుత్న ఇనంఙ్ పార్తన కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“బా” ఇనుంఙ్ మన్న అండినింత్తె ఈ దుక్కంత వటీన్ అన్నతన పుస్. “గని అన్నె మన్నడ్ తోద్. ఇన్నె మన్నడి ఎరెంఙ్.” ");
INSERT INTO nit_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","అప్పుడ్ స్వర్గతన ఒక్కొ దుత్ అమ్నుంఙ్ కన్డెత్న అమ్నున్ ఇమత్‍ సియ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","అముదు దుక్కమడ్ పార్తన కల్స ఇక్క డిలెపటెద్. అప్పుడ్ అముదు చరదడ్ నెత్తుర్‍నే బొట్లు బూమిత్ ఉర్కేఙ. ");
INSERT INTO nit_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","అముదు పార్తన తన తిర్పుత్ తన్నె సిసువై వతెంద్. ఔర్ దుక్కమడ్ మంఙెకరున్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","అముదు ఔరున్ “నీర్ తనుంఙ్ మంఙ్సాతిర్? విసారుత్ పడెంఙ్ తోద్‍ ఇసా సులుత్ పార్తన తన కలుర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","అముదు ఇంకా ముడ్స అనెంఙయ్ మంది మిరయ్‍తెర్. బరా మంది సిసులోప ఒక్కంద్ యూదక్ ఔరుంఙ్ ముడటి అడ్గసా యేసుకున్ ముద్దిడెంఙ్ మెర వతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","అప్పుడ్ యేసుంనున్, యూదక్ ముద్దిడుత్న మన్కనె పోరక్ సుముత్ దుస్మన్నె కేయుత్ సియ్‍సాతివా? ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","అమ్నున్ తిర్గొరా అనెకర్ తన్నెద ఎర్సదొ ఇసా ఓలుత్, ప్రబు, రుసినడ్ తర్గిసాతివా? ఇసా వేల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ఇంతెనాడ్ అవ్రతి ఒక్కొద్ దండి దెయ్యలక్నె సిసులున్ అమ్నె ఉన్న కేవ్వున్ తర్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","అదుంఙి యేసుంద్, “ఇండి మడ్ర” ఇసా అమ్నె కేవ్వున్ పుడుకుత్ సోయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","అప్పుడ్ యేసుంద్ సుమెంఙ్ వత్త దండి, మన్‍ వాలెలడ్, యాజకెర్ వెంట, మందిరున్ కయ్యెకర్ “ఒక్క డొంఙన్ సుమెంఙ వత్తెతి రుసిక్ అని టేగ్రిక్ సుముత్ వాత్తిరా? ");
INSERT INTO nit_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","అన్ రోజ్‍ ఇమున్ వెంట గుడిత్ అన్నెంఙ అదికార్ సుమెతిర్. గని ఇద్ ఇమ్మె సంది, చీకటి తా సక్తి” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ఔర్ అమ్నున్ సుముత్ డగలిప్సా దండి దెయ్యలక్నె ఎల్లవై తోడ సెద్దెర్. పేతురుంద్ దవడి ఔరున్ వెంట చెద్దెద్. ");
INSERT INTO nit_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","అప్పుడ్ కొన్సెం మంది ఆ ఎల్లత బజరుత్ కిచ్ ఎర్కుత్ కిచ్ అద్సా అత్తి తిరుగొర ఉద్దుత్ అన్నెర్. పేతురుంద్ నాయ్ సెత్న ఔరున్‍వెంట ఉద్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","అప్పుడ్ ఒక్కొ రప్తిరా కిస్‍నె వెంల్ఙుత్ ఉదుత్ అనెక పేతురున్ ఓలుత్, “ఈమన్కక్‍నై అమ్నున్ వెంట్టతది తా” ఇంత్తిన్ ");
INSERT INTO nit_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","అదున్ పేతురుంద్, “బాయి, అముదు ఎందొ అనుంఙ్ ఒర్కితొద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","జామాటింఙ్ పెనొక్కొద్ పేతురునున్ ఓలుత్న, నీనై అమ్నున్ వెంట్టతని ఒక్కొని ఇంతెంద్. అదుంఙి పేతురుంద్, అన్ ఎరెన్‍ తా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","మల్ల ఒక్కొ గంట ఎరెంఙ పెనొక్కొద్ పేతురునున్ ఓలుత్, “ఇమ్ద సత్తెం అమ్నున్ వెంట్టతది. ఇమ్‌ద గలిలీయ తది ఇసా ఇడ్సంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","అప్పుడ పేతురుంద్‍ నీతన్నెవిసాతివొ అనుంఙ్ కరిలెద్” ఇంతెంద్. అముదు ఇనంఙ్ ముడ్స అన్నెంఙయ్ పోత్ కూగెంఙ్. ");
INSERT INTO nit_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","అప్పుడ్ ప్రబుంద్ అదేతిర్గుత్ పేతురున్‍వై ఓల్తెంద్. “అన్ ఎదొ ఒర్కి తోద్ ఇసా నీ ముద్ది గుసాల్ ఇడ్‍ తా వెన్కత్ పోత్ కూగెంఙ్” ప్రబుంద్ అమ్నుంఙ ఇడ్‍తా గొట్టి పేతురునుంఙ్ అదివాత్తిన. ");
INSERT INTO nit_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","అప్పుడ్ పేతురుంద్ వకాసెత్న పక్క అర్రతెద్. ");
INSERT INTO nit_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","యేసునున్ సుంతర్ అమ్నున్ గదెంఙ్‍గుదెంఙ్ కత్తెర్, కుడ్కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","అమ్నె కడ్లున్కటుత్న, లగపుత్ ఇన్ ఎర్‍ లగప్‍తెర్ ఇడ్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","అమ్నున్ ప్రవక్తకెర్ గుల్ దుసన్. అమ్నుంఙ విరోద్ అనెకర్ గుల్ దుసన్ గొట్టిక్ ముట్టెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","పొద్‍ కురియెంఙయ్ మందినె దండి దెయ్యలకెర్, సాస్త్ర పాడిపెకర్ మిరయత్తెర్. యేసుంన్ సావ్డింఙ్ తోడ సెదెంర్. ");
INSERT INTO nit_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","నీ క్రీస్తునీ ఎరత్తె అద్దున్ అమ్ముంఙ ఇడ్ ఇంతెర్. అదుంఎత్తి అముదు అన్ ఇడ్‍త్తెన నీర్ నమ్మెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","అంత్తెయ్ ఎరెకడ్ అన్ వేల్తె నీర్ సామదనం ఇండెర్. ");
INSERT INTO nit_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ఇంతె ఇక్కపొయ్ మన్కనె పోరక్ సర్వ సక్తి తా దెయ్యమ్నె ఉన్నపక్కంఙ్ ఉద్దుత్ అందద్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ఇంతె నీ దెయ్యమ్నె పోరక్నివా? ఇంతెర్. ఇంతె ఔరున్, నీర్ ఇంతెతియ్ అని. ");
INSERT INTO nit_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","అదుంఎత్తి ఔర్, “నేండుంఙ్ ఇక్క సాక్సమాడ్ తా పనీ? ఇమ్నె మూతిత గొట్టికున్ నెడి వితం తా” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","మల్ల సిమ్కన మంది అమ్నున్ పిలాతున్వై కొస్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","అని ఔర్ అమ్నున్ పొయ్ గున కత్తెర్ అని ఇంతెర్. ఈ మన్కక్ అమ్మె జాతిన్ సాడిపుత్ సియెకానున్ ఓల్తమ్ అని రొమ రాజు పన్ను సియెకద్ తోద్ అని అన్ సొంతం క్రీస్తు ఒక్కొ రాజక్ అంసత్ ఇనెకదున్ అమ్ వింతమ్. ");
INSERT INTO nit_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","పిలాతు అమ్నున్ వేల్తెంద్. నీ యూదులె రాజక్ ఎన్ని వా? మల్ల అముదు అమ్నున్ ఇంతెంద్. నీ ఎనంఙ్ ఇసాతి అయ్. ");
INSERT INTO nit_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","పిలాతుక్ అని బార్స దెయ్యలకెర్ అని మంది ఇనెర్. ఈ మన్కనత్తి అనుంఙ్ తనయ్ గునా కన్కెరెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","గని ఔర్ లంకి కత్న ఇంతెర్. ఇమ్‌ద పనిన్ మోదల్ ఇట్ట గలిలీయ తన్న ఈ జాగంఙ్ ఎంత్ సదర్ యూదు బార్స లోప సియుత్న సాడిప్సాంద్. ");
INSERT INTO nit_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ఇదున్ పిలాతు వింత్న ఆ మన్కక్ గలిలీయ తద్ ఎన్నెదా ఇసా వెలుత్ ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","అముదు హేరోద్నె అదికార్త జాగతద్ అన్సాద్ ఇనంఙ్ ఒర్కిలుత్న యేసునున్ అముదు అ దినలుంఙ్ హేరోదున్ యెరూసలెముంఙ్ పవింటెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","హేరోద్ యేసుకున్ ఓలుత్న గుల్లెన కుసీంఙ్ వతెంద్. తానుంఙ్ ఇంతె అముదు యేసునున్ బదోల్ వింత్ అండెద్ అని అమ్నున్ యేసుంద్ కత్త కొన్ని సమత్కలున్ ఓలెంఙ్ ఆస అండిన్ అని పెలెగోల్ తన్న అమ్నున్ ఓలెంఙ్ మన్ కత్తండెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","అని అముదు పెల్లె గొట్టికున్ అమ్నున్ వెలుత్ ఓల్‍నెద్ గని యేసుంద్ తనయ్ ముడెతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","బార్స దెయ్యలకెర్ అని సాస్త్రి మన్కకెర్ జబర్ దస్తి గున లవిపుత్న ఇల్లుత్ అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","హేరోద్ తన్న సిపయిక్ వెంట అమ్నె అప్‍మన్ కత్న అమ్నున్ నారాజ్ కతెంద్. మల్ల రాజకెర్ తొడెకలంఙ్ తరియెకా జుఙ్ఙెలున్ ఎరొద్ యేసుకుంఙ్ తొడుపుత్న అమ్నున్ పిలాతున్ వపస్ పన్కతెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","అద్ది జీర్ హేరోద్ అని పిలాతు దొస్తు ఎద్దెర్. అదుంఙ్ పేలె ఔర్ ఇద్దర్ విరొది అండెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","అపుడ్ పిలాత్ దండి దెయ్యలకెరున్ అదీకాలున్ మందిన్ కుగుత్. ");
INSERT INTO nit_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","అని ఔరున్ ఇంతెంద్. ఈ మన్కక్ మన్కకెరున్ సాడిపెకద్ ఎన్నెంద్ ఇసా నీర్ ఇమ్నున్ తోడ వత్తిర. ఇముంఙ్ ముండట్ ఇమ్నున్ వేల్తోల్తెంఙ అన్ ఇమ్నున్‍ వై ఎద్ది గునాన్ ఓలెంఙ్ సాలెతన్. ");
INSERT INTO nit_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","హేరోదుంఙ్ నాయ్ రొంబడెతిన్. తానుంఙ్ ఇంతె అముదు నయ్ ఇమ్నున్ అమున్‍వయ్‍ పవింటెద్ ఓలుర్, తిక్కెకదుంఙ్ ఇమ్‌దు తనయ్ కలెతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","అదుంఙ్ ఎత్తి, అన్ ఇమ్నుంఙ్‍ సిక్స సియుత్న ఇమ్నున్ సాయ్‍సత్. ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ఆ పండ్గుంఙ్ ప్రతి సాలుంఙ్ పిలాత్ ఔరుంఙ్‍ సటీ పండ్గుంఙ్ జీర్ కొడ్పతరున్ సాయ్‍నెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","గని ఔర్ సదర్ మిరయుతన్న వపొయ్‍తెర్. ఇమన్కన్ పుస్ జెలర్ ఎద్ద బరబ్బకున్ అముంఙ్ సాయ్. ");
INSERT INTO nit_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","బరబ్బ పట్నంముత్ ఎద్ద ఒక్కొ బరబ్బకున్ బదోల్ జేలుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","యేసునున్ సాయెంఙ్ పిలాతుంఙ్ మన్న అండిన్, ఔరున్ వెంట పెన ముట్టెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","గని సిమ్కన ఔర్ సిలువ తపుర్ వపొయ్తెర్. అమ్నున్ కుడ్కుర్. సిలువ కుడ్కుర్. ");
INSERT INTO nit_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","మున్ది గుసాల్ అముదు ఔరున్ వెలుత్ ఓల్‍తెద్. ఇమ్ దతన్నెద్‍ కరాబ్ కతెంద్? ఇమ్నున్ అల్ఙేఙ్ ఇంతె ఇమ్నంతి తనయ్ గునా ఓలెతన్. అన్ ఇమ్నున్ తిక్కెకా సిక్స సియుత్ సాయ్‍సత్. ");
INSERT INTO nit_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","గని ఔర్ లగ్కి కత్తెర్ అని అమ్నున్ సిలువత్ కుడ్‍కెంఙ్ ఇసా గుల్ జోరకత్ వపొయుత్. వెలుత్ ఓల్‍తెర్ ఔరె లొంల్లి విడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","అపుడ్ పిలాతు ఔర్ ఎనంఙ్ వెల్‍తెర్ అనాయ్ టైరిప్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ఔర్ ఎనంఙ్ వెల్‍తెర్ అనాయ్ మెరవత్ పుసుతన్న కున్ కతెంద్ ఇసా జేలుత్ తప్త మన్కకున్ సాయ్‍తెంద్ గని యేసుంద్ ఔరె మన్నడ్ కలెంఙ్ ఇసా ఔరె కెయ్యుత్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","మల్ల ఔర్ అమ్నున్ తోడ సెరెంఙ్ కెన్ తన్నట్ ఊర్ లోప వారెక కురెని ఊర సిమోనున్ సుమ్‍తెర్ అని యేసునున్ వెంటా సిలువన్ కాజిప్. ");
INSERT INTO nit_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","గుల్ పెరేత్ మంది అమ్నున్ వెంట సెందెర్ అని పిల్లక్ అమ్నుంఙ్ సటీ అది కత్న జోరకత్ అర్రసా సెన్నె. ");
INSERT INTO nit_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","గని యేసుంద్ ఔరున్వై తిర్గుత్ ఇంతెద్. ఏ యెరూసలేమ్త పిల్లక్‍లార అనుంఙ్ సటీ ఆర్నెర్ గని ఇముంఙ్ సటీ అని ఇమ్మె పోరకెరుంఙ్ సటీ అర్రుర్. ");
INSERT INTO nit_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","తానుంఙ్ ఇంతె గొడ్డె పిల్లక్ పోరకేర్ ఎర్సెట అని పాల్ ఉర్‍త్ సెట దన్యుల్ అంసా ఇసా నీర్ ఇడ్డెక వేల వారెక అంసాహ. ");
INSERT INTO nit_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","మల్ల ఔర్ దండి మెట్లున్ ఇడ్‍దర్. అమ్మున్ పొయ్‍ ఉర్క అని డుబ్లెలున్ ఇడ్‍సార్. అమున్ సిమ్కన. ");
INSERT INTO nit_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","తానుంఙ్ ఇంతె పస్సి మాకున్ ఔర్ ఇనంఙ్ కత్తెర్ ఇంతె అర్త మాక్నెత్ తానెద్ ఎరద్? ");
INSERT INTO nit_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","డొంఙ ఇద్దరున్ నై అల్ఙేఙ్ ఇసా ఔరున్ వెంట తోడ సెందెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ఔర్ టొబ్ర పెరా జాగంఙ్ వాత్తె, ఔర్ అమ్నున్ అత్తి కుగ్‍తెర్ అని డొఙలున్ ఉన్న పకంఙ్ ఒక్కొనున్ అని ఎడమ పకంఙ్ సిలువ కుడ్కతెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","మల్ల యేసుంద్ ఇంతెంద్. బా, ఇవ్రున్ మాప్కల్ తానుంఙ్ ఇంతె ఇవ్రు తాగల్సరొ, అద్ద ఔరుంఙ్‍ ఒర్కి తోతెద్. సిపయిక్ అమ్నె జుఙ్ఙెలుఙ్‍ సాటీ సిటిక్ తప్పుత్న జుఙ్ఙెలున్ పైతెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ఓల్సని మన్కకెర్ ఇలుంత్ అన్నెర్ గని దండి అమ్నున్ డవారి కత్న ఇంతెర్. ఇమ్‌ద మరొక్కొరున్ బత్కిప్తెంద్. నీ దెయ్యం నివ్డిప్త మాన్దార్ క్రీస్తుంద్ ఎరతె, తన్నెత్ తన్ బత్కద్. ");
INSERT INTO nit_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","సైనిక్ నాయ్ అమ్నున్ విరోద్ కత్తెర్ అని అమ్నున్వై వత్న పుల్లె రసాన్ అమ్నుంఙ్ సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","అని ఇంతెర్: నీ యూదులె రాజక్ని ఎరతె నీ ఇన్నెత్ ఇనుంఙ్ బత్కిప్! ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","మల్ల అమ్నున్ పొయ్ ఇనంఙ్ వయ్‍త గునల పట్టెన్ ఇటెర్. ఇమ్‌ద యూదు మన్కకెరె రాజక్. ");
INSERT INTO nit_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","కుడక్‍త డొంఙ్ లోప ఒక్కొద్ అమ్నున్ బద్నం కత్న ఇంతెంద్. నీ క్రీస్తునె మన్‍ తని ఎన్నివా? నీ బతక్ అని అన్న బత్కిప. ");
INSERT INTO nit_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","గని మరొక్కొద్ అమ్నున్ దట్టిపుత్ ఇంతెంద్. ఇనుంఙ్ న అది సిక్స వత్తిన్. నీ దెయ్యమున్ అర్సెవ? ");
INSERT INTO nit_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","నేండుంఙ్ బరబర్ న్యాయ్ రొబ్బటిన్. గని ఈ మన్కక్ కరాబ్ తనయ్ కలెతెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","అని ఇంతెంద్. ఎ, యేసు, నీ రాజ్యం ఎత్న వారెంఙ్‍, అన్ అది కల్. ");
INSERT INTO nit_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","అదుఙి అముదు అమ్నడ్, “ఈ దినం నీ అన్ వేంట పరలోకముత్ అన్సతి ఇస ఇన్నడ్ కరె ఇడ్సత్” ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ఆరు తన్న తొమ్మిది దూక్ ఇంతె పన్నెండు గంట తన్న దుపరి ముడు ఎంత్ సిమ్కన బూమి పొయ్ సిర్మన ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","పొద్నె వెలుంఙ్ తొతిన్ అని గుడినె పాడ్ద ఇరియుత్న ఇద్ది తుక్డె ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","మల్ల యేసుంద్ జోరనట్ వపొయుత్ ఇంతెంద్. బా, అన్ అన్నె పానముంన్ ఇన్నె కెయ్యుత్ సియ్‍సత్ ఇనంఙ్ ఇత్ అముదు తన్నె పానమున్ సాయ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","అపుడ్ ఎద్దున్ ఒలుత్, నూర్ సైనిక్లె దొడంద్, “ఈ మన్కక్ కరెయ్ నీతిమాన్” ఇసా దెయ్యముంఙ్ స్తుతి కత్తెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ఎద్ద గొట్టిన్ ఓలెంఙ్ మిర్యత గుల్ మంది మన్కకెర్ తనెంద్ ఎద్దిన్ అదున్ ఓలుత్న తమ్మె సాక్కున్ కుడుకుత్న తమ్మె ఎల్లంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","అమ్నె ఒర్కి తర్ సదర్ మన్కకెర్ అని గలిలీయ బార్స తనట్ అమ్నున్ వెంట వత్త పిల్లక్ దౌవడ్ ఇల్లుత్న ఇదవుంన్ ఓల్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","మల్ల అరిమతయి ఇన్నెక యూదులె దెసెంతంద్ యోసేప్. సోయ్ నీతి అని ఇమన్‍దార్ మన్కక్ అండెద్. అముదు దెయ్యమ్నె రాజ్యమున్ పావొల్సా అన్నెద్. సబతర్ టైరిప్‍త గొట్టిన్ అనికత్తనున్ ఇమ్‌ద తోద్ ఇంత్ అండెద్ అని అముదు సెత్న దెయ్యమ్నె రాజ్యముంఙ్ సటీ పవ్ ఓల్‍నెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ఈ మన్కక్ పిలాతున్‍వై సెత్న యేసునె సెత్తన్ వెల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","అముదు సెత్తన్ డిపుత్న కండ్వ జుఙ్ఙెనడ్ గుడపుత్న కాన్న కత్త గుండ్‍నె తప్నెత్ ఇట్టెద్. అత్తి ఇమ్నుంఙ్ పేలె ఎనుని ఇడెతెర్. ");
INSERT INTO nit_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ఆ దినముంఙ్ పండ్గుంఙ్ పక్కఙ్ దినం అండిన్ అని ఆలపుసేక జీర్ కురియెంఙ్ అండిన్. ");
INSERT INTO nit_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","గలిలీయత పిల్లక్ యోసెపున్ వెంట వత్త తప్నెన్ ఓల్‍తె అని సెత్తన్ ఎనంఙ్ ఇట్టెర్ అమ్నున్ ఓల్‍తె. ");
INSERT INTO nit_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","అదహ మలయుత్ వత్న సోయ్ కంప్ వరెకహ నూనె, అత్తరు నూనెన్ తయార్ కత్తె. మల్ల ఆగ్యనె ఇసొబడ్ ఆలపుసేక జీర్ ఇసామ సుమ్‍తె. ");
INSERT INTO nit_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","గని ఐతరముంఙ్‍ పేలె జీర్ కొర్‍కూతంఙ్ అదా పిల్లక్ తయ్యర్ కత్త అత్తర్ నూనె తోడా తప్నెంఙ్ వాత్తె. ");
INSERT INTO nit_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","తప్నె తా గుండున్ డగ్ లిప్‍తదున్ అదా ఓల్‍తె. ");
INSERT INTO nit_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","అదా లోప సెదె గని ప్రబు యేసునె సెత్త అదవుంఙ్ రొంబడెతిన్. ");
INSERT INTO nit_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","మల్ల ఇనంఙ్ ఎద్దిన్. ఔర్ ఇదున్ బదోల్ కమాల్ కలెంఙ్, తరియెకా జుఙ్ఙె తొట్టర్ ఇద్దర్ మన్కకెర్ అదవున్ మెరా ఇల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","అద అర్సుత్‍న బూడున్ బూమిన్‍ ఓల్స అనెంఙ్‍, ఔర్ అదవ్లున్ ఇంతెర్. పానమ్ అనెకనున్ తనుంఙ్ నీర్ తిక్తరంతి కిర్వసాతిర్? ");
INSERT INTO nit_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","అముదు ఇత్తి తోతెద్. అముదు సుల్‍తెద్. అముదు గలిలీయ అనెం‍ఙ్ తానెద్ ఇడ్‍తెద్, ఆ గొట్టిన్ అదికలుర్, ");
INSERT INTO nit_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","మంజె, మన్కనె పోరక్ పాప్ మన్కకెరె కెయుత్ సియ్యదర్ అని అమ్నున్ సిలువ కుడుకుత్ అల్గదర్ మల్ల ముది దినలుంఙ్‍ అముదు సుల్‍దద్. ");
INSERT INTO nit_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","మల్ల అద పిల్లక్ అమ్నె గొట్టికున్ అది కత్తె. ");
INSERT INTO nit_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","తప్నెతన తిరుగుత్ వాత్న ఇదా సిమ్కన గొట్టికున్ బారా మంది ప్రెసిత్‍ సిసులుంఙ్ అని ఔర్ సదరుంఙ్ ఇడ్‍తెహె. ");
INSERT INTO nit_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","కబుల్లాకెర్ సిసులుంఙ్ ఈ గొట్టిన్ మగ్దలేనేన్ మరియ, యోహాన్, యాకోబ్నె అమ్మ మరియ్య అని అదవున్ వెంట అనెక పెన్న కొన్సెం మంది పిల్లక్ ఈ పిల్లకున్ ఇడ్‍తె. ");
INSERT INTO nit_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","గని ఇద గొట్టిక్ ఔరుంఙ్ జమ్మిప్‍త గొట్టిక్ కరిలుద్ అని ఔర్ అదవున్ పొయ్‍ బరొస తోతెద్. ");
INSERT INTO nit_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","గని పేతురుంద్‍ సుల్‍తెంద్ అని తప్నెంఙ్ తుటెద్ అని సొగుత్ లోప ఓల్‍తెద్. కడ్వ జుఙ్ఙె మత్రమ్ అండె అదున్ ఓలుతన్న ఎద్ద గొట్టిన్ బదోల్ కమల్ కత్న ఎల్లంఙ్‍ తిర్గుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","మల్ల అది జీర్ ఔరున్ లోప ఇద్దర్ యెరూసలేముంఙ్ ఏడ్‍ కొసు దవ్‍త ఎమ్మాయు ఇన్నెక ఊరుఙ్ సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ఔరిద్దర్ సదర్ గొట్టికున్ బదోల్ ఔర్లోప గొట్టి ముడ్నెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ఔర్ గొట్టి ముడ్స సెరెంఙ్‍, యేసుంద్ ఔరున్వై గదియుత్న ఔరున్ వెంట సెన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ఔర్ అంమున్ ఓల్తేర్ గని అమ్నున్ ఒర్కిలేతెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","అముదు ఔరున్ ఇంతెంద్, “ర్ అడ్గస ఇముంన్ లోప తనెదున్ బదోల్ గొట్టి ముంట్టిరె?” ఔర్ నారాజ్ ఎత్న ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ఔరున్‍లోప ఒక్కొద్ క్లెయొపా ఎన్నెంద్. ఈ దినాలుంఙ్ యెరూసలేముత్ ఎద్ద గొట్టిక్ బదోల్ ఇనుంఙ్ ఒర్కితొతెద్? అద ఒర్కితోసెటా నీ ఒక్కొది మరొక్కొ మన్కక్‍లంఙ్ కన్కెర్సతి. ");
INSERT INTO nit_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","యేసుంద్ ఔరున్ ఇంతెంద్. గొట్టిక్? అని ఔర్ అమ్నున్ ఇంతెంద్. నజరేత్ యేసుకున్ బదోల్త ఎంన్నె. అముదు సందేస్‍స్టక్ దెయ్యం ముండట్ అని సదర్ మన్కకెర్ ముండట్ పనిక్ కలెకత్తి గొట్టిక్ ఇడ్డెకత్తి గుల్లెనా జోర్‍దర్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","నేండె బర్స దెయ్యలకెర్ అని దండి అమ్నున్ అలంగెంఙ్ ఇసాగొట్టి జొడిపుత్న అమ్నున్ సుముత్ సియతెర్ అని అమ్నున్ సిలువత్ కుడక్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","అమ్‍ తె అముదు ఇస్రాయేల్ మంది సొడపెకద్ ఎన్నెంద్ ఇమ్‍ది. ఇస అమ్ బరోస నాడ్ పవొల్తమ్. అంత్తెయ్ తొద్, ఇదా సిమ్కన ఎత్న ఇన్నెడ్ ముది దినా ఎద్దె. ");
INSERT INTO nit_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","పెనా అమ్నె కొన్సెం మంది పిల్లక్ కొర్‍కూతంఙ్ తప్నెంఙ్ సెత్న కమల్‍ తా గొట్టిక్ కొత్తె. ");
INSERT INTO nit_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","అమ్నె సెత్త అదవుంఙ్ రొంబడెతిన్ మల్ల అదా మలయుత్ వత్ ఇనంఙ్ ఇంన్నె. అముంఙ్ దూత్ లె దర్సన్ఎత్న అముదు పానం అన్సాద్ ఇసా దూతు ఇడ్తె. ");
INSERT INTO nit_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","అమున్‍వెంటా అనెకర్ కొన్సెం మంది తప్నెంఙ్ సెత్న పిలక్ ఎనంఙ్ ఇడ్‍తె అనాయ్ ఓల్‍తెర్ గని అమ్నున్ ఔర్ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","అని అముదు ఔరున్ ఇంతెంద్. ఎ, బైతాడ్‍ మన్కకెర్, “సందేస్టకెర్ ఇడ్త సదర్‍ గొట్టిన్‍ పొయ్‍ బరొస ఇడ్డెకదుంఙ్ నీర్ ఉసారడ్‍ తోతెరా” ");
INSERT INTO nit_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","దెయ్యమ్నె మన్‍వలె ఇదా సిమ్కన తక్లిబులున్ సొసిపుత్ తన్నె మహిమత్ సెరెకద్ క్రీస్తునుంఙ్ జరురి తా! ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","అని మోసే తన సిమ్కన కబుర్లకెర్ లేకనముత్ తన్ బదోల్‍ వయ్త సదరున్ ఔరుంఙ్ కరిపుత్ ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","అనాయ్ ఔర్ సెరెకా ఉర్ మెర వత్తెర్. అముదు ఇంకా ముదర్వై సెరెకద్‍ లంఙ్ కాన్కెద్దెం. ");
INSERT INTO nit_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","గని ఔర్ అమ్నున్ జాబర్‍ దస్తి కత్తెర్. అమ్నున్ వెంట అన్ తానుంఙ్ ఇంతె ఇండి సిర్మనా ఎరెంఙ్‍ కల్సనంసాద్ అని చింతే వేల ఎందిన్. మల్ల అముదు ఔరున్‍ వెంట ఎల్లంఙ్‍ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","మల్ల ఇనంఙ్ ఎద్దిన్. అముదు ఔరున్‍ వెంట తినెంఙ్ ఉదుత్ అనెంఙ్‍, అముదు నిపట్టెన్ సుమ్‍తెంద్ అని దన్యవాద్ సియుత్న అదున్ ముర్కుత్న ఔరుంఙ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ఔరె కడ్లుంఙ్ కండ్క ఎద్దెంద్ అని ఔర్ అమ్నున్ ఒర్కిల్‍తే. అపుడ్ అముదు ఔరుంఙ్ కన్కెరె తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ఔర్ తమ్మెత్ తామీ ఇన్నెర్. పావుత్ అముదు నేండున్‍ వెంట ముడెంఙ్ అని సాస్త్ర లేకనములున్ నేండుంఙ్ పుసుత్ ఇడెంఙ్ నెడే మనడ్లు గుల్ కుసీ వత్తిన్‍ తా! ");
INSERT INTO nit_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","అని ఔర్ ఆ గట్‍కంఙ్ సుల్‍తెర్ అని తిరుగుత్ యెరూసలెముంఙ్ వతెంద్. బారా మంది సిసూ అని మల్ల కొన్సెం మంది మిరయుత్ అనెక రున్ ఓల్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ప్రబుంద్ కరెంయ్ సుల్తెంద్ అని సీమోనుంఙ్ కండ్క ఎద్దెంద్ ఇసా ఇవ్రు ఇద్దర్ మన్కకెరుంఙ్ ఔర్ ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","మల్ల ఎమవుస్ ఊరుంఙ్ సెరెకా పవుత్ తనెద్ ఎద్దిన్ అని ఎనంఙ్ అముదు నిపట్టెన్ ముర్కెంఙ్ ఔర్ ఇద్దర్ మన్కకెర్ యేసునున్ ఒర్కిల్‍ తెర్, ఆ గొట్టిన్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ఔర్ ఇదున్ ముడ్స అనెంఙ్‍, యేసుంద్ సెత్న ఔరె నడుమున్ ఇల్‍తెంద్ అని ఇంతెంద్. ఇముంఙ్ సాంతి అంకాద్! ");
INSERT INTO nit_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ఏద్దో ఆత్మ తముంఙ్ కన్కెదిన్ ఇసా ఔరు గని ఔర్ గబ్రిలుత్న అర్సతెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","అని అముదు ఔరున్ ఇంతెంద్. తనుంఙ్ గబ్రిల్‍తిరె? తనుంఙ్ ఇమ్మె మన్ లోపా సాకా సుమ్‍తిరా? ");
INSERT INTO nit_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","అని ఇమ్‍దున్ అన్నె కెయ్యులున్ గెట్టలున్ ఓలుత్ హన్ సుముత్ ఓలుర్, అనుంఙ్ అండెతిలఙ్ ఆత్మంఙ్ ఓల్తె ఇంతెతిలఙ్ బొక్కా అని ముర్యి బూతుంఙ్ ఆనెదిస ఈడ్డుత్! అంనే కెయ్యున్ గెట్టలున్. అముదు ఔరుఙ్ తనె కెయ్యుల్ అన్ గొట్టికున్ ఓలిప్సాంద్ ");
INSERT INTO nit_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","తన్నె కేయ్యులున్ గెట్టలున్ ఔరుంఙ్ ఒలిప్నెంద్. ఔరెత్ ఓలిప్తెంద్ ఇంతె ఔర్ కుసీంఙ్ వత్తెర్ అని ఇంక బారోస ఇడెంఙ్ అడ్డెర్ ఔర్ కమల్ ఇదరెఙ అమునున్ ఔరున్ ఇంఙ గని తినెకదుంఙ్ ఇత్తి ఎద్దెనా అండద్. ");
INSERT INTO nit_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ఔర్ కుసినడ్ బరొస తోతెంద్ కమల్‍ ఎరెంఙ్ అముదు ఇదే ఇమున్‍వై ఇమంత్తి తనెదెన్ తినెకదుంఙ్ అన్సాద ఇసా వేలెఙ. ");
INSERT INTO nit_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ఔర్ సుట్ట కయ్యెనే గడ్‍కాన్ ఒక్కొదున్ అమ్నున్వై సియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","అమ్ అదున్ సుముత్ ఔర్ ముండట్ తిద్దెద్. ");
INSERT INTO nit_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","అని అముదు ఔరుఙ్ ఇంత్ అన్ ఇమున్ వెంట అనెఙ, ఇమున్ ఇడ్డుత్ అన్నె గొట్టికున్ ఇదవీఇంతె. మోసేనె నెకి తంద్ అని కబుర్లకెర్, పుస్తక్ తద్ అని కీర్తన సోయ్ వాయ్త సిమ్కన కరెఎరెఙ పాజె. ");
INSERT INTO nit_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","అపుడ్ ఔర్ లేకనముత్ ఒర్కిలుత్ ఔరె మన్లున్ కోలిపుత్! క్రీస్తుంద్ తక్లిబ్ సుముత్ ముండొలుంఙ్ తిక్‍త తన సుల్‍నెంద్ ");
INSERT INTO nit_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","అని క్రీస్తుంద్ ఔరున్ ఇంతెంద్. దెయ్యమ్నె మన్వలె తక్లిబ్ సొసిపుత్న ముడొలుంఙ్ తిక్త తనట్‍ సుల్‍దాద్. ");
INSERT INTO nit_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","యెరూసలేముత్ సూరు ఎత్న సదర్ మందింఙ్ అమ్నె పేరడ్ మన్ బద్లిపెకాద్‍, పాపులె మాప్ కలేకద్ ఎరద్ ఇసా ఇడ్డెకద్ ఎంద్ ఇసా వాయుత్ అంసా. ");
INSERT INTO nit_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ఇదవ్ గొట్టికుఙ్ నీర్ పురవ సియెకర్ అందతిర్. ");
INSERT INTO nit_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","అని అన్నె బాంద్ కబుల్‍ కత్త వాగ్దానున్ ఇముంఙ్ సటీ పవిడ్సతున్ గని పొలడ్ వరెకా పరిసుద్ద ఆత్మనె తాకత్ ఇమున్ మున్స నన్తెత్ నీర్ పట్నమూతి ఇలుత్ అడ్ర ఇసా ఔరుంఙ్ ఇడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","యేసుంద్ బేతనియ ఎంత్ ఔరున్ తోడ సెత్న కెయ్యున్ పొదె కత్న ఔరుఙ్ ఆసిర్వాద్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ఔరుఙ్ ఆసిర్వాద్ సియ్యెంఙ్‍, ఔర్ తన్న కురియ్తెంద్ అని దెయ్యం పొదె అమ్నునున్ పరలోకముంఙ్ కొత్సిన్. ");
INSERT INTO nit_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ఔర్ అమ్నె కల్ మొక్తెర్ అని గుల్ కుసినడ్ యెరూసలేముంఙ్ మలయుత్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","మల్ల ఔర్ గుడిత్ రొజి అత్న దెయ్యముంఙ్ స్తుతి ఇడ్నెర్.");
INSERT INTO nit_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","దున్యంఙ్ పేలె తన పానం అనెకా వాక్యమ్ అండ్డిన్. ఆ వాక్యమి దెయ్యమున్‍ వెంట అండ్డిన్. ఆ వాక్యమి దెయ్యం. ");
INSERT INTO nit_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","అముదు దున్య గడిలెంఙ్ పేలె తన దెయ్యమున్ వెంటా అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","అమ్నాడి సిమ్కన గడిల్‍తె. గడిప్‍తద్ ఎద్ది అముదు తోసెటా గడ్డిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","వాక్యమీ అమ్నున్ లోపా అదర్ అనెక పానం అని ఆ పానం మన్కకెరె సిమ్కనంఙ్ వెల్‍గున్ సియ్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","వెలుంఙ్ సిర్మనత్ తరియ్‍సాద్, గని సీకటి అదున్ ఇల్పెంఙ్ సాలెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","దెయ్యం అమ్నె కబూర్ ఇడ్డెక ఒక్కొ మన్కన్ పన్కతెంద్. అమ్నె పేర్ యోహాన్. ");
INSERT INTO nit_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","అమ్నున్ వాలడ్ మన్కకెర్ వెల్ఙున్ బదోల్ విత్న, బరొస ఇడ్‍దర్ ఇసా అముదు ఆ వెల్ఙున్‍ గురించి కబూర్ ఇడ్డెంఙ్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","అముదు ఆ వెలుంఙ్ ఎరెంద్ గని. ఆ వెలుంఙున్ బదోల్ ఇడెంఙ్ వతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ఔర్ ఒక్కొనుంఙ్ వెలుంఙ్ సియెకాద్ దున్యంఙ్ సదరుంఙ్ కరెయ్ వెలుంఙ్ అముదు. ");
INSERT INTO nit_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ఈ దున్యంఙ్ వతెంద్. అమ్నున్ వాలడి దున్య గడిల్‍తిన్ అ దున్యతర్ అమ్నుని ఒర్కిలెర్. ");
INSERT INTO nit_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","అముదు తన్నెర్వై వతెంద్. గని ఔర్ అమ్నున్ ఒర్కిలెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","అముదు, తన కాబుల్ ఎద్దర్ సిమ్కనమందిన్, ఇంతె తన్‍పొయ్ విస్వాసం ఇటర్ సిమ్కన మందింఙ్‍, దెయ్యంన్నె కీకె ఎరెకా అదికారున్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","గని ఇవ్రు నెత్తుర్ డ్, అని సరిరడ్ మన్కక్నె ఇస్టంతొ ద్ గని దెయ్యమి ఔర్ తక్లంఙ్ అంసంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ఆ పానం వాక్యమ్ మన్కనె రుపామాడ్ మన్కనే నడమున్ బత్కసాద్. అమ్‍నంత్తి కృప, సత్తెం పూర అన్సా. అముదు బానుంఙ్ ఒక్కొది ఒక్కొంద్ కీకె. అదుంఙ్ ఎతి అమ్నత్తి సాదరి కీర్తి కలెకద్ అన్సాద్. ఆ మహిమన్ అమ్ అమ్నత్తి ఓల్‍తమ్. ");
INSERT INTO nit_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","యోహాన్ అమ్నున్ బదోల్ ఇనంఙ్ జోరకత్ ఇడ్నెంద్, “అనుంఙ్ వెన్కత్ వరెకద్ అనుంఙ్ ఎన పేలెతన అనెకాంద్. అదుంఙ్‍ ఎతి అనుంఙ్ ఎన గొప్ప. ఇసా అన్ ఎరుంఙ్ బదోల్ ఇడ్తానొ అమ్‍ది ఇమ్‍దు” ");
INSERT INTO nit_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","అమ్నున్ వాలడ్ నెడ్‍సిమ్కన మందింఙ్ పూర కృప అసిర్వదముంఙ్ అసిర్వదం రొబట్టిన్. ");
INSERT INTO nit_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","దెయ్యం మోసేన్ వాలడ్ నియమ్ సస్రన్ సియ్‍తెంద్. గని యేసు క్రీస్తున్ వాలడ్ కృపన్, సత్తెం వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ఎరి ఎప్పుడి దెయ్యమున్ ఓలెంఙ్ సాలెర్. దెయ్యమున్ బానె పొలికా పకంఙ్ అనెకద్ అముదు ఒక్కొ కీకె అనెకాంద్ దెయ్యమున్ ఒర్కి సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","తే యోహానున్ వేలుత్, నీ ఎంద్‍ ఎన్నెంద్? ఇనెకాద్ బదోల్ ఒర్కి లెంఙ్ ఇసా, యెరూసలేముత్ యూదులె దండి, దెలక్ లేవికున్ అమ్నున్వై పాన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","యోహాన్ సమాదనం ఇడ్డెంఙ్ వెన్కంఙ్ వరెతెంద్. గని డప్‍సెటా సోయ్‍ సమాదనం ఇడ్‍తెంద్. “అన్ క్రీస్తుద్ ఎరేన్!” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","తె ఔర్ అమ్నున్ ఇంతెర్, “నీ ఎన్ని? ఏలీయాక్ క్నివా?” ఇసా వేలుత్‍ ఓల్‍త్తెర్. అముదు, “తొద్” ఇసా ఇంతెంద్. ఔర్ ప్రవక్త నివా? ఇసా వేలుత్ ఓల్‍త్తెర్. అముదు “తొద” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ఔర్, వాఇంత్తెర్ మరి నీ ఎన్నీ? అమున్ పన్కతరున్ ఇడ్డెంఙ్ నీతనెద్ ఇడ్‍సాతీ? ఇసా వెలుత్ ఓల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","యోహాన్ ఇనంఙ్ సామదనం ఇడ్‍తెంద్. ప్రబుంఙ్ సోయ్త మర్గమ్ తయార్‍కల్‍ ఇసా బట్టి జాగ తన ఓకొ లెంఙ్ విన్కవత్తిన్. యెసయక్ ఇదా యెసయక్ ప్రవక్త ఇం తా గొట్టిక్. ");
INSERT INTO nit_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","మల్ల ఇవ్రున్ పన్కతర్ పరుసిక్ కొన్సెం మంది అన్సార్. ");
INSERT INTO nit_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","అదుంఙ్ ఎంతి యోహాన్ “నీ క్రీస్తుని ఎరేలాంఙ్‍, ఏలీయాక్ ఎరేలాంఙ్‍, ప్రవక్త నాయ్ ఎరెలాంఙ్. అటనీ ఎరతె నీ మందింఙ్ తనుంఙ్ బాప్తిస్మ సియ్‍సాతీ?” ఇసా వేల్త్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","యోహాన్ సమాదనం ఇడ్‍సా, “అన్ ఇరాడ్ బాప్తిస్మ సియ్‍సాత్. గని నీర్ ఒర్కిల్‍సెటద్ ఒక్కొద్ ఇమున్ నడుమున్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","అముదు అనుంఙ్ వెన్కత్ వరెకంద్. గని అన్ అమ్నె కెర్రికున్‍ నాయ్ పుసెంఙ్ యోగినన్ తోతెన్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ఈ గట్న బేతని ఊరుఙ్ జర్గిల్‍తె. అముదు యోహానుంఙ్ బాప్తిస్మ సియ్‍త యోర్దన్ పేనింఙ్ అలా పకంఙ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","మరొక్కొ జీర్‍ యోహాన్ యేసుంద్ తన్‍వై వరెకనున్ ఓలుత్న, ఇదొ! దెయ్యమ్నె గొర్రెనె కొవ్వె! సదార్ దున్యత పాపులున్ తన్‍పొయ్‍ సుమ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","అనుంఙ్‍ వెన్కత్ ఒక్కొద్ వర్సాంద్, అమ్దు అనుంఙ్ ఎన్న గొప్ప అదుంఙ్ ఎత్తి అనుంఙ్ ఎన పేలెతంది ఇసా అన్ ఎనున్ బదోల్ ఇడ్సాతొ అముదు ఇమ్ది. ");
INSERT INTO nit_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","అపుడ్ అముదు ఎందొ అనుఙ్నాయ్ ఎర్కతొద్. గని, అమ్నున్ ఇస్రాయేల్ మందింఙ్ ఒర్కి కలెంఙ్ ఇసా ఇరాడ్ బాప్తిస్మ సియెంఙ్ వతన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","మల్ల యోహాన్ సాక్సం ఇడ్‍తెంద్. ఆబార్తన పరిసుద్ద ఆత్మ ఒక్కొ పారెవనె రుపమడ్ వత్న అమ్నున్ పొయ్ వరెకదున్ ఓల్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“అనుంఙ్ పన్ఙిదూక్ ఒర్కితొద్” బాప్తిస్మ సియెకాదుంఙ్ దెయ్యం అన్‍ పన్కతిన్. పరిసుద్ద ఆత్మ ఎనున్ పొయ్ డిగ్‍సాదొ ఆ మన్కకి పరిసుద్ద ఆత్మనాడ్ ఈరడ్ బాప్తిస్మ సియ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","అన్ ఈ గట్నన్ ఓల్‍తన్. ఇమ్‌ద దెయ్యమ్నె పోరక్ ఇసా సాక్సం ఇడ్సత్. ");
INSERT INTO nit_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","మరొక్కొ జీర్ యోహాన్ అత్తి ఇలుత్ అన్సాద్. పెనొక్కొ సాట్ అమ్నె ఇదర్ సిసు అమ్నున్ వెంట అండెర్. ");
INSERT INTO nit_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ఆ వెలంఙ్ యేసుంద్ అనంఙ్ సెరెకనున్ ఓలుత్న. “ఇదె” ఓలుర్ దెయ్యమ్నె గొర్రెనె కొవ్వె ఓలుర్! ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ఆ ఇద్దర్ సిసు అముదు ఇనెకా గొట్టిన్ విత్న, యేసున్ వెంటా సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","యేసుంద్ ఔరున్‍వై తిర్గుత్, ఔర్ వరేకదున్ ఓలుత్, “ఇముంఙ్ తనెద్ పాజే?” ఇసా వెలుత్‍ ఓల్‍తెంద్. ఔర్, “రబ్బీ! గురు నీ ఎత్తి అన్సాతి?” ఇసా వెలుత్ ఓల్‍త్తెర్. రబ్బీ ఇంతె గురు ఇసా అర్తం. ");
INSERT INTO nit_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","యేసుంద్, “వత్‍ ఓలుర్” ఇసా సమాదానం ఇడ్‍తెంద్ అప్పుడ నాలి గంటల వేల ఎత్తడిన్. ఔర్ సెత్న అముదు ఎత్తి అన్సాదొ ఓల్‍త్తెర్. ఆ దినం అమ్నున్‍ తొలె గడప్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","యోహాన్ ఇడతదున్ విత్న, యేసున్ నంమ్‍తర్ ఔర్ ఇద్దర్ లోపా అంద్రెయక్ ఒక్కొద్. అంద్రెయక్ సీమోన్ పేతురునె దాదక్. ");
INSERT INTO nit_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","అంద్రెయక్ వెంటాయ్‍ తన్నె దాదక్ సీమోనున్ ఒర్కిలుత్న అమ్నున్ వెంటా, “మెస్సయ్యక్ ఇంతె క్రీస్తుంద్” ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","మల్ల సీమోనున్ యేసుంద్ మెరకుగుత్ తోడ వతెంద్ యేసుంద్ అమ్నున్ ఓలుత్, “ఇన్నె పేర్ సీమోన్! నీ యోహాన్నె కీకెనీ. ఇడితన నీ కేప ఇసా ఇన్దర్” కేపా ఇంతె పేతురు ఇసా అర్తం దండి గుండు. ");
INSERT INTO nit_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","మరొక్కొ జీర్ యేసుంద్ గలిలీయ సెరెకాద్ ఇసా నిర్నయ్ కతెంద్. పిలిపున్‍ వై సెత్న అమ్నున్, అన్ వెంట వా ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","అంద్రెయక్, పేతురు అనెక ఊర్ అద్ది, పిలిప్‍ నాయ్ బెత్సయిదా ఉరద్. ");
INSERT INTO nit_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","పిలిప్ నతనెలుంఙ్ సటీ కీరవుత్ అమ్నున్ వెంట, “అమ్ మోసేనె నియమ్ సాస్త్రముత్ ఎనున్ బదోల్ వాయుత్ అన్సాదొ అమ్నున్ ఒర్కిల్. ప్రవక్త కెర్ వాయ్‍త్తెర్ ఇమ్నున్ బాదొలి. ఇమ్నె పేర్ యేసుంద్. అముదు యోసేప్నె కీకె. నజరేత్ తంద్ ఎన్నేద్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","నతనేల్, “నజరేత్ ఉర్ తన సోయ్ ఎరెకద్ సోయ్!” ఇసా ఇంతెంద్. “వత్న ఓల్!” ఇసా పిలిప్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","నతనేల్ యేసుంద్ తన్‍వై వరెకనున్ ఓల్తెంద్. అమ్నున్ బదోల్, “ఇద్దో! సత్తెం ఇస్రాయేల్! అమ్నత్తి తనయ్ కప్‍టం తోతెద్” ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“ఇముంఙ్ అన్‍ ఎనంఙ్ ఒర్కి?” ఇసా నతనేల్ వెలుత్ ఓల్తెంద్. యేసుంద్, “పిలిప్ ఇన్ కూగెంఙ్ పేలెయ్, నీ మేడి మాక్ బూడున్ అనెంగయ్ ఇన్ అన్ ఓల్‍తన్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","నతనేల్, “రబ్బీ! గురు నీ కరెయ్ దెయ్యమ్నె పోరక్. ఇస్రాయేల్ రాజక్ ప్రబుద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","యేసుంద్ “నీ మేడి మాక్ బూడున్ అనెకనున్ ఓల్‍తన్‍ఇసా ఇడ్‍తదుంఙ్ వాలడ్‍ విస్వాస్ ఇడ్‍సాతివా? ఇదుంఙ్ ఎనా సోయ్తవున్ ఓల్‍త్తీ!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","అముదు మల్ల, “ఇద్ కరెయ్ ఆబార్ పయెకదున్, దెయ్యమ్నె దూత్ మన్కనె పోరక్ పొయ్ డీగెకాదున్, పెనా సొకేకదున్ ఓల్‍త్తీ” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","మూది దినాలుంఙ్ గలిలీయ దేసెముత్ కానాన్ పట్నముత్ ఒక్కొ పెండ్లి ఎద్దిన్. యేసునే అమ్మ అత్తి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","మల్ల యేసునున్ సిసు నాయ్ ఆ పెండ్లింఙ్ కుగ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","అగుర్‍న్నె రసా తిర్‍తాత్తి యేసున్నె అమ్మ అమ్నున్, “ఔరె అగుర్‍న్నె రసా తిర్‍త్తిన్!” ఇసా ఇడ్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","యేసుంద్ అనుంఙ్ తనుంఙ్ ఇడ్‍సాతి అమ్మ! అన్నె వెలా ఇంక్క వారెంఙ్ అన్సాద్! ఇసా సమాదనం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","అమ్నె అమ్మ గడియక్ కున్, “అముదు ఇడ్‍త్తెత్తి కలుర్!” ఇసా ఇన్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","పకంఙ్ గుండడ్ ఒజిప్త ఆర్ కాఙు అన్సా. ఆ కాఙులున్ యూదూలె కయ్‍దనె ఇసొబడ్ వేలంఙ్ కలెకదున్ వాడ్‍నేర్ ఔర్. ఒక్కొకొ కాఙుత్ నూటఈర్వె లీటలుంఙ్ ఎంత్ ఈర్ సుమ్‍నే. ");
INSERT INTO nit_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","యేసుంద్ జితగలున్, “ఆ కాఙులెంఙ్ ఈర్‍ నిడ్‍పుర్!” ఇసా ఇంతెంద్. ఔర్ కగు నిండ ఈర్ నిడప్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ఆ వెన్కత్ యేసుంద్ ఔరున్, “ఇండ్డి ఒక్కొ కాఙ్తన కొన్సెం పుసుత్ సెత్న దండి గడియక్ రా తోడ సెర్” ఇసా ఇంతెంద్. ఔర్ అనాయ్‍ కత్తెర్. ఆ పెండ్లి జెవున్నె మాల్కక్, అంగుర్‍ రస మలంఙ్త ఈర్‍నె సవ్వి ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ఆ దండి గడియక్ అద్ రసా ఎత్రనా వత్తినొ ఒర్కియ్. గని ఆ పెండ్లి జెవున్నె మాల్కక్ అద్ ఎత్రనట్ వత్తినొ అర్తం ఎరెత్తిన్. అదుంఙ్ ఎత్తి అముదు పెండ్లి ఎరెకా నొవ్రకున్ పకంఙ్ కూగుత్న, ");
INSERT INTO nit_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“అమ్నున్ సిమనా మంది సోయ్త అంగుర్‍నె రసాన్ పేలె పైతెర్. ఔర్ సిమన్ ఉండత్తి అముంఙ్ అంగుర్‍నె రాస సియ్‍త్తెర్. గని నీ సోయ్త అంగుర్‍ రసాన్ సియ్తీ” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","యేసుంద్ కత్త పెలె సమత్కలున్. ఇద్ గలిలీయ కానానుత్ జర్గిల్‍త్తిన్. ఇనంఙ్ అముదు అమ్నె మహిమ కలెకద్ ఇడ్‍సా అమ్నె సిసులుంఙ్ అమ్నున్ వాలడ్ విస్వాసం ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ఇదా ఎదా వెన్కత్ యేసుంద్ తన్నె అమన్ వెంటా, దాదక్ తకెరాడ్, సిసులడ్ కలయుత్ కపర్న ఇనెకా పట్నంముంఙ్ సెద్దెంద్. అత్తి ఔర్ కొన్ని గొల్‍ వస్తి అన్‍డెర్. ");
INSERT INTO nit_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","యూదులె పస్క పండుగ్ మెరా వారెంగయ్ యేసుంద్ యెరూసలేముంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","మంది గుడిత్ ఆవరవై కొదలున్, గొర్రెలున్, అని పైసె పేయెకరున్ పారెవాలున్ విరెకారున్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","అదుఙి నారనడ్‍ ఒక్కొ సాట్ బనపుత్ సిమ్కన మందిన్ ఆ గుడిత్ ఔర్తన డగ్‍లిపుత్ పుస్తెంద్. కొదలున్, గొర్రెలున్ సాయుత్, పైసె బదలిపెకారున్ ఔరె పైసెలున్ బూడున్ సల్లుత్ ఔరె బల్లలున్ తలుంఙ్ బూడున్ కత్న సయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","పారెవా విరెకారున్, “అదా సిమ్కనన్ అత్రనట్ పుసుర్! అన్నె బానె ఎల్ల అంఙడి ఇదరెంఙ్ ఇముంఙ్ ఇముఙ్ ఎంతే ఇంమతే?” ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","అమ్నె సిసు కితబుత్ వాయుత్ అనెకవులున్ అది కత్ ఇదార్తెర్. ఓ దేవా ఇన్నె ఎల్లత్ అనుంఙ్ ఆస అన్నె అన్నత్తి కిస్లంఙ్ తరిసా నండాద్. ");
INSERT INTO nit_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","అపుడ్ యూదు యేసున్‍ వాలడ్, “ఓక్కొ సమత్కరున్ కత్న ఇడ్. అదవున్ ఇనుంఙ్ ఇద కలెకదుంఙ్ ఇనుంఙ్ ఎ అదికరమున్ అముంఙ్ ఇడ్సతీ అమ్ నామ్‍సాతుమ్” ఇసా ఇన్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","అపుడ్ యేసుంద్ ఇనంఙ్ సామదనం ఇడ్‍తెంద్, “ఈ మందిరున్ ఓద్‍రిపుర్. అన్ అదున్ మూది దీనలుంఙ్ పేనా కాటాత్.” ");
INSERT INTO nit_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","యూదు, “ఈ మందిరున్ కట్టెంఙ్ సాడిస్అర్ సాల్కు లగ్‍త్తె. నీ అదున్ మూది దినాలుంఙ్ కాట్‍సాతి వా?” ఇసా ఇంన్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","గని యేసుంద్ ముడెకాద్ మందిర్‍ తోద్‍గ తన్నె సెత్త ఇనెక బదోల్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","మల్లా అముదు తిక్కుత్ పానం ఎద్దత్తి, అమ్నె సిసులుంఙ్ అముదు ఇడ్‍తద్ అది వత్తిన్. మల్ల ఔర్ లేకనముత్ వాయ్‍తదున్, యేసుంద్ ఇడ్‍తదున్ నమ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","యేసు పస్క పండ్గుంఙ్ జీర్ అముదు యెరూసలేముత్ అత్న కత్త సమత్కలున్ మంది ఓల్‍త్తెర్. ఔరుంఙ్ అమ్నున్ పొయ్‍ విస్వాస్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","అదుడ్ ఎతి యేసుంద్ సదరుంఙ్ ఒర్కి. అదుఙి అముదు ఔరున్ పూర నమ్మెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","మన్కన్నె సబావ్ అమ్నుంఙ్ ఒర్కియ్ అదుంఙ్ ఎత్తి మన్కకెరున్ బదోల్ అమ్నుంఙ్ ఎరీ సాక్సం ఇడ్డెకాద్ అవాసరం తోతెద్. ");
INSERT INTO nit_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","నికోదేము ఇన్నెకా పరుసిక్ యూదులె దండి అండెద్. ");
INSERT INTO nit_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","అముదు ఒక్కొ జీర్ సింత్తె యేసున్‍వై సెత్న, “రబ్బీ! నీ దెయ్యంతన వత్త గురు ఇసా అముంఙ్ ఒర్కియ్. నీ కలెకా సమత్కల్ దెయ్యం అన్ వెంట అన్సేట ఎరి కాలెంఙ్ సాలెర్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","యేసుంద్ జవాబ్ ఇడ్‍సా, “ఇద్‍ కరెయ్ ఎంద్. కొత్త జన్మతపా ఎదీ దెయ్యంన్నె రాజ్యమున్ సెరెంఙ్ సాలెద్” ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","అదుంఙ్ ఎత్తి నికోదేము, “ఓక్కొ మన్కక్ పబ్గ ఎద్దె మల్ల ఎనంఙ్ జన్మ వద్దద్? మల్ల జన్మ వరెంఙ్ అమ్మనె పెటెత్ పెనా ఒక్కొఉసాట్ సెరెంఙ్ సలేమ్‍ తా!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","యేసుంద్ జవాబ్ ఇడ్‍సా, “ఇద్ కరెయ్ ఎంద్.” ఈరడ్, పరిసుద్ద ఆత్మనాడ్ జన్మ వర్సెట తప్ప ఎదీ దెయ్యమ్నె రాజ్యముంఙ్ సెరెంఙ్‍సాలెద్. ");
INSERT INTO nit_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","సరీరాడ్ జన్మిల్త, ఆత్మనడ్ జన్మిల్‍త ఆత్మ. ");
INSERT INTO nit_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","అదుంఙ్ ఎత్తి అన్, నివ్‍ మల్ల జన్మవారెంఙ్ పాజె ఇనెకాదున్ విత్న కమల్ ఎన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","గాలి తన్నె మనడ్‍ వర్‍సాద్. నిర్‍ అద్నె అవజున్ వినెంఙ్ సాల్‍సాతిర్ గని అద్ ఎలడ్ వర్‍సాద్ ఇనెకాద్, ఎదె వర్‍సాదొ ఇడెంఙ్ సాలెర్. పరిసుద్ద ఆత్మనాడ్ జన్మిల్‍తద్ ప్రతి ఒక్కొద్ అనాయ్ అన్సార్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","“అద్ ఎనంఙ్ ఎరెంఙ్ సాలదే?” ఇసా నికోదేము వెలుత్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","యేసుంద్, “నీ ఇస్రాయేల్‍నే దొడనీ తా! ఇనుంఙ్ ఇదా అర్తం ఎరెతెవా?” ");
INSERT INTO nit_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ఇద్ కరెయ్. అమ్ అముంఙ్ కారిల్ తదున్‍బదోలి ఇడ్‍సాతుమ్. ఎన నీర్ అమ్మె సాక్సమున్ ఇడ్‍సాతిర్ అదున్ సుమ్ ఇసా. ");
INSERT INTO nit_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","అన్ ముడెకా దున్యతవున్ బదోల్ నీర్ నంమ్మెతిర్. అన్ స్వర్గంత గొట్టిక్ ఇడ్ఞె ఇనంఙ్ నమ్మతీర్? ");
INSERT INTO nit_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","పరలోకామ్ తన్న వత్త మన్కనె పోరక్ తప్ప పరలోకాముంఙ్ ఎదీ ఎప్పుడి సెరెంఙ్ సాలెద్. ");
INSERT INTO nit_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","మోసే పితూడ్ పామున్ బట్టిత్ ఎద్‍త్తెతి మన్కనె పోరక్ ఎత్తెంఙ్ పాజె ");
INSERT INTO nit_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","అమ్నున్ నమ్తెంద్ ప్రతి ఒక్కొద్ నాస్ ఎర్‍సెటా ఎప్పుడి తిక్సెట పానం అనెంఙ్ ఇంతె, ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","దెయ్యం ఈ దున్యత మన్కకేరున్ ఎత్తెఓ ప్రేమ్ కతెంద్. తన్నె ఒక్కొది ఒక్కొ పోరక్ ఈ దున్యంఙ్ పన్కతెంద్. అమ్నున్ నమ్తర్ ఎర్రి నాస్ ఎరెంఙ్ తోద్ ఇసా, ఔర్ ఎప్పుడి అనెక పానం సుమ్సార్ ఇసా అమ్నె ఆసా. ");
INSERT INTO nit_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","దెయ్యం తన్నె పోరకున్ వాలడ్ సోయ్ ఈ దున్యతరున్ రక్సనన్ సియెఙి గని సిక్స సియ్యెంఙ్ వరెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","తన్నె పోరకున్ తనతరుంఙ్ అముదు సిక్స సియెద్. నమ్‍సెటర్ పొయ్, ఇంతె దెయ్యమ్నె ఒక్కొది ఒక్కొ కీకెన్ పేరున్ నంమెత్తెర్ అదుంఎత్తి, ఇంతిన్ ఎంతి సిక్స సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","దెయ్యం ఇడ్‍త తిర్పు, ఎద్దిన్. దున్యత్ వేలంఙ్ వత్తిన్. మంద్దికారబ్ పానిక్ కాల్‍సార్ అదుంఙ్ ఎత్తి ఔర్ వెల్ఙున్ సాయుత్ చికటిన్ ప్రేమ్ కల్సర్. ");
INSERT INTO nit_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","కరాబ్ పనిక్ కలెకాద్ వెల్ఙున్ రోయ్తెంద్. తన్నెకారబు వాకకురియ్‍ద ఇసా అముదు వెల్ఙుంఙ్ వరెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","అదుఙి సత్తెం పనిక్ కలెకాద్ తన్ కత్తపనిక్ దెయ్యమున్ వాలడ్‍ కత్త వున్ మంది ఓలెంఙ్ ఇసా వెలంఙ్ వర్సద్. ");
INSERT INTO nit_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ఇనంఙ్ ఎద్ద వెన్కత్ యేసుంద్ తన్నె సిసు వెంట యూదియ జాగ సెత్న అత్తి క్కొన్ని దినా అండెద్, బాప్తిస్మ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","అనాయ్ యోహాన్‍ నాయ్ సలీమ్ పట్నం మెర ఇనెకా ఐనొను ఊరున్ ఈర్ పెరెత్ అనెకదుంఙ్ వాలడ్, అత్తి అనెకా మందింఙ్ బాప్తిస్మ సియ్‍సా అన్నెద్. మంది బాప్తిస్మ సుమెంఙ్ అత్తి సెన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ఇద్ యోహానున్ జేలుత్ తప్పెంఙ్ పేలె జర్గిల్తా గట్న. ");
INSERT INTO nit_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","అపుడ్ వేలంఙ్ అదర్ బదొల్ యోహాన్ సిసులున్ ఒక్కొ యూదునుంగ్ విరొద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","అపుద్ ఔర్ యోహానున్ వై వత్నా “రబ్బీ! యోర్దన్ పేనింఙ్ అలపక్క ఇముంన్ వెంట అనెకాద్, నీర్ ఎనున్ బదోల్ సాక్సం ఇడ్‍త్తిరొ? అముదు బాప్తిస్మ సియ్‍సాద్. సిమనా మంది అమ్నున్‍వై సెసానంసార్” ఇసా ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","యోహాన్ సమాదనం ఇడ్‍సా, పరలోకమ్ తన సియెకద్ తప్ప ఎరి తనెనీ కమపెంఙ్ సాలెర్ ఇసా ఇడ్తేంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","అన్ క్రీస్తునన్ ఎరెన్ ఇసా, అమ్నుంఙ్ ఎన ముండట్ పన్కతనుని మత్రమ్ అన్ ముండటి ఇడ్‍తన్. ఇదుంఙ్ నిరీ సాక్సం. ");
INSERT INTO nit_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","నొవ్రి నొవ్రకున్ వెంట నొవ్రక్నె సంఙ్తక్ నొవ్రక్నె గొట్టి వినెంఙ్ కుసి కల్సార్ అన్ గిన ఇద్ వింత్ కుసీ కల్సాత్. ");
INSERT INTO nit_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","అమ్నె ప్రాముక్యం పెర్గెంఙ్. అన్నె ప్రాముక్యమ్ కమ్మి ఎరెంఙ్. ");
INSERT INTO nit_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","పొలడ వతద్ సదరుంఙ్ ఎన గొప్పద్అన్సాద్. దున్యత్ జన్మిల్‍తద్ ఈ దున్యంఙ్ గదియ్‍దాద్. అటాద్ బూమి బదోల్ ముడ్‍సాద్. అదుంఙ్ ఎత్తి పరలోకంతన వత్తద్ సదరుంఙ్ ఎన గొప్పద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","అముదు తన్‍ ఓల్‍తదున్ బదోల్ తన్ వింతదున్ బదోల్ సాక్సం ఇడ్‍సాద్. గని అమ్నె సాక్సమున్ ఎరి నంమెర్. ");
INSERT INTO nit_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","గని అదున్ నంతర్ మన్కక్ దెయ్యం సత్తెం అన్సాద్ ఇసా నంసాద్. ");
INSERT INTO nit_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","తానుంఙ్ ఇంతె దెయ్యం పన్కతద్ దెయ్యం ఇడ్‍త గొట్టికున్ ఇడ్‍సాద్. అమ్నుంఙ్ దెయ్యం పరిసుంద్ద ఆత్మన్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","బాంద్ పోరకున్ ప్రేమ్ కల్సాద్. అదుంఙ్ వాలడ్ సిమ్కన అమ్నె కెయ్యుత్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ఆ పోరకున్ నమ్తర్ అర్ ఒక్కొద్ ఎప్పుడి అనెకా పనామున్ సుమ్ దాద్. గని ఆ కీకెన్ రోయ్తనుంఙ్ ఎప్పుడి అనెకా పానం రొంబాడెద్. దెయ్యంన్నె రాగ్ తన్న ఎద్ది సుకిపెంఙ్ సాల్తెంద్ ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","యేసుంద్ యోహానుంఙ్ ఎన ఎక్వ మందిన్ సిసు కాల్‍సా నంసద్ ఇసా, అమ్నుంఙ్ ఎన ఎక్వ మందిన్ బాప్తిస్మ సియ్‍సాద్‍ ఇసా పరుసిక్ వింత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","కారె బాప్తిస్మ సియ్‍తద్ యేసుంద్ ఎరెంద్. అమ్నె సిసు సియ్సార్. ");
INSERT INTO nit_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","అపుద్ అముదు యేససుంద్ ఇదున్ విత్న, యూదయన్ సాయుత్ గలిలీయ ప్రతముంఙ్ సేద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","అముదు సమరయన్ సామరియ పట్నముంఙ్ సెరెకాద్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","అడుగ్సా సెత్న సమరయత్ సుకారు ఇనెకా ఈ పట్నం అనెకా బూమిన్, యాకోబ్‍ తన్నె కీకె యోసేప్ పుఙ్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","అత్తి యాకోబ్‍న్నె నువ్వి అండిన్. యేసుంద్ అడుగ్‍సా సెరెఙ అలయుత్ ఆ నువ్వి మెర వత్న ఉద్‍తెంద్. అప్పుడ దుపరి బరా ఎతడిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ఒక్కొ సమరయ పిల్ల ఈర్‍ కొసెంఙ్ వత్తిన్. యేసుంద్ అదున్, బాయి! అనుంఙ్ ఉనెంఙ్ ఈర్ సియ్‍సా త్తివా? ఇసా వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","అమ్నె సిసు తినెకాద్ సుముత్ కొరెంఙ్ పట్నముంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ఆ సమరయ పిల్ల అమ్నున్ “నీర్ యూదూ, అన్ సమరయ్య పిల్లనాన్, అన్ ఉనెఙ్ ఇసా ఈర్ సియ్‍ ఇసా వెల్‍సాత్తీరే?” ఇసా ఇన్‍త్తిన్. యూదూ సమరయు వెంట కలయుత్ అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","యేసుంద్ సమాదనం ఇడ్‍సా, “దెయ్యం తనెన్ సియెంఙ్ సాల్‍దాదొ ఇముంఙ్ ఎర్కతొద్. ఇన్‍ ఈర్ ఎర్ వెల్సారొ ఇనుంఙ్ ఎర్కతొద్. అద్ ఇనుంఙ్ ఎర్క అండె అన్ వేలెఙ వెలెంక బదోల్ నీవ్‍ అన్ ఈర్ వేలెఙ ఎద్దె అన్ ఇనుంఙ్ పానం ఇరున్ సియ్‍తనెరాన్” ఇసా ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ఆ పిల్ల, “మాల్క! నువ్వి గుండి అన్సాద్. ఇమ్మత్తి తొడెంఙ్ పోర తోతెద్. ఈ పానం ఈర్ ఇముంఙ్ ఎనంఙ్ రొంబాడద్? ");
INSERT INTO nit_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","నీర్ అమ్మె తొలెనితార్ దొడా యాకోబ్‍ ఎన సోయ్తరా? అముదు ఈ నువ్విన్ అముంఙ్ సియ్‍తెంద్. ఈ నువ్విత ఇరున్ అముదు, అమ్నె కీకె, అమ్నె డొరియకే ఉండే” ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","యేసుంద్ ఎడ్తేంద్ “ఈ ఇరున్ ఉండెనా పెన ఈర్‍ అడ్‍దద్!” ");
INSERT INTO nit_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","గని అన్ సియెకా ఈర్ ఉండనుంఙ్ పెన ఈర్‍ అడ్వారెద్. అన్ సియ్‍త ఈర్ అమ్నున్ లోపా ఒక్కొ పానం జరలంఙ్ అందద్ మల్ల అమ్నుంఙ్ ఎప్పుడి అనెకా పానమున్ సియ్‍సాద్ ఇసా సమదానం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","అపుడ్ ఆ పిల్ల “మాల్క! అనుంఙ్ పెనా ఈర్‍ అడ్వవారెంఙ్ తోద్ అటా ఈర్‍ ఇత్తి వరెంఙ్ ఇడ్” ఇసా వెల్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","అముదు, “సెత్న ఇన్నె మాసున్ తోడవా!” ఇసా అదున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ఆ పిల్ల ఇంతిన్ “అనుంఙ్ మాస్‍తొతెద్” ఇసా ఇడ్‍త్తిన్. యేసుంద్, “ఇనుంఙ్ మాస్ తోతెంద్ ఇసా సోయ్ సామదనం ఇడ్‍త్తీ. ");
INSERT INTO nit_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","కారె ఇడెంఙ్ ఇంతె ఇనుంఙ్ ఐద్‍గుర్ మాస్నేర్ అండెర్ ఇండి నీఎన్‍ వెంటా బత్కసాతివొ అముదు ఇన్నె మాస్ ఎరెంద్. నీ సత్తెం ఇడ్‍తీ” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","అద్, “మాల్క! ప్రవక్తక్ లాఙ్ కండ్కెర్‍సాతీ. ");
INSERT INTO nit_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","అమ్మె తొలెనితార్ ఈ మోట్టా పొయ్ మొక్తెర్. గని ఇమ్మె యూదూ, ‘అమ్ మొక్కెకాద్ ఇత్తి తోద్, యెరూసలేముత్ మొకెంఙ్’ ఇసా ఇంతెర్” ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","యేసుంద్, “అదున్ ఇడ్సంద్ అమ్మా బానున్ అన్ నమ్మెక ఒక్కొ కాలం అన్ మోట్టా పొయ్ ఎనా యెరూసలేముంఙ్ మొకెంఙ్ సెరెకా గరజ్ తోసెటా దినా వద్దా.” ");
INSERT INTO nit_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ఇమ్మె సమరియత మన్కేకెర్ ఎరొ కరిల్‍సెటాదున్ మొక్సర్. రక్సన యూదూ తన వత్తిన్ అదుంఙ్ ఎత్తి అమ్ అముంఙ్ కరిల్‍తదున్ మొక్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","కరెయ్ మొక్కెకార్ బానున్ ఆత్మసక్తినాడ్ సత్తెం నడ్ మోకెకా వెల వరెకాద్ అన్సాద్. ఆ వెలా పంఙిని వత్తిన్. తానుంఙ్ ఇంతె బాంద్ అటా మొకేకారుంఙ్ సటి ని పావ్‍వొల్‍సా నన్సంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","దెయ్యం ఆత్మ ఎన్నెంద్ అదుంఙ్ ఎత్తి అమ్నున్ మొక్కెకర్ ఆత్మనాడ్ సత్తెం మొకెంఙ్ ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ఆ పిల్ల, “క్రీస్తుంద్ ఇనెకా మెస్సయ్యక్ వారెకాద్ అన్సాద్ ఇసా అనుంఙ్ ఎరకాయ్. అముదు వతెంద్‍ ఇంతె నేడుంఙ్ సిమ్కన నీ ఇడ్సాద్” ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","యేసుంద్, “ఇన్‍ వెంటా ముడెకాంద్ అముదు! అన్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","అద్ది వెలంఙ్ అమ్నె సిసు మలయుత్ వత్తెర్. అముదు ఒక్కొ పిల్లనాడ్ ముడెకానున్ ఓలుత్ కామల్ ఎదెర్. ఇస తనెద్ పజేహిసా అదున్ తానుంఙ్ ముడ్సనంసతి ఇసా ఎరి వెలుత్ ఓలేతెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","అపుడ్ ఆ పిల్ల తన్నె దుత్తన్ అతినీ సాయుత్న ఊరుంఙ్ మలయుత్ సెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","మందిన్, “వర్ర! అన్ కత్త సిమ్కనన్ ఇడ్‍త మన్కన్ ఓలుర్. ఇమ్‌ది క్రీస్తుంద్ తా” ఇసా ఇన్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ఔర్ సిమ్కన మంది ఉర్ తన్న కురియుత్ అమ్నున్‍వై సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ఇంతెత్ అమ్నె సిసు, గురుజీ! తీన్‍డ్రఇసా వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","గని అముదు ఔరున్, “అన్ తినెక అంబ్బా అనత్తి అన్సాద్. గని ఆ అంబలున్‍ బదోల్ ఇముంఙ్ తన్నెది కరిలెద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","అమ్నె సిసు, “అమ్నుంఙ్ సటీ ఎరొ అంబా కొత్తెర!” అని సాయ్‍గసా ముడసార్. ");
INSERT INTO nit_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","యేసుంద్ “అన్ పన్కతన్నె,” అసాన్ పూర కలెంఙ్ అమ్నె కార్యన్ పూర కలెకాది అన్నె అంబా ఇసా ఇంతేంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“వయ్‍త వెన్కత్ నాలి నెలలుంఙ్ పంట వర్సద్!” ఇసా నీర్ ఇసాతిర్. గని అన్ ఇడ్డెకద్ తనేద్ ఇంతె ఇమ్మె కడ్లడ్ కెన్‍వై ఓలుర్. పంటా కిసెంఙ్ తయార్ ఎత్‍ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","అదున్ వయ్‍తర్ కిసెకర్ పంటన్ పుస్దర్. ఎప్పుడి అనెకా జివితముంఙ్ సటీ, అముదు ఆ పంటన్ కిస్‍దద్. కటినాడ్ పానం తప్తద్ నై పంటన్ నై కిసెకాద్ ఇద్దర్‍నై కుసీంఙ్ వదర్. ");
INSERT INTO nit_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","అన్ కరెయ్ ఇడ్సతున్ విత్తనం ఒక్కొద్, వయ్‍తె పంటా ఇంకొకొద్ సుందద్, ఇనెక గొట్టి కరెయ్. ");
INSERT INTO nit_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","నీర్ కస్టెం కత్‍ పని కల్‍సెటా పంటాన్ కిసెంఙ్ ఇమున్ పన్కెన్, అదుంఙ్ ఎత్తి మరొక్కొర్ గుల్‍ కస్టెం కత్న పని కత్తెర్. ఔరె కస్టెమున్ నీర్ పలం సుమ్‍సానంసాతిర్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ఆ పట్నముత్ అనెకా సమరయ మన్కకెర్ వెంటా సాక్స సియ్త ఆ పిల్ల, “అన్ కత్తదున్ సిమ్కన అముదు ఇడ్‍తెంద్” ఇసా ఇడ్‍తిన్. ఆ కారనుంఙ్ వాలడ్ సిమ్కన మంది యేసున్ నమ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","అదుంఙ్ వాలడ్ ఆ సమరయ మంది అమ్నున్ మెర సెత్న అమున్ వెంటా అన్ ఇసా వింతి కత్తెర్. అముదు ఔరున్ వెంటా ఇంది దినా అండెద్. ");
INSERT INTO nit_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","అముదు ఇడతవుంఙ్ వాలడ్ యింకా పెరెత్ మంది విస్వాసు ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","మల్ల మంది ఆ పిల్లఙ్‍, “పెలెని ఇడతవున్ విస్వాసిటామ్ గని ఇన్డి అమ్ అమ్నె గొట్టిక్ సోయ్ వింతమ్. అదుంఙ్‍ఎత్తి అమ్నున్ పురా సత్తెం ఇడసాతుమ్. అముదు దున్యన్ రక్సన సియెంఙ్ వతెంద్ ఇసా అముంఙ్ సోయ్ ఒర్కి” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ఇంది దినా వెన్కత్ అముదు గలిలీయ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","అత్తి యేసుంద్, “కబుర్లకున్ తన్నె సొత ఊరున్ మన్‍ రొంబాడెద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","అముదు గలిలీయ వత్తె అత్త మన్కకెర్ అమ్నున్ స్వగత్ కత్తెర్. గలిలీయ మన్కకెర్ నాయ్ పస్క పండ్గుంఙ్ సటీ యెరూసలెముంఙ్ సెద్దెర్. అదుంఙ్ ఎత్తి, ఔర్ అముదు అత్తి పండ్గుంఙ్ జీర్ కుగ్తేర్. అముదు ఇదర్త సిమ్కన ఓల్తెర్ అదుఙి అమన్ఉన్ కుసీ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","యేసుంద్, తన్‍ ఇరున్ అంగుర్‍న్నె రసా కత్త గలిలీయ “కానా” నుంఙ్ పెనా గదీయ్తెంద్. అపుడ్ కపర్న పట్నముత్ ఒక్కొ ముక్యఅదికారి అండెద్. అమ్నెపోరక్ దుక్కమడ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","యేసుంద్ యూదియ తన గలిలీయ వతెంద్ ఇసా వింత్న ఆ ముక్యఅదికారి అమ్నున్‍వై సెద్దెంద్. సెత్న తికెంఙ్ కలేక అన్నె కీకెన్ సోయ్ కాల్ ఇసా వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","సమత్కల్ అద్బుత ఇదరసెటా నీర్ ఇమున్ లోప ఎరి నమ్మెర్ ఇసా యేసుంద్ ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ఆ ముక్య అదికార్, “మాల్క అన్నె కికే తికెంఙ్ పేలెయ్ దయకత్న వ.” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","యేసుంద్ ఇన్తెంద్, “నీ సె! ఇన్నె కీకె బత్కసాద్” ఇసా ఇంతెంద్. అముదు యేసునె గొట్టిన్ నమ్ముత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","అముదు యింకా పావుతి అనెంఙ్ అమ్నె గడియక్ మన్కకెర్ ఎదురుంఙ్ వత్న ఇన్తెంద్ బాపుద్ బత్కతేంద్ ఎద్దెంద్ ఇసా ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","అముదు ఔరున్ ఇన్నె కీకె ఏ వెలంఙ్ సోయ్ ఎదెద్ ఇసా వెల్‍త్తెర్. ఔర్, “ఓకొడ్ దుప్పరి ఒక్కటింఙ్ దుక్కం తన సోయ్ ఎద్దెంద్” ఇసా సామదన్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","సోయ్ అదీ వెలంఙ్ యేసుంద్ అమ్నున్ ఇన్తెంద్, “ఇన్నె కీకె బత్కతేంద్” ఇసా ఇడత విసాయమ్ అమ్నుంఙ్ అది వత్తిన్. అదుంఙ్ ఎతి అముదు, ఔరె ఎల్లతర్‍ సదర్ ప్రబునున్ నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","యూద దేసెంతన గలిలీయ ‍వత్తె ఇద్ యేసుంద్ కత్త రెండవ సమత్కర్. ");
INSERT INTO nit_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","కొన్ని దినలుఙ్ యూదులె పండుగ్ వత్తిన్. యేసుంద్ యెరూసలెముంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","అత్తి యెరూసలేమ్‍త గొర్రె మెర బొయ్దమెరా ఒక్కొ చెరువు అండిన్ ఇదున్ హీబ్రు గొటినాడ బేతెస్త ఇసా ఇసార్. ఇదున్ తిర్గొర ఐద్ సయ్వనడ్లు అండే. ");
INSERT INTO nit_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","గుల్‍మంది లుల్లకెర్, గుడ్డిక్, కుంటిక్, పెర్‍ దుక్కంతర్ అత్తి అన్నెర్. అనఙ్ ఈర్ మెలగెంఙ్ రంఙ్ రగ్త దుక్కలకేర్ గుండ్డిక్ కుంటిక్ తిక్కెఙ్ లుల్లాకేర్ డెగ్గు అండేర్. ");
INSERT INTO nit_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","అపూడ అపుడ్ కొన్ని గుసల్ మెలాప్స నంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","అత్తి అనెక రంతన్న ఒక్కొద్ తిస్‍ఎన్మిది సాల్కు తానా దుకమడ్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","యేసుంద్ అముదు అత్తి అనెకానున్ ఓల్తెంద్. గుల్‍ పేలె సాల్‍కు తన్న అముదు అనంఙ్ అన్సాద్ ఇసా వింత్న అమ్నున్, “ఇనుంఙ్ సోయ్ ఎరత్ ఇసాతివా?” ఇసా వెలుత్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ఆ లులక్ మాల్క! ఈర్ మేలగ్త ఇరుత్ అన్ చెరువుత్ డింపెంఙ్ ఎరి తొత్తెర్. అముదు సెరెంఙ్ కిరవెంఙ్ ఇక్కొకద్ అనుంఙ్ ఎన ముడటీ ఆ ఇరున్ డిగ్‍సాద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","అప్పుడ్ యేసుంద్ అమ్నున్, “సుల్! అని తేరున్ సుమ్ముత్ సే” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","అముదు వెంటాని సోయ్‍ఎద్దెంద్. అముదు తన్నె తేరున్ సుముత్ సెద్దెంద్. ఈ గట్న ఆలపుసేక దినముంఙ్ జీర్ జర్గిల్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","అదుంఙ్ ఎంతి యూదూలె దొడా ఇంతెర్ ఇద్ ఆలపుసేక దినముంఙ్ జీర్ నియమ్ సాస్త్రం ప్రకరం సోయ్ ఎద్ద మన్కకున్, ఇన్నె తేరున్ సుముత్ సెరెంఙ్ తోద్ తా. ");
INSERT INTO nit_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","అదుంఙ్ ఎత్తి అన్న సోయ్‍కత్త మన్కక్, ఇన్నె తేరున్ సుముత్ సే ఇసా ఇడతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ఔర్, “ఇన్నె సటేయున్ సుముత్ అడగ ఇన్నెకాద్ ఎద్?” ఇసా వేల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","అదుంఙ్ ఎత్తి తన్న సోయ్ కత్తద్ ఎదెన్నెదొ ఓలిపెంఙ్ సాలేతెంద్. మంది అండదుఙ్ వాలడ యేసుంద్ అత్రనట్ కురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","అద్ ఎద్ద వెన్‍కత్ యేసుంద్ అమ్నున్ గుడిత్ కలయుత్న, “ఓల్! నీ సోయ్ ఎద్దీ. పాపు కలెకావున్ సాయ్, తోదింతె ఇదుంఙ్ ఎన ఎక్వ విరోద్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","అనంఙ్ ఎద్దత్తి అముదు సెత్న, తన్న సోయ్ కత్త మన్కక్ యేసుంద్ ఇసా యూదులే అదికాల్లున్ ఇడతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","యేసుంద్ ఆలపుసేక జీర్‍ ఇదా సదర్ కతెంద్ ఇసా ఒర్కి ఎద్దదుంఙ్ వాలడ్ యూదూ అమ్నున్ కుర‍కుర్ కాలెంఙ్ మోదలిటెర్. ");
INSERT INTO nit_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","యేసుంద్ ఔరున్, “అన్నె బాంద్ సిమనా వేలలెంఙ్ పని కల్సాంద్. అదుంఙ్‍ ఎత్తి అన్‍నాయ్ పనీ కాల్‍సాత్” ఇసా సమదానం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","“అముదు ఆలపుసేక జీరి ఎరెకడ్, దెయ్యమున్ అన్నె బాంద్ ఇసాద్. అనంఙ్ కత్న తన్ దెయ్యమున్ వెంటా అనెంఙ్ కిర్వసాద్ ఇదుంఙ్ వాలడ యూదూ అమ్నున్ అల్ఙేఙ్ ఇసా జోరకత్తెర్ ఔర్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","యేసుంద్, ఇద్ కరెయ్. పోరక్ ఏదున్ సోయ్ కాలెంఙ్ సాలెద్. తన్నె బాంద్ కలెకావ్లున్ ఓలుత్, అదవ్లుని మత్రం కీకె కాలెంఙ్ సాల్‍దద్. బాంద్‍ తన్నెద్ కాల్‍సాదొ, కీకె అదునీ కాల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","బానుంఙ్ పోరకున్ పొయ్‍ ప్రేమ్ అన్సాద్ అదుంఙ్ ఎత్తి తన్ కలెకా సిమ్కనన్ అమ్నుంఙ్ ఓలిప్‍సాద్. అమ్నుంఙ్ యింకా సోయ్తవున్ ఓలిప్‍సాద్. అప్పుడ్ నీర్‍ సదర్ గుల్‍ ఎరతిర్. ");
INSERT INTO nit_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","బాంద్ తిక్తరున్ పానం కత్తెతి పోరక్నాయ్ తనుంఙ్ ఇస్టంవత్తరున్ బత్కిప్సాంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“అంత్తెయ్ ఎరెకడ, బా ఎరునీ న్యాయ్ కలెద్. గని న్యాయ్ కలెంఙ్ కీకెంఙ్ పూర అదికార్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","బానుంఙ్ మన్‍ సియ్‍త్తెతి కీకెంఙ్ మన్ సియెంఙ్ ఇసా ఇనంఙ్ కతెంద్. కీకెంఙ్ మన్ సియ్యెదో, ఆ కీకెన్ పన్కత తాకుంఙ్‍నాయ్ మన్ సియ్సెటాద్ లాఙ్ ఎద్దద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","యేసుంద్, ఇద్‍ కరెయ్. అన్నె గొట్టిక్ విత్న అన్ పన్కతనున్ పొయ్ బరొస ఇడ్డెకనుంఙ్ ఎప్పుడి అనెకా పానం రొంబాడద్. అంటనుంఙ్ సిక్స వరేద్. ఇంతె అముదు తికెకాదున్ గెలుత్ ఎప్పుడి తిక్సెట పానం వద్దాంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ఇద్ కరెయ్. దెయ్యమ్నె పోరకుఙ్ అవజ్ తిక్‍త్తెన ఔర్ వినెక కాలం వర్సనంసాద్. పంగినీ వత్తిన్. ఆ అవజున్ వింతర్ కొత్త బత్కున్ సుమ్‍దర్. ");
INSERT INTO nit_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","తానుంఙ్ ఇంతె, పానం బాంద్ ఎనంఙ్ మోదలొ అనాయ్ కీకెనాయ్ పానముంఙ్ మొదల్ పడ్‍సా. కీకెన్ మొదల్‍ పడ్‍సా ఇదర్‍తద్ తాకి! ");
INSERT INTO nit_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","మన్కనె పోరక్ ఎన్నెంద్ అదుంఙ్ ఎత్తి తక్ అమ్నుంఙ్ న్యాయ్ కలెకా అదికార్ సియ్‍తెంద్. ఆమ్నె లేఙున్ వినేకా కాలం వరెకాద్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","గుల్‍ఎన్నెర్! తప్నెత్ అనెకార్ సదర్ అమ్నె లేఙున్ వినెకా కలం వర్సన్సాద్ ");
INSERT INTO nit_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","అనంఙ్ విన్తర్ వాక వదర్ సోయ్ కత్తర్ ఎప్పుడి పానముంఙ్ సాటి సుల్దర్. కరాబ్ కత్తర్ ఎప్పుడి సిక్స పడెంఙ్ తిక్తతన సుల్. ");
INSERT INTO nit_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","అన్ తనయ్ కలెతన్. అన్ దెయ్యం ఇడ్ ‍ఇంతదూహీ ఇడ్‍సాత్. అదుంఙ్ ఎత్తి అన్నెత్‍ న్యాయ్ ఎద్దిన్. ఎరెకాద్ అన్నె మన్‍డ తోద్. అన్ అన్న పన్కతనె నీతి కుసీ కొరెంఙ్ వత్తన్. ");
INSERT INTO nit_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","అన్నెత్ అని సాక్సం ఇడ్తె అదుంఙ్ సత్తెం అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","గని అన్న బదోల్ సాక్సం ఇడ్డెకాద్ మారొక్కొద్ అన్సాద్. అన్న బదోల్ అముదు ఇడ్డెక సాక్సముంఙ్ సత్తెం అన్సాద్ ఇసా అనుంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","నీర్ ఇమ్మెరున్ బాప్తిస్మ సియ్యెక యోహానున్‍ వై పన్కత్తిర్. అముదు సత్తెం వై ఎత్న ముట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","మన్కకెరె సాక్సం అనుంఙ్ పాజె ఇసా తోద్. గని ఇమ్మెత్ రక్సన ఎరెంఙ్ ఇసా ఇదున్ అన్ ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","యోహాన్ ఒక్కొ తరియెకా దీవేలంఙ్ వెలంఙ్ సియ్‍తెంద్. కొన్నిగొల్ నీర్ ఆ వెల్గ తన్నపయ్‍ద సుముత్ కుసీకత్తిర్. ");
INSERT INTO nit_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","గని అన్నత్తి యోహానున్ సాక్సముంఙ్ ఎన గొప్ప సాక్సం అన్సాద్. పూరా కల్ ఇసా బాంద్ అనుంఙ్ అప్పగిస్‍త కార్యిలున్ అన్ పురా కల్‍సాత్. ఈ కార్యలున్ బాంద్ అన్ పన్కెంఙ్ ఇసా సాక్సం ఇడ్సనండా. ");
INSERT INTO nit_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","అన్న పన్కత బాంద్ సోయ్ అన్న బదోల్ ఇడ్‍తెంద్. నీర్ అమ్నె లెగున్ ఎప్పుడి వినెతిర్. అమ్నె రూపమున్ ఎప్పుడి ఓలెతి. ");
INSERT INTO nit_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","అంత్తెయ్ ఎరెకాడ్ అముదు పాన్కతనున్ నీర్ నమ్మెర్. అదుంఙ్ ఎత్తి, అమ్నె బొదా ఇమ్మె మనుత్ అనే. ");
INSERT INTO nit_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","లేకనముత్ బదోల్ ఎప్పుడి అనెకా పానం రొబడసాద్ ఇసా నీర్ అదున్ పరిక్స కల్‍సాతిర్. గని ఆ వయ్‍తవీ అన్న బదోల్ సాక్సం ఇడ్‍సా. ");
INSERT INTO nit_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","అముదు నీర్ అన్నవై వత్న అనంతన పానం సుమ్మెకాదుంఙ్ నాకరిల్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“అనుంఙ్ మన్కకెరె మాన్ అవసరం తోద్. ");
INSERT INTO nit_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","గని ఇముంఙ్ సటీ అనుంఙ్ ఒర్కియ్. ఇమ్మత్తి దెయ్యంమ్నె ప్రేమ్ తోతెంద్ ఇసా అనుంఙ్ ఎర్కయ్. ");
INSERT INTO nit_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","అన్‍అన్నె బాన్నె పెరడ్ వత్తన్. అన్‍ నీర్ ఒర్కిలెతిర్. గని ఒక్కొ మన్కక్ తన్నె పెరడ్ వత్తె అమ్నున్ నీర్ ఒర్కిల్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","నీర్ ఎప్పుడి కుసినడ్ అందతిర్ గని దెయ్యమున్ మాన్ ఇసా ఇన్నెర్. అనంఙ్ అండపుడ్ అన్ ఎనంఙ్ నమ్మతిర్? ");
INSERT INTO nit_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","అన్ ఇమున్ అన్నె బానే జాగత్ అపమన్ కాలత్‍ ఇసా ఇంన్నెర్. నీర్ ఆస సుమ్‍త మోసే ఇమున్ అపమన్ కద్దద్. ");
INSERT INTO nit_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","నీర్ మోసేన్ నంసాతిర్ ఎరతె, అముదు అన్ బదోల్ వాయ్తెంద్ అదుంఙ్ ఎతె నీర్ అంనాయ్ నమ్తర్. ");
INSERT INTO nit_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","అముదు వాయ్తదున్ నీర్ నమ్సెటాండె అండ్డె అన్ ఇడ్‍తదున్ ఎనంఙ్ అన్నె గొట్టికున్ నమ్మెంఙ్ సాలతిర్?” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ఇనంఙ్ ఎత్న కొన్ని దినాలుంఙ్‍, యేసుంద్ తిబెరియ ఇనెక గలిలీయ సంమ్‍దుర్ దాటుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","యేసుంద్ సమత్కర్ రొగులకెరున్ సోయ్‍కలెకనున్ ఓలుత్, పెరెత్ మంది అమ్నున్ వెంటా వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","యేసుంద్ తన్నె సిసు వెంట కలయుత్ మెట్ పొయ్‍సెత్న అత్తి ఉద్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","అదా పస్క పండ్గుంఙ్ పేలెటర్. పస్క యూదులె పండ్గుఙ్. ");
INSERT INTO nit_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","యేసుంద్ తల్లున్ ఎత్తుత్ మందిన్ ఓలుత్ తన్నవై వరెకరున్ ఓలుత్, పిలిపున్, “ఇవ్రుంఙ్ తినెంఙ్ అంబ ఎత్తి సుమ్‍నమ్?” ఇసా వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","అమ్నె మంనున్ ఓలెంఙ్ సటీ ఈ గొట్టి వెల్‍తెంద్. యేసుంద్ తాగలెకాదొ పేలెయ్‍ విచార్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","అదున్ పిలిప్, “ఇంది నూల్ దుగనిక్లడ్ నీప్పల్ కొని కొత్న ఓక్కొకొనుంఙ్ చినంతుక్డె సియెకదుంఙ్ నాయ్ పురలె” ఇంతేంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","యేసునె సిసుంద్ ఒక్కొద్ అంద్రెయక్ అన్సాద్. ఇమ్‌ద సీమోన్‍ పేతురునె దాదక్. ");
INSERT INTO nit_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ఇత్తి ఒక్కొ పోరక్ నంతి ఐద్‍ నిప్పల్‍, ఇంది కయ్యె అన్సా. గని ఇంతె మందింఙ్ ఇదా ఎనంఙ్ పురల్‍దా?” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","యేసుంద్, “మందిన్ ఉదిపుర్!” ఇసా ఇంతెంద్. అత్తి సోయ్త నిగుర్ గడ్డిజాగాహ అన్సాద్ మంది సదర్ అత్తి ఉద్‍త్తెర్. అత్తి అనెకా పడ్సింల్ ఐద్ హజల్. ");
INSERT INTO nit_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","యేసుంద్ ఆ నిప్పలున్ సుముత్, దెయ్యమున్ వింత్తి కత్న, అత్తి ఉదుత్ అనెకరుంఙ్ పాయుత్ సియ్‍తెంద్. అనాయ్ కాయెలున్‍నాయ్ పాయుత్ సియ్‍తెంద్. సిమ్కన మంది దనియ్యున్ త్తిందెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ఔర్ దనియ్యున్ తిందత్తి, తన్నె సిసులుంఙ్ ఎద్ది తుటిఎర్సెటా ఔర్ తిత్న మిక్తా తుక్‍డెలున్ సులుపుత్ ఇడుర్! ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ఐద్ పంగతూ నిప్పలున్ పయేఙ్, మిక్త తుక్డేలున్ సిసు బార డలా నిండ నిండప్తేర్. ");
INSERT INTO nit_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","మంది సత్తెం యేసుంద్ సమత్కరున్ ఓలుత్న, “దున్యత వరెకా ప్రవక్త ఇమ్‌ది!” ");
INSERT INTO nit_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","యేసుంద్ ఔర్ తన్న బలవంతమడ్ రాజక్ కాలెంఙ్ కల్సతిరిసా ఒర్కిల్‍ తెంద్. అదుంఙ్ ఎత్తి అముదు ఒక్కొదీ మెట్పోయ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","సింతె వేల ఎద్దిన్, ఎన సిసు సమ్‍దూర్ మెరమ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ఔర్ ఒక్కొ రూకుత్ సొకుత్ సమ్దురుంఙ్ ఆలాపకత కపర్న పట్నంవై సెరెంఙ్ ఎద్దెర్. అప్పుడ్ సీకటి ఎద్దిన్. యేసుంద్ ఔరుంఙ్ ఇంకా రొంబడెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","గాలి జోరనట్ వరెంఙ్ అలవ ఎక్వ వర్సా. ");
INSERT INTO nit_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ఐద్ ఆర్ కొసూ దావ్ ఔర్ సెదత్తి, యేసుంద్ సందూర్ పొయ్ అడ్గసా ఒక్కొ రూక్‍ వై వరెకనున్ ఔర్ ఓల్‍త్తెర్. ఔరుంఙ్ గుల్‍ అర్రి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","గని, యేసుంద్ ఔరున్, “అని! అర్సనెర్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ఈ గొట్టి వింత్త వెన్కత్ అమ్నున్ రూకుత్ వరెంఙ్ ఇట్టెర్. ఆ వెలంఙ్ ఔర్ తమ్ సెరెకా రూక్ జల్ది డర్డింఙ్ గదియ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","మరొక్కొ జీర్. అలాపకా అనెకా మందింఙ్‍ ఒక్కొది రూక్‍ అన్సాద్‍ ఇసా, యేసుంద్‍ సిసు వెంట కలయుత్‍ సెరెతెద్‍ఇసా, సిసులీ సెద్దెర్‍, ఇసా ఔర్ ఒర్కిల్తేర్. ");
INSERT INTO nit_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","గని ప్రబుద్ దెయ్యముంఙ్ దన్యావద్ సియుత్, నీప్పటెలున్ మందింఙ్ పయుత్ సియ్‍ తా తింద జాగ ఇత్తి అన్సాద్. తిబెరియ సందూర్ తన పెన కొన్ని రూకు వత్తే. ");
INSERT INTO nit_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","తే యేసుంద్, అమ్నె సిసు అత్తి తోతెర్ ఇసా ఓలుత్ ఒర్కిలుత్ వెంటనీ, ఔర్ ఆ రూకూలెంఙ్ ఉదుత్ అమ్నున్ కిర్వసా కపర్నముంఙ్ వత్తేర్. ");
INSERT INTO nit_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","యేసుంద్ అలా డర్డిత్ కాడ్కెరెంగాయ్, మంది అమ్నున్, “గురు! నీర్‍ ఇదే ఎప్పుడ్ వత్తిర్?” ఇసా వెలుత్‍ ఓల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","యేసుంద్, “ఇద్ కరెయ్. సమత్కలున్ ఒల్తదుంఙ్ వాలడ్ అన్ నీర్ కిరవెర్. నీప్పట్టె తిత్న ఇమ్మె పెట్టెనిడ్పె కదుంఙ్ ఎత్తి అన్న కిర్వసాతిర్” ");
INSERT INTO nit_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","కరాబ్ ఎరెకా అంబలుంఙ్ సటీ కస్టెం కన్నెర్ ఎప్పుడి అనెకా పానం సటీ కాస్ట పాడుర్. అదున్ మన్కనె పోరక్ ఇముంఙ్ సియ్దద్. అమ్నున్ పొయ్‍ బాంద్ దెయ్యం తన్న ఒర్కిల్‍తరున్ ముద్ర ఇడదాద్ ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","అపుడ్ ఔర్ అమ్నున్, దెయ్యమ్నె మన్నుఙ్ వరెకా “సోయ్‍త కార్య కలెంఙ్ ఇంతె అమ్ తా గలెంఙ్ పాజె?” ఇసా వెల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","యేసుంద్, “అమ్నున్ పన్కతనున్ విస్వాస్ ఇడెకది దెయ్యమ్నె సోయ్త కార్యం” ఇసా సమాదానం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","అదుఙి ఔర్ అమ్నుంఙ్ ఇడ్తడెర్, “అనంఙ్ ఎరతె, అమ్ నమ్మెంఙ్ ఇంతె ఏ సమత్కరున్ కత్త ఓలిప్‍ తీ? ");
INSERT INTO nit_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","అమ్మె తొలెనితార్ బాట్టిత్ మన్నా ఇనెక అంబా తింద్దెర్. ఇదున్ బదోల్ గ్రదముత్ ఇనంఙ్ వాయుత్ అన్సాద్, ఎన్న, ఔరుంఙ్ తినెంఙ్ పరలోకం తన్న తినెంఙ్ సియ్‍తెంద్.” ");
INSERT INTO nit_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","యేసుంద్ సమాదనం ఇడ్‍సా, “ఇద్ కరెయ్. పరలోకమ్ తన్న కారె అంబ సియ్‍తద్ మోసే ఎరెంద్. అదున్ సియెకాద్ అన్నె బాంద్.” ");
INSERT INTO nit_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ఇంది పరలోకం తన్న డిగుత్ వత్త క్రీస్తుది అముదు దున్యంఙ్ పానం సియ్‍సాద్ దెయ్యం పనాముంఙ్ తినెంఙ్ సియ్సంద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ఔర్, “మాల్క! ఎప్పుడి అనెక ఈ అంబా అముంఙ్ సియ్!” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","అదుఙి యేసుంద్ ఇనంఙ్ ఇడ్‍తెంద్, “అన్ పానం సియెకా అంబలన్, అన్‍వై వాత్తద్ కార్‍వ్ ఎరెద్. అన్ నమ్‍తనుంఙ్ ఎప్పుడి ఈర్ అండెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","గని అన్ పేలె ఇడతెతి అన్ ఓల్‍త్తిర్! ఎన నీర్ నమ్మెతిర్! ");
INSERT INTO nit_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","బాంద్ అనుంఙ్ ఇడతర్ సిమ్కన అన్‍వై వద్దర్. అన్‍వై వత్తరున్ ఎరునీ అన్ తోద్‍ ఇనెన్. ");
INSERT INTO nit_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","తానుంఙ్ ఇంతె, అన్ పరలోకం తన్న అన్నె ఇ సంకటమున్‍ పూర కలెంఙ్ ఇసా డిగుత్ వరెతన్. అన్ పన్కతనే ఇస్టమున్ పూర కాలెంఙ్ వత్తన్. ");
INSERT INTO nit_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","అన్ పన్కతనె ఆసా ఇద్. అనుంఙ్ అవ్వల కత్తరున్ అన్ మద్దెంఙ్ తోద్. ఔరున్ ఆక్రి దినాలుంఙ్ బత్కిపెంఙ్. ");
INSERT INTO nit_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","పోరకున్‍వై ఓలుత్‍ అమ్నున్ నంమ్‍తర్ ఎప్పుడి అనెకా పానం సుమెంఙ్. ఇద్ అన్నె బానె అసా. అనంఙ్ నమ్తరున్ అన్ ఆక్రి దినముంఙ్ తిక్కేకా తన బత్కిపత్.” ");
INSERT INTO nit_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","అముదు, “అన్ పరలోకం తన్నడిగుత్ వత్త అంబలున్” ఇసా అముదు ఇడ్తదుంఙ్ యూదు దొడా సైగెకద్ రెగ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“ఇమ్ద యోసేప్‍నే కీకె యేసుంద్‍ తా! ఇమ్నె బద్‍అమ్మన్ నేండ్‍ ఒర్కిల్‍సాతుమ్‍ తా. మరి ఇండి ఇమ్‌ద, అన్ పరలోకం తన్న డిగుత్వతన్ ఇసా, తనుంఙ్ ఇసాద్?” ఇసా ఔర్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","యేసుంద్ ఇనంఙ్ సామదనం ఇడ్‍తెంద్. ఇమ్మెత్ నిరీ కురకుర్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","అన్ పన్కత బాంద్ పన్కసెటా, అన్‍వై ఎదీ వరెంఙ్ సాలెద్. అన్‍వై వత్తనున్ ఆక్రి దినాలుంఙ్ అన్‍ బత్కిపత్. ");
INSERT INTO nit_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ఔరుంఙ్ దెయ్యం ఇడ్తిన్. ప్రవక్త కేరె గ్రదముత్ ఇనంఙ్ వాయుత్ అన్సాద్. బాంద్ ఔరు సదరుంఙ్ ఇడతెంద్. తక్‍నె గొట్టి విత్న అముదు ఇడతదున్ కరప్‍తద్ ఔర్ అన్ మెర వద్దర్. ");
INSERT INTO nit_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","దెయ్యం తన వత్తద్ తప్ప తకున్ ఎరి ఓలెత్తెర్. అముదు ఎకున్ తాకున్ ఓల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“ఇద్ కరెయ్. నమ్‍తనుంఙ్ ఎప్పుడి తిక్సెట పానం రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","అన్ ఇమ్మె పానం అంబా. ");
INSERT INTO nit_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ఇమ్మె దొడా బాట్టిత్ అనెఙ మన్నా ఇనెక అంబాలున్ తిందెర్. ఎన తిక్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ఇమ్‌ద పరలోకంతన వత్త కారె అంబా. ఇదున్ సదారమంది తినెంఙ్ వంద్. ఇదున్ తిందర్ తిక్కెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","పరలోకం తన వత్త పానం అంబా అని. ఇదున్‍ తిందర్ ఎప్పుడి బత్కదర్. ఆ అంబా అన్నె సరీర్‍. అన్నె సరీరమున్ దున్య తరుంఙ్ సటీ సియ్‍సాత్.” ");
INSERT INTO nit_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","యూదు అదుంఙ్ వెన్కత్, “నేండుంఙ్ తన్నె సరీరమున్ ఇమ్‌ది ఎనంఙ్ నేండుంఙ్ సియ్‍దద్?” ఇసా ఔర్ ఇన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","యేసుంద్ ఔరున్ ఇనంఙ్ ఇంతెంద్. ఇంద్ కరెయ్. మన్కనె పోరక్ సరిరమున్ తిత్న, అనాయ్ నెత్తుర్ ఉండే తప్ప ఇమ్‍త్తి పానం అన్నెద్. ");
INSERT INTO nit_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","అన్నె సరీరమున్ తిత్న, అన్నె నెత్తురున్ ఉడ్డనుంఙ్ ఎప్పుడి అనెకా పానం రొంబాడద్. అమ్నున్ అన్ ఆక్రి దినాలుంఙ్ ఎప్పుడి తిక్సెట పానం సియ్. ");
INSERT INTO nit_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","తానుంఙ్ ఇంతె అన్నె సరిరం కార్రె అంబా. అన్నె నెత్తుర్ కార్రె ఉనేక జార. ");
INSERT INTO nit_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","అన్నె సరీరమున్ తింత్, అన్నె నెత్తురున్ ఉందాత్ అనంత్తి అన్సాద్. అన్ అమ్నంత్తి అన్సంత్ ");
INSERT INTO nit_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“అన్నె పానం బాంద్ అన్ పన్కతెంద్. అమ్నున్ వాల్లాడీ అన్ బాత్కసానంసాత్. అనాయ్ అన్న అంబాలిత్న తిందర్ అనుంఙ్ సటీ బత్కదద్. ");
INSERT INTO nit_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","పరలోకమ్ తన డిగుత్‍ వత్త కారే అంబా యిదీ! ఇద్ నేండె దొడా తింద అంబాలఙ్ తోద్. ఔర్ అదున్ తిన్దర్ తిక్‍త్తెర్. గని యి అంబాలున్ తిందర్ ఎప్పుడి అనెకా పానమున్ సుమ్‍దర్.” ");
INSERT INTO nit_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","యేసుంద్, కపర్న పట్నత యూదులె సావ్డిత్ ఈ గొట్టికున్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","అంనె సిసు విత్న గుల్ మంది, “ఈ ఇడ్డెకాద్ గుల్ కట్టిన్‍తద్. ఇదున్ ఎర్ ఒర్కిల్‍దర్?” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","తన్నె సిసు ఇదున్ బదోల్ సాయ్‍గసార్ ఇసా యేసుంద్ ఒర్కిల్‍ తెంద్. అముదు ఔరున్, “ఇద్ ఇముంఙ్ కట్టిన్ అన్సాద్?” ");
INSERT INTO nit_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","మన్కనె పోరక్, తన్ ముండట్ అనెకా జాగంఙ్ సెరెకానున్ ఓల్‍త్తె నీర్ తనేవిందతిర్? ");
INSERT INTO nit_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ఆత్మ పానమున్ సియ్‍సాద్. సరీరముంఙ్ కిమత్‍ తొతెంద్. అన్నె గొట్టిక్ ఆత్మంఙ్ కలయ్తవెన్నె. అదా పానం. ");
INSERT INTO nit_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","గని, ఇమున్‍లోపా కొన్సెం మంది నమ్మెర్ తన్ పొయ్ ఇడ్డ తా నమ్మకాం ఇట్టాద్ అముదు ఎందొ, అనుంఙ్ ఒర్కి సియ్యకాంద్ ఎందొ యేసునుంఙ్ పేలెయ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","యేసుంద్ ఇనంఙ్ ఇంతెంద్, “బాంద్ ఇడత సివయ్ అన్‍వై ఎరి వరెర్ ఇసా అదుంఙ్‍ ఎతి ఇంతెంద్.” ");
INSERT INTO nit_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ఆ దినం తన్న సిసులత్తి గుల్‍ మంది అమ్నున్వై వరెకాద్ సాయుత్న వెన్క సెద్దెర్. మల్లి వారెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","అపుడ్ యేసుంద్, “నిర్‍నాయ్ సెరతుమ్‍ ఇసా ఇసాతిరా?” ఇసా బరమందిన్ పోరకేర్ వెలుత్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","సీమోన్ పేతురుంద్‍, “ప్రబు అమ్ ఎర్‍వై సెదుమ్? ఎప్పుడి అనెకా పానం బదోల్‍ ఇడ్డెకా గొట్టిక్ ఇమంత్తి అన్సాహ. ");
INSERT INTO nit_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","నీర్ దెయ్యమ్నెర్, పవిత్ర దెయ్యం ఇసా అముంఙ్ ఒర్కియ్. ఇసా అమ్ నమ్సతుమ్” ఇసా సామదనం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","అప్పుడ్ యేసుంద్, “నీర్ బారామందిన్ ఆస్తరున్ ఆనీ త! అముదు ఇమ్మత్తి ఒక్కొద్ బూత్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","సీమోన్నె ఇస్కరియోత్ కీకె యూదక్ ఇనెకాద్, పన్నెడు మందినత్తి ఒక్కొద్ బదోల్ యేసునున్ సుముత్‍ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ఇనంఙ్ ఎద్ద వెన్కత్, యేసుంద్ గలిలీయత్ మత్రం అన్నెద్ ఇసా ఇడతెంద్. యూదూ అమ్నె పనం పుసతుమ్ ఇనెంఙ్ అముదు పాజె ఇసా యూదులుంఙ్ ఇడెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","యూదూలె పార్తన సాలా గుడ్సెలె పండుగ్ మెరా వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","యేసున్నె దాదక్ కేర్ యేసునున్, “నీ ఈ ప్రతమున్ సాయుత్ యూదియంఙ్ సే. అనంఙ్ కత్తె ఇన్నె సిసు నీ కలెకా కార్యలున్ ఓలెంఙ్ సాల్‍దర్.” ");
INSERT INTO nit_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","నీ ఈ కార్యలున్ కల్‍సాన్సాతి. దున్యత్ సదర్ ఒర్కిల్ తెతీ కాల్ నిన్ ఇద్తెంద్, మందిన్నె దొడంద్ పజెఇన్నెకాద్ కచ్చితంగ కార్యి కాలెద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ఇంతె అమ్నె దాదక్ కెర్‍నాయ్ నమ్మెతెర్! ");
INSERT INTO nit_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","యేసుంద్ ఔరున్ ఇంతెంద్, “అన్నె వెలా ఇంక్క వరెంఙ్ అన్సాద్. ఇముంఙ్ ఏ వెలా ఎద్దెనా సొయి. ");
INSERT INTO nit_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","దున్యతర్ ఇమున్ విరోద్ కాలెర్. గని అన్ అద్నె పనిక్ సోయ్త ఎరెవ్ ఇసాత్. అదుంఙ్ ఎత్తి అద్ అన్ సాక్సం ఇడ్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","నీర్ సిమ్కన పండ్గుంఙ్ సెర్. అన్నె వెల ఇంకా వరెది అదుంఙ్‍ఎత్తి అన్ పంగీని వరెన్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ఇనంఙ్ ఇంత వెన్కత్ యేసుంద్ గలిలీయ అండ్డెద్. ");
INSERT INTO nit_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","అమ్నె దాదక్ కెర్ సెద్దెర్ ఇసా అముదు నాయ్ పండ్గుంఙ్ అన్కెర్ సెటా సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","అత్తి పండుగ్ ఎరెకా జాగత్ యూదలే అదికాల్ల, “అముదు ఎదెఅన్సాద్?” ఇసా ఇత్న అమ్నుంఙ్ సటీ కిరవెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","మంది అమ్నున్ బదోల్ ముడెంఙ్ మొదల్ ఇట్టెర్. సిమ్కన మంది అముదు సోయ్త మన్కక్ ఇంతెర్. మంల్ల కొన్సెం మంది, “తొద్, అముదు మందిన్ పసిప్‍సాద్!” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","యూదులున్ అర్సుత్ అమ్నున్ బదోల్ ఎరి తనయ్ ఇన్నెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","పండ్గుఙ్ సార్‍సం ఎరెంఙ్ పేలెయ్ యేసుంద్ గుడిత్ సెత్న బొద ఇడెంఙ్ మొదలింట్టెద్. ");
INSERT INTO nit_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","యూదు అదికారు అది గుల్‍ఎత్న చదువ్సెటా ఇమ్‌ద ఇంతె గ్యానామున్ ఏనంఙ్ సంపదింస్ తెంద్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","యేసుంద్, “అన్ ఇడ్డెకా అన్నెత్ ఏరేద్. అదా అన్న పన్కత దెయ్యంన్నె. ");
INSERT INTO nit_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","దెయ్యమ్నె మన్నడ్ ఇదరెఙ్ ఇసా నిర్నయ్ సుమ్తంద్ అని ఇదరెకా గొట్టి దెయ్యమ్నె వాలడ్ రొబట్టినో తొడొ అన్నే సొత గొట్టిన్ కరిప్సద్. ");
INSERT INTO nit_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","సొతంఙ్ ముడెకాద్ మాన్ రొంబడెంఙ్ ఇసా ఓల్‍సాద్. గని తన్న పన్కతనున్ మాన్ కలెకది సత్తెం. అటది కరాబ్ ముడెద్. ");
INSERT INTO nit_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","మోసేన్ పొయ్ నియమ్ సాస్త్రమున్ గదిప్‍తెద్‍ తా! గని యిమున్ లోపా ఒక్కొద్‍ నై అదవున్ పాడిపెతెర్‍. అన్ అల్‍ఙెకదుంఙ్ విచార్ కత్తిర్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ఇన్న తానెద్ ఎన బూత్ సుంతిన్? ఇన్ అల్ఙెంఙ్ ఎర్ కిరవ్‌సారా? ఇసా మంది ఇన్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","యేసుంద్ ఔరున్ ఇనంఙ్ ఇంతెంద్, “అన్ ఒక్కొ చమత్కర్ ఇదర్‍తన్. అదుని నీర్ గుల్ కమల్‍కత్తిర్. ");
INSERT INTO nit_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","మోసే ఇమున్ సున్నతి కలెంఙ్ ఇసా కనుని నేకి ఇడ్‍తెంద్. ఈ నెకి మోసేన్ వాలడ్ రొబ్బటిన్ తా. ఇద్ దొడా తన వత్తిన్ ఎనా. గని ఆలపుసేక దినామ్ నీర్ సున్నతి కయ్‍దన్ ఇదర్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ఆలపుసేక దినముంఙ్ సున్నతి కత్త మోసేనె నియమ్ సాస్త్రన్ నకరింల్‍త్తెతి తోద్‍ తా! ఆ ఆపుడ్ అన్ ఆలపుసేక దినముంఙ్ ఒక్కొనున్ సోయ్‍ కత్తె అన్న పొయ్ తా రగ్గ కల్సతిర్? ");
INSERT INTO nit_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","వక కన్కెరెకదున్ బదోల్ న్యాయ్ కలుర్ ఇంతెంద్.” ");
INSERT INTO nit_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","యెరూసలేం తన కొన్సెం మంది, “అవ్రు అల్ఙెకద్ ఇసా కిరవెకద్ ఇమ్‌ది తా? ");
INSERT INTO nit_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ఓలుర్ ఇమ్‌ద గులెన ముడెకద్ ఇమ్నున్ తనయ్ ఇనెర్. ఇమ్‌ది క్రీస్తుంద్ ఇసా అదికారి కున్ కరెయ్ ఒర్కి ఎద్దిన్ తనెద్? ");
INSERT INTO nit_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ఇమ్‌ద ఎత్తదొ నేండుంఙ్ ఎర్కయ్. గని క్రీస్తుంద్ ఇత్తరన వతెంద్ అముదు ఎత్తదొ ఎరుగి ఒర్కి తోద్” ఇసా ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","అదుఙి యేసుంద్ గుడిత్ గొట్టి ఇడ్సా, నిర్ అన్ అన్ ఒర్కిలెర్, అన్ ఎతారానొ ఒర్కిల్సాతి, అనుంఙ్ సటి అన్ వరెతన్, అన్ పన్కతద్ కరెయ్, అమ్నున్ నిర్ ఒర్కిలెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","అన్ అంనత్తి తనట్ వత్తన్. అముదు అన్ పవిట్టెద్‍ అదుంఙ్ ఎత్తి అముదు అనుంఙ్ ఒర్కి ఇసా జోరనట్ వపొయుత్ ఉడ్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","అదుంఙ్ ఎతి ఔర్ అమ్నున్ సుమ్మేంఙ్ ఇసా కోసీద్ కత్తెర్. గని అమ్నె టైయిమ్ ఇంకా వరెతిన్. అదుంఙ్ ఎతి ఏరి అమ్నున్ సుమ్మెఙ్ సలెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","అత్తి అనెకర్ పెరెత్‍ మంది అమ్నున్ నమ్తెర్. ఔర్, “క్రీస్తుద్ వత్తె ఇమ్నుంఙ్ ఎన గొప్ప సమత్కర్ కద్దదా” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","మంది యేసుంద్ బదోల్‍ ఇనంఙ్ ముడెకరున్ యాజక్ వింతెంద్. ఔర్ దొడద్ పరుసిక్, కలయుత్ అమ్నున్ సుమ్ముత్ సియెంఙ్ జవన్లున్ పన్కతెర్ ");
INSERT INTO nit_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","తానుంఙ్ ఇంతె యేసుంద్ మందిన్‍తొ, “అన్ ఇమున్ వెంటా కొనిగొలి అన్సాత్.” ఆ తర్వాత అన్ పన్కతన్‍వై సెసాత్. ");
INSERT INTO nit_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","అనుంఙ్ సటీ నీర్ కిర్వసాతిర్. గని అన్ రొంబడెన్. అన్ అనెక జాగంఙ్ వరెంఙ్ సాలెర్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","యూదూ తమ్మెత్‍ తామి, “నేండుంఙ్ ఒర్కి తోసెటా ఇమ్‌ద ఎదె సెరెంఙ్ సాల్‍దద్? గ్రీకు లె నడ్‍మున్ బత్కకెకద్ నేండెర్‍ వై సెత్న గ్రికులుంఙ్ ఇడ్‍సాదా? ");
INSERT INTO nit_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","అనుంఙ్ సటీ కిర్వసాతిర్, గని ఒర్కిలెర్. అన్ అనెక జాగంఙ్ నీర్ వరెర్ సలేర్ ఇసా అముదు ఇనెకద్నె అర్తం తానెద్?” ఇసా ఔరెత్ అవ్రి ముట్టెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","పండ్గుంఙ్ ఆక్రి దినం అని ముక్యదినం, ఆ దినం యేసుంద్ ఇలుత్ జోరకత్న, “ఈర్ ‍అడ్‍తంద్ అన్ మెర వరెంఙ్ వంద్. వత్న ఈర్‍ ఉన్నెంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","లేకనముత్ ఇడ్‍తెతి, అన్ నమ్తరున్ లోపా తన ‘పానం జర తుల్‍సా.’” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ఇంతె, తన్న నమ్‍తరున్ పేలె రొంబడెకా ఆత్మన్ బదోల్ ఈ గొట్టిక్ ఇడ్‍తెంద్. అముదు మహిమ సియ్తంద్ ఎరెంద్ అదుంఙ్ ఎత్తి యేసుంద్ పంగి దూక్ ఆత్మన్ ఎరుంగి సియెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","అమ్నె గొట్టిక్ వింత్తె కొన్సెం మంది, “ఇమ్ది కరెయ్ ప్రవక్త ఎన్నెంద్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","మల్ల కొన్సెం మంది, “ఇమ్ది క్రీస్తుద్ ఎన్నెంద్‍” పెన కొన్సెం మంది కబూల్లాక్ ఇన్నెంద్ ఇసా ఇన్నెర్. గలిలీయ ");
INSERT INTO nit_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","క్రీస్తుంద్ దావిద్నె కుటుంబంతన, దావిద్ బత్కత బేత్లెహేమ్ పట్నంతన వతెంద్‍ ఇసా లేకనముత్ వాయ్‍తెర్‍ తా! ");
INSERT INTO nit_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","యేసుకున్ వాలడ్ అత్తి అనెక మందింఙ్ బేదామ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","అదుంఙ్ ఎత్తి అమ్నున్ కట్టెకద్ ఇంతెర్. గని ఎరి అమ్నున్ సుమ్మెంఙ్ సలెతేర్. ");
INSERT INTO nit_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ఆక్రింఙ్ దండి దెయ్యలక్ మెర వత్, పరుసిక్ మెర మలయ్యుత్ సెద్దెర్. ఔర్ ఆ బట్టులున్, “అముదు తనుంఙ్ కూగుత్న తోడవరెతెంద్?” ఇసా వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ఔర్, “దొడ ముట్టెత్తి ఇండి దూక్ ఎర్రి ముడ్డెత్తెర్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","పరుసిక్, “ఇంతె! ఇమున్‍నై అముదు మోసం కత్తెదా?” ");
INSERT INTO nit_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","“ముడెకత్తి ఎక్కద్ పరుసి అదికారి ఎక్కద్ అమ్నున్ నమ్తర్ ఎర్రి తోతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","నియమ్ సాస్త్రంత. కితబున్ బదోల్ తనయ్ ఒర్కి తోసెటా ఆ మందిన్ పొయ్ దెయ్యంన్నె సిరొప్ అండెతియ్!” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","నికోదేము అవ్రత్తి ఒక్కొద్. ఇండిదూక్‍ యేసున్‍వై సెత్న వతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","అముదు, “నెడే నియమ్ సాస్త్రం ఇసొబ్‍ కల్‍సెటా, అమ్నెతున్ విసెటా, అముదు కత్తదున్ ఒర్కిల్‍సెట సిక్స సియ్సాదా?” ఇసా వెల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ఔర్ “నీనాయ్ గలిలీయ తనివా? నియమ్ సాస్త్రముత్ వసిప్. కబుర్లక్ గలిల్‍తన వరెంద్ ఇసా ఇనుంగీ కరిల్‍సాద్” ఇసా సమదానం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ఇంక ఎరే ఎల్లంఙ్ ఔర్ చెదెర్ ");
INSERT INTO nit_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","అదుంఙ్ వెన్కత్ సిమ్కన మంది ఎరెత్ ఔరె ఎల్లంఙ్ కురియుత్ సెద్దెర్. యేసుంద్ మల్ల ఒలీవ మాకుల మోట్ట పొయ్‍ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","మరొక్కొజీర్ తొల్లిని పొద్‍కురియెంగయ్ అముదు పెన్న గుడిత్ కండ్కెద్దెద్. అత్తిమందీఅమ్నున్ తిర్‍గొరా మిరయ్‍త్తెర్. ఔరుంఙ్ బొద ఇండ్డెంఙ్ అముదు అత్తి ఉద్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","కరబ్ పనిక్ కలెకా పిల్లన్ సాస్త్రిక్, పరుసిక్ కలయుత్ అత్తి దండి వత్తెర్. అదున్ సదర్ మందిన్ ముండట్ ఇల్‍పుత్న ");
INSERT INTO nit_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","యేసునున్, “బొద ఇడ్డెకనివా! ఈ పిల్ల చినలి రొబంటిన్. ");
INSERT INTO nit_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","మోసేనె నియం సాస్ర్తంముత్ ఇటా పిల్లన్ గుడ్లతపుత్ అలుగుర్ ఇసా ఆగ్య సియ్‍తెంద్. నీ తన్నెద్ ఇసాతీ!” ఇసా వెలుత్ ఓల్‍త్తెర్? ");
INSERT INTO nit_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","అమ్నునె పరిక్స ఓలెంఙ్ ప్రస్న వెల్‍తెర్. అమ్నుంఙ్ సిక్స సియెకాదుంఙ్ మోకా రొంబాడద్ ఇసా ఔరె ఉద్దసం గని యేసుంద్ గొగ్గుత్న బూమిత్ పొయ్‍ తన్నె వెందెలడ్ వాయెంఙ ");
INSERT INTO nit_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ఔర్ సాయ్సెట అమ్నున్ వేల్సని అన్నెర్ అదుంఙ్ ఎద్ది యేసుంద్‍ తల్లున్ ఎత్తుత్‍ ఓలుత్న, ఇమ్మత్తి పాప్ కాల్సెటార్ ఎరేనా అండ్డె, అముదు అదున్ సోయ్ పేలె గుండ్‍ తపెంఙ్ వంద్! ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ఇనంఙ్ ఇత్త వెన్కత్, పెన బూడున్ గొగ్గుత్ బూమిత్ పొయ్ వయ్‍సా నంసాద్. ");
INSERT INTO nit_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ఇదున్ విత్న ఔర్ ఒక్కొకొంద్ అత్రనట్ కురియుత్ సెరెంఙ్ ఎద్దెర్. పేలె పబ్గు దొడా కురియుత్ సెద్దెర్. ఆక్రింఙ్ అత్తి ఇల్లుత్ అనెకా పిల్లకున్ వెంట యేసుంద్ మాత్రం మిక్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","యేసుంద్ తల్లున్ ఎత్తుత్ ఓలుత్న, “అవ్ర ఎయ్ సెద్దెర్ బాయి! ఇన్ ఎరి సిక్స సియెతె రా?” ఇసా వెలుత్ ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","అపుడ్ బాయి ఇంతిన్తొద్ ప్రబు! ఇసా అద్ద ఇంత్తిన్. “యేసుంద్ అనీ ఇనుంఙ్ సిక్స సియెన్. సే! ఇడితన పాప్ కన్నెమ్.” ");
INSERT INTO nit_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","మల్ల యేసుంద్ ఇనంఙ్ ఇన్తెంద్, “అన్ దున్యంఙ్ వెల్ఙుంఙ్. అన్నవెంటా వరెకర్ సీకటిత్ అడ్గనెర్. ఔరుంఙ్ పానమున్ వెలుంఙ్ రొంబాడద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","పరుసిక్ జవాబ్ వెల్నెర్, “ఇన్నెత్ నీవి సాక్సం ఇడ్‍సాతీ. ఇన్నె సాక్సం సత్తెం పనీ సియెద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","యేసుంద్ సమాదనం ఇడ్‍సా, “అని అన్నె సాక్సం ఇడ్‍త్తె సాక్సం సత్తెం నమ్మెంఙ్ వంద్. తానుంఙ్ ఇంతె, అన్‍ ఎత్రనట్ వత్తనొ, ఎదేసెసాతొ అనుంఙ్ ఒర్కి.” గని అన్‍ ఎత్రనట్ వత్తనొ ఎదెసెసాతొ ఇముంఙ్ ఎర్కతొద్. ");
INSERT INTO nit_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","నీర్ సిమన సరీరలాఙ్ న్యాయం ఇడ్‍సాతిర్. అన్‍ ఎరునీ పొయ్ న్యాయ్ కలెన్. ");
INSERT INTO nit_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","గని అన్ ఒక్కొ వేల న్యాయ్ ఇడ్‍త్తె అన్నె న్యాయ్ సత్తెం. తానుంఙ్ ఇంతె, అన్ ఒక్కొనని న్యాయ్ కలేన్. అంన్ పన్కత బాంద్ అన్న వెంట అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","గని ఇద్దర్ కలయుత్ సాక్సం ఇడ్‍త్తె సాక్సమున్ సత్తెం వంద ఇసా ఇమ్మె నియమ్ సాస్త్రముత్ వాయుత్ అన్సాద్! ");
INSERT INTO nit_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","అన్ అన్ వాలడ్ సాక్సం ఇడ్‍సాత్. అనుంఙ్ పెనొక్కొ సాక్సం అన్నె బాంద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","అప్పుడ్ ఔర్, “ఇన్నె బాంద్ ఎత్తి అన్సాద్?” ఇసా వెల్‍త్తెర్. యేసుంద్, “ఇముంఙ్‍, అన్నె బాంద్ ఏందొ ఒర్కి తోద్. అన్ ఏననొ కర్లిల్‍త్తె, అన్నె బాంద్ ఏదొ ఇముంఙ్ కరిలద్” ఇసా సమాదానం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","అముదు సాదరున్ గుడిత్ దన్ తప్పెకా జాగత్ ఇల్లుత్న ఈ గొట్టిక్ ఇడ్‍సా ముట్టెంద్ ఇమ్నున్ ఏదీ కట్టెతెంద్; తానుంఙ్ ఇంతె అమ్నె వేల ఇంక్క వరెతిన్! ");
INSERT INTO nit_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","యేసుంద్ పెనొక్కొ మట్ ఔరున్, అన్ సెసాత్. నీర్ అనుంఙ్ సటీ కిర్వసాతిర్. గని “అన్ సెరెకా జాగంఙ్ నీర్ వరెంఙ్ సాలెర్.” తానుంఙ్ ఇంతె నీర్ ఇమ్మె పాప్ లడ్ తిక్‍త్తిర్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","యూదు, “తన్నెత్‍ తని తిక్‍సాంద్? అదుంఙ్ ఎతి, ‘అన్ సెరెకత్తింఙ్ నీర్ వరెంఙ్ సాలెర్’ ఇసా ఇసాద్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","అపుద్ యేసుంద్, “నీర్ ఈ లొకామ్ తన వత్ తార్. అన్ పొలడ్ వత్తరాన్. నీర్ ఈ దున్యతర్. అన్ ఈ దున్యతరాన్ ఎరెన్. ");
INSERT INTO nit_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","అదుంఙ్ ఎత్తి నీర్ ఇమ్మె పాపులడ్ తిక్సతిర్” ఇసా ఇంతెంద్. అని అదుఙి నీర్ నమ్సెటండె నీర్ ఇమ్మె పాప్ లెంఙ్ తిక్సాతిర్ ఇసా ఔరడ్ ఇడ్తన్. ");
INSERT INTO nit_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ఔర్ అద్ కరెయ్ గని, నీ ఏనీ? ఇసా వెల్తేర్. యేసుంద్, “అన్ పేలెతన ఎంద్ ఇసా ఇడ్‍తనొ అముదు అన్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“అన్ ఇమ్మె న్యాయ్ బదోల్ ఎన్నిగొ రితిక్లుడ్ ఇడ్డెంఙ్ సాలత్. గని అదవున్ మారోక్కొద్లంఙ్ అన్ పన్కతనున్ సత్తెం వాలడ్ వింత్న అదవుని మత్రం దున్యతరుంఙ్ ఇడ్‍సాత్. అముదు సోయ్తద్ అన్సాద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","అముదు తన్నె బానున్ బదోల్ ఇడ్‍సాద్. ఔర్ అర్తం కలెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","అదుంఙ్ ఎత్తి యేసుంద్ అవ్రడ్, “మన్కనె పోరక్ పొయ్ సులుప్తె అముదు అన్ ఇసా నీర్ ఓర్‍కిలెతిర్. అది ఎరెకడ్ సొతంఙ్ అన్ తనయ్ గలెన్ ఇసా, అన్నె బాన్నె ఇడ్‍తదుని మత్రం ఇడసాత్ ఇసా ఒర్కిల్‍దర్. ");
INSERT INTO nit_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","అన్ పన్కతంద్ అన్ వెంట అన్సాద్. అన్ సిమ్కన వెలలెఙి అమ్నుఙ్ మనుంఙ్ వత్తవునీ ఇడ్‍సాత్. అదుంఙ్ ఎత్తి అముదు అన్ ఒక్కొనునీ సాయెద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","అముదు ఇడ్‍త గొట్టికున్ విత్న సిమ్కన మంది అమ్నె విస్వాస్ ఇడెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","తన్ పొయ్ విస్వాస్ ఇట్ట యూదు ఔరున్ యేసుంద్, “నీర్ అన్నె గొట్టికున్ వింతి రింతె, నీర్ అన్నె కరెయ్ సిసుల్. ");
INSERT INTO nit_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","యేసుంద్ జవాబ్ ఇడ్‍సా” ఇద్ సత్తెం. పాపం కత్తద్ ప్రతి ద్ పాపుంఙ్ సయెకాద్ ఎద్దద్. ");
INSERT INTO nit_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","అబ్రాహామ్ జవాబ్ ఇడ్‍సా, ఇద్ కరెయ్. పాపం కత్తద్ ప్రతి ఒక్కొద్ పాపుంఙ్ గడియక్ ఎర్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","అదుంఙి యేసుంద్, “ఇముంఙ్ కరెయ్ ఇడ్సాత్, పాప్ కలెకంద్ ఆరొకొంద్ పాపుంఙ్ బానిసా. ");
INSERT INTO nit_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","బానిస్ కుటుంబముత్ సోయ్త పార్తన అనెద్. గని పోరక్ ఎప్పుడి ఆ ఎల్లత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","పోరక్ సోయ్ కత్తె ఇముంఙ్ కరె సోయ్ ఎరాద్. ");
INSERT INTO nit_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","నీర్ అబ్రాహామ్నె కుటుంబతర్ ఇసా అనుంఙ్ ఒర్కియ్. ఎన ఇముంఙ్ అన్నె సందేస్ నచ్చెతిన్. అదుంఙ్‍ ఎతి అన్ ఆల్ఙెంఙ్ కిరవ్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","అన్ అన్నె బానతన ఓల్‍తదున్ ఇడ్‍సాత్. నీర్ ఇమ్మె బానతన వింతదునీ కల్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","“అబ్రాహామ్ అమ్మె బాంద్” ఇసా ఔర్ సమాదానం ఇడ్‍తెర్. అప్పుడ్ యేసు, నీర్ అబ్రమ్నె పొరకెరెరతె అబ్రాహామ్ కలెక పనికున్ కనీర్. ");
INSERT INTO nit_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","అన్ కలెకద్ దెయ్యంతన్న వింత సత్తెం ఇడ్డెకదీ! అదుంఙ్ వాలడ్ నీర్ అన్ అలుగెంఙ్ ఇసా ఓల్‍సాతిర్. అబ్రాహామ్ నిర్‍ లంఙ్ ఇదరెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","నిర్‍ ఇమ్మె బాంద్ కత్తెతి కల్‍సాతిర్ఇసా ఇంతెంద్. ఔర్, “అమ్ చినలి కలెంఙ్ జన్మిలెతరమ్ ఎరెమ్. అముంఙ్ దెయ్యం ఒక్కొందీ అమ్మె బాంద్ ఆమ్ అమ్మె పోరకేర్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","యేసుంద్ ఔరున్ ఇనంఙ్ ఇంతెంద్. అదుఙి దెయ్యం ఇమ్మె బాంద్ ఎద్దె అన్ దెయ్యం తన వత్తన్ ఇసా నంతనర్. అదుంఙ్‍ ఎత్తి నీర్ అన్ ప్రేమ్ కలెకర్. స్వతయ్ అన్ ఇత్తి వరెతన్. దెయ్యమి అన్ పన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","నీర్ అన్నె గొట్టికున్ వినెర్ అదుంఙ్ ఎతి అన్ ఇడ్డెక ఇముంఙ్ అర్తం ఎరే. ");
INSERT INTO nit_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","నీర్ బూత్ అంట్తంద్ లగ్తర్‍ ఎన్నిర్. అముదు ఇమ్మె బాంద్. ఇమ్మె బానె కొరికలున్ పూర కలెకద్ అముదు మొదల్ తన్నన్నెకద్. అముదు కరెయ్ అడ్‍గెకద్. అమ్నత్తి సత్తెం తోతెద్. పైల్లిన్ ముడెకద్ అమ్నె సబావ్. అదుంఙ్‍ ఎత్తి అముదు సిమ్కన వెలంఙ్ పైల్లిన్ ముడ్‍సాద్. అముదు పైల్లినె బాంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","అన్ సత్తెం ఇడ్డెకదుంఙ్ వాలడ్ నీర్ నమ్మెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","అన్ పాప్ కత్తన్ ఇసా ఇమ్మతి ఎరేనా ఇడ్డెంఙ్ సల్సతిర? అన్ సత్తెం ఇడ్‍సాత్‍ తా! అన్న తనుంఙ్ నమ్మెర్ ఇడుర్. ");
INSERT INTO nit_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","దెయ్యంన్నె సంతనం దెయ్యంన్నె గొట్టిక్ విసాద్. నీర్ దెయ్యంన్నె సంతనం ఎరెర్ అదుంఙ్ ఎత్తి అన్ ఇడ్‍తదున్ విన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","అదుంఙి యూదు “నీ సమరయ తని, ఇన్ బూత్ సుమ్‍తిన్ ఇసా అమ్ ఇన్నెకద్ కారె ఎరెదా?” ఇసా ఔర్ వెల్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","అపుడ్ యేసుంద్, “అన్ బూత్ సుమ్మెతిన్.” అన్‍ అన్నె బానున్ మన్ సియ్‍సాత్. గని నీర్ అన్ అవమనం కల్‍సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","అన్ అన్నె మాన్ ఎరెన్. గని అన్నె తిర్పు కొరెకద్ ఒక్కొద్ అన్సాద్. అముదు న్యాయం కలెకద్. ");
INSERT INTO nit_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ఇద్ కరెయ్ అన్నె బొదన్ వినెకంద్ అముదు ఎప్పుడి తిక్కేంద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ఇదున్ వినుత్ యూదూ జోరకత్న, “ఇన్ బూత్ సుమ్‍తిన్ ఇసా అముంఙ్ ఇండి కరిల్‍త్తిన్! అబ్రాహామ్ తిక్‍తెంద్. అనాయ్ ఎప్పుడి కబుర్లకెర్‍ నాయ్ తిక్‍త్తెర్. ఇమ్‌ద ఇన్నె బొదన్ వినెకంద్ తిక్‍తెంద్ ఇసాతీ. ");
INSERT INTO nit_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","నీ అమ్మె బాంద్‍ అబ్రాహాముంఙ్ ఎన ఎప్పుడి? అముదు తిక్‍తెంద్. ప్రవక్త కెర్‍నాయ్ తిక్‍త్తెర్. ఇన్నె మనుత్ నీ ఎన్ని విసాతి?” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","అదుఙి యేసుంద్, “అన్నెత్ అని పొగడ్‍త్తె ఆ పొగడెకద్నె అర్తం తోతెద్. అన్న పొగడెకద్ అన్నె బాంద్ అముదు ఇమ్మె దెయ్యమున్ నిరి మాన్ ఇసాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","అముదు ఇముంఙ్ ఒర్కి తోద్. గని అముదు అనుంఙ్ ఒర్కియ్. అముదు అనుంఙ్ ఒర్కి తోద్ ఇంతె, అన్‍నాయ్ నీర్ లంగి పైల్లిన్ ముడెకారన్ ఎరత్. గని అముదు అనుంఙ్ ఒర్కియ్. అమ్నె గొట్టిక్లత్తి అన్ అడుగ్తన్. ");
INSERT INTO nit_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ఇమ్మె బాంద్ అబ్రాహామ్ అన్నె గెట్టలున్ ఓలెంఙ్ సాలెన్ ఇసా ఒర్కిల్‍త వెంటని కుసీంఙ్ వతెంద్. అముదు ఓల్‍తెంద్. కుసీంఙ్ వతెంద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ఆ కారనుంఙ్ యూదూ, “ఇనుంఙ్ ఇంక్క యాబై సాల్కు నిండెతిన్ ఎన. గని నీ అబ్రాహామ్ మున్ ఓల్‍తివా?” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","యేసుంద్, “ఇద్ కరెయ్. అబ్రాహామ్ జన్మిలెంఙ్ పేలెయ్ అన్ అన్సాత్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ఇదున్ వింత్న ఔర్ అమ్నున్ దన్పెంఙ్ ఇసా గుండ్లు సుమ్‍త్తెర్. గని యేసుంద్ ఔరుంఙ్ కండ్కెర్సెట డాఙుత్న ఆ గుడిత్ కురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","అముదు సెసాననెఙ ఒక్కొ జన్మిత తన గుడ్డిన్ ఓల్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","అమ్నె సిసు అంనున్, “రబ్బీ! ఇమ్‌ద గుడ్డి లగీ జన్మవాతేద్‍ దే! ఎర్‍ పాప్ కతెంద్ ఇసార్? ఇమ్‌ద మరి ఇమ్నె బాంద్‍ అమ్మ యే?” ఇసా వేల్తొల్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","యేసుంద్, ఇమ్‌ద ఎక్కద్‍ ఇమ్నె బాంద్‍ అమ్మ ఎక్కద్ పాప్ కలెత్తెర్! దెయ్యంమ్నె సక్తి ఇమ్నున్ వాలడ్ మయమ్ ఎరెంఙ్ ఇసా గుడ్డింద్ జన్మ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","పొద్ ఉర్కెంఙ్ పేలె నేండ్‍ అన్ పన్కతనే కార్యమున్ కలెంఙ్. సింతె ఎరెంఙ్‍ కల్‍సా నంసాద్. అపుడుంఙ్ ఎరి పాని కలేర్. ");
INSERT INTO nit_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ఈ దున్యత్ అన్ అనపాగొల్ అన్ అదుంఙ్ వెలుంఙ్‍ నాన్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","అముదు ఇనంఙ్ ముడుత్న బూమి పొయ్ ఎవుర్‍ ఉస్తెంద్. ఆ ఉస్‍త సిక్లన్ గుడ్డినే కండ్లెంఙ్ దిట్‍తేద్. ");
INSERT INTO nit_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","అమ్నున్, “సెత్న, సిలొయం కుంటత్ ఓడ్!” ఇసా ఇంతెంద్. సిలొయం ఇనెకాద్నె అర్తం “పన్కతద్.” ఆ గుడ్డింద్ సెత్న తన్నె గేట్టలున్ ఓట్టెద్. అమ్నుంఙ్ నదుర్ వత్తె మలయుత్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","అపుడ్ మెరతర్ దవతర్, పేలె ఔర్ బిసెం వెలెకానున్ ఓల్‍తర్, “అత్తి ఉదుత్ వెల్‍నెద్‍ ఇమ్‌ది తా!” ఇన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","“ఇమ్ది” ఇసా కొన్సెం మంది, “ఇమ్ద ఎరెద్” ఇసా కొన్సెం మంది ఇంతెర్. అముదు తే అని ఎన్‍దున్‍ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ఔర్, ఇన్నె కండ్లు ఎనంఙ్ ఓల్సనండతి ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ఔరుంఙ్ అముదు, “యేసుంద్‍ ఇనెకద్‍ ఒక్కొద్ సిక్లా కత్న అన్నె కండ్లెంఙ్ దిటుత్ సిలొయం వన్తంఙ్ సెత్న ఓడ్ ఇసా అనుంఙ్ ఇడతెద్. అన్ ఓడుత్ వత్తతి సోయ్ ఓలెంఙ్ ఎదన్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ఔర్, “అముదు ఇండి ఎత్తి అన్సాద్?” ఇసా వెలుత్ ఓలెంఙ్ అముదు, “అనుంఙ్ ఒర్కి తోద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","పేలె గుడ్డి అనెకా ఆ మన్కకున్ ఔర్ పరుసిక్ వై తోడా సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","యేసుంద్ సిక్లాన్ దిటుత్ అమ్నె కడ్లున్ సోయ్‍ కత్త దినమ్ ఆలపుసేక దినం. ");
INSERT INTO nit_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ఇనుంఙ్ ఎనంఙ్ నదుర్ వాత్న ఇడ్‍ ఇసా పరుసిక్ నాయ్ అమ్నున్ వేల్తొల్తెంద్. అముదు, “యేసుంద్ అన్నె కడ్లత్తి సిక్లన్ దిట్తెంద్. అన్ సెత్ ఒట్టాన్ అన్ ఓలెంఙ్ ఎద్దాన్” ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ఇమ్‌ద ఆలపుసేక దినమున్ పడిపెద్ అదుంఙ్ ఎత్తి ఇమ్ద దెయ్యం తన వరెతెంద్ అనాయ్ పరుసిక్ తన కొన్సెం మంది ఇంతెర్. మల్ల కొన్సెం మంది, “ఇమ్ద పాప్‍ కత్తంద్! ఎద్దె ఇంటా సమత్కల్ ఎనంఙ్ కలెంఙ్ సాల్సంద్?” ఇంతెర్. ఇనంఙ్ ఔరున్ లోపా బెదం వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","అదుంఙ్ వాలడ్ ఔర్ గుడ్డి అనెకనున్ ఇన్నె కండ్లున్ సోయ్ కతెంద్ ‍ తా! అమ్నుంఙ్ వాలడ్‍ నీ తనెవిసాతీ? ఇసా వెల్‍తెర్. “అముదు ఒక్కొ కబుర్లక్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ఆ గుడ్డింద్ సోయ్ ఎద్దెంద్ ఇసా యూదు అదికారి పేలె నమ్మెతెర్. గని అదుంఙ్ ఎత్తి అమ్నె అమ్మ బనున్ కుగ్‍గత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","గుడ్డియ్ జన్మిల్తెంద్ ఇసా నీర్ ఇడ్డెకా పోరక్ ఇమ్‌దియా? ఇమ్‌ది ఎరతె ఇండి ఎనంఙ్ ఓల్‍సంద్! ఇసా ఔరున్ వేల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","అదుంఙ్ అవ్రి బాంద్ అమ్మ, “ఇమ్ది అమ్మె కీకె. ఇమ్‌ద గుడ్డియ్ జన్మిల్తెంద్ ఇసా అంముంఙ్ ఒర్కీ.” ");
INSERT INTO nit_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","తే పంఙి ఇమ్‍దు ఎనంఙ్ ఓల్సదొ అముంఙ్ ఒర్కితొద్. ఇమ్నె కన్డున్ సోయ్ కత్తంద్ ఎదొ అముంఙ్ ఒర్కితొద్. ఇంతె ఇమ్నున్వై వత్తిన్. ఇమ్నునీ వేల్తొల్తెంద్. తాన్నె బదోల్ అముదు ఇడ్డెంఙ్ సల్సంద్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ఇమ్‌దీ అమ్మబాంద్ యూదులుగ్ అర్సుత్ అనంఙ్ ఇడ్తెర్ తనుంఙ్ ఇంతే యూదులుగ్ అపుడుంఙ్ ఏరెనా అమ్నుఙ్ క్రీస్తుంద్ ఇసా నాంతె ఓరున్ తన్నే బక్తి సావ్డి తనట్ పుస్సెంఙ్ గిసా నిర్నయం సుమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","అదుంఙ్ ఎత్తి ఔరే అమ్మబానే అముదు వైయ్యుంఙ్ వత్తద్, అమ్నుగ్నీ వెలుత్ ఓలుర్, ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","అదుని అపుడితి గుడ్డిలంఙ్ అనెకా మన్కుకున్ నిమ్మాట్ కుగ్తెద్. “నీ దెయ్యమున్ మాన్ సీయ్. ఈ మన్కక్ పాపులకెర్ ఇసా అముంఙ్ ఒర్కి” ఇసా అమ్నడ్ ఇన్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","అదుఙి అమునున్, “అమ్నున్ పాపులకెరొ తోదొ అనుంఙ్ తనెద్ ఒర్కి? తే అనుంఙ్ ఒక్కొదీ ఒర్కి. అన్ గుడ్డిలంఙ్ అన్దునిసా, ఇన్డీతే ఓల్సతీతా” ఇన్ తాన్. ");
INSERT INTO nit_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","అదుఙి అమునున్, “అసల్ అముదు ఇనుఙ్ తనెద్ ఇదర్తెద్? ఇన్నే ఏనఙ్ సోయ్ కతెంద్?” ఇసా మల్ల నెల్ తొల్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","అదుఙి అమునున్, “ఇదుంఙ్ సాజెని ఇడ్తన్. నీర్ వినెతిర్. పెనా తానుంఙ్ వినెంఙ్ ఇసాతిర్? నిర్నయ్ అన్నె సిసు ఎరెఙ్ ఇసాతిరా?” ఇసా ఔరడ్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","అదుఙి ఔర్ “నివీ అమ్నే సిసు నీ. అమ్ మోసేనె సిసులం. ");
INSERT INTO nit_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","దెయ్యం మోసేన్ ముడెకద్ అండద్ ఇసా ఒర్కి గని ఇమ్‌దు మన్కక్ నెత్ గొట్టిన్తే అసాల్ ఇమ్‌దు ఎన్తెత్తట్ వత్తెదో అముంఙ్ ఒర్కి తోద్” ఇసా అమ్నున్ గుల్ దటిప్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","తే అముదు, “అమ్నున్ ఎన్తే తనట్ వత్తెదో దెకుల్ ఇముంఙ్ ఒర్కితొసేటా కమాల్ అండద్.” ఎద్ది తనే వెద్దెనా అన్నే కన్లుల్ కన్కేరేద్‍ దెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","దెయ్యమ్నె పాపులె పార్తనన్ వినెద్ ఇసా అముంఙ్ ఒర్కి. దెయ్యమ్నెత్ బక్తి సుమ్ముత్ అమ్నె పసనున్ ఇదర్తే అమ్నుఙ్ వెల్ తాదున్ సియ్యసాద్ అముదు విసద్. ");
INSERT INTO nit_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","గుడ్డిలంఙ్ పుట్తె మన్కనే కండ్లున్ ఎరేనా ఓలిప్ తెతి లోకం గడిల్తతనట్ ఇండి దూక్ ఇటవులున్ ఏరి వింతిరా. ");
INSERT INTO nit_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ఇమ్‌దు దెయ్యం మెరా తనట్ వర్సె టంన్డె ఇన్టా ఇదారెతన్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","అదుఙి అముదు, “పాప్ లడ్ పుటుత్ పెర్గతని, నివ్ అముంఙ్ ఇడ్సతివా?” ఇసా ఇడ్తె తమ్మె సౌడీత్ తనట్ పుస్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","పరిసయ్యులు సావ్డి తన అమ్నున్ పుస్సెతెరిసా యేసుంద్ విన్దేద్ అముదు అమ్నున్ కలయుత్, “నివ్ మన్కనె పోరక్ నత్తి విస్వాస్ ఇడ్సనడ్డతివా?” ఇసా అముదుంఙ్ వెల్తొల్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","అదుఙి అముదు, “మాల్క, అనఙ్ విస్వాస్ ఇండెఙ్ అమ్నున్ ఎన్దొ అనుంఙ్ ఇడ్” ఇన్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","యేసుంద్, “ఇన్డీ నివ్ అమ్నున్ ఓల్సన్డతీ, ఇన్నడ్ ముడ్సనండత్ అని అముదు” ఇన్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ఇన్డీ అముదు, “అన్ నమ్సనడ్డ్ ప్రబు” ఇసా అమ్నున్ మొక్నెంద్ ");
INSERT INTO nit_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","అపుడ్ యేసు, “ఓల్సెటర్ దెకుల్ ఓలెంఙ్. ఓలెకంద్ గుడ్డి ఎరెఙ్‍, ఇసా న్యాయ్ కలెంఙ్ ఇద్ దున్యంఙ్ వత్తన్” ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","అమ్నుఙ్ నత్తి అనెకా పరుసిక్ లంతి కొన్సెమ్ మంది ఇద్ గొట్టి విత్నా, “ఇన్తే అమ్ దెకుల్ గుడ్డీక్లఙ్?” ఇసా ఇన్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","అదుఙి యేసు, “నీర్ గుడ్డీకెద్దె నీర్ పాప్ అన్సెటద్. గని ‘అమ్ ఓలెఙ్ సల్సతుమ్’ ఇసా నీర్ ఇడ్సనం డాతిర్ అదుఙి ఇముంఙ్ పప్ ఇల్లుత్ అడ్డద్” ఇసా ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","యేసుంద్, “ఇద్ కరెయ్. గొర్రెలె కొడ్కత బొయ్దనాడ్ సెసెటా గొడ పొలడ్‍ సొకుత్ సెరెకద్ డొంఙ్‍, కలెకద్.” ");
INSERT INTO nit_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","బొయ్దనాడ్ పవ్ చెరెకద్ ఆ గొర్రె మేపేకా గయ్‍కి. ");
INSERT INTO nit_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","పవుత్ కయ్యెకద్ అదుంఙ్ సటీ కవడున్ పుస్‍సాద్. గొర్రె అమ్నె లెగున్ ఒర్కిల్సా. ఆ గొర్రె అన్నెవి. ఆగొర్రెలున్ పేర్ సుముత్ కూగుత్ అదవున్ వకా సుముత్ కొసాంద్. ");
INSERT INTO nit_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","తన్నె గొర్రెలున్ వకా కూగుత్న అముదు ముండట్ అడ్గసాద్. అదవుంఙ్ అమ్నె లెంఙ్ ఒర్కియ్ అదుంఙ్ ఎత్తి అదా అమ్నున్ వెంటా సెసా. ");
INSERT INTO nit_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","అదా కొత్తన్ వెంటా చెరేవ్. కొత్తనె లెంగున్ ఒర్కిలెంఙ్ సాలే. అదుంఙ్ ఎత్తి కురియుత్ తుల్‍సాహ. ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","యేసుంద్ ఈ ఉదహరనడ్ ఇడతెద్. గని ఔరుంఙ్ అముదు తనెన్ ఇడ్‍సాదొ కరిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","అదుంఙ్ ఎత్తి యేసుంద్ పేన ఇనంఙ్ ఇడెంఙ్ మోదల్లిటెద్. కరెయ్ అని గొర్రెలె బొయ్దనాడ్. ");
INSERT INTO nit_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","అనుంఙ్ ఎన ముండట్ వత్తర్ డొంఙ్‍, డొంఙ్‍కలెకరి. అదుంఙ్ ఎత్తి గొర్రె ఔరె లెంఙ్ వినెతే. ");
INSERT INTO nit_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","అని బొయ్దనాడ్. అన్ వాలడ్ వరెకరి బత్కదర్. ఔర్ సొయడ్ లోప వర్సా చెస్సా అంసార్. ఆ గొర్రెలుంఙ్ నిగుర్ జాగ కన్కెర్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","డొంఙ కలెంఙ్‍, అల్ఙెంఙ్‍, కర్బకలెంఙ్ వర్సాద్. అన్ ఔరుంఙ్ కొత్త జీవితం సియెంఙ్ ఇసా వత్తన్. ఆ కొత్త పానం ఎపుడి అనెకద్. ");
INSERT INTO nit_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“ఆ సోయ్త గయ్‍కినాన్. అని గొర్రెలుంఙ్ సటీ తన్నె పానమున్ సియ్సాద్ నయ్ తయార్ అన్సాద్.” ");
INSERT INTO nit_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","కుల్కడుంఙ్ సటీ పనీ కలెకద్ గయ్‍కి ఎరెంద్. గొర్రె అమ్నెవ్ ఎరేవ్. అదుంఙ్ ఎత్తి అడవి రజే వరేకవున్ ఓలుత్న గోర్రేలున్ సయుత్ తుల్సాద్. అపుడ్ లండిగక్ అత్తె వత్న మందన్ పొయ్ ఉర్కుత్ అదవున్ నేరజడ్ కల్‍సాహ. ");
INSERT INTO nit_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","అముదు కుల్కడ్ పనింఙ్ వత్తద్ అదుంఙ్ ఎత్తి గొర్రెలున్ సోయ్‍ఓలేద్. ");
INSERT INTO nit_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","అన్ సోయ్త గయ్‍కినన్. అన్నె బానుంఙ్ అన్ బదోల్, అనుంఙ్ అన్నే బానుంఙ్ బదోల్ ఒర్కి. అనాయ్ అనుంఙ్ అన్నె గొర్రెలున్ బదోల్, అన్నె గొర్రెలుంఙ్ అన్ బదోల్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","అన్నె తాకున్ అన్ ఒర్కి అనుంఙ్ అన్నె తాక్ ఒర్కి, అన్నె గొర్రెలుంఙ్ సటీ అన్ పానం సియత్. ");
INSERT INTO nit_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ఈ మందత్ కలయ్‍సెటా గొర్రె కొన్ని అంసాహ. అదనయ్‍ కొడ్కత్ అన్సా. అద్‍వ్లునయ్ అని తోడా వరత్ అదా అన్నె గొట్టిన్ విసాహ. అప్పుడ్ సిమ్కన ఒక్కొది మంద లఙ్ అన్సాహ. ఒక్కొది ఒక్కొద్ గయ్‍కి అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","అన్ అన్నె పానమున్ సియెంఙ్ తయార్ అన్సాత్. అదున్ పెన సుమెంఙ్ సక్తితనన్. అదుంఙ్ ఏత్తి అన్నె బాంద్ అంన్ ప్రేమ్ కల్సద్. ");
INSERT INTO nit_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","అన్నె పానమున్ అనంతన ఎరి పుసెంఙ్ సాలెర్. అని సొత అన్నె పానమున్ సియ్‍సాత్. అన్నెపానం సియెకదుంఙ్‍, పెన వపస్ సుమ్మెకదుంఙ్ అనుంఙ్ అదికార్ అన్సాద్. అద్ అన్నె బానె ఆగ్య. ");
INSERT INTO nit_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ఈ గొట్టిక్ వాలడ్ యూదు లోప నెరజడ్ ఎదేర్. ");
INSERT INTO nit_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","గుల్ మంది, “బూత్ సుముత్ అముదు గల్ పిసాక్ ఎత్న. అద్నె గొట్టికున్ తనుంఙ్ వినెకద్?” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","గని మల్ల కొన్సెం మంది, “అదా బూత్ సుమ్‍తనే గొట్టిక్ ఎరేవ్. దయ్యం గుడింఙ్ ఎనంఙ్ నదుర్ సియెంఙ్ సాలద్?” ఇసా ఇంతెర్ ");
INSERT INTO nit_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","గని, ఇండి ఎన నీర్ వెల్‍తె దెయ్యం నీర్ వెల్‍తదున్ సియ్‍సాద్ ఇసా అనుంఙ్ ఒర్కిఇసా ఇంతెంద్. ఆ మల్ల యెరూసలెముత్ ప్రతిస్ట పండ్గ వత్తిన్. అద్దు టాండి కాలం ");
INSERT INTO nit_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","అప్పుడ్ యేసుంద్, గుడిత్ జగత్ అన్నెక సొలొమోన్ సయ్వన్ అడ్గసా అన్నెంఙ్ ");
INSERT INTO nit_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","యూదు అమ్నున్ తిర్గొర ఎత్న అంనడ్. ఎన్నిగెడ్ల అమున్ ఇనంఙ్ అన్మన్ ఇడ్సతి? నీ క్రీస్తుని వెరతె అమ్నె ఆత్మనాడ్ సోయ్ ముడ్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","యేసుంద్ అమ్నున్ ఇనంఙ్ ఇంతేంద్, అన్ ఇమున్ ఇడ్డెన్ గని నీర్ నమ్మెర్. అన్నె బానె పేరాడ్ అన్ ఇదార్స నాండత్ పనికి అన్నే బదోల్ ఇడ్సా. ");
INSERT INTO nit_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ఇంతె నీర్ అన్నె గొర్రె ఎరెర్ అదుంఙ్ ఎత్తి నీర్ బరొస ఇడెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","అన్నె గొర్రె అన్నె లెంఙ్ విసా, ఇసా అనుంఙ్ ఒర్కి, అదా అన్ వెంటా వర్సా, ");
INSERT INTO nit_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","అని అదవుంఙ్ పూర పానం సియ్సాత్ అదుఙి అదా ఎప్పుడి కరాబ్ ఎరే. అదవున్ ఎరి అన్నె కెయ్ తానా కొసెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","అదవున్ అనుంఙ్ సియ్తా అన్నె బాంద్ సదరుంఙ్ ఎనా గొప్పవాడు అదుఙి అన్నె బాంద్ కెయ్యు తానా ఎరి కొసెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","అన్, అన్నె తాక్ ఒక్కొంది. ");
INSERT INTO nit_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","అప్పుడు యూదు అమ్నున్ లగాపెంఙ్ గుండ్లు పెత్తేర్. ");
INSERT INTO nit_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","యేసుంద్ వెన్కత్ బాంద్ పేనహ ఇనంఙ్ ఇడ్తెంద్. ఆబార్‍ తన పరిసుద్ద ఆత్మ ఒక్కొ పరెవనె రూపాడ్ వత్న అమ్నున్ పొయ్ డిగేకదున్ ఓల్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","అందుఙి యూదు, “నీ మన్కక్‍ నీ ఎత్న ఇన్నెత్ నీ దెయ్యంనన్ ఇసాతి. విరొద్ కతదుఙ్ ఇన్ గుడ్లడ్ లగప్తన్ సొయ్త పనిక్ కతదుంఙ్ తొద్” గని అమ్నడ్ ఇంతెర్ ");
INSERT INTO nit_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","యేసు ఔరుంన్ సామదనం ఇడ్తెతి ఇనంఙ్ ఇంతెంద్ నీర్ దెయ్యములిసా అన్ ఇంతన్ ఇసా ఇమ్మె నియమ్ సాస్త్రముత్ వాయుత్ తోతెదా? ");
INSERT INTO nit_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","లేకనముత్ ఎరె. దెయ్యమ్నె వాక్యమ్ ఎరుంఙ్ వత్తెవొ, అదవి దెయ్య లిసా కుగ్‍తె. ");
INSERT INTO nit_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","బాంద్ పవిత్ర ఈ దున్యత పన్కతద్ అన్ దెయ్యమ్నె పోరక్ ఇసా ఇంతె నీ దుసన్ కాల్‍సాతి ఇసా నీర్ తనుంఙ్ ఇసాతిర్ ");
INSERT INTO nit_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","అన్ అన్నె బానే పనిక్ కల్కేసెట అండ్డె అన్ నమ్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","అదుంఙ్ ఎత్తి, అన్ అన్నె బనె పనికున్ ఓల్‍సా ఆండె, నీర్ అన్ నంసెటండె, బానత్తి అన్ బాంద్ అంనత్తి అన్సాతుమ్ ఇసా నీర్ ఒర్కిలుత్ అర్తం కలెంఙ్ అపనికున్ నముర్. ");
INSERT INTO nit_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ఔర్ మల్ల అమ్నున్ సుమతుమ్ ఇంత్తిర్ గని అముదు ఔరె కెయుతన సుకడిల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","యేసుంద్మల్ల యోర్దన్ నాదిఙ్ అలపకంఙ్ సెత్న అత్తిని అన్సాద్. యోహాన్ పేలె బాప్తిస్మ సియెకా జాగ ఇద్ది. ");
INSERT INTO nit_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","గుల్ మంది అమ్నున్‍ వై వాతెర్. యోహానున్ ఎదవి సమత్కల్ కలెతెంద్ గాని ఇమ్నున్ బదొల్ అముదు ఇడ్త బదొల్ కరెయ్ ఇసా నంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ఆత్తి పెరెత్ మంది యేసునున్ నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","బేతనియ ఉరద్ లాజరుంఙ్ దుక్క వతిన్. మరియ, మార్తనయ్‍ తోర్దాసిక్ ఆ ఊరున్ అనెకర్. ");
INSERT INTO nit_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ఒక్కపుడ్ ప్రబునె గేటలంతి అత్తరున్ నూనె దీటుత్ అన్నె తల్లత తిరడ్ ఉసుమ్‍తిన్ ఈ మరియలి! దుక్కమడ్ అనెకా లాజర్ అని దాదక్. ");
INSERT INTO nit_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ఈ అక్క తోర్దాసిక్, “ప్రబు! నీ ప్రేమ కలెకా లాజర్ దుక్కమడ్ అన్సాద్” ఇనెక కబుర్ యేసునుంఙ్ పన్కతెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","యేసుంద్, విత్న, “ఈ దుక్కం ఆల్ఙెంఙ్ వరెతిన్. ఇదుంఙ్ వాలడ్ దెయ్యమ్నె పోరకున్ మాన్ రొబడ్నేతి దెయ్యమ్నె మహిమంఙ్ సటీని వత్తిన్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","మార్తకున్, అద్నే తోర్దా లాజరున్ యేసు ప్రేమ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","లాజర్నే దుక్కం సుమ్మెంఙ్ ఇసా యేసు వింత్ గీన అముదు అనెక జాగాత్ ఇంకా ఇందీ దీనా అడ్డెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","అదుంఙ్ వేనుకత్ తన్నే సిసులున్ వెంట, “నేండ్ పేన యూదియంఙ్ సెన్నర్ చేండ్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","అమ్నే సిసు అమ్నున్ వెంట, “గురు, ఇదుంఙ్ పేలెని యూదు ఇన్ గుండ్లాడ్ కుడ్కెంఙ్ కోసీద్ కత్తెర్ తోద, అత్తినపేన సెసతివ?” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","అదుంఙ్ ఎతి యేసుంద్ జవాబ్ సీసా, “తొల్లినీ పన్నెండు గంటలుంఙ్ వెలుంఙ్ అనేద? ఒక్కొంద్ తొల్లినిత వేల అడుగ్తె కటిన్ ఎరెద్. తానుంఙ్ ఇంతె అముదు వెలుహుత్ సిమ్కన ఓల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","తే ఒక్కొంద్ సీంతె అడుగ్తె అమ్నత్తి వెలుంఙ్ తొతేద్ అదుంఙ్ ఎతి పరిసాన్ ఎర్సాంద్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","యేసుంద్ ఈ సంగతిక్ ఇడ్త వెన్కత్ ఔరడ్ ఇనంఙ్ ఇంతెంద్, “నెడే దొస్తక్ లాజరు మంతెంద్. అమ్నున్ మంఙ్ సా నడ్డద్ సుల్పెంఙ్ సెసనండతున్.” ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","అదుంఙ్ ఎతి సిసు అమ్నాడ్, “ప్రబు, అముదు మంఙ్ స ననేగ సోయ్ ఏర్సాంద్” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","యేసుంద్ అమ్నె తికెకాదున్ వాలడ్ ముట్టెంద్ గని ఔర్ మంఙ్ కత్తి అలపుసెంఙ్ ఎరద్ ఇసా అదున్ వాలడ్ అముదు ముడ్సానన్సాద్ ఇస ఇసాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","అపుడ్ యేసుంద్ ఔరడ్ ఇంతెంద్, “లాజర్ తిగ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ఇంతె అన్ అత్తి అన్సెటదుంఙ్ వాలడ్ కుసినడ్ అండత్. ఇద్ ఇముంఙ్ సటీని. ఇముంఙ్ బరొస తొద్ ఇసా. అమ్నున్ మేరం సెన్నార్ చేండ్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","దిదుమ ఇనెకాద్ మరొకో పేర్ తాద్ తోమక్, “వార్ గురున్ వెంట నేండ్ గీన తిక్కెంఙ్ సెన్నర్ చెండ్” ఇసా తముంఙ్ వెంట సిసులున్ గీన ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","యేసుంద్ అత్తి గదియుత్, అపుడుగిమ నానలీ దినాలుంఙ్ లంఙ్ లాజరు సమాదిత్ తప్నె ఎద్దిన్ ఇసా ఒర్కిల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","బేతనియ యెరూసలేముత్ మేరమి. ఇంతెతి మూది కిలో మిటార్ దావ్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","గుల్ దాదక్ యూదు మార్తకున్, మరియలున్ అదాలే సొప్తిరసికున్ గొట్టిన్ నాడిపేంఙ్ ఇసా వత్, అత్తి అన్సార్, ");
INSERT INTO nit_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","అపుడ్ మార్తక్, యేసుంద్ వర్సామద్ ఇసా వింత్ అమ్నున్ కాలయెంఙ్ ఎరెంఙ్ సెద్దిన్ గని మరియ ఎల్లతి అండిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","అపుడ్ మార్తక్ యేసునాడ్, మాల్క, నీవ్‍ ఇత్తి అనేంఙ్ అండే, నా దాదక్ తిక్సెటంద్, ");
INSERT INTO nit_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ఇండిఎన్న నీర్ వెల్‍తె దెయ్యం నీర్ వెల్‍తదున్ సియ్‍సాద్ ఇసా అనుంఙ్ ఒర్కిఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","యేసుంద్, “ఇన్నె దాదక్ పెన బత్కుత్ వర్సాద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","మార్తహ, “ఆక్రి దినముంఙ్ ఇనెంఙ్ మల్ల తిక్ తార్ బత్కసార్ దినముంఙ్ అముదు తిక్క తానా తిక్ తార్ బత్కసార్ ఇసా అనుంఙ్ ఒర్కియ్” ఇసా సమాదానం ఇడ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","యేసుంద్ ఇనంఙ్ ఇంతెంద్ తిక్ తార్ బత్కసార్ సాద్ అని. అన్ నమ్తంద్ తిక్‍తెనా పానం ఎద్దర్. ");
INSERT INTO nit_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","బత్కెకర్ అన్ నంతె ఎప్పుడి తికెర్. ఇదున్ నీ నమ్సతివా? ఇసా వేలుత్ ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ఆద్, “నమ్సాత్ ప్రబు! నీ క్రీస్తుద్ ఇసా, ఈ దున్యంఙ్ వత్త దెయ్యంమ్నె పోరక్నివిసా నంసాత్” ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ఇనఙ్ ఇంత వెన్కత్ మర్త ఎలంఙ్ సెత్న తన్నె తోర్దా మరియలున్ పకంఙ్ కూగుత్న, అదున్, కరపెకద్ వతెంద్. ఇనుంఙ్ సటీ వెలుత్ ఓల్సాద్ ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","మల్ల ఇదున్ విత్న వెంటాయ్ అమ్నున్వై సెదిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","యేసుంద్ ఇంకా ఊలెంఙ్ వరెతెంద్. మార్త కలయ్త జాగతి మరియక్ అత్తిని అండాంద్ ");
INSERT INTO nit_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","మరియ నాడ్ ఎల్లత్ అంత్ అదున్ ఇదార్సా యూదు అద్ జాలది సులుత్ వాక సేరెకదున్ ఓలుత్ అదున్ వెంట సెద్దెర్. అద్ తప్నె వై అర్రెంఙ్ సెద్దిన్ ఇసా ఔర్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","అప్పుడు మరియ యేసుంద్ అనెక జాగంఙ్ సెత్, అమునున్ ఓలుత్ అమనె గేట్టమొకుత్ ప్రబు, నివితి అనెంఙ్ అండే అనె దాదక్ తిక్సెటద్ ఇన్తిన్ ");
INSERT INTO nit_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","అద్ అరెకద్, అదున్‍వ్వెట వెంట్టవత యూదు గిన అరెకద్ యేసుంద్ ఓల్తపుడ్ అమ్నె పానం దక్‍కింతిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","అమ్నున్ ఎత్తి సమది కత్తిర్? ఇసా యేసుంద్ వెల్‍తెంద్. “వత్ ఓల్ ప్రబు!” ఇసా ఔర్ సామదనం ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","యేసుంద్ ఆర్రెకాద్. ");
INSERT INTO nit_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","అప్పుడ్ యూదు, “యేసుంద్ అమ్నున్ ఎత్తె ప్రేమ్‍ కల్సాదొ ఓలుర్!” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","గని కొన్సెం మంది, “గుడింఙ్ కడ్ల సియ్‍తద్ ఇమ్‌ది, తిక్ సెటా కలెంఙ్ సాలెదా?” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","యేసుక్నె మన్నుత్ నారాజ్ మెలగ్‍త్తిన్. అముదు తప్నె మెరా సెద్దెంద్. ఆ తప్నె ఒక్కొ కన్లంఙ్ అన్సాద్. ఒక్కొ గుండ్‍ అత్తి గెతుత్ అన్సాద్. అత్తిగి యేసుంద్ సెద్దెంద్ ");
INSERT INTO nit_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“యేసుంద్ ఆ గుండున్ పుసుర్!” ఇసా ఇంతెంద్ త్తిక్తనె తోర్దా మార్తక్, “గని ప్రబు! అమ్నె సెత్త నాలొల్ ఎద్దిన్. ఇండ్డి అద్ కప్ వర్సాదేర” ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","అప్పుడ్ యేసుంద్, “నమ్తె దెయ్యమ్నె మహిమ కలెకద్ ఓలతి ఇసా అన్ ఇడ్డెతన?” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ఔర్ ఆ గుండున్ పుస్తెర్. యేసుంద్ పొయ్ ఓలుత్న, “బా నీ అన్నె గొట్టి వింతదుంఙ్ దన్యివద్ ఇడ్‍సాత. ");
INSERT INTO nit_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","అన్నె గొట్టికున్ ఎపుడి విసాత్తి ఇసా అనుంఙ్ ఒర్కియ్. నీ అన్న పన్కతెతి ఇవ్రు నమ్మెంఙ్ ఇసా, ఇవ్రుంఙ్ అర్తం ఎరెంఙ్ ఇసా ఇత్తి ఇలుత్ అనెకరుంఙ్ సొయుంఙ్ సటీ ఇనంఙ్ ఇసాత్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","అముదు ఈ గొట్టిన్ ఇడ్త వెన్కత్ దండిలేంఙడ్ అద్ వపొయుత్, “లాజరు, వాక వా!” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","అపుడ్ తిక్తంద్ కేయ్యు గేట్ట మరనా జుఙ్ఙెన్ గుడపుత్ అనేగయ్ వకా వతెంద్. అమ్నె మొకముత్ ఒక్కొ జుఙ్ఙెన్ సుట్టుత్ అండద్. అపుడ్ యేసుంద్ అవ్రడ్, “అమ్నె కట్తవున్ ఉడ్పుత్, అమ్నున్ సెరెంద్ ఇడుర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","అపుడ్ మరియన్ మేర వత్ యూదు లత్తి గుల్ మంది యేసుంద్ ఇదర్తదున్ ఓలుత్ అమ్నున్ నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","గని, అవ్రత్తి కొన్సెం మంది సేత్ యేసుంద్ ఇదర్త పనికున్ పరుసిక్ లుంఙ్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","అపుడ్ దండి దెయ్యలకెర్, పరుసిక్, దడ్డి సబన్ మిరప్తెర్, నేండ్ తగన్నార్? ఈ మన్కక్ ఎన్నిగొ సమత్కల్ ఇదర్సానెంద్, ");
INSERT INTO nit_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","నేండ్ ఇమ్నున్ ఇనాయ్ సయ్తమ్ ఇంతె, సిమ్కనయ్ ఇమ్నున్ నమ్సార్. రోమియు దెసం మంది వత్ నేండె మందిరున్ అని నెడే రజ్జెమున్, పూర తోడసెసార్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","తే, ఔరడ్ ఒక్కొంద్, ఆ సాల్ దండి దెయ్యలకెర్లాఙ్ అండా కయప అవ్రాడ్, “ఇముంఙ్ తనేది ఒర్కితొద్. ");
INSERT INTO nit_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","నేండె జాతి సిమ్కన నాస్ ఎరెంఙ్ తోద్ ఇసా ఇంతె ఒక్కొ మన్కక్ మందిఙ్ సటీ తిక్కెకాద్ ఇముంఙ్ లాబం ఇనేకాద్ నీర్ అర్తం కల్సాతొతెర్?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","అముదు తన్నెత్ తనీ ఇనంఙ్ ఇడ్డెతెంద్ గానీ ఆ సాల్ దండి దెయ్యలక్‍ లంఙ్ అండంద్ అదుంఙ్ ఎత్తి, దెసం మంది సటీ యేసుంద్ తిక్కెంఙ్ ఇసా అముదు ఇనంఙ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","మల్ల ఆమ్దు జాతింఙ్ సటీ నీ తోద్ గా, మరొక్కొ మారొకో జగలెంఙ్ నెరయ్తర్ దెయ్యమ్నె మందిఙ్ ఒక్కొత్తిని మిరయెంఙ్ ఇసా యేసుంద్ తిక్కెంఙ్ ఇసా అముదు ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","అదుంఙ్ ఎత్తి, ఈ దినం తన యేసున్ ఇనంఙ్ అన్గెకాద్ ఇసా ఔర్ విచార్ కల్సా వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","అదుంఙ్ ఎతి యేసుంద్ అత్తరనా యూదులంతి తిర్గుసెటా, అత్తరనా సేత్ అరన్య ప్రాతం మేర అనెక ఎప్సాయిము ఇనెక ఊర్తన తన్నె సిసులున్ వెంట కలయుత్ అండెంద్. ");
INSERT INTO nit_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","యూదులె పస్క పాండ్గు మేర గదితిన్. గుల్ మంది మన్కకెర్ తమ్మెత్ తమి తమ్మె కయ్‍దనె పరిసుద్ద కలెకద్ పాండ్గున్ పేలెని ఉల్ తాన యెరూసలేముంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ఔర్ యేసునుంఙ్ సటీ ఓల్సా నన్సార్. దెయ్యమ్నె గుడిత్ ఇల్లుత్, ఒక్కొనెత్ ఒక్కొంద్ ముడ్సనన్సార్, “నీర్ తనెవిసాతిర్? అముదు పాడ్గున్ వరేదా?” ");
INSERT INTO nit_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","యేసుంద్ ఎత్తి అంసా ఇసా ఇముంఙ్ ఎరుంఙ్ ఎనా ఒర్కిఎరతె, తమ్ అమ్నున్ సుమ్మెంఙ్ సటీ, ఔరుంఙ్ ఒర్కి సియెంఙ్ ఇసా దండి దెయ్యలకుంఙ్‍, పరుసికుంఙ్, ఆగ్య కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","పస్కంఙ్ అర్ దిన ముండట్ యేసుంద్ బేతనియ సియ్ సా వత్దేద్. తిక్త లాజరున్ యేసుంద్ మల్ల బత్కిప్సాంద్ ఊర్ ఇద్దీ. ");
INSERT INTO nit_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","అత్తీ అముదు సాటీ తినెకద్ తయార్ కతెంద్. మార్తక్‍ పైయ్సన్సాద్. యేసునడ్ తినెంఙ్ బల్ల ఉద్దెకద్ ఔరడ్ లాజర్ దెకుల్ ఒక్కొంద్. ");
INSERT INTO nit_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","అపుడ్ మరియ ఆక్రిన్ వేకమ్ అనెకా కిమ్మతద్ జటామాసి ఇనెక సెట్లతన పుస్త అత్తర్‍ నునెన్‍ యేసునే గెట్టాలెంఙ్‍ వగుత్‍ తన్నేతల్త తిల్లున్ ఉసుమ్‍తిన్ ఎల్లసిమ్మనా అద్ అత్తర్ నూనె దీటుత్ కంపాడ్ నిండ్పతిన్. ");
INSERT INTO nit_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","అమ్నున్ సుముత్ సియెంఙ్, సిసులత్తి ఒక్కొద్ అముదు ఇస్కరియోత్ యూద, ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","ఇద్ “అత్తరున్ ముదీ నుల్లా దెనారలుంఙ్ విరెకద్ ఇరియ్యెకద్ గరీబులుఙ్ సియ్యెంఙ్ పజే తా?” ఇన్తెంద్ ");
INSERT INTO nit_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","అమునున్ గరీబులుఙ్ లత్తి కార్జి అండ్డద్ ఇలెంఙ్ ఇనెతన్. అముదు డొగ్గా. అమ్నత్తీ అనెకా పైసెలున్ సంచిలోప కొన్సెమ్ పైసే తన్నె సొతఙ్ సటీ సుమ్సనెకద్ ఏద్. ");
INSERT INTO nit_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","యేసుంద్, “ఇదున్ ఇనంఙ్ ఇదరెంఙ్ ఇడుర్, అన్నె సమదీ రోజుఙ్ అముదు తయార్ కత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","గరిబ్ ఎప్పుడి ఇమ్మె వెంటని అన్సద్, గని అన్ ఎప్పుడి ఇమ్నెవెంటాని అన్ అనెన్ తా” ఇన్ంతెద్. ");
INSERT INTO nit_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","అపుడ్ దన్డీ యూదులె మంది వత్ యేసుంద్ అత్తి అండంద్ ఇసా ఒర్కిలుత్, యేసున్ సటీ తోద్‍గ తిక్తతనట్ మల్ల బత్కిప్సాంద్ లాజరున్ నయ్ ఓలెంఙ్ ఇసా అత్తీని వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","లాజరున్ సుత్ముత్ పెరెత్ మందీ యూదు సెత్ యేసున్ పొయ్ బరొస ఇట్టెర్. అదుఙి ముక్య దండి దెయ్యలక్ లాజరున్ దెకుల్ అల్ఙేఙ్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","అదుంఙ్ మరొక్కొదినం పస్క పండ్గు వత్తిన్ మంది అత్తీ మిరయ్తెర్. యేసుంద్ యెరూసలేముంఙ్ వర్సనండాద్ ఇసా వింతేర్, ");
INSERT INTO nit_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","ఔర్ సిమ్కనయ్ కజ్జుర్ పండ్లు కొమ్ తొటా వత్ అమ్నుంఙ్ అడ్డమ్ సేత్, “యోహాన్! ప్రబునెత్ పేరడ్ వరెకద్ ఇస్రాయేలుఙ్ రాజక్ స్తుతి ఎక్కాద్!” ఇసా వాపొయ్తెంద్ అమ్నున్ కలయెంఙ్ సెద్దేర్. ");
INSERT INTO nit_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","“సియోన్ నే పిల్ల, అర్సనెం! ఇన్నె రాజక్ గాడ్దినె కొవ్వెనత్తీ ఉద్దుత్ వర్సనడ్డద్” ఇసా వాయుత్ అనెకా యేసు చిన్నం గాడ్దిన్ ఓలుత్ అదున్ పొయ్ ఉద్తెంద్ వర్సానండాద్. ");
INSERT INTO nit_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","అమ్నె సిసులుంఙ్ ఈ సంగతిక్ సజెనీ ఒర్కిలెతమ్ గని యేసునే మహిమ సుమ్ముత్ మల్ల, ఇద్ సంగతిక్లడ్ అమ్నే లహిప్ తా సిమ్కన, ఔర్ అమ్నుఙ్ ఇనంఙ్ ఇదర్తెర్ సిసా అది కల్సా నండాద్ ");
INSERT INTO nit_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","అముదు లాజరున్ తప్నెతనట్ కూగుత్, తిక్తతనట్ మల్ల బత్కిప్సాంద్ యేసునడ్ అనెకా మందిన్ అమ్నున్ వాలడ్ మరొక్కొరుంఙ్ సాక్సం సియ్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","అముదు ఇద్ ఓలెకా సమత్కల్ ఇదర్తెంద్ వింత్న కరనముంఙ్ వాలడ్ మంది మిరయ్ తెర్ అమ్నుఙ్ కలయెఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ఇదున్ వాలడ్ పరుసిక్, ఓలుర్, నేండ్ తనై కలెఙ్ సలెమం. దున్యసిమ్మన అమ్నున్ వెంటా సెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","పస్క పండ్గున్ మొకెంఙ్ వత్తర్ కొన్సెమం మందీ గ్రీకు అన్డెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ఔర్, గలిలీయ ముత్ బెత్సయిదా ఇనెక ఊర్తంద్ పిలిపున్ వత్తిన్ం, “మాల్క, అముంఙ్ యేసునున్ ఓలెకద్ అండద్” వేలుత్ ");
INSERT INTO nit_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","పిలిప్ సెత్ అంద్రెయక్ ఇంన్తెద్. అంద్రెయక్ పిలిప్ నడ్ కలయుత్ సెత్ యేసున్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","యేసుంద్ ఔరున్ ఉత్తర్ సియ్సా, మన్కనె పోరక్ మహిమ ఎరెకత్ గడియా వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ఇమ్మతి కరెయ్ ఇడ్సనండత్, గొద్మ దనె బూమిత్ ఉర్కుత్ తిక్సెటన్డే, అద్ ఒక్కొదిలఙ్ అన్సద్. ఇద్ తిత్తే పెరేత్ పండ్లు సియ్సద్. ");
INSERT INTO nit_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ఎందెన తనేత్ పానం ప్రేమ్ కల్కకాన్ అదున్ దేడేప్పద్. గిని, ఇద్ దున్యత్ తనెత్ జమున్ విరోద్ కల్కకాద్ ఎప్పుడి అనెకాద్ జమున్ సటీ అదున్ సోయ్ కాల్సద్. ");
INSERT INTO nit_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","అనేత్ సేవ కాల్కకాంద్ అనున్ వంట వరెంఙ్. అపుడ్ అన్ ఎత్తి అన్సతొ అత్తి అనె గడియకున్ అతిన్ అన్సంద్ అనున్ పైయెకాంద్ బాంద్ ఓల్సద్. ");
INSERT INTO nit_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","పంఙి అన్నె పానం బత్క ఇడ్సనండద్. అన్ తనయ్ ఇడ్డెన్? బద్ ఇద్ గట్నతనట్ అన్ పుస్ ఇసా ఇడ్తన? గని, ఇదుంఙ్ సాయీయ్ ఇద్ గట్నతనట్ మలయ్తన్. ");
INSERT INTO nit_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","బాంద్, ఇన్నె పేరడ్ మహిమ కాలప్ ఇసా ఇన్తెద్. అపుడ్ ఆబార్ తనట్ ఒక్కొలేంఙ్ వినుక్వర్సాద్ వత్ ఇనంఙ్ ఇంతిన్, “అన్ అదుంఙ్ మహిమా కాలాపెన్. మల్లా మహీమా అలాప్సత్.” ");
INSERT INTO nit_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","అపుడ్, అత్తీ ఇల్లుత్ అనెకాదున్ వింత్ మందినే, “గుడుమ్‍తిన్” ఇన్తెంద్ మిక్తర్, “ఓక్కొద్ దెవ దూత్ అమ్నడ్ ముట్టిన్” ఇన్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","అదుఙి యేసున్ ఇనంఙ్ ఇడ్తెంద్, “ఇద్ లెంఙ్ అనుంఙ్ సాటీ ఎరెద్. ఇముంఙ్ సటీ వత్తిన్.” ");
INSERT INTO nit_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","పంఙి ఈ దున్యత్‍ తిర్పు తిర్పెకా వేల వత్తిన్. ఇద్ ఈ లోకముత్ బత్కెకరున్ అదికారి ఎద్గెకద్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","అన్ బూమితనట్ పదే ఎద్తిరపుడ్, మన్కకెరున్ అన్వై తివ్సాత్. ");
INSERT INTO nit_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","అముదు ఎనంఙ్ తిక్సాదో ఓలెకాద్ ఎరద్, అదుంఙ్ విచార్ అముదు ఇద్ గొట్టి ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ఆ మంది మిరయుత్ అమ్నాడ్, “క్రీస్తు ఎప్పుడి అన్సాద్ నియమ్ సాస్త్రముత్ అండాద్ ఇసా విన్తమ్. ‘మన్కన్ పోరక్ పొయ్ ఎత్తెకద్ ఎరెఙ్’ ఇసా నివెనంఙ్ ఇడ్సతీ? ఈ మన్కనె పోరక్ ఏంద్ ఎన్నెంద్?” ఇన్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","అపుడ్ యేసుంద్ ఔరడ్ ఇనంఙ్ ఇడ్తెంద్, ఇంకా కొన్సెం కాలమీ వెలుంఙ్ ఇమ్మె నడుమ్ అన్సాద్; చికటి ఇముంఙ్ ముంసెట, ఇంకా వెలుంఙ్ అనెఙయ్ అడుగుర్. చికటిత్ అడ్గనెర్, తన్ ఎద్దెసెసందో అమ్నుఙి కరీలెద్. ");
INSERT INTO nit_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ఇముంఙ్ వెలుంఙ్ అనెఙయ్, ఆ వెల్ఙుత్ విస్వాస్ ఇడుత్ వెలుంఙ్ కలయుత్ ఇన్తెద్. యేసు ఇదా గొట్టిక్ ఇడ్, అన్తెతనట్ సెద్దరుఙ్ కన్కెర్సెటా పరీసాన్ అన్డర్. ");
INSERT INTO nit_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","యేసుంద్ ఔరున్ ముండట్ ఎన్నిగొ సమత్కల్ కత్తరతనట్, అమ్నున్ నమ్మెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ప్రబు, అమ్మెత్ గొట్టిన్ ఎరీ నమ్మెర్? ప్రబునున్ తనే సక్తిన్ ఎరుంఙ్ ఓలిప్సాంద్? ఇసా ప్రవక్త యెసయక్ ఇడ్త గొట్టిక్ మరొక్కొద్ మరొక్కొద్లంఙ్ ఇద్ ఎద్దీన్. ");
INSERT INTO nit_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ఇద్ ఔర్ ఇదున్ నమ్మెతెర్ యేసుంద్ ఇనంఙ్ ఇడ్తెంద్, తానుంఙ్ ఇంతె తానుంఙ్ ఇంతే యెసయక్ మరొక్కొద్ జాగా ఇనంఙ్ ఇన్తెద్, ");
INSERT INTO nit_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“దెయ్యం ఔరె కన్డున్‍ గుడ్డిక్ కత్తిన్, ఔరె మన్లున్ ముస్‍తెద్. ఔరుంఙ్ ఓలెంఙ్ వరెద్‍ ఇసా, ఔర్ అర్తం కలెంఙ్ వారెద్‍ ఇసా అమ్నె ఉద్దేస్ అనంఙ్ కల్‍సెటా అండె ఔర్ అన్‍వై మల్యదర్ ఔరుంఙ్ అన్ నయం కలెకద్‍వరద్.” యెసయా 6:10 ");
INSERT INTO nit_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","యెసయక్ యేసుంక్నె మహిమ కలెకద్ ఓల్‍తెద్. అదుంఙ్ ఎత్తి అమ్నున్ బదోల్ అనంఙ్ ముట్టెద్. ");
INSERT INTO nit_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ఈ పరిస్తితిక్లెంఙ్ ఎన యూదులె అదికారి కొన్సెం మంది యేసున్ పొయ్‍ విస్వాస్ ఇటెర్. గని పరుసియ్యకెర్ తమ్మె బక్తి సావ్డి తనట్ పుస్‍దర్ ఇనెకా అరింఙ్ వాలడ్ అదున్ బదోల్ ఔర్ ఇడెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","తానుంఙ్ ఇంతె, ఇవ్రుంఙ్ దెయ్యమ్నె దయంఙ్ ఎన మంది మాన్ ఎక్కవ ప్రేమ్. ");
INSERT INTO nit_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","యేసుంద్ అన్న విస్వాస్ కలెకద్, అని ఎరెకద్ అన్ పన్కతనున్ “అన్నతి నాయ్ విస్వాస్ ఇడ్‍దద్.” ");
INSERT INTO nit_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","అన్ ఓల్‍తద్ అన్ పన్కతనున్ నాయ్ ఓల్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","అన్ ఈ దున్యంఙ్‍ వెలుంఙ్ ఎత్త వత్తన్! తానుంఙ్ ఇంతె అన్నపొయ్ బరొస ఇడ్డెకర్ సీకటిత్ అనెంఙ్ తోద్ ఇసా. అదుంఙ్ ఎత్తి అన్‍ ఇడ్డెక గొట్టికున్ బాంద్ అనుంఙ్ ఇడ్ ఇసా సియ్‍త గొట్టికి. ");
INSERT INTO nit_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ఎదెన అన్నె గొట్టికున్ విత్న అదవున్ సుమ్‍సెటరున్ అన్ న్యాయ్ కలెన్. తానుంఙ్ ఇంతె అన్ ఈ దున్యంఙ్‍ న్యాయ్ కలెంఙ్ వరెతన్, గని అన్ బత్కిపెంఙ్ వతన్. ");
INSERT INTO nit_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","అన్నె గొట్టికున్ నంసెటరుంఙ్ ఒక్కొద్ న్యాయ్ కలెకద్ అన్సాద్. అన్‍ముట్ట గొట్టిక్ ఆక్రి దినముంఙ్ ఔరె న్యాయ్‍ కల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","తానుంఙ్ ఇంతె అన్నె మన్నాడ్ ముడెతన్, గని అన్నె బాంద్ తనెద్ ఇడ్ ఇసా అనుంఙ్ ఆగ్య సియ్‍తెదొ అనాయ్ ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","అమ్నె ఉక్కుమ్ ఎప్పుడి అనెకా పానం అడ్గిప్‍సాద్ ఇసా అనుంఙ్ ఒర్కియ్. అదుంఙ్ ఎత్తి అందా ఇడ్డెక గొట్టికున్ బాంద్ అన్నడ్ ఇడ్ ఇసా సియ్‍త ఆగ్య ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","పస్క పండ్గున్ పేలె దినం. ఈ దున్యన్ సాయుత్న తన్నె బానే ఎల్లంఙ్ సెరేకా వెల వత్తిన్ ఇసా యేసునుంఙ్ ఒర్కియ్. అముదు ఈ దున్యత్ అనెకర్ తన్నెర్ సాదరున్ ప్రేమ్ కతెంద్. తన్ ఔరుంఙ్ ఎత్తె ప్రేమ కతెంద్ ఇంతె ఆ ప్రేమన్ ఔరుంఙ్ ఓలిప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","యేసుంద్ అమ్నె సీసు సిత్తెతద్ తినెంఙ్ ఉదుత్ అన్సార్. సైతన్ అప్పుడి బూత్, సీమోన్నె కీకె యూద ఇస్కరియోత్ నంత్తి సొగుత్న యేసుకున్ కల్సా ఇసా ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","బాంద్ తనుంఙ్ పురా అదికార్ సియ్‍తెతి యేసునుంఙ్ కరిల్‍తిన్. తన్ దెయ్యం తనట్ వత విసయమ్, తిర్గుత్ అమ్నున్వై సెసాత్ ఇనెక విసయమ్ అమ్నుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","అదుంఙ్ ఎత్తి అముదు తినెకరె పంగత్ తన సుల్‍తెద్. తన్నె పొలహ జుఙ్ఙెలున్ పుసుత్, ఒక్కొ దుతన్ ముల్కెత్ చుట్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","అదుంఙ్ వెన్కత్ ఒక్కొ దండి తైలత్ ఈర్ వగుంత్ తన్నె సిసులె గెట్టలొడ్పెంఙ్ సురుకతెంద్. ముల్కెత్ కట్‍త కడ్వనాడ్ ఔరె గెట్టలున్ ఉసుమ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ఆమ్ద సీమోన్ పేతురున్‍వై వతెంద్. అప్పుడ్ పేతురుంద్ అమ్నున్, “మాల్క, నీ అన్నె గెట్టలున్ ఓడ్‍సాతివా?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","యేసుంద్ అమ్నున్ “అన్ కలెకాద్ ఇండ్డి ఇనుంఙ్ అర్తం ఎరెద్. గని, నీ మల్ల అర్తం కలతీ” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","పేతురుంద్ అమ్నున్, “నీ అన్నె గెట్టలున్ ఎప్పుడి ఒడెంఙ్ తోద్” ఇంతెంద్. యేసుంద్ అదున్ “అన్ ఇంన్ ఓడ్‍సెటా అండె, అన్నడ్ ఇనుంఙ్ పనితొతెద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","సీమోన్ పేతురుంద్ అమ్నున్, “ప్రబు, అన్నె గెట్టలి మత్రమ్ తోద్. అన్నె కెయ్యులి, అన్నె తల్లునాయ్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","యేసుంద్ ఇనంఙ్ అమ్నున్, “ఈర్ ఓట్టె వెన్కత్ తన్నె గెట్టలి ఎరెకడ్ ఇంక తనెన్ ఒడెంఙ్ తోద్. అపుడ్ సిమన సోయ్తది. నీర్ సుదులి గని, ఇమున్ లోప సిమ్కన సోయ్త తోతె” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","తానుంఙ్ ఇంతె, తన్నవిరొద్ కలెకద్ ఎరొద్ అంనుంఙ్ ఒర్కియ్ అదుంఙ్‍ఎత్తి అముదు, “ఇమున్ లోప సిమ్కన ఇమన్‍దాల్ ఎరెర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","యేసుంద్ ఔరె గెట్టలొడుత్, తన్నె జుఙ్ఙెలున్ సుముత్ నియమ్ ప్రకరం ఉదుత్న, ఔరున్, “అన్ ఇముంఙ్ సటీ తగాత్తనో ఇముంఙ్ కారిల్తినా?” ");
INSERT INTO nit_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","నీర్ అన్ ఇడ్డెకంద్, ప్రబుంద్ ఇసా సొయి కుఙ్ సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ఇడ్డెక, ప్రబునన్ జీమెదర్ అన్ ఇమ్మె గెట్ట లొట్టె, నిర్‍నై ఒక్కొనె గెట్టలొక్కొద్ ఒడెంఙ్. ");
INSERT INTO nit_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","అన్ ఇముంసటి కత్తెతి నిర్‍నై కలెంఙ్ ఒక్కొ నమొన ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","అన్ ఇముంఙ్ కరెయ్ ఇడ్సాత్, గడియక్ తన్నె మాల్కకుంఙ్ ఎన దొడంద్‍ తొద్. కబుల్లాకెర్ అంనున్ పన్కతనుంఙ్ ఎన సోయ్తద్ ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ఈ విసాయ ఇముంఙ్ ఒర్కియ్ అదుంఎత్తి, అనాయ్ కత్తిరింత్తె నీర్ బాగ్యివన్ల. ");
INSERT INTO nit_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","నీర్ సిమ్కనఙ్ సటీ అన్ ముడెన్. అన్ ఆస్తరున్ అనుంఙ్ ఒర్కియ్. ఎరతే, అన్నె నిపట్టె తినెకద్ అనుంఙ్ విరొదడ్ తన్ ముడేకా లేకనముత్ ఎరెంఙ్ ఇసా ఇనంఙ్ ఎర్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","అనం ఎరెంఙ్ పేలెయ్, ఇండ్డి ఇదున్ ఇముంఙ్ ఇడ్‍సాత్. తానుంఙ్ ఇంతె అనాఙి ఎరెంఙా, అన్ అండన్ ఇసా నీర్ నమ్మెంఙ్ ఇసా అన్నె అసా. ");
INSERT INTO nit_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","అన్‍ ఇముంఙ్ కరెయ్ ఇడ్‍సాత్. అన్‍ పన్కతనున్ సుందే ఔర్ అన్ సుంసాంద్. అన్ పవిట్టనున్ సుంసెటాద్ అన్ పన్క తనున్ సుంసాంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","యేసుంద్ ఇగొట్టి కున్ ఇడ్‍త వెన్కత ఆత్మనాడ నారాజ్‍ ఎదెద్, “ఇమున్ లోపా ఒక్కొద్ అన్ దొకా సియ్‍దద్ ఇసా ఇముంఙ్ సత్తెం ఇడ్సాత్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","అముదు ఎరుంఙ్ వాలడ్ ఇనంఙ్ ఇడ్‍సాదొ ఎర్క తోసెటదుంఙ్ సిసు ఒక్కొనె మొకం ఒక్కొద్ ఓల్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","తినెకా జాగత్ మెర, అమ్నె సిసుతన అముదు యేసుంద్ ప్రేమ్ కత్త సిసుంద్, యేసున్ మెరయ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","సీమోన్ పేతురు ఇనెకా పేర్త సిసునుంఙ్‍, “యేసుంద్ ఎరున్ బదోల్ అనంఙ్ ఇంతెంద్ ఇసా ఇదున్ వెలుత్ కరిప్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ఆ సిసుద్ యేసున్ మెరయ్ ఇసాతి, “ప్రబు, ఆ మన్కక్ ఎద్?” ఇసా వెల్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","అపుడ్ యేసుంద్ ఇంతెంద్, “ఈ నిపట్టె తుక్డెన్ ఎరుంఙ్ ముంపుత్ సియ్‍సాతొ, అముదు” ఇంతెంద్. మల్ల అముదు నిపట్టెన్ ముంపుత్ సీమోనె ఇస్కరియోత్ ఇనెకా పోరక్ యూదకున్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","అముదు ఆ తుక్డెన్ సుమెఙయ్, సైతన్ అమ్‍నున్‍లోప సొంఙ్తిన్. అప్పుడ్ యేసుంద్ అమ్నున్, “నీ ఇదరెకాద్ జలద్ ఇదర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","అముదు అమ్నున్‍ ఇనంఙ్ ఇంతెందొ, బల్ల మెర అనెకరుంఙి కరిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","పైసెల సంసి యూదక్‍నంత్తి అన్సాద్ అదుంఙ్ ఎత్తి యేసుంద్ అమ్నున్, “పండ్గుంఙ్ పనితవుని సుమ్” ఇసా ఎక్కద్, గరిబులుంఙ్ సియ్‍ ఇసా ఇడ్డెకదుంఙ్ ఔర లోప కొన్సెం మంది ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ఉయయదక్ అది సింత్తె అముదు ఆ నీపట్టె తుక్డెన్ సుముత్న వెంటాయ్ వాకకురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","యూదక్ సెదవెన్కత్, యేసుంద్, “ఇండ్డి మన్కనె పోరక్ మహిమ సుమ్‍తెద్. దెయ్యం అమ్నున్ లోప మహిమ సుమ్‍సనంసాద్” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","దెయ్యం వాలడ్ మన్కక్నె పోరకున్ మహిమ కల్సాద్, అనాయ్ తన్నెత్ తాని కీకెన్ వాలడ్ మయ్‍మ కల్‍సాద్. వెంటాయ్ అమ్నున్ మయ్‍మ కల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","పోరకేర్, ఇంక ఆ కొన్సెం కాలం అన్ ఇముంఙ్ అంసాతున్. ఇనుఙ్ సటీ కిరవ్సాతున్. గని, అన్ యూదులుఙ్ ఇడ్ఎతెతి ఇముంఙ్ దెకుల్ ఇడ్సనంసాతున్, అన్ సెద్దా జాగత్ నీర్ వారెతిర్. ");
INSERT INTO nit_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","నిర్‍ఓక్కొనెత్ ఒక్కొద్ ప్రేమ్ కలెంఙ్ ఇసా కొత్త ఆగ్య ఇముం సియ్‍సానంసాత్. అన్ ఇముంన్ ప్రేమ్‍ కత్తెతి నిర్‍నై ఒక్కొనున్ ప్రేమ్ కలెంఙ్. ");
INSERT INTO nit_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ఒక్కొనెత్ ఒక్కొద్ ప్రేమ్ ఓలిపెకద్ ఎద్దె, అదున్ సుముత్ అన్నె సిసు అని సదర్ మంది ఒర్కిల్‍దర్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","సీమోన్ పేతురుంద్ అమ్నున్, “ప్రబు, నీ వెయ్యసెసాతి?” ఇంతెంద్ యేసుంద్ ఇంతెంద్, “అన్ సెరెక జాగంఙ్ నీ ఇండి అన్ వెంట వరెంఙ్ సాలె? గని మల్ల వర్‍సాతి” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","అదుంఙ్ ఎత్తి, “పేతురుంద్, మాల్క అన్ ఇడియ్‍ ఇన్ వెంట తనుంఙ్ వరెన్? ఇనుంఙ్ సటీ అన్నె పానంసియత్” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","యేసుంద్ ఇంతెంద్, “అనుంఙ్ సటీ పానం సియ్‍సాతివ? అన్ ఇనుంఙ్ కరెయ్ ఇడ్సాత్, అన్ ఎననొ ఒర్కి తోద్ ఇసా నీ మూది గుసాల్ ఇడెంఙ్ పేలెయ్ పోత్ కూగెంఙ్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","యేసుంద్ “ఇమ్మె మనుంన్ దద్రిప్‍నెర్. నీర్ దెయ్యమున్ నమ్మెర్ అన్ నంముర్. ");
INSERT INTO nit_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","అన్నె బానె ఎల్లత్ ఎన్నిగొ కోలిక్‍ అన్సా. అనెంఙ్ తోసెటండె ఇముంఙ్ ఇడ్డెకనుంఙ్. సటీ ఒక్కొ కోలి తయార్ కలెకదుంఙ్ అదే సెసానంసాత్. ");
INSERT INTO nit_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","అన్ సెత్న ఇముంఙ్‍ సటీ జాగా తయార్ కత్ మల్ల వత్న ఇమున్ అన్‍ వెంట తోడా సెసాత్. అన్‍ ఎత్తి అన్‍డె నీర్‍ అత్తి అనెంఙ్ ఇసా అన్నె ఆసా. ");
INSERT INTO nit_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","అన్ సెరెక జాగంఙ్ వరెక పావ్ ఇముంఙ్ ఇత్తి ఎంతి ఒర్కి” ఇసా యేసుంద్ ఇంతెద్. ");
INSERT INTO nit_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","తోమక్ అమ్నున్, “ప్రబు! నీ సెరెక జాగా ఎత్తి అన్సాదొ అముంఙ్ ఒర్కి తోద్. అపుడుంఙ్ అముంఙ్ ఆ పావ్ ఏనంఙ్ ఒర్కింఙ్ వరద్?” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","మల్ల యేసుంద్, “అని మార్గమ్ సత్తెం, పానం, అనుంఙ్ తప్ప బాన్‍వై ఎరీ వరెంఙ్‍ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","అన్ ఎననొ కరె ఇముంఙ్ కరిలుత్ అండె అన్నె బాంద్ ఏదొ ఇముంఙ్ కరిలద్. ఇండి అమ్నున్ ఒర్కియ్. అముదు ఎదొ ఇముంఙ్ ఓల్తెంద్‍” ఇసా సమాదనం ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","పిలిప్, “ప్రబు! అముంఙ్ బానున్ ఓలిప్. అన్‍తెయ్ ఎరద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","యేసుంద్ ఇనంఙ్ సామదనం ఇడ్‍తెద్, “అని ఈన్నిగొల్ ఇమున్ వెంట కలయుత్ అండన్‍ తా! గని అన్ ఎననొ ఇముంఙ్ కరిలెతినా పిలిప్? అనా ఓల్‍తె బానున్ ఓల్‍తెతియ్. అనంఙ్ ఎద్దె బానుంన్ ఓలిప్ ఇసాతనుంఙ్ వెల్‍సాతి? ");
INSERT INTO nit_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","పిలిప్ ఇంతెంద్ అన్ బానంత్తి బాంద్ అనంతి అన్సాంద్ ఇసా, నీ విస్వాస్ ఇడెవా? అన్ ఇడ్డెకా గొట్టిక్ అన్నె మంత ఎరెవ్. అనతి అనెక బాంద్‍ తన్నె పనిన్ కల్‍సాద్.” ఇసా సిసులుంఙ్ ఇడ్సాంద్ ");
INSERT INTO nit_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","అన్ బానత్తి, బాంద్ అన్నత్తి అన్సాతుమ్ ఇసా విస్వాస్ ఇడుర్. తోద్ నమ్కలున్‍ఎన ఓలుత్ నంముర్. ");
INSERT INTO nit_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ఇద్ కరెయ్. అన్ బానున్‍వై సెసానంసాత్. అన్‍ నమ్తరున్ అన్ కత్త కార్యిలున్ సదర్. ఇదవుంఙ్ ఎన దండి కార్యిలున్ కద్దద్. తానుంఙ్ ఇంతె అన్ అన్నె బానున్వై చేసా నండాతున్ ");
INSERT INTO nit_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","అదుంఙ్ ఎత్తి అన్నె పేరడ్ ఎది వెల్తెనయ్ కీకెన్‍ వాలడ్ బాన్నె మహిమ సుమెకదుంఙ్ నీర్ అన్నె పెరడ్ తనెన్ వెల్‍తెన కల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","అన్నె పేరడ్ అన్న తనెన్ వెల్‍తెనా అన్‍ కల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","ఇముంఙ్ అన్నపొయ్ ప్రేమ్ అండె అన్‍ ఆగ్య కలతిర్. ");
INSERT INTO nit_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ఇమున్ వెంట ఎప్పుడి అంత్న, ఇముంఙ్ మదత్ కలెకదుంఙ్ మరొక్కొనున్ పన్క ఇసా అన్ బానున్ వేలుత్. అమ్నె ఆత్మన్ పన్కసాద్. ");
INSERT INTO nit_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","అపవిత్ర ఆత్మ సత్తెం ఇడ్డెకదుంఙ్ అద్నెకర్తవ్యం. దున్య అమ్నున్ ఓలెతిన్. అమ్నున్ బదోల్ దున్యతరుంఙ్ ఒర్కితొద్. అదుంఙ్ ఎత్తి అమ్నున్ నంమెర్, తానుంఙ్ ఇంతెంద్ అమ్నున్ ఓలెతిన్, ఒర్కిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“అన్ ఇమున్ పొరపొట్యికేర్ లంఙ్ సాయెన్.” ఇమున్‍వై పెన వర్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","కొన్ని దిన వాలడ్ ఈ దున్య అంన్ ఓలెద్. గని నీర్ అంన్ ఓల్‍తిరా. తానుంఙ్ ఇంతె అన్ ఎనంఙ్ బత్కసాతొ అనాయ్ నిర్‍ నై బత్కతిర్. ");
INSERT INTO nit_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ఆ దినాలుంఙ్ అన్ బానంతి, నీర్‍ అంనత్తి, అన్‍ ఇంమత్తి అన్సాత్ ఇనెకద్ బదొల్ నీర్ ఒర్కిల్‍తిర్. ");
INSERT INTO nit_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","అన్నె ఆగ్యలున్ విత్న అద్వున్ సుముత్ అడ్‍గెకది అంన్ ప్రేమ్ కలెకద్‍లాంఙ్ ఇనెకద్ వారద్. అంన్ ప్రేమ్ కలెకనున్ అన్నె బాంద్ ప్రేమ్ కల్‍సాద్. అనాయ్‍ అమ్నున్ ప్రేమ్ కత్నమ్నె సొంతం ఎరత్. ");
INSERT INTO nit_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","అప్పుడ్ ఇస్కరియోత్ యూదక్ ఎరెంద్, “గని యూదు ప్రబు! నీ దున్యంఙి మత్రమ్ నీ కండ్కెర్‍ సాతీ, కండ్కెరెన్ ఇసా తనుంఙ్ ఇసాతి?” ఇసా వెలుత్‍ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","అదుఙి యేసుంద్ సామదనం ఇడ్‍సా, ఎదేన అన్న ప్రేమ్ కత్తె అముదు అన్నె గొట్టికున్ విసాదొ. అన్నె బాంద్ అమ్నున్ ప్రేమ్ కల్‍సాద్. అమ్ అమ్నున్ మెరమ్ వత్న అమ్నున్ వెంట బత్కతుమ్. ");
INSERT INTO nit_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","అన్ ప్రేమ్ కల్‍సెటద్ అన్నె గొట్టిన్ వినెంద్. నీర్ వినెక ఈ గొట్టిక్ అన్నె ఎరె, అన్న పన్కత బానే. ");
INSERT INTO nit_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","ఇమున్ వెంట బత్కుత్ అనెంగయ్ ఇద సాదరి ఇముంఙ్ ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","అన్నె బాంద్ అన్నె పేరడ్ పన్కెక మదత్ అముదు పరిసుద్దాత్మ ఇముంఙ్ సిమన ఇడ్‍త, అన్ ఇముంఙ్ ఇడ్‍త సిమ్కన ఇముంఙ్ అది కత్‍సియ్‍దద్. ");
INSERT INTO nit_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","సాంతి ఇముంఙ్ సియుత్న సెసాత్. అన్నె సాంతిన్ ఇముంఙ్ సియ్‍సాత్. దున్యతలంఙ్ తోద్. ఇమ్మె మనుత్ దద్రిల్నెర్, అర్సానెర్. ");
INSERT INTO nit_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","అన్ సెదన్ గని ఇమున్‍వై పెన్న వర్సత్ఇసా అన్ ఇడ్డెకదున్ నీర్ వింత్తిర్. నీర్ అన్ ప్రేమ్ కత్తిరింతె, నీర్ కుసినడ్ అందతిర్. తానుంఙ్ ఇంతె అన్ అన్నె బన్‍వై సెసాత్. అన్నె బాంద్ అనుంఙ్ ఎన సోయ్తద్. ");
INSERT INTO nit_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ఇద్‍ జర్గిలెంగ నీర్ విస్వాస్ ఇడెంఙ్ ఇసా ఇముంఙ్ ఇదున్ బదోల్ ముడటి ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ఈ దున్యత అదికారి వర్సానంసాద్. అదుంఙ్ ఎత్తి ఇమున్‍వెంటా ఎక్వ ముడెన్. అముదు అన్ తనయ్‍గలెంఙ్ సాలెద్. ");
INSERT INTO nit_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","గని అనుంఙ్ బానుంన్ పొయ్ ప్రేమ్ అన్సాద్ ఇనెకద్ బదోల్, అముదు ఆగ్య సియ్‍తెతి అన్ కలెకదున్ బదోల్ దున్యతరుంఙ్ కరిలెంఙ్. అదుంఙ్ ఎత్తి ఇనంఙ్ కల్సనంసత్. “వర్, ఇత్రనట్ సెనర్!” ");
INSERT INTO nit_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","అన్ కరెయ్ అంగుర్నె రసాన్ తిగ్‍నన్. అన్నె బాంద్ అంగుర్‍నె కెతిదార్. ");
INSERT INTO nit_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","అనంత్తి అత్ కయ్‍సెట కొమున్ అముదు కత్కసాద్. పండ్లు కయెక సిమన కొమ్ములున్ ఇంక కాయెంఙ్ ఇసా అదవున్ కత్‍రిపుత్ సోయ్‍కల్సద్. ");
INSERT INTO nit_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","అన్ ఇముంఙ్ ఇడ్తాగొట్టి కారన్ నీర్ పంఙిదూక్ సోయ్తర్ ");
INSERT INTO nit_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","అనంత్తి నీర్ అడ్ర ఇమంత్తి అన్ అంసాత్. కొమ్మ అంగుర్నె రసాన్ తిగుత్ అండెని ఎరెకడ్ తన్నెత్ తనీ ఎనంఙ్ కయెదొ, నిర్‍నయ్ అనత్తి అండెని ఎరెకడ్ పలింసెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","అన్ అంగుర్నె రసాన్ చెట్నాన్, నీర్ తీగ్ ఎన్నిర్. అన్నడ్ ఎర్సంసారొ, అన్ ఎరడ్ అంసాతొ, ఆ మన్కక్ పెరెత్ రొంబాడద్. అన్నె మారొక్కొద్ నీర్ తనయ్ కాలెంసాలెర్ ");
INSERT INTO nit_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ఎదెన అంనత్తి తోసెటండె, అముదు కత్కుత్ జొపిట కొమ్‍లంఙ్ ఆర్‍సార్. ఔర ఆ కొములున్ మిరపుత్ కిసుత్ తప్‍సార్. అదా వెయ్‍సా. ");
INSERT INTO nit_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","నీర్ అనంత్తి, అన్నె గొట్టిక్ ఇంమత్తి అండె, తనెని ఎకద్ వేలుర్. అద్ ఇముంఙ్ సియద్. ");
INSERT INTO nit_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","నీర్ సోయ్ పీక్ సియుత్, అన్నె సిసులంఙ్ అండె, అన్నె బానుంఙ్ మహిమ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","బాంద్ అన్ ప్రేమ్ కత్తెతి అన్ ఇమున్ లాడ్ కత్తన్. అన్నె లాడుత్ గట్టి అడ్ర. ");
INSERT INTO nit_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","అన్ అన్నె బానె ఆగ్య కలయుత్ అమ్నె ప్రేమ్ త్ అండెతి అండె నీర్ అన్నె ఆగ్యలున్ అడ్తిరింతె అన్నె ప్రేమలొ ఇలుత్‍ అన్సాతిర్. ");
INSERT INTO nit_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","కుసిన్ నీర్‍ నాయ్‍ అనెంఙ్ ఇసా, నీర్‍ గుల్‍ కుసీ కలెంఙ్ ఇసా ఇముంఙ్ ఈ గొట్టిక్ ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","అన్ ఇమున్ ప్రేమ్ కత్తెతి నీర్ ఒక్కొనెత్ ఒక్కొద్ ప్రేమ్ కలెంఙ్. ఇద్ అన్నె ఆగ్య. ");
INSERT INTO nit_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","సంఙ్తకెరున్ సటీ పానామున్ సీయెకానె ప్రేమఙ్ ఏన గొప్ప ప్రేమ్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","అన్ ఇముంఙ్ ఆగ్య సీయ్‍తెతి కత్తిరింత్తె నీర్ అన్నె సంఙ్తకేర్. ");
INSERT INTO nit_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","అన్ ఇండి ఇమున్ గడియక్ ఇసా కుగెన్. తానుంఙ్ ఇంతె గడ్యికుంఙ్ మాల్కక్ కలెకద్ ఎర్కతొద్. అన్ ఇమున్ సంతకెర్ ఇసా కుగ్‍సాత్. తానుంఙ్ ఇంతె, అన్నె బానంతన అన్ వింతా సిమ్కన ఇముంఙ్ ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","నీర్ అన్ అసెతీర్. నీర్ సెత్న పలితం సియెంఙ్ ఇసా, ఇమ్మె పలం ఇలుత్ అనెంఙ్ ఇసా అన్ ఇమున్ ఆస్తరున్ నివ్డిప్‍తన్. అన్నె పేరడ్ నీర్ బానున్ ఎద్ది వెల్‍తెన సియెంఙ్ ఇసా ఇద కతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","నీర్ ఒక్కొనెత్ ఒక్కొద్ ప్రేమ్ కలెంఙ్ ఇసా ఈ ఆగ్య ఇముంఙ్ ఇడ్సనంసాత్. ");
INSERT INTO nit_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","లొకమ్ ఇమున్ విరోద్ కత్తె, ఆ దున్య ఇముంఙ్ ఏనా ముండట్ అన్న విరోద్ కత్తెర్ ఇన్నెకదున్ ఆదికలుర్. ");
INSERT INTO nit_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","నీర్ లోకముత్ కలయుత్ అండిర్ ఇంతె పరలోకంత మంది ఇమున్ తమ్మెరున్ లంఙ్ ప్రేమ్ కల్సాద్. అన్ ఇమున్ ఈ దున్య‍త్ ఆస్తరున్. అదుంఙ్ ఎత్తి ఇండ్డి నీర్ ఈ లోకంతర్ ఏరెర్. అదుంఙ్ ఎత్తి లోకం ఇమున్ విరోద్ కల్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","మాల్కకుంఙ్ ఏనా గడియక్ దండి తోద్ ఇసా అన్ ఇడ్‍త గొట్టికున్ ఆది ఇడుర్. ఔరు అన్నె విరోద్ ఇమున్ దెకుల్ విరోద్ కాల్సార్. ");
INSERT INTO nit_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","అన్న పన్కతద్ ఎదొ ఔరుంఙ్ ఎర్కా తోద్. అదుంఙ్ ఎత్తి అన్నె పేరడ్ ఇదా సెదర్ ఇదర్సర్ ");
INSERT INTO nit_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","అన్ వర్సెటా, అండే ఔరుంఙ్ దోసి ఇడ్‍సెటా అండిరింత్తె పాప్ దొస్ ఔరున్ పొయ్ అంసెటద్. గని ఇండి ఔరు తమ్మె పాపు తన్న సుటలెంఙ్‍ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","అన్న విరోద్ కలెకర్ అన్నె బానున్ నాయ్ విరోద్ కలెకద్‍లాంఙ్ ఎద్దద్. ");
INSERT INTO nit_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","అన్ ఔరుంఙ్ సటీ ఈ కార్యిలున్ కల్‍సెటండె ఔరుంఙ్ ఈ పాప్ ఆట్సెటద్. గని ఇండి ఔర్ అన్నెపానిక్ ఓల్‍తెర్. ఎన అన్న, అన్నె బానున్ విరోద్ కల్‍సార్. ");
INSERT INTO nit_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","గని చట్టం తోసెట అన్న సిమ్కన విరొద్ కత్తెర్ ఇసా వాయుత్ అన్సాద్. జర్‍గిల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","అన్ అన్నె బానత్తాన సత్తెం తా! ఆత్మన్ ఇముంఙ్ ఆదరుంఙ్ సటీ పన్కసాత్‍. మదత్ కలెకద్ ఈ ఆత్మ అన్న బదోల్ ఈ సక్సం ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","నీర్ అన్న వెంట పేలెతన అండరి అదుంఙ్ ఎత్తి నీర్‍నాయ్ సాక్సం ఇడెంఙ్. ");
INSERT INTO nit_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","నీర్ విస్వసాముత్ ఇల్లుత్ అన్నెఙ్ ఇసా ఈదవ్ గొట్టిక్ ఇముంఙ్ ఇడ్స నంతుమ్. ");
INSERT INTO nit_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ఔర్ ఇమున్ బక్తి సావ్డి తనట్ పుస్తెర్. ఇమున్ అలగ్తర్, దెయ్యమున్ సటీ సొబతా పనీ ఇదర్ సతుమ్ ఇసా ఇనెకా టయిమ్ వార్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","అన్ గానీ, బాంద్ గానీ ఔరుఙ్ ఒర్కి తోద్‍ అదుహీ అనఙ్ ఇదర్సర్. ");
INSERT INTO nit_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","తె అదవ్ ఎరెకా వేలా వత్తపుడ్, అదవుఙ్ వాలడ్ అన్ ఇముంఙ్ ఇడ్ తా ఆదీకలెంఙ్ ఇసా ఇదవ్ గొట్టిక్ ఇముంఙ్ ఇడ్సానగ్డత్. అన్ ఇమ్మడ్ అన్డతిస ఇదవ్ గొట్టిక్ సజెనీ ఇముంఙ్ ఇడ్డెఙ్ సలెన్. ");
INSERT INTO nit_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ఇంతె ఇండీ అన్ అలుగ్తనున్వై సెసానండాత్. తే, నివ్ ఎత్తింఙ్ సెసతీ? ఇసా నీర్ ఏరీ అన్ వేలుత్ ఓల్సాతొతెర్. ");
INSERT INTO nit_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","అన్ ఈ గొట్టికున్ ఇమ్మడ్ ఇడ్తనిసా ఇమ్మె మనుత్ నిండా దుక్కాడ్ అనడాద్. ");
INSERT INTO nit_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","అముదు అపుడుఙ్‍, అన్ నిమ్మట్ సత్తెం ఇడ్సనండత్, అన్ సెరెకద్ ఇముంఙ్ సొబతది. అన్ సెరసేటన్డే, మదత్ ఇన్మత్తీ వరెద్. గని అన్ సెద్దే, అమనున్ ఇమ్మతీ పవిడ్సత్. ");
INSERT INTO nit_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","మదత్ కలెకాంద్ వత్తెదింతె, పాప్ వాలడ్, నీతిన్ వాలడ్, న్యాయ్ వాలడ్ దున్యన్ ఓప్ గద్దంద్. ");
INSERT INTO nit_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","మంది అన్నత్తీ నమ్సతొతెర్ అదుహీ పాప్ వాలడ్ ఓప్ గద్దంద్. ");
INSERT INTO nit_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","అన్ బానత్తి సెరెకారన్ అండత్, నీర్ మల్ల అన్ ఎప్పుడి ఓలెర్ అదుఙి నీతిన్ వాలడ్ ఒర్కిలెర్. ");
INSERT INTO nit_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ఇద్ దున్యన్ పొరయేకద్ గొట్టిన్ అదికారి తిర్తెంద్ అదుఙి న్యాయ్ మనిప్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“అన్ ఇముంఙ్ ఇడ్డెకా గొట్టిక్ ఇంకా పేల్లె అన్సా గని పంఙి నీర్ అదవ్‌లున్ ఒర్కిలెంఙ్ సాలెర్.” ");
INSERT INTO nit_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ఇన్తే అమ్నున్, దెయ్యమ్నె సత్తెం ఆత్మన్ ఓలిపెకాద్ వత్ తా అపుడ్ ఇమున్ పుర సతేముత్ అడిప్సడ్. అముదు తన్తెత్ తనుంఙ్ తనయ్ ముడెద్. ఏద్ వీసదో అద్దీ ముడ్సాద్. ఏరెకవున్ ఇముంఙ్ ఇడ్ససద్. ");
INSERT INTO nit_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","అముదు అన్నున్ కొసుత్ ఇముంఙ్ సియ్సద్ అదుఙి అనుంఙ్ మహిమ సియ్తెద్. ");
INSERT INTO nit_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","అన్నె బానత్తి అనెకా అన్నెవీ, అదుఙి అద్ ఆత్మ అన్నున్ కొసుత్ ఇముంఙ్ ఇడ్ససదీసా అన్ ఇడ్డెన్. ");
INSERT INTO nit_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“కొన్నీ గొల్ వాలడ్ నీర్ అన్ను ఓలెర్. అదుంఙ్ వెన్కత్ మల్ల కొన్ని గొల్లుఙ్ నీర్ అన్ను ఓల్సతిర్.” ");
INSERT INTO nit_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","అమ్నె సిసులత్తి కొంచెం మందిన్ “అమ్నే ‘ఓక్కొ కలముత్ మిర్ అన్ను ఓలెర్. అద్ ఎద్దా వెనుకత్ నీర్ అన్ను ఓల్సతిర్, తానుంఙ్ ఇన్తే అన్ బానత్తి సెసాత్’ ఇసానడ్డత్. ఇద్ తనెద్? అముదు ముండట్ తనెద్ ఇడ్సనన్డద్?” ఇసా ఔరెత్ ఔరి ముడ్నెర్, ");
INSERT INTO nit_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","అదుఙి ఔర్, కొన్ని గొల్ అడ్డే అమ్నే ఉద్దెసం తనేద్? అముదు తనెద్ ఇడ్సదొ అముంఙ్ ఒర్కితొద్ ఇసా ఇన్తేద్. ");
INSERT INTO nit_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ఔరు ఇద్ గొట్టిత్ తన్నున్ వేలుత్ ఓలెఙిసా కొంతెం కాలం మల్ల నీర్ అన్ను ఓలెర్. ఆ మల్ల కొంతెం కాలానికి నీర్ అన్న ఓల్సతిర్ ఇసా అన్ ఇం తా గొట్టింఙ్ అర్తం తనేంద్ ఇసా విచార్ కాల్సానండతీర్ ");
INSERT INTO nit_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","అన్ ఇముంఙ్ కరెయ్ ఇడ్సాత్, నిర్‍ కుసినడ్ అర్సాతిర్, గని ఈ దున్యతర్‍ కుసీ కల్సార్. ఇముంఙ్ నారాజ్‍ ఎరద్ గని ఇమ్మె దుక్కం కుసీతద్ మల్‍గద్. ");
INSERT INTO nit_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","పిల్ల ములంఙ్ సెరెకా వెలంఙ్ కటిన్ ఎర్‍సాద్. గని, పోరక్‍ జన్మిల్‍త వెన్కత్ ఆ పోరక్ ఈ దున్యంఙ్ వతెంద్ ఇన్నెక కుసినడ్‍ తనుంఙ్ కటిన్ ఎరెకద్ మల్ల ఆది వరెద్. ");
INSERT INTO nit_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","అనాయ్ నిర్‍ ఇండ్డి తక్‍లిబ్ బొగిల్‍సాతిర్ గని, అన్ ఇమున్ మల్ల ఓల్‍సాత్. అప్పుడ్ ఇమ్మె మన్ కుసీ కలద్. ఇమ్మె కుసిన్ ఎర్రి ఇమ్మతన్న పుసుత్ కొసెర్. ");
INSERT INTO nit_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ఆదినముంఙ్ నిర్‍ అన్న ఏ పార్తనలున్ నాయ్‍ వెలెర్. అన్ ఇముంఙ్‍ కరెయ్ ఇడ్‍సాత్, నీర్ బానున్ ఎద్ది వేల్తొల్తెంద్, అన్నె పేరడ్ అముదు ఇముంఙ్ అదవ్లున్ ఇయ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ఇండిదూక్‍ అన్నె పేరడ్ నీర్ తనయ్ వెలెతిర్. వేలుర్, అప్పుడ్ ఇమ్మె కుసి పూర ఎరెకద్‍లంఙ్ నీర్ ఓలతిర్. ");
INSERT INTO nit_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","ఇదసిమ్కన ఇండిదూక్ సోయ్ అర్దం ఎర్‍సేట గొట్టినడ్ ఇముంఙ్ ఇడ్‍తన్. ఒక్కొ వెల వార్సాద్ అపుడ్ బానున్ బదోల్ సోయ్ ఉపమనం ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ఆ దినముంఙ్ నీర్ అన్నె పేరడ్ వేలుత్. ఇంతె ఇముంఙ్ సటీ బానున్ పార్తన కల్‍సాత్ ఇసా ఇనెన్. ");
INSERT INTO nit_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","తానుంఙ్ ఇంతె నీర్ అన్న ప్రేమకత్న, అన్ దెయ్యం నత్తన వత్తన్ ఇసా నమ్ముర్ అదుంఙ్‍ ఎత్తి బాది ఇముంన్ ప్రేమ్‍ కల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","అన్ బానున్‍ వాలడ్ ఈ దున్యంఙ్ వత్తన్. ఇండి పెన్న ఈ దున్యన్ సాయుత్ బానున్‍వై సెసాత్. ");
INSERT INTO nit_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","అప్పుడ్ అమ్నె సిసు ఓల్ ఇండ్డి నీ అర్తం ఉపమనం రితినాడ్ ఎర్‍సెట, సోయ్ ముడ్‍సాతి. ");
INSERT INTO nit_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","నివ్ అని ఒర్కితనివి ఇసా, ఇన్ వేలుత్ అవసారం తోద్ ఇసా, ఇండి అమ్ ఓర్‍కిల్‍తమ్. ఇదుంఙ్ వాలడ్ నివ్ దెయ్యంతన వత్తివ్‍ ఇసా అమ్ నమ్సతుమ్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","యేసుంద్ సామదనం ఇడ్‍సా, “నీర్ ఇండ్డి నమ్సతిరా? ");
INSERT INTO nit_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","నీర్ సిమ్కన ఎరేల్లక్లెంఙ్ ఔర్ సెత్న అన్న ఒక్కొనున్ సాయెకా వెలా వారెకద్‍అన్‍సాద్. వత్తిన్. ఎన్నగని, అన్నె బాంద్‍ అన్న వెంట అన్‍సాద్ అదుంఙ్‍ఎత్తి అన్ ఒక్కొనని ఎరెన్. ");
INSERT INTO nit_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","అన్న వాలడ్ ఇముంఙ్ సాంతి రొంబడెంఙ్ ఇసా అన్ ఇదసిమ్కన ఇముంఙ్ ఇడ్‍తన్. ఈ దున్యత్ ఇముంఙ్ తక్లిబ్ వార్సాద్. గని ఇమ్మత్ అడ్ర. అన్ దున్యన్ గెల్‍తన్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","యేసుంద్ ఈ గొట్టిక్ ఇడ్డుత్ ఆబార్ పోయ్ ఓలుత్, ఇనంఙ్ ఇంతెంద్, బబా, వెలా వత్తిన్. ఇన్నె కీకె ఇనుంఙ్ మహిమ కలెంఙ్‍, ఇన్నె కీకెంఙ్ మహిమ ఎర్గల్. ");
INSERT INTO nit_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","నీ ఇన్నె కీకెన్ సియ్ తా ఔరుఙ్ సిమ్కన అముదు ఎప్పుడి పానం సియ్యెకాంద్ నీర్ అమ్నున్ అదికార్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","కరె సత్తెం దెయ్యంని ఇన్ను. నీ పవిట్టా యేసు క్రీస్తున్ ఒర్కిలెకాది ఎప్పుడి అనెక పానం ");
INSERT INTO nit_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","నీ అనుంఙ్ సియ్‍త పని పుర్తి కత్న, బూమి పొయ్‍ ఇనుంఙ్ మహిమ కల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","బాంద్, ఈ దున్య గడిపేంఙ్ పేలె ఇన్ మెర అనుంఙ్ ఎంటది కీర్తి కలెకద్ అండినొ, ఇండి ఇన్నె అసరంలొ ఆ మహిమ మల్ల అనుంఙ్ ఎరెంఙ్ ఇడ్. ");
INSERT INTO nit_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","దున్యత్ తన నీ అనుంఙ్ సియ్‍తరున్ నీవ్ సెరెంఙ్ ఇట్టిర్. ఔర్‍ ఇన్నెరి. నీ ఔరున్ అనుంఙ్ సియ్‍తి. ఔర ఇన్నె వచనున్ సుంత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","నీ అనుంఙ్ సియ్‍త సిమ్కన ఇంనత్తానా వత్తవి ఇసా ఇండి ఔరుంఙ్ ఒర్కిలతెర్. ");
INSERT INTO nit_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","తానుంఙ్ ఇంతె నీ అనుంఙ్ సియ్‍త వాక్యలున్ అన్ ఔరుంఙ్ ఇడ్‌తన్. ఔరు అదవున్ సుంముత్, కరెయ్ అన్ ఇనంతన వతన్ ఇసా, నీవి అన్ పన్కతి విసా నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","అన్ ఔరుంఙ్ సటీ పార్తన కల్‍సాత్. ఈ దున్యంఙ్ సటీ తోద్ గని, నీ అనుంఙ్ సియ్‍తర్ ఇన్నెర్ ఔర్ అదుంఙ్ ఎత్తి, ఔరుంఙ్ సటీ నీ పార్తన వేలుత్. ");
INSERT INTO nit_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","అన్నె సిమ్కన ఇన్నెవి, ఇన్నె సిమ్కన అన్నెవి. ఔరతి అనుంఙ్ మహిమ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","అన్ ఇంక ఈ దున్యత్ అనెన్ గని ఔర్ దున్యత్ అంసార్. అన్ ఇన్‍వై వర్‍సాత్. పవిత్ర దెయ్యం బాంద్, నీ అనుంఙ్ సియుత్ అమ్నె పేరున్ వాలడ్, నెమ్ ఒక్కొది అండె ఔరున్ కాపాడు. ");
INSERT INTO nit_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","అన్ ఔరడ్ అనెంఙ్ నీ అనుంఙ్ సియుత్ ఇన్నె పేరుంన్ సుముత్ లేకనముత్ వాసానా ఎరెఙ్ ఇసా, కరాబ్ ఎరెఙ్ తోద్ ఇసా సొడప్‍దద్. ");
INSERT INTO nit_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ఇండి అన్ ఇన్ పొయ్ వర్‍సాత్. అన్నె కుసి ఔరుంఙ్ పురా ఎరెంఙ్ ఇసా దున్యత్ అనెంఙయ్ ఈ గొట్టికున్ ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ఔరుంఙ్ వాక్యం సియ్‍తన్. అన్ ఈ దున్యత్ అనెకరుంఙ్ ఎన, ఔర్‍వై ఈ దున్యత్ కలయ్‍తర్ తోద్ అదుంఙ్‍ ఎత్త ఈ దున్యతర్ ఔరున్ నకర్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","నీ ఈ దున్యతన ఔరుంఙ్ తోడ సెర్‍ఇసా అన్ పార్తన కలెన్ గని, విరొదిక్ తన్ ఔరున్ కపడెంఙ్ ఇసా ప్రా ర్తన కలెన్ గని, విరొదిక్ ఔరున్ కపడెంఙ్ ఇసా పార్తన వేలుత్. ");
INSERT INTO nit_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","అన్ ఈ దున్యత్ వతంనుంఙ్ ఎన ఔర్ ఈ దున్యత్ కలయ్‍త కలయ్‍తర్ యెరెర్. ");
INSERT INTO nit_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","సత్తెన్ వాలడ్ ఔరున్ పవిత్ర కల్. ఇన్నె వాక్యమి సత్తెం. ");
INSERT INTO nit_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","నీ అన్ ఈ దున్యత్ పన్కతెతి, అన్ ఔరున్ ఈ దున్యత్ పన్కతన్. ");
INSERT INTO nit_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ఔర్ సత్తెం వాలడ్ ఔరె సంతకెర్ పాజె ఇసా ఔరుంఙ్ సటీ అన్నెత్ అని పూర పవిత్ర కల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","నీవ్ అన్న పాపి ఇసా దున్యతర్ నమ్తెతి, బద్, అనంతి నీవ్ ఇనత్తి అండెతి. ");
INSERT INTO nit_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ఔర్ నెడత్తి ఒక్కొద్ ఎత్న అనెంఙ్ ఇసా ఔరుంఙ్ సటీ మాత్రమి అన్ పార్తన కలెన్. ఔర్ పన్కతివిసా దున్యతర్ నమ్మెకాంద్ లంఙ్ బాంద్, లోపా నీ ఇన్‍ లోప అన్‍ అండె, ");
INSERT INTO nit_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","నేండ్‍ ఒక్కొద్ ఎత్న అండె, ఔర్‍నై ఒక్కొద్‍ ఎరెంఙ్ నీ అనుంఙ్ సియ్‍త మహిమ కలెకద్ అన్ ఔరుంఙ్ సియ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","అవ్రత్తి అన్, అన్నతి నీ అండె అపుడ్ అవ్ర పూర ఒక్కొద్ అనెకదున్ వాలడ్, ఈ దున్యత్ నీ అన్న పన్కిసాతి, గని నీ అన్న ప్రేమ్ కత్తెతి ఔరుంనయ్ ప్రేమ్ కాల్, ");
INSERT INTO nit_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“బాంద్, అన్ ఎత్తి అంసాతొ, నీ అనుంఙ్‍ సియ్తర్ అన్ వెంట అనెంఙ్ ఇసా, నీ అనుంఙ్ సియ్‍త మహిమన్ ఔరు ఓలెంఙ్ ఇసా అన్ అసా కల్‍సాత్. తానుంఙ్ ఇంతె బూమిన్ గడిపెంఙ్ పేలెయ్ తనయ్ నీవ్ అన్ ప్రేమ్ కల్‍సాతి. ");
INSERT INTO nit_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","నీతి నాడ్ అనెకా అన్నె బాంద్! దున్య ఒర్కిల్ సెటా అండెనాయ్ నీ అనుంఙ్ ఒర్కియ్. నీ అన్నపన్కతివ్ ఇసా ఇవ్రుంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","నీఎన్నివొ ఔరుంఙ్ ఒర్కి కత్త సియ్‍సాత్. ఒర్కికత్తసియ్‍సాని అంసాత్. అన్ పొయ్ ఇనుంఙ్ అనెకా ప్రేమ్ అవ్రతినాయ్ అనెంఙ్ ఇసా, అవ్రతి అన్ అనెంఙ్ ఇసా అన్నె ఆసా.” ");
INSERT INTO nit_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","యేసుక్ ఇనంఙ్ ముడుత్న మల్ల తన్నెర్ సిసు వెంట కేద్రోత లోవన్ దాటుత్, అతిన్ అనెకాద్ బర్సంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","యేసుక్ తనెత్ సిసు వెంటా అపుడ్ అపుడ్ సేసా నంనేర్ అదున్ ఎంత్న అమ్నున్ సుమకార్ యూద కేరున్ సెరకాద్ మైతీ అండిన్. ");
INSERT INTO nit_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","యూద సైనిక్ గుంపున్ దండి దెయ్యలక్ పరుసిక్ ఓరికి తార్ తనున్ సీయ్ తా మందిర తా అదికారులున్ వెంట దుంద్రిక్ దీవె నార, రుసిక్, కొలా, తుపాకి, సుముత్ అత్తిఙ్ వంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","అపుడ్ యేసుక్, అమ్నున్ ఎరెకావ్ ఒర్కి అండిన్ అదున్ ఇసా ముదర్వై వత్న ఔరుఙ్, “నీర్ ఎరుఙ్ సటీ పవ్ ఓల్సనంసాతిర్?” ఇసా ఇంతేన్. ");
INSERT INTO nit_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","అమ్నున్ “నజరేత్ యేసుక్” ఎన్నెంద్ ఇసా ఇంతేన్. యేసుక్ ఇంతేద్‍, “అముదు అనే బాంద్” ఇసా ఇంతెంద్ యేసుకున్ సమ్ముత్ సియ్ తా యూదక్ ఔరున్ వెంట ఇలుత్ అండాంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","అముదు ఔరున్, “ఆని” ఇసా ఇడ్తెంద్‍ అపుడ్ అవ్ర వేన్క సర్కిల్‍ తేర్. ");
INSERT INTO nit_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","అముదు మల్ల, “నీర్ ఎరుంఙ్ సటీ ఓల్‍సాతిర్?” ఇసా వెల్‍తెంద్. ఔర్ మల్ల, “నజరేత్ తా యేసునుంఙ్ సటీ” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","యేసుంద్ ఔరున్, అముదు ఆని ఇసా ఇముంఙ్ ఇడ్‍తన్. నీర్ అనుంఙ్ సటీ ఓల్‍సాతిర్ ఎరత్తె, మిక్‍తరున్ సెరెన్‍ ఇడుర్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","నీ అనుంఙ్ సియ్త రంతన ఏనునీ అన్ దవడిపెతన్ఇన్నెక అమ్నె గొట్టి సిమ్కన ఎరెంఙ్ ఇసా అముదు ఈ గొట్టి ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","అపుడ్ సీమోన్ పేతురుంద్, తనత్తి అనెక రుసిన్ పుసుత్న, దండి దెయ్యలక్నె సేవక్నె ఉన్న కెవ్వున్ తర్గతెంద్. ఆ గడియక్ పేర్ మల్కు. ");
INSERT INTO nit_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","యేసుంద్ పేతురున్, “రుసిన్ లోపా ఇడ్‍, బాంద్ అనుంఙ్ సియ్‍త గిలస్తదున్ ఉసేటా అంసా తా?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","అపుడ్ సైనిక్లె గుప్, ఔరె దొడా, యూదులె మంది యేసునుంన్ సుమ్ముత్ కట్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","పేలె అమ్నున్ ఇంత జాగంఙ్ దండి దెయ్యలక్ సెద్దెర్. అముదు ఆ సాలుత్ అన్నస్ అదికరి అనెక కయపకు మామ. ");
INSERT INTO nit_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ఒక్కొ సిమ్కన మందింఙ్ సటీ ఒక్కొ మన్కక్ తికెంఙ్ పాజె ఇసా యూదులుంఙ్ ఇడ్‍త దీ ఈ కయపక్. ");
INSERT INTO nit_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","సీమోన్ పేతురుంద్, ఇంక్కొకొ సిసుంద్, యేసున్ దవ్‍తనయ్ ఓలుత్ అమ్నున్ వెంట సెద్దెర్. ఆసిసుంద్ దొడంద్ అదికరింఙ్ ఒర్కితది అదుంఙ్ ఎత్తి అముదు దండి దెయ్యలక్ అదికారినె ఎల్ల బోయ్దంఙ్ యేసునున్ వెంట చెసాంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","గని, పేతురుంద్ ఎల్ల మెర బొయ్దనాడ్ కయ్యెకద్ ఇలుత్ అన్‍సాద్. అపుడ్ దండి దెయ్యలక్ అదికరుంఙ్ ఒర్కి అనెక సిసుంద్ వకా వత్న ఎల్ల కయెకనున్ వెంట ముడుత్న పేతురున్ లోపా తోడా వతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","బొయ్దాత్ అనెకద్ ఒక్కొ రప్తిరాల్ పేతురునున్, “నీ అమ్నె సిసుతన ఒక్కొని తా?” ఇంతిన్ అముదు, “తొద్” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","అపుడ్‍ పనివరెంఙ్ అత్తి అన్నె గడియక్, అదికాల్ కిస్‍ఎర్‍కుత్ అదున్ తిర్‍గొరా ఇలుత్ కిస్‍అద్‍నెర్. పేతురుంద్ న్యాయ్ ఔరున్ వెంట ఇలుత్ కిస్‍ కగ్నెద్. ");
INSERT INTO nit_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","దండి దెయ్యలక్ అదికరి అమ్నె సిసులున్ బదోల్, అమ్నె ఉపదేసం బదోల్ యేసునుంన్ వేల్తొల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","యేసుంద్‍ సమాదనం ఇడ్‍సా, “అన్‍ కరెయ్ ఈ దున్యతరున్ వెంట ముట్టన్.” అన్ ఎప్పుడి యూదులె సావ్డిక్లెంఙ్‍, గుడిక్ లెంఙ్ ఉపదేసం ఇడ్‍తన్. డపుత్ తనయ్ ముడెతన్. ");
INSERT INTO nit_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","నీ అన్న తనుంఙ్ వెల్‍సాతి? అన్ తనెన్ ముట్టనొ, అన్నె గొట్టికున్ వింతరున్ వేలుత్. అన్ ముట్ట సిమ్కన ఈ మందింఙ్ ఒర్కి ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","యేసుంద్ ఇనంఙ్ ఇనెంఙ్‍, అత్తి ఇలుత్ అనెక అదికలంతన్న ఒక్కొంద్, యేసునుంన్ తన్నె కేయ్యడ్ చెంపన్ లగపుత్, “దండి దెయ్యలక్ అదికార్‍నీ నీవియ్ సామదనం సియెకా విదనం ఇద్దియ?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","యేసుంద్ అమ్నుంఙ్ సాక్స ఇడ్‍సా, “అని ఎదెన్న గలాత్ ముడుత్‍ అండన్‍ఎరత్తె, ఆగలాత్ తానెద్ ఎందొ ఇడ్. గని, అన్ సోయ్తదున్ ఇడ్‍తన్‍ఎరత్తె, అన్ తనుంఙ్ కుడ్కసాతి!” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","మల్ల కట్త యేసునుంన్ అన్నస్ దండి దెయ్యలక్ మాల్కక్‍ కయప కున్వై పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","అప్పుడ్ సీమోన్ పేతురుంద్ ఇలుత్ కిస్‍ కంఙ్సానంసాద్. అత్తి అనెకర్ అమ్నున్, “నీ నయ్‍ అమ్నె సిసు లంతని ఒక్కొని తా?” ఇంతెర్. పేతురుంద్ ఓపెతెంద్. “తొద్‍” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","పేతురుంద్ ఎరె కేవున్ తర్గతెదొ అమ్నె సుంటం దండి దెయ్యలక్ అదికార్నె గడియక్ ఒక్కొంద్. పేతురునున్, “నీ వడిత్ అమ్నున్ వెంట అనెంఙ అన్ ఓలెతన?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","పేతురుంద్ పెనని ఓపెతెంద్. వెంటాయ్ పోత్ కూగెంఙ్. ");
INSERT INTO nit_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","కోర్ కూతంఙ్ ఔర్ యేసుకున్ కయపున్‍తన్న రోమ్ రాజదికరినే బంఙ్లా వై తోడ వత్తెర్. అద్ పస్కఅంబ తినెంఙ్ పేలె కిస్కటం ఉర్కసెట అనెకదుంఙ్ ఔర్ ఆ రోమ్‍ రాజత అదికార్నె బంఙ్లా వై సెరెతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","అదుంఙ్ ఎత్తి పిలాత్ వకల అనెకర్వై వత్న, “ఈ మన్కకన్ పొయ్ నీర్ తా నేరం తప్సాతీర్?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ఔర్ అమ్నున్, “ఇమ్ద నేరం కలెంఙ్‍ తోసెట అనెంఙ్ ఎద్దె ఇమ్నున్ ఇన్‍వై కొర్‍సెటరం” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","అదుంఙ్ ఎత్తి పిలాత్ ఔరున్, “అమ్నున్ నీరి తోడసెత్న ఇమ్మె నియమ్ సాస్త్రం ప్రకారం నీర్ న్యాయ్ కలుర్” ఇంతెంద్. యూదు, “ఎరుంఙ్‍ఎన అల్ఙెకా అదికార్ అమ్ముంఙ్ తోతెద్” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","తన్ ఎనంఙ్ తిక్‍సాదొ, అదున్ బదోల్ యేసుంద్ పేలెయ్ ఇడ్‍త గొట్టి ఎరెంఙ్ ఔర్ ఈ గొట్టి ముట్టెర్. ");
INSERT INTO nit_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","అప్పుడ్ పిలాత్ పెన రోమ్ రాజక్నె బంఙ్లంఙ్‍ సెత్న, యేసునున్ కూగుత్న, అమ్నున్, “నీ యూదులుంఙ్ రాజక్నివా?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","యేసుంద్ సమాదనం ఇడ్‍సా, “ఈ గొట్టి ఇన్నెత్ నీవి ఇసాతివా, తోద్‍ తే ఎరేనా అన్న బదోల్ ఇనుంఙ్ ఇడ్‍త్తెరా?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","అదుంఙ్ ఎత్తి పిలాత్, “అన్ యూద్‍నన్ ఇసాతివా? ఇన్నె సొత మందింఙ్‍, దండి దెయ్యలక్ అదిక్ల, ఇన్న అన్వై సియ్‍త్తెర్. నీ తాగల్‍సాతి?” ఇసా వెల్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","యేసుంద్, ఇనంఙ్ ఇంతెంద్ “అన్నె రాజ్యం ఈ దున్య‍తంద్ ఎరెద్. అన్నె రాజ్ ఈ దున్యతంద్ ఎద్దె, అన్ యూదలె కెయ్యుత్ పడ్సెటా అన్నె సిపాయిక పొరడ్‍నెర్. కరెయ్ అన్నె రాజ్యం ఈ దున్య‍తంద్ ఎరెద్.” ఇసా సామదనం ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","అప్పుడ్ పిలాత్, “ఇంతె నీ రాజక్నివా?” ఇసా యేసునుంన్ ఇంతెంద్. యేసుంద్, “అన్ రాజక్ ఇసా నీవి ఇసాతి. సత్తెం బదోల్ సాక్సం ఇడెంఙ్ అన్ జన్మ వత్తన్. అదుంఙ్ ఎత్తి అన్ ఈ దున్యంఙ్‍ వత్తన్. సత్యామున్ ఒర్కిలెకర్ ఔర్ అన్నె గొట్టిన్ విచార్” ఇసా సామదనం సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","పిలాత్ అమ్నున్, “సత్తెం ఇంతె తన్నెద్?” ఇంతెంద్. పిలాత్ యూదు వెంట్ ఇనంఙ్ ఇంతెంద్ ఈ మన్కన్ సిక్స సియెంఙ్ తనెది నేరం కన్కెరెతీన్. ");
INSERT INTO nit_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","పస్కంఙ్ జీర్ అన్ ఒక్కొనున్ సాయెకాద్‍ ఇసా నెమిప్‍తన్ తా? అదుంఙ్ ఎత్తి యూదులె రాజక్ ఇముంఙ్ సటీ సాయుర్ ఇసాతిరా? ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","అపుడ్ ఔర్ జోరనట్ వపొయ్సా, ఈ మన్కన్ తోద్. బరబ్బాన్ సాయుర్! ఇంతెర్. బరబ్బ జేలుత్ తప్‍త డొంఙ. ");
INSERT INTO nit_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","అపుడ్ పిలాత్ యేసుంనున్ సుముత్ సాట్‍లడ్ లగప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","సైనిక్ సాల్ల కొమ్ములాడ్ ముకుట్ అలుత్న, అమ్నె తల్లపొయ్ ఇడుత్ బుతాక్ రంఙ్తా జుఙ్ఙె అమ్నున్ తొడుపుత్ అమ్నున్ మెర వత్న, ");
INSERT INTO nit_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","“యూదులె రాజక్, జయాహొ!” ఇసా ఇడ్డుత్ అమ్నున్ కేయ్యడ్ కుడుక్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","పిలాత్ మల్ల వకా చేత్న మందింఙ్‍, “ఈ మన్కనత్తి ఏ అపరద్ అనుంఙ్ కన్డకెరెతిన్ ఇసా ఇముంఙ్ కరిల్‍నెత్తి ఇమ్నున్ ఇమున్‍వై వకా తోడా వర్‍సాత్” ఇసా ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","అదుంఙ్‍ ఏత్తి యేసుంద్ వాక వత్తపుడుంఙ్ సాల్ల టొపి తొడుత్న, బుతక్ జుఙ్ఙె తొడుత్న అన్సాద్. అపుడ పిలాత్ ఔరున్, ఇమ్‌దొ ఈ మన్కక్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","దండి దెయ్యలక్ లంఙ్, అదికల్ యేసునున్ ఓలుత్, “సిలువత్ కుడుకుర్, సిలువత్ కుడుకుర్!” ఇసా, వాపొయ్‍తెర్‍. పిలాత్ ఔరున్, “ఇమ్నతి అనుంఙ్ తనయ్ తప్పు కండ్కెరెద్ అదుంఙ్ ఎత్తి నీరి కొసుత్ ఇమ్నున్ సిలువత్ కుడుకుర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","యూదు పిలాతున్ ఇంతెర్, అముంఙ్ ఒక్కొ నెకి అన్సాద్, అముదు తన్నెత్ తనీ దెయ్యమ్నె పోరక్లాఙ్ ప్రచరం కల్సాద్ అదుంఙ్ ఎత్తి, ఆ జీమెదర్ సుమ్‍తే అముదు తికెంగి పాజే, ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","పిలాత్ ఆ గొట్టిన్ విత్న గుల్ అర్సతెంద్, ");
INSERT INTO nit_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","పెన న్యాయ సబంఙ్ సెత్న, “నీ ఎత్రన వాత్తి?” ఇసా యేసునున్ వెల్‍తేద్. తే అంనుంఙ్ తనయ్ ఇడెతేద్. ");
INSERT INTO nit_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","అపుడ్ పిలాత్ అమ్నడ్, “నీ అన్నాడ్ ముడెవా? ఇన్ సాయెంఙ్‍, సిలువన్ ఇదరెంఙ్‍, అనుంఙ్ అదికార్ అండదిసా ఇనుఙ్ ఒర్కితొదా?” ఇన్తేంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","యేసుంద్ సమాదనం సియ్సా, “ఇనుఙ్ దెయ్యమ్నె అదికారం పొయ్ ఇనుఙ్ వత్తె అన్ పొయ్ ఇనుఙ్ ఏద్ది అదికార్ అనేద్. అదుఙి అనుంఙ్ నీ సియ్యెకానుంఙ్ ఎక్వ పాప్ అన్సాద్” ఇన్తేంద్ ");
INSERT INTO nit_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","అపుడ్ తన పిలాత్ యేసునున్ సాయెంఙ్ ఇసా కోసీద్ కతెంద్ గని యూదకేర్ పెరున్, “నీ ఇమ్నున్ సాయ్తివింతే, రొమ రాజుఙ్ సంఙ్తక్ని ఎరే. తన్నె తానుంఙ్ రాజక్ ఇదర్‍తద్‍ రొమ రాజుఙ్ విరోద్ ముటెతి” ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","పిలాత్ ఈ గొట్టికున్ విత్న, యేసునున్ వాక తోడవత్న, గుండ్ల ఇట్ట జాగత్ న్యాయ్‍పీట పొయ్‍ ఉద్‍తెంద్. హీబ్రు బాసనడ్ ఆ జాగన్ గబ్బతా ఇసా పేర్. ");
INSERT INTO nit_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","అద్ పస్క తయార్ కత దినమ్. సింత్తెవెల కమ్మి జాస్తి దుప్పారి వెలంఙ్. అపుడ్ పీలాత్ యూదులున్, “ఇమ్దొ ఇమ్మె రాజక్!” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ఔర్ వపొయ్‍సా, “అల్గుర్, అల్గుర్, సిలువత్ వెలిడుర్!” ఇసా జోరానడ్ వపొయ్‍తెర్. పిలాత్ ఔరున్, “ఇమ్మె రాజక్ సిలువ త్ వెలిడుర్ ఇసాతిరా?” ఇంతెద్. ముడటా దండి దెయ్యలక్ అముంఙ్ రొమ రాజక్ తప్ప మరొక్కొ రాజక్ తోతెద్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","అపుడ్ పిలాత్, సిలువత్ కుడ్కెంఙ్ యేసునుంన్ ఔరున్‍వై సియ్తెంద్. అదుంఙి ఔరు యేసునుంన్ తోడ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","తన్నె సిలువన్ తన్ని కజుత్ వకా వత్న, కపర్ జాగ ఇనెకా జాగంఙ్ వతెంద్. హీబ్రు గొట్టినడ్ ఆ జాగన్ గొల్గొతా ఇనెకా పేర్. ");
INSERT INTO nit_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","అత్తి ఔర్ యేసునుంన్, ఇరువైలులా ఇద్దరుంఙ్ మన్కకెర్ నడుమున్ సిలువ త్ వెలిప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","పిలాత్, ఒక్కొ పెత్ నజరేత్ తా యేసుంద్, యూదులె రాజక్ ఇసా వయ్‍గత్న సిలువ పొయ్ వెలిటెద్. ");
INSERT INTO nit_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","యేసునున్ సిలువ వెలిప్‍త జాగ పట్నముంఙ్ మెరం అన్సాద్ పొయ్ వయ్‍తద్ కబుర్ హీబ్రు, లాటిన్, గ్రీకు గొట్టి నడ్ వాయుత్ అన్సాద్ అదుంఙ్ ఎత్తి గుల్ మంది యూదు అదున్ వసిప్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","యూదులె దండి దెయ్యలక్ పిలాత్‍ నడ్, “యూదులె రాజ్ ఇసా తోద్ గని, అముదు ‘అన్ యూదులె రాజక్నన్ ఇసా ఇడ్‍తెంద్’ ఇసా వయ్‍గలుర్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","పిలాత్, “అన్‍వాయతదుని వాయతద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","సైనికు యేసునున్ సిలువత్ వెలిప్‍త వెన్కత్ అమ్నె జుఙ్ఙెలున్ సుముత్న నాలి బాగు కత్న పయ్‍తెర్. అమ్నె పొల జుఙ్ఙెన్‍నై సుమ్‍త్తెర్. అదున్ పొయ్ కుటుత్ తోసెటా, సిమ్కన ఒక్కొ ది అండిన్ అదుంఙ్ ఎత్తి, ");
INSERT INTO nit_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ఔర్ ఒక్కొనెత్ ఒక్కొద్, “ఇదున్ నేండ్‍ ఈర్కనెర్, ఇద్ ఎరెత్ ఎరదొ ఓలెకదుంఙ్ సిటిక్ తప్‍నర్” ఇంతెర్. “అన్నె జుఙ్ఙె తమ్మెత్ తమి పైతెర్, అన్నె జుఙ్ఙెలుంఙ్ సటీ సిటిక్ తప్‍త్తెర్.” ఇనెక లేకనముత్ ఎరెంఙ్ ఇసా ఇద్ ఎద్దిన్. అదుంఙ్ ఎత్తి సైనికు అనంఙ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","యేసు అమ్మ, అమ్నె అమ్మ తోర్దా, క్లోపా మాస మరియ, మగ్దలేనే మరియ, యేసున్ సిలువ మేరం ఇల్లుత్ అండాంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","అమ్నె, అమ్మ, అముదు ఒర్కిలుత్ ప్రేమ్ కత్ సిసున్ మెరంమడ్ ఇల్లుత్ అనేరడ్ ఓలుత్, యేసుంద్ తన్నె అమ్మనడ్, “అమ్మ, ఇంద్దొ ఇన్నె కీకె” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","మల్ల ఆ సిసునుంఙ్‍, “ఇద్దొ ఇన్నె అమ్మ” ఇన్దెంద్ ఆ వెల తనట్ ఆ సిసుంద్ అదున్ తన్నె ఎల్లంఙ్‍ కుతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","అదుద్ వెన్కత్, అనిగ్నాయ్ తిర్తిన్ ఇసా యేసునున్ ఒర్కి అదుఙి, లేకనముత్ ఇడ్డెంఙ్‍, “అనుఙ్ ఆడ్తెతిలఙ్.” ఇన్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","అత్తిని అంత్ పులితా అంగుర్నెరసా దుత్తన్ రుయ్యున్ మున్సుత్, ఈ హిస్సోప్ కొమ్మున్ సుట్టుత్ అన్నె మూతి వై కొస్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","యేసు, ఆ పుల్లె అంగుర్నెరసా సుంముత్, “తిటిన్ ఎద్దిన్” ఇసా, తల్లున్ డిమ్పుత్ అన్నె ఆత్మన్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","అద్ పడ్గు తయార్ దినం. ఆలపుసేక దినముంఙ్ సెత్త సిలువ పొయ్ అనెఙ్ తోద్ అనుంఙ్ ఇంతె సబ్బతు గుల్ ముక్యమైన దినం అదుఙి, ఓరె సెత్తలున్ ఇత్తి వెల్లిప్ వెర్, అమ్నె గెట్టలున్ కిన్కుత్, ఓరున్ బొడున్ పవిడుర్ ఇసా యూదులు పిలాతున్ వేలుత్. ");
INSERT INTO nit_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","అదుంఙ్ ఎత్తి సైనికు వత్న, యేసున్ వెంట సిలువ వెలిప్త పేలెతనున్, వెన్కతనున్ గెట్టలున్ ముర్కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ఔర్ యేసుకున్ మెర వత్తె, అముదు అపుడితుంఙి తిక్‍తెంద్ ఇసా, అమ్నె గెట్టలున్ ముర్కెతెద్. ");
INSERT INTO nit_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ఇంతె, సైనిక్ ఒక్కొద్ బర్సినడ్ అమ్నె లొతిన్ ఇక్‍తెద్. వెంటాయ్ నెత్తుర్, ఈర్ వకా వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ఇదసిమ్కనన్ ఓల్‍తద్ సాక్సం ఇడ్‍సాద్. అమ్నె సాక్సం సత్తె. అముదు ఇడ్‍తద్ సత్తెం ఇసఅమ్నుంఙ్ ఒర్కియ్. ఇద్ నిర్‍నయ్ నమ్మెకదుంఙి. ");
INSERT INTO nit_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“అమ్నె బొక్కతన్న ఒక్కొద్‍నై కినియెద్” ఇనెకా లేకనముత్ ఎరెంఙ్ ఇసా ఇదవెదె. ");
INSERT INTO nit_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“ఔర్ తమున్ ఇక్‍తనున్‍వై ఓల్‍సార్.” ఇసా మరొక్కొ లేకనముత్ ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","అదుంఙ్ వెన్కత్, యూదులున్ అర్సుత్ అరినడ్ యేసునే సిసుంద్లంఙ్ అనెక అరిమతయి పట్నముత్ యోసేపు, యేసునె సెత్తన్ తన్ కొసెంఙ్ ఇసా పిలాతున్ వేలుత్. పిలాత్ ఓప్‍తెద్. అదుంఙ్ ఎత్తి యోసేప్ వత్న యేసునె సెత్తన్ తోడసెదెద్. ");
INSERT INTO nit_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","పేలె సింత్తెత వెలంఙ్ యేసున్ మెర వత్న నికోదేము నాయ్ కమ్మి జాస్తి తిస్ కిలొ కాంప్ నునె అగరు మిస్రమున్ తన్ తోడ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ఔర్ ఇద్దర్‍ యేసునె సెత్తన్ తోడవత్న అత్తరు నూనె దిటుత్, కొత్త కడ్వ జుఙ్ఙె గుడప్‍తెర్. ఇద్ యూదులె పుర్‍పెకా కాయ్‍ద. ");
INSERT INTO nit_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","అమ్నున్ సిలువత్ వెలిపుత్ అనెకా జాగత్, అత్తి ఎరుని పుర్పసెట ఒక్కొ కొత్త తప్నె అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ఆ తప్నె మెరయ్ అన్సాద్ అదుంఙ్ ఎత్తి, ఆదినమ్ యూదు తయార్ ఎరెక దినం అదుంఙ్ ఎత్తి, ఔర్ యేసునున్ అత్తి ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ఐతరం తొలినీ ఇంకా చిర్మనయ్ అనెంఙ్ మగ్దలెని మరియ తప్నె మెరమ్ వతిన్. అత్తి తప్నెత్ ఇట గుండ్ పుస్‍తదున్ ఓల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","అదుంఙ్ ఎత్తి అద్ సీమోన్ పేతురున్‍వై, యేసుంద్ ప్రేమ కత మరొక్కొ సిసుంన్‍వై తుల్‍సెత్న. ఔరున్ ఇంతిన్, “ప్రబునున్ ఎరొ తప్నెతన కొస్‍తెర్. అమ్నున్ ఎత్తి ఇట్టెరొ ఎర్కతొద్” ఇసా ఇడ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","అదుంఙ్ ఎత్తి పేతురుంద్, ఆ ఇంకొక్కొ సిసున్ వెంట్టచెత్న తప్నె మెర వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ఔర్‍ ఇందర్ మిరయుత్ తుల్‍ సెరెంఙ ఆ ఇంకొక్కొ సిసుంద్ పేతురునుంఙ్ ఎన జలద్‍ తులుత్ పేలె తప్నె మెర సెదెంద్‍. ");
INSERT INTO nit_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","అముదు ఆ తప్‍నెన్ తొంఙ్‍తోల్తెంద్. వట్టి కడ్వ జుఙ్ఙెలి అంనుంఙ్ కండ్కెద్దె. గని అముదు తప్‍నెంఙ్ చెరెతెద్. ");
INSERT INTO nit_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","అదుంఙ్ వెన్కత్ సీమోన్ పేతురుంద్ అమ్నున్ వెన్కయ్‍ వత్న తప్నెంఙ్ సెద్దెంద్. అత్తి కడ్వ జుఙ్ఙె గుడపుత్ అనెకవున్, ");
INSERT INTO nit_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","అత్తి కడ్వ జుఙ్ఙె రలుత్ అనెక, అమ్నె తలుత్ కట్‍త రుమల్ జుఙ్ఙెలి ఎరెకడ్ మరొక్కొ జాగత్ సుట్టుత్ జుఙ్ఙేలె ములాత్ అనెకాద్ ఓల్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","అదుంఙ్ వెన్కత్ పేలె తప్నెంఙ్ గదియ్‍త సిసుంద్ నాయ్ లోప సెత్న ఓలుత్న నమ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ఇంతె అముదు తిక్‍తరంతన పానం ఎరెకంది ఎరెకడ్ సుక్కిల్ సెటా ఇనెక లేకనముత్ ఔర్ ఇంక ఒర్కిలెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","అపుడ్ ఆ సిసు తిర్గుత్ తమ్మె ఎల్లక్‍లెంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","అప్పుడ్‍ మరియక్ తప్నెవాటా ఇలుత్ అర్‍సానంద్. అద్ తప్‍నెన్ గొగుత్ ఓల్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","అదుంఙ్ ఇంది దూత్ కండ్కెదే. అద తెలొడి జుఙ్ఙె తొడుత్ అడ్డెర్. యేసునె సెత్త ఇట్ట జాగత్ ఒక్కొంద్ తల్‍వై ఇంకొక్కొంద్ గెట్టపకంఙ్ ఉదుత్ అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","దూతు ఇంతె “తనుంఙ్ అర్‍సాతి అమ్మా?” ఇసా వెల్‍తె. అదుంఙ్ అద్, “ఎరొ అన్నె ప్రబున్ తోడ సెద్దెర్. అంనున్ ఎత్తి ఇట్టెరొ కరిల్‍సా తోతెద్” ఇంతిన్. ");
INSERT INTO nit_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","అద్ ఇనంఙ్ ఇంత్న వెన్కవై తిర్గుత్ అత్తి యేసుంద్ ఇలుత్ అనెకనున్ ఓల్‍తిన్. గని అద్ అమ్నున్ ఒర్కిలెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","యేసుంద్, “అమ్మా, తనుంఙ్ అర్‍సాతి? ఎరున్ కిరవసాతి?” ఇసా అదున్ వెల్‍తెర్. అద్ అమ్నున్ వడిత గడియక్ ఎన్నెంద్ ఇంతిన్. “అయ్యా, ఒక్కొవేల నీ అమ్నున్ తోడసెదివెరతె అమ్నున్ ఎత్తి ఇటివొ ఇడ్ అన్ అమ్నున్ తోడసెరత్” ఇంతిన్. ");
INSERT INTO nit_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","అపుడ యేసుంద్ అదున్ ఓలుత్, “మరియా” ఇసా కూగ్తెంద్. అద్‍అమ్నున్‍వై తిర్‍గతిన్, “రబ్బు” ఇసా కూగ్తిన్. రబ్బుఆనీ ఇనెకా గొట్టింఙ్ హీబ్రు గొట్టినడ్ గొట్టి ఇడ్డెకద్ ఇసా అర్తం. ");
INSERT INTO nit_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","యేసుంద్ అదున్, “అన్ ఇంకా బాన్వై సెరెతన్. అదుంఙ్ ఎత్తి అన్ అంట్నెర్. గని అనే దాదకేర్ వై సేత్న అన్నె బాంద్, ఇమ్మె బాంద్, అన్నె దెయ్యం, ఇమ్మె దెయ్యం అముదు అమ్నున్వై సెసాత్‍ ఇసా ఔరుంఙ్ ఇడ్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","మగ్దలెని మరియక్ వత్న సిసులున్, “అన్ ప్రబున్ ఓల్‍తన్. అముదు అనుంఙ్ ఈ గొట్టిక్ ఇడ్‍తెంద్” ఇసా అద్ ఇడ్‍త గొట్టికున్ ఇడుంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ఐతరం సింత్తె వెలా ఎద్దపుడ్ యూదులె అదికరింఙ్ అర్‍సుత్ సిసు తమ్మె గుయ్యున్ గెత్తెర్. అపుడ్ యేసుంద్ వత్న ఔరున్ నడ్‍మున్ ఇల్లుత్న, ఔరున్, “ఇముంఙ్ సాంతి ఎరెంఙ్ ఇంతెంద్.” ");
INSERT INTO nit_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","అముదు అనంఙ్ ఇడ్‍త వెన్కత్ ఓరుంఙ్ తన్నె పకతదున్ అని కేయ్యులున్ ఓలిప్‍తెంద్. ఔర్ ప్రబునున్ ఓలుత్న సిసు గుల్‍కుసీంఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","మల్ల యేసుంద్ తిర్గుత్ ఇముంఙ్ సాంతి ఎకద్ బాంద్! అన్ పన్కతెతిలంగి అన్ ఇమున్ పన్కసాత్ ఇసా ఔరుంఙ్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ఈగొట్టిక్ ఇడ్‍త వెన్కత్ అముదు ఔరున్ పొయ్ ఉద్దుత్, “పరిసుద్ద ఆత్మన్ ఎకుర్. ");
INSERT INTO nit_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","నీర్ ఎరె పాపులున్ మాప్కలెరొ ఔరె పాపులున్ మాప్కల్ ఏరె అన్సాద్. ఎర్ పాపు అనెంఙ్ ఇసారొ అదా అనాయ్ ఇలుత్‍ అంసా” ఇసా ఇడ్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","బరజన్ సిసులోపా ఒక్కొద్ నెమాక్ ఇసా తోమక్ యేసుంద్ వతెంద్‍ ఇంతె ఔరవెంటా తోతెద్. ఇమ్నున్ “దిదుమ” ఇసా కుఙ్ నెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","మిక్‍త సిసు, “అమ్ ప్రబున్ ఓల్‍తమ్” ఇసా అమ్నుంఙ్ ఇడ్‍తెర్. అపుడ్ అముదు, “అన్ అమ్నె కీరత గావున్ ఓలత్. అన్నె వెద్దెన్ ఆ గావ్‍తతి ఇడెంఙ్. అనాయ్ అన్ అన్నె కేయ్యున్ అమ్నె పకంఙ్ ఇడత్. అప్పుడి అన్ నమ్సాత్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ఎన్మిది దినాలుంఙ్ మల్ల అమ్నె సిసు లోపా అంసార్. ఈ జీర్ తోమక్ నయ్ ఔరున్ వెంట పెన కలయ్‍తెద్. గుయ్యున్ గెతుత్ అంసార్. గని అపుడ్ యేసుంద్ ఔరున్ నడ్‍మున్ వత్న, “ఇముంఙ్ సాంతి ఎకద్!” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","మల్ల అముదు తోమక్ ఓలుత్, “అన్నె కేయ్యులున్ ఓల్. ఇన్నె వెదెలడ్ అదవున్ పుడ్కు. అనాయ్ ఇనే కేయ్య సాపుత్ అన్నె పకంఙ్ ఇడ్. విస్వాసాడ్ అన్. విస్వాస్ తోసెటార్ ఎన్నెమ్” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","అదుంఙ్ వాలడ్ తోమక్, “అన్నె ప్రబు, అన్నె దెయ్యం” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","అపుడ్ యేసుంద్, “నీవ్ అన్ ఓలుత్ ఒర్కిలె. అదుంఙ్ ఎత్తి అన్ ఓల్‍సెట నమ్మెకర్, కనీర్ దన్యుల్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","యేసు క్రీస్తుంద్ ఇంకా ఎనిగొ సమత్కల్ తన్నె సిసు ముండట్ కతెంద్. అదా సిమ్కనన్ ఈ పుస్తకుత్ వాయెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","గని యేసు దెయ్యమ్నె పోరక్ క్రీస్తుంద్ ఇసా నీర్ ఒర్కిలెంఙ్ నమ్ముత్ అమ్నె పేరడ్ పానం రొంబడెంఙ్ ఇద సిమ్కన వయెకవెదె. ");
INSERT INTO nit_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","అదుంఙ్ వెన్కత్ తిబెరియ సందూర్‍ మెర యేసుంద్ పెన తన్నె సిసులుంఙ్ కండ్కెద్దెద్. ఇనంఙ్ జర్గిల్తిన్. ");
INSERT INTO nit_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","సీమోన్ పేతురుంద్‍, దిదుమ ఇసా కుగెక తోమక్, గలిలీయ త్ కానా పట్నముంఙ్ తక్త “నతనేల్, జెబెదయినె పోరకేర్ మరొక్కొర్ ఇద్దర్ సిసు, సిమ్కన కలయుత్ ఒక్కొత్తి అన్సార్.” ");
INSERT INTO nit_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","సీమోన్ పేతురుంద్‍, “అన్ కయ్యేసుమ్మేంఙ్ సెచత్” ఇసా ఇంతెంద్. మిక్‍తర్, “అమ్‍నయ్ వర్సతుమ్” ఇసా ఇనెంఙ్ సిమన మంది కలయుత్ సెత్న రూకుత్ సొక్తెర్. గని ఆ సింత్తె ఔరుంఙ్ కయ్యె రొంబడెతే. ");
INSERT INTO nit_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","పొద్ కురియెకా వెలంఙ్ యేసుంద్ డర్డివై ఇలుత్ అన్సాద్. గని సిసు అముదు యేసుంద్ ఇసా ఇనెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","యేసుంద్, “సంఙ్తకెరార! కయ్యె రొంబట్టెవా?” ఇసా వెల్‍తెంద్. “తొద్” ఇసా ఔర్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","అముదు, “రూకుంఙ్ ఉన్న పకంఙ్ ఇమ్మె జార్ తపుర్. ఇముంఙ్ కయ్యె రొబడ్‍సా” ఇసా ఇంతెంద్. ఔర్ అముదు ఇడ్తెతియ్ జలున్ తప్తెర్. కయ్యె ఎక్వు జరుత్ పట్టదుంఙ్ వాలడ్ ఔర్ ఆజలున్ తివెంఙ్ సాలెతెర్. ");
INSERT INTO nit_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","యేసుంద్ ప్రేమ్ కత్త సిసు పేతురునున్, “ఇమ్దో ఓల్ ప్రబుద్” ఇసా ఇంతెంద్. సీమోన్ పేతురుంద్, “ఇమ్దో ప్రబుద్!” ఇసా ఇనెకదున్ వింత్ వెటని, ఇండి దూక్ పుస్త తన్నెపొల జుఙ్ఙెలున్ ముల్కెత్ సుటుత్న ఇరుత్ ఉర్కతెద్. ");
INSERT INTO nit_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","మిక్త సిసు జాగత్ కమ్మి జాస్తి నుర్ మూరా దవ్ అన్సార్. అదుంఙ్ ఎత్తి ఔర్ కయ్యెలాడ్ నిడ్ తా జాల్లున్ తివ్‍సా రూకున్ అడ్గిప్‍సా డర్డింఙ్ గదియ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ఔర్ రుక్ జాగత్ డిగెంగయ్‍ సుడెక పొయులెంఙ్ కయ్యె అనెకవున్ ఓల్తెర్. కొన్ని నిపల్నయ్ అత్తి అన్సావ్. ");
INSERT INTO nit_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","యేసుంద్ ఔరున్ “నీర్ సుమ్‍త కొన్ని కయ్యెలున్ తోడ వర్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","సీమోను పేతురుంద్ రూకుత్ సొకుత్ జారున్ జాగత్ తివ్‍తెర్. ఆ రూక్‍ నిండ దండి కయ్యె లంసా. సిమ్కన నూట పన్సముది కయ్యె అన్సా. అని కయ్యె అనెకా జార్ ఇరియెతిన్! ");
INSERT INTO nit_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","యేసుంద్ ఔరున్, “వర్! వత్న తిన్‍డ్ర” ఇసా ఇంతెంద్. “నీర్ ఎర్” ఇసా వెలుత్‍ ఓలెంఙ్ సిసులంఙ్ ఎరుంగి దైర్యం ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","యేసుంద్ ఔరున్వై వత్న, నిపట్టెన్ సుముత్ ఔరుంఙ్ సియ్తెంద్. అనాయ్ కయ్యెలున్‍నాయ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","యేసుంద్ తిక్తతన బత్కిప్సాంద్ తన్నె సిసులుంఙ్ కన్కెరెకద్ ఇద్ ముదిగుసాల్. ");
INSERT INTO nit_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ఔరె తినెకద్ ఎద్దతి యేసుంద్, సీమోన్ పేతురున్, “యోహాన్ కీకె సీమోన్! ఇవ్రుంఙ్ ఎన అన్న నివ్ ఎక్వ ప్రేమ్ కల్సత్‍ ఇసా ఇనుంఙ్ కరిలెదా?” ఇసా ఇంతెంద్. “ఆయ్ ప్రబుంద్ ప్రేమ్ కల్‍సద్ ఇసా ఇనుంఙ్ కరిలెదా!” ఇసా ఇంతెంద్. యేసుంద్, “అన్నె గొర్రెనె కొవ్వె మెప్!” ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","యేసుంద్, “యోహాన్ కీకె సీమోన్! నీ కరెయ్ అన్ ప్రేమ్ కల్‍సాతివా?” ఇసా పెన వెల్తొల్తెద్. అముదు, అయ్ ప్రబు! అన్ ఇన్‍ ప్రేమ్ కల్‍సాత్ ఇసా ఇముంఙ్ ఎర్కతొదా! ఇసా ఇంతెంద్. యేసుంద్ “అన్నె గొర్రెలున్ సోయ్‍ఓల్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ముదిగుసాల్ అమ్నున్, “యోహాన్నె కీకెన్‍ సీమోన్! అన్ ప్రేమ్ కల్సతివా?” ఇసా ఇంతెంద్. ముదిగుసాల్, “అన్‍ ప్రేమ్ కల్సాతివా” ఇసా వెల్తదుంఙ్ పేతురునే మన్ ఓయ్‍తిన్ “ప్రబు! ఇనుంఙ్ సిమనాయ్ ఒర్కి. అన్ ఇమున్ ప్రేమ్ కాల్సాత్ ఇసానయ్ ఒర్కియ్” ఇసా ఇంతెంద్. యేసు, అన్నె గొర్రెలున్ మెయప్! ");
INSERT INTO nit_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ఇద్ కరెయ్. జవన్ అనెంఙ్ ఇన్నె జూంగెలున్ నీ తొడుత్న ఇన్నె మనుంఙ్ వత జాగంఙ్ చెరెకనివ్ ఎన్ని. గని వయస్ ఎద్దతీ నీ కేయ్ సాప్‍తె మరొక్కొర్ నీన్ జుఙ్ఙె తొడుత్ ఇనుంఙ్ ఇస్టం తోసెట జాగంఙ్ తోడ సెద్దెర్ ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","పేతురుంద్‍ ఎనంఙ్ తిక్కుత్ దెయ్యమ్నె మహిమ కొద్తెంద్ ఓలిపెంఙ్ ఇసా యేసుంద్ ఇనంఙ్ ఇంతెంద్. అదుంఙ్ వెన్కత్ అమ్నున్, “అన్ వెంటావా!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","పేతురుంద్ వెన్కవై తిర్గుత్ ఓల్‍తెద్. యేసుంద్ ప్రేమ్ కత్త సిసుంద్ వెంట వరెకనున్ ఓల్‍తెద్. తినెకా వెలంఙ్ యేసునున్ అమ్నున్, “ప్రబు! ఇన్‍ ఎర్ సుమ్ముత్ ఇయ్తెంద్!” ఇసా వెలుత్ ఓల్‍తద్ ఇమ్‌ది. ");
INSERT INTO nit_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","పేతురుంద్ అంనున్ ఓలుత్ యేసున్, “ప్రబు! అమ్నె గతి తనెద్?” ఇసా వెలుత్‍ఓల్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","యేసుంద్ ఇంతెంద్, “అన్ మలయుత్ వంనంత్తెంఙ్ అముదు బాత్కుతి అనెంఙ్ ఇసా అనుంఙ్ ఇస్టమండె! ఆదున్ బదోల్‍ ఇంనుంన్ తగలెకద్. నీ అన్న వెంటా వా!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","యేసుంద్ ఇనంఙ్ ఇన్నెకదుంఙ్ వాలడ్ ఈ సిసుంద్ తికెద్ ఇసా వాద దాదక్ కెర్‍ అముదు తికెద్ ఇసా ఇనెత్తెర్. అముదు, “అన్ మలయుత్ వంనంత్తెంఙ్ అముదు బత్కుత్ అనెంఙ్ ఇసా అన్నె విచార్ అండినింత్తె అదున్ బదోల్ ఇనుంఙ్ తగలెకద్?” ఇసా ఇంతెంద్, అత్తెయ్. ");
INSERT INTO nit_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ఇదున్ బదోల్ సక్సం ఇడ్‍తద్, వయ్‍తద్ ఈ సిసుది. అమ్నె‍ సాక్సం సత్తెం ఇసా నేండుంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","యేసుంద్ కత్త పనిక్ ఇంక్క పేల్లె అంసా. ఆద సదర్ సోయ్ వయ్‍తె పుస్తకుత్ లత్తి ఈ బూమి పురలెద్‍ ఇసా అనుంఙ్ కరిల్‍సాద్.");
INSERT INTO nit_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","తియొపిలా, యేసుంద్ తన్ నివ్డిప్త అపొస్తులుంఙ పరిసుద్ద ఆత్మనడ్ నిడ్త వెన్కత్ ప్రియమైన అన్నె తియొపీంఙ్‍, అన్ అన్నె పేలె పుస్తక్ యేసుంద్ కత్త సిమ్కన, ఇడ్తాదున్ ఓర్కిలుత్న అమ్దు పరలోకాముంఙ్ తోడసెరెకా వేల దూక్ ఎద్దవున్ సిమ్కన వాయ్తాన్. ");
INSERT INTO nit_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","అమ్నున్ పరలోకాముంఙ్ కొసెంఙ్ పేలెయ్ పరిసుద్ద ఆత్మనె మయిమనడ్ తాన్ ఆసుత్ అపొస్తులున్ ఔరుంఙ్ ఆగ్య సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","అమ్దు తిక్తా వెన్కత్ ఔరుంఙ్ కన్కేత్న అన్ బత్కుతి అన్సాత్ ఇసా ఏనీగొ రితిక్లున్ ఓలిప్తెంద్. ఔరుంఙ్ సాలిస్ దిన దూక్ కన్కేత్న దెయ్యమ్నె రాజ్యం బదోల్ బొదా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ఔర్ సదార్ ఒక్కొజాగత్ మిరయుత్ అనెకా అమ్దు ఔరున్ కలయుత్ ఇనంఙ్ ఆగ్య సియ్తెంద్. “యెరూసలేమ్ పట్నమున్ సాయుత్ సెన్నెర్. అన్నె బానె వాగ్దానున్ కత్త వారముంఙ్ సటీ పవొలుర్. అదుంఙ్ వాలడ్ అన్ ఇముంఙ్ పేలెయ్ ఇడ్‍తన్. ");
INSERT INTO nit_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","యోహాన్ ఈరడ్‍ బాప్తిస్మ సియ్తెంద్. గని కొన్ని దినాలడ్ నీర్ పవిత్ర ఆత్మానడ్ బాప్తిస్మ సుమ్తిర్.” ");
INSERT INTO nit_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","అపొస్తు సదర్ మిర్యతె, “ప్రబు! నీ ఈ వేలంఙ్ ఇస్రాయేల్ మందింఙ్ రాజ్యం మున్ పెన సియ్సాతివా?” ఇసా యేసునున్ వేల్త్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","యేసుంద్ ఔరున్ తాక్ తన్నె అదికారడ్ కాలము వెల దినలున్ నెమిప్తెంద్. గని అదవ్లున్ ఓర్కిలెకా అవసరం ఇముంఙ్ తొతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","గని పవిత్ర ఆత్మ ఇమున్ పొయ్ వత్తినింత్తె ఇమత్తి తాకత్ వరద్. నీర్ పేలె యెరూసలేముత్, యూదయ, సమరయ సిమ్కన జాగలెంఙ్ తోద్ గని బూమి ఆక్రిదూక్ అన్నె బదోల్ సాక్సి సియ్‍దర్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ఇనంఙ్ ఇడెఙయ్ ఔరె కడ్ల ముడటి అమ్దు పరలోకముంఙ్ సెద్దంద్ ఔరుంఙ్ కన్కెర్సెట ఒక్కొ డమ్మ వత్తిన్ అని అమ్నున్ ముస్తీన్. ");
INSERT INTO nit_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","అమ్దు సెరెంఙ్ ఔర్ ఆబార్వై ఓల్సని అన్నెర్. ఆ వెలంఙ్ తేలొడి జుఙ్ఙె తొట్టెర్ ఇద్దర్ మాన్కకెర్ ఔరున్ పకంఙ్ ఇల్లుత్ ");
INSERT INTO nit_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ఔరున్ అనంఙ్ ఇడ్తెంద్ “గలిలీయ తా మంది! అబారున్ ఓల్సా తానుంఙ్ ఇల్తిర్? ఇమున్ తానా పరలోకం వై తోడసెద్ద ఈ యేసుంద్ ఇమున్ ఓల్సఅడ్గు అపుడ్ పరలోకం వై సెత్ అనైయ్ తిరుగుత్ వర్సంద్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","అదుంఙ్ వెన్కత్ అపొస్తు ఓలీవల మెట్తన యెరూసలేముత్ తిరుగుత్ వత్తెర్. ఈ మేట్ తన యెరూసలేమ్ కమ్మి జాస్తి ఒక్కొ కిలొమిటర్ దావ్. ");
INSERT INTO nit_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ఔర్ అనెక ఎల్లత్ సెద్దెర్ వాత్ పొల కోలింఙ్. అత్తి అనెకర్ అపొస్తు ఎరెన్నెర్ ఇంతెర్. పేతురు, యోహాన్, యాకోబ్‍, అమ్దు రెయక్, పిలిప్పు, తోమక్, బర్తొలొమయి, మత్తయ్, అల్పయి పోరక్ యాకొబు ఉద్యమ ఎద్ద సీమోన్, యాకోబ్నె పోరక్ యూదక్. ");
INSERT INTO nit_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ఇవ్రు సిమ్కన మిరయుత్ ఒక్కొ మన్నాడ్ ఎప్పుడి పార్తన కల్సానన్నెర్. కొన్సెం మంది పిల్లక్, యేసుంద్ అమ్మ మరియక్, యేసునె దాదకేర్ గినా ఇవ్రడ్ అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","కొన్నీ దినా వాలడ్ బక్తకెర్ సిమ్కన మిరయుత్ అన్నెర్. ఔరె సంక్య కమ్మి జాస్తి నుటాఈర్వె దాదకేర్ మంది అలయుత్ అనెఙ. పేతురు ముడెంఙ్ ఇసా ఇల్లుత్ అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","యేసుంద్ ఔరడ్ ఇనంఙ్ ఇంతెంద్, “అన్నె దాదకేర్” తొల్లినిత కాలంబుడాద్ పవిత్ర ఆత్మ యూదున్ సిమ్కన దావిద్నె నీతివాలడ్ ముట్టెంద్. ఆ లేకనడ్ కొండపుత్ ఔరుంఙ్ పావ్ ఓలిప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","యూద నెడున్ లోపా ఒక్కొంద్. ఇముదు నెడున్ వెంట పనికలెకాంద్‍ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","యూదక్ ఇదర్త అన్యాయ్ వాలడ్ కమప్త బకినడ్ ఒక్కొ బూమి సుమ్తెంద్. యేసుంద్ సిదుర్ గొగ్గుత్ రాటెంద్ మెన్ ఓడుత్ పేగుసదర్ వకా వత్తే ");
INSERT INTO nit_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","యెరూసలేమ్‍ తార్ ఔర్ సిమనా మంది అదున్ బదోల్‍ వింత్తెర్. అదుంఙ్ ఎత్తి తమ్మె గొట్టినాడ్ ఆ బూమిన్ అకెల్దమ్ ఇసా ఇనేర్. ఇద్నె అర్తమ్ “నెత్తుర్నె బూమి.” ");
INSERT INTO nit_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","పేతురుంద్‍ ఇంకా ఇనంఙ్ ఇన్తెంద్. ఇదున్ బదోల్ కిర్తనల పుస్తకముత్ ఇనంఙ్ వాయుత్ అన్సాద్, అమ్నె ఎల్ల కరాబ్ ఎరెంఙ్ ఇడుర్ అత్తి ఏరి బత్కసెటా సెరేంఙ్ ఇడ్, “అమ్నె జాగత్ మరొక్కొనున్ అనెంఙ్ ఇడ్ ఇనంఙ్ వాయుత్ అండద్.” ");
INSERT INTO nit_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ఇడ్డి పెనొక్కొద్ నేండ్‍ వై వారెంఙ్. అముదు ఔరుంఙ్‍, ఎన్న యేసుంద్ నేండ్‍ వెంటా కలయుత్ బత్కనంత్తెంఙ్ నేండ్ వెంటా కలయుత్ అనెకార్ తన ఒక్కొద్ ఎత్న అనెంఙ్.” ");
INSERT INTO nit_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","అముదు యేసు ప్రబునున్ తిక్ తార్ బత్కసార్ వత్ అనెకదున్ నెడత్తి కలయుత్ సాక్సం ఇడ్డెంఙ్. యోహానున్ బాప్తిస్మ సియ్యెకాదున్ మొదలిటాతన యేసున్ నేడతన పరలోకాముంఙ్ తొడసెక దినం వరెఙ నేడడ్ మిరయుత్ బత్కెకద్. ");
INSERT INTO nit_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ఔర్ ఇద్దరి పెర్లున్ ఆదికత్తెర్. బర్సబ్బా ఇసా కుగెకాద్ యోసేప్ మరొక్కొ పేర్ ఇమ్నుని యూస్తు ఇసా ఇన్నెర్, మత్తీయ. ");
INSERT INTO nit_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","సాట్టం మిరయుత్న ఇనంఙ్ పార్తన కత్తెర్, “ప్రబు! ఇనుంఙ్ ప్రతి ఒక్కొనె మన్ ఒర్కి యూద అమ్నె జాగన్ సయుత్ అముదు సెరేకాద్ జాగంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","యూద ఈ ఇద్దర్ తన అపొస్తులాఙ్‍, ఈ సేవా జాగన్ అక్రమించెంఙ్ నివ్ అస్ తాదున్ అమ్నున్ అముంఙ్ ఓలిప్.” ");
INSERT INTO nit_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","అద్ ఎద్ద వెన్కత్ ఔర్ చిట్టిక్ తప్తెర్. ఔర్ పుస్త చిట్టిత్ మత్తీయ పేర్ వయ్త అన్డిన్. అదుంఙ్ ఎత్తి అమ్దు ఆ పదకొండుమంది నాత్తి అపొస్తులున్ ఎద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","పెంతెకొస్తు ఇనెకాద్ పండ్గు వత్తిన్. ఆ దినం విస్వాసు సిమ్కన ఒక్కొ జాగత్ మిరయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","వెంటాయ్ జోరనాట్ వరెకా గాలినె సపుడ్ ఆబార్తన వెంట్టయ్‍ ఔర్ ఉద్దుత్ అన్నెక ఎల్ల సిమ్కన నిండ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","అపుడ్ ఔరున్ కిస్నె నెగడి కన్కెద్దె. అని ఎడలుత్ ప్రతి ఒక్కొ నత్తి డిగ్తె. ");
INSERT INTO nit_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","సిమ్కన మంది పరిసుద్ద ఆత్మనాడ్ నిండుత్ తమ్మె గొట్టిక్ ఎరెకాడ్ మరొక్కొ గొట్టినడ్ ముడెంఙ్ ఎద్దెర్. ఔరె సక్తి ముడెకాదుంఙ్ సియ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ఆర్ రోజులుంఙ్ ఆబార్ బుడున్ అన్నెక అర్ ప్రాత ఆ మందిన్ వలడ్ వతా బక్తకెర్ యూదూ యెరూసలెముత్ బత్కసా అన్డెర్. ");
INSERT INTO nit_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ఆ గొట్టిత ఆవజున్ విత్న ఒక్కొ పెరెత్ మందినే గర్ది ఆత్తి వత్తిన్. మందితర్ అర్ మన్కక్ సొత గొట్టినడ్ ఔర్ ముడెకాదున్ విత్న కామల్‍ ఎదేర్. ");
INSERT INTO nit_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","“అవ్రు గుల్ఎత్న గాబ్రిలుత్ ముడెకార్ సిమ్కన గలిలీయ తరియా? ");
INSERT INTO nit_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","అనంఙ్ అండె, నేండ్‍ లోపా అనెకార్ ఒక్కొద్ ఒక్కొద్, తమ్మె గొట్టినడ్ ముడెకదున్ ఎనంఙ్. ");
INSERT INTO nit_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","అమ్, ఇంతె ‘పార్తి’ దేస్తరం, ‘మాదీయు’ దేస్తరం, ‘ఏలమీ’ దేస్తరం, మెసపటెమియాత్, యూదయ, కప్పదొకియ, పొంతు, ఆసియ. ");
INSERT INTO nit_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","మల్ల ప్రుగియ, పంపూలియ, ఐగుప్తు జాగలకెర్, ‘లిబియ’ తా ‘కురేనే’ మెరా అనెకా జాగా తన వత్తర్, రోమ్ దేసం తన వత్తర్ ఔర్, ");
INSERT INTO nit_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","యూదూ, యూదు ఎర్సెటర్ యూదులత్తి కలయ్‍తర్, క్రేతుయుల్, అరెబియ తర్ ఔర్ దెయ్యంన్నె ఇదర్త దండి కార్యలున్ బదోల్ అమ్మె సొతా గొట్టినాడ్ ఇడ్డెకరున్ విసతుమ్త!” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ఇంతె సదార్ కమాల్‍ ఎత్న ఎదెని గమిల్సెట “ఇద్ తనెదొ” ఇసా ఒక్కొనెత్ ఒక్కొంద్ ఇడ్తేర్. ");
INSERT INTO nit_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ఇంతె “గుల్ ఉత్న కల్ అన్సార్” ఇసా కొన్సెం మంది గమత్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ఇదున్ విత్న పేతురుంద్ హక్ర మందినడ్ సులుత్, జోరకత్ వపొయ్‍సా మందిన్ ఓల్‍సా ఇసాద్ యూదియ కలెకా మన్కకె రా! యెరూసలేముత్ బత్కసాత్ అన్న ఇదున్‍ బదోల్ ఇడెంఙ్ ఇడుర్ అన్ ఇడ్డెక గొట్టిక్ సోయ్ విడ్ర. ");
INSERT INTO nit_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","నీర్‍ ఇన్‍త్తెతి ఇవ్రు ఉనెత్తెర్. పంగి ఇక్క తొలిని తొమ్మిది నాయ్‍ ఎరెతిన్‍ తా! ");
INSERT INTO nit_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ఇదున్‍ బదోల్ యోవేలు ప్రవక్త కెర్ ఇనంఙ్ వాయ్త్తెరద్ అదుంఙ్ ఎత్తి ఇదా జర్గిల్‍దా. ");
INSERT INTO nit_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","దెయ్యం ఈ రకలాడ్ అన్సంద్. ఇదా ఆక్రి దినాలుంఙ్ అన్ మన్కకెర్ సిమ్కన పొయ్ అన్నె ఆత్మన్ ఊరుక్సత్! ఇమ్మె పోరకేర్ పిల్లక్ అన్నె గొట్టి ఇడ్దర్! ఇమ్మె ఇన్ని గొల్లొ సొయ్యత నియమున్ ఓల్సాత్. మనున్ ఓల్త ఇమ్మె దొడ కల ఓల్దర్‍. ");
INSERT INTO nit_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","గడియకెర్ అని రప్తిరసిక్ ఇనెక బెదం తోసెటా అన్నె సందేస్ సింకన ఆ మన్ లోప అన్నె ఆత్మం ఓలిప్దర్ అపుడ్ ఔర్ అనె సందేస్ ఇడ్దర్. ");
INSERT INTO nit_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ఆబార్‍ పొదె అన్ చమత్కర్ ఇదర్సత్ బూమి పొయ్ సిన్న ఓలిపత్. నెత్తుర్, కిస్ దేగడ్, సిర్మనా వెల్ఙు ఎర్సద్. ");
INSERT INTO nit_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ప్రబుద్ వరెంఙ్ పేలె పొద్ కారి ఎర్సాద్. నెల ఎర్రొడి నెత్తుర్ లంఙ్ ఎర్సాద్. ");
INSERT INTO nit_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","అపుడ్ ఎద్ ఎన ప్రబునె పేరడ్ కూగ్సరొ ఔరున్ ప్రతి ఒక్కొనున్ దెయ్యం బత్కిప్సంద్. ");
INSERT INTO nit_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","ఇస్రాయేల్ మన్కకెర్! ఇదున్ విండ్రు, దెయ్యంన్నె నజరేత్ బత్కెకర్ యేసున్. తన్నె సమత్కలున్ ఇముంఙ్ సటీ ఓలిపెక పనిక్ ఓలెకా ఇమున్ నడుమున్ ఇదర్ గత్న అముదు తనుంఙ్ ముదర్వై ఓలిప్తెంద్ ఇసా ఇముంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","దెయ్యముంఙ్ మనుంఙ్ వనెంత్తి అముదు యేసుంద్ ఇముంఙ్ అర్పన కలెకంద్ ఎద్దెంద్. ఆ ఎద్దతి నీర్ దుస్మాండ్ల అండతీర్ మదతాడ్ అమ్నున్ సిలువ కంబత్ ఇడుత్, కిరా లగపుత్ అమ్నున్ అల్ఙంతెర్. పేలెయ్ నిర్నయ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","గని దెయ్యం అమ్నున్. తిక్కెక తన పానం ఎర్గతెంద్. తిక్కెక సక్తిన్ పుస్సుత్ తికెకద్ అంనున్ కొడపుత్ అపెంఙ్ సాలెద్. ");
INSERT INTO nit_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","దావిద్ యేసున్ గురించి ఇనంఙ్ ఇంతెంద్, “అన్ ఎప్పుడిప్రబున్, అన్ ముండట్ ఓల్తన్. అముదు అన్నె ఉన్న మెర అన్సాద్ అన్ ఎప్పుడి మెలగెంఙ్ సాలెర్! ");
INSERT INTO nit_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","అదుంఙ్ తే అన్నె మనుత్ కుసీ నిండుత్ అండాద్. అదుంఙ్ తే అన్నె సరీర్ ఎప్పుడు ఆసనాడ్ బత్కసన్సంద్. ");
INSERT INTO nit_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","తనుంఙ్ ఇంతే, అన్నె ఆత్మ పాతాలముంఙ్ వెంట అన్నెద్ నివ్ ఇన్నె బరొస త సేవకున్ తప్నెత్ కరాబ్ ఎరెంఙ్‍ ఇడెవ్. ");
INSERT INTO nit_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","అనుంఙ్ పానం పవున్ ఓలిప్తి! అన్ వెంట అంత్ అనుంఙ్ కుసీంఙ్ కొత్తి!” ");
INSERT INTO nit_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","దాదకేర్, నెడే కూమ్తంద్ ఎద్దద్ దావిద్. గురించి అన్ ఎద్ కరె ఎంద్ ఇసా ఇడ్డెంఙ్ సాలత్. అముదు తిక్తెంద్. అమ్నున్ పుర్తెర్, అమ్నె తప్నె పఙ్ఙి గీ అన్సంద్. ");
INSERT INTO nit_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","దావిద్ ఒక్కొంద్ గొట్టి ఇడ్డెకాద్. దావిద్నె వంసాముత్ జాన్మిల్ తనటి సింహాసనం పొయ్ ఉద్దెకంద్ ఎద్దన్ ఇసా దెయ్యం అమ్నున్ ఒట్టు ఇదర్తెంద్. ఇద్ దావిదుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ఇద్ జర్గిల్తదున్ అదున్ గురించి దావిదుంఙ్ పేలెయ్ ఒర్కి. అదుంఙ్ ఎతి అముదు క్రీస్తు పాతాలముంఙ్ జాగత్ అనేతెంద్ అమ్నె సెత్తత తప్నెత్ కరాబ్ ఎరెతిన్ ఇసా దావిద్ అమ్నె సులెకదున్ బదోల్ పేలెయ్ ఇడ్తెంద్ తిక్తార్ బత్కతర్ గురించి ఇనంఙ్ ఇన్తెంద్. దెయ్యం అమ్నున్ తప్నెత్ సయెత్తెంద్, ");
INSERT INTO nit_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","అదుంఙ్ తే దెయ్యం ఇద్ యేసున్ తిక్తతనా బత్కతెంద్. ఇదుంఙ్ అమ్ సిమ్కన మంది గావ. ");
INSERT INTO nit_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","అంనున్ సులుపుత్ దెయ్యం ఉన్నపక్కంఙ్ ఉద్దుత్. బాంద్ ఇనెక దెయ్యం సియ్త వాగ్దానం కత్త నేండ్ ఓల్తద్ వింతద్ ఈ వరమ్ అన్వలడ్ రొంబడుత్ నేండుంఙ్ సియెకద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","దావిద్ పరలోకముంఙ్ సెరెతెంద్ గని సెసెటాయ్ “ప్రబున్ అన్నె ప్రబునున్ వెంట, అన్ ఇన్నె విరోద్ ఇన్నె గెట్ట ఇడ్డెక పిటాత్ కొస్‍నంతెత్ నివ్ అన్నె ఉన్న పకంఙ్ అన్!” ");
INSERT INTO nit_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“అదుంఙ్ ఎతి ఇస్రాయేల్ మన్కకెర్ సిమ్కన ఇద్ పని కరేయ్ ఒర్కిలెంఙ్. దెయ్యంన్నె, నీర్ సిలువత్ తప్పుత్ అలంఙ్త ఈ యేసున్ దెయ్యం లంఙ్‍, ప్రబుద్ క్రీస్తులంఙ్ కరెయ్ నేమిల్తెంద్.” ");
INSERT INTO nit_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ఇదున్ వింత్ మందినె మన్ల మెలగ్తెవ్. ఔర్ పేతురున్ మల్ల మరొక్కొ అపొస్తులున్, “దాదకేర్! అమ్ తనె కద్దున్?” ఇసా వెల్తెంద్ ");
INSERT INTO nit_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","పేతురు ఇనంఙ్ ఉత్తర్ ఇడ్తెంద్, “ఇమ్మతి ప్రతి ఒక్కొంద్ పాప్నె మపి మిసెమడ్ పాపులున్ సాయుత్ మన్ బద్లిపుర్ పొందుత్ యేసు క్రీస్తునె పెరడ్ బాప్తిస్మ సుమ్మెంఙ్. అపుడ్ తె ఇమ్మె పాపులె మాప్కతెంద్. ఇముంఙ్ పవిత్ర ఆత్మన్ వరం రొబడద్. ");
INSERT INTO nit_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","దెయ్యంన్నె ఇద్ వాగ్దానున్ ఇముంఙ్ సటీ, ఇమ్మె సన్తనమున్ సటీ, ప్రబుంద్ ఔర్ సిమ్కన మందింఙ్ కూగ్తెంద్.” ");
INSERT INTO nit_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ఔరుంఙ్ ఎన్నిగొ గొట్టిక్ వాలడ్ సాక్సం ఇడ్తెంద్. అంతెయ్ తోద్ గని, ఔరడ్ ఇనంఙ్ వింతి కత్తెంద్, “వక్రద్దులున్న ఇద్ తరం ఔర్తన ఎడలుత్ రక్సన పొంన్దుత్!” ");
INSERT INTO nit_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","అమ్నె గొట్టిన్ ఒర్కిల్తర్ ఔర్ బాప్తిస్మ సుమ్తెర్. ఆ దినం అంజెద ముది అజ్జాల్ మంది ఆత్మ విస్వాసున్ గదితెర్. ");
INSERT INTO nit_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ఔర్ అపొస్తులున్ బొదన్ వినుత్ మిరయెకత్తిన్, నిపట్టెన్ ముర్కుత్ బగ్ సుమెకరె; పార్తన అనెకర్. ");
INSERT INTO nit_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","అప్పుడ్ ప్రతి ఒక్కొనున్ దెయ్యం ఆత్మ అపొస్తులున్ వాలడ్ ఎన్నిగొ రంఙ్ రాంఙ్త సమత్కలున్ క్రియలూ ఇదరుత్ ఓలిప్తెంద్. ప్రతి ఒక్కొనత్తి దెయ్యంన్నె అర్రి అంట్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","నమ్తర్ సిమ్కన కలయుత్ తముంఙ్ రొబటద్ సిమ్కనన్ ఇటెర్ ");
INSERT INTO nit_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","తమ్మె ఆస్తిన్, సామనున్ విరుత్ అవ్సరమ్ అనెకరుంఙ్ సియెకర్ ఔరు. ");
INSERT INTO nit_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ప్రతి దినం ఒక్కొది మనడ్ మందిరుంఙ్ ఒక్కొది ఉద్దేసడ్ మిరయ్నెర్. ఎల్లత్ మిరయుత్ తినెకదున్ పైయుత్ తినెకర్. సోయ్తమన్నడ్ గుల్‍ కుసినడ్ బత్కనేర్, ");
INSERT INTO nit_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","దెయ్యమున్ స్తుతి కలెకర్. మంది సిమ్కన ఔరుంఙ్ కృప రొబటిన్ ఇసా ఇస్టపడ్నెర్. ప్రబుంద్ బత్కిప్తర్ ఔర్ విస్వాసులున్ వెంటా వతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ఒక్కొ జీర్ పేతురున్, యోహాన్ నున్ దుప్పరి మూది గంట లెద్దత్తి మందిర్ వై సెసనండార్. అద్ పార్తన త వెల. ");
INSERT INTO nit_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ఒక్కొద్ పుట్త కుంటిన్ అమ్మున కొన్సెం మంది రొజి ఒఙుత్న సౌందర్య ఇనెక మందిర్‍ కవాడ్ మెర అప్నేర్. అముదు మందిరుంఙ్ సెరెంఙ్ వరెంఙ్ కలెకరున్ ఆ కుంటింద్ బిచ్చెం ఎక్సనన్నెద్. ");
INSERT INTO nit_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ఈ కుంటిన్, పేతురు యోహాన్ న్నె మందిరుంఙ్ సెరెంహ ఓలుత్ ఔరున్ బిచ్చెం వేల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","పేతురు యోహాన్ అమ్నున్వై ఓలుత్ “అమున్వై ఓల్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ఇంతె అముదు ఔరె తనేన్ సియ్సార్ ఇసా అసానడ్ ఔరున్వై ఓల్తెంద్‍. ");
INSERT INTO nit_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","అప్పుడ్ పేతురు, “అన్నతి బఙ్ఙర్, వెండి తోతె గని అన్నతి అనెక ఇనుంఙ్ సియ్సత్. నజరేత్ బత్కెకర్ యేసు క్రీస్తునె పెరడ్ అడ్గ!” ఇసా ఇంతెంద్, ");
INSERT INTO nit_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","అప్పడు అమ్నె తినెక కెయ్యున్ సుమ్ముత్ ఇల్పుతెంద్. వెంటని ఆ కుంటిన్ కిల్సె, గెట్టలుంఙ్ తాకత్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","అముదు నెగయ్సా ఇల్లుత్ అడ్గెంఙ్ మొదలిట్టెంద్. ఇద్ది పేలె అముదు అడుగ్స వపొయ్‍సా దెయ్యముంఙ్ స్తుతి కల్స ఔరడ్ మందిరముంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ఔర్ సిమ్కన అముదు అడ్గెకద్, దెయ్యముంఙ్ స్తుతి కలెంఙ్ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","మల్ల బిచ్చెం ఎకెకనుంఙ్ మందిర్ లోపా సోయ్త బొయ్ద ముదర్వై ఉద్నెంద్ అమ్‍ది ఇసా ఒర్కిల్తెర్. జర్గిల్తదున్ ఔర్ ఓలుత్ కమల్‍ ఎత్న గడ్సు ఎద్దన్. ");
INSERT INTO nit_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","అముదు బిచ్చెం ఎకెకంద్, పేతురున్ యోహానున్ కలయుత్ అన్సంద్. మందినత్తి ఎద్దద్ చమత్కర్ డిగ్గెతిన్. ఔర్ సొలొమోనున్ సయ్వనుత్ అనెకర్, నై తుల్సని సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","అప్పడు పేతురు ఔరున్ ఓలుత్ ఇనంఙ్ ఇంతెంద్, ఇస్రాయేల్త మన్కకెర్! ఇద్ ఇముంఙ్ తగలెంఙ్ కమాలెత్ హగత్ ఓల్సతిర్? అమ్ అమ్మె గుల్ సక్తినడ్ తోద్‍తె అమ్మె సోయాడ్ సియ్ ఇసా అడిగిపెకద్లంఙ్ అమున్వై సిమ్కన బక్తినడ్ ఇనంఙ్ ఇదర్తంమ్ ఇసాతిరా? ");
INSERT INTO nit_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","అబ్రాహామ్, ఇస్సాక్నె, యాకోబ్నెనె దెయ్యమ్, ఇంతె నేండె దొడ్‍లె దెయ్యం తనె గడియాక్ ఇనెక యేసునె మహిమ ఇదర్ తెంద్. అనంఙ్ ఎదె నిర్ అమ్నున్ పిలాతునె కెయ్యుత్ సియ్తెర్. అమ్ద అమ్నున్ పుసెంఙ్ ఇసా నిర్నాయ్ కత్తత్తి నీర్ పిలాతున్ ముదర్ నై యేసునున్ న్యాయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","అముదు పవిత్రక్ నీతిమంతుంద్, గని నీర్ అంనున్ అంత్తెయ్ ఎరెకడ్ అంనున్ బదోల్‍ పిలాతున్ మెరమ్ మరొక్కొనున్ సాయుర్ ఇసా నీర్ వెల్తిర్. ");
INSERT INTO nit_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","నిర్, ఇముంఙ్ నిత్య పానం సియ్యెకనుంఙ్ దాతకున్ అలుంఙ్ తెర్. గని దెయ్యం అమ్నున్ తిక్కెక తన బత్కిప్తెంద్. అమ్ ఇదుంఙ్ గావ. ");
INSERT INTO nit_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“అముంఙ్ ‘యేసుంద్’ ఇనెకనె పెరుత్ బరొస అండద్ ఇసా నీర్ ఒర్కిల్ తర్ కుంటి, సోయ్‍ ఎరెకనున్ నిర ఓల్సతిర్ ఇమ్నున్ నయం ఎర్సనంసద్. యేసు పేరడ్, అముదు రొంబడ్గత్తద్ విస్వాసి ఇమ్నుంఙ్ సదరుంఙ్ ముడటి అమ్నునుంఙ్ ఇద్‍ పుర సొయ్ ఎదిన్. ఇద్ నీర్ ఓల్తిర్.” ");
INSERT INTO nit_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ఇస్రాయేల్ దాదకేర్, ఇమ్మె అదికారిక్‍ వాలడ్నిర్, గిన ఒర్కి తోసెటయ్ అనుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","గని, ‘క్రీస్తునుంఙ్ తప్పతొసెట సిక్స ఎరెంఙ్’ ఇసా దెయ్యం ప్రవక్తకెరున్ వాలడ్ పెలెయ్ ఇడ్తవున్ అముదు ఇండి ఇనంఙ్‍ ఓలిప్తెంద్.” ");
INSERT INTO nit_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","మన్ బద్లిపుర్ దెయ్యమున్వై మలయుర్. అనఙ్ ఇదర్తె దెయ్యం ఇమ్మె పాపులున్ సోయ్‍కల్సద్. ");
INSERT INTO nit_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","సక్తి వంతక్ క్రీస్తు యేసుంద్ ఇముంఙ్ సాటి అముదు పన్సంద్. ఇమ్మె పపులున్ ఉసుముత్ జొపిడ్‍దద్. ");
INSERT INTO nit_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","సిమ్కనంఙ్ కమిఅన్నెక కలము వద్ద ఇసా లోకముంఙ్ పెలెతన మల్ల తమ్మెత్ తమ్మి దెయ్యమున్ కత్త ప్రవక్తకెరె మూతినాడ్ ఇనంఙ్ అర్పులిప్‍ తెంద్. పురన్ పవిత్ర కలెక కాలం వనంత్తెంఙ్ యేసుంద్ పరలోకముతి అనెంఙ్. ");
INSERT INTO nit_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","మోసే ఇనంఙ్ ఇంతెంద్, “ప్రబుద్ ఇనెక దెయ్యం ఇముంఙ్ సటీ అన్ లంఙ్ కబుర్లకున్ పన్కదద్‍. అముదు ఇమ్మె దాదకేర్ తన్న వర్‍సాద్. అముదు ఇడ్తెత్తి నీర్ వినెంఙ్. ");
INSERT INTO nit_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ఆప్రవతక్నె గొట్టిక్ వింసెటానున్ ఆత్మ వింతి కత్న నాస్ కద్దద్.” ");
INSERT INTO nit_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“సమూయేల్ కాలం తన్న ప్రవక్తకెర్ సిమ్కన ఈ దినా వారెకా అంసా ఇసా ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ఇమ్మె దొడా వాలడ్ దెయ్యం కత్త కరరున్, ఇమ్మె ప్రవక్తకెర్, కారరులుంఙ్ వారస్. దెయ్యం అబ్రాహామ్ మున్, ‘ఇన్నె పిడితరడ్ బూమి పొయ్‍ అన్నెకా మందిన్ ఆసిర్వాద్ కలత్ ఇసా ఇంతెంద్.’ ");
INSERT INTO nit_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","దెయ్యం తన్నె గడియాకున్ పేలె ఇమున్‍ వై పన్కతెంద్. ఇమున్ సిమ్కనన్ ఇమ్మె కరాబ్ పవ్ తన తిర్గెంఙ్ ఇసా అమ్నున్ పన్కతెంద్. అనంఙ్ కత్న ఇమున్ బత్కిపెంఙ్ ఇసా ఇంతెంద్.” ");
INSERT INTO nit_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","దెయ్యలకెర్, మందిర్వై పాలకుల అదిపతిన్, సద్దుకి కార్యలున్ కలయుత్ పేతురు, యోహానున్ అనెకా జాజ్ సెద్దెర్. అపుడ్ ఔర్ మందిన్ ఉపదేస్సిసా నన్సార్. ");
INSERT INTO nit_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ఔర్ అపొస్తులున్ మందిన్ ఇడ్డెకరూన్, యేసుంద్ ఉదహరనా సుమ్ముత్ తిక్తరున్ ఔర్ తిక్ తార్ బత్కసార్ ఇసా ఇంతెర్ అని వత్ ఔరుంఙ్ పొయ్ గుల్ రగ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ఔర్ పేతురున్, యోహానున్ కొడప్తెర్. అపుడ్ తుంఙ్ సింతెవెల ఎత్ అండకడితుంఙ్ మరొక్కొ దినం వరెంఙ ఔరున్ కొడపుత్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","గని ఔరె గొట్టిన్ వింత్ ఎంతొయో మంది విస్వాసుల్ ఎద్దెర్. ఔర్ విస్వాసుల్ గుంపులె అందెజ ఐదువెల మంది పేర్గతెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","మరొక్కొ దినం దండిక్, అదికారి మన్కకెర్ గురుకెర్ నియమ్ సాస్త్ర యెరూసలేముంఙ్ మిరయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ఔరు “ముక్య దెయ్యలక్, అన్నస్, కయప, యోహానున్, అలెగ్జాండర్, దండి మన్కకున్ ఎల్ల మంది నత్తి కలయ్తర్ సిమ్కన మిరయ్తత్తి అండెర్.” ");
INSERT INTO nit_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","పేతురున్, యోహానున్ ఇవ్రు ముదర్వై కూగుత్ వత్తెర్. “ఎద్ అదికారడ్, ఎరె పేరడ్ నీర్ ఆ పని కత్తిర్?” ఇసా ఔర్ వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","అపుడ్, పేతురునె పవిత్ర ఆత్మన్ డ్ నిండుత్ ఔరుంఙ్ ఇనంఙ్ ఉత్తర్ సితెంద్. మందినె అదికారి లరా, దొడలరా, ");
INSERT INTO nit_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ఒక్కొ కుంటిన్ ఇదర్త సోయ్‍కత్తదున్ బదోల్ ఇంన్డి నీర్ అమున్ వేల్తోల్తీర్త, ");
INSERT INTO nit_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","నీర్ ఇస్రాయేల్ తర్ సిమ్కన్ ఒర్కిలెంఙ్. నజరేత్ బత్కెకా మంది యేసు క్రీస్తునె పెరడ్ ఈ కుంటిన్ పురయ్ సోయ్ ఎత్న ఇమున్ ముదర్వై ఇల్లుత్ అన్సంద్ నీర్ యేసును సిలువంఙ్ కొసుత్ అలంఙ్ తనున్ దెయ్యం అమ్నున్ తిక్త తాన బత్కిప్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ఎల్ల కటేకర్ నీర్ సాయ్త గుండ్ అమ్‍ది ఆ గుండ్ ఎల్లంఙ్ అదర్ ఎద్దిన్. ఎల్ల కట్టెకర్ ఔరెన నీర్ జొపిటవ్ గుండ్ ఇంద్ యేసుంని! పఙ్ఙి అద్ ములత్ గుండ్ లంఙ్ నివ్డిల్తిన్, అద్ గుండ్ యేసుంది. ");
INSERT INTO nit_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","రక్సన ఇంక ఎరున్ వాలడి రొంబాడెద్. తానుంఙ్ ఇంతె, రక్సన రొంబడెంఙ్ ఇంతె యేసు ఆబార్ బుడున్ అన్నెక దెయ్యం మన్కకెరుంఙ్ తప్ప మరొక్కొ పేర్ తంద్ ఒర్కిలెంఙ్ ఇడెతెర్. ఈ పెరుంఙ్ తప్పు తాకత్ దున్యతరుంఙ్ సితద్ మరి పెరుంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","పేతురు, యోహానున్ వసిపుర్ ఇసా కరప్సెట సాదరన్ మన్కకెరుంఙ్ ఔరుంఙ్ ఒర్కి ఎద్దిన్. గని దడ్డి సబత్ అనెకర్ ఔరె సిమన దైర్యమున్ ఓలుత్ మిరయ్ తరుంఙ్ గుల్ ఎన కరిల్తిన్. అపుడ్ మంది ఔర్ యేసున్ వెంట అనెకర్ ఔరున్ కరిప్తెర. ");
INSERT INTO nit_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ఔరడ్ సోయ్ ఎద్దద్ ఇల్లుత్ అనెకనున్ ఓలుత్ ఇంక తనయ్ ఇదరెంఙ్ సలెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","పేతురు యోహానున్ సబతన్న కురియుత్ సే ఇసా ఉక్కుమ్ సియ్తెర్ మంది ఇనంఙ్ విచార్ కత్తెర్. ఔరెత్ ఔరి ముటెర్ ");
INSERT INTO nit_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ఇవ్రుంఙ్ ఇదరెంఙ్ ఇసా? యెరూసలేముత్ బత్కెకర్ సిమ్కన ఇవ్రు గుల్ సమత్కల్ కత్తెర్ అదా ఎరెత్తె ఇనెంఙ్ సాలెమ్. ");
INSERT INTO nit_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","గని ఇద్ మంది నత్తి ఇంక జాస్తి అనెంఙ్ సల్సెటా పేలెయ్ ఇంక పొదె అమ్నె పేరడ్ ఎరడి తనెంని ముడెకద్ తోద్ ఇసా ఔరడ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","మల్ల ఔరున్ లోపా కూగుత్ యేసునె పేరడ్ ఎమత్రం గొట్టిక్ ఇడ్డెంఙ్ తోద్, అమ్నున్ గురించి ముడెంఙ్ తోద్ ఇసాజొరనట్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","గని పేతురు, యోహానున్ ఔరుంఙ్ సమాదన ఇడ్సా, “నీర్ ఇడ్తద్ ఇదరెకదొ, దెయ్యం ఇడ్తద్ ఇదరెకదొ, దెయ్యంన్నె నదురుంఙ్ ముండట్ ఎద్ నీతి అమ్మెత్ నిరి ఇడుర్. ");
INSERT INTO nit_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","తానుంఙ్ ఇంతె అమ్ ఓల్తదున్, వింతదున్ గురించి మందింఙ్ ఇడ్సెటా అనెంఙ్ సలెమ్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ఔర్ పేతురున్, యోహానున్, పెనా కొన్సెం అర్పులిపుత్ సయ్తెర్ దెయ్యమ్నె మహిమా వాలడ్ ఇదా జర్గిల్త సంగట్నలుంన్ వాలడ్ మంది సిమ్కన్‍ మిరయుత్ దెయ్యమున్ స్తుతి కలెంఙ్ మోదలిట్టెర్. అదుంఙ్ ఎత్తి ఇవ్రున్ ఎ తరికనాడ్ సిక్స సియ్యెకదొ ఔర్ నిర్నయం కలెంఙ్ సలెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","సమత్కరడ్ సోయ్ ఎద్దద్ మన్కకక్ సాడిస్ సాల్కు దట్తంద్ అముదు. ");
INSERT INTO nit_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","పేతురున్, యోహానున్ సాయ్త వెంటాయ్ ఔర్ తనే మన్కకెర్ వెంట సెత్న దొడా దెయ్యలకెర్, దొడా ఇడ్తద్ సిమ్కన ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ఇద్ ఎదత్తి ఔర్ సిమ్కన్‍విస్వాసు ఆ గొట్టిన్ వింత్తె ఔర్ సిమ్కన మిరయుత్ దెయ్యమున్ ఇనంఙ్ పార్తన కత్తెర్. దడ్డి ప్రబుంద్! నివ్ ఆబారున్, బూమిన్, సమ్‍దురున్ అత్తి అనెక వున్ గడిపెకని వా. ");
INSERT INTO nit_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","నివ్ పవిత్ర ఆత్మన్ వాలడ్ ఇన్నె సేవకెరున్, అమ్మె బానున్ అమ్నె దావిదున్ మూతితన ఇనంఙ్ ముట్టివ్, యూదులెర్సెటర్ తనుంఙ్ చెర్చుస నన్సతివ్? మంది తనుంఙ్ ఆగం విసార్ కల్సార్? ");
INSERT INTO nit_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ప్రబున్ పొయ్ అముదు క్రీస్తున్ పొయ్ బూ రాజక్, అదికారి కలయుత్ ఒక్కొద్ ఎద్దెర్ అని నీ పరిసుద్దత్మనాడ్, ఇన్నె సెవక్, అమ్మె బంద్ ఇనెక దవి ఇడ్గ త్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","హేరోద్ పెనా ఒర్కిలుత్ పిలాతు, ఇస్రాయేల్త సత్తెం వంట మల్ల యూదులెర్సెటర్ వెంట కలయుత్. పవిత్ర ఇన్నె సేవకులున్, నివి అబిసేకం క్రీస్తున్ లంఙ్ కత్త యేసునుంఙ్ విరొది ఎదీ. ");
INSERT INTO nit_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ఇన్నె సక్తినాడ్ తనెద్ ఎరెంఙ్ ఇసా నేమిప్తదున్ అదవులున్ పూర కలెంఙ్ ఔర్ మిరయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","పంఙి ఔర్ అమున్ అర్పులిప్స నన్సార్, ఓల్ ప్రబు! ఇన్నె సందెసమున్ దైరమడ్ ఇడ్డెకద్ సక్తిన్ నివ్ సేవకెరుంఙ్ సియ్! ");
INSERT INTO nit_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ఇన్నె పవిత్ర సేవక్నె యేసునె. పేరడ్ రొగులున్ సోయ్ ఇదరెంఙ్ సటీ, సమత్కల్, అచర్యకరులు ఇదరెంఙ్ సటీ ఇన్నె కెయ్యున్ సపుత్ అముంఙ్ సక్తిన్ సియ్. ");
INSERT INTO nit_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ఔర్ పార్తనన్ తిర్ప అత్తి మిరయ్తత్తి జాగత్ మెల్గతిన్. సిమ్కన మందిత్ పవిత్ర ఆత్మ నిండుత్ రొబటిన్. ఔరున్ దెయ్యమ్నె సందేసం దైరమడ్ ఇడ్డెంఙ్ మొదలిట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","విస్వాసుల్ సిమ్కన మాన్ త, ఆత్మ ఒక్కొది మన్ ఒక్కొది మన్ కలయుత్ అన్సార్. ఎరి తమ్మె అస్తి క్లెంఙ్ ఎద్ది తన్నెత్. ఇసా ఇనెతెర్. ఔరుంఙ్ రొంబాటద్ సిమ్కన సొయ్ ఇటెర్. ");
INSERT INTO nit_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","గొప్ప సక్తినాడ్ అపొస్తులున్ ప్రబున్ యేసుంద్ తిక్ తార్ బత్కసార్ ఇసా సాక్సం దెయ్యమ్నెనె కృప ఎక్కవ ఔరున్ పొయ్ వత్తెతి కతెంద్ ");
INSERT INTO nit_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","అవ్రత్తి ఎరడి ఎదవి కమ్మి తోసెట అండెవ్. ఎల్లక్ కేండ్లు అనెకర్ ఔర్ అదవున్ విరుత్, ");
INSERT INTO nit_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","అదా పైసెలున్ అపొస్తులె ముదర్యైం ఔర్. ఔర్ అపొస్తులున్ పనిత సిమ్మకన్‍ ప్రతి ఒక్కొనుంఙ్ అదా పైసెలున్ పైయెకర్. ");
INSERT INTO nit_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","యోసేప్ ఇనెకంద్ అముదు లేవి వరసుడు. ఇంద్ సైప్రసు ప్రతంఅంట్తంద్. అమ్నున్ అపొస్తులున్ బర్నబా ఇసా కుగ్నేర్ అద్నె అర్తం ఆదారడ్ ఇసా ఇద్నె అర్తం. ");
INSERT INTO nit_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","అముదు తన్నె కెనున్ విరుత్ అద్ పైసెన్ కొత్ అపొస్తులున్ ముండట్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ఇంతె అననీయ ఇనెకపెరకంద్ ఒక్కొ మన్కక్, అండెద్ అమ్‍నే మాసల్ సప్పీరా నడ్ కలయుత్ తమే బూమిన్‍ విరస్సార్. ");
INSERT INTO nit_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","అననీయ తన్నె మాసలుంఙ్ నాయ్ ఒర్కి తముంఙ్ కొన్ని ఇస్సా పైస్సెల్ ఇట్టెర్. మికత్‍ పైసెలున్ అపొస్తులున్ సిత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","అప్పుడు పేతురుంద్‍ ఇనంఙ్ ఇంతెంద్. అననీయ, ఇన్ని బూమి విట పైసెలున్ కొన్నీగిడుత్‍ పవిత్ర ఆత్మ సైతన్ నె వింత్న పైలి ఇడెంఙ్ తనుంఙ్ ఇన్నె మనుంత్ జాగ సియ్తివ్? ");
INSERT INTO nit_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","అద్ విరెంఙ్ ముండట్ గిన ఇన్నెత్తి. విరత్ మల్ల గిన ఆ పైసే ఇన్నెవీ. ఇండి, ఏనఙ్ కలెంఙ్ ఇనుంఙ్ అదికార్ పుట్టుతిన్. నివ్ మన్కకెరడ్ ఏరేద్ పైలి ముట్టద్, గని దెయ్యమడి పైలిముట్టివ్. ");
INSERT INTO nit_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ఈ గోట్టిక్ అననీయ వెంటని బుడును రలుత్ పానమున్ సాయ్తిన్. ఈ గట్నన్ వినురుం గుల్ అర్రి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","కొన్సెం మంది జవాన్లుంఙ్ లోపా వత్న అననీయ సేత్తన్ ఒక్కొ జూగ్గెత్ సూట్టుతు ఏత్తుతు కోసుత్ పుర్పతెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","కమ్మి జాస్తి ముద్దిఙ్ గంటల్ ఏద వెన్కత్ అననీయక్నె మాసల్ అత్తి ఎదద్ ఒర్కి తోసెటయ్ అత్తి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","పేతురుంద్‍‍ అదున్ ఇనంఙ్ వెల్తెంద్ నీర్ బూమి విరెంఙ్ రోబ్బట్ పైసే ఇంతేయ? ఇండ్, బాయి ఇసా ఇంతెంద్. అయ్యొ అంతేయి పైసే రోబ్బట్టిన్ ఇస్సాబాయి ఇడ్త్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","అదుంగి పేతురు బాయినడ్, ఇనంఙ్ ఇంత్తద్ నీవ్, ఇనే మాసును కలయుత్ ప్రబువు ఆత్మన్ తనుంఙ్ పరిక్సికాల్సాతిర్? ఇన్నె మాసున్ పుర్పతర్ కవాడ్ మేరమి అన్సార్ ఔర్ ఇన్‍నై కొసార్. ");
INSERT INTO nit_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","వెంటాయ్‍ ఆ బాయి అంమనే గేట్టల్ ముండట్ రలుత్ పానమున్ సాయ్తిన్. అవేనుకత్ జవ్వన్ల లోప వాత్న బాయి తిక్కుతుఅనెకంద్ ఓలుత్ బాయిన్ నాయ్యి ఏత్తుతు కోసుత్ పిల్లనే మాసునుపక్కఙ్ పుర్పతెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","సంగముంఙ్, ఈ సంగటనల్ వినుతు ఔరుగుల్ అర్రి సుమ్ముస్సార్. ");
INSERT INTO nit_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","అపొస్తులున్, మందినత్తి, ఎన్నిగొ అద్బుత, సమత్కల్ ఓలిప్తెర్. విస్వాసు సిమ్కన కలయుత్ సొలొమోన్‍నే సయ్వనుత్ కలయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ఔరున్ బదోల్ మందిసోయ్ ఇడ్తెనా ఔరడ్ మరొక్కొర్ ఎర్‍ ఔరున్‍వై సెరెంఙ్ ఇమ్త ఎరెత్తి. ");
INSERT INTO nit_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","గని గుల్‍మంది పిల్లక్, పడసింల్ ప్రబున్ నమ్తెర్. అని రోజ్ రోజ్‍ మందిర్‍ వడిల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ఇదున్ ఓలుత్న మంది పేతురుంద్‍ వరెంఙ్ అమ్నె నీండ ఎన్నవ్రున్ పొయ్ పొదెంఙ్ ఇసా. తేల్ చప్ర తడక ఔరున్ తోడవత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","మల్ల మంది యెరూసలేమ్ తిర్‍గొర అనెక ఉలతరన కుప్ప కుప్పవత్తెర్. తమ్మత్తి దుక్కలడ అనెకరున్, దెయ్య అట్టుత్న గుల్‍ఎద్దరున్ తోడా వత్తెర్. ఔర్ సిమ్కన సోయ్‍ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","అప్పుడ్ దాండిదెయ్యలకెర్ అమ్నున్ వెంట అనెకర్, సద్దుకియ్యువెంట అనెకరున్ అపొస్తులున్ పొయ్ అసూయ వత్న ఔరున్‍ తానెద్ ఎన కలెంఙ్ ఇంతెర్‍. ");
INSERT INTO nit_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ఔర్ అపొస్తులున్ కట్టుత్న జేలుత్ తప్‍త్తెర్ ");
INSERT INTO nit_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","గని సింత్తె ప్రబునే దూత్ జేల్త గుయ్యున్ పుసుత్న ఔరున్ వాకా తోడ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","ఔరున్, “సెత్న మందిర్తా అవరాత్ ఇల్లుత్న ఈ కొత్త పానం బదోల్ గొట్టికున్ కరెయ్ మందింఙ్ ఇడుర్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ఆ గొట్టిన్ విత్న సెత్న మందిరుంఙ్ ముదర్వై ఇలుత్ ఇడ్తెర్. అప్పు ఇస్రాయేల్ దెయ్యలకెర్ అమ్నున్ వెంట అనెకర్ కలయుత్ దడ్డి సబత యూదత మందిన్ కూగుత్ జేలుత్ అనెక అపొస్తులున్ తోడవా ఇసా కొన్సెం మందిన్ పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","గని జుఙ్ఙె సుత్కెంఙ్ మొదలిట్టెర్. గని కబుర్ ఔరుంఙ్ జేలుత్ అపొస్తు కండ్కెరెతెర్. ఔర్ మలయుత్ వత్న అత్తరుంఙ్ ఇడ్తెర్, ");
INSERT INTO nit_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“అన్ జేలుత్ సెదె జేల్ కులుప్ తప్పత్ అన్నెఙ్ పోలిసు కవాడ్ మెర అనెకరున్ ఓల్తెర్, గానీ అమ్ దర్వొజన్ పుసుత్ లోప ఓలెంఙ్ అముంఙ్ ఎరి కన్డెరెతెర్.” ");
INSERT INTO nit_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ఈ సంగతిన్ వింత్ మందిరుత్ జగ్లి కయ్యెకార్ మంది ద, మక్య దెయ్యలకెర్ మంది, ఔర్ తనెది ఇసార? ఇసా గుల్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","అంతెనాడ్ ఒక్కొంద్ వత్, “నీర్ జేలుత్ ఇట్టర్ ఔర్ మందిరుత్ అవారత్ ఇల్లుత్ మందిన్ గొట్టి ఇడ్సానన్సార్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","అప్పుడ్ అదికల్ సైనికువెంట సెత్న, మందిగుడ్లడ ఇడ్సారొ ఎన్నంఙొ అర్సుత్, అద్ వింత్ జగ్లికైఎకార్ అదికారిక్ బటులున్ వెంట సుమ్ముత్ ఔరున్ సుముత్ కొరెంఙ్ సెద్దెర్. మంది నేండున్‍ గుడ్లడ్ ఇడ్సార్ ఇసా అర్రి అవ్రత్తి అన్సాద్. అదుంఙ్ ఎత్తి సిపాయిక్ వెంట ఔర్ ఎదవి ఇదరెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","అపొస్తులున్ కూగుత్ కొత్న ఔరున్‍ మందిన్ ముండట్ ఇల్ గత్తెర్. ముక్య దెయ్యలకెర్ ఔరున్ ఇనంఙ్‍, ");
INSERT INTO nit_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ఇమ్మె యేసునే పెరడ్ గొట్టి ఇడ్డెంఙ్ తోద్ ఇసా అమ్ ఇద్ ఔరుఙి కరేయ్ సియ్యుత్. ఎనాగ యెరూసలేమ్ సిమ్కన ఇమ్మె గొట్టికాడ్ నిడుప్తెర్. అంతెయ్ తోద్ గా అమ్నె తిక్కెకాద్ అమ్ పొయ్ వరెంఙ్ ఇసా ఓల్సా నన్సార్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","పేతురు మిక్తా అపొస్తులున్ ఇనంఙ్ ఇంతెర్. అమ్ దెయ్యమ్నె ఆగ్యఇడుత్ అనెంఙ్‍, మన్కకెరె అద్జ్య తోద్. ");
INSERT INTO nit_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","నీర్ సిలువాత్ గమ్మతియ్ అలంఙ్ తన్ యేసున్ అమ్మె పేలె తంద్ దెయ్యం తిక్తతన సుల్పతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","దెయ్యం అమ్నున్ అమ్నె ఉన్న పకంఙ్ అనెకా రక్సక్ ఎకద్. అమ్నున్ ఒక్కొ దండి మన్కక్ లంఙ్‍, బత్కిపెకంద్ లంఙ్ నిర్నాయ్ కతెంద్. మల్ల ఇస్రాయేల్ మందిన్ మన్ బద్లిపుర్ రొంబాడుత్ అవకసం. అమ్మె పాపులుంఙ్ మాప్ కలేంఙ్, రక్సపానం పొందుత్ అవకసం రొంబడెంఙ్ ఇసా అమ్నె ఉద్దెసం. ");
INSERT INTO nit_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ఈ సంగతికున్ అమ్. దెయ్యం తన్నె ఆఙ్ఞ్యనా ముప్పట్ కత్తె ఎనా తోద్‍తె ఔరుంఙ్ సితె ఎనా పవిత్ర ఆత్మ గినా ఇదుంఙ్ సాక్సి. ");
INSERT INTO nit_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","అపుడ్ అదున్ వింత్ అవరుంఙ్ గుల్ రఙ్ వత్తిన్. ఔర్ అపోస్తులున్ అల్ఙెంఙ్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","గని “గమలియేలు” పేర్ ఇనెకా పరుసిక్, మందిన్ వాలడ్‍ మన్ సియ్త నియం సాస్త్రి మన్కకెర్ దడ్డి సబత్ ఇల్లుత్ అపోస్తులున్ జమితుంఙ్ వాకా కొస్ ఇసా ఉక్కుమ్ సియ్‍తెంద్ అప్పుడ్ దడ్డి సబత్ అనెకరున్ ఇనంఙ్ ఇడ్తెంద్‍. అన్నె ఇస్రాయేల్ ఈ మన్కకెరడ్ తన్నెగలతుమ్ ఇసాతిరొ ఉసారడ్. ");
INSERT INTO nit_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","అముదు ఔరున్ అంట్త, ఇస్రాయేల్ మంది, ఇవ్రుంఙ్ తనేవి ఇదరెకాదొ సొయడ్ అదికలుర్! ");
INSERT INTO nit_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","కొనీగొల్ పెలె దుత సులుత్ తన్ దండి ఎమదున్ ఇసా ఇడ్తెంద్. సుమ్ముర్ నాలిఙ్ హజార్ మంది అమ్నున్ అలంఙ్ త్తెర్ కలయ్త్తెర్. అద్ ఎద్ద వెన్కత్ అమ్నె అనుసర్ కరాబ్ ఎద్దే. ఆక్రింఙ్ తనెవి మిక్కెతే. ");
INSERT INTO nit_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","అముదు ఎద్ద వెనుకత్ మందినె నొందని వెలంఙ్ గలిలీయ తద్ యూదక్ ఇనెకంద్ అముదు వత్ మందిన్ కలయుత్ ఇంద్ గినా అలంఙ్ తెంద్. అమ్నే మంది సిమ్కన నెరయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","అదుంఙ్ ఎత్తి ఔర్ గొట్టిన్ అన్నె సాల్ల ఇద్. ఔరె గొట్టికున్ సుమ్నేర్! ఔరున్ సాయుర్! ఔరె కార్యలున్, ఔరె ఉద్దేసలిన్ మన్కక్నే గడప్త ఎంద్ ఎరతె అద్ నాస్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ఇంతె దెయ్యమున్ వాలడ్ ఎంద్ ఎరత్తె ఇల్పెంఙ్ సాలెర్. నీర్ దెయ్యముంఙ్ అడ్డమ్ తిర్గెకార్ నీర్ ఎరతిర్ ఇసా ఇంతెంద్ ఆ గొట్టింఙ్ బరోసా అనెకర్ సిమ్కన మనుంఙ్ కొత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ఔర్ అపొస్తులున్ కూగుత్‍ సాట్లడ్ లగప్ఉత్న మల్ల ఎప్పుడి యేసునె పేరడ్ ఇడ్నెర్ ఇంత్న సాయ్తెర్‍. ");
INSERT INTO nit_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ఆ పేరుంఙ్ సటి అపోస్తు అపమాన్ ఎరెకారమ్ ఇసా ఆ దండి సబన్ సాయుత్న కుసినడ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","రోజీ మందిరుంఙ్‍, ఎల్లెల్లంఙ్‍, “యేసు క్రీస్తున్” ఇసా ఇడ్తెర్. ఈ సొయ్త కబుర్ ఇడ్డెంఙ్ మనిలెతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ఆ దినం సిసులె సంక్య పెర్గసా అనెంఙ్ అదుంఙ్ ఎత్తి యూదు అని గ్రిక్ ముడెకర్ యూదులుంఙ్ జగ్డెదిన్ రడెరసుకుంక్ ప్రతి దినం పైసె పైయె కత్తి బర్బర్ పైయెర్ ఇసా గ్రీకు ముడెకాంద్ యూదూ పొయ్ ఇడ్తెర్. హీబ్రు ");
INSERT INTO nit_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","అప్పుడ్ బరా మంది అపొస్తు సిసు మందిన్ తమున్ వై కుగుత్, అమ్ దెయ్యమున్ వాక్యమున్ ఇడెకద్ ఇసా జెవున్ సియెకద్ సొయ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","అన్ అముదుఙి దాదకేర్ బాయినెవరా, పవిత్ర ఆత్మనడ్ మన్ నిడ్తర్ లంఙ్‍, ఇండతన్. నీవ్ ఇనే దేసెంతన, ఇనే మంది తన్ సాయ్యుతు అన్ ఇనుగు బదోల దేసెముంఙ్ సే. ");
INSERT INTO nit_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","అమ్మె వెలన్ మాత్రమ్‍ పార్తనత్, వాక్యముత్ ఇడ్సా సేవ కలెకద్. ");
INSERT INTO nit_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ఈ గొట్టి బూడున్ వత్తిన్ అదుంఙ్ ఎత్తి, ఔరు విస్వాసాడ్ పరిసుద్ద ఆత్మనడ్ నిండుత్ అనెక స్తెపన్ ఇంక పిలిప్, ప్రొకొరు, నీకానోరు, సిమోన్, పర్మెనాసు, యూద మత్తముత్ కలయ్త దెయ్యం అంతియొకయ ఈ దేసేముత్ ఒక్కొ టిచ్చెడ్ బూమి గిన ఆస్తిసియ్యెతి. అంమదుగు అప్పుడు పిల్లపడ్సతోస్సెటా, అంమదుగు, అంమదుగు వేనుకంత్, వారేకర్ ఔరుంఙ్ ఆ దేసం ఆస్తి అన్సాంద్ ఇస్సా వచన్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ఔరు లొపా అపొస్తుల్ ముడట్ అపొస్తు పార్తన కత్న ఔరున్ పొదె కేయ్యులిటెర్. ");
INSERT INTO nit_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","దెయ్యమ్నె గొట్టిక్ రొజ్ రొజ్ నేర్యతె సిసులె సంక్య యెరూసలేముత్ వాడిల్తిన్ దెయ్యలకెర్ నాయ్ గుల్ మంది విస్వాస్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","స్తెపనె కృపనాడ్ సక్తినడ్ నిండుత్ మందిన్ నడుమున్ సమత్కర్లున్ దండి సిన్నలున్ క్రియలున్ ఇదర్సాద్. ");
INSERT INTO nit_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","సొతంత్ర సావ్డిఙ్ కలయ్తర్ పోయ్యి రగ్ అండిన్. అనఙ్ ఏత్తి కురెని అలెగ్జాండ్రియా కిలికియ ఆసియ దేసేముంఙ్ గాండియక్లాఙ్ విర్సర్. గని దెయ్యంఅముదుగు వెంట అన్సాంద్, ");
INSERT INTO nit_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","అంమదును కస్టతన గేలుపుత్. అంమదుగు బుద్ది సియ్యుతు. ఆ ఆత్మన్ అముదు ఈజిప్టు రాజక్నే మనమును గండ్పత్తెంద్. పరో అంనున్ ఈజిప్టు దేసెముంఙ్ రకవల్లిలాఙ్ తనే రాజ మడ్డికుల్లుగు అదికారిలాఙ్ నివుడిప్తేద్. ");
INSERT INTO nit_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","అప్పుడ్ ఔరత్తి కొంసెం మంది డపుత్ కబులెంత్ ఇమ్ద, మోసేన్ దెయ్యమున్ విరొద్ గొట్టిక్ ముడెకనున్ అమ్ వితం ఇసా ఇడ్గలెమ్ పైసె సియుత్ కబ్లిల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","మందిన్, నియం సాస్త్ర గురులున్ రెపుత్ అంనున్ పొయ్ వత్న అంనున్ సుముత్ దొడ సబంఙ్ ముదర్వై తోడ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","పైలీ సాక్సమ్. ఇడుత్ ఔర్, ఈ మన్కక్‍ ఎప్పుడి ఈ పవిత్ర జాగత్ నేండె నియం సాస్త్రంఙ్ విరోద్ గొట్టిక్ ముడ్సార్‍. ");
INSERT INTO nit_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","మందిరున్ నజరేత్ యేసుంద్కరాబ్ కత్న, మోసే నేండుంఙ్ సియ్త కయ్దలున్ బద్లిప్‍సాద్ ఇసా ఇమ్‌ద ఇడ్డెంఙ అమ్ వింత్తమ్, ఇసా ఇడ్‍తెర్. ");
INSERT INTO nit_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","సబత్ ఉద్తర్ సిమ్కన అమ్నున్వై తిరుగుత్ ఓలెంఙ్‍ అమ్నె మోకం దూత్ మోకంలంఙ్‍ ఔరుంఙ్ కండ్కెదిన్‍. ");
INSERT INTO nit_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","అప్పుడ్ దండి దెయ్యలక్ స్తెపనున్ ఈ గొట్టిక్ కరెయ్? ఇసా వెల్తెంద్, ");
INSERT INTO nit_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","అదుఙి స్తెపను ఔరుంఙ్ ఇనంఙ్ సమాదనం ఇడ్తెంద్ దండి అదికార్! దాదకేర్ అన్ ఇండేకాద్ వినుర్, తొలెతంద్ నేండె బాంద్ అబ్రాహామ్ “హారాను” పట్నముంఙ్ పేలెని మెసపటెమియాత్ అనెక అపుడ్ మహిమ అనెకా దెయ్యం. అమ్నుఙ్ కాన్కెత్‍ ఇనంఙ్ ఇడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","అన్ అముదుంఙ్ ఇండతన్. నీవ్ ఇన్నె దేసెంతన, ఇనే మంది తన్ సాయ్యుత్ అన్ ఇనుగు ఓలిపెకా దేసెముంఙ్ సే. ");
INSERT INTO nit_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","మల్ల అముదు కల్దీయుల దేసమున్ సాయ్యుతు హారానుతు అనేఙ్ సెద్దెంద్. హారనుత్ అంనే బాంద్ తిక్తెంద్ నీర్ పంఙి అనెకా దేసమున్ దెయ్యం అంనున్ కొత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","దెయ్యం అంమదుగు ఈ దేసేముత్ ఒక్కొ టిచ్చెడ్ బూమి గిన ఆస్తిసియ్యెతి. అంమదుగు అప్పుడు పిల్లపడ్సతోస్సెటా, అంమదుగు, వేనుకంత్, పిల్లపడ్సుంఙ్ ఔరుంఙ్ ఈ సొత దేసం సియ్యసంద్ ఇసా వచన్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","దెయ్యం అంమదును వెంట, ఇన్నె వారిసు పర దేసముత్ బత్కస్సానసార్. ఆ ముసపరిక్, ఇన్నర్ ఔర్ నాలుగు వందల సంవత్సరాల్ తమే బానిసలంఙ్ ఔర్ అంసార్. ");
INSERT INTO nit_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","గని ఔరున్ బానిసలంఙ్ ఇందరత దేసమున్, అన్ సిక్స సియ్సాత్ అవేనుకత్ ఔరువాక వత్న ఈ జగత్ తన్ ఇత్తి పుజకాల్సర్ ఇసా దెయ్యం ఇడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","దెయ్యం అబ్రాహాముంఙ్ సున్నతి, నేకి ఇండతిన్. కరార్ కత్న ఒర్కిలంఙ్ సియ్యతెంద్ అప్పుడ్ అబ్రాహమున్ ఇస్సాకుంఙ్ అముదు ఎనిమిదివ దినముల పోరకుంఙ్ సున్నతి కత్న, ఇస్సాక్ యాకోబ్‍ సున్నతి కత్న, కల్సార్. మల్ల యాకొబుంఙ్ పన్నేండు మంది సున్నతి కాల్సార్, ఎర్సర్. అవురి నేండె వేండ్లకేర్ ఏద్దేర్. ");
INSERT INTO nit_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","యాకోబ్‍ పోరకేర్ ఔర్ రత్తి ఒక్కొద్ యోసేపు పోయ్యి రగ్ అండిన్. అన్నె దాదకేర్ తొరేడ్లు ఐగుప్తు దేసేముంఙ్ బానిస లాడ్ విర్సర్. గని దెయ్యం అమ్నున్ వెంట అన్సాంద్, ");
INSERT INTO nit_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","అంమదును కస్టతన గెలుపుత్. అంమదుగు బుద్ది సియ్యుతు. ఆ బుద్దినాడ్ అముదు ఈజిప్టు రాజక్ మెస్తెతి బుద్ది సియ్తెర్. అంమున్ పరో ఐగుప్తు దేసెముంఙ్ రకవల్లిలాఙ్ రాజక్నె ఇల్లెంఙ్ దయన్ అదికారిలాఙ్ నివుడిప్తేద్. ");
INSERT INTO nit_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","అప్పుడి ఐగుప్తు, కనాను దేసులుంఙ్ కరువు వత్తిన్ మంది గులేన కస్టలున్ పట్టెర్. నేండె వేండ్లకేరుగు తినేకాదుంఙ్ తిండి గిన తొత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ఐగుప్తు దేసెముత్ తిండి అన్సాంద్ ఒరికి ఏరేంఙ్ యాకోబ్‍ నేండె తొలెనిత పొర్రెరున్ పేలె ఉసట్ అత్తిన్ పనక్సన్. ");
INSERT INTO nit_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","మల్లొక్కొ ఉస్సాట్ వత్తేన్ అప్పుడు, యోసేప్ అన్ ఇనెక గొట్టి తనే దాదకేర్ తొరెంలుంఙ్ ఒర్కిలుత్. మల్ల ఈజిప్టు యేసేపు కుటుంబున్ బదోల్ పరో ఒర్కిల్ తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ఆ వేనుకత్ యోసేపు తనే బద్ యాకోబున్ కబుర్ పవిడుత్, డెబ్బై ఐదు మంది అనెక్ ఆత్మ కుంటుంబ పుర్ ఈజిప్టు వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","యాకోబ్‍ ఐగుప్తు దేసేముంఙ్ వాత్తే, అముదు అమ్నె పొరకెర్ పాన సయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","అని అవురును‍ సెకెము కొసుత్ అత్తిన్ తప్నె జాగత్ ఇట్టెర్. అద్ జాగ ఇంతే, హమెరునె పోరకెరుంఙ్ అబ్రాహామ్ పైస్సేల్ సియ్యుత్. ");
INSERT INTO nit_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","దెయ్యం అబ్రాహాముంఙ్ కత్తద్ వాగ్దానమ్ పక్క ఏరేక వేలా మేర్రం వర్స అనేంఙ్ నేండె మన్కకెర్ ఐగుప్తు దేసముతు గులేన పేరేత్ సంక్య ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","కోన్ని దినల్ ఎద్దె యోసేప్ బదోల్ తనయ్యి ఏరకతొస్సేలన్ ఐగుప్తు దేసెముంఙ్ రాజక్ ఎద్దేన్. ");
INSERT INTO nit_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","అముదు నేండెరున్ మొసం ఇదరతేన్. నేండెరే దొడా సిక్స సియ్యుత్, ఔరుంఙ్ జన్మిలత లేతపాపకేరును వాకహ జొప్పిడుతు. ");
INSERT INTO nit_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","అ కాలయ్యుతి మోసే పుట్టుతేన్. ఇమద్ సొబత పోరక్. మోసే ఔరె ఎల్లత్ డపుత్ ఇట్టిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ఇమ్‍దున్ ఏల్ల వాకహ ఇండేగయ్యి పరో రాజక్నె కొమ్మల్ కొసుత్ తనే కాస్ పోరక్లంఙ్ పొరయ్త్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ఐగుప్తు దేసుల సిమ్మకన్ బుద్ది అమ్నున్ కారప్పతిన్. మోసే దండి గొట్టికుల్ ఇండేకత్తి దండి పనిక్ ఇదరేకతి జోర్దార్ కురితేన్. ");
INSERT INTO nit_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","మోసే నలబై సాల్కు వరెంఙ్ దాదకేర్ తన్నె సొత ఇస్రాయేలు మందిన్ తక్లిబున్ పడ్సారిసా ఒలెంఙ్ మన్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","అముదు అన్యాయ్ ఇస్రయెలియొలొ లోప ఒక్కొనున్ ఐగుప్తు దేసెంతన్ దాన్పెకానును ఓలుత్. మల్ల అముదు తరర్కలెకా మన్కకేరుంఙ్ మదత్ కలెంఙ్ ఈజిప్టు దేసెంతనున్ దాన్పుత్ అల్గుత్ బదోల్ సుమ్ముతేర్. ");
INSERT INTO nit_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ఇస్రాయెలు దాదకేర్ రక్సిపేంఙ్ దెయ్యం తనున్ గెల్పసర్ ఇసా గోట్టి ఔర్ ఒర్కిల్సార్ ఇస్సా మొసె బరొస ఇట్టెన్. గని ఔరుంఙ్ అద్ అర్దం కారిలేతి. ");
INSERT INTO nit_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","మల్ల ఒక్కొ దినం మొసె ఇద్దర్ ఇస్రాయేలీయులు దంన్పలాడేఙ్ ఓలుత్, దాదకేర్, నీర్ అనెక తొర్రెడ్ల, ఒక్కొనేత్ ఒక్కొంద్ తనుంఙ్ అన్యాయ్ కాల్సతిర్? ఇస్సా కలపెంఙ్ ఇస కోసిద్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","గని అమ్నున్ తనే సేజర్యకును అన్యాయ్ ఇద్దర్‍తన్ ఏన్నెన్ అంమును పోయ్యి అదికారి ఎక్కద్ న్యాయ్ ఎక్కద్ ఇన్ నివ్డిప్తన్ ఎంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ఐగుప్తు దేసెంతనున్ ఒక్కొడ్ అల్ఙతేతి అన్ గిన అల్ఙేఙ్ ఇస్సా ఓల్సతివ్? ఇస్సా ఇంతేన్. ");
INSERT INTO nit_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ఈ గోట్టిన్ వినుతు మోసే ఈజిప్టు దేసును సాయ్యుతు, మిద్యాను దేసుగు తుల్లుతు అత్తిన్ ముసపరిలంఙ్ అనేంఙ్ ఎద్దెంద్. అత్తిన్ అమ్నుంఙ్ ఇద్దర్ పోరకేర్ పుట్టుతేర్. ");
INSERT INTO nit_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","నలపై సాల్కు ఎర్సవ్. ఒక్కొ దినం సినాయి గుబ్బె పొయ్యి వేయ్యెక తుట్టి మొసెఙ్ ఒక్కొ దూత్ కండ్కసాద్. ");
INSERT INTO nit_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","మోసే అదున్ ఓలుత్ అంనుంఙ్ చమత్కర్ కరిలుత్న సోయ్ ఓలెగ్ ఇస్సా మేర్రం వారేగ్న ప్రబువునేత్ లేంఙ్ అంనుంఙ్ వినక్ ఏద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ఆ లేంఙ్ అమ్‍నున్ వెంట అన్ ఇమ్మె వేండ్లకరే దెయ్యం, అబ్రాహామ్, ఇస్సాక్, యాకోబుల దెయ్యం అని ఇస్సాన్. మోసే వాడక్సాన్. అదుంన్ ఓలెంఙ్ హిమ్మత్ పురయేతి. ");
INSERT INTO nit_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","అప్పుడ్ ప్రబువు, ఇనంఙ్ ఇడ్తెంద్ కెర్రికుల్లున్ పుస్సు! నివ్ ఇల్లుత్న అనెక్ జాగ పవిత్రద్ ఏంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","అనే మందిన్ ఐగుప్తు తక్లిబ్ అనెకదున్ ఓలుత్న. ఔరుంఙ్ అర్రెకా అనుంఙ్ విన్క వత్తె సొడపేంఙ్ ఇస్సా వాత్తన్. త! ఇన్ మల్ల ఈజిప్టు పనక్సాత్! ఇస్సా ఇంతేన్. ");
INSERT INTO nit_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","స్తెపను మల్ల ఇనంఙ్ ఇండతేన్. ఇన్ అదికారి, న్యాయ్ కలెకాద్లాంఙ్ ఇందరతన్ ఎద్? అని ఔరె కేయ్యడ్ సిరన్నల్ఏక్కతంద్లఙ్ ఈ మోసే. ఈ మోసేనున్ దెయ్యం ఔరె రాజక్లాంఙ్‍, సిపాయిలాంఙ్ పనక్తేతి రంబిలెకా తుట్టి కండ్కేంద్ దూతునడ్ ఓర్కిలుత్న సుమ్‍సాంద్‍. ");
INSERT INTO nit_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","మోసే సమత్కరున్, కమాల్ పనిక్ ఇదరుత్ అవురును ఐగుప్తు తన్ వాకహకుంగుతు కొత్తెంద్‍. లాల్ సందుర్ మేర్రం, ఆ వేనుకాంత్ నలబై సాల్కు అరన్యం జాగత్ అగ్గిప్ సా కొత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","అనేత్ లాంఙ్ ప్రవక్తకున్ దెయ్యం ఇంమె దాదకేర్ రత్తి అస్సుతు ఇముంఙ్ సియ్సద్ ఇస్సా ఇస్రాయేలు మందినడ్ ఇండుడు మోసే ఇమ్ది! ");
INSERT INTO nit_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ఇస్రాయేలు మందిసిమ్మకాన్ అరన్యంముత్ జాగత్ మింరయ్యెతే, అత్తి అనెక నేండె వేండ్లకేరడ్ మిరయ్యుతు అనెకాంద్ మోసే. సినాయి మేట్ పోయ్యి దూత్ నాడ్ ముట్టద్ మోసే. నేడుంఙ్ సియ్యెకదుంఙ్ పానంత దైవా సందేసున్ సుమ్ముతంద్ కొద్దాంద్ మోసే. ");
INSERT INTO nit_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","గని నేండె వేండ్లకేర్ అంనే గోట్టిక్ వినేతెర్. అంనున్ దగ్లిపుత్ ఔరె మనుత్ ఐగుప్తు దేసేముంగు తిర్గుత్ సెరెంఙ్ ఇస్సా ఇంత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","అనఙ్ ఎత్తి అహరోనున్, నేండుంఙ్ పావ్ ఇండేకాంవ్‍ దెయ్యల్ మూర్తికున్ తయార్ కత్న. అమున్ ఐగుప్తు దేసెం తన కూగుత్‍ కొత్తన్ ఆ మోసేఙ్ తనేవ్ ఏద్దినొ తనేద్ తోందో, ఇస్సా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","అప్పుడి సాట్టం మిరయ్యుత్ లేఙన్ రుప్లుఙ్ ఒక్కొద్ ముర్తి తయార్ కాత్. ఆ ముర్తిన్ బావ్ సియ్యితేర్. తమ్మే కేయ్యులాడ్ తయార్ కాత ఆ ముర్తినే పేరడ్ జెవొన్ కలెకద్. ");
INSERT INTO nit_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","అప్పుడు దెయ్యం ఔరత్తన సెత్, ఆబారుత్ తన సుక్కలున్ నీర్ పుజకాలుర్, ఇస్సా ఇంతేన్. ఇమ్‍దున్ బదోల్ ప్రవక్త లే పుస్తకుంతు ఇనంఙ్ వాయ్యుత్ అన్సాంద్. ఏ ఇస్రాయేలు మన్కకెర్! అరన్యంముత్ నలబై సాల్కు డోర్యకులున్ తర్గుత్ బావ్ సియ్యితంద్ అనుగు సటీ ఏరేద్! ");
INSERT INTO nit_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","నీర్‍ మొకెంఙ్ ఇందరత్తేన్ మొలెక్ గుడి! నీర్ కాజుత్ కొస్సేకాంద్ రెపాను నీరి దెయ్యం ఇనెకాం‍ద్‍ రోంపా సుక్కా ఒక్కొద్ ముర్తిన్! అమునున్ నీర్ పూజ కాల్లేకాందుఙ్ గడిప్సతిర్. అనగేత్తి ఇమున్ బబులోన్ పట్నముఙ్ ఇమున్ కొస్సర్! ");
INSERT INTO nit_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","నేండె వేండ్లకేర్ బట్టికులేఙ్ అనేఙ్ అవురతి దెయ్యంమ్నె గుడి అన్సాంద్. ఇద్ మోసేనె కేయ్యడ్ గండిపుడ్. ఇంద్ గండిపేంఙ్ తోల్లేని దెయ్యం ఒక్కొ నమూనాన్ మోసేఙ్ ఇండుత్ అమునున్ ప్రకారం గండిప్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ఆ వేనుకాంత్ ఇంద్ నేండె వేండ్లకేరుగు రోబ్బట్టిన్ బుయరి. ఔర్ యెహోసువ అడ్గిపేంఙ్, దెయ్యం ఎద్గేఙ్ మన్కకెర్ సాయ్యుతు సెరెంఙ్ బూమిపోయ్ అనెకా దినలేంఙ్ ఈ గుడి ఔర్ మేరం అన్సాంద్. దావిద్నె కాలముంఙ్ ఏంత్ అముదు ఆ దేసముత్ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","దావిద్ దెయ్యమున్ కివ్ రోబ్బటిన్ యాకోబ్‍ దెయ్యముంఙ్ సటీ మందిరున్ కట్టేకంద్ మొకా సియ్యి ఇస్సా దెయ్యమున్ విన్నతి కాల్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","గని సొలొమోన్ రాజక్ ఈ మందిరును నివుడిప్తన్. ");
INSERT INTO nit_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","గని దండి దెయ్యం మన్కకెర్ గండిపుడ్ గుడికులేఙ్ బత్కతేంద్, ఇమ్‍దున్ బదోల్ ప్రవక్త ఇనంఙ్ ఇస్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ఆబార్ అనే సింహాసన! బూమి అనే గెట్ట ఇండేకా పీట ఎంద్. అనుంఙ్ ఏనట్ట ఎల్ల నివుడిప్సతిర్ నీర్? అన్ అనెకా జాగ ఏత్తి అన్సాంద్? ");
INSERT INTO nit_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ఇందవ్ సాట్టం గండిప్తన్ అన్నె ఏరెవా? ఇస్సా ఇస్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","స్తెపను సందేసం అండిగప్స, “ముర్కకేర్! ఇమ్మె మన్లు యూదులు ఏక్కద్ ఔరె” మనులాఙ్ అస్సావ్. ఇమ్మె కేవ్వు దెయ్యం సందేసమును వినేకాందుఙ్ తొంద్ ఇస్సావ్. నీర్ ఇమ్మె వేండ్లకేర్ అండగ్తేతి అండ్గ్సనసతిర్. ఔర్లాఙ్ నీర్ గిన సాట్టం వేలలా పవిత్ర ఆత్మన్ విరొది కాల్సాతిర్. ");
INSERT INTO nit_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ఇమ్మె వేండ్లకేర్ తక్కిలిబ్ సియ్యిసేలన్ ప్రవక్త ఒక్కొద్ ఏన్న అస్సారా? ఔరె తన్నె నీతి సేవకెరున్ వర్సా ఇసా ముడటి ఇడ్తెంద్ దెయ్యమ్నె కబుర్ల్లకున్ అల్లుసార్. పంఙి అమ్నున్ తోద్ ఇసా అల్గతెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ఒక్కొ అపుడ్ నీర్ దూత్ లాండ్ వాలడ్ దెయ్యంమ్నె నియంసాస్త్రం ఇముంఙ్ రోబ్బట్టిన్. గని ఔరె గొట్టిన్ నీర్ పటించేతిర్. ");
INSERT INTO nit_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","దడ్డి సబ అనెకర్ స్తెపన్ గొట్టికుల్ వినుతు ఔర్ రాంగడ్, అమునున్ ఓలుత్ పల్కూ కొరుక్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","గని స్తెపన్ పవిత్ర ఆత్మనాడ్ నిండుత్ ఆబార్వై ఓలుత్ దెయ్యంమ్నె మహిమన్, యేసు దెయ్యంమ్నె ఉన్న పక్కఙ్ అనెకనున్ ఓల్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","అందో ఓలుర్! ఆబార్ ఉంగుడిలేగ్న మన్కనె పోరక్ దెయ్యమ్నె ఉన్న పక్కఙ్ ఇల్లుత్ అనెకనున్ కాడ్క్సనస్సద్! ఇస్సా ఇంతేద్. ");
INSERT INTO nit_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","దడ్డి సబ ఈ గోట్టిక్ విన్త వెంటాయ్ ఔర్ తమే కేవులున్ ముసుతేర్. జోర్‍కంత్ వాపొయ్స అమ్నున్వై సేస్సార్. ");
INSERT INTO nit_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","అమ్నున్ ఊర్ వాకహ కోసుత్ గుండ్లడ్ దాన్పేకాంద్ మొదల్ ఇట్టేర్. ఔర్ అదుంఙ్ సాక్సిలంఙ్ అమ్నె జుఙ్ఙెలున్ “సౌలు” ఇనెక ఒక్కొ మేండిగినే గేట్టల్ ముండట్ ఇంటేర్. ");
INSERT INTO nit_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ఔర్ గుండ్లు స్తెపను లగాపెఙ, “యేసు ప్రబు! అనే ఆత్మన్ ఇంనతి ఏక్!” ఇస వపొయ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","అప్పుడి టొఙ్ఙెటెకిపుత్‍, “ప్రబు! ఔర్పొయి ఈ పాప్ కుంతిప్నేమ్!” ఇసా జోరకత్ ఇసాంద్‍. ఈ గొట్టి ఇంత అప్పుడి తిక్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","సౌలు అమ్నె తికెకదున్ కబ్లిల్తెంద్. ఆ దినం తనటి సౌలు యెరూసాలెమ్ సంగమ్ పొయ్ విరోద్ కలెంఙ్. ఎదెద్ అప్పుడ్ అపొస్తులున్ ఎరెకడ్ విస్వాసిక్ సిమ్కన యూదియ, సమరయ, ప్రాతలెంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","కొంచెం విస్వాసిల్ స్తెపనున్ తప్నె ఇందరుత్, అముదుంఙ్ సటీ జోరకత్న ఆర్రుత్ బెమరి పట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ఇంతె సౌలు ప్రతి ఎల్లంత్ సొగుత్, పిలక్ పడసిలున్ సాయ్సెట సిమ్కన మందిన్ జేలుత్ తప్పత్ సంగమున్ కరాబ్ కలెంఙ్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","విస్వాసులు ప్రతి బార్సలుంఙ్ నెరయుత్‍ సొయ్త కబుర్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","పిలిప్ సమరయ ఇనెకాముక్య పట్నముంఙ్ సేత్న క్రీస్తును బదోల్ ఇడ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","మంది పిలిప్పు ఇండ్‍తవ్ గోట్టిక్ విస్సార్. ఇందరతవ్ సమత్కరున్ ఓలుత్ ఇంక సోయ్ అత్త గొట్టిన్ వింతేర్. ");
INSERT INTO nit_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","అపవిత్ర ఆత్మ అంటతరును ఔర్, లాంక్వ ఇంట్‍ దుంఖాలకేరున్, కుంటిక్ గులేన మంది అత్తిన్ అండేర్. బూతు అంట్తంద్ అవురును తన్ బూతు జోర్‍కంత్ వాపొయ్స వాకాహ వార్సవ్. లాక్వ ఇంట్ రోగులాకేర్, కుంటికుల్ సోయ్‍ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","అదుంఙ్ ఎత్తి ఆ పట్నముత్ అనెకర్‍ సాట్టం మంది కుసింఙ్ వార్సర్. ");
INSERT INTO nit_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","అత్తిన్ సీమోను పేర్త ఒక్కొ మన్కక్ అండేన్. అత్తిన్ గులేన్‍ దినముల్ తన్ ఆ పట్నముత్ విదెకల్స అనేన్. మల్ల సమరయత మందిన్ ఆస్చర్యపర్సాన్ అనేన్. అంమదోకొ దండి ఇస్సా ఇడ్సానంనేన్. ");
INSERT INTO nit_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","సిన్నల్ దండిక్ సాట్టం అముదు ఇండత్వవును ఉసరాడ్ విస్సన్ననేర్. నేండ్ గుల్‍సక్తి తద్ ఇస్సాతుమ్ ఆ దెయ్యంమ్నె సక్తి అమ్‍ది అన్నె గొట్టిక్ సోయ్ వింనెర్. ");
INSERT INTO nit_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","అముదు అవురును తనే కేదినాడ్ గులేన దినము తన అస్చర్య ఇందరస్సా అనెకాంద్ వల్లడ్ ఔర్ అముదు ఇండతెతి ఇందర్సనంనేర్. ");
INSERT INTO nit_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","గని దెయ్యంమ్నె రాజ్యమున్ బదోల్ సోయ్త గొట్టిన్, యేసు క్రీస్తు పేరున్ పిలిప్పు ఇండతవేనుకాంత్ పిల్లక్ పడ్సిల్ సాట్టం వినుతు, బరొస ఇడుత్, బాప్తిస్మ ఎక్కతేర్. ");
INSERT INTO nit_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","సమత్కలున్ సీమోన్ గిన బరొస్స ఇండుతు బాప్తిస్మమం ఏక్కత వెన్కత్. పిలిప్పుఙ్ కాల్లయ్యుత్ అంత్ అముదు ఇందరత్ గుర్తులును సమత్కరులును ఓలుత్ గుల్ ఎర్సర్. ");
INSERT INTO nit_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","యెరూసలేముత్ అపొస్తులున్ సమరయ మందింఙ్‍ దెయ్యంమ్నె గోట్టిన్ ఏరక్ ఎద్దిన్ ఇసా వినత్, పేతురు, యోహానున్ ఔరున్‍వై పన్కతెర్. ");
INSERT INTO nit_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","పేతుర్, యోహాన్ వాత్న అత్తర్ ఔరుంఙ్ పవిత్రత్మరొబ్బడేంఙ్ ఇసా పార్తన కాల్సర్. ");
INSERT INTO nit_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","తనుంఙ్ ఇంతే అత్తర్ ఔరు యేసు ప్రబునె పేరడ్ బాప్తిస్మ ఎక్తెర్. గని ఔర్ పొయ్యి పవిత్రత్మపంఙి గిన వారేతి. ");
INSERT INTO nit_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","అప్పుడు యోహాన్ పేతురు తమె కేయ్యులున్ అత్తర్ మన్కకెర్ పోయ్యి ఇంట్ అప్పుడి ఆ మన్కకెర్ పవిత్ర ఆత్మన్ ఎక్సర్. ");
INSERT INTO nit_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","అపొస్తులున్ తమె కేయ్యులున్ ఔర్పొయి ఇంట్ వెంటాయ్ ఔరున్ పవిత్ర ఆత్మవారేకాంద్ సీమోన్ పేతురు యోహాన్ ఓలుత్, అప్పుడ్ అన్ ఇంముంఙ్ పైసెల్ సియ్యిస్సత్. ");
INSERT INTO nit_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ఎరత్తి అనే కేయ్యులిట ప్రతి ఒక్కొనుంఙ్ పవిత్ర ఆత్మ రొబ్బడ్నెతిలాఙ్ ఇందరుతు ఈ అదికార్ అనుగు గిన సియ్యి ఇస్సా వేల్సద్. ");
INSERT INTO nit_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","గని పేతురుంద్ అంనుంఙ్ ఇనంఙ్ ఇడ్తెంద్ దెయ్యంమ్నె వారమును పైసెలాడ్ సుమ్ముస్సత్ ఇస్సా ఇసాతివ్ అంనగ్తీ ఇనే పైసే ఇంన్వెట్ సాత్యనాస ఏక్కద్! ");
INSERT INTO nit_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","దెయ్యంమ్నె కండ్లు ముండట్ ఇన్నె మన్ సోయ్‍తోద్. అనగ్ఎంతి ఈ సేవత్ ఇనుంఙ్ జాగతొతేద్. ");
INSERT INTO nit_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ఇనే కంప్ట్టిబుద్దిన్ పాపులున్ మాప్కల్ ప్రబున్ పార్తన కాల్. అనట్‍ బుద్దిక్ ఇనంతి కలయుత్ అస్సావ్ ప్రబువు ఇన్ మన్ బద్లిపుర్ వాంద్. ");
INSERT INTO nit_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ఇనంతి కరాబ్ నిండుత్ అనెకదున్ అన్ ఓల్సానంసాత్. నివ్ దుస్టలెంఙ్ పాపులెంఙ్ గటిలుతు అస్సాతివ్. ఇస్సా ఇడ్సన్. ");
INSERT INTO nit_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","సీమోన్ పేతురుంద్‍ యోహానున్ ఇనంఙ్ ఇస్సాన్. నీర్ ఎద్దవ్ ఇడ్సతిర్ అందవ్ తనయ్ అనుంఙ్ ఏరెగ్తొద్ ఇంత్ అనుంఙ్ సటీ ప్రబునుంఙ్ పార్తన కాల్లురు. ");
INSERT INTO nit_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","మల్ల పేతురు, యోహాన్ తమ్ ప్రబునున్ బదోల్ విన్నతందును, ఓల్తదున్ అత్తర్ మందిఙ్ ఇండ్సర్. ప్రబువు ఇండుడు సందేసును ఇడ్సర్. ఆ వేనుకాంత్ ఔరున్ సోయ్త సాక్సం ఎన్నొ సమరయ తిర్గొర అనెక ఉలెంఙ్ ఇడ్సా యెరూసలేముంఙ్‍ తిరుగుత్ వార్సర్. ");
INSERT INTO nit_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ఒక్కొ ప్రబునె దూత్ పిలిప్‍నాడ్ నీ సులుత్ దక్సిన యెరూసలేమ్ తన్ గాజా సేరేకా బట్టివై సే ");
INSERT INTO nit_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","అప్పుడ్ అముదు సులుత్ సేద్దెన్. అత్తిన్ ఇతియెపియా దేసెంతన్ ఒక్కొ అదికార్ కడ్కెదెద్. అముదు ఇతీయోపియా రాని సవుర్ముడ్యిక్ మొకెకదుంఙ్ యెరూసలెముంఙ్ వత్తెంద్ యెరూసలేముంఙ్‍ పార్తనఙ్ సేద్దెద్, ");
INSERT INTO nit_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","తిరుగుత్ వార్స తనే రతముత్ ఉద్దుత్ యెసయక్ ఇనెక ప్రవక్త గ్రంతామున్ వాచ్చిప్సఅనెగ్న. ");
INSERT INTO nit_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","దెయ్యంమ్నె ఆత్మ పిలిప్‍నాడ్, “ఆ రతముత్‍ మేర్రం సేరుతు అత్తిన్ అన్” ఇస్సా ఇంతేన్. ");
INSERT INTO nit_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","పిలిప్పు రాతమ్‍ మేర్రం తుల్లస్సా యెసయక్ ప్రవక్త కెర్ గ్రంతామున్ ఆ అదికారి వాచ్చిపేకాందును విస్సాన్. అత్తిన్ సేరుతు ఆ అదికారిన్, “నీవ్ వాచ్చిపేకాంద్ ఇనుఙ్ కారిల్సాన్సద్?” ఇస్సా వేల్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ఏద్దెన “ఇండ్తసివాయి అనుగు ఏనఙ్ కారిలాద్” అని అదికారి ఇస్సాన్. అప్పుడ్ పిలిప్పున్ రాతముత్‍ సోక్కుతు ఉద్ ఇసా వింతి కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ఆ అదికారి లేకనముత్ ఈ వాక్యామును వాచ్చిప్సన్సద్. అల్ఙెకాందుంఙ్ కొస్సేకాదున్ గొర్రెలాంఙ్ అముదు అడిగిపేంఙ్ ఎందేన్ తనే బూర్రున్ కత్తరిప్స గొర్రెనె కొవ్వె దాంబ్బ అండేతిలాంఙ్ అముదు ముడేతేన్! ");
INSERT INTO nit_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","అముదు గరీబున్ ఓలుత్‍ అంనుంఙ్ అన్యాయ్ జరిగిప్సర్. అంమనే పానం బూమితన్ ఎద్దుగుత్. అముదు సంతతిన్ బదోల్ ముడెకాంద్ ఏద్ద తోతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ఆ అదికారి పిలిప్పున్ “ఈ ప్రవక్తకెరున్‍ బదోల్ ముడుస్సాన్సన్? అంనున్ బదోల్ ఎక్కద్ మరొక్కొరును బదోల్? దయకాంత్ ఇండురు!” ఇస్సా వేల్లతేద్. ");
INSERT INTO nit_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","పిలిప్పు వాయ్తవున్ ఆ లేకనమడ్ మొద్లీడుత్, యేసు బదోల్ సోయ్త గొట్టిన్ అంమ ఇడ్సన్. ");
INSERT INTO nit_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ఆ పావుతు సేస్సన్ అనేఙ్ ఔర్ ఈర్ అనెక్ ఒక్కొ జాగంఙ్ సేరుతు. ఆ అదికారి, “ఇందో! ఇంతిన్ ఈర్ అన్సాంద్, అనుంఙ్ బాప్తిస్మసియెంఙ్ అటంకం” అంసాదా. ");
INSERT INTO nit_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","అప్పుడ్ రతము ఇల్ప ఇత్న పిలిప్పు అని ఆ అదికార్‍ ఇరుత్ డిగ్గుత్ బాప్తిస్మ సియ్యిస్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ఔర్ ఈర్ తన్ వాకహ వారుతు ప్రబువు ఆత్మ ఒక్కొది ఉస్సాట్ పిలిప్పున్ అత్తరన్ తొడ్ సేద్దేర్. ఆ అదికారి పిలిప్పున్ మల్ల ఓలేతేంద్. ఇంమద్ అముదు కుసినడ్ తనే పావడ్ అముదు సెస్నాద్. ");
INSERT INTO nit_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","పిలిప్పు అజోతున్ ఇనెక పట్నముత్ కండ్కెర్సాద్ ఎర్సన్. అత్తరన్ కురుయుత్ సాట్టం పట్నలుంఙ్ సెత్న సోయ్త సొయ్త కబుర్ ఇండ్సన్ అముదు కైసరియఙ్ వద్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","సౌలు, కొన్ని దినా వాలడ్‍ ప్రబుంద్ సిసు పోయ్యి విస్వాసం ఇంటర్ మన్కకేరును అల్గుతున్ ఇసా అరపులిపూత్, అముదు దండి దెయ్యలక్ నాంఙ్ సేదేద్, ");
INSERT INTO nit_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","దమస్కుంఙ్ పట్నముత్ యూదులె సావ్డిక్లెంఙ్ చిట్టిక్ వాయ్యుతు సియ్యి ఇస్సా వేల్సన్. ప్రబునే పావున్ అండగేకార్ ఔర్ కండ్కేదే పిల్ల పడ్సిల్ బేద్ తొస్సెట అవురును కటూత్ యెరూసలేముంఙ్‍ తొండవారేఙ్ ఇస్సా వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","అముదు దమస్కుంఙ్ ఇనెక పట్నం మేర్రం ఏద్దెన్. వెంటని ఆబార్ తన ఒక్కొ వెలుఙ్ వత్తిన్ అంనే తిర్రగొర్ తరియ్‍తిన్. ");
INSERT INTO nit_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","అముదు బూమి పోయ్యిరాల్లుతు. అని అముదు వెంట ముడేకా లేగున్ వినుత్న, “సౌలా! సౌలా! తనుంఙ్ అనుగు తక్లిబ్ సియ్యిస్సాతివ్?” ");
INSERT INTO nit_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“ఎ ప్రబు! నీవ్ ఎంద్ ఎన్నివ్?” నీవ్ తక్లిబ్ సియ్యిక యేసునన్ ఎద్దున్ ఇసా ఒక్కొ లెంఙ్ విన్కెవత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","గని సులుత్ పట్నముంఙ్ “సే” నీవ్ తనేద్ ఇందరేకాందో అత్తిన్ ఇనుంఙ్ కరిలాద్. ");
INSERT INTO nit_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","సౌవుల్‍నాడ్ సేరేగ్న ఔర్ మక్కకేర్ తనయ్ ముడ్సెటా సురుమి ఇల్‍స్సర్. ఔర్ ఆ లేంగవిస్సార్గని ఔర్ ఏరుగ్గి కండ్కెతేర్. ");
INSERT INTO nit_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","బూడున్ రాలుత్ అనెక సౌలు సులుత్ అముదు ఓలెంఙ్ ఇంతెంద్ గని అమ్నుంఙ్ తనయ్ కండ్కెరెతిన్. ఔర్ అంనే కేయ్యున్ సుమ్ముతు దమస్కుంఙ్ అడిగిప్సా కొర్సార్. ");
INSERT INTO nit_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ముద్దిఙ్ దినల్లుఙ్ ఏంత్ అముదు తమెమి ఓలెతెంద్ గుడ్డిలాంఙ్ సద్. అముదు తినెక ఉనెకవున్, తనెని ఓలెతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","దమస్కుంఙ్ యేసునే అననియ ఇనెక ఒక్కొ సిసుంద్ అంనేద్. ప్రబువు విసాద్ ఇసా సమాదనం ఇడ్తెంద్, అననీయ అన్నె పేర్ ఇనెకద్ ఒక్కొంద్. “ఇందో, ఇంతిన్ అస్సాత్ ప్రబు!” ఇస్సా అముదు జావాబ్ సియ్యితేద్. ");
INSERT INTO nit_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ప్రబువు అంనాడ్, “సర్కక్ సంది ఇనెక కూగేకా సంది అనెకా యూదక్” ఎల్లంఙ్‍ సేరుతు “తార్పు” ఇనెక పట్నంతన్ వారుడు సౌలు ఇనెక మన్కక్ సటీ వేల్లుతుఓల్. అముదు పార్తన కాల్సనంసాద్. ");
INSERT INTO nit_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","సౌలునాయ్ దర్సన్. అననీయ పెర్తన్ మన్కక్ అనంఙ్ వారేకానును ఓల్తెన్ అని అంమనేత్ నందుర్ మల్ల రొబ్బడేకాందుగు సటీ తన్ పోయ్యి కేయ్యుత్ ఇండేకానున్ ఓల్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","అనగ్తి అననీయ ప్రబు ఈ మన్కక్ యెరూసలెముత్ ఇనే నీ మంది ఏంతేఒ పవిత్ర కత్న అస్సన్ ఇస్సా అంమదును బదోల్ ఎందరొ ముత్తికులాండ్ వింతన్. ");
INSERT INTO nit_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","అని ఇత్తిన్నాయ్ ఇనేత్ పేర్ సుమేకార్ సాట్టముని కటుత్ కొసెంఙ్ సటీ బర్స దెయ్యలకేరే తన్ అదికార్ సుమ్ముతు దమస్కుంఙ్ వతెంద్ ఇసా ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","అప్పుడి ప్రబువు అననీయనాడ్, “సే! అనే పేర్ యూదు లెర్సెటరున్, ఔరె రాజకేర్, ఇస్రాయేలు మన్కకేరుంఙ్ ప్రచర్ ఇండెకాందుగు ఇమ్నున్ ఒక్కొ సేవాక్లఙ్ ఆస్తన్. ");
INSERT INTO nit_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","అన్నె పేరడ్ అండన్నిగుల్ కస్టల్ పండెఙ్ వార్సదొ అన్ అంనుంఙ్ ఇడ్సతును” అన్ అమ్మున్ ఓలిప్సత్ ఇంతేన్. ");
INSERT INTO nit_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ఆ వేనుకాంత్ అననీయ అత్తరన్ కురుయుత్ సౌలు అనెక ఎల్లఙ్ సెస్నాద్. తనే కేయ్యులున్ సౌలు పోయ్యి ఇండుతు, “దాదకేర్! యేసు ప్రబున్ నివ్ ఇంతిన్ వారెఙ్ ఇనుగు పావుతు కండ్కెద్దెన్, అమ్‍ది, నీవ్ ఓలతిసా, పవిత్ర ఆత్మ ఇనంతి నిండేఙ్ ఇస్సా అనున్ పన్కతేంద్” ఇస్సా ఇంతేద్. ");
INSERT INTO nit_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","అప్పుడి కయ్యేనే పొలస్‍ లంఙ్‍ సౌలు కండ్ల తన్ రాల్లుత్న బూడున్ రాల్సావ్. అముదు ఓలెఙ్ ఎద్దేన్. అముదు సుల్లుత్న బాప్తిస్మ ఎక్కతేన్. ");
INSERT INTO nit_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ఆ దమస్కుంఙ్ వెనుకాంత్ కొంచెం అంబ తిందే అంనుంఙ్ తక్కద్ వార్సద్ సౌలు డెమాస్కుతు అనెకా సిసులాడ్ కోన్ని దినాల్ అండేద్ ");
INSERT INTO nit_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ఆ వేనుకాంత్, యూదులె సావ్డిక్లెంఙ్, “యేసు దెయ్యంమ్నె పోరక్” ఇస్సా కరిపెకాంద్ మొదల్ ఇడ్సావత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","అంమనే గొట్టికుల్ వినుతు ఔర్ సాట్టం గులేన ఏరుతు, “యెరూసలేముత్ ఈ పేరున్ నమ్మతరును అల్ఙతంద్ ఇమ్ది తా! ఇత్తినవారుతు యేసు సిసున్ కోండపేంఙి తా! అనఙ్ కొండప్తరున్ పుడారి దెయ్యలకేరత్తి మెర్రం కొసెంఙ్ ఇస్సాతి తా?” ");
INSERT INTO nit_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","గని సౌలు గులేన్ బలమడ్ దమస్కుంఙ్ బ్రతకేక్ యూదుల్లుగు, యేసు ప్రబు క్రీస్తు, ఇస్సా ముక్కబల్ కత్త ఔరున్ గులేన్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","గుల్ దిన ఎద్దె యూదులు అంనున్ ఎనంఙ్ అల్ఙెంఙ్ ఇస్సా విచార్ కల్సార్ ఇసా. ");
INSERT INTO nit_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","గని సౌలుంఙ్ ఔరె విచార్ ఏర్కపట్టిన్. యూదులు అంనున్ అల్ఙేఙ్ ఇస్సా సింతేతోల్లి పట్నల బోయ్యిదాలేంఙ్ ఉసరాడ్ కాయ్యెనేర్. ");
INSERT INTO nit_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","గని అంనే సిసు సింతే అంనుంఙ్ ఒక్కొ డాల్లత్ డప్పుత్ కోటత గోడకతన బూడున్ డింప్సర్. ");
INSERT INTO nit_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","సౌలు యెరూసలేముంఙ్ వాత్తె సిసులాడ్ కాల్లయ్యెకాందుంఙ్ కొస్సిద్కలస్సన్. గని ఔర్ అముదు సిసుద్ ఇసా బరొస తోసెటా సిమ్కన అంనున్ అర్సార్. ");
INSERT INTO nit_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","గని బర్నబా అంనున్ కూగుత్ అపొస్తులున్ మేర్రం వారుతు అవురడ్ సౌలు సేరెకత్ని ప్రబునున్ ఓలుత్ ముటెద్ ఇసా, అముదు దమస్కుంఙ్ యేసునే పేరున్ హిమ్మతడ్ ఇండ్సద్. ");
INSERT INTO nit_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","అర్రితోసెట తిరిగ్స ప్రబునే పేరున్ హిమ్మతడ్ ఇడ్స సౌలు ఔరడ్ కలయుత్ యెరూసలేమ్ సిమ్కన తిరుగుత్ ప్రబున్ బదోల్ ఇడ్తేంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","గ్రీకు ముడెకాంద్ యూదులడ్ ముడుత్ అండెర్ గని ఔరు అన్ అల్ఙెంఙ్ ఇస్సా ఇస్సార్. ");
INSERT INTO nit_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","దాదకేర్ ఇంద్ ఒర్కిఎరేంఙ్ అంనున్ కైసరియంఙ్ కోసుత్ అత్తరనా తార్సు పట్నముంఙ్ పన్కస్సార్. ");
INSERT INTO nit_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","మల్ల యూదయ, గలిలీయ, అని సమరయ బర్సెలావ్ సంగమ్ క్లెంఙ్ తక్కలిబ్ ఏరేత్తిన్. సాంతి సమాదానడ్ పవిత్ర ఆత్మనె మద్దతడ్ మండడిక్ ఇమతడ్ వడిల్తె. అని ప్రబునె అర్రినడ్ అండ్గ్నె మండడి వాడిల్లుతు సేస్సద్. ");
INSERT INTO nit_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","పేతురు దేసెంసిమ్కన తిర్గుత్ “లుద్ద” ఇనేక పట్నముత్ అనెకాంద్ దెయ్యంమ్నె పవిత్ర కలయేకాదుంఙ్ సేస్సన్. ");
INSERT INTO nit_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","అత్తి ఎన్నమేది సాల్కు తన్ లాక్వనాడ్ తేర్ సుమ్ముడు “ఐనెయ” పేర్ తాంద్ ఇనెకనున్ కలైరయ్ ");
INSERT INTO nit_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","పేతురు “ఐనెయ! ఇస్సా కూగుత్ యేసు క్రీస్తు ఇనుగు సోయ్ కాల్సన్. సులుత్ ఇనె గదిన్ సావరిప్!” ఇస్సా ఇంతేద్ ఐనెయ వెంటాయ్ సులుత్ ఇల్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","లుద్ద, సారోను పట్నముత్ అనెకనున్ ఔరు సాట్టం ఓలుత్ ప్రబునున్ పోయ్యి విస్వాసం ఇట్టేర్. ");
INSERT INTO nit_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","“యొప్పే” ఇనెక పట్నముత్, తబితా ఇనెకా సిసురాల్ అండద్. ఈ పేరుంఙ్ గ్రీకు బాసత్ డుప్ప ఇస్సా అర్దం. ఇద్నె అర్తం దొర్కా ఇంతె జిక్క గరిబుల్లుఙ్ మందత్ కల్సా అన్సాంద్. ఎప్పుడి సోయ్ తత్ పనిక్ కాల్సానంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ఆ వేలంఙ్ అద్ దుక్కమాడ్ తిక్తీన్. పిల్లనె కురును ఈర్ ఒడుపుత్ మడ్డి పోల కోలిత్ ఇంటేర్. ");
INSERT INTO nit_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","లుద్ద, యొప్పే పట్నముంఙ్ ఎన ఎక్వదావ్ తోతెంద్ మెర్రం అంనుదు. పేతురు లుద్దయొప్పే పట్నముంఙ్ మెర అస్సాన్ ఇస్సా, సిసు విత్న కొరుమ్ కల్సెట తమున్ వై వా ఇసా అంమదును వింతి కల్స ఇదరునాయ్ అంనున్ వై పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","పేతురు అవురును వెంట సెసంద్. అముదు వారేగయి మడ్డి పొయ్యి కోలింఙ్ కొసుత్ సేస్సన్. అత్తన్ సుంట్ వాత్తవ్ రేడెరాసికుల్, దొర్కా బత్కుత్ అండపూడ్ కుట్త జుఙ్ఙెలున్ ఓలిప్స అర్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","పేతురు ఔర్ ఇద్దరున్ కొల్లితన వాకహపన్కుతు తనె ముడుసులాండ్ పార్తన కాల్సన్. కురునువై తిర్గుత్, “తబితా సుల్!” అని ఇస్సాన్. పిల్ల కండ్లు పుసుత్‍ ఓల్తిన్. పేతురున్ ఓలుత్ సులుత్ ఉత్సద్. ");
INSERT INTO nit_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","అముదు కేయ్యుత్ సియ్యుతు పిల్లఙ్ ఇల్లేకాందుగు మందత్ కాల్సన్. ఆ వెంటాయ్ పేతురు పవిత్ర, రేడేరాసికుల్లును కూగుత్ ఔరుంఙ్ పానమడ్ అనెక్ తబితాన్ ఓలిప్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ఈ కబుర్ యొప్పే జాగ్గలెఙ్ పూరాయి నేరయ్యతిన్. ఎందరొ ప్రబున్ నమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","పేతురు యొప్పేత్ సీమోన్ ఇనెకా ఒక్కొ కేర్రికుల్ కుట్టెకానే ఎల్లత్ గులేన్‍ దినల్ అండేన్. ");
INSERT INTO nit_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","కైసరియ ఇనెక పట్నముత్ కొర్నేలీ పేర్ తంద్ ఒక్కొ మన్కక్ అనెన్. “ఇటలీ” సైనికు లోప ఇనెక రోమ సైనిక్లె దొడంద్ అండేన్. ");
INSERT INTO nit_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","అముదు ఎల్లతరున్ వెంట్ట, దెయ్యముంఙ్ పార్తన కన్నెంద్. యూదులుంఙ్ దాన్ దర్మ కల్స ఎప్పుడి దేయ్యముంఙ్ పార్తన కన్నెంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ఒక్కొ దినం దూపరి అందెజ ముద్దిఙ్ గంటలప్పుడ్‍ దెయ్యమ్నె దూత్ అమ్నున్ మేర వత్న, “కొర్నేలీ” ఇసా కుగెకదున్ దర్సనుత్ సొయ్ ఒల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","కొర్నేలీ అమ్నున్ వై ఓలుత్ గుల్‍ అర్సుత్, “ప్రబూ” తన్నెద్? ఇసా వేలెంఙ్. అదుఙి దూత్, ఇన్నె పార్తన దొడలుంఙ్ నీ కలెక దాన్ దర్మ దెయ్యమ్నె జగత్‍ అదిలంఙ్ గదియెంఙ్. ");
INSERT INTO nit_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","పఙ్ఙి యొప్పేంఙ్ నీవ్ కొన్సెం మందిన్ పన్కుత్, పేతురు ఇసా మరొక్కొ పేర సీమోనున్ కుగల్ ఇంత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","అముదు పంఙ్ఙితుఙ్ సీమోన్ ఇనెక కేర్రికుల్ కుంట్టెకానె ఎల్లత్ సుట్టంమ్లఙ్ అన్సాంద్. అంమనే ఎల్ల సముద్రం దార్డి మెర్రం అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","దెయ్యమ్నె దూత్ కురుయుతు సెద్దిన్. ఆ వెంటని కొర్నేలీ తనె గాండియకేరుఙ్ ఇద్దరును కుంఙ్ సాంద్. ఎల్ల పనికుల్ ఇందరేకా సిప్పాయిలతి ఒక్కొనున్ కుంఙ్ సన్. ఈ సిప్పాయి దెయ్యమ్నె బక్తితన్ అస్సన. ");
INSERT INTO nit_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ఎందద్ అముదు సిమ్మక్న ఔరుంఙ్ ఇండుతు అవురును యొప్పేంఙ్ పన్కస్సద్. ");
INSERT INTO nit_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","మరొక్కొ ఒక్కొ దినం. ఔర్ పావడ్ సెరెగ్న యుప్పే ఊరుఙ్ మెరా ఎర్సార్. అప్పుడు దూపరి పన్నెండు గంటల్. పేతురు ఎల్లత్ మిద్దెపొయ్ పార్తన కలెంఙ్ సెసంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","పేతురుంగు కారవార్సద్. తనెన్ ఎన్న తినెంఙ్ ఇసా ఇంతేద్. అంమదుగు సటీ వేయ్యిగలేకాంద్ తయార్ కాలెఙ్ అంమదుగు దర్సనం ఏర్సన్. ");
INSERT INTO nit_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ఆ దర్సనముత్ ఆబార్ ఉగ్గుడిల్లుతు బుడును డిగ్గుతు వారేకాంద్ ఓల్సన్. అముదు ఒక్కొ దండి దుప్పటిలాంఙ్ అన్సాంద్. ఎరొ అమునున్ నాలిఙ్ మూలల్ సుమ్ముతు బుడును డింప్తెతిలాంఙ్ అముదు బూమి పోయ్యి డిగ్గతిన్. ");
INSERT INTO nit_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","అత్తి బూమీ పొయ్‍ అనేక రాంక్మిల్ జనవాల్, పరకెకవ్, ఆబార్ పోయ్ ఉండలేక్ పిట్టల్ అస్సావ్. ");
INSERT INTO nit_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ఒక్కొ లేంఙ్‍, “పేతురు, సుల్! అందవును అల్గుత్ తిన్” ఇస్సా ఇంతిన్. ");
INSERT INTO nit_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","గని పేతురు, “ప్రబు! అన్ అపవిత్ర ఎద్దదున్. సొబతాదూన్, సోయ్ అస్సేటందూను అన్ ఎప్పుడి తినేతన్” ఇస్సా జవాబ్ ఇడ్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ఆ లేంఙ్ మల్ల వింతన్, దెయ్యం ఆ పవిత్ర ఇందత్వ అందవును అపవిత్ర ఏరేంఙ్ తోంద్. ఇసా ఇడ్డతన్ ");
INSERT INTO nit_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ఇనంఙ్ ముద్దిఙ్ ఉస్సాల్ జరఙ్త అప్పుడి అముదు ఆబారుంఙ్ కొసుత్ సెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","పేతురు ఈ దివ్య దర్సనమును అర్దం కరిల్ఎట అమ్నున్ బదోల్ గులేన ఎరుతు విచ్చర్‍కాల్సానంనెన్. అంతేతి కొర్నేలీ పన్కత్ మన్కకెర్ సీమోను ఎల్ల ఎత్తిఅన్సదొ రొబ్బపుతు అంమనె ఎల్ల బొయ్ద ముండాట ఇల్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“పేతురు ఇస్సా కూగ్సతిర ఆ సీమోన్ ఇంతిన్ సూట్టంలాంఙ్ అస్సన్‍ దా?” ఇస్స ఎల్లతరును వేల్సార్. ");
INSERT INTO nit_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","దర్సననమును బదోల్ పేతురు మల్ల విచ్చర్ కాల్సఅనెఙ్ దెయ్యనే ఆత్మ అంమనాడ్, ఇందొ! ముగ్గుర్ మన్కకెర్ ఇనుగు సటీ కిరవ్సనంసార్. ");
INSERT INTO nit_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","సులుత్ బూడున్ సే. అవురును పన్కతన్ అని. అనగ్తి ఔర్ వెంట సెరేకాందుగు కొంచెం గిన తోద్ ఇస్సా ఇండ్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","పేతురు బుడును సెత్న అవ్రడ్, “ఇందొ! నీర్ కిరవేకారన్ అని అనుగు సటీ! తనుంఙ్ వాత్తిర్!” ఇస్సా వేల్సన్. ");
INSERT INTO nit_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ఔర్, “అంమ్ కొర్నేలీ సైనిక్లె దొడంద్. అముదు నీతి తద్. దెయ్యమున్ పోయ్యి అర్రినాడ్అనెకాంద్. యూదులు సాట్టం మన్సిసార్. ఇంమును తనే ఎల్లంఙ్‍ కూగుత్ నీర్ ఇండత గొట్టిన్ వినెగ్ఇస్స పవిత్రతంద్ దెయ్యమ్నె దూత్ అంమదుగు ఇండ్సన్” ఇస్సా సాక్స ఇండ్సర్. ");
INSERT INTO nit_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","పేతురు అవురును ఎల్లంఙ్‍ వార్రీస్స కూగుత్ ఆ సీంతే అత్తిని అన్ ఇస ఇంతేద్. మరొక్కొ దినం యొప్పే అవురును వెంట దాదకేర్ సేరెఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ఆ మరొక్కొ దినం ఔర్ కైసరియఙ్ గద్దిస్సార్. ఇవ్ర వార్సనంస్సార్ ఇస్సా ఒర్కిలుత్ కొర్నేలీ దొస్తులును సుట్టలును తనె ఎల్లంఙ్‍ కుంఙ్ సన్. ");
INSERT INTO nit_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","పేతురు ఎల్లత్ జాగ ఇండేగ్నాయి కొర్నేలీ అంమదును ముందర్ సేరుతు అంమనే గెట్టల్ మొక్సన్. ");
INSERT INTO nit_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","పేతురు అంమదును సుల్లుప్స, “సుల్! అన్ గిన ఒక్కొ మన్కకి” ఇస్సా ఇంతేద్. ");
INSERT INTO nit_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","పేతురు అంమనాడ్ ముడ్స లోప సెస్సన్. అత్తిన్ గులెన్ మంది మన్కకెర్ మిర్యతరున్ ఓల్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","పేతురు అవురడ్, యూదు, యూదు ఎర్ససేటర్ ఇనుఙ్ ఒర్కి అంమనాడ్ కలయుత్ అనెఙ్వారెద్, అంమనె ఎల్లంఙ్‍ సేరెగ్తొద్ ఇస్సా యూదులే న్యాయ సాస్త్రరు ఇట్సద్. ఇంద్ తప్పు ఇస్సా సాట్టముంఙ్ గి ఎర్కాయ్. అనగ్తి ఏ మన్కకున్ జమ్మిల్ద ఇస్సా ఇనెగ్తొద్. అపవిత్ర ఇస్సా ఇనేగ్తొద్ ఇంద్ అనుగు దెయ్యం ఇండ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","అనఙ్ ఎంతి అనుంఙ్ కుగ్తపుడ్ కారన్ ఇడ్సెటయ్ వాత్తన్. అనును తనుంఙ్ కూగ్త్తిరొ అన్ పంఙి కారనం వేలేఙ్ వాంద్? ఇస్సా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","కొర్నేలీ ఇనంఙ్ ఇడ్సన్. నాల్లిఙ్ దినల్ తన్ ఇంది గంట్కత్ ఏల్లత్ ఉద్దుత్ దెయ్యమున్ పార్తన కాల్సనంసాత్. అప్పుడు దూపరి ముద్దఙ్ గంటల్. ఒక్కదిఉస్సాట్ తెల్లొడి మెర్యెకా జుఙ్ఙెల్ తొడుత్ ఒక్కొ మన్కక్ అన్ ముండట్ ఇల్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","అముదు అనాడ్, కొర్నేలీ! దెయ్యం ఇనే పార్తన వింతేన్. నీవ్ గరిబుల్లుఙ్ ఇందరేకా సీయ్యితవ్ల్లును అద్దికాంతేన్. ");
INSERT INTO nit_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","పేతురు ఇస్సా ఇనెకాద్ సీమోన్ను కూగుత్ కొరెకదూఙ్ కొన్సెం మందిన్ యొప్పేంఙ్ పన్క అముదు పంఙి సీమోన్ ఇనెకా కుటేకన్నె ఎల్లత్ సుట్టంలాంఙ్ అన్సాంద్. ఈ కేర్రిక్ తోల్నె పని కలెకనె ఎల్ల సముద్ర దర్డిత్ అన్సాంద్ ఇస్సా ఇండతేన్. ");
INSERT INTO nit_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ఇమును కూగుత్‍ కొరేకదుంఙ్‌ వెంటాయ్ మన్కకేరును పన్కతన్. నీర్ వారుతు సోయ్త కామ్ కత్తిర్. పంఙి నేండ్ సాట్టం దెయ్యంమ్నె ముండట్అస్సాతుము. అంముగు ఇండ్ఇస్సా ప్రబువు ఇముంఙ్ అజ్నసీయ్యితవ్ సాట్టం వినెకాందు తయార్ అస్సాతుము. ");
INSERT INTO nit_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","పేతురు ఇనంఙ్ ఇండేకాంద్ మొదల్‍ ఇట్టెన్! దెయ్యమ్ కమ్మిజస్తి ఎరుంఙి కమ్మి కల్సెట సాదర్ మందిన్ సొయ్ ఒల్సాద్ ఇసా అన్ కరె ఒర్కిల్తన్. ");
INSERT INTO nit_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","అర్ మందింఙ్ తన్నవాలడ్ అర్రిఅర్సెకర్ నీతి అడ్గెకరున్ అముదు మనిల్సాద్ ఇసా ఒర్కిల్సాత్. ");
INSERT INTO nit_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ఈ సందేసమును దెయ్యం ఇస్రాయేలు కాంన్ద తరుఙ్ గాంద్దిప్సద్. దెయ్యం నేండుఙ్ సాట్టముంఙ్ గి ప్రబువు యేసు క్రీస్తు నాండి సాంతి రొంబడ్సాద్‍ ఇస్సా సోయ్త గొట్టిన్ ఇండ్సన్. ");
INSERT INTO nit_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","యోహాను ఇడ్త బాప్తిస్మ మును మన్కకెర్ సుమ్ముస్సేట్ గలిలీయ త్ ఒక్కొ గోట్టి మొదల్ ఎద్దిన్. ఆ గొట్టిన్ బదోల్ గొట్టికుల్ యూద జాగత్ సాట్టం నెరయ్త్తిన్. ఇంద్ ఇంముగు సాట్టముంఙ్ గి ఎర్కయ్యి. ");
INSERT INTO nit_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","నజరేతు అనెకా యేసు దెయ్యం పవిత్ర ఆత్మనాడ్ అబిసేకం. గుల్లెన సక్తి సియ్యితెన్. దెయ్యం అంమనాడ్ అనెకాంద్ వాలడ్ యేసు మందిఙ్ సోయ్ కాల్స అని జాగలెంఙ్ తిర్గతెన్. బూత్ అంట్త మన్కకేరును సోయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","యెరూసలేముత్, యూద దేసెముతు అనెక మిక్త జాగలెంఙ్ అముదు ఇంద్‍రవ్ ప్రతి కామున్ అంమ్ కండ్లాడ్ ఓల్తమ్. ఔర్ అంమనును మొద్నెనాడ్ ఇందరుడు సిలువాంఙ్ కిరా లంఙ్ అల్గతెర్. ");
INSERT INTO nit_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","గని మూడవ దినముగు దెయ్యం అమ్నున్ తిక్తతన సుల్పతిన్. అంమనె మన్కకెరుంఙ్ కండ్కెఙ్ ఇస్స దెయ్యమ్నె ఉద్దేస్. ");
INSERT INTO nit_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","సాట్టం అంమదును ఓలెతేర్. పఙ్ఙి గియి ఏంత్ దెయ్యం అస్సాతర్ కొన్సెం మంది మాత్రమి ఓల్తెర్. అంమి సాక్సులమ్. అముదు బతుకుతు వాత్తె అమ్ సాట్టం అంమనాడ్ కలయుత్ అంబ తిన్‍దమ్. ");
INSERT INTO nit_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","అముదు సాట్టముంఙి న్యాయ్ ఇంతే బత్కుత్ అనెక ఔరుంఙ్, తిక్తతన్ సుల్తార్ అవురును. దెయ్యం అంమదుగు సీయ్యితెన్. ఇమ్నున్ బదోల్ మందిఙ్ ముండట్ సాక్సం ఇండ్ఇస్సా, సొయ్త కబుర్ ఇడ్డెంఙ్ ఇసా. అముదు అంముగు అజ్నసీయ్యితెన్. ");
INSERT INTO nit_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","యేసును నమ్మతర్ తమ్మె పాప్ లుగు అముదు పేర మాపీ రొబ్బదిస్స కబుర్లకేర్ సాక్స ఇండ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","పేతురు ఈ గొట్టిక్ ముడ్స అనెఙయ్ అంమనె సందేసమున్ వినేకర్ అత్తిన్ అనెకా సాదరుంఙి పోయ్యి పరిసుద్దత్మ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","యుప్పె తార్ పేతురునాడ్ వాత్తర్ సాట్టమి యూదులు. సున్నతి సుముత్ నమ్సెటార్ వెంట గిన పరిసుద్ద ఆత్మాన్ అవ్రతి గిన సియ్యెకాద్ కమల్ ఎద్దేర్. ");
INSERT INTO nit_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ఔర్ మరొక్కొ బాసలాండ్ ముడ్స దెయ్యంమ్నెత్ స్తుతి కాలేకారున్ అత్తిన్ విసనన్నెర్! అప్పుడు పేతురు ఇస్సాన్. ");
INSERT INTO nit_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ఇవురుగు బాప్తిస్మ సియ్యెకాదుంఙ్ అడ్డమ్ ఇండేకా దైర్యం ఎరుఙ్ అన్సాంద్? నేండ్లాఙి ఇవుర్ గిన దెయ్యంమ్నె పరిసుద్దత్మ రొంబడ్సాద్‍. ");
INSERT INTO nit_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","యేసు క్రీస్తునే పేరడ్ ఔర్ బాప్తిస్మ సుమ్మెఙ్ ఇస్స పేతురు ఆగ్య సియ్తెంద్. ఇద సాటం తిర్తె ఔర్ పేతురున్ అంమును వెంట కొన్ని దినల్ అన్ వేల్సార్. ");
INSERT INTO nit_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","అపొస్తులున్, యూదియ దేసతు అనెక్ విస్వాసు, యూదు లెర్సెటరున్ దాదకేర్ గిన దెయ్యమ్నె సందెస్ సుంమెకాద్ ఇసా విచార్. ");
INSERT INTO nit_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","అపుడ్ పేతురు యెరూసలేముగుంఙ్ సెదంద్. యూదులెర్సెటర్ సున్నతి కాలేఙ్ ఇసా కొన్సెం మంది అంమున్ ఇన్నతేంద్, ");
INSERT INTO nit_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","నీవ్ సున్నతి ఇందర్ సెటరె ఎల్ల సెత్ అవురాడ్ కలయుత్ తిందివ్! ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","పేతురు ఔరుంఙ్ జరిగిల్తద్ జరిగిల్తెతి ఈ పేలె తా అనిగ్నాయ్ నాయ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","అన్ యొప్పే పట్నముత్ పార్తన కాలెఙ అనుంఙ్ దర్సన్ ర్రొబ్బటిన్. ఆ దర్సనముత్ ఒక్కొ దండి ఓల్తన్. ఆ దివ్య దర్సనముత్ ఒక్కొ దండి దుప్పటిలాంఙ్ అనెకాద్ ఒక్కొద్ నాల్లిఙ్ మూలల్ సుమ్ముత్ ఆబార్ తన బుడును డింప్తెతిలాంఙ్ ఓల్తన్. అముదు అన్ ముదర్వై ఇల్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","అన్ అత్తి తనేద్ అన్సాద్ ఇసా సోయ్ ఓల్తన్. ఊర పూర పొరయెకా జన్వల్ అడవి జన్వల్, పరకెక జన్వల్, ఆబార్త పిట్టా బూమి పోయ్ బత్కెకావ్ పానం జన్వల్ పురయ్ అన్సా ");
INSERT INTO nit_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","అత్తేతి అనుగు ఒక్కొ అవజ్ విన్కెవత్తిన్, పేతురు! సుల్! ఇదవ్లున్ అల్గుత్ తిన్! ఇసా అన్నాడ్ ఇడ్డెద్. ");
INSERT INTO nit_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ప్రబు అన్‍ ఆ పని కాలేఙ్ సాలేన్! అపవిత్ర ఎద్ద తింసేటవున్ ఇంతే గిన అదున్ అనే నాల్క ఎప్పుడి రూసి ఓలెతిన్ ఇస్స జావాబ్ సియితేన్. ");
INSERT INTO nit_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ఆబార్ తన ఆ అవాజ్ నింమట్ ఇనంఙ్ ఇంతిన్, “దెయ్యం పవిత్ర తినేంఙ్ సియ్ తవున్ ఎదవుని తినెంఙ్ తోద్ ఇసా ఇన్నెర్ ఇంతవ్ అదవును తినేఙ్ అపవిత్ర ఇన్నెమ్.” ");
INSERT INTO nit_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ఇనంఙ్ ముద్దిఙ్ ఉస్సల్ ఎందిన్ అముదు ఆబారుఙ్ తోడసేద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","అద్ది గట్కదుక్ అన్ కూగుత్ కొసెకదుంఙ్ కైసరియ తన వాత్తర్ ముగ్గుర్ మన్కకెర్ అన్‍ అనెకా ఎల్లముండట్ ఇల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ఔరడ్ సేరేకాందుగు అన్ ఏ మాత్రం వేనకావారేఙ్ తొంద్ ఇస్సా దెయ్యంమ్నె ఆత్మ అనాడ్ ఇడ్తిన్. యొప్పె తనట్ ఔరుంఙ్ దాదకేర్ కైసరియ అత్తి అనెకా అన్ వెంట వత్తెర్. అంమ్ సాట్టం కాల్లయ్యుత్ కొర్నేలీనే ఎల్లంఙ్‍ సేద్దమ్. ");
INSERT INTO nit_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","కొర్నెల్ అమ్మడ్ ఒక్కొద్ ఓల్తన్ ఇసా ఇడ్తెంద్. దెయ్యంమ్నె దూత్ ఎల్ల ముదర్ ఇల్లుత్ అమ్మనడ్ నివ్ కొన్సెం మందిన్ యొప్పేంఙ్ పవిదుత్ సీమోను పేతురున్ కూగుత్ కో ఇసా, ");
INSERT INTO nit_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","అముదు ముడెకా గొట్టిక్ ఇన్, ఇన్నె ఎల్లత్ ఔరున్ సాదరున్ బత్కిప్ సార్. ");
INSERT INTO nit_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ఎపుడ్ అన్ ముడేకద్ మొదల్ ఇండేఙ్‍, పేలె నేండున్‍ పోయ్యి పరిసుద్దత్మ ఎనంఙ్ వాత్తినో ఔరున్ పొయ్యి నై వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","యోహానున్ ఈరడ్ బాప్తిస్మ సియ్తెంద్ గని నీవ్ పరిసుద్దాత్మత్ బాప్తిస్మ ఏక్సాతివ్, ఇసా ఇత్త ప్రబువు ఇడ్త గొట్టి అనుగు అది వాత్తేవ్. ");
INSERT INTO nit_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","నేండ్ యేసు క్రీస్తు ప్రబునున్ నమ్మతందుఙ్ నేండుంఙ్ సియ్త వరమున్. దెయ్యం యూదు ఎర్సెటరుంఙ్ నై సియ్తిన్. అంటాప్పుడు దెయ్యమున్ అర్పులిపెంఙ్ అన్ ఏద్? ");
INSERT INTO nit_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ఔర్ ఇద గొట్టికుల్ వింతే ఔరె అడ్డమ్ కాలేఙ్ తోద్. దెయ్యం బత్కున్ యూదు లెర్సెటరుంఙ్ గిన మన్ బద్లిపుర్ అనెఙ రక్సన సుమేకా మొకాసియ్యిత్తేన్ ఇస్సా ఔర్ దెయ్యమున్ స్తుతికాల్సర్. ");
INSERT INTO nit_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","స్తెపన్ తిక్తత్ మల్ల ఎద్ద తక్లిబ్ వాలడ్ విస్వాసిక్ ఇదే అదే ఎర్సర్. ఇవురాత్తి కొన్సెం పొనీసియ, సైప్రసు, అంతియొకయ పట్నముంఙ్ సెద్తర్ దైవా సందేసున్ యూదు మాత్రమి ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","సైప్రసు, కురెని పట్నలుంఙ్ సెద్దర్ అరత్తిన్ కొచేం అంతియొకయ సేత్, గ్రీకు గొట్టి ముడెకాంద్ యూదులున్ గిన ముడేకద్ మొదల్ యేసుంది ప్రబుద్ ఇసా ఎడ్తర్. ");
INSERT INTO nit_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ప్రబునె సక్తి ఓరున్ వెంట అన్సాంద్. అనగేత్తి ఎంతెయొ ఔర్ ఇడ్తదున్ అమ్నున్ అనెక సత్తెన్ ఒర్కిలుత్ ప్రబున్ పోయ్యి విస్వాసులు ఎద్దేర్. ");
INSERT INTO nit_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","యెరూసలేముత్ అనెకా సంగమ్ ఈ గొట్టి వింత్‍ బర్నబా అంతియొకయ పన్కతిన్. ");
INSERT INTO nit_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","అముదు అంతియొకఙ్ సేరుతు అంత్ మన్కకెర్ పోయ్యి దెయ్యంమ్నె దయ నిండుత్ అనెకాంద్ ఒర్కిలుత్ గులేన కుసీంఙ్ వాత్తేన్. ప్రబున్ పోయ్యి మన్నడ్ బక్తి ఓలిప్స అండ్రిసా. అత్తరున్ సాట్టంమందిన్ వింతి కాల్సన్. ");
INSERT INTO nit_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","బర్నబా సోయ్ తంద్. పరిసుద్దాత్మ సక్తి అమ్నున్ పోయ్యి సిమ్కనయ్ అన్సాంద్. అంతేయ్ తోంద్ దెయ్యంమ్నె వాలడ్ సిమ్కకన్ విస్వాసం అన్సాంద్. ఎంతేయో మంది ప్రబున్ పోయ్యి విస్వాసుల్ ఎర్సర్. ");
INSERT INTO nit_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","అదున్ వెన్కత్ బర్నబా, తార్సు ఇనెక పట్నముంఙ్ సేరుతు సౌలుంఙ్ సటీ ఓలత్ ఇసా. ");
INSERT INTO nit_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","అముదు కలయుత్ అంతియొకయ కూగుత్ వార్సన్. సౌలు, బర్నబా ఒక్కొ ఏండ్గాలం అంతియొకయత్తి అస్సార్. అంత్ సంగమును కాలయ్సా ఏంతేయె కర్పనేర్ ఔర్. అంతియొకయత్ సిసు పేలె ఉస్సాట్ “క్రీస్తులున్” ఇస్సా కూగునేర్. ");
INSERT INTO nit_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ఆ దినములేంఙ్ కొన్సెం మంది ప్రవక్త లె యెరూసెలేము తన అంతియొకయ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ఔరత్తి ఒక్కొనే పేర్ అగబ్. అముదు సుల్లుత్ ఇల్లుత్ పరిసుద్దత్మ సక్తినాడ్, గుల్లెన కార్వ జల్దిని సదర్ దున్యంఙ్ వారేకాంద్ ఇస్స ఇండ్తెన్, ఏడ్ సాల్కు కరువూ వర్సాద్ ఇసా క్లౌదియ రాజక్ రాజ్ కాలముత్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ఇంద్ వినుతు అంతియొకత్ అనెకా సిసు యూదయుతు బత్కకేక్ తనే వెంట దాదకేర్ సటీ తమ్ముంఙ్ ఎత్తిఎంత్ ఎరద్ అత్తిన్ మదత్ ఔర్ ఇదరెంఙ్ ఇసా నిర్నయం ఎక్కతెర్. ");
INSERT INTO nit_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ఔర్ అనంఙ్ ఇదర్తపూడ్ ఇంత్ విదమాడ్ బర్నబా, సౌలు నాడ్ తమ్ పన్కెకాంద్ అందవును యూదియత్ దొడలుంఙ్ పన్కతేర్. ");
INSERT INTO nit_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ఆ దినాలుంఙ్ హేరోద్ రాజక్నె సంగముంఙ్ సెరెకార్ కొన్సెం మందిన్ విరోద్ కాలెంఙ్ సురు కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","అముదు యోహాన్నె దాదకేర్ యాకోబ్‍ రూసినాడ్ కత్కుత్ అలంఙ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ఈ గట్నన్ బదోల్ యూదూ కుసీంఙ్ వర్సర్ ఇసా. ఇదున్ విత్న అముదు పేతురునాయ్ సుమెకాద్ ఇసా సెద్దెర్. ఈ గట్న యూదూలె పుల్లె తోసెట నిపట్టె తీనేక పడ్గుంఙ్ జీర్ జర్గిల్‍త్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","పేతురున్‍ కటుత్న జేలుత్ తప్‍త్తెర్ నలుగుర్ నల్లి గుంపు ఎత్నకయుర్ ఇసా ఇడుత్ పకతరుంఙ్ అమ్నున్ సియ్‍తెంద్. పస్క పండ్గుంఙ్ ఎరెంఙ్ అమ్నె మంది ముదర్‍వై కొత్న విచార్ కలెంఙ్ ఇసా అమ్నె ఉందెసం. ");
INSERT INTO nit_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","పేతురునున్ అన్‍గడి జేలుత్ అప్తెంద్. పేతురునుంఙ్ సటీ సంగముంఙ్ కలయ్‍తర్ మద్సెటా దెయ్యమున్ పార్తన కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","హేరోద్ అంనున్‍ వెలుతొలెంఙ్‍ కొరెంఙ్ ఇసా అనెంఙ, ఆజీర్ సింత్తె పేతురుంద్‍ ఈ ఊర సైనిక్ లే నడుమున్ మంఙ్సా నంసాద్. సైనిక్ అమ్నున్ ఇంద్ది ఇనుమ్త సంకెలలడ్ కట్టుత్న సాయ్‍త్తెర్. మంల్ల కొన్సెం మంది సైనికూ జేల్ ముదర్‍వై బొయ్ద కయ్‍సా నంసార్. ");
INSERT INTO nit_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","వెంటని ఒక్కొ ప్రబున్నె దూత్ ఇల్లుత్ అండాద్. ఆ కోలి సిమ్కన వెఙ్ఞడ్ నీడ్‍త్తిన్. ప్రబున్నె దూత పేతురున్నె సాట్టన్ మెలపుత్న, “జల్ది సుల్!” ఇసా ఇంత్న అమ్నున్ సుల్పు తెంద్. కెయ్యులున్ కట్‍త సంకెలలడ్ పుద్తె రాటే. ");
INSERT INTO nit_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ఆ దూత్, “సులుత్, ఇన్నె జుఙ్ఙెలున్ సోయ్‍కత్న, కేర్రిక్ తొడ!” ఇసా ఇంతెంద్. పేతురుంద్ అనాయ్ కతెంద్. “ఇన్నె దుసెలిన్ పొర్కుత్ అన్న వెంట వా!” ఇసా ఆ దూత్ ఇంత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","పేతురుంద్ అదున్ వెంట జెల్తన వకా వతెంద్. గని దేవ్ దూత్ కల్లెకాద్ సత్తెం ఎరద్‍ ఇసా ఒర్కి తోసెట అముదు ఇనెతెంద్. దర్స ఎంద్ ఎర ఇసా ఇంన్నెద్. ");
INSERT INTO nit_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ఔర్ మోదల్ కాయ్యెకనున్, రెండవ కయ్యెకనున్ దాటుత్న పట్నముంఙ్ లోపా సెరెకా ఇనుమ్‍త గుయ్యున్ మెరా వత్తెర్. అద్ ఔరుంఙ్ సటీ అద్‍నెత్ అద్ది కుర్యుత్ అండిన్. ఔర్ అదున్ దటుత్ సెద్దెర్. కొన్సెందవ్ సెరెంఙ్ అపుడ్‍తద్ అప్పుడి ఆ ప్రబున్నె దూత్ అమ్నున్ సయుత్న సెదిన్. ");
INSERT INTO nit_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","అప్పుడ్ పేతురునుంఙ్ లెస్తెంద్ వత్తిన్. అముదు, “ప్రబుంద్ తన్నె దూతున్ పన్కుత్న హేరోద్ బందన్ తన్న అని కరెయ్ ఎరెంఙ్ ఇసా ఓల్‍సా అనెకా యూదు తన్న, అన్న బత్కిప్తెంద్. ఇత్తి తనయ్ అన్మన్ తోతెద్” ఇసా తన్నెత్ తన్ని ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","జర్గిల్‍తదున్ లెక్క కల్‍సెట యోహనే అమ్మ మరియనే ఎల్లంఙ్ సెద్దెంద్. యోహానున్ మార్క ఇసానయ్ ఇంన్నెర్. అత్తిగుల్ మంది మిరయుత్న పార్తన కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","పేతురుంద్ గుయ్యున్ డగ్లిప్తెంద్. “రొదే” ఇన్నెకా రప్తిరాల్ గుయ్యున్ పుసెంఙ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","అద్ పేతురున్నె లెఙున్ విత్న గుల్‍కుసీంఙ్ వత్తిన్. ఆ కుసినడ్ గుయ్యున్ పుసెకాదున్ సాయ్యుత్న లోపా తులుత్న, “పేతురుంద్ బొయ్‍దముదర్‍వై అన్సాద” ఇసా ఇడ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ఔర్ సిమన “ఇనుంఙ్ గియన్ తోతెద్‍గయె” ఇసా ఇంతెర్. గని అద్ తన్ ఇడ్డెకాద్ కరెయ్ ఇసా జోరనట్ ఇడ్‍త్తిన్. అదున్ ఔర్, “ఇద్ అమ్నె దూత్ ఎద్దెర” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","పేతురుంద్ ఇంక గుయ్యున్ కుడ్కసానీ అన్సాద్. ఔర్ సెత్న గుయ్యున్ పుసుత్న ఓలుత్ గుల్ కామల్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","పేతురుంద్ సురుమి ఔరున్ కెయ్యడ్ సైగ్ సా సురుమ్ అడ్ర ఇసా ఇంతెంద్. ప్రబుంద్ తన్న జేల్తన ఎనంఙ్ వకా కొత్తెదొ ఔరుంఙ్ ఇడుత్ యాకోబ్ దాదకేర్ ఈ విసయున్ ఒర్కిపర్త ఇసా కురియుత్ మరొకొ జగంఙ్ సెద్దెద్. ");
INSERT INTO nit_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","తొల్లిని పేతురుంఙ్ అనెంద్ ఎద్దినొ ఇసా సైనికు గాబ్రిల్తెర్. “పేతురుంద్ ఎనంఙ్ ఎద్దద్?” ఇసా ఔర్ వెలుత్ ఓల్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","హేరోద్ పేతురునున్ కిరవెంఙ్ సిమ్కన కిరవుర్. ఇంతెంద్ గని పేతురుంద్ కండ్కెరెతెంద్. హేరొద్ కాయేకరున్ అడమ్ ప్రస్న కత్న వేల్తోల్తెంద్. అనంఙ్ ఎద్ద వెన్కత్ ఆ కయ్యెకరున్ అల్గుర్ ఇసా ఆగ్య సియ్‍తెంద్. ఇనంఙ్ ఎద్ద వెన్కత్ హేరొద్ యూద తన్న కైసరియఙ్ సెత్న అత్తి క్కొన్ని దిన అండెద్. ");
INSERT INTO nit_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","హేరొద్ తూరు, సిదొన్త మందిన్ వెంటాగుల్ రగ్గడ్ అన్సాద్. ఔర్ సిమ్కన ఒక్కొద్ ఎత్న హేరొదున్ వెంట సెద్దెర్. రాజక్ వెంట పనికలెకా సంఙ్తక్ “బ్లాస్తున్” తమ్‍వై మదత్ పాజె ఇసా వెల్‍త్తెర్. ఇవ్రె రాజ్ తమ్మె తినెకవుంఙ్ సటీ హేరొద్ రాజెనె కోలి ఔరె దేసెముంఙ్ తినెకాద్ పావిడ్సాఅన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ఒక్కొద్ నెమిప్‍త దినం హేరోద్ రాజక్నె జుఙ్ఙె తొట్టెద్. న్యాయ్‍పీట ఉద్దుత్ మందిన్ సమ్జిప్‍సా కొన్ని గొట్టిక్ ఇడ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","“ఇమ్‍దు మన్కక్ ముటర్ ఎరెద్ గని దెయ్యమి ముడ్సాద్.” ఇసా మంది జోరకాద్ వపొయ్‍త్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","తనుంఙ్ ఇంతె అముదు మహిమ దెయ్యముంఙ్ ఎరెక మయ్మన్ అముదు సుమ్తాదుఙ్ ప్రబునె దూత్ అమ్నున్‍వైనీ దుకమున్ జొపిటెద్. పుర్రె పడుత్ అముదు తిక్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","దెయ్యమ్నె గొట్టిన్ విత్న విస్వాస్ ఇడ్డెకా మన్కకెరె జనబా పెర్గసా వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","బర్నబా, సౌలు తమ్మె పనిన్ తిర్‍పుత్న యెరూసలేమ్ తన్న మలయుత్ వత్తెర్. తమున్ వెంట మార్క ఇసా కుగ్‍త యోహానున్ నాయ్ తోడ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","అంతియొకయ సంగముతు అనెక ప్రవక్త లె, పండితు హేరోద్. బర్నబా, “అదికారి అనెక సీమోన్” నీగెర్ ఇస్స ఇనెకనున్, “సుమెయాను” కురెని ఊర్రర్ లూకియ, రస్టన్ అడిగిపెకన్ వెంట పెర్గత మనయేను, సౌలు. ");
INSERT INTO nit_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ఇవుర్ ఉపాస్ కత్న ప్రబునున్ పార్తన కాల్లెఙ్ పరిసుద్దత్మ, “బర్నబా, సౌలు అనుగు సటీ. అవురును ఒక్కొ ప్రత్యెకత్ పనిఙ్ సటీ కూగుత్న” ఇస్స ఇంతేన్. ");
INSERT INTO nit_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","అత్తి అనెకర్ ఇవ్రీద్దరున్ పన్కేఙ్ ముండట్ పార్తన, ఉపాస్ అత్ పార్తనకత్నతంమే కేయ్యులిడుత్ పన్కతేర్. ");
INSERT INTO nit_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","పవిత్రాత్మ అవురును పన్కతెన్. ఔర్ “సెలూకయ” ఇనెక పట్నముంఙ్ సేరుతు అత్తరన్‍ రూకుత్ సెరెకద్ కత్న సైప్రసు ఇనెక దిపుంఙ్ గాద్దియ్సార్. ");
INSERT INTO nit_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","అత్తరన్ సలామి ఇనెకపట్నముఙ్ సేస్సర్. అత్తి అనెక దొడ యూదులె సావ్డిత్ దెయ్యమ్నె ఇండ్నెర్. ఔరుంఙ్ సహయంలాఙ్ యోహాన్ మర్కఅవురును వెంటయ్ అండేద్. ");
INSERT INTO nit_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ఔర్ ఆ దిప్‍ పూర సాట్టం తిర్గుత్ “పాపు” ఇనెక పట్నముంఙ్ గాద్దియ్తేర్. మంత్తెర కాల్స తానొక్కొ పైలి కబుర్లకెర్ ఇస్స ఇడ్సనేకా మన్కకును. యూదు. అమ్నె పేర్ బర్‍యేసు, ");
INSERT INTO nit_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","అముదు “సెర్గి సౌలు” ఇనెక ఆ దివున్‍ పాలించే కానుంఙ్ సోయాడ్ అనేన్. సేర్గిపౌలు తేలివి అనెకాన్. దెయ్యమ్నె వినేఙ్ ఇసా బర్నబా, పౌలు కూగుతేన్. ");
INSERT INTO nit_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","మత్రలక్ “ఎలుమ” గ్రీక్ బాసత్ ఇంద్ ఇంమ్మనే పేర్. రాస్ట్రత్ వగిపెకాద్ ఈ విస్వాసుంఙ్ దౌవ్ అపెంఙ్ ఇస్స కొస్సింద్‍ కత్తేద్. ");
INSERT INTO nit_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","అప్పుడు పౌలు ఇంనున్ సౌలు ఇసా కూగునేర్ పరిసుద్దాత్మనాడ్ నిండుత్ ఎలుమను సార్కకి ఓల్సా, ");
INSERT INTO nit_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","నీవ్‍ సైతనుంఙ్ పోరక్నివా! నీ సోయ్త పనికుంఙ్ నీ విరోద్! అన్సాతి నీతి ఇన్ లోప సిమన పస్సిపేంకావ్, అస్సావ్! ప్రబునే ఒక్కొ సర్కక్ పావులున్‍ కొంక్డి బంద్లిపెకాద్ ఎప్పుడి మద్సతి? ");
INSERT INTO nit_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ఇందో ఓల్, ప్రబువు పంఙి ఇనును సాజ్ సియ్యిస్సత్. కొన్సెం కాలముంఙ్ ఏంత్ నీవ్ వెల్ఙున్ ఓలెగ్సలేవ్, గుడ్డి ఏరుతు సేరత్తివ్. ఇసా ఇంతేన్. వెంటని సీకటి లెలియన్ పొయ్ వత్ అముదు కిరవ్సా ఎరేనా మదత్ కల్సారెర్ ఇసా ఓల్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","అప్పుడ్ పేరుగు వగిపెకాద్ ప్రబునున్ బదోల్ ఇండతవ్ గోట్టిక్ వినుతు గులేన ఏరూతు ప్రబునున్ నమ్మతేన్. ");
INSERT INTO nit_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","“పాపు” తన్ పౌలు, అంమనే సాగ్తకేర్, పంపూలిత్ “పేర్గే” ఇనెక పట్నముంఙ్ రూకుత్ సెరెకద్ కత్న సేస్సర్. యోహానున్ మార్క అవురును అత్తిన్ సాయ్యుతు యెరూసలేముంఙ్‍ తిర్గుత్ సెసాంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ఔర్ పేర్గే తన్ పిసిదియ. పక్కఙ్ అనెకా అంతియొకయ ఇనెక పట్నముంఙ్ గాద్దియ్తేర్. ఒక్కొ ఆలపుసేక దినముఙ్ యూదులె సావ్డిఙ్ సేరుతు ఉత్సర్. ");
INSERT INTO nit_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","మల్ల నియమ్ సాస్త్రత్, గోట్టిక్ ప్రవక్త లే పుస్తకేవ్ వసిప్సార్. ఆ వెంటాయ్ బక్తి సావుడిత్ అదికారులు, “దాదకేర్, మందిన్ ఆదారడ్ కొరెక గొట్టికుల్ ఏందవేన అండే దయ కత్న ఇడుర్” ఇసా వెల్తెర్‍. ");
INSERT INTO nit_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","పౌలు సులుత్ ఇల్లుత్ కేయ్యుసుల్లుపుత్, ఇస్రాయేల్ మన్కకేరరా! యూదులాంఙ్ దెయ్యంమ్నె అర్రి అనెకద్ అనే గొట్టిన్ అరీత్ మందినే రా! అనే గోట్టిక్లున్ విన్నుర్. ");
INSERT INTO nit_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ఇస్రాయేల్ మందినే దెయ్యం నేండె వేండ్లాకేరును అస్తదున్ ఔర్ ఐగుప్తు ముసపరిక్లాంఙ్ అనేగ్న అవురును దండికుల్లఙ్ అవురును ఇందరాత్తేన్. తనే అద్బుత్ దండి సక్తినాడ్ ఆ దేసంతరున్ కూగుత్‍ కొస్సుత్‍, ");
INSERT INTO nit_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","బట్టిక్లెఙ్ ఔర్ మరల్ల నల్‍బై సాల్కు సోస్సిప్స అవురును కాపాటేద్. ");
INSERT INTO nit_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","కనాను ఏడ్ దేసెముల మన్కరెర్ రాపుత్న తనే మందిన్ ఆ బార్సఙ్ వారసులాంఙ్ ఇదరాతేన్. ");
INSERT INTO nit_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ఇందవ్‍ ఇందారేకాందుగు నాలుగు వందల్ యబై సాల్కు సుమూతిన్. ఆ వెన్కత్ దెయ్యం సమూయేల్ ప్రవక్త కాలాముంఙ్ ఏంత్, రాజ్ అండిగిపేంక్ న్యాయ అదికలున్‍ పన్కతేంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","తముంఙ్ “రాజక్” పాజే ఇస్స ఇనేఙ్ కీసు పోరక్ సౌలు ఔరుంఙ్ రాజక్లాంఙ్ పన్కతేంద్. దెయ్యం బేన్యామీన్ పాడితంద్ ఎన్నెంద్, పౌలు నలబై సాల్కు అడ్గిప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","సౌలు పుస్సుత్‍జోపిటే దావిదున్ ఔర్ రాజక్ నివుడిప్తెర్. దావిద్నే గోట్టిత్ తనే అయి ఇస్స ఇడ్స దెయ్యం ఇనంఙ్ ఇంత్తిన్. యెసయ పోరక్ దావిద్ అనుంఙ్ మనుంఙ్ వతెంద్. అముదు అన్ ఇండ్తదును సాక్స. ");
INSERT INTO nit_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","దెయ్యం తనే వాగ్దాన్ అసార్‍ ఇస్రాయేల్ మందిఙ్ సటీ రక్సక్ ఇనేక యేసున్ దావిద్నె ఇస్రాయేల్ మందిన్ ఇదర్తేంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","యేసున్ పరిసరియంఙ్ వరెంఙ్ పేలె, యోహాన్ మన్ బద్లిపుర్ వాలడ్ బాప్తిస్మన్ వలాడ్ ఇస్రాయేల్ మందిన్ ఇడెంఙ్‍ మొదలిట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","మల్ల తన్నె పరిసరియన్ యోహాన్ తన్నె పనిన్ తిర్పుత్ మందిన్ సిమ్కన ఇనంఙ్ వెల్తెంద్? నీర్ అన్ ఎంద్ ఇసాతిరా గని అద్దు అన్ వెంకత్ వర్సంద్ అమ్నె కెర్రిక్ పుస్సంఙ్ నై ఔకత్ తోతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","అనే ఇస్రాయేలు దాదకేర్! అబ్రాహామ్ మూన్ కుంబంతార్! దెయ్యమ్నె అర్రితా బక్తకెర్ రార! యూదులూ ఎర్సేటరా ఈ రక్సనా వాక్యం నేండత్తి పవీడే వంద్ గొట్టిన్ నేండుంఙ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","గని యెరూసలేమున్ సిమ్కన మందిన్, ఔరు అదికారి ఇద్ ఇంద్ది రక్సక్ ఇసా ఒర్కిలెతెర్. ప్రతి ఆలపుసేక దినం వసిపుత్ దెకుల్ ప్రవక్తకెర్ కరిపెతెర్. యేసున్ మర్న సిక్స సియ్యుత్ ఆ ప్రవచనాను ఇదర్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","అముదుంఙ్ మర్న సిక్స సియెకద్ ఔరుఙ్ ఎద్ కారన్ రొబాటెటనున్ అముదుంఙ్ అల్లుంత్ ఇసా పిలాతున్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ఔరు వయ్ తావున్ వాలడ్ సిమ్కన్ ఔర్ అమ్మున్ అల్తెర్. అద్ ఎద్దతి సిలువ పొయ్ డింపుత్ తప్నెత్ ఇట్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","గని దెయ్యం అంనున్ తిక్తతనడ్ బత్కిప్ తింన్‍. ");
INSERT INTO nit_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ఇంతెదూక్ అంనడ్ కలయుత్ గలిలీయ తనాట్ యెరూసలేమున్ అమ్మున్ వెంట పేలె గొల్ కండ్కెద్దిన్. ఔర్ ఇస్రాయేల్ మందిఙ్ ఇండిఅమ్మున్ సాక్సులు ");
INSERT INTO nit_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ఔర్ అమ్‍నున్ సటీ ఇస్రయేలు మంది ముండట్ సౌలాత్ ఇదరెఙ్ సటీ తయార్ అడంర్. దెయ్యమ్నెడెంత్ తొలే ఇదర్త వాగ్దాన్ పంఙి ఔరుఙ్ సొతఙ్ తయార్ ఎందా నెడుఙ్ సటీ పురా ఇదర్తేద్. యేసున్ తిక్త తానా సుల్పేకంద్ ఇద్ వరమున్ పూర యెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ఇద్ది అమ్ ఇడ్డెకగొట్టి. ఇద్దున్ వాలడ్ కీర్తన పుస్తకూత్ ఇనంఙ్ వయ్తదెంద్. నివ్ అన్నె పోరక్నివ్, ఇన్నెడ్ అన్ ఇన్నె బాననెద్దున్. ");
INSERT INTO nit_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","దెయ్యం అమ్‍నుంఙ్ తిక్తతన సుల్తెంద్. అముదు ఎంపుడి తప్నెత్ జిరయెంద్ అదున్ వాలడ్ దెయ్యం మరొకో జాగ “అన్ దావిదున్ సుక్కిల్సెటా సియ్సత్ ఇంతన్ పవిత్రనఙ్ నమ్మకమ్త ఆసిర్వాద్ ఇనుగ్సియసాత్” ఇసా ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","మరొకో జాగత్ అనఙ్ ఇండ్డెకద్ ఎందిన్ “ఇన్నెత్ బరొస సేవక్ సమాదిత్ నీ కరాబ్ ఎరెఙ్ ఇడే!” ");
INSERT INTO nit_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","దావిద్ తన్నె దెయ్యమ్నె యిసొబడ్ తన్నె కలయ్తరుంఙ్ సేవ కత్న తిక్తెంద్. కలాముత్ అద్దె అనుసర్ అడ్తెత్. అముదు తిక్తవెంటినీఅమ్నెత్ అంనుఙ్ తొలెని తార్ గుండ్త సామది ఇదతెర్ అమ్నెత్ సెత్ తా దుర్రత్ కలయ్ తిన్. ");
INSERT INTO nit_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","గని దెయ్యం తిక్తతన సుల్పతనుంఙ్ ఇనంఙ్ ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","అన్నె ఇస్రాయేల్ దాదకేర్ రార నీర్ గొట్టిన్ కరిపెంఙ్. యేసున్ నలాడ్ ఇమ్మె పాప్ సుక్కిలెకా అమ్ ఇముంఙ్ ఇడ్తంమ్. మోసే నియమ్‍ సాస్త్రం మాప్కలెతిన్ పాపాం తాన, సయేతేంద్ గని అమ్మున్ వాలడ్ ఇమ్మున్ యేసున్ పాపాం మాపి రొంబాడద్ నమ్ తాదున్ ప్రతి ఒక్కొనున్ మాప్కల్ సాద్. ");
INSERT INTO nit_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","అదుంఙ్ ఎత్తి ప్రవక్త కెర్ ఇడ్డత్ ఇమున్ పొయ్ వారెంఙ్ ఇడ్సెటా ఉసరడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“విసెటర్ మంది! ఆస్చర్యం సుమ్ముర్! తిక్కుర్! తానుంఙ్ ఇంతె అమ్మె ఈ కలముత్ అన్ ఒక్కొ పని ఇదర్తెన నమ్మెతిర్ ఇసా అన్! మరొకోర్ ఇడ్తె గినా నీర్ నమ్మెర్.” ");
INSERT INTO nit_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","పౌలు, బర్నబా యూదు సవ్డి సయుత్ సెరెఙ వరెకా ఆలపుసేక దినం ఈ గొట్టికున్ వాలడ్ ఇంకా పెర్రెత్ ముడ్ ఇసా మంది వింతి కత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","యూదులె సావ్డితనట్ ఎద్దత్తి గుల్ మంది, యూదులె మతముత్ యూదు ఎర్సెటర్, బక్తకేర్ పౌలు, బర్నబాన్ వెంట సెద్దెంర్. పౌలు, బర్నబా మందినడ్, “దెయ్యమ్నె కృప ఇస్వాద్ ఇడ్సా ఇనాయ్ బత్కుసా నండ్రు!” ఇసా కబుల్ కలగ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","మరొక్కొ ఆలపుసేక దిన పట్నం సిమ్కన ప్రబున్ సందేసున్ వినేంఙ్ ఇసా మిరయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","మిరయ్త మందిన్ ఓలుత్ యూదులత్తి నరాజ్ ఎద్దాన్ నింతిన్, ఔర్ పౌలుంఙ్ దుసన్ వన్నెతి ముడుత్ అమ్నున్ ఇదర్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","గని పౌలు, బర్నబా దైరమాడ్ సమదానం ఇడ్సా, “సిమ్కనంఙ్ ముదర్వై దెయ్యమ్నె గొట్టిన్ నీర్ ఇడ్డెకాద్ అమ్మె కర్తవ్యం. గని నీర్ నరకం ఇదరెకాదున్ వాలడ్, కారె పానమున్ ఎప్పుడి పత్కెకద్ ఇమ్మెత్ నీర్ ఇనేకాదున్ వాలడ్ అమ్ ఇమున్ సయుత్ యూదులెర్సెటర్వై సెసా నండాతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ప్రబున్ ఇనంఙ్ ఆగ్య సితెంద్ ఇసా ఇంతెర్. దున్యత్‍ అనెకర్ సిమ్కన్ రక్సన ఇదరేంన్ ఇమ్మున్ యూదులెర్సెటర్ దేసున్ ఇన్ ఒక్కొ వెలుంఙ్ లాంఙ్ ఇదర్తన్” ");
INSERT INTO nit_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","యూదులెర్సెటర్ ఔర్ ప్రబునె గొట్టిన్ వింత్ స్తుతి కత్తెర్. ఔర్ గుల్ మంది విస్వాసు ఎద్దెర్. ఎప్పుడి తిక్సెట పానం సియెంఙ్ ఇసా దెయ్యం ఇవ్రుంఙ్ ఆస్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","దెయ్యమ్నె గొట్టిన్ ప్రబునే గొట్టి ఆ ప్రతముంఙ్ సదర్ నేరైతిన్. ");
INSERT INTO nit_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","గినా యూదు పట్నంత దొడలాడ్, మల్ల యూదు ఎర్సెటా బక్తిత పిల్లకున్ ముడుత్ ఔరుంఙ్ పౌలు, బర్నబా వాలడ్ తమ్మె రగ్గున్ రొబడ్ననాంఙ్ ఇదర్తెర్. సిమ్కన మిరయుత్ ఔరున్ హింసాకత్ అంతెనాడ్ ఔరున్ తమ్మె పట్నం తన పుస్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","పౌలు, బర్నబా తమ్మె గెట్టల దుర్రన్ విరొదడ్ జడపుత్ “ఈకొనియ” ఇనేక పట్నముంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ఇంతె అంతియొక సిసు పొయ్ పవిత్ర ఆత్మతొ అనెక వాలడ్ అనెక కుసి కమ్మి ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ఈకొనియత్ ఎనఙ్ జర్గిలతిన్ పౌలు, బర్నబా యూదులె సావ్డిఙ్ సెత్, అదుంఙ్ వాలడ్ మంది యూదు, యూదు తోసెటర్ గ్రీకు విస్వాసు ఎద్దెర్. గుల్ ముట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ఇంతె ఔరె పాన నామ్ ఇసా యూదు, యూదులెర్సెటర్ విస్వాస్ కల్సెటర్ కొన్సెం దాదకేర్ యూదు లెర్సెటరుంఙ్ అర్పొలిపుత్ విస్వాసికున్ కరాబ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","అదుంఙ్ ఎతి, పౌలు బర్నబా ప్రబున్ వాలడ్ తమ్మె దైరమడ్ అత్తి పేలె గొల్ బొద ఇడ్నెంద్. ప్రబున్ ఔరున్ సమత్కర్లున్, మహిమలున్ ఇదరుత్ కృపన్ సియ్తెంద్. సత్తె అమ్నె విచార్ కలెకదుంఙ్ సటీ రుజువు కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ఆ పట్నముంఙ్ మంది ఇంది బాగులెత్ పయ్తెర్ కొన్సెం మంది యూదు, మల్ల కొన్సెం మంది అపొస్తులున్ పయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","యూదులెర్సెటర్ ఔర్, యూదు తమ్మే అదికారి కలయుత్ అపొస్తులున్ నరాజ్ ఎత్న, గుడ్లాడ్ లగపుత్ అల్ఙెన్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ఆప్పుడు గని అపొస్తు ఇదున్ ఒర్కిలుత్ లుకయొనియలున్ లుస్త్ర, దెర్బే ఇనెక పట్నముత్ తిగొర అనెక ప్రాతముత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ఆ ప్రాతలెంఙ్ ఔర్ దెయ్యమ్నె గొట్టి ఇడ్డెంఙ్ మొదలిట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","లుస్త్రత్ ఇంద్ కుంటింద్ లంఙ్ జన్మిల్ తన తెంద్. ఎప్పుడి అడ్గెంద్. ఒక్కొ కుంటింద్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","పౌలున్ ముడ్సననేగా అముదు వత్తేద్. పౌలు అమ్నున్ పకంఙ్ నిటామ్ ఓలుత్ సోయ్ ఎరత్ ఇసా విస్వాసం అమ్నత్తి అండాద్ ఇసా ఒర్కిలుత్, ");
INSERT INTO nit_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","అముదు “సులుత్ ఇన్నె గెట్టా పొయ్ ఇల్!” ఇసా అమ్నాడ్ జోరనాడ్ ఇంతెంద్. మిట్సా జోరనాడ్ అడ్గెంన్ మొదల్ ఇట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","పౌలు ఇదర్ తాద్ ఓలుత్ మంది లుకయునియ ఇనేక గొట్టినాడ్, “దెయ్యలీ మన్కక్నే రుపాడ్ డిగ్గుత్ వత్తెర్” ఇసా జోరనాట్ ఇందెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","బర్నబా ద్యుపతి జూస్ ఇసా, దండి ఉపన్యస అకుంన్ అదుంన్ ఎతి పౌలు హెర్మే ఇసా కుగ్నేర్. ");
INSERT INTO nit_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","జూస్ దెయ్యలింత్ దేలక్ ఇనెకదున్ వాలడ్ ఇవ్రుంఙ్ బావ్ సియెంఙ్ ఇసా ఉద్దెసమడ్ ఊర్ వకా మందిరుత్ ఒక్కొంద్ దెయ్యలక్, మందిన్ కలయుత్ కొందలున్, పుతలె అర్లున్ పట్న దర్వొజ కొత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","అప్పుడు అపొస్తులున్ బర్నబా, పౌలు ఇదున్ వింత్ జుఙ్ఙెలున్ ఈర్క ఆ మంది ముండట్ తుల్సా ఇనంఙ్ జోరనాట్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","దొడలార, నీర్ ఇనంఙ్ తనుంఙ్ కల్సాతిర్? అమ్ గినా మన్కకెరి నీర్ లాంఙ్ మన్కకెరి ఈ కరాబున్ పనింఙ్ సయుత్న ఇముమంఙ్ దవ్ ఆబార్, బూమిన్, సమ్‍దురున్ అత్తి అనెక అదా సిమ్కన గడుపుత్. ఆ పానం అనెకా దెయ్యమ్నె సొయ్త కబుర్ ఇముంఙ్ ఇడ్సతుం. ");
INSERT INTO nit_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ఇద్ అవ్రత్తి దెయ్యమ్నె మంది తంనె పసాన్ వత్తద్ లంఙ్ ఇదరెంఙ్ ఇట్టెన్. ");
INSERT INTO nit_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","గని ఆబార్ తన వాన వత్, పంట పాండెక కలముత్ పండిపుత్ తినెంఙ్ పజే అంతె తినేకదున్ సియ్యుత్ నెడే మన్కకెరున్ కుసినడ్ నేడున్ పొయ్ సోయ్ ఓలిపుత్ దెయ్యమ్నె అండెతి అముదు ఒర్కి సితెంద్. ");
INSERT INTO nit_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ఇన్ని ఇడ్తె గినా మందిన్ సియెంఙ్ ఇసా బావ్ సియ్యెకాద్ మద్దెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","గని కొన్ససెం మంది కబుల యూదు అంతియొకయ, ఈకొనియ పట్నం తన వత్ మందిన్ తమ్వై మలయ్ గత్తెర్. సిమ్కన మిరయుత్ పొయ్ పౌలున్ గుడ్లు జొపిటెర్. అముదు తిక్తెంద్ ఇసా ఇంత్ అమ్నున్ ఊరుంఙ్ వాక పాయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","సిసు అమ్నున్ తిర్గొర గదియ్తేర్. అంతెత్ అముదు సులుత్ పేనా పట్నముంఙ్ సెద్దెంద్. మరొక్కొ దినాం బర్నబా కలాయ్ తెంద్. ఇద్దర్ నై కలయుత్ దెర్బే ఇనెకా పట్నముంఙ్ సెరెంఙ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","పౌలు బర్నబా దెర్బె పట్నముత్ గొట్టి ఇడ్డెంఙ్ మొదలిట్టెర్ గుల్ మంది సెలకేర్ లాంఙ్ ఇదర్తెర్. లుస్త్ర, ఈకొనియ, అంతియొకయ పట్నలుంఙ్ తిరుగుత్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","సిసు పాన బలపరిసి, విస్వాసుత్ ఇలుత్ అనెంఙ్ ఇసా, దెయ్యమ్నె రాజ్యంఙ్ సెరత్ ఇంతె అనిగ్నియ్ చిక్సన్ సొచిపెంఙ్‍, ఇసా ఔరుంఙ్ ఇడ్సనండాతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","పౌలు, బర్నబా కలయుత్ పూర సంగలున్ కొన్సెం మంది దొడలున్ నిర్నాయ్ కత్తెర్. ఈ దొడా ఇదుంఙ్ పేలెని ప్రబున్ ఇస్వద్ ఇట్టర్ ఔర్ అదుంఙ్ ఎత్తి పార్తనన్, ఉపాస్ ఇదరుత్ ఔరు నమ్త ప్రబున్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","అంతెతి పిసిదియ బార్సత్‍ సెత్ అత్తరనా పంపూలియంఙ్ గదితెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","పేర్గేలుత్ గొట్టిన్ ఇడ్తెంద్ అత్తరనా అత్తాలియఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","అత్ తాలియ అనా అంతియొకయ కున్ మలయుత్ వరెంఙ్ ఎద్దెర్. పెన కత్త అన్నీనాయ్ పానిఙ్ ఇదరేంఙ్ దెయ్యమ్నె కృప మదత్ రొంబడెంఙ్ ఇసా ఇవ్రున్ దెయ్యం సితిన్. ");
INSERT INTO nit_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ఔర్ అంతియొకయకు వత్తత్తి సంగంతరున్ కూగుత్ దెయ్యం తన్ లంఙ్ ఇదర్త సిమ్కన ఇడ్తెర్. యూదులెర్సెటర్ ఔర్ గిన తన్ నమ్తెత్తి దెయ్యంమ్నె విస్వాసాడ్ అముదు కవాడున్ పుసుత్ గొట్టి ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ఔర్ అత్తి అనెకర్ సిసు మెర గుల్ కాలం గడుప్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","కొన్సెం దాదకేర్ యూదు తన అంతియొకయకు అత్తి అనెకా మంది, “సున్నతి ఇనెకా మోసే నియమున్ అడుగ్తె కరాబా ఇసా ఇముంఙ్ రక్సన రొంబాడెద్” ఇసా విస్వాసులున్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","అదుంఙ్ వాలడ్ పౌలు, బర్నబా ఔరడ్ కటిన్త ముడ్సద్ ఎత్తిన్. ఇద్ సమస్య మలడ్ పౌలు బర్నబా, ఇంక కొన్సెం మంది యెరూసలెముత్ అపొస్తులున్, దొడలత్తి తోడసెద్దెర్ ");
INSERT INTO nit_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","అదుంఙ్ ఎత్తి సంగమ్ తరున్ అడ్గిపెకద్, ఔరు పొనీసియ. సమరయ పట్నముంఙ్ వాలడ్ సెసా ననేఙ యూదులెర్సెటర్ ఎనా అవ్రత్తి వాత్ బద్లిలెకాదున్ వాలడ్ అత్తి అనెకరుంఙ్ ఇడ్ తెర్. ఇద్ దాదకేర్ సిమ్కన గుల్ కుసింఙ్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ఇవ్రు యెరూసలెముంఙ్ గదితత్తి సంగమ్, అపొస్తులున్ దొడ సిమ్కన మిరయుత్ ఇవ్రుంఙ్ స్వగతం కత్తెర్. పౌలు, బర్నబా దెయ్యం అముంన్ వాలడ్ అదువున్ ఔరుంఙ్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","పరుసిక్ కలయ్తర్ కిస్సేం మంది ఆ విస్వాసులున్ సులుత్, “యూదుల్ ఎర్సెటర్ తప్పక సున్నతి ఇదారెంఙ్‍, మోసే నియమ్ సాస్త్రమున్ పాటిన్ చెంఙ్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","అపొస్తులున్, దొడా కలయుత్ ఈ గొట్టిన్ వాలడ్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ఎన్నిగొ గొట్టిక్ పేతురు సులుత్ ఇనంఙ్ ఇంతెంద్, దాదకేరార, బాయినేవారా! యూదులెర్సెటర్ గని ఔర్ అన్నె మూతి తన గొట్టి వింత్ విస్వాసిక్ పజే ఇసా ఇమ్మత్ తన అన్ పేలెత కాలం బూడున్ దెయ్యం నేడుంఙ్ సిమ్కన తన అన్ అసెంఙ్ ఇముంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","మన్కకెర్ మన్ ఒర్కిల్ దెయ్యం, నేడుంఙ్ సితెతి పవిత్రాత్మ ఔర్ గినా సియ్యుత్ యూదుఎర్సెటరుంనాయ్‍ నేడుంఙ్ సత్తె సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","నేడుంఙ్ అని ఔరుంఙ్ గుల్ పారక్ అన్సాంద్. ఔర్ మన్లున్ విస్వాస్ ఇట్టెర్. అదుంఙ్ ఎతి ఔరె పవిత్ర కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","అదుంఙ్ ఎత్తి నేండె దొడా ఎకద్ నేండ్ ఎకద్ కుంతెంఙ్ సాల్సెట మోపున్ సిసులె కావ్డి పొయ్ ఇడుత్ నీర్ తనుంఙ్ దెయ్యమున్ పరీక్స ఓల్సతిర్? ఈ వేకమున్ నేండ్, నెడే దొడా గినా సొసిపెంఙ్ సలెతేర్ తొదా! దెయ్యం రగ్గుంన్ వర్సాంద్ తొదొ ఓలేంఙ్ ఇసా తున్? ");
INSERT INTO nit_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ప్రబున్ వే యేసు దయనాడ్ అమున్, ఔర్ గినా పనామడ్ అందాతుమ్ ఇసా రక్సన నమ్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","అపుడ్‍ బర్నబా, పౌలున్ వలడ్ యూదులెర్సెటర్ అవ్రత్తి దెయ్యం ఇదార్త మహిమలున్ వాలడ్, సమత్కర్లున్ వాలడ్ ఇడ్డెగా అవరు వింతెర్. మందిత్ అనెకర్ సిమ్కన సుయ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","పౌలు, బర్నబా ముడెకాద్ బాంద్ కత్తెర్ యాకోబున్ ఇనంఙ్ ఇంతెంద్. “దాదకేర్ బాయినేవారా!” అన్నె గొట్టిక్ వినేకాద్! ");
INSERT INTO nit_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","దెయ్యం పేలె యూదులెర్సెటర్ ఎనా ఔరున్ దెయ్యం తానుంఙ్ పేరుంఙ్ సటీ కొన్సెం మందిన్ అసుత్ తమ్మె మంది ఎనాంఙ్ ఇదర్తెందొ సీమోను ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ఈ లేకనముత్ ఇడ్తేతెతి ఈ సంగట్నలున్ ప్రవక్తలున్ ఈ గొట్టిన్ సొబనడ్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","ప్రబు ఇడ్సంద్ అదుంఙ్ వెన్కత్ నారబ్ ఎద్ద దావిద్నె రాజ్యమున్ తయార్ కల్సాత్! ఆదున్ కొత్త రాజ్యమున్ తయార్ కల్సాత్! కరాబ్ దావిద్నే రాజ్యమున్ ఇదర్సత్ మల్ల వర్సత్ గుడిన్ కట్సత్ ఇసా ప్రబుద్ ఇడ్సాద్. ");
INSERT INTO nit_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","మిక్తర్ మంది సిమ్కన దెయ్యమున్ కిరవ్ సార్! అన్ పేర్ సుంతర్ యూదు లెర్సెటరున్ అన్నెసోత మంది ఎద్దర్ సిమ్కన దేసెంత మందినయ్ ప్రబున్వై వర్సార్. ");
INSERT INTO nit_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ఇసా ప్రబున్ పేలెయ్‍ ఇదవున్ బదోల్ ఒర్కి పరుతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“దెయ్యం యూదులెర్సెటర్ ఔరున్,” గినా యూకొబు ఇంక ముడ్సా ఇనంఙ్ ఇంతేంద్ దెయ్యమున్వై తిరుగుత్ ముడేంన్ తోద్ ఇసా అనే అదికార్ అదుంఙ్ ఎతి, దెయ్యంవై మలాయ్సా నన్సార్. ");
INSERT INTO nit_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","అముదుఙి ముర్తిక్ బోనం అపవిత్ర తినెకాద్ పుడ్కేంఙ్ వరెద్ ఇసా, పరస్త్రీని కామ్మి సంజిలెంఙ్ తోద్, బొడ్కన్ తిర్ముత్ అలుంఙ్ తాద్ జనవర్లే ముర్యన్ పుడుకెంఙ్ వరెద్ ఇసా, జనవర్లే నెత్తురున్ ఉనేంఙ్ వరెద్ ఇసా అవరుంఙ్ నేండ్ లేక వాయుత్ పవిటంన్ ");
INSERT INTO nit_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","గని తరతరం తన మోసే యూదులె సావ్డితర్ నియమ్ సాస్త్రమున్ సిమ్కన పట్నముంఙ్ ఇడ్సా, అదున్ హర్ ఆలపుసేక జీర్ లేకనమున్ వాసిపెకద్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","అపొస్తులున్, దాదకేర్, సంగమ్ మిరయేకా, సిమ్కన మిరయుత్ మంది తన కొన్సెం మంది ఆసుత్, పౌలు బర్నబా నాడ్ ఔరున్ అంతియొకయ కున్ పవిట్టెర్, సొయ్తదున్ సంఙ్తాకేర్ దొడలెన బర్సబ్బా ఇసా ఆసెకాద్ ఎరద్ యూదక్, సీలనున్ అసుత్ ");
INSERT INTO nit_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ఔరున్ వెంట ఇద్ వయ్త పన్కతద్ తనెదెంద్ ఇంతె. ఇమ్మె సొప్తిక్ ఎనా అపొస్తులున్ దొడ, దాదకేర్ తన, అంతియొకయ, సిరియ, కిలికియ పట్నముత్ యూదులెర్సెటరుంఙ్‍ సుబం! అన్నె దదాకేరరావందనలు! ");
INSERT INTO nit_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","అమ్మె ఉక్కుమ్ తోసెట అమ్మత్తి కొన్సెం అత్తి వత్ తమ్మె గొట్టికలాడ్ నీర్ తక్లిబ్‍ రొబపుత్ ఇమ్మె పాన కరాబ్ కత్తెర్ ఇసా వింతమ్. ");
INSERT INTO nit_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","అదుంఙ్ ఎత్తి కొంసెం మందిన్ ఆసుత్న, నెడె ప్రబు ఇనెకా యేసు క్రీస్తునుంఙ్ సాటి పనలున్ కమ్మి బర్నబా, పౌలు అనే. ");
INSERT INTO nit_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ఇవ్రు అమ్మె యేసు క్రీస్తుంద్ ప్రబునె పేరడ్ బత్కిపెకద్ సటీ తమ్మె సియ్తర్ అవ్రి. ");
INSERT INTO nit_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","అదుంఙ్ ఎతి, అమ్ వాయెకద్ వితనం మూతినాడ్ ఇముంఙ్ ఇడ్డెంఙ్ ఇసా యూదక్, సీలను పవిడ్స నంసాతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ఈ నియమున్ తప్ప మిగాత నియమున్ ఇమున్ పొయ్ వెకమ్‍ సియెంఙ్ తోద్ ఇసా పవిత్ర ఆత్మన్, అముంఙ్ కరిప్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","మూర్తికుంఙ్ మొక్తదున్ తినెంఙ్ తోద్, మక్కున్ పిత్కుత్ అలుంఙ్త జన్వర్లున్ ముర్యన్, జన్వలె నెత్తుర్ పుడుక్నేర్. పరస్త్రీన్ కమ్మి సమ్జిలెంఙ్ తోద్ ఇసా. ఇనంఙ్ ఇదావున్ అండదుంఙ్ వాలడ్ ఇమ్మత్తి రొబడాద్. విడ్కోలున్. ");
INSERT INTO nit_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ఔర్ ఆల పుసేక సుమ్ముత్ అంతియొకయ కున్ సెద్దెర్. విస్వాసిక్ సిమనన్ కూగుత్ ఔరుంఙ్ వయ్త కగుదున్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ఔరు ఇమత్ సియ్స వయ్తదున్ వసిపుత్ ఆదార్ సుమ్మత్ మందిన్ గుల్ కుసినడ్ కొత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","యూదక్, సీల గినా ప్రవక్తకెరి అదుంఙ్ ఎతి ఆ ఊరున్ దాదకేర్ గుల్ పెర్రెత్ గడి ముడ్సా ఔరున్ ఇమత్ సియ్తెర్? కుసీంఙ్ కొత్తెర్? ");
INSERT INTO nit_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","అవ్రత్తి కొన్నీ దీనా గడుప్తెర? అంతెతి అత్ దాదకేర్ కేర్, సాంతి రొబటత్తి ఇసా ఇనేఙ ఔరున్ వీడ్కోలున్ ఇడ్తెర్. ఇవ్రు అమున్ పనుక్ తర్ ఔరున్ మేర తిర్గుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","“గని సీల అత్తిని అనెంఙ్ ఇసా ఇంతెంద్.” ");
INSERT INTO nit_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","పౌలు, బర్నబా అంతియొకయ లున్ కొన్ని దినా గడ్పుత్. ఇవ్రు, ఇంకా గుల్ మంది కలయుత్ ప్రబున్ గొట్టిన్ ఇడుత్ గొట్టి ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","కొన్ని కాలం తర్వ తా పౌలు, బర్నబా, నాడ్ “ప్రబున్ గొట్టిన్ ఉపదేసిమచుతద్ ప్రతి పట్నముంఙ్‍, నేండ్ పెనా సెన్నర్. అత్ తా దాదకేర్ కలయుత్ ఔర్ ఎనంఙ్ అబివ్రుద్ది రొబటినో ఓలుత్ వన్నం” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","బర్నబా, మార్క ఇసా కుగెకాద్ ఎరాద్ యోహానున్ గినా తమ్మె వెంట కూగుత్ సెరెంఙ్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","గని పౌలు ఒప్పెతెంద్‍ తమ్మె పని కల్సెటా తమున్ పంపూలియత్ సయుత్ సెద్దెంర్ అదుంఙ్ ఎత్తి పౌలు అమ్నున్ కూగుత్ సెరెకాద్ సోయ్ తోద్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","బర్నబా, పౌలు నాడ్మున్ జాగ్డా వాలడ్ ఔర్ ఎడల్తెర్. బర్నబా మార్క తన్ వెంట కూగుత్ రూకుత్ సైప్రసు సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","పౌలు, సీలనున్ తన్ వెంట కూగుత్ సెద్దెంద్. అత్తి అనెకా దాదకేర్ అమ్నున్ ప్రబువుంద్ కృప రొంబడెంఙ్ ఇసా ఆసిర్వాద్ ప్రబునుంఙ్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","అముదు సిరియ, కిలికియ దేసెంలెంఙ్‍ సెసా అత్తి అనెక సంగలున్‍ బలపరుస్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","అద్ ఎద్దతి పౌలు దెర్బే సెత్ అత్తరనా లుస్త్రకున్ సెద్దెర్. లుస్త్రలుత్ తిమోతి ఇనేక పేర్తంద్ ఒక్కొ సిసుంద్ అండెంద్. అమ్నె అమ్మ దెయ్యమున్ నమ్త యూదురా; బాంద్ గ్రీకు దేస్తంద్ తంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","లుస్త్ర, ఈకొనియ పట్నముత్ దాదకేర్ సిమ్కన మందినంతీ తిమోతి సత్తె అండేద్. ");
INSERT INTO nit_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","పౌలు అమ్నున్ తన్నె వెంట కూగుత్ సెరెంఙ్ ఇసా ఇంతెంద్. తిమోతినె బాంద్ గ్రీకు దేస్త తంద్ ఇసా ఆ బార్సత్‍ బత్కుత్ యూదు సిమ్కనంఙ్ ఒర్కి. అదుంఙ్ ఎతి అమ్నున్ సున్నతి ఇదర్ గతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","అపొస్తులున్, దొడా యెరూసలేముత్ నిర్నాయ్ కత్ న్యాయ్, ఔర్ ప్రతి పట్నముంఙ్ సెత్ మందింఙ్ ఒర్కి సియ్యుత్, అదవున్ పడిపుర్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","మల్ల సంగం విస్వాసిక్ దినం దినముంఙ్ రోజి ఆ మందిన్ సంక్య పెరుగ్సా వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ఔర్ ఆసియ బార్సఙ్ సేత్ ఈ గొట్టిన్ ఇడ్డెంఙ్ తోద్ ఇసా ఇంతెర్. గని పవిత్ర ఆత్మ ఔరుంన్ ఇలుప్తెంద్. అదుంఙ్ ఎతి, ఔర్ ప్రుగియ, గలతీయు ప్రతి ఊరుంఙ్ సేద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ముసియ పొలిమేరంఙ్ వాత్ బితునియఙ్ సేరెంఙ్ ఇసా కోసీద్ కత్తెర్. గని యేసుంద్ ఆత్మన్ అదుంఙ్ ఎతి అంగికారం ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ఆ కరమాడ్ ఔర్ ముసియన్ దాటుత్ త్రొయ పట్నం సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","మాసిదోనియ బార్సఙ్ అముదు ఒక్కొంద్, “ముసిదొనియమ్ఙ్ వాత్ అమున్ బత్కిపుర్” ఇసా వింతి కత్తెంద్ సింతె పౌలుంఙ్ ఒక్కొ దర్సన్ రొబటిన్. ");
INSERT INTO nit_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","పౌలుంఙ్ దర్సనం రొబటత్తి వెంటని మాసిదోనియ బత్కెకరుంఙ్ గొట్టి ఇడ్డెంఙ్ ఇస దెయ్యం అమున్ ఆస్తెంద్ ఇసా ఇనుత్ వెంటయ్ మాసిదోనియ అమ్ అత్తి సెరెంఙ్ ఇసా తయార్ ఎద్దమ్. ");
INSERT INTO nit_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","“త్రొయ” తన సముద్రముంఙ్ రూకుత్ సెద్దెర్ సమొత్రాకెకు సెత్ మరొక్కొ దినం నెయపొలింఙ్, అత్రనట్ పీలిప్పింఙ్ వతామ్. ");
INSERT INTO nit_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","అంతె తనట్ సెరెఙ మాసిదోనియ దేసెముత్ ఆ ప్రతలెంఙ్ పిలిప్ అద్ కాస్ పట్టనామున్ రోమియు అనెక బార్సలెంఙ్ మాసిదొనియత్ పేలె పట్నముంఙ్ సెత్తెర్ అత్తి గుల్ పేలెగొల్ అడ్డెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ఒక్కొద్ ఆలపుసేక జీర్ పార్తన ఇదరెఙ్ జాగ నది మెరం సెదం. యూదు కలయెక జాగత్ వత్ తా పిల్లక్ వెంట ఉద్దుత్ ముడెకత్ మొదాలిట్టమ్. ");
INSERT INTO nit_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","అమ్మె గొట్టిక్ వినెకద్ ఒక్కొద్ అద్నె పేర్ “లుదీయ.” ఇద్ తుయతైర పట్నంత. గులాబీ రంఙ్ జుఙ్ఙె విరెకాద్ లుదీయ ఇనెక. దెయ్యమ్నె బక్తురా అన్నె మనున్ బద్లిపుత్ పౌలు గొట్టిన్ వినెకద్లఙ్ ఇదర్తిన్. ప్రబుంద్ అద్నె మనున్ కొలిప్తెద్. ");
INSERT INTO nit_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","మల్ల అద్ అద్నె ఎల్లాత్ అనెకా ఔరె ఎల్లతర్ బాప్తిస్మము సుమ్సెటా అముంఙ్ ఎల్లంఙ్‍ కుగ్తెర్. “అన్ కరెయ్ ప్రబునె బక్తర ఎందునెరతే విస్వాస్ ఇముంఙ్ అండా దెరతె వత్త అమ్మె ఎల్లత అండ్రు” గని అముంఙ్ సాయుత్ వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ఒక్కొ జీర్ పార్తన జాగంఙ్ సెరేఙ ఒక్కొద్ బానిస పిల్ల కన్కెద్దిన్. అదుంఙ్ చడిక్ ఇండెఙ్ సక్తి వరెంఙ్ “జర్గిలేకాద్ ఇండ్డేకద్ ఒక్కొ అపవిత్ర ఆత్మ” ఇనెకా అద్ సోదిక్ ఇండెకా వాలడ్ అద్దె మాల్కకెర్ గుల్ పైసే గాడిప్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","అద్ పౌలున్, అమున్ విచార్ కల్సా, “ఇవ్రు పూర దండి దెయ్యమున్ ఇదరెక సేవకెర్. రక్సన ఇడ్సనండర్” ఇసా జోరకత్ వపొయ్తెతిన్. ");
INSERT INTO nit_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ఇనంఙ్ గుల్ పేలెగొల్ ఇదర్తిన్. ఆక్రి పౌలు నరజడ్ వెన్కవై తిర్గుత్ అద్నంతి అనెకా అపవిత్ర ఆత్మ, “యేసు క్రీస్తు పేరడ్ అదున్ సయుత్ సె ఇసా ఆగ్య సియ్” ఇసా ఇంతెంద్. వెంటని ఆ పవిత్ర ఆత్మ అదున్ సియ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ఆ బానిస పిల్ల దొడంద్ తమ్మె పైసెలున్ కమపెంఙ్ సలెంమ్ ఇసా పౌలున్, సీలను సుమ్ముత్ అదికారి లంత్తి గొట్టిన్ తిర్పెంఙ్ తివుత్ తోడసెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ఔరున్ పెరెత్ రోమా సైనిక్ అదికరికున్ ముండట్ కూగుత్, ఈ యూదులు అన్నె పట్నముంఙ్ వత్ అముంఙ్ తక్లిబ్ కల్సర్ ఇడ్తేర్. ");
INSERT INTO nit_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ఇవ్రు నెండె నియములున్ విరోద్ సల్సార్. నేండ్ రోమియులంఙ్ అంత్ అవ్రే కయ్దలున్ ఇదరూర్ ఇసా ఇడ్సర్. ");
INSERT INTO nit_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","అప్పుడ్ మంది సిమ్కన ఔరున్ పొయ్ సుల్తెర్. దొడా ఔరే జుఙ్ఙెలున్ ఈర్కుత్ సాట్లడ్ కుడ్కుర్ ఇసా ఆగ్య సితిన్. ");
INSERT INTO nit_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ఔరు గులెన లగపుత్ ఔరున్ జేలుత్ తప్పుత్, సోయ్ అప్ ఇసా జేల్త అదికరుంఙ్ ఆగ్య సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","అముదు ఆ ఆగ్యన్ పడిపుత్, ఔరున్ జేలుత్ తప్పుత్, గెట్టలున్ వేకం ఎద్ద సివ్వనడ్ ఇదర్ తా మొద్దలొట కొయ్యలుంఙ్ నడుమున్ కట్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","సార్సమలె పౌలు, సీల దెయ్యముంఙ్ పార్తన కల్స పాటా పాడ్స అనెంఙ్ జేలుత్ అనెకర్ వింన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","అప్పుడ్ ఒర్కితోసెటా దండి బూకంపం వత్తిన్, జేల్త బునజి మెలగ్తె, వెంటాయ్ కవాల్ కురియ్తె, సదర్ మందినె సంకెల కురియ్తె. ");
INSERT INTO nit_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","అంత్తెతి జేల్త అదికార్ మంఙ్ సులుత్, జేల్త గుయ్యు పుసుత్ అనెకవున్ ఓలుత్, జేలుత్ అనెకర్ తుటెర్ ఇసా, రుసిన్ పుసుత్, కలెంఙ్ తయ్యర్ ఎదేంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","అప్పుడ్ పౌలు, “నీ అల్ఙనేమ్, అమ్ సిమ్కన ఇత్తిని అన్సాతుమ్!” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","జేల్త అదికార్ దీవే కొర్ర ఇసా ఇడుత్ జల్దిని లోపా వత్న, వడక్సా పౌలు, సీలలున్ గెట్టా మొక్తెంద్, ");
INSERT INTO nit_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ఔరున్ వకాకొత్న, “దొడలారా, రక్సన రొంబడెంఙ్ ఇంతె తాగదుమ్?” ఇసా వెల్త్ఎర్. ");
INSERT INTO nit_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","అదుంఙ్ ఔర్, “ప్రబుద్ ఇనెకా యేసు నత్తి నమ్మకమ్ ఇడ్, అప్పుడ్ నీ, ఇన్నె ఎల్లతర్ రక్సన రొంబాడద్” ఇసా ఇడుత్ ");
INSERT INTO nit_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","అప్పడు అంనున్ అమ్నె ఎల్లత్ అనెకరున్ సిమ్కనంఙ్ ప్రబువు వాక్యం ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","సిత్తెయ్ ఆ వెలంఙ్ జేల్త ఆదికారి ఔరున్ తోడవత్న, ఔరె గవులున్ ఒట్టెంద్. వెంటాయ్ అముదు అమ్నె ఎలతర్ సిమ్కన బాప్తిస్మ సుమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","అముదు పౌలు సీలన్ అన్నె ఎల్లంఙ్ తోడ సెత్న తీనెంఙ్ సియుత్, తన్నె దెయ్యమ్ నత్తి విస్వాస్ ఇటదుంఙ్ తన్నె ఎల్లతర్ వెంట కుసీకత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","వెగెంఙయ్, ఔరున్సాయ్తెంద్ ఇసా ఇడెంఙ్ న్యాయ్ కలెకా రోమ అదికరి పొలిసు అదికారి పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","జేల్త అదికార్ ఈ గొట్టకున్ పౌలున్ ఒర్కి కత్న, ఇమున్సాయుర్ ఇసా న్యాయ్ ఆదికరులుంఙ్ కబుర్ ఇడ్తెంద్, అదుంఙ్ ఎత్తినీర్ ఇండి కురియుత్ సాంతినాడ్ సెర్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ఇంతె పౌలు, “ఔర్ ఇత్తెర్ అదీకరినడ్ ఇనంఙ్ ఇంతేంద్ రోమా అమున్ గులెన లగ్పత్న జేలుత్ తప్పుత్, ఇండి కరెయ్ సాయ్సరా? అమ్ ఒప్పెమ్. ఔరి వత్న అమ్మున్ వాక పుసెంఙ్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","పొలిసు అదికారి ఈ గొట్టికున్ రోమా న్యాయ్ అదికారికి కలెకరుంఙ్ ఇడ్తెర్. పౌలు సీలల్ రోమియుల్ ఇసా విత్న ఔర్ అర్సతెర్. ఆ న్యాయా అదికార్ల వత్ననా ");
INSERT INTO nit_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ఔరున్ వింతి కత్న జేలుంఙ్ వాక కొసుత్, పట్నం సాయుత్ సెరెంఙ్ ఔరున్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","పౌలు, సీల జేల్తన వక వత్న లుదీయలె ఎల్లంఙ్ సెద్దెర్. ఔరె దాదకేర్ ఓలుత్, ఇమత్ సియుత్ ఆ పట్నం తన్న కురియుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","పౌలు సిల అంపిపొలి, “అపోల్లోనియ, పట్నముంఙ్ వాలడ్ సెసా గదియుత్ తెస్సలోనిక ఇనేక పట్నముంఙ్ గదితెర్.” అత్తి ఒక్కొ యూదులె సావ్డి అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","అల్వట్ ప్రకారం పౌలు ఆ యూదులె సావ్డీత్ సెద్దెంద్. అత్తి మూది ఆలపుసేక గడ్తెంద్. ఔర్ వెంట్ యూదులె లేకనలున్ ఇడ్డుత్, గొట్టికున్ ");
INSERT INTO nit_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","మరియు క్రీస్తు తక్లిబ్ బోగిలుత్ తిక్తనా సుల్తెంద్ అన్ ఇడ్డెక, ఈ యేసు క్రీస్తు అని లెకనముత్ అండద్ ఇసా వయ్యుత్ అండెతి ఎడ్తెంద్ ");
INSERT INTO nit_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ఔరత్తి కొన్సెం మంది యూదు కబుల కత్ పౌలు, సీలల కల్తెర్. దెయ్యమ్నె అర్రినాడ్ గుల్ మంది గ్రీకు, దేసెంత పిల్లక్ ఔరున్ పకంఙ్ గదియ్తేర్. ");
INSERT INTO nit_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","అముదుఙి యూదు గుల్ ఎద్దెర్. సంతాద్ అనెక పనితోసెట ఔరున్ కొన్సెం మందిన్ మిరయ్త పట్నముంఙ్ వపొయెంఙ్ మొదలిట్టెర్. తివ్వెంఙ్ ఇసా సిమ్కన మిరయుత్ యాసొనె ఎల్ల పొయ్ ఉర్కుతెర్. పౌలు, సీలలున్ మందిన్ ముదర్వై కొరేంన్ ఇంతెర్ ");
INSERT INTO nit_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ఇంతె ఔర్ అత్తి కండ్కెర్ సెటదున్ వాలడ్ యాసొనె, మల్ల కొన్సెం మంది దాదకేర్ పట్నాత అదికార్లున్ ముదర్వై తోడా వత్తెర్, “అనెక దున్యత ఈ మందిన్ పఙ్ఙి ఇత్తి వత్తెర్ ఇసా వపొయుత్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ఇవ్రుంఙ్ యాసొనె తన్నె ఎల్లంఙ్ కొతెంద్. ఇవ్రు సిమ్కన రొమ అదీకారి నియములుంఙ్ తోద్ ఇసా కత్ యేసు ఇనేక పెనొక్కొ రాజక్ అన్సాంద్ ఇసా ఇసర్” ఇసా వపొయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ఈ గొట్టికున్ విన్త అత్తి అనెక మంది అని ఆదికల్ గుల్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","అద్ ఎద్దత్తి యాసొనెనాడ్, మిక్త ఔరు సిమ్కనన్ వెంట్ జుర్మన పైసె కట్టుత్ ఔరున్ సయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","సర్సం అలే ఎరంఙ్ అయ్ దాదకేర్ పౌలు, సీలలున్ బేరయ ఇనేక పట్నముంఙ్ పవిడ్డెర్. బేరయంఙ్ వత్తర్ ఔర్ యూదులె సావ్డిఙ్ సెద్దర్. ");
INSERT INTO nit_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","తెస్సలోనిక ఔరుంఙ్ ఎనా బెరయ ఔరె మన్నున్ ఇడ్డెకార్ ఔర్ దెయ్యమ్నె గొట్టిన్ సుయ్ వినెకార్. ప్రతి దినం లేకనముత్ వాసిపుత్, ఆ వేల్తోలెంఙ్ కరేయ లబడ ఓల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ఔర్ గుల్ మంది విస్వాసిక్ ఎద్దెర్. ఔర్లాఙ్ సోయ్త పేర్ గ్రీకు పిల్లకున్, పడ్సిలున్ గినా విస్వాసిక్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ఇంతె పౌలు దెయ్యమ్నె గొట్టిన్ బేరయలుత్ గిన గొట్టిక్ ఇడ్సాంద్ ఇసా తెస్సలోనికత యూదులుంఙ్ ఒర్కి ఎద్దిన్. ఔర్ అత్తి సెత్ మందిన్ అర్పులిపుత్, అవ్రత్తి ఎక్సిసంద్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","వెంటని దాదకేర్ పౌలున్ సందూర్ డర్డింఙ్ పవిట్టెర్. సీల, తిమోతి బెరతీ అండెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","పౌలున్ వెంట సే అమ్నాడ్ కలయుత్ ఏతెన్సు పట్నముంఙ్ ఎత్ సెద్దెర్. సీలన్, తిమోతి వన్నంతెత్ జలాది వా ఇన్ ఇసా కబుర్ పవిట్టెంద్. ఈ ఇడ్డెకాదున్ ఔర్ తిర్గుత్ బెరయనుంఙ్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","పౌలు ఏతెన్సు ఔరుంఙ్ సాటీ పవ్ ఓల్సా కొన్ని దినా ఇల్తెర్. ఆ పట్నం త మూర్తికున్ నిండుత్ అనేఙ విచార్ కత్ అమ్నే ఆత్మ ఒయ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","అదుంఙ్ వాలడ్ యూదులె సావ్డిత్ మిరయక యూదులాడ్, దెయ్యంమ్నె అర్రితంద్ యూదులేన ఎర్సేటర్ పేర్రేత్ మందిన్ వెంట, రొజి సెరెంఙ్ వరెంఙ్ కలెకారున్ మార్గత్ వెంట ముడ్సా అండెద్. ");
INSERT INTO nit_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ఎఎపికూరియులు గ్యానిక్ నడుమున్, స్టొయిక్‍ గ్యానిక్ నడుమున్ ఇనేకార్ కొన్సెం గ్యానిక్ అమ్నాడ్ ఇంతెర్ “ఆ రగ్టక్ తానెవిసాంద్?” ఇసా కొన్సెం మంది ఇంతెర్. “మరొక్కొ దెయ్యలున్ వాలడ్, యేసుంద్ తిక్తార్ బత్కసార్ వాలడ్ ఇడ్డెకాద్ ఔర్ అమ్నున్ ఔర్ మరొక్కొ దెయ్యమున్ వాలడ్ ఇడ్సర్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ఔర్ అమ్నున్ సుమ్ముత్ అరియోపగు దడ్డి సబ కూగుత్ వత్తెర్. “నీ ఇడ్డెకా కొత్త బొద ఇడ్డెకద్ తనేదొ అమ్ గినా ఒర్కిలేంఙ్ వంద్?” ఇసా కొన్సెం మంది వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","“నీర్ కొత్త గొట్టికున్ అమ్మె కెవ్వులెంఙ్ విన్కవత్తిన్. అద్నె అర్తం అముంఙ్ ఇడ్డుర్” ఇసా పెనా కొన్సెమ్ మంది వెల్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ఏతెన్సు పట్నముత్ బత్కెకార్ సీమ్మాన మందిన్, ఆ ముసపరిక్, తమ్మె కాలమున్ సిమ్కన కొన్ని గొట్టిక్ ఇడ్డెకాదుంఙ్ తోద్‍తె వినేకాదుంఙ్ ఔరున్ వెంట్ అండెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","పౌలు అరియోపగు సబ నడ్మున్ ఇల్లుత్, ఏతెన్సు మందితార్! నీర్ సిమ్కన గొట్టిత్ గుల్ సోయాడ్ బక్తినడ్ అంస్సతిర్. ఇద్ అమ్ కరిప్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","అన్ ఇమ్మె పట్నం సిమ్కన తిర్గుతన్. నీర్ మొక్కెకాదున్ అన్ ఓల్తన్. అన్‍తెయ్ తోద్‍గ సంమ్బం ఇదరెక బలిపీటం పొయ్, ఒర్కి తోసెట దెయ్యమున్, ఇసా వాయ్త అండదున్ ఓల్తన్. అదుంఙ్ ఎతి నీర్ ఒర్కి తొత్త సటింఙ్ నీర్ మొక్కెకా ఆ దెయ్యమున్ తయార్ కత్తిర్. ");
INSERT INTO nit_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ఈ ప్రపంచమున్, ఇత్తి అనెక ప్రతి వస్తున్ తయార్ కలేక దెయ్యం; ఆబారున్, బూమిన్ ప్రబుంద్ ఎద్దన్ అముదు దెయ్యం, మన్కకెర్ కట్ తా మందిరుత్ బత్కెంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","మన్కకెర్ సటీ ఇదరెంఙ్ సల్తద్ ఏద్ తోతెద్. పానం ఉప్రి ప్రతి ఒక్కొనుఙ్ పానం కంద్, తనుంఙ్ పాజె ఆ వాస్తున్ ఇ తాద్ దెయ్యం మందిన్ సేవ పజె? ");
INSERT INTO nit_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ఇంతె అముదు ఒక్కొ మన్కక్‍నాడ్ బూమి పొదె మందిన్ సిమ్కన తయార్కత్ ఔర్ ఈ ప్రపంచం సిమ్కన బత్కెకార్ లంఙ్ ఇదర్తెర్. ఔరుంఙ్ సటీ ఒక్కొ కాలమున్ సరి హద్దులు నిర్నయ్ కతెంద్. ఎ దేసెముంఙ్ మంది ఎత్తి బత్కెకదొ ఆ జాగన్, కలామున్ హద్దులు బరాబ్బర్ నిర్నాయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","మన్కకెర్ తనున్ కిరవేంఙ్ ఇసా, గుడ్డిన్ తన్నెత్ తన్ ఇంతేంద్ అనున్ ఒర్కిలెంఙ్ ఇసా ఔరుంఙ్ సయ్యెంఙ్ ఇసా ఇనంఙ్ కత్తెర్. గని దెయ్యం కరేన్ ఎరుఙి దావ్ తోతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","నేండ్ అమ్నున్ పొయ్ బత్కసా నడతుమ్ అమ్నత్తి మెలగేకాద్. అమ్నే కరనామడ్ నేండ్ అన్సాతుమ్ ఇమ్మత్తి కొన్సెం మంది పండితు ఇడ్తర్. నేండ్ అమ్నె పోరకేర్ ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","పంఙి నేండ్ దెయ్యంమ్నె సంతానం! అనంఙ్ అండె, దెయ్యం లాఙ్ అండతి మన్కకెర్ అన్నె జీమెదర్ విసారడ్ చక్కన బఙ్ఙర్, వెండి గుండ్నె బొమ్మలాఙ్ అండవిసా ఇనెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ఇంతె మన్కకున్ ఆ బుద్దిన్ వాలడ్ దెయ్యం ఓలుత్ ఓల్సెటర్లంఙ్ నటాక్ కతెంద్. గని పఙ్ఙి ప్రతి ఒక్కొనున్ మన్ బద్లిపుర్ ఇసా ఆగ్యసియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","తానుంఙ్ ఇంతె తాన్ దున్యత అనెక ప్రతి ఒక్కొ మన్కక్ న్యాయ్ ఎత్ తిర్పు ఇడ్డెక దినమున్ నిర్నాయ్ కతెంద్. అమ్నున్ తిక్త తన బత్కిపుత్ అముదు ఇది సదరుంఙ్ ఆదార్ ఎత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","తిక్ తార్ ఔర్ యేసున్ వాలడ్ తిక్ తార్ బత్కసార్ ఇసా పౌలు ఇడ్తదుంఙ్ కొన్సెం మంది అమ్నున్ హేలన్ ఇదర్తెర్. మల్ల కొన్సెం మంది, “ఇద్ నమ్ముత్ వాలడ్ అమ్ పెనా వినేంఙ్ ఇసా అన్సాతుమ్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ఇనంఙ్ ఎరెకదున్ వాలడ్ పౌలు ఆ సబతన కురియుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","కొన్సెం మంది విస్వాసిక్ ఎత్ పౌలున్ విచార్ కత్తెర్. అవ్రత్తి అరేయొపగు ఇనేక సబన్ పూర అనెక దియొనూసియు ఇనెకంద్ అముదు, దమరి ఇనేక పేర్త పిల్ల ఇవ్రడ్ ఇన్క కొన్సెం మంది అండర్. ");
INSERT INTO nit_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","అద్ ఎద్ద వెన్కత్ పౌలు ఏతెన్సు సయుత్ కొరింతింఙ్ సెద్దెంద్ ");
INSERT INTO nit_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","అత్తి అకుల ఇనెక పేర్త నయూదు కలయ్తెంద్. అమ్నె ఊరున్ సొత ఊర్. క్లౌదియ రాజక్ యూదు సిమ్కనన్ రోమా నగరముంఙ్ సయుత్ సెర్ ఇసా ఆగ్యసియ్‍తదున్ వాలడ్ పొంతు ఊర్ తంద్ అకుల ఇనెకా యూదద్ తన మాస ప్రిస్కిల్లనాడ్ కలయుత్ ఇటలీ తన కొరింతిత్ వత్తర్. ఇసా ఔరున్ ఓలెంఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","అదుంఙ్ ఎత్తి ఔర్ గిన గుడ్సెపడ్దా కుక్కుత్ బత్కనెర్ ఔర్ గని ఔరడ్ కలయుత్ అంత్ పని కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ఆర్ ఆలపుసేక దినం యూదులె సావ్డిత్ మిరయుత్ యూదులున్, గ్రీకు లున్ మనిలేంఙ్ కబుల సటీ కొసిద్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","మాసిదోనియ తన సీల, తిమోతిక్ వత్తె పౌలు తన్నె కలం సిమ్కన గొట్టిక్ ఇడ్డడెంఙ్ నిర్నయ్ కతెంద్. యూదు మంది నత్తి సాక్సం, యేసుది క్రీస్తుంద్ ఇసా ఇంతెర్ అముదు. ");
INSERT INTO nit_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","గని యూదు తిర్గుత్ అమ్నున్ బద్నం ఇదరుత్. పౌలు తన్నె జుఙ్ఙెలున్ జడపుత్, “ఇమ్మె సిక్స ఇమ్మె తల్ల పొయ్‍ని అంకద్ అదుంఙ్ నీరి కారన్, అన్ ఎరెన్.” ఇసా ఇంతెంద్. ఇండి అన్ మన్ సాప్ తొసెటరున్వై సెసత్. ");
INSERT INTO nit_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","అంతె తన సెత్ తీతు యూస్తు ఇనెక పేర్తద్ యుదు ఎర్సెటద్ ఒక్కొంద్ విస్వాసినే ఎల్లంఙ్ సెద్దెంద్. పౌలు యూదులె సావ్డి మెరం అన్నెంద్ అముదు దెయ్యమ్నె పుజా కలెకాంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","యూదు సవ్డి పొయ్ అదికార్ లంఙ్ ఇదరేక క్రీస్పు ఇనేక మన్కక్ అమ్నె ఎల్లంఙ్ సే ప్రబున్ విస్వాస్ ఇడ్డెర్. గుల్ మంది కొరింతి మందిన్ పౌలు ఇడ్త అదున్ వింత్ ప్రబుంద్ విస్వాస్ ఇడుత్ బాప్తిస్మ సుంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ఒక్కొ జీర్ సింతె ప్రబున్ పౌలుంఙ్ దర్సనమూత్ కండ్కుత్, “ఇనంఙ్ ఇంతెంద్ నీ అర్సెట ముడ్ సురుమి అన్నెమ్. పట్నముత్ అన్నె మన్కకెర్ గుల్ మంది అన్సార్. ");
INSERT INTO nit_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","అదుంఙ్ ఎతి మాన్ మొరపుత్ దైరమడ్ ఇడ్డుత్. అన్ ఇన్ వెంట. ఏరి ఇనుంఙ్ కరాబ్ కలేర్. ఈ పట్నముత్ అనెకర్ అన్నెని” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","పౌలు ఒకటినరా సంవస్రలుంఙ్ అత్తి అంత్ దెయ్యమ్నె గొట్టిన్ ఔరుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","గల్లియో అనెక పేర్ తన్ ఒక్కొ మన్కక్ అకయ ప్రతముంఙ్ బత్కెకంద్ లంఙ్ అన్నెంద్. అమ్నె కలముత్ యూదు సిమ్కన కలయుత్ పౌలుంఙ్ ఎదుర్ ఇల్లుత్. అమ్నున్ న్యాయ్‍పీట ముదర్వయ్ కొత్, ");
INSERT INTO nit_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“అముదు నేండె నియమ్‍ సాస్త్రన్ విరోద్ గునమాడ్ దెయ్యమున్ మొక్ ఇసా మందిన్ అన్ ఇదార్తెతి దరెకాద్ ఇసా జబార్దస్తి ఇడ్తెంద్” ఇసా అమ్నున్ నిర్నయ్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","పౌలు సమాదనం ఇడ్డెంఙ్ తయార్ ఎద్దెంద్. ఇమతెనాడ్ గల్లియో యూదులడ్, “ఒక్కొద్ తనెది అన్యాయ్ కత్తదున్ ఎన కరాబ్ వింతె సోయ్ గని, అన్ ఇమ్మె వింతిన్ వినెంఙ్ సోయ్తది అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","గని నీర్ అరొప్ పదం వాలడ్, పేర్లున్ వాలడ్, ఇమ్మె నియం సాస్త్రమూన్ వాలడ్ అదుంఙ్ ఎతి అమ్మెత్ ఇముంఙ్ నిర్నాయ్ కలుర్. ఇటవున్ వాలడ్ అనుంఙ్ మన్ తోతెద్” ");
INSERT INTO nit_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","అనట అనాటవున్ పొయ్ అన్ గొట్టి ఇడ్తన్, ఇసా ఇంత్ అముదు ఔరున్ న్యాయ్‍పీట తన పన్కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ఔర్ యూదులె సవ్డి అదికారి ఎద్దనున్ అముదు సోస్తెనేసును సుమ్ముత్ అమ్నున్ న్యాయ్‍పీట ముండట్ కుడుక్తెర్. ఎనాగ గల్లియో అనుంఙ్ సంమంద్ తోతెంద్ ఇంతెతి సూయ్ అండెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","పౌలు కొరింతిలున్ కొన్ని కలము అండెద్. అద్ ఎద్ద వెనుకత్ అత్తి అనెక దాదకేర్ సయుత్, అకుల, ప్రిస్కిల్లకున్, తన్ వెంట కూగుత్ రూకుత్ సిరియ దేసెముంఙ్ సెరెంఙ్ ఎద్దెర్. సెరెంఙ్ తోలె మొక్తదున్ తిర్పుత్ కెంక్రెయనె తనే తిరున్ బోడి కత్. ");
INSERT INTO nit_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ఔర్ ఎపెసుంఙ్ గదితెర్. అత్తి పౌలు అకుల్ల్ల ప్రిస్కిల్లన్ సయుత్ అన్ ఒక్కొది యూదులె సావ్డిఙ్ సెత్ యూదులాడ్ గొట్టి సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ఔర్ అమ్నున్ అమ్ వెంట పెనా కొన్ని దినల అండ్రు ఇసా వేల్తెర్. అముదు అనెంఙ్ సలెన్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","గని అవ్రి ముదర్వయ్, “దెయ్యంమ్నె ఇచ్చ అండినిమతె పెన వరసాత్ గా” ఇసా ఔరుంఙ్ ఇడ్డుత్ ఎపెసుంఙ్ రూకుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","అముదు కైసరియ పట్నముంఙ్ గదియుత్ అత్తరనా యెరూసలేముంఙ్ సెద్దెంద్. అత్తి అనెక సంగలున్ సుబాకాంక్సలు ఇడ్డుత్ అత్తరనా అంతియొకయఙ్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","అంతియొకయత్ కొన్ని దినా గడుపుత్ అత్తరనా సెరెంఙ్ ఎత్ గలతీయు, ప్రుగియ బార్సలెంఙ్ సెరెమఙ్ ఎత్, అమ్నె బార్సత్ అనెక సిసు విస్వాసమ అబివ్రుద్ది రొంబడెకాద్లంఙ్ ఇదర్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ఇద్ ఇనంఙ్ అనేఙ అపొల్లో ఇనేక పేర్త యూదుంద్ ఒక్కంద్ ఎపెసుంఙ్ పట్నముంఙ్ సెద్దెంద్. అపొల్లో ఊరుంఙ్ అలెగ్జాండ్రియా పట్నముంఙ్ పుట్తంద్. ఇమ్‍దు దండి గురుంద్ ఎద్దెంద్. లేకనముత్ సోయ్‍ గ్యాన్ తంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ప్రబునె పావ్ వాలడ్ ఉపదేసెముంఙ్ రొబటాద్ అముదు. ఆత్మ ఇడుత్న యేసున్ బదోల్‍ సొయడ్ దండి కుసినడ్ ఇసా ఇడ్తెర్. గని బాప్తిస్మ గొట్టిత్ అమ్నున్ యోహాన్ ఇడ్త గొట్టికున్ అదవి ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","అముదు యూదులె సావ్డిత్ దైరమాడ్ ముడ్సెంఙ్ మొదల్ ఇట్టెంద్. ప్రిస్కిల్ల, అకుల అమ్నె గొట్టిన్ వినుత్ అమ్నున్ తమ్మె ఎల్లంఙ్ కూగుత్ దెయ్యంమ్నె పావుంఙ్ బదోల్ అముంఙ్ ఇంకా సొయడ్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","అపోల్లొ అకయ బార్సఙ్ సే ఇసా ఇంతెర్. దాదకేర్ అమ్నే ఉద్దేసమున్ బలపరుస్తెర్, అకయ బార్సత్ అనెక సిసులున్ జవాబ్ వాయుత్ ఇమ్నున్ స్వగత్ ఇడ్ ఇసా వెల్తెర్. అముదు సెత్, దెయ్యమ్నె కృప వాలడ్ విస్వాసిడుత్ ఔరుంఙ్ గుల్ మదాత్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","మందిన్ ముండట్ జోరనాడ్ యూదులె వాద విదాలున్ ఇదరుత్, ఔరున్ ఆరిపుత్ లేకనమ్‍ వాలడ్ ఒర్కి పర్తసా యేసు క్రీస్తుంద్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","అపొల్లో కొరింతిత్ అన్నెంఙ ఎద్దిన్ తన్నెద్ ఇంతె, పౌలు నడుమున్ అనెక బార్సత్‍ అత్న ఎపెసుంఙ్ వత్తె కొన్సెం మంది సిసు అంనుంఙ్ కండ్కెద్దెర్. ఔరున్, “నీర్ నంముత్ అనెంఙ్ పరిసుద్దాత్మన్ సుమ్తిరా?” ఇసా వేల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ఔరు నమ్తె పరిసుద్దాత్మ అన్సాద్ ఇన్నెకరమీ అమ్ వినెతం. ");
INSERT INTO nit_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","అప్పుడ్ పౌలు, “ఇనంఙ్ ఎరతె నీర్ ఎటా బాప్తిస్మ సుమ్త్తిర్?” ఇసా వెలెంఙ ఔరు, “యోహాన్నె బాప్తిస్మ” ఇసాఇడ్త్ఎర్. ");
INSERT INTO nit_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","అదుంఙ్ ఎత్తి పౌలు, “యోహాన్ తన్న వెంట వరెకరతనట్, ఇంతె యేసునంత్తి విస్వాస్ ఇడుత్ మన్ బద్లిపుర్ ఇసా మందిఙ్ ఇడ్సా, బాప్తిస్మ” ");
INSERT INTO nit_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ఔర్ ఆ గోట్టిక్ విత్న ప్రబు ఇన్నెక యేసునే పేరడ్ బాప్తిస్మ సుంత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","మల్ల పౌలు ఔరున్ పొయ్ కేయ్యులిటే పవిత్ర ఆత్మ ఔరున్ పొయ్ వత్తిన్. అప్పుడ్ ఔర్ గొట్టిక్ ");
INSERT INTO nit_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ఔరు సిమ్కన కమ్మిజస్తి బరా మంది పడిసిల్. ");
INSERT INTO nit_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","మల్ల అముదు యూదులె సావ్డిఙ్ సెత్న ఇడ్సా దెయ్యమ్నె రాజ్యమున్ బదోల్ ఇడ్సా, కబులెర్ ఇసా, దైరమడ్ ముడ్సా ముది నెల అండెద్. ");
INSERT INTO nit_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ఇంతె కొన్సెం మంది తమ్మె మన్లున్ కటిన్ కత్న అంనున్ బద్నమ్ కలెకర్, మందిన్ ముండట్ క్రీస్తునె పావున్ బద్నం‍ కల్స వత్తెర్. అదుంఙ్ ఎత్తి అముదు ఔరున్ సాయుత్, సిసులున్ ఔరత్రనట్ అలది కత్న రోజ్‍ తురన్ను ఇన్నెక అంనున్ సాడత్ పన్కుత్ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ఇద్ది సాల్కులడ్ ఇనంఙ్ ఎద్దిన్. అదుంఙ్ ఎత్తి యూదు, గ్రీకు, ఆసియ త్ బత్కెకర్ పూర ప్రబునె వాక్యమ్ వింత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","అంత్తెయ్ ఎరెకడ్ దెయ్యం పౌలునాడ్ కండ్లు మిరుమిట్లు గొలిపే సమత్కలున్ ఇదర్తెద్. ");
INSERT INTO nit_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","అమ్నె చెత్తత్ కేయ్త జుఙ్ఙే ఎక్కద్ ముల్కె చెదంద్ ఎక్కద్ రొగులకెరున్ మెరం కొత్తె ఔరె రొగు సెసా, కరాబ్ ఆత్మ నాయ్ సాయుత్ సెసా. ");
INSERT INTO nit_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","అప్పుడ్ దేసెముత్ బత్కెకర్ యూద మంత్రిక్ కొన్సెం మంది, “పౌలు ఇడ్డెకా యేసునే పెరడ్ అమ్మున్ ఆగ్యసియ్సత్” ఇసా ఇడుత్, కరాబ్ ఆత్మ సుమ్తరున్ పొయ్ ప్రబు ఇన్నేక యేసునే పెరడ్ ఉసరిపెంఙ్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","యూదు ఇనేక స్కెవయను ఒక్క ముక్య దెయ్యలక్నే పోరకేర్ ఏడుగుర్ అనాయ్ కన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","అదుంఙి ఆ బూతున్ అన్ యేసునున్ ఒర్కిల్సాత్, పౌలున్వై ఒర్కిల్సాత్, గని నీర్ ఎరున్ వెలెంఙా! ");
INSERT INTO nit_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ఆ బూతున్ సుమ్తద్ మింటుత్ ఔరతర్ ఇద్దరున్ వంపుత్ గెల్తిన్; అదుంఙ్ ఎత్తి ఔరు జుకిలుత్ ఎత్న పెట్ల తిత్న జుఙ్ఙె తొసెట ఆ ఎల్ల తాన కురియుత్ తుటెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ఇదున్ బదొల్ ఎఫెసిత్ బత్కెక యూదులుంఙ్ గ్రీకులుంఙ్ ఒర్కి ఎదే ఔరు సిమన మందింఙ్ అరి వతిన్ అదుంఙెత్తి ప్రబు ఇనెక యేసునె పేరుంఙ్ మన్ ఎదిన్. ");
INSERT INTO nit_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","విస్వాస్ ఇట్టరున్ ఎపెసుంఙ్ బత్కెక యూదులుంఙ్ గ్రిక్‍ దేసెంతరుంఙ్ ఒర్కి పట్టె ఔరున్ సిమ్కనఙ్ అరివతిన్ అదుంఙ్ ఎత్తి ప్రబు యేసునె పేరున్ గనపరసతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","మల్ల మాత్ర విద్యెన్ అబ్యాస్ కత్తర్ సిమ్కన తమ్మె పుస్తకెవ్లున్ పుసుత్న, సదరుంఙ్ ముండట్ అదవున్ కిసిటెర్. ఔరు లెక్క ఓలెంఙ అదౌలె కిమ్మత్ పన్నస్ హజాల్ల వెండి రుపియలె. ");
INSERT INTO nit_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ఇనంఙ్ ప్రబునే సువార్త సిమ్కన రగ్టకెర్ ఎత్న, తమ్ కతవున్ ఒర్కికత్న ఒప్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ఇనంఙ్ ఎద్ద వెన్కత్ పౌలు మాసిదోనియ అకయ దేసుల మర్గలడ్ యెరూసలెమ్ సెరెకదుంఙ్ ఆత్మ తయర్ ఎత్ అన్ అత్తి సెద్ద వెన్కత్ రోమ వరులంఙ్ దెకుల్ ఒలెంఙ్ ఇస ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","అప్పుడ్ తమ్మె కబులక్ తిమోతి, ఎరస్తు ఇన్నెక ఇద్దరున్ మాసిదోనియమ్ఙ్ పన్కుత్ తన్ ఎకున్ ఆసియ త్ కొన్నిగొల్ అండెద్. ");
INSERT INTO nit_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ఆ దినాలుంఙ్ క్రీస్తునె పావున్ బదోల్ ఆత్తి గులెనా లొల్లి ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ఎనంఙ్ ఇంతె, దేమేత్రి ఇన్నెక పేర్త తోర్దా అర్తెమి ఒక్కొ సొనరి డయనా దేయ్యంనె వెండి ముర్తిక్ నివ్డిప్సా అత్త పనితరుంఙ్ సొబత పయద సుమ్మెకద్. ");
INSERT INTO nit_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","అముదు ఔరున్ ఆ వృతిత్ అనెకర్ ఔరున్ మిరపుత్ ఔరున్, ఈ పనిన్ వాలడ్ నేండుంఙ్ సోయ్త పయ్‍ద వర్స నేండె బత్కుంఙ్ సోయ్ ఎర్సద్ ఇసా ఇముంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ఇంతె పౌలు, కేయ్యులడ్ గడిప్త మూర్తికున్ కర్రె దెయ్య ఎరెవిస ఇడ్సా, ఎపెసుంఙ్ ఎరెకడి పురా ఆసియ తార్ గుల్ మంది మన్కకెరున్ కబులెర్ ఇసా ఇడ్తెంద్ ఇసా నీర్ వింత్తిర్, ఓల్తిర్ నై. ");
INSERT INTO nit_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","నేండె వృత్తిన్ పొయ్ కర్జి కమ్తి ఎరెకది ఎరెకడ్, అర్తెమి దెయ్యం మందిర్ నై పనింఙ్ వర్సెటద్ లంఙ్ ఎత్న, ఆసియ సిమనత్, ఇంక దున్యత సిమ్కన పుజకలెకద్నె ప్రబవం కమ్మి ఎర్సదొ ఎనంఙొ ఇసా అనుంఙ్ అరివార్సాద్ ఇసా ఔరుంఙ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ఔర్ ఇదున్ విత్న ఉగ్రులైపోయి, “ఎపెసియు లె అర్తెమి దండి దేవి” ఇసా వపొయ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","అదుంఙ్ ఎత్తి పట్నముత్ గులేన లొల్లి తయార్ ఎద్దిన్ వెంటాయ్ ఔరు పౌలున్ వెంట వ తా మాసిదోనియమ్ఙ్ కలయ్త గాయి, అరిస్తార్కులున్ సుముత్ సర్కక్ అత్తి నాటక్ ఇడ్డెక సాడత్ తోడ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","పౌలు ఆ మంది మిరయెక సబ మెర సెరత్ ఇంతెంద్ గని, సిసు అంనున్ సెరెంఙ్ ఇడెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","అంత్తెయ్ ఎరెకడ్ దేసెంత అదికరున్ అమ్నె సంఙ్తకేర్ కొన్సెం మంది అంనుంఙ్ కబుర్ పవిడుత్, “నీ నాటక్ ఇడ్డెక సాడత్ సేన్నేం” ఇసా వింతి కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ఆ సబత్ లొల్లి అన్సాద్. కొన్సెం మంది ఒక్కొ రకమడ్, కొన్సెం మరొక్కొ రకమడ్ వాపొయ్‍సార్. అసల్ తామ్ తనుంఙ్ అత్తి మిరయ్తెరొ గుల్ మందింఙ్ కరిలెతిని. ");
INSERT INTO nit_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","అప్పుడ్ యూదు అలెగ్జాండరున్ ముండట్ డగ్లిపుత్ అంనున్ మందింఙ్ ముండట్ కొత్తెర్. అలెగ్జాండర్ కర్రె ఇదరుత్ ఆ మందిన్ సమాదానం ఇడ్గల్సాత్ ఇసా ఓల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","మల్ల అంద యూదుంద్ ఇసా ఔరుంఙ్ కరిలుత్ సిమ్కన మంది మూకుమ్మడిగా ఇంది గంట దూక్ “ఎపెసియు లె అర్తెమి దండి దేవి” ఇసా నిద్దా కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","అప్పుడ్ ఊరా కరనముంఙ్ వెలంఙ్ మిరపు, ఎపెసిత్ అనెకర్, ఎపెసియు పట్నం అర్తెమి దండి దేవింఙ్ ఆబార్ తన్న రాటా పవిత్ర సిలన్ నియమ్తద్ ఇసా కరిల్సెటార్ ఎర్? ");
INSERT INTO nit_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ఈ సంగతిక్ తిర్గసెటవి అదుంఙ్ ఎత్తి నీర్ సాంతం మోరపుత్ తనెదుంఙి ఎక్కద్ లంకి పడ్సెట అండె సోయ్. ");
INSERT INTO nit_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","నీర్ ఈ మన్కకెరున్ తోడ వత్తిర్ ఓలె, ఇవ్రు గుడిన్ తవ్లిప్తర్? నేండె దెయ్యందూసన కత్తెర్? ");
INSERT INTO nit_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","అదుంఙ్ ఎత్తి దేమేత్రి అంనున్ వెంట అనెక సొనరిక్‍ ఇవ్రున్ పొయ్ అరొపు ఎద్దవెనా అండె న్యాయ్‌ కలేకద్ ఎరద్, అదికల్ అన్సార్ అదుంఎత్తి ఔరు ఒక్కొంద్ పొయ్ ఒక్కొద్ వాదా కలెంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","అనంఙ్ ఎరత్తె నీర్ మరొక్కొవున్ బదోల్ విచార్ కలతుమ్ ఇంతె అదా న్యాయ్ సబతీ న్యియ్ ఎర్సా. ");
INSERT INTO nit_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","నేండ్‍ ఈ గడబడున్ బదోల్ ఇడ్డెక కారన్ తనయ్ తొతెంద్ అదుంఙ్ ఎత్తి, ఇనెడ్ జర్గిల్త లొలిన్ బదోల్ అదికల్ నేండున్‍ వెల్సారొ తనెదొ ఇసా అరి వర్సాద్. ఇనంఙ్ కుప్ప మిరయెకదుంఙ్ తా కారన్ తనెన్ ఇడతుం. ఇసా ఔరున్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","అముదు అనంఙ్ ఇడుత్న సబన్ తిర్పతెంద్ం. ");
INSERT INTO nit_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","జగ్గడల్ కామ్మిఎందే, పౌలు యేసు సిసున్ కూగుస్సాన్. బుద్ది ఇండుత్న, అవురును తన్ ఆల పుసేక సుమ్మతేన్. అవేనుకాంత్ మాసిదోనియ సెస్నాద్. ");
INSERT INTO nit_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ఆ జాగ్గలెఙ్ తిరుగుత్న బుద్ది ఇండుత్న ఎన్నిగొ గొట్టికుల్ మందిఙ్ ఇండుత్న ఆక్రింఙ్ గ్రీసు దెసెముగు గదియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","అత్తిన్ ముద్ది నెల అండెన్ అంత్తర్న సిరియ దేసెముంఙ్ రూకుత్ పయానం ఇందరేంఙ్ ఇస్సా తయార్ఎద్దెన్. అంతేత్తి యూదులు తనును అల్ఙెంఙ్ ఇసా ఇస్సరిస్స అంమదుగు కారిల్తిన్. అనగ్ఎత్తి అముదు తిరుగుత్న మాసిదోనియ సేరుతు అత్తర్నపయానం సెస్నాద్. ");
INSERT INTO nit_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","అంమదును వెంట అనెకర్ ఎర్రితే! బేరయ పట్నంతన్ పుర్రక్నె పోరక్ సోపత్రు తెస్సలొకతద్ అరిస్ అరిస్తార్కు, సెకుందు, దెర్బే పట్నంతన్ గాయియు ఆసియా తన్ తుకికున్, త్రోపిము. అని తిమోతి ");
INSERT INTO nit_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ఇవ్రు ముండట్ సేరుతు అంముగు త్రొయ ఊరుత్ అముంఙ్ సటీ కాయ్యసానంస్సార్. ");
INSERT INTO nit_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","అమ్ పిలిప్ తన పులిత నిప్పలే పండఙ్ ఎంద్ రూకుత్ సేరెకాద్ ఏద్దిన్. ఐద్ దినా సెరెకద్ త్రొయ ఊరుత్ ఔరున్ కలయ్తమ్. అత్తి ఏడ్ దినా అండామ్. ");
INSERT INTO nit_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ఐతరం దినముంఙ్ సట్టం కలయుత్ నిపట్టె మురుకేంఙ్ మిరయ్తం. పౌలు మరొక్కొ దినముంఙ్ సెరెఙ్ ఇంత కాడితుంఙ్ సర్సం ఆలెదూక్ మందినడ్ ముడ్సంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","అముదు మాడిపొల కోలిత్ మిరయ్తం. అమ్మె కోలిత్ గుల్లెన దీవే తరిసనంసాద్. ");
INSERT INTO nit_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ఆ కోలిత్ కిడికిత్ ఐతుకు ఇనెక జవాన్ పోరక్ ఉద్దుత్ అస్సాంద్. పౌలు పేరేత్గడి ముడ్సని అమ్నున్. అంతెతి ఐతుకుంఙ్ మంఙ్ వత్తిన్ పొగుర్స మంఙ్ తెన్. ఆ జొప్పుతు ముడవ మాజ్లిపొయ్ బూడున్ రాటెంద్. కొన్సెం మంది వాత్ తిక్తనున్ అమ్నున్ ఓల్తేర్. ");
INSERT INTO nit_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","గని పౌలు బుడును సేరుతు ఆ జవ్వన్ పోరకున్ పక్కఙ్ ఒర్యుత్ అంనున్ ఎల్గతెంద్, “అర్సనెర్ పానం అస్సాన్” ఇస్సా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","అముదు మల్ల మాడి పోయి సెత్న నిప్పేటేన్ మురుకుతు సాగ్తకేరుగు సాయ్యుతు తన్ తిస్సాన్. పొద్ కురినంతెఙ్ అవురును వెంట ముడుతు సెస్నాద్. ");
INSERT INTO nit_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","మంది బత్కగ్తన్ ఆ జవన్ పోరకును అంమదును ఎల్లంఙ్‍ తోడ సేస్సర్. ఆ వేనుకాంత్ ఔరుంఙ్ ఎంతెయో ఆదార్ఎద్దే. ");
INSERT INTO nit_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","అమ్ పౌలున్ సాయుత్న రుక్ ఉద్దుత్ “అస్సు” సేద్దమ్. తన అడగ్స అస్సుగు గదియ్యుత్‍ పౌలు అత్తిన్ కాలయ్సాత్ ఇస్స ఇండ్తెన్. అత్తరన్ అంమును వెంట రూకుత్ పయానం ఇందరేంఙ్ ఇస్స అంమనె మన్. ");
INSERT INTO nit_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","అంమ్ అంమదును అస్సు తు కాలయ్తె అముదు అంమె రూకును ఉంతేన్. సాట్టం మిరయుతు “మితులేను” సేద్దమ్. ");
INSERT INTO nit_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","అత్తరన్ మల్ల ఒక్కొ దినం “కీయొసుంఙ్” వాత్తమ్ అని మల్ల ఒక్కొ దినం “సమొసు” దర్డిఙ్ గద్దియ్తమ్. మరొక్కొ దినం మిలేతుఙ్ వాత్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","పౌలు యెరుసలేముంఙ్‍ జంల్ది సెరెంఙ్ ఇస్సా ఇంతెంద్. ఆసియ పేలె దినలున్ అగామ్ ఇందరెకాంద్ తోద్ ఇసా ఎపెసుంఙ్ ఇల్క్సెట్ సేస్సన్. మొక్కఅండే పేంతెకొస్తు పండుగుదినం యెరూసలేంముత్ అనెంఙ్ ఇస్స ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","పౌలు మిలేతుఙ్ అనెంఙ్ ఎపెసులెంఙ్ అనెక కొన్సెం సంగమ్ దొడ కబుర్ పన్కుత్ అత్తి కూగ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ఔర్ వాత్తె అవురడ్ ఇనంఙ్ ఇండ్తెన్, అన్ ఆసియ త్ గేట్ట ఇట్టన్ అప్పుడ్ తన ఇంమడ్ అండన్ అనిగొల్ ఎనఙ్ బంత్కతనో ఇంముగు ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","యూదుల్ కాయ్యుత్నఅనుగు ఎన్నిగొ తక్లిబు, దుంఖాలున్ బొగ్గిల్తన్. గని ప్రబునే సేవక్ లంఙ్ పని విస్వాసమండ్ ఇందర్తన్. ");
INSERT INTO nit_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ఆత్మీయ గొట్టికులేంఙ్ ఇంముంఙ్ పాయ్యదతవ్ అరెక్ గొట్టిన్ డాప్సెట్, కుల్ ఎర్సెట్ ఎల్ల ఎల్లంఙ్‍ సేత్ ఇంముగు ఇడ్సెట అనెతన్. ");
INSERT INTO nit_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","మన్ బద్లిపుర్, దెయ్యముంఙ్ సటీ బాంత్కఇస్స, నేండె యేసు ప్రబునున్ విస్వాస్ తొసెట గ్రీకు యూదులుంఙ్‍, యూదు ఎర్సెటర్ ఎమ్మె సాక్సం ఇండ్తన్. ");
INSERT INTO nit_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","పంగి పరిసుద్దా ఆత్మ ఇండ్తెతి ఇందరెకాంద్ ఇస్స మనడ్ అన్ యెరూసముగు సేస్సనంసత్. అత్తిన్ జరిగిల్సాదో అనుగు ఏరక్తొంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","అన్ తక్లిబు, జెల్లుకులెంఙ్ సొస్సిప్సత్తివ్ ఇస్స పరిసుద్దాత్మ అనును అరెక్ పట్నంలెఙ్ ముండట్ సాక్సం సంకెల ఇద్ అనుగు ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","దెయ్యం కృప సొయ్త కబుర్ బదోల్ ఇండేకా గొట్టిన్ ఇండేకాంది అనే సాక్సం. గని ఈ తూలెకద్ కుస్తి తీటె యేసు ప్రబువు ఇండ్తవ్ ఈ పనిక్లున్ తిర్పతే ఎద్దిన్. గని అనే పానమున్ అన్ లెక్క కాలెన్. ");
INSERT INTO nit_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","అన్ ఇంమడ్ అంత్ దెయ్యమ్నె రాజ్యంన్ బదోల్ ఇడ్తన్. మల్ల ఇమ్మును ఓలెకాంద్ మొక్కరొబ్బడేంద్ ఇస్స అనుగు ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","అనంఙ్ ఎత్తి ఇంమత్తి ఎరెన్ తన్తెతని తిక్తె అముదుంఙ్ అన్ జిమ్మెదారి ఎరెన్. ఇంతెతన ఇమ్మెత్ నిరి సోయ్ ఇండ్గెసాల్సత్. ");
INSERT INTO nit_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","తనుంఙ్ ఇంతే అన్ దెయ్యమ్నె మన్తవున్ ఇముంఙ్ సాట్టం జరగిల్త డాప్సెట్ ఇండ్తన్. ");
INSERT INTO nit_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","అన్నె పోరక్నె నెత్తుర్ డ్ తోద్‍తె పోరక్నె వాబ్ వాలడ్ తన్నె సొత నెత్తుర్ ఇసా వాయుత్ అన్సాద్ ప్రబుద్ తన్నె నెత్తురున్ కమాప్తా సంగమున్ కయ్యెకద్ సటీ పరిసుద్దాత్మ ఇంమున్ అదికరిక్ లాఙ్ ఇదర్తిన్ ఆ మందన్ సంగంమున్ ఇమ్మెత్ నిరి ఉసారడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","అన్ సేద్దనింతే అర్సనేత్తిలాఙ్ లండిగకే ఇంమే మందత్ వారుతు వార్ కాల్సవ్ ఇస్స అనుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","అపుడ్ సిసు ఇంమును తన కొన్సెం మంది వత్ లబడ్ గొట్టిక్ ఇడ్సా విస్వాసికున్ మరొక్కొ పావుఙ్ పవిడ్సర్. ");
INSERT INTO nit_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","అంనగెత్తి ఉసరాడ్ అనురు. అన్ ముద్దిఙ్ సాల్కు ఇంమ్మతిన్ అండన్. కంతన ఈర్ ఇండుత్న సింతే తోల్లి ఇంమ్మత్తిన్ అంత్ సదరుంఙ్ ఇండ్తన్. బుద్ది ఇడ్డెకాద్ మద్దెతన్ నీర్ ఉసారడ్ అండ్రు. ");
INSERT INTO nit_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","పఙ్ఙి గి ఇంమును దెయ్యముంఙ్, కయ్యకద్ కృప వక్యం సియ్యిస్సాతును. అముదు ఇముంఙ్ ఆసిర్వాద్ సియ్యుత్ పవిత్ర కత దెయ్యం అన్నె దయ మందిన్ సాదరడ్ వారసు ఎరెంఙ్ సటీ సక్తి అస్సద్. ");
INSERT INTO nit_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","అన్ ఎదుగి నై అసా కలెన్ వేండి బఙ్ఙర్లున్ గని, సొబతా జుఙ్ఙెలున్ గని అస కలెతన్. ");
INSERT INTO nit_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","అన్ అన్నె కేయ్యులాడ్ పని కత్న, అనె గారుజుల్, అన్వెంట అనెక ఔరె గారుజుల్ తిర్పతన్ ఇస ఇంముగు ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","నీర్ గినా అనాయ్ దిక్కు తోసెటరుఙ్ మదత్ కాల్లెకాంద్ బాగ్యి వన్ ఇస ఇంముగు అనిఙ్ రంక్మిక్లడ్ ఇండ్తన్. యేసు ప్రబువు, “సుంమేకాందుఙ్ ఎన్ సియ్యెకాంత్తిన్ గులెన్ సోయ్ అస్సద్, ‘ఇస్స ఇంతేద్. అన్ అనిగ్నాయ్ గొట్టిక్లెంఙ్ ఇముంఙ్ ఉదహరనఙ్ అన్సాత్.’” ");
INSERT INTO nit_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ఈ రకాలడ్ ఇడుత్, అముదు తనే టొఙ్ఙెల్ టెకిపుత్న సట్టమడ్ కలయుత్ పార్తన కత్తేన్. ");
INSERT INTO nit_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ఆ వెన్కత్ సట్టం అరుత్న పౌలు ప్రేమనడ్ ఎల్గుత్ ముద్దిటెంద్. ");
INSERT INTO nit_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","అనుంఙ్ ఇంతె ఇమ్నున్ మల్ల ఓలెకదుంఙ్ మోక రొంబాడెంద్ ఇసా అముదు ఇత్త గొట్టికున్ ఔరుంఙ్ గుల్లెన దుక్కం కాల్గత్తె. ఆ వెంటాయ్ ఔర్ అమ్నాడ్ రూకుఙ్ ఎంత్ సెసార్. ");
INSERT INTO nit_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","అంమ్ ఓరున్ సాయుత్ సెదం కోసుఙ్ రూకుత్ పయానం కత్తమ్. మరొక్కొ దినం “రొదు” గదియ్తమ్. అత్తర్న కురుయుత్ పతరఙ్ గదియ్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ఒక్కొ రూక్ పొనీసియ సెరెకాదును ఓలుత్ అత్తిన్ పయానం సెస్సర్. ");
INSERT INTO nit_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","సైప్రసు దీప్ కండ్క ఎద్దే ఆ దిపుంఙ్ దక్సిన్ పక్కఙ్ సేత్ సిరియ దేసెముంఙ్ గదియ్తమ్. అంమే రూక్ సామన్ డింపేకాంద్ అస్సద్. అనగెత్తి తూరు డిగ్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","అత్తిన్ సిసు కలయుత్ అత్తి ఒక్కొ వారం అన్సాద్. పరిసుద్దత్మ సక్తినాడ్ యెరూసలేముంఙ్ సెరెంఙ్ తొంద్ ఇస్స పౌలుఙ్ ఇండ్తర్. ");
INSERT INTO nit_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","అంమ్ కొన్ని దిన అన్త సేద్దమ్. విస్వాసులు, తమ్మే మాససికూల్ పోరకేరడ్ కలయుత్ అమున్ వెంట ఊరుఙ్ ఆలపక్కఙెంత్ వాంత్తెర్. సముద్రం దర్డిఙ్ గదియ్తె, సాట్టం ముండుసు టెక్కిపుత్ పార్తన కత్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ఒక్కొనెత్ ఒక్కొంద్ సెరెక ఇండ్తమ్ అని అంమ్ రూకుత్ ఉంతెర్. ఔర్ తమ్మె తమ్మే ఎల్లక్లెంఙ్ సేస్సర్. ");
INSERT INTO nit_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","అంమ్ తూరు తన్ పయానం కురియుత్ తొలేమాయి ఊరుఙ్ వాత్తమ్. అత్తిన్ అనెక దాదకేర్ కాలయుత్న ఔరత్తి ఒక్కొ దినం అండమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","మరొక్కొ దినం పయానం సేత్ కైసరియఙ్ గదియ్తమ్. అత్తిన్ సొయ్త కబుర్ ప్రచార్ కాలేకాంద్ పిలిప్పు ఇనెక మన్కక్నే ఎల్లత్ సేదం అండమ్. అముదు యెరూసలేముత్ మదత్ కలెంఙ్ నేమిప్తంద్ ఏడుగురుత్ ఒక్కొద్. ");
INSERT INTO nit_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","అంనుంఙ్ పెండ్లిక్ ఎర్సెటవ్ జవన్ పిల్లక్ అన్సా. అదా సందేసం ఇడ్నె. ");
INSERT INTO nit_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","అత్తిన్ అంమ్ పేలె దిన అండమ్ అగబ్ ఇనెక పేర్తంద్ ప్రవక్త యూద తన వాత్తేంద్. ");
INSERT INTO nit_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","అముదు పౌలు వాత్, ముల్కెన్ కట్టెక టావెలడ్ అందనాడ్ తనే కేయ్యుత్ గేట్టల్ కట్టుత్న ఈ ఇనంఙ్ ఇస్సన, “ఈ ముల్కెన్ కట్టెక పట్ట వలడ్, అమ్నున్ యెరూసలేముత్ యూదులు ఈ రక్మినాడ్ కటుత్ యూదులెర్సెటర్ ఔరె కేయ్యుత్ సియ్యిస్సర్ ఇస్స పరిసుద్దత్మ ఇండ్సనంస్సన్.” ");
INSERT INTO nit_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ఇంద్ వింత మంది, అంమ్ కలయుత్ పౌలున్ యెరూసలేముంఙ్ సేరెఙ్ తొంద్ ఇసా వింతి కతమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","గని పౌలు, “నీర్ ఆర్రుత్ అన్నె మన్నుత్ బేమరి పడ్సతిర్? యేసు ప్రబునె పేరడ్ యెరూసలేముత్ కోండపేంఙ్ సటీ తొంద్, తిక్కెకాందుంఙ్ గిన అన్ తయార్ అస్సత్!” ఇస్స జవాబ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","అంమ్ అంమనే బుద్దిన్ కబులి కలెంఙ్ సాలేమ్ ఇస్స ఒర్కిలుత్న, ప్రబునే మంనడి ఎరెఙ్‍, ఇంత్ అంమ్ తనయ్ ముడెతమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ఆ వేనుకాంత్ సాట్టం తయార్ ఎత్న యెరూసలేముంఙ్ సేద్దమ్. ");
INSERT INTO nit_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","కైసరియ తన కొన్సెం మంది సిసు అంమున్ వెంట్ వాత్న మ్నాసోను సైప్రసు తద్ మన్కక్ అనెకాంద్, పేలె విస్వాసులత్తి అవురత్తిన్ ఎల్లత్ అనెఙ్ జాగ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","అంమ్ యెరూసలేముంఙ్ వాత్తమ్. అత్తిన్ దాదకేర్ అముంఙ్ గుల్లెన మన్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","మరొక్కొ దినం అంమ్ పౌలునాడ్ కలయుత్ యాకోబున్ ఓలెఙ్ ఇస సేద్దమ్. అత్తిన్ మందిత్ సంగం దొడ సాట్టం అస్సర్. ");
INSERT INTO nit_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","పౌలునే సేవనాడ్ యూదులెర్సెటర్ ఔరున్ మన్కకెర్ లోప దెయ్య కత్తద్ కామున్ బదోల్ సాట్టం సోయ్‍ ఇండ్సద్. ");
INSERT INTO nit_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ఔరె గోట్టిక్ వింతర్ సదర్ దెయ్యమున్ స్తుతికాల్సర్. ఆ వేనుకాంత్ పౌలునాడ్, దాదకేర్! వేల్ల మంది యూదులు విస్వాసుల్ ఎరేకాంద్ నీవ్ ఓల్సనంసతి. మోసే నియమ్ సాస్త్రత్ వాగిలేకాంద్ జరురీస్స ఔరె మంన్. ");
INSERT INTO nit_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","గని నీవ్ మోసే నియమ్ సాస్త్రును సాయ్యెమ్ ఇస్స, పోరకేరుఙ్ సున్నతి కాల్లెకాద్ తోద్ యూదులే నేక్కికున్ అడ్గనెర్ యూదులెర్సెటర్ ఔరున్ దేసముత్ బత్కకతెత్తి యూదులుంఙ్‍ ఇడ్తెతిలాఙ్ ఇవ్రుంఙ్ ఏరో ఇండ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","గని నెమ్ తనేద్ కాలేకాంద్? నీవ్ వాత్త గొట్టి ఔరుఙ్ ఒర్కి పడ్సద్. ");
INSERT INTO nit_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","అనంఙ్ ఎత్తి అంమ్ ఇండ్సతుమ్ అనఙ్ కాల్. అంమత్తిన్ మొక్ సియెకర్ నలుగుర్ అన్సర్. ");
INSERT INTO nit_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ఇవురున్ ఇన్ వెంట కూగుత్ తొండసే. అవురడ్ కలయుత్న పరిసుద్ద కలెకద్. ఔరె తల్లత్ తిలున్‍ కేర్రె కదుంఙ్ ఎరెక్ పైస్సెల్ సియ్యి. అనగకాంతే ఇన్ బదోల్ విత్తవ్ కారే ఎరెద్ ఇస్స సాట్టముంఙ్ గి సాక్సం ఎర్సద్. మోసే నియమ్ సాస్త్రన్ వాగ్గిసా బత్కసాత్తివ్ ఇస్స ఔరుంఙ్ కారిల్సద్. ");
INSERT INTO nit_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","గని ఇంక విస్వాస్ ఇడ్సెట యూదు బక్తకేరే గొట్టిత్ అమ్దు పఙ్ఙి ఎత్తి అంమే అబిప్రాయమున్ ఇండ్తమ్. ఔర్ ఈ నియమున్ మాత్రం అండగత్తె ఎర్సద్ “ముర్తికున్ ఇంట్ నివొద్దున్ పుడుకేంఙ్ తోంద్. నెత్తుర్, మన్కన్ పింత్కుత్ అంఙ్తదున్ జనవార్ సిల్లె ముర్యన్ తినేగ్తొద్. మరొక్కొ పిల్లన్ తన్ దౌవ్ అనేఙ్ ఇస్స ఇంతెర్. అదుంఙ్ ఎత్తి ఔరుంఙ్ వాయ్యుత్ పన్కతమ్” ");
INSERT INTO nit_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","మరొక్కొ దినం పౌలు ఔరున్ కూగుత్ కొసుతు ఔర్ వెంట్ వేలఙ్ కత్తేన్. ఆ అప్పుడి యెరూసలేమ్ పరిసుద్ద కలెకద్ మందిరుంఙ్ సేత్నసాట్టం వెలఙ్ ఎరేకాదుంఙ్‍ ఎన్ని దినల్ పావ్ఓల్స అనేఙ ఇండ్సన్. అకరి దినముంఙ్ తన్వెట వాత్తర్ అరేక్ ఒక్కొ బావున్ దాన్ సియ్యెంఙ్ వాంద్ ఇస్స ఇండ్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ఏడ్ దినల్ పూర్తిఙ్ ఎరెఙ్ తొల్లేని ఆసియ జాగత్ తన్ వాత్తర్ కొన్సెం మంది యూదులు పౌలున్ మందిరుత్ ఓల్సర్. ఔర్ మందిన్ సడిపుత్న పౌలున్ కొండప్సార్. మందినడ్, ");
INSERT INTO nit_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ఇస్రాయేల్ మన్కకేరెలార్! అంమడ్ మందత్ కాల్లుర్. ఇంమద్ సాట్టం జాగా తిరుగుత్న ఇస్రాయేలు మందిన్ బదోల్, మోసే నియమ్ సాస్త్రన్ బదోల్ యెరూసలేముత్ మందిరున్ బదోల్ విరోద్దడ్ సాట్టముంఙి ఇండ్సన్. పంఙి గ్రీకు కొన్సెం మందిరుంఙ్ కూగుత్నకొసుత్, ఈ పవిత్ర జాగన్ అపవిత్ర కత్తెన్, ఇస్స జోర్రనాడ్ ఇస్సర్. ");
INSERT INTO nit_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","మంది ఎపెసియు సుఙ్ ఔరె సోపత్రు పౌలునాడ్ కలయుత్ పట్నముత్ తిరగేకారును ఓల్తెర్. అంనగేత్తి పౌలు అమ్నున్ మందిరుంఙ్ కూగుత్‍ కొసెంఙ్ ఇసా ఇంతేద్. ");
INSERT INTO nit_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","పట్నముత్ సిమ్కన జగ్గడల్ ఎరేఙ్ ఎద్దేవ్. మంది నాలిఙ్ ములల్ తన్ తుల్స వత్తెర్. పౌలున్ సుమ్ముతు మందిరుంఙ్ ఆలపక్కఙ్ తివ్వుత్ అప్పుడి మందిర్త కవాడ్లున్ గేత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ఔర్, అంనున్ అల్ఙెకా కొస్సిదుత్ అస్సర్. యెరూసలేమ్ సాట్టం జగ్గడలాడ్ వాండిల్తుసేద్దిన ఇనెక గొట్టి సైనిక్లె పూడారింఙ్ పన్కతేర్. ");
INSERT INTO nit_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ఆ సైనిక్ పుడరి అప్పుడి, కొన్సెం మంది సైనికున్, సైనిక్లె దొడంద్, తన్ వెంట కొసుత్ మంది మిర్యత జాగత్ సేస్సన్. ఔర్ పుడారిన్, సైనిక్లున్ ఓలుత్, పౌలున్ దాంన్పెకాంద్ బంద్కతేర్. ");
INSERT INTO nit_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","పుడారి సైనిక్ అంనున్ మేర సెత్న, అంనున్ ఇనుమ్ సంకెలలడ్ కట్ ఇస్స సైనికుల్గు ఉక్కుమ్ సియ్తెంద్. అముదు ఎద్ ఎన్నెంద్? తనేంద్ కత్తేన్? ఆ వేనుకాంత్ మందిన్ వేల్తుఓల్సన్. ");
INSERT INTO nit_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","మంది జోర్‍కంత్ వాంపోయ్సా, ఒక్కొద్ మరొక్కొర్ మరొక్కొద్ ఇండ్సర్. అల్లరి అనెకాంద్ వల్లడ్ పుడరి సైనిక్లుంఙ్ ఎంద్దద్ తనేదొ తనయ్ కారిలెతిన్. పౌలున్ కిల్ల లోప కొసెంఙ్ ఉక్కుమ్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","పౌలు తంతే సోయ్‍ సొక్తె, మంది లగపెంఙ్‍సెదెర్‍. గని సైనిక్ పౌలున్ ఎత్తుత్ కిల్ల లోప తొండ సెస్సర్. ");
INSERT INTO nit_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","మంది అన్ ఎదగ్సని, “అన్ అల్ఙేఙ్!” ఇస్స జోర్రనాడ్ వాంపొయ్సార్. ");
INSERT INTO nit_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","సైనిక్ పౌలున్ కిల్లఙ్ లోప కొస్సుత్ ముండట్, అముదు పుడారి సైనికుంఙ్, “అన్ ఇంనడ్ కొచేం ముడెంఙ్ వందా?” ఇస్స వేల్తెంద్. పుడారిసైనిక్, “నివ్ గ్రీకు గొట్టి ముండ్సనంస్సత్తివ్! ");
INSERT INTO nit_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","పేలె సార్కరున్ మొర్చపుసుత్న నాలుగు వేల మంది కున్ కలెకరున్ బట్టికుల్లెఙ్ కూగుత్‍ కొస్తన్ ఐగుప్తు దేసెంతరివ్ నివిత?” ఇస్స వేల్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","పౌలు, “అన్ యూదునన్, కిలికియ దేసేంత్ తార్పుఇనెకా దండి పట్నంతరున్ ఎద్దున్. మందినడ్ ముడెంఙ్ ఇండుర్!” ఇస్స వెల్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","అమ్ద అదుంఙ్ ఉకుమ్ సియ్తెంద్. అపుడ్ పౌలు మెట్ల పొయ్ ఇలుత్న మందిఙ్ కెయ్యడ్ సాయ్గసద్. ఔరున్ హీబ్రు గొట్టినడ్ ఇనంఙ్ ఇంతేంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","దాదకేర్ బనెర్, అన్ పంఙి ఔరు ముండట్ ఎడ్డెకాద్ గొట్టి విన్డ్రు. ");
INSERT INTO nit_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","అముదు హీబ్రు గొట్టినడ్ ముడేకద్ విత్తెరపుడ్ ఔర్ ముడెసెట అండెర్. అముదు ఎనంఙ్ ఇంతెంద్, ");
INSERT INTO nit_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","అన్ కిలికియత్ తార్సు ఊరుఙ్ పుట్తన్ యూదుక్నన్. ఎద్దె ఈ ఊరుఙ్ గమలియేలు పెర్గుత్, నేండెత్ తొలెనితద్ నియమ్ సాస్త్ర కాలయ్ తా ఆగ్యలున్ సిక్సన్ రొబట్టిన్. నీర్ సిమ్కనయ్ ఈ రోజ్‍ అడ్డిర్ అనాయ్ దెయ్యంమ్నె గొట్టిత్ ఆస లొంబడుత్, ");
INSERT INTO nit_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ఈ విస్వాస పావున్ అగ్గెకరున్ పిల్లక్ పడ్సిల్ జేలుత్ తప్సార్, తిక్నంతెత్ సియ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ఈ గొట్టిత్ దండి దెయ్యలకేర్ దొడా అన్ ఎడ్డెకద్ కరెయ్ ఇసా ఇవ్రి సాక్సులాండర్. అన్ ఔర్ తనట్ దమస్కుంఙ్ అమ్నె దాదకేర్ పత్రిక సుముత్, అత్తర్ విస్వాసులున్ గినా కట్టుత్ సిక్ససియుత్ యెరూసలేముంఙ్ తోడా వరెంఙ్ ఈసా అత్తిఙ్ సెదం. ");
INSERT INTO nit_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","అన్ సెసాననెఙ్ఞ దమస్కుంఙ్ మెర్ వత్ తాపుడ్ దుప్పరి ఆబార్ తన ఒక్కొద్ సొబతత్ వెల్ఙు జోరనడ్ అన్ తిర్గొరా ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","అన్ భూమిపొయ్ రలుత్ అనెఙ “సౌలా సౌల, నీ అనున్ తానుంఙ్ హింస సియ్తదుంఙ్” అన్నడ్ ఒక్కొడ్ లెంఙ్ విన్ తాన్. ");
INSERT INTO nit_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","అదుంఙ్ వలాడి అన్ “ప్రబా! నీ వెనినివ్?” ఈసా వెలుత్ ఓలెఙ అముదు, “అన్ ఇనుఙ్ హింసాకల్ సాత్ నజరేత్ యేసున్” ఇసా అంనడ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","అన్నడ్ అనెకర్ అద్ వెలుంఙున్ ఓల్తెర్ గని అన్నడ్ ముడెకాద్ లెంగున్ వినెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","అపుడ్ అన్ ప్రబా, అన్ తనెద్ ఇదరేకాద్? ఇసా వెలుతొల్తన్. అప్పుడ్ ప్రబునున్, “నివ్ సులుత్ దమస్కుంఙ్ సే” అత్తి నీవత్ తానెద్ కలెఙ్ ఇసా అన్ తయరకత్త నొ అదవ్ సిమ్కన ఇనుఙ్ కరిల్సావ్, ఇసా అన్నత్తి ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","అద్ సొబావరెఙ అన్ ఓలెంఙ్‍ సాలెతన్. అద్దడ్ అన్నడ్ అనెకర్ అన్నె కెయ్యున్ సుముత్ అడ్గిప్సా దమస్కుంఙ్ పట్టంముత‍ కొస్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","అత్తి నియమ్‍ సాస్త్రం బదోల్ బక్తి అడ్గెకద్, అత్తి బత్కెర్ యూదులుఙ్ సిమ్కనంఙ్ సొబాతా పేర్ వత్తిన్ అననీయ ఇనెక మన్కక్ అన్నత్తి వత్ ");
INSERT INTO nit_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","అముదు అన్నత్తి వాత్ దాదకేర్ సౌలు, ఓలెకద్ అని అన్నడ్ ఇడ్డెగా అన్ ఓలెకద్ సుమ్ముత్ అమ్నుఙ్ ఓల్తన్. ");
INSERT INTO nit_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","అపుడ్ అముదు నెండె దొడలె దెయ్యలున్ ఒర్కిలెంఙ్ ఇసా అమ్నె నీతితంద్‍ సేవకున్ ఓలెంఙ్ ఇసా అమ్నె ముడెక గొట్టి వినెంఙ్ ఇసా ఇన్ నేమిప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","అవ్ ఓల్త అదవున్ వాలడ్, వీన్తావున్ అదవున్ వాలడ్ మందిన్ సిమనయ్ ముడట్ అమ్నుఙ్ సాక్స ఇల్సార్. ");
INSERT INTO nit_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","అదుంఙ్ అత్తి కయ్యెకద్ తనుంఙ్? లెసీ బాప్తిస్మ సుమ్ముత్, అన్నున్ పేరడ్ పార్తన ఇదరుత్ ఇన్నె పాపులున్ వెలుత్ సుమ్మ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","అదుంఙ్ వెంటని అన్ యెరూసలేముంఙ్ తిరుగుత్ వత్త దెయ్యమ్నె మందిరుత్ పార్తన ఇదరెగ్గా దర్సన్ ప్రబున్ ఓల్తన్. ");
INSERT INTO nit_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","అముదు అన్నడ్, “నివ్ వెంటని యెరూసలేముంఙ్ సయుత్సే” అనుంఙ్ వాలడ్ విచార్ కన్నెమ్ సాక్సం ఇత్తర్ మనిల్తేర్, ఇసా ఇండతెద్. ");
INSERT INTO nit_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","అదుగి అన్, ప్రబు, ప్రతి యూదులె సావ్డిత్ ఇంనత్తి బరొస ఇట్టరున్ ఔరున్ అన్ టానెత్ తప్పుత్ కొగ్స అండెరిసా ఔరుఙ్ ఓరికి. ");
INSERT INTO nit_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ఇంతెతొద్ గా ఇన్నె సాక్సి అమ్నున్ స్తెపను అల్ గ్తె అన్ గినా అత్తి ఇల్లుత్ అదుగి కబలిల్తెంద్ అమ్నునుఙ్ తిక్తె జుఙ్ఙెలున్ కైస అండాన్ ఇసా ఇండ్తన్. ");
INSERT INTO nit_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","అదుగి అముదు సెద్దె తానుంఙ్ ఇంతె అన్ ఇనుఙ్ దౌ యూదులెర్సెటరత్తి పవిడ్టన్, ఇసా అన్నత్తి ప్రబుద్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ఇన్తె దూక్ అముదు ఇం తాద్ ఔరు సొయ్ వీన్తెర్. గని వెంటని ఔరు, “ఇంటా మన్కక్ బత్కెంఙ్ సోయ్ తోద్. బూమిపొయ్ అనెఙ్ ఇడ్సెట అమ్నన్ అల్గుంఙ్” ఇసా వపొయ్ తెర్. ");
INSERT INTO nit_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","ఔర్ వపొయ్సా తన్నె జుఙ్ఙె జడిప్సా గాలిత్ దుమరం సుల్పతెర్. ");
INSERT INTO nit_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","ఇనంఙ్ ఔర్ అమ్నన్ దుస్మానడ్ వపొయ్సా కారన్ తనెంద్ ఇసా వెలుత్ ఓలెంఙ్ ఇసా రోమా సైనిక్ లే అదికరి పౌలున్ సటడ్ లగపుత్ వెలుతొలెఙ్ కొటఙ్ కొసుర్ ఇసా ఆగ్యసియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","గని ఔర్ పౌలున్ నరనడ్ కట్టెక అపుడ్ అముదు తన్నె తానుంఙ్ ఇల్లెక సైనిక్లె దొడంద్, “సిక్స సియ్సెటా ఒక్కొద్ రోమా మన్కకున్ సట్లడ్ లగపెఙ్ ఇముంఙ్ అదికరం అండాద్?” ఇసా వెల్తొల్తెద్. ");
INSERT INTO nit_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","సైనిక్ లే అదికరి ఆ గొట్టిన్ విన్త రోమా సైనిక్లె దొడన్వై సెత్, “ని తాగల్సతివ్? ఈ మన్కక్ రోమియుడు, ఒర్కియా?” ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","అపుడ్ రోమా సైనిక్లె అదికరి వన్న పౌలున్ ఓలుత్, “నివ్ రోమియుడవా? అద్ అన్నత్తి ఇడ్” ఇంత అపుడ్ అముదు, “అయ్ ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","పాపుడ్ రోమా సైనిక్లె అదికరి,” అన్ పేలెఙ్ పైసె సియ్తన్ రోమియునన్ ఎరెంఙ్ ఇసా కమయ్ కల్సత్ ఇంతెంద్ అదుగి పౌలున్, “అనెద్దె పుట్తతనయ్ రోమీయున్ని” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","అదుంఙి ఔర్ వెంటని పౌలుల్ సయ్తెర్. పొదె అముదు రోమియుడున్ ఒర్కిల్తపుడ్ అమునున్ కొండప్‍తదుఙ్ సైనిక్లె అదికరి దెకుల్ అర్సతెంద్ ");
INSERT INTO nit_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","మరొక్కొదినం, యూదులున్ అమ్నత్తి కున్త్తిప్త కరాబు కరెన్ ఒర్కిలెఙ్ సటీ, రోమా సైనిక్లె అదికరి అమునున్ సంకెలముల్ పుస్తెర్, దండి దెయ్యలక్, దడ్డి సబతర్ సిమనా సమాదనం ఎరెఙ్ ఆగ్యసియ్‍తన్, పౌలున్ కొత్నా ఔరున్ ముండట్ ఇల్పుర్, ");
INSERT INTO nit_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","పౌలు దడ్డి సబ తార్ ఔరున్ నిటామ్ ఓలుత్, “దాదకేర్, అన్ ఈ దినముంఙ్ తన దెయ్యం ముండట్ పూర సోయ్ మన్ సాక్సినాడ్ అడగ్సానన్సాత్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","అదుంఙ్ ఎతి దొడా దెయ్యలకెర్ అననీయ, ఇనేక “అమ్నే మూతి పొయ్ కుడ్కుర్” అని మేర ఉద్దుత్ అనెకరుంఙ్ అగ్జన్ ఇడ్డుర్. ");
INSERT INTO nit_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","పౌలు అమ్నున్ ఓలుత్, “సున్నమ్ లగాప్త గొడా, దెయ్యం ఇన్ కుడుక్దాంద్. ఇన్నె నియమ్ సాస్త్రం ప్రకారమ్ అన్ విచార్ కలుర్ ఇసా, నియమ్ సాస్త్రముంఙ్ విరొదడ్ అన్ కుడుక్ ఇసా అగ్జ సిసాన్సాత్?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","అపుడ్ మెర అనెకర్, “నీ దెయ్యమ్నె దండి దెయ్యలకున్ అక్మన్ కల్సతి తానుంఙ్ తనుంఙ్?” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","అదుంఙ్ ఎతి పౌలు, “దాదకేర్, ఇంద్ దండి దెయ్యలక్ ఇసా అనుంఙ్ ఒర్కి తోద్. ‘ఇన్నె మందినె అదికారి అక్మన్ అన్నెర్’ ఇసా వాయుత్ అన్సాద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","అత్తి అనెకరత్తి ఒక్కొ బాగం సద్దుకి కయ్యులూ, మరొక బాగం పరుసిక్ అండెతి పౌలు ఒర్కిలుత్, “దాదకేర్, అన్ పరుసిక్లె, పరుసిక్ సంతతివాన్ని. నేండుంఙ్ అనెక నిరీక్సన ఆస, తిక్ తార్ బత్కసార్ వాలడ్అన్ విచరనా వెంటపడసా నన్సాత్.” ఇసా మందిన్ ముండట్ వాపొయ్సా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","అముదు అనంఙ్ ఇడ్తపుడ్ పరుసిక్ సద్దుకి కయ్యులకు నాడ్మున్ జగ్డ ఎద్దిన్. అదున్ వాలడ్ ఆ మంది ఇందీ బాగు ఎద్దేర్. ");
INSERT INTO nit_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","సద్దుకి కయ్యులు తిక్ తార్ బత్కసార్ తొతేద్ ఇసా, దెయ్యమ్నె దూత్ ఏన, ఆత్మ ఏన తోతెంద్ ఇసా ఇడ్సార్. గని పరుసిక్ ఇదా సిమ్కన అన్యాయ్ ఇసార్. ");
INSERT INTO nit_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","అపుడ్ దండి జగ్డ ఎద్దిన్. పరుసిక్ అనెకర్ సాస్త్రులత్తి కొన్సెం మంది సులుత్, “ఇ మన్కకాక్ నత్తి ఎ తప్పు రొంబడెతిన్. ఒక్కొ ఆత్మ ఎన, దెయ్యమ్నె దూత్ ఎన అమ్నున్ వెంటా ముడెంఙ్ వంద్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","జగ్డ పెర్రెత్ ఎద్దత్తి పౌలున్ చిల్వ ఇదరెరా ఇసా రోమా సైనిక్ అదికరి అర్సుత్, “ఔరున్ లోప అంత్ అమ్నున్ జబర్ దస్తి సుమ్ముత్ కోటంఙ్ తొడవర్” ఇసా సైనిక్లుంఙ్ అగ్ఙ సితెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ఆ సింతె ప్రబున్ అమ్నున్ పకంఙ్ ఇల్లుత్ “ఇమ్మతడ్ అన్. యెరూసలేముత్ అన్ గురించి నీవ్ ఎనంఙ్ సాక్సం ఇడ్తివో అనాయ్ రోమ్ నగరముత్ గినా ఇడ్డెకాద్ అన్సాద్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","తొల్లిని ఎద్ద వెనుకత్ కొన్సెం మంది యూదు మిరయుత్, అన్ పౌలుంద్ ఇసా ఇడ్ అల్ఙనంతెత్ తినెకాద్ ఉనెకద్ సిమ్కన అని ఒట్టు ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","నలపై మందిఙ్ ఎనా జాస్తి ఈ కుర్ర గదితెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ఔర్ దండి దెయ్యలక్ మేర, దొడా మేర వత్, “అమ్ పౌలున్ అలంఙ్ నన్తెత్ తనేది తినెం ఇసా గట్టినాడ్ ఒట్టు ఇట్టమ్. ");
INSERT INTO nit_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","అదుంఙ్ ఎతి నీర్ మందినై సబాత్ కలయుత్, అమ్నున్ సోయ్ వెల్తొలుత్ అమ్నున్ ఇమున్ మేర తోడవర్ ఇసా రోమా సైనిక్లే అదికరి వెంట మనవి కాలుర్. అముదు ఇమున్ మేర వరెంఙ్ పేలెని అమ్నున్ అల్ఙెంఙ్ తయార్ ఎత్ అన్సాతుమ్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ఇంతె పౌలునె తోర్దా లె పోరక్ కసా ఇల్టమ్ ఔర్ అనంఙ్ ఇసా ఇంతెర్ పాని కొట తయార్ ఎత్ సైనికు ఆ సంగతిన్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","అపుడ్ పౌలు ఒక్కొ అదికరిన్ కూగుత్, “ఇ రోమా సైనిక్లె దొడనున్ మేర తోడ సే. ఇంద్ అమ్నున్ వెంట ఒక్కొ గిట్టి ఇడ్డెంఙ్ ఇసా అండద్” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","సైనిక్లే అదికరి ఆ రోమా సైనిక్లే అదికరిన్ మేర తొడ సెత్, “కైదిలాంఙ్ అనెక పౌలు అన్ కూగుత్ ఈ జవన్ మన్కాన్ ఇన్ మేర తోడ సే ఇసా వెల్తెంద్. అముదు ఇన్ వెంట ఒక్కొ గొట్టి ఇడ్డెకాంద్ ఎటే” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","రోమా సైనిక్ లె అదికరి ఆ మన్కక్నె కేయ్యున్ సుమ్ముత్ అలపకంఙ్ తోడాసెత్, “ని అన్ వెంట ఇడ్డెకా సంగతి తనేద్?” ఇసా ఒక్కొంది అనెఙ వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","అదుంఙ్ ఎతి, “నీ పౌలున్ పుర్తిగా విచార్ కలేంఙ్ ఇసా అమ్నున్ వేగెడ్ సబాంఙ్ మేర తోడవరెంఙ్ ఇసా ఇన్ బతిమలాడెంఙ్ యూదు పావ్ ఓల్స నన్సార్. ");
INSERT INTO nit_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","గని ఔర్ ఇడ్త గొట్టింఙ్ కబులిలెంఙ్ తోద్. తానుంఙ్ ఇంతె అవ్రత్తి నలపై మందిన్ ఎన జాస్తి అమ్నుఙ్ సటీ ఓల్సా నన్సార్. ఔర్ అమ్నున్ అలుంఙ్ నన్తెత్ పుడుకరంఙ్ తోద్ ఇసా ఒట్టు ఇట్టెర్. పఙ్ఙి ఇన్నె గొట్టింఙ్ సటీ ఒర్కిలుత్ అన్సార్” ఇసా ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","అపుడ్ ఆ రోమా సైనిక్ లె అదికరి, “జవన్ పోరకున్ ఈ గొట్టిన్ అనుంఙ్ ఒర్కిల్ తెతి ఎరడి ఇడ్నెమ్” ఇసా అర్పులిపుత్ పవిటెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","మల్ల అముదు తన్నె ఇద్దర్ అదికరికున్ కూగుత్, “కైసరియఙ్ ఎంత్ సెరెంఙ్ ఇందిఙ్ నుల్ మంది సైనిక్లె దొడా డెబై గుర్రలున్ ఇందిఙ్ నూల్ బర్సిక్ సుమ్ముత్ ఔరున్ సింతె తొమ్మెది గంటలుంఙ్ తయార్ కాలుర్. ");
INSERT INTO nit_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","పొలికుడి పేలిక్సున్ మేర పౌలు సోయ్ తోడవరెంఙ్ గుర్రలున్ తయార్ కలూర్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","అముదు ఇనంఙ్ ఒక్కొ ఉత్తర్ గిన వాయుత్ సియ్తెంద్, ");
INSERT INTO nit_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","గౌరవనియులైన పలక్ పేలిక్సున్, క్లౌదియస్ లూసియసుంఙ్ వందనాలు. ఇసా వాయ్తన్. ");
INSERT INTO nit_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","యూదు ఈ మన్కన్ సుమ్ముత్ అలఙా, అముదు రోమియుంద్ ఇసా వింత్, సైనిక్వై సెత్ అమ్నున్ గెలుప్తన్. ");
INSERT INTO nit_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","ఔర్ అమ్నున్ పోయ్ తప్పత గునా తనేదొ ఒర్కి పర్తెంద్ ఇసా అన్ ఔరె దడ్డి సబాత్ అమ్నున్ తోడ సెద్దన్. ");
INSERT INTO nit_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ఔర్ అమ్నె నియంసాస్త్రమూన్ వాదలున్ వాలడ్ తనేవొ గునా అమ్నున్ పోయ్ మోప్తెర్ తప్ప తిక్కెకదున్ ఎనా గునా తనేద్ అమ్నాడ్ ఓలిపెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","తే ఔర్ ఈ మన్కకున్ అల్ఙెంఙ్ నిర్నాయ్ కల్సార్ ఇసా అనుంఙ్ ఒర్కి వెంటని అమ్నున్ ఇమున్ మేర పన్కసాత్. గునాన్ సొసిప్తర్ గినా అమ్నున్ పొయ్ ఇడ్డెంఙ్ ఇనేక సంగతిన్ ఇమున్ ముదర్వైని ఇడ్డెంఙ్ ఇసా ఆగ్య యసితెంద్. ");
INSERT INTO nit_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","అదుంఙ్ ఎతి రోమ సైనిక్లున్ ఆగ్యసియ్త ప్రకరం ఔర్ పౌలున్ సింతె వేల అంతిపత్రింఙ్ తోడ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","మరొక్కొ దీనం ఔర్ గుర్రమున్ వాలడ్ సైనికు పనుకుత్ ఔరె కోటన్ తిర్గుత్ సెద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ఔర్ కైసరియంఙ్ వత్ పొలకుడికి కలెకన్వై సియ్యుత్ పౌలున్ అమ్నున్ ముదార్వై ఇలుప్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","పలక్ ఆ ఉత్తరున్ వసిపుత్ ఏ బార్సఙొ తందో అమ్నున్ వెల్తెంద్. కిలికియంఙ్ కలయ్తంద్ ఇసా ఒర్కిలుత్. ");
INSERT INTO nit_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“ఇన్ పొయ్ నేరం సొపిప్తర్ గినా ఔర్ గినా వత్త వేనుకత్ ఇన్నె సంగతి పుర్తిగ విచార్ కల్సాత్” ఇసా ఇడ్డుత్, హేరోద్ రాజకెరె మందిరుత్ అమ్నున్ కయ్యెకదుంఙ్ అమ్నున్ ఇడెంఙ్ ఇసా ఆగ్య సితెంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ఐద్ దినా వెనుకత్ మెన్ దెయ్యలక్ అననీయ, కొన్సెం మంది దొడా, తెర్తుల్లు ఇనేక ఒక్కొ న్యాయ కలేకద్ కైసరయ వత్, పౌలు పొయ్ ఇట్టా పిర్యదులున్ పేలెక్సుంఙ్ ఒర్కి సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","పౌలు పొలకుడికి ముదర్వై ఇల్‍తత్తి తెర్తుల్లు ఇమ్నున్ పొయ్ నేరం సిసా ఇనంఙ్ ఇన్తెంద్. మెన్ దొడలున్ గబ్ర్నల్ అమే అదికారి మొరపుత్ పెలిక్సు, అమ్ ఇమ్మె బత్కెకాదుంఙ్ ఎంతొయొ నేయ్యర్ అనుబావ్ కల్సాతుమ్ ఇసా, ఈ దేసెం తర్ మందిన్ రొంబడెకాద్ ఎంతొయొ పరిసాన్ ఇమున్ వాలడ్ పరిస్కరం ఎర్సనంసావ్ ఇసా మనిల్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","దండి మాన్ సియ్తంద్ పేలిక్సున్ ఆ కరనమాడ్ అమ్ సిమ్కన ఇదదాడ్, అని జాగలాడ్ ఇమున్ వకలాడ్ పూర ఇదదాడ్ అన్సాతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","అన్ ఇముంఙ్ పెర్రెత్ గడి ఇడ్సెట పురయ్ ఇడ్డెక గొట్టికున్ నీర్ దయ ఒలిపెంఙ్ వినేంఙ్ ఇసా ఇడ్సనండాతుమ్. ");
INSERT INTO nit_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","ఈ మన్కక్ గుల్ కరాబ్ లంఙ్ అనే ఆంద్. దున్యత పొయ్ అనెకా యూదు సిమ్కనన్ తిర్గుత్ పడెంఙ్ రెపుత్. ఇంద్ నజరేత్ నేండె జాతిత మన్వలె ఇసా ఒర్కిల్ తమ్. ");
INSERT INTO nit_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","మల్ల ఇమ్‍దు మందిరున్‍ అపవిత్ర కలెంఙ్ కోసీద్‍ కన్నెద్‍ గని అమ్ అమ్నున్ సుంతమ్‍ ");
INSERT INTO nit_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","గని ఇమ్మె సైనిక్లె అదికారి లూసియ వత్న జబర్దస్తి అమ్మె కెయ్యుల తనట్ వెత్తుత్ తొడసెదెద్. ");
INSERT INTO nit_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","అమ్ అమ్నున్ పొయ్ తప్త గలతున్ నీర్ వేల్తిరింతె అద కరెయ్‍ ఇసా ఇముఙి ఒర్కి ఇంతెంద్‍. ");
INSERT INTO nit_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","యూదు అదుంఙ్ ఎతి ఒక్కొదీ ఎత్న ఈ గొట్టికున్ కరేయ్ ఇసా ఇడ్తేర్. ");
INSERT INTO nit_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","అపుడ్ రాజుంద్, ముడ్ ఇసా పౌలున్ సైగుత్ ఇడెంఙ్‍, పౌలు ఇనంఙ్ ఇంతెంద్. నీర్ ఎన్నిగొ సాల్కుతన ఈ మందింఙ్ న్యాయకలెకాని లంఙ్ అన్సతి ఇసా ఒర్కిలుత్ అన్ దైరమాడ్ జవాబ్ ఇడ్ తాన్. ");
INSERT INTO nit_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","అన్ యెరూసలేముంఙ్ మొకెంఙ్ సెత్ పాక్త పన్నెండు దీనలి అంతెయ్ ఎద్దిన్ ఇసా నీర్ విచార్ కత్ ఒర్కిలేంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","దెయ్యంమ్నె మందిర్ ఎనా, యూదులె సావ్డి ఎనా, పట్నముత్ ఎన, అన్ ఎరున్ ఎన మిరపెకాంద్, తోద్‍తె మందిన్ ముడట్ వాపొయెకాద్ మోదలిడెహ ఏరి ఓలెతేర్. ");
INSERT INTO nit_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","ఔర్ పఙ్ఙి అన్ పొయ్ మోపేక గునలున్ ఇముంఙ్ కయ్యెయ్ ఇసా ఇడ్డెంఙ్ సాలె. ");
INSERT INTO nit_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","ఇమ్మున్ వాలడి అన్ నెండె బనెర్ లగి దెయ్యమున్ వాలడ్ అగ్తన్ నంసతున్, నియమ్ సాస్త్రముత్, ప్రవక్త లే గ్రంతాముత్ వాయుత్ అండనున్ నమ్ముత్. ");
INSERT INTO nit_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","నీతి మంతులూన్ ఆ నీతి పరులకూ తిక్ తార్ బత్కసార్ రొబడదిసా ఇవ్రు నమ్‍తెతి అన్ గినా దెయ్యమున్ పొయ్ నమ్సెటాంద్ ఇడుత్, ఔర్ తమ్మెసాకన ఇసా కుగ్తర్ ఈ మర్గముత్ అన్నె పుర్వికులున్ దెయ్యమ్నె అదికార్ సిసా నంసాత్. ");
INSERT INTO nit_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","ఇనంఙ్ దెయ్యమున్ వాలడ్, మన్కకున్ వాలడ్ ఎప్పుడి అన్నె మన్ సాక్సినాడ్ సొయడ్ అనెకద్ లంఙ్ ఓల్సతున్. ");
INSERT INTO nit_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","కొన్ని సల్కు ఎద్ద వేనుకత్ అన్ అన్నె తానే మందింఙ్ కొన్నిపైసే దాన్ సియెంఙ్ సటీ వతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","అన్ సోయ్ ఇదారుత్ అచారం అదవున్ సియ్యెహ నీర్ మందిరుత్ పరిసుద్ద కలెకద్ అన్ ఓల్తిర్. అన్ తనయ్ గుంపుత్ ఉద్దెతన్, అన్ వాలడ్ లొల్లి ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","తే ఆసియ తన వత్త కొన్సేం మంది యూదు అన్సార్. అన్ పొయ్ ఔరుంఙ్ తనేదెనా అండినింతె ఔర్ తనయ్ అన్ పొయ్ నేరం డొప్పత్న అనేంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","తోద్‍తె, అన్ మందిన్ ముండట్ ఇల్లుత్ అండపుడ్, తిక్తరె పనామ్ ఎరెకా గురించి ఇనేడ్ ఇమున్ ముండట్ అడుగ్సా నంసతున్ ఇసా అన్ దైరమడ్ ఇడ్త ఆ ఒక్కొ గొట్టిన్ గొట్టికత్ తప్పులున మల్ల ఎ అన్యాయ్ ఎద్దె గినా నీర్ ఒర్కిలుత్ అనేంఙ్ అద్ ఇడ్డెంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","తిక్ తార్ బత్కసార్ ఔరె వడ్మున్ ఇల్లుత్ అన్ జోర కత్ ఎద్తన్ ఈ గొట్టికున్ అన్ వాలడ్ ఎద్ది కరాబ్ నీర్ ఒర్కిల్ తిర్ఎరతె నీర్ ఎడ్డెంఙ్ వాంద్ ");
INSERT INTO nit_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","పేలిక్సున్ పావున్ బదొల్ గొట్టిక్ సొయ్ ఒర్కి. అముదు, “సహస్రాదిదతిన్ లూసియసుంఙ్ వత్తపుడ్ ఇనే సంగతి అన్ విచార్ కత్ ఒర్కిల్ సాత్” ఇసా ఇడ్డుత్ వెల్తొలెకదుంన్ ఇలుప్సాత్. ");
INSERT INTO nit_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","పౌలున్ పక్కఙ్ కైయెంఙ్ ఇడుత్, అమ్నున్ విచార్ కలేంఙ్ సటీ ఔరె సుట్టలత్తి ఎరుని అమ్నున్ మేర సెన్నెర్ ఇసా సైనిక్లె దొడంద్ ఆగ్య సితెంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","కొన్నీ దీన ఎద్ద వేనుకత్ పేలిక్సున్ యూదులర ద్రూసిల్ల ఇనెకా తన్నె మాసలాడ్ గీన వత్ పౌలు కడుకెత్, క్రీస్తు యేసుతొ విస్వాసమున్ వాలడ్ అముదు ఇడ్డెహ వింతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","గని పౌలు నీతిన్ వాలడ్ ఆసానిగ్రహం వాలడ్ వరెకా న్యాయం వాలడ్ ఇడ్సననెఙ పేలిక్సున్ ఇడ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","మల్ల పౌలు అనుంఙ్ తనేవేనా పైసె సిసదొ తన్దం ఇసా ఆసనాడ్, అమ్నున్ గొట్టి గొట్టిన్ కలపుత్ ముడ్సా నండాద్. ");
INSERT INTO nit_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","ఇంది సల్కు ఎద్ద వేనుకత్ పేలిక్సున్ బద్లి పోర్కియస్ పేస్తు పలక్ వతెంద్. అపుడ్ పేలిక్సు యూదు నదురుత్ సోయ్తంద్ ఇనేంఙ్ ఇసా, పౌలు టానెత్ సాయుత్ సెద్దెంద్. ");
INSERT INTO nit_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","పేస్తు పలక్ వత్తద్ ముది దినలుఙ్ కైసరియన్ తనట్ యెరూసలేముంఙ్ నత్తి సెద్దన్. ");
INSERT INTO nit_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","అపుడ్ దొడలుఙ్ దెయ్యలకేర్, యూదులె దొడా, పౌలు తన్నె వింతి కత్న అమ్నుఙ్ బదోల్ ఒర్కిలతెర్. ");
INSERT INTO nit_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","“దయకత్ పౌలుఙ్ యెరూసలేముంఙ్ కూగుర్” ఇసా పెస్తును ఔర్ కొర్తెర్ తనుంఙ్ఙితె ఔర్ అంనుఙ్ పవుత్ అల్ఙేఙ్ ఇసా టపిల్లుత్ అండార్. ");
INSERT INTO nit_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","అనుంఙ్ పేస్తు, “పౌలు కైసరియత్ జెలర్లఙ్ అండాద్ అన్ జలద్ అత్తిఙ్ సెరెకరాన్ అడ్డాత్. ");
INSERT INTO nit_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","అదుగ్గీ ఇమ్మత్తి ఇమ్మె నాయకులున్ అన్నడ్ కైసరున్ వత్నా అమ్నుఙ్ కరాబ్ పొయ్ అనెకద్ అండేదీంతే నేరం మెపవచ్చు” అని ఉత్తర్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","అముదు ఔరె తనట్ ఎనుందీ తొదీంతె పదీ దీనా అత్న కైసరియఙ్ సెత్నా మరొక్కొదిమం న్యాయ్‍పీట పొయ్ ఉద్దుత్ పౌలున్ తోడవా ఇసా ఆగ్య సియ్తెద్. ");
INSERT INTO nit_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","పౌలున్ వత్తెదింతె యెరూసలేమ్ తనట్ యూదులుఙ్ అమ్నె తిర్రొరా ఇల్ తా, ఎంనిగొ కరాబ్ గునలున్ కుతెంద్ గని అదవున్ రుజువు ఇదారెంఙ్ సాలేతం. ");
INSERT INTO nit_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","మల్ల పౌలు, “యూదులుఙ్ నియమ్ సాస్త్రం వాలడ్ ఎక్కద్, మందిరున్ వాలడ్ ఎక్కద్ రొమ రాజూ వాలడ్ ఎక్కద్ అని పాప్ కలెతన్” అని జావబ్ ఇంతెంద్ ");
INSERT INTO nit_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","తే పేస్తు యూదులకెరడ్ మంచి సొబతద్ ఇన్గేంఇసా, “యెరూసలేముంఙ్ వత్న అత్తి అన్నెముండట్ ఈదవ్ సంగతి వాలడ్ కివ్ కలెకద్ ఇనుఙ్ మన్నుగ్గా?” అని పౌలున్ వెల్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","అదుఙి పౌలు, “రొమ రాజూ న్యాయ పీటముంఙ్ ముండట్ ఇల్లుత్ అడ్డన్. అన్ విచార్ ఇదరెకాద్ జాగా ఇద్దీ యూదులుంఙ్ అన్ ఏ అన్యాయ్ ఇదరెతెంద్ ఇసా ఇముంఙ్ గుల్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","అన్ అన్యాయ్ సుక్కిలుత్ తికెకదుంఙ్ సిక్ససా పని ఎత్దెనా ఇదరుత్ అన్డె తికెకదుంఙ్ అస్సెన్. నీర్ అన్నత్తి మెపుతున్న నెరముంఙ్ ఏద్ది కరే అర్సెటండె అనుంఙ్ ఔరుఙ్ ఏరో సియ్యెంఙ్ ఇసా వేల తోతెద్. అన్ రొమ రాజూంఙ్ ముడటి ఇండ్సాత్” ఇన్తెద్. ");
INSERT INTO nit_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","అప్పుడ్ పేస్తు తన్నె సల్ల సియెకరడ్ వీసర్ కత్, “రొమ రాజక్ ముండట్ ఇడ్సత్ ఇం తా, రొమ రాజూ అన్నత్తిని పవిడ్ సాత్” ఇసా ఉత్తర్ సియ్తెద్, ");
INSERT INTO nit_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","అదుంఙ్ వెన్కత్ కొన్ని దినలుంఙ్ రాజక్ కెరుంఙ్ అగ్రిప్ప, బెర్నీకే పేస్తును ఓలుత్ కూగెంఙ్ కైసరియఙ్ వత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ఔరత్తి పేలెగొలుఙ్ వెన్కత్, పేస్తు పౌలు వాలడ్ రాజక్ ఇనంఙ్ ఇడ్తెంద్, పేలిక్సున్ సయుత్ సెద్ద జెలర్ ఒక్కొద్ ఇత్తి అడ్డాద్. ");
INSERT INTO nit_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","అన్ యెరూసలెముంఙ్ అనెఙ అత్తి దండి దెయ్యలకెర్, యూదులుఙ్ దొడా, అన్నత్తి పొయ్ ఇదర్త వున్ సిక్స సియ్‍త్ కొర్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","గని అదుగ్గీ అన్, గునా ఎరున్ పొయ్ తప్పతనొ ఆ మన్కకు గునా తప్పతరున్ ఎదుర్, తన్నె పొయ్ ఔరే కున్ తా గునా వాలడ్ సమదానం ఇడ్డెగ్ అవకసం సియ్యెంఙ్. అద్ తోసెటా ఏది మన్కకుఙ్ న్యాయ్‍ కలెంఙ్‍ రోమియుల పద్దతి ఎరెత్ ఇసా ఉత్తర్ సియ్ తెద్. ");
INSERT INTO nit_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ఔర్ ఇత్తి వత్తెర్ అపుడ్ అన్ కొరుమ్ కలెతన్, మరొక్కొదినం న్యాయ్‍పీట పొయ్ ఉద్దుత్ అడ్డా ఆ మన్కన్ తోడవర్ ఇసా ఆగ్యసియ్ తెర్. ");
INSERT INTO nit_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","తే కరాబ్ ఇదర్ తరున్ అన్ విచార్కత్ గునా ఒక్కొద్ నాయ్ అమ్నున్ పొయ్ డొపేతన్. ");
INSERT INTO nit_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","గని ఇంమె మతం వాలడ్, తిక్ తా యేసుంద్ ఇనెకాద్ ఒక్కొనున్ వాలడ్ ఇమ్నడ్ ఔరున్ కొన్ని ఔరె ఔరుఙి ఇడ్డేకాద్ కన్కెదాది. ఆ యేసున్ బద్కుత్ అన్డదిసా పౌలు ఇడ్సనండద్. ");
INSERT INTO nit_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","అన్ అంటవ్ వదకత్ తా బదోల్ అన్టవి తీర్పు ఇడ్డేకదో ఒర్కితొసేట, యెరూసలేముంఙ్ సెత్ అత్తి ఇదవున్ వాలడ్ విచార్ కలెకద్ పౌలు ఏర్సద్దొ తనెదొ వేలుతోల్తెన్. ");
INSERT INTO nit_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","తె పౌలుఙ్‍, రొమ రాజూనె నిర్నయ్ వందూక్ తానుంఙ్ కయ్యెకదు ఇడెగ్గిసా ఇడ్డెకది కెయ్ తెర్సాది రోమా రాజూ నత్తిఎత్ కదిపెకద్ ఎంద్ కయ్యెకదుఙ్ ఇడ్డెంఙ్ ఇసా ఆగ్యసియ్ తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","అదుగ్గీ అగ్రిప్ప, “ఆ మన్కుకుఙ్ సుమ్తెకద్ అనుగినా వినెక్ అండ్డాద్” ఇంతెంద్ అదూక్ పేస్తు, “వెగెడ్ వినెగెరద్” ఇసా ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","మరొక్కొదిన్ అగ్రిప్ప, బెర్నీకే ఎంతెయొ సొక్ కత్ వత్, సైనికాదిపతులతొ, పట్న పురప్రముకులత, అదికార్ మందిరుత్ సెరెకద్ ఎద్దిన్ మల్ల పేస్తు ఆగ్యపొయ్ పౌలున్ తోడవ్తెద్. ");
INSERT INTO nit_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","అపుడ్ పేస్తు, “అగ్రిప్ప రాజక్, ఇత్తి అనెకద్ సమస్త పుజలారా, మీర్ ఈ మన్కకున్ ఓల్సనంసార్ తా. యెరూసలేముంఙ్ ఇత్తి యూదుసీమ్మనా నీర్ ఇంకా బత్కెంఙ్ తోద్ ఇసా వపొయ్తెంద్ నెస్తు అమ్నుఙ్ విరోద్కల్సా అనుంఙ్ జులుమ్ కఇదర్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","గని ఇమ్‌దు తికెకదుంఙ్ ఎరెకపని ఎద్ది ఇదరెతెంద్ ఇసా అన్ విచార్కతెంద్. గని ఇమ్‌దు రోమా రాజూముండట్ ఇడ్సతుం ఇసా ఇనేఙ ఇంముంఙ్ అత్తినీ పవిడెకద్ నిర్నయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","గని ఇమ్నుఙ్ ఉద్దుత్ రోమా రాజక్ వాయెకద్ అనుంఙ్ కరెత గున కన్కెరెతిన్. అదుఎత్తి నేరం వాలడ్ వెల్తొతదున్ ఎద్దిన్ మల్లా వాయెకద్ ఎద్దెన అనుంఙ్ రొంబడెకయెద్ ఇముంఙ్ సీంమనయ్ ముదరవయ్, మల్ల ప్రత్యేకత్ అగ్రిప్ప రాజా ఇమ్మె ముండట్ ఇమ్ముంఙ్ వర్గత్ తాన్. ");
INSERT INTO nit_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","జెలర్ పొయ్ తాప్త కెస్లున్ విచార్కల్సెటా అమ్ముంఙ్ పవిడెకద్ సోయ్ దొదిసా ఉద్దెసం” ఈసా ఔరత్తదున్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","అపుడ్ అగ్రిప్ప రాజకుఙ్‍ పౌలున్ వెంట, “ఇన్నెత్ ఇడ్డెకాద్ ఎద్ ఏందొ ఇండి ఇడ్డెంఙ్ వంద్!” ఇసా ఇంతెంద్. పౌలు తన్నె కెయ్యులెత్తుత్, అన్నె నిర్దొసిన్ ఇడ్డెంఙ్ ఈ విదనాడ్ మొదలిట్టన్. ");
INSERT INTO nit_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","అగ్రిప్ప రాజక్! ఇంద్ రాజక్ ఇమున్ ముండట్ ఇల్లుత్ యూదు అన్ పొయ్ గునలున్ వాలడ్ ఇనేడ్ అనేత్ అని ఇదరుత్నేరలున్ బాగ్యి ఇసారుజువు కలేంఙ్ ఇసా అవసం కలెకాద్ అన్నె అద్రుస్టం. ");
INSERT INTO nit_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","ఇముంఙ్ యూదు వెంట, ఔరె అచరలాడ్, ఔర్ అడ్గెకా నియమలెంఙ్ గుల్ ఒర్కి అండిన్ అదుహెత్తి ఈద్ కరెయ్ అన్నెత్ కిస్మత్. అన్ ఇడ్డెకద్ ఇముంఙ్ సాంతినడ్ వినేఇస జులుమ్ కల్సనంసత్. ");
INSERT INTO nit_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","అన్ సిన్మంతన ఎవిదానడ్ పానంతనొ యూదుసిమ్మఙ్ ఒర్కి. అన్నెసోత దెసెముత్ ఎద్దద్ న బాల్యం మొదలిడుత్ యెరూసలేముత్ ఎద్దగట్న ఎద్దద్ సిమ్కన ఔరుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","ఔర్ అన్ ఎన్నిగొ సాల్కు నమ్సతున్. అన్, నేండె జాతి తన పక్క పరుసిక్ నెరయుత్ అనుసర్ కత్ బత్కుతన్ ఇసా ఔరుంఙ్ ఒర్కి. పజెఇసా ఇంతె అవ్రి ఇదా నియమలున్ సాక్సం ఇడ్సార్. ");
INSERT INTO nit_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","దెయ్యం నేండె తోలెనితర్ ఇదర్త వాగ్దానమున్ అనుంఙ్ ఆస అన్సాద్. అదుంఙ్ ఎత్తి అన్ ఈ దినం ఈ దోసీ ఇదరెకాద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","నేండె నెడే పన్నెండు గోత్రలర్ ఔర్ సింత్తే తొల్లి దెయ్యమున్ పుజ కల్స అమ్మనే వాగ్దంమున్ సుమ్మతున్ ఇసా ఎదుర్ ఓల్సా నన్సార్. ఒ రాజక్! ఈ ఆస అన్ లోపా యూదు అన్ గున కతాద్ పరిగన్స నన్సార్. ");
INSERT INTO nit_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","దెయ్యం తిగ్తల్లున్ బత్కిప్సాంద్. ఇద్ సత్తెమున్ నీర్ తనుంఙ్ తోద్ ఇసాతిర్? ");
INSERT INTO nit_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“ఒక్కపుడ్ అన్ గినా నజరేత్ బత్కెకరున్ యేసునె పేర్ తోసెట ఇదరెకాద్ అన్నె రగ్గున్ సొసిపెంఙ్ సలెన్. ");
INSERT INTO nit_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","అన్ యెరూసలేముత్ ఇదర్ తాద్ అద్ది. దొడా దెయ్యలకేర్ సియ్ తా అదికార్ డ్ అన్ గుల్ మందిన్ దేయ్యంనె ప్రజాలు పవిత్ర జేలుత్ తప్తాన్. ఔరున్ అల్ఙెంఙ్ హక్ గినా సితన్. ");
INSERT INTO nit_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","ఎన్నిగుసాల్ అన్ యూదులె సావ్డిత్ సెత్ ఔరుంఙ్ దుసన్ సియ్తన్. ఔరడ్ బలవంతమడ్ యేసున్ దుసింప ఇదర్తన్. పిచ్చి రగ్గడ్ మరొక్కొ పట్నలున్ గినా సెత్నా ఆ మార్గమున్ నమ్మెకర్ ఔరున్ హింసించను. ");
INSERT INTO nit_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“ఒక్కొ దినం అన్, దొడా దెయ్యలకేర్ అదికార్ డ్, అన్నె మూతినాడ్ దమస్కుంఙ్ పట్నము సెసానంన్సాత్. ");
INSERT INTO nit_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","రాజక్ పతె పన్నెండు గంటలుంఙ్‍, అన్ పవుత్ అనెఙ ఆబార్ తన ఒక్కొద్ దండి వెలుఙ్ వరెకాద్ కన్కెత్. ఆ వెలుఙ్ పొద్దుంఙ్ ఎనా ఇంకా జోరనాట్ వలుంఙ్ అడ్ వత్ అన్ పొయ్ అన్నత్తి అనెకర్ అవ్రత్తి గినా ఉర్క్తిన్ ప్రాకసం ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","అమ్ సిమ్కన బూమిత్ ఉర్క్తమ్. ఒక్కొ లెంఙ్ హీబ్రు గొట్టినాడ్ అన్నాడ్ ఇనంఙ్ ఇనెఙ వింతన్. సౌల! సౌల అన్ తనుంఙ్ హింసకల్సాత్ ఇంతివ్? ఇనంఙ్ ఇదరెకదున్ వాలడ్ ఇనుఙి నాస్టం రొంబాడద్.” కోద్దా తనే కట్తా రడున్ తడ్తేంతే ఇమ్మేత్ నిరీ మెనున్ లాగ్పతేతి తనుంఙ్ ఒయ్గల్సతివ్ ");
INSERT INTO nit_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“ప్రబువు ఇనంఙ్ బహబ్ సితేంద్ అన్, ‘నీర్ ఎర్ ప్రబు’ ఇసా వెల్తన్. ‘అన్ నివ్ హింసకల్స యేసున్’ ఇసా ప్రబునె ఉత్తర్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","తే సులుత్ ఇల్, ఇన్ అన్నె సేవకున్ లంఙ్ నిర్నయం కలెంఙ్ ఇసా ఇంతన్. అన్ ఓల్త ఇద్ కబుర్ వాలడ్, అన్ సేవకేర్ లాన్, సాక్సిలంఙ్ ఇముంఙ్ కన్కెద్దెద్ ఇడ్డెకాదున్ బట్టి మరొలొరుంఙ్ ఇడ్డెంఙ్ ఇన్ నిర్నయ్ కలెంఙ్ ఇసా ఇనుంఙ్ కన్కెద్దన్. ");
INSERT INTO nit_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ఇన్ ఇన్ వాలాడ్, యూదులేన యూదులెర్సెటర్ ఔర్తన బత్కిప్సాత్. ");
INSERT INTO nit_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","ఔరె కండ్లు ఓల్ గాత్ ఔరున్ సిర్మనా తన వెలుఙుంఙ్ సైతన్ వరెంఙ్ ఇన్ పనుక్సానన్సాత్. ఔర్ అన్ విస్వాస్ ఇడుత్ తమ్మె పాపులున్ మాప్, పవిత్ర ఇసా, దెయ్యం ఆస్తరున్ కలపుత్ తమే జగ రొంబడెంఙ్ ఇసా ఇనంఙ్ కల్సాన్సాత్.” ");
INSERT INTO nit_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","అదుంఙ్ వాలడ్ అగ్రిప్ప రాజక్! పరలొకంతన వత్త ఆ దర్సనమున్ అన్ ఒప్‍సెట అనెంఙ సలెతన్. ");
INSERT INTO nit_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","పేలె దమస్కుంఙ్‍, యెరూసలేమ్, యూదలే దేసెం సిమ్కన, అద్ అద్ద వేనుకత్ యూదులెర్సెటర్, ఔర్ మర్ మనస్సు సుమ్ముత్ దెయ్యమున్వై తిర్గుత్ మరూ మన్ బద్లిపుర్ కార్య ఇదరెంఙ్ ఇడ్సా నంసతున్. ");
INSERT INTO nit_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","ఇదా కార్య వాలడ్ యూదు అన్ దెయ్యమ్నె మందిరుంత్ సుమ్ముత్ అల్ఙెంఙ్ కోసీద్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","“ఎనగని అన్ దెయ్యమ్నె మదతడ్ ఈ దినమ్ దూక్ ఇలుత్ అండత్. ఇమ్మున్ ప్రవక్తక్ మోసే ముండట్ సాక్సంగా ఇమ్మె ముండట్ ఇల్సాతున్ ");
INSERT INTO nit_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","క్రీస్తునె హింసలున్ సుముత్ తిక్ తార్ బత్కసార్ పేలెతద్ ఎద్దదుంఙ్ వాలడ్, యూదులుంఙ్ యూదు లెర్సెటరుంఙ్ రక్సన వెలంఙ్ సియ్సాద్.” ");
INSERT INTO nit_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","అముదు ఇదుంఙ్ వాలడ్ సమాదానం ఇడ్సననేగా పేస్తు, “పౌలు వసిపుత్ పిసాకున్ ఎద్ది” ఇసా జోరకత్ వపొయ్తంద్. ");
INSERT INTO nit_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","అదుంఙ్ ఏత్తి పౌలు ఇనంఙ్ ఇంతెంద్, “దండి పేస్తు, అన్ పిసాకనన్ ఎరెన్. అన్‍ సత్తెం, కరేతవి గొట్టిక్ ఇడ్సానండాత్. ");
INSERT INTO nit_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","రాజక్ కుంన్ ఈద బదోల్ ఒర్కి అదుంఙ్ ఎత్తి అవరున్ ముండట్ అన్ దయ్రమాడ్ ముడ్సనండాతున్. అదలత్తి ప్రతి ఒక్కొ గొట్టిన్ ఔరుంఙ్ ఒర్కి ఇసా కారె నమ్సాతున్. తానుంఙ్ ఇంతె ఇద్ ఎద్దొ ఒర్కి తొసేట జర్గిల్త విసయ ఏరెద్. ");
INSERT INTO nit_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","అగ్రిప్ప రాజక్, నీర్ ప్రవక్త లున్ నమ్సాతిర? నమ్సాతిర్ ఇసా అనుంఙ్ ఒర్కి.” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","అదుంఙ్ ఏత్తి అగ్రిప్ప, “ఇంతే సస్తె అన్ క్రీస్తున్ నమెకద్లంఙ్ ఓల్సాతి” ఇసా పౌలు నత్తి ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","అదుంఙ్ తె పౌలు, “సస్తెయొ కస్టమాడో, నీర్ మాత్రమ్ తోద్, ఇనేడ్ అన్నె గొట్టిక్ వినేకార్ నీర్ సిమ్కన ఈ సంకెల తప్ప అన్ లంఙ్ అనేంఙ్ ఇసా దెయ్యముంఙ్ అన్నె పార్తన” ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","అపుడ్ రాజక్, పేస్తూ, బెర్నీకే, ఔరడ్ గిన ఉద్ తార్ సులుత్ పకంఙ్ సేత్. ");
INSERT INTO nit_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","“ఇ మన్కక్ తిక్కెంఙ్ ఎనా, జేలుత్ పేన అనెక ఇసా” తమ్మెత్ తమి ముట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","అపుడ్ అగ్రిప్ప, “ఈ మన్కక్ రొమ రాజక్ అన్ ముండాట్ ఇడ్సాత్ ఇసా ఇనేంఙ్ తెద్తె అనెకాంద్ ఇమ్నున్ సయ్సెటంద్” ఇసా పేస్తునాడ్ ఇడ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","ఆమ్ ఇటలీంఙ్ రూకుత్ సెరెకద్ కాలెంఙ్ ఇసా అదికారుల్ నిర్నయ్ కత్ పౌలున్, మరొక్కొ కైదికున్ “యూలి” ఇనెకాంద్ పేర్తంద్ సతాదిపాతిన్ సియ్తెర్. మరొక్కొ రోమా రాజూ సైనిక్లె దొడంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","అమ్ ఆసియ రూక్ పకంఙ్ సెరెంఙ్ తయరెర్స ననెంఙ్ హ అద్రముత్తియ ఇనెక రుకూత్ ఉద్దుత్ సెరెంఙ్ ఎద్దం. మాసిదోనియ ఎరియూ తెస్సలొకతద్ మెరతా అరిస్ అరిస్తార్కు ఇనెకాంద్ వెంటా అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","మరొక్కొ దినం సీదోనున్ గాదియ్ తామ్. యూలి, పౌలు తన్నె దొస్తకెరున్ కాలయుత్ మదాత్ కలెకార్ లాంఙ్ అమ్నుంఙ్ నాయ్ గాత్ అమ్నున్ పొయ్ దతతయా ఓలిప్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","అత్తరనా కురియుత్ రుకూత్ సెరెకరం ఎద్దామ్. అడ్డామ్ గాలి వాత్. అదున్ వాలడ్ సైప్రసు దక్సిన్నంలాంఙ్ గాలి సుర్గాడం ఈర్ లోపా సెరెంఙ్ ఎద్దాం. ");
INSERT INTO nit_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","కిలికియ, పంపూలియలుంఙ్ మెర అనెకా సందూర్ పొయ్ సెరెంఙ్ ఎర్సా “లుకియ” బార్సత్‍ అనెకర్ “మూర” ఇనెక పాట్నముంఙ్ గాదియ్ తామ్. ");
INSERT INTO nit_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","అమున్ వెంటా అనెకర్ సైనిక్లె దొడంద్ ఇటలీకి సెసాత్ “అలెగ్జాండ్రియా” రూకుత్ ఓలుత్, అమున్ ఆ రుకూత్ సొకిప్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","అడ్డమి గాలి వర్సాననేకాదున్ వాలడ్ గుల్ పేలె దినాలుంఙ్ ఎత్ నెయర్ సెరెకాద్ ఎద్దిన్. గుల్ కాటినాడ్ క్నీదుకు మెరం గాదియ్ తామ్. అడ్డాం గాలిన్ వాలడ్ ముదార్వై సెరెంఙ్ సాలె తామ్ అదుంఙ్ వాలడ్ దక్సినాంవై సెత్ “క్రేతు” దీవెన్ అడ్డామి ఇడుత్ సల్మోనే మెరా రుక్ అడిగీంప్తం. ");
INSERT INTO nit_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","ఆ ఇరున్ అమ్మెత్ సెరెకాద్ కస్టమ్ ఎద్దిన్. ఎద్దెక్కద్ విదనామడ్ “సోయ్త రేవూ” ఇనెక జాగలెంఙ్ గదియ్ తామ్. ఈ మెరం లసైయ ఇనెక పట్నముంఙ్ మెరమ అన్సాంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","అపుడి ఎన్నిగొ కాల వ్రుదాం అద్దిన్. గని ప్రయనం కలెకాద్ ప్రమాదకారం ఎద్దిన్. ఉపాస్ దినం ఇదారెక దినం గినా విడుత్న. ఎదుంఙ్ ఎత్తి పౌలు ఔరున్ ఉసరడండ్రు ఇసా ఇడ్సా. ");
INSERT INTO nit_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“దాదకేరరా! ఈ సెరెకత్తి నేడుంఙ్ తక్లిబు వర్సావ్ ఇసా అనుంఙ్ అనంఙ్ కారిల్సా నన్సాద్. రూకుత్, సరుకున్ తక్లిబ్ ఎరెకాది తోసెటా నేండె పానముంఙ్ గునా ప్రమనం ఎరెంఙ్ వంద్!” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","గని ఆ సైనిక్లె దొడంద్ గని పౌలునె గొట్టిక్ విన్సెటా కబుల ఆ రుక్నె మల్కాక్ గొట్టిక్, రుక్ మల్కనె గొట్టిక్ వింతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","అనంఙ్ ఎద్దె పని కాలం అనెకదుంఙ్ పనిసియ్యెంద్. అదుఎత్తి ఎంతెయొ మంది సెరెంఙ్ ఎర్ ఇసా సల్లా సితెంద్. టండి కాలం గడ్పెంఙ్ “పిలిక్సు” ఇనెక రేవు గదిసాతుమ్ ఇసా సిమ్కన అసాకత్తెర్. ఈ పినుక్సు రేవు క్రేతు దీవెత్ అన్సాంద్. మెట్ పకంఙ్ పేని పకంఙ్ నడుమ్ అనెకా దేసం తన మాత్రమె ఆ రేవున్ సెరెకాదుంఙ్ టైమ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","దక్సిన గని వరెంఙ్ హ తదుకున్ తజెఅంతె రొబటిన్ ఇసా అవ్రింతెర్. ఇన్మి లంగరెత్తి, రుకూన్ క్రేతు తీరం పకంఙ్ అడిగిప్సా సెరెకాద్ ఎత్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","అంతెతి, పొద్కురియ్ పొద్పడ్నగాలి ఇనెకా జోరనాడ్ క్రేతు దీవెన్ పొయ్ వరేకద్ మొదల్లెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","రుక్ ఆ సురగాలి తోడసెద్దిన్. అడ్డామ్ గాలిన్ వాలడ్ అమ్మె రుక్ ముదర్వై సెరెంఙ్ సలెతిన్. అమ్ తనయ్ గలెంఙ్ సాలెమ్. గాలి వరెకవై అమ్మె రూకున్ తోడసెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","“మల్ల కౌద” ఇనేకద్ సిన్నం దీవె అడ్డామి ఇడుత్ అదున్ మెరనాడ్ సెరెంఙ్ ఎద్దెర్. రూకుత్ నారనడ్‍ కట్తమ్ రూకున్ పని పడెద్ తక్లిబాడ్ బత్కిప్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","అదున్ రుక్ పొయ్ సొకిప్త వెన్కత్ నరన్ ఉడ్పుత్ రూకున్ సోయ్ అవరిపుత్ కట్టెర్. రుక్ “సూర్తిస” ప్రాతముత్ వారు తిప్ప పొయ్ సెసాద్ ఇసా అర్సుత్. అదుఎతి తెరకాపలున్ ఇకుత్ రూకున్ గాలి వరెక పకంఙ్ సెరెంఙ్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","మరొక్కొ దినం, సురగాలి జోరనట్ వరెకదున్ వాలడ్ రూకుత్ అనెక సమ్నలున్ సమ్‍దురుత్ జొపిడ్సార్. ");
INSERT INTO nit_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ముది దీన ఎద్దత్తి రూక్ వడెకా పనిత సమన్లు గినా సమ్‍దురుత్ జొపిడెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","పొద్ ఎన్‍ తొత్తె, నేల ఎన్‍ గని కోన్నిదినాలుంఙ్ ఎంత్ కండ్కెరెతిన్. సురగాలి ఒక్కొది మట్ కమ్మి ఎరెతిన్. అమ్ బత్కుమ్ ఇన్నెక ఆసన్ సాయ్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","గుల్ దినా తన ఔర్ అంబా తినెతెర్. పౌలు ఔరున్ నాడ్ము ఇల్లుత్, “అన్నె సల్లాన్ అడిగిపుర్ నిఎ క్రేతు తన సెరెంఙ్ తయార్ కల్సెటా, అనెకద్ ఎరద్. అనంఙ్ కత్ అండె సోయ్ ఎనా కరద్ ఎన రొంబడెకాద్ ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","గని, పఙ్ఙి ఇమున్ ఒక్కొ ఇసాతున్. దైర్యమడ్ అనెకాద్ ఇమ్మత్తి ఒక్కొనేత్ గిన పానం సెరెద్. గని రూక్ కరాబెద్దా. ");
INSERT INTO nit_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","అన్ ఎరుంఙి గదియెనొ, ఎరె సేవా కల్స నన్సాతొ దెయ్యమ్నె దూత్ ఇన్ సింతె అన్ మెరం ఇల్లుత్ ఇనంఙ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘పౌలు! అర్సనెం, విచార్ వెంట పడ్నెమ్ నివ్ రొమ రాజూ ముండట్ ఇల్లతివ్ దెయ్యం దయకత్, ఇనుంఙ్ సటీ ఇన్ వెంట్ వరెకారన్ ఎద్దన్ ఔర్ పనలున్ బత్కిప్తెర్.’ ");
INSERT INTO nit_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","అదుంఙ్ ఎతి దదాకేలరా! దైర్యమడ్ అడ్రు. అనుంఙ్ దెయ్యం పొయ్ బరొస అన్సాద్. అముదు ఇడ్ తాది ఎరద్. ");
INSERT INTO nit_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","నేండ్ జల్దిని నేండ్ ఒక్కొ దీవెన్ తోడసెరతుమ్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","చౌద దినాలుంఙ్ సింతె గిన అమింక అద్రియ సమ్‍దురుంఙ్ గాలింఙ్ తోడ సెరకరమ్ ఎరతుమ్ అందెజ సర్సం అలే రుక్ వాలె బూమి మెరం వత్తిన్ ఇసా ఆదికత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","అప్పుడ్ ఇనుమ్ గుండున్ నర కటుత్నూ నూట ఈర్వె దాపిక్‍ ఈర్లోపా తప్పుత్ జమటినాడ్ ఎద్ద వెన్కత్ పెన నొవద్‍ దాపిక్‍ బూడున్ ఈర్లోపా తప్పుత్ గుల్ వెకం గుండివై సుమ్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","అప్పుడ్ సింత్తె తిపపడ్సరెర ఇసా అర్సుత్న, ఔరు రుక్ వెన్కా వలడ్ నాలి లంగర్లు తప్తెర్. పాతే వరెంఙ్ ఇసా పార్తన అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","అన్నె రుక్ ముందర్వాలడ్ లంగర్లున్ ఈర్ బూడున్ సయెకర్లంఙ్ టక్కిప్తెర్ రూకుత్ కట్తద్ సిన్నం రూకున్ సమ్‍దురుత్ డింపతెర్. సుకడిపుత్ ఔరెత్ అవ్రి ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","అపుడ్ పౌలు సైనిక్లె దొడంద్, సైనిక్లున్, “ఈ రుక్ వలెనె రూకుత్ అండె కరాబా నీర్ బత్కెకర్ ఎరతిర్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","ఇదున్ వత్ సైనికు రూకున్ నారలడ్ కట్టుత్ వెన్కత్ తర్గుత్ ఆ రూకున్ ఈర్వై సెరెంఙ్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","పొద్కుర్యెంఙ్ పేలె పౌలు ఔర్సిమ్మనని అలే ఎంద్ ఇసా ఇడ్సా, “గడిల్త చౌద దినా నీర్ అంబా పుడ్సెటా బక్తిర్. తనెద్ ఎద్దినొ ఇముంఙ్ ఒర్కి తోద్. అముదు వింతి కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","ఇండి ఇమున్ కొన్సెం తిన్ ఇసా వింతి కద్దున్ ఇమున్ బత్కిపెంఙ్ ఇంతె తినెకాద్ రక్స. ఇమ్మె తల్తన ఒక్కొ తిర్ గిన ఉర్కెద్” ఇసా ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","జిఙ్ఙా అనంఙ్ ఇడ్డెఙా అముదు నిపట్టెన్ సుమ్ముత్ దెయ్యమున్ సిమ్న మందిన్ ముండట్ దన్యావద్ సియ్యుత్ అత్తరన్ ఒక్కొ తుక్డె ఇదరుత్ వినెంఙ్ మొదలిట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","అపుడ్ సిమ్కన ఇమత్ ఇడ్డుత్ అంబా కొత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","రూకుత్ అనెకర్ అమ్మె పాన సిమ్కన ఇందినూల్ సాత్తర్ ఆర్గుర్. ");
INSERT INTO nit_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","ఔర్ సిమ్కన పెట్టెనిండా తిందెర్. మల్ల రూకుత్ అనెక మిక్త మంది గొద్మలున్ జొపిడుత్ రూకున్ తెల్గాత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","పొద్కురితిన్. ఔరుంఙ్ బూమి కండ్కెద్దిన్. గని అదున్ ఒర్కిలెంఙ్ సలెతెర్. వరు అనెక డర్డి పకంఙ్ పాయ కండ్కెరెంఙ రూకున్ టైమండె అత్తి ఇల్ పెంఙ్ ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","నార తర్గుత్ లంగర్లున్ సందూర్ పకంఙ్ ఉర్కు గత్తెర్. తిర్గొర నార తిప్పుత్ రుక్నె ఒక్కొ పడ్దా ముదర్వై అనెక తడకన్ సులుత్ రూకున్ డర్డి పకంఙ్ కొస్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","గని ఆ రూక్ ఇరుత్ అండదుంఙ్ వారున్ తకుత్ బూమిత్ సిక్కుత్ సెద్దిన్. రూక్ ముందర్వాలడ్ వారుత్ సిక్కుత్ సెద్ద సటీంఙ్ ఆ రూక్ మెలగెతిన్. అలవ జోరనట్ లగపెక దున్ వాలడ్ వెన్కా పకంఙ్ తుక్డె లెద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","కైదిలున్ ఇద్ తుల్సెట అనెంఙ్ ఇసా ఉద్దెసంతొ సేలాకేర్ ఔరున్ అల్ఙేఙ్ ఇసా. ");
INSERT INTO nit_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","గని పౌలు పానమున్ బత్కిపెంఙ్ సల్సెట ఉద్దెసమడ్ ఆ రోమ సైనిక్లె దొడంద్ ఇదరెంఙ్ సలెకదున్ ఇదరెంఙ్ ఇడెతెంద్. ఈదెంఙ్‍ వరేకర్ ఈరుత్ ఉర్కుత్ డర్డిఙ్‍ సెరెంఙిసా, ");
INSERT INTO nit_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","మిగ్తరున్ రూక్నె సెక్కలె అదరడ్, రూక్ తా కురిత సెక్క లాడ్ గదియ్ తామ్. ఇనంఙ్ కల్సా సదర్ మంది బత్కిపెంఙ్ సాటి డర్డింఙ్ గదియ్ తామ్. ");
INSERT INTO nit_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","అమ్ సుకడిల్తమ్ ఆ దీవెన్ “మెలితే” అంటరమున్ ఒర్కిల్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","ఆ దిపుత్ బత్కెకర్ ఔర్ అమున్ పొయ్ గుల్ దయా ఓలిప్తెర్. అపుడ్ వాన వర్సనంద్. టండి గుల్ జోరనట్ అండిన్. ఔర్ పని వరెంఙ్ ఆ కిస్ ఎర్కుత్ అమున్ గిన వర్ ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","పౌలు సివ్వలున్ మిరపుత్ ఆ మొపున్ కిస్ పొయ్ ఇట్టెన్. ఆ సివ్వల మొప్ తన ఒక్కొ పామ్ ఆ వెడిన్ అనెఙ సల్సెట కిస తన వకా కురితిన్, పౌల్నె కెయ్యున్ కొర్కుత్నా అద్నె పల్కులాడ్ సుంమ్తిన్. ");
INSERT INTO nit_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","ఆద్దీ వేలంఙ్ బత్కెకర్ పౌలునె కెయ్యుత్ పామ్ వ్రెలడ్స అనెఙ ఓలుత్ ఔరెత్ అవ్రి, “ఇంద్ ఒక్కొ తాకత్ తంద్ ఎనా ఎద్దన్! సందూర్ తన గెల్తెంద్ గని, దెయ్యం అమ్మున్ బత్కెంఙ్ ఇడెతిన్” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","గని పౌలు, ఆ పామున్ కిస్ పకంఙ్ జడప్తెర్. అమ్నుంఙ్ తనయ్ తక్లిబ్ ఎరెతిన్. ");
INSERT INTO nit_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ఔర్ అమ్నె సరిరం మురుగ్స నన్సదొ, తొత్తె గుల్ తక్లిబాడ్ తిక్సదొ ఇంత్ గుల్ పెరెత్ గాడి కయ్సానన్నెర్. అమ్నుంఙ్ ఎ తక్లిబ్ తోసెటపుడ్ ఒర్కిలుత్, ఔర్ తమ్మె మనుస్సున్ బద్లిపుత్, “అముదు ఒక్కొ దెయ్యం” ఇసా ఇంతెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ఆ పకంఙ్ తా కేండ్లు “పొప్లి” ఇనెక పేర్తంద్ అమ్నత్తి గదితిన్. పొప్లి ఆ దీవెంఙ్ అదికారి. అముదు అమున్ అమ్నె ఎల్లంఙ్ ఆహ్వాన్ ఇడుత్ మూపి దినాలుంఙ్ ఎంత్ సుట్టమున్ మాన్ ఇదర్ తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","పొప్లినె బాంద్ వేస్సనాడ్, సీమ్ నెత్తుర్ చాల్లతేర్ తేరున్ సుమ్ముత్ అండాంద్. పౌలు అమ్నున్ ఓలెంఙ్ సెద్దెంద్. దెయ్యమున్ పార్తన కత్ పౌలు అమ్నె కెయ్యులున్ అమ్నె తల్ పొయ్ ఇట్టెంద్. వెంటని అమ్నుంఙ్ నాయం ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","ఈ విదమాడ్ జర్గిల్త వెన్కత్ ఆ దీవెత్ అనెకా మిక్త రొగులున్ గినా వత్తెర్. ఔర్ గినా సోయ్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ఆ దీవెత్ బత్కెకర్ అమున్ ఎన్నిగొ విదాలడ్ మాన్ సియ్యుత్ అమ్ సెరెంఙ్ పేలె అముంఙ్ పాజె అంతె ఇమ్మత్ సితెంద్. ");
INSERT INTO nit_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","టండి దినాలుంఙ్ ఆ దీవెత్ అంత్ అలెగ్జాండ్రియా సెద్ద ఒక్కొ రూకుత్ మూదీ నేల ఎద్ద వెన్కత్ సెరెంఙ్ ఎద్దం. అద్ నగరమ మెరత రూకుత్. దాని పేరు “నెమకే దెయ్యం ఒర్కి తా.” ");
INSERT INTO nit_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","అమ్ “సురకూసై” ఇనెక పట్నముంఙ్ గదియ్తమ్. సురకూస్ అమ్ మూది దినాలుంఙ్‍, ");
INSERT INTO nit_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","అత్రనట కురియుత్ అమ్ రేగియ నగరముంఙ్ వత్తం. మరొక్కొ దినం గుడ్డి సురగాలి ఎదుర్ వత్తతి అమ్ సెరెకరం ఎద్దం. ఇది దినం తర్వత అమ్ పొతియొలీ నగరముంఙ్ గదియ్ తామ్. ");
INSERT INTO nit_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","అత్తి అనెకర్ దాదకేర్ కొన్సెం మందిన్ కలయ్ తామ్. ఔర్ అమున్ మాన్ ఇడుత్ అంతి ఒక్కొ వారం అండ్రు ఇసా వింతి కత్తెర్. ఇనంఙ్ కల్సా రోముంఙ్ గాదియ్తమ్. ");
INSERT INTO nit_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","రోముత్ అనెకర్ దాదకేర్ అమ్ వర్సాతుమ్ ఇసా వింతిర్. అమున్ కాలయెంఙ్ సటీ ఔర్ అప్పీయా అఙడి పటనం ఆలపుసేక ముది జగలకెర్ కలయ్తెర్ ఇనేక అప్పుడ్ పౌలు దెయ్యముంఙ్ దన్యావద్ ఇడ్తెంద్. అమ్నుంఙ్ దైర్యం రొబాటిన్. ");
INSERT INTO nit_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","అమ్ రోమ్ పట్నముంఙ్ గదియ్ తాత్తి పౌలున్ ఒక్కొత్తిని అన్ గత్తెర్. గని ఓ సైనికున్ అమ్నున్ జాగ్లి లాంఙ్ ఇట్టెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","మూది దిన తర్వత పౌలు యూదులె దొడలున్‍ కుగ్ గతెంద్. అంతెనా మిరయ్తత్తి పౌలు అవ్రడ్, అన్నె దాదకేర్! అన్ మందింఙ్‍, విరోద్దడ్ నేండె తోలెనితరె దెయ్యలకెరె విరోద్దడ్ అన్ ఎద్ది ఇదరెతెంద్. అముదు అన్ యెరూసలేముత్, కొడాపుత్ రోమా అదికారుంఙ్ సియతెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ఔర్ అన్ వేల్తోలెంఙ్. గని యూదు సొపరిప్దద్ తాద్ తిక్కెకాద్ రొబాడెంఙ్ వాంద్ అపరదం ఎద్ది అన్ ఇదరెంఙ్ సాలెంన్. అదుంఙ్ ఎతి అన్ ఎడలెంఙ్ సాలెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","గని, యూదు అడ్డం ఇడ్తపుడ్ అన్ రొమ రాజు ముడట్ ఇడ్సాత్ ఇనెకద్ ఎదిన్. అన్నె పొయ్ నేరం జొపిడెంఙ్ ఇసా అన్నె విసర్ తొతెద్. ");
INSERT INTO nit_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","ఈ కరముంఙ్ అన్ ఇమున్ ఓలుత్ ముడెంఙ్ ఇసా కుగ్గత్తన్. ఇస్రాయేల్ అనెకా మంది అనెకా ఆసంఙ్ సటీ అన్ ఈ సంకెలలడ్ అన్ కట్తెర్ ఔరుంఙ్ వింతి కత్తెంద్. ");
INSERT INTO nit_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","అదుంఙ్ ఎత్తి ఆ బార్సత్‍ ఔర్ ఈ యూదు దాదకేర్ వాలడ్ ఏ సమచరం ఇడ్డెతెర్. కరాబ్‍లాంఙ్ ముడెతెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","అనంఙ్ ఎరత్తె అని ప్రతములెంఙ్ ఔర్ ఈ మతమున్ వాలడ్ విరోద్ ముడ్సాన్సార్ ఇసా అముంఙ్ ఒర్కిఇసా ఇంతెర్. అదుంద్ ఎత్తి ఇదున్ వాలడ్ నీర్ గ్యాన్ ఇసాతిరొ వినెంఙ్ ఇసా అండాద్. ");
INSERT INTO nit_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","పౌలున్ కాలయెంఙ్ ఇసా ఔర్ ఒక్కొ దినం నిర్నాయ్ కత్తెర్. ఆ దినముంఙ్ తొలిని అముదు అనెక జాగంఙ్ ఎక్వా మంది పౌలున్ తొల్లిన్ తన సింతె దూక్ ఔరున్ వెంటా ముడుత్, దెయ్యమ్నె రాజ్యముంఙ్ వాలడ్ ఇడ్సా ఇడ్తెంద్. మోసే నియంసాస్త్రం తన, ప్రవక్త లె వాయ్తద్ తన ఉదాహరనా సుమ్ముత్, యేసున్ గురించి వెల్‍త్తెర్ ఔరున్ ఇదరుత్ ఇడ్డెంఙ్ సటీ కోసిద్ కత్తెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","అముదు ఇడ్ తాద్ కొన్సెం మందింఙ్ బరొస తోతె. కొన్సెం మంది నమకం తోతెద్. ");
INSERT INTO nit_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ఔరడ్ ఔరున్ బెత్‍ బావు వరెకాదున్ వాలడ్ ఔర్ సెరెంఙ్ మొదలిట్టెర్. పౌలు ఈ ఆక్రింఙ్ గొట్టిక్ ఇడ్డెంఙ్ మొదలిట్టెంద్. “పరిసుద్దాత్మ ఇమ్మె తొల్లిని తార్ పొయ్ వరెంఙ్ యెసయకున్ వాలడ్ ఇనంఙ్ ఇడ్ కరేతది: ");
INSERT INTO nit_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘కోసెం మందిన్ ముండట్ ఇనంఙ్ ఇడ్. నీర్ ఎప్పుడి విసా నన్సాతిరా. గని సొమ్కన్‍ గొట్టికున్ అర్తం కాలె! నీర్ అని వెలలున్ ఓల్సనంసతిర్. గని ఎపుడి అర్తం కాలెర్. ");
INSERT INTO nit_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","ఔర్ కడ్లడ్ ఓలుత్న, కెవ్వులెత్తుత్ మాన్ నాడ్ వింనుత్ అర్తం కత్ అన్ పొయ్ మల్లినాడ్ ఔరున్ నాయం కాల్సాతున్. గని అనంఙ్ ఎరెంఙ్ తోద్ ఇసా ఈ మందినె మన్నుత్ పేలె పేలెని బారాయి. ఔరుంఙ్ గుల్ విన్కిప్తెంద్. ఔర్ అమ్మె కండ్లున్ ముంస్‍తెర్.’” ");
INSERT INTO nit_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","అదుంఙ్ ఎత్తి దెయ్యమున్ వాలడ్ ఈ రక్సన అది ఇడుత్. యూదు ఏర్సటరున్ వై పన్కెకద్ ఎదిన్ ఇసా నిర్ ఒర్కిలుర్. ఔరు విసార్. ");
INSERT INTO nit_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ఔర్ అదున్ విన్నెర్ కొన్ని కొత్త ప్రనిక్ లెంఙ్ బాత్కిపెకాదుంఙ్ సటీ ఈ గొట్టిన్ యూదు తమెత్ తమ్మి దక్కన ఎత్న సెదెర్ అని. ");
INSERT INTO nit_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","పౌలు ఇందీసంవత్సర తన్నె కిరయాడ్ సుంత ఎల్లాత్ బాత్కుతెంద్. అదున్ ఓలెంఙ్ ఇసా వత్తర్ ఔర్ సిమ్కనంఙ్ స్వగాత్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ఎదుని అర్సెట దైరమాడ్, దెయ్యంన్నె రాజ్యముంఙ్ సటీ ఇడ్డుత్, యేసు క్రీస్తు ప్రబున్ గురించి ఇడ్నెర్.");
INSERT INTO nit_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","యేసు క్రీస్తుంద్ సేవక్, అపొస్తులున్ లంఙ్‍, దెయ్యమ్నె సువార్త కలేంఙ్ ఆసుత్ కూగ్‍త, పౌలున్ ప్రబుద్ కూగ్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","ఈ సొయ్త కబుర్ దెయ్యం తన్నె ప్రవక్తన్ వాలడ్ పేలెని పవిత్ర లేకనముత్ ఇడ్తెంద్ సావల్ ఇడ్‍సా వాయ్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ఇద్ సరీరమాడ్ దావిద్నె సంతనుంఙ్ పుట్త అన్నె పోరక్ ఇంత యేసు క్రీస్తుంద్. ");
INSERT INTO nit_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","దెయ్యం తన్నె కికే, నెడె ప్రబుంద్ ఇనెక యేసు క్రీస్తుంద్ ఆంద్ పరిసుద్దునె ఆత్మ తన యేసుంద్ తిక్తార్ బత్కసార్ వత్తపుడ్ దెయ్యమ్నె కీకెలంఙ్ ఇదార్తద్ నివ్డిపెకాద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","పుర దేసుల మందిన్‍ విస్వాస్ ఇడుత్ కబుల్‍కలెకదుంఙ్ వాలడ్ దెయ్యం అమ్నున్ వాలడ్ క్రీస్తుంఙ్ అపొస్తులంఙ్ అనెంఙ్ కృపన్ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","అముదు నేండ్ నిమిత్తడ్ అనిగ్నాయ్ జాతిక్లడ్ మంది విస్వాసుంఙ్ కలయుత్‍ యేసు క్రీస్తుంఙ్ వాలడ్ అమ్మె కిస్మత్, అపొస్తులమ్‍ ఎద్దమ్. ");
INSERT INTO nit_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","తే రోమాత్ అనెకర్ ఇముంఙ్ సిమ్కనంఙ్ దెయ్యమున్ వాలడ్ లాడ్త కృపత మన్కకెరున్ అనెకరుంఙ్ వాయ్సనండాతున్ నేండె బాంద్ ఎద్ద దెయ్యం తన ప్రబుంద్ ఇంత యేసు క్రీస్తుంద్ తన పవిత్ర సమాదనం రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","ఇమ్మె ఇస్వద్ దున్య సిమ్కన ఇడ్డెకదున్ ఓలుత్, పేలెతన ఇముంఙ్ సాదరున్ సటీ యేసు క్రీస్తున్ వాలడ్ అన్నె దెయ్యమున్ దన్యావద్ ఇడ్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","ఇమ్మున్ ఎన్ని గొల్లదొ అది కల్సనండతున్. అమ్నె పోరక్ గొట్టిఙ్ వాలడ్ అన్ అన్నె ఆత్మత్ సొఙెక దెయ్యమి ఇదుంఙ్ సాక్సం. ");
INSERT INTO nit_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ఎద్దొ ఒక్కొ విదమడ్ ఇమ్మతి వరెకదుఙ్ దెయ్యమ్నె చింత వాలడ్ అనుంఙ్ అదికార్ అండదెర ఇసా అన్నె పార్తన ఎప్పుడి అమ్మున్ కోసీద్ కలెకద్. ");
INSERT INTO nit_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","నీర్ గట్టిగ తయార్ఎర్, నీర్ అన్ ఒక్కొనె ఆత్మనడ్ ఒక్కొది అదర్ ఎరెకాద్ కృప వరమ్ సటీ ఇమున్ ఓలెఙ్ సంతి కొర్సనండాతున్. ");
INSERT INTO nit_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","నిర్ సొయ్ ఎరెంఙ్ ఇసా నిర్ అన్ కరె విస్వాసున్ వలడ్ ఒక్కొరం అదర్ ఎరెకదుంఙ్ సాటీ ఇమున్ ఒలెంఙ్ ఇసా ఇసతుమ్. అప్పుడ్ ఆత్మంఙ్ కల్యతద్ ఎద్ది ఎక్కద్ కృపా వరామున్ ఇముంఙ్ గదిపెంఙ్ ఇసా అన్నె అసా. ");
INSERT INTO nit_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","దాదకేర్, ఇద్ ఇముంఙ్ కరిలెంఙ్. యూదులెర్సెటర్ మరొక్కొ మన్కకెర్ నడుమ్ అన్ సుమ్‍త పరిచర్య పలాము ఇమున్ నడుము‍న్ సుమెంఙ్ ఇసా గుల్‍ పేలెగుసాల్ కోసీద్ కత్తన్ గని పఙ్ఙి దూక్ సాలెతని. ");
INSERT INTO nit_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","గ్రీకులుంఙ్‍, మరొక్కొరుంఙ్‍, తెలివి అనెకరుంఙ్‍, బుద్దిఅనెకరుంఙ్ అన్ కర్జెత్ అంసాత్. ");
INSERT INTO nit_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","అదుఙి రోములత్తి ఇముంఙ్ గిన సొయ్త కబుర్ తయార్ కలెకా అసానాడ్ అన్ తయార్ అన్సాతున్. ");
INSERT INTO nit_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","సొయ్త సువార్త బదోల్ అన్ లజ్జంఙ్ వరెన్. తానుంఙ్ ఇంతె యూదుంద్ ఎన్తెయో, గ్రీకు జాతి తంద్ బరొస అనెకద్ ప్రతి ఒక్కొద్ అది దెయ్యమ్నె రక్స. ");
INSERT INTO nit_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","నీతిమంతక్ విస్వాసమడ్ బత్కినెంద్, ఇసా వాయుత్ అనెకద్లాంఙ్ విస్వాస్ కలెంఙ్ కుబ్ విస్వాసం కలేకద్దాంఙ్ దెయ్యమ్నె నీతి అద్నత్తి వేలెఙ ఎర్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","ఎరేనా తమ్మె కరాబ్ నీతినాడ్ సత్తెం అడ్మంమ్ కల్సరొ ఔరె బక్తి పొయ్, కరాబ్ నీతిపొయ్ దెయ్యమ్నె రగ్ పరలోకం తనట్ సెరెకద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","తనుంఙ్ ఇంతె దెయ్యమున్ వాలడ్ కరప్తద్ సదర్ ఔరుఙ్ కన్కెర్సనండద్. దెయ్యమి అదున్ ఔరుఙ్ సెరెంఙ్ ఇట్టెంద్. ");
INSERT INTO nit_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ఇద్ దున్య గడిల్తతనట్, ఎప్పుడి అనేకా సక్తి, దైవత్వం ఇనెకా అముదు కన్కెర్‍సెటాద్ గినా సోయ్ అదవున్ చక్కన పరిక్స కత్తవాలడ్ తేట చక్కన ఎర్సద్. అదుఙి తమ్మెత్ తామి బద్లిపెంఙ్ అవకసం తోతెద్. ");
INSERT INTO nit_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","ఔరున్ దెయ్యమున్ ఒర్కిలుత్ కుల్ అమ్నున్ దేయ్యంలఙ్ మహిమ కలెతెంద్, దన్యావద్ ఇడ్డెతెంద్ గని తమ్మే విసరుత్ బుద్దిమంతకెర్ ఎద్దెర్. ఔర్ రికమి మనుత్ చిర్మచికటి ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","తమ్ ఉసార్ అనెకారమ్ ఇసా ఇడ్తెర్ గని ఔర్ బుద్దిఅనెకర్. ");
INSERT INTO nit_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","ఔర్ ఎప్పుడి తీర్సెటాద్ దెయ్యమ్నె మహిమన్. నసానం ఎరెకా మన్కకెర్, పిట్ట, నాలిఙ్ గెట్టల దపికున్, పుర్రెవ్ ఇనెక అదౌలే రూపలున్ సియ్తెర్. ");
INSERT INTO nit_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","ఇదుంఙ్ ఎత్తి ఔర్ తమ్మె మన్త కరబ్ ఆస వాలడ్, తమ్మె మెన్లున్ తమ్మెత్ తముంఙ్ కరాబ్ ఇంతెతిలఙ్ దెయ్యం ఔరున్ లైంగిక అపవిత్రన్ పవిట్టెర్. ");
INSERT INTO nit_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","ఔర్ దెయ్యమ్నె సత్తెం లబడున్ బద్లిపుత్, యుగయుగాలున్ స్తుతి యోగ్య దున్యగడిప్తాన్ బదులు దున్యన్ పుజకత్. ");
INSERT INTO nit_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","ఈ కారనుంఙ్ దెయ్యం ఔరున్ కామ్మి విచార్ సియ్‍తిన్. ఔరె పిల్లకున్ నాయ్ పేలె తా అల్‍వొటున్ సాయుత్న పని పడ్‍సెటావున్ అల్‍వొట్ పట్టెర్. ");
INSERT INTO nit_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","అనాయ్ మన్కకెర్‍ నై తముంఙ్ కరిల్‍తదున్ పిల్లక్ ఇదరెక నియమున్ సాయుత్న పడ్సిలడ్ పడ్సిల్ కలేకద్లాంఙ్ ఇదర్‍తెర్. అనాయ్ ఔరు తమ్మె సినాలి పనిక్లడ్‍ నిండ్ తార్ కరగ్‍తెర్ తమ్మె గలతులున్ లగ్‍త ప్రతి పలమ్ సుంతెంద్. ");
INSERT INTO nit_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ఔరె మనుత్ దైవిక్ గ్యానుంఙ్ జాగ తోతెద్. అదుంఙ్ ఎత్తి కలెకా పనిక్ ఔరడ్ కల్‍గలెకా కరాబ్‍ మనుంఙ్ దెయ్యమ్ ఔరుంఙ్ సోపిప్‍తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","ఔరు దున్యత వాయిట్ నీతినాడ్, కరాబ్, లొబ్, కరాబ్ పని, ఈర్స్య, అసూయ, కూన్, జగడ, మోసం, విరోద్ కలేకద్ ఇదవ్లడ్ నిండుత్ అంసార్. ");
INSERT INTO nit_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ఔరు సాడిక్ ఇడ్డెకర్, పైలి నింద కలెకర్, దెయ్యమున్ విరోద్ కలెకర్, పైలిక్, గర్వతొచెటా సోయ్తవున్ ఇడ్డెకర్, కరాబ్ పనిక్ కలెకదుంఙ్ రంగ్ రంత పవు ఇడ్డెకర్, అమ్మబనున్ ఎదుర్ ఇడ్డెకర్, బుద్ది తోసెటర్, ");
INSERT INTO nit_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","బుద్ది తోసెటర్ గొట్టి వినేకర్, కివ్ తోసెటర్, దయ ఓలిప్సెటర్ ఎద్దెర్. ");
INSERT INTO nit_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ఇటార్ తికెకదుంఙ్ తయార్ఎర్సార్ ఇనెకది దెయ్యమ్నె న్యాయ్ వాయుత్ ఔరుంఙ్ సోయ్ కరిపూత్ గినా, అదవున్ కల్సాని అంసార్. తమ్కలెకవి ఎరెకడ్ అదవున్కలెకా మరొక్కొరడ్ కలయుత్ కుసీకల్సార్. ");
INSERT INTO nit_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","అదుంఙ్ ఎత్తి మరొక్కొరెత్ న్యాయ్ కలెకని ఏనివేకద్, ఇనేత్‍ నీవి మాప్ ఇడ్డెంఙ్. ఎదున్‍ బదోల్‍ ఎక్కద్ మరొక్కొనుంఙ్ న్యాయ్ ఇదర్‍సాతివొ అదున్ బదోల్ నీవి దొస్ ఇసా న్యాయ్ కల్సతీ. తానుంఙ్ ఇంతె నీ ఎపనిక్‍ బదోల్ న్యాయ్ కల్సతివొ అదుని నీ నాయ్ కల్సతీ తా? ");
INSERT INTO nit_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","ఆపనిక్ కలెకర్‍పొయ్ దెయ్యమ్నె సత్తెం న్యాయ్‍కలెకది ఇసా నేండుంఙ్ ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","ఆపనిక్‍ కలెకరుంఙ్ న్యాయ్ కల్‍సా అదవులునీ కలెకా ఒక్కొ మన్కక్, దెయ్యమ్నె న్యాయ్ వెలంఙ్ సుకడిపతీ? ");
INSERT INTO nit_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","దెయ్యమ్నె సిలువ అల్కే ఇన్ పస్సత్తప్ పడెంఙ్ కర్యకత్న ఒర్కితోసెట అమ్నె దయ ఇనెకా అనే మన్ బద్లిపుర్ కలెకదున్ ఎపుడి అనెక సత్తిన్ డగ్లిపుత్ పుసాతివా? ");
INSERT INTO nit_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","ఇన్నె మొండితనమున్, బదలిల్సెట ఇన్నె మనున్ బదోల్ దెయ్యమ్నె న్యాయ్‍ తా న్యాయ్ ఎరెకా ఆ ఉగ్రత దినముంఙ్ సటీ, దెయ్యమ్నె రగ్గున్ దండి కల్సతీ. ");
INSERT INTO nit_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","అంద ప్రతి మన్కన్ అమ్నె పనిన్ ఓలుత్ కుల్కడ్ సియ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","సోయ్ తా పనిక్ కుసినడ్ కల్సా, మహిమ గనత, నాస్ ఎరెకదున్ కిరవేకరున్ ఎప్పుడి అనెకా పానం సియ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","అనంఙ్ ఎరత్తె సొయ్తర్, నమ్మెకారున్ సాయుత్న అన్యాయ్ కలెకర్‍ పొయ్ దెయ్యమ్నె రగ్, గుల్‍ రగ్ వర్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","కరబ్ పని కలెక ప్రతి ఒక్కొ మన్కకెర్ ఆత్మ, పేలె యూదులుంఙ్, మరొక్కొరుంఙ్ నాయ్ పేలెయ్ గ్రీకులూంఙ్ దుక్లగ్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","అనంఙ్ ఎరతె సోయ్ పని కలెకా ప్రతి ఒక్కొనుంఙ్‍, పేలె యూదులుంఙ్, వెన్కత్ గ్రీకు దేస్ తరుంఙ్ మహిమ, సాంతి సమాదాన్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","తానుంఙ్ ఇంతె దెయ్యముంఙ్ బేత్ బావ్ తోతెద్. ");
INSERT INTO nit_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","నియం సాస్త్ర అత్న పాప్ కత్తర్ నియం సాస్త్రం లంఙ్‍ న్యాయ్ ఎరద్. నియం సాస్త్ర తోసెట పాప్ కత్తర్‍నై నియం సాస్త్ర తోసెటర్ నాస్‍ ఎర్‍సార్. ");
INSERT INTO nit_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","నియం సాస్త్ర వినెకరున్ తోద్, అదున్ సుముత్ అడ్‍గెకరునీ దెయ్యం నీతి నాడ్ అనెకర్ ఇసా ఆసాద్. ");
INSERT INTO nit_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","నియం సాస్త్ర తోసెటా యూదులెర్సెటర్ సబవున్ నియం సాస్త్ర ఇడ్‍తెతి అడ్‍గెతె ఔరుంఙ్ నియం సాస్త్ర తోసెటండెనా తమ్మెత్‍ తామ్మి నియం సాస్త్రం లంఙ్ అంసార్. ");
INSERT INTO nit_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","ఆంటరె మన్ సాక్సినాయ్ సాక్స సియ్‍సాద్. ఔరెవిచార్ ఔరుంఙ్ పొయ్ గలత్‍ ఎరెకడి గలత్ తోతెంద్ ఇసా ఇడేకాది ఇదర్‍సాద్. అటరె మడ్ల లోప నియమ్ సాస్త్ర వయ్‍తెతియ్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","అన్నె సువార్త లంఙి దెయ్యం యేసు క్రీస్తున్ వాలడ్ మన్కకెరె బత్కకదున్ విచార్ కలెకా దినా ఇనంఙ్ ఎద్దా. ");
INSERT INTO nit_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","ఇండి నీ యూదుని ఇసా పేర్‍ ఇడుత్న నియమ్ సాస్త్రం పొయ్‍ బరొస ఇడుత్ దెయ్యమున్ బదోల్‍ అసా కల్సతివ తొదా? ");
INSERT INTO nit_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","అమ్నె ఇచ్చ కరిలుతి, నియమ్ సాస్త్రముత్ గొట్టి విత్న ఎద్‍ సొబతదో సియ్‍తెంద్ కరిలుతి అదున్ మెచ్చతి తా? ");
INSERT INTO nit_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","గ్యాన్ సత్తెం త నియమ్ సాస్త్రముత్ కలయుత్ అత్తన, “అన్ గుడ్డికున్ పావొలిపెకారన్, చికటిత్ అనెకరున్ వెలుంఙ్ ఓలిపెకరాన్. ");
INSERT INTO nit_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","నియమ్‍ సాస్త్రమున్ బుద్ది తోసెటరున్ సోయ్‍ కలేకారన్, సిన్న పోరకేరున్ మాస్ తార్ లాంఙ్” సత్తెం అన్సాతి తా? ");
INSERT INTO nit_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","మరొక్కొరుంఙ్ ఉపదేస్ ఇడ్డెకారన్, ఇనుంఙ్ నీవి ఇడెవా? డొంఙా కన్నెమ్ ఇసా ఇడ్డెకనివి డొంఙా కల్సాతీవా? ");
INSERT INTO nit_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","చినలి కన్నెమ్‍ ఇసా ఇడ్డెకనివి సినాలి కల్‍సాతివా? ముర్తికున్ ఆసహ్యించుకుంటూ నీవి గుడికున్ డొంఙా కల్సాతివా? ");
INSERT INTO nit_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","నియమ్ సాస్త్రత సోయ్త ఇడ్డెకనివి నియమ్ సాస్త్ర మీరి, దెయ్యమున్ అపమన్‍ కల్‍సాతివా? ");
INSERT INTO nit_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","ఇమ్‍వాలడి తా దెయ్యమ్నె పేర్ యూదు లెర్సెటరున్ నాడుమున్ బద్నం కల్సాద్? ఇసా వాయుత్ అంసాత. ");
INSERT INTO nit_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","నీవ్ నియమ్ సాస్త్రన్ పడిపెకనివ్‍ ఎరత్తె ఇనుంఙ్ సున్నతి ఉపయెగం వర్‍సాద్ గానీ నియమ్ సాస్త్రాన్ని పడిపెవ్‍ ఎరత్తె, నీ సున్నతి ఎర్‍సెటద్‍లంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","అదుంఙ్ ఎత్తి సున్నతి తోసెటద్లంగి నియమ్ సాస్త్ర నియములున్ పడిప్తే సున్నతి తోసెటండెనా సున్నతి సుమ్తెత్తి ఎర్‍సాద్‍ తా? ");
INSERT INTO nit_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","సున్నతి సుమ్సెటండెనా నియమ్ సాస్త్రన్ సుముత్‍ బత్కెకర్, వాయుత్ వసం‍లెంఙ్, సున్నతి సుముత్ నియమ్ సాస్త్రమున్ పాడిప్సెటనీ ఇనుంఙ్ న్యకల్సాద్‍ తా? ");
INSERT INTO nit_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","పొయ్ యూదు లంఙ్ కన్కెనెద్ యూదుంద్ ఎరెంద్‍, సరీరుత్ పొయ్ కన్కెరెకా సున్నతి ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","లోపా యూదులెదది యూదు. సున్నతి మన్నుత్ సెదిన్. అద్ ఆత్మత్ జర్గిలెకాది గని అనంఙ్ ఎరెద్. అటనున్ మన్కకెర్ ఎరెర్, దెయ్యమి మెస్సెంద్. ");
INSERT INTO nit_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","అనఙ ఎద్దె యూదులుంఙ్ గొప్పతనం తనెద్? సున్నతి వాలడ్ పయ్‍దా తనెద్? ");
INSERT INTO nit_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","ప్రతి గొట్టిక్ పేలె, దెయ్యం నమ్మకమ్ వాలడ్ యూదులుంఙ్ సియ్యెకద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","కొన్సెమ్ యూదకెర్ అవిస్వాసడ్ ఔర్ ఎద్దదున్ మత్రం దెయ్యం విస్వాసడ్ ఎద్దాద? ");
INSERT INTO nit_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","ఎరెది ఎరెద్. “ఇన్నె గొట్టిక్లె నీవ్ నీతిమంతక్ లాంఙ్ కన్కెరెంఙ్‍, ఇన్పొయ్ విచార్ ఎద్దపుడ్ గెల్లెఙ్” ఇసా వాయుత్ అనెకా లాఙ్ మన్కకెర్ సదర్ లబడ్ ఎద్దర్ గని, దెయ్యం మాత్రం సత్తెం. ");
INSERT INTO nit_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","నేండెత్ కరాబ్ నీతి దెయ్యమ్నె నీతిన్ పుసుతిడ్తే అనెకపూర రగ్ ఓలిపెకా దెయ్యం నమ్సెటాంద్ ఇదరెకరున్ ఇడ్డెంఙ్? అన్ మన్కక్నె అడ్గెకా రీతిన్ ముడ్సానండాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","అనాగ్ ఎరెది ఎరెద్. అనఙ్ ఎద్దె దెయ్యం దున్యంఙ్ ఎనాఙ్ న్యాయ్ తిర్పసందా? ");
INSERT INTO nit_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","అన్నె లబడ్ వాలడ్ దెయ్యమున్ సత్తెం కరిపెకాంద్ అమ్నుంఙ్ మహిమ ఎద్దె? అన్ పాపినాన్ ఇసా న్యాయ్ కలెకాద్ తానుంఙ్? ");
INSERT INTO nit_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","సోయ్ ఎరెఙ్ ఇసా కరాబ్ కన్నార్ ఇసా అమ్ ఇడ్సనండాతుం ఇసా పఙ్ఙి దూక్ కొసెం మంది అంపొయ్ బద్నం ఇదర్ తెతి అన్ కరెయ్ అనఙ్ ఇడ్డెఙ్ వాంద్ తా? ఔరున్ పొయ్ వారెకా సిక్స న్యాయంతది. ");
INSERT INTO nit_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","అనఙ్ ఇసా అమ్ ఔరుఙ్ ఎనా సొబతరమా? ఎంతెయో గని తోద్. యూదకెద్దంద్, గ్రీకు దాదకేర్ ఎందర్, సాదరి పాప్ ముత్ అండరిస పఙ్ఙి దూక్ దొస్ ఇదర్నర్ తా. ");
INSERT INTO nit_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","ఇదున్ బదోల్ తన్నెద్ ఇసా వాయుత్ అంసాదింత్తె, ఇమందార్ తోరెంద్ ఒక్కొద్‍నాయ్ తోతెంద్. ఇద్ లేకాముత్ తనెద్ ఇసా వాయుత్ అండాదింతే, నీతిమంతక్ తోతెంద్ ఒక్కొద్ కుల్ తోతెంద్, ");
INSERT INTO nit_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","అమ్నున్ కరిపెకాంద్ ఎంది తోతెంద్, దెయ్యమున్ కిరవేకది తొతేంద్. ");
INSERT INTO nit_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","సాదరి దెయ్యంతన పవున్ బులిల్తెర్, సాదరి ఒక్కొద్ ఎందెర్ పని సియ్యెటర్లాంఙ్. దయ కలెకంద్ తోతెంద్, ఒక్కొద్ కుల్ తొతేంద్. ");
INSERT INTO nit_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ఔరె బొండ్క పుసుత్ అనెక తప్నెలంఙ్ అన్సాద్. ఔరు నాల్కనడ్ మోసం కల్సనంసార్. ఔరె పెదవెలుంఙ్ బూడున్ పామ్నె విసం అన్సాద్. ఔరె ముట్టెరింతే ఔరె మూతిక్ పుసుత్‍ అనెక సమాదిలాఙ్ అండాద్. ఔర్ నాల్కనడ్ పసిప్సా అన్సార్ ఔరే పెదవె పొయ్ పామ్నె విసం అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ఔరే మూతి నిండ కరాబ్ గునా, డావా ఇడుత్ అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ఔరె అల్ఙెఙ్‍ తులసార్ ఔరే పానాం ఇసానండద్. ");
INSERT INTO nit_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ఔరే మార్గముత్ నాస్, కాటిన్ అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ఔరుఙ్ సాంతి సామదన్ తా మర్గం ఒర్కితొద్. ");
INSERT INTO nit_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ఔరే నాదురుంఙ్ దెయ్యమ్నె అర్రి ఇంతె ఒర్కితొద్. ");
INSERT INTO nit_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","ప్రతి మూతింఙ్ మున్సెంఙ్ ఇసా. దున్యసిమన దెయ్యమ్నె తిర్పు బూడున్ వరెంఙ్ ఇసా నియమ్ సాస్త్రం ఇడ్డెకా గొట్టిక్ అదున్ బూడున్ అనెకారుఙి ఇస్సా అండాదిసా నెడుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","తానుంఙ్ ఇంతె నియమ్ సాస్త్రన్ పారిపెకదుంన్ వాలడ్ ఎమన్కక్ దెయ్యమ్నె నదురుంఙ్ నీతిమంతులాంఙ్ ఎరేద్. నియమ్ సాస్త్ర వాలడ్ పాప్ ఇంతె తనెదొ కరిల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","ఇద్‍ ఇనంఙ్ అండే నియమ్ సాస్త్ర సంమంద్ తోసెట దెయ్యమ్నె నీతి ఒర్కి ఎద్దిన్. నియమ్ సాస్త్రం ప్రవక్త వాయ్‍తెర్ అదుంఙ్ సాక్సం అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","అద్ యేసు క్రీస్తునంత్తి విస్వాసాడ్ నమ్మెకర్ సిమ్కన మందింఙ్ రొంబడెకా దెయ్యమ్నె నీతి. బెత్ బావ్ తనయ్‍ తోతెంద్ ");
INSERT INTO nit_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","సిమ్కన మంది పాప్ కత్న దెయ్యం సియెకా మహిమన్ సుమెంఙ్ సాలెత్తెర్. ");
INSERT INTO nit_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","నమ్మెకర్ దెయ్యమ్నె కృపనాడ్, క్రీస్తు యేసున్‍వాలడ్, సాయెకద్, పుకమెయ్ నీతిమంతులంఙ్‍ ఇసా న్యాయ్ సుమ్‍సార్. ");
INSERT INTO nit_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","యేసునే నెత్తుర్ విస్వాసాడ్ పాప్ తన్న సుటలెంఙ్ దెయ్యం తన్నె రంఙ్త అగ్నియన్పుచెకా పాప బదోల్ బావ్ ఇసా అంనున్ నెమిప్‍తెద్. అత్తి దెయ్యమ్నె నీతి తన్నె న్యాయున్ ఓలిపెంఙ్. తానుంఙ్ ఇంతె, పేలె తా పాపునున్ దెయ్యం సైన్ కత్నా దాటుత్‍ సెదెద్. ");
INSERT INTO nit_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","పేలె తా కలముత్ తన్నె నీతిన్ ఓలిపెకా మిసెమడ్, యేసునత్తి విస్వాస్ ఇట్టరున్ నీతిమాన్ లంఙ్ అనెంఙ్ దెయ్యం ఇనంఙ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","అదుంఙ్ ఎత్తి నేండ్ సోయ్తవున్ ఇడ్డెకదుంఙ్ కారన్‍ తానెద్? అదున్ పుసుత్ జొపిడెకద్ ఎద్దిన్. ఏనియమున్ సుముత్? క్రియలున్ సుముత్? తోద్, విస్వాస్ నియమున్ వాలడ్. ");
INSERT INTO nit_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","మన్కకెర్ నియమ్ సాస్త్రత క్రియతోసెటయ్ విస్వాసుంఙ్ వాలడ్ ఇమాన్‍దలుంఙ్ న్యాయ్ ఎరద్ ఇసా నిర్నయ్ కల్సాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","దెయ్యం యూదులుంఙి ఆ దెయ్యం మా? యూదు లెర్సెటరుంఙ్ తోదా? అయ్, ఔరుంఙ్‍నై దెయ్యమి. ");
INSERT INTO nit_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","దెయ్యం ఒక్కొది అదుంఙ్ ఎత్తి, అముదు యూదు ఎదనుంఙ్ విస్వాసుంఙ్ వాలడ్, సున్నతి ఎర్సెటర్ తోసెటరుఙ్ విస్వాసాడ్‍ నీతితద్‍లంఙ్ ఇదర్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","విస్వాసుంఙ్ వాలడ్ నియమ్ సాస్త్రమున్ మోడిప్సాతుమా? తోద్, నియమ్ సాస్త్రామున్ పరిప్ సాతుం. ");
INSERT INTO nit_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","ఆదుంఙ్ ఎత్తి సరీరాడ్ నేండె దొడంద్ అబ్రాహామ్ మున్ తనెద్ రొబట్టిన్? ");
INSERT INTO nit_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","అబ్రాహామ్నె క్రియలున్ బదోల్ నీతితద్ ఇసా న్యాయ్ కత్తండె అముదు సొతంఙ్ దండి చెరెంఙ్ కారన్ అంతనద్ గని అద్ దెయ్యమున్ ముండట్ తోద్. ");
INSERT INTO nit_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","లేకనం ఇడ్‍సాద్ తనెద్ ఇంతె, “అబ్రాహామ్ దెయ్యంనత్తి బరొస ఇట్టెద్. అదుంఙ్ వాలడి అముదు నీతితంద్ ఇసా న్యాయ్ ఎద్దిన్.” ");
INSERT INTO nit_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","పని కలెకా మన్కంఙ్ సియెకా కుల్‍కాడ్‍ అమ్‍నుంఙ్ హక్లంఙ్ వరెకా కుల్కడి గని దాన్ తోద్. ");
INSERT INTO nit_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","గని క్రియ కల్‍సెట అదుంఙ్ బదోల్ బక్తి తోసెటనున్ నీతిమంతులాంఙ్ కత్న దెయ్యంనత్తి ఎకున్ విస్వాసిని దెయ్యం నీతితంద్ నివ్డిప్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","అనాయ్ క్రియతోసెట దెయ్యం నీతితద్‍లంఙ్ ఇడ్‍ తా మన్కక్ దన్యులు ఇసా దావిద్ నాయ్ ఇడ్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","ఎనంఙ్ ఇంతె, తన్నె కత్త కరాబ్ పనిక్ మాప్ ఎద్ద దన్యుడు, తన్నె పాప్ లుంఙ్ మాప్కల్ తక్లిబ్ సుమ్‍ తాద్ దన్యుడు! ");
INSERT INTO nit_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ప్రబుద్ ఎరె విరొదులున్ పాప్ సుమ్సేటద్ బాగ్యి వన్. ");
INSERT INTO nit_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","ఈ కుసీ సున్నతి పడిపెకరున్ బదోల్ ఇడ్‍తెదా, పడీప్‍ చేటరూన్ బదోల్ గి ఇడ్‍తెదా? అబ్రాహామ్ మునే విస్వాస్ అంనున్ నీతిమాన్ ఇసా తీర్తీన్ ఇంతమ్‍ తా? ");
INSERT INTO nit_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","అముదు ఏంటాద్ అంనేదొ అద్ జర్గిల్‍తిన్? సున్నతి ఇదర్‍గత వెన్కత్ ఏరెకడి సున్నతిన్ ముదర్‍వై? ముదర్వైనీ! ");
INSERT INTO nit_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","సున్నతి తోసెటండెగి నమ్ తరున్ సాదరున్ అముదు బాంద్ ఎరెఙ్ సటీ ఔరున్ నీతి ఆపత్తికలెఙ్ సున్నతి తోసెటా అపుడి, తన్ కలయుత్ అనెకా విస్వాస్ వాలడ్ రొంబటా నీతిన్ ముద్రలంఙ్ సున్నతి ఇనెకా ఒర్కిన్ సుమ్ముర్. ");
INSERT INTO nit_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","అనఙి సున్నతి ఎద్దరున్ దెకుల్ బాంద్ అబ్రాహామ్ విస్వాసమడ్ అడ్గెకా రితి అగ్తరున్ ఔరున్ దెకుల్ బాంద్ ఎరెఙ్ అముదు ఆ ఒర్కి ఇదార్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","అబ్రాహామ్, అమ్నె పిల్లపడ్స దున్యంఙ్ తన్నె వారసు ఎద్దర్ ఇనెకా వాగ్దానం నియమ్ సాస్త్ర ములంగ రొంబడెతిన్. విస్వాస్ సున్ వాలడ్ ఎద్ద నీతిన్ వాలడ్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","నియమ్ సాస్త్ర బదోల్ వరసుల్ ఎద్దె విస్వాస్ వ్యర్తమ్ ఎర్‍సాద్, వాగ్దానం ఎర్తంఎరాద్ రగ్గుంఙ్ కొర్సార్ ");
INSERT INTO nit_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","తానుంఙ్ ఇంతె నియమ్ సాస్త్ర రగ్గాడ్ పుట్‍ గల్సాద్. నియమ్ సాస్త్ర తోసెట జాగత్ అదున్ పడిపెకద్ నాయ్ అనేద్. ");
INSERT INTO nit_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","ఈ కారనుంఙ్ బదోల్ ఆ వాగ్దానం అబ్రాహాముంఙ్ సంతనం ఔరు సిమ్కనమందింఙ్‍, ఇంతె నియమ్ సాస్త్రమ్ అనెకరుంఙి ఎకున్ తోద్ గా అబ్రాహాముంఙ్ అనెకా విస్వాస్ అనెకరుంఙ్ నాయ్ కృపన్ బదోల్ వగింలెంఙ్ ఇసా, అద్ విస్వాసులమ్ ఇసా ఎద్దమ్. ఆ అబ్రాహామ్ నేడుంఙ్ సిమ్కనమందింఙ్ బాంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","ఇదున్ వాలడ్, “ఇంను ఎంతెయొ మందిఙ్ బాంద్ లాఙ్ నేమిప్ తాన్” ఇసా వాయుత్ అండద్. తాన్ నమ్ తా దెయ్యమున్ ముండట్, ఇంతె తిక్తరున్ బత్కిప్సాంద్, తొసేటవున్ అండెతిలఙ్ కూగెకద్ అముదు దెయ్యమున్ ముండట్ అముదు నేండుంఙ్ సాదరున్ బాంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","అనఙ్ పఙ్ఙి, ఇన్నె పిల్లపడ్స అన్సాద్ ఇసా వాయుత్ అండేతిలాఙ్ అన్ అనెకా మందిఙ్ బాంద్ ఎద్దెతిలాంఙ్ ఏంటది ఆస తోసెటవుంఙ్ గినా ఆసనాడ్ నమ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","అముదు విస్వాసముత్ కమ్జొర్ ఎరెతెంద్, కమ్మి జాస్తి నూర్ సాల్కులక్ అదుంఙ్ పఙ్ఙి, తన్నె మెనుత్ గుగ్గు ముర్ తా, సారా గర్బం గుగ్గు ముర్త ఇంతేంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","అవిస్వాసడ్ దెయ్యమ్నె వాగ్దానామున్ బదోల్ బెత్‍బవ్ కల్‍సెటా విస్వాసుత్ సోయ్‍ఎత్న దెయ్యమ్నె మహిమ కలెంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","దెయ్యం గొట్టి సీతదున్ దెయ్యం పూర కలెంఙ్ విచార్ కల్సెటా పక్క నమ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","అదుంఙ్ ఏత్తి దెయ్యం అదున్ అనుంఙ్ నీతిమాన్‍ లాఙ్ ఇంతెంద్. ");
INSERT INTO nit_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","దెయ్యం విస్వాస్ తొసేటంద్ అనాయ్ అసెంఙ్ అనుంఙ్ సటీ మాత్రమి వాయుత్ తోతెద్, ");
INSERT INTO nit_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","నేండె ప్రబు యేసునున్ తిక్తరంతన సులుప్తెంద్ దెయ్యంనంతి విస్వాస్ ఇట నేడున్ నాయ్ ఇమన్‍దాల్ ఇన్నెంఙ్ నేండుంఙ్ సటీ నాయ్ వాయుత్ అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","అంనున్ దెయ్యం నేండె గలత్ అపరదులుంఙ్ సటీ సొపరిపుత్న, నేండున్‍ నీతిమంతక్ కలెంఙ్ అంనున్ పెన్న సులప్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","విస్వాసుంఙ్ వాలడ్ దెయ్యమ్ ఇమున్ ఇమాన్‍దల్‍ బనప్తిన్ అదుంఙ్ ఎత్తి నేండె ప్రబు యేసు క్రీస్తున్ వాలడ్ దెయ్యమున్ వెంట కలయుత్‍ అంసాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","అదున్ వాలడ్ నేండె విస్వాసుంఙ్ వాలడ్ ఈ కృపత్ అదున్‍ లోపా, అడుగుత్ దెయ్యమ్నె మహిమ బదోల్‍ ఆసనడ్ కుసీ కల్సాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","అంత్తెయ్ ఎరెకడి, కస్టలున్ సయినున్, సైన్ పరిక్సత్, పరిక్స పవ్ ఓలెకాద్ ఇదర్‍సా ఇసా కరిలుత్న నేండె కస్టాలెంఙ్ కుసీ కన్నర్. ");
INSERT INTO nit_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","అంతెయ్ తోద్, కస్టాలెంఙ్ సయినున్, సహిన్ కలెకాంద్, ఆసకల్సాన్ కొరాద్‍ ఇసా కరిలుతి నేండె కస్టాలెంఙ్ కుసీకన్నర్. ");
INSERT INTO nit_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ఈ నమ్మెకది నేండున్ నారాజ్ కలెద్. తానుంఙ్ ఇంతె దెయ్యం నేండుంఙ్ సియ్‍ తా పరిసుద్దా ఆత్మ వాలడ్ అముదు తన్నె ప్రేమన్ నేండె మన్నుత్ పురా సియ్యెకాద్ ");
INSERT INTO nit_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","తానుంఙ్ ఇంతె నేండ్ కమ్‍జోర్‍ అనెంఙ్‍, లగ్‍త వెలంఙ్ క్రీస్తుంద్ కమ్జొర్ అనెకరుంఙ్ సటీ తిక్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","సోయ్ లుంఙ్ సటీ ఎదేనా తికెకద్‍ అంసాదా. నీతి తరుంఙ్ సటీ ఏరెనా తికేకదుంఙ్ ఒక్కొ వెల తయార్ ఎరేంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","గని దెయ్యం నెడ్పొయ్ తన్నె ప్రేమన్ ఓలిప్‍తెద్. ఎనంఙ్ ఇంతె నేండ్ ఇంక పాపులకెర్ అనెంఙ్ క్రీస్తుంద్ నేడుంఙ్ సటీ తిక్‍తెద్. ");
INSERT INTO nit_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","అదుంఙ్ ఎత్తి ఇండి అమ్నె నెత్తుర్ డ్ ఇమాన్‍దాల్‍ సోయ్ ఎత్న, ఇంక కరెయ్ అంనున్ వాలడ్ రాగ్ తన్న సుకడిలతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","తానుంఙ్ ఇంతె నేండ్ విరోద్‍ అత్న, అమ్నే పోరక్నె తికేకదుంఙ్ వాలడ్ దెయ్యంనడ్ సమదాన్ ఎద్దె, క్రీస్తునే పానం అదుంఙ్ వాలడ్ ఇంకా సోయ్ బత్కసాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","అంత్తెయ్ ఎరెకడ్, నేండె ప్రబు యేసు క్రీస్తున్ వాలడ్ ఇండి సమదానడ్ అంసాతుమ్ అదుంఙ్ ఎత్తి అంనున్ వాలడ్ నేండె దెయ్యంనత్తి కుసీకల్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","ఇనంఙ్ అనెంఙ్‍, ఒక్కొ మన్కన్ వాలడ్ పాప్‍ ఎనంఙ్ ఈ దున్యత్ వత్తినొ, అనాయ్ పాపుంఙ్ వాలడ్ తికెకాద్ వత్తిన్. మన్కకెర్ సిమ్కన పాప్ కలెకదుంఙ్ వాలడ్ తికేకద్ సింకానంగి వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","తానుంఙ్ ఇంతె నియమ్ సాస్త్రం వరెంఙ్ పేలె దెకుల్ దున్యత్ పాప్ అండద్ గని నియమ్ సాస్త్రం తోతెంద్ అదుంఙ్ పఙ్ఙి దెయ్యమున్ ఔరున్ పొయ్ పాపం ఇదారెతిన్. ");
INSERT INTO nit_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ఇంతె, ఆదమ్నే కాలం తనట్ మోసేనె కాలం దూక్ మన్కకెర్ పొయ్ తికెకద్‍ రాజ్యె కత్తిన్‍. అదామ్ దెయ్యమ్నె ఆగ్యను మోడిప్తెంద్‍. ఇసా అదుంఙ్‍ వాలడి పాప్ ఇదర్సెటర్ పొయ్ దెకుల్ తికెకద్‍ రజ్య కత్తిన్. ఆదాము వారెకదున్ అమ్నుంఙ్ ఒక్కొ ఒర్కిలంఙ్ అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","గని దెయ్యం సియ్ తా వరమున్, మల్ల ఆదాం గలత్ కత్త పాపమున్ బరాబర్ తోతెద్. ఒక్కొనె పాపుంఙ్ వాలడ్ సిమ్కన మంది తిక్తేర్. ఇంతె దెయ్యమ్నె దయ, యేసు క్రీస్తు ఇనెకా ఒక్కొ మన్కక్నె కృపన్ వాలడ్ రొబట్టద్ పుక్కామెయ్ రొబట్టిన్ కృప దన్ మల్ల కరెయ్ ఎన్తెయో మందిఙ్ సొబనడ్ రొంబట్టిన్. ");
INSERT INTO nit_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","పాప్ కత్ తా ఒక్కొనున్ వాలడ్ సిక్స రొబ టేతి ఆ కృప దన్ రొంబడెతిన్. తానుంఙ్ ఇంతె తిర్పు ఒక్కొ పరిసాన్ నడ్ వత్ తా సిక్ససాన్ కారనం గలత్ ఎద్దాంద్ కృప నేవరమెద్దె ఎన్నిగొ ఎంతేయో వాత్ మన్కకెర్ నీతిమంతులాంఙ్ న్యాయ్ కలెకద్ వత్తిన్. ");
INSERT INTO nit_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","తిక్కెకాద్ ఒక్కొనే అపరద్ వాలడ్ వాత్ ఆ ఒక్కొనున్ వాలాడి కురిత్ నేరాయ్ తే కృప, నీతి ఇనెకా పుక్కామే రొబ్బటనద్ పానం పడుత్ కుబ్ కుబ్బెనా యేసు క్రీస్తు ఇనెకా ఒక్కొంద్ వాలడి గలత్ కురిసార్. ");
INSERT INTO nit_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","అదుంఙ్ పఙ్ఙితిర్పెకద్ ఒక్కొ అపరాద్ వాలడ్ వత్, మన్కకెరున్ సాదరున్ సిక్స గలత్ ఎద్దున్ వాలడ్ కారనం ఎద్దినొ, అనాఙి ఒక్కొ నీతి కార్యం వాలడ్‍ కృప దాన్ మన్కకెరున్ సదరుఙి పానం సియ్యుత్ నీతి మాన్ఎద్దీన్. ");
INSERT INTO nit_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","తానుంఙ్ ఇంతె ఒక్కొనె పాపినాన్ అనెకా ఎంతొయో మందిన్ నీతి మంతకెర్లాఙ్ ఇదార్సంద్. ");
INSERT INTO nit_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","21","నియమ్ సాస్త్రం సేరఎకాదున్ వాలడ్ అపరద్ నెరయ్తిన్. గలత్ ఎద్దె పాప్ తికెకదున్‍ అదర్ కత్న ఏనంఙ్ కురితినొ, అనఙి ఎప్పుడి పానం కలయెంఙ్ నీతిన్ వాలడ్ కృప మన ప్రబు యేసు క్రీస్తున్ వాలడ్ సెరెంఙ్ సటీ పాపం నెర్యుత్ జాగలేంఙ్ కృప పూరయ్ నెర్యతిన్. ");
INSERT INTO nit_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","అదుంఎత్తి తానేద్దీందర్? కృప వడిలెంఙ్ సటీ పాప్ మూతి అడ్‍గనార్? ");
INSERT INTO nit_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","ఇనంఙ్ ఎపుడి ఎరెంఙ్ తోద్. పాప్నె బత్కెకద్ బదోల్ తిక్తరమ్ నేండ్‍ అత్తి ఎనంఙ్ సెరెంఙ్ సాలతుమ్? ");
INSERT INTO nit_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","క్రీస్తు యేసునంత్తి బాప్తిస్మ సుమ్తారం నేడ్ సిమ్కనమంది అంనే తిక్‍తదున్ బదోల్‍ నాయ్ బాప్తిస్మ సుమ్తాం ఇసా ఇముంఙ్ కరిలెదా! ");
INSERT INTO nit_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","అదుంఙ్ ఎత్తి బానె మహిమ వాలడ్ క్రీస్తుంద్ తిక్తరుంఙ్ బదోల్ ఔరున్‍తన ఏనంఙ్ సుల్తేదొ, అనాయ్ నేడ్నయ్ కొత్త పానం తెతి అడ్గనెర్, నేండ్‍ బాప్తిస్మ బదోల్‍ తికుత్, అమ్నున్‍ వెంటా పుర్పతం ");
INSERT INTO nit_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","అమ్నె తిక్ తార్ బత్కసార్ బదోల్ అమ్నున్ వెంటా ఒక్కొద్ ఎత్‍ అంసాతుమ్‍ఎరత్తె, అనాయ్ అమ్నె సులెకదున్ బదోల్‍ నాయ్ ఒక్కొద్‍ ఎత్‍ అంసాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","తానుంఙ్ ఇంతె, నేండుంఙ్ ఒర్కియ్, నేండ్‍ పెన పాప్పుంఙ్ఞ గడియక్‍లంఙ్ అంసెటా పాప్‍న్నే సెత్త నాస్ ఎద్దెత్తి, నేండె పాత సబావ్ క్రీస్తున్ వెంటా కలయుత్ సిలువత్ తికెకద్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","తిక్‍ తా మన్కక్ పాపమున్ బదోల్ నీతితంద్ ఇసా న్యాయ్ ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","నేండ్‍ క్రీస్తున్ వంట నాయ్ తిక్తె, అంనున్ వెంటనాయ్ బత్కసాతుమ్ ఇసా నమ్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","తిక్తరత్తన సుల్త క్రీస్తుంద్ ఇంక తికెద్‍ ఇసా, తికేకదుంఙ్ అంనున్ పొయ్ అదికారం తోతెంద్ ఇసా ఒర్కియ్. ");
INSERT INTO nit_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","తానుంఙ్ ఇంతె అముదు తికెకద్ పాప్పుంఙ్ఞ బదోల్ ఒక్కొది ఉసాట్ తిక్‍తెంద్ గని, అంద బత్కెకద్ మత్రం దెయ్యమున్ వెంట బత్కసాద్. ");
INSERT INTO nit_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","ఇది ఇముంఙ్ వర్తిసాంద్. నీర్ పాపుంఙ్ బదోల్ తిక్తర్‍లంఙ్‍, దెయ్యమున్ బదోల్ క్రీస్తు యేసున్ వాలడ్ దెయ్యం నత్తి బత్కసాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","అదుంఙ్ ఎత్తి సరిర్నె అసా కత్న తిక్కెకా ఇమ్మె సరీరున్ పాప్వై సెరెంఙ్ ఇడ్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","ఇమ్మె వస్తులున్ అన్యాయ్ వస్తులున్‍ పాప్ న్వై సియ్‍నెర్. ఇంతే తిక్తతన పానం ఎద్ద ఇమ్మెత్ నిరి దెయ్యముంఙ్ సియ్యుర్ ఇమ్మె అవయులున్ నీతిన్ పనిక్ ఇదరెకాలంఙ్, దెయ్యముంఙ్ సియ్యుర్. ");
INSERT INTO nit_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","నీర్ కృప బుడుని గని నియమ్ సాస్త్రంఙ్ బూడున్ తోద్ అదుంఙ్ ఎత్తి పాపుంఙ్ అదికార్ సియెంఙ్ ఇడ్‍నెర్. ");
INSERT INTO nit_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","అనంఙ్ ఎద్దె, నేండె కృపంఙ్ బుడుని గానీ నియమ్ సాస్త్రంఙ్ బూడున్ తోతెమ్ అదుంఙ్ ఎత్తి పాప్ కత్తమా? అనంఙ్ ఎప్పుడి కలెంఙ్ తోద్. ");
INSERT INTO nit_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","నీర్ దెయ్యమున్ సుముత్ ఇమ్మెత్ నిరి గడియ్యకెర్‍లంఙ్ సోసిప్‍సాతిరొ, అద్ తికేకాదుంఙ్ సటీ పాపుఙ్‍ ఎన్న, నీతింఙ్ సటీ ఎన బూడున్ దెయ్యముంఙ్ సుముత్ అంసారొ, అదుంగి గడియకేర్ ఎద్దరిసా ఇముంఙ్ కరిలెదా! ");
INSERT INTO nit_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","నీర్ పేలె పాప్పుంఙ్ఞ గడియకేర్ లంఙ్ అన్సాతిర్. గానీ ఏ గొట్టిన్ ఇమ్మెత్ నీరి సియ్తిరొ అదుంఙ్ గుండెతానట్ ప్రేమ్ కల్సర్. దెయ్యముంఙ్ దన్యవాద్! ");
INSERT INTO nit_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","అదుంఙ్ వాలడ్ పాప్ మపి పొంది నీతింఙ్ గడియకెర్ ఎద్దిర్. ");
INSERT INTO nit_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","ఇమ్మె సరీర్నె కమ్జోర్తా మన్కక్నే రితినాడ్ ముడ్సనంసత్. ఇదుంఙ్ పేలె పైలి కలెకదుంఙ్ ఏనంఙ్ అపవిత్ర, దుర్మర్గమున్ ఇమ్మె అవయవా గడియక్‍లంఙ్ సియ్యెకాద్, అనాయ్ పవిత్ర ఎరెంఙ్ సటీ అదవున్ ఇండియ్ నీతింఙ్ గడియక్లాఙ్ సియ్యెకాద్. ");
INSERT INTO nit_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","నీర్ పాప్ లుంఙ్ గడియకెర్ లంఙ్ అనెంఙ్ నీతిన్ బదోల్ ఇముంఙ్ తనయ్ అడమ్ తొతెంద్. ");
INSERT INTO nit_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","ఇండి కత్త పనీక్ వాలడ్ ఇముంఙ్ తా పైదా రొంబట్టిన్? అదుంఙ్ వాలడ్ నీర్ ఇండి లజ్జఙ్ వర్సతిర్‍ తా? తికెకది అద్నె పైదా. ");
INSERT INTO nit_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","ఇంతె నీర్‍ ఇండి పాప్ సియ్యెకాద్ దెయ్యమ్నె గడియకెర్. పవిత్రత అదున్ పలితం. అద్నే ఆక్రి పలం ఎప్పుడి అనెకా పానం ");
INSERT INTO nit_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","తానుంఙ్ ఇంతె పాప్నె కుల్‍కడ్ తికేకది. అనంఙ్ ఎరత్తె దెయ్యమ్నె కృప వరం నేండె ప్రబుంద్ క్రీస్తు యేసునంత్తి ఎప్పుడి అనెకా పానం. ");
INSERT INTO nit_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","దాదకేర్ బాయి లార, నియమ్ సాస్త్ర మన్కకెర్ బత్కుత్ అనపగొలి అదికార్ అడ్‍గసాద్ ఇసా ఇముంఙ్ ఒర్కి తొదా! నియమ్ సాస్త్ర కరిల్త ఇముంఙ్ ముడ్సాత్. ");
INSERT INTO nit_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","పేడ్లి ఎద్ద పిల్ల, తన్నె మాస్ బత్కుత్ అనపగొలీ నియమ్ సాస్త్రవాలడ్‍ అంనుంఙ్ బదోల్ ఎక్కద్, మాస్ తిక్తే సోయ్‍రిక్ కలెక నియమ్ సాస్త్రనియమ్ తన్న సోయ్‍ఎరద్. ");
INSERT INTO nit_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","అదుంఙ్ ఎత్తి మాస బత్కుత్ అనెంఙ్ అద్ మరొక్కొమన్కనడ్ కలయ్‍తే అద్ చినలి ఎర్‍సాద్ గానీ, మాస తిక్త్తె అద్ నియమ్ సాస్త్రతనట్ సోయ్ ఎద్దిన్ అదుంఙ్ మరొక్కొ పడ్సానాద్ పేడ్లి కత్తే అద్ చినలిన్ ఎరేద్. ");
INSERT INTO nit_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","అదుంఙ్ ఎత్తి అన్నె దాదకేర్ అని బాయినెలారా, నేండ్ దెయ్యముంఙ్ సటీ సేవా కలేంఙ్ ఇసా తిక్కుత్ పానమ్ ఎద్దా క్రీస్తుంన్‍వై చెరెంఙ్ నీర్నాయ్ అంనే సరీర్ ‍వాలడ్ నియమ్ సాస్త్ర బదోల్ తిక్తేంద్. ");
INSERT INTO nit_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","తానుంఙ్ ఇంతె నేండ్ సరీరుత్ కలయ్‍తర్ అనెంఙ్ తికెకద్ పలమున్ పడిపెంఙ్ నియమ్ సాస్త్రవాలడ్ వరెకా పాప్ కోరిక నేండె వస్తు పని కల్‍సా అన్నె. ");
INSERT INTO nit_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","ఇండి ఇద్దె ఎది నేండున్‍ కట్టుత్ ఇట్టరొ అదున్ బదోల్ తికుత్న, నియమ్ సాస్త్రతనట్ సోయ్ ఎద్దమ్. అదుంఙ్ ఎత్తి నేండ్‍ అదున్ వాయుత్ అనెకా నియమ్ సాస్త్రం పాతవిదానాలడ్ తోద్ దెయ్యమ్నె ఆత్మలంఙ్ కొత్త విదానలడ్ సేవ కల్సాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","అదుంఙ్ ఎత్తి తనెన్ ఇడ్డెకాద్? నియమ్ సాస్త్రం పాప్? ఎరెది ఎరెద్. నియమ్ సాస్త్రవాలడ్ తొదెరతె అనుంఙ్ పాపమింతే తనెదొ ఎర్కా పడ్సేటద్. మరొక్కొరున్ చెద్దదున్ ఆసకనెర్ ఇసా నియమ్ సాస్త్ర ఇడ్సెటండె ఎక్వాస ఇంతె అనుంఙ్ కరిల్‍సెటాద్. ");
INSERT INTO nit_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","ఇంతె పాప్ ఆగ్యన్ ఆదారడ్ కత్న సిమ్కన రంఙులడ్ ఎక్వాసలున్ అనత్తి పుట్తిన్. నియమ్ సాస్త్ర తోసేటండే పాప్ తిక్తేతి. ");
INSERT INTO nit_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","ఒకపుడ్ అన్ నియమ్ సాస్త్రం తొసేటా అండె పానమి అంసాత్ గానీ, ఆగ్య వరెకదున్ వాలడ్ పాప్పుంఙ్ఞ పెన పానం వత్తిన్ అన్ తిక్తన్. ");
INSERT INTO nit_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","అపుడ్ పానం కొరెక ఆగ్యనుంఙ్ తికేకదున్ కొరెకద్ కన్కెదిన్. ");
INSERT INTO nit_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","తానుంఙ్ ఇంతె పాప్ ఆగ్యన్ అదర్కత్న పసిపుత్నా అన్ అలంగతిన్. ");
INSERT INTO nit_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","అదుంఙ్ ఎత్తి నియమ్ సాస్త్ర పవిత్ర. ఆగ్య నాయ్ పవిత్ర, సోయ్. నీతి వత్, ");
INSERT INTO nit_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","మరి సోయ్ తా అనుంఙ్ తికేకదున్ కొత్తినా? తోది తోద్. అనంఙ్ ఎరత్తె పాప్ సోయ్తదున్ వాలడ్ పాప్‍కంన్కేరెంఙ్ ఇసా, అద్ అనుంఙ్ తికెకదున్ తోడ వత్తిన్. ఇంతె పాప్నె ఆగ్యలంఙ్ పెన జాస్తి పాప్ ఎరెకదుంఙ్ సటీ, అద్ అనుంఙ్ తికేకాదున్ తోడవత్తిన్. ");
INSERT INTO nit_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","నియమ్ సాస్త్ర ఆత్మ కలయ్‍తిన్ ఇసా నేండుంఙ్ ఒర్కియ్. అనంఙ్ ఎరత్తె అన్ పాప్పుంఙ్ఞ విరెంఙ్ ఎద్ద సరీరుంఙ్ కలయ్‍తద్. ");
INSERT INTO nit_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","తానుంఙ్ ఇంతె అన్ కలెకద్ అనుంఙ్ కరిలెద్. అన్ ఎదున్ మనుంఙ్ కొర్‍సాత్ అదుంన్ అదున్ ఎరెకడ్ ఎదున్ విరోద్ కల్‍సాతొ అదుని కల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","అనుంఙ్ మన్నుంఙ్ తోసెటదున్ కత్తనింతె నియమ్ సాస్త్ర సోయ్తది ఇసా ఒప్సాత్. ");
INSERT INTO nit_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","అదుంఙ్ ఎత్తి అదున్ కలెకది అన్‍లోపా పాప్ గని అన్‍ తోద్‍. ");
INSERT INTO nit_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","అనంత్తి అండె అన్నె సరీరుత్ సోయ్ తద్ తనయ్‍తొతెద్ ఇసా అనుంఙ్ ఒర్కియ్. సోయ్తదునీ కలెంఙ్ ఇసా అసా అనుంఙ్ వార్సద్ గని, అదున్ కలెకదుంఙ్ అనడ్‍ఎరెద్. ");
INSERT INTO nit_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","అన్ కలత్ ఇసా ఇనెక సోయ్ తదున్ కల్‍సెట, అన్ కల్‍సెట కరాబున్ కల్సనంసాత్ ");
INSERT INTO nit_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","అన్ కలేన్ ఇనెకాదున్ కత్తె అద్ అన్నతి పాప్ మి గని అన్ తోద్. ");
INSERT INTO nit_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","అదుంఙ్ ఎత్తి, “అన్ సోయ్‍ అనెంఙ్ ఇసా అనెంఙ్ కరాబ్ అన్ అన్నత్తిని అన్సాద్” ఇనెకా ఈ నియమున్ అన్‍లోపా పనీ కత్తె తి విచార్ కల్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","సోయ్ అనెకా మన్కకున్ బదోల్ దెయ్యమ్నె నియమ్ సాస్త్రత్ అన్ కుసీ కలత్. ");
INSERT INTO nit_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","గని మరొక్కొ నియ్యమడ్ అన్నె అవయవాల్ అండెత్తి అనుంఙ్ కన్కెర్‍సద్. అద్ అన్నె మనుత్ నియమ్ సాస్త్రముత్ పొరాడుత్ అన్నె అవయవాల్లెంఙ్ పాప్ నియమున్ అన్ కైది కల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","అయ్యో, అన్‍ ఎంతెయ్ దుస్మాన్‍? తికేకదుంఙ్ మెరెత్నా ఈ సరీర్ తన్న ఔరు సాయ్సార్? ");
INSERT INTO nit_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","నేండె ప్రబు యేసు క్రీస్తున్ వాలడ్ దెయ్యముంఙ్ దన్యావద్ స్తుతి కన్నేర్. మాన్ తా ప్రేమ్ కల్సర్ అన్ దెయ్యమ్నె నియములూన్ గులామ్ అండాద్, సరీరున్ బదోల్ పాప్ నియములూన్ గులామ్ అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","అపుడ్ క్రీస్తున్ యేసునత్తి అనెక ఔరుంఙ్ ఎ సిక్సా తోద్ ");
INSERT INTO nit_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","క్రీస్తు యేసున్ పొయ్ పానం సియ్యెక ఆత్మ నియమ్ పాపడ్ తిక్కెక నియమ్ తన అన్ పుస్తిన్. ");
INSERT INTO nit_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ఎనంఙ్ ఇంతే మేనుత్ సబావమున్ సుమ్ముత్ నియమ్ సాస్త్రముత్ బలహీనం అనెకదున్ వాలడ్ అద్ ఎదున్ ఇదరేంఙ్ సలెతేన్ అదున్ దెయ్యమ్ ఇదర్తీన్. మెనున్ తోద్తే ఆత్మన్ అర్తమ్ కత్ అడుగెకార్ నేడత్తి నియమ్ సాస్త్రం సంమంద్ అనెక నీతి విదిన్ తయార్ కలెంఙ్ ఇసా పాపముంఙ్ సటీ అమ్నే సరీరముత్ పాపముంఙ్ సిక్స సితెంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","ఎనంఙ్ ఇంతె సా‍రిర్ నె ఇసొబడ్ నియమ్ సాస్త్రం కమ్‍జోర్ అనెకదుంఙ్ వాలడ్ అద్ ఎదున్ కలెంఙ్ సాలెతినొ అదునీ దెయ్యం కత్తిన్. సరీరమున్ ఎరెకడ్ ఆత్మన్ వెంట బరొస ఇడుత్ అడ్గనెర్ నియమ్ సాస్త్ర కలయ్తద్ నీతి విదిన్ ఇదరెంఙ్ ఇసా పాపులుంఙ్ సటీ దెయ్యం తన్నె సొత పోరకున్ పాప్‍న్నే సరిరడ్ పన్కుత్, సరిరముత్ పాపుంఙ్ సిక్స సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","సరీరాడ్ అనెకర్ సరిరున్ పొయ్ ఆత్మఙ్ కలైతార్ అసా గ్యాన్ ఇడ్‍సార్. ");
INSERT INTO nit_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","సరీర్లంఙ్ మన్ తిక్‍సాద్. ఆత్మ లంఙ్ అనెకా పానం, సమాదాన్. ");
INSERT INTO nit_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","తానుంఙ్ ఇంతె సరీరలంఙ్ అనెకా మన్ దెయ్యముంఙ్ విరోద్ పాని కల్‍సాద్. అద్ దెయ్యమ్నె నియంసాస్త్రముఙ్ కలయేద్, కలయేకా సక్తి అదుంఙ్ తోతెద్నయ్. ");
INSERT INTO nit_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","అదుంఙ్ ఎత్తి సరీర్ సబావ్ దెయ్యముంఙ్ కుసీ కలేర్. ");
INSERT INTO nit_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","దెయ్యమ్నె ఆత్మ ఇమ్మతి వస్తి కత్తె ఇమంతి ఆత్మనె సబావి అన్సాద్. సరీర్నె సబావ్ ఎరెద్. ఎరంతి ఎన క్రీస్తు ఆత్మ తోసెటా అండె అంద క్రీస్తునంతద్‍ ఎరెంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","క్రీస్తు నంత్తి అండె పాప్పుంఙ్ఞ బదోల్ ఇమ్మె సరీర్ తిక్తిన్ గని నీతింఙ్ సటీ ఇమ్మె ఆత్మ పానం అన్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","తిక్‍తరంతన యేసు క్రీస్తున్ సులుప్త ఆత్మ ఇమున్ లోపా అండినింత్తె, అమ్నె తికెకదుంఙ్ తయార్ అనెకా ఇమ్మె సరీరులున్‍ నై ఇమ్మతి బత్కేకా తన్నె ఆత్మనాడ్ బత్కిప్సాంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","అదుంఙ్ ఎత్తి దాదకేర్ బయినే, సరీర్‍ నె ఇసొబడ్ అడ్‍గెకాదుంఙ్ నేండ్‍ అదుంఙ్ తనయ్ కరజ తోతెమ్. ");
INSERT INTO nit_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","నీర్ సరీర్ అనుసర్ అడుగ్తె తిక్కెంఙ్ తయార్ అండాతీర్ గని ఆత్మా సరీరమూత్ కార్యలున్ అలుంఙ్ తే నీర్ బత్కుసాతీర్. ");
INSERT INTO nit_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","దెయ్యమ్నె ఆత్మా ఎంతెమాందిన్ అడిగిప్సారొ, ఔర్ సిమ్కన దెయ్యమ్నె పోరకేర్లంఙ్ అంసాతీర్. ");
INSERT INTO nit_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","తనుంఙ్‍, ఇంతె మల్ల అర్సెంఙ్ పాతన్ ఒర్కి పడుత్ నీర్ సుమ్ తాద్ బానిసాలెత్న ఆత్మ ఏరెద్, దత్తక్ సుం తా పోరక్. ఆ ఆత్మాన్ వలాడి నేండ్, “అబ్బా! బబా!” ఇసా దెయ్యమున్ కూగ్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","నేండ్ దెయ్యమ్నె పోరకేర్ ఇసా ఆత్మ నేండె ఆత్మనాడ్ సక్సి సియ్సాద్. ");
INSERT INTO nit_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","నేండ్ సిన్నా ఎద్దె వరసు లాఙ్. అండె దెయ్యమ్నె వరసు. అనాయ్ క్రీస్తు నత్తి గిన మహిమా రొబాడెంఙ్ అమ్నాడ్ కస్టా సిమ్కన సోసిప్తె, క్రీస్తు నత్తి వరసులం. ");
INSERT INTO nit_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","నేండుంఙ్ సెరెంఙ్ కలెకా మహిమాన్ పఙ్ఙితా కస్టా పొల్సెక ఏరె ఇసా అన్ ఇసానండాత్. ");
INSERT INTO nit_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","దెయ్యమ్నె పోరకేర్ సెద్దెరింతె సమయముంఙ్ సటీ దున్య తార్ గూల్ అసానడ్ కైసనండాద్. ");
INSERT INTO nit_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","తానుంఙ్ ఇంతె తన్నె మన్‍ గు‍రించి ఎర్సెట అదున్ వెంటా అండాద్ కరబ్ కలెకదున్ గురైనా దున్య, ");
INSERT INTO nit_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","కరాబ్ కలెంఙ్ ఎద్దతి బానిసాలెత్న తన కుర్యుత్, దెయ్యమ్నె పోరకేర్ సుమ్ముత్ మహిమత సోయ్త రొబాడ్ గల్సాత్ ఇసా నిరిక్సనాడ్ అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","పఙ్ఙి దూక్ దున్య సిమ్కన ఒక్కొద్ ఎత్న ములుఙ్సా ప్రసవ వేదన పడ్సనండాద్ అదున్‍ నేడుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","అంతేయ్ తోద్, ఆత్మ పేలె పలమూన్ రొంబటార్ నేండ్ గిన దత్తక్ సుం తా పోరక్ సటీ, ఇంతె నేండ్‍ సరీర్ సాయెకదుంఙ్ సటీ ఒర్కిసియ్స లోప లోపాలి ములుంఙ్ఞ స నండాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","తానుంఙ్ ఇంతె నేండ్ ఈ ఆసనాడ్ రక్సన సుం తామ్. నేండ్ కట్సాననెకాద్ కన్కెద్దాపుడ్ ఇంకా బరోసనాడ్ పని తొతేద్. తన్నె ముండట్ కన్కెద్దదూన్ అదుంఙ్ సటీ ఏంద్ కల్సా నండాద్? ");
INSERT INTO nit_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","నేండ్ ఓల్సెటదుంఙ్ సటీ బరోసనాడ్ ఓల్తమింతె, అదుఙ్ సట్టి సైనాడ్ పావొల్సాతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","అనాయ్ పరిసుద్దత్మ గిన నెండె కాంజొరున్ మాదత్ కల్సంద్. తానుంఙ్ ఇంతె నేండ్ బరబార్ ఎనంఙ్ పార్తన కలెకదో ఒర్కితోద్. గని, గొట్టిక్లాడ్ ముడెంఙ్ ఇసా వేల తోసెట మూల్గ్సా పరిసుద్దత్మన్ నేండ్ పకంఙ్ కూగ్సనండాంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","అముదు దెయ్యమ్నె సంకల్పన ప్రకారం పవిత్రులే పక్సంవై కూగ్సనంసాత్. తానుంఙ్ ఇంతె మన్నులున్ సోయ్ ఓలుత్ అమ్నుంఙ్ ఆత్మ అలొసనా తనెదో ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","దెయ్యమున్ ప్రేమ్ కత్ తార్, అముదు తన్నె ఇసొబాడ్ కుగూత్ ఔరున్, సోయ్ ఎన్ననంఙ్ దెయ్యం సిమ్కనన్ కలపూత్ ఎర్గల్సాంద్ ఇసా నేండుంఙ్ ఒర్కి. ");
INSERT INTO nit_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","తానుంఙ్ ఇంతె తన్నె పోరక్ ఎంతెయొ మంది దాదకేర్ పేలెతంద్ అనెంఙ్ ఇస. దెయ్యం పేలెని ఒర్కిల్ తా ఔరుంఙ్‍, తన్నె పోరకున్ పొలీన రూపం సుమ్మెంఙ్ పేలెని నిర్నాయ్ కతెంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","ఎరున్ పేలెని నిర్నయం కత్తెందో ఔరున్ కూగ్తెంద్, ఎరున్ కూగ్తెందో ఔరుంఙ్ నీతిమంతులఙ్ అసతెంద్. అంతేయ్ తోద్, ఎరున్ నితిమంతులఙ్ ఇట్టెంద్ ఔరుంఙ్ మహిమ సియ్తెంద్. ");
INSERT INTO nit_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","ఇదవున్ వాలడ్ నేండ్ తనెవిసతుంమ్? దెయ్యం నేండ్ పకంఙ్ అనె నేండుంఙ్ విరోద్ ఎంద్ ఎద్దద్? ");
INSERT INTO nit_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","తన్నె సొ తా పోరకూన్ నేండుంఙ్ పుకమెయ్ సియెంఙ్ సటీ వెన్కంఙ్ వరెతెంద్ నేండుంఙ్ సదరుంఙ్ సటీ అమ్నున్ సియ్యుత్ దెయ్య అమ్నాడ్ సదరున్ నేండుంఙ్ సియ్సెటా అందదా? ");
INSERT INTO nit_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","దెయ్యం నివ్డిప్తర్ పొయ్ తప్పు ఇదరెకాంద్ అముదు ఏంద్? నిర్దొసిలంఙ్ ఇదరెకాంద్ దెయ్యమి. ");
INSERT INTO nit_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","ఏర్ సిక్సా సియ్సార్? క్రీస్తు ఇసా? తిక్తాంద్, మరి అంతె ఎరెకడి తిక్తతన సుల్తంద్, దెయ్యమ్నె ఉన్నపకంఙ్ ఉదుత్ అనెకద్, నేండుంఙ్ సటీ ప్రర్దనా ఇదరెకాంద్ గిన అమ్‍ది. ");
INSERT INTO nit_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","క్రీస్తు ప్రేమ్ తాన నేండున్‍ ఎరి దౌ కాలెంఙ్ సలేర్? కస్టము, వాలడ్, హింసలు, కరువ్, వస్త్రంహీనత, ఉపద్రవం, తికెకద్, ఇదా నేండున్‍ వెగ్రె ఇదర్సావా. ");
INSERT INTO nit_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","కీర్తన 44: 22 ఇదూన్ వాలడ్ తనేద్ వయూత్‍ అండాద్ ఇంతె, “ఇనుంఙ్ సటీ ఆమ్ రోజి తిక్కెకా తక్లిబ్. లుంఙ్ సటీ తయార్ఇదర్త గొర్రెలంఙ్ అమున్ ఆస్తేర్.” ");
INSERT INTO nit_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","ఇంతే ఇదసిమ్మనాత్ నేడున్ ప్రేమ్ ఇదర్తనున్ వాలడ్ నేండ్ పూర విజేయం రొంబాడద్. ");
INSERT INTO nit_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","అన్ కరే నమ్మెకద్ ఇంతె తనేద్, తిక్కెకాద్, ఎన పానం కాద్ ఎన, దూత్ ఎన, సార్కర్ ఎన, పఙ్ఙి అనెకా ఎన, వరెకా ఎన, సక్తిక్ ఎన, పొదె ఎక్కద్, బూడున్ ఎక్కద్, స్రుస్టిత్ అనెకాద్ పెన తనెద్ ఎన ఎక్కాద్ గని, నేండె ప్రబు క్రీస్తు యేసు నత్తి దెయ్యమ్నె ప్రేమ్ తన నేండుంఙ్ అలది ఇదరెంఙ్ సలే. ");
INSERT INTO nit_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","అనే మన్నుత్ దండి దుక్కం, తిర్సెటా వేదన అండద్. అన్ పైలీ ముడ్సా తొతేన్, క్రీస్తు నంతి సత్తెం ఇడ్సనండతున్. ");
INSERT INTO nit_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","పరిసుద్దాత్మత్ అన్నె మన్ సాక్సి అన్నడ్ కలైయుత్ సాక్ససం ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","సాదీంస్తే, మేన్తా కలైతాద్ లాన్ అనే దాదకేర్, అనే సొ తా జాతితరున్ సటీ, క్రీస్తున్ తన వెగ్రె పడుత్ దెయ్యమున్ ససామున్ దనం ఎరేంఙ్ గిన అన్ తయార్. ");
INSERT INTO nit_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","నీర్ ఇస్రాయేల్. దాత్తక్ సుమ్ తా పోరక్, మహిమ, కరార్లున్, నియమ్ సాస్త్రం ఇనేక బహుమనం, దెయ్యమ్నె అరాదన తా కయ్దలున్, వాగ్దానా ఇవ్రేవి. ");
INSERT INTO nit_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","తొలెనితార్ ఇవ్రి ఔర్. మేన్తా రితినడ్ క్రీస్తు వత్తిన్ కరెయ్ ఇవ్ర తానై. ఇమ్‍దు సిమన అదికారి దెయ్యం, ఎప్పుడి స్తుతియోగ్య, ఆమెన్. ");
INSERT INTO nit_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","అదుహీ దెయ్యమ్నె గొట్టి బాగం ఎద్దేతి తోద్. ఇస్రాయేలు తన వత్తర్ సదర్ ఇస్రాయేలు దెయ్యమ్నె మంది ఎరేర్. ");
INSERT INTO nit_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","అబ్రాహామ్ మున్ సుమ్మతర్ సదర్ కరేవరే దెయ్యమ్నె కీకెలెరేర్, “ఇస్సాకున్ ఎద్దర్ కలయెంఙ్ అవ్రరి ఇనే పడితర్ ఇసా కూగ్సతిర్.” ");
INSERT INTO nit_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","ఇంతే మేన్తా పడితర్ సదర్ దెయ్యమ్నె సినపర్ ఎరేర్ గని దెయ్యమ్నె వాగ్దానం వాలడ్ జన్మిల్ తా సినాపరీ పడితరున్ లెక్కంఙ్ కొర్సార్. ");
INSERT INTO nit_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","ఆ వాగ్దానం గురించి వాక్యం ఇద్దీ, “మలయుత్ ఇద్దీ కాలముత్ వర్సతున్. అప్పుడ్ సారాకున్ పోరక్ జన్మిల్సద్.” ");
INSERT INTO nit_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","అంతే తోద్, రిబ్కా నేండె బాంద్ ఇస్సాకున్ వాలడ్ పేటేనడ్ ఎద్దిన్, ");
INSERT INTO nit_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","దెయ్యమ్నె ఆస్తదున్ వాలడ్ అముదు సంకల్పం, సోయ్ పనికున్ వాలడ్‌ తోద్ ఔరున్ కూగ్తనున్ వాలడ్ గేల్లేకాదున్ సటీ, ");
INSERT INTO nit_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","ఆ పిల్లపడ్సా ఇంకా ఎరెతెర్ సినపర్ ఇంకా జన్మిలుత్ సొబతద్వైట్ ఇదరేంఙ్ పేలెయ్, “దండివలే సిన్నం వలేంఙ్ సేవక్ ఎర్సద్” ఇసా అద్నడ్ ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","ఇదున్ గురించి, “అన్ యాకోబున్ ప్రేమ్ కత్తన్, ఏసావున్ దుస్మన్ ఇదర్తన్” ఇసా వాయుత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","అదుహీ తనేవిందతుమ్? దెయ్యం అన్యాయ్ కత్తినా? ఎరెది ఎరేద్. ");
INSERT INTO nit_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","అదుంగి దెయ్యం మోసేన్ ఇనంఙ్ ఇడ్‍తెద్, “అన్ ఎరున్‍పొయ్ దయ ఓలిపెంఙ్ ఇసాతొ ఔరున్ పొయ్ దయ ఓలిప్‍సాత్. ఎరున్‍పొయ్ కివ్ కలాత్ ఇసాతొ ఔరున్‍పొయ్ కివ్ కల్‍సాత్.” ");
INSERT INTO nit_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","అదుంఙ్ ఎత్తి ఒక్కొద్ ఆసా కలెకదుంఙ్ వాలడ్ ఎక్కద్, ఒక్కద్ తక్లిబ్ ఎరెకదుంవాలడ్ తోద్, దెయ్యం కివ్ కత్తినింతెయ్ ఎర్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","దెయ్యమ్నె లేకనమ్ పరోంఙ్ ఇడ్‍తద్ తనెద్ ఇంతె, “అన్ ఇనంత్తి అన్నె సక్తిన్ ఓలిపెంఙ్‍, అన్నె పేర్ బూమిపొయ్ సదర్ నెరయెంఙ్. ఈ దేసుంఙ్ సటీ ఇన్ నివ్డిప్‍తన్.” ");
INSERT INTO nit_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","అదుంఙ్ ఎత్తి అముదు ఎనున్ కివ్‍కలెంఙ్ ఇసాదొ ఔరుని కివ్‍కల్సాద్, ఎరున్ విరోద్ కలెంఙ్ ఇసాదొ ఔరుని విరోద్ కల్‍సాద్. ");
INSERT INTO nit_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","అనంఙ్ ఎరత్తె, “అమ్నె ఇడ్‍తదున్ కత్న ఓలిపెకద్ ఎద్? ఇంకా అముదు నేండున్‍ గలత్ సుమెంఙ్ తగలెంఙ్?” ఇసా నీ అన్ వేలెంఙ్ సాలతీ. ");
INSERT INTO nit_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","అద్ కరెయ్ గని దెయ్యమున్ ముండట్ వెలెకానీ నివేనీ? దుర్రనే దుత్ తా అమ్మున్ ఇంతిన్ అన్ తనుంఙ్ ఇనంఙ్ కత్తీ ఇసా తయార్ఎదద్ తన్ తయార్ కతదున్ ఇడెంఙ్ సాలదా? ");
INSERT INTO nit_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","ఒక్కొ దురనె ఉండతన ఒక్కొది దుతన్ వాడ్సార్, మరొక్కొ జీర్ వడెంఙ్ సటీ కుమరింఙ్ అదికార్ తోతెదా? ");
INSERT INTO nit_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","అనంగి దెయ్యం తన్నె రగ్గున్ ఓలిపెంఙ్ ఇసా తన్నె ప్రబావమున్ ఒర్కి పర్తెంఙ్ ఇసా కోరుత్న, మసున్‍వై నెమిపుత్న, రగుంఙ్ వరేకదున్ సాబడిప్‍త్తె తనెదా, ");
INSERT INTO nit_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","అదున్‍ వాలడ మహిమ రొంబడెంఙ్ ఇసా అమ్నున్ ముండట్ తయార్ కత్ తా ఆ కివ్ రొంబట బసోడ్ల వాలాడ్, ");
INSERT INTO nit_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","ఇంతె యూదులుంఙి మత్రం తోద్, యూదులెర్సెటర్ తన అంద ఔరున్ కూగ్‍తర్ నేండున్‍ పొయ్, తన్నె మహిమ రుపున్ ఓలిపత్ ఇసా ఇంతె తనెద్? ");
INSERT INTO nit_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","ఇదున్ బదోల్ హోసేయ పుస్తకుత్ అంద ఇనంఙ్ ఇడ్‍సాద్, “అన్నె మంది ఎర్‍సెటరున్ అన్నె మందిన్, ప్రేయసి ఎర్‍సెటదుంఙ్ ప్రేమ్ ఇసా, పేర్ ఇడ్‍సాత్. ");
INSERT INTO nit_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","నీర్ అన్నె మందిన్ ఔరుంఙ్ ఎత్తి ఇడ్‍తిరొ అత్తిని ‘పానం దెయ్యమ్నె పోరక్’ ఇసా ఔరుంఙ్ కూగ్దార్.” ");
INSERT INTO nit_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","28","“ఇస్రాయేల్ పోరకేరె లెక్క సందూర్‍ తా ఇసుకాలంఙ్ అనెంఙ్ మిక్త రక్సన రొంబాడద్.” తానుంఙ్ ఇంతె ప్రబుంద్ తన్నె గొట్టిన్ ఈ బూలోకముత్ జల్ది, పూర కతెంద్, ఇసా యెసయక్ నాయ్ ఇస్రాయేల్ బదోల్ జోరకత్ ఇడ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","యెసయక్ పేలెయ్ ఇడ్‍తెతి, “సైనికుంఙ్ దొడంద్ అనెకా ప్రబుంద్, నేడుంఙ్ పోరకేరున్ ఆప్సెటా అనెంఙ్ ఎద్దె సొదొమ్‍లాంఙ్ ఎత్తనెరామ్, గొమొర్రా అంతన్నెరామ్.” ");
INSERT INTO nit_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","ఇనంఙ్ ఎరతె నేండ్ తనెది ఇనెంఙ్ సాలెమ్? నీతిన్ కిరవ్‍సెట యూదులెర్సెటర్ నితింఙ్‍, ఎన విస్వాసులం నీతిన్ సుంతమ్. ");
INSERT INTO nit_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","ఇంతె ఇస్రాయేల్ నీతి తా నియమ్ సాస్త్ర నియమున్ వెంటపట్టదున్ సుమెంఙ్ సాలెర్. ");
INSERT INTO nit_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","తనుంఙ్? తానుంఙ్ ఇంతె ఔరు అదున్ విస్వాసాడ్ తోద్ తమ్మె పనికున్ వాలడ్ సుమెంఙ్ ఇసా ఓల్‍నెర్ ఔర్ గెట్టలెంఙ్ అడ్డమ్ గుండ్ తాకుత్ బొల్లా రటేర్. ");
INSERT INTO nit_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","ఇదే ఓల్ అన్ సియోనుత్ ఒక్కొ అడ్డమ్ గుండ్‍నాన్. నారాజ్ ఎరెఙ్ తోద్ ఇడసాత్, అంనంత్తి విస్వాసం ఇడ్డెకర్ లజ్జఙ్ వరెర్ ఇసా వాయుత్‍ అనెకద్‍ లంఙ్ ఔరు ఆ అడ్డమ గుండున్ తకుత్, బూడున్ రాటెర్. ");
INSERT INTO nit_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","దాదకేర్, ఇస్రాయేలీయులున్ రక్సన సుమ్మేకదీ అనే మన్ తా విచార్, ఔరున్ బదోల్ అన్ దెయ్యముంఙ్ పార్తన. కల్సాత్ ");
INSERT INTO nit_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","దెయ్యమ్నె గొట్టిత్ ఔర్ పెర్రేత్ అసక్తి తర్ ఔర్‍ ఔర్ బదోల్‍ సాక్సం సియ్‍సతున్. అదుఙి అవ్రే అసక్తిన్ అది అనెకద్ ఎరేద్. ");
INSERT INTO nit_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","అదుహీ ఔరున్ దెయ్యమ్నె నీతి గొట్టిత్ హక్ తొతేద్. కాబట్టి తమే బుద్దినడ్ ఇదరేంఙ్ ఓల్సా దెయ్యమ్నె నీతిన్ విదెయత ఓలిపెతేర్. ");
INSERT INTO nit_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","విస్వాసింసేకంద్ ఒక్కొకొనుంఙ్ నీతి వరేకదున్ సటీ క్రీస్తు నియమ్ సాస్త్రాముఙ్ పూర కతెంద్. ");
INSERT INTO nit_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","నియమ్ సాస్త్ర కరనం ఎద్ద నీతిన్ గేల్లేకంద్ అదున్ వాలడ్ బత్కసంద్ ఇస మోసే వాయ్తేంద్. ");
INSERT INTO nit_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","అదుహీ విస్వాసమున్ కారన్ ఎద్ద నీతిన్ ఇనంఙ్ ఇడ్సద్, “పరలోకాముంఙ్ ఏంద్ సొక్కుత్ సెస్సాంద్? ఇసా ఇమ్మె మన్లెంఙ్ ఇన్నెర్ క్రీస్తున్ అత్రనట్ బుడున్ తొడవారెంఙ్ ఇసా? ");
INSERT INTO nit_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","తోద్తే పతల్ దిపుత్ ఏంద్ డిగ్గుత్ సెద్దాంద్? ఇంతే క్రీస్తున్ తిక్తరంతన ఔరున్ పొదె కోరేంఙ్ ఇసా ఇనే మానుత్ ఇన్నేమ్.” ");
INSERT INTO nit_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","గని ఆ నీతి తనేన్ ఇడ్సదో ఓలుర్, “దెయ్యమ్నె వాక్యమ్ ఇముఙ్ మెరా, ఇంమే మూతిత్, ఇంమే మన్నుత్ అండద్.” అమ్ ఇదరేకా విస్వాసం కలైతా హక్ గిన ఇద్దీ. ");
INSERT INTO nit_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","అద్ తనేంద్ ఇంతే యేసున్ ప్రబున్ ఇంనే మూతినడ్ ఒప్పుత్, దెయ్యం అమ్నున్ తిక్తరంతన అమ్నున్ పానం వర్గత్ సుల్పతేంద్ దిన్తె ఇనుంఙ్ మనుత్ నమ్తివింతె ఇనుఙి సోయ్ ఎరద్. ");
INSERT INTO nit_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","ఎనంఙ్ ఇంతే మన్కక్నే నీతింఙ్ సటీ మన్నుత్ నమ్సంద్, పాప సోయ్‍ఎరెంఙ్ ఇసా మూతినాడ్ ఒప్సాంద్ అద్ ఇమ్ముఙ్ రక్స ");
INSERT INTO nit_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","“అంనంతి బరొస ఇట్టద్ ఏదీ లజ్జంఙ్ వడేద్” ఇస దెయ్యమ్నె లేకనముత్ ఇడ్సద్. ");
INSERT INTO nit_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","ఇంతీ యూదులే, గ్రీకు లూ ఇనేక బెత్బవ్ తొతే. ఆ దెయ్యం మీ సదరున్ ప్రబుంద్. అముదు తనుంఙ్ పార్తన ఇదరేకారున్ సదర్ మందిన్ డాప్సెటా ఆసిర్వాద్ సియ్యెకాద్. ");
INSERT INTO nit_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","తనుంఙ్ ఇంతే ప్రబునే పేరడ్ పార్తన ఇదరేకరుఙ్ సదర్ సోయ్ మందినె పాపు కండిల్సా ఇసా వాయుత్ అండాద్. ");
INSERT INTO nit_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","నమ్సేటనుంఙ్ ఔర్ ఎనంఙ్ పార్తన ఇదర్సరొ? తమ్ విసేట ఎనంఙ్ నమ్తేర్? అమ్నున్ గురించి ఇడ్డెకర్ తొసేట ఔర్ ఎనంఙ్ విన్దర్? ");
INSERT INTO nit_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","ఇడ్డెకారున్ పావిడ్సేటండే ఔర్ ఎనంఙ్ ఇడ్దర్? ఇదున్ గురించి, “సొబతా వున్ గురించి సోయ్తా కబుర్ ఇడ్డేకనే అమ్మనే గేట్ట ఎంతెయొ సొబతా” ఇసా వాయుత్ అండ. ");
INSERT INTO nit_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","మల్లా సదర్ మంది సువార్తన్ సిన్నం ఎరేతెర్. “ప్రబు, అమే సందేసమున్ ఎరి నమ్మేర్?” ఇసా యెసయక్ ఇడ్సనండద్ తా? ");
INSERT INTO nit_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","అదుహీ వినేకదున్ వాలడ్ విస్వాస్ వర్సద్. వినేకంద్ క్రీస్తున్ వాలడి గొట్టిక్ వినేకాద్. ");
INSERT INTO nit_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","ఎంద, అన్ ఇడ్డెకద్ తనేంద్ ఇంతే, “అవ్రు వినేతేరా? విన్తేర్ తా? ఔర్లంఙ్ దున్యత ర్ సదర్ అవ్రే గొట్టికున్ బుజడిప్తేతి బూమి తిర్తదుంఙ్ ఎంత్ గదితిన్ ఇసా వాయుత్ అండద్.” ");
INSERT INTO nit_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","అన్ ఇంకా ఇండేకద్ తనెంద్ ఇంతే, ఇస్రాయేలు మందిఙ్ ఇద్ కరిలెతినా? మోసే పేలెని ముడుత్, “అసల్ జాతిక్ ఇస కూగెకరున్ మోకతోతెద్ ఔరున్ వాలడ్ ఇమ్మున్ రగ్గున్ వర్గల్సర్ తెలివి తోసెటర్ మందిన్ వాలడ్ ఇమ్మున్ సటీ ఎరేకర్లన్ ఇదర్సర్” ఇసా ఇంతేద్. ");
INSERT INTO nit_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","మల్ల యెసయక్ ఇంమతడ్ ఇనంఙ్ ఇంతేద్, “అన్ కిరవ్‍సెటద్ అన్ రొంబప్తేద్. అన్ బదోల్ వేల్సెటనుంఙ్ అన్ కన్కెద్దాన్.” ");
INSERT INTO nit_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","ఇస్రాయేలులే గొట్టిక్ ఎద్దే అముదు, ఇడ్తవిసెటాం ఉల్టా తిరుగుత్ ముడేకా మందిన్వైనీ అన్ రొజి అనే కేయ్యు చాపుత్ కూగ్స నండాత్ ఇసా ఇడ్సనండద్. ");
INSERT INTO nit_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","అనఙ్ ఎంద్ అన్ వేలేకద్ తనేంద్ ఇంతే, దెయ్యం తనే మందిన్ సయుత్ సెద్దిన? ఎరిది ఎరేద్. అన్ గిన ఇస్రాయేల్ తనున్, అబ్రాహామ్నే కదానుత్ బేన్యామీన్ కాందానుత్ పుట్తద్. ");
INSERT INTO nit_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","తన్ ముండట్టీ ఒర్కిత తనే మందిన్ దెయ్యం సయుత్ సెరేతీన్. ఏలీయా గురించి లేకనబాగంముత్ ఇడ్డతిన్ ఇముంఙ్ కరిలెదా? అముదు ఏనంఙ్ ఇస్రాయేలుకున్ ఉల్టా దెయ్యమున్ ముడట్ వాద కత్తంద్ లేకన బాగముత్ ఇడ్తద్ ఇముంఙ్ కరిలెదా? ");
INSERT INTO nit_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","“ప్రబు, ఔర్ ఇనే ప్రవక్తకేరున్ అల్ఙంతెర్, ఇనే బావ్ సియ్యెక జాగలూన్‍ ఒదిరిప్తేర్. అన్ ఒక్కొననీ మిక్తా తాన్. ఔర్ అన్ గిన అల్ఙేంఙ్ ఓల్సనండర్.” ");
INSERT INTO nit_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","అదుఙి అమ్నుంఙ్ దెయ్యం సియ్ తా సమాదానున్ విన్డ్రు, “బయలున్ మొక్కెంఙ్ ఏడ్, అజాల్‍ మంది పడ్సీల్ అనుంఙ్ అండార్.” ");
INSERT INTO nit_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","పేలెనిత ఆస్త ప్రకరం ఇండి గిన కృప వత్ తయార్ ఎద్దిన్ గని కొంసెం మిక్కూత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","అద్ కృప వాలడ్ ఎద్దద్ ఎద్దే అద్ పనికున్ మూలం ఎద్దద్ ఎరేది. అనంఙ్ ఎర్సేటండే కృప ఇంక కృప ఎర్సేటది. ");
INSERT INTO nit_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","అప్పుడ్ తనేద్ ఎద్దిన్? ఇస్రాయేలు మంది తనేదున్ కిరవ్‍తెరొ అద్ ఔరున్ రొబడేతిన్, దెయ్యం ఆస్తదుంఙ్ వాలడ్ వత్తనుంఙ్ అద్ రొబటిన్. మిక్తర్ తమే గుండేన్ కటిన్ ఇదర్తేర్. ");
INSERT INTO nit_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ఇద్దున్ బదోల్, “ఇండిదూక్ దెయ్యం ఔరున్ మఙ్ నంత్తెంఙ్ మన్నుత్, ఓల్సెట కడ్లు, విసేట కేవ్వు సితేంద్” ఇసా వాయుత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","ఇదున్ దావిద్ తనేవింతేంద్ ఇంతే, అవ్రే తినేకా ఔరి ఒక్కొ జార్, ఒక్కొఅడ్పా, ఒక్కొ అడంమ్ గుడ్డులన్, ఒక్కొ ప్రతేకర పనిలంఙ్ అనేంఙ్ గాక. ");
INSERT INTO nit_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","ఔర్ ఓల్సెటర్లంఙ్ అవ్రే కల్లున్ చిర్మనా ఎరేంఙ్ గాక; అవ్రే విపు ఎప్పుడు వంఙ్ దుక్ అనేంఙ్ గాక. ");
INSERT INTO nit_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","అదుహీ అన్ వేలేకద్ తనేద్ ఇంతే, ఔర్ యూదు రాలేంఙ్ సటీ లాంకీపట్టెర్? అనంఙ్ ఎరేది ఎరేద్. అవ్రే లంకిన్ వాలడ్ యూదు లెర్సెటరున్ గలత్ పాపం కరిల్తిన్. అద్ యూదులే రక్స కొరేంఙ్ కారనం ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","అవ్రే అపరద్ దున్యంఙ్, అవ్రే లాస్ గలత్ యూదులెర్సెటరున్ ఐస్వర్యంలన్ అండే, అవ్రే పూరా ఇంక ఎంతే పేర్రేత్ ఐస్వర్యం ఎంతనదొ! ");
INSERT INTO nit_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","యూదు లెర్సెటరుంఙ్ ఇమ్మడ్ అన్ ముడ్సనండత్. అన్ ఇంక్కొకొ జాతిత కబుల్లాకెర్ అండదున్ అనే ఒర్కితరున్ పనినాడ్ మాన్ సీసతున్. ");
INSERT INTO nit_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","ఎనఙ్ ఎనా అనే సరీర బత్క కలైతన్ రంఙున్ కొరేకదున్ వాలడ్ అవ్రతి కొన్సెం మంది ఎనఙ పోరయైద్ ఇసా అనే విచార్. ");
INSERT INTO nit_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","ఔర్ రంఙున్ సుమ్మేకద్ దున్యత్ దెయ్యంనడ్ సమదానడ్ ఇదరేకద్ మరి, ఔరున్ మాన్ సియెకర్ తిక్ తార్ నైయ్ ఔర్ పానం త్ అనెకర్ సుల్తెతి ఏర్సద్ తా? ");
INSERT INTO nit_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","పేలెనితద్ పిడ్డి కడి పిండి ముద్దా సొబతద్ ఎద్దే ముద్దా సొబ తావీ. వేల్ల్ పవిత్ర కొమ్ము గిన సొబ తావీ. ");
INSERT INTO nit_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","అదుహీ కొమ్ములంతి కొన్నిగున్ కత్కుత్ జొపిటే, అడవితా ఒలీవ కొమ్ములొట ఇంన్ అద నడుమున్ సిప్పనా కట్టుత్, ఒలీవ మాకుత్ పొడమ్ అనెక వేరుత్ ఇనుంఙ్ జాగ సియ్తే, ");
INSERT INTO nit_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","నీ ఆ కొమ్ము పొదె వేల్లుత్ తోద్. తనుంఙ్ ఇంతే వేరి ఇన్ ఆప్సద్ గని నీ వేరున్ అపెంఙ్ సాలే. ");
INSERT INTO nit_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","అదుహీ, “ఆ కొమ్ములున్ కత్కతిన్ అన్ కలపుత్ కట్టేంఙ్” ఇస నీ ఇడ్డేంఙ్ వంద్. ");
INSERT INTO nit_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","కారేయ్. అవ్రే అవిస్వాసమున్ వాలడ్ కినుకుత్ జొపిడేకద్‍ ఎద్దిన్ నిఎద్దె విస్వాసమున్ వాలడ్ ఇలుత్ అడ్డతి. ఇనేత్ నీ పొ తా కల్సెట అర్రిఙ్ అర్సుత్ అన్. ");
INSERT INTO nit_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","తనుంఙ్ ఇంతే దెయ్యం సదర్న కొమ్ములుని సయేతిన్ తే ఇన్ గిన సయేద్ తా! ");
INSERT INTO nit_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","అదుహీ దెయ్యమ్నె దయన్, అమ్నే కటినున్ ఓల్. ఇంతే అమ్నున్ ఒక్కొ పక్కఙ్ రాట యూదు పొదె కటినున్ ఓలిప్తేంద్. ఇక్కొకొ పక్క నీ అమ్నె దయత్ ఇలుత్ అండే ఇన్ పొదె తనే దయన్ ఓలిప్సాద్. నీ అనంఙ్ ఇలుత్ అన్సెటండె ఇన్ గిన కత్కుత్ జొపిడ్సద్. ");
INSERT INTO nit_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","అంతే ఎర్సెట, ఔర్ తమే అవిస్వాసమున్ వగిప్సేట వేనకావై తిర్గతే ఔరున్ తిరుగుత్ నెడత్తి కలప్సార్. దెయ్యం ఔరున్ మల్ల నెడత్తి కలపేంఙ్ సాలెకాంద్. ");
INSERT INTO nit_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","ఏనంఙ్ ఇంతే, ఇన్ ఒక్కొ అడవితా ఒలీవ మాక్ తన తరుగుత్, సదర్నంగా సొబ తా ఓలివ మాకుత్ కలపుత్ కట్టేన్ సల్తద్ అముదు సదర్నంగా కొమ్ములున్ మరి కారేయ్ అమే సొంత ఓలివ మాకున్ కలపుత్ కటెం తా! ");
INSERT INTO nit_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","దాదకేర్ బయినేవరా, ఇమ్మేత్ నిరీ ఉసార్ ఇస తల్ వంప్సేట అనేంఙ్ ఇస ఈ డప్ తాదున్ సత్యమున్ నీర్ ఒర్కిలేంఙ్ ఇసా అన్ ఇసాతున్. అద్ తనేంద్ ఇంతే, యూదులెర్సెటరె వరేకద్ మూరైయ్ నత్తెంఙ్ ఇస్రాయేలు మందినంతీ కొన్సెం కటిన్ ఎద్దిన్. ");
INSERT INTO nit_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","ఇస్రాయేల్ “సాయెకంద్ సియోను తరన్ వత్ యాకోబు తన బక్తి హినులున్ పుస్సర్. ");
INSERT INTO nit_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","అన్ అవ్రే పాప్ ములున్ పుసుత్ జొపిడె ఙ అవ్రరాడ్ అన్ ఇదర్సెట కరార్ ఇద్” ఇసా వాయుత్ అండేతి ఇస్రాయేలు మంది సదర్ రక్సన సుమ్మతేర్. ");
INSERT INTO nit_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","సొయ్త కబుర్ గొట్టి ఎద్దే ఇమ్మున్ వాలడ్ ఔర్ విరోద్ సుమ్ముత్ అనేంఙ్ వద్ గని, దెయ్యమ్నె ఆస్త గొట్టిత్ ఎద్దే పితరులూన్ వాలడ్ ఔర్ దెయ్యమున్ లాడ్తంద్. ");
INSERT INTO nit_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","తనుంఙ్ ఇంతే, దెయ్యమ్నె కృప వరా బాదొల్, దెయ్యం మన్నున్ బద్లిప్ పెంద్. ");
INSERT INTO nit_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","గతముత్ నీర్ దెయ్యమున్ దయ సుంతీర్ అవిదేయులు. అండిర్ గని పఙ్ పఙ్ఙి యూదులు విసేటంద్ నీర్ కివ్ రొంబట్టిన్. ");
INSERT INTO nit_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","అనైయ్ ఇమ్ పొదె ఓలిప్ తా దయన్‍ వాలడ్ పఙ్ పఙ్ఙి కనికరం సుమ్మేంఙ్ సటీ, ఔర్ పఙ్ పఙ్ఙి అవిదేయులుగా అండర్. ");
INSERT INTO nit_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","సదరున్ పొదె తనే కివ్ ఓలిప్ తాన్ ఇస, దెయ్యం సదరునీ ఆగ్య పాడిప్సెటదుంఙ్ వాలాడ్ ముసుత్నా కొండప్తేర్. ");
INSERT INTO nit_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","అమ్మొ దెయ్యమ్నె తేలివి, బుద్దిత దండి ఎన్తే యో గుండి! అమ్నె న్యాయులున్ పరిక్సి ఇదరేకద్ ఎరే తరం అమ్మనే పావు నేమె విచరున్ గదియే. ");
INSERT INTO nit_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“ప్రబునె మన్నున్ ఒర్కిల్ తాద్ ఎద్? అమ్మునుంఙ్ అదర్ ఎరేకద్ ఎద్? ");
INSERT INTO nit_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","అమ్నత్ తన పెన ఎకత్ తనెని సియ్తెదా ఇసా ముడటీ అమ్‍నుంఙ్ సియెకాద్ ఎద్?” ");
INSERT INTO nit_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","సమస్తమూ అమ్నున్ ములంఙ్, అమ్నున్ వాలడ్, అమ్‍నుంఙ్ సటీ అండ. యుగయుగాలున్ అమ్మునుంఙ్ మహిమ కరెయ్ ఎరేంఙ్ గాక. ఆమెన్. ");
INSERT INTO nit_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","అదుంఙ్ ఏత్తి దాదకేర్ బాయినేవరా, దెయ్యమ్నె ప్రేమనాడ్ ఇమూన్ వింతి కల్సానండతుమ్, పవిత్ర, దెయ్యముంఙ్ మనుంఙ్ వత పాపం తొసేట సియ్యుత్ ఇమ్మె మెన్లూన్ సియుర్. ఇద్ నీర్ ఇదరేకా బత్క కలైతా సేవ. ");
INSERT INTO nit_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","నీర్ ఈ కాడుత్ తా పద్దాతినాడ్ అడ్గెంఙ్ తోద్. ఇమ్మె మన్ బద్లిలుత్ కొత్త రూప్ బద్లిల్ తాద్ వాలడ్ సోయ్ తది, పాజే అండ పురా ఎద్దా అమ్నే దెయ్యమ్నె విచారున్ కారిపుత్ ఒర్కిలుర్. ");
INSERT INTO nit_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","దెయ్యం అనుంఙ్ అనుంఙ్ సియ్ తా కృప వాలడ్ అన్ ఇండేకద్ తనేద్ ఇంతే, ఇమ్మత్తి ఎర్ తన్నేత్ తని అసేకదున్ ఎనా పేర్రేత్ అసేంఙ్ తోద్. దెయ్యం పాయుత్ సియ్ తా విస్వాసం కయ్దానడ్, ప్రతి ఒక్కొద్ ఇడ్సాంద్. ");
INSERT INTO nit_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","ఎనంఙ్ ఇంతే ఒక్కొ మెనుత్ నేడున్ ఎన్నిగొ వస్తు అండ సటీంఙ్, అదవున్ సదర్ ఒక్కొది పని అనేంద్. ");
INSERT INTO nit_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","అనైయ్ నేండ్ అనేఙ క్రీస్తు నంతి ఒక్కొ మెన్లన్ అంత్న, ఒక్కొనేత్ ఒక్కొద్ ఎకంగా వాస్తులాడ్ అండతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","దెయ్యం నేడుంఙ్ సియ తా కృప కయదనాడ్ ఎన్నిగొ రకాలడ్ కిస్మత్ తా వరమున్ కలైయుత్ అండతుమ్. అదుహీ, ప్రవచనల వరం ఎద్దే విస్వాసంత పరిమనంముత్ కయదలత్తి సోఙేంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","సేవ కలేకరం సేవకలెంఙ్ ఇడేకర్‍ ఇడేంఙ్ ఇమత్ సియెకర్ ఇమత్ సియెంఙ్ పాయేకద్ జోరనాడ్ పయెంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ఇడ్డెకా వరం అనెకాంద్ ఇడెంఙ్. బోద ఇడ్డేకా వరంతద్ బోద ఇడ్డెంఙ్. హిమ్మత్ సియెక వరం అన్నెకర్ ఇమత్ సియుర్, పైయెకార్ పూర పైయెంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","ఇమ్మె ప్రేమ్ కప్టి అనేంఙ్ తొద్. కరాబున్ రొయుత్ సోయ్ తాదున్ అసుర్. ");
INSERT INTO nit_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","దదాక్నే ప్రేమనడ్ ఒక్కొ పొదె ఒక్కొద్ పానం ఇదర్సా, మాన్ సియెకత్తి ఒక్కొనుంఙ్ ఒక్కొద్ పొటిపడుర్. ");
INSERT INTO nit_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","జిద్దడ్ గొట్టిత్ వేనుకా పడేంఙ్ తోద్, ఆత్మత్ జోరకత్ ప్రబునున్ సేవకల్. ");
INSERT INTO nit_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","ఆసనడ్ పావ్ ఓల్సా కుసీకలుర్. కస్టముత్ సంఙ్ఙ్ ఎర్సా, పార్తనత్ బరోసనడ్ అండ్రర్. ");
INSERT INTO nit_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","పవిత్ర లంఙ్ అవసరంమున్ అసర్ ఎర్సా, చుట్టలున్ సొబనడ్ ఓలుర్. ");
INSERT INTO nit_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","ఇమ్మున్ విరోద్ కలెకరున్ పార్తన కాలుర్ గని విరోద్ కన్నేర్. ");
INSERT INTO nit_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","కుసీకలేకర్ వెంట కలైయుత్ కుసీకలుర్. దుక్కంమడ్ అనెకర్ వెంట కలైయుత్ దుక్కంమడ్ అన్నెర్. ");
INSERT INTO nit_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","ఒక్కొనెత్ ఒక్కొద్ ఒక్కొ మాన్ను కలైయుత్ అండ్రు. దండి గొట్టిక్ వాలడ్ విచార్ కలేంఙ్ తోద్. కాలయుత్ అడ్కుర్. ఇమ్మేత్ నిరి గ్యాన్ అండద్ ఇంతేతి ఇండ్రర్. ");
INSERT INTO nit_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","సక్నమున్ ఇక్కొకొ సక్నం ఇదరేంఙ్ తోద్. మన్కకేరుంఙ్ సదరుంఙ్ ఎద్ సోయొ అద్ది ఇదరూర్. ");
INSERT INTO nit_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","ఇముంఙ్ కెయ్తేందద్ నమ్తె మట్టిన్ సదరున్ సమాదానడ్ అనేంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","లాడ్తంద్ సక్ తాకేరె, రగ్ సుంమేగ్ తోద్. దెయ్యమ్నె రగ్గున్ జాగా సియుర్. “రగ్గున్ న్యాయ్ కలెకద్ అన్నె పని, అని పాయ్దా సియ్సాతున్ ఇసా ప్రబువు ఇడ్సద్” ఇసా వాయుత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","“అదుఙి, ఇనే విరోద్ కరువుత్ అండే అమ్నుఙ్ అంబా సియ్, అడ్డుత్ అండే ఈర్ సియ్. అనంఙ్ ఇదరేకద్ వాలడ్ అమ్‍నెతల్ పొదె నిప్కా కుప్ప పేయ్తేతి ఎర్సద్.” ");
INSERT INTO nit_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","కరాబ్ ఇమున్ పొయ్ గెల్లెంఙ్ ఇడ్సెటా సోయ్ అండ్రు. ఉచరడ్ కారబున్ గెల్లుర్. ");
INSERT INTO nit_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","ప్రతి ఒక్కొద్ తనే అదికారంమున్ రొబడేన్. తనుంఙ్ ఇంతే దెయ్యమున్ వాలడ్ అదికార్ ఎద్దిన్. పఙ్ఙి అనెక అదికారం దెయ్యం పాన గడిప్ తావీ. ");
INSERT INTO nit_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","అదుహీ అదికార్ మున్ అర్సిపెకంద్ దెయ్యమ్నె నియ్యమున్ అర్సిప్సంద్. అదున్ వాలడ్ అముదు తన్నెత్ తనుంఙ్ పఙ్ఙి సిక్స కొర్సంద్. ");
INSERT INTO nit_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","వాగిపెకార్ అదికార్ కరాబ్ పనికుఙీ అస్సార్ గని సోయ్ తా పనికున్ తోద్. ఔరున్ అర్సెటా అనెఙ్ ఇంతే, సోయ్త పానిక్ కాలెఙ్. అపుడ్ ఔర్ ఇన్ మన్నుఙ్ కొర్సార్. ");
INSERT INTO nit_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","ఔర్ ఇనే సోయ్ సటీ అండ దెయ్యమ్నె సేవకేర్. మరి నీర్ కరాబ్ పనిక్ ఇదర్తే అర్రీంఙ్ అర్సెంఙ్. ఔర్ కారనం తోసేట రుసిక్ సుమ్మేర్. ఔర్ కరాబ్ ఇదరేకర్ పొదె రగ్గడ్ డావ్ ఇదరేకా దెయ్యమ్నె గడియకున్. ");
INSERT INTO nit_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","అదుఙి పక్త ఔరే రగ్గున్ గురించి అర్రి తొసేట ఇనే మన్ సాక్సిన్ వాలడ్ గిన అదికారులున్ మెర అన్నెంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","ఈ కారన్ వలాడి నీర్ పన్ను వడ్డి కట్సనండతిర్. తనుంఙ్ ఇంతే అదికారిక్ ఎప్పుడి ఈ పనీతి దెయ్యమ్నె సేవకేర్లాంఙ్ సేవ ఇదర్సనంసర్. ");
INSERT INTO nit_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","ఎరుఙ్ ఎద్ పజే అద్ ఔరుఙ్ సియ్యెకాద్. వడ్డి రున పడుత్ అండే పన్ను వడ్డి, సుంకాలు కర్జ ఎత్ అండే సొతఙ్ నిడ్పుర్. మన్ సియెకాద్ అండే, మాన్ సియెకాద్ అండే ఔరుంఙి మాన్ సీయుర్. ");
INSERT INTO nit_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","ప్రేమ్ గొట్టిత్ తప్ప గని తనేవి ఎరుఙి జీమెదర్ పడుత్ అనేంఙ్ తోద్. పకతరుంన్ ప్రేమ్ కలేకద్ నియమ్ సాస్త్రామున్ గేల్తద్. ");
INSERT INTO nit_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","తనుంఙ్ ఇంతే చినలి ఇదరేంఙ్ తోద్, హత్య ఇదరేంఙ్ తోద్, డొంఙ్ ఙ పనిక్ ఇదరేంఙ్ తోద్, ఇంక్కొకొరేత్ అసా ఒగ్గెంఙ్ తోద్ ఇనెక, మరింకె ఆగ్య ఎనా అండే అద్, “ఇనెత్ నివీ ప్రేమ్ కత్తెతి ఇనే పకతరుంఙ్ ప్రేమ్ కల్” ఇనెక వాక్యముత్ కలైయుత్ అండ. ");
INSERT INTO nit_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","ప్రేమ్ పకతరుంఙ్ సక్నం ఇదరేద్ అదుఙి ప్రేమ్ పుట్టూత్ అనేంఙ్ ఇంతే నియమ్ సాస్త్రామున్ గేల్తేతియ్. ");
INSERT INTO nit_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","అదుహీ నీర్ కాలమున్ ఆదికత్న, జొప్తన సులెకా వేల ఎద్దినిసా రక్స ఒర్కిలుర్. నేండ్ పేలె విస్వాసుల్ ఎద్ద అప్పుడ్, నేండె నేండ్ గెల్లెకాంద్ కుబ్బెనా మేర గదితీన్. ");
INSERT INTO nit_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","సింతే గుల్ పెర్రెత్ గడి ఎత్ వేన్ తా వేలంఙ్ వత్తిన్ అదుహీ నేండ్ చికటి కార్యమున్ సయుత్న వెలుంఙ్ జాగ్డకత్ కలైతా అయుదలున్ సుంనాడ్. ");
INSERT INTO nit_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","అగామ్ విరొదులున్, ఉండా జిఙ్ఙవత్, ఎద్దర్ రితిత్ అడ్డమ్ ఎర్సెటా సినలి ఆస, జాగడ, అసూయ, ఆసన్ సంబడిప్సెటంద్ దుప్పరి వెలుంఙ్ దుక్ లంఙ్ మానడ్ అడ్గనెర్. ");
INSERT INTO nit_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","ఆక్రిత్ ప్రబు యేసు క్రీస్తున్ ఒర్కిలుర్. మేనుంఙ్ అని అద్నే కదానుంఙ్ జాగా సినేడ్. ");
INSERT INTO nit_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","విస్వాస్ బదోల్ కమ్జొర్ అనెకరుంఙ్ మెర కలుర్ గానీ ఔరె అనుమానలున్ బరబర్‍ ఇదరెంఙ్ లొల్లికనెర్. ");
INSERT INTO nit_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","తినెకా సిమ్కనైయ్ తినెంఙ్ వంద్ ఇసా ఒక్కొద్ నమ్మతె, ఇక్కొకొద్ నమ్సేట తర్కరియి తిసన్సద్. ");
INSERT INTO nit_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","తినేకాద్ తింన్కాద్ అమ్మున్ చినం సుపు ఓలేంఙ్ తోద్. తినెకాద్ అముదు తినేకనున్వైని నింద డొపేంఙ్ తోద్. తనుంఙ్ ఇంతే దెయ్యం ఔరున్ మెరా కాల్సంద్. ");
INSERT INTO nit_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","ఇంకొక్కొంద్ సేవ కలెకద్ గొట్టిత్ న్యాయం ఇండెకాని నీ వెనివేన్నీ? అముదు ఇల్తేనా, రాటేనా అముదు అమ్నె మాల్కక్ ఓల్సద్. గని అముదు ఇల్సద్. ప్రబుంద్ అమ్నున్ ఇల్పెంఙ్ సటీ సక్తి అండద్. ");
INSERT INTO nit_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","ఇంక్కొకొ జాగత్ ఒక్కొద్ ఒక్కొ దినముంఙ్ ఎనా ఇక్కొకొ దినం సొబ తాద్ ఇసా నమ్సంద్. ఇక్కొకొద్ దినా సిమ్కన సొబ తావీ ఇస నమ్సంద్. ప్రతి ఒక్కొద్ అమ్‍నెంత్ అమ్‍ది ఒక్కొ గొట్టిన్ వరెంఙ్. ");
INSERT INTO nit_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","ప్రత్యెకామై సిమ్కన దినాలుంఙ్ వగిపేకంద్ ప్రబునున్ సటీని ఆ పని ఇదర్సద్. తినేకాంద్ దెయ్యమున్ దన్యావద్ ఇదర్సంద్ అదుఙి ప్రబునున్ సటీ తిసనండద్. అనైయ్ తిసెటంద్ గిన దెయ్యమున్ కృప ఇడ్డుత్ ప్రబునున్ సటీ తినేకంద్ మద్సద్. ");
INSERT INTO nit_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","నెడత్తి ఏదీ తనుంఙ్ సటీని బత్కెంద్, తనుంఙ్ సటీ తిక్కెంద్. ");
INSERT INTO nit_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","నేండ్ బత్కతేనా ప్రబునున్ సటీని, తిక్తేనా ప్రబునున్ సటీ. అదుహీ నేండ్ బత్కతేనా, తిక్తేనా ప్రబువునంతినీ కలైయుత్ అండతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","తిక్తరుంఙ్ పానం అనెకరుంఙ్ ప్రబుఙా అనెంఙ్ ఇసాని తా క్రీస్తుంద్ తిక్కుత్ మల్ల పానం వతెంద్? ");
INSERT INTO nit_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","మరి ఇనే దాదకున్ తనుంఙ్ న్యాయం ఇదర్సనండతీ? ఇనే బాయిన్ తనుంఙ్ న్యాయం ఇదర్సాతొతే? నేండ్ సదర్ దెయ్యమ్నె న్యాయ్‍పీట ఇదారెకాద్ ముదర్వై ఇల్సతుమ్. ");
INSERT INTO nit_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","అల్లరి తొసేట బత్కేకారాన్ అన్ ఇడ్డెకద్ తనేంద్ ఇంతే, ప్రతి ఒక్కొ ముడ్సు ముదర్వై వంఙ్ ఙసా ప్రతి నాల్క దెయ్యమున్, స్తుతి కల్సద్ ఇసా ప్రబుంద్, ఇడ్సనండద్ ఇసా వాయుత్ అండద్. ");
INSERT INTO nit_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","అదుహీ నెడత్తి ప్రతి ఒక్కొద్ తన్నె బదోల్ దెయ్యమున్ తన్నెత్ తాని లెక్క ఇడ్సానానేంఙ్ పాజే. ");
INSERT INTO nit_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","అదుఙి ఇండి తన నేండ్ ఒక్కొనేత్ ఒక్కొద్ న్యాయ్ కాలెంఙ్ తొదొ. అదున్, నేండ్ దాదకున్ అని బాయినెవుఙ్ అడ్డమ్ గుండ్లంఙ్ అడ్మం అనేంఙ్ తోద్ న్యాయ్ ఇదర్నడ్. ");
INSERT INTO nit_vpl VALUES ("RM14_14","075_14_14","ROM","14