﻿USE sofia;
DROP TABLE IF EXISTS sofia.ninNT_vpl;
CREATE TABLE ninNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ninNT_vpl WRITE;
INSERT INTO ninNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Uwanggo yo a si are ka uga ku Yesu Kristi ka. Yesu à zhi nu uki ku uttu Doda, u Doda a zhi nu uki ku Ibrayi. Uwanggo yo a si asa a ábáchí ma wa. ");
INSERT INTO ninNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrayi à si aki a Ishaku. Ishaku à si aki a Yakubu. Yakubu à si aki a Yahuda na amuyirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuda à si aki a Perrezi tuku Zerra, (Ayirr ambarr wa à si Tama). Perrezi à si aki a Hezroni. Hezroni à si aki a Ramu. ");
INSERT INTO ninNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramu à si aki a Aminada. Aminada à si aki a Nashoni. Nashoni à si aki a Salimo. ");
INSERT INTO ninNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimo à si aki a Bowazi. (Ayirr ama wa yo à si Raha). Bowazi à si aki a Obedi. (Ayirr ama wa yo à si Rutu.) Obedi à si aki a Jesi. ");
INSERT INTO ninNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi à si aki a Doda. Doda à si aki a Solomo. (Ayirr ama wa yo à si Basheba, ayamba a Urriya.) ");
INSERT INTO ninNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomo à si aki a Rehobowa. Rehobowa à si aki a Abija. Abija à si aki a Asa. ");
INSERT INTO ninNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa à si aki a Jehoshafa. Jehoshafa à si aki a Jehorramu. Jehorramu à si aki a Uziya. ");
INSERT INTO ninNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziya à si aki a Jotamu. Jotamu à si aki a Ahazi. Ahazi à si aki a Hezekiya. ");
INSERT INTO ninNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hezekiya à si aki a Manase. Manase à si aki a Amoni. Amoni à si aki a Josiya. ");
INSERT INTO ninNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiya à si aki a Jekoniya na amuyirr ba. (Na ase ka nggo a vɨ anu Israila ba igarr yi na ko nu Babilo.) ");
INSERT INTO ninNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nu ugo ku igarr ku nu Babilo: Jekoniya à si aki a Sheyalitiye. Sheyalitiye à si aki a Zerrubabe. ");
INSERT INTO ninNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerrubabe à si aki a Abiyudu. Abiyudu à si aki a Eliyaki. Eliyaki à si aki a Azorr. ");
INSERT INTO ninNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorr à si aki a Zado. Zado à si aki a Akimu. Akimu à si aki a Eliyudu. ");
INSERT INTO ninNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyudu à si aki a Eliyaza. Eliyaza à si aki a Matani. Matani à si aki a Yakubu. ");
INSERT INTO ninNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu à si aki a Isuhu. Isuhu yo à si unuru a Maryamu wa. Maryamu à si ayirr Yesu wa. A yo Yesu yo di Kristi. ");
INSERT INTO ninNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Meme nggo, bazhi ni Ibrayi ku, kuma nu uttu Doda ku à si uka uwurr nu une̱. Na bazhi nu uttu Doda ku ko nu nggo a vɨ anu Israila ba na kuma nu Babilo a si uka uwurr nu une̱, na bazhi nu nggo anu Israila ba a kazhi nu Babilo nga ni ingri i Kristi yi, a si uka uwurr nu une̱. ");
INSERT INTO ninNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ingri i Yesu Kristi inggi i si ma mi: Ayirr a Yesu wa à si Maryamu. A go ma zu ku ugo numa à ri Isuhu. Nggo Isuhu à nise gri ma nga ni iko ima, aba a gru kakye Maryamu à se ni ine. À si Izhi i Abachi iyo ì na ukyekye ukuma. ");
INSERT INTO ninNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Isuhu uruma wa, a si ni ikru isisu i Abachi ni isisurr ima, na kye ì si ta wre uwa bu ba Maryamu nggarr la na azhi hen, mre na ssu anko du uwa ta kà ma du, du anishirr si hi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nggo Isuhu à ni so ri amarr akama meme, unitu a Atiko wa à nga na ku nu uzhila, ni da ku di, “Isuhu, uhanma a Doda, si kru isisu i ba Maryamu ki uwami hen. Kye, uvuvurr wa nggo à se ni ine ima yi nggo à zhi ni Izhi i Abachi. Si kà ma du hen. ");
INSERT INTO ninNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","À ta ngri uvuvurr unuru. Nggo a ti ngri uvuvurr wa, uwa bu yo ma di Yesu. Kye, uwa yo à taka ni kpa anishirr ama ba ttungo ni ila ure imbarr yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ziza, inkindirr inggi yi i ta si meme, wre ku ure ku u bu kurr meme yo nggo Atiko à du Abi kpa are ama ba a nga ni da ku zu ni ikuchi yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kye, uva wanggo nggo à nise hi unuru kye à ta hru ine na ta ngri uvuvurr unuru, aba ta yo isa ima yi di Imanuwe,” inkpi i isa ima inggi ì si, “Abachi à se ni inta ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Isuhu à kasi ni ina yi nggo, na na inkindirr yi nggo unitu a Atiko wa à da ku nggo. Na gru ku gri Maryamu na nga ni iko ima ki uwama. ");
INSERT INTO ninNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Bazhi nu nggo a di to ikpa yi nga ni ingri i uzuma yi, Isuhu à nise hi ma ki ayamba kye. Uwa à ni ngri nggo, Isuhu à yo uvuvurr wa di Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","À ngri Yesu nu Betalami na anga ka Yahudiya, ni ivi yi nggo Hirridu nggo à su uttu unkpi a atuttu ba na anga akama. Azhibarr anuma nggo aba gru kakye anishirr nggo a hi inkindirr ni itu i intsintse̱ a gru zhi na anza ambre mu na nga nu Urushalima, ");
INSERT INTO ninNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","na ni zhi ba di, “A ngri uvuvurr wanggo wa nu momonggo, nggo a da di a taka ni si uttu a anu Yahuda? Inta i hi intsintse̱ ima yi zhi na anza ambre mu ni nga nye gbyarr ku asa.” ");
INSERT INTO ninNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Nggo uttu Hirridu à wo meme, isisurr i vri ma kakami, anishirr ba wemi nu Urushalima a wo na vri meme. ");
INSERT INTO ninNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Uttu wa à du ba yo ku ankpinkpye abikye ba na abitsarr Are ba, na ni zhi ba di, “A da di a taka ngri Kristi wa nu momonggo?” ");
INSERT INTO ninNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Aba a da ku di, “Nu Betalami, na anga ka Yahudiya, nâ ta si nggo Mika, uni kpa are Abachi wa à charr nggo, da di, ");
INSERT INTO ninNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Betalami nggo à si ni imimi i Yahuda, nu nggo a kye ùwà kpachirr mi ni igbu yi na anga ka Yahuda ka, ùwà si unkpi mu ni igbu i Yahuda yi. Nu nggo nu umi umuwa ku yo a taka gri ankpye ssuzzu, ankpye uwama yo à taka gri ittu i anishirr a mungga bu Israila ba.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Uttu Hirridu à yo anishirr angga ba kakuma, na ku zhi ba sharri na wo attuttu ka nggo a hi intsintse̱ yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Na ddu ba di, “Kuma nu Betalami ku zha uvuvurr wa kye. Nggo imba i ti hi ma imba bu kanga ni da ki ingga, wre ki ingga mi bu kuma ku kuttu gbyarr ku asa.” ");
INSERT INTO ninNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nggo a wo uttu wa kre, na gru vu anko wa a so kuma nu Betalami na gru hi intsintse̱ yi nggo aba a so ga yi zhi na anza ambre wa i nggurr huzzu ba. I so ku ba ichi ku kukri nu unto ku nggo uvuvurr wa à se. ");
INSERT INTO ninNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nggo a sa ashishi ni intsintse̱ yi, na gru so nyarr, na me̱ nyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nggo a mirri ni iko yi na hi uvuvurr wa na ayirr ama wa, Maryamu, na kuttu na chi ma. Na nu ma iki iwre, nggo i si i atuttu, nâ ta si ivi inkpu inklo i la nzarrnzarr nggo a yo yi di izinarriya, na àgà a inkinkurr wa nggo a di hun ingba wre aba yo wa di farrkinse tuku mârr ");
INSERT INTO ninNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Abachi à gbye ku anishirr bi zhi na anza ambre ba utu nu uzhila ni ibittu di a bu si kakuma nu uttu Hirridu ku zizo hen. Aba a wo meme na ka ga anko anuma mu na kakuma na ako ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nu ugo ku nggo abichirr ba a kakuma, unitu a Atiko numa à nga ni Isuhu ku nu uzhila ni da ku di, “Gru, ba uvuvurr wa na ayirr wa ni kru ku sharri nu Masarr. Kye uttu Hirridu à ta gru zha anko a itsi ma ngu. Ku so nabo ingga nggo taka da ku uwa azhibarr wa nggo uwa taka gri ma ni kanga.” ");
INSERT INTO ninNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nggo Isuhu à wo meme na gru ba uvuvurr wa tuku ayirr wa, na ga ibittu kuma nu Masarr, ");
INSERT INTO ninNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","na ku so nabo yo ka ma ku Hirridu ni ittu. Abachi à na meme, wre ku anishirr a bu hi di inkindirr yi nggo abi kpa are ba a da yi nggo ì bu si ure ujiji di, “Ingga yo uzumu wa zhi nu Masarr.” ");
INSERT INTO ninNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hirridu kye anko a abichirr angga ba nggo a zhi na anza ambre lankarr. Na gru nu unfu ku zizo, na gru yo abi ta iku ba na da ba di a bu ngɨ ankparr amumarr aniru ba ase aha kaji nu Betalami tuku igbu i kago yi. Uttu wa na meme ni itu yi inkindirr yi nggo a wo zhi na abichirr ba ba na azhibarr a ime̱me̱ wa nggo intsintse̱ yi i huzzu. ");
INSERT INTO ninNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ina ima ì ta du ure ku Irrimiya uni kpa are wa ù kurr meme yo nu nggo a charr di, ");
INSERT INTO ninNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“A wo ukorr nu Rama, ukorr ku iyi. A si Rahila nggo à ko yì amarr ma; aba a ddu ma di a bu ba ttungo, uwa kà iba ttungo yi, amumarr ngga a kɨ ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nu ugo ku nggo uttu Hirridu à ttu, unitu a Atiko wa à nga ni da ku Isuhu zizo nu uzhila uwa à nise nu Masarr ");
INSERT INTO ninNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","di, “Gru, ba uvuvurr wa na ayirr wa ni kakuma ni Israila. Kye, abangga ba nggo a so di zha anko a ingu ma wa a kɨ kre ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Isuhu gru ba uvuvurr wa na ayirr wa na kakuma ni Israila. ");
INSERT INTO ninNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Nggo Isuhu wo du uvuvurr a Hirridu wanggo nggo a yo ma du Akelayo, uwa yo à hun ni imburr i aki yi nu Yahudiya, isisu i ki Isuhu ni kuma nabo. Abachi à re na ku zizo nu uzhila di a bu kakuma na anga ka Galili mu. ");
INSERT INTO ninNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Uwa kakuma ku so ni igbu wanggo nggo a yo ma du Nazareti, meme nggo inkindirr yi nggo abi kpa are ba a da i bu si ure ujiji di, “A taka yo ma du anu Nazareti.” ");
INSERT INTO ninNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ni ivi yi nggo Yohana uni zzu na amasirr wa à gru ku di da ure ku Abachi na ankpuji a Yahudiya wa ");
INSERT INTO ninNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","di, “Imba kasarr ni ila ure imba yi, kye ittu i Abachi yi i ki ywhiywhirr!” ");
INSERT INTO ninNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Uni kpa are wa, nggo a yo ma di Ishaya, à re ni itu i Yohana iyo da di, “Undurr numa à so du hantu na ankpuji di, ‘Ssu anko wa bi ku Atiko wa. Na anko wa ki ntto nggo a taka ni wre ku uzirr!’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohana à di surr iki yi nggo a na yi ni infunfu i alakurrmi, na di lo upri unggakpa na anklampi. Ila ima yi i su ìzì tuku utu ku anisso. ");
INSERT INTO ninNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Anishirr a di gru zhi nu Urushalima na nga na ku. Abanu di gru zhi na anga ka Yahudiya ka namri. Anishirr banu a di zhi ni igbu yi nggo kago inyi nu Joda wa. ");
INSERT INTO ninNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","A nga ni di bre ila ure imbarr yi, uwa zzu ba na amasirr ni inyi nu Joda wa. ");
INSERT INTO ninNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nggo Yohana à hi anu Farrisi na anu Sadusi shishemi nggo so nga di a bu ni zzu ba na amasirr, na ddu ba di, “Imba inkirr i andanda ànìwǎ! Unggonggo da ki imba di imba bu kru iha yi nggo Abachi à ta du yi nga ni imba ba nggo? ");
INSERT INTO ninNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Imba bu na aseki ka nggo a ta tsarr anishirr di imba i ka isisurr sarr ni ila ure imba yi. ");
INSERT INTO ninNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ida imba yi di Ibrayi nggo à si ábáchí amba, sisi ima nggi i ta kpa imba ttungo ni iha yi nggo i so nga hen. Abachi à se nu ukyekye ku ka angbinta angga ka ki ku Ibrayi ahan ma! ");
INSERT INTO ninNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ibre amu i Abachi yi ku abi la ure ba i ta i si nâ ta si nggo a ka ka iwra inggi sa ni izhizhi inkinkurr ta tse ba. Meme nggo, unkunkurr ku nggo u si klo inkpinkpo iwre hen, aba a ta tse ku ta yo, na ta sarr ku tu nu uru. ");
INSERT INTO ninNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“ Ingga zzu imba na amasirr, wre ku anishirr bu hi di imba i ka ba ttungo ni ila ure imba yi ba. Uwanggo nggo so nga nu ugo umungga a ta ni zzu imba ni Izhi i Abachi i Iwre yi tuku uru kye ma. Uwama a mri ingga kakami, nggo ingga si ma uni vu anggakpaza ama ka gri ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","A se nu umumu ku nggo a taka ni ze ingbingbi iki yi. Na ta vu ingbingbi izizi yi ku surr nu iwurr, na ta vu intinturr yi surr nu uru ku ri sese ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na attuttu akama i Yesu à gru nga zhi na anga ka Galili ka, na ji kuma ni Yohana ku nu unddu inyi ku Joda ku, di a bu ku zzu ma na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yohana à zha anko wa nggo uwa ta na du ma ka amarr ama ka sarr na kakuma, na ddu ma di, “Nggo ingga nggo kakuma nu ùwà yo ku du ùwà bu ku zzu ingga, ùwà kanga ni ingga ku?” ");
INSERT INTO ninNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu à ddu ma di, “Du yi si meme ziza nggo. Meme yo nggo inta ta na undu ku nggo Abachi à turr inta di inta bu nga ni na ku nggo.” Yohana kye na kpanye na zzu ma na amasirr wa. ");
INSERT INTO ninNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nggo Yohana à zzu Yesu kre, Yesu ta ko huzzu na amasirr wa, mre unkplassu ku ù bwu, i Yesu kakye na hi Izhi i Abachi yi i so ji zzu nâ ta si anddu, ni ji so ku. ");
INSERT INTO ninNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ukorr u zhi nu unkplassu ni da di, “Uwanggo yo à su Uzumu wa nggo ingga i kpanye na ku. Isisurr mungga yi i di nyarr na ku kakami.” ");
INSERT INTO ninNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Izhi i Abachi yi i gri Yesu kuma na ankpuji nggo Umimi wa à ta ku tsarr ma kye. ");
INSERT INTO ninNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu à ku so ki ivi iso ine̱ (40) ni ibittu iso ine̱ (40), sama ni iri ila, iyo ki ma kakami. ");
INSERT INTO ninNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Umimi wa gru nga na ku na ni ddu ma di, “Ùwà ti da du ùwà su Uvuvurr a Abachi ùwà bu ka angbinta angga ka ki ankpinkpri unfonfo.” ");
INSERT INTO ninNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu ddu ma di, “Ungbamvu ku Abachi ku u da di, ‘A si si inkindirr i iri iyo mre ì ta du anishirr so tsitsirr hen, a si are ka nggo Abachi à da ka, aka yo à ta du anishirr so tsitsirr.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nabo yo, Umimi wa à gri Yesu kuma nu Urushalima, Ìgbù ni Wre wa, na gri ma ku sa na anvinvri a Uki Unkpi ku Ibarr Abachi ku, ");
INSERT INTO ninNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na ddu ma di, “Ùwà ti du ùwà su Uvuvurr a Abachi, ùwà bu tu ji nu nggo. Ungbamvu ku Abachi ku mi u da di: “ ‘Abachi à ta turr abitu ama ba du ba ji nga nu ùwà ku. Aba ta ni ko ùwà kpa nu ussu na ango ambarr ka, na si ta kpanye na du ùwà nggurr uza ni angbinta hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu à ddu ma di, “Ungbamvu ku Abachi ku u da zizo di, ‘Si tsarr Atiko wa nggo si Abachi muwa kye hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nu ugo kuma, ùwà gri Yesu na kuma ni igbre numa, nggo a ta kakami, na ku so tsarr ma inkpinkpye tuku iwre i ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Umimi wa à ddu Yesu di, “Nggo ùwà ti kuttu ni gbyarr ki ingga asa, ingga ta nu ùwà aseki angga ka namri.” ");
INSERT INTO ninNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesu ddu ma di, “Chi share ni ingga ku, ùwà Isheta! Kye, ungbamvu ku Abachi ku u da di, ‘Ùwà bu kuttu ni gbyarr ku Atiko asa, uwa yo à si Abachi amuwa wa na nkpama, ni bu ga uwa yo mre.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Umimi wa kru share na du Yesu na abubo wa. Abitu ba Abachi ba a nga ni zi ma. ");
INSERT INTO ninNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nggo Yesu à wo di uttu Hirridu à du ba vu Yohana ku harr nu uki, na gru kakuma nu Galili. ");
INSERT INTO ninNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Na si so nu Nazareti zizo hen, na gru kuma ku so nu Kapanahu hinga ni inyi nu Galili wa na anga ka nu Zebulu tuku Nafitali. ");
INSERT INTO ninNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A na meme, wre ku inkindirr yi nggo uni kpa are a Abachi wa, Ishaya à da i bu kurr meme yo. Ishaya à da di, ");
INSERT INTO ninNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Igbu nu Zebulu tuku Nafitali, nu unddu inyi ku, nu ugugarr ku inyi nu Joda, nu Galili, igbu a anishirr angga ba nggo a si si anu Yahuda hen! ");
INSERT INTO ninNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Anishirr ba nggo a di so ni ibwu ashishi ambarr ka ta bwu, aba ta kye hi. Anishirr ba nggo a di so ni ibwu tuku ni iyu i ittu, abubo wa ta la ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Zhi na azhibarr ama wa Yesu gru di da ba ure ku Abachi ku di, “Imba kasarr ni ila ure imba yi. Kye ittu i Abachi yi i si ywhiywhirr mi!” ");
INSERT INTO ninNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nggo Yesu à so zirr ga unddu ku inyi nu Galili wa, na ku hi amuya aha banu. Uyirr wa à si Sima, nggo à di yo ma di Biturr, uyirr wa à si Andoro. A si abi vɨ ikikla na so surr azhizhi ka vɨ ikikla ka ni inyi wa. ");
INSERT INTO ninNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu ddu ba di, “Imba ga ingga yi, ni di ingga tsarr imba nggo imba ta gri anishirr nga ni ingga ku nâ ta si nggo imba di vɨ ikikla yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nggo a wo meme na gru ankpa yirr ga ma, na kà azhizhi ka vɨ ikikla ambarr ka du. ");
INSERT INTO ninNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nggo Yesu a so zirr ga inyi wa, na ku hi amuya aha abanu, Yakubu tuku Yohana, amumarr bu Zabadi aba a rri so nu uddu na aki ambarr wa Zabadi, na so zɨ azhizhi ambarr ka. Yesu à ddu ba di a bu ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Aba ka uddu ku du na aki ambarr wa, na ga Yesu ankpa yirr. ");
INSERT INTO ninNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu à zirr kago anga ka Galili ka na di tsarr ba na aki ka issubi ka, na so di bre ba Ure ku wre ku ni itu i ittu i Abachi yi, na du anishirr banu nggo se ni ivri a wre. ");
INSERT INTO ninNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ure umaku u bwa kago anga ka Sirriya ka. Anishirr a gru vu abi lolo na nkanka na nga na ku. Abanu sa abi la, na abi se na anazhi, na abi tsɨ ankparr, na abangga ba nggo ukpa ku u ttu ga anga yirr. Yesu du ba a wre namri. ");
INSERT INTO ninNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ima yo du anishirr shishemi a ga ma zhi na anga ka Galili ka na anga ka Igbu Iwurr yi nggo à yo yi di Dekapoli, na kuma nu Urushalima, tuku Yahudiya, tuku igbu yi nggo i si nu ugugarr ku inyi nu Joda wa. ");
INSERT INTO ninNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na azhibarr numa nggo, Yesu à hi nggo anishirr ba a so nggurr bi, na gru kuma ni ine i igbre yi, na ku ji so. Abiga ma ba a nga ni so kago ma, ");
INSERT INTO ninNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","uwa gru so tsarr ba. Uwanggo yo sa are ka nggo à tsarr ba: ");
INSERT INTO ninNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Abangga ba nggo a hi di aba a klonyarr na age̱ ka Abachi, Abachi à yo ba angu azizi. Abachi nggo à hru ba ki Uttu ambarr! ");
INSERT INTO ninNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Abangga ba nggo a so ba azhittu, Abachi à yo ba angu azizi. Abachi taka nu ba isu isisurr! ");
INSERT INTO ninNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Abangga ba nggo a hru atu ambarr wa nggi, Abachi à yo ba angu azizi, ingbingbru yi ì ta si ba imbarr! ");
INSERT INTO ninNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Abangga ba nggo a yo itu di aba ta na inkindirr yi nggo Abachi à zha di a bu na yi, Abachi à yo ba angu azizi. Abachi taka nu ba inkindirr yi nggo a zha yi! ");
INSERT INTO ninNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Abi ki itito na atu a banu, Abachi à yo ba angu azizi. Abachi taka ni kye ba na ashishi ka itito! ");
INSERT INTO ninNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Abangga ba nggo isisurr imbarr yi i sama na ankizhi, Abachi à yo ba angu azizi. Anishirr abama a taka hi Abachi! ");
INSERT INTO ninNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Abi zi anishirr du ba a so zizi, Abachi à yo ba angu azizi. Abachi à taka ni kye ba ki amarr ma! ");
INSERT INTO ninNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Abangga ba nggo a ki ba iha nu nggo a so di na inkindirr yi nggo Abachi à zha, Abachi à yo ba angu azizi. Abachi nggo à hru ba ki Uttu ambarr!” ");
INSERT INTO ninNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Anishirr a ti re ndanda na atu amba, na ki imba iha, na bre imu mi na atu amba, nu nggo imba so ga ingga nggo, meme yo nggo Abachi à yo kimba angu azizi. ");
INSERT INTO ninNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","A ti na ki imba meme, imba bi me̱ nyarr ni bri nyarr yi, azadi amba ka a kri mwe nu unkplassu. Kye a na ku abi kpa are ba nggo a ku ki imba ichi iha yi meme yo.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Imba yo si nâ ta si ima i ingbingbru yi. Nggo imarr i ima yi ti ka nado, aba ta na yi kingginggi na di yi ka ni marr zizo? Ima i ma sa nu undu zizo, aba ta ka yi kahre na cha na aza.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Imba se nâ ta si azhi wa nggo a la ku anishirr ba kago ni ingbingbru inggi yi. Ìgbù wa nggo a me ma ni itu yi igbre, ka si ka sharri hen. ");
INSERT INTO ninNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Unushirr ka si yo uru ni ingba nu uru na ba ungabu a ttu hen. Iya, a ta ba ma sa nu ssu, du ma la kago ku anishirr ba ni iko yi we. ");
INSERT INTO ninNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Na anko ayiyirr ama yo, imba bu du ina uzizi imba yi la ku anishirr nâ ta si uru ku nggo à ta hi ku we, wre ba bu gbyarr ku Aki amba nu unkplassu wa asa.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Imba bu si kye di ingga nga nye kà Are ka nggo Musa na abi kpa are ba a tsarr imba glo hen. Ingga si nga i kà ka glo mu hen. Ingga nga nge du ka su jiji. ");
INSERT INTO ninNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Imba bu hi di nu nggo unkplassu ni imimi ta se, inkpi yirr ntsɨ a si ta tsu yi glo nu umi ku Are ka hen, bazhi ziza kuma ni ikikre i aseki yi. ");
INSERT INTO ninNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Meme nggo, undurr wa nggo ti kpa inkpi ure ivintsɨ iyirr chirr, na tsarr abanu du ba na meme, uwa taka su uvuntsɨ ni Ittu i Abachi yi. Nu ungo numa ku, undurr wa nggo à ti kru isisu i ure ku Abachi ku, na tsarr abanu mi du ba meme, uwa taka kpa inkpinkpye nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ingga nggo ko da ki imba, imba ta si yo isisurr imba yi ni ga Abachi mri abitsarr na are ba, na anu Farrisi ba, ni ta si na inkindirr yi nggo Abachi zha di imba bu na yi hen, imba si taka rri ni ittu i unkplassu yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Imba wo nggo a bre ku anishirr ni ikuchi yi di, ‘Si ngu unushirr hen. Undurr wa nggo ti na meme a ta gri ma kuma nu unto ki ibre amu.’ ");
INSERT INTO ninNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ziza, ingga ko da ki imba di, undurr wa nggo ti ki unfu nu uzayirr uniga, aba ta gri ma kuma ni ibre amu. Undurr wa nggo ti marr uzayirr uniga di à sama nu undu, aba ta gri ma ko na Akaba anu Yahuda wa, wre ba bu ku bre amu na ku. Undurr wa nggo ti yo uzayirr uniga di à su urrurru, Abachi ta yo ma nu uru ku ki iha sese.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ni ima yo, ùwà ti gri inkindirr ta ku yo na agbugba a Abachi wa, ni ti ssu hi di ùwà kpala ku uzumbirr uniga numa, ");
INSERT INTO ninNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ùwà bu du inkindirr yi nggo ùwà i gri nga nggo ni kru ka ku ssubi nu uzumbirr uniga wa ku bari, ni kanga ni to inkindirr yi na age̱ ka Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Unushirr ti gri ure nga ni itu muwa na gri ùwà kuma nu unto ki ibre amu, ùwà zha ni ssubi na ku ni du azhi wa nise nggo imba ta kuma nu unto ku ibre amu ku. Nggo ùwà ti si na meme hen, uwa ta ba ùwà sa ku uni bre amu wa na ango, uwa ta kpa ùwà nu abi lo ukpa ba du ba kpa ùwà ku ttu nu uki. ");
INSERT INTO ninNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nabo yo, ùwà ta kri, aba ta se iko muwa yi tsatsarr ku nu ba, ingga ko da ku ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Imba wo nggo a da di, ‘Si zha ayamba a unuma hen.’ ");
INSERT INTO ninNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ziza nggo, ingga ko da ki imba di, undurr wa nggo ti kakye ayamba ni isisurr iha du uwa ka zha wa ki ayamba ama, uwa kpala. ");
INSERT INTO ninNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A ti si ingbishi muwa i ungo ri nggi ta du ùwà kpala, ùwà ttu yi ta yo glo! I ta wre sha ùwà bu sama nu unto numa nu ukpa muwa ku, nu nggo ùwà ta rri nu uru namri. ");
INSERT INTO ninNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A ti si ungo ri muwa nggo u ta du ùwà kpala, ùwà bu ttu ku ta yo glo. I ta wre sha ùwà bu sama nu unto numa nu ukpa muwa du ku nggo ùwà bu rri nu uru namri.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ni ikuchi yi, imba wo nggo a di da di, ‘Undurr wa nggo à ti du uwa ta han uwama, uwa bu nu ma ungbamvu ku ingu igarr.’ ");
INSERT INTO ninNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ziza nggo, ingga ko da ki imba di, unuru ta si vu uwama ni kurr ìga nu unuru numa ku hen, uwa bu si han ma hen. Uwa ti han ma, ihan ima i ta du ma ku garr unuru numa, ina ima i si ikpala. U undurr wa nggo ti garr ayamba wa, uwa mi à kpala.” ");
INSERT INTO ninNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Imba di wo nggo a di da ku anishirr ni ikuchi yi di, ‘Si na ki na angu aha ni inkindirr yi nggo ùwà da di ùwà ta na ku Abachi hen. Na, nâ ta si nggo ùwà ka da ni ime̱me̱ ba.’ ");
INSERT INTO ninNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ziza nggo, ingga ko da ki imba di, imba bu si di shi azhi mi mremremu hen. Imba bu si shi azhi nu unkplassu hen. Kye u su unto ki iso ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ni si shi azhi ni imimi hen. Kye ì su ku unto ku sa aza. Ni si shi azhi nu Urushalima hen, kye à su ìgbù wanggo nggo Uttu unkpi wa à so gri ma nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Imba bu si shi azhi na atu a imba hen, nggo imba si hi ina infunfutu iyirr kaki ikikla ka ishishirr hen. ");
INSERT INTO ninNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Imba ti kpanye ku inkindirr, imba da di, ‘Yo-o.’ Imba ti kisa, imba da di, ‘Iya.’ Inkindirr yi nggo ti mri meme izhi nu umimi wa ku. ");
INSERT INTO ninNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Imba wo nu nggo a da na Are ka Musa ka da di, ‘Unushirr ti turr ku ùwà ishishi iyirr, ùwà turr ku ima iyirr yi meme. Uwa à ti ttu ku ùwà inyirr iyirr, ùwà ttu iyirr ima yi meme.’ ");
INSERT INTO ninNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ziza nggo, ingga ko da ki imba di, unushirr à ti na ki imba undanda imba bu si di imba ta na ku undanda han hen. Iya, si na meme hen. Undurr ti nggurr ùwà nu unga uyirr, ùwà bu ka unuma ku sarr ku. ");
INSERT INTO ninNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Undurr wa nggo ti gri ùwà na kuma na abubo a bre amu, du uwa zha ankru muwa avutsa ka umi ka, ùwà ttu ankru muwa ankpi ka abi ka nu ma kye. ");
INSERT INTO ninNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Undurr wa nggo à ti sa ùwà unggangga du ùwà bu zirr ga ma ìmîrr iyirr, ùwà bu ga ma ìmîrr iha. ");
INSERT INTO ninNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Undurr ti barr ùwà inkindirr numa, ùwà bu nu ma. Undurr ti zhi ùwà uhla, ùwà bu nu ma. ");
INSERT INTO ninNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Imba wo nggo a di da di, ‘Kpanye ni uni girr amuwa ku, ni karr uni karr ùwà.’ ");
INSERT INTO ninNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ingga ko da ki imba di, imba bu kpanye na abangga ba nggo a karr imba, ni barr ku abangga ba nggo a ki imba iha. ");
INSERT INTO ninNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Na meme, wre ku imba bu tsarr atu amba ki amumarr ajiji ba Aki amba nu unkplassu. Uwa yo à di du azhi wa la, na du ahru à ku ku anishirr andanda ba na azizi ba wemi. ");
INSERT INTO ninNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Imba ti kpanye na abangga ba nggo a kpanye ni imba yo ba mre, imba ka kpa azadi na Abachi ku? Kye abi kpa inklo i imimi yi ba mi a di na meme! ");
INSERT INTO ninNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Imba ti chi abangga ba nggo a di kpanye ni imba yo ba mre, imba na sa angginggi he̱he̱? Kye di abi ingbingbru ba mi a di na meme yo! ");
INSERT INTO ninNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ina uzizi imba yi i bu sama ni ikikre, nâ ta si nggo uzizi ku Aki amba nu unkplassu wa ù sama ni ikikre nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Imba bu na ndindi. Nggo imba ti ta na inkindirr izizi, imba si na na ashishi ka anishirr, wre ba bu hi imba hen. Imba ti na meme, imba si ta kpa azadi na Aki amba nu unkplassu wa ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Nggo imba ti ta nu abi iha inkindirr, imba si vri unddu nâ ta si nggo abi na aseki wre ku anishirr a bu hi ba a di na nggo hen. A di vri ingba na aki ka issubi ka tuku na atsutsu ka igbu, wre ku anishirr a bu hi ba na nu ba inkpinkpye. Ingga da ki imba ure ujiji, abi na abama a ka kuchi kpa azadi ambarr ka ba. ");
INSERT INTO ninNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nggo ùwà ti zi undurr ni inkindirr, ùwà bu si du undurr unuma mi hi du ùwà nggo i zi undurr ni inkindirr inggi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Du izi muwa yi si sharri. Aki muwa nggo, uwa yo hi inkindirr yi nggo ùwà na sharri. Uwa yo ta nu ùwà azadi amuwa ka. ");
INSERT INTO ninNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Nggo imba ti barr, imba si na ina i abi na aseki wre ku anishirr a bu hi ba hen. A di nyarr i gru kri na ashishi ka anishirr na aki ka ibarr ka tuku na atu anko ka igbu ka na barr hantu, wre ku anishirr bu hi ba. Ingga ko da ki imba a ka kpa azadi ambarr ka ba. ");
INSERT INTO ninNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Imba ti ta barr imba bu mirri ko nu umi uki ni han anko ka ni barr Aki amba wa nggo so sharri. Aki amba wa nggo à so sharri na so wo imba nggo a ta ni imba azadi amba ka. ");
INSERT INTO ninNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Uwa ti ta barr uwa si so bre are ka gigye nâ ta sa abangga ba nggo a si hi Abachi hen, na kye da Abachi ta wo ibarr imbarr yi nggo ikri kaba. ");
INSERT INTO ninNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Imba si na ina imbarr yi hen. Kye imba ti nise bwu angu mi, Aki amba wa à hi inkindirr yi nggo imba ko zha yi. ");
INSERT INTO ninNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Imba ka bi barr ma mi: “ ‘Aki munta wa nggo se nu nkplassu, di inta gri isa muwa yi ndindi, ");
INSERT INTO ninNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","nga ni hru iso munta yi ziza nggo, du anishirr we a kru isisu imuwa ni ingbingbru yi nâ ta si nggo a di na nu unkplassu nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ni inta ila iri imunta yi ni ivivi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ni nggurr ila ure munta yi zhi ki inta, nâ ta si nggo inta di nggurr zhi ku abangga ba nggo a di kpala ki inta. ");
INSERT INTO ninNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Si di inta jaku nu nggo a ti tsarr inta kye hen, ni kpa inta ttungo na ango ka Umimi wa.’ ");
INSERT INTO ninNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Imba ti nggurr zhi ku abangga nggo akpa la ki imba, Aki amba wa nggo so nu unkplassu ta nggurr ila ure imba yi zhi ki imba. ");
INSERT INTO ninNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Imba ta si nggurr zhi ku abanu hen, Aki amba wa si ta nggurr ila ure imba yi zhi ki imba hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Nggo imba ti su nu umi ku ivu angu, imba bu si cha ashishi ni kye gbo nâ ta si nggo abi na aseki ba na abi ba a di na, wre ku anishirr bu hi ba hen. A di na ukpa umbarr ku ki ttuttu na kye gbo da anishirr bu hi di aba ko vu angu gri. Ingga ko da ki imba a ka kpa azadi ambarr ka ba. ");
INSERT INTO ninNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nggo ùwà ti vu angu, ùwà ngla ashishi muwa ka ni varr itu muwa yi, ");
INSERT INTO ninNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","meme nggo, undurr à si ta hi du ùwà so vu angu hen. Aki amba wa nggo undurr si di hi ma na ashishi hen, uwa yo à ta hi du ùwà so vu angu na ta nu ùwà azadi amuwa ka. ");
INSERT INTO ninNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Si zu ki itu muwa aseki ka iwre ni ingbingbru inggi yi hen, a ta ri ambu, ka ri ìzzú, ka abayi ta hlo abubo wa nggarr na vu ka. ");
INSERT INTO ninNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Meme nggo, ùwà bu zu aseki ka iwre amuwa ka nu unkplassu nu unto ku nggo i si ta ri ambu, ka ri ìzzú, ka abayi ta ku hlo nggarr na vu ka hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Unto ku nggo aseki ka iwre muwa ka kurr nggo, isisurr imuwa yi ì ta se nabo yo. ");
INSERT INTO ninNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ashishi a si nâ ta si ingba nu uru ku ukpa ku. Ashishi muwa ka ti sa akyekye, ukpa muwa ku uta la wre. ");
INSERT INTO ninNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nggo ashishi muwa ka ti sa amimi, u ukpa muwa ku we u ta shi ibwu. Ni ima, ila uru yi nggo i so la ku ùwà, ùwà kye hi i ti si ibwu, ibwu ima i ta si kingginggi? ");
INSERT INTO ninNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Unushirr uyirr ka si na undu ku atitiko aha hen. À ta karr uyirr wa na ta kpanye nu unuma wa, na ta kru isisu i uyirr na ta ka uyirr wa. Na anko ayiyirr ama yo, ùwà ka si ba itu imuwa ni narrnarr ku undu ku Abachi tuku izha inklo hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ima yo di ingga i da di, imba bu si ri amarr ka inkindirr yi nggo imba ta ri ka imba ta so, ka iki yi nggo imba ta surr ttu ukpa hen. Iso tsitsirr ì si mri ila hen? Imba kye ukpa umba ku si wre na iki isurr hen? ");
INSERT INTO ninNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Kye aminche ba nggo so di bwa kago, a si di ttu ikiri, ka di hwa vu ku surr ni iwurr hen. Uwa sa Aki amba nu unkplassu wa yo à so di nu ba iri. Imba si mri aminche ba hen? ");
INSERT INTO ninNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Imba kye di iri amarr nggi ka turr ase ka iso tsitsirr amba ka chi kuma ki imba ni ichi? ");
INSERT INTO ninNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Angginggi du imba so ri amarr ka iki isurr? Kye igbyarr iki iwre kye yi nggo i so to ni ijiji na. Isi di na undu inkindirr hen, ni si di warr iki isurr ku atu ambarr hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Di ingga da ki imba, Uttu Solomo mi nggo a se na aseki ka ingbingbru ka namri, à si wre ikye nâ ta si ugbyarr ki inggi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Abachi nggo di surr ku agiga ka ankru, agiga angga ka nggo a kri ari, ambre a ka kparri nu uru. Imba kye à si ta ni imba iki isurr mri meme hen? Iyo isisurr imba yi na Abachi ku ì si ntsɨmi! ");
INSERT INTO ninNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Imba bu si gru so ri amarr di, ‘Ila imunta yi i ta zhi nu momonggo hen. Ka inkindirr yi nggo inta ta so, ka ankru ka nggo inta ta surr?’ ");
INSERT INTO ninNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Abangga ba yo sa aseki ka nggo anishirr ba nggo si hi Abachi hen, a so di yo isisurr. Aki imba wa nu unkplassu wa à hi di imba so zha aseki akama. ");
INSERT INTO ninNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Meme nggo, imba bu yo isisurr ni ittu i Abachi yi tuku inkindirr yi nggo à da di a bu na yi nggo. Uwa ta ni imba inkpu aseki yi namri. ");
INSERT INTO ninNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Meme imba bu si ri amarr ka ambre hen, ambre ta se na amarr ka itu ima. Si ba ivri i azhibarr anuma gri ku ttu ku anuma hen. ");
INSERT INTO ninNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ùwà bu si bre are ni itu i unuma hen, wre ku Abachi abu si bre amu ni itu muwa meme hen. ");
INSERT INTO ninNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nâ ta si nggo ùwà bre amu ni itu i unuma aba a ta bre ni itu muwa meme. Agbugba wa nggo imba di tsarr ku abanu na wa, Abachi à ta tsarr ki imba na ama yo meme. ");
INSERT INTO ninNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Ùwà so kye uvu unkunka ku nggo u rri ku uzumbirr ni ishishi ni kpamusu nu inkpunkpu unkunkurr yi nggo i kri ku ùwà ni ishishi. ");
INSERT INTO ninNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ùwà sama ni ishisha nggo ùwà ddu uzumbirr di, ‘Di ingga ttu ku ùwà unkunka ni ishishi,’ nggo inkpunkpu unkunkurr ikurr ku ùwà ni ishishi? ");
INSERT INTO ninNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ùwà ni na aseki ba na abi wre ku anishirr a bu hi, ttu inkpunkpu unkunkurr imuwa yi glo wre ku ishishi yi i bu hla, bari nittu ku uzumbirr wa unkunka umaku. ");
INSERT INTO ninNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Imba si nu amiyo inkindirr yi nggo i si i Abachi hen, nggo à ta kasarr na ta imba. Si ba inkindirr yi nggo si iwre zu ku anikpama hen, wre ba ta cha yi na aza na kasarr na nga imba hre. ");
INSERT INTO ninNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Imba ti zhi, aba a ta ni imba. Zha, imba ta hi. Nggurr anko wa, aba a ta bwu ki imba. ");
INSERT INTO ninNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Undurr wa nggo à ti zhi, uwa ta kpa; undurr wa nggo à ti zha, uwa ta hi; undurr wa nggo ti nggurr anko, aba a ta bwu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nu umi umba akiki, unggonggo ka nu uzuma ingbinta nggo uvuvurr wa ti zhi ma ila? ");
INSERT INTO ninNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ka unggo uvuvurr ka ti barr ùwà ikikla ùwà ta nu ma ìwǎ? ");
INSERT INTO ninNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nu ndanda umba ku mi, imba hi ini amumarr amba ba aseki azizi. Nggi Aki amba wa nggo se nu unkplassu ka na ki ngginggi? À ta nu abangga ba nggo barr ma inkindirr iwre! ");
INSERT INTO ninNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Na ku abanu nâ ta si nggo uwa zha da abanu bi na ku uwa. Uwanggo yo si itsarr yi we na Are ka Musa ka tuku nggo abi kpa are ba a da. ");
INSERT INTO ninNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Rri ga ankonki wa nggo iywirr yi i si montonto. Kye ankonki wa nggo ta gri anishirr kuma nu uru ama yo su akplankpla na wre izirr. Anishirr shishemi a so ga wa. ");
INSERT INTO ninNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Anko a kuma ni iso i asese wa a si iywirr mi, na so montonto, na vri ni iga. Anishirr ntsɨmi yo a zha wa hi. ");
INSERT INTO ninNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Imba bi si so ba kahre hen, abi kpa are bi imu a se. A di nga ni imba ba na na chě nâ ta si aminta. Nu umi umbarr ku aba sa aniche. ");
INSERT INTO ninNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Imba hi ba na aseki ka nggo a so na. Ùnkè̱ u si di klo ingginggo hen. Ire à si di klo ibwa hen. ");
INSERT INTO ninNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Unkunkurr ki iwre u di klo inkpinkpo iwre, unkunkurr ku nggo u si undanda u di klo inkpinkpo indanda. ");
INSERT INTO ninNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Unkunkurr ki iwre u si di klo inkpinkpo ndanda hen, unkunkurr undanda si klo inkpinkpo iwre hen. ");
INSERT INTO ninNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Unkunkurr ku nggo ta si klo inkpinkpo iwre hen, a ta tse ku ta yo na murr uru yo na ku, du ku u rri glo. ");
INSERT INTO ninNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Meme yo, aseki ka nggo abi kpa are bi imu ba a so na ka, aseki akama yo a ta di imba i hi da a si abi imu. ");
INSERT INTO ninNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A si su undurr wa nggo ti yo ingga di, ‘Atiko, Atiko’ nggo à ta rri ni ittu i Aki mungga wa nu unkplassu hen. Abangga ba nggo a si anishirr ba Abachi ba, aba yo si anishirr ba nggo a so di na inkindirr yi nggo Abachi nu unkplassu zha di a bu na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na Azhibarr a Ibre Amu wa, abanu taka ddu ingga di, ‘Atiko, Atiko! Kye inta i bre ku anishirr Ure ku wre ku Abachi ku ni isa muwa ni han izhi ndanda huzzu ku anishirr ni isa muwa ni na aseki ka ikagri shishemi’ ");
INSERT INTO ninNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ingga ta ddu ba di, ‘Chi ka ki ingga, imba amimi anishirr. Ingga si hi imba hen!’ ");
INSERT INTO ninNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“I si meme yo, undurr wa nggo ti wo ure mungga ku ná nà inkindirr yi nggo ingga tsarr ma, uwa si nâ ta si unushirr wa nggo a me iko ima yi ni ingbinta. ");
INSERT INTO ninNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nggo ahru wa ku i inyi wa ssu unddunddu u go kakami ni iko yi, iko yi si jaku hen, nggo a me yi ni ingbinta. ");
INSERT INTO ninNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Undurr wa nggo a wo ure mungga ku na si na nâ ta si nggo ingga da hen, a si nâ ta si urrurru unushirr wa nggo me iko ima yi ni itu i ugbuhun. ");
INSERT INTO ninNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nggo ahru wa ku, inyi wa ssu, unddunddu ku u go kakami ni iko yi, iko yi ji jaku ku ankpu!” ");
INSERT INTO ninNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nggo Yesu kre ibre ba are ka, anishirr ba a ku ayisurr ni itsarr yi nggo a so tsarr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","À tsarr ba nâ ta si uttu mu, na si tsarr nâ ta si abitsarr are bu Musa ba hen. ");
INSERT INTO ninNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nggo Yesu kaji zhi ni igbre wa, akpukpa anishirr a ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Uni lo ishi numa nga na ku ni kuttu ku na age̱ na da di, “Atiko, ùwà ti kpanye, ùwà bu di ingga wre.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu à na ungo sa na ku na da di, “Ingga kpanye. Ùwà bu wre!” Nu unto ku ishi yi i huzzu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","I Yesu ddu ma di, “Si da ku undurr inkindirr inggi yi hen. Tsi kuma ku tsarr itu muwa nu unikye wa ku, ni na aseki ka nggo Musa a da di abangga ba nggo a wre nu ulolo ku ishi a bu di na nggo, wre ku anishirr a bu hi di ishi i ssuzzu ku nu ukpa.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nggo Yesu mirri nu Kapanahu, ankpye abi ta iku numa nggo so gri anishirr ukrɨ uyirr, à zirr nga na ku, ni ko barr ma di, ");
INSERT INTO ninNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Atiko, ugarr amungga nggo à kurr ki kurr mu ni iko. À se ni ivri kakami na ka si gɨ ki tsa hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu ddu ma di, “Ingga bu nga ni du ma wre?” ");
INSERT INTO ninNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ankpye abi ta iku wa ddu Yesu di, “Atiko, ingga klonyarr nggo ùwà kakuma ni iko mungga, kri ni inggya ni da ure yo mre, ugarr amungga wa ta wre. ");
INSERT INTO ninNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ingga mi ko na undu nu ungo ku unuma nggo sa ankpye ni ingga ku, ni so gri abi ta iku abanu. Ingga ti ddu unuma di, ‘Kuma!’ uwa kuma. Ingga ti ddu unuma di, ‘Nga!’ uwa nga. Nggo ingga ti ddu ugarr mungga di, ‘Na inggi yi!’ uwa na yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nggo Yesu à wo ma na ku ayisurr na kasarr na ddu abangga ba nggo à ko ga ma di, “Ingga da ki imba, ni Israila mi ingga nise hi uni yo isisurr ma mi kye. ");
INSERT INTO ninNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kye yi, ingga da ki imba, anishirr shishemi taka nga zhi na anza ambre, abanu ta zhi na anza a ingbahru, na ta nga ni so ni Ibrayi, Ishaku, tuku Yakubu ku, na ri, na nyarr ni imburr inkpi yi tuku abangga ba nggo si anishirr ba Abachi ba. ");
INSERT INTO ninNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Abangga ba nggo aba yo ka si anishirr ba Abachi ba aba ta sarr turr aba yo surr ni ibwu, nabo yo aba ta ku so yi na ta anyinyirr.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yesu ddu ankpye abi ta iku wa di, “Kuma ni iko, ugarr muwa à ta wre nu nggo ùwà kpanye.” Ugarr a ugo wa wre keke nâ ta si nggo Yesu da. ");
INSERT INTO ninNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nggo Yesu à mirri ni iko i Biturr na hi ayimbarr wa à vri na kurr ko wri kpakpa nu uki. ");
INSERT INTO ninNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Na ki ungo sa ku nu ungo, ukpa ku u wre ku, uwa gru na zzu ba ila. ");
INSERT INTO ninNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ni ingbahru ima yi, aba gri ku Yesu abi ku anazhi ndanda shishemi, uwa du ba wre wemi. ");
INSERT INTO ninNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Aseki angga ka wemi a si nâ ta su nggo Abachi à da na angu ka Ishaya uni kpa are wa da di, “A ba iklonyarr munta yi nu ulolo munta ku glo.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nggo Yesu hi akpa anishirr wa ni ka ma yo na atsutsu, na da ku abiga ama ba di a bu cha ko nu ugugarr inyi numa ku. ");
INSERT INTO ninNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Unitsarr are numa à nga na ku ni ddu ma di, “Unitsarr, ingga ta ga uwa kuma nu unto ku nggo uwa ti kuma.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu à ddu ma di, “Anihon a se na ahon, aminche a se ni ako, ingga Uvuvurr a Unushirr i sama nu unto ku ji kurr ni sa itu.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Unuma nu umi ku abiga ma ba à ddu ma di, “Atiko, di ingga ku zzu aki mungga nggo bari.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu ddu ma di, “Ga mi, ni du abi kɨ a zzu ambarr bi kɨ.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu mirri nu uddu unkpi, abiga ma ba a rri ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Na gru kakye unddunddu numa gru so go kakami na amasirr wa. Unddunddu ku ù kri kakami ni ta ankinkirr ka amasirr ka, nu ba uddu ku hlo kasarr ashishi. I Yesu so kurr ina. ");
INSERT INTO ninNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Abiga ma ba gru ku si ma di, “Atiko, kpa inta ttungo! Inta ta gu!” ");
INSERT INTO ninNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu à ddu ba di, “Imba ki isisu i angginggi meme? Iyo isisurr imba yi ì si ntsɨmi!” Na gru kri na glo unddunddu ku, amasirr wa a ji kurr, unddunddu ku tuku ankinkirr ka amasirr ka a ji kurr. ");
INSERT INTO ninNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Anishirr ba nu uddu ku a kye na ku ayisurr na da di, “Uwanggo à si ibibi unushirr ita inggi? Unddunddu tuku ankinkirr ka amasirr mi a wo ma!” ");
INSERT INTO ninNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nggo Yesu cha amasirr a kri ni inkla yirr wa, na kuma nu unddu inyi ku, hinga ni igbu nu Gadarra, na ji ga anko wa na anga akama. Anishirr aha banu abi di tsɨ ankparr agru zhi na abe na nga na ku. Anishirr angga ba a ki isisu na se na anazhi na atu ambarr wa, na di han anishirr, ni ga anko ama wa. ");
INSERT INTO ninNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nggo a hi Yesu na nggarr iyi di, “Ùwà zha angginggi ni inta ba Uvuvurr a Abachi. Ùwà nye tsutsarr inta du azhibarr wa nise ma?” ");
INSERT INTO ninNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Inkirr i anikpama a kri so ri ywhiywhirr mi nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Anazhi ba barr Yesu di, “Ùwà ti ta han inta huzzu, ùwà bu turr inta ku surr ku anikpama angga ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu ddu ba di, “Kuma!” Aba huzzu kru ko ku rri ku anikpama ba. Anikpama ba a kru ji ni igbre wa ku sarr kusurr ni inyi wa na kɨ nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Abi ho anikpama ba a kru rri kuma nu umi igbu ku, ku bre ba ure kuma ni inkindirr yi nggo i la na abi ku anazhi ba na anikpama ba. ");
INSERT INTO ninNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Anishirr abi igbu ba wemi a gru kuma ni Yesu ku, a ku hi ma nggo, na tsi ku ango di a bu share na anga ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu ka rri nu uddu ku ni inyi ni kri ni inkla yirr wa na cha kakuma ni igbu wa nggo à di so. ");
INSERT INTO ninNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Anishirr banu a ba ugo numa nggo ukpa ku ttu nu utakpa gri na nga ni Yesu ku. Nggo Yesu à hi iyo isisurr imbarr yi, na ddu ugo uni lo wa di, “Iziya, vu isisurr, Abachi nggurr ila ure muwa yi zhi.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Abitsarr na are ba re ni ikpa di, “Ugo nggo à ba du uwa si Abachi! Wanggo à si imarr na Abachi ku!” ");
INSERT INTO ninNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu hi amarr ambarr ka, na da di, “Angginggi du imba i ri amarr ndanda ni isisurr imba yi? ");
INSERT INTO ninNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Watanggo si inkindirr ivitsa, ingga bu da di, ‘A nggurr ila ure imuwa yi zhi,’ ka ingga bu di, ‘Gru zirr’? ");
INSERT INTO ninNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ingga ta tsarr imba di Uvuvurr a Unushirr à se nu ukyekye ku nggurr ila ure zhi ni ingbingbru inggi yi.” Na kasarr na ddu uni lo wa di, “Gru, ba abubo a ikurr amuwa ni kuma ni iko!” ");
INSERT INTO ninNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ugo wa gru na ba abubo a ikurr ama wa na kuma ni iko. ");
INSERT INTO ninNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nggo anishirr ba a hi meme, isisu i ki ba, aba nyarr ku Abachi, nggo à nu anishirr ukyekye ukuma. ");
INSERT INTO ninNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nggo Yesu à du unto kuma na ko kuma, na ku hi ugo numa nggo à yo ma du Matiyu, uwa à so nu uki ku kpa inklo imimi ku, na ddu ma di, “Ga mi.” U Matiyu à gru ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","A sha so ntsɨ, i Yesu na abiga ma ba a kuma ku so ri ila ni ingbahru ni iko i Matiyu. Abi kpa inklo imimi na abi la ure abanu a se nabo meme. ");
INSERT INTO ninNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nggo anu Farrisi ba a hi meme na zhi abiga ma ba di, “Angginggi du unitsarr amba wa à so ri na abi la ure tuku abi kpa inklo imimi ba?” ");
INSERT INTO ninNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nggo a so wo ba na gru da di, “Abangga ba nggo a si lo hen a si di zha uni ni ahun hen. Abi lo ngga a di zha uni ni ahun. ");
INSERT INTO ninNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Imba kuma ku zhi kye, ure unggo ku ù da di angginggi, nggo a ti da di, ‘Ingga zha di imba bu si abi ki itito, ni si zha ito aseki inggi hen.’ Ingga si nga nye yo abi sama ni ìlà hen. Ingga nye yo abi la ure.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mre abiga bu Yohana uni zzu na amasirr ba a gru nga ni zhi Yesu di, “Inta na anu Farrisi ba di vu angu, anggi mu du abiga amuwa ba si di vu angu meme hen?” ");
INSERT INTO ninNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","I Yesu ddu ba di, “Imba kye i ka wre, ikpikpa i uni garr he̱he̱ a bu so ni iyo, uni garr wa à ni se na ba? Iya! I ka si wre meme hen! Azhibarr wa so nga nggo a taka ba uni garr he̱he̱ wa mi wa glo na ba, aba taka vu angu. ");
INSERT INTO ninNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“A si di ba upri nkru uhe̱he̱ awarr sa ku ankru akuku hen. Nggo upri nkru uhe̱he̱ ku ti ngahre glo, i ingahre yi ta kri kakami na ankru kuku ka. ");
INSERT INTO ninNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ka undurr ka si ba ahi ahe̱he̱ kasurr nu unggakpa ku zu ahi ukuku hen. Uwanggo nggo a ti na meme, ahi ahe̱he̱ wa a ta tsi unggakpa ukuku ku nggarr na kuhre, unggakpa ku u ta sama nu undu zizo. Meme nggo, a ta surr ahi ahe̱he̱ nu unggakpa ku zu ahi uhe̱he̱, aba aha mi ta kurr zizi.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nggo Yesu à ni ko re na ba, ugo numa à si ankpye mu nu uki ku issubi ku, à gru nga ni kuttu ku Yesu na aza, na da di, “Uva mu nggo ttu ziza, ga mi ku sa ungo muwa ku na ku du ma à tasi ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu na abiga ma ba a gru ga ma kuma. ");
INSERT INTO ninNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","U ayamba numa nggo a so di ji ayiyi ki ase awurr na aha, à gru ga Yesu nu ugo, ku vu ku utu ku ankru ku. ");
INSERT INTO ninNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ayamba wa da ni isisurr ima di, “Ingga ti sa ungo na ankru amaka, ingga ta wre.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu kasarr na hi ma, na ddu ma di, “Ayamba, vu isisurr! Iyo isisurr imuwa nggi i du uwa i wre.” Na ankpu ayirr ayamba wa à wre. ");
INSERT INTO ninNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","I Yesu rri kuma ni iko i ankpye yi. Na ku hi ba a so ba azhittu na nggurr ungo na angu na so yì kadada. ");
INSERT INTO ninNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yesu à ddu ba di, “Huzzu, imba wemi! Uva wa à si ttu hen, a so kurr si ina mu!” Aba wemi me̱ ma. ");
INSERT INTO ninNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nggo anishirr ba a huzzu ku kri na abi ka, uwa mirri ku vu uva wa nu ungo gɨ, uwa à tasi. ");
INSERT INTO ninNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ure ukuma u kago na anga akama. ");
INSERT INTO ninNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu gru nabo, na ta so kuma, anishirr aha banu aba akreshi a gru so ga ma, na so du hantu di, “Uvuvurr a Doda, kye inta na ashishi ka itito!” ");
INSERT INTO ninNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nggo Yesu mirri ni iko yi, aba kreshi bangga ba a ga ma, uwa à ddu ba di, “Imba kpanye di ingga i ka du imba wre?” Aba kpanye di, “Yo-o, Atiko!” ");
INSERT INTO ninNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","I Yesu ki ungo sa ba na ashishi na da di, “Du yi si nâ ta si iyo isisurr imba yi!” ");
INSERT INTO ninNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ashishi ka a bwu ba. I Yesu gba ba utu kakami di, “Si bre ku anishirr hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aba kà na kuma ku bre kago ku anishirr na anga akama. ");
INSERT INTO ninNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nggo aba kreshi aha ba a so share, anishirr abanu a gri ku uni ku anazhi numa nggo à si di re hen. ");
INSERT INTO ninNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nu unto ku Yesu han izhi ndanda yi huzzu ku, uwa gru ko re. Anishirr ba nggo a se nu unto ku a ku ayisurr, na da di, “Inta nise hi inkindirr numa ma mi kye ni Israila.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Anu Farrisi ba gru ko re di, “Ugo nggo, à su uttu a aninkindirr, aba yo a nu ma ukyekye ku han izhi ndanda huzzu ku anishirr.” ");
INSERT INTO ninNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","I Yesu zirr kago igbu inkpinkpi ni itsitsa yi. Na di tsarr ure ku na aki ka ibarr ambarr ka na di bre ba Ure ku wre ku ni itu ittu i Abachi yi. Na du anishirr a wre ni ilolo ni ivri imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nggo Yesu à hi akpukpa anishirr wa, itito i ki ma na ba, nggo a so kada na sama nu undurr ni zi ba. A zzu nâ ta si aminta ba nggo a sama na akikye. ");
INSERT INTO ninNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Na ddu abiga ma di, “Ikiri yi kri kaba abi hwa ba a si ntsɨmi. ");
INSERT INTO ninNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imba barr akikye ni īlá wa ni du ma turr abu undu du ba ku hwa ikiri yi vu nga ni iko.” ");
INSERT INTO ninNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mre i Yesu yo abiga ma awurr na aha ba nggurr bi, na nu ba ukyekye ku han izhi ndanda huzzu, na du anishirr wre ni ilolo ni ivri imbarr yi we. ");
INSERT INTO ninNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Uwanggo yo a si asa a abi ko na angu ba. Uni me̱me̱ wa asi Sima (nggo a yo ma di Biturr) tuku uzayirr wa Andoro; U Yakubu tuku uzayirr wa Yohana, amumarr bu Zabadi; ");
INSERT INTO ninNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","U Filibu tuku Batolomi; U Toma tuku Matiyu, uni kpa inklo i imimi wa; U Yakubu uvuvurr a Alifiyo, U Tadawo; ");
INSERT INTO ninNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","U Sima, nggo à se na amarr ka ako ambarr ka kakami, tuku Judasi Iskariyoti nggo à vu Yesu nu ba tsi ngu. ");
INSERT INTO ninNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu tu awurr na aha angga ba, na gba ba utu di, “Imba bu si rri kuma ni igbu i abangga ba nggo a si si ani Yahuda hen, ni si rri ni igbu nggi yi nggo anu Samarriya a so hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Imba kuma na anu Israila ba nggo a si nâ ta si aminta ngga a nado. ");
INSERT INTO ninNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kuma ku bre ba ure ku Abachi di, ‘Abachi à ka kuchi gri imba ki Uttu amba ba!’ ");
INSERT INTO ninNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ni du abi vri ba a wre, abi kɨ ba tasi, ni du abi lo ishi ba a wre, ni han anazhi ssuzzu ku anishirr. Ingga ni imba ukyekye ukuma ni si kpa inkindirr ni imba ba hen, imba mi bu zi abanu ni si kpa inkindirr na ba hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Si gri inklo hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Si gri ambu hen, ka ankru, ka anggakpaza, ka amfarr a uzirr hen. A ti ta zi imba ni inkindirr, imba si kà hen. Iwre abu undu ba bu ri ila. ");
INSERT INTO ninNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Imba ti rri ni igbu unkpi ka uvutsa, imba zha unushirr uzizi ni kuso ni iko ima yi ma na azhibarr wa nggo imba ta du igbu wa. ");
INSERT INTO ninNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Iko yi nggo imba ti rri, imba chi ba di, ‘Ingga chi imba ni isa i Abachi.’ ");
INSERT INTO ninNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Abi iko ba ti kpa imba, isu imba yi i ta so na ba; aba ti kà imba, imba gri isu imba yi ni ka huzzu. ");
INSERT INTO ninNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Inkla inggi yi nggo ì ta si kpa imba hen, ka a ta si wo imba hen, nggo imba ti ta huzzu ni iko yi, ka igbu wa, imba ttu ihurr yi na aza amba ka surr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ingga ko da ki imba su ure ujiji mu di, iha yi nggo ì taka ni kuttu anishirr bu Sodomu tuku Gomorra na azhibarr a ibre amu wa, ì taka su ntsɨmi mri inggi yi nggo i taka ni kuttu igbu uwama! ");
INSERT INTO ninNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Imba kye, ingga turr imba huzzu nâ ta sa aminta nu umi ku aniche. Meme nggo, imba bu zirr ndindi nâ ta sa ànìwǎ ngga, ni na chě sama ni ìlà nâ ta sa ananddu ngga. ");
INSERT INTO ninNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Imba bu zirr ndindi, ni bu hi di anishirr ta gri imba kuma ni into i ibre amu, na ta hlo imba na aki ka ibarr ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ni itu imungga aba ta gri imba kuma na abi gri igbu ba ba na atuttu. Uwama yo sa anko wa nggo imba ta da ba Ure ku wre ku, ni ta da ku abangga ba nggo a si si ani Yahuda hen meme. ");
INSERT INTO ninNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nggo a ti vɨ imba gri ko na ba, imba si wri kpakpa ni inkindirr yi nggo imba ta da hen. Abachi nggo ta ni imba inkindirr yi nggo imba ta da nu unto ukuma. ");
INSERT INTO ninNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","A si si imba ngga ta re hen, a si Izhi i Abachi yi mu ta kpa ure ku re ki imba. ");
INSERT INTO ninNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Imuyirr ta vu imuyirr nu ba a tsi ngɨ, akiki ta vɨ amumarr ambarr nu ba tsi ngɨ. Amumarr ta tsi na akiki ambarr na ta du ba ngɨ ba. ");
INSERT INTO ninNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anishirr namri, ta kà imba ni isa mungga, uwanggo nggo ti kri ngbangba ku ma ni ikikre yi, Abachi taka kpa ma ttungo. ");
INSERT INTO ninNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","A ti na ki imba ndanda mi ni ìgbù wanggo, imba kuma ni ìgbù numa. Jiji mu, ingga ko da ki imba, imba si ta zirr ìgbù i Israila yi kre bari ingga Uvuvurr a Unushirr kanga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Uvuvurr uni bre si mri unitsarr ama wa hen, ka ugarr à si mri atiko ama hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","À si inkindirr izizi uvuvurr uni bre a bu hi inkindirr nâ ta su unitsarr ama wa. A ti yo atakye ni iko wa du Belzebulu, aba ta yo anishirr bi iko ma ba ki abata ngga? ");
INSERT INTO ninNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ni ima yo imba bu si kru isisu imbarr yi hen. Inkindirr yi nggo ì sharri ì ta huzzu na abi, inkindirr yi nggo a ttu yi sharri nggo anishirr ta hi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Inkindirr yi nggo ingga da ki imba sharri ni ibwu, imba bu ku da yi huzzu ku anishirr du ba wo. Inkindirr yi nggo ingga bre ki imba zhazha imba ku hun kri na atu a iko ni du hantu du anishirr wo. ");
INSERT INTO ninNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Imba si kru isisu i anishirr ba nggo se nu ukyekye ku ngu ampu ikpa wa na ka si ngu izhi imba yi hen. Undurr uyirr wa nggo imba ta kru ma uwanggo à su uwanggo nggo à ka ngu ukpa ku tuku izhi yi nu uru ku rri asese ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Anishirr ba namri a hi di a di re ananddu aha angalanzirr yirr yo mre? Anddu ayirr à si di ttu sama ni ihi i Abachi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Abachi à hi di infunfutu imba yi i si ibirr nggi. ");
INSERT INTO ninNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ni ima yo, imba bu si kru isisu i inkindirr hen, uwa se nu undu mri ananddu shishemi! ");
INSERT INTO ninNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Imba ti bre ku abanu di imba i si amungga, ingga mi ta da ku Aki amungga nu unkplassu di imba si abiga amungga. ");
INSERT INTO ninNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Imba ti di imba i si hi ingga hen, ingga mi ta da ku Aki amungga wa nu unkplassu di imba i si si amungga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Imba si kye di ingga gri ki imba isu isisurr mu ni ingbingbru inggi yi hen, ingga si gri ki imba isu isisurr mu hen, ingga nga ki imba ni iku. ");
INSERT INTO ninNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ingga nga i du “ ‘uvuvurr ki iku na aki ku, uva na ayirr ku, ayamba a uvuvurr na ayimbarr ku. ");
INSERT INTO ninNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Uni kri angba achi nu unushirr ku ta zhi nu umi ku iko ima iyo.’ ");
INSERT INTO ninNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Undurr wa nggo ti kpanye na aki ku ka na ayirr ku mri ingga, uwa si ma uniga ingga hen. Undurr wa nggo ti kpanye nu uzuma ku, ka uva ma, uwa si ma uniga ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Undurr wa nggo ta si ba unkunkurr umaku na ga anko amungga wa hen, uwa si ma uniga ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Undurr wa nggo ti kri ngbangba du uwa ta so tsitsirr, uwa ta ttu. Undurr wa nggo ti kà itu ima na ga ingga, uwa ta so tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Undurr wa nggo ti kpa imba, uwa kpa si ingga. Undurr wa nggo ti kpa ingga, uwa kpa si Abachi nggo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Undurr wa nggo ti kpa uni kpa are a Abachi na hi di a su uni kpa are a Abachi, uwa taka kpa azadi ka nggo a kpa uni kpa are a Abachi wa. Unushirr wa nggo ti kpa unushirr uzizi nggo hi di a su unushirr uzizi, uwa ta kpa azadi ka unushirr uni na uzizi. ");
INSERT INTO ninNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Undurr wa nggo ti nu amwe atsitsa abi ga ingga ba amasirr à iso, nu nggo a hi di a so ga si ingga, undurr wama à se na azadi ama.” ");
INSERT INTO ninNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nggo Yesu a re kre na awurr na aha abiga ma ba, na gru share nu unto kuma ku, ku so tsarr ba na bre ba are ka ni igbu igaga yi na anga akama. ");
INSERT INTO ninNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Nggo Yohana uni zzu na amasirr wa à kri nu uki ku iharr ku, na wo are ka nggo Kristi so na ka, na tu abiga ama ba na ku, ");
INSERT INTO ninNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","na da ba di a bu ku zhi ma di, “Ùwà yo su uwanggo nggo a ta kanga wa, ka inta bu kye anko a unuma mu?” ");
INSERT INTO ninNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","I Yesu à ka sa ba di, “Kakuma ku bre ku Yohana inkindirr yi nggo imba ni wo na aseki ka nggo imba hi na ashishi amba. ");
INSERT INTO ninNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Aba kreshi a hi abubo, abi gbo na ampi a gru zirr, abi lo ishi a wre, aba agbatu a wo ure, abi kɨ a tasi, abi iha a wo Ure ku wre ku. ");
INSERT INTO ninNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Abangga ba nggo kri ngbangba, Abachi à yo ba angu azizi, na si ta jaku ni itu i aseki ka nggo ingga na nggo hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nggo Abiga Yohana ba a ka so kuma, Yesu gru so bre ku akpa anishirr wa ure ni itu i Yohana di, “Imba di kuma ku di kye sa angginggi na ankpuji wa? Itu i ihihru nggo unddunddu u go i vu darr? ");
INSERT INTO ninNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Uwa ta si si meme hen, imba i di kuma ku di kye sa angginggi? Unushirr wa nggo surr iki izizi i ankpinkpye nggo? Abi so na ando a uttu ngga a di surr iki ima yi, na si si abi di zirr ni ijiji mu hen! ");
INSERT INTO ninNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Imba da ki ingga, imba i kuma ku di kye sa angginggi? Uni kpa are wa yo? E-e! Imba hi di undurr wa nggo imba ku hi à mri uni kpa are. ");
INSERT INTO ninNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Yohana yo su undurr uwama wa nggo a charr da na angbamvu ka di, Abachi da di, “ ‘Ingga ta tu unitu amungga wa, du ma kuchi ku bu na anko wa ssubi ku ùwà.’ ");
INSERT INTO ninNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Di ingga da ki imba: A nise ngri unushirr ni ingbingbru inggi yi nggo à mri Yohana uni zzu na amasirr. U wanggo nggo su uvuntsɨ ni ittu i unkplassu yi a mri Yohana. ");
INSERT INTO ninNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Bazhi na azhibarr a ime̱me̱ wa nggo Yohana uni zzu na amasirr wa à huzzu bre ba Ure ku wre ku nga ziza, ittu i unkplassu yi ì so kuchi kyekye mi ni du anishirr ba a di zha di aba a ta kpa yi nu ngbrengbre. ");
INSERT INTO ninNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nggo Yohana à nise nga, abi kpa are ba, na Are ka Musa ka a bre are ni itu i Ittu i Abachi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Imba ti kpanye ni inkindirr yi nggo are ka a da nggo, imba ta kpanye di, Yohana yo à si Iliya, nggo a da inga ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Undurr wa nggo ti se na atu ka iwo ure, uwa bu wo! ");
INSERT INTO ninNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ziza, ingga ka tsarr anishirr bu ziza ba kye na angginggi? A se nâ ta si amumarr ngga na abubo a irro. Inkla numa du inkla numa, na so du akpa da di: ");
INSERT INTO ninNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Inta nggurr inggingga di imba bu rro, imba si rro hen. Inta i ba azhittu, imba si yì hen!’ ");
INSERT INTO ninNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nggo Yohana à nye, sama ni iri ka iso inkindirr, anishirr a bre di, ‘A se na anazhi ni itu!’ ");
INSERT INTO ninNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ingga Uvuvurr a Unushirr i nga ni di ri ni so, aba bre di, ‘Kye ugo ni iri na so ahi kpekpe wanggo na yi! Ikpikpa i abi kpa inklo i imimi na abi la ure!’ Nggo anishirr a ta se ni ihi i Abachi, ihi yi i ta tsarr di ihi i Abachi imbarr yi ì si ijiji. Ihi i Abachi yi i ta du anishirr a hi ina wre ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Anishirr ba nggo Yesu à na aseki ka ku ayisurr shishemi na ba nggo a kà ikpa ure ku Yesu ku, na kuchi ni ila ure imbarr yi. Ni ima yo, Yesu ki unfu na ba na da di, ");
INSERT INTO ninNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“I taka vri ki imba kakami, ùwà Korrazi, nu ùwà mi Betsada, uje umba! Aseki ka ikagri ka nggo ingga i na ka ni imba ba, ka di ingga i na ka su nu Taya nggo tuku Sido, anishirr abama ka vu angbanja iki ndanda a surr, na surr inturu nu ukpa, du yi tsarr da aba a ka ba ttungo ni ila ure imbarr yi ngbangbamu ba! ");
INSERT INTO ninNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ingga nggo ko da ki imba, na Azhibarr a Ibre Amu wa, Abachi à taka kye Taya tuku Sido na ashishi ka itito mri imba! ");
INSERT INTO ninNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Uwa ta si imba anu Kapanahu, imba kye di Abachi à ta kpa imba hun kuma nu unkplassu? Iya, a ta turr imba surr nu abubo a iso abi kɨ wa. Ka di ingga i na aseki ka kagri ka nggo ingga ina ka ni imba ba su nu Sodomu, ka si ma igbu uwama a ni kri ari! ");
INSERT INTO ninNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ingga nggo ko da ki imba, na azhibarr a ibre amu wa, Abachi à taka ni kye Sodomu na ashishi ka itito mri imba!” ");
INSERT INTO ninNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Na attuttu akama, Yesu à da ba di, “Aki, Atiko nu unkplassu tuku imimi, ingga nyarr ku ùwà, nggo ùwà ka aseki ka ngga ka sharri ku abi ihi ba, tuku abi bre angbamvu ba, ni kpanye ni tsarr anishirr ba nggo a kye ba ki amumarr. ");
INSERT INTO ninNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","I si meme yo Aki mungga, nggo ùwà kye iwre ku ùwà, ni na meme. ");
INSERT INTO ninNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Aki mungga wa a ni ingga ukyekye ku na aseki ka we. Undurr si ma ni hi Uvuvurr wa sama ni hi Abachi hen. Undurr si ma ni hi Aki wa sa nu Uvuvurr wa hen, na abangga ba nggo Uvuvurr wa kpanye na tsarr ba Aki wa. ");
INSERT INTO ninNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Imba nga yi ni ingga ku, imba wemi nggo so ki iha, imba nggo so gri iki i rɨ kakami, ingga ta ni imba isu isisurr. ");
INSERT INTO ninNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Imba ka atu amba wa ni ingga ni ga itsarr mungga yi. Ingga su chě, ni si di kri itu hen, meme nggo imba ta kpa isu isisurr ku atu a imba. ");
INSERT INTO ninNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Unkunkurr mungga ku u si vri iba hen. Itsarr imungga i si tsɨ hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ni ivivi ima yi, na Azhibarr a Isu anu Yahuda wa i Yesu na abiga ma ba a gru ko zirr ba ni izzuzzu i ikiri. Iyo ki abiga ma ba, aba gru so mɨ ato a ikiri wa so ta. ");
INSERT INTO ninNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nggo anu Farrisi abanu a kri na hi ba ni so na meme yi, na zhi Yesu di, “Kye na! Abiga amuwa ba a so na inkindirr yi nggo are amunta ka da di i si iwre aba bu na yi na Azhibarr a Isu wa hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu kasarr na sa ba di, “Imba nise bre nu ungbamvu ku, inkindirr yi nggo Uttu Doda à na nggo iyo ki ma na abiga ma ba? ");
INSERT INTO ninNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Uttu Doda à mirri ko nu uki ku Abachi ku, uwa na abiga ma ba na ku vu unfonfo wa nggo a gri ga ku Abachi ku ta. Are amunta ka a si kpanye aba bu na meme hen. Unfonfo uwama a kurr ku abikye aba yo na nkpambarr nu unto bubo ukuma. ");
INSERT INTO ninNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Imba nise bre unto unggo ku nu ungbamvu ku Are ka Musa ka nggo da di, abikye ba di na undu nu Uki ku barr ku i si wre aba bu na na Azhibarr a Isu wa, nggo are ka a si kpanye hen? A si kye ina imbarr ima ki ila ure hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ingga ko da ki imba di undurr wa nggo mri Uki Unkpi ku barr Abachi ku a kri ni inggya. ");
INSERT INTO ninNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Angbamvu ka Abachi ka a da di, ‘Ingga zha di imba bu si abi ki itito, ni si zha ito aseki inggi hen.’ Imba si hi ankpi are akama hen. Ka di imba hi ka, imba ka si bre amu ku abangga ba nggo a si na inkindirr indanda hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ingga Uvuvurr a Unushirr yo sa Atiko a Azhibarr a Isu wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nggo Yesu à du unto kuma na kuma nu uki ku issubi umbarr unuma ku, na ku hi ");
INSERT INTO ninNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ugo numa nggo ungo umaku u sharr kre. Anishirr abanu kri nabo na so gbye Yesu di a bu na inkindirr indanda, wre ba ka vu ma da à kpala. Aba zhi ma di, “Are munta ka a kpanye di i wre aba du unushirr à wre na Azhibarr a Isu wa?” ");
INSERT INTO ninNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu à zhi ba di, “Unggonggo nu umi umba ku ivinta ama ka jaku nu unkaharr na Azhibarr a Isu wa, uwa ka si ku vu ma gba huzzu hen? ");
INSERT INTO ninNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Imba kye unushirr si mri ivinta hen? Meme nggo, iwre a bu na wre na Azhibarr a Isu wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu ddu ugo nu unka ungo wa di, “Na ungo ku.” Ugo wa na ungo ku u wre keke, nu kaki kyekye nâ ta si ungo uyirr ku. ");
INSERT INTO ninNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Anu Farrisi ba a huzzu ku re bi nggo aba a ta na na ngu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nggo Yesu à wo di a so zha anko a ingu ma, na gru share nu unto ukuma. Anishirr shishemi a ga ma. Uwa du abi vri ba we a wre, ");
INSERT INTO ninNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na gba ba utu di a bu si bre ku anishirr du uwa à si unggonggo hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","A na meme di i bu si jiji nâ ta si nggo a charr nu ungbamvu ku uni kpa are wa Ishaya di: ");
INSERT INTO ninNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Uwanggo yo a su uvurr iko wa nggo ingga i hla ma ni kpanye na ku, isisurr imungga yi i si na ku kakami. Ingga i ta nu ma Izhi imungga yi, uwa ta ni da kago ku anishirr di ivi i ikpa ttungo i nga ku ingbingbru inggi yi we. ");
INSERT INTO ninNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","A si taka ri anta ka hantu hen, ka zirr na di hantu na atu anko hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","A si ta murr uguga ku nggo u vu kachi hen, na si ta zhi irrirri iru yi nggo i ko ki ywhiywhirr ì zhi hen. À ta di kri na hi ba ni bre amu ka yo narrnarr bari. ");
INSERT INTO ninNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Isa ima yi taka si inkindirr iyo isisurr ku anishirr we.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nu ugo kuma, aba gru gri ugo numa nggo a di ku anazhi, na se na akreshi, na si na agbatu, na nga ni Yesu ku. Yesu ni du ma wre, uwa gru re na hi. ");
INSERT INTO ninNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Anishirr ba we nggo a kri nabo a hi inkindirr yi nggo Yesu na yi na ku ayisurr na da di, “Ugo nggo wa ka su Uvuvurr a Doda jiji mu?” ");
INSERT INTO ninNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nggo anu Farrisi ba wo ure ukuma na da di, “Ugo nggo so han izhi ndanda yi huzzu nu ukyekye ku Belzebulu, uttu a anazhi yo mre.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nggo Yesu kri na ko hi amarr ambarr ka, na ddu ba di, “Ittu yi nggo ti ga akpa i ta jaku. Ìgbù wa nggo à ti ga so na nkanka na so vi ni ikpa a si ta tanko hen. Iko inggi yi nggo ì ti ga so na nkanka na kri di tsi ni ikpa ì si ta tanko hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Isheta ki itu ima à ti han Isheta, na ti so tsi ni itu ima ku, ittu yi ta kri kingginggi? ");
INSERT INTO ninNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ingga ti han izhi ndanda yi nu ukyekye ku Belzebulu, abiga amba ba mu a di han ba nu ukyekye ku unggonggo? Abiga amba ba ta da ki imba di imba na ndanda mi. ");
INSERT INTO ninNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ingga ti han izhi ndanda yi nu ukyekye ku Izhi i Abachi ì na ima ì tsarr di, Ittu i Abachi yi ì ka nga ba ni imba ba. ");
INSERT INTO ninNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Di ingga tsarr imba ure numa. Undurr wa nggo à ti du uwa à ta ku ki ayi ni iko i unushirr ukyekye, uwa ta ku vu ma lo zu bari na vu iki yi. ");
INSERT INTO ninNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Undurr wa nggo ta si so zi ingga gri anishirr nga na Abachi ku hen, uwa si uni karr ingga. Undurr wa nggo ta si si uni ssubi ni ingga ku hen, uwa si uni se hre. ");
INSERT INTO ninNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Meme yo, ingga ko da ki imba, inkindirr yi nggo unushirr ti na, tuku ida indanda mi aba ta nggurr yi zhi ku. Uwa a ta si nggo unushirr à da ure undanda ni itu i Izhi Iwre yi, a si ta nggurr zhi ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Undurr wa nggo ti da ure undanda ni itu i Uvuvurr a Unushirr, aba ta nggurr zhi ku. Uwa ta si Izhi Iwre yi, undurr wa nggo ti da ure undanda ni itu ima yi, aba si ta nggurr zhi ku ziza, ka na ase ka so nga ka hen. ");
INSERT INTO ninNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Unkunkurr ku nggo ti wre u di klo inkpinkpo i iwre. Unkunkurr ku nggo u su undanda, inkpinkpo ima yi i si ta wre hen. A di hi iwre i unkunkurr ni inkpinkpo ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imba inkirr i ànìwǎ andanda. Nu nggo isisurr imba yi i si imimi, imba ka na kingginggi ni da ure uzizi na angu amba ka? Angu ka di da si inkindirr yi nggo tsarr ssu ni isisurr i unushirr. ");
INSERT INTO ninNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Unushirr uzizi di da ure uzizi zhi ni isisurr ima izizi yi. Umimi unushirr à di da ure undanda zhi ni isisurr ima imimi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Imba bu hi di na Azhibarr a Ibre Amu a Abachi wa, anishirr a taka bre inkindirr indanda yi wemi nggo à re tankpami nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ubarr angu umuwa nggo taka lo ùwà, ka kpa ùwà ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Abitsarr na Are ba na anu Farrisi abanu a gru re ni Yesu ku di, “Unitsarr, inta zha du ùwà bu na inkindirr numa ikagri di inta hi.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu à ddu ba di, “Anishirr amimi na abi la ure ba ari ba, aba yo a zha di a bu na ba inkindirr ikagri. Undurr à si ta na ba inkindirr ikagri iyirr mi hen. Inkindirr i ikagri yi nggo ingga ta tsarr imba inggi i si ikagri i Yunana uni kpa are wa. ");
INSERT INTO ninNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Nggo imba wo di Yunana à rri so ki ivi itarr ni ibittu itarr nu umi ine ku ampu ikikla, Uvuvurr a Unushirr mi meme à taka rri so ni imimi ki ivi itarr ni ibittu itarr. ");
INSERT INTO ninNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na Azhibarr a Ibre Amu wa, anishirr bu Nineve a taka gru kri ni imba anishirr ba ari ba ba, na ta da di imba i kpala. Nggo a wo ure ku Abachi nu Yunana ku, na kasarr ni ila ure imbarr yi. Di ingga da ki imba, undurr numa se ni inggya nggo à mri Yunana inkpinkpye! ");
INSERT INTO ninNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Na Azhibarr a Ibre Amu a Abachi wa, ayamba wa nggo su uttu nu Sheba à taka gru kri ni imba anishirr ba ari ba ba, na ta da di imba i kpala, nggo a di gru zhi ni ìgbù ama wa gbagbamu à nga, ni di shirr ku uttu Solomo atu na are krizhizhi ka nggo à di re. Ingga ko da ki imba di undurr numa se ni inggya, nggo mri uttu Solomo ni inkpinkpye! ");
INSERT INTO ninNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nggo izhi ndanda ti huzzu ku unushirr nggo, i di rri na ankpuji tankpami ku di zha unto ki iso. Nggo izhi yi i ti ku zha lankarr, ");
INSERT INTO ninNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i di da di, ‘Ingga taka kuma ku kye iko yi nggo ingga i ka du.’ I ti ka ku hi iko yi kurr gigyemi, ni wre aba ssu yi bi na abubo a iso. ");
INSERT INTO ninNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Izhi yi i di huzzu ku gri anazhi numa atangba nggo a mri ma undanda, aba ta nga ni so nabo ndo. Nggo a ti mirri ku ji so ba, ugo wa di kaki ankalanttu mri nggo a di se ni ime̱me̱ yi. Ì taka si meme yo na amimi anishirr ba ari ba ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nggo Yesu ni ko re na akpa anishirr wa ku, ayirr ama wa, Maryamu ndo na amuyirr ba a nga ni kri na abi, na ko zha di aba ta re na ku. ");
INSERT INTO ninNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Undurr numa da ku Yesu di, “Kye, ayirr amuwa ndo na amuyirr amuwa ba a kri na abi, di aba ta re nu ùwà ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu ka sa ku ugo wa di, “A su unggonggo sa ayirr amungga na amuyirr amungga?” ");
INSERT INTO ninNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Na na ungo tsarr abiga ma ba, na da di, “Abangga ba yo sa ayirr amungga na amuyirr amungga ba! ");
INSERT INTO ninNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Undurr wa nggo ti na inkindirr yi nggo Aki amungga wa nu unkplassu zha di a bu na yi, uwa yo à si uzayirr amungga, nu uvayirr amungga, na ayirr amungga wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Azhibarr ayiyirr ama wa i Yesu à gru huzzu ni iko yi na ji ko ku so nu unddu inyi ku na ta tsarr anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Anishirr ba nggo nga na ku a kri mwe kakami, uwa gru rri ku ji so nu uddu ku nu umi ku amasirr ku, na du anishirr ba wemi nu unddu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Na so bre ba are shishemi na assurre di: “Uni do numa nggo huzzu ku ttu ikiri. ");
INSERT INTO ninNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nggo a hi ingbingbi kiri yi, inuma yi i kusurr na anko, aminche nga ni ta yi ri. ");
INSERT INTO ninNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Inuma yi kusurr na ako han, nggo imimi yi i si ntsɨmi. Ikiri yi i zzu hanhan mi, nggo imimi yi ì si kri ji kuma nu umi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nggo azhi wa huzzu, na tu, ikiri yi ì kɨ nu nggo injinja yi so fafami. ");
INSERT INTO ninNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Inuma yi kusurr ni intto, intto yi furr ni turr yi. ");
INSERT INTO ninNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ingbingbi numa i kusurr ni imimi izizi, ni zzu, ni hurr, ni na ingbingbi, ato numa wa a ma ayirr yirr, anuma wa iso titani, ato numa wa iso titarr. ");
INSERT INTO ninNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Undurr wa nggo ti se na atu ka iwo ure, uwa bu wo!” ");
INSERT INTO ninNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Abiga bi Yesu ba a nga na ku, ni zhi ma di, “Angginggi du ùwà re ku anishirr ba na assurre?” ");
INSERT INTO ninNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Uwa ddu ba di, “A ka tsarr imba aseki ka nggo à sha ka sharri ni itu i Ittu i Unkplassu yi ba. Uwa a ta si abanu ba na anko, a sha aseki angga ka sharri ba. ");
INSERT INTO ninNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Undurr wa nggo à hi inkindirr, Abachi à ta nu ma ihi zizo kakami, du ma se na yi shishemi. Uwa a ta su undurr wa nggo si hi inkindirr hen, Abachi à ta vu ma kpa ihi ivintsɨ yi nggo a se na yi mi glo. ");
INSERT INTO ninNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inkindirr yi nggo i du ingga re na ba na assurre i si nggo: “ ‘A ko kye, na si kye hi hen; na so wo, na si vu gri hen, na si hi inkindirr hen. ");
INSERT INTO ninNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ure ku nggo Ishaya uni kpa are wa à da ù jaku na atu ambarr wa di: “ ‘Imba ta di wo ni so di wo mu yo; ni ta di kye ni so di kye mu yo. ");
INSERT INTO ninNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Isisurr i anishirr angga ba i tsɨ kyekye; atu ambarr ka a si wo ure hen, ashishi ambarr ka a kattu. Wre ba a si ta kye hi na ashishi ambarr ka hen, na si ta wo na atu ambarr ka hen, na si ta ri amarr hi ni isisurr imbarr yi hen, na si ta kanga ni ingga ku, ni di ingga du ba wre ni ivri imbarr yi hen.’ ");
INSERT INTO ninNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Abachi à na wre ki imba nu nggo a du ashishi amba ka a kye hi, na du atu amba ka a wo ure. ");
INSERT INTO ninNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ingga so da ki imba ure ujiji mu di abi kpa are shishemi na abi na wre abi kuchi ba nggo a zha ihi inkindirr inggi yi nggo imba i hi na si hi yi hen, na zha iwo inkindirr yi nggo imba i wo na si wo yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Imba wo yi, ki, uwanggo yo si inkpi i assurre a uni do wa: ");
INSERT INTO ninNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Abangga ba nggo wo ure ku ni itu Ittu i Unkplassu yi, na si hi inkpi yi hen, a si nâ ta si ingbingbi ikiri yi nggo kusurr na anko, mre umimi wa nga ni vu ba kpa inkindirr yi nggo a tsarr ba na yi glo. ");
INSERT INTO ninNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ingbingbi ikiri yi nggo i kusurr na ako han ka, abangga si anishirr ba nggo a kpa ure ku korrmi na nyarr nggo a wo ku. ");
INSERT INTO ninNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","U ku si rri ba ni isisurr tanko hen. Nggo ivri, ka iha numa ti nga ba ni itu i ure yi, aba ka ko nu ugo. ");
INSERT INTO ninNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Uwa ta si ikiri inggi yi nggo i kusurr ni intto yi, abangga a si abangga ba nggo a wo ure ku, ivri i izharr iki ingbingbru inggi yi, ni ivri isisurr na aseki, a turr ure ku huzzu ni isisurr imbarr yi du ku si na undu hen. ");
INSERT INTO ninNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Uwa ta si ikiri inggi nggo i kusurr ni imimi i iwre yi, abangga a si abangga ba nggo a wo ure ku na hi inkpi yi. Aba yo ato ambarr wa di klo inkpinkpo, ato numa ayirr yirr mri inkindirr yi nggo a ttu nggo, abanu ato iso tani, abanu ato iso tarr.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu tsarr ba na assurre numa zizo di: “Ittu i nkplassu i si nâ ta si ugo numa nggo à gri ingbingbi kiri ima izizi ku hi ni īlá ima. ");
INSERT INTO ninNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ni ibittu, nggo anishirr rri ni kurr, uni karr ma à gri ibibi uwri ndanda ku hi ku nu umi ku kiri ku, na kuma nado. ");
INSERT INTO ninNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nggo ikiri yi furr ni ko hru ni ko surr ingbingbi, aba kakye akpukparr wa a gru ko furr huzzu. ");
INSERT INTO ninNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Amirr iko ba akikye uni īlá wa ku da ku di, ‘Ankpye, ùwà gri ingbingbi ikiri iwre nggi ku ttu ni īlá yi, uwri u zhi nu momo mu?’ ");
INSERT INTO ninNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Uwa à ddu ba di, ‘A su uni karr unushirr nggo na meme.’ “Amirr iko ba zhi ma di, ‘Ùwà zha inta bu ku kpo uwri ku kahre?’ ");
INSERT INTO ninNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Uwa à kisa ba di, ‘Iya, nggo imba ti di imba ta ku kpo uwri ku kahre, imba ta kpo ikiri yi kye. ");
INSERT INTO ninNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Du ikiri yi nu uwri kri ndo mi, ma nu uga. Ingga ta da ku abi ihwa ba nu uga du ba sarr uwri ku ssubi na lo ku zu na ambwa na ambwa, wre nggo a taka yo uru, na ta hwa ikiri yi gri ku surr ni iwurr amungga wa.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu gru so tsarr ba na assurre numa zizo di: “Ittu i unkplassu yi i si nâ ta si ingbingbi i unkunkurr numa nggo a yo ku du mosita nggo unushirr gri ku ttu ni īlá ima. ");
INSERT INTO ninNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ingbingbi ima iyo di si ivintsɨ yi mri kakami nu umi ku ingbingbi i inkinkurr yi we. Aba ti ttu yi i di zzu, ni furr. U ku yo di kaki unkunkurr unkpi ku nggo aminche bu unkplassu ba ku di hun so na me ako ni inggingga ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu da ba assurre numa zizo di: “Ittu i unkplassu yi si ma mi: Ayamba numa nggo à du uwa à ta na unfonfo na sha imbimbru iyisti ntsɨ kasurr ni imbimbru ikpu na agbugba, na han yi ba zu, imbimbru ikpu yi i gru si ssu na agbugba wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu na undu na assurre ni itsarr anishirr ba aseki ka we. A si di da ba inkindirr numa gigyemi sama na assurre hen. ");
INSERT INTO ninNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","A di na ba meme nâ ta si nggo uni kpa are wa à da di: “Ingga ta re na assurre nggo ingga ti ta re na anishirr ba. Ingga ta da ba inkindirr yi nggo a sha yi sharri ba bazhi nu nggo a na ingbingbru yi mu nggo.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nggo Yesu gru rri kuma nu umi iko, na du anishirr ba, abiga ma ba gru kuma na ku, ku da di, “Bre ki inta inkpi i assurre a uwri wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","I Yesu ka sa ba di, “Ugo wa nggo à hi ingbingbi ikiri i zizi yi nggo à su Uvuvurr a Unushirr. ");
INSERT INTO ninNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Īlá yi inggi su ingbingbru yi. Ingbingbi ikiri zizi yi inggi sa anishirr ba we nggo a kaki anishirr bi ittu ba. Uwri ku u si abangga ba nggo a sa abu umimi wa. ");
INSERT INTO ninNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Unikarr wa nggo kuma ku hi uwri ku nggo asi Isheta. Ihwa inggi i si ivi i ikikre yi, abi ihwa abangga sa abitu ba Abachi ba. ");
INSERT INTO ninNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Nâ ta si nggo a ta nggurr uwri ku bi na tu ku nu uru, i taka si meme yo ni ivi i ikikre i ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ingga Uvuvurr a Unushirr taka tu abitu amungga ba du ba ku hla glo nu umi ki Ittu mungga ku anishirr ba we nggo di na ku abanu anko a ikuhre we, na di na aseki amimi. ");
INSERT INTO ninNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A taka vu ba surr nu uru unkpi, nabo yo aba ta yì, na ta anyinyirr. ");
INSERT INTO ninNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Anishirr bi na wre ba ta la zanzarr zzu azhi mu ni ittu i Aki ambarr yi. Undurr wa nggo ti se na atu ka iwo ure, uwa bu wo. ");
INSERT INTO ninNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ittu i unkplassu yi i si nâ ta si inkindirr ì tsɨ anta nggi nggo undurr gri ku sharri ni īlá. Nggo undurr numa à ku hi yi na ttu yi kuma ku sharri zizo, na nyarr na kru ku vu aseki ka nggo a zu ni iko ima yi a re namri, na kakuma ku re īlá ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ittu i unkplassu yi zizo i si nâ ta si uni re iki nggo di zha angbinta ka tsɨ anta. ");
INSERT INTO ninNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nggo ku hi iyirr inuma nggo i tsɨ anta kakami, na kakuma ku vu aseki ka nggo a se na ka ni iko ima nggo a re tsatsarr, na kuma ku re ingbinta yi. ");
INSERT INTO ninNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Zizo, Ittu i Abachi yi, i zzu nâ ta si izhizhi i vɨ ikikla, nggo di yo ni inyi na vɨ ikikla na nkanka. ");
INSERT INTO ninNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nggo i ti ssu, abi vɨ ikikla ba a gba yi na azhizhi ssuzzu na abi, na ji so na hla izizi yi surr ni igbigba, na vu indanda yi kahre. ");
INSERT INTO ninNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","I taka si meme yo na azhibarr a ikikre wa. Abitu ba Abachi ba a taka nga ni ddu anishirr amimi ba ki nanka na anishirr azizi ba. ");
INSERT INTO ninNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Abitu ba Abachi ba a taka ta anishirr amimi ba tu surr nu uru. Nabo yo aba taka yì na ta anyinyirr ku ivri.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu à zhi ba di, “Imba ssu aseki angga ka hi we?” Aba kpanye ku di, “Yo-o, inta ssu ka hi we.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu ddu ba di, “Inkpi inggi si di abitsarr na Are ba we, nggo a ka tsarr ba Are ka Ittu i Unkplassu yi ba a si nâ ta si akikye ni iko wa nggo à vu aseki he̱he̱ na akuku huzzu nu uki ku zu aseki umaku.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nggo Yesu à bre assurr are angga ka kre na gru chi ka na anga ka igbu akama. ");
INSERT INTO ninNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Na kuma ni igbu ni ngri ama wa. Na ku so tsarr anishirr ba ure ku Abachi ku nu uki ku issubi ku. Aba kye itsarr ima yi na vu angu gri, na zhi di, “Unggonggo a nu ugo nggo ihi inggi yi nu ukyekye ku ina iki ikagri yi? ");
INSERT INTO ninNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wanggo si su uvuvurr a unitarr wa yo hen? A si yo ayirr wa yo di Maryamu hen, nggo amuyirr ba yo a si anu Yakubu, Isuhu, Sima tuku Yahuda hen? ");
INSERT INTO ninNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amuyirr animba ba wemi a si so ni inta ba ni inggya hen? Ugo nggo kpa ukyekye ni ihi inggi yi zhi nu momonggo?” ");
INSERT INTO ninNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aba a kpa vri ku kakami na kà ikpanye na ku. I Yesu ddu ba di, “A di kye uni kpa are ssu nu ungo na abi, na di kpa ma chirr ni igbu ama tuku ni iko ima.” ");
INSERT INTO ninNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Na si na aseki ka ikagri shishemi nabo hen, nggo anishirr ba a si yo isisurr na ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","A si ni ivi ima yi u Hirridu uttu nu Galili wa, a wo ure ni itu i Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Na da ku anishirr ba nggo a di so na ku undu nggo di, “Mi uwanggo a ta su Yohana uni zzu na amasirr wa yo à tasi na kanga. Ima yo i du ma à se nu ukyekye ku na aseki ka ikagri angga ka.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hirridu yo à du ba vu Yohana uni zzu na amasirr wa, na lo ma na ache na harr ma ni itu i Hirridiya, ayamba a Filibu uzayirr wa. ");
INSERT INTO ninNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yohana à da ku di: “I si ta wre uwa bu hru Hirridiya ki uwami hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirridu à ka ngu Yohana ba, na so kru isisu di anishirr ba a ta tsi kputtu, nggo a hi di anishirr ba a kpanye di Yohana à su uni kpa are a Abachi. ");
INSERT INTO ninNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nggo azhibarr a ingri a Hirridu wa a ma, uwa na iga. Uva a Hirridiya wa a nga ni rro na age̱ ka anishirr ankpinkpye ba na su ku Hirridu isisurr, ");
INSERT INTO ninNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","uwa da di, “Ingga shi ku uwa azhi, inkindirr yi nggo ùwà ti zhi yi ingga ta nu uwa na yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ayirr a uva wa à ddu ma di a bu da di, “Gri ki ingga itu i Yohana uni zzu na amasirr wa ni inggya na agbugba zizami!” ");
INSERT INTO ninNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Isisurr vri uttu wa, uwa kye ishi azhi i ima yi, ni ishisha i abichirr ba, na da ku abi ta iku ba di a bu na inkindirr yi nggo uva wa à da nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Mre aba ku ttu itu i Yohana yi nu uki ku iharr ku. ");
INSERT INTO ninNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Na gri itu yi na agbugba ga ku uva wa, uwa kpa yi ga ku ayirr wa. ");
INSERT INTO ninNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Abiga bu Yohana ba kuma ku ba ankpunkpru ukpa wa gri ku zzu, na ku da ku Yesu inkindirr yi nggo ì la nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nggo Yesu à wo ure ku ittu i Yohana yi, na gru na abiga ama ba nayi ku rri nu uddu na kuma na abubo wa nggo anishirr a sama na wa. Anishirr ba a wo meme nggo na gru ssuzzu ni igbu imbarr yi a ga Yesu na aza. ");
INSERT INTO ninNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nggo Yesu à ssuzzu nu uddu ku na hi akpa anishirr wa a kri bi ma, itito ki ma na ba, uwa du abu ulolo ba wre ni ilo imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nggo ingbahru yi so ki, abiga ma ba nga ni da ku di, “Ingbahru i so ki, inggya asi ankpuji. Undurr à si di so ni inggya hen. Du anishirr ba kuma ku re ila nu umi igbu ku, ku atu ambarr.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu à ddu ba di, “I si ta wre aba bu kuma hen. Imba ku atu amba bu nu ba inkindirr i iri!” ");
INSERT INTO ninNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Aba ka da ku di, “Ivi ila yi nggo inta i se na yi, à si unfonfo ukywi yo ni ikikla iha mre.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","I Yesu à ddu ba di, “Gri ba ga ki ngga.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Na da ku anishirr ba di a bu kuso na agiga ka. Na ki ungo kpa unfonfo ukywi wa ni ikikla iha yi, na kye hun kuma nu unkplassu, na nyarr ku Abachi. Na mɨ unfonfo wa ki ankpunkpu a nu abiga ma ba, aba kpa nu anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Anishirr ba we a ri shi. Abiga ma ba vu ankpunkpu ka nggo a ji ssu pwi ni isisa iwurr ni iha. ");
INSERT INTO ninNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A si bre amba na amumarr kye hen, anishirr ba nggo a ri si aniru ukrɨ ukywi. ");
INSERT INTO ninNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nggo anishirr ba a ri kre ma yo i Yesu à du abiga ma ba ku rri nu uddu ku na bu kuchi kuma nu ugugarr inyi numa ku. Uwa a ka so na yo anishirr ba anko bari. ");
INSERT INTO ninNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nggo a du anishirr ba kuma, na hun kuma ni igbre wa na nkima ku barr. Nu nggo ingbahru i ki, i Yesu se nabo na nkima, ");
INSERT INTO ninNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","uddu ku ùka ta anko ni inyi wa ba, unddunddu gru so go, ni turr uddu ku kakuma nu ugo, ankinkirr ka gru ni so nggurr nu uddu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nggo ambre ka à nise nggarr kre, i Yesu a rri na ba, na ko zirr na atu ka amasirr ka. ");
INSERT INTO ninNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nggo abiga ma ba a hi ma ni so zirr na amasirr wa, isisu ki ba. Aba da di, “À si uzhi!” Na nggarr angu yi hantu ku isisu. ");
INSERT INTO ninNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","I Yesu bwu angu re na ba keke di, “Vu isisurr! A si ingga, si kru isisu hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Biturr ddu ma di, “Atiko a ta su uwa yo jiji, uwa di ingga mi zirr na atu ka amasirr ka ni nga nu uwa ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","I Yesu yo ma di, “Nga!” I Biturr gru huzzu nu uddu ku na ko zirr na atu ka amasirr ka na ko kuma ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nggo a hi unddunddu ku tuku ankinkirr ka amasirr ka, isisu ki ma, uwa gru so ji rri na amasirr wa. Na nggarr angu yi di, “Kpa ingga ttungo, Atiko!” ");
INSERT INTO ninNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mre i Yesu na ungo na ko ma vu, na ddu ma di, “Uwa na kingginggi ni di iyo isisurr imuwa yi i si ntsɨmi. Angginggi du ùwà na isisurr imuwa yi ki iha?” ");
INSERT INTO ninNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aba aha mi a mirri nu uddu ku unddunddu ku ù kukri. ");
INSERT INTO ninNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Abiga ma ba nu umi ku uddu ku a kuttu na ddu Yesu di, “Uwa su Uvuvurr a Abachi jiji.” ");
INSERT INTO ninNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A cha inyi wa kuma nu ugugarr ku Genesareti. ");
INSERT INTO ninNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nggo anishirr ba nabo a hi di a si Yesu, na da ku anishirr ba kago korrmi na anga kama we, aba gru gri abi lolo wemi na nga na ku di a bu ni du ba wre. ");
INSERT INTO ninNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Na barr ma di a bu kpanye na du abi vri ba sa ango nu utu nkru uma uku yo mre. Abangga ba nggo a sa ungo na ku we a wre ni ivri imbarr yi we. ");
INSERT INTO ninNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mre abanu nu umi ku anu Farrisi ba na abitsarr na Are ka Musa ba, a gru nga zhi nu Urushalima ni Yesu ku na ni zhi ma di, ");
INSERT INTO ninNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Sa angginggi abiga amuwa ba a kà iwo na kpa itsarr i ábáchí yi chirr? Na si di ngla ango ambarr ka bari na ri hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","I Yesu à ddu ba di, “Angginggi di imba ka iwo ure ku Abachi ku ni so ga iba imba yi? ");
INSERT INTO ninNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Abachi da di, ‘Kye aki amuwa na ayirr muwa ssu nu ungo. Undurr wa nggo ti marr aki ka ayirr, aba bu ngu ma.’ ");
INSERT INTO ninNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Imba yo di da di, unushirr wa nggo à ddu aki ka ayirr di, ‘Ingga se ni inkindirr yi nggo ingga ka zi ùwà, uwa su nggo ingga ì ka ka yi nu Abachi mu ba.’ ");
INSERT INTO ninNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Imba i tsarr undurr uwama di a bu si nu aki ka ayirr wa inkpinkpye hen. Meme nggo imba cha ure ku Abachi ku ku iba imba yi. ");
INSERT INTO ninNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Imba abi na aseki ba na abi, wre ku anishirr bu kye imba! Ishaya uni kpa are wa à da ure ujiji na atu amba wa di. ");
INSERT INTO ninNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Anishirr angga ba wemi a so di gbyarr ki ingga asa ba na angu gigyemi, isisurr imbarr yi i ta anko ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iga imbarr yi ì si iruku, nu nggo imba so tsarr are ka nggo anishirr ngga a na ka, aka a kaki are!’” ");
INSERT INTO ninNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","I Yesu yo akpukpa anishirr wa chi ki ywhiywhirr na ddu ba di, “Imba wo ni ssu hi yi! ");
INSERT INTO ninNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","A si si inkindirr yi nggo mirri ku unushirr na angu inggi i di na unushirr ki umimi hen, a si inkindirr yi nggo i di huzzu ku unushirr na angu inggi di na ma ki ndanda.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Abiga ma ba gru nga ni da ku di, “Uwa hi di anu Farrisi ba so vri isisurr ni itsarr muwa inggi yi?” ");
INSERT INTO ninNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu à ka sa ba di, “Unkunkurr ku nggo à ta si si aki mungga wa nu unkplassu nggo à ttu ku hen, aba ta kpo ku ta yo. ");
INSERT INTO ninNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kpamusu na ba yi! A si abitsarr anko aba kreshi. Unakreshishi ti tsarr unakreshishi anko aba aha mi a ta kuhre nu udduddu.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","I Biturr à da di, “Ure kuma shi ki inta ibwu. Da ki inta inkpi i assurre ama wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu à zhi ba di, “Imba nise kye hi? ");
INSERT INTO ninNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Imba hi di, inkindirr yi nggo unushirr ta ri yi ko nu umi ine a di ja yi hre? ");
INSERT INTO ninNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Inkindirr yi nggo ti huzzu na angu ka unushirr i di zhi si ni isisurr. Ima yo di na ma ki undanda. ");
INSERT INTO ninNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aseki ka nggo di ssuzzu zhi ni isisurr i unushirr aka yo a si amarr ndanda, ingu unushirr, izha amba ni izha aniru, ni na aseki ndanda anuma ka. Iki ayi, ni iki imu, ni ki amparr. ");
INSERT INTO ninNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Abangga ba yo si aseki ka nggo di na unushirr ki ndanda. Uwa a ti su ure ki iri sa ni ingla angu nâ ta si nggo a da, ima si di na unushirr ki umimi hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","I Yesu du unto ukuma na gru kuma na anga ka nggo su ywhiywhirr ni igbu nu Taya tuku Sido. ");
INSERT INTO ninNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ayamba nu Kenanu numa, nggo so na anga akama à gru nga na ku, ni so yi na barr ma hantu di, “Atiko, Uvuvurr a Doda, kye ingga na ashishi ka itito! Uva mu nggo à ku anazhi, aba so ki ma iha kakami.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","I Yesu si da inkindirr hen. Abiga ma ba nga ni barr ma di, “Du ayamba wa kuma! Kye wa so ga inta na so yi han inta atu!” ");
INSERT INTO ninNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","I Yesu à ka sa ku di, “A tu ingga na aminta abi nado bu Israila ba yo ba mre.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mre ayamba wa nga ni kuttu ku na aza di, “Atiko, zi ingga!” ");
INSERT INTO ninNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","I Yesu sa ku di, “I si ta wre aba bu ba ila i amumarr yi nu amiyo hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ayamba wa kpanye ku di, “Ì si meme yo, Atiko. Amiyo ba mi di ri imbimbru yi nggo di kuhre zhi na ango ka akiko ambarr wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","I Yesu da ku di, “Uwa sa ayamba a iyo isisurr kakami! A ta na ku uwa inkindirr yi nggo uwa so zha yi nggo.” Keke uva ma wa à wre. ");
INSERT INTO ninNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nggo Yesu gru share na anga akama na ji kuma nu unddu inyi ku Galili ku, na hun ku ji so ni igbre numa. ");
INSERT INTO ninNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Akpukpa anishirr a gri abi kɨ ga anga ayirr, na aba kreshi, na abi nga na ango, na aba agbatu, na abi vri na nkanka ni zu ku Yesu na ashishi, uwa du ba wemi a wre. ");
INSERT INTO ninNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nggo anishirr ba hi inkindirr ima yi na ku ayisurr nggo aba agbatu a so re, abi nga na ango a wre, abi kɨ na aza a gru zirr, aba kreshi a kye hi. Anishirr ba wemi gru so gbyarr ku Abachi a Israila wa asa. ");
INSERT INTO ninNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu yo abiga ma ba chi kuma na ku ddu ba di, “Anishirr angga ba a lo ingga isisurr, utarr ambarr nggo ari a so di ga ingga sama ni iri inkindirr. I si ta wre ingga du ba kuma sama ni iho ba hen, wre ku abanu bu si zzu ma lankarr na anko hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Abiga ma ba a zhi ma di, “Inta ta hi inkindirr i iri nu momonggo ni nu anishirr angga ba we na ankpuji anggo wa?” ");
INSERT INTO ninNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","I Yesu zhi ba di, “Imba se na ankpinkpri unfonfo abirr ngga?” Aba ddu ma di, “Unfonfo utangba ni imwi ikikla ntsɨ.” ");
INSERT INTO ninNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I Yesu à ddu anishirr ba di a bu kuso ni imimi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Na vu unfonfo utangba wa ni ikikla yi, na nyarr ku Abachi, na mɨ ba ki ankpunkpu, na ka nu abiga ma ba. Aba kpa ga ku anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Anishirr ba wemi a ri na shi. Abiga ba a vu ankpunkpu ka nggo a ji ssu ni isisa itangba. ");
INSERT INTO ninNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anishirr ba nggo a se ni iri ima a si aniru ukrɨ une̱, aba si bre amba na amumarr kye hen. ");
INSERT INTO ninNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","I Yesu à du anishirr ba a ga kuma, na gru rri nu uddu ku, na cha kuma na anga ka Magada. ");
INSERT INTO ninNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Anu Farrisi banu na anu Sadusi a nga, da aba ta ni tsarr Yesu kye, na ni zhi ma di a bu na ba inkindirr numa i ikagri zhi nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Nggo i Yesu à ddu ba di, “Nggo ingbahru ti ki, unkplassu ku di kaki ususarr, imba di da di, ‘Inta ta hi unddunddu ki iwre.’ ");
INSERT INTO ninNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nggo ambre ka ti nggarr imba hi akpa ka nggo a gre na shirr imba di da di, ‘Ahru ta ku ari.’ Imba ti kye unkplassu ku, imba di da inkindirr ni itu i ikasarr i abubo yi. Imba sama ni inkindirr i ida ni itu i aseki ka nggo a so la ni ivi inggi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Imba amimi anishirr, imba zha inkindirr i ikagri nggo ta tsarr imba nggo, ni si ta kpanye hen! Inkindirr i ikagri inggi i si iyirr yo nggo ingga ta ni imba. Inggi i si inkindirr yi nggo ana ni ivi i Yunana yi.” Nggo à da ba meme kre na gru share. ");
INSERT INTO ninNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Abiga Yesu ba acha kuma nu gugarr ku nyi numa ku na kpamusu ni gri inkindirr i iri, nggo a cha kuma nu ugugarr ku inyi unuma ku. ");
INSERT INTO ninNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nggo a cha, i Yesu ddu ba di, “Imba vu ukpa gri ni so gbye ni itu i iyisti i anu Farrisi na anu Sadusi ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aba gru so re ni ikpa imbarr di, “A da meme nggo inta si gri unfonfo hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","I Yesu à kye amarr ambarr ka hi, na ku zhi ba di, “Imba anishirr abi yo isisurr ntsɨmi, sa angginggi du imba i so re meme ni ikpa di imba sama nu unfonfo? ");
INSERT INTO ninNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Imba nise kye hi? Imba si di ssu hi ankpinkpri unfonfo akywi ka nggo anishirr ukrɨ ukywi ba a ri na shi hen? Imba vu inkpinkpo ikadu yi ssu ni isisa ibirr nggi? ");
INSERT INTO ninNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ka ankpinkpri atangba ka nggo anishirr ukrɨ une̱ ba a ri shi na kadu, imba vu inkpinkpo yi ssu ni isisa ibirr nggi? ");
INSERT INTO ninNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Angginggi ttu ki imba isisurr yi du imba si hi di ingga si so re ni itu i unfonfo mu hen? Imba vu ukpa gri ni so gbye ni itu i iyisti i anu Farrisi na anu Sadusi wa!” ");
INSERT INTO ninNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Mre abiga ma ba a hi di a si so gba ba utu di a bu kye atu ambarr na imbimbru iyisti wa nggo a di na undu na wa ni na unfonfo mu hen, a ko re ba si ni itu i itsarr i anu Farrisi na anu Sadusi yi mu. ");
INSERT INTO ninNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu kuma na anga numa wa nggo su ywhiywhirr nu Kayisarriya Filipiya, na ku zhi abiga ma ba di, “Anishirr ba a da di Uvuvurr a Unushirr à su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Aba da di, “Abanu a da di Yohana uni zzu na amasirr, a abanu di Iliya, abanu di Irrimiya, ka uyirr nu umi ku abi kpa are ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","I Yesu zhi ba di, “Imba na? Imba da di ingga su unggo?” ");
INSERT INTO ninNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","I Sima Biturr da di, “Uwa yo su Kristi wa, Uvuvurr a Abachi uni so sese wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","I Yesu da ku di, “Abachi à yo angu azizi ku ùwà, Sima uvuvurr a Yohana. Ure unggo ku u si nga nu ùwà ku zhi na amarr ka unushirr hen. Aki amungga nu unkplassu uwa yo à turr ku nga ku ùwà. ");
INSERT INTO ninNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Meme nggo ingga ko da ku ùwà, ùwà si ingbinta, Biturr. Ni itu i ingbinta inggi iyo ingga ta me uki ku nggurr bi umungga ku nggo ittu mi si taka tsi ku nggarr hen. ");
INSERT INTO ninNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ingga ta nu ùwà inkpe̱ ibwu anko a i ittu i unkplassu yi. Inkindirr yi nggo imba ti ka yi ttu ni imimi aba ta ka yi ttu nu unkplassu, i inkindirr yi nggo imba ti bwu yi ni imimi aba ta bwu yi nu unkplassu.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Na gba ku abiga ma ba utu kakami di a bu si da ku undurr di uwa yo su Kristi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Bazhi na azhibarr ama wa, Yesu à gru di da huzzu ku abiga ma ba di, “Ingga ta kuma nu Urushalima. Abi gri anishirr ba, na ankpinkpye abikye ba na abitsarr Are ka Musa ba, a ta ku ki ingga iha. Na ta ngu ingga, u nu utarr wa ingga ta tasi.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","I Biturr yo ma ka ki na anga ayirr na glo ma di, “Abachi bu ka yi ka ku uwama, Atiko! Du yi si si meme nu ùwà ku hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","I Yesu kakye na ddu Biturr di, “Chi share ki ingga ni inggya ùwà Isheta. Ùwà si ki ingga utakpu ku karr uza, nggo amarr amuwa angga ka a si nga zhi na Abachi ku hen, a zhi nu unushirr ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","I Yesu da ku abiga ma ba di, “Undurr wa nggo à ti du uwa à ta ga ingga, uwa bu ka itu ima, na ba unkunkurr ku kpa unushirr umaku na ga ingga. ");
INSERT INTO ninNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Undurr wa nggo ti zha du uwa ta kpa itu ima ttungo, uwa si ta so sese hen, undurr wa nggo à ti ba itu ima à ni ku ingga, uwa à ta kpa iso sese. ");
INSERT INTO ninNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Unushirr à ta kpa angginggi nggo à ti vu aseki ka ingbingbru ka angga ka we na ssu izhi iso tsitsirr ima yi? Uwa ta han sa angginggi na bu gri itu ima yi kanga? ");
INSERT INTO ninNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kye, ingga Uvuvurr a Unushirr i ki ywhiywhirr i nga ni inkpinkpye i Aki ama yi, na abitu ama ba, ni ta ni nu anishirr we azadi ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ingga ko da ki imba jiji mu di abanu nggo kri ni inggya a taka hi Uvuvurr a Unushirr ni nga ni ittu ima yi bari na ka kɨ.” ");
INSERT INTO ninNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nu ugo ku ivi itani, i Yesu à yo anu Biturr tuku Yakubu u Yohana, uzayirr a Yakubu wa, na gri ba na hun kuma ni igbre unkpi numa, na kuso na akpa ambarr. ");
INSERT INTO ninNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nggo a so, na gru hi ukpa ku Yesu ku u kasarr. Ashishi ama ka a gru so la zzu azhi. Ankru ama ka a gru kaki akikla pyarr. ");
INSERT INTO ninNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Abiga ma atarr ba a so mre na kakye anu Musa tuku Iliya a kri so re na ku. ");
INSERT INTO ninNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Biturr à gru bwu angu re ni Yesu ku di, “Atiko, ì wre kakami nggo inta se ni inggya. Uwa ti kpanye, ingga ta tarr aburr atarr, iyirr muwa, iyirr ku Musa, iyirr ku Iliya.” ");
INSERT INTO ninNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nggo Biturr nise re kre, akpa ka la inge̱ na ji ni ttu ba. Aba wo ukorr nu umi ku akpa ka u da di, “Uwanggo yo su Uzumu wa, nggo Ingga inyarr ma ni isisurr kakami. Imba wo ma yi!” ");
INSERT INTO ninNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nggo abiga ma ba a wo ukorr ku, isisu ki ba kakami aba kuhre na ka ashishi ambarr ka ttu ni imimi. ");
INSERT INTO ninNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","I Yesu zirr nga ni sa ungo na ba di, “Gru yi! Imba si kru isisu hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aba gru na si hi undurr zizo hen, uwa si Yesu yo kri na ankpa ma. ");
INSERT INTO ninNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nggo a so ji ni igbre wa, i Yesu à gba ba utu di, “Imba si da ku undurr inkindirr yi nggo imba hi yi hen, du ingga Uvuvurr a Unushirr ka tasi bari.” ");
INSERT INTO ninNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Abiga ma ba a zhi ma di, “Angginggi du abitsarr na Are ka Musa ba a di da di Iliya nggo ta nga kuchi ku Kristi?” ");
INSERT INTO ninNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu à ddu ba di, “A da su ure ujiji di Iliya yo à ta nga kuchi na taka ni na aseki ka we ssubi. ");
INSERT INTO ninNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Di ingga da ki imba yi, Iliya a ka nga ba, anishirr si hi ma hen, na ni na ku inkindirr yi nggo isisurr imbarr yi i da ba. Na ta ni ki ingga Uvuvurr a Unushirr iha meme yo na ango ambarr ka.” ");
INSERT INTO ninNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Abiga ma ba a hi di a so re si ni itu i Yohana uni zzu na amasirr wa yo. ");
INSERT INTO ninNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nggo Yesu na abiga ma atarr ba a kaji nga na anishirr ba ba, ugo numa à nga ni kuttu ku na aza, ");
INSERT INTO ninNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na da di, “Atiko, ki itito nu uzumu wa ku. À di tsɨ ankparr na ki iha kakami. Ankpu numa uwa di jaku nu uru, ankpu numa na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ingga gri ma ni nga na abiga amuwa ba ba, aba si du ma wre hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","I Yesu à ddu ba di, “Imba anishirr abi kà iwo na abi sama ni ikpanye! Imba zha di ingga bu so ni imba ba kuma nita nggo bari? Imba zha di ingga bu na imba kingginggi yi? Gri ki ingga uvuvurr wa!” ");
INSERT INTO ninNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nggo a gri uvuvurr wa na nga na ku, uwa nggarr ito ni izhi yi ku, i huzzu kuma ni du uvuvurr wa, uvuvurr wa à wre keke nu unto ku. ");
INSERT INTO ninNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Abiga ba anga ni Yesu ku na ni zhi ma nayi di, “Angginggi du inta han izhi yi huzzu lankarr?” ");
INSERT INTO ninNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","I Yesu ddu ba di, “Su nggo iyo isisurr imba yi i si ntsɨmi. Di ingga da ki imba ure ujiji, iyo isisurr imba yi i ti si ivintsɨ nâ ta si ingbingbi i unkunkurr yi nggo a yo ku du mosita, imba ti ddu igbre wanggo di, ‘Gru chi ka ni inggya kuma ni inkla inggi yi.’ Uwa à ta gru chi kuma. Inkindirr numa i si ta tsɨ ki imba hen.  ");
INSERT INTO ninNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Anazhi angga ba si di huzzu sama ni ibarr tuku ivu angu kye hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nggo abiga ma ba a ku nggurr bi nu Galili i Yesu da ba di, “A ki ywhiywhirr i vu Uvuvurr a Unushirr ni na ango ka anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Aba ta ngu ma; uwa taka tasi nu utarr wa.” Isisurr i abiga ma yi i kaki ndanda. ");
INSERT INTO ninNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nggo a nga nu Kapanahu, abanu abi kpa inklo i Uki ku Ibarr ba a nga ni zhi Biturr di, “Unitsarr amba wa a di han inklo i Uki ku Ibarr yi?” ");
INSERT INTO ninNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Biturr kpanye ba di, “A si meme yo, a di han yi.” Nggo Biturr à mirri ni iko yi na nise da inkindirr, Yesu kuchi zhi ma di, “Amarr amuwa ka a da kingginggi Sima? Atuttu abi imimi ba a di kpa inklo i imimi yi nu unggonggo ku? Abi igbu ba, ka si na aba bì ba?” ");
INSERT INTO ninNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","I Biturr da ku da a ku di kpa yi na abi igbu ba ba. I Yesu da di, “Meme nggo, anishirr abi igbu ba a si di han inklo yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Si di inta kpala ba hen. Kuma ni inyi wa ku yo akwarr. Ikikla ni ime̱me̱ wa nggo ùwà ti vu, ùwà bwu angu ama ka kye, ùwà ta hi inkpinkpri inklo, ùwà ttu yi han inklo imungga ni imuwa.” ");
INSERT INTO ninNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na attuttu ama wa abiga bu Yesu ba a nggurr bi na nga na ku, ni zhi ma di, “Unggonggo si ankpye wa ni Ittu i unkplassu yi?” ");
INSERT INTO ninNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","I Yesu kasarr na yo inkparr uvuvurr numa gri nga ni ichi imbarr. ");
INSERT INTO ninNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Na da di: “Ingga da ki imba, imba ta si kasarr ni kaki nâ ta si amumarr atsitsa hen, imba si ta rri ni Ittu i unkplassu yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Undurr wanggo ti ka itu ima yi ta yo ni imimi na kaki nâ ta si uvuvurr wanggo wa, uwa yo si ankpye ni Ittu i unkplassu yi. ");
INSERT INTO ninNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Undurr wa nggo ti kpa uyirr ma mi ni isa imungga, uwa a kpa si ingga yo. ");
INSERT INTO ninNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Undurr wa nggo ti du uyirr nu umi ku amu atsitsa angga ba nggo kpanye ni ingga ku a la ure, ì ta wre aba bu klo ku undurr uwama ununa ni ito na ba ma tuyo ni inyi du ma gu. ");
INSERT INTO ninNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Uje ku anishirr abi ingbingbru ba, nu nggo aseki shishemi a se nggo ta du ba a la ure. Aseki akama a ta la. U uje ku undurr wa nggo du yi i la. ");
INSERT INTO ninNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“A ta su ungo, ka uza umuwa nggo u ta du ùwà jaku ni iga yi, ùwà gye ku ta yo. Uje ku abangga ba nggo a ta du anishirr ba la ure. I ta wre ùwà bu rri ni iso sese yi sama nu ungo ka uza, nu nggo a ta ba ùwà tu yo nu uru ku rri sese, ùwà se na ango na aza aha. ");
INSERT INTO ninNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ata si ishishi nggi ti du uwa jaku ni iga yi, uwa ttu yi ta yo glo, i ta wre uwa bu rri ni iso sese yi ni ishishi iyirr nu nggo a bu tu ùwà yo nu uru ku asese na ashishi aha. ");
INSERT INTO ninNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Imba bu si kpa atsitsa angga ba chirr hen. Ingga da ki imba, a se na abitu ambarr nu unkplassu a di kri ikri inggi na age̱ ka Aki amunta wa nu unkplassu.  ");
INSERT INTO ninNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ingga Uvuvurr a Unushirr i nga ikpa abi nado ba yo ttungo. ");
INSERT INTO ninNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Imba kye kingginggi, unushirr wa nggo à se na aminta ayirr yirr, uyirr nu umi umbarr ku à ti nado na? Uwa à si ta kà aminta iso itirr na atirr ba (99) du ni igbre wa, na kuma ku zha uyirr wanggo hen. ");
INSERT INTO ninNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Uwa à ti zha ma hi, ingga ko da ki imba, unushirr uwama à ta se ni inyarr kakami ni itu i ivinta uyirr uwama mri iso itirr na atirr ba (99) nggo si nado ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na anko ayiyirr ama yo, Aki amungga wa nu unkplassu mi à si di kpanye di uyirr nu umi ku atsitsa angga ba a bu nado hen. ");
INSERT INTO ninNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nggo uzumbirr ti kpala ku ùwà, kuma ku da ku ila ima yi, imba aha yo. À ti wo ùwà na kpanye ni ila ure ima yi, ùwà gri ma kanga na anko. ");
INSERT INTO ninNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nggo à ti kà iwo ùwà, ùwà bu yo unushirr uyirr ka aha du ba ga ùwà. ‘Inkindirr yi nggo anishirr aha ka atarr a ti hi yi i si meme yo jiji,’ nâ ta si nggo ungbamvu ku Abachi u da. ");
INSERT INTO ninNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Uwa ti si wo imba hen, ùwà bu gri ure ku ni kuma nu uki ku nggurr bi ku Abachi ku, uwa à ti kisa na aba Abachi ba ba zizo, ùwà kye ma ki unushirr wanggo nggo à si si uniga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ingga ko da ki imba ure ujiji, inkindirr yi nggo imba ti kà yi ni ingbingbru inggi yi aba a ta kà yi nu unkplassu. Inkindirr yi nggo imba ti kpanye na yi ni ingbingbru inggi yi aba a ta kpanye na yi nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ingga ko da ki imba zizo, unto ku nggo imba aha ni ingbingbru yi ti kpanye ni inkindirr iyirr nggo barr ni itu ima yi, Aki amungga wa nu unkplassu à ta na ki imba na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Unto ku nggo anishirr aha ka atarr a ti nggurr bi ni isa imungga, ingga se na ba nabo.” ");
INSERT INTO ninNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Biturr kuma ku zhi Yesu di, “Atiko, u uzumburr à ti so kpala ki ingga, ingga bu nggurr zhi ku ki inkpo ibirr nggi? Ankpu itangba?” ");
INSERT INTO ninNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu ddu ma di, “Iya! A si si inkpo itangba hen. A si ankpu iso tangba ki ankpu tangba. ");
INSERT INTO ninNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Meme nggo, ure unggo ku utsarr di Ittu i unkplassu inggi si ma mi: “Azhibarr numa nggo uttu numa gru yo amirr iko ama ba, na da ba di a bu tsarr ma aseki ka nggo uwa a ga ba na ka. ");
INSERT INTO ninNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","A so na meme nggo, aba a gri uyirr nu umi umbarr ku na rri kuma na ku, di a ri ba inklo shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Uvuvurr iko wa sama ni inklo yi nggo ka ma ihan uhla ukuma. Uttu wa à da di a bu ba ma ku re ki ugarr, kye na ayamba ama wa na amumarr ba ni inkindirr yi nggo a se na yi, wre ba bu han uhla ku. ");
INSERT INTO ninNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Uvuvurr iko wa à ji jaku na agbuzzu na age̱ ka uttu ka, na barr di, ‘Ingga ko barr uwa, vu isisurr ni ingga ku. Ingga ta han ku ùwà na yi we!’ ");
INSERT INTO ninNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Uttu wa ki itito na ku, na kà uhla ku du ku na du ma kuma. ");
INSERT INTO ninNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Nggo uvuvurr iko wa huzzu na kuma nu uvuvurr iko unuma nggo a so ga ma inklo ntsɨ. Na ku ma ma vu ni ito di, ‘Han ingga inklo yi nggo ingga so ga uwa nggo!’ ");
INSERT INTO ninNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Uvuvurr iko wa à jaku ni imimi na barr ma di, ‘Vu isisurr ni ingga ku, ingga ta han uwa na yi we!’ ");
INSERT INTO ninNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Uwa ka na kisa, na ba ma ku nu ba a ttu nu uki di a ti han uwa inklo yi bari. ");
INSERT INTO ninNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nggo inkpu amirr iko yi a kye inkindirr ima yi i vri ba isisurr kakami, na kakuma ku da ku uttu wa aseki ka wemi nggo a la. ");
INSERT INTO ninNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Uttu wa à tu ba a yo uvurr iko wa, na ddu ma di, ‘Ùwà ugarr undanda! Nggo uwa barr ingga, ingga nggurr uhla umuwa ku izhi ku uwa we. ");
INSERT INTO ninNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Uwa mi ka nggurr zhi ku ukpami uvuvurr iko wa meme, nâ ta si nggo ingga nggurr zhi ku uwa.’ ");
INSERT INTO ninNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Uttu wa vri isisurr na ku kakami, na du ba gri ma ku harr, na ki ma iha du ma han uhla ku we bari.” ");
INSERT INTO ninNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","I Yesu kre assurre wa na da di, “Aki mungga nu unkplassu ta na ki imba meme yo, nggo imba si di nggurr zhi ku amuyirr amba ba zhi ni isisurr hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nggo Yesu kre ibre are angga ka na gru nu Galili kuma nu ugugarr ku Inyi nu Joda wa na anga ka Yahudiya ka. ");
INSERT INTO ninNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Akpukpa anishirr shishemi a ga ma, uwa ku du ba wre nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Anu Farrisi abanu a nga ni zha anko di aba a ta tirr ma kye, na ku zhi ma di, “Are amunta ka kpanye di unuru a bu han ayamba ama ni ikpala yi nggo isisurr ima i da ku?” ");
INSERT INTO ninNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","I Yesu ddu ba di, “Imba nise bre nu ungbamvu ku nggo u da di, ni ime̱me̱ yi Abachi à na ba unuru tuku ayamba? ");
INSERT INTO ninNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Abachi à da di, ‘Ni ima yo, unuru à ta kà aki tuku ayirr du na nggurr itu bi nu uwama ku, aba aha mi a ta kaki nâ ta si ukpa uyirr.’ ");
INSERT INTO ninNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bazhi ziza aba a si ta si aha zizo hen, a ta su uyirr yo mre. Inkindirr yi nggo Abachi zɨ yi bi, unushirr bu si ga yi ki na nkanka hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Anu Farrisi ba zhi ma di, “Anggi mu du Musa à da du unuru à ti ta han uwama, uwa bu nu ma ungbamvu ku ingu igarr na han ma share?” ");
INSERT INTO ninNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","I Yesu à ddu ba di, “Musa à kpanye ki imba ni ingu igarr ku ikà iwo imba. Uwa a si si meme yo ni ime̱me̱ yi nggo Abachi à na ingbingbru yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ingga da ki imba, undurr wa nggo ti han uwama nu ure numa, nggo si si ure ku iga aniru hen, na ku garr unuma, uwa mi à la ure ku izha amba.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Abiga ma ba a da di, “I ka si meme yo ku unuru tuku ayamba, anishirr ka di so mu sa ni igarr i ka wre sha.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I Yesu da di, “A si si anishirr we mu ka kpanye ni itsarr inggi yi hen. Itsarr inggi yi i si i anishirr ba nggo Abachi à hla ba na nu ba na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Aseki a se shishemi nggo ka si du aniru garr hen. Abanu a ngri ba meme yo, abanu anishirr mu na ba ki meme. Abanu kà igarr yi ni itu i Ittu i unkplassu yi. Undurr wa nggo ti kye i wre ku uwa a bu kpa itsarr inggi yi uwa bu kpa yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Anishirr banu a gri amumarr atsitsa nga ni Yesu ku di a bu ni sa ba ungo ni itu na bu barr Abachi ku amumarr ba. Abiga ma ba a han anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","I Yesu ddu ba di, “Imba du amumarr ba du ba nga ni ingga ku ni si han ba yi hen, kye Ittu i unkplassu yi i si i anishirr ba nggo se nâ ta sa amumarr.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Na sa ku amumarr ba ungo na atu na share nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mre ugo numa gru ko ku zhi Yesu di, “Unitsarr uzizi, inkindirr i ta inggi i si iwre kakami nggo ingga ta na yi ni kpa iso sese?” ");
INSERT INTO ninNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","I Yesu zhi ma di, “Angginggi du uwa zhi ingga inkindirr iwre? Abachi yo na nkpama si uzizi. Nggo ùwà ti zha du uwa ta so sese, uwa kru isisu i are ka Abachi ka.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ugo wa zhi Yesu di, “Are ka ta ka ngga?” Yesu bre ku di, “Si ngu unushirr hen. Si zha amba hen. Si ki ayi hen. Si kri ku unu nu ugo gigyemi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kru isisu i aki amuwa tuku ayirr amuwa, ni kpanye nu uni girr amuwa ku nâ ta si nggo ùwà kpanye ni itu muwa.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ugo wa da ku di, “Ingga di kru isisu ankpi are akama we. Angginggi ingga ka na zizo?” ");
INSERT INTO ninNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","I Yesu ddu ma di, “Uwa ti zha du uwa ta so sama ni ila ure, uwa bu ku vu aseki amuwa ka re, ni ka inklo yi ga ku abi iha. Uwa ta se na aseki nu unkplassu, ni nga ni ga ngga.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nggo uvuvurr nze wa à wo meme, na ka share gbo mi, nu nggo à se na aseki kakami. ");
INSERT INTO ninNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","I Yesu kasarr na ddu abiga ma ba di, “Ingga da ki imba, irri ni ttu i kplassu yi taka tsɨ kakami ku uwanggo nggo à se na aseki ka ingbingbru ka shishemi nggo. ");
INSERT INTO ninNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ingga da ki imba zizo, i taka tsɨ ku unaseki shishemi uwa bu rri ni Ittu i Abachi yi, mri nggo alakurrmi a bu rri ni iywirr i anurr.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nggo abiga ma ba a wo meme na ku ayisurr kakami. Na zhi ma di, “Ati si meme, unggonggo ta firr huzzu?” ");
INSERT INTO ninNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","I Yesu kye ba girr na da di, “A si inkindirr i itsɨ ku unushirr, u na Abachi ku inkindirr i tsɨ mri i sama.” ");
INSERT INTO ninNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","I Biturr a gru re ni Yesu ku di, “Kye, inta nggo i kà aseki amunta ka du ni ga ùwà. Inta ta kpa sa angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu à ddu ba di, “Imba bu hi jiji mu di na ase ka nggo Abachi à taka ka ingbingbru yi ki ihe̱he̱, ingga Uvuvurr a Unushirr taka so ni imburr ima inkpi yi, imba abi ga ingga awurr na aha ba (12) taka hun so ni imburr i atuttu awurr na aha, ni taka gri iga iwurr ni iha i Israila yi. ");
INSERT INTO ninNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Undurr wa nggo à ka ako du, na amuyirr aniru na amba, na aki na ayirr, na amumarr, ni izzuzzu, ni itu imungga à taka kpa iki inggi yi shishemi na ta kpa izhi i iso sese. ");
INSERT INTO ninNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Abanu shishemi nggo sa abi ime̱me̱ a taka kaki abu ugo, abanu shishemi nggo si abu ugo a taka kaki abi ime̱me̱.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu kuchi ni da ba di, “Ittu i Unkplassu inggi i si ma mi: Na azhibarr numa ugo uni do unuma à han huzzu ni igambre, ku zha anishirr abu undu nggo ta ni na ku undu ni ila. ");
INSERT INTO ninNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na kpanye du uwa ta han ba azadi ambarr ka undu ka, dinarri iyirr na azhi, na turr ba kuma ni ila yi. ");
INSERT INTO ninNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Na gru kuma nu udu ni ikarrfe itirr i ambre na ku hi abanu kri gigyemi. ");
INSERT INTO ninNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Uwa ddu ba di, ‘Imba mi ga ba kuma ni ila yi, ingga i ta han imba inkindirr yi nggo iwre.’ ");
INSERT INTO ninNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Aba mi ga ba kuma ni ila yi. “Uwa huzzu kuma zizo na azhi na atsutsu tuku nggo azhi wa kasarr ba na ku na meme yo zizo. ");
INSERT INTO ninNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nggo azhi wa ko ji zha ikarrfe ikywi i ingbahru uwa ko nu udu ku, na ku hi anishirr ba a vu abubo wa kri nu unto ku. Na zhi ba di, ‘Imba kri ngu azhi wa yo gigyemi na angginggi?’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Aba da di, “ ‘Undurr si ba inta nu undu hen.’ “Uwa à ddu ba di, ‘Imba ga abanu ba ku na ki ingga undu ni ila yi.’ ");
INSERT INTO ninNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ni ingbahru, akikye ni ila wa da ku uni kye abu undu wa di, ‘Yo abu undu ba ni han ba inklo imbarr yi. Han zhi na abi ikikre ba ba ku kre na abi ime̱me̱ ba.’ ");
INSERT INTO ninNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Abangga ba nggo a vu ba ni ikywi ingbahru yi a kpa dinarri iyiyirr. ");
INSERT INTO ninNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Abangga ba nggo a vu ba kuchi, a kye da a ta han ba mri, uwa han ba dinarri iyiyirr yo. ");
INSERT INTO ninNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Aba kpa inklo imbarr yi na ta inttorr nu uni vu ba nu undu wa ku. ");
INSERT INTO ninNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","A da di, ‘Anishirr angga ba nggo a vu ba ni ikikre yi a na undu ku ki awa ayirr yo, inta nggo i gri undu zhi na ambre mu ku azhi, uwa han ba narrnarr ni inta nggo ssu azhi ma ni kre!’ ");
INSERT INTO ninNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Akikye wa à ddu uyirr ambarr wa di, ‘Wo ukpamu, ingga si ka imba mri hen. Inta ki iza ni imba, imba kpanye di imba ta na undu ku azhi ayirr ni itu i dinarri iyirr. ");
INSERT INTO ninNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ziza imba kpa inklo imba ni kuma yi. Isisurr imungga nggi di ingga bu nu abi ikikre angga ba inkindirr yi nggo iwre ingga bu nu ba narrnarr ni imba. ");
INSERT INTO ninNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Imba kye ingga sa nu ukyekye ku na undu ni inklo imungga yi nâ ta si nggo isisurr imungga i da ki ingga? Ka imba ki ishishi mu, nu nggo ingga i na wre ku abanu nggo?’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ni ikikre yi i Yesu à da di, “Ì si meme yo. Abi ikikre ba ta kaki abi ime̱me̱, abi ime̱me̱ ba ta kaki abi ikikre.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nggo Yesu gru ko kuma nu Urushalima, na yo abiga ma awurr na aha ba (12) kaki na anga ayirr na re na ba sharri, nggo a so kuma di, ");
INSERT INTO ninNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wo yi, inta ko kuma nu Urushalima, nggo a ta ku ba Uvuvurr a Unushirr nu ankpinkpye abikye ba, na abitsarr na Are ba. Aba ta vu ma di à la ure ku nggo u ma a bu ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Na ta ba ma nu anishirr ba nggo a si si anu Israila hen, aba ta sarr na me̱ ma, na hlo ma, na ta kpa ma ngu nu unkunkurr. Nu ugo ku ivi itarr uwa ta tasi.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ayamba a Zabadi wa à gru nga ni Yesu ku na amarr ma aha, ni kuttu ku na aza na barr ma di a bu zi uwa. ");
INSERT INTO ninNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesu zhi ba di, “Imba zha di ingga bu na ki imba angginggi?” Ayamba wa da di, “Kpanye ki ingga du uwa taka du amumarr amungga angga ba aha mi a so ku uwa uyirr wa nu ungo ri, uyirr wa nu ungo mla ni ittu imuwa yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","I Yesu ddu ba di, “Imba mi si hi inkindirr yi nggo imba so zha yi hen. Imba ka so nu umplango ku iha ku nggo ingga ta ko ki ywhiywhirr iso?” Amumarr ba kpanye di, “Inta ka so.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu ddu ba di, “Imba ta so nu umplango mungga ku jiji. Ingga sama nu ukyekye ku hla abangga ba nggo a taka so ki ingga nu ungo ri tuku nu ungo mla. Into ima i kurr ku anishirr abangga ba nggo Aki amungga à na zu ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nggo abiga ma awurr abanu ba a wo na ki unfu na amuya aha angga ba ba. ");
INSERT INTO ninNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","I Yesu yo ba nggurr bi nu unto uyirr, na ddu ba di, “Imba hi di abi gri anishirr bi ingbingbru ba a se nu ukyekye kakami na atu a anishirr ambarr ba. Ankpinkpye ambarr ba a di tsarr ba ukyekye kakami. ");
INSERT INTO ninNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","I si taka si meme yo ni imba ba hen. Uyirr nu umi umba ku nggo ti zha du uwa taka si ankpye, uwa bu na ki uvuvurr iko. ");
INSERT INTO ninNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Meme yo, uyirr nu umi umba ku nggo ti zha du uwa à taka si uni ime̱me̱, uwa bu na ki ugarr, ");
INSERT INTO ninNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","nâ ta si Uvuvurr a Unushirr wa à si nga di anishirr mu bu ni na ku undu hen, à nga nye na ku anishirr undu na bi nu ba itu ima yi, wre ku bu kpa anishirr shishemi ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nggo Yesu na abiga ma ba a ko huzzu nu Jerriko, anishirr shishemi a ga ba. ");
INSERT INTO ninNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Aba kreshi aha abanu a so nu unddu ku anko ku na wo di Yesu nggo so vu sarr, na gru ko du hantu di, “Atiko, Uvuvurr a Doda, kakye inta na ashishi ka itito!” ");
INSERT INTO ninNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Anishirr ba a nggarr ito na ba na ddu ba di a bu ba ttungo. Aba kà na du hantu mri di, “Atiko, Uvuvurr a Doda! Kakye inta na ashishi ka itito!” ");
INSERT INTO ninNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","I Yesu kukri na yo ba, na zhi ba di, “Imba zha di ingga bu na ki imba angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Aba da di, “Ankpye, di inta kye hi!” ");
INSERT INTO ninNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Itito i ki Yesu na ba, uwa sa ba ungo na ashishi ka, inkpu iyirr ashishi ka a bwu ba, aba kye hi, na ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nggo Yesu na abiga ma ba a ki ywhiywhirr nu Urushalima na nga ni igbu nu Betifegi nggo à si ni Igbre nu Olivu. Nabo i Yesu yo abiga ma aha na tu ba kuchi ");
INSERT INTO ninNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","di, “Imba kuma ni igbu wanggo nggo à si ki inta ni ichi. Ni imirri imba, imba ta hi ba lo ayirr ijaki ndo nu uvuvurr, imba ddu ba gri ki ingga. ");
INSERT INTO ninNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Undurr à ti zhi imba inkindirr imba da ku di, ‘Atiko wa à ko zha ba.’ Ankpa ayirr, uwa ta du imba gri ijaki yi ni kuma.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","A na meme wre ku ure ku uni kpa are wa u bu si ujiji di, ");
INSERT INTO ninNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Da ku anishirr bu Zayo ba, ‘Kye, uttu amba wa nggo à ko nga ni imba ba! À gri itu ima yi ki nggi na hun si ni ijaki nggi, na so nga nu uvuvurr ijaki.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Abiga ma ba ko ku na nâ ta si nggo Yesu à da ba di a bu ku na. ");
INSERT INTO ninNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A gri ijaki wa nu uvuvurr wa na nga na ku, na ddu iki isurr imbarr yi sa ku ijaki yi nu ugo, i Yesu hun so. ");
INSERT INTO ninNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Akpa anishirr shishemi a ddu iki isurr imbarr yi a la na anko wa. Abanu a wa angbamvu surr na anko. ");
INSERT INTO ninNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Anishirr abanu a ku ku Yesu ichi, abanu a so ga ma nu ugo na so du hantu di, “Hosana! Gbyarr ku Uvuvurr a Doda asa!” “Abachi à yo angu azizi ku uwanggo nggo à nga ni isa i Atiko yi inyarr!” “Hosana! Inyarr i si i Abachi nu unkplassu!” ");
INSERT INTO ninNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nggo Yesu mirri nu Urushalima, ìgbù wa namri nggurr ttu, anishirr ba gru zhi di, “Uwanggo su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Akpa anishirr wa a da ba di, “Uwanggo yo su Yesu uni kpa are wa, nggo nga zhi ni igbu nu Nazareti na anga ka Galili.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu rri kuma nu Uki Unkpi ku Ibarr Abachi ku, ku han anishirr ba we nggo a nga ni so re iki na abangga ba nggo a gri iki ire na nga nabo. Na turr imburr inkpinkpi i abi sarr inklo yi tuku imburr iso i abi re ananddu kahre. ");
INSERT INTO ninNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na ddu ba di, “A charr nu Ungbamvu ku Abachi ku di, Abachi à da di, ‘A ta di yo Iko imungga yi di iko i ibarr.’ Imba ka yi ki unto ku sharri ku abayi!” ");
INSERT INTO ninNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aba kreshi ba na abi gbo na ampi ba a nga ni Yesu ku nu Uki ku Ibarr ku, uwa du ba wre. ");
INSERT INTO ninNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ankpinkpye abikye ba na abitsarr na Are ba a ki unfu nggo a hi aseki ka ikagri ka nggo Yesu à so na, amumarr a ko du hantu nu Uki ku Ibarr ku di, “Inyarr i si i Uvuvurr a Doda!” ");
INSERT INTO ninNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Aba zhi Yesu di, “Uwa wo inkindirr yi nggo amumarr abangga ba a so da yi?” Yesu kpanye ba di, “Ingga so wo. Imba nise bre ungbamvu unggo ku kye, nggo u da di, “ ‘Ùwà yo a tsarr ankparr amumarr anko a inyarr ku Abachi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","I Yesu ka ba du na huzzu ni ìgbù wa kuma ni igbu nu Betani, na ku so ibittu yi nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Na ambre bwu nggo Yesu so kakuma nu umi ìgbù ku, iyo iki ma. ");
INSERT INTO ninNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Uwa ahi ibwa nu unddu anko ku na garr kuma ni ichi yi, na si ku hi inkpinkpo na ku hen, a si angbungba yo mre, i Yesu a ddu unkunkurr ku di, “Uwa si taka klo zizo hen!” Ibwa wa a ho keke. ");
INSERT INTO ninNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Abiga ma ba a hi na ku ayisurr di, “Sa anggi mu ibwa wa à ttu hanhan mi?” ");
INSERT INTO ninNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","I Yesu à ddu ba di, “Di ingga da ki imba, imba ti yo isisurr imba yi we ni si na amarr amba kaki aha hen, imba ta na inkindirr yi nggo ingga na ki ibwa wa. Uwa à si ta si ima yo mre hen, imba ta se nu ukyekye ku da ku igbre di, ‘Gru kuma ku jaku ni inyi,’ uwa ta gru. ");
INSERT INTO ninNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Imba ti kpanye na Abachi ku, imba ta kpa inkindirr yi nggo imba so barr zha yi na ku nggo.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nggo Yesu à mirri ku so tsarr nu Uki ku Ibarr ku, ankpinkpye abikye ba na akikre anishirr ba a nga ni zhi ma di, “Ukyekye ku ina aseki angga ka u zhi ku ùwà nu momonggo? A su unggonggo nu ùwà ukyekye ukuma?” ");
INSERT INTO ninNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","I Yesu ka sa ba di, “Di ingga zhi imba izhi iyirr inggi. Imba ti da ki ingga, ingga ta da ki imba undurr wa nggo à ni ingga ukyekye ku na aseki ka. ");
INSERT INTO ninNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yohana à kpa ukyekye ku zzu anishirr na amasirr ku zhi nu momonggo? U zhi na Abachi ku ka u zhi nu unushirr ku?” Aba gru so re ku ikpa imbarr di, “Inta ta da di angginggi? Inta ti da di, ‘A kpa ku zhi na Abachi ku,’ uwa ta zhi inta di anggi mu du inta kà ikpa ure ku Yohana ku? ");
INSERT INTO ninNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Inta ti da di à kpa ukyekye ku zhi nu unushirr ku, inta ko kru isisu i inkindirr yi nggo anishirr abanu ta na, nggo a kpanye wemi di Yohana à su uni kpa are.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Mre na ka da ku Yesu di, “Inta si hi hen.” I Yesu à ddu ba di, “Ingga mi si ta da ki imba undurr wa nggo à ni ingga ukyekye ku na aseki ka hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu zhi ba di, “Ziza, imba kye kingginggi? Ugo numa nggo na asese à se na amumarr aha. Na yo ununku wa na ddu ma di, ‘Uzumu kuma ku na ki ingga undu ni ila ari.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Uvuvurr wa ddu ma di, “Ingga si ta ko hen.” Na sha so ntsɨ na gru ka amarr ama ka sarr na kuma ni ila yi. ");
INSERT INTO ninNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Mre ugo wa à kye na ddu uzuma uvutsa wa di a bu ku na ku undu ni ila yi. Uvuvurr wa à kpanye di, ‘Yo-o, aki mungga, ingga ta kuma,’ na si kuma hen. ");
INSERT INTO ninNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Uwatanggo nu umi umbarr ku a na inkindirr yi nggo aki ambarr wa zha?” Aba da di, “Ununku wa.” Yesu à ddu ba di, “Ingga da ki imba, abi kpa inklo i imimi ba ni inddunddu a ta ba mirri ni Ittu i Abachi yi kuchi na du imba. ");
INSERT INTO ninNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohana uni zzu na amasirr wa à nga ni tsarr imba anko a iwre wa nggo imba bu ga wa, imba si kpanye na ku hen. Abi kpa inklo imimi ba ni inddunddu a wo na kpa ure umaku. Ima mi si du isisurr imba yi i kasarr ni du imba kpa ure umaku hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu kuchi ni da di, “Imba wo assurre anuma nggo zizo. Ugo numa nggo à do ila na ttu unkunkurr ku grepu ni ila yi, na harr ila yi na acha kago, na ya udduddu unkpi ku nggo a ta di hin àmà a unkunkurr wa surr, na me unto ku nggo a ta di hun kri na kye ila yi kago. Na ba yi nu abi do abanu di a bu kye ku na yi, na kuma nu uzirr ku ta anko ni igbu numa. ");
INSERT INTO ninNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nggo ivi i iywhe yi i ma, uwa tu amirr iko ama ba kuma na abi do ba ba, di a bu ku kpa ku inkpinkpo yi. ");
INSERT INTO ninNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Abi do ba a ku vu amirr iko ba, na hlo uyirr wa, na ngu unuma wa, na ta unuma wa ngu na angbinta. ");
INSERT INTO ninNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ugo wa à si di na ba hen, na sarr tu amirr iko abanu kuma na ba zizo mri abi ime̱me̱ ba, aba ku na ba meme yo. ");
INSERT INTO ninNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ni ikikre yi, uwa tu uzuma wa kuma na ba, na kye di, a ta ku kye uzuma wa ssu nu ungo. ");
INSERT INTO ninNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nggo abi do ba a hi uzuma wa, na re ni ikpa di, ‘Uwanggo yo su uzuma wa nggo aki wa taka ttu na ka ila yi du ku nggo. Imba nga di inta ni ngu ma, ni gri ila yi!’ ");
INSERT INTO ninNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aba ni vu ma, na ba ma huzzu ku tsi ngu na abi ka ila ka.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu zhi ba di, “Ziza, nggo akikye ni ila wa ti nga, uwa ta ni na abi do ba kingginggi?” ");
INSERT INTO ninNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Aba à ddu ma di, “A ta du ba ngɨ amimi anishirr abama gbigbi, na ta ba ila yi nu abanu, nggo a taka di nu ma inkindirr yi nggo su ku ima ni ivi i ihwa yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu ddu ba di, “Imba nise bre nu unto unggo ku kye nu Ungbamvu ku Abachi ku? “ ‘Ingbinta yi nggo abi me ba a kà yi di i si wre hen ima iyo di kaki itu i ibarr iko yi. A si Atiko nggo na meme, iwre ikye kakami na ashishi amunta!’ ");
INSERT INTO ninNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ingga da ki imba, a ta kpa Ittu i Abachi glo ni imba ba, na ta ka yi nu anishirr ba nggo ta na inkindirr yi nggo Abachi à zha di a bu na ku na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Undurr wa nggo ti jaku ni ingbinta nggi yi, uwa ta mɨ ki ankpunkpu. Undurr wa nggo ingbinta inggi yi ì ti ji jaku ku nu ukpa, ì ta ko ma ki imbimbru.” ");
INSERT INTO ninNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ankpinkpye abikye ba na anu Farrisi ba a ko wo assurre wa, nggo Yesu ko bre ba, na hi di à so re na atu ambarr yo, ");
INSERT INTO ninNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","na gru so zha anko wa nggo aba a ta na na vu ma. Isisu so ki ba na anishirr ba nggo a kpanye di Yesu à su uni kpa are. ");
INSERT INTO ninNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu na undu na assurre na so bre ku anishirr ba are ka zizo, ");
INSERT INTO ninNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","na da di: “Ittu i unkplassu inggi si ma mi: Uttu numa nggo à ta na iga i hru ku uzuma ayamba. ");
INSERT INTO ninNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Na à tu amirr iko ama ba du ba a ga da ku anishirr ba nggo à nu ba angbamvu ka iga ka di a bu nga ni iga yi ki, aba kà inga yi. ");
INSERT INTO ninNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Uwa tu amirr iko abanu kuma na abangga ba nggo a yo ba ni iga yi di, ‘Ari yo si iga yi, a ka han ilando inkpinkpi iga yi ba, ila yi i ka wri ba. Imba nga ni iga yi ki!’ ");
INSERT INTO ninNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Anishirr ba nggo a da ba iga yi a si kakye ba hen, na kuma ni indu imbarr mu, abanu ko ni īlá, abanu ko nu udu. ");
INSERT INTO ninNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Abanu ba a vu amirr iko ba hlo na ngɨ ba. ");
INSERT INTO ninNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Uttu wa ki unfu, na tu abi ta iku ama ba, du ba ku ngɨ anishirr abi ngɨ amirr iko ama ba na tu ako ambarr ka nu uru. ");
INSERT INTO ninNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Na kuso na yo amirr iko ama ba zizo na da ba di, ‘Iga imungga yi i ma ba, anishirr ba nggo ingga yo ba a si ma abi nga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ziza, imba ga rri nu umi igbu ku, ku ga kri na atu anko ka igbu ka ni yo anishirr tankpa nggo imba hi du ba nga ni iga yi.’ ");
INSERT INTO ninNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Amirr iko ba ga rri nu umi igbu ku, ku di yo anishirr ba nggo aba hi nggo, azizi na andanda, uki ku iga ku u tsarr ssu na anishirr. ");
INSERT INTO ninNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Uttu wa mirri ku so kye abichirr ba, na ku sa ashishi nu ugo unuma ku à si surr ankru ka gri ayamba ka na ba hen. ");
INSERT INTO ninNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Uttu wa zhi ma di, ‘Ukpamu, ùwà zhi nu momonggo ni mirri ni inggya ni si surr ankru ka igri ayamba ka na ba hen?’ Ugo wa kri ngbangbami. ");
INSERT INTO ninNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Uttu wa da ku amirr iko ama ba di, ‘Imba vu ma lo ango ka na aza, ni ba ma ku tu yo ni ibwu yi na abi. Nabo yo anishirr a ta yì, na ta anyinyirr.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","I Yesu da ni ikikre yi di, “A yo shishemi na hla ntsɨmi yo.” ");
INSERT INTO ninNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Anu Farrisi ba a huzzu ku nggurr bi na na anko wa nggo aba ta tirr Yesu, wre ku a bu da inkindirr inuma indanda aba ka vu ma. ");
INSERT INTO ninNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Na tu abiga ambarr ba na anishirr abu Hirridu abanu ba na ku di, “Unitsarr, inta hi ùwà di da su ure ujiji. Ùwà di tsarr ure ujiji ni tsarr inkindirr yi nggo Abachi à zha di anishirr a bu na. Ùwà si di kakye ure ku nggo anishirr so di da ni itu imuwa hen, nggo ùwà di na ku anishirr narrnarr. ");
INSERT INTO ninNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Da ki inta amarr amuwa ka, Are ka a kpanye di a bu han inklo imimi yi ku Kayisa (Uttu unkpi nu Roma wa) ka a kisa?” ");
INSERT INTO ninNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu à hi amarr ndanda ambarr ka, na zhi ba di, “Imba abi na aseki wre ku anishirr a bu hi! Imba so tirr ingga na angginggi? ");
INSERT INTO ninNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tsarr ingga inkpinkpri inklo yi nggo a di han inklo imimi yi na yi!” Aba gri inkpinkpri inklo dinarri iyirr ga ko. ");
INSERT INTO ninNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Uwa zhi ba di, “A charr si iyu ashishi ka unggonggo tuku isa i unggonggo ni inklo yi?” ");
INSERT INTO ninNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Aba da di, “Uttu Kayisa.” I Yesu ddu ba di, “Iwre, a bu han ku Uttu Kayisa inkindirr yi nggo i si i Uttu Kayisa, na bu nu Abachi inkindirr yi nggo i si i Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nggo a wo meme, na ku ayisurr na duma na ga share na du ma nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Na azhibarr ayiyirr ama wa, anu Sadusi abanu, nggo a si kpanye nu ure ku itasi ku hen, a nga ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","A nga ni zhi ma di, “Unitsarr, Musa à charr di unushirr wa nggo à ti garr ayamba na ttu sama ni ita uzayirr wa a bu hru ayamba na ako wa, wre ba bu ngri amumarr ni isa i uni ttu wa. ");
INSERT INTO ninNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ziza, amugo abanu a sa atangba nggo a di so ni inggya. Ununku ambarr wa à garr na ttu sama ni ita na ka ayamba wa du ku uzayirr unu uha wa. ");
INSERT INTO ninNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Uzayirr unu uha wa mi meme ni ttu na ka ayamba wa du ku unu utarr ambarr wa. A so kɨ meme yo kuma nu unu tangba wa ku. ");
INSERT INTO ninNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ni ikikre yi ayamba wa ni ttu ga ba. ");
INSERT INTO ninNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ziza, uwa bu da ki inta, nggo abi kɨ ba taka tasi, ayamba ama à taka si a uwatanggo, nggo aba atangba mi a gri wa?” ");
INSERT INTO ninNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu à ddu ba di, “Imba i ri amarr amba akama ndanda mi. A si nu nggo imba si hi ungbamvu ku Abachi ku yo hen, ni si hi ukyekye ku Abachi ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nggo Abachi à taka du abi kɨ ba taka tasi, a taka zzu nâ ta si abitu ba Abachi ba nu unkplassu. Aniru na amba a si taka garr hen. ");
INSERT INTO ninNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Imba si bre inkindirr yi nggo a da ni itu i abi tasi ba hen? Abachi à da di, ");
INSERT INTO ninNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘A si ingga yo si Abachi a Ibrayi ni si Abachi a Ishaku tuku Abachi a Yakubu.’ A si Abachi yo si Abachi a abi so tsitsirr ni si si Abachi a abi kɨ hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nggo anishirr ba a wo meme na ku ayisurr ni itsarr ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nggo anu Farrisi ba a wo di Yesu à ku ba anu Sadusi ba nggurr nu ure, na ku nggurr bi. ");
INSERT INTO ninNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Uyirr nu umi umbarr ku à si unitsarr na Are, na kuma ku tirr Yesu kye ni izhi di: ");
INSERT INTO ninNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Unitsarr, uwatanggo à si ure unkpi ku nggo u mri Are ka we?” ");
INSERT INTO ninNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","I Yesu à ddu ma di, “ ‘Kpanye na Atiko, Abachi amuwa wa ku ni isisurr imuwa yi na amarr muwa ka namri.’ ");
INSERT INTO ninNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Uwanggo yo a si ure ku me̱me̱ unkpi ku na are ka nggo se ankpinkpi sha na are ka. ");
INSERT INTO ninNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ure ku uha ku u si nâ ta si ku ime̱me̱ ku di, ‘Kpanye ni uni girr amuwa wa ku nâ ta si nggo ùwà kpanye ni itu muwa.’ ");
INSERT INTO ninNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Are ka Musa ka we tuku itsarr i abi kpa are yi, à ku yi na are aha angga ka yo.” ");
INSERT INTO ninNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nggo anu Farrisi banu a nggurr bi, i Yesu à zhi ba di, ");
INSERT INTO ninNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Angginggi si amarr amba ka ni itu i Kristi wa? A su uhanma a unggonggo?” Aba da di, “A su uhanma a Doda.” ");
INSERT INTO ninNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu ddu ba di, “Anggi mu du Doda à yo ma di ‘Atiko’? Doda, nu ukyekye ku Izhi à da di, ");
INSERT INTO ninNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Atiko wa ddu Atiko amungga wa di: “Ji so nu ungo ri umungga, di ingga ka abi karr ùwà ba surr ni imimi du ùwà vu aza sa na ba bari.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Doda ka ti yo Kristi wa ki ‘Atiko’, u Kristi wa ka na kingginggi na gru si ku Doda uhanma?” ");
INSERT INTO ninNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Unushirr uyirr mi à si hi inkindirr yi nggo à taka sa ku Yesu hen. Bazhi na azhibarr ama wa aba kru izhi ma are zizo. ");
INSERT INTO ninNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yesu à gru re na akpa anishirr wa kye na abiga ma ba ba di, ");
INSERT INTO ninNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Abitsarr na Are ba na anu Farrisi aba yo sa abangga ba nggo a kpanye ba di a bu bre inkindirr yi nggo Are ka Musa ka a da. ");
INSERT INTO ninNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Meme nggo imba bu kpa ni na undu ni inkindirr yi nggo a da di imba bu na, ni si ga uzirr umbarr ku hen. Kye a si di na inkindirr yi nggo a so tsarr di a bu na hen. ");
INSERT INTO ninNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","A di lo ku anishirr iki yi nggo rɨ nu umpa, ni vri ba igri, na si ri amarr ka ki uvuvurr ungo mi a zi ba igri iki yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“A di na aseki ambarr ka wemi wre ku anishirr mu a bu a hi ba. Uwa a ta si anu Farrisi na abitsarr ba nanko, abama a di naambu ka ibarr ambarr ka ki ankpinkpi, na di du inkinkru imbarr yi i ta ji nanka. ");
INSERT INTO ninNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","A di zha into iso inkpinkpi ni into i iga tuku na aki ka issubi ka. ");
INSERT INTO ninNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Na di zha di anishirr bu chi ba na kuttu nu udu, na di zha di anishirr bu yo ba di, ‘Unitsarr’. ");
INSERT INTO ninNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Uwa a ta si imba nanko, i si wre aba bu yo unuma ki ‘Unitsarr’ hen, nggo imba namri si imuyirr. Unitsarr amba wa à si uyirr yo. ");
INSERT INTO ninNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Imba bu si yo undurr ni imimi inggi yi di ‘Aki’, hen. Kye, Aki amba wa à si uyirr yo nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","I si wre aba bu yo imba di ‘Ankpye’ hen. Kye, Ankpye ni gri imba wa à si Kristi yo. ");
INSERT INTO ninNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Unkpi wa nu umi umba ku a bu su ugarr amba we. ");
INSERT INTO ninNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Undurr wa nggo à ti gɨ itu ima, aba ta gri ma kaji. Undurr wa nggo à ti gri itu ima ji, aba ta gɨ ma ki tsa. ");
INSERT INTO ninNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Uje umba imba abitsarr Are ba ni imba anu Farrisi ba. Imba abi na aseki wre ku anishirr a bu hi! Imba di harr anko ka mirri ni Ittu i unkplassu yi! Imba ku atu imba si mirri kuma hen, ni si kpanye di abanu nggo a so zha a bu rri kuma hen.  ");
INSERT INTO ninNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Uje umba, abitsarr Are ni imba anu Farrisi ba. Imba abi na aseki, wre ku anishirr a bu hi! Imba di ka amba ba ako ba mri, ni di barr tanko di anishirr a bu kye imba ki anishirr azizi. Ni ima yo, iha indanda yi mu ta kri bi imba ku ina ima. ");
INSERT INTO ninNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Uje umba, imba abitsarr na Are ba ni imba anu Farrisi ba! Imba abi na aseki wre ku anishirr a bu hi! Imba di zirr ga abi ni di cha inyi di imba di zha unushirr uyirr mi nggo à ta kasarr ga imba na anko amba wa. Nggo imba ti nga vu unushirr uyirr, imba di na ma ki ndanda, ma nggo a bu yo ma nu unto ki iha nu uru ku rri sese, mri atu amba wa mi. ");
INSERT INTO ninNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Uje umba, imba abitsarr anko ba kreshi! Imba tsarr di, ‘Unushirr à ti shi azhi ni isa i Uki Unkpi ku Ibarr Abachi ku, azhi akama à si ka gigye. Ùwà ti shi azhi ni izinarriya yi nggo u kurr nu Uki Unkpi ku Ibarr Abachi ku, uwa bu na inkindirr yi nggo a da zu na azhi akama.’ ");
INSERT INTO ninNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Dudurr imba aba kreshi! Uwatanggo à mri ki imba, izinarriya yi, ka Uki ku Ibarr ku nggo u na izinarriya yi ki ku Abachi izizi? ");
INSERT INTO ninNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ni di tsarr di, ‘Undurr wa nggo ti shi azhi na akikre ka ito ka, uwa à kpala ni ishi azhi ima yi, uwa ti shi azhi ni inkindirr yi nggo a gri yi nga na akikre ka, azhi akama a si ka gigye.’ ");
INSERT INTO ninNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Akreshi amba ka! A si kingginggi, uwatanggo a sha? Inkindirr yi nggo ùwà gri yi nga, ka akikre ka nggo a na inkindirr yi ssubi ku Abachi? ");
INSERT INTO ninNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Meme nggo, unushirr à ti shi azhi na akikre ka uwa so shi azhi na aseki ka nggo a so na akikre ka ndo na akikre ka mi. ");
INSERT INTO ninNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Uwa ti shi azhi nu Uki ku Ibarr ku, uwa so shi azhi akama kye na Abachi nggo à so nu umi. ");
INSERT INTO ninNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Undurr wa nggo ti shi azhi nu unkplassu, uwa so zhi azhi ni imburr i Abachi yi tuku Abachi wa nggo a so na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Uje umba, imba abitsarr na Are ba ni imba anu Farrisi ba! Imba abi na aseki wre ku anishirr a bu hi! Imba di zha di imba ta di nu Abachi inkindirr iyirr nu umi ku aseki awurr ka kye na amwi angbamvu ka nggo a di surr ni inyi mi. Ni si ga aseki ankpinkpi ka nu ure ku Abachi ujiji ku hen. Aseki akama ngga a si, ina wre ku anishirr, ni itito, ni ikru isisu i Abachi. Abangga ba yo si aseki ka nggo a wre imba bu na ka ni si ka atsitsa abanu ba du hen. ");
INSERT INTO ninNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Imba di tsarr anishirr anko, ni sa aba akreshishi. Imba si nâ ta si unushirr wanggo nggo à ttu ivinchi glo na ama, na sarr so alakurrmi à ttu mri nu umi ku ama ku! ");
INSERT INTO ninNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Uje umba, imba abitsarr Are ba tuku imba anu Farrisi ba! Imba abi na aseki wre ku anishirr a bu hi! Imba di ngla aseki ka iso amasirr ka tuku igbigba iri yi ba na abi, ni di du umi umbarr ku. Imba i se na aseki ka nggo imba i ka anishirr ngga mri ni ikpa ka, ni so di na aseki ka nggo a wre ku atu amba yo mre. ");
INSERT INTO ninNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Imba anu Farrisi ba akreshi! Hɨ inkindirr yi nggo se nu umi ku agbugba ku kuchi bari, abi ka mi a ta wre kye! ");
INSERT INTO ninNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Uje umba, imba abitsarr Are na anu Farrisi! Imba abi na aseki wre ku anishirr a bu hi! Imba si nâ ta si abe ka nggo a zharr kaki akikla, nggo a wre ikye ba na abi, na gri attuttu ka anishirr nu ubobo aseki nu umi. ");
INSERT INTO ninNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Imba mi si meme yo, na ábì imba wre ikye na ashishi ka anishirr, u umi umba ku u tsarr ssu nu umimi ni di na gigyemi di imba sa azizi. ");
INSERT INTO ninNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Uje umba, imba abitsarr Are ba tuku imba anu Farrisi ba! Imba abi na aseki wre ku anishirr a bu hi imba! Imba me abe ka abi kpa are ba wre kaba, ni zharr abe ka anishirr ba nggo zirr zizi du ka wre, ");
INSERT INTO ninNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ni bre di, ‘Ka di inta i se na ase ka ábáchí amunta ba, inta ka si yo ungo na ba ni ngɨ abi kpa are ba hen.’ ");
INSERT INTO ninNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ina imba yi mi i tsarr di imba si ahinhan ba anishirr ba nggo a ngɨ abi kpa are ba nggo! ");
INSERT INTO ninNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Imba si ba ttungo ni na aseki andanda ka nggo ábáchí amba ba a na zu na anko nggo hen! ");
INSERT INTO ninNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Imba inkirr i ànìwǎ andanda! Imba amumarr ani ibi! Abachi à ka lo imba ku ila ure imba yi ba, angginggi ta kpa imba ttungo nu uru ku rri sese ku? ");
INSERT INTO ninNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Uwa a si ni ima yi yo, ingga ta turr abi kpa are, na abi bwu ashishi na abitsarr nga ki imba. Imba ta ngɨ inkpu yi, ni ta kpa inkpu yi ni inkinkurr, ni ta hlo inkpu imbarr yi na aki ka issubi ka, ni ta tsutsarr ba ni igbu yi kago. ");
INSERT INTO ninNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ni ima yo, Abachi taka ni zhi imba ayiyi a anishirr azizi ba we, zhi ni ingu i Habila unushirr uzizi uwama kuma ni ingu i Zakarriya, uvuvurr a Barrakiya wa nggo imba i ngu ma na abi hinga nu unto ku akikre ka ito ka nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ingga da ki imba jiji mu di, aseki ka ngga ka wemi a taka nga na atu a imba anishirr ba ari ba! ");
INSERT INTO ninNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Urushalima, imba anishirr bu Urushalima! Imba i ngɨ abi kpa are ba ni ta abangga ba nggo Abachi à tu ba na angbinta. Ttuttumi, ingga di zha anko wa nggo ingga ta nggurr anishirr amuwa ba bi nâ ta si nggo iviko à di nggurr amarr ma ba bi na angba ama ka, imba si di kpanye hen! ");
INSERT INTO ninNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Kye, Uki unkpi ku Ibarr Abachi umba ku u ta kaki ako. ");
INSERT INTO ninNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ingga da ki imba, bazhi ziza imba si ta hi ingga zizo hen, kuma nu nggo imba taka da di, ‘Abachi à yo angu azizi ku unushirr wa nggo à nga ni isa i Atiko yi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nggo Yesu à ssuzzu nu Uki Unkpi ku Ibarr Abachi ku na so kuma abiga ma ba a kuma ku tsarr ma ime i Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Uwa kpanye ba di, “E-e, Imba hi ime inggi yi? Ingga ko da ki imba, a taka turr yi hre pempe. Ingbinta iyirr mi ì si taka hun so ni itu i inuma hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nggo Yesu gru nabo na hun kuma ku so ni Igbre nu Olivu wa, abiga ama ba a nga sharri ni da ku na yi di, “Da ki inta, a taka na aseki angga ka nita nggo? Sa angginggi taka tsarr inta di ivi i inga imuwa yi, ni ikikre i ingbingbru yi i ma ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","I Yesu ddu ba di, “So di gbye, ni si du undurr à re imba hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Anishirr shishemi a taka nga ni isa imungga, na ta ni da di, ‘Ingga yo si Kristi wa,’ na ta re anishirr shishemi du ba nga anko. ");
INSERT INTO ninNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Imba ta wo are ka iku ywhiywhirr tuku ugbagba. Meme mi imba bu si du isisurr imba yi i gru hen. Aseki akama a ti la meme mi, uwama yo a si ta si ikikre yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ìgbù ta tsi ni ìgbù, ittu ita ta iku ni ittu, iyo i ta ki, imimi yi ta battu na ankla shishemi kago. ");
INSERT INTO ninNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Uwama à taka si iha ime̱me̱ yi bari, ni taka si nâ ta si ine ingri nggi i gru ku ayamba. ");
INSERT INTO ninNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Aba ta vɨ imba nu ba gri ku tsutsarr na ngɨ. Ingbingbru yi namri ta karr imba ni itu imungga. ");
INSERT INTO ninNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ni ivivi ima yi, abanu shishemi a ta kakuma nu ugo ni iga yi. Anishirr shishemi a ta ki ku ikpa imu, abanu shishemi a ta karr ikpa. ");
INSERT INTO ninNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Abi kpa are abi imu shishemi a ta gru huzzu na ta re anishirr shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Nu nggo umimi u ta kri mwe, ikpanye ni ikpa i anishirr shishemi i ta su. ");
INSERT INTO ninNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Undurr wa nggo ti kri ngbangba kuma ni ikikre yi, Abachi taka kpa ma ttungo. ");
INSERT INTO ninNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","A taka da Ure ku wre ku Ittu i Abachi yi kago ni ingbingbru inggi yi, wre ku anishirr we a bu wo ku kago bari i ikikre yi i ta nga. ");
INSERT INTO ninNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Imba ti hi ‘Inkindirr indanda i ankizhi yi,’ nggo i ttu ūnké̱ surr na abubo a Abachi wa, nâ ta si nggo Daniya uni kpa are wa à da. (Uni bre wa a bu hi inkpi i ure ima yi.) ");
INSERT INTO ninNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Meme nggo, anishirr ba nggo a so nu Yahudiya a bu kru kuma na agbre ka. ");
INSERT INTO ninNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Unushirr wa nggo à so ni itu iko a bu si kru ji du uwa ta rri kuma ku vu iki nu uki bari hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Undurr wa nggo à kri ni īlá a bu si da du uwa a ta kru kuma ni iko ku ba ankru numa gri bari hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Iha i ta se ku amba ba nggo a hru ane ni ivi ima yi, na amba ba nggo a gri amumarr na ango! ");
INSERT INTO ninNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Barr Abachi du ukru unggo ku bu si ka si na aba, ka na Azhibarr a Isu wa hen! ");
INSERT INTO ninNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kye iha i ivi ima yi i taka vri mri iha yi nggo imba nise hi yi kye bazhi ni ime̱me̱ i ingbingbru yi nga ziza. Inkindirr inuma ì si taka mri inkindirr inggi yi ndanda zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A ka sama nu nggo Abachi à tsu ivi ima yi ki ntsɨmi, Unushirr uyirr mi ka si ka so tsitsirr hen. Uwa si na atu a abangga ba nggo Abachi hla ba nggo, aba yo a du Abachi à ta tsu ivi ima yi ma mi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ni ivi ima yi, undurr ti ddu imba di, ‘Kye Kristi wanggo ni inggya!’ ka da di, ‘Kye uwanggo nu unggu mu,’ imba bu si kpanye na ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kye, anu Kristi abi imu na abi kpa are abi imu a ta gru huzzu na ta na aseki ka ku ayisurr na ka ikagri, wre ba bu re anishirr kye na anishirr ba nggo Abachi à hla ba zu, nggo a ti hi anko. ");
INSERT INTO ninNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kye ingga i kuchi gba ki imba atu, ni itu i inkindirr inggi yi ivi yi ì ni se ni ichi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Undurr ti re imba di, ‘Kye uwanggo na ankpuji nggumu,’ imba bu si kru kuma nabo hen, aba a ti da di, ‘Kye, uwanggo kri nu umi uki ni inggya,’ imba bu si kpanye hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Uvuvurr a Unushirr à taka nggurr surr, nggo anishirr taka hi ma kago ankpu ayirr zzu nâ ta si ila i inge̱ nggi nggo di la nu unkplassu ku zhi na anza ambre kuma na anza a ingbahru. ");
INSERT INTO ninNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nu unto ku nggo iku i kurr, anangguru a di nggurr bi nabo. ");
INSERT INTO ninNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ni ikikre i ivi i iha yi, “ ‘azhi wa taka nggurr shirr, uhwa ku si ta la hen. Intsintse̱ yi ta kuhre zhi nu unkplassu, aseki ka unkplassu ka namri taka battu.’ ");
INSERT INTO ninNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ni ivi ima yi a taka hi inkindirr yi nggo tsarr inga i Uvuvurr a Unushirr yi na akpa. Anishirr bi ingbingbru ba wemi a taka yì, nggo a taka hi Uvuvurr a Unushirr ni ko nga na akpa ka unkplassu ka nu ukyekye tuku inkpinkpye ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A taka vri unddu unkpi ku nggo uwa à ta tu abitu ama ba kuma kago ingbingbru yi, aba ta kuma ku gri anishirr ama ba kago ni ingbingbru yi nggo a ka hla ba ni nggurr bi ni inkla iyirr. ");
INSERT INTO ninNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Du ibwa wa a tsarr imba. Nggo anggingga ama ka a ti ta ko nggarr angu, imba bu hi di ahru wa a ki ywhiywhirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Na anko ayiyirr ama yo, imba ti hi aseki angga ka a la we, imba bu hi di ivi ikanga ima yi ima ba. ");
INSERT INTO ninNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ingga da ki imba ure ujiji di aseki angga ka a taka la bari anishirr ba ari ba wemi a taka vu sarr. ");
INSERT INTO ninNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Unkplassu ni imimi taka ka nado, ure umungga ku u ta so sese. ");
INSERT INTO ninNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Undurr mi si hi azhibarr wa nggo a taka na aseki angga ka hen. Abitu ba Abachi ba nu unkplassu nu uwa Uvuvurr a Abachi wa mi à si hi hen. Aki uwa yo à hi azhibarr wa na nkpama. ");
INSERT INTO ninNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Azhi a inga a Uvuvurr a Unushirr wa à taka si nâ ta si inkindirr yi nggo i la ni ivi i Nuhu yi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ni ivi yi nggo amasirr wa a nise ni gu ttu abubo wa, anishirr a so di ri na so, aniru na amba a so di garr ikpa ku ma na azhibarr wa nggo Nuhu à rri ni ijirrigi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na si hi inkindirr yi nggo i ta la hen, mre na gru kakye amasirr mu ko gu ba we. I taka si meme yo nggo Uvuvurr a Unushirr à taka nga. ");
INSERT INTO ninNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ni ivi ima yi, anishirr aha a taka ko na undu ni īlá, aba ta ba uyirr na ka uyirr wa du. ");
INSERT INTO ninNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Amba aha a taka kri na abubo a iko, aba ta ba uyirr wa na du uyirr wa. ");
INSERT INTO ninNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Ni ima yo, imba bu so gbye yi, nggo imba si hi azhibarr wa nggo Atiko amba wa à taka nga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ka di akikye ni iko wa ka hi nita nggo ni ibittu yi unayi wa à ta nga ni iko ima, a ka di so tsitsirr na si kpanye du ma à mirri ni iko yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Imba bu so ssu shissu, kye Uvuvurr a Unushirr taka gru nga na azhibarr wa nggo imba si kye di à ta nga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“A su unggonggo si uvuvurr iko uwama nggo si uni wo ure na su ukrizhizhi? Uwa yo su uwanggo nggo akiko ma wa à nu ma inkpinkpye na atu amirr iko abanu ba, di à ka bu nu ba ila imbarr yi ttuttumi. ");
INSERT INTO ninNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","I ta wre ku uvuvurr iko uwama kakami, nggo akiko ma wa a ti kanga ni hi ma, uwa so na inkindirr yi nggo a da ku bari na kuma! ");
INSERT INTO ninNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ingga da ki imba akiko ma wa à ta ba ma a ki ankpye ni iko ima wa we. ");
INSERT INTO ninNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ka di a si uvurr iko umimi, ka da na amarr ama di, akiko ama wa à si ta kanga korr hen, ");
INSERT INTO ninNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","na ta di tsutsarr amirr iko abanu ba ni ihlo, na ta gru ga abi iso ahi ku di so na ri na ba. ");
INSERT INTO ninNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Akiko a uvuvurr iko uwama à ta gru nga azhibarr ayirr yo, nggo uvuvurr iko wa à si so kye anko ama wa hen, na azhibarr wa nggo a si hi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Akiko ama wa à ta ni hlo ma kakami, na ta han ma share ku zu na abubo a anishirr abi na aseki ba na abi wre ku anishirr bu hi ba. Nabo yo anishirr a ta ku di yì na ta anyinyirr. ");
INSERT INTO ninNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ni ivi ima Ittu i unkplassu yi i taka si ma mi: Azhibarr numa nggo áníwá abanu a sa awurr a gru vu ingba i uru imbarr, na kuma ko ma nu uni garr ku na anko. ");
INSERT INTO ninNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Akywi ba nu umi umbarr ku a si arrurru, akywi ba a si krizhizhi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Arrurru ba a vu ingba imbarr yi na si gri anye hen. ");
INSERT INTO ninNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","A krizhizhi ba gri ingba imbarr yi na gri anye shishemi ssu ni iki isurr anye imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Uni garr ayamba wa à so nado, na si nga korr hen. Áníwá ba a so di na gru kurr ina. ");
INSERT INTO ninNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Na atsutsu ibittu aba gru du di, ‘Uni garr ayamba wa à nga ba! Imba nga ni ma na ku na anko!’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Áníwá ba a gru awurr mi na ssu ingba ambarr yi ki. ");
INSERT INTO ninNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Arrurru ba a ddu krizhizhi ba di, ‘Imba sha anye amba wa ni inta yi, kye iru munta yi i ko kazhi.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Akrizhizhi ba a kisa ba di, ‘Iya, a si ta ma ki inta ni imba hen. Imba kuma ku re amba.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Nggo arrurru ba kuma ko re anye wa, uni garr wa à gru nga. Áníwá akywi ba nggo a so bi ma a gru rri ga ma kuma nu unto ku iga ku, na ka anko wa ttu. ");
INSERT INTO ninNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Nggo a ta so áníwá akywi ba a ku kanga, ni ko nggurr anko di, ‘Ankpye, ankpye! Bwu ki inta anko di inta mirri!’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Uni garr wa à ddu ba di, ‘Ingga da ki imba ure ujiji mu, ingga si hi imba hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","I Yesu da ba ni ikikre yi di, “Ni ima yo imba bu so di gbye yi, nggo imba si hi azhibarr a ikanga i Uvuvurr a Unushirr wa hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu da ba assurre anuma zizo da di, “Inkindirr yi nggo à taka na yi ni Ittu i unkplassu yi ì si nâ ta si nggo ugo numa à kuma nu uzirr. Nggo à gru ta kuma na yo amirr iko ama ba na ga ba aseki ka iko ma ka di a bu kye ku. ");
INSERT INTO ninNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ugo wa à hi ukyekye umbarr ku bari na ka aseki ka du ba. A nu unuma wa inklo abwubwu akywi, na nu unuma wa uha, unu utarr wa à kpa abwubwu ayirr. À na meme kre na gru kuma nu uzirr umaku. ");
INSERT INTO ninNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Uwanggo wa nggo à kpa abwubwu akywi ka à kuma ku re aseki na ka re, na kpa amasirr ni itu yi ki abwubwu akywi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Uwanggo nggo kpa abwubwu aha meme ku kru hwri, na kpa amasirr abwubwu aha. ");
INSERT INTO ninNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nggo unu utarr ambarr wa nggo a nu ma abwubwu ayirr wa, uwa gri inklo i atiko ama yi, ku ya udduddu ni imimi na ka wa yo sharri. ");
INSERT INTO ninNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Nggo atiko ambarr wa ku so ta anko na gru kanga zhi nu uzirr ku, na ni yo ba zu du uwa ta wo inkindirr yi nggo a na ni inklo ima yi nggo à nu ba. ");
INSERT INTO ninNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Uwanggo nggo à du ku abwubwu akywi ka à gri ka nga na gri amasirr nga kye ma, ni da di, ‘Ankpye, uwa ni ingga abwubwu akywi, kye akywi anuma ngga amasirr amungga wa.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Akiko wa à ddu ma di, ‘Ingga chi ùwà nu undu! Ùwà su uvurr iko uzizi uni gri inkindirr wre. Nu nggo ùwà gri inkindirr ntsɨ inggi yi wre, ingga ta nu ùwà aseki shishemi du ùwà kye ki ingga na ka. Nga ni nyarr ndo ni ingga ku!’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Uwa wanggo nggo a kpa abwubwu aha ka a mirri nga ni da di, ‘Ankpye, uwa ni ingga abwubwu aha. Kye, amasirr amungga nggo abwubwu aha.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Akiko wa à ddu ma di, ‘Ingga chi ùwà nu undu! Ùwà su uvurr iko uzizi uni gri inkindirr wre. Nu nggo ùwà gri inkindirr ntsɨ inggi yi wre, ingga ta nu ùwà aseki shishemi du ùwà kye ki ingga na ka. Nga ni nyarr ndo ni ingga ku!’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Uvurr iko wa nggo a nu ma abwubwu ayirr wa, à nga ni ddu atiko wa di, ‘Ankpye, ingga hi ùwà ì tsɨ kakami. Ùwà di hwa aseki ka nggo ùwà si ttu hen. Ùwà di ssu ikiri yi bi ni inkla yi nggo ùwà ì si ttu ikiri hen. ");
INSERT INTO ninNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ingga ì kru di inklo imuwa yi ì ta na ingga nado, ima yo di ingga gri yi ku ya imimi ni sha yi sharri. Kye! Uwanggo yo si inkindirr yi nggo ùwà ni ingga.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Akiko wa à ddu ma di, ‘Ùwà undanda tuku ussussu uvurr iko. Ùwà hi di ingga di hwa aseki ka nu unto ku nggo ingga si ttu hen, ni di ssu ikiri yi bi ni inkla yi nggo ingga si ttu ikiri hen? ");
INSERT INTO ninNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","E-e, à si meme yo, ùwà ka gri yi kuma ku zu ki ingga na abi zu inklo na amasirr ba ba, ingga ka ni ba yi na amasirr ni itu yi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“ ‘Kpa yi glo na ku, ka nu uwanggo nggo à se na abwubwu awurr ka. ");
INSERT INTO ninNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Abangga ba nggo a se ni inkindirr shishemi, a ta nu ba inuma sa ni itu. Imbarr yi i ta kri mwe ba shishemi. Uwa a ta si abangga ba nggo a sama ni inkindirr na anko, a ta vu ba kpa ivi ntsɨ inggi yi nggo à se na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Uwa ta su ankalanttu uvurr iko wanggo, a ta ba ma tu ku tu yo ni ibwu. Nabo yo uwa ta ku yì na ta anyinyirr.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Nggo Uvuvurr a Unushirr taka nga nu ukyekye ku Ittu umaku na abitu ba Abachi ba we na ku, uwa taka so ni imburr ittu ni inkpinkpye ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Anishirr ba ingbingbru ba we taka nggurr bi na ku, uwa taka ga ba ki aha, nâ ta si nggo uni ho di hla aminta ba glo na amuwu ba. ");
INSERT INTO ninNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Uvuvurr a Unushirr à ta zu aminta ba nu ungo ri uma, na zu amuwu ba nu ungo mla uma. ");
INSERT INTO ninNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Mre uttu wa taka da ku abangga ba nggo su nu ungo ri umaku di, ‘Aki mungga à yo ki imba angu azizi. Imba nga ni kpa aseki azizi zhi na Abachi ku. Imba nga ni so ni ri ndo na abubo a iso ni ittu wa nggo a na yi zu ki imba zhi nu nggo a na ingbingbru inggi yi. ");
INSERT INTO ninNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nggo iyo i ki ingga, imba ni ingga iri. Uhre ù ki ingga, imba ni ingga amasirr a iso. Ingga i su uhe̱he̱ ni imba ba, imba kpa ingga yo na ako amba wa. ");
INSERT INTO ninNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ingga so ni inkpohorr, imba ni ingga iki isurr. Nggo ingga lo, imba fu ingga. A gri ingga ku harr nu uki, imba ku rri ni ingga ku.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Azizi ba ta zhi ma di, ‘Atiko, inta na ku uwa meme nita nggo? Inta hi uwa nu momonggo, nggo uwa so ni iyo nu uhre, inta nu uwa iri ni iso? ");
INSERT INTO ninNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ùwà i su uhe̱he̱ nita nggo inta kpa ùwà yo na ako munta wa, ka ùwà sa ni inkindirr isurr inta nu ùwà ankru surr? ");
INSERT INTO ninNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ùwà ì lo nita nggo ni kri ni iharr nita nggo inta kuma nu ùwà ku?’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Uttu wa ta da di, ‘Ingga da ki imba ure ujiji, nggo imba ti na ku unuma nu umi ku amuyirr amba abi iklonyarr angga ba nggo sa amuyirr mungga ba, imba na si ki ingga yo!’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Mre uttu wa à ta da ku abangga ba nu ungo mla di, ‘Imba nggo Abachi à sarr antinte a surr imba, chi share ni ingga kuma ku rri nu uru ku nggo a na ku sese mu zu ku umimi wa na abitu ama ba. ");
INSERT INTO ninNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iyo i ki ingga, imba si ni ingga ila hen. Uhre u ki ingga, imba si ni ingga amasirr iso hen. ");
INSERT INTO ninNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ingga i su uhe̱he̱ ni imba ba, imba si kpa ingga hen. Ingga zirr ni ihorr, imba si ni ingga inkindirr isurr hen. Nggo ingga lo ni kri ni iharr, imba si kuma ku rri ni ingga ku hen.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Aba a ta da di, ‘Akiko, inta i hi ùwà nu momonggo ni iyo nu uhre ni si nu ùwà inkindirr iri, ka i iso hen? Ka ùwà nye ichirr, ka ihorr, ka ùwà lo, ka a gri ùwà ko ku ttu nu uki, inta ka izi ùwà?’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Uttu wa à ta da ba di, ‘Ingga da ki imba ure ujiji, nggo imba kà izi uyirr nu umi ku antsɨntsɨ angga ba, imba kà izi si ingga yo.’ ");
INSERT INTO ninNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Abangga ba yo a ta turr ba surr nu uru ku rri sese ku, uwa ta si abi na wre ba a ta kuma nu unto ku iso sese ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nggo Yesu kre itsarr ba are angga ka, na ddu abiga ma ba di, ");
INSERT INTO ninNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Imba hi di a ji ivi iha zhi ziza, aba a ta na Iga i Ivu Sarr yi, nggo a ta ba Uvuvurr a Unushirr nu abi karr ma ba du ba ku kpa ma nu unkunkurr!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nggo ankpinkpye abikye ba na akikre anishirr ba a nggurr bi ni iko i Kayafa, ankpye unkpi abikye wa, ");
INSERT INTO ninNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","na so zha anko wa nggo aba ta na na vu Yesu nayi ku tsi ngu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na da di, “Di inta si na meme na azhibarr a iga wa hen, wre ku anishirr ba bu si gru tsi akputtu hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu à se ni iko i Sima nu Betani, ugo wa nggo a ki iha nu ulolo ku ishi. ");
INSERT INTO ninNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nggo Yesu so ri ila nabo, ayamba numa gru nga na ku na gri anye wa nggo a ihun ingba wre na tsɨ anta ssu na azhizha a alabasta, na gri wa ni kasurr ku Yesu ni itu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Abiga ma ba a kye na vri isisurr na zhi ma di, “Uwa ka anye wa hre gigyemi da angginggi? ");
INSERT INTO ninNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nggo a ka ba anye anggo wa a re kpa inklo shishemi gri ku ga ku abi iha!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","I Yesu hi ivri imbarr yi na ddu ba di, “Imba so tsutsarr ayamba anggo wa na angginggi? A na ki ingga si inkindirr izizi mu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Abi iha ba ta di so iso inggi ni imba ba. Uwa a ta si ingga nanko, imba si ta di hi ingga ttuttumi hen. ");
INSERT INTO ninNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","À surr ki ingga anye anggo wa wre ku a bu ssu ukpa mungga ku bi zzu ni ibe. ");
INSERT INTO ninNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ziza, ingga da ki imba ure ujiji, unto ku nggo a ti ta da Ure ku wre ku ni itu i Yesu ni ingbingbru inggi yi, aba ta da inkindirr inggi yi nggo ayamba anggo wa à na wre ku anishirr a bu si kpamusu na ayamba wa hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Mre uyirr nu umi ku awurr na aha abiga Yesu ba, nggo a yo ma di Judasi Iskariyoti, à gru kuma na ankpinkpye abikye ba ba, ");
INSERT INTO ninNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na ku zhi ba di, “Imba ta ni ingga angginggi nggo ingga ti vu ugo nggo Yesu ni imba?” Aba bre ankpinkpri azurrfa ki iso itarr (30) a nu ma. ");
INSERT INTO ninNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bazhi nu unto kuma, uwa gru di zha anko wa nggo ta ná nà vu Yesu à nu ba. ");
INSERT INTO ninNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na azhibarr a ime̱me̱ wa a Iga i Unfonfo ni Sama ni Iyisti wa, abiga ma ba a nga ni zhi Yesu di, “Uwa di inta bi ku ssu unto ki ku uwa nu momonggo, nggo uwa ta ri Iga i Ivu Sarr yi?” ");
INSERT INTO ninNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu à ddu ba di, “Kuma nu umi ìgbù ku, imba ta ku hi ugo numa nggo, imba ddu ma di, ‘Unitsarr wa à da di azhibarr ama wa a nga ba, uwa na abiga ma ba à ta na Iga i Ivu Sarr yi ni iko muwa.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Mre abiga ma ba a kuma ku na nâ ta si nggo Yesu à da ba na ku ssu inkindirr iri yi ki nabo, nggo aba ta ri Iga i Ivu Sarr yi. ");
INSERT INTO ninNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nggo ingbahru yi i ki, i Yesu na abiga ma awurr na aha ba a ku ji so na ta ko ri. ");
INSERT INTO ninNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nggo a so ri wa, i Yesu gru da ba di, “Ingga da ki imba ure ujiji, uyirr nu umi umba ku à ta ba ingga nu abi karr ingga ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Abiga ma ba mi a kpa ure ukuma a vri isisurr kakami, na gru so zhi ma na ayiyirr di, “A si ingga? Atiko, ùwà si da di ingga hen?” ");
INSERT INTO ninNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","I Yesu da di, “Undurr wa nggo à so yo ungo ku ni ingga ku na agbugba wa à ta ba ingga re ba. ");
INSERT INTO ninNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Uvuvurr a Unushirr à ta ttu nâ ta si nggo a charr da nu Ungbamvu ku Abachi ku. Uje ku undurr uwama nggo à ta ba Uvuvurr a Unushirr à re nggo! I ka wre sha aba si ngri ma mi mremremi hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judasi wanggo nggo à ta ba Yesu à re ba, à gru zhi meme di, “Unitsarr, ùwà si so da di ingga hen?” I Yesu ddu ma di, “Nâ ta si nggo uwa da ki itu muwa.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nggo a ni so ri, i Yesu ba uvu unga unfonfo gri nu ungo, na nyarr ku Abachi, na mɨ ma, na ka nu abiga ma ba di, “Kpa ta yi. Kye, uwanggo yo su ukpa mungga ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Na ki ungo ba ukofi ku ahi ku, na nyarr ku Abachi, na ka ku a nu ba di, “Imba kpa so yi we. ");
INSERT INTO ninNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ayiyi anggo yo a lo ishi azhi i Abachi yi, ingga i ka wa kahre, wre ku a bu nggurr ila ure i anishirr shishemi zhi ba. ");
INSERT INTO ninNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ingga da ki imba, bazhi ziza ingga si ta so ususa àmà a ugbyarr ku unkunkurr anggo wa zizo hen, azhibarr wa nggo ingga taka so wa ni imba ba ki ahe̱he̱ a taka si ni ittu i Aki munta yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aba gru da usarr na hun kuma ni Igbre nu Olivu wa. ");
INSERT INTO ninNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu da ba di, “Ni ibittu i inggi yi imba wemi ta kru nado ni ta kà ingga du nâ ta si nggo Ungbamvu ku Abachi ku u da di: “ ‘Ingga ta ngu uni ka aminta wa, aminta ba a ta ga nado.’ ");
INSERT INTO ninNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nu ugo ku nggo ingga ti tasi, ingga ta ku ki imba ichi kuma nu Galili.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Biturr re ki Yesu di, “Abanu ba a ti kru nado mi, ingga si ta kru ni kà ùwà du hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu à ddu Biturr di, “Ingga nggo so da ku ùwà di, agba wa ta nise tu ni ibittu, uwa ta da ki ankpu atarr di ùwà si hi ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Biturr da di, “I ti ta ma ki ingga i ittu mi ndo nu ùwà ku, ingga si ta da meme hen!” Inkpu banu ba mi a da meme na ku. ");
INSERT INTO ninNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu na abiga ma ba kuma nu unto ku nggo a yo ku di Getsemani, uwa ku da ba di, “Imba ji so ni inggya, ingga ta chi kuma ku barr.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Na yo Biturr gri ndo na amumarr bu Zabadi ba aha mi. Na gru so wri kpakpa ku iha yi nggo i so ku ni itu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na da ba di, “Ivri yi nggo se ni isisurr imungga, i si kakami zzu di i ta ngu ingga mu. Imba kuso ni inggya ni so gbye yi ndo ni ingga ku.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Na chi kuma ntsɨ na ji kuttu ni imimi, na barr Abachi di, “Aki mungga, ùwà ti kpanye, ùwà ka ama iha anggo wa glo ki ingga! Ingga i si da di ùwà bu na nâ ta si nggo ingga da mu hen. Na inkindirr yi nggo iwre ku uwa.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Na kanga na abiga ma atarr ba na ni hi ba a so kurr ina, na ddu Biturr di, “Angginggi di imba atarr mi i si sha gbye ndo ni ingga ku ntsɨmi hen? ");
INSERT INTO ninNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Imba so tsitsirr, ni so gbye yi, ni so bi barr wre ku imba bu si ku ni la ure hen. Kye, izhi imba yi i so zha ina inkindirr yi nggo iwre, ukpa umba ku u su.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu kakuma ku barr zizo di, “Aki mungga, ùwà ti si kpanye di a bu ka iha inggi yi glo ki ingga hen, ùwà bu na inkindirr yi nggo iwre ku ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Na kanga ni hi ba so kurr ina yi zizo, nu nggo ina yi gbye ba na ashishi kakami. ");
INSERT INTO ninNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu ka ba du na kakuma ku barr zizo ankpu a utarr, na ku da angu ayiyirr akama yo. ");
INSERT INTO ninNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Na kanga na abiga ma ba ba, ni da ba di, “Imba ni so kurr ina yi ni so su mu? Kye! Azhi wa yo a ma ba nggo a ta vu Uvuvurr a Unushirr sa ku abi la ure na ango. ");
INSERT INTO ninNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Imba gru yi di inta kuma! Kye, uni ba ingga re ba wa uwanggo à ko zirr nga!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nggo Yesu ni so re na ba, u Judasi uyirr nu umi ku awurr na aha ba a nggurr surr na akpa anishirr di ga ma na gri injingba na ankpunkpu inkinkurr, nggo ankpinkpye abikye ba yo na akikre anishirr ba a tu ba. ");
INSERT INTO ninNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uni ba ma re ba wa à ka da ba nggo uwa ta ku na di, “Ugo wa nggo ingga ta ku nyarr ma vu gri, uwa à si uyo. Imba i so zha. Imba bu vu ma!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mre Yahuda tsi kuma ku ddu Yesu di, “Unitsarr, ingga chi ùwà,” na kla ma vu gri. ");
INSERT INTO ninNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu à ddu ma di, “Ukpamu, kuchi ni ina inkindirr yi nggo i gri ùwà nga!” Mre, anishirr abanu ba nga ni vu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Uyirr nu umi ku abangga ba nggo a di ga Yesu a ttu anjingba à sarr ku ugarr a ankpye unkpi abikye wa utu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","I Yesu à ddu ma di, “Ka anjingba muwa ka yo nu uhorr ku. Abangga ba nggo a ddu injinji a ta kɨ ni injinji iyo. ");
INSERT INTO ninNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ùwà si hi di ingga ka zha izi na Aki amungga ku, ankpu ayirr a ka turr ki ingga abitu ama ba shishemi ji mri abi ta iku ankinkirr ankpinkpi awurr na aha ba hen? ");
INSERT INTO ninNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ingga ti na meme Ure ku Abachi ku ta na ki ngginggi ni bu si jiji, nggo u da di uwama yo si inkindirr yi nggo a da di i taka la?” ");
INSERT INTO ninNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na attuttu akama Yesu kasarr na re na anishirr ba ba di, “Imba gri injingba na ankpunkpu inkinkurr di imba ta ni vu ingga zzu di ingga i si unayi? Ni ivivi yi, ingga so di tsarr imba nu Uki Unkpi ku Ibarr Abachi ku, imba si vu ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Aseki angga ka a si meme, wre ku ure ku nggo abi kpa are ba a charr na Angbamvu ka Abachi ka bu si jiji.” Abiga ma ba wemi a kru nggarr nado na ka ma du. ");
INSERT INTO ninNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Anishirr ba nggo a kuma ku vu Yesu na gri ma kuma ni iko i Kayafa, ankpye unkpi abikye wa, nu nggo abitsarr na are ba na akikre anishirr ba ku nggurr bi. ");
INSERT INTO ninNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","I Biturr di ga ba nu ugo kremu ku kri na akpla ka iko i ankpye unkpi abikye wa. Na ku ji so na abi gbye iko ba ba, wre ku ka hi inkindirr yi nggo a ta na ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ankpinkpye abikye ba na ankpinkpye abi Akaba anu Yahuda ba a so zha anishirr shishemi nggo ta ni ki imu ni itu ima yi, wre ba a bu vu ma tsi ngu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na si hi anko ayirr mi hen. Nu nggo anishirr shishemi a gru huzzu ku bre are mi ni itu ima yi, aba na, na na chankarr. Ni ikikre yi, anishirr aha ngga a mirri nga ni re̱ are, ");
INSERT INTO ninNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","di, “Ugo uwanggo wa à da di uwa se nu ukyekye ku turr Uki Unkpi ku Ibarr Abachi ku hre na vu ku me ni ivi itarr.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ankpye unkpi abikye wa à gru kri ki kri na zhi Yesu di, “Ùwà si ta sa ba hen? Ùwà sama ni inkindirr ida na are ka nggo a so bre surr ku ùwà?” ");
INSERT INTO ninNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","I Yesu so gbangbami. U ankpye unkpi abikye wa re na ku zizo di, “Ingga barr ùwà ni isa i Abachi uni so sese wa, da ki inta, ùwà yo su Kristi, Uvuvurr a Abachi wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","I Yesu à ddu ma di, “Nâ ta si nggo ùwà da. Ingga so da ki imba we, bazhi ziza kuma ni ichi, imba ta hi Uvuvurr a Unushirr ni so nu ungo ri ku Abachi ukyekye wa, ni ta hi ma so nga zhi na akpa ka unkplassu ka!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nggo ankpye unkpi abikye wa à wo ure ukuma na nga ankru ama ka hre na da di, “Kye, à re nâ ta si uwa nggo à si Abachi! Inta si ta zha iwo inkindirr numa zhi nu undurr ku zizo hen! Imba mi wo ure undanda ku nggo a da ni itu i Abachi! ");
INSERT INTO ninNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Imba kye kinggi?” Aba da di, “A la ure, a ta ttu.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Anishirr ba nggo a kri nabo a ddu antinte surr ku Yesu na ashishi na hlo ma na ankpu ango. Abanu ba hlo ma, ");
INSERT INTO ninNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","na da di, “Tsarr inta du ùwà si uni kpa are, Kristi. Da ki inta undurr wa nggo a nggurr ùwà!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nggo Biturr so na akpla ka iko i Ankpye Unkpi Abikye wa, uva ugarr unuma à gru nga na ba ni da di, “Uwa mi à di ga Yesu a anu Galili wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Uwa kisa na ashishi ambarr ka di, “Ingga si hi inkindirr ima nggo uwa so da hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na gru huzzu kukri na anko akpla wa. Uva numa ku hi ma nabo na da ku anishirr ba di, “Ugo nggo wa a di ga Yesu anu Nazareti wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","I Biturr kisa zizo di, “Ingga shi ki imba azhi, ingga si hi ma hen!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","A sha so ntsɨ, anishirr ba nggo a kri nabo a gru nga ni Biturr ku ni ddu ma di, “A si jiji mu, ùwà si uyirr nu umi ku anishirr ba nggo a di ga ugo nggo, ure umuwa ku u tsarr inta di ùwà zhi nu Galili!” ");
INSERT INTO ninNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","I Biturr à ddu ba di, “Ingga shi azhi di ingga so da ure ujiji! Abachi bu na ki ingga inkindirr indanda nggo ingga ti se na ba! Ingga si hi ugo wama hen!” Mre agba wa tu. ");
INSERT INTO ninNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","I Biturr ssu hi ida yi, nggo Yesu à da ku di, “Ùwà ta kisa du ùwà si hi ingga hen ki inkpu itarr bari agba wa taka tu.” Mre i Biturr à gru huzzu ku yì kpokpomi na ábì. ");
INSERT INTO ninNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ni igambre, ankpinkpye abikye ba wemi na akikre anishirr ba a nggurr bi na kpanye di a bu ngu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Na lo ma na ache gri na kuma, ku nu Bilatu, ugona anu Roma wa. ");
INSERT INTO ninNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nggo Yahuda, uni vu ma re̱ ba wa à hi di a kpanye di a ta ngu Yesu, isisurr vri ma, uwa à vu azurrfa iso tarr ku à gri ga ku ankpinkpye abikye ba na akikre anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Na ku ddu ba di, “Ingga la ure, ni ba ugo nggo, nggo à si na inkindirr hen i ni imba!” Aba da di, “Ima si vri ki inta hen. Uwama si ikye imuwa mu!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","U Yahuda ka inklo yi ta yo ba ni imimi yi nu Uki ku Ibarr ku na ka share, ku klo itu ima, na ttu. ");
INSERT INTO ninNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ankpinkpye abikye ba a ba inklo yi na da di, “Uwanggo si inklo i ayiyi, are amunta ka a si kpanye inta bu ka yi yo na abubo a zu inklo wa nu uki ku ibarr ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Na re bi, na ba inklo yi ku re abubo nu ugo uni me impirr wa ku, na ka wa ki abubo a zzu abichirr. ");
INSERT INTO ninNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ima yo du ba so di yo unto ukuma di “Unto ku Ayiyi” nga na ari. ");
INSERT INTO ninNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Meme nggo ure ku nggo Irrimiya uni kpa are wa à da u su ure ujiji di, “A ba azurrfa iso tarr ka, nggo ani Israila ba a da di aba ta ni ni itu i Yesu nggo, ");
INSERT INTO ninNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a gri ku re abubo nu uni me impirr wa ku, nâ ta si nggo Atiko wa à da ki ingga nggo.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nggo a gri Yesu na nga na age̱ ka ugona wa, uwa zhi Yesu di, “Uwa yo su uttu a anu Yahuda wa?” Yesu kpanye ku di, “Nâ ta si nggo ùwà da.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ankpinkpye abikye ba na akikre anishirr ba a bre are ka nggo a da di a na surr ku, uwa si sa ba hen. ");
INSERT INTO ninNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","U Bilatu à zhi ma di, “Ùwà si wo aseki ka nggo a so bre ni itu imuwa yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","I Yesu so ngbangbami, na si da inkindirr iyirr mi hen. Inkindirr ima yi i du ugona wa à ku ayisurr kakami. ");
INSERT INTO ninNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Bazhi ni ikuchi yi mu, azhibarr a Iga i Ivu Sarr wa a ti ma, ugona wa à di du ba ttu unushirr uyirr nggo a harr ttungo ku anishirr. ");
INSERT INTO ninNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ni ivi ima yi ugo numa à kri ni iharr, a hi ma kakami di a si ni di tto itsi, isa ima yi ri Barraba. ");
INSERT INTO ninNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nggo anishirr ba a nggurr bi, i Bilatu à zhi ba di, “Ingga bu ttu unggonggo ttungo ki imba? Ugo wa nggo a ri Barraba, ka Yesu wa nggo a yo ma di Kristi?” ");
INSERT INTO ninNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bilatu à zhi ba are angga ka na hi kakami di ankpinkpye ba nggo a vu Yesu gri nga ku, nggo a ki ishishi mu i Yesu yi. ");
INSERT INTO ninNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nggo Bilatu à so ni imburr inkpi i bre amu yi, ayamba ama wa à tu ba ni da ku di: “Ddu ango amuwa huzzu ni itu i ugo nggo. Ugo wa sama ni ila. Ingga i ki iha nu ula undanda kakami ni itu ima yi ni ibittu ari.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ankpinkpye abikye ba na akikre anishirr ba a turr anishirr ba di a bu da ku Bilatu di a bu ttu Barraba nggo ttungo ba, na ngu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","U Bilatu zhi anishirr ba zizo di, “Ingga bu ttu uwatanggo ttungo ki imba nu umi ku anishirr aha angga ba?” Aba du vo di, “Barraba!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatu zhi ba di, “Ni bu na Yesu wa nggo ri Kristi wa kingginggi?” Aba da wemi di, “Kpa ma nu unkunkurr!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","U Bilatu zhi ba di, “À la anggi?” Aba a du hantu kakami mri ime̱me̱ yi di, “Kpa ma nu unkunkurr!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nggo Bilatu à hi di uwa sama ni inkindirr ina zizo, na kru di a ta gru tsi kputtu, na du ba gri ku amasirr, na kpa wa a ngla ango ama ka na ashishi ka anishirr ba, na da di, “Ingga sama nu ungo na ayiyi a unushirr wanggo. Uwama à si undu umba mu!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Anishirr ba wemi a du nu ukorr uyirr di, “Du ayiyi ama wa a so na atu amunta na amumarr amunta!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","U Bilatu ttu Barraba a ttungo ba, na du ba a hlo Yesu, na ba ma nu ba gri kuma ku kpa ngu. ");
INSERT INTO ninNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Abi ta iku bu ugona ba a gri Yesu na rri kuma na ando a ugona wa, na kuma ku harr ma yo na atsutsu ndo ni inkpu abi ta iku ba. ");
INSERT INTO ninNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Na ttu ankru ama ka glo ku, na ku ba ankru anuma asisarr ni surr ku. ");
INSERT INTO ninNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Na ru intto ki anzɨ ni ttu ku ni itu, na ba unflankurr ku izirr ni nga ku nu ungo ri ki uttu, na so kuttu na sarr ma di, “Uttu anu Yahuda wa bu so sese!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A na meme na bu sarr antinte surr ma, na kpa unflankurr ku nu ungo umaku ka nggurr ma ni itu ankpu shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nggo a sarr ma kre, na ttu ankru ka glo ku na surr ku ankru ama ka. Na gri ma huzzu ta ku kpa ngu. ");
INSERT INTO ninNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nggo a so huzzu ni igbu wa, na ma nu ugo numa ku anu Sirrene a yo ma di Sima, abi ta iku ba a nga ma nggangga du ma à kpa ku Yesu unkunkurr ku. ");
INSERT INTO ninNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Na nga nu unto unuma ku nggo a yo ku di Goligota (Unto Ku Ukpahe Itu). ");
INSERT INTO ninNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nabo yo, abi ta iku ba a nu Yesuahi a rɨ kpakpa. Nggo Yesu à vu wa la kye, na kà. ");
INSERT INTO ninNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aba kpa ma nu unkunkurr ku, na turr kye ku ni kpa na ga iki isurr ima yi a ga. ");
INSERT INTO ninNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ni ikikre yi, na ku so gbye ma. ");
INSERT INTO ninNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Na charr ikpala ima yi a klo ku ni itu i unkunkurr yi di, “uwanggo yo à si yesu, uttu a anu yahuda wa.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Abi ta iku ba a kpa abayi abanu aha ndo ni Yesu ku, uyirr nu ungo ri, u uyirr nu ungo mla. ");
INSERT INTO ninNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Anishirr ba nggo so zirr na anko a kye Yesu na kpanye na atu na marr ma ");
INSERT INTO ninNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","di, “Uwa yo bre ba du ùwà ta hlo Uki Unkpi ku Ibarr Abachi ku nggarr ni ta vu ku me ni ivi itarr! Ùwà ti da du ùwà su Uvuvurr a Abachi, ùwà bu kpa itu muwa ttungo ni ji nu unkunkurr ku di inta kye!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ankpinkpye abikye ba, na abitsarr na are ba, na akikre anishirr ba a da ku na me̱ meme di, ");
INSERT INTO ninNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A hi ikpa abanu mu ttungo, na si hi ikpa itu ima ttungo hen? A si si uwa yo su uttu a anu Israila wa hen? A ti ji nu unkunkurr ku nggo ku ziza, inta ta kpanye nu ure ku umaku! ");
INSERT INTO ninNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A kpanye na Abachi ku na di yo itu ima ki Uvuvurr a Abachi. Abachi à ti kpanye na ku, uwa bu ttu ma ji ziza!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Abayi ba nggo a kpa ba ndo na ku mi a marr ma meme. ");
INSERT INTO ninNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Na azhi na atsutsu, abubo wa à nggurr ibwu kago, ku ma ni ikarrfe itarr i azhi. ");
INSERT INTO ninNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ni ikarrfe itarr yi, i Yesu à bwu angu à yì di, “Eloyi, Eloyi, lama sabachtani?” nggo si di, “Abachi amungga, Abachi amungga, a si anggi mu du ùwà kà ingga du?” ");
INSERT INTO ninNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Anishirr abanu ba nggo a kri nabo na wo ma na da di, “À so yo Iliya!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Mre uyirr ambarr wa à kru hanhan mi kuma ku ba usoso à yo nu ususa ahi na gri ni lo ni itu i unflankurr ná nà hun kuma ku Yesu di a bu so. ");
INSERT INTO ninNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Abanu ba so da di, “Du ma di inta so ni kye ka bu Iliya ta nga ni ttu ma ji!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mre i Yesu nggarr à yi zizo, na ttu. ");
INSERT INTO ninNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Upri nkru ku nggo u di klo nu Uki Unkpi ku barr Abachi ku u nggarr ki anga uha ba, zhi na atu ji nga na achi ka. Imimi yi i battu, angbinta ka a nggarr. ");
INSERT INTO ninNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Abe ka a bwu, anishirr abanu abi ga Abachi nggo a ka kɨ ba a tasi. ");
INSERT INTO ninNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Na ssuzzu na abe ka. Nu ugo ku nggo Yesu à tasi, aba mirri kuma nu umi ku ìgbù ni wre ku, anishirr shishemi a hi ba. ");
INSERT INTO ninNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ankpye a abi ta iku wa na abi ta iku ba nggo a so gbye Yesu a hi abubo wa ni battu yi na aseki ka nggo a la we, isisu ki ba kakami, aba da di, “Ugo nggo wa à si Uvuvurr a Abachi jiji!” ");
INSERT INTO ninNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amba shishemi nggo a so ga Yesu zhi nu Galili na di zi ma undu ku, a kri gbagbamu, na so kye. ");
INSERT INTO ninNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nu umi umbarr ku nabo a si anu Maryamu nggo zhi nu igbu nu Magadala, tuku Maryamu ayirr a Yakubu tuku Isuhu, ndo na ayamba a Zabadi wa nggo à si ayirr a Yakubu tuku Yohana. ");
INSERT INTO ninNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ni ingbahru ima yi, u ugo numa, a yo ma di Isuhu, nggo à se nu ungo kakami na si anu Arrimatiya à nga. Uwa mi a su uyirr nu umi ku abiga Yesu ba. ");
INSERT INTO ninNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","À rri kuma nu Bilatu ku, ku barr ma iku i Yesu yi. Bilatu kpanye ku di a bu ku ba yi a nu ma. ");
INSERT INTO ninNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Nggo Isuhu a kpa iku yi, na nga ni nyarr yi nu upri inkru ku nggo a di nyarr iku na ku, ");
INSERT INTO ninNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","na gri iku yi ku zzu ni ibe ima ihe̱he̱ yi, nggo a ya yi na ankɨ ingbinta wa. Na nyi ampu ingbinta wa nggo a si yarr a nga ni ttu angu ankonki ka ibe ka, na share. ");
INSERT INTO ninNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu nggo zhi nu Magadala ndo ni Maryamu unuma wa, a so nabo na so kye kuma ni ibe yi. ");
INSERT INTO ninNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Na azhibarr a uha wa, uwa si Azhibarr a Isu a anu Yahuda wa, nggo su nu ugo Azhibarr a issubi wa, u ankpinkpye abikye ba na anu Farrisi ba a ku nggurr bi nu Bilatu ku ");
INSERT INTO ninNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","na da di, “Ankpye, inta ssu hi anuma ngga ni itu i uni imu wanggo wa à ni di si tsitsirr na di da ba di, ‘Ingga taka tasi nu ugo ku ivi itarr.’ ");
INSERT INTO ninNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ni ima yo, uwa bu ni abi ta iku du ba ku gbye ibe ima yi ki ivi itarr di inta kye, wre ku abiga ma ba a bu si ku ttu iku yi na ku bre ku anishirr di à tasi hen. I imu ima yi ta mri i me̱me̱ yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatu à da ba di, “Imba ku du ba a gbye ibe inggi yi kakami nâ ta si nggo imba hi.” ");
INSERT INTO ninNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Aba kuma ku hu ibe yi kago na du abi gbye ba hun so na yi na so gbye. ");
INSERT INTO ninNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nu ugo ku Azhibarr a Isu wa, nggo ambre ka azhibarr a ime̱me̱ ka a so nggarr ni igbu, i Maryamu nggo zhi nu Magadala tuku Maryamu unuma wa, à gru da aba ta ku kye ibe yi. ");
INSERT INTO ninNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mre imimi yi i gru battu kakami. Unitu a Abachi wa ji zhi nu unkplassu, na kuma ni ibe yi ku ngi ingbinta yi glo na hun so na yi. ");
INSERT INTO ninNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ashishi ka unitu ka a so la nzarrnzarr zzu inge̱, ankru ka si akikla pyarr. ");
INSERT INTO ninNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Isisu ki abi gbye ibe ba nggo a hi unitu wa, aba a wri kpakpa na kuhre kurr zzu aku mu. ");
INSERT INTO ninNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Unitu wa re na amba ba ba di, “Imba si kru isisu hen. Ingga hi imba i so zha Yesu yo, nggo a kpa ma. ");
INSERT INTO ninNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","A si se ni inggya hen. A ka tasi ba, nâ ta si nggo a da. Zirr nga ni inggya ni kye unto ku nggo a yo ma. ");
INSERT INTO ninNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Narrma ku da ku abiga ba di, ‘A ka tasi ni ibe yi ba, na so ku ki imba ichi kuma nu Galili, imba ta ku hi ma nabo!’ Kye ingga i ka da ki imba ba.” ");
INSERT INTO ninNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Amba ba kru ki kru share ni ibe yi, ni isisu ni inyarr, na kru ko ida ku abiga ma ba. ");
INSERT INTO ninNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mre Yesu ma na ba na anko na chi ba di, “Ingga chi imba yi.” Aba ku vu ma na aza na gbyarr ku asa. ");
INSERT INTO ninNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu ddu ba di, “Si ki isisu hen. Kuma ku da ku amuya amungga ba di a bu kuma nu Galili. Nabo yo aba ta ku hi ingga.” ");
INSERT INTO ninNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nggo amba ba so ga anko wa, abi ta iku ba nggo a di gbye ibe yi a mirri kuma nu umi ìgbù ku, ku so bre ku ankpinkpye abikye ba inkindirr yi nggo ila we. ");
INSERT INTO ninNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ankpinkpye abikye ba na akikre anishirr ba a nggurr bi na ssu anko wa nggo abi gbye ibe ba si ta bre ku anishirr ure ukuma hen. Na yo ba na ga ba inklo shishemi ");
INSERT INTO ninNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","di, “Imba da ku anishirr ba di, ‘Abiga ma aba yo a kuma ku ba iku yi ni ibittu nggo inta so kurr ina.’ ");
INSERT INTO ninNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ugona wa ti wo ure ukuma, inta ta kri ki imba nu ugo, di imba si hi inkindirr ni itu yi hen. Imba ta sama ni ivri ni itu i ire yi.” ");
INSERT INTO ninNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Abi gbye ba a kpa inklo yi nà ná nâ ta si nggo a da ba di a bu da. Uwama yo su ure ku nggo ani Yahuda ba so da ku nga zizami. ");
INSERT INTO ninNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Abiga ma awurr na ayirr ba a kuma nu Galili, ni igbre wa nggo Yesu a da ba di a bu kakuma. ");
INSERT INTO ninNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Aba a hi ma, na kuttu, na gbyarr ku asa. Ni ihi ma ima yi mi, abanu ba se na asusurr aha. ");
INSERT INTO ninNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu chi kuma na ba na ddu ba di, “A ni ingga ukyekye we nu unkplassu tuku ni imimi. ");
INSERT INTO ninNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ni ima yo, imba bu kuma na anishirr bi ingbingbru ba ba ni ku na ba ki abiga amungga. Abangga ba nggo ti kpa ure mungga ku, imba zzu ba na amasirr ni isa i Aki yi, tuku i Uvuvurr yi tuku Izhi i Iwre yi, ");
INSERT INTO ninNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ni tsarr ba du ba na aseki ka wemi nggo ingga i da ki imba. Kye, ingga ta di so ni imba ba ttuttumi, ka ku ma ni ikikre i ingbingbru yi.”");
INSERT INTO ninNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Uwanggo yo su Ure ku wre ku ni itu i Yesu Kristi, Uvuvurr a Abachi wa. ");
INSERT INTO ninNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ure ku wre ku na ase ka kuchi ka nggo Ishaya, uni kpa are ka Abachi wa à charr da di Abachi da di, “Ingga ta tu unitu mungga wa du ma kuchi ku bi ssu anko wa bi ku uwa.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Undurr so du na ankpuji, ‘Ssu anko wa bi ku Atiko wa. Na wa ki ntto nggo a taka ni wre ku uzirr!’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Unitu wa a si Yohana ni di zzu anishirr na amasirr. À di zirr na ankpuji, na di zzu anishirr ba na amasirr, na tsarr ba da di, “Imba du ila ure imba yi, ni du ba zzu imba na amasirr. Abachi ta nggurr ila ure imba yi zhi ki imba.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Anishirr shishemi a nga zhi na anga ka nu Yahudiya, na abanu a zhi nu umi igbu ku Urushalima. A nga ni wo ure ku Yohana ku, na da ila ure imbarr yi, uwa zzu ba na amasirr ni inyi nu Joda. ");
INSERT INTO ninNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohana a di surr ankru ka nggo a na ka ni infunfu i alakurrmi, na lo upri unggakpa na anklampi. A di ta ìzì na di re̱ utu ku anisso. ");
INSERT INTO ninNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A di tsarr anishirr ba da di: “Undurr numa à so nga nu ugo mungga. A mri ingga kakami. Izhizhi i anggakpaza ima yi mi, ingga si ma ni ku klo ni ddu ka hen. ");
INSERT INTO ninNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ingga zzu imba na amasirr, uwa ta ka ni zzu imba ni Izhi Iwre i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","A si ni ivi ima yo i Yesu à nga zhi ni igbu nu Nazareti, na anga ka Galili ka, i Yohana nga ni zzu ma na amasirr ni inyi nu Joda wa. ");
INSERT INTO ninNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kakayirr, Yesu à so huzzu zhi nu umi ka amasirr ku, na hi unkplassu ku u bwu. A hi Izhi Iwre i Abachi yi nga ni so ku nu ukpa, ni izzu na sa anddu. ");
INSERT INTO ninNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Aba wo ukorr zhi nu unkplassu da di, “Ùwà yo su Uvuvurr mungga wa nggo ingga kpanye nu ùwà ku. Izhi mungga yi i nyarr nu ùwà ku kakami.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kakayirr i, Izhi Iwre i Abachi yi nga ni du ma rri ko na ankpuji. ");
INSERT INTO ninNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nabo yo, uwa ku so ki ivi iso ine̱ (40), ndo ni ininazzu i ijiji. Nabo yo, Isheta à ku tsarr ma kye. Abitu ba Abachi ba ku so zi ma. ");
INSERT INTO ninNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","A vu Yohana ku ttu nu uki, ni ivi ima yi nggo Yesu à kuma nu Galili, ku so tsarr Ure ku wre ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","A ddu ba di, “Ivi yi i nga ba. Ittu i Abachi yi i si ywhiywhirr mi. Imba kasarr ni ila ure imba yi, ni kpanye nu Ure ku wre ku!” ");
INSERT INTO ninNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","A ti ta so vu sarr nu unddu inyi ku Galili ku, na hi anishirr aha bi vu ikikla, Sima tuku Andoro uzayirr wa, a so ta azhizhi ki vu ikikla ni inyi wa. ");
INSERT INTO ninNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu à yo ba na ddu ba di, “Imba ga ingga yi, ni di ingga tsarr imba nggo imba ta gri anishirr nga ni ingga ku nâ ta si nggo imba di vɨ ikikla yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","A wo meme, kakayirr, na du azhizhi ambarr ka, na ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Na ti sha zirr a ko ntsɨ na hi amuya aha abanu, Yakubu tuku Yohana, amumarr bu Zabadi a so nu umi ku uddu umbarr ku, na so na azhizhi ambarr ka ssubi. ");
INSERT INTO ninNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kakayirr, Yesu à ti sa ashishi na ba, na yo ba, aba wo na ka aki ambarr wa Zabadi du ndo na amirr iko abu undu ba na ga Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu na abiga ma ba, a nga nu Kapanahu. Na Asabarr, Azhibarr a Isu anu Yahuda wa, Yesu à rri ko ku so tsarr nu uki ki issubi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Anishirr ba wo ma. Ayisurr ambarr wa jaku ni itsarr ima yi. À si tsarr ba, nâ ta si itsarr i abitsarr are ba hen. A so tsarr ba kyekye mi zzu nâ ta si uwa nggo sa akikye nu ure wa. ");
INSERT INTO ninNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nggo a se nu uki ki issubi ku, ugo numa a se ni izhi ndanda na nggarr angu yi da di, ");
INSERT INTO ninNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu anu Nazareti, uwa zha angginggi ni inta ba? Uwa nga ingu inta mu? Ingga hi uwa. Uwa yo su Uni wre wa nggo zhi na Abachi ku!” ");
INSERT INTO ninNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu a nggarr ito ni izhi ndanda yi ku, da di, “Ttu angu muwa! Huzzu ku ugo wa nu ukpa!” ");
INSERT INTO ninNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Izhi ndanda yi i mri ugo wa, ni du ma wri kpakpa, ni nggarr iyi, ni huzzu kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Anishirr ba wemi nggo a kri nabo a ku ayisurr. Na so zhi ikpa ambarr, da di, “Uwama sa angginggi? Uwanggo a si itsarr ihe̱he̱ mu? Ugo wanggo a se nu ukyekye ki re ki izhi ndanda, i wo ma!” ");
INSERT INTO ninNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nabo yo, ure ku Yesu ku bwa kago hanhan mi na anga ka Galili ka. ");
INSERT INTO ninNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu na abiga ma ba ndo ni Yakubu tuku Yohana huzzu nu uki ki issubi ku, na kuma ni iko ini Sima tuku Andoro. ");
INSERT INTO ninNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ukpa ku ayimbarr a Sima wa u nggurr ssu. Nggo a ti mirri aba da ku Yesu ivri ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu rri ko na ku, na ko ku vu ma nu ungo, na gɨ ma gru. Ivri yi du ma, uwa a gru na zzu ba ila. ");
INSERT INTO ninNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ni ingbahru ima yi, azhi wa a ji ba na klo gbo, aba gri ku Yesu abi lo na abi izhi ndanda. ");
INSERT INTO ninNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Anishirr shishemi abu Kapanahu ba shishemi a nga ni kri na akpla ka iko ka. ");
INSERT INTO ninNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yesu du anishirr ba nggo a se ni ilolo yi na nkanka a wre, na han anazhi ndanda yi huzzu ku anishirr shishemi nu ukpa. Na si kpanye di anazhi ndanda ba bu da inkindirr hen nu nggo aba mi a hi ma. ");
INSERT INTO ninNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ni igambre bwu, nggo abubo wa ni ko su wriwri, Yesu gru huzzu ni iko yi na ko ku so barr nu unto ku nggo su ywi. ");
INSERT INTO ninNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Sima na akpukpambarr ba a gru huzzu ku di zha ma. ");
INSERT INTO ninNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nggo a ko ku hi ma, na da ku di, “Anishirr ba namri a ko zha uwa.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu ddu ba di, “Di inta kuma ni igbu numa yi meme, di ingga ki itu mungga ku tsarr ba ure ku Abachi ku nabo. Ima yo gri ingga nga.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yesu na abiga ma ba di zirr kago ni igbu i Galili yi. Uwa ku di tsarr ba na aki ka issubi ka na di han anazhi ndanda huzzu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Uni lo ishi numa nga ni Yesu ku, na ni kuttu na agbuzzu na barr ma di, “Uwa ti kpanye, uwa di ingga wre.” ");
INSERT INTO ninNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Itito i ti Yesu na ku. Yesu ti ungo sa na ku na di, “Ingga kpanye. Uwa bi wre!” ");
INSERT INTO ninNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ishi yi huzzu keke, uwa wre. ");
INSERT INTO ninNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Yesu gba ku utu kakami di, “Si da ku undurr inkindirr hen. Kuma ku tsarr unikye wa ukpa muwa ku. Uwa ti hi du ùwà wre, uwa bu ni Abachi aseki ka nggo Musa à da di, uni lo ishi ta wre, uwa bu ni ka, na du anishirr bu hi du ùwà à wre ba.” Na du ma kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nggo ugo wa huzzu na so bre ku anishirr kago ankonki. Ima yo du Yesu à si rri ko nu umi igbu ku na du anishirr hi ma hen. Na ku di so ni into inggi nggo su ywi mi. Anishirr ba zha ma ku hi na di kuma na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","A ki ivi numa ntsɨ, Yesu kanga nu Kapanahu, anishirr ba a wo kago da a se ni iko. ");
INSERT INTO ninNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Anishirr shishemi a gru ni ttu ma zu nu umi uki na ssu harr anko wa ke na abi ka mi anko a mirri ko na ku a sama. Yesu a so bre ba ure ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nggo, Yesu a ni so bre ba ure ku, anishirr ane̱, a ba ugo numa nggo ukpa ku u ttu ywi, na nga na ku di a bu ni du ma wre. ");
INSERT INTO ninNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Nggo, anishirr ba a kri shishemi na harr anko wa, aba si hi unto ki gri ma na rri ko hen. Aba hun ni ituki yi na ngri anchirr ka nu unto ku nggo Yesu à so, na to uni vri wa nu utakpa ku ji nga ni inkla yi nggo Yesu à se. ");
INSERT INTO ninNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nu nggo Yesu a kye iyo isisurr imbarr yi na ku, na da ku uni vri wa di, “Uzumu, ingga nggurr ila ure muwa yi zhi ku uwa.” ");
INSERT INTO ninNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Abitsarr nu ungbamvu ku are ku, a se nabo, na so ta amarr ni isisurr imbarr yi da di, ");
INSERT INTO ninNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ugo nggo à da sa angginggi meme? A re ndanda mi ni itu yi Abachi! Unggonggo ka nggurr ila ure i anishirr zhi ba. A sa Abachi yo na kpa ma.” ");
INSERT INTO ninNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kakayirr, Yesu a hi ni izhi ma yi inkindirr inggi nggo a so ta amarr ni itu yi, na zhi ba di, “Sa angginggi di imba ri amarr ka ma meme? ");
INSERT INTO ninNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Uwatanggo tsɨ ki imba, ingga bu da ku ugo uni lo wa di, ‘A nggurr ila ure muwa yi zhi ku ùwà,’ ka ingga bu da ku, ‘Gru! Ba abubo a ikurr amuwa, ni kuma?’ ");
INSERT INTO ninNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ingga ta tsarr imba di, Ingga, Uvuvurr a Unushirr, ingga se nu ukyekye ni ingbingbru yi ki nggurr ila ure zhi.” Na da ku ugo wa nggo ukpa ku ttu wa di, ");
INSERT INTO ninNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ingga da ku uwa, gru. Chi abubo a ikurr amuwa ni kuma ni iko!” ");
INSERT INTO ninNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na ashishi ambarr ka, ugo wa gru kri, na chi abubo a ikurr wa, na narr kuma. Ayisurr ku ba wemi. Aba gru ko gbyarr ku Abachi asa na da di, “Inta nise hi inkindirr numa ma mi!” ");
INSERT INTO ninNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu à kakuma zizo nu unddu inyi nu Galili wa. Anishirr ba a ddu na nga na ku. Uwa gru ko tsarr ba. ");
INSERT INTO ninNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","A ti ta ko sarr ko, na hi uni kpa inklo imimi numa, nggo a yo ma di, Levi, uvuvurr a Alifiyo, uwa rri so nu uki ku undu umaku. Yesu yo ma di, “Ga mi!” Levi gru ga Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","A sha so ntsɨ, Yesu gru kuma ni iko yi Levi, ku so ri inkindirr. Abi kpa inklo imimi ba na abi kà ikpa ure ku Musa ku, a so ma mi ni Yesu na abiga ma ba, na so ri ma mi nu unto uyirr. ");
INSERT INTO ninNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Anu Farrisi banu nu nggo a sa abitsarr ba nu ungbamvu ku are ku. A hi nu nggo Yesu à so na so ri na abi kà ikpa ure ku Musa ku na abi kpa inklo imimi ba; na zhi abiga ma ba di, “Angginggi du ma ri na abi kpa inklo imimi ba na ndanda anishirr angga ba?” ");
INSERT INTO ninNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nu nggo Yesu wo ba ni zhi yi, na da ba di, “anishirr akyekye a si di zha unahun hen, a sa abi lo ngga di zha unahun. Ingga si nga nye i yo abi sa ni ila ure hen, ingga nga nye i yo andanda ba yo, du ba a kasarr ni ila ure imbarr yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Azhibarr numa nggo abiga bi Yohana uni zzu na amasirr wa na anu Farrisi ba a so vu angu. A banu nga ni zhi Yesu di, “A sa angginggi abiga bi Yohana uni zzu na amasirr wa na abiga ba anu Farrisi ba di vu angu gri, abiga amuwa ba si di vu angu gri hen?” ");
INSERT INTO ninNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu ddu ba di, “Imba kye, i ka wre ikpikpa i uni hru ayamba he̱he̱ bi so ni iyo? I ka si wre meme hen uwa ta ni so na ba. ");
INSERT INTO ninNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Azhibarr wa so nga nggo a ta ka ni ba uni garr he̱he̱ wa glo na ba, aba ta ka vu angu. ");
INSERT INTO ninNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Unggonggo ka ba upri inkru uhe̱he̱ warr sa na ankru kuku? Undurr wanggo nggo ta na meme, nggo a ti ngla ankru ka upri he̱he̱ ku, ta gbu nga glo, ingahre ima yi ta kri na ime̱me̱ yi. ");
INSERT INTO ninNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Anishirr si di ba ahi ahe̱he̱ kasurr nu unggakpa ku zu ahi ukuku hen. Uwanggo nggo a ti na meme, ahi ahe̱he̱ wa ta tsi unggakpa ukuku ku nggarr na kuhre, unggakpa ku u ta sama nu undu. Meme nggo, a ta surr ahi ahe̱he̱ nu unggakpa ku zu ahi uhe̱he̱, aba aha mi ta kurr zizi.” ");
INSERT INTO ninNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Asa Azhibarr a Isu anu Yahuda wa, nggo Yesu a so zirr ni izzuzzu i ikiri, abiga ma ba a se na ku, na gru so ngu ingbingbi ikiri yi ta. ");
INSERT INTO ninNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Anu Farrisi ba da ku Yesu di, “Kye, iba munta yi si kpanye ni inkindirr yi, nggo abi bre amuwa ba a so na undu na Azhibarr a Isu anu Yahuda wa hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yesu ddu ba di, “Ingga hi imba ka bre ba nggo uttu Doda na anishirr ama ba a na, nu nggo iyo yi ki ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Doda à ko ku rri nu uki ku Abachi ku, na ri unfonfo wa nggo a gri nga ni Iburr i nggurr bi yi Abachi yi. (Inkindirr ma yi i si meme na attuttu wa nggo Abiyata nggo à su ankpye unkpi abikye anishirr ba Abachi ba.) Ni iba munta yi unikye yo na nkpama di ri ashiki kama. U Doda ri ka na tsu nu abiga ma ba du ba kpa ri meme.” ");
INSERT INTO ninNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ni ikre ire yi, Yesu da ba di, “Abachi a na Azhibarr a Isu wa ku unushirr yo, na si na unushirr nggo ku Azhibarr a Isu wa hen. ");
INSERT INTO ninNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ingga, Uvuvurr a Unushirr, Ingga yo sa Atiko a Azhibarr a Isu wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yesu ka rri ko na ba nu uki ki issubi ku zizo. Ugo numa nggo su nu unka ungo a se nu umi uki ku. ");
INSERT INTO ninNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Uwa sa Azhibarr a Isu anu Yahuda wa. Anishirr banu rri kri na ko gbye ma, da a ti ka na inkindirr numa aba ka nu ma ila, na so kye girr mi, di à ta gru du ungo ku u wre ku ugo wa na azhibarr a isu anu Yahuda wa. ");
INSERT INTO ninNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu yo ugo nu unka ungo wa di, “Gru nga ni ichi.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Yesu zhi anishirr ba di, “Are ka Musa ka di inta bu na angginggi na Azhibarr a Isu wa? Di inta bu na uzizi, ka inta bu na umimi? Di inta bu du unushirr so tsitsirr, ka inta bu ngɨ anishirr?” Aba so ngbangbami na si sa ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesu ki unfu, na kye ba. Itito ki ma ni ikri itu ambarr yi. Uwa kasarr na ddu ugo uni vri wa di, “Na ungo ku!” Ugo wa na ku, u wre ku zizo. ");
INSERT INTO ninNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Anu Farrisi ba na anishirr ba Hirridu ba huzzu ku ssubi na ábì, nggo aba ta na na ngu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu na abiga ma ba gru so ji kuma nu unddu inyi ku akpa anishirr di ga ba. Akpa anishirr gru zhi na anga ka Galili, abanu na anga ka Yahudiya, ");
INSERT INTO ninNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nu Urushalima, na anga ka Idumiya, na anga ka inyi nu Joda, na anga ka igbu Taya tuku Sido. A gru shishemi na nga ni Yesu ku, da aba ta ni wo na kye inkindirr yi nggo, aba si di wo da a di na nggo. ");
INSERT INTO ninNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nggo a kye anishirr ba kri garrza na da ku abiga ma ba du a bi gri ku uwa uddu, du ku anishirr ta ma uwa. ");
INSERT INTO ninNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","A du abi vri shishemi wre, abi vri banu ba ni ko nga ngɨ nga mu, na ko zha anko nggo aba ka ka ungo sa na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ttuttumi abangga ba nggo se na anazhi ndanda a rri so ba nu ukpa a ti hi ma, aba di jaku ni imimi na age̱ ka Yesu, na di ttu iyi hantu di, “Uwa yo su Uvuvurr Abachi wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu gba ki izhi ndanda yi utu di i bu si di ba uwa da ku anishirr undurr du uwa su unggonggo hen. ");
INSERT INTO ninNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu hun kuma ni igbre numa na yo anishirr ba nggo uwa kpanye na ba na du ba hun ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Uwa ku hla nu umi ambarr ku awurr na aha ba, nggo a yo ba ki abi ko na angu. Na da ba di, “Ingga hla imba di imba taka bu se ni ingga ku, ni di ingga bu tu imba ko na anishirr ba nu ure ku Abachi ki iso sese ku. ");
INSERT INTO ninNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ingga ta nu imba ukyekye ki han izhi ndanda.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Abangga ba yo sa asa a anishirr awurr na aha ba nggo Yesu hla ba: Sima nggo Yesu yo ma ki Biturr, ");
INSERT INTO ninNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu tuku uzayirr wa Yohana, amumarr ba Zabadi, nggo Yesu yo ba di Bonaji, (anishirr bi inge̱.) ");
INSERT INTO ninNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andoro tuku Filibu, u Batolomi, u Matiyu, u Toma, u Yakubu uvuvurr a Alifiyo, Tadawo, tuku Sima, nggo à se na amarr ka ako ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","U Judasi Iskariyoti, nggo vu Yesu nu ba tsi ngu nggo. ");
INSERT INTO ninNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Yesu ko kuma ni iko, anishirr ba bi nga na ku zizo. Nggo Yesu na abiga ma ba si hi unto ki ji so na ri ikiri hen. ");
INSERT INTO ninNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nggo amla ma ba wo na gru nga da aba nga nye vu ma gri kuma ni iko di, “Itu yi gbuddu ku!” ");
INSERT INTO ninNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Abitsarr are ba nggo nga zhi nu Urushalima da di, “Da su Isheta, nggo a yo ma di, Belzebulu, uttu ani inkindirr yi nggo nu ma ukyekye ki han izhi ndanda yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu yo ba chinga nu ukpa uma na da ba assurre numa, na zhi ba di, “Isheta di han Isheta? ");
INSERT INTO ninNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ìgbù wa nggo ti ga ki na nkanka na so tsi ni ikpa, a ta kre. ");
INSERT INTO ninNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iko inggi nggo ti ga ki na nkanka ni so tsi ni ikpa i si di kri hen. ");
INSERT INTO ninNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ittu yi Isheta ti ga ki na nkanka ni so tsi ni ikpa i si ta kri hen, i ta jaku ni kre. ");
INSERT INTO ninNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Unayi ti ta rri ni iko yi unushirr ukyekye, uwa ta ku vu ma lo zu bari, na ki ayi ka. ");
INSERT INTO ninNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ingga so da ki imba ure ujiji, a ta nggurr zhi ku abi ila ure, na abangga ba nggo da are andanda ni itu yi Abachi. ");
INSERT INTO ninNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Abachi si ta nggurr zhi ku unushirr wa nggo ti da ure undanda ni itu yi Izhi Iwre yi Abachi yi hen, ila ure ima yi i so sese ni itu ima.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Inkindirr yi nggo Yesu da ba meme, nggo abanu ba da da à se ni izhi ndanda. ");
INSERT INTO ninNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ayirr a Yesu ndo na amuyirr ba gru nga na ku. Na ni kukri na abi ka iko ka nggo a so, na tu ba rri ko na ku nu umi iko ku da abangga kri yo ma na ábì. ");
INSERT INTO ninNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Akpa anishirr wa nggo rri so na ku, a da ku di, “Ayirr muwa ndo na amuyirr muwa so yo uwa na ábì.” ");
INSERT INTO ninNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu zhi ba di, “Unggonggo sa ayirr mungga na abata ngga sa amuyirr mungga ba?” ");
INSERT INTO ninNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yesu kakye anishirr ba nggo so ka ma yo na atsutsu, na tsarr ba di, “Kye yi abangga ba yo sa ana ayirr na amuyirr mungga ba! ");
INSERT INTO ninNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Undurr wa nggo ti na inkindirr yi nggo Abachi mungga da di a bu na yi, uwa yo a su uzayirr nu uvayirr na ayirr mungga wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu gru ko ku so tsarr anishirr ba zizo nu unddu inyi ku Galili. Nggo a ni ko tsarr ba, akpukpa anishirr ddu na nga na ku, uwa gru rri so nu uddu ku. Aba turr ku chi rri ntsɨ na amasirr wa. Anishirr ba wemi kri nu unddu inyi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Uwa tsarr ba aseki shishemi na assurre, na da ba ni itsarr ima yi di: ");
INSERT INTO ninNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wo yi! Uni do numa nggo huzzu ko ttu ingbingbiki. ");
INSERT INTO ninNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Na so hì, inuma yi ba kuhre na anko. Aminche ta yi ri. ");
INSERT INTO ninNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ingbingbi ikiri numa yi kuhre na abubo angbinta nggo imimi yi si ntsɨmi, ni zzu hanhan mi, nu nggo imimi su tsɨ mi. ");
INSERT INTO ninNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nu nggo azhi wa ssu na tu aywi wa. Nggo izhizhi yi imbarr yi iso fafami, i kru ni kɨ. ");
INSERT INTO ninNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ingbingbi ikiri numa yi kusurr ni intto, nu nggo i to nggo intto yi turr yi, i si hru ni na ingbingbi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ingbingbi ki numa yi kusurr nu ubobo imimi, ni zzu, ni furr korrmi, ni surr ingbingbi shishemi. Ibanu iso ititarr (30), ibanu iso ititani (60), ibanu ba ayiyirr yiyirr (100).” ");
INSERT INTO ninNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ni ikikre yi uwa da ba di, “Wo yi, uwanggo nggo ti se na atu ka iwo ure uwa bu wo.” ");
INSERT INTO ninNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nggo Yesu se na ankpa ma, abanu nggo a kri na so wo ma, a nga na ku ndo na awurr na aha ba, di a bu da ku aba inkpi i assurre yi. ");
INSERT INTO ninNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu a da ba di, “Abachi tsarr imba yo anazhi ba ittu i ima yi. Abanu ba nggo a zhi na ábì, a so wo su assurre mu, ");
INSERT INTO ninNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","da, “ ‘Aba ta kye, na kye, na si ta hi zizi hen. Na ta shirr atu, na shirr atu, na si ta vu inkpi inkindirr gri hen. A ti hi na wo, aba taka ko na Abachi ku, uwa ta nggurr ila ure imbarr yi zhi ba!’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yesu zhi ba di, “Imba di imba si hi inkpi i assurre wanggo wa hen? Imba ta na kingginggi ni ka hi inkpi i assurre numa? ");
INSERT INTO ninNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ingbingbi ikiri nggo uni ttu wa ku ttu yi nggo, iyo su ure ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Anishirr banu a si nâ ta su ingbingbi ikiri yi nggo i kuhre na anko. Nu nggo a wo ure ku, Isheta ka ku kpa ku glo na ba. ");
INSERT INTO ninNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Anishirr banu a se nâ si ingbingbi ikiri nggo kusurr na ahan. A ti wo ure ku Abachi ku, aba kpa na ango aha na nyarr. ");
INSERT INTO ninNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ure ku sa ni injinja ni isisurr imbarr yi, nu nggo iha ti ki ka a ti karr ba ni itu yi ure ku Abachi ku, aba di ba ta yo hanhan mi. ");
INSERT INTO ninNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Abanu ba zizo a se nâ si ingbingbi ikiri yi nggo kuhre ni intto, abama wo ure ku Abachi ku, ");
INSERT INTO ninNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amarr ambarr ka se kakami ni zha aseki ka ingbingbru ka mu, ni izha ashiki, na ba ingbingbru ni itu, di yi rri ba ni isisurr ni turr ure ku Abachi ku huzzu, aba si surr ingbingbi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Abanu ba ngga si nâ ta si ingbingbi ikiri yi nggo kuhre nu ubobo imimi. Aba yo wo ure ku na kpa ku gri, na surr ingbingbi - abanu ba iso titarr (30), abanu ba iso ititani (60), abanu ayiyirr yiyirr (100).” ");
INSERT INTO ninNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu kuchi ni bre ba are ka di, “Imba ka hi undurr unggonggo ka yo uru ni ingba nu uru na ba agbugba ttu ma, ka na ba ma yo na aza ka agudu? Na si ba ma sa na adida du ma la kago ni iko yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Inkindirr yi nggo a ti na yi sharri a ta gri yi huzzu nga na ábì. Inkindirr yi nggo a ta ttu yi zu aba ta bwu yi zu ndende. ");
INSERT INTO ninNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Undurr wa nggo ta se na atu ka wo ure, uwama wo!” ");
INSERT INTO ninNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Imba shirr atu yi. Agbugba wa nggo imba di tsarr ku abanu na wa, Abachi taka ni tsarr ssu ki imba pwi na wa na kuhre awuwa. ");
INSERT INTO ninNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Undurr wanggo nggo ta se ni inkindirr kakami, aba ta tsu surr ku. Uwanggo nggo se na yi ntsɨmi aba ta kpa ivi ntsɨ ima yi nu unuma.” ");
INSERT INTO ninNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu kuchi ni bre ba are ka zizo di, “Ittu i Abachi yi i zzu nâ ta su unushirr nggo hi ibibi ikiri ni ila ima. ");
INSERT INTO ninNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Na azhi ni ibittu uwa si hi nggo ikiri na ni so furr hen. ");
INSERT INTO ninNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Imimi iyo du ikiri zzu ni so furr ni hurr ni surr ingbingbi. Ni ime̱me̱, ikiri di kri ahwi, ni na atakpu, ni hurr ane, ni hurr, ni surr ingbingbi. ");
INSERT INTO ninNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nu nggo uga ku ti nggarr, ikiri yi i ki iwri wri ba, atakye wa ta ku han yi a ssu zu.” ");
INSERT INTO ninNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesu à ddu ba di, “Inta ta da di ittu i Abachi yi i si kingginggi? Inta ka tsarr yi kye na assurre atanggo a ta ma? ");
INSERT INTO ninNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ittu yi Abachi yi zzu nâ ta si ingbingbi unkunkurr numa nggi a yo yi du mosita, iyo si ivintsɨ nu umi ki ingbingbi inkinkurr yi ingbingbru yi nggo a di ttu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Uwa di zzu na furr ki unkunkurr unkpi mri inkpu inkinkurr yi. Nu di na inggingga shishemi aminu ni di so na na ako ni issu ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu di da ba are ama ka na assurre mu, na so di na undu na anko ka nggo a ta vu gri. ");
INSERT INTO ninNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ttuttumi uwa di tsarr anishirr na assurre. Nggo uwa ti ka ki na anga yirr, uwa vu ku bre hre ku abiga ma ba. ");
INSERT INTO ninNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ni ingbahru yi azhibarr ama wa, Yesu da ku abiga ma ba di, “Di inta kucha kuma nu ugugarr inyi numa ku.” ");
INSERT INTO ninNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Abiga ma ba du anishirr ba, na rri ni Yesu ku nu uddu ku na gru ko kuma. Nggo iddu numa mi se nu umi ki inyi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nu nggo a ni se nu umi inyi ku, unddunddu go kakami, nu vu amasirr ki ywhiywhirr ssu nu uddu ku. ");
INSERT INTO ninNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu so kurr ina nu ugo ku uddu ku, na sa itu ima yi na angbanja iki. Abiga ma ba si ma, na da ku di, “Unitsarr, i si ta vri ku uwa hen nggo inta ti kɨ ziza?” ");
INSERT INTO ninNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu kasi na gru kri, na nggarr ito nu unddunddu ku di, “Ba ttungo!” Na ddu amasirr wa di, “Kukri!” Unddunddu ku kukri, inyi wa ji kurr ywi. ");
INSERT INTO ninNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Yesu kasarr na zhi ba di, “Imba kru isisu ngginggi kakami meme? Zizami, imba nise kpanye ni ingga ku ni isisurr imba yi?” ");
INSERT INTO ninNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Isisu i ki ba kakami, aba gru so zhi ikpa di, “Uwanggo su unggonggo, nu nggo unddunddu na amasirr mi a wo ma?” ");
INSERT INTO ninNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu na abiga ama ba, a cha kako nu ugugarr inyi numa ku, na anga ka nu Gerrasa. ");
INSERT INTO ninNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nggo Yesu ti ta ko ji nu uddu ku, na kuma nu ugo numa nggo se ni izhi ndanda, na kru na nga na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ugo wa se ni izhi ndanda na di so na abe. Undurr sama nggo ka vu ma zu na lo ma na achiche. ");
INSERT INTO ninNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ankpa shishemi a di lo ma aza na ango ttuttumi, uwa di tsɨ ache ka hre na mɨ ankpu inklo hre na aza ka. A su ukyekye ku nggo undurr ka si vu ma zu hen. ");
INSERT INTO ninNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Na azhi ni ibittu uwa di so zirr na abe ka na agbre ka, na so di hantu na di nggarr ukpa umaku na angbinta ka. ");
INSERT INTO ninNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","A kri gbagbamu na hi Yesu, na kru nga ni jaku ku na agbuzzu ni imimi, ");
INSERT INTO ninNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","na nggarr iyi hantu di, “Yesu, Uvuvurr a Abachi Unkpi Kakami wa, ùwà zha angginggi ni ingga ku? Ingga barr ùwà ni isa i Abachi si tsutsarr ingga hen!” ");
INSERT INTO ninNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A da meme nu nggo, Yesu nggarr ito, ni izhi ndanda yi ku di, “Izhi ndanda huzzu nu ugo nggo ku!” ");
INSERT INTO ninNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu zhi ma di, “Isa muwa yi i ri unggonggo?” Uwa da ku di, “Isa mungga yi i rri ‘Akpa.’ Inta kri shishemi.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Izhi yi gri ibarr di a bu si han aba huzzu ko ta anko hen. ");
INSERT INTO ninNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Na ko na meme anikpama ba kri ri gagami na ba, nu unddu igbre ku nabo. ");
INSERT INTO ninNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Anazhi ba barr Yesu di, “Turr inta ko na anikpama ba di inta ku rri so na aba.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesu kpanye ba. Izhi ndanda yi i huzzu ku rri ku anikpama ba. Akpa anikpama ba ama ukrɨ uha (2,000) mu na kru ji na agbugbo ka ku kusurr ni inyi wa, na so amasirr wa na kɨ. ");
INSERT INTO ninNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Abi ho anikpama ba kru ko nu umi igbu tuku izzuzzu, ku bre ku anishirr ure kuma. Anishirr ba huzzu shishemi ta ku kye inkindirr yi nggo i la. ");
INSERT INTO ninNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Anishirr bi na nga ni Yesu ku, na ku hi ugo wa nggo izhi ndanda yi i rri so ku nu ukpa nggo. Uwa so na amarr ama ka kanga ku zizi, na so surr angbanja iki. Isisu ki ba na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Abangga ba nggo ku hi inkindirr ima yi ko ku so da ku anishirr inkindirr inggi nggo la nu ugo ni izhi ndanda wa, ni inkindirr yi nggo la na anikpama ba ba. ");
INSERT INTO ninNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Anishirr ba gru so barr Yesu di a bu du anga ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu ti ta ko rri nu uddu ku, ugo wa nggo a han ku izhi ndanda yi huzzu, à barr ma du uwa ta ga ma. ");
INSERT INTO ninNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu kisa na ddu ma di, “Kuma ni iko na anishirr muwa ba, ku da ba inkindirr inggi nggo Abachi na ku uwa, ni itito yi inggi nggo Abachi se na yi ni itu muwa nggo.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ugo wa kuma, na ku di zirr kago, na ku di bre ba ure ku na anga ka nggo a yo ka di Dekapoli, nggo si di “Igbu iwurr.” Anishirr ba namri wo na so vu angu yo gri. ");
INSERT INTO ninNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nggo Yesu cha ko nu ugugarr inyi numa ku nggo a zhi. Nu ugugarr kuma, akpa anishirr bi na nga na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ugo numa nggo a yo ma du Jarru, uyirr nu umi ku ankpinkpye ba nu uki ki issubi ku, a ku nggurr surr, na sa ashishi ni Yesu ku, na jaku ku na aza. ");
INSERT INTO ninNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Na barr ma lolo, “Uva mungga nggo ta ko ttu. Ga mi ni ku sa ungo muwa ku na ku, du ma wre na so ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu gru ga ma. Akpa anishirr ko ga Yesu na harr ma hi harr na anga ka aha mi. ");
INSERT INTO ninNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ayamba numa nggo se nabo, nggo di ji ayiyi kakami ki ase awurr na aha (12). ");
INSERT INTO ninNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nggo abi fu shishemi a ka fu ma chankarr ba. Uwa ka vu iki ima yi re nu ba tsatsarr ba, hi du uwa ta wre mu, inkindirr yi so kaki ndanda mu, ttuttumi. ");
INSERT INTO ninNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Uwa wo ure ni itu i Yesu na sha aza nga na anishirr ba nu ugo ki Yesu, na sa ungo na ankru ka Yesu ka. ");
INSERT INTO ninNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Na ta amarr ni isisurr ima di, “Ingga ti sa ungo na ankru ama ka, ingga ta wre.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","A ti ki ungo ku sa na ankru ka, ayiyi wa kukri keke. Uwa hi nu ukpa umaku du uwa wre ni ivri ima yi ba. ");
INSERT INTO ninNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Keke Yesu hi du ukyekye ki ifu umaku u sha huzzu na ku. Uwa ka kye anishirr ba, na zhi ba di, “Unggonggo sa ungo na a ankru mungga ka?” ");
INSERT INTO ninNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Abiga ama ba ddu ma di, “Uwa hi nu nggo anishirr ttu uwa, ni ka zhi anggi mu, du unggonggo sa ungo ni ingga ku?” ");
INSERT INTO ninNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu so kye kago du uwa ta hi undurr uwanggo nggo a sa ungo na ankru ka. ");
INSERT INTO ninNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ayamba wa hi inkindirr inggi nggo ila ku, na gru huzzu, ni ku ayisurr ni isisu, ni kuttu ku na aza, na da ku inkindirr yi nggo ila na ku tsatsarr. ");
INSERT INTO ninNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yesu ddu ma di, “Uva mu iyo isisurr muwa inggi ni ingga ku du uwa wre. Kuma ni isisurr muwa iyirr, uwa wre ni ivri muwa yi ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nggo Yesu ni ko re na ku, abitu zhi ni iko i Jarru, ankpye nu uki ki issubi ku, a nga ni da ku di, “Uva mi wa a ka ttu ba, si so tsutsarr unitsarr wanggo gbami hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu wo, na si kpanye ba hen, na ddu ugo wa di, “Si di isisu ki uwa hen, yo isisurr muwa yi ni ingga ku mre.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu si kpanye na du akpa anishirr ga ma zizo hen, na du anu Biturr, ni Yakubu, nu Yohana uwa uzayirr Yakubu. ");
INSERT INTO ninNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","A ti ko rri ni iko i Jarru, Yesu hi anishirr ba ni so kadada, na so yi na ba azhittu hantu. ");
INSERT INTO ninNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu mirri ko ku zhi ba di, “ikada imba yi i si i angginggi? Imba so yi angginggi? Uva wa si ttu hen, a so kurr si ina mu.” ");
INSERT INTO ninNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aba gru so sarr ma. Uwa han ba huzzu, na yo aki wa tuku ayirr a uva ni ttu wa, na abiga ma ba atarr mi, na rri ko nu uki ku nggo uva wa kurr. ");
INSERT INTO ninNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yesu vu uva wa nu ungo na ddu ma di, “Talita, kumi!” (nggo si di, “Uva, ingga du uwa bi gru!”) ");
INSERT INTO ninNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Uva wa nggo, a se na ase awurr na aha (12), tudo gru kri na zirr kago nu umi ku uki ku. Anishirr ba nggo a rri kri ni Yesu ku, a hi inkindirr yi nggo ila, na kye na vu angu gri. ");
INSERT INTO ninNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yesu gba ba utu da bi si bre ku anishirr hen, na da ba da bi nu ma ila ri. ");
INSERT INTO ninNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu na abiga ama ba a gru na anga kama, na kakuma nu Nazareti, ako ambarr ka, nggo à furr. ");
INSERT INTO ninNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na Azhibarr a Isu anu Yahuda wa, uwa gru ku so tsarr ba nu uki ki issubi ku. Akpa anishirr nggo wo ma na so vu angu yo mre, na so zhi di kye bari, “Ugo nggo wa kpa aseki kama nu momonggo? Unggonggo nu ma ihi ima yi, na du ma so na iki yi ikagri ma mi? ");
INSERT INTO ninNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","A si su unitarr wanggo yo hen, uvuvurr a Maryamu wa? A si su uzayirr a Yakubu, Isuhu, nu Yahuda tuku Sima hen? A si sa amuyirr ama ba yo so ni inta ba ni igbu wanggo hen?” Aba vri isisu na ku kakami, na ka iwo ma. ");
INSERT INTO ninNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu ddu ba di, “A di kye uni kpa are a Abachi ssu nu ungo na ábì. Na di ka iwo uni kpa are a Abachi ni igbu ama, amuyirr na amla ma, ni iko imbarr.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu si na inkindirr ikagri nabo hen, nggo a sa ungo yo na anishirr abi vri abanu ba ntsɨ, aba wre. ");
INSERT INTO ninNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ayisurr ku ba, ni ika iyo isisurr imbarr yi. Yesu huzzu ko ku so tsarr ba ni igbu igaga yi nabo. ");
INSERT INTO ninNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Yesu a yo awurr na aha ba zu, na so tu ba na ahaha, na nu ba ukyekye ki han izhi ndanda huzzu. ");
INSERT INTO ninNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yesu nggurr ba di a bu gri unflankurr ki ka ungo yo, na si gri ila, na ambu, na bi si gri azo na ambu ka inkinkru imbarr yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yesu da ba di a bu surr anggakpaza na si gri inkinkru ki iha hen. ");
INSERT INTO ninNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iko yi nggo imba ta rri, imba ta so nabo yo ma na azhibarr wa nggo imba ta ka du igbu wa. ");
INSERT INTO ninNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Imba ta ko ni igbu wa nggo a si kpa imba hen, na si ta wo ure ki imba ku hen, imba bi hɨ ihurr yi na anggakpaza ka imba ka surr ba ni kuma, ni du uwama su ba ure ki ikye. ");
INSERT INTO ninNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Aba huzzu ko ku so bre ku anishirr ure ku Abachi ku da abi du ila ure imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na han izhi ndanda huzzu shishemi, na ka anye surr ku abi vri ba ni itu, na du ba a wre. ");
INSERT INTO ninNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nggo uttu Hirridu wo aseki ka nggo Yesu so na ka. Nu nggo anishirr ba hi isa i Yesu kago ni ingbingbru yi we. Abanu so da di, “Yohana uni zzu anishirr wa yo tasi, ima yo du ma se nu ukyekye ki na iki ikagri yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Abanu kye da si Iliya uni kpa are Abachi wa. Abanu da, “A si uni kpa are Abachi numa nu umi ku abi kpa are ba Abachi abi ngbangba ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nu nggo, uttu Hirridu wo ure ku ma na da di, “Yohana wanggo nggo ingga ttu ku itu nggo, uwa yo tasi.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Uwa bumbri Hirridu wama yo du abi lo ukpa ba vu Yohana ku harr ku nu uki, na di Hirridiya, ayamba ama bu nyarr. Hirridiya, ayamba a uzayirr ungbangba Filibu nggo ni ko so tsitsirr Hirridu ku kpa ku ayamba ama wa. ");
INSERT INTO ninNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yohana ku ddu Hirridu di, “A si ila ure ùwà bi kpa ayamba a uzumbirr ki ayamba muwa!” ");
INSERT INTO ninNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hirridiya, gri Yohana ni isisurr na so zha anko a ingu ma, na si hi anko wa mu hen, nggo Hirridu si kpanye hen. ");
INSERT INTO ninNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hirridu kye Yohana ssu nu ungo kakami. Nggo a hi da a su unushirr uzizi a Abachi nggo Izhi Iwre i Abachi iso ku nu ukpa, na du ba gri ko ku ttu to mi. A di zharr iwo ma ttuttumi. Ivri ima yi su nu nggo a ta wo ma i isisurr ima yi di vri kakami. ");
INSERT INTO ninNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ni ikikre yi, Hirridiya hi anko wa nggo a di zha wa, na azhibarr a ingri a uttu Hirridu wa. Nggo a na iga, ankpinkpye ba bi so na ku, na ankpinkpye bi ta iku ba, na ankpinkpye anishirr nu Galili. ");
INSERT INTO ninNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nu nggo, uva a Hirridiya wa a rri na atsutsu ka anishirr na rro. Irro ima yi su ku uttu Hirridu ni ikpikpa ima yi isisurr. Uttu wa ddu uva wa di, “Da ki ingga inkindirr yi nggo uwa zha yi, ingga ta nu uwa na yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na da na shi azhi di, “Da ki ingga inkindirr yi nggo ùwà zha yi, ingga ta nu ùwà na yi, ka ingga ti ta nggarr ittu mungga yi mi narrnarr, ni nu ùwà anga yirr wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Uva wa kru huzzu ko ku zhi ayirr wa, “Ingga bi barr ma angginggi?” Ayirr wa da ku di, “Itu i Yohana uni zzu anishirr na amasirr.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kakayirr, uva wa kru kako nu uttu wa ku ni ibarr ima yi, “Zizami, ingga zha du ùwà bu ni ingga itu i Yohana uni zzu na amasirr yi na agbugba.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ure kuma di isisurr i uttu yi i vri kakami. Uwa su nu nggo à ka shi azhi na anke̱ ka ikpikpa ima yi ba, na si kpanye na re ure hen. ");
INSERT INTO ninNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mre ankpa yirr uttu wa tu uni ta iku numa wa nu ure di a bu ku gri ku uwa itu i Yohana. Ugo wa kuma, na ku sarr itu i Yohana yi nu uki ki harr ku, ");
INSERT INTO ninNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","na gri itu yi na nga na agbugba wa, ni ka nu uva wa. Uva wa kpa yi ga ku ayirr wa. ");
INSERT INTO ninNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nu nggo, abiga bu Yohana ba wo ure kuma na ni ba iku yi ku zzu. ");
INSERT INTO ninNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nu nggo, abi ko na angu abu Yesu ba akanga zhi ni itu yi, na ni harr Yesu yo na atsutsu na so bre ku, inkindirr yi nggo aba ku na, ni itsarr yi nggo aba ku tsarr. ");
INSERT INTO ninNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Anishirr shishemi abi na so ko ni Yesu ku, abanu so kakuma, na du Yesu na abiga ma ba a si hi anko i ri inkindirr hen. Uwa Yesu ka ddu ba di, “Di inta huzzu ko nu unto ku nggo inta ta ku so, ni di inta ku ttu unddunddu.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Meme, aba gru rri nu uddu ku, na so ko nu unto ku nggo u su ywiywimi. ");
INSERT INTO ninNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Akpukpa anishirr nggo hi ba ni so kuma yi, na hi da sa aba yo, na gru zhi ni igbu yi nu kukru ku gye ba ichi nu unto ku nggo a so kuma wa. ");
INSERT INTO ninNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nggo Yesu ta ji na hi akpa anishirr wa, itito ki ma na ba. Ima yo di, a na zzu aminta ba nggo sama nu uni ka ba. Mre na gru so tsarr ba aseki shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nu nggo, azhi wa so ku, abiga ma ba da ku di, “Azhi wa so ku, inta kri nu unto ku nggo ako sama. ");
INSERT INTO ninNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Du anishirr ba kuma ni izzuzzu igaga, ni igbu igaga yi ku re inkindirr i ri na ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu da ba di, “Imba nu ba inkindirr iri.” Aba da ku di, “E-e! Ila inggi nggo inta ta nu anishirr angga ba, ka si inklo mu shishemi, nggo i ka han unushirr uda ki ihwa itandarr?” ");
INSERT INTO ninNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yesu zhi ba zizo, “Imba se na ankpinkpri unfonfo abirr? Ku klo kye.” Nu nggo a ku kye ka na ni da ku di, “Ankpinkpri unfonfo akywi ni ikikla iha.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Yesu da ku abiga ma ba, di a bu du anishirr ba ga so na ankla na ankla na agiga assussu ka. ");
INSERT INTO ninNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Anishirr ba wo na ga so na ankla ka, abanu ayiyirr yiyirr abanu iso ikywi kywi. ");
INSERT INTO ninNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesu kpa ankpinkpri unfonfo akywi ka ni ikikla iha yi, na kye hun ko nu unkplassu, na nyarr ku Abachi. Na mɨ ankpinkpri ka nu abiga ma ba, di a bu kpa ga ku anishirr ba, na ga ba ikikla yi kye ma. ");
INSERT INTO ninNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Anishirr ba ri shi na ka du. ");
INSERT INTO ninNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Abiga ma ba vu imbimbru ankpinkpri unfonfo yi ni ikikla yi ki isisa iwurr ni iha. ");
INSERT INTO ninNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Aniru ba nggo a se ni iri ima yi, a su ukrɨ ukywi (5,000). ");
INSERT INTO ninNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ankpu yirr, Yesu da ku abiga ma di a bu rri nu uddu ku, na bi kuchi ko nu ugugarr inyi numa ku nu Betsada. Yesu di inkpu anishirr yi kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nu nggo a yo ba na anko na hun ko ku ibarr ni igbre wa. ");
INSERT INTO ninNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ni ingbahru nggo, abiga ma ba nu uddu ku a ka ku rri na atsutsu inyi ka ba, Yesu ni kri ni imimi na ankpa ma. ");
INSERT INTO ninNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","A kri ni igbre wa na so hi abiga ma ba ni so darr uddu ku chankarr, nggo unddunddu ku nga na ba narrnarr nu so turr ba ka ko nu ugo. Uwa si ni gambre nggo agba a ime̱me̱ wa a tu ba, uwa gru so kuma na ba na so zirr na atu ka amasirr ka, na ta ko nggarr ba. ");
INSERT INTO ninNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nggo aba hi ma ni so zirr na atu ka amasirr ka, na kye da su uzhi mu, na hantu. ");
INSERT INTO ninNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Aba wemi hi ma na ki isisu. Yesu re na ba di, “Imba vu isisurr, si kru isisu hen. A si ingga.” ");
INSERT INTO ninNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Na rri na ba nu uddu ku. Unddunddu ku kukri ywi. Abiga ma ba ku ayisurr. ");
INSERT INTO ninNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nggo a si hi inkpi yi unfonfo wa nggo nu anishirr ba du ba ri hen, inkindirr ima yi i ji ba ukpa. Ni du aba si kye ure umaku hi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nu nggo, a cha inyi wa kre, na rri nu Genesareti, na ka uddu ku hirr nabo. ");
INSERT INTO ninNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nu nggo, a huzzu nu uddu ku, anishirr ba kye Yesu hi keke. ");
INSERT INTO ninNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Na kru kago na anga kama ka, ku di gri abi vri ba nu utakpa na nga na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Unto ku nggo Yesu ti kuma, ni igbu itsitsa yi, ni inkpinkpi yi, tuku ni izzuzzu yi, anishirr di vu abi vri ba na ko nu udu, na ku di barr ma di a bu du ba sa ungo nu utu ankru umaku. Abangga ba nggo ti sa ungo na ka, aba di wre. ");
INSERT INTO ninNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ni ivi numa, nggo a na iga i, anu Farrisi ba a nga ndo na abanu abitsarr na Are ka bi iga ka, a nga zhi nu Urushalima, na nga ni ssubi nu Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nggo na hi abiga ma ba, a so ri ila na ankizhi ka mi. Na si ngla ango ka hen, nâ ta su nggo anu Yahuda ba di na. ");
INSERT INTO ninNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Anu Yahuda ba, na anu Farrisi ba wemi, a si di ri ila sama ni ngla ango hen. A di ga iba i atiti imbarr yi kakami. ");
INSERT INTO ninNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A si di ri ila nggo a ti nga zhi nu udu hen, nggo a ti nga zhi nu udu aba ta ni mɨ amasirr nu ukpa. Na di ga iba yi ngla ango yi ni i ngla igbigba yi, ni itsa, na ampirri, na aseki atsitsa ka). ");
INSERT INTO ninNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ni ima yo, anu Farrisi ba na abitsarr Are ba a zhi Yesu di, “Angginggi da abiga muwa ba a si ga iba i atiti yi hen? Na di ri ila na ankizhi, sa ni ngla ango.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesu ddu ba di, “Inkindirr yi nggo Ishaya a da na atu a imba si jiji, imba sa anishirr abi na aseki wre ku anishirr a bu hi ba! Nggo a charr da di, “ ‘Anishirr angga ba a ga ingga na angu gigyemi, isisurr ambarr yi i ta anko ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","A so ga ingga gigyemi, itsarr imbarr yi sa are ka anishirr, na si su ure ku Abachi hen.’ ");
INSERT INTO ninNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Imba ka Are ka Abachi ka, zu na anga yirr, ni ga iba i anishirr.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu a ddu ba di, “Imba se na anko zizi ka ka Are ka Abachi ka wre ki imba bu ga iba imba yi. ");
INSERT INTO ninNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nggo Musa a charr da di, ‘Uwa bu kru isisu i aki tuku ayirr muwa. Undurr a ti da inkindirr indanda ni itu ati ama wa, ka ayirr ama, aba bi ngu ma.’ ");
INSERT INTO ninNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Imba di tsarr du, undurr numa ti se ni inkindirr yi nggo à ta zi ati tuku ayirr, na da di, ‘Ashi! Inkini inggi yi su Kobani’ (i si i Abachi mu.) ");
INSERT INTO ninNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ida ima yi, i tsarr du ùwà si ta zi ati tuku ayirr muwa hen. ");
INSERT INTO ninNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Imba so di tsarr amumarr amba ba iba imba yi, ni nggurr ugo yo ure ku Abachi ku. A si si ima yo na ankpa ma hen, aseki banu se nggo imba so di na ka meme.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu yo anishirr ba zizo, na da ba di, “Imba bi shirr ki ingga atu wemi yi, ni bi hi. ");
INSERT INTO ninNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Inkindirr sama nggo ka rri nu umi ine ku unushirr ni na ma ki ndanda. Inkini nggo di huzzu ni isisurr i unushirr, ima yo di na unushirr ki ndanda na Abachi ku.  ");
INSERT INTO ninNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wo yi, undurr wa nggo a se na utu ka iwo, uwa bu wo.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nggo Yesu a du akpa anishirr wa, na gru ni i ssubi yi, na rri ko ni iko, abiga ma ba ko ku zhi ma, inkpi i assurre wa nggo a da ba na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Uwa a zhi ba di, “Imba mi si hi ankpi yi abanu ka hen? Imba mi si kye hi meme hen? Inkini sama nggo ka mirri ku unushirr ni ine ni na ma ki ndanda na Abachi? ");
INSERT INTO ninNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Inkini ima yi si rri ko ku ni isisurr hen, irri ko ku si ni ine mu, a si meme yo nggo a ta ja yi huzzu.” (Are ka nggo Yesu a da ba, a tsarr ba di ikiri i si zizi pempe). ");
INSERT INTO ninNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu da ba di, “Inkini inggi nggo di huzzu zhi ni isisurr i unushirr, ima yo di na unushirr ki ndanda na Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Zhi nu umi ki isisurr i unushirr amarr ndanda a di huzzu, na ka ma ki umimi, uni zha amba tuku uni zha aniru, unayi, nu uni ngɨ anishirr, ");
INSERT INTO ninNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ni ittu ashishi, ni na awurr, ni imu, ni izharr inkindirr, ni issu, amparr, gɨ itu, urrurru. ");
INSERT INTO ninNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Aseki ndanda angga ka wemi, a di huzzu zhi nu umi ki isisurr i unushirr, na di na ma ki ndanda na Abachi ku.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu gru nu Galili, na kuma ywhiywhirr ni igbu nu Taya tuku Sido. Na ko ku rri ko ni iko numa, di a bu si hi uwa hen, na si hi unto ki isharri hen. ");
INSERT INTO ninNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ayamba numa nggo, uva uvutsa ama a se ni izhi ndanda, uwa wo inkindirr yi nggo Yesu so na, na gru horr mi nga na ku, na ni jaku ku na aza. ");
INSERT INTO ninNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ayamba wa a su anu Girrki. A su unichirr mu, na si su anu Yahuda hen. A ngri ma nu Fonisiya nggo su na anga ka Sirriya. A nga ni barr Yesu da bi ku han izhi ndanda yi glo ku uva ma wa. ");
INSERT INTO ninNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yesu a ddu ayamba wa di, “Du amumarr ba a ri kuchi. I si ta wre a bi ba ila yi amumarr yi ta yo ku amiyo hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ayamba wa a kpanye di, “E-e, Akikye, ka amiyo ba nggo di kurr na aza ki imburr ka a di ri imbimbru ila amumarr yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yesu da ku di, “Nu ure muwa ku, kakuma ni iko, izhi ndanda yi i huzzu ku uva mi wa ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ayamba wa a huzzu kakuma ni iko, na ko ku hi uva ma wa kurr na abubo ikurr wa. Izhi ndanda yi i ka huzzu ku jiji ba. ");
INSERT INTO ninNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu a gru na du anga ka Taya ka, na zzu ba nu Sido, na rri ba na anga ka igbu yi nggo a yo yi di Dekapoli (Igbu Iwurr), na rri ni inyi nu Galili wa. ");
INSERT INTO ninNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Anishirr abanu a gri agbatu nga na ku, nggo a si di re zizi hen. Na ku barr Yesu di a bu ki ungo sa na ku na du ma a wre. ");
INSERT INTO ninNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu à gri ma na kako na anga yirr, na ki imimarr ungo ima yi surr ku na atu ka, na sarr antinte, na ki ungo sa ku ni irrirri yi. ");
INSERT INTO ninNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Na gɨ ashishi kye unkplassu, na ttu unddunddu, na re ngbungbru, na da di, “Efata!” (di, “Bwu!”). ");
INSERT INTO ninNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Keke, atu ka a bwu ku. Inkini nggo di lo ku irrirri yi gbuddu. Uwa a wo ure na re wre. ");
INSERT INTO ninNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu a gba ba atu, da bi si da ku undurr inkindirr yi nggo uwa na yi hen. Igba atu ima yi du ba so da ku anishirr ba kakami. ");
INSERT INTO ninNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Anishirr so wo na vu angu gri, na da di, “A na aseki ka wemi zizi. A da aba agbatu ba wo, abi nganta a re wre!” ");
INSERT INTO ninNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ni ivi ima, anishirr nggurr bi shishemi. Nu nggo aba sama ni inkindirr iri. Yesu a yo abiga ma, na da ba di, ");
INSERT INTO ninNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Itito ki ingga na anishirr angga ba. Utarr ambarr nggo ari ni ingga ku, ziza a sa ni inkindirr iri. ");
INSERT INTO ninNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ingga ti du ba kakuma ni iko ni inga aza mi, aba ta zzu tsi na anko kye, abanu ba a zhi nu ugbagba mu.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Abiga ma ba, a zhi ma di, “Nu momonggo, inta ta hi inkindirr iri ni ka nu anishirr angga ba na ankpuji nggo?” ");
INSERT INTO ninNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu zhi ba di, “Imba se na ankpinkpri unfonfo abirr ngga?” Aba da, “Atangba.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yesu ddu anishirr ba da bi kuso ni imimi. Na ba ankpinkpri unfonfo ka atangba mi, na nyarr ku Abachi, na tsɨ ka ki atsitsa ga abiga ma ba, aba kpa ga ku anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aba se ni imu ikikla tsɨ. Uwa ba yi na nyarr ku Abachi, na du abiga ma ba vu yi ga ba meme. ");
INSERT INTO ninNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Aba ri na shi. Aba vu imbimbru yi ssu ni isisa itangba. ");
INSERT INTO ninNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Anishirr ba, a su ukrɨ ne̱, uwa du ba kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Keke na a rri nu uddu ku ndo na abiga ma ba na ko na anga ka nggo a yo ka du Damanuta. ");
INSERT INTO ninNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Anu Farrisi banu ba a nga ni so ri anta ni Yesu ku, da aba ta tsarr ma kye, da Abachi kpanye na ku. Ni ima yo, aba da ku Yesu di, “Na inkindirr ikagri numa nggo i zhi nu unkplassu, ni di inta kye.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu ta inchorr ni isisurr kakami na da di, “A sa angginggi anishirr bu mi ba a zha ihi inkindirr na ashishi? Ingga da ki imba, inkindirr sama nggo a ta tsarr imba anishirr bu mi ba!” ");
INSERT INTO ninNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nabo yo, uwa du ba na rri nu uddu ku na kucha ko nu ugugarr inyi numa ku. ");
INSERT INTO ninNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Abiga ma ba a kpamusu, na si gri unfonfo wa hen. Unfonfo wa nggo a gri su uyirr yo na ba nu uddu ku. ");
INSERT INTO ninNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu a gba ba utu di, “Imba kye yi. Imba ssubi ni kye iyisti anu Farrisi na iyisti ani Hirridu wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aba so zhi ikpambarr, “A su nggo inta si gri unfonfo wa yo hen?” ");
INSERT INTO ninNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu a hi inkindirr yi nggo a so are, na zhi ba di, “A sa angginggi di imba so re ni ikpa di imba sa nu unfonfo? Imba si so hi hen? Isisurr imba yi tsɨ ni ihi? ");
INSERT INTO ninNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Imba se na ashishi, ni si kye hi hen? Imba se na atu, ni si wo hen? Imba si ssu hi hen? ");
INSERT INTO ninNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nggo ingga tsɨ unfonfo ukywi wa ga ku anishirr ukrɨ ukywi (5,000) ba, imba i vu imbimbru yi ssu ni isisa ibirr nggi?” Aba ddu ma di, “Iwurr ni uha.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Nggo ingga tsɨ ankpinkpri unfonfo atangba ga ku anishirr ukrɨ une̱ (4,000) ba, imba i vu imbimbru yi ssu ni isisa inkpinkpi ibirr nggi?” Aba ddu ma di, “Itangba.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Yesu zhi ba di, “Ziza mi, imba nise kye hi?” ");
INSERT INTO ninNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nggo a rri nu Betsada, anishirr abanu gri unakreshishi na nga ni Yesu ku, na ni barr ma da bu ki ungo sa na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu a vu unakreshishi wa nu ungo, na gri ma huzzu ko nu umi igbu ku. Na ku ddu antinte surr ku na ashishi ka, na ka ango sa ku, na zhi ma di, “Uwa kye hi?” ");
INSERT INTO ninNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Unakreshishi wa à kpanye, na da di, “Ingga kye anishirr ba hi, aba zzu inkinkurr nggi so zirr.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu ka angu ama ka sa ku zizo na ashishi ka. Unakreshishi wa a surr ashishi girr, na kye hi zizi mi. ");
INSERT INTO ninNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu a du ma kakuma ni iko, na gba ku utu na da ku di, “Tsi kuma ni iko muwa, ni si kanga nu umi ki igbu ku zizo hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nggo Yesu na abiga ma ba, a gru rri kuma ni igbu yi na anga ka Kayisarriya Filipiya. Nggo a se na anko, uwa à zhi abiga ma di, “Anishirr ba da di ingga su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Aba ddu ma di, “Abanu da du uwa su Yohana uni zzu anishirr na amasirr, abanu du uwa su Iliya, abanu a da du uwa su uyirr nu umi ku abi kpa are bi kuchi ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Uwa zhi ba di, “Imba ku atu amba wa da di, ingga su unggonggo?” Biturr a da di, “Uwa yo su Kristi.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu a nggurr ba di, “Imba si da ku undurr inkindirr ni itu mungga hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Yesu gru so tsarr abiga ma ba di, “Ingga Uvuvurr a Unushirr a ta ki iha kakami. Ankpinkpye ba ta kà ingga. Ankpinkpye abikye, na abitsarr ni Iba yi, a ta kà ingga, na ta ngu ingga. Nu utarr wa, ingga ta tasi.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A da ba krizhizhimi. Nggo Biturr a gba ma ko na anga yirr, na ku so glo ma di angginggi du uwa da meme. ");
INSERT INTO ninNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nggo, Yesu kasarr na kye abiga ma ba, na nggarr ito ni Biturr ku di, “Chi huzzu ni ingga ku, uwa Umimi! Uwa si se na amarr ka Abachi hen, uwa se na amarr ka unushirr.” ");
INSERT INTO ninNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yesu yo anishirr ba na abiga ma ba, na da ba di, “Undurr nggo ta du uwa ta ga ingga, uwa bu ka itu ima. Na bu ba unkunkurr ki garr umaku na ga ingga. ");
INSERT INTO ninNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Undurr wanggo nggo ta du uwa ta so sese, uwa ta zha yi chankarr. Undurr wanggo nggo a ta ni ingga itu ima yi ni i kuchi i ure ku Abachi ku, uwa ta so sese. ");
INSERT INTO ninNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Angginggi su ku unushirr zizi nggo a ti gri inkpinkpye ingbingbru yi pempe na bi ttu? ");
INSERT INTO ninNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Unushirr sa ni inkindirr yi nggo ka ni na kpa itu ima ttungo. ");
INSERT INTO ninNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Unushirr wanggo à ti kru ishisha imungga nu ure ku nggo ingga da, na ase amimi a ka la ure angga ka, ingga Uvuvurr a Unushirr mi ta kru ishisha ima yi na anke̱ ka Abachi, nggo ingga ta kanga ni ila nzarrnzarr i Aki mungga yi ndo na abitu ba Abachi abi wre ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu kuchi ni bre ba di, “Ingga da ki imba ure ujiji, abanu nggo kri ni inggya, a si ta kɨ bari na ka hi ittu i Abachi yi ni nga kyekye mi hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nu nggo azhibarr utani wa i vu sarr, i Yesu yo Biturr tuku Yakubu, u Yohana du ba ga ma hun ko ni itu igbre unkpi wa, nu nggo a ko ku so na akpambarr. Nabo yo, Yesu ku kasarr na ashishi ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Angbanja iki ama ka la kaki a akikla pyarr nâ ta sa azzuzzu, nu nggo undurr ni ingbingbru inggi yi ka si ngla ssu meme hen. ");
INSERT INTO ninNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Abiga ma ba atarr mi a hi Iliya, uni kpa are a Abachi wa, tuku Musa, ni kri re ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Biturr re ni Yesu ku di, “Unitsarr, a si ki inta inkindirr iwre nggo inta se ni inggya. Di inta na aburr atarr ki imba. Iyirr ku uwa, iyirr ku Musa, iyirr ku Iliya.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Biturr si hi inkindirr i nggo ko da hen, nggo isisu ki ba kakami). ");
INSERT INTO ninNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Akpa ji zhi nu unkplassu ni ttu ba nado. Aba wo ukorr nu umi ku akpa ku di, “Uwanggo yo su Uzumu wa, nggo isisurr mungga yi i nyarr na ku kakami. Imba wo ma yi!” ");
INSERT INTO ninNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aba ka kye na si hi undurr na ku zizo hen. Yesu yo se na ankpa ma. ");
INSERT INTO ninNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nu nggo a ko ji igbre inkpi wa, Yesu gba ba utu di, “Imba si da ku undurr inkindirr yi nggo imba ku hi hen, di ingga Uvuvurr a Unushirr ka ttu ni ka tasi bari.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Aba vu ure umaku gri ni isisurr ambarr yi, na ka ko zhi ikpa di, “Sa angginggi si ittu ni itasi yi?” ");
INSERT INTO ninNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aba zhi Yesu di, “Angginggi du abitsarr are ba di da di Iliya nggo ta ka nga kuchi ku uni kpa inta ttungo wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu da ba di, “Iliya ka nga kuchi ba, ni ssu anko bi. Ungbamvu ku da di, Uvuvurr a Unushirr taka ni ki iha aba taka kà ma? ");
INSERT INTO ninNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Di ingga da ki imba, Iliya a ka nga ba. Anishirr ba a ni na ku inkindirr indanda nggo isisurr imbarr yi i kpanye ba, nâ ta su nggo ure ku Abachi ku u da ni itu ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nu nggo Yesu na abiga ma ba, atarr ba ji zhi ni igbre wa, na hi akpukpa anishirr nabo. Abitsarr are ba so ri anta na abiga ma banu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nggo anishirr ba hi Yesu, na ku ayisurr kakami, na kru ko na ku, na ku so chi ma. ");
INSERT INTO ninNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesu zhi abiga ma ba di, “Imba kri ri anta ka angginggi na ba?” ");
INSERT INTO ninNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ugo numa nu umi ku anishirr ba a da di, “Unitsarr, ingga gri ku uwa uvuvurr mungga nggo a se ni izhi ndanda nggo i du ma si di re hen. ");
INSERT INTO ninNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Izhi ndanda yi ti gru ku i di ba ma nggurr ni imimi, uwa ssu anfu na angu, na ta anyinyirr na tsɨ ki klakaka. Ingga da abiga muwa ba bi han izhi ndanda yi huzzu ku uvuvurr wa, aba han yi chankarr.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu ddu ba di, “Imba anishirr bi kà iyo isisurr! Imba kye ingga ta so ki ivi ibirr nggi ni imba ba? Ingga ta ttu angginggi vu isisurr ni imba ba? Gri uvuvurr wa ga ki ingga!” ");
INSERT INTO ninNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Aba gri ma ga ku Yesu. Nu nggo, izhi ndanda yi hi Yesu, ni ba uvuvurr wa gri ni nggurr ni imimi du ma tsɨ na ssu anfu na angu. ");
INSERT INTO ninNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu zhi aki a uvuvurr wa di, “A ki ase abirr ngga ni di tsɨ yi?” Aki wa da ku di, “Zhi ni tsitsa mu. ");
INSERT INTO ninNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Izhi yi di zha du uwa ta ngu ma, ni di ba ma tu nu uru, ni di ba ma yo na amasirr. Uwa ti se ni inkindirr ina, kye inta na ashishi ka itito, ni zi inta nggo uwa ti hi aza ka!” ");
INSERT INTO ninNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu da ku di, “Uwa da angginggi, di uwa ti hi aza ka? Unushirr wanggo nggo ti yo isisurr na Abachi ku, uwa di se nu ukyekye ki na aseki ka namri.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Aki a uvuvurr wa da hantu di, “Ingga kpanye, ni yo isisurr na Abachi ku, si su kakami hen. Zi ingga ni di yi su kakami.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nggo Yesu hi da anishirr ba so nga, na nggarr ito ni izhi ndanda yi ku di, “Izhi i agbatu tuku inganta, ingga han uwa huzzu nu umi umaku, si ka rri na ku zizo hen!” ");
INSERT INTO ninNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Izhi ndanda yi nggarr angu yi, ni ba ma nggurr kakami uwa kurr tsɨ. Izhi yi huzzu kuma. Uvuvurr wa kurr ni inkla yi ywi zzu da a ttu. Nu nggo anishirr ba da di, “A ttu!” ");
INSERT INTO ninNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yesu vu ma nu ungo na gɨ ma gru, uwa gru kri. ");
INSERT INTO ninNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nu nggo, Yesu mi rri ko nu umi ki iko ku, abiga ma ba ku so zhi ma sharri di, “Angginggi di inta han izhi ndanda yi huzzu lankarr?” ");
INSERT INTO ninNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesu ddu ba di, “Inkindirr sama nggo ka han izhi inggi yi huzzu, ibarr Abachi na ankpa ma nggo ita zi.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nggo Yesu na abiga ma ba du unto kuma, na sarr ko na anga ka Galili ka. Yesu si kpanye du undurr bu hi unto ku nggo uwa se hen. ");
INSERT INTO ninNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nu nggo a so tsarr abiga ma ba. Na ddu ba di, “A ta ba Ingga Uvuvurr a Unushirr nu anishirr, nggo ta tsi ingga ngu, unu utarr wa, ingga ta tasi.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Abiga ma ba kye ure ki itsarr umaku ssurr. Isisu ki ba ni zhi ma yi. ");
INSERT INTO ninNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Aba nga nu Kapanahu, nu nggo a rri ko nu umi uki, Yesu zhi abiga ma ba di, “Imba di ri anta ka angginggi ga anko?” ");
INSERT INTO ninNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ishisha ki ba ni ka sa ku. Nu nggo a ka so di narr inkpinkpye nggi na anko, na so zhi ikpa du unggonggo ta sa ankpye nu umi umbarr ku. ");
INSERT INTO ninNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu ji so, na yo awurr na aha ba, na da ba di, “Uwanggo nggo ta zha du uwanggo ta su ni me̱me̱, uwanggo bi su uni kre wa, na bu su ugarr amba namri.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Na ba inkparr uvuvurr numa na du yi gru kri na atsutsu ambarr ka. Na vu ma gri nu ungo, na da di, ");
INSERT INTO ninNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Uwanggo nggo ti kpa uyirr nu umi ku antsɨntsɨ abangga ba, ni isa mungga uwa kpa si ingga. Undurr wanggo nggo ti kpa ingga, uwa si kpa si ingga na nkpamu hen, a kpa Abachi nggo a tu ingga mi.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana ddu Yesu di, “Unitsarr, inta hi ugo numa nggo so han izhi ndanda huzzu ni isa muwa, inta da ku di a bu duma, da a si se nu umi munta ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu ddu ba di, “Si han ma yi hen. Undurr wanggo nggo ti na ikagri ni isa mungga, uwa yo ka si kasarr hanhan mi na da ure undanda ni itu mungga hen. ");
INSERT INTO ninNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Undurr wa nggo ta si ka inta hen, uwa sa amunta. ");
INSERT INTO ninNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ingga so da ki imba ure ujiji mu. Undurr wa nggo ta ni imba amasirr ni isa mungga, Abachi taka nu ma azadi ama ka na azhibarr a ikikre wa. ");
INSERT INTO ninNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Undurr wa nggo ati na na du uyirr nu mi ku atsitsa angga ba a ka ko nu ugo ni iga ingga yi, i wre ka lo ku unushirr uwama ununa ni ito na turr ma yo ni izzo amasirr. ");
INSERT INTO ninNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Meme nggo, ungo umuwa nggo ti ta du uwa sarr uza ni ga ingga yi, uwa gye ku ta yo. I ta wre ùwà bu rri ni iso sese nu ungo uyirr, nu uwa bi se na ango aha ni bi rri nu unto ki iha nu uru ki rri sese. ");
INSERT INTO ninNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Uza muwa nggo ti ta du uwa rri ni ila ure, gye ku ta yo. I ta wre ku uwa, uwa bi rri ni iso sese nu uza uyirr, nu uwa bi se na aza aha ni bi rri nu unto ki iha sese nu uru. ");
INSERT INTO ninNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ishishi muwa inggi ti du uwa sarr, uwa ttu yi glo. I ta wre ku uwa bi rri ko ni ittu yi Abachi ni ishishi iyirr, nu uwa bu gri ashishi aha ni rri nu unto ki iha nu uru ki rri sese. ");
INSERT INTO ninNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nu nggo “ ‘inkɨ yi nggo taka ri ni si ta kɨ hen, uru ku si ta kazhi hen.’ ");
INSERT INTO ninNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","A taka ngla anishirr zzu nu uru na du ba la zzu nu nggo a di surr ima ni ila na di yi imarr. ");
INSERT INTO ninNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ima si inkindirr iwre. Imarr yi ti ngla glo, anko se nggo ta na nà di yi ka ni imarr zizo? Nggo imba hi ima di marr ni inyi, imba bi na ku akpukpambirr ba nâ si ima, ni so zizi na anishirr ba namri.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu gru nu Kapanahu na ji ko na anga ka Yahudiya, na ku cha inyi nu Joda wa. Akpa anishirr bi na nga na ku zizo, uwa so tsarr ba nâ ta si nggo a di tsarr ba ttuttumi. ");
INSERT INTO ninNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Anu Farrisi ba a nga da aba ta ni tsarr ma kye, na ni zhi ma di, “Da ki inta. I wre unuru bu han uwama?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesu zhi ba di, “Musa wa charr ki imba are ka da angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Aba ddu ma di, “Musa kpanye du unuru bu charr ku ayamba ama wa ungbamvu ku ingu igarr na du ma kuma.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu ddu ba di, “Musa charr ure kuma meme nggo imba kri itu ni si wo ure hen. ");
INSERT INTO ninNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ni ime̱me̱ yi i si se meme yo hen, ‘Abachi à na ba unuru tuku ayamba,’ nâ ta su nggo, a charr nu ungbamvu, ");
INSERT INTO ninNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Ni ima yo, unuru ta du aki na ayirr ma, na nggurr itu bi nu uwama ku, ");
INSERT INTO ninNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Aba aha mi ta su ukpa uyirr.’ Na si ta se aha hen. ");
INSERT INTO ninNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ni ima yo, inkindirr yi nggo Abachi zɨ yi bi unushirr bu si tsɨ yi hre hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nu nggo, Yesu ka rri ko ni iko yi, abiga ma, ku zhi ma ure kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yesu ddu ba di, “Undurr wa nggo ta han uwama na ku garr ayamba numa, uwa kpala ku uwama wa kakami. Na si uni zha amba. ");
INSERT INTO ninNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Na anko ayirr ama wa, ayamba wa nggo ta ka uruma na ko ku garr unuma, uwa kpala ku uruma wa kakami. Na si uni zha aniru.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anishirr ba gri ku Yesu amumarr tsitsa di a bu ni sa ungo na ba, abiga ma ba ni nggarr ito na anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nggo Yesu hi ba ni na meme yi, na ki ba unfu, na ddu ba di, “Du amumarr ba du ba nga ni ingga ku, ni si han ba hen, ittu yi Abachi yi i si aba ma yo. ");
INSERT INTO ninNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ingga ko da ki imba ure ujiji, undurr wanggo nggo ta si bwu isisurr na kpa ittu yi Abachi nâ ta si amumarr tsitsa ba hen, uwa si ta rri na yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Na so vu amumarr ba na yiyirr, na sa ba ungo ni itu, na yo ba angu azizi. ");
INSERT INTO ninNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu su nu umi ku uzirr, ugo numa kru na nga ni kuttu ku na agbuzzu, na zhi ma di, “Unitsarr ni iwre, ingga ta na sa angginggi bari ni ka so sese?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu zhi ma di, “Angginggi du ùwà yo ingga ki uni wre? Undurr numa si si uni wre na antsandirr hen, Abachi yo na ankpa ama su uni wre. ");
INSERT INTO ninNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Uwa hi Are ka nggo a da di, ‘Si ngu unushirr hen; si zha amba ba anishirr hen; si ki ayi hen; si gye ku undurr imu hen; si de abubo hen; kru isisu i aki muwa tuku ayirr muwa.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ugo wa da di, “Unitsarr, nggo ingga ni su uvutsa mu ni kru isisu Are ka ma.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu kye ma girr, na kpanye na ku, na ddu ma di, “A ni ji ku ùwà inkindirr iyirr yo. Kuma ku vu aseki muwa ka re namri, ni ga ku abi iha ba inklo yi, ni ga ingga, uwa ta se na ashiki ka kri mwe nu unkplassu.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nggo, ugo wa wo meme, isisurr ima yi kaki chichi, na vri isisurr, na kuma ni ivri isisurr ima yi. Nggo, ugo wa a se na aseki ka shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu ka kye abiga ma ba, na ddu ba di, “I ta ka tsɨ kakami ku aba ashiki ka ingbingbru ba, na bi rri ni ittu yi Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Isisu ki abiga ma ba na are kama, Yesu kuchi ni bre ba di, “Amarr mu imba hi nggo itsɨ ni rri ni ittu yi Abachi yi. ");
INSERT INTO ninNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","A ta si inkindirr isu alakurrmi bi rri ni iywirr i anurr, nu unushirr wa nggo a se na aseki ka ingbingbru ka bu rri ni ittu i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nu ure kuma, abiga ma ba ku ayisurr kakami, na ka so zhi ikpa zhazha di, “Meme Abachi ta kpa unggonggo ttungo?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu ka kye ba girr na da di, “Inkindirr yi nggo i mri unushirr, i si tsɨ ku Abachi hen; na Abachi ku aseki ka wemi si mri ma hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Biturr gru na zhi di, “Inta nggo du aseki munta ka ni ga uwa na?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu kpanye ba di, “I se meme yo, ingga ko da ki imba di, undurr wa nggo ti du iko, ka amuyirr aniru na amba, ka ayirr, ka aki, ka amumarr, ka izzuzzu, na ga ingga, na da ba ure ku Abachi ki wre ku, ");
INSERT INTO ninNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Uwa ta kpa aseki angga ka shishemi, ako na amuyirr, ayiyirr, na Amumarr, ni izzuzzu. Na ta kpa ikarr ni ingbingbru yi. Na ase ka so nga ka, uwa ta ka kpa izhi iso sese. ");
INSERT INTO ninNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Abi ime̱me̱ ba ta kaki abi kugo, abi kugo shishemi ta kaki abi ime̱me̱.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nggo, aba so kuma nu Urushalima, uwa so ku ba ichi. Uzirr umaku du abiga ma ba so ku ayisurr. Inkpu anishirr zi ga ba ni isisu. Yesu yo awurr na aha ba kaki na anga yirr na da ba inkindirr yi nggo ta la na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","A ddu ba di, “Inta ko kuma nu Urushalima, nggo a ta ku vu Ingga Uvuvurr a Unushirr nu ankpinkpye abikye ba na abitsarr are ba. Aba ta da di a bu ngu ingga, na ta ba ingga nu abichirr. ");
INSERT INTO ninNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Aba ta me̱ ingga, na ta sarr antinte surr ingga, na ta hlo ingga, na ta ngu ingga. Unu utarr wa, ingga ta tasi.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ani Yakubu tuku Yohana, Amumarr bu Zabadi, gru nga ni zhi Yesu di, “Unitsarr, inta di inta ta barr uwa, du uwa na ki inta inkindirr numa nggi?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yesu zhi ba di, “Imba zha di ingga bu na ki imba angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Aba da di, “Nu nggo ùwà taka so ni imburr i ittu muwa yi, ùwà ka du uyirr munta wa bu so ku ùwà nu ungo ri, uyirr wa nu ungo mla.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu ddu ba di, “Imba si hi inkindirr yi nggo imba ko zha yi hen. Imba ka so nu ukucha ki rɨ kpakpa ni ivri ku nggo ingga ta so? Ka a ta zzu imba na anko ayirr nggo a zzu ingga na amasirr, ni iha yi nggo ingga ta ki yi?” ");
INSERT INTO ninNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Aba di, “Yo-o! Inta ka na.” Yesu ddu ba di, “Imba ta so nu ukucha ki rɨ kpakpa ku nggo ingga ta so, ni ta kpa izzu na amasirr nggo a ta zzu ingga. ");
INSERT INTO ninNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Uwa ti si iso nu ungo ri tuku nu ungo mla mungga si si ingga nggo ta ni imba hen. Sa Abachi mu ta nu abangga ba nggo a hla ba into ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nggo, awurr na aha abiga ma ba wo ure ku nggo ku, na ki unfu ni Yakubu ku tuku Yohana. ");
INSERT INTO ninNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu yo ba nggurr bi ni inkla iyirr, na ddu ba di, “Imba hi anishirr abangga ba a na ba ki attu na atu anishirr a se nu ukyekye ku gri ba ndanda mi. Ankpinkpye anishirr ba di nu ba iha. ");
INSERT INTO ninNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Imba bi si na meme yo hen. Undurr wa nggo ti du uwa ta sa ankpye ni imba ba, uwa bi su ugarr amba we. ");
INSERT INTO ninNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Uwanggo nggo ta du uwa ta si uni me̱me̱, uwa bu su ugarr amba we. ");
INSERT INTO ninNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ingga Uvuvurr a Unushirr mi si nga di a bu ni gbo ki ingga gbi gbo hen; ingga nga ni itu mungga nye kpa anishirr shishemi ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","A nga nu Jerriko, Yesu so na abiga ma ba na anishirr shishemi. Unakreshishi numa nggo a yo ma du Batimawu, uvuvurr a Timawu, nggo so nu unddu anko ku na so barr. ");
INSERT INTO ninNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nu nggo a wo da a si Yesu anu Nazareti, nggo so sarr na gru so yo hantu di, “Yesu, Uvuvurr a Doda, kye itito mungga!” ");
INSERT INTO ninNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Anishirr shishemi kpa ma ki, di a bu ba ttungo. Uwa ka, na so du hantu kakami di, “Uvuvurr a Doda, kye itito mungga, ni zi ingga!” ");
INSERT INTO ninNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu kukri na di, “Yo ma.” Aba yo ugo na kreshi wa, na da ku di, “Vu isisurr, gru kye ma so yo uwa.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Batimawu ttu ikpo ankru ima yi ta yo, na nga chachacha, na kuma ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu zhi ma di, “Uwa zha di ingga bu na ku uwa angginggi?” Unakreshishi wa di, “Ankpye, da ashishi ka bwu ki ingga, ni di ingga kye hi zizo.” ");
INSERT INTO ninNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu ddu ma di, “Kuma, iyo isisurr muwa nggi du uwa wre.” Inkpo iyirr, Batimawu hi abubo, na ga Yesu kuma na anko. ");
INSERT INTO ninNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nggo, Yesu na abiga ma ba ki ywhiywhirr nu Urushalima, nggo a ki gaga irri ni igbu nu Betifegi tuku Betani, na nga ni Igbre nu Olivu. Yesu ttu anishirr aha nu umi ku abiga ma ba, na tu ba kuchi, ");
INSERT INTO ninNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na gba ba utu di, “Kuma ni igbu wanggo wa ni ichi imba, ni imirri imba, imba ta hi uvuvurr ijaki nggo a lo ma nabo, nggo nise hun yi kye. Imba ddu yi gri ki ingga ni inggya. ");
INSERT INTO ninNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Undurr ti zhi imba di, ‘Imba so na angginggi nabo?’ Imba da ku di, ‘Akikye wa yo tu inta, à ta du ba gri yi kanga ziza.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aba kuma, na ku hi uvuvurr ijaki wa, nggo a lo ma zu nu ankonki a iko nga na anko, aba ku ddu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Anishirr banu kri nabo, na zhi ba di, “Angginggi di imba so ddu uvuvurr ijaki wa?” ");
INSERT INTO ninNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Aba da ba ure ku nggo Yesu a da ba, anishirr ba du ba kuma nu uvuvurr ijaki wa. ");
INSERT INTO ninNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Aba gri uvuvurr ijaki wa ga ku Yesu, na ddu inkinkru imbarr i abi yi sa ku, na du Yesu hun so. ");
INSERT INTO ninNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Anishirr shishemi a ddu angbanja iki ambarr ka la ku na anko. Abanu mɨ angbamvu surr ku na anko wa. ");
INSERT INTO ninNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Anishirr ba nggo a so ku ki ichi, na abanu ba nggo a so ga ma nu ugo, gru so hantu ko da di, “Hosana! Inyarr si i Abachi! Abachi bu yo angu ama ka wre ku wanggo nggo a nga ni isa yi Atiko yi! ");
INSERT INTO ninNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Abachi bu sa ungo uma ku wre ku ni itu yi ittu yi nggo so nga nâ ta si ittu i aki munta wa Doda! Inyarr si i Abachi nu unkplassu!” ");
INSERT INTO ninNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu rri ko nu Urushalima, na ko nu Uki Unkpi ku Ibarr Abachi ku, na kye ku kago, nggo azhi wa so kre, uwa ka huzzu ko nu Betani na awurr na aha ba. ");
INSERT INTO ninNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nu uha wa nggo a gru nu Betani, iyo ki Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Uwa yo ashishi hi ibwa numa gbagba mu, na ko kye du uwa ta ku hi inkpinkpo numa na ka ywhe ri, na nga ni ichi yi, na ni hi sa angbamvu yo mre, ibwa wa si klo hen. A si su ba ivi imbarr iyo hen. ");
INSERT INTO ninNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yesu ddu ibwa wa di, “Undurr mi si taka ri inkpinkpo muwa yi zizo hen.” Abiga ma ba a wo ma ni da yi. ");
INSERT INTO ninNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Aba ku rri nu Urushalima, Yesu kuma nu Uki Unkpi ku Ibarr Abachi ku, na ko ku han abi gri iki nga ni re ba na abi so re iki nu Uki ku Ibarr Abachi ku, na vu ankpu imburr ka abi so sarr inklo ba kasarr, na abubo a iso a abi so re ananddu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Yesu kisa ku anishirr ba ni gri inki ire na rri ba nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Na da ku anishirr ba di, “A kurr ni icharr nu ungbamvu ku Abachi ku zhe mu di, Abachi da di: “ ‘A ta di yo Iko imungga yi ki iko yi ibarr ingga i ingbingbru yi we.’ Imba ka yi ki unto ku iso ku abayi!” ");
INSERT INTO ninNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ankpinkpye abikye anishirr na abitsarr are ba a wo ma mi, na gru so zha anko a ingu Yesu. Na so kru isisu ima yi, nggo anishirr ba shishemi a ku ayisurr ni itsarr ima yi, na kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nggo azhi wa so ku, Yesu na abiga ma ba gru huzzu nu umi ìgbù ku. ");
INSERT INTO ninNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na ambre ka uha ka, aba gru so ga anko wa, na ni hi ibwa wa nggo a yo ko angu ndanda ka, uwa ttu zhi na angbungba ka ji ku sarr ni izhizhi yi. ");
INSERT INTO ninNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Biturr kye hi na da ku Yesu di, “Ankpye, kye ibwa wa nggo uwa na yo ku angu ndanda ka a ddu!” ");
INSERT INTO ninNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu da ba di, “Gri Abachi ni isisurr muwa yi gbangba. ");
INSERT INTO ninNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ingga ko da ki imba ure ujiji di, wanggo nggo ti da ki igbre wa nggo wa di, ‘Gru kuma ku, ku ni inyi,’ ni isisurr ima iyirr na kpanye jiji di inkindirr yi nggo uwa da yi ta se meme yo, uwa ta na ku na yi. ");
INSERT INTO ninNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Meme nggo ingga ko da ki imba, uwa ti barr zha inkindirr na Abachi ku, uwa bi kpanye du uwa ka kpa yi ba, uwa ta nu uwa na yi jiji. ");
INSERT INTO ninNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Uwa ti gru kri ni ta barr Abachi, uwa bi nggurr zhi ku abangga ba nggo kpala ku uwa, ni da Aki muwa nu unkplassu mi ka ila ure muwa yi glo ku uwama.”  ");
INSERT INTO ninNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Uwa ta si nggurr zhi ku abanu hen, Aki muwa nu unkplassu mi si ta nggurr zhi ku uwa meme hen. ");
INSERT INTO ninNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Aba kakuma nu Urushalima zizo. Yesu ku so zirr kago nu umi Uki Unkpi ku Ibarr Abachi ku, ankpinkpye abikye ba, na abitsarr Are ba, na akikre anishirr bi igbu ba, a nga na ku, ");
INSERT INTO ninNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na ni zhi ma di, “A su nu kyekye ku unggonggo uwa so na iki isisu inggi yi? Unggonggo nu uwa ukyekye ki na iki inggi yi ma mi?” ");
INSERT INTO ninNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu da ba di, “Ingga mi se ni izhi iyirr nggo ingga ta zhi imba. Imba ti sa ki ingga ma, ingga ta da ki imba undurr wa nggo ni ingga ukyekye ki na aseki ku. ");
INSERT INTO ninNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ukyekye ku nggo izzu yi nggo Yohana di zzu anishirr ba na amasirr wa u zhi nu momonggo? A kpa ukyekye ku zhi na Abachi ku, ka Yohana a na ki itu ima? Da ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Aba ka ko ri anta, ni ikpa di, “Inta ti da di, ‘A kpa zhi na Abachi ku,’ uwa ta da du uwa sa anggi mu inta si kpanye nu Yohana ku hen? ");
INSERT INTO ninNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Inta ti da di, ‘A na ki itu ima.’ ” (Isisu so ki ba na anishirr ba, nggo anishirr ba wemi kpanye du Yohana si uni kpa are a Abachi jiji.) ");
INSERT INTO ninNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nggo, na da ku Yesu di, “Inta si hi hen.” Yesu ddu ba di, “Ingga mi si ta da ki imba, ukyekye ku nggo ingga so na undu na ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu gru so tsarr ba na assurre numa di, “Ugo numa nggo do ila, na ttu inkinkurr numa nggi a yo yi du grepu. Na harr ila yi kago na acha, na ya inkpri udduddu nggo a ta di hin àmà wa surr, na me unto ki ihun kri na kye kago. Na ba ila yi nu abi do abanu nggo a ta di kye ku na yi, na kuma nu uzirr nu unto gbagba. ");
INSERT INTO ninNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ni ivi iywhe issubi yi, uwa tu uvuvurr iko ama numa na abi do ba ba, di a bu nu ma inkpinkpo ima ga ku uwa. ");
INSERT INTO ninNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Abi do ba ku vu ma hlo, na han ma share na ango aha. ");
INSERT INTO ninNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Uwa tu uvuvurr iko numa kako na aba zizo, aba ku hlo uwama nggarr itu na nu ma ishisha. ");
INSERT INTO ninNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akikye wa ku tu unuma ko na aba ki unu utarr, aba ku ngu uwama. Uwa ni tu abanu shishemi, aba ku hlo ba, na ngɨ inkpu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Uwa se nu uvuvurr uyirr yo nggo ta tu, uzuma wa nggo a kpanye na ku. Na tu ma, ni ikikre yi, di a ta ku kye ma ssu nu ungo. ");
INSERT INTO ninNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Abi do ba re ni ikpambarr di, ‘Uwanggo yo su uvuvurr a ugo wa, nggo taka ni gri abubo wa, nga yi di inta ni ngu ma ni gri abubo wa ki amunta.’ ");
INSERT INTO ninNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aba vu uvuvurr wa, na ngu ma, na ba iku yi huzzu ni ila yi gri ku ta yo na ábì.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu kuchi ni bre ba zizo di, “Akikye ni ila wa ta ni na ba kingginggi? A ta ni ngɨ abi do bama ba, na kpa ila yi nu abanu. ");
INSERT INTO ninNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Imba nise bre nu Ungbamvu ku Abachi ku nggo a charr di: “ ‘Ingbinta yi nggo abi me ba a kà yi, iyo kaki itu yi ibarr iko yi. ");
INSERT INTO ninNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Atiko munta wa Abachi nggo na yi meme, wanggo si inkindirr iku ayisurr ni hi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ankpinkpye ba anu Yahuda ba so zha anko a vu Yesu, nggo a hi da a so da assurre unggo ku na atu ambarr. Aba du ma na kuma, nggo a so kru isisu i anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ankpinkpye ba anu Yahuda ba, tuku anu Farrisi, tuku anishirr ba Hirridu ba a nga ni Yesu ku, da aba ta ku tirr ma ni izhi kye, wre ba ka vu ma. ");
INSERT INTO ninNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na gru nga na ku di, “Unitsarr, inta hi uwa so da su ure ujiji, ni si di kakye inkindirr yi nggo anishirr di da hen, ni si di kye unushirr ki na nkanka hen. Ùwà so tsarr anishirr anko a Abachi wa nu ure ujiji. I wre inta bi han inklo i imimi yi ku Kayisa (Uttu unkpi nu Roma wa), ka i si wre hen mi? ");
INSERT INTO ninNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Inta bu han, ka inta bu si han hen?” Yesu kye ba hi nggo a nga i tirr ma, na zhi ba di, “Ingga na ki imba angginggi nu nggo imba nga nye i tirr ingga? Imba gri ki ingga inkpinkpri inklo dinarri iyirr, ni di ingga ni kye.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Aba gri ku uyirr. Uwa kpa ku kye, na zhi ba di, “Wanggo so ashishi ka unggonggo ni isa inggonggo ni inklo yi?” Aba di, “Uttu unkpi nu Roma wa.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yesu ddu ba di, “To, imba nu Uttu Kayisa inkindirr yi nggo i si ku i ma, ni nu Abachi inkindirr yi nggo si i Abachi.” Aba vu angu gri. ");
INSERT INTO ninNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Anishirr banu nggo a yo ba da, Anu Sadusi (Anishirr ba nggo si kpanye da anishirr ta ka tasi hen), nga ni Yesu ku. Na ni zhi Yesu di, ");
INSERT INTO ninNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Unitsarr, Musa à charr ki inta du: ‘Undurr ti ttu na du ayamba sa nu uvuvurr, uzayirr ama wa bi hru ayamba na ako wa, na ngri Amumarr surr ku uzayirr ni ittu wa.’ ");
INSERT INTO ninNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Amugo abanu sa aba atangba, ununku wa a garr na ttu sa nu uvuvurr. ");
INSERT INTO ninNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ususa umaku u ba ayamba wa gri, uwa mi ni ttu sa nu uvuvurr wa meme. Ni se meme yo nu unu utarr ambarr wa ku. ");
INSERT INTO ninNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aba atangba mi a gri ayamba wa ama na kɨ sa ni ita. Ayamba wa mi, ni ikikre yi, nga ni ttu ga ba sa ni ita yi meme. ");
INSERT INTO ninNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ziza, na azhibarr a itasi wa, uwa taka sa ayamba a uwatanggo, nggo aba atangba mi a hru ma ki ayamba ambarr.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu da ba di, “Ivri imba yi si iyirr yo, nggo imba si hi Ungbamvu ku Abachi ku, ka ukyekye ku Abachi ku hen. Ima yo, di imba na ndanda mi! ");
INSERT INTO ninNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Nggo abi kɨ ba taka tasi, aniru na amba si ta ka garr zizo hen. A ta ka zzu na su abitu ba Abachi ba nu unkplassu nggo si di garr hen. ");
INSERT INTO ninNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ziza nggo, ni itu abi kɨ yi, nggo taka tasi: imba nise bre nu ungbamvu ku Musa ku, nu unto nggo ijiji yi iso kparri? Abachi ddu Musa di, ‘Ingga yo sa Abachi a Ibrayi, Abachi a Ishaku, Abachi a Yakubu.’ ");
INSERT INTO ninNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Imba ssurr ndanda mi, Abachi si sa Abachi abi kɨ hen, a sa Abachi abi so!” ");
INSERT INTO ninNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Uyirr a abitsarr ba Are ka, a nga ni wo ba ni ko ri anta yi, na hi nggo Yesu re na ba zizi mi, na zhi ma di, “Nu umi ku ankpi are ka, ita inggi i mri?” ");
INSERT INTO ninNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu ddu ma di, “Inkindirr inggi nggo i mri, inggi si, ‘Imba wo yi ani Israila! Atiko, Abachi munta wa, Atiko nggo su uyirr. ");
INSERT INTO ninNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kpanye na Atiko, Abachi muwa ni isisurr muwa iyirr, ni izhi muwa yi, na amarr muwa ka, nu ukyekye muwa ku.’ ");
INSERT INTO ninNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ure ku uha ku nggo si di: ‘Kpanye na anishirr ba namri zzu na si itu muwa.’ Inkpi ire numa sama nggo i mri aha angga ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Unitsarr Are wa ddu Yesu di, “Unitsarr, ingga chi uwa! A su ure ujiji nggo uwa da di Atiko Abachi wa su uyirr yo, unuma sa na antsandirr nggo mri ma; ");
INSERT INTO ninNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Unushirr bu kpanye na Abachi ku ni isisurr ima iyirr, na amarr ama ka, nu ukyekye umaku, na bu kpanye nu anishirr ba na su nggo uwa kpanye ni itu ima yi; ankpi Are numa sama na antsandirr nggo a mri aha angga ka, ankpi Are aha angga ka a mri han amuwu na tu inina yi nu uru ni iki numa yi nggo a di gri nga ku Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu wo nggo ugo wa re krizhizhi mi na ddu ma di, “Uwa si ywhiywhirr mi ni mirri ni ittu yi Abachi.” Nu ugo ku uwama ku unuma si ka zhi Yesu inkindirr zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nggo Yesu so tsarr ba nu Uki Unkpi ku Ibarr Abachi ku, uwa zhi ba di, “Abitsarr Are ba na kingginggi na da di Mezaya wa taka su uvuvurr a Doda? ");
INSERT INTO ninNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Doda ku itu ima, nggo Izhi Iwre yi Abachi yi i so ku ni isisurr, uwa da di: “ ‘Atiko wa da ku Atiko mungga wa di: “Ji so nu ungo ri mungga, ni di ingga ka abi karr ùwà ba yo ku uwa ni imimi du ùwà so ni sa uza na ba.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Doda ni itu ima, à yo Mezaya wa da ‘Atiko.’ Na anko a ta nggo, uwa kaki ku Doda uzuma?” Akpukpa anishirr nggo ko wo ma, na ko nyarr ku kakami. ");
INSERT INTO ninNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nggo a so tsarr, na da ba di, “Imba bi zirr ndindi ni du ku abitsarr Are ba, nggo di surr atozzo inkinkru, na di zirr kago di zha ichi na anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Na di zha into iso izizi na aki ka issubi ka, ni into izizi nu nggo a so na iga nggo. ");
INSERT INTO ninNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Abangga ba yo sa anishirr ba nggo di kpa iki na amba bi so na ako ba de ri, na di barr ta anko na aki ka barr Abachi ka, da anishirr bi kye ba. Anishirr ba ma, Abachi taka ki ba iha ndanda mi.” ");
INSERT INTO ninNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu kuso hin nga nu unto ku nggo a di ka inklo yi nggo anishirr ba di gri na nga nu Uki Unkpi ku Ibarr Abachi ku surr, na so kye anishirr ba, ni surr azo ka nu unto ku. Anishirr shishemi nggo se na azo kakami a ko surr azo ka kakami. ");
INSERT INTO ninNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ayamba numa nggo so na ako, na sama ni inkindirr, ni surr angalanzirr atsitsa aha. Nu nggo ka ma inklo anini ayirr mi. ");
INSERT INTO ninNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu yo abiga ma ba, na ddu ba di, “Ingga da ki imba ure ujiji mu da ayamba na ako anggo wa, a ni azo mri anishirr ba wemi nggo a yo ungo nu unto ki surr azo ku. ");
INSERT INTO ninNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Abi ni shishemi ba, a tsu zhi ni inkindirr yi nggo a se na yi, ayamba anggo wa a ni zhi nu ntsɨ wa nggo a se na ku, na ni mri, inkindirr yi nggo a se na yi ni iso ima yi ni ingbingbru yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nggo Yesu so huzzu nu Uki Unkpi ku Ibarr Abachi ku, uyirr nu umi ku abiga ma ba ddu ma di, “Unitsarr! Kye angbinta kpinkpi angga ka na, kye ime inkpi iwre inggi na!” ");
INSERT INTO ninNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu ddu ma di, “Uwa hi ime inggi yi, a taka turr yi hre tsatsarr, ingbinta iyirr si ta hun so ki inuma nu ugo hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesu so, na so ka ashishi ko nu Uki Unkpi ku Ibarr Abachi ku. Nggo Yesu so ni Igbre nu Olivu wa, Biturr, Yakubu, Yohana tuku Andoro ni ko ku zhi ma toto di, ");
INSERT INTO ninNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Da ki inta ni ta nggo inkindirr inggi yi taka na. Angginggi taka tsarr inta da a si ivi ima yo ima ba?” ");
INSERT INTO ninNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu da ba di, “Imba so kye yi, ni su du unu ni re imba hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anishirr shishemi ta nga ni isa mungga da aba yo su Kristi wa, na ta re anishirr shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Imba ti hi iku na are ka iku, imba si ki isisu hen, iki yi nggi yi ta na. Meme mi ikikre yi nise bari. ");
INSERT INTO ninNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ìgbù ta tsi ni ìgbù. Attu ta tsi na attu. Imimi yi ta battu ni ingbingbru yi shishemi, iyo inkpi taka se. Uwanggo ni ko si ime̱me̱ iha ingri yi mu bari. ");
INSERT INTO ninNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Imba so gbye yi, a ta vɨ imba gri ko ni into yi ibre are na attu ba, na ta hlo imba na aki ka issubi ka. A ta gri imba ko na attu ba ni itu iga ingga. Wanggo yo ta sa anko wa nggo imba ta da ba Ure ku wre ku ni itu mungga. ");
INSERT INTO ninNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","(A ta da ku anishirr Ure ku wre ku unggo ku ki ni ikikre i ingbingbru yi wemi bari, ikikre yi ta ka nga.) ");
INSERT INTO ninNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ivi yi nggo a ta vu imba gri na ko ni into ibre yi, imba bi si ri amarr ka inkindirr yi nggo imba ta ku da hen. Da ba inkindirr yi nggo Izhi yi Abachi yi nu uwa na attuttu ama wa. A si su uwanggo ta re hen, a si Izhi yi Abachi yi iwre mu ta re ku uwa. ");
INSERT INTO ninNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Imuyirr ta vu imuyirr ku nu ba tsi ngɨ, akiki mi ta na meme ku Amumarr ambarr. Amumarr mi ta tirr akiki ambarr ku nu ba tsi ngɨ. ");
INSERT INTO ninNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anishirr namri, ta kà imba ni isa mungga, uwanggo nggo ti kri ngbangba ku ma ni ikikre yi, Abachi taka kpa ma ttungo. ");
INSERT INTO ninNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Imba ti hi ‘Inkindirr indanda i ankizhi’ i kri nu unto ku nggo u si su ku uma hen. (Uwa ni bre wa, bu hi inkpi ire ima yi.) Abangga ngga a so nu Yahudiya bu kru huzzu ku sharri na agbre. ");
INSERT INTO ninNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Undurr wa nggo ti ni so ni ituki uwa bi kru ji kuma, na si ka rri ko du uwa ko iba inkindirr nu umi uki hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Uwanggo nggo ta kri ni īlá uwa bu si kru ka ko du uwa ka ko iba ankru ni iko hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ivi ima ta ka vri kakami ku amba bi ine na amba bi ko gri amumarr. ");
INSERT INTO ninNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Imba barr Abachi di ivi ima bi ka si ni ikɨ hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ivri yi ivi ima ta ka si ndanda nggo. Imba nise hi meme kye ni ingbingbru yi, zhi ni me̱me̱ yi nggo Abachi a na ingbingbru inggi yi, ni si ta ka si meme zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Abachi tsu ivi ima yi ki ntsɨmi. I ka si si ntsɨmi hen, unushirr uyirr mi ka si so tsitsirr hen. Uwa a si ni itu i anishirr ba nggo a hla ba nggo, ima yo i du ba tsu ivi yi ki ntsɨmi. ");
INSERT INTO ninNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Undurr ti ddu imba di, ‘Kye, Kristi wanggo nggo,’ ka di, ‘Kye uwanggo nu unggu mu,’ imba bi si kpanye na ba hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Anu Kristi abi imu, na abi kpa are bi imu ta huzzu. Na ta na iki yi isisu ni iki ikagri, wre ba ka re anishirr ba nggo Abachi hla ba nggo a ti hi anko wa. ");
INSERT INTO ninNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Imba so gbye kakami! Ingga da ki imba ni ima yo ni di ivi yi ni se ni ichi. ");
INSERT INTO ninNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ni ivi ima yi, nu ugo ki iha ku, “ ‘azhi wa ta ka shirr, uhwa ku si taka la hen; ");
INSERT INTO ninNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","intsintse̱ yi taka kuhre zhi nu ussu, ukyekye ku unkplassu ku ta battu.’ ");
INSERT INTO ninNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Nabo yo anishirr ta hi ingga Uvuvurr a Unushirr na ashishi ko ji na akpa ka nu ukyekye ni ila nzarrnzarr. ");
INSERT INTO ninNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ingga ta tu abitu mungga ba zhi nu unkplassu, du ba ni nggurr anishirr mungga ba bi nggo Abachi ka hla ba zu ba, zhi na anga anza ambre kuma na anza a ingbahru, zhi ni ikatu kuma ni ikashirr, na anga ka anɨ mi kuma ni ikikre yi unkplassu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Imba bi na undu nu ure ku ibwa ku, nggo ti ddu angbungba ka, na ko to ahe̱he̱, imba di hi di ikɨ so nga manu. ");
INSERT INTO ninNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Meme mi, imba ti hi aseki angga ka, imba bu hi di ingga ki ywhiywhirr na anko ba. ");
INSERT INTO ninNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ingga so da ki imba ure ujiji mu, imba ta hi aseki angga ka anishirr ba umi ba ni so. ");
INSERT INTO ninNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Unkplassu tuku imimi ta kre, ure mungga ku si ta ka kre hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“A ta sa azhibarr wa, na attuttu a inga mungga wa. Undurr si hi hen, ka abitu ama ba nu unkplassu, ka uzuma wa. Aki wa yo hi na ankpa ma. ");
INSERT INTO ninNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Imba so, ni so gbye yi, ni si so kahre hen. Imba si hi attuttu wa nggo a ta ka nga hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ingga Uvuvurr a Unushirr, si na su unushirr wa nggo so kuma nu uzirr nu unto ugbagba, na du iko ima yi nu ungo ku amirr iko ama ba, na ga ba into yi indu na nkanka, na da ku uni gbye anko wa, da abi so gbye anko wa zizi, na si kurr ina hen. ");
INSERT INTO ninNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Imba mi bi so gbye, imba si hi attuttu wa nggo atakye ni iko wa ta kanga hen. A taka si ni ingbahru nggi, na atsutsu ibittu, ka na agba tu, ka na ambre. ");
INSERT INTO ninNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Du ma si ka gru nga ni ttu imba zu, imba so kurr ina hen ");
INSERT INTO ninNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Inkindirr yi nggo ingga da ki imba, ingga da ku anishirr ba tsatsarr. So gbye yi!” ");
INSERT INTO ninNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","A ji ivi iha aba bi na Iga i Ivu Sarr yi tuku Iga i Unfonfo ni Sama na Iyisti wa. Ankpinkpye abikye ba tuku abitsarr Are ba, a so zha anko wa nggo aba ta vu Yesu ku tsi ngu na ayi. ");
INSERT INTO ninNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Aba da di, “Inta bu si na na azhibarr a iga wa hen, du ku anishirr ba ta zha are ni inta ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nu nggo Yesu so nu Betani ni iko i Sima nggo a lo ishi. Nu nggo Yesu so ri ila, ayamba numa gri anye wa nggo tsi anta na hun ingba wre na azhizha a alabasta. A na wa na anye a unkunkurr ku nggo yo ku du nadi, na si zɨ wa ni inkindirr hen. Uwa murr itu azhizha yi na ka anye wa surr ku Yesu ni itu. ");
INSERT INTO ninNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Anishirr banu nggo a kri nabo a vri isisurr, na so re di, “Angginggi du ayamba nggo so varr anye wa hre gigyemi? ");
INSERT INTO ninNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anye ma nggo ka ba wa re inklo ssu na ango aha na ga ku abi iha (nggo ka ma azo ka ihan unushirr nu undu ni ise).” Na nggarr ito na ayamba wa ku. ");
INSERT INTO ninNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu ddu ba di, “Imba du ma tomi. Imba glo ma na anggi? A na ki ingga inkindirr izizi ni inkindirr iwre mu na. ");
INSERT INTO ninNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Abi iha ba ta di so ni imba ba ttuttumi. Azhibarr wa nggo imba ta hi inkindirr iwre imba na ba. Uwa ta si ingga, ingga si ta di so iso inggi ni imba hen. ");
INSERT INTO ninNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A na inkindirr yi nggo a hi anko a ina wa. A ka anye anggo wa surr ki ingga, a ko na ingga ssubi ki iba zzu mungga iyo. ");
INSERT INTO ninNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ingga da ki imba ure ujiji mu di, unto ku nggo a ti ko ku da ba Ure ku wre ku ni itu mungga ni ingbingbru inggi yi, aba ta da ba ure ku ayamba unggo ku, na du ba hi ku.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judasi Iskariyoti, uyirr nu umi ku awurr na aha ba, gru kuma na ankpinkpye abikye ba, ko ku ba Yesu nu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Aba nyarr ku kakami nggo a wo ure ku na da zu ku da aba ta nu ma azo. Uwa ko zha anko nggo uwa ta ku vu ma nu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na azhibarr a ime̱me̱ wa a Iga i Unfonfo ni Sama ni Iyisti wa, nggo a sa azhibarr a di han imimarr inkru i Iga i Ivu Sarr yi, abiga bi Yesu ba zhi Yesu di, “Uwa zha di inta bu ku zzu unto ku ki nu momonggo, nggo inta ta ku ri Iga i Ivu Sarr yi?” ");
INSERT INTO ninNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yesu hla anishirr aha nu umi ku abiga ma ba na da ba di, “Imba kuma nu umi ìgbù ku Urushalima, imba ta ku hi ugo numa gri itsa yi amasirr, na ta ma ni imba ba na anko. Imba bu ga ma kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ku da ku akikye ni iko wa nggo uni gri amasirr wa rri di, ‘Unitsarr wa du, Uki ku abichirr umungga ku u se nu momonggo, nggo ingga na abiga mungga ba ta ni ri Iga i Ivu Sarr yi?’ ");
INSERT INTO ninNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Uwa ta tsarr imba angbla uki numa na atu, nggo a ka ssu ku ki zu ba. Imba ssubi ki inta nabo yo.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Abiga ma ba, nggo a hla ba, gru vu anko, na kuma nu umi ìgbù ku ku hi i se meme yo nggo Yesu da ba nggo. Na ssubi ki Iga i Ivu Sarr yi nabo. ");
INSERT INTO ninNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ni ingbahru yi Yesu à nggurr surr na awurr na aha ba. ");
INSERT INTO ninNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nggo a so ri ni imburr iri inkpi yi, Yesu da ba di, “Ingga da ki imba ure ujiji di, uyirr nu umi umba ku ki ywhiywhirr i ba ingga nu ba, uyirr amba wa nggo so ri ni ingga ku.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Inkindirr ima yi ivri abiga ma ba isisurr kakami, aba gru so zhi ma na yiyirr, da di, “Uwa da di a si ingga? Han?” ");
INSERT INTO ninNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu ddu ba di, “A ta su uyirr nu umi umba awurr na aha ba yo. Uwanggo nggo à so yo ungo ku ni ingga ku na agbugba ayirr, uwa yo ta ba ingga nu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nâ ta su nu nggo a charr da nu Ungbamvu ku Abachi ku du Uvuvurr a Unushirr ta ttu. I ta su ndanda ku undurr wa ma nggo ta ba Uvuvurr a Unushirr nu ba! A ka hi meme na si ngri ma hen!” ");
INSERT INTO ninNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nggo a su nu umi ki so ri ku, Yesu ba unfonfo wa numa na da inyarr ku Abachi, na nga ma hre, na ka nu abiga ma ba, na da ba di, “Kpa yi! Kye uwanggo su ukpa mungga ku.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Na ki ungo ba ukofi ku, na nyarr ku Abachi zizo, na ka nu ba. Aba kpa so wemi. ");
INSERT INTO ninNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu da ba di, “Uwanggo yo sa ayiyi mungga wa nggo a ka wa hre ku anishirr shishemi. Ayiyi anggo yo su ishi azhi ihe̱he̱ i Abachi ku anishirr. ");
INSERT INTO ninNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ingga da ki imba ure ujiji, ingga si ta so ama a ugbyarr iki numa ni imba ba zizo hen. A ta ka sa azhibarr wa nggo ingga ta ka so ama he̱he̱ mu ni ittu i Abachi nu unkplassu.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nggo a ri kre, na da usarr, aba gru hun kuma ni Igbre nu Olivu wa. ");
INSERT INTO ninNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu ddu ba di, “Imba ta kru nggarr nado ni du ingga, zzu nu nggo a charr da nu ungbamvu ku Abachi ku: “ ‘Ingga ta ngu uni ka aminta wa, aminta ba ta kru nggarr nado.’ ");
INSERT INTO ninNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nu ugo ku nggo ingga ti tasi, ingga ta ku ki imba ichi ko nu Galili.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Biturr ddu ma di, “Anishirr ti kru nggarr nado namri, ingga si ta kru hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu da ku di, “Di ingga da ku ùwà ure ujiji, ni ibittu i ari yi nggo agba wa ta nise tu ki inkpu iha, ùwà ka kisa ni ingga ku ki ankpu atarr ba.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Biturr da ki Yesu kyekye mi di, “A ti ta ngu ingga kye nu ùwà ku mi, ingga si ta kisa di ingga si hi ùwà hen.” Abiga ma ba namri da angu yiyirr kama yo. ");
INSERT INTO ninNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Aba gru kuma nu unto numa nggo a yo ku du Getsemani. Yesu da ku abiga ma ba di, “Imba ji so ni inggya, di ingga ta ku barr.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Na yo Biturr, Yakubu tuku Yohana gri. Isisurr ima yi wri kpakpa ni vri. ");
INSERT INTO ninNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yesu da ba di, “Isisurr mungga yi se ni ivri kakami di ingga ki gaga yi ittu. Imba so ni inggya ni so gbye yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nggo a sha chi kuma ntsɨ, na jaku ji kurr ni imimi, na barr di, i ti wre ku Abachi, uwa bi ka iha inggi glo ma. ");
INSERT INTO ninNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Na barr di, “Aki! Aki mungga! Inkindirr sama nggo i ka mri uwa, nggo uwa ta kpanye, uwa ka iha inggi yi glo ki ingga. Si na inkindirr yi nggo ingga zha hen, uwa bi na inkindirr yi nggo iwre ku uwa!” ");
INSERT INTO ninNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nggo a kanga na atarr ba ba, na ni hi ba so kurr ina, na yo Biturr na zhi ma di, “Sima, ùwà so kurr ina mu-u? Ùwà ka si sha so tsitsirr ntsɨ ma attuttu ayirr hen. ");
INSERT INTO ninNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Imba so tsitsirr, ni so gbye yi, ni so bi barr du ku imba bu si ku la ure hen. Kye, izhi imba yi i so zha ina inkindirr yi nggo iwre, ukpa umba ku u su.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Na ka ko zizo ku barr, na da inkindirr yiyirr ima yo. ");
INSERT INTO ninNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nggo a kanga zizo, na ni hi ba so kurr ina yi zizo, nggo ashishi ambarr ka rɨ ni ina, na si so kye hen, uwa si ba. Aba si hi inkindirr yi nggo aba ta da ku hen. ");
INSERT INTO ninNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nggo a kanga na aba inkpu itarr yi, na ni zhi ba di, “Imba ni ko kurr ina, ni so su yi? Ima ba! Attuttu ayo a nga ba! Kye, ziza undurr numa a ba ingga Uvuvurr a Unushirr ni na ango ka abi la ure ba. ");
INSERT INTO ninNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gru yi, ni di inta kuma. Uni ba ingga ni wanggo so nga ywhiywhirr mi!” ");
INSERT INTO ninNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nggo Yesu ni so re na ba, Judasi, uyirr nu umi ku awurr na aha ba, ku nggurr surr. Na nga na akpa anishirr di ga ma, abanu gri injingba na abanu ankpunkpu inkinkurr. Ankpinkpye abikye ba, na abitsarr Are ba, na akikre anishirr ba, aba yo tu ba di a bu ku vu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ziza, uni ba ma nu ba wa zzu kuma, nâ ta si nggo a ka tsarr ba ba di, “Ugo wa nggo ingga ta ku nyarr ma vu ni ma anta, uwa yo su wanggo nggo imba di zha ma nggo, imba vu ma gri ni kuma yi.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nggo a nggurr surr, Yahuda zzu kuma ni Yesu ku, na da di “Unitsarr!” na ma anta. ");
INSERT INTO ninNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Anishirr ba ki Yesu kpa na vu ma. ");
INSERT INTO ninNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Uyirr nu umi ku awurr na aha ba kri gagami na ku, na ki ungo ttu anjingba, na sarr utu ku ugarr a ankpye unkpi abikye wa ttu ta yo. ");
INSERT INTO ninNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu zhi ba di, “Imba kye di ingga su unayi mu, ni nga ni ingga ku ni injingba na ankpunkpu inkinkurr ta ni vu ingga? ");
INSERT INTO ninNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ttuttumi ingga kri di tsarr imba nu Uki Unkpi ku Ibarr Abachi ku, imba si vu ingga hen. Inkindirr inggi i na meme nggo a charr nu Ungbamvu ku Abachi ku ni itu mungga.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Abiga ma ba kru nggarr nado namri na du ma. ");
INSERT INTO ninNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Uvuvurr nze numa nggo so ga Yesu, a kri na garr upri inkru, na si surr inkindirr nu umi hen. Aba ta vu ma. ");
INSERT INTO ninNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Uwa kru huzzu ni ihorr mi, na ka upri inkru ku du ba na ango, na kuma. ");
INSERT INTO ninNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aba gri Yesu na ko ni iko yi ankpye unkpi abikye wa, nu nggo ankpinkpye abikye ba namri, na akikre anishirr, na abitsarr na Are ba a nggurr bi. ");
INSERT INTO ninNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Biturr di ga ba gbagba mu, rri ko nu ure̱ ki iko ku ankpye unkpi abikye wa. Biturr ku ji so na abi gbye ma ba, na so vri uru. ");
INSERT INTO ninNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ankpinkpye abikye ba na Akaba anu Yahuda ba wemi, a so zha anishirr ba nggo ta da inkindirr indanda ni itu ima yi, da aba ka ngu ma, na si hi anishirr hen. ");
INSERT INTO ninNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Anishirr shishemi a bre imu ni itu Yesu, are ambarr ka si mirri ni ikpa hen. ");
INSERT INTO ninNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Abanu gru kri na bre are ka imu ni itu ima yi di, ");
INSERT INTO ninNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Inta wo ma so da di, ‘Uki Unkpi ku Ibarr Abachi ku, nggo a me ku na ango ka unushirr, ingga ta tsi ku nggarr, ni ta vu ku me ni ivi itarr, ni si ta me ku na ango ka unushirr zizo hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Meme mi are ambarr ka si mirri hen. ");
INSERT INTO ninNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ankpye unkpi abikye wa gru kri na anke̱ ambarr ka na zhi ma di, “Yesu, uwanggo sa are ka nggo a so bre ni itu muwa, ùwà da da angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yesu so gbangbami, na si da ba inkindirr mremremu hen. Ankpye unkpi abikye wa zhi ma zizo di, “Uwa yo su Kristi, nggo su Uvuvurr Abachi wa nggo a di gbyarr ku asa?” ");
INSERT INTO ninNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu ddu ba di, “Yo-o, a si ingga yo! Imba ta hi ingga Uvuvurr a Unushirr nggo ingga ta so nu ungo ri ku Unukyekye wa, ni ta nga na akpa ka unkplassu ka.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ankpye unkpi abikye wa ki unfu na nga ankru ama ka hre na da di, “Inta si zha undurr numa bu da inkindirr mu na ku zizo hen? ");
INSERT INTO ninNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Imba wo ire̱ are inggi yi, nggo à da are andanda ni itu i Abachi. Imba da anggi?” Aba da na angu ayirr di ugo wa a la ure, à ma ni tsi ngu. ");
INSERT INTO ninNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Abanu gru so ddu antinte surr ku nu ukpa, na ki ungo ttu ku ashishi ka, na kirr ma, na zhi ma di, “Da undurr wa nggo a nggurr uwa?” Abi gbye ba vu ma na so rɨ ma meme. ");
INSERT INTO ninNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nggo Biturr so ni ikashirr iki yi nu ure̱ ku, uva numa, nggo su uyirr nu umi ku agarr ba ankpye unkpi abikye wa, nga nabo. ");
INSERT INTO ninNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nu unggo, uva wa hi Biturr so vri uru nu ure̱ ku, na kye Biturr girr, na du ma di, “Uwa mi di ga Yesu anu Nazareti wa meme.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Biturr kisa di, “Ingga si hi inkindirr ima nggo uwa so da yi hen.” A da meme, na gru huzzu kuma na anko akaba wa. Meme nggo, agba wa tu. ");
INSERT INTO ninNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Uva wa ko ku hi ma nabo zizo, na gru so tsarr abi kri nabo ba di, “Ugo nggo mi su uyirr nu umi umbarr ku.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Biturr kisa zizo. Abi kri nabo ba gru so ddu Biturr di, “A su ure ujiji. Uwa se na ba. Uwa sa anu Galili. Si kpa kisa hen.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Biturr shi azhi zhi kisa di, “Ingga da ki imba ure ujiji. Ingga si hi undurr wa ma nggo imba so da ma hen. Ingga ti hi ma, Abachi bi nggurr ingga ngu.” ");
INSERT INTO ninNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ni inkpu ima yi, agba wa tu inkpu iha yi. Biturr ssu hi nu nggo Yesu da ku di, “Agba wa taka nise tu ki inkpu iha, uwa ka kisa ni ingga ku ki inkpu itarr ba.” Biturr gru ko yi kpokpo. ");
INSERT INTO ninNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ni gambre bwu, ankpinkpye abikye ba, na akikre anishirr ba, na abitsarr na Are ba, na Akaba anu Yahuda ba, ndo nu uki ku we, na ssubi. Na yo ku Yesu ache, na gri ma ga ku Bilatu (Uttu wa sa anu Roma nggo so gri ba na anga ka Yahudiya ka.) ");
INSERT INTO ninNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatu zhi Yesu di, “Nggi su uwa mu su uttu anu Yahuda wa?” Yesu kpanye ku di, “Nggo uwa da.” ");
INSERT INTO ninNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ankpinkpye abikye ba a so di tto Yesu na are ki imu shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilatu zhi ma zizo, “Uwa si ta da inkindirr hen? Uwa si wo are ka nggo a gri nga shishemi ni itu muwa hen?” ");
INSERT INTO ninNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu si da inkindirr zizo hen. I Bilatu a ku ayisurr. ");
INSERT INTO ninNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ttuttumi ni Iga i Ivu Sarr yi, Bilatu di ttu unushirr uyirr huzzu ni iharr, wanggo nggo anishirr ba ti barr ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ni ivi ima yi, ugo numa a ri Barraba, nggo a harr ma ndo na abanu nggo a tto itsi na di ngɨ anishirr. ");
INSERT INTO ninNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nggo, akpa anishirr wa chinga na so zhi Bilatu inkindirr inggi yi nggo à di na ku aba ttuttumi nggo. ");
INSERT INTO ninNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatu zhi ba di, “Imba zha di ingga bi ttu uttu anu Yahuda wa huzzu ki imba?” ");
INSERT INTO ninNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Bilatu mi hi kakami nggo ankpinkpye abikye ba a gri Yesu ni nu ma, na ttu ashishi na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ankpinkpye abikye ba ddu anishirr ba, da ba di a bu du Bilatu ttu Barraba nggo nu ba. ");
INSERT INTO ninNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatu a zhi ba zizo, “Angginggi ingga ta na nu uyirr wa nggo imba yo ma du uttu anu Yahuda wa?” ");
INSERT INTO ninNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Aba da hantu, “Kpa ma nga nu unkunkurr!” ");
INSERT INTO ninNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatu zhi ba di, “A la angginggi?” Aba du nu ukorr unkpi na so da di, “Kpa ma nga nu unkunkurr ku!” ");
INSERT INTO ninNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatu zha du uwa ta su ku anishirr ba isisurr na ttu Barraba ttungo, na ba Yesu nu abi ta iku ba, da a bu hlo ma na gri ma ku kpa nga nu unkunkurr. ");
INSERT INTO ninNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Abi ta iku ba gri Yesu na rri kuma nu umi ku ando a ugona wa, na yo inkpu i abi ta iku yi we. ");
INSERT INTO ninNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Aba so sarr ma na surr ku ikpo ankru isisarr i uttu yi, na nyarr intto turr ku ni itu ki anzɨ, ");
INSERT INTO ninNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","na kuttu na so chi ma di, “Uttu anu Yahuda, izhi muwa yi bu so sese!” ");
INSERT INTO ninNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Na so hlo ma ba ni itu ni unflankurr, na so ddu antinte surr ma, na kuttu ku na agbuzzu da aba so chi ma. ");
INSERT INTO ninNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nggo, a sarr ma kre, na ttu ikpo ankru isisarr i uttu yi glo ku, na ka angbanja iki ama ka surr ku, na gri ma huzzu kuma nu unto ki kpa nu unkunkurr ku. ");
INSERT INTO ninNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nggo a so gri Yesu ko yi kpa, na zzu ma nu ugo numa nggo ri Sima, aki a Alezanda tuku Rufo, à sa anu Sirrene, na so rri nga nu umi ìgbù ku. Aba turr ma du ma ba unkunkurr ki kpa Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Na gri Yesu kuma nu unto numa nggo a yo ku du Goligota, (a yo ku meme nggo da su Unto Ku Ukpahe (Uttuttu) Ki Itu.) ");
INSERT INTO ninNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nabo yo, aba ku ni Yesu ahi wa nggo a zɨ na ahun ka nggo a ri mârr. Yesu ka iso wa. ");
INSERT INTO ninNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mre na kpa Yesu nu unkunkurr ku, na vu iki isurr ima yi ga. Na turr kye ku ikpa ka uwatanggo à ta kpa ankru atakangga. ");
INSERT INTO ninNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nggo si itirr ambrè, aba kpa Yesu. ");
INSERT INTO ninNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na charr ikpala ima yi nggo a vu ma na yi di: “UTTU ANU YAHUDA WA.” ");
INSERT INTO ninNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Na kpa abayi banu aha ndo na ku ni inkinkurr i ambarr, uyirr wa nu ungo ri, uyirr wa nu ungo mla.  ");
INSERT INTO ninNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nu nggo yo Ungbamvu ku Abachi ku da jiji di, “A bre ma surr nu umi ka bi ila ure.” ");
INSERT INTO ninNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Anishirr ba zzu di ga anko wa ba nabo, na mɨ atu, na so da are andanda ni itu ima yi di, “Mhnn! Uwa yo da du uwa ta ddu Uki Unkpi ku Ibarr Abachi ku, na ta me ku ni ivi tarr! ");
INSERT INTO ninNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","I-i! Ziza, ji nu unkunkurr ku ni kpa itu muwa ttungo ki!” ");
INSERT INTO ninNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ankpinkpye abikye ba na abitsarr na Are ka Musa ba a me̱ Yesu na re ni ikpa, na da di, “A hi aza ka ikpa abanu ttungo, na si kpa itu ima ttungo hen! ");
INSERT INTO ninNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Du Kristi wa nggo su uttu anu Israila wa, bi ji nu unkunkurr ku zizami, na di inta bi kye, ni bi yo isisurr na ku!” Aha ba nggo kpa ba ndo na ku à sarr ma meme. ");
INSERT INTO ninNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nggo, azhi wa ga na atsutsu, ibwu kri igbu wa namri, nga ni itarr yi ingbahru. ");
INSERT INTO ninNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ni itarr yi ingbahru yi, Yesu nggarr yi kpokpo na da di, “Eloyi Eloyi, lama sabachtani?” A da di, “Abachi mungga, Abachi mungga, angginggi du uwa kà ingga du?” ");
INSERT INTO ninNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Inkpu anishirr yi nggo a se nabo a wo ma ni da yi, na da di, “Wo yi, a so yo Iliya.” ");
INSERT INTO ninNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Uyirr nu umi ambarr, ku kru ko ku ba usoso yo nu umi ku ususa ahi na ka ti turr ni itu unflankurr, na gɨ kuma ku Yesu na angu, na so da di, “Inta ta kye ka Iliya ta nga ni ttu ma ji.” ");
INSERT INTO ninNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yesu garr angu yi kpokpo mre, na ttu. ");
INSERT INTO ninNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Upri nkru ku u di klo nu Uki Unkpi ku Ibarr Abachi ku u nggarr ki uha ba, zhi na atu ji nga na achi ka. ");
INSERT INTO ninNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ankpye uni ta iku wa, nggo kri ni ichi yi unkunkurr yi nggo kpa Yesu, a hi nggo Yesu ttu, na da di, “Ugo wa su Uvuvurr Abachi jiji!” ");
INSERT INTO ninNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amba banu a se nabo, na kri kre mu, na so kye ma. Nu umi ambarr ku, Maryamu nggo zhi nu igbu nu Magadala, nu Salomi, nu Maryamu ayirr anu Yakubu uvutsa wa tuku Jose, na abanu shishemi. ");
INSERT INTO ninNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aba yo di ga Yesu nggo a di so nu Galili, na so di zi ma undu ku, na amba banu shishemi nggo nga ndo na ku zhi nu Urushalima na se na ku. ");
INSERT INTO ninNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","A sa azhibarr a issubi wa (na ambre ka uha ka, uwa ta sa Asabarr, azhibarr a isu anu Yahuda wa). Nggo ni ingbahru yi, ");
INSERT INTO ninNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ugo numa a ri Isuhu, unushirr nu Arrimatiya a nga. A su uyirr nu umi ka akikre ba Yahuda ba, nggo a di kye ma ssu nu ungo, uwa mi a su nu umi ki so kye anko nggo Abachi ta ka so ni ittu ima yi. A kuma kyekye mi nu Bilatu ku, na ko ku barr ma, da bi nu uwa iku i Yesu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatu a ku ayisurr nggo a wo di Yesu ka ttu ba. Na yo ankpye abi ta iku wa, na zhi ma di, “Yesu à ttu ngbangbamu?” ");
INSERT INTO ninNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nggo a wo na ankpye wa, Bilatu kpanye ku Isuhu di a bu kuma ku ba iku Yesu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Isuhu ku re upri inkru ukukla ki izzu ku, na hun ku ttu iku yi ji, na nyarr yi nu upri inkru ku, na ba iku yi ku yo ni ibe yi, nggo i su nu Uko uhan, na ku nyi ankɨ ingbinta ankpi ni ttu angu ka Uko uhan ka. ");
INSERT INTO ninNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryamu nggo zhi nu Magadala tuku Maryamu ayirr Jose, a so kye, na hi unto ku nggo a yo ma. ");
INSERT INTO ninNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nggo Asabarr, Azhibarr a Isu anu Yahuda wa vu sarr, Maryamu nggo zhi nu Magadala tuku Maryamu ayirr anu Yakubu, u Salomi, a re anye a ihun ingba wre nggo aba ta ku surr ki iku i Yesu yi. ");
INSERT INTO ninNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Na ambre bwu, na azhibarr a uha wa, nggo anza wa a gru ba, aba kuma ku rri ni ibe i Uko uhan yi. ");
INSERT INTO ninNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Aba zzu di zhi ikpa na anko di, “Unggonggo ta ku nyi ingbinta yi ka ki inta ni ibe yi?” ");
INSERT INTO ninNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ingbinta si inkpi yi. Nggo a ko ku kye, na hi a ka nyi ingbinta yi glo ba. ");
INSERT INTO ninNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Na ko ku rri kuma nu umi ku Uko uhan ku, na ko ku hi uvuvurr nze so na anga ungo ri a ibe wa, na so ttu ikpo ankru akikla. Isisu ki ba. ");
INSERT INTO ninNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Uwa ddu ba di, “Imba si kru isisu hen! Ingga hi imba so zha su Yesu, anu Nazareti yo, uwanggo nggo a kpa ma nggo. A tasi. A si se hen. Imba kye yi, uwanggo yo su unto ku nggo a ka ma yo. ");
INSERT INTO ninNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ziza nggo, kakuma yi, ni kuma ku da ki Biturr na abiga ma ba: ‘A so ku ki imba ichi kuma nu Galili; imba ta ko ku hi ma nabo, nâ ta si nggo a da ki imba bari na ka ttu.’ ” ");
INSERT INTO ninNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aba ka huzzu nu ukru zhi ni ibe i uko uhan yi. Ukpa ambarr ku wri kpakpa. Aba si da ku undurr inkindirr ima yi hen, nggo isisu ki ba.  ");
INSERT INTO ninNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nggo Yesu à tasi ni gambre yi, na azhibarr a ime̱me̱ wa (nu ugo ku azhibarr a isu wa), uwa huzzu me̱me̱ yi ku Maryamu nggo zhi nu Magadala, nggo Yesu à han izhi ndanda itangba huzzu ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Maryamu nggo zhi nu Magadala, kuma na ko ku da ba abangga ba nggo di ga ma. Aba so ri amarr na so yi. ");
INSERT INTO ninNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nggo, a wo di Yesu tasi; du Maryamu nggo zhi nu Magadala à hi ma, aba si kpanye ni da ima yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nu ugo ku meme, Yesu huzzu na ashishi numa nanka ku anishirr aha banu, a so zirr na anko na so zirr huzzu kuma ni ìgbù numa. ");
INSERT INTO ninNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Aba ko ku da ku abiga ma abanu ba. Aba mi si kpanye hen. ");
INSERT INTO ninNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ni ikikre yi, Yesu huzzu ku abiga ma awurr na yirr ba, nggo a so, na so ri ila. Uwa glo ba ni kà iyo isisurr ambarr yi, ni itsɨ kyekye ambarr yi nggo a si kpanye na abangga ba nggo hi uwa ni tasi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Uwa da ba di, “Kuma yi ni ingbingbru yi wemi ku bre ku anishirr Ure ku wre ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uwanggo nggo ta kpanye nu Ure ku wre ku, aba bi zzu ma na amasirr, Abachi ta kpa ma ttungo. Uwanggo nggo ta si kpanye nu Ure ku wre ku hen, ila ure ima yi i ta so ku ni itu ima sese. ");
INSERT INTO ninNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abangga ba nggo ti yo isisurr imbarr yi ni ingga ku, ingga ta nu ba ukyekye ku nggo: A ta han izhi ndanda huzzu ni isa mungga; na ta re ni irrirri ihe̱he̱, nggo a nise tsarr ba na yi. ");
INSERT INTO ninNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Inkindirr ndanda si ta ki ba hen, ka ti vɨ ànìwǎ, ka ti so itsɨ. A ta sa ango ambarr ka na abi vri ba, aba ta wre.” ");
INSERT INTO ninNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu ugo ku nggo Yesu re na ba, aba ba ma hun kuma nu unkplassu. Uwa ko ku so nu ungo ri ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Abiga ma ba kuma ko ku di bre Ure ku wre ku kago. Atiko wa so na undu na aba, na tsarr di ibre imbarr yi si jiji, zhi nu nggo a nu ba ukyekye ki na iki ikagri.");
INSERT INTO ninNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ingga chi uwa, ankpye Tiyofilo. Anishirr shishemi a ka ta ukpa na charr aseki angga ka nggo Yesu à na ka, nggo a di so ni inta ba. ");
INSERT INTO ninNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","A charr aseki kama nggo inta i wo na angu ka abangga ba nggo a di ga ma, na hi na ashishi, zhi ni ime̱me̱ yi, na bre surr ku anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Meme yo, ingga ji so kpi mi ni bre aseki ka we nggo a na zhi ni ime̱me̱ yi, ni kye i ta wre ingga bu charr ku ùwà, ankpye Tiyofilo, aseki ka na chi na chi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ingga na meme wre ku ùwà bu hi da aseki akama namri nggo a charr ku ùwà na ka a sa ajiji. ");
INSERT INTO ninNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ni ivi yi nggo Hirridu nggo su uttu unkpi wa nggo di gri anga ka Yahudiya ka, ugo numa à su unikye nggo a yo ma du Zakarriya. A zhi ni inkirr i abikye yi nggo a yo ba di Abija. A su uhanma a Aruna. Ayamba ama yo su Alisabatu. Uwa mi su uhanma a Aruna meme. ");
INSERT INTO ninNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zakarriya tuku Alisabatu, aba aha mi a zirr wre na anke̱ ka Abachi, na di kru isisu iba i Atiko yi namri. Na si jaku ni inkpi iyirr mi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Alisabatu à su nu ukru. Aba aha mi a ka kuyi ba, ni ima yo aba so sama nu uvuvurr. ");
INSERT INTO ninNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na azhibarr numa nggo uwa a su ku abikye bu Abija ba undu umbarr, u Zakarriya nggo à so na undu ku unikye umaku nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A hla Zakarriya hihla mu nâ ta si nggo a di na na adu ambarr a abikye wa di a bu rri nu Uki Unkpi ku Ibarr Abachi ku, ku tu iki ihun ingba nggɨnggɨ yi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nggo a so tu itu iki ihun ingba nggɨnggɨ yi, i so kparri nggo, abi nga ni barr Abachi ba shishemi so barr na ábì. ");
INSERT INTO ninNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mre, unitu a Abachi wa nggurr huzzu nu Zakarriya ku, na nga ni kukri na anga a ungo ri a akikre ka a so tu iki ihun ingba nggɨnggɨ yi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nggo Zakarriya sa ashishi na ku na ki wu, isisu ki ma. ");
INSERT INTO ninNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Unitu wa à ddu ku di, “Zakarriya si ki isisu hen, Abachi à wo ibarr imuwa yi, uwami wa Alisabatu à ta ngri ku ùwà uvuvurr, ùwà ta yo ma du Yohana. ");
INSERT INTO ninNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ùwà ta se ni inyarr kakami ni itu ima yi, anishirr shishemi ta me̱ nyarr ni ingri ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","A taka su unkpi na age̱ ka Atiko, na si taka so ahi ka inkindirr yi nggo di ki ihwa mremremu hen. Zhi ni ingri ima yi Izhi i Abachi yi taka rri so na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A taka du anishirr bu Israila shishemi a kanga na Atiko Abachi ambarr wa ku. ");
INSERT INTO ninNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Uwa yo ta su uwanggo taka nga kuchi, bari Atiko wa taka nga. Nggo à ti nga, uwa taka ni na undu nu ukyekye tuku izhi iyiyirr ima yo ni inggi yi nggo Iliya à na undu umaku na yi nggo. À na meme wre ku ka ni nggurr akiki bi na amumarr, ni taka ni na abi kà iwo ure ku Abachi ba ki anishirr azizi, nggo ta se na amarr ka ina wre, nâ ta sa anishirr ba Abachi. À ta du anishirr ssubi, na so kye anko a inga i Atiko yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakarriya à zhi unitu wa di, “Ingga ta na kingginggi ni ta hi di ida muwa yi ta su jiji? Ingga nggo su uchuche mu, u ayamba mungga wa mi su uchuche mu meme.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Unitu wa ddu ma di, “Ingga yo su Gabre, ingga di kri na age̱ ka Abachi. Uwa yo tu ingga nu Ure ku wre ku nga nu ùwà ku. ");
INSERT INTO ninNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Nu nggo ùwà si kpanye nu ure ku nggo ingga da ku ùwà hen, ni ima yo, bazhi ziza ùwà taka di so ywiywimi, sa ni ure, kuma na azhibarr wa nggo ayamba muwa wa taka ngri uvuvurr wa. Wanggo yo si inkindirr yi nggo ùwà taka hi yi nu nggo ivi yi ti ma.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Meme nggo, anishirr ba nggo a kri bi Zakarriya na ábì ka Uki Unkpi ku Ibarr Abachi ku a gru so ki isisu da a su ku anggi mu uwa à rri ku so gbami nu umi uki ku. ");
INSERT INTO ninNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Zakarriya à huzzu nggo na re chankarr, anishirr ba a hi ni ima yo da Abachi à tsarr ma inkindirr nu Uki ku Ibarr ku. Ima yo du ma kye na so ki ba na ango, na so jinjirr mi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nggo ivi i undu i Zakarriya nu Uki Unkpi ku Ibarr Abachi ku i vu sarr, uwa kakuma ni iko. ");
INSERT INTO ninNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nu ugo ki ivi ima yi, Alisabatu ayamba ama wa hru ine, na di so ba nu uki mu ki ihwa ikywi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Na da di, “Kye bari, ziza yo Atiko na ki ingga inkindirr inkpi inggi yi. Atiko tsarr ingga ikpanye ima yi ni ivi inggi yi. A ttu ishisha glo ki ingga na anishirr ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nggo ine i Alisabatu yi ki ihwa itani, a Abachi tu unitu ama wa Gabre ni igbu nu Nazareti na anga ka Galili, ");
INSERT INTO ninNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","nu uva numa ku nggo a nise hi unuru kye, nggo a yo ma di Maryamu. Ugo numa nggo a yo ma di Isuhu, uwa yo à go ma. Ugo wa su uhanma a uttu Doda. ");
INSERT INTO ninNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Unitu wa à nye na ku, na ku da ku di, “Ingga chi ùwà, ùwà nggo Abachi na wre ku ùwà kakami! Abachi se nu ùwà ku.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maryamu ki wu kakami, nggo a wo ichi ima yi, na so ri amarr ni itu i inkpi i ichi ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Unitu wa ddu ma di, “Maryamu si ki isisu hen, sa Abachi nggo à ta na wre ku ùwà kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Uwa ta hru ine, ni ta ngri uvuvurr ni ta yo ma di Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Uvuvurr wa taka sa ankpye. Anishirr ta yo ma du Uvuvurr a Abachi Unkpi Kakami wa. Atiko Abachi taka ni du ma à ri ittu i ábáchí ma, uttu Doda. ");
INSERT INTO ninNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Uwa yo taka su uttu a ahinhan bu Yakubu ba sese. Ittu ima yi taka sama ni ikikre.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","U Maryamu ddu unitu wa di, “Ingga ni su uva mu bari, unuru nise hi ingga kye, i ta na ki ngginggi ni si ki ingga meme?” ");
INSERT INTO ninNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Unitu wa ka sa ku di si, “Izhi Iwre i Abachi yi mu i ta ji nu ùwà ku, ukyekye ku Abachi Unkpi Kakami wa ta ni ttu ùwà kago. Uvuvurr wa nggo ùwà ta ngri, a ta sa ni ìlà. Aba ta yo ma du Uvuvurr a Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kye, iwrimi Alisabatu, nggo a da di à se nu ukru, à se ni ine ihwa itani ziza, ni ichiche ima inggi yi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Inkindirr sama nggo ka mri Abachi ina.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","U Maryamu ddu ma di, “Ingga su ugarr a Atiko. Abachi bu na inkindirr yi nggo iwre ku ni itu mungga, nâ ta si nggo ùwà da.” Unitu wa à ka ma du. ");
INSERT INTO ninNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ni ivi ima yi, i Maryamu gru ssubi na narr kuma na Alisabatu ku ni iko ima yi, ni ìgbù na agbre wa na anga ka Yahudiya ka. ");
INSERT INTO ninNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nggo Maryamu a nggurr surr ni iko i Zakarriya, na sa ashishi na Alisabatu ku, na chi ma. ");
INSERT INTO ninNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nggo Alisabatu wo ichi i Maryamu yi, u uzuma wa nu umi ine ku a ki wu, Izhi i Abachi yi mirri ku Alisabatu nu ukpa. ");
INSERT INTO ninNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Alisabatu da hantu di, “Ùwà yo sa ayamba wa nggo Abachi yo ku ùwà angu ka iwre mri amba ba namri. Abachi yo ku Uvuvurr wa nggo ùwà ta ngri ma angu ka iwre meme! ");
INSERT INTO ninNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Angginggi du inkindirr inkpi ma mi nga ni ingga ku, nggo uwa ayirr a Atiko mungga wa gru nga ni ingga ku? ");
INSERT INTO ninNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ankpa yirr nggo ingga wo ichi muwa yi, u uvuvurr mungga wa nu umi ine à gru ta inyarr. ");
INSERT INTO ninNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Abachi yo ku ùwà angu ka iwre nggo ùwà kpanye du ure ku Atiko ku nggo a tu ba nu ùwà ku, bu si meme!” ");
INSERT INTO ninNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamu da di, “Isisurr mungga yi ko nyarr ku Atiko. ");
INSERT INTO ninNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ingga nyarr ku Abachi nggo à kpa ingga ttungo. ");
INSERT INTO ninNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ingga nggo si si inkindirr hen, Abachi ssu ingga ugarr ama wa hi. Bazhi ziza, ùka ku anishirr namri ta di yo ingga du ayamba wa nggo Abachi yo ku angu ka iwre, ");
INSERT INTO ninNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","nggo Abachi Unkpi wa, na ki ingga inkindirr inkpi inggi yi. Isa ima yi si iwre. ");
INSERT INTO ninNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nggo a se ni itito ni itu i abi kru isisu ama ba, bazhi nu ùka numa kuma nu numa. ");
INSERT INTO ninNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Abachi na ungo uma ukyekye ku nà na undu unkpi. A tse abi nggurr anke̱ kahre, na abangga ba nggo di ri amarr inkindirr inkpi na atu a ambarr wa. ");
INSERT INTO ninNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Abachi ddu atuttu ankpinkpi ji ni imburr imbarr yi, na gɨ abangga ba nggo si si inkindirr hen gru. ");
INSERT INTO ninNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na nu abi ki iyo ba iki iwre shishemi, na du abu ungo ba kakuma na ango aha. ");
INSERT INTO ninNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","A gri ure umaku nggo a da zu ku ábáchí munta ba, du uwa taka ni kye agarr ama ba Israila, na ashishi ka itito. ");
INSERT INTO ninNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Na kye Ibrayi na ahinhan ma ba na ashishi ka itito ase na ase nâ ta si nggo a ka da zu ku ábáchí munta wa ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","U Maryamu so ni Alisabatu iwrima wa ku ki ihwa itarr bari na kakuma ni iko nu Nazareti. ");
INSERT INTO ninNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nggo ivi i ingri yi nga ku Alisabatu, uwa ngri uvuvurr unuru. ");
INSERT INTO ninNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Abi girr ama ba na amla ma ba a wo inkindirr inkpi i itito ima yi nggo Atiko na ku Alisabatu na zi ma inyarr. ");
INSERT INTO ninNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nggo uvuvurr wa à ki ivi itandarr ni ingri, aba nga ni yo ku iji, na gru so ri amarr ka yo ku isa i aki yi du Zakarriya. ");
INSERT INTO ninNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ayirr wa kisa na da di, “Iya! A ta yo ma du Yohana.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Aba a kisa ku di, “Umlama numa à si ri Yohana hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aba zhi aki wa na ango di a bu yo uvuvurr wa du unggonggo. ");
INSERT INTO ninNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","U Zakarriya da ba na ango di a bu gri ku uwa inkindirr numa nggo uwa ta charr na yi. Nggo a gri ku na yi, uwa kpa yi na charr di, “Isa ima yi ri Yohana.” Aba kukri na so vu angu gri. ");
INSERT INTO ninNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na ankpu yirr, irrirri ima yi gbuddu ku, uwa gru so re na ba, na so nyarr ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Isisu ki abi girr ama ba, anishirr ba gru ku di bre are akama kago ni ìgbù i agbre yi na anga ka Yahudiya ka. ");
INSERT INTO ninNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nggo anishirr ba wo ure kuma na gru so ta amarr ni itu yi na so bi zhi di, “Uvuvurr wama taka sa angginggi?” Nggo a hi ungo ku Abachi ku u se ku ni itu. ");
INSERT INTO ninNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Izhi yi Abachi yi mirri ku Zakarriya aki a Yohana wa, uwa gru so da ure zu di: ");
INSERT INTO ninNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Di inta nyarr ku Atiko Abachi a ani Israila! Nggo a nga nye zi anishirr ama ba na ddu ba ttungo. ");
INSERT INTO ninNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nggo a ni inta uni kpa ttungo unkpi, zhi nu uga ku Doda ugarr ama wa. ");
INSERT INTO ninNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nâ ta si nggo Abachi à da zu na angu ka abi kpa are ama abi wre ba ngbangbamu. ");
INSERT INTO ninNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na da du uwa taka ni kpa inta ttungo nu ungo ku abi kà inta ba, abangga ba nggo sa abi karr inta. ");
INSERT INTO ninNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Na da zizo du uwa taka kye ábáchí munta ba na ashishi ka itito, na ssu ishi azhi iwre ima yi hi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ishi azhi yi nggo à da zu ku ábáchí munta wa Ibrayi, ");
INSERT INTO ninNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","du uwa taka ni ddu inta ttungo na ango ka abi karr inta ba, di inta ga ma sa ni isisu, ");
INSERT INTO ninNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ni si ni isisurr i iwre ni izirr zizi na age̱ ka Abachi nggo inta ti so ni ingbingbru inggi yi. ");
INSERT INTO ninNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Uzumu, à ta yo ùwà ki uni kpa are a Abachi Unkpi Kakami wa. Ùwà yo ta kuchi ku Atiko ku bi na anko wa ssubi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ùwà yo ta ku bre ku anishirr da Abachi ta nggurr ila ure imbarr yi zhi, na kpa ba ttungo. ");
INSERT INTO ninNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Itito i Abachi yi si shishemi. Ima yo du ma ni inta uni kpa ttungo wa, nggo si nâ ta si anza ambre wa nggo la zhi nu unkplassu ji nga ni inta ba. ");
INSERT INTO ninNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Na la ku abi so ni ibwu ba tuku abi so ywhiywhirr ni ittu, na ta tsarr inta anko a isu isisurr.” ");
INSERT INTO ninNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Uvuvurr wa furr ki unkpi, na tsɨ kyekye ni Izhi i Abachi yi, na gru ku di so na ankpuji, kuma ni ivi yi nggo a nggurr huzzu ku anishirr bu Israila ba. ");
INSERT INTO ninNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ni ivi yi nggo uttu unkpi wa nggo a ri Kayisa Agostu à gri anga ka Roma ka, na da di a bu bre anishirr ba nggo uwa so gri ba nggo namri. ");
INSERT INTO ninNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Uwama yo si ibre anishirr ime̱me̱ yi na ase ka nggo Kwirrinu à su ugona nu Sirriya.) ");
INSERT INTO ninNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Anishirr ba we à so kuma ni igbu imbarr yi, di bu ku charr asa ambarr wa. ");
INSERT INTO ninNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Isuhu a di so nu Nazareti na anga ka Galili ka, na gru kuma meme na anga ka Yahudiya ni igbu a Doda wa, nggo a yo ma du Betalami, nggo uwa mi su uhanma a uttu Doda. ");
INSERT INTO ninNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Isuhu à gru kuma ni icharr yi nggo na gri Maryamu, uva wa nggo à go ma ta garr. Uwa à se ni ine i ko ma ku ingri. ");
INSERT INTO ninNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nggo aba se nabo, ivi ingri yi ma ku. ");
INSERT INTO ninNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Uwa ngri uvuvurr ama ni ime̱me̱ wa, unuru, na nyarr ma ttu na angbanja iki na ka ma yo nu ungblo. A si hi uki ni iko ikpa abichirr yo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na anga kama abi ho aminta banu a kurr ywhiywhirr nabo, na so gbye aminta ambarr ba ni ibittu. ");
INSERT INTO ninNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Unitu a Atiko wa à nga na ba. Inkpinkpye tuku ukyekye ku Abachi ku u ji nga na ba, abubo wa la zanzarr kago ba, isisu ki ba. ");
INSERT INTO ninNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Unitu wa da ba di, “Imba si kru isisu hen! Ingga gri ki imba Ure ku wre ku, ure ku nggo anishirr we ta me̱ nyarr kakami na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kye! Ari a ngri ki imba Uni kpa ttungo nu Betalami, igbu a uttu Doda wa. Uni kpa ttungo wa yo su Kristi, Atiko wa. ");
INSERT INTO ninNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Inkindirr yi nggo ta ku tsarr imba na ku inggi si di, imba ta ku hi ba a nyarr uvuvurr na angbanja iki na ka ma yo nu ungblo.” ");
INSERT INTO ninNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Mre, abitu ba Abachi shishemi nu unkplassu a nggurr huzzu ni nggurr bi nu unitu wa nggo ku, na so ru ku Abachi asarr da di, ");
INSERT INTO ninNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Di inta nyarr ni gbyarr ku Abachi asa, nggo sa ankpye nu unkplassu, du anishirr ba ni imimi nggo Abachi kpanye na ba, a bu so ni isu isisurr.” ");
INSERT INTO ninNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nggo abitu ba Abachi ba ka hun kuma nu unkplassu, abi ho aminta ba gru so da ni ikpa di, “Di inta kuma nu Betalami, ku kye inkindirr inggi yi nggo la nabo, nggo Atiko wa da ki inta.” ");
INSERT INTO ninNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Na gru korrmi kuma, na ku hi Maryamu tuku Isuhu ndo nu uvuvurr wa, aba ka ma yo nu ungblo. ");
INSERT INTO ninNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nggo a ko ku hi uvuvurr wa, na bre are ka kago nggo unitu wa da ba ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Abangga ba nggo wo are ka namri, nggo abi ho aminta ba a da, a ku ayisurr, na aseki ka nggo a da ba. ");
INSERT INTO ninNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","U Maryamu gri aseki angga ka we ni isisurr ima, na so di ri amarr na atu ambarr wa. ");
INSERT INTO ninNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nggo abi ho aminta ba so kakuma, na so di gbyarr ku Abachi asa ga anko ku inkindirr yi nggo aba wo na ku hi, i si meme yo nâ ta si nggo a da ba. ");
INSERT INTO ninNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na azhibarr a utandarr wa, aba yo ku iji, na du ku isa di, Yesu. Uwa yo si isa yi nggo unitu a Abachi wa da ba, nggo a nise hru ine ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nggo Maryamu à su ukpa ku ingri ku kre, nâ ta si nggo Are ka Musa a da ba, Isuhu tuku Maryamu a ba uvuvurr wa na kuma nu Uki Unkpi ku Ibarr Abachi ku nu Urushalima ko ku na ma nu Atiko, ");
INSERT INTO ninNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(nâ ta si nggo i kurr ni charr na Are ka Atiko ka di, “Nggo ayamba ti ngri, uvuvurr ni ime̱me̱ nggo su uvuvurr unuru, aba ta gri ma ku nu Abachi.”) ");
INSERT INTO ninNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Aba kuma nu Urushalima, na ko ku na uvuvurr wa nu Abachi, na to ku Abachi aseki ka, nâ ta si nggo i kurr ni icharr nu angbamvu ka Are ka Atiko ka. Aseki ka nggo a di to na ka aka ngga su ananddu aha, ka amumarr aminche aha. ");
INSERT INTO ninNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ugo numa nu Urushalima nggo a yo ma di Simiyo, a su unushirr uzizi na di kru isisu i Abachi, na su uyirr nu umi ku abi gbye anko a uni kpa Israila ttungo wa. Izhi Iwre i Abachi yi se na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Izhi Iwre i Abachi yi a ka tsarr ma da à si ta ttu hen, à taka hi Kristi a Abachi wa ni nga yi bari. ");
INSERT INTO ninNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Izhi i Abachi yi gri Simiyo rri kuma nu umi ku ure̱ ku Uki Unkpi ku Ibarr Abachi ku. Isuhu tuku Maryamu a gri uvuvurr wa Yesu na rri kuma nu umi ku ure̱ ku Uki Unkpi ku Ibarr Abachi ku, nâ ta si nggo iba i Are ka Musa ka da. ");
INSERT INTO ninNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyo kpa uvuvurr wa gri na ango na gbyarr ku Abachi asa da di: ");
INSERT INTO ninNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Zizami, Atiko, ùwà na inkindirr yi nggo ùwà da zu. Meme nggo, ùwà bu du ingga ugarr muwa wa kuma ni isisurr iyirr, nâ ta si nggo ùwà da zu. ");
INSERT INTO ninNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ingga hi Uni kpa inta ttungo wa na ashishi mungga aha, ");
INSERT INTO ninNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","nggo ùwà na ma ssubi na ashishi ka anishirr we. ");
INSERT INTO ninNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Uwa yo taka su ku anishirr ba nggo si si anu Yahuda hen uru ku kye anko ku na taka gri inyarr nga ku anishirr ama ba Israila.” ");
INSERT INTO ninNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Isuhu tuku Maryamu a vu anke̱ gri ni inkindirr yi nggo a wo ma ni ko da ni itu i uvuvurr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simiyo yo ba angu ka iwre, na da ku Maryamu, ayirr a uvuvurr wa di: “Uwanggo su uvuvurr wanggo Abachi hla nggo. À ta du anishirr banu bu Israila ba kuhre, na ta gɨ abanu gru kakami. Uwa yo ta si itsarr i Abachi yi nggo anishirr ta re ndanda ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Uwa yo ta gri amarr ka nggo sharri ni isisurr i anishirr huzzu. Nu ùwà ku, ùwà ta vri isisurr kakami, ivri isisurr muwa yi ta si nâ ta si nggo a nggarr isisurr unushirr na anji.” ");
INSERT INTO ninNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ayamba numa nggo su uni kpa are, a yo ma di Ana. A su uva a Fanuwe, na zhi nu uga ku Asherr. A su uchuche ayamba, nggo a so ase tangba yo tuku uruma wa, u unuru wa ttu. ");
INSERT INTO ninNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Bazhi ni ima mu, uwa di rri so na ako ka, ziza à ki ase iso tandarr na ane̱ (84), na di kuma nu Uki Unkpi ku Ibarr Abachi ku ttuttumi na azhi ni ibittu, uwa di barr Abachi ni ivu angu. ");
INSERT INTO ninNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na ankpu ayirr ama wa, uwa mi nga na anu Isuhu ba tuku Maryamu, ni nyarr ku Abachi, na da ure ni itu i uvuvurr wa na abangga ba nggo so kye anko wa nggo Abachi taka ni kpa Urushalima ttungo nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nggo Isuhu tuku Maryamu a ku kre ina inkindirr yi nggo iba i Atiko yi i da ba nggo, na kasarr kakuma ni igbu ambarr wa nu Nazareti na anga ka Galili ka. ");
INSERT INTO ninNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Uvuvurr wa furr nà na ki ukyekye ni ihi i Abachi yi. Abachi kpanye na ku, na yo ku angu ka iwre. ");
INSERT INTO ninNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Na ase na ase akiki bu Yesu ba di kuma nu Urushalima ku di na Iga i Ivu Sarr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nggo Yesu si na ase wurr na aha, akiki ma ba gri ma na ko ni iga yi, nâ ta si nggo iba yi tsarr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nggo iga yi i kre, anaki ba gru ko kuma ni iko, u uvuvurr wa Yesu ka kukri nu Urushalima. Anaki ba si hi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A kye da à se nu umi ku anishirr ba nggo so kakuma ni iko. Nggo à zirr ku azhi bari na gru so zha ma nu umi ku amla ma ba na akpikpa ambarr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nggo a zha ma chankarr na kakuma nu Urushalima ko i zha ma nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nggo a zha ma ki ivi itarr na ko ku hi ma nu ure̱ ku Uki Unkpi ku Ibarr Abachi ku, uwa rri so na abitsarr ba ba, na so shirr ba atu, na so bu zhi ba are. ");
INSERT INTO ninNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Anishirr ba nggo so wo ma, a ku ayisurr ku ihi ima yi, tuku nggo a so sa ba are ka. ");
INSERT INTO ninNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nggo anaki ba hi ma, na ku ayisurr. Ayirr wa zhi ma di, “Uvuvurr, ùwà na ki inta uwama sa angginggi? Inta tuku aki muwa ko zha ùwà kakami.” ");
INSERT INTO ninNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Uwa zhi ba di, “Imba di zha ingga na angginggi? Imba si hi i si meme yo ingga bu so ni iko i Aki mungga yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Aba si hi inkindirr yi nggo à so da ba hen. ");
INSERT INTO ninNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesu gru ga ba kuma nu Nazareti, na di wo ba ure. Ayirr wa so di vu aseki kama zu ni isisurr ima. ");
INSERT INTO ninNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","U Yesu furr ni ikye hi, nu ukpa ukyekye. Abachi nyarr ma, a anishirr mi nyarr ma meme. ");
INSERT INTO ninNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","A si ni ise iwurr ni kywi (15) i ittu i Uttu unkpi wa nggo a yo ma du Tiberriyosi Siza, ni ivi ima yi u Pontu Bilatu nggo a su ugona nu Yahudiya. U Hirridu nggo so gri anga ka Galili ka, uzayirr wa Filibu nggo so gri anga ka Ituriya ka tuku anga a Trakoniti. Lisaniya nggo à so gri Abilene. ");
INSERT INTO ninNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ni ivi ima yo, anu Anasi ngga tuku Kayafa a si abikye ankpinkpi ba. Ni ivi ima yo zizo, Abachi re nu Yohana uvuvurr a Zakarriya wa, nu ankpuji wa. ");
INSERT INTO ninNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yohana gru di zirr kago anga ka inyi nu Joda wa, na di da ku anishirr ba ure ku Abachi di, “Imba bu kasarr ni ila ure imba yi ni di ingga zzu imba na amasirr, da wre ku Abachi bu nggurr ila ure imba yi zhi.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nâ ta si nggo a charr nu ungbamvu ku uni kpa are wa Ishaya da di: “Undurr so hantu na ankpuji wa, ‘Ssu anko wa bi ku Atiko wa. Na wa ki ntto nggo a taka ni wre ku uzirr. ");
INSERT INTO ninNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","A ta turr imimi surr ttu adduddu, na ta korr iga inki na agbre ki nggi. Na ta na anko ka nggo a kachi ki ntto, na ta na anko ki klon. ");
INSERT INTO ninNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Anishirr namri ta hi ukyekye ku ikpa anishirr ttungo i Abachi yi!’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Akpa anishirr gru nga ni Yohana ku, di a bu zzu ba na amasirr, uwa ddu ba di, “Imba inkirr i andanda ànìwǎ! Unggonggo da ki imba di imba bu kru huzzu nu uje ku nggo Abachi ta turr nga ki imba? ");
INSERT INTO ninNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ziza, imba bu na iki yi nggo i ta tsarr di imba kasarr ni ila ure imba yi. Ni si gru so da na akpambirr di, ‘Ibrayi nggo sa Aki munta’ hen. Ingga da ki imba, Abachi se nu ukyekye ku nggo ka ka angbinta angga ka kasarr kì ku Ibrayi ahinhan ma! ");
INSERT INTO ninNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ibre amu i Abachi yi ku abi la ure ba i ta si nâ ta si nggo a ka iwra nggi nu uzhizhi ku unkunkurr ba. Meme nggo, unkunkurr ku nggo u si klo inkpinkpo iwre hen, aba a ta tse ku ta yo, na ta sarr ku tu nu uru.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Anishirr ba zhi ma di, “Meme nggo, inta bu na sa angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Uwa ddu ba di, “Uwanggo nggo ti se ni inkinkru iha, uwa bu ba ayirr ka nu undurr wa nggo sa na ka. Uwanggo nggo ti se ni ila, uwa bu sha nu undurr wa nggo sa na yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Abi kpa inklo imimi banu nga di a bu ni zzu ba na amasirr, na ni zhi ma da di, “Unitsarr, inta ta na sa angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Uwa ddu ba di, “Imba bu si kpa mri inkindirr yi nggo a di imba bu ku kpa hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Abi ta iku banu gru nga na ku meme ni zhi ma di, “Inta mi na? Inta bu na ki ngginggi?” Uwa ddu ba di, “Si kpa inklo nu undurr ku nu ungbrengbre hen, ka vu undurr ni imu mi hen. Meme imba bu korr angba ni inkindirr yi nggo a di han imba.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Anishirr a so di kye anko a uni kpa ba ttungo wa, abanu gru so ta amarr di mi Yohana yo su Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohana ddu ba wemi di, “Ingga zzu imba na amasirr. Undurr numa so nga nggo a mri ingga. Ingga si ma ni kuklo ni ddu ku anggakpaza ama ka hen. A ta ni zzu imba ni Izhi Iwre yi tuku uru. ");
INSERT INTO ninNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","A gri umumu ku ze ikiri umaku, nggo ta ni hwa ikiri yi, na ta vu izizi yi ku surr ni iwurr, na ta vu intinturr yi surr nu uru ku nggo u si di ka zhi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohana se na anko shishemi nggo à di bre ba Ure ku wre ku da anishirr ba bu kpa ku. ");
INSERT INTO ninNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohana à glo uttu Hirridu, nggo à garr Hirridiya, ayamba a uzayirr wa, nà na aseki numa ndanda shishemi. ");
INSERT INTO ninNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Uttu Hirridu wa a na inkindirr numa ndanda zizo, nggo a yo Yohana nu uki ku harr. ");
INSERT INTO ninNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nggo à so zzu anishirr ba na amasirr, na zzu Yesu meme. Nggo Yesu à so barr, unkplassu ku bwu, ");
INSERT INTO ninNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Izhi Iwre yi, zzu nâ ta si anddu, i ji ni kuso ku. Aba wo ukorr zhi nu unkplassu da di, “Ùwà yo su Uzumu wa, nggo ingga korr angba nu ùwà ku kakami.” ");
INSERT INTO ninNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu à vu undu umaku nggo, na se na ase iso itarr. Anishirr ba yo ma du uvuvurr a Isuhu, nggo su uvuvurr a Heli. ");
INSERT INTO ninNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli su uvuvurr a Matati. Matati su uvuvurr a Levi. U Levi su uvuvurr a Meliki. U Meliki su uvuvurr a Janayi. U Janayi su uvuvurr a Isuhu. ");
INSERT INTO ninNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Isuhu su uvuvurr a Matataya. U Matataya su uvuvurr a Emo. Emo su uvuvurr a Nahumu. U Nahumu su uvuvurr a Esili. Esili su uvuvurr a Nagayi. ");
INSERT INTO ninNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","U Nagayi su uvuvurr a Mati. Mati su uvuvurr a Matataya. U Matataya su uvuvurr a Seme. Seme su uvuvurr a Jose. U Jose su uvuvurr a Joda. ");
INSERT INTO ninNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","U Joda su uvuvurr a Jowana. U Jowana su uvuvurr a Resa. U Resa su uvuvurr a Zerrubabe. U Zerrubabe su uvuvurr a Sheyalitiye. U Sheyalitiye su uvuvurr a Nerri. ");
INSERT INTO ninNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","U Nerri su uvuvurr a Meliki. U Meliki su uvuvurr a Adi. Adi su uvuvurr a Kosamu. Kosamu su uvuvurr a Elimada. U Elimada su uvuvurr a Err. ");
INSERT INTO ninNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Err su uvuvurr a Joshuwa. U Joshuwa su uvuvurr a Eliyeza. Eliyeza su uvuvurr a Jorrimu. U Jorrimu su uvuvurr a Matati. U Matati su uvuvurr a Levi. ");
INSERT INTO ninNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","U Levi su uvuvurr a Simiyo. U Simiyo su uvuvurr a Yahuda. U Yahuda su uvuvurr a Isuhu. Isuhu su uvuvurr a Jonamu. U Jonamu su uvuvurr a Eliyaki. ");
INSERT INTO ninNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyaki su uvuvurr a Meleya. U Meleya su uvuvurr a Mena. U Mena su uvuvurr a Matata. U Matata su uvuvurr a Nata. U Nata su uvuvurr a Doda. ");
INSERT INTO ninNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","U Doda su uvuvurr a Jesi. U Jesi su uvuvurr a Obedi. Obedi su uvuvurr a Bowazi. U Bowazi su uvuvurr a Salimo. U Salimo su uvuvurr a Nashoni. ");
INSERT INTO ninNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","U Nashoni su uvuvurr a Aminada. Aminada su uvuvurr a Adimini. Adimini su uvuvurr a Ani. Ani su uvuvurr a Hezroni. Hezroni su uvuvurr a Perrezi. U Perrezi su uvuvurr a Yahuda. ");
INSERT INTO ninNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","U Yahuda su uvuvurr a Yakubu. U Yakubu su uvuvurr a Ishaku. Ishaku su uvuvurr a Ibrayi. Ibrayi su uvuvurr a Terra. U Terra su uvuvurr a Naho. ");
INSERT INTO ninNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","U Naho su uvuvurr a Serrugu. U Serrugu su uvuvurr a Rewu. U Rewu su uvuvurr a Pelegi. U Pelegi su uvuvurr a Eberr. Eberr su uvuvurr a Shela. ");
INSERT INTO ninNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","U Shela su uvuvurr a Keyina. U Keyina su uvuvurr a Afakadi. Afakadi su uvuvurr a Shemu. U Shemu su uvuvurr a Nuhu. U Nuhu su uvuvurr a Lameki. ");
INSERT INTO ninNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","U Lameki su uvuvurr a Metusela. U Metusela su uvuvurr a Inoki. Inoki su uvuvurr a Jarredi. U Jarredi su uvuvurr a Mahalale. U Mahalale su uvuvurr a Kenani. ");
INSERT INTO ninNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","U Kenani su uvuvurr a Enoshi. Enoshi su uvuvurr a Seti. U Seti su uvuvurr a Adamu. Adamu su uvuvurr a Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nggo Yesu kazhi ni inyi nu Joda wa, Izhi Iwre i Abachi yi i ssu ku nu ukpa. Izhi yi gri ma ni rri kuma na ankpuji. ");
INSERT INTO ninNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nggo Umimi wa ku tsarr ma kye ki ivi iso ine̱ (40). Ni ivi ima, uwa si di ri inkindirr hen, iyo ki ma kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Umimi wa da ku di, “Ùwà ti du ùwà su Uvuvurr a Abachi, ùwà ka ingbinta inggi yi kaki unfonfo.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu à ddu ma di, “Ungbamvu ku Abachi ku da di, ‘À si si ila inggi na nkpama unushirr ta ri na so tsitsirr hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Umimi wa ba Yesu gri kuma ni itu i igbre numa na tsarr ma ittu ingbingbru yi we. ");
INSERT INTO ninNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Na ddu ma di, “Ingga ta nu ùwà ittu, nu ukyekye tuku iwre imbarr yi namri. A ka ni ingga aseki akama namri ba. Undurr wa nggo isisurr mungga ti kpanye na ku, ingga ta nu ma na ka. ");
INSERT INTO ninNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iki inggi yi ta si imuwa namri, nu nggo ùwà ti kuttu ni ni ingga inkpinkpye.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu à ddu ma di, “Ungbamvu ku Abachi ku da di, ‘Ùwà bu kuttu ku Atiko nggo sa Abachi muwa ni ga uwa yo na nkpama!’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Umimi wa ba ma na kuma nu Urushalima, na gri ma ku sa ni ituki Uki Unkpi ku Ibarr Abachi ku, na ddu ma di, “Ùwà ti du ùwà su Uvuvurr a Abachi ùwà tu ji zhi ni inggya di ingga kye. ");
INSERT INTO ninNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ungbamvu ku Abachi ku mi da di: “ ‘Abachi ta tu abitu ama ba du ba ni ko ùwà kpa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Abitu ba ta gɨ ùwà na ango ambarr ka, na si ta du ùwà ngri uza ni angbinta hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu à ka sa ku di, “Ungbamvu ku Abachi ku u da di, ‘Si tsarr Atiko wa nggo si Abachi muwa kye hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nggo Umimi wa tsarr Yesu kye na anko ka ngga ka wemi, na ka ma bi azhibarr numa nggo uwa ti ka hi anko. ");
INSERT INTO ninNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mre Yesu kanga nu Galili, ukyekye ku Izhi yi Iwre ku u se na ku. Anishirr ba wo ure ni itu ima yi kago na anga ama wa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesu tsarr ba na Aki ka Issubi ka, anishirr ba wemi gbyarr ku asa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu kuma nu Nazareti nggo à furr. Na Azhibarr a Isu wa, Yesu kuma nu Uki ki Issubi ku, nggo a di na meme zhe mu. Na ku gru kri na ta bre nu Ungbamvu ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Aba ba ungbamvu ku Ishaya, uni kpa are wa, nu ma. Uwa bwu ku na hi unto ku nggo a charr di: ");
INSERT INTO ninNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Izhi Iwre i Abachi yi i se ni ingga ku, ima yo du Abachi hla ingga di ingga bu ku da ku anishirr bi iha ba Ure ku wre ku. Abachi tu ingga di ingga bu ku ddu abi kri ni iharr ttungo, ni du aba akreshishi ba a hi abubo, ni ku ddu abangga ba nggo a so ni itsutsarr ttungo, ");
INSERT INTO ninNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ni da ba di ivi iyo i nga ba, nggo Atiko ta ni ddu anishirr ama ba ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu chi ungbamvu ku, na ka ku nu unu undu wa nu uki ki issubi ku, na ji so. Anishirr ba tsatsarr nu umi ku uki ki issubi ku so surr ku ashishi, ");
INSERT INTO ninNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","uwa à da ba di, “Ari yo, ankpi are angga ka nggo imba i wo nggo ingga bre, a si are jiji.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Aba wemi nggo a wo ma a bre are zizi ni itu ima yi, na so ku ayisurr na ankpi are ka nggo a bre ka, na da di, “Uwanggo si su uvuvurr a Isuhu hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu ddu ba di, “Ingga hi di imba ta da ki ingga assurre nggo wa di, ‘Unifu, fu itu muwa.’ Imba ta da ki ingga di aseki ka nggo ingga i na ka nu Kapanahu ingga bu na ka ni inggya ni igbu mungga wa meme.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu da ba zizo di, “Ingga so da ki imba di, ‘A si di kye uni kpa are ssu nu ungo ni igbu ama hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Imba wo ingga yi, amba ba ako a garrza ni Israila na ase ka Iliya, uni kpa are wa, nggo a so sama na ahru ki ase tarr ni ihwa itani. Iyo i ki kakami kago na anga ka ma. ");
INSERT INTO ninNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Abachi si turr Iliya ko nu unuma nu umi ku amba ba ako ba ni Israila hen, na turr ma ko na ayamba na ako numa ku nu Zarrefa na anga ka Sido. ");
INSERT INTO ninNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Anishirr shishemi ni Israila so ki iha ni ishi ni ivi i Ilisha uni kpa are wa, uyirr mi nu umi umbarr ku si wre hen, uwa su Nama anu Sirriya, nggo Abachi du ma wre.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Akpa anishirr wa nggo a rri so nu uki ki issubi ku anu Yahuda ku a wo ure ku Yesu ukuma na ki unfu kakami na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Na turr gru gba Yesu huzzu ni igbu wa. Na gri ma hun ko na anga yirr a igbre nu Nazareti wa, da aba ta ku turr ma ji ni itu igbre yi wre ku a bu ji ku ttu. ");
INSERT INTO ninNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Uwa ku gbuddu na angu ambarr ka na rri ba nu umi umbarr ku na kuma na ka ba du nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nabo, Yesu kakuma nu Kapanahu, igbu numa na anga ka Galili, na ku di tsarr anishirr ba na Azhibarr a Isu anu Yahuda wa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Aba ku ayisurr ni itsarr ima yi, nggo à re kyekye mi zzu nâ ta si uwa nggo sa akikye nu ure wa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ugo numa nggo a se ni izhi ndanda, na rri so na ba nu uki ki issubi ku, na gru re hantu di, ");
INSERT INTO ninNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“E-e! Yesu anu Nazareti, ùwà zha sa angginggi ni inta ba? Ùwà nga i ngɨ inta mu ki? Ingga hi ùwà! Ùwà yo su Unushirr uni Iwre a Abachi wa!” ");
INSERT INTO ninNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu nggarr ito ni izhi yi ku di, “Ba ttungo, ni huzzu ku ugo wa!” Izhi ndanda yi ba ugo wa gri ni nggurr, ni huzzu kuma, uwa si ngri ukpa hen. ");
INSERT INTO ninNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Anishirr ba vu angu gri na so ddu ikpa di, “Uwanggo sa angginggi? Ugo nggo wa re kyekye mi na anazhi ndanda ba ba, aba huzzu!” ");
INSERT INTO ninNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ure ki Yesu ku u bwa kago na anga ama wa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu huzzu nu uki ki issubi ku na kuma ni iko yi Sima. Ayimbarr a Sima wa à vri kakami na rri kurr nu uki, aba da ku Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","I Yesu rri ku kukri nu unddu ku abubo a kurr wa, na ddu ivri yi di i bu huzzu ku. Ivri yi huzzu ku jiji. Uwa gru na zzu ba ila. ");
INSERT INTO ninNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ni ingbahru, abangga ba nggo se na abi vri na nkanka a gri ba nga na age̱ ka Yesu, uwa ni sa ungo na ba, aba wre namri. ");
INSERT INTO ninNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Izhi ndanda yi huzzu ku anishirr shishemi meme ni da di, “Ùwà yo su Uvuvurr a Abachi wa!” Yesu nggarr ito na ba, na han ba ni re yi, nu nggo aba mi hi du uwa yo su Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Na ambre bwu, i Yesu à huzzu nu umi igbu ku, na kuma nu unto ku nggo kurr ywiywimi. Anishirr ba gru di zha ma, na ku hi ma, na da aba ta han ma ni kuma yi. ");
INSERT INTO ninNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Uwa ddu ba di, “Ingga ta ku da Ure ku Abachi ku ni igbu numa yi meme, ima yo gri ingga nga.” ");
INSERT INTO ninNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Na gru kuma di bre ba ure ku Abachi ku kago na aki ka issubi ka, na anga ka Yahudiya ka. ");
INSERT INTO ninNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Azhibarr numa nggo Yesu kri nu unddu ku inyi nu Genesareti wa, anishirr shishemi a bi na ku, di aba ta wo ure ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Uwa à hi iddu iha kri nu unddu amasirr ku, nggo abi vɨ ikikla ba a ka yi zu na ko ngla azhizhi ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu mirri nu uddu uyirr ku nggo su ku Sima, na da ku Sima di a bu gburr rri ni inyi wa ntsɨ, Yesu rri so nu uddu ku na so tsarr anishirr ba ure ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nggo a re kre ba, na ddu Sima di, “Turr uddu ku chi rri ko na amasirr a ita wa, ùwà nu ukpami wa imba surr azhizhi ka ni vɨ yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Sima da di, “Ankpye, inta gri undu zhi ni ibittu mu, ni si vu inkindirr hen. Ingga ta yo, nggo ùwà da.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aba surr azhizhi ka, na vu ikikla shishemi, nggo azhizhi ka ki ywhiywhirr tsi hre. ");
INSERT INTO ninNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nggo aba yo abi girr ambarr ba nu uddu numa di a bu ni zi aba. Aba ni vɨ ssu ni iddu yi ha mi, nggo iddu yi ta ko ji zhi na amasirr wa. ");
INSERT INTO ninNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sima Biturr hi inkindirr ima yi na, ji kuttu na agbuzzu ka Yesu, na di, “Chi share ni ingga ku, Atiko! Ingga si ni ila ure mu!” ");
INSERT INTO ninNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","A da meme nggo, aba wemi ku ayisurr na akpa ikikla wa nggo a vɨ. ");
INSERT INTO ninNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Akpukpa ma bu Sima ba, ani Yakubu tuku Yohana, amumarr bu Zabadi ba, aba mi a ku ayisurr meme. Yesu ddu Sima di, “Si di isisu ki ùwà hen. Bazhi ziza nggo, ùwà taka di vɨ anishirr.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A turr iddu yi ku zu nu unddu inyi ku, na ka aseki imbarr ka du namri, na ga Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nggo Yesu ni se ni igbu numa wa, ugo numa se nabo nggo si uni lo ishi. Nggo à hi Yesu, na ji kuttu ni imimi na barr Yesu di, “Atiko, ùwà ta kpanye ùwà di ingga wre!” ");
INSERT INTO ninNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu sa ungo na ku na da di, “Ingga kpanye! Ziza ùwà wre ba!” Ankpu ayirr, ishi yi huzzu ku ugo wa. ");
INSERT INTO ninNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu gba ku utu di, “Si da ku undurr hen. Gri itu muwa ku tsarr unikye wa, ni to ito yi nggo Musa à da, wre ku anishirr bi hi du ùwà wre ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nu nggo Yesu gba ku ugo wa utu mi, ure kuma ka ni bwa kago na anga ma wa mri ngbangba yi. Anishirr shishemi a nga ni wo ma, na ka bu wre ni ivri imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Yesu à di gru kuma ku barr na ankpa ma nu unto ku nggo su ywi. ");
INSERT INTO ninNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","A si na azhibarr numa nggo Yesu so tsarr anishirr ba, anu Farrisi ba na abitsarr Are banu a so nabo. A zhi ni igbu yi kago nu Galili tuku Yahudiya, abanu ba a zhi nu Urushalima. Ukyekye ku Abachi ku rri ku Yesu nu ukpa, nggo ta du abi lo ba wre. ");
INSERT INTO ninNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Anishirr banu a ba ugo numa nu utakpa na nga. Ugo wa nggo a ttu ga anga yirr. Aba nurr da aba ta gri ma na rri ko ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Anishirr ba kri harr anko wa. Aba si hi anko wa nggo aba ta ba ma na rri kuma ni iko yi hen. Na kye, na ba ma na hun ni ituki yi, na ko ku ngri anchirr ka narrnarr nu unto ku nggo Yesu à so, na to ma ji nu utakpa ku, ni zu na atsutsu ka anishirr ba, na age̱ ka Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nggo Yesu kye iyo isisurr imbarr yi, na ddu ugo wa di, “Ukpamu, ingga nggurr ila ure muwa yi zhi ku ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Abitsarr Are ba na anu Farrisi ba gru so ri amarr di, “Ugo nggo su unggonggo, nggo so tsarr itu ima yi kye na Abachi ku? Abachi yo na ankpa ma à se nu ukyekye ki nggurr ila ure zhi!” ");
INSERT INTO ninNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu hi isisurr imbarr yi, na ddu ba di, “Angginggi di imba ri amarr angga ka meme? ");
INSERT INTO ninNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Uwatanggo tsɨ ki imba kakami, ingga bu da di, ‘A nggurr ila ure muwa yi zhi,’ ka ingga bu da ku di, ‘Gru zirr’? ");
INSERT INTO ninNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ingga ta tsarr imba ari di ingga Uvuvurr a Unushirr se nu ukyekye ku nggurr ila ure zhi ku anishirr, ni ingbingbru inggi yi.” Na da ku uni lo wa di, “Ingga du ùwà bu gru ba abubo a ikurr a muwa ni kuma ni iko!” ");
INSERT INTO ninNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ugo wa turr do gru, ba utakpa nggo à di kurr na ashishi ambarr ka, na kuma ni iko, na so nyarr ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Aba wemi ku kri vu angu. Isisu ki ba. Aba gru so nyarr ku Abachi da di, “Inta hi aseki ankpinkpi na ashishi munta ari!” ");
INSERT INTO ninNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nu ugo kuma, Yesu gru huzzu kuma na ábì na ku hi uni kpa inklo imimi numa nggo a yo ma du Levi. Uwa rri so na abubo a undu ama wa. Yesu ddu ma di, “Ga mi.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi turr gru na kà aseki ka nggo a kurr nu uki du, na ga ma kuma. ");
INSERT INTO ninNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Levi à na ku Yesu iga inkpi ni iko ima. Anishirr abi kpa inklo imimi ba shishemi na anishirr banu a se nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Anu Farrisi na abitsarr ambarr ba a gru so zhi abiga i Yesu ba di, “Angginggi di imba di ri ni so na abi kpa inklo i imimi ba na abi la ure ba?” ");
INSERT INTO ninNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu ddu ba di, “Anishirr ba nggo sa akyekye si di zha uni ni ahun hen, abi vri ngga di zha ma. ");
INSERT INTO ninNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ingga si nye yo abi sa ni ila ure mu hen, ingga nga i yo abi la ure ba yo du ba kasarr ni ila ure imbarr yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Anishirr banu nga ni da ku Yesu di, “Abiga bu Yohana ba di vu angu gri ttuttumi na so di barr riri mu, abiga ba anu Farrisi ba mi di na meme yo, amuwa ba so di ri na so mre.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu zhi ba di, “Imba kye ka wre ikpikpa i unuru ayamba he̱he̱ yi bu so ni iyo nggo wa unuru a ayamba wa ni so na ba? ");
INSERT INTO ninNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Azhibarr wa so nga nggo a taka ba unuru wa glo na ba bari, aba taka vu angu.” ");
INSERT INTO ninNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu da ba assurre anggo wa di, “Anishirr si di tsu upri inkru uhe̱he̱ ni warr sa ku ankru akuku hen. A ta nga ankru ahe̱he̱ ka hre, upri ankru uhe̱he̱ ku si ta kpa wre ku ukuku ku hen. ");
INSERT INTO ninNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Na anko ayirr ama yo, anishirr si di ba ahi ahe̱he̱ kasurr nu unggakpa ku zu ahi ukuku hen. Uwanggo nggo a ti na meme, ahi ahe̱he̱ wa ta tsi unggakpa ukuku ku nggarr na kuhre, unggakpa ku u ta sama nu undu. ");
INSERT INTO ninNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Meme nggo, anishirr bu surr ahi ahe̱he̱ nu unggakpa ku zu ahi uhe̱he̱! ");
INSERT INTO ninNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Undurr wa nggo ta so ahi akuku wa, uwa si ta kpanye na ahe̱he̱ wa zizo hen. A ta da di, ‘Ahi akuku wa a marr sha.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yesu na abiga ma ba a so zirr ba ni izzuzzu i ikiri na Azhibarr a Isu wa, abiga ama ba gru so mɨ ato a alikama wa so ngu ta. ");
INSERT INTO ninNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Anu Farrisi banu a zhi ba di, “Angginggi du imba so na inkindirr yi nggo Iba munta yi kisa di a bu si na yi na Azhibarr a Isu wa hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu zhi ba di, “Imba nise bre inkindirr yi nggo uttu Doda à na nggo iyo i ki ma na anishirr ba nggo so zirr na ku? ");
INSERT INTO ninNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Doda à rri ko nu uki ku Abachi ku na ku ba unfonfo wa nggo a gri ga ku Abachi à ta na tsu ga ku anishirr ama ba. Ni iba munta yi, a si abikye ngga a di ta uwama na nkpambarr.” ");
INSERT INTO ninNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ni ikikre yi, Yesu da ba di, “Ingga Uvuvurr a Unushirr nggo si Atiko a Azhibarr a Isu wa.” ");
INSERT INTO ninNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Uwa a si na Azhibarr a Isu numa nggo Yesu gru ku so tsarr anishirr ba nu uki ku issubi ku. Ugo numa nggo ungo ri umaku u sharr kre ku a rri so nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Abitsarr na Are ba na anu Farrisi ba a rri kri nu umi uki ku, na so zha anko wa nggo aba ta vu Yesu ni ìlà. Na so kye ma girr mi, di à ta gru du ungo ku u wre ku ugo wa na Azhibarr a Isu wa. ");
INSERT INTO ninNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu hi amarr ambarr ka na ddu ugo wa di, “Gru nga ni ichi.” Ugo wa gru ku kri ni ichi yi. ");
INSERT INTO ninNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu ddu ba di, “Di ingga zhi imba: Iba munta yi i da di inta bu na angginggi na Azhibarr a Isu wa? Di inta bu na uzizi, ka inta bu na umimi? Di inta bu du unushirr so tsitsirr, ka inta bu du ba kɨ?” ");
INSERT INTO ninNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Na kye ba kago, na ddu ugo wa di, “Na ungo muwa ku.” Uwa na ku. Ungo ku u wre ku. ");
INSERT INTO ninNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aba vri isisurr na ku kakami na gru so zhi ikpa inkindirr yi nggo aba ta na ku Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Azhibarr numa nggo Yesu hun ku so barr Abachi ni igbre wa, na ku so barr nggarr ambre. ");
INSERT INTO ninNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nggo ambre ka nggarr, uwa yo abiga ama ba nggurr bi na hla anishirr awurr na aha ba na yo ba ki abi ko na angu. ");
INSERT INTO ninNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Sima nggo a yo ma di Biturr, nu uzayirr wa Andoro, i Yakubu tuku Yohana, i Filibu tuku Batolomi, ");
INSERT INTO ninNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","U Matiyu tuku Toma, i Yakubu uvuvurr a Alifiyo, i Sima nggo a yo di ugo nggo à se na amarr ka ako ambarr ka, ");
INSERT INTO ninNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judasi uvuvurr a Yakubu, u Judasi Iskariyoti nggo na anko du ba vu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu na abi ko na angu ba a kaji zhi ni igbre wa ni kukri na abubo badada wa. Akpa anishirr nga ni hi abiga ama ba kri bi ma nabo. A zhi na anga ka Yahudiya, ni igbu i Urushalima, nu unddu inyi ku Taya nu Sido. ");
INSERT INTO ninNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","A nga da aba a nye wo ure ku Yesu ku na ku bu kpa iwre ni ivri imbarr yi. Abanu nggo a se na anazhi a nga na ni wre. ");
INSERT INTO ninNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Anishirr so ta kpukpa da aba ta ku sa ungo na ku, nggo a so hi ukyekye ku ni huzzu ku nu ukpa, na du ba wre wemi. ");
INSERT INTO ninNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu kakye abiga ma ba na da di, “Abachi à yo ki imba angu ka iwre, imba abi iha zizami; Ittu i Abachi yi si imba. ");
INSERT INTO ninNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Abachi à yo ki imba angu ka iwre, imba bi ki iyo zizami; imba taka shi! Abachi à yo ki imba angu ka iwre, imba abi yi zizami; imba taka me̱! ");
INSERT INTO ninNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Abachi à yo ki imba angu ka iwre, nggo anishirr kà imba, na han imba, na marr imba, na bre are andanda na atu amba, ni itu mungga Uvuvurr a Unushirr! ");
INSERT INTO ninNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Nggo a ti na ki imba meme, imba bu nyarr, ni me̱ nyarr. Kye, azadi amba ka kri kakami, nggo a zu ki imba nu unkplassu. Kye, ábáchí ambarr ba a na ku abi kpa are mungga ba meme yo. ");
INSERT INTO ninNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“A ti si imba nggo se ni iki ingbingbru yi zizami, uje umba ku taka si kakami, nggo imba ka kpa azadi amba ka ba! ");
INSERT INTO ninNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Uje umba, imba nggo so shi zizami. Imba taka so ni ingaza! Uje umba, nggo so me̱ nyarr ziza nggo; imba taka ni yì wuwu! ");
INSERT INTO ninNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Uje umba, nggo anishirr so gbyarr ki imba asa; ábáchí ambarr ba mi a na meme yo ni itu i abi kpa are bi imu ba. ");
INSERT INTO ninNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ingga so da ki imba, imba nggo so wo ingga: Imba bu kpanye na abi karr imba ba ba. Imba bu na wre ku abi karr imba ba. ");
INSERT INTO ninNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Abangga ba nggo a marr imba, imba bu yo ba angu azizi, ni barr Abachi ku abangga ba nggo a na ki imba undanda. ");
INSERT INTO ninNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Undurr ti nggurr ùwà nu unga uyirr, ùwà ka numa ku sarr ku. Undurr ti vu ùwà kpa ankru ankpi, ùwà ba avutsa ka unuma kye. ");
INSERT INTO ninNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nu abangga ba nggo barr imba inkindirr. Undurr ti ba inkindirr imba, imba bu si ga ma ku kpa yi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na ku abanu inkindirr yi nggo imba zha di a bu na ki imba. ");
INSERT INTO ninNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Imba ti kpanye na abangga ba nggo kpanye ni imba ba, imba ta kpa angginggi iwre? Abi la ure ba mi di na wre ku abangga ba nggo kpanye na ba! ");
INSERT INTO ninNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Imba ti na wre ku abangga ba nggo di na wre ki imba yo mre, imba ta kpa angginggi zizi nu umi? Abi la ure ba mi di na meme yo! ");
INSERT INTO ninNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Imba ti ni uhla ku abangga ba nggo imba hi da taka han imba, imba ta kpa angginggi zizi? Abi la ure ba mi a di nu abi la ure uhla, nu nggo a hi di a taka ni han ba! ");
INSERT INTO ninNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iya! Imba bu kpanye na abi kà imba ba ba, ni na wre ba. Ni uhla, ni si kye anko nggo a ta ni han imba bari hen. Imba ti na meme, azadi imba ka taka kri kaba. Imba taka si amumarr ba Abachi Unkpi Kakami wa, nggo uwa yo di na wre ku abi kà inyarr na agbugbu anishirr. ");
INSERT INTO ninNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Imba bu si abi itito nâ ta si Aki amba wa, nggo di se ni itito. ");
INSERT INTO ninNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Imba bu si bre ku abanu ila ure imbarr yi hen. Abachi mi si ta bre ila ure imba yi hen. Imba si vɨ abanu ni ila hen. Abachi mi si ta vɨ imba ni ila ure hen. Imba nggurr zhi ku abanu, Abachi mi ta nggurr zhi ki imba meme. ");
INSERT INTO ninNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Imba ti tsu ni abanu, Abachi ta ni imba meme. Imba ta kpa ssu pwi, i ta kuhre awuwa. Aba ta ni imba ssu na ango na kpa kpikpa, na ba vaviva ki awuwa na age̱ amba. Na agbugba wanggo nggo imba di tsarr ku abanu, Abachi ta tsarr ki imba na ama yo.” ");
INSERT INTO ninNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu da assurre anggo zizo di, “unakreshishi ka si gbu unakreshishi hen. Unuma ti na meme, aba aha mi ta kuhre nu udduddu. ");
INSERT INTO ninNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Uvuvurr uni bre si di mri unitsarr ama wa hen. Nggo uvuvurr ni bre wa a ti kre ibre yi nggo, uwa ta si nâ ta si unitsarr ama wa. ");
INSERT INTO ninNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Angginggi du ùwà so kye uvu unkunka ku ni ishishi i uzumbirr yi, ni si kakye unkunkurr ku nggo u harr ni muwa yi hen? ");
INSERT INTO ninNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ùwà ta na ki ngginggi ni da ku uzumbirr wa di, ‘Di ingga ttu ku ùwà unkunka ku ni ishishi’, ni si hi unkunkurr ku nggo kurr ni ishishi imuwa yi hen? Ùwà ni na aseki wre ku anishirr a bu hi. Ttu unkunkurr ku ni ishishi muwa yi bari, ùwà ta kye hi zizi ni ttu ku uzumbirr wa unkunka ku ni ishishi ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Unkunkurr ki iwre si di klo inkpinkpo indanda hen. Unkunkurr undanda si di klo inkpinkpo iwre hen. ");
INSERT INTO ninNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","A di hi unkunkurr ku inkpinkpo yi, nggo u klo nggo. A si di ywhe ibwa ka ingo nu unkunkurr ki intto hen. ");
INSERT INTO ninNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Meme yo, unushirr uzizi à di gri inkindirr zizi zhi ni isisurr ima izizi yi. Ugbugbu unushirr di gri amarr ndanda zhi ni ndanda isisurr ima yi. Angu di da inkindirr yi nggo i zhi ni isisurr. ");
INSERT INTO ninNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Angginggi di imba so di yo ingga da ‘Atiko, Atiko’, ni si na inkindirr yi nggo ingga da ki imba hen? ");
INSERT INTO ninNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Di ingga ta tsarr imba di, uwanggo nggo ti nga ni ingga ku, na ni shirr atu nu ure mungga ku, na kpa ku na na undu, à si kinggi. ");
INSERT INTO ninNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","A si nâ ta si ugo wa nggo ta me iko, na ya ibarr ji kuma ni imimi bari, na zu ibarr iko yi na angbinta. Nggo inyi wa ssu garrza na ni nggurr ni iko yi, i si battu hen, nggo a me yi wre. ");
INSERT INTO ninNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Undurr wanggo nggo ti wo ure mungga ku, na si na undu na ku hen, uwa si nâ ta si ugo wanggo nggo me iko ima yi sama ni ibarr iko yi. Nggo inyi wa ssu, na ni nggurr iko yi i ji jaku inkpu iyirr, i jaku yi i si wawami!” ");
INSERT INTO ninNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nggo Yesu bre aseki ka kre ku anishirr ba, na gru kuma nu Kapanahu. ");
INSERT INTO ninNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ankpye a abi lo ukpa nu Roma wa nabo, a se nu uvurr iko nggo se gaga na ku, uvurr iko wa à kurr ukpa kakami na ki ywhiywhirr ittu. ");
INSERT INTO ninNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nggo ankpye wa wo di Yesu se, na tu akikre ni Yahuda da bu ko ku yo ma du nga ni du uvurr iko wa wre. ");
INSERT INTO ninNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Aba ko ni Yesu ku, ku so barr ma kakami da di, “Ugo wa so zha ùwà kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","À kpanye na anishirr munta ba ba, na à me ki inta uki ki issubi ku.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yesu à ga ba. Nggo à ko ki ywhiywhirr ni iko yi nggo ugo wa so, ugo wa tu akpambarr ba ni Yesu ku di, “Ankpye, si ki itu muwa iha ni irri nga ni iko mungga hen. Ingga si ma ni du uwa bu rri nga nu umi iko mungga hen. ");
INSERT INTO ninNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ingga kye itu mungga kpachirr, ingga si ma ni nga na age̱ muwa hen. Kri nabo ni re uvurr iko wa ta wre ki ingga. ");
INSERT INTO ninNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ingga mi so nu ungo ku ankpinkpye mungga, ni so gri abi ta iku banu na ango mungga. Ingga ti tu unuma di kuma, uwa kuma. Ingga ti yo unuma di nye, uwa nga. Ingga ti da ku ugarr mungga wa di na inggi yi, uwa à na yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu kukri na vu angu gri, na kakye anishirr ba nggo so ga ma, na ddu ba di, “Ni Israila mi, ingga nise hi unushirr ni yo isisurr ma mi!” ");
INSERT INTO ninNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Abitu bu ugo ba kakuma ni iko yi ankpye abi ta iku wa na ku hi uvurr iko wa uwa ka wre ba. ");
INSERT INTO ninNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nggo Yesu huzzu kuma ni igbu wa nggo a yo ma du Neyi. Abiga ama ba na akpukpa anishirr di ga ma. ");
INSERT INTO ninNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nggo à so mirri na anko a igbu wa, na hi ba so gri iku yi ko izzu. Uni ttu wa à su uwa uyirr wama yo ni ingri iyirr. Ayirr ama wa si ayamba ako. Anishirr bi igbu ba shishemi huzzu so zirr ndo na ayirr wa. ");
INSERT INTO ninNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nggo Atiko sa ashishi na ayamba wa ku, itito ki ma, uwa ddu ma di, “Ba ttungo!” ");
INSERT INTO ninNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Na zirr kuma ku sa ungo nu utakpa ku, u abi ba iku ba kukri. Yesu da di, “Uvuvurr nze, ingga du ùwà bu tasi!” ");
INSERT INTO ninNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Uni ttu wa gru so, na bwu angu na gru so re. Yesu ka ma nu ayirr wa. ");
INSERT INTO ninNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Isisu ki anishirr ba, aba gru so nyarr ku Abachi na da di, “Uni kpa are unkpi nggo gru ni inta ba!” Na da di, “Abachi nggo nga ikpa anishirr ama ba ttungo!” ");
INSERT INTO ninNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ure kuma ni itu yi Yesu u bwa kago na anga ka Yahudiya ka na abi girr ambarr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nggo abiga bu Yohana ba ku bre ku inkindirr yi nggo Yesu so na yi, nggo Yohana yo aha nu umi umbarr ku, ");
INSERT INTO ninNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","na tu ba di a bu ku zhi Yesu kye di, “Ùwà yo su uwanggo nggo à taka nga wa, ka inta bu kye anko a unuma mu?” ");
INSERT INTO ninNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Nggo a ko ni Yesu ku, na ko ku da ku di, “Yohana uni zzu na amasirr wa yo di inta bu ni zhi ùwà di, ‘Ùwà yo su uwanggo nggo à taka nga wa, ka inta bu kye anko a unuma mu?’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na attuttu ama wa Yesu du abi vri shishemi a wre ni ivri ambarr, ni ilolo imbarr yi, na abi ku anazhi ndanda, na du aba kreshi shishemi a wre. ");
INSERT INTO ninNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Uwa ddu abitu bu Yohana ba di, “Imba kakuma ku da ku Yohana inkindirr yi nggo imba hi ni wo yi nggo. Aba kreshi a wre, aba akpre a gru zirr, abi lo ishi mi a wre, aba agbatu a wo are, na abi kɨ mi tasi, a bre ku abi iha Ure ku wre ku. ");
INSERT INTO ninNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Abachi ta yo ku undurr wa nggo a kpa ingga ni isisurr iyirr angu ka iwre.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nggo abitu bi Yohana ba a kakuma, Yesu gru ko bre ku anishirr ba are ni itu i Yohana di, “Nggo imba di ko nu Yohana ku na ankpuji wa, imba di kye di imba ko kye sa angginggi? Itu ihihru wa nggo a lo wa klo du ka so wri nu unddunddu? ");
INSERT INTO ninNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Imba i ko kye angginggi? Unushirr wa nggo surr iki iwre? Anishirr ba nggo di surr iki inkpinkpi i atuttu, na so me̱ nyarr, na di so na akaba a uttu! ");
INSERT INTO ninNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Da ki ingga yi, imba i ko kye sa angginggi? Uni kpa are? E-e, imba hi undurr wa nggo mri uni kpa are. ");
INSERT INTO ninNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Yohana yo su uwanggo nggo Ungbamvu ku Abachi ku da di Abachi à da di: “ ‘Ingga ta tu unitu mungga wa kuchi ku ùwà, uwa à ta kuchi nga ni bu ssu anko bi ku ùwà.’ ");
INSERT INTO ninNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ingga so da ki imba, Yohana à mri anishirr ba nggo ayamba nggo ngri. Undurr wa nggo uwa yo su uvutsa kakami wa ni Ittu yi Abachi yi à mri Yohana.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Anishirr ba namri a wo Yohana. Abi kpa inklo imimi mi a kpanye da Abachi à na wre, ni ima yo aba du Yohana à zzu ba na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","U anu Farrisi ba na abitsarr na are ba nggo sa abi kri atu na kà iwo ku Abachi ure, na si du Yohana zzu ba na amasirr hen). ");
INSERT INTO ninNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu ddu ba zizo di, “Ziza nggo, ingga ka da anishirr ba ari ba a zzu nâ ta sa angginggi? ");
INSERT INTO ninNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","A zzu nâ ta sa amumarr ngga so nu udu. Na so yo ikpa di: “ ‘Inta nggurr ki imba inggingga, imba si rro hen! Inta ba azhittu, imba si yi hen!’ ");
INSERT INTO ninNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","I Yohana uni zzu na amasirr wa nga, na si so ahi, ka ri unfonfo hen, imba da di, ‘À se na anazhi ni itu.’ ");
INSERT INTO ninNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ingga Uvuvurr a Unushirr nggo nga, ni so ri ni so, imba da di, ‘Kye ugo nggo! A ri kpekpe, na so na hwa, na ki ikpikpa na abi kpa inklo imimi ba, na abi la ure!’ ");
INSERT INTO ninNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Abangga ba nggo a kpanye nu ukrizhizhi ku Abachi ku a so na inkindirr yi nggo i tsarr di ukrizhizhi ku Abachi ku su jiji.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Anu Farrisi numa a yo Yesu di a bu ku ri ni iko ima. I Yesu kuma ni iko yi na ku ji so na ta ko ri. ");
INSERT INTO ninNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ayamba numa nggo se nu umi ku igbu kuma, à si ni ila ure na wo di Yesu nggo so ni iko i anu Farrisi, na ba anye a hun ingba wre ssu na a azhizha wa nggo a na wa ni ingbinta yi nggo a yo yi di alabasta. ");
INSERT INTO ninNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Na ka ba ku Yesu nu ugo na ni kuttu ku na aza, na so yi ashishi surr ku Yesu na aza. Na ki infunfutu ima yi hɨ ku ashishi wa, na surr ku anye a ihun ingba wre wa na aza na ma anta. ");
INSERT INTO ninNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nggo anu Farrisi wanggo nggo a yo ma a hi meme na da ku itu ima di, “Ka du ugo nggo su uni kpa are ujiji, ka si hi da ayamba anggo wa, nggo so ngu ma ango ka à su uni la ure hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu ddu ugo wa di, “Sima, ingga se ni inkindirr yi nggo ingga ta da ku uwa.” Sima da di, “Unitsarr, da ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu ddu ma di, “Anishirr aha banu nggo a ri ku ugo numa uhla ki inklo. Uyirr wa à ri ma ayiyirr akywi (500) mu ka ingbingbi dinarri. Uyirr wa iso ikywi (50). ");
INSERT INTO ninNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Aba aha mi a sama na anko a ihan inklo wa. Ugo wa à ka yi du ba aha mi. Uwatanggo ta nyarr ku ugo wa sha?” ");
INSERT INTO ninNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sima da di, “Ingga kye, a ta su uwanggo nggo umaku u kri sha.” Yesu ddu ma di, “Ùwà da ma.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Na kye kako na ayamba wa ku, na ddu Sima da di, “Kye ayamba nggo wa. Ingga mirri ni iko muwa, uwa si ni ingga amasirr a ingla aza hen. Uwa ni ngla ki ingga aza ka na ashishi ama, na hɨ ki ingga na ka ni infunfutu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ùwà si kpa ingga ni ma anta hen, uwa nga so ma anta na aza mungga ka zhi nggo ingga mirri mu. ");
INSERT INTO ninNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ùwà si gri anye ni surr ki ingga ni itu hen, uwa ni ngu ki ingga anye a ihun ingba wre na aza. ");
INSERT INTO ninNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ima yo, ingga so da ku ùwà di a nggurr ila ure ima i kri mwe yi zhi ku, ima yo du ma tsarr ikpanye i kri mwe inggi yi. Undurr wa nggo ti nggurr zhi ku ntsɨmi, ikpanye ima yi di su ntsɨmi yo.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nabo yo, Yesu ddu ayamba wa di, “Ingga nggurr ila ure muwa yi zhi ku uwa.” ");
INSERT INTO ninNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Abanu nggo so ri na ku nggo, gru so zhi ikpa toto di, “Uwanggo su unggonggo na nggurr ila ure zhi?” ");
INSERT INTO ninNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu ddu ayamba wa di, “Iyo isisurr muwa nggi kpa uwa ttungo. Kuma ni isu isisurr.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nu ugo ku ivi ima, i Yesu gru kuma ku di zirr kago ni igbu inkpinkpi ni itsitsa yi, na ku di bre ba Ure ku wre ku ittu i Abachi yi. À gri abi ko na angu awurr na aha ba (12) na ku, ");
INSERT INTO ninNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","na amba banu meme, nggo Yesu à du ba wre ni ivri imbarr yi, na han anazhi ndanda huzzu ku abanu ba nu ukpa. Uyirr nu umi ku amba ba a yo ma di Maryamu, nggo zhi nu Magadala, nggo Yesu à han anazhi ndanda atangba huzzu ku nu ukpa. ");
INSERT INTO ninNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Unuma su Yuwana, ayamba a Chuza, ugo wa su uyirr nu umi ku ankpinkpye ba nggo a di na undu na ando a uttu Hirridu. U Suzana, na amba banu ba shishemi, nggo so di zi Yesu na abiga ma ba na aseki. ");
INSERT INTO ninNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Anishirr shishemi a so nga ni Yesu ku, zhi ni igbu yi kago. Nggo akpa anishirr wa a nggurr bi ni ankla iyirr, Yesu a bre ba assurre anggo di: ");
INSERT INTO ninNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Uni do numa a ssuzzu kuma ko ku hi ibibi ikiri ima. Nggo a kuma ku so hi ikiri yi nggo, i ingbingbi inuma yi i kuhre ga anko, aba cha yi na aza, aminche a ta yi ri glo. ");
INSERT INTO ninNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ingbingbi inuma yi i kuhre na adantto. Uwa si nggo a amasirr a sama, achi a ikiri wa a gru ta ko furr mre na ka kɨ. ");
INSERT INTO ninNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ibibi ikiri numa yi kuhre ni intto, intto yi i furr ni harr ikiri di yi furr chankarr. ");
INSERT INTO ninNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ibibi ikiri numa yi i kuhre ni imimi izizi, ni furr ni klo ingbingbi ayiyirr mri inggi uni do wa à ttu nggo.” Yesu à bre kre ba nggo na nggarr angu ddu ba di, “Uwanggo nggo ti si na atu ka iwo, uwa bu wo.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Abiga ma ba a zhi ma inkindirr inggi nggo assurre wa a da nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu à ddu ba di, “A tsarr imba ihi aseki ka ittu i Abachi yi, uwa ta sa abanu ba nanko, ingga na undu na assurre nggo ni tsarr ba, wre ba, “ ‘a ti so kye mi, aba si ta kye hi hen; na a ti so wo mi aba si ta vu gri ni itu hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Wanggo yo si inkindirr yi nggo assurre wa a tsarr nggo: Ingbingbi ikiri yi su ure ku Abachi ku yo. ");
INSERT INTO ninNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ikiri yi nggo i kuhre ga anko wa nggo i sa abangga ba nggo a wo ure ku Abachi ku, umimi wa a nga ni ka ku glo ni isisurr imbarr yi, na han ba ni kpanye na kpa ikpa ttungo yi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ingbingbi ikiri yi nggo i kuhre ni imimi i adantto wa i si nâ ta si anishirr abangga ba nggo a wo ure ku Abachi ku na kpa ku ni inyarr. Uwa a su nggo ure ku u si rri kurr ba ni isisurr ngbangba hen, aba kpanye na sha kri ngbangba, itsarr kye ti rri na ba mre aba jaku. ");
INSERT INTO ninNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Uwa ta si ikiri inggi yi nggo i kuhre ni intto yi, ima si nâ ta si anishirr abangga ba nggo a wo ure ku Abachi ku na kpa ku nggo, ivri tuku aseki ka ingbingbru ka a nga ni han ba ni furr ki azizi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ingbingbi ikiri yi nggo i kuhre ni imimi izizi yi, inggi sa abangga ba nggo a wo ure ku Abachi ku na vu ku gri ni isisurr izizi, na kpanye na vu gri, na kri karrkarr ma ni klo ingbingbi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Unushirr ka si murr uru na gru ba agbugba ttu ingba ni la uru wa hen. A ka si ba uru ku nggo so la ku zu na aza ka agudu hen. Iya! A ta ba uru ku sa ni inkindirr numa tsa, na du ku la ku anishirr ba nggo so nga ni iko yi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Inkindirr yi nggo a sha yi sharri nado a taka gri yi ssuzzu na ábì. Inkindirr yi nggo a ka yi ttu sharri a ta bwu yi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Uwa a si ni ima yo, imba bu shirr atu zizi. Undurr wanggo a se ni inkindirr, a ta tsu yo ku zizo, undurr wanggo a sama ni inkindirr, aba ta vu ma kpa ivi inkindirr ntsɨ yi nggo a kye du uwa a se na yi nggo.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ayirr a Yesu na amuyirr bi Yesu ba a nga di aba a ta ni hi ma, akpa anishirr wa a ttu ma nado, aba ma chankarr ni ichi ki ywhiywhirr na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Undurr numa ddu Yesu di, “Anayirr muwa ngga na amuyirr amuwa ba a kri na bi da aba nye hi ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu à ddu ba di, “Ayirr na amuyirr amungga ba a si abangga ba nggo a wo ure ku Abachi ku na na inkindirr yi nggo u da nggo.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Azhibarr numa, Yesu a mirri nu uddu ku amasirr na ddu abiga ma ba di, “Di inta i kucha kuma nu ugugarr ki izzo amasirr ku.” Aba gru mirri nu ddu ku na so kuma. ");
INSERT INTO ninNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nggo a so darr nu uddu ku na so kuma, ina i vu Yesu. Unddunddu unkpi gru so go kyekye mi ni so vu amasirr surr nu umi ku uddu ku, u gru ta ko ji rri, ittu i klo ba na ashishi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Abiga ma ba ku a si ma di, “Ankpye! Ankpye! Inta ta kɨ.” Yesu à gru na nggarr ito nu unddunddu ku ku tuku ankinkirr ka amasirr ka. Unddunddu ku u kukri ni go yi, ankinkirr ka a ba ttungo, amasirr wa a ba ki ywi. ");
INSERT INTO ninNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu à zhi abiga ma ba di, “Ikpanye imba yi i se namo mu?” Isisu ki ba, aba a ku ayisurr na zhi ikpa di, “Uwanggo su unggonggo? A nggarr ito nu unddunddu ku tuku amasirr mi, aba wo ma.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","A kucha zhi na anga a Galili wa na kuma na anga ka igbu nu Gerrasa wa. ");
INSERT INTO ninNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nggo Yesu à ko huzzu nu uddu ku ma yo nu unddu ku amasirr ku, na ma nu ugo numa zhi ni igbu wa, izhi indanda i rri so ku nu ukpa. Uwa à tanko ba ni di zirr ni ihorr, na si di so ni iko mremremu hen. À di so na abe. ");
INSERT INTO ninNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nggo ugo a hi Yesu, mre na nggarr angu a yi na jaku ku na aza, na du hantu di, “Ùwà zha angginggi ni ingga ku, Yesu Uvuvurr a Abachi Unkpi Kakami wa! Ingga tsi ku ùwà ango, si ki ingga iha hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ugo wa da meme nu nggo Yesu à ka da ku izhi ndanda yi di bu ssuzzu ku nu ukpa. Ankpu shishemi izhi ndanda yi a di ba ugo wa nggurr. Ni ima yo, aba di vu ma lo na ache, izhi ndanda yi di du ma tsɨ ache ka nggo a lo ma na ka na ango tuku na aza kahre na ssuzzu zirr kuma na ankla ka nggo anishirr a si do hen. ");
INSERT INTO ninNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu à zhi ma di, “Isa imuwa yi i ri unggonggo?” Uwa ddu ma di, “Akpa”, nu nggo anazhi shishemi a rri so na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Anazhi ba tsi ku Yesu ango di a bu si han ba ku surr nu udduddu ku nggo u ta sama ni ikikre. ");
INSERT INTO ninNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akpa anikpama a so ri ni ine igbre yi. Anazhi ba a barr Yesu di a bu du aba kuma ku rri na anikpama ba ba. Yesu a kpanye ba ma. ");
INSERT INTO ninNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mre, anazhi ba a huzzu nu ugo wa ku, na ku rri ku anikpama ba, akpa anikpama wa kru ji ni ine igbre yi, na ku kuhre rri na amasirr na gu kuma. ");
INSERT INTO ninNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nggo abi so ho anikpama ba a hi inkindirr yi nggo i la, na kru rri nu umi igbu ku na ga igbu itsitsa yi, na so bre ure ku kago. ");
INSERT INTO ninNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Anishirr huzzu nye ikye inkindirr yi nggo la. Nggo a nga ni Yesu ku, na ni hi ugo wa nggo anazhi ba huzzu na ku nggo, uwa so hinga ku Yesu na aza, na surr iki, itu ima yi i si iyirr, isisu ki anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abangga ba nggo a ku hi nggo na kakuma ku da ku anishirr iwre i ugo wa nggo anazhi ba a di so na ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mre, isisu ki anishirr ba na anga ka Gerrasa ka we, aba barr Yesu di a bu huzzu share na anga kama. Nggo Yesu rri nu uddu ku na ta ko share, ");
INSERT INTO ninNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ugo wa nggo anazhi ba a ssuzzu ku nggo, a tsi ku Yesu ango di a bu du uwa ga ma. Yesu à kisa ku na ddu ma di, ");
INSERT INTO ninNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kakuma ni iko ku bre ba inkindirr yi nggo Abachi a na ku ùwà.” Ugo wa à kakuma kago umi igbu ku na so bre ba inkindirr inkpi yi nggo Yesu a na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nggo Yesu à kucha kakuma nu ugugarr ku izzo amasirr ku zizo, anishirr ba nggo a kri ko kye anko ama wa a kpa ma na ango aha. ");
INSERT INTO ninNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ugo numa nggo a yo ma di Jarru, à sa ankpye nu uki ku issubi ku igbu ku, na nga ni jaku ku Yesu na aza, na tsi ku ango, di a bu ga uwa kuma ni iko ima, ");
INSERT INTO ninNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","du uva ama ta ko ttu. Uva wa a si na ase awurr na aha, na si ku ayirr wa uyirr wama yo. Nggo Yesu à zzu so ga anko wa, akpa anishirr wa a ma ma, uwa à ma ittu unddunddu chankarr. ");
INSERT INTO ninNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ayamba numa a ki ase awurr na ha nu ulolo ku ji ayiyi. A ka varr azo na abi fu ba chankarr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ayamba a rri ga akpa anishirr wa, na nga nu ugo ku Yesu, na ni sa ungo nu nzirrnzirr ku ankru ka Yesu ka. Mre, iji ayiyi yi i kukri. ");
INSERT INTO ninNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu zhi ba di, “Unggonggo a sa ungo ni ingga ku?” Anishirr ba wemi a kisa. Biturr à ddu Yesu di, “Ankpye, ùwà ssurr akpa anishirr wa nggo a ttu ùwà nggo?” ");
INSERT INTO ninNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu a ddu ma di, “Undurr a sa ungo ni ingga ku. Ingga i hi ukyekye u ssuzzu ki ingga nu ukpa.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nggo ayamba wa à hi da a fo uwa hi, na gru so wri kpakpa na ni jaku ku Yesu na aza. Na da ku na ashishi ka anishirr ba, inkindirr yi nggo i du uwa a nga ni sa ungo ku na ku nggo, tuku nggo iji ayiyi i ba ttungo ku inkpo yirr. ");
INSERT INTO ninNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesu a ddu ma di, “Iviya, iyo isisurr imuwa inggi du ùwà wre. Kuma ni isu isisurr.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nggo Yesu a ni so re, unitu numa a zhi ni iko i Jarru na ni ddu Jarru di, “Si so tsutsarr unitsarr wa gbami hen, uva mi wa a ka ttu ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu à wo meme nggo, na ddu Jarru di, “Si du isisu ki ùwà hen. Yo isisurr yo mre, uva wa a ta wre.” ");
INSERT INTO ninNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nggo à nga ni iko i Jarru yi, Yesu à kisa ku inkpu anishirr yi ni rri ga ba yi, na du ani Biturr, i Yohana tuku Yakubu, na aki tuku ayirr a uva wa du ba a rri ga ma. ");
INSERT INTO ninNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Anishirr ba wemi a ko ba azhittu na yi uva wa hantu. Yesu à ddu ba di, “Si yì hen, uva wa si ttu hen, a kurr si ina mu!” ");
INSERT INTO ninNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Aba hi du uva a ka ttu ba, na me̱ Yesu mi me̱ mu. ");
INSERT INTO ninNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu a vu uva wa nu ungo na da di, “Inkparr uva, tasi!” ");
INSERT INTO ninNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mre, izhi i uva yi ikanga, uwa turr do gru kri ki kri. Yesu ddu ba di a bu nu ma inkindirr a ri. ");
INSERT INTO ninNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Akiki bu uva ba a ku ayisurr, Yesu à nggurr ba, di a bu si da ku undurr inkindirr yi nggo uwa na hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu à yo abi ko na angu awurr na aha ba ni inkla yirr, na nu ba ukyekye ku han anazhi ndanda we, na bu du abu ilolo a wre. ");
INSERT INTO ninNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na tu ba di a bu ku bre ku anishirr ure ku ittu i Abachi yi, na bu du abu ilolo a wre. ");
INSERT INTO ninNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Na ddu ba di, “Imba si gri inkindirr ni huzzu kuma nu uzirr ku hen. Si ba unflankurr ku yi ungo mi hen, ka ambu, ka ila, ka azo, ni si gri inkinkru iha hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nggo imba ti rri ni iko yi nggo a kpa imba, imba bu so ni iko ima yi ma na azhibarr wa nggo imba taka gru ni igbu wa. ");
INSERT INTO ninNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Anishirr bi igbu ba nggo a ti kà imba, imba ti ta share imba ttu ihurr yi na aza amba surr ba. Uwama su ba inkindirr igba ba utu, di Abachi taka ki ba iha.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Abi ko na angu ba kuma ni igbu tsitsa yi kago, ku di bre ba Ure ku wre ku, na du anishirr wre ni ivri imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nggo Hirridu, uni gri anga ka Galili wa à wo aseki ka nggo Yesu ko na ka, na nggurr zarr, nggo anishirr banu ko ku da ku di Yohana uni zzu na amasirr wa a tasi, na se. ");
INSERT INTO ninNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Abanu so da di Yesu à su Iliya uni kpa are a Abachi, uwa mu nggurr huzzu. Abanu da di Yesu su unuma nu umi ku abi kpa are bi kuchi ba yo à tasi zizo. ");
INSERT INTO ninNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","U Hirridu à da di, “Yohana nggo ingga i ka du ba vu ma ttu ku itu ba. Uwa su unggonggo, nggo a so bre are ni itu yi zizo?” Na gru so zha anko wa nggo uwa ta sa ashishi ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nggo abi ko na angu ba a ku kanga, na ni da ku Yesu inkindirr yi nggo aba ko ku na yi, uwa yo ba na kuma ni igbu wa nggo a yo ma di Betsada, nggo a ta ko kuso na akpambarr nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Akpa anishirr wa wo unto ku nggo à ko na gru ga ma. Uwa kpa ba, na bre ba ure ni itu i Ittu i Abachi yi, na du abi lo ba wre, nâ ta si nggo a so zha. ");
INSERT INTO ninNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nggo azhi wa ta ko ku, abi ko na angu ba, aba awurr na aha mi (12), a gru nga ni Yesu ku ni ddu ma di, “Du anishirr ba kuma ni igbu itsitsa yi ni izzuzzu yi nggo se kago ni inggya, hi da a ta ku hi ila na abubo ikurr. Inggya a si nâ ta si ankpuji mu.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu ddu ba di, “Imba ku atu amba, imba nu ba inkindirr iri.” Aba da di, “Inta se na ankpinkpri unfonfo akywi (5) yo ni ikikla iha (2), nggo iji inkpu. Uwa zha di inta bu ku re ku akpa anishirr anggo ila?” ");
INSERT INTO ninNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Anishirr aniru ka ma ukrɨ ukywi (5,000) mu, nggo a kri nabo). Yesu da ku abiga ma ba di, “Imba du anishirr ba ga so na ankla na ankla ki iso ikywi kywi.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Abiga ma ba a na meme yo, anishirr ba we a ji so. ");
INSERT INTO ninNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesu ki ungo kpa ankpinkpri unfonfo akywi ka ni ikikla iha yi, na kye hun ko nu ussu, na nyarr ku Abachi, na mɨ ka nu abiga ma ba, di a bu kpa ga ku anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Aba ri shi na du ikpu imbimbru yi, abiga ma ba vu yi ssu ni isisa iwurr ni iha (12). ");
INSERT INTO ninNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","A si na azhibarr numa nggo Yesu ko ku so barr na ankpa ma, abiga ma aba yo a se na ku mre. Uwa zhi ba di, “Anishirr ba da di ingga su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Aba ddu ma di, “abanu da du uwa su Yohana uni zzu na amasirr, abanu da du uwa si Iliya, abanu da du uwa su unuma nu umi ku abi kpa are bu ngbangba ba, nggo tasi.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","I Yesu zhi ba da di, “Imba na? Imba da di ingga su unggonggo?” I Biturr da di, “Ùwà yo su Kristi wa nggo zhi na Abachi ku.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu gba ba utu gbigbi di a bu si da ku undurr hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu da ba zizo di, “Uvuvurr a Unushirr ta ki iha kakami. Akikre anishirr ba, na ankpinkpye abikye ba, na abitsarr are ba ta kà ingga, na ta ngu ingga. U nu utarr wa, Abachi ta ta ingga si.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Yesu ddu ba wemi di, “Undurr wa nggo ti zha du uwa ta ga ingga, uwa bu kpamusu ni itu ima, na di ba unkunkurr ku ikpa umaku ttuttumi, na ga ingga. ");
INSERT INTO ninNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Undurr wa nggo ti du uwa ta kpa itu ima ttungo, uwa ta ttu. Undurr wa nggo ti ba itu ima yi a ni ingga, uwa si ta ttu hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Unushirr ta kpa angginggi nu nggo à ti se na aseki ka ingbingbru ka namri, i ni ikikre yi uwa si taka kpa iso sese hen? ");
INSERT INTO ninNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Undurr wa nggo ti kru ishisha mungga ni itsarr mungga yi, ingga Uvuvurr a Unushirr mi taka ni kru ishisha ima yi, nggo ingga taka nga ni inkpinkpye imungga yi, ni inkpinkpye i Aki mungga yi, na abitu abi wre ama ba. ");
INSERT INTO ninNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ingga so da ki imba di abanu ni inggya a taka hi ittu yi Abachi bari na kɨ.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nu ugo ku ivi itandarr nggo Yesu bre ba aseki angga ka, uwa ba Biturr, i Yohana tuku Yakubu, na hun kuma ni igbre numa ko kuso barr. ");
INSERT INTO ninNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nggo Yesu ku so barr wa, ashishi ama ka a kasarr, iki isurr ima yi i là nzarrnzarr. ");
INSERT INTO ninNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Aba kakye anishirr aha a kukri so re na ku. Uwa à su anu Musa tuku Iliya. ");
INSERT INTO ninNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Aba aha mi kri ni inkpinkpye, na ni kri so re ni Yesu ku ni itu yi nggo a da di à ta ni ttu nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Biturr na akpukpa ama bu zirr ba a ku kurr ina zzu nâ ta sa a ku mu. Nggo a kasi, na hi ila nzarrnzarr i Yesu yi. Na hi anishirr aha ba, anu Musa tuku Iliya, aba so re ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nggo anishirr aha ba a ta kuma na ka Yesu du, Biturr ddu ma di, “Ankpye, i wre kakami nggo inta se nu ùwà ku ni inggya. Inta ta na ki imba aburr atarr, iyirr muwa, iyirr ku Musa, iyirr ku Iliya.” (Na si hi inkindirr yi nggo à so da hen). ");
INSERT INTO ninNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nggo a ni so re, akpa ji zhi nu unkplassu ni ttu ba nado. Isisu ki abiga ma ba, nu nggo akpa ka ji ni ttu ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Aba wo ukorr zhi na akpa ka da di, “Uwanggo yo su Uzumu wa, nggo ingga hla. Imba wo ma yi!” ");
INSERT INTO ninNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nggo ukorr ku ba ttungo, aba hi Yesu kri na ankpa ma. Ni ivi ima yi abiga ma ba a ji nga na ni ki ywi na si da ku undurr inkindirr yi nggo aba hi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nu uha wa, nggo Yesu na abiga ma ba atarr mi a ka ji zhi ni igbre wa, akpa anishirr nga ni ma na ku na anko. ");
INSERT INTO ninNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ugo numa nu umi ku akpa anishirr ku a du hantu di, “Unitsarr! Ingga barr ùwà, kye uzumu wa nggo à si ki ingga ingbingbi iyirr ima yo mre. ");
INSERT INTO ninNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Izhi ndanda nggi di tsutsarr ma, ni du ma di hantu tankpami, na di tsɨ ssu antinte na angu, ni so di na ma ki undanda ttuttumi, ni si ttu ma ttungo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ingga barr abiga muwa ba di a bu han izhi yi huzzu ku uvuvurr wa, aba a han yi chankarr.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu ddu ba di, “Imba bi sa ni iyo isisurr! Imba ndanda anishirr! Imba kye ingga ta di so sese mu nggi ni imba ba, ni ka so di vu isisurr?” Na da ku ugo wa di, “Gri uzumi wa nye ni inggya.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nggo uvuvurr wa ta ko gru kuma ni Yesu ku, izhi yi i ba ma gri ni nggurr kparr, ni du ma tsɨ. I Yesu nggarr ito ni izhi indanda yi ku na du uvuvurr wa wre, na ka ma nu aki wa. ");
INSERT INTO ninNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Anishirr ba wemi nggo kri nabo a hi inkindirr ima yi na ku ayisurr nu ukyekye ku Abachi ku. Nggo anishirr ba ni ko ku ayisurr na aseki ka nggo aba a ku hi Yesu ni ko na ka, uwa ddu abiga ma di, ");
INSERT INTO ninNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Imba bu si kpamusu ni inkindirr yi nggo ingga ta da ki imba ziza nggo hen! A ta ba ingga Uvuvurr a Unushirr nu anishirr abi kà ingga ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Abiga ma ba si hi inkpi i ure ima yi hen. Abachi nggo ka inkpi i ure yi sharri ba. Isisu ki ba ni zhi ma inkindirr ni itu yi. ");
INSERT INTO ninNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Abiga ma ba gru so ri anta ni ikpa du uwatanggo ta sa ankpye. ");
INSERT INTO ninNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu hi amarr ambarr ka, na ba inkparr uvuvurr numa, na du ma kri ku na anga yirr, ");
INSERT INTO ninNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","na ddu ba di, “Undurr wa nggo ti kpa uvuvurr uvutsa ma mi ni isa mungga, uwa kpa si ingga. Undurr wa nggo ti kpa ingga, uwa kpa su undurr wa nggo à tu ingga. Undurr wa nggo su uvutsa kakami nu umi umba ku, uwa yo sa ankpye kakami wa.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","U Yohana da di, “Ankpye, inta i hi undurr numa nggo à ko han anazhi huzzu ku anishirr ni isa muwa, na si se nu umi munta ku hen, inta han ma di a bu du ma.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Yesu ddu ma di, “Imba bu si han ma hen! Undurr wa nggo ta si kà imba hen, uwa sa amba.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nggo ivi yi i so nga nggo a ta ba Yesu hun kuma nu unkplassu, uwa gru kpanye ni isisurr ima du uwa ta kuma nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Na tu abitu abanu kuchi kuma ni igbu numa nu Samarriya, di a bu ku ssu aseki ka bi ku namri. ");
INSERT INTO ninNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nu nggo abi igbu ba a hi krizhizhi mi di Yesu à so kuma nu Urushalima, ima yo du anishirr ba nabo a si kpa ma hen. ");
INSERT INTO ninNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Abiga ma ba, Yakubu tuku Yohana a hi meme na zhi ma di, “Atiko, uwa zha di inta bu yo uru nggo zhi nu ussu du ku ji ni tu ba ngɨ?” ");
INSERT INTO ninNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesu kasarr, na nggarr ito na ba. ");
INSERT INTO ninNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mre i Yesu na abiga ma ba a kuma ni ìgbù numa. ");
INSERT INTO ninNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nggo Yesu na abiga ma ba a vu anko so kuma, ugo numa à nga ni ddu Yesu di, “Unto ku nggo uwa ti kuma, ingga ta ga uwa.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu ddu ma di, “Anihon a se na ahon, aminu a se ni ako, ingga Uvuvurr a Unushirr sama nu unto ku ka itu sharri.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Na ddu ugo numa wa di, “Ga mi.” Ugo wa da di, “Ankpye, di ingga ku so ni ka ba aki mungga zzu bari.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu ddu ma di, “Du abangga ba nggo sa ni izhi iso sese nggo a si nâ ta sa abi kɨ a bu ko ku zzu ikpa ambarr. Ùwà, kuma ku da ure ku ittu i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ugo numa ddu ma di, “Ankpye, ingga ta ga ùwà, ùwà bu di ingga ku da ku abi iko mungga ba bari.” ");
INSERT INTO ninNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu ddu ma di, “Uni do ni ilando wa nggo ti ko do, na bu kakye ugo, uwa si ta ma ina undu ni ittu i Abachi yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nu ugo kuma Yesu hla anishirr iso itangba na aha (72) na tu ba huzzu na aha ha, du ba bu kuchi kuma ni igbu yi ni into yi nggo uwa ta ko kuma na yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Na da ba di, “Ikiri inggi i wri kakami, abu undu ba a su ntsɨmi. Imba barr Akikye ni ikiri wa du ma turr abu undu huzzu shishemi du ba ni ssu ikiri bi. ");
INSERT INTO ninNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ziza nggo, ingga ko tu imba zzu amumarr aminta ngga nu umi ku aniche. ");
INSERT INTO ninNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Imba si gri ambu, ka azo, ka anggakpaza ki aha hen. Si kukri ni so chi undurr na anko hen. ");
INSERT INTO ninNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nggo imba ti rri ni iko i undurr, imba bu da di, ‘Iso su ni iko inggi yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Unushirr ni iso su nggo di kpanye na anishirr ba à ti se ni iko yi, imba du ichi imba i iso su yi i kuma na ku, undurr ti sama imba ba ichi imba i iso su yi ni kuma. ");
INSERT INTO ninNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Imba so ni iko iyiyirr ima yi nggo a kpa imba yo, ni ri ni so inkindirr yi nggo a ti ri na so na tsu ni imba. I wre a bu han ku unu undu azadi ka undu ama ka, ni si gru di sarr akonki hen. ");
INSERT INTO ninNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Imba ti mirri ni igbu aba kpa imba, imba bu ri inkindirr yi nggo a zu ki imba na age̱. ");
INSERT INTO ninNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ni du abu lolo ba wre ni igbu wa. Ni da ku anishirr ba nabo di, ‘Ittu i Abachi yi i si ywhiywhirr mi ni imba ba.’ ");
INSERT INTO ninNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Imba ti mirri ni igbu wa nggo a kà ikpa imba, imba ka huzzu zirr ga anko ka umi igbu ka ni da di, ");
INSERT INTO ninNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ihurr igbu imba yi nggo i so ki inta na aza, inta ttu yi surr ki imba, wre ki imba bu hi di Abachi taka ni ki imba iha. Imba bu hi meme di: Ittu i Abachi yi i si ywhiywhirr mi ni imba ba.’ ");
INSERT INTO ninNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ingga so da ki imba di na azhibarr a ibre amu wa, Abachi taka ki itito nu Sodomu ku mri igbu wa ma! ");
INSERT INTO ninNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Uje umba Korrazi! Uje umba mi meme Betsada! Iki i ikagri yi nggo a na yi ni imba ba, ka da a na yi nu Taya tuku Sido, ka si ma anishirr ba nabo a ka ku so na surr angbanja iki ka ivri isisurr ba, na surr inturu ni itu, na tsarr da aba a ka kasarr ni ila ure imbarr yi ngbangbamu. ");
INSERT INTO ninNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na azhibarr ibre amu wa, Abachi taka ki itito na anu Taya tuku Sido ba mri imba. ");
INSERT INTO ninNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Imba anishirr ba nu Kapanahu! Imba kye da Abachi ta gri imba hun kuma nu ussu? A si ta na meme hen. Iya! A ta turr imba surr nu abubo a iso abi kɨ wa!” ");
INSERT INTO ninNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu da ku abiga ma ba di, “Undurr wa nggo ti wo imba uwa so wo si ingga. Undurr wa nggo ti kà imba, uwa kà si ingga. Undurr wa nggo ti kà ingga uwa kà undurr wa nggo à tu ingga.” ");
INSERT INTO ninNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anishirr iso itangba na aha (72) angga ba a kanga ni inyarr, na da di, “Atiko, anazhi mi a wo inta, nggo inta nggarr ito na ba ni isa muwa!” ");
INSERT INTO ninNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu ddu ba di, “Ingga hi Isheta ko jaku zhi nu unkplassu zzu nâ ta si ìlà i inge̱. ");
INSERT INTO ninNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wo yi! Ingga ni imba ukyekye nggo imba ta hun zirr na ànìwǎ, na anila, ni nu imba ukyekye ku nggo imba ta ba Isheta uni kà imba wa, inggurr. Inkindirr si ta ki imba hen. ");
INSERT INTO ninNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Imba bu si nyarr di anazhi ba a wo imba hen. Inyarr imba yi bu si nu nggo a charr asa a imba wa nu unkplassu nggo.” ");
INSERT INTO ninNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na ankpu ama wa, Izhi Iwre yi i du Yesu à si ni inyarr. I Yesu da di, “Aki, Akikye nu unkplassu tuku imimi, ingga nyarr ku ùwà, nggo ùwà tsarr amumarr ba aseki ka nggo ùwà sha ka sharri ku abi bwu ashishi na abangga ba nggo a hi ibre angbamvu. I si meme yo, Aki mungga, uwanggo yo si inkindirr yi nggo uwa nggo kpanye ni na yi meme. ");
INSERT INTO ninNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Aki mungga wa à ni ingga aseki ka namri. Undurr si hi ka uvuvurr wa à su unggonggo hen. Uwa sa Aki wa yo na nkpama à hi. Undurr si hi nggo Aki wa se hen, Uvuvurr wa yo na nkpama hi, na abangga ba nggo Uvuvurr wa hla ba na tsarr ba na ku nggo.” ");
INSERT INTO ninNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu kasarr ko na abiga ma ba na anga yirr, na ku da ba sharri di, “Abachi à yo ki imba angu ka iwre, nggo imba hi aseki ka nggo imba so hi ka ziza nggo! ");
INSERT INTO ninNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ingga ko da ki imba di abi kpa are na atuttu shishemi a zha da aba ka hi aseki ka nggo imba so hi ka, na si hi anko wa hen, na zha da aba ka wo aseki ka nggo imba so wo ka, na si wo ka hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Unitsarr na angbamvu ka Are ka à gru kri du uwa ta tsarr Yesu kye di, “Unitsarr, ingga ta na kingginggi wre ki ingga bu kpa iso sese?” ");
INSERT INTO ninNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu zhi ma di, “Ungbamvu ku Abachi ku da kingginggi? Inkpi i ure yi i si da angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ugo wa da di, “ ‘Kpanye na Abachi, Atiko muwa wa ni isisurr iyirr, ni izhi muwa iyirr, nu ukyekye muwa ku wemi, na amarr muwa ka namri’; ni ‘Kpanye nu uni girr amuwa nâ ta si nggo ùwà kpanye ni itu muwa.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu ddu ma di, “Uwa da ma. Na meme yo, uwa ta kpa iso sese.” ");
INSERT INTO ninNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Unitsarr na Are wa zha di anishirr a bu hi du uwa di kru isisu i Are yi, na gru zhi ma di, “Unggonggo su uni girr amungga wa?” ");
INSERT INTO ninNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu ddu ma di, “Ugo numa ko ji zhi nu Urushalima na ko kuma nu Jerriko, abayi a zzu vu ma, na kpa iki ima yi, na hlo ma ki rrerre, na ka ma du. ");
INSERT INTO ninNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nggo unikye a anu Yahuda numa so ga anko ama wa, na ni hi ugo wa kurr na anko wa, na zirr ni gigarr ka ga anga numa wa, na kuma. ");
INSERT INTO ninNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Uni zi undu nu Uki ku Abachi numa, nggo zhi nu uga ku Levi, à nga na ni na meme yo. A ni ko ku klo kye ugo wa, na kakuma meme. ");
INSERT INTO ninNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","U anu Samarriya numa à zirr uzirr uma mu na tsi ni ma nu ugo wa ku uwa kurr, na ki itito na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Na kuma na ku, ku ba ma, na hɨ ku ukpa, na surr ku anye na ahi na ankpa ka, na lo ku na ka nu upri inkru. Na ba ugo wa ni sa ni ijaki ama wa, na gri ma kuma nu unto ku nggo anishirr abi ko nu uzirr a ku di kurr na ri ila. Na ku kye ma nggarr ambre. ");
INSERT INTO ninNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nggo ambre ka nggarr, uwa zzu nu unikye abubo wa inklo azurrfa aha, na da ku di, ‘Bubomi, imba kye ki ingga na ku. Ingga ta kanga na anko anggo wa, ni ta ni han ku uwa inkindirr yi nggo ihun ni itu yi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ni ikikre yi, Yesu zhi unitsarr are wa di, “Ni ikye muwa, uwatanggo nu umi umbarr ku atarr mi a su uni girr a ugo wa nggo abayi ba a hlo ma?” ");
INSERT INTO ninNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Unitsarr na are wa da di, “Uwanggo nggo na wre ku ugo wa nggo.” Yesu ddu ma di, “Uwa mi kuma ku na meme yo!” ");
INSERT INTO ninNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nggo Yesu na abiga ma ba ko zirr na anko so kuma nu Urushalima, na ku rri ni ivi igbu numa. Ayamba numa nggo a yo wa di Marrta, a so ni igbu wa, na kpa ba gri kuma ni iko ima. ");
INSERT INTO ninNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Na se nu uvayirr nggo a yo ma di Maryamu. Maryamu ku ji so ku Atiko na aza, na so wo itsarr ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","U Marrta ki unfu di Maryamu à kà undu ku du ku uwa pempe, na du uwa so na ku na ankpa ma. Na kuma ku zhi Yesu di, “Atiko, i wre nggo uvamburr wa kà undu ku du ki ingga di ingga so na ku na ankpa mu? Da ku du ma nga ni zi ingga undu ku!” ");
INSERT INTO ninNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesu ddu ma di, “Marrta! Marrta! Uwa zharr itsutsarr itu muwa na ashiki shishemi. ");
INSERT INTO ninNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Inkindirr yi nggo i si izizi i si iyirr yo. Uvambirr Maryamu à ttu inkindirr izizi ima yo, nggo a si taka vu ma kpa yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na azhibarr numa nggo Yesu ku so barr nu unto numa. Nggo à barr kre, uyirr nu umi ku abiga ma ba a ddu ma di, “Atiko, tsarr inta nggo inta ta barr, nâ ta si nggo Yohana a tsarr abiga ma ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu ddu ba di, “Imba ti ta barr, imba da ma mi: “ ‘Ati munta, du isa muwa yi i kurr wre; du íttû muwa yi nga. ");
INSERT INTO ninNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ni inta ila iri munta yi ni ivivi yi, nggo inta di zha. ");
INSERT INTO ninNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ni nggurr ila ure munta yi zhi ki inta, nâ ta si nggo inta di nggurr zhi ku abi kpala ki inta ba. Si gri inta kuma nu unto ki tsarr kye hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu ddu abiga ma ba di, “Ka du uyirr nu umi umba ku a gru kuma ni iko i ukpama na atsutsu ibittu, na ku da di, ‘Ukpamu, ni ingga uhla ku ankpinkpri unfonfo atarr ngga. ");
INSERT INTO ninNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Kye, ukpamu nggo à ko zhi nu uzirr na mirri ni iko mungga. Ingga sama ni inkindirr iri nggo ingga ta ba nu ma ri!’ ");
INSERT INTO ninNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Uwa wo ukpami wa à re nu umi uki mu di, ‘Si ttutsarr ingga hen! A ka han anko ba. Ingga na amumarr mungga ba, inta ka ji kurr ba. Ingga si ta gru ni nu uwa inkindirr hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Di ingga da ki imba, a ti du uwa si ta gru ni nu uwa unfonfo wa du uwa su ku ukpama mi hen, uwa à ta gru ni nu ma aseki ka namri nu nggo à si kru ishisha hen, na ka na so zhi ma gbami hen. ");
INSERT INTO ninNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Meme nggo, ingga ko da ki imba di: Imba bu zhi, imba ta kpa; zha, imba ta hi; nggurr, aba ta bwu ki imba anko wa. ");
INSERT INTO ninNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Undurr wa nggo ti zhi, uwa ta kpa, undurr wa nggo ti zha, uwa ta hi. Undurr wa nggo ti nggurr, anko wa aba ta bwu ku. ");
INSERT INTO ninNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Unggonggo nu umi umba akiki à ka nu uzuma ìwǎ nggo à ti zhi ma ikikla? ");
INSERT INTO ninNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ka uzumi ka à zhi ùwà ihen, ùwà nu ma ìlǎ? ");
INSERT INTO ninNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Imba amimi mu di nu amumarr amba ba aseki azizi. Aki amba wa nggo su nu unkplassu wa mu nggo à di ni Izhi Iwre yi ku abangga ba nggo ko barr ma ka si hi ini aseki mri meme hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu ku han izhi huzzu ku ugo numa nggo izhi du ma si di re hen. Nggo izhi yi huzzu, ugo wa gru so re. Anishirr ku ayisurr. ");
INSERT INTO ninNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Abanu a da di, “A su Belzebulu, uttu ani inkindirr, uwa yo nu ma ukyekye ku han ba huzzu ku.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Abanu zha da aba ta tirr Yesu kye, di a bu na inkindirr numa isisu nggo i ta tsarr ba di Abachi nggo à tu ma. ");
INSERT INTO ninNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu hi amarr ambarr ka nggo na ddu ba di, “Anishirr bi ìgbù ba nggo ti ga akpa ki na nkanka, na ko di tsi ni ikpa, a si di ma ivi iha hen. Uga ku nggo ti ga ki na nkanka u di jaku meme. ");
INSERT INTO ninNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Anishirr bi Isheta ba ti ga kri na ko tsi ni ikpa, ittu yi ta kri kingginggi? Ingga da meme, nu nggo imba da di ingga so han izhi yi ssuzzu, di a su Belzebulu nggo ni ingga ukyekye ku na meme ku. ");
INSERT INTO ninNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ingga ti so han anazhi ba huzzu nu ukyekye ku Belzebulu, abiga amba ba di han ba nu ku unggonggo? Abiga amba ba mi da di imba da ndanda mi! ");
INSERT INTO ninNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","A su nu ukyekye ku Abachi nggo ingga di han izhi i ndanda yi. Ima mi i tsarr imba di ittu i Abachi yi i ka nga ni imba ba ba. ");
INSERT INTO ninNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Unushirr ukyekye, à ti zu atita ama ka itsi so gbye iko ima, iki iko ima yi i ta kurr ku zizi. ");
INSERT INTO ninNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Undurr ukyekye nggo à mri ma ti nga ni tsi na ku na mri ma, uwa ta vu atita ama ka gri na kuma na vu iki i iko ma yi ga ku anishirr. ");
INSERT INTO ninNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Undurr wa nggo ta si si amungga hen, uwa à karr ingga. Undurr wa nggo ta si zi ingga ssu ikiri bi hen, uwa si uni se kahre. ");
INSERT INTO ninNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Izhi i ndanda ti huzzu nu ukpa ku unushirr, i di zirr kuma ku zha unto ku iso su. I ti ku zha lankarr, i di ddu itu ma di, ‘Ingga ta kakuma ni iko mungga yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nggo i ti kakuma ni ku hi iko yi ikurr krizhizhi wre. ");
INSERT INTO ninNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","I di kakuma ku gri anazhi abanu atangba nggo a mri ma umimi, aba ta ga ma ku so nabo. Nggo a ti ku kuso kre ba, undurr wa kaki ndanda mri ni ime̱me̱ yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nggo Yesu ni so re, ayamba numa nu umi ku anishirr ku à gru re di, “Ayamba wa nggo a ngri ùwà nggo, Abachi à yo ku uwa angu azizi!” ");
INSERT INTO ninNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu ddu ma di, “Abangga nggo a wo ure ku Abachi ku na kpa ku na undu, aba mi Abachi yo ba angu ka iwre mri meme.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nggo akpa anishirr wa kri kago Yesu, uwa da ba di, “Anishirr bi ivi angga ba a si agbugbu kakami! A zha ihi ikagri. Undurr si ta na ba na yi mri inggi nggo Abachi à na ku Yunana hen. ");
INSERT INTO ninNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na anko wa nggo Yunana a sa angba ku anu Nineve, uwa si meme yo ingga Uvuvurr a Unushirr ta si ku anishirr ba ari ba angba. ");
INSERT INTO ninNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na Azhibarr a Ibre Ure wa, Ayamba wa nggo su Uttu nu Sheba taka gru kri na ni imba ba ari ba ikpala. Nggo à zirr zhi ni ìgbù numa gbagbamu, na kuma du uwa ko iwo itsarr i bwu itu i Uttu Solomo yi. Ingga ko da ki imba, undurr numa se ni inggya nggo à mri Solomo. ");
INSERT INTO ninNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Na Azhibarr a Ibre Amu wa, anishirr bu Nineve a taka gru kri ni imba anishirr ba ari ba ba, na ta da di imba i kpala. Nggo a wo ure ku Abachi ku nu Yunana ku, na kasarr ni ila ure imbarr yi. Di ingga da ki imba, undurr numa se ni inggya nggo à mri Yunana inkpinkpye! ");
INSERT INTO ninNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Undurr ka si yo uru ni ingba nu uru na ba ma sharri à ka si zu ma na ba agbugba ttu ma hen. A ta ba ma sa nu unto ku nggo su tsa, wre ku bu la kago ni iko yi na du anishirr ba kye hi. ");
INSERT INTO ninNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ashishi amba ka a su ku ukpa umba ku ingba nu uru. Ashishi amba ka ti si azizi imba ta kye wre. Nggo ashishi ka ti vri, ukpa ku si ni ibwu. ");
INSERT INTO ninNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kri gbangba ni du uru imba ku la ni si du ibwu ki hen. ");
INSERT INTO ninNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ukpa umba ku ti ko la namri intankla iyirr mi, i si se ni ibwu hen, u ta la kago nâ ta si nggo a di yo uru ni ingba wa u di la ki imba nggo.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nggo Yesu bre are kama kre, anu Farrisi numa a yo ma di a bu ku ri na ku. Uwa mirri ga ma ku ji so na abubo a iri wa. ");
INSERT INTO ninNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","U anu Farrisi wa a ku ayisurr, nu nggo Yesu ta ko ri sama ni ingla ango. ");
INSERT INTO ninNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","U Atiko wa ddu ma di, “Imba anu Farrisi ba di ngla ugo ku igbigba imba yi, u nu umi ku imba sa amimi anishirr. ");
INSERT INTO ninNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Arrurru imba! A si sa Abachi uyirr uwama yo nggo na abi ka, uwa yo na umi ku hen? ");
INSERT INTO ninNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Imba nu abi iha ba aseki ka nggo se nu umi ku igbigba umba ku, aseki ka tsatsarr ta ngla zzu ki imba na age̱ ka Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Uje umba anu Farrisi, nggo imba di nu Abachi uyirr nu umi ku uwurr nu umi ku aseki ka hin inyi, ni kà ikpanye na Abachi ku, ni si na uzizi hen. Imba bi na aseki ka wemi ni si ttu inuma glo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Uje umba anu Farrisi, imba di zha abubo a kuso ankpinkpye na aki ka issubi ka, ni di zha di a bu chi imba ichi i ankpinkpye nu udu. ");
INSERT INTO ninNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Uje umba yi! Imba si nâ ta si abe ngga, nggo a si di ssu ka kye hi hen, na du anishirr di zirr ba na ka si hi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Uyirr nu umi ku abitsarr Are ba à ddu ma di, “Ùwà ti da meme, ùwà marr inta mi kye na aba!” ");
INSERT INTO ninNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","I Yesu ddu ma di, “Uje umba abitsarr Are! Imba di vu iki irɨ sa ku anishirr na ago, imba ku atu amba si ta na ivri ungo mi, izi ba gri yi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Uje umba! Nggo imba i ssu abe ka abi kpa are ba na wre nanka. Abi kpa are ba nggo ábáchí ambirr a ngɨ ba, imba me ba abe ka wre. ");
INSERT INTO ninNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Meme nggo, imba kpanye ku ábáchí ambirr ba da a na wre. Ábáchí ambirr ba a ngɨ abi kpa are ba, imba me ba abe ka. ");
INSERT INTO ninNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ni ima yo, Abachi, nu ukrizhizhi umaku, à da di, ‘Ingga ta tu ba abi kpa are na abitu. Aba ta ngɨ inkpu yi, na ta ki inkpu yi iha.’ ");
INSERT INTO ninNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Meme nggo, Abachi taka ni zhi imba anishirr ba ari ba ayiyi a abi kpa are ba we, zhi ni ime̱me̱ i ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","E-e, ingga ko da ki imba anishirr ba ari ba, Abachi taka ni zhi imba ayiyi a anishirr angga ba namri, bazhi nu nggo a ngu Habila mu kuma nu nggo a ngu Zakarriya nu Uki ku Abachi ku, na atsutsu ka akikre ka ito nu Unto ku Iwre Sha Kakami ku. ");
INSERT INTO ninNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Uje umba abitsarr Are ba! Imba i gri inkpe̱ ibwu anko i kuma ni iko i ihi i Abachi yi. Imba si ta rri ko hen, ni han anishirr ni mirri kuma!” ");
INSERT INTO ninNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nggo Yesu à share nu unto kuma, abitsarr Are ba na anu Farrisi ba a re ku Yesu kago, na gru so zhi ma aseki shishemi, ");
INSERT INTO ninNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","da aba ta hi anko wa nggo aba ta vu ma ni da inkindirr numa ndanda. ");
INSERT INTO ninNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Na attuttu ama wa nggo akpa anishirr nu ukrɨ nu ukrɨ a huzzu shishemi na ko cha ikpa, i Yesu ddu abiga ma di, “Imba bu hi ndanda itsarr i anu Farrisi yi, nggo i si i ashishi aha. ");
INSERT INTO ninNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Inkindirr yi nggo a ti ttu yi zu sharri, aba taka ni bwu yi la na azhi. Inkindirr yi nggo ti na yi sharri, a taka gri yi nga ni ihi i anishirr. ");
INSERT INTO ninNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Meme nggo, inkindirr yi nggo anishirr ti da yi sharri ni ibwu, aba ta da yi huzzu na azhi du anishirr wo yi. Inkindirr yi nggo uwa ti da yi zhazha nu uki, a ta kpa yi du hantu ni ituki. ");
INSERT INTO ninNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Akpukpamburr, ingga da ki imba, imba bu si kru isisu i abangga ba nggo a ta ngu ukpa ku yo mre, na si ta na inkindirr mri meme hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ingga ta tsarr imba undurr wa nggo imba ta kru ma isisu nggo. Kru isisu i Abachi nggo se nu ukyekye ku ngu unushirr na turr ma yo nu uru. Ingga ta da ki imba zizo, Abachi nggo si ni ikru! ");
INSERT INTO ninNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A si di vɨ ananddu akywi re angalanzirr aha hen? Abachi si kpamusu nu uyirr nu umi umbarr ku hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Infunfutu imba yi mi i kri ni ibre mu namri. Imba bu si ki isisu hen. Kye, imba mri ananddu ba nggo kri shishemi! ");
INSERT INTO ninNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Ingga da ki imba, undurr wa nggo ti bwu angu ama da du uwa ga ingga, ingga Uvuvurr a Unushirr ta na ku meme yo na age̱ ka abitu ba Abachi ba. ");
INSERT INTO ninNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Undurr wa nggo ti huzzu krizhizhi mi na kà ingga, ingga Uvuvurr a Unushirr mi ta kà ma na age̱ ka abitu ba Abachi ba. ");
INSERT INTO ninNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Undurr wa nggo ti da ure undanda ni itu imungga Uvuvurr a Unushirr, aba ta nggurr zhi ku. Undurr wa nggo ti da ure undanda ni itu i Izhi Iwre yi, aba si taka nggurr zhi ku hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nggo ti gri imba kuma nu unto ku ibre amu na age̱ ka ankpinkpye ba, ka na atuttu ba, imba si ku ayisurr ni ri amarr ka inkindirr yi nggo imba ta da ni kpa atu amba ttungo nu unto kuma hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Izhi Iwre i Abachi yi i ta tsarr imba inkindirr yi nggo imba ta da.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ugo numa nu umi ku anishirr ku, à ddu Yesu di, “Unitsarr, da ku uzumburr wa di a bu tsu iki yi nggo aki munta a ttu na kadu ki inta a ni ingga.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu ddu ma di, “Ukpamu, unggonggo na ingga ki uni bre amu ka uni ga ki imba iki?” ");
INSERT INTO ninNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Na kuchi ni da ba di, “Imba bu so gbye ni bu kye ni si na ki abi zharr inkindirr hen. Undurr ka ti se na ashiki ka kinggi mi, uwa si ta so sese hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu à da ba assurre anggo di: “Ugo numa nggo à su nu ungo ni ikuchi yi, na se ni ila iwre ikiri. ");
INSERT INTO ninNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ugo wa gru ko ri amarr ni isisurr ima di, ‘Ingga sa nu unto ku nggo ingga ta zu ikiri mungga yi. Ingga ta na ki ngginggi?’ ");
INSERT INTO ninNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Na ddu itu ima di, ‘Ingga ta hlo iwurr imungga yi nggarr ni me inkpinkpi mu nggo ingga ta zu aseki ni ikiri mungga yi. ");
INSERT INTO ninNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ni ta da ku itu mungga di, “Ugo ni murrvu! Ùwà se na aseki zizi nggo ùwà ta zu ma ase shishemi. So su, ni ri, ni so, ni nyarr ku itu muwa.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Abachi ddu ma di, ‘Urrurru ùwà! Ni ibittu inggi yi ùwà ta ttu. Unggonggo ta na undu na aseki angga ka nggo ùwà zu?’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ni ikikre yi Yesu da ba di, “I se meme yo na abangga ba nggo so turr aseki ka ingbingbru ka zu ku atu ambarr, na sa ni inkindirr na age̱ ka Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu da ku abiga ma ba di: “Imba bu si tsutsarr atu amba, ni inkindirr yi nggo imba ta ri, ka imba ta surr hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Iso tsitsirr i mri ila. Ukpa u mri iki i surr. ");
INSERT INTO ninNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Imba kye aminche ba nggo a si di do hen, na si di hwa hen, na sama na aki ka zu ikiri, ka iwurr, ka inzaba. Abachi à so di nu ba iri. Imba mri aminu! ");
INSERT INTO ninNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Itsutsarr imba yi ka yo ki imba azhi yirr ni iso imba yi ni ingbingbru inggi yi? ");
INSERT INTO ninNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Imba ti ma chankarr ni ivintsɨ ma mi nggo mri imba ina, inkpinkpi yi mu na? ");
INSERT INTO ninNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Imba kye ugbyarr ku nggo di furr na ankpuji. U si di na undu inkindirr hen, na si di warr iki isurr ku atu ambarr hen. Ingga ko da ki imba di, Uttu Solomo nggo se na aseki shishemi, a si se na iki isurr iwre na ugbyarr ku ijiji ku hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Sa Abachi nggo di ni agiga ka iki isurr. Agiga ka nggo se ari, ambre a ka kɨ, aba ku yo uru na ka. Nggo Abachi di na meme ku agiga mu, uwa ta na kingginggi na si ta ni imba isurr hen! Imba abi isisurr ivuntsɨ! ");
INSERT INTO ninNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Imba si di tsutsarr atu amba gbami ni inkindirr yi nggo imba ta ri, ka imba ta so hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","(Anishirr bi ingbingbru ba di so yo isisurr imbarr yi na aseki ka ngga ka ma mi.) Aki amba wa a hi aseki akama nggo imba so di zha ka. ");
INSERT INTO ninNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Imba bu zha ittu ima yi, uwa ta ni imba inkpu iki yi namri kye ma. ");
INSERT INTO ninNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Imba si ki isisu hen, imba amumarr aminta. Aki amba wa a kpanye du uwa ta ni imba ittu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vu aseki amba ka re, ni ka inklo yi ga ku abi iha. Ni na ku atu a imba into isurr inklo yi nggo i si taka ngahre hen. Imba zu aseki amba ka nu unkplassu, nggo a si taka kre hen. Nabo, unayi si ta ku ba hen, idarr si ta ri hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Unto ku nggo aseki amba ka a se, isisurr i imba yi ta se nabo yo. ");
INSERT INTO ninNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Imba ssubi ku undu, ni yo uru ni ingba imba yi, ");
INSERT INTO ninNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ni na zzu nâ ta si amirr iko ba nggo so gbye anko a Atiko ambarr nggo ta kanga zhi nu unto ku ihru ayamba. Nggo à ti nga ni nggurr ba anko wa, aba ta gru bwu ku na wa hanhan mi. ");
INSERT INTO ninNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Amirr iko abama ta sa abi nyarr nu nggo Atiko ambarr wa taka kanga na ni hi ba so gbye! Ingga da ki imba, a taka ttu ankru ama ankpi ka glo, na taka ji so, na ri na ba. ");
INSERT INTO ninNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Amirr iko ba a ta sa abi nyarr kakami, nggo a ti ni hi ba so ssubi, ka à nga si ni ibittu, ka ni igambre! ");
INSERT INTO ninNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Imba mi hi di akikye ni iko ka hi azhibarr wa nggo unayi ta nga ni iko ima yi, uwa ka si kpanye na du unayi wa mirri hen. ");
INSERT INTO ninNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Imba mi bu so ssubi. Kye ingga Uvuvurr a Unushirr ta nga na azhibarr wa nggo imba si ta hi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Biturr ddu Atiko wa di, “Ùwà so da ki inta ngga, assurre wa, ka ùwà so da ku anishirr ba namri.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Atiko wa à ddu ma di, “A su unggonggo se nu uvuvurr iko ukrizhizhi nggo yo isisurr? Uwa yo su wanggo nggo akiko ma wa ba ma yo ki ankpye ni iko yi, di a bu gri iko yi na nu amirr iko banu ba ila na ankpu na ankpu. ");
INSERT INTO ninNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Uvurr iko wama taka nyarr kakami nggo akiko ma wa à taka nga ni hi ma uwa so na undu ku wre ni iko yi. ");
INSERT INTO ninNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Akikye ni iko wa à ta du ma kye iko yi namri. ");
INSERT INTO ninNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Uvurr iko wa ti gru da di akiko ama wa ta so gbami bari na kanga, na gru ko hlo amirr iko abanu ba, aniru na amba ba, na ri na so na hwa, ");
INSERT INTO ninNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Akiko ma wa à gru nga na azhibarr wa nggo uvuvurr iko wa si hi hen, na attuttu wa nggo a si so kye anko hen. Akikye wa taka ni tse ma ki ankpunkpu aha, na ta ki ma iha ndo na abi kà iwo ure abanu ba. ");
INSERT INTO ninNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Uvurr iko wa nggo hi inkindirr yi nggo akiko ma wa zha di a bu na ku na yi, na kà ina yi, a ta kpa ihlo kakami na amfarr. ");
INSERT INTO ninNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Uvurr iko wa nggo si hi inkindirr yi nggo aki iko ma wa zha da a bi na ku hen, nà ná inkindirr indanda, a ta hlo ma meme. Ihlo ima yi ta ma mi. Abachi ta zha shishemi nu unushirr wa nggo Abachi nu ma shishemi nggo. Uwanggo nggo a nu ma kri kakami, a taka kpa kri kakami na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ingga nye iyo uru ni ingbingbru yi. Ingga kye i ka wre i ka rri ba! ");
INSERT INTO ninNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ingga se ni izzu na amasirr yi nggo ingga ta kpa yi. Bazhi ziza, ingga ta so se nu umi ku iha ka ku ma na azhibarr wa nggo ingga ta kpa yi. ");
INSERT INTO ninNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Imba kye di ingga nye gri isu isisurr mu ga ki ingbingbru yi? Iya! A si si isu isisurr mu hen, si iga ki na nkanka mu. ");
INSERT INTO ninNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Bazhi ziza, iko yi nggo se na anishirr akywi i ta ga ki nanka. Atarr ba ta gru vi na aha ba ba, aha ba ta gru vi na atarr ba ba. ");
INSERT INTO ninNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Akiki ta gru vi na amumarr ambarr ba ba, amumarr ta vi na akiki ambarr ba ba. Ayiyirr ta gru vi na amumarr áníwá ba, áníwá ta gru vi ku ayiyirr ba. Ayimbarr ta gru ku ayamba a uzuma, amba amumarr ta gru vi na ayiyirr ba aniru ambarr.” ");
INSERT INTO ninNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu ddu anishirr ba wemi di, “Imba ti hi akpa ka so gru zhi ni ingbahru, imba di da di, ‘Ahru ta ku,’ ahru wa a ku jiji. ");
INSERT INTO ninNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Imba ti wo unddunddu u go ni hun hi hun, imba di da di issu i ki ywhiywhirr ba uwa si meme yo. ");
INSERT INTO ninNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imba abi na aseki wre ku anishirr a bu hi! Imba di kye imimi yi, ni kye akpa ka, ni da inkindirr yi nggo i ta la. Meme nggo, angginggi di imba si hi uzirr ku ingbingbru ku ni ivi inggi yi hen, nggo ingga se ni imba ba ziza. ");
INSERT INTO ninNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Angginggi di imba si di hla kye bari, ni na inkindirr yi nggo i si iwre hen? ");
INSERT INTO ninNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Undurr ti se nu ure ni itu muwa, na gri ùwà ko nu unto ki ibre amu, ùwà bu zha issubi na ku ni iko, ni si du imba kuma nu unto ki ibre amu ku hen. Ùwà ti kà, uwa ta gri ùwà ku nu uni hla amu wa. Uni hla amu wa ta kpa ùwà nu abi lo ukpa ba, aba ta gri ùwà ku ttu nu uki. ");
INSERT INTO ninNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ùwà ta si han inkindirr yi nggo a zu ku ùwà tsatsarr hen, uwa si ta du ùwà huzzu nabo hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na azhibarr ama wa, anishirr a se na ku, na da ku Yesu nggo Bilatu à ngɨ anu Galili na azhibarr nggo a nga ni so han inina yi na ko to ayiyi wa na age̱ ka Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu ddu ba di, “Anu Galili ba nggo a ngɨ ba meme, imba kye di abangga si abi la ure mri inkpu anishirr nu Galili? ");
INSERT INTO ninNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Imba mi, ingga ko da ki imba, imba ta si kasarr, ni du ila ure imba yi hen, imba mi ta kɨ meme yo. ");
INSERT INTO ninNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Abangga ba na anishirr awurr na atandarr ba nggo ugonka ku Silowa ku u ji ywhe ba na? Imba kye di abangga si ndanda mri anishirr ba nu Urushalima na? ");
INSERT INTO ninNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ingga ko da ki imba i si si meme hen! Imba ta si kasarr ni du ila ure imba yi hen, imba mi ta kɨ meme yo.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu gru da ba assurre anggo wa di: “Na sese ugo numa nggo ttu ibwa ni ila ima. Na ko ku di zha inkpinkpo yi, ibwa wa si klo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ugo wa à da ku unu undu ama wa di, ‘Kye, wanggo si ise itarr nggi nggo ingga di nga ni di zha inkpinkpo ibwa nu unkunkurr unggo ku, u si klo hen. Tse ku ta yo! U ta kri na angginggi ni so harr abubo wa gigyemi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Unu undu wa ddu ma di, ‘Du ku ma ni inarr bari. Di ingga ya imimi surr kago ku ichi yi, ni surr ku ingbarr i amuwu. ");
INSERT INTO ninNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Unkunkurr ku ti klo ìmbrèyìrr, i wre. U ta si klo hen bari, ùwà tse ku ta yo.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nggo Yesu ku so tsarr ba nu uki ku issubi ku na Azhibarr a Isu wa, ");
INSERT INTO ninNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ayamba numa nggo anazhi a ki ma ulolo, uwa so di gbo gbi gbo ase awurr na tandarr, na vu darr na à ka si gru ki tsa hen. ");
INSERT INTO ninNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nggo Yesu hi ayamba wa, na yo wa na ddu ma da di, “Ayamba, ivri imuwa yi i wre ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Na sa ungo na ku, uwa gru na ukpa, na gru kri ki kri, na nyarr ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ankpye nu uki ku issubi wa a ki unfu, nggo Yesu à du ayamba wa wre na Azhibarr a Isu wa. Na gru kri na ddu anishirr ba di, “Inta se ni ivi itani i na undu. Imba nga ni ivi ima yi ni kpa iwre imba yi, ni si nga na Azhibarr a Isu wa hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Atiko wa à ddu ma di, “Imba abi na aseki wre ku anishirr a bu hi! Imba si di ddu ilando ka ijaki imba yi zhi nu unto ku ri umbarr ku, du ba ku so amasirr na Azhibarr a Isu wa hen? ");
INSERT INTO ninNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Kye, ayamba anggo wa su uhanma a Ibrayi, nggo Isheta lo ma zu ki ase awurr na atandarr, imba di ingga bu si ddu ma ttungo na Azhibarr a Isu wa hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ida ima yi i du ishisha ki abi karr ma ba. Anishirr shishemi a nyarr ni iki iku ayisurr yi nggo Yesu a na yi. ");
INSERT INTO ninNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesu à zhi ba di, “Ittu i Abachi yi i si nâ ta si angginggi? Ingga ta tsarr Ittu i Abachi kye na angginggi ku? ");
INSERT INTO ninNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I zzu nâ ta si ingbingbi i mosita, nggo ugo numa nggo gri ku ttu ni ila ima. I zzu, ni kaki ichi inkpi. Aminche bi ingbingbru ba a ku na ako ni inggingga ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu à zhi zizo di, “Ingga ta tsarr ki imba angginggi kye ni Ittu i Abachi yi? ");
INSERT INTO ninNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I zzu nâ ta si ayamba nggo à ba imbimbru ikpu ssu na agbugba na tsu iyisti surr imbimbru ikpu yi i gru si.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu ko kuma nu Urushalima, na zzu di tsarr anishirr ba ga igbu inkpinkpi ni itsitsa yi. ");
INSERT INTO ninNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ugo numa à zhi ma di, “Ankpye, Abachi ta kpa anishirr ntsɨmi yo ttungo?” Uwa ddu ba di, ");
INSERT INTO ninNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ùwà mi bu ta ukpa ni rri ga anko avutsa wa. Ingga da ku ùwà, anishirr shishemi ta gru da aba ta rri kuma, na si ta hi anko wa hen. ");
INSERT INTO ninNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nggo akikye ni iko wa ta gru ku han anko wa, nggo imba ta kri nabo ni ta ko nggurr anko wa ni da di, ‘Ankpye, bwu ki inta anko wa!’ “Uwa ta ddu imba di, ‘Ingga si hi inkla yi nggo imba zhi hen!’ ");
INSERT INTO ninNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Nabo yo, imba ta gru ko da di, ‘Inta i ri ni so ndo nu ùwà. Ùwà i tsarr ni igbu imunta yi!’ ");
INSERT INTO ninNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Uwa ta da di, ‘Ingga si hi inkla yi nggo imba zhi hen! Imba chi share ni ingga ku, imba bi na awurr!’ ");
INSERT INTO ninNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Nabo yo, imba ta yì, ni ta nyirr nyirr, nu nggo imba ta hi Ibrayi, Ishaku, Yakubu na abi kpa are ba Abachi ba ni Ittu i Abachi yi, nggo a ta ddu imba glo! ");
INSERT INTO ninNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Anishirr ta zhi na anza ambre tuku ni ingbahru. Abanu ta zhi ni ikatu tuku ni ikashirr na nga, ni so ni imburr imbarr yi ni iga ittu i Abachi yi. ");
INSERT INTO ninNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Abanu nggo sa abi ime̱me̱ a ta kaki abu ikikre, abi ikikre a ta kaki abi ime̱me̱.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nabo, anu Farrisi ba nga ni ddu Yesu di, “Gru share ni inggya. Kye, uttu Hirridu ko zha du uwa ta ngu ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu ddu ba di, “Imba ko ku da ku inkindirr ima yi, ‘Ingga ko han izhi indanda huzzu, ni ko du anishirr wre ari. Na ambre, ívri nggi, ingga ta kre undu mungga ku.’ ");
INSERT INTO ninNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ingga ta ko kuchi nu undu mungga ku ari, ambre ni ívri. I si ta wre a bi ngu uni kpa are nu unto numa nggo si su Urushalima hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yesu da di, “E! Urushalima, Urushalima! Imba nggo ngɨ abi kpa are ba, ni di ta abitu ba Abachi ba na angbinta, nggo a tu ba ni imba ba! Inkpo ibirr nggi ingga zha issu amumarr amba ba bi, nâ ta si nggo ayirr iviko di kye na ssu amumarr ama ba bi na angba ama ka. Imba di kà! ");
INSERT INTO ninNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Kye, Abachi taka kà Uki unkpi ku Ibarr Abachi imba ku ni igbu imba wa. Ingga ko da ki imba di, imba si ta hi ingga zizo hen, imba taka hi ingga na azhibarr wa nggo imba ta ko da di, ‘Uwanggo nggo nga ni isa i Atiko yi, Abachi bu yo ku angu ka iwre.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","A si na Azhibarr a Isu numa nggo, i Yesu ko ku ri ila ni iko yi ankpye numa nu umi ku anu Farrisi ba, anishirr ba nggo a kri nabo gru so surr ku ashishi girr. ");
INSERT INTO ninNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ugo numa nggo aza ama ka na ango ka a si, à nga ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu à zhi abitsarr Are ba na anu Farrisi ba di, “I wre aba bu du unushirr a wre na Azhibarr a Isu wa, ka a bi du ma?” ");
INSERT INTO ninNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aba so gbangbami. Uwa yo ugo wa na du ma wre, na du ma kuma. ");
INSERT INTO ninNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Na ddu ba di, “Unggonggo alando ka uvuvurr alando amaka a jaku ni inkpri udduddu na Azhibarr a Isu wa, uwa ka kà wa du?” ");
INSERT INTO ninNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Aba si ddu ma inkindirr hen. ");
INSERT INTO ninNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu hi nggo abichirr ba nggo a yo ba ni iga yi a di zharr into i iso i iwre yi na abubo a iga wa, na da ba assurre anggo wa di: ");
INSERT INTO ninNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“A ti yo ùwà ni iga numa, ùwà bu si narr ku ji so nu unto ku ankpinkpye ku hen. Mi, a yo ankpinkpye banu nggo a mri ùwà. ");
INSERT INTO ninNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ugo wa nggo yo imba ha mi ta ni ddu ùwà, du ùwà bu gru ni nu ugo nggo wa abubo a iso wa. Ishisha ta ki ùwà ni ku so na abubo avutsa wa. ");
INSERT INTO ninNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Nggo a ti yo ùwà, ùwà bu ku ji so na abubo a iso avutsa wa, wre ku uni iga wanggo ta nga, uwanggo ta ni da ku ùwà di, ‘Ukpamu, gru ku ji so na abubo ankpi a iwre wa.’ Anishirr ba ta kye ùwà ssu nu ungo. ");
INSERT INTO ninNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Undurr wa nggo ti gɨ itu, aba ta nggurr ma yo nu ugo. Undurr wa nggo à ti kà itu ima ta yo, aba ta gɨ ma ki nu ussu.” ");
INSERT INTO ninNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu ddu ugo wa nggo a yo ma di, “Ùwà ti na iga, si yo akpukpambirr, ka amuyirr, ka amla mi, ka abi girr bu ungo hen, wre ku aba mi taka ni yo ùwà meme, han ùwà unka ku. ");
INSERT INTO ninNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ùwà ti na iga, ùwà bu yo abi iha, aba ankpu aza na aba ankpu ango, na aba akreshi. ");
INSERT INTO ninNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Abachi ta yo ku ùwà angu azizi. Nggo anishirr abama sama ni inkindirr i ka ni han ùwà, Abachi taka han ùwà na azhibarr wa nggo à taka ta anishirr ba nggo a kye ba a sa azizi ba kasi.” ");
INSERT INTO ninNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Uyirr nu umi ku abi so ri ndo ni Yesu ba ba à wo ure ku nggo Yesu da, na ddu ma di, “Abangga ba nggo taka so ni imburr inkpi yi na azhibarr a iga wa ni iko yi Abachi taka nyarr kakami!” ");
INSERT INTO ninNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu à ddu ma di: “Ugo numa nggo à ta na iga, na yo anishirr shishemi. ");
INSERT INTO ninNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nggo azhibarr wa ma, uwa tu amirr iko ama ba di a bu ku da ku anishirr ba nggo a yo ba di, ‘Nga yi ki kye inta issubi ba!’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Abichirr ba gru so da ivri imbarr na nkanka. Uni ime̱me̱ wa da di, ‘Ingga re īlá, i wre ingga bu ku kye yi. Kpa iyi imungga yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Unu uha wa da di, ‘Ingga re ilando ido iwurr, di ingga gri yi ku tsarr kye bari. Kpa iyi imungga yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Unuma wa da di, ‘Ingga garr ayamba ahe̱he̱ ni ivi inggi yo. Ingga si ta ko hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Uvurr iko wa kakuma ku da ku akiko ama wa, akiko wa ki unfu na ddu uvuvurr iko wa di, ‘Narr huzzu ku ga anko kpinkpi ka na a atsutsu ka umi igbu ku, ni yo abi iha, na aba kpre aza, na aba ankpunkpu ango, na aba kreshi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Uvurr iko wa à ddu ma di, ‘Ankpye, inkindirr yi nggo ùwà da, ingga i ka na yi ba, i zizami into ki iso u nise ma.’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Akiko ma wa à ddu uvurr iko wa di, ‘Kakuma na anko ka unddu ìgbù itsitsa yi, ni ku turr ba du ba nga, ni tsarr ssu ki ingga ni iko yi. ");
INSERT INTO ninNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ingga nggo ko da ku ùwà, abangga ba nggo ingga yo ba ni ime̱me̱ yi, uyirr mi si taka la ila imungga yi kye hen!’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","A sa azhibarr numa nggo, akpa anishirr so ga Yesu. Uwa kasarr na ddu ba di: ");
INSERT INTO ninNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Undurr wa nggo ti du uwa ta ga ingga, na si kpanye ni ingga mri ana ayirr, nu uwama, na amarr ma, na amuyirr aniru na amba, ni itu ima hen, uwa si ma uni ga ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Undurr wa nggo ta si ba unkunkurr ku ikpa umaku na ga ingga hen, uwa si ma uni ga ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Undurr wa nggo ti du uwa ta me iko, uwa si ta ji so na bɨ inklo yi kye, ka i ta ma, ka i ta klonyarr bari hen? ");
INSERT INTO ninNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","A ta si na meme hen, na gru zu ibarr i iko yi na du ime yi kukri na anko, anishirr ba nggo ti ko sarr ba nabo na hi yi a ta me̱ ma. ");
INSERT INTO ninNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Na da di, ‘Ugo nggo à du uwa ta me, nggo na klonyarr na anko!’ ");
INSERT INTO ninNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ka, ka du uttu numa nggo ta ko ni ta iku nu uttu numa, na si ku so na han kye, uwa na anishirr ukrɨ uwurr (10,000) ta ku ta iku nu uttu wa nggo se na anishirr ukrɨ iso iha (20,000) ku hen? ");
INSERT INTO ninNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Uttu wa ti hi du uwa ka si tsi kpa na ku hen, nggo a ti nise gbagbamu, uwa ta tu anishirr ama ba du ba ku zha issubi na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Na anko ayirr ama wa, undurr wa nggo ta si nggurr ugo nu aseki ka nggo se na ka hen, uwa si ma uni ga ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu da ba zizo di, “Ima i wre, imarr ima yi ti ka nado, a ta na yi kingginggi na du imarr yi i kanga? ");
INSERT INTO ninNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","I si ta se nu undu ku imimi mi hen, na ka si tsu yi surr na atsu mi hen. A ta ba yi ku kahre. Undurr wa nggo ti se na atu ka iwo ure, uwa bu wo!” ");
INSERT INTO ninNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na azhibarr numa nggo, abi kpa inklo imimi ba na abi la ure a gru nga ni Yesu ku, wre ba bu ni wo ma. ");
INSERT INTO ninNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Anu Farrisi ba na abitsarr Are ba a gru ko re gbrungbru di, “Ugo wa nggo à di kpa abi la ure na ri na ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","I Yesu da à ba assurre numa di: ");
INSERT INTO ninNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ka du uyirr nu umi umba ku, a se na aminta ayirr yirr (100), uyirr nu umi umbarr ku nado, uwa ta na kingginggi? Uwa ta ka iso itirr na atirr (99) ba du ni ijiji yi, na kuma ku zha uyirr wa nggo nado, ku hi bari. ");
INSERT INTO ninNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A ti hi ma uwa ta nyarr na ba ma sa na abubwa, ");
INSERT INTO ninNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","na ta gri ma nga ni iko. Na ta ni yo akpikpa ama na abi girr ama ba, na da ba di, ‘Ingga se ni inyarr, nggo ingga ku zha ivinta mungga wa nggo a nado hi. Ingga yo imba, di imba bu ni zi ingga inyarr ima yo!’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na anko ayiyirr ama yo, ingga ko da ki imba di, inyarr ta se nu unkplassu kakami ni itu i unushirr uni la ure uyirr nggo à du ila ure ima yi na kpa Abachi. A mri iso itirr na atirr ba (99) nggo a si abi wre ba nggo kye i si si ba inkindirr i iwre aba bu du ila ure imbarr yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu à da ba assurre anuma zizo di, “Ka di ayamba numa nggo se na angalanzirr awurr, i kpinkpirr iyirr i jaku nado, uwa ta na kingginggi? À ta murr uru ki, na vu uki ku, na so zha ku kye bwemi. ");
INSERT INTO ninNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nggo à ti hi yi, uwa ta yo akpukpama na abi girr ama ba na ddu ba di, ‘Ingga se ni inyarr, nu nggo ingga zha inklo mungga yi nggo i nado hi. Imba nga di inta ni nyarr yi!’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Meme nggo, ingga ko da ki imba da abitu ba Abachi ba nu unkplassu ta se ni inyarr kakami ni itu i unushirr uyirr nggo a du ila ure ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu da ba zizo di: “Ugo numa nggo à se na Amumarr aniru aha. ");
INSERT INTO ninNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Uvutsa wa ddu aki ambarr wa di, ‘Aki mungga, vu iki imuwa yi ga ki inta zizami, ni ni ingga imungga.’ Aki ambarr wa vu aseki ama ka ga ba aha mi. ");
INSERT INTO ninNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ni ivi ntsɨmi, uvutsa wa vu aseki ama ka re tsatsarr na kpa inklo yi na gru kuma nu uzirr. À kuma ni ìgbù numa gbagbamu na ku ri inklo yi kre na angu. ");
INSERT INTO ninNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nggo inklo yi i kre namri, iyo gru ki na anga akama, uwa sa ni inkindirr. Iyo ki ma kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Uwa gru kuma ku zha undu nu ugo numa ku, nggo a si abi ìgbù wama. Ugo wa à turr ma kuma nu unto ku nggo a zu anikpama ama ba, di a bu kuma ku di ho ku nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Uwa ku di zha du uwa ta ho itu ima ni ila yi nggo a di ni anikpama ba. Undurr mi si nu ma inkindirr iri hen. ");
INSERT INTO ninNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Nggo amarr ama ka a kanga ku, uwa da di, ‘Amirr iko ba aki mungga ba, a se na aseki nggo a mri ba iri. Kye, ingga nggo ko ttu ni ingaza ni inggya mi! ");
INSERT INTO ninNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ingga ta gru kuma na aki mungga ku. Ni ta ku da ku di, Aki mungga, ingga la ure na age̱ ka Abachi, ni ila ure na age̱ muwa. ");
INSERT INTO ninNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ingga si ma uni yo ki uzumi zizo hen. Na ingga ki uyirr nu umi ku amirr iko amuwa ba, nggo so di na ku ùwà undu.’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nggo, na gru ko kuma na aki wa ku. “Nggo a ni ko ta anko ni iko, aki wa hi ma ni ko nga yi, itito ki ma na ku. Uwa kru kuma nu uvuvurr wa ku, ku nyarr ma vu. ");
INSERT INTO ninNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Uvuvurr wa da di, ‘Aki mungga, ingga la ure na age̱ ka Abachi tuku na age̱ amuwa. Ingga si ma uni yo ki uzumi zizo hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Aki wa yo amirr iko ama ba na ddu ba di, ‘Narrma nye! Ku ba ankru ahe̱he̱ ka wre ni surr ku yi. Ni ba indehri ni yo ku ni uvuvurr ungo, ni vu anggakpaza ni surr ku na aza. ");
INSERT INTO ninNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ni kuma ku kye uvuvurr alando uzizi, nggo a ki ahihi, ni vu han yi, ni di inta nyarr ni na iga! ");
INSERT INTO ninNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Uzumu wanggo a ka ttu ba, i zizami uwa tasi. A nado, i ziza ingga hi ma.’ Mre aba a kuchi ni iga yi. ");
INSERT INTO ninNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Nggo a ko na meme, uzayirr nunku wa a nado ni īlá. Nggo a ko kanga, na ki ywhiywhirr ni iko na wo asarr ni inggingga irro yi. ");
INSERT INTO ninNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Na yo ugarr uyirr wa na zhi ma di, ‘Angginggi zzu?’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Uwa da ku di, ‘Uzumbirr wa yo a kanga ni iko, aki muwa à vu uvuvurr alando uzizi, nggo ki ahihi han ku, nggo a hi ma kanga kyekye.’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Uzayirr nunku wa ki unfu du uwa si ta mirri ni iko yi hen. Aki wa wo na huzzu ko ku barr ma di a bu mirri. ");
INSERT INTO ninNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Uwa ddu aki wa di, ‘Kye, ase angga ka nggo ingga so na ku ùwà undu zzu ugarr mu ni si kpala ku ùwà nu unto numa hen. Ùwà na ki ingga angginggi? Ivuwu mi nggo ùwà ka vu ni ingga di ingga kpa na irro na akpukpamburr, ùwà nise na meme kye! ");
INSERT INTO ninNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Uwa nggo yo su uzumi wanggo nggo à vu aseki muwa ka ku kahre ni izha amba, nggo nga ni iko ùwà ngu ku uvuvurr alando uzizi, nggo a ki ahihi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Aki wa ddu ma di, ‘Uzumu, ùwà di so se ni ingga ku ttuttumi. Inkindirr yi nggo ingga se na yi i si imuwa namri. ");
INSERT INTO ninNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ima ki inta ni inyarr yi, nggo uzumbirr wa a ttu na tasi. A nado, i ziza uwa kanga.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu da ku abiga ma ba ure unggo ku di, “Ugo numa nggo se nu ungo. Na se na ankpye a amirr iko, nggo di kye ku ashiki ama ka. Ugo wa à wo di uvuvurr iko wa di varr azo ama ka hre na anko ndanda. ");
INSERT INTO ninNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nggo na yo ma rri ku ddu ma di, ‘Ingga wo da angginggi ni itu muwa? Gri angbamvu ka nggo ùwà charr aseki ka nggo ingga du ku ùwà i nga namri, di ingga ni kye. Ùwà yo si ta su uni gri ki ingga aseki mungga ka zizo hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Uvurr iko wa à ri amarr na ddu ma di, ‘Akiko mungga à ta ku han ingga nu undu mungga ku. Ingga ta na kingginggi? Ingga nggo si su ukyekye nggo ingga ka do hen. Ishisha ki ingga ni ku barr ma yi. ");
INSERT INTO ninNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ingga hi inkindirr yi nggo ingga ta na! I ta si meme undu mungga ku ti kre, ingga ta se ni ikpikpa, nggo a taka di kpa ingga yo na ako ambarr wa.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Na yo anishirr ba nggo a ri ku ugo wa ahla ka na ayiyirr. Na zhi uni ime̱me̱ wa di, ‘Uhla ku nggo ùwà ri ku akiko amungga wa u su ubirr nggo?’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Uwa ddu ma di, ‘Ingga kpa uhla ku anye olivu impirr inkpinkpi ayirr yirr (100).’ “Uvuvurr iko wa à ddu uni ni uhla wa di, ‘Ji so ni charr hanhan mi di ayiyirr ane̱ (400) nu ungbamvu muwa ku.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Na yo unu uha wa mirri ku zhi ma di, ‘Ùwà na? Uhla muwa ku u su ubirr nggo?’ “Uwa da di, ‘Umungga ku su ikiri abubwu ukrɨ uyirr (1,000).’ “Uvuvurr iko wa da ku di, ‘Charr abubwu ayiyirr atandarr (800).’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ni ikikre yi, akiko a uvurr iko ni varr iki hre wa à gbyarr ku asa, nggo à na undu uma ku krizhizhi mi. I si meme yo nggo anishirr bi ingbingbru ba si krizhizhi ba ni na aseki ka ingbingbru ka mri anishirr abiga ba Abachi ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesu kuchi ni bre ba di, “Ziza, ingga ko da ki imba di, ki ikpikpa na ashiki ka ingbingbru ka, wre ba a ti ka kre aba ta kpa ùwà ni iko i iso sese yi. ");
INSERT INTO ninNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Undurr wanggo nggo à ti kpanye na ku ni gri inkindirr ivutsa, aba ta kpanye na ku ni gri inkpi. Undurr wanggo nggo à ti si kpanye na ku ni gri inkindirr ivutsa hen, aba si ta kpanye na ku ni gri inkpi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Meme nggo, imba ti si hi achi ka gri iki i ingbingbru yi hen, imba ta na kingginggi ni gri iki inggi yi nggo i si i unkplassu? ");
INSERT INTO ninNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Imba ti si hi gri inkindirr yi nggo i si i undurr unuma hen, unggonggo ta ni imba imba yi? ");
INSERT INTO ninNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Uvuvurr iko uyirr ka si na undu ku atitiko aha hen. À ta karr uyirr wa na ta kpanye nu unuma wa. À ta kru isisu i uyirr na ta kà uyirr wa. Na anko ayiyirr ama yo, ùwà ka si ba itu imuwa ni undu ku Abachi tuku izha inklo narrnarr hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nggo anu Farrisi ba wo are angga ka namri, na sarr Yesu, nggo a hi da aba mi zharr inklo. ");
INSERT INTO ninNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Yesu ddu ba di, “Imba yo atu amba wa di imba ngga si abi na wre na ashishi ka anishirr. Abachi mu hi isisurr imba yi. Inkindirr yi nggo anishirr bre yi surr na amu, ima yo si inggi yi nggo Abachi à kà yi. ");
INSERT INTO ninNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Anishirr a di kru isisu i Are ka Musa ka na angbamvu ka abi kpa are ka, nga ni ma ni ivi yi nggo Yohana uni zzu na amasirr wa à ku nggurr surr. Bazhi ni ima yo aba a gru di da Ure ku wre ku ni itu i Ittu Abachi yi. Anishirr shishemi a ko ta ukpa da aba ta mirri ni ittu yi. ");
INSERT INTO ninNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Meme mi, ure ku Musa ku u se. A si inkindirr ivintsɨ, unkplassu ni ingbingbru inggi a bu ka nado, mri nggo inkindirr ivutsa nu umi ku Are ka i bu sama nu ukyekye. ");
INSERT INTO ninNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Undurr wa nggo ti han ayamba ama na ku garr anuma, uwa kpala na si uni zha amba. Undurr wa nggo ti garr ayamba wa nggo a han wa, uwa mi kpala na si uni zha amba.” ");
INSERT INTO ninNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu kuchi ni bre ba ni itsarr yi di, “Ugo numa nggo a se nu ungo kakami na di surr iki i iwre ni i tsɨ anta. Na se na aseki azizi kakami, na su kpukpa na iga yo mre. ");
INSERT INTO ninNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ugo numa se zizo nggo a su uni iha i isa ima yi i ri Lazarru, nggo ukpa umaku sa ankpa mi. Aba di ba ma ni zu na aminko ka mirri ko ni iko i ugo nu ungo wa. ");
INSERT INTO ninNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A di zha du uwa ta di vu imbimbru ila yi nggo ugo nu ungo wa ti ri na du inkpu. Amiyo ba nga di re̱ ku ankpa ka. ");
INSERT INTO ninNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Uni iha wa a ttu, abitu ba Abachi ba a gri ma hun ku zu ywhiywhirr ni Ibrayi ku. Unu ungo wa ttu, aba zzu ma. ");
INSERT INTO ninNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nggo a so nu abubo a iso abi kɨ wa, na gɨ ashishi kye nu ussu na hi Ibrayi gbagbamu, u Lazarru so ku na anga ayirr. ");
INSERT INTO ninNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Uwa bwu angu yo di, ‘Aki mungga Ibrayi! Kye iha mungga ni du Lazarru yo uvuvurr ungo na amasirr na tse̱ yo ki ingga ni irrirri di igbigbarr mungga yi su. Kye, ingga ko wo ivri kakami nu uru!’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ibrayi ddu ma di, ‘Uzumu, ssu hi nggo ùwà di so ni ingbingbru yi, ùwà se na ashiki ka ingbingbru ka shishemi. U Lazarru a se na aseki andanda. Ziza nggo, Lazarru so me̱ nyarr, ùwà so se ni ivri. ");
INSERT INTO ninNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Meme mi, inkpri udduddu i se ki inta na atsutsu nu ùwà. Nggo abanu ti da aba ta cha ko nu ùwà ku, aba ta cha chankarr. Abanu nggo ti da aba ta cha nga zhi ni imba ba na nga ni inta ba, aba ta cha ma chankarr.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ugo nu ungo wa da di, ‘Ingga ko barr ùwà aki munta Ibrayi, tu Lazarru kuma na amuya mungga ba ni iko i aki mungga. ");
INSERT INTO ninNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ingga se na amuyirr mungga a sa akywi. Du Lazarru ku gba ba utu du ba si ka ni ki iha nu unto ku nggo ingga se hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ibrayi ddu ma di, ‘Amuya amuwa ba a se na Are ka Musa ka tuku itsarr i abi kpa are yi nggo a charr, nggo a ta gba ba atu. Amuyirr muwa ba bu shirr atu ku itsarr imbarr yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Uni ungo wa à da di, ‘Aki munta, Ibrayi! Iya, i nise ma ki ingga, undurr nu umi ku a bi kɨ ba kakuma na aba, aba ta wo ma na du ila ure imbarr yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Ibrayi ddu ma di, ‘A ta si ta wo Are ka Musa ka ni itsarr i abi kpa are yi hen, aba si ta wo zizo hen, ka undurr ka tasi na kuma na ba, aba si ta kpanye hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu ddu abiga ma ba di, “Iki yi nggo di du anishirr la ure i ta nga ki imba. Uje ku undurr wa nggo i ta nga zhi na ku nggo! ");
INSERT INTO ninNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Iwre ka ba ununa ki iko à klo ku ni ito, na turr ma yo ni inyi. Ima i wre na ku nggo a bu du ma so na du atsitsa angga ba la ure. ");
INSERT INTO ninNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kye inkindirr yi nggo ùwà di na yi! “Uzumbirr ti la ure, ùwà bu glo ma, uwa ti ba ttungo, ùwà bu nggurr zhi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A ti kpala ku ùwà ki inkpo tangba na azhi ayirr, na ko nga nu ùwà ku inkpo itangba yi, ni barr da di, ‘Ingga i si ta na meme zizo hen,’ Ùwà bu nggurr zhi ku.” ");
INSERT INTO ninNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Abi ko na angu ba a ddu Atiko wa di, “Na ni du iyo isisurr imunta yi i kri mri i ziza yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yesu ddu ba di, “Imba ti se ni iyo isisurr ntsɨmi nâ ta si ingbingbi ikiri yi nggo a yo yi di mosita, imba ti ddu unkunkurr unggo ku di, ‘Huzzu ni izhizhi imuwa yi we ku ji rri ni inyi!’ U ta na nâ ta si nggo imba i da. ");
INSERT INTO ninNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ka du uyirr nu umi umba ka a se nu uvuvurr iko nggo di do ku, ka di ho ku. Nggo uvuvurr iko wa ti nga zhi ni īlá, atiko ama wa di ddu ma di a bu narrma ku ri ila ima yi? ");
INSERT INTO ninNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Iya! Atiko wa ta ddu ma di, ‘Ssu ila yi zu ki ingga ni ku ssubi ni nga ni ni ingga na yi, di ingga ni ri ni so bari, ùwà nga ni ji so ni ri imuwa yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Uvurr iko wa si ta kpa igbyarr asa numa hen, nu nggo à si so na undu ku nggo akiko ama wa à nu ma hen. ");
INSERT INTO ninNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Imba mi bu na meme, nggo imba ti na inkindirr yi nggo a da ki imba, imba da di, ‘Inta sa amirr iko mu. Inta i si ma a bi kpa igbyarr asa imuwa yi hen, inta so na undu munta mu.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu à so kuma nu Urushalima na nga nu udirr ku Samarriya tuku Galili. ");
INSERT INTO ninNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nggo ta ko rri nu umi igbu numa, anishirr abi ishi awurr gru ni ma na ku na anko. Na kri gbagbamu, ");
INSERT INTO ninNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","na du ma hantu di, “Yesu! Ankpye munta! Ki itito ni inta ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nggo a hi ba na ddu ba di, “Kuma ku tsarr abikye anishirr ba ikpa imba yi.” Nggo a ko kuma na kakye aba wre. ");
INSERT INTO ninNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Uyirr nu umi umbarr ku nggo hi du uwa wre, na kasarr kuma na so nyarr ku Abachi na so bre asarr hantu. ");
INSERT INTO ninNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na kuma ku kuttu ku Yesu na aza na nyarr ku. Ugo wa a zhi nu Samarriya. ");
INSERT INTO ninNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu zhi ma di, “Ingga kye di a sa anishirr awurr ngga nggo ingga du ba wre? Uyirr yo à kanga, atirr ba na? ");
INSERT INTO ninNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Sa angginggi du uyirr wanggo nggo à su unichirr mu à kanga ni da ku Abachi inyarr ima yi?” ");
INSERT INTO ninNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yesu ddu ma di, “Gru kuma. Kye, iyo isisurr muwa nggi i du ùwà wre.” ");
INSERT INTO ninNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Anu Farrisi banu a nga ni zhi Yesu di Ittu i Abachi yi i taka nga nita mu. Yesu à ddu ba di, “Ittu i Abachi yi i si ta nga na anko wa nggo imba ta hi na ashishi amba hen. ");
INSERT INTO ninNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Undurr si ta da di, ‘Kye! Si inggi inggya!’ ka ‘Kye! Si inggi nu nggo hen!’ Ittu i Abachi yi i ka rri ba so ni imba ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Na ddu abiga ma ba di, “Ivi yi ko nga nggo imba ta zha di imba ka hi azhi yirr nu umi ku ivi yi Uvuvurr a Unushirr yi, ni si ta hi wa hen. ");
INSERT INTO ninNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Abanu ta re imba mi di, ‘Kye inggi ni inggya!’ ka, ‘Kye kuma unggu mu!’ Imba bu si kuma ku di zha yi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nggo imba di hi inge̱ i là nu ussu, ni là zhi na anga numa kuma na anga numa, Uvuvurr a Unushirr taka si meme yo na azhibarr wa nggo a taka kanga. ");
INSERT INTO ninNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Uvuvurr a Unushirr taka ki iha kakami. Anishirr ba a se angga ka a ta kà ma. ");
INSERT INTO ninNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Nâ ta si nggo a na ni ivi i Nuhu yi, i taka se meme yo ni ivi yi nggo Uvuvurr a Unushirr a taka kanga. ");
INSERT INTO ninNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Na ase ka Nuhu ka, anishirr namri a so di ri na so. Aniru na amba a so di garr ikpa ku ma na azhibarr wa nggo Nuhu a rri ni ijirrigi ima yi, amancha wa ku nga ni ngɨ ba namri. ");
INSERT INTO ninNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“I taka se nâ ta si nggo i se ni ivi i Lotu yi. Anishirr a so di ri na so, na re na vu ka re, na so ttu ikiri na so me ako. ");
INSERT INTO ninNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Na na meme ma na azhibarr wa nggo Lotu a huzzu nu Sodomu, uru tuku solfa u ji zhi nu unkplassu ni tu ba ngɨ namri. ");
INSERT INTO ninNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“I taka se meme yo nu nggo Uvuvurr a Unushirr wa taka kanga aba taka hi inkpinkpye nu ukyekye umaku. ");
INSERT INTO ninNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Na azhibarr ama wa, unushirr wa nggo so ni itu iko ima, a bu si ji rri ni iko yi du uwa ta ku ba inkindirr nu umi hen. Meme yo, unushirr wanggo nggo ti kri ni īlá, a bu si kru kanga ni iko du uwa ta ni ba inkindirr hen. ");
INSERT INTO ninNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Imba bu ssu hi inkindirr yi nggo i la na ayamba a Lotu wa! ");
INSERT INTO ninNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Undurr wa nggo ti du uwa ta kpa itu ima ttungo, uwa ta ttu. Undurr wa nggo ti ba itu ima à ni, a ta kpa ma ttungo. ");
INSERT INTO ninNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ni ibittu ima yi, ingga nggo ko da ki imba, anishirr aha ta kurr na abubo ayirr, aba ta ba uyirr na du uyirr wa nu ugo. ");
INSERT INTO ninNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Amba aha taka so kò nu ununa. Aba ta ba uyirr wa na du uyirr wa nu ugo.  ");
INSERT INTO ninNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Anishirr aha taka klo ko na undu ni īlá, aba ta ba uyirr na du uyirr wa.” ");
INSERT INTO ninNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Abiga ma ba a zhi ma di, “Atiko, a taka na meme nu momonggo?” Yesu ddu ba di, “Nu unto ku nggo iku ti se, anangguru di nggurr bi nabo yo.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Yesu à bre ku abiga ma ba assurre nggo ta tsarr ba di a bu so di barr ttuttumi, na si su ukpa hen. ");
INSERT INTO ninNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesu da di: “Ni ìgbù numa nggo uni hla are numa di so, na si kru isisu i Abachi hen, na si kye unushirr mi ssu ni ishishi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ayamba na ako numa ni igbu wama à di nga na ku ttuttumi, ni di barr ma ki itu ima di, ‘Zi ingga ni itu i abi karr ingga ba!’ ");
INSERT INTO ninNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Zhi ngbangbamu uni hla are wa di kà ina inkindirr ni itu yi. Ni ikikre yi uwa da ku itu ima di, ‘Nu nggo ingga si kru isisu i Abachi hen, ni si kye unushirr ssu ni ishishi hen, ");
INSERT INTO ninNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nggo ayamba wa nggo di tsutsarr ingga, ingga ta ta ukpa ni na ku inkindirr yi nggo so zha yi. Ingga ta si na meme hen, uwa ta di tsutsarr ingga meme yo, na ka ni ki ingga udi!’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Atiko wa à da di, “Wo inkindirr yi nggo ugbugbu uni hla are wa à da. ");
INSERT INTO ninNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nggo uni hla are andanda wa mu ka ti na meme ku ayamba na ako wa, imba kye Abachi ka si na inkindirr izizi mri meme ku anishirr abangga ba nggo a so di barr ma zha izi na azhi na ingbahru hen? A si ta su ukpa ni zi ba hen. ");
INSERT INTO ninNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ingga da ki imba, Abachi ta nu ba inkindirr yi nggo i si ba imbarr, na ta ni yi hanhan mi. Uvuvurr a Unushirr à ti nga wa à taka ni hi anishirr shishemi a bi yo isisurr na ku ni ingbingbru inggi yi?” ");
INSERT INTO ninNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu à bre assurre anggo ku anishirr ba nggo a di kye da abangga na wre ka ba, na di kye abanu kpachirr. ");
INSERT INTO ninNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","À ddu ba di, “Anishirr aha banu ngga a huzzu kuma ni ibarr Abachi nu Uki Unkpi ku Ibarr Abachi ku. Uyirr wa sa anu Farrisi, unuma wa à su uni kpa inklo imimi. ");
INSERT INTO ninNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Anu Farrisi wa à gru kri ku itu ima na barr di, ‘Abachi, ingga nyarr ku ùwà nggo ùwà na ingga ki nanka ni inkpu anishirr, abi de anishirr, agbugbu, abi zha amba, ni si si nâ ta si uni kpa inklo imimi wanggo wa hen. ");
INSERT INTO ninNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ni ivi itangba, ingga di vu angu ankpu iha. Ni ti se ni inkindirr iwurr ingga ttu iyirr nu ùwà.’ ");
INSERT INTO ninNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Uni kpa inklo imimi wa gru kri kremi na si kpanye na gɨ ashishi hun kuma nu ussu hen, na sa ungo na anke̱ na da di, ‘Abachi, ki itito ni ingga uni la ure ku!’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu da di, “Ingga ko da ki imba, uni kpa inklo imimi wa yo kuma ni iko ni isu isisurr. Undurr wa nggo ti gɨ itu ima aba ta gri ma kaji, undurr wa nggo ti gri itu ima yi ji aba ta gɨ ma hun.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Anishirr banu mi a so gri amumarr ambarr na nga ni Yesu ku, di a bu yo ba angu azizi. Abiga ma ba hi ba na han ba ni na meme yi. ");
INSERT INTO ninNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu yo amumarr ba chinga nu ukpa uma na ddu abiga ma ba di, “Du amumarr tsitsa du ba nga ni ingga ku. Si han ba yi hen. Ittu yi Abachi yi si i abangga ba nggo a si nâ ta si amumarr angga ba. ");
INSERT INTO ninNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Imba bu hi di, undurr wa wanggo ti si kpa Ittu yi Abachi nâ ta si uvuvurr uvutsa hen, uwa si taka ni rri ni ittu yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Azhibarr numa nggo, ankpye numa a zhi Yesu di, “Unitsarr uni wre, ingga ta na sa angginggi ni ka kpa iso sese?” ");
INSERT INTO ninNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu a zhi ma di, “Angginggi du ùwà yo ingga ki uni wre? Abachi yo su uni wre na nkpama. Undurr numa uni wre à sama. ");
INSERT INTO ninNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ùwà hi Are ka, ‘Si zha amba na aniru hen. Si ngu unushirr hen. Si ki ayi hen. Si vu undurr ni imu mi hen. Kru isisu i aki muwa na ayirr muwa.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ugo wa ddu ma di, “Zhi nggo ingga ni di su uvutsa mu, ingga di na aba ma.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nggo Yesu wo meme, na ddu ma di, “Inkindirr iyirr yo ni ji ku ùwà. Kuma ku vu aseki muwa ka re namri, ni kpa inklo yi ga ku abi iha, ùwà ta se na aseki shishemi nu unkplassu. Ùwà ti na meme ùwà nga ni ga ingga.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nggo ugo nggo à wo meme, isisurr i vri ma kakami, nu nggo ugo wa à se nu ungo kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu hi ma ni ivri isisurr yi na da di, “I taka tsɨ kakami unu ungo a bu rri ni Ittu i Abachi yi! ");
INSERT INTO ninNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Alakurrmi ta rri ni iywirr i anurr kuchi unushirr nu ungo ka rri ni ittu i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Anishirr ba nggo kri nabo na wo meme na a zhi ma di, “Unggo mu taka kpa ikpa ttungo?” ");
INSERT INTO ninNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","I Yesu ddu ba di, “Inkindirr yi nggo tsɨ ku unushirr, Abachi ka na yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","I Biturr ddu ma di, “Kye! Inta nggo i kà ako munta wa du ni kà aseki ka nggo inta i se na ka du, ni ga ùwà na?” ");
INSERT INTO ninNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu à ddu ba di, “Undurr wanggo a ka du iko ima du, na ayamba ama, na amuyirr aniru na amba, na akiki ma, na amarr ma ni itu Ittu i Abachi yi, ");
INSERT INTO ninNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","uwa ta kpa kri shishemi na ase angga ka bari, ni ka kpa iso sese na ase ka so nga ka.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu yo abiga ama awurr na ha ba kaki na anga yirr, na ddu ba di, “Wo yi! Inta ta ko kuma nu Urushalima. Inkindirr yi nggo abi kpa are ba a charr, i ta ku la jiji ni itu i Uvuvurr a Unushirr. ");
INSERT INTO ninNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","A ta ku ba ma nu abangga ba nggo a si si anu Yahuda hen, aba a ta me̱ ma, na marr ma, na ta ddu antinte surr ma. ");
INSERT INTO ninNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Na ta hlo ma, na ta ngu ma, unu utarr wa, uwa ta tasi.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Abiga ma ba si hi inkindirr ima yi nggo a ko da yi hen. Inkpi i ure yi i sharri ba, aba si hi inkindirr yi nggo Yesu ko re ni itu yi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nggo Yesu so ki ywhiywhirr nu Jerriko, unakreshishi numa nggo so di barr nu unddu anko ku nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nggo a wo anishirr ba ni so sarr kuma na zhi ba di, “A sa angginggi ima yi?” ");
INSERT INTO ninNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Aba da ku da di, “a si Yesu anu Nazareti nggo à so sarr kuma” ");
INSERT INTO ninNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Uwa yo hantu di, “Yesu! Uvuvurr a Doda! Kye, ki itito ni ingga ku!” ");
INSERT INTO ninNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Anishirr ba nggo a si ni ichi a nggarr ito na ku di, a bu ba ttungo. Uwa kà na yo hantu kakami di, “Uvuvurr a Doda! Kye iha mungga yi!” ");
INSERT INTO ninNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu à kukri na da di a bu vu ma ga ku uwa. Nggo a ki ywhiywhirr, i Yesu zhi ma di, ");
INSERT INTO ninNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ùwà zha di ingga bu na ku ùwà angginggi?” Uwa da di, “Ankpye, di ingga kye hi.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu ddu ma di, “Bwu ashishi! Iyo isisurr imuwa nggi i du ùwà wre.” ");
INSERT INTO ninNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Inkpu iyirr, uwa bwu ashishi na kye hi, na ga Yesu, na ko nyarr ku Abachi. Nggo anishirr ba a hi meme, na gru ko nyarr ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Nggo Yesu mirri nu Jerriko, na ko vu sarr. ");
INSERT INTO ninNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ankpye abi kpa inklo imimi numa nabo a ri Zakiyo, nggo a se nu ungo. ");
INSERT INTO ninNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Na zha du uwa ta hi Yesu, na su unkpunkpu kakami, anishirr ba a harr ma. ");
INSERT INTO ninNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Uwa kru ku ku anishirr ba ichi, ku hun nu unkunkurr numa nggo a yo ku di sikamo, u kri nu uddu anko ku, na hi di Yesu so ba nabo yo. ");
INSERT INTO ninNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nggo Yesu à rri ni ichi unkunkurr yi, na kukri na gɨ ashishi kye Zakiyo, na ddu ma di, “Zakiyo! Narr ji. Kye, ingga ta kurr ni iko muwa ari.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakiyo wa narr ji, ni inyarr ni kla ma vu. ");
INSERT INTO ninNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Anishirr ba hi na re gbrungbru di, “Ugo nggo à ko ichirr ni iko i uni la ure wanggo!” ");
INSERT INTO ninNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","U Zakiyo gru kri ki kri, na ddu Atiko di, “Ankpye, wo ingga! Ingga ta ga aseki mungga ka narrnarr, ni ta ba anga ayirr nu abi iha. Ingga ti de undurr, ingga ta han ku ki inkpu ine̱ inkindirr yi nggo ingga kpa.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu ddu ma di, “Ari, ikpa ttungo i nga ni iko inggi yi. Ugo nggo mi meme a su uhanma a Ibrayi. ");
INSERT INTO ninNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ingga Uvuvurr a Unushirr i nga nye i zha abi nado ba ni kpa ba ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nggo anishirr ba ko shirr ku atu, Yesu kuchi na bre ba na assurre unuma, nu nggo à ki ywhiywhirr nu Urushalima aba kye di Ittu i Abachi yi ta gru nga. ");
INSERT INTO ninNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Uwa da ba di, “Ugo numa nggo sa ankpye na gru kuma ni ìgbù numa gbagbamu ko ikpa ittu, na kanga ni iko. ");
INSERT INTO ninNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nggo a ta ko kuma na yo amirr iko ma ba awurr mi, na nu ba angalanzirr ayiyirr, na da ba di, ‘Ingga ti kuma, imba bu hi inkindirr yi nggo imba ta ka inklo inggi yi sarr na yi nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Anishirr abi igbu ama ba a kà ma, na tu abanu di a bu kuma ku da ku abi ttu ba di, ‘Inta kà. Ugo nggo à si ta si uttu munta hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ni ima mi, uwa à ku kpa ittu yi, na kanga ni iko, na ni yo amirr iko ba awurr mi zu, wre ku a bu wo inkindirr yi nggo a kasarr, na amasirr ni itu. ");
INSERT INTO ninNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Uni ime̱me̱ wa à da di, ‘Ankpye, ingga se na angalanzirr awurr nggo ùwà ni ingga.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Atiko ma wa à da di, ‘Ingga chi ùwà nu undu. Ùwà su uvuvurr iko uzizi! Nggo ùwà hi igri ivutsa, ingga na ùwà ki uttu ni itu i igbu iwurr.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Unu uha wa da di, ‘Atiko, ingga se na angalanzirr a kywi kye na angga ka nggo ùwà i ni ingga nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Atiko ma wa à ddu uwama di, ‘Ùwà ta gri igbu ikywi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Uni utarr wa mirri na ddu ma di, ‘Ankpye, kye inklo muwa inggi. Ingga i gri yi ku yo sharri ku ùwà nu unga ankru. ");
INSERT INTO ninNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Isisu ki ingga nu ùwà ku, nu nggo ùwà tsɨ kyekye. Ùwà di kpa inkindirr yi nggo i si si ajiji amuwa hen, ni di hwa nu unto ku nggo ùwà si ttu hen.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Atiko ma wa à ddu ma di, ‘Ùwà ugbugbu uvuvurr iko. Angu muwa ka a vu ùwà. Ùwà hi di ingga tsɨ, ni di ri ajiji ka abanu ni di hwa nu unto ku nggo ingga si ttu hen. ");
INSERT INTO ninNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ùwà ka gri inklo imungga yi ku zu ki ingga nu unto ku zu inklo ku. Kye, ingga ka kanga ni ba yi na amasirr ni itu yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Na ddu anishirr ba nggo a kri na ku di, ‘Imba kpa inklo yi glo na ku, ni ka yi nu uwanggo wa nggo se na angalanzirr awurr ka.’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Aba a da ku di, ‘Ankpye, kye a se na awurr mremremu!’ ");
INSERT INTO ninNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Uttu wa a ddu ba di, ‘Ingga nggo ko da ki imba, undurr wanggo ti se ni inkindirr, a ta tsu inuma nu ma shishemi. Undurr wanggo ti sama ni inkindirr, a ta kpa ivintsɨ yi nggo a se na yi. ");
INSERT INTO ninNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Uwa a ta si abi karr ingga ba, nggo a si kpanye di ingga nggo bu su uttu ambarr wa hen, vɨ ba ni tsi ngɨ na ashishi a mungga nggo mi!’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nggo Yesu bre are ka kre, na ku ba ichi kuma nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nggo Yesu na abiga ma ba a ki ywhiywhirr nu Betifegi tuku Betani, igbu yi nggo i si na anga ka Igbre nu Olivu wa, uwa a tu abiga ma ba aha di aba bu kuchi ");
INSERT INTO ninNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Na ddu ba di, “Kuma ni igbu wanggo ni ichi imba. Imba ti kuma, imba ta ku hi uvuvurr ijaki nggo a lo ma zu, nggo a nise hun ma kye. Ddu ma gri nga ni inggya. ");
INSERT INTO ninNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Undurr ti zhi di imba ko ddu ma ta na angginggi, imba bu da ku da Atiko wa yo à zha ma ta na undu na ku.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aba aha ba a kuma na ku hi yi si meme yo nggo Yesu à da ba. ");
INSERT INTO ninNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nggo a ko ddu uvuvurr ijaki wa, akikye wa à zhi ba di, “Imba ko ddu ma na angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aba da ba di, “Atiko wa ko zha ma.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nggo a ttu ma ga ku Yesu. Na ni ddu inkinkru imbarr i abi yi sa ki inina wa nu ugo, na ba Yesu sa. ");
INSERT INTO ninNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nggo Yesu a so kuma, anishirr ko ddu inkinkru imbarr i abi yi surr ku na anko. ");
INSERT INTO ninNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nggo a ki ywhiywhirr nu Urushalima, nu nggo anko wa zzu ji ni Igbre nu Olivu wa, akpa anishirr wa nggo so ga ma, gru so nyarr ku Abachi, na da aseki ka iwre ka nggo Abachi na ba hantu, nggo a hi ikagri yi nggo Yesu à na ba, na da di: ");
INSERT INTO ninNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Abachi bu yo ku Uttu wa nggo, nga ni isa i Atiko yi angu azizi! Isu bu se nu unkplassu. Inta bu gbyarr asa ku Abachi nggo a hru aseki ka wemi!” ");
INSERT INTO ninNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Anu Farrisi banu nggo se nabo, a re ni Yesu ku di, “Unitsarr, nggarr ito na abiga ba ba du aba ba ttungo ni da meme!” ");
INSERT INTO ninNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu ddu ba di, “Ingga da ki imba, abiga mungga ba a ti ba ttungo ni igbyarr ki ingga asa, angbinta a ta gru so hantu na gbyarr asa kama.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nggo Yesu ki ywhiywhirr na kye Urushalima, na yì ku ìgbù wa, ");
INSERT INTO ninNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","na da di, “Ka kaki di ùwà hi inkindirr yi nggo ta gri isu nga ari! Aba ka yi sharri ku ùwà. ");
INSERT INTO ninNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Azhi wa so nga nggo abi karr ùwà ba ta ni harr ùwà zu nu ugonka, na ta harr ùwà yo na atsutsu. ");
INSERT INTO ninNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Na ta rɨ ùwà nggarr tsatsarr na anishirr ba nggo a so nu umi umuwa ku, na si ta du ingbinta iyirr mi nu unto umaku hen, nggo ùwà si hi azhi wa nggo Abachi nga ni kpa ùwà ttungo hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu rri kuma nu Uki Unkpi ku Ibarr Abachi ku, na ku han abi gri iki ire ba huzzu, ");
INSERT INTO ninNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","na ddu ba di, “Ungbamvu ku Abachi ku u da di, Abachi à da di, ‘A ta yo Iko imungga ki iko ibarr.’ Imba nanko ka yi ki unto ku sharri ku abayi.” ");
INSERT INTO ninNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ni ivivi ima yi Yesu di tsarr ba nu Uki Unkpi ku Ibarr Abachi ku. Ankpinkpye abikye ba, na abitsarr are ba, na akikre ba a di zha da aba ta ngu ma, ");
INSERT INTO ninNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","na si hi anko wa hen, nggo anishirr ba wemi a ko shirr ku atu kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","A si na azhibarr numa nggo Yesu so tsarr anishirr ba nu Uki Unkpi ku Ibarr Abachi ku na so bre ba Ure ku wre ku, ankpinkpye abikye ba, na abitsarr Are ba, na ankpinkpye anu Yahuda ba a gru nga ni Yesu ku, ");
INSERT INTO ninNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ni ddu ma di, “Da ki inta undurr wa nggo nu ùwà ukyekye ku na aseki angga ka ma mi. A su unggonggo nu ùwà na ku?” ");
INSERT INTO ninNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu ddu ba di, “Imba di ingga zhi imba ure uyirr. ");
INSERT INTO ninNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ukyekye ku nggo Yohana à di zzu anishirr na amasirr wa, u zhi na Abachi nggo ku, ka u zhi nu anishirr ku?” ");
INSERT INTO ninNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Aba gru ko ri anta na atu ambarr di, “Inta ta da ku da angginggi? Inta ti da di, ‘Abachi nggo a nu ma na ku,’ uwa ta da di, ‘uwa sa anggi mu inta si kpanye na are ka Yohana ka hen?’ ");
INSERT INTO ninNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Inta ti da di, ‘U zhi nu anishirr ba,’ akpa anishirr anggo a ta ta inta na angbinta. Nggo anishirr ba a ka kpanye di Yohana a si uni kpa are ba.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Na gru da di, “Inta si hi unto ku nggo ukyekye umaku u zhi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu ddu ba di, “Ingga mi si ta da ki imba, nu ukyekye ku unggonggo ingga ko na undu unggo ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu da ku anishirr ba assurre anggo wa di, “Ugo numa nggo a ttu inkinkurr i grepu ni ila, na ba yi nu abi do, na kuma nu uzirr nu unto gbagba, na ku so ta anko. ");
INSERT INTO ninNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nggo ivi i ywhe yi i ma, uwa tu uvuvurr iko ama na abikye ila ba ba di a bu ku kpa inkindirr yi nggo a tsu zu ku. Abi do ba ku hlo uvuvurr iko wa na han ma kakuma na ango aha. ");
INSERT INTO ninNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Uwa ni tu uvuvurr iko numa zizo inkpu iha. Aba ku hlo ma meme, na nu ma ishisha, na du ma kakuma na ango aha. ");
INSERT INTO ninNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Inkpu itarr inggi, uwa ni tu unuma, aba ku ki ma unkpa meme, na turr ma huzzu. ");
INSERT INTO ninNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Akikye ni ila wa da di, ‘Ingga ta na kingginggi ziza nggo? Di ingga tu uzumu wa wanggo ingga kpanye na ku. A ta ku wo ma!’ ");
INSERT INTO ninNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Nggo abi do ba hi ma nggo, na ddu ikpa di, ‘Uwanggo yo su uvuvurr a akikye ni ila wa, di inta ngu ma, iki ima yi i ta si imunta!’ ");
INSERT INTO ninNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Na ba ma huzzu ni ila yi, ku tsi ngu.” Yesu ddu ba di, “Meme nggo, akikye ni ila wa ta na abi do ila abama kingginggi? ");
INSERT INTO ninNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","A ta nga ni ngɨ abi do abama, na ka ila yi nu abi do banu.” Nggo anishirr ba a wo ure ku nggo Yesu a bre ba nggo, na da di, “Abachi bu si du inkindirr inggi yi ila hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu kakye anishirr ba, na zhi ba di, “Uwa ti si meme, ungbamvu ku Abachi ku u da di angginggi? “ ‘Ingbinta yi nggo abi me ba a kà yi di i si ndanda, ima iyo i kaki ingbinta inkpi yi nggo si iso gri ibarr i iko yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Undurr wa nggo ti jaku ni ingbinta nggi yi, uwa ta mɨ ki ankpunkpu. Undurr wa nggo ingbinta nggi yi ì ti ji jaku ku nu ukpa, ì ta ko ma ki imbimbru.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Abitsarr na Are ba na ankpinkpye abikye ba a hi di Yesu da assurre anggo ni itu imbarr. Ima yo du ba zha anko wa nggo aba ta vu Yesu korrmi. Isisu so ki ba na anishirr ba ba, aba kru di anishirr ba a ta gru tsi akputtu, na si vu ma hen. ");
INSERT INTO ninNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Abitsarr Are ba na ankpinkpye abikye ba gru zha anko, wre ba ka vu ma gri ku ugona wa nggo a ttu ma zhi nu Roma. Na tu anishirr abanu, di a bu ku na zzu da aba si anishirr azizi, na bu tirr Yesu kye ni izhi. ");
INSERT INTO ninNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Abangga ba nggo a tu ba a nga ni ddu Yesu di, “Unitsarr, inta hi di ure muwa ku, ni itsarr muwa yi a si jiji. Inta hi du ùwà si di na wre ku amuwa nanka hen. Ùwà di da si inkindirr yi nggo Abachi zha di unushirr a bu na. ");
INSERT INTO ninNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Da ki inta, i wre inta bu han inklo imimi ku Kayisa, uttu nu Roma, ka i si wre hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu à hi isisurr imbarr yi, di a ko tirr uwa mu, na ddu ba di, ");
INSERT INTO ninNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Tsarr ingga dinarri uyirr, a charr ashishi ka unggonggo, ni isa inggonggo na ku?” Aba da di, “Uttu Kayisa.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nabo yo Yesu ddu ba di, “Imba bu nu Uttu Kayisa inkindirr yi nggo i si i Uttu Kayisa, ni nu Abachi inkindirr yi nggo i si i Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aba si hi inkindirr yi nggo aba ta na nà ka vu ma na ashishi ka anishirr ba nabo hen. A ku ayisurr ni ida ima yi, na ba ki ywi. ");
INSERT INTO ninNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Anishirr abanu nggo a yo ba da anu Sadusi, nggo a si kpanye di anishirr bi kɨ, a taka tasi hen, ambarr abanu a nga ni Yesu ku ni zhi ma di, ");
INSERT INTO ninNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Unitsarr, Musa à charr ki inta are angga ka di, ‘Unushirr ti ttu na kà ayamba du na sa nu uvuvurr, uzayirr a uni ttu wa à ta gri ayamba wa, wre ku a bu ngri amumarr ni isa i uzayirr yi.’ ");
INSERT INTO ninNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Amugo abanu sa atangba. Ununku wa garr na ttu, sa nu uvuvurr. ");
INSERT INTO ninNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ususa umaku ba ayamba wa, na ttu meme, sama nu uvuvurr. ");
INSERT INTO ninNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Mre uzayirr nu utarr wa a ba ma na ttu. Na ko na meme yo aba atangba mi a garr ma na kɨ, ayamba wa a si ngri ku uyirr mi ambarr hen. ");
INSERT INTO ninNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ni ikikre yi, ayamba mi ni ttu. ");
INSERT INTO ninNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Da ki inta, na azhibarr wa nggo abi kɨ ba taka tasi, uwatanggo taka gri ayamba wa, nggo aba atangba mi a garr wa?” ");
INSERT INTO ninNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu ddu ba di, “Ima ku anishirr bi ingbingbru ba a di garr, na ba garr. ");
INSERT INTO ninNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Uwa a taka si si meme yo na ase ka so nga ka hen. Abangga ba nggo Abachi kye i wre aba bu ka tasi na ase akama, ni wre aba bu ka so tsitsirr, a si taka garr zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na si taka kɨ zizo hen. A taka zzu nâ ta si abitu ba Abachi ba nu unkplassu. A taka sa amumarr ba Abachi, nggo Abachi taka du ba tasi ni ibe, na du ba so tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jiji mu, Abachi ta abi kɨ ba si. Musa tsarr da abi kɨ ba taka tasi na gru so tsitsirr. Nu unto ku nggo ijiji yi i kparri, Musa à da di Atiko nggo a si, ‘Abachi a Ibrayi, na Abachi a Ishaku, na Abachi a Yakubu.’ ");
INSERT INTO ninNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A si Abachi a abi so tsitsirr, na si si Abachi a abi kɨ hen. Ima i tsarr di inta wemi ni ikye i Abachi, i so tsitsirr.” ");
INSERT INTO ninNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Abitsarr na Are abanu ba a gru re di, “Unitsarr, ida imuwa inggi yi i si ure ujiji!” ");
INSERT INTO ninNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bazhi ni ima, undurr a si zhi Yesu inkindirr zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu zhi ba di, “Anggi mu du anishirr a da di Kristi wa à su uhanma a Uttu Doda? ");
INSERT INTO ninNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","U Doda na nkpama à charr nu Ungbamvu ku Asarr ka Igbyarr Asa ku di: “ ‘Atiko Abachi à ddu Atiko mungga wa di: “Ji so nu ungo ri umungga ");
INSERT INTO ninNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ni di ingga na abi karr ùwà ba ki inkindirr yi nggo ùwà ta vu aza muwa sa na ba.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Uttu Doda ki itu ima a yo ma ki ‘Atiko.’ Kristi wa ka na kingginggi na kaki ku Doda uhanma?” ");
INSERT INTO ninNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nggo anishirr ba ko shirr ku atu, Yesu ddu abiga ma ba di, ");
INSERT INTO ninNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Imba na ni bu kye abitsarr Are ba. Nggo di zharr izirr ni inkinkru inkpinkpi kago, na di zha da anishirr bi so chi ba na kuttu ba nu udu, na di zha into inkpinkpi nu uki ku issubi ku, tuku iso ni ichi ni into i iga. ");
INSERT INTO ninNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Anishirr angga ba di ka amba ba ako mri, na vu ba kpa àko ambarr wa. Na di barr ta anko, wre ku anishirr a bu kye da aba a hi Abachi kakami! Abachi ta ki anishirr abama iha mri abanu ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nggo Yesu kye kago na hi abu ungo ba ko surr inklo na agbugba a uki ku ibarr wa, ");
INSERT INTO ninNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","na hi ayamba na ako nggo si ni iha à ko yo angalanzirr atsitsa aha. ");
INSERT INTO ninNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Na ddu ba di, “Ingga da ki imba da ayamba na ako wa nggo à si ni iha, à yo mri abanu ba. ");
INSERT INTO ninNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Abanu ba tsu zhi na akpukpa aseki anggo wa nggo a se na wa, ayamba anggo à ba inkindirr yi nggo se na yi namri.” ");
INSERT INTO ninNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Abiga ma abanu ba a ko re ni itu i angbinta zizi ka nggo a me Uki Unkpi ku Ibarr Abachi ku na ka nggo, ni ini yi nggo a gri ga ku Abachi. Yesu da di, ");
INSERT INTO ninNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Imba i hi angbinta angga ka? Azhibarr wa a so nga nggo a taka hlo ime inggi yi nggo imba ko kye yi nggarr. Imba si taka hi ingbinta inuma so ku numa ni itu zizo hen. A taka turr ka kahre tsatsarr.” ");
INSERT INTO ninNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Abanu zhi Yesu di, “Ankpye, i taka si meme nita nggo? Angginggi taka tsarr inta da ina ima i ta ko ki ywhiywhirr i la?” ");
INSERT INTO ninNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu ddu ba di, “Imba so kye yi, ni si na ki arrurru hen. Anishirr shishemi ta gru da aba nga ni isa imungga. A ta ni da di, ‘Ingga yo su Kristi! Kye, ivi yo i nga ba!’ Imba si ga ba hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Imba bu si du isisu i ki imba hen, nggo imba ta wo are ka iku, ni itsi kputtu. Abama ba yo ta kuchi nga bari, meme mi nggo ikikre yi i nise.” ");
INSERT INTO ninNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Na da zizo di, “Ìgbù ta tsi ni ìgbù. Ittu ta tsi ni ittu. ");
INSERT INTO ninNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Imimi yi ta battu, iyo ta ki, anishirr ta wo ikɨ kago ni ingbingbru yi, na ta ki iha ku ilolo ndanda. Iki yi isisu ta ji zhi nu ussu. ");
INSERT INTO ninNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nggo aseki angga ka a ta nise nga, aba ta vɨ imba ku tsutsarr. A ta gri imba na kuma, ku bre amu na aki ka ibarr ka, na ta harr imba na aki ka iharr. A ta gri imba na kuma na atuttu ba ba, na ankpinkpye bi gri anishirr, nu nggo imba i si abiga amungga. ");
INSERT INTO ninNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Uwama yo ta si ki imba anko wa nggo imba ta da ku anishirr ba Ure ku wre ku ni itu imungga. ");
INSERT INTO ninNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nggo a ti vɨ imba, imba bu yo isisurr imba yi ni ingga ku, ni si ri amarr ka inkindirr yi nggo imba ta da hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ingga nggo ta ni imba ankpi are ka ni ihi du imba hi inkindirr yi nggo imba ta da. Uyirr nu umi ku abi karr imba ba a si ta kri na kpa kisa ni inkindirr yi nggo imba i da hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Akiki ambirr, na amuyirr ambirr, na amla ambirr, na akpukpambirr a ta re imba, na ta ngɨ inkpu imba yi. ");
INSERT INTO ninNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Anishirr namri ta kà imba ni isa mungga. ");
INSERT INTO ninNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Meme mi ingbingbi infunfutu iyirr imba i si ta nado hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Imba ti kri ngbangba, imba ta kpa atu amba ttungo. ");
INSERT INTO ninNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Imba ti hi abi ta iku ba kri kago Urushalima, imba bu hi di ivi yi i ki ywhiywhirr ba, nggo a ta hlo igbu wa nggarr. ");
INSERT INTO ninNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Abangga ba nggo a so nu Yahudiya a bu kru hun kuma na agbre ka. Abi so nu umi ku ìgbù nu Urushalima a taka kru huzzu. Abangga ba nggo se na ábì a bu si ka rri kuma nu umi ìgbù ku zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ivi ima yo taka si ‘Ivi Iha’ nggo Abachi taka du yi ki ani Israila ba. Iki iha inggi iyo i taka nga nâ ta si nggo a charr nu Ungbamvu ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ivi ima yi taka vri ku amba ba ane kakami, na amba abi gri amumarr alala! Iha ndanda ta se ni ingbingbru yi. Unfu ku Abachi nggo taka ji na atu a anishirr angga ba. ");
INSERT INTO ninNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","A taka ngɨ abanu ni injingba, na ta vɨ abanu ku harr ni igbu numa. Anishirr angga ba nggo a si si ani Yahuda hen a taka ni tsi nu Urushalima ku, na ta ri igbu wa. Aba ta gri Urushalima kakuma ni ivi ikikre yi. ");
INSERT INTO ninNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Aseki ka isisu taka se na azhi a la wa, nu uhwa ku, tuku ni intsintse̱ yi. Ni ingbingbru yi, anishirr ta so ni isisu i iku. A taka zha inkindirr ina yi chankarr. Amasirr ni inyi a taka yi na gru na ankinkirr. ");
INSERT INTO ninNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Anishirr ta hi aseki ka isisu ka nggo ko gru ni ingbingbru yi, abanu taka tsɨ ku isisu. Ukyekye ku ussu ku taka battu wemi. ");
INSERT INTO ninNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Aseki ndanda angga ka a ti kre nggo, mre anishirr kago a ta hi ingga Uvuvurr a Unushirr so rɨ huzzu, ji zhi na akpa nu ukyekye ni inkpinkpye. ");
INSERT INTO ninNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nggo imba ti hi aseki ka ko na meme nggo, imba gru kri ni so gbye kakami, kye ikpa ttungo imba yi i si gagami.” ");
INSERT INTO ninNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","I Yesu da ba assurre di: “Kye ibwa ni inkinkurr numa yi. ");
INSERT INTO ninNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Imba ti hi ba ko to angbungba ahe̱he̱, imba hi da ajiji nggo ko nga. ");
INSERT INTO ninNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Na anko ayiyirr ama wa, imba ti hi aseki angga ka, imba bu hi di ittu i Abachi yi i si ywhiywhirr mi. ");
INSERT INTO ninNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Di ingga da ki imba, anishirr abanu na ase angga ka a taka se tsitsirr, aseki angga ka a taka ni vu sarr bari, aba ta kɨ. ");
INSERT INTO ninNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Unkplassu ni imimi taka kre, ure mungga ku si taka kre hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ima yo, imba bu ki bwe, ni si tsutsarr atu amba ki iri ni iso inyarr iki, tuku iso ni ingbingbru yi hen, wre ku Azhibarr ama wa a bu si ka ni vu imba kpa mi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Azhibarr ama wa taka vu anishirr kago ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Imba bu gbye ni so barr Abachi ttuttumi, wre ku bu ni imba ukyekye ku bwa huzzu na aseki ka ngga ka nggo taka nga nggo, wre ki imba ka ku kri na age̱ ka Uvuvurr a Unushirr.” ");
INSERT INTO ninNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesu à ba ivi ima yi namri ku so tsarr ba nu Uki ku Ibarr ku. Nggo ingbahru ti ki, uwa di huzzu kuma ku so nggarr ambre ni Igbre nu Olivu wa. ");
INSERT INTO ninNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ttuttumi ni igambre anishirr ba ta gru nga ni shirr atu na wo ure umaku nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ivi yi ki ywhiywhirr, nggo a ta na Iga i Unfonfo ni Sama ni Iyisti wa, nggo a yo yi di Iga i Ivu Sarr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ankpinkpye abikye ba na abitsarr Are ba a so kru isisu i anishirr yi, ima yo du ba so zha anko wa nggo aba ta vu Yesu sharri. ");
INSERT INTO ninNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nggo Isheta mirri ni isisurr i Yahuda, nggo a yo ma di Iskariyoti. Uwa yo su uyirr nu umi ku awurr na aha ba. ");
INSERT INTO ninNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","U Yahuda gru kuma na ankpinkpye abikye ba ba na ankpinkpye abi gbye Uki ku Ibarr ba, na ku bre ba nggo uwa ta ná, nà ka ba Yesu re ba. ");
INSERT INTO ninNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Aba nyarr ku na ddu ma di aba ta nu ma inklo. ");
INSERT INTO ninNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","I Yahuda kpanye na gru ko ri amarr ka anko zizi, wre ku bu vu Yesu a nu ba na yi, anishirr shishemi a si ta se nabo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Na azhibarr wa nggo a ko na Iga i Unfonfo ni Sama ni Iyisti wa. A sa azhibarr nggo anishirr a ko han imimarr inkru i Iga i Ivu Sarr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","I Yesu tu Biturr tuku Yohana na ddu ba di, “Imba kuma ku ssu ila i Iga i Ivu Sarr yi ssubi di inta ni ri.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Aba ka zhi ma di, “Ùwà zha di inta bu ku ssu yi ki nu momonggo?” ");
INSERT INTO ninNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Uwa da ba di, “Imba ti ta mirri nu umi ìgbù ku, imba ta hi ugo numa nggo gri itsa i amasirr na nga ni imba ba. Imba ga ma rri ko ni iko yi nggo a ta rri, ");
INSERT INTO ninNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ni zhi akikye ni iko wa di, ‘Unitsarr wa à da di, uki ku nggo ingga na abiga mungga ba ta ri ila i Iga i Ivu Sarr yi u si momonggo?’ ");
INSERT INTO ninNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Akikye ni iko wa à ta gri imba hun ku tsarr angbla uki numa na atu, nggo a ka ssu ku ki zu ba. Imba surr inkindirr iri yi nabo yo.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aba huzzu na ku hi aseki ka meme yo nâ ta si nggo Yesu a da ba, na na ila yi Iga i Ivu Sarr yi nabo. ");
INSERT INTO ninNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nggo azhi wa ama ba, Yesu ku ji so na ri ila yi na abi ko na angu ama ba ba. ");
INSERT INTO ninNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na ddu ba di, “Ingga so kye anko di ingga ka ri ila Iga i Ivu Sarr yi ni imba ba bari, ni ka ki iha yi! ");
INSERT INTO ninNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ingga da ki imba, ingga si taka ri yi zizo hen. Uwa taka se ni ikikre yi mu bari nggo a taka hi inkindirr yi nggo du ba so ri ni Ittu i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu ki ungo ba ukofi ku, na nyarr ku Abachi, na da di, “Imba kpa ga ki ikpa imba. ");
INSERT INTO ninNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ingga ko da ki imba di bazhi ziza, ingga i si taka so ahi a ugbyarr unkunkurr numa zizo hen, Ittu i Abachi yi taka nga bari.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Na ba unfonfo wa gri na nyarr ku Abachi, na mɨ ma, na ka nu ba di, “Uwanggo su ukpa umungga ku nggo aba ku ni ni itu amba. Imba na meme, wre ki imba ka di ri amarr amungga.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nggo a ri kre, Yesu ba ukofi ku nu ba meme yo, na da di, “U uwanggo yo a si ayiyi amungga wa nggo a ka wa kahre ki imba. Ama yo a tsarr azhi ahe̱he̱ ka nggo Abachi à shi ku anishirr ba nggo kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kye! Uwanggo nggo à ta re ingga nu ba, à so ni imburr yi ni ingga ku! ");
INSERT INTO ninNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ingga Uvuvurr a Unushirr ta ttu nâ ta si nggo Abachi kye iwre ku. Uje ku unushirr uwama nggo ta ba ingga re!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aba gru so zhi ikpa di, a su unggonggo nu umi umunta ku nggo à ta na meme. ");
INSERT INTO ninNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Abi ko na angu ba a gru ko ri anta ni ikpa di uwatanggo ta sa ankpye nu umi umbarr ku. ");
INSERT INTO ninNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu ddu ba di, “Atuttu bi ingbingbru ba a hru anishirr ambarr ba nu ukyekye mu. Ankpinkpye angga ba nggo a si nu ukyekye na atu anishirr wa a yo atu ambarr di, ‘Abi zi anishirr’. ");
INSERT INTO ninNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","I si si meme yo ni imba ba hen. Unkpi wa nu umi umba ku bu kaki uvutsa. Uni gri imba wa a bu na ki ugarr. ");
INSERT INTO ninNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Undurr wa nggo à si ankpye, uwanggo su unushirr wa nggo ji so na ri, ka uwanggo nggo a so na ku undu? E-e! Undurr wa nggo ji so. Ingga su uvurr iko nu umi imba ku. ");
INSERT INTO ninNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Imba di so ni ingga ku ni hi itsarr kye mungga yi namri. ");
INSERT INTO ninNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","A si nu nggo Aki mungga à ni ingga ukyekye ku hru anishirr nâ ta su uttu, ingga mi ta ni imba meme inkpinkpye ihru anishirr nâ ta su atuttu. ");
INSERT INTO ninNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Imba ta ri, ni so ni ingga ku ni imburr inkpi yi ni ittu imungga yi, ni ta si atuttu abi gri aki awurr na aha ka Israila ka. ");
INSERT INTO ninNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Sima! Sima! Wo! A bwu ku Isheta anko di a bu tsarr imba kye, nggo a di hla azizi ba glo na andanda ba, nâ ta si nggo uni do à di ze ikiri na ddu akpukpla ka. ");
INSERT INTO ninNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ingga ko barr ku ùwà, Sima, di iyo isisurr imuwa yi bu si jaku hen. Nggo ùwà ti kanga ni ingga ku, ùwà nu amuya amuwa ba ukyekye.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Biturr ddu ma di, “Atiko, ingga ta ga ùwà kuma nu uki ki iharr ku, ni ta ttu ndo nu ùwà ku!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu ddu ma di, “Ingga da ku ùwà, Biturr, agba wa ta nise tu ni ibittu inggi yi, ùwà taka kisa ki ankpu tarr du ùwà si hi ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nggo Yesu gru zhi abiga ma ba di, “Nggo ingga turr imba kuma ni me̱me̱ yi sama na ambu a uzirr, na ambu a inklo, na anggakpaza, imba zha inkindirr chankarr?” Aba da di, “Iya, inta i si zha inkindirr chankarr hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu ddu ba di, “Zizami, undurr wanggo nggo ti se na ambu a uzirr, ka ambu a inklo, uwa bu ba gri. Undurr wa nggo ti sama na anjingba, uwa bu ba ankru ama ka a re na re ayirr. ");
INSERT INTO ninNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Imba na meme, wre ku inkindirr yi nggo Angbamvu ka Abachi ka a da ni itu mungga nggo i bu la meme yo. Angbamvu ka a da di, ‘A bre ma yo na abi la ure ba.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Abiga ma ba a da di, “Ankpye, kye inta i se na anjingba aha!” Uwa ddu ba di, “A ma ba!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu gru huzzu ni igbu wa nâ ta si nggo a di na ttuttumi na kuma ni Igbre nu Olivu wa. Abiga ma ba a ga ma. ");
INSERT INTO ninNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nggo a ku rri nu unto ku na da ba di, “Imba barr yi, wre ki imba bu si jaku ni itsarr kye yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Na chi kuma ntsɨ, ma nggo ka ta ingbinta ko, na kuttu na agbuzzu na barr di, ");
INSERT INTO ninNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Aki mungga, ùwà ti kpanye ùwà ka ukofi ku iha unggo ku glo ki ingga. Na inkindirr yi nggo i wre ku ùwà, si na inkindirr yi nggo ingga nggo i zha du ùwà bu na hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Unitu a Abachi wa à ji zhi nu ussu ni nu ma ukyekye ku vu isisurr. ");
INSERT INTO ninNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu à se nu umi ku ivri ni isisurr kakami, na so barr kakami na gba ajiji, ajiji ka ko tse zzu ayiyi mu surr ni imimi. ");
INSERT INTO ninNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nggo Yesu gru zhi nu unto ku ibarr ku, na kakuma na abiga ma ba ba, na ku hi ba a ka di ba na so kurr ina. Isisurr imbarr yi i se ni ivri. ");
INSERT INTO ninNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Uwa ddu ba di, “Imba so kurr ina ngginggi yi? Gru so tsitsirr ni barr yi, wre ki imba bu si jaku ni itsarr kye yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nggo Yesu ni ko re, akpa anishirr shishemi nga na ku. Uyirr nu umi ku abiga ba, a ri Judasi a so zirr ni ichi imbarr, na zirr nga ni nyarr Yesu vu gri. ");
INSERT INTO ninNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yesu zhi ma di, “Judasi, ùwà nga ni ngu ingga Uvuvurr a Unushirr na ango, wre ku ùwà bu ba ingga re ba yo?” ");
INSERT INTO ninNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nggo abiga Yesu ba a hi inkindirr yi nggo ko zirr, na zhi ma di, “Atiko, inta bu na undu ni injingba munta yi?” ");
INSERT INTO ninNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Uyirr nu umi ku abiga ma ba à ka itu anjingba a sarr ku ugarr a ankpye unkpi abikye numa wa utu ku ungo ri. ");
INSERT INTO ninNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","I Yesu à ddu ba di, “I ma ba!” Na ki ungo vu ku utu ku, u ku wre. ");
INSERT INTO ninNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","I Yesu ddu ankpinkpye abikye ba, na ankpinkpye bu Uki ku Ibarr ba, na akikre anishirr abanu nggo nga ivu ma di, “Imba nga nye vu ingga yo ni injingba na ankpunkpu inkinkurr, zzu di ingga la ki imba ure? ");
INSERT INTO ninNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ttuttumi ingga di se ni imba ba nu Uki Unkpi ku Ibarr Abachi ku, imba si vu ingga hen. Ziza yo sa azhibarr a ivu wa, nggo uttu ni ibwu wa ko gri ittu yi.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nggo a vu Yesu, na gri ma na kuma ni iko i ankpye unkpi abikye wa, Biturr à so ga ba gbagba mu nu ugo. ");
INSERT INTO ninNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Aba mu uru nu ure̱ ku na ko vri, Biturr ku ji so na ko vri na ba. ");
INSERT INTO ninNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Uva ugarr numa nggo hi ma ni so na ba yi, na kye ma girr, na da di, “Ugo nggo mi se ni Yesu ku!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Biturr kisa di, “Ayamba, ingga si hi ma hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","A sha so ntsɨmi, ugo numa à hi Biturr ni so yi, na da di, “Ùwà mi su uyirr nu umi umbarr ku meme!” Biturr da di, “Ugo nggo, ingga si se hen!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A sha so ntsɨmi zizo, ugo numa kri karrkarr di, “Ugo nggo a se ni Yesu ku, uwa mi sa anu Galili!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Biturr da di, “Ugo nggo, ingga si hi inkindirr ima nggo ùwà ko da yi hen!” Nggo à ni ko re mre, agba wa tu. ");
INSERT INTO ninNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ni ima, Atiko wa kasarr na kye Biturr girr. Biturr à ssu hi inkindirr yi nggo Atiko wa da ku di, “Agba wa ta nise tu ùwà ta kisa ki inkpu itarr du ùwà si hi ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","I Biturr gru huzzu ku kri na abi na so yi kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Anishirr ba nggo a so gbye Yesu à gru ko sarr ma na hlo ma. ");
INSERT INTO ninNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na ki upri ankru ttu ku ashishi ka, na zhi ma di, “Unggonggo nggurr ùwà? Gye da!” ");
INSERT INTO ninNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Na bre are andanda numa ssu ku. ");
INSERT INTO ninNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nggo ambre ka nggarr, akikre anishirr, na ankpinkpye abikye ba, na abitsarr Are ba, a nggurr bi, na gri Yesu nga na age̱ ka inggurr bi i ankpinkpye yi. ");
INSERT INTO ninNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Na ku zhi ma di, “Da ki inta, ùwà yo su Kristi wa?” Yesu ddu ba di, “Ingga ti da ki imba mi imba si ta kpanye hen. ");
INSERT INTO ninNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ingga ti zhi imba ure, imba si ta sa ki ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bazhi zizami kuma ni ichi, ingga Uvuvurr a Unushirr ta so nu ungo ri ku Abachi nggo su Unukyekye we.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Aba zhi ma di, “Ùwà yo su Uvuvurr a Abachi wa?” Uwa ddu ba di, “Imba da meme yo di ingga su Uvuvurr a Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Aba da di, “Inta si zha inkindirr numa na ku zizo hen. Inta wo na atu amunta inkindirr yi nggo a da ni ibarr angu ima nggo!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Anishirr ba gru namri na gri Yesu kuma nu Bilatu ku, ");
INSERT INTO ninNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","na gru so re kisa ma na ku di, “Inta vu ugo nggo uwa so re anishirr di a bu si han inklo imimi ku Kayisa hen, na gru ko da na nkpama du uwa yo si Kristi wa, wanggo a su uttu.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","U Bilatu a zhi Yesu di, “Ùwà yo su uttu a anu Yahuda wa?” I Yesu ddu ma di, “Nâ ta si nggo ùwà da.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","U Bilatu à ddu ankpinkpye abikye ba na anishirr ba di, “Ingga si hi ugo nggo ni ìlà nggo ingga ka ttu ma iba hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aba kà na gru kri ku kyekye mi di, “Itsarr ima yi gri itsi nga ku anishirr ba kago nu Yahudiya. A tsarr zhi nu Galili mu, uwanggo ziza a rri ni inggya.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nggo Bilatu wo meme, na zhi ba di, “Ugo nggo sa anu Galili?” ");
INSERT INTO ninNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nggo à wo di Yesu zhi na anga ka nggo Hirridu so gri ka, na turr ma kuma ku Hirridu. Hirridu à se nu Urushalima ni ivi ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","U Hirridu nyarr kakami, nggo a hi Yesu ashishi na ashishi. A ta anko ba na di wo are ama ka, na si hi inkindirr yi nggo uwa ka na, na hi ma hen. Na a ko yo isisurr du uwa ka hi ma ni na inkindirr numa ikagri. ");
INSERT INTO ninNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","I Hirridu zhi Yesu are shishemi. I Yesu kri ngbangbami. ");
INSERT INTO ninNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ankpinkpye abikye ba na abitsarr Are ba gru chi kuma na hantu, na bre ku Hirridu are ka imu andanda ni itu i Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","U Hirridu na abi ta iku ama ba a sarr Yesu, na ku ba ankru ka uttu, ni surr ku, na turr ma kakuma ku Bilatu. ");
INSERT INTO ninNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Na azhibarr ama yo Hirridu tuku Bilatu a vu ikpikpa. Ngbangba ka a so di karr ikpa. ");
INSERT INTO ninNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatu yo ankpinkpye abikye ba, na akikre ba, na anishirr ba namri, ");
INSERT INTO ninNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","na da ba di, “Imba gri ugo nggo ni nga ni ingga ku di a so di re anishirr mi. Kye, ingga zhi ma na ashishi amba ni si hi ma ni inkindirr ìlà iyirr mi nu umi ku aseki ka nggo imba bre ku na ka hen. ");
INSERT INTO ninNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirridu mi meme a si hi ma ni ìlà hen, na turr ma kanga ni inta ba. Ugo nggo à si na inkindirr numa nggo ima itsi ma ngu hen. ");
INSERT INTO ninNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","A ta si meme ingga ta hlo ma ni du ma kuma.”  ");
INSERT INTO ninNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ttuttumi ni Iga i Ivu Sarr yi ani Yahuda ba a ti barr, u Bilatu di ttu unushirr uyirr nggo ttungo, nu umi ku abangga ba nggo a kri harr. ");
INSERT INTO ninNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Anishirr ba namri a gru hantu di, “Ngu ma! Ni ttu Barraba ttungo ki inta!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(A yo Barraba wa ni harr yi di a tto itsi nu Urushalima, na ngɨ anishirr). ");
INSERT INTO ninNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatu ko zha du uwa ta ttu Yesu nggo ttungo, na barr anishirr ba zizo. ");
INSERT INTO ninNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Aba kisa na nggurr ungo na angu di, “Kpa ma! Kpa ma nga nu unkunkurr ku!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Bilatu da ba inkpu itarr yi di, “Ugo nggo à là angginggi? Ingga si hi inkindirr yi nggo a na hen, imba di imba ta ngu ma! Ingga ta hlo ma ni ttu ma ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aba kisa na hantu kisa di a bu kpa Yesu. Ni ikikre yi ihantu, imbarr yi i du amarr ka Bilatu ka a ba kasarr, uwa ba ma nu ba. ");
INSERT INTO ninNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bilatu à yo ba ungo ni inkindirr yi nggo a ko zha ni itu i Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Na ttu ugo wa nggo a harr ma nu uki, ku itsi ni ingɨ anishirr yi ttungo. Bilatu ba Yesu nu ba di a bu kuma ku na inkindirr yi nggo isisurr imbarr da ba. ");
INSERT INTO ninNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Abi ta iku ba a gri Yesu na share. A so kuma nggo na zzu hi ugo numa a sa anu Sirrene, a yo ma di Sima. Uwa so ka zhi ni ivi ìgbù numa, na ta ko rri nu Urushalima. Aba vu ma, na ba unkunkurr ku garr ku a sa ku nu umpa, na du ma gri ku, na ga Yesu nu ugo. ");
INSERT INTO ninNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Akpukpa anishirr di ga ma. Amba banu se nu umi umbarr ku na a so yì ku Yesu. ");
INSERT INTO ninNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu kakye ba na ddu ba di, “Imba amba bu Urushalima! Imba si yì ki ingga hen, yì ku atu amba na amumarr amba ba. ");
INSERT INTO ninNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ivi yi so nga nggo anishirr ta da di, ‘Amba ba nggo Abachi à yo ba angu azizi, a si abangga ba nggo a nise ngri kye, nggo uvuvurr a nise ma ba asisa ambarr kye!’ ");
INSERT INTO ninNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Uwama yo ta si ivi yi nggo anishirr ta ddu agbre ka di, ‘Ji ttu inta!’ na ta ddu agbre ingbinta di, ‘Sha inta sharri!’ ");
INSERT INTO ninNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Anishirr ka ti na aseki a kama ni ivi yi nggo unkunkurr i to ni shirr, i ta si kingginggi ni ivi yi nggo i ti kru?” ");
INSERT INTO ninNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Abi ta iku ba a gri abi la ure aha abanu kye ku Yesu ta ku kpa ba ni inkinkurr yi ma mi. ");
INSERT INTO ninNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nggo a ni rri nu unto ku nggo a yo ku di, “Ukpahe Itu”, na kpa Yesu nabo na abayi ba aha mi. Uyirr wa nu ungo ri, uyirr wa nu ungo mla. ");
INSERT INTO ninNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu da di, “Aki mungga, nggurr zhi ba! Kye, a si hi inkindirr yi nggo a ko na hen.” Abi ta iku ba a ba ankru ama ka nggarr ga, na ko hla hi hla. ");
INSERT INTO ninNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Anishirr ba kri na ko kye, u ankpinkpye anu Yahuda ba ko me̱ ma di, “A kpa abanu ttungo, a ti du uwa yo su Kristi wa nggo Abachi a hla ma, uwa bu kpa itu ima ttungo di inta kye.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Abi ta iku ba mi kri na ko sarr ma, na nga, ni nu ma ususa ahi, ");
INSERT INTO ninNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","na da di, “Kpa itu muwa ttungo, ùwà ti da du ùwà yo su uttu anu Yahuda wa!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ni itu ima yi a charr nu unkunkurr ku di: UWANGGO YO SU UTTU ANU YAHUDA WA. ");
INSERT INTO ninNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Uni la ure uyirr wa, nggo a kpa ma bi ni Yesu ku nggo, à gru ko marr ma di, “A si su ùwà yo su Kristi hen? Ttu itu muwa ttungo kye ni inta mi meme!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Uyirr wa nggarr ito na ku di, “Ùwà si kru isisu i Abachi hen? Ùwà kpa iha iyirr ndo na ku. ");
INSERT INTO ninNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Imunta yi ima ki inta, inta ko vu inkindirr yi nggo inta ngga i ttu yi, uwama à si na inkindirr hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Na ka ddu Yesu di, “Kakye ingga hi ni ittu muwa yi!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu ddu ma di, “Ari, ùwà ta so ni ingga ku nu unkplassu.” ");
INSERT INTO ninNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nu nggo a si na azhi na atsutsu mi, nggo azhi wa a kà ila yi, igbu wa wemi a shi ibwu, kuma ni itarr ingbahru. ");
INSERT INTO ninNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Azhi wa kà ila yi. Ungbanja ankru ku nggo a klo ku nu Uki Unkpi ku Ibarr Abachi ku u nggarr ki anga aha. ");
INSERT INTO ninNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu à yì hantu di, “Aki mungga! Izhi imungga yi i si na ango muwa!” Nggo a da meme, na ttu. ");
INSERT INTO ninNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ankpye abi ta iku wa nggo a se nabo nggo, a hi inkindirr yi nggo i la, na nyarr ku Abachi di, “Jiji mu, ugo nggo à su unushirr uzizi!” ");
INSERT INTO ninNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Anishirr ba nggo kri nabo na ko kye inkindirr yi nggo ko zirr, na hi inkindirr yi nggo i la, a kakuma ni iko, ni ivri isisurr, na sa ango na anke̱. ");
INSERT INTO ninNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Abangga ba nggo a hi Yesu ashishi na ashishi, na amba ba nggo a di ga ma zhi nu Galili, a kri gbagbamu na so kye ma. ");
INSERT INTO ninNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ugo numa a ri Isuhu, nggo su uyirr nu umi ku akikre ba ni inggurr bi i anu Yahuda yi, na su unushirr uzizi, nggo a di kye ma ssu na ango. ");
INSERT INTO ninNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","A si kpanye na amarr ka ankpinkpye abanu ba hen, na kisa ni inkindirr yi nggo a na nggo. Isuhu a zhi ni igbu numa ni Yahudiya, nggo a ri Arrimatiya. Na so di kye anko a inga a ittu i Abachi yi. ");
INSERT INTO ninNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","A gru kuma ku barr Bilatu iku i Yesu yi. ");
INSERT INTO ninNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Na hun ku ttu iku i Yesu yi ji, na nyarr yi nu upri inkru nggo a di nyarr iku na ku, na ba yi ku yo ni ibe yi nggo a ya yi na ankɨ ingbinta wa, na nise na undu na yi. ");
INSERT INTO ninNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","A si na azhibarr nggo ani Yahuda ba a so ssubi ku azhibarr Asabarr, nggo a si Azhibarr a Isu anu Yahuda. A si ni ingbahru, nggo Azhibarr a Isu wa a ko ma. ");
INSERT INTO ninNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Amba ba nggo a ga Yesu zhi nu Galili, a ga Isuhu ku kye ibe yi, nggo a yo iku yi. ");
INSERT INTO ninNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Na kakuma ni iko ku na anye a ihun ingba wre ku iku yi. Na Azhibarr a Isu wa, aba so su, nâ ta si nggo Are ka Musa ka a da. ");
INSERT INTO ninNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ni igambre bwu, nu uha na Azhibarr a Isu ani Yahuda wa, amba ba gru kuma ni ibe yi, na gri anye ka a hun ingba wre wa nggo a na ka ssubi. ");
INSERT INTO ninNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na ku hi a ngi ingbinta yi glo na angu anko ka ibe ka. ");
INSERT INTO ninNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","A mirri kuma, na si ku hi iku i Atiko Yesu yi ni ibe yi hen. ");
INSERT INTO ninNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","A kukri nabo kpi, na ko ri amarr ni inkindirr ima yi, mre na gru kakye anishirr aha a kri na aba, na surr inkinkru i la zanzarr nâ ta si azhi. ");
INSERT INTO ninNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Isisu i ki amba ba, aba kuttu ni imimi. Abitu ba Abachi ba a zhi amba ba di, “Sa angginggi du imba ko zha uni so tsitsirr nu umi ku abi kɨ? ");
INSERT INTO ninNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A si se ni inggya hen! A ka tasi ba. Imba bu ssu hi inkindirr yi nggo à da ki imba nu Galili. ");
INSERT INTO ninNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘A ta ba Uvuvurr a Unushirr sa ku abi la ure na ango, du ba kpa ma, u nu ugo ki ivi itarr, uwa ta tasi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Mre amba ba a ssu hi di Yesu à da meme. ");
INSERT INTO ninNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Na share ni ibe yi na kakuma ku da ku awurr na ayirr ba ni inkpu anishirr yi. ");
INSERT INTO ninNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Amba ba nggo a kuma ni ibe yi a su Maryamu nu Magadala, tuku Yuwana, u Maryamu ayirr a Yakubu. Aba ni inkpu amba yi, a ga ba ku da ku abi ko na angu ba. ");
INSERT INTO ninNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Abi ko na angu ba kye ure kuma ki ankalanttu, na si kpanye na ba hen. ");
INSERT INTO ninNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Biturr gru kru kuma ni ibe yi ku klo kye na hi iki izzu anishirr iyo kurr, iku i Yesu yi i sama nu umi. Uwa kakuma ni iko ni ku ayisurr ni inkindirr yi nggo uwa ku hi. ");
INSERT INTO ninNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na azhibarr ayiyirr ama wa, anishirr aha nu umi ku abiga Yesu ba, a ko kuma ni igbu wa nggo a ri Emayo, nggo ka ma kilomita iwurr ni yirr zhi nabo na kuma nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Aba ko re ku ikpa ni inkindirr yi nggo i la. ");
INSERT INTO ninNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nggo a ko re na ko ta amarr, Yesu ni itu ima à nga ywhiywhirr, ni ko zirr na ba. ");
INSERT INTO ninNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Aba ko hi undurr wa, na si kye ma hi ka su unggonggo hen. ");
INSERT INTO ninNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu zhi ba di, “Imba zirr ni ko re da angginggi ga anko?” Aba kukri ngbangbami, ni ivri na ashishi ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Uyirr nu umi ku, a yo ma di Kliyopa, a zhi ma di, “Ùwà yo si unichirr wa na nkpami nu Urushalima nggo si hi inkindirr yi nggo i la nabo ni ivi inggi yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu a zhi ba di, “Imba ko re da angginggi?” Aba ddu ma di, “Ni itu i inkindirr yi nggo i la ni Yesu anu Nazareti wa ku nggo. Ugo nggo wa à su uni kpa are mu a Abachi, na di na aseki ka ku ayisurr shishemi. Abachi à na anishirr ba namri du ba kye ma ssu na ango. ");
INSERT INTO ninNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ankpinkpye abikye munta ba na ankpinkpye ba, a ba ma a ni, di a bu tsi ma ngu. Aba a kpa ma nu unkunkurr. ");
INSERT INTO ninNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Inta ko yo isisurr du uwa yo taka ni kpa Israila ttungo! Ari su utarr mu nggo a na inkindirr ima yi. ");
INSERT INTO ninNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kye, amba banu nu umi munta ku, a ni da ki inta ure ki ku ayisurr da aba zzu han kuma na ambre ni ibe yi, ");
INSERT INTO ninNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","na si ku hi iku yi hen. Na kanga da aba ku hi zzu da su nu ula, abitu ba nggo a da ba di Yesu à si tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Abanu nu umi munta ku, a kru kuma ku kye ibe yi, na ku hi meme yo nggo amba ba a da, na si hi ma hen.” ");
INSERT INTO ninNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu ddu ba di, “Imba sa arrurru, imba si kpanye na aseki ka wemi nggo abi kpa are ba a da hen! ");
INSERT INTO ninNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Imba kye, i wre ku Kristi wa du ma ki iha bari Abachi ka kye ma ssu na ungo kakami nu unkplassu?” ");
INSERT INTO ninNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesu bre ba aseki ka nggo a charr nu Ungbamvu ku Abachi ku ni itu ima yi, bazhi ni ime̱me̱ yi na Angbamvu ka Musa ka tuku ni inkpu icharr i abi kpa are ba. ");
INSERT INTO ninNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nggo a ki ywhiywhirr ni igbu nu Emayo wa, nggo a so kuma, Yesu à na zzu du uwa a ta tsi so kuma ni ichi mu. ");
INSERT INTO ninNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Aba tsi ku ango di, “Nga ni so ni inta ba, kye azhi wa ko ku, ibwu ta ko ki.” Uwa ka ga ba rri kuma ku so na ba. ");
INSERT INTO ninNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nggo a ji so na ta ko ri, Yesu ba unfonfo wa, na nyarr ku Abachi, na mɨ ma ga ba. ");
INSERT INTO ninNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mre, aba gru ko kye ma hi. Uwa ka nado. ");
INSERT INTO ninNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aba gru ko zhi ikpa di, “A si si nâ ta si uru nggo u ko rri ni isisurr munta yi nggo à ko re na anko wa, nggo ko tsarr ki inta Angbamvu ka Abachi ka hen?” ");
INSERT INTO ninNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mre, aba tudo gru ankpa ayirr kaji kuma nu Urushalima, na ku hi abi ko na angu awurr na ayirr ba so na abanu. ");
INSERT INTO ninNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Abi ko na angu ba a ddu aba aha ba di, “Atiko munta wa à tasi jiji! A bwu ku Sima ashishi na du ma à hi ma!” ");
INSERT INTO ninNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Anishirr aha abi zhi nu Emayo ba a gru so da ba inkindirr yi nggo aba a zzu hi na anko, tuku nggo aba kye ma hi nggo a ko mɨ unfonfo wa. ");
INSERT INTO ninNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Nggo aha ba ni ko bre ba, mre aba kakye Yesu kri na ba, na ddu ba di, “Imba bu se ni isu isisurr.” ");
INSERT INTO ninNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Aba ki wu, na kye da aba ko hi uzhi mu. ");
INSERT INTO ninNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Uwa ddu ba di, “Imba kru isisu ngginggi? Angginggi di imba si kpanye hen? ");
INSERT INTO ninNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kye, inkpa ango imungga yi, na atoza amungga ka, ni bu hi di a si ingga yo ni itu mungga. Sa ungo ni ingga ku kye imba ta hi. Kye, izhi i sama ni inina ikpa tuku attuttu, imba hi ingga se na aseki akama.” ");
INSERT INTO ninNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nggo a da meme, na tsarr ba ango ka na aza ama ka. ");
INSERT INTO ninNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Aba nyarr kakami na ku ayisurr di jiji mu Yesu a si tsitsirr, na si kpanye hen. Uwa zhi ba di, “Imba se na angginggi iri ni inggya?” ");
INSERT INTO ninNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Aba ba kukru ikikla nggi ni surr sisurr a nu ma. ");
INSERT INTO ninNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Uwa kpa ta na ashishi ambarr. ");
INSERT INTO ninNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yesu ddu ba di, “Nggo ingga ni di se ni imba ba, ingga bre ki imba di: Aseki ka wemi nggo a charr na are ka Musa ka, tuku angbamvu ka abi kpa are ka, tuku Ungbamvu ku Asarr ka Igbyarr Asa ku, a ta la ni itu imungga.” ");
INSERT INTO ninNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mre, uwa bre ba di a bu hi ankpi ire ka nggo a charr na Angbamvu ka Abachi ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na a ddu ba di, “A charr na Angbamvu ka Abachi ka di Kristi wa à ta ki iha na ttu, unu utarr wa uwa a ta gru ni ibe yi. ");
INSERT INTO ninNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","A charr zizo na Angbamvu ka Abachi ka di anishirr a ta ba isa ima yi bre Ure ku wre ku Abachi ku. Bazhi nu Urushalima na kago igbu i ingbingbru inggi yi wemi a ta bre da anishirr bu du ina ndanda na kanga na Abachi ku, wre ku a bu nggurr ila ure imbarr yi zhi ba. ");
INSERT INTO ninNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imba yo i ki ashishi hi aseki angga ka, kuma ku da ku abanu inkindirr yi nggo imba hi nggo. ");
INSERT INTO ninNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ingga ku itu mungga ta tu ki imba Izhi Iwre yi nggo Aki mungga wa à da zu. Imba bu ku so nu Urushalima bi ukyekye ku nggo ta ji zhi nu ussu nga ki imba.” ");
INSERT INTO ninNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mre, Yesu gri ba na huzzu nu umi igbu ku, kuma ni igbu nu Betani, na ku gɨ ango ama ka ki nu ussu na yo ba angu ka iwre. ");
INSERT INTO ninNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nggo a so yo ba angu azizi ka, mre aba attu ma ki nanka na ba ma hun kuma nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Aba kuttu na so gbyarr ku asa na kakuma nu Urushalima, ni inyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Bazhi ni ima yi, aba a ka ko nu Uki Unkpi ku Ibarr Abachi ku, na so gbyarr ku Abachi asa.");
INSERT INTO ninNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ure u se ni ime̱me̱ i aseki yi. Ure ukuma u di se ndo na Abachi ku. Ure ukuma u si Abachi. ");
INSERT INTO ninNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ure kuma u di se ndo na Abachi ku zhi ni ime̱me̱ yi. ");
INSERT INTO ninNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Abachi à na aseki ka we nu ure ukuma yo, na a si na inkindirr inuma nanka sama nu ure ukuma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Iso tsitsirr i zhi nu uwa yo ku, i iso ima iyo su i so là nâ ta si uru nggo u so là kago ku anishirr. ");
INSERT INTO ninNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Uru ukuma yo u so là ku abi so ni ibwu ba. Ibwu yi ka si tsi ku zhi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Abachi à tu unitu ama wa, nggo isa ima yi ri Yohana, ");
INSERT INTO ninNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","di a bu nga ni tsarr anishirr ure ni itu i ìlà yi, wre ku anishirr we a bu wo ma na kpanye nu ure ku. ");
INSERT INTO ninNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yohana nggo à si si uru ku ìlà jiji ku hen, à si uni tsarr anko mu. ");
INSERT INTO ninNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Uwa uwanggo nggo à si uru ku ìlà ujiji ku nggo, uwa yo à so nga ni ingbingbru yi, na taka ni là kago ku ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ure ku u se ni ingbingbru yi, Abachi à na ingbingbru nu ure uku yo, i ingbingbru yi i si hi ma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Uwa à nga nu unto umaku, u anishirr bu unto ku uma ba a kà na si kpa ma yo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Abanu ba a kpa ma na kpanye na ku. Abangga ba nggo a kpanye na ku, uwa nu ba ukyekye du ba kaki amumarr ba Abachi. ");
INSERT INTO ninNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Amumarr ba nggo a si si ingri i ukpa hen, ka akiki ba anishirr hen, ka ni ida i anishirr hen, amumarr ba nggo a ngri ba zhi na Abachi mu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ure ku u kaki unushirr ni rri so ni inta ba ni ingbingbru inggi yi. Inta i hi inkpinkpye ima yi, inkpinkpye i Uvuvurr uwama nggo à si ku Aki wa uyirr uwa yo, a tsarr ssu nu uzizi tuku ujiji. ");
INSERT INTO ninNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohana à bre ure hantu ni itu i unushirr uwama wa di, “Uwanggo yo su uwanggo nggo ingga ko re ni itu ima yi di, ‘Uwanggo nggo à so nga nu ugo umungga, na mri ingga, na à se ku ki ingga ichi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","À si ina wre ima iyo, i du inta i so kpa aseki ka iwre ka na achi na achi. ");
INSERT INTO ninNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Musa nggo a gri Are ka nga, i Yesu Kristi nggo à gri ina wre ni ina jiji nga. ");
INSERT INTO ninNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Undurr nise hi Abachi kye. Abachi yo ki itu ima, à du Uzuma wa na ankpa ma, uwanggo wa nggo so ywhiywhirr na Aki wa ku, à nga ni du anishirr ba hi di Abachi à si kingginggi. ");
INSERT INTO ninNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wanggo yo su ure ujiji ku nggo Yohana à da, nggo ankpinkpye anu Yahuda ba nu Urushalima a tu abikye ba na abi zi undu nu Uki ku Abachi ba di a bu ku zhi ma di, “Ùwà su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohana à re kyekye mi na da ba ssuzzu di, “À si si ingga yo i si Kristi wa, nggo Abachi à da zu di uwa à taka tu ma nga hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Aba a zhi ma zizo di, “Uwa su unggo mu? Uwa si Iliya mu?” Uwa à kisa di, “Iya, ingga i si si Iliya hen.” Aba zhi ma di, “Uwa yo su uni kpa are wa nggo Abachi à da di à taka nga?” Uwa kisa di, “Iya.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Aba zhi ma zizo di, “Ùwà su unggonggo? Da ki inta ùwà i si unggo, ni di inta kakuma ku da ku abitu inta ba. Ùwà su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yohana da ba ukorr ure ku Ishaya uni kpa are wa di, “Ingga yo su ukorr ku nggo u so du na ankpuji di, ‘Na anko wa ki ntto ku Atiko wa!’ ” ");
INSERT INTO ninNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","A si anu Farrisi ngga a tu ba, ");
INSERT INTO ninNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","aba gru zhi ma di, “Ùwà i ta si si Kristi, ka Iliya, ka uni kpa are hen, ùwà i zzu anishirr ba na amasirr, ni na nggye mu?” ");
INSERT INTO ninNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I Yohana à ddu ba di, “Ingga zzu na amasirr, undurr numa se ni inggya nggo imba i si hi ma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","A su uwa yo nggo so nga nu ugo umungga, ingga i si ma uni kuklo ni ddu azhizhi ka anggakpaza ama ka hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yohana a da ure unggo ku, nu nggo a so zzu anishirr ba na amasirr nu Betani nu ugugarr numa ku inyi nu Joda wa. ");
INSERT INTO ninNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nu uha wa u Yohana à hi Yesu à so nga na ku na ddu ba di, “Imba kye uwanggo yo a si Uvuvurr Inkru a Abachi wa nggo à ba ila ure i ingbingbru yi glo! ");
INSERT INTO ninNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Uwa yo su uwanggo nggo à so nga nu ugo umungga, nggo ingga i da ki imba di, ‘Undurr numa so nga nu ugo umungga, nggo à mri ingga, na à se ni ingbingbru inggi yi ku ki ingga ichi.’ ");
INSERT INTO ninNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ingga mi i si hi ma hen. Ingga i ko zzu imba na amasirr wre ku anishirr bu Israila ba a bu hi ma wemi.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","I Yohana a da di, “Mre, ingga kakye Izhi Iwre yi i ji zhi nu ussu nâ ta si anddu ni ku so na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ingga mi nise hi ma kye. Undurr wa nggo à turr ingga di ingga bu nga ni zzu anishirr na amasirr wa nggo, uwa yo a da ki ingga di, ‘Ùwà ti hi Izhi i ji ni ku so nu ugo numa ku, uwa bu hi di uwa yo à su uwanggo nggo à taka ni zzu anishirr ni Izhi Iwre yi.’ ");
INSERT INTO ninNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ingga hi inkindirr inggi yi, ni na meme jiji bari, ni da ki imba di a su Uvuvurr a Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nu uha wa zizo, nggo Yohana à kri na abiga ma aha banu ba, ");
INSERT INTO ninNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","na gru hi Yesu à ko zirr ba na ba, na gru ddu ba di, “Kye, Uvuvurr Inkru a Abachi wanggo!” ");
INSERT INTO ninNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nggo abiga ma aha ba a wo Yohana ni da meme yi, na gru ga Yesu. ");
INSERT INTO ninNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nggo Yesu kakye na hi ba ni so ga ma, na zhi ba di, “Imba so zha angginggi?” Aba ddu ma di, “Rabayi, ùwà di so nu momonggo?” (“Rabayi” inkpi inggi yi su di, “Unitsarr.”) ");
INSERT INTO ninNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I Yesu ddu ba di, “Imba ga mi ku kye yi.” (Meme nggo, azhi wa a ka ma ine̱ ni ingbahru mu ba.) Anishirr aha ba a kuma ni Yesu ku, na ku hi unto ku nggo à di so, na ku so inkpu azhi yi kre nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Uyirr nu umi ku anishirr ba nggo à wo ure ku Yohana ku na ga Yesu, uwanggo a su Andoro, uzayirr a Sima Biturr. ");
INSERT INTO ninNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Inkindirr i ime̱me̱ yi nggo Andoro à na yi inggi, i si nggo à gru ku zha uzayirr Sima, na da ku di, “Inta i hi Mezaya wa.” (Inkpi inggi yi su “Kristi”.) ");
INSERT INTO ninNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andoro wa à gri uzayirr wa na nga ni Yesu ku. Yesu à ni kye ma na da di, “Uwa yo i si Sima uvuvurr a Yohana, a ta yo uwa di Kefa.” (Isa i Kefa ka Biturr si “ingbinta” nggi i ri meme.) ");
INSERT INTO ninNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nu uha wa zizo, i Yesu à gru kuma nu Galili na ku hi Filibu na ddu ma di, “Ga mi!” ");
INSERT INTO ninNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filibu à zhi nu Betsada ni igbu uyirr ndo na anu Andoro tuku Biturr.) ");
INSERT INTO ninNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibu à ku zha Nataniya na da ku di, “Inta hi uwanggo nggo Musa na abi kpa are ba a charr ni itu ima yi. Uwa yo à su Yesu anu Nazareti, uvuvurr a Isuhu wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","U Nataniya zhi ma di, “Nazareti! Inkindirr izizi inuma i ka zhi nu Nazareti?” Filibu à ddu ma di, “Nga ni kye.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nggo Yesu à hi Nataniya ni ko zirr nga na ku na da di, “Kye, uwanggo yo à sa ani Israila ujiji, nggo à di da ure yo!” ");
INSERT INTO ninNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","U Nataniya à zhi ma di, “Ùwà na kingginggi ni hi ingga?” Yesu ddu ma di, “Ingga hi ùwà ni ichi ibwa yi bari Filibu kuma ku yo ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","U Nataniya ddu ma di, “Unitsarr, ùwà yo su Uvuvurr a Abachi wa jiji! Ùwà yo su Uttu ni Israila!” ");
INSERT INTO ninNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu à zhi Nataniya di, “Nggo ingga i da ku ùwà di ingga i hi ùwà ni ichi ibwa yi, ima yo i du ùwà i kpanye? Ùwà ta hi aseki ka nggo a mri meme!” ");
INSERT INTO ninNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","I Yesu ddu ba di, “Ingga ta da ki imba ure ujiji, imba ta hi unkplassu ku ni bwu yi, ni ta hi abitu ba Abachi ba a so ji na bu kahun ni itu i Uvuvurr a Unushirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nu utarr wa aba so na iga i ihru ayamba nu Kena, na anga ka Galili ka, u Maryamu ayirr a Yesu a se nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Aba a yo Yesu ni iga yi, uwa ndo na abiga ma ba a kuma nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nggo à se nabo ahi wa a gru kre, u ayirr a Yesu à nga da ku di, “Ahi wa à na ba kre.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","I Yesu ddu ma di, “Aya, ùwà nggo si ta da ki ingga inkindirr yi nggo ingga ta na hen. Attuttu wa a nise ma ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","U ayirr a Yesu kakuma ku da ku amirr iko ba di, “Inkindirr yi nggo a ti da ki imba di imba bu na, imba na yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nu unto ku, aba zu itsa inkpinkpi itani, nggo a na yi na angbinta, na di surr amasirr a ingla ukpa nggo na yi, nâ ta si nggo iba i anu Yahuda yi i da di a bu di na. Itsa iyirr ka ba amasirr ma indu iso iha ka iso itarr. ");
INSERT INTO ninNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","I Yesu da ku amirr iko ba di, “Imba surr amasirr ssu ni itsa inggi yi we.” Aba surr amasirr wa ssu pwi. ");
INSERT INTO ninNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","I Yesu à ddu ba di, “Imba tsu amasirr anggo wa ga ku uwanggo nggo so kye iga yi.” Aba tsu amasirr wa ga ku ugo wa nggo so kye iga yi. ");
INSERT INTO ninNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nggo à kpa amasirr wa à la kye, amasirr wa à ka kaki ahi ba. Na si hi unto ku nggo a gri ahi wa zhi hen. (Amirr iko aba yo a hi unto ku.) Meme nggo, uwa à yo uwanggo nggo à gri ku ayamba wa, ");
INSERT INTO ninNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na da ku di, “A di gri ahi a iwre a yo huzzu kuchi, nggo abichirr a ti so shi bari aba di gri anuma wa nggo a wre ma mi a huzzu. Hai! Ùwà i so gri ahi a iwre wa huzzu ziza nggo yo!” ");
INSERT INTO ninNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Uwama yo si inkindirr ikagri i ime̱me̱ yi nggo Yesu à na nu Kena, na anga ka Galili. Nabo yo Yesu à tsarr ba inkpinkpye umaku, abiga ma ba a hi na kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nu ugo ukuma, i Yesu na ayirr wa ndo, na amuyirr ba, na abiga ma ba, a gru kuma ku sha so ma ivi ntsɨ nu Kapanahu. ");
INSERT INTO ninNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nggo ivi i Iga i Ivu Sarr i anu Yahuda yi i ki ywhiywhirr, i Yesu à gru kuma nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nabo nu Uki Unkpi ku Ibarr Abachi ku, uwa kuma ku hi anishirr a gri ilando, na aminta, na ananddu ni so re, na abi so sarr inklo a ga so ni imburr imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I Yesu à vu izhizhi cha ki amfarr, na han ilando yi na aminta ba huzzu nu Uki ku Ibarr ku, na vu ankpu imburr ka abi sarr inklo ba kattu na angu na di inklo yi varr hre. ");
INSERT INTO ninNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na da ku abi zu ananddu ba di, “Imba vu ni huzzu ni inggya! Imba si na uki ku Aki mungga ku ki udu hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Abiga ma ba ssu unto nggo ku hi nggo u da nu ungbamvu ku Abachi ku di, “Ingga kpanye ni iko yi Abachi, ikpanye ima i so rri nâ ta si uru nggo ni isisurr imungga.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ankpinkpye anu Yahuda ba a gru nga na ku na are di, “Unggonggo nu ùwà ukyekye ku na aseki angga ka? Na inkindirr i ikagri inuma nggo i ta tsarr inta di Abachi nggo nu ùwà ukyekye ki na meme ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I Yesu da ba di, “Imba tsi Uki Unkpi ku Ibarr Abachi ku nggarr, Ingga ta gɨ ku ni ivi itarr.” ");
INSERT INTO ninNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Aba zhi ma di, “Ùwà du ùwà ta vu ku me zizo ni ivi itarr? Ùwà si hi di a me Uki Unkpi ku Ibarr Abachi ku ki ase iso ine̱ na atani bari, na kre ku hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Uki ku Ibarr Abachi ku nggo Yesu à so re ni itu yi, a su ukpa uma uku yo. ");
INSERT INTO ninNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nggo à tasi ni ibe yi bari, abiga ma ba a ssu ida ima yi hi, na kpanye nu ungbamvu ku Abachi ku, ni inkindirr yi nggo Yesu a bre ba. ");
INSERT INTO ninNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nggo Yesu à se nu Urushalima ni Iga i Ivu Sarr yi, anishirr shishemi a hi iki i ikagri yi nggo a na yi na kpanye du uwa yo à si Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Yesu si kpanye na ba hen, nggo à hi nggo isisurr imbarr yi i se. ");
INSERT INTO ninNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","À si zha du undurr mu bi da ku ure na atu ambarr wa hen. Uwa ki itu ima à hi inkindirr yi nggo i se ni isisurr imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ugo numa nggo a yo ma du Nikodemu, à su uyirr nu umi ku anu Farrisi ba, na si ankpye anu Yahuda. ");
INSERT INTO ninNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Azhibarr numa nggo ni ibittu uwa gru kuma ni Yesu ku, na ku da ku di, “Unitsarr, inta hi du ùwà yo su unitsarr, nggo Abachi à tu ùwà di ùwà bu nga ni tsarr inta ure umaku. Ka sama na Abachi, uwa ka si so na aseki ka ikagri angga ka hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","I Yesu ddu ma di, “Ingga da ku ùwà ure ujiji, a ta si ngri ùwà zizo hen, ùwà si ta ka mirri ni Ittu i Abachi yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","U Nikodemu zhi ma di, “Unushirr ka ti chě ba, aba ta na kingginggi na ngri ma zizo? A ka si ka rri ku ayirr ni ine, na du ba ngri ma inkpo iha hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","I Yesu da ku zizo di, “Ingga da ku ùwà ure ujiji. A ta si ngri ùwà zhi na amasirr tuku ni Izhi i Abachi yi hen, ùwà si taka rri ni Ittu i Abachi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Unushirr nggo di ngri unushirr, meme yo Izhi i Abachi nggi di ngri izhi yi nggo se nu umi munta. ");
INSERT INTO ninNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ùwà bu si ku ayisurr nu nggo ingga da ku ùwà di a ta ngri ùwà zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Unddunddu di go ni kuma nu unto ku nggo u wre ku. Ùwà wo ankɨnkɨ ka, ni si hi unto ku nggo u zhi hen, ka unto ku nggo u so kuma hen. I si meme yo nu unushirr wa nggo a ngri ma zhi ni Izhi i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","U Nikodemu a zhi ma di, “A ka na kingginggi na na meme?” ");
INSERT INTO ninNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu ddu ma di, “Ùwà i si unitsarr unkpi mu ni Israila, ni si hi aseki angga ka hen? ");
INSERT INTO ninNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ingga da ku ùwà ure ujiji, inta so da inkindirr yi nggo inta hi yi, ni inkindirr yi nggo inta sa ashishi na yi, imba si kpanye ni kpa are yi nggo inta da ki imba hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ingga bre ki imba aseki angga ka nggo a si ka imimi inggi yi, imba si kpanye hen. Meme yo, imba ta na sa anggingga ni ta kpanye ni ingga ku nggo ingga ti bre ki imba ure ni itu aseki ka nggo a si ka unkplassu hen? ");
INSERT INTO ninNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Undurr à nise hun kuma nu unkplassu kye na kanga, uwa a si ingga, uwa yo iji zhi nu unkplassu ni nga ni imimi inggi yi, uwa yo su ingga Uvuvurr a Unushirr. ");
INSERT INTO ninNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","A taka gɨ Uvuvurr a Unushirr ki tsa nu unkunkurr ku nâ ta si nggo Musa à gɨ ìwǎ na anga inklo wa nu unkunkurr ku na ankpuji wa, ");
INSERT INTO ninNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","wre ku undurr wa nggo ti kpanye na ku, uwa taka so sese. ");
INSERT INTO ninNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Abachi nggo à kpanye na anishirr ba ingbingbru ba kakami na ba Uzuma wa nggo si ingbingbi iyirr yo a ni, wre ku undurr wa nggo à ti kpanye na ku, uwa taka so sese na si taka ttu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Abachi à si turr Uzuma wa ji nga di a bu ni vɨ anishirr ba ingbingbru ba ni ila ure mu hen, a tu ma di a bu ni kpa ba ttungo mu. ");
INSERT INTO ninNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Anishirr ba nggo a kpanye nu Uvuvurr a Abachi wa ku a si ta vɨ ba ku ila ure hen, abangga ba nggo a si kpanye na ku mu hen a vɨ ba ku ila ure imbarr yi, nggo a si kpanye nu Uvuvurr a Abachi wa ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ibre amu i Abachi inggi i si di: Uru ku là ku Abachi ku u nga ni ingbingbru inggi, aba si kpanye na ku hen. Na ka na zha ibwu mu, nggo a so di na aseki amimi. ");
INSERT INTO ninNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Abi na umimi, aba yo kà uru ku là ku, na si ta nga ni ìlà yi hen mi, nggo a hi di i ta tsarr umimi ku nggo a so di na. ");
INSERT INTO ninNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Abangga ba nggo a ga anko a ina jiji wa, aba yo di nga nu uru ku là ku ni isisurr iyirr. Ìlà iru yi i tsarr di aseki ka nggo a so na ka, a zhi na Abachi ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nu ugo kuma, i Yesu na abiga ama ba a gru di ga anga ka Yahudiya ka a kuma ku so ndo na abiga ama ba na ku di zzu anishirr na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","I Yohana mi a di zzu anishirr ba meme nu Ayeno hinga nu Salimu, nggo amasirr a kri nabo kakami. Anishirr a di kuma nabo du Yohana ku di zzu ba na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(A na meme ni ivi yi nggo a nise vu Yohana ku ttu.) ");
INSERT INTO ninNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Abanu nu umi ku abiga bu Yohana ba a gru so ri anta ndo na anu Yahuda numa ni itu ingla ukpa i abiga yi. ");
INSERT INTO ninNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Na gru nga ni zhi Yohana di, “Unitsarr, du ùwà hi ugo nggo a nga nu ùwà ku nu unddu inyi ku Joda ku, uwanggo nggo ùwà da ure ni itu ima yi? Kye uwanggo à so zzu anishirr na amasirr, anishirr shishemi a so kuma na ku!” ");
INSERT INTO ninNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","I Yohana a ddu ba di, “Undurr sama nu ukyekye ku kpa inkindirr numa inggi yi nggo Abachi nggo à si nu ma na yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Imba ku atu amba, i wo nggo ingga da ki imba di, ‘Ingga yo i si su Kristi wa hen. Ingga si uni ssu anko mu ki ku.’ ");
INSERT INTO ninNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ni iga i ihru ayamba, uwanggo wa nggo à di gri ku ayamba wa, uwa yo à si akikye na ayamba wa. U ukpama wa à ta nyarr, nggo uwa se nu unto ku na wo ukorr umaku. Ima yo di ingga se ni inyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Inkpinkpye ima ti ita so hunhihun, ingga ta kaji jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Uwanggo nggo à nga zhi nu unkplassu uwa à yo mri anishirr ba we. Undurr wa nggo à zhi ni imimi a su unushirr ni imimi na di re ni itu i aseki ka imimi ka. Undurr wa nggo a nga zhi nu unkplassu a mri ba we. ");
INSERT INTO ninNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","À ko bre inkindirr yi nggo à hi na wo, undurr si kpanye ni inkindirr yi nggo a ko bre ba hen. ");
INSERT INTO ninNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Undurr wa nggo à ti kpanye nu ure umaku, undurr wama à tsarr di ure ku Abachi ku u su jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Undurr wa nggo Abachi à tu ma à ni bre ure umaku, Abachi à nu ma Izhi yi nggo i si wawami. ");
INSERT INTO ninNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Aki wa à kpanye nu Uzuma wa ku, na nu ma ukyekye na atu a aseki ka we. ");
INSERT INTO ninNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","U abangga ba nggo a kpanye nu Uvuvurr a Abachi wa a ta so sese. U abangga ba nggo a kà Uvuvurr a Abachi wa a si ta kpa iso sese hen. U unfu ku Abachi ku u so na atu ambarr wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yesu à hi di anu Farrisi ba a wo du uwa so zzu anishirr na amasirr, anishirr ba a so kuma na ku mri ni Yohana ku. ");
INSERT INTO ninNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Meme mi uwa si si Yesu nggo ku itu ima à ko zzu ba hen. A si abiga ama ba mu a so zzu ba. ");
INSERT INTO ninNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nggo Yesu a wo meme, na du anga ka Yahudiya ka na kakuma nu Galili. ");
INSERT INTO ninNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ni inkpu ima yi uwa ta ga anko wa ba nu Samarriya. ");
INSERT INTO ninNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Mre Yesu ku nggurr surr nu igbu a anu Samarriya wa nggo a yo ma di Sukarr, nggo a su ywhiywhirr mi ni ila yi nggo Yakubu a nu uzuma wa Isuhu na asese ka. ");
INSERT INTO ninNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Udduddu ku tsu amasirr i Yakubu yi i kri nabo. Nggo Yesu à zirr di na anko a ita wa na ni ji so nu ukotu ku udduddu ku, na azhi na atsutsu. ");
INSERT INTO ninNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","A sha so ntsɨmi, ayamba nu Samarriya numa gru nga nye tsu amasirr i Yesu à ddu ma di, “Bubomi tsu amasirr wa ni ingga so.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Abiga ma ba a mirri ko ire ila nu umi igbu ku, uwa so na nkpama). ");
INSERT INTO ninNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ayamba wa à ku ayisurr na zhi Yesu di, “Kye! Ùwà sa anu Yahuda mu, ingga sa ayamba nu Samarriya mu. Ùwà na kinggi ni so zhi ingga amasirr a iso?” (Anu Yahuda ba a di kpa anu Samarriya ba chirr.) ");
INSERT INTO ninNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","I Yesu à ddu ma di, “Ka du ùwà hi nggo Abachi à di ni anishirr inkindirr, ùwà ka zhi ingga ni di ingga nu ùwà amasirr a iso sese.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ayamba wa à ddu ma di, “Ankpye, ùwà sama ni izhizhi ka unga inkindirr ki itsu amasirr, i udduddu inggi yi ita kakami. Ùwà ta kpa amasirr a iso sese ama wa zhi nu momonggo? ");
INSERT INTO ninNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Meme mi, ùwà kye du ùwà nggo mri ábáchí amunta wa Yakubu nggo à ya ki inta udduddu inggi yi, na so amasirr na yi na amarr ma ba ni ilando ima yi?” ");
INSERT INTO ninNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu ddu ma di, “Anishirr ba nggo ti so amasirr ama wa uhre di ki ba zizo. ");
INSERT INTO ninNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Uwa ta sa amasirr wa nggo ingga di ni a di ka uhre ku glo ba mremremu. Amasirr ama wa ta kaki umblo nu umi umbarr ku, nggo a ta gri ba iso sese.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ayamba wa à da di, “Bubomi Ankpye, sha amasirr ama wa ni ingga! Nggo a si ta di ingga ki uhre zizo hen, ni si taka ni gba amasirr ni inggya zizo hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","I Yesu à ddu ayamba wa di, “Kuma ku yo urumi wa ni nga.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ayamba wa à da di, “Ingga sama nu unuru.” I Yesu ddu ma du, “Ùwà da ma di ùwà i sama nu unuru. ");
INSERT INTO ninNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ure ku nggo su di ùwà i garr ki aniru akywi ngga, uwanggo nggo ùwà so na ku mi à si su urumi hen. Ùwà da ki ingga ure ujiji.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ayamba wa da di, “Ankpye, ùwà su uni kpa are. ");
INSERT INTO ninNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ziza, da ki ingga, sa angginggi du imba anu Yahuda ba kri ngbangba di Urushalima nggo na nkpama su unto ku nggo anishirr a bu kuma ku barr Abachi ku? Akiki amunta anu Samarriya ba a da di a si ni igbre uwanggo mu nggo ábáchí munta ba a ku di barr.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","I Yesu da ku di, “Ayamba, kpanye ki ingga, ivi yi ko nga nggo imba si taka hun kuma ku barr Aki wa ni igbre, ka nu Urushalima zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Imba anu Samarriya ba hi ntsɨ ni itu yi undurr wa nggo imba ku di barr ma. Inta anu Yahuda ba hi ma kakami, nggo ikpa ttungo yi iba ni inta anu Yahuda ba yo ba. ");
INSERT INTO ninNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kye yi! Ivi yi ko nga ni i ka nga ba nggo abiga ajiji ba ta ga Abachi Aki amunta wa nu ukyekye ku Izhi i Abachi yi tuku nu nggo uwa à se jiji. Aki wa mi ko zha anishirr bama bu ga ma. ");
INSERT INTO ninNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Abachi su Izhi, abangga ba nggo ti ta ga ma i wre aba bu ga ma nu ukyekye ku Izhi i Abachi yi tuku nu nggo uwa à se jiji.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ayamba wa da di, “I ingga hi du Mezaya wa (nggo à yo ma du Kristi) à ko nga. Uwa ti nga, uwa taka ni bre ki inta aseki we.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","I Yesu da ku di, “À su uchichi ingga uwama yo ko re nu ùwà ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ntsɨmi ma yo u abiga ma ba a kanga, na ku ayisurr nu nggo a hi ma so re na ayamba ku. Uyirr mi nu umi umbarr ku à si zhi ayamba wa di, “Ùwà zha anggi?” hen. Uyirr mi à si zhi Yesu di, “Angginggi du ùwà so re na ayamba wa ku?” hen. ");
INSERT INTO ninNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nggo ayamba wa ka itsa itsu amasirr ama wa zu na kakuma ku da ku anishirr ba nu umi igbu ku di, ");
INSERT INTO ninNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Imba nga ni kye unushirr wa nggo wa à bre ki ingga inkindirr yi nggo ingga so di na yi tsatsarr. Hi du uwa yo ka su Kristi wa?” ");
INSERT INTO ninNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Mre, anishirr gru huzzu shishemi nu umi igbu ku ni kye Yesu. ");
INSERT INTO ninNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nu unto kuma mi u abiga ma ba so da ku di, “Ankpye, inta barr ùwà ri inkindirr manu!” ");
INSERT INTO ninNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Uwa da ba di, “Iya, ingga se ni ila yi nggo imba si hi yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Abiga ma ba a zhi ikpa ambarr di, “Unggonggo mu gri ga ku?” ");
INSERT INTO ninNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Mre, i Yesu gru da ba di, “Ila mungga inggi si ingga bi na undu ku uwama wa nggo a tu ingga, ni bu na ku kre. ");
INSERT INTO ninNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Imba si di da di, ‘A ji ihwa ine̱ yo aba bu rri ni na atu ikiri wa’ hen? Ingga nggo da ku ùwà, bwu ashishi ni kye izzuzzu yi ni kye nggo ikiri wri zha ihan! ");
INSERT INTO ninNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","A di han ku abu undu ba azadi ambarr ka wre, i ziza mi nggo ikiri yi nggo a so hwa i sa anishirr ba nggo a gri ba kuma ni iso sese. Wre ku undurr wa nggo a ttu, nu undurr wa nggo a hwa ssubi abi me̱ nyarr. ");
INSERT INTO ninNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","I ta si meme ida inggi yi i si jiji di, ‘Unuma mu ttu unuma mu ku hwa.’ ");
INSERT INTO ninNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ingga tu imba di imba bi ku hwa nu unto ku nggo imba si ttu hen. Abanu a ka na undu ku vri ukpa ku ba, imba nga ni hwa ido imbarr yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Anu Samarriya shishemi ni igbu wama a kpanye ni Yesu ku, nggo ayamba wa a da ba di, “A da ki ingga aseki ka nggo ingga so di na ka tsatsarr.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nggo anu Samarriya a nga ni hi ma na barr ma di a bu sha so ni igbu a ambarr wa bari. Uwa kpanye na sha so ki ivi iha. ");
INSERT INTO ninNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ni itu are ama ka, anishirr shishemi a kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Na ddu ayamba wa di, “Ziza nggo, inta mi kpanye nggo inta mi ku wo ma na atu munta, na si si ki ida muwa yi mu hen. Inta hi jiji du uwa yo su Uni kpa ttungo ni ingbingbru wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nu uha wa i Yesu gru kuma nu Galili. ");
INSERT INTO ninNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Nâ ta si nggo Yesu di da di, “A si di kye uni kpa are ssu nu ungo ni ìgbù ama hen.”) ");
INSERT INTO ninNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Anu Galili ba kpa ma na ango aha, nggo aba mi a se nu Urushalima nggo a na Iga i Ivu Sarr yi na hi ma ni na aseki ka ikagri ka. ");
INSERT INTO ninNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nu umi ku uzirr kuma nggo a ba nu Galili na rri nu igbu nu Kena, nggo a ka amasirr wa ki ahi. Ankpye numa ni iko i uttu à se na ba, nggo uzuma wa nggo so nu Kapanahu à vri kakami. ");
INSERT INTO ninNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nggo à wo di Yesu à nga zhi nu Yahudiya na so zirr nu Galili, uwa kuma ku zha Yesu hi na tsi ku angu di a bu ga ma kuma nu Kapanahu ku du uzuma wa wre, nggo uvuvurr wa ki ywhiywhirr i ttu. ");
INSERT INTO ninNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu zhi ma di, “Ingga ti na inkindirr ikagri bari imba ta kpanye ni ingga?” ");
INSERT INTO ninNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ugo wa barr di, “Ankpye, bubomi ga mi ku du uvuvurr wa tasi ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","I Yesu da ku ugo wa di, “Kakuma ni iko, uzumi wa ta wre ku uwa.” Ugo wa kpanye ni Yesu ku na so kakuma ni iko. ");
INSERT INTO ninNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nggo ugo wa se na anko a ikuma wa na zzu ma na amirr iko ama banu ba, aba da ku du uvuvurr wa wre ni ivri ima yi ba. ");
INSERT INTO ninNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ugo wa zhi ba attuttu wa nggo uvuvurr wa wre nggo. Aba da ku di, “Uvuvurr wa na wre nare, ni iyirr i azhi na atsutsu.” ");
INSERT INTO ninNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","U aki wa hi du uwama yo sa attuttu wa nggo Yesu na da ku du, “Uzumi wa ta wre nggo.” Ima yo du ugo wa na anishirr bi iko ima ba a kpanye ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Uwama yo si inkindirr i ikagri i iha nggo Yesu a na nu Galili nu ugo ki ikanga umaku zhi nu Yahudiya. ");
INSERT INTO ninNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nu ugo ku aseki kama ka, Yesu à gru kuma na ba ni iga i ani Yahuda numa nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nu Urushalima i izzo amasirr inuma à yo yi di Betizata ni irrirri i Ibraniya, i se na anko akywi. Izzo amasirr ima yi i se hinga na anko wa nggo a yo wa du Amunko ka Aminta. ");
INSERT INTO ninNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nu unddu ku, abi lolo na nkanka a kurr kago amasirr wa na anko ka akywi mi, abanu sa aba kreshi abi gbo na ampi na abangga ba nggo ukpa ku u ttu.  ");
INSERT INTO ninNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nggo unitu a Abachi wa nu unkplassu ti ji ni rru amasirr wa ni ivi numa, undurr wa nggo ti rri na amasirr wa kuchi, uwa di wre ni ivri ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ugo numa nggo di kurr nabo, ivri ima yi i ki ase iso itarr na atandarr (38). ");
INSERT INTO ninNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nggo Yesu hi ma ni ikurr yi na hi du ugo wa a di vri zhi ngbangbamu na zhi ma di, “Uwa zha du uwa ta wre?” ");
INSERT INTO ninNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ugo uni vri wa ddu ma di, “Ankpye, ingga sama nu undurr wa nggo à ta ba ingga yo na amasirr wa, nggo a ti nga ni zzu amasirr wa. Nggo ingga ti ta ko mirri, unuma di rri kuchi ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","I Yesu ddu ma di, “Gru kri ki kri, ni ba abubo a ikurr muwa wa ni zirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ugo wa wre ni inkpo iyirr na ba abubo a ikurr ama wa na zirr kuma. Azhibarr wa nggo Yesu a na undu ku a si na Azhibarr a Isu a anu Yahuda wa. ");
INSERT INTO ninNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nggo ankpinkpye ba anu Yahuda ba a hi ugo wa ni ba abubo a ikurr wa na ko kuma, na ddu ma di, “Ari sa Azhibarr a Isu, uwa kpala ku Are ka Musa ka nu nggo uwa ba abubo a ikurr muwa wa ni zirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Uwa ddu ba di, “Ugo wa nggo di ingga wre, uwa yo da ki ingga meme di ingga bi ba abubo a ikurr mungga wa ni kuma.” ");
INSERT INTO ninNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Aba zhi ma di, “A su unggonggo uwama nggo da ku uwa du uwa bi ba abubo a ikurr wa ni kuma?” ");
INSERT INTO ninNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ugo wa mi si hi Yesu hen, nggo anishirr ba a kri kakami nu unto ku, i Yesu a mirri nado nu umi ku anishirr ku. ");
INSERT INTO ninNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nggo Yesu ku zha ugo wa hi nu Uki Unkpi ku Ibarr Abachi ku, na ddu ma di, “Kye ùwà wre ba. Ùwà bu du ila ure du, ku inkindirr numa indanda mri inggi yi si taka la nu ùwà ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ugo wa nggo Yesu du ma wre nggo à kakuma ku da ku anu Yahuda ba da a si Yesu yo du uwa wre. ");
INSERT INTO ninNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nggo Yesu a ko du anishirr ba wre na Azhibarr a Isu a Anu Yahuda wa aba gru so zha are na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","I Yesu ddu ba di, “Aki mungga wa nise kukri nu undu ku umaku, ima yo di ingga mi so na undu ku tsi kuma meme.” ");
INSERT INTO ninNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Meme nggo anu Yahuda ba kuchi ni zha anko a ingu ma wa, na da di, à kpala na are aha. Uku me̱me̱ ku u si di à ko na undu na Azhibarr a Isu wa. Uku uha ku nggo su nggo à da di Abachi nggo su ku Aki, na ko tsarr itu ima kye na Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nggo i Yesu ddu ba di, “Di ingga da ki imba, wanggo su ure ujiji mu du Uvuvurr a Abachi wa sama nu ukyekye ki na inkindirr numa ki itu ima sama ni ihi i Aki yi. A di nâ ta si inkindirr yi nggo a hi Aki wa ni ina yi na so na yi narrnarr, nâ ta si nggo aki wa di na. ");
INSERT INTO ninNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Aki wa a kpanye nu Uzuma wa na tsarr ma aseki ka nggo a na ka we. Aki wa ta tsarr ma aseki numa mri meme, nggo a ta di imba ku ayisurr. ");
INSERT INTO ninNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nâ ta si Aki wa di du abi kɨ ba tasi na ka ni so tsitsirr, na anko ayiyirr ama wa Uvuvurr wa mi ta gri iso sese nga ku undurr wa nggo à kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Aki wa si di bre amu ni itu i undurr hen, nggo na na uzuma wanggo ki uni bre amu wa na atu anishirr we. ");
INSERT INTO ninNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aki wa zha da anishirr bi kru isisu i Uvuvurr yi nâ ta si nggo a di kru isisu ima yi. Undurr wa nggo ti kpa Uvuvurr wa chirr, ina ima yi tsarr da a si kru isisu i Aki wa nggo tu ma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ingga nggo ko da ki imba, undurr wa nggo ti wo ure mungga ku na kpanye nu uwanggo nggo tu ingga nggo. Uwa se ni iso sese, Abachi si ta vɨ ba ni ila ure hen. Na a ka ya ge̱ ittu ba. ");
INSERT INTO ninNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ingga ko da ki imba ure ujiji mu, ivi yi ko nga ni i ka nga ba, nggo abi kɨ ba ta wo ukorr ku Uvuvurr a Abachi ku, u abangga ba nggo ti shirr ku atu ta so. ");
INSERT INTO ninNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Aki wa se nu ukyekye ki gri iso sese na nu Uzuma wa ukyekye kuma meme. ");
INSERT INTO ninNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Na nu Uzuma ukyekye ki ibre amu na atu anishirr we, nu nggo uwa yo su Uvuvurr a Unushirr. ");
INSERT INTO ninNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Imba bu si ku ayisurr hen, vure ivi yi ko nga nggo abi kɨ ba na abe ta wo ukorr umaku, ");
INSERT INTO ninNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","mre na ta gru huzzu na abe ambarr ka. Abangga ba nggo a di so wre taka ni so sese, u agbugbu ta tasi ni ma ki ibre amu. ");
INSERT INTO ninNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ingga ka si na inkindirr ki itu mungga hen. Aki mungga nggo à tu ingga, nâ ta si uwa yo tsarr ingga nggo ingga ta di bre amu ka nggo. Ingga di bre amu amungga ka narrnarr, nggo ingga kru isisu ima yi, ni si so na inkindirr yi nggo ta su ki ingga nggo isisurr hen. Ingga ko na nâ ta si nggo Aki amungga wa à da. ");
INSERT INTO ninNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Ka di ingga ko re si ki itu mungga, ingga ka sa na anko a itsarr imba du ure mungga ku u su ujiji. ");
INSERT INTO ninNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","U undurr numa se nggo di kpa re ki ingga. Ingga hi da a di da ure ujiji. ");
INSERT INTO ninNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Imba tu anishirr du ba kuma ni Yohana ku, uwa ko ku da ba ure ujiji. ");
INSERT INTO ninNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ingga si ba ki inkindirr, inkindirr yi nggo anishirr di da ni itu mungga ki inkindirr hen. Ingga ko bre ki imba are angga ka, wre ki imba bu kpa ikpa ttungo. ");
INSERT INTO ninNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohana yo à si ingba nu uru wa nggo a la kago, imba mi nyarr ni ila ima yi ki ivi ntsɨmi. ");
INSERT INTO ninNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Inkindirr numa se nggo mri inggi nggo Yohana a da ni itu mungga nggo. Ingga ko na aseki ka nggo Aki mungga wa ni ingga di ingga bu ni na ka nggo. Aseki akama yo ko kpa re ki ingga na tsarr da Aki wa yo tu ingga jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aki wa nggo tu ingga à tsarr imba du uwa nggo tu ingga jiji, ka nu nggo imba nise wo ukorr umaku ni si hi ma ashishi na ashishi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Imba si kpanye nu ure umaku hen, nggo imba si kpanye nu undurr wa nggo a tu ma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Imba bre Ungbamvu ku Abachi ku ni kye di imba ta hi iso sese nu umi umaku. Ungbamvu ku Abachi kuma yo so re si ni itu mungga yo! ");
INSERT INTO ninNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Nggo imba kà ni si nga ni kpa iso sese yi ni ingga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ingga si ko zha igbyarr asa na anishirr ba hen. ");
INSERT INTO ninNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nggo ingga hi imba, ni hi di imba sama ni ikpanye i Abachi yi ni isisurr imba. ");
INSERT INTO ninNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Aki mungga wa yo tu ingga nu ure umaku di ingga bu nga ni bre ku anishirr. Imba ni kà ingga, ni ta kpa abangga ba nggo ta nga ni so re ka atu ambarr. ");
INSERT INTO ninNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Imba ta na kingginggi ni kpanye nu ure ku Abachi ku, nggo imba so di zha igbyarr asa na anishirr ba, ni si ri amarr ka igbyarr asa yi nggo i zhi na Abachi ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Imba bu si kye di ingga nggo taka gri imba ku bre ku Abachi hen, nggo imba yo isisurr imba yi nu Musa ku uwa yo taka gri imba ko ku bre. ");
INSERT INTO ninNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musa à charr ni itu mungga, imba ka ti kpanye nu Musa ku, imba ka kpanye ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Imba ta si kpanye ni inkindirr yi nggo Musa à charr hen, imba ta na kingginggi ni kpanye ni ida mungga yi?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nu ugo ku nggo Yesu na aseki ka kre na gru cha kuma nu ugugarr inyi numa ku Galili ku (nggo à yo ku du inyi nu Tiberriya). ");
INSERT INTO ninNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Akpa anishirr a ddu na kuma na ku, nggo a hi aseki ka ikagri ka nggo a hi Yesu ni so na yi, nggo a so du anishirr wre ni ilolo imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","I Yesu na abiga ma ba gru hun kuma ni itu i igbre wa ku ji so nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ni ivi ima yi nggo Iga i Ivu Sarr i anu Yahuda yi ki ywhiywhirr. ");
INSERT INTO ninNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nggo Yesu kakye na hi akpa anishirr ni so nga na ku, na ddu Filibu di, “Inta ka re ila nu momonggo, nggo ta ma ku anishirr angga ba iri?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(I Yesu à da meme so tsarr Filibu kye mu. Na ka hi inkindirr yi nggo uwa ta na ba). ");
INSERT INTO ninNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","I Filibu a ddu ma di, “Inta ka na undu ma ihwa itandarr mu bari, anishirr angga ba ka kpa inkindirr ntsɨ la kye na yiyirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","U uyirr nu umi ku abiga ma ku, nggo a yo ma du Andoro nggo a su uzayirr a Sima Biturr wa da di, ");
INSERT INTO ninNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kye uvuvurr numa nggo gri ankpinkpri unfonfo akywi ni ikikla iha. Uwama mi ta ma ku anishirr ba angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu da ku abiga ma ba di a bu du anishirr ba ji so. (Agiga assussu a se kakami na abubo wa.) U anishirr ba we ji so nabo. Aniru ba nggo a se nabo a su ukrɨ ukywi (5,000). ");
INSERT INTO ninNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mre i Yesu ba unfonfo wa, na nyarr ku Abachi ni itu ima yi na ka nu anishirr ba nggo a so nabo, na ba ikikla yi mi na na meme yo. U anishirr ba a kpa ga ba, aba kpa ri na shi. ");
INSERT INTO ninNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nggo a ta shi na ka, uwa ddu abiga ma ba da a bu ga na vu imbimbru yi nggurr bi, wre ba si varr yi hre hen. ");
INSERT INTO ninNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Aba ga na vu imbimbru i unfonfo yi ki isisa iwurr ni iha nggo a ri shi na kadu. ");
INSERT INTO ninNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nggo anishirr ba a hi ikagri ima yi nggo Yesu a na yi nggo, na da di, “Uwa yo ta su uni kpa are wa jiji nggo Abachi à da da à taka nga ni ingbingbru yi!” ");
INSERT INTO ninNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nggo Yesu hi amarr ka nggo anishirr ba ko ri, da aba ta vu ma nu ungbrengbre ku na ma ki uttu ambarr wa, na gru hun kuma na agbre ka na ankpa ma. ");
INSERT INTO ninNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ni ingbahru ima yi, abiga ba Yesu ba a gru ji kuma nu unddu ki inyi nu Galili wa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nggo abubo wa ko shi ibwu, i Yesu nise kanga na ba, abiga ma ba kye na rri nu uddu ku na gru ta cha kuma nu Kapanahu. ");
INSERT INTO ninNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Nggo a se nu umi ku icha ku, mre u unddunddu numa gru go kyekye mi, na du ankinkirr ka amasirr ka gru ko gru kakami. ");
INSERT INTO ninNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nggo abiga ma ba a ka zirr ma kilomita ikywi ka itani kuma ni imimi mu ba, na hi Yesu ko zirr na atu ka amasirr ka na ko ga ba ywhiywhirr nu uddu ku, isisu ki ba aba wri kpakpa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","I Yesu ddu ba di, “A si ingga yo! Imba bi si kru isisu hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Abiga ma ba a nyarr na du ma rri nu uddu ku, mre aba kukri nu unddu ku amasirr ku nu unto ku nggo a ko kuma wa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nu uha wa, anishirr ba nggo di so nu ugarr ku inyi ku a hi du uddu ku u su uyirr yo nggo u kri nabo. Na hi nu nggo abiga ma ba gru, i Yesu sama nu uddu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Iddu numa i nga zhi na anga ka Tiberriya ni kukri ywhiywhirr mi nu unto ku nggo Yesu a nu ba iri yi. ");
INSERT INTO ninNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na ku hi di Yesu na abiga ma ba a kakuma ba, nggo aba ka rri ni iddu imbarr yi na darr kuma na anga ka Kapanahu kaku zha Yesu nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nggo anishirr ba a kuma ku zha Yesu hi nu ugugarr ki inyi ku, na zhi ma di, “Ankpye, uwa nga inggya nita mu?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","I Yesu ddu ba di, “Ingga di imba si so zha ingga ni itu i iki i ikagri yi nggo ingga na hen. Imba di zha ingga nu nggo imba ri shi mu. ");
INSERT INTO ninNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Imba bi si tsutsarr itu imba ki ila yi nggo i di na i ki ndanda hen, imba bi na undu zha ila yi nggo di gri iso sese. Uvuvurr a Unushirr yo ta ni imba ila ima yi, ni itu yi nggo Aki ama wa Abachi nggo kpanye ku da a bu na meme.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Anishirr ba a zhi ma di, “Abachi zha di inta bu na sa angginggi mremremu?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu ddu ba di, “Abachi zha di imba bi yo isisurr imba nu uwanggo wa nggo uwa tu ma.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Aba zhi ma di, “Uwa ta na si ikagri i ta inggi nggo inta ta hi ni bu kpanye nu uwa ku? ");
INSERT INTO ninNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kye nu nggo ábáchí munta ba di zirr ni ijiji yi, Abachi a nu ba unfonfo zhi nu ussu nggo a yo ma du mana, du ba ri. I su meme nâ ta si nggo a charr nu Ungbamvu ku Abachi ku di, ‘Abachi a nu ba unfonfo zhi nu unkplassu du ba a ri.’ ” ");
INSERT INTO ninNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","I Yesu ddu ba di, “Ingga da ki imba ure ujiji, unfonfo wa nggo Musa à ni imba, uwa yo a si su unfonfo ujiji zhi nu unkplassu ku hen. A su Aki mungga nggo à di ni imba unfonfo ujiji wa zhi nu ussu. ");
INSERT INTO ninNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Unfonfo wa nggo Abachi ni, uwa yo ji zhi nu unkplassu ni di gri iso tsitsirr ki ingbingbru yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Aba ddu ma di, “Ankpye, di ni inta unfonfo wama ttuttumi.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","I Yesu ddu ba di, “Ingga yo su unfonfo ni gri iso sese wa. Undurr wa nggo ti nga ni ingga ku i iyo i si ta ki zizo ma hen. Undurr wa nggo ti yo isisurr ni ingga ku u uhre si ta ki ma zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ingga ka da ki imba ba di, imba hi ingga ni kà iyo isisurr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Undurr wa nggo Aki mungga wa ti ni ingga, uwa ta nga ni ingga ku, u undurr wa nggo ti nga ni ingga ku i ingga si ta han ma share hen. ");
INSERT INTO ninNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ingga si ji zhi nu unkplassu di ingga i ta ni na inkindirr inggi nggo isisurr mungga nggi ikpanye hen. Ingga nye na inkindirr yi nggo Abachi wa nggo tu ingga à zha. ");
INSERT INTO ninNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Uwanggo yo si ina i Abachi yi, di ingga bu si du uyirr nu umi ku anishirr ba nggo à ni ingga na ba a nado hen. À di ingga bu ka ba si na azhibarr a ikikre wa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Abangga ba nggo a ti surr ashishi nu Uvuvurr a Abachi wa na yo isisurr na ku a ta kpa iso sese. Ingga ta ta ba si na azhibarr a ikikre wa. Wanggo yo si inkindirr yi nggo aki mungga wa à zha.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Anishirr ba gru so re ngbungbru nu nggo Yesu da ba di, “Ingga yo su unfonfo wa nggo à ji zhi nu unkplassu.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Na gru so zhi ikpa di, “Uwanggo si si Yesu, Uvuvurr a Isuhu hen? A kye di inta si hi aki ama wa na ayirr wa hen? Na na kingginggi na ko da du uwa ji zhi nu unkplassu?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","I Yesu kakye ba na ddu ba di, “Imba du ire ngbungbru ni ikpa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Undurr ka si gru nga ni ingga ku ki itu ima, na si si Aki mungga nggo yo ma hen. Aki mungga wama yo tu ingga, na turr ma nga. Ingga ta tà ma si na azhibarr a ikikre wa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Uyirr nu umi ku abi kpa are ba a charr di: ‘Abachi nggo ki itu ima ta tsarr ba.’ U unushirr wa nggo ti shirr ku Aki wa atu na kpa itsarr ima yi na undu, uwa ta nga ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Undurr wa nggo zhi na Abachi ku, uwa yo hi Aki wa na nkpama. Undurr numa si hi ma zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Di ingga da ki imba ure ujiji, unushirr wa nggo ti yo isisurr ima yi ni ingga ku uwa se ni iso sese. ");
INSERT INTO ninNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ingga yo su unfonfo wa nggo di gri iso tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ábáchí amba ba a ri mana wa ni ijiji yi, meme mi na kɨ. ");
INSERT INTO ninNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kye unfonfo ni gri iso wa nggo ji zhi nu unkplassu, undurr wa nggo ti ta ma, uwa si taka ttu zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ingga yo su unfonfo ni so sese wa nggo ji zhi nu unkplassu. Unushirr wa nggo ti ta unfonfo wama uwa ta so sese. Inina imungga yi iyo su unfonfo wa nggo ingga ta ni, wre ku anishirr ba ingbingbru ba bi kpa iso tsitsirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ankpinkpye ba anu Yahuda gru so ri anta kakami ni ikpa na gru so zhi ikpa di, “À ta na kingginggi na ta ni inta inina ikpa ima yi di inta ta?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","I Yesu ddu ba di, “Ingga da ki imba ure ujiji, imba ta si ta inina ikpa ni si so ayiyi a Uvuvurr a Unushirr hen, imba ta sa ni iso tsitsirr nu umi umba. ");
INSERT INTO ninNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Abangga ba nggo ti ta inina ikpa imungga yi na so ayiyi amungga aba ta kpa iso sese. Ingga taka tà ba si na azhibarr a ikre ungo wa. ");
INSERT INTO ninNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Inina ikpa mungga iyo si ila iri ijiji yi u ayiyi mungga a yo si inkindirr ijiji yi nggo di gri iso tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Abangga ba nggo ta inina mungga yi na so ayiyi mungga wa a so nu umi mungga, ingga mi so nu umi umbarr ku meme. ");
INSERT INTO ninNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Abachi nggo tu ingga, ingga so nâ ta si nggo Abachi à se meme, undurr wa nggo ti ta inina ikpa imungga yi uwa ta so nâ ta si nggo ingga mi so. ");
INSERT INTO ninNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ingga si se nâ ta si unfonfo wa nggo ábáchí ambirr ba a ta nggo hen. A ta unfonfo wama wa na kɨ. Ingga yo su unfonfo wa nggo à ji zhi nu unkplassu. Undurr wa nggo ti ta unfonfo wama uwa ta so sese.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu a bre ba are kama nggo a ko tsarr ba nu uki ki issubi ku nu Kapanahu. ");
INSERT INTO ninNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nggo abiga ma ba shishemi a wo ure kuma, abanu ba a da di, “Itsarr inggi yi i tsɨ ki inta unggonggo ka kpa yi?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nggo Yesu hi da abiga ma ba a se ni ivri ni itu itsarr ima yi, i na zhi ba di, “Itsarr inggi i du iyo isisurr imba yi kako nu ugo? ");
INSERT INTO ninNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","U nu nggo imba ti ka hi Uvuvurr a Unushirr ni ko hun kuma nu unkplassu unto ku nggo à zhi na? ");
INSERT INTO ninNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A si Izhi iyo di gri iso tsitsirr. Inina ikpa si di gri iso tsitsirr hen. Are ka nggo ingga bre ki imba sa are ka Izhi, na di gri iso tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","U abanu nu umi umba ku si yo isisurr ni ingga ku hen.” (Nggo Yesu ka hi abangga ba nggo a kà iyo isisurr zhi ni ime̱me̱ mu ba, na hi uwanggo wa nggo taka ni vu ma re nggo.) ");
INSERT INTO ninNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Nggo Yesu da ba di, “Imba sama nu ukyekye ki nga ni ingga ku sama na Aki mungga nggo ni turr imba nga yi. Ima yo di ingga bre ki imba are angga ka we.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ni itu i inkindirr yi nggo Yesu a bre ba u abiga ma ba shishemi a kà iga ma yi na kakuma nu ugo. ");
INSERT INTO ninNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","I Yesu zhi abiga ma ba di, “Imba mi ta kuma meme?” ");
INSERT INTO ninNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","I Sima Biturr ddu ma di, “Atiko, inta ta kuma nu unggonggo ku? Ùwà yo se nu ure ki iso sese ku. ");
INSERT INTO ninNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Inta kpanye ni hi du ùwà yo su Uni wre wa nggo zhi na Abachi ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","I Yesu ddu ba di, “Ingga yo hla imba awurr na aha mi, u uyirr wa nu umi umba ku à su a Isheta umimi wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I Yesu à ko re ni itu i Judasi, uvuvurr a Sima Iskariyoti wa yo, nu nggo Judasi a su uyirr nu umi ku abiga ma ba, uwa yo su uwanggo wa nggo taka ni vu ma re ba. ");
INSERT INTO ninNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nu ugo ki na aseki ka angga ka, i Yesu gru di zirr kago na anga ka Galili ka, na si zirr na anga ka Yahudiya ka hen, nggo a hi da ankpinkpye ba Yahuda ba ko zha anko a ingu ma. ");
INSERT INTO ninNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Uwa si ni ivi yi nggo anu Yahuda ba ta na Iga i Aburr imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nggo amuyirr bi Yesu ba nga ni da ku di, “Gru kuma na anga ka Yahudiya ka ku na aseki ka ikagri angga ka ni du abiga muwa ba nabo mi hi. ");
INSERT INTO ninNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Unushirr wa nggo ti zha du uwa ta zzu isa, uwa si di kà ina ima yi sharri hen. Ku na aseki ka angga ka ni di ingbingbru i hi uwa!” ");
INSERT INTO ninNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ima tsarr da amuyirr bi Yesu ba mi a si kpanye na ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","I Yesu ddu amuyirr ba di, “Azhibarr mungga wa nise nga, uwa ta si imba azhi wa sa a imba namri. ");
INSERT INTO ninNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ingbingbru yi ka si karr imba hen, i karr ingga nu nggo ingga da ba ila ure imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Imba bi kuma na abubo a iga wa ingga nise bari, attuttu mungga wa nise.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu bre ba are kama na so nu Galili. ");
INSERT INTO ninNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Amuyirr bi Yesu ba a kuma ni iga yi, i Yesu mi gru ga ba nu ugo, na ku so sharri na si du anishirr ba hi ma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ankpinkpye ba anu Yahuda ba ko ku so zha ma na abubo a iga wa di, “Ugo nggo wa à ba momonggo?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Anishirr ba nggo a kri na abubo a iga wa, a gru so re ni ikpa di, “Ugo nggo su unushirr uzizi.” Abanu ba da di, “A si si meme hen, à bri ku anishirr ashishi mu.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Unushirr ni isisurr sama nggo ta gru kri na da inkindirr kyekye mi ni itu i Yesu, nggo a so kru isisu i ankpinkpye anu Yahuda ba. ");
INSERT INTO ninNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nggo à se na atsutsu ka ivi Iga i Aburr yi Yesu gru kuma ku so tsarr nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","U anu Yahuda ba gru so vu angu na da di, “Ugo nggo nise kuma na abubo a ku ibre kye, na na kingginggi na hi ungbamvu ku ma mi?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I Yesu ddu ba di, “Aseki ka nggo ingga ko tsarr si sa amungga hen, a nga zhi nu uwanggo a tu ingga mu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Anishirr ba nggo ti zha ina inkindirr yi nggo Abachi a da ba, aba ta hi di itsarr mungga yi i zhi na Abachi ku, ka i si imungga. ");
INSERT INTO ninNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Undurr wa nggo di tsarr ihi ima yi, à so di zha si inkpinkpye ima mu, u undurr wa nggo so zha inkpinkpye i uwanggo nggo à tu ma nggo, à so da su ure ujiji na si ki imu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","U Musa à ni imba are ka, a si si meme hen? U uyirr amba mi si kru isisu imbarr yi hen. A sa angginggi du imba so zha anko a ingu ingga?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Anishirr ba ddu ma di, “Ùwà se na anazhi ndanda nggo a mirri ku ùwà. Angginggi du ùwà kye da anishirr ta ngu ùwà?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","I Yesu da ba di, “Ingga na inkindirr i ikagri iyirr yo imba kukri vu angu. ");
INSERT INTO ninNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","U Musa a da ki imba ure ki isarr iji. (Na si su Musa nggo a ni imba isarr iji yi hen. Ure kuma u zhi na ábáchí amburr ba.) Meme yo imba di sarr ku amumarr amba ba iji na Azhibarr a Isu wa mi kye. ");
INSERT INTO ninNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Imba ta di sarr ku amumarr amba ba iji na Azhibarr a Isu wa nâ ta si Are ka Musa a da, uwa sa anggi mu di imba so ki unfu ni ingga ku di ingga du unushirr wa pempe mi a wre na Azhibarr a Isu wa? ");
INSERT INTO ninNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Imba bu si di kye aseki nâ ta si nggo a na ka hen, imba bu di kye aseki ka nâ ta si nggo a se.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Inkpu anishirr ba nggo so nu Urushalima a da di, “Uwanggo yo à si su ugo wa nggo a ko zha anko ta ngu ma hen? ");
INSERT INTO ninNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kye ma ko tsarr nu unto ku nggo anishirr ka kye ma hi na wo ma krizhizhi mi, undurr mi à si ko ku gye ku angu hen. Imba kye da ankpinkpye ba kpanye du uwa yo su Kristi wa jiji? ");
INSERT INTO ninNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Uwa ta si inta, inta hi unto ku nggo ugo nggo a zhi. Nggo Kristi ujiji wa kanga, undurr si ta hi unto ku nggo à zhi hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nggo Yesu à ko tsarr ni Uki Unkpi ku Ibarr Abachi ku à du hantu di, “Yo! Ingga hi di imba hi ingga, ni hi unto ku nggo ingga zhi. I Ingga si nga ki itu mungga mu hen, a su uwanggo wa nggo su ujiji wa yo, nggo imba si hi ma hen, uwa yo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Uwa ta si ingga, ingga zhi nu uwa yo ku nggo à tu ingga nggo. Ima yo di ingga hi ma.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nggo Yesu da meme, u anishirr ba gru horrhorr da aba ta vu ma, u nu nggo ivi i ivu ma i nise ma, unushirr uyirr mi si sa ungo na ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","I inkpu anishirr shishemi a kpanye na ku na kpa ure umaku. Na da di, “Kristi wa ti nga, uwa ta ni na aseki ka ikagri numa mri ka ngga ka nggo ugo nggo so na?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nggo anu Farrisi ba a wo anishirr ni so bre are ni itu i Yesu. U ankpinkpye abikye ba ndo na anu Farrisi ba a tu abi gbye iko i Abachi ba di a bu ku vu ma nga. ");
INSERT INTO ninNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","I Yesu da ba di, “Ingga ta so ni imba ntsɨmi ni ta kakuma nu uwanggo wa nggo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Imba ta zha ingga ni si ta hi ingga hen, ni si hi anko a inga nu unto ku nggo ingga se hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ankpinkpye ba anu Yahuda ba a re ni ikpa di, “Ugo nggo ta ko nu momonggo nggo inta si ta zha ma hi hen. A bu ta ko ni igbu i anu Girrki yi nggo anishirr munta ba a so na ta ku tsarr anu Girrki ba nabo yi? ");
INSERT INTO ninNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","À da di, ‘Imba ta zha ingga ni si ta hi ingga hen,’ tuku nu nggo à da di, ‘Imba si ta hi anko a inga nu unto ku nggo ingga se hen.’ A da uwama à sa angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na azhibarr a ikikre a iga wa nggo a yo sa azhibarr ankpi wa, i Yesu gru kri na du hantu di, “Undurr wa nggo uhre ti ki ma, bu nga ni ingga ku ni so. ");
INSERT INTO ninNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Undurr wa nggo ti kpanye ni ingga ku, amasirr wa nggo a ta du unushirr so tsitsirr a ta gu zhi nu umi umaku, nâ ta si nggo ungbamvu ku u da.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu à ko re ni itu i Izhi Iwre iyo. A nise ni Izhi i Iwre yi, nggo Yesu nise tasi kuma ni inkpinkpye ima yi. Nu ugo ku nggo a ta Yesu si ni ibe yi, abangga ba nggo ti kpanye na ku ta kpa Izhi yi. ");
INSERT INTO ninNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Inkpu anishirr ba nggo a kri nabo na so wo Yesu ni re yi a da di, “Ugo nggo su uni kpa are ajiji wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Abanu ba a da di, “Uwa yo su Kristi wa!” Meme mi abanu ba a da di, “Kristi wa si ta nga zhi nu Galili nggo hen! ");
INSERT INTO ninNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ungbamvu ku u da du Kristi wa ta nga zhi nu uga ku Doda zhi nu Betalami, ni igbu wa nggo Doda a so.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","I iri anta gru ku anishirr ba nabo ni itu i Yesu. ");
INSERT INTO ninNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Abanu zha da aba ta vu ma, u unushirr uyirr mi si sa ungo na ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Abi gbye iko i Abachi ba a kakuma ku da ku ankpinkpye abikye ba na anu Farrisi ba, aba a ka zhi ba di, “Anggi mu di imba si vu Yesu gri nga ni inggya hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Abi gbye ba da di, “Inta nise wo undurr ni re meme kye!” ");
INSERT INTO ninNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Anu Farrisi ba zhi ba di, “Meme nggo Yesu wa à re imba meme? ");
INSERT INTO ninNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Imba hi uyirr nu umi ku ankpinkpye ba ka anu Farrisi ba a kpanye na ku? ");
INSERT INTO ninNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Anishirr ba nggo si hi inkindirr na are ka Abachi ka hen, a sa abu uje!” ");
INSERT INTO ninNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Uyirr nu umi ku anu Farrisi ba nggo à yo ma du Nikodemu, à se nu umi umbarr ku. Uwa yiyirr wama yo à kuma ni Yesu ku. À da di, ");
INSERT INTO ninNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Iba munta si di vu unushirr ni ìlà sama ni iwo ma bari hen, ka hi inkindirr indanda nggo a na bari.” ");
INSERT INTO ninNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Aba zhi ma di, “Ùwà mi zhi nu Galili wa mu meme? Ka ku ji so ni bre angbamvu ka kye, ùwà ta hi di uni kpa are à si ta kanga zhi nu Galili hen.”  ");
INSERT INTO ninNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Anishirr ba ga kuma ni iko. ");
INSERT INTO ninNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu à hun kuma ni Igbre nu Olivu wa. ");
INSERT INTO ninNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Na kaji kuma nu Uki Unkpi ku Ibarr Abachi ku ni igambre. Anishirr bi na nga na ku uwa ji so na ko tsarr ba. ");
INSERT INTO ninNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","U abitsarr na are ba na anu Farrisi banu a gri ayamba numa nggo a vu wa a ko kurr ìga tuku ugo numa nggo a si su ku uruma hen. Aba gba wa gri na kuma ku kri na anke̱ ka anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Na ko ku ddu Yesu di, “Unitsarr, inta vu ayamba anggo aba so kurr ìga tuku unuru numa. ");
INSERT INTO ninNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Are ka Musa ka tsarr di inta bu ta ayamba wa nggo inta ti vu wa ko na meme ngu na angbinta. Uwa na, ùwà da da anggi?” ");
INSERT INTO ninNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Na ko zhi meme, wre ba bu tirr Yesu kye. A zha di aba ta wo inkindirr indanda na ku, na ka vu ma. I Yesu ji kuklo na gru ko charr ni imimi ni uvuvurr ungo. ");
INSERT INTO ninNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nggo a ka na ko zhi ma ure kuma uwa gɨ itu na zhi ba di, “Imba wemi, Unushirr wa nggo ta nise la ure kye, uwa yo bu tarr ayamba wa kuchi.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Na ji kuklo zizo na ko charr ni imimi yi. ");
INSERT INTO ninNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Anishirr ba nggo a kri nabo na wo Yesu, a gru so ga share na yiyirr, zhi na akikre ba kuma ni inkpu yi ku, na du Yesu yo nabo tuku ayamba wa. ");
INSERT INTO ninNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nggo Yesu gɨ itu na zhi ma di, “Ayamba, anishirr ba na? Uyirr mi si da du uwa vu ùwà ni ila ure hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A ayamba wa da di, “Uyirr mi sama, Ankpye.” I Yesu ddu ma di, “Ingga mi si vu ùwà ni ikpala imuwa yi hen. Kuma, ni si ka la ure zizo hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nu ugo kuma, i Yesu re na anishirr ba ba zizo di, “Ingga si ìlà i ingbingbru yi. Unushirr wa nggo ti ga ingga uwa si ta zirr ni ibwu zizo hen. A ta se ni ìlà yi nggo i ta nu ma iso tsitsirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","U anu Farrisi ba a ddu Yesu di, “Ùwà ti re ni itu imuwa, ùwà su uwanggo nggo taka da na ankpami di ida muwa si jiji. Inta si kpanye hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","I Yesu ddu ba di, “Ingga ti ko re si ki itu mungga mi ida imungga yi i si jiji. Ingga hi unto ku nggo ingga zhi, nu unto ku nggo ingga ko kuma. Uwa ta si imba, imba si hi unto ku nggo ingga zhi, nu unto ku nggo ingga ko kuma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Imba kye ingga nu ukpa ni so bre amu, uwa ta si ingga nanko, ingga si ko bre amu ni itu i unu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ingga ta di ingga ta bre amu ka mi, i ibre amu mungga yi ta si ijiji, nu nggo ingga si se na ankpa mu hen. Aki mungga wa nggo tu ingga a se ndo ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Are amba ka a da di anishirr aha ti da ure uyirr, imba bi kpanye na ba. ");
INSERT INTO ninNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ingga su uyirr nu umi ku abi re ni itu mungga, u Aki mungga wa nggo tu ingga, uwanggo su unu uha wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Aba zhi ma di, “Aki muwa wa se momonggo.” I Yesu ddu ba di, “Imba si hi ingga hen ni si hi Aki mungga wa hen. Imba ka ti hi ingga, imba taka hi Aki mungga wa meme.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesu à bre ku ankpinkpye anu Yahuda ba are kama nu nggo à ko tsarr ba nu Uki Unkpi ku Ibarr Abachi ku iyo, hinga ni unto ku nggo a di zu inklo yi. Undurr mi si vu ma hen, nggo ivi a ivu ma yi nise. ");
INSERT INTO ninNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","I Yesu da ku ankpinkpye anu Yahuda ba zizo di, “Ingga ti du imba, imba ta zha ingga, ni ta kɨ ni ila ure imba yi. Nggo imba ka si kuma nu unto ku nggo ingga so ko hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Aba zhi di, “Yesu ta ngu itu ima mu?” Ima yo du ma ko da di, “Imba si ta hi anko a ikuma nu unto ku nggo ingga se hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu ddu ba di, “Imba anishirr angga ba, imba zhi ni imimi inggya mi, uwa ta si ingga nanko, ingga zhi nu unkplassu. Imba sa abi ingbingbru, ingga si si abi ingbingbru inggi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ima yo di ingga ko da ki imba di jiji mu, imba ta kɨ ni ila ure imba yi. Imba ta kɨ ni ila ure imba yi, nggo imba ta si kpanye di ‘Ingga yo su undurr wa nggo ingga i da di a si ingga nggo’ hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Nggo aba a zhi ma di, “Ùwà su unggonggo?” I Yesu a ddu ba di, “Ingga yo su uwanggo wa nggo ingga ka da ki imba bazhi ni ime̱me̱ yi ba. ");
INSERT INTO ninNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ingga se na aseki ka ida kakami na atu a imba nggo ingga ka vu imba na ka. Ingga si ta da ka hen. Nggo ni kye ni ko da ku ingbingbru yi aseki ka nggo uwanggo wa nggo tu ingga yo mre, uwa yo di da ure ujiji.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","U anishirr ba si hi da a so re ba ni itu i Aki yi mu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nggo i Yesu ddu ba di, “Nggo imba ti klo Uvuvurr a Unushirr, imba ta hi di ‘Ingga yo su undurr wa nggo ingga i da di a si ingga nggo.’ Imba ta hi da aseki ka nggo ingga so di na ka a si su nu ukyekye mungga mu hen. Ingga so di da si inkindirr yi nggo Aki mungga wa di ingga bu ni da. ");
INSERT INTO ninNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Uwanggo wa nggo tu ingga a se ndo ni ingga ku. Ingga so di na aseki ka nggo a di su ku isisurr. Ima yo du ma si du ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nggo Yesu ko bre ba are kama ka u anishirr shishemi a kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu da ku anu Yahuda ba nggo kpanye na ku di, “Imba ti kuchi ni ga itsarr mungga yi, imba sa abiga mungga ba jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Imba ta hi ure ujiji ku, u ure ujiji ku ta kpa imba ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Aba a ddu ma di, “Inta sa amumarr ba Ibrayi, ni si sa agarr ba unu kye hen, nggo ùwà ta da ki inta ure ku ikpa ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","I Yesu da ba di, “Ingga da ki imba ure ujiji mu di, unushirr wa nggo ti so ni ila ure, uwa su ugarr a ila ure. ");
INSERT INTO ninNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ugarr si di so iso inggi ni iko yi sese hen, uvuvurr à di so iso inggi ni iko yi. ");
INSERT INTO ninNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Meme nggo, Uvuvurr wa ti ddu imba ttungo, imba ta sa amumarr iko ni si ta sa agarr zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ingga hi di imba sa ahinhan ba Ibrayi. Imba ba ma yo ko zha anko a ingu ingga, nggo ure mungga ku si so ki imba ni isisurr hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ingga so da inkindirr yi nggo Aki mungga wa tsarr ingga, imba so na inkindirr yi nggo aki amba nggo à bre ki imba.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Aba a ddu ma di, “Ibrayi nggo sa aki munta wa.” Yesu ddu ba di, “Ka di imba sa amumarr ba Ibrayi jiji mu, imba ka na inkindirr yi nggo a na. ");
INSERT INTO ninNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ingga nggo so di bre ki imba ure ujiji ku nggo ingga kpa zhi na Abachi ku, imba so di zha anko ka ngu ingga. Ibrayi à si na inkindirr numa meme hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Imba so na si inkindirr yi nggo aki amba wa mu a di na.” Aba da ku di, “A si hru ine iko nggi na ngri inta hen. Abachi nggo sa Aki munta wa na nkpama.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","I Yesu ddu ba di, “Ka da Abachi yo sa Aki a imba wa jiji mu imba ka kpanye ni ingga kakami, nu nggo ingga zhi na Abachi ku ni se nu nggo ziza. Ingga si nga su ku itu mungga hen, uwa yo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Inkindirr yi nggo du ure mungga ku u tsɨ ki imba, su nu nggo imba si kpanye ni shirr atu ku ure mungga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Imba sa amumarr ba aki a imba umimi wa, ni so na inkindirr yi nggo à zha. Nggo a su ni ngɨ anishirr zhi ni ime̱me̱ yi na nise na inkindirr numa ijiji. Nggo ina jiji sama nu umi kuma ku. A ti ki imu, uwa so na su ku undu uma mu. Nggo a su uni imu na sa aki a abi imu we. ");
INSERT INTO ninNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ingga da ki imba ure ujiji, ima yo du imba si kpanye ni ingga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Unggonggo nu umi umba ka gru kri na tsarr inkla yi nggo ingga i la ure nggo? Ingga da ki imba ure ujiji anggi mu di imba si kpanye ni ingga ku hen? ");
INSERT INTO ninNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Unushirr wa nggo sa a Abachi à di shirr atu ku ure ku Abachi ku. Imba mi, si zhi na Abachi ku hen. Ima yo du imba si ta shirr atu hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Anu Yahuda ba ddu Yesu di, “Inta si da ma nggo inta i da du ùwà sa anu Samarriya ni se ni izhi ndanda hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu da ba di, “Ingga sama na anazhi ndanda. Ingga nu Aki mungga wa inkpinkpye ima yi, imba kpa ingga chirr. ");
INSERT INTO ninNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ingga si so zha inkpinkpye ki itu mungga hen. U undurr à se nggo à so zha yi, na su uwa yo à su uni bre amu wa. ");
INSERT INTO ninNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ingga so da ki imba ure ujiji, undurr wa nggo ti ga itsarr mungga yi uwa si taka ttu hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Anu Yahuda ba ddu ma di, “Ziza yo inta i kye uwa kre ba. Inta hi du uwa se na anazhi ndanda. Ibrayi a ttu, u abi kpa are ba a kɨ. Uwa da du undurr wa nggo ti ga itsarr muwa yi uwa si taka ttu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ùwà mu mri Aki munta wa Ibrayi nggo à ttu? Ùwà mu mri abi kpa are ba nggo a kɨ? Ùwà kye du ùwà su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu ddu ba di, “Ka di ingga ta gɨ itu mungga yi ku inkpinkpye mu, inkpinkpye ima ka si i igigye. Uwanggo wa nggo ni ingga inkpinkpye yi uwanggo sa Aki mungga wa, wanggo wa nggo imba bre da a si ki imba Abachi a imba. ");
INSERT INTO ninNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Imba si hi ma hen, i ingga hi ma. Ka di ingga ta da ki imba di ingga si hi ma hen. Ingga kaki imu nâ si imba. I ingga hi ma ni ga ure kuma ku. ");
INSERT INTO ninNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Aki amba wa Ibrayi à nyarr du uwa ka hi inga i mungga yi. Na hi yi na nyarr.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Aba ddu ma di, “Uwa nggo nise ma ase iso ikywi, nggo ni ka hi Ibrayi?” ");
INSERT INTO ninNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu ddu ba di, “Ingga da ki imba ure ujiji, ingga i se kuchi bari aba ngri Ibrayi.” ");
INSERT INTO ninNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nggo Yesu à da meme, aba kuklo na vu angbinta da aba ta ta ma, i Yesu sharri ba na huzzu nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nggo Yesu so zirr kuma, na ku hi ugo numa nggo à su unakreshishi zhi nggo ayirr à ngri ma mu. ");
INSERT INTO ninNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","U abiga ma ba a zhi ma di, “Unitsarr, angginggi du ba a ngri ugo wanggo wa na akreshi? À si ila ure ima nggi ka si i akiki ma?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","I Yesu da ba di, “À si si ki ila ure ima ka i akiki ma hen. Abachi à du ba a ngri ma meme, wre ku bi tsarr ba ukyekye umaku ni itu i ma yi. ");
INSERT INTO ninNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iwre i inta bu na undu ku uwanggo wa nggo à tu ingga du azhi wa nise, wre ku ibittu ti nga undurr si ta na undu zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ziza, nu nggo ingga nise nu ugo ki imimi ku, ingga yo sa azhi wa ku ingbingbru yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Mre Yesu ttu antinte yo ni imimi na hu imimi vu re ku na ashishi ka. ");
INSERT INTO ninNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na da ku di, “Ku ngla ashishi ka ni indinda amasirr i Silowa.” (Inkpi inggi yi, “A tu ma.”) Ugo wa kuma ku ngla ashishi ka na kuma ni iko na ko kye abubo hi. ");
INSERT INTO ninNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Abi girr ama ba na anishirr ba nggo a di hi ma ni so na di barr a zhi ikpa di, “À su ugo wa nggo à so di barr wanggo yo?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Abanu da, à su uwa yo. U abanu da da à su unuma mu à zzu ugo ni barr wa. Ugo ni barr wa à kri karrkarr mi di, “À si ingga yo.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Aba zhi ma di, “Unggonggo du ùwà wre, à sa angginggi la?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A ddu ba di, “Ugo wa nggo à yo ma di Yesu, uwa yo hu imimi re ki ingga na ashishi na da ki ingga di kuma ku ngla ashishi ka ni indinda amasirr i Silowa. Mre ingga ku ngla ni hi abubo.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Aba zhi ma di, “Uwa se momonggo ziza?” Uwa ddu ba di, “Ingga si ka hi hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aba a gri ugo wa nggo a di su unakreshishi na kuma na anu Farrisi ba. ");
INSERT INTO ninNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Azhibarr nggo Yesu à hu imimi zharr ku ugo wa na ashishi ka na du ma wre si na Azhibarr a Isu Anu Yahuda ba. ");
INSERT INTO ninNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","U anu Farrisi ba a zhi inkindirr yi nggo ila ni du ma wre. Uwa da ba di, “À hu imimi nggi zharr ki ingga na ashishi, nggo ingga ku ngla yi glo, ziza ingga kye hi.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Anu Farrisi banu ba a da du, “Yesu wanggo yo si zhi na Abachi ku hen. Kye ma so na undu na Azhibarr a Isu wa.” Abanu ba a da di, “Imba kye uni la ure ka na aseki ka ikagri angga ka meme?” Na vi na ga ki na nkanka. ");
INSERT INTO ninNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","U anu Farrisi ba ka ku zhi ugo wa nggo à di se na akreshi ka di, “Ùwà da du ugo wa nggo à bwu ku ùwà ashishi ka su unggonggo?” Ugo wa da di, “À su uni kpa are.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ankpinkpye bu Yahuda abanu ba si kpanye da à su unakreshishi jiji hen, na si kpanye di ashishi ka a bwu ku hen, na yo anaki ma ba rri, ");
INSERT INTO ninNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","na zhi ba di, “Uwanggo su uvuvurr a imba? À di su unakreshishi jiji? Uwa ta di su unakreshishi uwa na kingginggi na kye hi ziza?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Anaki ba a ka sa ba di, “Inta hi da à su uvuvurr munta. I inta ngri ma ttu na akreshi. ");
INSERT INTO ninNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","I inta si hi nggo ashishi ka a na na wre ku hen, ka undurr wa nggo bwu ku ashishi ka. Uwa mi si su uvuvurr hen, imba zhi ma uwa ta da ki imba ni itu ima!” ");
INSERT INTO ninNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","A da meme nggo a ko kru isisu i ankpinkpye bu anu Yahuda ba, nggo a du undurr wa nggo ti da di Yesu su Kristi, aba ta ttu ma glo nu uki ki issubi umbarr ku. ");
INSERT INTO ninNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ima yo du anaki ba a da di, “À kri unushirr ba, imba zhi ma du da ni itu ima.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Aba yo ugo wa nggo à di se na akreshi ka rri inkpo i iha, na ddu ma di, “Ùwà da du ùwà di kru isisu i Abachi, da ki inta ure ujiji na anke̱ ka Abachi! Inta hi du ugo wa nggo à du ùwà wre à su uni la ure.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ugo wa ddu ba di, “Ingga si hi ka à su uni la ure hen. Inkindirr yi nggo ingga hi nggo inggi ì si di: Ingga i di su unakreshishi, i ziza ingga ko kye hi.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Aba zhi ma di, “À na sa angginggi, na na kingginggi na bwu ku ùwà ashishi ka?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ugo wa ddu ba di, “Ingga ka da ki imba ba, imba kà iwo. Imba zhi ingga anggi mu zizo? Imba mi zha di imba mi ta ga ma mu meme?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Mre, aba marr ma da di, “Ùwà mu si uniga a undurr uwama, i inta sa abiga ba Musa mu. ");
INSERT INTO ninNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Inta hi da Abachi à re nu Musa ku. Uwa ta su undurr muwa wa inta si hi unto ku nggo à zhi hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ugo wa ddu ba di, “U kuma ù shi ki ingga ibwu! Imba di imba si hi unto ku nggo à zhi hen, ka bu à zhi momo? Ingga nanko, inkindirr yi nggo inggi ingga hi si di, ugo wa à du ashishi mungga ka bwu. ");
INSERT INTO ninNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Inta hi Abachi si di wo ibarr i uni la ure hen, na di wo abangga ba nggo a so di ga ma na di na inkindirr yi nggo à da a bu na yo mre. ");
INSERT INTO ninNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Zhi ni ime̱me̱ yi nggo Abachi à na ingbingbru yi mu, imba ka wo du undurr ka bwu ashishi ku unuma nggo a ngri ma na akreshi du ma hi abubo ba? ");
INSERT INTO ninNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ka du ugo nggo si zhi na Abachi ku hen, ka si na undu kuma hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Aba a ddu ma di, “À ngri ùwà ni ila ure, ùwà di la ure ttuttumi nggi ni du ùwà ta tsarr inta ure ku Abachi?” Na ttu ma huzzu nu uki ki issubi ku. ");
INSERT INTO ninNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nggo Yesu wo inkindirr yi nggo a na nu ugo wa, na zha ma. À ku hi ma nggo na da ku di, “Ùwà kpanye nu Uvuvurr a Unushirr?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ugo wa zhi ma di, “Ankpye, uwanggo su unggonggo? Da ki ingga, hi di ingga mi ta kpanye na ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","I Yesu ddu ma di, “Ùwà ka hi ma ba, a su uwa yo ko re nu ùwà ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ugo wa da di, “Yo, Atiko, ingga kpanye!” Na kuttu ku Yesu. ");
INSERT INTO ninNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","I Yesu ddu ma di, “Ingga nga ni ingbingbru yi i tsarr iga ki na nkanka anishirr yi ssuzzu na ábì. Ingga nga i du aba kreshi bu kye hi, ni bu tsarr abangga ba nggo kye da aba so kye hi nggo di a sa aba kreshi.” ");
INSERT INTO ninNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nggo anu Farrisi banu a wo Yesu ni da meme yi, na zhi ma di, “Ùwà da anggi? Ùwà di inta mi sa aba kreshi?” ");
INSERT INTO ninNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu ddu ba di, “Ka di imba sa aba kreshi, a ka si vu imba ku ila ure hen. Nu nggo imba da di imba kye hi, imba ta kri ilo ku ila ure yi meme yo.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu da di, “Di ingga da ki imba ure ujiji, undurr wa nggo ti hun ba ni itumpa na si ga anko hen, à su unayi ni di kpa iki nu ukyekye. ");
INSERT INTO ninNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Undurr wa nggo à di rri ga anko, uwa yo su uni ka aminta wa. ");
INSERT INTO ninNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Uni gbye anko wa di bwu ku anko uni ka aminta wa, uwa ta rri, u aminta ba a di wo ukorr umaku na nga na ku. Uwa di yo aminta ama ba na asa na gri ba huzzu. ");
INSERT INTO ninNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu ugo ku nggo a ti gri aminta ba ssuzzu na ábì, uwa zzu ku ba ichi. Nggo a hi ukorr umaku, ima yo du ba ga ma. ");
INSERT INTO ninNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","A si ta ga undurr tankpami hen. Undurr ti yo ba aba ta kru, nggo a si hi ukorr uma ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu à da ba assurre nggo ku, aba wo na si hi inkpi i ire ima yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Uwa gru ko da ba zizo di, “Ingga da ki imba ure ujiji, ingga yo su anko a uki ku aminta wa. ");
INSERT INTO ninNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Inkpu yi nggo a kuchi ki ingga a sa abayi na di kpa inkindirr nu ukyekye, u aminta a jiji ba a si wo ba hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ingga yo sa anko a uki ku aminta wa, undurr wa nggo ti rri ba ni ingga ku a ta kpa ma ttungo. Unto ku nggo à ti kuma uwa ta hi agiga a ssussu. ");
INSERT INTO ninNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Undu ku unayi ku sa ayi, ingu, tuku ina ki ndanda. U undu mungga ku su ki ni iso tsitsirr, ni bu ni yi tsarr ssu. ");
INSERT INTO ninNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ingga yo su uni ka aminta uzizi wa. Uni ka aminta wa di ba itu ima ni ku aminta ba. ");
INSERT INTO ninNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Uni ka aminta ni inklo wa si si uni ka wa nggo aminta ba a su ku ama hen. Nggo a ti hi iche so nga na ku, à ta kru share, na du aminta ba. I iche wa ta ngɨ ba, na ta du na da du inkpu yi kru varr ni ijiji. ");
INSERT INTO ninNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ugo wa ta kru share, nggo à so na su undu ku uda mu, i isisurr ima yi si se ni itu i aminta ba hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ingga yo su uni ka aminta uzizi wa. Ingga hi aminta mungga ba, aba mi hi ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nâ ta si nggo ingga hi Aki mungga wa, uwa mi hi ingga. Ima yo di ingga i ba itu mungga ni ku aminta mungga ba. ");
INSERT INTO ninNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ingga se na aminta banu nggo a si se nu uki ku aminta ku hen. Ingga ta ku gri ba nga, ni surr na abangga ba. Aba ta wo ukorr mungga, na ta zirr bi ndo, u uni ka ba wa à ta su uyirr yo. ");
INSERT INTO ninNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ingga ka itu mungga yi ni, wre ki ingga bu kpa itu mungga yi kanga. Ima yo du Aki mungga wa kpanye ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Undurr sa nu ukyekye ki kpa itu mungga yi, ingga nggo kpanye ni ba yi ni. Ingga nggo i tsarr ma ku imungga ni ba itu mungga yi, ni se nu ukyekye ki ka yi kpa zizo. À sa Aki mungga nggo à da ki ingga di ingga bu na meme.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ida i Yesu ima yi di anishirr ba ga ki na nkanka zizo. ");
INSERT INTO ninNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Abi kri mwe ba so da di, “À ku anazhi, na là! Imba kri wo ku angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Inkpu yi da di, “Uni ku anazhi ka na kingginggi na re ma mi? Uzhi ka na kingginggi ni du unakreshishi kye hi?” ");
INSERT INTO ninNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Uwa su ni ivi yi nggo ani Yahuda ba ta na Iga i bwu Uki Unkpi ku Ibarr Abachi yi nu Urushalima. Ivi ima yi si ni umvru, ");
INSERT INTO ninNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","i Yesu so zirr na anga a Uki Unkpi ku Ibarr Abachi wa, nggo à yo wa da akaba a Solomo wa. ");
INSERT INTO ninNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Anu Yahuda ba ni nggurr bi na zhi ma di, “Ùwà ta di zu inta kakuma nita nggo bari, ni ka da ki inta ure ujiji ku? Uwa yo su Kristi wa jiji? Da ki inta ziza nggo.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu ddu ba di, “Ingga ka da ki imba ba, imba si kpanye hen. Aseki ka ikagri nggo ingga na ni isa i Aki mungga yi a tsarr imba na angu mungga ka. ");
INSERT INTO ninNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Meme mi, imba si kpanye hen, nggo imba si sa aminta mungga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Aminta mungga ba di wo ukorr mungga. Ingga hi ba, aba di ga ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ingga nu ba iso sese. Aba si taka kɨ mremremu hen. Undurr si ma nggo ka kpa ba glo nu ungo mungga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Aki mungga wa ni inga aminta mungga ba, à su ukyekye mri anishirr ba we, undurr si ma nggo ka kpa ba glo nu ungo ku Aki mungga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inta tuku Aki mungga wa inta sa ayirr.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Anu Yahuda ba a vu angbinta zizo da aba ta tà ma. ");
INSERT INTO ninNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu ddu ba di, “Ingga na aseki ka ikagri kama na ashishi amba nggo Aki mungga wa ni ingga. Ni itu i uwata nggi imba ta tà ingga na angbinta ka?” ");
INSERT INTO ninNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Aba ddu ma di, “Inta si di inta ta tà ùwà ku ina wre nggi hen. Inta ta tà ùwà nggo ùwà re ndanda mi ni itu i Abachi. Ùwà su unushirr na ayiyi nu ukpa ni so zha du ùwà ta da du ùwà sa Abachi!” ");
INSERT INTO ninNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu ddu ba di, “A charr nu ungbamvu ku Are ka imba ka di, ‘Ingga i ka da ba du imba sa ábáchí.’ ");
INSERT INTO ninNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Inta mi hi du Ungbamvu ku Abachi ka si kasarr hen. Anishirr bama a nu ba ure ku Abachi ku nggo, Abachi à re na ba na yo ba ki ábáchí. ");
INSERT INTO ninNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sa anggi mu du imba di ingga da ure undanda ni itu i Abachi, nggo ingga da di, ‘Ingga su Uvuvurr a Abachi’ nggo? Ingga yo su uwanggo wa nggo Abachi à ttu na tu nga ni ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ingga ti si so na sa aseki ka nggo Aki mungga à zha di ingga bu na nggo hen, imba bu si kpanye ni ingga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ingga ti ko na aseki ka Aki amungga a ka yo, ka nu nggo imba si kpanye ni ingga ku na aseki ka nggo ingga so na mi hen, imba bu kpanye na aseki ka ikagri ka yo, wre ki imba bu hi ankpu uyirr mre da Aki mungga wa se nu umi mungga, i ingga mi se nu umi ku Aki mungga.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Aba zha da aba ta vu Yesu zizo, uwa sarr huzzu ba na ango. ");
INSERT INTO ninNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Mre Yesu cha inyi nu Joda wa zizo kakuma nu ugarr ku nggo Yohana à so di zzu anishirr ba, na kuma ku so nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Anishirr shishemi a nga na ku. A ddu ikpa di, “Yohana à si na inkindirr i ikagri hen, u ure ku nggo à da ni itu i unushirr wanggo u si jiji.” ");
INSERT INTO ninNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Anishirr shishemi nabo a kpanye ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ugo numa nggo à di so nu Betani, aba yo ma di Lazarru. Uwa à vri. Betani wa yo si igbu a ani Maryamu tuku uvayirr wa Marrta. ");
INSERT INTO ninNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Maryamu wama yo à surr ku Atiko anye a ihun ingba wre wa na aza na hɨ wa ni infunfutu ima yi. Lazarru à su ku uzayirr). ");
INSERT INTO ninNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Amuyirr ba, anu Marrta tuku Maryamu a tu ba ni Yesu ku di, “Atiko, ukpami wa nggo ùwà kpanye na ku à vri.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nggo Yesu wo, na da di, “Ikikre i ulolo kuma si ta si ittu i Lazarru hen. Inkindirr ima i si meme, wre ku anishirr bu hi inkpinkpye i Abachi yi, ni ta si anko wa nggo Uvuvurr a Abachi wa mi taka kpa inkpinkpye meme.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu à kpanye na anu Marrta ba nu uvayirr ama wa tuku Lazarru. ");
INSERT INTO ninNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Meme mi nggo, Yesu à wo ivri i Lazarru na so nu unto ku nggo à se ki ivi iha bari. ");
INSERT INTO ninNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Na gru ddu abiga ma ba di, “Gru di inta kakuma nu Yahudiya.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Aba zhi ma di, “Unitsarr, inta kye di a ta tà ùwà na angbinta ka nabo yo, i ivi yi i nise kri mwe ùwà du ùwà ta kakuma nabo zizo?” ");
INSERT INTO ninNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","I Yesu ddu ba di, “Azhi yirr se ni ankpi awurr na aha, i si si meme hen? Unushirr wa nggo ti zirr na azhi uwa si ta bwu uza hen, nu nggo azhi wa a so la ku ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Uwa ti zirr ni ibittu nggo abubo wa shi ibwu, uwa ta bwu uza nggo à si gri uru hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu da ba meme, na da ba zizo di, “Ukpama munta wa Lazarru à kurr ina, di ingga ku si ma.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Abiga ma ba da ku di, “Atiko, à ti ko kurr si ina, uwa à ta wre.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu à ko da ba di Lazarru à ttu. Abiga ma ba a kye da à si ina jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","I Yesu kye na da huzzu ba di, “Lazarru à ttu. ");
INSERT INTO ninNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Inyarr imungga yi i si ki imba yo, nu nggo ingga sama nabo, wre ki imba bu kpanye. Di inta kuma na ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","U Toma (nggo a di yo ma di Didimo, nggo ri Amuhe̱) à ddu abiga banu ba di, “Di inta ga Yesu, di inta ku kɨ na ku!” ");
INSERT INTO ninNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nggo Yesu mirri nu Betani na hi du Lazarru à ka ttu ba, izzu ima yi i ki ivi une̱ mu ba. ");
INSERT INTO ninNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani ka ma kilomita itarr zhi nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Anu Yahuda shishemi a nga nye chi anu Marrta tuku Maryamu ni ittu i uzayirr umbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nggo Marrta wo di Yesu so nga na gru kuma ko ima na ku na anko, u Maryamu à so ni iko. ");
INSERT INTO ninNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marrta ddu Yesu di, “Atiko, ka du ùwà se ni inggya, uzayirr amungga wa ka si ttu hen! ");
INSERT INTO ninNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ni ima mi, ingga hi di inkindirr yi nggo ùwà ti barr Abachi uwa ta nu ùwà na yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu ddu ma di, “Uzumbirr wa ta gru zizo.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marrta da di, “Ingga hi da à taka tasi na azhibarr a itasi wa nggo a si azhibarr a ikikre wa.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu da ku di, “Ingga yo i di du anishirr a tasi ni du ba a so tsitsirr zizo. Undurr wa nggo ti kpanye ni ingga ku, à ti ttu mi uwa ta so tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","U unushirr wa nggo ti so tsitsirr na kpanye ni ingga, uwa si taka ttu mremremu hen. Marrta, ùwà kpanye meme?” ");
INSERT INTO ninNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marrta à da di, “Atiko, ingga ka kpanye ba du ùwà yo su Kristi wa, Uvuvurr a Abachi, nggo a so kye anko da à taka nga ni ingbingbru yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Nggo Marrta da meme na ku yo Maryamu, uvayirr wa kaki na anga yirr, na da ku di, “Unitsarr wanggo à se ni inggya, na so zha du uwa ta hi ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nggo Maryamu à wo meme na ssubi na kru huzzu kuma na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Yesu ni kri nu unto ku nggo Marrta à ku hi ma, na nise mirri nu umi ku igbu ku.) ");
INSERT INTO ninNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Anishirr ba nggo a ni so chi ba a se ndo ni Maryamu ku. Na hi ma nggo à gru kru huzzu, na kye da a ko kuma ko yi ni ibe yi mu, na ga ma. ");
INSERT INTO ninNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maryamu ko nu unto ku nggo Yesu à se. Nggo à sa ashishi na ku na ji jaku ku na aza, na da ku di, “Atiko, ka du ùwà se ni inggya, uzumburr wa ka si ttu hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nggo Yesu hi ma ni so yi yi, na hi nggo anishirr ba mi a ko yi na ku meme, itito ki ma na ba, i isisurr ima yi gru. ");
INSERT INTO ninNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yesu zhi ba di, “A zzu ma nu momonggo?” Aba da di, “Atiko, nga ni kye.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","I Yesu à yì. ");
INSERT INTO ninNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Anishirr ba da di, “Imba kye nggo a kpanye na ku kakami bari.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Abanu ambarr ba a da di, “À si bwu ku aba kreshi ashishi hen? À ka si zu Lazarru na han ma ni ittu yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Nggo itito ki ma zizo, i Yesu gru zirr kuma ni ibe yi. Ibe yi ì su nu uko uhan, aba ttu yi ni ingbinta. ");
INSERT INTO ninNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu ddu ba di, “Imba ba ingbinta yi glo.” Marrta uvayirr a uni ttu wa à ddu ma di, “Atiko, a su une̱ mu ari nggo a zzu ma, à ta hun ingba kakami!” ");
INSERT INTO ninNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu à ddu ma di, “Ingga si da ku ùwà du ùwà ta hi inkpinkpye i Abachi nggo ùwà ti kpanye hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Aba ngi ingbinta yi glo, i Yesu kye ko nu unkplassu na da di, “Ingga nyarr ku ùwà Aki mungga, nggo ùwà di wo ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ingga hi du ùwà di wo ingga ttuttumi. Ingga ko da ure unggo ku, wre ku anishirr angga ba bu hi na kpanye di ùwà nggo tu ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nggo Yesu à da meme, na yo ma hantu di, “Lazarru, gru huzzu!” ");
INSERT INTO ninNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Mre, Uni ttu wa gru huzzu, u ango ka na aza ka a kurr ni ilo nu upri ankru ku ibe ku, ni lo ku na ashishi ka meme. Yesu ddu ba di, “Imba ddu ma yi, ni du ma kuma.” ");
INSERT INTO ninNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Anishirr ba shishemi nggo a nga nye ichi ani Maryamu a hi inkindirr yi nggo Yesu à na, na kpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Abanu nu umi umbarr ku a kuma na anu Farrisi ba ba na ku da ba inkindirr yi nggo Yesu à na. ");
INSERT INTO ninNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Anu Farrisi ba na ankpinkpye abikye ba a yo inggurr bi i Akaba anu Yahuda ba na da di, “Inta ta na sa angginggi? Imba kye ikagri yi nggo unushirr wanggo so na yi! ");
INSERT INTO ninNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Inta ti so kye ma du u kuchi meme, anishirr ba we ta ka ku ga ma, u atuttu ba nu Roma ba a ta nga ni kpa inkpinkpye imunta yi nu Uki ku Ibarr munta ku na kpa Igbu munta yi!” ");
INSERT INTO ninNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Uyirr nu umi umbarr ku nggo a yo ma di Kayafa, nggo uwa yo à sa Ankpye unkpi abikye ba ni i se ima yi, à da di, “Imba sa arrurru mu? ");
INSERT INTO ninNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Imba kye i si wre sha unushirr uyirr a bu ttu ku anishirr ba we hen, nu nggo anishirr ba bu kɨ we?” ");
INSERT INTO ninNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafa mi à si da ure ukuma ku itu ima mu hen. Nu nggo uwa yo à sa ankpye unkpi abikye wa ni ise ima yi mi, à so da inkindirr yi nggo i taka la ni ichi mu, di Yesu ta ku ttu, wre ku anu Yahuda ba bu so. ");
INSERT INTO ninNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Na si su ku anu Yahuda ba yo na akpambarr hen, a su ku anishirr ba Abachi ba nggo a ga so ni ingbingbru inggi yi we. ");
INSERT INTO ninNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Bazhi na azhibarr ama wa kuma ni ichi ankpinkpye ba anu Yahuda ba a gru di zha anko a ingu Yesu. ");
INSERT INTO ninNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ni ima yo, Yesu gru di zirr sharri, na gru kuma ku di so na abiga ma ba ba hinga na ankpuji, ni igbu wa nggo a yo ma du Ifremu. ");
INSERT INTO ninNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nggo ivi i Iga i Ivu Sarr anu Yahuda yi i ki ywhiywhirr, anishirr shishemi ni ìgbù yi a gru kuma nu Urushalima da aba ko ingla ukpa umbarr ku, nâ ta si nggo iba imbarr yi ì da ba bari na ka ma ni iga yi. ");
INSERT INTO ninNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na so zha di aba ta hi Yesu, nggo a ku so nu Uki ku Ibarr ku, na gru so zhi ikpa di, “Imba kye kingginggi? À si ta nga ni iga inggi yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ankpinkpye abikye ba na anu Farrisi ba a ga da ku anishirr ba, di undurr uwanggo ti hi unto ku nggo Yesu à se, uwa bu da ba wre ba ku vu ma. ");
INSERT INTO ninNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nggo a ji ivi tani aba na Iga i Ivu Sarr yi, i Yesu mirri nu Betani ni igbu wa nggo Lazarru, ugo wa nggo Yesu a ta ma si, à di so. ");
INSERT INTO ninNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Aba zzu ku Yesu ila. Nggo Marrta a nu ba, u Lazarru ni so ri na ba. ");
INSERT INTO ninNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","I Maryamu à ba anye à tsɨ anta kakami ssu na azhizha. A na anye wa zhi nu unkunkurr ku nggo à yo ku du nadi, na si zɨ wa ni inkindirr hen. Na gri wa ni surr ku Yesu na aza, na hɨ ku aza ka ni infunfutu ima yi. I ingba i anye yi ì varr ssu ni iko yi. ");
INSERT INTO ninNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judasi Iskariyoti, uyirr nu umi ku abiga Yesu ba (nggo uwa yo à taka ba Yesu re nggo) à se nabo, na gru da di, ");
INSERT INTO ninNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Inklo i anye anggo wa i ka ma azurrfa ayiyirr atarr mu, aba ka si ba wa re na ka inklo yi ga ku abi iha ba hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yahuda a da mu, na si se na amarr ka abi iha ba jiji mu hen. A da meme nu nggo à su unayi. Uwa yo di gri ba abubwu a inklo wa, uwa ti gru uwa ttu inklo yi na yi. ");
INSERT INTO ninNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","I Yesu ddu Yahuda di, “Du ayamba wa tomi! A na wre nggo a zu anye anggo bi azhibarr a izzu ingga wa. ");
INSERT INTO ninNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Abi iha ba ta di so iso inggi ni imba ba. Uwa ta si ingga nanko, ingga si ta di so iso nggi ni imba ba hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Anu Yahuda ba shishemi a wo di Yesu se nu Betani na gru kuma ko i hi Yesu tuku Lazarru, nggo Yesu à ta ma si. ");
INSERT INTO ninNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","U ankpinkpye abikye ba a ssubi da aba ta ngu Lazarru mi meme. ");
INSERT INTO ninNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nggo si ni itu i Lazarru iyo anu Yahuda shishemi a so ka iga imbarr yi na so kakuma ku kpanye ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nu uha wa anishirr shishemi a so nu Urushalima ku Iga i Ivu Sarr yi. Nggo a wo di Yesu so nga nu Urushalima, ");
INSERT INTO ninNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","na mɨ ahiharr iri na ko ima na ku na anko, na ko di hantu di, “Hosana!” “Abachi à yo angu ka iwre ku ugo wa nggo à so nga ni isa i Atiko yi!” “Abachi à yo angu ka iwre ku Uttu a Israila wa!” ");
INSERT INTO ninNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nggo Yesu à du ba a gri ku ijaki wa na hun so na ku, nâ ta si nggo a charr di, ");
INSERT INTO ninNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Imba anishirr bu Zayo, imba si ki isisu hen! Kye uttu amba wanggo à so nga, na hun so ni uvuvurr ijaki.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ni ime̱me̱ yi abiga ma ba si kye inkindirr ima hi hen. Nu ugo ku nggo Yesu à ttu na tasi na hun kuma nu unkplassu ni inkpinkpye ima yi bari, aba a ssu hi da a charr inkindirr ima zu ni itu i Yesu nâ ta si nggo a na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Anishirr shishemi a se ni Yesu ku nggo à du Lazarru à tasi na da ku di a bu gru huzzu ni ibe yi. Ziza, aba ko bre ku anishirr inkindirr yi nggo Yesu a na. ");
INSERT INTO ninNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Anishirr ba wo iki i ikagri yi nggo Yesu a na, ima yo du anishirr shishemi a gru kuma ko ima ni Yesu ku na anko. ");
INSERT INTO ninNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Anu Farrisi ba gru so re ki ikpa di, “Imba hi di inta sama ni inkindirr numa izizi? Kye, anishirr bi ingbingbru ba a ko ga uwa mu we.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Anishirr banu nggo a yo ba ki anu Girrki a se nabo meme. A nga nye ibarr Abachi ni Iga yi nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Aba mi gru kuma nu ugo numa ku nggo a zhi nu Betsada na anga ka Galili ka, nggo yo ma di Filibu, ku da ku di, “Ankpye, inta zha di inta ka hi Yesu.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","I Filibu a da ku Andoro, aba aha mi a gru kuma ku da ku Yesu. ");
INSERT INTO ninNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu da ba di, “Ivi iyo i nga ba nggo Abachi à ta tsarr anishirr inkpinkpye jiji i Uvuvurr a Unushirr. ");
INSERT INTO ninNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Di ingga da ki imba ure ujiji, ingbingbi ikiri ta ji jaku rri ni imimi ni ttu, wre ku i bu klo ingbingbi shishemi. Ì ta si ttu hen, ì ta di kurr iyiyirr ima yo mre. ");
INSERT INTO ninNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Undurr wa nggo à zharr itu ima à ta ttu, u undurr wa nggo ti kà itu ima ni ingbingbru inggi yi à ga anko zizi a iso sese. ");
INSERT INTO ninNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Undurr wa nggo ti na ki ingga undu, uwa ta ga ingga. Uvuvurr iko amungga wa ta se ni ingga ku ttuttumi nu unto ku nggo ingga ti kaba. Aki amungga wa à ta ni abangga ba nggo so ga ingga nggo inkpinkpye. ");
INSERT INTO ninNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ziza nggo ingga se ni ivri ni isisurr. Ingga ta da kingginggi? Ingga bu da di Aki mungga bu kpa ingga ttungo ni ivri inggi yi? Iya, ingga i nga ku ima yo mremremu. ");
INSERT INTO ninNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aki, na inkindirr yi nggo ta du anishirr a kye uwa ssu nu ungo!” Mre aba wo ukorr zhi nu unkplassu da di, “Ingga i ka na isa imungga yi ki inkpinkpye ba, ni ta na yi zizo.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Anishirr ba nggo a kri nabo na wo ukorr ku, na da di, à si inge̱. Abanu ba a da di, “A si unitu a Abachi mu nggo a re na ku!” ");
INSERT INTO ninNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","I Yesu ddu ba di, “Ukorr ukuma u si ki imba yo nu su si ki ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Uwanggo yo su ku abi ingbingbru ba ivi i ibre amu yi. Ziza nggo a ta han uttu ni gri ingbingbru wa ssuzzu. ");
INSERT INTO ninNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nggo a ti gɨ ingga gru ni imimi yi, ingga ta du anishirr ba we a nga ni ingga ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Yesu ko da ba sa anko wa nggo uwa à taka ttu). ");
INSERT INTO ninNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Anishirr ba da di, “Inta bre na Angbamvu ka Abachi du Mezaya wa à taka so sese, uwa sa anggi mu du ùwà ka ko da di, ‘A ta gɨ Uvuvurr a Unushirr ki nu ussu’? A su unggonggo su ‘Uvuvurr a Unushirr’ uwama?” ");
INSERT INTO ninNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","I Yesu ddu ba di, “Uru mungga ku u ta sha la ki imba ki ntsɨmi yo. Meme imba bu na undu nu nggo abubo wa ni ko la, wre ku ibwu ta vu imba kpa undu ku. Imba ti zirr ni ibwu, imba si ta hi unto ku nggo imba so kuma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kpanye ni uni ila uru wa ku, nggo à ni so se ni imba ba, wre ki imba bu kaki amumarr ba azhi.” Nggo Yesu da ba meme na share na ba kuma ku sharri. ");
INSERT INTO ninNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nggo Yesu a di se na ba na di na aseki ka ikagri shishemi, aba kà ikpanye na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ima i si nâ ta si nggo uni kpa are a Abachi wa, Ishaya a da di, “Atiko, unggonggo kpanye ni inkindirr yi nggo inta bre ba? Atiko à tsarr ku unggonggo ukyekye umaku?” ");
INSERT INTO ninNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","U anishirr si kpanye hen nâ ta si ida Ishaya yi zizo di, ");
INSERT INTO ninNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Abachi à ttu ba ashishi na di isisurr imbarr yi shi ibwu, du ba si ta kye hi na ashishi ambarr ka hen, na si ta ri amarr hi ni isisurr imbarr yi hen, na si ta kanga ni du ingga du ba wre ni ivri imbarr yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya à kuchi hi inkpinkpye i Yesu yi na da ure ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Anishirr shishemi a kpanye ni Yesu ku kye na abi gri anishirr ba meme. Na so kru isisu i anu Farrisi ba, na si gru kri na da di aba kpanye ni Yesu ku hen. A kru da a ta ddu ba glo na aki ka ibarr ka. ");
INSERT INTO ninNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","A zha igbyarr asa i anishirr mri i a Abachi yi. ");
INSERT INTO ninNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","I Yesu à da hantu di, “Undurr wa nggo ti kpanye ni ingga ku, uwa si kpanye si ni ingga ku hen, à kpanye su nu uwanggo wa nggo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Undurr wa nggo hi ingga, uwa hi wanggo wa nggo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ingga gri ku abi ingbingbru ba uru, du undurr wa nggo ti kpanye ni ingga ku, uwa si ta so ni ibwu zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“U undurr wa nggo ti wo ure umungga ku na si kpanye na ku hen, ingga si vu ma ni ila ure hen. Ingga si nga ibre ki ingbingbru yi amu mu hen, ingga nga nye kpa yi ttungo mu. ");
INSERT INTO ninNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Undurr wa nggo ti kà ingga na si kpa nu ure umungga ku hen, uwa se nu uwanggo wa nggo ta bre ku amu. Ure umungga, uku yo taka bre ku amu na azhibarr a ikikre wa! ");
INSERT INTO ninNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ingga si ko re ki itu mungga hen. Ingga ko re ni itu i Aki amungga wa nggo tu ingga, a tsarr ingga ure ku, nggo ingga ta da na di ingga i da ku. ");
INSERT INTO ninNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ingga hi du ure umaku u di gri iso sese. Meme nggo, inkindirr yi nggo ingga ti da, uwa si inkindirr yi nggo Aki wa mu à da ki ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","A si azhibarr wa nggo a ta zzu na ambre ka na na Iga i Ivu Sarr yi, i Yesu à hi da azhibarr yo a nga ba nggo uwa ta du ingbingbru inggi yi na kakuma na Aki wa ku. À di kpanye na abiga ma ba ba nggo so ni ingbingbru yi kakami kuma ni ikikre yi. ");
INSERT INTO ninNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ni ingbahru Yesu na abiga ma ba a ko ri ila. Umimi wa à na undu nu Judasi, uvuvurr a Sima Iskariyoti, nggo na nu ma amarr ka iba Yesu re. ");
INSERT INTO ninNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu hi du uwa zhi na Abachi ku na ta kakuma na Abachi ku. Na hi da Abachi nu ma ukyekye ku we. ");
INSERT INTO ninNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ni ima yo Yesu gru kri na ttu ankru ama ka abi ka, na ba upri inkru ki ihɨ ukpa lo na anklampi. ");
INSERT INTO ninNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Na ba amasirr kasurr na agbugba na gru ko ngla ku abiga ma ba aza, na ko hɨ ba aza ka nu upri inkru ku. ");
INSERT INTO ninNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nggo Yesu nga ni Sima Biturr ku, uwa da di, “Atiko uwanggo ta ngla ki ingga aza?” ");
INSERT INTO ninNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","I Yesu ddu ma di, “Uwa si hi inkindirr yi nggo ingga ko na ziza hen, uwa taka hi yi ni ichi.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","I Biturr ddu ma di, “Uwa si ta ngla ki ingga aza mremremu hen.” I Yesu ddu ma di, “Uwa ta si kpanye di ingga bu ngla ku ùwà aza muwa ka hen, uwa si su uyirr nu umi ku anishirr amungga ba hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","U Sima Biturr ddu ma di, “Atiko, ngla aza mungga ka kye na ango ka ni itu yi mi!” ");
INSERT INTO ninNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu da di, “Nggo unushirr ti su ukpa, ankizhi a sama ku nu ukpa zizo uwa à ta zha ingla aza yo mre. Imba si shirr ankizhi wemi hen, unushirr uyirr yo à se na ankizhi nu umi umba ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesu a hi wanggo wa nggo ta vu ma re, ima yo du ma da di, “A si si imba wemi mu a sama na ankizhi hen.”) ");
INSERT INTO ninNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nggo a ngla aza ka kre ba, na ba ankru ama ka surr na ka ku ji so zizo. Na zhi ba di, “Imba hi inkindirr yi nggo ingga na ki imba? ");
INSERT INTO ninNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Imba yo ingga du Unitsarr tuku Atiko. Uwa a ma ki imba, ingga su uwa yo. ");
INSERT INTO ninNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ingga nggo su unitsarr ni si Atiko a imba, ni ngla ki imba aza. Imba mi bi ngla ki ikpa aza meme. ");
INSERT INTO ninNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ingga na meme tsarr imba, di imba mi ka bu na meme ki ikpa imba. ");
INSERT INTO ninNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ingga da ki imba ure ujiji du uvurr iko ni itu si di mri akiko ma hen. Na anko ayiyirr ama yo unitu si di mri wanggo nggo à tu ma hen. ");
INSERT INTO ninNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nggo imba hi aseki angga ka, imba ti na ka, Abachi à ta yo angu ka iwre ki imba! ");
INSERT INTO ninNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ingga si ko re na atu imba wemi hen. Ingga hi abangga ba nggo ingga hla ba nggo. Wre ku ure ku Abachi bu si meme nâ ta si nggo u da di, ‘Uwanggo wa nggo a so ri ni ingga ku nu unto uyirr uwa vu ingga re ba.’ ");
INSERT INTO ninNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Ingga ko da ki imba ziza, ni du inkindirr inggi yi nise la, wre nggo i ti la, imba ta kpanye di Ingga su Uwa Yo. ");
INSERT INTO ninNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ingga da ki imba ure ujiji mu, undurr wa nggo ti kpa unushirr nu umi abangga ba nggo ingga tu ba, uwa kpa si ingga. Undurr wa nggo ti kpa ingga, uwa si kpa si ingga hen, uwa kpa si uwanggo nggo à tu ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nggo Yesu a bre ure kuma kre ba, isisurr ima yi i se ni ivri kakami. Uwa da di, “Ingga so da ki imba, uyirr amba nggo à ta vu ingga re ba.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","U abiga ma ba kakye ikpa, nggo a si hi uwanggo wa nggo Yesu ko re ni itu ima yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Unuma nggo Yesu kpanye na ku nu umi ku abiga ma ku nggo à nga ni so hinga ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","I Sima Biturr zhi ma na ango di a su unggonggo? ");
INSERT INTO ninNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Uwama mi à chi kuma na kuyi ni Yesu ku na zhi ma meme di, “Atiko, a su unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","I Yesu ddu ba di, “Ingga ti ba unfonfo wa na agbugba wa, undurr wa nggo ingga ti ki ni inyi yi ni ka nu ma, uwa su uwa yo.” I Yesu ba unfonfo wa à ki ni inyi yi na ka nu Judasi, uvuvurr a Sima Iskariyoti wa. ");
INSERT INTO ninNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Nggo Yahuda ki ungo kpa unfonfo wa, mre Umimi wa à rri ku ni isisurr. I Yesu ddu ma di, “Na inkindirr yi nggo ùwà ta ko na kokorr!” ");
INSERT INTO ninNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Unushirr uyirr mi na abubo a iri wa si hi inkindirr yi nggo i du Yesu da ki Yahuda meme hen. ");
INSERT INTO ninNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nggo Judasi yo su uni zu ba inklo wa, abanu kye di Yesu ko da di a bu ku re inkindirr mu ku iga yi, ka a bu nu abi iha ba inkindirr. ");
INSERT INTO ninNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Mre, i Judasi à yo ungo ba unfonfo a gri na narr ssuzzu. Uwa a si ibittu mu. ");
INSERT INTO ninNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nggo Judasi gru kuma, i Yesu da ba di, “Ziza yo, Uvuvurr a Unushirr a kpa inkpinkpye. Abachi yo a kpa inkpinkpye ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Abachi ti kpa inkpinkpye ni itu ima yi, Abachi à ta nu ma inkpinkpye, na ta nu ma na yi ziza yo. ");
INSERT INTO ninNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Amarr mu, ingga ta so ni imba ba ntsɨmi yo. Imba ta zha ingga lankarr. Ingga da ki imba ziza, nâ ta si nggo ingga da ku anu Yahuda ba di, ‘Imba ka si kuma nu unto ku nggo ingga ta ko hen.’ ");
INSERT INTO ninNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ingga ko ni imba su ure uhe̱he̱ mu. Imba kpanye ni ikpa. Nâ ta si nggo ingga kpanye ni imba ba, imba bu kpanye ni ikpa meme. ");
INSERT INTO ninNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Imba ti kpanye ni ikpa, anishirr ba ingbingbru bu ta hi di imba sa abiga ingga.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sima Biturr zhi Yesu di, “Atiko, ùwà ta kuma nu momo nggo?” I Yesu ddu ma di, “Ùwà ka si kuma nu unto kuma nggo ingga ta kuma ziza hen, ùwà taka ga ingga nu ugo mu.” ");
INSERT INTO ninNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","I Biturr zhi ma di, “Atiko, angginggi ta han ingga ni iga ùwà ziza? Ingga kpanye ingga ta ttu ku ùwà!” ");
INSERT INTO ninNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","I Yesu zhi ma di, “Ùwà du ùwà kpanye du ùwà ta ttu ki ingga? Di ingga da ku ùwà, nggo agba wa ta nise tu, ùwà ta da ki inkpu itarr du ùwà si hi ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu à da ku abiga ma ba di, “Imba si di isisurr imba yi vri hen. Imba yo isisurr na Abachi ku ni yo isisurr ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Àkí se shishemi ni iko i Aki mungga yi. I ka si si meme hen, ingga ka si da ki imba hen? Ingga ko kuma ko ina abubo ssubi ki imba. ");
INSERT INTO ninNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nggo ingga ti kuma ku ssu abubo wa ki ki imba, ingga ta kanga ni gri imba ni kuma ndo, wre ku unto ku nggo ingga ti so imba mi ta so meme. ");
INSERT INTO ninNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Imba hi anko a ikuma nu unto ku nggo ingga ko kuma.” ");
INSERT INTO ninNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","U Toma ddu ma di, “Atiko, inta si hi unto ku nggo ùwà so kuma hen. Inta ta na kingginggi ni hi anko wa?” ");
INSERT INTO ninNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu ddu ma di, “Ingga yo sa anko wa, ni su ujiji wa, ni su iso tsitsirr yi. Undurr ka si kuma na Aki mungga wa ku sa ni ba ni ingga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ka di imba hi ingga kakami, imba ka hi Aki mungga wa meme. Zhi ziza nggo, imba hi ma, ni sa ashishi na ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","U Filibu da di, “Atiko, tsarr inta Aki wa. Uwanggo si inkindirr yi nggo inta zha.” ");
INSERT INTO ninNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","I Yesu ddu ma di, “Ingga so ni imba ba zhi ngbangbamu, imba si hi ingga hen, Filibu? Undurr wa nggo ti hi ingga, uwa hi Aki mungga wa. Anggi mu di imba ka so da di, ‘Tsarr inta Aki muwa wa’? ");
INSERT INTO ninNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Imba si kpanye di ingga se nu umi ku Aki mungga ku, ùwà se nu umi mungga hen? Are ka nggo ingga di bre ki imba a si di zhi si ni ingga ku hen. A sa Aki mungga wa yo nggo à rri so nu umi mungga na di na undu umaku. ");
INSERT INTO ninNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Imba bi kpanye ni ingga ku nggo ingga da ki imba di, ingga se nu umi ku Aki ku, u Aki wa se nu umi mungga. Ka imba bi kye aseki ka ikagri ka nggo ingga na, ni kpanye. ");
INSERT INTO ninNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ingga da ki imba, undurr wa nggo ti kpanye ni ingga ku uwa ta na aseki ka nggo ingga so di na. U abangga ba nggo ti kpanye aba ta na aseki ankpinkpi mri kanga ka nggo ingga na, ni itu yi nggo ingga ko kuma ko iso na Aki wa ku. ");
INSERT INTO ninNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Inkindirr yi nggo imba ti zhi ni isa mungga, ingga ta na ki imba na yi, wre ku Uvuvurr wa bi tsarr anishirr inkpinkpye i Aki yi. ");
INSERT INTO ninNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Inkindirr yi nggo imba ti zhi ingga ni isa mungga, ingga ta na yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yesu à kuchi da ku abiga ma ba di, “Imba ti kpanye ni ingga, imba ta na inkindirr yi nggo ingga da di imba bu na. ");
INSERT INTO ninNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ingga ta zhi Aki wa, uwa ta ni imba Uni zi numa nggo ta ni so ni imba ba sese. ");
INSERT INTO ninNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Izhi Iwre iyo i ta tsarr imba inkindirr yi nggo i si ijiji. Anishirr bu ingbingbru ba a si kpanye na ku hen, nggo a si hi ma hen. Imba hi ma, nggo à se ni imba ba, na ta di so ni imba ba. ");
INSERT INTO ninNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ingga si ta du imba na akpambirr nâ ta si amumarr ba ako hen, ingga ta kanga ni imba ba. ");
INSERT INTO ninNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ni ivi ntsɨmi ingbingbru yi si ta hi ingga zizo hen. Imba ta di hi ingga. Nu nggo ingga ta so tsitsirr, imba mi ta so tsitsirr meme. ");
INSERT INTO ninNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na azhibarr ama yo imba ta hi di ingga se nu umi ku Aki mungga ku, imba mi se nu umi mungga, ingga se nu umi umba. ");
INSERT INTO ninNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Abangga ba nggo a hi ure mungga ku na so ga ku, aba yo sa abangga ba nggo a kpanye ni ingga ku. Aki mungga wa ta kpanye na abangga ba nggo kpanye ni ingga. Ingga mi ta kpanye na ba ni si ta ka sharri ba hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","I Judasi (si si Judasi Iskariyoti hen) à da di, “Atiko, angginggi du ùwà tsarr inta yo itu muwa yi, ni si ta tsarr inkpu anishirr i ingbingbru yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu à ka sa ba di, “Anishirr ti kpanye ni ingga ku aba ta na inkindirr yi nggo ingga da ba. Aki mungga wa ta kpanye na ba. Inta ta nga ni so na ba. ");
INSERT INTO ninNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Abangga ba nggo kà ingga a si di ga itsarr mungga yi. Itsarr nggo imba so wo yi i si si mungga hen, i zhi na Aki mungga wa nggo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ingga bre ki imba aseki ka angga ka nggo ingga ni so ni imba ba. ");
INSERT INTO ninNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Uni zi imba wa taka ni tsarr imba aseki ka we, na ta ni imba amarr ka hi inkpu aseki yi nggo ingga bre ki imba. Uni zi uwama yo si Izhi i Iwre yi nggo Aki mungga wa à taka turr nga ni isa mungga. ");
INSERT INTO ninNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ingga ni imba isu isisurr. Isu isisurr i inggi yi nggo ingga yo di ni yi na ankpa mu. Isu isisurr ima yi si si nâ ta si i ingbingbru yi hen. Imba vu isisurr ni si kru isisu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Imba wo nggo ingga da ki imba di ingga ta kuma, ni ta kanga ni imba ba. Imba ti kpanye ni ingga ku, imba bu se ni inyarr nggo ingga ta kakuma na Aki mungga ku, nggo imba hi da Aki mungga wa à mri ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ingga ko da ki imba are ka ngga ka ziza, ni du inkindirr inggi yi nise la, wre nggo i ti la, imba ta kpanye ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ingga si ta ka re ni imba ba ma mi zizo hen, nu nggo uttu ni ingbingbru wa ko nga. A sama nu ukyekye ni itu mungga. ");
INSERT INTO ninNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ingga zha da anishirr bi ingbingbru ba ka hi di ingga kpanye na Aki mungga wa ku. Ima yo di ingga i so na aseki ka nggo à da ki ingga. “Gru, di inta kuma yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu da ku abiga ma ba di, “Ingga yo si anggunggurr a grepu ajiji wa, Aki mungga wa yo si uni do wa. ");
INSERT INTO ninNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","A di tse inggingga mungga yi nggo ì si di klo inkpinkpo hen. Na di kurr angga wa nggo di klo, wre ku uwa bi klo kakami. ");
INSERT INTO ninNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Imba mi si nâ ta si anggingga ka nggo a ka kurr ka ba nu nggo imba i kpa itsarr imungga yi. ");
INSERT INTO ninNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Imba re̱ nga ni ingga ku, ingga mi ta re̱ nga ni imba ba. Unggungga ka si klo inkpinkpo ku itu ima sama ni re̱ nga na anggunggurr wa hen. Meme yo, imba mi ka si klo sama ni re̱ nga ni ingga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ingga yo si anggunggurr wa, imba ngga si inggingga yi. Undurr ti re̱ nga ni ingga ku, i ingga mi re̱ nga ku, à ta klo inkpinkpo shishemi. Imba ka si na inkindirr ku atu amba sama ni ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Undurr wa nggo ta si re̱ nga ni ingga ku hen, uwa si nâ ta si unggungga ku nggo a gye ku ta yo u ttu. A di ssu inggingga ima bi na yo uru. ");
INSERT INTO ninNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Imba ti nggurr itu bi ni ingga ku ni ga itsarr mungga yi, inkindirr yi nggo ùwà ti barr ni isa mungga aba ta na ku ùwà na yi. ");
INSERT INTO ninNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Imba bi klo inkpinkpo shishemi, ni tsarr anishirr ba di imba sa abiga ingga jiji. Ima yo di gri ku Aki mungga inkpinkpye. ");
INSERT INTO ninNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Ingga i kpanye ni imba nâ ta si nggo Abachi à kpanye ni ingga. Ziza, imba so ni ikpanye imungga yi. ");
INSERT INTO ninNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Imba ti ga are mungga ka, ingga ta di kpanye ni imba ba nâ ta si nggo ingga so di ga are ka Aki mungga ka uwa di kpanye ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ingga bre ki imba are angga ka, wre ki imba bu si ni inyarr kakami nâ ta si nggo ingga mi i se. ");
INSERT INTO ninNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ziza, ingga ni ko da ki imba di imba bu kpanye ni ikpa nâ ta si nggo ingga kpanye ni imba ba. ");
INSERT INTO ninNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Anko wa nggo ùwà ta tsarr unushirr di ùwà kpanye na ku, anggo su wa bi ka itu muwa yi ni ni ttu ku undurr wama. ");
INSERT INTO ninNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Imba ta si akpukpamburr nggo imba ti ga are mungga ka. ");
INSERT INTO ninNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ingga si ta yo imba ki amirr iko zizo hen, nggo uvuvurr iko si di hi aseki ka we nggo akiko ma wa di na hen. Ingga yo imba ki akpukpamburr, nggo ingga bre ki imba aseki ka we nggo Aki mungga wa bre ki ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Imba ngga si hla ingga hen. Ingga nggo i hla imba, ni ni imba undu ku nggo ku, di imba bu ku klo inkpinkpo, inkpinkpo yi nggo a ta so sese. U Aki mungga wa ta ni imba inkindirr yi nggo imba zha na ku ni isa mungga. ");
INSERT INTO ninNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Uwanggo yo su ure mungga ku: Imba bu kpanye ni ikpa yi. ");
INSERT INTO ninNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Anishirr ba i ingbingbru ba ti karr imba, imba bu hi da a karr ingga kuchi. ");
INSERT INTO ninNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Imba ti si abi ingbingbru yi, aba ta kpanye ni imba ba nâ ta si ambarr. Ingga hla imba glo na ba. Ziza, imba si se na ba zizo hen, ima yo du ba karr imba. ");
INSERT INTO ninNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Imba bu ssu hi inkindirr yi nggo ingga da ki imba du: ‘Uvuvurr iko à si di mri Akiko ma hen.’ Anishirr ti tsutsarr ingga aba ta tsutsarr imba mi meme. Ka da a wo itsarr imungga yi a ta wo imba mi. ");
INSERT INTO ninNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","A ta na ki imba meme nggo imba so ga ingga, a na meme nggo a si hi wanggo nggo à tu ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ingga ka si nga ni re na ba hen, a ka si hi di aba kpala hen. Ziza, a ka si da di, ‘Inta si hi di inkindirr yi nggo inta di na si ikpala hen.’ ");
INSERT INTO ninNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Undurr wa nggo ti karr ingga uwa karr Aki mungga meme. ");
INSERT INTO ninNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ingga na aseki ka nggo undurr nise na ka kye nu umi umbarr ku. Ka da a nise hi ingga ni na aseki ngga ka, a ka si da da a kpala hen. Aba a hi ingga ni na aseki ka angga ka na karr ingga na Aki mungga wa meme. ");
INSERT INTO ninNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Inkindirr inggi i si meme, wre ku ure ku Abachi bu si meme nâ ta si nggo a charr na Are ka di, ‘A karr ingga gigyemi.’ ");
INSERT INTO ninNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ingga ta tu Uni zi wa zhi na Abachi ku, uwa yo si Izhi Iwre yi nggo i zhi na Aki mungga wa ku. Izhi yi ta ni tsarr ure ujiji ni itu i Abachi. Uwa ti nga, uwa ta ni zi imba ni ta bre ki imba are ni itu mungga. ");
INSERT INTO ninNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Imba mi bi ku bre ku anishirr ure ni itu mungga, nggo imba mi i se ni ingga ku zhi ni ime̱me̱ yi. ");
INSERT INTO ninNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ingga bre ki imba are ka angga ka, wre ki imba bu si ka ko nu ugo ni iyo isisurr imba yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","A ta han imba huzzu na aki ka issubi ka. Ivi yi ko nga nggo abi ngɨ imba ba ta kye di aba ko zi Abachi mu undu. ");
INSERT INTO ninNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","A ta na aseki kama ni ibwu nu nggo a si hi Aki mungga wa hen, na si hi ingga mi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ingga bre ki imba aseki ka angga ka ni du ivi yi nise, nggo a ti ka la imba ta ssu hi di ingga ka gba ki imba utu ba. “Ingga di se ni imba ba, ima yo di ingga si bre ki imba are angga ka ni ime̱me̱ yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ziza nggo, ingga ko kakuma nu uwanggo nggo à tu ingga nggo. Uyirr amba mi à si zhi ingga di ingga ta ko nu momonggo hen? ");
INSERT INTO ninNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ingga hi di isisurr imba yi i vri nggo ingga bre ki imba are ka angga ka. ");
INSERT INTO ninNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ingga bre ki imba si are ajiji mu, ì wre ingga bu du imba. Ingga ti kuma ingga ta ku tu Uni zi wa nga ki imba. Ingga ta si kuma hen, Uni zi wa si ta nga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nggo Uni zi wa ti nga, uwa taka ni tsarr anishirr ba ingbingbru ba are ni itu i ila ure, tuku ni itu i izirr wre na age̱ ka Abachi, tuku ni itu i ibre amu. ");
INSERT INTO ninNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Uni zi wa ta tsarr ba di ika ikpanye ni ingga ku i si ila ure, nggo a kà ikpanye ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Na si hi inkindirr yi nggo si isa ni ila ure na age̱ ka Abachi hen, nggo ingga nggo ta ko kuma na Aki mungga ku, imba si ta hi ingga zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Uni zi wa à ta ni tsarr ba di Abachi à ka bre ku uttu ni ingbingbru wa amu ba. ");
INSERT INTO ninNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Ingga se na aseki shishemi nggo ingga ta bre nggo, a ta mri imba ivu gri. ");
INSERT INTO ninNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Izhi yi nggo di tsarr anishirr ba ure ujiji ku ta nga, ì ti nga ì ta ni gri imba na anko ajiji wa. À si ta re ku itu ima hen, à ta bre si inkindirr yi nggo a wo ka ni ingga ku nggo, na ta bre aseki ka nggo a so nga. ");
INSERT INTO ninNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Izhi ijiji yi taka ni tsarr imba inkpinkpye mungga yi. Nggo ì ta bre ki imba si inkindirr yi nggo ingga ka da ki imba nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Aseki ka nggo Aki mungga wa à se na ka we a si amungga. Ima yo di ingga da di Izhi yi ta ni bre ki imba inkindirr yi nggo ingga ka bre. ");
INSERT INTO ninNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“A ji ntsɨ imba si ta hi ingga hen, u ntsɨmi imba ta hi ingga zizo.” ");
INSERT INTO ninNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Abiga ma abanu ba zhi ikpa di, “Yesu a da uwama sa angginggi di, ‘A ji ntsɨmi imba si ta hi ingga hen, u ntsɨmi imba ta hi ingga zizo?’ Na da uwama sa angginggi di, ‘Nggo ingga ko kuma na Aki amungga wa ku?’ ” ");
INSERT INTO ninNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Na zhi zizo di na da uwama si angginggi di, ‘ntsɨmi’? Inta si hi inkindirr ima yi nggo a so bre hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu à hi di abiga ma ba a zha di aba ta zhi ma are akama, na ddu ba di, “Imba ko zhi ikpa inkindirr yi nggo ingga da yi di, ‘Ntsɨmi imba si ta hi ingga hen, u ntsɨmi imba ta hi ingga zizo’? ");
INSERT INTO ninNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ingga da ki imba ure ujiji mu di, imba ta yi ni vri isisurr, abi ingbingbru ba ta me̱ nyarr. Imba ta vri isisurr, i ivri isisurr imba yi taka kaki inyarr. ");
INSERT INTO ninNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ayamba ti ta ko ngri uvuvurr, uwa di wo ivri nggo azhibarr wa a ma ba. Nggo uwa ti ngri uvuvurr wa gri na ango ba, uwa kpamusu ni ivri yi, na nyarr nu uvuvurr wa nggo a ngri ma nga ni ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","I ta si ki imba meme yo. Ziza imba ko vri isisurr. Nggo ingga taka ni hi imba zizo imba taka me̱ nyarr, undurr si taka kpa inyarr ima yi glo ki imba hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na azhibarr ama wa imba si taka zhi ingga inkindirr zizo hen. Ingga da ki imba, Aki mungga wa taka ni imba inkindirr yi nggo imba ti barr ma ni isa mungga. ");
INSERT INTO ninNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Imba nise barr inkindirr numa ma mi na anko anggo wa kye. Ziza nggo, imba ta barr ni isa mungga, a ta ni imba na yi, wre ki imba bi me̱ nyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ingga bre ki imba are angga ka na assurr are, azhibarr wa ko nga nggo ingga ta re ki imba krizhizhi mi. Ingga taka bre ki imba are ni itu i Aki mungga wa. ");
INSERT INTO ninNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na azhibarr ama wa, imba taka zhi Aki mungga wa aseki ni isa mungga, imba ku atu amba nggo taka barr ma si ta si ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Abachi nggo à si Aki, à kpanye ni imba, nggo imba kpanye ni ingga, ni kpanye di ingga nga zhi na ku. ");
INSERT INTO ninNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ingga zhi na Aki mungga wa ku, ni nga ni ingbingbru yi, ziza nggo ingga ko du ingbingbru yi ni kakuma na ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Abiga ma ba a da ku di, “Kye ziza yo ùwà ko re ki inta krizhizhi mi ni si ko na undu na assurr are nggo vri ki inta ikye hi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ziza nggo yo, inta kpanye du ùwà hi aseki ka we, ni si zha undurr wa nggo ka zhi ùwà ure hen. Ima yo di inta kpanye du ùwà nga zhi na Abachi ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","I Yesu da ba di, “Ziza yo imba kpanye? ");
INSERT INTO ninNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kye na! Ivi yi ko nga, ni i ka nga ba, nggo imba wemi taka ga nado, imba wemi taka ga kuma na ako amba. Imba taka kà ingga du na ankpa mu. Meme mi, ingga si ta se na ankpa mu hen, nggo Aki mungga wa à se ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ingga bre ki imba are angga ka, wre ku imba bu se ni isu isisurr nu nggo imba i nggurr bi ki uyirr ni ingga ku. Imba ta ni se ni ingbingbru inggi imba ta ki iha, meme mi imba bi vu isisurr, kye ingga ka mri ingbingbru yi ba!” ");
INSERT INTO ninNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nggo Yesu re kre na abiga ma ba na gɨ ashishi kye hun ko nu unkplassu na barr di, “Aki mungga, azhibarr a yo a nga ba. Nu Uzumi wa inkpinkpye, wre ku Uzumi wa mi bu nu ùwà inkpinkpye yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ùwà nu Uvuvurr wa ukyekye na atu a anishirr we, wre ku bu ni iso sese ku abangga ba nggo ùwà nu ma. ");
INSERT INTO ninNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iso sese inggi su a bu hi ùwà, du ùwà yo sa Abachi ujiji na nkpami, na bu hi Yesu Kristi nggo ùwà tu. ");
INSERT INTO ninNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ingga kre undu ku nggo ùwà ni ingga di ingga bu na nggo. Meme yo nggo, ingga nu ùwà inkpinkpye ni ingbingbru inggi yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ziza nggo, Aki, ka inkpinkpye ime̱me̱ yi nggo ingga i di se na yi ni ingga, iyiyirr ima yo nggo ingga di se na yi bari ùwà na imimi yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ùwà ni ingga anishirr angga ba zhi ni ingbingbru yi, ingga tsarr ba nggo ùwà se nggo. A sa anishirr muwa, ùwà ni ingga na ba. Aba a kru isisu i ure muwa ku. ");
INSERT INTO ninNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ziza nggo, aba hi da aseki ka we nggo ùwà ni ingga a zhi nu ùwà ku. ");
INSERT INTO ninNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ingga tsarr ba are ka nggo ùwà ni ingga na ka, aba kpanye na ka. Aba a hi di ingga zhi nu ùwà ku, na kpanye du ùwà yo tu ingga jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ingga ko barr ni itu imbarr. Ingga si ko barr ku anishirr ba ingbingbru ba hen. Ingga ko barr ku anishirr ba nggo ùwà ni ingga, nggo a si amuwa mu ziza. ");
INSERT INTO ninNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Inkindirr yi nggo ingga se na yi i si imuwa, i inkindirr yi nggo i si imuwa i si imungga. Aba yo ta tsarr inkpinkpye imungga yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ingga si ta so ni ingbingbru yi zizo hen. Ingga ko nga nu ùwà ku. Aba ta so ni ingbingbru yi bari. Aki Uni wre, zu ba zizi nu ukyekye ku isa muwa ku, isa yi nggo ùwà ni ingga nggo, wre ba bu sa ayirr, nâ ta si nggo inta tuku ùwà sa ayirr. ");
INSERT INTO ninNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nggo ingga di so na ba, ingga di zu ba zizi ni di kri ba nu ukyekye ki isa muwa ku, isa yi nggo ùwà ni ingga nggo. Ingga di kri ba. Uyirr ambarr mi à si nado hen, uwa su uyirr wanggo yo nggo à su undanda wa à na ingga nado nâ ta si nggo ure ku Abachi ku u da nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ingga ta ko nga nu ùwà ku ziza nggo, ni ko bre ba aseki ka angga ka mi, nggo ingga ni so ni ingbingbru yi na abiga ba ba, wre ku abiga ingga ba bu tsarr ssu ni inyarr iyiyirr yi nggo ingga se na yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ingga tsarr ba ure muwa ku, u anishirr ba ingbingbru ba a karr ba, nggo a si si abi ingbingbru ba na ba zizo hen, nâ ta si nggo ingga mi si si abi ingbingbru wa hen. ");
INSERT INTO ninNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ingga si ko barr du ùwà bu vu ba glo ni ingbingbru yi mu hen, ingga ko barr du ùwà bu gri ba ni ka umimi wa glo ba ma. ");
INSERT INTO ninNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","A si sa abi ingbingbru inggi yi hen, na su nggo ingga mi si si uni ingbingbru wa hen. ");
INSERT INTO ninNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ure muwa ku ù su ujiji. Meme yo, du ujiji ku na ba ki anishirr muwa namri. ");
INSERT INTO ninNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ingga tu ba na anishirr ba ingbingbru ba ba, nâ ta si nggo ùwà tu ingga na ba ni ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ingga nu ba itu mungga yi, wre ku aba mi bu ni atu ambarr wa na ga ùwà ku are muwa ka, nggo sa ajiji. ");
INSERT INTO ninNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ingga si ko barr ku abangga ba yo na akpambarr hen. Ingga mi ko barr ku abangga ba nggo ta kpanye ni ingga ku ku itsarr imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Aki, ingga so barr di a bu sa ayirr, nâ ta si nggo ùwà se nu umi mungga, ingga se nu umi muwa. Ingga ko barr di ùwà bu nggurr ba bi ni inta ba. Ima yo ta du anishirr ba ingbingbru ba a kpanye du uwa yo tu ingga jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ingga nu anishirr angga ba inkpinkpye yi nggo ùwà ni ingga, wre ba bu si ayirr, nâ ta si nggo ùwà ni ingga sa ayirr. ");
INSERT INTO ninNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ingga se nu umi umbarr ku, ùwà se nu umi mungga, wre ba bu kaki ukpa uyirr chi. Ima yo ta du anishirr bi ingbingbru ba hi du ùwà yo tu ingga. A ta hi du ùwà kpanye na abiga mungga ba ba nâ ta si nggo ùwà kpanye ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aki, ingga zha di abangga ba nggo ùwà ni ingga bu se ni ingga ku ttuttumi, wre ba bu hi inkpinkpye mungga yi nggo ùwà ni ingga, nggo ùwà kpanye ni ingga ku zhi ni ime̱me̱ yi nggo ùwà nise zu ibarr i ingbingbru yi. ");
INSERT INTO ninNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Aki mungga uzizi, ingbingbru anishirr yi i ssurr ùwà, ingga hi ùwà, u abiga mungga ba a hi du ùwà yo tu ingga. ");
INSERT INTO ninNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ingga tsarr ba ùwà, ni ta kuchi ni du ba hi ùwà, wre ku ikpanye muwa yi nggo ùwà se na yi ni itu mungga bi se na atu ambarr wa, ingga mi bu se nu umi umbarr ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nggo Yesu à barr kre na gru na abiga ma ba ba cha uhangbu numa nggo a yo ku du Kidro. Ila numa nggo a ttu inkinkurr i olivu i se nabo, u Yesu na abiga ma ba a rri ko na yi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judasi, wanggo à vu Yesu à re ba nggo, à hi unto kuma kakami, nggo Yesu na abiga ma ba a di nggurr bi nabo na ankpu na ankpu. ");
INSERT INTO ninNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nggo Yesu na abiga ma ba a ni se ni ila yi, u Judasi a nggurr surr ni inkirr i abi ta iku bu Roma ba na abi gbye Uki ku Ibarr ku, nggo ankpinkpye abikye ba na anu Farrisi ba yo a tu ba. Aba hru iki itsi ni ingba i murr uru. ");
INSERT INTO ninNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nggo Yesu a ka hi inkindirr yi nggo ta la na ku ba, na zirr kuma na ba, na zhi ba di, “Imba di zha unggo?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Aba ddu ma di, “Yesu anu Nazareti.” I Yesu ddu ba di, “À si ingga yo nggo.” (I Judasi uni ba Yesu re wa à kri na ba nu unto ku.) ");
INSERT INTO ninNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nggo Yesu à ddu ba di, “À si ingga yo,” aba kakuma nu ugo ku kuhre ni imimi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","I Yesu zhi ba zizo di, “Imba di imba di zha unggonggo?” Aba da di, “Yesu anu Nazareti.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu ddu ba di, “Ingga da ki imba di à si ingga yo. Imba ti ko zha si ingga yo, imba du inkpu anishirr yi kuma.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","(I si meme, wre ku are ka nggo Yesu à da ba bu si jiji: “Uyirr mi si nado nu umi ku anishirr ba nggo uwa ni ingga hen.”) ");
INSERT INTO ninNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sima Biturr à gri anjingba, na kpo ka ssuzzu na ttu ku uvuvurr iko unuma a ankpye unkpi abikye wa utu ku ungo ri ku. (Isa i ugarr yi ì ri Maluku.) ");
INSERT INTO ninNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","I Yesu à ddu Biturr di, “Ka anjingba muwa ka yo nu uhorr. Ùwà kye di ingga si ta so umplango ku iha ku nggo Aki mungga à ni ingga di ingga bu so hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mre u abi ta iku ba na ankpye ambarr wa, na abi gbye Uki ku Ibarr ku, a vu Yesu, na lo ma na azhizhi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na gri ma na kuma nu Anasi nggo ku ime̱me̱ yi. Uwa yo si uhima a Kayafa, ankpye unkpi abikye ba ni ise ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kayafa wama yo à da ku anu Yahuda ba di i wre u unushirr uyirr bi ttu ku inkpu anishirr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sima Biturr tuku uniga unuma wa a so ga Yesu. Nu nggo ankpye unkpi abikye wa à hi uniga uwama wa, aba a kpanye ku du ma a ga Yesu rri na ando wa. ");
INSERT INTO ninNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","I Biturr kukri na anko, uwa uniga numa wa nggo a hi ankpye unkpi abikye wa na ka huzzu nga ni re nu uva wa nggo ì kri harr anko wa na du Biturr à mirri. ");
INSERT INTO ninNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Uva wa kri na anko wa na ddu Biturr di, “Ùwà si su uyirr nu umi ku abiga bu ugo uwanggo wa hen?” I Biturr da di, “Iya, ingga si se hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Abubo wa à su, amirr iko ba na abi gbye abubo ba a kri so vri uru. I Biturr mi kukri vri uru ku na ba. ");
INSERT INTO ninNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ankpye unkpi abikye wa à zhi Yesu ure ni itu i abiga ma ba ni itsarr ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","I Yesu ddu ma di, “Ingga si re ku ingbingbru sharri hen. Ingga so di tsarr ba na aki ka issubi ka nu Uki Unkpi ku Ibarr Abachi ku, nggo ani Yahuda ba wemi a di nggurr bi. Ingga si da inkindirr sharri hen. ");
INSERT INTO ninNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ùwà zhi ingga angginggi? Zhi anishirr ngga ba nggo so di wo ingga. A hi inkindirr yi nggo ingga di bre ba.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nggo Yesu a re meme, u uyirr nu umi ku abi gbye abubo ba à kri hinga na ku na nggurr ma na ashishi, na zhi ma di, “Uwanggo yo su anko a ire na ankpye unkpi abikye wa ku?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu ddu ma di, “Ingga ti da inkindirr numa indanda, ùwà tsarr ingga na yi. Ingga ta si da undanda hen, ùwà nggurr ingga na anggi mu?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Mre u Anasi à du ba gri Yesu ni ilo ango yi na kuma ni Kayafa, ankpye unkpi abikye wa ku. ");
INSERT INTO ninNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nggo Sima Biturr kri so vri uru ku na ba, aba gru zhi ma di, “Ùwà mi si su uyirr nu umi ku abiga ma ba hen?” I Biturr à kisa di, “Iya, ingga si se hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Uyirr nu umi ku agarr bi iko yi ankpye unkpi abikye wa a kri nabo. Ugo wama a su umlama a ugo wa nggo Biturr a ttu ku utu ku nggo. A gru da di, “Ingga si hi ùwà na ku ni ila i Olivu yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","I Biturr kisa zizo di, “Iya, a si imu, a si si ingga hen.” Mre agba wa tu. ");
INSERT INTO ninNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ni gambre yi, ani Yahuda ba a gri Yesu zhi ni iko i Kayafa na kuma na ando a ugona anu Roma wa. Na si mirri na ando wa hen. A na meme, wre ba bu gri ukpa umbarr ku zizi, na ka ni ri ila i Iga i Ivu Sarr yi. ");
INSERT INTO ninNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","U Bilatu wa a gru nga na ba na akpla ka, ni zhi ba di, “A la ki imba angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Aba a da ku di, “A ka si na inkindirr hen, inta ka si gru gri ma ni nga nu ùwà ku gigyemi hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatu da ba di, “Imba gri ma ni kuma ku bre ku amu ka ni itsarr imba yi.” Aba a ddu ma di, “Are amba ka a si kpanye di inta bi tsi undurr ngu hen mi.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","(Uwanggo à si meme, wre ku ida i Yesu yi ni itu ittu ima yi bu si meme yo jiji). ");
INSERT INTO ninNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","U Bilatu ka rri kuma ku ji so na ando wa na yo Yesu, ku zhi ma di, “Ùwà yo su uttu a anu Yahuda ba?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","I Yesu a zhi ma di, “Uwanggo yo si izhi muwa yi, ka undurr a bre ku ùwà ure ni itu mungga?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","U Bilatu a da ku di, “Ingga su anu Yahuda? A sa anishirr a imba ba mu na ankpinkpye abikye ba a gri ùwà na nga. Ùwà na ba angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","I Yesu da ku di, “Ittu mungga yi si si ingbingbru inggi yo hen. Ka di i si imimi inggi yo amirr iko mungga ba a taka tsi, wre ba bu si ba ingga nu anu Yahuda ba hen. I ittu mungga yi i zhi nu unto numa mu!” ");
INSERT INTO ninNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","U Bilatu à ka sa di, “Nggi ùwà su uttu mu?” I Yesu à ka sa ku di, “Ùwà mu di ingga su uttu. Ima yo du ba ngri ingga ni ingbingbru yi, di ingga bu ni da ku anishirr ure ujiji. Undurr wa nggo ti kpanye nu ure ujiji ku uwa yo di shirr atu ku ure mungga ku.” ");
INSERT INTO ninNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","U Bilatu à zhi ma di, “Angginggi su ujiji?” Nggo Bilatu à da meme na gru kuma na anu Yahuda ba na ábì, ku da ba di, “Ingga si hi ma ni ikpala hen. ");
INSERT INTO ninNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Imba i hi di iba imba ì da di ingga bu ttu uni kri iharr uyirr ttungo ki imba ni ivi Iga i Ivu Sarr yi. Imba zha di ingga bi ttu ‘Uttu a anu Yahuda’ wa yo ttungo?” ");
INSERT INTO ninNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Aba kisa vo di, “Iya, si su uwa yo hen! Inta zha Barraba mu!” (Barraba à su ugo wa nggo su uni tsi sharri narr igbu ambarr). ");
INSERT INTO ninNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","I Bilatu da ba di a bu gri Yesu kuma ku hlo na amfarr. ");
INSERT INTO ninNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Abi ta iku ba a nyarr intto yarr na ka yo ku ni itu, na ku gri ikpo ankru asisarr ni surr ku, ");
INSERT INTO ninNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","na so nga na ku ni so me̱ ma di, “Inta chi ùwà Uttu anu Yahuda wa.” Na hlo ma na ashishi. ");
INSERT INTO ninNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","I Bilatu gru kanga ni ddu ankpinkpye ani Yahuda ba di, “Imba kye, ingga ta gri ma ssuzzu ki imba ziza nggo, ni ima mi imba bu hi krizhizhi mi di ingga si vu ma ni ikpala hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","I Yesu huzzu na surr intto yi ni itu ikpo ankru sisarr yi. I Bilatu ddu ba di, “Kye! Ugo wanggo nggo!” ");
INSERT INTO ninNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nggo ankpinkpye abikye ba na abi gbye Uki ku Ibarr ku a hi ma na hantu di, “Kpa ma! Kpa ma!” U Bilatu ddu ba di, “Imba ku kpa ma na akpambirr yi. Ingga si vu ma ni ikpala hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Anu Yahuda ba a kri karrkarr mi di, “Inta se ni iba yi nggo i da da a bu ttu, nggo a da du uwa su Uvuvurr a Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nggo Bilatu a wo meme, i isisu ki ma kakami. ");
INSERT INTO ninNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Uwa ka rri kuma na ando wa, ku zhi Yesu di, “Ùwà zhi nu momo nggo?” I Yesu si sa ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","U Bilatu da di, “Ùwà kà i re yi ni ingga ku? Ùwà si hi di ingga se nu ukyekye ki kpa ùwà ttungo nu ukyekye ki du ba a ngu ùwà hen?” ");
INSERT INTO ninNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu a ddu ma di, “Ukyekye ku nggo ùwà se na ku ni itu mungga su ukyekye ku nggo Abachi nggo nu ùwà. Undurr wa nggo à ba ingga nu ùwà, uwanggo su uni la ure wa kakami.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nggo Bilatu wo meme, na gru ta ukpa du uwa ta zha anko a ttu Yesu ttungo du à kuma, anu Yahuda ba a kisa di, “Ùwà ti du ugo nggo kuma, ùwà si su ukpama a Kayisa zizo hen! Undurr wa nggo ti ba du uwa su uttu, undurr uwama à si kpanye ni Kayisa ku hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nggo Bilatu à wo ba ni ko re yi meme, na gri Yesu ssuzzu, na hun so ni Igbre Ingbinta Ibre Amu yi. (Ni irrirri i Ibraniya, unto kuma u ri “Gabata”.) ");
INSERT INTO ninNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A si na azhi na atsutsu na azhibarr wa nggo a ta zzu na ambre ka na na Iga i Ivu Sarr. U Bilatu à ddu anu Yahuda ba di, “Kye uttu amba wa nggo!” ");
INSERT INTO ninNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Aba kà na hantu di, “Ngu ma! Ngu ma! Kpa ma!” U Bilatu à zhi ba di, “Imba zha di ingga bi kpa uttu amba wa?” U ankpinkpye abikye ba a da ku di, “Uttu munta wa nggo i su u Kayisa na nkpama!” ");
INSERT INTO ninNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","U Bilatu à ba Yesu nu abi ta iku ba di a bu kpa ma ngu. Aba kpa ma na kuma. ");
INSERT INTO ninNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Uwa gri unkunkurr ku garr gi garr umaku na kpa ma ssuzzu nu umi igbu ku na kuma nu “Unto ku Ukpahe Itu ku,” (nggo a yo ku ni irrirri i Ibraniya du, “Goligota.”) ");
INSERT INTO ninNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na kuma ku kpa ma nabo, na kpa abayi banu aha ndo na ku. Uyirr wa nu ungo ri, u unuma wa nu ungo mla, i Yesu na atsutsu. ");
INSERT INTO ninNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","U Bilatu du ba charr ikpala ima yi ko ku klo ku ni itu i unkunkurr umaku du: YESU ANU NAZARETI, UTTU A ANU YAHUDA WA. ");
INSERT INTO ninNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","A charr ni irrirri i Ibraniya, tuku irrirri i Latini tuku Girrki. Unto ku nggo a kpa Yesu u si hinga nu umi ìgbù, u anu Yahuda ba shishemi a bre icharr yi hi. ");
INSERT INTO ninNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ankpinkpye abikye ba a kisa ku Bilatu da à bu si charr du “Uttu a anu Yahuda” hen, da a bu charr du, “Ugo nggo da du uwa nggo su Uttu a anu Yahuda.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatu ddu ba di, “Inkindirr yi nggo ingga charr, ingga ka charr yi ba.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nggo abi ta iku ba a kpa Yesu kre na ba ikpo ankru ima yi nggarr ki anga ane̱, ga ki ikpa aba ane̱ mi. Na ba ankru ama ka umi ka, nggo a ru ka su upri uyirr yo zhi na atu nga na achi. ");
INSERT INTO ninNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Abi ta iku ba ddu ikpa di, “Inta bu si nga ankru angga ka hre hen. Di inta turr ni kye undurr wa nggo ta kpa ka.” Ure kuma u si meme nâ ta si nggo a charr nu ungbamvu di, “A ba ankru mungga ka ga ki ikpa na ba ankru mungga a turr.” U abi ta iku ba a na ma nâ ta si nggo a charr na angbamvu ka Abachi. ");
INSERT INTO ninNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ayirr wa, tuku uvayirr a ayirr wa, ni Maryamu ayamba a Klopa, ni Maryamu wa nggo a zhi nu Magadala a kri hinga nu unkunkurr ku garr gi garr ku a kpa Yesu nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nggo Yesu hi ayirr ama wa tuku uniga ma wa nggo à kpanye na ku kakami nggo a kri ywhiywhirr mi, na ddu ayirr wa di, “Ayamba, kye uzumi wanggo.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Uwa ddu uniga ma wa di, “Kye ayirr amuwa nggo.” Bazhi ni ima nggo, u uniga wa à ba ayirr a Yesu wa du ma ku so ni iko ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nggo Yesu à hi du uwa à kre undu umaku ba, na da di, “Uhre ki ingga.” À da meme, wre ku icharr i angbamvu ka Abachi ka i bu si jiji. ");
INSERT INTO ninNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Itsa numa i kri nu ususa ahi nabo. Aba ba usoso a yo na wa na ka harr nu unflankurr ku nggo a yo ku di hiso, ná nà hun ko ku Yesu na angu. ");
INSERT INTO ninNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nggo Yesu la ahi wa kye na da di, “A kre ba!” Na ki itu nggi na ttu. ");
INSERT INTO ninNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nggo anu Yahuda ba si kpanye da aku wa bi klo meme ni inkinkurr yi ma na Azhibarr a Isu wa hen, anu Yahuda ba ku barr Bilatu di a bu du ba ku mɨ ba aza ka, na ddu aku wa glo. Uwa si na azhibarr wa nggo a ko ssu atutu ka Iga i Ivu Sarr yi, unu uha wa ta su ku anu Yahuda ba Azhibarr a Isu ambarr ankpi wa. ");
INSERT INTO ninNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Mre abi ta iku ba a nga ni mɨ aza ka ugo unuma wa nggo a kpa hinga ni Yesu ku nggo. Na mɨ aza ka uyirr wa meme. ");
INSERT INTO ninNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nggo a nga ni Yesu ku na a ni hi ma uwa ka ttu ba, aba si murr ku uza hen. ");
INSERT INTO ninNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Uni ta iku numa wa su ku itankparr nu usa, u ayiyi na amasirr a huzzu. ");
INSERT INTO ninNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Undurr wa nggo à kri nabo na hi inkindirr ima yi na ashishi ama, uwa yo à bre. Are ka nggo à bre ki imba a su jiji, na hi du uwa à ko da su ure ujiji, na bre ka di imba bu kpanye ni ga ma.) ");
INSERT INTO ninNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Aseki ka a zirr meme nâ ta si nggo ungbamvu ku Abachi ku u da nggo di, “A si ta murr uttuttu uma uyirr hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","U ungbamvu numa ku u da di, “A taka kye uwanggo wa nggo a turr ma nggo.” ");
INSERT INTO ninNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nggo a hi di Yesu a ttu ba u Isuhu nggo zhi nu Arrimatiya ko ku barr Bilatu di a bu nu uwa iku i Yesu kpa ku zzu. (Isuhu a su nu umi ku abiga na yi ba nggo di kru anu Yahuda ba). Nggo Bilatu kpanye ku, uwa ku ttu iku i Yesu yi glo. ");
INSERT INTO ninNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","U Nikodemu, uwanggo nggo a ka nga ni Yesu ku ni ibittu yi nggo, à ga Isuhu. Aba gri àgà a inkinkurr yi nggo a yo yi di mârr, tuku unuma ku nggo a yo ku di alosi, du ba ta ni gbo ku iku i Yesu du yi si kaki ndanda hanhan hen. Àgà wa ka a rɨ ma atu ima ankpinkpi aha mu. ");
INSERT INTO ninNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Anishirr aha angga ba, a ba iku i Yesu yi nyarr nu upri inkru kukla ku nggo a di nyarr iku na ku, na so bu surr àgà unkunkurr wa, nâ ta si nggo anu Yahuda ba di zzu unushirr nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ila numa i se ywhiywhirr mi nabo nu unto ku nggo a kpa Yesu. Ni ila ima yi aba a ya ibe numa nggi he̱he̱ mi nggo a nise na undu kye na yi. ");
INSERT INTO ninNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nu nggo a so ssu atutu ku Azhibarr a Isu Anu Yahuda wa, aba a ba iku i Yesu zzu ni ibe ima, nu nggo ibe yi i se ywhiywhirr mi nabo. ");
INSERT INTO ninNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na azhibarr a ime̱me̱ wa nu ugo ki iga ku, u Maryamu nggo zhi nu Magadala à gru han kuma ni ibe yi, abubo wa ni ko shi ibwu. Nggo a ko ku hi ba a ka ba ingbinta yi glo na angu ka ibe ka ba. ");
INSERT INTO ninNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Na kru ko ku da ku Sima Biturr ndo tuku uniga unuma wa nggo Yesu à di kpanye na ku di, “A ba Atiko wa nado ni ibe yi, inta si hi unto ku nggo a zu ma hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Mre i Biturr tuku uniga unuma wa kru na kuma ni ibe yi. ");
INSERT INTO ninNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A so kru ki kru aha mi, uniga unuma wa kru mri Biturr na ku rri ni ibe yi kuchi. ");
INSERT INTO ninNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nggo à ji kinggi na kye rri kuma nu upri inkru kukla ku nggo kurr nabo nggo, na si rri kuma nu umi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","I Sima Biturr, nggo à su ku nu ugo uma, kru na kuma ku tsi rri kuma nu umi ki ibe ku. Na ko ku hi upri inkru kukla ku yo ù kurr. ");
INSERT INTO ninNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Na hi upri ku nggo a nyarr ku na ku ni itu. Upri ankru ku a nyarr ku zu na nkpama, na chi ku zu nanka nu unuma ku. ");
INSERT INTO ninNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Uniga numa wa nggo a kru rri ni ibe yi kuchi a mirri ko meme, na ku hi na kpanye. ");
INSERT INTO ninNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ni ima mi aba a nise ssu hi unto kuma nu ungbamvu ku nggo u da di Yesu taka tasi nggo.) ");
INSERT INTO ninNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Abiga ma ba a kakuma ni iko. ");
INSERT INTO ninNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryamu nggo zhi nu Magadala à kri ni ibe yi so yi na abi ka. À so yi nggo, na ji klo kye rri kuma ni ibe yi ");
INSERT INTO ninNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","na hi abitu ba Abachi aha a surr iki ikikla a so nu unto ku nggo a ka Yesu yo nggo, uyirr wa ni itu u uyirr wa na aza. ");
INSERT INTO ninNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aba zhi ma di, “Ayamba, ùwà so yi angginggi?” Uwa da ba di, “A ka ba Atiko mungga wa nado ba, ingga si hi unto ku nggo a zu ma hen!” ");
INSERT INTO ninNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nggo Maryamu à da meme na kasarr na hi Yesu à kri nabo, na si hi da a si Yesu hen. ");
INSERT INTO ninNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","I Yesu à zhi ma di, “Ayamba, ùwà so yi anggi mu? Ùwà ko zha unggonggo?” Uwa kye di à su uni di kye inkinkurr ni ila yi mu, na zhi ma di, “Ankpye, ùwà ti ba ma glo, ùwà da ki ingga unto ku nggo ùwà ka ma zu, ni di ingga ku ba.” ");
INSERT INTO ninNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","U Yesu gru yo ma di, “Maryamu!” Uwa kasarr kye ma na da na ako ambarr ka, ni irrirri i Ibraniya di, “Raboni!” (A si di “Unitsarr.”) ");
INSERT INTO ninNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu ddu ma di, “Si so re̱ ingga gri hen. Kye ingga nise hun kuma na Aki ku. Iya, kuma ku da ku amuyirr amungga ba di, ‘Ingga taka kuma na Aki mungga wa nggo sa Aki amba meme, nggo sa Abachi mungga na Abachi amba meme.’ ” ");
INSERT INTO ninNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryamu, nggo zhi nu Magadala, à wo meme, na kuma na abiga ma ba, ku da ba di, “Ingga hi Atiko wa!” Na da ba inkindirr yi nggo Yesu a da ku. ");
INSERT INTO ninNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ni ingbahru yi na azhibarr ama wa, abiga ba a rri so nu uki na han anko wa kru anu Yahuda ba. Mre, aba kakye Yesu kukri ba na atsutsu na da ba di, “Isu isisurr ku imba yi!” ");
INSERT INTO ninNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nggo à da meme nggo na tsarr ba inkpa ango ima yi, nu usa ku, abiga ma ba a nyarr kakami nggo aba hi Atiko wa nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu à da zizo di, “Isu isisurr ku imba yi! Nâ ta si nggo Aki mungga wa a tu ingga, ingga ko tu imba ngga ziza.” ");
INSERT INTO ninNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nggo a da meme na ttu unddunddu surr ba di, “Imba kpa Izhi Iwre yi. ");
INSERT INTO ninNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Imba ti nggurr ila ure i unu zhi ku, aba a ta nggurr zhi ki imba. Imba ta si nggurr zhi ku unu hen, aba si ta nggurr zhi ki imba hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma (nggo a di yo ma da Didimo, nggo ri Amuhe̱) nggo à su uyirr nu umi ku abiga ma awurr na aha ba, a sama na ba nggo Yesu a nga nggo. ");
INSERT INTO ninNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nggo à ku nga nggo inkpu yi ni ko da ku di, “Inta hi Atiko wa!” U Toma à da di, “Ingga si kpanye nu ure umba ku hen. Ingga ti hi ma, ni hi ku aywirr ka na ango, ni yo ivirr ungo na aywirr ka inkpu inklo ka, tuku nu usa ku bari ingga ta kpanye.” ");
INSERT INTO ninNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nu utangba wa abiga ba a rri so nu uki zizo, u Toma a se na ba. Aba han anko ka. Nu nggo anko ka à kurr ni ihan mi, i Yesu à nga na kukri na atsutsu ambarr, na da di, “Isu isisurr ku imba yi.” ");
INSERT INTO ninNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Na ddu Toma di, “Yo uvuvurr ungo muwa yi nu unggo mungga ku. Yo ungo muwa ku nu usa mungga ku kye. Si na isisurr muwa yi di yi tsi nanka hen, kpanye!” ");
INSERT INTO ninNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","U Toma da di, “Atiko amungga na Abachi amungga!” ");
INSERT INTO ninNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Mre i Yesu à ddu ma di, “A su nggo ùwà hi ingga, ima yo du ùwà kpanye. Abangga ba nggo a nise hi ingga na ka na kpanye ni ingga ku Abachi à ta yo ba angu azizi!” ");
INSERT INTO ninNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu à na iki i ikagri inuma shishemi na ashishi ka abiga ma ka, nggo aba a si charr ka nu ungbamvu ku unggo ku hen. ");
INSERT INTO ninNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Uwa ta si are angga ka na anko, a charr ka wre ki imba bu kpanye di Yesu à si Kristi, Uvuvurr a Abachi. Ni bu hi di imba ti kpanye na ku, imba ta kpa iso tsitsirr ijiji ni isa ima yi. ");
INSERT INTO ninNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nu ugo ukuma i Yesu à gri itu ima ku tsarr abiga ama ba zizo nu unddu inyi nu Tiberriya. Itsarr ima inggi ì si ma mi: ");
INSERT INTO ninNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","A sa azhibarr numa nggo Sima Biturr, Toma, (nggo a di yo ma da Didimo, nggo ri Amuhe̱), u Nataniya, nggo zhi nu Kena na anga ka Galili ka, na amumarr ba Zabadi ba aha mi, na abiga aha banu a si ndo. ");
INSERT INTO ninNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","I Sima Biturr gru ddu ba di, “Ingga ko ivu ikikla.” Inkpu yi da di, “Inta mi ta ga ùwà.” Na gru ga ma ku rri nu uddu ku. Na ku so tirr ikikla nggarr ambre na si vu inkindirr ni ibittu ima yi hen. ");
INSERT INTO ninNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ni igambre yi, i Yesu nga nu unddu inyi ku, abiga ma ba a kye ma ssurr. ");
INSERT INTO ninNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","I Yesu zhi ba di, “Akpukpamburr, imba vu anggi?” Aba di, “Inta si vu inkindirr hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Uwa ddu ba di, “Imba yo azhizhi amba ka na anga a ungo ri a uddu wa, imba ta vu inkindirr.” Mre aba a tu azhizhi ka surr na gba ka kanga chankarr, nu nggo azhizhi ka a vɨ ikikla shishemi. ");
INSERT INTO ninNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Uniga unuma wa nggo Yesu di kpanye na ku kakami nggo à ddu Biturr di, “A sa Atiko yo!” Nggo Sima Biturr à wo da a si Yesu, na ba ankru kama ka (nggo à ttu ka zu ko na undu ku) na vu ka nyarr nu ukpa, na tu rri na amasirr wa. ");
INSERT INTO ninNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Abiga abanu ba nggo a so nu uddu ku a so darr uddu ku nga na ábì, na gba azhizhi ka ssuzzu ni ikikla nu umi pwi. A si kri ta anko mu zhi na ábì ka hen, a ka ma imita ayirr yirr. ");
INSERT INTO ninNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nggo abiga ba a ssuzzu nu uddu ku nggo na ni hi unfonfo tuku ikikla na akikla uru. ");
INSERT INTO ninNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","I Yesu ddu ba di, “Imba ttu ikikla yi nggo imba vɨ ga mi.” ");
INSERT INTO ninNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","I Sima Biturr à rri nu uddu ku na ku gba azhizhi ka ssuzzu nga na ábì. Ikikla inkpinkpi ima i sa ayirr uyirr ni iso ikywi ni itarr (153), u azhizhi ka si tse̱ hre hen. ");
INSERT INTO ninNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","I Yesu yo ba di, “Imba nga ni ri yi.” Isisu i ki ba, uyirr mi na abiga ba à si zhi ma di, “Ùwà su unggonggo?” hen, nggo aba mi a hi da a sa Atiko yo. ");
INSERT INTO ninNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu à ba unfonfo wa a gri nu ungo uma na ka ma nu ba. Na ba ikikla wa mi gri na ka ma nu ba. ");
INSERT INTO ninNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uwama a si inkpo itarr nggi nggo Yesu à ko tsarr abiga ba itu ima yi nu ugo ki ittu umaku. ");
INSERT INTO ninNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nggo a ri kre, i Yesu yo Sima Biturr di, “Sima, uzuma a Yohana, ùwà kpanye ni ingga ku jiji mri abanu ba?” Uwa da di, “A si meme yo, Atiko, ùwà mi hi di ingga kpanye nu ùwà.” I Yesu ddu ma di, “Ho amumarr aminta amungga ba.” ");
INSERT INTO ninNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","I Yesu yo ma zizo, “Sima uzuma a Yohana, ùwà kpanye ni ingga ku jiji mu?” Uwa da di, “Atiko, ùwà hi di ingga kpanye nu ùwà ku.” Yesu ddu ma di, “Kye ki ingga aminta mungga ba.” ");
INSERT INTO ninNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu a zhi ma inkpu itarr yi zizo di, “Sima uzuma a Yohana, ùwà kpanye ni ingga ku?” I Sima na ki ivri isisurr nggo Yesu ko zhi ma inkpu itarr nggi di, “Ùwà kpanye ni ingga ku?” I Biturr ddu da, “Atiko, ùwà hi aseki ka we. Ùwà hi di ingga kpanye nu ùwà.” Yesu ddu ma di, “Ho aminta mungga ba. ");
INSERT INTO ninNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nu nggo ùwà ni di su uvuvurr nze, ùwà di ba unggakpa muwa ku murr na anklampi, ni di kuma nu unto ku nggo isisurr muwa yi da ku ùwà. Ni ivi yi nggo ùwà ti ka chě nggo, ùwà ta gɨ ango ki tsa unuma mu ta gbyarr ku ùwà ankru amuwa ka, na gri ùwà kuma nu unto ku nggo ùwà si du ùwà ta ko hen.” ");
INSERT INTO ninNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesu à da meme, ni itu i ittu yi nggo Biturr à taka ttu na taka nu isa i Abachi yi inkpinkpye.) Na ddu Biturr di, “Ga mi!” ");
INSERT INTO ninNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Biturr à kasarr na hi uniga wa nggo Yesu à kpanye na ku nggo, uwa à so ga ba. (À su uyiyirr uwama yo nggo à so hinga ni Yesu ku na abubo a iri ila wa, na zhi ma di, “Atiko, unggonggo ta vu ùwà re?”) ");
INSERT INTO ninNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nggo Biturr kakye ugo na hi ma nggo na zhi Yesu di, “Atiko, uwanggo wa na?” ");
INSERT INTO ninNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu à ka sa ku di, “Ingga ti di à ta so tsitsirr ma ni inga imungga yi, angginggi imuwa nu umi? Ùwà bu ga mi!” ");
INSERT INTO ninNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aba gru di bre ku abiga ba kago du uwama si taka ttu hen. I Yesu a si da meme da à si taka ttu hen. A da di, “Ingga ti di à ta so tsitsirr ma nu unga imungga yi, angginggi imuwa nu umi?” ");
INSERT INTO ninNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","A si uniga wa nggo à re ni itu i aseki angga ka, uwa yo à charr zu, inta hi di inkindirr yi nggo à da ì si ijiji. ");
INSERT INTO ninNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu à na aseki anuma shishemi zizo. Ka di a charr ka zu namri, ingga kye ingbingbru yi we ka si ma isurr angbamvu ka we nggo a ka charr ka hen.");
INSERT INTO ninNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyofilo, Ingga i charr ku ùwà nu ungbamvu mungga ku me̱me̱ ku aseki ka nggo Yesu à gru di na ni ime̱me̱ yi, na di tsarr anishirr ");
INSERT INTO ninNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ma na azhibarr wa nggo a ba ma na hun kuma nu unkplassu. Nggo a nise ba ma hun kuma nu unkplassu, Izhi Iwre yi i du ma tsarr abi ko na angu ama ba nggo à hla ba nggo, inkindirr yi nggo a ta na. ");
INSERT INTO ninNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nggo Yesu à ki iha yi kre, na gri itu ima ku tsarr anishirr angga ba na tsarr ba aseki angga ka nggo a ta du aba mi a hi di Yesu à si tsitsirr. Yesu à gri itu ima di tsarr ba ki ivi iso ne̱s na so di re ba are ka Ittu i Abachi yi. Abi ko na angu ba a hi ma. ");
INSERT INTO ninNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Na ankpu numa nggo uwa so ri ila na ba, na ttu ba ukorr da di, “Si gru share nu Urushalima yi hen. So bi inkindirr yi nggo Aki amungga wa à da di uwa taka ni imba nggo. Imba i wo ingga i re ki imba ni itu i inkindirr ima yo. ");
INSERT INTO ninNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohana a zzu imba na amasirr, ingga so da ki imba di a ji ivi ntsɨmi aba ta zzu imba ni Izhi Iwre.” ");
INSERT INTO ninNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Uwa a si meme yo abi ko na angu ba a nga ni nggurr bi ni inkla iyirr nggo na zhi ma da di, “Atiko, ùwà ta ba ittu yi ka nu anu Israila ba ziza yo?” ");
INSERT INTO ninNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Yesu a ddu ba da di, “Ivi yi na attuttu wa nggo Aki wa a zu ni inkpinkpye ima yi a si si inkindirr ihi imba hen. ");
INSERT INTO ninNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Nggo Izhi Iwre yi à ti nga ni imba ba, uwa ta ni imba ukyekye, imba ta si abi da ku anishirr inkindirr yi nggo imba ihi nggo nu Urushalima tuku Yahudiya tuku Samarriya tuku ingbingbru yi kago we.” ");
INSERT INTO ninNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nggo Yesu à da meme mre, aba a ba ma na ashishi ambarr, a akpa a ttu ma nado, aba si hi ma hen. ");
INSERT INTO ninNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Abiga ma ba a kri so kye yoyo hun kuma nu ussu uwa so kuma. Mre aba gru ka kye anishirr aha a surr iki ikikla a kukri ba na anga yirr, na a ddu abiga ma ba ");
INSERT INTO ninNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","di, “Anu Galili, imba kri so kye angginggi hun kuma nu ussu. Yesu uyirr yirr wanggo a ba ma glo ni imba ba hun kuma nu unkplassu, a taka ka nga meme yo nâ ta si nggo imba i hi ma so hun kuma nu unkplassu nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mre abi ko na angu ba a ji ni igbigbu yi nggo a yo yi di Olivu. I ta i anko yi zhi nabo kuma nu Urushalima ka ma mita ukrɨ yirr na ayirr yirr (1,100). ");
INSERT INTO ninNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","A kanga nggo na ni hun kuma nu uki, ni iko issu yi nggo a ku di so nggo. Abangga ba nggo a se nabo a si ani Biturr, u Yohana, u Yakubu tuku Andoro, i Filibu tuku Toma. Abanu ba a si anu Batolomi, u Matiyu, i Yakubu, uvuvurr a Alifiyo, u Sima nggo à se na amarr ka ako ambarr ka kakami, tuku Judasi uvuvurr a Yakubu. ");
INSERT INTO ninNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","A nggurr bi wemi na amba ba na ku so di barr Abachi ttuttumi na anu Maryamu ayirr a Yesu, na amuyirr abi Yesu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","A ki ivi ntsɨmi na na issubi i abiga. (A ka ma anishirr ayirr yirr ni iso iha (120).) Biturr à gru kri, ");
INSERT INTO ninNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","na ddu ba di, “Amuya abiga, Ungbamvu ku Abachi ku u ta na inkindirr yi nggo Izhi Iwre yi i da na angu ka Doda ni itu i Judasi Iskariyoti nggo à gri abi vu Yesu ba ni tsarr ba na ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yahuda à si ni inta ba nu undu ku nggo a di inta bu na ku nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yahuda à kpa inklo i umimi ima yi ku re īlá, na ji jaku nabo yo na ttu. Ine ima yi nggarr arire̱ ka a ssuzzu. ");
INSERT INTO ninNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Anishirr bu Urushalima ba we a wo ure unggo ku kago, na ka di yo īlá yi na ako ambarr ka di Akelidama, di i si “Īlá i Ayiyi.”) ");
INSERT INTO ninNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Biturr à da di, “A charr nu Ungbamvu ku Asarr ka Igbyarr Asa di, “ ‘A bu kà iko ima yi du, undurr bu si du uwa ta ku so na yi hen.’ A charr zizo di, “ ‘A bu du undurr a ba inkpinkpye ima yi.’ ");
INSERT INTO ninNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ni ima yo, i wre inta bu ttu unuma nggo a ta sarr ba inkla i Yahuda Iskariyoti yi. A bu su uyirr nu umi ku anishirr angga ba nggo a di se ni inta ba, ni ime̱me̱ yi nggo Atiko Yesu wa à di zirr kago ni inta ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Bazhi nu nggo Yohana à zzu Atiko Yesu na amasirr nga nu nggo a ba ma hun kuma nu unkplassu. Uyirr nu umi ku abangga ba nggo a ta ku zi inta da ku anishirr di, Yesu à tasi ni ibe.” ");
INSERT INTO ninNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","A gri asa a anishirr aha: Isuhu nggo a di yo ma di Basaba (isa inuma yi i ri Yustu), na gri isa i Matiya. ");
INSERT INTO ninNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nggo na barr Abachi di, “Atiko, ùwà i hi isisurr i anishirr namri. Tsarr inta uyirr wanggo nggo ùwà i ttu ma nu umi ku anishirr aha angga ba nggo ");
INSERT INTO ninNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","à ta ba undu ku abi ko na angu ku nggo Judasi Iskariyoti à kaku du na kakuma ni inkla nggo à zhi ma.” ");
INSERT INTO ninNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mre aba a mɨ ankinka a ki na bre kye, u Matiya nggo a ri. Nggo aba du ma à rri na abi ko na angu awurr na yirr ba ba. ");
INSERT INTO ninNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Uwa a si na azhibarr Iga i Pentiko yi abiga ga Yesu ba a ku so ni inkla iyirr. ");
INSERT INTO ninNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nggo mre na gru wo i inkindirr i yi zhi nu unkplassu nâ ta si unddunddu unkpi, iyi yi i tsarr ssu nu iko yi nggo a so nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Aba a hi inkindirr izzu nâ ta si irrirri iru i ji ga so ku so ku abiga ba na yiyirr na atu. ");
INSERT INTO ninNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Izhi Iwre i tsarr ssu na ba wemi, aba a gru so re irrirri na nkanka. ");
INSERT INTO ninNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ni ivi ima, ani Yahuda nggo a di kru isisu i Abachi na zhi ni igbu yi na nkanka a di so nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nggo a wo iyi i unddunddu yi akpa anishirr a nggurr bi. A ku ayisurr nu nggo a wo ba a so re na ako ambarr. ");
INSERT INTO ninNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na zhi da di, “Anishirr angga ba wemi a si di re ni irrirri i nu Galili hen? ");
INSERT INTO ninNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","A si anggi mu inta wemi i wo ba a so re ni irrirri imunta? ");
INSERT INTO ninNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Inkpu munta yi a zhi nu Patiya, u Mediya tuku anu Elamu, na abi zhi nu Mesopotamiya, u Yahudiya tuku Kapadosiya, abi zhi nu Ponto, tuku Asiya, ");
INSERT INTO ninNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","na abi zhi nu Frigiya tuku Pamfiliya, na abi zhi nu Masarr tuku igbu i Libiya nggo si hinga nu Sirrene. Amunta abanu ba a zhi nu Roma. ");
INSERT INTO ninNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Abi na ani Yahuda ba tuku abangga ba nggo a ttu anko a iga ambarr wa ttungo na kanga ni rri ni iga i ani Yahuda yi. Inkpu munta yi a zhi nu Kreti tuku Arrabiya, inta i wo ba a so bre ni irrirri imunta aseki ka ku ayisurr ka nggo Abachi à na ka!” ");
INSERT INTO ninNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ayisurr a jaku ba aba a zhi ikpa da di, “Ina inggi yi i da di angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Anishirr abanu a sarr are na ba da di zhinu a so hwa sa ahi. ");
INSERT INTO ninNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Biturr à gru kri na abiga Yesu awurr na yirr ba na re ba nu ukorr unkpi da di, “Amuya mungga ani Yahuda, ni imba nggo so nu Urushalima, di ingga bre ki imba aza ka inkindirr inggi yi. Shirr atu zizi yi ni wo inkindirr yi nggo ingga i ta da. ");
INSERT INTO ninNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Imba i kye di anishirr angga ba a hwa ahi. A si si meme hen. A ni si ikarrfe itirr i ambre mu bari. ");
INSERT INTO ninNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ina inggi yi si inkindirr yi nggo uni kpa are Abachi wa Jowe à da nggo: ");
INSERT INTO ninNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Abachi à da di, ni ivivi ikikre yi, ingga ta ka Izhi imungga yi i ka surr ku anishirr we. Amumarr aniru na áníwá a ta kpa are ka Abachi ka da ki imba. Amumarr nze amba ba a ta rri ala, Achiche anishirr amba ba a ta gru rri ala. ");
INSERT INTO ninNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ni ivivi ima, ingga ta ka Izhi mungga yi i surr ku agarr amba na aniru aba a ta kpa are ka Abachi so bre. ");
INSERT INTO ninNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ingga ta tsarr ikagri nu unkplassu ni ta na aseki ka i ku ayisurr ni imimi. Ayiyi tuku uru tuku intsi a ta se ma. ");
INSERT INTO ninNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Azhi à la wa à ta shi ibwu, uhwa ku u ta kaki ayiyi bari azhibarr ankpi wa nggo Atiko wa à ta kanga nggo a taka ma. ");
INSERT INTO ninNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Meme nggo undurr uwanggo à ti yo isa i Atiko wa, aba taka kpa ma ttungo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Anishirr imba bu Israila wo ure nggo ku! Yesu nggo zhi nu Nazareti à su unushirr wanggo imba i hi krizhizhi undu ku nggo Abachi a nu ma. A na aseki a ka ku ayisurr na ka ikagri, imba mi i hi ka. ");
INSERT INTO ninNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Abachi nggo a ba ugo nggo ni imba ni ihi ima. Anishirr amimi a zi imba klo ma nu unkunkurr, uwa ttu. ");
INSERT INTO ninNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Abachi à ddu ma ttungo na ango ka ittu na ta ma si. I ittu si hru ma nu ukyekye hen. ");
INSERT INTO ninNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Doda mi à re ni itu i Yesu da di, “ ‘Ingga i hi Atiko wa, uwa di si ni ingga ku ttuttumi. À kri ki ingga nu ungo ri, isisu ì si ta ki ingga hen. ");
INSERT INTO ninNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ni itu ima yo, ankpi are amungga ka a tsarr ssu ni inyarr, isisurr mungga yi ta se ni inyarr, ukpa mungga ku mi ù ti ttu, ingga yo isisurr di ingga ta so tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nggo Atiko à du uwa si ta kà ingga du ku abubo a iso abi kɨ wa hen, na si ta du Uni wre muwa wa à bo ni ibe hen. ");
INSERT INTO ninNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ùwà ka tsarr ingga anko nggo ingga ta zirr ba ma, ni ta di du ingga nyarr na age̱ amuwa.’ ");
INSERT INTO ninNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Amuya, ingga ta da ki imba sama ni ikru inkindirr da ábáchí amunta wa uttu Doda à ttu, aba zzu ma, ibe ima yi i se ni inta ba ari. ");
INSERT INTO ninNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Uwa à su uni kpa are ka Abachi na à hi di Abachi à shi azhi du uwa taka ba uhanma numa a sa ni ittu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Doda à hi inkindirr yi nggo i so nga ni ichi. Ima yo i du ma à re di Kristi a ta tasi. A si ka ma du na abubo a iso abi kɨ wa hen, ukpa umaku u si bo hen. ");
INSERT INTO ninNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Abachi à ka gɨ Yesu gru tsitsirr ba. Inta mi i hi ure ukuma. ");
INSERT INTO ninNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","A nu Yesu inkpinkpye nu ungo ri ku Abachi. Uwa kpa Izhi Iwre yi nggo Abachi à da du uwa à taka ni nggo. Yesu à surr ki imba Izhi ima yi nggo imba i ko wo ni ko hi. ");
INSERT INTO ninNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Doda nggo à si hun kuma nu unkplassu mi hen, à da di, “ ‘Atiko wa à ddu Atiko amungga wa di: “Ji so ki ingga nu ungo ri mungga ");
INSERT INTO ninNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","di ingga ka abi karr ùwà ba ki inkindirr yi nggo ùwà ta vu aza sa nggo.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Meme nggo Israila a bu hi di Yesu wanggo nggo imba i kpa ma nu unkunkurr, Abachi à na ma ki Atiko na na ma ki Kristi!” ");
INSERT INTO ninNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nggo anishirr ba a wo meme, inkindirr yi i tsutsarr ba ni isisurr a ba a zhi ani Biturr na abi ko na angu abanu ba da di, “Amuya, inta ta na kingginggi?” ");
INSERT INTO ninNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Biturr a ddu ba di, “Ttu anko nggo imba so ga wa ttungo, ni du ba a zzu imba namri na amasirr ni isa i Yesu Kristi, nggo a ta nggurr ila ure imba yi zhi. Meme nggo imba ta kpa Izhi Iwre yi. ");
INSERT INTO ninNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Abachi à da inkindirr inggi yi zu ki imba na amumarr amba, na anishirr wemi nggo se gbagba mu Atiko Abachi amunta wa à yo ba nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Biturr à gba ba utu na are numa shishemi, na tsi ba ango di, “Imba du ila ure imba yi ni du Abachi kpa imba ttungo ku inkindirr yi nggo taka kuttu amimi anishirr bi ingbingbru ba nggo!” ");
INSERT INTO ninNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","A zzu abangga ba nggo a kpa ure umaku nggo na amasirr. Na azhibarr ama anishirr a ma ukrɨ utarr (3,000) a ku ki ku abiga ba. ");
INSERT INTO ninNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Abiga ba a so di zha da aba a ta hi aseki ka nggo abi ko na angu ba a ta tsarr ba nggo, na di so di nggurr atu bi ni i ri bi tuku ibarr Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Abi ko na angu ba a na aseki ka ku ayisurr na ka ikagri, isisu ì ki anishirr ba we. ");
INSERT INTO ninNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Abiga ba wemi a nggurr bi na so di ga aseki ka narrnarr. ");
INSERT INTO ninNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","A vu aseki ambarr ka re, na kpa inklo yi ni nggurr bi bari, na vu ga ku abangga ba nggo a zha chankarr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","A di kuma nu Uki Unkpi ku Ibarr Abachi ku ni ivivi yi. Na di ri bi na nyarr na aseki ka ni isisurr iyirr. ");
INSERT INTO ninNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","A di ru ku Abachi asarr, anishirr we a kpanye na ba. Abachi à di nu ba abiga ahe̱he̱ ni ivi yi. ");
INSERT INTO ninNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Azhibarr numa, nggo azhi wa à ma ikarrfe itarr, na ma ibarr, i Biturr tuku Yohana a gru so kuma nu Uki Unkpi ku Ibarr Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ugo numa à mɨ aza zhi nggo a ngri ma mu, aba ba ma ku zu na angu ankonki ka Uki ku Ibarr Abachi ku nggo à yo ka di Ankonki a Iwre wa. A di ba ma ni ivi yi nga ni zu wre ku à bu barr anishirr a bi so rri ba inklo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nggo à hi anu Biturr tuku Yohana a so mirri nu Uki ku Ibarr Abachi ku na barr ba inklo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","A kye ma, i Biturr à ddu ma da di, “Kye inta na!” ");
INSERT INTO ninNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Uwa gɨ ashishi kye ba na kye di a ta nu ma inkindirr. ");
INSERT INTO ninNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Biturr à ddu ma da di, “Ingga sama ni inklo, ima yo di ingga ta nu ùwà inkindirr yi nggo ingga i se na yi nggo. Ni isa i Yesu Kristi nu Nazareti, gru kri ni zirr!” ");
INSERT INTO ninNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nggo Biturr vu ma nu ungo ri, na gɨ ki tsa, mre aza ama ka na agbuzzu a kaki kyekye. ");
INSERT INTO ninNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ugo wa a tu ki tsa na gru kri na aza ama, na gru so zirr kago. Na mirri ga ba kuma nu Uki ku Ibarr ku. À zirr na di tu ki tsa na so gbyarr ku Abachi asa. ");
INSERT INTO ninNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Anishirr ba nabo a hi ma so zirr na so gbyarr ku Abachi asa. ");
INSERT INTO ninNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nggo a hi da à su ugo ni di barr na angu ankonki ka Uki ku Ibarr Abachi ka nggo à yo ka di Ankonki a Iwre wa, a ku ayisurr na vu angu gri ni inkindirr yi nggo ila nu ugo wa ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ugo wa à kure̱ ani Biturr tuku Yohana, anishirr ba we a ku ayisurr na kru kuma na ba nu unto ku nggo a yo ku di akaba a Solomo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nggo Biturr a hi anishirr ba nggo na ddu ba di, “Amuya anu Israila, angginggi di imba ku ayisurr ni inkindirr inggi yi? Imba so kye inta na anggi? Imba kye di inta du unushirr wanggo gru zirr nu ukyekye umunta mu, ka ku i sama ni ila ure, ka iga imunta? ");
INSERT INTO ninNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abachi a Ibrayi, Ishaku ni Yakubu, Abachi a akiki munta à nu uvuvurr iko ama wa Yesu inkpinkpye. Imba ba ma nu ba di a bu kpa ngu ni kà ma na ashishi ka Bilatu. Uwa Bilatu a ka ttu ma ttungo ba. ");
INSERT INTO ninNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Imba i kà Yesu nggo à sama ni ila ure nâ su unushirr uzizi, ni da di a bu ttu uni ngɨ anishirr wanggo ttungo ki imba. ");
INSERT INTO ninNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Imba ingu uwanggo nggo a di nu anishirr iso, Abachi à ta ma si inta yo i si abangga ba nggo a ki ashishi ihi inkindirr ima nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Imba so kye unushirr wanggo hi, ni hi ma. A yo isisurr ni isa i Yesu na kaki ukyekye. Iyo isisurr ni Yesu ku iyo du ugo wa à wre na ashishi amba. ");
INSERT INTO ninNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Amuya, ingga si hi di imba na ankpinkpye amba ba mi si hi inkindirr yi nggo imba na hen. ");
INSERT INTO ninNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Abachi à du abi kpa are ama ba ngbangba mu di a bu nga ni da ki inta di Mezaya wanggo a tu ma nggo à ta ni ki iha, inkindirr inggi yi du ure umaku u kurr meme yo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Imba kanga na Abachi ku ziza nggo ni du ila ure imba yi, wre ku Abachi bu nggurr ila ure imba yi zhi ki imba. Imba ti na meme nggo, ");
INSERT INTO ninNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ivi yi ko nga nggo Abachi à ta ni imba ukyekye uhe̱he̱, na ta tu ki imba Yesu u Kristi wa nggo Abachi à ka hla zu ki imba ba. ");
INSERT INTO ninNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesu à ta so nu unkplassu ku na du Abachi na aseki ka kaki ahe̱he̱ nâ ta si nggo à tu abi kpa are ama abi wre ba ngbangbamu du ba a nga ni da nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Musa a da di, ‘Atiko Abachi amba wa à taka ttu uyirr ni imba ba ki uni kpa are nâ ta si nggo a ttu ingga nggo. Imba bu wo ku aseki ka wemi nggo a da ki imba nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Undurr wa nggo a ti kà iwo ku uni kpa are wa ma, aba ta ttu ma glo na anishirr ama ba ba.’ ");
INSERT INTO ninNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Bazhi ni Samwila ku, abi kpa are ba nggo a zzu sama nggo, a so di re ni itu i aseki ka nggo inta so hi ka ari nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Imba yo sa abangga ba nggo Abachi à da ku abi kpa are ba di a bu re na ba. Aba a ni imba ida zu yi nggo Abachi à da zu ku ábáchí mbirr wa Ibrayi di, ‘Abachi ta yo angu ka iwre ku anishirr bi ingbingbru ba we ni itu i unushirr uyirr nu uga umba ku.’ ");
INSERT INTO ninNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Abachi à ta uvuvurr iko ma wa si ni ibe yi na du ma kuma ni imba yo ba ni ime̱me̱ yi, wre ki imba bu kpa iyo angu zizi i Abachi yi ni du ila ure imba yi imba wemi.” ");
INSERT INTO ninNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Anu Biturr tuku Yohana a ni so re na anishirr ba ba nggo, mre ankpinkpye abikye ba na ankpye a abi gbye Uki ku Ibarr ba na anu Sadusi ba a zirr nga na ba. ");
INSERT INTO ninNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ankpinkpye ba a ki unfu kakami ni itsarr i abi ko na angu yi, nggo a da di anishirr ba nggo a kɨ a taka tasi nâ ta si nggo a ta Yesu si. ");
INSERT INTO ninNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Aba vɨ ani Biturr tuku Yohana, nggo a kye si ingbahru, na gri ba ku harr nu uki zu nu uha wa. ");
INSERT INTO ninNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Anishirr shishemi nggo a wo ure ku a kpanye na ku. Abangga ba nggo a kpa Yesu a hun ma ukrɨ ukywi (5,000). ");
INSERT INTO ninNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ambre ka à nggarr nggo abi hru igbu ba, na aninku, na abitsarr Are ka Musa ba a nggurr bi nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anasi nggo a sa ankpye unkpi abikye wa à se tuku Kayafa, u Yohana tuku Alezanda na abanu ni ine i ankpye unkpi abikye wa. ");
INSERT INTO ninNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","A du ba a gri anu Biturr tuku Yohana nga ba, na ni so zhi ba di, “Imba i so na aseki angga ka nu ukyekye uta ku nggo, ka imba so na aseki ka ni isa i unggonggo?” ");
INSERT INTO ninNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Mre Izhi Iwre yi i tsarr ssu ni Biturr ku, uwa ddu ba di, “Ankpinkpye na aninku bu Israila! ");
INSERT INTO ninNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Imba ti di imba so zhi inta inkindirr izizi yi nggo inta na ku uni gbo na ampi wa, ni so da di inta bu tsarr imba nggo inta na ni du à gru zirr nggo, ");
INSERT INTO ninNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","imba na anu Israila namri imba bu wo yi. Inta i zha di imba bu hi di unushirr wanggo nggo à kri na age̱ amba ziza à wre ni ivri ima yi tsatsarr nu ukyekye ku isa i Yesu Kristi anu Nazareti wa. Wanggo nggo imba i kpa ma ngu, a Abachi a ta ma si ni ibe yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Uwa yo à si, “ ‘Ingbinta yi nggo imba abi me ba i kà yi, ima iyo i kaki ibarr iko yi.’ ");
INSERT INTO ninNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Yesu yo na nkpama à se nu ukyekye ku kpa anishirr ttungo! Isa numa sama nggo Abachi à ni yi ni ingbingbru yi, nggo i ka kpa anishirr ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nggo a hi ani Biturr tuku Yohana a re sama ni kru isisu, na hi da a si bre ungbamvu hen, na sa anishirr abangga ba nggo aba di hi ba ttuttumi nggo, anishirr ba a ku ayisurr. Na ssu hi da ani Biturr tuku Yohana a di se ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nggo a hi uni gbo na ampi wa à kri krikri na ba nabo, na zha inkindirr ida yi chankarr. ");
INSERT INTO ninNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A han ani Biturr huzzu nu uki ku iso ku Akaba anu Yahuda wa. Aba ankpinkpye ba a nggurr itu bi, ");
INSERT INTO ninNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","na re da di, “Inta ta na anishirr angga ba kingginggi? Nggo a na inkindirr ikagri inkpi anishirr bu Urushalima ba wemi a hi yi, inta ka si kisa hen. ");
INSERT INTO ninNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Inta ti si kpanye da anishirr bu wo ure unggo ku kago hen, inta bu gba ba atu da a bu si re ni isa i Yesu zizo hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mre na yo ba ka mirri ku fe̱ ba ashishi di a bu si re nu undurr ku ni isa i Yesu yi zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ni da ima mi anu Biturr tuku Yohana a ddu ba da di, “Imba mi kye ku atu imba, uwatanggo à wre na age̱ ka Abachi? Inta bu na inkindirr inggi yi nggo imba ngga da di inta bu na, ka inta bu na inggi yi nggo Abachi nggo da? ");
INSERT INTO ninNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Inta si ta ba ttungo ni re inkindirr yi nggo inta i wo ni hi na atu munta hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ankpinkpye ba a sha ba ji meme nggo na du ba a kuma. Nggo a si hi ila yi nggo a ta vu anu Biturr hen. Anishirr ba a so gbyarr ku Abachi asa ni inkindirr yi nggo a na, mre ankpinkpye ba a ma chankarr ni ki anu Biturr iha. ");
INSERT INTO ninNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ugo wa nggo a gru zirr ku ikagri inggi yi nggo a mri ase iso ne̱s. ");
INSERT INTO ninNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","A ttu ba ttungo ma yo mre, anu Biturr tuku Yohana a narr kuma ku da ku akpukpambarr abiga ba inkindirr yi nggo ankpinkpye abikye ba na abi gri anishirr ba a ddu ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Abiga ba a wo meme nggo na nggurr bi ni isisurr iyirr na so barr Abachi da di, “Atiko unkpi, ùwà nggo i na unkplassu ku, ni imimi yi, na amasirr ka, ni inyi inkpinkpi yi, na aseki ka nggo a so nu umi umbarr ku. ");
INSERT INTO ninNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ùwà re na angu ka ugarr amuwa wa Doda, ábáchí amunta wa, nu ukyekye ku Izhi Iwre imuwa yi da di, “ ‘A sa angginggi du anishirr abangga ba nggo a si si anu Yahuda hen a varr unfu? Angginggi du anishirr ba so ri amarr ka nggo à si ta gri ba inkindirr izizi hen? ");
INSERT INTO ninNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Atuttu bi ingbingbru ba a ttu ukpa ku itsi, abi hru igbu ba a nggurr bi ta tsi na Atiko ku tuku Kristi ama wa, uwanggo nggo à hla ma ki nanka nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Aseki angga ka a la jiji. Kye, Hirridu tuku Pontu Bilatu na abangga ba nggo a si si anu Yahuda hen, na anu Israila ba, a nggurr bi we nu Urushalima ni itu i Yesu. Yesu yo à su uvuvurr iko uni wre amuwa, wanggo wa nggo ùwà na ma ki Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A nga ni na inkindirr ima yi nggo ùwà da nu ukyekye ni ihi muwa yi ngbangbamu di ì taka la nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Atiko, kye nggo anishirr angga ba a ttu isisu ssu ki inta nu ukpa, ni bu kpanye ki inta, agarr uwa, di inta re ure muwa ku sama ni isisu. ");
INSERT INTO ninNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Uwa bu du anishirr a hi ukyekye umuwa ku, ni di inta bu du abu lolo a wre, ni bu na aseki ka ikagri na aseki ka iku ayisurr ni isa i uvurr iko muwa wa, Yesu nggo uwa i hla ma.” ");
INSERT INTO ninNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nggo a barr Abachi kre, abubo a ibarr wa à battu gburrgburr. Izhi Iwre i rri ni tsarr ssu ba wemi nu ukpa, aba a gru so re ure ku Abachi ku na si kru isisu hen. ");
INSERT INTO ninNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Abiga ba wemi a se ni isisurr iyirr, amarr ayirr. Unuma a si da di inkindirr ima i si ima na nkpama hen. A ga ku ikpa aseki angga ka nggo a se na ka nggo narrnarr. ");
INSERT INTO ninNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abi ko na angu ba a kri kyekye kakami na da ku anishirr ba di a ta Yesu si ni ibe yi jiji. Abachi à na wre ba we kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Unuma na abiga ba ba a si zha inkindirr chankarr hen. Abangga ba nggo a si na anila tuku ako a vu ba re, na kpa inklo yi nga ");
INSERT INTO ninNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ni nu abi ko na angu ba. Aba a kpa yi ga ku abangga ba nggo a sama ni inkindirr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ani Isuhu, uni zi undu nu Uki ku Abachi wa nggo a ngri ma nu Sayiprosi à na meme yo. Abi ko na angu ba a yo ma di Barrnaba (nggo si di “Uni du unushirr à kri kyekye.”) ");
INSERT INTO ninNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Isuhu à se ni īlá, na ba yi re, na gri inklo yi ni nu abi ko na angu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ugo numa nggo à yo ma di Ananiya tuku uwama à ri Safirra a ba ila imbarr a re. ");
INSERT INTO ninNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A ba ila yi re nggo na nggurr angu bi tuku uwama wa na ttu inklo inuma yi zu sharri, na ba inkpu yi nga ni nu abi ko na angu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Biturr à zhi ugo wa di, “Ananiya, ùwà na kingginggi ni du Isheta a mirri ku ùwà ni isisurr meme na du ùwà i ki imu ku Izhi Iwre yi ni itu i inklo yi nggo ùwà ikpa ni ila yi nggo ùwà ba yi re nggo? ");
INSERT INTO ninNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Abubo wa a di kri nggo na sa amuwa, ùwà ba wa re mi inklo yi nggo a re wa nggo i si imuwa. Uwa a si angginggi du ùwà i ni isisurr imuwa du ùwà ta na inkindirr inggi? Ùwà si ki ku anishirr mu imu inggi yi hen. Ùwà i ki ku Abachi mu imu yi.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nggo Ananiya à wo meme mre na jaku iku. Isisu i ki anishirr kago nggo a wo inkindirr yi nggo i la. ");
INSERT INTO ninNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Anzinze abanu a gru ni nyarr iku yi nu upri inkru, na ba yi ku zzu. ");
INSERT INTO ninNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","A so ki awa atarr ayamba a Ananiya wa a mirri nu uki ku nggo Biturr à so na si hi inkindirr yi nggo ila nu uruma wa ku hen. ");
INSERT INTO ninNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Biturr à zhi ayamba wa di, “Uwanggo yo a si inklo yi pempe nggo imba i ba ila yi re ni kpa nggo?” Ayamba wa à kpanye di, “Inklo inggi namri.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Biturr à ddu ma di, “Angginggi du imba tuku urumi i kye di imba ka nggurr angu bi ni tsarr Izhi i Abachi yi kye ùwà si ta na ki imba inkindirr hen? Kye! Abi zzu urumi abangga a so nga, a ta ba ùwà mi ku zzu meme!” ");
INSERT INTO ninNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mre ayamba wa a jaku ku Biturr na aza na ttu. Anzinze ba a mirri na ni hi da à ttu nggo na ba ma gri ku zzu hinga nu unuru wa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Isisu i ki abiga ba we na anishirr ba kakami nggo a wo ure unggo ku. ");
INSERT INTO ninNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Abi ko na angu ba a na aseki ka ikagri na aseki ka ku ayisurr shishemi na anishirr ba ba. Abiga ba wemi a nggurr atu ambarr wa bi na abubo a ikuso nggo yo wa di Akaba Solomo. ");
INSERT INTO ninNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Abangga ba nggo a si se na abiga ba ba hen a kru na si rri na ba hen. Ni ina ima mi anishirr a kye ba ssu na ango. ");
INSERT INTO ninNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Amba na aniru shishemi a kpanye na Abachi ku na nga ni nggurr atu a bi na abiga ba ba. ");
INSERT INTO ninNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Anishirr ba a hi aseki angga ka na vu abu ilolo na abubo a ikurr ambarr wa nga ni zu ga anko di Biturr a ti so sarr ba nabo iyu ima yi i ta jaku na abu lolo ba ba, aba ta wre. ");
INSERT INTO ninNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Akpa anishirr mi a hru abu ilolo na abangga ba nggo anazhi a so di tsutsarr ba nggo zhi ni igbu yi nggo i kri kago Urushalima nggo a ba ni kaki kyekye. ");
INSERT INTO ninNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ankpye unkpi abikye wa na akpukpama ba, nggo a si anu Sadusi ba, a kri angbachi na ba, na gru da aba ta ki ba iha. ");
INSERT INTO ninNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","A vu abi ko na angu ba gri ku harr na abubo nggo a di harr abi la ure. ");
INSERT INTO ninNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","U ni ibittu ima unitu Atiko wa a nga ni bwu anko abubo a harr wa. Na gri abi ko na angu ba ssuzzu na ddu ba di, ");
INSERT INTO ninNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Kuma ku kri nu Uki Unkpi ku Ibarr Abachi ku ni da ku anishirr ba ure ku anko a iso ahe̱he̱ wa.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Abi ko na angu ba a wo ku unitu Abachi wa, na gru ssuzzu ni gambre kuma nu Uki Unkpi ku Ibarr Abachi ku ku so tsarr anishirr ba. Nggo ankpye unkpi abikye wa na anishirr ama ba a nga nggo, na ni yo Akaba ankpi anu Yahuda wa na akikre anu Israila ba, na tu ba di a bu kuma ku gri ba abi ko na angu ba zhi na abubo a harr wa. ");
INSERT INTO ninNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Nggo abi lo ukpa ba a nga na abubo a harr wa na ni zha abi ko na angu ba chankarr, mre na kakuma na abubo a ssubi wa ku da ba di, ");
INSERT INTO ninNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Inta kuma nye na ba a harr anko abubo a harr wa gbangba ni inkpe̱ iharr yi. Ni hi abi so gbye abubo ba mi aba kri karrkarr. Inta bwu anko nggo ni si hi undurr nu umi hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nggo ankpye abikye Uki ku Ibarr wa tuku ankpinkpye abikye ba a wo meme na ku ayisurr di a sa angginggi ima i so la. ");
INSERT INTO ninNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nggo ugo numa a nga ni ddu ba di, “Anishirr angga ba nggo imba i harr ba nggo a kri so tsarr anishirr nu Uki ku Ibarr ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","A wo meme, mre ankpye abi gbye abubo a harr wa à kuma na ankpinkpye abanu ku gri abi ko na angu ba nga. A si nga ba nggangga mu hen. A kru di anishirr ba ta tà ba na angbinta. ");
INSERT INTO ninNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","A kuma ku gri abi ko na angu ba na nga na Akaba anu Yahuda wa, wre ku ankpye unkpi abikye wa bu ni zhi ba are. ");
INSERT INTO ninNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ankpye abikye wa à ddu abi ko na angu ba di, “Inta i si gba ki imba utu di imba bu si tsarr anishirr ni isa i ugo wanggo hen? Kye inkindirr yi nggo imba na nggo. Imba ka ga ni tsarr anishirr kago Urushalima ba. Ni ta du ayiyi a ugo nggo wa a so ki inta na ango di a bu da di inta ngga i ngu ma.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Biturr na abi ko na angu a abanu ba a ka sa ba da di, “Inta ta na inkindirr inggi yi nggo Abachi mu da di inta bu na, ni si ta na inkindirr yi nggo anishirr mu di inta bu na yi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nggo imba i kpa Yesu ni klo ma ngu nu unkunkurr ku, Abachi a akiki amunta wa a ta ma ka si ni ibe yi. ");
INSERT INTO ninNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Abachi a ba ma ku zu nu ungo ri uma, na na ma ki uttu tuku uni kpa ttungo. Meme nggo anu Israila ba ta hi anko wa nggo a ta ba ttungo nu undanda umbarr ku, aba ta nggurr ila ure imbarr yi zhi ba. ");
INSERT INTO ninNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Inta i nye da ki imba inkindirr yi nggo Abachi a na nggo. Izhi Iwre yi nggo Abachi a nu abangga ba nggo a wo ku ure nggo, i di da aseki ka Abachi ka meme.” ");
INSERT INTO ninNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nggo abi di so na akaba anu Yahuda ba a wo meme na cha ukpa di a bu ngɨ abi ko na angu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Uyirr nu umi ku anu Farrisi ba à ri Gamaliya. À si unitsarr na Are ka Musa ka. Anishirr a di kye ma yo ni chi kakami. Uwa yo gru kri na Akaba anu Yahuda wa na ttu ukorr di a bu gri abi ko na angu ba a ssuzzu. ");
INSERT INTO ninNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nggo na ddu akaba wa di, “Anishirr bu Israila, ki bwe ni inkindirr yi nggo imba ta ko na ku anishirr angga ba. ");
INSERT INTO ninNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ivi i nise tanko nggo Tiyuda à gru nggurr anke̱ du uwa si kaba. A na meme anishirr ama ayiyirr ane̱ (400) a gru di ga ma. A ngu ma, abiga ma ba a ga ki varr varr namri. I nggurr bi imbarr yi i ttu nado. ");
INSERT INTO ninNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ima ivu sarr nggo mre anu Galili nggo a yo ma di Judasi à nga ni ivivi nggo à bre anishirr ba nggo. Uwa mi à gburr anishirr aba di ga ma shishemi, aba ngu ma meme abiga ma ba ga ki varr varr. ");
INSERT INTO ninNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ni itu inkindirr yi nggo i ko zirr ziza nggo, ingga ko da ki imba si na ku anishirr angga ba inkindirr hen. Du ba kuma. Inkindirr yi nggo a so na yi i ta si ina i unushirr, i si ta tà anko hen. ");
INSERT INTO ninNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Inkindirr imbarr yi i ta zhi na Abachi ku imba si ta ba ba nggurr hen. Imba ka kye imba so tsi na Abachi mu ku.” Akaba wa a kpa amarr ka Gamaliya ka. ");
INSERT INTO ninNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Na yo abi ko na angu ba mirri na du abi gbye abubo a ibarr ba a hlo ba na gba ba atu di a bu si so re ku anishirr ba ni isa i Yesu yi hen, na ddu ba ttungo. ");
INSERT INTO ninNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Abi ko na angu ba a ka share na Akaba anu Yahuda wa na so nyarr kakami di Abachi à kye aba ma abi ki iha ku isa i Yesu. ");
INSERT INTO ninNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A di rri nu Uki ku Ibarr ku na ga ako anishirr na so tsarr na bre Ure ku wre ku Yesu Kristi ku ni ivivi yi. ");
INSERT INTO ninNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ni ivivi ima nggo abiga ba a so kri mwe nggo uvi u gru ku ani Yahuda abangga ba nggo a di re irrirri imbarr yi, na ani Yahuda abanu ba nggo a di re irrirri i Girrki. Ani Yahuda abi di re Girrki ba a yì di a si di kye amba bi so na ako ambarr ba zizi ni ga ila yi nggo a di nu amba bi so na ko ba ni ivi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Abi ko na angu awurr na aha ba a wo meme nggo na yo abiga ba bi na da ba di, “I si wre inta bu ka ure ku Abachi ku du ni ka ku di na undu ku iga ila hen. ");
INSERT INTO ninNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Amuya, a ti si meme, imba ddu anishirr atangba nu umi umba ku nggo a di kye ba ssu na ango. Abangga ba nggo Izhi Iwre yi itsarr ssu na ba, na a si abi hi inkindirr. Inta du abangga a so di kye ki inta undu ku ga aseki unggo ku. ");
INSERT INTO ninNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Inta mi ta kukri kakami nu undu ku so barr Abachi tuku so bre ku anishirr ure umaku.” ");
INSERT INTO ninNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Abiga ba wemi a kpanye ni ida i abi ko na angu yi. Na ttu Istifanu, unushirr wanggo kpanye kakami nu ure ku Abachi ku, Izhi Iwre yi i si na ku. Na ddu anu Filibu, u Prokoro, tuku Nikano, u Timo, u Pamena tuku Nikola, uwama a si si ani Yahuda hen, na zhi nu Antakiya. À kà iga i ábáchí ama yi na kpa iga i anu Yahuda yi. ");
INSERT INTO ninNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aba a gri anishirr atangba ba ni tsarr abi ko na angu ba aba sa ba ango ni itu na barr Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Meme nggo anishirr shishemi a wo ure ku Abachi ku na kpa ku. Abiga ba a gru so kri mwe nu Urushalima. Abikye ba shishemi a kpanye nu ure ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Istifanu a su Unushirr wanggo ungo ku Abachi ku u so na ku ni nu ma ukyekye. Uwa na ku anishirr aseki ka ikagri na a ka ku ayisurr. ");
INSERT INTO ninNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mre anishirr abanu a gru ko kisa ku Istifanu. Anishirr abama a si na abubo a issubi anu Yahuda nggo a ri, “Abubo abangga ba nggo a ka ddu ba ttungo ni igarr ba,” na zhi nu Sirrene tuku Alezandra. Abanu ambarr ba a zhi nu Silisiya tuku Asiya. Aba wemi a gru ko ri anta ni Istifanu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ni na imbarr yi mi, Izhi i Abachi yi i nu Istifanu ihi, aba ama ma chankarr nu ure ku. ");
INSERT INTO ninNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Aba kye na kuma ku ssubi na anishirr abanu ba sharri na yi di a bu nga ni ki imu ni itu i Istifanu di, “Inta wo Istifanu a ko re are andanda ni itu i Musa tuku Abachi!” ");
INSERT INTO ninNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Mre na tto anishirr ba na ankpinkpye ba tuku abitsarr Are ka Musa ba. Aba vu Istifanu na gba ma na nga na Akaba anu Yahuda wa. ");
INSERT INTO ninNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Na ku gri anishirr banu du ba a nga ni re are ni itu i Istifanu di, “Ugo nggo wa à so di re are andanda ni itu i Uki ku Ibarr Unkpi ku tuku Are ka Musa ka. ");
INSERT INTO ninNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Inta i wo ma da di, Yesu anu Nazareti wanggo a ta turr abubo a ibarr munta wa kahre. Na ta vu aseki ka nggo Musa à tsarr akiki munta ba na ka nggo a kasarr.” ");
INSERT INTO ninNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Anishirr ba wemi na Akaba anu Yahuda wa a kye Istifanu karr na hi ashishi amaka a gru so la zzu ashishi ka unitu Abachi mu. ");
INSERT INTO ninNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ankpye unkpi abikye ba a zhi Istifanu di, “Are ka nggo anishirr angga ba a bre du uwa da, a si meme yo?” ");
INSERT INTO ninNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanu à ka sa ku di, “Amuya na akiki, imba wo ki ingga. Abachi à nggurr huzzu nu inkpinkpye uma, ku aki amunta wa Ibrayi, uwa à ni di so ni igbu nu Mesopotamiya bari na ka gru sorr kuma nu Harra. ");
INSERT INTO ninNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Abachi à ni ddu ma da di, ‘Gru ni ìgbù amba wa na anishirr amuwa ba ni kuma nu unto ku nggo ingga ta tsarr ùwà.’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Mre, Ibrayi à gru zhi igbu anu Kalidiya wa na ku kuso nu Harra. Nggo aki a Ibrayi à ttu, Abachi à du Ibrayi à gru à nga ni igbu wa nggo imba so nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ni ima, Abachi à nise nu Ibrayi inkla numa ntsɨ nggo à ka yo ki ima. Abachi à da zu ku mu du uwa taka nu ma igbu wanggo nggo à taka si ama na ahan ama. Abachi à so da ure kuma nggo Ibrayi à sama nu uvuvurr. ");
INSERT INTO ninNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Abachi à ddu ma da di, ‘Ahinhan amuwa ba a ta so ichirr na ta kaki agarr ni ìgbù numa, aba ta ki ba iha ke ase ayiyirr ne̱s. ");
INSERT INTO ninNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anishirr ba nggo aba a so garr yi na ba nggo ingga ta ki ba iha. Ahinhan amba ba a taka huzzu zhi ni ìgbù uwama na nga ni di barr ingga ni inkla abubo inggi yi.’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Mre nggo Abachi à lo shi azhi tuku Ibrayi. Abachi à ddu Ibrayi di, ‘Iyo iji inggi i taka si angba anggo nggo a si taka du ba a kpamusu na azhi ambarr ka hen.’ Ni ima yo, aba a ngri ku Ibrayi uzuma wa Ishaku, uwa à ki ivi itandarr u Ibrayi à yo ku iji. Ishaku mi à yo ku amarr ma ba iji meme. U Yakubu mi à na meme ku amarr ma ba, ábáchí munta awurr na aha ba a na meme yo. ");
INSERT INTO ninNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ishishi i ki ábáchí ba nu Isuhu ku. Aba a vu ma a re ki ugarr ni igbu nu Masarr. Abachi mu à ka na so zi ma. ");
INSERT INTO ninNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Na di ttu ma a ssuzzu ni aseki ndanda ka nggo anishirr a na ku nggo. Abachi à du Isuhu a si ni ihi na si ukrizhizhi, na ti ta nga na age̱ ka Firrawuna, uttu nu Masarr wa, nggo uwa kpanye na ku. Firrawuna à na Isuhu ki ankpye ni igbu na di kye iko ittu yi. ");
INSERT INTO ninNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Nggo ingaza ì ki ba nu Masarr tuku Kenanu ni du iha ki ba kakami, akiki munta ba a zha ila chankarr. ");
INSERT INTO ninNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nggo Yakubu à wo di ila ì se nu Masarr na tu amumarr ama ba nggo aba yo a si akiki amunta ba. Aba a kuma na ankpu a me̱me̱ wa. ");
INSERT INTO ninNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Na ankpu aha wa i Isuhu à bwu itu ima a tsarr amuyirr ba, i Firrawuna, uttu nu Masarr mi à gru hi akiki bi Isuhu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Isuhu à tu ba ni Yakubu, aki ama wa ku di a bu gru ni iko ima yi we na nga nu Masarr. Aba wemi a si anishirr iso tangba na kywi (75). ");
INSERT INTO ninNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu gru na kuma nu Masarr, na ku kɨ nabo na amarr ma ba. ");
INSERT INTO ninNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","A gri aku ambarr wa ku zzu nu Shekemu, ni ibe inggi yi nggo Ibrayi à re ni inklo na amumarr bu Hamo ba ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nggo ivi yi ì ki ywhiywhirr Abachi bu na ku Ibrayi inkindirr yi nggo à da zu ku du uwa à taka na nggo, anishirr amunta ba a ka kri mwe nu Masarr ba. ");
INSERT INTO ninNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mre uttu uhe̱he̱ mu nggo à si hi Isuhu hen, à hun ni ittu i Masarr yi. ");
INSERT INTO ninNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Na ssu anko amimi ku anishirr munta ba na di ki ba iha. À di han ba du ba a di ka amumarr abangga ba nggo a ngri a du na bi du ba a kɨ. ");
INSERT INTO ninNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Uwa a si ni ivivi ima yo aba a ngri Musa. Uvuvurr ni wre kpekpe na ashishi ka Abachi. Musa à ki ihwa itarr ni iko imbarr, akiki ama ba a ssu ma gri. ");
INSERT INTO ninNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nggo a ba ma ku kadu na abi ka nggo uva a Firrawuna à ba ma gri ku ho ki ama. ");
INSERT INTO ninNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","À tsarr Musa ihi i anu Masarr yi pempe. Uwa à furr ki Unushirr nggo à su kakami nu ure, tuku aseki ka nggo a di na ka. ");
INSERT INTO ninNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Nggo Musa à ki ase so ne̱s na gru kuma ni ichirr na ambarr ani Israila ba. ");
INSERT INTO ninNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Na ku hi anu Masarr a ko ki anu Israila numa iha, mre Musa kuma ku ngu anu Masarr wa kpa ku anu Israila wa. ");
INSERT INTO ninNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Musa à kye di aba ako ambarr wa a ta hi di Abachi nggo a ta du uwa Musa a ni kpa ba ttungo. Aba a si hi meme hen. ");
INSERT INTO ninNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ambre ka nggarr nggo u Musa à hi ani Israila ambarr aha a so tsi na gru du uwa ta narr ba, na ddu ba di, ‘A wo yi amuya, imba si imu yirr anggi mu di imba ko tsi ni ikpa?’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Unuma nggo à ko ki uyirr wa iha yi nggo à turr Musa ka glo na zhi ma di, ‘Unggonggo à na ùwà ki uttu tuku uni bre ki inta are? ");
INSERT INTO ninNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ùwà nye ingu ingga nâ ta si nggo ùwà na ngu anu Masarr wa nare nggo?’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nggo Musa wo meme mre na kru share nu Masarr. Na kuma ku so ni igbu anu Midiya. Nggo à di so nu Midiya ayamba ama wa à ngri ku amumarr aha. ");
INSERT INTO ninNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Nu ugo ku ase iso ine̱ unitu a Abachi wa nggurr huzzu ku nu umi ku irrirri iru na ankpuji ywhiywhirr ni igbre nu Sinayi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nggo Musa à hi uru ku, na ku ayisurr ni ihi ima yi. A chi kuma du uwa ta ku kye uru ku kakami nggo na wo ukorr ku Atiko ku da di, ");
INSERT INTO ninNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘À si ingga Abachi a akiki amuwa ba, ni si Abachi a Ibrayi, tuku Ishaku, i Yakubu.’ Musa à wri kpakpa na ma bwu ashishi kye chankarr. ");
INSERT INTO ninNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Atiko wa à ddu ma da di, ‘Ddu anggakpaza amuwa ka glo, abubo wa nggo ùwà ì kri à si a iwre. ");
INSERT INTO ninNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ingga ihi iha i anishirr amungga ba nu igbu nu Masarr ni wo iyi imbarr yi, ni ji nye kpa ba ttungo. Nye ni inggya, ingga ta tu ùwà kakuma nu Masarr.’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Uwa su Musa uyiyirr wama yo nggo ani Israila ba a kà ma na da di, ‘Unggonggo à na ùwà ki uttu tuku uni bre ure a munta?’ Abachi à tu uwa yo na du unitu ama wa à nga ni re nu Musa ku ni ijiji yi nggo i so kparri nggo. Abachi à du unitu wa à yo Musa na nu ma undu ku gri anishirr ba ki uttu tuku uni kpa ba ttungo. ");
INSERT INTO ninNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa à gri anishirr ba huzzu nu Masarr. À na aseki ka ikagri tuku a ka ku ayisurr nu Masarr, ni Inyi Ususarr wa tuku na ankpuji wa ki ase iso ine̱ (40). ");
INSERT INTO ninNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Uwa si Musa yo à ddu anu Israila ba di, ‘Abachi à ta tu uni kpa are na ba, nâ ta si nggo à tu ingga nggo. Uwa à ta su uyirr amba.’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Uwa yo à di zirr na anishirr ba ba na di nggurr bi ni ijiji. Uwa yo à di zirr na akiki munta ba ba tuku unitu Abachi wanggo nggo à re na ku ni igbigbu i Sinayi. À kpa ure ku Abachi ku nggo u di ni inta iso tsitsirr, wre ku bu turr ku nga ki inta. ");
INSERT INTO ninNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Akiki munta ba a si wo ku hen. A kà ma na da di aba a zha di aba kà kakuma nu Masarr ku mu. ");
INSERT INTO ninNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Nggo na ddu Aruna di, ‘Na ki inta ábáchí unuma nggo a ta di ku ki inta ichi nggo. Inta si hi inkindirr yi nggo ì la nu Musa wanggo à gri inta ssuzzu nu Masarr nggo hen.’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ni ima yo aba a na ankpunkpru a uvuvurr ilando na han ayiyi a to ku. Na na iga na rro nyarr ku inkindirr yi nggo a na nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","A na meme nggo, Abachi à kà ugo a nu ba, na du ba ka di kye intsintse̱ na akpa ki ábáchí ambarr wa nâ ta si nggo a charr nu ungbamvu ku abi kpa are ba di, “ ‘Anishirr bu Israila! Imba i si di han ayiyi a ininazzu wa to ki ingga ki ase iso ne̱s ni ijiji hen. ");
INSERT INTO ninNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Imba i ba iburr i azhi Mole, na ankpunkpru iki ka Refa, azhi amba a intsintse̱ wa. Abama a si aseki ka nggo imba i na di abangga a si ábáchí amba ba. Ni itu ima yo, ingga ta turr imba kuma ni igarr gbagbamu nu Babilo nggumu.’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Akiki amunta ba a se ni Iburr Iwre i nggurr bi i Abachi yi. Ima yo i tsarr di Abachi à si na ba ni ijiji yi. A tarr yi mwe ma nggo Abachi à da ku Musa di à bu na yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","A so shi akiki amunta ba a kpa Iburr i nggurr bi Abachi yi na akiki ambarr ba ba, na di gri yi ma nu nggo Joshuwa a kpa igbu yi nggo Abachi à han ba huzzu ba. Iburr yi i di se ma na ase ka Doda. ");
INSERT INTO ninNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Doda à su ku Abachi isisurr. Na à barr Abachi di a bu du uwa à me ku Abachi a Yakubu iko. ");
INSERT INTO ninNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Uwa à su Solomo mu à me ku uki ku ibarr ku. ");
INSERT INTO ninNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Abachi Unkpi Kakami wa à si di rri so na ako anggo nggo anishirr ngga a me wa hen. Uni kpa are wa à da di, ");
INSERT INTO ninNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Abachi à da di, ‘Unkplassu ku u si idaba i ittu imungga yi, ingbingbru yi ì si inkla i sa aza amungga. Imba ka me ki ingga iko ita nggi? Abubo a kuso amungga a si nu momonggo? ");
INSERT INTO ninNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","A si si ingga yo ì na aseki angga ka wemi hen?’ ");
INSERT INTO ninNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Imba anishirr bi kà iwo! Isisurr imba yi ì si nâ ta si isisurr i abangga ba nggo a kà ure ku Abachi! Imba ta angbinta harr atu ku ure ku Abachi ku. Imba i si nâ ta si akiki amba ba. Ttuttumi imba mi i di kà iwo ku Izhi Iwre yi! ");
INSERT INTO ninNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Akiki amba ba a si ki uni kpa are uwa watanggo iha hen? A ngɨ abi kpa are ba nggo a da are ni itu i Uwanggo nggo à di wo ku Abachi ure ttuttumi. Imba ngga zizo i yo ku uza ni ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Imba yo i kpa Are ka Musa ka zhi na abitu ama ba ba. Ni ima mi imba i ka ni si na inkindirr yi nggo a di imba bu na hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nggo abi so na akaba ba a shirr ku Istifanu atu, unfu u ki ba, aba ta anyinyirr na ku. ");
INSERT INTO ninNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ni ina ima mi, Izhi Iwre yi ì tsarr ssu ni Istifanu ku, uwa gɨ ashishi hun ko nu unkplassu na hi inkpinkpye i Abachi yi, i Yesu à kri nu ungo ri ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Istifanu à ddu ba di, “Kye yi, ingga i hi unkplassu ku u bwu, Uvuvurr a Unushirr wa à kri nu ungo ri ku Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Aba a yi hantu na ki ango ttu atu, na gru kru ku kuttu ma ankpa yirr. ");
INSERT INTO ninNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","A turr ma kakuma nu ugo ku ìgbù ku na ta ma na angbinta. Abangga ba nggo a bre are ka imu surr ku nggo a ddu iki isurr imbarr yi a zu nu uvuvurr nze numa ku a yo ma du Shawulu. ");
INSERT INTO ninNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","A ko ta Istifanu na angbinta ka, uwa yì na yo Atiko wa di, “Atiko Yesu, ùwà bu kpa izhi imungga yi.” ");
INSERT INTO ninNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Na kuttu na nggarr angu a yi nu ukorr unkpi di, “Atiko, si du ila ure imbarr yi iso ba na atu ambarr hen.” À da meme mre, na ttu. ");
INSERT INTO ninNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Shawulu à kpanye di a na wre nggo a ngu Istifanu nggo. Na azhibarr ama anishirr a ki abiga ba nu Urushalima iha kakami. Abiga ba wemi a gru kru varr kuma ni igbu i Yahudiya tuku Samarriya, na ka abi ko na angu ba yo a du. ");
INSERT INTO ninNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Aniru abi kru isisu i Abachi kakami a zzu Istifanu, na ba azhittu kakami ni ittu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Shawulu na anko à zha anko nggo à ta ngɨ abiga ba na aki ka nggurr bi ka Abachi. À di ga ako wa na yiyirr na gba aniru na amba kuma ku surr na aki ka iharr. ");
INSERT INTO ninNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Abiga ba nggo a ga kru nggo, a zirr ga ankla ka wemi na so di da Ure ku wre ku. ");
INSERT INTO ninNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibu a kuma ni ìgbù numa nu Samarriya na ku bre ba ure ku Kristi. ");
INSERT INTO ninNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","I nggurr bi i anishirr yi wemi a shirr atu ku inkindirr yi nggo Filibu à so da. A wo na hi aseki ka ikagri ka nggo à na. ");
INSERT INTO ninNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Anazhi ndanda a ta ukpa na ssuzzu nu ukpa ku anishirr shishemi nggo a di rri so na ba nggo. Na so han atu. Anishirr bangga ba nggo a kɨ ga anga yirr na aba kpre aza a kaki kyekye. ");
INSERT INTO ninNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Anishirr abi ìgbù ba a nyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ugo numa nu umi ìgbù ku à yo ma di Sima, à si unutirr. Aseki ka nggo à di na ka à du anishirr abi igbu ba wemi a ku ayisurr kago nu Samarriya, na di ga angba du uwa si ankpye mu kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Anishirr ba wemi ni igbu wa, atsitsa na ankpinkpi a di da di, “Wanggo yo à su ukyekye ku Abachi wa nggo à yo ma di ‘Unukyekye Unkpi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ase ka a kri ba nggo a so di na aseki ka ku ayisurr anishirr ba a so di shirr ku atu kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nggo anishirr ba a kpanye nu ure ku Filibu ku ni itu ittu i Abachi yi tuku isa i Yesu Kristi, na du ba zzu ba na amasirr, amba na aniru. ");
INSERT INTO ninNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sima mi à kpanye meme, aba a zzu ma na amasirr. Uwa di ga Filibu kago na ku ayisurr na aseki angga ka nggo a na ka. ");
INSERT INTO ninNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nggo abi ko na angu ba nggo a si nu Urushalima na wo di anu Samarriya ba a kpa ure ku Abachi ku, na tu anu Biturr tuku Yohana kuma na ba. ");
INSERT INTO ninNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ni inga imbarr nabo nggo na ni barr Abachi di abiga ba bu kpa Izhi Iwre yi. ");
INSERT INTO ninNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ni ima Izhi Iwre yi i nise ji ku undurr na ba. A zzu ba na amasirr yo mre ni isa i Atiko Yesu. ");
INSERT INTO ninNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nggo anu Biturr tuku Yohana a sa ungo na ba, aba kpa Izhi Iwre yi. ");
INSERT INTO ninNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nggo Sima à hi di abi ko na angu ba a ti na ungo sa na anishirr ba aba a kpa Izhi Iwre yi mre na ttu inklo du uwa ta nu ba ");
INSERT INTO ninNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","na da di, “Na ingga mi ki kyekye wre ku undurr wanggo ingga ti sa ungo na ku uwa bu kpa Izhi Iwre.” ");
INSERT INTO ninNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nggo Biturr à ka sa ku di, “Ùwà bu kuttu ni inklo imuwa yi mi, nu nggo ùwà kye di ùwà ka ba inklo re inkindirr yi nggo Abachi à ni yi na si kpa inkindirr na yi hen! ");
INSERT INTO ninNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Angginggi imuwa, ùwà sama nu ungo nu undu unggo ku, nu nggo isisurr imuwa yi ì si ndanda na age̱ ka Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Meme nggo, uwa bu ba amarr andanda amuwa kama ttungo, ni barr Abachi hi di à ka nggurr amarr amuwa akama zhi ku ùwà. ");
INSERT INTO ninNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ingga kye ùwà si ssu nu kpakpa isisurr. Ila ure imuwa yi i lo ùwà zu ki ugarr.” ");
INSERT INTO ninNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sima à ddu anu Biturr tuku Yohana di, “Ingga tsi ki imba ango, barr ki ingga Abachi di a bu si du aseki angga ka nggo imba bre a kuttu ingga hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nggo a da ku anishirr ba inkindirr yi nggo a hi ni itu i Yesu nggo, na re ure ku Atiko ku, ani Biturr tuku Yohana a kakuma nu Urushalima. Na ga igbu i Samarriya yi na di bre ure ku Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Unitu a Atiko wa à re ni Filibu ku di, “Gru kuma ni ingbahru na anko nggo a zhi ni Urushalima na ko nu Gaza.” (A si di ga anko ma zizo hen.) ");
INSERT INTO ninNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I Filibu à gru kuma. Na anko ama ugo anu Habasha numa, à si ankpye uni di kye abubo a zu inklo a Kandaki, ayamba wa nggo a su uttu nu Habasha. Ugo wa à so zhi ni ibarr Abachi nu Urushalima ");
INSERT INTO ninNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","na so kakuma ni iko. À rri so ni inga ama wa na so bre nu ungbamvu ku nggo Ishaya uni kpa are Abachi wa à charr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Izhi Iwre yi ì ddu Filibu da à bu chi ki ywhiywhirr nu ugo wa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibu à chi kuma na wo ma so bre nu ungbamvu ku Ishaya. Na zhi ma da di, “Ùwà ì hi inkpi inkindirr yi nggo ùwà so bre yi nggo?” ");
INSERT INTO ninNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Anu Habasha wa à ka sa ku Filibu di, “Undurr ti si tsarr ingga hen, ingga ta na kingginggi ni hi?” Na tsi ku Filibu ango di à bu hun so nu uwa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Inkla yi nggo anu Habasha wa à so bre na angbamvu ka Abachi ka nggo, à si inkla inggi yi nggo da di, “À si nâ ta si ivinta nggo à gri ta ku ngu. À si nâ ta si uvuvurr inkru nggo à kurr ku infunfu ikpa, uwa à si da inkindirr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","A nu ma ishisha na a si na wre ku nâ ta si nggo a ka na hen. Unggonggo ka bre are ni itu i ahinhan ma ba? A ngu ma glo ni ingbingbru inggi yi.” ");
INSERT INTO ninNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ankpye wa a ddu Filibu di, “Da ki ingga, uni kpa are wa à so re ni itu ima ka à so re ni itu i undurr mu?” ");
INSERT INTO ninNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Mre i Filibu à gru so re ku Ure ku wre ku ni itu i Yesu zhi na achichi are kama nggo a so bre nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A so ga anko wa na nga ni inkla numa i amasirr, ankpye wa a ddu Filibu di, “Amasirr nggo inggya, anggi ta han ùwà ni zzu ingga na wa?”  ");
INSERT INTO ninNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibu à da di, “Ùwà ti kpanye ni Yesu ku ni isisurr imuwa yi we a ka zzu ùwà na amasirr wa.” Ugo wa à ka sa ku di, “Ingga kpanye di Yesu Kristi à su Uvuvurr a Abachi.” ");
INSERT INTO ninNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ankpye wa à du inga ni gba ba wa a kukri. Aba aha mi, u Filibu tuku ankpye wa, a ji kuma na amasirr wa, Filibu à zzu ma na wa. ");
INSERT INTO ninNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nggo a ssuzzu na amasirr wa Izhi i Atiko yi i ki Filibu ba share. Ankpye wa à si hi ma zizo hen. Na kuchi nu uzirr umaku isisurr ima yi ì si pyarr. ");
INSERT INTO ninNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Mre i Filibu à kakye uwa à si ni igbu nu Azotu, na di ga igbu yi na so bre Ure ku wre ku Yesu ku nga ni rri ni Kayisarriya. ");
INSERT INTO ninNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nggo Shawulu à ni so vri sasa na so ta anyinyirr du uwa ta ngɨ abiga Atiko ba. Na kuma na ankpye unkpi abikye wa ku ");
INSERT INTO ninNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","di a bu ku charr ungbamvu angga ka nggo a ta da ba du uwa Shawulu à su unggonggo. Na bu nu uwa na ka, uwa à ta kpa ka na kuma na abubo a ssubi anu Yahuda wa nu Damasika, wre ku à ti ku hi abangga ba nggo a ga anko nggo a tsarr nggo uwa à ta vɨ ba amba na aniru nga ni harr nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nggo Shawulu à zirr ki ywhiywhirr nu Damasika mre uru numa u gru ji zhi nu unkplassu nu la nzarr kago ma. ");
INSERT INTO ninNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Uwa jaku ni imimi na wo ukorr u so ddu ma di, “Shawulu, Shawulu, ùwà so ki ingga iha ngginggi?” ");
INSERT INTO ninNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","I Shawulu à zhi di, “A su ùwà unggonggo, Atiko?” Ukorr ku da di, “A si ingga Yesu wanggo nggo uwa i so ki ma iha yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gru kuma nu umi ìgbù ku aba ta ku da ku uwa inkindirr yi nggo uwa ta na nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Anishirr ba nggo a so zirr ni Shawulu ku à kukri sama nu ure na so wo ukorr ku na si hi undurr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawulu à gru ni imimi yi na bwu ashishi ama ka nggo na si kye hi naka hen. Aba a gbu ma nu ungo mu na rri nu Damasika. ");
INSERT INTO ninNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Uwa ki ivi itarr sama ni hi abubo, na si ri ka so inkindirr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Uniga numa à se nu Damasika à yo di ma Ananiya. Atiko wa à yo ma nu la di, “Ananiya!” Uwa kpanye ku di, “Ingga nggo Atiko.” ");
INSERT INTO ninNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Atiko wa à da ku di, “Kuma ni iko i Judasi na anko a umi ìgbù wa nggo yo wa di Ntto, ni kuma ku zhi ba ugo numa a yo ma di Shawulu a sa anu Taso, à so barr. ");
INSERT INTO ninNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","À hi unushirr nu ula à yo ma di Ananiya uwa nga ni sa ango na ku da ashishi ama ka bu bwu.” ");
INSERT INTO ninNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiya à da di, “Atiko, ingga ka wo are ka ugo ma ba na anishirr ba shishemi na aseki ndanda ka nggo a na ku anishirr amuwa ba, nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Na nga ni inggya ni ikpanye i ankpinkpye abikye ba du uwa ta nga ni vɨ abangga ba nggo a so di barr ni isa imuwa yi nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Atiko wa à ddu Ananiya di, “Kuma! A su undurr wanggo nggo ingga ì ttu ma zu di a bu na ki ingga undu. A ta da ure umungga ku ku abangga ba nggo a si si ani Yahuda hen, na atuttu na anishirr bu Israila ni itu mungga. ");
INSERT INTO ninNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ingga ta tsarr ma iha yi nggo à ta ki yi ni itu mungga, wre ku anishirr a bu hi ingga.” ");
INSERT INTO ninNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Mre u Ananiya à gru kuma ni iko yi nggo Shawulu à so, na ku sa ku Shawulu ango ni itu, na ddu ma di, “Uzumburr Shawulu, Atiko Yesu à tu ingga. Ùwà i hi uwa yo na anko. À zha di ashishi amuwa ka a bu kye hi ni bu si undurr wanggo nggo Izhi Iwre i Abachi i ta tsarr ssu nu ùwà ku kakami nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ankpa yirr mre, inkindirr i si nâ ta si akpakpla ka ikikla issuzzu ku na ashishi kuhre ni imimi uwa kye hi zizo. A gru kri aba a zzu ma na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Uwa gru kpa ila à ri na ri kre nggo ukyekye umaku u kanga ku nu ukpa. Shawulu à so ki ivi ntsɨmi na abiga ba ba nu Damasika. ");
INSERT INTO ninNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A tsi kuma na abubo a ssubi anu Yahuda na gru so re ku anishirr di Yesu à su Uvuvurr a Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Abi wo ure umaku a ku ayisurr wemi, na zhi da di, “A si su ugo nggo a di ngɨ abi yo isa i Yesu ba nu Urushalima hen? À nga ni inggya ku ima yo, wre ku a bu ni vɨ ba gri ku ankpinkpye abikye ba?” ");
INSERT INTO ninNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ni ina ima mi u Shawulu ka na re ure ku kyekye mi. Ina ima i du anu Yahuda ba nggo a so nu Damasika a zha inkindirr ida chankarr di Yesu à su Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ivi shishemi i vu sarr anu Yahuda ba a nggurr bi na ssu anko da aba ta ngu Shawulu. ");
INSERT INTO ninNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Aba a farr da ku. A kuma ku di sa ma na azhi ni ibittu na anko ka ìgbù ka da aba ta ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Azhibarr numa nggo ni ibittu abi di ga Shawulu ba a ba ma na asa, na lo ku asa izhizhi, na to ma ji bwe ba ime yi nggo a me harr igbu wa kago nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Shawulu à kuma nu Urushalima na ku du uwa ta nggurr itu bi na abiga ba ba nabo, aba si kpanye da a si uniga jiji hen. Isisu i ki ba na ku. ");
INSERT INTO ninNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nggo Barrnaba à nga ni zi ma na gri ma na kuma na abi ko na angu ba ba. Na ku bre ba nggo Shawulu a hi Atiko wa na anko, na bre ba nggo Atiko wa à re na ku tuku nggo Shawulu à bre ure ku Abachi ku ni isa i Yesu nu Damasika sama ni ikru isisu. ");
INSERT INTO ninNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Meme bari i Shawulu rri ki ambarr na zirr ga Urushalima kago sama ni ikru undurr na so di bre ure ku Abachi ni ku isa i Atiko yi. ");
INSERT INTO ninNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","À kuma ku di re na ri anta na ani Yahuda ba nggo a di re irrirri i Girrki nggo aba a zha anko da aba ta ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nggo amuya ba a wo meme na gru gri Shawulu na kuma nu Kayisarriya na ku tu ma kuma nu Taso. ");
INSERT INTO ninNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Uwa a si ni ima mre abiga ba kago Yahudiya, Galili tuku Samarriya a si ki iha ni ivi ima hen. Izhi Iwre yi i nu abiga ba iso su, aba gru so kri mwe na so ni isisu i Atiko wa. ");
INSERT INTO ninNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Biturr à zirr kago ìgbù yi. Azhibarr numa nggo uwa kuma ni chirr na anishirr ba Abachi ba ba nu Lida. ");
INSERT INTO ninNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na kuma ku hi ugo numa nabo a yo ma di Aniya. A ttu ga anga yirr na ki ase atandarr sama ni igru na abubo a ikurr ama wa. ");
INSERT INTO ninNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Biturr à ddu ma di, “Aniya, Yesu Kristi à du uwa wre, gru chi abubo a ikurr amuwa.” Mre u Aniya à gru. ");
INSERT INTO ninNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Anishirr ba kago Lida tuku Sharroni a hi ma na kaki abiga. ");
INSERT INTO ninNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ayamba numa nu Jopa à si uniga na ri Tabita (Tabita ni irrirri i Girrki à si Doka.) Tabita à so di na uzizi na di zi abi iha. ");
INSERT INTO ninNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ni ivi ima uwa gru lo na ttu. Aba a su ku iku yi ukpa na ba yi gri ku zu nu uki ku ussu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopa à si ta anko zhi nu Lida hen. Nggo abiga ba nu Jopa a wo di Biturr à se ni Lida, mre na tu anishirr aha di a bu ku tsi ku ango di, “Bubomi, narrma nga ni inta ba!” ");
INSERT INTO ninNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nggo Biturr à gru ttu ukpa na ga ba. À mirri nggo aba gri ma na hun kuma nu uki ku nggo à zu iku yi. Amba shishemi nggo aniru ambarr ba a ka kɨ ba nggo a nggurr bi wemi kago Biturr na so yi na bu tsarr iki isurr yi nggo Doka à ni su tsitsirr na ru ba na yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Biturr à han ba di a bu gru ssuzzu wemi nu uki ku, na kuttu na barr Abachi. À kakye iku yi na da di, “Tabita, gru.” Uwa bwu ashishi na hi Biturr na gru so si so. ");
INSERT INTO ninNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Biturr à chi kuma na gɨ ma gru, na yo abiga ba na amba ba nggo aniru ba a ka kɨ ba a mirri, na nu ba na ku. ");
INSERT INTO ninNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ure ukuma u zirr kago Jopa, anishirr shishemi a kpanye na Atiko. ");
INSERT INTO ninNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Biturr à sha so ta anko nu uni hu anggakpa numa ku nu Jopa à yo ma di Sima. ");
INSERT INTO ninNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ugo numa à se nu Kayisarriya a yo ma di Konelu. À si ankpye a inkirr i abi ta iku abu Roma ba nggo a yo ba di “Inkirr i Italiya.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","À su unushirr Abachi. Uwa na abi iko ma ba wemi a di kru isisu i Abachi. À di zi ani Yahuda abi iha ba. Na so di barr Abachi ttuttumi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Azhibarr numa nggo, azhi wa a ka kasarr ba, u Konelu à so tsitsirr a Abachi à tsarr ma nu ula uwa a hi krizhizhi mi unitu a Abachi a mirri na so yo ma ni isa di, “Konelu!” ");
INSERT INTO ninNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Uwa kye unitu wa ni isisu, na ddu ma di, “A sa angginggi, Atiko?” Unitu wa à ddu ma di, “Abachi à nyarr ibarr imuwa yi na hi aseki ka nggo ùwà di nu abi iha ba. Nggo na gru ta tsarr ùwà du uwa bu hi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Tu ba ko nu Jopa, ni du ba yo ku ùwà ugo numa nggo à ri Sima Biturr. ");
INSERT INTO ninNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","A su unichirr ni iko uni hu anggakpa numa a yo ma di Sima. Iko ima yi i si nu unddu ku inyi ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nggo unitu wa à kakuma, Konelu à yo amirr iko ama aha tuku uni ta iku wa nggo à su Unushirr a Abachi na à di zi Konelu undu. ");
INSERT INTO ninNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Na bre ba inkindirr yi nggo ì la na tu ba kuma nu Jopa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Na azhibarr a uha wa na azhi na atsutsu, abitu ba a ki ywhiywhirr nu Jopa, i Biturr à hun ko barr Abachi na atu ka iko issu yi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Iyo so ki ma uwa du ba ko zzu ku ila. A ni ko zzu ila yi uwa à so tsitsirr ula ù gru ki ma. ");
INSERT INTO ninNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Uwa hi unkplassu ù bwu nu la ku. Inkindirr ì so ji zhi nu ussu ku ji nga ni imimi nâ ta si upri inkru nggo à vu ku gri na anga ka ne̱ mi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nu umi ku upri inkru ku a gri ininazzu i akpre tankpami, abi nga ngi nga, na aminche abi ijiji. ");
INSERT INTO ninNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Uwa à wo ukorr ù da di, “Biturr gru, ngɨ ni ta.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Biturr à da di, “Atiko, ingga ka si na meme kpa hen. Ingga i nise ri inkindirr ndanda i ankizhi yi nggo amunta a si di ri yi hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ukorr ku u ddu ma ankpu aha wa di, “Inkindirr inggi yi nggo Abachi à na yo ki izizi, ùwà bu si yo yi ki i ankizhi hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Inkindirr inggi yi i na meme ki ankpu tarr, mre à ba gba upri inkru ku na hun kuma nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nggo Biturr à ko ta amarr ni itu i ula ku, anishirr abangga ba nggo Konelu à tu ba nggo, a zha iko i Sima yi hi na kukri na angu ankonki ka. ");
INSERT INTO ninNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","A nggarr angu a yo, na zhi di, “Biturr, uwanggo nggo à yo ma di Sima à so ni inggya yo?” ");
INSERT INTO ninNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Biturr à ni so bɨ kye ni isisurr di ula ku ù so da ku uwa sa angginggi. Mre Izhi Iwre yi ì ddu ma di, “Wo! Biturr gru kye anishirr atarr ngga a so zha ùwà. ");
INSERT INTO ninNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Gru ji ga ba, ni si kru inkindirr hen. Ingga yo tu ba.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Biturr à ji ku ddu anishirr ba di, “À si ingga yo nggo imba i so zha nggo. Imba i nye na si angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Anishirr ba a ddu ma di, “Inta zhi nu Konelu ankpye abi ta iku wa ku. Uwa yo à tu inta. A si Unushirr uzizi na di kru isisu i Abachi. Ani Yahuda wemi a di nu ma inkpinkpye kakami. Unitu Abachi nggo à ddu ma di a bu du ba yo uwa, na bu wo inkindirr yi nggo uwa i ta da ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Mre Biturr à yo ba mirri na kpa ba ki abichirr ama. A zzu na ambre ka, i Biturr à gru ga ba, amuya banu abiga nu Jopa a ga ma. ");
INSERT INTO ninNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","A zzu nu uha wa na rri nu Kayisarriya. Meme nggo u Konelu so ko kye ba anko. Na yo amuyirr na akpukpama gbangba. ");
INSERT INTO ninNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nggo Biturr à ta ko mirri, i Konelu à gru nga ni ma na ku na anko, na ku ttu ku aza na chi ma. ");
INSERT INTO ninNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Biturr à ka, na du ma gru. Na ddu ma di, “Gru ki tsa, ingga mi i si unushirr nâ ta si ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Biturr à so re nu Konelu ku na rri kuma ni iko yi na ku hi anishirr shishemi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Na ddu ba di, “Imba mi i hi di a di han ani Yahuda ni na inkindirr bi nu undurr wanggo nggo à si si ani Yahuda hen. Na bu si kuma ni ichirr na ku hen. Uwa à si Abachi mu à tsarr di ingga bu si da du undurr à si uni hlo iki ka uni zɨ iki hen. ");
INSERT INTO ninNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ima yo du ba a ni yo ingga nggo ingga gru ni si ri anta hen. Di ingga i zhi ùwà, ùwà i tu ba yo ingga na angginggi?” ");
INSERT INTO ninNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konelu à sa ko di, “A su une̱ nggo ari, ingga so barr Abachi ni iko mungga. Nggo azhi wa à kasarr ba, mre unushirr à surr iki i la nzirrnzirr a kukri ki ingga na ashishi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Na yo ingga na ddu ingga di, ‘Konelu, Abachi à wo ibarr imuwa yi. Aseki ka ngga ùwà di nu abi iha ba nggo a so ku ni isisurr. ");
INSERT INTO ninNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Tu anishirr abanu kuma nu Jopa du ba ku yo ku uwa Sima nggo à ri Biturr. A se ni iko i Sima uni na anggakpa wa, nggo iko yi ì si nu unddu ku inyi wa nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Si ima yo ingga i gru tu ba korrmi, iwre nggo ùwà i nga nggo. Ziza nggo inta i si na age̱ ka Abachi ni ta wo pempe inkindirr yi nggo Abachi à di ùwà bu ni da ki inta nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Mre Biturr à gru bwu angu ddu ba di, “Ziza nggo yo ingga i hi di Abachi à si kpanye na abanu mri abanu hen. ");
INSERT INTO ninNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","A ti si anabata mi, na ti di kru isisu ima yi na na wre ku, uwa à ta kpa ma. ");
INSERT INTO ninNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Imba i hi ure ku nggo Abachi à nu ba gri ku ani Israila ba nggo. Ure ukuma yo ù si Ure ku wre ku di Yesu Kristi Atiko a anishirr ba wemi, uwa yo à gri iso isu. ");
INSERT INTO ninNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Imba i ka hi inkindirr yi nggo i la kago Yahudiya ba. Bazhi nu Galili, nu ugo ku nggo Yohana uni zzu na amasirr wa à bre ku anishirr di a bu nga du ba ni zzu ba na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Abachi à nu Yesu anu Nazareti Izhi Iwre yi tuku ukyekye. Abachi à se ni Yesu ku, nu nggo Yesu à zirr di na aseki azizi kago na du anishirr abangga ba nggo Isheta à de ba zu a wre. ");
INSERT INTO ninNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Inta mi i hi inkindirr yi nggo a na ni ìgbù nu Urushalima tuku igbu inuma ni Yahuda yi. A klo ma nu unkunkurr uwa a ttu. ");
INSERT INTO ninNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Unu utarr wa Abachi à ta ma ka si ni ibe yi, na du anishirr a hi ma. ");
INSERT INTO ninNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","A si si anishirr wemi mu a hi ma hen. A si inta nggo Abachi à hla di inta bu kuma ku da ku anishirr Ure ku wre ku nggo. Inta yo hi ma, ni ri, ni so na ku, nu ugo ku nggo a tasi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","À ttu ki inta ukorr di inta bu da are kago ku anishirr ba, ni bu da ba di uwa yo à si uwanggo nggo Abachi à ttu ma ki uni bre amu ku abi so tsitsirr na abi kɨ. ");
INSERT INTO ninNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Abi kpa are ka Abachi ba wemi a da ni itu ima yi di undurr wanggo ti kpanye na ku aba ta nggurr ila ure ima yi zhi ku nu ukyekye ku isa ima yi.” ");
INSERT INTO ninNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Biturr à so bre are angga ka mre Izhi Iwre i rri ku abi kri so wo are ka ni isisurr. ");
INSERT INTO ninNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ani Yahuda, abiga ba nggo a ga Biturr zhi nu Jopa a ku ayisurr di abangga ba nggo a si si ani Yahuda mi hen, Abachi à nu ba Izhi Iwre yi. ");
INSERT INTO ninNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Uwa a si nggo a hi anishirr abama a ko re ni irrirri inuma na nkanka nggo aba si hi hen, na so gbyarr ku Abachi asa ku ukyekye umaku. Biturr à ddu ba di, ");
INSERT INTO ninNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Abangga ba a kpa Izhi Iwre yi na ti inta i kpa nggo, angginggi ta han ni zzu ba na amasirr?” ");
INSERT INTO ninNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Na ddu ba di a bu zzu ba na amasirr ni isa i Yesu Kristi. Aba barr Biturr di a bu sha so ivi ntsɨ na ba bari. ");
INSERT INTO ninNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Abi ko na angu ba na amuya abiga ba nu Yahudiya a wo kago da abangga ba nggo a si si ani Yahuda hen a kpa ure ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nggo Biturr à kanga nu Urushalima abanu nggo a kpanye ni iyo iji yi a glo ma ");
INSERT INTO ninNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","di, “Ùwà kuma na anishirr abangga ba nggo a si yo ba iji hen, ni ku ri ila bi na ba.” ");
INSERT INTO ninNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Biturr à bre ba inkindirr yi nggo ì la zhi ni ime̱me̱ yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","À ddu ba di, “Ingga so barr Abachi ni ìgbù nu Jopa. Nggo ingga so tsitsirr ula ki ingga. Ingga ì hi ba a so gri upri inkru unkpi so ji zhi nu unkplassu, na a vu ku gri na atu wa ane̱ mi. U ji ni kukri hinga ni ingga ku. ");
INSERT INTO ninNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ingga kye nu umi ku ni hi ininazzu i akpre, na abi nga ngi nga tuku aminche abi ibwa. ");
INSERT INTO ninNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ingga i wo ukorr u ddu ingga di, ‘Biturr, gru ngɨ ni ta.’ ");
INSERT INTO ninNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Ingga ka sa ku ukorr ku di, ‘Atiko, ingga ka si ta abangga ba hen. Inkindirr ndanda na ankizhi nise rri na angu amungga kye.’ ");
INSERT INTO ninNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ukorr ku ù re ankpu aha wa zhi nu unkplassu di, ‘Inkindirr yi nggo Abachi à na yi ki izizi, ùwà bu si yo ki i ankizhi hen.’ ");
INSERT INTO ninNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","A na meme ki ankpu tarr, aba gba iki yi kakuma nu unkplassu zizo. ");
INSERT INTO ninNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Mre ingga kakye anishirr atarr nggo a tu ba ni ingga ku zhi nu Kayisarriya a ni kukri ni iko yi nggo ingga i so. ");
INSERT INTO ninNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Izhi yi da ki ingga di ingga bu ga ba, ni si ri amarr nanka hen. Amuya abiga atani ngga a ga ingga. Inta ku rri ni iko i ugo yi ma mi. ");
INSERT INTO ninNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Uwa da ki inta du uwa a hi unitu Abachi à kri ni iko ima na ddu ma di, ‘Tu ba kuma nu Jopa du ba ku yo ku uwa Sima nggo à rri Biturr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Uwa yo a ta gri ku uwa na anishirr bi iko muwa ba are angga ka nggo ta kpa imba ttungo nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ingga gru so re nggo Izhi Iwre yi ì rri na ba na ti nggo ì rri ni inta ba ni me̱me̱ yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Mre ingga ì ssu hi nggo Atiko wa a da di, ‘Yohana à zzu imba na amasirr, uwa ta si imba, aba taka zzu imba ni Izhi Iwre.’ ");
INSERT INTO ninNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Meme nggo uwa ta si Abachi nggo à nu abangga ba nggo a si si ani Yahuda hen, Izhi Iwre yi na ti nggo a ni inta abi kpanye na Atiko Yesu Kristi ku. Ingga ì su unggonggo ni kisa ku Abachi?” ");
INSERT INTO ninNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nggo a wo ma meme mre na zha inkindirr i da yi chankarr na ka so gbyarr ku Abachi asa di, “Abangga ba nggo a si si ani Yahuda mi hen, Abachi à nu ba ikpa ttungo ni na ndanda imbarr yi, na nu ba iso sese.” ");
INSERT INTO ninNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Abangga ba nggo a varr ki na nkanka ku iha yi nggo i gru ni ittu i Istifanu yi nggo à kru kuma nu Fonisiya tuku Sayiprosi, u Antakiya. Na bre ku ani Yahuda yo Ure ku wre ku na akpambarr. ");
INSERT INTO ninNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Abanu ambarr ba, aniru nggo a zhi nu Sayiprosi tuku Sirrene na kuma nu Antakiya na ku so bre ku anishirr ba nggo a di re ni irrirri i Girrki Ure ku wre ku ni itu i Atiko Yesu wa. ");
INSERT INTO ninNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ukyekye ku Abachi ku ù se na ba, anishirr shishemi a kpanye na ku na kpa Atiko wa. ");
INSERT INTO ninNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Abiga ba nu Urushalima a wo inkindirr yi nggo a la nu Antakiya na tu Barrnaba kuma nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nggo uwa mi à nga ni hi inkindirr yi nggo Abachi nu uzizi umaku à na yi na nyarr na nggurr ba di a bu kri ngbangba ni iga yi ni isisurr iyirr. ");
INSERT INTO ninNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barrnaba à su Unushirr uzizi, Izhi Iwre yi ì so na ku, uwa à kpanye na Abachi kakami. Anishirr shishemi a kpa Atiko nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barrnaba à ssuzzu kuma nu Taso du uwa ta ku zha Shawulu, ");
INSERT INTO ninNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","na ku hi ma nggo na gri ma na nga nu Antakiya. Abiga ba shishemi a nggurr bi ni inkla iyirr na ki ise iyirr, na di kpa itsarr i anu Barrnaba tuku Shawulu. A si na Antakiya yo aba yo abiga ba inkpu ime̱me̱ di abi si nâ ta si Kristi. ");
INSERT INTO ninNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Ni ivivi ima abi kpa are abanu a zhi nu Urushalima na nye nu Antakiya. ");
INSERT INTO ninNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","A yo unuma wa na ba di Agabu. Izhi yi i du ma a gru à re aseki ka nggo a ta la ni ichi. Uwa da di iyo ta ki kago ingbingbru yi namri. (Iyo ima yi ì ki na ase ka nggo Kladiyu à su Uttu unkpi wa.) ");
INSERT INTO ninNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Abiga ba wemi a gru shirr aseki ta zi amuya abiga ba ni Yahudiya. Anishirr a ni nâ ta si nggo ukyekye umbarr u nu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Na shirr aseki ka nu anu Barrnaba tuku Shawulu, di a bu kpa gri ku akikre anishirr ba. ");
INSERT INTO ninNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na attuttu a ka ma uttu Hirridu à gru so ki abiga abanu ba iha sama ni itito. ");
INSERT INTO ninNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","À ngu Yakubu, uzayirr a Yohana na anjingba. ");
INSERT INTO ninNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nggo à hi di ani Yahuda ba a nyarr, ni ina ima, na vu Biturr meme. A na inkindirr inggi ni ivivi nggo anishirr ba a so na iga inggi nggo a yo yi di Iga i Unfonfo ni Sama ni Iyisti. ");
INSERT INTO ninNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","A vu Biturr na gri ku harr, na du abi ta iku ba inkirr ine̱, na ane̱ne̱ nggo, so kye ma sarr kpa. Hirridu à na anko wa nggo a ta gri ma kuma ni Iga i Ivu Sarr bari na ka ttu Biturr a nu ba du bre ku amu. ");
INSERT INTO ninNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ima yo i du Biturr à kri ni harr. Ni ina ima mi, abiga ba a kri ni isisurr iyirr na barr Abachi ni itu i Biturr. ");
INSERT INTO ninNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ni ibittu yi nggo Hirridu ta zzu na ambre ka na ka gri Biturr ssuzzu ku anishirr ba du ba ni bre ku ure amu ka nggo, Biturr à rri kurr ku abi ta iku aha ba na atsutsu. Aba lo ma na ache aha. Abi gbye anko banu a kri na anko a imirri wa. ");
INSERT INTO ninNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Aba gru kakye unitu a Atiko wa a kukri, uru ula nu uki ku harr ku. Uwa tto Biturr nu ungba na si ma, na ddu ma di, “Narrma, gru!” Ache ka a kuhre ankpa yirr glo ku Biturr na ango. ");
INSERT INTO ninNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Unitu a Abachi wa à ddu ma di, “Surr ankru ni lo anggakpaza amuwa ka.” Biturr na ku meme yo. Unitu wa à ddu ma di, “Ba ankru amuwa ka abi ka garr ni ga mi.” ");
INSERT INTO ninNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Na ssuzzu, Biturr ga ma, na si hi di inkindirr yi nggo unitu wa so na i si jiji mu hen. Na kye du ula mu so ki ma. ");
INSERT INTO ninNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","A ni nggarr abi gbye abi ime̱me̱ ba tuku abu uha ba, na nga na anko wa nggo a na wa na ankpunkpu inklo. A di ba na anko ama yo na kuma nu umi ìgbù ku. Anko ama à bwu ba na nkpama, aba rri ba ma. Nggo a zirr na nggarr anko a ime̱me̱ wa, unitu wa a ka nado na du ma na nkpama. ");
INSERT INTO ninNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mre Biturr a hi di inkindirr inggi yi i si jiji. Na da di, “Ziza yo ingga hi di i si jiji. Atiko wa à tu unitu ama wa, uwa ni kpa ingga ttungo na ango ka Hirridu tuku aseki ka nggo ani Yahuda ba a ko kye di aba a ta na ki ingga nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nggo a hi meme, na tsi kuma ni iko i Maryamu, ayirr a Yohana nggo à yo ma ki Marrku. Anishirr shishemi a nggurr bi na so barr Abachi nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Biturr a nggurr anko a bi wa. Uvurr iko, uva nggo a yo ma di Roda à nga nye i kye à su unggonggo ko nggurr anko wa. ");
INSERT INTO ninNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nggo a wo ukorr ku Biturr ku na nyarr kakami na kru kakuma na si bwu anko wa hen. Na ku da ba di, “Biturr nggo kri na anko wa!” ");
INSERT INTO ninNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Aba ddu ma di, “Ùwà si ni ìlà.” Uwa kisa du uwa da su ure ujiji mu. Aba da di, “A su izhi i unitu wa nggo à di gbye ma mu.” ");
INSERT INTO ninNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Meme nggo Biturr à kri so nggurr anko wa. Nggo a bwu anko wa na hi ma na ku ayisurr. ");
INSERT INTO ninNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Biturr ki ba nu ungo di a bu ki ywi, na bre ba nggo Atiko wa à gri ma ssuzzu nu uki ku iharr ku nggo. Na ddu ba di, “Ku da ku ani Yakubu na amuya ba inkindirr inggi yi.” Na ka ba du na kuma na ntsandirr mu. ");
INSERT INTO ninNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na ambre ka abi gbye abubo ba a kye nkankarr mi na zhi di, “Biturr à ba nu momo?” ");
INSERT INTO ninNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hirridu à da ba di a bu zha ma kye. Aba à zha ma chankarr. Na du ba a yo abi gbye abubo ba ni zhi ba inado i Biturr yi, mre na da di a bu ngɨ ba. Nu ugo ku Iga i Unfonfo ni sama na iyisti wa, u Hirridu gru zhi nu Yahudiya ji kuma nu Kayisarriya, ku so ma ivi nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirridu à di se ni ivri na anishirr bu Taya tuku Sido ba. Anishirr bu Taya tuku Sido ba a nggurr bi nga ni vu ku Blasitu uza di à bu zi ba na re nu uttu wa ku. Uwa yo à si ankpye na akaba a uttu wa. Blastu à kpanye du uwa ta zi ba. Aba ku barr ma di aba a ta so zizi na ku, nu nggo aba mi di kpa ila zhi ni ìgbù ama wa yo. ");
INSERT INTO ninNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na azhibarr wanggo a ttu zu nggo, i Hirridu à surr inkinkru i ittu na so ni imburr ittu ima yi na re na anishirr ba ba. ");
INSERT INTO ninNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Aba hantu di, “Uwanggo à si si unushirr nggo à so re hen, à si ábáchí.” ");
INSERT INTO ninNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ankpa yirr mre unitu Atiko wa à nggurr ma ta yo, nu nggo à kpa inkpinkpye i Abachi, na na nâ ta si ábáchí mu. Inkɨ i ri ma, uwa ttu keke. ");
INSERT INTO ninNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ure ku Abachi ku u so kuchi kago. ");
INSERT INTO ninNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barrnaba tuku Shawulu a kre undu na ka zhi nu Urushalima, na ba Yohana, nggo à yo ma du Marrku à gri kye. ");
INSERT INTO ninNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Abi kpa are na abitsarr a se na abiga ba ba nu Antakiya. A si Barrnaba, u Simiyo, wanggo nggo a di yo ma di Niga (nggo su unushirr ushishirr), u Lukiyu anu Sirrene, tuku Manayi (nggo à furr ni inkla iyirr tuku uttu Hirridu nggo), u Shawulu. ");
INSERT INTO ninNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Nggo a so kuttu ku Abachi na vu angu, i Izhi Iwre yi ì ddu ba di, “Ttu anu Barrnaba tuku Shawulu zu ku undu ku nggo ingga ì yo ba na ku nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Mre aba a barr na vu angu, na sa ba ango ni itu na du ba kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Aba aha mi nggo Izhi Iwre yi tu ba nggo, a kuma nu Salukiya, na ku gru nabo a rri nu ddu na kuma nu Sayiprosi. ");
INSERT INTO ninNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nggo a se nu Salami, na bre ure ku Abachi ku na aki ka issubi ka ani Yahuda ka. Na gri Yohana Marrku di a bu di zi ba nu undu. ");
INSERT INTO ninNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A zirr kago igbu wanggo a amasirr a ka ma yo na atsutsu nggo na kuma nu Pafo. A ku hi unutirr unuma nabo. A di re anishirr du uwa di kye na hi inkindirr yi nggo i ta la ni ichi nggo. A si anu Yahuda. Aba yo ma ni irrirri i Girrki di Barr-Yesu. ");
INSERT INTO ninNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","A di se ndo nu Sajo Bulu, nggo à si krizhizhi ku, na si ugona ni igbu wa nggo amasirr wa a harr ma yo na atsutsu. Sajo Bulu à tu ba yo anu Barrnaba tuku Shawulu du uwa à ta ni wo ure ku Abachi ku na ba. ");
INSERT INTO ninNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Nggo Ilima uni ikagri wa (wanggo yo si inkpi isa yi ni irrirri i Girrki) à ta ukpa du uwa ta han ugona wa ni yo isisurr ima yi na Atiko ku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mre, Izhi Iwre yi gru nga ku Shawulu, nggo a di yo ma du Bulu, uwa kye uni ikagri wa girr, ");
INSERT INTO ninNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","na ddu ma di, “Ùwà uvuvurr a umimi, ùwà si di kpanye ni inkindirr yi nggo i di si izizi hen. Ni se na anko ka di re anishirr na amimi aseki ka ikagri, ni di da ba di are ajiji ka Abachi ka a si are ka imu. ");
INSERT INTO ninNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Atiko wa a ta nggurr ùwà ta yo ziza nggo, ùwà ta kaki unakreshishi ni si ta kye hi hen ma nu nggo Abachi a taka da nggo.” Mre Ilima kakye ame a ttu ashishi ama ka. Uwa à nga chacha di zha undurr wa nggo à ta gbu ma nu ungo nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nggo ugona wa à hi inkindirr yi nggo ì là nu Ilima ku, na ku ayisurr ni itsarr inggi yi ni itu i Atiko na yo isisurr na Atiko wa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Bulu na abi zirr ama ba a darr nu uddu ku zhi nu Pafo na nga ni igbu nu Pega nggo se na anga ka Pamfiliya nggo. Yohana nggo a yo ma du Marrku à ka ba du nabo na kakuma nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Aba gru zhi nu Pega na nga nu Antakiya na anga ka Pisidiya. Uwa si na Azhibarr a Isu Anu Yahuda wa, aba a rri ku so nu uki ku issubi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Nggo a bre kre zhi na Are ka Musa ka tuku icharr i abi kpa are ba Abachi ba, ankpinkpye bu uki ku issubi ba a tu ba nu anu Bulu ba di, “Amuya, imba ti si ni inkindirr i da ku anishirr ba imba re na ba.” ");
INSERT INTO ninNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bulu à gru kri na ki ba nu ungo, na da di: “Amuya ani Israila na abangga nggo a kuttu ku Abachi wemi na a si si anu Yahuda hen, imba wo yi! ");
INSERT INTO ninNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Abachi à anishirr bu Israila à ttu akiki amunta ba na na ba ki anishirr abi inkpinkpye nu nggo a si abichirr ni ìgbù nu Masarr. Abachi à gri ba ssuzzu nu Masarr nu ukyekye unkpi umaku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Aba si kpanye na ku hen, uwa vu isisurr na so di zirr na ba na ankpu jiji wa ki ase iso ne̱s (40). ");
INSERT INTO ninNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","À ngɨ igbu itangba na tsi ako ambarr wa nggarr na anga ka Kenanu ka, na ka anishirr ama ba ki akikye bi igbu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","A ba ma ase ayiyirr ane̱ ni iso ikywi (450) ngga na na aseki akama. “Nu ugo ukuma uwa à nu ba abi bre amu aba di se meme yo nga ni ma ku Samwila, uni kpa are a Abachi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nggo a gru so zha uttu, Abachi a nu ba Shawulu uvuvurr a Kishi, nggo zhi nu uga ku Benyami. Uwa a hru ittu yi ki ase iso ne̱s (40). ");
INSERT INTO ninNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nu ugo kuma, u Abachi à ttu Shawulu glo ni ittu yi na na Doda ki uttu wa. Wo inkindirr yi nggo Abachi a da ni itu Doda, ‘Ingga ì zha Doda uvuvurr a Jesi i hi nggo à su Unushirr wanggo a kuma ki ingga ni isisurr. A su unushirr wanggo nggo à ta na inkindirr inggi yi nggo ingga da ku di a bu na yi nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Abachi à na uhanma a Doda nggo ki uwanggo nggo à ta ni kpa anishirr bu Israila ttungo nâ ta si nggo à da zu nggo. Ugo uwama yo à si Yesu. ");
INSERT INTO ninNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Nggo Yesu à nise ssuzzu undu umaku, i Yohana a di bre ku anishirr bu Israila ba wemi da a bu ba ila ure imbarr yi ttungo, na ka isisurr imbarr yi kanga na Abachi ku, na bu du ba zzu ba na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Nggo Yohana a ta so kre undu umaku na ddu anishirr ba di, ‘Imba kye di ingga su unggonggo? Ingga i si si uwanggo nggo imba so kye ku anko hen. Kye yi, ingga ta kre bari uwa ta nga. Ingga i si ma uni ddu ku azhizhi ka anggakpaza hen.’ ");
INSERT INTO ninNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Amuya, ahan ma bu Ibrayi na abangga ba nggo a si si anu Yahuda hen na di barr Abachi, kye a gri ki inta yo ure ku ikpa ttungo unggo ku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Anishirr ba nggo a so nu Urushalima na ankpinkpye ambarr ba, a di bre angbamvu ka abi kpa are ba na Azhibarr a Isu anu Yahuda wa na si hi inkpi i are yi hen. A ngu Yesu na si hi di aba a ko na si inkindirr yi nggo a ka da zu mu ba hen. ");
INSERT INTO ninNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Nu nggo a si hi ma ni ila hen, na si hi inkpi i ngu ma yi hen, na ka na ddu Bilatu di a bu du ba ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nggo a na aseki ka wemi nggo angbamvu ka Abachi ka a da di a taka na ku Yesu na ka nggo, na ttu ma ji nu unkunkurr ku klo ku na kama yo ni ibe. ");
INSERT INTO ninNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Abachi à ta ma si ni ibe yi. ");
INSERT INTO ninNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Uwa kanga ni di zirr ki ivi shishemi, anishirr ba nggo a di ga ma zhi nu Galili kuma nu Urushalima, a hi ma. Abama yo a ka di da ku anishirr bu Israila aseki ka ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Abachi à da zu ku ábáchí amunta ba aseki ka nggo uwa à taka na ba nggo, inta nye bre ki imba Ure ku wre ukuma yo. ");
INSERT INTO ninNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ziza nggo Abachi à na ki inta, ahinhan ambarr ba inkindirr ima yo, nu nggo a ta Yesu si ni ibe. Uwa a si meme yo nggo a charr nu Ungbamvu ku Asarr ka Igbyarr Asa ku uha ku da di: “ ‘Ùwà su Uzumu; ari ingga kaki Aki amuwa.’ ");
INSERT INTO ninNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Abachi à ta Yesu si ni ibe, na si du ukpa umaku u bo hen. Ni ima yo Abachi à da di: “ ‘Ingga ta ni imba ida zu iyiyirr ima yo nâ ta su nggo ingga da zu ku Doda.’ ");
INSERT INTO ninNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nâ ta si nggo a da nu Ungbamvu ku Asarr ka Igbyarr Asa unuma ku di: “ ‘Ùwà si ta du Uni wre amuwa wa à bo ni ibe hen.’ ");
INSERT INTO ninNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Doda à na undu ku Abachi ma ni ittu. A zzu ma hinga na ábáchí ama ba ba, uwa a bo. ");
INSERT INTO ninNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","A ta su uwanggo nggo Abachi à tasi nggo, à si bo hen. ");
INSERT INTO ninNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Ima yo, imba amuya wemi, bu hi gbigbi di ure ku nggurr ila ure zhi ku u zhi ni inkindirr yi nggo Yesu à na na nkpama nggo inta so bre ki imba. ");
INSERT INTO ninNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Imba bu hi di undurr wanggo à ti kpanye ni Yesu ku, aba a kpa ma ttungo ni ila ure ima yi nggo Are ka Musa ka a ma chankarr ni kpa ma ttungo nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ki bwe, ni si du ure ku abi kpa are ku ka ùwà vu hen. ");
INSERT INTO ninNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“ ‘Kye yi, imba abangga ba nggo re are andanda ni itu inkindirr yi nggo Abachi à da nggo, ku ayisurr ni kɨ yi. Ingga ì ta na inkindirr ni ivi imba yi, uwa si inkindirr inggi yi nggo undurr ka ti bre ki imba mi, imba si ta kpanye hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Nggo anu Bulu tuku Barrnaba a ta so ka share nu uki ku issubi ku ani Yahuda ku, anishirr ba ddu ba di a bu ka kanga ni bre ba aseki angga ka zizo na Azhibarr a Isu à so nga anu Yahuda wa. ");
INSERT INTO ninNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nggo anishirr a gru ni issubi yi nggo ani Yahuda shishemi na abangga ba nggo a so ga iga i ani Yahuda yi, na so kuttu ku Abachi à gru so ga anu Bulu tuku Barrnaba. Anu Bulu a re na ba, na tsi ba ango di a bu si kakuma nu ugo hen, na bu kye uzizi ku nggo Abachi à na ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","A zzu na Azhibarr a Isu anu Yahuda a uha wa, anishirr ba ni ìgbù wa a ssuzzu wemi nga ni wo ure ku Atiko ku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Nggo ani Yahuda ba a hi akpa anishirr wa nggo na zha di a ka si aba mu, na re are ndanda ni itu i ure ku Bulu ku na marr ma. ");
INSERT INTO ninNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mre anu Bulu tuku Barrnaba a si kru undurr hen, na ddu ba di, “A si gbigbi mu inta bu da ki imba yo ure ku Abachi ku kuchi bari ni ka ku bre ku abanu meme. Imba kà ku. Ima tsarr di imba si so zha iso sese hen. Ziza inta ko kuma na abangga ba nggo si si ani Yahuda hen. ");
INSERT INTO ninNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Uwanggo yo si inkindirr yi nggo Abachi à di inta bu na: “ ‘Ingga na ùwà ki uru ku la ku abangga ba nggo si si anu Yahuda hen, wre ku ùwà bu gri ikpa ttungo nga ku anishirr we ni ingbingbru yi.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nggo abangga ba nggo a si si anu Yahuda hen a wo ure ukuma, na nyarr na gbyarr ku Abachi asa nu ure kuma. Abangga ba nggo Abachi à ka hla ba di a taka so sese nggo, a yo isisurr na Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ure ku Abachi ku ù bwa kago na anga akama. ");
INSERT INTO ninNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Anu Yahuda ba a ddu aniru abangga ba nggo a kye ba ssu na ango ni ìgbù wa, na amba abi kru isisu i Abachi, nggo a di kye ba ssu na ango, aba gru so ki anu Bulu tuku Barrnaba iha ni ìgbù wa, na han ba share na anga ka igbu ambarr ka. ");
INSERT INTO ninNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Abi ko na angu ba a ttu ihurr yi na aza ambarr ka surr ku igbu uwama na kuma nu Ikoniya. ");
INSERT INTO ninNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Abiga ba nu Antakiya a nyarr kakami, Izhi i Iwre yi ì tsarr ssu ba ni isisurr kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ni Ikoniya anu Bulu tuku Barrnaba a na meme yo nâ ta si nggo a na nu Antakiya nu Pisidiya nggo. A rri kuma nu uki ku issubi ku anu Yahuda ku. Na ku re kakami, ani Yahuda ba na abangga ba nggo a si si ani Yahuda hen shishemi a kaki abiga. ");
INSERT INTO ninNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ani Yahuda ba nggo a si kpa ure ku hen, a gru tto abangga ba nggo a si si anu Yahuda hen, na du ba a ki unfu na amuya abiga ba ba. ");
INSERT INTO ninNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Anu Bulu tuku Barrnaba a sha so ta anko nabo, na re ure ku Abachi ku sama ni isisu. Abachi a nu ba ukyekye na du ba na aseki ka ikagri na ka ki isisu, nggo a tsarr di ure umbarr ku ni itu ina wre i Abachi yi ù su ujiji. ");
INSERT INTO ninNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","A kpa anishirr wa nu umi ìgbù ku a ga ki aha na amarr ambarr ka. Abanu a kpanye ni inkindirr yi nggo anu Yahuda ba a so da. Abanu ba a kpanye nu Bulu tuku Barrnaba, abi ko na angu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Mre abangga ba nggo a si si anu Yahuda hen, na anu Yahuda ba, na ankpinkpye ba, a zha anko wa nggo aba ta ki ba ankpa, na ta ba na angbinta. ");
INSERT INTO ninNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Abi ko na angu ba a wo nggo na kru kuma na anga ka Likoniya na mirri ni ìgbù i Lisitra tuku Debe tuku ìgbù yi nggo se nabo, ");
INSERT INTO ninNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","na ku bre Ure ku wre ku. ");
INSERT INTO ninNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ugo uni mɨ aza numa à se nu Lisitra. Zhi nu nggo a ngri ma mu à si di zirr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","A so na ko wo ure ku Bulu ku, u Bulu à kye ma girr na hi du ugo wa à se ni iyo isisurr yi nggo ta du ma wre, ");
INSERT INTO ninNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","na du hantu di, “Gru kri ki kri.” Ugo wa à tu ki tsa na gru so zirr kago. ");
INSERT INTO ninNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nggo akpa anishirr wa a hi inkindirr yi nggo Bulu a na, na hantu na ako ambarr ka ani Likoniya da di, “Ábáchí ba a kaki anishirr na ji nga ni inta ba!” ");
INSERT INTO ninNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","A yo Barrnaba di Zeyusi, na yo Bulu di Hemisi, nu nggo uwa yo à su uni so re wa. ");
INSERT INTO ninNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Unikye a ábáchí Zeyusi wa nggo uki ku ibarr umaku u si na abi ka ìgbù ka, a kuma ku gri ilando iniru tuku ugbyarr ku unkunkurr gri na nga na angu ankonki ka ìgbù ka di aba a ta han ilando yi a to ku anu Bulu tuku Barrnaba. ");
INSERT INTO ninNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Nggo anu Barrnaba tuku Bulu, abi ko na angu ba, a wo inkindirr yi nggo anishirr angga ba a ta ko na nggo, mre na nga inkinkru imbarr yi hre na kru rri na atsutsu ka anishirr ba na hantu di, ");
INSERT INTO ninNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Imba ko na meme da angginggi? Inta si anishirr nâ ta si imba. Inta nga nye i da ki imba Ure ku wre ku Yesu ku ni bu ka imba glo na aseki andanda angga ka yo, ni ka imba kakuma na Abachi uni so tsitsirr ku nggo na unkplassu tuku imimi, amasirr na aseki wemi nggo a se nu umi umbarr ku. ");
INSERT INTO ninNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ni ikuchi yi à du anishirr wemi a ga anko na nkanka. ");
INSERT INTO ninNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ni na ima mi, Abachi a na aseki azizi nggo a ta du anishirr a hi di uwa à si Abachi. A du ahru a ji zhi nu ussu. Na du ikiri wri. A ni imba ila, na ni imba inyarr ni isisurr.” ");
INSERT INTO ninNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Nu ure unggo ku mi, anu Bulu kisa kakami bari anishirr ba a ba ttungo ni ito yi. ");
INSERT INTO ninNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ani Yahuda abanu a zhi nu Antakiya nu Pisidiya, abanu a zhi nu Ikoniya, na nga ni na anishirr ba du ba kpanye na ba, na ta Bulu na angbinta, na kye di a ttu. Na gba ma ssuzzu nu umi ìgbù ku. ");
INSERT INTO ninNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Nggo abiga ba a ni nggurr bi kago ma, uwa à gru na kakuma nu umi ìgbù ku. Nggo ambre ka nggarr aba tuku Barrnaba a kuma nu Debe. ");
INSERT INTO ninNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Anu Bulu tuku Barrnaba a bre Ure ku wre ku nu Dabe. Anishirr shishemi a kpa Yesu. Aba kakuma nu Lisitra, na ku kuma nu Ikoniya tuku Antakiya nu Pisidiya. ");
INSERT INTO ninNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Aba nggurr abiga ba na ddu ba di a bu kri karrkarr ni iga yi, na da ba di, “Inta abiga wemi a ta ki iha kakami bari na rri ni ittu i Abachi yi.” ");
INSERT INTO ninNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","A ti rri na abiga ba ba na aki ka nggurr bi ka Abachi we, aba a di ddu abanu ki ankpinkpye, na barr Abachi, na vu angu bari na ka ba sa na ango ka Abachi wa, nggo a yo isisurr imbarr yi na ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nggo a zirr anga ka Pisidiya ka kre na rri nu Pamfiliya. ");
INSERT INTO ninNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A ku bre Ure ku wre ku nu Pega na ji kuma nu Ataliya. ");
INSERT INTO ninNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A gru zhi nu Ataliya na darr nu uddu ka kakuma nu Antakiya na anga ka Sirriya. A si nabo yo nggo abiga ba a ka anu Bulu tuku Barrnaba sa na ango ka Abachi ni itu i undu ku nggo a na kre nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ni nggurr surr imbarr nabo, aba yo abiga ba nggurr bi, na da ku anishirr ba aseki ka nggo aba na, nggo Abachi à zi ba tuku nggo à du abangga ba nggo si si anu Yahuda hen a yo isisurr ni Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A so ta anko na abiga ba ba nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Anishirr abanu a zhi nu Yahudiya na nga nu Antakiya ni so tsarr amuya abiga ba da di, “A ta si yo ku Unushirr iji nâ ta su ure ku Musa ku u da di a bu na hen, Abachi à si ta kpa undurr uwama ttungo hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Anu Bulu tuku Barrnaba a ri anta na vi na ba ku ida ima yi. Ima yo i du abiga ba a da di anu Bulu tuku Barrnaba, na abanu nu Antakiya a bu kuma ku hi abi ko na angu ba tuku ankpinkpye ba nu Urushalima ni itu i ure kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Abiga ba a gri ba ku yo na anko, aba a ba nu Fonisiya tuku Samarriya na di bre ba di abangga ba nggo a si si ani Yahuda hen, a kpa Abachi. Ure kuma u du abiga ba a nyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nggo anu Bulu à rri nu Urushalima nggo, abiga ba na abi ko na angu ba na ankpinkpye ba a kpa ba na ango aha. Anu Bulu a bre ba aseki ka nggo Abachi a na nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Abiga abanu ba nggo a se ni nggurr bi i anu Farrisi yi a gru na da di, “A bu yo ku abangga ba nggo si si anu Yahuda hen iji na du ba a di na inkindirr yi nggo Are ka Musa ka a da nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Abi ko na angu ba na ankpinkpye ba a nga ni nggurr bi na bɨ ure ukuma kye. ");
INSERT INTO ninNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nggo a ri anta ta anko, i Biturr à gru kri na ddu ba di, “Amuya amungga, imba i hi di Abachi à yo ingga zhi ni imba ba di ingga bu bre Ure ku wre ku, ku abangga ba nggo a si si anu Yahuda hen. Meme nggo a ti wo aba a ta kpanye. ");
INSERT INTO ninNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Abachi nggo à hi amarr ka anishirr, a kpanye na abangga ba nggo a si si ani Yahuda hen, na nu ba Izhi Iwre meme yo nâ ta si nggo a ni inta. ");
INSERT INTO ninNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Abachi a si kye inta nanka na ba hen. A kpanye na ku nggo, uwa à ngla isisurr imbarr yi. ");
INSERT INTO ninNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Angginggi du imba zha itsarr Abachi kye, ni vu angbungbru iki angga ka i de abiga ba nggo a si si anu Yahuda hen, nu ugo nggo inta mi na ábáchí amburr ba ka si ba ka kpa hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Iya, ka si si meme yo hen. Inta kpanye di Abachi à kpa inta ttungo nu uzizi ku nggo Yesu a na ki inta nggo. Abachi a kpa aba mi ttungo meme yo.” ");
INSERT INTO ninNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Anishirr ba wemi a ba ki ywi nggo a wo anu Bulu tuku Barrnaba so bre aseki ka iku ayisurr na ka ikagri ka nggo Abachi à du ba na ku anishirr abangga ba nggo a si si ani Yahuda hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nggo a re kre, u Yakubu a gru ddu ba di, “Wo ingga yi amuya! ");
INSERT INTO ninNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Sima à bre ki inta inkindirr yi nggo Abachi à na zhi ni ime̱me̱ yi, nggo à ttu abanu nu umi ku abangga ba nggo a si si anu Yahuda hen ki anishirr ama. ");
INSERT INTO ninNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Abi kpa are ba mi a da meme yo ni itu i ure unggo ku, nu nggo angbamvu ka Abachi ka da di, ");
INSERT INTO ninNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘Ni ichi ingga ta kanga, ni vu àko ka Doda ka me. Ime yi nggo a na yi ki ndanda ingga ta vu yi me, ni ta na yi ki kyekye, ");
INSERT INTO ninNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","wre ku inkpu anishirr yi nggo a ni so tsitsirr ni ingbingbru yi, abangga ba nggo a si si ani Yahuda hen a bu ga anko a Atiko wa. Ingga, Abachi yo nggo i da meme. ");
INSERT INTO ninNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Atiko wa yo à du anishirr ba hi meme ngbangbamu.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakubu à ddu ba di, “Ni ikye mungga, abiga abangga ba nggo a si si ani Yahuda hen, nggo so kanga na Abachi ku, inta bu si ki ba iha gigyemi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ni ina ima, i wre inta bu charr ungbamvu bre ba, di a bu si ri ila inggi yi nggo a di zzu ku anazhi ngga na yi hen, na bu si di yo atu ambarr na are ka zha amba ka aniru hen, na bu shi inina yi nggo a si han ayiyi wa kahre ku ininazzu wa hen, na bu si ta ayiyi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Inta bu hi di a di bre Are ka Musa ka ni igbu yi we zhi ngbangbamu, na di bre ka ttuttumi ni Ivi i Isu i anu Yahuda yi nggo anu Yahuda ba ti nggurr bi.” ");
INSERT INTO ninNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","A kye meme nggo, abi ko na angu ba, na ankpinkpye ba, na abiga ba wemi, a ddu anishirr abanu a kye ku anu Bulu tuku Barrnaba, na tu ba kuma na Antakiya. Na ttu Judasi (nggo ri Basaba) tuku Sila, abiga ba a di kye anishirr aha aba ma ssu na ashishi. ");
INSERT INTO ninNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Na tu ba nu angbamvu angga ka di: Inta abi ko na angu na ankpinkpye ba, nggo si amuya amba we, Inta so chi imba we, Amuya abangga ba nggo a si si ani Yahuda hen, zhi nu Antakiya, tuku Sirriya, tuku Silisiya. ");
INSERT INTO ninNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Inta wo di abanu munta ba a nga ni imba ba, ni ko bre ki imba are ka nggo gri ki imba uvi tuku iso ndanda. Inta ngga si tu ba meme hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ima yo di inta nggurr bi ni tu abanu ni imba ba. A ta ga akpamburr munta ba anu Bulu tuku Barrnaba nggo inta kpanye na ba kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","A so na undu ku Atiko Yesu Kristi ni ittu na ashishi. ");
INSERT INTO ninNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Inta so tu Judasi tuku Sila. Ni ima yo aba mi ta bre ki imba na akpambarr aseki ka nggo inta charr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Izhi Iwre i kye i si ta wre aba bu di imba ki iha numa zizo hen. Inta mi kpanye meme yo. Imba bu na aseki angga ka yo mre. ");
INSERT INTO ninNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Imba bu si ri ila inggi yi nggo a di zzu ku anazhi ngga na yi hen, ni si ta ayiyi hen, imba bu shi inina yi nggo a si han ayiyi wa kahre ku ininazzu wa hen, ni si zha ayamba ka unuru wa nggo si si amuwa hen. Imba ti na meme i ta wre ki imba. Abachi bu di imba so zizi. ");
INSERT INTO ninNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Abitu ba a gru nu Urushalima, aba gri ba ku yo na anko. Aba kuma na Antakiya na ku yo abiga ba ni inkla iyirr na nu ba ungbamvu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Anishirr ba a bre ungbamvu ku na nyarr na kaki kyekye. ");
INSERT INTO ninNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Anu Judasi tuku Sila nggo a si abi kpa are ka Abachi, a bre ku abiga are ka ta anko. Are kama a du abiga ba vu isisurr na kaki ukyekye. ");
INSERT INTO ninNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nggo a sha so nabo abiga ba a gru yo ba na anko ni isisurr iyirr. Aba kakuma na abangga ba nggo a tu ba nggo.  ");
INSERT INTO ninNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Sila nanko à so nabo na si ga ba hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Anu Bulu tuku Barrnaba a ku sha so ma ivi nu Antakiya, na bi na abiga abanu ba na bre ure ku Atiko ku. ");
INSERT INTO ninNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nggo a sha so ki ivi nabo u Bulu à gru ddu Barrnaba di, “Di inta ka ga igbu yi nggo inta i bre ba ure ku Atiko ku ni kye abiga ba nu uzirr umbarr ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barrnaba a zha di aba bu gri Yohana, nggo a yo ma du Marrku kye, ");
INSERT INTO ninNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","u Bulu à kisa di Yohana à si ta ga ba hen, na da di à ku ka aba du nu Pamfiliya nu uzirr ku ime̱me̱ ku na si ga ba kuma ni ikikre yi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","A ri anta kakami nu ure ukuma na ga ki na nkanka. Barrnaba a ba Marrku na ga uddu ku amasirr kuma nu Sayiprosi. ");
INSERT INTO ninNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","U Bulu na anko, à ttu si Sila nggo di à bu ga ma. Abiga ba a barr Abachi bu hru ba zizi. ");
INSERT INTO ninNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Aba ba nu Sirriya tuku Silisiya na so nggurr abiga ba na aki ka nggurr bi ka Abachi ka di aka bu kri ngbangba. ");
INSERT INTO ninNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulu à kuma nu Debe na ku gru nabo kuma nu Lisitra. Uniga numa a ri Timoti à se nabo. Ayirr ama wa a si ani Yahuda na si uniga meme. Aki wa yo à si anu Girrki. ");
INSERT INTO ninNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Amuya abiga ba nu Lisitra tuku Ikoniya a re are zizi ni itu Timoti. ");
INSERT INTO ninNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Bulu à zha du uwa ka gri Timoti kye, ni ima yo uwa à du ba a yo ku Timoti iji. Ani Yahuda ba wemi nggo a si ni igbu ima a hi di aki a Timoti wa à si anu Girrki, ima yo du Bulu à du ba yo ku iji yi. ");
INSERT INTO ninNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","A di ga ìgbù yi nggo na di da ba aseki ka nggo abi ko na angu ba na ankpinkpye ba nu Urushalima a da a bu na nggo. Na ddu ba di a bu ga are kama. ");
INSERT INTO ninNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Meme nggo abiga ba na aki ka nggurr bi ka Abachi a ka kri ngbangba nu ure ku Abachi ku, na gru so ngri mwe ni ivivi yi. ");
INSERT INTO ninNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Anu Bulu a zirr ba na a nga ka Frigiya tuku Galatiya. Izhi Iwre yi i si du ba a da itu yi na anga ka Asiya hen. ");
INSERT INTO ninNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nggo a nga nu udirr ku Misiya na zha di aba ka rri nu Bitiniya, Izhi i Yesu yi i han ba ni rri yi. ");
INSERT INTO ninNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Aba kye na tsi ba nu Misiya na ji kuma nu Torrowa. ");
INSERT INTO ninNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","I ni ibittu ula u ki Bulu di Unushirr nu Makidoniya a nga ni kri so barr ma di, “Nga nu Makidoniya ni zi inta.” ");
INSERT INTO ninNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nggo ula ku ki Bulu meme nggo inta i hi di Abachi a ko da di inta bu bre ku anishirr bu Makidoniya ure umaku mre inta ttu kpa ku kuma ni Makidoniya wa. ");
INSERT INTO ninNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Inta gru nu Torrowa nu uddu ku amasirr ni darr ba nu Samotrakiya. Ambre ka nggarr inta nga nu Niyapoli. ");
INSERT INTO ninNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ni gru nabo i rri ga umi kuma nu ìgbù unkpi nu Roma numa na anga ka Makidoniya ka. A yo ma di Filipiya. Inta i sha so mwe ivi nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Na Azhibarr a Isu anu Yahuda wa inta ssuzzu ni ìgbù wa ni kuma nu unddu ku inyi ku ni kye di inta ta hi abubo wa nggo ani Yahuda ba a ku di barr Abachi nggo. Inta ku so ni re na amba ba nggo a ni nggurr bi nabo nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ayamba numa nggo a wo inta ni so re yi a ri Lidiya na zhi nu Tiyatirra. À gri iki isurr ì kri inklo nggi di re. Ayamba ama wa à di ga Abachi. Atiko wa à bwu ku isisurr na du ma shirr ku Bulu atu. ");
INSERT INTO ninNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","A zzu ba na abi iko ma ba na amasirr wa nggo, uwa ga inta na di tsi ki inta ango di, “Imba ti kye ingga ki uniga a Atiko ujiji, imba bu nga ni so ni iko imungga.” Na na inta di inta gru ga ma. ");
INSERT INTO ninNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Azhibarr anuma nggo inta i so kuma na abubo a ibarr Abachi, ni zzu ma nu uva ugarr numa ku na anko. A si ni izhi indanda. Izhi yi i di du ma a da aseki ka nggo a taka là ni ichi nggo. Na di kpa ku akikye ama ba azo ni ina ima. ");
INSERT INTO ninNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Uva wanggo à ga inta na anu Bulu na di hantu di, “Anishirr angga ba a si amirr iko ba Abachi Unkpi Kakami wa. Aba yo di tsarr anko a ikpa ttungo a Abachi wa.” ");
INSERT INTO ninNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Uva wa à ga ba na di na meme ni ivivi yi. Unfu gru ki Bulu, uwa kasarr na ddu izhi yi di, “Nu ukyekye ku nggo u se ni isa i Yesu Kristi, ingga du ùwà bu ssuzzu nu uva wa ku!” Mre, izhi yi i ssuzzu glo nu uva wa ku na attuttu ama wa. ");
INSERT INTO ninNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nggo akikye ama ba à hi di anko a azo ambarr wa nu uva wa ku a tarr han ba, mre na du ba vɨ anu Bulu tuku Sila gri na kuma na abubo a ibre amu wa nggo à se ni inkla i ri udu yi. ");
INSERT INTO ninNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Na gri ba kuma na abi bre amu ba ba na ku ddu ba di, “Anishirr angga ba a si ani Yahuda, na nga ni ko tto itsi ni ìgbù amunta wa. ");
INSERT INTO ninNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","A nga ni ko tsarr itsarr ihe̱he̱ di inta bu na aseki anuma ngga nggo inta si di na na ako munta hen. Inta sa anu Roma ni si di na aseki akama hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Anishirr ba a gru zi ba kuttu anu Bulu tuku Sila. Ankpinkpye abi bre amu ba a du ba nga inkinkru i anu Bulu yi tuku Sila nga hre, na da ku anishirr ba di a bu hlo ba na amfarr. ");
INSERT INTO ninNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","A hlo ba kakami na gri ba ku harr na da ku uni harr abubo wa di a bu harr ba gbangba. ");
INSERT INTO ninNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Uni harr abubo wa à na inkindirr yi nggo a da ku nggo. A gri ba ku harr na abubo wa nggo a harr wa nu umi kakami, na lo ba ache na aza gri ku lo na ankpunkpu inkinkurr ankpinkpi. ");
INSERT INTO ninNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Na atsutsu ibittu nggo anu Bulu tuku Sila a so barr Abachi na so ru asarr. Abi kri ni iharr abanu ba a so shirr atu. ");
INSERT INTO ninNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mre aba gru wo abubo wa a battu kakami. Anko ka abubo a harr ka a bwu. Ache ka a ddu hre ku anishirr ba we na ango. ");
INSERT INTO ninNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Uni kye abi kri harr ba à kasi na hi anko ka a kru ibwu yi na kye di abi kri ni harr ba a ssuzzu kuma nado ba. Na ttu anjingba ama ka du uwa ta ngu itu ima. ");
INSERT INTO ninNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Nggo Bulu à nggarr ito na ku da di, “si han ukpa muwa hen, inta ngga so wemi!” ");
INSERT INTO ninNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Uni kye abi kri iharr ba a du ba gri ku uru. Na kru ku jaku so wri kpakpa ku anu Bulu tuku Sila na aza. ");
INSERT INTO ninNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na ddu ba ssuzzu na zhi ba di, “Ingga ta na ki ngginggi ni du ba kpa ingga ttungo?” ");
INSERT INTO ninNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Anu Bulu a ddu ma di, “Ùwà bu kpanye na Atiko Yesu ku, uwa ta kpa ùwà ttungo na abi iko amuwa ba.” ");
INSERT INTO ninNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Mre aba bre ku na abi iko ima ba we ure ku Atiko ku. ");
INSERT INTO ninNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ni ibittu ima, uni harr abubo wa à gri anu Bulu a ssuzzu ku ngla ba ankpa ka. Aba a zzu ma na abi iko ima ba we na amasirr keke. ");
INSERT INTO ninNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Uni kye abi kri ni iharr wa a gri anu Bulu na kuma ni iko ima, na ku nu ba ila ri. Uwa na abi iko ma ba a nyarr kakami nggo a kpanye na Abachi ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","A zzu na ambre ka, abi bre amu ba a tu abi ta iku ba di a bu da ku abikye abi kri ni iharr ba di a bu ttu anu Bulu ttungo du ba kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Uni kye abi kri iharr ba a ddu Bulu di, “Abi bre amu ba a tu ba di ingga bu ddu ùwà tuku Sila ttungo di imba kuma. Imba bu ssuzzu kuma ywiywimi.” ");
INSERT INTO ninNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","U Bulu a ddu abi lo ukpa ba nggo a tu ba nggo di, “Inta i si na inkindirr numa indanda hen, aba a gri inta ku hlo na ashishi ka anishirr na ábì. Nu nggo inta i si anishirr abu Roma mi, aba ka na gri inta ku hlo na ashishi ka anishirr na si wo ure umunta ku bari hen. Na turr inta surr nu uki ku iharr. I ziza nggo aba da aba ta ddu inta ttungo na yi? Inta kà. Du ankpinkpye bu Roma abangga a ta nga ni ddu inta ssuzzu na ki imbarr.” ");
INSERT INTO ninNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Abi lo ukpa ba nggo a tu ba di a bu ni ddu anu Bulu ttungo nggo a kakuma ku da ku abi bre amu ba. Nggo abi bre amu ba a wo di anu Bulu tuku Sila a si anu Roma, isisu ki ba. ");
INSERT INTO ninNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ima yo du ba a nga ni tsi ku anu Bulu ango, na gri ba ssuzzu nu uki ku iharr ku na ddu ba di a bu share ni ìgbù wa. ");
INSERT INTO ninNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Bulu tuku Sila a ssuzzu nu uki ku iharr ku na kuma ni iko i Lidiya. Nggo a ku hi amuya abiga ba nabo na re ba ure ku nggo ù ta nu ba ukyekye. A re kre nggo na kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Anu Bulu a zirr ba ni igbu yi nggo a yo yi di Amfipoli tuku Apoloniya na nga nu Tesalonika, nggo uki ku issubi ku ani Yahuda ku u se nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulu a rri ga ba nu uki ku issubi ku nâ ta à di na ttuttumi. Bulu a ki Ivi Isu ani Yahuda yi itarr, na ku di re na anishirr ba ba nu ure ku Abachi ku. A di bre ba inkindirr yi nggo ure ku u da nggo, ");
INSERT INTO ninNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","na di bre ure ku Abachi ku a tsarr anishirr ba di i wre u Kristi wa nggo Abachi à ttu ma na tu ma a ta ki iha na tasi ni ibe. Bulu a ddu ba di, “Yesu uwama yo ingga ko da ki imba ure umaku, uwa yo à si Kristi wa.” ");
INSERT INTO ninNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ani Yahuda abanu ba a kpanye nu ure ku anu Bulu ku na nggurr bi na di zirr na anu Bulu ba tuku Sila. Anu Girrki abanu shishemi nggo a di kru isisu i Abachi, a bi na amba ankpinkpi ni igbu wa na nggurr bi na di zirr na anu Bulu ba tuku Sila. ");
INSERT INTO ninNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ani Yahuda ba a ki unfu nggo anishirr shishemi a kpanye nu ure ku Bulu ku. Na kuma ku yo anishirr amimi nggo a so gigyemi a nggurr bi ki abi tto itsi. A na meme na du anishirr gru so tto itsi ni ìgbù wa, na narr kuma ku ttu iko i Jaso na so zha anu Bulu tuku Sila wre ba bu gri ba ssuzzu nga ku akpa anishirr wa. ");
INSERT INTO ninNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nggo a zha ba chankarr nggo na vɨ anu Jaso na amuya abiga abanu gri na kuma na ankpinkpye abi ìgbù ba ba. Na so hantu da di, “Anu Bulu tuku Sila aba yo a so tto itsi kago, na nga ni ìgbù amunta wa, ");
INSERT INTO ninNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","u Jaso à kpa ba zu ni iko ima. A si so na inkindirr yi nggo Kayisa a da di inta bu na hen. A so da di uttu numa mu a se na ri Yesu.” ");
INSERT INTO ninNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Anishirr abi ìgbù ba na ankpinkpye ba a wo meme mre na varr abubo. ");
INSERT INTO ninNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ankpinkpye ba a du Jaso na anishirr banu ba a ni inklo na ttu ba ttungo na du ba kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ibittu ki nggo, amuya abiga ba a du Bulu tuku Sila a kuma nu Berriya. Nggo a ku rri nggo, na kuma nu uki ku issubi ku ani Yahuda ku. ");
INSERT INTO ninNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Anishirr ba nu Berriya a kpa ba zizi mri anishirr bu Tesalonika ba. A shirr atu ku ure umbarr ku, na so di bre ure ku Abachi ku ni ivivi yi na ga aba ta kye ka bu inkindirr yi nggo Bulu à di da i si jiji. ");
INSERT INTO ninNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ina ima i du anishirr shishemi nabo a kpanye nu ure ku Abachi ku. Amba anu Girrki shishemi, nggo anishirr di kye ba ssu na ashishi nggo, aba mi na aniru anu Girrki shishemi a kpanye nu ure ku Abachi ku meme. ");
INSERT INTO ninNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nggo ani Yahuda abu Tesalonika ba a wo di Bulu à so bre ure ku Abachi ku nu Berriya meme, na gru nga nabo ni du anishirr ba nggurr bi na varr abubo. ");
INSERT INTO ninNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Mre amuya abiga ba a gru turr Bulu kuma nu unddu inyi ku na du anu Sila tuku Timoti a so nu Berriya. ");
INSERT INTO ninNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Anishirr ba nggo a so gri Bulu na kuma nggo a ga ma ku rri na Atina. A ka ta kuma u Bulu tu ba da ku anu Sila tuku Timoti di a bu nga nu uwa ku korr. ");
INSERT INTO ninNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nggo Bulu a so kye anko anu Sila tuku Timoti nu Atina, na vri isisurr nu nggo ìgbù wa a tsarr ssu na ana ábáchí. ");
INSERT INTO ninNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Bulu à di rri ga ba na aki ka issubi ka, ku di re na ani Yahuda ba ba tuku abangga ba nggo a si si ani Yahuda hen na di barr Abachi. Na di kri na ri anta na anishirr bangga nggo a nga nye wo ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Anishirr abanu nggo a yo inggurr bi imbarr yi di Ipikurriya tuku abanu nggo a yo ba di Sitoyi, aba mi a di nga ni ri anta na ku. Abanu ba a da di, “Uwama à bre angginggi?” Abanu zizo a da di, “A zzu nâ ta à so re ni itu i ábáchí ba anishirr bi igbu numa.” A si nggo a wo Bulu à di re ba ni itu i Yesu ni itasi ima yi ni ibe yi, ima yo du ba a da meme. ");
INSERT INTO ninNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","A si ima yo aba a yo Bulu di a bu ga ba kuma ni issubi yi nggo di na yi na abubo nggo a ri Ariyopagu. Na ddu ma di, “Da ki inta itsarr ihe̱he̱ yi nggo ùwà so re ni itu yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Aseki numa ka nggo inta i wo ùwà so bre nggo inta nise wo ka kye. Inta zha di inta ka hi achi ka a are akama.” ");
INSERT INTO ninNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Anishirr bi igbu nu Atina ba, na abanu nggo a gru isorr nga ni di so ngu azhi wa yo gigyemi nabo, nggo a di zha di aba ka so di bre na wo aseki ahe̱he̱). ");
INSERT INTO ninNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Mre u Bulu à gru kri ni ichi i anishirr ba nggo a so ni issubi yi na ddu ba di, “Anishirr ba Atina, ingga i hi di imba di ta ukpa kakami ku are ka iga. ");
INSERT INTO ninNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nggo ingga so zirr ga umi igbu umba ku ni hi ankla na aseki ka nggo imba ku di barr ábáchí amba ba nggo, ni ku hi ba a charr ni inkla i akikre numa di: WANGGO À SI KU ABACHI WANGGO NGGO INTA SI HI MA HEN. Uwanggo nggo imba di kuchu ni barr ma nggo ni si hi ma hen, ingga so re ki imba ni itu ima yo. ");
INSERT INTO ninNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Abachi nggo à na ingbingbru yi na aseki ka nggo a se ni ingbingbru yi we, uwa yo si Atiko wa nggo a hru unkplassu ku tuku imimi yi, na a si di rri so nu uki izhi nggo Unushirr a me hen. ");
INSERT INTO ninNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na si di zha inkindirr yi nggo Unushirr a ta na ku hen. Uwa yo a nu anishirr ba wemi iso tuku ususi, na aseki ka wemi. ");
INSERT INTO ninNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Abachi à na anishirr ba wemi ni ingbingbru yi zhi nu unushirr uyirr ku, na du ba a ga so kago ni ingbingbru yi we. Uwa na nkpama à zu ba ivi imbarr yi ni inkla iso imbarr yi bari na na ba. ");
INSERT INTO ninNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Abachi à na meme wre ku anishirr a bu zha ma na zha kago hi di a ka zha ma hi. Ni ima mi, Abachi à si ta anko nu uyirr amunta ku hen. ");
INSERT INTO ninNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘Inta i rri so na ku. Ni zirr na ku ni i se na ku.’ Abanu abi ru asarr amba ba a da di, ‘Inta si amumarr ama.’ ");
INSERT INTO ninNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nu nggo inta i si amumarr ba Abachi, inta bu si kye ma ki ankpunkpru azhi wa nggo a na wa ni izinarriya ka azurrfa ka ingbinta hen. À si si nâ ta si inkindirr inuma nggo unushirr mu han kye na na yi ku itu ima hen. ");
INSERT INTO ninNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ni ikuchi yi, Abachi à nggurr ima a zhi we, nu nggo anishirr a si hi mu na na ka hen. Uwa a ta si ziza nggo nanko, Abachi à da di anishirr kago we a bu kasarr nu umimi umbarr ku na kanga nu uwa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Abachi à ka zu azhibarr ba nggo uwa a taka ni bre amu ku anishirr we na si taka ka unuma mri hen, na à ka ttu undurr ni bre amu ama wa ba. À tsarr inta kakami du uwa a ta na meme. Ima yo i du ma à du Unushirr uwama à tasi.” ");
INSERT INTO ninNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nggo anishirr ba a wo Bulu ni da di ugo numa à ttu na à tasi ni ibe, ambarr abanu ba a gru so me̱. Abanu ba a da di, “Inta taka wo ku ùwà ure ukuma bwe mu.” ");
INSERT INTO ninNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Meme mre u Bulu à gru share na du ba. ");
INSERT INTO ninNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Aniru abanu a kpanye nu ure umaku na kpa Abachi. Dayonisu nggo a si aba yo a di na issubi i Ariyopagu yi a kpanye nu ure ku Bulu ku. Ayamba numa a ri Damarri, uwa mi na abanu a kpanye nu ure ku Bulu ku na kpa Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Bulu à re kre na abubo a issubi a Ariyopagu wa nggo na gru nu Atina kuma nu Korrintiya. ");
INSERT INTO ninNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","A ku hi anu Yahuda numa nabo a ri Akila, nggo a ngri ma nu Ponto. Aba mi a nga ni ivivi ima yo zhi ni Italiya tuku uwama Priskila, nu nggo Kayisa Kladiyu a han anu Yahuda ba share nu Roma nggo. Bulu a kuma na ba, ");
INSERT INTO ninNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","na ku so nabo na di na undu na ba. Undu umaku u si ku di na inggakpa i ttu ahru. Akila mi a di na undu kuma yo. ");
INSERT INTO ninNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ni Ivi i Isu i anu Yahuda yi Bulu à di ga ba ku di ri anta na anu Yahuda, na anu Girrki ba ba nu uki ku issubi ku di a bu kpanye na are ama ka. ");
INSERT INTO ninNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nggo ani Sila tuku Timoti a nga zhi nu Makidoniya, Bulu a ba ivi na di bre ba ure ku Yesu ku na di tsarr ani Yahuda ba kakami di Yesu yo si Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Aba a gru kisa ku Bulu na bre aseki amimi ni itu ima yi, uwa à tsɨ kisa na hɨ ihurr glo ni iki isurr ima yi na ddu ba di, “Imba ti du Abachi à kà imba, imba taka yì ku atu amba. Ungo umungga ù sama nu umi. Ziza nggo ingga ta di kuma na abangga ba nggo a si si ani Yahuda hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","A da meme mre na ka ku di so ni iko i Titiyu Yustu. Uwama à si si ani Yahuda hen na di barr Abachi. Iko ima yi i si hinga nu uki ku issubi ku ani Yahuda ku. ");
INSERT INTO ninNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispu, ankpye nu uki ku issubi ku ani Yahuda ku, uwa mi na abi iko ma ba we a yo isisurr na Atiko wa ku. Abanu shishemi nu Korrintiya a wo Bulu. A zzu anishirr ba wemi nggo a yo isisurr na Atiko wa ku nggo na amasirr. ");
INSERT INTO ninNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Azhibarr anuma ni ibittu Atiko wa a nye ku Bulu nu ula na ni ddu ma di, “Si du isisu ki uwa hen. So bre ure umungga ku meme yo ni si so ywiywimi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Ingga i si ta kà ùwà du hen. Undurr a si ta na ku uwa inkindirr indanda hen. Anishirr shishemi ni ìgbù nggo a si amungga.” ");
INSERT INTO ninNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Mre u Bulu a so ki ise ni inkpu nabo na di tsarr anishirr ba ure ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nggo a na Galiyo ki ugona nu Roma na anga ka Akaya, anu Yahuda ba a nggurr bi na vu Bulu na kuma na abubo a bre amu. ");
INSERT INTO ninNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Na ku da di, “Unushirr wa nggo à ko re anishirr di a bu di barr Abachi na anko anuma nggo are amunta ka a si di inta bu na hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Bulu a ta so re nggo u Galiyo a ddu anu Yahuda ba di, “Imba anu Yahuda, ka di Bulu a na inkindirr indanda ingga ka shirr ki imba atu ni wo. ");
INSERT INTO ninNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Uwa a si iri anta mu ni itu i ankpi are, tuku asa, na are amba ka. Imba ku ssubi na ki imbirr yi. Ingga nggo si ta si uni bre amu ku are a kama hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Na han ba ssuzzu na akaba a bre are wa. ");
INSERT INTO ninNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Aba we a vu Sositene, ankpye nu uki ku issubi ku ani Yahuda wa, na hlo ma na ashishi ka abi bre amu ba, u Galiyo a si kakye ba mi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulu a sha so mwe ivi na amuya abiga ba ba nu Korrintiya, mre na gru ga ijirrigi i amasirr na anu Priskila tuku Akila na kuma nu Sirriya. A nise gru, u Bulu à shi ku Abachi azhi, ima yo i du ma à kurr itu ima yi bari na gru ni ìgbù nu Kenkriya wa. ");
INSERT INTO ninNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nggo a rri nu Afisa nggo u Bulu à kà anu Priskila tuku Akila du. Na rri nu uki ku issubi ku na ku so ri anta na ani Yahuda ba ba. ");
INSERT INTO ninNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Aba ddu ma di a bu sha so ta anko na ba, uwa kà. ");
INSERT INTO ninNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Na ta so kuma na ddu ba di, “Abachi ti kpanye ingga i taka kanga ni imba ba.” Mre na ga ijirrigi yi kuma na Afisa. ");
INSERT INTO ninNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bulu à rri nu Kayisarriya nggo na ku kuma nu Urushalima ku chi abiga ba nabo bari na kuma nu Antakiya. ");
INSERT INTO ninNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A so ki ivi ntsɨ na gru nabo, na kuma na anga ka Galatiya tuku Frigiya, na di da ku abiga ba di a bu kri karrkarr. ");
INSERT INTO ninNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ani Yahuda numa a yo ma di Apolo, a ngri ma nu Alezandra. A nga nu Afisa. A hi ure kakami na hi angbamvu ka Abachi ka kakami meme. ");
INSERT INTO ninNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","A kpa ibre ima yi na anko a Atiko wa na di re na tsarr ba ni isisurr iyirr ni itu i Yesu ni isisurr nu ukyekye umaku we. Ni ina ima mi uwa hi ure ku izzu na amasirr uku yo mre nggo Yohana à bre nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","A gru so re sama ni kru isisu nu uki ku issubi ku. Nggo Priskila tuku Akila a wo ma ni ire yi, na gri ma na kuma ni iko imbarr yi a ku bwu ku ashishi zizi na anko a Abachi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nggo Apolo à gru du uwa à ta kuma nu Akaya, abiga ba nu Afisa a zi ma na charr ku amuya ba nu Akaya di a bu kpa Apolo na ango ahaha. Inga ni sha so ima yi i zi abangga ba nggo uzizi ku Abachi ku u du ba kaki abiga nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolo a kri karrkarr na re mri ani Yahuda ba. Nggo a tsarr ba na Angbamvu ka Abachi ka di Yesu yo a su Kristi wa. ");
INSERT INTO ninNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nggo Apolo à se nu Korrintiya, u Bulu à di zirr ga igbu yi na nga nu Afisa. Na nga ni hi abiga abanu nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Na zhi ba di, “Imba i kpanye ni Yesu ku nggo, i imba i kpa Izhi Iwre yi?” Aba a ddu ma da di, “Iya, inta nise wo mi di Izhi Iwre i se.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulu à zhi ba di, “Izzu na amasirr imba yi i si ita nggi?” Aba ddu ma di, “I si izzu na amasirr i Yohana iyo.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulu à ka sa ba di, “Yohana à zzu anishirr na amasirr wa wre ba bu kasarr kanga na Abachi ku. Na da ba kye ma di undurr unuma à so nga. Na ddu ba di a bu yo isisurr imbarr yi na ku. Yesu yo à si undurr uwama nggo Yohana à so re ni itu ima yi nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nggo a wo meme mre na du ba a zzu na amasirr ni isa i Atiko Yesu yi. ");
INSERT INTO ninNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Mre u Bulu a sa ungo na ba Izhi Iwre yi inga ba, aba a re ni irrirri na nkanka. Na bre ku anishirr ure ku nggo zhi na Abachi ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Aba wemi a se aniru awurr na aha. ");
INSERT INTO ninNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Bulu à rri kuma nu uki ku issubi ku, na ki ihwa tarr na di bre ba ure ku Abachi ku kyekye mi na tsi ba ango, di a bu kpanye di inkindirr yi nggo uwa à so bre ba nggo i si ijiji. ");
INSERT INTO ninNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Abanu ba a kà iwo na si kpanye hen. Na bre ku anishirr ba aseki amimi ni itu i Anko a Atiko wa. Ni ima yo, Bulu à ka ssuzzu share na ba, na gri abiga ba kye. Ni ivivi yi à so di tsarr na abubo nggo Tirranu à di tsarr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bulu di na meme ki ase aha, mre anishirr ba na anga ka Asiya ka, ani Yahuda na abangga ba nggo a si si ani Yahuda hen a wo ure ku Atiko ku. ");
INSERT INTO ninNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Abachi a du Bulu a ko na aseki ka ikagri. ");
INSERT INTO ninNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","À vu aprinkru ka ihɨ ajiji tuku ka ilo na anklampi nggo Bulu a di lo na na undu mi, a gri ku abi vri ba, aba wre, anazhi ndanda ba a ssuzzu ku anishirr nu ukpa. ");
INSERT INTO ninNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ani Yahuda abanu a di zirr kago na di han anazhi ndanda ssuzzu ku anishirr. Aba mi a na da aba ta han anazhi ba ni isa i Atiko Yesu. A ddu anazhi ndanda ba di, “Inta ko nggarr ito ni imba ba di, ni isa i Yesu wanggo nggo Bulu à di re ku anishirr ure umaku nggo, ssuzzu yi nu unushirr wa nggo ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ankpye abikye ani Yahuda numa a ri Sikeva, à se na amumarr aniru atangba aba a so di na meme yo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Izhi ndanda yi i ddu ba di, “Ingga i hi Yesu ni hi Bulu, uwa a ta si imba, imba sa abata ngga?” ");
INSERT INTO ninNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Mre ugo uni ku izhi ndanda wa à gru kuttu amumarr bu Sikeva ba na hlo ba. Ihlo yi i si kakami, aba a kru ssuzzu ni iko yi na angbanja iki na so ja ayiyi nu ukpa. ");
INSERT INTO ninNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ani Yahuda ba na abangga ba nggo a si si ani Yahuda hen, a wo ure kuma kago Afisa, isisu i ki ba, aba a gbyarr asa ni isa i Atiko Yesu yi kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Abiga ba shishemi a ssuzzu na abi na so bre aseki andanda ka nggo aba na ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Abi di ki utirr shishemi a vu angbamvu ka ibre utirr ambarr ka a ssuzzu ni tu na ashishi ka anishirr we. Inklo yi nggo a ka vu angbamvu ka re na kpa yi nggo ka ma azurrfa ukrɨ so kywi. ");
INSERT INTO ninNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ina ima i du ure ku Abachi ku u kaki kyekye anishirr a wo ku kago. ");
INSERT INTO ninNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Aseki angga ka a vu sarr nggo Bulu a gru du uwa ta ba nu Makidoniya tuku Akaya na kuma nu Urushalima. Bulu a da di, “Ingga ti kuma nabo, ingga ta ku kuma nu Roma meme.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Bulu à tu abi zi ma aha, Timoti tuku Irrasitu kuma nu Makidoniya, na à sha so na anga ka Asiya ka bari. ");
INSERT INTO ninNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","A si ni ivi ima yo ivri i rri nu Afisa ni itu i Anko a Atiko wa. ");
INSERT INTO ninNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Uni di la aseki na azurrfa numa a ri Demetru a la uvu uki izhi nggo u si nâ ta si uki ku barr ábáchí animba wa nggo yo wa di Atemi. Undu ukuma u di gri ku abu undu abama inklo shishemi. ");
INSERT INTO ninNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","U Demetru a yo ba bi na abanu nggo undu umbarr ku mi si meme na ddu ba di, “Amuya, imba i hi di inta di kpa inklo shishemi nu undu unggo ku. ");
INSERT INTO ninNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Imba mi i wo ni hi inkindirr yi nggo u Bulu undurr nggo a so na. À da di ábáchí abangga ba nggo anishirr a me na akpambarr a si si ábáchí hen. Anishirr shishemi a wo na kpanye ku ni igbu nu Afisa tuku anga ka Asiya ka we. ");
INSERT INTO ninNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Isisu inggi i si nggo anishirr a ta kye undu umunta unggo ku ndanda mi. A si si ima yo mre hen, ivri inkpi inggi i si nggo anishirr a ta kye uki ku ibarr ku ábáchí animba wa Atemi na kpa ku chirr. Isa ima yi ita jaku na ashishi ka anishirr. Uwa yo a si ábáchí animba wa nggo anishirr kago Asiya tuku ingbingbru yi we a di kuttu na barr uwa yo.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nggo abi la aseki ba a wo are akama, mre na varr unfunfu na gru so hantu di, “Atemi nu Afisa a si kaba!” ");
INSERT INTO ninNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Anishirr kago ìgbù wa a wo na gru ko kye nkankarr mi, na vu anu Gayu tuku Arristaku. Abama a si anishirr bu Makidoniya nggo a di ga Bulu. Anishirr ba a gba ba na narrma kuma na abubo nggo anishirr a bi igbu ba a di nggurr bi. ");
INSERT INTO ninNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulu à gu gru du uwa ta rri na akpa anishirr wa ku, abiga ba a han ma. ");
INSERT INTO ninNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ankpinkpye abi igbu abanu ba nggo a si ku Bulu ikpikpa ima, a tu ba tsi ku ango di a bu si kuma na abubo irro wa hen. ");
INSERT INTO ninNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","A so na meme nggo, issubi i ka kaki varrvarr ba. Abanu a hantu na da inggi yi, abanu da inuma mu nanka. Inkindirr yi nggo i du ba a na meme nggo i si nu nggo igarr imbarr yi a si hi inkpi iyo ba ni nggurr bi yi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ankpinkpye anu Yahuda ba shishemi a turr ugo numa à ri Alezanda yo ku anishirr ba ni ichi, na gru so bre ku inkindirr yi nggo a ta da nggo. Mre uwa ki ba nu ungo di a bu ba ttungo, wre ku bu bre ba inkindirr yi nggo i ko la. ");
INSERT INTO ninNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Nggo anishirr ba a hi di à si ani Yahuda, mre na gru so hantu ki awa aha na so da inkindirr iyiyirr ima yo di, “Atemi nu Afisa a si kaba!” ");
INSERT INTO ninNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","I ni ikikre yi ankpye uni charr ni ìgbù wa a du anishirr a ba ki ywi. Na ddu ba di, “Anishirr bu Afisa, anishirr wemi a hi di ìgbù nu Afisa, uwa yo à di kye uki ku ibarr ku Atemi ku, na di kye ba ingbinta yi nggo i jaku zhi nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Undurr ka si ri anta na aseki angga ka hen. Ni ima yo, imba bu ki ywi ni si na inkindirr sama na amarr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Imba gri anishirr angga ba ni nga ni inggya aba a si ki ayi na aki ka barr ka hen, na si da inkindirr indanda ni itu i ábáchí animba amunta wa hen. ");
INSERT INTO ninNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ka di Demetru ni inkpu abu undu ba a se ni ivri nu undurr ku, abi bre are ba a zu ni ivi yi nggo abi vri a bu ku bre are ambarr ka nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Imba ti si ni inkindirr mri meme nggo imba zha nggo, aba a ta kaku issubi ki imba ni issubi i igbu yi nggo ankpinkpye ba a di yo yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Anu Roma ba a ta ba di inta ngga i tto itsi kputtu yi nggo a tsi ari nggo. Undurr ka si da inkindirr i kpanye nggo i du ba a tsi ari hen. Inta mi ka si da inkindirr jiji nggo du anishirr ba a gru na meme hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","À re meme kre nggo, na du anishirr ba na abubo a issubi, na ga kuma na ako ambarr. ");
INSERT INTO ninNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nggo itsi kputtu yi i ba ttungo nggo, u Bulu a yo abiga ba nggurr bi na bre ba are ka nggo ta nu ba ukyekye ni iga yi na ddu ba du uwa a so kuma. Mre na gru kuma nu Makidoniya. ");
INSERT INTO ninNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Bulu à ga anga akama na di bre ba are shishemi nggo a ta du ba kri kyekye ni iga yi nggo. Na nga nu Girrki, ");
INSERT INTO ninNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","na ni ki ihwa itarr nabo. A ko ttu ukpa ku kuma nu Sirriya nggo na gru wo di ani Yahuda ba a ko ssu anko nggo a ta ngu ma, a hi meme nggo na kye na ka ba nu Makidoniya. ");
INSERT INTO ninNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Sopata, uvuvurr a Pirru, nggo zhi nu Berriya nggo, à ga ma. U Arristaku tuku Sekondu a zhi nu Tesalonika, Gayu à zhi nu Debe, anu Tikiku, u Trofimu a zhi na anga ka Asiya, tuku Timoti abi na ga Bulu. ");
INSERT INTO ninNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Anishirr angga ba a kuchi ku so bi inta nu Torrowa. ");
INSERT INTO ninNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Inta i ri Iga i Unfonfo ni Sama ni Iyisti wa nggo ni ga amasirr ankpi wa zhi nu Filipiya, ni ki ivi kywi bari ni nga na ba nu Torrowa ni so ki ivi itangba nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Na Azhibarr a Isu anu Yahuda wa, ni ingbahru, inta ku nggurr bi na Agbugba a Atiko ni ri ila bi. Bulu à re na anishirr ba ba, na re ma na atsutsu ibittu, nu nggo à hi du uwa à ta share na ambre ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ingba iru shishemi i so la nu uki ku ussu ku nggo inta i so na issubi yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Uvuvurr nze numa à ri Yutiku à so ni iywirr i uki na so durr ina, nggo Bulu à so re na ba tanko mi. Ina yi gru vu ma kakami, uwa ji zhi nu ussu ku tarr ku nga ni jaku ni imimi. Aba gɨ ma nggo uwa si iku mu. ");
INSERT INTO ninNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bulu à ji nga na ba ni imimi na ni kuklo na nyarr iku yi gri na ango. Na ddu anishirr ba di, “Si vri yi hen, à ni su utsitsirr.” ");
INSERT INTO ninNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Mre na ka hun ko nu uki ku ussu ku mɨ unfonfo wa ta na abiga ba ba. Nggo Bulu a re na ba tanko ma na anza ambre, na gru kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Anishirr ba a ga uvuvurr wa tsitsirr ko ni iko ni isu isisurr kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Inta kuchi kuma ni ijirrigi i amasirr yi ni ku darr kuma nu Aso, nu nggo Bulu a ta ku rri ni inta ba ni ijirrigi yi. Uwa yo a da di inta bu ka zzu ba uwa nabo, nu nggo uwa a ta zirr na aza mu kuma nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","A hi inta nu Aso nggo inta gri ma kye ni inta ba ni kuma nu Mitilini. ");
INSERT INTO ninNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Inta gru nu Mitilini ni nga na inkla numa ni ingbahru nggo à ka kri nabo na kye Kiyosi i. Inta zzu nu uha wa ni nga nu Samosi. Ambre ka nggarr, inta rri nu Miletu. ");
INSERT INTO ninNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Bulu à ba ni isisurr ima du uwa a ta sarr ba nu Afisa, wre ku uwa bu si ku ta anko na anga ka Asiya ka hen. À so narrma du uwa ka rri nu Urushalima na azhibarr a nggo a yo wa di Pentiko nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nggo inta rri nu Miletu, u Bulu à tu ba kuma nu Afisa ku da ku akikre abiga ba nabo di a bu nga ni hi uwa. ");
INSERT INTO ninNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Aba a nga nggo uwa ddu ba di, “Imba hi nggo ingga i di si ni imba ba ttuttumi, bazhi na azhibarr a ime̱me̱ wa nggo ingga i rri na anga ka Asiya ka. ");
INSERT INTO ninNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Anu Yahuda abanu ba a ssu anko ka ngu ingga na ki ingga iha na ni ingga i vri kakami, ni ina ima mi ingga i ka ni ki itu nggi na ashishi na ashishi ni so na undu ku Atiko ku. ");
INSERT INTO ninNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ni di tsarr itsarr imungga yi na abi tuku na ako amba wa, ingga i si sha inkindirr izizi inuma sharri ki imba hen. ");
INSERT INTO ninNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ingga gbye ku ani Yahuda ba utu na abangga ba nggo a si si ani Yahuda hen, di a bu kasarr nu nggo a di la ure ku Abachi na kpanye ni Yesu Atiko amunta wa ku. ");
INSERT INTO ninNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ziza nggo, ingga ta na inkindirr yi nggo Izhi Iwre yi ì ko da di ingga bu na nggo. Ingga so kuma nu Urushalima, ni si hi inkindirr yi nggo i ta la ni ingga ku nabo hen. ");
INSERT INTO ninNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ingga ì hi inkindirr iyirr yo nggo Izhi Iwre yi i so gba ki ingga utu ni ìgbù yi wemi nggo ingga ì zirr, di a ta ku harr ingga nu uki na ki ingga iha. ");
INSERT INTO ninNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ingga ì si ba iso imungga yi ni ingbingbru inggi yi ki inkindirr ni ingga ku hen. Ingga na meme, wre ki ingga bu kre undu ku nggo Atiko Yesu wa a ni ingga di ingga bu na nggo. Undu ukuma nggo u si di ingga bu da ku anishirr Ure ku wre ku ni itu i uzizi ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ingga zirr kago imba we ni di da ki imba ure ku ittu i Abachi yi. Ziza nggo, ingga i hi di uyirr amba a si taka hi ingga zizo hen. ");
INSERT INTO ninNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Uwa a si ni ima yo, ingga so da ki imba kakami di, unuma ni imba ba a ti ka ku zha abubo a iso chankarr na Abachi ku, u ungo umungga u sama nu umi. ");
INSERT INTO ninNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Ingga si ka inkindirr numa nggo Abachi à da du uwa taka na ku anishirr sharri ki imba hen. ");
INSERT INTO ninNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ssu ikpa imba yi gri zizi na anishirr ba nggo Izhi Iwre yi i vu ba a sa ki imba na ango nggo. Imba bu gri abiga ba nâ ta si abi ka ilando ngga. Aba yo a si ilando yi nggo a re yi na ayiyi a Uzuma wa. ");
INSERT INTO ninNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ingga i hi di ingga ti share, anishirr abangga ba nggo a si nâ ta si ininazzu ndanda a ta mirri na abiga ba ba, na ta ki ba ankpa. ");
INSERT INTO ninNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ivi yi i so nga nggo anishirr abanu nu umi umba ku a ta bre ku abiga ba mi imu aba ta gru kà imba du, na ga imu yi. ");
INSERT INTO ninNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kri karrkarr yi ni si kpamusu yi hen. Ingga i di yi ashishi na azhi ni ibittu ni di tsarr imba ure ku Yesu ku ki ase atarr. ");
INSERT INTO ninNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“I ziza nggo, ingga ka imba i sa na ango ka Abachi. Si kpamusu nu ure ku uzizi unkpi umaku hen. Ure ukuma yo ta di imba furr, ni ta ni imba iyo angu izizi yi nggo Abachi a da zu ku anishirr ama ba wemi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ingga i si surr ashishi ni inkindirr i undurr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Imba mi i hi na atu amba di ingga i na undu na ango amungga ni kpa inklo ire inkindirr yi nggo ingga na abu zirr amungga ba i zha nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ingga i tsarr imba na anko shishemi di ina meme yo i ta di inta i zi abangga ba nggo a si si kyekye hen. Ni si kpamusu nu ure ku nggo Yesu mi na nkpama à da di, ‘Unushirr wanggo à nu unuma inkindirr à se ni nyarr ni isisurr ima yi mri nggo à ti kpa inkindirr zhi nu undurr ku nggo.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Bulu à re kre na kuttu na gbuzzu na anishirr ba ba na barr Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Aba a so yo ma na anko nggo na so yì, na so ngu ma na ango. ");
INSERT INTO ninNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","A vri kakami nu nggo Bulu à ddu ba di a si taka hi ashishi ama zizo hen. Na ga ma kuma ni ijirrigi i amasirr yi. ");
INSERT INTO ninNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nggo inta du anishirr ba ni darr ntto kuma nu Kosi, ni zzu nu uha wa ni rri nu Rodesi, ni gru nabo kuma nu Patarra. ");
INSERT INTO ninNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nu Patarra, inta i hi ijirrigi i kuma nu Fonisiya, ni ga yi kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Inta nga nu unto ku nggo inta ka kye Sayiprosi hi, ni ka ba ku igbu wa na chi ni kuma nu Sirriya. Inta kukri nu Taya, aba ta ddu iki yi nggo i si ni ijirrigi glo ma nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Inta zha abiga abanu hi nabo ni ku so na ba ki ivi itangba. Izhi Iwre yi i da ba di a bu da ku Bulu di a bu si kuma nu Urushalima hen. ");
INSERT INTO ninNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nggo ivi imunta yi na ba i kre, inta kuma ni kuchi nu uzirr munta ku. Abiga ba wemi na amba na amumarr ambarr ba a ga inta ssuzzu ni ìgbù wa. Inta kuttu na gbuzzu wemi nu unddu ku amasirr ku ni barr Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Inta chi ikpa yi kre ni ku rri ni ijirrigi yi, anishirr ba a ga kuma na ako ambarr wa. ");
INSERT INTO ninNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Inta kuchi nu uzirr munta ku zhi nu Taya ku kukri nu Tolema, ni chi amuya abiga nabo ni so ki azhi ayirr nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Unu uha wa inta i rri nu Kayisarriya. Nabo inta ku kuma ni iko i Filibu, ni ku so na ku. Filibu à su uyirr nu umi ku anishirr atangba ba nggo a hla ba nu Urushalima di a bu zi abi ko na angu ba. ");
INSERT INTO ninNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","A si na áníwá a ne̱s nggo a nise garr na di kpa are zhi na Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Inta ki ivi nabo, uni kpa are ka Abachi numa nggo à ri Agabu à nga nu Yahudiya. ");
INSERT INTO ninNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","A nga ni inta ba na ni ttu upri inkru ku nggo Bulu di lo na anklampi, na ka ku lo aza na ango ama ka na da di, “Izhi Iwre yi i da di, ‘Akikye nu upri nkru unggo ku, ani Yahuda nu Urushalima a ta lo ma meme yo, na ta ba ma nu abangga ba nggo a si si anu Yahuda hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Inta na anishirr ba nabo i wo meme nggo ni tsi ku Bulu ango di a bu si kuma nu Urushalima hen. ");
INSERT INTO ninNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bulu ddu inta di, “Imba so yi angginggi meme ni lo ingga isisurr? Ingga si so kuma ku ilo na aza yo mre nu Urushalima hen, ingga ka ttu mi ku isa i Atiko Yesu.” ");
INSERT INTO ninNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Inta i da di a bu ka amarr amaka sarr ni na chankarr ni ba ttungo, ni barr di, “Aseki ka we nggo a ta la, a bu si nâ ta si nggo Atiko wa a da.” ");
INSERT INTO ninNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Inta so ivi nabo, ni gru ssu aseki amunta ka bi ni vu anko a Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Abiga abanu nggo a zhi nu Kayisarriya a ga inta, na gri inta kuma ni iko i ugo nggo inta ta ku so na ku nggo. A yo ma di Munasoni. À zhi nu Sayiprosi, na si uniga zhi ni ivi ime̱me̱ yi mu. ");
INSERT INTO ninNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nggo inta rri nu Urushalima amuya ba nabo a kpa inta na ango aha na nyarr kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ambre ka nggarr u Bulu a ga inta ku re nu Yakubu ku, a akikre ba we a se na ba. ");
INSERT INTO ninNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bulu a chi ba na bre ba aseki ka na ayiyirr we nggo Abachi à du Bulu à na ku abangga ba nggo a si si ani Yahuda hen. ");
INSERT INTO ninNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nggo a wo ma, mre na gru so nyarr ku Abachi, na ddu Bulu di, “Akpamburr amunta ni iga, kye nggo aseki ka a se, ani Yahuda ama u kri shishemi a kpanye nu Ure ku wre ku na yo itu kakami ni na inkindirr yi nggo Ure ku nggo a nu Musa nggo u da di a bu na. ");
INSERT INTO ninNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","A ka bre ba are amuwa ka ba di uwa di tsarr ani Yahuda ba wemi nggo a so ni igbu i abangga ba nggo a si si ani Yahuda hen, di a bu ba ure ku Musa ku ttungo na bu si yo ku amumarr ambarr ba iji hen, na si ga inkindirr yi nggo ani Yahuda ba a di na hen. ");
INSERT INTO ninNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","A ka wo di uwa se ba. A ti si meme a ka na kingginggi? ");
INSERT INTO ninNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Di inta da ku uwa inkindirr yi nggo inta i kye uwa ka na nggo. Anishirr ane̱ abanu ni inggya a ka vu angu na Abachi ku ba. ");
INSERT INTO ninNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ga ba ni rri na ba ni iba i ngla ukpa yi na age̱ ka Abachi, ni han inklo yi nggo anishirr abama ka han ba nggo, wre ba bu kurr atu ambarr wa. Ùwà ti na meme nggo, anishirr ba wemi a ta hi di aseki ka nggo a bre ni itu imuwa yi nggo a si si jiji hen. Na ta hi du ùwà mi di na inkindirr yi nggo Are ka Musa ka a da nggo ");
INSERT INTO ninNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Uwa ta si abangga ba nggo a si si ani Yahuda hen na kpanye nu Ure ku wre ku, inta i charr ungbamvu da ba di inta ka kpanye di a bu si ri ila yi nggo a di zzu ku anazhi na yi hen, na bu si ta ayiyi hen, na bu si ta inina yi nggo a si han ayiyi kahre hen, na bu si ki ika tankpami hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nggo nu uha wa Bulu à yo anishirr ane̱ ba, na kuma na ba ku ngla ukpa nâ ta si nggo iba i anu Yahuda yi i da di a bu di na. Na gru kuma nu Uki Unkpi ku Ibarr Abachi ku, na ku da ivi yi nggo a taka na ingla ukpa ikikre yi. Na azhibarr a ikikre wa, nggo aba a taka gri aseki ka nggo a ta ni ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nggo ivi itangba yi i ta so kre, ani Yahuda abanu nggo a zhi na anga ka Asiya ka, a hi Bulu nu Uki Unkpi ku Ibarr Abachi ku, na gru tto akpa anishirr wa na vu Bulu. ");
INSERT INTO ninNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","A hantu da di, “Anishirr bu Israila, a nga yi ni zi inta! Wanggo yo à su ugo wa nggo à di zirr kago na di re are andanda ni itu i ani Israila ba tuku Are ka Musa ka, nu Uki Unkpi ku Ibarr Abachi ku. I ziza nggo uwa a gri abangga ba nggo a si si ani Yahuda hen na du ba ni na abubo a wre anggo ki ndanda.” ");
INSERT INTO ninNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Nu nggo a ka hi Trofimu anu Afisa wa nu umi ìgbù tuku Bulu ba na kye di Bulu à gri ma rri nu Uki ku Ibarr ku). ");
INSERT INTO ninNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Itsi kputtu gru ni ìgbù wa kago, ni du anishirr gru so kru ku nggurr bi. Na ku kla Bulu vu na gba ma ssuzzu nu Uki Unkpi ku Ibarr Abachi ku na han anko ka Uki ku Ibarr ka ankpa ayirr. ");
INSERT INTO ninNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Akpa anishirr a so zha anko a ngu Bulu nggo na gru ku da ku ankpye abi ta iku nu Roma unkpi wa di a ko tsi kputtu nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Mre uwa a vu ankpinkpye abi ta iku banu na abi ta iku na kru ji kuma na anishirr ba ba. Anishirr ba a hi ma na abi ta iku ba mre na ba ttungo ni hlo Bulu yi. ");
INSERT INTO ninNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Ankpye abi ta iku wa à zirr kuma nu Bulu ku, na vu ma na ddu ba di abi lo ma na ache aha. Ankpye wa à zhi ba di, ugo wanggo wa a su unggonggo, na na angginggi? ");
INSERT INTO ninNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Anishirr abanu ba hantu da inkindirr iyirr, abanu ba a da inuma mu nanka. Anishirr a re na nkanka ina ima i du ankpye wa si hi karr inkindirr yi nggo so zirr hen. Ima yo i du ma ddu anishirr ama ba di, a bu ba ma na kuma na abubo a abi ta iku wa. ");
INSERT INTO ninNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Aba gri ma ku rri ni inkla i hun kuma ni ime yo mre, nggo akpa anishirr wa a varr unfu kakami, abi ta iku ba a kye na ba ma kye ba. ");
INSERT INTO ninNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Anishirr ba a so ga ba ttu na so du hantu di, “Ngu ma!” ");
INSERT INTO ninNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nggo a ta so ba Bulu na rri na abubo nggo abi ta iku ba a di so nggo, uwa a re na ankpye wa ku di, “Ùwà ka di ingga da ku ùwà inkindirr nggi?” Ankpye à da di, “Ùwà i re irrirri Girrki? ");
INSERT INTO ninNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ùwà yo si si anu Masarr wa nggo à tto itsi yi ni ikuchi yi, ni gri anishirr ukrɨ une̱ ni kru kuma na ankpuji, ku di ssu anko di aba ta nga ni kpa inkpinkpye i igbu yi hen?” ");
INSERT INTO ninNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulu à kisa ku di, “Ingga si ani Yahuda. A ngri ingga nu Taso ku Silisiya, unushirr ni ìgbù unkpi. Ingga tsi ku ùwà ango di ingga re na anishirr ba ba.” ");
INSERT INTO ninNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ankpye abi ta iku wa à kpanye di a bu re. Mre u Bulu a gru kri ni idaba yi na ki anishirr ba nu ungo. Nggo aba ki ywi u Bulu a re na ba ni irrirri i Ibraniya. ");
INSERT INTO ninNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Amuya na akiki, imba wo nggo ingga ta re kisa na age̱ amba na aseki ka nggo imba i da di ingga na nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nggo a wo ma a so re ni irrirri i Ibraniya, na ba ki ywi mri ime̱me̱ yi. U Bulu à ddu ba di, ");
INSERT INTO ninNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ingga si anu Yahuda. A ngri ingga ni ìgbù nu Taso nggo si ni Silisiya. Ingga ì furr mu ni inggya nu Urushalima ni si uvuvurr ni bre a Gamaliya. A tsarr ingga kakami na are ka nggo a nu akiki amunta ba naka nggo. Ingga i nu Abachi itu imungga yi kakami ni ga are ka na ti imba i se ari. ");
INSERT INTO ninNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ingga i ki abi ga anko a Atiko ba iha, abanu a kɨ. Ingga i vɨ aniru na amba isurr na aki ka harr. ");
INSERT INTO ninNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ankpye unkpi abikye uki ku ibarr wa, tuku akaba ani Yahuda wa we a ka da ki imba di ingga so da si ure ujiji. A charr angbamvu mi a ni ingga gri ku ambarr ankpinkpye ani Yahuda ba nu Damasika, wre ki ingga bu kuma ku i vɨ anishirr abiga ba lo na ache gri ni nga ni ki ba iha nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nggo ingga so kuma ni ki ywhiywhirr nu Damasika na zhi na atsutsu, uru numa gru la nzarr zhi na akpa kago ingga. ");
INSERT INTO ninNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ingga jaku ni imimi ni wo ukorr u ddu ingga di, ‘Shawulu! Shawulu! Ùwà ki ingga iha ngginggi?’ ");
INSERT INTO ninNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Ingga ì zhi di, ‘A su uwanggo, Atiko?’ “Atiko à ddu ingga di, ‘A si ingga Yesu anu Nazareti, nggo ùwà ki ma iha.’ ");
INSERT INTO ninNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Abangga ba nggo inta i so zirr ma mi nggo a hi ila iru yi na si wo ukorr ku uwanggo nggo so re ni ingga ku hen. ");
INSERT INTO ninNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Ingga zhi di, ‘Ingga ta na kingginggi, Atiko?’ “Atiko wa à ddu ingga di, ‘Gru ni rri kuma nu Damasika. Aba ta ku da ku ùwà aseki ka we nggo Abachi a ba ni isisurr du uwa ta na.’ ");
INSERT INTO ninNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Uru ku u du ingga i kaki unakreshishi, akpukpamu bu zirr mungga ba mu a vu ingga nu ungo na rri kuma nu Damasika. ");
INSERT INTO ninNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ni igbu wa, ugo numa à ri Ananiya, a su unushirr ni barr Abachi kakami, na di na inkindirr yi nggo Are ka Musa ka a da nggo. Ani Yahuda ba nggo a so nu Damasika we a di kye ma ssu na ashishi kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ugo ma a nga ni kri ki ingga na anga yirr na da di, ‘Iziya Shawulu, kye hi zizo!’ Ankpa yirr ingga kye ma hi. ");
INSERT INTO ninNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Uwa da di, ‘Abachi a akiki munta wa à hla ùwà du ùwà bu hi inkindirr yi nggo Abachi à ssu zu ku ùwà nggo, ni bu hi Uvurr Iko ama wa nggo di na uzizi ku nggo, ni bu wo ma so re nu ukorr uma. ");
INSERT INTO ninNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ùwà ta su uni hi tuku uni da ku anishirr uzizi ku Abachi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ziza nggo, ùwà kri bi anggi? Gru ni du ba a zzu ùwà na amasirr na ngla ila ure imuwa yi glo, ni so yo isa i Atiko wa.’ ");
INSERT INTO ninNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ingga ì kakuma nu Urushalima, nggo ni ku so barr nu Uki Unkpi ku Ibarr Abachi ku, azhibarr anuma nggo ula gru ki ingga. ");
INSERT INTO ninNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nu ula ukuma ingga i hi Atiko wa a ddu ingga di, ‘Narrma ssuzzu share korr nu Urushalima. Anishirr ba ni inggya a si ta kpanye nu ure ku nggo ùwà ta da ba ni itu imungga hen.’ ");
INSERT INTO ninNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Ingga i da di, ‘Atiko, à hi di ingga ì di kuma na aki ka issubi ka ani Yahuda ka ku di vu abangga ba nggo a kpanye nu ùwà nggo nga ni hlo. ");
INSERT INTO ninNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nu nggo a so ngu Istifanu, uni da ure amuwa wa, ingga ì se ni inkla yi. Ingga i kpanye ni ingu ma yi ni so kye ku abi ngu ma ba inkinkru imbarr yi.’ ");
INSERT INTO ninNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Atiko wa a ddu ingga di, ‘Kuma, ingga ta tu ùwà kuma gbagba mu na abangga ba nggo a si si ani Yahuda hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Anishirr ba a so shirr ku Bulu atu ma nu nggo à ddu ba du uwa ta kuma na abangga ba nggo a si si ani Yahuda hen. Mre, aba bwu akorr da di, “Gri ma ni share yi, ku ngu ma. Imba si du ma à so tsitsirr hen!” ");
INSERT INTO ninNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Anishirr ba a so yi kisa, na ddu inkinkru imbarr yi a yi nu ussu, na tsu imbimbru imimi so varr ko nu ussu. ");
INSERT INTO ninNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Ankpye abi ta iku nu Roma unkpi wa a du anishirr ba a ba Bulu na rri kuma na abubo nggo abi ta iku ba a di so nggo. Na ddu ba di a bu hlo ma na amfarr wre ku Bulu a bu da ba inkindirr yi nggo i du ani Yahuda ba a so re kisa ku meme. ");
INSERT INTO ninNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nggo a lo ma ta hlo nggo u Bulu a ddu ankpye wa nggo a kri na ba nabo di, “Are amunta ka a kpanye di a bu hlo Unushirr wanggo nggo a si anu Roma sama ni bre amu ku ila ima yi?” ");
INSERT INTO ninNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nggo ankpye wa a wo meme mre na kuma na ankpye abi ta iku wa ku ku ddu ma di, “Ùwà ta na kingginggi? Ugo uwama à si anu Roma.” ");
INSERT INTO ninNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ankpye a abi ta iku unkpi wa a kuma nu Bulu ku ku zhi ma di, “Da ki ingga, ùwà si anu Roma?” U Bulu à kpanye di, “Yo-o, ingga si anu Roma.” ");
INSERT INTO ninNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ankpye abi ta iku unkpi wa a da di, “Ingga i ni inklo shishemi bari aba a na ingga ki anu Roma.” Bulu a ddu ma di, “Ingga na anko ingga su uvurr ingri nu Roma.” ");
INSERT INTO ninNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Abangga ba nggo a nga ni so zhi Bulu nggo a nggurr itu ka share na ku, isisu i ki ankpye abi ta iku unkpi wa nggo a hi di Bulu a si anu Roma uwa a yo ma na ache. ");
INSERT INTO ninNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ankpye abi ta iku unkpi wa à zha du uwa ta hi karr di ani Yahuda ba a nga Bulu di a na ba angginggi. Ima yo i du ankpye wa à zzu na ambre na du ba a ddu ku Bulu ache ka. Na yo ankpinkpye abikye ba tuku Akaba anu Yahuda ba mre na gri Bulu na nga na ba. ");
INSERT INTO ninNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulu à kye anishirr ba Akaba anu Yahuda ba girr na da di, “Amuya mungga, uzirr umungga ku na age̱ ka Atiko wa ba zhi ni ime̱me̱ yi nga na azhibarr ari wa, isisurr imungga yi i si da ki ingga di ingga i na inkindirr indanda hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ankpye unkpi abikye wa, Ananiya à da ku abangga ba nggo a kri hinga nu Bulu ku di a bu nggurr ma na angu. ");
INSERT INTO ninNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bulu à ddu ma di, “Abachi à ta nggurr ùwà, ùwà ugonka ku nggo a hɨ ku kaki ukukla. Ùwà so nabo du ùwà ta bre ki ingga are na si nggo Are ka Musa ka à di a bu na nggo. Ùwà uyiyirr wama yo i ya ge̱ inkindirr yi nggo are ka Atiko ka a han inta ni na yi nggo, ni du ba a nggurr ingga!” ");
INSERT INTO ninNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Anishirr ba nggo a kri hinga nu Bulu ku a ddu ma di, “Ùwà ko marr ankpye unkpi abikye a Abachi wa yo meme?” ");
INSERT INTO ninNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulu à ddu ba di, “Amuya amungga, ingga si hi du uwa yo a si ankpye unkpi abikye wa hen. Ungbamvu ku Abachi ku da di, ‘Ùwà bu si re ku uni gri anishirr amba ba ure andanda hen.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nggo Bulu a hi di anishirr abanu ba a si anu Sadusi, abanu ba a si ani Farrisi, na gru re ku anishirr ba na Akaba anu Yahuda wa hantu di, “Amuya mungga, ingga si anu Farrisi, ingri i anu Farrisi. A si gri ingga nga ku ibre amu inggi yi ku inkindirr inuma mu hen. A si nu nggo ingga ì yo isisurr di Abachi à taka du abi kɨ ba a tasi ni ibe.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nggo a da meme mre, anu Farrisi ba na anu Sadusi ba a gru so vi, na ga ki na nkanka. ");
INSERT INTO ninNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Anu Sadusi ba a da di anishirr abangga ba nggo a kɨ a si taka tasi hen, na si kpanye di abitu ba Abachi a se hen, na da di anazhi a sama. Anu Farrisi ba na anko a kpanye na aseki atarr akama). ");
INSERT INTO ninNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","A gru ko hantu ka mwe, abitsarr are abanu nggo a si na ba ni nggurr bi i anu Farrisi yi, a gru kri karrkarr na kisa kakami di, “Inta si hi inkindirr indanda nggo ugo nggo à na hen, ka bu unitu à Abachi ka izhi inggi ì re na ku?” ");
INSERT INTO ninNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Iri anta yi gru kaki nu unfu kakami, isisu i ki ankpye abi ta iku wa, uwa kye di a ta nga Bulu kahre. A kye meme nggo na du abi ta iku ama ba a ji kuma na anishirr ba ba na ku vu Bulu share na ba na gri ma kuma na abubo nggo abi ta iku ba a di so nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Ni ibittu ima, Atiko wa à nga ni kri nu Bulu ku na ddu ma di, “Vu isisurr, ùwà da ba ure umungga ku nu Urushalima inggya, ùwà ta na meme yo nu Roma.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Ambre ka a nggarr, ani Yahuda abanu ba a nggurr bi na ssu anko. A shi azhi di aba ta ngu Bulu bari na ri na so inkindirr. ");
INSERT INTO ninNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","A mri anishirr iso ne̱s (40) nggo a nggurr bi na na anko ama wa. ");
INSERT INTO ninNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mre, na gru kuma na ankpinkpye abikye ba ni nggurr bi i akikre yi na ku ddu ba di, “Inta i nggurr bi ni shi azhi di inta ta ngu Bulu bari ni ri ni so inkindirr. ");
INSERT INTO ninNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ziza nggo, imba na anishirr ba wemi na Akaba anu Yahuda wa ta kuma na ankpye abi ta iku unkpi wa ku ni ku da ku di a bu gri ma nga na Akaba wa, wre ba bu nga ni wo ma zizo. Imba ti so na meme nggo, inta ta kuma ku so sharri ni ngu ma na anko.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ugi a Bulu à wo inkindirr yi nggo a so da, na ku rri kuma na abubo nggo abi ta iku ba a di so nggo na ku bre ku Bulu. ");
INSERT INTO ninNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Mre u Bulu à yo ankpye a inkirr abi ta iku uyirr wa, na ddu ma di, “Gri uvuvurr nze wanggo ni kuma na ankpye abi ta iku unkpi wa ku. À si ni inkindirr inggi yi nggo à ta da ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ankpye a inkirr abi ta iku uyirr wa à gri uvuvurr wa na kuma na ankpye abi ta iku unkpi wa ku. Na ku ddu ma di, “Bulu, uni kri iharr wa, à yo ingga na ku di ingga bu gri uvuvurr nze uwanggo ni nga nu ùwà ku, da à si ni inkindirr ì da ku ùwà.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ankpye abi ta iku unkpi wa à vu ma nu ungo na gri ma na nkima na share. Na ku zhi ma di, “Ùwà i si na angginggi i da ki ingga?” ");
INSERT INTO ninNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Uvuvurr wa da di, “Ankpinkpye anu Yahuda ba a ka nggurr angu bi ba di ambre aba a ta nga ni re ùwà mi, di ùwà bu nu ba Bulu gri na kuma na Akaba anu Yahuda wa ku zhi ma are numa ngga ni itu ima yi. ");
INSERT INTO ninNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ùwà bu si wo ba hen. Anishirr a mri iso ne̱s (40) a ta kurr sharri bi ma. A ka shi azhi ba di aba a ta ngu Bulu bari na ri na so inkindirr. A ka ssubi ba nggo aba ta ngu ma na kri bi inkindirr yi nggo ùwà ta da.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ankpye abi ta iku unkpi wa à ddu ma di, “Si da ku undurr du ùwà i da ki ingga ure unggo ku hen.” Na du uvuvurr nze wa a share. ");
INSERT INTO ninNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ankpye abi ta iku unkpi wa à yo ankpinkpye aha na ddu ba di, “Ni ikarrfe itirr ibittu, ùwà ddu abi lo ukpa ayiyirr aha (200) ssubi ni kuma nu Kayisarriya. Gri abi ta iku a bi hun inga iso tangba (70), na abi zirr na aza ayiyirr aha (200) du ba hru itankparr. ");
INSERT INTO ninNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Zha inga wa nggo Bulu à ta hun, ni gri ma zizi ni kuma nu Ugona Feli ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ankpye abi ta iku wa à charr ungbamvu à da di: ");
INSERT INTO ninNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","À si ingga Kladiyu Lisiya. Ingga ì charr ku ùwà Ankpye Ugona Feli. Ingga ì chi ùwà. ");
INSERT INTO ninNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Ani Yahuda ba a vu ugo nggo na ta ko ngu ma. Ingga wo nggo ni gri abi ta iku amungga ba ni ku kpa ma na ba, nggo ni wo di à si anu Roma. ");
INSERT INTO ninNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ingga i zha di ingga ta hi inkindirr yi nggo a da di à na nggo, ni gri ma ni kuma na ba na Akaba ambarr wa. ");
INSERT INTO ninNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ingga ku hi di a si na inkindirr inggi ita du ba a ngu ma hen, na si si inggi a ka yo ma ni iharr hen. Inkindirr yi nggo a da di à na i si ni itu i are ambarr ka ani Yahuda ka. ");
INSERT INTO ninNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Nggo a ni da ki ingga di ani Yahuda abanu a ko ssu anko ndanda ni itu ima yi, ingga kye ni di a bu nga nu ùwà ku. Ingga i da ku abangga ba nggo a da di à na aseki ndanda ka nggo di a bu nga ni bre ku ùwà aseki ka. ");
INSERT INTO ninNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Abi ta iku ba a na inkindirr yi nggo ankpye wa à da di a bu na. A ku gri Bulu ni ibittu na kuma nu Antipatri azhibarr ama. ");
INSERT INTO ninNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","A zzu na ambre ka abi ta iku ba aza ba a kakuma na abubo nggo abi ta iku ba a di so nggo. Na du abi hun inga ba a ga ma. ");
INSERT INTO ninNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","A gri ma na nga nu Kayisarriya, na ni nu Ugona wa ungbamvu ku na ba Bulu nu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Ugona wa a bre ungbamvu ku na zhi Bulu di à zhi na anga a ta nggo. Nggo à wo di à zhi nu Silisiya, ");
INSERT INTO ninNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","na ddu ma di, “Abi bre are surr ku ùwà ba a ti nga, ingga i ta wo ku ùwà.” Na da ba di a bu zu Bulu na du abi ta iku a so kye ma na ando wa nggo uttu Hirridu à me. ");
INSERT INTO ninNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ivi i kywi i vu sarr, u Ananiya, ankpye unkpi abikye wa à kuma nu Kayisarriya, na gri akikre abanu tuku Tatulu, uni kpa are re ku anishirr wa. A ni kri na age̱ ka Ugona Feli na bre are ka nggo a da di Bulu à na nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Mre aba a yo Bulu a mirri, u Tatulu à gru so bre aseki ka nggo a da di Bulu à na ka nggo na age̱ ka Feli. À bre are angga ka: “Uttu unkpi, u krizhizhi umuwa ku u di inta so su ta anko sama ni itsutsarr. Ùwà so vu aseki kasarr wre ku ìgbù amunta wa a bu kuchi. ");
INSERT INTO ninNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Na anko ka wemi, inta i nyarr ku ùwà kago, inta i nyarr ku ùwà Feli, ankpye unkpi sha wa. ");
INSERT INTO ninNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ingga i si ta gri ùwà ta anko ni so wo ingga hen. Inta tsi ango di ùwà bu shirr atu ku uvu ure ku nggo inta ta re. ");
INSERT INTO ninNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Inta kye hi di ugo wanggo à si ni tto itsi na ka na igbu ki ndanda. À du ani Yahuda a gru so tsi akputtu kago ingbingbru yi. Na si ankpye a inggurr bi i anu Nazareti wa. ");
INSERT INTO ninNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","À zha du ùwà ka surr ūnké̱ surr Uki ku Ibarr munta ku, nggo inta i vu ma. Inta so ssu anko anggo inta ta bre amu amaka na anko nggo are munta ka a da nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Uwa si Lisiya, ankpye abi ta iku wa mu, à nga ni narr ma kyekye mi kpa ni inta ba. ");
INSERT INTO ninNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nggo Lisiya à di inta bu gri ma ni nga nu ùwà ku, ni bre aseki ka nggo inta da à na. Ùwà ti zhi ugo nggo na nkpami, ùwà ta wo aseki ka wemi nggo inta da di à na ka nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ani Yahuda ba mi a bre aseki ayiyirr kama iyo di Bulu à na, na kpanye di a si meme yo. ");
INSERT INTO ninNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ugona wa à ki ku Bulu ungo di à bu re, u Bulu à da di: “Ingga i hi du ùwà i ki ase shishemi ni di bre are ku anishirr abi ìgbù angga ba, ima yo i di ingga nyarr nu nggo ingga ta kri na age̱ amuwa ni kisa na aseki ka nggo a da di ingga na nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ùwà ti zhi, ùwà ta wo di, a si mri ivi iwurr ni iha (12) nggi nggo ingga ku barr Abachi nu Urushalima hen. ");
INSERT INTO ninNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ani Yahuda ba a si hi ingga ni so ri anta nu undurr ku nu Uki Unkpi ku Ibarr Abachi ku hen, na si hi ingga ni so tto anishirr di a bu tsi na aki ka issubi ka, ka ni inkla inuma nu umi ìgbù ku hen. ");
INSERT INTO ninNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","A ka si da inkindirr numa nggo i ta du anishirr hi di are ka nggo a bre ni itu mungga a si jiji hen. ");
INSERT INTO ninNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ingga i ta da uwanggo a si ure ajiji di ingga di barr Abachi a akiki amunta wa ni di ga anko anggo nggo a kisa di a si si ajiji hen. Ingga mi di kpanye na Are ka Musa ka we tuku angbamvu ka abi kpa are ba Abachi ba. ");
INSERT INTO ninNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ingga ì so di kye anko a Abachi wa nâ ta si nggo anishirr angga ba mi a so di kye nggo. Di Abachi à taka du anishirr we, azizi na ndanda a tasi ni ibe. ");
INSERT INTO ninNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ima yo i di ingga di tsɨ di ingga ta na inkindirr yi nggo ingga kpanye di i si izizi na Abachi ku tuku anishirr. ");
INSERT INTO ninNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ingga i ki ase shishemi ni si si nu Urushalima hen, ni ku nga ni gri inklo ku nu anishirr amungga ba nabo ni ka bu to ku Abachi. ");
INSERT INTO ninNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Uwa si nggo ingga so na meme aba nga ni hi ingga nu Uki ku Ibarr Abachi ku, ingga i ka kre iba i ingla ukpa yi ba. Anishirr a sama ni ingga ku, abandurr a si so tsi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ani Yahuda abanu nggo a zhi na anga ka Asiya na se nabo, aba a ti se ni inkindirr ni itu imungga aba bu nga ni da yi na age̱ amuwa. ");
INSERT INTO ninNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ùwà ti si ta na meme hen, ùwà bu du anishirr angga ba ni inggya a da inkindirr indanda yi nggo ingga i na aba a gri ingga na nga na age̱ ka Akaba anu Yahuda ka. ");
INSERT INTO ninNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Inkindirr iyirr yo a ka da di ingga ì na yi, inggi ì si inkindirr yi nggo ingga ì da yi hantu na akaba a bre amu wa da di: ‘Nu nggo ingga ì kpanye di abi kɨ ba a taka tasi ni ibe, ima yo ì du ba a ko bre ki ingga amu angga ka ari.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mre u Feli nggo à ka hi Anko a Atiko wa kakami ba, à du ure ku kre. Na ddu ba di, “Lisiya, ankpye abi ta iku unkpi wa, à ti nga bari ingga ta gurr ure umuwa ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","À da ku ankpye abi ta iku wa di à bu gri Bulu ku zu na so gbye ma, na bu du ma sha ttu unddunddu ntsɨ, na du akpukpama ba a ka bu gri ku aseki angga ka nggo à zha nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","A ki ivi ntsɨmi anu Feli tuku uwama wa Drusila, ani Yahuda, à tu ba a yo Bulu, uwa nga ni re ba ni itu i ikpanye ni Kristi Yesu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Nggo Bulu à so re ni itu i izirr wre na age̱ ka Abachi i unushirr, tuku ivu ukpa gri, na azhibarr nggo Abachi à taka ni bre ku anishirr amu, isisu i ki Feli, uwa à da di, “Ùwà ka kukri bari! Kuma! Ingga ti hi anko, ingga ta du ba yo ùwà zizo.” ");
INSERT INTO ninNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Nu nggo Feli à kye di Bulu à taka gru go ku angu, na di tu ba a yo ku na ku ttuttumi na nga ni di re na ku. ");
INSERT INTO ninNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ase aha a ni vu sarr u Posiyu Festu à hun ni imburr i ugona Feli yi. Feli à zha di ani Yahuda ba a bu kpanye nu uwa ku, ima yo i du ma à ka Bulu du nu uki ku iharr ku. ");
INSERT INTO ninNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nggo a na Festu ki ugona, uwa ki ivi itarr na gru zhi nu Kayisarriya na kuma nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mre ankpinkpye abikye ba na ankpinkpye anu Yahuda ba a gri ku Festu are ka nggo a da di Bulu à na ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","A barr Festu di a bu du Bulu à nga nu Urushalima. A na meme wre ba bu ka zzu ngu Bulu na anko, ima yo du ba da di a bu nga. ");
INSERT INTO ninNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festu à ddu ba di, “Bulu à kri iharr nu Kayisarriya, ingga ta na ni kuma nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ugo wa ti na ki imba inkindirr indanda, imba bu du ankpinkpye amba ba a ga ingga kuma nu Kayisarriya ku bre surr ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Bu Festu à so ki ivi itandarr, ka bu si iwurr na ba bari na kuma nu Kayisarriya. A zzu na ambre ka uwa so na akaba a ibre amu wa na ddu ba di a bu gri Bulu na rri. ");
INSERT INTO ninNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nggo Bulu à mirri ani Yahuda ba nggo a zhi nu Urushalima a ka ma yo na atsutsu na gru so bre di à na aseki shishemi nggo a si ndanda. Ni ima mi aba a si da inkindirr yi nggo ka du unushirr a kpanye nu ure umbarr ku ni itu i Bulu hen. ");
INSERT INTO ninNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulu na nkpama à kisa na aseki ka nggo a bre nggo, na ddu ba di, “Ingga i si na inkindirr indanda ku are ka ani Yahuda ka hen. Ni si na ku Uki ku Ibarr umba ku tuku Kayisa nu Roma wa inkindirr indanda hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festu à zha du uwa ta du ani Yahuda ba a kpanye na ku nggo, na gru zhi Bulu di, “Ùwà ta kpanye ni ga ingga kuma nu Urushalima ku re̱ narr itu imuwa ttungo na are ka nggo a da du ùwà na ka nggo?” ");
INSERT INTO ninNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulu à da di, “Ingga kri si na akaba a bre are a Kayisa, a si inkla yi nggo a bu bre ure mungga ku nggo. Ingga si na ku ani Yahuda ba inkindirr indanda hen. Imba mi na tu amba i hi kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ingga ti na inkindirr inggi are ka a da di inta bu si na hen, ni na inkindirr yi nggo ima a bu ngu ingga, ingga si ta kisa di a bu si ngu ingga hen. Uwa ti si di are ka nggo a bre ni itu mungga a si si meme yo hen, undurr a si ta ba ingga a nu ba hen. Ingga zhi di a bu di ingga ba ure ku ni kuma nu Kayisa wa ku!” ");
INSERT INTO ninNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festu à re bi na abi so na akaba ama ba ba, na da di, “Ùwà ba ure ku ni kuma nu Kayisa ku. Ùwà ta kuma nu Kayisa yo ku!” ");
INSERT INTO ninNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","A ki ivi ntsɨ uttu Agripa tuku Banisi, uvayirr ama wa, a mirri nu Kayisarriya nga ni ichirr nye chi Festu. ");
INSERT INTO ninNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nggo a sha so ma ivi nabo, u Festu à vu ure ku Bulu ku à bre ku uttu wa. Uwa ddu ma di: “Unushirr numa à se nggo Feli à ka ma du ni iharr. ");
INSERT INTO ninNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ingga i nga nu Urushalima nggo ankpinkpye abikye ba na akikre bu Yahuda ba, à bre du ugo wa à na aseki ndanda na da di ingga bu ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Ingga i ddu ba da di, a ti da di unushirr à na inkindirr indanda, anu Roma a di du undurr wa nggo a nga ma inkindirr yi a re narr itu ima kye na ashishi ka abangga ba nggo a nga ma inkindirr yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","A nga ni inggya nggo ingga i ki korr ni zzu na ambre ka ni du ba a gri ma nga ki ingga na akaba a ibre amu wa. ");
INSERT INTO ninNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Abi kri azanyirr na ku ba a gru kri na si da inkindirr numa ndanda ni itu ima yi nggo ingga ì kye di a ta da hen. ");
INSERT INTO ninNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","A sha ri anta yo na ku ni itu i anko nggo a di barr Abachi nggo. Na re ni itu i ugo numa a yo ma di Yesu nggo a ka ttu ba u Bulu a kisa di a se tsitsirr. ");
INSERT INTO ninNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ure ukuma ù shi ki ingga ibwu, ingga zha inkindirr ida chankarr nu ure ku, nggo ni zhi Bulu di a ta kpanye na kuma du ba ku bre ku amu nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Bulu à kà na ba ure na gru. À barr di a bu harr uwa zu na gbye uwa du Kayisa wa nga ni han ku uwa ure ku. Ima yo di ingga du ba a zu ma na so gbye ma nu nggo ingga i taka turr ma kuma nu Kayisa wa ku.” ");
INSERT INTO ninNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa à ddu Festu di, “Ingga zha di ingga ka wo ugo wanggo na nkpamu.” Festu à ddu ma di, “Ùwà ta wo ma ambre.” ");
INSERT INTO ninNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ambre ka nggarr anu Agripa tuku Banisi a mirri nggo, aba a gbyarr ba asa na chi ba, na rro tsarr ba. Aba a zirr na ankpinkpye abi ta iku ba na anishirr bi ìgbù ba nggo a kye ba ssu na ashishi na mirri nu uki unkpi ku nggo anishirr a di nggurr bi ma. Festu à du ba a gri Bulu na mirri. ");
INSERT INTO ninNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festu à da di, “Uttu Agripa na anishirr ba we nggo a si ni inta ba ni inggya, imba i hi ugo wanggo nggo ani Yahuda ba we ni inggya tuku Urushalima a nga ni yi ki ingga ni itu ima yi nggo. Aba a nggurr ungo na angu di a bu ngu ma. ");
INSERT INTO ninNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ingga i si hi ma na inkindirr yi nggo i ma a bu ngu ma hen. Uwa si nggo uwanggo ku itu ima a ba ure ku na nga nu Kayisa wa ku, nggo ingga kye ni ta turr ma nga nu Roma. ");
INSERT INTO ninNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ingga nanko i sama ni inkindirr karr nggo ingga ta charr ku Kayisa wa ni itu ima yi. Ima yo di ingga gri ma ni nga ni inggya na age̱ amba, ingga kye ùwà uttu Agripa yo kakami, wre ku ùwà ti bɨ ure unggo ku kye, ingga i bu si ni inkindirr yi nggo ingga ta charr nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ingga i kye i si ta wre hen ingga bu turr uni kri ni iharr kuma sama ni ida inkindirr yi nggo a da di à na nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa à ddu Bulu di, “Ingga i nu ùwà anko ùwà bu re ku itu imuwa.” Bulu à ki ba nu ungo na re kisa na aseki ka nggo ani Yahuda ba a bre da à na ka nggo, na da di, ");
INSERT INTO ninNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Uttu Agripa, ingga i kye a si ki ingga inkindirr inyarr nggo ingga i kri na age̱ amuwa ari ta kisa na aseki ka nggo ani Yahuda ba a bre di ingga na nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Ingga da meme nu nggo ùwà hi aseki ka nggo ani Yahuda ba a di na ka. Ùwà hi iso yi nggo ani Yahuda ba a di so nggo, ni hi anko ka nggo iso yi i si ba na nkanka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ani Yahuda ba wemi a hi ingga zhi ni imimarr itsa mu. A hi iso yi nggo ingga i so na akonta tuku nu Urushalima. ");
INSERT INTO ninNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","A ka ti da aba a ta da ure ujiji mu, aba ta da ki imba di ingga ì si anu Farrisi ni si di rro nu ure ku ibarr Abachi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","I ziza nggo ingga ì kri aba ta bre ki ingga amu nu nggo ingga i so surr ashishi di Abachi à ta na inkindirr yi nggo à da zu du uwa ta na ku akiki amunta ba nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ima yo i du aki awurr na aha ka Israila ka a so di barr Abachi na azhi ni ibittu, na so di surr ashishi ku aseki ka nggo Abachi à da zu du uwa à taka na nggo. Uttu, ùwà à si ku i surr ashishi iyiyirr ima yo, du ani Yahuda ba a bre aseki angga ka surr ki ingga. ");
INSERT INTO ninNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","A sa angginggi di imba ani Yahuda i ma chankarr ni kpanye di Abachi à ka du abi kɨ ba a tasi? ");
INSERT INTO ninNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ingga ni itu imungga ì kye di ingga ta kri karrkarr ni kà isa i Yesu anu Nazareti yi. ");
INSERT INTO ninNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","A si inkindirr inggi yi nggo ingga i na nu Urushalima nggo. Ankpinkpye abikye ba a di kpanye ki ingga, di ingga di vɨ anishirr ba Abachi shishemi ku harr. Aba ti ttu ba iba di a ta ngɨ ba nggo, ingga kpanye di a bu ngɨ ba. ");
INSERT INTO ninNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ankpu shishemi ingga di ki ba iha na aki ka issubi ka ani Yahuda ka ni na anko nggo a ta du ba a re are andanda ni itu i Yesu. Ingga i ki unfu na ba kakami, ni di ssuzzu ku di zha abiga ba ni igbu inggi yi nggo i si si imunta hen, wre ki ingga i bu ki ba iha. ");
INSERT INTO ninNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“A si na ankpa anuma nggo ingga i kpa angbamvu na ankpinkpye abikye ba ba. Angbamvu a kama yo a kpanye ki ingga di ingga bu kuma nu Damasika ku vɨ abiga ba nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","A si na anko a Damasika na azhi na atsutsu, ingga i hi uru numa la nzarr zhi nu unkplassu nu la mri azhi wa. Ù la kago ingga na anishirr ba nggo a so zirr ni ingga ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Inta kuhre ni imimi wemi, ingga i wo ukorr u ddu ingga ni irrirri inu Ibraniya di, ‘Shawulu, Shawulu, ùwà so ki ingga iha ngginggi? Ùwà so ki ku itu imuwa ankpa, nggo ùwà so ta anggaza nâ ta sa alando aniru nggo a so kà iwo amfarr a atiko ama wa.’ ");
INSERT INTO ninNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Ingga i zhi di a su uwanggo nggo, Atiko?” “Atiko wa à da di, ‘A si ingga Yesu, wanggo nggo ùwà so ki ma iha yi nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gru kri kikri. Ingga nggurr ssuzzu ku ùwà, wre ki ingga bu na ùwà ki uvurr iko amungga. Ùwà ta da ku abanu inkindirr yi nggo ùwà i hi ni itu imungga ari nggo, tuku inkindirr yi nggo ingga ta tsarr ùwà ni ichi. ");
INSERT INTO ninNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ingga ta kpa ùwà ttungo na ango ka anishirr bu Israila tuku abangga ba nggo a si si ani Yahuda hen. Ingga ta tu ùwà kuma na aba yo ba. ");
INSERT INTO ninNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Ùwà ta ku bwu ba ashishi, ni ttu ba zhi ni ibwu kuma ni ila iru. Ni ta ttu ba zhi nu ukyekye ku Isheta gri kuma nu ukyekye ku Abachi, wre ba bu kpa inggurr zhi ku ila ure imbarr yi. Na ta kpa abubo a iso na anishirr abangga ba nggo Abachi à hla ba nu nggo a kpanye ni ingga ku nggo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Uttu Agripa, à si ima yo di ingga i na inkindirr yi nggo ula ku ù da ki ingga zhi nu unkplassu. ");
INSERT INTO ninNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ni ime̱me̱ yi, ingga i bre ku anishirr ure ku nu Damasika, ni kuma nu Urushalima tuku igbu yi kago nggo i si si anu Yahudiya hen. Ni ikikre yi, ingga i kuma na abangga ba nggo a si si anu Yahuda hen ni ku ddu ba di, a bu kasarr na kanga na Abachi ku! Ni du iso tsitsirr imbarr yi i tsarr inta di aba a kasarr jiji. ");
INSERT INTO ninNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","A si amarr akama yo a du ani Yahuda ba a vu ingga nggo ingga i si nu Uki ku Ibarr ku na da aba ta ngu ingga. ");
INSERT INTO ninNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Bazhi ni ima, Abachi à di zi ingga. Ima yo di ingga kri ni inggya so bre ku anishirr we, ankpinkpi na atsitsa, inkindirr yi nggo ingga ì hi yi. Inkindirr yi nggo ingga i da i si iyiyirr ima yo nggo abi kpa are ba, u Musa a da di taka la nggo, ");
INSERT INTO ninNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","di Kristi wa à taka ki iha na taka si ni ime̱me̱ ni tasi ni ibe, wre ku Ure ku wre ku ikpa ittungo ku nggo a da ku anishirr ama anu Yahuda ba na abangga ba nggo a si si anu Yahuda hen, a bu bwu ba ashishi nâ ta su ila iru nggi.” ");
INSERT INTO ninNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nggo Bulu à so re meme u Festu à nggarr ito na ku di, “Bulu, ùwà i la! Ibre ta anko imuwa yi i du ùwà ta la.” ");
INSERT INTO ninNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Bulu à ddu ma di, “Ingga si la hen, ankpye Festu. Are ka nggo ingga ko re nggo à si are ajiji, i wre ingga i da ka. ");
INSERT INTO ninNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Uttu Agripa mi à hi are ka, ima yo ì du ingga so re sama ni isisu nu nggo ingga hi di à hi aseki angga ka a si ajiji, a si na ka sharri mu hen. ");
INSERT INTO ninNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Uttu Agripa, ùwà kpanye na aseki ka nggo abi kpa are ba a charr da nggo? Ingga ì hi du ùwà kpanye na ka.” ");
INSERT INTO ninNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Uttu Agripa à ddu Bulu di, “Ùwà kye du ùwà ka ka ingga ki uniga Kristi ni ikuso ntsɨ inggi yi?” ");
INSERT INTO ninNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulu à ddu ma di, “Ka ntsɨ, ka ì ta anko, ibarr imungga inggi i si di Abachi bu du ùwà na abangga ba nggo a so wo ingga ni re yi we a bu si nâ ti ingga i se, na bu sama na ache angga ka yo mre.” ");
INSERT INTO ninNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Mre uttu wa tuku ugona wa, u Banisi na abanu ba wemi a gru kri kikri. ");
INSERT INTO ninNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Na share nggo na ddu ikpa di, “Ugo nggo à si na inkindirr yi nggo i ma a bu ngu ma ka gri ma ku harr hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa à ddu Festu di, “Ka du ugo nggo a si ba ure ku na kuma nu Kayisa wa ku hen a ka ttu ma ttungo.” ");
INSERT INTO ninNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nggo a kpanye di inta bu kuma ni Italiya, na ka Bulu tuku abi kri harr abanu anu Juliyo, ankpye a inkirr i abi ta iku i Roma yi nggo a yo yi di, “Inkirr i Kayisa Agostu.” ");
INSERT INTO ninNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Inta i rri ni ijirrigi i amasirr nggo so zhi nu Adramitiyu ni i ta so kuma ni igbu i unddu amasirr yi nggo si na anga ka Asiya nggo. Inta ga ijirrigi yi share. Arristaku anu Makidoniya nggo zhi ni igbu nu Tesalonika à ga inta. ");
INSERT INTO ninNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Inta zzu na ambre ka ni rri nu Sido. Juliyo à na wre ku Bulu na du ma ku kye akpukpama du ba nu ma aseki ka nggo à zha na undu na ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Inta gru kuchi nu uzirr ku, unddunddu ku u so go ni turr inta tankpami, inta kye ni hun hin hun ga unddu ku Sayiprosi, igbu wanggo nggo a si na atsutsu ka amasirr ka nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Inta kucha inyi wa ni kashirr i anga ka Silisiya tuku Pamfiliya ni nga nu Mirra nu Lisiya. ");
INSERT INTO ninNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nabo ankpye abi ta iku wa à hi ijirrigi ì so zhi nu Alezandra ni ta kuma ni Italiya, mre na di inta i rri na yi. ");
INSERT INTO ninNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Inta i darr ni ijirrigi yi bwemi ki ivi shishemi ni ki iha bari ni rri nu unddu inyi ku igbu nu Kinidu. Unddunddu ku u han inta ni kuchi nu uzirr ku ga anga nggo inta i so kuma nggo. Inta kye ni darr ba ni igbu nu Salimone, wre ku igbu nu Kreti wa nggo a si na atsutsu ka amasirr ka à bu chirr ki inta unddunddu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Inta so darr ga unddu inyi ku ni ki iha bari ni nga ni inkla numa a yo yi di, inkla Izu Ijirrigi Zizi, i si ta anko zhi ni Lasiya hen. ");
INSERT INTO ninNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Inta i so tanko. Uzirr ku mi ù gru ki isisu, nu nggo uhwa ku uwurr ku unddunddu ku ù ka ma ba, nggo Azhibarr Inggurr Ila Ure wa a ka vu sarr ba. Mre u Bulu à nu ba amarr di, ");
INSERT INTO ninNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Akpukpa mu, ingga i kye inta ti darr ziza nggo ijirrigi imunta yi mi ni iki yi nggo ijirrigi yi i vu yi nggo ì ta na ki ndanda, anishirr mi a ta kɨ.” ");
INSERT INTO ninNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ankpye abi ta iku wa à kpanye ni inkindirr yi nggo ankpye ni ijirrigi wa tuku akikye wa a da nggo, na si kpanye nu ure ku Bulu ku hen. ");
INSERT INTO ninNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Inkla izu ijirrigi yi i si wre nggo a ka so nabo ma nu umvru ku ni kre yi hen. Ima yo du igarr anishirr yi a gru gbirr uzirr ku kye hi di aba ka ku rri nu Fonika. Fonika à si ni igbu nu Kreti nggo kri na atsutsu ka amasirr nggo. Abubo a zu ijirrigi i amasirr wa nggo a se nabo a kri sharri ku unddunddu ku. ");
INSERT INTO ninNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Unddunddu ntsɨ u gru so go zhi ni ikashirr, abi na undu ni ijirrigi ba a kye di aba a ta na inkindirr yi nggo a zu ni isisurr di aba ta na nggo. Na gru ttu inkpu inklo yi nggo di lo ijirrigi yi zu ni inkla iyirr ssuzzu na amasirr wa, na darr ijirrigi yi so ga unddu ku Kreti. ");
INSERT INTO ninNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mre unddunddu unkpi, nggo u di go zhi ni ikatu i anza ambre, u gru go zhi ni igbu wa nggo amasirr wa a ka ma yo na atsutsu nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Unddunddu ku u nggurr ni ijirrigi. Ijirrigi ima chankarr ni turr unddunddu ni kuma, inta kye ni ba ttungo ni turr yi, ni du yi ka so ga inkla yi nggo unddunddu ku so ba. ");
INSERT INTO ninNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Unddunddu unkpi ku u go inta gri nga na achi ka ivi igbu wa nggo a ri Kawuda, amasirr wa a ka ma yo na atsutsu nggo. Anga wa nggo inta i se nggo à kri sharri ku unddunddu ku. Inta i tsi kakami nu unddunddu ku ku ni narr uddu uvutsa ku kpa. ");
INSERT INTO ninNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Abi darr ijirrigi ba a gba uddu uvutsa ku ni yo ni ijirrigi yi, na lo ijirrigi yi na azhizhi kago. Nu nggo a kru di ijirrigi yi ì ta ku rri nu ugbuhun ku Sirriti, ni Libiya, ima yo i du ba a ttu upri inkru ku tuku iki inuma yi nggo i di zi ba ni turr ijirrigi yi nggo, na ttu ijirrigi yi ttungo du unddunddu ku u turr yi ni so kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Nu nggo unddunddu ku u ka ni so go kakami nggo, aba zzu na ambre ka na ddu iki numa yi nggo ijirrigi yi i gri nggo a so tu surr nu umi ku amasirr ku. ");
INSERT INTO ninNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","U nu tarr wa zizo aba ddu aseki anuma ka ni ijirrigi yi tu surr na amasirr wa. ");
INSERT INTO ninNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Inta ma ivi shishemi sama ni hi azhi ni si hi intsintse̱ hen, unddunddu ku u ka ni so go kakami, inta ttu isisurr glo di inta ta ssuzzu zizi ni ijirrigi yi. ");
INSERT INTO ninNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nggo anishirr ba a so ta anko sama ni iri inkindirr, u Bulu à gru kri na ddu ba di, “Amuya, ka di imba i wo ki ingga ni si di inta i gru nu Kreti hen, inta ka si ki iha inggi yi ni vu aseki angga ka kahre ma mi hen. ");
INSERT INTO ninNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ziza nggo ingga i barr imba, vu isisurr. Uyirr amba a si ta ttu hen, ijirrigi yi mu i ta na ki ndanda. ");
INSERT INTO ninNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Unitu a Abachi wanggo nggo ingga i di ga ma ni di barr ma nggo à nga ni kri ki ingga nu ungo yirr ni ibittu, ");
INSERT INTO ninNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","na ddu ingga di, ‘Si kru isisu hen Bulu, ùwà ta kri na age̱ ka Kayisa wa. Abachi nggo à di na wre ku ùwà nggo à ta kpa anishirr ba nggo imba i so zirr ma mi nggo a ttungo.’ ");
INSERT INTO ninNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Meme nggo amuya, imba bu vu isisurr. Ingga hi Abachi à ta na inkindirr yi nggo à da ki ingga nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ni ima mi unddunddu ku ta turr inta ko ni inkla krizhizhi numa nggo amasirr a ka yi yo na atsutsu nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ni ibittu na azhibarr awurr nu ne̱s wa, unddunddu ku u turr inta kago ni inyi nu Mediterreniya wa. Na atsutsu ka ibittu ka, uwa zzu ku abi darr ijirrigi ba di inta i ko ki ywhiywhirr nu unddu ku inyi ku. ");
INSERT INTO ninNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","A ba izhizhi itsarr ita i amasirr a lo ni inkpu inklo na tu yi tu yo na amasirr wa, wre ba bu hi ita i amasirr yi. Uwa si imita iso itarr ni itangba (37). A sha so na gru tsarr kye zizo amasirr wa a si imita iso itarr ni itangba (27). ");
INSERT INTO ninNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","A kru di ijirrigi yi ì ta ku nggurr na angbinta, na vu ankpi anklo ane̱ a lo yi zu nu ugo, ni inkla iyirr, na ko barr Abachi di ambre a bu nggarr. ");
INSERT INTO ninNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Abi di darr ijirrigi ba a gru ko ssu anko wa nggo aba ta kru share. A ba uddu uvutsa ku a tu yo na amasirr wa, na gru na da aba ta ku lo ankpu inklo numa ngga tu surr ni ichi i ijirrigi yi. ");
INSERT INTO ninNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","U Bulu à ddu ankpye abi ta iku wa na abi ta iku ba di, “Abikye ijirrigi angga ba a ta si so ni inta ba ni ijirrigi hen, imba ta kɨ ni ijirrigi inggi yi.” ");
INSERT INTO ninNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Abi ta iku ba a gru sarr azhizhi ka kahre na du uddu uvutsa ku ù gu kuma. ");
INSERT INTO ninNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ambre a nise nggarr hwa hwa, u Bulu à tsi ku anishirr ba ango wemi di a bu zha ila a ri. À ddu ba di, “Imba i ki ivi iwurr ni ine̱ inggi ni so sama ni iri inkindirr. ");
INSERT INTO ninNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ingga tsi ki imba ango kpa ila ri, wre ki imba bu so tsitsirr ni si kɨ hen. Infunfutu iyirr i si ta nado ki imba hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Bulu à da meme nggo, na ba unfonfo na nyarr ku Abachi na ashishi ka anishirr ba, na mɨ ma ta. ");
INSERT INTO ninNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Anishirr ba a vu isisurr gri na gru kpa ila ri wemi. ");
INSERT INTO ninNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Inta wemi ni ijirrigi yi i si anishirr ayiyirr aha ni iso tangba na tani (276). ");
INSERT INTO ninNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Anishirr ba a ri shi wemi nggo na gru ddu alikama ka wemi a tu surr na amasirr wa du ijirrigi yi i kaki futtuttu. ");
INSERT INTO ninNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nggo ambre ka à nggarr, abikye ijirrigi ba a kye unddu ku amasirr ku chankarr na si hi inkla yi nggo aba a se hen. A hi inkla inuma i ttu itu na amasirr wa nga na ábì, na gru da aba ta turr ijirrigi yi ssuzzu nga nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","A gye ankpu inklo ka nggo di lo ijirrigi yi zu ni inkla iyirr nggo, na du ka ji rri na amasirr wa. Na ddu azhizhi ka nggo di lo unkunkurr ku idarr ijirrigi ku nggo. Mre na gɨ upri inkru ku ni ichi i ijirrigi yi i zirr nggo ijirrigi yi i gru so gu ga unddunddu ku kuma nu unddu ku amasirr ku. ");
INSERT INTO ninNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ijirrigi yi ka ni ku nggurr nu ugbuhun ku. Itu ijirrigi yi i ku harr, ankinkirr ka a hlo ugo ku nggarr. ");
INSERT INTO ninNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Abi ta iku ba a na anko wa nggo aba ta ngɨ abi kri iharr ba wemi, wre ba bu si darr ssuzzu hen. ");
INSERT INTO ninNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","U Juliyo, ankpye a abi ta iku wa à zha anko du uwa ka kpa Bulu ttungo, na han abi ta iku ba ni na inkindirr yi nggo a zha di aba a ta na yi nggo. A na meme nggo na du abangga ba nggo a hi idarr nggo, a tu rri na amasirr wa na so darr kuchi kuma na ábì. ");
INSERT INTO ninNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Abanu ba a vu ankpunkpu nkinkurr ka na ankpu ijirrigi ka gri na darr na ga ba. Inta wemi na meme yo ni ssuzzu zizi nga na ábì. ");
INSERT INTO ninNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nggo inta ssuzzu zizi nga nu unddu ku amasirr ku, aba a da ki inta di a yo inkla ima yi nggo kri na atsutsu ka amasirr ka di Malita. ");
INSERT INTO ninNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Abi ìgbù ba a kpa inta zizi. Ahru a so ku, umvru u su, aba a mu uru di inta vri. ");
INSERT INTO ninNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Bulu à vu infinfla inkinkurr so surr nu uru ku, ìwǎ à wo issu iru yi na gru ssuzzu ni tse Bulu nu ungo na klo ku na ku. ");
INSERT INTO ninNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nggo abi ìgbù ba a hi ìwǎ wa ni klo ku Bulu nu ungo ku na ddu ikpa di, “Ugo wa nggo à si uni ngu unushirr. Ni ifirr ssuzzu ima yi na amasirr wa mi, azhi a amasirr wa nggo à di du anishirr a ki iha ku ikpala imbarr yi à ta ngu ma.” ");
INSERT INTO ninNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Bulu mɨ ungo ku ìwǎ wa à jaku nu uru ku na si na ku inkindirr hen. ");
INSERT INTO ninNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Abi igbu ba a kye di ukpa ku Bulu ku ù ta ssu, ka Bulu à ta gru ji jaku iku. A so ta anko na si hi inkindirr na ku Bulu hen, na kasarr da na amarr ambarr ka di Bulu à si ábáchí. ");
INSERT INTO ninNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Bazhi nabo na kuma ni izzuzzu i Pubilu, ankpye unkpi uni kye igbu wa, à si ta anko hen. À kpa inta zizi, inta ki ivi itarr ni se abichirr ama. ");
INSERT INTO ninNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Aki a Pubilu wa à sama nu ukpa kyekye na kurr ko wri kpakpa ku umvru, ine ihan ma uwa so kahre ayiyi. Bulu à rri kuma ku kye ma, na barr Abachi, na sa ango na ku, uwa wre. ");
INSERT INTO ninNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","A na meme nggo abu lolo abanu ba ni igbu wa a nga, uwa a barr aba wemi a wre. ");
INSERT INTO ninNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","A ni inta aseki shishemi inta ta gru ni ijirrigi yi aba a surr ki inta aseki anuma nggo inta ta na undu na ka nu uzirr ku nggo. ");
INSERT INTO ninNT_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Inta ki ihwa itarr ni gru ga ijirrigi i amasirr yi nggo i zhi nu Alezandra. A yo yi di, “Anazhi Ahe̱,” (Kasto tuku Poluku). A na ba aha mi sa ni itu ijirrigi yi. I kri nu Malta zhi na aba mu. ");
INSERT INTO ninNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Inta ga yi ni nga ni rri ni igbu nu Surraku ni ki ivi itarr nabo. ");
INSERT INTO ninNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ni gru nabo nga nu Regimu. Ambre ka nggarr unddunddu u gru so go zhi ni kashirr, inta i ki ivi iha ni rri nu Putiyoli. ");
INSERT INTO ninNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Inta i hi abiga abanu nabo, aba a di inta i so na ba ki isati iyirr. Mre inta i nga nu Roma. ");
INSERT INTO ninNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Amuya ba nu Roma a wo inga imunta yi na gru zhi ni igbu yi gbagbamu nga ni inta ba nu Udu ku Apiyo tuku Ako a Kpa Abichirr Atarr wa. Bulu à hi ba na nyarr ku Abachi, na kaki kyekye kakami. ");
INSERT INTO ninNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nggo inta i rri nu Roma nggo, u Bulu ku so na nkpama na zu ku uni ta iku di a bu so gbye ma. ");
INSERT INTO ninNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","A ki ivi itarr u Bulu à yo ankpinkpye ba ani Yahuda ba ni issubi. A nga ni nggurr bi nggo, uwa à ddu ba di, “Amuya, ingga i si na inkindirr indanda ku aba akonta ba hen, ni si vu sarr ku aseki ka nggo akiki amunta a di na ka hen, aba vu ingga nu Urushalima a nu anu Roma ba. ");
INSERT INTO ninNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Anu Roma ba a bɨ ure umungga ku kye na si hi inkindirr indanda ni ingga ku hen, na da aba ta ttu ingga ttungo. ");
INSERT INTO ninNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ani Yahuda ba a kà. Nggo ingga kye chankarr ni ba ure ku ni nga nu Kayisa ku. Meme mi ingga si da di anishirr amungga a na ki ingga ndanda hen. ");
INSERT INTO ninNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ima yo di ingga da di ingga ta hi imba ni re ni imba ba. A yo ingga na ache angga ka ku Atiko wanggo nggo ani Israila ba a surr ashishi na ku nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Aba a ddu ma di, “Inta i si kpa ungbamvu numa zhi nu Yahudiya ku inga imuwa yi hen. Uyirr nu umi ku amuyirr amunta a si zhi nabo na ni da ki inta inkindirr indanda ni itu imuwa hen. ");
INSERT INTO ninNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ni ima mi, inta zha di inta ta wo amarr amuwa nu nggo a re ndanda ni itu i nggurr bi yi nggo ùwà se nu umi nggo.” ");
INSERT INTO ninNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","A zu ivi i nggurr bi nu Bulu ku, anishirr shishemi a nga ni inkla yi nggo Bulu à di so. Uwa so di bre ba are ka ittu i Abachi yi zhi na ambre ma ni ibittu. À kri karrkarr du uwa ta du ba kpanye nu ure ku Yesu ku zhi na Are ka Musa tuku icharr i Abi kpa are yi. ");
INSERT INTO ninNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Abanu ambarr ba a kpanye nu ure umaku, abanu ba a si kpanye hen. ");
INSERT INTO ninNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","A re varrvarr ku ikpa, na ga ki na nkanka, nggo u Bulu à da di, “Ima ma nggo Izhi Iwre yi i du Ishaya uni kpa are Abachi wa à da di: ");
INSERT INTO ninNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","“ ‘Kuma ku da ku anishirr angga ba di, “Imba ta wo, ni wo yo mre ni ta ssurr achi ka inkindirr yi nggo imba i wo nggo; imba ta kye kakami ni si ta kye hi hen.” ");
INSERT INTO ninNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","A si nggo isisurr i anishirr angga ba i tsɨ kakami; a ka si wo ure na atu ambarr ka hen, na ttu ashishi ambarr ka. Na ka di i si si meme hen, ashishi ambarr ka ka kye hi, atu ambarr ka ka wo ure, isisurr imbarr yi i ta hi inkindirr krizhizhi mi aba ka kanga ni ingga ku, ingga ka du ba wre.’ ” ");
INSERT INTO ninNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Ni ikikre yi Bulu à ddu ba di, “Imba bu hi di Abachi à zha du uwa ta kpa abangga ba nggo a si si anu Yahuda hen ttungo! Aba a ta shirr atu na ku.”  ");
INSER