﻿USE sofia;
DROP TABLE IF EXISTS sofia.nii_vpl;
CREATE TABLE nii_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nii_vpl WRITE;
INSERT INTO nii_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ei Jiisas Krais nge kupam noł tiłap ei, Deipis nge tiłap. Nga Deipis eim Eiparam nge tiłap ende. ");
INSERT INTO nii_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eiparam eim kingam Aisik, Aisik eim kingam Jeikop, Jeikop eim kingam Jura ni angim noł pei. ");
INSERT INTO nii_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jura eim kingam Peres kin Sara, eł ełip menjngił ei Tamar. Peres eim kingam Esran, Esran eim kingam Ram, Ram eim kingam Aminarap. ");
INSERT INTO nii_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminarap eim kingam Neison, Neison eim kingam Salmon. ");
INSERT INTO nii_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon eim kingam Bowas, eim mam Reiyap. Bowas eim kingam Opes, eim mam embe Rus. Opes eim kingam Jesii. ");
INSERT INTO nii_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesii kingam King Deipis, Deipis eim kingam Solomon. Mam ei ok Yuraiya nge ambim. ");
INSERT INTO nii_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon eim kingam Riyapom, Riyapom eim kingam Apaisa, Apaisa eim kingam Asa. ");
INSERT INTO nii_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa eim kingam Jiyasopas, Jiyasopas eim kingam Joram, Joram eim kingam Yusaiya. ");
INSERT INTO nii_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yusaiya eim kingam Josam, Josam eim kingam Eiyas, Eiyas eim kingam Esekaiya. ");
INSERT INTO nii_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaiya eim kingam Manasa, Manasa eim kingam Amon, Amon eim kingam Josaiya. ");
INSERT INTO nii_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiya eim kingam Jekonaiya kin eim angim noł, kunum ełe Esrel wumb Bapilon konu ełe kan ngii mił punjung kongun dinga enjing ku. ");
INSERT INTO nii_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kan ngii mił punjung kongun dinga erik kunum ei Jeikonaiya eim kingam Siyalsiyel, Siyalsiyel eim kingam Serapapel. ");
INSERT INTO nii_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serapapel eim kingam Apiiyur. Apiiyur eim kingam Eliyakim, Eliyakim eim kingam Asor. ");
INSERT INTO nii_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor eim kingam Sarok, Sarok eim kingam Akim, Akim eim kingam Eliyur. ");
INSERT INTO nii_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyur eim kingam Eliyeisa, Eliyeisa eim kingam Masan, Masan eim kingam Jeikop. ");
INSERT INTO nii_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jeikop eim kingam Josep, Josep eim ambim Maria, pe Maria eim Jiisas mengim, wumb eim Krais niłmin. ");
INSERT INTO nii_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yi mił Eiparam nge tiłap ełe opu Deipis tonu onum. Pe wumb tiłap ei nge engki nga kapił kapłi mulnjung. Deipis nge tiłap ei pei Bapilon konu kan ngii mił punjung. Ei wumb tiłap engki nga kapił kapłi mulnjung. Pe Bapilon konu kan ngii eł mułangin Krais tonu om kunum ei, wumb tiłap engki kapił kapłi tonu ok mulk, yi mił mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jiisas Krais nge ek poł yi to tu wunjung, mam Maria, Josep simba nik kuimi to mundnjung ninjing. Ba wumb tał tep to ende endnerangił, ba amb Maria Gos Gui Ka tuk wang kin amb Maria, kangił mundum. ");
INSERT INTO nii_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Wam simba ninjing wu Josep eim wu kun ka mołpu endim. Wu ei eim kenim ni ambił kangił peng kanpi, ambił singambił simba nipi si kindmbii ni yi piim. ");
INSERT INTO nii_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep eim yi piipi pupu or pim konu, Gos nge Enjel kindang opu eim kin ek yi mił nim, “Josep nim Deipis nge kingam, nim amb Maria simbii ni singambił kulerii mon! Piini! Eim kangił mołum ei Gos Gui Ka kangił eim kin mołum. Or kumb yi mił kenim. ");
INSERT INTO nii_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pe eim kangi endi mengmba, kangi ei embe Jiisas ninjii. Nimbił erang, kangi ei wumb pei oł kis ei kil ngopu, nga sipi orung simba ku.” ");
INSERT INTO nii_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Epi ombu pei tonu om kin, ok ek ni tor kindiłmin wumb Gos oł ekii se ermba ei piipi niłim wu ei Gos gupu ełe ek keimi ei pei tor omba. Gos nge ok ek ni tor kindiłmin wumb ek ei ok nirim mił, tonu om. ");
INSERT INTO nii_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Piini! Ambił ei kangi endi mengpi nim kin kangił ei embe Emanuwel, ningii,” pa yi nim. (Ei pułe yi mił, ‘Gos sinim kin ouni mołum.’) ");
INSERT INTO nii_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep or kumb er kenim mił, angpi pupu owundu nge enjel nim ek mił piipi, pupu eim ambim sim. ");
INSERT INTO nii_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ba eim kin tep to endnenjingił, eim kangi mengim kunum ei, eim kangi ei embe Jiisas nim. ");
INSERT INTO nii_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Jiisas mengim konu kembis embe Beslem ei Juriya konu owundu mei konu ełe Eros King mułum kunum ei Jiisas mengim. Ekii se wu kombur ał mani eni tonu onum konu orung tonu ełe wu noman pim wu ombu ok Jerusalem konu ok yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Kangił konj endi mam mengim ei Jura wumb King mułmba nge tonu om; ei jiłi pałim? Sin kenjpin ni eim tonu om konu ełe kanjip konj ei tonu o peng kanpin eim embe ambił tonu kindpin ngumun ei nge onmun,” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Eros eim ek ei piipi, tungu enim. Nga wumb Jerusalem konu mulnjung wumb ei Eros kin tungu enjing ku. ");
INSERT INTO nii_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pe King Eros eim kułmał kałmin wumb owundu ni Esrel wumb num noman pim wumb ei pei neng kułou tunjung. Tangin, eim wu ombu kii sim. “Gos kindim wu Krais konu jiłi mił tonu omba?” ");
INSERT INTO nii_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Wumb ei ek yi ninjing, “Beslem konu kembis ni Juriya mei owundu ok wumb oł ekii se tonu omba piipi niłim wu mon yi mił pułum ei pałim,” ninjing ");
INSERT INTO nii_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Nim Beslem konu kembis, Jura konu owundu wii mon. Nim konu owundu mił mulnjii. Nimbił erang, nim kin wu owundu endi omba wu na nge tiłap ełe Esrel wumb eim ekii singii tep ermba.’” ");
INSERT INTO nii_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","King Eros eim popuł sim, ba eim nge wu ombu ał konu orundung noman pim wu ombu wii tang wangin kin, wu ombu kii sim. “Enim eni tonu ołum konu orundung wu, enim kanjip ei kunum nenj tonu wang kenjing?” ");
INSERT INTO nii_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Pe King Eros ek yi nim, “Enim Beslem konu puk kin kongun dinga er andik, kangił ei kan singii. Kan sik, nga orung ok na nengin kin, na yi ku pup men top ermbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","King Eros ek nim mił piik punjung. Pe nga en enim eni tonu ołum konu molk, kanjip kanik kanjip ei, en enim pungii konu kumb se pang kanik ekii se punjung. Pe kanjip ei pupu, kangi pim ngii eł tonu kun pim. ");
INSERT INTO nii_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wu ombu en enim kanjip ei nga kanik kin wu ombu ka ka piinjing. ");
INSERT INTO nii_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Pe ngii ełe nirik punjung. Puk kenjing ni kangi ei mam Maria kin mulnjunguł. Pe wu ombu en enim mong gopsing pii polk molk, men tok erik, en enim kon apsik, ond muł tuk ełe muru ka tołum epi ni, dup kiłangin muru ka tołum ei ni, gol ni kangi Jiisas ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","En enim epin or pinjing konu, or kumb kenjing ni Gos yi nim, “Enim King Eros kin orung punerngii mon! Andłam eipi endi puk kin en enim konu pungii,” nim. Yi neng kin, wu ombu en enim andłam eipi ełe puk, en enim konu ełe orung punjung. ");
INSERT INTO nii_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pe wu ombu orung punjung. Pangin, Josep or pepi or kumb kenim ni, Owundu nge enjel opu yi nim, “Nim angkin, kangi ei mam teł sikin Eisip konu sipnjii. Enim orung ongii kunum ei, na ek nimbii. Pe King Eros eim kangi ei to kundmbii ninim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pe Josep eim kangi ei kin mam teł epin tuk mii memb si mengpi Eisip konu sipim. ");
INSERT INTO nii_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pe Josep eim ni Eisip konu owundu mułangin kin King Eros eim kapłi kułmba. Oł ekii se tonu omba ei piipi niłim wu ei kin Gos Owundu eim neng, ek ei keimi pałim. Eim ek yi nirim, “Na kangi ei Eisip konu mołum ei na wii tamb tor omba.” ");
INSERT INTO nii_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pe king Eros ei piim ni, eni tonu ołum noman pim wumb ei, na ek ei ekii sinenjing mon, yi peng kin, eim popuł kis sim. Sipi, eim wu kombur kindang puk Beslem konu ni konu orung mandi sim konu ełe puk, kangił kembis kung ngii tał o pum kangił ombu to kundngii nipi kindim. Eim yi piim wu noman pim wu ombu ok ninjing kunum ei kangi endi king mułmba nge tonu om ei, na en enim kii sinj kunum ei piik ninjing. ");
INSERT INTO nii_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kumb ok ek ni tor kindiłmin wu Jermaiya gupu ełe Gos ek nipi tor kindrim, ek ei keimi tonu om. ");
INSERT INTO nii_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama konu Beslem konu owundu endi sałim wumb ek tanginmin dinga piinjing. Amb ke owundu nik, ek kaimb er ninim ni piinjing. Resel eim kingam noł piipi ke nim. Wumb eim noman er ka erngii pinerim mon. Nimbił erang, eim nge kingam noł pei mulenjing, wumb to konduk poru ninjing.” ");
INSERT INTO nii_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ekii se, King Eros kułang kin, Josep or pepi or kumb kenim ni, Gos Owundu enjel kindang opu eim kin ek yi nim. ");
INSERT INTO nii_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Nim kangi ei mam teł sikin, Esrel mei ełe si kind orung pui!” nim. “Wumb kangi to kundngii enjing wumb ei kolk poru ninjing,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pe Josep eim kangi ei kin mam teł si mengpi, Esrel wumb mei konu ełe sipim. ");
INSERT INTO nii_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ba eim piim ni, wu Arkelos eim arim Eros mułum konu eim King mołum ninjing. Yi nengin kin, Josep eim konu ełe ba gał erim. Pe nga kunum endi eim or kumb er kenim ni, Gos eim kin ek nim. Pe eim Galilii konu orung pum. ");
INSERT INTO nii_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Eim pupu konu endi ‘Nasres’ niłmin konu ełe pupu mułum. Oł ekii se tonu omba piik niłmin wumb ninjing ek ei keimi tonu om ei yi mił, “Eim Nasres konu ełe wu.” ");
INSERT INTO nii_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Kunum ełe Jon wumb noł pendiłim wu ei opu, eim Juriya wumb konu mei wii sim konu ełe mołpu ek ni tor kindim. ");
INSERT INTO nii_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Eim ek dinga nipi yi nim, “Enim noman ak tungii! Nimbił erang Gos sinim tep er mołum ei enim kin mandi onum.” ");
INSERT INTO nii_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon omba nge, Gos eim ek ni tor kindiłim wu Aisaiya gupu ełe ni tor kindrim, ek yi mił nirim, “Mei wumb mulenjing konu ełe wu endi ek dinga nipi wii top mołum. ‘Owundu nge andłam er kun erei! Owundu omba nge piik, enim noman tuk er kun erik mułngii.’” ");
INSERT INTO nii_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon eim konduk kindiłim kon, ei kung kamil ngenj ełmin kon ei kindpi, kan eim kend ełe tuk si tałpi ei ka ngenj ełim. Eim kuni nołum kuni ei guimbi gulnjambi ni ka piimi muł ombu nopu yi ełim. ");
INSERT INTO nii_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kunum ełe Jerusalem wumb ni Juriya konu orung orung wumb pei noł Joran konu orung wumb pei ok Jon mułum konu onjung. ");
INSERT INTO nii_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nga en enim oł kis ombu ni tor kindik erangin ni, noman ak tok erik kin Jon en enim noł Joran ełe noł pendpi ngum. ");
INSERT INTO nii_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon eim kenim ni, wumb kolk nga konj onerngii piik ełmin ni Lo ek piik ekii siłmin wumb ombu ok noł pimin nik onjung. Ei eim kanpi ek nipi yi nim, “Enim ka wembii nge kingam mił noł noman kis piik enjing, wumb nii enim neng oł ekii se tonu omba ei Gos nge popuł owundu ei tungu pungii nge onmun? ");
INSERT INTO nii_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Enim noman ak tungii nge, oł kun erik, noman ak tok ełmin oł ei mił kun erangin wumb keningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Enim noman tuk ełe yi piinerngii, ‘Eiparam ei sin nge kupenjpin,’ sin noman ak tunermin ei kapłi yi ni piinerngii. Gos eim kapłi ya kom ku ombu erang, Eiparam nge kingam noł mułngii. Mułangin, Gos enim topu tor kindmba. ");
INSERT INTO nii_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Pe nga tui mer ond puł eł pałim. Ond pei mong ka tunałmin, ond ombu kołmung tok dup kełngii. ");
INSERT INTO nii_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na Jon enim noł mendpił ełe noł pendind ei, enim noman ak tangin pendind. Ba Gos kindang wu endi ekii se omba wu, ei eim dinga ei dinga wii, na dinga ei kapłi enanim. Na wu kun ka mołał pim kin, eim simb su ei si kindmbii ei kapłi enand mon. Nga eim enim wumb kopur Gos Gui Ka ei ngang singii ba wumb kopur Gos kin pii gii ninanmin wumb ei Gos nge popuł kis ei dup ningił ełe mułngii. ");
INSERT INTO nii_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Pe Gos kindim wu Krais, eim angił ełe ambiłpi kuni mong wiis kapor ei sik sik tang, wiis tindkan si kindpi wiis kułou tołmun ngii ełe nirik kindmba mił yi ełim. Nga wiis rais tindkan ei sipi dup ełe kindmba, dup kumbułpu nga nopu yi ełim dup endi mon. Kunum kunum nopu pałiłim dup.” ");
INSERT INTO nii_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kunum ełe Jiisas eim Galilii konu si kindpi, noł Joran konu orundung Jon kin pum. Jiisas Jon angił ełe noł pimba nge pum. ");
INSERT INTO nii_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ba Jon eim erang kin Jiisas eim noman ak topu pimba nipi erim, “Na nim kin noł pimbii, ba nim nimbił erang na kin on?” a nipi Jon eim Jiisas kin ek yi nipi orung kindim. ");
INSERT INTO nii_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ba Jiisas ek nipi orung kindim, “Mon, pe Gos nge noman ełe oł kun pałim mił yi na kin enjii ei kapłi,” nim. Yi mił neng, Jon eim ek ekii sim. ");
INSERT INTO nii_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jiisas eim noł pepi poru nipi, noł si kindpi sikir tonu om ni ei epin wuł ał pang, Gos nge Gui Ka ei mani om. Sinim kei Kurmuł ninmin ei mił opu Jiisas kin mułum. ");
INSERT INTO nii_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Pe ek endi epin konu ełe tor om ek ei yi nim, “Kangi ei, na kangił mendpił, na eim noman ngond. Na noman ka eim kin pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Kunum ełe Gos Gui Ka ei Jiisas sipipi wumb mulenjing konu ełe mułang kin, Seisen eim Jiisas ermba oł ei kenmbii nipi ek nimba pum. ");
INSERT INTO nii_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jiisas eim kuni nunarpi mułum, kunum ei kunum 40 epin, tinga pei mułum. Moł pang, eim kuni owundu tang piipi mułum. ");
INSERT INTO nii_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Pe Seisen Jiisas kin ek neng ermba oł ei kenmbii ni piim Seisen yi piipi kin, ei Jiisas mandi tor opu ek nim. “Nim Gos kingam mendpił pim kin, kapłi nim ya kom ku mołum ei ek nen kin bres pengłi!” ");
INSERT INTO nii_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ba Jiisas ek dinga nipi orung kindpi yi nim, Gos ek ka ok nirim mił yi ninim, ‘Bres mendpił ei wumb noman ełe konj ngunermba mon. Ba Gos nirim ek ni tor onum ek ei, wumb noman konj ngonum.’” ");
INSERT INTO nii_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jiisas eim ek yi neng kin, Seisen Jiisas sipipi, Jerusalem men ngii owundu ełe ei tonu mendpił sipim. Sipipi, engndang engim. ");
INSERT INTO nii_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Engang, ek nipi yi nim, “Nim Gos nge kingam pim kin, ełe nim puku sikin mani pan, Gos ek ninim mił, ‘Enjel kindang neng ok, nim enim angił embiłangin, nim simb ełe ku ni epi endi nim tunermba,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nga Jiisas ek yi nim, “Gos nge ek ka nga ninim, ‘Ninim nge Gos Owundu ermba oł ei kenmbii ni enerii mon!’ ninim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nga Seisen eim Jiisas nga sipipi, komung owundu endi pim konu ełe sipim. Sipipi, konu owundu orung orung pei andan topu, konu ka wii owundu pei wu king tep er mołmun konu ei kenjngił. ");
INSERT INTO nii_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nga Siesen Jiisas kanpi yi nim, “Pe nim na kin simb ełe ming gopsing pii polkun, na kin men tokun enjii, kapłi na nim konu ka wii ni epi ombu pei ngumbii,” nim. ");
INSERT INTO nii_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pe Jiisas ek yi nim, “Nim Seisen po! Gos ek ka ok nirim mił yi ninim, ‘Nim Gos Owundu nge embe ambił tonu kindkin men tokun enjii. Erkin, eim kongun ei mendpił enjii,’ Gos nge ek ka yi ninim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yi neng kin, Seisen Jiisas si kindpi pum. Pang kin, enjel ok Jiisas paki tunjung. ");
INSERT INTO nii_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jiisas piim ni Jon kan ngii kindinmin ninjing. Nengin piipi, Galilii konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pupu, Naseres konu si kindpi, Kapaniyam konu ełe pum. Kapaniyam ei noł gopu owundu ełe orundung sim. Nga konu orung Sepulan ni Napsalii konu tał ełe orung sim. ");
INSERT INTO nii_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Yi mił erang kin, pe ok ek ni tor kindiłmin wu Aisaiya gupu ełe Gos ek nirim ei yi mił nirim, ");
INSERT INTO nii_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sepulan mei konu ni Napsalii mei konu ełe andłam pupu noł gopu owundu ełe pupu orung noł Joran tor punum. Galilii konu ei torung wumb eipi wumb konu. ");
INSERT INTO nii_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Konu ełe wumb noman tuk ełe emii mił peng molk oł kis erik mulnjung wumb ei tiłang owundu ei kaninmin! Nga wumb noman tuk ei emii tuk molk kulk poru ninjing konu mił mołmun, ba tiłang ei Jiisas enim wumb kin om, ei tiłang erang nimba. Emii konu kułngii nge mołmun, tiłang ei ok orum poru nim!” ");
INSERT INTO nii_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kunum ełe Jiisas kongun pułngun mondpu ek ni tor kindpi wumb ngum. Ngopu, yi nim, “Gos epin konu sinim tep enim ei, enim kin mandi poru ninim, kapłi enim oł kis si kindik noman tuk ełe ak tok erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jiisas eim Galilii noł gopu owundu wer ełe pupu endim. Pupu kenim ni, wu angim angim tał, endi Saimon nge embe nga endi Piisa. Nim eim angim Endru teł noł gopu ełe omu kon poł simbił ni er mulnjunguł. Wu tał eł ełip omu tołmbuł kongun ei erkił kin ku siłmbił. ");
INSERT INTO nii_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pe Jiisas eim wu tał kanpi kin ek yi nim, “Ełip na kin ekii singił nge weł! Wangił, na ełip wumb eipi nengił na kin ekii singii nge nip ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kunum ei mendpił omu kon ni epi si kindpił, sikir pukuł, Jiisas pum konu ekii se punjnguł. ");
INSERT INTO nii_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Nga Jiisas noł wer ełe pupu kenim ni angim tał, endi Jeimis, Sependii kingam, angim Jon teł erinjngił kin omu kon er ka er mulnjung. Mułangin, ei tonu noł kanu eł molk erinjngił Sependii kin er mulnjung. Nga Jiisas eim wu tał wii tum. ");
INSERT INTO nii_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pe sikir wu tał erinjngił Sependii si kindił, Jiisas pum konu ekii se punjnguł. ");
INSERT INTO nii_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jiisas eim Galilii konu orung pei endim. Andpi, en enim men ngii konu ełe pei ek ka ni tor kindpi wumb ngopu ek ei Gos sinim tep enim mił nipi ngum. Ngopu kin, eim wumb ngenj ełe ening kanim kanim ening, ei er ka erim. ");
INSERT INTO nii_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Eim erim oł ei, wumb ek poł to pangin Siriya konu orung orung wumb piik, pe wumb ening kanim kanim pim wumb ni, ngenj kumbii erpi, kinj num wumb, ni keku tum wumb ni, simb angił mapi erim wumb ni gui kis tuk mułang ni ening kanim kanim pim wumb ei pei tu wunjung. Wumb ei pei Jiisas eim er ka erim. ");
INSERT INTO nii_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pe wumb tiłap owundu punjung wumb ei, Galilii konu ni Dekapolis konu ni, Jerusalem konu ni Juriya konu ni noł Joran orung wumb pei ok Jiisas pum konu ekii se punjung. ");
INSERT INTO nii_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jiisas kenim ni wumb tiłap owundu pei ok, eim kin ongii nge onjung. Ok kin, pe eim komung ełe tonu pupu mułum. Nga eim nge ekii siłmin wumb eim mułum konu kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Pe Jiisas eim ek man ek nipi, eim nge ekii siłmin wu ombu ngum. ");
INSERT INTO nii_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Wumb Gos Gui Ka nge simin nik wii mulnjung wumb, ei ka piyangin. Gos konu ełe tep er mołum epi ei eim nge. ");
INSERT INTO nii_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Wumb eipi oł kis erangin kin wumb ei ke nik mułngii wumb ei ka piingii. Gos wumb ombu kin noman er ka ermba. ");
INSERT INTO nii_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Wumb en enim embe ambił tonu kindnanmin wumb, ei ka piingii. Ei en enim Ernjing Gos epi ka pei ngumba nirim mił, ei pei singii. ");
INSERT INTO nii_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Wumb kombur en enim noman ełe kunum kunum ei oł kun ka er mułngii wumb ei, en enim ka piingii. Gos en enim epi pei ngang kapłi ermba. ");
INSERT INTO nii_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Wumb kombur en enim wumb eipi kin kaimb singii ei ka piingii. Gos en enim kin kaimb simba ku. ");
INSERT INTO nii_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Wumb noman tuk kun ka simba wumb ei, en enim ka piingii. En enim Gos kapłi keningii. ");
INSERT INTO nii_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Wumb kombur en enim wumb eipi kin noman ende pimba nik kongun dinga enmin wumb, ei ka piingii. Gos wumb ei kin yi nimba. ‘Enim nanim kingam noł,’ pa nimba. ");
INSERT INTO nii_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Pe wumb en enim Gos nge oł kun erangin, wumb eipi ok en enim kin oł embin tui erngii, ei en enim ka piingii. Gos sinim tep ełim konu ei en enim nge konu simba. ");
INSERT INTO nii_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pe enim na ek ekii sik erik endangin, wumb eipi enim kin ek ngok, ek kis kanim kanim kend nik ngok, enim kin kis yi enjing kin kapłi enim ka piingii. ");
INSERT INTO nii_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pe enim noman ka seng ka piingii. Enim nge kumep ka singii epi ka wii ei tonu epin sałim. Yi mił, wumb Gos nge oł ekii se ermba piik ni tor kindiłmin wu, ombu ok kin yi enjing ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Pe sinim mei wumb ei ep kusa mił mułmun. Ei pułe yi mił wumb oł kis ełmin wumb ei tonu mani kindik oł kis enerngii mon niłmin. Ba ep kusa singin ei poru nim kin wumb pii gii ei ep kusa singin mił poru ni si kindim. Sinim nimbił oł eramin nga opu singin ermba? Ep kusa ei singin enermba ei wumb si kindiłmin. Si kindangin, wumb kanik, simb eł kambik ełmin. ");
INSERT INTO nii_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Enim mei wumb eł dup tiłang mił erang mułngii. Nga konu owundu endi tonu komung ełe simba, ei koi enermba mon ku. ");
INSERT INTO nii_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pe wumb dup alam kałiłmin, ei sipik peł mandring ni eł kindnałmin mon. Dup ei tonu peni ełe mundangin, tiłang erang wumb ngii nirik mułngii wumb ei tiłang erang keningii. ");
INSERT INTO nii_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Yi mił ku, enim oł kun ka ełmin ei tiłang mił wumb pei andan tangin kanik, enim Ernjing ei epin mołum, ei eim embe ambił tonu kindngii.” ");
INSERT INTO nii_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Na op lo ek ni Gos oł ekii se ermba ombu piik nik ełmin wumb ei to tor kindmba om nik enim yi piinerngii mon. Na op lo ek ni Gos oł ekii se ermba oł wumb pei ek nik enjing ek, ei na pułe nip ka ermbii nge ond. ");
INSERT INTO nii_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na ek keimi nip enim ngond, tonu epin konu nga ya mani mei konu ei poru nimba kunum ei, mon min ek kembis endi tuk lo ek mon eł aninga endi pimba. Ek ei am punermba mon. Lo ek yi pepi mułang, epi tor opu poru nimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pe wu endi eim lo ek eł aninga endi sipipi, ek nipi wumb ngumba wu, ei eim embe tonu Gos epin konu sinim tep enim konu eł kembis wii pimba. Ba wu endi lo ek ekii sipi, nipi wumb ngopu ermba wu, ei eim embe Gos epin konu sinim tep er mołum konu eł Gos eim embe ambił tonu kindmba. ");
INSERT INTO nii_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na enim nind, enim lo ek kin oł kun erik erngii ei, wumb lo ek połmun wumb ni lo ek piik ekii siłmin wumb ni ełmin oł ka ei kapłi to mani kindnenjing kin kapłi enim Gos epin konu tep er mołum konu eł tuk punerngii mon.” ");
INSERT INTO nii_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ok sinim kupenjpin noł sinjing ek ei piik poru ninjing. Enim wumb to kundnerngii mon! Nga wu endi pupu wu endi to kundum kin, wu ei kos ełe ba. ");
INSERT INTO nii_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ba na enim kanip nga nind, wu endi eim angim kin ek mił enjngił kin, eim kos ełe ba. Nga wu endi eim angim kin ek kis nimba, ‘Nim wu kis noman pinałim wu!’ ei eim kaunsul owundu mołum konu ba. Nga wu endi mołpu wu endi nim wu wulu mendpił nimba, wu ei dup konu mendpił ba. ");
INSERT INTO nii_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Pe ninim Gos kin kułmał kelnjii nge okun, kułmał kałiłmin konu mandi angkin piinjii ni ninim angnim kin ek endi pałim. Ei piikin kułmał kelnjii epi eł mond si kindkin, pukun angnim kin ek ni kun erkin poru nikin, nga orung okun, Gos kin kułmał kał ngunjii. ");
INSERT INTO nii_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Pe wu endi nim kin kos ermba neng, ełip andłam eł punguł konu eł nim ekii sikin eim kin noman ende sekin ek ka ni enjii. Yi ninen kin, wu ei nim sipipi ek pii kun ełim wu ngang, nga ek pii kun ełim wu ei ngang, wu ei sipipi opu ond wumb ngang, opu ond wumb eim sipik, kan ngii eł kindngii. ");
INSERT INTO nii_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Na nim kanip nind, pe nim ku epi ngo pendin, ei kopur pei ngunen kin nim kan ngii sikir tor onenjii mon!” ");
INSERT INTO nii_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Enim kin ek ei ok tor om enim piik poru ninjing, ‘Nim wu amb eipi nge ningił enenjii mon.’ ");
INSERT INTO nii_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ba na enim kanip yi nind, wu endi eim amb eipi endi kanpi noman to piimba wu, ei eim oł kis noman ełe erpi poru nim. Wu ei lo ek ei piinerim mon. ");
INSERT INTO nii_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nga ninim ningił tundung epi endi kanpi oł kis ermba, erim kin ningił tundung kopis si kindnjii. Ei mił nim oł kis ei si kindnjii. Ninim nge ngenj orung kopur kopis kindnjii ei kapłi. Mon pim kin, nim ngenj ei kopis kindnen kin, nim ngenj pei mer dup konu kis ełe ba.” ");
INSERT INTO nii_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nga ninim angił tundung oł kis endi erim kin, angił orung kiłip to kindnjii. Nimbił erang nim angił tundung kiłip to kindan, ei epi kis ba ninim ngenj orung pei dup konu ba ei epi kis mendpił. Oł yi eran kin nim ngenj pei mer dup konu ełe punermba.” ");
INSERT INTO nii_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Kumb ok lo ek endi tor orum ek ei yi nirim, ‘Wu endi eim ambim si kindmba wu, ei eim ok pupu kos pipe sipi amb ei ngumba,’ niłmin. ");
INSERT INTO nii_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ba na enim kanip nind, wu endi eim ambim si kindmba, ei eim ambim wu eipi kin ningił enermba wu ei lo ek to kindim. Nga wu endi ok ambim si kindim amb ei, nga wu endi simba wu, ei lo ek to kindmba.” ");
INSERT INTO nii_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ek endi sinim kupenjpin noł sinjing ek ei enim piinjing. Ei yi mił, enim ek keimi endi nik tonu kindik ek dinga nik enjing, ei to kindnerngii mon. Ba ek keimi endi ninjing kin, enim ek kun nik Owundu kumb eł ninjing ek ei yi mił erngii. ");
INSERT INTO nii_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ba na enim kanip nind, ek keimi endi nik tonu kindik dinga enerngii mon! Enim tonu epin Gos konu sik ek endi nik dinga enerngii. Epin ei Gos eim mołum konu. ");
INSERT INTO nii_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nga mani mei eł nik ek endi nik dinga enerngii ei mon. Nimbił erang mei ei mei kembis Gos simb sałim konu. Nga Jerusalem konu nik ek endi ni dinga enerngii ei mon! Jerusalem konu ei King Owundu konu sałim. ");
INSERT INTO nii_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na ek dinga endi kun keimi pinerang kin, eim na peng eł tui topu kołmung erpi si kindmba, pa ninjii mon. Enim peng enjin ei endi kuru erpi wu tukui mił pinermba; nga peng enjin endi ping erpi wu gał mił yi enermba mon ku. ");
INSERT INTO nii_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ba enim wu nik mon ni owa ningii ei mendpił. Enim nga ningii, ei Seisen mendpił enim kin nei neng ninmin.” ");
INSERT INTO nii_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Lo ek ei ok tonu om, ek ei kapłi enim oł yi mił erngii, ‘Nim wumb ningił ei si kindkin nin kin wumb nim ningił ei si kindngii ku. Nga nim wumb gupu mong ei si kindkin nin kin, wumb nim gupu mong si kindngii ku!’ ");
INSERT INTO nii_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ba na enim kanip nind, wumb endi enim tumbii ni ermba wumb, ei enim eim to orung kindnerngii mon. Pe wu endi nim kon taki tum kin, nga ak tan orundung tumba ku. ");
INSERT INTO nii_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Pe wu endi nim kin kos erpi nim kumep sinerim kin, eim nim konduk simbii nim kin, nim torung muł ełim kon ei ouni ngunjii ku. ");
INSERT INTO nii_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Pe wumb endi eim nim kin konu mandi eł pambił nim kin, nga nim eim nga konu turii sipnjii. ");
INSERT INTO nii_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nga wu endi nim epi endi ngui nim kin, nim eim ngunjii. Wu endi nim epi endi ngan, nga ekii se nim ngumbii nim kin, nim wu ei kin buł ngunenjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Enim lo ek ei ok tor om piinjing ek, ei yi mił, ‘Wumb nii endi nim kin mandi mułmba wumb ei noman ngunjii. Nga nim nge opu orung wumb ei nim eim kin kis piikin noman ngunenjii mon!’ ");
INSERT INTO nii_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ba na enim kanip nind, enim opu orung wumb noman ngok, nga opu orung wumb enim tumbii ni ermba wumb ei paki tok Gos kin prei erik, opu orung wumb paki tungii. ");
INSERT INTO nii_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yi mił enjing kin, enim Gos epin konu ełe mołum ei enim Ernjing mił mułang kin, enim eim kingam noł mił wumb eipi kin andan tangin keningii ei enim. Gos eim eni erpi kindang opu wumb kis ka mołmun konu ełe eni pei topu tiłang enim. Nga Gos eim konu kumb erpi kindang opu wumb kis ka mołmun konu, ełe eim konu kumb kindang onum ku. ");
INSERT INTO nii_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Enim wumb noman ngołmun wumb ei kin noman ngunjing kin enim epi sinerngii mon. Pe wumb ku takis siłmin wumb ei oł yi ełmin ku. Ba enim nga oł kun ka wii pei erngii. ");
INSERT INTO nii_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nga enim nge engnjing noł kin ek ka nik enim nipe epi ka wii enjing? Pe wumb torung ngenj eipi wumb ei oł yi ełmin ku. ");
INSERT INTO nii_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yi pałim ei piik en enim oł kun ka wii erik mułngii mił, enim Ernjing Gos tonu epin konu kun ka wii mendpił mołum mił yi mułngii.” ");
INSERT INTO nii_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Enim pii kun erngii enim oł ka endi, eramin wumb eipi ei sin keningii nik yi enerngii mon. Pe enim oł yi enjing kin, enim Ernjing Gos tonu epin mołum ei, enim kumep epi ka endi ngunermba. ");
INSERT INTO nii_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ninim wumb epi sinerang wii mołmun wumb, ei paki topu epi ngumbii ni piinjii, ei nim wumb eipi kanik wii top ngumbii ni yi enjii ei mon. Ei yi mił, ek kend wumb men ngii nirik ni andłam owundu orung ełe angk prei erik wumb kanik kin, ‘Sin embe ambił tonu kindngii,’ nik ełmin mił yi enerngii. Yi ełmin ei Gos kin epi ka endi sinerngii mon! Na enim kanip nind, wumb ei en enim epi sinjing poru nim, Gos nga epi endi ngunermba mon. ");
INSERT INTO nii_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pe ninim wumb epi sinermba wumb ei epi ngumbii ni piinjii, ei yi mił. Nim angił taring orung nimbił oł enjii ei, nim angił tundung orung piinermba mon. Ei pułe yi mił. Nim wumb epi sinermba wumb ei koi erkin epi ngunjii ei wumb kinerngii. ");
INSERT INTO nii_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yi mił, ninim kongun kaimb sikin enjii mił yi koi er pimba. Nga nim Arnim tonu epin mołum ei nim nge epi koi er pimba, ei eim kanpi nim kin ngopu orung kindmba.” ");
INSERT INTO nii_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Enim kunum endi prei erngii, ei wumb ek kend tok ełmin mił yi enerngii mon. Ek kend tok ełmin ei andłam eł ni men ngii kumb eł angk prei kinan erik pengin kin wumb en enim keningii ni piik ełmin oł ei nge enerngii. Na ek keimi ni enim ngond, wumb ombu nge kumep endi ei sinjing poru ninim. ");
INSERT INTO nii_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pe kunum ełe ninim prei enjii pimba, ei nim pukun ngii nirik pukun, ondu ngokun, koi er prei enjii. Ei ninim Arnim Gos epin konu epi koi ełe mołum ei kaninim. Nga eim epi pei koi er sałiłim ei kaniłim, eim nim ngumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Enim prei erngii, ei torung ngenj wumb ek wii pei nik kinan kind pałmin mił enerngii. Ngenj wumb yi piinmin, ‘Nimbił erang sin ek pei nemin, Gos piimba,’ nim piik yi ełmin. ");
INSERT INTO nii_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Enim wumb enmin oł ei ekii sinerngii. Ernjing Gos enim epi simin ni piimin ei Gos eim piinim. Enim eim kin kii sinerngii kunum ba eim ok piiłim. ");
INSERT INTO nii_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Enim prei yi mił erngii: ‘Sin Erinjpin Gos. Nim tonu epin mołun. Nim embe ambił tonu mendpił kindmin ei ka wii. Gos ninim nge sin tep er mołun dinga sin kin omba. ");
INSERT INTO nii_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ninim nge noman ełe tonu epin ekii sinmin mił yi ku sin ya mei eł ekii sinmin. ");
INSERT INTO nii_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pe sin kuni kunum kunum ełe kapłi ngon. ");
INSERT INTO nii_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nim sin oł kis enjpin ei kil ngokun si kindnjii. Ei mił sin yi ku wumb sin kin oł kis enjing, ei sin kil ngo si kindmin ku. ");
INSERT INTO nii_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nim sin kin epi oł embin tui endi tonu omba kunum, nim sin kin wakin to si kindnenjii mon. Ba wu er kis ełim wu, ei sin kin omba nim sin paki tokun, tep ka er mułii.’ ");
INSERT INTO nii_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Piimin. Enim wumb endi enim kin oł kis ermba ei nik kun enjing kin, enim Ernjing Gos tonu epin mołum, ei nim oł kis kil ngopu si kindmba ku. ");
INSERT INTO nii_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ba enim wumb eipi oł kis ei nik kun enenjing kin, enim oł kis erngii Gos enim oł kis kil ngopu si kindnermba ku.” ");
INSERT INTO nii_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Pe enim kuni nunarik mowii piingii. Nimbił erang Gos eim enim kin noman ka piimba. Wumb ek kend wumb, en enim kumb dinga puk enmin. Nimbił erang wumb enim keningii ei oł yi enjing kin, wumb yi piingii wu ombu kuni mowii pek onjung ni kengii. Na ek keimi nip enim ngond, wumb epi ekii se singii kumep epi ei pe si poru ninmin. ");
INSERT INTO nii_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ba nim kuni mowii piin kin, noł was, kumb ningił eł erkin, kopung peng eł kalkin, yi erkin endnjii. ");
INSERT INTO nii_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Yi mił en onjii ei, wumb nim kuni mowii pekin on ni yi kinerngii. Ba Gos eim epin konu mołum ei endeim mendpił eim epi koi er sałim, epi ei piiłim nga kaniłim ku ei kanpi kin nim kumep epi nga ngopu orung kindmba.” ");
INSERT INTO nii_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Enim epi ka wii kan apirik ya mei ełe kułou tunerngii. Mei ełe tumb jingamb ok epi ombu er kis erngii, nga waning wu opu waning simba ku. ");
INSERT INTO nii_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ba enim oł kun ka wii ełmin oł, ei nge Gos eim enim kin ka piimba ei tumb jingamb ni waning erngii wumb ni ei epin konu eł tuk puk er kis monduk enerngii mon! Nga waning wu pupu waning sipi ermba andłam sinałim mon ku. ");
INSERT INTO nii_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Yi mił erang, en enim noman eł epi ka wii simba konu eł enim nge noman ei ełe simba ku.” ");
INSERT INTO nii_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ningił ei sinim ngenj ełe nge dup alam mił. Pe nim ningił ei ka pim kin, nim noman tuk kun ka sim kin, oł kun ka enjii ku. ");
INSERT INTO nii_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ba ninim ningił kis mułum kin, ninim noman tuk ei pei emii owundu pimba. Nimbił erang oł kis ełmin oł ei nim kin pei sepi kin, nim noman tuk ei emii er pałim,” pa Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Wu endi eim kongun wu owundu tał kin enermba mon! Nga wu ei owundu tał kin kongun erim kin, eim owundu endi kin ka piipi kin nga endi kin kis piipi ermba. Nga owundu endi kin noman ngopu endi kin noman ngunarpi ermba ei mon. Yi mił sinim noman tał sepin Gos kongun erpin nga ku kongun erpin kunum ende enermin mon! ");
INSERT INTO nii_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Yi piik na enim kanip nind. Enim konj molk, noman embin to yi piinerei! Nga kuni nipe numun eł yi piinerngii mon. Sinim nge ngenj ełe epi nipe tełmin? Sinim konj mołmun ei epi owundu ba kuni ei epi owundu mon. Yi ku sin nge ngenj ei epi owundu ba alap ei epi owundu mon. ");
INSERT INTO nii_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Enim kei kaninmin ei tonu bur ni andinmin: ei kuni emb tilanmin, nga kuni tu wuk, ngii konu sinałmin. Ba enim Ernjing Gos tonu epin ei kuni ngołum. Enim kei ombu to mani kindik enim wumb mołmun. Gos enim kuni ni alap ngumba ku. ");
INSERT INTO nii_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Enim mołmun konu tuk eł, wu nii endi eim epi endi noman erang piim kin, eim kunum kinan konj mułmbii ni piimba, ei kapłi enanim. ");
INSERT INTO nii_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pe nimbił erang enim ngenj ełe konduk ni ei noman to piinmin? Enim andaring plawa kuk nin ond kuk tonu onum, ei er onum mił nenj ei keningii. Plawa kuk ei kongun dinga enałim, nga konduk ni epi endi enałmin ku. ");
INSERT INTO nii_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ba na enim kanip nind, ok king Solomon eim konduk ka wii kindrim, ei ya ond kuk ka wii mił ei kindnerim mon. ");
INSERT INTO nii_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Keimi, pe kui engimb nin epi ei en enim Gos konduk mił ei ka wii akip ngang kindim. Topuł mer dup kałiłmin konu eł kindang dup numba. Pe nga enim konduk ni epi ei kindnermba ni piinmin min? Nimbił erang Gos epi ei enim kui pei ngunermba nik pii gii ninanmin? ");
INSERT INTO nii_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ei piik enim noman embin yi piinerngii. ‘Sinim kuni nipe kuni endi numun da, sinim noł nik piinerngii mon. Nipe noł endi numun da ni piinerngii mon. Ei sinim konduk nipe konduk endi kindmin da ni piinerngii mon.’ ");
INSERT INTO nii_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mon, oł ombu wumb torung ngenj wumb ei, kongun yi enmin. Ba enim nge Ernjing Gos tonu epin mołum ei piiłim. Enim epi ombu nge pei ngang singii ku. ");
INSERT INTO nii_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ba enim oł kun ka pałim mił ka erik, Gos sinim tep er mołum ni piik ekii sik er mułangin kin kapłi Gos enim epi eipi ombu ngumba ku. ");
INSERT INTO nii_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yi pałim ei piik, topuł ermin epi ni noman embin yi piinerngii mon. Topuł wumb endi ei eim ermbii ni piinim epi ei enim. Nga oł embin tui endi topuł tonu omba ei, enim noman to piinerngii mon.” ");
INSERT INTO nii_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Enim wumb kanik ek ngok erik kos piik ełmin mił yi ninerngii. Enenjing kin, Gos enim kin kos piinenmba ku. ");
INSERT INTO nii_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pe enim wumb kin erngii oł ei, Gos enim kin ermba. Nga epi wumb ngołmun mił yi ku Gos enim ngumba. ");
INSERT INTO nii_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nimbił erang nim angnim epi moł aninga ningił eł pałim ei kankin nin, ba ninim ningił eł ond owundu mił pałim? Ei ok si kindkin, ekii se eim nge ningił eł epi moł pimba ei si kindnjii. ");
INSERT INTO nii_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ond owundu mił ninim ningił pałim, ba ninim angnim kankin yi nin? “Engnan, nim ningił eł epi moł pałim, ei si kindmbii nin?” Ei pułe yi mił, sinim oł kis enmin oł ei epi moł mił, sinim nge noman tuk eł pałim ei si kindinmin. ");
INSERT INTO nii_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nim ek kend nge wu. Ninim ok ningił eł ond owundu mił si tor kindkin, ningił ka seng, kan kun erkin, nga angnim epi moł ningił eł pałim, ei si kindnjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Enim Gos ek ka epi ka wii mił, ei nge wumb kis owu mił kapłi ngunerngii mon! Nga biis ni epi ka wii ei sipik, wumb Gos kin ek buł ngok ełmin wumb, ei kung mił ngunerngii mon ku. Mon peng, wumb kung mił, biis ka wii ei en enim simb eł kamb mani kindik, nga wumb owu mił ok enim kin erik kis erngii ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Enim Gos kin prei er ngungii, “Enim Gos kii sik enmin ei epi enim ngumba. Enim epi kuruk endngii, ni keningii. Enim Gos ngii ondu eł to teki teki nengin, aki tumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","“Wumb pei Gos kin prei ełmin, ei epi siłmin. Epi sipmin nik kurułmun, ei kaniłmin. Nga Gos ngii ondu eł to teki teki nimba wu, ei Gos eim ngii aki tołum ku. ");
INSERT INTO nii_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Pe wu endi kingam aka numbii nimba, eim arim kom ku endi sipi ngumba min? Ei mon. ");
INSERT INTO nii_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nga kingam omu numbii nimba, eim arim ka wembii sipi kingam ngumba min? Ei mon ku. ");
INSERT INTO nii_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yi mił, enim wumb kis ei kingenjing noł epi ka noman ka pend kingenjing ngołmun. Pe sinim piimin, Erinjpin Gos tonu epin mołum ei sinim prei erpin kii sipin ninjpin kin kapłi epi ka ei ngumba ku. ");
INSERT INTO nii_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Wumb enim kin oł yi mił erngii nik piinmin oł ei, en enim wumb eipi kin oł yi erngii ku. Ek ei lo ek, nga Gos nge oł ekii se ermba piik niłmin wumb ek ei ende pałim.” ");
INSERT INTO nii_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Enim epin konu andłam kembis ełe pungii. Nimbił erang andłam puk konu kis dup konu eł pungii andłam ei owundu sałim. Andłam ełe wu amb ombu pei andłam ełe andik mołmun. ");
INSERT INTO nii_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ba kunum kunum konj ka mułngii konu, ei andłam kembis wii. Nga andłam puk konu ka eł pungii, ei kongun dinga erngii. Erik kin, wu amb endeim endeim ni andłam ei kan singii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Ek ni tor kindiłmin ek kend wumb ongii, ei kan kun er mułngii. Ek kend wumb siipsiip ngenj mił ei torung kun ka wii mił kindik ongii. Ba noman tukrung ei owu simbii mił enim kin onmun. Ok enim pii gii ei to kis erngii nge ongii. ");
INSERT INTO nii_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nga enim molk ek ni tor kindiłmin kend kongun er ongii, ei enim wumb ei nge oł kongun erik keningii. Nimbił erang wumb noł wain mong ond angił ełe gał mołułum ei siłmin; min wumb ond pik mong sik, engimb min epi gał mołułum ei sik yi ełmin min? Mon, ei sin kapłi enałmin. ");
INSERT INTO nii_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Yi mił ku, ond ka mong ka tołum ku. Nga ond kis ei mong kis tołum ku. ");
INSERT INTO nii_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ond ka ei mong kis tunałiłmin mon ku. ");
INSERT INTO nii_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pe nga ond endi mong ka tunałim, ei kołmung tok, sik dup kałiłmin. ");
INSERT INTO nii_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ek ei yi mił, enim ek ni tor kindiłmin kend kongun ełmin wumb ei, enim keningii. Kanik, ek ei pułe piingii pa nipi ngum.” ");
INSERT INTO nii_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wumb kombur aninga na kin ‘Owundu, Owundu,’ nik, ek dinga nik erngii wumb, Gos sinim tep er mołum konu eł tuk pungii ba wu endi nam Ernan tonu epin mołum ni piipi, eim noman eł ekii sipi endmba wu, ei eim Gos kin Owundu Owundu nimba wu, ei eim Gos kin epin konu tep er mołum konu eł kapłi tuk ba. ");
INSERT INTO nii_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pe kunum owundu tonu omba kunum, ei wu amb pei yi ningii, ‘Owundu, Owundu! Na nim nge embe eł oł ekii se ermba mił piik niłmin mił ninj ningii. Nim embe eł sin gui kis to si kindinjpin. Nim nge embe eł sin jep oł kanim kanim enjpin,’ pa ningii. ");
INSERT INTO nii_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kunum ełe, na ek nip orung kindip yi mił nimbii, ‘Enim na kinał. Enim oł kis wumb mendpił, na kin tuk onerei!’ nimbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Pe wu endi na nind ek ei piipi, ekii simba wu, ei wu endi yi mił eim noman ka peng, eim ngii tonu kom ku peł takiłim. ");
INSERT INTO nii_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Pe konu kumb topu mani orum, konu pop owundu topu onum, noł owundu topu ełim ei ngii mani punałim. Nimbił erang, wu eim ngii ei kom ku peł ełe tonu takiłim ei dinga pupu ngii eim engim. ");
INSERT INTO nii_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Wu endi na ek ei piipi, ekii sinerim wu, ei eim yi mił wu ende noman pinałim wu mołum ei mił. Pinerang, eim ngii tonu noł ku kilta takiłim. ");
INSERT INTO nii_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Konu kumb owundu topu, mani orum, konu pop owundu topu orum, noł owundu to orum kunum ei ngii ei eskił tołum. Ei keimi, ngii mani pupu er kis ełim.” ");
INSERT INTO nii_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jiisas ek ei nipi poru neng, wumb tiłap owundu ok mulnjung ni, eim ek ei wumb piik mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Nimbił erang, Jiisas eim ek nim ek ei wumb noman peng niłmin lo ek ei nge ninerim. Jiisas eim wu endi noman dinga, pii gii nik niłmin ek mił yi neng, wumb mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jiisas eim komung eł si kindpi mani wang, wumb pei eim pum konu ekii sik punjung. ");
INSERT INTO nii_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Pangin, ngenj kinj bombułum tum wu endi opu, Jiisas simb eł ming gopsing pii połpu, kan mani kanpi yi nim, “Owundu, nim na er ka ermbii ni piin kin, kapłi enjii.” ");
INSERT INTO nii_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jiisas eim angił wu ei ambiłpi ek yi nim, “Na yi mił ermbii, nim ngenj ka simba.” Neng, wu ei kinj bombułum tum ni poru neng, wii ka mułum. ");
INSERT INTO nii_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Pe Jiisas ek yi nim, “Oł ei, nim pukun wumb endi kankin ninenjii mon. Nim ngenj ei sipkin, Gos kin kułmał kałiłim wu mołum konu ełe andan tan, ok Moses nirim oł ei erkił, Gos kin kułmał kiłan, wumb nim keningii ni, nim ening pim ei poru nim ni keningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jiisas pupu Kapaniyam konu tor pang, Rom wu endi opu wumb 100 pei tep ełim wu, ei opu, kii dinga sipi Jiisas ngum. ");
INSERT INTO nii_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Owundu, na nge kongun wu ei ening topu, ngenj dinga pinerang, peł ełe ngii konu pałim, eim ngenj kumbii owundu ei piipi pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Neng, Jiisas yi nim, “Na pup, eim er ka ermbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ba opu ełmin tep ełim wu, ei eim yi nim, “Owundu, na wu ka mon. Nim na ngii konu ełe onenjii mon! Nim ek wii nen, nam nge kongun wu ka mułmba. ");
INSERT INTO nii_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nam yi ku, wu num na tep ełim wu ei na tep erang, na nam nge opu wu ombu tep erip, endi ‘Pui!’ nemb, pułum. Nga endi, ‘Ya wei!’ nemb, ołmun. Nga nam kongun wu kongun ei ‘Erii!’ nemb, kongun ełim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jiisas wu ei ek piipi puku sipi erim. Erang, ek nipi, wumb eim kin ekii se onjung wumb ei ngum, “Na Esrel wumb konu ełe wu endi pii gii wu, yi nge endi kan sinenj mon! ");
INSERT INTO nii_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Na enim kanip nind, wumb konu eipi wumb orung eni tonu ołum konu, ni eni mani punum konu, wumb ei ok, Eiparam ni Aisik ni Jeikop ni kuni peł endi nok mułangin, Gos sinim tep er mołum konu ełe no mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ba wumb Gos mołpu tep erang tuk mołmun Jura wumb, ei topu tor kindpi, emii konu epi endi eł kindmba. Ei en enim ke nik, gupu mong kongk, kaimb er mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Pe Jiisas ek nipi opu ełmin tep ełim wu ei ngopu yi nim, “Ninim pii gii peng eramb ni pui mił yi ermba?” pa nim. Pe konu eni ełe Jiisas opu ełmin tep ełim wu kin ek tengim, kunum eł mendpił, eim nge kongun wu ei ening poru neng, ka mułum. ");
INSERT INTO nii_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jiisas pupu, Piisa ngii konu eł nirik pupu kenim ni Piisa ambim nge mam ei ening tang, peł ełe or pim. ");
INSERT INTO nii_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pe Jiisas eim angił embłang, ening ni si kindpi pum. Pang, amb ei eim Jiisas kin wumb ngungii kuni nge er kun erpi onguł erpi ngurum. ");
INSERT INTO nii_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Pe konu pou neng, wumb gui kis mułum wumb pei tu wunjung. Jiisas ek nipi gui kis to kindpi, wumb ening pim wumb, pei er ka erim. ");
INSERT INTO nii_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yi mił erang kin, Gos ok ek ni tor kindiłim wu Aisaiya gupu ełe ni tor kindrim ek ei keimi pim. Ek ei yi mił nirim, “Eim sinim nge ening pim pei si kindpi, sinim ening kanim kanim ei eim kin sim.” ");
INSERT INTO nii_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jiisas kenim ni wumb tiłap owundu eim mułum konu orung orung mułangin kanpi mułum. Eim ek yi nim, “Sinim noł gopu orundung pamin!” nim. ");
INSERT INTO nii_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Pe lo ek kengpi tołum wu endi opu yi nim, “Ek emb tołum wu, nim konu orung orung min konu endi punjii konu, ei na nim kin ekii sip bii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jiisas ek yi nipi orung kindim, “Owu simbii mei tukpu ełe pałiłmin. Nga kei andinmin ngii angłim. Ba Gos wu kingam ya mani mei ełe kindang, wu ngenj sipi mołum eim nge peng sipi sałim konu endi sinałim. Yi mił, wu endi na kin ekii simba wu, ei kongun dinga pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nga eim nge ekii siłmin wu endi ek nipi kii sim, “Owundu, na nim kin ekii simbii ba kumb se kapłi na kindan pup, ernan tukpu tumbii min?” ");
INSERT INTO nii_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ba Jiisas ek nipi yi nim, “Mon, wumb Gos ek piinanim wumb, kułii mił wumb, ei wumb kułii er kun erngii ba nim na ond konu ekii se oi!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jiisas noł kanu ełe tonu pang, eim nge ekii se andiłmin wumb ekii sengin ouni punjung. ");
INSERT INTO nii_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Konu pop owundu topu, noł gopu tuk pinin nipi noł kanu tuk opu, noł kanu to ak tumba erim, ba Jiisas eim or pim. ");
INSERT INTO nii_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eim nge ekii se andiłmin wumb eim to konj kindnjing. Kindik, ek yi ninjing, “Owundu, nim sin paki to! Sin to kundmba enim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jiisas eim ek dinga nipi eim nge ekii se andiłmin wu ombu ngum, “Nimbił erang enim tungu enmin? Enim pii gii kembis ninmin.” Pe eim angpi, eim konu pop kin noł ei ek neng, nga ka wii mendpił sim. ");
INSERT INTO nii_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jiisas eim nge ekii se andiłmin wumb, mund mong erik yi ninjing, “Ei wu kanim eipi endi mołum. Eim ek neng kin, konu pop topu, noł pinin ni erim, ei nga eim ek ekii sik enmin,” ni yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jiisas noł gopu orundung tor pupu, Garariin wumb konu ełe pum. Pe gui kis tuk mułum wu tał, eim kin tor onjnguł, ei wumb guimeng eł molkuł onjnguł. Wu tał wu simbii mił. Wumb konu ełe andłam endnałmin mon. ");
INSERT INTO nii_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Pe wu tał wii dinga tokuł yi ninjngił, “Gos kingam, nim sił kin nimbił oł enjii on? Kunum ei epi poru nimba ei poru ninerang okun sił ngenj kumbii ngunjii nge on min?” ");
INSERT INTO nii_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pe kung konu ełe pei orundung ei nok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gui kis ombu ek dinga nik yi ninjing, “Nim sin tor kindnjii pim kin, sin kindan kung mołmun konu ełe tuk bin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Pe Jiisas ek yi nipi ngum, “Enim pei!” Pe gui kis wu tał si kindik puk, kung pei mulnjung konu tuk pangin, kung ombu pei sikir puk, konu tumbułam noł gopu mołum ełe mani puk, noł nok kolk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kung es to mulnjung wumb, oł ei kanik tungu puk, konu owundu wumb mulnjung konu kanik, wumb ei ek yi ninjing. Wu tał gui kis er kindim oł, ei pei nik wumb ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wumb konu owundu ełe ek ei piik ok Jiisas kanik yi ninjing, “Sin mei ełe mulenjii; konu eipi pui!” nik ek dinga yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jiisas eim noł kanu eł nga tonu pupu, noł gopu ełe nga orung pupu eim konu kun tor pum. ");
INSERT INTO nii_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wumb wu endi ening pim wu ei, tu wunjung. Wu ei eim ngenj kołpu poru neng, embił dinga pinerang, eim peł ełe or pim. Pe Jiisas kenim ni wumb ei kin pii gii ninjing. Kanpi, ening pim wu kin ek yi nim, “Na nim oł kis ei si kindind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pe lo ek piiłmin wu kombur, en enim noman ełe yi piinjing, ‘Wu ei Gos kin ek ambiltim,’ ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jiisas wu kei en enim noman yi piyangin, kanpi yi nim, “Nimbił erang enim noman tuk oł kis yi piinmin? ");
INSERT INTO nii_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nipe ek ei oi mił to peng nimbii? Pe na nim oł kis ei kil ngond nimbii ei kapłi min? Nga nim peł ei si mengkin pui yi nimbii ei kapłi min? Ek endi na nim oł kis kil ngond ei nimbii. ");
INSERT INTO nii_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ba na end ei enim kanik piingii nip end. Na tonu epin si kindip, mei mani op, wu kingam tels ei na noman dinga peng, wumb oł kis ei kil ngop ek nip ya wu embił dinga pinernang ei kanip nind. ‘Nim angkin, ninim peł ond sikin, ninim ngii konu pui!’ nind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jiisas ek yi neng kin, wu ei eim peł sipi, eim ngii konu sipim. ");
INSERT INTO nii_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nga wu amb ni wumb pei oł ei kanik, mund mong erik, yi piinjing, Gos wu yi nge noman dinga, ni noman ka, wu ei kin ngonum nik, yi erang Gos embe ambił tonu kindnjing. ");
INSERT INTO nii_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jiisas andpi pupu kenim ni wu endi mułum ei ku takis siłim ngii ełe mułum. Wu ei embe Masyu. Jiisas wu ei kanpi ek yi nim, “Na ond konu oi!” Nipi yi neng, wu ni angpi, Jiisas pum konu ekii se pum. ");
INSERT INTO nii_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jiisas Masyu eim ngii konu ełe mołpu kuni num. Wumb pei ku takis siłmin wumb ni oł kis ełmin ei kin mołpu kuni ende num. Eim nge ekii siłmin wu ombu ouni nunjung. ");
INSERT INTO nii_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Lo ek piiłmin wumb, ei Jiisas wumb kis kin kuni nang kanik, eim nge ekii sik ełmin wu ombu kanik yi ninjing, “Nimbił erang enim nge ek emb top ngołum wu ei wumb kis ni ku takis siłmin wumb kis ni ombu kin kuni nonum?” ");
INSERT INTO nii_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jiisas eim ek ei piipi yi nim, “Wumb ening tunałim wumb ei, ening ngii ełe punałmin mon. Ening pałiłim wumb ei mendpił pułmun. ");
INSERT INTO nii_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Enim puk Gos nge ek ka ełe kanik piingii, ‘Ka kułmał kałiłmin epi ei na noman pinałim. Na noman kaimb siłmin ei na noman pałim.’ Na wumb ka mulnjung ei kin, paki tumbii onenj. Ba wumb kis mulnjung ni oł kis enjing wumb ei, paki tamb, noman ak tungii nip onj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jon wumb noł pendłim wu, ei eim nge ekii sik andiłmin wumb Jiisas kin ok, ek yi kii sik ninjing. “Nimbił erang sin kin lo ek ekii siłmin wumb kin kuni mowii ełmin, ba nim nge wu ombu kuni mowii enałmin, ei nimbił erang ełmin?” ");
INSERT INTO nii_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jiisas ek ekin nipi orung kindpi yi nim, “Pe wu endi eim simba ermba kunum ełe, eim nge wumb puł, eim paki tołmun wumb kunum ełe kapłi amb simba wu ei eim wumb kin kuni no mułmba kunum ei eim nge wumb kis piik mułngii min? Ei mon. Ba ekii se amb simba wu ei wumb kis eim konu eipi si pangin, eim nge wumb ei kapłi kuni mowii piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Wu endi eim konduk endi piltan top kis ermba, konduk ełe alap konj endi sipi, mui tumba mił mon? Pe wu endi yi erim kin, alap konj ei pepi, konduk topu, kis owundu nga ermba. ");
INSERT INTO nii_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jura wumb kung meme ngenj kulk, noł wain tuk kindiłmin. Ei kung meme ngenj konj ełe noł wain konj kindiłmin, epi tał ka mułangił. Nga noł wain ok nge ei kung meme ngenj ok nge ełe kindiłmin. Nga noł wain konj ei sipik, kung meme ngenj ok nge ełe kindiłmin ei noł tok nipi noł wain tor pang, kung ngenj kis mołułum ku. Yi mił na ek konj ei Jura lo ek ok nge ei kin ende punermba.” ");
INSERT INTO nii_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jiisas eim ek ei nipi mułang, Jura wu num endi opu, eim simb ełe ming gopsing pii połpu ek yi nim, “Na ambłam pe mendpił koltum, nim okun, eim ngenj ełe embłan, nga konj mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pe Jiisas wu ei kin pum. Pang, eim nge ekii sik andiłmin wu ombu ni punjung. ");
INSERT INTO nii_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Puk, amb endi mułum amb, ei eim kunum kunum eim miiyem ei o pupu minj mułang, kung ngii engki nga tał o purum. Amb ei eim opu, Jiisas buł morung ełe eim opu Jiisas konduk embiłim. ");
INSERT INTO nii_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Eim nge noman ełe yi piipi om. “Na pup, Jiisas konduk minjin tamb, na ening ei kapłi wii simba, ka mułmbii,” ni piim. ");
INSERT INTO nii_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ba Jiisas eim piipi ak topu kanpi yi nim, “Ambił, nim na kin pii gii nin, ełe nim ei ka seng, wii mulnjii,” pa nim. Pe kunum ełe mendpił, amb ei ka mułum. ");
INSERT INTO nii_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jiisas opu, Jura wu num ngii ełe opu kenim ni mingał pop tok golang nik wumb ke dinga wii nik mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jiisas opu ek dinga nipi yi nim, “Enim kunerei! Ambił ei kulerim ba or pałim,” pa nim. Neng, wumb eim kanik tokuł enjing. ");
INSERT INTO nii_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pe wumb to anda kind poru nik, Jiisas eim nirik pupu, ambił ei angił ambiłpi, er konj sim. ");
INSERT INTO nii_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jiisas yi erim, ek ei wumb konu orung orung pei nik pangin, wumb pei piinjing. ");
INSERT INTO nii_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jiisas konu ełe si kindpi, andłam ełe andpi pang, ningił tumbun mułum wu tał okuł wii dinga tokuł yi ninjngił, “Nim Deipis kingam, nim sił kin kaimb sinjii.” ");
INSERT INTO nii_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pe Jiisas eim ngii ełe nirik pang, wu tał eim ekii sikił onjnguł. Wangił, Jiisas ek yi nim, “Ełip pii gii na kin piinjngił na oł ei ermbii.” Wu tał yi ninjngił, “Owundu, keimi sił pii gii ninmbił.” ");
INSERT INTO nii_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pe Jiisas eim wu tał ningił ełe ambiłpi yi nim, “Ełip pii gii pim mił, kapłi oł yi ku ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Wu tał ningił ka mułang, Jiisas ek dinga nipi wu tał ngum. Ngopu yi nim, “Na ełip kin oł ei, wumb endi kangił ek ninereł mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ba wu tał eł ełip anda pukuł, wumb konu orung orung pei Jiisas kongun erim oł ei kankił nikił punjnguł. ");
INSERT INTO nii_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Andłam ełe bił ni erangił, nga wumb wu endi gui kis tuk mułang, eim ek tingnerim wu ei Jiisas kin tu wunjung. ");
INSERT INTO nii_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Pe Jiisas eim gui kis ei to kindpi yi erang, gupu ek tingnerim wu ni ek tangpi erim. Yi erang, wumb pei mund mong enjing yi ninjing. “Ok Esrel konu oł yi endi tonu onerim, sin kinerpin,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ba lo ek ekii siłmin wumb yi ninjing, “Gui kis nge wu num eim kin mołpu, eim kin noman dinga ngopu, eim gui tor kindnim,” nik yi ninjing. (Ei ek keimi mon, Jiisas ek keimi ninim.) ");
INSERT INTO nii_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jiisas konu owundu ni konu orung orung pei andpi, wumb men ngii ełe nirik pupu, Gos ek ka nipi wumb ngopu, Gos sinim tep er mułum mił nipi ngopu, wumb ngenj ełe ening kanim kanim pim, ei er ka erpi yi erim. ");
INSERT INTO nii_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jiisas eim wumb tiłap owundu ei kanpi kaimb sim. Nimbił erang wumb noman embin piik kin, wu endi paki tumba nge kuruk endnjing yi er mulnjung. Ei kung siipsiip tep ełim wu mulałim mił, yi er mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jiisas oł ei kanpi, ek nipi eim nge ekii sik andiłmin wu ombu ngum. “Kuni wiis poł topu pei mołum, ba tengingii kongun wumb mon pałim. Ei yi mił, wumb Gos ek ka piingii wumb ei pei mołmun ba ek ni tor kindik wumb ei ngungii wumb mon pałim. ");
INSERT INTO nii_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yi piik kin enim kongun ei nge arim kin prei erangin, eim kongun wu kombur kindmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jiisas eim nge ekii sik andiłmin wu engki nga tał, wii tang wangin, noman dinga nipi wu ombu ngum. Noman ei ni ngopu gui kis to kindik, ening ni ngenj ełe oł kanim kanim ermba ei to kindngii nge nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Eim nge ek ka endngii nge engki nga tał, wu ombu embe yi mił: kumna Saimon embe endi Piisa, eim angim Endru, nga Jeims ei eim Sependii kingam ni eim angim Jon. ");
INSERT INTO nii_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip ni Barsolomyu ni Tomas ni Masyu ku takis ok siłim wu, ni Jeims arim Sariyas. ");
INSERT INTO nii_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon Selos ni Juras wu ei Eskerios, eim Jiisas opu orung wumb onjung konu Jiisas mołum ei nipi andan tum wu. ");
INSERT INTO nii_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jiisas eim nge wu engki nga tał, ek dinga nipi kindang punjung. Jiisas ek yi nim, “Enim wumb konu eipi punerngii, nga Sameriya konu owundu ełe tuk punerngii mon! ");
INSERT INTO nii_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Enim puk Esrel wumb, kung siipsiip mił am punjung ełe pungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Enim puk, wumb kanik, ek yi ningii: ‘Gos sinim tep er mołum kunum ei pei mandi omba enim,’ ningii. ");
INSERT INTO nii_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Enim puk, wumb ening pimba ei er ka erik, wumb kułngii, ei er konj sik, wumb gui kis mułmba ei tor kindik, wumb ngenj kinj bumbułum tonum wumb, ei erangin ka mułngii. Pe enim epi ei sinjing, ei epi endi ngok enjing. Yi mił nga wumb kin oł yi erngii, epi endi sinerngii mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Enim ku gol ni, ku silpa ni, ku kapa ni ombu endi pendik epi ombu sipnerngii mon,” nim. ");
INSERT INTO nii_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kon andłam pungii kon ni, konduk ni nim su ni dolu ni epi ei endi sipnerngii mon. Wu kongun ełim wu, ei kuni ngangin nołum, mił yi enim nungii. ");
INSERT INTO nii_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Enim puk konu kembis min owundu endi tor pungii, ei wumb kan kun erngii. Konu endi tor pangin wumb konu, ełe oł kun er mułngii. Ei enim wumb ei kin molk, puk, nga enim konu ei si kindik pungii. ");
INSERT INTO nii_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Pe enim wumb ngii endi ełe nirik punjung kin, wumb ngii puł wumb ei ek yi ningii, ‘Enim noman emin pengłi!’. ");
INSERT INTO nii_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wumb ngii ełe tuk pangin, ek ka nik enjing kin, “Enim nge noman emin ei wumb ombu kin ba. Ba wumb en enim ngii konu ełe, ‘Enim nirik wei!’ a ninarik enjing kin, enim noman emin ei wumb ei kin noman emin ei ngunerngii. ");
INSERT INTO nii_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nga wumb nii endi enim nge ek piinarik min enim tuk sinarik kin kapłi enim ngii konu ełe si kindik kunum ełe konu eipi pungii kunum ei enim simb ełe kułman si kindngii. ");
INSERT INTO nii_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na ek keimi nip enim ngond. Ekii se Gos kunum owundu kos owundu piimba kunum, ełe wumb mok tumba kunum ei Gos Sorom konu ni Gomora konu ełe eim kaimb simba. Ba nga konu eipi ełe wumb ei enim kin, ‘Weiyo,’ nik enenjing kin, Gos konu ełe wumb kaimb sinermba mon,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Piingii! Na enim kung siipsiip mił tuk owu simbii wumb mił mulnjung konu kindind. Ei piik enim ka wembii noman ka peng oł ei nge ekii singii. Nga kei Pułmu noman emin seng ełmin oł ei nge ekii singii. ");
INSERT INTO nii_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pe enim kan kun er mułngii! Wumb enim ambił gii nik, kos ngii sipik, en enim men ngii ełe enim kepii tok yi erngii. ");
INSERT INTO nii_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Erik, na nge ek ni na to mani kindngii nge, enim sipik king ni kumb ełe sipik gapman nik erngii. Ei nimbił erang enim ek nik en enim kin wumb tiłap eipi ngok yi enjing konu ełe. ");
INSERT INTO nii_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nga wumb enim kos ełe tonu tu wangin, enim yi piingii. ‘Sinim nimbił ermin? Sinim nipe ek nimin?’ ni piik mułngii. Kunum ełe mendpił, Gos enim ningii ek ei nipi enim ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Enim nge ek ninerngii, ba enim Ernjing Gos nge Gui Ka ei enim kin mołum ei ek nipi tor kindmba. ");
INSERT INTO nii_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Nga wu endi eim angim kos ełe tonu si pang to kundngii. Yi ku arim eim kingam kos ełe tonu si pang to kundngii. Nga kangił en enim, ernjing, menjing noł kin opu orung erik to kundngii ku. ");
INSERT INTO nii_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Wumb pei enim kin noman kis piingii. Ei nimbił erang na nge embe ei enim kin pimba, ba wu endi eim ambił gii nipi na kin pii gii dinga pupu mułum kin, ekii se kunum poru nimba kunum, wu ei Gos eim sipi orung simba, ei wu eim nge. ");
INSERT INTO nii_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pe nga wumb enim kin oł embin tui kis enjing kin, enim konu ei si kindik, tungu puk, konu owundu endi eipi pungii. Na enim kanip nind, enim kongun endi Esrel wumb konu owundu ełe kapłi poru nininang, kapłi na wu kingam tonu epin konu ełe si kindip, mani mei ei sikir tor ombii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Pe nga men kangił ei ek emb topu eim ngonum wu, ei to mani kindmba mił mon? Nga kongun kunum kunum wii minj ełim wu, ei eim nge wu owundu to mani kindmba mił mon? ");
INSERT INTO nii_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pe men kangił ei mołpu, ek emb topu ngumba wu ei mił kapłi, nga kongun wu ei eim wu owundu mił mułmba ei kapłi. Ngii ei arim embe Biyelsipul ei ek kend wu pim kin, wumb en enim ngii ende wumb embe kis mendpił singii. Ei yi mił, wumb na Biyelsipul nik embe singii.” ");
INSERT INTO nii_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Pe wumb enim tungii ei mund mong enerngii. Epi pei koi er sałim, ei Gos nga peni ełe tor kindmba. Epi pei kum top pałim ei ekii se wumb keningii. ");
INSERT INTO nii_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ek na enim ya emii peng nind ek, ei enim tinga eni kin nik wumb ngungii. Nga en enim kom ełe ek piinjing ek, ei ngii ełe tonu puk, ek nik wumb ngungii. ");
INSERT INTO nii_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Wumb nii endi enim ngenj ełe to kundngii, ei gał piinerngii. Ba ei enim noman tuk ei to kundnerngii mon. Ba enim Gos eim kin gał kulk mułngii. Nimbił erang Gos eim kapłi ngenj kin noman tuk kin ouni topu kondpu, dup konu ełe kindmba. ");
INSERT INTO nii_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wumb kei Winu kembis tał ku kundii ei nge endeim nga siłmin. Ba enim Ernjing Gos kei endeim endi boi nipi, mani mei ełe ba, ei eim piinim. ");
INSERT INTO nii_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Yi piik kin, enim noman embin to piinerngii mon! Enim kei Winu kembis ku ngok sinmin ei to mani kindinmin. Yi peng kin, Gos sin tep ka er mułmba. Enim peng enjin Gos eim gerpi, kanpi si kindpi mołum.” ");
INSERT INTO nii_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Wu endi na embe ełe nipi wumb pei ningił ełe nimba wu, ei eim embe na Ernan Gos ningił ełe nimbii. ");
INSERT INTO nii_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ba wu endi na embe ei, wumb ningił ełe koi erpi ni tor kindnerim kin, wu ei eim na Ernan Gos ningił ełe eim embe tonu epin konu ełe ni tor kindnermbii mon ku.” ");
INSERT INTO nii_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Enim piik, na op mei ełe opu enmin ei to mani kindip noman emin ngumbii nge onj, ni piinerngii mon! Ba na wumb mok top noman kanim eipi eipi ngumbii nge onj. ");
INSERT INTO nii_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na onj ei opu erngii nge onj, wu endi eim arim kin opu orung erang, eim ambłam ei eim mam kin opu erang, nga amb ei eim wam nge mam opu orung erngii nge onj. Ei yi mił wumb kombur na kin pii gii ninerngii. Nga wumb kombur na kin pii gii ninmin. ");
INSERT INTO nii_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wu endi eim na kin pii gii nimba wu, ei kin ngii ende wumb ei en enim eim kin opu, orung erik mułngii ku. ");
INSERT INTO nii_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Wumb en enim ernjing, menjing noł noman ngok, enmin oł ei, ba na kin noman ngunanmin. Wumb ei na nge wumb puł mon. Nga wumb en enim kingenjing, embilenjing noman ngonmun, oł ei ba na kin noman ngonanmin. Wumb ei na wumb puł mił mulerngii mon! ");
INSERT INTO nii_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wu endi eim ond peri ei ko wupu na kin ekii sinerim kin, wu ei na wu puł mił kapłi pinermba mon. ");
INSERT INTO nii_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Wu endi eim nam noman konj kan simbii ni piipi endmba wu, ei eim noman konj ei am ba. Wu endi na kin piipi, eim nge noman konj si kindmba wu, ei eim noman konj nga orung simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Wu nii endi enim eim ngii ełe nirik sim kin, eim na eim ngii ełe nirik sim ku. Wu nii endi na eim ngii ełe nirik sim kin wu endi ei Gos na kindang onj, ei eim ngii ełe nirik simba ku. ");
INSERT INTO nii_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wu nii endi oł ekii se ermba piipi niłim wu, ei paki topu eim ngii konu sipipi erim kin, eim oł ekii se ermba piipi niłim wu nge kumep ka simba mił yi ku simba. Pe wu nii endi eim kinang, wu kun ka endi wang, eim sipipi, kuni ngopu ełim wu, ei eim wu kun ka, ei eim kumep ka eim ngumba. ");
INSERT INTO nii_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pe wu nii endi eim wumb ei kanpi, eim noł jii ni kułpu tu wupu, nam nge ekii sik andiłmin wu ombu ngopu ermba, wu ei na ek keimi nip enim ngond. Wu ei kumep simba, epi ei am punermba mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jiisas eim nge ekii sik andiłmin wu engki nga tał wu, ombu ek nipi kongun ełe kindpi, eim konu ełe si kindpi, konu eipi pupu, wumb ek emb topu, ek ka ni tor kindpi erim. ");
INSERT INTO nii_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jon wumb noł pendiłim wu, ei eim kan ngii pepi mołpu piim ni, Gos kindang wu Krais kongun yi erpi, oł yi erpi enim nengin piipi, eim nge ekii sik andiłmin wu kindang, Jiisas mołum konu punjung. ");
INSERT INTO nii_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Puk, Jiisas kin kii sik yi ninjing, “Nim Gos kindim wu Krais ei nim on, min sin wu endi eipi kui er mołmun?” ");
INSERT INTO nii_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jiisas ek nipi wu ombu ngum, “Enim Jon mołum konu puk, enim epi kanik piik enmin mił, ei nik Jon ningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","“Ningił tumbun mołum ei nga ka seng kaninmin. Simb kis mułum ei nga kun kamb andinmin. Ngenj kinj bumbułum tum wumb ei, nga ngenj ka sałim. Kom ngum wumb ei nga ek piinmin. Wumb kolk, ei nga tonu konj onjung. Nga wumb epi sinerim kaimb mulnjung wumb, ei ok Gos ek ka piinmin. ");
INSERT INTO nii_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pe wu nii endi eim pii gii ei na kin dinga pim kin, wu ei eim ka piyangłi!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon wumb noł pendpi ngołum wu, ei nge ekii se andiłmin wu si kindik orung pangin, Jiisas eim Jon nge ek ei nipi wumb ngum. “Kumb ok enim wumb mulenjing konu punjung, ei epi nipe keningii punjung? Enim puk, wu endi gumei mił mołpu kin konu pop tang ek eipi eipi nipi enim wu, ei enim keningii nge punenjing mon. ");
INSERT INTO nii_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Enim epi nipe keningii punjung? Enim puk, wu endi eim konduk mon kanim kanim kindpi mułum, ei keningii nge punenjing mon. Wumb konduk mon ka kanim kanim kindiłmin, ei king ngii ełe mołułmun wumb,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ba enim nimbił erang punjung? Oł ekii se tonu omba piik niłmin wu, ei keningii nge punjung. Ba oł ekii se tonu omba piik niłmin wu kombur tonu ok wu ombu, eim to mani kindpi poru nim, eim wu owundu mołum. ");
INSERT INTO nii_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wu ei mendpił Gos nge ek ka ełe ek yi nim, ‘Piini! Na ek se andiłim wu endi kindamb pupu, na ek ni tor kindmba Wu ei eim kumb se ba. Pupu, Jiisas nim nge andłam er ka ermba.’ ");
INSERT INTO nii_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jiisas yi nim, “Na ek keimi nip enim ngond. Jon wumb noł pendpi ngołum wu, ei oł ekii se tonu omba piik niłmin wumb tonu onjung wumb, ei pei kamb mani kindim. Ba Jon eim wu endi Gos sinim tep er mołum konu ełe wu num mił mon. Ba wu wii endi Gos ek ka ni tor kindmba wu ei, Jon to mani kindmba. Nimbił erang Jon eim Gos ek ka aninga kopur piim, ba pe sinim Jiisas kin pii gii ninmin wumb, ei Gos ek ka ei pei piik sinmin. ");
INSERT INTO nii_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Jon wumb noł pendiłim wu tonu orum kunum ei, wang wang pe kunum ełe sinim mołmun. Pe wumb kis Gos sinim tep er mołum ek ei kin ek buł ambilk ninjing. Pe wumb num ni wumb dinga wii ei wumb eipi kin Gos sin tep er mołum ei, sinerngii mon nik, mani kindik si kindngii enmin. ");
INSERT INTO nii_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Gos nge oł ekii se tonu omba piik niłmin wumb ok nik, Moses lo ek om nin, pe Jon tonu om kunum ei ek ombu pei Gos sinim tep er mołum ek ei kin ninjing. ");
INSERT INTO nii_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pe enim ek ei pii gii ninjing kin piingii. Jon eim Elainja mił oł ekii se tonu omba piipi niłim wu ei omba nge om. ");
INSERT INTO nii_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wu nii endi kom simba wu, ei kom se piyangłi! ");
INSERT INTO nii_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Pe wumb kunum ełe mołmun wumb ei, na epi nipe mił su simbii? Wumb ei yi mił, kangił tuk konu endi molk, ek dinga nik kangił kombur ngok yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Sin gising topun enmin, ba enim golang ninanmin. Sin golang kaimb er ninmin, ba enim ek ninanmin mon! ");
INSERT INTO nii_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon om kunum ei eim noł ni kuni nunerim. Yi erang kin, wumb yi ninjing, ‘Gui kis eim kin mołum,’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Pe na Gos kingam tonu epin si kindpi, mani mei ełe opu wumb ngenj kułpu ei, enim wumb yi ninmin. ‘Wu ei kuni pei nopu, noł wain pei nopu ełim wu,’ nik yi ninmin. ‘Eim wumb puł ei ku takis sik, nga oł kis kanim kanim ełmin wumb ei nge wu puł mołum,’ pa niłmin. Sił epi pei enjpił ei enim pei ka piinenjing mon. Ba Gos nge noman ka ei pep onum. Pe ei sinim kanpin, Gos noman ei keimi ni piimin.” ");
INSERT INTO nii_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Konu owundu kombur Jiisas eim jep oł pei ok erim konu, ełe wumb noman ak tunenjing. Yi erangin kin, kunum ełe Jiisas wumb ek ngum. ");
INSERT INTO nii_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ngopu ek yi nim, “Enim Korasin konu wumb ni Besaira konu wumb, kaimb piind,” pa nim. “Pe wu endi Sairon konu ni Taiya konu, wu endi jep oł yi na end mił ermba ei enim ok enim Sairon ni Taiya ni wumb ei kon alap kis mił sik, dup sik ełe kunum kunum molk, noman ak tunjung. ");
INSERT INTO nii_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ba na enim kanip nind, Sairon kin Taiya konu oł embin tui tonu om mił enim kin onermba. Enim kin oł embin tui kis wii owundu tonu opu pimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Pe enim Kapaniyam konu wumb, enim si tonu epin konu simba ni piinmin? Ei mon. Enim dup konu mendpił pungii. Pe wu endi Sorom konu jep oł na enim kin end oł ei, Sorom konu ełe wumb oł yi ełangin kin wumb ei en enim piram mułułangin ku. ");
INSERT INTO nii_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ba na enim kanip nind, “Sorom konu wumb Gos to kondpu kis erim mił yi enim konu wumb onermba. Ba enim konu ełe mołmun wumb ei kin, Gos kunum Owundu tonu omba memb ei oł embin tui owundu kis ei tonu omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kunum ełe Jiisas eim ek yi mił nim, “Arnan, nim tonu epin konu kin mani mei konu ei kin, nim wu num owundu mołun. Na nim kin noman ka piind. Nimbił erang ninim nge epi ombu ek keimi wumb noman ka piik ełmin wumb, ei kin koi erpin pendin. Nga ninim nge epi ombu ek keimi, ei mendpił kangił kembis andan ton. ");
INSERT INTO nii_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Keimi, Arnan nim nge noman ei yi mił pałim ei en. ");
INSERT INTO nii_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Na Arnan eim epi pei na angił ełe kindpi ngum. Wumb endi eim kingam ei pii poł tunanmin mon. Arim eim mendpił kingam piinim. Wumb endi Arim ei pii poł tunanmin mon, kingam eim mendpił arim piinim. Wumb pei kingam noman ełe ei arim mołum nipi andan topu wumb ngum kin, wumb eim arim ei pii poł tungii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Wu nii endi epi embin ko wumba kis erim kin, na kin wang eim kor ngamb, kor mułmba. ");
INSERT INTO nii_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Pe oł embin tui na pindang ełe pałim ei, enim sik enim pindang ełe ko wungii. Ko wuk, na ek ekii sik piingii. Nimbił erang na wumb kin oł ka ełe erip, nam embe to mani kindił. Pe enim nge noman tuk ełe kan sik kor ka mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Oł embin tui ei enim pindang ełe pendind, ei ka wii. Epi na enim ngopu, singii pa nimbii, ei embin owundu enałim mon.” ");
INSERT INTO nii_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ekii se kor kunum endi, Jiisas kuni wiis pin tuk ełe endim. Eim nge ekii sik andiłmin wu ombu kuni tum. Pe tuk andik, kuni wiis mong ei tangk nunjung. ");
INSERT INTO nii_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wumb lo ek piiłmin wumb, ek nik Jiisas ngunjung, “Nim nge ekii sik andiłmin wumb ombu oł ei kor kunum enmin ei mon ninjing.” ");
INSERT INTO nii_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jiisas ek nipi yi nim, “Enim Deipis ek poł ei ger piinjing min? Na nind, ei eim kin eim wu ombu ei kuni tum kunum, ei nimbił oł enjing? ");
INSERT INTO nii_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Molk kin, Gos men ngii owundu ełe nirik punjung. Puk, bres Gos ngii ełe sałiłim ei wumb eipi mon niłmin. Gos kin kułmał kałiłmin wumb ei minj nungii niłmin. ");
INSERT INTO nii_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Enim ek ei lo mon ełe pim, ei ger kinenjing min? Pe kułmał kałiłmin wumb ei Gos men ngii owundu ełe kongun ełmin. Kor kunum mon nik ełmin oł ei ełmin, ba ek endi ninałmin. ");
INSERT INTO nii_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pe na enim kanip nind, noman dinga ei ya sałim ei men ngii sałim epi ei to mani kindim. ");
INSERT INTO nii_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ba enim na nind ek ei piingii, ‘Na kułmał kałiłmin oł ei na noman pinałim. Na noman kun ka sałim wumb ei noman enim.’ Enim wumb oł endi enjing wumb ei oł embin tui enerngii mon. ");
INSERT INTO nii_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na Gos kingam tonu epin si kindip mani mei ełe op, mei kingam mił tałip moł ei, na kor kunum puł wu Owundu moł. Wumb nipe oł endi kor kunum erngii, ei na dinga ełe wumb oł yi mił erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jiisas konu ełe si kindpi, men ngii ełe tuk pum. ");
INSERT INTO nii_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wu endi mułum wu, ei eim angił ełe epi endi sinałiłim. Angił kułii erim. Pe wu kombur Jiisas kos er ngonmun nik, Jiisas kii dinga sinjing. “Pe sinim kor kunum ening pałim wumb ei er ka ermin min?” ");
INSERT INTO nii_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jiisas ek nipi orung kindpi yi nim, “Enim mołmun konu, wu endi kung siipsiip es tołum ei kor kunum kung siipsiip endi konu tukpu endi mani pupu pimba ei, kor kunum si tonu sinermba min? ");
INSERT INTO nii_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nga wumb endi eim kung siipsiip ei to mani kindiłim yi mił pe sinim lo ek ełe kapłi nipin kin sin kor kunum ełe wumb kapłi paki tumun. ");
INSERT INTO nii_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pe eim ek nipi wu ei ngopu yi nim, “Nim angił tun kindii!” Neng, tun kindim. Yi erang, wu ei eim angił ei ka mułum. Wu eipi endi ka mułum mił yi mułum. ");
INSERT INTO nii_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jiisas kor kunum oł ei erang kanik puk kin, wumb en enim ek nik piik Jiisas to kundngii nge ek ninjing. ");
INSERT INTO nii_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ba Jiisas eim ninjing ek ei piipi, konu ełe si kindpi pang, wumb tiłap pei eim kin ekii se pangin, eim wumb ening ombu er ka erim. ");
INSERT INTO nii_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jiisas ek dinga nipi wumb ngopu yi nim, “Enim ek nik tor kindnerii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Gos ok oł ekii se ermba oł piipi niłim wu Aisaiya ek ni tor kindpi yi nirim. Ekii se oł yi tonu omba nirim, ek ei pe keimi pałim. Ek ei yi mił, ");
INSERT INTO nii_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wu ei na eim kongun ermba nip to mundunj wu. Na eim ka piip, nam noman eim kin sałim. Nam nge Gui Ka ei eim ngamb, eim na kos dinga ek kun nipi, torung wumb tiłap eipi ngumba. ");
INSERT INTO nii_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pe eim wumb ek ngopu ek dinga nipi enermba. Wumb eim andłam ełe angpi wii topu yi erang, eim ek piinerngii. ");
INSERT INTO nii_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Gumei endi ek nimba er pimba, ei eim to engin tunermba. Dup alam kan endi, dup kembis nopu pimba, ei eim to kumundpu poru ninermba. Ei yi mił wumb nii endi en enim pii gii dinga pinermba wumb ei, eim to tor kindnermba. Eim kongun ermba ei Gos eim kunum owundu tonu omba kunum ełe, na ek ka ei erang kin oł kun minj erpi pang poru nimba. ");
INSERT INTO nii_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pe wumb torung tiłap eipi wumb eim kin pii gii nik, eim kui er mułngii.” (Gumei kin dup kan ninmin ei yi mił; wumb Gos ek ka ei piipin oł ermin mił nenj ni piik mułngii wumb ei, Jiisas eim mani opu kongun erang wumb oł ka wii mendpił erik mułngii nip piipi, oł ekii se ermba nipi piiłim wu Aisaiya ek yi pułum.) ");
INSERT INTO nii_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kunum ełe, wumb wu endi tunjung wu ei gui kis tuk mułum. Wu ei ningił tumbun mułang, gupu ełe ek tengnerim ku. Jiisas eim wu ei er ka erim. Erang, gupu ek nipi kin, ningił kanpi erim. ");
INSERT INTO nii_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wumb tiłap pei molk kanik puku sik yi ninjing, “Wu ei Gos kindim wu Krais min mon?” Wumb en enim noman ełe yi piinjing. ");
INSERT INTO nii_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ba lo ek piiłmin wumb ek ei piik yi ninjing, “Dinga ełe enim ei gui kis nge tep ełim owundu Biyelsipul nge dinga ełe enim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ba Jiisas eim wumb noman ełe piipi, ek nipi yi nim, “Pe king tep erim konu endeim ełe wumb, en enim opu erngii ei, en enim konu ka dinga sinermba. Pe wumb konu ende wumb, min ngii ende wumb orung orung puk, opu erngii ei, en enim ngii konu ni konu ka sinermba. ");
INSERT INTO nii_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pe Seisen nge wumb en enim eipi eipi bin ni, erngii dinga ermba min? ");
INSERT INTO nii_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Biyelsipul na paki tang na gui kis tor kindinj, ba wumb nii enim ekii sik andiłmin wumb paki tang, gui kis to kindinmin? Pe en enim kos piiłmin wu mił molk kapłi enim ek kanim kanim ei nik kun erang, ");
INSERT INTO nii_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ba Gos nge dinga ełe na gui kis top kindinj kin, enim piingii. Gos sinim tep er mołum ei, sinim kin mandi onum ni piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nimbił erang, na pup, wu num Seisen nge wumb waning ermbii ni piind, ba ok na pup, wu num Seisen eim simb angił kan ngo pendip, ekii se na eim nge wumb ei waning simbii. ");
INSERT INTO nii_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wu endi na wu puł mon, ei na kin opu ermba wu. Pe wu endi na kin kung siipsiip es tunermba wu, ei eim kung siipsiip topu eipi eipi kindiłim. ");
INSERT INTO nii_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Yi mił pałim ei piip na enim nip ngond. Gos eim wumb ek kis nik enmin ei, kapłi oł kis kil ngumba, ba wumb endi Gui Ka kin ek buł ngok erngii, ei Gos wumb oł kis ei kil ngunermba mon. ");
INSERT INTO nii_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Na Gos kingam tonu epin si kindip mani op, mei kangił mił muls ei wu endi ek kis nipi, na ngumba, ei Gos kapłi kil ngumba. Ba wu endi Gui Ka kin ek kis nimba wu ei, Gos eim kapłi kil ngunermba mon.” ");
INSERT INTO nii_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Pe ond ka pimba ei, ond mong ka tumba. Nga ond kis pimba ei, mong kis tumba ku. Wumb ond ei kanik kin, ond mong ka min kis ei kan poł tołmun. ");
INSERT INTO nii_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Enim lo ek ekii siłmin wumb wembii kis Seisen nge kingam noł, enim ek ka er ningii mił nenj? Enim wumb kis enim noman tuk ełe noman kanim kanim pałim mił, ek yi gupu ełe ni tor kindinmin. ");
INSERT INTO nii_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Wumb kun ka endi eim noman tuk ełe oł kun ka kanim kanim pei pałiłim mił ei oł kun ka ei pei ni tor kindiłim. Nga wu kis endi eim noman tuk ełe oł kis kanim kanim pei pałiłim mił ei oł kis ei pei ni tor kindiłim. ");
INSERT INTO nii_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ba na enim kanip nind, wumb en enim ek wii mił nik ełmin oł kanim kanim ombu, ekii se Gos wu amb mok tumba kunum, ei wumb pei nipi ek ninjing ek ei, Gos kin ek orung kindngii. ");
INSERT INTO nii_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wumb ninim ka ninjii ełe Gos nim, wu ka nimba. Pe nga ek kis nin kin, en kin Gos nim, wu kis nimba. Ei ninim oł erkin ek nikin enjii mił ku, Gos nim kanpi nimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pe kunum ełe, wu num lo piiłmin ni lo ek ekii siłmin wu, kombur kin ok, ek yi ninjing. “Ek emb to ngołun wu, sin nim jep oł endi eran kenmin ni onmun,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ba eim ek dinga nipi yi nim, “Wu amb kunum ełe oł kis er andiłmin wumb, ei na jep ei erang kenmin niłmin ei, ek ni tor kindiłim wu Jona oł ei andan top ngoł. ");
INSERT INTO nii_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Kumb ok Gos ek ni tor kindiłim wu Jona eim omu owundu kirim ełe tuk pupu pim. Ei eim kunum tekliki epin, tinga ouni pep mułum. Yi mił ku, na Gos nge kingam tonu epin konu si kindpi mani mei ełe wu kingam mił tełim, ei eim mei ełe kunum tekliki epin, tinga ouni yi pimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ekii se Gos wumb mok tumba kunum ei, wumb Ninipa konu owundu wumb tonu ok wumb pe mołmun wumb angk ei enim oł kis kanim ei ni tor kindngii. Ei nimbił erang, wumb ei wu Jona Gos ek nipi ngum, ei noman ak tunjung. Pe ya epi endi mołum ei wu Jona to mani kindpi, owundu mendpił mołum,” pa nim. Ei Jiisas eim piipi nim, wumb endi mon, eim mendpił, ba enim wumb eim pii gii ninanmin. ");
INSERT INTO nii_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gos wumb mok tumba kunum ei, kuin owundu konu orundung eipi mołum ei, opu wumb ya ełe mołmun wumb ei oł kanim kanim enjing ei nipi tor kindpi ngumba. Nimbił erang kuin owundu embe Siipa konu mei orundung mołpu omba. Ei opu King Solomon nge noman ka peng ek ka nipi tor kindim, ei piimba nge om. Ba epi endi ya ełe mołum ei eim King Solomon noman ei to mani kindpi, eim wu num owundu mendpił mołum.” (Ei Jiisas eim ermba oł ei piipi nim.) ");
INSERT INTO nii_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Pe gui kis ei wu endi si kindpi pułum ei pupu konu kep endi mułmbii ni pułum. Pepi mułmbii ni pułum ba konu endi sinałim. ");
INSERT INTO nii_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Eim yi piiłim, ‘Na ok muls ngii ełe nga orung bii,’ nipi opu kaniłim ni ngii was erik, brum er ka er sinjing. ");
INSERT INTO nii_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Seng, kanpi pupu gui kis angił orung nga tał pei kanpi neng onjung, ba gui ombu oł kis wii enjing. Pe ok ngii ełe nirik puk ngii ełe mulnjung ok, wu oł kis aninga er mułum, ba pe am er kis mendpił pup mułum. Oł ei nge, wu amb kis pe mołmun kunum, yi ku tonu omba.” ");
INSERT INTO nii_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jiisas ek nipi wumb ngopu mułang, Jiisas eim mam ni angim noł ok ngii andaring engnjing. Eim kin ek nimin nik ok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Pe wu endi kanpi opu ek nipi yi nim, “Nim manim ni angnim noł ok nim kin ek nimin nik ok mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ba Jiisas wu ei kin ek nipi orung kindpi yi nim, “Na minan ei nii? Nga na nge engnan noł ombu nii?” ");
INSERT INTO nii_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pe eim nge ekii sik ełmin wu amb ombu kin angił tuł ngopu ek yi nim, “Enim kinei! Wu amb ombu na nge engnan noł ni minan noł mił mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","“Wu endi na Ernan Gos noman pałim mił ekii singii wumb, ei na minan ni, na engnan nga, na ainan noł mułngii,” pa nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pe akip kunum ełe Jiisas ngii ełe si kindpi, pupu noł gopu wer ełe mułpu, ek nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wumb pei Jiisas eim mułum konu ełe ok mulnjung. Mułangin, pe Jiisas eim noł kanu endi ełe tonu pupu mułum. Wumb noł wer ełe mułangin kin eim wumb kin ek nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jiisas eim ek nim ek ei pei ek ekin topu nipi wumb ngum. Ngopu yi nim, “Enim piinmin! Wu endi kuni mong wiis emb kindim. (Ei yi mił wu endi kongun er sepi kinapi mong emb kindinmin oł ei mił yi kindim.) ");
INSERT INTO nii_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Pe kuni wiis emb kindpi pang, kombur pu andłam ełe mani pang, kei ok sik nunjung. ");
INSERT INTO nii_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kuni wiis mong kombur pupu, mei aninga pim, ku pei mandring mułum konu ełe mani pum. Kuni ei sikir tonu om. Ei nimbił erang, mei aninga tonu peł ełe pim. Mei pei sepi mani punerim mon. ");
INSERT INTO nii_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ba konu eni dinga tang, kuni wiis mong ei dumbuł mani punenim. Tonu ku peł ełe pim, ei kułii erpi pei kułum. ");
INSERT INTO nii_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Pe kuni mong wiis emb kombur pupu mei sim konu pum. Ei tonu omba erim ba eri ei tonu opu kuni mong wiis to mani kindim. ");
INSERT INTO nii_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kuni mong wiis kopur pupu, mei ka sim ełe mani pum. Ei tonu opu ka erpi, mong pei tum. Kombur mong 100 to mułum, kombur mong 60 to mułum, kombur mong 30 to mułum.” ");
INSERT INTO nii_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jiisas ek ei nipi poru nipi yi nim, “Wumb endi kom pimba wumb ei, ek ei piyangłi!” ");
INSERT INTO nii_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jiisas eim nge ek se andiłmin wumb ombu ok yi ninjing, “Nimbił erang nim ek ekin to nikin wumb ngon?” ");
INSERT INTO nii_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Eim ek nipi orung kindim, “Gos enim epin konu tep er mołum konu, ei ek koi er pim, ei nipi enim ngum, ba wumb ombu mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pe wu endi eim epi sepi mułum kin, Gos eim kin epi nga ngumba. Wu endi eim epi sinerang mułum kin, nga eim nge epi kembis endi simba, epi ei am ba. ");
INSERT INTO nii_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Na ek ekin nind ek ei pułe yi pałim, ‘Ningił ełe epi kaninmin ba epi kinanmin. En enim kom ełe ek piinmin, ba mendpił piik kun enanmin mon.’ ");
INSERT INTO nii_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wumb oł yi enmin ei, ok ek ni tor kindiłim wu Aisaiya ninim ek ei keimi pałim. Ei wumb ekii se oł yi erngii ni piipi nirim mił keimi pałim. Nirim ek yi nirim. ‘Enim piinmin ba pułe piinanmin. Enim keningii ba epi endi kinerngii. ");
INSERT INTO nii_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Enim noman ełe pirek neng, ek piinanmin. Enim kom ełe ek piingii, kis enim. Nimbił erang en enim ningił kumbuł gii ninmin. Yi erik epi kinanmin. Kom ełe er piik tuk sinanmin. En enim noman ełe ek pułe pii poł tunanmin. Tunarik, na kin onan Gos yi ninim. Wangin kin, na en enim er ka ermbii.’ ");
INSERT INTO nii_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ba enim ka piingii ei enim ningił epi kanik, kom ełe ek piik yi enmin. ");
INSERT INTO nii_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Enim piingii! Na ek keimi nip enim ngond, kumb ok Gos nge oł ekii se tonu omba, ei piik niłmin wu ni, kombur wu oł kun ka ełmin ombu en enim noman ka ka piik, enim pe kanik enmin ei kenmin ni mulk ba kinenjing mon. Nga enim piinmin ek ei piimin ni, ka piik mulk ba piinenjing.” ");
INSERT INTO nii_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Wu endi kuni emb pani pin kindim, ei ek ekin ei nge pułe yi pałim ei enim piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wumb pei Gos tonu epin mołpu sinim tep enim ełe ek ei kuni mił, tał pendnim ei pir sinanmin. Ei yi mił kuni mong wiis emb ei mani andłam ełe pang, kei sik nunjung. ");
INSERT INTO nii_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Nga kuni mong wiis emb pupu, mei ku mułum ełe mani pum ei yi mił, wumb Gos ek piik, ka piik sikir sinmin. ");
INSERT INTO nii_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pe kuni wiis ei dumbuł mani punanim. Ei yi mił, wumb kombur Gos ek to mani kindik wu ei kin oł kis erangin, wu ei eim pii gii sikir kis mołum ei, nge pułe yi pałim. ");
INSERT INTO nii_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kuni mong wiis emb kombur pupu, ond kan dumbuł mułum ełe mani pum. Ei pułe yi mił, wumb endi Gos ek ei piim ba mei ełe oł embin tui eim kin tonu opu, Gos ek ka ei to mani kindim. (Ei yi mił eim Gos nge kongun enerim.) ");
INSERT INTO nii_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ba kuni mong wiis emb ei pupu, mei ka ełe mani pum ei yi mił, wumb Gos piik, ekii sik, kongun yi erangin kin kuni mong 100 min, 60 min, 30 yi top mułum.” (Ei yi mił wumb Gos piik, nga kongun erangin, wumb konj nga tuk ok Gos piinmin mił, ek yi nim.) ");
INSERT INTO nii_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jiisas eim ek ekin endi nipi ngopu yi nim, “Gos sinim tep er kanpi mołum mił yi, wu endi eim kuni emb sipi kindim. ");
INSERT INTO nii_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ba epin konu emii peng opu, orung wu endi opu, kuni mong wiis pim konu engimb kis mong pim, ei kindpi pum. ");
INSERT INTO nii_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ekii se kuni mong wiis ei tonu opu, mong tumbii ni erang, engimb kis endi tonu opu pim. ");
INSERT INTO nii_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pe kongun wumb puk en enim nge wu Owundu mułum konu kanik, yi ninjing, ‘Wu Owundu, sin piipin nim kuni mong wiis ka wii ei aka pin kindin ni, piinjpin ni, engimb kis endi tonu opu mołum,’ pa ninjing. ‘Ei nimbił erang enim?’ a ninjing. ");
INSERT INTO nii_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Eim ek yi nim, ‘Opu orung wumb endi opu erim.’ Neng, kongun wumb eim kanik yi ninjing. ‘Sin pupun, engimb kis ei pirpin, tor kindmin min?’ ");
INSERT INTO nii_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ba wu owundu ei ek nipi yi nim, ‘Enim engimb kis ei er tor kindmin ni erngii ei, enim kuni mong wiis ei ouni er tor kindngii mon!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Pe enim epi tał ouni kan wiik tangin tonu onkuł, pengił, ekii se kuni poł tumba kunum, ei engimb kis ei eipi or tok, kuni mong wiis ei sipik, nanim kuni ngii ełe kindngii, ba engimb kis ei or tok dup ełe kindngii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jiisas eim ek ekin endi eipi nipi ngum. Ei yi mił nipi, “Gos tonu epin konu sinim tep enim mił yi eim kuni mong endi embe maser mong,” pa niłmin. ");
INSERT INTO nii_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kuni ei wu endi eim sipipi, eim aka pin ełe tełim. Maser niłmin kuni ei mong kembis wii, kuni wii emb ombu kuni mong wiis mił kapłi mon. Ba ekii se, kuni ei tonu opu, ond mił mendpił peng kei ok ond ełe ambilk molk, ngii takik ełmin.” ");
INSERT INTO nii_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nga eim ek endi ekin topu nipi ngopu yi nim, “Epin konu tep er mołum, ei yi mił kuni yiis ei amb endi sipi kin, ming endi sipi, noł kin erang, plawa owupu tonu ołum. Ei yi mił, wumb Gos ek ka ei piik wumb, pei ok Jiisas kin ekii sinmin.” ");
INSERT INTO nii_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jiisas eim ek ekin ombu ni tor kindpi wumb pei ngum. Ek ombu pei eim nipi tor kindim ei, Jiisas eim er endeim ni tor kindnerim mon; ek pei ek ekin ni tor kindim. ");
INSERT INTO nii_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Na ek ni tor kindinj ei yi, ok oł ekii se tonu omba, epi ei piipi nirim ek ei keimi, tonu om wu eim ek yi nirim. “Na ek ekin top nip wumb en enim ngumbii. Nga nam ek koi er pirim ek ei nip tor kindip ngumbii ei kumb ok Gos mei eririm ek ei nip ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pe eim wumb si kindpi ngii konu pum. Nga ekii se eim nge ekii sik ełmin wu ok, eim kin kii sinjing, “Nim engimb kis endi ek ekin, ei pułe ni peni ełe kindii!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jiisas ek nipi orung kindpi yi nim, “Wu endi kuni mong wiis ka emb kindim wu, ei wu kingam. ");
INSERT INTO nii_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aka pin ei pułe, mei orung orung pei. Nga kuni emb ei, Gos sinim tep enim konu ełe pei mołmun. Nga engimb kis ei yi pałim; Seisen nge wumb, ei engimb kis mił mołmun. ");
INSERT INTO nii_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Sinim nge opu orung wu ei, Seisen eim mołpu, eim engimb kis emb mił ei kindim. Ekii se kunum poru nimba ei, kuni ngungii kunum ei yi mił ku, muł, mei poru nimba kunum ei, Gos enjel kuni ei kułou tungii. ");
INSERT INTO nii_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Engimb kis ei kułou tok, dup kelnjing ei, yi mił ku ekii se ya mei ełe poru nimba kunum ei yi pimba. ");
INSERT INTO nii_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gos kindim wu kingam pupu, enjel kindang ok, wumb endi oł kis erik oł kanim kanim yi erangin kin, wumb pii gii to kis ełim ei sik, epi kanim kanim endi pii gii to kis ełmin ei, Gos tep ełim wumb ei kin tep to mulerngii mon. ");
INSERT INTO nii_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Pe wumb ombu, pei olkup to dup ełe kindngii. Dup ełe en enim ke nik, anmbił kongk, er mułngii. ");
INSERT INTO nii_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kunum ełe, wu amb kun ka mułngii wumb ei, ngenj ełe eni mił tiłang erang, en enim nge ernjing tep ermba konu tukrung mułngii. Wumb endi eim kom pim kin ek ei piyengłi!” ");
INSERT INTO nii_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Gos sinim tep er mołum ei mił; wu endi ku kum mei ełe peng kan sim. Ku kum ei kan sipi nga aka pin ełe nga koi erim. Nga wu ei eim ka ka piipi pupu, eim epi wumb kanim kanim pei wumb ngopu ku minj sim. Eim nge ku ei sipi mei ełe nga top erpi sirim.” ");
INSERT INTO nii_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Gos sinim tep er mołum konu ei yi mił; wu endi epi top erpi, nga wumb ngopu ku sipi, eim biis ni epi mon ka wii pałim ei nge kurnum. ");
INSERT INTO nii_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pe eim kenim ni biis ka wii endi kanpi eim epi sipipi wumb eipi kin ku sipipi biis ka wii ei top erpi sim.” ");
INSERT INTO nii_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Pe nga endi yi ku, Gos sinim tep er mołum konu ei yi mił; omu kon ei oł tok noł gopu, ełe mani kindik, omu kanim kanim sik tor siłmin. ");
INSERT INTO nii_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Pe omu kon ei piki tang sik, noł wer ełe tor tu wułmun. Tu wuk, omu ka mił ombu apir sik, ming endi ełe kindik, kis mił ombu kułou tok sipik si kindiłmin. ");
INSERT INTO nii_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ekii se muł mei poru nimba kunum, ei yi mił ermba. Enjel ok wumb kis tuk wumb ka mułngii konu tuk mułngii, to sipi tor kindngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Pe wumb ombu pei sipi, dup konu ełe kindangin, ke nik, en enim gupu anmbił ni gupu mong ei kongk, kunum kunum dup peł ełe minj mułngii.” ");
INSERT INTO nii_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Jiisas eim ek nipi kii sipi yi nim, “Enim ek ombu pei piik poru ninmin?” Pe eim ek nipi ngopu yi ni dinga nim. Wumb eim kanik, yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","“Gos sinim tep ełim ek ei piik poru nik ełmin wumb kin, ngii ełe ngii arim mił molk. Pe eim top ngii endi ełe epi pei konj min oknge ei pei sipi top simba. Ei yi mił, Gos ek oknge nim nga ek konj ei pei Jiisas ni tor kindim.” ");
INSERT INTO nii_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pe Jiisas eim ek ekin nipi poru nipi, eim konu ełe si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nga eim si kindpi pupu, eim nge mei ełe pum. Pupu, eim Gos ek nipi wumb ngopu, erang wumb Gos ngii ełe molk, piik puku sik yi ninjing. “Wu ei noman dinga ni, jep oł enim, ei eim konu jiłi orung pupu sim? ");
INSERT INTO nii_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Wu ei eim wu kamnda nge kingam. Mam Maria ei eim nge mam. Eim nge angim Jeims ni Josep ni Saimon ni Juras wu ombu eim angim noł mołmun. ");
INSERT INTO nii_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pe nga eim nge aim noł pei sinim kin mołmun ba wu ei ek jiłi orung pu sim?” ");
INSERT INTO nii_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wumb ek yi nik kin en enim noman kis piinjing. Ba Jiisas eim ek nipi yi nim, “Ek ni tor kindiłim wu eim konu orung orung eipi wumb eim kaimb sik, noman kulk ełmin, ba eim ngii konu ni eim nge konu ełe wumb, oł yi enałmin mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pe nga eim jep oł pei konu ełe enerim mon. Nimbił erang wumb eim kin pii gii ninenjing. ");
INSERT INTO nii_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kunum ełe, King Eros wu owundu, eim Galilii konu tep mołum wu, ei eim Jiisas ek ei piim. ");
INSERT INTO nii_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Eim ek nipi eim nge kongun wu ombu ngopu yi nim, “Wu ei Jon wumb noł pendpi ngołum wu ei, tukpu ełe angpi tonu om ełe dinga ei eim kin kongun er mołum.” ");
INSERT INTO nii_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ei yi mił, King Eros ni wu ei Jon ambił gii nipi sipi kan ngum. Erosiyas Pilip nge ambim, ei eim kamim ba eim King Eros bii nipi kin King Eros kin pum. Pang, Jon, “Mon!” pa nim, ełe nge King Eros Jon kan ngii ełe kindim. ");
INSERT INTO nii_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Kumb ok, Jon eim King Eros kanpi yi nim, “Nim amb ei sin, ei kapłi enanim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nga King Eros eim Jon to kundmbii nim; ba eim wumb pei kin mund mong kułum. Ei nimbił erang, wumb pei Jon ek ni tor kindiłim wu mołum ni yi piinjing. ");
INSERT INTO nii_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kunum ełe wu kombur King Eros kin kułou tunjung. Tok, mam eim mengim kunum ei piik er mulnjung. Kunum ełe Erosiyas eim nge ambłam ei tuk golang nipi, non er endim. Endim ei, King Eros eim kan ka kenim. ");
INSERT INTO nii_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kanpi, eim ek dinga nipi ambił ei ngopu yi nim, “Nim epi endi simbii ninjii ei, na nim kapłi ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ambił ei nge eim mam ei nim ek mił piipi yi nim, “Nim wu Jon wumb noł pendiłim wu, ei peng ming endi kindkin tu, nam ngui!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ambił ei ek yi neng kin, King Eros eim noman embin to piim, ba ok eim ek dinga nipi ngum ei piim. Pe nga eim wu kombur eim kin kuni ende nok mulnjung, ei piinjing ku. Yi peng piipi kin, “Yi na epi ei ngei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eim wu kombur kindang puk, Jon kan ngii pim konu, pang, “Kołmung er tu wei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wumb puk, Jon peng embił ei ming ełe tu wuk kindik, ambił ei ngangin kin ambił ei sipipi eim mam ngum. ");
INSERT INTO nii_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ba Jon nge ekii siłmin wumb ei ok, Jon ngenj sipik, tukpu tok pendik. Ekii se puk, Jiisas kanik, yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jiisas eim Jon ek ei piipi, konu ełe si kindpi noł kanu sipi, konu eipi wumb mulenjing konu eipi ełe pum. Eim endeim mendpił pum. Ba wumb konu owundu orung orung pei piik, eim pum konu ekii se punjung. ");
INSERT INTO nii_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ekii se Jiisas eim tor pupu kenim ni wumb tiłap owundu pei ok mulnjung. Eim wumb ombu noman ka ngopu, ening pim wumb ei er ka erpi yi erim. ");
INSERT INTO nii_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Konu pou neng, Jiisas nge ekii siłmin wumb ok eim kanik yi ninjing, “Sinim ya konu ełe wumb endi mandi mulałmin; nim wumb ei kindan orung puk, kuni kan sik, nok erngii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ba Jiisas ek nipi orung kindpi yi nim, “Nimbił erang wumb pei orung pungii? En enim wumb ei kuni ngungii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jiisas eim nge ekii siłmin wumb eim kanik yi ninjing, “Sin kuni endi pei sinałim. Bres angił orung kin, omu tał mendpił sałim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jiisas eim ek nipi, “Kuni ombu ya na moł konu tu wei!” nim. ");
INSERT INTO nii_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Eim ek nipi, “Wumb pei mani ełe mułei!” pa neng, mulnjung. Mułangin, eim bres angił orung sipi, omu tał sipi, tonu kanpi, Gos kin ek ka nipi, bres engin topu, eim nge ekii siłmin wu ngang, sipik wu amb ombu ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Wumb kuni ei nok pangin orung pei mułum ei, kon engki nga tał to piki tunjung. ");
INSERT INTO nii_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Wu kuni nunjung ei 5,000, ba amb kangił ei pei gerik kun enenjing mon. ");
INSERT INTO nii_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pe Jiisas eim nge ekii siłmin wumb ei kanpi yi nim, “Kumb se enim noł kanu ełe tonu puk, noł orundung pei! Nam wumb ei ‘Pei!’ nip kindip, ombii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jiisas eim wumb ei pei nipi kindpi, eim mendpił tonu komung ełe tonu pupu, prei erim. Konu pou neng, eim mendpił tonu komung ełe mułum. ");
INSERT INTO nii_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Noł kanu ei pupu, tuk noł miim ełe mandi pang, konu pop owundu topu yi erim. Ei noł kanu kumb ełe om. Opu, noł kanu to ak tumba erim. ");
INSERT INTO nii_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Konu tengmba mandi erim, ba aninga kopur emii mił pim konu kenjing ni eim noł gopu peł ełe tonu opu, eim ekii siłmin wu mulnjung konu mandi om. ");
INSERT INTO nii_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wu ombu molk kenjing ni wu endi noł peł ełe wang mił, wu ombu mund mong kulk, mon gui endi onum, ninjing. Nik, mund mong erik, wii dinga wii tunjung. ");
INSERT INTO nii_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pe Jiisas sikir tor opu yi nim, “Enim mund mong enerei! Ei na, na mendpił ond. Enim puku sinerei, mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piisas ek nipi orung kindpi yi nim, “Owundu, ei nim mendpił on kin, na nen noł peł ełe op, nim mołun konu ombii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Oi!” a nipi Jiisas ek yi nim. Pe Piisa eim noł kanu ei si kindpi, noł peł ełe pupu, Jiisas mułum konu bii ni pum. ");
INSERT INTO nii_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ba eim konu pop owundu tang, eim mund mong erim. Erpi, noł ełe si mani simbii ni erim. Erpi, eim wii dinga topu yi nim, “Owundu, nim na paki to!” nim. ");
INSERT INTO nii_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jiisas eim sikir opu, angił mani kindpi, Piisa ambił tonu sim. Sipi yi nim, “Nim pii gii dinga pinałim. Nim nimbił erang nim na kin pii gii ninan?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Pe wu tał noł kanu ełe tonu pangił, konu pop owundu tum ni poru nim. ");
INSERT INTO nii_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Noł kanu ełe mulnjung wu ombu, en enim Jiisas kin men tok erik Gos embe ambił tonu kindik, “Nim Gos kingam keimi mołun,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Galilii noł gopu ei orundung puk si kindik, Genesares konu orung tor punjung. ");
INSERT INTO nii_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wumb konu ełe wumb, Jiisas piik poł tok yi ełmin. Erik, “Wumb ening pim wumb tu wei!” pa nik kindnjing. ");
INSERT INTO nii_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Wumb en enim ek dinga nik yi ninjing, “Wumb ening pim wumb ei, ok nim konduk embiłngii,” pa yi nengin, ening pim wumb ei ok Jiisas kon ełe embiłangin, ening pim wumb pei ka mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kunum ełe, lo ek piiłmin wumb kombur ni lo ek emb tołmun wumb kombur ni Jerusalem konu si kindik, Jiisas mułum konu tor onjung. Ok yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nimbił erang nim nge ekii siłmin wumb ei sinim ok kupenjpin noł, ‘Erei!’, nik oł ei enarik, kuni nungii kunum ei, angił was enanmin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jiisas ek nipi orung kindpi yi nim, “Nimbił erang en enim nge ełmin oł ei ekii sinmin. Sik, Gos nge lo ek ei si kindinmin min? ");
INSERT INTO nii_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gos ek yi nim, ‘Nim arnim manim ningii ek ekii sik erngii,’ pa nim. ‘Pe wu endi arim mam kin ek kis nipi ngopu erim kin, eim to kundngii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ba en enim yi niłmin, ‘Wu endi eim epi pei sałiłim wu, ei eim arim mam paki tumba,’ ba ei eim ek yi nimba, ‘Na epi ei Gos ngumbii nipi poru ninj,’ pa yi niłmin. ");
INSERT INTO nii_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ernjing, menjing ei er ka erngii mił mon nik, en enim ełmin oł ei erik, Gos nge ek to mani kindik, en enim ełmin oł ei ambił tonu kindiłmin. ");
INSERT INTO nii_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Enim ek kend nge wu ombu, Aisaiya Gos ek ni tor kindiłim wu enim kin ek keimi kun yi nirim. ");
INSERT INTO nii_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Eim ek yi nim, ‘Wumb tiłap ombu en enim gupu ełe na embe ambił tonu siłmin. Nga en enim nge noman ei na kin am turii sałiłim. ");
INSERT INTO nii_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","En enim wumb lo pendik ełmin ek ei ni tor kindik yi niłmin, Gos nge ek ni tor kindinmin,’ pa yi niłmin. ‘Yi nik kin na kin men tok wii nił nik yi ełmin,’” pa nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jiisas eim wu amb pei wii topu, “Wei!” a nim. Nipi yi nim, “Enim piik kun erngii. ");
INSERT INTO nii_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wumb epi nangin mani punum ei kis mon. Mer gupu ełe ek nengin tor onum ek, ei erang, wu noman tuk ei penj kun ka pinałim mon.” ");
INSERT INTO nii_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kunum ełe eim nge ekii sik ełmin wu ombu ok, eim kanik yi ninjing, “Lo ek piik ełmin wumb, nim nin ek ei piik, kis piinmin ninjing ek, ei nim piin min mon?” ");
INSERT INTO nii_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eim yi nim, “Emb epi kanim kanim endi nanim Arnan tonu epin mołum ei erip tał pendnenim, epi endi kapłi dumbuł pei puł erngii. ");
INSERT INTO nii_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Enim kan wiik tei! Wumb ei ningił tumbun mułum wumb, ei puk, ningił tumbun mołum wumb kombur andłam andan tungii enmin. Pe ningił tumbun mułum wumb endi pupu, endi andłam andan tumbii ni ermba, ei wumb tał ouni bok tunguł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piisas ek nipi orung kindpi yi nim, “Nim ek ekin ei pułe ni peni ełe kindan, sin piimin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jiisas ek yi nim, “Enim yi ku noman kun ka pinałim, wumb eipi mił mołmun. ");
INSERT INTO nii_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Enim piinanmin, wumb kuni gupu kindiłmin, epi nok mani kindinmin ei, mer kirim ełe punum. Pupu, nga sipi tor kind si kindinmin. ");
INSERT INTO nii_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ba epi noman tuk pałim, nik tor kindinmin ei, noman ełe tor onum. Epi ei mendpił wumb erpi kis mondnum. ");
INSERT INTO nii_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nga wumb noman tuk ełe tor onum ei yi mił, ek kis nik, epi waning erik, wumb to konduk, amb eipi ngunduk, oł kis eipi erik, epi waning sik, ek kend tok erik, wumb kin ek buł ambił erik yi ełmin. ");
INSERT INTO nii_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Oł eipi oł ombu erpi wumb er kis mondułum, ba wumb endi angił was enarpi kuni nołum, ei wumb er kis penj mundnałim mon,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jiisas konu ełe si kindpi, pupu Taiya kin Sairon konu ełe mandi tor pum. ");
INSERT INTO nii_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Keinan konu ełe wumb tiłap eipi, amb endi opu konu ełe mułum. Amb ei opu, ek dinga nipi yi nim, “Owundu, nim Deipis nge kingam, nim na kin kaimb se. Na nge ambił ei gui kis ei er kis mundang mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ba Jiisas ek endi nipi ngunerim mon. Eim nge ekii sik ełmin wu ombu ok, ek dinga ninjing, “Amb ei eim wii dinga topu sinim onjpun konu onum ei, nim eim orung kindan orung pangłi!” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jiisas ek orung kindpi yi nim, “Gos na kindang op Esrel wumb kung siipsiip mił am punjung ei, mendpił sip orung simbii nge onj.” ");
INSERT INTO nii_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amb ni opu, eim simb ełe mani ming gopsing pii połpu ek yi nim, “Owundu, nim na paki to!” ");
INSERT INTO nii_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jiisas ek nipi yi nim, “Sinim kangił kuni sipin, owu ngunermin ei, oł kun pinałim mon.” ");
INSERT INTO nii_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Amb ei yi nim, “Owundu, nim ek keimi nin, ba wumb en enim kuni nołmun kuni ełim mani pułum ei owu nołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Amb ni ek yi neng kin Jiisas ek nipi yi nim, “Amb, ninim pii gii na kin ei owundu tonu om, epi ninim piin mił yi tonu omba.” Yi neng kin, kunum ełe mendpił amb ei ambłam ka wii mułum. ");
INSERT INTO nii_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jiisas konu ełe si kindpi, pupu noł gopu Galilii niłmin konu ełe tor pum. Pupu, komung endi ełe tonu pupu, mei ełe mułum. ");
INSERT INTO nii_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Wumb tiłap owundu endi ok, eim mułum konu onjung. Ok, wumb ningił tumbun mułum, ni kom ngang ek piinenjing wumb, ni simb angił kis mułum wumb pei sik, eim mułum konu tu wunjung. Tu wuk, Jiisas mułum konu simb ełe mandi tuk mundangin, Jiisas eim wumb pei er ka erim. ");
INSERT INTO nii_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Yi mił erang kin, wu amb pei noman nendii tok piinjing. Nimbił erang wumb ek tingnenjing wumb ei, nga ek tengnjing; nga simb kis mułum wumb ei nga simb ka mułum; ningił tumbun mułum wumb ei, nga ningił ka mułang kenjing. Gos oł ei yi mił erang kin, wumb en enim Esrel nge Gos embe ambił tonu kindnjing. ");
INSERT INTO nii_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiisas eim nge ekii sik ełmin wu ombu, wii tang wangin kin ek yi nim, “Wu, amb ombu na kaimb kis piind,” pa nim. “Wumb kunum tekliki pe na kin mulnjung, pe wumb kuni tang piinmin ei, na nga orung pei nimbii kaimb enim. Nimbił erang wumb ei dinga sinerang, ngii konu bin ni puk, kumb kuni tang mełiłim tumba.” ");
INSERT INTO nii_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jiisas nge ekii sik ełmin wumb ok ek yi nik, “Ya konu ełe orung orung ei wumb mulałmin, sinim kuni jiłi orung sipin wumb ombu kuni ngumun?” ");
INSERT INTO nii_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jiisas eim ek nipi kii sim, “Enim bres nimberii sałim?” Wu ombu yi ninjing, “Sin bres, angił orung nga tał ni omu endeim endeim ni sałim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pe Jiisas ek nipi wumb ngang, wumb pei mei ełe mani puk mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Pe eim bres pei sipi, omu ombu sipi, eim Arim Gos kin prei erpi ngopu, kuni ombu sipi eim nge ekii sik ełmin wu ombu ngang, wu ombu sik mok tok wumb mulnjung wumb, ei ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Wumb pei kuni nok pangin, pinang pang kin, kuni orung mułum ei kon angił orung nga tał, takik piki tunjung. ");
INSERT INTO nii_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kuni nunjung wu ei 4,000 pei mendpił nunjung. Nga amb, kang ambił angił pendik tuk kindnenjing mon. ");
INSERT INTO nii_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jiisas wumb ei pei nipi kindpi, eim noł kanu endi sipi, pupu konu orung Makaran ni konu ełe orung pum. ");
INSERT INTO nii_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jura wumb wu num ombu lo ek ekii sik ełmin ni wumb kolk nga konj angk tonu onerngii ni piik wumb ok, Jiisas kanik, eim nimba ek piimin nik eim ermba mił kenmin nik yi ninjing. Nik, “Eim epin konu ełe jep oł andan topu oł, endi erangłi!” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ba Jiisas eim ek orung kindpi yi nim, “Konu pou nipi, eni mani pang, enim molk kunum ka simba niłmin. Ei nimbił erang kupu muł kundii erang kanik niłmin. ");
INSERT INTO nii_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Konu kupiiring okrii ni molk, konu kupu ping erpi ełim ei, enim molk konu pop topu, kumb owundu tumba, nik ełmin. Ba akip kunum ei, na jep oł kanim kanim end oł ei, enim kapłi pii poł tunanmin mon. ");
INSERT INTO nii_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Enim wumb kis molk kin oł kis ełmin. Enim molk jep oł andan topu oł kenmin ninmin, ei na kapłi enermbii. Jep oł andan top ermbii oł ei, Gos ek ni tor kindiłim wu Jona kin ełim jep oł andan tum oł, ei mendpił. Wumb Jona ołup tok, noł ełe mani kindnjing kin, ba nga Gos eim sipi, tonu orung sipi konj mundum.” Eim yi ni pendpi poru nipi, wu ombu si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jiisas eim nge ekii se ełmin wu ombu, noł gopu ełe tumb tok puk, ba en enim kuni bres ni epi endi sik nungii ei, piinarik pendik puk. ");
INSERT INTO nii_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jiisas eim ek nipi yi nim, “Enim kan kun er mułngii! Jura wumb wu num ombu lo ek ekii sik ełmin wumb ni wumb kolk nga konj tonu puk piinałmin wumb ei kin ek kend tok ek ak mak erik ei yiis bres ełe tok kindangin opu tonu ołum ei mił yi erngii. Ei enim piik kun erik mułngii. ");
INSERT INTO nii_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jiisas nge ekii sik ełmin wu ombu ek enim kin ek nik yi ninjing, “Eim yi mił neng kin, ‘Sin bres tu wunenjpin,’” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ba Jiisas eim bres ni kuni epi sinałim ni piipi kin eim ekii siłmin wumb kin ek yi nim, “Enim wu pii gii dinga pinałim mił wu, nimbił erang enim en enim kin ek nik orung orung kindik enmin?” ");
INSERT INTO nii_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Enim ek ei piinanmin min? Na bres angił orung ei wumb 5,000 pei ngamb nunjung. Nangin, enim kuni orung mułum ei, kon nimberii kon tunjung ei piinmin min? ");
INSERT INTO nii_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pe nga bres angił orung nga tał ei wumb 4,000 pei ngamb nunjung. Nga kuni orung sik kon nimberii tunjung? ");
INSERT INTO nii_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nimbił erang enim piinanmin na enim bres nga ek kun ninand mon? Na nind ei, enim Jura wumb wu num ombu wumb ei ok ek kis ka pei pei nik, kend tok erngii ek ei, piip nind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yi mił neng kin, wumb ei nim ek ei piinjing bres ełe kuni yiis mon ek eipi endi ninmin, ni piingii, Jura wumb wu num ombu ei lo ek emb tołmun ek pei nga emb tunjung. Wumb ombu en enim oł yi mił ełmin ba noman tuk ka wumb eipi kin ngonałmin mon. ");
INSERT INTO nii_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jiisas pupu Sisariya Pilipai konu ełe pum. Kunum ełe eim nge ekii sik ełmin wumb kii sipi ek yi nim, “Wumb pei na embe nii niłmin?” ");
INSERT INTO nii_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eim nge ekii sik ełmin wu ombu yi ninjing, “Wu kingam wumb kombur, ‘Nim Jon wumb noł pendiłim wu,’ ninmin; nga wumb kombur, ‘Nim Elainja,’ pa ninmin. Nga wumb kombur, ‘Nim Jeremaiya ek ni tor kindiłim wu endi,’ pa ninmin. Wumb kombur molk, ‘Nim Gos oł ekii se ermba oł ei piikin niłim wu,’” pa ninmin. ");
INSERT INTO nii_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pe Jiisas eim ek nipi yi nim, “Enim na nii ninmin?” ");
INSERT INTO nii_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Piisa ek yi nim, “Nim Krais, nim Gos nge kingam molkun, wumb noman konj ngan, wumb konj mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jiisas ek nipi ngopu yi nim, “Saimon, nim Jon kingam ka piinjii. Ya mei ełe wu endi nim ek ei ni neng, nim ninan mon. Na Ernan tonu epin mołum ei, nim ek ei nipi nim ngonum. ");
INSERT INTO nii_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Piisa, na nim kanip nind. Pe na Gos nge ngii tekmbii ei, ya ku peł ełe tekmbii. Ku peł ełe tekmbii, nim embe ei pułe Piisa ei ku mił. Pe wumb kułngii konu kis ełe nge dinga ei, to mani kindnermba mon. ");
INSERT INTO nii_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Na Gos sinim tep er mołum konu ei kii wał sip, nim ngumbii. Epi nim mei konu ambił gii nin epi ei, tonu epin Gos ambił gii nimba ku. Nim mei ełe epi endi si kindin kin, tonu epin Gos epi ei si kindmba ku.” ");
INSERT INTO nii_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jiisas eim nge ekii sik ełmin wu ombu kanpi kin ok yi nim, “Enim wumb endi kanik na Krais Gos kindim wu mei mani om, ninerei mon!” nim. ");
INSERT INTO nii_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kunum ełe Jiisas eim Jerusalem konu ba nge pułe andan tum. “Wumb noman peng pim wumb ni, Gos kin kułmał kałiłmin wumb, ni lo ek emb tołmun wumb pei ok, eim ngenj kumbii ngungii. Ngok, to kundngii, tukpu konu mani pupu, epi nga kunum tekliki ełe tonu opu konj ba, ek ei ni tor kindim.” ");
INSERT INTO nii_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piisa eim sipipi tor sipi eim ek kis ngum. Ngopu ek yi nim, “Owundu, nim ek keimi ninan, nim nin ek ei tonu onermba mon.” ");
INSERT INTO nii_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jiisas kan ak topu, ek nipi Piisa ngum, “Seisen, nim na buł morung pui! Nim na kin ek eipi ninjii en? Nim Gos nge ermba oł ei piinan mon. Nim wumb noman ełe erngii epi ei mendpił piin!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kunum ei Jiisas eim ek nipi eim nge ekii sik ełmin wu ombu ngum, “Wumb endi na kin ekii simbii ni piimba wu, ei eim noman to piinarpi kin, eim ond peri ei kou sipi, na bii konu ekii simba. ");
INSERT INTO nii_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wu endi eim nge noman konj peng ka moł ni piimba wu, ei eim noman konj am ba. Wu endi na nge piipi erang, eim noman konj am ba; ei eim noman konj ei nga sipi orung simba ku. ");
INSERT INTO nii_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wu endi eim mei ełe epi piipi si kułou topu er mułang, eim noman konj kułmba ei, mei ełe epi er sipi orung simba mił nenj? Nga eim epi nipe endi eim noman konj ei nga top er sipi orung simba ei epi sinałim. ");
INSERT INTO nii_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Na tonu epin si kindip, mani op wu kingam tałip onj. Kunum ei Arnan Gos nge tiłang owundu ei kin enjel ni ouni ongii. Kunum ełe, na ek keimi ni pendind mił keimi tor omba ei, en enim oł erngii mił yi ku, Gos eim enim kumep orung kindmba.” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Na ek keimi nip enim ngond, wumb kombur ya ełe angiłmin wumb ei, konj mułngii. Mułangin, na wu kingam ei king mołup ombii,” pa nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pe kunum angił orung nga endeim poru neng, Jiisas eim Piisa sipi, Jeims angim Jon kin nipi, seng puk tonu komung owundu endi ełe tonu punjung. Komung ei am ei tonu sim konu, en enim mendpił mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jiisas nge ngenj ei nga ngenj endi eipi mił peng kenjing. Eim kumb ningił ei eni topu tiłang enim mił, yi tiłang owundu erim. Nga eim alap ełe kuru mił tiłang erim. ");
INSERT INTO nii_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moses kin Elainja tał ouni tor okuł, Jiisas eim kin ek tangk kenjing. ");
INSERT INTO nii_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piisa ei kanpi kin eim ek yi nim, “Owundu, sinim ya mołmun ei ka wii. Nim kapłi nin kin, ya ełe na ngii tika tekliki tekmbii. Endi nim nge; nga endi Moses nge; nga endi Elainja nge,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ek nipi mułang, kupu kuru tiłang owundu erpi opu, wu kei enjing konu om. Kupu ei opu wu kei kin pełi erim. Erang, kupu tuk ełe Gos ek endi tor om ei yi nim, “Ei na nge kingam, na eim kin noman ka wii ngond. Na eim ka wii piind; nga enim eim ek piingii.” ");
INSERT INTO nii_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jiisas nge ekii sik ełmin wu ek ei piik, mund mong erik, mani mei ełe puk pinjing. ");
INSERT INTO nii_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jiisas eim mandi opu, wu ombu embłim. Ambiłpi, ek nipi ngopu yi nim, “Enim mund mong enerei mon!” nim. ");
INSERT INTO nii_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pe wu kei tonu angk kenjing ni, wumb endi mulenjing; ba Jiisas eim mendpił mułum kenjing. ");
INSERT INTO nii_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jiisas ni wu kei kin komung ei si kindik mani puk, Jiisas eim kin ek nipi ngum, “Enim pe kanik onmun, ei wumb eipi kanik ninerngii mon. Pepi, pang pang tonu epin si kindpi mani mei ełe opu, wu kingam mił mołpu kołpu, nga opu konj pum kin, ek ei tor pangłi,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jiisas eim nge ekii sik ełmin wu kei eim kin kii sinjing, “Nimbił erang lo ek emb tok mołmun wumb ei, Elainja kumb se omba ninjing?” ");
INSERT INTO nii_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jiisas ek nipi orung kindpi yi nim, “Ei keimi! Elainja eim kumb se omba. Opu, oł kanim kanim ei er kun ermba nge omba. ");
INSERT INTO nii_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ba enim kanip nind, Elainja ok om ba wumb eim om mił pii kun enenjing. Enarik, en enim noman ełe eim kin oł kanim kanim erik enjing. Yi mił ku, akip tonu epin si kindpi, mani mei ełe om, wu kingam ei ngenj kumbii simba ku.” ");
INSERT INTO nii_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jiisas ek yi neng kin eim nge tekliki ekii sik ełmin wu ombu piinjing ei, Jon wumb noł wii pendiłim wu ei, kin ninim ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pe puk, wumb tiłap owundu endi tor onjung konu ełe, wu endi Jiisas kin tor opu, ming gopsing pii połpu, eim simb ełe mani opu mołpu mei ełe pim. ");
INSERT INTO nii_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Pepi, ek yi nim, “Owundu, nim na kin kaimb piin kin, nanim kangi ei noman wulu mił pang, pupu dup peł ełe pułum; nga noł tuk pupu, eim ka mulałim mon. ");
INSERT INTO nii_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Na sip tu wup, nim nge ekii sik ełmin wumb mulnjung konu ninj ei, wu ombu kapłi ka enenjing mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jiisas ek nipi orung kindpi yi nim, “Enim wumb tiłap pei pii gii pinerim; nga enim noman tuk kun ka pinerim wumb. Kunum nimberii na enim kin kongun er mołamb kin, enim Gos nge noman dinga ei pii poł tungii? Enim kangi ei na kin tu wei!” nim. ");
INSERT INTO nii_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jiisas kangi ni tu wangin, gui kis ni ek ngopu tor kindim. Kindang, kangi ei pe mendpił ka wii mułum. ");
INSERT INTO nii_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jiisas eim nge ekii sik ełmin wu mendpił ok, Jiisas kanik ek nik kii sinjing. “Nimbił erang sin gui kis ei to tor kindnenjpin?” ");
INSERT INTO nii_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Eim ek nipi orung kindpi yi nim, “Enim pii gii aninga mendpił pim. Peng kin, enim ermin ni enjing kapłi enerim. Na enim kin ek keimi nip enim ngond, enim pii gii ei kuni maser mong kembis wii ei sem simbii mong mił yi pim kin, enim mei komung ya pałim ei mon, pukun orung ełe pui,” nengin kin ba. Pe enim epi endi ermin, ni pii gii, epi ei kapłi erngii. ");
INSERT INTO nii_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ba andłam eipi endi seng, gui kis ei mił to kindmin mił mon. Ba prei erpin ngopun, kuni mowii pepin ermin ei, mendpił pałim. Epi endi eipi kapłi enermba mon.” ");
INSERT INTO nii_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","En enim puk Galilii konu o ende puk molk, Jiisas ek nipi eim ekii sik ełmin wumb ngum. “Na tonu epin mani mei ełe op wu kingam moł. Mołamb, wumb na sik, opu orung wumb ok angił ełe ngungii ei, piip nind.” ");
INSERT INTO nii_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nipi yi nim, “Pe na to kundangin kułmbii; tukpu konu pep kunum tekliki opu pang, nga angip tonu op konj bii,” pa nim. Jiisas eim ek yi neng, eim nge ekii sik ełmin wu ombu noman embin tang piik mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ekii se puk, Kapaniyam konu ełe tor punjung ni men ngii owundu ełe andik men ngii ku takis siłmin wumb ei ok Piisa kii sik yi ninjing, “Enim nge ek emb topu ngołum wu, men ngii owundu ełe ku takis tołum min mon?” a nik. ");
INSERT INTO nii_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piisa ek nipi orung kindpi yi nim, “Owa, eim enim.” Nga Piisa eim pupu ngii ełe nirik pum, ba Jiisas Piisa kin opu kii sipi ek yi nim, “Saimon, nim noman nipe noman piin? Ya mani mei ełe wu num ei eim kingam amb seng kuimi ngum, ba nga wumb eipi ei wu num eim paki yi ku tum. Tum ełe wumb, nii endi epi ei nga ngopu orung wu eim kin kindngii?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piisa ek nipi yi nim, “Wumb tiłap eipi kin ngołmun,” pa nim. Jiisas ek nipi ngum. “Yi erpi kin, eim nge kingam ku ni epi ngopu orung kindnermba. Yi mił, na Ernan ngii konu ku takis kindnermbii ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Pe sinim yi eramin kin, wumb ei sin kin kis piingii ei mon. Nim pukun, noł gopu ełe omu wuk kindan, omu endi ok tonu opu pim kin, sikin, gupu ełe ambił aki tokun kenjii ni, ku monii endi pimba ku ei, tu wukun wumb ei ngunjii. Ngunjii ku ei, wumb ei nge tiłap ouni ngunjii; ei kapłi ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kunum ełe Jiisas nge ekii sik ełmin wu ok kin ek yi ninjing, “Wu nii endi Gos sinim tep er mołum konu ei wu owundu mendpił mołum?” ");
INSERT INTO nii_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jiisas eim kangi kembis endi tu wupu, tuk mulnjung konu ełe engndim. ");
INSERT INTO nii_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Eim ek nipi yi nim, “Na ek keimi nip enim ngond. Enim ok kangił kembis mił ek keimi ni piik mulnjung kin, enim Gos sinim tep er mołum konu ełe tuk punerngii. ");
INSERT INTO nii_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Wu endi eim ngenj ei mani kind si kindpi, eim noman to piinarpi mułmba wu ei Gos sinim tep er mołum konu wumb tuk mułngii ei, to mani kindpi mołum kumb ełe ba. ");
INSERT INTO nii_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nga wu endi na nge embe ełe piipi kangił ei mił ‘Oi!’ a nipi, eim ngii ełe nirik simba wu ei, na yi ku, ‘Oi!’ a nipi, eim ngii ełe nirik simba,” Jiisas eim ek yi nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Wu endi opu, na kangił mołmun ei na kin pii gii peng mołmun ei to kis ermbii ni ermba wu ei, eim kumep owundu kis mendpił ei eim simba. Ba wu ei kom ku owundu endi sik num goltum ełe kan kulk sipik, ep noł mii ełe to mani kindngii wu ei, kumep kembis simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Mei wumb kaimb kis piind. Wumb eipi ei ok kin wumb, na kin pii gii ninjing wumb ei si tor singii. Keimi, oł ei mił tonu ołum. Ba wumb nii endi wumb ei oł yi mił erngii nipi si tor sim wumb ei, eim kin oł embin tui kis endi ei eim kin tonu omba. ");
INSERT INTO nii_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Pe nim simb min angił ei endi Gos buł ngopu ermbii ni erim kin, endi kiłpi to si kindnjii. Yi erang kin, ninim simb endeim min angił endeim ei peng konu ka ełe punjii ei ka. Simb angił orung orung ouni pimba ei, dup konu tukpu ełe mani kindngii ei, kulałmin kunum kunum dup no mułmba. ");
INSERT INTO nii_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pe ninim ningił ei erang kin Gos buł ngokun si kindkin en kin kapłi ninim nge ningił kopiskin tor sikin, olkup tokun si kindnjii ei, ninim konj mulnjii. Nim ningił endeim peng konj mulnjii ei kapłi, ba nim ningił tał pim kin, nim oł kis kanim kanim eran kin, nim olkup tok dup konu kindngii ei kis.” ");
INSERT INTO nii_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Enim kan kun er mułngii; tuk kangił kembis mołmun ei epi wii mon. Na enim kanip nind, tonu epin en enim enjel tep ełmin ei, na Ernan tonu epin mołum ei mandi mołmun piiłmin. ");
INSERT INTO nii_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Nimbił erang na tonu epin si kindip, ya mani mei ełe op tełim moł. Mołamb, wumb am punjung ei, sip orung simbii nge onj.) ");
INSERT INTO nii_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Enim er piinmim mił nenj? Wu endi eim kung siipsiip 100 pei mulnjung ei, endeim am pum. Ei eim kurnermba min? Ei mon. Eim kung siipsiip 99 pei tonu komung ełe mond si kindpi, eim pupu, kung siipsiip endeim am pum ei kurpu ba. ");
INSERT INTO nii_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na ek keimi nip enim ngond, wu ei pupu, eim kung siipsiip ei kan sim kin, eim ka wii piimba. Nga eim kung siipsiip 99 am punenjing ei kin ka wii piinałim mon. ");
INSERT INTO nii_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Yi mił ku, sinim Erinjpin ei tonu epin konu mołum, ei eim tuk kangił kembis mołmun ei am punerngii ni piinim.” ");
INSERT INTO nii_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Pe ninim angnim ei oł kis nim kin erim ei, pe nim pukun eim kin molkun, eim oł erim ei andan tunjii ba eł ełip mendpił konu koi erkił ek ningił. Ek yi nen ninim, angnim nim ninjii ek ei piim kin, ninim angnim si orung sinjii. ");
INSERT INTO nii_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ba wu ei nim ek piinerim kin, nim pukun nga wu tał nga sinjii. Sen, enim tep to pungii. Puk, wu tekliki ni tał ni ek ni tor kindngii ei, Gos nge ek ninim mił yi erngii. ");
INSERT INTO nii_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ba eim wu ombu ek piinermbii nim kin, nga pukun Gos nge tiłap men ngii endi wumb mołmun ełe sipnjii. Nga eim Gos nge tiłap wumb ei ningii ek piinermbii nim kin, enim yi mił piingii wu ei torung pii gii ninanim wu, ni ku takis sipi ełmin wu ei mił mołum.” ");
INSERT INTO nii_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Na ek keimi nip enim ngond. Pe nga enim kin ya mei ełe oł endi wumb erngii ei, enim buł ngok noman to piinenjing kin, ei yi ku Gos tonu epin konu mołum buł ngopu noman to piinermba. Pe nga ya mei ełe enim kin oł endi wumb erngii oł, enim noman to piinjing kin, ei yi ku Gos tonu epin konu mołum yi mił ermba. ");
INSERT INTO nii_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Na ek nga nip enim ngond. Enim tuk mei ełe mołmun ei wu tał eł ełip noman ende sekił prei erkił, epi endi simbił ningił. Ei na Ernan epin mołum ei, kapłi paki tumba. Topu singił, epi ei ngumba. ");
INSERT INTO nii_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Keimi, wu tał min tekliki mił molk, na nge embe piik tuk kułou tungii ei, na op tuk ełe op mułmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kunum ełe Piisa opu ek kii sipi Jiisas ngum, “Owundu, kunum nimberii na engnan opu oł kis endi na kin erang, na eim si kindip ngumbii. Kunum angił orung nga tał min?” ");
INSERT INTO nii_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jiisas ek nipi eim ngopu yi nim, “Nim kunum angił orung nga tał nin ba na nim kanip nind, kunum kunum pei eim nim kin oł kis ermba, ei kil ngunjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Yi mił eran, Gos sinim tep er mołum oł, ei yi mił king owundu endi mołpu, eim kongun wumb eim epi se no pendngii, ei eim mołum ei er kun ka erpi, akip tor sipi yi ełim. ");
INSERT INTO nii_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pe wu king ei eim wumb ei epi se nok pendiłmin ei, akip orung simbii nipi kongun pułngun mondup erang, wumb wu endi eim kin tu wunjung. Wu ei ku owundu kis dinga er sipi no pendim. ");
INSERT INTO nii_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ba wu ei ku kapłi ngo orung kindmba mił pinerim mon. Yi peng kin, eim nge wu owundu king ei mołpu yi nim. “Wu ei eim ambim ni eim kingam ambiłim noł nin eim epi kanim kanim pei wumb ngok, ku singii. Sengin, ku ei nanim kin orung omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yi mił neng kin, wu ni opu, king enim konu simb ełe mani mei ełe pepi, ek dinga nipi yi nim. ‘Wu owundu, nim na kin kaimb sin kin, na kindan andip kapłi ku epi kanim kanim na sip no pendinj, ei kapłi ngo orung kindmbii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pe wu owundu ni eim kongun wu ek nim mił, ei piipi, kaimb sipi, ku no pendim ku ei kapłi ngo orung kindmba pinerim ku, ei nim, ‘Epi endi ngunerii mon ku!’ nim. Nipi, nga eim noman ełe to piinerim mon. ");
INSERT INTO nii_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kongun wu ni eim si kindpi pupu, nga eim angim kongun wu endi eim ku sipi no pendim wu ni om konu ambił gii nip, yi nim, ‘Na ku sikin no pendin ku, kapłi pe mendpił ngo orung kindnjii!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yi mił neng kin, angim kongun wu endi ni mani mei ełe ming gopsing pii połpu ek dinga nipi yi nim, ‘Nim na kaimb piin kin, kapłi kui er mułan, na andip kapłi, nim ku ngo ninim kin orung kindmbii.’ ");
INSERT INTO nii_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ba eim mon nipi, sipipi kan ngii ełe pindamb, ‘Kapłi, eim nanim ku sen mił ngo orung kindpi poru nipi, kan ngii tor omba,’ nipi yi nim. ");
INSERT INTO nii_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","En enim kongun wu endi oł ei kanik, noman embin to kis piinjing. Piik, puk, wu owundu mułum konu kanik erim oł mił pei nik, wu owundu ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yi mił nengin kin, wu owundu ni kongun wu ei wii to nirik sipi yi nim, ‘Nim kongun wu kis, nim ok na kin ke nen, na nim ku owundu kis no pendin ei ngo orung kindnerii mon nip, nim kaimb sip mon minj. ");
INSERT INTO nii_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na nim kin kaimb sip ngunj, ei mił ku nim kongun wu endi ombu kin, yi mił ku kaimb sinjii, ba nimbił erang yi mił enen?’ ");
INSERT INTO nii_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Yi nipi, wu owundu wu ei sipi kindang, wumb eim sipi kan ngii kindnjing ełe pepi mołum. “Eim wu owundu kin ku sim mił ngopu poru nipi, eim kapłi kan ngii ełe si kindpi tor omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jiisas eim ek nipi poru nipi yi nim, “Pe en enim nge noman ełe enjing oł kis ei si kindnenjing kin, na Ernan tonu epin mołum, ei enim kin yi ku ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jiisas ek ei nipi poru nipi pendpi, Galilii konu si kindpi, pupu Juriya konu owundu ei si kindpi, pupu noł tungun orundung Joran ni konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wumb pei eim pum konu ekii se punjung; ening pim wumb pei tu wunjung, ei er ka erpi yi erim. ");
INSERT INTO nii_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lo ek emb tołmun wumb ei, ok Jiisas nimba ek piimin nik, kii sik yi ninjing, “Wu endi kapłi eim amb kiłpi to si kindmba ei, sinim lo ek ełe kapłi yi ermba ninim min mon?” ");
INSERT INTO nii_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pe eim ek nipi orung kindpi yi nim, “Enim Gos nge ek ei ger kinenjing min? Gos epi am pei kumb ok eririm, Gos eim ei kumb ok wu kin amb tał eririm.” ");
INSERT INTO nii_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ek yi nim, “Peng kin, wu ei eim mam arim si kind opu, eim ambim kin o dambiltpi ende punjnguł. Pukuł, wumb tał nga o endeim molkuł poru ningił. ");
INSERT INTO nii_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yi mił wu amb wumb tał mon, wumb endeim. Gos epi erpi ende kindpi pendnim ei, pep poru ninim ei, nga wumb endi to eipi eipi kindnermba mon.” ");
INSERT INTO nii_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Wu ombu ek dinga nik yi ninjing, “Nimbił erang Moses lo ek yi niłim, wu endi amb kiłpi tumba ei, pipe mon endi eim ambim ngopu, kapłi si kindmba nirim? ");
INSERT INTO nii_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jiisas eim ek nipi orung kindpi yi nim, “Moses enim embnjing to tor kindngii nirim ei, nimbił erang Moses nirim ek ei enim piinarik, buł ngok yi erangin kin, Moses yi nirim, ba kumb ok Gos epi kanim kanim pei eririm kunum ełe oł yi endi tonu wang enałmin mon. ");
INSERT INTO nii_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pe wu endi eim ambim eim kin mandi mularpi, wu eipi kin ningił erang wu ei eim ambim tor kindpi, nga pupu amb konj simba ei, Gos nge lo ek ei wu to kis enim, oł kun pałim mił enanim,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jiisas eim nge ekii sik ełmin wu ombu, ek nik ngok yi ninjing, “Oł yi pimba ei, wam ambim tał, eł ełip kongun nikił kun erngił, yi pimba ei wu pupu, nga amb konj sinermba; nga amb yi ku pupu wu konj punermba mon ku.” ");
INSERT INTO nii_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jiisas eim ek yi nim, “Ek ei na nip ngond, ‘Ei wumb pei pei kapłi erngii oł mił mon. Ba wumb Gos kapłi paki tang ermba wumb ei, kapłi nanim nind ek ei kapłi piyangłi,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","“Pe mani mei ełe wu kanim kanim amb sinałmin wu mołmun ei, puł kanim kanim pałim. Nimbił erang, kombur menjing yi mengpi pendrim mił; nga kombur wumb erangin mołmun mił; nga kombur en enim amb sinałmin ei nimbił erang, en enim Gos sinim tep enim kongun eii ekii sik puk mułngii. Wumb ombu ek emb tołum ek, ei piik ekii sik erngii.” ");
INSERT INTO nii_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kunum ełe, wumb kangił kembis kembis kombur tu wuk ei, Jiisas eim kangił peng ełe ambiłpi, Gos kin prei erpi ngumba, ni tu wuk ba Jiisas nge ekii sik ełmin wu molk. “Kangił tu wuk ei mon,” pa nik. ");
INSERT INTO nii_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jiisas yi nim, “Enim kangił ei kun erangin nam kin wangin, enim mon nik yi enerngii mon. Nimbił erang Gos sinim tep enim oł, ei kangił yi mił mułngii wumb ei tuk pungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pe Jiisas eim angił peng ełe ambiłpi, Gos kin prei er nipi, yi er poru nipi pendpi, konu ełe si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pe wu endi Jiisas pum konu tor opu yi nim, “Ek emb tołum wu, na oł ka nimbił oł endi erip, kapłi noman konj kunum kunum ei sip kin, konj kunum kunum mołup simbii?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jiisas yi nim, “Nim na nimbił erang na kin epi ka ei kii sikin? Epi ka endi ermbii ek ei noman to piikin nin, wumb endeim mendpił ka mołum. Pe nim lo ek pałim mił piikin, ekii sikin kapłi noman konj kunum kunum mołum ei sinjii.” ");
INSERT INTO nii_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Wu ni kii sipi yi nim, “Lo nipe lo?” Jiisas ek yi nim, “Lo ek yi pałim; nim wumb endi to kundnenjii mon! Nga wu amb eipi nge ngundpu sinermba mon! Nga wumb eipi nge epi waning enenjii, mon! Nga wumb endi kin kankin ek kend to ngunenjii, mon! ");
INSERT INTO nii_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ninim arnim manim ek piikin, ekii sinjii. Pe nga ninim noman kultun mił yi wumb eipi mułngii ei, yi ku noman kulkun ngunjii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Wu kangi wu ni yi nim, “Na kumb ok kangił kembis kin moł lo ek ombu ekii sip poru nił; nga na nipe epi endi nga ermbii?” ");
INSERT INTO nii_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jiisas eim ek yi nipi ngum, “Pe ninim am wu kun ka mendpił mułmbii ni piin kin pukun, ninim epi pei wumb ngo, ku sikin ku, ei tu wukun wumb ku sinerang mułngii wumb, ei ngunjii. Yi mił en kin, nim epi ka wii pei nga tonu epin simba sinjii; nim kapłi nanim ond konu ekii sinjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pe wu ei eim ek ei piipi eim noman embin to piim. Nimbił erang wu ei eim epi kanim kanim pei sałiłim. ");
INSERT INTO nii_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jiisas eim ek nipi, eim nge ekii sik ełmin wumb ngum, “Na ek keimi nip enim ngond. Wu endi epi kanim kanim pei simba wu ei, Gos sinim tep er mołum konu ełe tuk ba, ba ei kongun dinga wii ermba. Nimbił erang eim epi kanim kanim ei erpi, eim sipi konu ka ełe kindnermba mon. ");
INSERT INTO nii_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Na ek nga endi nip enim ngond. Kung kap endi mułmba kung, ei eim kung gui ondu ełe tuk ombii ni ermba, ei kapłi enermba mon! Nimbił erang ei kung gui ondu ei dinga owii sałim. Ei yi mił ku, wu endi epi kanim kanim pei sałiłim wu ei, Gos sinim tep er mołum konu tuk ba, ei kongun dinga owii mendpił pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jiisas eim nge ekii sik ełmin wu ombu ek ei piik, puku sik yi ninjing, “Wumb nii endi kapłi noman konj kunum kunum mułmba ei simba?” ");
INSERT INTO nii_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jiisas wu kei kun kanpi yi nipi ngum, “Wumb kin epi oł yi ei kapłi enerngii ba Gos eim kapłi epi kanim kanim pei ermba.” ");
INSERT INTO nii_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Eim ek yi neng kin, Piisa ek nipi orung kindim, “Nim kenjii, sin epi pei ngii konu si kindpin, nim kin ekii sipin onjpun. Ei sin nipe epi endi simin?” ");
INSERT INTO nii_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jiisas ek nipi wu ombu ngum, “Na ek keimi nip enim ngond. Ekii se kunum tonu omba kunum ei, na tonu epin si kindip, mani mei ełe wu kingam moł. Mołamb, na opu tiłang owundu sipi king mołułum peł ełe mułmbii. Kunum ei, enim na kin ekii sinmin wu ombu ok, peł engki nga tał simba konu ełe mułngii ku. Enim wu num molk, Gos nge wumb ei tep erik kan kun er mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","“Nga wumb nii endi eim ngii konu si kindpi omba, angim aim noł nin arim mam noł nin nga eim kangi ambił nin eim mei konu si kindpi opu, nanim kin ekii sipi na kongun ermba, ei kapłi eim si kindpi omba epi mił sipi, nga mering pei mendpił pendpi sipi, nga noman konj kunum kunum mułmba ei simba ku. ");
INSERT INTO nii_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ba wumb nii endi pe opu kumb ełe bii ni piimba wumb ei, ok ekii simba. Nga ekii se ni piimba wumb endi ei ok kumb ełe ba.” ");
INSERT INTO nii_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Keimi Gos sinim tep enim oł ei yi mił, wu endi eim noł wain ond pin seng eim pupu kongun wu simbii nip kupiiring ok purum. Ei ok, noł wain kongun erngii nge nip purum. ");
INSERT INTO nii_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Eim kongun wu kombur kin ek tang piipi, noman ende sipi, kunum endeim ni wu endeim endeim kumep ngumbii nim. Pe wu ombu puk, wain tałiłim konu ełe puk kongun erngii nge nipi kindim. ");
INSERT INTO nii_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pe konu kupiiring eni 9 erang, eim nga pupu kenim ni epi top ełmin konu ełe wu kombur wii angk kongun endi enenjing. ");
INSERT INTO nii_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Pe wu ombu kanpi ek dinga yi nim, ‘Enim yi ku puk noł wain konu ełe kongun erngii,’ pa nim. ‘Erik mułangin kin na enim kongun erngii mił ku ngumbii.’ ");
INSERT INTO nii_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wumb pangin, eim nga beli kunum 12 erang, nga pou neng kunum 3 erang, yi ku erpi epi top ełmin konu wumb kurpu sipi kongun ngumba nge pum. ");
INSERT INTO nii_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nga pou pou nipi emii pimba erang kin, eim nga epi top ełmin konu ełe pupu kenim ni wu kombur nga ełe piram angik mulnjung. Mułangin kin eim pupu yi nipi kii sim, ‘Nimbił erang enim ya ełe angik mułangin kunum wii mił poru ninim?’ ");
INSERT INTO nii_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Wu ombu ek yi nik eim ngunjung, ‘Sin kongun ngumba wu mulałim.’ Pe eim ek nipi yi nim, ‘Enim yi ku puk, noł wain konu ełe kongun yi ku erngii,’ nipi kindang punjung. ");
INSERT INTO nii_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Konu eni mani pupu poru nipi emii ermba. Erang, ond wain arim opu, kongun wumb tep ełim wu kanpi yi nim, ‘Nim kongun wumb wii tokun, tuk sikin, embe sikin, ku ngunjii. Ba wumb ok kongun enjing wumb ei, ku ekii se ngunjii, nga pe ekii se tuk ok kongun enjing wumb ei, ku kumb se ngunjii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pe tep wu ni yi nim, ‘Konu pou pou nipi emii pimba erang ok, kongun enjing wumb ei wangin!’ Neng, ok pangin, kunum endeim pei ni ku kumep ngum. ");
INSERT INTO nii_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Pe nga wumb kongun ok kumb se enjing wumb ei, en enim yi piinjing, ‘Sin kongun ok enjpin, ku kopur pei simin,’ ni yi piinjing ni ekii se onjung wumb ku engki ngum mił yi ku en enim ngum. ");
INSERT INTO nii_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ngang sik pendik, ond wain kin kongun wumb kun tep ełim wu ei kin ek kanim kanim nik ek kis nik ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ngok yi ninjing, ‘Wu ekii se kongun enjing ei konu eni endi pei enenjing mon, ba sin kumb se konu eni kopur pei kongun erpin, nga tinga konu eni dinga tum konu kongun owundu enjpin,’ nik yi ninjing. ‘Ba nim wumb ekii se onjung wumb ku ngun mił sin yi ku ngun,’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wu ombu ek yi nengin, ond wain arim wu ei opu, eim ek yi nipi orung kindpi kongun wu endi mołum konu ngum. ‘Wu puł, na nim kin oł kis endi enand mon. Ba enim na kunum endeim ni ku ngumbii ninj, ei enim na kin kapłi ninjing,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","‘Nim ku se mengkin ninim ngii konu pui!’ a nim. ‘Ekii sik ok kongun enjing wumb ei, enim ku ngunj mił, yi ku ngumbii end,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‘Pe na nam ku kumep ei kapłi wumb ngop, nga sip kongun epi end ermbii. Ei na kapłi ermbii min? Enim na ku ełe kanik, pei simin na wu ka mołum ni piinmin min?’” Ond wain arim ek yi nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jiisas eim ek ei nipi poru nipi yi nim, “Pe nga wumb kombur en enim kumb simin ni piik mołmun wumb ei, nga ok ekii singii. Nga ekii sik ongii ni piinmin wumb ei, ok kumb singii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jiisas eim Jerusalem konu tonu bii ni pupu, eim ekii sik ełmin wu engki nga tał sipi sipim. Andłam ełe puk, Jiisas eim ek nipi eim nge wu ombu mendpił ngum. ");
INSERT INTO nii_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Piiyei!” a nim. “Pe sinim Jerusalem konu tonu bin onmun. Pamin! Na tonu epin si kindip mani mei wu kingam moł. Mołamb, na sik sipik, kułmał kałiłmin wumb nga lo ek piiłmin wumb ei kin ngungii. Ngangin kin, wumb ei kos piik, nga na to kundngii nge nik piik erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","“Nga na wumb ei sik, sipik, wumb tiłap eipi endi ngungii. Ngangin, wumb ei sik, na kepii tok, na kin ek kanim kanim nik, ek korum tok sipik, ond peri ełe to kundngii. Nga kunum tekliki tukpu ełe pep, nga angip op konj bii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Kunum ełe, Sependii ambim eim nge kingam tał sipi opu, Jiisas mułum konu tu wupu, eim mei ełe ming gopsing pii połpu kan, mani kan pepi prei erpi Jiisas kin epi endi kii sim. ");
INSERT INTO nii_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Pe Jiisas yi nim, “Nim epi nipe sinjii nin?” Eim ek yi nipi Jiisas kin orung kindim, “Ekii se ninim king mulnjii kunum ei, na kangi tał okuł, endi nim angił tundung mułang kin, endi opu nim angił taring mułang. Molkuł, ełip Gos nge wumb tep er mułnguł.” ");
INSERT INTO nii_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eim ek yi neng, Jiisas ek nipi orung kindpi yi nim, “Enim kii sinmin epi ei, enim pii poł tunanmin, mon! Pe enim kapłi na epi embin tui owundu pe ko wumbii er moł mił, enim yi kapłi ko wungii ku? Nga pup ond peri ełe kułmbii mił, enim yi ku kapłi erngii min?” En enim kapłi ninjing, “Sin kapłi yi ermin.” ");
INSERT INTO nii_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jiisas ek nipi ngopu yi nim, “Keimi, ełip kapłi na epi embin tui ko wumbii mił nga ełip yi ku pukuł epi embin tui ko wunguł. Ko wukuł yi erngił ei kapłi. Ba okuł endi angił tundung mułang kin, nga endi angił taring mułang yi erngił, ei na kongun mon! Ełip ngumbii mił pinałim. Wumb nii endi nanim Arnan ok konu ełe mułngii pa nimba wumb ei kapłi ok konu ełe mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jiisas eim ekii sik ełmin wu engki kei, wu angim angim tał ek ei piik kin, wu angim angim tał kin kis piik, noman embin peng yi erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ba Jiisas eim wu ombu wii tang, wangin eim ek yi nim, “Enim piinmin ya mani mei konu ełe wu king wu ei, wumb tiłap eipi ei to mani kindiłmin, en enim wu owundu ombu molk wu amb ek nik ngok yi ełmin piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","“Ba oł ei nge, ya sinim mołmun konu ełe yi tonu onermba mon. Wu endi tuk wu owundu mułmbii ni pimba ei, wumb pei paki topu, eim kongun wu mendpił mołpu, eim embe ambił mani kindmba. ");
INSERT INTO nii_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wu endi eim mołpu o kumb ełe bii ni piimba, wu endi enim mołmun konu ełe tuk mułmba, ei eim kapłi kongun wu mił enim eim no kulkuł se mułangin kin eim enim kanpi kun erpi se mułmba. ");
INSERT INTO nii_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yi mił, tonu epin si kindip mani mei ełe, na wu kingam mołup yi mił ermbii oł. Na nam op, ei opu wumb na kin kongun erik, na paki tungii nip onenj mon! Na op, wumb paki tumbii nge onj. Op, na ond peri ełe kułamb, na miyem ełe wu amb pei sip, orung simbii nge onj,” pa nim. (Ek ei eim ermba nge ei piipi nipi ngum.) ");
INSERT INTO nii_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pe Jeriko konu si kindik pangin, wumb tiłap pei Jiisas pum konu ekii se punjung. ");
INSERT INTO nii_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ningił tumbun mułum wu tał, andłam wer ełe molkuł piinjngił ni Jiisas andłam ełe ek tengpi o pang, piikił wii dinga tunjnguł. Tokuł ek dinga nikił yi ninjngił, “Gos kindim wu Krais nim sin orung sinjii wu, nim Deipis nge tiłap wu sił kin kaimb sinjii.” ");
INSERT INTO nii_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wumb pei onjung wumb ei ok kin wu tał wii tokuł yi ninjngił, “Wu ei kin ek tingneneł mon!” pa ninjing. Ba wu tał wii dinga tokuł nga yi ninjngił, “Owundu, nim Deipis nge tiłap wu nim sił kin kaimb sinjii,” pa ninjngił. ");
INSERT INTO nii_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jiisas angpi ek dinga nipi yi nim, “Na ełip kin nimbił oł ermbii ninmbił?” ");
INSERT INTO nii_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Wu tał ek yi ninjngił, “Owundu, nim sił ningił ei er ka enjii nipił ninmbił ninjngił.” ");
INSERT INTO nii_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jiisas eim wu tał kin kaimb sipi, eim wu tał ningił eł embiłang, pe sikir wu tał ningił ka wii seng kankił, Jiisas pum konu ełe ekii sikił punjnguł. ");
INSERT INTO nii_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Andłam andik puk Jerusalem konu mandi puk, Bespeis ni konu ełe komung Olip ełe tor puk, Jiisas eim ekii sik ełmin wu tał nipi kindang ok punjnguł. ");
INSERT INTO nii_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jiisas eim wu tał kin ek yi nipi ngopu kindang punjkuł. “Ełip punmbuł konu ełe alting mandi konu kembis endi sałim konu ełe, kung dongkii endi wał kin, kan kulk kindnjing pałim ei, pe ełip kan poskił se mengkił, na kin tu weł!” a nipi, kindang punjnguł. ");
INSERT INTO nii_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“Ełip pangił, wu endi ełip kii sim kin yi ningił, ‘Owundu eim kongun peng simbił onmbuł pa ningił.’ Nengił, ngumba,” pa nipi yi nim. ");
INSERT INTO nii_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","“Epi ei tonu onum ei, Gos oł ekii se ermba piik niłmin wu ek yi nik pendik mił pe keimi tonu onum pa nipi ek dinga nim,” yi nim. ");
INSERT INTO nii_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Enim Jerusalem mołmun wumb ei ningii. Pe enim nge king ei enim kin onum. Eim noman emin seng kung dongkii endi kin giiyeng giiyeng ni opu, kung dongkii wał ełe mendpił mołpu onum.” ");
INSERT INTO nii_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jiisas nge wu tał kumb se pukuł, Jiisas yi ereł nim mił, pukuł enjngił. ");
INSERT INTO nii_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Wu tał kung dongkii mam, wał tał tu wukuł, eł ełip tor konduk gulk tonu kung dongkii ełe kin sengił, Jiisas eim tonu pupu peł ełe mułum. ");
INSERT INTO nii_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pe wumb kopur pei en enim konduk tor gulk sipik, andłam ełe kumbuk sinjing. Wumb kombur ond onguł tok sipik, andłam ełe sinjing. ");
INSERT INTO nii_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Wumb pei kumb se pangin, nga kombur ekii se Jiisas pum konu ełe puk, wii dinga tok yi ninjing, “Deipis nge kingam eim embe ambił tonu kindamin tonu pangłi. Gos eim wu ei kin noman ka ngumba, wu ei Owundu nge embe ełe onum. Gos embe am ei tondrung pangłi!” pa nik yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jiisas Jerusalem konu owundu ełe tuk pang, wumb kanik, puku sik noman kanim endi eipi mił piik. “Wu ei nii?” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Wumb punjung wumb ei yi ninjing, “Wu Gos oł ekii se tonu omba ei piipi niłim, wu Jiisas eim Nasares konu Galilii mei konu owundu ełe wu,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jiisas pupu, Gos men ngii owundu engim konu nirik pupu kenim ni wumb puk, epi top erik enjing ei, en enim kung ni kei ni epi ei sik Gos kin kułmał kełngii enjing. Wumb en enim ku sik erik mulnjung ei, kanpi to makrip anda kindim. Kindpi, ku tonu peł ełe ku mong erik kin, nga epi top erik, mulnjung wumb ei to pułpeł topu, nga peł ambiłpi sipi ak topu yi erim. Nga kei ni peł ełe ku sek enjing wu ei mulnjung konu peł ełe, ambiłpi sipi ak topu, yi erpi to kindang, si kindik anda punjung. ");
INSERT INTO nii_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Eim wumb kin ek dinga nipi yi nim, “Gos nge ek yi mił ninim, ‘Gos nanim men ngii ei prei ełmin ngii ningii,’ pa nim. Ba enim ngii ei erangin kin epi waning wumb mił ngii sałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jiisas eim Gos men ngii owundu ełe mołpu yi nipi mułang, wumb ningił tumbun mułum wumb, ni simb ak tum wumb tu wangin, Jiisas er ka erim. ");
INSERT INTO nii_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ba kułmał kałiłmin wumb ei ni lo ek piiłmin wumb ni molk piinjing ni, eim jep oł erpi erang, kangił nirik Gos men ngii owundu ełe molk wii dinga tok ‘Osana,’ ninjing ei, nik kin ‘Deipis nge tiłap ende kingam,’ yi ninjing, ei wu ombu en enim molk piik kin kis piinjing. ");
INSERT INTO nii_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Piik, ek nik Jiisas ngok yi ninjing, “Nim ek ninmin ei nim piin min mon?” Nga Jiisas ek nipi orung kindim, “Na piind, enim Gos ek ei gerik piinenjing min? Ek ei yi ninim, ‘Kangił kembis menjing am nok mołmun, ni kangił dinga mił mołmun ei, Gos eim erpi gupu ełe nanim embe ambił tonu kindngii nipi yi ninim,’ pa nim.” ");
INSERT INTO nii_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Pe eim Jerusalem konu owundu ełe mulnjung ei si kindpi, tor pupu Besanii konu kembis ełe emii peng pupu mułum. ");
INSERT INTO nii_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mołpu, kupiiring ok, eim Besanii konu kembis si kindpi tor pum, ni eim kuni tum. ");
INSERT INTO nii_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tang, kenim ni ond pik mong nołmun ond endi engim, ei pupu kenmbii nipi andłam ełe pum. Pupu kenim ni ond ei mong endi to mulerim mon! Onguł mendpił erpi engim. Jiisas ek dinga nipi ond ei ngum, “Nim nga ond mong nga tunerii mon!” Yi neng kin, ond ni sikir kułum. ");
INSERT INTO nii_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jiisas eim nge ekii sinjing wumb oł ei kanik puku sik endnjing. Andik ek yi ninjing, “Nimbił erang ond ei sikir kułii enim?” ");
INSERT INTO nii_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jiisas ek nipi eim nge ekii siłmin wumb ngopu yi nim, “Na ek keimi nip enim ngond. Pe enim pii gii mendpił peng, enim noman tał sinerang mulnjung kin, na ond pik ełe enj oł ei mił enim yi erngii. Ba enim oł yi mendpił enerngii mon! Pe nga enim pii gii mendpił molk kin komung owundu pałim ek dinga nik, ‘Komung pukun ep noł ełe mani pui ningii, ei kapłi ba,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","“Pe enim pii gii nik prei enjing kin, enim epi nipe simin nik erngii ei, kapłi singii.” ");
INSERT INTO nii_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiisas Gos men ngii owundu ełe orung opu, ek emb topu wumb ngopu mułum. Mułang kin, Jura wumb nge kułmał kałiłmin wu owundu ni Esrel wu num kombur ok eim kanik yi ninjing. “Nim nipe noman dinga sikin kongun ei en? Wumb nii nim noman dinga ei ngum?” ");
INSERT INTO nii_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jiisas ek nipi yi nim, “Na ku yi enim kin ek endi nip kii simbii. Ei enim na ek ei nik ngunjung kin, na nam nipe noman dinga peng kongun end, ei nip enim ngumbii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Jon wumb noł pendiłim wu ei noman dinga ei jiłi mił orung tonu om? Pe oł ei Gos epin konu mani om min mei mani wumb ngenj ełe om?” Pe Jura wu num ombu ei en enim ek nik piik piik erik yi ninjing, “Pe sinim oł ei Gos epin nge epi epin konu ełe mani om, ei ninjpin kin, eim sinim kin ek yi mił nimba; ‘Kapłi, nimbił erang en enim Jon nge ek ei pii gii ninenjing? ");
INSERT INTO nii_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ba pe sinim nimin oł ei mei mani wumb kin om ninjpin kin, sinim wumb tungii ni mund mong kułmun. Kułpun ek ni tor kindnermin yi nik piinjing. Nimbił erang, wumb ei yi ni piinjing, Jon Gos oł ekii se ermba ei piipi niłim wu,” ei yi ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wu ombu ei piik, Jiisas kin ek ni orung kindnjing, “Sin piinanmin,” pa ninjing. Jiisas ek yi nipi wu ombu ngum, “Na yi ku, na noman dinga nipe dinga peng kongun end ei, nip enim ngunermbii.” ");
INSERT INTO nii_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Ba enim er piinmin mił nenj? Wu endi kangi wu tał meng seng mulnjunguł. Arim pupu, kingam kumna mułum konu kanpi ek nipi yi nim, ‘Nim pukun pani aka pin kongun erii!’ nipi kindim. ");
INSERT INTO nii_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kingam yi nim, ‘Na punermbii,’ nim, ba nga ekii se pum. ");
INSERT INTO nii_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Arim nge pupu kingam ekii kanpi yi ku nim. Ba kingam, ‘Owa bii,’ nipi, nga ekii se punerim. ");
INSERT INTO nii_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pe kangi wu tał kangi wu nii eim arim nim ek ei ekii sim?” Wumb yi ninjing, “Kingam kumna arim nim ek ei ekii sim,” pa ninjing. Pe Jiisas ek nipi ngopu yi nim, “Na ek keimi nip enim ngond. Ku takis siłmin wumb ni amb wu eipi eipi ningił erik endnjing amb, ni wumb ombu oł kis mendpił er endnjing wumb ei, nga ok Gos sinim tep er mołum konu tuk pungii. Nimbił erang en enim noman ak tok, Gos nge ek ekii sinjing ełe pungii. ");
INSERT INTO nii_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Nimbił erang, Jon opu oł kun erpi enim andan tum, ba enim pii gii ninenjing mon. Ba wu ku takis siłmin wu, ni amb wu eipi eipi ningił erik erik endnjing amb, ni wumb ok pii gii eim kin piinjing. Enim oł ei kanik poru ninjing, ba enim nge noman ak tok pii gii ninenjing mon,” Jiisas ek yi nim. ");
INSERT INTO nii_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Enim wu num wumb tep ełmin wu ek ekin endi nga nimbii end piiyei!” Jiisas ek yi nim, “Wu endi eim ond mong wain pin nge konu owundu endi erpi tełim, konu ełe teł mei konu orung orung pei kung gui erim. Nga tukrung ełe, noł wain ming owundu endi erim er sepi ond mong wain tep mułngii ngii endi tekim, yi er sim. Sepi kin, wu kombur ełe kongun top siłmin wu er noł wain mułei nipi pendpi, eim konu turii endi ełe pum. ");
INSERT INTO nii_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ekii se ond mong wain nungii kunum mandi erang, noł wain arim eim kongun wu kombur kindang puk, wumb wain pin tep er mołmun ełe pangin eim kuni wain kombur ngungii nipi kindang punjung. ");
INSERT INTO nii_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pe kongun ełe wain pin tep er mulnjung wumb ei molk, wu onjung wu ombu ambił gii nik, wu endeim to konduk, wu endi kepii tok, wu endi ku tok kindnjing. ");
INSERT INTO nii_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Pe nga ekii se kuni wain arim ei kongun wu kombur nga kindim. Ei ok kindim mił mon, kongun wu kombur pei kindim. Pe kuni wain kongun tep er mulnjung wumb kembin ei ok oł ei ku nga enjing. ");
INSERT INTO nii_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pe ekii se mendpił, eim nge kingam ek piingii ni piipi kindim. ");
INSERT INTO nii_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ba kongun tep er mulnjung wumb ei molk kenjing ni, eim kingam mendpił wang kanik kin, ek nik piik piik enjing. Erik yi ninjing, ‘Kang wu onum, ei eim arim epi ombu pei simba, sinim eim to kundamin! Yi erpin kin, eim kuni wain nin pan aka pin pei ei sinim simin,’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Nik, kangi wu om ni tor sipik, kuni wain pin torung ełe to kundnjung. ");
INSERT INTO nii_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Pe enim er piinmin mił nenj? Ekii se kuni wain pin nge arim wu ei opu, kongun tep er mołmun wu ombu kin nimbił oł ermba ei piinmin min?” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Wumb ek yi ninjing, “Kuni wain pin nge arim wu ei opu, kongun tep er mulnjung wumb kis ombu ei to kundmba mendpił. Nga kuni wain pin arim wu ei pani wain pin ei sepi, wu kombur eipi kongun top siłmin er noł wain konu ełe mułei nipi pendmba. Wumb ełe ouni wain arim nge kuni wain ngungii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jiisas ek yi nim, “En enim Gos nge ek ka mon ei gerik piinjing min mon? Ei yi nim, ‘Kom ku ngii endi takinmin wumb ei endi si tor kind si kindnjing ku ei, pe ngii ekin mił orung opu tonu opu ku dinga wii pałim. Ku ninim ei Jiisas eim ninim, Gos owundu eim oł ei erang tonu onum ei, sinim kan ka wii kaninmin.’ ");
INSERT INTO nii_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Yi mił peng kin, na enim kanip nind,” Jiisas yi nim. “Gos sinim tep er mołum konu ei, enim kin sipi orung simba. Sipi, wumb tiłap eipi endi Gos sinim tep er mołum konu ei wumb ngumba wumb ei, Gos oł kun ka erngii. ");
INSERT INTO nii_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Wumb nii endi eim bok topu pupu, ku peł ełe pim kin, eim topu pułpeł to eipi eipi kindmba, ba nga kom ku ei opu wumb endi ngenj ełe pim kin, wumb ei topu kiłpi topu pułpeł topu, dup sik mił eipi eipi kindmba,” Jiisas yi nim.) ");
INSERT INTO nii_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pe kułmał kałiłmin wumb owundu ni lo ek piiłmin wumb Jiisas eim ek ekin ei piinjing ei eim wu kei kin ninim ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Piik, eim ambił gii nimin ni piinjing, ba wumb pei mołułmun nik mund mong enjing. Wu amb en enim yi piinjing, “Jiisas eim Gos oł ekii se ermba oł ei piipi niłim wu, ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jiisas nga ek ekin topu ek yi nim. ");
INSERT INTO nii_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Gos sinim tep er mołum oł ei nge oł konj mił, king endi oł yi erim. Eim kingam amb simba erang, eim kuni owundu erim. ");
INSERT INTO nii_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kumb ok, wu king eim nge kongun wumb kindpi, wumb kanik yi ningii, ‘Na kangi amb simba kunum kuni owundu er simbii, ok nungii,’ nirim. Pe kuni owundu nungii kunum ei mandi erang, king ei eim nge kongun wu ombu kindang, wumb andik nengin, wangin neng, puk, wumb kanik nik, ba wumb kan nirim wumb ei, ‘Onermin mon!’ ninjing. ");
INSERT INTO nii_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","King ni nga eim kongun wu kombur kindpi yi nirim, ‘Enim puk yi ningii, “Na kung kou top nui, epi owundu pei sipi, kangi amb simba kuni pei kun er sepi mołum, enim ok, kuni nungii. Wei!” Nim nik puk yi nei!’ nipi kindim. ");
INSERT INTO nii_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","King ei nge kongun wumb puk, wumb kanik nik ni wumb ek ei piinermin nik wumb, en enim si kindik, eipi eipi puk. Kombur en enim ku singii kongun erngii nge puk; nga kombur en enim aka pin kongun erngii nge eipi eipi puk. ");
INSERT INTO nii_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ba wumb kombur king nge kongun wu ombu ambił gii nik, kepii tok, kombur to konduk erik. ");
INSERT INTO nii_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Erangin kin, king eim popuł sipi, eim nge opu wu ombu kindang puk, wumb ombu ambił gii nik, ei eim kongun wumb to kundnjung wumb sik to kundngii, nga konu orung orung pei dup kindangin, ‘Nangłi,’ nirim. ");
INSERT INTO nii_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","King ni eim ek nipi eim kongun wumb ngopu yi nim, ‘Na kuni owundu wumb nungii ninj wumb ei, kuni er kun er sinj ba wumb wii tunj ei, en enim enmin oł ei kapłi enanim. ");
INSERT INTO nii_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yi pałim ei piik enim puk, andłam ełe molk wumb eipi ongii ei, nik tu wangin ok. Ok amb simba kuni owundu er sinj, ei nungii,’ pa nipi, kindang punjung. ");
INSERT INTO nii_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","King eim yi nipi eim kongun wumb ngang, puk konu orung orung pei puk, wumb kanik ninjing ei, wumb kis, ka ouni ninjing. Nengin, wumb ok eim kingam amb simba erim konu ngii nirik molk piki tunjung. ");
INSERT INTO nii_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wumb wu amb ok mułangin kin, king nirik pupu wumb ok mulnjung ei kenmba nge nirik pum. Pupu kenim ni, wu endeim eim wu endi amb simba erang konduk kindiłmin kon ei, kindnerim mon. ");
INSERT INTO nii_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pe king ek nipi wu ei ngum, ‘Wu puł, nimbił erang nim kuni owundu wu endi amb simba erang konu nirik on, ba konduk kindiłmin kon ei kindnan?’ Ba wu ei eim ek nimba ek pinerim mon. ");
INSERT INTO nii_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","King ni kongun wumb kanpi kin ek yi mił nim, ‘Enim wu ei simb angił ełe kan tok, olkup to anda emii enim konu ełe pindangin pengłi!’ pa nim. ‘Emii kunum ełe wu ei eim ke dinga nipi, eim nge gupu mong kongpu nopu mułmba,’” pa nipi yi nim. ");
INSERT INTO nii_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jiisas nga ek yi nim, “Keimi, Gos eim wumb pei ngii nirik wii tum ba wu kopur endeim endeim ni eim ngii ełe nirik wangin,” a nim. ");
INSERT INTO nii_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Lo ek piiłmin wumb en enim ek nik piik yi ninjing, “Sinim Jiisas ambił gii nimin, ei nipe ek nipin ambił gii nimin?” ");
INSERT INTO nii_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pe enim lo ek piiłmin wumb ei nge kongun wu kombur kin King Eros nge kongun wu kombur kin ouni ok, Jiisas mułum konu kanik yi ninjing, “Ek mon wu, nim sin piinmin nim ek keimi niłin wu, ninim ek keimi minj nikin, Gos oł kun ka ełim mił yi nikin wumb ngołun. Pe nim wumb endeim kin noman ngunałin, wumb pei noman ende minj ngołun. ");
INSERT INTO nii_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pe nim er piin mił nenj ei ni sin ngo? Sinim Rom wu King Siisa kin ku takis ngumun min mon?” ");
INSERT INTO nii_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ba Jiisas eim wu ombu noman tuk piik ninjing ek, ei piipi ek dinga nipi orung kindpi yi nim. “Enim ek kend nge wumb, enim ni ek endi nimbii min, yi piik ninmin ei, nimbił erang ninmin? ");
INSERT INTO nii_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Enim ku takis tunjung ku endi tu wuk, na ngangin kenmbii,” nim. Neng, takis ku endi tu wunjung. ");
INSERT INTO nii_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tu wangin, wu ombu kii sim, “Ku min men ni embe ei nii nge mołum?” ");
INSERT INTO nii_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Wu ombu yi ninjing, “Wu King Siisa nge,” ninjing. Pe eim ek nipi ngopu yi nim, “Siisa nge epi ei Siisa ngungii; Gos nge epi ei Gos eim ngungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wu onjung wu kei Jiisas nge ek piik, mund mong erik kin, si kindik punjung. ");
INSERT INTO nii_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","24","Akip kunum ei mendpił, wumb koltmun wumb ei nge nga konj onerngii yi niłmin wumb ok, Jiisas kin ek nik kii sinjing. Sik yi ninjing, “Ek mon wu, Moses nge lo ek yi ninim, ‘Pe wu endi eim kangił mulerang kułum kin, eim angim eim amb sipi, eim kingam mił endi meng simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","“Kumb ok wu angim angim angił orung nga tał mulnjung, ba wu kumna amb ei sipi mułum ei, kułum. Ba kangi endi mulerim. Yi erang kin, eim nge angim ei amb ei sim. ");
INSERT INTO nii_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nga angim tuk ei yi ku erim, nga enginjngił ekii ei yi ku erim, yi minj er puk. Puk wu angił orung nga tał pei yi mił erik kolk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","28","Wu ombu pei kolk poru nengin, amb ei eim mendpił ekii se kułum. Pe nim ne! Ekii se wumb kulnjung wumb ei angk, nga konj tonu ongii kunum ei, wu nii endi amb ei wam mułmba? Nim piin, wu pei amb endeim minj sinjing.” ");
INSERT INTO nii_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ba Jiisas ek nipi orung kindpi yi nim, “Enim Gos nge ek ei piinenjing min? Enim yi ku Gos nge noman dinga ei piinanmin min? Yi mił enim ek ninmin ei kapłi enanim. ");
INSERT INTO nii_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yi mił ekii se kułii wumb ok nga konj pungii kunum ei, wu amb sinenjing; ni amb wu punenjing; wumb ombu Gos enjel mołmun mił yi mułngii. ");
INSERT INTO nii_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Nga enim wumb kulnjung wumb angk, nga konj mułngii ninmin ei, na enim kii simbii end. Enim Gos nge ek ei ger kenjing min mon? Eim ek ei yi mił ninim, ‘Na Eiparam nge Gos, Jeikop nge Gos, Aisak nge Gos.’ Ek pułe yi mił, wu ombu kulnjung, ba nga puk konj mołmun. Wumb ombu Gos ei konj kunum kunum mołum Gos ei nge,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wu amb, wumb pei ek ei piik, mund mong erik, ek ni Jiisas eim ngum. ");
INSERT INTO nii_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kunum ełe Jiisas eim ek neng wumb kolk nge konj tonu puk piinałmin wumb ei, gupu ełe ek tingninenjing ek ei lo ek piiłmin wumb piinjing. Piik, eim mułum konu ełe mandi ok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Wumb mulnjung konu tuk ełe, wu endi lo ek piiłim wu mołpu, Jiisas nimba ek piimbii ni piinim, ek ei Jiisas kin kii sim. “Ek mon wu, ek nipe ek endi lo pei to mani kindpi ek ei minj owundu enim?” ");
INSERT INTO nii_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jiisas ek nipi, wu ei ngopu yi nim, “Nim nge Owundu nge embe ambił tonu kindkin, ninim kaimb ni, noman tuk ni, noman poru, nga noman ka pei Gos Owundu ngunjii. ");
INSERT INTO nii_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Lo ek ei endeim owundu mendpił ei, ek lo ka wii mendpił. ");
INSERT INTO nii_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nga lo ek endi ei yi mił pałim ku. Ei yi mił, ‘Nim ninim noman ełe kuł ngonum yi ku wumb erpi ei kin, ninim noman ka ngunjii.’ ");
INSERT INTO nii_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pe ek lo ek tał ei, ek pułe endeim pałim. Ek ei, Gos oł ekii se ermba ei piik niłmin wumb kin, Moses lo ek pei ei yi ku pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Lo ek piik ełmin wumb mułangin kin, Jiisas ek kii sipi nipi ngum. “Enim Gos kindim wu Krais ei er piinmin mił nenj? Eim nii kingam?” Wumb ei kanik yi ninjing, “Eim Deipis nge kupam,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eim ek nipi wumb ngum, “Pe nimbił erang Gos Gui Ka ei Deipis kin neng, Deipis mołpu wu ei, ‘Nam Owundu,’ nim? Eim yi nim, ");
INSERT INTO nii_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Owundu ek nipi nam nge Owundu ngopu yi nim: Nim na nge angił tundung orung mulnjii. Ekii se ninim nge opu orung wumb ongii ei sipi, ninim simb mandring ełe kindmbii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Deipis eim nge ek ełe nipi eim, ‘Na nge Owundu,’” pa nim. “Nimbił erang wu ei eim nge kupam?” a ninim. ");
INSERT INTO nii_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wu endi Jiisas nim ek ei nik orung kindngii mił wu endi mulenjing mon. Nga kunum ełe pułngun monduk wumb eim kin kał kulk nga ek kii sinenjing mon. ");
INSERT INTO nii_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pe Jiisas ek nipi wumb pei ngopu, nga eim nge ekii sinjing wumb kin ouni ngum. ");
INSERT INTO nii_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Eim ek yi mił nim, “Lo ek piiłmin wumb kin, lo ek połmun wumb kin puk, Moses nge lo ek dinga nik ngok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pe enim wumb ombu ei, lo ek nik ngonmun ei piik, ekii singii. Ba en enim ełmin oł ei, enim ekii sik enerngii mon. Wumb ombu en enim, ek ni tor kindiłmin; ba en enim ek ei ekii sinałmin mon. ");
INSERT INTO nii_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Wumb en enim epi oł embin tui tu wuk, wumb pindang ełmin; ba en enim angił mong ełe endeim, wumb paki tok yi enałmin mon. ");
INSERT INTO nii_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","En enim epi pei ełmin oł ei, wumb keningii ni piik, yi ełmin. Nga en enim ka owundu peng ełe talk, prei ełmin. Yi mił erik, en enim konduk ełe olt, moke kanim kanim ełmin. Yi mił ermin ni piik, epi ei wumb keningii. ");
INSERT INTO nii_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","En enim noman yi piiłmin kuni owundu nungii ei, ‘Sin sinim o pun, peł kumb ełe mułmun,’ ni piiłmin. Nga men ngii konu ei pupun, kumb ełe mułmun nik, yi piik andiłmin. ");
INSERT INTO nii_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","En enim yi piiłmin, ‘Sin tuk wumb konu ełe endamin wumb molk, sin ek mon wu, yi ningii,’ ni piiłmin. Ei mon! Enim wu endeim mendpił ek mon wu, enim angim angim mułngii. ");
INSERT INTO nii_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Ba wumb molk, enim ‘Ek mon wu,’ ninerngii mon! Wu endeim enim nge ek mon wu, nga enim angim angim yi mułngii. ");
INSERT INTO nii_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ya mani mei ełe enim, ‘Sin erinjpin endi mołum,’ yi ninerngii mon. Enim nge Ernjing endeim mendpił, ei tonu epin konu ełe mołum. ");
INSERT INTO nii_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Enim wumb molk, ‘Enim wu num peng pim wu,’ yi mił ninerngii mon. Enim wu num endi mołum ei, Krais mendpił mołum. ");
INSERT INTO nii_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ba enim nge wu owundu ei, enim kin kongun wu mił yi mułmba. ");
INSERT INTO nii_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wu endi eim embe ambił tonu kindim kin, eim nge embe ei mani ba. Wu endi eim embe ambił mani kindim kin, ei eim tonu ba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Enim lo ek piik ełmin wumb ni, połułmun nik ełmin wumb, enim kan kun er mułngii. Enim noman tał sek enjing wumb. Nimbił erang enim Gos sinim tep er mołum ei andłam ondu ngok erangin kin, wumb tuk ełe pungii kapłi enanim mon! Nga en enim konu ełe punarik, nga wumb tuk bin ni enmin ei, pei nik yi enanmin ku. ");
INSERT INTO nii_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(“Enim lo ek piiłmin wumb ni, andłam ełe prei olt er mułamin kin, wumb keningii nik ełmin wumb ni enim kan kun er mułngii! Enim kend tok nik ełmin wumb, enim amb wenjing kulnjung amb ngii konu ełe epi waning erik, yi ełmin. En enim prei kinan erik, ei enim oł ełmin, ei nge enim kumep kis endi singii,” pa nim.) ");
INSERT INTO nii_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Enim lo ek piiłmin wumb ni, andłam ełe angk prei olt ermin; wumb keningii nik ełmin wumb ni, enim piik kun er mułngii! Enim nge noman tał er pałim. Enim ep noł ni, konu mei orung orung andik, wu endi semin Jura nge wu mułmba nik endnjing. Andik kin, wu endi tuk sinjing wu ei, am dup konu peł ełe kun tuk ba wu mołum. Ei en enim yi mił ku; ba enim eim kin nengin erpi, eim am oł kis wii erpi, enim to mani kindnim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Enim lo ek nga pei nik enmin, ei kun punałim mił enim; ek eipi eipi nik lo ek ei ekii sik niłmin; ba Gos lo ek ekii sinałmin. Enim ningił tumbun kis mułum; ba nga wumb andłam andan to ngungii enmin. Kapłi enim kan kun er mułngii! En enim ek yi niłmin, ‘Wumb endi men ngii kin, ei nipi, ek keimi mendpił nind. Nipi, angił tonu kindmba wu ei, ek wii mił nimba. Pe wumb en enim lo ek eipi eipi en enim noman ełe nik ełe, en enim ekii sik, andłam kun sałim mił punarik kin, Gos nge lo ek ei ekii sinałmin mon. En enim nge lo ek ni pendnjing ek lo kembis kembis, ei nge ekii siłmin. ");
INSERT INTO nii_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Enim ningił tumbun kis mułang, noman wulu pang mołmun wumb! Epi nipe ei owundu? Min gol ei epi owundu min? Men ngii ei erang, gol opu kun ka mendpił mułmba min? ");
INSERT INTO nii_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pe nga enim wumb molk yi niłmin, ‘Wu endi kułmał kałiłmin konu ełe angpi, ek tonu dinga nipi, ek keimi nind niłim ek ei, enim ek wii niłmin. Nga wu endi kułmał kałiłmin epi sipi, tonu kumo ełe sepi, ek keimi nimba ei keimi, eim yi ku erpi mułangłi!’ niłmin. ");
INSERT INTO nii_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Enim ningił tumbun kis mułang, ek ninmin min, epi nipe owundu? Kułmał kałiłmin epi tonu kumo ełe sepi, epi owundu min? Kułmał kałiłim kumo ei erang, kułmał epi ei kun ka mendpił min? ");
INSERT INTO nii_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pe wu endi eim kułmał kałiłmin konu kumo ełe kin, ek endi tonu nipi, dinga ermbii nipi ermba ei, tonu kumo ełe epi pei mułmba epi ei kin, ouni ek dinga nimba. ");
INSERT INTO nii_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Wu endi men ngii owundu ek tonu nipi, ek ni dinga ermba ei, eim men ngii owundu ełe ni, Gos men ngii nirik mołpu, ku ouni ek dinga nimba. ");
INSERT INTO nii_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Wu endi tonu epin ek tonu nipi, ek endi ni dinga ermba ei, Gos peł mołum owundu ei kin, ouni ek nipi dinga ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Enim lo ek piik ełmin wumb ni, wumb enim lo ek andan tołmun wumb; enim kan kun er mułngii! Enim noman tał pim wumb. En enim aka pin me min, kuni singin erang, epi engki tu wuk, endeim aninga tonu ei Gos ngok yi ełmin. Ba enim lo ek pei enim si kindiłmin ek ei, nga ekii sinermin mon. Ei ek yi ek, wumb nok tumba kun ka ek ni, oł kun erngii ek ni, noman ka wumb ngungii ek ni, lo ek Gos kin epi engki nga sipi, Gos ngok erngii oł ei, enim si kindnanmin mon! Ba epi lo ek owundu ei oł keimi erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","“Enim ningił tumbun kis mułum wumb molk kin, wumb andłam kun andan tungii enmin min? Ei kapłi enanim mon! Enim epi kembis kembis noman peng kongun er molk kin, ba Gos nge epi owundu ei, enim ambił gii ninarik mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Enim lo ek andan tołmun wumb ni, lo ek piiłmin wumb; enim kan kun erik mułngii! Enim noman tał er pałim wumb. Enim ngenj torung ełe noł was er ka erik mołmun; ba enim noman tuk ei tukrung oł kis pei seng, ei penj mendpił mołmun. ");
INSERT INTO nii_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Enim ningił tumbun lo ek andan tołmun wumb! Enim ming kap tukrung ok was er ka erik, nga torung ei eim ka wii konj simba ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Enim lo ek andan tolmun wumb ni, enim lo ek piik nik ełmin wumb; enim kan kun er mułngii! Enim noman tał seng kin, ek tał er nik nik enmin. Ei enim wumb yi mił mołmun ei guimeng tukpu ełe, torung kopung kuru ka kand sengin ka sałim; ba tukrung ełe wumb kułii embił piki topu, epi kis er sałim mił enim noman ełe yi sałim. ");
INSERT INTO nii_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","En enim yi mił ku mołmun. Wumb enim ngenj ełe kanik kin, enim wumb ka mołmun ni piinmin; ba noman tukrung orung epi waning ni, lo ek to kindik, oł kis ei tuk ełe piki to mołmun.” ");
INSERT INTO nii_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Enim lo ek piik ełmin wumb ni, enim lo ek andan tołmun wumb, enim kan kun er mułngii! Enim noman tał peng ek tang mulnjung wumb, enim ek ni tor kindiłmin wumb nge tukpu ełe, kung gui pok ni, kom ku ka wii ełmin. Nga wumb oł kun ka ełmin wumb ei nge, tukpu ka wii ełmin ku. ");
INSERT INTO nii_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Molk ek yi niłmin, ‘Pe sin ok kupenjpin noł mulk kunum ei, sin mołpun kin, kapłi sinim ek ni tor kindiłmin wumb paki tamin, to kundnałmin mon!’ ");
INSERT INTO nii_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","En enim ek ei niłmin ei, enim ek ni tor kindiłmin wumb to kondułmun ek ei piik niłmin. Enim ek ni tor kindiłmin wumb to kundnjung wumb ei nge tiłap ende molk kin, ninmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","“Kapłi, en enim kupenjing noł ok ełmin oł ei, erik poru ningii. ");
INSERT INTO nii_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Enim wembii, enim wembii kis nge kingenjing noł; Gos enim kos owundu piimba kunum ei, enim dup konu mendpił pungii. Nimbił erang enim kos ełe tungu erngii. Tungu ermin ni erngii, ei kapłi enermba mon. ");
INSERT INTO nii_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yi pałim ei piik, pe na ek ni tor kindiłmin wu kombur sip, noman ka piim wu kombur kin, mon ek tołum wu kombur kin, Gos ek ka piik tor niłmin wu kombur kindamb, enim kin ongii ei, enim kombur to konduk, nga kombur sik, ond peri ełe to kundngii ku. Nga kombur enim men ngii ełe tungii. Nga wu kombur konu owundu endi ełe bułun to sipik, konu owundu endi ełe tor sipik, yi erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","“Wu kombur mei konu wu oł kun ka mulk wu ei, enim to kundnjung ei, enim nge kumep enim kin pei owundu pimba. Gos nge tiłap wumb kumna kin, Eipel wu oł kun ei Jura wumb to kundnjung. Kułang kin, pepi, opu opu ni, ekii se mendpił Sekaraiya kingam Berekaiya, eim enim tuk men ngii ka ełe kumo kind sik ełe to kunduk, kumep ei pepi, opu enim ngenj ełe pałim. Ei enim pe ya mei mołmun wumb ei, enim puł ełe enim pe epi kis enim mei ełe molmun wumb ei, pe kumep kis singii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Na ek keimi nip enim ngond. Kumep pe kis enim wumb tiłap pe mołmun wumb ei singii. Nimbił erang, enim wumb oł kun ka enjing wumb ei to kundnjung.” ");
INSERT INTO nii_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Jerusalem konu wumb, Jerusalem konu wumb! Enim Gos oł ekii se ermba oł ei piik niłmin wumb, enim to kundułmun. Nga Gos nge ek se andiłmin wumb kombur kindang ku, to kundmun nik tołmun. Kunum kunum na enim nge kingenjing noł sip, kułou tumbii nip ełe, ei yi mił kei kultu mam ei kei wał ombu sipi eim kong mandring kindiłim mił, na yi ermbii nip enj, ba en enim mon ni piiłmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","“Enim piinmin! Akip enim ngii konu ełe wii simba, wumb mulerngii mon! Na enim si kindmbii. Si kindamb, kangił menjing mulerang mołmun, ei mił mułngii. ");
INSERT INTO nii_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Keimi na ek yi mił nip enim ngond, enim na nga kinerngii mon, molk puk puk ekii se enim ek yi ningii, ‘Gos wu ei kin epi ka wii ngangłi, eim wu owundu embe ełe onum, pa ningii,’” Jiisas pa nim. ");
INSERT INTO nii_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jiisas eim Gos men ngii owundu ei, si kindpi anda pupu pum. Pang, eim nge kongun wu eim pum konu ekii se punjung. Puk, eim kin ek nik Gos men ngii angiłim mił nik, andan tungii nge punjung. ");
INSERT INTO nii_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ba Jiisas ek nipi orung kindpi yi nim, “Enim epi pei ei kan poru ninmin min? Na ek keimi nip enim ngond, ya ku ei endi wii sinermba, pei tangin ku endi pupu, ku endi tang pei ombult mani opu poru nimba.” ");
INSERT INTO nii_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jiisas eim tonu komung Olip ełe mułum ni, eim nge ekii siłmin wu mendpił eim kin onjung. Ok ek kii sik yi ninjing, “Nim sin kankin ne! Kunum nenj kin oł ei tonu omba? Nga oł endi ok tonu wang kenmin ei, epi nipe tonu omba? Nim orung wan, ya mei ei kunum nenj kin poru nimba?” nik kii sinjing. ");
INSERT INTO nii_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jiisas ek nipi orung kindpi yi nim, “Enim kan kun er mułngii. Mon peng kin, wu endi opu enim kin, ek kend topu ngumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","“Nimbił erang, wumb pei ok na nge embe ełe ongii. Ok ek yi ningii, ‘Na nam Gos kindim wu Krais,’ pa ningii. Nik, wumb pei ek kend tok ngungii. ");
INSERT INTO nii_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pe enim molk piingii ni wumb opu enmin ni piingii; nga wumb ek nik tu wangin wumb opu erngii ei piingii ku; ba ei kan kun er mułngii. Enim puku sinerngii mon. Epi ei tonu omba ba kunum poru nimba kunum ei sikir tonu onermba mon. ");
INSERT INTO nii_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Konu mei owundu wumb tiłap endi kin nga konu tongndung mei owundu endi wumb tiłap endi kin opu erngii. Nga king endi nge tiłap ei puk nga king endi nge tiłap kin opu erngii. Nga konu kombur wumb kumb kuni owundu seng mułngii; nga konu kopu owundu pei tumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","“Oł ombu pei tonu omba ei mił amb endi kangił mengmba kunum ei, eim ngenj kumbii piinim mił yi piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kunum ełe, wumb enim sik ngenj kumbii ni oł embin tui enim kin tonu omba. Wang kin, enim to kundngii ku. Nga mei wumb pei enim kin noman kis mendpił piingii. Nimbił erang, na nge embe ełe ei wumb oł kis yi mił enim kin tonu wang erngii. ");
INSERT INTO nii_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kunum ełe, wumb pei en enim pii gii si kindngii. Si kindik, en enim engnjing noł sik, opu erii wumb ongii ei ngok; nga en enim engnjing kin opu orung erik, popuł sik erngii. ");
INSERT INTO nii_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yi erangin kin, pei ek kend wumb oł ekii se tonu omba pa nik yi erngii ei, enim wumb kanik, ek kend tungii. ");
INSERT INTO nii_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Oł kis ei opu owundu ermba, yi erang kin, wumb en enim noman ngok enmin oł ei, si kindngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","“Ba wu nii endi eim dinga mołpu, Gos kunum owundu ekii se mendpił tonu omba kunum ei mułum kin, Gos eim sipi eim kin orung simba. ");
INSERT INTO nii_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pe Gos sinim kin tep er mołum oł konj oł ei nge ek ka ei, wumb konu orung orung mołmun wumb ei kin, ek ni tor kind ngangin piik poru nengin kin, ekii se Gos kunum owundu kunum poru nimba kunum ei tor omba.” ");
INSERT INTO nii_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pe enim keningii ei epi oł kis mendpił ei opu konu to kis erpi yi ermba. Epi ei Gos oł ekii se ermba ei piipi niłim wu Danyel ek nirim mił, epi opu Gos nge konu kun ka wii ełe engmba. ");
INSERT INTO nii_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kunum ełe, Juriya wu amb pei Juriya konu ei si kindik, tonu komung ei tonu sikirik pungii. ");
INSERT INTO nii_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Pe wu nii endi eim tonu ngii ełe mułmba wu ei, nga mani pupu eim epi sinermba mon, eim sikir ba. ");
INSERT INTO nii_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Pe nga kunum ełe wu nii endi eim aka pin mułmba wu, ei nge orung pupu, eim ngii konu konduk simbii ni piimba ei sinermba mon. ");
INSERT INTO nii_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nga amb kangił kembis am ngok mołmun ni, amb kangił mundii mołum amb ombu kaimb er mołmun. ");
INSERT INTO nii_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","En enim prei er mulnjung kin, jii nimba kunum min, kor owundu kunum ei enim tungu sikir punerngii. ");
INSERT INTO nii_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Kunum ei oł embin tui owundu tonu omba, mei konj sirim kunum ei pepi opu, pe yi ku, oł embin tui ei mił ok tonu oneririm mon. Nga ekii se mendpił, oł embin tui owundu ei nge tonu onermba mon ku. ");
INSERT INTO nii_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Gos eim kunum ei sikir mandi onerim kin, wumb ei pei am pungii. Ba Gos eim wumb simbii nipi mundum wumb ei piipi kin, kunum ei mandi omba. ");
INSERT INTO nii_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kunum ei wumb molk yi ningii, ‘Kinei! Gos kindim wu Krais ya mani mei ełe onum!’ min ‘Orung onum,’ ya nik erngii ei, enim keimi ni piik pii gii ninerngii mon. ");
INSERT INTO nii_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Kunum ełe wumb kombur ok yi ningii, ‘Na wu Krais,’ nga wu endi oł ekii se tonu omba epi ei piipi niłim wu; ei ek kend tok erik. Jep oł kanim kanim pei erik erngii ei, Gos eim tuk sipi mundum wumb noman ei to wulu kindngii piim kin, kapłi kindngii. ");
INSERT INTO nii_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Enim piinmin ei, na enim kanip ok ninj. ");
INSERT INTO nii_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Wumb ei ok ek kend tok yi ningii, ‘Eim orung wumb mulałmin konu ełe mołum,’ yi ningii ei, enim punerngii; min wumb yi ningii, ‘Kinei, eim ya konu ełe koi er mołum,’ ei enim pii gii ninerngii mon. ");
INSERT INTO nii_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Enim piinmin, kupu endi tiłang erim kupu ei o pupu, wuł tiłang erpi pupu, wuł mani purum mił yi, Gos mei mani kindang wu kingam ei, eim orung omba kunum ei, yi mił ku ermba. ");
INSERT INTO nii_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Wumb ni epi kolk pengin konu ełe kei Sikapi ok kułou tołmun.” ");
INSERT INTO nii_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Kunum ei oł embin tui ei opu poru neng, ekii se eni opu emii ermba; nga oi opu tiłang enermba; yi erang kanjip tonu muł ełe boi boi nik mani ongii. Wangin, tonu muł ełe epi kanim kanim pei owundu ei ołup ołup ermba. ");
INSERT INTO nii_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kunum ełe, Gos kindang mani mei ełe wu kingam tełim wu ei omba. Erang, tonu muł ełe jep ol endi erang keningii. Erang, mani mei ełe wumb pei keningii. Ei molk keningii ni, Gos kindang wu kingam tełim wu ei tonu muł peł ełe mołpu omba. Ei eim nge noman dinga owundu ni, tiłang owundu wii peng omba. ");
INSERT INTO nii_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ei eim nge beli owundu tumba ei, ek owundu tengmba. Tengang kin, Gos eim enjel pei kindang, Gos eim wumb nge, simbii ni mundum wumb ei, si kułou tok wumb pei konu orung orung mei ekin tongndung pupu, endi mei ełe molk sik orung singii.” ");
INSERT INTO nii_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Enim ond pik ei ond oi mił onguł okuł nipi, nga mun erpi enim mił piingii. Ond kirang ei noł mołpu, onguł konj tołum, ei enim piinmin. Ond pik yi niłmin, ‘Akip konu eni mandi ba,’ pa niłmin. ");
INSERT INTO nii_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Yi mił ku, ekii se enim epi ombu pei keningii. Kanik, yi ni piingii kunum poru neng omba, kunum mandi enim ni piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Na enim kanip ek keimi nip enim ngond, wu amb enim akip mołmun wumb ei kularik kin, kopur konj mułangin kin, Jerusalem konu owundu ei to kis ermba, ei wumb kombur keningii,” nim. ");
INSERT INTO nii_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","“Tonu muł, mani mei ei, pei poru nimba ba Gos ek ka ei poru ninermba mon.” ");
INSERT INTO nii_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ba ya mei ełe wu endi Jiisas nga orung omba kunum ei, wu endi pii poł tunanim mon. Nga Gos nge enjel ombu piinałmin ku. Nga Gos eim kingam ei pii poł tunanim ku. Arim Gos eim endeim mendpił kunum ei eim piipi mołum. ");
INSERT INTO nii_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ok wu endi Nowa multum kunum ei, wumb oł kis erik mulnjung. Mulk, oł ei nge ekii se wu kingam orung omba kunum ei, wumb oł yi mił ku er mułngii. ");
INSERT INTO nii_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kumb ok noł owundu topu enerim kunum ei, wumb en enim noł kuni ka nok, amb sik, oł yi er pangin opu erik poru neng, Nowa nge eim wumb sip owundu ełe tuk puk. ");
INSERT INTO nii_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Noł owundu tonu om ei, wumb piinarik mułangin kin konu topu noł opu pim mił, yi Gos kindang mani mei wu kingam tełim wu ei, omba kunum ei yi omba, wumb piinerngii ku. ");
INSERT INTO nii_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kunum ei wu tał aka pin kongun er mułnguł ei, Gos wu endi sipi, endi sinermba. ");
INSERT INTO nii_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nga amb tał kongun er talkił mułnguł ni, Gos opu amb endi sipi, endi mundang mułum. ");
INSERT INTO nii_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ei piik kin enim kan kun er mułngii; nimbił erang, kunum nenj en enim nge wu owundu ei omba kunum, enim piinanmin mon. ");
INSERT INTO nii_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Enim epi ei piingii; pe wu endi eim ngii konu piiłim ei waning wu endi omba ni piipi, eim ngii ełe tep erpi kanpi mołum. Ei waning wu opu tuk punałim mon. ");
INSERT INTO nii_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Yi mił peng kin, en enim er kun er mułngii. Nimbił erang Gos kindang opu mani mei ełe opu wu kingam tełim wu ei, omba kunum ei enim pii kun erik mulerngii kunum, eim omba.” ");
INSERT INTO nii_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Pe kongun wu ka nii endi eim noman ka peng mołum? Wu eim kongun ei tep ka er mołum ei wu owundu nga wu ei eim nge kongun wumb pei, ‘Tep er mułii!’ nim. Nipi, ‘Kuni singii kunum ei, kuni ngokun yi er mułii!’ nim. ");
INSERT INTO nii_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ekii se eim nge wu owundu ei eim orung opu kenim ni, eim ok ek nirim mił yi er mułum. Mołang, pe kongun wu ei eim ka piyengłi. ");
INSERT INTO nii_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na ek keimi nip enim ngond, kongun wu ei wu owundu eim epi ombu pei tep er mułii neng, tep er mułmba. ");
INSERT INTO nii_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ba kongun wu kis ei eim nge noman ełe piim. ‘Na nge wu owundu ei sikir onermba,’ ni piipi yi er mułum. Ba wu owundu orung omba kunum ei eim piinerim mon. ");
INSERT INTO nii_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Pe eim kongun endi enjing wumb ei kepii topu, eim pupu kuni ni noł nok, wulu pang enjing, konu ełe tuk pupu er mułum. ");
INSERT INTO nii_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Pe eim nge wu owundu ei orung omba erim kunum ei piinarpi, eim wu owundu omba ei kui er mulerim mon. ");
INSERT INTO nii_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pe kongun wu mułang, eim nge wu owundu ei opu, eim kongun wu ei kepii kis tum. Topu, sipipi wumb ek keimi ninmin ba ełe enmin keimi pinałim ełmin wumb mulnjung konu ełe tok kis enjing. Konu ełe, wumb ei ke dinga nik, en enim gupu mong ni anmbił kongk kiłip tok mułngii.” ");
INSERT INTO nii_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kunum ełe, Gos sinim tep er mołum konu ei mił ambił wenip engki mulnjung. Ambił ombu en enim wu endi eim amb simba nge omba nik, en enim dup alam si mengk punjung. Sik puk, wu ei andłam ełe wang, kan sipin omun nik punjung. ");
INSERT INTO nii_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ba ambił angił orung en enim noman dinga pim. Nga ambił angił orung en enim noman pinerim. ");
INSERT INTO nii_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pe ambił angił orung noman pinerim ombu, en enim dup alam mendpił si mengk tu wunjung; ba nga dup alam noł kopur tu wunenjing mon. ");
INSERT INTO nii_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ba ambił angił orung noman pim ambił ombu, en enim dup alam sik, ming ełe dup noł kulk sik ouni sipnjing. ");
INSERT INTO nii_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ba amb simba erim wu ei, sikir onerim mon. Yi erang kin, ambił ombu or wang, or pingii pim. ");
INSERT INTO nii_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Pe or pek mułangin, epin tuk mii memb, wumb wii tok onjung ni yi ninjing, ‘Amb simba wu ei onum. Puk, andłam ełe puk, kan sik ongii,’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pe ambił ombu en enim angik, dup kalk er kun erik punjung. ");
INSERT INTO nii_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ambił noman pinerim ambił ombu, ek nik ambił noman pim ambił ombu ngunjung. ‘Sin dup alam noł poru ninim, enim dup noł kopur sin ngei!’ a ninjing. ");
INSERT INTO nii_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ba ambił noman pim ambił ombu, ek nik orung kindik yi ninjing, ‘Dup noł ei sin kindamin, nga enim kindngii ei kapłi ermba min mon da. Enim kapłi puk top ngii ełe konj top erngii,’ ninjing. ");
INSERT INTO nii_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Yi nengin kin, noman pinerim ambił ombu dup alam noł top ermin ni pangin, amb simba erim wu ei mandi tor om. Wang, wu omba nik kui er mulnjung ei ni ambił en enim er kun er mulnjung ei ok, wu amb simba erim ełe tuk punjung. Puk, kuni owundu er sim, ei ouni molk kuni nunjung. Nga ngii ondu pim. ");
INSERT INTO nii_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ekii se, ambił eipi noman pinerim kombur onjung. Ok yi ninjing, ‘Owundu, wu owundu! Nim ngii ondu aki to!’ ninjing. ");
INSERT INTO nii_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ba wu owundu ek nipi orung kindpi yi nim, ‘Enim na kin puł mendpił keimi pinałim mon!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Oł yi mił tonu omba ei piik kin, enim kui er mułngii! Kunum endi eim omba ei, tinga omba min, emii peng omba ei, enim pii poł tunanmin mon.” ");
INSERT INTO nii_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nga ek endi yi ku, Gos wumb tep er mołum konu yi mił. Wu owundu endi eim konu eipi endi ba ni piipi, eim nge kongun wu wei neng, wangin, eim ku nin epi mok topu eim nge kongun wu ombu ngang, kongun erngii nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Eim nge kongun wu ombu oł erik, kongun dinga erik ełmin mił piipi nim kin, eim nge ku ei mok topu erim. Kongun wu endi ku 5,000 ngum, nga kongun wu endi ku 2,000 ngum, nga kongun wu endi ku 1,000 ngopu yi erim. Er pendpi, eim konu eipi endi pum. ");
INSERT INTO nii_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pang, kongun wu endi eim ku 5,000 ngum kongun wu ni, eim sikir kongun top ełim endi erpi pupu, ku 5,000 ngum ku, ei sipi nga ku 5,000 orung tuk sipi kindpi se mułum. ");
INSERT INTO nii_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Pe nga kongun wu endi eim ku 2,000 sim wu, ei eim kongun top ełim er pupu, ku 2,000 nga endi sipi tuk kind sepi mułum ku. ");
INSERT INTO nii_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ba kongun wu endi ku 1,000 sirim wu, ei eim sipipi ku ni, tukpu sipi mei ełe mandring kind pendpi, wu owundu ngum mił ei mendpił pengłi nipi pendim. ");
INSERT INTO nii_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wu owundu ei eim kumb ok purum, nga andpi orung om. Kunum ei opu, eim nge kongun wu ombu wii topu tuk sipi, eim ku ngum ek ei nipi piipi ermbii nipi wii tum. ");
INSERT INTO nii_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tang, wu endi eim ku 5,000 ngurum wu ni om. Opu yi nim, ‘Wu owundu, nim na kin ku 5,000 ngun ni, na top erip ku 5,000 orung sip, tuk kind pendip moł,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Wu owundu eim ek ei piipi yi nim, ‘Nim kongun wu ka wii! Ninim kongun tep ka er mołun ei, epi kembis tep ka mułun ei, akip nim kindamb, na epi owundu tep er mulnjii. Pe nim okun, na noman ka ei siłip mok to sipił er mułmbuł,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nga wu kongun endi eim ku 2,000 ngurum wu, ei opu yi nim, ‘Wu owundu, nim na ku 2,000 ngun ni, na kongun top erip er pup ku 2,000 endi se tuk kindip sinj sałim,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Eim nge wu owundu ni ek nipi eim ngum, ‘Nim kongun wu ka! Nim wu ka, nim oł ka wii en. Erkin, ninim kongun tep ka en,’ pa nim. Nipi yi nim, ‘Nim kongun kembis ei tep ka molkun ei, akip na nim epi pei tep enjii. Nim okun, na noman ka ei siłip mok to sipił er mułmbuł,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pe nga wu endi ku 1,000 sim wu ni, opu yi nim, ‘Wu owundu, nim ełin oł ei na piił. Nim ek dinga nikin ełin ei na piip, nga nim wumb kuni epi tał pendkin pukun si nołun, nga konu epi endi kuni emb kindiłmin ei pukun, kuni wiis ei si nołun ełin na kanił. ");
INSERT INTO nii_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Kanip yi mił piinj. Piip, mund mong erip ni ku 1,000 ngun ei, koi er pendinj pałim ei, epi nim nge ninim si!’ a nim. ");
INSERT INTO nii_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ba eim nge wu owundu ei ek dinga nipi wu ei kin ek ngum. Ngopu yi nim, ‘Nim kongun wu kis, nim kongun enjii kis erang kor mołułun wu. Nim keimi na kaniłin, na pup, wu kuni epi ei sip, nga pup, wu kuni wiis emb eipi kindiłmin ei sip tangip ełe sił? ");
INSERT INTO nii_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Nim nga na ku ei sipkin, ku beng ngii ełe kindnjii. Nimbił erang en? Yi mił er eran kin, nam orung ombii kunum ełe, nam nge ku ei sip, nga ku kopur pendip simbii.’ ");
INSERT INTO nii_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pe wu owundu ni ek yi nim, ‘Enim wu ei ku 1,000 ei sik, wu endi ku 10,000 se mołum wu ei, ku 1,000 ei sik ngei!’ nim. ");
INSERT INTO nii_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nimbił erang wumb en enim epi pei sek mołmun wumb ei, na epi pei ni noman ka wii nga sip ngumbii. Ba nga wumb endi epi pei ni noman ka ei sepi mulermba wumb ei, eim epi ni noman aninga kopur simba epi ei, nga na sip orung simbii; eim wii mułmba,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pe enim molk, kongun wu kis ei sip, olkup tok torung emii enim ełe kindei! Kindangin, konu ełe molk ngenj kumbii sik, en enim gupu mong kongk, ke nik, kunum kunum kaimb er mułngii,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ekii se, Gos kindang mani wu tełim ei, omba kunum ei eim embe owundu seng kin, enjel kin ouni ongii. Kunum ei, Gos eim nge king peł tiłang ka wii ermba konu ełe mułmba. ");
INSERT INTO nii_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kunum ei, wu amb pei ok, eim mułmba konu ełe kułou tungii. Mułangin kin, eim wumb mok topu, wumb sipi, tiłap tał ermba. Ei yi mił, wu endi eim kung siipsiip sipi eipi kindpi, nga kung meme sipi eipi kindpi, ełim mił Gos kindim wu Krais yi ermba. ");
INSERT INTO nii_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ei eim kung siipsiip sipi, eim angił tundung mondpu, nga kung meme sipi angił taring mondłum, ei mił yi ku ermba. ");
INSERT INTO nii_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nga king owundu eim mołpu yi nimba, ‘Enim na angił tundung mołmun wumb ei, Gos enim kin noman ka ngopu erim wumb ei, Gos sinim tep er mołum konu ei enim nge Gos konu am kumb ok eririm konu ełe, nirik wei!’ a nimba. ");
INSERT INTO nii_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‘Nimbił erang ok na kuni tum kunum ei, enim na kuni ngołmun, nga na noł numbii nił ei, enim na noł ngołmun. Nga na konu eipi wu ei, enim na enim ngii konu sipiłmin. ");
INSERT INTO nii_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na alap pei sineririm kunum ei, enim na alap ngołmun. Na ening pałiłim kunum ei, enim na paki tok, kan kun er si mołułmun, nga kan ngii peł kunum ei, enim ok na kanik ełmin,’ a nimba. ");
INSERT INTO nii_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nga wumb oł kun ka ełmin wumb ei ek nik orung kindik yi ningii, ‘Owundu, sin nim kunum nenj nim kuni mułun, sin nim kuni ngunjpun? Pe nga kunum nenj nim noł numbii nen, sin noł tu wupun nim ngunjpun? ");
INSERT INTO nii_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kunum nenj nim wumb eipi konu mułun, sin nim sipin sin ngii konu sipinjpin? Nga kunum nenj nim alap pei sinerang, sin alap nim ngunjpun? ");
INSERT INTO nii_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kunum nenj nim ening tang pen sin nim er ka er paki tupun, nga kan ngii pen sin opun kanpin enjpin ei, kunum nenj enjpin?’ ");
INSERT INTO nii_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pe king owundu ek nipi orung kindpi yi nimba, ‘Na enim kin ek keimi nind. Enim epi endi na nge angnan noł kin endi enjing ei, na kin enjing ku.’ ");
INSERT INTO nii_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“King owundu eim ek ei nipi poru nipi, nga wumb angił tundung mulnjung wumb ei kin ek yi nimba, ‘Enim am pungii wumb, enim am si kindik, dup konu pungii ei poru ninermba mon. Pe dup ei, na Ernan er sim konu ełe Seisen kin eim enjel ei poru dup konu ełe kunum kunum mułngii,’ pa nimba. ");
INSERT INTO nii_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‘Nimbił erang ok na kuni muls kunum ei, enim na kuni ngunerik mon. Nga na noł numbii nił ba enim na noł ngonałmin mon ku. ");
INSERT INTO nii_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na wu konu eipi wu mult ba enim na sik, enim ngii konu sipnerik. Nga alap pei sinerim kunum ei, enim na alap na ngunerik mon. Nga na ening peng, kan ngii pep muls kunum ei, enim na ok kinarik na paki tunenjing mon.’ ");
INSERT INTO nii_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yi mił neng kin, wumb ombu ek nik orung kindik yi ningii, ‘Owundu, kunum nenj nim kuni tang mułun, sin nim kanpin kuni ngunenjpin? Nga kunum nenj nim noł nuwa erang mułun, sin nim noł ngunenjpin, nga nim alap pei sinerang, sin alap ngunenjpin, nga nim ening peng, kan ngii ei, sin kunum nenj sin opun kinenjpin?’ ");
INSERT INTO nii_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wumb ek yi nengin, owundu eim ek nipi orung kindpi yi nim, ‘Ba na ek keimi nip enim ngond. Pe enim kunum endi na engnan noł paki tok enenjing kin, nga enim na kin paki tok enanmin mon ku,’ pa yi nimba. ");
INSERT INTO nii_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pe, wumb tiłap ei enim kumep kis singii ei, kunum kunum ngenj kumbii sik, dup konu kis mułngii. Ba wu oł kun ka ełmin wumb ei, en enim Jiisas Owundu kin kunum kunum konj mułngii.” ");
INSERT INTO nii_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jiisas eim ek ekin nipi poru nipi pendpi, kunum ełe eim ek eim nge er se endim wu ombu ngum. ");
INSERT INTO nii_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Enim piinmin! Kunum tał mendpił Gos Esrel wumb paki tum kunum ei ‘Pasopa’ kuni owundu nołmun kunum; niłmin, ei tonu wang kunum ełe, Gos tonu epin konu ełe mani kindang opu ya mei ełe wu kingam tełim mułum ei, wumb sik, ond peri ełe to kundngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kunum ełe, eim kułmał kałiłmin wumb ni wumb noman pim wumb pei, en enim kułou tunjung. Ei wu Kaiyapas eim kułmał kałiłim wu owundu eim ngii ełe kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tok, “Sin nipe oł mił erpin Jiisas ambił gii nipin, sipin koi erpin tumun?” ");
INSERT INTO nii_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ba en enim nik yi ninjing, “Sinim kor kunum kuni owundu numun kunum ei yi enermin, wu amb sinim kin opu erngii,” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jiisas eim Besanii konu kinj num wu Saimon ngii konu ełe mułum. ");
INSERT INTO nii_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Pe amb endi om. Opu, eim noł mił kopung ku ming mił epi endi ku owundu mendpił pułum noł mił, kopung mur ka tołum ni sipipi, Jiisas kuni peł ełe kuni nopu mułum konu, peng ełe bein tum. ");
INSERT INTO nii_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jiisas nge ekii siłmin wumb oł ei kanik, en enim popuł sik, ek yi kii sinjing. “Nimbił erang noł mił kopung ei mur ka wii ku owundu pułum ei wii kindim? ");
INSERT INTO nii_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pe sinim kopung ka wii ei nge simin ni piiłamin kin, kopung ei ku owundu sipin ei, wumb kurpu epi sinerang wii mołmun wumb ei ngołmun.” ");
INSERT INTO nii_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jiisas en enim ninjing ek ei eim piipi, eim ek nipi wu ombu ngum, “Nimbił erang enim amb ek embin nik ngonmun? Amb ei eim oł ka wii na kin erim,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","“Kunum kunum wumb epi sinałiłim wumb enim kin ouni mołmun. Ba na enim kin kunum kunum mulał mon! ");
INSERT INTO nii_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Amb ei eim kopung ka wii ei na ngenj ełe kindim, ei eim erpi na tukpu ełe mani kindmba nge erim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","“Na ek keimi nip enim ngond, konu orung orung ei Gos nge ek ka ei ba. Pang, wu amb ek ei piik, wumb en enim oł ei piingii. Piik, amb ei oł yi erim ni piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Kunum ełe kii siłmin wu engki nga tał mulnjung wu ei endi embe, ‘Juras Eskeriyas’ niłmin, wu ei pupu kułmał kałiłim wumb owundu mulnjung konu ełe pupu nim. “Na Jiisas enim angił ełe ngunj kin, enim nipe na ngungii?” Yi mił neng kin, en enim ku engki tekliki beltik tor kindik, eim ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kunum ełe, Juras Jiisas sim kułmał kałmin wumb angił ełe kindmba nge, kurpu endim. ");
INSERT INTO nii_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Kunum kumna kuni owundu Esrel wumb bres, ‘yiis’ niłmin, epi ei kindnałmin, bres wii nołmun kunum ei, tonu om. Jiisas eim nge ekii siłmin wumb ok yi ninjing, “Sin konu jiłi nim kuni owundu ei yi ku Pasopa niłmin kuni ei, sin er kun er mułamin nunjii?” ");
INSERT INTO nii_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pe eim ek yi nim, “Enim konu owundu Jerusalem ełe tuk pungii. Puk, wu endi kanik yi ningii, ‘Sin ek emb to ngołum wu endi nge kuni numba ngii kan si ngui! Eim kunum mandi enim,’ pa ningii. ‘Na nge ekii sik kongun ełmin wumb kin ouni kuni nungii ei Pasopa niłmin, kunum ei tonu wang nim ngii ełe numun enmin,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pe Jiisas eim nge ekii sik ełmin wumb eim nim mił yi erik, kuni owundu Pasopa nungii nge er kun enjing. ");
INSERT INTO nii_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Konu pou neng, Jiisas eim nge ekii sik ełmin wumb engki nga tał ouni kułou tok, kuni nungii enjing. ");
INSERT INTO nii_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Molk kuni nok molk, Jiisas eim ek yi nim, “Na ek keimi nip enim ngond, sinim ya mołmun konu tuk ełe, wu endi mołum wu ei, na sipipi, opu orung wumb ongii kanpi ni ngumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pe ekii sik ełmin wu ombu en enim noman embin piik, wu eipi eipi eim kii sik yi ninjing, “Owundu, ei na min mon?” ");
INSERT INTO nii_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ba Jiisas eim ek nipi orung kindpi yi nim, “Wu endi na kin ouni eim bres ełe mani dis ełe kindim wu ei, na sipi, opu orung wumb ngumba. ");
INSERT INTO nii_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gos kindim wu kingam na kułmbii pa ni Gos nge ek ka mer mon ełe yi ni pałim mił ermbii. Ba wu endi eim na sipipi, opu orung wumb ełe kanpi nipi ngum wu ei, Gos eim kin kumep kis wii ei eim kin ngumba. Pe mam eim mengnenełang kin ei ka wii piłang.” ");
INSERT INTO nii_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yi neng, Juras wu eim sipipi ni peni ełe kindmba wu ei ek yi nim, “Ek mon tołum wu, ei na min?” Jiisas ek nipi yi nim, “Ninim ek nin wu ei mendpił.” ");
INSERT INTO nii_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Kunum ełe en enim kuni nok molk, Jiisas eim bres sipi, Gos kin noman ka ngopu, prei erpi bres engin topu, eim nge ekii siłmin wumb wu ombu ngum. Ngopu ek yi nim, “Enim sik bres, ei na nge ngenj mił mei!” ");
INSERT INTO nii_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nga sipi ond mong noł wain ming kap ei sipi, Gos kin noman ka ek ni ngopu prei erpi noł wain ni ngum. Ngopu, yi nim, “Enim noł wain ei pei nei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nipi yi nim, “Noł wain ming ei, na nge miyem mił enim nunjung. Na miyem ei nge andan topu, Gos ek dinga nipi pendim ei dinga keimi pałim, nga na miyem bein top, wumb oł kis enjing ei, kil ngumbii ku. ");
INSERT INTO nii_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na ek keimi nip enim ngond; pe nga ekii se ei na noł wain endi nga nunermbii moł pup ekii se Erinjpin Gos sinim tep er mołum konu ei, sinim ende mułmun kunum ei, noł wain konj numbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","En enim golang konj endi nik poru nik, anda puk, tonu komung Olip ełe punjung. ");
INSERT INTO nii_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jiisas ek nipi eim ekii sik ełmin wumb wu ngopu yi nim, “Akip emii pimba kunum ei, enim na kin pii gii dinga pei pinermba ba aninga kopur pimba. Nga na si kindik konu eipi eipi pungii. Nimbił erang Gos ek yi ninim, ‘Na kung siipsiip tep wu to kundamb, kung siipsiip ei konu eipi eipi pungii,’ ninim. ");
INSERT INTO nii_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ba nga na angip konj tonu pup, ok Galilii konu ełe kumb se tor pamb, enim ekii se ongii,” Jiisas eim yi nim. ");
INSERT INTO nii_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piisa eim Jiisas kin ek nipi yi nim, “Nim kin ekii siłmin wu ombu, en enim pii gii ei wakin tungii; ba na nim kin pii gii nind ei, wakin tunermbii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jiisas ek nipi Piisa ngopu yi nim, “Na ek keimi nip nim ngond, akip emii pimba kunum ełe, kei kultu wii tunerang kin, nim kunum tekliki ek yi ninjii, ‘Na wu ei na kan poł tunał,’ pa yi ninjii.” ");
INSERT INTO nii_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piisa ek nga nipi yi nim, “Na nim kin ouni kułmbii; ba nim na kan poł tunał, yi ninermbii mon!” Nga eim nge ekii sik ełmin wu pei ek yi minj nik punjung. ");
INSERT INTO nii_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pe Jiisas kin ekii sik ełmin wumb konu endi orung punjung, konu ei embe Gesemanii, niłmin. Konu ełe pu molk, Jiisas eim ek nipi eim wu ombu ngum, “Enim ya ełe mułei! Na orung pupu, prei ermbii,” nipi pum. ");
INSERT INTO nii_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pupu, Piisa sipi, nga Sependii kingam tał kin ouni punjung. Puk, eim noman tuk ełe endi mił erpi, eim noman embin piim. Piipi kin, eim pii kis piim. ");
INSERT INTO nii_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Piipi, ek nipi wu kei ngopu yi nim, “Na noman embin tang, ei owundu erang kułmbii peng piind. Enim ya ełe molk, na kin ouni tep er mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nipi, aninga kopur andpi pupu, eim kumb sipi, mei ełe kindpi Erinjpin Gos kin prei erim. Erpi, ek dinga nipi yi nim, “Na Ernan, oł embin tui ei nim kapłi orung sinjii. Nim na nge noman ełe kapłi ekii sinenjii ei mon; ba ninim noman ełe piinjii mił ei, nim erii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jiisas eim orung pupu, eim ekii sik ełmin wumb ei kenim ni or pengin kin opu to konj kindim. Kindpi kin, eim ek nipi Piisa ngopu yi nim, “Nimbił erang enim wu tekliki kei na kin akip eni endeim ei mendpił na kin tep er mulałmin mon? ");
INSERT INTO nii_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Enim tep ka er mułngii ni prei er mułangin, mon pim kin Seisen nge epi ei enim kin sikir tor omba. Enim noman tuk ełe dinga sałim ba; nga ngenj oł ei dinga pinałim mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Kunum nga endi eim orung pupu, prei erpi ek dinga nim, “Na Ernan, ya oł embin tui ngenj kumbii ei, na si kindmbii ni piind; ba nim na noman ełe ekii sinerii! Ninim nge noman oł minj erii!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jiisas eim nga opu kenim ni ekii se ełmin wu ombu or pek mulnjung. Mułangin, wu ombu en enim ningił or peng mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Nga wu ombu si kindpi pupu, prei erim. Ei kunum tekliki mił yi erim. Prei erim ei eim ok prei erim mił nga yi erim. ");
INSERT INTO nii_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ekii se eim opu, eim nge ekii sik ełmin wu ombu kanpi, to konj kindpi, ek yi mił nim. “Enim nga or pek kor mołmun min? Pe mendpił kunum tonu om wu endi opu, Gos kindang wu kingam mołum wu ei sipi, oł kis ełmin wumb angił ełe pendngii nge ongii enmin. ");
INSERT INTO nii_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Enim angk, mułangin sinim pamin! Wu endi na opu orung wumb kin ngumba, eim pe mandi onum.” ");
INSERT INTO nii_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jiisas eim ek nipi mułang, Juras wu ei Jiisas nge ekii sik ełmin wu engki nga tał, wu tuk mołmun wu, endi om. Om konu wumb tiłap owundu endi ouni onjung. Onjung wumb ei tui kiłeng epi ni, kepii owundu mułum epi sik si mengk onjung ei wumb kułmał kałiłmin wu ni, Jura men ngii noman pim wu ombu wumb ei kindnjing. ");
INSERT INTO nii_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juras wu ei opu orung wumb ngum wu Jiisas kan sipi ninj kin pupu ngunj kangiłpi yi enj kin, ei “Enim noman peng onmun wu ei ermbii,” pa nim. “Nga enim ok kin eim ambił gii nik sipngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pe Juras eim opu Jiisas mułum konu mendpił kun opu yi nirim, “Ek emb tołum wu, nim kapłi mołun min?” Nipi kin, Jiisas mułum konu ełe eim ngunj kangiłim. ");
INSERT INTO nii_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pe Jiisas ek nipi yi nirim, “Wu puł, nim enjii on oł ei sikir enjii!” Wumb pei sikir ok eim ambił gii ninjing. ");
INSERT INTO nii_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wu endi Jiisas kin mandi mułum wu ni angił mani kindpi, tui kepii endi sipi kułmał kałiłim owundu nge kongun wu onjung wu ei endi tang kom kiłip topu mani pum. ");
INSERT INTO nii_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pe Jiisas ek nipi yi nim, “Nim tui kepii ei orung kind pim konu pend. Nimbił erang wumb pei tui ełe opu ermin ni erangin wumb pei tui mond kułngii. ");
INSERT INTO nii_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Pe nim piinan. Na Ernan wii tamb eim nge enjel pei, na paki tok kindang ongii, ei opu tiłap engki nga tałtał ei to mani kindmba mił,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ba na yi mił eramb kin, Gos nge ek ok ełe pałim ełe nge na kułmbii nge nind ei, ek pułe keimi tonu onermba mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pe kunum ełe Jiisas eim ek nipi, wumb tiłap onjung wumb ei ngopu yi nim, “Eim tui ni dolu epi ambilk tu wunmun na sik ei waning wu endi mił ambił gii ningii enmin min? Kunum kunum na Jura men ngii owundu ełe mołup ek nip wu amb ngop er muls ba enim na ambił gii ninenjing mon! ");
INSERT INTO nii_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ba kumb ok Gos oł ekii se ermba ei piik niłmin wumb ombu ek mon ok pulk ek ei keimi tonu om. Ei yi mił epi pei tonu om.” Pe Jiisas nge ekii sik ełmin wumb pei eim si kindik sikir punjung. ");
INSERT INTO nii_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wumb ok Jiisas ambił gii nik sipik, kułmał kałiłim wu owundu Kaiyapis eim ngii ełe sipnjing. Pe lo ek poltmun wumb ni peng pim wumb pei kułou tok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piisa Jiisas sipnjing konu ekii se pum; ba eim turii mił yi pum. Eim pupu kułmał kałiłim wu ei ngii kung gui ełe nirik pum. Pupu, opu wu mulnjung konu ouni mulnjung. Pe Piisa eim epi nipe erngii nipi kan mułum. ");
INSERT INTO nii_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nga kułmał kałiłim wu owundu ni kaunsil wumb pei ek piik kun pinałim ek kend wu ni ek nipi nik Jiisas to kundngii ek ei wu kombur kan simin ninjing. ");
INSERT INTO nii_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Pe wumb pei ok ek kend tok yi ninjing. Ba eim to kundngii ek endi kan sinenjing mon. Nga ekii se wu tał okuł. Ek yi ninjngił, “Wu ei, ‘Gos men ngii owundu ei er kis mondpu, nga kunum tekliki mendpił tekmbii,’ nim,” pa yi ninjngił. ");
INSERT INTO nii_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nga kułmał kałiłim wu owundu angpi ei ek nipi Jiisas ngum, “Nim ek endi ni orung kindnenjii min? Nipe ek wumb ek ei nik nim kin ngonmun?” a nim. ");
INSERT INTO nii_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ba Jiisas eim ek endi ninerim. Nga kułmał kałiłim wu owundu ni ek nipi ngum, “Na nim kin nip kii simbii end ei Gos Owundu nge embe ełe ni kunum kunum konj mołum ei nge nimbii end. Ei nim ek nikin sin ngan piimin. Nim Gos kindim wu Krais Gos nge kingam min mon?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jiisas ek ni orung kindpi yi nim, “Nim ek nin mił ei poru ninim. Ba na enim kanip nind. Ekii se kunum nga Gos kindang opu mei ełe wu kingam wu ei na keningii ni Gos dinga owundu angił tundung ełe mołup, na Gos nge epin kupu ełe pei peng mani ombii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","66","Jiisas ek yi mił neng kin, kułmał kałiłmin wu owundu ni popuł sipi eim konduk ei to piltan to kembis kembis erim. Erpi ek yi nim, “Gos kin ek buł morung ninim. Sin eim kin ek nga piinermin. Ek kis ei enim wumb pei piik poru ninmin. Enim er piinmin mił nenj?” a nim. Wu num ombu eim ek dinga nik orung kindik yi ninjing, “Eim oł kis endi erim, kumep kis sipi eim kułmba,” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","Pe enim Jiisas kumb ełe jipambił tok, eim tunjung. Wumb ombu en enim angił kin se andik eim tunjung. Tok ek yi ninjing, “Nim ek nikin oł ekii se tonu omba nge ek niłin ełin wu ni pe nim nii kepii tonum?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piisa eim torung mołpu, eim ngii ełe kung gui tukrung mułum. Kunum ełe pe kongun amb endi opu yi nim, “Nim wu ei Jiisas Galilii konu ełe wu ni mołun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ba Piisa ek nipi wumb pei ngopu yi nim, “Nim ek nin ek ei na pii kun enand mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pe nga eim anda pupu ngii tak tor kindiłmin ełe mułum. Nga amb endi opu ek nipi wumb mulnjung ei kanpi nim, “Wu ei Jiisas kin ouni Nasares konu ełe mulnjunguł kenj wu,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piisa nga ek dinga nipi tonu kindpi yi nim, “Na ek keimi mendpił nind, na wu ei na kinał,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ekii se wumb molk nga wu kombur ok ek nik yi ninjing, “Keimi, nim tiłap wu ei nge ek ninim ei mił ku nim ek ende nin ei sin piipin ninmin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nga Piisa eim ek dinga mendpił nipi yi nim, “Na ek keimi mendpił ninenj kin Gos na to kundmba. Na wu ei kinał mon,” nim. Nipi poru neng, kei kultu wii tum. ");
INSERT INTO nii_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pe Piisa mołpu piim ni Jiisas eim kanpi nirim ek ei piim. Ek yi nirim, “Kei kultu wii tunerang, na nge embe kunum tekliki yi mił ninjii ei, ‘Nim na piinan.’” Pe Piisa anda pupu ke dinga nim. ");
INSERT INTO nii_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Konu tingang, kułmał kałiłim wumb ni wu peng pim wu pei Esrel wumb kin ek nik piik Jiisas to kundngii ek endi nimin ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jiisas eim kan tok sipik, Pailos Rom gapman owundu endi mułum konu sipik ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pe Juras eim Jiisas sipi, opu orung wumb ngum wu ei, eim kenim ni Jiisas kos erik kin, oł embin tui ngangin, Juras kanpi kin, eim noman ak topu kin, ku engki tekliki se mengpi, orung tu wupu kin kułmał kałiłmin wumb ni peng pim wumb mulnjung konu sipi ngumbii ni tu wum. ");
INSERT INTO nii_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Pe eim ek yi nim, “Na oł kis enj. Na wu ei mong endi sinerim ei ni to kindinj. Pe eim to kundngii enmin,” pa nim. Ba wu ombu en enim ek yi ninjing, “Ei sin epi mon ei, ninim nge epi,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pe Juras ni wu ei eim ku ni olkup topu men ngii owundu ełe tuk kindim. Kindpi, eim pupu kan to kułmbii ni pupu, kułum. ");
INSERT INTO nii_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ba kułmał kałiłmin wu Owundu ombu ku ei sik kin ek yi mił ninjing, “Wu endi to kundmun nipin ku ngunjpun ku ei nga ya sinim kin orung ngonmun, ei men ngii ełe nirik sipnermin. Nimbił erang ku ei miyem ku.” ");
INSERT INTO nii_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wumb ombu en enim ek endi ni piinjing, Piik yi ninjing, “Ku ei sipipin mei endi wumb niłmin mei ełe, ‘Wu endi mei ming sin ełim,’ mei ei top enjing. Konu turii, wumb ei tukpu ełe simba.” ");
INSERT INTO nii_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Yi ninjing konu ei embe sik wumb yi niłmin, “Mei ei miyem mei,” nik konu ei pe sałim ku. ");
INSERT INTO nii_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Kumb ok Gos eim ek endi ni tor kindiłim wu Jeremaiya gupu ełe neng kin oł ekii se tonu omba ei piip nirim mił keimi tonu om. Eim ek yi mił nirim, “Esrel wumb ku 30 ei, Jiisas top nik enjing mił ku ei wu endi mei ming sin ełim mei ei top er sinjing. Ei Owundu nirim mił yi mił keimi tonu om poru nim.” ");
INSERT INTO nii_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jiisas sipik Rom gapman owundu Pailos mułum konu kumb ełe endindnjing. Pe Pailos ei ek nipi eim kii sim. “Nim Jura wumb king mołun min?” Jiisas ek yi nim, “Ei ninim ek yi nim.” ");
INSERT INTO nii_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ba kułmał kałiłmin wu ni peng pim wu ombu kin ek endi nik Jiisas kin ngunjung ni eim ek endi nipi orung kindpi ngunerim. ");
INSERT INTO nii_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pe Pailos ek nipi Jiisas ngopu yi nim, “Nim kos erngii wumb ek pei ninmin ei nim piinan min?” ");
INSERT INTO nii_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ba Jiisas eim ek endi nipi orung kind ngunerim mon. Yi erang kin Pailos eim puku sipi nimbił erang enim ni piim. ");
INSERT INTO nii_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nga kuni owundu ‘Pasopa’ niłmin kunum ełe, kan ngii pałiłmin wumb ei kung ngii endeim endeim ni gapman wu owundu ei kan wu tor kindpi ełim ei wumb pei en enim wu ei omba nengin Pailos tor kindiłim. ");
INSERT INTO nii_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pe kunum ei, wu kis wii endi kan ngii pirim, wu ei embe ‘Barapas,’ niłmin. ");
INSERT INTO nii_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wumb kułou tok mułangin kin, Pailos ek nipi wumb kii sirim, “Na wu nii endi enim kin tor kindmbii? Pe na Barapas kindmbii min? Jiisas Krais ninmin ei kindmbii?” ");
INSERT INTO nii_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailos eim piim, wumb pei Jiisas embe to mani kindmin ni piinmin sin sinim embe to tonu ba ni piik, tu wuk kos ełe tu wunjung ni piim. ");
INSERT INTO nii_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pailos eim kos piipi ek nipi kun ełim konu ełe mułang, eim nge ambim ei ek nipi kindpi yi nim: “Nim wu oł kun ka wii ei oł kis endi enerim wu ei kin oł endi enerii! Na akip epin or kumb wu ei kin er kanip noman embin tang moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ba kułmał kałiłmin wumb ni peng pim wumb ei ok wu amb wii mulnjung ełe ek dinga ngok yi ninjing. Enim Pailos kin kii sipi, “Barapas kindan wii pangłi nik Jiisas to kundei yi nei!” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ba gapman owundu ni ek yi nim, “Ya wu tał mołmbuł ei wu nii endi enim kin kindmbii?” Wumb pei molk yi ninjing, “Barapas wangłi!” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailos ek nipi orung kindpi yi nim, “Pe na Jiisas kin nimbił oł ermbii Krais pa ninmin ei?” Wumb pei molk yi ninjing, “Ond peri ełe tonu to kundii!” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ba Pailos ek yi nim, “Nimbił erang wu ei eim oł kis nimbił oł endi erim?” Pe wumb wii dinga tok yi ninjing, “Tonu ond peri ełe to kundii!” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailos eim yi piim, “Na ek nind ei kapłi enanim, wumb ek pei nik dinga enmin ei opu tonu omba,” ni yi piim. Piipi, eim wumb pei mulnjung konu ningił ełe eim angił was erpi yi nim, “Na wu ei kin oł kis endi erpi wu ei to kundngii ninand mon. Ei enim wumb pei en enim noman ełe nimbił oł erngii, na mon.” ");
INSERT INTO nii_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pe wu amb wumb pei ek ni orung kindik yi ninjing, “Ei sin oł kis enmin wumb ei nge sin kangił ni sin pe pułe sin sinim kin kumep kis tonu omba,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wumb yi nengin kin, Pailos Barapas tor kindang pum. Pe Jiisas eim opu wumb angił kindnjing, kepii tok ei sipik ond peri ełe to kundngii nge sipnjing. ");
INSERT INTO nii_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pe Pailos nge opu ełmin wu ombu Jiisas sipik gapman ngii ełe nirik sipik eim kin kułou tok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Molk, eim konduk ei gulk kindik, king mił kon sakis kundii eipi endi kindnjing. ");
INSERT INTO nii_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kindik, nga eim peng ełe peng kon mondunmun nik kan jimbiltang ei nge kirang ombu engin to sik kin tonu eim peng ełe mundnjung. Pendik dolu endi sipik eim angił tundung ełe engindnjing. Nga en enim mandi ming gopsing pii poł molk eim kin se ek kulsik ek paki tok yi enjing. “Jura wumb wu king owundu nim kunum kunum kinan mołułum wu,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Nik, eim kumb ełe jipambił tok, kepii sim ni sik eim peng ełe kepii tok yi enjing. ");
INSERT INTO nii_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eim kin se ek kulsik oł yi er poru nik, king mił konduk kundii eipi ni gulk tor sik, konduk eim nge orung kind pendnjing. Pendik eim sipik, ond peri ełe ni tungii nge sipnjing. ");
INSERT INTO nii_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pe andłam ełe punjung ni Sairiini wu endi om wu ei embe Saimon. Wu om konu, “Ond peri ei ko wii!” Nengin, Jiisas ond peri ei wu ni ko wum. ");
INSERT INTO nii_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Puk konu endi tor punjung konu ei embe, ‘Golkasa’ niłmin, konu ełe tor punjung. Konu ei wumb kaniłmin ni, wumb peng embił ni kumb ningił ni yi mił seng kanik kin konu embe yi mił niłmin. ");
INSERT INTO nii_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wumb noł wain endi ngunjung eim nopu piim ni epi endi eim num ni kumbii erang piipi mon nim. Nimbił erang eim noł ei nopu kułii mił kołpu peng kin eim ngenj kumbii simba pinerang kin mon nim. ");
INSERT INTO nii_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Pe Jiisas ond peri ełe nil to pendik, eim nge konduk sik kin opu ond wumb ku kembis mił epi ei kinjmał erik kin wu nii endi eim konduk simba nik yi enjing. ");
INSERT INTO nii_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pe opu ond wu ombu mani molk kin Jiisas kin tep er mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ok mon endi to pendnjing konu ełe Jiisas peng ełe pim. Ei kos piinjing ek ei nge nik mon polk pendnjing, “Ei Jiisas, Jura wumb nge king.” ");
INSERT INTO nii_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jiisas pim konu orung orung ełe wu tał opu erkił epi waning sikił epi ełmbił wu tał ond peri ełe to pendnjing. Wu endi Jiisas angił tundung pim. Endi angił taring orung pim. ");
INSERT INTO nii_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Wu amb ni wumb ok Jiisas kin ek buł morung nik peng ak tok orung enjing. ");
INSERT INTO nii_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Erik yi ninjing, “Nim men ngii owundu ei kis mułang nga kunum tekliki konj tekmbii nin wu; pe nim Gos kingam keimi pim kin, tonu ond peri ei si kindkin mani wan kinamin!” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Yi mił ku lo ek piiłmin wumb ni peng pim wumb ni kułmał kalk ełmin wumb pei molk eim kin ek buł ambilk yi ninjing. “Eim wumb eipi kin paki tum; ba eim akip eim paki tunermba mon. Eim sin Esrel nge wumb king pim kin, kapłi pe tonu ond peri ełe si kindpi mani wang, sin eim kin pii gii nimin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Eim Gos kin pii gii nipi kin na Gos kingam moł ninim. Ei Gos eim kin noman ngum kin, akip eim paki tang kenmin,” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pe wu tał epi waning sikił ełmbił wu tał ond peri ełe to pendnjing wu tał Jiisas pim konu mandi pinjngił wu tał ek buł ambilkił ninjngił ku. ");
INSERT INTO nii_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pe konu tinga eni kunum beli sałim kunum ei emii pim. Pep, pang pang nga konu pou neng eni tekliki erim. ");
INSERT INTO nii_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Konu eni tekliki ermba erang, Jiisas eim wii dinga topu Jura nge wumb ek ełe yi nim, “Eli eli lama sambasani?” Yi nim ei pułe yi, “Na Gos nim na nge Gos nim na nimbił erang si kindin?” ");
INSERT INTO nii_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ba wu kombur mandi molk piinjing ni yi nim, “Neng kin, wu ombu molk mon, wu ei ek ni tor kindiłim wu Elainja wii tonum,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pe sikir wu endi tuk mulnjung wu ni pupu omb ngenj nok sinjing ei sipi noł wain ełe mani kindpi; kindang kin noł wain kopup tuk seng dolu endi sipi dolu topu sipi Jiisas ngamb noł ei numba ni sipim. ");
INSERT INTO nii_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ba wu kombur molk yi ninjing, “A nim giyeng ni moł. Eim nimbił oł ermba ei kenmin, yi neng kin, Elainja opu eim paki tonum min ei kenmin,” ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jiisas nga wii dinga tum. Pe eim nge noman tuk ełe kindang pum. ");
INSERT INTO nii_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kunum ełe mendpił men ngii owundu ełe alap owundu endi tuk Gos nge men ngii palting ełe ondu ngo pendnjing konu ełe wumb tuk punałmin konu pendnjing alap ei tonu piltan topu mer mani tor pum. Pupu, alap opu tał mił yi erim. Erang kin, wumb Gos kin pungii nge aki tum. Topu, kunum ełe, mendpił kon kopu owundu tang kin, kom ku owundu pim ni mani pupu purum. ");
INSERT INTO nii_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nga mer mei ełe wumb kułii tukpu tołmun konu ei ombułpu aki topu wii seng kin Gos eim wumb pii gii ni molk, kulnjung wumb ombu angk tonu ok konj mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Nga en enim mer tukpu ełe wakin to si kindik angk tonu ok kin ok Jiisas eim kołpu; nga angpi tonu opu konj mołpu, tonu konu owundu ka wii ełe tuk peng wumb pei kenjing konu ełe en enim tuk punjung. ");
INSERT INTO nii_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Opu ełmin wumb tep ełmin wu ni opu wu kombur kin mulnjung ni konu kopu topu oł kanim kanim erim ni kenjing ei Jiisas pim konu tep er mulnjung wu ombu en enim oł ei kanik tungu erik,” yi ninjing. “A keimi wu, ei Gos nge kingam mołum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Amb pei mulnjung amb ei Jiisas ek ekii siłmin amb ombu Galilii konu si kindik eim kin ouni tu wunjung ok eim paki tunjung; ok konu turii mił angk kenjing. ");
INSERT INTO nii_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Amb mulk konu tuk ełe amb kombur mulk, amb ei endi Mariya Makandala kin Mariya endi Jeims angim kin Josep tał menginjngił kin, nga amb endi Sepndii nge kingam tał ei menginjngił kin mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Konu pou neng, wu endi om wu ei embe Josep, wu ei Jiisas nge ekii siłim wu, Aramasiya konu ełe wu eim ku pei sałiłim wu. ");
INSERT INTO nii_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Josep eim opu, Pailos mułum konu kii sipi yi nim, “Jiisas ngenj ei na sipmbii min?” nipi kii sim. Seng kin, Pailos eim opu wumb ei neng, Jiisas ngenj ei tu wuk eim ngunjung. ");
INSERT INTO nii_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Pe Josep ni wu ei eim alap konj kuru endi sipi, Jiisas ngenj ełe pandi tum. ");
INSERT INTO nii_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Pe Jiisas ngenj ei sipipi eim nge tukpu konj ełe pendim. Eim tukpu ei tuk kom ku owundu ełe wumb kombur sik, konu ełe Jiisas tuk kind pendik, kom ku owundu endi sik peri ngok sipik pendik tukpu ełe pendnjing. Pendik, en enim punjung. ");
INSERT INTO nii_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariya Makandala niłmin amb ei kin, Mariya niłmin amb endi kin ouni mulnjunguł. Amb tał tukpu peng ełe mandi molkuł kankił mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kupiiring nga kor kunum epi er kun ałmin kunum ei opu peng, kułmał kałiłmin wu ni, lo ek ekii siłmin wu ni pei puk Pailos ngii konu kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tok, Pailos kanik yi ninjing, “Wu owundu, sin piinmin ei, wu ek konj mułpu ek kend wu ei, ‘Kunum tekliki mendpił tukpu ełe angip op tonu bii,’ ninim ninmin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Nga ek yi ninjing, “Nim ek yi ninjii, ‘Tukpu ełe pandi dinga tok, tep ka er mułangin kin, kunum tekliki poru nimba. Mon peng kin, eim nge ekii sik ełmin wu ok waning sipik wumb kanik nengin ninjing, ei eim ngenj tuk ełe pinałim, eim angpi tonu opu konj pum.’ Ek ok ek ei op ekii seng, ekii se ek kend ei opu kumb ełe ba pałim.” ");
INSERT INTO nii_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailos ek nipi orung kindim, “Enim puk tep mułngii opu wu tiłap endi singii. Sengin, puk tukpu ei pandi tok dinga wii er pendngii. Enim ełmin mił erngii.” ");
INSERT INTO nii_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Yi neng, puk tukpu pandi dinga tungii punjung. Puk, tukpu ełe oł endi dinga enjing ei wumb tuk onerngii nik kin, tukpu ełe to dangndik pendnjing. Nga opu wu kombur tukpu ełe, “Tep er mułei!” nengin, tep er mulnjung ku. ");
INSERT INTO nii_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kor owundu kunum poru neng, kupiiring mandi ełe amb Mariya Makandala seng kin, nga Mariya endi kin ouni okuł, Jiisas tukpu ełe kenmbił nikił onjnguł. ");
INSERT INTO nii_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pe sikir konu kopu owundu tum, Gos Owundu nge enjel tonu epin si kindpi mani om. Opu, ku ni ambił ak tang, ak topu orung pupu pim. Peng kin, tonu peł ełe eim tonu mułum. ");
INSERT INTO nii_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Eim nge kumb ełe kupu kuru mił tiłang erim. Nga konduk ei kupu mił kuru mendpił pim. ");
INSERT INTO nii_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Opu wu ombu en enim mund mong erik, puku sik wumb kułii mił mendpił pek mulnjung. ");
INSERT INTO nii_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ba enjel ek nipi amb tał ngopu yi nim, “Ełip mund mong enereł mon! Na piind ełip Jiisas kurkuł onmbuł ni piind. Wu ei ond peri ełe to kundnjung. ");
INSERT INTO nii_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eim ya konu ełe mulałim, eim angpi nga konj tonu pum. Eim ok ek nirim mił yi erim. Pe ełip okuł eim pim konu ei keningił weł!” nim. ");
INSERT INTO nii_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Pe ełip amb tał sikir pukuł, eim nge ekii siłmin wu ombu mulnjung kankił kin, ek yi ninjngił, ‘Eim tukpu ełe si kindpi, nga angpi konj tonu pum. Piinmin! Eim Galilii konu ek pupu mułmba punum, enim ekii se puk eim konu ełe keningii,’ pe na ek nipi ełip ngunj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Amb tał eł ełip mund mong erkił ka piikił sikir pukuł tukpu si kindkił ei nge ekii siłmin wu mulnjung konu kankił yi ninjngił. ");
INSERT INTO nii_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Nikił pangił nga sikir Jiisas eim amb tał andłam ełe kan sipi ek yi nim, ‘Ełip onmbuł?’ Nga amb tał eł ełip eim simb ełe ambił gii nikił molkuł ek ka nikił prei enjngił. ");
INSERT INTO nii_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jiisas ek nipi amb tał ngopu yi nim, “Ełip mund mong enerel! Ełip pukuł na engnan noł kan ningił. Nengił kin, puk Galilii konu ełe puk mułangin kin, na konu ełe wumb ei keningii,” yi nim. ");
INSERT INTO nii_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Amb tał andłam ełe tuk pukuł opu wu ombu konu owundu ełe puk kin kułmał kałiłmin wumb mulnjung konu epi tonu om mił ek kanik onjung mił ninjing. ");
INSERT INTO nii_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pe kułmał kałiłmin wumb ei ni peng pim wu num ombu kułou tok molk ek nik, “Opu ełmin wu ombu ku owundu ngumun,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nik, opu wu kanik ku owundu ngok ek yi ninjing, “Enim yi ningii, ‘Sin or pinjpin kunum ei eim nge ekii siłmin wu ok eim ngenj ei waning sipnjing,’ yi ningii,” pa nik. ");
INSERT INTO nii_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","“Nga gapman wu owundu ei eim ek endi nim kin, sin eim kin ek nemin, enim kin ek endi pinermba,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Yi mił nengin kin, opu ełmin wumb ku ei sik kin, oł ei nik mił endi ei enjing. Nga ek ei Jura wumb konu orung orung pei piik pangin, pe ek ei piinmin ku. ");
INSERT INTO nii_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Eim nge ekii sik wu engki nga endeim ei puk Galilii komung konu punjung. Puk, ełe punjung ei Jiisas ek nipi mił konu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Puk, Jiisas kanik eim kin ek ka nik men tok erik; ba wu kombur noman tał er pim; “Ei Jiisas mendpił min wu eipi da?” ni piinjing? ");
INSERT INTO nii_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jiisas eim wumb mandi opu ek dinga nipi eim wu ombu ngopu yi nirim, “Gos eim mei ełe noman dinga ni tonu epin noman dinga ei pei na ngum. ");
INSERT INTO nii_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Enim ei piik, konu orung orung wumb pei kin puk, na ek ka enim kin ngok, wumb ei na kin pii gii ningii ei na nge wumb pei ekii sik mułngii. Wumb ei noł pingii ei, na Ernan embe ni na eim kingam embe ni Gos Gui Ka embe ełe noł pendik dambiltik ende puk ngungii. ");
INSERT INTO nii_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Enim na ek nip ngond mił yi enim puk wumb kanik ek yi nik ngungii, enim piinmin ei na enim kin kunum kunum moł, ei moł pamb kunum poru nimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ek ka ei nge Gos kingam Jiisas Krais nge ek ka tonu om. ");
INSERT INTO nii_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wu endi embe Aisaiya, Gos ek ni tor kindiłim wu, ek kos ei nge ok yi mił pułum. Eim Gos ek ka nipi eim kingam kin ngum, “Na wu endi nim nge ek poł kindamb sipi nim. Ei nim andłam topu ba; yi mił ekii se wumb nim onjii ni piik mułngii. ");
INSERT INTO nii_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Wu endi wumb mulenjing konu ełe wii dinga topu mołum. ‘Wu owundu eim omba enim. Enim noman tuk ełe er kun erik mułngii!’” ");
INSERT INTO nii_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jon wumb noł pendpi ngołum, wu eim ełe wumb mulenjing konu, eim Aisaiya kumb ok nirim mił tonu orum. Jon eim Gos ek ka endi nipi wumb ngum. Ngang kin, “Wumb noman ak tok pii gii nengin kin noł pendpi ngum. Ngang kin, Gos wumb oł kis ombu kil ngopu si kindmba. ");
INSERT INTO nii_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pe Jura mei owundu wumb kin, Jerusalem konu tuk mulnjung wumb kin pei punjung. Puk, Jon mułum konu ełe tuk punjung. Puk, Jon mułum konu oł kis ombu ni tor kindik ngunjung. Ngangin kin, wu Jon wumb noł pendpi ngum. Noł ei embe Joran. ");
INSERT INTO nii_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pe Jon eim kon endi kindiłim, konduk ei, kung kamil ngenj ełmin, kon ei kindim. Jon eim kan endi tuk kend ełe, tuk sipi tełim ku. Eim guimbu kin, piimi muł kin, nopu endim. ");
INSERT INTO nii_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pe Jon ek nipi wumb ngum, “Wu num endi na ond konu ełe ekii se omba wu ei, na dinga ei kapłi si kindmba. Na wu ka mon, na mei ełe wu mendpił. Na eim simb su kan ei kapłi si kindmbii, ba eim wu num mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","“Na enim noł mendpił pendpi ngond; ba wu endi ekii se omba wu ei eim, Gos Gui Ka ełe noł pendpi enim ngumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kunum ei, Jiisas Galilii Nasres konu ełe si kindpi om. Pe Jon Jiisas noł Joran ełe noł pendpi ngum. ");
INSERT INTO nii_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kunum ełe Jiisas eim noł si kindpi, opu kenim ni, tonu kupu muł wuł ał pum. Pang kin, Gos Gui Ka kei Kurmuł mił mani opu, Jiisas kin mułum. ");
INSERT INTO nii_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pe Gos ek ka endi ei tonu muł ełe tor opu yi nim, “Nim na kingam mendpił, na nim noman pałim. Na noman ka wii nim kin ngond,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Sikir Gos Gui Ka Jiisas sipi mei wumb mulenjing konu ełe sipi kindim. ");
INSERT INTO nii_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jiisas mułum kunum ei 40 pei mułum. Pe Seisen eim Jiisas ermba mił kenmbii ni erim. Erang kin, Jiisas eim kui, ka, kei, kung simbii nin, epi mulnjung konu ełe mułum. Ba wumb mulenjing mon. Nga Gos enjel eim paki tunjung. ");
INSERT INTO nii_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nga ekii se Jon kan ngii mułum, kunum ei Jiisas Galilii konu ełe opu, Gos ek ka nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ngopu yi nim, “Gos kunum ełe tonu omba nirim pe tonu onum. Gos sinim tep erpi omba enim. Enim noman tuk ak tok Gos ek ka pii gii ningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nga Jiisas noł gopu Galilii wer ełe andpi mułum. Jiisas Saimon kin, angim Endru teł kenim. Wu tał noł gop ełe omu kon polkuł mulnjunguł. Wu tał, omu kongun ełe ełmbił wu. ");
INSERT INTO nii_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jiisas ek nipi wu tał ngum, “Ełip na ond konu ekii se weł! Ełip na ek ka nip ngamb, ełip wu yi mił singił,” pa nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pe sikir, wu tał omu kon si kindkił, onjnguł. Okuł, Jiisas pum konu ełe ekii se punjnguł. Pukuł, ekii se, eim ek piingił nge punjnguł. ");
INSERT INTO nii_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nga Jiisas aninga kopur pupu kenim ni, wu Sependii nge kingam Jeims kin, angim Jon kin, alting noł kanu ełe molkuł, omu kon er ka er mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pe kunum mendpił, wu tał eim “Ełip weł!” nim. Neng kin, wu tał erinjngił, Sependii kin, kongun wu kin konu ełe mond si kindkił, Jiisas pum konu ełe, ekii se punjnguł. ");
INSERT INTO nii_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nga enim Kapaniyam konu ełe punjung. Kunum ei kor kunum, Jiisas men ngii konu ełe nirik pum. Pupu, Gos nge ek ka pułngun mondpu wumb nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nga wumb ei Jiisas ek nim piik puku sinjing. Nimbił erang, Jiisas Gos nge ek ka kengip tołmun wumb mił, nipi ngunerim mon; ba eim wu num endi noman dinga pim mił, yi nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nga kunum ei, wu endi men ngii ełe tuk mułum wu ei gui kis tuk mułang kin, wii dinga tum. ");
INSERT INTO nii_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nim Nasares nge konu ełe wu Jiisas nim sin kin nimbił oł enjii en? Nim okun sin to kis enjii on min? Na nim piind, nim Gos nge wu kun ka kindang on,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ba Jiisas gui kis ei ek dinga nipi ngum, “Nim ek tingnerii! Nim wu ei si kindkin pui!” nim. ");
INSERT INTO nii_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pe gui kis ei wu ek ei to kindpi, wii dinga tum. Topu kin, wu ei topu si kindpi tor pum. ");
INSERT INTO nii_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pe wu amb pei puku sik endnjing. Andik, wumb en enim ek nik, piik piik enjing. “Ei epi nipe? Ei ek konj endi nim, wu ei noman dinga pałim. Nimbił erang, eim ek nipi, gui kis ngang, gui kis eim ek piinjing?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jiisas yi mił erang, eim ek mei Galilii konu ełe pei sikir pang, wumb piinjing. ");
INSERT INTO nii_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pe men ngii si kindik anda puk, wumb Saimon kin Endru kin ngii konu ełe nirik punjung. Jeims kin Jon teł nirik punjnguł ku. ");
INSERT INTO nii_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pe Saimon ambim mam peł ełe eim ening tang or pim. Wumb Jiisas kanik ninjing. ");
INSERT INTO nii_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nengin kin, Jiisas pupu kin amb mam nge angił ambłang, engim. Angpi, ening tum ei, ening poru nim. Pe amb mam eim kuni nungii ni kałpi er kun er mułum. ");
INSERT INTO nii_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pou neng ełe, eni mani ba erang, wumb pei ening pim wumb Jiisas mułum konu ełe tu wunjung. Wumb kombur gui kis pim, kopur ening pim wumb onjung ku. ");
INSERT INTO nii_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Konu owundu, wumb pei kułou tok, ok ngii ondu ełe mandi ok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nga Jiisas eim wumb ening kanim kanim pim er ka erim. Pe eim gui kis kopur pei si kindim ku. Gui kis ombu, Jiisas eim piyangin kin, ek yi nim, “Gui kis enim ek ninerngii!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nga kupiiring okrii, Jiisas eim tor pupu, konu wumb mulenjing konu ełe pum. Eim Gos kin prei er mułum. ");
INSERT INTO nii_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nga Saimon kin angim noł Jiisas pum konu ełe ekii sik punjung. ");
INSERT INTO nii_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Puk, kan sik kin, yi ninjing, “Wumb pei nim kuruk mołmun,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jiisas ek nipi wumb ngum, “Sinim mei konu eipi eipi endi pamin! Ya mandi na ek nipi, wumb ngumbii pałim ku. Ełe nge, na okrii onj.” ");
INSERT INTO nii_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pe Jiisas Galilii mei konu pei pupu endim. Jiisas men ngii konu nirik pupu, Gos ek ka wumb nipi ngum. Eim wumb gui kis pei top tor kindim. ");
INSERT INTO nii_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nga kinj num wu endi opu, eim gopsing pii poł mołpu, Jiisas kanpi, ke nim, “Nim noman pim kin, kapłi na er ka enjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jiisas wu ei kaimb sipi piim. Piipi kin, wu angił ambiłpi kin, ek yi nipi ngum. “Na piind ei nim ka mulnjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jiisas ek nipi, wu ei ngang kin, kinj num wu ei sikir ka mułum. ");
INSERT INTO nii_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jiisas wu ei ek dinga ni ngopu, sikir kindang pum. ");
INSERT INTO nii_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Jiisas wu ei kin ek yi nipi ngum, “Nim wu endi kankin, oł ełe ninerii mon! Ok Moses ek nirim mił nim pukun, ‘Nim ngenj men ngii kułmał kałiłim wu konu ełe andan tunjii. Kumo kindpi, kułmał kałpi nim si kin ngunjii. Kiłang kin, nim ngenj ka erim ni keningii!” pa nim. Nipi, Jiisas wu ei kindang pum. ");
INSERT INTO nii_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ba wu ei pupu, wumb pei kanpi nipi, eim wumb mulnjung konu ełe, pei kanpi, ek pol topu ngum. Yi mił erang Jiisas eim konu endi kanpi nim, wumb pei mulnjung konu tuk ba pinerim mon. Eim andaring minj mułum konu orung wumb mulenjing wumb konu ełe orung orung wumb pei eim kin onjung. ");
INSERT INTO nii_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Nga kunum kopur o pang, Jiisas Kapaniyam mei konu ełe nga orung om. Wumb Jiisas piinjing ni, eim ngii konu ełe mułum. ");
INSERT INTO nii_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nga wumb pei kułou tunjung. Pe ngii konu ełe piki topu, poru nim. Ngii ondpuł ełe konu endi wii sinerim mon. Nga Jiisas eim ek ka nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wumb wu endi ening pim wu endi eim mułum konu tu wunjung. Wu ei miyem kułang eim embił dinga pinerim. Wu kapił kapłi ening pim wu ei, ko wuk tu wunjung. ");
INSERT INTO nii_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Konu ełe wu amb pei piki tum. Pe wu ei tuk Jiisas mułum konu tuk tu wungii pinerim. Pe Jiisas mułum konu orung, ngii engimb tok altap ninjing. Pe wu miyem kułum wu nge peł ełe kindik mani kindnjing. ");
INSERT INTO nii_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Pe Jiisas wumb pii gii pim ei kenim. Kanpi kin, ening pim wu ei kin yi nim, “Kingnan, na nim oł kis kil ngop si kindind.” ");
INSERT INTO nii_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pe men mon połmun wumb mulnjung. En enim noman ełe ek dinga ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nimbił oł erang wu ei Gos ek buł morung?” ninim. Nipi, “Eim Gos ek ambiltim,” a ninjing. “Wu endi oł kis kil ngopu, si kindnermba mon! Ei Gos nge kongun minj pałim,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Noman kis piik wu kei en enim noman tuk ełe, Jiisas piipi, eim ek yi nipi ngum, “Nimbił oł erang enim noman tuk ełe yi piinmin? ");
INSERT INTO nii_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nipe ek endi nga embin pinałim? Na yi nimbii, ‘Na nim oł kis kil nop, si kindmbii’ ei min, ‘Nga nim peł sikin, angkin pui!’ a nimbii? Ei enim oł embin ei enim kin pałim min? ");
INSERT INTO nii_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ba na minj ek nemb eim ka mołang, enim na pii poł tungii! Wu kingam ei noman dinga mei ełe pałim ei kapłi, oł kis kil ngumba.” Pe ek nipi, wu ei simb angił kis mułum wu ei ngopu, yi nim. ");
INSERT INTO nii_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Na nim ek nipi ngond, nim peł sikin angkin, ngii konu pui!” ");
INSERT INTO nii_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wu ni wumb mulnjung konu sikir angpi, peł sipi, pum. Pe wumb pei puku sinjing. Sik kin, Gos embe ambił tonu kindik yi ninjing, “Ok sin jep oł ei nge endi kinenjpin,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiisas nga noł gop ełe endim. Wumb tiłap owundu endi eim mułum konu ełe kułou tok onjung. Pe Jiisas eim Gos nge ek ka nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Pe eim andpi pupu, Liiwai, Alpiyas nge kingam kenim ni, ku takis siłim wu ngii konu ełe mułum. Pe Jiisas eim ek yi nipi ngum, “Nim na ond konu ełe ekii se oi!” a nim. Neng kin, eim angpi, Jiisas pum konu ekii se pum. ");
INSERT INTO nii_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jiisas Liiwai ngii konu ełe mułpu, kuni num. Nopu, wumb takis siłmin wumb kin oł kis ełmin wumb pei, Jiisas kin kuni nunjung. Jiisas nge ekii siłmin wumb eim kin kuni nunjung ku. Nga yi mił wumb kanim kanim pei Jiisas pułum konu ełe, ekii se pułmun ku. ");
INSERT INTO nii_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nga wumb lo ek piiłmin wumb nge mon ek połmun wumb kenjing ni, Jiisas eim wumb ku takis siłmin wumb kin wumb oł kis ełmin wumb kin, Jiisas kuni ende nopu mułum. Pe wumb ombu ek nik, Jiisas nge ekii siłmin wumb kin ninjing, “Nimbił erang Jiisas wumb ku takis siłmin wumb kin, wumb oł kis ełmin wumb kin, kuni ende nonmun?” ");
INSERT INTO nii_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jiisas ek ei piipi pendpi kin, eim ek nipi wumb ngum, “Wumb ening pałim wumb ond mong piiłmin wumb mołum konu ełe pułmun. Wumb ening pinałim wumb, ond mong piiłmin wumb mołum konu ełe punałmin. Na wumb kun ka mołmun wumb kin onenj mon! Na mani opu, wumb oł kis ełmin wumb kin onj; enim noman ak tok piingii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kunum endi Jon nge ekii siłmin wumb kin lo ek piik ekii siłmin wumb kin kuni mowii mulnjung. Mułangin kin, wu kopur ok Jiisas kanik yi ninjing, “Nimbił oł erang Jon nge ekii siłmin wumb kin lo ek piik ekii siłmin wumb kin kuni mowii mołmun? Ba nim nge ekii siłmin wumb ei kuni mowii mulałmin.” ");
INSERT INTO nii_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pe Jiisas ek nipi kii sim, “Eim kan nołum wumb pei wu endi amb simba erim kunum ei, enim kuni ende nunerngii min? Pe wu ei en enim kin ende molk kin, kunum ełe kuni si kindnerngii mon. ");
INSERT INTO nii_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ekii se wu ei angił sengił poru nimba kunum, ei eim kan nołum wumb kin tep to mulermba. Nimbił erang wumb eim sik orung sipi enjing kunum ełe, eim kan nołum wumb kuni ei kapłi mowii mułngii.” ");
INSERT INTO nii_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jiisas ek ekin nga yi mił nim, “Wu endi alap konj tilarpi endi sipi, tukpu ełe pandi tum kin, konduk ei eim yi mił erim kin konduk ei piltan tumba. Alap konj ei opu kembis, ba kon ok nge piltan topu kis mondpu tukpu owundu ermba. ");
INSERT INTO nii_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Wumb ond mong wain noł sik ming konj ełe kindiłmin. Nimbił erang noł wain ei dinga ełim. Nga ming ok nge tuk kindiłmin ei noł wain dinga tor opu ming gał tołum. Pe noł wain ming gał tang, noł wain mei ełe pum.” Ek ei yi mił ninim Jiisas ek ok nge kin konj kin ende pinermba nipi ek ekin yi mił tum. ");
INSERT INTO nii_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Kor kunum Jiisas aka pin andłam sim konu ełe andpi pum. Pe Jiisas nge ekii siłmin wumb eim kin tep tok punjung. Puk kin, kuni kopur aka pin puk andik sik nunjung. ");
INSERT INTO nii_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pe lo ek piik ekii siłmin wumb, Jiisas kanik ek dinga ninjing, “Piini! Kor kunum ełe kongun mowii ninjing ba nim nge ekii siłmin wumb oł ei nimbił erang enmin?” ");
INSERT INTO nii_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nga Jiisas ek nipi ngum, “Enim Deipis Gos ek ka enim ger piinenjing min? Na ek ei nind, kunum ei eim kin eim wumb pei kuni sineririm kunum nind. ");
INSERT INTO nii_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nimbił erang Deipis kuni tang, Gos ngii ełe nirik pum. Pang kin, kułmał kałiłim wu ei mołpu bres sipi eim ngum. Ngang kin, Deipis sipi nga eim wumb kin bres ei nunjung ku.” ");
INSERT INTO nii_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jiisas ek nipi wumb ngum, “Gos kor kunum ei wumb paki tumbii nipi kor kunum sim. Ba wumb kor kunum paki tunerngii mon,” yi nirim. ");
INSERT INTO nii_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","“Yi mił wu kingam epin konu si kindpi mani mei ełe opu tonu om; wu ei mendpił kor kunum wu owundu mułmba ku.” ");
INSERT INTO nii_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiisas men ngii konu ełe nga nirik pum. Wu endi mułum wu ei, angił orung kis mołpu, miyem kułii erim. ");
INSERT INTO nii_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wumb Jiisas mułum konu kanik mulnjung. Kor kunum Jiisas wu ei er ka ermba min mon, ni kanik mulnjung. Molk kin, kunum ełe en enim Jiisas kin kos ermin ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jiisas ek nipi wu ei angił kis mułum wu ei kin ngum, “Nim ya wa!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jiisas ek nipi wumb pei ngum, “Sinim kor kunum oł ka ermin ei kapłi min? Sinim kor kunum epi kis ermin ei kapłi min? Sinim wumb to kundmun min paki tamin ka mułngii min?” Ba wumb ek nik orung kindnenjing mon. ");
INSERT INTO nii_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jiisas wumb mulnjung konu orung orung kind kenim. Kanpi kin, eim popuł sim. Nimbił erang Jiisas wumb kanpi wumb noman tuk ełe piim. Wumb noman tuk ełe dinga peng, wumb pii gii ninenjing ei eim piim. Pe Jiisas ek nipi wu ei angił kis mołum wu ei ngum, “Nim angił tun kindii!” nim. Pe wu ei angił tun kindang kin, nga kapłi ka erim. ");
INSERT INTO nii_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lo ek piik ekii siłmin wumb ok punjung. Puk kin, Eros wu owundu wumb mulnjung konu kułou tunjung. Tok kin, en enim ek ni piik piik erik Jiisas tumun ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jiisas kin eim ekii siłmin wumb konu ei si kindik, noł gop mułum konu ełe punjung. Pe wumb pei Jiisas pum konu ełe ekii se punjung. Wumb Galilii konu ełe kin, Juriya konu wumb kin pei punjung. ");
INSERT INTO nii_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Pe Jerusalem konu ełe wumb kin Erumiya konu ełe wumb kin, noł Joran orung, Taiya konu kin Sairon konu ełe wumb, pei Jiisas erim oł, ei piik pendik Jiisas mułum konu onjung. ");
INSERT INTO nii_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pe Jiisas eim ekii siłmin wumb kanpi yi nim, “Wumb pei mołmun ei, na ambił gii ningii, ni piind. Wumb ei na ambił gii ningii, en enim noł kanu endi tu wangin kin, na kapłi tonu pup mułmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pe wumb ening pim wumb ei, Jiisas ambił gii ninjing. Wumb Jiisas ngenj ełe embiłmin nik enjing. Nimbił erang, ok Jiisas wumb ening tołmun wumb ei er ka ełim ni piik onjung. ");
INSERT INTO nii_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nga wumb gui kis Jiisas kanik kin, enim gopsing pii polk molk kin, ek dinga tangk yi ninjing, “Nim Gos nge kingam mołun!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pe Jiisas ek dinga nipi ngum, “Enim gui kis, na embe ełe ek ni tor kindnerngii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pe Jiisas komung endi ełe tonu pum. Pupu kin, eim kin mułngii wu ombu to tonu kindmbii ni piipi kin wii tang, onjung. ");
INSERT INTO nii_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nga eim wu engki nga tał wumb nipi tonu kind mundpu wumb, ei eim kin mułngii nipi tonu kind mundum. Eim ekii siłmin wumb kindang, “Na ek ka ningii,” nipi kindang nge punjung. ");
INSERT INTO nii_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jiisas noman dinga ngamb kin, “Gui kis wumb kin mołmun ei tor kindngii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wu engki nga tał topu mundum wumb ei yi mił: Saimon, embe eipi endi ngum embe ei Piisa nim. ");
INSERT INTO nii_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Pe nga Sependii nge kingam Jeims angim Jon wu tał embe eipi endi sipi ngum, embe ei Bonesis. Embe puł yi mił nim, “Kupu muł ek tangiłim,” embe ei sipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Pe nga Endru kin Pilip, Basolomu, Masyu, Tomas, Alpiyas nge kingam Jeims, Tariyas, Saimon Siilas. ");
INSERT INTO nii_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nga wu Juras Eskeriyas konu ełe wu, ei eim Jiisas sipi opu orung wumb kin ngum. ");
INSERT INTO nii_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nga Jiisas ngii konu ełe pupu kin, nga wumb pei ok kułou tunjung ku. Yi erangin kin, Jiisas kin eim ekii siłmin wumb kuni nungii nge kunum endi sinerim. ");
INSERT INTO nii_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nga Jiisas nge tiłap ende wumb ek ei piinjing. Piik, ok kin “Jiisas simin,” nik onjung. Wumb ei ek yi ninjing, “Eim wulu punum,” ninjing. ");
INSERT INTO nii_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Wu num kombur lo ek piik nik tep ełmin wumb ei Jerusalem konu ełe molk mani onjung. Ok yi ninjing, “Gui kis Biyelsipul Jiisas eim kin tuk mulnjung. Ei eim gui kis owundu nge noman dinga ei gui kis pei wumb tuk mołmun ei, to tor kindim.” ");
INSERT INTO nii_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jiisas eim wumb mandi, “Wei!” nim. Jiisas ek ekin kopur topu wumb ngopu yi nim, “Yi mił Seisen eim kapłi Seisen to mani kindmba min?” ");
INSERT INTO nii_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Yi mił, king endi mołpu eim wumb tiłap palsik tał erik, “Opu erei!” nimba. Kapłi, tiłap ei dinga simba min? Ei dinga sinermba mon! ");
INSERT INTO nii_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pe ngii ende beltik en enim opu erngii. Erangin kin, ngii ełe dinga engnermba mon. ");
INSERT INTO nii_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Pe Seisen eim wumb kin opu orung eim kin kapłi Seisen eim dinga pupu mulermba mon. Eim poru nimba. ");
INSERT INTO nii_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Pe Jiisas ek ekin ei yi mił nim, “Wu endeim eim pupu, wu king owundu ngii endi epi simba mił pinałim mon. Simba, pim kin yi ermba. Wu owundu ei kan ngo pendpi, epi ei kapłi simba. Yi mił erpi nim kin, wu num ei epi ngii nirik mułum, epi sipi ngii er kis mondpu simba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jiisas yi nim, “Na ek keimi nind. Gos wumb pei kapłi oł kis kil ngo si kindmba. Si kindpi, wumb kin ek buł morung niłmin wumb ombu pei kapłi kil ngopu si kindmba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","“Ba wu endi Gos Gui Ka ek buł morung nipi, to mani kindmba wu ei, Gos eim oł kis ei kil ngopu si kindnermba mon mendpił. Pe yi ku sinim wumb endi ek yi ninermin ek ei, nga pepi tonu omba pałim wu ei, oł kis ei poru ninermba mon; kunum kunum pep mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nimbił erang wumb ek yi ninjing, “Jiisas gui kis nge dinga eim kin mołang pałim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kunum ełe Jiisas mam kin angim noł ok, andaring enginjing. Angk kin ek ni kindik, “Jiisas anda omba,” pa ningii. ");
INSERT INTO nii_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Wumb pei Jiisas mułum konu orung orung mulnjung wumb ei ek nik Jiisas ngunjung, “Nim manim, ainim, angnim noł ok kin andaring molk kin, nim wii tonmun.” ");
INSERT INTO nii_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pe Jiisas ek nipi orung kindim, “Nimbił oł enim? Wumb nii na angnan, manan noł mołmun, ei enim piinmin min?” ");
INSERT INTO nii_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jiisas orung orung kind kenim ni, wumb eim mułum konu orung orung pei mulnjung. Jiisas ek yi nim, “Ya kind kinei! Wumb ya mandi mołmun, wumb ei na manan, angnan noł mołmun,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","“Wumb endi eim Gos nge noman ełe ekii sipi erim kin, wumb ei na manan, einan, engnan noł mił mułmba.” ");
INSERT INTO nii_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nga Jiisas kongun nga erpi wumb kengip ek ngopu konu noł gop wer ełe nipi ngum. Nga Jiisas mułum konu wumb pei ok kułou tunjung. Tangin kin, Jiisas noł kanu endi ełe tuk pum. Jiisas pupu noł kanu ełe mołang kin, noł kanu ei pupu tuk noł gop ełe pim. Wumb pei noł gop mułum konu wer ełe mandi mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Pe Jiisas eim ek ekin pei to wumb ngopu ek yi nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Enim piyei! Wu endi kuni mong pei sipi aka pin kindim. ");
INSERT INTO nii_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kindim, kuni mong kopur ei ok andłam ełe mani pum. Pang kin, kuni ei kei ok nunjung. ");
INSERT INTO nii_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pe nga kuni mong kopur ku mułum konu ełe mani pum mei ełe, aninga pim konu ełe, kuni mong ei sikir tonu om. ");
INSERT INTO nii_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Nga eni tonu wang kin, kuni mong ei kułii erpi kułum. ");
INSERT INTO nii_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nga kuni mong kopur ei ond guimbin mułum konu ełe pum. Pupu kin, tonu omba konu sinerim. Sinerang kin, ond guimbin to mani kindang, mong tunerim. ");
INSERT INTO nii_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pe nga kuni mong kopur mei ka sim konu ełe pum. Kuni mong ei tonu opu, kuni mong ka tum kuni mong ei, tonu opu, kuni mong 30 aninga kopur tum. Nga tum ei kuni mong kopur 60 pei mił tum. Nga tum, pii kełpi topu ond kirang engin tumba er mułum ei 100 pei tum. ");
INSERT INTO nii_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wumb endi kom sepi piim kin, am dinga piyangłi!” ");
INSERT INTO nii_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ekii se Jiisas eim mendpił mułum. Pe Jiisas ekii siłmin wu engki nga tał mulnjung wumb kin tep tok mołangin wumb ei, Jiisas kii sik ninjing, “Nim ek ekin ei er ton mił nenj?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jiisas ek yi mił ni wumb ngum, “Gos koi er nim ek ei nge, Gos wumb top erpi mołum ei, enim kin andan top konu enim pei ngond. Ba wumb anda mołmun wumb ei, na nge ek ekin ei minj piik mołmun. ");
INSERT INTO nii_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Yi mił, ‘Ger piinjing, ba epi ei pii poł tunenjing mon. Nga ek ei piinjing, ba ek pułe ei pii poł tunenjing mon. Nga ek ei piinjing, ba ek pułe ei pii poł tunenjing mon ku. Mon pim kin, wumb ek ei pii poł tok kin, noman ak tok enjing kin, Gos en enim oł kis ei kil ngopu si kindmba.’” ");
INSERT INTO nii_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nga Jiisas ek nipi wumb ngum, “Enim ek ekin ei piinanmin min? Pe nga enim ek ekin eipi pei er piingii mił nenj? ");
INSERT INTO nii_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Wu endi kuni mong tełim wu ei, Gos nge ek ka ei tełim. Tałpi, kuni mong ei Gos nge ek ka mił mołum. ");
INSERT INTO nii_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nga kuni mong kopur andłam ełe pim mił ei, wumb Gos ek ka yi mił piinjing. Piik kin, wumb ek ei piinjing kunum ełe mendpił, Seisen sikir opu, Gos ek ka ei to ak topu eipi kindim. ");
INSERT INTO nii_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nga kuni mong kopur pupu mei ku mułum konu pupu sikir tonu opu yi mił pimba,” pa nim. “Wumb yi mił enmin wumb ei, Gos ek ka sikir piik sik kin, ka ka piiłmin. ");
INSERT INTO nii_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ba en enim dumbuł ei pinerang mulnjung kin, kunum aninga kopur mułangin kin, pe wumb kombur Gos ek ka to mani kindangin kin, oł embin tui tonu wang kin, wumb ei nge pii gii ei sikir to kis ermba. ");
INSERT INTO nii_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pe nga wumb kopur yi mił mułangin kin, kuni mong kombur ond guimbin mułum konu ełe mani punjung ei tonu omba erim; ba ond guimbin ei to mani kindim. ");
INSERT INTO nii_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ba wumb pei ya mani mei ełe epi ei noman to piinjing. Piik kin, ku ni epi ei noman kulk, nga ya mani mei ełe epi ei pei bun bun kulk yi enjing epi ei Gos nge ek ka ei to mani kindpi pandi tum. Wumb ei kuni mong ka wii mił endi tunerim mon. ");
INSERT INTO nii_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ba wumb kombur Gos ek ka piik sik kin kuni mong mił mei ka wii ełe mani pum. En enim noman tuk ełe kindnjing ek ka ei kindik ei, ambił gii ninjing. Pe kuni mong ei tonu opu kuni mong 30 mił aninga kopur tum. Nga tum kuni mong ei kopur pei 60 mił tum. Nga tum kuni mong ei pii kełpi topu ond kirang engin tumba er mułum ei 100 pei pei tum.” ");
INSERT INTO nii_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nga Jiisas ek ekin endi nipi ngum, “Wu endi dup alam kałpi, sipi mani peł ełe min kuni ming endi mandring pendmba min? Mon; ba wu ei dup kałpi sipi tonu peł ełe pindang, tiłang erang wumb nirik ngii konu ełe mułangin kin, kałpi kan kun erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Epi pei koi er mołum epi ei, ekii se pei peni ełe tor omba. Nga wumb pei sik ok ei er mołmun epi ei, ekii se peni ełe tiłang erang enim kenjngii. ");
INSERT INTO nii_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pe wu endi kom pim kin, kapłi wu ei eim kom se piyangłi. ");
INSERT INTO nii_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Jiisas ek nipi wumb ngum, “Enim ek piik ek ei pii kun erngii,” pa nim. “En enim ek ei piik pendik wumb eipi nik ngangin kin, Gos enim noman ełe ek ka ngumba. Wumb kopur epi aninga se mułngii ei, Gos nga ngumba. Ei pułe yi mił pałim. Wumb kopur Gos ek aninga ambił gii nik mulnjung kin, Gos wumb ei noman ełe eim Gos ek pei ngumba. Pe wumb kombur ek aninga ei nik wumb eipi endi ngunarik mulnjung kin, Gos ek ei topu tor kindmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jiisas ek ekin endi nga nipi wumb ngum, “Gos eim wumb tep enim yi mił, wumb kopur enim kuni mong aka pin kindnjing. Kindangin kin, kuni mong tonu opu kuni mong tum. ");
INSERT INTO nii_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kunum kunum emii peng, wu ei or pałiłim. Tinga, wu ei eim wii andpi mołułum. En enim kuni mong tałiłmin ei, połpu tonu opu owundu ermba mił nenj? Wu ei eim ei pii poł tunałim mon. ");
INSERT INTO nii_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nga mei eim erang kuni tonu opu, onguł tum. Topu, kuni mong topu onguł kumna tum. Topu, nga muł mondpu kin ekii se kuni mong tum. ");
INSERT INTO nii_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ba ekii se kuni mong topu owundu erim. Erang, kuni simba kunum mandi erang kin, wumb sikir tui kapera sik kiłip tołmun.” ");
INSERT INTO nii_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jiisas ek nipi wumb ngum, “Na kapłi Gos sinim tep enim ei nip ngamb, enim kapłi piingii min? Pe nipe ek ekin endi enim piingii, ek ei nemb piingii min mon?” ");
INSERT INTO nii_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gos eim wumb tep ka erang wumb pei tonu ołmun ei, yi mił kuni mong embe maser, niłmin. Kuni mong maser ei ya mei ełe kuni mong ei endi ende mił mon. Kuni mong ei kembis wii, wumb mani mei ełe taltmin. ");
INSERT INTO nii_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kuni mong ei talk poru nengin kin, pe kuni mong tonu opu, kuni kopur to mani kindiłim. Kuni maser ond kirang owundu ngołum. Kapłi, kei ombu emin ełe ok ond kirang ełe ngii takik jii niłim konu ełe mołułmun.” ");
INSERT INTO nii_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jiisas ek ekin pei nipi wumb ngum, ek ei ek ekin minj nipi wumb ngum; wumb noman piingii mił nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jiisas ek ekin minj topu nipi wumb ngum. Ek endi kun nipi tuk kindnerim mon; ek ekin minj nipi ngum. Jiisas nge ekii siłmin wumb mendpił mulnjung kunum ełe, ek ei pułe nipi eim ek ekii siłmin wumb nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kunum ełe pou neng, Jiisas ek nipi eim ekii siłmin wumb kin nipi ngum, “Sinim noł gop ełe orundung pamin!” nim. ");
INSERT INTO nii_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pe wumb pei mulnjung konu ełe si kindik pendik, Jiisas noł kanu mułum konu ełe, Jiisas ekii siłmin wumb tonu puk punjung. Nga noł kanu kombur ouni punjung ku. ");
INSERT INTO nii_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nga konu pop owundu endi tum. Pe noł kanu ełe noł tuk pupu kin, noł piki tumba erim. ");
INSERT INTO nii_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ba Jiisas noł kanu orung peng kiłandi erpi pim. Peng kin, eim ekii siłmin wumb Jiisas a nik wii tunjung, “Ek mon wu, sinim kułmun pałim ei, nim sin kin piin min mon?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pe Jiisas konj angpi, konu pop ek dinga wii nipi ngang, pop poru nim. Pe eim ek nipi noł ngum, “Noł nim mani pui!” pa yi nim. Neng kin, noł mani pang, pop poru nim. Pe noł tunarpi wii sim. ");
INSERT INTO nii_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nga Jiisas ek nipi eim ekii siłmin wumb ngum, “Enim nimbił erang tungu enmin? Enim nimbił erang enim nga pii gii ninenjing?” ");
INSERT INTO nii_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pe en enim ek nik piik enjing, “Wu ei noman dinga ei erpi sim mił nenj? Yi mił noł kin pop kin eim ek piikił pendkił mani pupu poru ninim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jiisas ekii siłmin wumb kin noł gop orundung punjung. Puk kin, mei Genesares konu ełe wumb nge mei. ");
INSERT INTO nii_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Pe kanu ełe tor wangin kin, wu endi gui kis pim endi, sikir opu Jiisas kenim. Kanpi, wu ei kom ku tukpu wumb sałiłmin konu mołpu om. ");
INSERT INTO nii_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wu ei eim or guimeng ku tukpu ełe pałiłim. Wumb wu ei kin kan sen to pendngii ei, dinga kapłi enermba mon. ");
INSERT INTO nii_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Yi mił kunum kunum wumb kan sen simb angił ouni to pendiłmin ei, topu kiłip tołum. Eim wu dinga wii mołpu kin, wu kombur wu ei kapłi kan tunerngii mon. ");
INSERT INTO nii_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kunum emii peng, tinga, kunum kunum eim tonu komung nin ku guimeng ełe minj mołułum. Eim kunum kunum wii dinga topu, eim ngenj ku ełe topu, yi minj ełim. ");
INSERT INTO nii_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nga wu ei Jiisas konu turii opu kenim. Kanpi kin, eim sikir opu, eim mong gopsing pii pułum. ");
INSERT INTO nii_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Eim wii dinga topu yi nim, “Jiisas, nim Gos kingam mendpił. Gos ei tonu mołpu wu dinga owii mołum ei, nim na kin nipe oł enjii?” pa nim. “Na ek keimi nip, Gos embe ełe nind ei, nim na kin ngenj kumbii nga ngunenjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Nimbił erang wu ei ek dinga nipi Jiisas ngum? Ngang kin, Jiisas ek nipi wu ei ngum, “Nim gui kis, nim wu ei kin si kindkin pui!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jiisas wu ei kii sim, “Nim embe nii?” a nim. “Na embe opu ond wumb; nimbił erang sin pei mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wu ei ek dinga nipi Jiisas ngum, “Nim gui kis pei mei ełe mołum to tor kindnenjii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pe kung pei tonu komung ełe kuni nok mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Pe gui kis pei wii tok ek dinga nik Jiisas ngunjung, “Jiisas, nim ni kindan, sin pupun kung mołmun konu ełe tuk bin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pe Jiisas kapłi neng kin, punjung. Gui kis pei ei wu ei kin si kindik punjung. Puk kin, kung mulnjung konu ełe tuk punjung. Pe kung dinga wii sikirik puk, konu kis endi sim konu punjung. Kung pei 2,000 yi mił mulnjung puk, noł gop mani puk kolk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pe wumb kung tep enjing wumb, oł ei kanik kin en enim tungu puk, konu owundu sim konu puk, wumb kanik, ek ninjing. Nengin kin, wumb ei puk oł ei kenjngii. ");
INSERT INTO nii_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nga wumb ei Jiisas mułum konu ełe ok, wu ei kenjing. Wu ei ok gui kis pei eim kin mulnjung; ba pe eim alap tałpi kin eim noman ka seng mułum. Nga wumb wu ei kanik kin tungu enjing. ");
INSERT INTO nii_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nga wumb kung tep enjing wumb epi ei kanik kin wumb eipi kin poł tok yi ninjing. “Ok, gui kis wu ei kin mułum; ba pe eim wumb kin mołpu pum. Nga gui kis ei pei kung kin tuk puk kin kolk poru ninjing.” ");
INSERT INTO nii_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pe nga wumb Jiisas kin ek dinga nik, “Nim mei ełe sikin, mei eipi endi punjii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Pe Jiisas kapłi noł kanu ełe tonu pum kunum ei, wu endi ok gui kis tuk mułum wu kii dinga sipi, “Na nim kin bii,” nim. ");
INSERT INTO nii_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ba Jiisas wu ei kin mon nirim. Nipi kin, Jiisas ek nipi wu ei ngum, “Nim nge ngii konu wumb tiłap ende mołmun konu ełe pui! Nim pukun, Owundu oł erim ei, wumb kankin Owundu eim nim kin kaimb piipi ngum, ek ei wumb kin ninjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pe wu ei pupu kin Diikapolis konu ełe pupu, Jiisas eim kin erim mił ei wumb konu orung orung wumb pei kanpi ek ni tor kindpi pum. Pang kin, wumb ek ei piik kin, wumb ei noman embin tok piinjing. ");
INSERT INTO nii_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pe nga Jiisas noł kanu ełe pupu, nga noł orung pum. Pupu kin, Jiisas noł gop wer ełe mułum kin, wumb pei eim mułum konu kułou tok onjung. ");
INSERT INTO nii_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pe wu owundu endi men ngii kongun tep ełim wu endi, ei eim embe Jairas. Wu ei Jiisas mułum konu opu kin, Jiisas simb ełe mong gopsing pii połpu ngum. ");
INSERT INTO nii_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Pe eim kii dinga sipi yi nim, “Na ambilnan pe mandi kułmba enim. Nim okun, eim ngenj ambiłan, eim nga konj kindpi mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pe Jiisas wu ei kin pum. Pupu kin, wumb pei Jiisas pum konu ełe ekii sik punjung ku. Yi mił peng kin, wumb Jiisas mułum konu piki topu pim. ");
INSERT INTO nii_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nga amb endi konu ełe mołułum amb ei, eim miyem gu niłim. Niłim, amb ei eim miyem opu pupu mułang mułang kung ngii angił orung orung nga tał o pang mułum. ");
INSERT INTO nii_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nga amb ei ngenj kumbii pei ko wupu kin, ond mong ngołmun wumb pei amb ei kenjing. Kanik kin, eim ku pei ngang sik, ba eim ening poru ninerim mon. Nga eim ening kis nga piram pałiłim. ");
INSERT INTO nii_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nga amb ei Jiisas oł kanim kanim erim mił piipi kin, Jiisas mułum konu ełe om. Wang kin, eim wumb pei Jiisas mułum konu ełe kułou tunjung konu ełe opu Jiisas nge konduk buł morung ełe embiłim. ");
INSERT INTO nii_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nimbił erang, amb ei eim yi ni piim, “Na Jiisas konduk ełe embiłamb kin, na ening poru nimba,” ni piim. ");
INSERT INTO nii_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Yi mił erang kin, eim miyem kołpu sikir poru nim. Nipi, eim ngenj tuk piim ni eim miyem ening poru nim kin, ka moł, ni piim. ");
INSERT INTO nii_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pe nga Jiisas yi piim ni, eim noman dinga kopur tor pum. Pupu kin, Jiisas eim kan orung kindpi wumb pei kanpi ek yi nim, “Wumb nii endi na konduk embiłim?” ");
INSERT INTO nii_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jiisas ekii siłmin wumb ek nik Jiisas eim ngunjung, “Nim kan! Wumb pei piki tonum. Nim nimbił erang wumb endi na konduk embiłim nin?” ");
INSERT INTO nii_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jiisas kanpi orung kind, wumb kanpi kin wumb nii endi enim ni piim. ");
INSERT INTO nii_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ba amb ei eim piim ni, epi ei Jiisas kin enim ni piipi kin, tungu erim. Amb ei opu Jiisas mułum konu ełe ming gopsing pii pułum. Połpu kin, eim ek keimi pei nipi Jiisas ngum. ");
INSERT INTO nii_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nga Jiisas eim ek nipi amb ei ngum, “Ambiłan, nim pii gii je, nim er ka enim. Nim pukun, noman ka seng kin, mułnjii. Nim ening ei poru neng, ka mołun,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pe Jiisas ek ei nipi mułang kin, wu owundu endi men ngii tep ełim wu, ei eim wumb kombur onjung. Ok kin, ek yi ninjing, “Nim ambił ei koltum. Nimbił erang nim ek mon wu noman embin nga ngon?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jiisas ek ei kom se piinarpi kin, ba Jiisas ek nipi men ngii tep ełim wu ei ngum, “Nim ek ei piikin, tungu enenjii mon; ba nim pii gii nikin mulnjii?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nga Jiisas eim wumb eim ba konu punerngii. Wu Piisa kin Jon, Jeims angim kin wu kei minj tep tok pungii. ");
INSERT INTO nii_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nga wu kei puk, men ngii tep ełim wu ngii konu ełe punjung. Puk kin, Jiisas kenim ni, wumb ke dinga owundu ninjing. ");
INSERT INTO nii_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Pe Jiisas ngii nirikring pupu, eim ek nipi wumb ngum, “Nimbił erang enim ke dinga wii nik mołmun? Ambił ei mendpił kulerim mon ba eim or mił pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nga wumb ei eim kin tokuł enjing. Pe Jiisas wumb pei topu tor kindim. Kindpi kin, arim mam kin, Jiisas ekii siłmin wu tekliki kin, nirik puk, ambił ei pim konu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Pe Jiisas ambił angił ełe ambiłpi yi nim, “Taliisa kum!” Ek ei pułe yi ninim, “Ambił kembis, na ek nip ngond, nim ang!” ");
INSERT INTO nii_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Neng kin, sikir ambił kembis ei angpi tonu om. Eim kung ngii engłi nga tał mendpił. Wumb oł ei kanik kin, puku sinjing. ");
INSERT INTO nii_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jiisas ek dinga nipi wumb ngum, “Enim wumb oł end ei kanik kin ek ninerngii mon! Enim kuni endi sik, ambił kembis ei ngei!” yi nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jiisas konu ei si kindpi, eim nge mei konu ełe pum. Jiisas ekii siłmin wumb, Jiisas pum konu ełe ekii sik punjung. ");
INSERT INTO nii_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nga kor kunum endi Jiisas pupu, men ngii ełe Gos ek nipi, wumb ngum. Ngopu, wumb pei Jiisas eim ek ei piik, puku sinjing. Sik kin, wumb ek yi ninjing, “Wu ei ek ei jiłi sim?” a ninjing. “Eim noman dinga ka ei jiłi mił sim? Pe eim jep oł ei erpi, owundu mił enim!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","“Pe wu ei ngii takpi ełim wu min? Nga eim Maria kangił, angim Jeims kin, Joses, Juras, Saimon, aim kin ya sinim kin mołmun min?” Yi nik kin, noman kis piinjing. ");
INSERT INTO nii_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pe Jiisas ek nipi, wumb ngum, “Ek keimi, ni tor kindiłim wu nge embe konu pei punum. Ba eim konu mendpił, eim miyem ende wumb nge ngii konu ei embe pinałim mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nga eim jep oł endi eim konu ełe ermba kapłi enanim mon; ba eim wumb kombur ening tumb wumb ei ambiłpi, er ka erim. ");
INSERT INTO nii_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Nga eim noman embin sipi yi piim. Nimbił erang wu amb eim kin pii gii ninanmin. Yi mił erang kin, pe eim pupu, mei konu orung orung andpi, eim Gos ek nipi, wu amb pei ngum. ");
INSERT INTO nii_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pe Jiisas eim wu engki nga tał eim kin wii topu, “Wei!” nim. Eim wu tał tał ni kindang, punjung. Jiisas eim noman dinga ekii siłmin wumb ngum. Ngang kin, wumb gui kis tuk seng kin, tor kindngii nipi, wumb ei noman dinga ngum. ");
INSERT INTO nii_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Eim ek nipi ekii siłmin wumb ngum, “Andłam pungii dolu epił endi singii. Epi eipi endi sinerngii! Enim andłam turii kepii embilerngii! Enim kuni bres endi sinerngii! Nga kon endi sinerngii; nga ku endi sinerngii mon ku. ");
INSERT INTO nii_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ba enim simb kum kindngii! Kindik kin, nga enim konduk torung tał kindnerngii mon!” ");
INSERT INTO nii_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pe Jiisas ek nipi wumb ei ngum, “Enim puk konu endi tor puk kin, ngii endi nirik pungii. Puk kin, ngii ełe minj pek wumb ek nik ngok, andik molk ekii se pungii. ");
INSERT INTO nii_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pe enim konu endi pangin kin, wumb enim ek piinarik kin, nga enim sik nirik sinenjing kin kapłi, en enim wumb ei si kindik pendik; konu eipi endi pungii. Puk kin, enim simb ełe kułman mułmba ei si kindik pungii. Yi mił erangin kin, wumb en enim ełmin oł kis ei kom se piingii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yi mił erang, pe Jiisas nge ekii siłmin wumb punjung. Puk kin, Gos ek ka ni tor kindnjing, “Enim wumb noman tuk ełe ak tungii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pe puk kin, gui kis mułum wumb ei gui kis tor si kindik, nga wumb kombur ening pim wumb ei, kopung kindik er ka erik punjung. ");
INSERT INTO nii_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pe King Eros eim ek ombu eim piim. Nimbił erang Jiisas nge embe konu pei andpi, kapłi erim. Wumb kopur yi ninjing, “Jon wumb noł pendiłim wu kułum ni, nga angpi orung onum. Yi mił erang kin, pe Jiisas eim oł dinga yi mił enim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba wumb kombur eipi yi ninjing, “Elainja ok ek keimi ni tor kindiłim wu ei pe onum,” pa ninjing. Pe wumb kombur eipi yi ninjing, “Ei ek keimi ni tor kindiłim wu ei mił, ek keimi ni tor kindiłmin mił wumb ok mulnjung,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ba King Eros eim pii poł tunarpi, yi ni piim, “Wu ei Jon wumb noł pendiłim wu, ok na eim peng kołmung enj ni, nga tonu onum,” Eros yi ni piim. ");
INSERT INTO nii_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yi mił kumb ok, Eros wumb kombur kindang puk, Jon ambił gii nik, kan sen tok kan ngii ełe kindnjing. Nimbił erang, Eros amb Erosiyas eim angim Pilip nge ambim ei sim. ");
INSERT INTO nii_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yi mił kin, Jon ek nipi Eros ngum, “Nim wu angnim ambim sin, ei kapłi enanim,” pa yi nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nga amb Erosiyas eim, “Jon to kundmbii,” nipi piim, ba ei kapłi enerim. Nimbił erang, Eros eim Jon kin mund mong tang kin, sipi kan ngii kindim. ");
INSERT INTO nii_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yi mił Eros eim yi ni piim, “Jon eim wu ka wii nin oł kun ka ełim wu mołpu kin, eim sipi kan ngii ełe tuk kindim. Eim Jon ek piipi mułum, ei eim noman embin tum; ba eim Jon ek nim ei piipi ka piim. ");
INSERT INTO nii_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ba ekii se Erosiyas, Jon to kundmba nge andłam yi mił kan sim. Eros ei kuni owundu endi erim. Eim mam mengim kunum ei eim kuni erpi, wumb wu num eim kin, tep ełmin paki tunjung wumb kin, opu enjing wu num kin, Galilii wu num kopur eim kin mulnjung wumb ei kin kuni owundu endi erim. ");
INSERT INTO nii_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yi mił Erosiyas ambiłam opu, non erang kin, pe Eros kin wumb eim kin kuni nunjung wumb eim kin noman ngunjung. Pe King Eros ek nipi ambił ei ngum, “Nim epi nipe sinjii? Ei nim na kin ek nen kin, piip na nim ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pe Eros ek keimi mendpił nim, “Nim epi endi simbii nin kin, kapłi na nim ngumbii. Na epi konu orung orung pei sałim ei, aninga orung na ngunjii nin kin, na kapłi nim ngumbii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pe ambił ei eim anda pupu eim mam kii sim, “Na kii sip, epi nipe endi simbii?” a nim. Eim mam ek nipi ngum, “Nim pukun yi ninjii, ‘Na Jon wumb noł pendpi ngołum wu ni peng simbii,’” pa ninjii. ");
INSERT INTO nii_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pe ambił sikir pupu Eros wu num mułum konu om. Pe ek dinga nipi Eros ni ngum, “Pe minj na piind, nim wu Jon wumb noł pendpi ngołum wu ei nge, peng sikin ming endi ełe tuk kindkin na ngunjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ambił ei yi neng kin, wu num Eros noman embin tum. Ba eim yi piim ni, “Ok na ek dinga wii nipi tonu kindinj.” Pe eim noman yi piim, “Wumb eim kin kuni nok mulnjung wumb, eim ambił ei ek nim ei, to kindmba pinerim mon,” ni piim. ");
INSERT INTO nii_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pe sikir wu num Eros opu ełim wu endi kindang pupu, Jon topu, peng simba nge pum. Opu ełim wu ei pupu, Jon kan ngii mułum topu, peng kołmung tum. ");
INSERT INTO nii_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Nga wu ei Jon nge peng sipi, ming endi kind sipipi kin, ambił ei ngum. Ngopu, ambił ei sipi kin mam ngum. ");
INSERT INTO nii_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Pe kunum ełe, Jon nge ekii siłmin wumb ek ei piik, Jon ngenj ei sik kin, tukpu tunjung. ");
INSERT INTO nii_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jiisas nge ek se andiłmin wumb orung ok, Jiisas kin kułou tunjung. Ok kin, ek poł tok, en enim enjing mił nik Jiisas ngunjung. Ngok kin, ek wumb kanik ninjing mił ok, Jiisas kanik ninjing ku. ");
INSERT INTO nii_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yi mił, wumb pei ok kin punjung kin, Jiisas kin ek se andiłmin wumb kin kuni nungii kunum endi sinerim. Pe Jiisas ek nipi eim ek se andiłmin wumb ngum, “Sikir, sinim wumb mulenjing konu endi pamin! Wei! Sinim pupun kor aninga mułmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pe nga noł kanu endi sik puk, wumb mulenjing konu ełe en enim minj puk mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pe wumb pei kenjing ni Jiisas ek se andiłmin wumb kin, noł kanu ełe punjung. Puk kin, wumb konu owundu nge wumb orung orung onjung. Wumb kanik, noł orundung sikir puk, orung tor puk mułangin kin, Jiisas ek se andiłmin wumb kin noł kanu ełe tor onjung. ");
INSERT INTO nii_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pe Jiisas orung tor pupu kenim ni, wumb pei onjung wumb ei Jiisas kaimb piim. Wumb ei kung siipsiip mił, wumb tep ełim wumb endi mulerim. Nga Jiisas eim kengpi ek pei pułngun mondpu, nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nga eni mani ba erang kin, Jiisas nge ek se andiłmin wumb ok, Jiisas kanik, ek yi ninjing, “Konu orung wumb mulenjing konu mołpun kin, eni mani ba enim. ");
INSERT INTO nii_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Nim wumb kindan pangin kin, puk konu eipi eipi puk, en enim kuni top tungii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ba Jiisas ek nipi eim nge ek se andiłmin wumb ngum, “En enim kuni wumb ei ngangin, nungii.” Pe en enim yi ninjing, “Sinim ku pei 200 mił sipin, bres top ermin, ei kapłi ermba min?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nga Jiisas ek nipi ek se andiłmin wumb ngum, “Enim bres nimberii sałim? Enim puk kinei!” Kanik poru nik, ek yi ninjing, “Sin bres angił orung kin, omu tał sałim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jiisas ek dinga nipi ngum, “Wumb pei mani mułei!” pa yi nim. “Tiłap mok tok mułei!” Jiisas yi neng mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pe wumb mulnjung wumb tiłap kopur 100 mulnjung; nga wumb tiłap kopur 50 mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Pe Jiisas bres angił orung kin omu tał sim. Pe Jiisas kanpi, tonu epin kanpi prei erpi, Gos ngum. Pe Jiisas bres engin topu, eim nge ek se andiłmin wumb ngum. Ngang kin, eim ek se andiłmin wumb sik, mok tok, wumb mulnjung wumb ei ngunjung. Pe Jiisas omu tał, yi ku engin topu, wumb ngum ku. ");
INSERT INTO nii_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Wumb pei kuni ei nangin kin kapłi erim. ");
INSERT INTO nii_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Pe Jiisas nge ek se andiłmin wumb bres kin omu orung kin pei sim. Orung sim kuni ei sik gerenj kon engki nga tał tok piki tunjung. ");
INSERT INTO nii_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nga wumb kuni bres ei nunjung wu ei, 5000 pei pei tuk mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jiisas eim ekii siłmin wumb kin, ek nipi tu wum. Tu wupu kin, “Noł kanu ełe tonu pei!” nim. Noł kanu sik, kumb se puk noł orung pungii,” pa nim. Konu endi Beseira, wumb ok kindang punjung. ");
INSERT INTO nii_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jiisas wumb pei neng, punjung. Puk kin, eim komung endi ełe tonu pupu, prei ermbii ni piipi, pum. ");
INSERT INTO nii_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nga pou neng, noł kanu tuk noł ełe pupu pim. Pe Jiisas ei mendpił minj noł orundung mei ełe mułum. ");
INSERT INTO nii_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Pe Jiisas kenim ni konu pop topu, noł kanu andłam punerim. Pe mandi tengmba erang kin, Jiisas ei eim noł peł ełe tonu angpi om. Opu, eim nge ekii siłmin wumb ei si kindip op bii ni erim. ");
INSERT INTO nii_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ba Jiisas ekii siłmin wumb eim kenjing ni, Jiisas eim tonu noł peł ełe om. Eim ekii siłmin wumb yi piinjing, “Ei gui endi mołum,” ni piinjing. Pe enim dinga wii tunjung. ");
INSERT INTO nii_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Yi mił, eim nge ek ekii siłmin wumb pei kanik, tungu enjing. Ba sikir Jiisas ek nipi eim ek ekii siłmin wumb ngum, “Enim noman tuk ełe dinga kindei! Na mendpił ond. Enim tungu enerngii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Pe Jiisas opu, noł kanu ełe tuk tonu pum. Pupu, eim ek ekii siłmin wumb ei kin mułang kin, konu pop ni tunerim. Nga eim ek ekii siłmin wumb mund mong tok kin, kom sek piinjing. Nimbił erang Jiisas ekii siłmin wumb eim nge noman dinga ei piinenjing. ");
INSERT INTO nii_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Nga Jiisas bres sipi, wumb pei nga nunjung ei, en enim pii poł tunenjing mon! Ba en enim noman tuk ełe dinga puk kin, pii gii mendpił ninenjing mon. ");
INSERT INTO nii_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wumb noł gop tumb tok orung Geneseres konu ełe onjung. Ok kin, noł kanu ei noł wer ełe kan tunjung. ");
INSERT INTO nii_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Wumb noł kanu si kindik kin, tor punjung. Puk kin, sikir wumb Jiisas kanik kin, ei Jiisas ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pe wumb sikir puk konu orung orung mandi sim konu ełe punjung. Puk kin, Jiisas mułum konu ełe ening pim wumb Jiisas mułum konu ełe tu wunjung. ");
INSERT INTO nii_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nga konu pei nin, konu owundu nin, konu eipi eipi nin, pei Jiisas andpi kin kapłi wumb ening pim wumb kułou tok mulnjung. Molk kin, wumb ek dinga nik, wumb ening pim wumb Jiisas nge konduk ambiłangin kin eim er ka ermba. Wumb pei Jiisas nge konduk embilnjing wumb, ei pei ka molk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Pe lo ek piik ekii siłmin wumb kopur, kin men lo ek piik połmun wumb Jerusalem si kindik, Jiisas kin kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Wumb ei kenjing ni Jiisas nge ek ekii siłmin wumb kombur kuni nangin kin, angił ok noł kindnarik, angił ka sinerim kuni nołmum. En enim nimbił erang sinim men tok oł enmin oł ei enanmin? Ei en enim noman tuk ka sinałim ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yi mił lo ek piik ekii siłmin wumb kin Jura wumb pei kin, en enim ok wumb ełmin mił men tok oł ei yi enjing. Angił noł kindnałmin kin kapłi kuni nunałmin. ");
INSERT INTO nii_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nga kuni top ngii ełe pułmun ei, orung ok angił noł kindnałmin, ei kuni nunałmin. Pe en enim men tok oł kanim kanim nga ełmin. Ok wumb oł ei nik ekii siłmin ku. Enim ming kin, kuni ming kin noł ming ełe nin peł ełe ei noł kind kindiłmin ku. ");
INSERT INTO nii_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pe men lo ek piik ekii siłmin wumb kin, men lo ek piik połmun wumb ok, Jiisas kii sinjing. “Nimbił erang nim nge ekii siłmin wumb men tok oł ełmin wumb oł ei mił enanmin? En enim angił penj mułang kin kuni nonmun.” ");
INSERT INTO nii_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pe Jiisas ek nipi wumb ngum, “Ek keimi ni tor kindiłim wu Aisaiya ek keimi nipi enim kin ngum. Enim oł endi piiłmin ba oł eipi ełmin wumb kin Gos ek yi mił Aisaiya mon enim kin pułum: ‘Wumb ei na embe ninim ei gupu ełe embe ambił tonu kindiłmin. Ba en enim noman tuk ełe kin na kin konu turii mił mołmun. ");
INSERT INTO nii_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Wumb ei men tok, na Gos kin ełmin ba ei wii mił ełmin. Nga en enim nge men tołmun kengip ek ei, wumb nge men tok kengip ek Gos nge ek keimi mon.’ ");
INSERT INTO nii_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Wumb en enim Gos kengip ek dinga ei si kindik kin, en enim wu ełmin oł minj ambił gii ninmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Pe Jiisas ek nipi wumb ngum, “En enim Gos nge kengip lo ek ei ambił gii ninarik si kindiłmin; ba en enim noman ełe nge ekii siłmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“Yi mił, wu Moses lo ek yi ninim, ‘Nim arnim manim ek ningił ei piikin, nga ekii sinjii. Nga wu endi eim arim mam kin ek kis nimba, wu ei kułmba,’ pa nirim. ");
INSERT INTO nii_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ba enim yi niłmin, ‘Wu endi eim ku ngumba wu, ei eim arim mam paki tumba; ba wu eim ek dinga nipi ngum ku ei, na Gos ngumbii, nip sinj,’ pa niłim. ");
INSERT INTO nii_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nga eim nge arim mam teł kin kapłi nga paki tumbii ni kapłi enermba mon. ");
INSERT INTO nii_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Yi mił enim ok wumb ełmin oł, ei enim enmin. Pe enim Gos ek ei ek wii mił si kindinmin ba, en enim oł kanim kanim pei yi mił enmin. Nga en enim nge kengip ek ei wumb eipi kin ngołmun ku.” ");
INSERT INTO nii_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nga Jiisas eim wumb wii topu kin, eim wumb ei kin ek nipi ngum, “Enim na ek ei kom sek piik erik mułngii! ");
INSERT INTO nii_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Epi wu ngenj torung mołum epi ei, nga wu noman tuk pupu wu, ei to peni ermba ei kapłi enanim mon. Ba wu noman tuk ełe kis mołum epi ei, tor opu wu ei minj kapłi er penj mundmba. ");
INSERT INTO nii_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wumb endi kom sepi piim kin, am dinga piyangłi.” ");
INSERT INTO nii_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiisas wumb ei si kindpi kin, ngii konu ełe pum. Pe ekii siłmin wumb Jiisas ek ekin ei pułe piimin ninjing. ");
INSERT INTO nii_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jiisas ek nipi orung kindim, “Enim ek ei nimbił erang pii poł tunanmin? Enim yi ku piinenjing min? Na ek ei enim piyei! Epi ngenj torung ełe sałim, epi ei nga wu ngenj ełe tuk pupu nim kin, wu ei noman tuk ełe penj mulermba mon! ");
INSERT INTO nii_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nimbił erang epi ei wu noman tuk ełe tuk punermba mon! Ba kuni ei kirim ełe tuk pupu, nga ekii se tor onum.” (Kunum ełe, Jiisas kuni pei ka pei konj mołum.) “Kuni ombu wumb nungii ei, wumb noman tuk ełe er penj mundnermba mon!” ");
INSERT INTO nii_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pe eim ek yi nim, “Epi endi wu noman tuk ełe mołpu tor onum, ei minj erpi wumb noman tuk ełe er penj mondnum. ");
INSERT INTO nii_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Yi mił, epi wumb noman tuk ełe mołum, epi ei tor opu, yi mił enim. ");
INSERT INTO nii_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Noman kis piik ni; oł kis erik; wu amb eipi oł kis erik; wumb eipi nge epi waning sik, wumb to konduk; wu amb eipi nge ngunduk; wumb nge epi kan bun bun kulk; oł kis kanim kanim erik; ek kend tok erik; wu amb oł kis ni piik noman ełe yi erik; wumb kin noman kis piik ngok erik; wumb kin ek kis ni ngok en enim nge embe ambił tonu kindik kin, nilkeng sik erik; en enim noman kun pinerang kin, Gos kin piinenjing mon. ");
INSERT INTO nii_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Epi ombu wumb noman tuk ełe pepi kin, nga tor wang kin, epi ei wumb pei oł penj tui ei enim.” ");
INSERT INTO nii_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jiisas konu ełe si kindpi, pupu Taiya konu owundu ełe orung pum. Pupu kin, ngii endi nirik pum. Ei eim wumb kin koi ermbii ni piim; ba eim kapłi enerim mon. ");
INSERT INTO nii_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ba amb endi ek yi piipi, Jiisas mołum ni piipi, amb ei eim ambiłam gui kis tuk mułum amb ni sikir opu, Jiisas mułum konu ełe ming gopsing pii pułum. ");
INSERT INTO nii_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pe amb ei wumb tiłap eipi kin eim Piniisiya konu ełe wumb kin Siriya konu ełe mułum. Mułum kin, amb ei Jiisas kin dinga kii sim, “Na ambilan gui kis mołum ei, nim kil ngo tor kindii!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nga Jiisas ek nipi yi nim, “Kumb se, sinim kangił kuni ok ngumun. Nim kangił nge kuni ei sikin owu kin ołup to ngonmun, ei mił enenjii mon.” ");
INSERT INTO nii_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ba amb ei ek nipi orung kindim, “Wu Owundu, nim ek ei keimi nin; ba owu peł mandi minj mołpu kin, kangił kuni orung mani pułum ei, owu nołum.” ");
INSERT INTO nii_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pe Jiisas ek ni orung kindim, “Yi mił nim ek yi mił nin, ei kapłi, nim nga si kind orung ngii konu punjii! Gui kis ei nim ambiłanim si kindpi pum,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Amb ni eim ngii konu ełe orung pum. Pupu kenim ni, ambiłam ei eim peł ełe pim. Peng kin, gui kis ei ambił ei si kindpi pum poru nim. ");
INSERT INTO nii_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Pa Jiisas nga Taiya konu owundu ełe si kindpi, pupu, konu Sairon konu owundu ełe orung pum. Am pupu Diikapolis konu ełe pum. Pupu, noł gop Galilii mułum konu ełe mani pum. ");
INSERT INTO nii_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pe wumb wu endi Jiisas mułum konu ełe tu wunjung. Tu wuk kin, wu ei ek tingnarpi kin, kom ngopu, wu ei sik tu wunjung. Wumb Jiisas kin kii dinga sik yi ninjing. “Nim wu ei ambiłan kin, kapłi eim ek tengmba,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jiisas wu ei kin, eł ełip mendpił wumb mond si kindkił, eł ełip mulnjunguł. Jiisas eim angił mong sipi, wu ei nge kom ełe embiłim. Nga eim angił mong ełe jipambił topu, wu gupu anmbił ełe kindim. ");
INSERT INTO nii_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jiisas kan tonu epin kind kanpi, eim gek dinga nim. Pe ei eim noman tuk ełe embin to piim. Piipi kin, ek yi nim, “Epipasa,” ek puł yi mił pałim. “Nim kom nin gupu nin ei pirek nengłi!” nim. ");
INSERT INTO nii_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pe wu ei kom pirek neng piim. Nga eim anmbił ak tang kin ek tengim. Tangpi kin, wu ni ek ka nipi mułum. ");
INSERT INTO nii_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jiisas ek dinga nipi wumb ngum, “Oł ei yi enim pa ni wumb ni tor kindik, ba eim ek dinga nga ninim, ninerngii mon! Enim ek nik wumb ngonerei mon!” nim. Ba wumb ei ek dinga nga nik tor kindnjing. ");
INSERT INTO nii_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nga wumb mund mong tum, ek ei yi ninjing, “Epi kanim kanim eim erpi epi ka wii erim. Neng kin, wumb kom ngum wumb ei ek piinjing. Nga wumb anmbił ak topu pim wumb, ei ek tengnjing,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Kunum ełe mandi erang kin, wumb pei Jiisas kin kułou nga tunjung. Tok kin, wumb ei kuni sinerim, wii mulnjung. Jiisas eim ekii siłmin wumb, “Wei!” a nim. Neng, wangin kin, Jiisas enim kin ek nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Na wumb ei kin kaimb sind. Nimbił erang wumb ei kunum tekliki na kin mulnjung. Molk kin, akip wumb ei kuni sinałim. ");
INSERT INTO nii_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Pe wumb ei kuni tum kin, na kindamb pungii; ba puk andłam ełe ningił sendang kin, bok tungii mił pałim. Wumb kopur konu turii ełe onjung ku.” ");
INSERT INTO nii_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pe Jiisas ekii siłmin wumb eim kin ek nik orung, kindnjing. “Wumb molałmin konu ełe sinim kuni ei jiłi sipin wumb ei kuni ngumun?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jiisas eim ekii siłmin wumb ei kin kii sim, “Enim bres nimberii sałim?” Nga ekii siłmin wumb yi ninjing, “Bres angił orung nga tał sałim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pe Jiisas ek dinga nipi, wumb pei ngum, “Enim mani mei ełe mułei!” nim. Neng, mołangin kin, Jiisas bres angił orung nga tał ei sipi, Gos kin prei erpi ngum. Pe eim bres ei sipi, eim ekii siłmin wumb ei kin ngum. Ngang kin, eim ekii siłmin wumb kuni sik, wumb pei mołangin kin, wumb kuni mok tok ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jiisas ekii siłmin wumb omu kembis kembis endeim endeim ni ku se mulnjung. Jiisas omu ei sipi, Gos kin prei erpi, ngopu, eim ekii siłmin wumb omu sik, wumb mulnjung ei mok tok ngunjung ku. ");
INSERT INTO nii_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nga wumb ei kuni nunjung, ei kapłi erim. Erang kin, kuni ei mend orung pei mułum, kuni ei sik gerenj kon angił orung nga tał tu wunjung. ");
INSERT INTO nii_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wumb mulnjung wumb ei 4,000 pei pei mulnjung. Pe wumb ei Jiisas, “Pei!” nim. ");
INSERT INTO nii_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Sikir, eim noł kanu ełe kin, eim ekii siłmin wumb kin, noł kanu ełe sik puk, Dalmanusa konu owundu ełe orung punjung. ");
INSERT INTO nii_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lo ek ekii siłmin wumb kombur ok, Jiisas kin ek ełe opu mił enjing. Wumb ei ok, Jiisas oł ermba mił kenmin ni piik enjing. Wumb ei ok, Jiisas kin kii sinjing, “Jep oł ei epin konu nge sin andan tan, sin kenmin,” pa ninjing. Wumb ei Jiisas ermba oł ei kenmin ni piik, kii sinjing. ");
INSERT INTO nii_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jiisas eim noman tuk gui ełe dinga gek nim. Nipi kin, eim ek yi nim, “Nimbił erang enim tiłap wumb ei akip jep oł ei eramb, kenmin ninmin? Na ek keimi nind, na enim wumb tiłap ei kin jep oł endi kapłi enermbii mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nga eim wumb si kindpi, nga noł kanu ełe tonu pupu, noł gop ełe orundung pum. ");
INSERT INTO nii_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jiisas nge ekii siłmin wumb orung tok, bres ni epi endi sik tu wunarik wii onjung. Ok kin, bres endeim mendpił mer kanu ełe tuk sim. ");
INSERT INTO nii_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nga Jiisas eim enim kin ek dinga nipi ngum, “Enim piik kun erik kan poł tok mułngii. Lo ek ekii siłmin wumb nge bres yiis kin, Eros nge bres yiis kin, epi bres tonu opu owundu ołum epi ei erim pii kun erngii. Ek pułe yi mił, wumb oł kis aninga ełmin ba ekii se oł kis ei tonu opu owundu ełim. ");
INSERT INTO nii_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pe Jiisas ekii siłmin wumb en enim kin ek nik piinjing, “Sinim bres endi sinałim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pe Jiisas ei piipi, ek yi nipi, eim ekii siłmin wumb ngum, “Nimbił erang en enim ek nik piik piik enmin ei, ‘Sinim bres sinałim,’ ninmin? Pe en enim noman pinałim, mił piik enanmin min? Nimbił erang enim noman tuk ełe dinga pałim? ");
INSERT INTO nii_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Enim ningił ełe pałim ei epi kinenjing min? Enim konu pałim ei enim ek piinanmin min? Enim ek ei wakin tok si kindnjing min kunum endi na bres angił orung sip, wumb 5,000 mulnjung ei na kuni ngamb nunjung? Enim kuni ngunjung kuni ei, gerenj kon nimberii orung tu wunjung?” “Engki endeim nga tał,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nga kunum endi na wumb 4,000 wumb pei kuni ngunj ei enim kuni mend orung enim gerenj kon nimberii tu wunjung?” Eim ekii siłmin wumb yi ninjing, “Gerenj kon angił orung nga tał tu wunjpun,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jiisas ek nipi ekii siłmin wumb ngum, “Enim oł ei pii poł nga tunanmin min?” ");
INSERT INTO nii_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nga Jiisas kin eim ekii siłmin wumb Beseira konu ełe tor punjung. Pe wumb kombur wu ningił tumbun wu endi, Jiisas mułum konu ełe tu wunjung. Wumb ei ek dinga nik, Jiisas wu ei angił embiłang ka ermba ninjing. ");
INSERT INTO nii_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jiisas wu ningił tumbun mułum wu ni angił embiłim. Jiisas wu ei sipi, konu owundu ełe tor sipim. Sipang kin, eim jipambił topu, ningił ełe kindpi, eim angił tonu ambiłim, pe wu ei kii sim, “Nim epi endi kan min?” ");
INSERT INTO nii_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pe wu ei tonu kindpi kenim. Kanpi kin, ba “Wumb ei ond mił angk mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jiisas nga wu ei ningił ełe embiłim. Pe wu ei dinga kenim ni, wu ningił ei ka mułum. Mułang kin, epi pei kanpi poru nim. ");
INSERT INTO nii_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jiisas wu ei kindang kin, eim nge ngii konu ełe ba nge pum. Jiisas ek nipi wu ei ngum, “Ninim wumb nge konu ełe punenjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jiisas ekii siłmin wumb kin tor pupu, Sesariya Pilipai konu ełe tuk pei punjung. Andłam ełe puk, Jiisas eim ekii siłmin wumb ek dinga nipi kii sim, “Wumb pei na embe nii niłmin?” ");
INSERT INTO nii_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pe eim ekii siłmin wumb yi ninjing, “Wumb kopur nim Jon wumb noł pendiłim wu, pa niłmin. Nga wumb kopur nim Elainja, ok ek keimi ni tor kindiłim wu,” pa ninjing. “Nga wumb kopur nim ek ni tor kindiłim wu eipi endi mołun,” pa ninmin ku. ");
INSERT INTO nii_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jiisas ekii siłmin wumb ei kin kii sim, “Pe enim na nii pa niłmin?” Piisa ek nipi orung kindim, “Nim Krais, Gos mei konu ełe mani kindang orun wu,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pe Jiisas ek dinga nipi yi mił nim, “Enim wumb eipi kin, na embe ni to kindnerngii, mon!” ");
INSERT INTO nii_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pe Jiisas nga kengip ek mon kindpi nipi, eim ekii siłmin wumb kin ngum. “Na wu kingam mani mei ełe op, epi embin se andip, ngenj kumbii simbii. Nga kułmał kałiłmin wumb owundu kin, men tok ełmin wu num tok, lo ek piik połmun wumb kin, wu kingam ei buł ngok, tok kundngii,” pa nim. “Kunum tekliki o pang kin, nga na angip konj tonu ombii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nga Jiisas ek puł nipi kun erpi wumb ngum. Pe Piisas Jiisas sipi tor pupu ek ngum, “Jiisas nim ek ei nin, ei kapłi enanim,” Piisa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ba Jiisas ak topu eim ekii siłmin wumb kenim. Kanpi kin, wu Piisa ek ngum, “Nim Seisen Piisa kin mołun, ei si kind pui!” a nim. “Nim Gos noman ei nim pii poł tunan mon! Nim wumb noman ei mendpił piikin mołun,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nga Jiisas wumb pei eim kin ekii siłmin wumb kin wii tang, eim mułum konu ełe onjung. Eim ek nipi wumb ngum, “Wumb endi na kin ombii ni pimba wumb, ei eim nge embe ei ambił mani kindmba. Wu ei eim na ond peri ambił si mengpi, na ond konu ełe omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","“Yi mił, wu endi yi mił enarpi, noman konj ambił gii nipi mułmba, wu ei eim noman konj ei sinermba mon. Ba wu endi na kin piipi kin, na kin men topu ermba wu, ei eim nge noman konj si kindim kin, eim nga noman konj sipi kunum kunum ka mułmba. ");
INSERT INTO nii_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yi mił, wu endi eim mei ełe, epi pei noman to piipi mułmba wu, ei eim noman konj ei sinenmba mon!” pa nim. Jiisas yi nim, “Mei ełe epi ei eim noman konj er simba mił nenj? Ei mon! ");
INSERT INTO nii_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yi mił, wu ei epi nipe ngopu, eim noman konj sipi orung simba? ");
INSERT INTO nii_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yi mił, pe kunum ełe wumb oł kis kanim kanim er mołmun wu endi, na ek ei piipi nipi wumb ngumba wu ei, singambił erang mułum kin, ekii se wu kingam omba wu, ei eim kin singambił piipi ngumba ku. Na Jiisas kin Gos nge tiłang ka wii ei kin nga Gos eim nge enjel ka wii pei omun kunum ei eni mił topu tiłang ka wii ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pe Jiisas ek nga nipi wumb ngum, “Na enim kin ek keimi nip ngond. Wumb kopur ya ełe angiłmin wumb ei, nga kulerngii mon! Ba wumb ei Gos wumb tep enim noman dinga ka wii ei tonu onum ni keningii.” ");
INSERT INTO nii_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nga kunum endi angił orung nga endeim o pang, Jiisas Piisa kin Jon kin Jeims wu kopur sipi komung owundu ełe eim ei si tonu sipim. En enim minj molk kin, Jiisas nge ngenj ei nga endi eipi mił tonu om. ");
INSERT INTO nii_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Wu kei ningił ełe kenjing ni, Jiisas wu endi eipi mił mułum. Nga eim nge alap ni epi ei tiłang erang kin, ei kuru ka wii sim. Sipi kin, mei wumb endi alap ni epi kapłi tiłang yi mił enermba mon! ");
INSERT INTO nii_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Pe wu tał Elainja kin Moses teł tor wangił kin, Jiisas kin ek tengnjing. ");
INSERT INTO nii_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Piisa eim Jiisas kanpi kin, ek yi nim, “Ek emb tołum wu! Sin ya ełe mołmun ei ka wii. Sin ngii tekliki tekmin. Tekmin ei, ngii endi nim nge, nga ngii endi Elainja nge, nga ngii endi Moses nge; sin ngii pei tekmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yi mił erang kin, wu kei mund mong enjing. Pe Piisa eim nipe ek endi nimba ei piinerim. ");
INSERT INTO nii_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pe kupu endi opu wu kei pandi tum. Gos ek tuk kupu muł ełe tor om, “Ei nam nge kingam; na eim kan ka wii piind. Enim eim ek piiyei!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pe sikir kan orung orung kind kenjing ni, wu endi eipi kinenjing mon. Ba Jiisas endeim mendpił minj mułum. ");
INSERT INTO nii_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nga komung ei si kindik kin, mani wangin kin, Jiisas ek dinga nipi wu kei ngum, “Epi ei enim kenjing oł ei, enim wumb endi kanik kin ei ninerngii mon! Pu molk kin, ekii se wu kingam mani mei ełe opu, kołpu kin nga angpi, nga tonu orung ba. ");
INSERT INTO nii_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yi mił, nga wu kei ek ei ambił gii nik mulnjung. Molk kin, en enim ek nik piik piik enjing, ek ei, “‘Kołpu, nga angpi tonu ba,’ pa ninim, ei ek nipe ek ninim?” ni piik piik enjing. ");
INSERT INTO nii_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nga wu kei Jiisas kii sinjing, “Nimbił erang men lo ek piik połmun wumb yi ninmin ei, Elainja ek ni tor kindiłim wu ei kumb se omba?” ");
INSERT INTO nii_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nga Jiisas ek nipi wu kei ngum, “Ei keimi, Elainja ok opu epi pei er ka ermba nge omba. Nimbił erang, ek endi eipi mer Gos mon ok pulk, ełe pałim, ei yi ninim? ‘Wu kingam eim ngenj kumbii sipi kułmba kunum ei, wumb eim kin buł ngunjung?’ ");
INSERT INTO nii_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ba na ek nip enim ngond, wu Elainja eim om poru nim. Neng kin, wumb en enim noman ełe eim kin oł kanim kanim enjing ei, Gos ek ok pulk, yi mił ninim.” ");
INSERT INTO nii_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jiisas kin wu kei ekii siłmin wumb mulnjung konu ełe orung onjung. Wangin kin, ekii siłmin wumb kin wumb pei kułou tok mulnjung. Nga lo ek piik niłmin wumb kopur ek dinga nik, Jiisas nge ekii siłmin wumb ei nge ek mił ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nga wumb molk kenjing ni Jiisas om. Wang kin, wumb ei sikir puku sinjing. Sinjing kin, wumb ei Jiisas mułum konu ełe sikir puk kin, Jiisas kanik kin yi ninjing, “Nim on?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Pe Jiisas eim ekii siłmin wumb kin kii sim, “Eim wumb ei kin enim nimbił oł erang enim gupu ełe ek mił enmin?” a nim. ");
INSERT INTO nii_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nga wu endi tuk wumb mulnjung konu mułum wu ei, Jiisas kin ek nipi orung kindim, “Ek emb tołun wu, nim na kangił gui kis endi tuk mułang kin, eim ek tingnałim. Na nim kin tu wund, ei nim er ka enjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","“Nga kunum kunum gui kis ei kangił ei ambiłpi, topu mani mei ełe kindiłim. Pe gupu noł gupu ełe tor ołum kin, nga gupu mong giikir nipi kin, eim ngenj dinga punum. Nga na nim ekii siłmin wumb kanip kin, kii sip ninj, ba wumb ei kapłi er ka enenjing mon,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jiisas ek nipi orung kindim, “Enim wumb pii gii pinałim wumb! Kunum nimberii na enim kin mułmbii? Kunum nimberii na enim ngenj kumbii kułmbii? Enim kangił ei na kin tu wei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nga wumb kangił ei Jiisas mułum konu ełe tu wunjung. Tu wunjung kunum ełe, gui kis ei Jiisas kanpi, kangił ei sikir to ak topu, kangił ei mani mei ełe kindang pepi, ak mak erim. Erim kin, kangił ni, gupu ełe jipambił mił epi kuru endi tor om. ");
INSERT INTO nii_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nga Jiisas kangił arim kii sim, “Kunum nimberii eim oł yi mił erim?” Arim ek nipi orung kindim, “Kumb ok kangił kembis kin er pim. ");
INSERT INTO nii_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nga gui kis ei kangił topu, dup ełe nin noł ełe nin kindmbii ni erang kin, topu kundmbii ni erim. Ba nim sin kin kaimb sikin kin, paki tokun kapłi er ka enjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jiisas ek nipi wu ei ngum, “Nim pii gii niłan kin, kapłi, nim epi ei pei siłan,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Sikir arim ek dinga nipi yi nim, “Na pii gii nind; ba pii gii ei kapłi enanim. Nim na paki tunjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pe Jiisas kenim ni, wumb pei sikir ok kułou tunjung. Pe Jiisas gui kis ei ek dinga ni ngopu, “Pui!” nim. Neng kin, “Nim gui kis gupu ek tingnen kin, nim kom pirek ninan; na ek nipi nim ngond ei, nim kangił si kind pui! Nim nga kangi ei kin nga tuk punenjii mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pe nga gui kis ei wii dinga topu, kangił ei kułii mił kołpu pepi pum. Pe wumb pei yi ninjing, “Kangił ni koltum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ba Jiisas kangił ni angił ełe embiłang kin nga konj engim. ");
INSERT INTO nii_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ekii se Jiisas ngii konu ełe tuk pupu, eim ekii siłmin wumb minj molk, eim kin kii sinjing, “Nimbił erang, sin gui kis ei si kindmin ei kapłi enanim?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pe Jiisas eim ekii siłmin wumb ek nipi ngum, “Gui kis ei prei erangin kin, mendpił kapłi ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jiisas kin eim nge ekii siłmin wumb konu ei si kindik pendik puk, Galilii konu ełe tuk punjung. Jiisas eim yi ni piim, “Wu endi na jiłi moł ni piinerngii mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nimbił erang Jiisas ekii siłmin wumb kanpi, eim kułmba nge kengip ek ei nge nipi ngum. Jiisas ek nga nipi ngum, “Wumb kombur na wu kingam mani mei ełe op tonu onj; ba wu ei sik wumb opu erii wumb kin ngok kin, nga wumb ei na to kundngii. To kunduk, nga kunum tekliki na angip tonu ombii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ba eim kin ekii siłmin wumb ek ei pii poł tunenjing. Tunarik kin, en enim singambił kulk, Jiisas nga kii sinenjing mon. ");
INSERT INTO nii_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pe Jiisas kin ekii siłmin wumb ok Kapaniyam konu ełe onjung. Ok, ngii endi nirik pangin kin, Jiisas eim ekii siłmin wumb ei kin kii sim. “Enim andłam ełe ok, nipe ek mił endi ninjing?” ");
INSERT INTO nii_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ba eim ekii siłmin wumb ek endi ninenjing. Nimbił erang andłam ełe ok yi ninjing, “Wumb nii sinim wu num mułmba,” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pe Jiisas mani kan mołpu kin, eim wu engki nga tał, ‘Wei!’ a nim. Nipi kin, ek nipi ngum, “Wu endi ei wu num mendpił mułmbii ni piim kin, eim embe to mani kindpi mułmba. Wu ei ekii se wumb pei paki topu ngopu mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Pe Jiisas kangił kembis endi sipi, tuk en enim mulnjung konu ełe engndim. Pe eim kangił ei angił ambiłpi kin, eim ek nipi wu kei ngum. ");
INSERT INTO nii_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Wu endi na embe ełe piipi kin, kangił kembis ei mił endi paki tumba wu ei, na paki tumba. Nga na paki tum kin, wu ei na mendpił paki tunanim mon. Wu ei na Arnan paki tonum ei, na kindang onj, ei paki tonum ku. ");
INSERT INTO nii_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon ek nipi ngum, “Ek emb tołun wu, sin kenjpin wu endi nim embe ełe nipi, gui kis si tor si kindim. Ba wu ei sinim kin tep to kongun ende endnerim. Wu ei yi erang sin, ‘Eim mon!’ pa ninjpin.” ");
INSERT INTO nii_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ba Jiisas ek nipi Jon ngum, “Enim ei yi ninerngii mon! Wu endi na embe ełe nipi, jep oł endi ermba wu ei, na kin ek kis sikir ninermba mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","“Wu endi sinim kin opu orung mulerim kin, wu ei sinim wu puł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","“Yi mił, na enim kin keimi nip ngond, wu nii endi enim kin kanpi noł ming endi enim kin paki topu ngumba wu ei, Krais nge kongun ei piipi kin, paki topu erim. Erim kin, wu ei eim nge kumep ngang simba ei am punermba mon.” ");
INSERT INTO nii_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Pe wumb kombur kangił pii gii to kis mundmun ni erngii wumb ei, num goltum ełe ku owundu endi kan kulk, ep noł ełe mani kindngii. Kindangin kin, na ek ni piik mulnjung kangił ei, ka mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Pe enim angił ełe oł kis enjing kin, enim pii gii ei kis mułmba. Kis mułang kin, enim angił ełe orung kopus si kindang kin, enim angił oł kis enerang, nim ka mułngii. Mon pim kin, enim angił ełe tał peng kin, enim dup konu kis ełe pungii dup ei, kumblałim mon, piram nopu minj pałiłim. ");
INSERT INTO nii_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Konu ełe, ‘Dup nopu nopu minj er mołang kin, ei kumblermba. Nga ka Pisapis mił epi ei wumb ngenj ełe nołum ei, poru ninermba; ba enj enj nopu pimba.’) ");
INSERT INTO nii_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pe nga enim simb ełe oł kis enjing kin, enim pii gii ei kis mułmba. Kis mułang kin, nga enim simb ełe orung kopus si kindang kin, enim simb oł kis enerang, nim ka mułngii. Mon pim kin, enim simb ełe tał peng kin, enim dup konu kis ełe pungii. Dup ei kumblermba, piram nopu minj pałiłim. ");
INSERT INTO nii_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Konu ełe, ‘Dup nopu nopu er mołang kin ei, kumblermba. Pe ka Pisapis mił epi ei wumb ngenj ełe numba ei, poru ninermba; ba enj enj nopu pimba.’) ");
INSERT INTO nii_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pe nga enim ningił ełe oł kis enjing kin, enim pii gii ei kis mułmba. Nga enim ningił ełe orung si kindang, enim ningił ełe oł kis enerang, enim ka mułngii. Mon pim kin, enim ningił tał peng kin, enim dup konu kis ełe pungii. Dup ei kumblermba mon, ba piram nopu minj pałiłim. ");
INSERT INTO nii_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Konu ełe, ‘Dup nopu nopu er mołang kin, ei kumblermba. Pe ka Pisapis mił epi ei wumb ngenj ełe numba, ei poru ninermba; ba enj enj nopu pimba.’ ");
INSERT INTO nii_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yi mił, pe dup ełe wumb pei nopu poru nimba, ei yi ep kusa mił. ");
INSERT INTO nii_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Epi kusa ei, epi ka wii mendpił. Ba ep kusa nge singin ei poru nim kin, kapłi ep kusa ei nimbił oł erpi kin nga singin simba? Ep kusa nge singin ei enim kin mułang kin, kapłi enim wumb eipi kin endeim endeim ni noman emin sek mułngii. ");
INSERT INTO nii_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jiisas eim konu ełe si kindpi, orung pupu, orung Juriya konu owundu ełe noł Joran pum. Pupu kin, wumb pei ok Jiisas mułum konu ełe nga kułou tunjung. Jiisas eim nge oł yi mił erpi, nga Gos ek ka kengip ek nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Men ek piik ekii siłmin wumb kopur ok, eim ermba oł ei kenmin ni piik kii sinjing. “Sinim nge men kengip ek yi pałim ni, wu endi eim amb sim ei kiłip topu si kindmba min mon?” ");
INSERT INTO nii_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jiisas ek nipi orung kindim, “Ok Moses enim nipe pipe mon ek dinga nipi ngum?” ");
INSERT INTO nii_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Pe wumb ek yi ninjing, “Moses eim kapłi enim mon endi polk kin, amb kiłip to si kindmin nik, mon endi polk kindik kin, kapłi amb ei si kindngii,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ba Jiisas ek nipi orung kindim, “Nimbił erang enim noman tuk ełe dinga peng kin, kumb ok Moses lo ek dinga endi pultum. Pułpu kin, enim noman ok wumb pałiłim mił enim yi peng kin Moses mon yi połpu ngurum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ba kumb ok, Gos oł pei eririm kunum ełe, Gos wu kin amb teł eririm ku. ");
INSERT INTO nii_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yi mił erang kin, nga wu ei arim mam tał si kindpi kin, eim ambim kin dambiltpi ende pupu endeim mił mułmba. ");
INSERT INTO nii_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Pe nga wu amb tał ngenj ende mił simba. Yi mił ku, wumb tał nga ngenj tał nga pinermba mon. Wumb tał ngenj endeim mił pimba. ");
INSERT INTO nii_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yi mił Gos wu amb tał sipi, ende kindpi mundmba ei, wu min amb eipi endi to kiłip tunermba mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nga ekii se ngii konu ełe puk, epi ełe Jiisas nge ekii siłmin wumb, eim kin kii sinjing. ");
INSERT INTO nii_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jiisas ek nipi orung kindim, “Wu endi ei ambim si kindpi, nga amb konj endi sim, wu ei eim ambim oł kis erpi kin, eim amb kin kiłip tonum. ");
INSERT INTO nii_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Nga amb ei eim wam si kindpi, eim wu eipi endi pupu kin, amb ei wam kin oł kis erpi, wam kin kiłip tonum. ");
INSERT INTO nii_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nga wumb kombur kangił kembis Jiisas mułum konu ełe tu wunjung. Tu wuk kin, wumb ei kangił kembis ei embiłmba ni piik, ba eim ekii siłmin wumb kangił tu wangin wumb ei ek ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ba Jiisas oł ei kanpi, eim noman kis piipi kin, ek nipi orung kindim. “Kangił kembis na ngangin kin enim ambił gii ninerngii! Ei yi mił, wumb endi pii gii pim kin, kangił mił yi Gos mołum konu ka ełe tuk pungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","“Na enim kin ek mendpił nip ngond. Wumb endi Gos sinim kin tep er mołum konu ełe, kangił ełe kembis mił yi sinerim kin, kapłi Gos mołum konu ełe tuk punerngii mon mendpił!” ");
INSERT INTO nii_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nga Jiisas eim kangił kembis embiłpi erim kin, kangił kembis ombu eim angił ambiłpi, kengip ek ka nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nga Jiisas angpi andłam ełe pupu kin, wu endi sikir opu, Jiisas mułum konu ełe opu, mani simb ełe gopsing pii połpu, ek nipi kii sim. “Nim ka wii ek mon wu, na nimbił oł erip, noman konj kunum kunum sip mułmbii?” ");
INSERT INTO nii_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jiisas ek nipi orung kindim, “Nimbił erang nim na wu ka nin? Gos endeim mendpił ka mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","“Nim lo ek pei piiłin: nim amb sikin, kiłip tokun, amb eipi sinenjii; nim wumb nge epi waning sinenjii; nim ek kend tokun wu endi ngunenjii mon! Nim ek kend tokun, wu epi eipi ni ngonenjii; nim arnim manim ek ningił ei piinjii! Piikin, arnim manim paki tunjii!” ");
INSERT INTO nii_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nga wu ei ek nipi Jiisas ngum, “Ek mon wu, na kumb ok kangił kembis kin moł ei, na lo ek pei piip kin, ekii sip poru nił. ");
INSERT INTO nii_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Pe Jiisas wu ei kanpi kin ka piipi ngopu, eim ek nipi wu ei ngum, “Nim epi endi kapłi enenim. Nim nge epi pei sikin, wumb ngokun ku sinjii! Sikin, nim ku nin epi sinerang mołmun wumb ei, ngunjii! Nim epin konu ełe epi ka mendpił sałim ei, sinjii! Nim na ond konu ełe, ekii se onjii. ");
INSERT INTO nii_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Yi mił, wu ei ek ei piipi kin, eim kumb dinga erim. Pe eim noman embin topu kin eim orung pum. Nimbił erang, wu ei epi pei sałiłim nge wu.” ");
INSERT INTO nii_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nga Jiisas kanpi orung orung kind kanpi kin, eim nge ekii siłmin wumb kin ek yi nim, “Pe wumb epi pei mani mei ełe sałiłim wumb ei, kongun dinga wii erik Gos sinim tep er mołum konu ełe tuk pungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pe Jiisas ekii siłmin wumb Jiisas ek ei piik kin puku sinjing. Ba Jiisas ek nga nipi orung kindpi yi nim, “Na nge kingnan noł, wu endi Gos sinim tep er mołum konu tuk ba; ba ei kongun dinga erpi ba. ");
INSERT INTO nii_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pe kung kamil endi alap mui gal tundii ełe andłam ełe tuk ba; ba eim kongun dinga erpi ba. Yi mił ku, wu endi epi pei sałim wu ei, kongun dinga wii mendpił erpi, Gos sinim tep er mołum konu ełe tuk ba.” ");
INSERT INTO nii_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jiisas ekii siłmin wumb ek ei piik, puku sinjing. Sik kin, enim Jiisas kin ek nik kii sinjing, “Yi mił, wu nii kapłi erang, noman konj kunum kunum sipi mułmba?” ");
INSERT INTO nii_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Pe Jiisas eim ekii siłmin wumb kin kan kanpi, ek nipi ngum, “Ei wumb en enim kapłi enermba mon, ba Gos eim kapłi ermba. Gos eim mendpił epi kanim kanim kapłi pei ermba.” ");
INSERT INTO nii_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ba Piisa ek nga nipi Jiisas ngum, “Kani! Sin epi pei si kindpin, nim kin ekii se onjpun.” ");
INSERT INTO nii_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Pe Jiisas ek nim, “Na enim kin ek mendpił nip ngond, wumb endi na kin Gos nge ek ka ei piik kin, ngii konu ełe si kindik; engnjing noł si kindik; einjing noł si kindik; menjing noł si kindik; ernjing noł si kindik; kingenjing noł si kindik; aka pin kuni si kindik; na nge kongun erngii onmun kunum ełe, Gos epi 100 pei ngopu orung kindmba. Ya mani mei ełe mułngii kunum ełe, Gos eim enim kin ngii ni, angim ni, aim ni, mam ni, kangił ni, aka pin kuni ei, Gos enim ombu kin pei orung kindpi ngumba. Ngang kin, wumb kombur wumb ei kin oł embin tui erik ngungii ku. Nga kunum ekii se, noman konj sik, konj kunum kunum mułngii. ");
INSERT INTO nii_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ba wumb kombur wu owundu mołmun kumb se mołmun wumb ei, ekii se nga wumb wii mił mułngii. Ba wumb kombur wumb wii ekii sik mołmun wumb ei, ekii se kunum ełe, kumb se wumb num mułngii. ");
INSERT INTO nii_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Wumb Jerusalem konu ełe pungii pendik, andłam ełe punjung. Pe Jiisas andłam ełe andpi sikir ok pupu, Jiisas ekii siłmin wumb puku sinjing. Nga wumb ekii se onjung wumb tungu enjing. Jiisas eim ekii siłmin wumb engki nga tał sipi, orung sim kin, ek pułe eim kin tonu omba ei, nipi ngum. ");
INSERT INTO nii_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jiisas ek yi nim, “Enim piyei! Sinim Jerusalem konu ełe tonu bin. Pe wumb wu kingam sipangin kin, ek emb tołmun wumb kin, Gos kułmał kałiłmin wumb owundu kin ngungii. Ngok kin, eim wumb omba ni piik kin, kan ngok tok kundngii. Pe wu kingam ei sik, wumb eipi endi ngangin kin, tok kundngii nik, wumb eipi ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nga eim wumb sik, ek kulsingii, jipambił tok, kepii tok kundngii. Tok kundangin kin, pepi kunum tekliki poru neng kin, angpi nga konj tonu omba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nga Sependii nge kingam tał, Jeims, Jon teł okuł, Jiisas kin yi ninjngił. “Ek mon wu, sił nim kin epi endi kii simbił nge onmbuł. Nim epi ei sił kin enjii!” pa ninjngił. ");
INSERT INTO nii_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pe Jiisas ek nipi, wu tał ngum, “Na ełip kin nimbił oł ermbii?” ");
INSERT INTO nii_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Pe wu tał Jiisas kin ek nikił orung kindinjngił, “Nim ekii se king peł ełe, tiłang owundu ei ninim noman dinga sikin onjii kunum ei, kapłi sił piinmbił ei nim sił wu tał endi sikin, angił tundung mundan kin, nga endi angił taring mundan mułmbuł,” pa ninjngił. ");
INSERT INTO nii_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ba Jiisas ek nipi wu tał ngum, “Na kin ek ei kii sinmbił ei ełip ek ei pii poł tunanmbił. Ełip kapłi noł na nond noł ming ei, kapłi nunguł min? Nga ełip kapłi na noł peł ełe ełip kapłi pingił min?” ");
INSERT INTO nii_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Pe wu tał eim kin ek nikił, “Sił kapłi ermbił.” Jiisas ek nipi wu tał ngum, “Keimi, ming ei na pe noł nond, ełip ming ei kapłi noł nunguł ku. Pe na noł peł ełe, ełip kapłi noł pingił ku. ");
INSERT INTO nii_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pe wumb nii endi eim na angił tundung min angił taring ełe mułmba ei, na nge epi endi mon. Ba Gos ei eim peł ei eim ngumbii ni, er ka er mundum wumb ei ngumba.” ");
INSERT INTO nii_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nga Jiisas nge ekii siłmin wumb engki orung ek ei piik, nga Jon kin Jeims tał kin noman kis piinjing. ");
INSERT INTO nii_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ba Jiisas eim ekii siłmin wumb eim kin wii topu, “Wei!” pa nim. Eim ek nipi wu kei ngum, “Enim piinmin, wumb embe mołum wumb num ei, tiłap eipi ełe pałim ei, en enim noman dinga to mani kindngii ei pałim. Pe en enim wumb owundu ombu tep dinga wii ełmin. ");
INSERT INTO nii_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ba oł ei enim kin tuk pinermba mon! Wu endi eim enim kin wu owundu mułmbii ni ermba ei, enim kin kongun wii paki tumba wu mułmba. ");
INSERT INTO nii_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pe wu endi enim kin wu owundu endeim mułmbii ni ermba, wu ei eim enim wumb pei kin kongun wii paki tumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","“Nimbił erang wu kingam eim yi ku, eim opu wumb eim kin kongun paki tungii nipi onerim, mon! Eim opu wumb paki tumba nge om. Opu kin, ond peri ełe kołpu, eim noman konj ka ngopu, wumb pei nga sipi orung simba nge om.” ");
INSERT INTO nii_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pe Jeriko konu ełe onjung. Jeriko konu ełe si kindpi pupu kin, Jiisas ekii siłmin wumb kin, wumb pei eim kin punjung. Puk kin, Barsimeiyas, Tiimeiyis nge kingam ei, ningił tumbun mołułum wu ei, andłam wer ełe mołpu, wumb ku ni epi ei kenim nipi siłim. ");
INSERT INTO nii_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nga Jiisas Nasares konu ełe wu ei orum eim piipi kin, eim wii dinga topu, “Nim Jiisas, nim Deipis nge kingam. Nim na kin kaimb si ngo!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nga wumb pei wu ei ek ngok yi ninjing, “Nim ek tingnerii!” Ba eim nga wii dinga topu, “Nim Deipis nge kingam, nim na kin kaimb si ngo!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pe Jiisas eim opu yi nim, “Enim wii tangin kin, wangłi!” nim. Pe wumb wu ningił tumbun mułum wu, ei wii tunjung, “Nim noman dinga pimba. Nim angkin po! Jiisas eim nim wii tonum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Kapłi, pe eim konduk si kindpi kin, eim sikir engim. Angpi kin, Jiisas mułum konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Pe Jiisas wu ei kin ek nipi ngum, “Na nim kin nimbił oł ermbii?” Wu ningił tumbun mułum wu ei, ek nipi ngum, “Ek mon wu, na ningił er ka eran, kenmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jiisas ek nipi orung kindim, “Nim po! Nim pii gii je erang kin, nim ningił ełe ka enim.” Pe wu ningił tumbun mułum wu ei, sikir erang ka mułang kenim. Kanpi kin, wu ei Jiisas andłam pum konu ełe, ekii se pum. ");
INSERT INTO nii_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pe Jerusalem konu ełe mandi ok kin, Bespeis kin Besanii konu ełe mandi komung Olip ełe tor onjung. Pe Jiisas eim nge ekii siłmin wu tał kindang punjnguł. ");
INSERT INTO nii_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jiisas eim ek nipi wu tał ngum, “Ełip pukuł, konu ełe keningił konu ełe mandi mołum. Pe sikir keningił ni kung dongkii wumb mulenjung kung endi kan kuł pendnjing ei, na kin tu wunguł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“Pe wu endi ełip kanpi, ‘Ełip ei nimbił erang enmbił?’” a nim kin, kapłi ełip yi ningił, ‘Sił wu owundu tu weł!’ a neng kin onmbuł. Ekii se eim kung dongkii sikir sipi ya orung kindmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kapłi wu tał pukuł, kenjngił ni kung dongkii endi kan kuł pendnjing. Kung ngii ondu ełe pendnjing pim ei, kan si kindkił nga tu wunjnguł. ");
INSERT INTO nii_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Nga wu kombur mandi angk, ek nik ngunjung. “Ełip nimbił oł erang kung dongkii ei kindangił punum?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nga wu tał ek nikił wumb ngunjnguł, “Jiisas ek nim mił ninjngił.” Nengił kin, kung dongkii wumb, “Kung kapłi seł!” ninjing. ");
INSERT INTO nii_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pe ełe ełip kung dongkii wał ya Jiisas mołum konu ełe tu wunjnguł. Tu wukuł kin, konduk tukuł ei peł ełe singił. Pe Jiisas kung dongkii ełe tonu pupu mułum. ");
INSERT INTO nii_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pe wumb pei konduk gulk, andłam ełe mundnjung. Pe nga wumb kombur ond onguł tok tu wuk, andłam ełe mundnjung ku. ");
INSERT INTO nii_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nga wu amb pei Jiisas pum konu ełe kumb se punjung. Nga wumb kombur ekii se punjung ku. Nga wumb pei puk kin wii dinga tunjung, “Wu owundu onum,” pa ninjing. “Gos wu owundu ei kin eim noman ka ngumba. Eim Gos nge embe owundu ełe onum! ");
INSERT INTO nii_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Gos sinim noman ka ngopu, eim kingam wu owundu Krais kindang opu, sinim konu orung orung tep ermba nge onum. Kumb ok, kupam Deipis sinim tep ełim mił, yi ermba nge onum. Gos embe ambił tonu kindinmin.” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pe Jiisas Jerusalem konu ełe om. Opu kin, men ngii owundu ełe nirik pupu kin konu ełe kan andpi, pupu kin epi kanim kanim kanpi poru nim. Ba konu eni mani pupu poru nim. Konu pou neng Jiisas eim ekii siłmin wumb engki nga tał sipi Besanii konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nga kunum endi, Besanii konu ełe si kindik, nga Jiisas kuni tum. ");
INSERT INTO nii_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nga eim kenim ni ond pik endi turii mił engim. Pe Jiisas kenim ni, ond onguł pei mułum ni kenim. Kanpi pupu kin, “Ond mong, kurup simbii,” ni piim. Ond engim konu ełe, eim ond mong endi eim kinerim mon! Onguł mendpił mułum. Nimbił erang, ond pik mong tunałim kunum ei mułum. ");
INSERT INTO nii_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pe Jiisas ond ei nipi ngum, “Nim ond mong nga tunenjii mon!” pa yi nim. Pe Jiisas ekii siłmin wumb ek ei piinjing. ");
INSERT INTO nii_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wumb Jerusalem konu ełe punjung. Pe Jiisas men ngii konu ełe andaring mandi pum. Pupu, kenim ni wumb men ngii konu ełe andaring mandi wumb, kei nin ku onguł sik mong top ełmin, epi pei wumb tu wuk ya epi top erik, er mulnjung wumb ei Jiisas pupu, to kindang kin, konu eipi eipi tor si kindang punjung. ");
INSERT INTO nii_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pe Jiisas ek dinga nipi wumb ngum, “Epi top ei Gos ngii mandi tu wuk enerngii mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jiisas kengip ek nipi ngum, “Gos ek yi mił wumb kombur ok pulk yi ninim, na ngii ei kin wumb yi mił ningii, ‘Na ngii ei prei nge konu ełe er mułmba,’ yi ningii; ba enim wumb ek ei piinarik sik, wumb koi erik, epi waning sik erik nge ngii mił enmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nga kułmał kałiłmin wumb owundu kin, ek emb połmun wumb ombu kin, Jiisas enim epi ei piik, en enim andłam endi kuruk Jiisas tumun ni piinjing. Wumb ombu Jiisas kin mund mong enjing. Nimbił erang wumb pei Jiisas nge kengip ek piik, puku sik, tungu enjing. ");
INSERT INTO nii_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nga konu pou neng, Jiisas ekii siłmin wumb kin Jerusalem konu ełe si kindik punjung. ");
INSERT INTO nii_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pe kupiiring okrii, Jiisas kin eim ekii siłmin wumb andłam ełe puk kenjing ni, ond pik kułii erim. Ond onguł kin dumbuł kin pei kułii er poru nim. ");
INSERT INTO nii_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Nga Piisa eim oł endi erang piipi kin, eim yi nim, “Ek emb tołun wu, keniyo! Ond Pik ei nim ek ngon, ond ei kułum.” ");
INSERT INTO nii_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","23","Jiisas ek nipi orung kindpi yi nim, “Enim Gos kin pii gii nik molk kin, oł ei enim kapłi erngii,” pa nim. “Na ek keimi nga nip enim ngond. Pe wu endi kapłi komung ei ek neng kin, kapłi pupu mani ep noł ełe ba. Pe wu endi eim noman tał pinermba mon, ba eim pii gii ełe mendpił pimba. Pe eim ek ei kapłi peni ełe omba. Nga epi ełe tonu omba ei, wu endi ek nim mił mendpił pimba. ");
INSERT INTO nii_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yi mił erang, ełe nge na enim kin ek nind, kunum ełe enim prei erik, epi endi simin ni kii sinjing kin, kapłi enim pii gii nik epi ei singii. Sik kin, prei erik, kii sik, epi ei enim singii. ");
INSERT INTO nii_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nga kunum ełe enim angk prei erangin kin, wu endi enim kin oł kis erpi nim kin, enim wu ei oł kis ei kapłi si kindngii. Yi mił, enim Ernjing Gos ei epin konu ełe mołum, eim enim noman kis kapłi kil ngopu si kindmba ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","(“Ba enim wu endi oł kis ei si kindnenjing kin, kapłi Erinjpin Gos enim noman oł kis ei kil ngopu si kindnermba mon ku,” pa nim.) ");
INSERT INTO nii_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wumb Jerusalem konu ełe nga orung onjung. Wangin kin, Jiisas men ngii konu ełe nirik andpi mułum kin, wumb kułmał kałiłmin wumb owundu kin, mon ek tołmun wumb kin, men ngii kongun ełmin wumb ombu ei Jiisas mułum konu ełe onjung. ");
INSERT INTO nii_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wumb ok Jiisas kin ek nik ngunjung, “Nim nipe noman dinga peng oł ombu en? Pe wumb nii nim noman dinga ngang, kongun ombu mił en?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jiisas ek nipi ngum, “Na enim ek endi kii sip ngumbii. Enim na ek nik ngunjung kin, ek ei nga na enim nip orung kindmbii. Ei na kongun noman dinga peng enj mił ei nimbii ku. ");
INSERT INTO nii_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ya noł wu Jon wumb noł pendiłim oł ei; Gos nge oł min mei ełe wumb nge oł?” Jiisas ek nipi, “Ek ei nik orung kindei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pe wumb en enim ek yi ni piik piik enjing. “Pe sinim epin konu ełe epi ninjpin kin, kapłi Jiisas yi nimba, ‘Enim nimbił oł erang enim Jon pii gii ninanmin?’ a nimba. ");
INSERT INTO nii_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pe nga sinim wumb ek epi ninjpin kin, ek ei kapłi enermba mon.” Nimbił erang en enim wumb pei mułangin kin, mund mong enjing. Wumb pei Jon eim Gos ek ni tor kindiłim wu ni piinjing. ");
INSERT INTO nii_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pe wumb Jiisas kin ek nik ngunjung, “Sin piinanmin.” Pe Jiisas ek yi nim, “Na yi ku enim kanip nind, na noman dinga peng yi kongun enj pa nip, ninermbii mon,” pa nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jiisas ek ekin topu wumb ngopu eim ek yi nim, “Wu endi eim kan ond mong pin endi tełim. Tałpi, kung gui torung er pok erim. Erang kin, ming owundu endi yi mił er sepi kin, ond mong tangpi tuk kindmba nge erim. Erpi kin, tep ngii endi tuk ełe takpi sim ku. Ond mong pin ei sipi wumb kongun, ‘Erngii!’ nipi, wumb kin kindim. Kindpi kin, eim pupu konu turii endi pum. ");
INSERT INTO nii_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Tengingii kunum mandi erang kin, eim kongun wu endi kindang pupu, ond mong wumb kongun er mulnjung konu ełe pum. Eim yi ni piim, ‘Ond mong pin kuni kombur numbii. Nop sipip, ku simbii,’ ni piim. ");
INSERT INTO nii_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pe wumb wu ni ambił gii nik, kepii tunjung. Tok kin, nga wii kindangin orung pum. ");
INSERT INTO nii_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pe nga, eim kongun wu endi nga kindang om. Wu ei yi ku tok kin, peng to tokun tunjung. Nga wu ei kin oł kis enjing. ");
INSERT INTO nii_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pe nga eim kongun wu endi nga kindim. Kongun wumb erik molk, wu ei to kundnjung. Pe nga kongun wumb pei kindang onjung. Pe enim wumb kopur tok, nga enim wumb kopur tok kundnjung ku. ");
INSERT INTO nii_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pe eim kingam endeim mendpił mułum. Mołpu kin, eim kingam ei eim noman piim. Piipi kin, ekii se mendpił, eim nge kingam ei kindang, pupu wumb ond mong pin kongun er mulnjung konu ełe pum. Pupu kin, ek yi nim, ‘Nam nge kangi ei ek nimba ei kom singii,’ pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ba ond mong pin kongun ełmin wumb en enim ek nik piik, piik enjing. ‘Kingam eim arim nge epi eim pei simba,’ ni piinjing. ‘Sinim sikir to kondpun kin, ond mong epi ei sin sinim simin!’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Yi nik kin, tok konduk sipik, ond mong pin torung ełe kindnjing.” ");
INSERT INTO nii_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pe Jiisas ek nipi kii sipi wumb ngum, “Pe ond mong pin ei arim opu kin nimbił oł endi ermba? Eim opu kin eim ond mong pin kongun er mulnjung wumb ei to kundmba. Pe nga ond mong pin ei sipi, wumb eipi endi ngang kin, kongun er mułngii. ");
INSERT INTO nii_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Enim ek mon endi mer poł pendnjing ei gernenjing min? Gos ek yi mił ninim, ‘Pe ku ei ngii takiłmin wumb si kindnjing kin ku, ei ku dinga ka wii mendpił, ngii ekin ełe engim. ");
INSERT INTO nii_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gos owundu eim mendpił oł ei erang kin tonu onum, sin ei kan ka wii kaninmin.’” ");
INSERT INTO nii_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jiisas ek ei wumb piik nik ełmin wumb owundu ei pupun, Jiisas ambił gii nimin ni piinjing; ba wumb mund mong enjing. Wumb piinjing ni Jiisas ek neng kin, en enim konu ei si kindik punjung. ");
INSERT INTO nii_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Lo ek piik ekii siłmin wumb kombur kin, Eros wumb kopur kin Jiisas mułum konu ełe punjung. Puk kin, wumb ei en enim ek endi nik Jiisas simin ni piik punjung. ");
INSERT INTO nii_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pe wumb ei ok Jiisas kin ek dinga nik, “Ek emb tołun wu, sin piinmin nim ek keimi nikin nikin en wu. Pe nim wu endeim noman ngonan. Nim wu endi noman peng ek ninmin mił ninan. Nga wu embe pinałim mił ninan mon? Gos ek keimi mendpił minj nikin, wu amb pei ngon. Nim piin ei sinim ermin mił nenj? Ei kapłi sinim wu num Siisa yi mił Rom tep ełmin wu owundu mił, ku takis ngumun min mon? Sinim kapłi ngumun min sinim ngunermin?” ");
INSERT INTO nii_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jiisas ek kend tok ełmin wumb ei piim. Piipi kin, Jiisas ek nipi ngum, “Nimbił oł erang enim na kin ek ak mak enmin? Pe kom ku end tu wuk, na ngangin kin, ei kenmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wumb kom ku sik tu wunjung. Tu wangin kin, Jiisas wumb ei kin kii sim, “Ei min men mił ku ei nii nge?” Pe wumb ek nik orung kindnjing, “Ei Siisa nge.” ");
INSERT INTO nii_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Pe Jiisas ek nipi orung kindim, “Epi Siisa nge epi ei Siisa ngungii! Gos nge epi ei Gos eim ngungii!” Pe wumb ek ei piik pii pol tunarik kin, piik kun enenjing. ");
INSERT INTO nii_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Wumb kolk nga konj punałmin ni piiłmin wumb kopur Jiisas mułum konu ełe onjung. Wumb tiłap ei men ek eipi mił yi niłmin, ‘Wumb kolk nga konj punałmin.’ Wumb ei, Jiisas kin kii sinjing. ");
INSERT INTO nii_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ek emb tołun wu, Moses lo ek yi mił połpu sinim ngum. ‘Pe wu endi kułum kin, eim kangił endi mulerim ba, eim ambim ei mołum. Mołum kin, amb ei eim angim sipi kin, kangił endi mengpi ngumba. ");
INSERT INTO nii_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pe wu angim angim angił orung nga tał mulnjung. Molk kin, wu kumna ei amb sim wu ni kułum ba, kangił endi mengnerim. ");
INSERT INTO nii_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pe angim ekii amb ei sipi kin, nga wu ei kułum, ba kangił endi mulerim ku. Pe nga angim tuk ei, amb ei eim sim, ba nga eim kułum ku. ");
INSERT INTO nii_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Yi mił wu angim angił orung nga tał angim ei, amb endeim ei ku sik punjung; ba kangił endi mengnenjing mon. Angim angim ni pei kulnjung. Kolk kin, ekii se mendpił amb ei kułum ku. ");
INSERT INTO nii_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pe kunum ekii se kulnjung wumb nga angk tonu ongii kunum ei, amb ei wu nii simba? Amb ei wam nii, nim piin min? Wu angim angił orung nga tał amb endeim sinjing,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jiisas ek nipi ngum, “Gos ok pultum ek ei, enim pii poł tunarik mołmun. Pe enim Gos epi dinga ermba, ei enim piinanmin. Pe enim ek ninmin ei, kun pinałim mon. ");
INSERT INTO nii_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wumb kulnjung wumb angk tonu ongii kunum ełe, wu amb sinerngii mon, ba Gos enjel epin konu ełe mołmun mił ei yi ku mułngii. ");
INSERT INTO nii_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ba ek ei wumb kułii wumb nga angk tonu ongii; enim Moses nge mon mer pultum pałim ei kenjing min? Dup endi ond kembis ełe dup num ek poł ei Gos nipi wu Moses kin ngum, ‘Na wu Eiparam nge Gos, wu Aisak nge Gos, wu Jeikop nge Gos,’ pa yi nim. ");
INSERT INTO nii_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Gos wumb kułii wumb nge Gos mon! Gos wumb konj mołmun nge Gos mołum. Gos wumb eim kin pii gii ninjing wumb ei, Gos noman konj nga, en enim ngang konj mułngii. Enim ek ei kun mendpił pinałim mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nga men kengip ek tołum wu endi opu moł piipi kin, Jiisas wumb kin ek mił enjing ni orung kindpi ka erim. Pe wu ei Jiisas kii sim, “Lo nipe lo kumna mendpił ka wii pałim?” ");
INSERT INTO nii_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jiisas ek nipi orung kindim, “Lo ek kumna yi mił pałim. ‘Enim Esrel wumb pei enim piingii! Sinim Erinjpin Gos Owundu ei sinim Gos ei endeim mendpił, sinim nge Owundu mołum. ");
INSERT INTO nii_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nim Gos kin noman ka pei mendpił ngokun, “Nanim Gos,” nikin mulnjii. Ninim noman tuk ełe poru Gos kin ngokun; nga nim noman pei Gos kin ngokun, nim noman dinga pei Gos kin ngokun er mulnjii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nga lo endi ei yi mił: ‘Nim wumb eipi noman ka ngunjii ei, ni ninim noman ka ngon mił yi ngunjii.’ Nga lo eipi endi lo tał ei kamb mani kindnanim mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pe ek emb tołun wu ek nipi Jiisas ngum, “Ek mon wu! Nim ek ka nin keimi mendpił, Gos endeim mendpił mołum. Eim Owundu mołum. Gos eipi endi molałum, mon! ");
INSERT INTO nii_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Sinim eim kin noman ka pei ngumun; sinim noman tuk ełe pei ngumun; sinim noman dinga eim kin pei ngumun; sinim wumb mołmun noman ka ngumun. Pe sinim lo tał ei piipin kin sin sinim lo tał ei ekii se punjpun kin, kapłi oł ei erpi wumb kułmał kałmin kanim kanim pei to mani kindim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nga Jiisas piim ni, wu ei ek ka nipi orung kindim. Jiisas wu ei kin ek nipi ngum, “Nim Gos sinim kin tep er mołum konu ełe mandi mołun,” pa nim. Yi mił, nga wumb endi Jiisas kin nga kii sik mund mong erik mołmun. ");
INSERT INTO nii_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pe nga Jiisas men ngii mołpu, kengip ek nipi wumb ngum, “Nimbił erang kengip ek tołmun wumb ei Krais ei opu, wumb paki tumbii ni, omba wu ei Deipis nge kingam mendpił mołum?” pa ninmin. ");
INSERT INTO nii_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","“Gos Gui Ka neng, Deipis kin ek nim, ‘Owundu nipi, na owundu ninim mił, nim na angił tundung orung mulnjii. Molkun kin, ekii se nim opu orung wumb na sipi, nim simb ełe mandring kindamb kin, nim opu orung wumb to mani kindnjii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Deipis ei eim ‘Owundu’ ninim; nimbił erang Owundu Deipis nge kingam mendpił mołum ninim?” Pe wumb tiłap owundu molk kin, eim ek ei piik kin ka piinjing. ");
INSERT INTO nii_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Pe Jiisas kengip ek ni ngopu yi nim, “Enim lo ek piiłmin wumb kan kun erik mułngii. En enim alap olt tałpin endmin ni piiłmin. Puk kin, en enim wumb kanik kin, ‘Mułeiyo,’ nik kin wumb ei kułou tołmun konu ełe mołmun. ");
INSERT INTO nii_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Nga en enim konduk olt kindik kin men ngii kumb ełe mułngii ei ka piiłmin. Nga en enim kuni owundu nołmun ei, en enim puk peł kumb ełe mułmun ni ka piiłmin ku. ");
INSERT INTO nii_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","‘Wumb ombu amb ngii konu bin ni piiłmin.’ Amb wengin mołmun konu ełe pułmun. Puk kin, amb epi ngii konu epi mołum ei, pei sik poru niłmin. Nga en enim ek kend tok prei olt ełmin. Erik kin, ekii se kunum, Gos wu ombu epi embin tui endi wu kei kin ngumba.” ");
INSERT INTO nii_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nga Jiisas men ngii konu ełe ku sim konu ełe wumb ku tu wuk ming ełe kindiłmin konu ełe mandi mułum. Pe wumb ku sim wumb, ku pei ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pe nga amb endi wam kultum, amb ku kurpu mułum ni, ku kundii kembis ei endeim mił sipi kindim. ");
INSERT INTO nii_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nga Jiisas nge ekii siłmin wumb eim wii topu kin, “Wei!” nim. Nga eim enim kin ek nipi ngum, “Na ek keimi nipi enim ngond, amb ku kurpu eim wam kułum amb ei, ku owundu tuk kindnim. Kindim, amb ei wumb ku pei men ngii ełe ku tołmun ming ełe tu wunjung wumb ombu, amb ei to mani kindim. ");
INSERT INTO nii_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pe wumb pei en enim ku pei sałiłim, ba mer ming ełe pei kindnałmin. Ba amb ei eim ku pei pinerim, ba eim ku pei tuk kindim. Kindpi kin, pe eim nga kuni sipi nopu ermba, ku sinałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pe Jiisas men ngii si kindpi, tor pupu kin, Jiisas ekii siłim wu endi ek nipi, Jiisas ngum, “Ek mon wu! Kani! Ku owundu ka wii nin ngii ka wii ka wii mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nga Jiisas ek nipi orung kindpi yi mił nim, “Nim ngii owundu ombu kan min? Pe ku endi tonu ku ełe pałim ku ei, ekii se pei to mani kindngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jiisas tonu komung Olip ełe mułpu, men ngii owundu orung engim ni kenim. Pe Piisa, Jeims, Jon, Endru wu kei mendpił molk kin, eim kin kii sinjing. ");
INSERT INTO nii_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nim ek nikin sin ngon, ei kunum nenj oł embin tui ei tonu omba? Nipe oł endi kumb se tonu omba sin piimin? Epi ombu pe mandi tonu omba min?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pe Jiisas ek nipi ekii siłmin wumb ngum, “Enim kanik kun er mułngii! Mon pim kin, wu endi enim ek kend topu ngopu tor simba. ");
INSERT INTO nii_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wumb pei ok, ‘Na embe Krais,’ ningii. Nik kin, ek yi ningii, ‘Na wu ei mendpił ond,’ pa ningii. Nik kin, wumb pei ek kend tok ngok tor singii. ");
INSERT INTO nii_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nga ekii se, enim wumb opu erngii ei piik kin, wumb opu erngii ek poł omba ei piik kin, en enim tungu enerngii! Ei epi tonu ongii, ba poru nimba kunum ei, poru ninanim. ");
INSERT INTO nii_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yi mił, wumb tiłap endi puk, wumb tiłap endi kin opu erngii. Wu king tiłap endi puk, wu king endi kin opu erngii. Nga konu orung kopur konu kopu tumba. Kopu tang kin, wumb kuni simba. Epi ei amb endi kangił mengmba erang ngenj kumbii sinmin, yi mił pepi ba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ba en enim mandił kan kun erik mułngii! En enim wu num ek ei kos piimba. Pe enim men ngii konu tu wuk enim kepii tungii; enim kin nin tep ełim wu owundu mułngii konu ełe, tu wungii enim. Na ek ka nik wumb ei ngok kin, na kongun yi mił erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pe wumb tiłap eipi eipi wumb pei Gos ek ka nengin kin, ełe ok endi piyangin kin, ekii se muł mei poru nimba kunum ei, oł embin tui tonu omba nim. ");
INSERT INTO nii_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pe wumb kombur enim sik tu wuk, kos ełe tonu tu wunjung kin, enim mund mong kulerngii. Kularik kin, sinim ek nipe ek nimin noman yi to piinerngii mon! Kunum ełe, Gos enim kin ek ei pei nipi enim ngumba ei, enim nik tor kindngii. Nimbił erang, ek ei enim mendpił ni tor kindnerngii mon. Ba Gos Gui Ka enim kin ek ei nipi ngumba. ");
INSERT INTO nii_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wumb enim engnjing sik, kos erik nga to kundngii. Ernjing, kingenjing kin opu orung erik to kundngii. Pe kingenjing, arim mam ni opu orung erik, to kundngii. ");
INSERT INTO nii_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Wumb pei enim kin noman kis piik ngungii; na ek enim piik mołmun, oł ei erngii. Ba wu endi na kin pii gii dinga peng mułum kin, kunum ełe poru nimba kunum ei, Gos eim sipi orung simba.” ");
INSERT INTO nii_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ba enim epi ei keningii, konu er kis ermba, epi kis ei konu ka mołpu konu engmba. Wu endi ek ei gerim kin, ka piyangłi! Kunum ełe Jura wumb mulnjung, tungu puk, tonu komung ełe sikir tonu pungii. ");
INSERT INTO nii_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Pe wu endi ngii tonu ełe mołpu kin, nga sikir mani pupu eim epi ngii nirik mołum, epi endi sinermba mon. ");
INSERT INTO nii_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nga wu endi aka pin mołpu kin, kan ak topu sikir pupu, konduk endi sinermba mon ku. ");
INSERT INTO nii_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kaimb mendpił singii amb kangił mundii mondunmun ei, nin amb kangił am ngok kunum ei, wumb ei kaimb sik ngungii. ");
INSERT INTO nii_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pe enim prei erangin kin, konu jii nimba kunum ei, oł ei nge tonu onermba mon. ");
INSERT INTO nii_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Kunum ełe, oł embin tui owundu kumb se tonu omba. Kumb ok, Gos epi pei eririm kunum, pei o pum; nga pe yi ku oł embin tui ei nge ok tonu oneririm. Ekii se oł embin tui, ei yi ku tonu onenmba. ");
INSERT INTO nii_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nga Gos Owundu eim kunum ełe aninga kopur wak tułang kin, wu amb pei kunum ełe poru niłangin. Ba eim nge ni mundum wumb ni piipi kin, kunum ełe aninga kopur wak topu kindang mołmun. ");
INSERT INTO nii_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Nga kunum ełe wu endi mołpu yi nimba, ‘Kenei! Krais ya ełe mołum. Krais wuł ełe mołum,’ yi nimba. Wu ei enim kin ek yi nimba, enim pii gii ninerngii mon. ");
INSERT INTO nii_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pe Krais ek mił ek kend tok ningii. Nga ek kend tok ni tor kindiłmin wumb ok kin, jep oł kanim kanim nin, oł kanim kanim erngii ku. Keimi kapłi erim kin, Gos mundum nipi wumb ek kend tok singii nge, erngii. ");
INSERT INTO nii_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ba enim kan kun erik mułngii! Na ek pei enim kin ok nip poru ninj oł ei nge, endi ekii se tonu om kin, enim pii poł tungii.” ");
INSERT INTO nii_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ba kunum ełe oł embin tui pupu poru neng kin, pe eni emii pimba; nga oi tiłang enermba mon ku. ");
INSERT INTO nii_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nga muł ełe, kanjip pei mani ongii. Nga kupu muł dinga epi mołum epi ei ołup ermba. ");
INSERT INTO nii_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nga kunum ełe, na wu kingam ekii se kupu muł kin, ełe mani ombii ni enim keningii! Kanik kin, na noman dinga wii kin nga tiłang ka wii kin mani ombii. ");
INSERT INTO nii_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nga kunum ełe, Gos nge eim enjel pei kindang, ongii. Ok kin, eim nge wu amb pei kułou topu mundum wumb eim konu ełe orung orung pei sipi orung simba. Sipi kin, mei konu ekin orung orung pei, sin epin konu ełe orung orung pei sipi orung simba.” ");
INSERT INTO nii_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Enim ond pik ełe ek ei piingii. Kunum endi ond angił ełe noł mołpu, onguł konj tonu opu, nim kin enim piingii ei, konu eni ba kunum tonu onum ni piingii. ");
INSERT INTO nii_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ei mił, ekii se na ek nind mił epi yi tonu omba keningii. Enim piingii, eim mandi opu kin, ngii ondu ełe mołum ni piingii. ");
INSERT INTO nii_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Na ek keimi nip enim ngond! Wu amb pei kulerngii kunum ełe, na ek nind mił epi yi tonu omba. ");
INSERT INTO nii_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kupu muł kin mei teł poru nimba; ba na ek ei poru ninermba mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ba wu endi kunum ełe kin, eni ełe ni piinanim mon. Gos enjel ei epin konu ełe mołmun, ei pii poł tunanim. Nga Gos kingam yi ku, pii poł tunanim. Ba Arim Gos mendpił pii poł tołum. ");
INSERT INTO nii_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Enim kan kun erik kui erik mułngii! Enim piinanmin kunum nenj oł ei tonu omba. ");
INSERT INTO nii_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ei yi mił, wu endi eim ngii konu ełe si kindpi kin, konu eipi orung pum. Pupu kin, eim kongun wumb eim nge epi ombu tep er mułngii, ni kongun wu endeim endeim ni ngum. Ngopu kin, ngii ondu ełe tep er mułmba wu, ei eim tep ka er mułmba. ");
INSERT INTO nii_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yi mił, enim tep ka erik mułngii! Enim piinanmin ngii arim kunum nenj orung omba. Emii pang omba min, tinga omba min, kupiiring okrii kei kultu wii tołum kunum ełe omba min, ei enim pii poł tunanmin mon. ");
INSERT INTO nii_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mon pim kin, eim sikir opu, kenmba ni enim or pek mułngii. ");
INSERT INTO nii_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nga ek ei enim nip ngond, ei na wumb pei nip ngunj, ei enim tep ka wii erik kin, kui erik mułngii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pe kunum tał opu pang, ekii se ‘Pasopa Kuni Owundu’ kunum endi sim. Nga kułmał kałiłmin wumb owundu kin kengip ek niłmin wumb yi ninjing, “Sinim nimbił oł erpin, Jiisas kin ek kend nipin kin, Jiisas ambił gii nipin, to kundmun?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yi mił wumb ek yi ninjing, “Sinim oł ei kunum owundu sałim kunum ei, enermin mon. Mon pim kin, wumb opu tonu sik erngii.” ");
INSERT INTO nii_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nga Jiisas eim Besanii konu ełe pupu, Saimon ok kinj nang pirim, ngii konu ełe pum. Pupu mołpu kin, kuni nołmun peł ełe mułang kin amb endi om. Opu kin, amb ei ming ka wii endi sipi tu wum. Tu wupu kin, ming ei mur ka wii, ku owundu pułum ming ei, topu gał tum. Topu kin, kopung ka wii sipi, Jiisas peng ełe kindim. ");
INSERT INTO nii_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ba wumb kombur mulnjung wumb ei noman kis piinjing. Wumb en enim ek ni piik piik enjing, “Nimbił erang kopung muru ka wii ei wii bein to kindnim?” ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","“Pe sinim wumb top erei nipin ngumun, ei ku 300 mił simin. Sipin kin, wumb kurpu mołmun wumb ei ngumun.” Nik kin, amb ei kin ek ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ba Jiisas yi nim, “Enim amb kanik, wiik tei!” a nim. “Enim nimbił erang noman embin tui eim kin ngonmun? Ei na kin oł ka enim. ");
INSERT INTO nii_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Kunum kunum wumb kurpu enim kin mołmun. Kunum kunum enim wumb kurpu kin paki tumun ni piinjing kin, kapłi paki tei! Ba na enim kin kunum kunum mulermbii mon. Muleramb kin, enim na kin paki tungii mił nenj?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","“Amb ei epi kapłi ermba mił erim. Amb eim kopung muru ka wii sipi, na ngenj ełe kełim ei na kułmbii oł erim. ");
INSERT INTO nii_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nga na enim kin ek keimi nind! Ei konu orung orung pei wumb Gos ek ka nik ngungii. Epi nipe amb eim erim mił nik ngangin kin, wumb pei piingii ku!” ");
INSERT INTO nii_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pe kunum ełe, Jiisas ekii siłmin wumb engki nga tał mulnjung konu ełe, wu endi embe Juras Eskeriyas eim pupu, kułmał kałiłmin wumb mulnjung konu ełe pum. Pupu kin, eim Jiisas sipi, opu erii wumb ngumba nge pum. ");
INSERT INTO nii_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nga en enim ek ei piik Juras Eskeriyas ek nim mił piik, ka piinjing. “Pe eim kom ku ngumun,” pa ninjing. Pe Juras, “Jiisas sipi, kułmał kałiłmin wumb ngumbii,” ni yi piim. ");
INSERT INTO nii_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nga kunum kumna kunum bres yiis punałim kunum ei, tonu om. Kunum ełe, kung siipsiip wał to kondułmun ku. Kunum ełe Jiisas ekii siłmin wumb Jiisas kin yi ninjing, “Sin nim kuni Pasopa jiłi er ka er semin nunjii?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nga Jiisas wu tał kindang punguł nge punjnguł. Pe eim ek yi nipi wu tał ngum, “Ełip konu owundu ełe wu endi noł ming owundu ełe noł kułpu tumba konu ełe, ełip kurkuł ba konu ełe, ełip ekii se punguł. ");
INSERT INTO nii_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nga ekii se pukuł, eim ngii endi nirik pum kin, ełip ngii arim kin ek yi mił ningił, ‘Ek mon wu yi nim, ngii palting jiłi seng, na ekii siłmin wumb kin kuni Pasopa numbii?’ ");
INSERT INTO nii_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nga eim kapłi andan topu, konu owundu tondrung palting ełe tuk peł simba ełe, er kun er kindang, simba ełe sinim kuni er ka er singił.” ");
INSERT INTO nii_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pe Jiisas ekii siłmin wu tał punjnguł konu ełe owundu sim. Seng kin, epi kanim kanim Jiisas ek nim mił kenjngił. Pe wu tał kuni Pasopa er ka enjngił. ");
INSERT INTO nii_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nga konu pou neng, Jiisas eim ekii siłmin wumb sipi tu wum. ");
INSERT INTO nii_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nga peł ełe kuni nok molk kin, Jiisas eim yi nim, ‘Na ek keimi nip enim ngond, enim mołmun wu ei endi, na sipi opu orung wumb ngumba wu ei, na kin kuni ende nonum.’ ");
INSERT INTO nii_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pe Jiisas ekii siłmin wumb en enim, noman embin tum. Tang kin, pe wu endi nii nik eim kii sinjing, “Na min?” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Pe Jiisas ek yi nipi ngum, “Enim wu angił orung orung nga tał endi ełe mołum. Wu ei nam kin ming ełe bres ende kindinjpił. ");
INSERT INTO nii_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Yi mił, na wu kingam oł embin tui tonu omba, ei Gos ek ełe ok polk pendik mił ninim. Wu kingam ei topu tonu kindim wu, eim kaimb mendpił sim. Kapłi, wu ei mam wu ei mengnerim!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nga en enim kuni noł molk kin, Jiisas eim bres endi sipi, eim prei erpi Gos ngum. Ngopu kin, bres engin topu, eim ekii siłmin wumb kin ngum. Ngopu kin, ek yi nim, “Enim Sei! Ei na nge ngenj mił.” ");
INSERT INTO nii_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Pe eim ming wain endi sipi kin, prei erpi, Gos ngum. Ngopu kin sipi, eim ekii siłmin wumb kin ngum. Pe wumb pei noł nunjung. ");
INSERT INTO nii_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nga Jiisas ek nipi wumb ngum, “Ei miyem mił ei, Gos ei kumb ok eim wumb ek mendpił nirim ek ei pułe, akip tonu onum. Ei yi mił, na miyem ei bein tamb kin, wu amb pei paki tumba. Pułe yi mił, na kuls kin, mei wumb pei paki top ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","“Na ek keimi nip enim ngond, na nga noł wain ei nga nonarip pup kin, nanim noł wain konj endi Gos mołum konu ełe nga numbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nga wumb golang nik, puk tonu komung Olip ełe tonu punjung. ");
INSERT INTO nii_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nga Jiisas ek nipi wumb ngum, “Enim pii gii ei pei dinga mulerang kin, enim tungu pungii. Gos ek ok połmun ek ei yi mił ninim, ‘Kung siipsiip tep mołum wu ei to kundangin kin, kung siipsiip konu ełe eipi eipi pungii.’ ");
INSERT INTO nii_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ba nam nga angip tonu bii, pe na pup ok, Galilii konu ełe bii. Enim na kin ekii sik ongii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pe Piisa ek yi nim, “Kapłi, wumb pii gii pei dinga mulerim kin, na pii gii ei dinga mułmba. Wumb kombur tungu puk kin, ba na tungu punermbii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pe Jiisas ek nipi Piisa ngum, “Na ek keimi nip nim ngond, akip emii pimba kunum ełe, kei kultu wii tunermba kunum tał ninim kin, nim na embe kunum tekliki kii sengin, ni tor kindnenjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ba Piisa ek dinga nim, “Na nim kin ende kułmbii, ba na nim embe nip koi enermbii mon mendpił!” pa nim. Pe Jiisas ekii siłmin wumb pei yi minj ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pe puk konu endi ełe tor punjung, konu ei embe Gesemanii. Nga Jiisas ekii siłmin wumb ek nipi ngum. “Enim ya ełe mułngii! Nam prei ermbii!” ");
INSERT INTO nii_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pe eim Piisa kin Jeims kin Jon sipi, eim kin punjung. Pe eim noman tuk ełe embin tang piipi eim kis mendpił piim. ");
INSERT INTO nii_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Pe eim ek nipi wu kei ngum, “Nam noman tuk ełe embin tonum. Nam kułmbii ni piind,” pa nipi wu kei ngum. “Enim ya ełe molk kin, tep ka erik mułngii!” ");
INSERT INTO nii_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Pe eim aninga kopur pui mił erim. Pupu kin, mei ełe mani pupu kin prei erim. Na kułmbii ni piim kin, ngenj kumbii owundu ei na kin si kindmba. ");
INSERT INTO nii_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Jiisas yi nim, “O Arnan, nim epi pei kapłi enjii, ni piind. Nim na ming ei oł embin pałim, na oł embin tui ei si kindnjii, ba nim na noman ełe ekii se enenjii mon! Ba ninim noman ełe yi enjii.” ");
INSERT INTO nii_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Pe eim pupu, kenim ni eim ekii siłmin wumb or pinjing. Nga Jiisas eim ek nipi Piisa ngum, “Saimon, nim or pałin min? Nim kunum endeim kapłi na kin tep mulenjii min? ");
INSERT INTO nii_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Enim tep ka kun erik molk kin, prei erngii! Mon pim kin, epi endi enim ermba epi ei kan simba. Keimi, noman tuk gui ei dinga piinim, ba ngenj ei dinga pinałim.” ");
INSERT INTO nii_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pe Jiisas nga pupu kin prei erim. Pe prei ei ok erim mił, eim nga prei ei nge nga erim ku. ");
INSERT INTO nii_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Pe Jiisas nga opu, ekii siłmin wumb or pinjing konu opu, kenim ni or pek mulnjung. Eim ekii siłmin wumb en enim ningił embin tum. Tang kin, pe en enim ek nipe ek nimin ni piinenjing. ");
INSERT INTO nii_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nga Jiisas nga kunum tekliki pupu kin, nga orung om. Opu kin, ek nipi ekii siłmin wumb ngum, “Enim or pek kor mołmun min? Ei kapłi, pe kunum ei na wu kingam mani mei ełe sik, opu orung wumb noman kis piik wumb ngonmun. ");
INSERT INTO nii_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enim angangin kin sinim pamin! Kinei! Wu na nipi kindmba wu, ya mandi onum.” ");
INSERT INTO nii_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pe Jiisas ek nipi mułang kin, Juras sikir opu, wu ei Jiisas ekii siłmin wu angił orung orung nga tał, ei nge wu endi eim om. Pe wumb tiłap owundu eim kin onjung. Onjung kin, wumb ei tui nin kepii ambił sik onjung. Wu owundu kułmał kałiłmin wumb kin, wumb mon tołmun wumb kin, men tok kongun wumb kindangin onjung. ");
INSERT INTO nii_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pe wu endi Jiisas sipi, opu orung wumb wu ei oł erpi, nipi wumb kin ngum, “Pe na wu endi kin gupu top nop ninj, wu ei Jiisas. Enim ambił gii ningii! Enim tep ka molk sik sipngii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pe Juras opu Jiisas mułum konu ełe pupu kin, ek yi nim, “Ek emb tołun wu!” Pe eim Jiisas gupu topu num. ");
INSERT INTO nii_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pe wumb pei Jiisas ambił gii ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ba en enim enjing konu ełe wu endi mandi angpi mułum wu ei, tui kepera sipi tor sipi, kułmał kałiłim kongun wu endi topu, eim kom kopispi mani kindim. ");
INSERT INTO nii_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pe Jiisas ek nipi wumb ngum, “Enim na singii wangin kin, pe enim tui ambilk enmin ei, waning wu endi mułum mił ambił gii ningii enmin min? ");
INSERT INTO nii_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kunum kunum na enim kin men ngii ełe ende mołpun, na enim ek emb top top enj, ba enim na ambił gii ninenjing,” pa nim. “Ba Gos ek ka ok pulk ełe, ek nim mił ei mendpił keimi tonu om.” ");
INSERT INTO nii_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Pe Jiisas eim ekii siłmin wumb tungu puk, konu eipi eipi puk kin, en enim Jiisas buł ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Pe kangi wu gał ei Jiisas pum konu ełe ekii se pum; ba eim alap kuru endi ngenj ełe tełim. Pe wumb eim ambił gii nimin ni enjing; ba eim alap kuru ei si kindpi, eim ngenj wii si kindpi tungu pum. ");
INSERT INTO nii_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pe wumb Jiisas sipi, kułmał kałiłmin wu mułum konu ełe sipnjing. Pe wumb kułmał kałiłmin wumb kin mon tołmun wumb kin men tok kongun wumb pei ok kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pe Piisa Jiisas pum konu ełe ekii se pum. Ba pupu kin mandi punerim mon; eim turii mił pupu mułum. Eim pupu kin, wu kułmał kałiłmin wu ei kung gui ełe tuk pum. Pupu kin, pe tep ełmin wumb molk kin, eim dup piipi kin konu ełe pełe erpi mułum. ");
INSERT INTO nii_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pe wumb kułmał kałiłmin wumb kin Jura wumb owundu pei ok, wumb kopur wii tangin ok kin, ‘Jiisas oł nimbił oł erim ei ni piimin,’ ninjing. Ek pułe nik kanik, Jiisas to kundmun ni piinjing; ba en enim oł endi kan sinenjing mon. ");
INSERT INTO nii_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pe wumb pei ek kend tok, ‘Jiisas oł yi erim,’ nik ninjing. Ba en enim ek ei dinga punerang kin, en enim ek ende punerim mon. ");
INSERT INTO nii_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Pe wumb kopur angk, ek kend tok, Jiisas kin ngok ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sin piinjpin Jiisas yi mił nim, ‘Na nam men ngii wumb angił kin teknjing, ei nam erip kis mundmbii. Nga kunum tekliki mendpił na ngii endi tekmbii, ba wumb angił ełe teknałmin mon! Enim wumb ngii ei nge kunum kapłi teknerngii!’ yi niłim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ba ek ei ninjing ei, opu ende punerim mon. ");
INSERT INTO nii_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nga wu kułmał kałiłim wu ei wumb tuk ełe angpi, Jiisas kii dinga sim. “Nim ek endi nikin, orung kindnenjii min? Ek nipe ek wumb nim ngenj ełe ek ambiltmin?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ba Jiisas ek endi nipi orung kindnerim. Pe wu kułmał kałiłim wu ek nga nipi ngum, “Nim Gos kindim wu Krais, Gos kingam mendpił min?” ");
INSERT INTO nii_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Pe Jiisas ek nim, “Ei na mendpił. Nga enim keningii ni na wu kingam mani mei ełe op, Gos tonu mołum konu ełe angił tundung orung dinga wii ei pang mułmbii. Pe na tonu kupu muł epin konu ełe mołup, ombii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pe kułmał kałiłim wu ei eim kis piipi kin, eim konduk piltan topu yi nim, “Sinim wumb kopur wii tamin ok ełim oł ei, nga ninerngii mon!” ");
INSERT INTO nii_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Eim Gos kin ek nipi kis mondpu, Gos embe to mani kindim ei, enim piik poru ninjing. Pe enim er piinmin mił nenj?” Wumb pei Jiisas tungii ek yi mił ninjing, “Enim oł kis endi erim, eim kułangłi,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pe wu kopur tumun! Ke nik, jipambił tok enjing. Pe enim alap endi sik, ningił kum tunjung. Tok kin, Jiisas enim angił kin tok, yi ninjing, “Nim pe ek keimi mendpił niłin wu, nii kepii tonum?” Pe tep ełmin wumb sipik, eim angił kin tunjung ku. ");
INSERT INTO nii_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piisa mer mandring mułum, kung gui tukrung ełe mułum. Pe wu kułmał kałiłim wu nge kongun amb endi om. ");
INSERT INTO nii_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","68","Pe eim kenim ni Piisa dup piipi mułum. Pe amb ei opu, Piisa dinga kanpi ek nim, “Nim yi ku Jiisas kin Nasares konu ełe andkin mułun,” pa nim, “Na mon! Na piinand! Na nim ek nin ek pułe ei na piinand.” Pe eim kung gui ondu mandi ełe anda pum. Pang kin, kei kultu endi wii tum. ");
INSERT INTO nii_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pe kongun amb Piisa kenim ni, nga amb ei ek nga wumb mandi mulnjung wumb nipi ngum, “Wu ya mołum wu ei, wumb tiłap ende,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ba eim nga ek dinga nim, “Mon!” Nga ekii se nga wumb Piisa kin ende mulnjung, wumb ek ninjing, “Keimi, nim wu ei kin tiłap ende, nim Galilii konu wu mendpił,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pe Piisa ek dinga wii nim, “Na ek keimi mendpił nind! Na enim ninmin wu ei, na piinand.” ");
INSERT INTO nii_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pe sikir kei kultu kunum tał wii tum. Pe Piisa piim ni Jiisas yi nim mił piim, “Kei kultu kunum tał wii tunerang kin, pe nim ek kunum tekliki ninjii, ‘Nim na kin piinand.’” Pe Piisa eim ke dinga wii nim. ");
INSERT INTO nii_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nga kumb kupiiring ok, wumb kułmał kałiłmin wumb kin men kengip ek tołmun wumb kin men tok kongun wumb kin Jura wumb owundu pei ek endi ninjing. Pe wumb Jiisas kan tok, Pailos Rom tep ełim wu owundu mułum konu ełe, sipnjing. ");
INSERT INTO nii_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pe Pailos eim Jiisas kii sim, “Nim Jura wumb nge king mołun min?” Jiisas ek nipi ngum, “Nim ninim ek yi mił.” ");
INSERT INTO nii_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pe wumb kułmał kałiłmin wumb eim kin ek pei nik ngunjung. ");
INSERT INTO nii_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pe Pailos nga Jiisas kii sim, “Nim ek nikin orung kindnjii min? Nim kani! Wumb nim kin ek pei ninmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ba Jiisas ek nga nipi orung kindnerim. Yi erang kin, Pailos kom sepi piim. ");
INSERT INTO nii_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pe kung ngii pei Pasopa kunum ei, kuni nołmun kunum ei, Pailos eim kan ngii pałiłmin wumb endeim ni nipi kindiłim. Wumb en enim wu endi nik wii tangin kin, kapłi Pailos eim wu ei mendpił en enim kin kindiłim. ");
INSERT INTO nii_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Pe kunum ełe wu endi kan ngii ełe pim wu ei embe Barapas. Wu ei eim tep ełmin wumb kin opu erim kin, pe opu ełmin wumb kan ngii ełe pendik kindnjing. Wumb tiłap ei opu erpi wu kopur to kundnjung. ");
INSERT INTO nii_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pe wumb pei ok Pailos mułum konu ełe, kanik ninjing. “Ok nim ełin oł, ei ni pe yi enjii!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pe Pailos ek nipi orung kindim, “Enim Jura wumb na enim king ei en enim ngumbii min?” ");
INSERT INTO nii_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pe eim yi piim, “Kułmał kałiłmin wumb Jiisas kin noman kis sek, kos ełe tu wumun,” ni piim. ");
INSERT INTO nii_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ba kułmał kałiłmin wumb owundu wumb paki tok nengin wumb yi ninjing, “Nim Barapas kindan wumb mołmun konu wangłi!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pe Pailos ek nga nipi wumb ngum, “Pe enim Jura wumb nge king enim niłmin wu ei kin, nipe oł endi ermbii?” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Wumb wii nga tu wunjung, “Eim ond peri ełe nil tei!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pe Pailos ek nipi wumb ngum, “Nimbił erang? Nipe oł kis endi eim erim?” Ba wumb ek nik nga wii tunjung, “Eim ond peri ełe nil to!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yi mił, pe Pailos wumb ek taki taki nipi, ka piingii ni piipi kin wumb ngum. Pe eim yi mił erim ei Barapas sipi, wumb kin kindang pum. Jiisas sipi, opu orung wumb mulnjung konu ełe ngum. Ngang kin, opu wumb ond peri ełe eim nil tumun, ni kepii tok sipnjing. ");
INSERT INTO nii_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pe opu wumb Jiisas sik, orung sipik tep ełmin owundu wu nge ngii konu ełe tuk sipnjing. Sipik kin, opu wumb kopur wii tangin kin, pei onjung. ");
INSERT INTO nii_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nga opu wumb Jiisas konduk kundii endi kindnjing. Nga opu wumb peng kon endi kan gał mułum endi sik enjing, peng kon ei Jiisas peng ełe pendnjing. ");
INSERT INTO nii_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Pe Jiisas tungii pendik yi ninjing, “O Jura wumb ei nge King,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nga opu wumb goł mił epi endi sik, Jiisas peng ełe kepii tunjung. Pe wumb eim jipambił tunjung. Pe en enim eim kin men tok kend tok mani molk kin, ka wii piinjing. ");
INSERT INTO nii_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Piik kin, pe Jiisas kin ek ngok poru nik, Jiisas konduk kundii si kindik, nga Jiisas eim konduk nga eim kin kindnjing. Kindik kin, pe Jiisas sipik, ond peri ełe tungii nge sipnjing. ");
INSERT INTO nii_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nga wu endi Saimon, Sairiin konu ełe orung opu, kangi wu Aleksandir kin Rupus tał nge arim, opu konu owundu ełe tuk bii, ni om. Opu kin, pe opu wumb ek dinga yi ninjing, “Nim Jiisas ond peri ko wunjii!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nga wumb Jiisas sipik, konu endi tor sipnjing konu ei embe Golkasa. Sinim embe ei ak topun yi ninmin, “Konu wumb peng embił konu.” ");
INSERT INTO nii_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nga wumb kopur Jiisas wain kin ond mong kindnjing epi ei Jiisas ngungii nge tu wunjung; ba Jiisas ei epi nunerim. ");
INSERT INTO nii_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pe opu wumb Jiisas ond peri ełe nil tunjung. Pe eim konduk ni epi ei opu wumb en enim mok tok sinjing. Pe opu ond wumb ku kembis mił epi ei kinjmał erik kin konduk ei singin nik enjing. Epi ombu ni simba nge nik enjing. ");
INSERT INTO nii_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Pe kunum eni angił orung nga kapił kapłi kupiiring, eim ond peri ełe sik tonu kindnjing. ");
INSERT INTO nii_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pe tonu embe pulnjung, eim kos enjing mił embe yi mił pulnjung, “Jura Wumb King,” ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Nga Jiisas pim konu ełe mandi wu tał ond peri ełe pinjngił. Wu tał opu erkił kin epi waning sikił ełmbił. Wu endi Jiisas angił tundung tonu kindik, nil tunjung. Nga endi sik, Jiisas angił taring tonu kindik nil tunjung. ");
INSERT INTO nii_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","(Pe Gos ek ok pulk mił keimi tor onum. Ek ei yi mił ninim, “Enim wumb kis kin mułum ni kenjing.”) ");
INSERT INTO nii_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Pe wumb ok puk erik, eim kin ek kis nik ngunjung. Wumb peng ak mak erik yi ninjing, “Nim wu men ngii top kis erpi, nga kunum tekliki nga tekmbii,” nin wu. ");
INSERT INTO nii_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","“Pe ninim paki to! Tokun, nim ond peri ełe si kindkin, mani wa!” ");
INSERT INTO nii_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Yi mił ku, wumb kułmał kałiłmin wumb kin, wumb mon tołmun wumb kin, ek kis nik Jiisas ngunjung ku. Pe wumb en enim ek nik piinjing, “Eim wumb eipi kin paki tum, ba ei eim kapłi paki tunermba! ");
INSERT INTO nii_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kapłi, Gos kindim wu Krais ei Esrel wumb king, eim ond peri ełe si kindkin, mani wangłi! Wang kin, sin kanpin, pii gii nimin wu ei wumb paki tumbii ni orum ni kenmin,” pa ninjing. Wu tał Jiisas kin ouni nil tunjung, wu tał yi ku ek nikił Jiisas ngunjnguł. ");
INSERT INTO nii_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Nga tinga konu beli pałim kunum ei, mei konu orung orung pei emii pim. Emii pepi pang, konu pou neng konu eni tekliki erim. ");
INSERT INTO nii_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pe pou neng konu eni tekliki erang kin, Jiisas wii dinga tum. “Eloi, Eloi, Lama Sambaksanii.” Sinim ek ei ak topun yi nimin, “Na Gos! Na Gos! Nim na nimbił erang na si kindin?” ");
INSERT INTO nii_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Pe wumb kopur mandi mulnjung wumb ek ei piinjing. Piik ek yi ninjing, “Piyei! Wu Elainja ni wii tonum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pe wu endi sikir pupu, ep noł epi endi sipi noł wain ełe tuk kindim, epi kumbii ełim epi ei sipi, Jiisas ngum. Pe wu ei yi nim, “Sinim tep er mołpun kinamin, pe Elainja opu, Jiisas ond peri ełe sipi mani simba min?” ");
INSERT INTO nii_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nga Jiisas eim dinga wii topu kin, eim kułum. ");
INSERT INTO nii_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Pe alap owundu endi men ngii ełe pim, ei tonu piltan topu, mer mani tor pupu topu, orung orung pum. ");
INSERT INTO nii_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pe opu ełmin wumb tep ełim wu, Jiisas pim konu mandi opu angpi kenim ni Jiisas kułmba mił yi erim. Pe eim ek nim, “Keimi mendpił, wu ei Gos kingam,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nga amb kopur mulnjung ei turii mił yi angk, kanik mulnjung. Molk kin, tuk endi mułum ei, Mariya Makandala mułum, nga endi Mariya Jeims mam ekii kin Josis, pe endi Salom mułum. ");
INSERT INTO nii_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kumb ok Jiisas Galilii konu multum kunum ełe, amb ombu eim kin ekii sik eim paki tołmun. Pe amb pei eipi mulnjung konu ei, en enim Jiisas kin Jerusalem konu ełe onjung. ");
INSERT INTO nii_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Nga kunum pou neng, Josep Arimasiya konu ełe mołpu om. “Eim kos piiłim wu num, ka wii mołum,” pa niłmin. Eim yi ku, Gos kunum tep ermba omba nipi, kui erpi mołułum. Pe yi mił, Josep eim ngii ełe nirik pupu, Pailos kumb ełe engim. Pe eim mund mong kulerim mon! “Pe na Jiisas ngenj simbii ond,” pa nipi pum. ");
INSERT INTO nii_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pe Pailos noman embin top piim. Pe opu ełmin wu endi kii sim, “Eim kułum poru nim min?” ");
INSERT INTO nii_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eim opu wumb tep ełim wu ek piipi poru nipi om. Opu, Josep kin ek nim, “Eim ngenj ei kapłi sinjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep eim alap kuru endi top erim. Pe eim Jiisas ngenj sipi mani tu wum. Pe eim alap kuru sipi, Jiisas ngenj ełe kum tum. Pe sipipi, komung endi tukpu sim, konu ełe mani kindim. Pe tukpu sinjing, ei ku tukpu owundu pendnjing. Pe Josep eim ku endi sipi, tukpu ełe pandi tum. ");
INSERT INTO nii_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nga Amb Mariya Makandala kin Mariya endi Josis mam, amb tał kan mulnjunguł. Pe tukpu ełe Josep Jiisas sipi mani kindpi kankił mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nga kor kunum pupu poru neng kin, Mariya Makandala kin amb Mariya Jeims mam kin Salom, en enim kopung ni epi muru ka tum epi ei top enjing. Erik, sipik Jiisas nenj kopung erngii nge sipnjing. ");
INSERT INTO nii_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kor niłmin kunum ei opu pang kin, kupiiring eni tang, wumb en enim wumb tukpu konu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Puk kin, en enim ek yi ninjing, “Wumb nii opu, ku owundu ei sipi ak tang, sinim wumb tukpu konu nirik bin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pe en enim kenjing ni, ku owundu tukpu ełe pim ni pinerim mon! Wu endi ku ei sipi, ak topu kindim pim. Pe ku ei ku owundu wii mułum. ");
INSERT INTO nii_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nga wumb tukpu ełe tuk punjung. Puk kin kenjing ni, wu kangi wu endi angił tundung orung mułum. Mułum wu, eim konduk kuru olt endi kindim wu ei kanik, puku sinjing. ");
INSERT INTO nii_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pe wu ei ek nipi ngum, “Enim puku sinenei! Enim Jiisas Nasares konu ełe wu ei enim kuruk onmun, wumb eim sik, ond peri ełe nil tunjung. Ba pe eim angpi nga konj pum. Pupu kin, eim ya ełe mulałim. Kinei! Eim pendnjing konu ełe kinei! ");
INSERT INTO nii_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ba enim puk, eim ekii siłmin wumb kanik ningii! Pe Piisa kanik ningii ku! ‘Jiisas eim ok Galilii konu ełe ok pum, yi mił eim ek nipi ngurum. Enim eim keningii,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nga amb ombu nga sikir tor punjung. Puk kin, en enim tukpu ei si kindik, tungu punjung. Puk kin, en enim mund mong tang, en enim noman tuk ełe mił pinerim. Pe en enim wu endi kin ek tingnenjing. Nimbił erang, en enim mund mong tum. ");
INSERT INTO nii_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kupiiring ok mendpił kunum kumna, Jiisas eim angpi nga tonu pum. Pe eim opu Mariya Makandala mułum konu ełe pum. Amb ei ok, Jiisas gui kis angił orung nga tał to tor kindim. ");
INSERT INTO nii_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Pe Mariya eim pupu, wumb ok Jiisas ekii siłmin wu ombu kanpi nim. Pe wu ombu noman embin erang, ke nik mulnjung. ");
INSERT INTO nii_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pe Mariya ek nipi wu ombu ngum, “Jiisas eim konj mułum, na kenj,” pa nim. Pe amb ei ek piik ek nim, ek ei pii gii ninenjing, mon! ");
INSERT INTO nii_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pe ekii se, Jiisas ekii siłmbił wu tał konu ełe si kindkił, tor punjnguł. Pe Jiisas wu eipi mił, wu tał onjnguł konu ełe tor om. ");
INSERT INTO nii_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pe Jiisas ekii siłmbił wu tał nga orung pukuł. Jiisas ekii siłmin wu kopur mulnjung konu ełe kan ninjngił, ba wu ombu wu tał ek ei pii gii ninenjing. ");
INSERT INTO nii_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nga ekii se, Jiisas ekii siłmin wumb engki nga endeim molk, kuni nok kin, Jiisas mulnjung konu ełe tonu om. Jiisas ek dinga yi nim, “Enim pii gii dinga pinałim,” pa nim. “Pe en enim noman pirek ninim. Nimbił erang enim piinenjing? Wumb kopur kanik ninjing ba, ei pii gii ninenjing.” ");
INSERT INTO nii_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jiisas ek dinga nipi eim ekii siłmin wumb ngum, “Enim pei konu owundu orung orung pei ełe puk, na ek ka ningii. ");
INSERT INTO nii_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wumb kopur pii gii nik, noł pinjing kin, Gos eim paki topu sipi orung simba. Ba wu ombu pii gii ninenjing kin, kos owundu omba kunum ei eim oł embin tui eim kin tonu omba. ");
INSERT INTO nii_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nga wumb kombur Gos kin pii gii ninjing kin, Gos eim jep oł er sipi, peni ełe kindmba. Yi mił, na embe ełe ek nik gui kis ei to tor kindik si kindngii,” pa nim. “Pe wumb ek ei endi mił ningii. ");
INSERT INTO nii_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Wumb ombu ka wembii angił ełe embiłngii, wembii ei wumb tołum epi ei enim tunermba. Wumb kombur to kondułum epi tumba ei kulerngii. Wumb endi kis ermba piingii, ei enim ngenj ełe embiłngii. Embiłangin kin, wumb ening tumba ei poru nimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Yi mił, pe Jiisas Owundu ek nipi poru neng kin, Gos ei epin konu ełe tonu sim. Pe Jiisas Gos angił tundung orung mołum. ");
INSERT INTO nii_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pe Jiisas ekii siłmin wumb ei punjung. Puk kin, Gos nge ek ka ei konu orung orung wumb pei kanik nik ngunjung. Nga Owundu en enim kin ouni kongun er endim. Nga en enim ek nik jep oł enjing ei, Owundu eim er dinga kindim ku. ");
INSERT INTO nii_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nim wu owundu Tiopilas. Ok Gos sin kin oł kombur eririm oł ei, pe keimi sin kin pe punum en enim pei angił ełe mon pulnjung. ");
INSERT INTO nii_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kumb ok, wumb kombur gupu ełe piik kanik erik Gos nge ek ka kongun ełmin ku. Ek ei nge sin sinjpin, ek mon pulnjung wumb pei ei oł ei nge pulnjung. ");
INSERT INTO nii_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pe akip na yi ku, ek poł ei połup nim ngond. Ek ombu nge kii sip kom sep piip muls kunum kinan, na oł ei ekii sinj. Sip, ei piip kin puls ek ei oł pulk mił kun pułup ngond. ");
INSERT INTO nii_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ek ei ek keimi, enim ok gerik piik. Yi mił erik ei enim pii kun erik mułngii. Pe ek ei yi ku połup ngond. ");
INSERT INTO nii_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Eros eim Jura wumb king multum kunum ei, wu endi Gos kin kułmał kałiłim wu endi multum wu ei embe Sekaraiya. Eim kułmał kałiłmin wumb ei Apaisa nge tiłap ełe tep to ełmin. Nga wu ei eim ambił Eron nge tiłap ełe amb ei, Elisembes pa niłmin. ");
INSERT INTO nii_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pe wu amb yi tał eł ełip, Gos ningił ełe oł ka er mulnjunguł. Pe Gos Owundu nge ek dinga kanim kanim ni pendim, pei ekii sikił kun ka mulnjunguł. Oł kis endi enerkił. ");
INSERT INTO nii_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ba wu amb yi tał kangił endi mingnenjngił mon! Eł ełip wii mendpił mulnjunguł. Wu amb tukui mendpił mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sekaraiya eim Gos kin kułmał kałiłim kongun ei ełim kunum ei, Sekaraiya nge tiłap wumb ei kongun ełe tonu onjung. ");
INSERT INTO nii_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Kułmał kałiłmin wumb ełmin oł ei erik, Gos andan tang wu ei embe pe nik wang to tonu kindnjing. Kindangin kin, eim Gos ngii owundu palting ka ełe mołpu kin, epi muru ka tołum epi ei sipi kin, dup eskił erpi kin, muru ku piiłmin. ");
INSERT INTO nii_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kunum ełe Gos kin dup eskił muru ka kałpi ełim kunum ei, wumb pei ok, andaring molk prei erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pe Sekaraiya eim kenim ni, dup kałim konu angił tundung ełe Owundu nge enjel angpi mułum ei kenim. ");
INSERT INTO nii_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pe eim enjel kanpi eim puku sipi, mund mong tang piim. ");
INSERT INTO nii_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ba enjel ek nipi Sekaraiya ngopu yi nim, “Sekaraiya, nim mund mong tunerii mon! Gos nim prei en ek ei piim. Nim ambnim Elisembes eim wu kangił endi mengmba. Kangił ei, nim eim embe Jon ninjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","“Mengang kin, nim noman ka peng, nim ka piinjii. Kangi ei tonu omba ei wumb pei ka piingii ku. ");
INSERT INTO nii_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Yi mił kangi ei wu owundu mułang, Gos Owundu eim kangi ei wu num mułmba ni piim. Pe eim noł wain ni noł dinga ombu nunermba. Eim mam kirim ełe multum kunum ei Gos Gui Ka eim kin piki to mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","“Jon eim ek neng kin Esrel wumb pei noman ak tok pii gii nik, Gos Owundu kin orung pungii nge nipi wumb ngumba. ");
INSERT INTO nii_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Gos Jon kindang opu, owundu nge ek ei ni pendim. (Jon eim owundu omba ełe kumb se omba). Ek ni pendpi opu eim noman dinga piimba ei ok Elainja ek ni tor kindiłim wu pirim mił yi eim yi ermba. Erpi kin, arim kingam noman to ak tungii nge nipi, wumb Gos ek to kindiłmin wumb ei neng noman kun ka seng, wumb kun ka molk Owundu omba nge kui er mułngii nipi kongun yi ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraiya ek nipi Gos nge enjel ngopu yi nim, “Na tukui er poru ninj. Na nam amb tukui erim ku. Nimbił erang na ek ei keimi ni piimbii?” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Pe Gos nge enjel ek yi nim, “Na Gepriyel, na Gos kumb ełe kun mołup enj. Gos Eim na kindang, na op nim nimbii nge onj. Pe ek poł ka ei nim kanip nind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","“Kapłi nim piinjii. Nim na ek ei piikin noman ełe kindnen kin, nim anmbił ak tang kin, ek tingnenjii, yi pepi pang, oł ombu opu poru nimba. Na nind ek ei keimi ekii se tonu omba.” ");
INSERT INTO nii_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wumb pei Sekaraiya anda omba ni piik kui er mulnjung. Epi nipe endi eim kin erang mołum ni piinjing; tuk konu Gos ngii owundu ełe ka mołum? ");
INSERT INTO nii_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ekii se eim anda opu, eim wumb kanpi ek nimba pinerim. Yi erang kin wumb en enim piik, Gos ngii owundu palting ka tuk ełe epi nipe endi kenim ni piinjing. Pe eim ek tingnarpi, angił ełe minj erpi ek mił tangpi erang kenjing. ");
INSERT INTO nii_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ekii se Sekaraiya eim Gos ngii owundu tuk kongun poru neng eim si kind ngii konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","Ekii se eim ambim Elisembes kangił mundii mułum. Pe amb ei eim koi er mułang oi angił orung o pang kin eim ek yi nim. “Pe Gos Owundu na kin noman ka ngum. Ok na kangił mulerim kunum ełe, na wumb kin ngenj singambił peng muls. Ba pe nga na singambił pinermbii,” nim. ");
INSERT INTO nii_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pe oi angił orung nga endeim o pang, Elisembes wu kangi endi mengmba ei Gos enjel Gepriyel kindang pupu Galilii mei owundu konu ełe orung endi sim konu ei Naseres ełe pui ni kindim. ");
INSERT INTO nii_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gos enjel kindang pupu kin, ambił endi mułum konu ełe pum ambił ei, wu endi simba nik kuimi to mundnjung. Wu ei embe Josep, wu ei King Deipis nge tiłap. Pe ambił ei embe Mariya. ");
INSERT INTO nii_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Pe enjel er pupu ambił kanpi ek yi nim, “Nim mołun ei? Gos Owundu nim kin eim noman ka ngopu nim kin mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ba eim nim ek ei piipi, eim noman embin tang piim. Eim noman ełe yi piipi, ei nipe ek ninim ni piim. ");
INSERT INTO nii_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Enjel ei ek yi nim, “Mariya, nim mund mong tunerii mon! Gos nim kin noman ka ngopu mołum. ");
INSERT INTO nii_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nim piin min? Nim kangił mundnjii; nga kangił endi mengnjii. Kangi ei embe Jiisas ninjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","“Eim wu owundu mułmba. Pe wumb eim kanik yi ningii, ‘Gos Owundu kingam mendpił,’ ningii. Nga Gos eim King mundang eim kupam King Deipis mołułum konu ełe eim simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","“Eim kunum kunum Jeikop nge wumb tiłap ełe eim King mułmba. Pe eim tep erpi mułmba konu kunum ei poru ninermba!” ");
INSERT INTO nii_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariya enjel kin ek yi nim, “Oł ei erpi tonu omba mił nenj? Na ambił wii moł, wu endi molałim molałim.” ");
INSERT INTO nii_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nga enjel ek ni orung kindpi yi nim, “Gos Gui Ka kapłi nim nge noman tuk ełe omba nim, Gos Owundu mendpił eim dinga kapłi nim kin omba. Yi erang nim kapłi kangi ei ekii se mengnjii, wumb eim embe sik yi ningii. Ei King ka wii Gos Owundu nge kingam yi ningii. ");
INSERT INTO nii_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nim piin min? Bipanim Elisembes amb tukui sim, ba kangi endi kirim ełe mołum. Okrii wumb yi niłmin, kangił endi mingnermba niłmin. Ba pe eim kangi mundii mułang, oi angił orung nga endeim o pang mołum. Pe Gos nim kin yi ku enim. ");
INSERT INTO nii_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Epi endi Gos kapłi enermba mił mon? Epi pei ei eim kapłi ermba.” ");
INSERT INTO nii_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariya ek yi nim, “Piin! Nam Owundu kongun ambił eim na kin nimbił oł ermba ni piimba ei kapłi nim nin ei mił ermba.” Nga Gos nge enjel eim si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kunum ei, Mariya eim sikir pupu mei komung ełe tonu pum. Jura mei owundu endi sim konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekaraiya ngii ełe nirik pupu Elisembes kanpi, “Mułiyo!” nipi yi nim. ");
INSERT INTO nii_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisembes Mariya kanpi, “Mułiyo,” nipi erim ek ei piipi eim kangił mundii mułum ei puku sipi piim ni Gos Gui Ka eim kin piki to mułum. ");
INSERT INTO nii_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pe Elisembes eim wii dinga tum. Topu yi nim, “Gos noman ka nim ngum, ba amb eipi kombur noman ka yi ngonałim mon! Pe kangi mundii mołun ei Gos noman ka kangi ngonum. ");
INSERT INTO nii_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na nii epi owundu ei na kin tonu onum? Nim Owundu mam ei na kin on; na kapłi enanim. ");
INSERT INTO nii_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Piini! Nim na mułiyo nin, ei piind, na kangi kirim ełe mołum, ei eim noman ka piipi tonu mani erang puku sim. Puku sipi, na piind nam Owundu mam moł ni piind. ");
INSERT INTO nii_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Owundu ek ei nim neng kin nim pii gii nin. Yi eran Gos nim kin noman ka ngonum. Ek ei ekii se yi mił ermba,” Elisembes yi nim. ");
INSERT INTO nii_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Pe Mariya ek yi nirim, “Nam noman ełe Gos Owundu embe ambił tonu kindind. ");
INSERT INTO nii_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Gos Owundu na kin paki tonum nam nge noman tuk ełe ka piind. ");
INSERT INTO nii_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na eim kongun wii ambił moł ba eim na noman ngonum. Pe ekii se wu amb pei Gos nge eim na kin noman ka ngołum pa ningii. ");
INSERT INTO nii_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gos Owundu nge dinga wii eim oł Owundu na kin ei nim. Gos eim embe ka wii sim. ");
INSERT INTO nii_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Wumb nii endi Gos Owundu mendpił mołum ba sinim mei wumb minj mołmun ni piinjing. Wumb ei Gos eim wumb ombu nge kingam noł ni mering kingenjing noł pei Gos eim kaimb kułum. ");
INSERT INTO nii_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gos kongun dinga wii erim; wumb en enim wumb Owundu mołum ni piinjing wumb ei en enim noman ełe ełmin. Wumb ei Gos to kindang eipi eipi pułmun. ");
INSERT INTO nii_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wumb King dinga mołmun Gos wumb ei to mani kindiłim. Kindpi, wumb wii mołmun wumb ei Gos wumb num tonu kindiłim. ");
INSERT INTO nii_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wumb kuni tang mołułmun wumb ei eim nge epi kanim kanim ka wii ngołum. Wumb epi pei sałiłim wumb ei Gos kindang wii punjung. ");
INSERT INTO nii_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Eim Esrel kongun wumb eim paki tang, sinim kupenjpin noł ek keimi dinga niłim. Wumb ei eim ok kaimb sipi eririm. Yi mił ku sinim kin kaimb sinim. ");
INSERT INTO nii_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Yi peng piipi kin, eim ek nipi sinim wumb kupenjpin noł ei ngum, Eiparam nge wumb ekii se tonu ongii kaimb sipi ngum. Nga kunum kinan molk pungii,” Mariya pa nim. ");
INSERT INTO nii_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya Elisembes kin mułangił oi tekliki mił o pang, nga ekii se eim ngii konu ełe orung pum. ");
INSERT INTO nii_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisembes kangi mengmba kunum mandi erang, eim wu kangi endi mengrim. ");
INSERT INTO nii_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wumb Elisembes nge opam noł wumb kin mandi mołmun wumb kin, molk piinjing ni ek om piinjing ei Owundu kin kaimb topu ngum. Nga wumb en enim eim kin ka piinjing. ");
INSERT INTO nii_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kunum angił orung nga tekliki o pang, wumb kangi ei tu wuk ngenj kopisngii nge tu wunjung. Pe kangi ei embe Sekaraiya nimin ninjing ei eim arim embe mił. ");
INSERT INTO nii_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ba kangi mam eim yi nim, “Mon! Sinim kangi ei embe Jon nimin!” ");
INSERT INTO nii_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Pe ek yi ninjing, “Nim bipanim embe endi yi pinałim.” ");
INSERT INTO nii_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Wumb ełe ek mił enjing kangi eim arim yi mił kii sinjing. Arim kangi embe nipe embe simba erim. ");
INSERT INTO nii_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Eim ku pirambi ei sipi mon endi połpu embe Jon ni pułum. Nga wumb en enim kanik puku sik kin piinjing. ");
INSERT INTO nii_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pe mendpił Sekaraiya gupu aki tang kin eim anmbił kapłi erim. Eim ek nipi Gos embe ambił tonu kindpi mułum. ");
INSERT INTO nii_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pe eim nge wumb konu mandi mulnjung wumb, mund mong tunjung. Oł ombu nge ek ombu orung orung konu Jura mei owundu ni konu komung ei ombu pang piinjing. ");
INSERT INTO nii_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Wumb ek ei piik en enim noman to piik, nga en enim yi ninjing. “Ekii se kangi ek er mułmba mił nenj?” Wumb yi piinjing, “Gos Owundu eim kin mołum,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gos Gui Ka arim Sekaraiya kin piki to mołpu eim paki tang yi nim. Pe eim Gos oł ekii se ermba oł piipi ek dinga nim. ");
INSERT INTO nii_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Sinim Gos embe ambił tonu kindmin. Eim Esrel nge Gos eim opu sinim orung simba nge onum. ");
INSERT INTO nii_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Eim nge kongun wumb tiłap ei King Deipis, Gos eim Owundu dinga wii endi mundang sinim sipi orung simba nge onum. ");
INSERT INTO nii_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Yi erang Gos eim ek keimi niłmin wumb ei gupu ełe ni tor kindim. ");
INSERT INTO nii_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Eim ek yi nim, sinim opu wumb dinga ełe sipi orung simba enim. Pe sinim kin noman kis piik wumb er mułngii konu ełe sinim wumb ei dinga ełe sipi orung simba. ");
INSERT INTO nii_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Sipi pang, eim sinim kupenjpin noł kaimb se ngopu paki tołum. Pe eim kumb ok ek dinga nipi pendpi oł ka ełim oł ei piipi kin, yi mił erim. ");
INSERT INTO nii_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ei keimi minj nipi sinim kupenjpin Eiparam multum konu ek keimi nipi ngurum. ");
INSERT INTO nii_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Eim sinim opu orung wumb eim nge dinga sipi orung simba. Eim ek dinga sinim ngum ei sinim eim kongun er mułmun. Sinim mund mong tunermin. ");
INSERT INTO nii_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kunum kunum sinim mołpun, eim kongun ka erpin, kunum kunum ka minj mułpun, oł kun ka er mołpun, eim kumb ełe mendpił erpin mułmun,” wumb kin ek yi nim. ");
INSERT INTO nii_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Nga ek yi nim, “Pe nim na kangi, ekii se nim Gos Owundu mendpił nge ek ni tor kindiłim wu endi mulnjii yi ningii. Pe nim kumb se pukun, Owundu nge kongun er kun er mulnjii. ");
INSERT INTO nii_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nim sinim eim nge wumb ek nikin wumb ngan, wumb en enim oł kis kil ngangin kin wumb ei Owundu sipi orung simba nge omba. ");
INSERT INTO nii_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sinim Gos nge kaimb owundu sipi, sinim kin kindpi yi er ngumba. Eim epin konu tonu mendpił tiłang ka wii ermba. Yi ermba ei nge Gos sinim wumb sipi orung simba nge omba. ");
INSERT INTO nii_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tiłang ei opu wumb kin emii tuk mołmun, ni wumb mandi koltmun ni piik tungu enjing. Wumb ei tiłang ngumba sinim endmin nge andłam ei er ka erang sinim noman emin peng endmin.” ");
INSERT INTO nii_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ekii se kangi ei tonu opu dinga erpi eim noman tuk ełe dinga pim. Peng kin, eim wumb mulerngii konu mołpu Gos kongun ermba nge opu Esrel wumb mułngii konu ełe tor omba. ");
INSERT INTO nii_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kunum ei, Rom wu owundu King mułum wu ei embe Akasas eim ek lo endi yi nipi pendrim. Wumb pei en enim konu ełe mendpił ełe puk kin, en enim embe pułngii nirim. ");
INSERT INTO nii_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kunum ei kumna kin wumb embe połmun kunum ełe Sairiiniyas ei wu owundu Siriya mei owundu ełe tep er mułum kunum ei. ");
INSERT INTO nii_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yi erang kin, wumb en enim konu ełe punjung. Puk kin, en enim embe pułngii. Polk poru neng kin, en enim konu ełe orung punjung. ");
INSERT INTO nii_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep eim King Deipis nge wumb tiłap ende. Pe Josep eim Naseres konu ełe Galilii mei owundu si kindpi, pupu Jura mei owundu Deipis nge konu ełe purum konu ei embe Beslem konu niłmin. ");
INSERT INTO nii_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Eim ambim Mariya kin tep to pukuł, eł ełip embe ni wumb ngunguł nge pukuł. Punjnguł kunum ei Mariya kangił mengmba mił mandi erang pukuł. ");
INSERT INTO nii_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Wumb tał konu ełe mułangił ei Mariya kangił mengmba kunum mandi erim. ");
INSERT INTO nii_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Pe eim kingam kumna kung kou ngii ełe mengrim. Nimbił erang wumb pałmin ngii pei piki tum. Pe alap endi sipi pandi topu pindang mer kung kou kuni nołmun konu ełe pindang pim. ");
INSERT INTO nii_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kunum ei, wu kombur kung siipsiip es tołmun wumb Juriya mei konu ełe andaring mulk. Wumb en enim kung siipsiip tep erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Pe Owundu nge enjel kindang om. Opu, Owundu nge dinga tiłang opu en enim mulnjung konu ełe erang wumb ombu en enim mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ba Owundu nge enjel ek nipi wumb ngum, “Enim mund mong tunerngii! Piik, mułei! Na enim kin ek ka endi tu wund. Enim wu amb konu orung orung pei piik noman ka piingii nge ek tu wund,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","“Kunum ełe King Deipis nge konu owundu ełe amb endi kangił kembis mengnim. Kangi kembis ei enim sipi orung simba wu ei Krais, ei wu Owundu Gos kindang om. ");
INSERT INTO nii_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Pe na ek endi nemb enim yi mił piik kin, puk keningii. Enim keningii ei kangi kembis endi alap kin tuk kindik mer kung kou kuni nołmun konu ełe pałim ei keningii. Kanik kin, enim piingii ni na ek eim kin nind ei keimi pimba.” ");
INSERT INTO nii_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Owundu nge enjel ei ek yi neng kin; pe sikir enjel pei mani ok eim kin mulnjung. Noman ka piik golang nik Gos ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Gos embe ambilk tonu kindngii. Mani mei wumb noman emin pengłi! Gos eim enim noman ka ngonum.” ");
INSERT INTO nii_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Pe enjel pei epin konu orung punjung. Pe kung siipsiip es tołmun wumb ei en enim ek dinga ninjing. “Sinim pamin! Beslem konu sikir pupun, Owundu ek yi mił nim epi tonu onum ei kinamin,” nik punjung. ");
INSERT INTO nii_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pe wumb sikir puk, Josep kin Mariya teł mulnjunguł kenjing. Kangi kembis ei mer kung kou kuni nołmun konu ełe pim kenjing. ");
INSERT INTO nii_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Pe kan poru nik, orung puk kangił kembis ei nge ek piinjing mił nik tor kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pe wumb pei molk piinjing ni, kung siipsiip es tołmun wumb ninjing ek ei piik kin, kom sek piinjing. ");
INSERT INTO nii_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ba Mariya eim ek ei piipi noman ełe kindpi, kom se piipi minj mułum. ");
INSERT INTO nii_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Kung siipsiip es tołmun wumb orung puk Gos embe ambilk tonu kindik punjung. Wumb en enim ka piik, Gos ek piik kanik enjing. Ei Gos enjel ek nipi erim mił kenjing ku. ");
INSERT INTO nii_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ekii se kunum angił orung nga tekliki o pang, kangił kembis ngenj kopisnjing. Kopsik, kangił ei embe Jiisas ninjing mił eim mam mingnerim kunum ei Owundu enjel kindang opu nim. Ei kangił embe yi nengin nim mił ninjing. ");
INSERT INTO nii_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Kunum poru neng, Mariya kin kingam kin ka mułnguł oł enjing ei, Moses lo ek niłim mił enjing. Pe arim mam teł kangił ei Jerusalem konu ełe sipkił Gos Owundu kin ngunguł nge sipinjngił. ");
INSERT INTO nii_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ei yi mił, Gos Owundu lo ek yi er pendiłim mił niłmin. “Kangił wu kumna mengiłmin kangił ei Gos Owundu kongun ermba niłmin oł ei nge enjngił.” ");
INSERT INTO nii_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Wumb tał eł ełip Gos kin kułmał kełngił ei Moses lo ek niłim mił yi mił enjngił. Ei Owundu lo ek pałim mił ermbił ni piinjngił. Kei Pułmu mił tał min kei wał eipi tał sikił Gos kin kułmał kełmbił ni sipinjngił. ");
INSERT INTO nii_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kapłi, wu endi Jerusalem konu ełe mułum wu ei embe Simion. Ei wu kun minj mołum wu ek piipi ełim wu, ei eim wumb Esrel wumb sipi orung simba nge wu endi omba, ni kui er mułum. Gos nge Gui Ka ei Simion kin mułum. ");
INSERT INTO nii_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Gos nge Gui Ka ei eim yi nirim, “Simion sikir kulenjii mon!” pa nirim. “Nim Owundu nge kindang wu Krais kumb se kenjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gos nge Gui Ka je erang Simion pupu men ngii owundu ełe nirik pum. Pe kingam arim mam tał sikił tu wukuł lo ek ninim mił ermbił ei Gos Owundu kin ngunguł nge onjnguł. ");
INSERT INTO nii_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion eim kangi ei sipi sipim. Si pang kin, Gos embe ambił tonu kindpi, yi nim. ");
INSERT INTO nii_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","“Pe Owundu pe ni ninim kongun wu ei er ka eran noman emin sepi piyangłi nim. Nam ningił ełe nim sin sikin orung sinjii nge on ei kanip ka piip moł. ");
INSERT INTO nii_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nim ek ok nirim, ‘Simion, sikir kulenjii mon! Nim Owundu nge kindang wu Krais kumb se kenjii,’ pa nim. Wu amb pei keningii nge en. Wu ei kindang sinim sipi orung simba nge om yi nirim mił en. ");
INSERT INTO nii_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Gos eim tiłang mani kindim. Kindpi, tiłang ei erang wumb tiłap eipi nim oł ei nge ekii sik noman tok piik erngii. Nga nim nge enjel wumb embe owundu erim,” Simion Jiisas nge ek pei nirim. ");
INSERT INTO nii_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Kangi mam arim tał Simion nim ek ei piikił puku sikił piinjngił. ");
INSERT INTO nii_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Pe Simion Gos ek ka nipi en enim ngum. Nga ek yi mił nipi Mariya ngum, “Piini! Gos eim noman ełe kangi ei yi erang Esrel wumb pei bok tonmun, ba wumb kombur nga angk gii nik dinga mołmun. Eim Gos nge noman ełe tuk mundum mułmba. Mułang kin, wumb pei eim kin ek kis nik ngok erngii. ");
INSERT INTO nii_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Erangin kin, nim noman tuk ełe tui mił tang yi mił kaimb erang piinjii. Eim wumb en enim noman tuk ełe andan tang kin noman tuk ei to tor kindmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Gos nge ek ni tor kindiłim amb endi mułum amb ei embe ‘Ana’ niłmin. Eim arim Panul mułum; eim nge wumb tiłap Asir; amb ei amb tukui mendpił mułum. Ok, eim wam kin kung ngii angił orung nga tał mułum. ");
INSERT INTO nii_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ekii se wam kułang kin, eim wii mułang kung ngii 84 pei o pum. Amb ei eim men ngii owundu mei wak tunałim. Eim konu kuni mowii nipi eim Gos kin prei tek tek ełim. Ei epin, tinga Gos embe ambił dinga kindpi kongun ełim. ");
INSERT INTO nii_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kunum ei Jiisas arim mam teł eim tu wunjnguł eim men ngii opu Gos kin noman ka piipi ngum. Pe eim kangi ei nge ek ni tor kindpi nim. “Kangi ei enim wumb pei kui er mulnjung wumb kin Jura wumb pei sipi orung simba nge om,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wumb en enim Owundu nge lo ek niłim mił ełe enjing. En enim Galilii mei orung puk, Naseres konu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pe kangi ei oupu tonu opu dinga er mułum. Mołpu kin, eim noman ka wii peng mołpu, nga Gos eim noman ka Jiisas ngum. ");
INSERT INTO nii_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Kangi mam arim tał eł ełip ei kung ngii endi o pułum kunum ei kunum kunum Jerusalem konu ełe pułmbuł. Kunum ei konu kor owundu kunum ei yi niłmin, ‘Pasopa kuni owundu numun,’ pa niłmin kunum ei. ");
INSERT INTO nii_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jiisas eim kung ngii engki nga tał yi mił multum kunum ei, kor owundu ekii siłmin oł ei sik Jiisas arim mam ni Jerusalem konu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ekii se, ‘Pasopa kunum’ ei poru neng, nga si kindik orung punjung; ba kangi Jiisas Jerusalem konu ełe enj multum. Pe arim mam tał Jiisas multum ei piinerkił. ");
INSERT INTO nii_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kunum ei arim mam tał Jiisas wu amb kin onmun ni piikił. Yi ni piikił okuł, nga eł ełip wumb tiłap ende kin wumb puł kin endik konu kurkuł endkił mon pirim. ");
INSERT INTO nii_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Nga topultung kurkuł endkił, ba mon pirim. Yi peng kin, nga Jerusalem konu ełe orung pukuł, kur keningił nge pukuł. ");
INSERT INTO nii_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nga kunum ei, wumb tał kurkuł andangił kunum tekliki o purum. Nga ekii se pu kenkił ni men ngii owundu ełe nirik multum kenkił. Wumb ek mon połmun wumb mulk konu ełe tuk multum. Wumb ei ek ninjing ek ei kii se piipi nga wumb nik ek mił piipi nipi orung kindpi multum. ");
INSERT INTO nii_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Wu ombu eim ek ei piik kin, kangił ei eim noman ka peng ek nipi kii sipi erang, wu ombu en enim puku sik endnjing. ");
INSERT INTO nii_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Arim mam tał Jiisas kankił nga puku sinjngił. Mam ek nipi yi nirim, “Kangił nim nimbił erang sił kin yi en? Nim arnim kin na kin noman embin tang kin, nim kurpuł andinmbił,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kangi Jiisas eim ek ni orung kindpi yi nim, “Nimbił erang, ełip na kurkuł andinmbił? Ełip piinenjngił min; na nam Arnan ngii owundu konu moł?” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ba wumb tał Jiisas ek nim ei ek pułe pii kun enenjngił. ");
INSERT INTO nii_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kapłi, mam arim tał kin orung punjung. Nga Naseres konu ełe tor punjung. Pe mam arim tał ek ninjngił ek ei piipi ekii siłim. Pe eim mam eim niłim ek ombu piipi noman ełe tuk kind piip mułum. ");
INSERT INTO nii_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jiisas oupu tonu wang, eim noman ka wii tonu om. Wang kin, wu amb eim kan ka kaniłmin ei nga Gos kan ka kaniłim ku. ");
INSERT INTO nii_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kung ngii engki nga angił orung o pang Taipiriyas Siisa Rom King owundu mił mułum. Nga wu Pansiyas Pailos Jura mei owundu wu num mułum. Nga Eros Galilii mei owundu wu num mułum. Pe angim Pilip Esuriya kin Trakonaisis ełe wu num mułum. Pe wu endi Laiseniyas Apiliin konu ełe wu num mułum. ");
INSERT INTO nii_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas kin Kaiyapas ni wu owundu kułmał kałiłmbił wu tał mołmbuł. Kunum ei Jon Sekaraiya kingam eim wumb konu ełe mulenjing konu ełe mułum. Pe Gos ek eim kin ek nipi ngurum. ");
INSERT INTO nii_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yi erang kin, Jon eim Jura noł Joran konu wumb mulk konu ełe orung orung pum. Pupu, Gos ek piirim mił ni Joran wumb ngang, “En enim piyei! Oł kis si kindik, noman ak tok ok noł pingii,” ei mił nirim. “Pe Gos enim oł kis kil ngumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ek ni tor kindiłim wu endi Aisaiya eim mon ełe ok ek yi mił pułum ei keimi tonu orum. “Wumb mulenjing konu ełe wu endi wii top yi nim: ‘Owundu nge andłam er kun erei!’ nim. ");
INSERT INTO nii_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","‘Pe mei mani pum ni komung tonu pum ni, peng mei kis tonu mani er punum kin andłam mapi erim ei, enim nge nipi eim er kun ermba,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","‘Wumb pei keningii ni Gos kongun erpi wumb pei sipi orung simba nge ermba.’” ");
INSERT INTO nii_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wumb pei wangin kin, Jon wumb noł pendpi ngumba nge ok. Eim ek yi nim, “Enim ek kend oł ełmin wembii kis mił mołmun. Enim wumb nii nipi ngum, Gos nge oł ekii se enim kin tonu omba ei nge enim kapłi koi erik si kindik punerngii. ");
INSERT INTO nii_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Enim noman ak tok onjung kin, enim noman konj ka sik mułngii, nge nipi ngum. En enim noman piik ełe molk nik, ‘Eiparam ei sin erinjpin’ ei ninerei mon! Na enim kanip nind, Gos ya ku ombu, kapłi erang, Eiparam kingam noł mułngii. ");
INSERT INTO nii_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Wu endi tui maimi kin ond tami tumba enim mił yi ku wumb noman tuk to ak tunenjing kin, ond mong tunanim ond ei kołmung to dup kałiłmin mił Gos eim wumb ombu kin yi ku ermba.” ");
INSERT INTO nii_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Eim ek yi neng kin, wumb pei eim kii sinjing, “Pe sin nimbił oł er wamin, nim sin noman tuk ak tunjung ni piinjii?” ");
INSERT INTO nii_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Pe ek nipi orung kindim wumb ngopu yi nim, “Wu endi konduk tał simba wu ei wu endi ngunjii. Nga wu endi kuni sinermba ei ngunjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wumb ku takis siłmin wumb ok noł pingii nge onjung. Wumb ei eim kin sinjing, “Ek emb wu, sin nimbił oł er wamin nim sin noman tuk ak tunjung ni piinjii?” ");
INSERT INTO nii_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ek yi nipi wumb ei ngum, “Enim lo ku takis singii nimba mił sei! Nga enim ku endi pendik simin ni enerei mon!” ");
INSERT INTO nii_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Pe opu wumb ok eim kii sinjing ku, “Sin nimbił oł er wamin nim sin noman tuk ak tunjung ni piinjii?” nik kii sik ninjing. Pe Jon ek nipi ngum, “Enim wumb wii kepii tunarik, kos wii enerik, ku wii sinerngii mon! En enim kongun ku ei mendpił ambilk, noman ka piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wu amb epi simin ni noman dinga piik kin, en enim noman ełe kom sek yi er mulnjung. Molk, yi piinjing, Jon ei Gos kindang om wu Krais min, ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pe Jon ek nipi orung kindim, “Na noł sip enim noł mendpił pendip ngond. Ekii se wu endi omba wu ei eim dinga ei kapłi ermba ei na dinga ei kapłi enanim. Eim dinga ei kapłi ermba. Na wu ka mon. Na eim kongun wu eim simb su kan ei na kapłi si kindmbii, ba na kapłi enanim. Eim wu num mołum. Eim enim Gos nge Gui Ka ełe nin dup ełe kin ouni yi mił wumb noł pendip ngumba. ");
INSERT INTO nii_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eim kapor sipi ambiłpi kuni wiis nginamin si kindpi er ka ermba. Pe kuni wiis ei sipi kuni ngii ełe kapłi kułou tumba. Ba wiis tindkan ei dup kełmba. Dup ei nopu kumbulermba mon! Piram kunum kunum nopu pimba.” ");
INSERT INTO nii_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon eim ek kanim eipi eipi neng kin wumb ek dinga ngopu, yi mił, kunum ei Jon eim Gos ek ka nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ba Jon Eros kin ek ngang, Eros eim wu num endi eim nge angim nge ambim embe Erosiyas sim. Eros eim oł kis kanim kanim eipi erim. ");
INSERT INTO nii_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jon Eros kin ek nipi ngum. Ngang kin, eim Jon kan ngii pendim. Pendang, Eros mong owundu sim. ");
INSERT INTO nii_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wumb pei noł pek mułangin kin, Jiisas noł pim ku. Jiisas noł pepi tonu opu, peri er mułang kin, ei kupu muł ei wuł ał pum. ");
INSERT INTO nii_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Gos nge Gui Ka ei mani opu eim kin om. Gos Gui Ka ei kenjing ni kei Kurmuł mił mani om. Ei epin Gos ek endi nipi mani opu yi nim. “Nim na kangi! Na nim kin noman ngond. Na nim kin ka piip ngond,” nim. ");
INSERT INTO nii_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kunum ei Jiisas eim kongun mendpił ermba erim. Nga eim kung ngii engki nga tekliki o pang eim kongun ermba erim. Wumb piik eim Josep kingam ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elai nge kingam Josep; Masas nge kingam Elai; Liiwai nge kingam Masas; Melkai nge kingam Liiwai; Janai nge kingam Melkai; Josep nge kingam Janai; ");
INSERT INTO nii_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Masaraiyas nge kingam Josep; Emos nge kingam Masaraiyas; Neiyam nge kingam Emos; Eslii nge kingam Neiyam; Nakai nge kingam Eslii; ");
INSERT INTO nii_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Mas nge kingam Nakai; Masasaiyas nge kingam Mas; Semen nge kingam Masasaiyas; Josek nge kingam Semen; Jora nge kingam Josek; ");
INSERT INTO nii_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jonan nge kingam Jora; Tesa nge kingam Jonan; Serapapel nge kingam Tesa; Sialsiel nge kingam Serapapel; Nerai nge kingam Sialsiel; ");
INSERT INTO nii_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melkai nge kingam Nerai; Endai nge kingam Melkai; Kosam nge kingam Endai; Elmaram nge kingam Kosam; Er nge kingam Elmaram; ");
INSERT INTO nii_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Josuwa nge kingam Er; Eliyesa nge kingam Josuwa; Jorim nge kingam Eliyesa; Masas nge kingam Jorim; Liiwai nge kingam Masas. ");
INSERT INTO nii_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Saimon nge kingam Liiwai. Jura nge kingam Saimon; Josep nge kingam Jura; Jonam nge kingam Josep; Elaikim nge kingam Jonam; ");
INSERT INTO nii_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meliya nge kingam Elaikim; Mena nge kingam Meliya; Masas nge kingam Mena; Nesan nge kingam Masas; Deipis nge kingam Nesan; ");
INSERT INTO nii_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jesii nge kingam Deipis; Oper nge kingam Jesii; Bowas nge kingam Oper, Salmon nge kingam Bowas; Naison nge kingam Salmon; ");
INSERT INTO nii_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminarap nge kingam Naison; Armin nge kingam Aminarap; Arni nge kingam Armin; Esran nge kingam Arni; Peres nge kingam Esran; Jura nge kingam Peres; ");
INSERT INTO nii_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jeikop nge kingam Jura; Aisak nge kingam Jeikop; Eiparam nge kingam Aisak; Tera nge kingam Eiparam; Neiyor nge kingam Tera; ");
INSERT INTO nii_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Serak nge kingam Neiyor; Tiyu nge kingam Serak; Pelek nge kingam Tiyu; Eper nge kingam Pelek; Sila nge kingam Eper; ");
INSERT INTO nii_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Keinan nge kingam Sila; Apaksas nge kingam Keinan; Sem nge kingam Apaksas; Nowa nge kingam Sem; Lemek nge kingam Nowa; ");
INSERT INTO nii_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Mesusala nge kingam Lemek; Enok nge kingam Mesusala; Jeres nge kingam Enok; Manalail nge kingam Jeres; Keinan nge kingam Manalail; ");
INSERT INTO nii_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enos nge kingam Keinan; Ses nge kingam Enos; Andam nge kingam Ses; Gos nge kingam Andam. ");
INSERT INTO nii_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Gos Gui Ka opu Jiisas kin paki to mułang, Jiisas eim nga noł Joran si kindpi orung pum. Pang kin, Gos Gui Ka eim sipi konu wumb mulenjing konu sipim. ");
INSERT INTO nii_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Gos Gui Ka Jiisas paki tang mułum. Mołang kin, wumb mulenjing konu ełe mułang kunum 40 o pum. Kunum ełe Seisen opu Jiisas kanpi ek nipi eim ermba mił ei kenmbii ni erim. Kunum ełe Jiisas eim kuni nunerim, wii minj mułum. Ekii se kuni tang piim. ");
INSERT INTO nii_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Seisen yi nim, “Nim Gos kingam pim kin, kom ku ei nen kin bres erangłi!” nim. ");
INSERT INTO nii_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pe Jiisas ek nipi orung kindim, “Gos ok połmun ek ełe yi nim, ‘Kuni bres mendpił wumb nołmun ei kapłi enałim, wumb konj mulerngii,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Seisen Jiisas tonu sipi sikir andan topu mei orung orung tep ełiłim wumb pei mołmun konu ei andan tum. ");
INSERT INTO nii_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Pe Seisen ek yi nim, “Tep ełim wumb ełe dinga pałim ei kin epi ka wii ya mołum ei kin ei na nim ngumbii,” pa nim. “Epi ka ya mołum ei na epi ei nga kapłi nanim noman ełe wu endi ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","“Pe nim na kin prei en kin na epi ei pei nim ngumbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jiisas ek nipi orung kindpi yi nim, “Gos ok połmun ek ełe yi ninim, ‘Nim Gos Owundu embe ambił tonu kindkin eim kongun ei minj enjii ninim,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Pe nga Seisen Jiisas sipipi, Jerusalem konu ełe men ngii owundu engim ełe tonu mondpu ek yi nim. “Gos ok połmun ek ełe yi ninim, ‘Gos nge enjel nim kin tep er mułngii. Er mołangin kin, enjel en enim angił nim ambilk tonu singii. Embiłangin kin, ku endi simb ełe tunermba yi mił ninim.’ Pe nim Gos kingam pim kin, nim ya ełe angkin puku si mani punjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jiisas ek nipi orung kindim, “Gos ok połmun ek yi ninim, ‘Nim Gos Owundu oł ei ermba nim kenjii ba oł ei nim kapłi enenjii,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pe Seisen ek nipi erim oł ombu Jiisas ermba ni kanpi erim, ba mon peng Seisen kunum endi nga op ermbii ni piip si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gos nge Gui Ka dinga ełe Jiisas kin mołang kin, Galilii mei ełe orung pum. Pe eim ek ka ei konu orung ełe pei pang wumb piinjing. ");
INSERT INTO nii_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kunum ei Jiisas eim, wumb men ngii ełe Gos ek kunum kunum nipi wumb ngołum. Ngang, wumb pei eim embe ambił tonu kindiłmin. ");
INSERT INTO nii_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jiisas Naseres konu ełe pum. Konu ei ok Jiisas kangił kembis kin konu ełe mołpu owundu erim ei, konu ełe mołum. Kor kunum ei, pupu men ngii ełe pułum. Pupu, Jiisas kunum kunum Gos ek ka gerpi ełim ei wumb piiłmin. ");
INSERT INTO nii_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Pe wumb, Gos ek ni tor kindiłim Aisaiya wu ei ok pułum ek sik ngangin, ek ei gerpi kenim ni ek yi piim. ");
INSERT INTO nii_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Gos nge Gui Ka ei na kin mułang kin, eim na kongun ngopu enjii nipi kindim. Ei na op wumb epi sinałim wumb kin Gos ek ka yi nip ngumbii nge onj. Wumb kan puk mołmun ei tor wii mułngii. Ningił tumbun mołum wumb ei ka nik mułngii. Wumb endi noman embin peng mołmun wumb ei na paki tumbii nge onj. ");
INSERT INTO nii_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na op enim nip ngond, pe kunum Owundu nge wumb eim sipi orung simba nge om.” ");
INSERT INTO nii_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jiisas ek mon połmun ni tuk kindpi, ngopu eim mani mułang, wumb men ngii ełe tuk mołangin wumb ei Jiisas kin ningił kanik minj mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pe eim ek nipi wumb ngumba nge erim. “Akip Gos ek ei tor onum. Yi mił enim piik poru ninmin.” ");
INSERT INTO nii_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Pe wumb eim embe ambilk tonu kindik, eim ek ka nim ni piik mulnjung. Molk, en enim ek yi ninjing, “Wu ei Josep kingam min mon?” ");
INSERT INTO nii_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jiisas eim piipi kenim wumb pei eim ek pii gii ninenjing. Ninerangin kin, eim ek yi nipi wumb ngum, “Ek ekin endi na kin enim yi nik na ngungii, ‘Ond mong ngopu ełim wu ninim nge ngenj er ka enjii. Nim Kapaniyam konu ełe oł en ei sin piinjpin. Pe ya ninim mei ełe oł ei nge enjii,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Eim ek yi nim, “Na ek keimi nip enim ngond. Wu endi ek ni tor kindiłim wu mołpu ek keimi nimba; ei eim nge ngii konu mołmun wumb ei eim ek ei piinerngii. ");
INSERT INTO nii_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Na ek keimi nip enim ngond ei enim piinmin. Elainja multum kunum ei Esrel amb pei mulk, wenjing noł kulk kunum ei kupu muł ei poru nirim. Pe kung ngii tekliki o pang oi angił orung nge endeim purum kunum ei konu pei orung orung kumb kuni owundu sirim. ");
INSERT INTO nii_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ba Gos Elainja kindpi pupu Esrel amb wei endi mułum konu pui ni kindnerim. Mon! Gos Elainja Serepas konu ełe Sairon mei orung pui nirim konu ełe, amb endi wam kultum amb ei, kuni sałim konu ełe nim pui nipi kindrim. ");
INSERT INTO nii_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Gos nge ek ni tor kindiłim wu endi Elainja orung kunum ei wumb kinj wumb pei Esrel konu mulk, konu ei tuk ełe wumb endi ka mulerik mon! Siriya konu ełe kinj wu Neimin ni wu ei minj ka multum.” Jiisas nirim ek ei eim nge wumb tiłap ende ei eim ek piinenjing. ");
INSERT INTO nii_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Wumb men ngii ełe nirik molk ek ei piik popuł sinjing. ");
INSERT INTO nii_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pe wumb tonu angk, Jiisas ambilk konu owundu anda kindnjing. Kindangin kin, konu owundu ei, tonu komung endi ełe sim. Pe wumb eim sik komung ełe orung tonu sip komung ełe to olkup to kindngii. ");
INSERT INTO nii_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ba eim tuk wumb onjung konu opu, tuk ełe opu am pum. ");
INSERT INTO nii_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Eim Kapaniyam konu ełe tor pupu, mei owundu endi sim ei Galilii niłmin. Pupu, kunum ei kor kunum wumb mulnjung Gos ek ka nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Wumb eim ek ei piik wumb tuk puku sik enjing. Nimbił erang Jiisas ek ei dinga pałim. ");
INSERT INTO nii_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Men ngii ełe wu endi gui kis tuk mułum wu ei ngii ełe tuk mułum. Mołpu kin wii dinga topu, ek dinga nipi yi erim. “Jiisas, Naseres konu wu, nim ya ełe nimbił oł enjii on? Nim sin kin tunjii on min? Nim sin kan wiik to si kindnjii! Na nim piind ei Nim Gos nge wu kun ka wii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ba Jiisas ek nipi orung kindpi, ek dinga ngum, “Nim ek tingnarkin, wu ei si kind o pui!” nim. Gui kis ni wu ei to kindang mani pupu wumb mulnjung konu tuk pim. Pe gui kis wu ei kin oł endi nga enerim wii si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wumb pei puku sik, yi ninjing, “Ek ei nipe ek yi ninjing? Wu ei wu Owundu eim dinga sałim ei eim ek dinga nipi gui kis ngang kin, gui kis pei eim ek piik wu endi si kindik punjung,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Oł yi mił erang kin, Jiisas eim erim oł ei wumb nik pangin, wumb konu ełe orung orung pei piinjing. ");
INSERT INTO nii_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jiisas men ngii ei si kindpi anda opu, pupu Saimon ngii engim konu ełe nirik pum. Pupu, kenim ni, Saimon ambim mam ening owundu tang pim. Pe wumb ok Jiisas kii sengin, “Amb ei paki tunjii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pe eim pupu amb mułum konu ełe mandi angpi ek dinga neng, ening tum ni poru nim!” Neng kin, amb ni sikir angpi kuni wumb pei ngum. ");
INSERT INTO nii_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eni mani ba erang, wumb pei ening kanim kanim pim wumb, Jiisas mułum konu ełe tu wunjung. Pe eim wumb kis pim wumb, peng ełe endeim endeim ni angił ambiłpi pang, wumb pei ka mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jiisas ek nipi ngum. Pe gui kis ombu wumb pei si kindik konu eipi eipi punjung. Gui kis ombu wii dinga tok yi ninjing, “Nim Gos kingam.” Ba eim gui kis ek ngopu, “Ek tingnerei!” nipi ek dinga ngum. Gui kis ombu Jiisas nim ek piik, “Eim Krais wu endi Gos kindang om,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pe kupiiring ok, Jiisas pupu wumb mulenjing konu ełe pum. Pang kin, wumb eim pum konu kanik, ekii sek punjung wumb ei si kindik punenjing mon! Eim konu eipi punermba nik, eim endim konu ekii sik punjung. ");
INSERT INTO nii_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ba eim ek nipi orung kindpi yi nim, “Pe na ek ka nip wumb ngumbii ei nge Gos sinim tep er mołum mił ei nip wumb tiłap eipi kin nip kongun ei nge ermbii,” pa nipi kindim. ");
INSERT INTO nii_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pe eim Jura konu wumb, men ngii engim konu ełe pupu Gos ek nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kunum endi noł wer ełe mandi Genesares noł gop ełe Jiisas eim angpi mułum. Nga eim wu amb pei Gos ek ni ngang piimin nik wumb pei eim kin ok wumb piki tok mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eim kenim ni noł kanu tał noł gop wer ełe pinjngił, omu tołmun wumb tor punjung. Wumb omu kon polk omu tołmun wumb en enim omu kon ei noł was er kun erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jiisas eim noł kanu endi ełe tonu purum. Purum noł kanu ei Saimon nge kanu. Nga eim Saimon kanpi yi nirim, “Nim noł kanu ei noł ełe pip to tuk kindii!” nirim. Pe eim noł kanu ełe mołpu, Gos ek ka nipi wumb ngurum. ");
INSERT INTO nii_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eim ek ni poru nipi, ekii se eim Saimon kanpi nim, “Nim noł kanu pip to sipkin, omu kon tuk noł ełe mani kindkin omu sinjii nge kindii,” nim. ");
INSERT INTO nii_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon ek nipi orung kindim, “Epin kunum endi sin kongun enjpin omu tunenjpin. Pinerang, sin omu endi tunenjpin mon, ba nim nin, ei kapłi nga omu kon pułmbii,” pa nipi mani kindim. ");
INSERT INTO nii_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","7","Omu tołmun wumb kombur yi erangin kin, omu kon omu piki top mułum. Mułang kin, omu kon kiłip tumba nge erim. Yi erangin kin, omu tołmun wumb ei en enim kongun ende ełmin wumb noł kanu eipi se mulnjung ei tu wangin nik angił pinou enjing. Erangin wangin kin, noł kanu tał omu kindnjing piki topu noł kanu tał noł ełe mandring simba erim. ");
INSERT INTO nii_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Piisa eim jep oł ei kanpi Jiisas simb ełe mani pupu yi nim, “Nim si kind po! Na oł kis ełe wu moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pe eim omu pei sinjing omu ei kanpi, eim puku sim. Pe wumb eim kin tep to mulnjung wumb, puku sinjing ku. ");
INSERT INTO nii_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sependii nge kingam tał, Jeims kin Jon tał ei Saimon kin tep to andiłmin, wu tał yi ku puku sinjngił. Pe Jiisas ek nipi Saimon ngum, “Nim mund mong tunerii! Ekii se wumb na ek piimin nik ongii ei nim wumb pei nik tuk sikin, na ek ni wumb ngunjii ei omu yi mił, wumb yi mił tuk ongii.” ");
INSERT INTO nii_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Omu tołmun wumb ei noł kanu noł wer ełe tu wunjung. Tu wangin kin, en enim epi kanim kanim pei si kindik Jiisas kin ekii sinjing. ");
INSERT INTO nii_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Eim konu owundu ełe multum konu ełe, nga wu endi multum. Multum wu ei, eim ngenj kinj owundu tum. Eim Jiisas kanpi, opu Jiisas simb ełe mani mołpu prei erpi yi nirim. “Owundu, nim noman ełe erim kin kapłi, nim na er ka enjii,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jiisas eim angił ei kinj tum wu embiłmbii ni erpi ek yi nim. “Na noman ełe nim ka mulnjii,” pa nirim. Neng kin, kunum ełe mendpił Jiisas kinj tum wu ei er ka erim. ");
INSERT INTO nii_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nga Jiisas ek dinga nipi eim ngopu yi nim, “Nim wu endi ek ninenjii mon! Nim ngenj sipkin Gos kułmał wu ei andan tunjii. Tan kin, ngenj ka sałim ni piingii nikin kułmał kelnjii ei Moses lo ek ełe pałim mił erang, wumb yi piingii nim ening ni poru nim ni piingii. Nim nga ek wumb ninenjii mon!” ");
INSERT INTO nii_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ba Jiisas oł erim ombu konu orung orung pei eim ek pang wumb pei piinjing. Piik kin, Jiisas mułum konu ełe onjung. Ok Jiisas ek ei piimin nik wumb kis pim ei tu wunjung kin er ka nge ermba. ");
INSERT INTO nii_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ba eim wumb mulenjing konu pupu kunum ei eim prei ełim. ");
INSERT INTO nii_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kunum endi eim wumb ei ek nipi ngopu multum kunum ei lo ek piiłmin wu kombur kin lo ek emb tołmun wu kombur mulk ku. Wumb ei Galilii mei orung orung kin Jura mei nin Jerusalem konu owundu ełe ni wumb ombu onjung. Owundu nge dinga Jiisas ngang, Jiisas ening pirim wumb ei er ka ermba nge om. ");
INSERT INTO nii_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wu kombur wu endi peł ełe pendik tu wuk. Wu ei embił poru, dinga pineririm wu, ei en enim nirik sipik Jiisas mułum konu ełe kumb ełe mandi pendngii sipik. ");
INSERT INTO nii_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ba konu ełe wu amb pei piki topu pirim. Nga wu ening pim wu ei nirik sipngii konu ełe tuk sineririm. Yi erang kin ngii andaring ełe sipik tonu ngii beł ełe ambił wuł ał kindik peł ełe pim wu mani Jiisas mułum konu ełe kun mani kindik. ");
INSERT INTO nii_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jiisas wu ombu pii gii pirim wu ei kanpi kin yi nirim, “Wu puł, nim oł kis ei kil ngum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wumb lo ek połmun wumb ni lo ek piiłmin wumb en enim noman nendii to piik yi kii sinjing. “Wu ei wu nii opu Gos kin ek ambiltim? Wu endi wumb oł kis ei kil ngunermba; ba Gos endeim minj yi ermba.” ");
INSERT INTO nii_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jiisas wumb ombu noman ełe piipi si kindim. Pe eim ek nipi orung kindpi, yi nirim, “Nimbił erang en enim noman ełe ek eipi eipi nik punmun? ");
INSERT INTO nii_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nipe ek endi enim noman ełe embin tonum? Na ninj ek ei embin tonum min? Na nim, ‘Oł kis ei si kindind!’ min ‘Na nim angkin pui!’ nind? Pe na oł endi eramb enim kanik keimi nik piingii. ");
INSERT INTO nii_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ba na enim piingii ni piind, na wu kingam noman dinga ya mei ełe sałim. Kapłi wumb oł kis kil ngumba, yi erang kin eim ek nipi wu endi embił dinga punerim ei nge er ka erim. Na nim kanip nind, ‘Nim angkin, peł sikin, ninim nge ngii konu ełe orung pui!’” nind. ");
INSERT INTO nii_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Yi erang, pe mendpił wu amb ningił ełe eim engim. Angpi peł sipi eim ngii konu ełe pupu Gos embe ambił tonu kindim. ");
INSERT INTO nii_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pe wumb pei Jiisas erim oł ei ka nik puku sik enjing. Ba wumb Gos embe ambił tonu kindik. En enim noman ełe piik nik minj endnjing. Yi mił ninjing, “Pe sin oł eipi minj endi kenjpin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ekii se Jiisas eim andłam andpi pupu, kenim ni wu endi ku takis siłim wu, ei eim ku takis ngii ełe mułum wu ei embe Liiwai. Jiisas ek nipi wu ei ngum, “Nim na onj konu ełe oi!” nim. ");
INSERT INTO nii_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pe eim angpi epi pei si kindpi Jiisas pum konu ełe ekii se pum. ");
INSERT INTO nii_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Liiwai eim ngii konu ełe kuni owundu endi erpi Jiisas ngum. Pe ku takis siłmin wumb pei kin, wumb eipi pei kułou tok wu tał kin kuni ei nunjung. ");
INSERT INTO nii_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pe lo ek ekii siłmin wumb ni, peng lo ek mon połmun wumb ni wumb ok Jiisas nge ekii siłmin wumb mulnjung konu ełe noman kis piik mulk kii sinjing. “Nimbił erang enim ku takis siłmin wumb kin nga oł kis ełmin wumb kin enim kuni ende nonmun?” ");
INSERT INTO nii_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jiisas ek nipi wumb ngopu yi nim. “Enim wumb ening endi pinałim wumb ei, ond mong ngopu ełim wu kin punałmin min, ba ening pim wumb ei minj ond mong ngopu ełim wu pangin kin ond mong ngołum. ");
INSERT INTO nii_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na wumb oł kis er mołmun wumb ei oł kis kil ngop sip orung simbii nge onj. Ba wumb kun ka mołmun ni piinjing wumb, ei kin na onenj,” pa nim. “Nimbił erang na nga wumb oł kis enjing ei kin ngii konu pup onermbii ku?” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pe wumb kombur ek nik Jiisas ngok yi ninjing, “Jon nge ekii siłmin wumb kuni mowii ełmin. Erik, Gos prei kunum kunum ełmin. Lo ek ekii siłmin wumb nge ekii siłmin wumb ombu yi ku ełmin. Ba nim nge ekii siłmin wumb kuni nok yi ełmin. Ei nimbił erang ełmin?” ");
INSERT INTO nii_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jiisas ek nipi wu ombu ngum, “Enim wu endi amb simba ełim kunum ei kapłi ei wumb puł kuni mowii erngii min? Ei mon! ");
INSERT INTO nii_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ba ekii se opu wumb wu amb simba er mołum wu ei si tor singii kunum ei eim kan se nołum kin tep to mulermba kunum ełe kuni mowii erngii.” ");
INSERT INTO nii_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jiisas ek ekin endi nipi ei nge wumb noman konj kin wumb noman ok nge ende punermba ek ei wumb ngum. Eim yi nim, “Wu endi konduk konj ei kiłip to kembis kembis erpi, aninga konj endi sipi konduk ok nge ełe mui tumba. Pe wu endi yi ermba ei eim konduk konj er kis mondpu ermba ei, konduk konj ei kanim eipi mił pimba. Nga konduk ok nge kanim eipi mił pimba ku. ");
INSERT INTO nii_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Pe wu endi kung meme ngenj ming, mił ok nge ełe noł wain konj tuk kindnałmin. Ei mon! Wu endi yi mił ermbii ni ermba wu ei eim kung meme ngenj ming mił ok nge tok neng, noł wain konj ei tor pułum. Nga kung meme ngenj ming mił nge ei kis mołułum ku. ");
INSERT INTO nii_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ba wu endi noł wain konj kułpu kung meme ngenj ming mił konj ełe tuk kindmba. ");
INSERT INTO nii_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pe wu endi eim noł wain ok nge nołum, ‘Ei noł wain ka wii,’ pa nim. Eim noł wain konj singin ka pinałim.” ");
INSERT INTO nii_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kor kunum Jiisas eim tuk kuni mong wiis pałiłim konu ełe andpi mułum. Jiisas nge ekii siłmin wumb ombu ok kuni wiis mong ei sik ambił winin tok nuk. ");
INSERT INTO nii_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ba lo ek ekii sinjing wu ombu yi ninjing, “Gos kor kunum, ei kongun mon niłmin kunum ei, ba enim nimbił erang enmin?” ");
INSERT INTO nii_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jiisas ek ni orung kindpi yi nirim, “Enim king Deipis sin kupenjpin eim epi erim mił enim piinarik na ek yi nind. Kunum ei eim kin eim wumb kin kuni kulnjung. ");
INSERT INTO nii_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Deipis eim Gos ngii owundu ełe nirik pupu, bres Gos nge kumb ełe sim bres ei sim. Pe bres ei wumb pei nunerngii mon nik, Gos kin kułmał kałmin wumb minj ambił nungii niłmin. Ba Deipis eim bres nopu nga eim nge wumb ei bres ngang nunjung ku. Ek ei enim gerik piinjing min?” Ei kii sipi nim, “Nimbił erang enim King Deipis kin ek ninanmin, ba na sin kin ek ninmin?” ");
INSERT INTO nii_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jiisas ek dinga nga nipi yi nim, “Gos kindang mei ełe na wu kingam moł. Mołup, kor kunum owundu moł.” ");
INSERT INTO nii_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pe nga kor kunum endi eim pupu men ngii ełe pupu Gos ek nipi wumb ngum. Kunum ei wu endi mułum wu ei angił tundung orung miyem poru nim. ");
INSERT INTO nii_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lo ek emb tołmun wumb kin lo ek ekii siłmin wumb kin ei Jiisas ermba oł ei kenmin nik kui er mulnjung. Molk kin, yi piinjing ni kor kunum wumb endi kis pimba er ka ermba ni kanik mulnjung. Molk kin, Jiisas kos er ngumun nik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ba Jiisas eim wumb noman tuk ełe piinim. Piipi kin, wu angił miyem poru nim wu ni, “Angkin Oi!” Neng, wu ni sikir opu wumb mulnjung konu tuk engim. ");
INSERT INTO nii_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pe Jiisas eim ek nipi wumb ngum, “Na pe enim kii simbii end. Sinim lo ek nipi kunum oł ka ermin min oł kis ermin, ei ninim min? Wumb kin paki topu er ka ermin, min wumb topu er kis ermin?” a nim. ");
INSERT INTO nii_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jiisas wumb mulnjung konu tuk kanpi andpi, wu endi angił miyem poru nim ei kan sipi nim. “Nim angił tun kindii!” Yi neng kin, wu ei yi erang eim angił ni ka erim. ");
INSERT INTO nii_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ba wumb en enim noman kis dinga piinjing. En enim ek nik piik piik enjing. Erik, en enim yi ninjing, “Jiisas kin nimbił oł ermin,” ninjing. ");
INSERT INTO nii_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kunum ei Jiisas eim prei ermbii ni piipi komung endi ełe tonu purum. Eim prei erpi Gos ngurum kunum ei eim prei er mułang kin, konu tengrim. ");
INSERT INTO nii_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tengmba erang kin, Jiisas ekii sinjing wumb wangin nim. Neng, wangin wu engki nga tał sipi wumb embe ‘Ek se andiłmin wumb’ pa yi nirim. ");
INSERT INTO nii_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Wu embe endi Saimon, Jiisas embe Piisa ni ngum. Nga endi Endru ei Saimon nge angim. Embe nga Jeims kin Jon teł, Pilip ni Barsolomu. ");
INSERT INTO nii_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Pe Masyu ni Tomas ni Jeims Alpiyas nge kingam Saimon wu ei lo ekii siłim wu. ");
INSERT INTO nii_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Pe Jeims nge kingam Juras nin nga Juras Eskeriyas konu wu eim Jiisas opu orung wumb mulnjung konu ni peni ełe kindmba. ");
INSERT INTO nii_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pe Jiisas wumb ei kin mani punjung. Nga puk konu kun sim konu eim nge ekii siłmin wumb kin pei tep to engnjing. Pe wumb pei Jura mei konu ełe orung orung ni Jerusalem konu owundu ełe ep noł wer ełe konu ełe Taiya konu ni Sairon konu ni wumb pei ok mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Wumb ei ok eim ek piimin nik onjung. Pe eim wumb ening pim wumb ombu er ka erpi, wumb gui kis tuk mułang onjung wumb ei Jiisas wumb ombu er ka erim. ");
INSERT INTO nii_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wumb pei angił Jiisas embiłngii enjing. Nimbił erang Jiisas dinga pupu wumb pei, wumb ening pim wumb ei Jiisas er ka eririm. ");
INSERT INTO nii_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jiisas eim nge ekii siłmin wumb ombu kanpi ek yi nim, “Enim wumb wii epi sinerang mołmun wumb ei, ka piyei! Gos sinim tep er kanpi mołum oł ei enim nge sałim. ");
INSERT INTO nii_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Enim kumb kuni pałmin, enim ka piyei! Ekii se enim noman ka piik mułngii. Pe enim wumb ke ninmin, ei enim ka piyei! Ekii se enim tokuł erngii. ");
INSERT INTO nii_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Ekii se wumb enim wu kingam ei kin ekii se punmun ei keningii. Kanik kin, wumb en enim noman kis peng piingii. Piik kin, enim kon si kindngii ni, enim kin ek kis ningii ni, enim embe sik epi kis mił ombu nge singii kunum ei, enim ka piingii. ");
INSERT INTO nii_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Pe wumb enim kin yi erik ninjing kin enim ka piik noman ka seng mułngii. Enim piingii, epin konu ełe enim kumep singii ei owundu sałim. Kumb okrii enim kupenjing noł oł ei, Gos nge ek ni tor kindiłmin wumb kin yi ku ełmin. Yi mił ku enim kumep ka singii. Ei Gos nge ek ni tor kindiłmin wumb kin tep to singii. ");
INSERT INTO nii_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ba enim kom ku ngenj ełe peng, enim noman ka piik er mułmun ei enim noman ka piik erngii. Erangin, oł ei er poru nik mołmun ei enim wumb ei kan kun er mułngii. ");
INSERT INTO nii_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Enim wumb epi pei kanim kanim sinjing kin enim noman ka simba. Ekii se enim epi sinerang kin kuni kułngii. Enim wumb pe tokuł er ka piinmin wumb ei kan kun er mułngii. Ekii se enim ke nengin ningił ka mani omba. ");
INSERT INTO nii_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Pe enim wumb pei enim embe ambił tonu kindik ninjing kin enim pii kun er mułngii. Ok en enim kupenjing noł ek kend tok, ek ni tor kindiłmin kend wumb embe ambił tonu kindik ełmin oł yi erngii ei kanik mułngii,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Ba enim na ek piik mołmun wumb ei, na ek nind ei piyei! Enim opu orung wumb mułngii, ei kapłi noman ka ngok mułngii. Pe wumb enim noman kis piingii, ei enim wumb ei kin epi ka erngii. ");
INSERT INTO nii_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wumb enim kin ek bultung ningii ei, enim kengip ek ka nik wumb ombu noman ka ngungii. Nga wumb enim kin oł kis erngii wumb ei, enim Gos kin prei erik paki tungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wu endi nim kon taki tum kin, nga orung ak tan orung tumba ku. Wu endi nim kon takis ei simbii nipi erim kin, nim konduk ei kin ouni mon ninenjii ku. ");
INSERT INTO nii_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Wu endi epi endi kii sipi nim kin, nimba epi ei ngui! Pe wu endi nim epi wii sipim kin, nim nga orung tu wii nikin, ek dinga ninerii! ");
INSERT INTO nii_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Enim ermin ni piingii oł ei, wumb enim kin enjing kin, nga enim wumb ombu kin oł yi ku erngii. ");
INSERT INTO nii_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Wumb enim kin noman ngołmun wumb ei, nga enim noman ngangin enim nipe noman piingii? Pe wumb oł kis enmin wumb ei, wumb kombur noman ka piik ngołmun ku. ");
INSERT INTO nii_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pe enim wumb kombur oł ka er ngangin kin, nga wumb enim kin oł ka er ngungii. Nga ei enim nipe noman piingii? Wumb noman kis piik oł kis ełmin wumb ei kombur oł ka yi mił ełmin. ");
INSERT INTO nii_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Enim epi kombur wumb ngunjung kin, nga orung simin ningii ei enim noman nipe noman piingii? Wumb oł kis ełmin wumb oł ka erik wumb eipi ngołmun ku. Pe wumb ombu epi ende mił siłmin. ");
INSERT INTO nii_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ba enim opu erii wumb ei noman ka ngok, enim oł ka erik wumb ngungii. Enim wumb ngungii epi ei nga ngok orung kindmin ni piinerei! Enim oł ei erik epi ka wii owundu singii. Enim ełe yi erik molk punjung kin enim Gos kingam noł mendpił mułngii. Wumb Gos kin noman ka piinałmin ei Gos wumb ombu kin noman ka ngołum. Ngopu kin, wumb kis kin noman ka ngołum. Ngopu, wumb kis kin ouni ngołum. ");
INSERT INTO nii_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Enim wumb eipi kaimb singii, ei enim Ernjing Gos kaimb siłim mił ku singii. ");
INSERT INTO nii_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Enim wu endi ek ei nge nik mok tołum wu oł ei mił enerngii. Enim wumb oł kis ei si kindangin kin, Gos enim oł kis ei kil ngumba ku. Pe nga enim epi endi mok tołum wu er kun ełim mił enerngii. Yi mił enjing kin Gos enim epi embin tui ei mok tumba. Wumb oł kis ei ni ka enjing kin enim oł kis ei Gos kil ngumba ku. ");
INSERT INTO nii_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pe enim oł kanim kanim yi erngii mił yi ku Gos enim kin yi ermba. Pe wumb enim kin pimba mił ngungii ei, pei ngungii. Ei ngok pangin piki topu bein tumba ermba, ei enim ngungii. Pe enim epi wumb ngungii yi mił ku Gos enim ngumba. ");
INSERT INTO nii_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jiisas ek ekin endi nipi wumb ngum ku. Ei yi nim, “Wu ningił tumbun mołum wu ei, nga wu endi ningił tumbun mułmba wu ei, andłam andan top simba min? Ei mon! Wu tał ouni tukpu ełe bok tunguł. ");
INSERT INTO nii_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Mon kangił ei ek mon wu ek nipi ngołum wu ei to mani kindnermba. Eim mon kanpi poru nimba ei kapłi eim ek mon wu mił mułmba. ");
INSERT INTO nii_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Enim wumb eipi kanik oł kun pinermba mił ermba ei ni kun enerngii mon! Ei nimbił erang ninim oł yi nge ełin ku? Nimbił erang nim angnim ningił ełe epi moł pałim ei kankin nin? Ba ninim epi moł owundu endi ningił ełe pałim ei piin min? ");
INSERT INTO nii_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nimbił erang nim angnim ek nin? ‘Angnan, nim ningił ełe epi moł endi pałim, na si kindmbii,’ nin. Ba ninim ningił ełe epi owundu pałim ei ninim piinan min? Nim ek kend wu, nim epi owundu endi ninim ningił ełe pałim ei si kindkin, ekii se ninim angnim ningił ełe kun kankin epi moł pimba ei kapłi si kindnjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ond ka ei, mong kis tunałim. Yi ku ond kis ei nga mong ka tunałim. ");
INSERT INTO nii_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wumb en enim ond angłim ei kanik piiłmin. Piik kin, ond ei ond ka min mon, ni kaniłmin. Wumb en enim ond pik ei gał mołpu mong tołum ei tingnałmin. Nga ond wain yi ku, ond wain ei ond kembis angpi gał mołpu mong tołum ei tingnałmin mon. ");
INSERT INTO nii_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Wu endi eim noman ka pałiłim wu ei oł ka ełim ku. Erpi, oł ka wii ełim. Nga wu kis ei eim noman kis piki topu peng, eim oł kis ełim. Noman ełe oł yi mił pałiłim ei gupu ełe tor ołum.” ");
INSERT INTO nii_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Nimbił erang enim na ‘Owundu, Owundu’ niłmin, ba na ek nind ek ei enim piinanmin? ");
INSERT INTO nii_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wu endi na kin opu na ek piipi ermba wu ei na eim kanip moł. Mołup, eim ermba oł ei andan tamb enim piingii. ");
INSERT INTO nii_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Wu ei yi mił, wu endi ngii tekmbii ni tukpu sipi mer mani pupu, mei ełe ku owundu pei kindpi siimen ełim. Ekii se ngii tonu ełe takiłim, noł owundu topu ngii ei nirik omba, ba kapłi onermba. Nimbił erang wu ei eim ngii dinga wii tekim. ");
INSERT INTO nii_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ba wu endi na ek piipi nga ekii sinermba wu ei yi mił wu endi ngii tonu mei peł ełe tekim. Eim mei mani ei ku dinga kindnarpi siimen enerim. Ekii se noł owundu topu, noł ngii ełe nirik wang kin, ngii sikir er kis mułum. Nimbił erang wu ei ngii mił dinga pinerim. ");
INSERT INTO nii_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jiisas ek ei nipi wumb ngopu poru nipi, ekii se eim Kapaniyam konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rom wu endi opu ełmin wumb 100 pei opu ełmin wumb pei tep ełim, wu ei kongun wu endi mułum. Opu tep ełim wu eim kongun wu eim noman ka ngołum wu ni ening peng erang kułmba mandi erim. ");
INSERT INTO nii_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Opu tep ełim wu ei eim Jiisas kin ek ei piipi mułum. Pe eim Jura wu num kombur kindang puk ek nengin kin, Jiisas opu, na kongun wu ei er ka ermba nipi kindim. ");
INSERT INTO nii_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Wumb puk Jiisas multum konu ełe tor puk ek dinga nik, Jiisas nik yi ninjing, “Wu ei wu ka nim wu ei paki tunjii min? ");
INSERT INTO nii_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eim sinim Jura wumb kin noman ka ngołum. Eim mendpił men ngii ei takpi sinim ngurum.” ");
INSERT INTO nii_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pe Jiisas wu ombu kin tep to purum. Jiisas opu, opu tep ełim wu eim ngii konu mandi pang kin, opu wu 100 tep ełim wu ni wu puł kombur kindang puk Jiisas kin ek ningii nge puk. Puk yi nik, opu tep ełim wu ni yi nim, “Jiisas, nim wu Owundu! Nim na ngii konu ombii nikin okun kis piinjii; na wu ka mon. Nim na ngii nirik onerii!” yi ninim pa nik. ");
INSERT INTO nii_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","“Pe yi ku, na wu ka pim kin, nim ngii konu ełe na ombii min, ei mon. Ba nim ek ei nen na kongun wu ei ka mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","“Nimbił erang, na yi ku wu num kombur kongun ngokuł ełmin oł ei na kongun er moł. Pe na nge opu wumb ei na ek piiłmin. Pe wu endi ‘Pui’ nimbii, ei kapłi ba. Nga wu endi ya ‘Oiyo!’ nimbii, ei kapłi omba. Pe nam kongun wu, ‘Nim oł ei erii!’ nimbii, ei kapłi ermba. Na nge wu num ombu kongun ei na ngunjung mił na yi end. Ba nim noman dinga peng ening ei nge er ka ełin ei kapłi nim na nge kongun wu ening ei kapłi er ka enjii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Pe Jiisas ek ei piipi, eim wu ei noman ka jiłi sim ni piim. Pe eim ak topu wumb eim orung konu ekii se ok ei kanpi yi nirim. “Na enim kanip nind, Esrel wumb pei mołmun konu ełe wu endi noman ka peng, pii gii yi mił peng na kinenj mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Opu ełmin wumb tep ełim wu, wu puł kombur kindang ok wu ni nga orung puk kenik ni, kongun wu kułmba erim ni nga konj multum. ");
INSERT INTO nii_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ekii se nga Jiisas eim konu owundu endi purum konu ei embe Nein. Jiisas eim nge ekii sinjing wumb kin, wumb pei eim purum konu puk. ");
INSERT INTO nii_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Eim pupu konu owundu ełe andłam ondu pałim ełe mandi pang, wu endi kultum wu ni tu wuk wu kultum ei, mam eim kingam endeim mendpił mułum ei, kułang kui tunjung nge ei tu wuk. Tu wangin kin, amb ei wam kumb ok kultum. Pe wumb konu ełe wumb pei amb ei kin ouni ok. ");
INSERT INTO nii_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jiisas Owundu amb ei kanpi, kaimb piipi yi nirim. “Amb, nim ke ninerii mon!” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Pe eim mandi pupu, wu kułii pirim konu ełe eim peł ełe embiltim. Pe wumb wu tu wuk wumb ei angik mulk. Pe Jiisas nipi yi nirim, “Kangi wu, kanpi nind, nim engnjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Pe nga kultum wu ei tonu mułum. Mołpu, ek nipi multum. Mułang kin, Jiisas wu ei sipi mam eim ngurum. ");
INSERT INTO nii_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Yi erang kin, wumb pei mund mong tok, Gos embe ambilk tonu kindnjing. Wumb yi ninjing, “Gos ek nipi oł ekii se ermba wu owundu sinim konu ełe tuk onum,” ninjing. Wumb ek nga yi ninjing, “Gos eim opu eim wumb si orung simba nge opu wumb paki topu enim,” ninjing. ");
INSERT INTO nii_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jiisas erim oł ei pang kin, wumb Jura mei konu ni wumb konu orung orung pei piik punjung. ");
INSERT INTO nii_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jon nge ekii sinjing wumb ei epi pei ek nik eim ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jon eim ekii sinjngił wu tał wii tum. Eim yi nim, “Ełip pukuł Owundu kankił yi kii singił,” pa nim. “Ok Gos wu endi kindmbii neng, sin kui er mulnjpun wu ei nim min? Min sin nga wu endi omba ni kui ermin min?” ");
INSERT INTO nii_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wu tał Jiisas kin okuł ek yi ninjngił. “Jon noł sipi wumb noł pendiłim wu, ei sił nim kin peł neng onmbuł ninjngił. Nikił yi ninjngił, ‘Ok Gos wu endi kindmbii neng sin wu endi omba ni kui enjpin wu, ei nim wałim min?’” ");
INSERT INTO nii_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kunum ei Jiisas wumb ening kanim kanim pirim wumb kin, wumb ening kis pirim wumb ni, wumb gui kis tok multum wumb ei pei er ka erim. Pe wumb pei ningił tumbun multum ei pei er ka eririm ku. ");
INSERT INTO nii_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Pe Jiisas ek nipi wu tał ngopu yi nirim, “Ełip pe pukuł Jon konu ełe kankił, na ya pe nipe oł erip ek nipe ek nip eramb ełip piikił, kankił enmbił ei pukuł, Jon kan ningił peł nim. Wumb ningił kis mułum wumb ei, kenjing. Simb kis mułum wumb, nga ka seng andłam endnjing. Wumb kinj tum wumb ei, ka sim. Wumb kom ngum wumb ei ek piingii neng ek piinjing. Pe wumb kulnjung wumb ei nga ok tonu konj mołmun. Wumb epi endi sinałim wumb ei Gos ek ka ngang piki tołum. ");
INSERT INTO nii_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Wumb na Jiisas kin pii gii ninjing, en enim pii gii ei mani punerim, wumb ei ka piingii. ");
INSERT INTO nii_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon ek ni kindang onjnguł wu tał nga orung pangił; Jiisas Jon nge ek nipi wumb pei ngopu yi nim. “Ok, enim Jon mułum konu ełe wumb mulenjing konu ełe puk epi nipe endi kenjing? Min enim puk konu pop tang goł kembis ei kenjing min mon? Wu ei goł mił mon? ");
INSERT INTO nii_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Enim epi nipe kengii nge punjung? Enim wu endi epi konduk ka wii erpi mułum ei keningii punjung min? Ei mon! Wumb konduk ka wii kindik, en enim ngenj ełe epi ka ełmin ei King ngii owundu ełe minj mołułmun. ");
INSERT INTO nii_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ba enim puk epi nipe keningii nge punjung? Enim puł wu endi Gos oł ekii se ermba ei nge nipi mułum wu ei kenjing min? Ei keimi; wu ei eim nge kongun ende ek ni tor kindiłim wu pei to mani kindiłim. ");
INSERT INTO nii_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wu ei mendpił Gos nge ek yi ninim, ‘Piini! Na ek se endmba wu endi kindmbii wu ei, na ek ok sipipi nim, kumb se pupu nim andłam ei to ka er sipi mułmba.’” ");
INSERT INTO nii_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jiisas ek yi nim, “Na ek keimi nip enim ngond, ‘Kunum ełe Jon ya mei ełe wumb pei ei kamb mani kind poru ninim. Ba akip kunum ełe wu endi Gos sinim tep er kanpi mołum oł ei wu wii mił pii gii nim kin, wu ei Jon to mani kindnim,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wumb ek ei piik poru nik, wu amb ni wumb ku takis siłmin wumb pei ek yi ninjing, “Gos eim kun ka wii mołum wumb ei Gos noman ełe ekii sengin ok Jon angił ełe wumb noł sipi wumb noł pendpi ngum.” ");
INSERT INTO nii_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ba lo ek piiłmin wumb kin, lo ek emb tołmun wumb ei Jon angił ełe noł pinenjing yi mił erik, Gos nge noman ełe wumb ei buł ngok kin, andłam andan tum ei si kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jiisas ek yi nirim, “Akip kunum ei na enim wumb ekii sinenjing mił wumb sip mondup ei nimbił oł erngii? Wumb ei jiłi wumb? ");
INSERT INTO nii_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pe wu ombu yi mił, kangił kembis kombur konu endi tuk ełe molk, kangił kembis kombur eipi kin wii tunjung. Tok yi ninjing, ‘Sin mingał kepii tonmun nimbił erang enim golang ninanmin?’ a ninjing. ‘Pe nga sin golang kaimb er ninmin ei enim ke ninanmin. Ei yi mił en enim noman endi pinałim eipi eipi punum.’ ");
INSERT INTO nii_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon sinim noł pendpi ngołum wu ei tonu om. Eim opu noł wain ni bres ei endi nunerim. Pe enim wumb yi ninjing, ‘Wu ei gui kis tuk mołum,’ ninjing. Ei mon!” ");
INSERT INTO nii_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pe na wu kingam op kuni nop, noł wain nop end. Pe enim wumb molk yi ninjing, ‘Wu ei kuni pei minj nołum,’ ninjing. ‘Wu ei noł wain pei minj nopu,’ yi ełim niłmin. Nik, ‘Eim wumb ku takis siłmin wumb kin wumb oł kis erik ełmin wumb ei kin puł pałim,’ pa niłmin. ");
INSERT INTO nii_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ba wumb noman ka pałiłim wumb, ei yi niłmin. ‘Gos nge noman ka ei epi ka wii niłmin.’” ");
INSERT INTO nii_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lo ek piiłim wu endi embe Saimon Jiisas kin ek nipi eim kin kuni numbuł nirim. Eim lo ek piiłim wu ei ngii konu ełe pupu kuni no multum. ");
INSERT INTO nii_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Amb endi oł kis ełim amb, konu owundu ełe mułum. Pe amb ei mołpu piim ni Jiisas pupu lo ek piiłim wu ngii konu ełe kuni nonum nik. Nengin, piipi kin amb ei eim kopung muru ka ming endi sipi om. ");
INSERT INTO nii_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Pe eim pupu Jiisas buł morung orung angpi, simb ełe mołup ke nipi mułum. Ke nim ningił ka ei, Jiisas simb ełe purum. Ei kanpi eim peng enjin olt sipi, Jiisas simb ełe kil ngum. Ngopu kin, Jiisas simb ełe kum su sipi er mułum. Mołpu kin, kopung muru ka ni sipi, Jiisas simb ełe kindrim. ");
INSERT INTO nii_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lo ek piiłim wu ei, Jiisas wii tang om wu ei, eim epi ei kanpi eim noman yi piim. “Wu ei, Gos oł ermba oł ei, keimi nipi ełim kin amb ei piipi mon. Amb ei, yi ełim nimba ni piim amb ei, amb oł kis ełim.” ");
INSERT INTO nii_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yi erang kin, Jiisas eim wu noman ełe, piinim ek nipi ngumbii ni piim. Piipi kin, Saimon kanpi neng, “Saimon,” yi nim. “Ek mon wu, nim ek ninjii pim ek ei ni!” a nim. ");
INSERT INTO nii_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Pe Jiisas ek yi nim “Wu tał, wu endi kin kom ku sikił, nga ekii se ngo orung kindmbił ni sikił, wu endi kom ku 100 pei mił sirim. Nga wu endi, kom ku kum endeim mendpił sirim. Wu tał kom ku yi mił si ngokuł, pendkił pirim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Wu tał epi endi ngo orung kindngił pinerang, wu ni kan wiik turum. Yi erang kin, wu tał eim kin noman ngunjnguł wu endi nii eim noman ka wii piipi eim ngumba?” ");
INSERT INTO nii_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon ek nipi, orung kindpi yi nim, “Na yi ni piind, wumb endi oł kis pei kil ngo si kindmba wumb ei,” pa nim. Neng kin, “Nim ek kun nin,” pa ni Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Pe eim ak topu amb ei kanpi kin, ek nipi Saimon ngum. “Nim ya amb ei kan min? Na nim ngii konu onj ei, nim noł kulkun, na simb ełe noł kindnen; ba amb ei na simb ełe, noł kindpi enim ei eim ke nim ke noł sipi na simb ełe noł kindnim. Pe eim peng enjin sipi, na simb ełe kil ngonum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","“Nim nam kin kum su sinen. Ba na tuk op mułamb, pe amb ei opu, na simb ełe kum su sipi enim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“Nim nam peng ełe kopung kindnen; ba amb ei eim kopung ka wii na simb ełe kindim.” ");
INSERT INTO nii_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yi mił peng kin, na nim kanip nind, “Eim na kin noman ka ngum. Ngopu kin, nim ei piinjii; eim nge oł kis ei pei ełim; ba na eim oł kis kil ngop poru nind, Gos wu endi kin oł kis aninga er kil ngum kin, wu ei Gos noman pei ngunałim; ba aninga ngołum.” ");
INSERT INTO nii_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jiisas ek nipi amb ei ngum, “Na nim nge oł kis ei si kindin.” ");
INSERT INTO nii_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Wumb eim kin peł ełe ende mulnjung wumb ei, en enim ek nik piik piik enjing. Nik ek dinga nik, “Wu ei nii, wumb oł kis ei kil ngonum?” ");
INSERT INTO nii_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jiisas ek nipi, amb ei ngopu yi nim, “Amb, ninim nge pii gii je erpi, nim si orung sinim. Pe nim pukun, noman emin ka peng mulnjii. ");
INSERT INTO nii_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pe nga Jiisas konu owundu ni konu kembis andpi Gos ek ka nipi wumb ngopu, Gos sinim tep er mołum mił ei nipi wumb ngum. Jiisas eim nge ekii siłmin wu engki nga tał eim kin andik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pe amb kombur ok, ening pim amb ombu ni, gui kis tuk mułum amb ombu, Jiisas er ka eririm. Amb ombu, Jiisas pum konu ełe punjung ku. Amb endi ‘Mariya’ niłmin, ei ‘Mariya Makandala,’ pa niłmin. Ok Jiisas eim amb ei, gui kis angił orung nga tał pei tor kindrim. ");
INSERT INTO nii_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Pe Jo Ana, Susa nge ambim wu ei King Eros ngii ełe tep er mołułum ei, eim embe Susana. Pe Susana ni amb pei onjung ku. Amb ombu puk, Jiisas kin, Jiisas nge ekii siłmin wu ombu, kom ku paki tok ełmin amb ombu, ouni puk ku. ");
INSERT INTO nii_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wumb tiłap owundu endi ok, kułou tunjung wumb ei, konu owundu eipi eipi wumb pei Jiisas mułum konu ełe onjung. Wangin kin, Jiisas ek ekin endi topu nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wu endi kuni wiis emb sipipi emb kindrim ei kombur wumb andłam endik konu ełe mani pang, wumb kimbangin, kei ok nok nok enjing. ");
INSERT INTO nii_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Pe kuni wiis emb kombur pupu, mei ku mułum konu ełe mani pum. Pe kuni wiis ei sikir tonu om, ba mei noł muł erang, kuni ei kułii erpi, kołpu poru nim. ");
INSERT INTO nii_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Pe kuni wiis kopur, pupu kan gał pim konu ełe mani pum konu ełe, kan gał mul ei tonu opu, kuni wiis ei to mani kindim. ");
INSERT INTO nii_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Pe kuni wiis emb kombur mei ka ełe mani pum ei sikir tonu om. Opu kin, kuni wiis pei topu mułum. Tum, ei 100 pei pei kuni wii yi tonu mułum.” Jiisas ek yi nipi ek dinga wii nim, “Wu endi kom pimba, wu ei kom sepi ek ei piyangłi!” ");
INSERT INTO nii_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jiisas eim nge ekii siłmin wumb ei, ek ekin topu ninim, “Ek ei, pułe piimin nik kii sinjing. ");
INSERT INTO nii_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Pe eim yi nim, “Gos sinim tep er mułum mił ei eim ek koi er pałim ek ei piipi kin nipi enim ngonum. Ba torung wumb eim ek ekin top nim ek ei mendpił piinjing, ba ek ekin ei pułe pii poł tunenjing. Tunarik kin, en enim konu orung orung kind keningii, ba epi endi kinenjing. Pe nga ek ei pingii, ba pułe piinerngii mon!” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ek ekin tum ek pułe yi pałim. Kuni wiis mong ei Gos nge ek. ");
INSERT INTO nii_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pe kuni wiis kopur pupu andłam ełe mani pang kin, wumb andik kambinmin ei Gos ek wumb piinmin, ba nga Seisen opu Gos ek ka ei topu eipi kindnim. Eim yi piinim, wumb Gos kin pii gii nengin kin Gos sipi orung simba ni piipi enim. ");
INSERT INTO nii_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pe kuni wiis emb kombur pupu, mei ku mułum konu ełe mani pum, ba dumbuł mer mei ełe mandring punałim mon. Pułe yi mił wumb Gos ek piik sik, noman ełe kindik ka mołułmun. En enim pii gii dinga ninarik mułangin kin, epi embin tui endi tonu ołum ei, wumb en enim dinga mulałmin kin, bok tołmun. ");
INSERT INTO nii_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pe kuni mong kombur pupu, kan gał mułum konu puł ełe mani pum ei wumb Gos ek ka piik, nga kongun erik, ba mei ełe epi kanim kanim noman peng, kom ku ni epi ka wii ka ka piik, yi er mułangin kin Gos ek ei piinarik, to mani kindinmin. Yi erangin kin, en enim kongun ei tonu opu mong tunenim mon, ba mani pupu koltum. ");
INSERT INTO nii_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ba kuni wiis mong kombur, pupu mei ka ełe mani pum ei yi mił; wumb Gos ek piik, ambił gii nik mulnjung. Molk kin, en enim noman dinga peng, kongun kunum kunum yi erik mulnjung ei, kuni wiis mong pei tum mił yi er mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Wumb endi dup alam kałpi, ming ełe mani kind pendmba min? Dup alam kałip peł mandring pendmba, ei kapłi tiłang erip tor omba min? Ei mon! Dup alam kalk tonu peł ełe sengin kin, wumb kanik nirik puk anda ok yi erngii. ");
INSERT INTO nii_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Epi pei nim kinan koi er sałim ei, ekii se kenjii wumb nii oł pei koi er pendmba ei ekii se, wumb eim pii poł tungii. ");
INSERT INTO nii_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Enim kan kun er molk, ek ka piik erngii. Wu endi eim noman dinga peng, eim piipi kun er mołpu pii gii nipi mułmba, wu ei Gos nga eim dinga ngumba. Nga wu endi eim noman ka ni oł kun ka ombu piipi kun enarpi mułmba wu ei, Gos wu ei noman ka ni oł kun aninga pimba ei Gos sipi orung sipi si kindmba. ");
INSERT INTO nii_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kunum ełe Jiisas nge mam ni angim noł ok, ba wumb konu ełe piki topu peng kin, wumb ei mulk konu tuk ongii konu endi sineririm. ");
INSERT INTO nii_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wumb kombur molk yi nik, “Jiisas nim nge wumb, manim ni angnim noł ok, nim kenmin nik anda mołmun,” pa nik. ");
INSERT INTO nii_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ba Jiisas ek nipi orung kindpi yi nirim, “Wumb Gos ek ka ei piik, ekii singii wumb ei, na nge engnan noł ni, minan noł mułngii,” nirim. ");
INSERT INTO nii_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kunum ełe Jiisas kin eim ekii siłmin wumb, noł kanu endi ełe puk. Pe Jiisas ek yi nirim, “Sinim noł gop mołum konu ełe orundung pamin!” nirim. Neng, noł tuk ełe puk. ");
INSERT INTO nii_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Pe noł kanu sikir pang kin, Jiisas eim or pirim. Konu pop owundu endi noł gop ełe pop owundu endi turum. Topu, noł mer kanu ełe tuk pang, wumb kułngii kunum mandi eririm. ");
INSERT INTO nii_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pe wumb en enim puku sik andik Jiisas or pirim konu ełe to konj kindik yi nik, “Owundu! Owundu! Sinim kułmun pałim,” pa nik. Pe Jiisas eim angpi konu pop owundu ei kin, noł topu tonu omba eririm ei ek dinga nipi ngurum. Ngang kin, konu pop kin noł owundu tumba eririm ei wii sirim. Noł ołup enerim, wii pim. ");
INSERT INTO nii_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Pe Jiisas eim ek nipi, eim ekii siłmin wumb ngum, “Enim pii gii ei konu jiłi pum?” Yi neng kin eim ekii siłmin wumb en enim mund mong tok noman embin tang mołmun. Molk kin, yi nik, “Wu ei nii? Eim ek nipi konu pop kin noł ei ek neng, eim ek ei piinmbił!” ");
INSERT INTO nii_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ekii se Gerasiin konu ełe tor punjung. Galilii konu noł gop ełe orundung sipim konu ei, orung sim. ");
INSERT INTO nii_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jiisas eim noł kanu si kindpi tor pum. Pang kin, konu ełe wu endi eim mułum konu ełe tor om. Wu ei gui kis kombur eim kin mułum. Wu ei kumb ok eim alap pandi topu tilałim mon! Eim ngii endi pinałiłim mon ku. Eim pupu wumb guimeng ełe pu pałiłim. ");
INSERT INTO nii_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wu ei Jiisas kanpi, eim ek dinga nipi wii tum. Topu kin, Jiisas simb ełe mani pupu pim. Pepi ek nipi, wii dinga topu yi nim, “Jiisas, nim Gos Owundu mendpił kingam. Sinim kongun ende enałmin mon. Nim na kin nimbił oł enjii on? Na nim kin prei ermbii, ei nim na ngenj kumbii ngunenjii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Gui kis ei ek yi nim. Nimbił erang Jiisas eim ek dinga nipi wu ei kin si kind kin tor punjii nim. Eim ek nim mił erim. Kunum kunum gui kis ei, wu ei kin mołułum. Pe wumb wu ei ambił gii nik, kan tok angił ełe, kan tok er pendiłmin ei, wu eim to kiłip tołum. Pe gui kis ei yi erpi mił wu ei si mengpi wumb mulałmin konu ełe si pang, eim mołum. ");
INSERT INTO nii_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jiisas wu ei gui kis mułum wu, ni ek nga ngopu kii sim, “Nim embe nii?” Pe eim yi nim, “Na embe, ‘opu ond wumb,’” nimbił erang, gui kis pei eim kin pei mołułmun. ");
INSERT INTO nii_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pe gui kis ombu wii dinga tok yi ninjing, “Jiisas nim sin konu kis ełe kindnenjii!” ");
INSERT INTO nii_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kung tiłap pei konu komung endi ełe mandi kuni nok er mołmun. Yi nik kin, gui kis ombu Jiisas kin wii tok ek dinga ninjing, “Nim kapłi sin kung ombu kin pei! Neng kin, bin,” ninjing. Pe Jiisas wak tang, punjung. ");
INSERT INTO nii_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gui kis ombu wu ei si kindik, kung mulnjung konu ełe tuk punjung. Pe kung ombu andłam dinga sikirik puk konu kis endi ełe punjung. Punjung, konu ei noł gop ełe tuk puk noł nok kulnjung. ");
INSERT INTO nii_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kung es tok mulnjung wumb ei, oł ei kanik tungu erik punjung. Puk kin, konu kembis ni konu owundu sim konu wumb kanik ninjing. ");
INSERT INTO nii_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pe wumb pei puk, erim oł ei kenmin ni punjung. Puk kin, kenjing ni Jiisas kin wu gui kis mułum wu ei kin, mulnjunguł ei kenjing. Wu ei gui kis pei eim si kind pangin, eim alap tałpi mułum kenjing. Pe eim noman ka peng, eim Jiisas mułum konu ełe simb ełe mani mułum. Wumb pei onjung wumb ei kanik mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kung es tołmun wumb ei ok kanik puk, wumb ei Jiisas wu ei kin erim oł ei ek poł tok er mulnjung. Ok eim gui kis eim kin mułang, Jiisas opu gui kis topu tor kindang, wu ei er ka erim. ");
INSERT INTO nii_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerasiin konu ełe wumb pei onjung. Wumb ei ek nik Jiisas ngunjung, “Nim, sin konu ełe si kindkin pui!” pa ninjing. Wumb en enim mund mong erik ninjing. Nga Jiisas eim noł kanu endi ełe tonu pupu, orung bii ni pum. ");
INSERT INTO nii_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Gui kis wu ei si kind punjung wu ei eim prei erpi yi nim, “Jiisas, na nim kin tep to bii,” pa nim. Ba Jiisas wu ei, “Orung pui!” nipi yi nim. “Ni ninim ngii konu ełe orung pukun, Gos owundu nim kin nimbił oł erim, ei nikin wumb ngunjii,” pa nim. Yi neng kin, wu ni orung pupu wumb konu owundu ełe pupu Jiisas eim kin nimbił oł erim ei nipi wumb pei nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pe Jiisas noł gop nga orung wang kin, wumb pei ka piinjing. Nimbił erang wumb Jiisas orung omba ni piik kui er mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Pe wu endi om wu ei embe Jairas. Wu ei eim wu num endi, eim Jura wumb men ngii tep erpi mołułum. Wu ei Jiisas simb ełe mandi mani pupu, prei erpi ek dinga nim. “Nim na ngii konu ełe onjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Wu ei eim ambiłam endeim mendpił multum ambił ei kung ngii engki nga tał multum. Multum, ambił ei kułmba mandi erim. Pe Jiisas Jairas ngii konu ełe bii nipi andłam ełe pang kin, wumb pei eim pum konu ełe ambił gii nik punjung. ");
INSERT INTO nii_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pe amb endi mułum amb ei eim kung ngii engki nga tał, ei pei eim miyem o tor minj pupu mułum. Pe wumb endi eim miyem o tor pum, ei er ka erngii wumb endi mulenjing mon. ");
INSERT INTO nii_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pe amb ei Jiisas mułum konu ełe mandi om. Opu, eim Jiisas kon takis ełe minjin tamb kin, “Nam nge miyem tor pum ei kep ermba,” ni piim. Pe opu yi erang kin, sikir miyem tor pum ni kep erpi nga tor onerim mon, ka mułum. ");
INSERT INTO nii_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pe Jiisas ek yi nim, “Wumb nii na kon takis ei minjin tonum?” Pe wumb pei molk, “Na mon! Na mon!” pa ninjing. Piisa ek yi nim, “Owundu, wumb tiłap pei nim kin mołun konu ełe angik mołmun. Ei sin er kan poł tumun mił nenj?” ");
INSERT INTO nii_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ba Jiisas ek yi nim, “Wumb endi na minjin tang piinj. Piyamb kin, na dinga kombur tor pang piinj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nga amb erim amb ei koi ermba mił pinerim, Jiisas eim piim. Yi peng kin, amb ni opu, Jiisas mułum konu ełe mani mei ełe kan mani kanpi mułum. Mułang kin, wumb pei kumb ełe eim Jiisas kon takis minjin tang ek ei pułe nipi wumb pei mulnjung konu ni tor kindim. Kindpi yi nim, “Na oł ei eramb kin na ening ei sikir poru ninim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pe Jiisas ek nipi amb ei ngum, “Nim pii gii je ninim er ka enim, nim orung pukun, ninim noman emin ka seng punjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pe eim ek nipi mułang kin, wu endi om. Om wu ei Jairas wu num Jura men ngii tep ełim wu num ei ngii konu ełe wu ei mułpu om. Opu, yi nim, “Wu num! Nim ek mon wu owundu ei kongun dinga ngunenjii! Nim ambiłanim ok kułum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ba Jiisas ek ei piipi, ek dinga nipi orung kindim, “Nim mund mong tunenjii! Nim pii gii nen, ninim ambiłanim ei konj mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Pe Jiisas wu ei ngii konu ełe pum. Wumb punjung ei kan wiik tang nirik onerngii, mon nim. Jiisas kin Piisa ni Jon, Jeims ni eim arim mam tał mendpił nirik punjung. Wumb ei mendpił eim kin nirik punjung. ");
INSERT INTO nii_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Wumb pei en enim ambił ei nge nik ke dinga nik mulnjung. Jiisas opu ek nipi wumb ngopu yi nim, “Ambił, ei mendpił kulerim mon, ba eim or mił pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pe eim ek nim ei wumb kanik tokuł enjing. Nimbił erang, ambił eim kułum poru nim, wumb ei kanik tokuł enjing. ");
INSERT INTO nii_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ba Jiisas ambił ei angił ambiłpi, ek dinga nipi ngum, “Ambił kembis, nim engii!” a nim. ");
INSERT INTO nii_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pe ambił ei noman konj opu eim kin tuk wang, eim sikir engim. Engang kin, Jiisas yi nim, “Enim kuni endi ambił kembis ei ngei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pe ambił kembis ei arim mam tał puku sinjngił. Ba Jiisas ek dinga nipi wumb tał ngum, “Ełip wumb kankił na oł endi ei, kankił ninerngił mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Pe Jiisas eim nge er se endiłim wu engki nga tał wii tum. Wangin kin, eim noman dinga wu ombu ngopu kindang puk kin wumb gui kis to kindik, ening pimba wumb ei er ka erik, erngii pa nipi, eim nge noman dinga ngopu kindim. ");
INSERT INTO nii_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wu ombu kindang, puk wumb kanik Gos ek ka nik wumb ngok, nga Gos sinim tep er mołum ek ei nik, wumb ening pimba ei nengin wii mułngii pa nip kindang punjung. ");
INSERT INTO nii_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Pe eim ek nipi wu ombu ngum, “Enim andłam turii pungii pendik, siłmin epi ei sinerngii. Pe dolu ni, kon kembis ni kom ku ni, kuni bres ni, epi endi sipnerngii. Konduk tał er sipnerngii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","“Enim puk konu endi tuk puk, ngii endi mułngii ngii ełe minj mułngii. Molk kin, ek nik wumb ngok er molk poru nik. Nga ekii se enim ngii konu ełe pinjing konu ei si kindik pungii. ");
INSERT INTO nii_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pe nga enim konu eipi pangin wumb enim ngii konu ełe sipnarik enjing kin, enim konu ełe si kindik pungii. Puk kin, mer simb ełe mei kułman mułmba ei tami to kindik pungii. Yi erik pangin kin, wumb en enim enjing oł ei piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yi neng kin, wu ombu puk konu pei andik punjung. Puk kin, Gos ek ka ei nik wumb ngok, wumb ening pepi erim, ei er ka erik punjung. ");
INSERT INTO nii_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","King Eros eim mołpu Jiisas nge ek ombu pei piipi, eim noman embin to piim. Nimbił erang wumb kombur molk, “Jon wumb noł pendiłim wu mer tukpu ełe tonu onum,” ninjing. ");
INSERT INTO nii_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Pe wumb kombur yi ninjing, “Ok ek ni tor kindiłim wu endi Elainja tonu onum,” ninjing. Nga kombur, yi ninjing, “Ok Gos oł ekii se ermba oł ei piik niłmin wu ni nga endi onum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wumb yi nengin kin King Eros yi nim, “Na Jon peng ei kołmung enj, ba ek ei er piik ninmin mił nenj nipi opu kin, ‘Jiisas kenmbii,’” ni piim. ");
INSERT INTO nii_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jiisas nge ek se andiłmin wu orung ok, en enim erik oł ombu Jiisas kanik ek poł to nguk. Pe Jiisas wu eipi ombu si kindpi, en enim mendpił Beseira konu owundu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ekii se wumb eim ek ei piik, eim pum konu ełe ekii se punjung. Eim pum konu pangin kin, eim ka piim. Piipi, eim Gos sinim tep er mołum, ek ei nipi ngum. Ngopu, wumb ening pim wumb, ei er ka erim. ");
INSERT INTO nii_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ekii se pou neng, eim nge er se andiłmin wu engki nga tał, orung ok yi ninjing, “Nim wumb ombu kindan, en enim konu orung pungii. Puk kuni simba, kan sik nungii,” pa ninjing. “Ya konu ełe sinim mołmun, konu ei kuni sinałim mon. Nga wumb konu ełe mulałmin.” ");
INSERT INTO nii_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ba Jiisas ek yi nim, “Enim kuni endi wumb ei ngungii. Kuni endi sałim min?” Pe eim nge er se andiłim wumb ombu yi ninjing, “Sin kuni endi sinałim. Ba bres angił orung kin omu tał, ei mendpił sałim,” pa ninjing. “Pe sin pei kapłi pupun, wumb pei ombu nge kuni pei top ermin min?” ");
INSERT INTO nii_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wumb pei mulnjung wu ei 5,000 yi pei mulnjung. Jiisas eim nge er se andiłim wumb kanpi nim, “Enim wumb kułou konu eipi eipi wumb 50 mił to mundei!” pa neng yi enjing. ");
INSERT INTO nii_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jiisas nge er se andiłim wu ombu, eim nim mił yi enjing. Erangin kin, wumb pei mani mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jiisas eim bres angił orung ei sipi, omu tał ei sipi, ei epin konu ełe kanip, Gos kin prei erim. Erpi, bres engin topu, eim er se andiłim wu ombu ngum. Nga eim er se endim wumb sik, kuni mok tok wumb pei mulnjung wumb ei ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pe kuni ngunjung kuni ei, wumb pei nunjung. Pinang pang kin, kuni orung pei mułum ei sik gerenj kon engki nga tał to piki tunjung. ");
INSERT INTO nii_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kunum endi, Jiisas eim mendpił prei er mułum. Pe eim nge er se andiłim wumb ei eim kin ouni mulnjung. Mułangin kin, Jiisas ek nipi, wu ombu kii sim. “Wumb na nii, pa ninmin?” ");
INSERT INTO nii_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Wu ombu ek ni orung kindik yi ninjing, “Wumb kombur, nim Jon wumb noł pendiłim wu pa ninmin. Nga wumb kombur, nim wu Elainja pa ninmin. Nga wumb kombur yi ninmin, ‘Gos oł ekii se ermba ei, piipi niłim wu ok kultum, nga konj tonu onum, ninmin,’” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Pe Jiisas ek nipi, eim er se andiłim wu ombu ngopu yi nim, “Enim na nii pa ninmin?” Piisa ek nipi orung kindpi yi nim, “Nim Gos kindim wu Krais, mendpił mołun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pe Jiisas ek dinga nipi eim nge er se andiłim wu ombu ngum, “Enim wumb endeim, endeim kanik, ek ei ni tor kindnerngii, mon!” nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Pe eim ek yi nim, “Na Wu Kingam ei, ngenj kumbii kułmbii,” pa nim. Kułmał kałiłmin wumb owundu ni, lo ek połmun wumb pei, na kin buł ngungii. Ngok kin, na to kundngii. Kundangin kin, na mei konu ełe kunum tekliki pimbii. Pep, nga angip tonu ombii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jiisas ek nipi, eim nge er se andiłim wumb ngum, “Pe wu endi na kin ekii simbii ni piimba wu, ei eim noman ełe oł kanim kanim ermbii nipi piimba noman ei to mani kindpi, kunum kunum eim ngenj kumbii sipi, kongun dinga erpi, endmba ei yi mił eim ond peri ei kan sipi andpi, na ekii simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","“Wu endi eim noman ełe er endmba wu ei, eim noman konj am ba. Pe wu endi na nge noman piipi, eim noman ełe to kundmba ni erim, ei eim noman konj punermba; ba eim kunum kunum konj mułmba. ");
INSERT INTO nii_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pe wu endi eim, kongun owundu erpi, eim mei epi pei simba wu, ei eim noman konj am ba. Pang kin, mei ełe epi, ei opu, eim paki tumba mił nenj? Ei kapłi enanim. ");
INSERT INTO nii_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pe wu endi na ek ni tor kindnermba; eim na kin buł ngang piipi, yi ermba wu ei, na Gos kindang na mani op wu kingam moł; na wu ei kin buł ngop piimbii ku. Wu kingam eim nge tiłang owundu kin, eim nge arim Gos kin, Gos nge enjel ka wii ouni ongii kunum ei, eim kin yi ku erngii. ");
INSERT INTO nii_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Na ek keimi nip enim ngond, ‘Wu kombur ya ełe angiłmin wu ombu, ei kulerngii. Nga molk kin, Gos sinim tep er mołum ei nge noman dinga ei keningii.’” ");
INSERT INTO nii_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jiisas ek ei nipi, mułang kunum angił orung nga tekliki poru neng, eim Piisa, Jon ni Jeims sipi, eim prei ermba nge, komung endi ełe tonu punjung. ");
INSERT INTO nii_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eim prei er mułang kin, eim kumb ningił ei eipi mił kułum. Eim konduk ni kupu kuru mendpił mił tiłang erim. ");
INSERT INTO nii_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Pe wu tał eim kin tor okuł, ek tang mulnjung. Sin ok kupenjpin noł wu tał ei Moses kin Elainja teł kin ek tengnjing. ");
INSERT INTO nii_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Wu tał tiłang owundu erim konu tor okuł, Jiisas Jerusalem konu oł endi ermba ei nikił, nga Jiisas mei ełe si kindpi ba, ei nikił enjngił. ");
INSERT INTO nii_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pe Piisa kin eim angim tał, ningił se andpi erang kin, mani pu pingii pim. Ba yi er mułangin kin, Jiisas nge tiłang owundu ni wu tał tiłang owundu mulnjung konu ełe erim. ");
INSERT INTO nii_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wu tał Jiisas mondkuł si kindkił punguł enjngił. Pe Piisa ek dinga nipi yi nim, “Wu Owundu, sinim ya mołmun ei ka; sin ngii wii tekliki ełe tekmin. Ngii endi nim nge, endi Elainja nge, endi Moses nge,” pa nim. Ba Piisa eim ek ei pii poł tunarpi nim. ");
INSERT INTO nii_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pe ek ei nipi mułang kin, konu kupu endi opu, wu kei kin pełi erim. Erang kin, kon kupu ei en enim pandi tang kin, mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Konu kupu pełi erim, konu tuk ełe, ek endi tor om. Ek yi nim, “Ei na kangi, na eim noman ngop moł. Enim eim nimba ek, ei piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ek tor om, ei poru neng kin, kenjing ni Jiisas eim, endeim mendpił mułum. Mułang kin, en enim ek tinenjing. Ekii se kunum ei wu kei epi endi kaninmin pa nik, yi ninenjing mon. ");
INSERT INTO nii_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kupiiring komung ei si kindik, mani punjung. Puk, kenjing ni wumb tiłap owundu endi andłam ełe ok Jiisas kan sinjing. ");
INSERT INTO nii_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wumb onjung konu, tuk ełe wu endi om, wu ei wii dinga topu yi nim, “Owundu! Na nim kin prei end, nim na kangił ei kenjii. Na kangił endeim mendpił mołum. ");
INSERT INTO nii_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Gui kis endi, eim ambił gii nipi, sikir wii topu yi ełim. Pe gui kis ei, oł kis eim kin ełim. Erang kin, jipambił kuru endi eim gupu ełe tor ołum. Pe gui kis ei ngenj tuk, er kis mondpu, eim tor punałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Pe nam nim nge, er se andiłim wu ombu kanip nemb, to tor kindngii, nemb puk; ba nim nge er se andiłim wumb ei enjing kapłi enerim mon! ");
INSERT INTO nii_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jiisas ek dinga nipi, orung kindpi yi nim, “Enim wu amb pei kunum ełe, enim pii gii dinga ninanmin. En enim noman ełe kun pinałim. Kunum nimberii na enim kin mołup oł embin tui ei nge, er kun er mułmbii? Nim kangił ei ya tu wa!” ");
INSERT INTO nii_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pe eim kangił ei andpi wang kin, gui kis ni ełim oł ei erang, kangi ei olkup topu kindang, am pupu bok kis topu pim. Ba Jiisas eim gui kis ei ek dinga ngopu kindpi, kangił ei er ka erpi, arim mułum konu ngo orung kindim. ");
INSERT INTO nii_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Wumb pei molk kenjing ni, Gos nge noman dinga ełe oł ei erang, wumb puku sik enjing. Nga epi pei erim ełe nge, enim embin to piinjing. Pe Jiisas eim er se andiłim wumb kanpi, ek dinga nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Enim kom ka sek, molk ek ei piingii. Kunum kinan mon; pe nga wu Gos kindang mani opu wu kingam ei, wu kombur sipik, wumb pei angił ełe ngungii.” ");
INSERT INTO nii_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ba eim er se andiłim wumb, en enim ek nim ek ei, pułe pii poł tunenjing. Tunarik kin, nga ek ei pułe koi er pim. En enim mund mong tok Jiisas kin ek ei kii se piimin, min mon ni piik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jiisas nge er se andiłim wu ombu, en enim ek mił enjing. Erik, yi ninjing, “Sinim mołmun, tuk ełe wu nii owundu mułmba?” ");
INSERT INTO nii_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pe Jiisas eim yi piim, en enim noman tukrung yi pałim, ni kenim. Kanpi, eim kangił kembis endi tu wum. Kangi ei eim kin tep to engim. ");
INSERT INTO nii_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jiisas eim ek nipi yi nim, “Wumb endi kangił ei kanpi nam kangił ni piipi paki tumba, ei yi mił eim na paki tum ku. Pe wu endi na paki tumba, ei Gos Owundu na kindrim wu ei paki tumba ku. Kangił kembis tuk mołum ei mił wumb endi yi erpi kangił kembis noman pałim mił, yi peng na kongun yi erpi mułmba ei wu owundu mendpił.” ");
INSERT INTO nii_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pe Jon ek ni orung kindpi yi nim, “Owundu, sin kenjpin wu endi nim nge embe ełe nipi gui kis piim wu ei to tor kindrim. Ba eim sinim andinmin konu ełe ekii se onanim. Sin yi nipin kin mon ninjpin.” ");
INSERT INTO nii_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ba Jiisas ek nipi eim ngum, “Enim mon nik yi enerngii mon! Wu endi enim kin ek ka nipi ermba, ei enim opu orung wu mon!” ");
INSERT INTO nii_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Gos eim Jiisas sipi, ei tonu nga orung simba, kunum ei mandi erim. Yi erang kin, Jiisas noman dinga kindpi Jerusalem konu ełe ba erim. ");
INSERT INTO nii_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jiisas eim ba pendpi, wu kombur ok puk, wumb kanik ningii nge, nipi kindim. Pe wu ombu ok puk, Sameriya konu ełe ok tuk puk, eim omba nge er kun er mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ba wumb konu ełe wumb, en enim ngii konu Jiisas sipngii kis erang piinjing. Nimbił erang, wumb en enim yi mił piinjing; Jiisas Jerusalem konu ełe ba onum ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pe Jiisas nge, er se andiłim wu tał, Jon kin Jeims teł Sameriya konu ełe wumb oł ei kankił orung onmbuł, ek nikił Jiisas ngunjnguł. “Owundu! Nim er piin mił nenj? Sin ei epin konu ełe dup opu wumb ombu nangłi nimin min?” ");
INSERT INTO nii_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ba Jiisas kan ak topu, wu tał kanpi ek ngum. ");
INSERT INTO nii_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ek ngang kin, nga konu eipi endi punjung. ");
INSERT INTO nii_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Andłam ełe andik puk, pangin kin, wu endi tor opu ek yi nirim, “Nim pe punjii on konu ei na bii. Nim konu eipi endi punjii konu ei, na bii ku.” ");
INSERT INTO nii_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jiisas ek nipi wu ei ngum, “Owu simbii ei mei tukpu ełe or pałiłmin. Nga kei ei ngii sałim. Ba mei mani opu wu kingam ei, peng sipi or pimba konu ełe sinałim,” pa nim. “Pe nim na kin kii yi sikin ekii simbii nin, ei ninim pii poł ton min?” ");
INSERT INTO nii_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pe wu endi eipi kanpi, ek dinga nipi ngum, “Nim na ond konu ełe ekii se wa!” nim. Wu ei ek yi nim, “Nim na kapłi pup arnan kułum ei, tukpu top pendip ombii min?” ");
INSERT INTO nii_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pe Jiisas ek nipi wu ei ngum, “Wumb na noman konj sinanim ei wumb kułii mił mołmun ei kapłi wu ei tukpu tungii; ba nim pukun wumb kankin, Gos sinim tep erpi, mołum mił ei ninjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wu endi opu yi nim, “Owundu! Na kapłi, ok pup nam nge wumb tiłap ei, angił sip pendip kin, na nim kin ekii sip ombii min?” ");
INSERT INTO nii_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pe Jiisas ek yi nim, “Wu endi eim andłam kun bii ni pupu, nga kan orung kindpi, nga na noman pałim mił er nimba wu ei Gos sinim tep er mołum kongun pałim ei kapłi enermba mon!” ");
INSERT INTO nii_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ekii se Owundu eim wu nga engki angił orung nga tał to tonu kind mondpu, eim wu tał tał ni kindang punjung. Ei ekii se eim omba konu ełe ok ni kindang punjung. Eim wu ombu puk konu owundu ni, konu wii ni pei nipi kindim. Ekii se eim konu ombu pei andpi ba nge piipi nim. ");
INSERT INTO nii_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kindpi yi nim, “Kuni pei poł top mołum, ba kongun wu pei mulałmin. Yi piik kin, enim kuni arim ei kin prei kunum kunum er mułangin kin, kuni arim eim kongun wu pei kindang kuni kułou tungii nge pungii,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Piinmin! Enim pei! Na enim kung siipsiip wał mił tuk owu simbii mulnjung konu ełe kindind. ");
INSERT INTO nii_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Enim ku kon min simb su min kon erik se mołmun ei mendpił sipngii. Enim epi eipi endi sipnerngii. Andłam ełe puk wumb kin ‘Wei!’ a ningii; ba enim ek kinan tangk yi erik mulerngii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Pe enim puk, wumb ngii endi ełe, nirik punjung kin, ok enim ek yi ningii. ‘Enim ngii ełe wumb noman emin seng mułngii!’ ek yi ok ningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Pe wu endi eim noman emin peng, ngii ełe mułum kin, eim ek noman emin ningii ek ei wu ełe kin ba, min wumb endi noman yi pim endi mulenjing kin, enim noman emin ningii ek ei; nga en enim kin orung wang kin, ‘Enim kin noman ka pimba; ba wumb ei kin noman ka piinenmba, mon!’ ");
INSERT INTO nii_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pe en enim konu endi tuk puk kongun erangin kin, nga wumb endi enim ngii konu ełe sipik kuni mok to nungii kuni ei minj. Nga ngii endi puk, endi puk enerngii mon. ");
INSERT INTO nii_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nga enim ngii ełe minj molk, kuni ni, noł ni, nipi epi endi ngungii ei nungii minj. Nimbił erang kongun enmin wumb ei ku kapłi siłmin enim ngii ełe puk yi enerngii mon! ");
INSERT INTO nii_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Wumb kombur ening tang, piingii ei er ka erei! Erik yi ningii, ‘Gos sinim kin tep erpi mołum, kunum ei ya mandi onum,’ pa ningii. ");
INSERT INTO nii_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pe enim konu owundu, endi tuk pangin kin, wumb enim sik ngii konu ełe sipnarik, ninjing kin, enim puk andłam wer konu owundu ełe angk, molk, ek yi ningii. ");
INSERT INTO nii_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Enim nge kułman, sin simb ełe mułum, ba nga en enim kin orung kindinmin. Ba enim piik kun erngii, Gos sinim tep er mołum, omba kunum mandi enim.’ ");
INSERT INTO nii_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na enim kanip nind; kunum poru nimba kunum ei, Sorom konu ełe oł embin tui tonu orum ya konu ełe tonu onermba. Ba konu ełe oł embin tui owundu mendpił tonu omba. ");
INSERT INTO nii_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Enim Korasin ni Beseira konu ełe wumb piik kun er mułngii. Pe na jep oł yi enim kin enj oł ei Sairon konu ełe kin Taiya konu ełe ok yi ełamb kin, wumb ombu molk, kon mił epi geltii kend munduk, dup sik ełe molk sik, pakik andan tok, en enim oł kis buł ngok, noman to ak tunjung ni wumb, keningii nik yi ełmin. ");
INSERT INTO nii_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gos wumb mok tumba kunum mandi ermba ei, Taiya kin Sairon konu ełe oł embin tui, tonu orum ei kembis. Ba akip oł embin tui, enim kin tonu omba ei, owundu tonu omba. Nimbił erang, enim noman ak tunenjing. ");
INSERT INTO nii_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Pe enim Kapaniyam konu ełe wumb ei, epin konu ełe ambilk tonu pungii erngii ei mon! Ba enim dup konu ełe mani pungii.” ");
INSERT INTO nii_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Pe Jiisas ek yi nipi, eim nge er se andiłim wumb ngum, “Wu endi enim ningii ek ei piipi nim kin, ei na ek piimba. Wu endi enim kin, buł ngopu nim kin, ei na kin buł ngonum ku. Pe wu endi na ek piinarpi; buł ngopu mułmba ei, Owundu na kindang onj ei, eim kin buł ngumba ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ekii se wu engki angił orung nga tał, 70 pei orung ok, ka piinjing. Jiisas kanik yi ninjing, “Owundu! Nim embe ełe nemin, gui kis ni ombu, sin ek piik, ekii sik tor punjung,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Pe Jiisas Seisen eim dinga poru nipi yi nim, “Na mołup kenj ni, Seisen ei epin konu ełe kupu kuru mił, boi ni mani om. Opu, gur gałi owundu nipi kumb kinang erim. ");
INSERT INTO nii_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Enim piyei! Na enim dinga ngunj. Ngamb kin, enim ka wembii ni epi, enim kin tumbii ni ermba, ei eim piik kanik, enim opu orung wumb ongii ei, enim to mani kindngii. Enim pungii konu ełe epi endi, enim to mani kindnermba mon! ");
INSERT INTO nii_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ba enim ka piik yi ninerngii, ‘Gui kis enim sin ek ekii sik, tor punmun.’ pa ninerngii mon! Enim Gos kin ka piingii, Gos enim ei epin konu ełe enim embe poł pendim pałim. Nimbił erang enim Gos kingam noł mołmun.” ");
INSERT INTO nii_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kunum ełe Gos Gui Ka je, Jiisas kin ka piipi ngang kin, Jiisas ka piipi, ek yi nirim, “Gos Owundu! Nim tonu epin ni mani mei ełe owundu mołun. Ei na nim kin ka piind. Nim wumb noman ka pepi, peng pim wumb ei kin, oł ka dinga ei en enim kin koi erkin pendin, ba nga kangił kembis mił noman yi peng mołmun ei kin, oł ei andan tokun en, ei ka ninim noman ka pim mił en. ");
INSERT INTO nii_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Na arnan eim epi pei na angił ełe pei ngołum. Eim kingam ei wumb endi pii poł tunałmin mon! Arim, eim mendpił, kingam pii poł tołum. Nga arim wumb endi pii poł tunałmin. Kingam mendpił arim piiłim. Pe kingam mendpił eim noman ełe Ernjing wumb andan tumba, wumb ei Ernjing piingii.” ");
INSERT INTO nii_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jiisas nge er se andiłim wumb mendpił eim kin mulnjung. Molk kin, eim kan ak topu ek nim, “Enim piik kanik enmin oł ei, wumb kombur yi kenjing kin, wumb ei ka piyangin. ");
INSERT INTO nii_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na enim kanip nind, kumb ok Gos nge oł ekii se ermba oł ei piik niłmin wumb kin, wu King ni, wumb ei ok, enim pe kaninmin oł ei nge kenmin nik mulk. Ba en enim kinerik mon. Enim pe piinmin ek ei piimin ni mulk, ba en enim piinerik.” ");
INSERT INTO nii_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pe wu endi lo ek piipi ełim wu, ei eim yi piim. Nam ek nemb Jiisas nimba mił ei kenmbii nip nirim. “Ek andan wu! Na nimbił oł erip, noman konj sip kunum kunum ka mułmbii?” ");
INSERT INTO nii_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Pe Jiisas ek nipi yi nim, “Gos lo ełe nipe ek pałim? Nim er gerin mił nenj?” ");
INSERT INTO nii_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Pe eim ek dinga nipi orung kindpi yi nim, “Owundu, ei Gos nim nge, nim eim kin noman ka ngunjii ei, ninim noman nge ninim noman tuk, ninim dinga pei eim kin ngunjii. Pe ninim kapłi wumb nii endi ninim piikin, nanim wumb nii ni piimbii ei nanim wumb ende mił na kin mandi pep mołum; yi mił ninim noman kultun mił yi kulkun wumb ei ngunjii.” ");
INSERT INTO nii_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Pe Jiisas ek nipi ngopu yi nim, “Nim ek kun nin, ninim nin mił yi enjii! Erkin nim noman konj kunum kunum ka sikin mulnjii.” ");
INSERT INTO nii_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ba lo ek piiłim wu ei, eim embe ambił ka ermbii ni piim. Piipi kin, nga Jiisas kii sim. Sipi yi nim, “Na wumb nii ni piimbii ei nanim wumb endi mił na kin mandi mołum?” ");
INSERT INTO nii_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pe Jiisas ek yi mił nipi orung kindim, “Jura wu endi Jerusalem konu ełe si kindpi, wuł mani Jeriko konu ełe pum ni, wumb waning ełmin wumb kombur, eim andłam ełe kan sinjing. Wu waning ełmin wu ombu ok, eim epi pei sik, eim kepii tok erik pendik, en enim pangin kin, wu pupu kułmba peng pim. ");
INSERT INTO nii_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pe kunum ełe kułmał kałiłim wu endi, eim andłam ełe wuł mani pum. Pupu, andłam ełe pum ni wu pim ei kan si kindpi pum. ");
INSERT INTO nii_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Yi ku, pe nga Liiwai kułmał kałiłmin paki tołum wu endi andłam ełe tor opu pum. Pupu kin, wu ei kanpi si kindpi, opu orung andłam ełe pupu pum ku. ");
INSERT INTO nii_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ba Sameriya konu ełe wu endi andłam ełe opu, pupu mer wu ei pim konu ełe tor pum. Eim wu ei kanpi, eim mund mong ełe kaimb kis piim. ");
INSERT INTO nii_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Pe wu ni eim mandi pupu, kepii mundum konu ei kanpi, kopung kindpi, noł wain kindpi yi erim. Yi erpi sipi, tonu sipi, eim nge kung dongkii ełe tonu kindim. Kindpi sipipi, sing ngii ełe pendpi, tep ka er mułum. ");
INSERT INTO nii_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pekił kupiiring, eim ku mong engki sipi, ngii sing ngii tep ełim wu ei ngopu yi nim. ‘Nim na wu ei tep ka er mułii! Pe nim epi endi ya wu ei kin ngun kin, na ya orung ombii kunum ei, na nim kum epi top orung kind ngumbii,’ pa nipi eim pum. ");
INSERT INTO nii_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pe nim er piin mił nenj? Wu tekliki andłam ełe andik onjung. Nim wumb nii piinjii ei ninim wumb endi mił nim kin mandi mułang wumb kis ei ok wu ei tunjung?” ");
INSERT INTO nii_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Lo ek piiłim wu ei ek yi nim, “Eim wu ei kan kaimb piipi wu ei, paki tum.” Pe Jiisas ek nipi, wu ei ngopu yi nim, “Nim pukun oł yi ku erii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pe andik puk, Jiisas pupu konu endi ełe tuk pum. Amb endi mułum amb ei, embe Masa. Eim Jiisas sipi eim ngii konu ełe sipim. ");
INSERT INTO nii_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Masa ni amb ei eim angim endi mułum amb ei, embe Mariya. Mariya eim Jiisas mułum konu simb ełe mandi opu mołpu Owundu ek nim mił piipi mułum. ");
INSERT INTO nii_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ba Masa eim kongun pei erpi, kuni kełim. Pe eim noman eipi eipi pum. Masa pupu, Jiisas kanpi yi nim, “Owundu, na nge engnan ei, na wak tang, na mendpił kuni er ka end. Ei nim piinan min; eim kindan opu, na paki tumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ba Owundu ek nipi orung kindim, “Masa! Masa! Nim noman ełe epi kanim kanim piikin nin. ");
INSERT INTO nii_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ba epi endeim mendpił ka wii ei, pe Mariya epi ka ei, piipi simba enim. Ei wumb endi eim epi ka ei sinermba mon!” ");
INSERT INTO nii_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jiisas eim konu orung endi prei er mułum. Ekii se prei er poru nipi wang, eim nge er se andiłim wu endi opu yi nim, “Owundu, nim sin prei ermin mił ei, andan to!” pa nim. “Ok Jon wumb eim se andiłim wumb prei erpi eim nge kongun wu ombu andan tum mił yi, sin prei ermin mił enjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Pe eim ek nipi ngum, “Enim prei enjing kin yi erngii. ‘Sinim Erinjpin, nim embe ełe kun ka wii mendpił tonu mułmba. Nim sin tep er mołun konu ei tor omba. ");
INSERT INTO nii_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sin nge kuni nim kunum kunum ełe sin ngo! ");
INSERT INTO nii_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nim sin oł kis enjpin ei kil ngunjii. Nimbił erang, sin yi ku, wumb oł kis sin kin erik ei, ninim noman pałim mił, sin kin yi enanmin, ei pei si kindinmin. Nim sin oł embin tui endi tonu opu, sin kin erang kin, sin oł kis ermin ei kapłi, nim sin paki to si orung sin kin, sin konu ełe mandi punenmin.’” ");
INSERT INTO nii_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pe eim ek yi nipi ngum, “Enim mołmun konu tuk ełe, eim wu angim endi mołum ei, eim pupu, epin tuk memb, ngii andaring pupu angim ek dinga nipi ngopu yi nim, ‘Engnan, nim bres tekliki na ngui!’ a nim. ");
INSERT INTO nii_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Na nge wu puł endi konu turii andpi om. Na kuni ngumbii sinerang kin; na op nind,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Angim ngii nirik pim wu ei, ek dinga nipi yi nim. ‘Na angip tonu ombii pinałim; ngii ondu pałim. Na kangił kin or pałmin. Na angip, nim epi endi sip ngumbii pinałim.’ ");
INSERT INTO nii_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Kapłi, ei nimbił oł ermba? Na ek nip enim ngond, ‘Eim na engnan nipi piinarpi, epi endi ngunerim, eim yi piimba; wu ei wii tek tek top mołum nipi, eim kapłi angip opu, angim epi sinerang om, ei paki top ngumba.’ ");
INSERT INTO nii_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Na enim kanip nind, nim Gos kin kii sin kin nim ngumba sinjii. Enim epi endi kuruk endngii ei, kapłi keningii. Enim ngii ondu, to seki ningii ei Gos kapłi aki tumba. ");
INSERT INTO nii_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Wumb Gos kin prei ełmin ei epi siłmin. Wu endi epi kurpu andłim ei, kan siłim. Pe wu endi Gos kin mandi mołpu, ngii ondu to teki teki nimba ei, Gos kapłi aki topu ngumba. ");
INSERT INTO nii_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Enim mołmun konu tuk ełe, wu nii endi eim kingam opu, kii sipi, omu endi ngumbii nimba; ba eim arim ei ka wembii kis endi ngumba min? Ei mon! ");
INSERT INTO nii_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Wu endi kingam ei, kei muł numbii nimba; ba eim arim ei ka ep min, epi endi ngumba ei numba min? Ei mon ku! ");
INSERT INTO nii_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pe enim wumb kis, ei en enim kingenjing epi ka ngołmun. Ei en enim piingii ku. Yi mił, enim Ernjing ei epin konu mołum ei, enim prei erik, Gos Gui Ka simin ningii ei, enim kapłi ngumba. Ngang kin, Gos sin kin oł ka pei erpi ngonum.” ");
INSERT INTO nii_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jiisas wu endi gui kis mułang, ek tingnałim ei, to tor kindim. Gui kis ei pang kin, wu ei ek tangpi yi er mułang kin, wumb kanik, noman embin to piinjing. ");
INSERT INTO nii_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ba wumb kombur yi ninjing, “Eim gos kend owundu Biyelsipul nge ełe gui dinga kis ombu, to tor kindnim. Ei gui kis nge tep ełim wu,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Pe wumb kombur eim ermba jep oł ei, kenmin nik, oł endi ermin, ninjing. Nik yi ninjing, “Nim jep oł endi ei epin konu ełe oł endi erii!” ninjing. ");
INSERT INTO nii_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ba Jiisas wumb noman tuk ełe eim piim. Piipi kin, eim ek dinga nipi ngum, “Pe wumb mei ende wumb en enim eipi eipi puk, paltik opu ermin nik erngii. Ei en enim konu kunum kinan olt ka sinermba. En enim mei konu kis mułmba. Nga ngii endi eskił topu pupu, ngii endi ełe pimba ei ngii endi eskił topu, mani ba ku. ");
INSERT INTO nii_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Seisen nge tiłap ei ok eipi eipi puk, opu ermin nik erngii ei, kapłi ka mułngii mił nenj? Enim nik na gui kis tor kindind; ei nimbił erang Biyelsipul nge dinga ełe gui kis ombu to, tor kindind, ninmin ei na nind. ");
INSERT INTO nii_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Enim yi ninmin, “Na gui kis to tor kindinj ei Biyelsipul dinga ełe to tor kindinj pim kin, kapłi en enim Jura engnjing noł gui kis to tor kindinmin ei kindinmin mił nenj? Yi mił ku en enim ek ełe ni peni ełe kindpi kos er ngumba. ");
INSERT INTO nii_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gos angił ełe erang, na gui kis top kindinj pim kin, kapłi Gos sinim kin tep ermba om ni piimin. ");
INSERT INTO nii_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Pe wu dinga endi, opu kiłeng ambiłpi, eim ngii ełe mułmba ei eim ngii konu ka simba. ");
INSERT INTO nii_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ba wu endi eim dinga pupu wang kin, wu ei kin opu erngił ei, wu ei kapłi, eim wu endi opu kiłeng ni kumb tepii ei kapłi simba. Eim opu ermbii nip piingii ni opu, wu ei topu eim epi sipi, wumb mok to ngopu yi ermba pend piipi omba. ");
INSERT INTO nii_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Wu endi na kin opu ermba wu ei, na kin wu puł mon! Wu endi na nge kung siipsiip kin, tep er kun enermba, ei eim na kung siipsiip ombu, to eipi eipi kindiłim.” ");
INSERT INTO nii_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Gui kis wu endi si kindpi pułum ei, pupu mei kep ka sałiłim, konu mołułum. Gui kis ei konu endi kan sinałim kin, yi ni piiłim. ‘Ok nam muls, ngii konu si kindip onj konu ei nga bii,’ ni piiłim. ");
INSERT INTO nii_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Pe pupu ngii ełe kurpu kenim ni, ngii ei er kun er sałmin ei sim. ");
INSERT INTO nii_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ka seng kanpi, pupu gui kis angił orung nga tał nipi tu wum. Ei eim dinga ei to mani kindik oł kis ełmin. Erik, ngii ełe nirik puk mołułmun. Ok wu ei kis aninga mułum, ba pe kis mendpił mołum.” ");
INSERT INTO nii_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jiisas eim ek ei nim, kunum ei wumb pei mulnjung. Konu tuk ełe amb endi mułum. Amb ei ek dinga nipi wii yi mił tum. “Amb ei ok nim mengpi nim am ngurum amb ei eim ka piyangłi.” ");
INSERT INTO nii_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jiisas ek nipi yi nim, “Ei minj mon, ba wumb Gos kin ek piik ekii sinmin wumb ei kapłi ka piyangłi.” ");
INSERT INTO nii_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wumb pei ok kułou tangin, Jiisas ek yi nim, “Akip kunum ełe, wu amb pei wumb kis mołmun. En enim kii sik ek nik, jep oł minj kenmin ninmin. Ba na jep oł endi andan tunermbii. Ei Jona nge jep oł mendpił ei andan tumbii. ");
INSERT INTO nii_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Gos kumb ok Jona Ninipe konu ełe pui nipi kindrim, ba Jona Gos ek nirim mił ekii sinerang kin, Gos jep oł endi erpi andan tang, omu owundu eim kirim ełe tuk pupu kunum tekliki pirim. Ei Ninipe konu ełe mołmun wumb keningii nipi enerim mił yi ku wu kingam mołum. Ei eim Gos oł ei ermba ei akip wumb mołmun kunum ełe keningii nipi ermba. ");
INSERT INTO nii_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ekii se Gos eim wumb, mok tumba kunum ei, wumb tep er mułum amb kuin konu mei orundung mułum amb ei tonu opu, wumb oł kis enjing ei ni peni ełe kindpi ermba. Nimbił erang amb kuin mei wer orung mendpił mułum. Pe eim opu King Solomon eim noman ka piim ei piimba nge om. Ba pe wu endi Solomon to mani kindim wu endi ya ełe mołum; ba en enim eim ek piinenjing mon. ");
INSERT INTO nii_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ekii se Gos eim, wumb pei mok tumba kunum Ninipe konu ełe mołmun wumb kin, wumb akip kunum ei wumb ouni orung tonu ongii. Ok oł kis ombu nik tor kindngii. Nimbił erang Ninipe konu ełe wumb Jona nirim ek ei piik, noman ak tok. Ba pe ya mołum wu ei Jona ek to mani kindim, ba enim noman ak tunanmin. ");
INSERT INTO nii_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wumb dup alam kałiłmin ei sik ngii nirik mandring, peł ełe kindngii ełe mandring kindik pendngii ei mon! Wumb dup kalk tonu peł ełe pendiłmin, wumb ngii ełe nirik ongii ei, dup tiłang ei kanik ongii. ");
INSERT INTO nii_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nim ningił, ei ninim ngenj ełe nge tiłang. Pe ninim ningił ka piimba ei ninim ngenj tiłang ka ermba. Pe nim ningił kis mułum kin, nim ngenj pei emii ermba. ");
INSERT INTO nii_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ei piik en enim, kan kun er mułngii. Mon pim kin tiłang noman tuk sałim ei nga emii ermba. ");
INSERT INTO nii_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pe ninim noman tiłang pei pim kin, noman ełe emii endi pinermba mon. Ninim noman pei tiłang ermba. Ei dup alam tiłang enim mił yi ninim noman ełe tiłang erpi pimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jiisas ek ei nipi poru neng kin, lo ek piiłim wu endi opu, “Jiisas, nam ngii konu wang kuni numbuł,” pa nim. Yi neng kin, Jiisas pupu peł ełe mułum. ");
INSERT INTO nii_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Lo ek piiłim wu ei mołpu kenim ni, Jiisas noł was enarpi, kuni ok num. Nang kanpi wu ei, eim noman embin to piim. ");
INSERT INTO nii_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ba Owundu yi nim, “Enim lo ek piiłmin wumb enim kuni nołmun ming torung was er ka ełmin wumb tukrung penj mołum. Yi mił enim noman tuk ełe oł kis ni, waning epi erngii nge piki top pałim. ");
INSERT INTO nii_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Enim wumb noman pinałim. Gos enim nge ngenj torung erim, ba eim enim ngenj tukrung enerim min? ");
INSERT INTO nii_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ba enim noman tuk pałim oł ka epi yi erngii nge wumb kaimb er mołmun wumb ei paki tungii. Enim yi erangin kin, enim noman tuk ka seng kin, enim wumb paki tungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ba enim lo ek piik kin wumb, piik kun er mułngii. Enim keming ni tem ni epi mok tok engki erik, epi orung endeim sik Gos ngołmun. Ba enim wumb noman ngok ełmin, oł ei si kindik, andłam kun si kindik, Gos kin noman ngunałmin. Enim oł ei erik, nga oł endi si kindnałmin mon ku. ");
INSERT INTO nii_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Enim lo ek piik ełmin wumb, piik kun er mułngii. Enim yi mił piiłmin, sin men ngii ełe kumb se mułamin kin, wumb keningii nik ełmin. Pe kunum endi, wumb kułou tołmun kunum ei, sin onmun nik angił sik, yi erangin wumb eipi, ei sin keningii nik. Enim noman yi piiłmin wumb. Yi erngii ei kan kun erik mułngii. ");
INSERT INTO nii_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Enim mołmun ei yi mił, wumb tukpu tołmun, ba jep oł er pendnałmin, mei mandring koi er pałim ei kan kun enarik tonu peł ełe andłam andiłmin, ba mandring mei konu ełe ka sinałim mił enim yi mołmun. Ba wumb kan kun enarik kin, nga wumb ok emin mołmun mił yi ku molk kapłi enanmin.” ");
INSERT INTO nii_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wu endi lo ek piik nik ełmin wu ei nge endi ek nipi orung kindpi yi nim, “Ek mon wu! Nim ek yi nikin, sin kin ek embiłin ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pe Jiisas ek ni orung kindpi yi nim, “Enim lo ek piiłmin wu, enim kan kun er mułngii. Enim oł embin tui er wumb ngołmun. Ngangin kin, wumb kongun dinga ełmin; ba en enim angił endi tuk kindik, wumb ei wurii wii paki tunałmin mon! ");
INSERT INTO nii_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Enim kan kun erik mułngii! Ok enim kupenjing noł Gos oł ekii se ermba oł ei piik niłmin wu ombu to kundnjung. To konduk kin, tukpu ełe en enim epi kuk moke ngok pendnjing. Yi enjing ei, en enim kupenjing noł enjing oł ei en enim noman ełe kapłi en enim ni piik enjing. Keimi, nimbił erang enim kupenjing noł Gos ek ka ni tor kindiłmin wumb to kundnjung? Nga enim tukpu sik epi kuk moke ngok enjing. Oł ei ngenj torung oł keimi mił pim, ba noman tukrung oł keimi enenjing, mon! ");
INSERT INTO nii_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Yi erangin kin, Gos eim noman ka piim ek ei ok eim nim, ‘Pe na Gos oł ekii se ermbii oł ei, piip nimba wu kin, Gos ek ka ei si endngii wumb kindamb ongii. Ei wumb kombur konu eipi eipi pangin, embii monduk to kundngii. ");
INSERT INTO nii_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pe kunum ełe, wumb ei ok Gos oł ekii se ermba ei piik ni tor kindiłmin, wumb to kunduk. Akip kunum ełe en enim oł embin tui singii. Ei ok wumb ombu to konduk mił ni, pe kunum ełe erik mił singii. ");
INSERT INTO nii_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Am kumb ok, wu Eipel kultum. Nga mering wu Sekaraiya kultum. Ei Gos ngii kułmał kałiłmin konu kin men ngii konu tuk ełe kultum. Ei ngenj kumbii singii nim ei, pe mołmun wumb ei keimi. Na enim kanip nind, enim wumb tiłap ei pe ngenj kumbii singii. ");
INSERT INTO nii_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Enim ek ka piik sinjing, ba wumb kombur tuk puk ek ka simin ni enjing, ba en enim singii andłam ei, enim ondu ngunjung ei, enim kapłi konu ełe tuk punerngii mon!” ");
INSERT INTO nii_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jiisas ngii ełe si kindpi anda pupu pum. Pe lo ek połmun wumb kin, lo ek piik niłmin wumb en enim ek nik, eim ngunjung. Ngok kin, eim gupu ełe ek kanim kanim kopur kii sipin, yi nimin nik piik enjing. ");
INSERT INTO nii_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Eim ek endi nipi ngumba min, nik kui er mulnjung. Eim Jiisas ek endi nipi nim kin, ek nipin eim kos er ngumun ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Wumb pułe mam pei ok kułou tunjung, ba konu wumb pei piki topu pim, wumb endi kombur kembngii pim. Kunum ei Jiisas eim ek ok, nipi eim er se endim wumb ngum. “Enim kan kun er mułngii. Lo ek piik niłmin wumb ei ek kend tok niłmin ei, yiis bres tuk kindiłmin mił.” Jiisas ek ei pułe yi mił nirim, “Lo ek piik niłmin wumb ek kend tok, ek ei wumb eipi ngangin piik kin en enim er kis mondułmun. ");
INSERT INTO nii_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pe epi pei koi er sałim ei ekii se nga peni ełe omba,” pa nim. Epi pei kum topu pałim ei, ekii se nga peni ełe wang wumb keningii. ");
INSERT INTO nii_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Yi pałim ei, enim ek koi erik emii peng ninjing kin, ei nga kupiiring eni topu tiłang enim mił ek ei tiłang erpi, peni ełe wang kin, wumb piingii. Enim ek aninga ngii nirikring ninjing ek ei, nga tonu ngii tondrung ełe angk nik tor kindiłmin mił pimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Enim na wumb puł, na enim kanip yi nind. Wumb enim ngenj ei to kundngii ei mund mong tunerngii! Mon!” pa nim. “Pe nga ekii se wumb ei oł endi nga kapłi enerngii mon! ");
INSERT INTO nii_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ba na enim mund mong tungii wu, endeim na enim andan tumbii,” pa nim. Enim wu ei kin mund mong tungii; wu ei wumb to kondułum. Nga ekii se, eim wumb sipi dup konu kis ełe kindmba ku. Na enim kanip nind, enim eim kin mund mong tok mułngii. ");
INSERT INTO nii_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Enim piinmin! Kei Winu angił orung ei, ku kundii tał ngok siłmin ei, enim piinmin. Ba Gos kei ei pei kanpi piinim. Nga endeim Gos ourun tunanim mon! ");
INSERT INTO nii_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na ek keimi nind. Gos enim peng enjin tukrung, ei pei gerpi kanpi poru ninim. Enim mund mong tunerngii! Enim kei Winu kembis mił ei, to mani kindinmin. Yi mił ku Gos enim kin pei tep er kanpi mołum.” ");
INSERT INTO nii_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Na enim kanip nind, wumb endi na embe ełe ek nipi wumb kumb ełe kanpi nimba wumb ei, eim na kin nimba ei wu kingam yi ku nimba. Ei eim Gos enjel kumb ełe wu ei embe ambił tonu kindmbii. ");
INSERT INTO nii_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pe wumb endi na kin, wumb ningił ełe buł ngopu nim kin, na eim Gos enjel ningił ełe eim buł ngumbii ku. ");
INSERT INTO nii_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Wumb nii endi wu kingam kin, ek ambiłpi ek kis nimba wu ei, Gos eim oł kis kil ngumba. Ba wumb endi eim yi nipi Gui Ka dinga kongun owundu erim, ei embe ambił mani kindpi, yi nimba wumb ei Gos kapłi ek kis yi mił nimba wu, ei kil ngo si kindnermba mon! ");
INSERT INTO nii_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Pe wumb enim sik sipik men ngii ełe wu owundu mułngii ningił ełe ni, wumb num mułngii konu ningił ełe sipngii ei, enim mund mong enerngii mon! ‘Pe sin nipe ek ei nimin?’ Nik, yi ni piinerei mon! ");
INSERT INTO nii_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wumb enim kin ek ningii kunum ei mendpił, Gos Gui Ka, enim ningii ek ei, enim ek andan tumba. Nipi ngang kin, enim ningił ek ei mił ningii.” ");
INSERT INTO nii_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wumb pei mulnjung konu tuk ełe, wu endi opu Jiisas kanpi, ek nipi ngum, “Ek mon wu! Nim ek nikin na angnan ngunjii. Ngan kin, eim sił erinjpił epi ei pei mok to simbił,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ba Jiisas ek nipi orung kind ngopu yi nim, “Nimbił erang wumb nii na ek kos mił piimbii nik to tonu kindnjing min, nga ełip erinjngił koł epi ełip kin mok top kapił kapił erpi ełip ngumbii min ei kapłi enanim mon!” ");
INSERT INTO nii_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Pe Jiisas eim ek nipi orung kindpi wumb ngopu yi nim, “Enim kan kun er mułngii. Wumb epi pei simba ei nik, kan bun bun kulerngii mon! Pe epi pei simba wumb ei, eim kułmba kunum ei, epi ombu eim paki tunerngii mon!” ");
INSERT INTO nii_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Pe eim ek ekin endi topu wumb ngopu ek dinga nim, “Wu num endi epi ni ku pei sałiłim wu ei, eim kuni tełim ei, poł pei topu mołum. ");
INSERT INTO nii_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pe wu num ei eim noman ełe piipi, ‘Na nimbił oł endi ermbii?’ ni piim. ‘Na kuni tuk kindmbii ei ngii pei sinałim,’ ni piim. ");
INSERT INTO nii_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Eim yi nim, ‘Nam ermbii mił nenj?’ ni piim. ‘Na yi ermbii, kuni ngii kembis kembis ombu to kis erpi, kuni ngii owundu konj tekmbii,’ nim. ‘Takip kin, kuni tem ni kuni kanim kanim sip nam ngii ełe tuk kindmbii. Nam kuni pei sałim, kung pei nop mułmbii,’ nipi kin, kor mułum. ");
INSERT INTO nii_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Mołpu kin, eim ei ek nipi yi nim, ‘Nim kung ngii pei kor molkun, kuni ni epi sałim. Nokun kin, ka ka piikin mulnjii,’ pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ba Gos ek nipi wu ei ngum, ‘Nim wu kom noman ka pinerang nikin mołun. Nim epin mendpił nim kulnjii. Kułan kin, epi pei ka er sin, ei wumb nii simba?’ ");
INSERT INTO nii_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ei yi mił, wumb en enim epi pei kułou mondułmun wumb ei, Gos kumb ełe ok epi sinerii mił mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jiisas eim er se andiłim wumb kanpi, ek dinga nim, “Na enim kanip nind, ‘Enim noman konj ełe noman to minj kulerngii mon!’ Enim yi ningii, ‘Sinim kuni nipe kuni numun? Nga enim ngenj ełe piik kin, alap ni epi nipe endi kindmin,’ yi ni piinerngii mon! ");
INSERT INTO nii_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Noman konj sikin konj mulnjii ei, kuni minj ni piinerngii; nga ngenj ełe alap minj ni piinerngii! ");
INSERT INTO nii_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Enim kei Goi ni kei kanim kanim ei piingii. Enim kei piin min? Kei ei kuni tilałmin, nga kuni kełngii ngii sinałim; nga kuni tu wuk kułou tunałmin; ba Gos eim kei kuni ngołum. Enim wu amb ei kei to mani kindinmin ei, enim wumb owundu mołmun. ");
INSERT INTO nii_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pe enim mołmun konu tuk ełe wu endi noman dinga pimba. Ei eim nga nipi, pupu eim noman konj ei kung ngii kopur nga sipi, mułmbii ni pimba, ei kapłi enanim; ba Gos mendpił ei kapłi ermba. ");
INSERT INTO nii_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pe enim epi kembis endi erngii ei kapłi enerim kin, Gos mendpił kapłi ermba. Nimbił erang enim epi kanim kanim pei noman to piinmin? ");
INSERT INTO nii_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Enim epi kuk ka wii ei piin min? Ei kongun endi enałmin mon. Ei wii tonu onum. Pe enim alap enałmin; ba na enim kanip nind, kumb ok King Solomon, eim alap ka wii kindim. Ba ei ya epi kuk ka wii ei mił alap endi kindnerim mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","“Pe kuni tałiłmin konu epi ka wii tonu opu mołum ei, pe mołum; ba topuł tok tor kindik dup kełngii. Pe epi wii ei nge Gos kan wiik tołum. Ei enim kan kun erngii. Gos enim tep ermba ku; ba enim wu amb pii gii dinga pinałim. ");
INSERT INTO nii_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yi piik, enim noman embin to piinerngii. Sin nipe kuni kin noł numun, epi nipe epi simin nik yi piinerngii mon! ");
INSERT INTO nii_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mei konu orung orung torung mołmun wumb ei, epi pei er simin mił nenj ni piik mołmun; ba enim Ernjing ei epi ei nge singii ni piinim. ");
INSERT INTO nii_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Enim Gos enim tep er mołum oł ei, kan kun er mułngii. Pe Gos eim enim epi ombu kapłi ngumba ku.” ");
INSERT INTO nii_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Enim wumb tiłap kembis kung siipsiip mił ombu, enim mund mong tunerngii. Enim Ernjing Gos ka piipi, eim tep er mołum konu ei, ‘Enim ngumbii mułngii,’ pa nirim, ek ei pałim. ");
INSERT INTO nii_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","En enim epi pei wumb ngangin kin, wumb top tok singii ku ei, wumb wii mułngii wumb ei, paki tok ngungii. Ngangin kin, enim ku nin epi ombu am punermba. Pe ninim kon endi sinjii kon, ei sikirpi kiłip topu numun tunermba; ba kon dinga wii seng kindnjii. Pe enim epi ka wii kanim kanim, epin konu kułou tungii ei am punermba. Konu ełe waning wumb tuk ok waning sinerngii; nga ka pila min, epi kis endi tuk ok epi ombu, nok erik kis mundnerngii mon! Pe enim epi ka wii, ei epin konu kułou tungii, ei am punermba. Epin konu ełe waning wumb tuk onerngii; nga ka pila min, nga epi kis endi tuk onerngii mon. ");
INSERT INTO nii_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Enim nge epi ka konu ełe sałim konu ełe, kunum kunum enim noman tuk konu ełe sałim ku.” ");
INSERT INTO nii_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Enim kan talk, dup alam si kalk, konduk kindik, nipe epi endi erik, en enim er kun erik mułngii. ");
INSERT INTO nii_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Jiisas ek nipi yi nim, “Enim mułngii ei, wu owundu endi omba. Nik kin, wumb en enim or pinarik, er mołmun mił mułngii. Ei yi mił, wu ei eim kuni owundu nok erngii ei, orung omba ei si kindpi kin, opu ngii ondu to teki teki nimba, ei sikir ok aki tungii. ");
INSERT INTO nii_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Wu owundu ei opu kaniłim ni, eim nge kongun wumb or pinałmin ei, wumb ka piingii. Na enim kanip nind, wu owundu eim alap sipi osii er tałpi, kan tałpi, eim nga kuni er kun er sepi yi nimba. ‘Na nge kongun wumb ok peł ełe molk, kuni owundu nungii nge ngumbii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pe wu owundu ei epin tuk mii memb omba min, kei kultu kumna tumba kunum ei omba min, eim opu kenmba ni, eim kongun wumb or pinarik omba nik, kui mułngii wumb ei ka piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Enim oł ei piinmin! Wu endi eim ngii konu waning wumb ongii ni piipi kin, eim ngii konu tep ka wii er mołum ei, tuk punałmin mon! ");
INSERT INTO nii_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Enim yi ku er kun erik mułngii. Wu kingam eim omba kunum ei, enim piik kunum ełe, omba ni piinerngii.” ");
INSERT INTO nii_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pe Piisa ek ekin yi nim, “Owundu, nim sin kin ek ekin pei ni ngon min, sin wumb eipi kin ek ouni nin min?” ");
INSERT INTO nii_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Pe Owundu yi nim, “Pe tep enim ei nii tep mołum? Mołpu kin, eim noman ka pałim. Peng kin, eim kongun tep ka mołułum. Mołpu kin, owundu eim wu endi to mundang mołpu, kongun wumb tep er nim min? Nipi kin, wumb kuni kunum simba kunum ei ngopu erangłi nim min? ");
INSERT INTO nii_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ekii se wu owundu ei orung opu, eim kongun wu ei ok ek nim mił, ei piipi kin, kongun er mołum wu ei eim ka piimba. ");
INSERT INTO nii_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na ek keimi nip enim ngond, wu owundu eim, ‘Epi pei tep er mułii!’ nimba. Neng kin, tep er mułmba. ");
INSERT INTO nii_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ba kongun wu ei eim noman yi piim, ‘Na wu owundu ei sikir orung onermba,’ ni piipi, kongun wumb ei wu amb ni kepii topu kin, eim pupu kuni nopu, noł nopu, wulu pang er andpi mułum. ");
INSERT INTO nii_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pe eim yi er mułum ei, eim wu owundu ei kunum nenj omba nipi kin, kui er mulerim. Pe kunum endi eim pii poł tunarpi mułum. Pe wu owundu opu, eim kongun wu ei kepii topu, wu sipipi wumb wii molk kongun pii poł tunarik mulnjung konu ełe mundum. (Konu ełe wumb pii gii ninenjing wumb). ");
INSERT INTO nii_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kongun wu ei eim wu owundu ełim oł ei piiłim; ba eim wu owundu noman ełe kongun kun enarpi mułum. Wu ei wu owundu opu, ek ngopu kin, kepii dinga wii tumba. ");
INSERT INTO nii_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pe kongun wu ei, eim wu owundu kongun ełim oł ei piinarpi kin, oł eipi er mułum kin, wu owundu ei opu, ek ngopu kin kepii aninga er tumba pałim. Wumb endi epi pei ngang sim pim kin, wumb ei epi yi ku erpi kin nga pei ngo orung kindmba. Nga wumb endi ek ka min, kongun ka ni, epi pei kanim kanim ngum ei, wumb kin kongun oł yi mił ku erpi ngo orung kindmba. ");
INSERT INTO nii_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na op dup owundu kindamb, mei ełe opu dup numba. Nam noman dinga ni piip, nam dup ei sikir numba. ");
INSERT INTO nii_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na noł endeim pimbii ei yi mił, na kin oł embin tui owundu endi tonu onum. Onum oł ei na kin sikirip poru nimba. Nip moł; ba sikirpi poru ninerang kin, nanim noman embin enim. ");
INSERT INTO nii_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Pe enim piinmin! Na op enim opu erik erngii oł ei (opu ond wu mił op) mon nimbii onj min? Mon. Na enim kanip nind, “Na op wumb tiłap ende en enim opu erngii, nge onj. ");
INSERT INTO nii_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Akip ni, nga ekii se, wu amb kangił kombur ngii ende mułngii wumb ei, ok eipi eipi puk, tiłap tał er mułngii. Pe tiłap endi, opu orung erpi tiłap tał ngumba. Ngang kin, nga tiłap tał opu orung er eim kin ngunguł. ");
INSERT INTO nii_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Yi er puk kin, kangi ei arim kin opu ermba ku. Nga arim kingam kin opu ermba ku. Nga amb mam eim ambiłam kin opu ermba; nga ambiłam eim mam kin opu ermba ku. Pe amb mam eim kingam ambim ei kin opu orung erang; nga kingam ambim ei kingam mam kin opu orung erang kin yi erngii.” ");
INSERT INTO nii_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Pe eim ek dinga nipi wumb ngopu nim, “Enim konu eni tonu opu, mani pupu, enim konu ei kon kupu endi tonu onum ei kaninmin. Kanik kin, enim yi ninmin, ‘A konu kumb tumba.’ Enim yi niłmin oł ei keimi, konu kumb tołum. ");
INSERT INTO nii_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Pe enim mułangin kin, konu pop owundu endi mer ełe tołum kunum ei, enim yi niłmin, ‘A konu eni owundu pimba,’ pa niłmin. Yi niłmin, oł ei keimi tonu ołum. ");
INSERT INTO nii_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Enim ek kend wumb! Enim kupu kin mei ełe oł ermba ei kan poru niłmin. Ba nimbił erang, enim Gos oł kombur pe tonu onum, nga tonu omba ei, kan kun enanmin? ");
INSERT INTO nii_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Nimbił erang enim oł ei ek nik kun kind piinarik, oł kun niłmin? ");
INSERT INTO nii_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Kunum endi nim wu endi nim kin kos er ngumba wu ei kin, tep to punjii. Ei andłam ełe pukuł, wu ei kin ek ni ka enjii. Mon pim kin, wu ei nim sipi, kos piiłim wu endi angił ełe ngang kin, kos piiłim wu ei nim sipi opu ond wumb angił ełe ngang, opu ond wumb nim sipik, kan ngii ełe kindngii. ");
INSERT INTO nii_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na enim kanip nind, nim kan ngii ełe sikir tor onenjii mon! Ok ninim kom se piikin, ku epi owundu endi min, ku kembis pei ei ngo orung kind poru ninjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kunum ełe, wumb kombur mołangin kin, enim nik Jiisas ngunjung. Galilii wumb kombur mołangin kin, Pailos eim kułmał kelnjing wumb ei, topu miyem sipi nga kułmał kelnjing, kung miyem ei sip endi kindim. ");
INSERT INTO nii_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jiisas ek dinga nipi orung kindpi yi nim, “Galilii wumb ei er molk, Galilii wumb kombur to mani kindinmin, ni piik ninmin min? Pe Galilii wumb tiłap ei oł kis ełmin, wumb ni piik ninmin min? Ełe nge kapłi wumb ei oł embin tui sinjing min? ");
INSERT INTO nii_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na enim kanip nind. Ei mon! Ba enim yi ku, noman ak tunenjing kin, enim pei yi mił ku kolk am puk poru ningii. ");
INSERT INTO nii_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kumb ok kunum Sailom ngii olt endi eskił topu mani pupu wumb engki nga kapił kapłi pei to kundum. Wumb ei oł kis erik oł ei, wumb eipi Jerusalem konu mołmun wumb oł kis ei to mani kindim ni piik ninmin min? ");
INSERT INTO nii_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ei mon ku! Na enim kanip nind, ‘Enim noman to ak tunenjing kin, enim yi mił ku kolk am puk poru ningii,’ pa nind. ");
INSERT INTO nii_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Pe eim ek ekin endi nipi ngopu yi nim, “Wu endi eim ond pik tuk kuni wain pin tałim. Ba ekii se opu, ond pik ei mong tonum min? Op, mong tang numbii ni piipi opu kin, kenim ni mon pim. ");
INSERT INTO nii_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mon peng kin, ek nipi eim kongun wu ngum, “Nim piin! Kung ngii tekliki mołup op kin, ond pik mong numbii ni onj, ba mong tunerim. Pałim, ei nim kołmung to kindii! Nimbił erang ond ei mei noł wii nonum?” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kuni mong nge kongun ełim wu ei ek nipi orung kindpi yi nim. “Wu owundu! Nim kapłi nen, kung ngii endeim minj nga mułmba min? Mułang kin, na mer ond puł ełe mei akip kung kou enj tu wup, kindip kin, yi ermbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","“Yi erpi pindamb kin, nga kung ngii endi ełe kapłi mong tumba. Yi eramb kin, mong tunerim kin, nga kołmung tui nen kin, to si kindmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kor kunum endi Jiisas Gos ek ka nipi wumb ngum. Ei men ngii endi ełe mołpu ek nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kunum ełe amb endi mułum, amb ei gui kis endi mułum. Gui kis ei, amb ei ening ngang kin, kung ngii engki nga kapił kapłi pei o pum. Gui kis ei erang kin, amb ei ening kan sipi pim ei eim buł engin tang kin, kun ba pinerim mon. ");
INSERT INTO nii_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pe Jiisas amb ei kanpi yi nim, “Nim ya wa!” Amb ni wang kin, Jiisas ek yi nim, “Na nim ening ei er ka er poru nind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Amb ei wang kin, Jiisas angił sipi, amb ei embiłim. Embiłang kin, amb ni sikir kun engim. Angpi kin, Gos embe ambił tonu kindim. ");
INSERT INTO nii_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ba men ngii ełe tep mołułum wu ei, Jiisas amb ei kor kunum er ka erim ei, mon nipi, Jiisas kin popuł sim. Sipi kin, ek dinga nipi wumb pei ngopu yi nim, “Kongun ermin kunum ei kongun minj ermin. Kunum angił orung nga endeim ełe kongun ermin. Enim ei ngenj er ka ermba ni pingii wumb ei, kongun kunum wangin kin, er ka ermba. Enim ełe nge piik kin, kor kunum wumb yi nge, ya ełe tu wunerei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pe Owundu ek nipi orung kindpi yi nim, “Enim wumb kanik ek kend nik pendik, nga puk oł eipi eipi ełmin wu, kor kunum enim kung kou ni, kung dongkii ni konu kuni ngo pendiłmin konu ei kan posik sipik, noł ngok, nga tu wuk, yi ełmin oł ei piinarkin nin min? ");
INSERT INTO nii_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ba amb ei, Eiparam nge tiłap ambiłam, Seisen ambił gii nipi mułang kin, kung ngii engki nga kapił kapłi pei opu pum. Ei akip kor kunum ei na eim kan mił pe mułum ei, pilngan to kindind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eim ek yi neng kin, opu orung enjing wumb ei singambił sinjing. Pe wumb pei eim erim oł ka ei kanik ka wii piinjing. ");
INSERT INTO nii_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jiisas ek ekin nga topu yi nipi ngum, “Na nipe epi endi su sip kin, nga Gos wumb tep enim ei tonu ok pei mołmun ei nip ngumbii? ");
INSERT INTO nii_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ei yi mił, kuni emb kembis wii endi sinim embe ‘maser,’ pa ninmin. Wu endi kuni emb maser ei sipi kin eim kuni tałim konu ełe tałpi pendim. Pe kuni maser ei ekii se ond mił tonu om. Ond ei engim konu kei ok mołułmun.” ");
INSERT INTO nii_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ek ekin nipi nga nim, “Na Gos wumb konu orung orung wumb pei tep er mołum oł ei, na epi nipe endi mił su sep nimbii? ");
INSERT INTO nii_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ei yiis bres tuk kindiłmin mił, amb endi bres plawa ming owundu endi sipipi, yiis kin endi kindim ei, ekii se bres plawa ei oupu tonu om. Ei yiis ninmin epi ei konu orung orung pang kin, yi ełim. ");
INSERT INTO nii_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jiisas eim pupu, konu owundu ni konu kembis kombur sim konu tor pum. Pup andpi kin, Gos ek emb topu, wumb ngopu yi erim. Erpi kin, eim Jerusalem konu ełe ba nge pum. ");
INSERT INTO nii_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","24","Pang kin, wu endi opu yi nim, “Owundu, Gos wumb endeim, endeim ni sipi orung simba min?” Ba Jiisas ek nipi wumb ngopu yi nim, “Enim embił dinga kindik, kongun dinga erik, ngii ondu kembis wii ełe tuk pungii. Ei yi mił enim kan kun er mułngii nge Gos erim. Na ek nip enim ngond, ei nimbił erang wumb pei ngii ondu kembis wii nirik bin nik erngii; ba kapłi enermba mon! ");
INSERT INTO nii_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ekii se ngii arim ei opu kin, ngii ondu ngumba. Ngang kin, enim ok andaring ok, molk yi ningii. ‘Owundu, ngii ondu aki to!’ yi ningii. Pe eim ek yi nipi ngumba, ‘Enim jiłi wumb, na piinand.’ ");
INSERT INTO nii_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nga enim yi ningii, ‘Sin nim kin ende mołpun, kuni nopun, noł nopun, nim andłam ełe andpin, ek emb topun, sin konu owundu ngołan,’ pa ningii. ");
INSERT INTO nii_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ba eim ek yi nipi enim ngumba, ‘Enim jiłi wumb, na enim piinand. Enim oł kis ełmin wumb, na moł konu kunerei!’ ");
INSERT INTO nii_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ba enim molk ke ningii ni, Eiparam ni, Aisak ni, Jeikop ni, Gos ek ka ni tor kindiłim wumb pei Gos konu sinim tep enim konu ełe, tuk mułngii ei keningii. Ba en enim mon, si kindik torung mułngii. Molk kin, en enim gupu mong kongk kin ke nik mułngii. ");
INSERT INTO nii_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pe wumb konu eni tonu onum konu wumb ni, eni mani punum konu wumb ei ni, ei orung wumb ni, mer mani orung wumb ni, wumb ei tonu ok, Gos sinim kin tep er mołum konu peł ełe, kuni owundu nok er mułngii. ");
INSERT INTO nii_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Keimi! Pe wumb kombur en enim ekii se omun ni erngii wumb ei, nga ok kumb se pungii. Wumb kombur pe o kumb se bin ni erngii wumb ei, am ekii se mendpił ongii. ");
INSERT INTO nii_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kunum ełe mendpił lo ek piik niłmin wumb kombur ok, ek yi ninjing, “Nim konu ełe si kindkin, konu eipi endi ełe pui! King Eros nim tumba enim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jiisas ek nipi orung kindim, “Enim eim kanik ek ningii, ‘Piimin! Akip min, topuł endi, gui kis ei na to tor kindip, ening pimba wumb ei, er ka erip, ermbii. Toi na kongun poru nimba. ");
INSERT INTO nii_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ei yi mił, pe min, topuł min, tał kunum na andip kongun ermbii. Ei nimbił erang wumb, wu endi Gos oł ekii se ermba oł, ei piik niłmin wu, endi to kundngii ei, Jerusalem konu tu wuk minj, to kundngii. ");
INSERT INTO nii_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O Jerusalem konu ełe wumb! Jerusalem konu ełe wumb! Enim wumb Gos nge ek keimi nik oł ekii se ermba oł ei piik nik ełmin wumb, ei enim to kundmun. Gos kindiłim wumb ei ku tok yi ełmin. Kunum kunum na enim kei kultu mam wał ombu sipi eim kong mandring kindiłim mił, na enim yi ermbii; ba en enim mon niłmin. ");
INSERT INTO nii_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Piinmin! Gos enim konu owundu si kindpi, enim to anda kindim poru nim. Na enim kanip nind, ekii se na enim kinarik, ek yi ningii, ‘Wu endi Gos owundu nge embe ełe om wu ei, eim embe ambił tonu kindamin,’ ningii ei, enim na kinerngii mon.” ");
INSERT INTO nii_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kor kunum endi, Jiisas pupu lo ek ekii sik ełmin wumb nge wu num endi ngii konu kuni num ni, Jiisas eim ermba oł ei kanik kui erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wu endi simb ni angił ngenj ombu pei oupu mułum wu ni, Jiisas mułum konu ełe mandi opu mułum. ");
INSERT INTO nii_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jiisas wu ei kanpi kin, ek nipi, wu lo ek piiłmin wu kin lo ek ekii sik ełmin wumb kin wu ombu kii sim, “Sinim lo ek kapłi ninim ni, kor kunum wu ei endi ening pimba er ka ermin min mon?” ");
INSERT INTO nii_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ba en enim ek tinarik mulnjung. Mułangin kin, Jiisas wu ni sipi, er ka er kindang pum. ");
INSERT INTO nii_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Pe ek nipi yi nim, “Enim mołmun konu ełe wu nii endi eim kingam endeim mułmba min; wu endi eim kung kou ni endi pupu kin noł tukpu ełe mani pupu pimba ei, kor kunum kapłi sikir sipi kin, tonu simba min mon?” ");
INSERT INTO nii_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pe wumb en enim eim nim ek ei ni orung kindnenjing. ");
INSERT INTO nii_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jiisas mołpu kenim ni, wumb kuni owundu ngungii onjung. Wumb ei pe kumb se ełe konu ka wii mułmun ni piinjing, yi kanpi Jiisas eim ek ekin endi nipi, yi nim. ");
INSERT INTO nii_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wu nii eim amb simba pendpi nim kunum ełe; ‘Oi!’ nimba. Ei nim pukun peł kumb ełe mulenjii. Mułang kin, wu owundu endi wii tangin kin, opu peł kumb ełe mułang, nim enjii mił nenj? ");
INSERT INTO nii_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nim ‘Oi!’ nin wu ni, opu yi nim, ‘Nim peł kumb ełe sim peł ei, ya wu ei ngui!’ nimba. Yi neng kin, nim singambił owundu peng kin, pukun buł morung peł ełe mulnjii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ba wu endi nim wii topu, kuni numbuł oi nikin, nim pukun, buł morung peł ełe mulnjii. Wu endi wii topu opu nim kanpi yi nimba, ‘A— na wu puł, nim ya peł tonu ełe mułii!’ nimba. Yi neng kin, nim embe tonu pang kin, wumb pei ningił ełe kuni ende nunjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Ei yi mił, wu endi eim embe ambił tonu kindmba wu ei, wu eipi endi wu ei nga to mani kindmba ku; ba wu endi eim embe to mani kindmba wu ei, wu eipi endi eim embe ambił tonu kindmba.” ");
INSERT INTO nii_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Pe wu ei kanpi kuni owundu ngumbii oi nirim wu ei, ek yi nim, “Nim kuni owundu endi en kin, angnim noł ni, wu puł ni, ninim tiłap ende wumb min, konu ende wumb ku pei simba wumb ei min, pei kan ninenjii! Yi en kin, ekii se wumb ei nim wii tangin kin, nim pan kuni nunjii kuni ei, nga ngo orung kindngii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","“Mon! Pe nim kuni owundu endi en kin, pukun wumb epi sinerang kaimb wii mołmun wumb ni, wumb ningił kis mułum wumb ni, wumb simb angił kis mułum wumb ni, wumb ening peng pimba wumb ei nge ninjii!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","“Pe wumb ombu nge nim kuni owundu ngunjii wumb ei, nga ngo orung kindnerngii! Nimbił erang ei ninim ekii se Gos epi ei ngo orung kindmba kunum ei, wumb kun ka molk wumb ei, nga angk, tonu konj ongii kunum ei, Gos nim epi ka ngumba.” ");
INSERT INTO nii_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pe tuk ełe wu endi en enim kuni endi no mulnjung wu ei mołpu, piim ni, Jiisas ek nim ek ei piipi, ek yi mił ngum, “Wu endi Gos sinim tep er kanpi mołum konu ełe, wu endi kuni konu ełe nopu mułmba wu ei, ka piyangłi!” nim. ");
INSERT INTO nii_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jiisas wu ei ek nipi ngum, “Wu endi eim kuni owundu endi er sepi kin, wumb pei tung kindim wumb ei, kuni owundu ełe ngungii ongii. ");
INSERT INTO nii_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pe kuni nungii kunum ei, eim kuni er kun er sepi kin, eim kongun wumb kindang, puk ok, eim kan nirim wumb ei wangin kin, ‘Kuni er kun er sep moł,’ nirim. Neng kin, eim kongun wumb puk, ‘Kuni er kun er sim, enim wei!’ pa nik. ");
INSERT INTO nii_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ba eim ek kanpi nirim wumb ei, pei ek yi minj ku nik, ‘Sin omun pinałim ku,’ nik. Wumb endeim opu yi nirim. ‘Na aka pin konj endi top enj ei, pup kenmbii pałim. Na ombii pinałim, ei kapłi min?’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Nga wu endi ek yi nirim, ‘Na kung kou kongun erngii nge kung engki top er sinj. Na kung kou kongun erngii kanip bii. Na kapłi bii pinałim mon!’ nirim. ");
INSERT INTO nii_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pe nga wu endi eipi ek yi nirim, ‘Na pe minj amb konj sinj kin, na kapłi bii pinałim,’ pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pe kongun wu ni orung pupu, eim wu owundu ni kanpi nirim. Pe ngii arim ni, popuł sipi yi nirim. ‘Nim sikir pukun, konu andłam owundu ni, kembis ni, pei pukun, wumb epi sinerang mułngii wumb ni, simb kis mułmba wumb min, ningił tumbun wumb ni, wumb simb angił kiłip to pum wumb min, wii to sikin, ya na ngii ełe nirik tu wunjii pui!’ ni kindim. ");
INSERT INTO nii_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Pe ekii se kongun wu ni, orung opu yi nirim, ‘Wu owundu, nim nin ek ei na piip enj; ba ond peł kopur wii simba pałim,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nga wu owundu ek dinga nipi kin, eim kongun wu ngum. ‘Nim pukun, andłam owundu nim konu owundu ełe tuk mołmun wumb ei, se kułou to kinan kapłi erim kin, nga konu owundu taring wumb tałip epi ni, wumb mołmun ei ni, tu wunjii ku! Na ngii ełe wumb piki tumba,’ pa nipi, kindang pum. ");
INSERT INTO nii_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘Na nim kanip nind; wumb kumb se kuni owundu nungii pa nir wumb ei, na kuni owundu ełe, kapłi nunerngii mon!’ pa nim.” ");
INSERT INTO nii_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wumb tiłap owundu Jiisas pum konu ełe ekii se punjung. Jiisas kan ak to yi nim. ");
INSERT INTO nii_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Noł ei wakin to si kindnarpi, nga eim noman ełe oł kanim kanim ermbii. Nip, piimba noman ei top mani kindnerim kin, op nanim kongun wu mendpił mulermba mon. ");
INSERT INTO nii_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wu endi eim na kin noman to piipi kin, eim ngenj kumbii sinarpi, kongun dinga enarpi, eim nge ond peri kon sinarpi yi ermba wu ei, na kin ekii se omba ei, na nge kongun wu mulermba mon! ");
INSERT INTO nii_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Nimbił erang enim mołmun konu ełe wu endi ngii olt takpi ei, tonu bii ni piimba wu ei, eim mołpu kin, ngii ei ku nimberii ba ei piipi kin, ermba wu ei, ngii kapłi tekmba min mon? ");
INSERT INTO nii_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ok eim yi ni piinarpi kin, mei ełe ku simin er poru nipi kin, ngii tekmba mił pinerim. Wumb pei wu ei kanik kin, ek kulnjung. ");
INSERT INTO nii_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Pe wumb kanik yi niłmin, “A— wu ei ngii pułngun mond, ba eim tekim ni, ngii ei takpi poru ninerim mon!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pe kang endi eim pupu kin, king endi kin opu ermbii niłim ei, eim mołpu kin, kom sipi piipi kin, kun er pendpi, king ei opu wumb 10,000 pei mendpił mołmun, (kar angił orung mił) ni piipi, eim opu wu 20,000 pei nga mendpił mołmun (kar engki mił) ni seng kin, eim kin ouni pułmun. Pupu kin, eim kom se piipi kin, wu king endi ei topu kindmbii min mon, ni piim. ");
INSERT INTO nii_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pe king endi eim opu wu kaniłim kapłi enałim kin, wu king endi opu wumb sipi, opu konu turii mił mołułum konu ek ni kindpi, ‘Opu enerambił,’ ek ni ka erambił nipi yi niłim. ");
INSERT INTO nii_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ei yi mił ku, enim mołmun konu ełe, wu endi eim epi pei buł ngunarpi mułum kin, wu ei na nge kongun wu mon.” ");
INSERT INTO nii_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Wu endi eim noman ełe epi kanim kanim pei buł ngopu, na kin ekii simba. Nga noman to orung kindpi piim kin, ei eim ep kusa kis mułang kin, kongun endi pinerang si kindinmin mił eim yi mołum. Ep kusa ei epi ka; ba ep kusa singin ei pinarpi nim kin, sinim er ka ermin mił nenj? ");
INSERT INTO nii_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ep kusa ei nge sinim aka pin ełe kindnermin. Nga ep kusa ei nge kung kou enj kin endi kindnermin ku. Ep kusa ei wii si kindmin. Wumb endi eim kom pim kin, ek ei piyangłi!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Oł kis ełmin wumb kin, wumb ku takis siłmin wumb kin, ok Jiisas nim ek piinjing. ");
INSERT INTO nii_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Lo ek piik ekii siłmin wumb kin, lo ek połułmun wumb, en enim yi ninjing, “Wu ei wumb oł kis ełmin wumb kin, kuni ende nonum,” nik ek kis ninjing. ");
INSERT INTO nii_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yi ninjing kin, Jiisas eim ek ekin topu nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Enim mołmun konu ełe wu endi, kung siipsiip 100 pei mułum wu ei, kung siipsiip endeim am ba; ba ei eim kung siipsiip 99 pei wii mondpu, si kindpi pupu kin, kung siipsiip endeim kurmba wu ei, eim kung siipsiip endeim am pum ei, kur kan sipi minj omba. ");
INSERT INTO nii_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eim kurpu andpi kan sipi kin, tu wupu, eim pepił ełe pendpi tu wum. Tu wupu kin, eim ka piipi mołum. ");
INSERT INTO nii_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Sipi tu wupu kin, eim nge puł wumb ni, wumb ngii mandi mołmun wumb ei, wii tang kułou tunjung. Tangin kin, ek nipi ngum, ‘Enim na kin ouni ka piingii! Na kung siipsiip endi am pum; ba nga kur kan sip tu wunj!’ ");
INSERT INTO nii_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na enim kanip nind; yi mił ku, tonu epin konu ełe wumb 99 pei ka mołmun wumb ei, nga noman ak tunerngii ka piingii. Ba oł kis erpi ełim wu endi, eim noman ak tumba ei, tonu epin wumb ka wii owundu piingii,” pa nim. Pe nga ek ekin yi mił nim.” ");
INSERT INTO nii_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pe amb endi eim ku engki se mułmba ei, kom ku endi am ba. Kapłi ei eim dup alam kał pingii, nirikring brum erpi, kur mołpu kin, kan sim. ");
INSERT INTO nii_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Amb ei eim ku kan sipi kin, eim wumb puł ni, ngii mandi mołmun wumb ei, wii top wangin kin, kułou tunjung. Tangin kin, eim ek nipi wumb ngum. ‘Enim na kin ka piik ngungii; nimbił erang na ku ni kan sinj.’ ");
INSERT INTO nii_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Na enim kanip nind yi mił, ‘Epin konu ełe Gos nge enjel pei, wu endi eim oł kis er andiłim wu ei, noman ak topu wang kin, enjel wu ei onum wu ei kin ka nik ka ka piiłmin.’” ");
INSERT INTO nii_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jiisas ek ekin nga yi nim, “Wu endi eim kingam tał mołmbuł. ");
INSERT INTO nii_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pe eim kingam ekii ni, arim kanpi yi nim; ‘Wusa, nim sił epi mok tokun sił ngan kin, na nge epi mił pe simbii,’ pa nim. Pe erinjngił epi ombu mok topu, kingam tał ngum. ");
INSERT INTO nii_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Pe kunum kinan enerang kin, kangi ekii ni eim epi pei sipi kin, konu turii eipi pupu mułum. Mołpu kin, eim ku ni, epi pei sipipi, oł kis erpi, wumb ngopu yi ełim. ");
INSERT INTO nii_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eim epi sipipi, wumb ngopu, yi erpi pang kin, ku poru nim. Neng kin, kumb kuni owundu simba kunum mandi erim. Pe eim epi endi sinerim mon. ");
INSERT INTO nii_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sinerang kin, eim pupu konu ełe wu endi kin kongun eririm. Wu ei eim kindang, pupu kin, kung es tum. ");
INSERT INTO nii_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Wu ei kung eim aka kis ngum. Ngang kin, aka kis ei eim kirim ełe numbii, ni piim. Pe wumb endi eim kin epi endi ngunenjing mon. ");
INSERT INTO nii_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pe eim mołpu piim ni, ‘Na ernan nge kongun wumb ei, kuni pei seng nok er mołułmun; ba na kuni je kułmbii end,’ ni piim. ");
INSERT INTO nii_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Piipi kin, yi nim, ‘Nam ernan kin bii,’ pa nim. Pup kin, eim kanip nimbii, ‘Wusa, na nim kin, Gos kin oł kis enj,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","20","‘Akip na wu ka endi mił onenj; na nim nge kangił pa ninenjii mon; ba na nim kin kongun wu mił mułmbii,’” pa nim. Pe eim angpi kin, eim arim kin pum. Ba eim pupu kin, konu turii ełe mułum. Mułang kin, arim eim kenim. Kanpi kin, eim kingam kaimb sipi piim. Eim kaimb kis piipi kin, eim sikir pupu, eim kingam wunj kangiłpi, gupu to num. ");
INSERT INTO nii_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Pe kangi ni eim arim kanpi yi nim, ‘Na wu ka mon; nim na kangił pa yi ninerii mon! Na nim kin, Gos kin, na oł kis enj,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pe arim ni, kongun wumb kanpi yi nim, ‘Enim puk kin, konduk olt ka wii ni sikir tu wuk kin, kangi ei talk kindei! Kindik kin, eim simb su kindik kin angił dong eim angił ełe kindik, yi eriei!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","‘Puk kin, kung kou wał ka wii endi kanik kin to tu wangin kin, sinim kuni nopun, ka piyamin! Nimbił erang sinim eim onum nipin, ka piimin. ");
INSERT INTO nii_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nimbił erang, na kangi ei koltum ni piinj; ba nga konj mołpu kin nga orung onum. Eim am mendpił pum; ba nga orung onum,’ nik ka piinjing. ");
INSERT INTO nii_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pe eim kingam kumna ei aka pin ełe mułum. Ekii se opu kin, ngii orung ełe mułum. Mołpu piim ni, golang nik, ek ka nik, non enjing, eim piim. ");
INSERT INTO nii_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Pe kongun wu endi wii topu kin, kii sipi yi nim. ‘Ei nimbił oł enmin?’ ");
INSERT INTO nii_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Wu ei ek yi nim, ‘Nim nge angnim ni orung om. Wang kin, nim arnim kung kou wał ka wii endi to koipi kin, kingam om konu ka piipi kuim. Nimbił erang, eim kingam kułum ni piim; ba nga orung wang kin, eim noman ka piipi enim.’ ");
INSERT INTO nii_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ba eim kingam kumna ni popuł sipi, nirik punerim. Punerang kin, arim anda opu, ek ka kombur nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kingam ek nipi arim ngopu yi nim, ‘Kung ngii kinan na nim kin kongun wii minj er moł. Na nim niłin ek ei endi to kindnał mon; ba nim kung meme wał ni, endi na ngonan. Ngan kin na sip nam wu puł ombu ouni kin, kuni nok, ka piik, yi eranmin mon!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","‘Ba nim kinganim ei, nim ngurun epi no poru nipi kin, oł kis erpi, andłam amb kan andpi kin, nga orung wang kin, nin kung kou wał ka wii ei to koin,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Pe arim ek nipi eim ngum; ‘Kangi! Kunum kunum nim na kin molkun, na epi ombu pei nim tep er mołułun. ");
INSERT INTO nii_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ba pe sinim ka piipin kin, noman ka simba. Nimbił erang, ninim angnim koltum ni piinjpin; ba konj mołpu kin, nga orung onum. Eim am pum; ba sinim si orung sinmin,’ pa nim.” ");
INSERT INTO nii_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jiisas ek nipi, eim er se andiłim wumb ngum. Ngopu kin, yi nim, ‘Wu endi ku pei sałiłim wu ei eim nge kongun wumb, eim epi pei wu endi tep mondułum. Nga wumb kombur ok, wu num ei kanik kin, ek kis nik yi ninjing. ‘Nim tep mundun wu ei, nim epi pei wii si kindin,’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pe eim tep kongun wu ni, wii tang kin om. ‘Nimbił erang nim oł ei eran kin na ek ei piind? Nim pukun kin, na epi pei nim kin sałim mił ei nen piimbii,’ pa nim. ‘Nim nga na epi pei ni, na kongun wumb tep enenjii mon,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pe kongun tep er mułum wu ni yi piim, ‘Na nimbił oł ermbii? Wu owundu, na kongun wumb tep muls kongun ei, na tor kindmba ninim; na pup kin, mei akip ermbii ei, na dinga pinałim. Nga wumb kuni kenim nimbii ei, na singambił enim. ");
INSERT INTO nii_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ba nam epi endi ermbii piind oł ei eramb kin, wumb na sik, en enim ngii konu sipngii ei, wu owundu na to tor kindmba kunum ei, na wumb tep mulermbii kunum.’ ");
INSERT INTO nii_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pe eim wumb endeim endeim ni, wii topu yi nim, ‘Enim wu owundu kin epi endi ngo pendngii ei wei!’ nim. Yi neng kin, wu endi ok om. Wang kin, kongun tep wu ei kii sim, ‘Nim epi nipe mił, na wu owundu ei kin ngo pendin?’ ");
INSERT INTO nii_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Pe wu ni yi nim, ‘Na wu owundu kin ming owundu kopung ei nge 100 pei sinj,’ pa nim. Pe tep wu yi nim, ‘Nim sirin pipe ei sin kin, pipe ei nge 50 ming minj pei sikir pułii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ekii se nga wu endi om. Wang kin, kongun tep wu ei kanpi yi nim, ‘Nim na nge wu owundu ei kin, epi nipe mił nim sin?’ Pe wu ni yi nim, ‘Na kuni mong wiis kon 100 pei sinj,’ pa nim. Neng kin, tep wu ni yi nim, ‘Nim pipe sirin pipe ei tu wan kin, nga 80 pei kon minj pulnjii!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nga ekii se wu owundu eim kongun tep er kis mundum wu ni, embe ambił tonu kindim. Nimbił erang, wu ei eim wumb noman ka peng enmin oł mił erim. Ba mei wumb en enim oł kis kanim kanim ei pułe erngii nge noman ka peng, piik kun erik mołmun; ba Gos nge wumb tiłang erang, oł ka er mołmun wumb ei yi mił mon!” Ya mei ełe wumb oł kis ełmin wumb ei nge enmin ei, wumb noman dinga peng, enmin oł erik kin, wumb tiłang ełe mołmun wumb Gos nge wumb ei to mani kindinmin. ");
INSERT INTO nii_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Na enim kanip nind, ‘Mei ełe ku ni epi ei sik, en enim wumb eipi ei ngok, yi erik kin, wumb puł ei tonu ongii. Pe ekii se ku ni epi ei poru nim kin, enim Gos mołum konu ełe puk epi ka wii orung singii. ");
INSERT INTO nii_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pe wu endi eim epi kembis ei kan kun er mołułum kin, epi owundu ei kan kun er mułmba ku. Pe wu endi epi kembis ei, kongun kun er mulerim kin, epi owundu ei kongun kun enermba ku. ");
INSERT INTO nii_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pe enim ya mei ełe epi kis ełe ku ei kan kun er mulenjing kin, wumb nii enim Gos oł epi ngang ei, kan kun er mułngii? Wu endi yi erpi kin, kan kun enermba mon. ");
INSERT INTO nii_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pe enim mei ełe epi ei kan kun er mulenjing kin, Gos ninim ngumba epi ei, wumb ni kapłi yi nimba epi ombu kan kun er se endnjii ei, nii mił endi yi nimba? Ei mon! ");
INSERT INTO nii_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wu endi eim noman dinga piim kin wu ei, mei ełe wumb wu owundu Seisen nge kongun ermba. Yi erim kin wu ei, Gos Owundu nge kongun kunum ende ermba ei kapłi enanim, ei mon mendpił! ");
INSERT INTO nii_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Lo ek piik ekii siłmin wumb en enim ku nin epi noman pałiłim. Pe en enim molk piinjing ni, Jiisas ek ei neng kin, en enim Jiisas kin ek buł morung opu er ninjing. ");
INSERT INTO nii_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ba eim ek ni ngopu yi nim, “Enim oł ka enmin nik, wumb ningił ełe enmin; ba Gos enim noman ełe kaninim. Epi endi wumb en enim embe ambił tonu kindmin ei, Gos ningił ełe oł kis mendpił enmin. ");
INSERT INTO nii_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gos nge ek ka ni tor kindiłmin wumb ek ei ok pirim; nga lo ek ei ok pirim kunum ei, Jon wumb noł pendiłim wu orum; ba Jon kunum ei o purum. Pe kunum ei Gos nge ek ka ei opu, konu orung orung pei punum. Pang ek ei yi mił; sinim Gos sinim tep er mołum konu ei, wumb pei piimin ei, wumb pei konu ełe tuk bin nik, kongun dinga ełmin. ");
INSERT INTO nii_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ekii se muł mei ei poru nimba; ba lo ek ei am punermba mon. Lo ek aninga wii kopur ku am punermba, ei mon! ");
INSERT INTO nii_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wumb pei en enim amb si kindik, amb eipi sik, wu eipi amb ei wunduk yi enmin. Pe wu endi eim ambim si kindrim amb ei, nga wu endi eipi sim oł ei, amb sinmin lo ei wu ei to kindpi kin, amb wundpu mił sim.” ");
INSERT INTO nii_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ok ku ni epi pei sałiłim wu endi multum wu ei, eim konduk ka wii minj kindiłim. Wu ei kon kundii ka wii, wu king mił kindiłim; nga kunum kunum eim kuni ka minj nołum. ");
INSERT INTO nii_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Wu ku sałiłim wu ei, ngii ondu ełe, wu endi epi sinałim wu endi mułum. Wu ei eim ngenj ełe mong mołpu kin, toru mił pei mułum wu ei embe Lasaras. ");
INSERT INTO nii_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Wu ei eim piiłim wu; ku ni epi pei sałiłim wu ei kuni nang kin, kuni ełim ni, kuni mend ei eim numbii ni piiłim. Nga owu ok eim ngenj tonu o mułum ei, anmbił kin pen siłmin. ");
INSERT INTO nii_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ekii se wu endi epi sinałim wu ni kułum. Kułang kin, Gos nge enjel ok kin, eim sipik, Eiparam kin ende mundnjung. Pe nga wu ku ni epi pei sałiłim wu ei kułum. Kułang kin, sik tukpu to pendnjing. ");
INSERT INTO nii_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pe wu ku ni epi pei sałiłim wu ni, dup konu kis ełe mołpu kin, ngenj kumbii owundu sipi mułum. Mołpu kin, tonu kind kenim ni, Eiparam mułum konu ei turii mił mułang kin, Lasaras mandi mułang kin, ouni mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pe wu ku ni epi pei sałiłim wu ok ku ngenj ełe peng no endrim wu ni, wii dinga topu yi nrim. ‘Ernan Eiparam! Nim na kaimb sikin, Lasaras kindan eim angił ei noł kindpi tu wang kin, na anmbił ełe kindang jii nimba. Na ya dup ełe ngenj kumbii owundu piind,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ba Eiparam yi nim, ‘Kingnan, na nim piikin ok ninim konj multun kunum ei, nim epi ka kankin si nołun; ba Lasaras epi kis minj nołum. Ba akip kunum ełe, eim noman ka seng mułang kin, nim ngenj kumbii owundu piin,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","‘Epi endi eipi yi pałim ku. Sin mołmun konu ei, enim mołmun konu ei, Gos duł owundu endi sałim duł ei, wumb ya mołmun wumb ei, enim mołmun konu ełe onerngii mon! Nga wumb orung mołmun wumb ei, nga ya sin mołmun konu ełe, onerngii mon ku!’ ");
INSERT INTO nii_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pe ok wu ku nin epi sałiłim wu ni yi nim, ‘Ernan, na nim kanip nind. Nim Lasaras kindan pupu, na ernan ngii konu ełe ba,’ pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","‘Na engnan noł angił orung pei mołmun ei Lasaras pupu, ek dinga neng kin, piingii. Mon peng kin, engnan oł ei noman ak tunenjing kin, na ya ngenj kumbii sip ei moł konu ełe, ongii ku, ei mon!’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ba Eiparam yi nim, ‘En enim Gos ek ka ni tor kindiłmin wumb nge ek ni, Moses nge ek ei sałim, min mon? Seng kin, ek ei piingii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pe nga wu ni yi nim, ‘Wusa Eiparam! Ei kapłi enermba mon! Wumb koltmun wu ei endi pupu nimba, ei kapłi piik kin, noman ak tungii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pe nga Eiparam ek nipi wu ei ngum, ‘Pe Moses kin Gos ek ka ni tor kindiłim wumb nge ek poł ei piinenjing kin; nga wumb kułii mer tukpu ełe angk tonu ok ningii ek ei, pii gii ninerngii mon ku.’” ");
INSERT INTO nii_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pe Jiisas eim er se andiłim wumb kanpi yi nim, “Epi kanim kanim tonu omba ei je erang, wumb oł kis erngii. Ba wumb endi kis ei erang, wumb oł kis je erik mulnjung. Wumb endi oł kis erim wu ei, epi kis eim kin tonu wang kin, eim kaimb er mułmba. ");
INSERT INTO nii_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","Mon peng, wu ei mołpu, wumb kombur pii gii dinga pinałim wumb ei kin, oł kis erpi mułmba. Enim ku owundu endi sik kin, wu ei num goltum ełe kan to pendik sipik, ep noł ełe kindei!” nim. “Yi erangin kin, eim oł kis wu endi, wumb pii gii dinga pinałim oł kis je erngii ei, enermba, mon mendpił! Ei en enim kan kun er mułngii! Pe nim angnim oł kis enim kin, nim eim ek dinga ngunjii. Nga eim noman ak tum kin, eim oł kis erim ei ni, ka enjii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","“Pe wu endi eim nim kin oł endi kunum angił orung nga tał pei erim kin, nga wu ei, orung opu, noman ak tumbii nim kin opu, kunum angił orung nga tał ermba. Yi erim kin, nim eim oł kis erim ei, kil ngo, ka enjii.” ");
INSERT INTO nii_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nga Jiisas nge ek se andiłmin wumb, Owundu kanik yi ninjing, “Nim sin pii gii je erang opu kin, dinga pimba,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pe Owundu yi nim, “Enim pii gii pałim ei, kuni ‘Maser,’ niłmin, mong kembis wii mił yi pim kin; pe enim ond mong owundu tołum ond ei kanik yi ningii. ‘Nim puł pei pir pukun, ep noł peł ełe, nga polkun piinjii!’ Nengin kin, ei kapłi; enim ek ningii mił, ekii se sipi, piipi ba.” ");
INSERT INTO nii_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Enim konu ełe wu endi mołpu kin, eim wu kongun wii ełim wu ei, eim kindang pupu, kung siipsiip es tołum min, kongun mei ełe akiłim min, er andpi wang kin, eim mołpu yi nimba. ‘Nim sikir wa! Kuni nunjii wa!’ nimba min? ");
INSERT INTO nii_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Min pe eim kin ek yi nimba; ‘Nim, na kuni er kun er sekin kin, ninim kan takin kin, na kuni si mengkin tu wunjii. Tu wan kin, na kuni kin noł ok namb; nga nim kuni kin noł kin ekii se nunjii.’ ");
INSERT INTO nii_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wu endi eim kin kongun wii er mołułum wu ei, oł ka enim kin eim ka piipi ngumba min? Ei mon! ");
INSERT INTO nii_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Yi pałim ei enim yi ku. Enim Gos ek nimba mił ei erngii ei kapłi; ba enim yi ningii, ‘Sin kongun wu wii, sin kongun ei minj enmin.’” ");
INSERT INTO nii_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jiisas eim Jerusalem konu andłam ełe andpi pum. Pupu kin, Sameriya ni konu Galilii konu ełe tuk pum. ");
INSERT INTO nii_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pe eim opu konu endi tor wang kin, ngenj kinj bumbłum tum wu engki ok, eim kan sinjing ei, en enim konu turii mił engnjing. ");
INSERT INTO nii_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Angk kin, ek nik wii dinga tok yi ninjing, “Jiisas tep wu owundu! Nim sin kaimb sinjii min?” ");
INSERT INTO nii_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pe eim en enim kanpi yi nim, “Enim puk, kułmał kałiłmin wumb mołmun konu ełe ngenj andan tungii. Tangin kin, kułmał kałiłmin owundu enim kin kułmał kełangin kin wumb pei keningii.” Yi neng pangin kin, en enim ngenj ei opu, ka erim. ");
INSERT INTO nii_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pe kinj bumbłum tum wu mulnjung konu ełe, wu endi eim kenim ni, eim ngenj ka seng kanpi kin, sikir orung pum. Pupu kin, Gos embe ambił tonu kindim. ");
INSERT INTO nii_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Wu ei pupu, Jiisas simb ełe gopsing pii poł mołpu kin, “Jiisas! Nim oł ka en!” pa nim. Wu ei eim Sameriya konu ełe wu. ");
INSERT INTO nii_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pe Jiisas wu ei kanpi, yi nim, “Na piip mił, wu engki kinj bumbłum tum ni piinj; ba wu angił orung nga kapił kapłi kombur jiłi mołum? ");
INSERT INTO nii_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pe wu kombur ok, Gos embe ambił tonu kindngii onanmin? Ba ya wu konu eipi wu ei, mendpił om min?” ");
INSERT INTO nii_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pe eim kanpi, ek nipi ngum, “Nim angkin po! Nim nge pii gii je erang, er ka enim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pe lo ek piik siłmin wumb Jiisas kii sinjing, “Kunum ngenj Gos opu, sinim tep erpi omba?” Pe Jiisas ek nipi, orung kindpi yi nim, “Gos opu sinim tep ermba kunum ei, omba oł ei, enim ningił ełe kinerngii mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“En enim piinmin! Wumb ek yi ninerngii, ‘A ya ełe mołum, mon orung mołum,’ yi piinmin. Gos sinim ya tuk tep er kanpi mołum.” ");
INSERT INTO nii_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jiisas eim nge er se andiłim wu kanpi yi nim, “Enim nge noman ełe ek dinga piingii. Pe mei mani nga opu wu kingam ei, omba oł ei kenmin; ba enim kan sinerngii mon! ");
INSERT INTO nii_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Enim mułngii konu ełe wumb yi ningii, ‘Orung ełe mołum, a mon ya mołum. Ya onum, mon wuł onum, mon ał ełe onum.’ Yi nik erngii ei, enim piik, ekii sik punerngii, mon! ");
INSERT INTO nii_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ei yi mił ełim, kupu tiłang enim, ei tonu, wuł, ał pułum. Pe wu mei mani, nga wu kingam opu mei ełe wu kingam tełim wu ei, eim omba kunum ei, sikir wang kin, wumb pei keningii. ");
INSERT INTO nii_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ba ok wu ei, eim ngenj kumbii sipi erang kin, akip kunum ełe mołmun wumb, en enim wu ei kin, buł ngungii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ok Nowa kanu mulk wumb oł yi tonu orum mił; nga ekii se, wu mei mani nga opu, wu kingam tełim wu ei, yi ku erngii. ");
INSERT INTO nii_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ok wumb pei yi erik puk, amb ngok, amb sik, kuni nok, noł nok, yi er pangin kin; Nowa eim noł kanu owundu ełe tuk purum kunum ei, wumb pei kulnjung poru nim. ");
INSERT INTO nii_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Nga Los multum kunum ei, wumb yi erik ku. Noł nok, kuni nok, kongun erik, epi emb talk erik, ngii takik, epi top erik sipik, nga wumb eipi kin ku sik, yi erik. ");
INSERT INTO nii_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ba Los eim Sorom konu ei si kindpi purum ei, dup kin ku sulpa ni, ei konu kumb mił, muł ełim epi ei, Gos kindang orum. Opu kin, wumb pei to kundrum. ");
INSERT INTO nii_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pe yi ku, mei mani nga opu, wu kingam mołum wu ei, tor sikir omba kunum ei, oł yi ku ermba,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Kunum ełe, wu endi ngii tondrung mołpu; nga mani opu, nirikring eim epi simbii nipi omba ei, kapłi enermba. Yi mił ku, wu endi eim aka pin ełe mułmba ei, nga orung pupu, ngii konu epi endi sinermba mon! ");
INSERT INTO nii_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Enim Los ambim erim oł ei piingii. Amb ei ak to kan orung kind kanpi kin, eim ku mił połpu angrim. ");
INSERT INTO nii_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Wu endi eim noman konj kunum kunum mołpu kin, eim sipi orung simbii ni ermba wu ei, eim noman konj am ba. Pe wu endi eim nge noman konj ambił gii ninarpi, mułmba wu ei, eim ekii kunum kunum ka mułmba. ");
INSERT INTO nii_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na enim kanip nind. Akip kunum ełe, wu tał ngii endeim ełe or pingił ei, Gos wu endi sipi, endi pindang pimba. ");
INSERT INTO nii_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pe nga amb tał eł ełip, aka pin kongun ouni ełmbił ei, Gos amb endi sipi kin, endi mundang mułmba. ");
INSERT INTO nii_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Pe wu tał pani pin ełe mułnguł ei, Gos wu endi sipi kin, wu endi mundang mułmba.)” ");
INSERT INTO nii_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jiisas eim nge kongun wumb ek ei piik, kii sik yi ninjing, “Owundu, epi ei er omba mił nenj?” Pe Jiisas ek nipi, orung kindpi yi nim, “Wumb min epi endi kołpu pałim konu ełe, kei sikapi puk, kułou tok mołułmun. Yi mił ku, mei mani opu wu kingam tałpi mułum ei, sikir tor omba kunum ei, wumb pei eim keningii.” ");
INSERT INTO nii_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jiisas ek ekin endi nipi, er se andiłim wumb ngum, “En enim kunum kunum enim prei erik kin, enim ten kulk yi enerngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Eim ek yi ni nim, “Konu owundu kos piiłim wu endi mułum wu ei, Gos kin men tunałim. Nga eim wumb kin kaimb piinałim ku. ");
INSERT INTO nii_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Amb endi wam kultum amb ei, konu ełe mułang kin, kunum kunum amb ei opu, yi niłim. ‘Na nga opu orung wumb ei onmun. Nim na paki tokun kin, na kin kos piinjii,’ pa niłim. ");
INSERT INTO nii_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kos piiłim wu ei ok, ‘Nam amb ei paki tunermbii,’ ni piim. Nga eim noman ełe yi piim ei, ‘Gos kin mund mong kulermbii; nga na wumb ombu kin piinermbii ku,’ niłim. ");
INSERT INTO nii_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","‘Ba amb ei wam kultum amb ei, na kin kongun owundu ngołum ei, na eim kos ełe paki top nimbii,’ pa nim. ‘Kos piineramb kin, kunum kunum wang kin, na piip kis piimbii,’ ni piim.” ");
INSERT INTO nii_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Pe Owundu ek yi nim, “Enim kos piipi kun ełim, wu kis ei, nipi ek ninim ei, enim piyei! ");
INSERT INTO nii_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nimbił erang Gos eim nge wumb sipi, mundum wumb ei, kunum kunum epin, tinga pei, Gos kin ke minj nik mołmun. Gos wumb ombu kos ełe paki tumba min mon? Pe eim kunum kinan er mołpu kin, ekii se paki tołum min mon? ");
INSERT INTO nii_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Na ek nip enim ngond. Gos eim wumb ombu sikir paki tumba. Ba ekii se, wu mei mani opu wu kingam wu ei, ekii se opu kenmba; ya mei ełe wumb pii gii nik, prei erik, er mułngii min mon? Ei opu kenmba.” ");
INSERT INTO nii_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wumb kombur en enim yi piinmin, “Sin oł ka erpin pii gii nipin mołmun,” ni piiłmin. Piik kin, wumb kombur ei, wumb kis mołmun nik piiłmin. Ba Jiisas ek ekin topu, wumb ei ngum. ");
INSERT INTO nii_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ngopu yi nim, “Wu tał Gos kin prei erngił, pendkił pukuł, men ngii owundu ełe tuk punjnguł. Wu endi ku takis siłim wu, nga wu endi lo ek ekii sipi ełim wu, wu tał punjnguł. ");
INSERT INTO nii_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pe lo ek ekii sipi ełim wu ei eim eipi pupu angpi, prei yi erim, ‘O Gos, na wu kombur mił mon. Na nim kin ka piip ngond. Nga wumb epi waning sik erik, oł kun enarik kin, amb wam mołum ei wunduk enmin oł ei, na yi enał mon! Pe na ya wu ei ku takis sipi ełim wu ei mił, na mon ku. ");
INSERT INTO nii_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Kunum kunum kongun endeim tuk ełe, kunum tał ni ku, na kuni nonarip mowii peł. Pep kin, kuni ni epi pei ei mok top engki erip, eipi epi kandip, endeim ni ku nim ngoł.’ ");
INSERT INTO nii_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ba ku takis siłim wu ei, eim konu turii engim. Angpi kin, ei epin konu kinerim mon! Nipi kin, eim pepił ełe topu ek nim, ‘O Gos, na oł kis eł wu. Gos nim na kaimb se!’ a nim. ");
INSERT INTO nii_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na enim kanip nind; wu ei ku takis siłim wu ei, Gos nge ningił ełe wu ei, kun mołum; ba lo ek ekii sipi ełim wu ei mon. Wu endi eim embe si tonu kindmbii ni ermba wu ei, Gos wu ei to mani kindmba. Ba wu endi, eim embe to mani kindmbii ni ermba, Gos wu ei, eim embe ambił tonu kindmba.” ");
INSERT INTO nii_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pe kangił kembis Jiisas mułum konu ełe to wangin kin, Jiisas angił tonu peng ełe kindpi, ek kengip ngumba ni tu wunjung. Ba Jiisas nge ek se andiłmin wu ombu kanik kin, wumb ek ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pe Jiisas kangił kembis ombu wii topu, mandi sipi, ek yi nim, “Enim kangił kembis ei kun erangin kin, na moł konu ełe wangin kin, Gos sinim tep erpi mołum oł ei, wumb pii gii pim kin, kangił mił yi Gos oł ei sinmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","“Na ek ei keimi nip enim ngond. Gos sinim tep er mołum oł ei, tuk ba, ei kangił yi mił; wu endi ek ei pii gii ninenim kin, Gos sinim tep er mołum konu ełe tuk punermin, mon!” ");
INSERT INTO nii_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pe Jura wumb nge wu num endi Jiisas kin kii sipi, ek ni ngołum. “Wu ka wii, na noman konj sip kunum kunum er mułmbii mił nenj?” ");
INSERT INTO nii_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Pe Jiisas ek nipi ngum, “Nim na wu ka wii nin; ba Gos endeim mendpił ka wii mołum. Nimbił erang nim ek yi mił nin? Nim kan kun erkin piinjii. ");
INSERT INTO nii_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Gos kengip ek Moses ngurum ek ei nim piiłin. Ek yi niłim, ‘Ek kend tokun ninenjii; nim epi wangin enenjii; wumb to kundnenjii; amb wam mułmba amb ei wundnenjii; ninim arnim manim ek ningii ei piikin, ekii sinjii.’” ");
INSERT INTO nii_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pe wu num ni ek yi nim, “Na kangił kembis kin moł; pe op wu dinga moł ei, na oł ombu poru ekii sip poru nił,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jiisas ek ei piipi, ek nipi, wu ei ngum, “Nim epi endi sinarpi nim kin, nim epi pei wumb ngokun, nga ku sinjii ku ei, wumb kurpu wii mułngii wumb ei ngunjii. Nim oł yi en kin, nim epi ka wii epin konu ełe sałim epi ei, am punałim mon! Epi ei nim sinjii. Pe nim na ond konu ełe ekii se oi!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ba wu num ni, ek ei piipi, eim noman embin to piim. Nimbił erang wu ei, eim ku nin epi pei sim ei, wakin top si kindip punermbii ni piim. ");
INSERT INTO nii_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jiisas wu ei kanpi yi nim, “Wumb ku pei sałiłmin wumb ei, Gos sinim tep er mołum oł ei, singii ei, kapłi enermba mon! Ba wumb ei kongun dinga erik singii. ");
INSERT INTO nii_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pe kung kamil ya gal alap mui gal tundii ełe mił ondu kembis ei tuk bii ni ermba; ba ei kongun dinga erpi, ngenj kumbii sipi tuk ba pałim. Yi mił ku, wu ku nin epi pei sałiłim wu ei, Gos sinim tep er mołum oł ei, simbii ni ermba; ba eim kongun dinga wii erpi, noman embin sipi, simba pałim ku.” ");
INSERT INTO nii_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wumb ek ei piik, yi ninjing, “Ek mon wu, wumb nii endi epi erpi kin noman konj sipi kunum kunum mułmba?” ");
INSERT INTO nii_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ba Jiisas ek yi nim, “Epi endi wumb erngii kapłi enermba mon; ba ei Gos kapłi ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pe Piisa ek yi nim, “Piini! Sin kongundpun, ngii, mei, amb kangił ni, epi si kindpin, nim kin ekii se onmun.” ");
INSERT INTO nii_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Pe Jiisas ek nipi, eim er se andiłim wu ombu ngum, “Na ek keimi nip, enim ngond. Wumb endi Gos sinim tep er mołum oł ei, kongun paki topu erpi wu ei, eim amb angim noł, arim mam kangił ni, epi pei si kindpi omba. ");
INSERT INTO nii_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Wu ei nga akip Gos epi pei ngo orung kindpi oł ka erang kin, nga ekii se epin konu ka ełe, noman konj kunum kunum sipi, ka mułmba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pe Jiisas eim nge ek se andiłmin wu, engki nga tał sipi, ek yi nip ngum. “Enim kinei! Akip sinim Jerusalem konu ełe tonu punmun. Ok Gos ek ka ni tor kindiłmin wumb ek mon polk, pei yi nik, wu mei mani opu wu kingam mołum wu nik, ek keimi tor omba. ");
INSERT INTO nii_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pe nga Jura wu num kombur eim sik kin, wumb tiłap eipi endi ngungii. Ngangin kin, wumb ei eim kin ek buł morung nik, oł kis erik kin, jipambił tok erngii. ");
INSERT INTO nii_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Erik kin, kepii tok, ond peri ełe to kundangin kin, nga kunum tekliki ełe, nga konj angpi tonu ba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ba Jiisas eim nge ek se andiłmin wumb ei, ek ei pułe pii poł tunenjing. Pe eim ek ei pułe koi erim. Pe eim nge kongun wu ombu, eim ek ei pii kun enenjing. ");
INSERT INTO nii_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pe Jiisas eim Jeriko konu ełe tor wang, wu endi ningił tumbun multum wu ei, andłam wer ełe mułpu kin, wumb ku nin epi ngei, ni multum. ");
INSERT INTO nii_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Pe eim mołpu piim ni, wumb pei onjung. Wangin kin, eim wumb kii sim, “Ei nimbił oł enmin?” a nim. ");
INSERT INTO nii_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pe wumb eim kanik, yi ninjing, “Jiisas Naseres konu ełe wu onum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wu ni wii dinga tum, “Jiisas, nim King Deipis nge miyem ende wu. Pe nim Owundu mołun, na kaimb se!” ");
INSERT INTO nii_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Pe wumb kumb se onjung wumb ei, eim ek ngunjung, “Nim ek tingnar!” ninjing. Ba wu ei, wii dinga nga tum. “Jiisas nim King Deipis nge miyem ende kingam, na kaimb se!” ");
INSERT INTO nii_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jiisas opu angpi, wumb kanpi kin, ek yi nim, “Wu ei, ya tu wei!” nim. Wu ni mandi opu angang kin, Jiisas eim wu ni kii sim. ");
INSERT INTO nii_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na nim kin, nimbił oł ermbii ni piikin nin?” Pe wu ni yi nim, “Owundu, na ningił ei, ka seng, kenmbii nip nind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Pe Jiisas wu ei kin, ek nipi ngum, “Nim ningił ełe tiłang ermba ei, ninim nge pii gii je, er ka enim,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yi neng kin, sikir wu ni, ningił ka seng kenim. Wu ei, Jiisas pum konu ełe, ekii se pupu, Gos embe ambił tonu kindim. Kindpi kin, wumb en enim oł ei, kanik kin, Gos embe ambił tonu kindnjing ku. ");
INSERT INTO nii_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jiisas Jeriko konu ełe tor pupu, nga bii ni pum. ");
INSERT INTO nii_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wu endi mułum wu ei, embe Sakiyas. Wu ei, wu ku takis siłmin wumb ei, tep er mołułum. Wu ei, eim ku nin epi pei sałiłim. ");
INSERT INTO nii_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Eim Jiisas kenmbii ni piim; ba wumb pei onjung. Sakiyas eim wu osii peng kin, Jiisas kenmba mił pinerim. ");
INSERT INTO nii_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pe eim sikir kumb se pupu, ond endi ‘Sikimor’ niłmin ełe, tonu pum. Pupu, mołpu kin, Jiisas andłam ełe, omba kenmbii ni mułum. ");
INSERT INTO nii_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pe Jiisas konu ełe tor opu, kan tonu kindpi yi nim, “Sakiyas, nim ond si kindkin sikir mani wa! Akip na nim kin mułmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pe eim ka piipi, sikir mani om. Opu kin, Jiisas sipi, eim ngii konu ełe sipim. ");
INSERT INTO nii_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Pe wumb pei kanik kin, ek kis ninjing. Nik kin, yi ninjing, “Jiisas eim wu kis ei kin, or pimba punum,” ninjing. ");
INSERT INTO nii_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pe Sakiyas eim opu wumb kumb ełe angpi, yi nim, “Owundu, akip na epi pei kułou to mondup kin, epi orung sip, wumb epi sinałim wumb ei ngumbii. Nga orung sipip, wu endi kin epi waning erir konu ełe, wu ei kin, kunum kapił kapłi sipi, ngo orung kindmbii,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Pe Jiisas eim ek nipi ngum, “Akip nim ni ninim nge wumb, ya ngii ełe mołmun wumb ei, Gos sipi, orung sinim,” pa nim. Pe nga ek nipi, wumb ngopu yi nim, “Pe wu ei Eiparam nge tiłap ende wu. ");
INSERT INTO nii_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wu mei mani opu wu kingam tełim wu ei, wumb am punjung ei, sipi orung simba nge om.” ");
INSERT INTO nii_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Wumb ek ei piyangin kin, Jiisas nga ek ekin topu ngum. Nimbił erang Jiisas eim Jerusalem konu ełe mandi om. Wumb yi ku ni piinjing ei, Gos sinim tep er mołum oł ei, mandi tor omba enim, ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Piyangin kin, eim ek ekin yi nim, “Wu Owundu endi konu turii endi pupu, king owundu mundangin mołpu kin, nga orung omba nge punum. ");
INSERT INTO nii_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wu owundu ei opu kin, eim ku engki mił sipipi, eim kongun wu engki wii topu, ku ngond ei sik, kongun erik mułngii. Mułangin kin, “Na nga orung ombii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wumb konu ende wumb ei, wu owundu kin kis piinjing. Piyangin kin, wu owundu ei, eim si kind pendpi pum. Pang kin, wumb kombur ekii se punjung. Puk kin, yi ninjing, “Sin wu ei king mulermba,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ba mon, wu ni king mundangin kin, nga si kind orung om. Opu kin, yi nim, “Na ok ku ngunj wu ombu, wii tangin wangin,” pa nim. “Na piimbii, kongun erik ku nimberii orung sinjing ei, piimbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Pe wu endi kumb se opu yi nim, “Wu owundu, nim ku endeim mił na ngun ei, na kongun erip pup kin, kum endeim nga sinj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Pe king ni yi nim, “Nim kongun wu ka, nim kongun ka en. Nim epi kembis ei tep ka en ei akip na nim kindamb pukun, konu ełe owundu orung orung sałim ei, konu engki pei tep enjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nga kongun wu endi opu yi nim, “Wu owundu, nim ku endeim mił na ngun ku ni, kongun er piip kin, ku angił orung mił sinj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Pe wu owundu yi nim, “Na nim kindamb pukun kin, konu ełe owundu angił orung pei tep er mulnjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pe nga kongun wu endi om. Opu kin, yi nim, “Wu owundu, nim ku endeim mił ni, ya alap kin kum to pendinj pałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","“Nimbił erang na nim kenj ni, nim wu wumb kin ek nikin ełin. Na kanip kin, nim kin mund mong kuls. Nim wumb eipi epi siłin, nga kuni wumb eipi kuni ei siłin.” Nga epi eipi nge nim sikin yi ełin. ");
INSERT INTO nii_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pe king ei ek dinga nipi, kongun wu ei ngum, “Nim kongun wu kis, ninim nin ek ełe, na nim kos er ngumbii. Keimi nim piin; na wu wumb kin ek dinga nip erip, epi wumb eipi nge ei pup sip kin, kuni wumb eipi nge sip ełe nin min? ");
INSERT INTO nii_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nim na ku ei mer ku beng ełe tuk kind sen ełe, kongun er pukun, na ku endi seng, nam op kin, simbii ei, nimbił erang kindnen?” ");
INSERT INTO nii_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wumb mandi mulnjung wumb ei kanpi yi nim, “Enim wu ei, ku endeim mił ei, sik sipik, wu endi ku kum endeim sałim wu ei ngei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Pe wumb yi ninjing, “Owundu, ei wu ku kum endeim sim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Eim ek yi nim, “Na enim kanip nind. Wu endi epi pei simba wu ei, epi nga na epi pei eim ngumbii. Nga, wu endi eim epi kembis simba epi ei, na sip orung simbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ba pe wumb na kin opu orung er nik, ‘Sin kin king mulermba ninjing wumb ei, na ya ełe kumb ningił ełe tu wuk, to kundngii!’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jiisas ek ei nipi pendpi, eim andłam ełe ok andpi pupu kin, Jerusalem konu ełe tor pum. ");
INSERT INTO nii_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Pe eim pupu, Bespeis ni, Besanii konu ełe mandi opu, komung endi, ‘Olip,’ wumb yi niłmin, konu ełe tor pum. Pupu kin, eim nge ek se andiłmbił wu tał kindang, kumb se punjnguł. ");
INSERT INTO nii_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Eim wu tał kanpi, yi nim, “Ełip konu orung ełe peł. Pukuł kin, konu endi tuk pu keningił ni, kung dongkii wał endi, kan kuł kindnjing pałim ei ok wumb mulenjing kung dongkii ei, kan pos si mengkił, tu weł!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“Wu endi ełip kii sipi, ‘Kung dongkii ei, nimbił erngił enmbił?’ Yi nipi nim kin, ełip yi ningił, ‘Sił Owundu ei, kongun peng tu weł neng, enmbił pa ningił,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pe Jiisas wu tał kindang pukuł, kenjngił ni, Jiisas nim mił yi kenjngił. ");
INSERT INTO nii_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pe wu tał ni, kung dongkii kan pos sikił, pengił. Kung dongkii arim opu, kanpi yi nim, “Nimbił erang ełip kung dongkii wał kan posinmbił?” ");
INSERT INTO nii_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Pe wu tał ni, yi ninjngił, “Sił wu Owundu ei, kongun peng tu weł neng, enmbił,” pa ninjngił. ");
INSERT INTO nii_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pe wu tał kung dongkii ni, Jiisas mułum konu ełe, tu wunjnguł. Pe eł ełip konduk ei sikił kin, tonu kung dongkii ełe sengił kin, Jiisas tonu peł ełe mułum. ");
INSERT INTO nii_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jiisas kung dongkii ełe mołpu pang kin, wumb en enim nge wu Owundu onum ni piik, en enim konduk gulk, andłam ełe sengin pum. ");
INSERT INTO nii_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Pe eim opu, komung Olip ełe mandi mani ba erang kin, pe eim nge ek se andiłmin pei wu ombu, ka ka piinjing. Piik kin, “Sin jep oł pei kenjpin,” nik, wii dinga tok kin, Gos embe ambił tonu kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Pe enim wii dinga tok, yi ninjing, “Owundu nge embe ełe, king ei onum ni, Gos embe ambił tonu kindmba,” nik yi ninjing. “Pe epin konu ełe emin ngo, ka sengłi. Seng kin, nga Gos embe tonu mendpił pangłi.” ");
INSERT INTO nii_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Pe lo ek piik ekii sik ełmin wumb kombur, wumb tuk ełe molk ei, piik yi ninjing, “Ek mon wu Owundu, nim nge ek se andiłmin wu ombu, ek ngo.” ");
INSERT INTO nii_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pe Jiisas ek nipi, orung kindpi yi nim, “Na enim kanip nind. Ek nik wii tok yi enerangin kin, kom ku ombu, kapłi wii tok, ek tengingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jiisas eim Jerusalem konu ełe mandi opu, wumb ombu kanpi kin, ke nim. ");
INSERT INTO nii_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nipi yi nim, “Pe enim oł ka ombu piik, noman emin sek kin, ka piingii. Ba pe epi ombu koi er pałim ei, enim kinerngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","“Ekii se kunum endi tonu omba ei, enim nge opu orung wumb ok, enim mułngii konu ełe sik, pok pok erik, mei akikik, mei ngo tonu kindik monduk, enim kin opu ermin nik, yi erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","“Pe nim kinganim noł ni, nim kin tuk mułngii wumb ei kin, pei to kundngii. Pe ku endi sik, ku endi peł ełe pindnerngii! Nimbił erang enim Gos opu paki tumba kunum ei, pii poł tunenjing,” Jiisas ek yi nim. ");
INSERT INTO nii_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Akip Jiisas eim men ngii owundu ełe nirik pupu, wumb men ngii ełe epi top er mulnjung ei, to tor kindim. ");
INSERT INTO nii_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Eim ek dinga nipi yi nim, “Gos nge ek ełe, yi ninim, ‘Na nge ngii ełe prei ngii simba;’ ba enim erangin kin, ngii kis mołpu kin, ngii ei, koi er seng kin, wumb epi waning erik kin, er kis mondunmun.” ");
INSERT INTO nii_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pe kunum kunum eim wu amb sipi, men ngii owundu ełe, ek emb to ngopu yi ełim. Erang kanik kin, lo ek pułmun wumb ni, lo ek piik ekii siłmin wumb ni, wumb tep ełmin wu num ombu ni, eim to kundngii nge andłam kurnjung. ");
INSERT INTO nii_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ba wumb pei Jiisas eim ek piimin nik, eim endim konu ełe wumb pei endinjing. Pe wu num ombu, eim kin ek endi nik, to kundngii nge andłam endi sinerim, mon. ");
INSERT INTO nii_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kunum endi Jiisas men ngii owundu ełe ek ka nipi, wumb ngum. Pe lo ek piik ekii sik ełmin wumb ni lo ek połmun wumb ni, wu num ombu, nirik onjung ku. ");
INSERT INTO nii_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nga wumb ombu, eim kanik yi ninjing, “Nim sin kankin nei! Nim dinga ei, jiłi sikin okun nin? Nim noman dinga ei, nii ngopu oł ei, erii nim?” ");
INSERT INTO nii_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Pe Jiisas ek nipi, wumb ombu ngopu ek nim, “Pe yi ku, enim na kii sinmin oł ei nge, enim kii simbii. Enim na ek nei! ");
INSERT INTO nii_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jon wumb noł pendiłim oł ei, Gos epin konu ełe dinga ngum min; ya mei wumb ełmin oł ei, dinga sipi erim min?” ");
INSERT INTO nii_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pe wumb en enim yi ninjing, “Sinim ei epin epi pa yi nimin ei, kapłi eim yi nimba, ‘Nimbił erang enim eim ek pii gii ninenjing?’ nipi yi nimba,” yi ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pe ‘Sinim wumb oł minj,’ pa nimin ei, wumb piik kin, Jon Gos ek kan ni tor kindiłim wu nik, pii gii nik, sinim tungii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pe wu num ombu ek nik, Jiisas ngok yi ninjing, “Sin pii poł tunanmin,” pa ninjing. “Jon wumb noł pendiłim wu ei, eim nge dinga konu jiłi siłim?” ");
INSERT INTO nii_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pe Jiisas ek nipi, ngopu yi nim, “Yi mił ku, na enim kanip ninermbii ei, na nipe dinga pałim.” ");
INSERT INTO nii_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pe Jiisas eim ek yi nipi pendpi, ek ekin endi nipi, wumb ngopu yi nim, “Wu endi eim ond mong wain konu ei tełim. Pe ond mong wain konu ei sipi, wumb kombur kongun erngii wumb ei ngang kin, ekii se wumb ei, ond mong wain orung kindngii ni ngum. Ngopu pendpi kin, eim konu turii endi pupu, kunum kinan mułmba pum. ");
INSERT INTO nii_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pe ond mong wain ei nołmun kunum mandi erang kin, ond mong wain arim ei, eim kongun wu endi kindang opu kin, wumb ond mong wain kongun er mulnjung konu ełe om. Pe eim yi ni piim, ‘Kongun wu ombu, ond mong kuni aninga ngangin kin, tu wumba,’ nipi kindang om. Ba wumb kongun ełe er mulnjung ei, kongun wu ei, kepii tok, ek ngok, wii to tor kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pe nga, wu endi nga kindang om. Ba wumb yi ku nga erik, wu ei tok, eim kin oł kis erik, wii pui nengin kin, pum. ");
INSERT INTO nii_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pe nga wu endi kindang om. Ba wu ei, kepii tok, miyem sik, olkup to tor kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pe wumb yi erangin kin, ond mong kuni arim ei, yi ni piim. ‘Na er ermbii mił nenj?’ nim. ‘Pe na kangi endeim ei na eim noman ngoł kangi ei, kindmbii ei, eim kapłi ek nimba ek ei piingii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ba kongun er mulnjung wumb ei, kenjing ni, wu num ni kingam om. Kanik kin, en enim ek nik, piik enjing. Erik kin, yi ninjing, ‘Wu ei, eim arim nge epi eim simba wu ei, sin tamin! Topun kin, ya konu ei, sin sinim kongun er mułmun,’ pa yi nik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pe wu ni ambił gii nik, sipik tor sipik, to kundnjung. Ek ekin top yi nim, ‘Pe wu num ei wumb kongun wumb ei kin, nipe oł ermba?’ ");
INSERT INTO nii_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wu num ei opu, ond mong wain konu ełe kongun enjing wumb ei, pei to kondpu kin, ond mong wain konu ei wumb eipi endi ngumba. Pe wumb en enim ek ekin ei piik kin, yi ninjing; “Mon peng yi enermba,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ba Jiisas eim wumb kan orung kind kanpi kin, ek yi nim. “Ek ei nipe ek Gos ek połułmun ek pułe er piimin min mon? ‘Wumb ngii tekmin wumb ei, ngii tumunj ei si kindik; ba tumunj ei, ngii tumunj ok nge mendpił tonu orum.’ ");
INSERT INTO nii_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pe wumb pei ngii tumunj ełe, bok tunjung kin, wumb glas ming mił tumb tumb ermba; min ngii tumunj ei, mani opu wumb topu nim kin, wumb ei kułngii ngenj kinerngii, kułman mił ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jiisas ek ekin endi nipi kin, kułmał kałiłmin wumb owundu ni, lo ek połułmun wumb ombu, piingii nge piipi nipi ngum. Ngang kin, pe kunum ełe mendpił eim ambił gii ningii mił pim; ba wumb pei mułangin kin, en enim mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Erik kin, Jiisas ermba oł endi koi er kan mulnjung. Mułangin kin, eim oł endi ermba ni kan mulnjung wumb ei, wu kombur kindangin ok, Jiisas eim ek nipi ermba ei, ok kan mulnjung. Ok kan mulnjung wu ombu, ek kend tok, ek kun mił ninjing. Nik, “Eim ek yi nim,” pa nik kin, eim ambił gii nik, ek piipi kun ełim wu, gapman owundu mułum konu epi sipngii enjing. ");
INSERT INTO nii_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pe wumb ombu, Jiisas kii sik, ek ninjing, “Ek mon wu, nim nin ek ei sin piinmin ei ek kun pałim. Pe nim ek kun nikin, wumb ngokun ełin. Pe nim wumb mei ełe wumb pei, kankin ek ei, ek ende minj nikin pułun. Ninim Gos nge ek ei mendpił nikin, wumb ngokun yi minj ełin. ");
INSERT INTO nii_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pe nim er piin mił nenj? Sinim Siisa wu owundu ei kin takis ngumun min mon?” ");
INSERT INTO nii_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ba Jiisas eim oł kend tui ei enjing ei, Jiisas eim piim. Piipi kin, eim ek nipi, wumb ombu ngum. ");
INSERT INTO nii_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Pe enim ku endi na andan tungii. Tangin kin, ku ełe min men endi mołum ei, wumb nii mołum?” Pe wu ombu yi ninjing, “Min men ei Siisa mołum.” ");
INSERT INTO nii_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pe Jiisas ek nipi ngopu yi nim, “Pe enim Siisa nge epi ei Siisa ngungii. Pe nga Gos nge epi ei Gos ngungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wumb pei mulnjung konu ełe, ek neng kin, Jura wu num ombu, kunum endi eim ambił gii ningii pinerim. Eim ek nipi, orung kindim ek ei, piik noman embin tang kin, ek nik orung kindngii pinerang kin, gupu mum to mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Pe wumb kolk nga konj tonu piinarik piiłmin wumb tiłap kombur ok, ek yi niłmin. “Wumb kulnjung wumb ei nga konj tonu punerngii,” niłmin wumb ombu, Jiisas kii sik yi ninjing, “Ek mon wu, Moses lo ek endi yi pultum. ‘Pe wu endi amb sipi, mołpu kin, kułmba ei, eim ambim kangił endi mulerim kin, eim nge angim amb ei simba. Sipi kin, eim angim nge kang ambił mengpi simba.’ ");
INSERT INTO nii_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pe wu endi eim angim noł angił orung nga tał mulnjung. Wu kumna amb sim ei, kangił endi mingnarpi kin, kultum. ");
INSERT INTO nii_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nga angim amb ei sim kin, eim kułum ku. ");
INSERT INTO nii_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kułang kin, nga angim endi sim ei ku, wu ni kułum. Yi mił, wu angił orung nga tał pei, amb endeim minj sik kolk, yi minj er puk. Wu angił orung nga tał pei ok, kangił endi mingnarik kin, kolk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Nga ekii se, amb ei eim mendpił kultum ku. ");
INSERT INTO nii_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pe wumb kułii, nga konj tonu ongii kunum ei, amb ei, wu nii ambim mendpił mułmba? Wu angił orung nga tał, amb endeim ełe sinjing ei, wu nii amb ei, wam mendpił mułmba?’” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Pe Jiisas wumb ei ek nipi ngum, “Wu amb ni, akip kunum ełe, en enim wu amb seng kin, yi enmin. ");
INSERT INTO nii_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Wumb nii endi, Gos kunum ekii se kapłi konj tonu ongii nimba wumb ei, noman konj kunum kunum sik mułngii wumb ei, wu amb sik erngii ei, pii poł tunałmin mon! ");
INSERT INTO nii_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Nga wumb ei, nga kulerngii. Nimbił erang, Gos nge enjel mołmun mił yi mułngii. Gos eim wumb ei tukpu ełe, nga tonu konj sim ei, Gos eim kingam ambiłam noł mułngii. ");
INSERT INTO nii_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pe Moses wumb kułii ei, nga konj ok mułngii, pa yi niłim ku. Gos ok ek ka mer poł pendrim ek ei, Moses ond kembis endi dup nang kenim. Moses Gos Owundu ni, sinim kupenjpin noł ni, ek yi nim. ‘Eim Eiparam nge Gos; Eim Aisak nge Gos, eim Jeikop nge Gos mołum,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pe Gos ei wumb kułii ei nge Gos mon. Ba wumb ok pei konj mołmun wumb ei nge Gos. Eim ningił ełe, wumb pei konj mołmun.” ");
INSERT INTO nii_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Eim ek nipi ngang kin, nga lo ek pułmun wumb ek nik, orung kindik yi ninjing, “Ek mon wu, nim ek ka wii nin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Wumb ei mund mond kulk, nga ek endi kii sik erngii, pinerim. ");
INSERT INTO nii_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ba Jiisas ek nipi wumb ngopu kii sim, “Nimbił erang, wumb molk, Krais Gos wu ei kindang na op wu ei, King Deipis nge miyem ende wu,” pa nimin. ");
INSERT INTO nii_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","“Mer mon Sam ełe Deipis yi nirim, ‘Sin Owundu na Owundu kanpi yi nirim, Nim na angił tundung orung mułii!’ pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Nga ekii se, ‘Nim nge opu orung wumb sip kin, nim simb ełe mani kindmbii,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","King Deipis eim Krais Gos kindang wu ei, eim ‘Owundu’ nirim. Pe nimbił erang, Deipis eim miyem ende wu ninmin?” ");
INSERT INTO nii_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wumb pei molk, eim nim ek ei piinjing ni, Jiisas eim ek nipi, eim nge ek se andiłmin wumb ngum. ");
INSERT INTO nii_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Enim lo ek piik ełmin wumb ei, ek ningii ei, enim piik kan kun erngii! En enim konduk ełe olt endi kindik erangin kin, wumb keningii nik ełmin. En enim yi piiłmin; oł ei erpin, wumb konu kułou tungii ni, wumb men ngii ełe konu ka wii keningii ni piiłmin. Nga kuni owundu ei, sin sinim kumb ełe pu mułamin kin, wumb keningii ni piik, enim embe tonu kindik, yi ełmin. ");
INSERT INTO nii_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pe wumb ei, en enim puk, amb wenjing kołmun amb ei, ngii konu ni, ku ni, epi ombu waning sik; ba wumb kumb ełe prei kinan er puk ełmin. Gos wumb mok tumba kunum ei, wumb ombu kos owundu singii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jiisas eim men ngii mołpu kenim ni, wu ku sałiłmin wu ambił ngołmun wu, en enim Gos nge men ngii ku konu ełe Gos kin noman ka ku kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Pe eim kenim ni, amb endi wam kultum amb ei, epi endi sinałim amb, kurpu endi eim, ku kundii kembis tał, mer Gos kin noman ka piik kindnjing konu ełe, kindim. ");
INSERT INTO nii_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pe Jiisas eim ek nim, “Na ek keimi nip enim ngond. Ya amb kurpu ei, wam kułum amb ei, eim ku kindnim amb ei, enim wumb pei eipi kindnjing ku ei, to mani kindnim. ");
INSERT INTO nii_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pe enim wumb eipi ei, enim ku pei sałim ei, enim epi wii Gos kin ka pii ngonmun. Ba amb ei, eim epi endeim sinałim; ba ei ku tu wupu ngonum. Nga eim kuni simba ku ei, sinałim, mon!” ");
INSERT INTO nii_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","6","Wumb kombur men ngii owundu ełe nik ek ninjing, “Ngii ełe kom ku mon ka wii ngunjung. Nga wu amb Gos kin noman ka epi kindnjing.” Nga Jiisas ek yi nim, “Oł ei pe enim kaninmin ei, nga kis mułmba ei kunum endi simba kunum ei, ku endi tondrung peł ełe pinermba. Pei er kis erpi, konu orung orung pei eipi eipi mani kindmba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Pe wumb eim kii sik, yi ninjing, “Ek mon wu, kunum nenj epi ei tonu omba? Epi ei omba kunum oł endi erang kin, sin kenmin kunum ei, mandi omba, min mon?” ");
INSERT INTO nii_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jiisas eim ek yi nim, “Enim kan kun er mułngii! Wumb kombur ok, enim kin ek kend to ngungii. Ngok kin, wumb pei ok, na embe ei singii. Sik kin, yi ningii, ‘Wu ei na ond kunum mandi enim.’ Nik kin, yi erngii; ba enim ningii ek ei piik, pungii konu ekii se punerngii, mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Wumb tiłap kembis tuk ełe, en enim nginmał enmin ningii, ku. Nga wumb tiłap pei konu orung orung pei opu owundu enmin nik erngii ei, enim piingii; ba enim mund mong tunerngii mon! Oł ombu ok tonu omba; ba kunum poru nimba kunum ei, sikir tonu onermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jiisas eim wumb kanpi ek nipi ngum, “Pe wumb tiłap endi pupu kin, wumb tiłap endi kin ermba. Pe wu king endi nge tiłap ei pupu kin, king endi nge tiłap ełe opu erngii. ");
INSERT INTO nii_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pe konu kopu owundu tonu omba; nga konu kombur kumb kuni owundu sepi kin, wumb ening owundu pimba ku. Nga kupu muł ełe keningii ni, muł ei owundu erpi, oł kanim kanim erang kin, enim mund mong erngii. ");
INSERT INTO nii_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ba epi ombu tonu onerang kin, enim wumb ok, enim ambił gii nik kin, oł embin tui kanim kanim erngii. Erik kin, enim sik sipik, men ngii ełe kos piik kin, nga enim sik, kan ngok, yi erngii ku. Yi erik kin, enim na embe ambił to mani kindmin ni erngii nik sipik, king ngii konu ełe gapman mułngii konu ełe, enim sipngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","“Yi erngii kunum ełe, enim na ek ka ni tor kindngii. ");
INSERT INTO nii_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kunum ełe en enim noman ełe, piik dinga erik kin, nga nipe ek endi ok ni orung kindmin ni, yi piinerngii mon! ");
INSERT INTO nii_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Na nam ek enim ngamb ek ei, keimi ni piik, ni tor kindngii. Enim kin noman ka ngop ermbii, nim. Enim nge opu orung wumb ei, enim ek tok kindik, enim to mani kindmin ni erngii ei, kapłi enermba. Na enim nip ngunj ek ei, kapłi dinga pimba. ");
INSERT INTO nii_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Arnim manim ni, angnim ni, miyem ende wumb ni, puł wumb ok, enim nge opu orung wumb kin ngungii. Ngok kin, kombur en enim mułngii wumb ei, kombur to kundngii ku. ");
INSERT INTO nii_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pe wumb pei enim kin popuł kis singii ei, nimbił erang enim na embe ambił tonu kindngii. ");
INSERT INTO nii_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gos epi ei piinerim kin, enim nge peng enjin ei, endi am punermba mon. Gos wumb pei noman tuk piinim ku. ");
INSERT INTO nii_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Kunum kunum en enim dinga kind er mulnjung kin, kapłi en enim noman konj mendpił singii. ");
INSERT INTO nii_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Ba enim molk kinangin kin, opu wumb ok Jerusalem konu owundu ełe orung orung onjung kin, enim pii poł tungii ei, Jerusalem konu ełe owundu ni, konu er kis mundngii kunum ei, mandi enim ni piik mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","“Kunum ełe, wumb Jura konu ełe mołmun wumb, ei sikir puk kin, tonu komung ełe pungii. Nga Jerusalem konu ełe owundu tuk mołmun wumb ei, tungu puk, konu eipi eipi simba konu ełe pungii. Nga wumb konu orung orung ełe torung mołmun wumb ei, nga konu ełe tuk punerngii. ");
INSERT INTO nii_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kunum ełe, oł kis ełmin wumb ei, Gos wumb ombu kin kumep ngumba ei, mer Gos mon ełe pałim ek ei, pei keimi pimba. ");
INSERT INTO nii_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kaimb kunum ełe, amb kangił am ngopu mułmba min, kangił mułang mułmba amb ei, kaimb er mułngii! Oł embin tui ełe, konu orung orung tonu wang kin, Gos eim popuł sim mił ei, eim wumb ombu kin kos erpi ngumba. ");
INSERT INTO nii_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wumb ei tui pei nopu poru nimba. Nga opu orung wumb ok, kan ngok, konu eipi orung orung pei kindngii. Wumb tiłap eipi simb ei, Jerusalem konu ełe kembngii. Yi er mułangin kin, wumb tiłap eipi kunum ei, Gos to mundum kunum ei, poru nimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Nga tonu muł ełe eni ni, kanjip ni, oi ombu, oł kanim kanim erngii. Mani mei ełe konu orung orung, wumb en enim, oł embin tui peng mułangin kin, ep noł topu, gur gałi nipi ermba ei, wumb piik mund mong erngii. ");
INSERT INTO nii_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Wumb pei en enim mei ełe tonu omba ei, noman embin to piingii. Pe wumb kułmun ni piik kin, noman pepi kun enerang mułngii. Nimbił erang tonu muł ełe oi ni, kanjip ni ombu, ołup, ermba. ");
INSERT INTO nii_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Oł ei tonu wang kin, molk keningii ni, Gos kindang opu mei wu kingam tełim ei, eim kupu peł ełe omba. Opu kin, eim dinga owundu peng kin, nga eim tiłang owundu ka wii ei, erang kin omba. ");
INSERT INTO nii_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nga ekii se, oł ombu tonu wang kin, enim kunum ełe angk, en enim peng kan tonu kanik er mułngii. Nimbił erang, sinim kis mułamin kin, oł embin tui tonu orum ei, Gos sinim paki tumba nge kunum ei, mandi erang orum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nga Jiisas eim ek ekin endi nipi ngopu kin, yi nim. “En enim ond mong pik kanik kin, nga ond eipi pei kanik erei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","“Pe enim kinangin kin, ond ei, onguł konj topu nim kin, konu eni owundu ba, enim nik, yi piingii. Akip kunum ei kuni mong poł tonum. ");
INSERT INTO nii_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Yi mił, enim oł ombu kinangin yi mił erpi nim kin, en enim piingii. Gos sinim tep er mułmba kunum ei mandi omba, enim ni piingii!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Na ek keimi nip enim ngond. Wumb kunum ełe wumb konj mułngii kunum, ei epi ombu tor omba. ");
INSERT INTO nii_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Muł kin mei poru nimba; ba na ek ei poru ninermba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ba enim kan kun er mułngii! Mon pim kin, enim noł kunum kunum nok wulu pang kin, en enim molk, ngenj epi ełe noman piingii; ei mon! Pe enim noman ka peng mulenjing kin, Gos kindmba wu ei, wu kingam omba kunum ei, sikir tor omba. Eim omba ei yi mił; kung min, kei endi, karip tan sikir pupu kin, kei min, epi mondnum mił, yi sikir omba. ");
INSERT INTO nii_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Epi ei tonu omba kunum ei, wumb mołmun konu ełe orung orung pei tonu omba. ");
INSERT INTO nii_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kunum kunum en enim kan kun er mułngii! En enim Gos kin kunum kunum prei er mułangin kin, Gos enim dinga ngumba. Ngang kin, oł embin tui enim kin tonu ombii ni ermba; ba enim pii gii nik, dinga pimba. Peng er molk kin, wu kingam Gos mei mani kindrim ei, kumb ełe engingii,” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kunum kunum Jiisas wumb pei sipipi, Gos ngii owundu ełe, wumb ek nipi ngopu, yi ełim. Ba emii peng, eim pupu, komung Olip ełe mołułum. Mołpu or pepi kin, Jerusalem konu men ngii orung om. ");
INSERT INTO nii_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nga wumb en enim ngii konu pek, kupiiring ok Gos ngii owundu ełe Jiisas nge ek ka piiłmin. ");
INSERT INTO nii_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pe kunum endi bres yiis punenim kunum ei, kuni owundu, ‘Pasopa,’ niłmin kunum ei, mandi erim. ");
INSERT INTO nii_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pe kułmał kałiłmin owundu ni, lo ek piiłmin wumb ni, en enim wumb pei mulnjung ei, mund mong tunjung. Mułangin kanik kin, en enim yi ninjing, “Sinim Jiisas koi erpin kin, er to kundmun, mił nenj?” a ninjing. ");
INSERT INTO nii_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pe Seisen Juras noman ełe tuk pum. Nga Juras eim ‘Eskeriyas,’ niłmin. Jiisas eim nge ekii siłmin wumb ende wu engki nga tał, ei nge wu. ");
INSERT INTO nii_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Pe Juras eim pupu, kułmał kałiłmin owundu kin, men ngii ełe tep mołułmun wu ombu ni, kanpi nim. Eim Jiisas sipi, wumb ngumba ei nge er endim. ");
INSERT INTO nii_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yi ngang kin, wumb en enim ka piik, ku nin epi sik kin, wu ei ngumun, ninjing. ");
INSERT INTO nii_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pe Juras eim kapłi nipi, eim Jiisas sipi, wumb ngumba ei nge, kanpi endim. Eim kunum endi mołpu kenim ni, wumb pei Jiisas kin mulenjing. ");
INSERT INTO nii_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pe kunum ei, bres yiis punerim kunum ei, tonu wang kin, wumb kung siipsiip wał endeim ni, to kałiłmin ei, ‘Pasopa’ pa niłmin. ");
INSERT INTO nii_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pe Jiisas eim Piisa kin, Jon teł konu endi ełe kindpi yi nim, “Ełip pukuł kin, ‘Pasopa,’ kuni er kun erangił, sinim kuni numun,” pa nipi kindim. ");
INSERT INTO nii_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Wu tał eim kankił, yi ninjngił, “Nim piin! Sił konu jiłi er kun ermbił?” ");
INSERT INTO nii_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Pe Jiisas ek yi nim, “Ełip konu owundu ełe tuk pangił kin, wu endi noł ming endi sipi, tu wumba konu ełe, ekii se pukuł kin, wu ei ngii jiłi nirik ba, konu ełe, ełip nirik punguł. ");
INSERT INTO nii_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Pe ełip ngii ei, arim mułmba ei, kankił ningił, ‘Ek mon wu ek yi nim, Na nge ek se andiłmin wu engki nga tał ei kin, kuni numbii palting ełe, jiłi sałim?’ ");
INSERT INTO nii_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yi nengił kin, wu ei eim ngii tondrung ełe palting owundu endi sałim ei, ngang kin, ełip sinim kuni ‘Pasopa’ er kun er singił,” pa nipi kindim. ");
INSERT INTO nii_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wu tał ni punjnguł. Pukuł kin, kenjngił ni, Jiisas nim mił yi kenjngił. Kankił kin, kuni ‘Pasopa’ nungii nge, er ka enjngił. ");
INSERT INTO nii_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pe kuni nungii kunum seng kin, Jiisas ni, eim er se andiłmin wu kin, tonu peł ełe molk kin, kuni nok mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","16","Kuni nok molk kin, Jiisas yi nim, “Na ek keimi nind. Na enim kin kuni ‘Pasopa’ endi nop moł ei, na ka piind. Ekii se ngenj kumbii simbii. Nimbił erang ‘Pasopa’ kunum nga simba ei, na enim kin, kuni endi nunermbii, mon! Nga Gos sinim tep er mułmba kunum ei, peni ełe wang kin, oł ei ek keimi pimba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eim ming kap noł wain endi sipi kin, Gos kin prei erim. Nga eim yi nim, “Enim noł wain ming kap ei, endeim endeim ni nui!” nim. ");
INSERT INTO nii_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","“Na ek keimi nind. Akip min ekii se, mering pei, na ond mong noł wain ei nunerngii mon! Nga Gos sinim tep er mułmba kunum ei tonu omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nga bres sipi kin, Gos kin prei erpi, ngopu kin, Eim bres engin tum. Topu kin ek yi nim, “Bres ei na ngenj mił mołum. (Na ngenj ei enim paki tond; enim nok kin, na kin piik er mułngii! ");
INSERT INTO nii_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nok poru nengin kin, nga yi mił ku erpi, ming kap endi, ond mong noł wain mułum ni sipi, yi ku erang kin, nok poru nengin kin, yi nim; “Noł wain ei, enim kin oł konj endi erip ngond. Yi mił enim Gos nge wumb nanim kin, tep to mołpun, o ende punmun. Nga ming kap ond mong noł wain mułum ni, sipi kin, yi ku erim. Erpi kin, yi nim; ming kap ond mong noł wain ei, na enim kin kondrak konj endi end ei, na miyem mił peng kin, enim kin paki to ngond.) ");
INSERT INTO nii_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ba wu endi na sipi kin, wumb opu orung wumb angił ełe pendmba ei, akip sił kuni ende nopuł kin, peł ełe ende mołmbuł, wu ei minj. ");
INSERT INTO nii_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wu ei, mei mani opu wu kingam pim ei, Gos eim noman piim mił yi erim. Ba wu ei wu kingam sipi kin, wumb opu orung wumb ngumba wu ei, na kaimb sind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jiisas eim ek yi neng mił, wu ombu en enim endeim endeim ni, ek nik, kii sik, piik piik enjing. Erik kin, “Sinim kin wu nii endi oł ei ermba?” enim yi kii sinjing. ");
INSERT INTO nii_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pe eim nge ek se andiłmin wumb molk kin, ek mił enjing. Erik kin, yi ninjing, “Sinim mołmun konu ełe, wu nii owundu mołum?” ");
INSERT INTO nii_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pe Jiisas ek nipi ngum, “Wumb king eipi ei konu eipi eipi mołmun ei, king en enim noman dinga peng kin, king owundu molk wumb tep erik, wumb yi mił ninjing. Nga en enim embe ełe oł ka erik, wumb ngok ełmin. ");
INSERT INTO nii_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ba wu endi, wu num mułmbii nipi ermba wu ei, wu kongun wii mił mułmba. Nga wu noman peng wu owundu mułmbii ni piimba wu ei, kongun wu mił, enim paki topu ngopu kin, kongun erpi mułmba. ");
INSERT INTO nii_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Wu nii endi wu owundu mołum? Pe wu kuni kałpi tu wułum wu ei, min tonu peł ełe mołpu kin, kuni nołum wu ei min? Nga en enim yi ku ni piik, kuni peł ełe mołpu kin, kuni nołum wu ei mendpił. Ba na enim mołmun konu ełe tuk mołup kin, kongun wu mił, enim paki top moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Epi kanim kanim oł embin tui na kin tonu onum kunum ei, enim na wak tunenjing; ba enim na kin mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na nge Ernan sinim tep er kanpi mołum, Eim noman dinga ei na ngum. Akip na noman dinga ei, enim ngamb kin, enim mułngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","“Nam enim tep er mułmbii noman dinga ei, enim kuni peł seng kin, nok mułngii. Pe enim ok, King mił molk, Esrel wumb engki nga tał, wumb tiłap ei kin, kos piiłmin wu mił, mułngii.” ");
INSERT INTO nii_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Saimon! Saimon! Nim piikin; pe Seisen eim enim kin kuni mong wiis ełmin oł ei mił, enim kin yi ku ermba. Ei eim enim kin mok topu wumb dinga molałmin wumb nin, nga dinga mołmun wumb, kapłi kongun erpi sipi, eim andłam ełe kindmbii ni ermba ei, dinga mił molałmin kin, wumb wii mił mołmun. ");
INSERT INTO nii_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ba na prei erip kin, nim Saimon paki tunj ełe nge nim pii gii ei, dinga pimba. Ekii se nim noman ak tokun orung on kin, ninim angnim noł paki tunjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piisa ek yi nim, “Owundu, na er kun er moł. Nim kin kan ngii ełe ouni bił; nga nim kulnjii ei, na er kun er moł, na nim kin ouni kułmbuł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jiisas ek nipi yi nim, “Piisa, na nim kanip nind. Akip kunum ełe epi peng kin, kei kultu wii tunenerang kin, nim ek kunum tekliki ninjii, ‘Na wu Jiisas ninmin, ei na kinał!’ pa ninjii.” ");
INSERT INTO nii_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Pe Jiisas ek yi nim, “Ok na enim kindinj ei, enim ku ni, kon ni, simb su ei sipnerei! Kunum ei, enim epi endi simin ni piinjing min mon?” Pe en enim yi ninjing, “Sin oł endi yi enerim mon.” ");
INSERT INTO nii_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","38","Enim Jiisas ek nipi ngopu yi nim, “Pe enim tuk mołmun wu endi ku kon pimba ei simba. Nga kon yi ku. Wu endi tui kepii sinerim kin, eim kon takis ei sipipi, ku sipi, tui kepii top ermba. Erpi kin, tui kepii simba,” pa nim. Pe wumb yi ninjing, “Owundu, nim ya kan! Sin tui kepii tał sałim.” Eim yi ni piim, “Enim na ek ei pii poł tunenjing. Eim yi nim, ‘Ek ei kapłi poru nim,’ pa nim. Na enim kanip nind, Gos ek ok pułum yi nirim, ‘Enim oł kis ełmin wumb mił, eim kułou tum,’ pa nim. Nimbił erang ek ei, na nind mił, keimi tonu omba. Gos mon ełe na ek nim ek ei, akip keimi tonu onum.” ");
INSERT INTO nii_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jiisas eim anda pupu, tonu komung Olip ełe, ba pum ei, eim kunum kunum prei erpi, yi ełim. Oł ei erang mił, eim nge er se andiłmin wumb ombu, ekii se punjung. ");
INSERT INTO nii_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Pe eim konu ełe opu kin, ek nipi er se andiłmin wu ombu ngum, “Enim prei erangin kin, epi kis endi erangin kin, kenmbii nip tonu omba epi ei enim kin onermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Pe nga eim wu ombu mondpu kin, eim konu eipi mandi pum. Pe eim simb gopsing pii poł mołpu kin, prei erim. ");
INSERT INTO nii_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Jiisas eim wumb epi kis kanim kanim eim kin tonu wang kin, eim arim kin ke nipi, ek ekin yi topu nim. “Arnan! Nim na ming kap embin tui ei, na numbii ni piin kin, ninim noman ełe sinjii. Ba nim na noman ełe, nim ekii sinenjii mon. Ninim noman ełe piikin enjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jiisas eim Gos kin prei er mułang kin, pe tonu epin konu ełe enjel endi mani opu kin, eim dinga ngum. ");
INSERT INTO nii_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jiisas eim noman embin kis piipi kin, eim prei dinga erpi mułang kin, eim kurun ei, miyem mił opu, mei ełe mani pum. ");
INSERT INTO nii_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pe eim prei er pendpi angpi kin, eim ek se andiłmin wumb mulnjung konu ełe pum. Pupu kenim ni, or pinjing kenim ni, en enim noman embin tang kin, piik pinjing, kenim. ");
INSERT INTO nii_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Pe Jiisas ek nipi yi nim, “Enim nimbił erang, enim or pałmin? Enim konj kind, angk prei erei! Mon pim kin, oł kis endi enim kin tonu omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jiisas eim ek nipi mułang kin, wumb tiłap owundu endi onjung. Wu endi Juras niłmin wu ei, Jiisas nge ek se andiłmin wu engki nga tał tuk mołmun wu endi eim kumb se om. Eim mandi opu kin, Jiisas kin kumb gupu to numba nge om. ");
INSERT INTO nii_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ba Jiisas ek nipi Juras ngum, “Juras, nim wu kingam ei, nim eim gupu to nokun sikin kin, opu orung wumb ngunjii min?” ");
INSERT INTO nii_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jiisas eim nge ek se andiłmin wumb molk, kenjing ni, oł ei tonu omba enim nik, Jiisas kanik kin, yi ninjing, “Owundu, sin tui kepii sipin kin, wumb ei tumun, min mon?” ");
INSERT INTO nii_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yi nik kin, wu endi tui kepii tang kin, kułmał kałiłim owundu nge kongun wu ei, eim nge kom orung angił tundung orung, kiłip topu mani om. ");
INSERT INTO nii_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ba Jiisas kanpi yi nim, “Mon! Oł ei si kindei!” pa nim. Yi nipi kin, wu ni kom ełe embiłang kin, kom ni, nga ok pim mił, pim. ");
INSERT INTO nii_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pe Jiisas ek nipi, kułmał kałiłim owundu ombu ni, men ngii owundu ełe tep mołułmun wu ombu ni, wumb num pei, wumb eim ambił gii ningii nge ok wumb ei, Jiisas yi nim, “Enim tui nin, kepii epi ei sik kin, tu wunmun ei, enim waning wu endi tungii nge onmun min? ");
INSERT INTO nii_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na enim kin kunum kunum men ngii owundu ei mołułmun. Ba enim na peng ełe, enim angił embilałmin, mon. Ba akip kunum ei, enim kunum seng enmin. Akip Seisen emii ełe mołpu kin, epi kis ełim ei nge, dinga akip tor onum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jiisas eim ek nipi poru neng kin, wumb ombu eim ambił gii ni sipnjing. Pe wumb ei, eim sipi kin, kułmał kałiłim owundu ngii konu ełe tuk sipnjing konu ełe, Piisa eim ekii se pum. Pupu kin, konu turii mił mołpu, kan mułum. ");
INSERT INTO nii_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ngii owundu kung gui tukrung ełe engim konu ełe, dup kalk mulnjung konu ełe, Piisa tep to mulnjung ku. ");
INSERT INTO nii_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kongun amb endi mołpu kenim ni, Piisa eim dup ełe mułum kenim. Amb ni, eim kanpi kin, yi nim, “Wu ei, Jiisas kin tep to mołułum wu,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ba Piisa ek nipi, “Mon!” pa nipi yi nim, “Amb, wu ei, na kinał!” ");
INSERT INTO nii_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ekii se nga, wu endi Piisa kanpi kin, yi nim, “Nim eim nge tiłap ende,” pa nim. Ba Piisa yi nim, “Kawukeiya! Na mon!” ");
INSERT INTO nii_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Mołang kin, nga ekii se, wu eipi endi pupu yi nim, “Keimi mendpił, wu ei, eim kin tep to andiłim wu. Eim Galilii konu ełe wu,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ba Piisa ek dinga nipi ngopu, yi nim, “Wu, nim nin ek ei, na pii poł tunand.” Piisa eim ek yi nipi mułang kin, kei kultu wii tum. ");
INSERT INTO nii_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pe Owundu eim ak topu, Piisa kenim. Pe Piisa eim piim ni, Owundu ek endi eim kin nirim ek ei piim. Ek ełe nge, eim kei kultu wii tunermba kunum ei, nim yi ninjii, “Na Jiisas kinał, pa nikin, kunum tekliki enjii,’” pa nirim. ");
INSERT INTO nii_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pe Piisa eim tor pupu, ke dinga wii nim. ");
INSERT INTO nii_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Wumb Jiisas ambił gii nik, ek ngok, kepii tok enjing. ");
INSERT INTO nii_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Pe wumb Jiisas eim ningił ełe, alap pandi to pendik, kepii tok, yi ninjing. “Pe nim ek ni tor kindiłim wu mendpił min mon; ek ni! Wu nii nim kepii tonum ei, ninjii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wumb ek kis kanim kanim nik, eim kin ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ekii se konu eni tang kin, Esrel wumb num ei ni, lo ek piiłmin wumb ni, ek kengip tołmun wumb ni, Gos kin kułmał kałiłmin wumb ni, ok kułou tok molk kin, Jiisas sik sipik, kaunsil mułum konu ełe sipik, yi ninjing. ");
INSERT INTO nii_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nim sin kan kin, ‘Na Gos er sałim wu kindang, Krais,’ pa niłin, ei keimi min mon?” Pe Jiisas ek nipi ngopu, yi nim. “Na enim kanip nimbii; ba enim pii gii ninerngii. ");
INSERT INTO nii_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nga na enim kin ek kombur kii simbii nim kin, enim na ek ei ni orung kindnerngii, pałim. ");
INSERT INTO nii_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ba pe ekii se, kunum kunum mei mani opu wu kingam ei, eim Gos angił tundung ełe mułmba konu ei, Gos eim dinga wii sałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pe wumb yi ninjing, “Nim ek ei nin ei, nim Gos kingam mołun min?” Pe eim ek yi nim, “Enim ninmin ek ei, na mendpił.” ");
INSERT INTO nii_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nga wumb en enim yi ninjing, “Sinim nipe ek nga nipin kii simin? Eim gupu ełe, ek ei ninim, sin sinim piinmin, ei poru!” ");
INSERT INTO nii_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yi nik kin, wumb pei eim sipik, Pailos mułum konu ełe sipnjing. ");
INSERT INTO nii_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pe kos piingii nge nik, eim kin ek yi ninjing. “Sin wu ei kenjpin ni, eim sin wumb tiłap ełe, ełmin oł ei, eipi erpi ełim. Pe eim sin ku takis Siisa ngołmun ei, eim mon nipi, eim ‘Nam Gos kindang wu Krais nipi, nam King,’ pa nipi, yi ełim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pe Pailos eim kii sim, “Nim Jura wumb King min?” Pe Jiisas eim ek nipi, orung kindpi, ek yi nim, “Ninim nin mił yi,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailos ek nipi, kułmał kałiłim owundu ni, wumb pei kanpi yi nim, “Na wu ei, erim oł endi kan sinand, mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ba wumb ek dinga nik, yi ninjing, “Eim ek nipi wumb ngang kin, wumb eim ek piik, Jura konu ni, konu orung orung pei, mund mong ełmin. Pe Galilii konu ełe, eim er opu opu ya ełe onum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailos eim ek ei piipi kin, wumb kii sim, “Wu ei Galilii konu ełe wu min?” ");
INSERT INTO nii_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nga wumb eim kanik yi ninjing. Pe eim piim ni, Jiisas nge konu ei, Galilii konu orung ełe, Eros tep ełim konu ei piinim. Kapłi Pailos ek ei piipi kin, nga kindang pupu, “Eros mołum konu ełe orung pangłi,” nim. Kunum ei, Eros Jerusalem konu ełe mułum. ");
INSERT INTO nii_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eros Jiisas kanpi kin, eim ka piim. Nimbił erang Jiisas ek ei Eros piim; ba kunum kinan, eim Jiisas kenmbii ni piipi mułum. Eros eim yi piim, “Jiisas jep oł endi erang, kenmbii,” ni piim. ");
INSERT INTO nii_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Yi piipi kin, Eros eim epi pei Jiisas kin kii sim; ba Jiisas eim ek endi nipi kin, orung kindnerim, mon! ");
INSERT INTO nii_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Kułmał kałiłmin owundu ni, lo ek piiłmin wumb ei ok, mandi angk kin, Jiisas kos erngii nge, ek dinga kind ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eros ni, eim nge opu ond wumb ni eim ek ngok, ek kis kanim kanim nik erik, konduk ka wii endi mon kanim kanim mułum kon ei kindik kin, nga eim Pailos mułum konu ełe orung kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kumb ok, Eros eim Pailos kin opu ełmbił; ba pe eł ełip, ek ka nikił, ende punjnguł. ");
INSERT INTO nii_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pe Pailos eim kułmał kałiłmin owundu ni, wu num ni, wumb pei ok kułou tei nipi, wii tum. ");
INSERT INTO nii_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pe eim ek nipi, yi nim, “Enim wu ei ya sik tu wunjung ei, yi ninjing, ‘Wu ei sin tiłap ełe, ek nipi wumb noman er kis ełim,’ nik, tu wunjung. Pe na wu ei, enim kumb ełe ek nip, wu ei kii sind; ba eim enim enmin ek ei, endi neng kin, na piinand. Wu ei, oł endi enerim. Sinim wu ei kin, kos ermin mił mon! ");
INSERT INTO nii_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nga Eros eim erim oł endi enerim, mon ku! Nga ei eim orung kindang onum. Piinmin! Wu ei, oł kis owundu endi erang kin, sinim kapłi, eim to kundmun. ");
INSERT INTO nii_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pe na wu ei kepii top kindamb kin, orung pangłi,” nim. ");
INSERT INTO nii_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","(Ba en enim ełmin oł ei, yi kor owundu kunum ei, kan ngii pałmin wu ei, endi tor kindiłim.) Pe wumb pei wii tok kin, ek dinga nik yi ninjing, “Wu ei to kondkun, Barapas kindan kin, sin kin wangłi!” ninjing. (Barapas eim konu owundu ełe gapman kin opu erpi, wu endi to kundrum. To kundang kin, Barapas sik kin kan ngii pendik.) ");
INSERT INTO nii_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailos wumb nga kanpi, ek yi nirim, “Wu ei Jiisas, eim orung kindamb, ba,” ni piim. ");
INSERT INTO nii_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ba wumb wii tok, nga yi nik, “Ond peri ełe, to kond!” Wumb pei yi ku ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pe Pailos nga kunum ei ngang kin, kunum tekliki mił nim, “Nimbił erang, wu ei nipe oł endi erim? Na eim oł endi erim min, nip kurunj; ba oł endi erang kin, tumun ei kapłi; ba, mon!” nim. “Yi piip kin, wii kepii top kindamb, ba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ba wumb dinga puk, ek dinga nik, wii dinga tok, “Ond peri ełe kułangłi!” ninjing. Pe wii ek dinga nik, Pailos nim ek ei, to mani kindnjing. ");
INSERT INTO nii_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wumb ek yi nengin kin, Pailos wumb kanpi, yi nim, “En enim dinga kindik, ‘Wu ei tumun,’ ninmin ei, wu ei, en enim sipik, tei! Na mon minj!” ");
INSERT INTO nii_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Wu ei, gapman kin opu erim ni, wu endi to kundmun nik, sik, kan ngii pendik, wu ei, wu amb pei si orung simin nik. Pe Pailos mani wu endi ei kindan, “Wangłi,” nik. Pe Pailos Jiisas kindang wang kin, wumb sipik. ");
INSERT INTO nii_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pe opu ond wumb Jiisas sipik kin, wu endi ambił gii nik wu ei, embe Saimon. Saimon ni wu ei, eim Sairiini konu ełe wu. Wu ei opu, konu owundu ełe tuk bii ni erang kin, wumb ond peri ełe tu wunjung. Tu wuk kin, wu ei pindang ełe pindangin ko wupu kin, Jiisas pum konu ełe ekii se pum. ");
INSERT INTO nii_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pe wumb ke nik, kaimb kulk, puk kin, Jiisas pum konu ełe ekii se punjung. ");
INSERT INTO nii_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ba Jiisas ak topu amb kombur kanpi kin, ek yi nim, “Enim Jerusalem konu ełe amb! Enim na kin piik ke ninerei! Ke ningii pim kin, en enim nge kangił ei piik ke nik kin, en enim nge piik ke ningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","“Piinmin! Ekii se ek endi tonu omba ei yi pimba. ‘Amb kangił mengnarik amb ni, kangił mengnenjing amb ni, amb am ngunenjing amb ni, amb ombu pei ka piingii.’ Nimbił erang kunum ei, wumb mulnjung kin oł embin tui enim kin tonu omba. ");
INSERT INTO nii_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tonu om kunum ełe wumb kombur komung ełe ek yi ningii. Enim komung ombu mani ok kin, ‘Sin tei!’ nimin. Nga komung kembis kembis ombu yi ku, ‘Sin to pandi tei!’ nimin. ");
INSERT INTO nii_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yi mił erang enim oł ei ond konj ełe enmin; ba nga ond kułii ełe enim nimbił oł erngii?” Jiisas eim ek yi nim, “Ei oł konj ei tonu wang kin, enim kaninmin,” pa yi nim. “Nga ekii se ond kułii ei, mering ekii se oł ei enim na kin piik mułngii wumb ei, oł yi tonu omba ei, enim nimbił oł erngii?” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Wumb eipi tał tu wunjung wu tał, oł kis ełmbił wu tał, Jiisas tok, wu tał ouni tungii nge enjing, enjing. ");
INSERT INTO nii_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Pe wumb konu endi ełe tor punjung konu ei, embe ‘Wumb peng embił’ konu ei yi niłmin. Niłmin konu ełe, Jiisas ond peri ełe tok, wu tał oł kis ełmbił wu tał, nil tunjung ku. Wu endi Jiisas angił tundung orung peng kin, nga wu endi angił taring orung pim. ");
INSERT INTO nii_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jiisas ek nim, “Arnan, nim piin, wumb en enim oł kis en enim ei pii poł tunarik enmin. Kapłi nim wumb oł kis ei kil ngunjii,” pa nim. Pe Jiisas konduk ni alap epi ei wumb ku kembis mił epi ei kinjmał erik kin, konduk ei simin nik enjing. ");
INSERT INTO nii_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Wumb molk, kanik mulnjung; ba wumb peng pim wumb ei, en enim ek ngok yi ninjing. “Eim wumb eipi paki topu yi ełim. Pe keimi Gos eim Krais tełim wu ei, kindang opu, wumb paki topu ełim pim kin, kapłi akip ei eim paki topu, ond peri ełe si kindpi, mani omba,” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Opu ond wumb ei kin ek ngok, yi ninjing ku. Yi erik kin, mandi ok, epi kumbii ełim epi ei, sipi ngumun ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Pe ek ngok kin, yi ninjing, “Nim keimi Jura wumb nge King pim kin, kapłi ninim paki to!” ninjing. ");
INSERT INTO nii_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ond peri ełe, tonu eim peng ełe, ek mon endi yi pulnjung, “Wu ei, Jura wumb ei nge King,” pa nik pulnjung. ");
INSERT INTO nii_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Epi waning ełmbił wu kis tał tuk wu endi, Jiisas kin ek yi nirim. “Nim Krais Gos kindang tełin wu ei min? Kapłi ninim paki tokun kin, sił kin ouni paki tunjii ku!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ba wu eipi endi orung pim wu ni ek ei piipi kin, wu ek nim wu ni, ek ngum, “Nim ngenj kumbii sin mił wu ei yi ku sinim. Ełe nge nim Gos kin mund mong tunan min? ");
INSERT INTO nii_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wumb siłip to kondunmun ei, siłip mong sinjpił ełe to kondunmun. Ba ya wu ei, eim oł kis endi enerim konu ei tonmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pe wu ni ek yi nim, “Jiisas ekii se, nim wu King dinga owundu mułun kin, na piinjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Pe Jiisas ek nipi yi nim, “Na ek keimi nind, akip kunum ełe mendpił, nim na kin Gos nge konu ka wii ełe ouni mułmbuł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pe konu eni beli seng kin, Gos eni pandi topu erang kin, konu orung orung emii mił pepi pang kin, pou mił neng kin, emii pim ei poru nim. ");
INSERT INTO nii_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pe mendpił alap ka wii endi, Gos ngii owundu ełe, pim alap ei, tuk kiłip topu, orung orung tał pim. ");
INSERT INTO nii_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jiisas ond peri ełe pepi, ek dinga nipi yi nim, “Arnan, na noman tuk ei, nim angił ełe kindind,” nipi eim kułum. ");
INSERT INTO nii_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pe opu ełmin wumb ei, tep ełim wu ni, kanpi kin, Gos nge embe ambił tonu kindim. Kindpi yi nim, “Keimi mendpił, wu ei, wu oł kis endi enałim.” ");
INSERT INTO nii_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pe wu amb pei pei ok, enim mił kenmin nik onjung. Ok molk, kenjing ni, epi keimi peng kanik, en enim kaimb sik, pepił ełe tok, nga orung punjung. ");
INSERT INTO nii_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pe Jiisas nge wu puł ombu pei ni, Galilii konu ełe amb kombur kin, ekii se ok, turii angk, epi kis ei Jiisas kin tonu wang kin, ei kanik mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pe wu endi multum wu ei, eim embe Josep. Wu ei konu owundu ełe multum konu ei, Jura wumb mołułmun konu ełe, embe ei, ‘Arimasiya,’ pa niłmin. Wu ei, wu kaunsil mołułum wu ei, oł ka ełim wu. ");
INSERT INTO nii_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Wu ei eim kaunsil eipi ek niłmin, oł kis ełmin ełe, ekii sipi enałim. Eim Gos konu sinim tep er mołum konu ei, ekii se peni ełe wang kenmbii nipi, minj kui er mołułum. ");
INSERT INTO nii_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wu ei Pailos kin pupu, “Jiisas nge ngenj ei simbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pe Jiisas ngenj sipi, mani tu wupu, alap kuru endi sipi, pandi tum. Topu sipipi kin, tukpu endi ełe mani kindim tukpu ei, kom ku owundu endi tunduk sik, ełe ok wu endi tuk kindnałmin, ełe kindim. Kindim tukpu andiłim ełe ku owundu ondu ełe ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kor kunum ei, tonu omba mandi enim ei, kunum ka wii kunum ei er mołułmun. ");
INSERT INTO nii_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Amb ombu Galilii konu ełe si kindik, Jiisas kin ok, nga Josep purum konu ełe ekii se puk. Puk kin, Jiisas tukpu to pendik mił, kenmin ni punjung. ");
INSERT INTO nii_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kanik poru nik kin, en enim ngii konu ełe orung puk. En enim kopung ka wii ni, epi muru ka tołum epi ei, er kun erik kin, Jiisas ngenj ełe kopung ei kindngii enjing. Kor kunum “Kor mułei!” nik mił kor mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pe kongun kunum kumna, kor ei kupiiring ok, amb ombu en enim wumb tukpu ełe punjung. Puk kin, kopung ka wii ni, epi muru ka tołum epi sik kin, epi ei er kun er sik, mił sinjing. ");
INSERT INTO nii_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Puk kin, kenik ni, ku endi pandi to pendik ni, tukpu ełe pineririm. ");
INSERT INTO nii_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wumb ok wumb ni, tukpu ełe tuk puk; ba Jiisas Owundu ngenj ei kinerik mon. ");
INSERT INTO nii_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Pe wumb en enim noman ełe piik, mund mong erik mulk. Molk kenik ni, wu tał konduk kuru pirim wu tał, eł ełip mulkuł. Mulkuł wu tał nge konduk erang kin, wumb keningii pineririm. ");
INSERT INTO nii_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Amb ombu en enim keningii pinerang kin, mani mei ełe kan mani kanik mulnjung. Mułangin kin, wu tał ek nikił ngunjnguł; “Nimbił erang enim wumb tukpu konu ełe wumb endi konj mołum nik kur onmun? ");
INSERT INTO nii_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ba eim ya molałim! Eim angpi tonu pupu pum. Eim Galilii konu ełe mołpu kin, enim kin nipe ek nipi ngum ek ei, en enim piingii? ");
INSERT INTO nii_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Eim ek yi nirim, ‘Wu kingam ei sipik, wumb oł ełmin wumb ei ngangin kin, sipi to kundangin kin, tukpu konu ełe mani pu pepi kin, nga kunum tekliki pang kin, eim nga opu konj ba,’” nirim. ");
INSERT INTO nii_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wumb ek ei piik ni, Jiisas ok ek nirim mił piinjing. ");
INSERT INTO nii_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wumb tukpu konu ełe si kindik, orung punjung. Puk kin, ek nik, eim ek se andiłmin wu engki nga endeim mulk, konu ełe kanik nik ei, epi kenik mił nik, wumb eipi pei ngok yi enjing. ");
INSERT INTO nii_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pe Mariya Makandala ni, Jo Ana, ni Mariya Jeims mam ni, amb ombu mułangin kin, ek ei nik, Jiisas ek se andiłmin wumb mulk konu ełe kanik ninjing. ");
INSERT INTO nii_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ba wumb ei, ek ei ek wii ninmin ni piik kin, pii gii ninerik, mon. ");
INSERT INTO nii_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ba Piisa angpi sikir pupu, Jiisas tukpu tuk konu ełe kenmbii nipi purum. Pe eim sip topu, tukpu ełe nirik pupu kenim ni, alap mendpił sim. Seng kin, eim nga orung ngii konu ełe pupu, epi ei kenim mił piipi mułum. ");
INSERT INTO nii_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pe kunum ełe mendpił, Jiisas pii gii ninjngił wu tał eł ełip, konu endi Emeiyas ni konu ełe punguł nge punjnguł. Pukuł andłam ei Jerusalem konu ełe pupu, nga Emeiyas konu ełe tor pułum konu ei, angił orung nga tał turii mił sałiłim. ");
INSERT INTO nii_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wu tał andkił pukuł kin, epi pei kenjngił mił ei, nikił punjnguł. ");
INSERT INTO nii_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wu tał eł ełip, ek nikił, kii sikił punjnguł ei, Jiisas eim wu tał onjnguł konu ełe ekii se om ei kinenjngił. ");
INSERT INTO nii_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ba epi endi wu tał ningił ełe pełi erang kin, Jiisas kan poł tunenjngił mon! ");
INSERT INTO nii_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pe eim opu, ek nipi kii sipi yi nim, “Ełip epi nipe nikił onmbuł?” Eim ek yi neng kin, wu tał ni nikił ek piinerkił; kan mani kankił mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Pe wu endi embe Kliyopas wu ei, ek nipi orung kindim, “Wumb konu orung orung pei ok Jerusalem konu ełe minj mołmun. Pe nim mendpił Jerusalem konu epi ei tonu onum piinan min?” ");
INSERT INTO nii_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nga wu ei ek yi neng kin, Jiisas wu tał kii sim, “Epi nipe?” Wu tał eim kankił yi ninjngił, “Epi Jiisas Naseres konu ełe wu oł ei tonu om. Eim ek ni tor kindiłim wu mołpu kin, kongun ei nga erpi, Gos ningił ełe ek dinga nipi wumb ngołum. ");
INSERT INTO nii_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Wumb peng pim wumb ni, kułmał kałiłmin owundu wumb ni, Jiisas sik sipik, kos piiłim wu owundu ngunjung. Pe kos piiłim wumb owundu ek nik piik kin, wumb kombur eim ond peri ełe to kundnjung. ");
INSERT INTO nii_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ba kumb ok sin pii gii yi ninjpin kin, wu ei Esrel wumb kis mulnjung kin, oł embin tui tonu orum kin, Gos enim paki tumba nge orum. Pe nga ek endi pałim ku. Epi ombu om ei, pe kunum tekliki kunum sałim. ");
INSERT INTO nii_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Akip sin amb kombur ok ek nengin kin, sin mund mong enmin. Kupiiring ok en enim Jiisas tukpu to pendnjing konu ełe kenmin nik punjung. ");
INSERT INTO nii_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ba Jiisas nge ngenj ei kinanmin nik, ok sin kanik yi ninjing. Eim kinenjpin, ba Gos nge enjel ok yi ninjing, ‘Eim konj mołum,’ ninjing. ");
INSERT INTO nii_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nga sin wu kombur puk kin, keningii nge punjung ei, amb ok ninjing mił ku ninjing. Ba eim kinanmin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jiisas eim ek dinga nipi wu tał ngum, “Ełip noman ełe dinga pinałim min? Ełip ek ni tor kindiłmin wumb ek pei niłmin ek ei ełip pii gii ninenjngił. ");
INSERT INTO nii_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nimbił erang ełip piinanmbił? Gos Krais tełim wu ei kindang, eim ngenj kumbii ok sipi kin, nga kunum ka seng kin, Gos nge dinga tiłang owundu ngang mułmba?” ");
INSERT INTO nii_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pe eim Moses lo ek ni, ek ni tor kindiłmin wumb nge ek ei nimba erim. Pe eim ek nipi wu tał ngum ei, konu orung orung Gos mon ełe ek nipi eim mendpił pa ninim ei, ek pułe nim yi mił nim. ");
INSERT INTO nii_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pe wu tał eł ełip konu ełe mani punjnguł. Pe Jiisas eim yi erpi ba nge pum. ");
INSERT INTO nii_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ba wu tał eim kin ya mułmun konu ełe, emii pimba mandi enim, yi nengił. Nengił kin, Jiisas wu tał kin mułum. ");
INSERT INTO nii_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ekii se kuni nungii pendik, Jiisas eim wu tał kin mułum. Mołpu kin, eim bres sipi, Gos kin prei erpi, wu tał ngum. ");
INSERT INTO nii_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jiisas eim wu tał kin yi erang kin, wu tał ningił pirek neng kin, Jiisas kan poł tangił kin, nga Jiisas eim mulerim. Eim am pum. Pang kin, wu tał eim nga kinenjngił mon. ");
INSERT INTO nii_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Wu tał eł ełip ek nikił piinjngił. “Siłip andłam ełe wambił kin, eim siłip kin ek ka nipi ngum. Ngopu kin, Gos nge ek pułe nipi ngopu erim. Kunum ełe siłip noman pirek neng,” yi ninjngił. ");
INSERT INTO nii_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wu tał ek yi nikił kunum ełe mendpił orung pukuł, Jerusalem konu ełe pukuł. Pukuł ni, wu engki nga endeim mulk. Nga en enim nge puł wu kombur ouni mulnjung. ");
INSERT INTO nii_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Molk kin yi ninjing, “Keimi mendpił, Owundu ni nga orung om,” pa nik enjing. “Eim orung om ei, Saimon eim kenim.” ");
INSERT INTO nii_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Pe wu tał eł ełip andłam ełe erim oł ei, ek poł tunjnguł. Tokuł kin, yi ninjngił. “Eim bres ambił engin topu Gos kin prei erang kin, sił eim kan poł tunjpuł,” pa ninjngił. ");
INSERT INTO nii_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pe en enim ek yi nik mułangin kin, Jiisas eim opu tuk, mii memb ełe engim, “Enim noman ende sek ka piik kin, mułngii!” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ba wu en enim mund mong tok enjing. Wu ombu, “Sin sinim gui endi kaninmin,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pe eim ek nipi wumb ngum, “Nimbił erang enim puku sik andinmin? Nimbił erang enim noman embin to piik mulnjung? ");
INSERT INTO nii_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Enim na simb ni angił ełe kinei! Na mendpił moł! Na gui mon! Gui ei ngenj na pałim mił pinałiłim mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eim ek yi nipi kin, eim simb, angił pei andan topu ngum. ");
INSERT INTO nii_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","En enim ka wii piinjing; ba pii gii ninenjing. Pe en enim noman embin to piik mulnjung. Mułangin kin, eim yi nim, “Enim kuni kopur ya sałim min?” yi kii sim. ");
INSERT INTO nii_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pe en enim omu endi ni ngunjung. ");
INSERT INTO nii_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Pe Jiisas eim sipi, nang kin, kenjing. ");
INSERT INTO nii_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Eim ek nipi ngopu yi nim, “Ok, na enim kin mołup, ek nip ngunj ei, piinjing. Moses nge ek nin, ek ni tor kindiłmin wumb ek poł nin, mon Sam ełe ek pałim ek ei, na nge ek pałim. Ekii se keimi tonu omba nir mił tonu keimi onum.” ");
INSERT INTO nii_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jiisas eim ek ei nipi kun erang kin, wumb Gos ek ei pii kun enjing. ");
INSERT INTO nii_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Pe eim ek yi nim, “Krais Gos kindang tełim wu ei, eim ngenj kumbii sipi kołpu; nga kunum tekliki eim tukpu ełe angpi, nga konj tonu opu ba,” nirim. ");
INSERT INTO nii_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","“Pang kin, eim nge embe ełe, wumb ek nik ngok erangin kin, wumb tiłap ok, noman ak tok Gos ek piingii. Piyangin kin, Gos wumb ombu oł kis kil ngumba,” pa nim. “Akip enim Jerusalem konu ełe ni, konu orung orung pei ełe puk, kongun ei erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Pe enim puk, ek ombu pei wumb kanik ningii. ");
INSERT INTO nii_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Enim piinmin! Gui Ka Gos ok enim ngumbii nirim mił, Owundu ei, akip na enim ngumbii. Ba enim puk kin, Jerusalem konu owundu ełe mułangin kin, tonu epin konu ełe Gos nge dinga ei enim kin kindmba,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eim wumb ombu sipipi, Besanii konu ełe sipipi, eim angił tonu kindpi, noman ka ek nipi ngum. ");
INSERT INTO nii_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Pe eim ek ka nipi ngopu mułang kin, Gos eim sipi epin konu ełe tonu sipim. ");
INSERT INTO nii_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Wumb en enim Jiisas embe ambił tonu kindik, nga Jerusalem konu ełe orung puk kin, en enim ka ka piinjing. ");
INSERT INTO nii_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kunum kunum Gos ngii owundu ełe molk kin, Gos embe ambił tonu kind mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Am kumb ok Gos nge ek ka ei Jiisas Krais se multum. Mei eneririm kunum ei eim Gos kin ouni multum. Jiisas eim Gos Mendpił. ");
INSERT INTO nii_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Am kumb ok mendpił, Jiisas Krais eim Gos kin ouni mulkuł. ");
INSERT INTO nii_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Molkuł, eim mendpił epi kanim kanim pei eririm. Epi endi andłam eipi endi ełe tonu enerim, mon! Eim erang tonu om. ");
INSERT INTO nii_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Noman konj ei eim kin pim. Pe noman konj ei wumb tiłang ngum. ");
INSERT INTO nii_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tiłang ei wumb noman tuk emii konu tiłang ngołum. Emii ei erpi tiłang ełe tuk onermba mon! ");
INSERT INTO nii_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pe wu endi tonu om; wu ei embe Jon. Gos eim wu ei nipi, kindang om. ");
INSERT INTO nii_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Wu ei opu, ek ni tor kindmba nge om. Eim Jiisas nge tiłang ei ni tor kindmba nge om; eim ek mong wumb ek ei piik, ambił gii nik, pii gii ningii nge nimba nge om. ");
INSERT INTO nii_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon eim tiłang ei mon, eim Jiisas nge tiłang owundu pałim ei ni tor kindmba nge mendpił om. ");
INSERT INTO nii_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jiisas eim tiłang ei keimi. Eim tiłang ei wumb pei ngołum. Eim mani mei konu omba eim kunum ełe. ");
INSERT INTO nii_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Gos Jiisas Krais kin mei ei eririm. Erang, Jiisas eim opu mei ełe multum; ba mei wumb eim pii poł tunenjing mon! ");
INSERT INTO nii_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Eim pupu eim nge konu pum; ba eim nge wumb tiłap ei eim onum pa ninarik, eim ek ei piinenjing mon! ");
INSERT INTO nii_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ba wumb kombur eim ek ei piik, wumb ei Jiisas kin pii gii ninjing. Pii gii ninjing wumb, ei eim sipi Gos nge kingam ambiłam noł mułngii nipi mundum. ");
INSERT INTO nii_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gos nge kingam ambiłam noł mułngii ei wumb miyem ełe mengk singii min; wumb nge ngenj ełe mengk singii; min wu noman ełe mengk singii ei ok Gos nge kingam ambiłam noł mulerngii mon. Gos eim nge wumb er mondułum. Wumb ei Gos nge noman ełe eim kingam ambiłam noł mendpił mułngii. ");
INSERT INTO nii_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jiisas eim mei mani opu wu tałpi Gos nipe mił mołum, eim sinim anda tum eim tuk sinim kin mołum. Sinim Gos nge kingam mendpił eim nge tiłang owundu ei kan poru ninjpin. Eim nge tiłang Gos Owundu kindang om. Jiisas eim noman kun ka ni ełe kun ka mendpił; ei eim kin piki top mołum. ");
INSERT INTO nii_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon eim ek ei nipi eim wii dinga topu yi nim, “Wu ei ok na enim kanip yi ninj, ‘Wu endi na ond konu ekii se omba wu ei, na nge Owundu. Nimbił erang na tonu onerir kunum, ei eim kumb ok multum.’” ");
INSERT INTO nii_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Sinim wumb pei, eim nge ka wii epi pei sinmin ei eim kin piki to mołum. Eim nge noman ka ei sinim kin am pei ngopu minj mołum. ");
INSERT INTO nii_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nimbił erang, Gos eim lo ek ei Moses angił ełe ngurum. Ba Jiisas Krais eim noman ka ngopu ni, ek keimi mendpił ei Jiisas Krais eim sin kin tonu om. ");
INSERT INTO nii_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wumb endi Gos endeim kinałim mon. Gos eim nge kingam endeim mendpił, ei eim mendpił Gos arim kin ouni mołułum. Ei eim Gos nge ełim oł ei, pułe ni tor kindpi sinim ngołum. ");
INSERT INTO nii_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jura wumb molk, Gos kin kułmał kałiłmin wu kombur ni, Liiwai wumb men ngii kongun paki tok ełmin wumb ei, nik kindangin Jerusalem konu si kindik ok, Jon kanik kii sinjing, “Nim Nii?” ");
INSERT INTO nii_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pe Jon eim ek ei koi enerim mon. Eim ek ni tor kindpi ek dinga yi nim, “Na Krais Gos kindang wu mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Pe wu ombu eim kii sinjing, “Pe nim Elainga Gos nge ek ni tor kindiłim wu ok multum min?” Pe eim yi nim, “Ei na mon.” Nga wu ombu kii sinjing, “Sin wu endi oł ekii se tonu omba ei piipi nimba wu endi omba nipin kui er mulnjpun, wu ei nim min?” Nga Jon ek nipi orung kindpi yi nim, “Ei na mon,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wu ombu en enim yi ninjing, “Pe nim nii? Wumb si kindik ninjing ek ei nim nipin ngonmun. Pe ninim ek nikin, ‘Na wu ei,’ pa nen piimin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Pe Jon eim ek yi nim, “Enim noman tuk ełe er kun erei!” Ek pułe ei yi mił, ‘Na wu endi eim konu wumb mulenjing konu ełe wii top ek dinga nip,’ yi ninim. ‘Owundu nge andłam to kun erei!’ Ei ok ek ni tor kindiłim Aisaiya oł ekii se tonu omba nge piipi nirim ek ei nge nimbii ond,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Lo ek piiłmin wumb, wu ombu kindangin Jon kin onjung. ");
INSERT INTO nii_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pe wu ombu Jon kii sik yi ninjing, “Nim ok wu Aisaiya oł ekii se tonu omba ei piipi niłim wu ei mon. Nga nim Krais Gos kindang om mon; nga oł ekii se tonu omba ei wu endi mon. Nga nim nimbił erang wumb noł pendkin en?” ");
INSERT INTO nii_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Pe Jon eim ek nipi orung kindpi yi nim, “Na noł mendpił ełe wumb noł pendind. Ba enim mołmun konu tuk ełe wu endi angpi mołum. Ei enim piinanmin mon. ");
INSERT INTO nii_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Wu ei na ond konu ekii se omba; ba na nam wu ka mon, eim simb su kan ei pos kindnermbii mon. Eim oł kis min, oł embin ei na si kindnermbii, mon!” ");
INSERT INTO nii_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Epi ombu pei Besanii konu orung noł Joran ełe tonu om. Konu orung ełe, Jon wumb noł pendpi ngum. ");
INSERT INTO nii_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jon eim topuł mołpu kenim ni, Jiisas eim mułum konu omba nge om. Pe Jon eim yi nim, “Ei Gos nge kingam kung siipsiip wał mił wumb kułmał kałiłmin eim onum kinei! Eim onum kułang mei ełe wumb pei kis kil ngumba nge onum,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","“Wu ei na ek yi mił nir, ‘Wu endi ond ekii se omba; ba wu ei na nge wu owundu nir. Nimbił erang na minan mingneririm kunum ei, eim am kumb ok mendpił eim multum.’ ");
INSERT INTO nii_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na nam eim pii poł tunerir mon. Ba na op wumb noł mendpił pendip ngur. Ei nge Esrel wumb Gos kingam ni piingii.” ");
INSERT INTO nii_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Pe Jon eim ek nipi tor kindpi yi nim, “Na kenj tonu epin Gui Ka kei Kurmuł mił ninmin mił yi mani om. Opu, eim kin mułum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","“Pe na nam eim piip poł tunerir; ba Gos na kindang op, wumb noł mendpił ełe pendip ngur. Eim na kin ek nipi ngopu yi nirim. ‘Nim moł kinan Gos Gui Ka ei opu, wu endi kin mułum kin, wu ei wumb Gos nge Gui Ka ei, wumb noł mił pendpi ngumba.’ ");
INSERT INTO nii_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pe na nam kanip poru nip, ek ei nip, tor kindinj. Ei Gos kingam mendpił,” Jon eim ek yi mił nipi kindim. ");
INSERT INTO nii_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nga kupiiring, Jon eim kin ekii sinjngił wu tał ouni mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Molk kin, Jon eim mołpu kenim ni, Jiisas andłam ełe, andpi pum. Pang kin, Jon eim ek yi nim, “Gos nge kung siipsiip wał ei onum, kenei!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eim kin ekii sinjngił wu tał, eim ek yi mił nim ei, piinjngił! Piikił, Jiisas pum konu ełe ekii sikił punjnguł. ");
INSERT INTO nii_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jiisas eim pupu, kan ak topu, wu tał kanpi, ek nipi, wu tał ngopu, yi nim, “Ełip epi nipe kurkuł, onmbuł?” Pe wu tał ek ni, orung kindkił. “Nim ek emb tołun wu, nim ngii jiłi sałim?” yi nikił, eim kii sinjngił. ");
INSERT INTO nii_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pe Jiisas eim ek nipi, yi nim, “Ełip ya okuł kineł!” nim. Wu tał pukuł eim mułum konu ngii ei kankił kin, eim kin ouni mulnjung. Nimbił erang, konu eni kapił kapłi erim ei, eni wuł mani pupu, konu pou nim. ");
INSERT INTO nii_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Wu tał Jon ek neng, piikił, Jiisas pum konu ełe, ekii se punjnguł wu tał, endi Endru, ei Saimon Piisa angim. ");
INSERT INTO nii_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pe Endru eim pupu, angim Saimon kanpi, yi nim, “Sin Gos Kindim Wu Krais om, kenjpin ei, sinim Krais Gos Kindim Wu ei, sin kenjpin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Pe Endru eim angim Jiisas mułum konu ełe, kenmba nipi sipim. Jiisas eim kanpi, yi nim, “Nim Saimon, Jon nge kingam; ekii se, nim embe endi Siipas ningii; Griik wumb embe ei yi mił niłmin. Piisa ei pułe, ‘Kom ku,’ yi niłmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nga kupiiring, Jiisas eim Galilii konu ełe bii nipi opu, Pilip kan sipi, yi nim, “Na ond konu ekii se wa!” a nim. ");
INSERT INTO nii_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip ni wu ei, eim konu ełe embe Beseira konu ei, Piisa kin Endru teł konu ende. ");
INSERT INTO nii_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip Nasaniyel kur kanjpi yi nim, “Ok Moses lo ek połpu, nga ok ek ni tor kindiłmin wumb, eim kin ek polk wumb ei nge, ni wu ei sin kenjpin. Eim Jiisas Naseres konu ełe wu Josep nge kingam,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Pe Nasaniyel ek nipi yi nim, “Naseres konu ełe, akip epi ka endi tonu omba min mon?” Pilip ek nipi, orung kindpi, yi nim, “Nim okun kenjii; oi!” ");
INSERT INTO nii_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jiisas kenim ni, Nasaniyel eim kin wang kanpi, eim ek yi nim, “Ei Esrel wu mendpił onum, kenei! Ek kend endi ni, eim kin pinałim, mon!” ");
INSERT INTO nii_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nasaniyel ek nipi orung kindpi yi nim, “Nim na er kaniłin mił nenj?” Pe Jiisas ek nipi orung kindpi yi nim, “Pilip nim kin ek tinerim kunum ei, nim ond mong pik puł ełe mułun ni, na nim ok kenj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Pe Nasaniyel ek nipi orung kindpi yi nim, “Ek emb tołun wu! Nim Gos nge kingam mendpił. Nim Esrel wumb nge King,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jiisas ek nipi orung kindpi yi nim, “Na nim ok kenj ond pik puł ełe mułun kunum ei na ninj, nim pii gii nin min? Ekii se nim kenjii ei epi owundu mendpił tonu omba,” pa nim. Ei Jiisas eim ekii se jep oł piipi nim. ");
INSERT INTO nii_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jiisas ek nga nipi ngopu yi nim, “Na ek keimi mendpił nip enim ngond. Ekii se enim molk piingii ni, na Gos kindang mani mei ełe tels wu moł; yi erang Gos nge andłam ełe sinim. Eim kin ek tangpin piipin ermin andłam ełe aki tum. Ekii se enim molk keningii ni, tonu epin wuł ał pang, Gos nge enjel pei, tonu puk, nga mani ok erngii ei, na kin ongii. Na Gos kindang mani mei wu tels wu moł.” ");
INSERT INTO nii_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kunum tekliki ełe, wu endi Keina konu orung Galilii niłmin konu ełe, wu endi amb simba erim konu ełe, Jiisas mam pupu konu ełe mułum ku. ");
INSERT INTO nii_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jiisas eim nge ekii siłmin wumb kin, Jiisas kin Keina konu ełe, wangin nik tung kindnjing. ");
INSERT INTO nii_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ekii se noł wain nunjung poru neng, Jiisas mam opu, Jiisas kanpi yi nim, “Noł wain nunjung poru ninim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pe Jiisas mam kin ek yi nim, “Amb ei nim epi mon. Na nam noman ełe, na nam andan tumbii kunum ełe tonu onanim mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jiisas nge mam eim ek nipi kongun wii ełmin wu ombu kanpi yi nim, “Jiisas eim nipe ek endi enim kanpi nim kin enim eim nimba mił, ekii sik erei!” a nim. ");
INSERT INTO nii_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Noł ming mił owundu angił nga endeim mił sim. Ei Jura wumb noł was ełmin oł ei nge ming. Noł kułngii ei noł kulk ming endeim piki top mułmba ei nge su 20 ni 30 su pei sik ninmin. ");
INSERT INTO nii_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jiisas ek nipi, “Noł ming pei ełe noł kulk piki tei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pe Jiisas eim kongun wii ełmin wu ombu kanpi yi nim, “Noł kopur bein tok, sipik wu kuni wumb ngonum tep ełim wu ei ngei!” nim. Yi neng kin, sipik ngunjung. ");
INSERT INTO nii_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pe kuni mok topu tep er mułum wu ei, pe noł ei sipi nopu piim ni, noł wain mendpił pim. Wu ni yi piim, “Noł wain ei jiłi orung sinjing,” ni piim. Ba kongun wu ming owundu noł kulnjung wu ombu en enim piinjing. Pe kuni mok topu tep er mułum wu ei eim ek nipi wu amb sim wu ei kii sipi yi nim. ");
INSERT INTO nii_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Wumb pei noł wain ka mił ei ok ngok, erang wumb nok kis er mułangin noł wain kis mił ei ekii se ngołmun. Ba ni nim noł wain ka ei ambił gii nikin, ekii se tu wun,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jiisas eim jep oł ei am kumna mendpił erang, eim nge noman dinga tiłang ei andan tum. Kunum ełe eim nge ekii sinjing wu ombu Jiisas kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pe kunum ei poru neng, Jiisas eim mam angim noł ni eim ekii sinjing wu ombu kin Kapaniyam konu ełe puk, kunum kopur konu owundu ełe mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jura wumb kuni owundu Pasopa nołmun kunum mandi erang, Jiisas eim Jerusalem konu ełe tonu pum. ");
INSERT INTO nii_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nirikring, Gos nge men ngii owundu ełe wumb kung kou ni, kung siipsiip ni, kei ni, kom ku tiłan erik. Enjing, wumb ombu ok peł ełe molk ku tiłan erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Pe Jiisas eim kan endi sipi, wumb ei kan piłangsi topu, wumb to anda kindim. Kindpi, wumb ku tiłan erik mulnjung wumb ei top bein topu, ku peł ni ku ombu orung orung si kindim. ");
INSERT INTO nii_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jiisas kanpi, wu kei tu wuk, ku sik erik mulnjung wumb ei kanpi ek yi nim, “Enim epi ei sipei! Enim na Arnan ngii yi erangin opu, top ngii mił sinermba mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jiisas eim kin ekii siłmin wumb ei, en enim yi piinjing. Gos ek endi yi pałim mił keimi tonu om. “Na kongun dinga erpi, Arnan nge men ngii ka simba nipi end.” ");
INSERT INTO nii_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ba Jura wumb ei kanik yi ninjing, “Nim jep oł nipe jep oł endi eran, sin kenmin nim nge noman dinga peng oł yi mił en?” ");
INSERT INTO nii_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jiisas eim ek nipi orung kindpi yi nim, “Enim Gos men ngii ei to mani kindangin, nga na kunum tekliki mendpił ngii ei si tonu kindip tekmbii,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Pe Jura wumb yi ninjing, “Kung ngii 46 kinan, wumb ngii ei teknjing. Ba nim kunum tekliki mendpił ngii ei tekmbii nin min?” ");
INSERT INTO nii_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ba Jiisas eim Gos men ngii ei nim ek, ei eim ngenj ełe kołpu nga kunum tekliki konj angpi tonu ba ei piipi, ek ei nim. Ba wumb ek ei pii poł tunenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ei mił, Gos eim kołpu ekii se eim sipi nga konj angpi orung simba nirim ek ei, eim nge ekii siłmin wumb ei Gos nge ek poł ei piik mił Jiisas eim yi kun nipi tor kindang, ek ei pii gii mendpił nik, mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jiisas eim Jerusalem konu ełe Jura kor owundu Pasopa kunum ka ełe mułum. Mułang, wumb pei eim jep oł erim ei kenjing. Kanik, eim yi erim oł ei eim kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ba Jiisas eim wumb pii gii ninmin ninjing ei Jiisas eim keimi ni piinerim mon. Piinarpi, eim wumb kin bii ni piinerim. Nimbił erang wumb pii gii ninenjing. Jiisas wumb noman ełe kan poru niłim. ");
INSERT INTO nii_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Wumb endi molk wumb ombu yi mił oł yi mił ełmin pa nik Jiisas eim ek ngunerngii mon. Ełe nge nimbił erang Jiisas eim wumb pei noman tukrung nipe ełe noman pim ei eim kan poru nim. ");
INSERT INTO nii_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wu endi wu num ei, eim embe Nikoriimas. Wu ei eim lo ek piiłim wu. Eim Jura wumb ei tep wu num mołum wu. ");
INSERT INTO nii_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wu ei eim epin kunum opu, Jiisas mułum konu opu yi nim, “Ek emb tokun wumb ngołun wu. Sin piinmin, nim Gos kindang, ek emb tokun wumb ngunjii nge on. Pe Gos wu endi kin mulermba, ei eim jep oł en mił yi kapłi enermba mon.” ");
INSERT INTO nii_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jiisas ek nipi orung kindpi yi nim, “Keimi mendpił na nim kanip nind. Pe wu endi ei opu noman tuk konj kangił kembis mił punerim kin, Gos sinim tep er mołum wumb ei kin konj mulermba mon.” ");
INSERT INTO nii_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pe Nikoriimas ek nipi orung kindpi yi nim, “Wumb tukui molk nga kangił kembis mił tonu ongii mił nenj? Nga menjing kirim ełe tuk pangin, nga menjing mek kindangin ok konj mułngii nin min?” ");
INSERT INTO nii_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jiisas eim ek nipi ngopu yi nim, “Keimi mendpił na nim kanip nind. Pe wu endi eim noł pepi, Gos Gui Ka ei sipi opu, wu konj mił punerim kin, keimi wu ei Gos sinim tep er mołum ełe tuk punermba mon. ");
INSERT INTO nii_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wumb nii endi ngenj ełe mengnim ei ngenj ełe wumb, nga Gos Gui Ka ełe wumb konj tonu ongii ei, Gos Gui Ka nge wumb,” a nim. ");
INSERT INTO nii_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Na nim kanip nind, ek ei piikin noman embin to pinerii mon! Nim okun, nga wu konj mił mułii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Konu pop tonum, ei eim pop top orung pupu, orung pupu enim. Konu pop onum ei nim piin. Ba konu jiłi opu, nga jiłi orung punum ei nim piinan. Yi mił, wumb pei Gos Gui Ka ełe ok, wumb konj mił mulnjung kin, yi mił ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Pe Nikoriimas ek nipi orung kindpi yi nim, “Epi ei er tonu omba mił nenj?” ");
INSERT INTO nii_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jiisas eim ek nipi orung kindpi yi nim, “Nim Esrel wumb nge ek emb tokun ngołum wu mołun, ba nimbił erang nim epi ei pii kun enan?” ");
INSERT INTO nii_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","“Keimi mendpił na nim kanip nind. Sin ek nipin enim ngopun ninmin ei, epi sin kanpin poru nipin kin, ek ni tor kindpin enim ngonmun. Ba enim ek ei piinarik, buł ngok ngok enmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","“Na enim mei ełe epi ei, enim kanip ninj; ba ek ei enim pii gii ninanmin mon! Pe na tonu epin epi ei nip enim ngumbii ei, er pii gii ningii mił nenj? ");
INSERT INTO nii_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Wumb endi tonu epin pupu kinałim mon! Gos Jiisas (Krais) kindang opu mei wu tełip ei, na nam mendpił konu ei kanił. Nimbił erang ei nga nam moł konu.” ");
INSERT INTO nii_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Kumb ok Moses eim mei wumb mulenjing konu ełe ka wembii endi mił ond endi tonu kindpi pendim; yi mił ku Gos kingam kindang opu mei wu tełim wu ei, wumb yi mił ku erik; nga eim ond peri ełe tonu kindik tok kundngii. ");
INSERT INTO nii_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Kundangin, wumb pei na kin pii gii ninjing kin, en enim noman konj sik kunum kunum ka mułngii. ");
INSERT INTO nii_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Keimi, Gos eim kingam endeim mendpił mołum. Ba Gos eim mei wumb pei noman mendpił ngopu, eim kingam endeim mendpił ei ngum. Gos eim yi mił erang kin, wumb pei eim kin pii gii ningii wumb ei, Gos kin mułngii. Wumb ei noman konj sik, kunum kunum konj mułngii. ");
INSERT INTO nii_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Gos eim kingam kindang om ei, wumb kos piipi, wumb ek nipi kun erpi yi ermba nge onerim mon. Gos kingam ei kindang om ei, wumb sipi Gos kin orung simba nge kindim. ");
INSERT INTO nii_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Wumb eim kin pii gii ninenjing kin, Gos kos owundu piimba. Kunum ei en enim Gos kin mulerngii mon, kunum kunum dup nok mułngii. Nimbił erang, Gos kingam endeim ei kin pii gii ninenjing. Nga wumb eim kin pii gii nik mułngii wumb ei, noman konj sik, kunum kunum konj ka mułngii. ");
INSERT INTO nii_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Gos wumb kos piimba ei, ek pułe yi pałim. Jiisas tiłang owundu ei mei wumb noman tuk kin tiłang ermba. Ba wumb en enim emii konu noman kulk, tiłang ełe onenjing mon. Nimbił erang, wumb en enim oł kis er mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wumb oł kis ełmin wumb ei, en enim tiłang ei noman ngunałmin. Nimbił erang, wumb en enim oł kis peni ełe omba ni piik nge onałmin. Onarik, tiłang ełe oł ka ei kin, opu orung erik buł ngołmun. ");
INSERT INTO nii_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ba wu endi eim oł kun ełim wu, ei eim tiłang ełe opu, erang wumb kaniłmin. Wu ei eim Gos nge dinga ełe enim ni piiłmin.” ");
INSERT INTO nii_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pe epi ei poru neng, Jiisas eim nge ekii siłmin wu ombu kin, Jura konu orung ełe puk. Konu ełe pu molk, eim nge ekii siłmin wumb ei wumb noł pendik, ełmin. ");
INSERT INTO nii_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon eim yi ku wumb noł pendpi eririm, ei konu Einon ni konu ei, Salim konu mandi sirim. Noł pei pim konu ełe wumb ok noł pinjing. ");
INSERT INTO nii_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Eros Jon sipi kan ngii pindneririm kunum ei erim. ");
INSERT INTO nii_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon nge ekii sik wu ei nge ombu ni Jura wu endi kin, tuk ek orung orung nik, wumb noł pendik ełmin oł ei nge nik. ");
INSERT INTO nii_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Pe Jon nge ekii sik wu ombu ok, eim kanik yi nik, “Ek mon wu, nim wu endi kin ok nim kin Joran konu orung molkuł, wu ei nim ek ni tor kindin. Wu ei eim wumb noł pendnim nik, wumb pei eim kin punmun,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Pe Jon eim nipi yi nim, “Gos tonu epin mołum ei epi endi wumb ngunermba; nga wumb endi ei eim kapłi sinermba mon. Nimbił erang Gos eim Krais kindang ya mani opu, wumb noł pendik ełmin oł ei ermba nge om. ");
INSERT INTO nii_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Enim ok piimin, na ek nip ngunj, ‘Na Krais mon. Ba Gos na eim ekii se omba konu na ok kindang ond,’ pa yi ninj. ");
INSERT INTO nii_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Pe wu endi eim amb sim kin, wu ei eim amb ei mendpił mułmba. Pe eim nge wu angim ei angpi piim ni, eim angim wu ei amb sipi ek tingang, eim piipi ka piim. Nimbił erang wu ei amb simba wu ei ka piinim. Yi mił ku, na noman ka ka piki top mołum. ");
INSERT INTO nii_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Eim nge embe ei am owundu ei tonu mendpił pang, na nge embe ei am mani mendpił ba,” nim. ");
INSERT INTO nii_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Wu endi tonu mołpu mani om kin, ei owundu mendpił mołum. Wu endi mei konu tonu om kin wu ei mei wu. Mei ełe epi ei nip ngonum, ba wu endi tonu epin mani om wu ei, Jiisas epi pei tep er mołpu Owundu mendpił mołum,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","“Wu owundu eim ek niłim ei, piipi poru nipi, kanpi poru nipi, ek nipi tor kindiłim, ba wumb endeim endeim, endi eim nim ek ei piik, sik, ambił gii nik, piik mulałmin min? ");
INSERT INTO nii_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Wumb endi eim ek ei ambił gii nik mułngii, wumb ei, ek ei piik ni orung kindngii. Gos ei eim ek keimi mendpił niłim,” pa ningii. ");
INSERT INTO nii_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Wu ei Jiisas Gos kindang om. Opu, Gos erim ek ei nipi tor kindim. Nimbił erang Gos eim Gui Ka ei, wu ei kin dinga aninga er ngunerim mon; ba eim dinga owundu pei ngołum. ");
INSERT INTO nii_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Arim Gos eim kingam Jiisas ei noman ngopu, eim epi pei kingam angił ełe ngopu, wu ei Jiisas epi pei tep er mołum. ");
INSERT INTO nii_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wumb endi Gos kingam ei kin pii ninjing kin, eim noman konj kunum kunum sipi mułmba. Wumb endi Gos kingam ek ei pii gii ninenjing kin, noman konj ei, sinermba mon. Gos wumb ei kin kos owundu erpi kindang; nga kumep kis eim kunum kunum simba.” ");
INSERT INTO nii_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Kunum ełe lo ek piiłmin wumb ek endi yi mił piinjing, “Jiisas eim kin ekii siłmin wu ombu ei wumb noł pendik ngołmun. Nga wumb pei Jiisas kin ekii siłmin ninjing. Jon kin wu ombu aninga ekii sek punjung,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ba Jiisas eim wumb noł pendnerim mon. Eim kin ekii siłmin wumb ei wu amb noł pendik ngunjung. ");
INSERT INTO nii_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jiisas eim lo ek piiłmin wumb ei ek ei piinmin ni piipi, eim Jura konu ei si kindpi, Galilii konu orung pum. ");
INSERT INTO nii_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pupu andłam endi ełe ekii sipi pupu, Sameriya konu ełe tuk pup ełe orundung tor bii ni pum. ");
INSERT INTO nii_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pe Jiisas eim pupu, Sameriya wumb konu owundu endi ełe tor om. Konu ei embe Saikar niłmin. Konu ełe kumb ok Jeikop mei nendii kingam Josep ngurum mei ei, konu ełe mandi mił sim. ");
INSERT INTO nii_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Noł tukpu ei kumb ok Jeikop siłim noł tukpu, ei konu ełe sim. Jiisas eim noł tukpu ełe mandi mułum. Jiisas andłam olt om eim ten erim. Ei konu eni tinga beli sim kunum. ");
INSERT INTO nii_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sameriya amb endi noł kułmba nge om. Jiisas eim ek nipi amb ei ngum, “Noł na ngan numbii,” a nim. ");
INSERT INTO nii_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jiisas ei kin ekii sik ok wu ombu konu owundu ełe puk, kuni top erngii nge punjung. ");
INSERT INTO nii_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sameriya amb ni ek nipi orung kindpi yi nim, “Nim Jura wu, na Sameriya amb. Nimbił erang, nim na noł ngamb nin? Jura wumb kin Sameriya wumb kin tep tok ende andnałmin mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Pe Jiisas ek nipi orung kindpi yi nim, “Nim Gos eim epi wii wumb ngołum ei nim piin kin, kapłi nim na nii ei nim pii poł tokun kin na kii sen kin, noł ei ngamb nim nokun konj kunum kunum mulnjii noł ei na nim ngumbii,” pa nim. Jiisas eim noman konj ngumba ei nge piipi, ek nipi amb ei ngum. ");
INSERT INTO nii_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Amb ni ek nipi orung kindpi yi nim, “Owundu, noł ming endi sinałim; pe nim noł wumb nok konj kunum kunum mułngii noł ei, er sinjii mił nenj? ");
INSERT INTO nii_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sinim nge kupenjpin Jeikop, eim noł tukpu ei sin ngum. Ok eim kingam noł ni eim kung kou ni, kung siipsiip ni, ei pei noł ei ngołum. Pe nim, eim to mani kindkin sin noł ka wii ngunjii min?” ");
INSERT INTO nii_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jiisas eim ek nipi orung kindpi yi nim, “Wumb ya noł tukpu ełe nonmun wumb ei, nga noł ełe kulk nungii. ");
INSERT INTO nii_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noł ei kunum kunum tangpi, tonu opu topu tor wang ei noman konj ngang konj kunum kunum mułmba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Amb ei ek nipi Jiisas ngopu yi nim, “Nim noł ei na ngo! Ngan, na noł nuwa enerang, nga ya noł tukpu ełe op kulermbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jiisas eim ek nipi amb ei ngopu yi nim, “Nim pukun, wanim nen. Nga ya weł!” nim. ");
INSERT INTO nii_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Amb ni ek yi nim, “Na wu molałim,” pa nim. Pe Jiisas ek yi nim, “Amb, nim na wu mulałim nin ei keimi nin. ");
INSERT INTO nii_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ok, nim wu angił orung pun. Pe nim wu endi nim kin mołum ei ninim wu mendpił mon.” ");
INSERT INTO nii_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Amb ni ek nipi orung kindpi yi nim, “Owundu na pe piind nim Gos oł ekii se ermba oł ei piikin niłin wu. ");
INSERT INTO nii_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sin Sameriya konu ełe wumb ok kupenjpin noł mulk, ei tonu komung Gerisim ełe kułou tok Gos kin men tok ełmin. Nga enim Jura wumb ei yi niłmin. Men tok erngii konu ei Jerusalem konu ełe sałim,” pa niłmin. ");
INSERT INTO nii_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jiisas ek nipi amb ei ngopu yi nim, “Nim na ek ei pii gii ninjii. Ekii kunum endi tonu omba kunum ei, mandi wumb tonu komung Gerisim ełe Gos men tok enarik, nga wumb pei Jerusalem konu ełe Gos men tok enerngii ku. ");
INSERT INTO nii_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Pe enim Sameriya konu ełe wumb en enim Gos pii poł tunarik, men tok ełmin. Nga sin Jura wumb ei Gos piiłmin eim kin men tok ełmin. Ei nimbił erang, Gos ei kongun erpi, wumb sipi eim kin orung simba nge wu ei, sin Jura wumb kin om. ");
INSERT INTO nii_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kunum endi tonu omba nik, ei pe tonu om poru ninim. Wumb en enim Gos kin men tok keimi mendpił ełmin wumb ei en enim noman tuk ełe Gos kin noman ka ngungii. Nga en enim men tok keimi erik, Gos kin ngungii. ");
INSERT INTO nii_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Gos wumb mił mon! Gos eim Gui Ka mołum. Wumb endi Gos kin men tok erngii ei, Gui Ka ełe erik en enim noman ka ngok; ek keimi noman ka ngok ek keimi nik Gos ngungii.” ");
INSERT INTO nii_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Amb ni ek yi nim, “Na piind, wu endi omba, ‘Krais’ niłmin. Wu ei om kin, sinim kin Gos nipi oł erim ei nipi ngumba.” ");
INSERT INTO nii_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jiisas eim ek nipi amb ei ngum, “Ei na; na pe nim kin ek tang moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Eim ek yi neng kin eim nge ekii sik wu ombu orung onjung. Wu ombu en enim yi piinjing, “Eim amb ei kin nimbił erang, ek tangnim?” ni piinjing. Ba wu endi opu, “Nim amb ei kin nimbił erang ek tangkin mołun? Nim nimbił oł en?” Jura wumb oł yi mił enałmin; yi ningii wu endi onenjing nik, en enim yi piinjing. ");
INSERT INTO nii_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pe amb ei eim noł ming ei mani kind sepi, konu owundu ełe orung pum. Pupu, wumb kanpi yi nim. ");
INSERT INTO nii_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Enim wu endi mołum ei, keningii wei!” pa nim. “Wu eim na ok ełe mił pei ei nipi ngum. Ei Krais min mon?” ");
INSERT INTO nii_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pe wumb konu owundu ełe si kindik, Jiisas mułum konu ełe bin ni punjung. ");
INSERT INTO nii_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kunum ełe, eim ekii sinjing wu ombu ek dinga yi ninjing, “Ek emb tołum wu, nim kuni nui!” a ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ba Jiisas eim ek nipi ngopu yi nim, “Na kuni kombur sałim ei enim piinanmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yi mił neng kin, Jiisas kin ekii siłmin wu ombu, ek en enim yi ninjing, “Wumb endi eim kuni endi tu wuk ngunjung min?” ");
INSERT INTO nii_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jiisas ek nipi ngopu yi nim, “Na kuni ei ya mani mei ełe kuni mon; ba yi mił. Na Gos kindang onj; ei eim noman ełe na ekii sind. Eim nge kongun ei na er poru nimbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Enim ek yi niłmin, ‘Oi kapił kapłi pałim ei poru neng, sinim kuni kułou simin kunum,’ pa niłmin. Na enim kanip nind, enim kan orung kind kinei! Kuni pei pol top mołum. Ei pe kunum ełe kuni singii. (Ei Jiisas eim ek ekin mił end nim.) Wumb ok wumb ei pe na kin pii gii nik erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","“Wu nii endi eim kuni wiis kiłip topu kułou tum kin, ei eim kumep ka simba. Nga eim wu endi kuni wiis emb tełim wu ei kin, eł ełip ouni noman ka piingił. Nga yi mił ku, wumb nii endi eim yi erang kin wumb na kui erik pii gii ninjing kin, eim kumep ka simba. Nga nim wu endi kin Gos ełe ka ei wumb kin ek emb topu ngum, eł ełip ouni noman ka piingił. ");
INSERT INTO nii_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pe ek yi mił ei keimi, ‘Wu endi kuni emb tałpi pendiłim kin, wu endi opu kuni kułou topu siłim.’ ");
INSERT INTO nii_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na enim kuni se nip kindamb punjung, ei enim kongun er tilenjing; wumb epi kongun dinga er tał pendnjing konu, enim puk kuni singii nge punjung.” ");
INSERT INTO nii_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pe Sameriya wumb pei Jiisas kin pii gii ninjing. Nimbił erang, amb ei eim ok erim oł ei, Jiisas eim piipi nipi tor kindim. Amb ek yi neng kin, wumb Jiisas eim kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pe Sameriya wumb ok Jiisas eim kanik, kii sik yi ninjing, “Nim sin kin mułmun min?” pa nengin kin, Jiisas eim konu ełe kunum tał mendpił mułum. ");
INSERT INTO nii_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pe kunum ei wumb pei nga Jiisas nge ek piik eim kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Pe wumb ei ek yi ninjing, “Amb, nim ek ei sin pii gii mendpił ninenjpin mon. Sin sinim eim ek ei piipin, nga eim kanpin enmin. Sin piipin eim wu ei mendpił mei wumb pei Gos kin sipi orung simba nge onum, pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","44","Jiisas eim ek nipi tor kindpi yi nim, “Gos oł ekii se ermba ei piipi nipi tor kindpi ełim wu, ei eim konu ełe eim embe tonu punanim,” nim. Pe wumb Jiisas eim ek ei piinerangin kin konu ełe kunum tał moł pu poru nipi pendpi, eim konu ełe si kindpi, Galilii konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pe Jiisas eim pupu Galilii konu ełe tor pang, wumb eim onum nik ka piinjing. Nimbił erang, ok en enim kor owundu kuni owii, ‘Pasopa’ niłmin kunum ei Jerusalem konu ełe puk Jiisas nge epi kanim kanim erim ei kenjing. ");
INSERT INTO nii_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nga Jiisas eim opu, Galilii konu ełe orung konu endi Keina niłmin ełe tor om. Konu ełe ok eim noł mendpił ei erang opu noł wain mendpił pim konu ełe. Pe Kapaniyam konu ełe gapman nge epi tep ełim wu endi mułum. Wu ei eim kingam ening tum. ");
INSERT INTO nii_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wu ei eim mołpu piim ni, Jiisas Jura konu si kindpi, Galilii konu ełe onum ninjing. Wu ei yi piipi eim pupu, Jiisas kin dinga kii sipi yi nim, “Nim kapłi mani na ngii pukun, na kangi kułmba mandi enim. Ei er ka erkin se konj sinjii,” nim. ");
INSERT INTO nii_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jiisas eim ek nipi eim ngum, “Pe enim jep oł kanim ei kinenjing kin, enim pii gii ninerngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pe gapman nge epi tep er mołułum wu ni yi nim. “Owundu, nim sikir mani oi! Mon peng kin, na kangi ei kołpu ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jiisas ek nipi wu ei ngopu yi nim, “Nim po! Nim kinganim ei konj kindpi mułmba,” nim. Wu ni Jiisas nim ek ei pii gii nipi pum. ");
INSERT INTO nii_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wu ni eim andłam ełe pupu peng, eim nge kongun wumb tor ok, eim kanik yi ninjing, “Nim kinganim ni ka wii mołum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Pe wu ni eim kongun wu ombu kii sim, “Konu eni kunum nenj eim ka wii mił mułum?” “Oltin konu eni beli orung kunum ei, eim ening ei poru neng, ka wii mułum,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yi nengin kin, arim eim piim oltin kunum ełe Jiisas ek yi nim, “Nim kinganim konj mułmba,” pa yi nim, ei piim. Pe eim pii gii neng, eim nge wumb tiłap ei kin ouni Jiisas kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jiisas eim Juriya konu ełe si kindpi pupu, Galilii konu om. Opu kin, Galilii konu ełe, eim jep oł nga ei eririm. Jiisas eim ok noł wain eririm. Nga wu ei kingam er ka erim, jep oł tał mił erim. ");
INSERT INTO nii_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pe ei poru neng kin, Jura wumb kor owundu nge kuni owundu endi tonu onum nengin kin, Jiisas eim Jerusalem konu ełe tonu pum. ");
INSERT INTO nii_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem konu ełe mandi kung siipsiip ngii ondu konu ełe endi sim konu ełe, noł gopu kembis endi mułum. Noł ei Eipru wumb ek embe ełe embe yi siłmin, ‘Besesra’ niłmin. Konu ełe ngii tika angił orung engim. ");
INSERT INTO nii_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ngii tika ełe, wumb pei ening pim wumb ni, ningił kis mułum wumb ni, simb kis mułum wumb ni, wumb ngenj embił pei kułum wumb, pei konu ełe mulnjung. Noł ei ołup tumba ni kui er mułułmun. ");
INSERT INTO nii_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Kunum endi, Gos Owundu nge enjel endi kindang opu, noł ełe mandring pupu, noł ei ołup tang kin, wumb endi ok opu mani noł ełe pułum ei, eim ening ei poru nipi, ka sałiłim. ");
INSERT INTO nii_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Wu endi ngii tika ełe mułum wu ei, eim ening kunum kinan tang pałiłim. Wu ei kung ngii 38 pei mułum. ");
INSERT INTO nii_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jiisas opu kenim ni, wu ei or pepi mułum. Jiisas piinim ni wu ei ening kunum kinan tum pim. Pe Jiisas ek nipi wu ei ngum, “Nim ngenj ei opu, ka ba ni piin min?” ");
INSERT INTO nii_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ening pim wu ei ek nipi orung kindim, “Wu Owundu, noł ei ołup ełim kunum ei, wu endi na paki tangin bii ei, wu endi mon. Nam bii ni ełe ei, kapłi enerang, wumb na to mani kindik, ok ku noł ełe puk pułmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jiisas ek nipi eim ngopu yi nim, “Nim tonu angkin ninim peł ei sikin pui!” nim. ");
INSERT INTO nii_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pe sikir wu ni angpi, eim peł ei sipi pum. Pe kunum ełe, kor kunum. ");
INSERT INTO nii_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jura wumb wu ei kanik yi ninjing, “Pe kor kunum ei, nim nimbił erang peł ei ko wukun tu wun? Ninim nge peł tu wun ei, sin nge men tołmun lo ełe mon ninim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ba wu ening peng opu ka pum wu, ni ek yi nim, “Wu ei ka er ka erim wu ei eim yi nim, ‘Nim peł ei sikin pui!’ nim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pe wumb eim kii sinjing, “Wu nii nim peł ełe sikin pui nim?” ");
INSERT INTO nii_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ba wu ening pim wu opu ka pum wu ei, Jiisas pii kun enerim mon. Nimbił erang, wumb pei tuk ełe mulnjung. Jiisas eim konu eipi pum. ");
INSERT INTO nii_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ekii se Jiisas wu ei, men tołmun ngii owundu ełe kanpi wu ei nim, “Piini! Nim pe ka mołun; nga oł kis endi enenjii. Nim nga en kin oł embin tui owundu endi nim tonu omba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pe wu ni pupu, Jura wumb kanpi yi nim, “Wu endi na er ka erim, ei Jiisas.” ");
INSERT INTO nii_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yi neng kin, Jura wumb Jiisas tumun ni piik enjing. Nimbił erang, eim oł ei kor kunum men tołmun lo ełe mon niłim kunum ei, Jiisas eim jep oł ei enim. ");
INSERT INTO nii_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ba Jiisas ek nipi orung kindpi yi nim, “Na Arnan ei kunum kunum kongun er mołum. Pe na yi ku kongun ei end,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yi neng kin, Jura wumb, “Jiisas to kundmun mendpił,” ninjing. Nimbił erang, eim lo ek kor kunum pałim ek ei, ekii sipi enałim. Ei ek yi ninim, “Gos ei na Arnan mendpił,” ninim ek ei yi mił, “Eim Gos mił mołpu ninim min?” a yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pe Jiisas ek nipi orung kindpi yi nim, “Na ek keimi mendpił nip enim ngond. Na Gos kingam nam noman ełe oł endi enand, mon. Nam Arnan ełim kanił epi ei minj end. Arnan eim ełim epi pei ei, na eim kingam yi ku ermbii. ");
INSERT INTO nii_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Na Arnan eim noman ka na ngopu, eim epi pei enim mił na andan tołum. Nga Arnan eim kin kongun owundu kombur nga na andan tumba ku. Yi mił erang kin, enim puku sik erngii. ");
INSERT INTO nii_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Arnan eim wumb kułii eim nga noman konj ngołum. Yi mił ku, nam noman ełe wumb ombu noman konj ngamb konj mułngii ni piił ei, na yi mił ku eł. ");
INSERT INTO nii_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Arim, wumb oł kis enjing kin kos piinermba. Eim kongun ei mok topu, na eim kingam kos ei piip ermbii nip, eim kingam ngum poru nim. ");
INSERT INTO nii_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Yi mił pałim, wumb pei Arim embe ambił tonu kindiłmin. Yi mił ku, kingam anm embe ambił tonu kindngii. Wumb endi kingam nam embe ambił tonu kindnenjing kin, Arim eim kindang eim embe ambił tonu kindnerngii,” pa yi nim. (Jiisas eim kin Gos eim kindang om ei, ek ekin mił nim.) ");
INSERT INTO nii_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Na ek keimi mendpił nip enim ngond. Wumb endi na ek ni piipi na kindang onj ei, Gos kin pii gii nim kin, eim noman konj sipi kunum kunum ka mułmba. Wumb ei oł kis enjing, eim kos ei tonu onermba mon! Eim wumb koltmun ngenj ei si kindpi, pe eim noman konj nga sipi kunum kunum mułmba.” ");
INSERT INTO nii_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jiisas ek nga nipi yi nim, “Keimi mendpił na enim kanip nind. Kunum endi tonu omba min, ei pe tonu onum ei, wumb kułii wumb ei Gos nge kingam na ek ei piingii. Wumb na ek ei piingii wumb ei, noman konj sik kunum kunum ka mułngii. ");
INSERT INTO nii_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Na Arnan, eim noman konj nge puł wu, eim noman dinga ei na eim kingam ngum. Pe kingam na yi ku, nam noman konj ka nam kin pałim. Wumb Gos ek pii gii ninjing kin, kingam na wumb ei noman konj ei ngumbii. ");
INSERT INTO nii_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Gos kindang opu mei wu tełim ei, na eim arim eim kingam wumb oł kis enjing kos piipi, ‘Erangłi!’ ni piipi ngum. ");
INSERT INTO nii_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Enim ek ei kin puku sinerngii mon. Kunum endi tonu omba wumb kułii mer tukpu ełe wumb ei, na ek ei nimbii piingii. ");
INSERT INTO nii_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Piik, tukpu konu ełe si kindik tor ongii. Wumb oł kun ełmin wumb ei angk, noman konj sik kunum kunum mułngii. Wumb oł kis kanim kanim erik kulk wumb ei, angk tonu ok, nga oł kis enjing kos ełe piik kin konu kis pungii.” ");
INSERT INTO nii_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Na nam noman ełe epi endi enermbii. Na Arnan eim ek nim mił piinj ek ei nip, wumb oł kis enjing kos ermbii. Nimbił erang, wumb kos piimbii ei kun ka sałim mił piimbii. Na kindang onj ei, eim noman ełe na ekii sip ermbii end. ");
INSERT INTO nii_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Pe na nam mendpił ek endi ni tor kindmbii ek ei, ek keimi min mon? Nii piimba? ");
INSERT INTO nii_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ba Arnan mołpu na ek ek ei nipi tor kindim. Pe na piind, na ek ei nip keimi mendpił pałim. ");
INSERT INTO nii_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ok enim Jon multum konu, ek nik, kii sik kindik ei, Jon ek keimi na kin nipi tor kindrim. ");
INSERT INTO nii_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Wumb na ek ni tor kindik, na enj oł pułe nik enmin ei, piinand mon. Ba na noman ełe on ek ninim ek ei, Gos enim sipi orung simba ni piip ek ei nind. ");
INSERT INTO nii_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon eim dup alam mił tiłang erpi wumb ngum. Enim noman ełe, dup alam ei kin kunum aninga er ka piinjing,” Jiisas yi ninim. ");
INSERT INTO nii_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ba epi endi ei, Jon na kin ek nirim ei to mani kindim ei, na nge pułe ni tor kindnim. Kongun pei na Arnan ngum kongun ei, er poru nimbii. Kongun ombu na end, na kongun ei erip, wumb andan tamb, wumb piingii nip end. Na Arnan kindang onj ni piingii. ");
INSERT INTO nii_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Arnan ei, na kindang onj. Na Arnan, eim na nge pułe nipi tor kindim. Enim eim ek endi piinałmin. Nga eim kinałmin ku. ");
INSERT INTO nii_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Eim nge ek ei, enim kin pinałim ku. Nimbił erang Arnan wu endi kindang opu, eim kin enim pii gii ninenjing. ");
INSERT INTO nii_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Gos nge ek ka mon ełe gerngii ei, enim noman konj sik, kunum kunum mułngii ni piiłmin. Ek ei, na nge ek pułe ei, ni tor kindiłim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","“Ba enim na kin ok, noman konj ei simin ni piinanmin. Enim noman yi pinałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Wumb na embe ambił tonu kindngii ni piinand. ");
INSERT INTO nii_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ba na enim noman ełe piind. Enim Gos kin noman ka ngok ngok enmin oł ei, enim noman ełe pinałim. ");
INSERT INTO nii_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na Arnan nge noman dinga ełe na onj; ba ei na nind ek ei, enim piinanmin. Ba wu endi eim nge noman dinga ełe nipi omba wu ei, eim nimba ek ei, piingii. ");
INSERT INTO nii_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Enim wumb eipi, sin embe ambił tonu kindngii ni piinmin. Ba enim Gos mendpił tonu mołum ei, sinim embe, ei ambił tonu kindmba ni piinanmin. Pe Gos Owundu tonu mołum ei, enim eim embe ełe, pii gii ningii ei kapłi enanim mon. ");
INSERT INTO nii_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Enim piinmin mił, na Gos kin ek nip enim oł kis kos er ngumbii ni, noman to piinerngii mon! Wu endi enim kin kos er ngumba wu ei, Moses. Wu ei enim piik kin, ‘Sin paki tumba,’ ni piinmin, ba ei enim kos erpi ngumba wu,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pe enim Moses nge lo ek ei pii gii nik pim kin, na ek ei pii gii ningii ku. Nimbił erang, Moses eim na nge ek ei pultum. ");
INSERT INTO nii_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ba Moses eim pultum lo ek ei pii gii ninenjing kin, kapłi na nge ek ei enim pii gii ningii mił nenj?” ");
INSERT INTO nii_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jiisas eim ek ei nipi poru ni pendpi, eim Galilii noł gopu ełe orundung orung pum. Pum konu ei, nga embe, ‘Taiperiyas noł gop’ niłmin. ");
INSERT INTO nii_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Pe wumb tiłap owundu ei eim wumb ening pim wumb ni, eim jep oł pei erim ei, kanik kin, eim pum konu ełe ekii sik punjung. ");
INSERT INTO nii_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jiisas eim nge ekii siłmin wu ombu eim sipi kin, tonu komung ełe tonu puk mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jura wumb kor kunum ka niłmin ei, ‘Pasopa’ kuni owundu niłmin kunum ei mandi omba enim. ");
INSERT INTO nii_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jiisas eim mołpu kin, kan orung orung kind kenim ni, wumb tiłap owundu endi eim kin ongii nge onjung. Pe eim ek nipi, wu Pilip ngopu yi nim, “Sinim kuni min bres konu jiłi sipin wumb ei kuni ngumun?” ");
INSERT INTO nii_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Pilip ek nimba ek ei piimbii nipi kin, Jiisas eim Pilip kii sim. Jiisas eim ermba mił oł ei pii poru nipi nim. ");
INSERT INTO nii_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip ek nipi, orung kindpi yi nim, “Sinim bres top ermin, ei ku 200 mił ba pałim, ei ya mołmun wumb ei, nungii ei kapłi enermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jiisas kin ekii siłmin wumb ei, wu endi embe Endru ei, Saimon Piisa angim, eim ek yi nim. ");
INSERT INTO nii_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kangi endi eim kuni bres embe ‘barlii’ angił orung kin, omu tał eim se mołum. Ei ya wumb tiłap owundu mołmun ei, kapłi ermba pinałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jiisas eim ek yi nim, “Wumb nengin kin, mani mułngii,” pa nim. Wumb konu ełe kui engimb pei pim konu ełe mulnjung. Pe wu konu ełe mulnjung wu ei, 5000 pei yi mił, wu am pei mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Wumb pei mani mułangin kin, Jiisas eim bres angił orung ni sipi kin, Gos kin prei erpi, mok topu, eim ekii siłmin wumb ngum. Nga eim omu tał yi ku erpi ngum. Eim ekii siłmin wumb kuni ei, wumb pei ngok, wumb ei en enim kuni numun ni piinjing mił, nunjung. ");
INSERT INTO nii_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wumb tiłap owundu ei kuni nangin kapłi erang kin, kuni mend orung pei mułum. Pe Jiisas eim ekii siłmin, wu ombu kanpi yi nim, “Enim kuni orung mołum ei, sik kułou tungii. Mon peng kin, kuni ei wii mił ba, ei mon!” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pe wu ombu, bres barlii nunjung orung mułum ei sik girenj kon engki nga tał tu wunjung ei, wumb pei kuni nunjung, orung mułum ei, sik girenj kon tunjung. ");
INSERT INTO nii_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pe wumb pei Jiisas eim jep oł erim ei kanik yi ninjing, “Keimi mendpił, wu ni tor kindiłim wu ei Gos kindang mei konu ełe om ei, sin paki tumba nge om,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pe Jiisas eim piim ni, wumb ei ok eim ambilk, eim en enim king mundngii enjing ei piipi kin, wumb pei si kindpi kin, eim endeim mendpił tonu komung ełe orung pum. ");
INSERT INTO nii_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Konu pou neng, Jiisas eim nge ekii siłmin wu ombu noł gopu ełe mani punjung. ");
INSERT INTO nii_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Puk noł kanu ełe tonu puk kin, Kapaniyam konu ełe orung bin ni piik punjung. Pe konu emii ermba erim kunum ei, Jiisas eim wu ombu kin tor onerim. ");
INSERT INTO nii_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pe wu ombu noł kanu ełe pangin kin, konu pop owundu topu, noł tuk ełe topu, pinin nipi yi erim. ");
INSERT INTO nii_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pe wu ombu noł kanu ełe eim dolu sik pu, konu turii mił ełe puk kenjing kin, ni Jiisas noł peł ełe opu, mani noł kanu ełe mandi om. Wang kin, wu ombu en enim mund mong enjing. ");
INSERT INTO nii_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ba, Jiisas eim opu yi nim, “Enim mund mong enerei! Na mendpił ond,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Wu ombu, eim noł kanu ełe tuk simin nik enjing ni, noł kanu ei pe mendpił, en enim pungii ni piik onjung konu ełe, kun tor om. ");
INSERT INTO nii_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nga kupiiring, wumb tiłap owundu pei en enim yi piinjing. Jiisas eim nge ekii siłmin wu ombu mendpił noł kanu ełe punjung. Jiisas eim noł kanu ełe, tonu pupu, punerim. Noł kanu endi konu ełe, sinałim mon. Jiisas konu ełe tor omba nik, noł gop ełe orungdung wumb ei kupiiring ok, ok konu ełe mulnjung. Ba Jiisas eim noł peł ełe andpi pum ei, wumb en enim piinenjing. ");
INSERT INTO nii_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Taiperiyas konu ełe nge noł kanu kombur ok Owundu Jiisas bres sipi, Gos kin prei erpi, wumb kuni ngang nok enjing konu ełe mandi onjung. ");
INSERT INTO nii_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pe wumb tiłap owundu ei molk kenjing ni Jiisas kin eim ekii siłmin wu ombu kin, konu ełe mulenjing. Pe noł kanu kombur ełe tonu puk, Kapaniyam konu ełe pupun, Jiisas kurmun nik, Kapaniyam konu ełe punjung. ");
INSERT INTO nii_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wumb tiłap ni konu ełe tor puk, Jiisas eim kenjing. Kanik kin, yi ninjing, “Ek emb to wumb ngołun wu, nim kunum nenj ya on?” ");
INSERT INTO nii_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jiisas eim ek nipi, wumb tiłap ei ngopu yi nim, “Na ek keimi mendpił enim kin nip ngond. Enim jep oł pei enj kanik kin, nga na kuruk onanmin mon. Ba enim kuni bres ei nangin, pinang punum ei piik kin, na kuruk onmun?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nga Jiisas eim yi pim, “Enim ya mei ełe kuni minj numun kuni ei namin ni piik, ełe nge kongun enerngii mon. Ba enim kongun erngii ei, noman konj kunum kunum mułngii ei nge kongun erngii. Noman ei kunum kunum konj sałim kuni ei singii. Singii kuni ei nge, wu kingam Gos kindang mei konu ełe mani opu wu tełim ei, enim ngumba. Arnan Gos eim noman dinga wii ei, na kin ngum poru nim.” ");
INSERT INTO nii_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pe wumb ei ek yi mił ninjing, “Sin nimbił oł erpin, Gos nge kongun ei erpin bin?” ");
INSERT INTO nii_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jiisas ei nipi orung kindpi yi nim, “Gos nge kongun ei yi pałim. Enim Gos na kindang ya mei ełe op kin, na kin pii gii ningii.” ");
INSERT INTO nii_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wumb ei en enim yi ninjing, “Nim jep oł nipe jep oł eran, sin nim kin pii gii nimin? Pe nim kongun nipe kongun enjii? ");
INSERT INTO nii_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Kumb ok sin nge kupenjpin noł ei, wumb mulenjing konu ełe kuni mana ei, sik nunjung. Gos nirim ek yi mił ninim, ‘Gos tonu epin konu ełe kuni ei, ngang kin nunjung.’ Pe nim kuni yi ku, sin nga numun ni piik enjing.” ");
INSERT INTO nii_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Wumb ek yi mił nengin kin, Jiisas eim ek nipi orung kindpi yi nim, “Na ek keimi nip enim ngond. Moses eim tonu epin konu ełe kuni keimi ei sipi kin enim kupenjing noł ei ngunerim mon. Na nge Arnan eim tonu epin konu ełe kuni keimi ei, noman konj kunum kunum enim ngonum. ");
INSERT INTO nii_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gos eim bres ei ngum bres ei, tonu epin konu ełe si kindpi, mani om bres ei, mei wumb noman konj ka ngomun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Pe wumb ei enim yi ninjing, “Owundu, nim bres ei, sin kunum kunum ngunjii!” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jiisas ek yi nim, “Na nam kuni ei nge, noman konj wumb singii sałim ei nam. Wumb endi na kin omba wumb ei, nga epi endi simbii ni piinermba mon. Ei yi mił, wumb ei, nga kuni tang piinermba. Nga wumb endi na kin pii gii nim kin, eim noł nga nuwa erang kin, piinermba mon. ");
INSERT INTO nii_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Na enim kanip ninj, enim na kan poru ninmin. Ba enim na kin pii gii ninenjing mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","“Pe wumb pei na Arnan ngumba wumb ei, na kin ekii sik ongii. Wumb endi na kin omba ei, na eim to tor kindnermbii; keimi mendpił mon! ");
INSERT INTO nii_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Na tonu epin konu ełe si kindip, mani mei konu ełe onj ei, nam noman ełe ekii sip, endmbii nip onenj, mon! Na Arnan eim kindang onj ei, eim nge noman piimba mił ei, na ekii simbii. ");
INSERT INTO nii_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Eim noman ełe yi piipi kin, na kindang onj ei, yi mił; wumb pei eim na ngopu poru nim ei, na wumb endi si kindnermbii mon. Ekii se muł mei poru nimba kunum ei, nam wumb pei Gos kin, nga konj sip orung simbii. ");
INSERT INTO nii_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Na nge Arnan ei eim noman yi pałim. Wumb pei na kangi ei kanik pii gii ninjing kin, noman konj ka sik kunum kunum mułngii. Mułngii wumb ei, na kunum poru nimba kunum ełe, wumb ombu na konj sip orung simbii.” ");
INSERT INTO nii_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jiisas eim yi nim, “Na nam kuni bres ei tonu epin konu ełe, si kindip mani onj.” Yi neng kin, Jura wumb ek ei piik, popuł sik, eim ek ngok, ek pei nik eim ngunjung. ");
INSERT INTO nii_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Pe wumb en enim yi ninjing, “Wu ei Jiisas, Josep nge kingam. Sinim eim arim mam ei kaninmin. Nimbił erang eim yi ninim? Na tonu epin konu ełe si kindip mani mei konu ełe onj,’ ninim?” ");
INSERT INTO nii_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pe Jiisas eim ek dinga nipi, orung kindpi yi nim, “En enim mołmun tuk ełe, ek eipi eipi ninerngii mon! ");
INSERT INTO nii_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Wumb endi na kin wii onermba, mon! Na nge Arnan ei na kindang kin, na onj. Eim wu endi tu wupu, na ngum kin wumb ei, eim kunum poru nimba kunum ełe, na wumb ei, nga konj sip orung simbii. ");
INSERT INTO nii_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ek ni tor kindi kindiłmin wumb mon ełe ek ka pałim ei, ‘Gos wumb pei, ek ei emb topu wumb ngołum. Pe wumb ei, na nge Arnan ek ei piik, ekii sik poru nik wumb ei, na kin ołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Wumb endi Gos endeim kinałmin mon. Na Gos kin ouni mołup kin, na kindang mei ełe onj. Na endeim mendpił, na Arnan Gos kanił. ");
INSERT INTO nii_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na ek keimi mendpił nip enim ngond, wumb endi na kin pii gii nimba wumb ei eim noman konj sipi kin, kunum kunum mułmba. ");
INSERT INTO nii_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nam kuni ei nge, noman konj wumb singii sałim ei, nanim ngoł. ");
INSERT INTO nii_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Kumb ok, enim nge kupenjing noł, wumb mulenjing konu ełe kuni mana niłmin kuni ei nok, kolk mon erik, poru nik. ");
INSERT INTO nii_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ba pe kuni ei eim tonu epin konu ełe si kindpi mani om kuni ei, na nam moł kuni ei, wumb endi sik nungii ei, na kin pii gii ningii wumb ei, kunum kunum konj mułngii. ");
INSERT INTO nii_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na kuni ei, noman konj peng kin, tonu epin konu ełe si kindip, mani onj. Pe wumb endi, kuni ei sipi nim kin, eim noman konj sipi, kunum kunum mułmba nge, ei simba. Pe na kuni ei, eim ngumbii ei, nam ngamb to kundangin kin, mani mei ełe wumb ei noman konj singii.” ");
INSERT INTO nii_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pe Jura wumb en enim mołmun tuk ełe ek eipi nik yi mił ninjing, “Nimbił erang eim ngenj ngopu kin, sinim ei ngenj kuni mił ei ngumba?” ");
INSERT INTO nii_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jiisas eim ek nipi, orung kindpi yi nim, “Na ek keimi nip enim ngond ei, Gos kindang mani opu mei wu tełim ei, na kołup miyem bein tamb kin, wumb na kin pii gii ningii wumb ei, noman konj kunum kunum mułngii ei, singii. Ei yi mił, wumb endi kuni ni, noł nunjung kin kunum kunum konj mułngii. ");
INSERT INTO nii_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wumb endi na nge miyem ngenj mił epi nołmun wumb ei eim noman konj sipi kin, kunum kunum mułmba. Gos Owundu kunum poru nimba kunum ei, na wumb ei nga konj sip orung simbii. ");
INSERT INTO nii_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nimbił erang, na nge ngenj kin miyem ei, noman tuk nge kuni mendpił mołum. ");
INSERT INTO nii_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wumb endi na ngenj, miyem mił epi ei nopu, na kin piipi, mułmba wumb ei, na nam wumb ei kin mułmbii ku. ");
INSERT INTO nii_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Arnan eim konj kunum kunum mołpu kin, na kindang op, Arnan nge noman dinga ełe nge, nam noman konj moł. Pe yi mił ku, wumb endi na ngenj mił epi ei num kin, nam nge noman dinga ełe, eim noman konj kunum kunum sipi, mułmba ei, eim ngumbii. ");
INSERT INTO nii_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pe kuni ei tonu epin konu ełe si kindpi mani om kuni ei, ok enim kupenjing noł wumb mulenjing konu ełe, kuni nok, kolk poru ninjing, ei kin ende mon. Wumb endi, kuni ei num kin, eim noman konj sipi, kunum kunum mułmba,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Kapaniyam konu ełe men tołmun ngii ełe, Jiisas eim ek emb topu, wumb ngopu, eim ek yi nim. ");
INSERT INTO nii_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pe Jiisas eim kin ekii siłmin wu pei ek ei piik, noman embin to piinjing. Piik yi ninjing, “Wumb nii endi ek ei piimba?” ");
INSERT INTO nii_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ba eim ekii siłmin wu ombu, ek ei piik kin, ek orung orung ninjing ei, Jiisas ei eim noman ełe, ek ei piim. Jiisas eim nge ekii siłmin wu ombu ngopu yi nim, “Enim ek ei enim noman ełe to kis enmin?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","“Pe Gos kindang mani mei wu tełim ei, na mani onj, konu ełe nga orung epin konu ełe tonu pup kin, nimbił oł mił piingii ei, enim kis piingii? ");
INSERT INTO nii_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Noman konj ei, Gos Gui Ka wumb ngołum; ba sinim wumb noman konj sinałim. Pe sinim ngenj ei, wumb kułii mił mołum. Na ek ei nip enim ngond ek ei, enim noman ełe kuni mił mołum ek ei, enim noman konj ngołum. ");
INSERT INTO nii_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ba enim mołmun konu tuk ełe mołmun wumb ei, kombur pii gii ninanmin.” Kumb ok pii gii ninarik mulnjung wumb ombu ei Jiisas piim. Wumb ei, na nge opu orung wumb konu ełe, ni tor kindmba ni yi piirim. ");
INSERT INTO nii_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pe Jiisas ek yi nim, “Wu endi na nge opu orung wumb kin na ni tor kindmba ei nge na piip kin, ok ek ei, nip enim ngunj,” pa nim. “Pe na nge Arnan ei, eim dinga wu ei ngunełang kin, wu ei na kin onełang mon.” ");
INSERT INTO nii_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jiisas ek ei nipi, poru neng kin, wu ombu Jiisas kin ekii sik erik, wu ombu Jiisas si kindik, en enim orung punjung. Puk kin, nga Jiisas kin tep to endnenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pe Jiisas eim ek nipi, eim kin ekii siłmin wu engki nga tał ei, kanpi yi nirim, “Enim yi ku, na si kindik, pungii enmin min?” ");
INSERT INTO nii_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon Piisa eim ek nipi, orung kindpi yi nim, “Owundu, pe sin konu jiłi orung bin? Nim nge ek ei mendpił, noman konj kunum kunum sin kin noman konj ngumba. ");
INSERT INTO nii_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sin nim kin pii gii nipin poru ninmin. Nim Gos nge oł kun ka nge puł wu ei, sin piinmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jiisas ek nipi, orung kindpi yi nim, “Nimbił erang na enim wu engki nga tał wii top sinj; ba enim mołmun konu tuk ełe wu endi mołum ei, Seisen gui kis eim kin mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jiisas ek nim ei, Juras Saimon Eskeriyas nge kingam ei kin piipi nim. Jiisas kin ekii sinjing konu ełe tuk mołmun, wu engki nga endeim mulnjung konu ełe tuk, eim mułum. Ba ekii se, wu ei eim Jiisas sipipi, opu orung wumb angił ełe ngopu kin, ku sim. ");
INSERT INTO nii_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pe ei poru neng kin, Jiisas eim Galilii konu ełe endim. Ba Jura wumb eim tumun ni erangin kin, eim Juriya konu ełe nga endnerim mon. ");
INSERT INTO nii_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jura wumb en enim kor owundu kunum endi alap ngii ełe kuni owundu nołmun oł ei nge, kunum ei tonu omba ei, mandi enim nik enjing. ");
INSERT INTO nii_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pe Jiisas eim angim noł yi ninjing, “Nim ya konu ełe si kindkin Jura konu ełe pan, nim kin ekii sik ok wu ombu, nim enjii kongun ei keningii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wumb ombu Jiisas kin ek yi ninjing, “Pe wu endi eim peni ełe mułmbii ni piip, yi ełim ei, eim epi koi er enałim mon. Nim epi yi ermbii ni piikin kin, pukun wumb ningił ełe pei enjii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jiisas eim nge angim noł ei, eim kin pii gii ninarik kin, ek yi mił ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yi nengin kin, Jiisas ek nipi yi nim, “Kunum ei wumb pei na piik kanik erngii ei, tonu onanim; ba enim kuni owundu pungii kunum ei, noman ełe pei sałim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","“Ya mei wumb ei, en kin opu orung er ngunerngii mon; ba na kin opu orung enmin. Ei nimbił erang, na ek nip tor kindił ei, ‘En enim oł kis enmin ei,’ na ni tor kindip kin, ek yi mił ei na kin opu orung enmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","“Pe en enim kuni owundu ei puk, Jura wumb kor kunum ka niłmin kunum ei, puk keningii. Ba pe nga, na kor kunum ka ei pup kinermbii. Na bii kunum ei tonu onanim. ");
INSERT INTO nii_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jiisas eim ek yi nipi kin, eim Galilii konu ełe kunum kombur nga enj mułum. ");
INSERT INTO nii_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jiisas nge angim noł ei Jura wumb kułou tok ełmin konu ełe keningii nge ok punjung. Pe eim yi ku ekii se pum. Jiisas eim pum ei, peni ełe punarpi kin, koi mił erpi pum. ");
INSERT INTO nii_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jura wumb kułou tok mulnjung kor kunum ka ełe molk. “Wu ni jiłi punum?” pa nik, kuruk mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Pe Jura wumb eim kin ek kanim kanim ninjing. Wumb kombur molk, “Mon wu ei, wu ka,” pa ninjing. Ba wumb kombur molk yi ninjing, “Mon wu ei, eim wumb kanpi kin, ek kend topu niłim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jura wumb kombur Jiisas kin pii gii nik, wumb pei konu ełe tuk mulnjung; ba lo ek piiłmin wumb kin mund mong enjing. Erik kin, wumb endi tonu angk, Jiisas nge ek endi ninenjing. Nimbił erang, wumb endi ek nipi, “Jiisas ei Mesiya” nimba wu ei, men tołmun ngii ełe, to anda kindngii niłmin, pim. ");
INSERT INTO nii_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pe Jura wumb kuni owundu kunum ka nik ełmin kunum ei, aninga mandi no poru ningii, er mułangin kin, Jiisas Gos ngii owundu tuk ełe angpi, ek nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pe Jura wumb kenjing ni mon gerpi nim. Neng kin, wumb puku sinjing. “Eim mon konu endi pupu neng kin, kinenjpin mon? Nga eim mon ei gernim mił nenj?” ");
INSERT INTO nii_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pe Jiisas wumb ei ek nipi ngopu yi nim, “Na pe nip, enim ngond ek ei, na nge mon. Ei Gos nge ek, eim na ‘Pui’ nipi, kindang kin, na onj. ");
INSERT INTO nii_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pe wumb endi, Gos ek ei piipi nipi, ermba wumb ei, eim na nind ek ei piipi om kin, eim Gos kin ba. Min na nam noman ełe ek ei nind. ");
INSERT INTO nii_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wu endi eim noman ełe, ek ninim ei eim embe tonu ba ni piipi ninim. Ba wu endi kindang om ni piipi kin, eim embe er tonu kindpi kin, ek kun nipi ermba wu ei, eim oł kis endi eim kin pinermba, mon! ");
INSERT INTO nii_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kumb ok Moses enim lo ek nipi, ngurum kunum ei, enim mołmun konu tuk ełe, wumb endi lo ek ei, ekii sinarik; ba enim na nimbił erang na to kundmun, ninmin?” ");
INSERT INTO nii_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Wumb ek nik, orung kindik yi ninjing, “Nim gui kis endi nim kin mołum. Wumb endi nim to kundnerngii mon!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jiisas eim ek nipi, orung kindpi yi nim, “Na jep oł owundu endi enj ei, enim pei puku sinjing,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","“Moses enim ngenj kopsingii oł ei, nipi ngum ei keimi. Pe enim oł ei, Moses kin onerim mon. Oł ei enim nge kupenjing noł kin tonu om; ba enim kangił kunum tonu opu, ngenj kor owundu kunum ełe kopsiłmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","“Pe enim Moses nge lo ek ei, am kun ekii siłmin. Ba en enim kangił ei, kor owundu kunum tu wuk kin, ngenj kopsiłmin. Pe na yi ku, kor owundu kunum ei, wu ening pim wu ei, er ka enj; ei nimbił erang na kin popuł sinjing? ");
INSERT INTO nii_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Epi ningił ełe kanik kin, epi mok tunerngii! Enim epi pei mok tungii ei, oł kun pałim mił kun erngii!” ");
INSERT INTO nii_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pe wumb Jerusalem konu ełe mołmun wumb kombur ek yi ninjing, “Nimbił erang wu ei to kundmun ninjing wu min?” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","“Pe kineł! Eim wumb mulnjung konu peni ełe, ni tor kindnim. Nga wumb ek endi ni orung kindnanmin. Pe keimi, Jura wu num peng pim wu ombu, piinmin ei, Gos kindim wu Krais min?” ");
INSERT INTO nii_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pe sinim wu ei eim nge ngii konu ełe sinim piinmin. Nga Krais omba kunum ei; ba wumb endi eim nge ngii konu ełe piinerngii. Yi peng kin Jiisas ei Krais ya mon,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jiisas men tołmun ngii ełe Gos ek ei piipi wumb tor kindpi mułang kin, ek kombur ei piipi, eim ek dinga nipi, orung kindpi yi nim, “Enim na piinmin! Na ngii konu ełe enim piinmin ku! Ba na nam noman ełe onenj, mon. Na Arnan eim na kindang kin, onj ei, oł kun mendpił pałim mił end; ba enim pii kun enanmin mon! ");
INSERT INTO nii_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na nam eim piind. Na Gos kin ouni muls. Gos eim na kindang kin, na mani mei ełe onj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Pe wumb eim kan ngumun ni piinjing; ba Jiisas eim kongun ei poru ninerim. Yi peng kin, wumb endi Jiisas embiłmba mił, pinerim mon. ");
INSERT INTO nii_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pe wumb pei eim nim ek, pii gii nik, yi ninjing, “Gos kindang wu Krais tonu om kin, eim jep oł pei erpi, ya ei enim jep oł ombu to mani kindpi, kapłi piipi yi enermba mon!” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Lo ek piiłmin wumb ei, piinjing ni wumb pei Jiisas nge ek ei eipi eipi nengin kin piinjing. Lo ek ekii sik ełmin wumb ni, kułmał kałiłmin wumb pei puk, opu ond wu kombur nengin puk kin, eim kan ngungii nge punjung. ");
INSERT INTO nii_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Pe Jiisas eim ke nipi, wumb ngopu yi nim, “Na enim kin kunum aninga er moł. Nga na eim kindang onj konu ełe orung bii,” nim. ");
INSERT INTO nii_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","“Na bii konu ei, enim kuruk endngii ei, na kapłi kan sinerngii, mon! Nga na bii konu ełe, enim kan sinerngii mon!” ");
INSERT INTO nii_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pe Jura wumb en enim ek nik yi ninjing, “Eim konu jiłi pang kin, sinim eim kur andinmin ninim? Eim sinim Griik wumb konu ełe pupu kin, Griik wumb kin, ek nipi ngopu, ermba ninim min? ");
INSERT INTO nii_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Pe eim yi ninim, ‘Enim na kuruk pungii ei, kan sinerngii,’ ninim. Nga, ‘Nam bii konu ełe, enim kapłi punerngii,’ pa ninim. Ek ei pułe er pałim mił nenj?” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jura wumb kor owundu kuni owundu simba kunum ei, mandi poru neng kin, kunum owundu mendpił pałim. Jiisas eim angpi ek dinga yi nim, “Wumb endi na kin pii gii ninjing pim kin, kapłi na kin ok pii gii ningii. Yi mił peng kin, wumb endi noł nuwa mułum kin, na kin wang, noł ngamb numba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ei Gos nge ek ełe yi ninim, ‘Wumb na kin pii gii ningii wumb ei, eim noman tuk ełe noł konj mił tonu omba,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jiisas ek ei, Gos Gui Ka kin ek yi nim, “Wumb na kin pii gii ningii wumb ei, eim Gui Ka ei singii.” Kunum ei, Jiisas eim nge tiłang owundu ei sinarpi kin, epin konu ełe tonu orung punerim kunum ei, Gui Ka ei tor onerim. ");
INSERT INTO nii_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wumb kombur Jiisas ek ei piik, “Keimi mendpił wu ei, Gos ek ni tor kindiłim wu mołum,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Nga wumb kombur yi ninjing, “Wu ei, Gos kindang nge wu Krais tonu om,” pa ninjing. Nga wumb kombur ek eipi nik yi ninjing, “Gos kindim wu Krais eim Galilii konu ełe tonu omba min? Jiisas eim Gos kindim wu Krais mon, ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Gos nge ek ełe yi nirim, “Gos kindang wu ei Krais eim Deipis nge tiłap ende. Pe eim Beslem konu ełe tonu omba nirim konu ełe, ok Deipis multum konu ei sałim.” ");
INSERT INTO nii_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wumb ek yi nik kin, wumb tiłap tał erik, Jiisas kin eipi eipi punjung. ");
INSERT INTO nii_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Wumb kombur, “Eim kan ngumun,” ninjing; ba wumb endi eim embiłmba wumb endi, mulerim mon. ");
INSERT INTO nii_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pe opu ond wu ombu, nga orung puk kin, lo ek piiłmin wu ni, kułmał kałiłmin wu owundu ombu ni, kanik yi ninjing, “Enim nimbił erang, wu ei tu wunmun? ");
INSERT INTO nii_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yi nik opu ond wu ombu, ek ni orung kindik yi ninjing, “Ok wu yi nge endi, opu ek wu ei ninim mił ei ninerim mon!” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yi mił nengin kin, pe lo ek piiłmin wumb ombu ek yi ninjing, “Wu ei, enim kin ek kend topu ngonum, ku min? ");
INSERT INTO nii_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Enim kanmin ei, sin lo ek piipin, ełmin wu ombu ni, men tołmun wu num ombu ni, endi pii gii nik erangin kin, kenjing min? ");
INSERT INTO nii_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ei mon! Ba wumb Jiisas kin pii gii ninjing ya wumb ei, Moses lo ek piinarik enmin, wumb ei, Gos kos owundu singii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Wu Nikoriimas ei wu ombu nge men tołmun ngii kongun ende ełmin wu ei, eim ok, epin tuk memb kunum ełe Jiisas kin purum. Wu ei eim ek yi nim, “Sinim lo ek ei wumb kos wii er ngumun ninim? Ei mon! Sinim eim nge ek ei ok piipin, eim nimbił oł erim ei piimin,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Pe lo ek piiłmin wu kombur, eim kin ek nik kii sinjing. “Pe nim Galilii konu ełe wu min? Lo ek ei, ger kankin, enjii. Ek ni tor kindiłim wu endi, Galilii konu ełe tonu onermba,” pa nik yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","(Wumb pei en enim ngii konu ełe eipi eipi pangin kin, nga Jiisas eim tonu komung Olip ełe tonu pum. ");
INSERT INTO nii_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kupiiring ok eim pupu kin, men tołmun ngii owundu ełe nga pum. Pang kin, wumb pei eim kin wangin eim mołpu kin, ek emb to nipi, wumb ngopu kin, yi er mułum. ");
INSERT INTO nii_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Lo ek piiłmin wu ni, lo ek połmun wumb ni, amb sik ełmin oł ei, amb endi lo ek ei to kindim nik, tu wuk kin, tuk ełe engindangin engim. ");
INSERT INTO nii_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Engang kin, ek nik Jiisas ngok yi ninjing, “Ek emb to wumb ngołun wu, ya amb ei wu puk enmin oł ei to kindim ni kenjing,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","“Moses nge lo ek ełe, wumb ombu yi erngii ei, kom ku to konduk erngii, pa nipi pendim. Pe nim nipe ek ninjii?” ");
INSERT INTO nii_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Wumb en enim yi piinjing, “Sin ek yi ninmin. Eim nipe ek nimba ei, piipin kin eim oł kis kun pinermba mił ermba, ni kenjing. Ba Jiisas eim kan mani kanpi kin, eim angił orung ei sipi, mei ełe mei tumb mił nipi, mani kanpi er mułum. ");
INSERT INTO nii_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wumb am ek nik, kii sik mułangin kin, Jiisas eim angpi, ek nipi, wumb ngopu yi nim, “Enim mołmun konu ełe wumb endi eim oł kis enałim wu endi mułum kin, eim amb ei ok, ku tangłi,” nim. ");
INSERT INTO nii_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jiisas eim ek yi nipi kin, nga mani mołpu kin, mei ełe mei tumb nipi, mani kanpi er mułum. ");
INSERT INTO nii_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Pe wumb ek ei piik kin, en enim oł kis erpin ni piinjing wumb ei, pei endeim endeim ni, anda punjung. Puk wu num ombu, kumb se pangin kin, wumb wii ekii se punjung ku. Jiisas endeim mendpił mułum. Nga eim mułum konu ełe amb ni opu, eim kumb ełe engim. ");
INSERT INTO nii_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Pe Jiisas eim angpi kin, yi nim, “Amb, wumb ni jiłi mołmun? Wumb endi, nim kin kos ermba wumb endi mołum min mon?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Amb ni ek yi nim, “Owundu, wumb endi mulałim mon!” Pe Jiisas yi nim, “Na yi ku, nim kos enermbii. Nim po! Pukun, nga oł kis endi enerii mon!” ni Jiisas yi nim.) ");
INSERT INTO nii_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ekii se Jiisas wumb men tołmun tuk mołmun wumb ek nipi yi nim, “Na nam mei wumb ełe tiłang moł. Wumb endi na kin pii gii nim kin, eim noman tuk ełe, emii pinermba mon. Wumb ei, eim tiłang konu ei eim kin pimba wu ei, noman konj simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Lo ek piik ełmin wumb ei ek nik, eim ngok yi ninjing, “Nimbił erang ninim nge nikin ek ei, ni tor kindin? Kindin ek ei, keimi mon,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pe Jiisas eim ek nipi yi nim, “Keimi, na nam nge ek ei nind; ba na nind ek ei keimi. Nimbił erang na nam angip onj konu ei piind. Nga nam bii konu ei piip moł. Ba enim na nam ngii konu ei enim piinanmin. Nga na konu jiłi bii ei, enim yi ku, piinerngii mon! ");
INSERT INTO nii_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pe enim mani mei oł pałim mił ei, wumb mok tonmun. Ba na wumb endi ei, mok tonał mon! ");
INSERT INTO nii_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ba na wumb mok tułamb kin, kapłi na mok kun mendpił tułamb. Nimbił erang, na nam endeim mendpił mon. Na Arnan na kindang mani mei ełe onj ei kin ouni kongun erpił wumb mok tumbuł. ");
INSERT INTO nii_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Enim nge lo ek ei yi pałim, ‘Pe wu tał ek ende mił, ni tor kindngił ei, ek keimi,’ pa yi niłmin. ");
INSERT INTO nii_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na nam ek ei nind. Ei na Arnan na kindang op kin, nam ek yi ku, nip tor kindind.” ");
INSERT INTO nii_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Pe wumb eim kii sik, yi ninjing, “Nim Arnim konu jiłi mołum?” Jiisas ek nipi, orung kindpi yi nim, “Na Arnan, enim pii poł tunanmin ei, enim na Arnan ei enim piinerngii. Ba enim na piinjing kin, kapłi enim na Arnan ei piingii ku.” ");
INSERT INTO nii_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Men tołmun ku sałiłim konu ełe ek ei nirim kunum ei, eim men ngii owundu ełe wumb ek emb topu ngurum. Wumb endi eim sipi, kan ngungii mił pineririm. Nimbił erang, Jiisas nge kongun ei poru ninerim mon! ");
INSERT INTO nii_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jiisas eim ek nga nipi, wumb ngum, “Na pe konu ełe bii ei, enim na kinerngii. Pe enim kułangin kin, oł kis ei enim kin pim kin, na Arnan kin tonu bii konu ełe enim onerngii mon.” ");
INSERT INTO nii_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Eim ek yi neng kin, Jura wumb en enim yi ninjing, “Nimbił erang eim ek yi ninim? ‘Na eim tui min epi endi sipi, eim to kundmba ninim min? Eim kan to kułmba nge ninim min?” ");
INSERT INTO nii_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pe Jiisas eim ek nipi ngopu yi nim, “Enim ya mei mani ełe wumb; ba na nam tonu epin konu ełe nge wu. Enim ya mei ełe wumb; ba na mei konu ełe nge wu mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","“Yi piip kin na ek nip enim ngond. Pe enim kułangin kin, enim nge oł kis ei pepi mułmba. Ełe nge Gos kindim wu ei, na enim pii gii ninenjing kin, pe enim kułngii; ba oł kis pei ei piram pepi mułmba.” ");
INSERT INTO nii_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Pe wumb ek yi ninjing, “Nim wu nii?” Jiisas ek nipi, orung kindpi yi nim, “Ok na enim kanip ninj, wu ei mendpił na moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Enim ełmin oł ei nge, na am ek pei pałim. Na enim ełmin oł ełe, kos wu mił piip ermbii. Ba ei eim, na pui nip kindang onj ei, eim nge ek ei keimi mendpił pałim. Eim nim ek ei, na piip op kin, mei wumb ombu kanip nind.” ");
INSERT INTO nii_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","28","Jiisas Erinjpin Gos kin ek nipi ngum ei, wumb en enim piinenjing mon. Piinerangin kin, Jiisas eim ek nipi wumb ngopu yi nim, “Ekii se enim Gos kindang opu, mei wu tełim wu ei, na ond peri ełe, tonu kindngii. Kindngii wu ei na moł ei, enim piingii. Na nam noman ełe, ek endi ninand mon. Na Arnan nipi, andan to ngurum ek ei mendpił, nip enim ngond. ");
INSERT INTO nii_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na Arnan ‘Pui’ nipi kindang kin, na onj. Eim na kin ouni mołum. Na endeim mendpił mułamb kin, eim na si kindnałim mon. Kunum kunum na eim noman ełim epi ei, minj erip yi eł.” ");
INSERT INTO nii_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jiisas eim ek yi neng kin, wumb pei eim kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jiisas ek yi nipi Jura wumb pii gii ninjing wumb ei ngum, “Pe enim na ek ełe mendpił ekii sik mulnjung kin, na nge ek se endngii wumb mendpił mułngii. ");
INSERT INTO nii_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Molk, ek keimi mendpił ei piik er mułangin kin, ek keimi enim erang tonu ok, kunum ka seng kin, wii mułngii. Oł kis ni, embin tui ni, oł kanim kanim ei enim kin tonu onermba. Ei yi mił enim wumb Seisen nge kongun wii erik, mulerngii mon!” ");
INSERT INTO nii_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wumb ek nik, Jiisas ngok yi ninjing, “Sin Eiparam nge tiłap ende wumb. Sin kunum endi wumb kin kongun wii enałmin. Nim nimbił erang sin opun, kongun ni endi tonu onerang kin, kunum ka seng kin, wii mołmun nin?” ");
INSERT INTO nii_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jiisas ek nipi, orung kindpi yi nim, “Na ek keimi mendpił nip enim ngond. Wumb pei oł kis ełmin ei Seisen nge kongun wii ełmin; ba kumep pułe ei wumb kułngii. ");
INSERT INTO nii_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Kongun wii ełmin wumb ei, ngii konu ełe mulałmin mon. Arim kingam ei, mendpił kunum kunum mołum. Wumb kis en enim yi niłmin, wumb endi, sin tep enermba ninmin wumb ei, en enim am mendpił pungii. ");
INSERT INTO nii_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pe yi mił, Gos kingam ei enim sipi, Gos kin orung sim kin, ei keimi mendpił; enim noman konj sik mułngii. Enim oł kis si kindangin kin, enim kunum ka seng mułngii. ");
INSERT INTO nii_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Na piind ei, enim Eiparam nge tiłap ende; ba na nge ek ei enim noman tuk ełe pinałim. Enim ek ei piinarik kin, na to kundmun ninmin. ");
INSERT INTO nii_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na ek nip tor kindił ei, na Arnan nge epi pei kan poru nip nind. Pe enim yi ku, kupenjing noł ełmin oł ei enim yi ku ełmin.” ");
INSERT INTO nii_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Wumb ei ek ni orung kindik yi ninjing, “Sin nge kupenjpin Eiparam,” pa ninjing. Pe Jiisas nga ek nipi, ngopu yi nim, “Pe enim Eiparam kupenjing noł mołmun; ba enim Eiparam ełim oł ei mił enim enanmin, mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","“Na ek keimi nip enim ngunj ei, na Gos nirim ek ei piip kin, nip enim ngunj; ba pe enim na to kundmun, ninmin. Ba Eiparam eim oł yi nge eneririm, mon. ");
INSERT INTO nii_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Enim kupenjing noł ełmin oł ei enmin.” Yi neng kin wumb ek nik, eim ngok yi ninjing, “Mon, sin kupenjpin endeim mołum ei Gos. Sin eim nge kupam noł mendpił mołpun si kindinmin,” pa ni yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Pe Jiisas eim ek nipi, orung kindpi yi nim, “Keimi, Gos ei enim kupenjing pim kin, enim kapłi na noman ngungii. Nimbił erang, na Gos kin ouni mołup kin onj. Na nam noman ełe onenj mon! Gos na pui nip kindang kin, na onj. ");
INSERT INTO nii_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nimbił erang enim na nge ek ei pii kun enanmin? Pułe yi mił pałim, enim na ek ei piinermin ni piinmin. ");
INSERT INTO nii_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Enim kupenjing ei Seisen nge kupam noł mołmun. Pe enim kupenjing nge noman ełe, ekii sik, dinga puk mołmun. Wu ei ok wumb to kondułum oł yi erpi kin, eim oł kun mendpił pałim ei ekii sinerim mon. Nimbił erang, oł kun ei eim kin pinerim mon. Eim ek kend topu nipi, ek kun mił niłim. Eim ek kend nge puł wu, ei eim mendpił mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","“Ba na ek mendpił ei kun nip enim ngond. Nimbił erang enim na ek ei ekii sinanmin? ");
INSERT INTO nii_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Enim mołmun konu tuk ełe wu endeim angpi kin, na oł kis kun pinerim mił ei en pa yi nimba min? Mon pim kin, na ek mendpił kun pim ek ei ninj. Ba nimbił erang, enim na nind ek ei pii gii ninanmin? ");
INSERT INTO nii_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gos nge kingam noł ei, Gos nge ek pei ei piiłmin. Enim Gos nge kingam noł molałmin mon! Nimbił erang enim Gos nge ek ei piinałmin mon. ");
INSERT INTO nii_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jura wumb ek dinga nik, orung kindik yi ninjing, “Sin nim Sameriya konu ełe wu pa niłmin. Nim gui kis endi nim kin mołum, pa niłmin. Ei keimi mendpił, min mon?” ");
INSERT INTO nii_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pe Jiisas ek nipi, orung kindpi yi nim, “Na gui kis endi na kin mulałim mon. Na nam Arnan nge embe ambił tonu kindił ei, enim na embe ei to mani kindinmin,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Na nam embe ei, tonu ba ni, kongun ei enand mon. Wu endi na nge embe ambił tonu kindmbii ni piinim ei, eim wumb kos piipi, kun erpi, mok tumba. Eim na kin kun ermba ku. ");
INSERT INTO nii_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Keimi mendpił, na enim kanip nind. Wumb endi na ek ei ekii simba wu ei, eim kulermba; ba kunum kunum konj mułmba,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jura wumb ek yi ninjing, “Pe eim nim piinmin nim gui kis endi mołum. Eiparam mułum wu ei kułum; nga ek ni tor kindiłim wumb tonu onjung ei, kulnjung ku. Pe akip nim yi nin, ‘Wumb endi na ek ei, ekii simba wumb ei, kularpi kin, konj kunum kunum mułmba,’ pa nin. ");
INSERT INTO nii_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nimbił oł en? Nim Eiparam sin nge kupenjpin ei, nim to mani kindkin nin min? Eiparam eim kułum, nga ek ni tor kindiłim wumb tonu ok, wumb ei kulnjung ku. Pe ninim wumb nii mił tonu onjii en?” ");
INSERT INTO nii_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Pe Jiisas eim ek nipi orung kindpi yi nim, “Na nam embe ambił tonu kindmbii ei, epi wii mił pimba. Ba nam nge Arnan eim na embe ei ambił tonu mendpił kindnim. Pe en enim yi niłmin, ‘Sin nge Gos’ niłmin. ");
INSERT INTO nii_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ba enim eim piinanmin. Na nam eim piip moł. Pe na nam eim kinał, nimbił ei, enim ek kend tok niłmin mił, yi nimbii. Ei mon! Na nam eim piipi poru nipi kin, eim ek kun ei ekii sind. ");
INSERT INTO nii_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Enim nge kupenjing Eiparam ei eim na mani mei ełe ombii kunum ei kenmbii ni, ka piipi mułum ei, eim kanpi kin, eim noman ka seng mołum.” ");
INSERT INTO nii_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Nga Jura wumb ek nik, Jiisas ngok, yi ninjing, “Nim wu gał kangi wu mołun. Pe nim Eiparam er ken mił nenj?” ");
INSERT INTO nii_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jiisas eim ek nipi, orung kindpi yi nim, “Na ek keimi mendpił nip enim ngond. Ok Eiparam eim tonu oneririm kunum ei, na muls.” ");
INSERT INTO nii_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yi neng kin, wumb kom ku sik, eim tumun nik enjing. Ba Jiisas eim koi erpi kin, men tołmun ngii owundu si kindpi anda pupu pum. ");
INSERT INTO nii_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jiisas eim andpi pupu kin, kenim ni, wu endi ningił tumbun mułum wu endi mułum. Wu ei, kangił kembis mam kirim ełe tor orum ei, yi er pirim. ");
INSERT INTO nii_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jiisas eim kin ekii siłmin wu ombu yi ninjing, “Ek emb to ngołun wu. Pe wu ei, eim oł kis erim min, eim arim mam teł oł kis enjngił min?” ");
INSERT INTO nii_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jiisas eim ek nipi, orung kindpi yi nim, “Wu ei eim oł kis erim kin, nga eim arim mam teł oł kis enjngił pułe ei mon. Ba Gos eim kongun erpi, dinga owundu yi erang kin, eim nge pułe wu ei kin tor wang kin, wumb keningii nipi, wu ei kin tonu om. ");
INSERT INTO nii_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pe mendpił ei, eni kunum mił ka sałim ełe, sinim Gos kongun ermin. Eim na kongun ełe kindang kin, na onj. Gos eim nge kunum poru nimba kunum ei, epin mendpił mił mułmba kunum ei sinim kongun endi kapłi enermba mon. ");
INSERT INTO nii_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pe na ya mei ełe moł ei, na mei wumb nge noman tuk ełe tiłang moł.” ");
INSERT INTO nii_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jii Jiisas eim ek yi nipi, jipambił topu, mani mei eł kindpi kin, mei kin jipambił dangindpi sipi, noł oi mił, wu ningił ełe pendim. ");
INSERT INTO nii_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Pendpi eim yi nim, “Nim pukun, noł gopu Sailom ełe was enjii!” nim. Sailom ei sinim pułe yi nimin, ‘Eim kindang pum.’ Pupu, noł ełe was erpi, orung opu, ningił ka seng kin, kenim. ");
INSERT INTO nii_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wumb eim konu ende wumb ni, ok eim kanik wumb ni, “Wu ei ok mołpu kin, wumb ku ni epi ngei nipi, mołułum wu ei min?” Wumb eim ka mułang kin, kanik ek yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ba wumb kombur yi ninjing, “Wu ei mendpił,” pa ninjing. Nga wumb kombur yi ninjing, “Mon, wu ei mił, wu endi mołum,” pa ninjing. “Ba wu ei, wu eipi.” Pe wu ei, eim mołpu kin, yi nim, “Ei na ya moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yi neng kin, wumb ek nik ngok, yi ninjing, “Nim ningił ei opu, ka erim mił nenj?” ");
INSERT INTO nii_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Pe eim ek nipi, orung kindpi yi nim, “Wu ei, Jiisas niłmin wu ni, eim mei kin noł eningii erpi sipi, na ningił ełe pendpi kin, yi nim, ‘Nim pukun, noł gop ‘Sailom ełe,’ was enjii!’ Neng kin, na pup, was erip, nam ningił ei, ka seng kin, epi kenj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wumb wu ei kii sinjing, “Pe wu jiłi pum?” Wu ni yi nim, “Na kinenj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Pe wumb wu ei ok ningił tumbun multum ni, lo ek piiłmin wumb mulnjung konu ełe sipnjing. ");
INSERT INTO nii_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Kunum ei, kor owundu kunum Jiisas noł oi sipi kin, wu ei kin yi erpi kin, ningił tumbun mułum ei, er ka erim. ");
INSERT INTO nii_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Lo ek ekii siłmin wumb nga wu ei kii sinjing, “Nim ningił ei opu, ka erim mił nenj?” Wu ni ek nipi, orung kindpi yi nim, “Eim noł oi sipi kin, na ningił ełe pindang kin, na pup was eramb kin, na ningił ei tiłang erim.” ");
INSERT INTO nii_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pe lo ek piiłmin wumb ek yi ninjing, “Gos wu ei kindang onerim; eim kor owundu kunum ei eim piinanim min? Eim kor owundu ei lo ek piiłim min mon?” Ba wumb kombur ek yi ninjing, “Oł kis ełim wu ei, jep oł ei ermba mił nenj?” Wumb en enim ek yi nik, en enim eipi eipi puk, tiłap tał mił molk kin, ek yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nik kin, nga wu ningił tumbun mułum wu ei, kii sik yi ninjing, “Pe nim wu ningił er ka erim wu ei, eim embe er sin mił nenj?” Wu ei, ek yi nim, “Ei wu ek ni tor kindiłim wu endi Gos kindim wu,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Keimi, ok wu ei, eim ningił tumbun multum; ba pe, eim ningił ei pirek neng kenim. Ba Jura wumb oł ełe pii gii ninenjing. Pe wu ningił opu, ka pum wu ei, eim arim mam noł wii tunjung. ");
INSERT INTO nii_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Wii tok kin, wumb ek nik, wu amb tał kii sinjing, “Wu ei ełip nge kingenjngił min? Mam mengrim kunum ei, wu ei eim ningił tumbun multum pa ninmbił. Ba pe, nimbił erang eim ningił ka seng kin, epi kan kun enim?” Nik yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Arim mam teł, ek yi ni orung kindinjngił. “Sił piinmbił ei mam mengrim kunum ei, eim ningił tumbun moł pirim ei, sił piinmbił. ");
INSERT INTO nii_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ba pe, eim ningił ei ka seng kin, epi kanpi enim ei, sił pii poł tunanmbił. Wumb endi ni, eim ningił ei er ka erim ei, sił pii kun enanmbił ku. Eim wu dinga mołum ei, eim kapłi enim kii sik piingii.” ");
INSERT INTO nii_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wu ei nge arim mam teł, Jura wumb kin mund mong erkił yi ninjngił. Nimbił erang Jura wumb owundu ek yi mił ni pendnjing wu ei, Jiisas ei Krais Gos kindang wu ei om nimba wumb ei, men tołmun ngii ełe, to anda kindngii nik pendnjing. ");
INSERT INTO nii_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pe arim mam teł, ek pułe nikił yi ninjngił, ‘Eim wu dinga mołum ei eim kii sik piyei!” ninjngił. ");
INSERT INTO nii_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pe nga wumb ek nga nik kin, wu ei ok ningił tumbun multum wu ni, wii tok, se orung sik yi ninjing, “Gos eim jep oł ei erim. Nim Gos nge embe tonu kindkin, ek keimi ninjii. Sin piinmin wu ei, oł kis ełim wu.” ");
INSERT INTO nii_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Wumb ek yi nengin kin, wu ningił ka mułum wu ni ek yi nim, “Na ningił er ka erim wu ei, oł kis ełim wu min, ei na pii kun enand, mon! Ba epi endi na piind ei, na ok ningił tumbun multum; ba pe tiłang erang kin, kanip ei piind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Neng kin, wumb yi kii sinjing, “Eim nim kin, nimbił oł erpi kin, nim ningił ei er ka erim?” ");
INSERT INTO nii_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Wu ni ek dinga nipi, orung kindpi yi nim, “Na enim ok kanip ninj ei, enim piinenjing min? Nimbił erang nga piimin, ninmin? Pe enim wu ei kin ekii singii nge ninmin, min?” ");
INSERT INTO nii_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pe Jura wumb ek kis nik, orung kindik yi ninjing, “Nim eim nge ekii sin; ba sin Moses kin ekii sinjpin mołmun. ");
INSERT INTO nii_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sinim piinmin ei, Gos ek nipi, Moses ngurum. Ba wu ei, konu jiłi tonu om? Ei sin piinanmin!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Yi nengin kin, wu ningił ka mułum wu ni yi nim, “Ei oł endi eipi mił, owundu endi tonu om ei, enim piinanmin. Piinarik kin, konu jiłi wu ei tonu om; ba nam ningił ei erang opu, ka mułum ei piind,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nga nipi yi nim, “Sinim piinmin ei, Gos wumb oł kis erik enmin, wumb ei ninmin ek ei, Gos piinanim mon. Ba wumb Gos kin men tok erik kin, Gos oł keimi pałim mił ekii sik enmin ei, en enim ek ningii ei Gos eim piiłim. ");
INSERT INTO nii_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Am kumb ok mendpił, wu amb endi kangi endi mingang ningił tumbun multum ei, wu endi opu, ei er ka eririm nengin kin, sin piinałmin ei nge ek poł. ");
INSERT INTO nii_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pe Gos ei kindnełang kin, eim oł yi nge endi enełang mon!” ");
INSERT INTO nii_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Lo ek piiłmin wumb ek dinga nik, wu ei ngok yi ninjing, “Nim manim nim mengim ei, oł kis enjing konu ełe nim molkun, okun tonu on. Ei nim oł kis wu mendpił molkun kin, nga sin kin ek emb tokun, man mił ngunjii en min?” Wumb ek yi nik, eim men tołmun ngii owundu to tor kindnjing. ");
INSERT INTO nii_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jiisas eim piim ni, wu ei to anda kindmin nengin kin, eim pupu, wu ei kan sim. Kan sipi yi nim, “Nim Gos kindang opu, mei wu tełim ei kin pii gii nin, min mon?” ");
INSERT INTO nii_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Pe wu ei ek nipi, orung kindpi yi nim, “Wu Owundu, Gos kindang opu, mei wu tełim ei, wu nii? Nim na kan nen kin, pii gii nimbii,” nim. ");
INSERT INTO nii_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Pe Jiisas ek nipi, orung kindpi yi nim, “Nim eim kan poru nin ei, pe nim kin, ek tang mołum wu ei,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wu ei yi nim, “Owundu, na nim kin pii gii nind!” Nipi, mani mei ełe mołpu kin, Jiisas kin men topu erim. ");
INSERT INTO nii_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jiisas eim ek yi nim, “Na mani mei ełe op, wumb mok tumbii nge onj. Wumb Gos ek pii poł tunenjing kin, wumb ei ningił tumbun mił mułang mułngii wumb ei, nga ka seng kin, tiłang mendpił erang kin, kanik pii poł tungii. Ba wumb ningił pe ka seng kin, ka nik, pii poł tonmun ni, wumb ei piik, nga ningił tumbun mił mułangin kin, tiłang mendpił kanik kin, pii poł tunanmin, mon.” ");
INSERT INTO nii_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pe lo ek piiłmin wu kombur ełe mandi molk, Jiisas nim ek ei piinjing. Piik yi ninjing, “Sin yi ku, sin ningił ełe tumbun mił mołang mołpun kin, Gos ek pii poł tunanmin, nin min?” a yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jiisas ek nipi, orung kindpi yi nim, “Enim ningił ei tumbun mił mulełang kin, enim kin Gos ek ei pii poł tunarik kin, enim oł kis endi enenełangin mon. Ba en enim yi niłmin, ‘Sin ningił ei, tiłang mendpił enim,’ yi niłmin ełe nge, enim kin oł kis ei mołum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ek keimi mendpił na enim kanip nind. Wumb endi, kung siipsiip nge kung gui ondu ełe, tuk punermba mon; ba wu endi, konu eipi orung opu, kung gui to tangindpi tuk ołum ei, wu epi waning wu opu, kung siipsiip sipi yi ełim. ");
INSERT INTO nii_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Ba wu endi kung siipsiip kung gui ondu ełe, tuk pułum wu ei, kung es tołum wu mołum. Kung gui ondu ełe, tep mołpu ełim wu ei, eim kung gui ondu aki tang kin, kung siipsiip ombu, eim ek tangiłim ei piiłmin. Nga eim kung siipsiip pei embe sipi sipi ełim wu ei, kung siipsiip kung gui anda siłim. ");
INSERT INTO nii_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eim kung siipsiip ombu pei anda sipi, poru nipi kin, wu ei opu kumb se pang kin, kung siipsiip ombu, eim ek ei piik kin, eim pułum konu ełe, kung siipsiip ekii sik pułmun. ");
INSERT INTO nii_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wumb eipi endi kin, ekii sinałmin mon. Kung siipsiip en enim tungu ełmin. Nimbił erang kung siipsiip wumb eipi ek ei piinałmin mon.” ");
INSERT INTO nii_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jiisas eim ek ekin ei nipi ngum; ba wumb eim nim ek ei, pułe pii poł tunenjing, mon! ");
INSERT INTO nii_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nga Jiisas ek nipi yi nim, “Keimi mendpił, na enim kanip nind. Na nam kung siipsiip kung gui ondu mił moł,” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","“Wumb pei ok, kumb se onjung wumb ei, ek kend tok, epi waning sik ełmin wumb mił onjung. Ba wumb Gos nge kung siipsiip mił mulnjung wumb ei, en enim ek kend tok ełmin; wu ombu nge ek piinenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na nam ngii ondu mił moł. Wumb endi na kin pii gii nim kin, ngii ondu ełe, opu tuk ba wumb ei Gos eim sipi orung simba. Na nge wumb ei, kung siipsiip mił tep er mułmbii ni, pupu anda opu, kuni ka wii sipi nopu ermba ei, yi mił ku, na wumb kuni nin, epi kanim kanim pei ngumbii. ");
INSERT INTO nii_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Epi waning wumb ei, epi eipi endi simba nge onałim mon! Ba kung siipsiip ei, to konduk kin waning sik erngii nge piik ołmun. Ba na mei mani op, wumb pei noman konj singii nge onj. Wumb noman konj wii mendpił sinjing kin, en enim noman ka wii peng piingii. ");
INSERT INTO nii_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na kung siipsiip nge tep wu ka moł. Kung siipsiip teł ka er mołułum wu ei, eim kołpu kin, kung siipsiip ombu paki tumba. Jiisas eim kołpu kin, wumb paki tumba ei piipi kin, ek yi mił nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wu endi ku simba nge piipi ni kongun erpi kin, kung siipsiip es tołum wu ei, kung siipsiip tep wu ka mularpi kin, kung siipsiip nge ernjing mił mularpi ełim wu ei, eim mołpu kaniłim ni, owu simbii endi ołum ei, eim kung siipsiip ombu si kindpi kin, tungu pułum. Pang kin, owu simbii ei opu, kung siipsiip nopu, to eipi eipi kindpi yi ełim. ");
INSERT INTO nii_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nimbił erang wu ku kongun ełim wu erpi kin, kung siipsiip ombu piinałim mon; eim kung siipsiip si kindpi kin, pułum. ");
INSERT INTO nii_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Na kung siipsiip nge tep wu ka wii moł. Na nam kung siipsiip ombu piyamb kin, nga kung siipsiip ombu na piiłmin ku. Ei yi mił, na nge Arnan ei, na piiłim. Nga na eim piił ku. Piip kin, nam nge ngenj ełe kołup kin, kung siipsiip ombu paki tumbii. ");
INSERT INTO nii_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Na nge kung siipsiip eipi kombur mołmun ku. Ei ya ełe nge kung gui tuk ełe mulałmin. Kung siipsiip ei ya ełe tu wamb kin, nam ek ei piingii ku. Ei kung siipsiip tiłap endeim mendpił mułangin kin, nga kung siipsiip tep wu endeim mendpił mołup kin, tep ermbii. ");
INSERT INTO nii_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Na nge Arnan eim, na noman ngum ei, pułe yi pałim. Na nam noman konj ei, si kindamb kin, wumb to kundangin kin, nga angip, tonu op, konj mułmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","“Wumb endi, na noman konj ei, sinermba mon. Na nam nge dinga ełe, nam noman konj ei, wak to kindip kin, nga nam nge dinga ełe nam noman konj ei eipi orung simbii kongun ei, na nge Arnan nipi ek ei na ngum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jura wumb ei, ek ei piik kin, wumb ok eipi eipi puk, tiłap eipi eipi mił mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Wumb pei molk yi ninjing, “Wu ei, eim gui kis tuk mołum! Mułang kin, eim noman wulu pang kin, ek eipi eipi ninim. Nimbił erang, enim eim nge ek piinmin?” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Nga wumb kombur yi ninjing, “Ek ei, gui kis nge ek mon. Pe gui kis ei pim kin, wu ningił tumbun mułum ei, kapłi er ka er kindnermba mon; ba eim wu ei er ka erim,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Men tołmun ngii ei ombu aki tok, kor owundu kunum ka ei tonu wang kin, wumb pei Jerusalem konu ełe punjung. Puk kunum ełe konu jii nirim kunum ełe pirim. ");
INSERT INTO nii_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Men tołmun ngii andaring ond pos olt konu ełe ‘Solomon nge ngii tika,’ yi niłmin konu ełe, Jiisas eim andpi pupu, andaring ngii ełe endim. ");
INSERT INTO nii_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Endang kin, Jura wumb ok eim si pok erik, eim kanik yi ninjing, “Kunum nimberii nim ek nen kin, sin noman tał tonum? Pe nim Gos kindang mei mani wu Krais pin kin, ek ni tor kindan kin, sin piimin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jiisas ek nipi, orung kindpi yi nim, “Na enim kanip ninj; ba enim na pii gii ninanmin. Na kongun pei Arnan nge noman dinga ełe, kongun end ei, nam nge embe ełe andan tum kongun ei tonu onum. ");
INSERT INTO nii_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ba enim kung siipsiip na nge tiłap ende mon pim kin, enim na kin pii gii ninanmin. ");
INSERT INTO nii_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nam nge kung siipsiip ombu, nam ek nił ei piiłmin. Nga nam en enim piił. Nga en enim na nił ek ei ekii siłmin ku. ");
INSERT INTO nii_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yi erangin kin, na en enim noman konj sik, kunum kunum mułngii nge ngoł ei, en enim am punerngii mon! Nga wumb endi na angił ełe, kung siipsiip ombu sipnerngii, mon ku! ");
INSERT INTO nii_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na nge Arnan ei, wumb ei kung siipsiip mił sipi kin, na ngum. Na Arnan eim nge noman dinga ei, epi pei to mani kindiłim. Na nge Arnan angił ełe, wumb endi, na wumb ei, si tor sinermba mon. ");
INSERT INTO nii_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na Arnan kin sik ende mendpił.” ");
INSERT INTO nii_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jura wumb kom ku nga sik, eim tungii nge enjing. ");
INSERT INTO nii_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jiisas eim ek nipi, yi nim, “Na nge Arnan kongun ei na ngang kin, enim kin kunum pei andan tunj. Enim kongun nipe kongun na end ei ni piik kin, enim na tungii nge enmin?” ");
INSERT INTO nii_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jura wumb ek nik, orung kindik yi ninjing, “Sin kongun ka endi en nipin kin, nim kom ku tumun enanmin. Ba nim Gos kin ek buł ambiłin ni tumun nge enmin. Nim wu wii molkun kin, ‘Nam Gos moł,’ nin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Nga Jiisas ek nipi, orung kindpi yi nim, “Wumb ombu ok, Gos nge ek ei en enim piinjing. Gos eim ek nirim mił ei ngurum. ‘En enim gos,’ nim. Pe Gos nge ek ka ei am punermba mon! Nimbił erang ninmin? Enim nge lo ek ei Gos yi mił ninim. Na enim kanip ninj ei, enim Gos mił mołmun. ");
INSERT INTO nii_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ba na Arnan Gos eim na kindang, na ya mei ełe mani onj. Pe na ek yi nind, ‘Na Gos nge kingam,’ pa yi nind. Pe nimbił erang, enim yi ninmin, ‘Nim Gos kin ek buł ambiłin,’ ninmin? ");
INSERT INTO nii_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","38","Pe na nam nge Arnan Gos nge kongun enenj kin, enim na ek ei pii gii ninerngii. Ba na Arnan Gos, eim nge kongun ei na end. Pe enim na ek ei pii gii ninerngii pim kin, na nipe kongun enj ei piik kin, enim pii gii nei! Nik kin, en enim noman pimba mił, ei piingii. Na Arnan ei, eim na kin mułang, nga na eim kin moł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nga wumb Jiisas ambił gii nik, kan ngumun nik enjing; ba eim opu, tor pupu am pum. ");
INSERT INTO nii_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jiisas eim am pupu, noł Joran konu ełe Jon ok wumb noł pendpi erim konu ełe tor pupu, konu ełe mułum. ");
INSERT INTO nii_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Mułang kin, wumb eim mułum konu ełe wumb pei onjung. Ok kin, en enim ek yi ninjing, “Keimi, Jon eim jep oł endi enerim. Ba Jon eim wu ei nge nipi kin, ek pei nim ek ei keimi mendpił pałim,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pe konu orung ełe wumb pei Jiisas kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wu endi ening owundu tang pim wu ei, eim embe Lasaras. Eim Besanii konu ełe pim. Besanii konu ełe, eim nge aim tał Mariya kin angim Masa teł mulnjunguł ku. ");
INSERT INTO nii_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Amb Mariya ei eim kopung mur ka wii tołum epi ei sipipi, Jiisas simb ełe, kopung ka wii kindpi kin, nga eim peng enjin ei sipi, Jiisas simb ełe kil ngum. Ngopu, yi enim amb ei, eim aim Lasaras ei, eim ening owundu tang pim. ");
INSERT INTO nii_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Peng kin, eim aim tał ek nikił, Jiisas mułum konu ełe kindinjngił. Kindkił, ek yi ninjngił, “Owundu, nim noman ngołum wu ni, eim ening owundu tang pałim,” ninjngił. ");
INSERT INTO nii_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pe Jiisas ek ei piipi kin, yi mił nim, “Ening ei eim kułmba ening mon! Ening ei, Gos nge embe ambił tonu kindmba nge erim. Nga Gos nge kingam ei, na embe ambił tonu kindmba erim ku.” ");
INSERT INTO nii_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6","Jiisas eim Masa kin, Mariya kin, Lasaras ni, wumb kei noman ngołum. Jiisas eim mołpu piim ni, Lasaras ening owundu tang pałim, nengin kin, Jiisas eim kunum tał nga mułum konu ełe enj mułum. ");
INSERT INTO nii_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nga ekii se Jiisas eim nge ekii siłmin wu ombu kanpi nim, “Sinim Jura konu ełe orung pamin!” nim. ");
INSERT INTO nii_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pe Jiisas eim kin ekii siłmin wu ombu yi ninjing, “Ek emb to ngołun wu! Pe mendpił, Jura wumb nim ku tumun nik enjing ei piinarkin kin, nga konu ełe bii, nin min?” ");
INSERT INTO nii_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Jiisas ek nipi, orung kindpi yi nim, “Konu eni tonum kunum ei, wumb kongun ełmin. Pe wu endi, konu eni pim kunum ei, andłam ei bok tunałim. Nimbił erang, konu eni topu mei ełe tiłang erang kin, kanpi andiłim. Pe na kin yi mił ku; akip eni tonum kunum ełe, na kongun poru ninanim. Na kunum kułmbii nge kunum ei tonu onanim. Ba nga wumb endi, konu emii pałiłim kunum ełe, andłam andiłim ei, bok tołum. Nimbił erang, tiłang endi, eim kin paki tang kin, andłam andnałim mon. Ba na kułmbii kunum ei tonu onenim kin, na kapłi endmbii. ");
INSERT INTO nii_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jiisas eim yi nipi kin, nga yi nim, “Sinim nge wu puł Lasaras eim or pim kin, pe na to konj kindmbii nge bii end,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jiisas eim kin ekii siłmin wu ombu yi ninjing, “Owundu, pe wu ei eim or pim kin, eim nga kapłi mułmba,” ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jiisas eim Lasaras koltum ni piipi, nirim ek ei nim: ba eim ekii siłmin wu ombu, en enim yi piinjing. Lasaras eim or mendpił peng ninim ni, yi piinjing. ");
INSERT INTO nii_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ba pe Jiisas eim ek yi nipi, wu ombu ngopu yi nim, “Lasaras eim kułum ei, na enim kin ek ekin top ninj ei, enim eim or pałim,” ni ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na enim kin ka piip kin kunum ełe, Lasaras kułum kunum ei, na eim ngii konu ełe sikir punenj. Nimbił erang, akip enim na kin pii gii dinga nga ningii. Ba pe sinim eim kin bin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomas embe endi, ‘Diriimas,’ niłmin ei, eim ek yi nim. “Sinim eim kin ouni kułmun nge pamin!” nim. ");
INSERT INTO nii_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pe Jiisas eim pupu, Besanii konu ełe tor pupu kin, piim ni, Lasaras eim kułum. Kułang kin, tukpu tunjung ei, kunum kapił kapłi, o pum ni piim. ");
INSERT INTO nii_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Besanii konu ei Jerusalem konu ełe owundu mandi mił sim. ");
INSERT INTO nii_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pe wumb pei ok, Mariya kin Masa teł enginjngił kułum ei, ke nik ni, kaimb mułmun nik, tep to mołmun nik onjung. ");
INSERT INTO nii_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Amb Masa piim ni, Jiisas onum nengin kin, eim pupu, andłam ełe kan simbii nipi pum. Ba Mariya eim ngii konu ełe enj mułum. ");
INSERT INTO nii_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Amb Masa pupu kin, Jiisas kanpi yi nim, “Owundu, nim ok ya ełe mułułan kin, na einan ei kulełang. ");
INSERT INTO nii_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nga pe na piind ku, pe nim Gos kin epi endi simbii ni, prei enjii ei, eim kapłi nim ngumba.” ");
INSERT INTO nii_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jiisas ek nipi, ngopu yi nim, “Pe nim ainim ei nge angpi kin, konj ba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Neng kin, Masa ek nipi, Jiisas kin yi nim, “Na piind, eim Gos kunum ei poru nimba ełe angpi kin, nga konj tonu omba,” ni piipi, yi nim. ");
INSERT INTO nii_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jiisas ek nipi, eim ngopu yi nim, “Angk kin, tonu ongii oł ei nin, nga noman konj sik ełmin ei, pułe na. Pe wumb endi na kin pii gii nim kin, eim ngenj ełe kułang kin, eim noman tuk kulermba mon! Nga tonu opu, noman konj kunum kunum mułmba. ");
INSERT INTO nii_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wumb pei konj molk, na kin pii gii ningii wumb ei, am punerngii mon. En enim noman konj ei sik kin, kunum kunum mułngii ei, nim pii gii nin, min mon?” ");
INSERT INTO nii_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Masa Jiisas kanpi yi nim, “Owundu, na nim kin pii gii nind. Nim Krais, nim Gos nge kingam. Gos ok ek nipi kin, nim mei konu ełe kindmbii nirim ei, nim mendpił!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Masa eim ek yi nipi pendpi kin, eim pupu, angim Mariya kanpi nim, “Ek emb to ngopu ełim wu ei, opu mołpu kin, ‘Nim oi! ninim,’” pa nim. Nipi kin, eim angim Mariya kanpi ek endi nipi ngum. ");
INSERT INTO nii_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya ek ei piipi, sikir pupu Jiisas mułum konu ełe tor pum. ");
INSERT INTO nii_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pe Jiisas Besanii konu ełe tor onerim mon; ba Masa pupu eim kan seng kin, ek tangkił enjngił konu ełe enj mułum. ");
INSERT INTO nii_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pe Jura wumb ok Mariya kin kaimb er mulnjung wumb ei, kenjing ni, Mariya eim sikir angpi kin, anda pum. Pe aim pendnjing konu ełe ke nipi ermba punum ni piik, wumb eim pum konu ełe, ekii sik anda punjung. ");
INSERT INTO nii_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Amb Mariya opu, Jiisas mułum konu ełe tor opu, Jiisas kenim. Kanpi opu, Jiisas simb ełe mani pupu, pepi yi nim, “Owundu, nim ya mułułan kin, na einan ei kulenenełang mon!” ");
INSERT INTO nii_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yi nipi kin, eim ke nim ei, Jiisas kenim. Nga wumb eim kin onjung wumb ei, ke ninjing ku. Pe Jiisas eim kaimb sipi kin, noman ełe embin to piim. ");
INSERT INTO nii_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Piipi kin, Jiisas eim yi nim, “Enim eim sipik, konu jiłi orung pendnjing?” Wumb yi ninjing, “Owundu, nim ya okun, kenjii!” ");
INSERT INTO nii_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Pe Jiisas eim ke nim. ");
INSERT INTO nii_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Pe Jura wumb eim ke nim ei, kanik yi ninjing, “Jiisas eim wu ei noman ngołum ei, piipi kin, ke ninim,” ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ba Jura wumb kombur ek yi ninjing, “Jiisas eim wu endi ningił tumbun mułum ei, eim er ka erim. Pe wu kułum ei, Jiisas ełang kin wu ei kapłi kulełang. ");
INSERT INTO nii_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jiisas eim noman ełe embin peng piipi kin, eim tukpu to pendnjing konu ełe om. Pe Lasaras tukpu to pendnjing ei, kom ku owundu endi ełe, tunduk tuk puk. Nga ku endi sik kin, tukpu ei ondu nguk. ");
INSERT INTO nii_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pe Jiisas eim yi nim, “Enim kom ku owundu ei aki tei!” nim. Wu kułum wu ei, eim aim Masa mołpu kin, yi nim, “Owundu, wu ei kułum kunum kapił kapłi poru nim ei, eim kumun ngonum,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jiisas ek nipi, Masa ngopu yi nim, “Nim nimbił oł enim? Na ok nim kanip ninj ei, nim pii gii nin pim kin, kapłi Gos nge noman dinga owundu ei kenjii.” ");
INSERT INTO nii_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","42","Pe wumb ku ei tukpu ełe si kindnjing. Pe Jiisas eim kan epin konu ełe tonu kanpi yi nim, “Arnan, nim na prei end ei, nim piin. Kapłi na nim kin ka piip ngond. Na piind ei, kunum kunum nim na prei ełe ei piiłin. Ba pe wumb ya ełe na kin ouni mołmun wumb ei na nim kin nind. Pe wumb yi piingii ei, nim na kindan onj ni piik wumb ei, na kin pii gii ningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jiisas eim ek yi nipi kin, eim wii dinga topu yi nim, “Lasaras, nim si kindkin anda wa!” nim. ");
INSERT INTO nii_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pe wu kułii ei, angpi kin, anda om. Eim kultum kunum, kan simb angił ełe, kan to pendik mił ni, alap kumb ełe peng to pendik mił ni, kun om. Pe Jiisas ek yi nim, “Eim alap ngenj ełe pałim ei, si kindangin kin, pangłi!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pe Jura wumb kombur ok, Mariya kin ke nik mułmun wumb ei, Jiisas jep oł owundu erang kanik kin, eim kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ba wumb kombur en enim puk kin, lo ek piik ekii siłmin wumb mulnjung konu ełe puk kin, Jiisas eim oł yi erim mił ei, kanik ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yi nengin kin, kułmał kałiłmin wu ni, lo ek ei ekii sik ełmin wu ni puk kin, kaunsil kanik nik kin, kułou tunjung. Tok yi ninjing, “Wu ei, epi jep oł kanim kanim enim ei, er ermin mił nenj?” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","“Pe sinim kan wiik tamin kin, oł yi nge erpi pang kin, wumb pei eim kin pii gii ningii ei, nga Rom opu ełmin wumb ok, sinim men tołmun ngii owundu ni, sinim Jura wumb tiłap ei, to kis erngii, ei mon!” ");
INSERT INTO nii_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Wumb mulnjung konu tuk ełe, wu endi mułum wu ei, embe Kaiyapas. Wu ei, eim kułmał kałiłmin ei, eim tep mułum kunum. Pe eim ek yi nim, “Enim noman ełe epi endi to piik kin, enanmin mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“Enim yi to piinerngii mon. Wu endeim kułmba wu ei, eim wumb pei paki tumba ei ka. Mon pim kin, sinim Jura wumb tiłap pei, Rom opu ond wumb ok, sinim pei to kundngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eim noman ełe piim mił, ei piipi kin, ngunerim mon. Eim kułmał kałiłim owundu kongun tep ermba nik kin, ei kung ngii ełe ermba. Ba Gos yi erang kin, eim oł ekii se tonu omba ni piipi niłim wu yi nim. ‘Jiisas eim kołpu kin, Jura wumb pei paki tumba,’ ni yi nim. ");
INSERT INTO nii_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jiisas kołpu kin, Jura wumb mendpił paki tunermba mon. Gos nge kingam noł konu orung orung pei mołmun ei kin, pei kołpu kin, Gos nge wumb pei sipi kin, tiłap endeim mendpił kindmba. ");
INSERT INTO nii_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pe Jura noman pim wumb ei, kunum ełe ni piik kin, Jiisas eim to kundmun ni piik enjing. ");
INSERT INTO nii_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Yi mił nengin kin, Jiisas nga tuk Jura wumb kułou tok erik kin, konu peni ełe endnerim. Pe eim konu ełe si kindpi kin, am pupu, wumb mulenjing konu ełe orung mandi mił, sim konu owundu ełe mułum. Pe eim mułum konu ei embe ‘Epriyam.’ Jiisas eim kin ekii siłmin wu ombu kin puk ełe, ouni mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jura wumb kor owundu kuni ‘Pasopa’ nołmun kunum ei, mandi erim. Pe ‘Pasopa’ kunum ei, mandi erang kin, wumb konu orung eipi eipi wumb ei, Jerusalem konu owundu ełe tonu puk kin, en enim noman ełe kil ngumun ni, oł ei pii kun erik kin, Moses lo ek niłim mił, yi kun erngii nge punjung. ");
INSERT INTO nii_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pe wumb pei, Jiisas kurngii enjing. Wumb en enim men tołmun ngii nirikring ełe angk molk, yi ninjing, “Enim er piinmin mił nenj? Eim pe kuni owundu ‘Pasopa’ ei, kanpi ermba nge omba, min mon?” ");
INSERT INTO nii_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jura wumb kułmał kałiłmin wu owundu ombu ni, lo ek piiłmin wumb ni, ek ni piik enjing, “Wumb kii semin, eim jiłi mołum ei piipin kin, pe eim kan ngumun,” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kunum angił orung nga endeim mił molk, kor owundu kuni ‘Pasopa’ nungii ei, tonu omba pim. Pe kunum ełe, Jiisas eim Besanii konu ełe Lasaras nge konu ełe wu ei, Jiisas eim tukpu to pendnjing ei, Jiisas er konj nge sim wu ngii konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Besanii konu ełe wumb Jiisas nge kuni er sinjing sim. Amb Masa eim kuni onguł erim. Nga Lasaras eim Jiisas kin kuni nunjung wumb ei kin, ouni mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Pe amb Mariya eim ku owundu top erpi sim kopung ka ming owundu mił endi ei, tu wupu kin, Jiisas nge simb ełe kopung bein topu kin, nga Mariya eim nge peng enjin ei sipi kin, eim simb ełe kil ngum. Pe kopung muru ka wii tołum ei tuk ngii ełe pei muru ka tołum. ");
INSERT INTO nii_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Ba Jiisas eim kin ekii siłim wu ei, embe Juras Eskerias konu ełe wu ei, ekii se Jiisas opu orung wumb onjung konu ełe nipi ngum wu ei, ek yi nim. “Sinim kopung ka wii tołum ei sikin, wumb eipi ngopun, ku 300 pei mił sipin kin, wumb wii mulnjung wumb ei ku ngopun. Nimbił erang sinim enenjpin?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ba Juras eim ek yi nim ek ei, wumb wii mołmun wumb ei kin ek keimi ninerim mon. Eim waning ermba nge piipi, yi nim. Eim ku kon ei, eim tep mundang mołpu kin, ku waning nołum. ");
INSERT INTO nii_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jiisas eim yi nim, “Nim amb kun eran pangłi! Ekii se, na tukpu ełe pendngii kunum ei, eim yi ermba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","“Wumb epi sinałim wumb ei, enim kin kunum kunum mołmun. Ba na enim kin, kunum kunum mulał, mon!” ");
INSERT INTO nii_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jura wumb pei, Jiisas Besanii konu ełe mołum ni piik kin, eim mułum konu ełe onjung. Ok kin, Jiisas mendpił keningii nge onenjing mon. Ok Jiisas eim Lasaras kułum ei, eim er konj sim ei, Lasaras kenmin nik kin, onjung. ");
INSERT INTO nii_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kułmał kalk ełmin wumb owundu ei, Lasaras to kundmun ku, ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nimbił erang, Jura wumb pei Lasaras piik kin, kułmał kalk lo ek piik ełmin wumb ei kin, si kindik kin, wumb ei Jiisas kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kunum endi nga, wumb tiłap owundu ei ok, ‘Pasopa,’ kunum kor owundu kunum ei ok piinjing ei, Jiisas Jerusalem konu ełe omba ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yi piik kin, wumb ei puk kin, ond onguł ni epi sik, andłam ełe kui er mulnjung. Molk kin, wumb ei, wii tok yi ninjing: “Pe Gos sin paki tumba! Sinim Owundu Gos eim kindang onum. Eim embe ambił tonu kindmin. Eim sin Esrel wumb nge King!” ");
INSERT INTO nii_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","15","Pe Jiisas kung dongkii wał endi, kan sipi, tonu ełe mołpu kin, om. Ei Gos nge ek ka ok pułum ełe yi mił nim. “Saiyon konu owundu ełe, wumb mund mong enerei! Pe nga enim nge king ei onum kin, eim kinei! Eim kung dongkii wał peł ełe mołpu, onum.” ");
INSERT INTO nii_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ok Jiisas kin ekii siłmin wu ombu, Jiisas eim epi oł erim ei, pii poł tunenjing. Ba ekii se Jiisas epin tonu ełe pum, eim tiłang owundu ei seng kanik kin, en enim piinjing ni, Gos nge ek kumb ok pulk ełe pim ei, kun erang piinjing. Nga wumb eim kin enjing oł ei piinjing ku. ");
INSERT INTO nii_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ok Lasaras kułang paki to pendik kunum ei, wumb pei Jiisas kin molk, Jiisas eim Lasaras tukpu ełe wii tang kin, Lasaras angpi opu kin, konj nga multum ełe wumb pei, jep oł erang kanik wumb ei, Jiisas eim oł yi eririm pa nik, ek yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Wumb pei ei jep oł erpi eririm ei piik enjing wumb ei, puk kin, andłam ełe, kuruk punjung. ");
INSERT INTO nii_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pe lo ek piik nik ełmin wumb ei, en enim ek nik, piik piik erik kin, yi ninjing. “Pe enim enjing oł ei kapłi enanim. Wumb pei en enim eim kin ekii sik punmun.” ");
INSERT INTO nii_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Wumb pei, Jerusalem konu ełe tonu puk ei, en enim kor owundu kuni ‘Pasopa’ ełe puk kin, Gos kin men tok ermin ni punjung. Nga Griik wumb kombur ełe ouni punjung ku. ");
INSERT INTO nii_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wumb Griik wumb ei, Pilip kin onjung. Pilip eim Galilii konu ełe orung Beseira konu kembis ełe wu. Pe wumb eim kii sik, yi ninjing, “Wu puł, sin Jiisas kenmin ni piinmin,” ninjing. ");
INSERT INTO nii_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pe Pilip pupu kin, Endru kanpi ek ei neng kin, pukuł Jiisas kankił yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Pe Jiisas eim ek nipi, yi nim, “Gos na kindang mani mei wu tełim ei onj. Pe na tiłang owundu simbii kunum ełe, mandi enim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","“Na ek keimi mendpił nip enim ngond. Pe Gos kingam Krais ei, eim mani mei ełe kindim. Pe Gos nge kingam kindang, eim mani mei ełe opu kulełang kin, eim mendpił mułułang. Ba Gos kingam mani mei konu ełe opu kułmba ei, eim wumb eim kin pii gii ninjing wumb pei, eim sipi orung simba. Ei yi mił ku, kuni mong eim endi mei ełe mani kulenenłang kin, eim mendpił mułang; ba kuni emb endi mei ełe mani kułang kin, kapłi ei kuni mong pei simba. ");
INSERT INTO nii_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Wu endi ngenj ełe bun bun kułpu ermba wu ei, eim nge noman opu konj pimba ei, am ba. Ba wu endi, eim ngenj ei mendpił piinarpi kin, Gos nge ek ekii sipi, eim kongun er mułmba wu ei, eim noman konj sipi kin, kunum kunum konj mułmba ei, eim am punermba mon! ");
INSERT INTO nii_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Pe wu nii endi, na nge kongun ei erim kin, eim na kin ekii simba wu ei, na mułmbii konu ełe, na nge kongun wu ei, eim na kin ouni mułmbuł. Pe wu endi, eim na kongun ei ermba wu ei, na nge Arnan eim embe ambił tonu kindmba.” ");
INSERT INTO nii_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Pe nam noman tuk ełe ei, embin tonum. Pe na nip kin, ek nipe ek nimbii? Pe nam Arnan kin yi nimbii, ‘Arnan, nim epi embin tui na kin tonu omba enim ei, nim se! Na ek yi mił ninermbii min? Nimbił erang, oł embin tui ei, na kin tonu omba nge nip kin, akip onj. ");
INSERT INTO nii_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nam Arnan ni nim nge embe ei, tonu opu owundu pimba.” Jiisas eim ek yi neng kin, pe Gos ek endi tonu epin konu ełe tor opu, yi mił nim, “Na nam embe ei, wumb ambilk tonu kindnjing. Pe nga am opu owundu ba enim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Wumb Jiisas kin mandi angk mulnjung wumb ei, ek piik kin, yi ninjing. “Gur gaki endi enim,” ninjing. Nga wumb kombur yi ninjing, “Mon, enjel endi opu, eim kin ek tangnim,” ninjing. ");
INSERT INTO nii_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jiisas eim ek nipi, wumb ngopu yi nim, “Gos ek ei na kin mendpił ninanim mon! Ek ei, enim kin paki tungii nge piingii, ninim,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","“Pe kunum mandi enim ei, Gos ya mei ełe mołmun wumb ei, mok tumba. Pe Seisen mei konu ełe mołmun wumb ei, tep mołum wu kis topu kindmba. ");
INSERT INTO nii_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Pe na mei ełe moł, ekii se wumb na ond peri ełe to kundngii kunum ei, na wumb pei sip kin, na nam kin orung simbii,” nim. ");
INSERT INTO nii_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","34","Jiisas eim ek yi nim ei, eim kułmba nge ei, piingii ni yi nim. Wumb ek orung kindik kin, yi ninjing, “Sin lo ełe piinmin ei, lo ek yi ninim, ‘Krais Gos kindang wu, mei ełe mani opu, eim kunum kunum konj mułmba,’ ninim. Nimbił erang, nim ek yi nin, wumb wu kingam ei ond peri ełe to kundngii nin? Wu kingam ei nii?” a nim. ");
INSERT INTO nii_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jiisas ek nipi, wumb ngopu yi nim, “Pe kunum aninga kopur, mei wumb nge tiłang ei, na enim kin ouni mułmbii. Pe enim tiłang ełe, oł kun andik er mułngii. Mon pim kin, Seisen nge emii dinga ei, enim sipi orung simba. Wu endi eim emii peng ba ei, eim konu jiłi orung ba ei, eim piinermba mon! ");
INSERT INTO nii_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pe enim tiłang peng mołmun ełe tiłang ei, na kin pii gii ningii. Enim na kin pii gii ninjing kin, enim tiłang ei nge, kingam ambiłam noł mił mułngii. Nga enim tiłang ei, andik kin, oł kun erngii ku!” pa nim. Jiisas eim ek ei nipi, poru nipi kin, eim wumb mulnjung konu ełe, tuk am pup kin, koi erim. ");
INSERT INTO nii_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jura wumb Jiisas eim jep oł pei erim ei, kanik kin; ba enim Jiisas kin pii gii ninenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pe ok ek ni tor kindiłim wu Aisaiya nirim ek ei, pe keimi tonu pim. Ok wu ei, Aisaiya eim ek yi mił nirim: “Owundu wumb nii endi, sin ek ei ni tor kindinjpin ei, pii gii ninenjing mon. Pe Owundu eim nge noman dinga ei, wumb pei kin andan tang kin; ba wumb ei, pii poł tunenjing.” ");
INSERT INTO nii_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Wumb Jiisas kin pii gii ninenjing. Nimbił erang ek ni tor kindiłim wu ei, Aisaiya ek endi nga nirim mił ei, keimi pirim. Eim ek yi mił nirim. ");
INSERT INTO nii_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gos eim, en enim ningił ambił ak tang kin, en enim ningił ełe, kapłi kun kinerngii mon! Nga noman erang kin, kom ku mił peng kin, en enim noman ełe, pii kun enerngii mon! Pe nga en enim, nanim kin wangin kin nanim paki top kin, oł yi ermbii ni piik, enanmin!” pa ni Gos Owundu yi nim. ");
INSERT INTO nii_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ek ni tor kindiłim wu ei, Aisaiya eim Krais Gos kindang mei konu ełe mani wu nge tiłang owundu ei, kanpi kin Krais nge ek ka mendpił nirim. ");
INSERT INTO nii_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pe Jura wumb num kombur, Jiisas kin pii gii nik kin; ba en enim lo ek piik nik ełmin wumb ei kin, mund mong erik kin, ek nik tor kindnenjing. Nimbił erang, lo ek piiłmin wumb ei, sin men tołmun ngii ełe, to anda kindngii, ni piik. ");
INSERT INTO nii_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Gos en enim embe ei, ambił tonu kindmba ni piinarik, mon! Wumb en enim nge embe ei, ambił tonu kindngii, ni piik enjing. ");
INSERT INTO nii_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jiisas eim wii dinga topu kin, yi nim, “Wumb nii endi, na kin pii gii nimba ei, na kin mendpił mon! Ba Gos na kindang onj kin, ouni pii gii nimba ku. ");
INSERT INTO nii_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wumb endi, na kenmba ei mił ku, na Arnan na kindang onj ei, kenmba ku. ");
INSERT INTO nii_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Na nam ya mei wumb ełe, tiłang nge onj. Wumb nii endi na kin pii gii nimba wumb ei eim wumb nii endi, noman tuk emii oł kis ełe, min oł ei mił mulermba wu ei, na tiłang ełe ekii simba. ");
INSERT INTO nii_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pe wumb endi, na ek ei piipi, ekii sinerim kin, na eim ek kos mił piip, yi enermbii. Na mani mei ełe op, wu amb ek piip, kun erip kin, kos piip, ermbii nge onenj mon? Na wu amb pei, Gos kin orung simbii nge onj. ");
INSERT INTO nii_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pe wumb endi, na nge ek ei ekii sinarpi buł ngopu erim kin, eim kin kos piipi, ermba wu endi mołum. Pe na ek nip, tor kindind ek ei, pii gii ninenjing kin, ekii se Gos kunum poru nimba kunum ei, eim kos owundu piimba. ");
INSERT INTO nii_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na nam noman ełe piip kin, ninand mon. Na Arnan eim na kindpi kin, eim ek ei nipi, na ngopu kin, yi mił nim na nind. ");
INSERT INTO nii_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pe na piind ei, na nge Arnan ek ei, kunum kunum konj ngumba nge nip kin, tonu kindiłim ei yi mił pałim. Na ek pei ni tor kindind ei, na nge Arnan na kanpi nim ek ei, na nip tor kindind,” Jiisas pa nim. ");
INSERT INTO nii_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasopa kuni nołmun kor owundu ei, tonu omba mandi erang kin, Jiisas eim piim. Eim mei ełe si kindpi kin, Arim kin orung ba nge ni piim. Piipi kin, eim nge wumb mei ełe mani mułngii ei kin, noman ngołum. Nga eim mei ełe wumb pei noman ngopu pupu kin, kułmba kunum ei, poru nim. ");
INSERT INTO nii_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pe kunum poru neng kin, Jiisas kin ekii siłmin wu ombu kin, kuni nok mułangin kin, Seisen opu, Jura Eskerias konu ełe Saimon nge kingam eim noman tuk ełe pum. Pang kin, Juras eim Jiisas sipi kin, opu orung wumb ongii konu ełe nipi, tor kindmba nge piim. ");
INSERT INTO nii_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jiisas eim piipi, poru nim kin, eim Arim epi pei kin, noman dinga eim ngopu, poru nim. (Nga Juras Eskerias Saimon nge kingam ermba oł ei piim ku.) Gos eim kindang om kin, nga eim Arim Gos kin, orung ba, ku. ");
INSERT INTO nii_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pe Jiisas eim kuni peł ei, si kindpi kin, eim angpi, kon takis ei, guł topu sepi kin, kon alap endi sipi, eim kend ełe tałpi kin, eim kongun wu mił erim. ");
INSERT INTO nii_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Eim yi erpi kin, noł sipi, ming endi sim ełe noł bein to kindim. Pe noł ming ni sipi, eim nge ekii siłmin wu ombu simb ełe, was erpi kin, kon alap kend ełe tałpi pendim ni sipi kin, eim simb ełe kil ngopu, yi erim. ");
INSERT INTO nii_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Eim simb was erpi opu kin, Saimon Piisa mułum konu ełe tor wang kin, Piisa eim ek yi nim, “Owundu, nim na simb ełe was enjii on?” a nim. ");
INSERT INTO nii_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Pe Jiisas eim ek nipi, orung kindpi yi nim, “Na pe oł ei, ermbii end oł ei, nim pe pii poł tunenjii. Ba ekii se, oł ei pułe, nim pii kun enjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piisa ek dinga yi nim, “Nim na simb was enenjii mon!” Pe Jiisas ek nipi, orung kindpi yi nim, “Pe na nim simb ei was enenj kin, nim na kin ouni mulenjii mon!” ");
INSERT INTO nii_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nga Saimon Piisa yi nim, “Owundu, nim na simb ełe mendpił was enerii! Ba na peng ełe ni, angił ełe, pei was erii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nga Jiisas eim ek yi nim, “Wumb ngenj ełe, noł was ok pei enjing ei, nga was enerngii mon! Ba simb ełe mendpił, noł was erngii nge sałim ei, erngii. Pe enim noman tuk ełe ka seng kin, mołmun. Ba enim wumb pei mon! Wu endi, Juras Eskerias wu ei, eim noman tuk ełe oł kis sałim. ");
INSERT INTO nii_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jiisas ek ei piipi, poru nim wu ei, eim opu orung wumb nipi, tor kindmba wu yi nim, “Enim wumb pei noman tuk ełe ka mulałmin,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pe Jiisas eim kin ekii siłmin wu ombu simb was er poru nipi kin, eim kon takis ei, nga kindpi kin, eim peł konu ełe orung mułum. Mołpu kin, ek yi nim, “Na enim kin oł enj ei enim piinmin, min? ");
INSERT INTO nii_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Enim na ek emb to ngokun ełin wu owundu niłmin. Nik kin, enim ek kun yi niłmin. Na yi mił moł. ");
INSERT INTO nii_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na ek emb top wumb ngop, wu Owundu mołup kin, na enim simb ei was enj. Nga enim yi ku, enim engnjing noł kin, oł yi mił erei!” nim. ");
INSERT INTO nii_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na oł ei pe erip kin, enim andan top enj oł ei, nga enim enginjing noł kin yi ku erngii. ");
INSERT INTO nii_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Na ek keimi mendpił enim kanip nind, ‘Kongun wu ei, eim nge wu Owundu ei kapłi to mani kindnałim. Nga wu endi kongun ermba pum wu ei, eim kindang pum wu ei, to mani kindpi kin, eim wu Owundu mił mulermba mon. ");
INSERT INTO nii_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pe enim oł ei nge pułe piik kin, enim yi mił enjing kin, enim noman ka piingii. ");
INSERT INTO nii_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Na nam sip mundunj kin, enim wumb ombu kin nind ei, enim pei mon. Ba pe epi ełe nge wumb ok pułmun Gos nge ek nirim ei, keimi pałim. Gos nge ek yi mił nirim: ‘Wu endi, na kin ende mołpuł kuni nunjpuł wu ei, na nge opu orung wu, tonu opu mołum.’ ");
INSERT INTO nii_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Oł ei tonu onerang kin, na pe ek ei nip, enim ngond. Pe ekii se wu ei, oł yi erang kin, enim kanik kin, na Krais Gos kindang mei wu onj kin, pii gii ningii.” ");
INSERT INTO nii_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jiisas eim yi nim, “Na ek keimi mendpił nip enim ngond. Na nge kongun wu kindamb pangin kin, wumb endi sipi tuk simba wu ei, eim na kin ouni simba. Nga wu endi na sim kin, na Arnan na kindang onj ei, ouni simba ku.” ");
INSERT INTO nii_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jiisas eim ek yi mił neng kin, eim noman tuk ełe embin tang kin, piipi yi nim, “Na ek keimi mendpił nip enim ngond. Enim mołmun konu tuk ełe wu endi mołum wu ei na opu orung wumb ongii konu ełe nipi, tor kindmba.” ");
INSERT INTO nii_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Eim ek yi mił neng kin, eim kin ekii siłmin wumb ombu, en enim kumb kin erik kanik, “Wu nii endi ninim,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wu endi Jiisas kin ekii siłim wu ei, Jiisas eim noman ngołum wu ei, Jiisas mułum konu ełe mandi wii mułum wu ei, embe Jon. ");
INSERT INTO nii_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pe Saimon Piisa, Jon kanpi, peng ku tonu nim eim mandi mołum ei, eim kii se, Jiisas wu nii endi nimba ei, piimin ni piim. ");
INSERT INTO nii_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pe Jon eim Jiisas mułum konu ełe mandi pupu, Jiisas nge kom sipi mołpu kin, yi mił nim, “Owundu, nim nii kin nin?” ");
INSERT INTO nii_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jiisas eim ek nipi, orung kindpi kin, yi nim, “Pe na kuni bres sup kin kindip orung sip kin, eim ngamb numba ei, wu ei mendpił. Pe Jiisas eim kuni bres sup kin kindpi kin, orung sipipi, Juras Eskerias, Saimon nge kingam ei ngum. ");
INSERT INTO nii_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","30","Pe Juras kuni ei sipi nang kin, Seisen Juras noman tuk ełe tuk pum. Pe Jiisas eim ek yi nim, “Nim epi endi enjii pin kin, sikir enjii,” nim. Pe Juras kuni orung ei, sipi nopu kin, sikir anda pupu pum. Pe konu emii pim ei, poru nim. Jiisas eim ek ni piim; ba ei tonu peł ełe kuni ende nok mulnjung wu ombu, ek ei pułe pii poł tunenjing. Wu kombur en enim yi piinjing. Juras ku tep ełim wu ei kin, ninim ni piinjing. Juras eim epi top ermba ni konu kor owundu kunum top erpi, min wumb epi sinerang, wii mulnjung wumb ei ngopu, yi erang kin, Jiisas piipi ninim ni, yi piinjing. ");
INSERT INTO nii_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Juras anda pupu pang kin, Jiisas eim ek yi nim, “Pe Gos kindang opu wu kingam tełim, tiłang owundu seng kin, nga Gos wu kingam ei kin, tiłang owundu simba. ");
INSERT INTO nii_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pe na Gos nge tiłang owundu ei, na andan top ninj kin, Gos kindang mei wu tełim ei, na nge tiłang owundu andan yi ku tumba. Gos eim andan topu, sikir ermba. ");
INSERT INTO nii_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Enim na kangił mił, na enim kanip nind. Kunum endi ekii se aninga, enim na kurngii. Pe kunum aninga, na nam enim kin ouni moł. Pe ek ei Jura wumb kan yi ku ninj ek ei, enim kanip nind ku. ‘Na bii end konu ei, enim punerngii.’ ");
INSERT INTO nii_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Na enim lo ek konj endi nip, enim ngond endi ei, yi mił. Enim engnjing noł noman ngungii ei, na enim noman ngoł mił, yi ngungii. ");
INSERT INTO nii_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Pe enim engnjing noł endeim endeim ni, noman ngunjung kin, wumb pei yi piingii ei, enim na kin ekii sik endnjing wumb, ni piingii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Piisa ek kii sipi, yi nim, “Owundu, nim konu jiłi punjii nin?” Nga Jiisas ek nipi, orung kindpi yi nim, “Pe na bii end konu ei, nim na kin ekii sikin punenjii. Ba ekii se, nim na kin ekii sinjii,” nim. ");
INSERT INTO nii_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piisa nga ek nipi yi nim, “Owundu, nimbił erang pe, na nim kin ekii sip onermbii? Na pe kołup kin, nim paki tumbii,” Piisa yi nim. ");
INSERT INTO nii_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Nga Jiisas ek kii sipi, Piisa ngopu yi nim, “Pe nim kolkun, na paki tumbii nin min? Na ek keimi mendpił nip, nim ngond; kei kultu pełi wii tunermba kunum ei, nim na nge embe ei, kunum tekliki ni tor kindnenjii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Enim noman embin tonum, yi enerei mon! Enim Gos kin pii gii ninjing kin, na kin pii gii ningii ku,” Jiisas pa nim. ");
INSERT INTO nii_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","“Na nge Arnan mołum konu ełe, konu pei sałim. Pe yi sinełang kin, na enim ok kanip niłamb. Na nge Arnan ngii ei pup kin, enim nge konu ełe, er kun ermbii ni pund. ");
INSERT INTO nii_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na pup konu ełe er ka er sep kin, nga orung op, enim kin ouni bin. Ei yi mił, na mułmbii konu ełe, enim na kin ouni mułngii ku.” ");
INSERT INTO nii_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jiisas eim yi nim, “Na bii end konu ełe andłam ei enim piinmin min?” ");
INSERT INTO nii_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Pe Tomas ek nipi yi nim, “Owundu nim konu jiłi punjii nin? Sin piinanmin. Pe nim punjii andłam ei, sin er piimin mił nenj?” ");
INSERT INTO nii_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jiisas ek nipi ngopu, yi nim, “Na nam Arnan mołum konu ełe, andłam ei nge moł. Nga na nam ek keimi ei nge puł wu. Nga na nam noman konj kunum kunum ei nge puł wu moł, ku! Wumb endi na Arnan mołum konu ełe andłam eipi endi punermba, mon, andłam ei, na mendpił. ");
INSERT INTO nii_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Pe enim na piik mulnjung kin, na nge Arnan ei, enim piingii ku. Pe enim eim piik kanik enmin mił, nga yi kun kanik piik erngii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nga Pilip ek yi nim, “Owundu, nim Arnim ei, andan tan, sin kapłi piimin,” a nim. ");
INSERT INTO nii_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Nga Jiisas ek nipi, Pilip ngopu yi nim, “Na enim kin kunum kinan muls. Pe Pilip nim na pii poł tunen, min? Wumb endi na piim wumb ei, na nge Arnan piim ku. Nimbił erang nim yi nin, ‘Nim Arnim, sin andan tan kenmin, nin?’ ");
INSERT INTO nii_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Pe nim Pilip, na kin pii gii ninen, min? Na Arnan kin moł; nga na Arnan ei nam kin mołum. Na ek nip, enim ngond ei, na nam nge noman ełe nip ngunand mon. Na Arnan eim na kin eim nge kongun ei end. ");
INSERT INTO nii_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Enim na kin pii gii ningii. Na nam Arnan kin moł. Nga Arnan eim na kin mołum. Pe enim ei piik, pii gii ninenjing kin, nga na kongun ni, jep oł pei erip punj ei, enim piingii. Piik kin, na kin pii gii ningii. ");
INSERT INTO nii_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na ek keimi mendpił nip enim ngond, wumb endi na kin pii gii nim kin, eim na kongun ełe mił, yi ermba ku. Nga kongun owundu ermba ei, na enj kongun ei am tonu kindmba. Nimbił erang, na Arnan mołum konu ełe bii pund. ");
INSERT INTO nii_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Epi endi simin nik kin, na nge embe ełe prei enjing kin, enim kapłi singii. Yi erangin kin, na Arnan eim nge kingam na kin embe ambił tonu kindmba. ");
INSERT INTO nii_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Enim na nge embe ełe oł endi ermbii nik, Gos kin kii sik, prei enjing kin, na kapłi ermbii.” ");
INSERT INTO nii_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Enim na kin noman ngunjung kin, na lo ek ei piik, ekii singii ku. ");
INSERT INTO nii_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nga na Arnan kin kii simbii Gos eim nge Gui Ka kindang, enim paki tumba wu ei, ek keimi puł wu. Ei enim kin kunum kunum mułmba. ");
INSERT INTO nii_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ei Gos ek ka ei, ek keimi mendpił nimba. Mani mei wumb pei eim singii ei, kapłi enanim. Nimbił erang, eim kanik kin, pii poł tunanmin. Nga eim kongun ełim mił, ei piinanmin ku. Ba enim ei piinmin. Nimbił erang, ei eim enim noman tuk ełe mołum kin, nga mułmba ku. ");
INSERT INTO nii_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Na enim kin si kindip pamb kin, enim kangił ernjing, menjing mulerang mołmun mił, yi mulerngii mon. Na enim kin orung ombii. ");
INSERT INTO nii_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mani mei ełe pii gii ninenjing wumb ei, na kunum aninga kinerngii mon, ba enim na keningii. Na noman konj sip, kunum kunum mułamb kin, ei nga enim yi ku, noman konj kunum kunum mułngii. ");
INSERT INTO nii_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kunum ełe, enim piingii ei, na Arnan kin mułamb kin, yi mił ku, enim na kin mułangin kin, nga na enim kin, yi ku moł. ");
INSERT INTO nii_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Wumb nii endi, na nge lo ek ei sipi, ekii simba wumb ei, na kin noman ngonum. Ngang kin, na nge Arnan eim noman wumb ei kin ngang kin, nga na wumb ei kin, noman ngumbii ku. Nga na eim mułmba konu ełe tor wamb kin, na nam eim kin andan tumbii ku.” ");
INSERT INTO nii_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jiisas eim ek yi mił neng kin, wu Juras endi, eim Eskerias Saimon nge kingam mon. Wu eim ek nipi, Jiisas ngopu yi nim, “Owundu, nimbił erang nim sin kin, ni ninim andan tunjii nin, ba ya mani mei ełe pii gii ninenjing wumb ei kin, nim andan tunenjii nge nin, min?” ");
INSERT INTO nii_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jiisas ek nipi, orung kindpi yi nim, “Pe wumb endi na noman ngołum ei, eim na nge ek ekii simba wu ei, na nge Arnan wumb ei, kin noman ngumba ku. Nga sił Arnan kin, na ouni o puł, wumb ei kin mułmbuł. ");
INSERT INTO nii_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Wumb endi na kin noman ngunałim ei, eim na nge ek ei ekii sinałim ku. Pe enim piinmin ek ei, na nam nge ek mon. Na Arnan nge ek ei, eim na ngopu kindang kin, na onj. ");
INSERT INTO nii_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Pe na enim kin ouni mołpun kin, na ek ombu enim kanip nind. ");
INSERT INTO nii_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ba enim paki mendpił tołum ei, Gos Gui Ka enim paki tumba. Na nge noman dinga ełe, na Arnan ei kindmba. Gos Gui Ka enim kin epi pei andan tumba. Tang kin, enim nge noman ełe pirek neng kin piingii ei, na enim ok nip ngur ek ei, pei enim noman ełe piingii. ");
INSERT INTO nii_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Na enim si kindip, bii peng kin, na enim noman emin ngond. Nam nge noman emin kanim eipi enim ngond ei, mani mei ełe pii gii ninenjing wumb ei, en enim noman emin ngok enmin oł ei nge, na enim ngunand mon. Enim noman embin tum kin, mund mong yi enerngii mon! ");
INSERT INTO nii_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Na enim kanip kin nip ngunj ek ei, pii poru ninmin, ‘Na pe enim si kindip kin, na Arnan kin bii end. Ba na nga enim kin orung ombii.’ Pe enim ok na kin noman ngunjung kin, na nge Arnan kin bii nge, enim ka piingii. Ei nimbił erang, na Arnan kin bii kunum ei, Gos Gui Ka kindamb kin, enim kin mołpu kin, dinga ngumba. Nga na Arnan eim Owundu mołang kin, na mani moł. ");
INSERT INTO nii_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nga pe oł ei, tonu onerang kin, na ek ei, ok nip enim ngond. Pe ekii se, yi mił tonu om kin, enim na kin pii gii ningii. ");
INSERT INTO nii_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Pe na enim kin ek pei nip, enim ngumbii pinałim. Nimbił erang, mani mei ełe pii gii ninenjing wumb ei, Seisen noman tuk ełe mułang kin, ei ongii mandi onum. Pe eim oł endi na kin ermba ei, kapłi enanim. ");
INSERT INTO nii_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ba mani mei ełe wumb pei, epi endi piingii ei, na Arnan kin noman ngop ei nge, na Arnan ek nirim mił ei, na ekii sił.” “Pe enim engngei! Sinim pamin!” Jiisas pa nim. ");
INSERT INTO nii_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jiisas eim ekii siłmin wumb ek nipi ngum, “Nam na ond wain mendpił mił moł. Na nge Arnan ei, ond wain pin nge tep ełim wu mił mołum. Nga wumb ei na kin pii gii ninjing wumb ei, na nge ond angił mił mołmun. ");
INSERT INTO nii_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na nge angił ełe ond mong tunałim ei, na Arnan top tor kindiłim. Ei yi mił, wumb nga oł kun ka enarik wumb ei, na kin pii gii ninenjing wumb ei, na Arnan wumb ei, top tor kindmba. Ond angił kombur mong tołum ei, na Arnan eim kołmung topu, er ka erpi erang kin, nga mong pei ka tumba. Ei yi mił, wumb oł kun ka kombur oł ei ełmin; ba oł kun pinałim mił oł ei, top si kindmba. Yi erang kin, wumb ei, oł kun ka mendpił nga erngii. ");
INSERT INTO nii_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Na nge ek nip, enim ngond ei erang kin, enim noman tuk ełe, kun ka wii mułngii. ");
INSERT INTO nii_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Enim na kin ouni mułangin kin, na enim kin mułmbii. Pe ond angił ei pupu, ond mam ełe kin pinerim kin, ei ond mong tunermba. Yi mił ku enim na kin mulenjing kin, enim yi ku, oł kun ka wii enerngii mon! ");
INSERT INTO nii_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na ond wain mendpił mił moł. Nga enim ond wain ei angił mił mołmun. Wumb endi eim na kin mułang kin, na eim kin mułmbii ei, eim oł kun ka wii pei ermba. Pe enim na wak tunjung kin, enim oł kun ka wii endi enerngii, mon! ");
INSERT INTO nii_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pe wumb endi na kin mulerim kin, ei yi mił, ond wain angił kułii erang kin, to tor kindinmin mił, yi erngii. Erik kin, ond angił ei, kułou tok kin, dup kałiłmin. ");
INSERT INTO nii_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pe enim na kin mułangin kin, na nge ek ei enim noman tuk ełe pim kin, enim noman ełe Gos kin prei erngii ei, enim kin oł yi mił ku, tonu omba. ");
INSERT INTO nii_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Pe enim oł kun ka wii enjing kin, na Arnan oł ełe nge, eim embe ambił tonu ba. Seng kin, enim na nge kongun wumb mendpił erik mułngii. ");
INSERT INTO nii_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na Arnan na noman ngołum mił, yi ku, na enim kin noman ngoł. Enim na kin mulnjung kin, na noman ełe, enim kin kunum kunum er ngumbii. ");
INSERT INTO nii_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Pe enim na nge lo ek dinga ei ekii sinjing kin, enim na nge noman kunum kunum er ngumbii. Ei mił ku, na nam Arnan nge lo ek dinga ei, kun ekii sił. Sip kin, eim nge noman kaimb ngopu ełe ei, na moł. ");
INSERT INTO nii_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Na nam ek ei, enim kin ngond ei nge, noman ka ei enim kin peng kin, enim noman ka piik mułngii. Ei enim noman tuk ełe piki to peng kin, kunum kunum ka piingii. Yi ni piip kin, na ek ei enim kin ngond. ");
INSERT INTO nii_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na nge lo ek dinga ei yi mił pałim. Enim engnjing noł mołmun ei, noman ełe ngungii ei, na enim noman ngoł mił ngungii. ");
INSERT INTO nii_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Pe wumb endi eim nge wu puł pei ni, wumb endi paki tumbii ni, erpi kułmba ei, noman ngok, ngok enmin oł ei, to mani kindmba. ");
INSERT INTO nii_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Pe enim na ek dinga nind ek ei ekii sinjing kin, enim nam nge wumb puł mendpił mułngii. ");
INSERT INTO nii_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Kongun wu ei eim nge wu owundu ermba oł ei piinałim. Pe yi ku, na enim kongun wu ninermbii mon. Nimbił erang, na Arnan nge ek nipi ngurum ek ei, na enim kin nip poru ninj. Ei nge, na piip kin, enim nge wu puł mendpił nind. ");
INSERT INTO nii_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","En enim na sik, mundnenjing mon! Ba na enim sip, poru nip kin, mundunj. Mondup kin, enim kongun ełe kindinj ei, enim Gos kongun erangin kin, oł kun ka wii tonu omba nge nip kindinj. Pe enim nge kongun kun ka wii tonu wang kin, kunum kunum yi erik mułngii. Mułangin kin, enim na nge noman dinga ełe, Gos kin prei erik na Arnan ngok epi endi simin ningii ei, enim kapłi ngumba. ");
INSERT INTO nii_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Na enim ek dinga yi mił nip ngond. Enim engnjing noł, endeim endeim ni, ei noman ngungii.” ");
INSERT INTO nii_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ya mei ełe pii gii ninenjing wumb, enim kin opu orung enjing kin, enim piingii ei, na kin kumb se, opu orung erik, ei piingii. ");
INSERT INTO nii_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nga enim pii gii ninenjing mei ełe wu mendpił piłang kin, wumb ei, enim si tuk, noman ngok siłangin. Ba enim ya mei ełe nge wumb mon. Na enim pii gii ninenjing wumb ei si tor kindip kin, enim nam nge sip mundunj. Ełe nge, mei ełe pii gii ninenjing wumb ei, enim kin opu orung erngii. ");
INSERT INTO nii_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Na enim kanip nind ek ei piik mułngii, ‘Kongun wu ei eim nge wu owundu ei, to mani kindnermba mon! Pii gii ninenjing wumb ei, na muls konu ełe ok, na kin oł embin tui ngunjing ei, oł ei mił, enim mułngii konu ełe, yi erngii ku. Na nge ek ekii sinjing pim kin, enim nge ek ei, ekii singii ku. ");
INSERT INTO nii_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ba wumb ei, na Arnan mołpu kin, na kindang onj ei, piinenjing wumb ei, enim kin oł pei yi erngii. Nimbił erang, enim na nge ekii siłmin wumb mołmun. ");
INSERT INTO nii_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Pe keimi onarip kin, na ek wumb ei ngunenj pim kin, wumb en enim oł kis enjing ei, singambił piinerngii. Ba pe, wumb en enim oł kis ei koi erngii konu ełe endi sinałim mon. ");
INSERT INTO nii_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Wumb endi, na kin opu orung ermba ei, eim nge Arnan ei kin, opu orung ermba ku. ");
INSERT INTO nii_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Kongun ełe kanim kanim ok, wumb endi enerik oł ei nge, na enim konu tuk ełe enj. Pe keimi, na jep oł ei enenj pim kin, wumb en enim oł kis ei pim kin, ei piinerngii. Ba pe oł ei kanik poru nik, na nge Arnan kin ouni, opu orung enmin. Nimbił erang, enim na kin pii gii ninenjing. ");
INSERT INTO nii_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ba en enim enmin oł ei, en enim lo ek endi, lo mon ełe poł pendnjing ek ei, pei keimi tor onum. Ek ei yi mił ninim, ‘Wumb en enim na kin opu orung wii enmin.’ ");
INSERT INTO nii_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Ba paki tołum nge wu endi, enim kin erang, dinga mułngii ei, eim na Arnan kin mołum ei, na kindamb, enim kin omba. Omba wu ei Gos nge Gui Ka ei ek keimi mendpił niłim. Gos Gui Ka pim kin, na Arnan kin mołpu kin, omba. Gui Ka ei opu, na nge ek ei nip tor kindmba. ");
INSERT INTO nii_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Nga enim na nge ek ni tor kindngii ku. Nimbił erang, ok enim na kin mułangin kin, na kongun ei pułngun mondup kin enj. Nga ok molk kin, pe mołum,” Jiisas pa nim. ");
INSERT INTO nii_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jiisas nga ek yi nim, “Na enim pii gii ei, si kindik, enerngii ni piip kin, ek ei nip enim ngond. ");
INSERT INTO nii_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Enim Jura men tołmun ngii ełe wumb enim to anda kindngii. Nga ekii se, enim Gos nge kongun paki tok ermin ni piik kin, wumb ei, ok enim to kundngii. ");
INSERT INTO nii_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wumb en enim na nge Arnan ei piinarik kin, nga na piinarik kin, oł yi mił erngii. ");
INSERT INTO nii_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ba na enim kin oł embin tui oł ei nge, tonu omba ni piip kin, na enim kengip ngop nind. Nga ekii se, oł ei tonu om kin, enim ei piingii. Na enim kin ek yi nir mił, ei piingii. Nimbił erang, ok na enim kin mołup kin, ek ei nip enim ngunerir. ");
INSERT INTO nii_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ba na Arnan kindang onj konu ei, nga orung bii end. Ba enim mołmun wu ei, endi na, ‘Nim konu jiłi punjii en?’ Ek yi endi nik kin, na kii sinenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ba na ek ei, enim kanip nemb kin, enim nge noman ełe embin mendpił enim. ");
INSERT INTO nii_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ba na ek keimi nip enim ngond. Na enim si kindip kin, na bii ełe nge, enim paki tumbii. Pe na punenj kin, Gos Gui Ka ei, enim paki to ermba ei, enim paki tunermba. Pe na punenj kin, enim dinga paki to ermba Gos Gui Ka ei, enim kin onermba. Ba na punj kin, eim kindamb kin, enim kin omba. ");
INSERT INTO nii_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nga Gos Gui Ka opu, ya mei konu ełe, pii gii ninenjing wumb ei, kongun erpi andan tang kin, en enim piingii ei, oł kis enjing pimba. Nga oł kun ka oł pałim ni, Gos en enim kos pimba ei, piingii ku. ");
INSERT INTO nii_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gos Gui Ka andan tang kin, wumb en enim oł kis enjing pułe ei, en enim na kin pii gii ninarik kin, endnjing ei, piingii ku. ");
INSERT INTO nii_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nga oł kun mendpił ei nge pułe andan yi mił tumba. Nimbił erang na Arnan kin nga orung bii ei, enim nga na kinerngii mon. ");
INSERT INTO nii_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Gos wumb kos piimba ei nge pułe andan yi mił tumba. Nimbił erang, mei ełe wumb tep er mołum wu ei Seisen, eim dup owundu kin kunum kunum mułmba. Yi mił ku, wumb pii gii ninenjing wumb ei kos owundu singii ku. ");
INSERT INTO nii_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Na ek pei pałim ei nip enim ngumbii end; ba pe na enim ngumbii end ei, pe enim kapłi ei piinerngii pałim. ");
INSERT INTO nii_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ba Gos nge Gui Ka ei ek keimi mendpił niłim ei, opu ek nipi enim kin ek keimi andan tumba. Nga eim noman ełe ek endi nipi enim ngunermba mon! Ba Gos nge ek eim piipi ek ei nipi enim ngumba. Ngopu kin, nga oł ekii se tonu omba ei nipi enim ngumba ku. ");
INSERT INTO nii_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Gos Gui Ka eim na nge ek ei sipi opu kin, enim tor pułe nipi andan tumba. Oł yi ermba ełe, na embe ambił tonu kindmba. ");
INSERT INTO nii_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Na Arnan nge epi pei ei, na nge ei piip kin yi mił nind. Gos Gui Ka na nge epi pei ei sipi opu kin, enim kin andan tumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jiisas nge ek yi nim, “Pe nga kunum aninga kopur enim kinerngii. Nga ekii se kunum aninga enim na keningii!” ");
INSERT INTO nii_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jiisas eim kin ekii siłmin wu kombur en enim ek yi mił ninjing, “Ek ei pułe sinim piimin ni, ninim mił nenj? Eim yi nim, ‘Enim pe kunum aninga na kinerngii. Nimbił erang nga nam Arnan kin bii ni pund,’ pa nirim. ");
INSERT INTO nii_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Nga ek yi ninjing, ‘Pe kunum aninga,’ ninim ei nipe ek ninim? Sinim eim ninim ek ei, pułe pii poł tunanmin,” ninjing. ");
INSERT INTO nii_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nik kin, Jiisas eim kii singii enjing ei, Jiisas eim piipi kin, ek nipi ngopu yi nim, “Na ninj ek ei, pułe piimin nik, kii sik orung orung er mołmun min? Na ek yi mił ninj, ‘Kunum aninga pe enim na kinerngii. Nga ekii se kunum aninga enim na keningii,’ pa ninj. ");
INSERT INTO nii_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ei na ek keimi mendpił nip enim ngond. Mani mei ełe wumb ombu pei, na to kundnjung kin, ka piingii. Ba ełe nge, enim noman embin to piingii. Nga noman embin ei, opu ka peng kin, nga enim ka mendpił piingii. ");
INSERT INTO nii_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Amb endi kangił mengmba ei piipi kin, noman embin to piiłim. Nimbił erang ei ngenj kumbii ełim; ba eim kangił mengpi kin, eim ngenj kumbii nga piinerim mon. Eim kangił mengpi tonu om ei, kangił kan ka kanpi se mułum. ");
INSERT INTO nii_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ei mił pe enim noman embin piinmin. Ba na enim nga kenmbii kunum ei, enim ka piingii. Enim noman ka piingii ei, wumb endi to eipi kindnermba mon! ");
INSERT INTO nii_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kunum ełe enim epi endi na kin kii sinerngii mon! Na ek keimi mendpił nip enim ngond. Pe enim na Arnan kin epi endi simin ni, prei erngii ei, na nge noman dinga ełe, enim kii singii epi ei enim ngumba. ");
INSERT INTO nii_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ok enim na nge noman dinga ełe epi endi simin nik kin, Gos kin prei enenjing mon! Pe enim epi endi ei kii sik ei, sinjing kin, en enim noman ka mendpił seng piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jiisas nga ek yi nim, “Na ek ombu nip ek ekin top ninj. Nga ekii se kunum endi, tonu omba ei, enim kin ek ekin top nip enermbii, mon! Ba nam ek kun nip tor kindip kin, Arnan mołum mił eim kin nip tor kindmbii. ");
INSERT INTO nii_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kunum ełe, enim na nge noman dinga ełe, Gos kin prei erngii; ba na enim kin ek nip yi ninenj ełe, na nam prei eramb kin, na Arnan kii sip enim paki tumba, ei mon nip end. ");
INSERT INTO nii_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Na nge Arnan enim noman ngonum. Ngang kin, nimbił erang, enim na kin noman ngonmun. Na Arnan Gos kin mołup, enim kin onj ei enim pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Kumb ok na nam Arnan kin ouni mołup, Arnan si kindip mani mei ełe onj. Pe na mei konu ełe ei si kindip kin, Arnan kin nga orung bii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Pe Jiisas eim kin ekii siłmin wu ombu en enim yi ninjing, “Pe nim ek ekin tunarkin kin, ek ni tor kindin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","“Pe sin pii kun enmin ei, nim wumb endi epi kii simba ni, kui enan mon. Ninim, epi pei pii poru niłin wu ei, pe sin pii gii ninmin ei, nim Gos kin ouni molkun on,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jiisas eim ek nipi orung kindpi yi nim, “Pe enim na kin pii gii ninmin min? ");
INSERT INTO nii_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Piinmin! Pe kunum mandi enim ei, tor wang kin, wumb enim endeim endeim mułngii konu ełe, si pok erik, en enim konu eipi eipi kindngii. Kindangin kin, enim na si kindik kin, konu ełe eipi eipi pungii. Ba na nam mendpił mulermbii mon! Na Arnan kin ouni mułmbuł,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Na nam noman ełe yi piind ei, enim na kin noman emin seng mułngii ei, na enim kin ok ek yi ninj, ‘Mani mei ełe enim oł embin tui pałim. Ba enim noman dinga peng mułngii! Mułangin kin, na ya mei ełe wumb dinga oł kis ei na to mani kind poru ninj,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jiisas ek yi ni poru nipi, eim tonu epin konu ełe tonu kanpi yi nim, “Arnan, kunum tonu op poru ninim. Ninim nge kinganim ei eim embe ambił tonu kindnjii. Yi mił Arnan, ninim nge kinganim na, nim embe ambił tonu kindmbii. ");
INSERT INTO nii_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nimbił erang, nim na noman dinga ngun, poru nim. ‘Na wumb pei tep er mułmbii,’ nin. Ninim wumb sikin kin, na ngun wumb ei, nam nge noman konj ei, wumb ngumbii. Pe noman konj ei ngunj, wumb ei sik, kunum kunum konj mułngii. ");
INSERT INTO nii_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Noman konj sik, kunum kunum mułngii ei yi mił; wumb en enim piinmin. Nim Gos keimi endeim mendpił molkun kin, nam Jiisas Krais, nim mendpił na kindan onj ni, yi piingii. ");
INSERT INTO nii_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Arnan, na nim nge embe ambił tonu kindip kin, ya mei ełe wumb ei, andan tunj poru nim. Neng kin, nim na kongun ei erii ni ngun, kongun ei, na er poru ninj. ");
INSERT INTO nii_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pe na Arnan, kumb ok mei sineririm kunum ei, na nim kin ouni mult ei, nam tiłang owundu pirim. Pe na yi piind, Arnan, ok nam tiłang owundu ei na ngunjii! ");
INSERT INTO nii_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nim mei wumb ełe tor sikin kin, wumb na ngun wumb ei, ninim nge noman dinga ei, na andan tunj. Ninim nge wumb ei, na ngo poru nin. Nga wumb ei nim nge ek ei ekii ka sinjing. ");
INSERT INTO nii_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Pe wumb en enim piinmin ei, Arnan nim epi pei na noman dinga ngo poru nin ei piik kin, nga epi ei, ninim kin onum ni piinmin ku. ");
INSERT INTO nii_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nim ek pei ni na ngun ek ei, na nip wumb ombu ngunj ei piik kin, keimi na nim kin ouni mołup kin, onj ni piinmin. Piik kin, nim na kindan onj ni, nim kin pii gii nik mołmun. ");
INSERT INTO nii_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na prei eramb kin, nim wumb omba paki tunjii. Tokun kin, mani mei ełe pii gii ninenjing wumb pei ei kin, nim paki tunjii na prei enand mon. Ba Gos, ninim wumb sikin kin, na ngum wumb ei kin, prei erip paki tunjii. Nimbił erang wumb ei, ninim sikin mundkun eran kin pii gii ninjing wumb ei, nim nge wumb mołmun. ");
INSERT INTO nii_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na nge wumb ei, nim nge wumb pei, nga nim nge wumb ei, na nge wumb. Pe wumb ei, na embe ambił tonu kindinmin. ");
INSERT INTO nii_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na nim kin ombii. Pe na mei konu ełe nga mulermbii; ba wumb ei mei konu ełe mułngii. Na Arnan oł kun ka nge puł wu. Arnan, ninim wumb ei, tep eran kin, ninim nge noman dinga ełe mułngii. Siłip noman ende pałim ei mił, wumb en enim yi mił peng ku, mułngii. ");
INSERT INTO nii_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na wumb ombu kin, ouni muls kunum ei, na tep ka eramb kin, nim nge noman dinga ełe ka mulnjung. Nim noman dinga endi nikin, na ngun ei, piip kin, na tep ka er mułamb kin, endi am punerim ei, ninim nge mon pułun ełe, ek yi nirin mił ei, keimi pimba pałim. Wu endeim mendpił am ba. ");
INSERT INTO nii_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Arnan, pe na nim kin ond. Na mei konu ełe mołup kin, na ek ei nemb kin, na nge noman ka ei, wu ombu kin piki tang, mułngii ei nge, en enim noman ka peng yi er mułngii. ");
INSERT INTO nii_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Arnan, nim nge ek ei, na nip wu ombu ngunj. Ba wumb pii gii ninenjing wumb ei, wumb ombu kin opu orung enjing. Nimbił erang wumb en enim pii gii ninenjing wumb ei mił, wumb endi mon. Nga yi mił ku, na pii gii ninenjing wumb ei mił endi mon ku. ");
INSERT INTO nii_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na prei erip kin, mei ełe si tor sinjii ninand mon! Na prei erip kin nimba wumb ombu tep ka enjii nge nind. Yi eran kin, wu kis endi Seisen ei opu enim pii gii ei to eipi eipi kindnermba mon. ");
INSERT INTO nii_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nga en enim mei ełe nge wumb mon! Pe na yi ku, mei ełe nge wu mon ku! ");
INSERT INTO nii_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gos nim wumb ei eran kin, ninim na nge ek ei, ekii singii. Ninim ek ei ek keimi mendpił. ");
INSERT INTO nii_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ok nim na kindan op mei ełe wumb mulnjung konu ełe muls ei, yi mił ku; na wu ombu mei ełe wumb mołun konu tuk ełe punmun. Punmun ei, kindind ei nge, mei wumb pei nim ek piingii. ");
INSERT INTO nii_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Na nam nge noman konj ngop kin, wu ombu kin paki tumbii ei, ninim nge ek keimi ei, pii gii ninjing kin wumb ei, ninim nge ek ekii singii. Pe wu ombu nim nge wu mendpił mułngii. ");
INSERT INTO nii_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Na wu ombu kin mendpił, prei er ngunand mon! Ba wu ombu puk kin, na nge ek ei ningii wumb ei kin, wumb na kin pii gii ningii nip end ku. ");
INSERT INTO nii_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na nim prei er ngond yi; wu ombu pei noman ende sek mułngii. Arnan, nim na kin mułan, na nim kin mułamb enmbił oł ei, wumb ei yi erngii. Erik kin, siłip kin piik mułngii, ei nge, mani mei ełe pii gii ninenjing wumb ei, yi piingii. Gos nim kindan onj ni piik kin, pii gii ningii. ");
INSERT INTO nii_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nim na embe ambił tonu kindin ei mił ku, na en enim kin yi ku erinj. Ei nge, en enim noman ende sek mułngii. Ei yi mił ku, kumb ok siłip noman ende se mułmbuł. ");
INSERT INTO nii_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nim na kin ende mołmbuł yi ku, na en enim kin ende mołmun. Yi mił ermbił ei, en enim noman ende sek mułngii. Pe nga mei ełe pii gii ninenjing wumb ei, en enim piingii ei, Gos nim na kindan onj, ni piingii. Nim wumb ei noman ngołun mił ei, na noman ngoł. ");
INSERT INTO nii_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Arnan, na noman ełe yi piind. Nim wumb sikin kin, na ngum wumb ei, na pu mułmbii konu ełe, ouni mułmun nind. Ei nge, na wumb nam nge tiłang owundu ei keningii. Kumb ok mei sineririm kunum ei, Gos nim na noman ngołun. Nga tiłang owundu ei, ngurun ku. ");
INSERT INTO nii_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Na Arnan! Nim Gos oł kun ka mendpił puł wu. Mani mei ełe pii gii ninenjing wumb ei, nim pii poł tunerik mon! Ba na nim piił. Nga ya wu ombu nim piiłmin ku. Gos nim na kindan onj ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na nim nge oł dinga ei, wumb kanik andan tunj. Na nga andan tumbii nge wumb, en enim noman ngok enmin, oł ei piingii. Nim ei piikin kin, nim na noman ngun yi ku, wumb ei kin ngunjii. Nga yi ku, na en enim kin, ende mułmbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jiisas eim prei erpi ei poru neng kin, eim kin ekii siłmin wu ombu kin, ouni puk, noł endi embe Kiron. Noł Kiron ełe orung puk kin, orung ond Olip mong nołmun ond pin pendnjing konu ełe, tuk punjung. ");
INSERT INTO nii_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Juras Jiisas nipi, opu orung wumb ngumba wu ei, eim konu orung ełe ond Olip telnjing konu ełe, eim piim ku. Nimbił erang, kunum kunum Jiisas eim kin ekii siłmin wu ombu kin, ond mong Olip telnjing konu ełe, kułou tołmun konu ełe Juras eim piim. ");
INSERT INTO nii_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pe Juras eim opu wu kombur sipi kin, nga kułmał kałiłmin owundu enim nge opu ond wu kombur kindangin wu ni, lo ek piiłmin wu ei sipi, konu orung ełe, tuk om. Pe wumb ombu, dup jep kandik sik, opu epi sik, ambilk tu wunjung. ");
INSERT INTO nii_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jiisas eim kin, oł ombu pei tonu omba erim ei, Jiisas eim piipi poru nim. Nipi kin, wumb onjung konu ełe mandi pupu yi nim, “Enim nii kuruk onmun?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Pe wumb ek nik, orung kindik yi ninjing, “Sin Jiisas Nasares nge konu ełe wu ei kurpun onmun,” pa ninjing. Pe Jiisas ek nipi, orung kindpi yi nim. “Ei na mendpił moł.” Nga Juras eim Jiisas sipi, opu orung wumb ngumba wu ei, wumb kin ouni angk mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nga Jiisas eim ek yi nim, “Ei na mendpił moł!” Yi neng kin, wumb puku sik, orung bin ni erik, mei ełe mani bok tunjung. ");
INSERT INTO nii_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jiisas nga ek nipi yi mił kii sim, “Enim nii kuruk onmun?” Wumb ek nik yi ninjing, “Jiisas Nasares konu ełe wu ei kurpun onmun,” yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jiisas ek nipi, ngopu yi nim, “Na enim ek poru ninj ei, ‘Na mendpił moł.’ Pe enim na kuruk onjung kin, wu ombu wak tangin pungii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Eim ek yi nim ek ei, ok eim nirim ek ei, keimi pimba ni piipi nim. “Arnan, nim wu ombu na ngun ei, endi wak top kindnenj.” ");
INSERT INTO nii_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Piisa eim tui kepii olt endi, se mułum ei sikir sipi, kułmał kałiłim owundu wu ei nge kongun wu endi nge kom ełe, tui topu, kiłip to kindim. Tum kongun wu ei, eim embe ‘Melkas’ niłmin. ");
INSERT INTO nii_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pe Jiisas eim Saimon Piisa kanpi yi nim, “Tui kepii olt ei nge, konu ełe orung kindii! Na Arnan oł embin tui ei to mundum ei, na kin tonu onermba ni piin min?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Pe opu ełmin wumb tiłap ei ni, opu tep ełim wu ni, Jura wumb opu ond wu ombu ni, enim ok Jiisas ambił gii nik, kan ngunjung. ");
INSERT INTO nii_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Wu Kaiyapas gułum Anas mułum konu ełe ok sipnjing kunum ełe, Kaiyapas eim kułmał kałiłim wu owundu kongun konj ei erim. ");
INSERT INTO nii_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiyapas eim ok Jura wumb kanpi yi nirim, “Wu endeim kapłi kołpu, sinim wumb pei paki tumba,” nirim. ");
INSERT INTO nii_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","16","Saimon Piisa kin, na Jon, Jiisas sipnjing konu ełe ekii se punjnguł. Nga wu endi eim kułmał kałiłim wu owundu ei kaniłim. Yi peng kin, wu Piisa ni pupu, Jiisas sipik enjing konu ełe tuk pum. Pupu, kułmał kalk ełmin wumb ei, ekii se pum; ba Piisa eim kung gui ondu mandi ełe torung angpi mułum. Pe na Jon, wumb onjung konu ełe tuk ełe onj. Pe na pup kin, kung gui ondu tep mułum ambił ei kin ek neng kin, na Piisa nirik tu wunj. ");
INSERT INTO nii_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ambił kung gui ondu ełe tep er mułum ambił ei, ek nipi, Piisa ngopu yi nim, “Nim wu ei kin, ekii sikin endin wu kun min?” Piisa ek nipi yi nim, “Na mon!” ");
INSERT INTO nii_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kongun wumb ni, opu ond wumb ei, en enim dup endi kelnjing. Nimbił erang konu jii nim. Wumb ei, dup ełe mandi dup piik mulnjung. Nga Piisa eim tuk ełe pupu angpi kin, dup ełe piipi mułum ku. ");
INSERT INTO nii_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kułmał kałiłim wu owundu ei, eim Jiisas kin ekii sik ok, wu ombu nge kii sim. Nga eim ek nipi, wu ngopu eririm ek ei mił piimbii nipi kin, Jiisas kii sim. ");
INSERT INTO nii_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jiisas eim ek nipi, orung kindpi yi nim, “Na wu amb pei kanip ek peni ełe nip ngoł. Nga kunum kunum men tołmun ngii ełe ni, Gos nge men ngii owundu ełe, nirik wumb pei ek emb top nip, wumb ngoł ku. Konu ełe Jura wumb kułou tołmun konu ełe, ek embe top nip ngoł. Na ek endi koi er ninał mon. ");
INSERT INTO nii_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Nimbił erang nim na kii sin? Ek emb top wumb ngop ei piinjing wumb mołmun wu, kii sikin piinjii. Wumb ombu na nir ek ei piik mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jiisas eim ek yi mił neng kin, opu ond wu endi mandi angpi mułum ni opu, Jiisas angił misin topu, yi nim. “Nim ek yi mił nikin, kułmał kałiłim wu owundu ngon min?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pe Jiisas eim ek nipi orung kindpi yi nim, “Pe na ek kis endi nił pim kin, kapłi pe nim ni tor kindan wumb pei piingii. Ba ek kun ninj pim kin, kapłi pe nimbił erang nim na ton?” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Pe Jiisas kan to pendnjing mił peng kin, wu Anas Jiisas kindang, kułmał kałiłim wu num Kaiyapas mułum konu ełe kindim. ");
INSERT INTO nii_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Piisa eim dup piipi, angpi mułang kin, wumb eim kanik yi ninjing. “Nim wu ei kin ekii sikin wu min?” Pe eim ek kend topu yi nim, “Ei na mon!” nim. ");
INSERT INTO nii_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kułmał kałiłim owundu wu ei nge kongun wu endi Piisa eim wu ei kom tui kepii kin tum ei nge, tiłap ende wu endi, opu yi nim, “Keimi mendpił na nim kenj ei nim eim kin ouni tuk ond mong Olip pin ełe, tuk mułun ni kenj,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piisa nga eim ek dinga nipi yi nim, “Na Jiisas kinał mon!” Yi neng kin, pe mendpił kei kultu pełi wii tum. Wii tang kin, Piisa eim kin Jiisas ok nirim mił, ek ei piim. ");
INSERT INTO nii_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kułmał kałiłim wu num ombu ngii ei kin si kindik. Pe nga Jiisas sipik, gapman owundu ngii ełe mułum konu ełe sipnjing kunum ełe, kupiiring sipnjing. Jura wumb en enim gapman owundu ngii ełe nirik punenjing. Nimbił erang, en enim lo ek yi mił pałim. “Sin wumb eipi ngii ełe nirik bin ei, sin ngenj ełe penj mułmba; ei mon!” niłmin. “Ełe nge, sin kuni owundu ‘Pasopa,’ ei nunermin,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yi piik kin, torung mulnjung. Pe Pailos eim tor opu, yi nim, “Enim wu ei, nimbił oł erim nik, kos erngii tu wunjung?” ");
INSERT INTO nii_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Wumb ek nik, orung kindik yi ninjing, “Pe wu ei, oł kis endi enełang kin, sin nim kin tu wunełamin mon,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailos ek nipi, orung kindpi yi nim, “En enim wu ei sipik, en enim lo pałiłim mił, kos piik erngii, sipei!” a nim. Nga Jura wumb ek yi ninjing, “Sin lo ek wu endi to kundmun min niłmin, ei sin to kundmun mił mon?” pa yi ninjing. ");
INSERT INTO nii_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nengin kin, oł ei, Rom wumb oł yi mił ełmin oł ei nge ok, Jiisas eim ond peri kułmba nge, ei ni pendrim. Pe eim ok, wumb kan nirim ek ei mił, keimi pimba erim. ");
INSERT INTO nii_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nga Pailos gapman ngii owundu ełe nga nirik pum. Pupu kin, Jiisas wii tang wang kin, Pailos ek nipi, Jiisas kii sim. Sipi kin, yi nim, “Nim Jura wumb nge king min mon?” ");
INSERT INTO nii_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jiisas eim ek nipi, orung kindpi yi nim, “Pe ninim noman ełe, ek ei piikin nin, min wumb endi eipi, na king nim ek yi mił nengin kin, nin min?” ");
INSERT INTO nii_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Nga Pailos ek nipi, orung kindpi yi nim, “Na Jura wu min? Nimbił erang ninim nge Jura wumb tiłap ei ni, kułmał kalk ełmin wu num ombu ni, nim tu wuk, na moł konu ełe ngunjung. Pe nim nimbił oł kis endi en?” ");
INSERT INTO nii_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Pe Jiisas ek nipi, orung kindpi yi nim, “Na nge konu sinim tep er mołum konu ei, ya mei ełe konu tep er mułułamb kin, keimi na nge kongun wumb ei opu erik, Jura wumb endi ok, na sik, Jura wumb ngunenełangin mon! Ba na sinim tep er kanip mołum konu ei, ya mei ełe mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nga Pailos ek yi nim, “Pe nim king endi min?” Jiisas ek nipi orung kindpi yi nim, “Ei ninim na king pa nin. Na minan ei na mei ełe mengim. Na mei ełe tonu onj ełe nge, na ek nip, wumb ngop, kongun yi mił erip, ek keimi nip tor kindip eł. Wumb pei ek keimi mendpił ei ekii siłmin wumb ei, na ek ei piiłmin.” ");
INSERT INTO nii_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailos ek nipi, ngopu yi nim, “Ek keimi nim nin ek ei nipe mił?” Yi ni pendpi anda pupu kin, Jura wumb kanpi kin, ek nipi ngopu yi nim, “Na wu ei, oł kis endi erim ei, na kur kan sinand. Wu ei kin, oł kis endi eim erim pinałim. ");
INSERT INTO nii_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ba enim nge oł endi yi pałim. Ei ‘Pasopa’ kunum ei, kan ngii wu endeim ni kindmbii, niłmin. Pe na Jura wumb king ei, enim kin tor kindmbii min mon?” ");
INSERT INTO nii_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wumb pei nga wii dinga tok, yi ninjing, “Ei mon! Nim Barapas kindan wangłi!” Barapas eim wumb to kondpu, wumb eipi epi nge waning sipi ełim wu mołum. ");
INSERT INTO nii_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","2","Yi nengin kin, Pailos ek yi neng kin, opu wumb Jiisas sipik kepii tunjung. Nga opu wumb kan jimbiltang gał mułum ei nge sik, king nge peng kon endi mił erik, peng ełe pendik kin, king nge alap mił alap kundii endi sik, eim telnjing. ");
INSERT INTO nii_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Talk pendik kin, opu wumb ok yi ninjing, “Jura wumb nge king owundu mołun?” Nik, ek kulsik, angił misin tok, yi enjing. ");
INSERT INTO nii_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailos nga tor opu wumb kanpi yi nim, “Enim kinei! Pe na eim sip tor tu wup, enim ngamb kin, enim piingii ei, na eim erim oł ei endi, na kan sinand mon!” ");
INSERT INTO nii_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pe Jiisas tor om. Opu kin, eim kan jimbiltang gał mułum ei sik, eim peng kon mił enjing, ei eim peng ełe mułang kin om. Nga alap kundii king mił talk kin, kindangin om. Opu kin, Pailos wumb kin ek yi nim, “Wu ei, enim kinei!” ");
INSERT INTO nii_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yi mił peng kin, kułmał kałiłmin wu owundu nin opu ond wumb ombu nin Jiisas kenjing ni, wumb ombu wii dinga tunjung, “Eim ond peri ełe nil to! Eim ond peri ełe nil to,” yi wii tunjung. Pe Pailos ek nipi, wumb ngopu yi nim, “En enim wu ei sik, ond peri ełe nil tei! Na wu ei oł kis erim oł ei, kan sinenj mon!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jura wumb ek nik orung kindik yi ninjing, “Sin lo ek endi pałim ei, lo ek ei yi ninim, ‘Wu ei kułmba. Nimbił erang na Gos nge kingam moł,’ niłim.” ");
INSERT INTO nii_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pe Pailos ek ei piipi kin, mund mong nga erim. ");
INSERT INTO nii_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yi erang kin, Pailos kin Jiisas nga gapman ngii owundu ełe nirik punjnguł. Pukuł kin, Pailos kin ek yi nim, “Nim jiłi molkun on?” Ba Jiisas eim ek endi nipi, orung kindnerim mon. ");
INSERT INTO nii_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailos ek nipi yi nim, “Nimbił erang nim na ek ei, ni orung kindnan? Na dinga ełe, nim si kindamb punjii. Nga na dinga ełe, nim ond peri ełe nil tumbii ei, nim pii poł tunan min?” ");
INSERT INTO nii_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jiisas ek nipi, orung kindpi yi nim, “Pe Gos tonu mołum ei, nim dinga ngunełang kin, nim kapłi na to mani kindnełan mon! Nga wu ei na sipi, nim angił ełe ngum wu ei, eim nge oł kis ei nim nge oł kis en ei to mani kindim. Eim nge oł kis am tonu mendpił pałim!” ");
INSERT INTO nii_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailos eim ek ei piipi kin, Jiisas ek dinga nip, tor kindamb ba, ni piim. Ba Jura wumb wii tok, ek dinga nik yi ninjing, “Pe nim wu ei kindan pum kin, nim Rom wu owundu, Siisa nge wu puł mon!” pa ninjing. “Wu nii endi, ‘Na king’ nimba wu ei, Rom wu owundu, Siisa nge opu orung wu mułmba.” ");
INSERT INTO nii_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailos eim wumb ek ei piipi kin, ek yi nipi, opu wu endi Jiisas sipi anda tu wum. Pe Pailos eim tonu kos piik ełmin konu ełe mułum. Pailos mułum konu ei, kom ku peł kuł sałmin konu ełe mułum. Nga Eipru wumb konu ełe embe yi niłmin, ‘Gapasa’ niłmin. ");
INSERT INTO nii_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pe kunum ei, kuni owundu ‘Pasopa,’ kor kunum nik, kuni er kun erik ełmin. Nga ‘Pasopa’ kunum ba konu eni beli pim. Peng kin, Pailos ek yi nim, “Jura wumb en enim king ei kinei!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pe kułmał kałiłmin wu owundu ek orung kindik yi ninjing. “Sin nge king endi eipi mulałim, ba wu Siisa sin nge king endeim mołum. ");
INSERT INTO nii_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pe nga Pailos eim Jiisas wumb nge angił ełe ngum. Ngang kin, wumb ombu Jiisas ond peri ełe nil to pendngii nge ngum. ");
INSERT INTO nii_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yi mił peng kin, wumb ombu Jiisas sipnjing. Sipangin kin, Jiisas eim ond peri ei ko wupu sipi kin, tor pum. Pum konu ei embe, ‘Wumb peng embił konu,’ niłmin. Konu ei embe endi Eipru ek nik, ‘Golkasa’ niłmin. ");
INSERT INTO nii_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Konu ełe, wumb ombu Jiisas ond peri ełe nil tunjung. Tok kin, nga wu eipi tał ond peri ełe tał eipi yi ku nil tunjung. Wu endi Jiisas nge angił taring ełe nil tok kin; nga endi Jiisas nge angił tundung ełe nil tunjung. Tok nga, Jiisas wu tał kin tuk mii menb ełe nil tungung. ");
INSERT INTO nii_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailos eim mon endi połpu kin, Jiisas pim ond peri ełe tonu kind pendim mon ei, ek yi mił nim, “Jiisas Nasares Konu Ełe Wu Ei Jura Wumb King.” yi ni poł pendim. ");
INSERT INTO nii_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Konu orung ełe, Jiisas ond peri ełe nil tunjung ei, konu owundu ełe mandi mił sim. Pe Jura wumb pei Pailos ek pułum ei gerik piik enjing. Erik ek ei, Eipru wumb ek ni, Griik wumb ek ni, Rom wumb ek ni, ei mił poł pendim. ");
INSERT INTO nii_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Pe Jura kułmał kałiłmin wu num ombu Pailos kin ek yi ninjing, “Pailos, nim ek mon yi pulerii mon! ‘Jura wumb nge king’ ei mon; ba nim ek mon yi mił poł! ‘Wu ei eim yi nim, na Jura wumb nge king,’ yi pułii!” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailos ek nipi, wumb ngopu yi nim, “Ek na puls, ei poł poru ninj ei pengłi!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nga opu ond wumb kapił kapłi ombu, Jiisas ond peri ełe nil to pendik kin, Jiisas alap ni konduk ei, mok tok, en enim wu endeim endeim ni sinjing. Nga kon takis ei sik ku; ba kon takis ei mui tołmun konu endi sineririm. Sinerang kin, kon ei, tonu orung orung er mani puk pirim. ");
INSERT INTO nii_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Pe opu wumb en enim ek yi nik, “Sinim kon takis ei, to piltan to yi enermin mon!” nik. “Sinim kom ku kembis mił siłin kin kinjmał erpin kin, wu endeim mendpił konduk ei simba,” ninjing. Nik oł yi erik kin, Gos nge ek ok pultum yi nirim, mił keimi tonu opu poru nirim. “Na nge alap konduk ei mok to sinjing. Nga na kon takis ei, kom ku kembis mił kinjmał erik kin, wu endeim simba nik, yi enjing.” Ei keimi tonu wang kin, wumb yi enjing ei Gos nge ek nirim mił keimi tonu om. ");
INSERT INTO nii_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Pe Jiisas ond peri ełe to pendnjing konu ełe, Jiisas eim mam ni, angim Mariya ei, Kliyopas nge ambim ni Mariya Makandala ouni ok engnjing. Amb ombu ok, Jiisas to pendnjing ond peri ełe, mandi ok engnjing. ");
INSERT INTO nii_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jiisas eim kenim ni, mam kin, Jiisas eim noman ngopu ełim wu ei, na Jon ouni mandi ond peri ełe enginjngił. Pe Jiisas eim ek nipi, mam ngopu yi nim, “Wu ei, nim kinganim mił mołum.” ");
INSERT INTO nii_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nga Jiisas eim noman ngołum wu, na Jon kanpi yi nim, “Amb ei, nim manim mił mołum,” pa nim. Pe kunum ełe, na Jon, Mariya nam ngii konu ełe orung sip kin, tep er se moł. ");
INSERT INTO nii_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pe ei poru neng kin, Jiisas eim piim ni, eim kongun ei pei poru nim. Nga Gos nge ek mon ok pułum ei, keimi tonu orum ei, poru nipi yi nim, “Na noł nuwa enim,” nim. ");
INSERT INTO nii_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Noł ming endi piki to pim ei, epi gupu tołum noł wain ei kindangin kin, piki top pim. Pe wumb endi sikir pupu, noł tuk siłim epi ei mił epi endi sipi mułang kin, Jiisas numba piipi kin, epi endi tu wupu kin, noł gupu tołum epi tuk kindim. Kindpi kin, goltum endi tu wupu kin, Jiisas gupu ełe pendim. ");
INSERT INTO nii_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pe Jiisas eim noł gupu tołum noł wain ei, nopu yi nim, “Nam kunum pei ei poru ninim,” a nim. Yi mił nipi kin, eim peng to mani kindpi kin, kułum. Nga eim noman tuk gui ei, wak tang pum. ");
INSERT INTO nii_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pe kunum ei, kuni owundu ‘Pasopa’ numun nik, kuni er kun ełmin. Nga kor owundu tonu wang kin, Jura wumb lo ek yi mił ni pendiłmin ei yi mił, “Kor owundu ełe, wumb kongun endi enerngii mon!” pa niłmin. Ei yi mił peng piik kin, kulnjung wu kei ngenj tonu ond peri ełe mulerngii, ni piinjing. Pe wu Kombur Pailos kanik kii sik, ek yi ninjing. “Enim sikir ok kin, wu kei nge simb angił ełe sikir embił engin tangin kin, sikir kułangin kin, si mani singii,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","33","Pe opu ond wumb puk kin, wu tał Jiisas kin ouni ond peri ełe nil tunjung wu tał, simb angił ełe, ambilk engin tok enjing; ba puk kin, Jiisas kenjing ni kułum pim. Nga eim simb angił embił kin engin tok enenjing, mon. ");
INSERT INTO nii_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ba opu ond wu endi Jiisas demb ełe kiłeng tum. Tum konu ełe, sikir miyem kin noł ouni tor om. ");
INSERT INTO nii_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Pe na Jon, oł ei erim, ei kanip piinj. Pe nga, na Jon ek ei nip tor kindind ei kapłi, enim pii gii ningii. Na ek nind ek ei, keimi mendpił! Na piip kin, ek nind ei, ei keimi mendpił nip tor kindind. ");
INSERT INTO nii_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Epi ei tonu om ei, Gos nge ek ok pułum ei nirim ei, keimi tor om. Ek ei yi mił pałim, “Eim nge embił endi to engin tunerngii mon!” ");
INSERT INTO nii_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Nga Gos nge ek ok pułum ełe, ek endi yi mił ninim, “Opu ond wu ei, kiłeng to kundum wu ei keningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ei epi poru neng kin, Josep wu ei eim Airmasiya konu ełe wu ei, eim Jiisas kin ekii siłim wu endi om; ba eim Jura wumb kin mund mong erpi kin, eim pii gii ei ni peni ełe kindnerim. Josep eim opu, Pailos kanpi kin, yi nim, “Na Jiisas ngenj ei simbii ond,” pa nim. Pe Pailos kapłi neng kin, Josep Jiisas ngenj ei sipim. ");
INSERT INTO nii_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikoriimas wu ei, eim ok, Jiisas multum konu ełe epin kunum kunum orum wu ei, eim om ku. Om wu ei, eim ond kanim eipi eipi tał ei nge muru ka tołum epi ei sipi tu wum. Tu wum ond tał nge, epi muru ka wii tołum ei ende kindik mundnjung. Pe ond kopung ei, epi embin owundu er 100 mił yi kapłi erim. ");
INSERT INTO nii_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wu tał Jiisas nge ngenj ei sipinjngił. Pe wu tał epi muru ka tołum ei, Jiisas ngenj ełe kindikił. Nga alap ka wii pandi tokuł ei enjngił Jura wumb, wumb kułii tungii pendik ełmin oł ei, enjngił. ");
INSERT INTO nii_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jiisas ond peri ełe, to pendnjing konu ełe, aka pin endi sim. Pe aka pin ełe, tukpu konj endi sim. Tukpu konj ei, ok wumb kułii endi tukpu ełe tunenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pe kunum ei, kor owundu kuni ‘Pasopa’ kunum mandi erang kin, Jura wumb kuni er kun ełmin kunum ei, mandi poru nimba. Nga tukpu konj mandi mołum ei, wu tał Jiisas konu ełe pendinjngił. ");
INSERT INTO nii_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pe Mariya Makandala eim kor kunum kupiiring ok tangpi kun enerang kin, eim Jiisas pendnjing konu tukpu ełe tor om. Opu, eim kenim ni Jiisas eim pendik, tukpu ełe kom ku owundu endi, ondu ngok pendnjing; ba eim kenim ni, ondu ngok pendnjing mił pinerim. ");
INSERT INTO nii_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yi peng kin, eim nga sikir pupu, Saimon Piisa kin wu endi Jiisas eim noman ngołum wu ei, Jon kin mulnjunguł konu ełe kanpi yi nim, “Sinim Owundu tukpu ełe pinałim; sipinjing pałim. Sin piinamin; eim sipi jiłi orung pendnjing da.” ");
INSERT INTO nii_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pe Piisa kin na kin sił ngii konu ełe punjkuł. ");
INSERT INTO nii_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pupuł kin, sikir punjpuł; ba na Jon, Piisa eim pend si kindip na ok punj. Pup kin, Owundu tukpu tunjung konu ełe, ok tor punj. ");
INSERT INTO nii_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pup kin, mani pii połup, tukpu ełe epi sip kenj ni alap tuk sim; ba eim tuk pup kinenj. ");
INSERT INTO nii_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon Piisa ekii se tor opu, tukpu ełe tuk pupu, kenim ni alap ei mendpił sim kenim. ");
INSERT INTO nii_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Nga alap, Jiisas eim peng ełe pandi tok pendnjing alap ei, sinerim mon! Alap ei simbir ka erpi, orung ełe eipi kind sim. ");
INSERT INTO nii_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Pe na Jon ok onj, tukpu ełe tuk punj ku. Pup, epi ei kanip kin, na pii gii ninj. ");
INSERT INTO nii_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pe kunum ei, Gos nge ek ok pułum ei, sił pii kun enenjpił. Gos nge ek ei yi nirim, “Jiisas eim tukpu ełe angpi konj ba,” yi mił ninim. ");
INSERT INTO nii_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Pe sił Jiisas kin ekii siłmbił wu tał, nga ngii konu ełe orung punjpuł. ");
INSERT INTO nii_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pe Mariya eim, tukpu ełe, torung angpi kin, ke nipi engim. Ke ni, pendpi kin, tukpu ełe kan tuk kind kenim. ");
INSERT INTO nii_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Kenim ni, enjel tał alap kuru kindinjngił wu tał mulnjunguł ni kenim. Ok Jiisas eim ngenj pim konu ełe mulnjunguł enjel endi, Jiisas nge peng sim ełe mułang kin, endi Jiisas nge simb sim konu ełe mułum. ");
INSERT INTO nii_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pe enjel tał ek nikił Mariya ngokuł yi ninjngił. “Amb, nim nimbił erang ke nin?” Pe eim ek nipi, ngopu yi nim, “Na nge Owundu sipnjing pałim ei, eim sipik, jiłi orung pendnjing ei na piinand,” nim. ");
INSERT INTO nii_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","15","Yi nipi, kan orung kind kenim ni, wu endi engim. Ba amb Mariya ei, eim wu ei Jiisas ni piinerim mon! Pe amb Mariya eim yi ni piim; ei eim aka pin tep mułum wu endi ni piim. Nga Jiisas eim kanpi kin, yi kii sim, “Amb nim nimbił erang ke nin? Nim wumb nii kurun?” Mariya ek nipi, ngopu yi nim, “Pe nim eim si pendin kin, na nen kin, piip eim simbii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Pe Jiisas eim ek nipi yi nim, “Mariya!” Pe amb Mariya nga ak topu, Eipru wumb ek ełe yi nim, “Raponai!” Pułe ei yi mił, ‘Ek emb to ngołum wu,’ yi nim. ");
INSERT INTO nii_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jiisas ek nipi, eim ngopu yi nim, “Nim na ambił gii ninerii mon! Na Arnan kin nga orung tonu punenj, kokuł. Nim orung pukun kin, na engnan noł kankin yi ninjii! ‘Na Arnan nga enim Ernjing mołum ełe tonu pund. Nga nam nge Gos ni, enim nge Gos mołum konu ełe, tonu bii pund,’” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pe amb Mariya Makandala eim orung pupu, Jiisas eim kin ekii siłmin wu mulnjung konu ełe pum. Pupu, ek nipi yi nim, “Na Owundu kan poru nip ond.” Nipi, Jiisas eim kanpi, nipi ngum ek ei nipi, wu ombu ngum. ");
INSERT INTO nii_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jiisas kin ekii siłmin wu ombu, Jura tep ełmin wumb owundu kin mund mong enjing. Erik kin, en enim ngii endi ondu dinga ngo pendik kin, nirik mulnjung. ‘Konu kor kunum endi, konu eni mani pang kin, en enim ngii nirik mulnjung. Pe Jiisas eim opu tuk ełe engim. Angpi kin, yi nim, “Enim noman emin pangłi,” nim. ");
INSERT INTO nii_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yi mił neng kin, Jiisas ngenj orpuł angił ni, demb ei andan tum. Jiisas kin ekii siłmin wu ombu, nga Owundu kanik kin, ka piinjing. ");
INSERT INTO nii_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jiisas ek nga nipi wumb ombu ngopu yi nim, “Enim noman emin ka piingii. Arnan kindang onj mił, yi ku nga enim kindamb kin, nam kongun ei er pungii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eim ek yi mił nipi kin, eim pop topu, wu ombu kin kindpi kin, yi nim, “Gos nge Gui Ka enim kin ngond,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","“Na enim noman dinga ngond. Pe enim wumb kombur oł kis ei kil ngonmun ningii; ei kapłi poru nimba. Nga enim wumb kombur oł kis ei pangłi ningii wumb ei, oł kis pimba ku,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jiisas eim kin ekii siłmin wu engki nga tał mulk konu ełe Jiisas wumb ei kin, nga tor orum kunum ei, wu endi tuk ełe mulerim wu ei Tomas, nga eim embe endi ‘Dirimas,’ niłmin. ");
INSERT INTO nii_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Pe wu eipi ombu, Jiisas kanik Tomas ninjing; ba Tomas eim ek nipi, wu kombur ngopu yi nim, “Pe na Jiisas nge ngenj orpuł ei kanip, nam angił mong ei sip ambiłip, eim angił ni, demb ełe orpuł ei kanip enenj kin, kapłi na pii gii ninermbii mon,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nga ekii se, kongun endi opu pang, Jiisas kin ekii siłmin wu ombu kin, Tomas ni ouni mulk. Molk kin, en enim Jura tep ełmin wumb kin, mund mong erik kin, ngii ondu dinga ngo pendik poru nik, en enim nirik mulk konu ełe, Jiisas opu tuk ełe engim. Angpi kin, ek yi nirim, “Enim noman emin ka sengłi,” nirim. ");
INSERT INTO nii_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Pe Jiisas eim ek nipi, Tomas ngopu yi nim, “Nim angił mong ei yi ełe pendkin kin, na angił orpuł ełe kenii!” nim. “Nga nim nge angił ei, na demb orpuł ełe, tuk kindii! Pe nim pii gii ei to kindnenjii; ba nim pii gii dinga ninjii!” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas ek nipi, orung kindpi yi nim, “Nim na nge Owundu! Nim na nge Gos mendpił!” ");
INSERT INTO nii_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jiisas ek nipi, Tomas ngopu yi nim, “Nim na kankin pii gii nin min? Wumb na kinarik kin, pii gii nik yi enmin wumb ei, ka piingii.” ");
INSERT INTO nii_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jiisas eim jep oł nga pei erpi kin, eim nge ekii siłmin wu ombu mulk, tuk ełe erim. Ba na Jon Jiisas erim jep oł ei, pei mon ełe pulenj, mon. ");
INSERT INTO nii_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ba na ek poł poru ninj ei, enim Jiisas ei eim Krais Gos kindang wu eim, enim pii gii ningii ei, eim Gos nge kingam. Pe enim eim kin pii gii ninjing kin, kapłi enim eim nge embe ełe, enim noman konj sik, kunum kunum mułngii nge singii. ");
INSERT INTO nii_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ekii se nga, Jiisas eim kin ekii siłmin wu ombu kin tor om. Opu kin, Taipiriyas konu ełe ni konu orung ep noł gop mołum konu ełe, Jiisas eim nge yi mił tor om. ");
INSERT INTO nii_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Piisa ni, Tomas eim embe nga endi ‘Dirimas,’ niłmin ei ni, Nasaniyel, Kena konu kembis ełe, Galilii konu owundu ełe wu ei ni, Sependii nge kingam tał ni, nga wu tał Jiisas kin ekii sinjngił wu tał kin, ouni mulnjung. ");
INSERT INTO nii_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Pe Saimon Piisa ek nipi, wu ombu ngopu yi nim, “Na omu tumbii pund,” nim. Wu ombu ek nik, eim ngok yi ninjing, “Sin nim kin ouni bin,” ninjing. Pe puk, noł kanu ełe, tonu puk punjung. Ba kunum pei ei emii peng kin, en enim omu endi tunenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Pe konu kupiiring konu eni tonu omba erang kin, Jiisas eim pupu, noł gop orung wer ełe, engim. Ba eim kin ekii siłmin wu ombu ei, Jiisas ni piinenjing mon. ");
INSERT INTO nii_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Pe Jiisas ek nipi, wu ombu ngopu yi nim, “Kang wu kei, enim omu endi sinmin min?” Pe wu ombu ek nik, orung kindik yi ninjing, “Mon.” ");
INSERT INTO nii_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","7","Nga eim yi nim, “Enim omu kon nga sik, noł kanu angił tundung ełe kindik, omu kombur singii,” nim. Yi neng kin, omu kon pulnjung ni, omu pei sinjing. Pe omu kon ei tonu singii pinerim mon; kon ei wurup mendpił nim. Na Jon, ek nip, Piisa ngop yi nim, “Ei Owundu!” Pe Saimon Piisa eim kon takis gułpu sepi, kongun erim. Nga eim Owundu ek ei piipi kin, kon takis ni kindpi, puku sipi, noł ełe mani pum. Pupu kin, Jiisas mułum konu ełe sikir pum. ");
INSERT INTO nii_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jiisas kin ekii siłmin wu kombur wangin kin, omu mer kon ełe, piki top pim ni, ambił gii nik tonu sinjing. Nga wu ombu noł wer ełe, turii mił mulenjing. Mulk konu ełe ei su yi mił, 300 simb mił sim. ");
INSERT INTO nii_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pe ok noł wer ełe, tor ok kenjing ni, dup endi nopu pim. Pim konu ełe, kenjing ni omu kombur dup ełe pim. Nga bres orundung kenjing ni sim ku. ");
INSERT INTO nii_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jiisas ek nipi wu ombu ngopu yi nim, “Enim omu pe kon poł sinjing ei, kopur tu wei!” ");
INSERT INTO nii_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pe Saimon Piisa eim noł kanu ełe tonu pupu, omu kon ni ambiłpi kin, noł peł ełe ambiłpi sipi kin noł wer ełe sipim. Omu owundu owundu tuk omu kon ełe piki top pim. Omu tuk mołmun ei, omu peng yi mił 153 pei mołmun. Mulnjung omu pei ombu mulk, ba omu kon kiłip tunerim mon. ");
INSERT INTO nii_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jiisas ek nipi, wu ombu ngopu yi nim, “Enim ok, kuni nei!” a nim. Pe Jiisas nim ek ei, wu endi eim kii sinerim mon, “Nim nii?” En enim piinjing ni, “Ei Owundu,” ni piinjing. ");
INSERT INTO nii_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jiisas eim dup konu ełe opu, bres ni sipi, wu ombu ngum. Nga omu yi ku erim. ");
INSERT INTO nii_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jiisas eim kołpu nga tukpu ełe angpi opu kin, nga konj pupu endim. Pe eim kin ekii siłmin wu ombu kin, kunum tekliki peni ełe tor wang kin, kenjing. ");
INSERT INTO nii_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kuni nok poru nik, Jiisas ek nipi, Saimon Piisa ngopu yi nim, “Saimon, nim Jon nge kingam, nim epi eipi pei ełe to mani kindkin, na noman ngon min?” Saimon ek yi nim, “Keimi Owundu, nim piin; na nim noman ngond.” Pe Jiisas ek nipi eim ngopu yi nim, “Nim na nge wumb kung siipsiip wał mułangin kin, na nge ek emb tokun ngunjii ei, kung siipsiip mił kuni ngunjii.” ");
INSERT INTO nii_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jiisas ek nga nipi, Piisa ngopu yi nim, “Saimon Jon nge kingam, nim na noman ngon min mon?” Piisa ek orung kindpi yi nim, “Owundu, na nim noman ngond,” nim. Nga Jiisas ek nipi, Piisa ngopu yi nim, “Nim na nge pii gii ninjing wumb kung siipsiip mił ei, tep ka er mułii!” a nim. ");
INSERT INTO nii_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jiisas nga ek kunum tekliki nipi, Saimon ngopu yi nim, “Saimon Jon nge kingam, nim na noman pałim min?” Pe Piisa eim noman embin to piim. Nimbił erang pe ek kunum tekliki mił nipi, Piisa kindpi yi nim, ‘Pe nim na noman ngokun nin min?’” Pe Piisa ek nipi, Jiisas ngopu nim, “Owundu, ninim epi pei piiłin wu. Nim piin, na nim noman ngoł.” Pe Jiisas nga ek yi ku nim, “Nim na nge wumb kung siipsiip mił mułangin kin, na nge ek emb tokun ngunjii ei kung siipsiip mił kuni ngunjii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na ek keimi mendpił nip nim ngond, ok nim wu kangi wu multum kunum ei, ninim kan talkin, ninim konu jiłi bii ni piiłin konu ełe kunum ei, ninim kan talkin, ninim konu jiłi bii ni piiłin konu ełe pułun. Nga ekii se, nim tukui enjii kunum ei, nim angił tonu kindkin mułan kin, wumb nim kan kend ełe talk, ninim bii ni piinenjii konu ełe sipngii,” Jiisas yi nim. ");
INSERT INTO nii_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jiisas ek nirim ei pułe yi mił, Piisa eim ond peri ełe kułmba oł ei mił nirim kunum ei, eim Gos nge embe ei ambił tonu kindmba nge nim. Jiisas eim ek ełe nge piipi kin yi nim. Pe Jiisas Piisa kanpi yi nim, “Nim na bii konu ekii se!” a nim. ");
INSERT INTO nii_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piisa eim kan ak topu, kenim ni, na Jon ekii sip onj. Na ok kuni nuk kunum ełe, na Jiisas multum konu ełe, mandi mołup yi ninj, “Owundu, nim wu nii opu orung wumb ongii konu ni tor kindmba?” ");
INSERT INTO nii_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piisa na kanpi kin, ek yi nipi Jiisas ngum, “Owundu, wu Jon ei eim nipe oł mił endi eipi kułmba?” ");
INSERT INTO nii_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Pe Jiisas ek nipi, Piisa ngopu yi nim, “Pe nam noman ełe, eim konj mułang kin, na nga orung ombii kunum, ei kapłi. Pe ei nim nge epi mon! Nim na kin ekii se onjii.” ");
INSERT INTO nii_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yi mił nga ek ei, angim noł mulnjung konu ełe, eipi eipi nipi angim noł kin ngum. Ngopu, yi nim, “Ekii siłim wu ei, Jon eim kulermba. Ba Jiisas eim ‘Wu ei kulermba,’ ei, yi ninerim mon. Ba Jiisas eim yi nim, “Ei na nam noman ełe pim kin, wu ei konj mułang kin, na orung ombii kunum ei, ei nim nge epi mon!” ");
INSERT INTO nii_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ei ekii siłim wu endi, eim ek ei ni tor kindnim. Nga eim ek mon ei połpu, poru nim ek mon ei, sinim piinmin ek mon ei, ek keimi mendpił ninim. ");
INSERT INTO nii_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ba nga oł kanim kanim pei, Jiisas eim erim ku. Kapłi wu nii endi, eim Jiisas nge oł erim mon ei, pułmbii ni piim kin, kapłi mon pułngii ei, pei mułmba. Na piind ei, ya mei konu ełe orung orung pei mon pułułangin kin, kapłi konu endi wii sinenełang, mon! ");
INSERT INTO nii_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O Tiopilas, na mon ei, ok nam pei puls. Jiisas eim epi pei erpi, wumb andan topu erim ek ei, na puls. Kumb ok ni, pe kunum ełe, eim kongun pułngun mundum. Ekii se, eim tonu epin ba erim kunum ei, eim ek se andiłmin wumb kengip ngopu noman dinga ei, Gos Gui Ka kin ngurum. Ekii se, nga Gos Jiisas tonu epin sim. ");
INSERT INTO nii_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jiisas ngenj kumbii kułum. Kułum poru neng kin, nga ekii se, eim ek se andiłmin wu mulnjung konu konj tor om. Pe eim epi ei erang kin, nam konj moł ni piingii nipi yi nim. Pe kunum 40 ełe, Jiisas eim kenjing kunum ełe, Jiisas eim Gos epi pei tep erpi, kanpi mołum ei, ek nipi ngum. ");
INSERT INTO nii_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","En enim tep to molk kin, eim wumb ei ek nipi ngum. Enim Jerusalem konu, ełe si kindnerngii, ba Erinjpin Gos ek yi nim, “Na enim epi ngumbii ei, enim epi ei kui erik mułngii. Molk kin, na ek yi mił nip enim ngunj. ");
INSERT INTO nii_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon wumb noł pendpi ngum, ba kunum endi kinan punenmba ei, Gos Gui Ka enim noł pendpi ngumba.” ");
INSERT INTO nii_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pe kunum ełe, Jiisas wumb kin tep tok mulnjung. Molk kin, eim kii sinjing, “Jiisas Owundu! Nim Esrel tiłap wumb paki tokun, Rom wumb to mani kindnjii min? Kunum ełe, Esrel wumb nga wii mułngii.” ");
INSERT INTO nii_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pe eim ek nipi ngum, “Ei enim epi mon; pe enim kunum kunum pingii kapłi enermba ei Erinjpin Gos eim ełim. Pe eim enim tep mołum. ");
INSERT INTO nii_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ba ekii se Gos Gui Ka, enim kin omba. Nga eim enim noman dinga ngumba. Ngang, na ek Jerusalem konu ningii ei Juriya konu orung ni Sameriya konu ni, mei konu orung orung pei pang kapłi ermba.” ");
INSERT INTO nii_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jiisas eim ek ei nipi poru nim; pe en enim kanik mulnjung. Mułangin kin, Jiisas eim tonu pum. Pe kupu endi eim tonu sipim. Sipang wumb kanik mulnjung ni am sipim. ");
INSERT INTO nii_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eim pum, pe Jiisas nge wumb en enim ei muł ełe kanik enjing. Pe sikir wu tał konduk kuru pim, wu tał tor onjnguł ");
INSERT INTO nii_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Wu tał okuł yi ninjngił, “Enim Galilii wumb, enim nimbił erang angk ei muł ełe kanik mołmun? Ei Jiisas, pe Gos eim kin sipi orung sipi ei tonu epin sipipi, eim nga orung omba ei enim pe kaninmin mił yi orung omba.” ");
INSERT INTO nii_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yi erang, en enim komung ei si kindik, komung ei embe Olip, pe Jerusalem konu orung punjung. Komung pim ei, Jerusalem konu mandi pim. ");
INSERT INTO nii_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Pe en enim konu owundu ełe tuk punjung; en enim tuk mołułmun konu ełe tonu punjung. Punjung, wu embe yi mił Piisa, Jon, Jeims, Pilip, Endru, Tomas, Basolomu, Masyu, Elpiyas kingam Jeims, Jeims kingam Juras. Saimon wu endi wumb ei nge Rom wumb to mani kindngii nirim. ");
INSERT INTO nii_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pe wu ombu en enim noman ende kindik, prei erik mulnjung. Amb kombur ni, Mariya Jiisas mam ni, Jiisas angim noł yi ku prei erik mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","19","Wu Juras yi mił erim. Wu ei mei endi top erim ku ei kułmał kałiłmin wumb owundu ngunjung. Ngangin kin, eim oł kis er pendpi, wumb sipipi Jiisas mułum konu andan tum. Eim bok topu mani pum. Pe eim nge ngenj tuk ełe engin topu eim kirim ni tułup nipi tor pum. Ekii se wumb pei Jerusalem konu mulk wumb pei ek ei piik nik punjung. Pe en enim ek ełe konu ei ‘Akeltama’ nik mei konu ei wumb miyem konu ninjing. Wumb kułou tołmun kunum ei, Piisa pii gii wumb kumb ełe angpi, ek endi nipi ngum. Pe wumb 120 mił pei mulnjung. Piisa ek nim, “Engnan noł, enim piyei! Gos pipe mon endi multum, kumb ok Gos Gui Ka wu Deipis gupu ełe nipi tor kindrim. Juras kin nim, pe ei eim Jiisas ba konu andłam andan tang, wumb Jiisas keningii. Ek ei pepi peni ełe omba, nik pe pepi tor onum. Ok Jiisas Juras sin kin to tonu kind mondłum. Mołpu, sin kongun ende er mułpun ełmin nipi,” Piisa yi nim. ");
INSERT INTO nii_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piisa yi nim, “Ek ei mer mon Sam ełe Jura wumb golang Deipis pułum ek yi nipi nim, ‘Eim ngii konu wii simba, wu endi mulermba,’ mon Sam ełe ek yi ninim. ‘Pe nga wu eipi endi eim kongun simba,’ pa ninim.” ");
INSERT INTO nii_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Wumb endi Jiisas nga konj tonu om kenim ni wu ei sin kin tuk omba. Wu ei sinim kin tep topun endinmin. Kunum kunum Jiisas eim sinim kin pupu opu er mołum. Kunum ełe Jon eim wu amb noł pendpi ngurum. Kunum ełe nga Gos Jiisas sipi orung epin konu simba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Piisa ek yi mił nim, “Kapłi wu tał embe tumun.” Wu endi Josep, Basapas ninmin wu ei, wu ei embe eipi endi pałim ku, embe endi Jasas, pe wu endi embe Masaiyas. ");
INSERT INTO nii_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Pe en enim prei erik, “Owundu! Nim wumb pei noman tuk nim piin. Wu tał nii endi mułmba ei nim to tonu kindin ei nim sin andan to! ");
INSERT INTO nii_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Tan wu ei Juras ełim kongun ei ermba. Juras eim kongun ei si kindpi eim dup konu ełe pum.” ");
INSERT INTO nii_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Pe wumb en enim prei erik, Gos wumb andan tang angił tonu kindnjing ni Masaiyas wumb pei engki nga endeim ełe tuk kindangin kin, kongun ełe enjing. ");
INSERT INTO nii_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gos Gui Ka mani om kunum ei Pendikos niłmin. Pasopa kunum 50 poru neng, Pendikos kunum om. Pii gii wumb en enim ngii endi ełe kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pe sikir tonu muł ełe ek tengim, konu gur gałi mił, owundu endi top ngii ełe nirik wumb mulnjung konu om. ");
INSERT INTO nii_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Pe wumb molk kenjing ni dup anmbił mił pei onjung. Pe epi ei gał topu wumb mulnjung konu eipi eipi punjung. ");
INSERT INTO nii_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Gos Gui Ka Jiisas nge wumb mulnjung konu tuk opu poru nim. Gos Gui Ka je erang wumb pei, wumb ek eipi eipi tengnjing. Ei Gos Gui Ka erang yi enjing. ");
INSERT INTO nii_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pe Juras wumb Jerusalem konu mulnjung wumb, ei Gos ek piiłmin wumb konu orung orung pei onjung. ");
INSERT INTO nii_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pe konu gur gałi owundu neng kin, wumb ok kułou tunjung. Wumb ok molk ek ei piinjing ni, Gos nge wumb ek eipi eipi nik mułangin kin, nimbił erang puku sik mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Wumb puku sik noman embin tang mulnjung. Molk, ek yi ninjing, “Nimbił erang wumb ei ek eipi eipi nik enmin, ei Galilii wumb min? ");
INSERT INTO nii_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nimbił oł erang sinim ek erinjpin menjpin noł sinim ngopun ełe ek ei piiłmin mił niłmin. Wu ombu Galilii konu wumb min? ");
INSERT INTO nii_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sinim wumb Parsiya ni konu Miriya ni Eilam, Mesoposemiya konu sinim wumb konu orung orung wumb, Juriya ni Kaparosiya, ni Ponsas ni Eisiya wumb mołmun. ");
INSERT INTO nii_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Prisiya ni Pampiliya, Eisip ni, wumb orung orung Aprika konu Sairiini, ni sin Rom wumb ya ełe pei ya ełe mołmun. ");
INSERT INTO nii_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Wumb Griis ni Areipiya ni sinim Jura wumb ni wumb tiłap eipi ei sinim Jura ełmin oł ei enmin. Ba sinim wumb pei sin sinim ek piimin; Gos nge jep oł pei nipi sinim ek ełe nipi ngołum.” ");
INSERT INTO nii_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pe puku sik, noman embin tang mulnjung. En enim ek dinga nik piik enjing. “Epi nimbił oł enim?” ");
INSERT INTO nii_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ba wumb kombur en enim ek buł morung nik ek dinga ninjing, “En enim noł nok wulu pang kin, ek eipi eipi ninmin,” pa ninjing. ");
INSERT INTO nii_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pe Piisa engki nga endeim mulnjung konu ełe tuk angpi wii dinga topu ek dinga nipi wumb ngum. “Enim Jura wumb ni wumb ok Jerusalem konu wumb ok mołmun; enim kom sek, oł enim ei ni ngamb piingii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","“Enim wumb ombu noł nok wulu punum ni piinmin ba mon; akip konu kupiiring eni pim. ");
INSERT INTO nii_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ba oł ei Gos nge ermba oł ei piipi niłim wu Joel yi ninim. ");
INSERT INTO nii_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Gos ek yi nim, ekii se poru nimba kunum mandi erang Gos Gui Ka wumb pei ngamb eim Gos pei ngumbii,’ pa yi nim. ‘Pe enim kingenjing embiłenjing ni Gos oł ekii se ermba ei piik niłmin wumb ek tangiłmin mił yi tengingii. Noman ka wii enim wu kangi wu mułngii konu andan tumbii, or kumb mił er keningii. Pe wu tukui ombu piingii konu or kumb ka andan tamb keningii, pa nim. ");
INSERT INTO nii_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","‘Kunum ei enim wu amb kongun wumb na Gui Ka pei ngumbii ku. Ngamb kin Gos oł ekii se ermba ei piik niłmin wumb ei ek niłmin mił ningii. ");
INSERT INTO nii_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pe na tonu kupu muł ełe jep oł eipi mił kombur ermbii. Mani mei ełe na miyem ni dup ni, dup eskił owundu ni jep oł ermbii,’ nim. ");
INSERT INTO nii_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","‘Eni kunum ei eramb emii pimba; pe oi ei eramb, miyem mił ermba. Pe ekii se Jiisas orung omba kunum ei tangpi tiłang owundu ermba,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","‘Pe wumb pei Gos embe pii gii nik wii tungii wumb ei sipi orung seng kin, Gos eim nge wumb mułngii. Gos ermba oł piipi niłim wu Joel,’ yi ninim. ");
INSERT INTO nii_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Enim Esrel wumb, enim ek ei piingii: na enim Jiisas Naseres wu nge nip ngumbii end. En enim kaninmin, oł dinga ni kongun erpi jep oł kanim kanim enim oł ombu enim piik kanik ełmin ei, Gos eim mendpił wu ei Jiisas kindang om. ");
INSERT INTO nii_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wu ei Jiisas kumb ok epi pei Gos Eim piipi ek nipi pendrim. Pe wu ei enim angił ełe kindim. Enim Jura wumb ek kis nik enjing. Nimbił erang tor wumb ei Jiisas ond peri ełe nil to kundnjung? ");
INSERT INTO nii_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ba Gos eim Jiisas nga er konj sim. Eim ngenj kumbii kułpu erim ei Gos eim kulnjung wumb konu ełe si kindpi nga er konj sim. ");
INSERT INTO nii_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ok Deipis yi mił pułum, Jiisas ek dinga nirim, ‘Gos Owundu na kumb ełe kunum kunum mołum. Eim nam angił tundung orung mułang kin na epi endi kapłi to mani kindnermba mon! ");
INSERT INTO nii_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yi erang kin, na noman ka seng, gupu tokuł pałim. Nam piind ei nam ngenj ei epi ekii se omba nip moł. (Ba Gos kin pii gii nip moł). Yi mił ku epi endi nam ngenj ei kapłi ambił gii ninermba. ");
INSERT INTO nii_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pe na noman tuk ei pang, Gos eim dinga ełe na paki tang, wumb kułii konu mulermba mon. Pe nim nge kinganim mendpił eim ngenj purnermba mon! ");
INSERT INTO nii_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nim na noman konj bii andłam ełe andan to kun erngii. Nim na kin mułun na ka piip minj mułmbii,’ Deipis ek yi nim. ");
INSERT INTO nii_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Engnan noł na sinim kupenjpin Deipis multum mił nip kun kun ermbii end. Deipis eim kultum tukpu tuk, tuk ei akip sinim mołmun konu ya sałim. ");
INSERT INTO nii_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ba Deipis eim Gos ekii se ermba oł ei piiłim ku. Gos ek dinga nipi yi nim, ‘King Deipis kinganim ekii se nim peł mołun konu ełe mułmba,’ nim. ");
INSERT INTO nii_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ba kumb ok Deipis eim Gos ermba epi ei kan poru nirim. Pe yi nirim, Krais Owundu wu ekii se omba wu ei, nga konj tonu orung omba nirim. ‘Gos eim wumb kułii konu wak tunenmba. Eim ngenj purpu kumun ngunermba ku.’ ");
INSERT INTO nii_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jiisas wu ei, Gos eim sipi orung nga konj sim. Sin wumb pei ei kanpin kin ninmin. ");
INSERT INTO nii_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pe Jiisas eim angpi tonu pupu Gos Jiisas eim angił tundung wu Owundu mundum. Pe ei Gos Gui Ka sim. Ei ok Gos nirim mił yi erang kin akip Gos Gui Ka pei ngang, sinim wumb sipin kin sin ek eipi eipi ninmin ei enim kanik piik enmin. ");
INSERT INTO nii_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Deipis eim ngenj ei epin konu tonu punerim. Ba ei ek nipi pułum. Gos Owundu ek nipi nam wu num ei ekii se omba. Yi mił nipi ngum, ‘Nim na angił tundung orung mulnjii. ");
INSERT INTO nii_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Pe ekii se nim opu orung wumb ei na to mani kindmbii mendpił. Sip, nim simb ełe mandring kindmbii.’ ");
INSERT INTO nii_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Pe sinim Esrel wumb tiłap pei sinim ek ei pii kun er mułmun. Pe Jiisas ei sinim sipin ond peri ełe tonu kindpin, ei Gos eim sipi Krais wu Owundu ekii se omba ei mundang mołum!” Piisa ek yi nim. ");
INSERT INTO nii_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wumb en enim ek ei piinjing noman ełe embin tum. Piisa kin wu kombur kin kan yi ninjing, “Enginjpin noł, sin nimbił oł ermin?” ");
INSERT INTO nii_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pe Piisa ek nipi wumb ngum, “Enim noman ak tok ok Jiisas Krais embe ełe noł pingii, ei Jiisas enim noman kis kil ngumba. Enim yi erangin kin Gos nge Gui Ka enim kin wii ngumba. ");
INSERT INTO nii_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ok Gos ek dinga yi nipi pendim. Enim kin en enim kangił ni wumb konu turii mołmun wumb pei ngumbii nirim mił Gos Owundu wumb ei wii tang, onjung. Wumb ei Gos eim ek dinga nipi ngum.” ");
INSERT INTO nii_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piisa ek nga endi nipi tuk kindim; ek pei dinga nipi ngum, “Enim piik kun er mułngii; mon pim kin, enim wumb oł kis enmin wumb ei kin pei poru nimba.” ");
INSERT INTO nii_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yi neng kin, wumb pei Piisa ek nim mił pii gii nik noł pinjing. Pe kunum ełe wumb 3,000 pei Jiisas kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Gos nge ek se andiłmin wumb ei ek ninjing. Wumb ei dinga piinjing ei engnjing noł paki tok, kuni ende nok, prei erik enjing. ");
INSERT INTO nii_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Pe wumb pei puku sik Gos jep oł pei eim nge ek se andiłmin wumb kin erim. ");
INSERT INTO nii_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Wumb pei Jiisas kin pii gii ninjing, wumb ei ende mulnjung. Pe epi sałim min simba ei pii gii wumb epi ende sałim. ");
INSERT INTO nii_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Wumb ei en enim epi ni, mei ni, wumb ok top to sengin, ku ni epi ei sik, wumb eipi epi sinerang mołmun wumb ei ngunjung. ");
INSERT INTO nii_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Wumb en enim noman ende sek, ka piik enjing. Kunum kunum en enim men ngii owundu engim konu puk puk ełmin. En enim kuni ngii eipi eipi ełe ende nok nok ełmin. ");
INSERT INTO nii_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kunum kunum Gos embe ambilk tonu kindik, Jerusalem wumb yi piinjing. Wumb pii gii wumb, en enim noman tuk ka seng mołmun. Kunum kunum Gos eim wumb kopur sipi orung sipi erang, wumb Jiisas kin pii gii nik enjing wumb ei pei pei orung sim. ");
INSERT INTO nii_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Piisa Jon teł tonu men ngii owundu prei ermbił ni punjnguł. Kunum ei konu eni tekliki erang punjnguł. ");
INSERT INTO nii_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Wu endi mułum, wu ei ok mam mengrim kunum ei simb yi er pirim mił pim. Wu ei tu wuk men ngii owundu ełe, ondu embe, “Ka wii ełe mundangin,” kunum kunum mołpu, wumb ongii kom ku kenim nipi, er mułmba nik mundangin mołułum. ");
INSERT INTO nii_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wu ei mołpu kenim ni Piisa kin Jon teł men ngii owundu ełe nirik punguł nge onjnguł. Wu ei ek nipi wu tał ngopu yi nim, “Epi endi na ngeł,” nim. ");
INSERT INTO nii_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piisa kin Jon kin wu ni dinga kenjingił. Piisa ek nim, “Nim ya sił kenjii!” ");
INSERT INTO nii_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Pe eim kan ak topu kenim ni, wu tał epi endi na ngunguł ni piim. ");
INSERT INTO nii_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ba Piisa ek yi nim, “Na ku pinałim. Ba na pałim epi ei ni ngumbii. Naseres konu, Jiisas embe ełe na nind, ‘Nim angkin po!’” ");
INSERT INTO nii_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piisa angił tundung orung wu ni ambił tonu sim. Wu ni Jiisas dinga sipi, simb si kun er engim. ");
INSERT INTO nii_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Wu ni puku sipi angpi pum. Pe wu tał kin men ngii nirik punjung; wu ni men ngii owundu pupu, puku sipi er andpi Gos embe ambił tonu kindim. ");
INSERT INTO nii_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Wumb pei mulk kenjing ni wu ei andpi Gos embe ambił tonu kindpi endim. ");
INSERT INTO nii_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wumb piinjing wu endi men ngii owundu ondu ka wii ełe mołpu, ku ni epi ngei nipi, kenim ni mołułum, ei wumb kenjing ni wu ei keimi mułum, kanik puku sik oł erim pułe pii poł tunenjing. ");
INSERT INTO nii_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wu ei Piisa kin Jon teł punjnguł konu ekii se pum. Pe wu amb pei sikir ok Solomon palting men ngii owundu palting endi konu andaring ełe onjung. ");
INSERT INTO nii_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piisa ei kanpi ek dinga nipi wumb ngum, “Enim Esrel wumb nimbił erang, enim oł ei noman embin to piinmin? Nimbił erang sił kin kanik enmin? Enim yi ni piinmin, sił nge dinga ełe ni sił oł ka ełmbił ełe nge wu ei erambił opu andpi punum ni piingii? Ei mon!” ");
INSERT INTO nii_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Eiparam ni, Aisak ni, Jeikop ei, Gos sinim ok sinim kupenjpin noł Gos ei, eim kongun wu Jiisas eim ambił tonu kindmin. Wu ei enim sik opu orung wumb ngunjung. Ba wu num owundu Pailos si kindmbii ni piim; ba enim wumb dinga puk mon nik eim kin buł ngunjung. ");
INSERT INTO nii_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Enim wu ei oł kis endi enarpi wii kun ka multum, wu ei Jiisas Gos kingam mendpił buł ngok, yi nik, wu endi wumb to kundum wu ni piimba, ei kindangin kin, sin kin wangłi nik. ");
INSERT INTO nii_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jiisas Gos kingam mendpił ei sinim wumb sipi noman konj ngołum. Wu ei enim to kundnjung, ba Gos nga er konj sim. Pe sił mołpuł kenjpił, ek ei ni tor kindmbił nge mołmbuł. ");
INSERT INTO nii_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sił Jiisas kin pii gii nembił kin Jiisas enim. Jiisas dinga ełe yi wu ka ełim. Enim kanik piinmin ei Jiisas eim sił pii gii ełe nge erpi, enim wumb pei ningił ełe enim. ");
INSERT INTO nii_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Keimi na piind engnan noł enim kin wumb owundu kin pii kun enarik kin Jiisas to kundjung. ");
INSERT INTO nii_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ba kumb ok Gos eim nge ek keimi niłmin wumb ek yi nik, Gos eim nge kingam Krais ngenj kumbii kułpu kułmba nirim. Pe akip enim wumb oł kis enmin ei, ek ni tor kindiłmin wumb ninjing opu peni ełe keimi punum. ");
INSERT INTO nii_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pe enim piik kin noman ak tunjung kin, kapłi Gos eim enim oł kis ombu kil ngopu poru nimba. ");
INSERT INTO nii_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","21","Yi enjing kin Gos enim kin tep mułmba. Pe Gos enim noman tuk dinga ngang, ka piik mułngii. Gos ok ek dinga nirim, ‘Na Krais King Owundu enim kin kindmbii.’ Gos eim wu owundu ei sinim kin kindmba, wu ei embe Jiisas. Pe epin konu Jiisas er mołum. Kunum ei Gos epi pei konj nga ermba mił ok eim ek keimi niłmin wumb en enim gupu ełe niłmin. Kunum ełe Gos Jiisas mei ełe mani nga kindang eim oł ei ermba. ");
INSERT INTO nii_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","23","Moses ek yi nirim, ‘Owundu ei enim Gos, pe enim engnjing sipi, Gos eim ek keimi niłmin wu ei, nam mił yi mułmba. Enim eim ek nimba mił piingii. Piik, nimba mił erngii. Pe wumb pei ek keimi niłim wu mił nimba ei piinerngii wumb ei Gos wumb top kundmba. Pe wumb ei Gos nge wumb nga mulerngii, Gos yi neng,’ Moses piipi nirim. ");
INSERT INTO nii_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gos ek ni tor kindiłmin wumb ok yi nik, Samyuel kin Gos ek niłmin wumb ekii se tonu onjung. Pei yi ninjing, ‘Kunum ei akip sałim kunum ei,’ pa ninjing. ");
INSERT INTO nii_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Enim Gos nge ek keimi niłmin wumb ei nge kingenjing mił mułngii. Enim nge kupenjing noł Gos ek dinga nipi pendrim mił sił mułngii. Gos Eiparam kanpi ek dinga nipi ngurum. ‘Nim nge tiłap ełe wumb tiłap pei na kengip ek ka nip ngumbii.’ ");
INSERT INTO nii_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gos eim nge kongun wu Jiisas er mundum. Pe kindang enim mulnjung konu ok om. Opu, enim Gos ek ka kengip top nipi ngumba nge om. Nimbił erang eim enim oł kis ombu kil ngumba nge om.” ");
INSERT INTO nii_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","3","Wu tał wumb kankił, ek nikił mulnjunguł; pe men ngii owundu ełe wu tał wumb kankił ek yi mił ninjngił, Jiisas angpi tonu konj nga om. Pe yi ku wumb kulnjung wumb ei angk tonu ongii. Yi nengił, kułmał kałiłim owundu kin, men ngii tep ełim wu owundu kin, wumb kolk nga konj punałmin ni, piiłmin wumb ombu ok, mon ek piik kis piinjing. Pe emii peng wu tał ambił gii nik, kan ngunjung. “Kupiiring ełip kos piimin,” ninjing. ");
INSERT INTO nii_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ba wumb pei ek ei piik, pii gii ninjing. Pe wumb pii gii nengin kin, wumb pei ei yi mił 5,000 wumb mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Topuł Jura wumb owundu ni, men ngii kongun wumb ni, lo andan tołmun wumb ni, Jerusalem konu kułou tumun ninjing. Men ngii ełe mołułmun wumb ei Anas ni Kaiyapas ni Jon ni Eliksander ni kułmał kałiłim owundu, eim nge wumb pei, kułou tunjung. ");
INSERT INTO nii_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Gos nge ek se andiłmbił wu tał en enim kumb ełe engnjingił. Angkił, wu tał kii sinjing, “Ełip dinga nipe ełip embe nii nge ełe oł ei enjngił?” ");
INSERT INTO nii_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Gos Gui Ka Piisa kin piki top mułum; pe eim ek yi nipi ngum, “Enim Esrel wu owundu ni men ngii kongun ełmin wumb. Enim sił wu endi simb kis mułang, paki topuł enjpił ni, sił kin ek ningii enmin min? Wu ei er ka mułum mił nenj ei enim piinmin min? ");
INSERT INTO nii_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Yi erpi nim kin enim pei piyangin, enim Esrel wumb ei pei piingii ku. Jiisas Krais Naseres konu wu, eim embe ełe wu ei ka mołum. Mołpu, yi enim kumb ełe mołum. Enim Jiisas ond peri ełe to kundnjung, ba Gos eim Jiisas nga er konj seng opu konj pum. ");
INSERT INTO nii_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ond tumunj endi enim ngii takiłmin wumb si kindnjing ei nimbił erang enim konu ełe kindngii ni piinenjing. Jiisas eim ond tumunj ei mił mołang kin Jiisas eim ngii tumunj mendpił mił mołum. Eim ngii takiłmin wumb si kindnjing. ");
INSERT INTO nii_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wu eipi endi sinim kapłi paki tunermba mon! Ei Gos sinim wu endi eipi andan topu ngunanim. Jiisas endeim sinim sipi orung simba. ");
INSERT INTO nii_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wumb kenjing ni Piisa kin Jon teł ek dinga nikił, dinga pu mulnjunguł. Wu tał wumb kin mund mong kulenjngił. Yi piinjing ek mon ngii punałmbił ni piinjing. Wu tał mulnjunguł yi piik kin noman pei piinjing ei ok wu tał ełe Jiisas kin tep to mulnjunguł ni piinjing. ");
INSERT INTO nii_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pe wu ei kenjing, ni wu ei ka mołpu, wu tał kin angpi mułum ei, wumb en enim kenjing. Pe ek nik wu tał ngungii ek endi pinerim. ");
INSERT INTO nii_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Wu tał kaunsil ngii si kindkił tor peł ninjing. Wu tał pangił mił, en enim ek nik piinjing. ");
INSERT INTO nii_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Pe sinim wu tał kin nimbił oł ermin? Wu tał jep oł endeim erangił kin, wumb Jerusalem wumb pei kenjing. Pe ei sinim kapłi koi ermin mił mon. ");
INSERT INTO nii_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ba mon pim kin, ek ei wumb konu pei pang piingii. Yi ermba ei piikił kin wu tał kin ek dinga nimin. Pe wu tał nga Jiisas embe ełe nikił wumb eipi ngunerngił.” ");
INSERT INTO nii_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Pe wu tał wii to orung sik yi ninjing, “Ełip nga ek endi Jiisas embe ełe nikił enerngił mon!” ninjing. ");
INSERT INTO nii_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ba Piisa kin Jon teł nikił orung kindinjngił. Pe sił Gos ek si kindpił enim ek ningii mił piimbił. Ei Gos kumb ełe kapłi ermba min? Ei enim piingii. ");
INSERT INTO nii_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ba wu tał yi ninjngił, ‘Sił gupu pandi tumbuł mił mon. Epi kanpił ek piipił enjpił mił ei, wumb kanpił nimbił ni piinjngił. ");
INSERT INTO nii_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pe kaunsil wumb ek dinga endi nik wu tał ngunjung. Wu tał si kindkił punjnguł. Pangił, kaunsil wumb andłam endi kurpun, wu tał kan ngumun, ni piik enjing. Nimbił erang wumb pei Gos eim embe ambilk tonu kindangin kin, kaunsil wumb wu tał kan ngumun nik enjing kapłi enerim. ");
INSERT INTO nii_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Wu ei wu tał, Gos jep oł erangił opu konj pum wu ei, kung ngii 40 pei mołum. ");
INSERT INTO nii_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wu tał eł ełip wumb puł kombur kin punjnguł. Pukuł, wumb ei kankił kułmał kałiłim owundu, ni tep ełmin wumb ombu ek ninjing mił wumb kan ninjngił. ");
INSERT INTO nii_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ek ei piik poru ni pendik, en enim noman ende kindik prei yi mił enjing. “Gos Owundu nim ei epin en, ya mani mei en, pe ep noł en, ei pei nim er sin. ");
INSERT INTO nii_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Gos Gui Ka je sin erinjpin Deipis ek gupu ełe tor orum. ‘Ei Gos nim nge kongun wu, Gui Ka ek nirim. Nimbił erang wumb tiłap eipi ei popuł sinmin. Pe wumb tiłap ek yi ninjing. Sin epi owundu eramin piingii nik piinjing; ba ei kapłi enerngii. ");
INSERT INTO nii_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Pe King pei konu orung pei kui er molk opu ermin ninjing. Pe wumb tep ełmin wumb owundu kułou tok Gos Owundu to mani kindmin ninmin. Eim kingam Krais eim ekii se omba wu ei to mani kindmin nimin.’ ");
INSERT INTO nii_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Keimi mendpił konu owundu ełe, ya Eros ni Pailos ni wumb eipi ni Esrel wumb pei kułou tok Gos nim nge kongun wu ka wii, nim Krais ok kindan eim ya mani om. ");
INSERT INTO nii_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","En enim kułou owundu tok, ek nik pendik, ek ei dinga pimba ni Jiisas ok yi nirim mił yi erik. ");
INSERT INTO nii_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O wu owundu, nim piin wumb nim kin ek dinga ninmin. Ninim sin kongun wu mołmun ei paki tan, sin nim ek ei sin dinga kindpin ni tor kindmin. Kindpin, sin mund mong piinermin mon! ");
INSERT INTO nii_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nim angił to kindan ening pimba wumb ei ka mułngii. Jiisas nge embe ełe jep oł enjii. Nim nge kongun wu ka wii Jiisas.” ");
INSERT INTO nii_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Prei er poru nengin kin ngii mulnjung ngii ei ołup erim. Pe Gui Ka en enim kin tuk opu piki to poru nim. Pe Gos embe ambilk tonu kindik Gos ek dinga nik, wumb kin mund mong piinenjing. ");
INSERT INTO nii_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pii gii wumb en enim noman ende sinjing. En enim ek endeim minj piik mulnjung. Wu endi epi eipi simba, ei na epi mendpił ninermba mon; epi sinim epi ende. ");
INSERT INTO nii_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jiisas nge ek se andiłmin wumb ei, Jiisas nga konj tonu pum nik, ek ei ninjing. En enim ek ninjing, ek ei dinga pim. Pii gii ninjing wumb ei Gos nge noman ka mołpu poru nim. ");
INSERT INTO nii_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Enim mołmun konu wu endi kuni ni epi sinerang, ka mułmba wu ei wumb pei mei sep ngii mołangin wumb, ei epi wumb eipi ngok, ku siłmin, ku ei tu wunjung wunjung. ");
INSERT INTO nii_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tu wangin kin, ku ei sipik, Jiisas nge ek se andiłmin wumb simb ełe kindnjing. Pe Jiisas nge ek se andiłim wu ei sik kanik, wumb kuni sinarpi ełim wumb kanik mok tok ngołmun. ");
INSERT INTO nii_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pe wu endi Saipris konu mułum wu ei embe Josep. Eim Liiwai wu endi, Gos nge ek se andiłmin wumb, eim embe eipi endi ngunjung ei embe Banapas ninjing. Embe ei nge pułe yi, wumb noman tuk paki tołum wu. ");
INSERT INTO nii_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Wu ei eim, wu eipi endi, eim mei ei top erim ku ei tu wupu kin, Gos nge ek se andiłmin wumb mulnjung simb ełe kindim. ");
INSERT INTO nii_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ba wu endi mułum wu ei embe Ananaiyas, ambim nge embe Sapaira. Ananaiyas eim mei orung ei wu eipi ngopu ku sim. ");
INSERT INTO nii_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Pe ku sirim ku aninga ei nge ambiłpi wiik top se mułum. Eim ambim ei piipi mułum. Ananaiyas eim ku orung sipi tu wum. Tu wupu, Gos nge ek se andiłmin wumb mulnjung konu simb ełe sim. ");
INSERT INTO nii_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pe Piisa ek nim, “Nimbił erang Seisen nim noman kin piki topu mołum. Pe nim Gui Ka kin ek kend to pendkin, mei ku orung sin ku ei orung tu wun pałim. ");
INSERT INTO nii_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ok wumb mei top enenjing kunum ei, mei ei nim nge, ba mei top er poru nengin, pe ku ei nim nge sim. Nimbił erang nim noman yi mił pałim. Nim wumb kankin ek kend ton ni piin ei mon; nim Gos kin ek kend to ngon.” ");
INSERT INTO nii_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaiyas ek ei piipi, mani pupu, bok topu kułum. Pe wumb ek ei piik, mund mong kulnjung. ");
INSERT INTO nii_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Pe wu kangi wu ok, wu ei alap pandi to sipik, kui tunjung. ");
INSERT INTO nii_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ekii se eni tekliki o pang, Ananaiyas ambim opu tor om. Ba oł yi eim piinenim. ");
INSERT INTO nii_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pe Piisa ek nipi amb ei ngum, “Nimbił oł en? Ełip mei ku sinjngił kapłi yi mił enim min mon?” Pe amb ek nim, “Ei keimi nin. Yi mił sił sinjpił.” ");
INSERT INTO nii_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piisa ek nga nipi ngum, “Nimbił erang ełip ek ni endi kind pendkił Gos Gui Ka enim mił ei kenmbił ni enjngił? Nim nge wanim wumb sik kui tungii sipnjing wumb ei ok ngii ondu ełe mołmun. En enim pe nim sipngii ku.” ");
INSERT INTO nii_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pe nga sikir amb ni, Piisa simb ełe mani opu bok topu kołpu pim. Ba wu kangi wu ombu nirik onjung. Ok, kenjing ni amb ei kołpu pim. Ok, sipik wam pim konu mandi eim kui tunjung. ");
INSERT INTO nii_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pe Gos nge pii gii wumb konu orung orung ei mulnjung wumb ei, mund mong kulk mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Gos nge ek se andiłmin wumb, jep oł kanim kanim wumb pei mulnjung konu tuk enjing. Pe pii gii niłmin wumb en enim, men ngii owundu andaring Solomon nge palting ełe ek nik kułou to mołułmun. ");
INSERT INTO nii_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pe tor wumb mund mong kulk ok ende mulenjing. Pe wu amb en enim pii gii wumb Gos embe ambilk tonu kindnjing. ");
INSERT INTO nii_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wumb pei Jiisas kin pii gii ninjing. Pe Jiisas nge tiłap ełe wumb pei tuk onjung. ");
INSERT INTO nii_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Wumb enim kis erim wumb ei, tu wuk andłam ełe pendnjing. Pe peł kanim kanim tu wuk pendnjing. Pendik, yi ni piinjing, eni tang, Piisa opu kin, eim min men ei wumb to tingndang wumb ombu ka mułngii ni piinjing. ");
INSERT INTO nii_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Wumb konu orung orung wumb, kin Jerusalem wumb orung pei mulnjung wumb, pei ok kułou tunjung. Wumb ei ok mił, ening pim wumb tu wunjung. Pe gui kis tuk mułum wumb kombur tu wunjung wumb ombu pei ka molk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kułmał kałiłim wu owundu ni, eim nge wumb ni wumb kolk nga konj angk piinałmin wumb ni pei wumb ei Jiisas nge ek se andiłmin wumb kin noman kis piinjing. ");
INSERT INTO nii_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Pe wumb ombu ok Gos nge ek se andiłmin wumb sik, er kan ngii kindnjing. ");
INSERT INTO nii_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Ba epin emii peng, Gos eim enjel kindang opu, kan ngii owundu aki topu, wu ombu si tor tu wum. Tu wupu yi nim, “Enim puk, nirik men ngii owundu ełe puk, pe noman konj ek onum ek ei wumb kanik ningii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Gos nge ek se andiłmin wumb ek ei piik pendik punjung. Kupiiring okrii puk men ngii owundu ełe wumb ek ni wumb ngunjung. Kułmał kałiłim wu owundu ni ei wu kombur kin onjung. Ok kaunsil ni Esrel wumb noman pim wumb kin kułou tunjung. Tok, ek nik kan ngii kindik, Gos nge ek se andiłmin wu ombu kindangin, wangin ninjing. ");
INSERT INTO nii_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pe kan ngii ełe tep mołułmun wumb puk kan ngii ełe kenjing ni, Gos nge ek se andiłmin wumb mulenjing. Kanik, puk ek yi ninjing. ");
INSERT INTO nii_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Sin kan ngii ełe kenjpin ni ngii ondu dinga ngo pendnjing. Nga kan ngii tep wumb ngii ondu ełe angk mulnjung. Pe sin kan ngii aki topun, kenjpin ni wumb endi nirik mulenjing.” ");
INSERT INTO nii_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Men ngii owundu ełe tep mołułum wu owundu ni kułmał kałiłim wu owundu ni wumb ek ei piik noman embin to piinjing. Piik yi ninjing, “Pe nga nimbił oł ermba,” ninjing. ");
INSERT INTO nii_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pe wu endi opu yi nim, “Enim wu kombur kan ngii kindnjing, wu ombu puk mer men ngii owundu ełe wumb kanik Jiisas ek nik ngok mołmun,” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kan ngii tep ełim wu ni eim wu kombur ni puk, wu ombu simin ni punjung. Puk, wu ombu kepii tunenjing. En enim mund mong kulnjung, wumb ok ku sik tungii ni piinjing. ");
INSERT INTO nii_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","28","Pe wu ombu tu wuk kaunsil wumb mulnjung konu tuk ełe engindnjing. Pe kułmał kałiłim wu owundu ek dinga nim. “Sin enim kanpin mon ninjpin, enim wumb kanik Jiisas embe ei nge nik wumb ngunerei mon ninjpin. Pe enim wumb Jerusalem konu wumb enim ek ei nge pei mołmun. Enim ek nik, sin wu ei to kundunjpun,” ninmin. “Gos sin kin ekii se kos piimba.” ");
INSERT INTO nii_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ba Piisa kin Gos ek se andiłmin wu pei ek dinga ninjing. “Sin Gos nge ek ei piimin, wu ek ei piinermin mon!” pa ninjpin. ");
INSERT INTO nii_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","“Enim Jiisas ond peri ełe to kundnjung. Ba sinim ok kupenjpin noł nge Gos opu Jiisas erpi konj sim. ");
INSERT INTO nii_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Gos eim si mengpi sipi, eim angił tundung orung mundang mołum. Pe eim sinim nge wu owundu mołpu, sinim paki top mołum. Pe Esrel wumb noman to ak topu sinim oł kis ombu kil ngopu erpi pum mołum. ");
INSERT INTO nii_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sin wu ombu epi pei mołum, ei nge kenjpin ni tor kindpin onmun. Pe Gos nge Gui Ka ek yi ninim. Gos eim ek piik pii gii ninmin wumb ei Gos Gui Ka wumb ombu ngonum.” ");
INSERT INTO nii_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pe wu owundu ombu ek ei piik, noman kis peng kin, Jiisas nge ek se andiłmin wumb to kundmun, ni piik enjing. ");
INSERT INTO nii_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pe kaunsil konu lo ek piiłmin wu endi engim. Wu ei eim lo ek piiłim wu num, wu ei embe Gameliyel. Eim wumb lo ek nipi ngang wumb eim embe ambił tonu kindiłmin. Wu ei yi nim, “Jiisas nge wumb ei anda kindangin pangin,” nim. ");
INSERT INTO nii_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Eim ek nipi kaunsil wumb ngum, “Enim Esrel wumb, pe enim oł endi ya wu ombu ermin ni enjing kin, enim Esrel wumb, en enim pii kun erik erngii,” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","“Enim piinmin! Ok wu endi multum. Embe ei Tiyuras eim yi nim, ‘Na, nam noman dinga pałim.’ Yi neng kin, wumb 400 eim ek ekii sinjing. Ba wumb eim to kundnjung. Pe eim ekii sinjing wumb tungu punjung. En enim kongun ei wii mił enjing. ");
INSERT INTO nii_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ekii se gapman wumb embe pułang Galilii wu Juras eim wumb kombur nipi sim. Wumb ei Juras nim ek ei puk gapman wumb kin opu erpin tumun ninjing. Ba eim yi ku kułum. Kułang, wumb eim kin ekii sinjing wumb, ei tungu eipi eipi puk poru ninjing. ");
INSERT INTO nii_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yi ku akip na enim kanip nind. Enim Jiisas ek se andiłmin wumb ombu nge kanik tungu erngii. Erik, kan wiik to mułngii. Pe wu endi eim kongun ei puł pendip ermbii ni ermba. Wumb ombu ek ei keimi punermba mon nik. ");
INSERT INTO nii_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Gos eim kongun ełe nge puł wu pim kin, enim andłam ondu ngunerngii. Ondu ngunenjing kin enim Gos kin opu erngii.” ");
INSERT INTO nii_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yi neng kin, eim nim ek ei piinjing; Gos ek se andiłmin wu ombu wangin tunjung. Enim Jiisas ek se andiłmin wu ombu wangin kepii tunjung. Tok, ek yi ninjing, “Enim nga Jiisas embe ełe nik enerngii mon!” ek dinga nik ninjing. Nik, si kindangin punjung. ");
INSERT INTO nii_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Pe Jiisas ek se andiłmin wu ombu kaunsil ni wumb mulnjung si kindik, anda punjung. Puk yi piinjing, Gos yi nipi piim, “Sinim wumb owundu mił mołmun ni, Gos sinim to tonu kind mundum. Nimbił erang, Jiisas nge embe ełe sinim singambił piinmin.” ");
INSERT INTO nii_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kunum kunum men ngii owundu ełe ni en enim ngii konu ei, wumb kanik Gos ek nik ngok er mulnjung. Ek yi ninjing, “Jiisas wu ei ekii se omba, wu ei eim ek poł ka wii ei si kindnenjing, kongun er andik nik minj mulnjung.” ");
INSERT INTO nii_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kunum nga Jiisas nge wumb pei tonu onjung. Wumb Jiisas nge wumb Griik ek niłmin wumb ei Eipru wumb ek niłmin wumb ei kin kis piinjing. Yi niłmin, “Wumb kombur kuni ni epi sinerim wumb ei kunum kunum paki tołmun. Ba sin amb enim paki tunanmin. Amb wenjing kulnjung amb ombu sinim paki tunanmin.” ");
INSERT INTO nii_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Yi erangin kin, Jiisas nge ek se andiłmin wu engki nga tał molk Gos nge wumb pei wii tok, “Wei!” ninjing. “Pe sin Gos nge ek ni ngołmun ei si kindpin kuni mok to mulnjupun kin ei kapłi enermba mon. ");
INSERT INTO nii_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ba engnan noł enim wu angił orung nga tał kurngii. Wu ombu en enim embe ka peng, wumb Gos ek piik erangin, en enim Gos Gui Ka tuk ełe mułang wumb ei ni Gos Gui Ka wumb ei kin mułngii. Wumb ei ni peng ka pepi ermba wu ei, sin to tonu kindamin sinim kongun ei tep erngii. ");
INSERT INTO nii_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Pe sinim kunum kunum prei erpin Gos ek nipin, wu amb ngopun mołmun.” ");
INSERT INTO nii_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pe wumb pei ek ei piimin ni, ka piinjing. Pe wumb nik tonu kindangin Siipen ni wu ei pii gii wu dinga wii, Gui Ka eim kin piki to mułum. Pe Pilip to tonu kindnjing. Prokoras ni Nikanor, ni Taimon, ni Parmenas, ni Nikolas. Nikolas eim tiłap eipi Andiyok konu wu, ba ok Jura wumb tiłap ełe tuk orum. ");
INSERT INTO nii_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Pe wu ombu Jiisas nge ek se andiłmin wumb kumb ełe engnjing. Pe Jiisas nge ek se andiłmin wu prei erik angił tonu kindik enjing. ");
INSERT INTO nii_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Pe Jiisas ek ei pang wumb pei piinjing. Pe wumb pei Jiisas nge wumb Jerusalem konu mulnjung. Jiisas kin kułmał kałiłmin wumb ei pei pii gii ninjing ku. ");
INSERT INTO nii_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Siipen eim Gos nge noman ka nipi eim wu dinga mułum. Pe eim jep oł pe wumb kin mołmun konu tuk ełim. ");
INSERT INTO nii_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pe wumb ok Siipen kin ek opu er nik. Wumb men ngii endi engim. Wumb ombu ngii takik ei Jura konu tuk ełe tekik. Ek ei men ngii ełe nge “Priiman,” pa niłmin. Pe Jura wumb kombur konu Sariiniya ni Aleksandriya ni Silisiya, Eisiya konu wumb onjung kin Siipen ek opu er ninjing. ");
INSERT INTO nii_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Gos Gui Ka Siipen mułum konu noman ka ngum. Yi erang kin, wumb wii eim ek to mani kindngii ba pinerim. ");
INSERT INTO nii_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Pe wumb ek kend tok erangin, wumb eipi kombur ek ni piik punjung. Pe wumb ombu yi ninjing, “Sin piinjpin. Eim Moses kin Gos teł ek ei nipi kis erim.” ");
INSERT INTO nii_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Wumb ei ok, wu amb mulnjung konu kend tok nik, wu lo ek pułmun wumb ni men ngii kongun wumb ei kanik nik, pei mulnjung konu kanik ek kend tok ninjing. Nik puk, Siipen ambił gii nik sipik, kos ngii konu sipnjing. ");
INSERT INTO nii_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Enim wu kombur kindangin kin andik angk eim kin ek kend tok ninjing wumb ombu yi nik. “Kunum kunum wu ei eim ek kis nipi ya Gos ngii konu ełe nipi lo ek nipi ełim ku. ");
INSERT INTO nii_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sin piinjpin eim yi nim, ‘Jiisas Naseres eim konu ełe kis mondpu, Moses oł ok nirim ek ei topu eipi kindpi ermba,’” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Wumb pei kaunsil ngii mulnjung wumb ei, pei wu ei minj kenjing. Pe wumb kanik mulnjung ni Siipen kumb ningił ei Gos wu sinim tep ełim wu kumb ningił yi mił nge sim. ");
INSERT INTO nii_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pe kułmał kałiłim wu owundu ei yi nim, “Ek ei keimi min?” ");
INSERT INTO nii_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Siipen yi nim, “Erinjpin noł ni engnan noł, enim piyei! Ok sinim kupenjpin Eiparam eim Mesoposemiya konu owundu multum. Eran konu puneririm kunum ełe Gos eim nge tiłang ka wii ełe Eiparam kin tor om. ");
INSERT INTO nii_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Pe yi nim, ‘Nim mei konu ni angnim noł si kindnjii. Pe nim pan, na mei endi nim andan to ngumbii,’ nirim. ");
INSERT INTO nii_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Pe Eiparam eim Kaltiya konu si kindpi, Eran konu pupu mułum. Pe ekii se eim arim kułum. Kułang, Gos eim kindang opu, ya mei ełe mułum; konu pe sinim mołmun konu ei. ");
INSERT INTO nii_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Gos Eiparam mułmba mei konu endi ngang, kongun er mułmba mei konu endi ngunerim mon! Pe mei aninga endi ngumba ei ngunerim mon. Ba Gos ek yi nim, ‘Ekii se mei ei ngamb, nim embilnjii, ei nim tiłap ni nim kinganim noł ełe mułngii.’ Eiparam kangił mulenjing kunum ei Gos ek yi nim. ");
INSERT INTO nii_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Gos ei yi mił nim, ‘Ekii se nga kinganim noł wumb mei eipi nge ełe mułngii. Nim nge kinganim noł wumb mei eipi nge ełe molk wumb mei wumb ei kongun wii er mułngii. Mułangin, wumb eipi enim oł embin tui er kis mundngii, ei kung ngii 400,’ pa nim. ");
INSERT INTO nii_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘Nim nge kinganim noł wumb ei kin kongun wii er mułngii, ba ekii se, na wumb tiłap eipi ei kin kos er ngumbii. Nimbił erang nim nge tiłap mei ei si kindik pungii.’ ");
INSERT INTO nii_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ba ok kunum ełe Gos eim Eiparam kin, ek dinga mon endi ni pendrim. Gos eim Eiparam kin ek dinga nip ekii se ermba ei nirim. ");
INSERT INTO nii_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Ok sinim kupenjpin noł wu engki nga tał, Josep kin noman kis piik, Josep wumb eipi ngok ku sik. Pe wumb ei Josep sik Eisip konu sipik. Ba Gos Josep paki topu multum. ");
INSERT INTO nii_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Epi endi eim kin omba erim ei Gos eim paki tum. Pe Gos Josep kin noman ka ngopu erang, Josep kongun ka erim. King Pero yi nim, ‘Nim Eisip konu tep wu owundu molkun, na ngii konu epi pei tep mulnjii,’ nirim. ");
INSERT INTO nii_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ekii se Eisip konu kumb kuni owundu sim. Pe Keinan konu orung orung, kuni owundu sim ku. Oł embin tui ei pim. Pe sinim kupenjpin noł ombu kuni ka si nungii mił pinerim. ");
INSERT INTO nii_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ba Jeikop mołpu piim ni, kuni wuł Eisip konu pei mołum ninjing. Pe eim kingam noł, sin kupenjpin noł ei kumna Eisip konu kindang punjung. ");
INSERT INTO nii_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ekii se nga kindang punjung. Pe Josep eim angim noł ek dinga nim, ‘Na Josep moł.’ Yi neng kin, Pero piim Josep nge wumb tiłap ende onjung ni piim. ");
INSERT INTO nii_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pe Josep ek nipi kindpi, ‘Arim Jeikop wangłi,’ nim. Eim kin eim nge wumb tiłap ei 75 mendpił ouni onjung. ");
INSERT INTO nii_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pe Jeikop wuł mani Eisip konu pum. Pu mołpu kułum. Eim kingam noł ei sinim kupenjpin noł kulnjung ku. ");
INSERT INTO nii_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pe Jeikop eim kingam noł eim sipik Sekim konu kui tunjung. Ok Eiparam eim Emor wumb kin mei Sekim top er sirim. ");
INSERT INTO nii_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Gos kunum ei epi ei ermbii ni piirim. ‘Ok Eiparam kanpi ermba,’ pa nirim. Kunum ei epi pei tonu omba enim. Esrel wumb tiłap ei Eisip konu owundu tonu onmun ei ok Eisip konu piki tonum. ");
INSERT INTO nii_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ekii se Eisip king endi tonu orum. Ei Josep pii poł tuneririm. ");
INSERT INTO nii_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Wu King ei sinim nge wumb tiłap ełe ambił gii dinga nirim. Sinim nge kupenjpin noł oł kis erpi ngum. King ei ek dinga nipi Esrel wumb, wu kangił mengingii ei anda kind pindangin kolk poru ningii nirim. ");
INSERT INTO nii_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kunum ełe Moses tonu om. Kangi ei Gos kan ka kenim ni Gos kangi ei kin noman ngum. Arim mam teł ngii konu tep er mułangił oi tekliki o pum. ");
INSERT INTO nii_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ekii se kangi Moses eim andaring pendnjing. Pe king Pero ambiłam eim kan sim. Sipipi eim kingam mił se mułum. ");
INSERT INTO nii_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Moses eim Eisip oł ełmin mił ei andan tangin er mołułum. Eim wu dinga mołpu, kongun erpi, ek dinga nipi ełim. ");
INSERT INTO nii_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses eim mołpu pang kin, kung ngii 40 pei o pang, mołpu piim. Esrel engnan noł mołmun konu pup kenmbii ni piim. ");
INSERT INTO nii_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pupu kenim ni, Eisip wu endi pupu Esrel wu mułum konu kepii tum. Pe pupu Esrel wu ni paki tum. Moses eim wu ei to orung kindim. Kindpi, Eisip wu ei to kundum. ");
INSERT INTO nii_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Eim yi piim, nam tiłap Esrel wumb ende ni piim. Gos sinim Moses angił ełe paki tonum ni piingii ni piim. Ba wumb yi ni piinenjing. ");
INSERT INTO nii_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kupiiring nga wu tał opu enjngił, Moses konu ełe tor om. Opu, wu tał opu enjngił ei, embii ermbii ni erim. Yi nim, ‘Ełip angim angim, nimbił erang opu erngił enmbił?’ ");
INSERT INTO nii_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pe wu endi angim kin opu erim wu, ei Moses ambił peri ngum. Ngopu yi nim, ‘Nim wu wumb nii nim wu owundu mundang molkun sin tep erii?’ nim. ");
INSERT INTO nii_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","‘Oltin Eisip wu endi to kundun mił, akip na to kundnjii en min?’ ");
INSERT INTO nii_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Wu ei yi neng kin, Moses sikir tonu pupu Miriyan konu eipi nge ełe mułum. Ekii se eim kingam tał mulnjunguł. ");
INSERT INTO nii_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Mułangił, eim kung ngii 40 pei opu pum. Gos kindang sinim tep enim, enjel ei nge opu ond kembis endi pim konu ełe dup erang num. Konu ełe mandi pupu dup kenmbii ni piim. Dup komung Sainai mani num. Dup tukrung ełe mołpu ek endi yi nim. ");
INSERT INTO nii_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses oł ei kanpi piim; eim kum sep piipi mandi pup kenmbii ni pum. Pe Gos Owundu ek yi nim, ");
INSERT INTO nii_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na Gos nim nge kupanim noł Gos moł. kupenjing Eiparam, Aisik, Jeikop, wu kei na Gos moł.’ Pe Moses puku sim. Sipi, eim Gos kenmba gał erim. ");
INSERT INTO nii_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Pe Owundu ek yi nim, ‘Nim simb kum pałim ei sikind! Na Gos moł, ya konu ełe nim angiłin konu ei konu ka wii mendpił sałim. ");
INSERT INTO nii_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na nge wumb, Eisip konu kis er mołmun ei, na kanip moł. Na enim kei ninjing ei piinj. Pe na mani op paki tumbii nge ombii. Kongun embin tui ei si kindmbii. Pe nim na kindamb Eisip konu punjii,’” pa yi nim. ");
INSERT INTO nii_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Siipen ek yi nim, “Moses ei ok enim ni wu owundu mołpu sin tep mułii nim?” Yi ninjing, “Gos eim dinga ełe enjel ei kindang ond kembis Moses mandi ełe pum. Wu ei nga Gos kindang pupu tep wu mołpu Esrel wumb sipi orung simba nge pum. ");
INSERT INTO nii_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses eim wumb sipim. Pe eim Gos nge jep oł kanim kanim erim. Erpi pupu, ep noł kundii mułum konu jep oł erim. Pe konu wumb mulenjing konu, kung ngii 40 pei opu pum. ");
INSERT INTO nii_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Esrel wumb pei mulnjung. Pe Moses eim Esrel wumb kanpi nim. Enim nge engnjing endi Gos sipi, to tonu kindmba wu ei, nga Gos kongun endi, oł ekii se ermba ei piipi nipi ermba. ");
INSERT INTO nii_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ekii se wumb mulenjing konu ełe kułou tunjung. Pe Moses Esrel wumb kin mulnjung. Enjel eim ek nikił tonu kumung Sainai komung mulnjunguł. Molkuł kin, Gos nge ek sim. Ek ei ek konj ka seng kin sinim kupenjpin noł, Moses nipi ngurum. Ek ei konj seng kin, pe nga ek ei sinim sałim ku. ");
INSERT INTO nii_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ba sinim kupenjpin noł ei Moses ek piinermin ninjing. Nik, ‘Mon,’ pa nik. ‘Sinim Eisip konu orung nga pamin,’ pa nik, yi piinjing. ");
INSERT INTO nii_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Pe Esrel wumb Eron kanik ninjing, ‘Nim sin nge gos eran kin kumb se pang kanpin ekii se bin,’ ninjing. ‘Pe Moses eim sin Eisip konu tor tu wumba; ba eim jiłi orung punum, sin piinanmin.’ ");
INSERT INTO nii_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kunum ełe kung kou wał endi enjing. Pe kułmał kalk gos kend ei ngunjung. Pe epi ei en enim angił ełe enjing epi ei kin ka piik embe ambił tonu kindik er mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Yi erangin kin, Gos en enim kin buł ngum. Ngang kin, en enim oi, kanjip, eni ei embe ambił tonu kindik, epi ombu sin gos erngii nik, Gos erngii mer mon ełe Gos ek ei ekii se ermba piiłmin. Wumb ei ek pulk ek ei yi nim. ‘Enim Esrel wumb enim ok ya konu wumb mulerik kunum ei enim kung ngii 40 pei mulk, enim kung kou ni kung siipsiip ni ombu kułmał kalk na ngonarik ełmin. Ba enim ek kend gos kułmał kalk ngok enmin. ");
INSERT INTO nii_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Enim kend Moluk gos ngii ełe sipnjing. Pe kanjip kin gos kend Rapan ełmin. Enim epi ombu erik embe ambilk tonu kindik enmin. Pe na enim kindamb Bepilon konu orung orung pungii.’ Gos Owundu ek yi nim.” ");
INSERT INTO nii_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Siipen ek yi nim, “Sinim kupenjpin noł, ok wumb mulnjung mei ełe mulnjung. Kunum ełe Gos ek piimin nik, alap ngii endi Gos nge alap ngii tekik, nimbił erang Gos nge eim embe ambilk tonu kindngii. Erik, alap ngii ei Moses kanpi yi mił tekei, nirim. ");
INSERT INTO nii_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kunum ekii se sinim kupenjpin noł Josua kin ok en enim wumb mei singii onjung. Wumb konu tiłap eipi nge mei sinim kupenjpin noł pangin kin, Gos wumb tiłap eipi ei to kindrim. Kunum ei, Gos nge ngii alap ei sipnjing. Sipik, alap ngii takik Gos eim embe ambilk tonu kindnjing kunum ełe Deipis tonu orum. ");
INSERT INTO nii_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Gos eim Deipis kin noman ngang, Deipis prei erpi Gos Jeikop kin ngii endi tekmbii nim. ");
INSERT INTO nii_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ba Solomon Gos ngii endi tekim. ");
INSERT INTO nii_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ba Gos Owundu mendpił wumb takiłmin ngii ei mulałim. Gos nga ekii se ermba oł ei piipi niłim wu yi nirim mił. ");
INSERT INTO nii_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Owundu ek yi nim, ‘Epin konu ei na peł mił tep erip moł, mei konu ei na simb ełe tonu kind send konu tep erip ku moł. Ngii nipe ngii na ngii nik takinmin? Pe na kor mołup ermbii ei konu jiłi? ");
INSERT INTO nii_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Pe nga na angił ełe epi ombu pei enenj min? Gos yi nim. Gos nge ek ni tor kindiłim wu endi yi mił nirim. Gos Owundu mendpił eim wumb takiłmin ngii ei molałiłim.’ ");
INSERT INTO nii_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Enim wumb Gos ek piinałmin, enim wii mołmun wumb noman kom, ni epi pinałim. Kunum kunum enim Gos Gui Ka to kindik kindik enmin. Enim ok kupenjing noł mulk oł ei nge enim yi mołmun. ");
INSERT INTO nii_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Ok Gos ermba oł piipi niłim wu ei wu nii mułum? Pe enim kupenjing noł wu ei kin oł kis endi enjing min mon? Mon! Wumb ok tonu ok Gos ek kun pałim mił nik wu endi ekii se omba wu ei oł kis endi enałim mon. Yi nik erik wu ombu to kunduk. Wu ei wu ka; ba pe akip enim wu ei enim puk wumb opu orung mulnjung konu nengin eim to kundnjung. ");
INSERT INTO nii_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Enim Gos nge lo ek ei sik ei, enjel gupu ełe sinim kupenjpin noł sik. Pe nga ek ei sinim piinmin ku, ba ekii sinanmin.” ");
INSERT INTO nii_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ek ei piinjing mił nenj noman ełe keimi tang kin, piinjing. En enim gupu mong kongk, Siipen kin popuł kis sinjing. ");
INSERT INTO nii_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ba Siipen, Gos nge Gui Ka kin piki to mułum. Mułang kin, eim ei epin konu dinga kenim ni, Gos konu ka wii tiłang ka wii er sim konu Jiisas Gos angił tundung orung engim. ");
INSERT INTO nii_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Pe Siipen ek nim, “Kinei! Na epin konu ka wii seng kand; wu kingam Jiisas Gos angił tundung orung angłim.” ");
INSERT INTO nii_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Yi neng kin, wumb wii dinga wii tunjung. En enim kom ambilk pandi tunjung. Sikir puk, Siipen ambił gii ninjing. ");
INSERT INTO nii_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Pe eim konu owundu ełe to tor kindnjing. Kindangin pang, ku sik pum konu ku tunjung. Wumb ok kin ek kis nik enjing, wumb en enim konduk gulk, wu kongun wu endi mułum konu mandi kindnjing. Kangi wu ei embe Sol. ");
INSERT INTO nii_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pe wumb Siipen ku to kundmun ni enjing. Pe Siipen prei yi erim, “Owundu Jiisas, na nge noman tuk ei nim se!” ");
INSERT INTO nii_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Pe Siipen eim gopsing pii poł mołpu wii dinga tum, “Gos Owundu, nim oł kis ei er orung kindnenjii.” Siipen ek yi nipi, eim kułum. ");
INSERT INTO nii_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Siipen to kundnjung. Wumb kombur Gos nge ek ei pii gii ninjing wumb ombu Siipen kui to pendik, ke owundu ninjing. Sol noman ka piim kunum ełe Gos nge wumb Jerusalem konu mulnjung wumb ei oł embin tui enjing. Yi erangin kin, wumb Gos ek piik mulnjung wumb ei tungu punjung. Puk, Jura konu ni Sameriya konu eipi eipi punjung. Ba Jiisas nge ek se andiłmin wumb Jerusalem konu er mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pe Sol eim Gos nge wumb er kis er endim. Wumb ngii konu pei nirik pupu wu amb ni sim. Sipi, kan ngii ełe kindpi ełim. ");
INSERT INTO nii_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pe Gos ek piinjing wumb tungu puk eipi eipi puk, Gos ek ka ei nik wumb ngunjung. ");
INSERT INTO nii_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip Sameriya konu owundu ełe mani pum. Pupu, Jiisas nge embe Krais ekii se omba ek puł ełe nipi wumb ngum. ");
INSERT INTO nii_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wumb pei Pilip Gos ek nim ei piik. Pe Pilip ek nim ei wumb kom se piinjing. Piik, Gos jep oł erim ei kanik enjing. ");
INSERT INTO nii_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Wumb pei gui kis tuk mułum; wu onjung wii dinga tok wumb nga ka mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Yi erang kin wumb konu owundu ełe mulnjung wumb pei ka piinjing. ");
INSERT INTO nii_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Wu endi konu owundu ełe mułum, wu ei embe Saimon. Ok eim kum kondpu oł kanim kanim ełim wu. Yi erang kin, Sameriya wumb noman pei piinjing. Eim yi niłim, “Na wu owundu.” ");
INSERT INTO nii_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pe wumb embe pim wumb pinerim, wumb pei Saimon ei piinjing. Wumb molk yi ninjing, “Wu ei Gos nge dinga piinim,” ninjing. Wumb eim kanik wu owundu dinga wii niłmin. ");
INSERT INTO nii_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wumb Saimon ek ei dinga piinjing. Nimbił erang ei kunum kunum oł ombu erang kanik, jep oł ei keimi ni piiłmin.” ");
INSERT INTO nii_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ba ekii se Pilip eim Gos enim ek ka ei nipi, Gos nge epi kanim kanim ei andan tang kanik, Gos embe ełe nipi sinim tep er mołum ni, Jiisas embe ełe neng, pii gii nik, wu amb ni ok noł pinjing. ");
INSERT INTO nii_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Pe Saimon pii gii nim ku. Pe noł pepi Pilip kin ouni mułum. Saimon mołpu kenim ni Gos nge jep oł kanim kanim Pilip erim. Erim ei, kanpi tungu erim. ");
INSERT INTO nii_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jiisas nge ek se andiłmin wumb Jerusalem konu molk piinjing ni Sameriya wumb Gos ek piinmin, ninjing. Yi nengin kin, Piisa Jon teł konu ełe kindangin punjnguł. ");
INSERT INTO nii_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wu tał ał mani pukuł Gos kin prei erangił, Gos wumb ombu paki topu Gos nge Gui Ka ngumba ni punjnguł. ");
INSERT INTO nii_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Nimbił erang Gos nge Gui Ka ei mani wang kin, ei sinenjing. Jiisas kin pii gii nik, eim embe ełe mendpił noł pinjing. ");
INSERT INTO nii_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pe wu tał wumb angił tonu kindangił wumb ei Gos nge Gui Ka sinjing. ");
INSERT INTO nii_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimon kenim ni Jiisas nge ek se andiłim wu tał wumb angił tonu kindangił wumb Gos Gui Ka sinjing. Yi erangił kin, Saimon kom ku si ngopu wu tał kin tu wum. ");
INSERT INTO nii_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Eim ek yi nim, “Ełip noman dinga ei nge na ngeł! Na wu endi angił tonu kindamb Gos nge Gui Ka simba,” nim. ");
INSERT INTO nii_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ba Piisa ek nipi ngum, “Gos eim epi ei wii ngołum ei, nim ku ngop simbii ni piikin nin min? Pe Gos nim kin ku kin, ouni poru nimba. ");
INSERT INTO nii_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ei nim epi mon, nim noman tuk Gos kaninim, ba ei kapłi enanim mon. ");
INSERT INTO nii_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nim noman to ak tokun, keimi oł kis en ei si kindkin, ninim Gos Owundu kin prei enjii. Erang kin, nim nge noman kis piin ni oł ombu Gos kil ngopu si kindmba. ");
INSERT INTO nii_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na nim kand. Nim noman tuk epi kis pei noman pałim. Yi ku nim keimi poru nimba mendpił.” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pe Saimon ek nipi orung kindpi yi nim, “Ełip Gos kin prei erngił na paki tumba. Prei erangił kin, epi ełip ek ninjngił epi ei na kin tonu onenmba.” ");
INSERT INTO nii_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pe Gos nge ek se andiłmin wu tał ek nikił poru ninjngił. Owundu ek ni poru ni pendkił Jerusalem konu nga orung punjnguł. Andłam ełe pukuł Gos ek ka Sameriya konu wumb tiłap pei ni ngokuł ngokuł punjnguł. ");
INSERT INTO nii_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Owundu kindang sinim tep enim enjel ei opu Pilip kin ek nim, “Nim pukun orung tor pukun Jerusalem andłam si kindkin, Geisa konu orung mani punjii.” Andłam sałim ei orung wumb mulałmin. ");
INSERT INTO nii_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Pe Pilip angpi andłam ełe pupu kenim ni Esiopiya wu endi mułum. Wu ei wu owundu mołpu, Kandesi konu Kuin kin kongun er mułum. Pe Esiopiya wu eim ku ni epi pei tep er se mułum. Wu ei Jerusalem konu Gos embe ambił tonu kindim, ek piimbii ni om. ");
INSERT INTO nii_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Pe eim nga ngii konu orung ba erim. Eim kung os karis ełe mołpu, Aisaiya Gos nge ek ni tor kindiłim wu ei mon poł pendim er gerpi pum. ");
INSERT INTO nii_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pe Gos nge Gui Ka Pilip kin yi nim, “Nim sikir tonu pukun kung os karis ei kin tep to punjii!” ");
INSERT INTO nii_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Pe Pilip sikir pupu tonu pum. Pupu, piim ni wu ei Gos Aisaiya nge ek ger pum. Pilip ek nim, “Pe nim gerin ek pułe, nim piin min mon?” ");
INSERT INTO nii_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Wu ei ek yi ni orung kindim, “Pe wu endi na andan tunenjing kin, na er kanip piimbii mił nenj?” Pe Pilip kanpi nim, “Nim na moł konu tonu wa!” ");
INSERT INTO nii_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ek ei Gos ek gerim yi mił gerim. “Eim tu wunjung ni kung siipsiip mił to kundngii nge tu wułmun oł ei tu wunjung. Kung siipsiip wał ei enjin kopus siłmin ei ke ninałim. ");
INSERT INTO nii_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Eim to mani kindik, kos er kun enenjing mon. Wumb endi opu eim tiłap wumb yi mulnjung. Mołmun nimba wu ei kapłi enanim. Eim epin konu pum.” ");
INSERT INTO nii_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pe Esiopiya wu ei Pilip kii sim, “Gos nge ek ni tor kindiłim wu piipi yi nim ek ei nii pułum? Eim kin ninim min, wumb eipi kin ninim?” ");
INSERT INTO nii_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Pe Pilip ek nipi wu ei ngum. Eim Gos ek nipi Jiisas ek ka ei nipi ngum. ");
INSERT INTO nii_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Andłam ełe pukuł, noł endi pim konu punjnguł. Wu num ni yi nim, “Noł endi pałim. Epi nipe endi erang na noł pinenmbii?” ");
INSERT INTO nii_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pe Pilip ek nipi ngum, “Nim noman ełe pii gii keimi nin kin kapłi. Wu ei ek dinga nim, ‘Na Jiisas Krais Gos kingam ei na pii gii ni moł,” wu ni yi nim. ");
INSERT INTO nii_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pe ek neng, kung os engim. Pe Pilip kin wu num ei kin noł ełe mani punjnguł. Pe Pilip wu ei noł pendpi ngum. ");
INSERT INTO nii_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wu tał noł si kindił tonu onjnguł. Pe kunum ełe mendpił Gos Owundu nge Gui Ka opu, Pilip sipim. Wu num ni Pilip eim kinenim. Pe wu num ni eim ka piipi, eim ngii konu andłam ełe orung pum. ");
INSERT INTO nii_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pe Pilip pupu konu Asros ni konu endi tor om. Eim pupu konu owundu sim konu orung Jiisas ek ka ei nipi wumb ngum. Ekii se pupu konu Sameriya ni konu ełe tor om. ");
INSERT INTO nii_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Sol nge ek dinga nipi, owundu nge wumb ei to kundmun ni ek nipi kułmał kałiłim wumb Gos ek piik mulnjung konu kindim. Pe men ngii Jura wumb mulnjung konu ei embe Damaskas. Pe pipe sipi Sol ngum, pipe ek yi nim, “Pe Sol wumb kombur kindang Owundu nge wumb andłam ełe puk ninjing kin, kan ngopu Jerusalem tu wangłi!” nim. ");
INSERT INTO nii_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pe Sol andłam andpi pupu Damaskas konu ełe tor pum ni, ei epin tiłang ełe tor opu Sol om konu orung orung tiłang erpi eni mił dinga tum. ");
INSERT INTO nii_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Pe tiłang ei Sol tang mani mei pepi piim ni ei epin ek endi tor om, “Sol! Sol! Nim nimbił erang na wumb tiłap ei er kis mondun?” ");
INSERT INTO nii_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol ek yi nim, “Owundu nim nii?” Pe eim yi nim, “Na Jiisas. Nim na tiłap wumb ei nimbił erang tokun en? Ei nim na tokun en ku. ");
INSERT INTO nii_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nim angkin konu owundu ełe tuk punjii. Pan, wu endi mołum wu ei, nim oł endi enjii mił yi nipi ngumba,” pa nim. ");
INSERT INTO nii_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Wumb Sol kin tep to onjung wumb ei mulnjung wumb ei ek ningii; ba ningii pinerim. Ek ei epin tor om ek ei piinjing, ba wumb endi kinenjing. ");
INSERT INTO nii_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Pe Sol angpi kenmbii ni erim, ba ningił tumbun mułum. Mułang, wumb eim angił ambilk Damaskas tonu tuk sipnjing. ");
INSERT INTO nii_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Kunum tekliki ningił ka enerim, kuni ni noł ni ombu nunerim mon. ");
INSERT INTO nii_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pe Jiisas nge wu endi Damaskas konu mułum wu ei embe Ananaiyas or kumb kenim ni Gos ek nim, “Ananaiyas!” Nga eim yi nim, “Owundu na moł.” ");
INSERT INTO nii_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Owundu ek yi nim, “Nim pukun konu embe ek yi nim, ‘Kun sałim’ konu ełe punjii. Juras ngii konu ełe kii sinjii. Wu endi mułmba wu ei Tasas konu wu ei, eim embe Sol eim prei er mołum. ");
INSERT INTO nii_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Prei er mułpu kunum ełe eim noman kindpi piim ni wu endeim angpi mułum. Wu ei embe Ananaiyas. Wu ei opu eim angił tonu Sol peng ełe embiłim. Yi erang kin, eim ningił er kun ermba,” Owundu yi nim. ");
INSERT INTO nii_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaiyas ek nipi orung kindim, “Owundu, na piinj wumb pei wu ei kin ek yi ninjing, ‘Wu ei oł embin tui ełim, Jerusalem nim wumb mulnjung konu ełim,’ wumb yi ninjing. ");
INSERT INTO nii_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Sol, kułmał kałiłim wu owundu kin wumb pipe sipi poru nim. Wumb konu ełe wumb Gos ek piik er mulnjung wumb ei, Jiisas embe ambił tonu kindik enmin.” ");
INSERT INTO nii_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ba Owundu ek nipi ngopu yi nim, “Nim po! Wu ei akip na nge kongun wu. Na eim kongun eipi endi kindamb pupu wumb tiłap eipi nge ni, King ni mułngii konu ełe na embe nge ełe nipi sipipi, Esrel wumb kin mułmba ku. ");
INSERT INTO nii_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Pe na eim epi embin tui kanim kanim andan tamb kanpi, na nge embe ełe ek nimba.” ");
INSERT INTO nii_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pe Ananaiyas eim pum. Pupu, ngii ełe nirik pupu angił Sol nge peng, tonu kindpi ek nim, “Engnan Sol, Jiisas Owundu nim andłam ełe kenim ei na kindang ond. Nimbił erang nim ningił ka erang kenjii. Gos nge Gui Ka nim kin piki to mułmba.” ");
INSERT INTO nii_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Pe sikir Sol ningił ełe pim epi omu kindin mił ei sikir tor pang, eim ningił nga ka seng kenim. Eim angpi pupu noł pim. ");
INSERT INTO nii_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ekii se Sol eim kuni nopu erpi dinga peng mułum. Damaskas konu Sol eim Jiisas nge wumb kin tep to mułum. ");
INSERT INTO nii_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mołpu, sikir Gos nge ngii Jura konu orung orung sim. Konu pum, eim Jiisas ek nipi wumb ngopu yi nim, “Jiisas ei Gos kingam mendpił.” ");
INSERT INTO nii_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Wumb pei ek ei piik, puku sinjing. Sik, ek yi ninjing, “Wu ei Jiisas embe ełe nge prei erik enjing ei eim mon nipi, Jerusalem wumb topu ełim wu mendpił.” ");
INSERT INTO nii_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ba Sol eim noman tuk dinga nga pang, Damaskas mulnjung wumb eim ek ei piik ek ei kapłi enerang orung kindngii. Eim wumb andan ka topu yi nim, Jiisas ei Krais wu ekii se omba, niłmin ei nipi ngum. ");
INSERT INTO nii_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kunum pei o pang, Jura wumb kułou tok ek ni piik, Sol to kundmun, ninjing. ");
INSERT INTO nii_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ba Sol wumb ninjing ek ei piim. Jura wumb konu owundu ełe andłam ełe epin, tinga, kui er molk, Sol to kundngii nge mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ba Sol eim ek ekii sinjing wumb, eim ku ngii ełe tuk tonu sipnjing. Pe Sol gerenj kon owundu endi sim konu mułum. Mołang, eim nge ekii sinjing wumb kan pilngan tangin, mani mei ba ni enjing. ");
INSERT INTO nii_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ekii se Sol Jerusalem konu pum. Eim Jiisas ekii sinjing wumb kin kułou topu nipi sipipi, wumb eim kin mund mong kulk, eim Jiisas nge wu endi min nik pii gii ninenjing. ");
INSERT INTO nii_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ba Banapas Sol nipi sipipi, Gos ek se andiłmin wumb mulnjung konu sipim. Pe eim ek poł topu Sol, Owundu Jiisas kenim mił yi poł top ngum. Pe Jiisas nge embe Sol dinga nipi Damaskas konu wumb nipi ngopu erim mił ei poł tum. ");
INSERT INTO nii_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yi erang, Sol en enim kin tep to mołpu Jerusalem konu and mulnjung. Gos Owundu ek ei dinga nipi wumb ngopu eim mund mong kulerim. ");
INSERT INTO nii_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol Jura wumb Griik niłmin wumb ei kin ek tangpi erim. Wumb ei kin ek mił erim. Ba wumb en enim andłam endi kan sipin, eim to kundmun ninjing. ");
INSERT INTO nii_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ekii se Sol angim noł ek ei piik, Sol si mengk Sisariya konu mani sipnjing. Sipik, eim Tasas konu kindnjing. ");
INSERT INTO nii_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pe Jura konu ni Galilii konu ni Sameriya konu ei pei orung Gos nge kułou tunjung wumb ei kunum ełe ka mulnjung. Opu ni epi pinerang kin, Gos nge wumb dinga mulnjung. Wumb en enim Gos Owundu ek nim mił ekii sengin, Gos nge Gui Ka en enim noman tuk to dinga erim. Wumb pei Gos ngii ełe ok Gos ek piinjing. ");
INSERT INTO nii_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pe Piisa konu pei andpi pum. Pupu, Lira ngii konu ełe pum. Pupu, Gos nge wumb pii gii ninjing wumb mulnjung konu ełe pu mułum. ");
INSERT INTO nii_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Konu ełe wu endi mułum. Wu ei embe Einiyas. Wu ei ngenj dinga punerim, wii sirim. Wu ei eim or minj pepi mułang, kung ngii angił orung nga tekliki o purum. ");
INSERT INTO nii_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pe Piisa ek nipi wu ei ngum, “Einiyas! Pe Jiisas Krais nim er ka ermba enim. Nim angkin, or pin peł er kun enjii!” Pe wu ni sikir engim. ");
INSERT INTO nii_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pe Lira wumb ni Seron wumb pei noman ak tok Owundu kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jopa ni konu ełe Gos nge amb endi mułum, amb ei embe Tapisa. Griik wumb ek eipi Dorkas niłmin Amb ei kunum kunum oł ka erpi, wumb epi sinałim ei eim wumb paki topu ełim. ");
INSERT INTO nii_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kunum ei eim ening endi kan sipi kułum. Pe eim nge was er ka erik tukrung palting ełe tonu kind pendnjing pim. ");
INSERT INTO nii_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lira ni konu ei Jopa konu ełe mandi sim. Pe Gos nge wumb molk piinjing ni, Piisa eim Lira konu ełe mołum ni piinjing. Pe wu tał kindangin pukuł ni, Piisas ek ningił, “Nim sin kin wa; mulerii!” ");
INSERT INTO nii_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pe Piisa eim tał kin sikir punjung. Piisa pupu tor pang, eim sik tuk palting ełe tonu sipnjing. Amb pei wenjing noł kulnjung ombu ok Piisa mułum konu mandi ok ke nik mulnjung. Dorkas konduk ni kon enim konduk ei en enim mołum epi ombu tu wuk andan tok enjing. ");
INSERT INTO nii_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piisa amb pei anda kindim. Eim gopsing pii poł mołpu prei erim. Er pendpi, kan ak top amb ngenj ełe nim, “Tapisa, nim ang!” Pe amb ni ningił kanpi Piisa kenim ni kanpi angpi mułum. ");
INSERT INTO nii_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piisa amb ni angił ambiłpi angndang engim. Pe amb Tapisa konj mułum. Pe Piisa wumb Gos kun er molk enjing wumb wii topu, amb wenjing noł kulnjung amb poru wii tum. Wangin kin, Dorkas en enim ngum. ");
INSERT INTO nii_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ek ei Jopa konu orung orung pang piinjing. Piik, wumb pei Gos Owundu kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jopa konu Piisa kunum kinan mułum. Piisa wu endi kin mułum wu ei kung kou ngenj kongun ełim wu kin mułum. Wu ei embe Saimon. ");
INSERT INTO nii_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pe wu endi Sisariya konu mułum wu ei embe Koniiliyas. Wu ei opu wumb, pei 100 tep ełim. Wu opu ełmin wumb ei, Rom opu wumb embe Esalii konu niłmin. ");
INSERT INTO nii_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Wu ei eim Gos ek piiłim. Eim ni ngii ende pałmin wumb ombu Gos embe ambilk tonu kindiłmin. Jura wumb epi endi sinarpi ełim, ei eim ku pei sipi ngołum. Kunum kunum eim Gos kin prei er ngołum. ");
INSERT INTO nii_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kunum ełe eni pou neng eni tekliki erang kin, epi endi kenim ni or kumb mił yi erim. Gos nge enjel endi kindang, eim kin opu, ek yi nim, “Koniiliyas!” ");
INSERT INTO nii_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Koniiliyas enjel kanpi mund mong erim. Erpi kin, ek yi nim, “Owundu, ei epi nipe?” Pe enjel ek nipi Koniiliyas ngum, “Nim prei erkin wumb epi sinerim ei nim paki tokun en ei Gos piipi mołum. ");
INSERT INTO nii_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pe nim wumb kombur kindan, Jopa konu puk wu endi kurngii, wu ei embe Saimon, wu endi embe Piisa wu ei wii tangin ya omba. ");
INSERT INTO nii_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Wu ei Saimon endi ełe, ngii konu mołum. Wu kung kou ngenj kongun ełim wu. Eim ngii ep noł wer ełe angiłim.” ");
INSERT INTO nii_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Gos enjel Koniiliyas kin ek ni pendpi pum. Pe Koniiliyas eim kongun wu tał wii topu, opu wu endi wii tum ku. Opu, wu ei eim Koniiliyas kin paki topu mołpu, Gos embe ambił tonu kindim wu. ");
INSERT INTO nii_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Koniiliyas enjel nim ek ei kun nipi wu tekliki ngum. Ek nipi ngopu, pe Jopa konu pei ni kindang punjung. ");
INSERT INTO nii_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Andłam ełe andik puk, emii peng or pinjing; tingang puk, Jopa konu owundu ełe mandi punjung. Kunum ełe Piisa ngii ełe tonu pupu prei erim kunum ełe konu eni tinga mił sim. ");
INSERT INTO nii_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Piisa eim kuni tang kin, kuni numba erim, kuni er ka enjing epi endi Piisa or kumb mił er kenim. ");
INSERT INTO nii_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Eim kenim ni ei muł ełe epi endi wuł ał pang kin, epi endi mani om. Ei alap owundu mendpił epi ei orung orung ambił epi tuk si ya mei ełe mani om. ");
INSERT INTO nii_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tukrung ełe kung ni kei ni, epi nui nunerii, ka wembii, ni epi pei mułum. ");
INSERT INTO nii_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pe ek endi Piisa kanpi nim, “Piisa, nim angkin kung ni epi to kał nui!” nim. ");
INSERT INTO nii_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ba Piisa ek nim, “Owundu, na mon! Na epi nonał. Epi ei nge na nonał.” ");
INSERT INTO nii_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ek ei nga tor opu yi nipi, Gos ngołum. “Epi ei Gos konj erim ni nonałmin nin min?” ");
INSERT INTO nii_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Epi ei kunum tekliki mani opu nga ei muł tonu pum. ");
INSERT INTO nii_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piisa noman embin to piipi, or kumb ei pułe er pałim mił nenj ni piim. Eim yi piipi mułang kin, Koniiliyas wumb ei ngii ondu andaring ełe engnjing. ");
INSERT INTO nii_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ok, wii dinga tok yi ninjing, “Saimon, eim embe endi Piisa konu jiłi mołum; ya ełe mołum min mon?” ");
INSERT INTO nii_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piisa eim or kumb kenim ei noman embin to piim. Pe Gos nge Gui Ka ek nim, “Piisa, wu tekliki, nim kuruk onmun. ");
INSERT INTO nii_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pe nim pukun, wu ombu kin pungii. Nim noman embin to piinenjii. Na wu ombu na kindamb, onmun.” ");
INSERT INTO nii_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wu ombu mulnjung konu Piisa pupu yi nim, “Enim wu endi kur endnjing wu ei na. Enim er onmun mił nenj?” ");
INSERT INTO nii_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Wu ombu ek yi ninjing, “Opu ełmin wumb 100 pei tep erim wu Koniiliyas sin ‘Pei’ ni kindang onmun. Eim wu ka mołpu Gos nge embe ambił tonu kindpi mołum. Jura wumb pei molk wu ei ka niłmin. Pe enjel ek nipi ngum wu ei ngii konu wang kin, nim ek kombur nen piimba,” ninim. ");
INSERT INTO nii_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pe Piisa ek nipi wu ombu, “Nirik wei!” pa nim. Eim wu ombu kin pim. Pek kin, kupiiring Piisa wu ombu kin punjung. Jopa konu wumb pii gii nik mulnjung wumb ei, eim Piisa kin ouni punjung. ");
INSERT INTO nii_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Puk, andłam ełe andik punjung. Kunum ełe endeim or pinjing. Pek, puk Sisariya konu tor bin ni punjung. Pe Koniiliyas eim wumb ongii ni kui er mułum. Eim nge wumb tiłap ei wii topu eim nge wumb puł ei wii to tuk sipi er mułum. ");
INSERT INTO nii_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Piisa ngii ełe ni ei bii ni pum. Koniiliyas anda o pupu, Piisa kumb ełe om. Opu, Piisa simb ełe mong gopsing pii połpu pepi ka piim. ");
INSERT INTO nii_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ba Piisa eim angił ambił tonu sim. Eim ek yi nim, “Na nim mił wu ende, eipi mon, na wu ku.” ");
INSERT INTO nii_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piisa wu ei kin ek nipi nirik punjnguł. Pukuł, kenjngił, nirik wumb pei kułou to mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Piisa ek dinga nipi yi nim, “En enim piinmin! Jura wumb endi kin wumb tiłap eipi kin ende endnerngii niłmin. Pe nga wumb tiłap ei ngii wu endi ba konu punerngii niłmin ku. Ba Gos na kin oł yi erim. Na wumb endi kis mołum nip wu endi ka mołum nip yi ninenmbii mon. ");
INSERT INTO nii_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ei piip kin, na ek ei ni tor kindind. Na enim ek nik kindnjing ei piip kin na ya ond. Pe na enim ek ei to kindnenj. Ei nimbił erang, enim na wii tunjung ei piip ond?” ");
INSERT INTO nii_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pe Koniiliyas ek yi nim, “Epi endi na kin wang pe kunum tekliki o pang, ei yi mił, na nam ngii konu mołup konu eni tekliki erang, prei er muls. Kunum ełe, wu endi opu na kumb ełe engim. Eim alap tełim epi ei tiłang enim mił yi erim. ");
INSERT INTO nii_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Pe eim ek yi nim, ‘Koniiliyas, Gos nim prei en ei piinim. Pe Gos eim piinim, nim wumb epi sinerim wumb ei paki ton ei piinim. ");
INSERT INTO nii_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pe nim wu ombu kindan Jopa konu puk Saimon mułmba ei ningii. Wu ei embe endi Piisa. Wu ombu puk kin, Saimon wu endi ngii konu ełe mołułum. Wu ei kung kou ngenj kongun ełim wu. Pe eim ep noł wer ełe eim ngii angiłim.’ ");
INSERT INTO nii_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Yi neng kin, na wu ombu nim mułun konu pei nemb punjung. Pe nim oł ka erkin on. Pe sin wumb pei ya Gos kumb ełe o mołmun. Ei ek pei Owundu nim nipi ngum, ek ei ni sin ngan piimin,” Koniiliyas ek yi mił nim. ");
INSERT INTO nii_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","36","Pe Piisa ek yi nim, “Keimi, pe na piind, Gos eim wumb kanpi ende kindnim. Wumb eipi eipi Gos ningił ełe ende mił mołmun. Wumb pei konu orung orung wumb ende oł ka erpi Gos kin mund mong kułmba wumb ei noman Gos ngołum. Enim piinmin! Gos sin Esrel wumb kin ek nipi kindiłim. Kindang kin, eim ek ka Jiisas Krais wu endi Gos eim kindang om. Pe sinim pei kin Owundu mołum. ");
INSERT INTO nii_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Pe en enim piinmin! Ok Jon noł pingii ek ei nipi poru nirim. Ekii se ek kanim kanim ei enim piik. Kunum ełe ek ei Galilii konu opu, Jura konu orung pei piik. ");
INSERT INTO nii_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ek ei Jiisas Naseres ek, Gos eim Gui Ka kin dinga eim ngum. Pe eim konu eipi eipi pupu wumb paki tum. Gos eim kin mułang, Seisen wumb kin mołpu, wumb Seisen er kis mundum wumb ei, Jiisas er ka erim. ");
INSERT INTO nii_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Sin ek ni tor kindim ek, kanpin ninmin. Wumb sin konu Jura konu ni Jerusalem konu kindinmin wu ombu, konu pei wu ei ond peri ełe to kundnjung. ");
INSERT INTO nii_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pe kunum tekliki pang, Gos eim nga er konj sim. Sipi peni ełe kindim. ");
INSERT INTO nii_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pe Jura wumb pei ningił ełe kinenjing, mon! Gos eim erang sin Gos eim ok nirim wu ombu eim ek nipi tor kindpin ermin. Wu eim tukpu ełe angpi nga orung wang, sin eim kin kuni ende nopun, noł ende nopun enjpin. ");
INSERT INTO nii_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Eim sin kanpi nim, ‘Enim wumb pei kanik, ek ei ni tor kindngii. Gos Owundu eim wu ei Jiisas minj mundang mołpu, wumb kułii konj pei kos ermba ni mundum.’ ");
INSERT INTO nii_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Krais wu endi Gos kindang omba wu, ei Gos ek ni tor kindiłmin wumb ek dinga nik wumb ngunjung. Gos wumb ei pii gii ninmin wumb ombu oł kis ei kil ngumba.” ");
INSERT INTO nii_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Piisa ek ei nipi mułang kin, Gos nge Gui Ka mani opu wumb pei ei piik mulnjung konu om. ");
INSERT INTO nii_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pe Jura wumb pii gii pim ninjing wumb Piisa kin onjung, wumb ei puku sinjing. Nimbił erang Gos Gui Ka erpi wumb tiłap eipi ei ngonum. ");
INSERT INTO nii_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Jura wumb ombu molk piinjing ni, wumb en enim ek eipi eipi nik Gos embe ambił tonu kindnjing ek ei yi nengin kin, Piisa ek nim, “Wumb nii endi noł pek enmin ei mon nimba? Wumb ei sinim Gui Ka sinjpin mił sinmin.” ");
INSERT INTO nii_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pe ek nipi wumb ngum, “Enim Jiisas Krais embe ełe noł pingii.” Pe wumb ek ninjing, “Nim sin kin kunum kopur mulnjii,” ninjing. ");
INSERT INTO nii_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Gos nge ek se andiłmin wumb kin, pii gii wumb Jura konu orung orung molk piinjing ni, wumb tiłap eipi ei Gos ek piinjing poru ninim ninjing. ");
INSERT INTO nii_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Pe Piisa Jerusalem konu tonu pum. Pang kin, ngenj kopus siłmin pii gii niłmin wumb, Piisa kin ek dinga ninjing. Nik, eim ek ngunjung. ");
INSERT INTO nii_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","5","Ba Piisa epi tonu om mił nipi ngum. Ek yi nim, “Jopa konu owundu ełe muls. Mołup, prei erip mołup, or kumb mił endi enj. Epi ei alap owundu kupu muł si kindpi mani om. Epi ei orung orung kapłi pim ni, mani na muls konu om. ");
INSERT INTO nii_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Pe na mołup, epi ei mandił kenj ni mani mei ełe, epi ei ni ka wembii ni kei ni epi pei mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Na mołup piinj ni, ek endi yi nim, ‘Piisa, nim epi ombu to kał, no!’ nim. ");
INSERT INTO nii_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ba na yi ninj, ‘Owundu na mon! Na epi kis mołum epi endi nop nga ka sim nop enał, mon!’ ninj. ");
INSERT INTO nii_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ei epin ek ei nga tor om. ‘Epi Gos enim epi ei ka sałim, ei kis ninenjii!’ ");
INSERT INTO nii_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Epi ei kunum tekliki tor om. Pe sikir epi ei pei ei muł ełe tonu pum. ");
INSERT INTO nii_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pe kunum ełe wu tekliki sin mulnjpun ngii ełe tonu onjung. Sesariya wu endi, wu kei kindang na muls konu onjung. ");
INSERT INTO nii_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pe Gos nge Gui Ka ek nim, ‘Nim wu kei kin ouni pungii,’ nim. ‘Nim noman embin kulerii!’ Pe wu kei kin pii gii wumb angił orung nga endeim na kin pupun Koniiliyas ngii konu nirik punjpun. ");
INSERT INTO nii_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Pe wu ei eim ek nipi nim, ‘Eim Gos kindang opu sinim tep enim wumb ei nge kenim mił nipi sin ngum.’ Ei yi nim, ‘Nim Jopa konu pukun wu Saimon mołum nen omba, wu ei embe endi Piisa. ");
INSERT INTO nii_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Eim nim ek kombur nipi ngumba. Ek ełe nim Gos nim sipi orung sipi, nim ngii endi wumb ei Gos sipi orung simba,’ yi nim. ");
INSERT INTO nii_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na ek nip mołamb kin, Gos nge Gui Ka wumb mulnjung konu om. Ei sinim kin ok orum mił yi om. ");
INSERT INTO nii_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na owundu ni eim ek ei nga piind, ‘Jon wu amb noł mendpił pendpi ngum. Ba enim Gos nge Gui Ka ełe noł pendmba.’ ");
INSERT INTO nii_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ok sinim Jiisas Krais kin pii gii nemin epi ka wii sinim kin wii ngumba. Gos Gui Ka sin ngurum mił ei nge akip wumb ombu ngonum. Nii na kapłi? Gos andłam owundu ngumbii min?” Piisa ek yi nim. ");
INSERT INTO nii_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Piisa ek nim ek ei piik, “En enim ek ei si kindik Gos embe ambił tonu kindik,” enjing. “Yi erangin, Gos wumb tiłap eipi noman to ak tum ku, wumb ei noman konj sik mułngii ku.” ");
INSERT INTO nii_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ok Siipen kołpu pang kin, oł embin tui owundu endi tonu om. Pe pii gii wu kombur tungu puk konu eipi eipi punjung. Puk, Piniisiya konu ni Saipris konu ni Andiok ni konu ełe punjung. Ek nik wumb eipi Gos ek ngunenjing; Jura wumb minj ek nik ngunjung. ");
INSERT INTO nii_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ba wu kombur tuk ełe mulk, Saipris konu ni Sairiini ni konu ombu puk, Andiok konu puk Griik wumb Jiisas ek ka ni ngunjung ku. ");
INSERT INTO nii_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gos Owundu nge dinga ełe opu seng kin, wumb pei pii gii nik, Gos kin noman to ak tok Gos Owundu kin pii gii ninjing. ");
INSERT INTO nii_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalem konu Gos nge tiłap ek ei piik wu, Banapas Andiok konu kindangin pum. ");
INSERT INTO nii_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Eim opu kenim ni, Gos wumb ombu kaimb sipi piki to mułum. Banapas opu kanpi ka piim. Pe eim Gos ek dinga nipi wumb ngum. Wumb piik kin, Gos Owundu kin kunum kunum mandi ok mulnjung. ");
INSERT INTO nii_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banapas ei wu ka, Gos nge Gui Ka eim kin piki to mułum. Enim Gos kin pii gii dinga pim. Pe wumb pei Gos nge tiłap ełe tuk onjung. ");
INSERT INTO nii_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pe Banapas Sol kurpu, Tasas konu ełe pum. ");
INSERT INTO nii_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Pupu, kur kan sipi, Andiok konu ełe orung tu wum. Kung ngii endeim Gos nge tiłap wumb Andiok konu mulkuł, Gos ek ka nikił, wumb ngunjnguł Andiok konu ełe Gos nge wumb ełe kumna embe, ‘Krisin’ o ninjing. ");
INSERT INTO nii_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kunum ełe, ekii se piik niłmin wu kombur Jerusalem konu si kindangin Andiok konu mani onjung. ");
INSERT INTO nii_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ek ni tor kindiłmin wumb mulnjung konu, wu endi tuk mułum wu ei embe Akapas. Wu ei Gos Gui Ka piki tang, orung orung pei kumb kuni owundu simba nim. Ekii se Kloriyas King owundu mułum kunum ełe, kumb kuni owundu simba kunum. ");
INSERT INTO nii_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Yi neng kin, Gos pii gii wumb Andiok konu ełe ek nik piik. Jura wumb engnjing noł eipi mołmun ei paki tumun. Gos nge tiłap wumb endeim ni yi piinjing. Ku seng kin, kongun ełe ku orung paki to kindmin ni piinjing. ");
INSERT INTO nii_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ek yi ni pendik, ku ngangin Banapas kin Sol tał kindangin sipkił, peng pim wumb mulnjung konu ngunjnguł. ");
INSERT INTO nii_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kunum ełe, wu King Eros tiłap ełe mulnjung wumb ei topu kan ngopu oł embin tui erim. ");
INSERT INTO nii_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Pe King Eros Jeims angim Jon tui to kundum. ");
INSERT INTO nii_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","King Eros Jura wumb kenim ni, erim oł ei ka piinjing. Piyangin, kanpi Piisa kan ngum ku. Erim, kunum ei Jura wumb bres yiis punerang nunjung kunum ełe erim. ");
INSERT INTO nii_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Piisa ambił gii nik, kan ngunjung. Piisa kan ngopu, opu wu kapił kapłi mulnjung konu kindim. Kindang kin, tep er mulnjung wu kapił kapłi mulnjung konu opu wu kapłi tep er mulnjung. Wu King Eros eim yi piim, Pasopa kunum ei ekii se Gos wumb Jura wumb Piisa sipi wumb mułngii konu ełe kos ermbii ni piim. ");
INSERT INTO nii_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Yi erangin kin, Piisa kan ngii ełe mułang kin, opu wu tep er mulnjung. Ba Gos nge tiłap ełe pr