﻿USE sofia;
DROP TABLE IF EXISTS sofia.nif_vpl;
CREATE TABLE nif_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nif_vpl WRITE;
INSERT INTO nif_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Anutulɨ Yesu en Mesia nɨmbɨ taleñguk endok soliilok kot sambat wɨn ñɨndɨñ: Yesu endɨ ama wapmañ Devit endok sambat, tɨmbi Devit endɨ Ablaamdok sambat. ");
INSERT INTO nif_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablaam wɨn Aisak endok beu, Aisak wɨn Jekop endok beu, tɨmbi Jekop wɨn Juda gɨta dal kwayañii endok besɨ. ");
INSERT INTO nif_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda wɨn Peles gɨta Sela endok beset. (Menjettok koi Tama.) Tɨmbi Peles wɨn Heslon endok beu, Heslon wɨn Ram endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tɨmbi Ram wɨn Aminadap endok beu, Aminadap wɨn Nason endok beu, Nason wɨn Salmon endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tɨmbi Salmon wɨn Boas endok beu. (Meñlok koi wɨn Rahap.) Tɨmbi Boas wɨn Obet endok beu. (Meñlok koi Rut.) Tɨmbi Obet wɨn Jesilok beu, ");
INSERT INTO nif_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi wɨn ama wapmañ Devit endok beu. Tɨmbi Devit wɨn Solomon endok beu. (Solomon meñ wɨn dama Ulialok tamɨn pakuk.) ");
INSERT INTO nif_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tɨmbi Solomon wɨn Reoboam endok beu, Reoboam wɨn Abia endok beu, Abia wɨn Asa endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tɨmbi Asa wɨn Jeosafat endok beu, Jeosafat wɨn Jeolam endok beu, Jeolam wɨn Usia endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Tɨmbi Usia wɨn Jotam endok beu, Jotam wɨn Ahas endok beu, Ahas wɨn Hesekia endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Tɨmbi Hesekia wɨn Manase endok beu, Manase wɨn Amon endok beu, Amon wɨn Josaia endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tɨmbi Josaia wɨn Jeoiakin gɨta dal kwayañii endok besɨ. Nain wolonda Babilon nasilɨ Islael amatam kaikan gɨñgɨnembi, endok kwelan kuñgulok yanañgɨp ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Yesulok solii Babilon ña pakɨlɨñ, walinin bɨkap Yesu en indañguk endok kot sambat wɨn ñɨndɨñ: Jeoiakin wɨn Sealtiel endok beu, Sealtiel wɨn Selubabel endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tɨmbi Selubabel wɨn Abiut endok beu, Abiut wɨn Eliakim endok beu, Eliakim wɨn Asol endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Tɨmbi Asol wɨn Sadok endok beu, Sadok wɨn Akim endok beu, Akim wɨn Eliut endok beu. ");
INSERT INTO nif_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tɨmbi Eliut wɨn Eleasa endok beu, Eleasa wɨn Matan endok beu, Matan wɨn Jekop endok beu, ");
INSERT INTO nif_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekop wɨn Josep endok beu. Tɨmbi Joseptɨ tamɨn Malia tɨmbɨmbi, Malialɨ wakan Yesu apmɨñguk, koi Mesia kɨtɨañ. ");
INSERT INTO nif_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Wɨndɨñda ama sambat Ablaamdok plon kusei kɨmɨpi bɨkap Devittok plon talelak wɨn 14, tɨmbi sambat wɨndɨñgangot Devittok plon kusei kɨmɨpi bɨkap Babilon ñañgɨlɨñ endok plon talelak wɨn 14, tɨmbɨ walinin ama sambat nombo inda-ta-bɨumbi, Mesia indañguk endok kunakunatsɨ wɨn bo 14got. ");
INSERT INTO nif_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesu Mesia indañguk wolok kasat wɨn ñɨndɨñ. Endok meñ Malia Josepta gɨñgɨt wɨlɨmɨñgɨlɨñ. Endɨ gama yakan nɨm kuñɨlɨmbi, Dɨndɨm Woñdɨ kundit tɨmbɨmbi, Malialɨ gwañgwa mɨnjɨp tɨñguk. Wɨndɨñ indañmɨñguk wɨn inda-dakleumbi, ");
INSERT INTO nif_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","gɨñgɨtñɨn Josep endɨ biup nandɨñguk. Gan endɨ ep tɨndɨn kɨndem kuñgukta siñgi mayek nɨm mɨup nandɨñɨpi, gitakan biup nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wɨndɨñ tɨmbepi nanandɨ kena tɨ-kuñɨlɨmbi, Wopum Anutulɨ añelo no nɨ-mulɨmbi, lat plon indañmɨmbi nɨñguk, “Josep, ama wapmañ Devit endok komblin, dɨk ñɨndɨñ nandɨ: Malia gwañgwa mɨnjɨp tɨlak wɨn Dɨndɨm Woñ endoññan nanin, wala tɨmbi dɨk en tamga tɨmbep nɨm mɨsɨwɨñ. ");
INSERT INTO nif_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Gwañgwa apmekak en wakan amatamñii yomjɨlok toptop plon nanin epmekak, wala tɨmbi koi Yesu kɨtɨukañ.” Añelolɨ wɨndɨñ nɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Wopumdɨ plofet ama no damañgan kuñguk endok man plon ñɨndɨñ indauktok eñguk, “Nandañ. Wembe sim ama gɨta gama nɨm douñguk nolɨ gwañgwa mɨnjɨp tɨmbi, gwañgwa apmɨumbi, endok koi Emanuel kɨtɨnekalɨñ.” (Kot wolok kusei wɨn ñɨndɨñ, ‘Anutulɨ nɨn gɨta kulak’). Manda walɨ bien indauktok nepek wɨndɨñ Malialoñ indañmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tɨmbi Joseptɨ dounan nanin mɨlapi, Wopumdok añelolɨ molo manda nɨñguk wolok tuop klembi tɨñguk. Endɨ tamɨn Malia nañgɨlɨmbi, ilnan ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tɨmbi endɨ wapat tamdok kuñgu gama nɨm kuñgɨmɨknan Malialɨ gwañgwa apmɨumbi, Joseptɨ gwañgwa wolok koi Yesu kɨtɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Elottɨ Juda amatamdok ama wapmañ palɨñɨlɨmbi, Yesu gwañgwalɨ Betleem it kwelan, Judia distrik wandɨñ indañguk. Tɨmbi soliña nandɨ-tale amalɨ maim lambɨlak kandañ nanin bɨmbi, Jelusalem it kwelan tombi ");
INSERT INTO nif_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","e-nandɨmbi eñgɨlɨñ, “Gwañgwa Juda amatamdok ama wapmañ kuuktok indak endɨ kwet delok patak? Nɨndɨ endok soliña maim lambɨlaknan indaumbi kañbi, ‘Mɨlelem tɨñmɨna’ embi kle bamɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tɨmbi ama wapmañ Elot endɨ manda wɨn nandɨmbi, nandum mɨlatañguk, tɨmbi amatam Jelusalem kuñgɨlɨñ gɨtɨk endɨ bo wɨndɨñgangot tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tɨmbi Elottɨ tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama kɨtɨ-semum bɨumbi e-nandɨ tɨmbi enguk, “Mesia endɨ it kwet delok sɨnɨk indauktok een?” ");
INSERT INTO nif_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eumbi tambane nɨñgɨlɨñ, “Betleem it kwelan, Judia distrik kandañ. Neta, plofet ama nolɨ Anutulok manda no ñɨndɨñ youp biñguk patak, ");
INSERT INTO nif_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betleem it kwet Judia kwelan, dɨkok kandañ telak dama no indambi, Islael amatamnai yanañgɨpi yambɨ-dɨkñeukak, wala tɨmbi dɨk Juda it kwet damandama tañ dɨwɨn endok pɨmbɨñ nɨm. Nɨm sɨnɨk.’” ");
INSERT INTO nif_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tɨmbi Elottɨ manda wɨn nandɨmbi, soliña nandɨ-tale ama telak gitak en-tiañeum bɨumbi, soliña walɨ dawanda sɨnɨk indañguk wolok en-nandɨ-kɨliñ eumbi nɨ-dakleñgɨlɨñ. Nɨ-dakleum nandɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Betleem ñanelɨñdok en-mupi eñguk, “Sɨndɨ ñambi, e-lonjɨ tɨ-kɨliñ embi, gwañgwa wɨn tɨmbɨ indanekalɨñ. Tɨmbɨ indaumbi, nombo undane bɨm nanbɨm nandɨmbi, nak bo wɨndɨñgangot ñambi, mɨlelem tɨñmetat.” ");
INSERT INTO nif_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wɨndɨñ eumbi, endɨ Jelusalem bimbi, Betleem ñañgɨlɨñ. Telak plon ñañɨpi, soliña maim lambɨlaknan kandañ kañgɨlɨñ walɨ bɨndambo inda-sembi, telak dama tɨ-semum ñambi, Betleem tomgɨlɨñ. Tombɨmbi, soliñalɨ gwañgwa pakuk it wolok plon ña kwambɨñ dam pakuk. ");
INSERT INTO nif_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Palɨm kañbi, walenjɨ kɨndem daumbi, sɨlɨsɨlɨ wopum sɨnɨk tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","it wolok gɨnañnan loñgɨlɨñ. Lombi, gwañgwalɨ meñat palɨmbi kañgɨlɨñ. Kañbi mɨlelem tɨ-ñɨmbi, nepek kusei kusei tuan loloñ mep bɨñgɨlɨñ wɨn jimbi, tɨmɨt pɨsapi, sɨmba kɨndemda mɨñgɨlɨñ. Wɨn gol wakɨt tuk mɨlɨñ kɨndem siñgin plon saplesaplelok, ba nepek mɨlɨñ kɨndem sinjilok wandin mɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tɨmbi Anutulɨ doulat plon Elottok kandañ nɨm undane ñanelɨñdok molo manda enbɨmbi, endɨ telak tambon nolok isɨ kuseinan ñanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Soliña nandɨ-tale amalɨ ña-taleumbi, Wopumdok añelo nolɨ doulat plon Joseptoñ indañmɨmbi nɨñguk, “Ama wapmañ Elot endɨ mik amañii gwañgwa ñɨn lonjɨmbi wɨlɨ kɨmnelɨñdok en-mulepi tɨlak. Wala tɨmbi dɨk mɨlapi, gwañgwa meñat yanañgɨlɨmbi, Isip kwelan pi ñambi, wandɨñ kunekalɨñ, nak undane bɨmbɨlok ganbetat wolok tuop.” ");
INSERT INTO nif_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Eumbi, Joseptɨ mɨlapi, gwañgwa meñat yanañgɨlɨmbi, tim Isip kwelan ñanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ñambi, wandɨñ pat-ta-kuumbi, Elottɨ sembɨñguk. Wopumdɨ plofet ama nolok man plon ñɨndɨñ indauktok eñguk, “Nɨñana Isip kwelan kuumbi kɨtɨñmambi bɨñguk.” Wɨn manda walɨ bien indauktok wakan endɨ Isip kwelan ña kuñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Elottɨ soliña nandɨ-tale amalɨ juluñɨt tɨñmɨñgɨlɨñ wɨn ka-nandɨ-tombi, gimbɨt kolan tɨmbi, mik ama en-mulɨmbi, Betleem it kwelan ba kwet dɨwɨn ñasɨñgan pakañ wandɨñ ñañgɨlɨñ. Ñambi, gwañgwa gwɨlat tɨpet nɨm makleñgɨlɨñ wɨn gɨtɨk yandɨpmum kɨm-taleñgɨlɨñ. Neta, soliña nandɨ-tale amalɨ Elotta ñɨndɨñ nɨñgɨlɨñda tɨmbi, “Nɨndɨ soliña wɨn ka-ta-bɨnambi, gwɨlat tɨpet tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nepek wɨndɨñ indaumbi, plofet Jelemaialɨ manda ñɨndɨñ eñguk wolok bien inda-dakleñguk, ");
INSERT INTO nif_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rama it kwelan kwawa indaumbi, mano kwɨlɨm wopum tañ. Wɨn Resellok komblinñii endɨ gwañgwanjii gɨtɨk kɨm tale-sɨnɨk tañgɨlɨñda kut-blambla eumbi, binelɨñdok en-busumbusuk tɨ nɨm ka biañ.” ");
INSERT INTO nif_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ama wapmañ Elottɨ sembɨñgukta, Wopumdok añelo nolɨ Joseptoñ Isip kwelan lat plon indañmɨmbi nɨñguk, ");
INSERT INTO nif_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Gwañgwa wɨlɨ kɨmbektok eñgɨlɨñ endɨ ip gɨtɨkkan kɨm-taleñgɨlɨñ, wala tɨmbi dɨk mɨlapi, gwañgwa meñat yanañgɨlɨmbi, Islael kwelan undane ñawɨt.” ");
INSERT INTO nif_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Eumbi mɨlapi yanañgɨpi, Islael kwelan undane bɨñguk. Bɨ tombi, ");
INSERT INTO nif_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","‘Elottok nɨñañ Akelao endɨ beulok kɨnjan Judia distriktok ama wapmañ indambi yambɨ-dɨkñelak’ gɨñgɨt wɨn nandɨmbi, kwet wandɨñ ña kuupi mɨsɨñguk. Gan lat plon molo manda nandɨmbi, Galili distrik wandɨñ ñambi, ");
INSERT INTO nif_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","it kwet no koi Nasalet wandɨñ ña pat-kuñguk. Plofet amalɨ Mesiala “Nasalet ama nɨnekalɨñ” eñgɨlɨñda tɨmbi Joseptɨ wandɨñ ña papi kuñɨlɨmbi, manda walɨ bien indañguk. ");
INSERT INTO nif_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Yesulɨ gama Nasalet it kwelan kuñɨlɨmbi, Yoane amatam tuk i-semlɨñguk endɨ Judia distrik wandɨñ kwet sɨlanin kambaññan wandinnan ña kuñɨpi, amatam gɨñgɨt manda ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Nain nɨm ombataumbi, Kunum Molomdɨ amatam gɨtɨk indañgan yambɨ-dɨkñeukak, wala tɨmbi sɨndɨ tɨ-pañgɨpañgɨlembi, gɨnañjɨ tambanewɨt!” ");
INSERT INTO nif_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wɨn Yoanelañgan plofet Aisaialɨ manda ñɨndɨñ embi youkuk patak, “Kwet kambaññan sɨlaninnan ama nolɨ ñɨndɨñ kɨtɨlak, ‘Wopumdok telak tɨ-ñɨmbi, tɨ-dɨndɨme kena tɨñmɨnekalɨñ.’” ");
INSERT INTO nif_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoanelɨ plofet ama no nomɨk dasidasin kamel domdɨ tɨndɨn wɨn dasimbi, boñgɨunan bɨt gwɨlaptɨ tembi pa kulɨñguk. Tɨmbi endok nanañ wɨn gotak gɨta bupit tuk koñgom kli gɨnañ nanin epbi pa nalɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tɨmbi Jelusalem it kwet ba Judia distrik ba Jodan tuk tombo tombonan nanin amatam asupgandɨ endoñ bɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","yomjɨ e-jamilaumbi, Jodan tuknan gɨnan tambatambatok tuk i-semlɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tɨmbi endɨ Falisi ba Sadusi ama asup tuk inepi bɨum yambɨmbi, ñɨndɨñ enguk, “Sɨndɨ ama manjɨ manbenjɨ malet upmat nomɨk. Anutulɨ kolanjɨlok tuan ombɨ-samepi tɨlak. Sɨndɨ nokoñ bɨmbi, ñɨndɨñ nandañ ba, ‘Tuk inetamɨñda, endok gɨmbɨt wɨlambane-kotnetamɨñ’? Nanandɨnjɨ walɨ bien nɨm tɨlak! ");
INSERT INTO nif_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sɨndɨ gɨnañjɨ tambaneñgɨlɨñda, wolok tuom ep tɨndɨnjɨ kɨndem wolok bien daut nɨmumbi kana! ");
INSERT INTO nif_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nɨm kañbi, gɨnañjɨlɨ manda juluñ ñɨndɨñ enelɨñ, ‘Nɨndɨ Ablaamdok sambatta tɨmbi kolandok kɨnjan nɨm tɨkenekamɨñ.’ Nak sanba nandɨwɨt: Anutulɨ gumañ eumbi, sɨndok kɨnjan kawat ñalɨ Ablaamdok sambat indanelɨñ! ");
INSERT INTO nif_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kapinoñgo ipkan komba kuseinan kɨmɨkɨmɨlɨn patak, wala tɨmbi kombalɨ bien kɨndem nɨm pa laliyañ wɨn gɨtɨk jɨnɨmbi, komba gɨnañ silok. ");
INSERT INTO nif_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Amatam dɨwɨsɨlɨ gɨnañjɨ tambaneñgɨlɨñ wɨn sambɨ-nandɨnelɨñdok nak tukgot i-samlet. Gan ama no siñgina kandañ indaukak endɨ Dɨndɨm Woñ gɨt komba dɨndɨn i-samekak. Endɨ loloñ sɨnɨk, nak kambak ñandin ñalɨ kesi gwɨlap kiundɨlɨmettok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Endɨ amatam kɨndem ba kolan ep danbepi tɨlak, wɨn amalɨ plaua nanañ mɨnjɨp gɨt gwɨlap ep danbi, bien wɨsɨ-kopi, gwɨlap ba kɨlɨkɨlɨk siu dɨlak, wɨndɨñgangot ama walɨ kɨndesɨ epbi, kolasɨ komba kɨmkɨm nɨmnat gɨnañ ep siu dɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nain wolonda Yesulɨ Galili distrik bimbi, Jodan tuknan ña tombi, Yoanelɨ tuk iñmektok nɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Gan Yoanelɨ Yesulok kusei ka-nandɨ-tombi, “Wɨndɨñ nɨm” embi, kɨmɨsip ñɨmbi nɨñguk, “Dɨk mek nak tuk i-nameñ ñak. Nɨtekta tɨmbi nokoñ bɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gan Yesulɨ tambane nɨñguk, “Man ñɨndɨñgɨt nandɨ-nambi, nak elet wɨndɨñ tɨ! Wɨndɨñ tɨñɨpi, Anutulɨ dɨndɨm kuñgula elak wɨn tuopkan kɨmɨt-klendetamɨk.” Wɨndɨñ eumbi nandɨñɨmbi, gɨnan tambatambattok tuk iñmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iñmɨ-taleumbi, wolongan tuk pawan lambɨ ipi kañguk wɨn: kunum tombɨmbi, Anutulok Woñdɨ mambaip wandin endok plon pɨumbi kañguk. ");
INSERT INTO nif_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kañɨlɨmbi, kunum gɨnañ nanin manda no ñɨndɨñ kɨtɨu pɨumbi eñguk, “Ñɨne nokok nɨñana sɨnɨk. Nak gɨnañnalɨ en kasɨlembi, nandɨ-koñgom tɨñmɨlet.” ");
INSERT INTO nif_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yesulɨ tuk i-taleumbi, Satandɨ tɨ-kuyuk tɨñmektok Dɨndɨm Woñdɨ en nañgɨlɨmbi, kwet kambaññan sɨlaninnan ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ñambi, tim sandap 40 nanañ gɨtɨk kɨmɨsip tɨ-talembi, nanañ gawat kuñguk. ");
INSERT INTO nif_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tɨmbi tɨ-kuyuk amalɨ endoñ bɨmbi nɨñguk, “Tɨkap dɨk Anutulok Nɨñañ sɨnɨk kulañda, kusaka tɨmbɨ dakleuktok kawat ñɨ pakañ enbɨmbi, kɨnjan nanañ indawɨt.” ");
INSERT INTO nif_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eumbi, mandan wɨlambane-kopi tambane nɨñguk, “Anutulok mandan ñɨndɨñ youyoulɨn patak, ‘Nanañlɨñgot kuñgu nɨm mɨlak. Nɨm. No en Anutulok man mandan kɨmɨt-klembi tañgonelakta endɨ wakan kuñgunat tɨlak.’” ");
INSERT INTO nif_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wɨnaña Satandɨ Yesu nañgɨpi, Anutulok it kwet, Jelusalem, wandɨñ ñambi, tapma it pendɨm malap plon lo kɨmɨpi ");
INSERT INTO nif_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","nɨñguk, “Ale. Dɨk Anutulok Nɨñañ sɨnɨkta, dɨkopi ma pɨ! Nekta, manda ñɨndɨñ youyoulɨn patak, ‘Anutulɨ añeloñii gambɨ-dɨkñenelɨñdok enbɨmbi, dɨkok pɨuñda kɨsɨlɨ gepmumbi, kawat nolɨ kesɨka no nɨm youlekak.’” ");
INSERT INTO nif_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Eumbi, Yesulɨ tambane nɨñguk, “Nɨm. Manda nombo ñɨndɨñ youyoulɨn patak, ‘Dɨk Molomga Anutu endok gembɨn inda-dakleuktok tɨ-kuyuk nɨm tɨñmekañ.’” ");
INSERT INTO nif_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wɨndɨñda Satandɨ nombo nañgɨpi, kwet jañgɨn ombap sɨnɨk no wolok plon lo kɨmɨpi, kwet gɨtɨk wolok gembɨn ba paman daulɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Daulɨmbi nɨñguk, “Tɨkap dɨk naka mɨlelem tɨ-nambi, nan-wowoñ tɨmbetañda, nepenepek kalañ ñɨn gɨtɨk sɨnɨk dɨkok bi-gametet.” ");
INSERT INTO nif_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Eumbi nɨñguk, “Satan, dɨk nambimbi ñau! Manda ñɨndɨñ youyoulɨn patak, ‘Dɨk Molomga Anutu en noñganda mɨlelem tɨ-ñɨmbi, kuñguñga endok gɨñgɨt wɨlɨmekañ.’” ");
INSERT INTO nif_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yesulɨ wɨndɨñ eumbi, Satandɨ kak bim ñaumbi, añelolɨ bɨm tɨmbɨ platañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","‘Yoane tɨkembi, it kwambɨñ gɨnañ kɨmɨlɨm patak’ gɨñgɨt walɨ Yesulok pawañ gɨnañ pɨumbi, nain wolondañgan endɨ Judia distrik bimbi, Galili distrik undane ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Gan endɨ il kusei Nasalet wandɨñ nɨm kuñguk, endɨ Kapaneam it kwelan pit mɨlat tɨmbektok wandɨñ ñambi kuñguk. It kwet wɨn Galili tuk guañ baliliñ patak. Kwet wɨn sambat tɨpettoñ, wɨn Sebulon gɨt Naptali, endok kweset. ");
INSERT INTO nif_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Plofet amalɨ nepek indauktok eñguk wɨn inda-dakleuktok Yesulɨ Kapaneam ñañguk. Neta, plofet Aisaialɨ ñɨndɨñ youkuk, ");
INSERT INTO nif_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulon gɨta Naptali endok kweset, wɨn Galili kwet, wandɨñ amatam asuptɨ kuañ, Judalok sambat endɨñgot nɨm. Kwet wɨn telak Galili tuk guañnan ñalak wandɨñ patak, Jodan tuk tambon kandañ. Amatam wandɨñ kuañ enda ñɨndɨñ elet: ");
INSERT INTO nif_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","amatam yomjɨlok kɨlɨm gɨnañ kuañ enda Anutulɨ enlok kolsalen wopum kolɨ sale-semguk, tɨmbi kɨmkɨmlok gɨñgɨt kuañ endok kañdañ bo saleñguk.” ");
INSERT INTO nif_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yesulɨ wandɨñ ña tombi, kusei kɨmɨpi, gɨñgɨt manda ñɨndɨñ eu pɨñguk, “Nain nɨm ombataumbi, Kunum Molomdɨ amatam gɨtɨk indañgan yambɨ-dɨkñeukak, wala tɨmbi sɨndɨ tɨ-pañgɨpañgɨlembi, gɨnañjɨ tambanewɨt!” ");
INSERT INTO nif_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Tɨmbi nain nola Yesulɨ Galili tuk guañ baliliñnan ñañɨpi, pis tiatia ama tɨpet, dakwaya yambɨñguk, wɨn Simon koi no Petlo, tɨm kwayañ Andlu. Endɨ guañnan pis tiatia lɨkset kop palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesulɨ yambɨm enguk, “Sɨtɨ bɨmbi, nak nep kle-kuumbi, nak ama tiatia kena san-daut tɨ-sametat.” ");
INSERT INTO nif_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Eumbi, wolongan lɨkset bimbi, Yesu kle ña en gɨta kuñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tɨmbi Yesulɨ yousɨ ñañɨpi, ama dakwayañgot tɨpet nombo ep tɨmbɨ indañguk, wɨn Sebedilok nɨñañiit Yakobo gɨt kwayañ Yoane. Endɨ beset Sebedi gɨt kɨkeñ plon papi, pis tiatia lɨksɨ gɨlɨne-pakɨlɨñ. Tɨmbi Yesulɨ kɨtɨ-semumbi, ");
INSERT INTO nif_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","wolongan beset gɨt kɨkeñ kak bimbi, Yesu kle ña en gɨta kuñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tɨmbi Yesulɨ Galili distrik tuop kle-gɨmbut kuñguk. Kuñɨpi, amatam it kiyaunjɨ gɨnañ enɨ-daut tɨ-sembi, Anutulɨ amatam nɨtek yambɨ-dɨkñelak wolok gɨñgɨt manda kɨndem eu pɨumbi, amatam jɨmbat kusei kusei inda-semguk ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Endɨ wɨndɨñ tɨmbɨmbi, koi gɨñgɨttɨ Silia provins tuop pɨndɨ dañguk. Tɨmbi amatamdɨ jɨmbatsɨat gɨtɨk endoñ yanañgɨpi bɨñgɨlɨñ, wɨn ama jɨmbat ba pɨñgɨp gawat kusei kusei inda-semguk, ba ama yal kolanjɨat, ba ama kɨm katap tañgɨlɨñ, ba ama kesɨt kuñgulok tuop nɨm gɨtɨkkan endoñ yanañgɨp bɨumbi, ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tɨmbi amatam kɨmɨn wopum Galili nanin, ba Dekapolis, Jelusalem, Judia, ba Jodan tuk tambon kandañ nasi endɨ endoñ pa bɨmbi kle kuañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tɨmbi Yesulɨ ama kɨmɨn wopum kle kuñgɨlɨñ yambɨmbi, kwet kɨmɨnnan lombi pipakuk. Pipalɨmbi, gwañgwañiilɨ endoñ bɨm kɨmɨn tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","kusei kɨmɨpi, ñɨndɨñ enɨ-daut tɨ-sembi enguk, ");
INSERT INTO nif_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Amatam Anutulok dainan nɨsɨla nandum pɨmbɨñen tɨlak endɨ wakan Kunum Molomdɨ yambɨ-dɨkñelak, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tɨ-blamblae tɨmbi mano tɨ-kuañ endɨ wakan Anutulɨ en-busumbusuk tɨ-semekak, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kayombɨnembi kuañ endɨ wakan Anutulɨ kwet gɨtɨk endok gɨñgɨt wɨsem-taleñguk wɨn kasɨlenekalɨñ, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anutulok dainan dɨndɨm kunelɨñdok nandɨ-koñgom wopum tañ endɨ wakan Anutulɨ ep tɨmbɨ plap taumbi, wolok tuop tɨnekalɨñ, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nosiila gɨnañ busuk tɨ-semañ enda wakan Anutulɨ wɨndɨñgot gɨnañ busuk tɨ-semekak, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Gɨnañjɨ Anutulañgot biñmañ endɨ wakan kunum gɨnañ ñambi, Anutu kanekalɨñ, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mik gimbɨt nain plon kulan busuk tɨmbɨ indañ endɨ wakan Anutulɨ ‘wembe gwañgwanai’ enbekak, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Amatam Anutulok man tañgoneañda tɨmbi, mɨlap kusei kuseilɨ inda-semlak endɨ wakan Kunum Molomdɨ yambɨ-dɨkñelak, wala tɨmbi endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Kwapme kwapme amatamdɨ sɨndɨ gɨñgɨtnai kuañda tɨmbi kosɨ tɨmbɨ kolaumbi, mɨlap kusei kusei sambi, juluñɨt manda kolan kusei kusei sɨndok plon embi, siñgiñjɨ siañ, nain wolonda sɨndɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Neta, tuanjɨ wopum kunum gɨnañ pat-samlak, wala tɨmbi walenjɨ kɨndem daumbi, sɨlɨsɨlɨ tɨnekalɨñ. Amatamdɨ plofet ama damañgan kuñgɨlɨñ enda bo wɨndɨñgangot mɨlap kusei kusei tɨ-semmañgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesulɨ yousɨmbi, gwañgwañiila ñɨndɨñ enguk, “Palañdɨ kena tɨlak wolok tuop sɨndɨ amatam gɨtɨktok boñgɨpsɨnan wɨndɨñgangot tañ. Gan palañdok koñgom pɨ-taleumbi, nek ñala bɨndambo koñgom dawɨk? Wɨndɨñ tɨndɨlok tuop nɨm. Palañ wandin walɨ kena nɨmnat, wɨn slak kwet plon yalɨmulɨm ñaumbi, ama kesɨsɨlɨ yali-pañgɨpmañ. ");
INSERT INTO nif_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","It kwet no jañgɨnnan indañgan palɨmbi, nepek nolɨ nɨm masipmek. Wɨndɨñgangot sɨndɨ kwelalok amatam endok kolsalen. ");
INSERT INTO nif_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ama nolɨ kolsalen pɨndopi, kambottɨ tapliwɨk ba? Nɨm a. Endɨ wɨn indañgan kɨmɨlɨmbi, it gɨnañnan pit mɨlat tañ gɨtɨk enda kolɨ sale-semlak. ");
INSERT INTO nif_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Wɨndɨñgangot sɨndok kolsalenlɨ amatam kolɨ sale-semsemlok. Kusei ñɨndɨñda wɨndɨñ tɨlok: endɨ sɨndok kunditsɨ kɨndem ka-nandañda tɨmbi, Bepsɨ kunum gɨnañ patak en nɨ-kɨndem danekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yesulɨ yousɨmbi enguk, “Sɨndɨ naka ñɨndɨñ nɨm nandɨ-nambi enekalɨñ, ‘Anutulɨ endɨkñe manda Moselok kiinan kɨmɨt-nɨmguk, tɨmbi plofet amalɨ manda nɨnɨ-daut tɨ-nɨmgɨlɨñ. Yesulɨ manda wakan wialektok indañguk.’ Sɨndɨ wɨndɨñ nɨm enekalɨñ. Nak manda wɨn wialettok nɨm indañgut, tambo nak wolok kusei tɨmba inda-dakleuptok indañgut. ");
INSERT INTO nif_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nak biañgan sɨnɨk sanba: kunum kwet patekamɨk tuop endɨkñe manda youp bimbin pakañ walɨ gɨtɨk papat kwambɨñ patnekalɨñ. Wɨn Anutulɨ nepek indauptok elak wɨn gɨtɨk gama nɨm indañɨlɨmbi, endɨkñe manda lakat sɨnɨk nolɨ bo no nɨm paitnekalɨñ. Nɨm sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wɨndɨñda tɨkap sɨndɨ endɨkñe manda lakat sɨnɨk wandin no lapɨpi, amatamdɨ wɨndɨñgangot tɨnelɨñdok enɨ-daut sem tɨ-semañ, Kunum Molomdɨ sɨnda nandum gɨñgɨtñiilok boñgɨpsɨnan pɨmbɨñen sɨlanin sɨnɨk tɨlak. Gan tɨkap sɨndɨ endɨkñe manda gɨtɨk tañgonembi, amatamdɨ wɨndɨñgangot tɨnelɨñdok enɨ-daut sem tɨ-semañ, Kunum Molomdɨ sɨnda nandum gɨñgɨtñiilok boñgɨpsɨnan loloñ tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yesulɨ yousɨmbi enguk, “Dɨndɨm kuñgula nak ñɨndɨñ sanlet: endɨkñe manda nandɨ-tale ama gɨt Falisi ama endɨ endɨkñe manda youyoulɨn patak wɨn gɨtɨk kɨmɨt-kle-kɨliñ eañ. Tɨkap sɨndɨ ama wɨn nɨm yapma klembi, Anutu nɨtek kunelɨñdok nandɨlak wɨndɨñ nɨm kunekalɨñda, sɨndɨ Kunum Molomdok gɨñgɨtñii nɨm indanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sɨndɨ ama damasɨla manda ñɨndɨñ enɨenɨn wɨn nandɨ-taleañ, ‘Dɨk ama no nɨm wɨlɨ kɨmbekak. No en ama no wɨlɨ kɨmbekakta, endɨ manda plon kɨmɨttok.’ ");
INSERT INTO nif_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Gan natna ñɨndɨñ sanlet: no en nolla gimbɨt tɨlakta, en manda plon kɨmɨttok. Ba no en nol manda winjɨt nɨmbi nɨ-suambatak, en wakan ka-dɨkñelok mɨn wopum gɨnañ kɨmɨttok. Ba no en nol ñɨndɨñ nɨlak, ‘Dɨk ama kamen sɨnɨk’, endɨ jɨmbɨñdok komba gɨnañ nɨ-muttok. ");
INSERT INTO nif_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wala tɨmbi dɨk tapma tɨmbepi sisuetnan ña ipi, nokalɨ nandɨ-kola tɨ-gamek wɨn nandɨ-sɨwɨtañda, ");
INSERT INTO nif_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kak, nepenepeka sisuet kuseinan kɨmɨpi, dɨndɨmgan ña noka tɨmbɨ indaumbi, en gɨta manda e-sale tɨmbi, not busuk tɨndekamɨk. Wɨndɨñ tɨ-tale-bimek, kɨndem ñambi tapma tɨmbekañ. ");
INSERT INTO nif_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ba tɨkap ama nolɨ manda plon gapɨlep tɨlakta, sɨtɨ telak plon yakan ñandemɨk, wolondañgan plapkan sɨnɨk tambon tɨ-dɨndɨmelok manda en gɨta eum dɨndɨm eukak. Nɨm kañbi, ama walɨ kañ-dan amalok kiinan gapɨlɨmbi, kañ-danlɨ bo tem dumanlok kiinan gapɨlɨmbi, endɨ gepmbi, it kwambɨñ gɨnañ gapɨlek. ");
INSERT INTO nif_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nak biañgan sɨnɨk ganba: dɨk it kwambɨñ gɨnañ papi, mɨnem ombɨ-mɨlok een wɨn ombɨ-taleumek gambiumbi pɨukañ. ");
INSERT INTO nif_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Manda ñɨndɨñ damañgan een wɨn sɨndɨ nandɨ-taleañ, ‘Dɨk ama nolok tamɨn gɨta telak joñgo nɨm kuukañ.’ ");
INSERT INTO nif_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Gan natna ñɨndɨñ sanlet: ama nolɨ tam no ka-galkta tɨlakta, en wakan ikan enlok gɨnan nanandɨn gɨnañ tam wɨn en gɨta telak joñgo kulak. ");
INSERT INTO nif_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wɨndɨñda tɨkap dauka tombonlɨ gep tiañeumbi, yomdok sɨsoñ plon pi pɨwɨñ ñala dauka wɨn gɨtnei kopi, dauka tombongot kuukañ. Nɨm kañbi, gwɨlapka gɨtɨk jɨmbɨñ gep kolɨm pɨuñ a. ");
INSERT INTO nif_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ba tɨkap kɨka tombonlɨ gep tiañeumbi, yomdok sɨsoñ plon pi pɨwɨñ ñala kak dombɨ kopi, kɨka tombongot kuukañ. Nɨm kañbi, gwɨlapka gɨtɨk jɨmbɨñ ñauñ a. ");
INSERT INTO nif_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Tɨmbi damañgan ñɨndɨñ pa eñgɨlɨñ, ‘No endɨ tamɨn kle-kolep tɨlakta, wolok tuop kundit yout daklembi mɨukak.’ ");
INSERT INTO nif_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Gan natna ñɨndɨñ sanlet: tam telak joñgo nɨm kuñguk en slakan nɨm kle-kokottok. Neta, ama no en tamɨn wandin kle kolɨmbi, wapai komblin tɨkewɨkta, ama walɨ tamɨn wakɨt endok wapai komblin yom plon yapɨlɨmbi, telak joñgo kundemɨk. ");
INSERT INTO nif_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Sɨndɨ ama damasɨla ñɨndɨñgangot enɨenɨn wɨn nandɨ-taleañ, ‘Dɨk manda e-kwambɨñ dañguñ wɨn nɨm maklembi tambɨlekañ. Dɨk Wopumdok dainan nepek nek tɨndɨlok e-top tɨñguñ wolok tuop tɨmbekañ.’ ");
INSERT INTO nif_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Gan natna ñɨndɨñ sanlet: e-kwambɨnda manda no nɨm enekalɨñ, wɨn kunum ba kwet ba Jelusalem wolok plon nɨm enekalɨñ. Ñɨndɨñda: kunum gɨnañ Anutulɨ pipapi, amatam yambɨ-dɨkñelak, tɨmbi kwettɨ wɨn kesilok gembañ tɨmbɨmbi, kesi wolok plon kɨmɨtak. Tɨmbi Jelusalem wɨn Ama Wapmañ wopum endok il kwel. ");
INSERT INTO nif_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tɨmbi dɨk kumbañga sak bip ba satnin tɨmbɨ indauktok tuop nɨm, wala tɨmbi kumbañgala bo nɨm e-kwambɨñ daukañ. ");
INSERT INTO nif_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ama nolɨ nepek nola san-kaumbi, dɨndɨmgan tambanembi, ‘Oñ’ ba ‘Nɨm’ nɨnekalɨñ. Tɨkap sɨndɨ mandanjɨ tɨmbɨ kwambɨñ danelɨñdok nandañ wɨn Kolan Molomdok kandañ nanin bɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yesulɨ yousɨmbi enguk, “Sɨndɨ manda ñɨndɨñ damañgan een wɨn nandɨ-taleañ, ‘No en ama nolok dai tɨmbɨ kolaukta, endok dai bo tɨmbɨ kolalok. Ba no en ama nolok man kwandai wɨlɨ gɨloñmekta, endok man kwandai bo wɨlɨ gɨloñmɨlok.’ ");
INSERT INTO nif_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Gan natna ñɨndɨñ sanlet: ama no kolan tɨ-samumbi, tambon nɨm ombɨñmɨnekalɨñ. Nɨm sɨnɨk. Tambon sɨndɨ ñɨndɨñ tɨnekalɨñ: tɨkap ama nolɨ bumga tombon wɨlekta, tombon wɨndɨñgot wɨlektok tambaneñmekañ. ");
INSERT INTO nif_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ba tɨkap ama nolɨ kiupɨñga kasɨleuktok manda plon gapɨlepi nandɨlakta, sauloñga wɨndɨñgot biñmekañ. ");
INSERT INTO nif_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ba tɨkap ama nolɨ kaikan gan-gɨñgɨnembi, nepenepelɨ wɨn kwet kɨmɨn noñgan wolok tuop bembi ñañmeñdok elakta, dɨk kwet kɨmɨn tɨpet wolok tuop bembi ñañmekañ. ");
INSERT INTO nif_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ba tɨkap ama nolɨ nepek nola gan-nandɨ tɨlakta mɨukañ, ba nepeka no nain dumangot tɨke-kuup ganlakta nandɨñmekañ. ");
INSERT INTO nif_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Sɨndɨ damañgan ñɨndɨñ een wɨn nandɨ-taleañ, ‘Dɨk nokala gɨnañ kɨndem tɨñmekañ, tɨmbi kanjɨkkala nandɨ-kola tɨñmekañ.’ ");
INSERT INTO nif_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Gan natna ñɨndɨñ sanlet: kanjɨksiila gɨnañ kɨndem tɨ-semnekalɨñ, ba ama mɨlap kusei kusei tɨ-samañ enda Anutulɨ gwɨlam tɨ-semektok nɨmolo tɨ-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wɨndɨñ tɨñɨpi, sɨndɨ kunum Bepsɨlok wembe gwañgwa kuañ wɨn inda-dakleukak. Neta, endɨ ama gɨtɨkkan, wɨn ama kɨndem mandan kɨmɨt-kleañ wakɨt ama kolan mandan wɨkañ enda gɨtɨk maim kolɨ sale-sembi, gwi nɨ-mut-semlak. ");
INSERT INTO nif_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tɨkap sɨndɨ ama gɨnañ kɨndem tɨ-samañ endañgot gɨnañ kɨndem tɨ-semnelɨñda, nektok kuseila Anutulɨ tambon ombɨ-samek? Wɨn takis epep ama kolan endɨ bo telak wakangot kleañ wɨn! ");
INSERT INTO nif_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ba tɨkap sɨndɨ nosiilañgot not tɨ-semañda, kunditsɨ walɨ amatam dɨwɨn endok kunditsɨ nɨtek maklewɨk? Amatam Anutu nɨm nandɨñmañ endɨ bo wɨndɨñ nɨm tañ ba?” ");
INSERT INTO nif_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yesulɨ wɨndɨñ embi yousɨmbi, dɨndɨm kuñgula manda eñguk wolok bien wɨn ñɨndɨñ enguk, “Kunum Bepsɨlok gɨnan nanandɨn ba ep tɨndɨn wɨn gɨtɨk kɨndem ba dɨndɨm sɨnɨkgot. Wɨndɨñda tɨmbi sɨndok gɨnañ nanandɨnjɨ ba ep tɨndɨñjɨ bo gɨtɨk kɨndem ba dɨndɨm sɨnɨkgot palekak.” ");
INSERT INTO nif_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesulɨ yousɨmbi, gwañgwañiila enguk, “Sɨndɨ gɨnañjɨ tiptok kena tɨñɨpi ka-kɨliñ embi, amatamdok dausɨnan ep tɨndɨnjɨ sambɨ-daklenelɨñdok nɨm tɨnekalɨñ. Nɨm kañbi, Besɨ kunum gɨnañ patak endɨ tuanjɨ tambon nɨm ombɨ-samek. ");
INSERT INTO nif_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ama manjɨ manbenjɨ malet nomɨk endɨ it kiyau gɨnañ ba ipaka boñgɨpnan gɨñgɨlɨ wopumgan tɨñɨpi, mɨnem nepenepek ama pɨmbɨñesɨla emañ, wɨn amatamdɨ kosɨ gɨñgɨt tɨke-lonelɨñdok wɨndɨñ tañ. Nak biañgan sanba: endɨ tuanjɨ ikan kasɨle-taleañ. Wala tɨmbi nain nola ba nola dɨk plap kena tɨñɨpi, wɨndɨñ nɨm tɨmbekañ. ");
INSERT INTO nif_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","Dɨk ama pɨmbɨñesɨ ep kɨmɨlɨñɨpi, plap kenañga tɨlañ walɨ dausɨnan sembɨn palektok dɨk kɨka dɨndɨmdɨ nek tɨlak wɨn kɨka kepmala nɨm nɨmbekañ. Tɨmbi Bepkalɨ nepek dausɨnan sembɨn indalak wɨn kalakta endɨ tuan ombɨ-gamekak. ");
INSERT INTO nif_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ama manjɨ manbenjɨ malet nomɨk endɨ it kiyau gɨnañ ba telak balambalak ba pañga indanan ipi, nɨmolo tɨnepi nandañ, wɨn amatamdɨ yambɨ-daklenelɨñdok wɨndɨñ tañ. Nak biañgan sanba: endɨ tuanjɨ ikan kasɨle-taleañ. Wala tɨmbi nain nola ba nola dɨk nɨmolo tɨñɨpi, wɨndɨñ nɨm tɨmbekañ. ");
INSERT INTO nif_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Dɨk nɨmolo tɨmbepi, dɨtnañgan doundou ika gɨnañ lombi, yamañga sipbi, Bepka kwet sembɨn patak enda nɨmolo tɨñmekañ. Tɨmbi Bepkalɨ nepek dausɨnan sembɨn indalak wɨn kalakta endɨ tuan ombɨ-gamekak. ");
INSERT INTO nif_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Amatam anutu juluñgan nɨmolo tɨ-semañ endɨ manda sɨlanin asup pinapi, ‘Nɨmolo ombapnɨla nandɨ-nɨmetak’ wɨndɨñ nandɨñɨpi pa tañ. Gan sɨndɨ nɨmolo tɨnepi, ");
INSERT INTO nif_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","endok nɨmolonjɨlok telal nɨm klenekalɨñ. Sɨndɨ Bepsɨla nepek nola gamañ nɨm nɨ-nandɨñɨlɨmbi, nekta lonjɨañ wɨn endɨ ikan nandɨ-talelak. ");
INSERT INTO nif_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wɨndɨñda nɨmolo ñɨndɨñ tɨnekalɨñ, ‘Kunum Bepnɨ, dɨkok koka wɨn giñgiñgan tɨ-gamlok. ");
INSERT INTO nif_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dɨk amatam gɨtɨk nɨp tɨmbɨ gɨñgɨtgai indambi, kunum gɨnañ kuañdɨ mañga tañgoneañ wɨndɨñgangot nɨndɨ kwelan ñolok tañgoneneñ. ");
INSERT INTO nif_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Dɨk nanañ sandap ñolok tuop nɨmɨñ. ");
INSERT INTO nif_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nɨndɨ amatamdɨ yom tɨ-nɨmañ wɨn bi-semamɨñ, wɨndɨñgangot dɨk yomnɨ bi-nɨmɨñ. ");
INSERT INTO nif_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dɨk tɨ-kuyuk plon nɨm nɨmbiwɨñ, tambo kolandok kiinan nanin nɨpmɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Nandañ. Sɨndɨ amatam ep tɨndɨnjɨ kolan wɨn bi-semnelɨñda, Bepsɨ kunum gɨnañ patak endɨ bo sɨndok yomjɨ bi-samekak. ");
INSERT INTO nif_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Gan, tɨkap sɨndɨ amatam ep tɨndɨnjɨ kolan nɨm bi-semnelɨñda, Bepsɨ endɨ bo ep tɨndɨnjɨ kolan nɨm bi-samekak.” ");
INSERT INTO nif_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tɨmbi Yesulɨ yousɨmbi enguk, “Ama man manbenjɨ malet nomɨk endɨ nanañ gɨtɨk kɨmɨsip tɨñɨpi, dei blamblae ba tɨ-kolakola embi, nanañ kɨmɨsip tañ wɨn amatam dausɨnan inda-daklenelɨñdok. Nak biañgan sanlet: endɨ tuanjɨ ikan kasɨle-taleañ. Wala tɨmbi nain nola ba nola sɨndɨ nanañ gɨtɨk kɨmɨsip tɨndɨlok telak kɨmɨt-kleñɨpi, wɨndɨñ nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Dɨk nanañ gɨtɨk kɨmɨsip tɨñɨpi, tuk imbi, kumbañga sak youlekañ. ");
INSERT INTO nif_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Wɨndɨñ tɨmbeñda, dɨk nanañ kɨmɨsip tɨlañ wɨn Bepka kwet sembɨn patak en noñganlañgot inda-daklewɨñ, amatamda nɨm. Tɨmbi Bepkalɨ nepek dausɨnan sembɨn indalak wɨn kalakta endɨ tuan ombɨ-gamekak.” ");
INSERT INTO nif_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Tɨmbi Yesulɨ yousɨmbi enguk, “Kwelan ñolok kwɨnakam ba bapaptɨ nepenepek tɨmbɨ kolalak, tɨmbi kumbu amalɨ it wiapi, kumbu tañ. Wala tɨmbi sɨndɨ gwɨlaptok kenañgot tɨmbi, nepenepesɨ tuan wopum kwelan ñolok pat-samektok nɨm tɨ-jumɨt tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Tambon sɨndɨ tuanjɨ kɨndem wɨn kunum gɨnañ pat-samektok tɨ-jumɨt tɨnekalɨñ. Wɨn kunum gɨnañ kwɨnakam ba bapaptɨ nepek no nɨm tɨmbɨ kolalak, tɨmbi kumbu amalɨ bo it wiapi, kumbu nɨm tɨañ, wala tɨmbi tuanjɨ nɨm pailekak. ");
INSERT INTO nif_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kusei ñɨndɨñda tɨmbi wɨndɨñ tɨndɨlok sanlet: nepek nekta sɨnɨk nandum loloñ tɨlak walañgot gɨnañ nanandɨnjɨlɨ pat-samlak. ");
INSERT INTO nif_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Daut endɨ tipala nomɨk, endɨ pɨñgɨpnɨlok kolsalen. Tɨkap daukalɨ kɨndem patakta, kolsalenlɨ pɨñgɨpka gɨnañ gɨtɨk kolɨ salelak. ");
INSERT INTO nif_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Gan, tɨkap dauka kolanla, pɨñgɨpka gɨnañ gɨtɨk kɨlɨme-patak. Wɨndɨñda tɨmbi, tɨkap nepek gep kolɨ salelok walɨ kɨlɨm indañgukta, biañgan kɨlɨm mulum gɨnañ kulañ.” ");
INSERT INTO nif_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila enguk, “Kena gwañgwa sɨlanin endɨ molom tɨpettok kena tɨ-semektok tuop nɨm. Wɨndɨñ tɨmbekta, molomñɨn nola not tɨ-ñɨmbi tɨke-kwambɨñ dambi, molomñɨn nola nandɨ-kunjɨt tambi, siñgi wɨlɨmek. Wɨndɨñgangot sɨndɨ nepek tɨpelat, wɨn Anutu gɨt mɨnem kwɨlɨkwɨlɨ, endok kena tɨnelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wala tɨmbi ñɨndɨñ sanba nandɨwɨt: sɨndɨ kuñgunjɨla ba gwɨlapsɨla nandɨmbi, nanañ tuk ba dasindasinjɨ tuop pat-samlak wala nandɨ-bendɨ nɨm tɨnekalɨñ. Biañgan sɨnɨk: nepek nek ñalɨ bien sɨnɨk? Wɨn kuñgunjɨlɨ nanañ maklelak, tɨmbi gwɨlapsɨlɨ dasindasinjɨ maklelak. ");
INSERT INTO nif_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Sɨndɨ monɨk yambɨ nandɨwɨt: endɨ nanañ tɨpimbi met-na wɨsɨ-kot wɨndɨñ nɨm tañ, gan sɨndok Bepsɨ kunum gɨnañ patak endɨ ep towilak. Tɨmbi nɨtek? Sɨndɨ monɨk endok pɨmbɨñ ba? Nɨm a! Sɨndɨ endok loloñ sɨnɨk, wala tɨmbi endɨ wɨndɨñgangot sep towilak. ");
INSERT INTO nif_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ba sɨndoññan nanin ama nin ñalɨ sɨnɨk kuñgunla nandɨ-bendɨ wopum tɨñɨpi, kuñgun lakat nombo guma yousum ombatawɨk? ");
INSERT INTO nif_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tɨmbi dasindasinjɨla nekta nandɨ-bendɨ wopum tañ? Sɨndɨ pepekañgolalok paman klinan indambi pakañ wɨn ka nandɨwɨt: endɨ dasindasinjɨlok kena nɨm tañ, ");
INSERT INTO nif_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","gan pamanjɨ wɨn kɨndem bien sɨnɨk. Nak wala ñɨndɨñ sanlet: ama wapmañ Solomon endɨ dasindasin pamanat dasiñguk, gan endok pama wɨn kli wolok paman nɨm makleñguk. ");
INSERT INTO nif_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kli nepek pamanjɨ mangan indambi, desa yañetambi bɨndɨp pɨlak wɨn bo Anutu en dasindasinjɨ emlakta, nɨtek tɨmbi endɨ dasindasinjɨ nɨm tɨmbɨ inda-samek? Nanandɨ-kɨlɨktɨnjɨ lakat nɨm pat-samlak ba? ");
INSERT INTO nif_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wɨndɨñda sɨndɨ nandɨ-bendɨ tɨmbi, ñɨndɨñ nɨm enekalɨñ, ‘Nɨndɨ nanañ tuk nek ep na tɨnekamɨñ?’ ba ‘Nɨndɨ dasindasin nek dasi kunekamɨñ?’ ");
INSERT INTO nif_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ama nindɨ Anutu biañgan en nɨm nandɨñmañ endok gɨnañjɨ ba nanandɨnjɨlɨ nepenepek gɨtɨk wandindokgot pat-semlak. Tɨmbi kunum Bepsɨlɨ ñɨndɨñ nandɨ-sam-talelak: sɨndɨ nepek gɨtɨk wɨn nɨm pat-samekta guma nɨm kunelɨñ, wala tɨmbi nepek wala nandɨ-bendɨ wopum nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sɨndɨ gɨnañ nanandɨnjɨlɨ dama nepek ñala kɨmɨlɨm pat-samekak: sɨndɨ Anutulok gɨñgɨtñii indam kumbi, dɨndɨm kuñgu kunekalɨñ. Wɨndɨñ tɨnekalɨñda, nepek dɨwɨn gɨtɨk wandin walɨ bo inda-samekak. ");
INSERT INTO nif_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wala tɨmbi sɨndɨ desa nek indauk wolok man nandɨ-bendɨ wopum nɨm tɨnekalɨñ, wɨn desalok gɨñgɨt. Sandap nolok mɨlap wɨn sandap wolok tuop. Nɨm kañbi, yousɨmbi e-ta-ñaumbi mɨlatauk.” ");
INSERT INTO nif_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yesulɨ manda yousɨmbi ñɨndɨñ enguk, “Sɨndɨ amatamdok ep tɨndɨnjɨ kañ-danbi, endɨ kolasɨ wɨndɨñ nɨm enɨnekalɨñ. Nɨm kañbi, Anutulɨ sɨnda wɨndɨñgangot tɨ-samek. ");
INSERT INTO nif_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nekta, telak nɨtek plon sɨndɨ amatam yambɨ-dan tɨ-semañ, wɨndɨñgangot Anutulɨ bo sambɨ-dan tɨ-samekak. Tɨmbi kusei nɨtektok tuop sɨndɨ amatam yambɨ-dan tɨ-semañ, kusei wolok tuopkan Anutulɨ bo sambɨ-dan tɨ-samekak. ");
INSERT INTO nif_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dɨk nɨtek tɨmbi nokalok dainan kɨlɨkɨlɨk mɨnam wɨn kalañ, gan dɨtnalok dauka gɨnañ komba bem pakamlak wɨn nɨm ka-daklelañ? ");
INSERT INTO nif_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Dɨtnalok dauka gɨnañ komba bem wɨndɨñ patakta, nɨtek nokala ñɨndɨñ tuop nɨmbeñ, ‘Notna, nak dauka gɨnañ kɨlɨkɨlɨk patak wɨn klewa lambɨ-gamek.’ ");
INSERT INTO nif_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Dɨk ama juluñgandok. Dama dɨtnalok dauka gɨnañ komba bem patak wɨn kle-kopmek, siñgi kɨndem dei-kɨliñ embi, nokalok dai gɨnañ kɨlɨkɨlɨk mɨnam patak wɨn kle-kolekañ. ");
INSERT INTO nif_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Sɨndɨ nepek no Anutulok gɨñgɨt wɨlɨmɨmɨn wɨn tɨkembi, kamotta nɨm emnekalɨñ. Nɨm kañbi, kamottɨ undanembi, sɨnla sep sainelɨñ. Ba sɨndɨ sɨnlok kokomjɨ tuan lolon wɨn bɨtta nɨm emnekalɨñ. Nɨm kañbi, bɨt kesɨsɨlɨ yali mɨna dam kotnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yesulɨ yousɨmbi, nɨmolo tɨndɨla ñɨndɨñ enguk, “Sɨndɨ nepek nola tɨpɨkañ wala nɨ-nandɨ tɨnekalɨñ, tɨmbɨmbi nandɨ-samekak. Sɨndɨ nepek nola lonjɨmbi tɨpɨkañ wala lolonjɨ tɨnekalɨñ, tɨmbɨmbi nepek wolok bien kanekalɨñ. Sɨndɨ yaman wɨwɨt tɨnekalɨñ, tɨmbɨmbi Anutulɨ pɨsat-sambi sep plaptaukak. ");
INSERT INTO nif_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wɨn kusei ñɨndɨñda: nɨ-nandɨañ tuop nandɨ-semlak. Lonjɨañ tuop bien kañ. Yama wɨkañ tuop yama pɨsat-semekak. ");
INSERT INTO nif_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sɨndoññan nanin nindɨ nɨñañ nanañla eumbi kawat mɨwɨk? Nimbek nolɨ tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ba pisla eumbi, malet no nɨm nanalok kɨndem mɨwɨk ba? Wɨn bo tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sɨndɨ ama yomat, gan nepenepek kɨndem gwañgwa bɨsatsɨla emnelɨñdok nandɨ-kɨliñ eañ. Wɨndɨñda tɨmbi, sɨndɨ ñɨndɨñ sɨnɨk nandɨwɨt: Bepsɨ kunum gɨnañ patak endɨ mek sapma klembi, nepenepek kɨndem ama nindɨ enda nɨ-nandañ enda guma emekak. ");
INSERT INTO nif_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Sɨndɨ amatamdɨ nek tɨ-samnelɨñdok nandɨ-koñgom tañ, wɨndɨñgangot enda tɨ-semnekalɨñ. Manda walɨ wakan endɨkñe manda Moselɨ kɨmɨt-nɨmguk ba manda plofet amalɨ nɨnɨ-daut tɨ-nɨmgɨlɨñ wolok kusei tɨmbɨ inda-daklelak. ");
INSERT INTO nif_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sɨndɨ yama gik wandɨñ lonekalɨñ. Jɨmbɨñ ñañalok yama wɨn wopum, tɨmbi telak jɨmbɨñ kandañ ñalak wɨn basakñanen, ba kesɨttɨ ñañalok pañgɨtnin, wala tɨmbi amatam asupgandɨ telak wɨn kleañ. ");
INSERT INTO nif_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gan kuñgu kwambɨñ ñañalok yama wɨn gik sɨnɨk, tɨmbi kuñgu wandɨñ ñañalok telak wɨn bo tip tɨmbi gliñgliñnat. Wala tɨmbi ama noñgan noñgandɨñgot telak yama wɨn kañbi, gɨnañ loañ.” ");
INSERT INTO nif_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yesulɨ yousɨmbi enguk, “Plofet ama julunjuluñ enda yambɨ-kɨliñ embi kunekalɨñ. Endɨ sipsip busukñanen wandin nomɨk sɨndoñ bañ, gan gɨnañ nanandɨnjɨ wɨn kamot moyen sañan wandin: endɨ sep tɨmbɨ kolanelɨñdok nandɨañ. ");
INSERT INTO nif_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Sɨndɨ endok ep tɨndɨnjɨ ba kenanjɨlok bien kañbi, kusasɨ ka-dɨndɨm enekalɨñ. Kuañgɨmdɨ mandañ bien nanalok lalilak ba? Ba gɨnjattɨ gip bien nanalok lalilak ba? Nɨm a. ");
INSERT INTO nif_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Komba tɨpitɨpin kɨndem endɨ bien kɨndemgot lalilak, komba kolan endɨ bien kolan lalilak. ");
INSERT INTO nif_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Komba kɨndem endɨ bien kolan lalilali wɨn nɨm patak, ba komba kolan endɨ bien kɨndem lalilali wɨn bo nɨm patak. ");
INSERT INTO nif_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tɨmbi komba no bien kɨndem nɨm laliumbi jɨnbɨm gɨloumbi, komba gɨnañ silok. ");
INSERT INTO nif_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wɨndɨñgangot sɨndɨ plofet ama julunjuluñ endok ep tɨndɨnjɨ kañbi, kɨndem kusasɨ ka-daklenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Amatam ‘Wopumna, Wopumna’ pa nanɨañ endɨ gɨtɨkkandɨ Kunum Molomdok gɨñgɨt nɨm indambi kunekalɨñ. Wɨn Bepna kunum gɨnañ patak endok man mandan tañgoneañ endɨñgot kunum gɨnañ lonekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kunum Molomdɨ amatam yambɨ-danbekak wolonda asuptɨ ñɨndɨñ nanɨnekalɨñ, ‘Wopum, wɨn dɨkok kokala nɨndɨ plofet manda eñgɨmɨñ, yal kolan ep kle-semgɨmɨñ, tɨmbi kundit gembɨnat engano asup tɨñgɨmɨñ yañ!’ ");
INSERT INTO nif_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wɨndɨñ eumbi, ñɨndɨñ e-daklembi enbetat, ‘Sɨndɨ Anutulok endɨkñe manda makleñgɨlɨñ. Nak nɨm nandɨ-samlet. Sɨndɨ nambimbi ñawɨt!’” ");
INSERT INTO nif_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yesulɨ yousɨmbi enguk, “No en manda gɨtɨk ñɨn san-talelet wɨn tɨke-kulakta, endɨ ama nanandɨnat ñandin: endɨ il kɨndilɨpi, ita mambɨ ilɨmbi, kawat ta kusei gɨnañ melɨ pɨumbi, gembɨnatkan youlɨ gɨlɨm da-taleñguk. Wɨndɨñ tɨmbi, il kɨndit-talem palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","nain nola gwi gwam wopum sɨnɨk it plon suañguk, tɨm sasalelɨ bo it pendɨt-tɨlalɨmbi, dɨñdam pakuk. Nekta, kawat ta kusei gɨnañ melɨ pɨumbi youlɨ gɨlɨm dañgukta nɨm gɨloñguk. ");
INSERT INTO nif_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Gan no en manda gɨtɨk ñɨn san-talelet wɨn nandɨmbi nandɨ-kɨmkɨmnelakta, endɨ ama kamen ñandin: endɨ il kɨndilɨpi, ita kenanjat sɨlanin plon mambɨ ikuk. It kɨndit-talem palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","gwi gwam wopum sɨnɨk it plon suambi, kɨnanjat kɨndilɨmbi, sasalelɨ bo it pendɨp yout mɨnjulɨmbi gɨlom pɨmbi, lɨlɨme-taleñguk.” ");
INSERT INTO nif_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Yesulɨ amatam kɨmɨn wopum nanandɨ emguk, wɨn endɨ endɨkñe nandɨ-tale amanjiilɨ enɨ-daut tɨ-semmañgɨlɨñ wolok tuop nɨm tɨñguk. Nɨm, endɨ enlok man ba gembɨn plon enɨ-daut tɨ-sem tɨ-kuñguk, wala tɨmbi manda eu taleumbi amatamdɨ nandɨ-gɨtɨñgɨtɨk tɨmbi, dambenjɨ pɨumbi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesulɨ kwet jañgɨnnan nanin pɨ ñaumbi, amatam kɨmɨn wopumdɨ en kle ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tɨmbi ama no wanda kwambɨñnat endɨ Yesuloñ bɨmbi, mɨlelem tɨ-ñɨmbi nɨñguk, “Wopum, tɨkap dɨk nep kɨmɨlep nandɨlañda, guma jɨmbatna tɨmbɨ taleumbi, kɨndem dawa.” ");
INSERT INTO nif_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Eumbi, kii kot-suapi, ama wɨn tɨke-kambi nɨñguk, “Nak nandɨ-gamlet. Dɨk kɨndem da” eumbi, wolongan wanda kwambɨñ walɨ pailɨmbi kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Tɨmbi Yesulɨ ñɨndɨñ nɨñguk, “Nandɨlañ. Nepek inda-gamlak wolok kasat ama nola nɨm tɨ-semekañ. Nɨm. Dɨk ñambi, gwɨlapka tapma amala daulɨmɨumbi, jɨmbatka talelak wɨn gambɨ-dakleukak. Tɨmbi dɨk amatamdɨ wandañga biañgan ip talek wɨn gambɨ-nandɨnelɨñdok Moselɨ endɨkñe manda kɨmɨt-nɨmguk wolok tuop tapma tɨmbekañ.” ");
INSERT INTO nif_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tɨmbi Yesulɨ Kapaneam it kwelan ñañguk. Ña tombɨmbi, Romalok mik ama 100 endok telak damanjɨ endɨ Yesuloñ bɨmbi nɨ-gɨñgɨnembi ");
INSERT INTO nif_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","eñguk, “Wopum, kena gwañgwana jɨmbat wopum indañmumbi, kii kesi dalandaumbi, pɨñgɨp gawat wopum nandɨmbi, ilan patak.” ");
INSERT INTO nif_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Eumbi nɨñguk, “Ale, nak ña tɨmba kɨndem dautak.” ");
INSERT INTO nif_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gan mik amalok telak damanjɨlɨ tambanembi nɨñguk, “Wopum, nak ama pɨmbɨñenen, nɨtek dɨk nokoñ ilan bɨwɨñ? Dɨk mandañgot eumbi, kena gwañgwana kɨndem dawɨn. ");
INSERT INTO nif_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Kusei ñɨndɨñda wɨndɨñ elet: lolonalok kapmalnan wɨn natna kulet, tɨmbi nokok kapmalnan mik ama dɨwɨn nolɨ kuañ. Tɨmbi nak nola ‘Dɨk ñau!’ nɨmbambi ñalak, ba nola ‘Dɨk bo!’ nɨmbambi bɨlak, tɨmbi kena gwañgwanala ‘Kena ñɨn tɨ!’ nɨmbambi, kena wɨn tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesulɨ manda wɨn nandɨmbi nandɨ sɨlɨkñembi, amatam en kle ñañgɨlɨñ enda ñɨndɨñ enguk, “Yakñesɨ! Sɨndɨ ama ñɨn kawɨt! Biañgan sanlet: endɨ Juda ama nɨm, gan endɨ nanandɨ-kɨlɨktɨ wopumnat! Nak Islael sɨndok boñgɨpsɨnan nanandɨ-kɨlɨktɨ wandin nɨm kañgut. ");
INSERT INTO nif_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nak ñɨndɨñ sanba: Kunum Molomdɨ kusei kɨmɨpi, amatamñii indañgan yambɨ-dɨkñembi, nanañ sina wopum tɨ-semekak, wolonda amatam asup kwet tuopnan nanin endɨ bɨmbi, Ablaam, Aisak gɨt Jekop en gɨta nanañ nanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Gan Anutulɨ Juda amatam dama gɨñgɨtñii ep kasɨleñguk wɨn asup ep kleumbi, kɨlɨm gɨnañ pɨmbi, wandɨñ mano kwɨlɨm tɨmbi, manjɨ sɨ-gɨlɨm danekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tɨmbi Yesulɨ mik amalok telak dama nɨmbi eñguk, “Dɨk ñau. Nanandɨ-kɨlɨktɨ tɨlañ wolok tuop inda-gametak.” Eumbi, wolongan sɨnɨk telak damalok kena gwañgwa jɨmbalɨ taleumbi kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tɨmbi Yesulɨ Petloloñ ilan ña loñguk. Lombi kañguk wɨn: Petlolok yapman tam pɨñgɨu komba dɨumbi, ipat plon dou-pakuk. ");
INSERT INTO nif_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tɨmbi Yesulɨ kii plon tɨke-kaumbi, jɨmbalɨ taleumbi, tam walɨ mɨlapi, nanañ tuk tɨmbɨ plaptañguk. ");
INSERT INTO nif_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Maim pɨumbi, ama yal kolanjɨat asup yanañgɨpi, Yesuloñ bɨñgɨlɨñ. Bɨumbi, man mandalɨñgot yal ep kle-kopi, amatam jɨmbatsɨat gɨtɨk ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Wɨndɨñ tɨñgukta, endɨ plofet Aisaialɨ kundit indauktok eñguk wolok tuop tɨñguk, wɨn ñɨndɨñ, “Endɨ jɨmbat ba pɨñgɨp gawatnii nɨpma tɨkembi bem-nɨmguk.” ");
INSERT INTO nif_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Amatam asuptɨ Yesu kle-gɨmbup palɨm yambɨmbi, gwañgwañiilɨ tuk guañ tambon kandañ ñañalok enɨ-dɨkñeñguk. ");
INSERT INTO nif_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tɨmbi endɨkñe manda nandɨ-tale ama nolɨ Yesuloñ bɨmbi nɨñguk, “Endaut. Dembek dembek ñaukañ tuop nak gep kle-kuutat.” ");
INSERT INTO nif_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Eumbi tambane nɨñguk, “Kamot moyen klinalok endɨ kwet tombañjɨat, tɨmbi monɨk endɨ bo isɨat, gan Amalok Nɨñañ en il no nɨm palmɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tɨmbi gwañgwañiiloñ nanin ama nolɨ Yesu ñɨndɨñ nɨñguk, “Wopum, nandɨ-namumbi, dama ña bepna kɨndit tapli-bimek bɨm gep kle-kuutat.” ");
INSERT INTO nif_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Gan Yesulɨ nɨñguk, “Nɨm a. Ama gɨnañjɨ tip kɨmkɨmɨn endɨ kɨndem nosɨ tɨke kɨmɨpi kɨnditnelɨñ. Dɨkta bɨm, nep kle.” ");
INSERT INTO nif_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tɨmbi Yesulɨ kɨkeñ plon loumbi, gwañgwañiilɨ en kle ñambi loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tɨmbi tuk guañ plon ñañɨlɨmbi, sasale wopum plapkan sɨnɨk pendɨpi, tuk munjulɨmbi, kɨkeñ kot tapliupi tɨñguk. Gan Yesu enla dou kamalam pakuk. ");
INSERT INTO nif_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tɨmbi gwañgwalɨ Yesu tɨmbɨ sɨlɨkñeumbi nɨñgɨlɨñ, “Wopum, nɨpmɨ plata! Kuñgunɨ taleupi tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Eumbi enguk, “Nekta gembɨnjɨ pɨumbi mɨsɨañ? Nanandɨ-kɨlɨktɨnjɨ lakat nɨm pat-samlak ba?” Wɨndɨñ embi mɨlapi, sasale gɨt tuk enombɨumbi, sasalelɨ biumbi, tuktɨ busukñanen douñguk. ");
INSERT INTO nif_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tɨmbi ama Yesu gɨta pakɨlɨñ endɨ ka sɨlɨkñembi eñgɨlɨñ, “Ama ñɨn nɨtein sɨnɨk, ñala sasale gɨt tuktɨ mandan tañgoneamɨk?” ");
INSERT INTO nif_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Galili tuk guañ tambon kandañ, Gadala nasilok kwelan, ama tɨpet yal kolanjɨat endɨ sumnan pa kuñgɨmɨk. Endɨ ama sañasɨt sɨnɨkta tɨmbi ama nolɨ endɨ kuñgɨmɨknan kandañ ñañambɨt tɨndɨlok tuop nɨm. Yesulɨ wolok ña tombɨmbi, ama tɨpet endɨ sumnan nanin pɨmbi, en tɨmbɨ indambi ");
INSERT INTO nif_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","kɨtɨmbi nɨñgɨmɨk, “Anutulok Nɨñañ, dɨk nekta nɨndoñ bɨlañ? Kwelan kuñgulok nainnii gama nɨm dumalañɨlɨmbi, kena gɨm nɨmepi bɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bɨt kɨmɨn wopum no kambak mayañgan kuñɨpi, kwet minañ-pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Tɨmbi yal kolan endɨ Yesulɨ nandɨ-semektok nɨ-gɨñgɨnembi eñgɨlɨñ, “Tɨkap dɨk nɨp kleup tɨlañda nandɨ-nɨmumbi, bɨt kɨmɨn da pakañ endok gɨnañjɨ gɨnañ ña pɨna.” ");
INSERT INTO nif_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Eumbi enguk, “Ale, pɨm ñawɨt!” Tɨmbi wolongan yal kolan endɨ ama tɨpet yambɨk bimbi, bɨt asup endok gɨnañjɨ gɨnañ ña pɨñgɨlɨñ. Pɨumbi, bɨt gɨtɨk endɨ gembɨnat woñepi, kwet yaliup jɨlopi, jɨmbɨñ pɨmbi, tuk guañ gɨnañ tuk nañbi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tɨmbi bɨt ka-dɨkñe ama endɨ pim ñambi, it kwet wopumnan ña tombi, bɨttok kasat ba ama tɨpet yal kolanjɨat kuñgɨmɨk endok kasat gɨtɨk amatamda tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Wɨndɨñda tɨmbi amatam it kwet wopumnan kuñgɨlɨñ gɨtɨk endɨ Yesu bɨ kañbi, kwesɨ bim ñauktok nɨ-nandumbi nandɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tɨmbi Yesulɨ kɨkeñ plon lombi, tuk guañ tombo kandañ undane ñambi, enlok il kwelnan tomguk. ");
INSERT INTO nif_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tɨmbi ama dɨwɨndɨ ama no kii kesi dalandan tañgonembi, endoñ bɨñgɨlɨñ. Bɨu yambɨmbi, nanandɨ-kɨlɨktɨnjɨlok kusei ka-nandɨ-tombi, ama tañgo plon pakuk enda ñɨndɨñ nɨñguk, “Notna, waleñga busukñeun: nak yomga gɨtɨk bi-gamlet.” ");
INSERT INTO nif_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wɨndɨñ eumbi, endɨkñe manda nandɨ-tale ama dɨwɨndɨ wala nandum pɨumbi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Ama ñalɨ yom biñmektok elak endɨ Anutula en wandin eñɨpi nɨ-lakatalak yañ!” ");
INSERT INTO nif_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesulɨ gɨnañ nanandɨnjɨ ka-daklembi enguk, “Nekta gɨnañjɨ gɨnañ nanandɨ kolan wandin tɨ-namañ? ");
INSERT INTO nif_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Anutulɨ gembɨn nɨm namumda, nak ama ñala ‘Yomga bi-gamlet’ ba ‘Dɨk mɨlapi, kesɨttɨ ñau!’ wɨndɨñ nɨmbambi, bien kɨndem indauk ba? Nɨm a! ");
INSERT INTO nif_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wɨndɨñda Amalok Nɨñañ kwelan ñolok yom bimbilok gembɨn palmɨlak wɨn nak ñɨndɨñ daut sametet.” Yesulɨ wɨndɨñ embi, ama kii kesi dalandanla nɨñguk, “Dɨk mɨlapi, ipaka tɨkembi, ikanan ñau!” ");
INSERT INTO nif_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eumbi, wolongan mɨlap ipi, ipal tɨkembi, ilnan ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tɨmbi amatam kundit wɨn kañgɨlɨñ endɨ mɨsɨmbi, Anutulɨ gembɨ wandin amala emguk wala nɨ-kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tɨmbi Yesulɨ walinin pɨ ñañɨpi, ama no koi Matayo takis epep ilan kena tɨ-palɨmbi kañbi nɨñguk, “Dɨk bɨmbi nep kle-kuukañ.” Nɨmbɨmbi, wolongan mɨlapi kle ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tɨmbi Yesu gɨt gwañgwañii endɨ it gɨnañ lo pipapi, nanañ nañgɨlɨñ. Nañɨlɨmbi, takis epep ama ba ‘yom ama’ asup dɨwɨndɨ bɨ yousɨmbi, en gɨta nanañ yakan na-pakɨlɨñ. Na-palɨñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Falisi ama dɨwɨndɨ wɨn kañbi, nandum pɨ-sɨnɨk taumbi, Yesulok gwañgwañii en-nandɨmbi eñgɨlɨñ, “Sandautsɨ endɨ neta takis epep ba yom ama en gɨta nanañ nalak?” ");
INSERT INTO nif_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesulɨ manda wɨn nandɨmbi enguk, “Kɨndesɨ endɨ gwasap amaloñ nɨm ñañ. Wɨn jɨmbatsɨat endɨñgot gwasap amaloñ ñañ. ");
INSERT INTO nif_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Sɨndɨ ñambi, Anutulok mandan ñɨndɨñ youyoulɨn patak wɨn pinapi, bien ka-daklenekalɨñ, ‘Nak ama gɨnañ busuk tɨ-semnelɨñdok nandɨlet, tapma tɨ-namañ wala nɨm.’ Wɨndɨñda nak yom ama en-tiañeuttok indañgut, ama nɨsɨla nandum dɨndɨm sɨnɨk tɨlak enda nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nain wolonda Yoane tuk ii-sem kena tɨñguk endok gwañgwañiilɨ Yesuloñ bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Falisi ama gɨta nɨndɨ nanañ kɨmɨsip pa tamɨñ, gan nɨtekta dɨkok gwañgwañgailɨ wɨndɨñ nɨm pa tañ?” ");
INSERT INTO nif_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Eumbi, Yesulɨ gwañgwañiilɨ kusei nekta ep tɨndɨn damanin nɨm kɨmɨt-kleñgɨlɨñ wɨn eu dakleuktok eyout manda dɨwɨn eñguk. Eñɨpi, enla ba gwañgwañiilok plon ñɨndɨñ embi enguk, “Ama nolɨ tamɨn tɨlakta tɨmbi, sina mɨn na-sɨlɨsɨlɨlok nain indaumbi, noliilɨ kɨndem blandok telak kleñɨpi, nanañ kɨmɨsip tɨnelɨñ ba? Wolok tuop nɨm. Gan ama wɨn noliilok boñgɨpsɨnan nanin yapma tɨke-ñaumek, noliilɨ blandok telak klenepi, nanañ kɨmɨsip pa tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesulɨ wɨndɨñ embi yousɨmbi enguk, “Ama nolɨ dasindasin damanin dɨkñendɨkñen mambupmeupi sandum kusip komblin nɨm tɨkelak. Wɨndɨñ tɨmbekta, dasindasin wɨlɨlɨmbi, sandum kusip komblin walɨ ña titambi, dasindasin damanin tiañeum blañganeumbi, gɨnañ wopumgan sɨnɨk indauk. ");
INSERT INTO nif_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tɨmbi wain tul komblin bo meme gwɨlap kawai gɨnañ nɨm wɨlɨ gɨlolok. Wɨndɨñ tɨmbekta, wain tullɨ bendɨ wopum dambi, meme gwɨlap kawai tɨmbɨ tawa kolaumbi, wain kwelan lamɨt pɨ-talewɨk. Wala tɨmbi wain tul komblin wɨn gwɨlap komblin gɨnañ pa wɨlɨ gɨlolok, tɨmbi nɨset tɨpelat kɨndemgot patemɨk.” ");
INSERT INTO nif_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesulɨ wɨndɨñ eñɨlɨmbi, ka-dɨkñe ama nolɨ endoñ bɨmbi, kuañ kuseinan mɨlelem tɨñɨpi nɨñguk, “Wembana kombɨkan sɨnɨk sembɨlak. Gan wandingan dɨk bɨmbi, kɨka endok plon kɨmɨlɨmbi, kuñgun nombo indañmun.” ");
INSERT INTO nif_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Eumbi, Yesulɨ mɨlapi, gwañgwañii gɨta ka-dɨkñe ama klem ilnan ñanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Tɨmbi tam no tam jɨmbat indañmɨ palɨmbi, gwɨlat 12 taleñguk endɨ enla ñɨndɨñ e-nandɨñguk, “Nak Yesulok dasindasingot tɨke-kautatta, kɨndem dautat.” Wɨndɨñ eñɨpi, endok siñgi kandañ ñambi, dasindasin kusipgot tɨke-kañguk. ");
INSERT INTO nif_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tɨke-kaumbi, undanem tam kañbi nɨñguk, “Wembe, waleñga kɨndem dawɨn. Nanandɨ-kɨlɨktɨñgalɨ gep tɨmbɨ kɨndem dalañ.” Tɨmbi nain wolondañgan tam walɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tɨmbi Yesulɨ ka-dɨkñe ama endok ilnan ña tombi yambɨñguk wɨn: amatam asup kɨmɨn tɨ-palɨmbi, dɨwɨsɨlɨ blandok kap pakñuaktɨ pendɨlɨmbi, dɨwɨsɨlɨ mano tɨmbi, losala wopumgan tɨñgɨlɨñ. Tɨ-palɨm yambɨmbi ");
INSERT INTO nif_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","enguk, “Sɨndɨ mɨlapi ña-talewɨt. Wembe tip endɨ nɨm sembɨk. Endɨ slak dou-patak.” Eumbi ka-kwalepgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Gan amatam ep kleum pawan pɨ-taleumbi, Yesulɨ wembe pakuknan lombi, kii plon tɨkeum mɨlakuk. ");
INSERT INTO nif_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tɨmbi kundit wolok gɨñgɨttɨ kwet wolok tuop sapakñeñguk. ");
INSERT INTO nif_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesulɨ waliningan pɨ ñañɨlɨmbi, ama tɨpet dauset sisipmɨn endɨ siñgi kandañ klembi kɨtɨñmɨm eñgɨmɨk, “Devittok Komblin, dɨk nɨta blan tɨ-nɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesulɨ it gɨnañ lo palɨmbi, ama tɨpet walɨ endoñ bɨñgɨmɨk. Bɨumbi en-nandɨmbi eñguk, “Nak gumañ sep tɨmba kɨndem dandemɨk wɨn sɨtɨ nandɨ-kɨlɨktɨ tɨ-namamɨk ba?” Eumbi nɨñgɨmɨk, “Oñ, Wopum, wɨndɨñgan.” ");
INSERT INTO nif_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Eumbi, kiilɨ dauset tɨke-kambi enguk, “Nɨtek nandɨ-kɨlɨktɨ tɨ-namamɨk wolok tuop inda-samun.” ");
INSERT INTO nif_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Eumbi, dautset tombɨmbi, kɨmɨsip manda kwambɨñ ñɨndɨñ enbi eñguk, “Sɨtɨ nepek ñɨn inda-samlak wɨn ama dɨwɨn nola nɨm enɨndekamɨk.” ");
INSERT INTO nif_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wɨndɨñ eñguk, gan endɨ ñambi, Yesulok gɨñgɨt wɨn kwet wolok tuop e-sapakñeñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ama tɨpet walɨ walinin pɨ ñañɨlɨmbi, amatamdɨ ama no yal kolanlɨ man tɨmbɨ sipmɨñguk wɨn Yesuloñ nañgɨp bɨñgɨlɨñ. Nañgɨp bɨumbi, ");
INSERT INTO nif_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","yal kolan kleñmɨumbi, man sisipmɨn endɨ kusei kɨmɨpi, manda eñguk. Tɨmbi amatamdɨ wɨn ka sɨlɨkñembi eñgɨlɨñ, “Dama Islael kwelan nepek ñandin no nɨm indañguk.” ");
INSERT INTO nif_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gan Falisi amalɨ ñɨndɨñ pa nɨañgɨlɨñ, “Yal kolandok telak damanjɨlɨ gembɨ mɨumbi, yal kolan pa ep kle-semlak.” ");
INSERT INTO nif_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tɨmbi Yesulɨ it kwet wopum ba tip gɨtɨk kle-gɨmbulepi ñañguk. Ñañɨpi, amatam it kiyaunjɨ gɨnañ enɨ-daut tɨ-sembi, Anutulɨ amatam yambɨ-dɨkñelak wolok plon gɨñgɨt manda kɨndem eu pɨumbi, amatam jɨmbat kusei kusei inda-semguk ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tɨmbi endɨ ama kɨmɨn wopum yambɨñguk wɨn endɨ sipsip ka-dɨkñenjɨ nɨmnat ba tɨ-plaplaenjɨ nɨmnat nomɨk kuumbi yambum mɨlataumbi blan tɨ-semguk. Blan tɨ-sembi, ");
INSERT INTO nif_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","gwañgwañiila ñɨndɨñ enguk, “Nanañ bien mepmettok asupgan pakañ, gan kena ama wɨn lakatgot. ");
INSERT INTO nif_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wala tɨmbi sɨndɨ Anutu kena molom nɨmolo tɨñmumbi, kena ama ep tɨmbɨ indaumbi, kenan gɨnañ en-mulɨm ñambi, bien ep kɨmɨn kotnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tɨmbi endɨ gwañgwañii 12 kɨtɨ-semum bɨumbi, yal kolan ep kle-semnelɨñdok ba jɨmbat kusei kusei ep tɨmbɨ kɨndem danelɨñdok gembɨ emguk. ");
INSERT INTO nif_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ama enmumulɨn 12 endok kosɨ ñɨndɨñ: dama Simon koi no Petlo, tɨmbi kwayañ Andlu, gɨt Sebedilok nɨñañiit Yakobo gɨta kwayañ Yoane, ");
INSERT INTO nif_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip gɨt Batlomio, tɨmbi Tomas gɨt Matayo takis epep ama, tɨmbi Yakobo Alifaialok nɨñañ gɨt Tadaio. ");
INSERT INTO nif_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Tɨmbi Simon Selot gɨt Judas Iskaliot en Yesu bola tɨñmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","6","Tɨmbi Yesulɨ gwañgwa 12 wala wakan en-mupi, molo manda embi enguk, “Islael amatam endɨ sipsip pait-pakañ wandin, wala tɨmbi sɨndɨ endoñgot ña yambɨnekalɨñ. Sɨndɨ Samalia amatam endok isɨ kwesɨnan nɨm lonekalɨñ, ba amatam Judalok sambat nɨm endoñ nɨm ñanekalɨñ, Juda amatamdoñgot ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ñañɨpi, gɨñgɨt manda ñɨndɨñ enɨnekalɨñ, ‘Kunum Molomdɨ amatamñii yambɨ-dɨkñelak wɨn inda-dakleup tɨlak.’ ");
INSERT INTO nif_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Tɨmbi jɨmbatsɨat ep tɨmbɨ kɨndem danekalɨñ, ba kɨmkɨmɨn ep tɨmbɨ mɨlatnekalɨñ. Wanda kwambɨñjɨat ep tɨmbɨ gɨlɨta-semnekalɨñ, ba yal kolanjɨat ep kle-kot-semnekalɨñ. Gembɨ samsamɨn wɨn tuan nɨmnat, wala tɨmbi sɨndɨ kena tuan nɨmnat kenane-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Ama kena tɨlak enda tuan mɨlok, wala tɨmbi sɨndɨ ñanepi, mɨnem gɨmɨn ba satnin nɨm mep ñanekalɨñ. Sɨndɨ lɨksɨ nɨm tañginekalɨñ. Tɨmbi kiupɨ tɨpet wakɨt kesɨsɨ gwɨlap ba toña youtilok nɨm mep ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Sɨndɨ it kwet wopum ba tip nolok ba nolok lonekalɨñ, wolonda ama kɨndem nolɨ not tɨ-samektok e-lonjɨmbi en-nandɨ tɨnekalɨñ. En-nandɨ tɨmbɨmbi, nɨsɨ inda-dakleumbi, en gɨta ñambi, wandɨñ patnekalɨñ tuop endok ilnangot dou mɨlat tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Endok ilnan loñɨpi, amatam ñɨndɨñ enɨnekalɨñ, ‘Busuk sɨndok kandañ palekak.’ ");
INSERT INTO nif_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tɨkap it wolok gɨnañ pakañ endɨ not tɨ-samnekalɨñda, busuk walɨ endok kandañ palekak. Nɨmda, Anutu nɨ-nandumbi, busuk wɨn yapma tɨkeukak. ");
INSERT INTO nif_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tɨkap it ba it kwet nolok ama nolɨ not no nɨm tɨ-samnelɨñda ba mandanjɨ no nɨm nandɨnelɨñda, yambinekalɨñ. Yambinep tɨñɨpi, dausɨnan kesɨsɨ plon kwɨlɨñ sapak wɨt sapleum pɨumbi, ‘Anutulɨ siñgi wɨt-nɨmlak’ wɨndɨñ sambɨ-nandɨ-daklenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nak biañgan sanba nandɨwɨt: Anutulɨ amatam yambɨ-danbekak wolonda it kwet sɨnda siñgi wɨt-samnekalɨñ endok kolanjɨ wolok tuan walɨ amatam kolan papait nindɨ damañgan Sodom gɨt Gomola it kwelan kuñgɨlɨñ endok kolanjɨlok tuan makleukak.” ");
INSERT INTO nif_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yesulɨ yousɨmbi enguk, “Nandañ. Nak amatamdoñ san-mulam ñambi, kanjɨknailok boñgɨpsɨnan kunekalɨñ. Endɨ kamot moyen sañan wandin, tɨmbi sɨndɨ sipsip gembɨnjɨ nɨmnat wandin. Endɨ sep tɨmbɨ kolanelɨñdok nandañ, wala tɨmbi sɨndɨ nandɨ-kɨliñ tɨmbi kuñɨpi, yom nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Sɨndɨ ama yambɨ-kɨliñ embi kunekalɨñ. Endɨ manda plon sep kɨmɨtnelɨñdok ama biesɨlok kɨsɨnan sapɨlɨmbi, it kiyaunjɨ gɨnañ sep waipnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Endɨ naka tɨmbi ama wapmañ ba ka-dɨkñe ama endoñ mandala sanañgɨlɨmbi, telak inda-samumbi, gɨñgɨt manda kɨndem en ba dɨwɨn Juda ama nɨm enda bo enɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mandala sep ñañɨlɨmbi, ‘Nek enetamɨñ, ba manda telal nɨtek plon enetamɨñ’ wala nandɨ bendɨ wopum nɨm tɨnekalɨñ. Neta, manda plon ilɨmbi, wolongan Anutulɨ manda eelok daut samumbi enekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Manda enekalɨñ wɨn sɨnlok nɨm. Wɨn Bepsɨ enlok Dɨndɨm Woñ endɨ sep tɨmbɨ pañgɨtaumbi enekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ama dɨwɨn nak nɨm nep kleañ endɨ dasii ba kwayañjii nandɨ-kɨlɨktɨ namañ wɨn kanjɨknailok kɨsɨnan yapɨpi, yandɨpmɨ kɨmnelɨñdok. Ba besii dɨwɨndɨ gwañgwañjɨ bɨsat wɨndɨñgangot tɨ-semnekalɨñ. Tɨmbi wembe gwañgwalɨ menjɨ bepsɨla wɨndɨñgot kanjɨk tɨ-sembi, amalɨ yandɨpmɨ kɨmnelɨñdok enekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tɨmbi nokok gɨñgɨtnai kuañda tɨmbi amatam gɨtɨktɨ nandɨ-kunjɨta wopumgan tɨ-sam tɨ-kunekalɨñ. Gan no en mɨlap wandin indañmekak tuop nep kwambɨñ dambi nɨm nambiukak, endɨ wakan Anutulɨ kuñgu taletalen nɨmnatnan tɨke-kɨmɨlekak. ");
INSERT INTO nif_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tɨmbi it kwet nolok nasilɨ mɨlap kusei kusei samnekalɨñda, it kwet nolok pimbi ñanekalɨñ. Nak biañgan sanba: sɨndɨ Islael it kwet patak tuop kenanjɨ gama nɨm tɨmbɨ taleñɨlɨmbi, Amalok Nɨñañ en bɨ tombekak.” ");
INSERT INTO nif_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yesulɨ yousɨmbi enguk, “Mɨlaptok kandañ nak ñɨndɨñ sanlet: gwañgwalɨ nɨndaulɨn nɨm makle-patak, tɨmbi kena gwañgwa sɨlanin endɨ molomñɨn nɨm makle-patak. ");
INSERT INTO nif_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Wala tɨmbi amalɨ nɨndaut ba molom mɨlap nɨtek tɨ-semnekalɨñ, wɨndɨñgangot gwañgwan ba kena gwañgwanla tɨ-semnekalɨñda, wala endɨ manda nɨmnat. Endɨ naka Belsebul nangɨlɨñ, wɨn Satan. Sambatsiilok kumbamla wɨndɨñ nɨñgɨlɨñda, nɨtek tɨmbi sambatnai nɨm san-kolakolae sɨnɨk tɨ-samnelɨñ? ");
INSERT INTO nif_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Gan amala nɨm mɨsɨnekalɨñ. Nepek sembɨn patak wɨn sɨndɨ amatam enbɨ tawaumbi, ba manda sembɨn gɨtɨk wɨn eu inda-dakleukak. ");
INSERT INTO nif_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Manda tim sɨnlañgan sansanɨn wɨn maim plon amatam gɨtɨk enɨ-dakle-semnekalɨñ, ba manda janjat sanlet wɨn indañgan e-kolɨ pɨukak. ");
INSERT INTO nif_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Sɨndɨ amatamda nɨm mɨsɨnekalɨñ. Endɨ gwɨlapsɨñgot wɨpi, gɨnañjɨ tip wɨwɨttok gembɨ nɨm pat-semlak. Gan Anutu endɨ gwɨlap gɨt gɨnañ tip nɨset tɨpelatkan ep munjulɨm jɨmbɨñ pɨndemɨktok gembɨ palɨmlak endañgot mɨsɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Monɨk tipnam tɨpet mɨnem kwandai gɨmɨn noñganlɨñgot tuatuan, gan noñgan piulekta, sɨndok Bepsɨlɨ wɨn nandɨ-talelak. Endɨ monɨk kambak wandin yambɨ-dɨkñelakta, ");
INSERT INTO nif_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","sɨndɨ bo sambɨ-dɨkñelak, tɨmbi kumbanjɨ saktok kunakunat wɨn bo nandɨ-talelak. ");
INSERT INTO nif_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Sɨndɨ Anutulok dainan loloñ sɨnɨk, monɨk tiptip asupgan yapma kleañ, wala tɨmbi amatamda nɨm mɨsɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sɨndɨ amalok dausɨnan ‘Nak Yesulok gɨñgɨt kulet’ wɨndɨñ e-dakleañ, nak bo wɨndɨñgangot kunum Bepnalok dainan sɨnda nɨ-dakleutat. ");
INSERT INTO nif_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gan sɨndɨ naka amalok dausɨnan ‘Nak nɨm nandɨñmɨlet’ eañ, nak bo wɨndɨñgangot kunum Bepnalok dainan sɨnda ‘Nak nɨm nandɨ-semlet’ eutat.” ");
INSERT INTO nif_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yesulɨ yousɨmbi, gwañgwañiila ñɨndɨñ enguk, “Sɨndɨ ñɨndɨñ nɨm nandɨ-namnekalɨñ, ‘Endɨ kwelandok mik gɨtɨk tɨmbɨ taleupi indañguk’. Nak mik tɨmba taleuktok nɨm indañgut. Nɨm. Nak kakit nomɨk ");
INSERT INTO nif_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","amatam ep tambɨleptok indañgut. Wɨndɨñda ama nolɨ beula kanjɨk tɨñmumbi, wiulɨ meñla kanjɨk tɨñmum, tamɨnlɨ nambɨn tamla kanjɨk tɨñmekak, ");
INSERT INTO nif_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","wɨn ama nolok sambalii endɨ endok kanjɨkñii tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nandañ. Ama no en gɨnañlɨ nak nep kasɨlelak, gan gɨnañlɨ meñ ba beu ep kasɨle-sɨnɨk talakta, nandɨñmam tuop nɨm tɨ-namlak. Tɨmbi ama no gɨnañlɨ nak nep kasɨlelak, gan gɨnañlɨ wemben ba gwañgwan kasɨle-sɨnɨk talakta, nandɨñmam tuop nɨm tɨ-namlak. ");
INSERT INTO nif_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tɨmbi ama no kloñbalɨ nɨm bembi nep kle-kulakta, enda bo nandɨñmam tuop nɨm tɨ-namlak. ");
INSERT INTO nif_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ama no kuñgun enlok biñmɨlak, endok kuñgun pailɨmekak. Gan ama no naka tɨmbi kuñgun bi-namlakta, endɨ kuñgun taletalen nɨmnat indañmekak.” ");
INSERT INTO nif_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yesulɨ yousɨmbi enguk, “No en sɨnda not tɨ-samlak, endɨ naka not tɨ-namlak, tɨmbi no en naka not tɨ-namlak, endɨ Anutu nan-mukuk enda not tɨñmɨlak. ");
INSERT INTO nif_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","No en plofet ama no endok kenanla tɨmbi not tɨñmɨlak, enda Anutulɨ plofeta tuan kɨndem mɨlak wɨndɨñgangot mɨukak. Tɨmbi no en ama dɨndɨm no endok dɨndɨm kuñgula tɨmbi not tɨñmɨlak, enda Anutulɨ ama dɨndɨmla tuan kɨndem mɨlak wɨndɨñgangot mɨukak. ");
INSERT INTO nif_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Sɨndɨ gɨñgɨtnai kosɨ nɨmnat ñɨn endoññan nanin no ka-nandɨwɨt. Nak biañgan ñɨndɨñ sanlet: no en ama wolok kusei ka-daklembi, plap tɨñmɨlak ba tukgot gɨpi mɨlak endok tuan wɨn biañgan Anutulɨ kɨmɨlɨm palmekak.” ");
INSERT INTO nif_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesulɨ gwañgwañii 12 wɨndɨñ enɨ-dɨkñe-sem-talembi, walinin pɨ ñambi, Juda amatam enɨ-daut tɨ-sembi, gɨngɨt manda kɨndem enbektok it kwet pakɨlɨñnan ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tɨmbi Yoane tuk ii-sem kena tɨñguk en it kwambɨñ gɨnañ kɨmɨlɨm pakuk. Papi, Yesu Mesialɨ kundit kusei kusei tɨñguk wolok gɨñgɨt nandɨñgukta, gwañgwañii dɨwɨn en-mulɨm Yesuloñ ñambi, ");
INSERT INTO nif_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ñɨndɨñ nɨkañbi eñgɨlɨñ, “Anutulɨ ama nɨ-mulɨm bɨ-nɨmektok een wɨn dɨk wakan ba? Ba nola mandɨ-ta-kunekamɨñ?” ");
INSERT INTO nif_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Eumbi, Yesulɨ tambanem enguk, “Sɨndɨ undane ñambi, kunditna dausɨlɨ kañ ba pawanjɨlɨ nandañ wolok kasat Yoanela ñɨndɨñ tɨñmɨnekalɨñ: ");
INSERT INTO nif_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","dausɨ sipsipmɨn endɨ deiañ, kesɨt nɨm kuañ endɨ kesɨt kuañ, wanda kwambɨñjɨat endɨ wandanjɨ gɨlɨtalak. Pawanjɨ kamalañguk endɨ manda nandañ, kɨmgɨlɨñ endɨ nombo ep tɨmba mɨlap kaik pakañ, ba pɨmbɨñen enda gɨñgɨt manda kɨndem enba nandañ. ");
INSERT INTO nif_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tɨmbi no en kusatna ka-nandumbi, nanandɨ-kɨlɨktɨn nɨm pipɨlak, endɨ amatam dɨwɨn yapma kle-patak.” ");
INSERT INTO nif_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tɨmbi Yoanelok gwañgwañiilɨ Yesu kañbim ñañɨlɨmbi, Yesulɨ amatam kɨmɨn tɨ-pakɨlɨñda Yoanela ñɨndɨñ enguk, “Sɨndɨ kwet kambaññan sɨlaninnan ñañgɨlɨñ, wɨn nek kanepi ñañgɨlɨñ? Wɨn klinandok kundɨt no sasalelɨ pendɨlɨmbi ña-bɨt tɨmbɨm kanepi ñañgɨlɨñ ba? ");
INSERT INTO nif_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tɨkap nɨmda, sɨndɨ nek kanepi ñañgɨlɨñ? Ama no dasidasin kɨndem pamanat kanepi ñañgɨlɨñ ba? Nandañ: ama wandisɨ endɨ ama wapmañdok isɨnan pipat mɨlat tɨ-kuañ. ");
INSERT INTO nif_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wɨndɨñda nek kanepi ñañgɨlɨñ? Plofet ama no ba? Biañgan. Gan plofet ama kañgɨlɨñ walɨ plofet sɨlanin no nɨm. Nak ñɨndɨñ sanlet: Yoane endɨ engano. ");
INSERT INTO nif_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Endɨ Anutulok gɨñgɨt ee ama, wɨn enda wakan manda ñɨndɨñ youp bimbin patak, ‘Nandɨlañ, nak gɨñgɨt ee amana no nɨ-mulambi, telak dama tɨ-gambi, telak tɨ-dɨndɨme kena tɨ-gamekak.’ Wɨn Yoanela manda wɨndɨñ youp bimbin patak. ");
INSERT INTO nif_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nak biañgan sanba: Yoanelɨ amatam gɨtɨk dama kuñgɨlɨñ ba man ñɨndɨñgɨt kuañ endok loloñ sɨnɨk yañ, gan ama pɨmbɨñesɨ gɨtɨk Kunum Molomdok gɨñgɨtñii kuañ endɨ bo Yoane makleañ. ");
INSERT INTO nif_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yoanelɨ tuk ii-sem kena kusei kɨmɨpi tɨñguk walinin bɨkap man ñɨndɨñgɨt nepek ñandin indalak: ama kolan ba sañan endɨ Kunum Molomdɨ amatamñii nɨtek yambɨ-dɨkñelak wolok endaut manda wɨn mik tɨ-ñɨmbi, tɨmbɨ kolanelɨñdok gɨñgɨne kena tañ. ");
INSERT INTO nif_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yoanelɨ kenan gama nɨm kusei kɨmɨlɨñɨlɨmbi, Mose gɨta plofet ama gɨtɨk endɨ Kunum Molomdɨ amatamñii telak nɨtek yambɨ-dɨkñeukak wolok plon manda youkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tɨkap sɨndɨ manda ñɨn tɨke-dasinelɨñdok tuopta wɨn ñɨndɨñ: plofet amalɨ Elia Mesialok telak dama indauptok eñgɨlɨñ wɨn Yoane wakan. ");
INSERT INTO nif_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","No en pawañnat endɨ mandana nandɨmbi nandɨ-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesulɨ yousɨmbi enguk, “Nak amatam man ñɨndɨñgɨt kuañ sɨnda nɨtek ewɨt? Sɨndɨ wembe gwañgwa wandin ipakanan pipapi, nosiila ñɨndɨñ kɨtɨ-semañ, ");
INSERT INTO nif_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Pakñuak pendɨtnambi, sɨndɨ kap nɨm tilɨñ. Ba nɨndɨ kap blan tinambi, mano nɨm tɨlɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kusei ñɨndɨñda tɨmbi sɨnda wembe gwañgwa sanlet: Yoanelɨ indambi, nanañ gɨtɨk kɨmɨsipbi, wain tuk no nɨm pa nalak, tɨmbi sɨndɨ ‘Yal kolanlɨ pɨñmɨlak’ pa nɨañ. ");
INSERT INTO nif_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tɨmbi Amalok Nɨñañ endɨ indambi, nanañ gɨt wain tuk pa nalak, tɨmbi sɨndɨ ñɨndɨñ pa nɨañ, ‘Wɨ kawɨt! Endɨ nanañ gɨt wain tuk nana molom, takis epep ba yom ama not tɨ-semlak!’ Gan amatam Anutulok nanandɨ kleñɨpi kundit kɨndem tañ endɨ nanandɨ wɨn dɨndɨm sɨnɨk tɨmbɨ dakleañ.” Yesulɨ wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Endɨ dama it kwet dɨwɨnnan kundit engano gembɨnat sɨnɨk asupgan tɨñguk, gangan wɨnasilɨ gɨnañjɨ nɨm tambaneñgɨlɨñ, wala tɨmbi endɨ kusei kɨmɨpi, it kwet wɨn enombɨmbi eñguk, ");
INSERT INTO nif_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Kolasin gɨt Betsaida nasi sɨndɨ kilañmet! Anutulɨ mek salamɨlekak! Nak kundit engano gembɨnat asup sɨndok kandañ tɨñgut, gan sɨndɨ gɨnañjɨ nɨm tambaneñgɨlɨñ. Kundit wɨn Tilo ba Sidon it kwelan indaumda, endɨ gɨnanjɨ tambaneañ wɨn inda-daklenepi blandok dasindasin dasimbi, kwɨlɨñ plon pipatnelɨñ. ");
INSERT INTO nif_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wɨndɨñda sanba nandɨwɨt: Anutulɨ amatam sambɨ-danbekak wolonda sɨndok kolanjɨlok tambon walɨ Tilo gɨt Sidon nasilok tambon wɨn makleukak. ");
INSERT INTO nif_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tɨmbi Kapaneam nasi, sɨndɨ ‘Anutulɨ kunum gɨnañ nɨp loukak’ wɨndɨñ nɨm nandɨnekalɨñ! Nɨm sɨnɨk, sɨndɨ jɨmbɨñ sep kolɨ pɨmbɨlokgot. Nekta, nak kundit engano gembɨnat asup sɨndok kandañ tɨñgut, gan sɨndɨ gɨnañjɨ nɨm tambaneñgɨlɨñ. Kundit wɨn Sodom kwelan indaumda, wɨnasilɨ gɨnañjɨ tambaneumbi, Anutulɨ it kwet wɨn nɨm tɨmbɨ kolaumbi, ñɨndɨñgɨt guma palek. ");
INSERT INTO nif_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wɨndɨñda sanba nandɨwɨt: Anutulɨ amatam sambɨ-danbekak sɨndok kolanjɨlok tambon walɨ Sodom nasilok tambon wɨn makleukak.” ");
INSERT INTO nif_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nain wolonda Yesulɨ ñɨndɨñ eñguk, “Bep, kunum kwet molom, nak ñɨndɨñda gan-kɨndem dalet: dɨk nanandɨñga dɨwɨn ama nanandɨnjɨat ba nandɨ-daklenjɨat enda kɨmɨsembɨñguñ, gan nanandɨ sembɨn wɨn amatam nanandɨnjɨ nɨmnat enda tɨmbɨ dakle-semguñ. ");
INSERT INTO nif_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Bep, biañgan sɨnɨk, dɨk wɨndɨñ indauptok nandɨñguñ.” ");
INSERT INTO nif_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Eñɨpi yousɨmbi, amatamda enguk, “Bepnalɨ gembɨn nanandɨn gɨtɨk wɨn naka nam-taleñguk, tɨmbi en noñganlɨñgot Nɨñañ nandɨ-namlak. Tɨmbi Bep wɨn nindɨ nandɨñmañ? Wɨn Nɨñañ en ba ama nin endɨ epmbi, Bep daut semlak endɨñgot Bep nandɨñmañ. ");
INSERT INTO nif_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kena gɨm tɨmbi mɨlap bemañ sɨndɨ gɨtɨk nokoññan bɨ-talewɨt. Bɨumbi, nak pat-nandɨ samambi, sɨmbasɨ busukñewɨn. ");
INSERT INTO nif_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nak kulan busuk molom, natnala nɨm ewa lolak, wala tɨmbi sɨndɨ nambium sanañgɨlambi, manda san-daut tɨ-samlet wɨn tañgonenekalɨñ. Wɨndɨñ tɨ-kuñɨpi, gɨnañjɨlɨ busukñaneukak. Tañgotañgo nak tañgonenelɨñdok samlet wɨn tɨkembi tañgonenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Wɨn mɨlap nɨm, wɨn pañgɨtninga n.” ");
INSERT INTO nif_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Sabat pat-nandɨ nain nola Yesulɨ plaua nanañ kena boñgɨpnan ñañɨlɨmbi, gwañgwañii en kle-ñañgɨlɨñ endɨ nanañjɨla tɨmbi, kusei kɨmɨpi, plaua mɨnjɨp mep nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tɨmbi Falisi ama dɨwɨndɨ wɨn kañbi, Yesu nɨmbi eñgɨlɨñ, “Wɨ ka. Gwañgwañgailɨ Sabat pat-nandɨ naindok endɨkñe manda maklembi, kena tañ.” ");
INSERT INTO nif_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eumbi enguk, “Devit gɨt nolii en gɨta pakɨlɨñ endɨ nanañ gawat inda-semgukta Devittɨ nɨtek tɨñguk? Sɨndɨ kasat wɨn pinapi nandañ, gan nandɨ-kamalañ bek? ");
INSERT INTO nif_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Endɨ Anutulok sel it gɨnañ lombi, plaua nanañ simbi, Anutula tapma tɨñmɨmɨn wɨn mep pɨumbi, sambalii gɨta nañgɨlɨñ. Plaua wɨn tapma ama endɨñgot nanalok, gan Devit gɨt nolii endɨ kɨmɨsip manda maklembi nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tɨmbi endɨkñe manda Moselɨ youkuk walɨ ñɨndɨñ nɨnɨ-daut nɨmlak wɨn sɨndɨ wɨndɨñgangot pinat nandɨmbi kamalañ bek: Sabat pat-nandɨ nainnan tapma amalɨ tapma it gɨnañ kena tɨñɨpi, Sabattok endɨkñe manda makleañ, gan walɨ Anutulok dainan yom nɨm indalak. ");
INSERT INTO nif_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tapma ittok kandañ nak ñɨndɨñ sanlet: nepek ñɨ patak wolok loloñɨlɨ tapma it maklelak. ");
INSERT INTO nif_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Tɨmbi Anutulok mandalɨ ñɨndɨñ elak, ‘Nak ama gɨnañ busuk tɨ-semnelɨñdok nandɨlet, tapma tɨ-namañ wala nɨm.’ Sɨndɨ manda wolok kusei nandɨ-kɨliñeumda, ama yom nɨm tañ en yom plon nɨm yapɨtnelɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nekta, Amalok Nɨñañ Anutulɨ nɨ-mukuk endɨ Sabat pat-nandɨ nain wolok molom.” ");
INSERT INTO nif_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesulɨ waliningan yousɨm ñambi, it kiyaunjɨnan loñguk. ");
INSERT INTO nif_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tɨmbi ama no kii tombon dalandan endɨ wolok bɨm pakuk. Wɨndɨñda ama dɨwɨsɨlɨ Yesu manda plon kɨmɨtnepi nɨ-nandɨmbi eñgɨlɨñ, “Dɨk nɨtek nandɨlañ? Ama nolɨ Sabatta ep tɨmbɨ kɨndem da wɨn kɨndem tɨmbek ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Eumbi enguk, “Sɨndoññan nanin no endok sipsip noñgangot palmek walɨ Sabat nainnan ban gɨnañ pɨumbi, endɨ nɨtek tɨmbek? Endɨ sipsip wɨn tɨke tiañeumbi lambɨuk bek. ");
INSERT INTO nif_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Gan amalɨ loloñ sɨnɨk, sipsip maklelak yañ! Wala tɨmbi Sabat nainnan kundit kɨndem tɨ-semeñ wɨn kɨndem.” ");
INSERT INTO nif_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Eñɨpi, ama wala ñɨndɨñ nɨñguk, “Kɨka kot-suat” eumbi, amalɨ wɨndɨñ tɨmbɨmbi, kiilɨ bɨnda kɨndem dambi, tombon wandin tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Gan Falisi amalɨ mɨlapi pɨ ñambi, kɨmɨn tɨmbi, telak nɨtek plon Yesu wɨlɨ kɨmnelɨñdok manda e-lonjɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesulɨ wɨn nandɨ-daklembi, walinin pɨm ñañguk. Tɨmbi amatam asuptɨ Yesu kle ñaumbi, jɨmbatsɨat gɨtɨk ep tɨmbɨ kɨndem daumbi, ");
INSERT INTO nif_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","kena tɨñguk wolok gɨñgɨt joñgo nɨm eu satauktok e-kɨmɨsip tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Endɨ wɨndɨñ tɨmbɨmbi, Anutulɨ plofet Aisaialok man plon Mesialok manda ñɨndɨñ eñguk wolok bien inda-dakleñguk, ");
INSERT INTO nif_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ñɨn nokok kena gwañgwa nak en natnalok kasɨleñgut. En wakan nak gɨnañnalɨ kasɨlembi, nandɨ-koñgom tɨ-ñɨmbi, endoññan Woñna kɨmɨlɨmetat. Tɨmbi nak telak nɨtek plon amatam ep tɨmba dɨndɨmenekalɨñ wɨn endɨ kwelalok amatamda enɨ-dakle-semekak. ");
INSERT INTO nif_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Endɨ gimbɨt ba manda kwambɨñlok nɨm, tɨmbi endɨ pañga indanan manda nɨm eu pɨukak. ");
INSERT INTO nif_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Endɨ klinandok kundɨt gembɨn nɨmnat gɨloup tɨlak wandin no nɨm ombekak, ba tipalalok kolsalen duat pɨtpɨt tɨlak wandin no nɨm pendɨlɨm kɨmbekak. Endɨ kenane-palɨmbi, amatam dɨndɨm indanelɨñdok telak walɨ inda-dakleukak wolok tuop. ");
INSERT INTO nif_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tɨmbi kwet tuop ama walɨ bɨmbi epmektok en mandɨ-patnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nain wolonda ama no Yesuloñ nañgɨp bɨñgɨlɨñ, wɨn yal kolanlɨ pɨñmɨñgukta tɨmbi man ba dai tɨpelatkan sipgɨmɨk. Tɨmbi Yesulɨ tɨmbɨ kɨndem daumbi, nepenepek kañbi manlɨ manda eelok salaktañmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tɨmbi amatam gɨtɨktɨ kundit wɨn ka sɨlɨkñembi, nɨsɨñgan e-nandɨ tɨmbi pa eñgɨlɨñ, “Ama Wapmañ Devittok Komblin bɨmbɨlok e-ta-bañ wɨn ñakan bek?” ");
INSERT INTO nif_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Gan Falisi amalɨ manda wɨn nandɨñgɨlɨñda tɨmbi Yesula ñɨndɨñ eñgɨlɨñ, “Wɨn yal kolandok telak damanjɨ Belsebul endok gembɨnlañgot yal kolan ep kle-semlak.” ");
INSERT INTO nif_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesulɨ nanandɨnjɨ ka-nandɨñgukta ñɨndɨñ enguk, “Ama wapmañ nolok gɨñgɨtñiilɨ tambɨpi nɨsɨñgan miañ endɨ kola sɨnɨk tañ. Ba it kwet ba sambat nolɨ wɨndɨñgangot tañ endɨ nɨm dɨñdam patnelɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wɨndɨñgangot Satandok gɨñgɨt nolɨ enlok nol no kle kolɨmda, Satandɨ enla mik tɨñmumbi, endok ka-dɨkñenlɨ plakan talewɨk. ");
INSERT INTO nif_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Sɨndɨ ‘Ama walɨ Belsebullok gembɨnla yal kolan ep kle-kot pa tɨlak’ wɨndɨñ naka nanɨañ. Manda wɨn bien tɨmbekta, nindɨ sɨndok gwañgwanjii gembɨ emumbi, yal kolan ep kle-kot pa tañ? Belsebul ba? Nɨmda, manda nokok gembɨnalok kuseila eañ wolok bien nɨm inda-daklelak yañ. ");
INSERT INTO nif_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wɨn Anutu enlok Woñdɨ nep plataumbi, yal kolan ep kle kotet, Belsebullɨ nɨm. Wɨndɨñda ñɨndɨñ inda-daklelak: Anutulɨ ikan sɨndok boñgɨpsɨnan amatam yambɨ-dɨkñelak. ");
INSERT INTO nif_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ba ama nolɨ ama gembɨnat nolok it gɨnañnan slak lombi, gɨñgɨtñii joñgoñgan epmektok tuop ba? Nɨm ya! Dama endɨ ama gembɨnat wɨn tɨkembi, toalɨ ap imbi bium palmek, nepek nek it gɨnañ pakañ wɨn gumañ ep talewɨk. ");
INSERT INTO nif_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ama no nak not nɨm tɨ-namlakta, endɨ kanjɨk tɨ-namlak. Tɨmbi ama no nak nɨm nep platambi, Anutuloñ amatam nɨm ep kɨmɨn tɨlakta, endɨ ep kleum papuseneañ. ");
INSERT INTO nif_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wɨndɨñda ñɨndɨñ sanlet: amatam yom tañ ba Anutu nɨ-kolayañ, endok yomjɨ gɨtɨk Anutulɨ gumañ bi-semekak, gan ama no Dɨndɨm Woñ nɨ-kolalakta, endok yomɨn Anutulɨ nɨm biñmekak. ");
INSERT INTO nif_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tɨmbi ama no Amalok Nɨñañ enda manda kolan elakta, endok yomɨn Anutulɨ gumañ biñmekak, gan ama no Dɨndɨm Woñ gembɨn namlak, enda manda kolan elakta, endok yomɨn Anutulɨ man ñɨndɨñgɨt ba nain taletalenan bo nɨm biñmekak. Wɨndɨñda kusatnala gɨnañ tɨpet nombo nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Komba no kɨndemda, endɨ bien kɨndemgot pa lalilak, tɨmbi komba no kolanda, endɨ bien kolangot pa lalilak. Wɨn komba walɨ kolan ba kɨndem wɨn bienlɨ mek daut samlak. ");
INSERT INTO nif_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Sɨndɨ manjɨ manbenjɨ malet upmat nomɨk. Ama kolanda, nɨtek tɨmbi manda kɨndem enelɨñ? Nepek kusei kusei ama nolok gɨnañnan tokñelakta, wakan eu lambɨlak. ");
INSERT INTO nif_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ama kɨndem nepek kɨnde kɨndem gɨnan gɨnañ pa wɨsɨ-kotak, endɨ nepek kɨndemgot pa tɨlak, tɨmbi ama kolan nepek kola kolan gɨnan gɨnañ pa wɨsɨ-kotak, endɨ nepek kolangot pa tɨlak. ");
INSERT INTO nif_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nak ñɨndɨñ sanba: Anutulɨ amatam sambɨ-danbekak nain wolonda endɨ manda kolan gɨtɨk eñgɨlɨñ wolok kusei e-daklenelɨñdok sanbekak. ");
INSERT INTO nif_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Neta, Anutulɨ mandañga kañ-danbi, wolok tuop dɨk ama dɨndɨm ba ama kolan ganbɨ indaukak.” ");
INSERT INTO nif_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tɨmbi endɨkñe manda nandɨ-tale ama gɨta Falisi ama endoññan nanin dɨwɨndɨ Yesu nɨñgɨlɨñ, “Endaut, dɨk nandɨ-nɨmbi, kundit engano sɨnɨk no tɨmbɨmbi kanetamɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Gan endɨ ñɨndɨñ tambane enguk, “Amatam man ñɨndɨñgɨt kuañ sɨndɨ kolan tɨmbi, Anutu bi-sɨnɨk tañ. Sɨndɨ kundit no kanepi pa nandañ, gan plofet Yonalok kundilɨñgot daut samum kanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yonalɨ tim sandap tɨpet gɨt no tuk gaut wopumdok mɨnjɨp gɨnañ pakuk. Wɨndɨñgangot Amalok Nɨñañ endɨ bo maim tɨpet gɨt no kwet gɨnañ palekak kanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nandañ: Anutulɨ amatam manda plon yapɨlekak nain wolonda Niniwe nasi Yonalok molo manda nandɨñgɨlɨñ endɨ amatam man ñɨndɨñgɨt kuañ sɨn gɨta yakan mɨlapi, sɨndok kusasɨ tɨmbɨ dakleukak. Neta, endɨla Yonalok mandala gɨnañjɨ tambaneñgɨlɨñ, gan sɨndɨla ama nin Yona maklelak endok manda nandɨmbi, gɨnañjɨ nɨm tambaneñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wɨndɨñgangot Anutulɨ amatam manda plon yapɨlekak nain wolonda kwet koi Siba wolok tam wapma endɨ bo amatam man ñɨndɨñgɨt kuañ sɨn gɨta yakan mɨlapi, sɨndok kusasɨ tɨmbɨ dakleukak: endɨla ama wapmañ Solomondok nanandɨ kɨndem nandɨuktok kwet mayañgan nanin sɨnɨk walɨ endoñ bɨñguk, gan sɨndɨla ama Solomon maklelak endok mandan nandɨ-kɨmneñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yesulɨ yousɨmbi enguk, “Yal kolan nolɨ ama no ka-mɨsɨm poñawɨkta, endɨ kwet kasatnan ña bɨt tɨmbi, pipapat komblin lonjɨwɨk. Lonjɨm nɨm kañbi, ");
INSERT INTO nif_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","enla ñɨndɨñ ewɨk, ‘Nak bɨndambo undane it dama pakutnan ñawa’. Embi ña kawɨk wɨn: it wɨn jamimbi tɨ-kɨliñem biumbi, itgot palek. ");
INSERT INTO nif_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kañbi pɨ ñambi, yal kolan kɨt tambon tambon tɨpet endok gembɨnjɨlɨ en makleañ ep tɨmbɨ indambi yanañgɨlɨm, it wolok gɨnañ lombi pi pat mɨlat tɨnelɨñ. Wɨndɨñda tɨmbi damañgan ama wala mɨlap lakat indañmɨñguk, gan man mɨlap wopum sɨnɨk indañmek. Enda indañmɨñguk, wɨndɨñgangot amatam man ñɨndɨñgɨt kolan tɨ-kuañ sɨndoñ inda-samekak.” ");
INSERT INTO nif_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesulɨ amatam manda en-palɨñɨlɨmbi, meñ gɨt kwayañii endɨ bɨ tombi, pawan ipi, en gɨta manda e-nandɨ tɨnelɨñdok eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tɨmbi ama nolɨ Yesu nɨmbi eñguk, “Nandɨlañ. Meñga kwayañgai pawan bɨ ipi, dɨkɨta manda e-nandɨ tɨnepi nandañ.” ");
INSERT INTO nif_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Gan Yesulɨ ama wala ñɨndɨñ tambane nɨñguk, “Mena kwayanai wɨn nin?” ");
INSERT INTO nif_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Eñɨpi, gwañgwañiila kɨt yout tɨ-sembi nɨñguk, “Ñɨ ka: mena kwayanai ñɨ pakañ. ");
INSERT INTO nif_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Neta, no en Bepna kunum gɨnañ patak endok man tañgonelakta, endɨ wakan nokok mena, kwayanai, ba witnai biañgan t añ.” ");
INSERT INTO nif_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sandap wolonda Yesulɨ it bimbi, tuk guañnan ñambi, amatam enɨ-daut tɨ-semepi tuk baliliñnan ña pipakuk. ");
INSERT INTO nif_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tɨmbi amatam asuptɨ endoñ bɨ kɨmɨn tɨñgɨlɨñda tɨmbi, endɨ kɨkeñ nolok plon lombi pipakuk. Pipalɨmbi, amatam kɨmɨn wopum endɨ tuk pawan ilɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","e-yout mandalɨ nepek asuptok plon enɨ-daut tɨ-semguk. Tɨ-semñɨpi ñɨndɨñ enguk, “Nandañ. Ama nolɨ nanañ mɨnjɨp kokotta kenañ gɨnañ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ñambi, mɨnjɨp kot-tɨ-kot-tɨ-ñañɨlɨmbi, mɨnjɨp dɨwɨn telak plon pɨumbi, monɨktɨ bɨm na-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Tɨmbi mɨnjɨp dɨwɨndɨ kawattɨ salaiumbi kwet lakatgot pakuknan pɨñgɨlɨñ. Mɨnjɨp kwet plongot pakɨlɨñda tɨmbi mindin plakan tawa lambɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Gan kakailɨ sua embi, kwet nɨm tɨke gembɨlaumbi, maimdɨ lambɨ ep dɨumbi, yañetambi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Mɨnjɨp dɨwɨndɨ kwet koselek mɨnjɨp pakuknan pɨñgɨlɨñ endɨ yakayakan tawa lambumbi, koselektɨ bendɨmbi ep tapliumbi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mɨnjɨp dɨwɨndɨ kwet galk gɨnañ pɨñgɨlɨñ walɨ lambɨm wopum dambi, bien laliñgɨlɨñ. Kusei dɨwɨndɨ bien 100 100 laliñgɨlɨñ, dɨwɨndɨ bien 60 60 laliñgɨlɨñ, tɨmbi dɨwɨndɨ bien 30 30 wɨndɨñ lali-ta-ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","No en pawañnat endɨ mandana nandɨmbi nandɨ-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Papalembi, Yesulok gwañgwañiilɨ endoñ bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Amatam manda enlañ wɨn kusei nɨtekta tɨmbi e-yout manda gɨta pa enlañ?” ");
INSERT INTO nif_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Eumbi tambane enguk, “Kunum Molomdɨ amatam telak nɨtek yambɨ-dɨkñelak wɨn damañgan pat-sembɨn pakuk. Nepek wɨn endɨ sɨnda sanbɨ dakle-talelak, gan amatam dɨwɨnda nɨm. ");
INSERT INTO nif_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Neta, no en nepek palmɨlak wɨn tɨke-kuumbi, enda nombo yousɨ-mɨumbi, asupgan palmekak. Gan no en nepek palmɨlak wala nandum tlal tɨlakta endok nepek lakat palmɨlak wɨn apma tɨkeñmɨumbi, slak palekak. ");
INSERT INTO nif_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ama wandisɨ walɨ dautsɨlɨ kañ, gan nɨm ka-dɨndɨm eañ, ba pawanjɨ kɨmɨkañ, gan nɨm nandañ ba nɨm nandɨ-dakleañ, wala tɨmbi nak manda e-yout manda gɨt pa enlet. ");
INSERT INTO nif_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Plofet Aisaialɨ nek indauktok eñguk wɨn man ñɨndɨñgɨt amatam wandisɨloñ inda-semlak. Endɨ Anutulok mandan ñɨndɨñ eñguk, ‘Amatam ñalɨ manda nandɨnekalɨñ, gan nɨm nandɨ-daklenekalɨñ, ba dautsɨlɨ kanekalɨñ, gan nek kañ wɨn nɨm ka-nandɨ-tomnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nekta, endok gɨnañ nanandɨnjɨlɨ kwambɨñ dañgukta, pawanjɨlɨ manda nandɨnepi kunjit tañ, ba dautsɨlɨ nɨm kanelɨñdok masipmañ. Wɨndɨñ nɨm tɨmbɨmda, endɨ dautsɨlɨ kañbi, pawanjɨlɨ nandɨmbi, gɨnañjɨlɨ nandɨ-tombi, gɨnañjɨ tambaneumbi, nak ep tɨmba kɨndem danelɨñdok nokoññan bɨnelɨñ.’ Anutulɨ amatamdok plon manda wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Gan sɨndɨla dautsɨlɨ kɨndem kañ, tɨmbi pawanjɨlɨ guma nandañ, wala tɨmbi amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nak biañgan sɨnɨk sanba: plofet ama gɨta ama dɨndɨm damañgan kuñgɨlɨñ endɨ nepek sɨndɨ kañ wɨn kanepi nandɨ-koñgom tɨñgɨlɨñ, gan nɨm kañgɨlɨñ, ba manda sɨndɨ nandañ wɨn nandɨnepi nandɨ-koñgom tɨñgɨlɨñ, gan nɨm nandɨñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila enbi eñguk, “Sɨndɨ pawanjɨ kɨmɨpi, mɨnjɨp kokottok e-yout manda sanɨt wolok kusei san-daklewambi nandɨwɨt. ");
INSERT INTO nif_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nanañ mɨnjɨp telak plon pɨñguk manda wolok kusei wɨn ñɨndɨñ: amalɨ Anutulɨ amatamñii nɨtek yambɨ-dɨkñelak wolok gɨñgɨt manda nandɨmbi nɨm tɨke-kulak, tɨmbi kolan molomdɨ bɨmbi, manda gɨnañnan kokolɨn wɨn apma tɨkeñmɨlak. ");
INSERT INTO nif_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mɨnjɨp kawat plon pɨñguk manda wolok kusei wɨn ñɨndɨñ: amalɨ gɨñgɨt manda sɨlɨsɨlɨnat nandɨmbi, plakan gɨnan gɨnañ dasilak, ");
INSERT INTO nif_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","gan manda gɨnan gɨnañ pɨlak walɨ nɨm pa kwambɨñ dalak. Nɨm, walɨ nain dumangot papi pailɨmlak. Wɨn kuñgunlok plon mɨlap indañmɨlak, ba Anutulok manda tɨke-kuañ endok plon mɨlap kusei kusei inda-semum yambɨlak, nain wolongan nanandɨ-kɨlɨktɨn pi pɨlak. ");
INSERT INTO nif_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ba mɨnjɨp kwet koselek mɨnjɨp pakuknan pɨñguk manda wolok kusei wɨn ñɨndɨñ: amalɨ gɨñgɨt manda wɨn nandɨlak, gan kwelalok mɨlap ba mɨnem kwɨlɨkwɨlɨ wolok nandɨ-koñgomlɨ gɨnañ tɨmbɨ pailɨmbi, manda nandɨlak wolok bien nɨm indañmɨlak. ");
INSERT INTO nif_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Mɨnjɨp kwet galk gɨnañ pɨñgɨlɨñ manda wolok kusei wɨn ñɨndɨñ: amalɨ gɨñgɨt manda wɨn nandɨmbi nandɨ-kɨliñ embi, kɨmɨt kle kuañ. Endok bien wɨn 100 ba 60 ba 30 wolok tuop indalak.” ");
INSERT INTO nif_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tɨmbi Yesulɨ yousɨmbi, e-yout manda no amatamda ñɨndɨñ enguk, “Kunum Molomdɨ gɨñgɨtñii yambɨ-dɨkñelak wɨn ñɨndɨñ: ama nolɨ kenan gɨnañ nanañ kɨndemlok mɨnjɨp kokuk, ");
INSERT INTO nif_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","gan tim boñgɨpnan ama gɨtɨktɨ dou-palɨñɨlɨmbi kanjɨkñɨlɨ kena wolok ñambi, kli kolandok mɨnjɨp kopi pi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pakapi, mindin tawa lambɨmbi, bien indaup tɨmbɨmbi, kli kolandɨ bo inda-dakleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Inda-dakleumbi, ama wolok kena gwañgwañiilɨ wɨn kañbi, molomloñ ñambi nɨñgɨlɨñ, ‘Wopum, dɨk kenañga gɨnañ mɨnjɨp kɨndemgot kokuñ. Gan nɨtek tɨmbi, kli kolanlɨ indalak?’ ");
INSERT INTO nif_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wɨndɨñ nɨ-nandumbi enguk, ‘Wɨn kanjɨkna nolɨ kolɨmbi lambɨlak.’ Eumbi nɨ-nandɨmbi eñgɨlɨñ, ‘Wɨndɨñda nɨndɨ ña kli wɨn tamat kotnetamɨñ ba?’ ");
INSERT INTO nif_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Eumbi enguk, ‘Wɨndɨñ nɨm. Kak biu palen. Nɨm kañbi, kli tamat kokamɨñ embi, nanañ wakɨt tamatnelɨñ a. ");
INSERT INTO nif_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Biumbi, nanañ gɨta kli nɨset tɨpelatkan lambɨndekamɨk. Tɨmbi nanañ mepmettok nain indaumek, nak kena ama enbambi, dama kli moyen tamap imbi, komba gɨnañ sium dɨukak. Tɨmbi nanañ bien wɨn wɨsɨkot itna gɨnañ ep wɨsɨ-kolɨm palekak.’” ");
INSERT INTO nif_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesulɨ e-yout manda no ñɨndɨñ enguk, “Kunum Molomdok kaundɨkñe kena wɨn mastat mɨnjɨp ama nolɨ kenan gɨnañ kokuk wandin. ");
INSERT INTO nif_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastat mɨnjɨp wɨn yaya mɨnjɨp tip mɨnam sɨnɨk yañ, gan tawa lambɨlak wolonda yaya walɨ dɨwɨn yapma klembi, komba nomɨk wopum dalak, wala tɨmbi yaya wolok gayam plon monɨktɨ bɨmbi, isɨ tañ.” ");
INSERT INTO nif_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesulɨ yousɨmbi, e-yout manda no ñɨndɨñ enguk, “Kunum Molomdok kaundɨkñe kena wɨn ñɨndɨñ: tam nolɨ kɨmɨlɨ bendɨ lakatgot tɨkembi, plaua kwɨlan wopumgan wakɨt tambanembi, papalem kaumbi, plaua walɨ gɨtɨk bendɨmbi lambɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesulɨ amatam kɨmɨn wopumda manda gɨtɨñgɨtɨk enguk wɨn endɨ telal no gɨt nɨm eñguk, endɨ e-yout mandalɨñgot enguk. ");
INSERT INTO nif_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Endɨ wɨndɨñ tɨmbɨmbi, plofet ama nolɨ manda ñɨndɨñ eñguk wolok bien inda-dakleñguk, “Nak e-yout mandalɨñgot manda enbi, nanandɨ sembɨn kwet kusei kɨmɨkɨmɨlɨnan nanin pat-ta-bañ wɨn enba dakleutat.” ");
INSERT INTO nif_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tɨmbi Yesulɨ amatam kɨmɨn wopum yambɨk bimbi, gwañgwañii gɨt ilan ñañguk. Ña palɨñɨlɨmbi, gwañgwañiilɨ endoñ bɨmbi nɨkañbi eñgɨlɨñ, “Dɨk e-yout manda eñañ wɨn - kli moyen kena gɨnañ lambɨlak - wolok kusei nɨtek? Wɨn nɨnɨmbɨ nandɨna.” ");
INSERT INTO nif_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Eumbi enguk, “Ama mɨnjɨp kokuk wɨn Amalok Nɨñañ en wakan. ");
INSERT INTO nif_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kena wɨn kwet ñɨn man pakamɨñ wolok walan, tɨmbi nanañ mɨnjɨp wɨn Kunum Molomdok gɨñgɨtñii. Tɨmbi kli kolan wɨn kolan molomdok gɨñgɨtñii, ");
INSERT INTO nif_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","tɨmbi kanjɨk kli kolan mɨnjɨp ep kokuk wɨn kolan molom Satan en. Mɨnjɨp bien mepmet wɨn kwet nain taletalenan wolonda indaukak, tɨmbi kena tɨndɨ ama wɨn Anutulok añeloñii. ");
INSERT INTO nif_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kli kolan tamap wɨp siañ wɨndɨñgangot nain taletalenan kolan molomdok gɨñgɨtñii enda inda-semekak. ");
INSERT INTO nif_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nain wolonda Amalok Nɨñañ endɨ añeloñii en-mulɨmbi, kwet tuop gɨñgɨtñii endoññan nanin ama kolan tañ en ba dɨwɨn no ep tiañeumbi yom tañ endɨ wakɨt ep kɨmɨn tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","jɨmbɨñdok komba kwambɨñ gɨnañ ep kolɨ pɨnekalɨñ. Wandɨñ endɨ mano kwɨlɨm tɨmbi, manjɨ sɨ-gɨlɨm danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Gan amatam Bepsɨlok man tañgoneñgɨlɨñ endɨ kunum gɨnañ lombi, maim duatak wɨndɨñ duapi, indañgan endok kapmainan kuumbi yambɨ-dɨkñeukak. No en pawañnat endɨ mandana nandɨmbi nandɨ-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesulɨ yousɨmbi, e-yout manda enguk, “Kunum Molomdok kaundɨkñe kena wolok walan wɨn nepek tuan wopumgan sɨnɨk kena gɨnañ kɨmɨsembum pakuk wandin. Ama nolɨ nepek wɨn tɨmbɨ indambi, taplim bium pakuk. Tɨmbi sɨlɨsɨlɨ wopum indañmɨñgukta endɨ nepenepelɨ gɨtɨk ña tuatualok kɨmɨlɨm tua-taleumbi, mɨnem walinin tɨkembi, nepek tuan wopum wɨn endok indañmektok kwet wɨn ña tua kleñguk. ");
INSERT INTO nif_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tɨmbi Kunum Molomdok kaundɨkñe kena wolok walan no kawat tuan wopum wandin: ama nolɨ kawat tuan wopumgot wɨn tuaup yolonjɨñguk. Yolonjɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","kawat kɨndem sɨnɨk no kañbi, ña nepenepelɨ gɨtɨk tuatualok kɨmɨlɨm tua-taleumbi, mɨnem walinin tɨkembi, kawat wɨn ña tuañguk. ");
INSERT INTO nif_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tɨmbi Kunum Molomdok kaundɨkñe kena wolok walan no wɨn ñɨndɨñ: pis tiatia lɨk wopum tuk gɨnañ kolɨ pɨumbi, pis kusei kusei epgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lɨk tokñeumbi tiañe pawan lambɨ pipapi, pis kañ-dan tɨñgɨlɨñ, wɨn pis nanalok kɨndem kambot gɨnañ ep kɨmɨpi, pis kolan wɨn ep kokɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kwet nain taletalenan wɨndɨñ wakan indaukak: Anutulɨ añeloñii en-mulɨm bɨmbi, ama Anutulok man tañgoneañ endok boñgɨpsɨnan nanin ama kolan epbi, ");
INSERT INTO nif_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","jɨmbɨñdok komba kwambɨñ gɨnañ ep kolɨ pɨnekalɨñ. Wandɨñ mano kwɨlɨm tɨmbi, manjɨ sɨ-gɨlɨm danekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesulɨ e-yout manda eu taleumbi, gwañgwañii en-nandɨmbi eñguk, “Sɨndɨ e-yout manda gɨtɨk sanlet wolok kusei nandɨ-dakleañ ba?” Enbɨmbi, endɨ “Oñ, nandamɨñ” nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Eumbi enguk, “Wɨndɨñda endɨkñe manda nandɨ-tale amalɨ Kunum Molomdok gɨñgɨt indambi kuañ endɨ ama nepek kɨndem wɨsɨkot isɨnan kɨmɨlɨm patakñan nanin epmañ wandin: endɨ Anutulɨ nanandɨ damañgan eñguk ba man elak wɨn nandɨ-daklembi, wolok tuop amatam enɨ-daut tɨ-semañ.” ");
INSERT INTO nif_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesulɨ e-yout manda wɨn eu taleumbi, walinin pɨ ñambi, ");
INSERT INTO nif_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","il kuseinan ña tomguk. Tombi, it kiyaunjɨ gɨnañ lombi, amatam enɨ-daut tɨ-semguk. Tɨmbi amatam mandan nandɨñgɨlɨñ endɨ nandɨ-gɨtɨñgɨtɨk embi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Ama ñalɨ nanandɨ wandin ba kundit engano sɨnɨk tɨndɨlok gembɨ wɨn denanin tɨkeñguk? ");
INSERT INTO nif_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nɨndɨ endok kusei nandamɨñ yañ! Endɨla it kɨndikɨndit ama endok nɨñañgot. Meñlok koi wɨn Malia, kwayañii wɨn Jekop, Josep, Simon gɨt Judas, ");
INSERT INTO nif_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","tɨmbi endok wiwii wɨn nɨn gɨta yakan kuamɨñ. Wɨndɨñda nanandɨn gɨt gembɨn wandin wɨn nindɨ daulmɨñguk?” ");
INSERT INTO nif_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wɨndɨñ eñɨpi, endok mandan ba ep tɨndɨn wala nandum tlal tɨñguk. Tɨmbi Yesulɨ enguk, “Amatam dɨwɨndɨ plofet ama giñgiñgan tɨñmañ, gan enloñ nasii ba noliilɨ wɨndɨñ nɨm tɨñmañ.” ");
INSERT INTO nif_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Wɨndɨñ embi, nɨm nandɨ-kɨlɨktɨ tɨñmɨñgɨlɨñda tɨmbi kundit engano asup wandɨñ kandañ nɨ m tɨñguk . ");
INSERT INTO nif_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nain wolonda Galili distriktok ama wapmañ Elot endɨ Yesu koi gɨñgɨt nandɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","kena amañii ñɨndɨñ enguk, “Endɨ Yoane tuk ii-sem en wakan. Kɨmnan nanin mɨlakukta tɨmbi kundit engano tɨmbektok gembɨn wopumgan palmɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kusei ñɨndɨñda Elottɨ wɨndɨñ nandɨñmɨñguk: damañgan endɨ enlok kwayañ Filip endok tamɨn Elodia apma tɨkeñguk. Apma tɨkeumbi, Yoanelɨ ñɨndɨñ pa nɨlɨñguk, “Dɨk Elodia tamga tɨkeñguñ wɨn nɨndok endɨkñe manda maklelañ.” Wɨndɨñda Elottɨ eumbi, Yoane tɨke imbi, it kwambɨñ gɨnañ kɨmɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Elottɨ Yoane wɨlɨ kɨmbektok nandɨñguk, gan amatamda mɨsɨñgukta wɨndɨñ nɨm tɨñguk. Neta, Juda amalɨ Yoanela nandum plofet no tɨñgukta tɨmbi. ");
INSERT INTO nif_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gan wɨnaña ñɨndɨñ indañguk: Elottok indainda nain indaumbi, yokñiilok nanañ sinat tɨ-semumbi, Elodialok wembanlɨ bɨ endok dausɨnan kap tiñguk. Kap tiumbi, Elottɨ wembe wolok kapta nandɨ-koñgom tɨñgukta tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","manda ñɨndɨñ e-kwambɨñ dambi nɨñguk, “Biañgan sɨnɨk. Dɨk nepek nola ba nola nan-kautañ wolok tuop gametet.” ");
INSERT INTO nif_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wɨndɨñ eumbi, meñloñ ñaumbi, nanandɨ ñɨndɨñ mɨumbi, Elottoñ undane ñambi nɨñguk, “Dɨk eumbi, Yoane tuk ii-sem endok bim dombɨmbi, kumbam jawañ plon kɨmɨpi bɨ namɨt.” ");
INSERT INTO nif_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ama wapmañdɨ manda wɨn nandɨmbi nandum mɨlatañguk. Gan manda yokñiilok dausɨnan e-kwambɨñ dañgukta tɨmbi endɨ nandɨñmɨmbi, wembelɨ eñguk wolok tuopkan tɨnelɨñdok eñguk. ");
INSERT INTO nif_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tɨmbi it kwambɨñ gɨnañ ñambi, Yoanelok bim dombɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","kumbam jawañ plon kɨmɨpi bɨm wembe mɨumbi, meñloñ tɨke ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tɨmbi Yoanelok gwañgwañiilɨ bɨm dalandan bem ña kɨndikɨlɨñ. Wɨndɨñ tɨ-talembi, siñgi ña Yesu kasat tɨñmumbi nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yoane wɨlɨ kɨmɨñguk wolok gɨñgɨt Yesulɨ nandɨñgukta endɨ gwañgwañii gɨt walinin pɨ ñanelɨñdok kɨkeñ nolok plon lombi, kwet ama nɨmnatnan nɨsɨñgan kunepi ñañgɨlɨñ. Ñaumbi, amatamdɨ gɨñgɨt wɨn nandɨmbi, isɨ kwesɨ bimbi, kesɨttɨ en klem, tuk baliliñ ñañgɨlɨñ. Ñakap, Yesulɨ ñaupi nandɨñguknan ña tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tɨmbi Yesulɨ kɨkeñ plon nanin pɨñɨpi, amatam kɨmɨn wopum yambɨñguk. Yambɨmbi, blan tɨ-sembi, jɨmbatsɨat ep tɨmbɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kwet timlala tɨmbɨmbi, gwañgwañiilɨ Yesuloñ bɨmbi nɨñgɨlɨñ, “Kwet kɨlɨm elak. Tɨmbi ñɨn kwet ama nɨmnatnan pakamɨñ, wɨndɨñda dɨk amatam en-mulɨmbi, it kwelan ñambi, nanañjɨ tua nambɨt.” ");
INSERT INTO nif_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Eumbi enguk, “Nekta ñanelɨñdok eañ? Sɨn nanañ ep towiwɨt.” ");
INSERT INTO nif_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Eumbi, jip jup tɨmbi nɨñgɨlɨñ, “Nɨndok plaua nanañ kɨt tombon gɨt pis tɨpet walɨñgot pat-nɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Eumbi enguk, “Wɨn nokoññan mep bɨwɨt.” ");
INSERT INTO nif_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Wɨndɨñ embi, amatam enbɨmbi, kli yali gɨmbañ dambi pipakɨlɨñ. Tɨmbi Yesulɨ plaua nanañ kɨt tombon gɨt pis tɨpet wɨn epbi, kunum plon deium loumbi, Anutu weñmɨmbi, plaua wɨn ombɨmbi, gwañgwañiila emguk. Emumbi, endɨ ep papusenembi, amatam em-taleumbi, ");
INSERT INTO nif_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","gɨtɨktɨ nambi na-tokñe tɨñgɨlɨñ. Tɨmbɨmbi, dɨp pakuk wɨn gwañgwañiilɨ epmbi, sandɨñ lɨk 12 wolok gɨnañnan dasium tokñeñguk. ");
INSERT INTO nif_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nanañ nañgɨlɨñ wɨn ama 5,000 nɨtepek, gan tam gɨt wembe gwañgwa nɨm ep kunakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ama kɨmɨn gɨtɨktɨ nanañ nambɨ taleumbi, Yesulɨ gwañgwañii en-gɨñgɨnembi, nɨsɨngan kɨkeñ plon lombi, tuk guañ tambon kandañ damandama ñanelɨñdok en-mukuk. En-mulɨm ñañɨlɨmbi, amatam kɨmɨn gɨtɨk isɨnan en-mulepi pakuk. ");
INSERT INTO nif_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Papi, amatam en-mulɨm ña-taleumbi, Yesu en engan nɨmolo tɨmbepi jañgɨnnan lo pakuk. Kwet kɨlɨm eumbi, jañgɨnnan engan palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","gwañgwañiilok kɨkeñdɨ ña tuk guañ boñgɨpnan tomguk. Tombɨmbi, sasalelɨ ñañgɨlɨñ kandañnan bɨñgukta, tuktɨ kɨkeñ munjupi, tɨke lombi pɨmbi tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kwet gama nɨm salañɨlɨmbi, Yesulɨ guañ plon yali ta-ñakap gwañgwañii ep tɨmbɨ dumalañguk. ");
INSERT INTO nif_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tɨmbi gwañgwañiilɨ tuk plon yaliyali bɨumbi kañbi, “Asilɨ bɨlak!” embi, gembɨnjɨ pɨumbi, mɨsɨmbi kwawa tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tɨmbi wolongan Yesulɨ enɨ-daklembi eñguk, “Nɨm mɨsɨwɨt, natna bɨlet, walenjɨ busukñewɨn.” ");
INSERT INTO nif_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tɨmbi Petlolɨ nɨñguk, “Wopum, biañgan dɨtna bɨlañda, nanbɨmbi, tuk plon yalim dɨkoñan bɨwa.” ");
INSERT INTO nif_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Eumbi nɨñguk, “Natna ya, bo!” Nɨmbɨmbi, kɨkeñ plon nanin pɨ tuk plon yalimbi, Yesuloñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ñañɨpi, sasale wopum wɨkukta tuk mɨlakuk wɨn kañbi, mɨsɨmɨsɨ ñakap tuk gɨnañ pɨup tɨmbi, kɨtɨmbi eñguk, “Wopum, nepmɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eumbi, wolongan Yesulɨ kii kot-suap tɨkembi nɨñguk, “Nanandɨ-kɨlɨktɨñga lakat pakamlak. Nekta gɨnañ tɨpet tɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wɨndɨñ eñɨpi, Petlo nañgɨlɨmbi, kɨkeñ plon loñɨlɨmbi, sasalelɨ kɨlp eñguk. ");
INSERT INTO nif_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tɨmbi gwañgwa kɨkeñ plon pakɨlɨñ endɨ Yesuloñ mɨlelem tɨmbi nɨñgɨlɨñ, “Biañgan dɨk Anutulok Nɨñañ.” ");
INSERT INTO nif_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tuk guañ dɨkñe-talembi, Genesalet it kwet kandañ lo suañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Suaumbi, wɨnasɨlɨ Yesu ka-daklembi, manda kɨmɨlɨmbi, kwet wolok tuopkan ñañguk. Ñaumbi, amatamdɨ ama jɨmbatsɨat gɨtɨk yanañgɨp endoñ bɨñgɨlɨñ. Bɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yesu dasindasin kusipgot tɨke-kanelɨñdok nɨ-nandɨ tɨñgɨlɨñ. Nɨ-nandumbi nandɨ-semumbi, tɨke-kañgɨlɨñ tuop kɨnde m dañgɨlɨ? ");
INSERT INTO nif_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tɨmbi Falisi ama gɨt endɨkñe manda nandɨ-tale ama dɨwɨndɨ Jelusalem bimbi, Yesuloñ bɨñgɨlɨñ. Bɨmbi, ñɨndɨñ nɨ-nandɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nɨtek tɨmbi, gwañgwañgailɨ bep pañniilok telak ñɨn makleañ? Endɨ nanañ nanepi, telak nɨnɨ-daut tɨ-nɨmgɨlɨñ wolok tuop kɨsɨ nɨm wɨlɨpi pa nañ.” ");
INSERT INTO nif_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Eumbi tambane enguk, “Nɨtek tɨmbi, sɨndɨ sɨnlok ep tɨndɨñ klenelɨñdok Anutulok endɨkñe manda makleañ? ");
INSERT INTO nif_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Neta, Anutu en endɨkñe manda tɨpet ñɨndɨñ kɨmɨt-nɨmguk, ‘Dɨk meñga beka giñgiñgan tɨ-semekañ’, tɨmbi ‘Ama no meñ ba beu en-kolalakta en wɨlɨ kɨmlok.’ ");
INSERT INTO nif_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Gan sɨndɨ endɨkñe manda tɨpet wɨn maklembi, amatam ñɨndɨñ enɨ-daut pa tɨ-semañ: tɨkap ama no meñ ba beu epmɨu plaptauktok nepek no palmɨlak, gan ‘Nak nepek wɨn ikan Anutulok gɨñgɨt wɨlɨmɨñgut’ wɨndɨñ enlakta, ");
INSERT INTO nif_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","endɨ kɨndem beu nɨm nandɨ-ñɨmbi, nɨm tɨmbɨ plaptalak. Wɨndɨñ tɨñɨpi, endɨ beu giñgiñgan nɨm tɨ-ñɨmbi, endɨkñe manda maklelak. Wɨndɨñda sɨndɨ sɨnlok ep tɨndɨñ klenelɨñdok Anutulok endɨkñe manda tɨmbɨ lakatalak. ");
INSERT INTO nif_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yakñesɨ! Sɨndok manjɨ manbenjɨ malet nomɨk! Anutulɨ plofet Aisaialok man plon ñɨndɨñ embi, sɨndok kolanjɨlok walan e-kɨliñ eñguk, ");
INSERT INTO nif_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Amatam ñalɨ manjɨlɨñgot kotna gɨñgɨt e-tɨke-loañ, gan gɨnañ nanandɨnjɨlɨ mayañgan sɨnɨk pat-semlak. ");
INSERT INTO nif_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Endɨ amalok nanandɨ wɨn nokok endɨkñe manda wandin enɨ-daut tɨ-semañ, wala tɨmbi endɨ nan-wowoñ tañ wɨn sɨlaningot.’” ");
INSERT INTO nif_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tɨmbi Yesulɨ amatam kɨmɨn gɨtɨk kɨtɨ-semum bɨumbi enguk, “Sɨndɨ pawanjɨ kɨmɨpi nandɨ-kɨliñ ewɨt. ");
INSERT INTO nif_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nepek nek ñalɨ ama tɨmbɨmbi, Anutulok dainan dɨndɨm palektok tuop nɨm? Wɨn nepek nanambi, mɨnjɨpnɨ gɨnañ pɨlak walɨ nɨm. Wɨn nepek kolan gɨnañnɨ gɨnañ papi, manɨ plon lambɨ pɨlak walɨ mek ama tɨmbɨ kolalak.” ");
INSERT INTO nif_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Papalembi, Yesu gwañgwañiilɨ endoñ bɨmbi nɨñgɨlɨñ, “Ba dɨk Falisi amalɨ mandañga wɨn nandɨmbi, nandɨ-kola tɨ-gamlɨñ wɨn nandɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eumbi tambane enguk, “Falisi ama endɨ kli kolan kena gɨnañ nɨsɨ lambañ wandin. Tɨmbi Bepna kunum gɨnañ patak endɨ kenan gɨnañ nepek nɨm tɨpiñguk wɨn kakasiat gɨtɨk ep tamat-taleukak. ");
INSERT INTO nif_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sɨndɨ yambium patnelɨñ. Ama dautsɨ sipsipmɨn endɨ nosii telak daut semnepi pa tañ. Tɨmbi dai sipsipmɨn nolɨ dai sipsipmɨn no telak daulɨmekta, nɨset tɨpelatkan dɨmat gɨnañ pɨndemɨk.” ");
INSERT INTO nif_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Tɨmbi Petlolɨ Yesu nɨñguk, “Dɨk e-yout manda manɨlok plon eñañ wolok kusei kɨndem nɨnbɨ dakleutak.” ");
INSERT INTO nif_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Eumbi enguk, “Gwañgwanai sɨndɨ bo nɨtek tɨmbi nandɨ-daklenelɨñdok gamañgot tɨpɨkañ? ");
INSERT INTO nif_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Sɨndɨ ñɨn nɨm nandɨ-dakleañ ba? Nepek manɨ gɨnañ pɨlak walɨ tem meñ gɨnañ pɨmbi, temdok telak plon ñambi, tem koñ gɨnañ pɨlak. ");
INSERT INTO nif_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Gan nepek manɨ gɨnañnan nanin lambɨmbi pɨlak walɨ gɨnañnɨ gɨnañ nanin lambɨlak. Tɨmbi walɨ mek biañgan ama Anutulok dainan tɨmbɨ kolalak. ");
INSERT INTO nif_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nak nepek ñandinda elet: wɨn ama gɨnañjɨ gɨnañ nanandɨ kolan kusei kusei indaumbi tañ wɨn ñɨndɨñ: ama wɨlɨ kɨm tañ, ba nolok wapai ba tamɨn kumbu tañ, ba telak joñgo kuañ, ba nepek kumbu tañ, ba ama nolok siñgin joñgoñgan siañ, ba kosɨ eu kolayañ. ");
INSERT INTO nif_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kundit wandin walɨ mek tɨmbɨmbi, amalɨ Anutulok dainan dɨndɨm patnelɨñdok tuop nɨm. Gan endɨ Falisi amalok ep tɨndɨnjɨ nɨm kɨmɨt klembi, kɨsɨ nɨm wɨlɨpi ep na-tañ walɨ nɨm ep tɨmbɨ kolalak.” ");
INSERT INTO nif_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tɨmbi Yesulɨ gwañgwañii gɨt walinin pɨ ñambi, Tilo gɨt Sidon it kwet tɨpet pakamɨkñan ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ña tombɨmbi, Kenan tam no kwet wandɨñ kuñguk endɨ endoñ bɨmbi, kɨtɨñmɨ-gɨñgɨnembi nɨñguk, “Wopum, Devittok Komblin, dɨk blan tɨmbi, mandana nandɨ-namɨñ. Yal kolandɨ wembanalok gɨnan gɨnañ pɨumbi, kola-sɨnɨk talak.” ");
INSERT INTO nif_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Eumbi, Yesulɨ nandɨ-kɨmnembi ñañguk. Tɨmbi gwañgwañiilɨ Yesuloñ bɨmbi nɨ-gɨñgɨnembi eñgɨlɨñ, “Tam walɨ kɨtɨ kɨtɨñɨpi nɨp klelak, wala tɨmbi dɨk kak nɨ-mulɨm ñaun.” ");
INSERT INTO nif_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nɨmbɨmbi enguk, “Nak Islael amatam sipsip pait-pakañ wandin endañgot nan-mulɨm bɨ indañgut.” ");
INSERT INTO nif_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yesulɨ wɨndɨñ eñguk, gan tam walɨ endoñ bɨmbi, kesɨnan mɨlelem tɨmbi nɨñguk, “Wopum, nep kɨmɨt.” ");
INSERT INTO nif_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Wɨndɨñ eumbi nɨñguk, “Wembe gwañgwalok nanañjɨ yapma tɨkembi, kamotta emem wɨn tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Eumbi nɨñguk, “Wopum, wɨn kɨndem elañ, gan molomjɨlɨ nanañ nambɨmbi dɨp pɨlak wɨn kamottɨ wakan pa nañ wɨn.” ");
INSERT INTO nif_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Wɨndɨñ eumbi nɨmbi eñguk, “Tam, nanandɨ-kɨlɨktɨñga wɨn wopum. Nandɨlañ, wolok tuop inda-gamɨn.” Eumbi, wolongan wemban kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tɨmbi Yesulɨ walinin pɨm ñam Galili distrik tombi, tuk guañ baliliñ ñam kwet kɨmɨn no wolok lombi pi pakuk. ");
INSERT INTO nif_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tɨmbi amatam asupgandɨ endoñ bɨñɨpi, amatam jɨmbatsɨat yanañgɨp bɨñgɨlɨñ, wɨn ama kesɨk nɨm kuañ wakɨt ama kɨsɨ ba kesɨsɨ dalandan, ba dausɨ sipsipmɨn ba manjɨ sipsipmɨn, ba jɨmbat dɨwɨn nolɨ epmɨ epmɨn wakɨt asup yanañgɨp bɨmbi, Yesulok kuañ kuseinan ep bɨ kɨmɨn kolɨmbi, ep tɨmbɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ep tɨmbɨ kɨndem daumbi, amatamdɨ yambɨñgɨlɨñ wɨn: ama manjɨ sipmɨn kuñgɨlɨñ endɨ manda eñgɨlɨñ, ama kɨsɨ ba kesɨsɨ dalandan endɨ kɨndem dañgɨlɨñ, ama kesɨttɨ nɨm kuñgɨlɨñ endɨ kesɨttɨ kuñgɨlɨñ, tɨmbi ama dausɨ sipsipmɨn endɨ deiñgɨlɨñ. Wɨn yambɨmbi yambɨ sɨlɨkñembi, Islael amatamdɨ Anutu nɨ-wowoñ tɨñmañ en nɨ-kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesulɨ gwañgwañii kɨtɨ-semum bɨumbi enguk, “Amatam ñalɨ sandap tɨpet gɨt no nakɨta palɨmbi, nanañjɨ talelak, wala tɨmbi nak blan tɨ-sembi, slak en-mulam ñanelɨñdok nɨm nandɨlet. Nɨm kañbi, telak plon dautsɨ kolɨmbi, katap tɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Eumbi, gwañgwañiilɨ nɨñgɨlɨñ, “Ñolok it kwet no nɨm pakañ, wala tɨmbi nɨndɨ nanañ denanin ep bɨmbi, amatam kɨmɨn wopum ñɨn ep towinambi, tuop tɨ-semek?” ");
INSERT INTO nif_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Eumbi, Yesulɨ en-nandɨmbi eñguk, “Sɨnlok plaua nanañ nɨtek pat-samlak?” Tɨmbi endɨ eñgɨlɨñ, “Plaua kɨt dɨwɨn tɨpetgot, tɨmbi pis titip lakat sɨnɨk pat-nɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wɨndɨñ eumbi, Yesulɨ amatam enbɨm nandɨmbi, kwelan pipakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tɨmbi endɨ plaua nanañ kɨt tombon tɨpet wakɨt pis wɨn epmbi, Anutu weñmɨmbi ombɨmbi, gwañgwañiila emumbi, amatam em-ta-ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tɨmbi endɨ gɨtɨk nanañ wɨn nañbi na tokñeñgɨlɨñ. Na tokñeumbi, dɨp pakuk wɨn gwañgwañiilɨ ep dasiumbi, sandɨñ lɨk wopum kɨt tombon tɨpet tokñeñguk. ");
INSERT INTO nif_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wɨn ama 4,000 nɨtepek endɨ nanañ nañgɨlɨñ, gan tam ba wembe gwañgwa endok kunakunatsɨ nɨm epgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesulɨ wɨndɨñ tɨ-talembi, amatam en-mulɨm ñaumbi, en kɨkeñ plon lombi, gwañgwañii gɨt Magadan ka ndañ ñañgu k. ");
INSERT INTO nif_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Tɨmbi Falisi gɨt Sadusi ama dɨwɨn Yesuloñ bɨñgɨlɨñ endɨ sɨsoñ tɨñmɨnelɨñdok ñɨndɨñ nɨñgɨlɨñ, “Kunum Molomdok gembɨn pakamlakta wɨn nɨnda daut nɨmeñdok dɨk kundit engano sɨnɨk no tɨmbɨmbi kana.” ");
INSERT INTO nif_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Eumbi tambane enguk, “Maimdɨ pɨ sembep tɨmbɨmbi, kunum gɨm daumbi, sɨndɨ ñɨndɨñ pa eañ, ‘Desa nain kɨndem indaukak.’ ");
INSERT INTO nif_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kwet salaumbi, mulukualɨ kunum masipmɨlak wala sɨndɨ ñɨndɨñ pa eañ, ‘Gwi sasale inda-nɨmetak.’ Wɨndɨñda sɨndɨ kunum kañbi, maim iletak ba gwi wɨletak wɨn kɨndem ka-dakleañ. Gan sɨndɨ man ñɨndɨñgɨt nepek nek indalak wɨn kañbi, wolok kusei nɨm ka-nandɨ-dakleañ. ");
INSERT INTO nif_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nɨtek tɨmbi ama man ñɨndɨñgɨt kuañ sɨndɨ kolan tɨmbi, Anutu bi-sɨnɨk tañɨpi, kundit engano kanep kɨtɨ-nandañ? Gan kundit no nɨm daut samum kanekalɨñ. Nɨm. Ñɨn noñgangot kanekalɨñ: wɨn plofet Yona indañmɨñguk wɨndɨñgangot inda-namekak.” Yesulɨ wɨndɨñ embi yambimbi pɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tuk guañ tambon kandañ tɨmbɨ dumalanelɨñdok ñañɨpi, gwañgwañiilɨ kamalambi, plaua nanañ no nɨm ep ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tɨmbi Yesulɨ enguk, “Sɨndɨ Falisi gɨta Sadusi endok plaua kɨmɨlɨ bendɨla ka-kɨliñ enekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wɨndɨñ eumbi, nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, “Plaua nanañ nɨm tɨke-bɨmɨñ wala elak bek.” ");
INSERT INTO nif_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesulɨ wɨn yambɨ-nandɨmbi enguk, “Nekta sɨngan ‘Plaua nɨm pat-nɨmlak’ wɨndɨñ e-nandɨ-tañ? Biañgan nanandɨ-kɨlɨktɨnjɨ wɨn lakat sɨnɨk pat-samlak. ");
INSERT INTO nif_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Kusatna gama nɨm nandɨ-dakleañ bek? Nak plaua nanañ kɨt dɨwɨngot wɨn tambɨpi, ama 5,000 ep towiwambi, sɨndɨ dɨp palɨmbi, sandɨñ lɨk 12 dasium tokñeñguk wɨn sɨndɨ nɨm nandɨ-tomañ ba? ");
INSERT INTO nif_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ba plaua kɨt tambon tɨpet walɨ ama 4,000 ep towiwambi, dɨp palɨmbi, sandɨñ lɨk wopum nɨtek dasiñgɨlɨñ? ");
INSERT INTO nif_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nɨtekta tɨmbi, sɨndɨ mandana nɨm nandɨ-dakleañ? Nak plaua nanañla nɨm et, wɨn nak Falisi gɨt Sadusi endok plaua kɨmɨlɨ bendɨla ka-kɨliñ enelɨñdok sanɨt.” ");
INSERT INTO nif_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wɨndɨñ eumbi, kombɨkmek ñɨndɨñ nandɨ-dakleñgɨlɨñ: endɨ nanandɨ Falisi gɨt Sadusilɨ amatam emañ wala ka-kɨliñ enelɨñdok enguk, plaua kɨmɨlɨ bendɨ wala nɨm. ");
INSERT INTO nif_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tɨmbi Yesulɨ gwañgwañii gɨt it kwet no koi Sisalia Filipai wandɨñ kandañ ñañguk. Ña tombi, gwañgwañiila en-nandɨ tɨmbi eñguk, “Amatamdɨ Amalok Nɨñañ enda nin sɨnɨk pa eañ?” ");
INSERT INTO nif_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Eumbi nɨñgɨlɨñ, “Dɨwɨndɨ Yoane tuk ii-sem eumbi, dɨwɨndɨ plofet Elia nombo indauptok een ip wakan bek eumbi, dɨwɨndɨ plofet Jelemaia ba plofet no damañgan kuñguk en wɨndɨñ pa ganɨañ.” ");
INSERT INTO nif_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Wɨndɨñ eumbi enɨ-nandɨmbi eñguk, “Tɨmbi sɨnɨla naka nin sɨnɨk pa nanañ?” ");
INSERT INTO nif_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Enɨ-nandumbi, Simon Petlolɨ nɨñguk, “Dɨk Mesia, Anutu kuñgu molom endok Nɨñañ.” ");
INSERT INTO nif_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Eumbi, Yesulɨ nɨñguk, “Simon Yoanelok nɨñañ, dɨk amatam dɨwɨn yapma kle-patañ. Nanandɨ wɨn amalok nanin nɨm. Bepna kunum gɨnañ patak endɨ ganbɨm dakleñguk. ");
INSERT INTO nif_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wɨndɨñda nak ñɨndɨñ ganlet: koka komblin Petlo kɨtɨlet, wɨn Kawat. Tɨmbi nak kawat wolok plon kɨkesɨmɨnnai yapɨlam gembɨlambi bendɨ wopum danekalɨñ. Bendɨ wopum daumbi, kɨmdok gembɨnlɨ bo kɨkesɨmɨnnai ep tɨmbɨ pɨuktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tɨmbi Kunum Molomdok amatamñii yambɨ-dɨkñewɨñdok nak gembɨ gamlet. Dɨk nepek nola kwelan e-wiat tɨ-semumbi, Kunum Molomdok dainan wɨndɨñgot wiawiat indaukak, tɨmbi dɨk nepek nola e-wiat nɨm tɨ-semumbi, Kunum Molomdok dainan wɨndɨñgot gama pat-semekak.” ");
INSERT INTO nif_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wɨndɨñ eñɨpi, kɨmɨsip kwambɨñ tɨ-sembi, enla en Mesia, Anutulɨ ama wapmañ nɨ-mulektok e-kwambɨñ dañguk wɨn joñgo nɨm eelok enguk. ");
INSERT INTO nif_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nain wolonda Yesulɨ kusei kɨmɨpi, nepek indañmekak wala gwañgwañiila ñɨndɨñ en-sɨwɨkuk: endɨ Anutulok man tañgoneuptok Jelusalem it kwelan loumbi, Juda ama biesɨ gɨta tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama endɨ mɨlap kusei kusei tɨñmɨnekalɨñ. Tɨñmumbi, Roma amalɨ wɨlɨm kɨmbɨmbi, sandap tɨpet gɨt no tɨmbɨmbi, Anutulɨ tɨmbɨ mɨlalekak. ");
INSERT INTO nif_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wɨndɨñ eumbi, Petlo engan Yesu nañgɨpi, ña nɨ-ñombɨmbi nɨ-kɨmɨsip tɨñɨpi, Anutulɨ kamaiuktok embi nɨñguk, “Wopum, mɨlap wandin sɨnɨk bo nɨm inda-gamekak.” ");
INSERT INTO nif_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Eumbi tambanem, Petlola ñɨndɨñ nɨñguk, “Satan, dɨk wi! Dɨk Anutulok nanandɨ nɨm klelañ. Nɨm. Dɨk amalok nanandɨ klembi, telak masip tɨ-namlañ.” ");
INSERT INTO nif_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wɨndɨñ embi, gwañgwañii gɨtɨkta enbi eñguk, “Ama no en nak nep kle kuup nandɨlakta, endɨ enlok nanandɨnla nandum tlal tɨmbɨmbi, endɨ kloñbatlɨ tɨke bembi, nep kle kuuktok sanlet. ");
INSERT INTO nif_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Neta, no en kuñgun enlok kasɨleupi nandɨlakta, endok kuñgun pailɨmekak, gan no en naka tɨmbi kuñgun bi-namlakta, endɨ kuñgun taletalen nɨmnat indañmekak. ");
INSERT INTO nif_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tɨkap ama nolɨ kwelalok nepenepek gɨtɨk kasɨlewɨk, gan siñgi en jɨmbɨñ pɨwɨk, nain wolonda nepek walɨ nɨtek tɨke-kɨmɨlek? Tɨmbi kuñgun taletalen nɨmnat wɨn bɨndambo nɨtek kasɨlewɨk? Wɨn tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kusei ñɨndɨñda wɨndɨñ elet: Amalok Nɨñañ endɨ Beulok gembɨn walalannat añeloñii yanañgɨpi undane bɨupi tɨlak. Undane bɨmek, amatam gɨtɨktɨ ep tɨndɨnjɨ nek tɨñgɨlɨñ wolok tuopkan tuanjɨ emekak. ");
INSERT INTO nif_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nak biañgan sɨnɨk sanba: ama ñɨ pakañ sɨndok boñgɨpsɨnan nanin dɨwɨndɨ gamañgot kwelan kuñɨlɨmbi, Amalok Nɨñañdɨ amatam yambɨ-dɨkñeuktok bɨ indaumbi kanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Maim kɨt tambon noñgan taleumbi, Yesulɨ gwañgwañii tɨpet gɨt no, wɨn Petlo, Yakobo gɨta kwayañ Yoane, yanañgɨlɨmbi, kwet jañgɨn ombap no wolok lombi, nɨsɨñgan pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pakapi, gwañgwañiilɨ kañɨlɨmbi, Yesulok pɨñgɨu walan engano tɨkɨleñguk, wɨn timan dai maim daut wandin, tɨmbi dasindasin wɨn kolsalen walalan sɨnɨk saleñguk. ");
INSERT INTO nif_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tɨmbi platik sɨnɨk plofet ama tɨpet damañgan kuñgɨmɨk, wɨn Mose gɨt Elia, endɨ gwañgwañiiloñ indambi, Yesu gɨt manda e-nandɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wɨndɨñ tɨmbɨmbi, Petlolɨ Yesula nɨñguk, “Wopum. Nɨndɨ ñɨ pakamɨñ wɨn kɨndem sɨnɨk. Wala tɨmbi dɨk ñɨndɨñ nandɨwɨñda, nak it jala tɨpet gɨt no kɨndiletet, wɨn no dɨkok, no Moselok, no Elialok.” ");
INSERT INTO nif_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petlolɨ manda wɨndɨñ eñɨlɨmbi, mulukua walalan sɨnɨk walɨ platik sɨnɨk ep tɨmɨlɨmbi, mulukua gɨnañ nanin manda no ñɨndɨñ kɨtɨu pɨumbi eñguk, “Ñɨne nokok nɨñana sɨnɨk. Nak gɨnañnalɨ en kasɨlembi, enda wale kɨndem tɨñmɨlet, wala tɨmbi sɨndɨ endok mandan nandɨmbi kɨmɨt-klenekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tɨmbi gwañgwañiilɨ manda wɨn nandɨmbi, gembɨnjɨ pɨumbi, gapok pɨmbi, timanjɨ daut kwelan pɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Gan Yesulɨ endoñ ñambi, ep kañbi enguk, “Mɨlalet! Sɨndɨ nɨm mɨsɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wɨndɨñ enbɨmbi, endɨ deimbi kañgɨlɨñ wɨn: Yesu en noñgan ilɨmbi kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Walinin kwet jañgɨn plon nanin pɨñɨpi, Yesulɨ gwañgwañii e-kɨmɨsip tɨ-sembi enguk, “Nepek ñɨn kalɨñ wolok kasat ama nimbek nola nɨm enɨnekalɨñ. Gamamek, Amalok Nɨñañ endɨ kɨmnan nanin mɨlalekak, wolondamek kɨndem enɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tɨmbi gwañgwañiilɨ nɨ-nandɨmbi eñgɨlɨñ, “Wɨndɨñda kusei nekta endɨkñe manda nandɨ-tale amalɨ ñɨndɨñ pa eañ, ‘Plofet Elialɨ Mesialok telak dama tɨmbi bɨukak’?” ");
INSERT INTO nif_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Eumbi enguk, “Biañgan Elialɨ dama undane bɨmbi, amatam tɨ-pañgɨpañgɨle tɨ-semekak. ");
INSERT INTO nif_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gan natna ñɨndɨñ sanlet: plofet no Elia wandin endɨ ikan bɨñguk, gan amalɨ endok kusei gama nɨm ka-nandɨ-dakleñgɨlɨñ. Endɨ nɨsɨlok nanandɨnjɨ klembi, kundit kolan kusei kusei tɨñmɨñgɨlɨñ. Tɨmbi Amalok Nɨñañla kolan wɨndɨñgangot tɨñmɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wɨndɨñ eumbi, gwañgwañiilɨ Yesulɨ Yoane tuk ii-sem tɨ-kuñguk endok plon e-yout tɨmbi eñguk wɨn nandɨ-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu gɨt gwañgwañii tɨpet gɨt no endɨ amatam asuptɨ kɨmɨn tɨ-pakɨlɨñnan pɨ tombɨmbi, ama nolɨ Yesuloñ bɨmbi, kesiinan mɨlelem tɨ-ñɨmbi nɨñguk, ");
INSERT INTO nif_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Wopum, dɨk nɨñanala blan tɨñmɨñ. Gwañgwa ñalɨ kwapmeñgan gɨnañ kamalalak nain wɨn tɨkeumbi, kɨm katap tɨmbi, komba gɨnañ ba tuk gɨnañ pa pɨumbi, pɨñgɨu kola sɨnɨk talak. ");
INSERT INTO nif_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nak gwañgwañgailɨ tɨmbɨ kɨndem danelɨñdok nañgɨpi bɨñat, gan endɨ tɨ-tlap bium patak.” ");
INSERT INTO nif_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Wɨndɨñ eumbi, Yesulɨ tambane eñguk, “Amatam man ñɨndɨñgɨt kuañ sɨndɨ nanandɨ-kɨlɨktɨnjɨ nɨm pat-samumbi, kamakama tañ. Nak sɨn gɨta papata kunjit tɨlet! Nain nɨtek sɨnɨk sɨn gɨta gamañgot kuwambi, nandɨ-kɨlɨktɨ namnekalɨñ?” Wɨndɨñ embi, “Gwañgwa wɨn nokoñ nañgɨp bɨwɨt!” enguk. ");
INSERT INTO nif_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nañgɨp bɨumbi, Yesulɨ yal kolan gwañgwalok gɨnannan pakuk wɨn nɨ-ñombɨumbi poñañguk. Poñaumbi, wolongan gwañgwa walɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nɨsɨñgan palɨñɨpi, gwañgwañiilɨ Yesuloñ bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Kusei nɨtekta tɨmbi nɨndɨ yal kolan wɨn kle-kotneñdok tɨpɨkamɨñ?” ");
INSERT INTO nif_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Eumbi enguk, “Nanandɨ-kɨlɨktɨnjɨ lakat sɨnɨk walɨ tuop nɨm. Nak biañgan sɨnɨk sanba: nanandɨ-kɨlɨktɨnjɨ wambɨñ mɨnjɨp tip mɨnam wandin pat-samekta, kundit gɨtɨk tɨnep nandañ wɨn kɨndem eumbi indauk, wɨn kwet jañgɨn ñala bo kɨndem nɨnelɨñ, ‘Dɨk mɨlapi da wolok ñau!’ nɨmbɨmbi, wolok tuop tɨmbek.” ");
INSERT INTO nif_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesulok gwañgwañii gɨtɨk endɨ Galili distrik kɨmɨn tɨ-palɨmbi, ñɨndɨñ enguk, “Nain nɨm ombataumbi, Amalok Nɨñañ kanjɨkñiilok kɨsɨnan kɨmɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","wɨlɨ kɨmbɨmbi, sandap tɨpet gɨt no ñaumbi, Anutulɨ kɨmnan nanin tɨmbɨ mɨlalekak.” Wɨndɨñ eu nandɨmbi, gɨnañjɨ mɨlata sɨnɨk tañguk. ");
INSERT INTO nif_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tɨmbi Yesu gɨta gwañgwañii endɨ Kapaneam it kwelan ña tomgɨlɨñ. Tombɨmbi, ama mɨnem tapma it tɨ-dɨndɨm eelok epmañgɨlɨñ endɨ Petloloñ bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Endautsɨ endɨ tapma ittok takis mɨnem pa kɨmɨtak ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Eumbi nɨñguk, “Ba! Kɨmɨtak ñak.” Wɨndɨñ embi, it gɨnañ loñguk. Lombi, manda gama nɨm eñɨlɨmbi, Yesulɨ nɨ-nandɨmbi eñguk, “Simon, dɨk nɨtek nandɨlañ? Kwelalok ama wapmañdɨ kena kusei kuseilok mɨnem pa mekañ wɨn denanin? Wɨn nɨñañjiiloñ nanin mekañ ba ama dɨwɨsɨloñ?” ");
INSERT INTO nif_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Eumbi, Petlolɨ eñguk, “Ama dɨwɨsɨloñ.” Eumbi nɨñguk, “Wɨndɨñda nɨñañjiilɨ slak papi, takis mɨnem nɨm pa kɨmɨkañ. ");
INSERT INTO nif_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gan nɨm kañbi, gɨnañjɨ tɨnda kolaumbi, gimbɨt tɨ-nɨmnelɨñ. Wɨndɨñda dɨk ñambi, tuk guañnan pis tiatia toa no kolɨm pɨwɨn. Tɨmbi pis dama tiañeutañ endok man tambɨpi, mɨnem kwandai no man gɨnañ paletak kautañ wɨn tɨke bɨmbi, enda emekañ. Mɨnem walɨ nɨtettok takislok tuop tɨmbetak.” ");
INSERT INTO nif_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nain wolonda gwañgwalɨ Yesuloñ bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Kunum Molomdok gɨñgɨt boñgɨpnɨnan nindɨ loloñ sɨnɨk yañ?” ");
INSERT INTO nif_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eumbi, Yesulɨ gwañgwa tip no kɨtɨñmum bɨumbi, boñgɨpsɨnan kɨmɨpi ");
INSERT INTO nif_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","enguk, “Nak biañgan sɨnɨk sanba: tɨkap sɨndɨ gɨnañ nanandɨnjɨ nɨm tambanembi, gwañgwa bɨsat nomɨk nɨm indanelɨñda, sɨndɨ Kunum Molomdok gɨñgɨtñii nɨm indanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","No en kayombɨnembi, gwañgwa tip ñandin indalakta, en wakan Kunum Molomdok gɨñgɨtñiilok boñgɨpsɨnan loloñ sɨnɨk patak yañ. ");
INSERT INTO nif_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","No en naka nandɨmbi, gwañgwa ñandin nola not tɨñmɨlakta endɨ wakan naka not tɨ-namlak. ");
INSERT INTO nif_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gan no en gwañgwa koi nɨmnat ñandin ñalɨ nandɨ-kɨlɨktɨ tɨ-namlak wandin no nɨ-tiañeumbi, yom plon pipɨlakta ama walɨ blangandok. Neta, Anutulɨ mɨlap wopumgan mɨukakta tɨmbi. Endɨ kundit wandin gama nɨm tɨñɨlɨmbi, kawat wopum no bim plon topmbi, tɨke kolɨm tuk kimbɨñ gɨnañ pɨumda walɨ mɨlap lakat indañmek. ");
INSERT INTO nif_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kwelalok amatam endɨ blasɨñgandok. Neta, nain tuop nepek kusei kuseilɨ yom plon ep tiañenepi inda-semañ. Gan nepek wandin wɨn nindɨ tɨmbɨ inda-semlak en Anutulɨ mek tɨ-lamɨlekak. ");
INSERT INTO nif_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Wɨndɨñda dɨk kɨka ba kesɨka tombonlɨ yomdok sɨsoñ plon gapɨlɨm pipɨlañda, kak dombɨ kolɨm ñaumbi, kɨka ba kesɨka tombongot kumbi, kuñgu taletalen nɨmnatnan loukañ. Nɨm kañbi, kɨka ba kesɨka tɨpelatkan kukapi, komba nɨm pa kɨmlaknan wandɨñ gep kolɨm pɨuñ a. ");
INSERT INTO nif_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ba dɨk dauka tombonlɨ yomdok sɨsoñ plon gapɨlɨm pipɨlañda, dauka wɨn gɨtnei kolɨ ñaumbi, dauka tombongot kumbi, kuñgu taletalen nɨmnatnan loukañ. Nɨm kañbi, dauka tɨpelatkan kukapi, jɨmbɨñdok komba galk gɨnañ gep kolɨm pɨuñ a. ");
INSERT INTO nif_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Sɨndɨ kuñgunjɨ ka-kɨliñ enekalɨñ. Nɨm kañbi, gwañgwa kosɨ nɨmnat wandin endoññan nanin nola nandum tlal tɨmbɨmbi, en tɨmbɨ kolanelɨñ. Neta, nak ñɨndɨñ sanba: añelo gwañgwa wandin yambɨ-dɨkñeañ endɨ kunum gɨnañ kumbi, enda tɨmbi kwapmeñgan Bepna kunum gɨnañ patak endoññan kɨndem ña indañ. ");
INSERT INTO nif_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Sɨndɨ nɨtek nandañ? Tɨkap ama nolok sipsip 100 palmek, tɨmbi noñgan no pailɨm kak biwɨk ba? Nɨm a. Endɨ 99 yambium kwet jañgɨnnan palɨmbi, ña noñgan no pait-patak wɨn lonjɨwɨk. ");
INSERT INTO nif_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nak biañgan sanba: endɨ sipsip 99 enda sɨlɨsɨlɨ tɨlak, gan noñgan pailɨm tɨmbɨ indalak enda sɨlɨsɨlɨ wopum sɨnɨk tɨlak. ");
INSERT INTO nif_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Wɨndɨñgangot Bepsɨ kunum gɨnañ patak endɨ gwañgwa koi nɨmnat wandin endoñ nanin no nɨm pailektok nandɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yesulɨ yousɨmbi enguk, “Nokok sambatnai sɨndoñ nanin nolɨ yom tɨ-gamumbi, dɨk ñam sɨtekan papi, kusei daulmekañ. Tɨmbi endɨ mandañga nandɨm tɨke-kɨliñ elakta, endɨ bɨndambo not tɨ-gambi, dɨkok sambat indaukak. ");
INSERT INTO nif_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ba endɨ mandañga wɨlekta, ama noñgan ba tɨpet yanañgɨlɨmbi endoñ ñanekalɨñ. Tɨmbi nokailɨ manda gɨtɨk ama wolok plon kɨt yout tɨlañ wɨn e-gembɨlanekalɨñ, endɨkñe mandalɨ molo manda elak wolok tuop. ");
INSERT INTO nif_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ba endɨ mandanjɨ wɨt kak kolekta, ama wɨn kɨkesɨmɨndok kɨsɨnan kɨmɨlekañ. Kɨkesmɨndok manda wɨndɨñgangot wɨt kak kolekta, enda nandɨñmɨumbi, endɨ takis epep ama ba ama Anutu nɨm nandɨ-kɨlɨktɨ tɨñmañ endok tuop tɨmbekak. ");
INSERT INTO nif_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nak biañgan sanba: sɨndɨ nepek nola kwelan e-wiat tɨ-semumbi, Kunum Molomdok dainan wɨndɨñgot wiawiat indaukak, tɨmbi sɨndɨ nepek nola e-wiat nɨm tɨ-semumbi, Kunum Molomdok dainan wɨndɨñgot gama pat-semekak. ");
INSERT INTO nif_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","Tɨmbi nak yousɨmbi ñɨndɨñ sanba: ama tɨpet ba tɨpet gɨt no endɨ nokok kotna plon kɨmɨn tañda, nak en gɨta patet, wala tɨmbi sɨndoñ nanin ama tɨpet endɨ kwelan ñolok gɨnañjet kiulɨm noñgan tɨmbɨm, nepek nola ba nola nɨmolo tɨmbɨmbi, Bepna kunum gɨnañ patak endɨ nandɨ-semekak.” ");
INSERT INTO nif_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tɨmbi Petlolɨ Yesuloñ bɨmbi nɨkañbi eñguk, “Wopum. Notna nolɨ yom pa tɨ-namumbi, nain nɨtek yomɨn biñmetat? Nain 7got biñmet walɨ tuop ba?” ");
INSERT INTO nif_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Eumbi nɨñguk, “Nain 7got nɨm a. Dɨk 70 im 7 biñmɨ-ta-ñaukañ, wɨn yom bimbi tɨñɨpi nɨm kunakunattok elet. ");
INSERT INTO nif_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Kusei ñɨndɨñda tɨmbi wɨndɨñ elet: ama wapmañ nolɨ nepek tɨñguk wɨndɨñgangot Kunum Molomdɨ gɨñgɨtñii yambɨ-dɨkñelak. Ama wapmañ walɨ kena amañiilɨ nepek slak epgɨlɨñ wolok kɨnjan ombɨñmɨnelɨñdok en-tiañeñguk. ");
INSERT INTO nif_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","En-tiañembi, kena kusei kɨmɨlɨmbi, ama no nañgɨp bɨñgɨlɨñ endoñan kɨnjan ombɨñmektok palmɨñguk wɨn mɨnem 45 milion. ");
INSERT INTO nif_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Endɨ mɨnem wɨn ombɨñmektok tuop nɨm, wala tɨmbi ama wapmañdɨ mɨnem dɨwɨn epmektok nandɨñɨpi, kena gwañgwañii ñɨndɨñ tɨnelɨñdok enguk: endɨ ama en wakɨt tam gwañgwañii ba nepenepek gɨtɨk palmɨlak wɨn epbi, tualok kɨmɨtnelɨñdok enguk. ");
INSERT INTO nif_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Wɨndɨñ eumbi, kena ama walɨ ama wapmañdok kesɨnan mɨlelem tɨmbi, ñɨndɨñ nɨ-blambla eñguk, ‘Ama wapmañna, blan tɨ-nambi, naingot namumbi, nak kɨnjan tuopkan ombɨ-gam-taleutat.’ ");
INSERT INTO nif_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tɨmbi ama wapmañdɨ ama wala blan tɨ-ñɨmbi, kɨnjan wopum palmɨñguk wɨn gɨtɨk biñmɨmbi, kak slak bium ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","It gɨnañ nanin pɨ ñañɨpi, kena gwañgwa nol no tɨmbɨ indañguk, endoñan kɨnjan ombɨñmektok palmɨñguk wɨn mɨnem 100. En wakan tɨmbɨ indambi, bim plon tɨke kandipi nɨñguk, ‘Dɨk mɨnem slak tɨkeñguñ wɨn ñɨndɨñgɨtañgan ombɨ-namɨñ!’ ");
INSERT INTO nif_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tɨmbi nollɨ kesɨnan mɨlelem tɨ-ñɨmbi, ñɨndɨñ nɨ-blambla eñguk, ‘Dɨk nandɨ-nambi, nain namumbi, nak kɨnjan ombɨ-gametat.’ ");
INSERT INTO nif_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Eumbi nandɨ-kɨmnembi, it kwambɨñ gɨnañ nañgɨp ña kɨmɨpi ñɨndɨñ nɨñguk, ‘Kɨnjan ombɨ-tale-namumek gep pɨsattok’. ");
INSERT INTO nif_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tɨmbi noliilɨ kundit wɨn ka-nandɨmbi, gɨnañjɨ biañgan mɨlataumbi ña ama wapmañ kasat tɨñmɨ-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tɨñmɨ-taleum nandɨmbi, kena ama wɨn bɨndambo nɨ-tiañembi ñɨndɨñ nɨñguk, ‘Ama kolan papait, dɨk nan-blambla eumbi, nak blan tɨ-gambi, kɨnjanna wopum wɨn kak bi-gamɨt. ");
INSERT INTO nif_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nɨtek tɨmbi, nak bi-gamɨt, gan dɨk wɨndɨñgangot nokala blan nɨm tɨmbi biñmɨñañ?’ ");
INSERT INTO nif_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wɨndɨñ embi, gɨnañ komba dɨumbi, mik amaloñ nañgɨp ñambi enguk, ‘Sɨndɨ nain tuop kena gɨm mɨumbi, endɨ kɨnjanna wopum wɨn ombɨ-nam-taleumek, wolonda sɨndɨ kañbiumbi pɨukak.’” ");
INSERT INTO nif_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesulɨ e-yout manda wɨndɨñ en-talembi eñguk, “Sɨndɨ noñgan noñganlɨ gɨnañjɨ gɨtɨktɨ nosiilok yomjɨ nɨm bi-sem-talenelɨñda, Bepna kunum gɨnañ patak endɨ wɨndɨñgangot noñgan noñgan sɨndok yomjɨ nɨm bi-sameka k.” ");
INSERT INTO nif_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesulɨ manda wɨndɨñ e-talembi, Galili distrik bimbi, Juda amatamdok kwelan Jodan tuk dat kandañ patak wandɨñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tɨmbi amatam asupgandɨ en kle ñaumbi, jɨmbatsɨat ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tɨmbi Falisi ama dɨwɨndɨ Yesuloñ bɨmbi, tɨ-kuyuk tɨñmɨnepi nɨ-nandɨmbi eñgɨlɨñ, “Dɨk nɨtek nandɨlañ? Damañgan Moselɨ endɨkñe manda kɨmɨt-nɨmguk wolok tuop ama nolɨ enlok nanandɨnla nepek kusei wala ba wala tamɨn kle-kolek ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Eumbi tambane enguk, “Manda youyoulɨn ñɨn patak wɨn sɨndɨ pinat nandɨmbi kamalañ bek. Nain kusei kɨmɨkɨmɨlɨnan Anutulɨ ama ep tɨmbɨ indañguk wolonda endɨ ama gɨt tamɨn ep tɨmbɨ indañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tɨmbi ñɨndɨñ eñguk, ‘Kusei wɨndɨñda amalɨ meñ beu yambimbi, tamɨnnat galɨ-kwambɨñ daumbi, pɨñgɨpset noñgan indayamɨk.’ ");
INSERT INTO nif_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wɨndɨñda nak ñɨndɨñ sanlet: endɨ pɨñgɨp noñgan indambi, nombo tɨpet nɨm tamɨk. Wala tɨmbi wapatam Anutulɨ ep kiukuk wɨn amalɨ nɨm tambɨktok.” ");
INSERT INTO nif_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tɨmbi Falisi amalɨ ñɨndɨñ nɨñgɨlɨñ, “Tɨkap wɨndɨñda, nɨtek tɨmbi Moselɨ endɨkñe manda ñɨndɨñ kɨmɨkuk: ama no tamɨn kle-kolektok nandɨlakta, endɨ manda no wolok tuop youp mɨmbi kleum ñaukak?” ");
INSERT INTO nif_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Eumbi enguk, “Sɨn bamba bep pañjiilok gɨnañ kwambɨndanjɨla tɨmbi Moselɨ nandɨ-sambi, tam kɨndem ep klenelɨñdok eñguk. Gan nain kusai kɨmɨkɨmɨlɨnan wɨn wɨndɨñ nɨm pakuk. ");
INSERT INTO nif_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wɨndɨñda tɨmbi nak ñɨndɨñ sanba: ama no tamɨn telak joñgo nɨm kuñguk wɨn kleum ñaumbi, komblin tɨlak endɨ telak joñgo kulak.” ");
INSERT INTO nif_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tɨmbi gwañgwañiilɨ tam kle-kokottok plon Yesu ñɨndɨñ nɨmbi eñgɨlɨñ, “Tɨkap wɨndɨñda, amalɨ tam nɨm tɨmbi slak palekta wɨn kɨndem.” ");
INSERT INTO nif_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Eumbi enguk, “Ama Anutulɨ ep tɨmbɨ pañgɨtalak endɨñgot manda wɨn guma tɨkeañ, ama gɨtɨkkandɨ nɨm. ");
INSERT INTO nif_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nandañ. Kusei ñɨndɨñda ama dɨwɨsɨlɨ tam nɨm epmañ: wɨn dɨwɨn nolok pɨñgɨpsɨ kolan indañgɨlɨñda tɨmbi slak pakañ. Tɨmbi dɨwɨn nolok pɨñgɨpsɨ komblin inda-satalok gembɨn wɨn ama nɨsɨ dombu kokɨlɨñ, wala tɨmbi tam nɨm tɨkem slak kuañ. Tɨmbi ama dɨwɨn nolɨ Kunum Molomdok kenan tɨnelɨñdok tam nɨm tɨmbi slak pakañ. No en manda ñɨn nandɨ-daklelakta endɨ tɨkeukak.” ");
INSERT INTO nif_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tɨmbi amatamdɨ gwañgwa bɨsat Yesulɨ kii endok plon kɨmɨpi nɨmolo tɨ-semektok endoñ yanañgɨp bɨñgɨlɨñ. Bɨumbi, gwañgwañiilɨ enombɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","gan Yesulɨ ñɨndɨñ enguk, “Kunum Molomdɨ ama ñandisɨ enlok gɨñgɨtñii yambɨ-dɨkñelak, wala tɨmbi gwañgwa bɨsat yambiumbi nokoñ bɨwɨt, telak masip nɨm tɨ-semnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Wɨndɨñ embi, kii gwañgwa bɨsattok plon kɨmɨpi, gwɨlam tɨ-sem-talembi, walinin pɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tɨmbi ama nolɨ Yesuloñ bɨmbi nɨñguk, “Endaut, nak kuñgu taletalen nɨmnat kasɨleuttok ep tɨndɨn kɨndem nek tɨmbettok nandɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Eumbi nɨñguk, “Kusei nekta dɨk nokoñ bɨmbi, nepek nek ñalɨ kɨndem sɨnɨk wala nan-kalañ? Anutu en noñgangot endɨ kɨndem, wala tɨmbi dɨk en gɨta nain taletalen nɨmnat kuuñdok nandɨlañda, endɨkñe mandan tañgonembi kleukañ.” ");
INSERT INTO nif_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Eumbi, ama walɨ Yesu ñɨndɨñ nɨ-nandɨñguk, “Dɨk endɨkñe manda dek ñala sɨnɨk elañ?” Eumbi nɨñguk, “Endɨkñe manda ñala elet: dɨk ama nɨm wɨlɨ kɨmbekak, telak joñgo nɨm kuukañ, kumbu nɨm tɨmbekañ, ama no manda plon patak endok siñgin joñgo nɨm siukañ, ");
INSERT INTO nif_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","meñga beka giñgiñgan tɨ-semekañ, tɨmbi dɨtnala nandɨlañ wɨndɨñgangot nokaila nandukañ.” ");
INSERT INTO nif_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Eumbi, ama sim endɨ nɨñguk, “Endɨkñe manda gɨtɨk wɨn nak ikan tañgonembi kle-talelet. Gan nepek nek wala sɨnɨk gamañ tɨpɨkalet?” ");
INSERT INTO nif_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Eumbi nɨñguk, “Tɨkap dɨk Anutulok nanandɨn gɨtɨk kle-taleup nandɨlañda, dɨk ña nepenepeka gɨtɨk tuatualok kɨmɨlɨm tua-taleumbi, mɨnem wɨn epmbi, ama pɨmbɨñesɨla em-taleumbi, tuañga kunum gɨnañ inda-gamekak. Wɨndɨñ tɨ-talembi, bɨ nep kle kuukañ.” ");
INSERT INTO nif_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ama simdɨ manda wɨn nandɨmbi, nepenepek asup palmɨñgukta tɨmbi gɨnañ kolaumbi gwɨlɨlambi bim ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tɨmbi Yesulɨ gwañgwañiila enguk, “Nak biañgan sɨnɨk sanba: ama mɨnem kwɨlɨkwɨlɨnat nolɨ Kunum Molomdok gɨñgɨt indauktok nandɨlakta endɨ gliñgliñnat. ");
INSERT INTO nif_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nak bɨndambo ñɨndɨñ sanba: kamel nolɨ lɨk bemdok gɨnañ gik wolok ña tombep nandɨwɨkta endɨ kena kwambɨñ tɨmbek. Tɨmbi ama kwɨlɨkwɨlɨnat no Anutulok gɨñgɨt indaup nandɨlakta endɨ wɨndɨñgangot kena kwambɨñ tɨmbekak, gan endok kenan wɨn kamellok kenan maklelak.” ");
INSERT INTO nif_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Gwañgwañiilɨ manda wɨn nandɨmbi, kolan sɨnɨk sɨlɨkñembi eñgɨlɨñ, “Tɨkap wɨndɨñda, nindɨ Anutulok gɨñgɨt tuop indauk?” ");
INSERT INTO nif_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Wɨndɨñ eumbi, Yesulɨ dɨndɨmgan yambɨmbi enguk, “Amalɨ wɨndɨñ tɨndɨlok tuop nɨm, gan Anutulɨ nepek gɨtɨk wɨn tuop tɨ-taleuk.” ");
INSERT INTO nif_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tɨmbi Petlolɨ tambanembi nɨñguk, “Kalañ. Nɨndɨ nepenepeknɨ gɨtɨk bi-talembi bɨmbi, dɨk gep kle kuamɨñ, wala tɨmbi nɨndɨ tuan nek tɨkenekamɨñ?” ");
INSERT INTO nif_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Eumbi enguk, “Nak biañgan sɨnɨk sanba: Anutulɨ nepek gɨtɨk tɨmbɨ kaitaumek, Amalok Nɨñañ endɨ ama wapmañdok pipapipat plon pipapi, kusei kɨmɨpi, amatam gɨtɨk yambɨ-dɨkñeukak. Wolonda ama 12 nep kle kuañ sɨndɨ bo ama wapmañdok pipapipat plon pipapi, Islael ama sambat 12 yambɨ-dɨkñenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tɨmbi no en naka tɨmbi il ba dal kwayañii ba wiwii ba meñ beu ba gwañgwa bɨsalɨ ba nanañ kenan ba nepek wɨn gɨtɨk bi-taleñgukta, Anutulɨ wolok tambon nain asupgan yousɨñmɨ-ta-ñambi, kuñgu taletalen nɨmnat wakɨt mɨukak.” ");
INSERT INTO nif_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Yesulɨ yousɨmbi enguk, “Nain taletalenan ñɨndɨñ indaukak: ama asup nin endɨ man ñɨndɨñgɨt ama dɨwɨsɨlok dausɨnan damandama tañ endɨ siñgi sɨnɨk itnekalɨñ, tɨmbi siñgi sɨnɨk bañ endɨ d amandama itnekal ɨñ. ");
INSERT INTO nif_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nekta, Kunum Molom wɨn endɨ wain kena molom nolɨ kena gwañgwañii en-tiañembi yambɨ-dɨkñeñguk wandin. Kwet salaumbi, kena molom walɨ kɨmɨn kwelan ñambi, kena gwañgwa dɨwɨn epmepi, ");
INSERT INTO nif_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","kena nain noñgan wolok tuan en-indaumbi nandum tuop tɨmbɨmbi, kena gɨnañ en-mulɨm ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tɨmbi kwet ip sala-sɨnɨk taumbi, ama walɨ nombo ñambi, ama dɨwɨn kenala nɨm ñañañ kɨmɨn kwelan slak palɨmbi yambɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ñɨndɨñ enguk, ‘Sɨndɨ bo ña wain kenana tɨmbɨmbi, kena tɨnetañ wolok tuan sametet.’ Wɨndɨñ eumbi, wain kena tɨndɨla ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tɨmbi maim boñgɨp palɨmbi, kena molomdɨ bɨndambo ña ama dɨwɨn kena tɨñmɨnelɨñdok en-mukuk. Tɨmbi maimdɨ gama nɨm pɨ-sembɨñɨlɨmbi endɨ wɨndɨñgangot tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tɨmbi kwet kɨlɨmekɨlɨmelok tɨmbɨmbi, bɨndambo ñambi, ama dɨwɨn kena nɨm tɨndɨn slak pakɨlɨñ ep tɨmbi indaumbi enguk, ‘Sɨndɨ nekta sandap ombap kena nɨm tɨmbi slak palɨmbi, timlala tɨlak?’ ");
INSERT INTO nif_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Eumbi nɨñgɨlɨñ, ‘Nimbek nolɨ kena no nɨm nɨmɨk.’ Eumbi en-mupi enguk, ‘Ale, sɨndɨ bo ñambi, wain kenana gɨnañ kena tɨmbɨt.’ ");
INSERT INTO nif_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kwet kɨlɨm eumbi, wain kena molomdɨ kena ka-dɨkñe amala nɨmbi eñguk, ‘Dɨk kena gwañgwa kɨtɨ-semum bɨumbi, tuanjɨ emɨñ. Emepi, siñgi bɨlɨñ endoñan kusei kɨmɨpi em ta-ña, dama bɨlɨñ enda siñgi emu talewɨn.’ ");
INSERT INTO nif_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tɨmbi kena ka-dɨkñelɨ ama kwet bipmem tɨmbɨmbi, kena kusei kɨmɨkɨlɨñ enbɨm bɨumbi, kena nain noñgandok tuan em-taleñguk. ");
INSERT INTO nif_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Emumbi, dama bɨñgɨlɨñ endɨ ‘Tuan tɨke lo nɨmetak bek’ em nandɨñgɨlɨñ, gan ka-dɨkñelɨ ama noñgan noñgan enda bo kena nain noñgandok tuan emguk. ");
INSERT INTO nif_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tuanjɨ tɨkeñɨpi, kusei kɨmɨpi, kena molomda em balep tɨ-ñɨmbi ");
INSERT INTO nif_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","eñgɨlɨñ, ‘Siñgi bɨlɨñ endɨ kena nain dumangot tɨlɨñ, gan nɨndɨ sandap ombap maim kwambɨñ gɨnañ kena pɨñgɨp gawalat tɨ-patnambi kɨlɨm elak. Nekta sɨnɨk siñgi bɨlɨñ en gɨta tuan walan noñgangot nɨmlañ?’ ");
INSERT INTO nif_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wɨndɨñ eumbi, kena molomdɨ endoññan nanin nola ñɨndɨñ nɨñguk, ‘Notna, nak kolan nɨm tɨ-gamlet. Dɨk kena nain noñgandok tuanla gan-nandɨwambi, nandum tuop tɨk wɨn. ");
INSERT INTO nif_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wala tɨmbi mɨnemga tɨkembi ñau. Nak mɨnem gamɨt, wɨndɨñgan siñgi bɨlɨñ emepi nandɨt. ");
INSERT INTO nif_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nak natnalok mɨnem wɨndɨñ ba wɨndɨñ tɨmbep nandɨmbi, kɨndem tɨmbet. Nak gɨnañ sɨloñ tɨ-semlet, wala dɨk nɨsɨlok tañgan yambɨ-gimbɨt tɨlañ ba?’” ");
INSERT INTO nif_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesulɨ e-yout manda wɨndɨñ embi enguk, “Wɨndɨñda ama man ñɨndɨñgɨt siñgi sɨnɨk bañ endɨ damandaman itnekalɨñ, tɨmbi damandaman bañ endɨ siñgi sɨnɨk itnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tɨmbi Yesulɨ Jelusalem lo ñaupi, gwañgwañii 12 kɨtɨ-semum bɨumbi, nɨsɨñgan telak telak ñañɨpi enguk, ");
INSERT INTO nif_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nandañ! Nɨndɨ lokap, Jelusalem tomnambi, Amalok Nɨñañ tɨkembi, tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama endok kɨsɨ plon kɨmɨlɨm loukak. Tɨmbi endɨ manda plon kɨmɨpi, wɨlɨ kɨmbektok manda embi, ");
INSERT INTO nif_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Roma amalok kɨsɨ plon kɨmɨlɨmbi, endɨ Amalok Nɨñañ endok plon nɨ-sasale manda embi waipmbi, tɨkem kloñbat plon wɨlɨm kɨmbekak. Tɨmbi maim tɨpet gɨt no tɨmbɨmbi, Anutulɨ en kɨmnan nanin tɨmbɨ mɨlalekak.” ");
INSERT INTO nif_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tɨmbi Yesulɨ kɨmbektok en-taleumbi, Sebedilok tamɨn endɨ nɨñañiit tɨpet, wɨn Yakobo gɨt Yoane, en gɨta Yesuloñ bɨmbi, mɨlelem tɨ-ñɨmbi, nepek no nandɨñmektok nɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tɨmbi Yesulɨ nɨ-nandɨmbi eñguk, “Dɨk nekta nandɨlañ?” Eumbi nɨñguk, “Dɨk ama wapmañ indambi, amatam yambɨ-dɨkñeukañ nain wolonda nandɨ-nambi, nɨñanait tɨpet ñalɨ bo ama wapmañ indambi, kɨka dɨndɨm ba kepmanan pipatemɨktok nandɨlet.” ");
INSERT INTO nif_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eumbi, Yesulɨ nɨñañiit ñɨndɨñ enguk, “Sɨtɨ nɨtekta eamɨk wɨn nɨm nandɨ-dakleamɨk. Nak mɨlap bemetat wɨn sɨtɨ tuop bemdekamɨk ba?” Eumbi nɨñgɨmɨk, “Nɨtɨ tuop.” ");
INSERT INTO nif_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Wɨndɨñ eumbi enguk, “Sɨtɨ biañgan nokok mɨlap bemdekamɨk, gan nindɨ kɨtna dɨndɨm ba kepma kandañ pilekak wɨn natna ewa taleuktok tuop nɨm. Pipapat wɨn Betnalɨ ama dek endɨ engan epmep nandɨlak enda tɨ-wɨlɨ dɨkñe tɨ-semguk.” ");
INSERT INTO nif_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tɨmbi gwañgwañii 10 endɨ manda wɨn nandɨñgɨlɨñda, dakwaya tɨpetta gɨnañjɨ komba dɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gan Yesulɨ gwañgwañii gɨtɨk kɨtɨ-semum bɨumbi enguk, “Sɨndɨ kwelalok yambɨ-dɨkñe ama endok ep tɨndɨnjɨ nandɨ-taleañ: amatamdok kuñgun ba kɨm wɨn ama wapmañjɨlok kiinan patak, tɨmbi ama loloñdɨ pɨmbɨñesɨla endɨkñe mandanjɨ kwambɨñ enbi, tañgonem klenelɨñdok gɨñgɨneañ. ");
INSERT INTO nif_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gan sɨndok boñgɨpsɨnan wɨndɨñ nɨm tɨlok. Nɨm sɨnɨk. Sɨndoññan nanin no en wopum kuuktok nandɨlakta, endɨ noliilok tɨplaplaenjɨ kuukak. ");
INSERT INTO nif_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tɨmbi no en sɨndok telak damanjɨ kuuktok nandɨlakta, endɨ kena gwañgwañjɨ sɨlanin kumbi, ");
INSERT INTO nif_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Amalok Nɨñañ tɨñguk wolok tuop tɨmbekak. Endɨ amatam asup ep tɨmbɨ platambi, endok kɨnjan kɨmbektok ama sɨnɨk indañguk, endɨ en tɨmbɨ platanelɨñdok nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesulɨ gwañgwañii gɨt Jeliko it kwet bim ñañɨlɨmbi, amatam kɨmɨn wopumdɨ en kle ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tɨmbi ama tɨpet dauset sisipmɨn endɨ telak pawan pi pakɨmɨk. Endɨ Yesulɨ yapma kleup tɨmbɨm nandɨmbi, wolongan kɨtɨmbi nɨñgɨmɨk, “Devittok Komblin, dɨk nɨta blan tɨ-nɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Endɨ wɨndɨñ kɨtɨumbi, amatam asuptɨ enombɨmbi, en-kɨmɨsip tɨñgɨlɨñ, gan endɨ wopumgan kɨtɨmbi nɨñgɨmɨk, “Wopum, dɨk Devittok Komblin, nɨta blan tɨ-nɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Eumbi, Yesulɨ wɨñga ipi kɨtɨ-sembi enguk, “Sɨtɨ nɨtek tɨ-samettok nandamɨk?” ");
INSERT INTO nif_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Eumbi nɨñgɨmɨk, “Wopum, nɨtɨ dɨk dautnet tɨmbɨ tom-nɨmeñdok nandamɨk.” ");
INSERT INTO nif_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tɨmbi Yesulɨ blan tɨ-sembi, dauset kiilɨ tɨke-kaumbi, wolongan dauset tombɨmbi, nepenepek kañbi, Yesu kle ñañgɨm ɨk. ");
INSERT INTO nif_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu gɨt gwañgwañii endɨ Jelusalem it kwet tɨmbɨ dumalaumbi, Oliv kwet jañgɨnnan lombi, Betfage it kwelan tomgɨlɨñ. Tomñɨlɨmbi, Yesulɨ gwañgwañiit tɨpet en-mupi ");
INSERT INTO nif_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","enguk, “Sɨtɨ it kwet da patak wolok ñandekamɨk! Ñam tombi, wolongan doñki nɨñaññat toalɨ ep top yambiyambin kandetamɨk. Kañbi pɨsap yanañgɨpi bɨwɨt! ");
INSERT INTO nif_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tɨkap nimbek nolɨ sambɨmbi san-kaumbi, ñɨndɨñ nɨndekamɨk, ‘Molomdɨ doñki kena emektok nandɨlak. Tɨmbi platik sɨnɨk yambiumbi yanañgɨlɨmbi bɨndetamɨk.’” ");
INSERT INTO nif_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yesulɨ doñkila eñguk wɨn endɨ plofet ama nolɨ damañgan kumbi manda eñguk walɨ bien inda-dakleuktok tɨñguk. Manda wɨn ñɨndɨñ, ");
INSERT INTO nif_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saiondok amatam ñɨndɨñ enbɨm nandɨwɨt: Ama wapmañjɨ endɨ sɨndɨ sepmektok bɨ-samlak. Endɨ kayombɨnembi, doñki plon pipatak, wɨn doñki sim wolok plon pipapi bɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tɨmbi gwañgwa tɨpet endɨ ñambi, Yesulɨ kena manda enguk wolok tuop tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","doñki me nɨñañ yanañgɨpi, Yesuloñ bɨñgɨmɨk. Bɨmbi, sauloñjet kiundepi, doñki plon kɨmɨlɨmbi, Yesulɨ wolok plon lo pipapi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tɨmbi amatam kɨmɨn wopum endoññan nanin asupgandɨ endok koi gɨñgɨt tɨke-lonelɨñdok sauloñjɨ telak plon samba eñɨlɨmbi, dɨwɨndɨ komba sak kiyat dombɨmbi mep bɨm, wɨndɨñgot telak plon ipane-ta-ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tɨmbi amatam Yesu siñgi dama tɨmbi kleñgɨlɨñ endɨ enda Mesia nɨmbi, ñɨndɨñ yousɨyousɨñgan kɨtɨmbi eñgɨlɨñ, “Ama wapmañ Devit endok Komblin bɨlak, koi tɨke-lowɨt! Molomdɨ ama ñɨn ama wapmañnɨ kuuktok nɨ-mukuk en wakan gwɨlam tɨñmen! Anutu kunum gɨnañ patak endok koi tɨke-lona!” ");
INSERT INTO nif_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesulɨ Jelusalem it kwelan ama wapmañ nomɨk lo tombɨmbi, wɨnasi gɨtɨktɨ wɨn ka sɨlɨkñembi, “Wɨn nin?” e-nandɨñgɨlɨñ. E-nandumbi, ");
INSERT INTO nif_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","amatam kɨmɨn wopumdɨ tambane e-ta-ñañgɨlɨñ, “Ñɨn plofet Yesu en Nasalet it kwet, Galili distrik nanin.” ");
INSERT INTO nif_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tɨmbi Yesulɨ tapma it sañ jimba gɨnañ lombi, kɨmɨlɨ tua tɨmbi, mɨnem kena tɨ-pakɨlɨñ lo yambɨmbi, nandum tuop nɨm tɨñguk. Wɨndɨñda endɨ ama tapma tɨndɨlok nepenepek kɨmɨlɨm tuañgɨlɨñ gɨtɨk ep klembi, ama mɨnem tambo mɨñ kena tɨñgɨlɨñ endok kɨmɨkɨmɨtsɨ wakɨt monɨk tuatualok kɨmɨkɨlɨñ endok pipapatsɨ wɨlɨ tombolɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ñɨndɨñ enguk, “Anutulok manda no ñɨndɨñ youyoulɨn patak, ‘Nokok itna wɨn nan-wowoñ tɨndɨlok it een’. Gan kɨmɨlɨ tua ama sɨndɨ it ñɨn tɨmbɨm kumbu amalok pat-sembɨ it nomɨk tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yesulɨ tapma it sañ jimba gɨnañnan palɨñɨlɨmbi, ama kesɨt nɨm kuñgɨlɨñ gɨt ama dausɨ sipmɨsipmɨn endɨ endoñ bɨumbi, ep tɨmbɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tɨmbi wembe gwañgwa wandɨñ pakɨlɨñ endɨ ñɨndɨñ kɨtɨñgɨlɨñ, “Ama wapmañ Devittok Komblin endok koi tɨke-lowɨt!” Tapma ama biesɨ gɨt endɨkñe nandɨ-tale ama endɨ manda wɨn nandɨmbi, Yesu kundit kɨndem engano asup tɨñguk wɨn kañbi, gɨnañjɨ komba dɨumbi, ");
INSERT INTO nif_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ñɨndɨñ nɨ-nandɨñgɨlɨñ, “Endɨ Mesia ganañ wɨn dɨk nandɨlañ ba?” Eumbi tambane enguk, “Ba wɨn nandɨlet ñak. Gan sɨndɨla Ama Wapmañ Devittɨ Wopumla ñɨndɨñ nɨñguk wɨn pinapi nandɨ-kamalañ bek, ‘Dɨk wembe gwañgwa tip ba wopum ep tɨmbɨ pañgɨtaumbi, gan-tɨke-loumbi kɨndem dalak.’” ");
INSERT INTO nif_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wɨndɨñ embi, ama biesɨ yambimbi, Jelusalem nanin Betani it kwelan ñambi, wandɨñ douñguk. ");
INSERT INTO nif_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kwet salaumbi, Yesulɨ Jelusalem undane ñañɨpi, nanañ gawat tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tɨmbi deium ñaumbi, komba fik no telak pawan palɨmbi kañguk. Kañbi, ñasɨñgan kuseinan ña bienla deium loumbi, lonjɨ ka-tɨlapi, sakgot kañguk. Kañbi, komba fik nɨ-suambapi eñguk, “Dɨk bienga nombo nɨm laliukañ, nɨm sɨnɨk.” Eumbi, wolongan komba fik walɨ yañetambi kɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gwañgwañiilɨ wɨn ka sɨlɨkñembi eñgɨlɨñ, “Nɨtek tɨmbi, komba fik ñalɨ platik sɨnɨk kɨmbi yañetalak?” ");
INSERT INTO nif_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eumbi, Yesulɨ tambanembi enguk, “Nak biañgan sɨnɨk sanba: tɨkap sɨndɨ gɨnañ tɨpet nɨm tɨmbi, Anutu biañgan nandɨ-kɨlɨktɨ tɨñmɨ-kunelɨñda, nak kundit komba fik ñala tɨt wɨndɨñgangot sɨndɨ bo tɨnelɨñ. Tɨmbi wakangot nɨm ya. Tɨkap sɨndɨ kwet jañgɨn ñala ‘Mɨlapi, tuk kimbɨñ gɨnañ pɨ!’ nɨmbɨmbi, gumañ wolok tuop indawɨk. ");
INSERT INTO nif_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Sɨndɨ Anutula nepek no ba no tɨmbektok nɨmolo tɨ-ñɨmbi, nandɨ-samektok nandɨ-kɨlɨktɨ tañda, wɨndɨñ inda-samekak.” ");
INSERT INTO nif_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesulɨ tapma it sañ jimba gɨnañ lombi, amatam enɨ-daut tɨ-semguk. Enɨ-daut tɨ-sem-palɨñɨlɨmbi, tapma ama biesɨ gɨta Islael amalok ama biesɨ endɨ endoñ bɨmbi, nɨ-kañbi eñgɨlɨñ, “Nindɨ ganbɨmbi, kundit ñandin pa tɨlañ? Ba nindok mandanla ba gembɨnla wɨndɨñ pa tɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Eumbi tambane enguk, “Nak bo nepek nola san-nandutet. Dɨndɨm tambane nanɨnetañda, nak bo nindok mandala kundit wandin sɨnɨk pa tɨlet wɨn sanbetet. ");
INSERT INTO nif_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Nindɨ Yoane nɨmbɨmbi, amatam tuk i-semguk? Wɨn Kunum Molomdɨ ba ama nolɨ?” Wɨndɨñ eumbi, kusei kɨmɨpi, nɨsɨñgan dombɨ tañan tɨmbi eñgɨlɨñ, “Nɨndɨ ‘Kunum Molomdɨ’ wɨndɨñ eneñda, endɨ ñɨndɨñ nɨnɨ-nandutak, ‘Wɨndɨñda sɨndɨ nekta Yoanelok mandan nɨm nandɨ-dasiñgɨlɨñ?’ ");
INSERT INTO nif_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Gan nɨndɨ ‘Ama nolɨ Yoane nɨmbɨm kena tɨñguk’ wɨndɨñ eneñda, amatam kɨmɨn wopum Yoanela plofet nandɨñmañ endɨ nɨtek tɨ-nɨmnelɨñ walañgot mɨsɨnetamɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wɨndɨñda endɨ Yesu ñɨndɨñ tambane nɨñgɨlɨñ, “Nindɨ Yoane nɨmbɨmbi, tuk i-semguk wɨn nɨndɨ nɨm nandamɨñ.” Eumbi enguk, “Ale, wɨndɨñda nak bo nindɨ nanbɨmbi, kundit pa tɨlet wɨn nɨm sanbetet.” ");
INSERT INTO nif_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesulɨ yousɨmbi, Juda ama biesɨla enbi eñguk, “Sɨndɨ kasat ñala nɨtek nandañ? Ama nolok nɨñañiit tɨpet kuñgɨmɨk. Tɨmbi tualoñ ña ñɨndɨñ nɨñguk, ‘Tua, dɨk man ñambi, wain kena tɨ!’ ");
INSERT INTO nif_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Eumbi, jip jup tɨñguk, gan siñgimek endɨ gɨnañ tambaneumbi, ña kena tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tɨmbi besettɨ monaloñ ña wɨndɨñgangot nɨmbɨmbi, beula nɨñguk, ‘Ale, ñautet.’ Endɨ wɨndɨñ eñguk, gan nɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Sɨndɨ nɨtek nandañ, gwañgwa nindɨ beulok man tañgoneñguk?” Eumbi, endɨ eñgɨlɨñ, “Tualɨ.” Tɨmbi Yesulɨ enguk, “Nak biañgan sanba: takis epep ama ba tam telak joñgolok endɨ sɨndok kwesɨ kɨnjannan Anutu enlok gɨñgɨt indaumbi yambɨ-dɨkñelak. ");
INSERT INTO nif_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Kusei ñɨndɨñda tɨmbi wɨndɨñ indalak: Yoanelɨ bɨmbi, dɨndɨm kuñgulok telak daut samumbi, sɨndɨla mandan nandum tlal tɨñguk, gan takis epep ama gɨt tam telak joñgolok endɨla mandan wɨn nandɨmbi tɨke-kɨliñ eñgɨlɨñ. Sɨndɨ nepek wɨn kañgɨlɨñ, gan gɨnañjɨ nɨm tambanembi, Yoanelok mandan nandɨmbi nɨm tɨke-kɨliñ eñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesulɨ yousɨmbi, tapma ama biesɨ ba Falisi amala enbi eñguk, “Nak e-yout manda no sanbambi nandɨwɨt. Kena molom nolɨ wain kap kwet nolok tɨpiñguk. Tɨpi-talembi, sañ im gɨmbunembi, wain tul wɨsɨ-dottok kwet no kɨndipi, kena ka-dɨkñelok it ombap kloñ no kawattɨ kɨndilɨm ikuk. Wɨndɨñ tɨ-talembi, kenan wɨn ka-dɨkñelok kɨsɨ plon kɨmɨpi, kwet mayañgan nolok ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ña kuñɨlɨmbi, bien mepmettok nain indaumbi, kena gwañgwañii dɨwɨndɨ wain bien enlok mepmettok ka-dɨkñeloñ en-mulɨm bɨmbi, wain kena gɨnañ tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tɨmbi ka-dɨkñe endɨ gwañgwa en-mumulɨn wɨn epmbi, no wɨpi, no wɨlɨ kɨmbɨmbi, no kawattɨ wɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wɨndɨñ tɨmbɨmbi, kena molomdɨ gwañgwa dɨwɨn nombo en-mukuk. Kunakunatsɨ wɨn gwañgwa dama en-mukuk yapma klembi, asup en-mulɨmbi bɨ tombɨmbi, kundit wɨndɨñgangot tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Siñgi sɨnɨk endɨ enlok nɨñañ sɨnɨk nɨ-mupi, ñɨndɨñ nandɨñguk, ‘Nɨñanalɨ ña tombɨmbi kañbi, giñgiñgan tɨñmɨnekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Tɨmbi ka-dɨkñelɨ nɨñañ wɨn kañbi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, ‘Gamanda endɨ wakan kena ñolok molom tɨmbekak, wala tɨmbi nɨndɨ en wɨpi, kenan ñɨn nɨnlok gɨñgɨt kasɨlena.’ ");
INSERT INTO nif_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wɨndɨñ embi tɨkeñɨpi, kena gɨnañ nanin munjut munjut ñakap, kena pawan wɨlɨ kɨmguk.” ");
INSERT INTO nif_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesulɨ wɨndɨñ embi en-nandɨmbi eñguk, “Wain kena molomdɨ undane bɨmek, ka-dɨkñe wɨn nɨtek tɨ-semekak?” ");
INSERT INTO nif_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eumbi nɨñgɨlɨñ, “Nepek kolan sɨnɨk tɨñgɨlɨñda tɨmbi endɨ bo kolan sɨnɨk yandɨpmum kɨm-talenekalɨñ. Tɨmbi endɨ kena ka-dɨkñe komblin kɨndem ep kasɨlembi, kenan endok kɨsɨnan kɨmɨlɨmbi, wain bien mepmettok nain indaumbi, nain tuop endɨ bien dɨwɨn enlok melɨm tɨ-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tɨmbi Yesulɨ enla manda embi enguk, “Anutulok manda youyoulɨn patak ñɨn sɨndɨ pinat nandɨmbi kamalañ bek, ‘Molom en ñɨndɨñ tɨmbɨ indañguk: it kɨndikɨndit amalɨ ita kawattɨ tɨndɨn nola kena nɨmnat embi siñgi wɨlɨmgɨlɨñ, gan kawat walɨ ta dɨwɨn gɨtɨk yapma klelak. Nɨndɨ wɨn kanambi, kundit gɨtikñin tɨlak.’ ");
INSERT INTO nif_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Manda wolok tuop it kɨndikɨndit amalɨ kawat wɨn siñgi wɨlɨmgɨlɨñ, wɨndɨñgan sɨndɨ nak siñgi wɨt-namgɨlɨñ, wala tɨmbi nak ñɨndɨñ sanba nandɨwɨt: Sɨndɨ Anutulok gɨñgɨtñii ku-ta-bañ, gan endɨ pipapipat wɨn sapma tɨkembi, amatam no nindɨ endok manda tañgonembi bien tɨmbɨ indañ enda emekak. ");
INSERT INTO nif_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ama nolɨ kawat wolok plon pi wɨlekta en wɨlɨ mɨnanda taleuk. Ba kawat walɨ ama nolok plon pɨwɨkta, kawat walɨ ama wɨn wɨlɨ gakñe-taleuk.” ");
INSERT INTO nif_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tapma ama biesɨ gɨt Falisi ama endɨ Yesulɨ e-yout manda eñguk wɨn nandɨmbi, “Nɨndañgan elak” wɨndɨñ nandɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","tɨkenepi nandɨñgɨlɨñ. Gan amatam kɨmɨn wopum endɨ Yesula plofet no wɨndɨñ nandɨñmɨñgɨlɨñ, wala tɨmbi Falisi amalɨ amatamdɨ mik tɨ-semnelɨñ wala mɨsɨmbi, nɨm tɨkeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesulɨ yousɨmbi, nombo ama biesɨla e-yout mandalɨ manda enɨñɨpi, ñɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kunum Molomdɨ gɨñgɨtñii yambɨ-dɨkñelak wɨn ñɨndɨñ: ama wapmañ nolok nɨñañlɨ tamɨn tɨkeup tɨmbɨmbi, wapmalɨ kena gwañgwañiilɨ nanañ sina wopum tɨñmɨnelɨñdok embi, ");
INSERT INTO nif_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","manda kɨmɨpi, yoktɨ nanañ wɨn nanelɨñdok en-tiañeñguk. Tɨmbi nanañ nanalok nain indaumbi, yokñiilɨ bɨnelɨñdok kena gwañgwañii en-mulɨmbi ñañgɨlɨñ. Gan yokñiilɨ bɨmbɨla kunjit tambi, nɨm embi gɨñgɨnem pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Tɨmbi ama wapmañdɨ bɨndambo kena gwañgwa dɨwɨn bo en-mupi, yokñii ep tiañeñguk enda ñɨndɨñ enɨnelɨñdok enguk, ‘Nandañ. Nak nanañna ip tɨ-wɨlɨ dɨkñet. Nokok bulmakau wapai sim ba nɨñañ dɨwɨn no gwok galkñat yandɨp si-talembi, nepek gɨtɨk tɨ-jumɨt tɨ-sam-talemɨñ. Sɨndɨ bɨumbi, nɨñanalɨ tam tɨmbetak en gɨta na sɨlɨsɨlɨ tɨna!’ ");
INSERT INTO nif_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","En-mulɨmbi, kena gwañgwañiilɨ ña manda eñguk wɨndɨñ engɨlɨñ, gan yokñiilɨ mandanjɨ nandɨ-kɨmnembi ñañgɨlɨñ. Dɨwɨndɨ nanañ kenanjɨnan ñañgɨlɨñ, dɨwɨndɨ mɨnem kenanjɨla ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tɨmbi dɨwɨndɨ ama wapmañdok kena gwañgwa wɨn epbi kolan tɨ-sembi yandɨp kɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wɨndɨñ tɨmbɨmbi, ama wapmañdɨ gɨnañ komba dɨumbi, mik amañii en-mulɨmbi ña ama kena gwañgwa yandɨpgɨlɨñ wɨn yandɨp talembi, isɨ kwesɨ wakɨt sium dɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tɨmbɨmbi ama wapmañdɨ kena gwañgwañii dɨwɨnda ñɨndɨñ enguk, ‘Yoknailok nanañ sina tɨ-sem-talet, gan ama nak en-tiañeñgut endɨ kɨndesɨ nɨm. ");
INSERT INTO nif_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wɨndɨñda sɨndɨ telak mannan ñambi, amatam yambɨnetañ tuop en-tiañeum bɨmbi, wapatamdok sina dum nanañ nambɨt.’ ");
INSERT INTO nif_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Eumbi, kena gwañgwañiilɨ enguk tuop telak man tuop ñambi, amatam kɨndesɨ ba kolasɨ yambɨñgɨlɨñ gɨtɨk ep kɨmɨn tɨmbi yanañgɨlɨmbi, nanañ nanala bɨmbi, it gɨnañ tokñeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Amatam it gɨnañnan lo pi palɨñɨlɨmbi, ama wapmañdɨ yambep loñguk. Lombi yambɨñɨpi kañguk wɨn: ama nolɨ dasindasin nain wolok dɨndɨm sɨnɨk yokñiila emgɨlɨñ wɨn nɨm dasimbi, bɨ pipalɨm kañbi ");
INSERT INTO nif_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","nɨ-nandɨñguk, ‘Notna, nɨtek tɨmbi dɨk dasindasin gamɨt wɨn nɨm dasimbi bɨñ?’ Eumbi, ama walɨ manda nɨmnat palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ama wapmañdɨ kena gwañgwañii enbi eñguk, ‘Sɨndɨ kii kesi toalɨ topbi, pawan kolɨ pɨmbi, kɨlɨm gɨnañ palen.’” Yesulɨ e-yout manda wandin embi yousɨmbi eñguk, “Kɨlɨm gɨnañ amalɨ mano kwɨlɨm tɨmbi, manjɨ sɨ-gɨlɨm danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nandañ. Kunum Molomdɨ amatam asup en-tiañelak, gan noñgan noñgan mandan nandɨmbi bañ endɨñgot ep kasɨlelak.” ");
INSERT INTO nif_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tɨmbi Falisi amalɨ Yesu manda plon kɨmɨtnelɨñdok nandɨmbi, ña kɨmɨn tɨmbi, mandalɨ sɨsoñ tɨñmɨnepi e-sambat tɨñgɨlɨñ. Tɨ-talembi, ");
INSERT INTO nif_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","nɨsɨlok gwañgwanjii dɨwɨn gɨt ama wapmañ Elot endok sambalii dɨwɨn en-mulɨmbi ñambi nɨñgɨlɨñ, “Endaut, nɨndɨ dɨkok kusaka nandamɨñ, dɨk juluñ manda nɨm embi, biañgangot pa elañ, Anutulɨ nɨndɨ nɨtek kuneñdok nandɨlak wɨn lolon ba pɨmbɨn gɨtɨk mɨsɨmɨsɨ nɨmnat tuopkan nɨnɨ-daut nɨm tɨ-nɨmlañ. ");
INSERT INTO nif_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Wala tɨmbi gan-nandɨnambi nɨnbekañ: Romalok ama wapmañ Sisa enda takis mɨnem mamɨñ wala nandum dɨndɨm elak ba nɨtek?” ");
INSERT INTO nif_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Wɨndɨñ eumbi, Yesulɨ kolan tɨñmɨnepi nandɨñgɨlɨñ wɨn ka-nandɨmbi enguk, “Sɨndɨ ama manjɨ manbenjɨ malet nomɨk, mandalɨ sɨsoñ tɨ-namnepi bañ ba? ");
INSERT INTO nif_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takis mɨnem pa kɨmɨkamɨñ mɨnem wɨn no daut namɨt” eumbi, mɨnem kwandai satnin no ña tɨke bɨ daulmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tɨmbi Yesulɨ en-nandɨmbi eñguk, “Mɨnem plon ama walan gɨt kot kundit wɨn nindoñ?” ");
INSERT INTO nif_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eumbi nɨñgɨlɨñ, “Wɨn Sisaloñ”. Wɨndɨñ eumbi enguk, “Ale, Sisalok gɨñgɨt wɨn Sisala tambane mɨnekalɨñ, tɨmbi Anutulok gɨñgɨt wɨn Anutula tambane mɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Wɨndɨñ eumbi, nandɨ piasat tɨmbi bimbi pɨ ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sandap wolondañgan Sadusi ama dɨwɨn endɨ Yesuloñ bɨñgɨlɨñ. (Ama walɨ ‘Ama sembañ endɨ nɨm mɨlamɨlattok’ wɨndɨñ pa eañ.) Endɨ Yesuloñ bɨmbi, ñɨndɨñ nɨ-nandɨmbi ");
INSERT INTO nif_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","eñgɨlɨñ, “Endaut. Endɨkñe manda Moselɨ kɨmɨt-nɨmguk walɨ ñɨndɨñ elak: ama nolɨ yamɨn pap sembɨlakta, endok sambat nɨm talenelɨñdok kwayañlɨ endok tamɨn kanjalɨ tɨkembi, dallok kɨnjan gwañgwa bɨsat ep tɨmbɨ indanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wɨndɨñda, dakwaya kɨt tambon tɨpet endɨ ñolok kuñgɨlɨñ. Tɨmbi tualɨ tam no tɨkembi kukap, komblin nɨmnat yamɨn papi sembɨñguk. Sembumbi, monalɨ tam wakangot tɨkeñguk. ");
INSERT INTO nif_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Tɨkembi, endɨ bo wɨndɨñgangot yamɨn papi sembɨñguk. Tɨmbi gwik endɨ bo wɨndɨñgangot tɨñguk. Tɨmbɨm ña gwik konjok endok plon taleñguk. ");
INSERT INTO nif_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Endɨ gɨtɨkkandɨ sembɨ-taleumbi, siñgi sɨnɨk tam walɨ bo sembɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ale, dɨk eumbi nandɨna: dakwaya endɨ gɨtɨktɨ tam wɨn tɨkeñgɨlɨñ, wala tɨmbi ama sembɨñgɨlɨñ endɨ mɨlamɨlat nainnan mɨlalɨmbi, ama kɨt tombon tɨpet endoñ nanin ama nindɨ sɨnɨk tam wɨn tɨkeukak?” ");
INSERT INTO nif_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eumbi tambane enguk, “Sɨndɨ Anutulok mandan youyoulɨn patak wolok kusei ba endok gembɨn nɨm nandɨ-dakleañ, wala tɨmbi mɨlamɨlatta nandumbi kamalalak. ");
INSERT INTO nif_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Amatamdɨ kɨmnan nanin mɨlatmek endɨ kunumdok añelo nomɨk wapatam nɨm pa tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Tɨmbi ama sembɨmbi mɨlatnekalɨñ wolok kandañ Anutulɨ manda ñɨndɨñ sanguk wɨn sɨndɨ pinat nandɨmbi kamalañ bek, ");
INSERT INTO nif_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Natna Anutu wakan Ablaam wakɨt Aisak ba Jekop endɨ nan-wowoñ tɨ-namañ.’ Endɨ bep pañnii kwelan nombo nɨm kuañ endok plon wɨndɨñ eñguk. Tɨmbi ama kaik kuañ endɨñgot Anutu nɨ-wowoñ tañ, ama sembɨsembɨn endɨ nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Amatamdɨ Yesulɨ nanandɨ emguk wɨn nandɨmbi, nandɨ-gɨtɨñgɨtɨk e tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Yesulɨ Sadusi amalok manjɨ masipmɨñgukta, Falisi amalɨ wɨn nandɨmbi, bɨ kɨmɨn tɨmbi, Yesuloñ bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Endoññan nanin no endɨ endɨkñe manda nandɨ-tale ama. Endɨ Yesu sɨsoñ tɨñmep nɨ-nandɨmbi eñguk, ");
INSERT INTO nif_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Endaut. Endɨkñe manda nek ñalɨ sɨnɨk dama tɨmbi, loloñ sɨnɨk tɨlak yañ?” ");
INSERT INTO nif_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Eumbi nɨñguk, “‘Sɨndɨ gɨnañjɨ wakɨt gɨnañjɨ tip ba nanandɨnjɨ gɨtɨk Wopum Anutunjɨ endok biñmɨnekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Endɨkñe manda walɨ dama sɨnɨk tɨmbi, loloñ sɨnɨk yañ. ");
INSERT INTO nif_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tɨmbi endɨkñe wandingangot no wɨn ñɨndɨñ, ‘Dɨk dɨtnala nandɨlañ, wɨndɨñgangot nokala nandɨñmekañ.’ ");
INSERT INTO nif_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moselɨ endɨkñe manda gɨtɨk kɨmɨt-nɨmguk ba plofet amalɨ nanandɨ nɨmgɨlɨñ wolok bien endɨkñe tɨpet walɨ nɨnɨ-dakleamɨk.” ");
INSERT INTO nif_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Falisi amalɨ kɨmɨn tɨ-palɨñɨlɨmbi, Yesulɨ ñɨndɨñ en-nandɨmbi ");
INSERT INTO nif_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","eñguk, “Mesia Anutulɨ amatamñii epeplok nɨmbɨ taleñguk wɨn sɨndɨ enda nɨtek nandañ? En nindok komblin?” Eumbi nɨñgɨlɨñ, “Endɨ ama wapmañ Devit endok komblin.” ");
INSERT INTO nif_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Eumbi enguk, “Wɨndɨñda kusei nɨtektok Dɨndɨm Woñdɨ Devittok gɨnan nanandɨn tɨmbɨ daklembi, enlok komblin wɨn ‘Wopumna’ kɨtɨmbi, ñɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wopum Anutulɨ Wopumnala ñɨndɨñ nɨñguk, Dɨk kɨtna dɨndɨm kandañ pipalɨmbi, nak kanjɨkkai dɨkok kapmainan yapɨlambi patnekalɨñ wolok tuop.’ ");
INSERT INTO nif_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Manda wolok tuop Devittɨ Mesiala ‘Wopumna’ kɨtɨñguk, wala tɨmbi Mesialɨ nɨtek Devittok komblingot tɨmbek?” ");
INSERT INTO nif_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Eumbi, ama biesɨ gɨtɨktɨ manda tambon no tambane nɨnelɨñdok tuop nɨm. Tɨmbi nain wolondañgan kusei kɨmɨpi, mandalɨ sɨsoñ tɨñmɨnepi ekaeka dɨwɨn tɨnep mɨsɨmbi kak biñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tɨmbi Yesulɨ gwañgwañii gɨta ama kɨmɨn wopum tɨ-pakɨlɨñ enda ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Falisi gɨt endɨkñe manda nandɨ-tale ama endɨ Moselok kɨnjan ipi, endɨkñe manda san-daut tɨ-samañ. ");
INSERT INTO nif_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Wala tɨmbi manda sanañ wɨn gɨtɨk tɨke-kunekalɨñ, gan ep tɨndɨnjɨ nɨtek tañ wɨn nɨm kɨmɨt-klembi tɨnekalɨñ. Nekta, endɨ endɨkñe manda san-daut tɨ-samañ, gan nɨsɨ manda wɨn nɨm tɨke-kuañda tɨmbi. ");
INSERT INTO nif_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Endɨkñe manda sɨnda san-daut tɨ-samañ wɨn nepek mɨlap wɨn sɨndɨñgot tañgonenelɨñdok samañ wandin. Gan nɨsɨ sep tɨmbɨ pañgɨtanelɨñdok kɨt kɨmɨt no tɨnepi nɨm nandañ. ");
INSERT INTO nif_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nepek tañ gɨtɨk wɨn endɨ amalɨ yambɨmbi e-kɨndem da tɨ-semnelɨñdokgot pa tañ. Sɨndɨ Falisi gɨt endɨkñe nandɨ-tale ama endok kama besañ ba dama immɨsɨ wɨn kañ ba? Wɨn wopum sɨnɨk! Tɨmbi kuñgunjɨ Anutu biñmañ wɨn inda-dakleuptok endɨ dasindasinjɨ kusip blemblemat ombaplɨ tɨndɨn wɨn pa dasiañ. ");
INSERT INTO nif_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tɨmbi sina wopum indalaknan ba it kiyau gɨnañ endɨ pipapat damandama pakañ wolokgot pipatnepi nandañ, ");
INSERT INTO nif_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","tɨmbi amatam kɨmɨn kwelan yambañ endɨ we sembi giñgiñgan tɨ-semnelɨñdok ba kosɨ eu loumbi, ‘endaut’ pa enɨnelɨñdok nandañ. ");
INSERT INTO nif_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nandɨwɨt: ama noñgan endɨñgot sɨndok sandautsɨ sɨnɨk, tɨmbi sɨndɨ gɨtɨk dakwayañgot, wala tɨmbi amatamdɨ sɨndok kosɨ eu lonelɨñdok ‘nɨnɨndaut’ wɨndɨñ nɨm sanɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wɨndɨñgangot sɨndɨ kwelan ñolok ama nola ‘Bepnɨ’ nɨm kɨtɨnekalɨñ. Bepsɨ noñgangot endɨ kunum gɨnañ patak. ");
INSERT INTO nif_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tɨmbi bo amatamdɨ sɨnda ‘telak damanɨ’ nɨm sanɨnekalɨñ. Nɨm. Sɨndok telak damanjɨ wɨn noñgan endɨñgot, wɨn Mesia Anutulɨ en sepmektok nɨ-mukuk en wakan. ");
INSERT INTO nif_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Sɨndok ama lolonjɨlɨ sɨndok kena gwañgwanjɨ kuukak. ");
INSERT INTO nif_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","No en enlok koi tɨke lolakta, Anutulɨ endok koi tɨke pɨukak. Tɨmbi no en kayombɨnembi kulakta, Anutulɨ endok koi tɨke loukak.” ");
INSERT INTO nif_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Yesulɨ yousɨmbi enguk, “Endɨkñe manda nandɨ-tale gɨta Falisi ama sɨndɨ kilañmet! Ama manjɨ manbenjɨ malet nomɨk sɨndɨ amatam kunumdok yama sip semañ, wɨn sɨnɨ Kunum Molomdok gɨñgɨt nɨm indañ, gan amatamdɨ endok gɨñgɨt indanep nandañ wɨn telak masip tɨ-semañ, wala tɨmbi Anutu en mek sambekak. ");
INSERT INTO nif_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Endɨkñe nandɨ-tale gɨta Falisi ama sɨndɨ kilañmet! Ama manjɨ manbenjɨ malet nomɨk sɨndɨ gwañgwañjɨ noñgangot tɨmbɨ indanelɨñdok kwet tuop ba tuk kimbɨñ dɨkñembi ku-taleañ. Sɨndɨ kolandok gɨñgɨt tañ, tɨmbi ama nolɨ gwañgwañjɨ indambi, nanandɨnjɨ gɨt ep tɨndɨnjɨ kɨmɨt-kle-talelak sɨndɨ en tɨmbɨm kolandok gɨñgɨt tɨñɨpi, sapma klembi, kola sɨnɨk talak. ");
INSERT INTO nif_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ama dautsɨ sisipmɨn nosiila telak daut semañ sɨndɨ kilañmet! Sɨndɨ ñɨndɨñ enɨ-daut tɨ-sembi tañ: tɨkap ama nolɨ ñɨndɨñ eup nandɨlak, ‘Nak Anutulok dainan wɨndɨñ ba wɨndɨñ tɨmbettok e-kwambɨñ da tɨlet’, gan endɨ Anutulok koi kɨtɨup mɨsɨmbi, tapma ittok plon e-gembɨlalakta, endɨ manda wɨn kɨndem lapɨlektok tuop. Gan tɨkap endɨ nepenepek gollɨ tɨndɨn tapma ilan pakañ wolok plon manda e-kwambɨñ dalakta, endɨ manda wɨn lapɨlektok tuop nɨm. Sɨndɨ wɨndɨñ pa enɨ-daut tɨ-semañ. ");
INSERT INTO nif_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Sɨndɨ ama dausɨ sisipmɨn gɨta kamasɨ! Anutulok dainan nek ñalɨ loloñ sɨnɨk? Wɨn nepek gollɨ tɨndɨn walɨ loloñ sɨnɨk, ba tapma it walɨ loloñ sɨnɨk? Nepek gollɨ tɨndɨn walɨ tapma ilnan nɨm palɨmda, walɨ loloñ nɨm tɨmbek yañ. ");
INSERT INTO nif_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tɨmbi bo ñɨndɨñ enɨ-daut tɨ-semañ, ‘Amalɨ sisuet plon manda e-kwambɨñ dalak, endɨ manda wɨn kɨndem lapɨlektok tuop. Gan tɨkap endɨ tapma no sisuettok plon kɨmɨlɨm patak wolok plon manda e-kwambɨñ dalakta, endɨ manda wɨn lapɨlektok tuop nɨm’. ");
INSERT INTO nif_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sɨndɨ dautsɨ sipmɨn. Anutulok dainan nek ñalɨ loloñ sɨnɨk? Wɨn tapma walɨ loloñ sɨnɨk, ba sisuet walɨ loloñ sɨnɨk? Tapma wɨn sisuettok plon nɨm kɨmɨlɨm palɨmda, walɨ loloñ nɨm tɨmbek yañ. ");
INSERT INTO nif_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wala tɨmbi no en sisuettok plon manda e-kwambɨñ dalakta, endɨ sisuet wakɨt nepek gɨtɨk wolok plon kɨmɨlɨm pakañ nepek wolok plon mandan e-kwambɨñ dalak. ");
INSERT INTO nif_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tɨmbi no en tapma ittok plon manda e-kwambɨñ dalakta, endɨ tapma it wakɨt Anutu en wolok kulak endok plon manda e-kwambɨñ dalak. ");
INSERT INTO nif_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Tɨmbi no en kunumdok plon manda e-kwambɨñ dalakta, endɨ kwet wolok Anutulɨ pipapi, kunum kwet yambɨ-dɨkñelak wakɨt Anutu enlok plon manda e-kwambɨñ dalak. ");
INSERT INTO nif_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Endɨkñe nandɨ-tale ama gɨta Falisi ama sɨndɨ kilañmet! Anutu en mek sambekak. Ama manjɨ manbenjɨ malet nomɨk sɨndɨ nepek gɨtɨk kasɨleañ wɨn danbɨm, kɨt tambon tambon tɨmbɨmbi, tambon noñgan Anutulok pa mañ, wɨn nepek tipnam gwasap wandin tuan wopum nɨmnat wɨn bo sɨndɨ nɨm kamalañ. Wɨndɨñgan sɨndɨ endɨkñe manda wandin kambak kɨmɨt-kleañ, gan endɨkñe manda Anutu enlok dainan loloñ sɨnɨk wɨn pa lapɨkañ. Endɨkñe manda loloñ sɨnɨk walɨ nosii kundit dɨndɨm ba mamasa tɨ-semnelɨñdok, tɨmbi Anutu tɨke-kwambɨñ danelɨñdok pa sanañ. Wɨndɨñda sɨndɨ gembɨ kopi, endɨkñe manda loloñ wɨn kɨmɨt-klenekalɨñ. Tɨñɨpi, endɨkñe manda dɨwɨn gɨtɨk wɨn bo nɨm nandɨ-kɨmnenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Sɨndɨ ama dautsɨ sisipmɨn wandin walɨ nosiila telak daut sembi, ñɨndɨñ tañ: sɨndɨ endɨkñe manda tip mɨnam wɨn ka-kɨliñ em kleañ, gan endikñe manda bien wopum sɨnɨk wɨn nɨm pa ka-nandɨ-dakleañ. Wɨndɨñda sɨndɨ ama nolɨ kwɨnakam tip mɨnam sɨnɨk tuk wɨtna gɨnañ nanin tɨke kotak, gan kamel wopum wolok patak wɨn nɨm kañbi, tuk tɨke lombi, wakɨtañgan kɨmo elak en wandin! ");
INSERT INTO nif_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Endɨkñe nandɨ-tale ama gɨt Falisi ama sɨndɨ kilañmet! Ama manjɨ manbenjɨ malet nomɨk sɨndɨ jawañ ba kambot pawañgot wɨlɨt-kɨliñ tɨndɨn wandin, gan nepek kolan kusei kusei gɨnañjɨ gɨnañ tokñe-patak, wɨn sɨndɨ ep tɨndɨnjɨ kɨndem wolok walan pa tañ, gan ama piñpiñen sɨndɨ gɨnañjɨ gɨnañ sɨnɨlañgot pa nandañ. ");
INSERT INTO nif_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falisi dautsɨ sisipmɨn sɨndɨ dama gɨnañjɨ kambot gɨnañ nomɨk wɨn wɨlɨlɨmek, wolondamek pawan kɨndem daukak. ");
INSERT INTO nif_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Endɨkñe nandɨ-tale ama gɨta Falisi ama sɨndɨ kilañmet! Ama manjɨ manbenjɨ malet nomɨk sɨndɨ ama sum no kawattɨ masipbi, pama satnin walɨ sapleñgɨlɨñ wandin. Pawan ka kɨndem danat, gan wolok gɨnañ ama kwandat gɨt nepek dañgalan walɨ tokñe-patak. ");
INSERT INTO nif_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wɨndɨñgangot sɨndɨ amalok dausɨnan ep tɨndɨnjɨ dɨndɨm walan tañ, gan ep tɨndɨnjɨ juluñ ba tɨmɨpmɨlelɨ gɨnañjɨ gɨnañ tokñe-patak. ");
INSERT INTO nif_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Endɨkñe nandɨ-tale ama gɨta Falisi ama sɨndɨ kilañmet! Ama manjɨ manbenjɨ malet nomɨk sɨndɨ plofet ama damanin ba ama Anutulok dainan dɨndɨm kuñgɨlɨñ endok sum wɨn tɨ-kɨndem dam tɨ-jamilambi, sumnan pama kɨndem kɨndem kɨmɨpi, ");
INSERT INTO nif_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","juluñgan ñɨndɨñ pa eañ, ‘Bep pañniilok nainnan kunemda, nɨnɨ ep tɨmbɨ platambi, plofet ama nɨm yandɨp kɨmneñ.’ ");
INSERT INTO nif_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Manda wɨndɨñ pa eañ wɨn ñɨndɨñ inda-daklelak: bep pañjiilɨ plofet yandɨpgɨlɨñ, tɨmbi endok komblinjii sɨndɨ enɨsɨ nomɨk kuañ. ");
INSERT INTO nif_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Wala tɨmbi kɨndem a, bep pañjiilɨ plofet yandɨp kɨm kena kusei kɨmɨkɨlɨñ wɨn yousɨmbi, sɨndɨ ña tɨmbɨ taleukak! ");
INSERT INTO nif_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Sɨndɨ malet upmat wandin! Anutulɨ manda plon sep kɨmɨlɨmbi, jɨmbɨñdok gɨñgɨt tɨnekalɨñ wɨn sɨndɨ nɨtek maklenekalɨñ? Walɨ tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wɨndɨñda ñɨndɨñ sanba: nak plofet ama wakɨt ama nanandɨnjɨat ba ama Anutulok telak san-daut tañ sɨndoñ en-mulambi bañ. Gan sɨndɨ dɨwɨn yandɨp kɨmbi, dɨwɨn kloñbat plon yandɨp kɨmnekalɨñ. Dɨwɨn it kiyaunjɨ gɨnañ ep waipbi, dɨwɨn it kwet ñanekalɨñ tuop ep klem gɨmgɨm embi, yandɨp kɨmnelɨñdok. Sɨndɨ kolan wɨndɨñ pa tɨ-semnekalɨñ, ");
INSERT INTO nif_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","wala tɨmbi damasɨlɨ ama dɨndɨm gɨtɨk yandɨpmɨu kɨmgɨlɨñ wolok tuan wɨn sɨndɨ ombɨ-tɨkenekalɨñ. Ama yom nɨmnat damandama wɨlɨ kɨmguk wɨn Abel. Tɨmbi siñgi endɨ ama dɨndɨm asup yandɨp-ta-ñambi, siñgi sɨnɨk endɨ Sekalaia Belekialok nɨñañ tapma it wakɨt sisuet wolok boñgɨpsetnan wɨlɨ kɨmguk. ");
INSERT INTO nif_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nak biañgan sɨnɨk sanba: yandɨpmɨu kɨmgɨlɨñ wolok tuan wɨn amatam man ñɨndɨñgɨta kuañ sɨndɨ ombɨ-tɨkenekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yesulɨ yousɨmbi eñguk, “Jelusalem Jelusalem amatam sɨndɨ plofet ama yandɨp kɨmañ, tɨmbi ama Anutulɨ sɨndoñ en-mulɨm bañ wɨn kawattɨ yandɨp kɨm pa tɨ-semañ. Puput meñlɨ nɨñañii ep kamailak, wɨndɨñgangot nak nain asupgan sep kamaiuttok nandɨñgut, gan sɨndɨ nɨm nandɨ-tale-namgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nandañ: Anutulɨ tapma isɨ biumbi, itgot pat-samekak. ");
INSERT INTO nif_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nak ñɨndɨñ sanlet: sɨndɨ ñɨndɨñ nanɨnekalɨñ, ‘Molomdɨ ama ñɨn ama wapmañnɨ kuuktok nɨ-mukuk en wakan gwɨlam tɨñmen!’ wɨndɨñ nanɨnekalɨñ, wolondam ek nombo nambɨnekalɨñ, damala nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesulɨ tapma it bimbi, pɨ ñañɨlɨmbi, gwañgwañiilɨ endoñ bɨmbi, it gɨtɨk tapma it sañ jimba gɨnañ pakɨlɨñ wɨn kauktok nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eumbi enguk, “Ale. Nɨndɨ it kɨndem ñɨn gɨtɨk kana. Nak biañgan sɨnɨk sanba: nain indaumbi, it gɨtɨk kawat wopumdɨ tɨndɨn ñɨn ep wialɨmbi, kawat papuseneumbi, kawat nolɨ nollok plon no nɨm galɨ-palekak.” ");
INSERT INTO nif_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tɨmbi Yesulɨ Oliv kwet jañgɨn wolok lom pipalɨmbi, gwañgwañiilɨ enɨsɨngan endoñ bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Nain nekta sɨnɨk wɨndɨñ indaukak wɨn nɨnɨmbɨm nandɨna. Tɨmbi nek kundit no indaumek wɨn ñɨndɨñ ka-nandɨnekamɨñ: dɨkok undane tomtom nainga indaumbi, kwettok nain taleup tɨlak?” ");
INSERT INTO nif_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Eumbi, Yesulɨ tambanembi enguk, “Sɨndɨ ka-kɨliñ embi kunekalɨñ. Nɨm kañbi, ama nolɨ sɨnda juluñɨt tɨ-samek. ");
INSERT INTO nif_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Neta, ama asuptɨ nokok kotna plon bɨ indambi, ‘Natna Mesia Anutulɨ nan-mulektok e-kwambɨñ dañguk wɨn nak ñakan’ wɨndɨñ embi, amatam asup juluñɨt tɨ-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nain wolonda sɨndɨ mik ñasɨñgan tañ wolok gɨñgɨlɨ wakɨt mik mayañgan tañ wolok gɨñgɨt nandɨnekalɨñ, gan nɨm mɨsɨnekalɨñ. Nepek wɨn gɨtɨk indaindalok elet, gan kwet taletalelok nain wɨn gamamek indaukak. ");
INSERT INTO nif_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ama sambat nolɨ sambat no gɨt mik minekalɨñ, ba ama wapmañ nolɨ ama wapmañ no gɨt mik minekalɨñ, ba kwet nolok ba nolok nanañ map wopum indaukak, ba kwet mɨnjamɨnjat tɨmbekak. ");
INSERT INTO nif_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Gan nepek wɨn gɨtɨk indaukak wɨn tamdɨ gwañgwa tɨkenepi dama siñgin gawat lakalakat nandañ wandin. Siñgin gawat wopumgan wɨn siñgimek indaukak. ");
INSERT INTO nif_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nain wolonda sɨndɨ gwañgwanai kuañda tɨmbi amatam gɨtɨktɨ nandɨ-kunjɨt wopumgan tɨ-sambi sepmbi, kanjɨksiilok kɨsɨnan sapɨlɨmbi, dɨwɨn kena gɨm samnekalɨñ, dɨwɨn sandɨp kɨmnekalɨñ. Wɨndɨñ tɨ-sam tɨ-kuumbi, ");
INSERT INTO nif_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","sɨndoññan nasɨ asuptɨ nanandɨ-kɨlɨktɨnjɨ biu pɨumbi, tambon tambon bola tɨ-sembi, nandɨ-kunjɨt wopumgan tɨ-sem-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tɨmbi plofet julunjuluñ asuptɨ indambi, amatam asup juluñɨt tɨ-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Tɨmbi amatamdɨ tɨmɨpmɨle wopumgan sɨnɨk tɨnekalɨñda tɨmbi asupgandɨ nosiila gɨnañjɨ tombo mɨ tañ wɨn nombo nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gan no en wandingan embi gɨñgɨnembi, dɨñɨndam palekak, en wakan Anutulɨ nain taletalen indaumbi enlok tɨke-kɨmɨlekak. ");
INSERT INTO nif_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tɨmbi amatam gɨtɨk Anutulɨ yambɨ-dɨkñeukak wɨn nandɨ-daklenelɨñdok endɨ gɨñgɨt manda kɨndem ñɨn kwet tuop eu sapakñelok nandɨlak. Sapakñe-taleumek, nain taletalen wɨn indaukak.” ");
INSERT INTO nif_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yesulɨ yousɨmbi enguk, “Nepek kolan papait tapma it tɨmbɨ kolaukak wolok plon plofet Daniellɨ manda no youp biñguk patak. (No en manda youtet ñɨn pinalekak endɨ wolok kusei nandɨ-kɨliñ ewɨn.) Wɨndɨñda sɨndɨ nepek kolan wɨn Anutulok ilnan kwel kɨnjannan ilɨm kanekalɨñ, ");
INSERT INTO nif_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Judia distrik pakañ endɨ kwet jañgɨnnan pi ñanelɨñdok elet. ");
INSERT INTO nif_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tɨmbi kwet plon pakañ endɨ nepenepesii metnepi isɨ gɨnañnan nɨm lonelɨñ, ");
INSERT INTO nif_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ba kena gɨnañ pakañ endɨ saulonjɨ tɨkenepi isɨnan nɨm undane ñanelɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tɨmbi nain wolonda tam mɨnjɨpsɨat ba gwañgwa num pa emañ endɨ blasɨñgandok. ");
INSERT INTO nif_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","21","Nain wolonda amatamdɨ mɨlap wopum sɨnɨk bemnekalɨñ, wala tɨmbi sɨndɨ nain wolokta nɨmolo pa tɨnekalɨñ. Nɨm kañbi, mɨlap wɨn gwi sasale ba Sabat pat-nandɨ nainnan inda-samumbi, pi ñañalok telak kɨmɨsip tɨ-samek, ñala. Mɨlap wandin wɨn kwet kusei kɨmɨkɨmɨlɨnan nanin bɨkap man ñɨndɨñgɨta no nɨm indaindan, gɨtikñin sɨnɨk indaukak. Tɨmbi wolok siñgi kandañ bo mɨlap wandin nombo nɨm indaukak. ");
INSERT INTO nif_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tɨkap Anutulɨ nain wɨn ikan nɨm tɨmbɨ dumalaumda, amatam gɨtɨktɨ talenelɨñ. Gan endɨ amatam ep danbi enlok gɨñgɨt kasɨleñguk enda tɨmbi nain wɨn tɨmbɨ dumalaukak. ");
INSERT INTO nif_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","24","Nain wolonda Mesia juluñgan ba plofet juluñgan endɨ indambi, nɨsɨlok kusasɨ tɨmbɨ dakle-semnelɨñdok amatam dausɨnan kundit gembɨnat engano sɨnɨk tɨmbi, juluñɨt tɨ-semnekalɨñ. Tɨkap ama wandisɨ endɨ tuopta, endɨ amatam Anutulɨ ep danbi enlok gɨñgɨt kasɨleñguk enda bo juluñɨt tɨ-semnelɨñdok nandɨnekalɨñ. Wɨndɨñda tɨkap ama nolɨ ñɨndɨñ sanbekta, ‘Yakñesɨ! Mesialɨ ñɨ patak!’, ba ‘Wɨ kawɨt! Endɨ da patak’ wɨndɨñ sanbɨmbi, manda wala nandum tlal tɨmbekak. ");
INSERT INTO nif_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nandañ. Nak nepek wandin indaukak wɨn itañgan san-talelet, ");
INSERT INTO nif_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","wala tɨmbi tɨkap endɨ ‘Yakñesɨ! Mesialɨ kwet kambaññan sɨlaninnan bɨ patak’ wɨndɨñ sanɨnekalɨñda, wandɨñ nɨm ñanekalɨñ. Ba ‘Endɨ it ñolok gɨnañ patak’ wɨndɨñ sanbɨmbi, mandanjɨ nandum tlal tɨmbekak. ");
INSERT INTO nif_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kusei ñɨndɨñda wɨndɨñ sanlet: Amalok Nɨñañ endok tomtom wɨn pɨsapɨsat wandin, wala tɨmbi kwet kɨmɨlɨ taleñguknan amatam gɨtɨkkandɨ wɨn kanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yesulɨ wɨndɨñ embi, e-yout manda no ñɨndɨñ eñguk, “Nepek wɨlɨ kɨmguk patakñan klekakaktɨ kɨmɨn tɨmbɨmbi, delok patak wɨn inda-daklelak.” ");
INSERT INTO nif_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yesulɨ yousɨmbi eñguk, “Mɨlap wopum nain wolonda indaukak walɨ taleumek, maimdɨ bipmɨumbi, yakɨptɨ nɨm saleukak, tɨmbi domboñgɨptɨ kwesɨ bimbi bululup em pɨnekalɨñ. Tɨmbi nepek kwambɨñ dɨwɨn bamup sɨlaninnan pakañ ep mɨnjalɨmbi jɨlop talenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Wolongan nepek dɨwɨn no kunum plon indambi, Amalok Nɨñañlɨ tombepi tɨlak wɨn tɨmbɨ dakleukak. Indaumek, kwelalok amatam gɨtɨkkandɨ wɨn kañbi, mɨsɨm mano tɨmbi kanekalɨñ wɨn: Amalok Nɨñañ en Anutulok gembɨn ba kolsalen wopumnat mulukua plon pɨmbi tombekak. ");
INSERT INTO nif_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tɨmbi mumumlɨ wopumgan pendɨlɨm kɨtɨumbi, endɨ añeloñii en-mulɨm ñambi, kunum kwet kɨmɨlɨ taleñguknan amatam enlok gɨñgɨt ep danbi kasɨleñguk wɨn ep kiut-talenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sɨndɨ komba konelok plon nanandɨ ñɨn epnekalɨñ: endɨ sak kawai pɨ-taleumbi pakap, kii gayamdɨ tukñat tɨmbi, sak kaik indaum kañbi, wolonda maim nain indaupi tɨlak wɨndɨñ nandañ. ");
INSERT INTO nif_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Wɨndɨñgangot sɨndɨla nepenepek gɨtɨk sanɨt walɨ indaum kañmek, Amalok Nɨñañlɨ yamanan papi tombepi tɨlak wɨndɨñ ka-nandɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nak biañgan sɨnɨk sanba: ama sambat ñɨndɨñgɨta kuañ endɨ gama nɨm sembɨ-taleñɨlɨmbi, nepek gɨtɨk walɨ indaukak. ");
INSERT INTO nif_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunum kwet paitekamɨk, gan mandanalɨ nɨm paipi, papat kwambɨñ palekak.” ");
INSERT INTO nif_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila enbi eñguk, “Nepek wɨn dawanda sɨnɨk indaukak wɨn ama nolɨ nɨm nandɨlak. Kunumdok añelo gɨta Anutu enlok Nɨñañ endɨ bo wɨn nɨm nandañ, wɨn Bep en noñgandɨñgot nain wɨn nandɨlak. ");
INSERT INTO nif_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Amalok Nɨñañ endok tomtom nainnan nepek nek indaukak wɨn nepek Noalok nainnan indañguk wandin. ");
INSERT INTO nif_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tuk gwam gama nɨm indañɨlɨmbi, amatamdɨ nanañ tuk sina tɨmbi, wapa tam pa tɨñgɨlɨñ. Wɨndɨñ tɨ-kuñɨlɨmbi ñakap, Noa en kɨkeñ wopum kɨndikuknan loñguk. ");
INSERT INTO nif_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Loumbi, gwam wopum suambi, amatam gɨtɨk ep walaiñguk nain wolondañgangot endɨ nek inda-semguk wɨn ka-nandɨ-tomgɨlɨñ. Wɨndɨñgangot Amalok Nɨñañ endok tomtom naindɨ amatam nɨm mandɨ-palɨmbi kaikan inda-semekak. ");
INSERT INTO nif_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nain wolonda ama tɨpet endɨ kena gɨnañ yakan palɨñɨlɨmbi, no bimbi, no matɨkeukak. ");
INSERT INTO nif_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tɨmbi tam tɨpet endɨ yakan nanañ mɨndɨ-palɨñɨlɨmbi, no bimbi, no matɨkeukak. ");
INSERT INTO nif_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Sɨndɨ Wopumjɨlɨ nain nekta sɨnɨk bɨ tombekak wɨn nɨm nandañ, wala tɨmbi ka-kɨliñ embi kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Sɨndɨ manda ñɨn nɨm nandɨ-kamalanekalɨñ: it molomdɨ kumbu amalɨ tim nain nekta sɨnɨk bɨup eñguk wɨn nandɨwɨmda, endɨ kaik papi, kumbu ama mandɨ-palɨmbi, endɨ bɨm il wɨlɨ blañganeumbi, gɨnañ louktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɨm kañbi, sɨndɨ nain no ‘Endɨ nɨm bɨutak bek’ wɨndɨñ nandɨñɨlɨmbi, wolondamek en bɨ tombek, wala tɨmbi sɨndɨ nain tuop endok tomtomñɨla tɨ-pañgɨpañgɨle tɨ-ta-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yesulɨ yousɨmbi enguk, “Sɨndɨ kena gwañgwa nanandɨ kɨndem ba matañgotañgonat wandin kunekalɨñ. Molomdɨ kena gwañgwa wandin nola kena gwañgwa dɨwɨn yambɨ-dɨkñeuktok kɨmɨpi, nanañ dandan nainnan sɨnɨk nanañ dan-semektok nɨmbi, molom en kwet nolok ñawɨk. ");
INSERT INTO nif_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ña kukap, ilnan undane bɨmek kawɨk wɨn: kena gwañgwa walɨ molomdɨ nɨñguk wolok tuop tɨmbɨmbi kaumbi, kɨndem dañmek. ");
INSERT INTO nif_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nak biañgan sɨnɨk sanba: molomdɨ kena gwañgwa wɨn enlok nepenepelɨ gɨtɨk ka-dɨkñeuktok nɨmbɨ taleukak. ");
INSERT INTO nif_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gan tɨkap kena gwañgwa walɨ ama kolanda, endɨ gɨnañlɨ ‘Molomna plakan nɨm undane bɨukak’ wɨndɨñ nandɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","kusei kɨmɨpi, kena gwañgwa nolii yandɨpmek, tɨmbi ama tuk sañan nanalok en gɨta nanañ tuk nambek. ");
INSERT INTO nif_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Endɨ molom nain nekta sɨnɨk undane bɨukak wɨn nɨm nandɨlakta, endɨ nɨm mandɨ-palɨmbi, kaikan bɨ tombekak. Tombi, ");
INSERT INTO nif_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","kena gwañgwa wɨn tɨ-lamɨpi, ama Anutulok manda julunjuluñ tañgoneañ en gɨta kɨmɨlɨmbi, mano kwɨlɨm tɨmbi, man sɨ-gɨlɨm daukak.” ");
INSERT INTO nif_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesulɨ yousɨmbi enguk, “Amalok Nɨñañ tombekak wolonda Anutulɨ amatam yambɨ-dɨkñeukak wolok walan no ñɨndɨñ: ama no tam tɨndɨlok nain tombɨmbi, tam sim kɨt tombon tombon endɨ tipalanjɨ tɨkembi, tam nosɨ wapai tɨmbepi tɨñguk endok ilan ñañgɨlɨñ. Ñam papi, wapailɨ bɨm enlok ilnan yanañgɨlektok mandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Tam sim kɨt tombon endɨ kamasɨla tɨmbi, tipalanjɨñgot tɨkembi, tul wɨlɨñgɨlo gɨnañ no nɨm wɨpi tɨkeñgɨlɨñ. Tɨmbi tam sim kɨt tombon endɨ nanandɨnjɨat, wala tɨmbi tipalanjɨ tɨkembi, tul wakɨt wɨlɨñgɨlo gɨnañ wɨpi tɨkeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tɨmbi endɨ ama wɨn mandɨ ka-tɨlapi, gwasaem douñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Dou-palɨñɨlɨmbi, tim bomup tɨmbɨmbi, kɨtɨkɨtɨ no ñɨndɨñ indañguk, ‘Ama bɨmbɨlok een en ip tamɨn nañgɨp, ilnan ñauktok bɨlak, ipa mɨlap pɨm bɨmbi tɨmbɨ indawɨt!’ ");
INSERT INTO nif_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tɨmbi tam sim endɨ nandɨ sɨlɨkñem mɨlapi, tipalanjɨ tɨkembi tɨ-dɨndɨm tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Tɨmbi kamasɨlɨ nanandɨnjɨat enda ñɨndɨñ engɨlɨñ, ‘Nɨndok tipalanɨ kɨmlak, wala tɨmbi sɨndɨ tul kambak wɨt-nɨmɨt.’ ");
INSERT INTO nif_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Eumbi, nanandɨnjɨat endɨ ñɨndɨñ engɨlɨñ, ‘Wɨn nɨtek tɨneñ? Nɨndok tipala tul wɨn tipala tɨpettok tuop nɨm, wala tɨmbi sɨndɨ tuatua ilan ñam sɨnlok tuawɨt.’ ");
INSERT INTO nif_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Tɨmbi endɨ tul tuanep ñañɨlɨmbi, ama walɨ tam gɨñgɨt wɨlɨmɨñgɨlɨñ enda bɨ tombi, tamɨn wakɨt tam sim tɨ-jumɨt tɨ-pakɨlɨñ wɨn enlok ilnan yanañgɨlɨmbi ñañgɨlɨñ. Ña amalɨ tam tɨmbepi nanañ si-jumɨt tɨñguknan it wolok loum, yama sipmu kwambɨñ daumbi, nanañ tuk na-pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Palɨñɨlɨmbi, tam kamasɨ kɨt tombon endɨ bo bɨmbi kɨtɨmbi, ñɨndɨñ eñgɨlɨñ, ‘Ama wopum, ama wopum, yama pɨsat-nɨmɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kɨtɨumbi enguk, ‘Nak biañgan sanba: nak sɨndɨ nɨm nandɨ-samlet.’” ");
INSERT INTO nif_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesulɨ e-yout manda wɨndɨñ embi yousɨmbi enguk, “Sɨndɨ Amalok Nɨñañ endɨ dawanda sɨnɨk bɨ tombekak wɨn nɨm nandɨañda tɨmbi ka-kɨliñ embi mandɨ-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesulɨ yousɨmbi, Amalok Nɨñañlɨ tombekak nain wolok plon e-yout manda no ñɨndɨñ enbi eñguk, “Ama nolɨ kwet nolok ñaupi, kena gwañgwañii en-tiañeum bɨumbi, nepenepelɨ tambɨpi, ka-dɨkñeñmɨnelɨñdok emguk. ");
INSERT INTO nif_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Tɨñɨpi, ama nola mɨnem kwandai 5,000 mɨñguk, nola 2,000 mɨñguk, tɨmbi nola 1,000 mɨñguk, wɨn kena tañ gembɨnjɨ yambɨ-nandɨlak wolok tuop ka-dɨkñeñmɨnelɨñdok emguk. Em-talembi, en yambimbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ñañɨlɨmbi, ama mɨnem 5,000 epguk endɨ wolongan kusei kɨmɨpi, mɨnem kena mɨumbi yousɨñmɨumbi, mɨnem 5,000 nombo indañmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nollɨ no mɨnem 2,000 epguk endɨ bo mɨnem kena mɨumbi, mɨnem 2,000 nombo indañmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gan ama mɨnem 1,000 epguk endɨ wɨne molomlok mɨnem wɨn ep ñambi, kwet gɨnañ kɨndit taplium pakuk. ");
INSERT INTO nif_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tɨmbi molomdɨ nain ombap kukap undanem bɨñguk. Bɨmbi, kena gwañgwañii mɨnem emguk wala ep kɨmɨn tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tɨmbi ama mɨnem 5,000 mɨmɨn endɨ bɨmbi, mɨnem 10,000 daulmɨmbi eñguk, ‘Molom, dɨk mɨnem 5,000 namguñ. Tɨmbi nak wɨn epbi, kena mɨwambi nombo yousumbi, 5,000 nombo indañguk.’ ");
INSERT INTO nif_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Eumbi, molomñɨlɨ ñɨndɨñ nɨñguk, ‘Dɨk kena gwañgwa kɨndem matañgotañgoñganat. Dɨk nepek lakattok ka-dɨkñe kɨndem kuñguñda tɨmbi, nak nepek asup gamambi ka-dɨkñeukañ. Wala tɨmbi dɨk bɨumbi, sɨlɨsɨlɨ tɨna!’ ");
INSERT INTO nif_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Wɨndɨñ eumbi, kena gwañgwa mɨnem 2,000 mɨmɨn endɨ bo bɨ tombi, mɨnem daulmɨmbi nɨñguk, ‘Molom, dɨk mɨnem 2,000 namguñ, tɨmbi nak mɨnem wɨn kena mɨwambi yousumbi, mɨnem 2,000 nombo indañguk.’ ");
INSERT INTO nif_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Eumbi, molomñɨlɨ ñɨndɨñ nɨnguk, ‘Dɨk kena gwañgwa kɨndem matañgotañgoñganat. Dɨk nepek lakattok ka-dɨkñe kɨndem kuñguñda tɨmbi nak nepek asup gamambi ka-dɨkñeukañ. Wala tɨmbi dɨk bɨumbi, sɨlɨsɨlɨ tɨna!’ ");
INSERT INTO nif_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Tɨmbi ama mɨnem 1,000 mɨmɨn endɨ bo bɨ tombi eñguk, ‘Molom, nak kusaka ñɨndɨñ ip nandɨlet: dɨk ama kunduwat. Dɨk nanañga nɨm tɨpi nalañ, amalɨ tɨmbɨ indaumbi gamnelɨñdok pa elañ. Tɨñɨpi, amalɨ kwet nolok nanañ tɨpium indalak wɨn yapma tɨkelañ. ");
INSERT INTO nif_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wala tɨmbi nak dɨkok mɨnemga nɨm kañbi pailek wala mɨsɨmbi, kwet kɨndipi, tapli sembam pakuk ñɨn tɨke gam bɨlet.’ ");
INSERT INTO nif_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wɨndɨñ eumbi, molomñɨlɨ manda ñɨndɨñ tambane nɨñguk, ‘Dɨk kena gwañgwa kolan ba kunjitan! Dɨk kusatna ñandin bek wɨn nandɨlañ: nak nanañna nɨm tɨpi nalet, amalɨ tɨmbɨ indaumbi namnelɨñdok pa elet. Tɨñɨpi, kwet nolok amalɨ nanañ tɨpium indalak wɨn yapma tɨkelet. ");
INSERT INTO nif_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Wɨndɨñda nɨtek tɨmbi mɨnemna wɨn mɨnem it gɨnañ nɨm kɨmɨkuñ? Wandɨñ kɨmɨlɨmda, nak bɨmbi, mɨnemna wɨn mɨnem it gɨnañ nanin epmep ewambi, lakat yousɨ-namnelɨñ.’ Molomlɨ wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","29","kena gwañgwa dɨwɨsɨla ñɨndɨñ enguk, ‘Ama gɨtɨk nepek dɨwɨn pat-semlak wɨn tɨke-kuañ, enda nombo yousɨm emambi, asupgan pat-semekak. Gan ama no nepek palmɨlak wala nandum tlal tɨmbɨmbi nɨm tɨke-kulakta, nepek lakat palmɨlak wɨn apma tɨkeñmambi slak palekak. Wala tɨmbi sɨndɨ mɨnem 1,000 ñɨn apma tɨkembi, ama mɨnem 10,000 ep patak enda mɨwɨt. ");
INSERT INTO nif_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tɨmbi kena gwañgwa kena nɨmnat ñɨn tɨke kolɨm pawan kɨlɨm gɨnañ pɨwɨn. Wandɨñ amalɨ mano kwɨlɨm tɨmbi, manjɨ sɨ-gɨlɨm danekalɨñ.’” ");
INSERT INTO nif_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesulɨ yousɨmbi enguk, “Amalok Nɨñañlɨ añeloñii gɨtɨk en gɨta bɨ tombi, ama wapmañ gembɨn walalannat inda-dakleumek, endɨ amatam gɨtɨk ep danbektok ama wapmañ pipapat plon pipalekak. ");
INSERT INTO nif_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tɨmbi añelolɨ amatam kwelan damañgan kuñgɨlɨñ ba man ñɨndɨñgɨt kuañ gɨtɨk wɨn endok dainan kɨmɨn tɨmbɨmbi yambɨ-danbi, sambat tɨpet ep samba eukak. Meme sipsip yambɨ-dɨkñe amalɨ tañ wɨndɨñ ep danbi, ");
INSERT INTO nif_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","amatam dɨndɨm kɨt dɨndɨmnan yambimbi, dɨwɨn kɨt kepmanan yambiumbi patnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Tɨmbi amatam kɨt dɨndɨmnan patnekalɨñ enda ñɨndɨñ enbekak, ‘Bepnalok gwɨlam sɨndok plon patak sɨndɨ bɨmbi, kuñgu kɨndem kasɨlewɨt! Kuñgu wɨn Anutulɨ kunum kwet kusei kɨmɨkuknan tɨ-jumɨt tɨ-sam-taleñguk. ");
INSERT INTO nif_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kusei ñɨndɨñda sɨndɨ kuñgu wɨn kasɨlenekalɨñ: nak nanañnala map palambi, sɨndɨ nanañ namgɨlɨñ. Ba tuknala kɨmbambi, tuk namgɨlɨñ. Nak nosɨ nɨm, gan sɨndɨ not tɨ-nambi, isɨnan nanañgɨp ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Sandumna nɨmnat tɨmbambi, sɨndɨ sandum namgɨlɨñ. Jɨmbat inda-namumbi nambɨ-dɨkñeñgɨlɨñ. It kwambɨñ gɨnañ palambi bɨ nambɨñgɨlɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Amatam dɨndɨm endɨ manda wɨn nandɨmbi, tambon ñɨndɨñ nɨnekalɨñ, ‘Wopum, dawanda nanañgala palɨmbi gambɨmbi, nanañ gamgɨmɨñ? Ba dawanda tukkala kɨmbɨmbi, tuk gamgɨmɨñ? ");
INSERT INTO nif_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Dawanda dɨk notnɨ nɨm, gan not tɨ-gambi, itnɨnan ganañgɨp ñañgɨmɨñ? Ba sandumga nɨmnat gambɨmbi, sandum gamgɨmɨñ? ");
INSERT INTO nif_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dawanda jɨmbat tɨñguñ ba it kwambɨñ gɨnañ pakuñ, tɨmbi ña gambɨñgɨmɨñ?’ ");
INSERT INTO nif_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Eumbi, Ama Wapmañlɨ ñɨndɨñ tambane enbekak, ‘Nak biañgan sɨnɨk sanba: sɨndɨ nepek no nokok notnai kosɨ gɨñgɨl nɨmnat endoññan nanin nola tɨñmɨñgɨlɨñ wɨn wakan naka tɨ-namgɨlɨñ tɨlak.’ ");
INSERT INTO nif_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Wɨndɨñ eñɨpi, amatam kii kepmanan ñɨndɨñ enbekak, ‘Anutulok yala sɨndok plon patak sɨndɨ wi-nambi, komba galk gɨnañ ña-talewɨt. Komba taletalen nɨmnat wɨn Anutulɨ Satan gɨt endok añeloñiilok tɨ-jumɨt-semguk. ");
INSERT INTO nif_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kusei ñɨndɨñda sɨndɨ komba galk gɨnañ ñanekalɨñ: nak nanañ map palambi, sɨndɨ nanañ nɨm namgɨlɨñ. Tuknala kɨmbambi, tuk nɨm namgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nak nosɨ nɨm, tɨmbi sɨndɨ not nɨm tɨ-nambi, isɨnan nɨm nanañgɨp ñañgɨlɨñ. Sandum nɨmnat palambi, sɨndɨ sandum no nɨm namgɨlɨñ. Jɨmbat tɨ-palambi ba it kwambɨñ gɨnañ palambi, sɨndɨ nɨm bɨ nambɨñgɨlɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Tɨmbi endɨ bo tambane ñɨndɨñ nɨnekalɨñ, ‘Wopum, dawanda nɨndɨ gambɨnambi, dɨk nanañgala ba tukkala pakuñ, ba dɨk notnɨ nɨm, ba sandumga nɨmnat pakuñ, ba jɨmbat tɨ-pakuñ, ba it kwambɨñ gɨnañ pakuñ, tɨmbi nɨndɨ plap nɨm tɨ-gamgɨmɨñ?’ ");
INSERT INTO nif_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Tɨmbi endɨ bo ñɨndɨñ tambane enbekak, ‘Nak biañgan sɨnɨk sanba: sɨndɨ ama kosɨ nɨmnat ñɨn endoññan nanin ama no plap nɨm tɨñmɨñgɨlɨñ wɨn wakan nak tɨ-namgɨlɨñ tɨlak.’” ");
INSERT INTO nif_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Yesulɨ wɨndɨñ embi yousɨmbi enguk, “Ama wɨndɨñ tɨñgɨlɨñ endɨla pɨ ñambi, kuñgu kolan taletalen nɨmnat tɨkeumbi, pɨñgɨp gawat papat kwambɨñ inda-semekak. Gan amatam dɨndɨm endɨla kuñgu kɨndem taletalen nɨmnat kas ɨlembi, Ama Wapmañ en nakan kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesulɨ manda wɨn gɨtɨk eu taleumbi, gwañgwañiila ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Sandap tɨpet tɨmbɨmbi, kamaikamai gwɨlat indaukak wɨn sɨndɨ nandɨ-taleañ. Nain wolonda Amalok Nɨñañ kanjɨkñiilok kɨsɨnan kɨmɨlɨmbi, kloñbat plon wɨlɨ kɨmbekak.” ");
INSERT INTO nif_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yesulɨ wɨndɨñ eñɨlɨmbi, tapma ama biesɨ gɨt Juda ama biesɨ endɨ tapma amalok telak damanjɨ koi Kaiapas endok ilan kɨmɨn tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yesu telak gitak tɨkembi wɨlɨ kɨmbektok e-sambat tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Tɨñɨpi, ñɨndɨñ pa eñgɨlɨñ, “Nɨndɨ gwɨlat gɨnañ wɨndɨñ nɨm tɨna. Nɨm kañbi, amatamdɨ nɨmbɨ-nandɨmbi, gimbɨt tɨm mik tɨ-nɨmnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesulɨ Betani it kwelan ñambi, Saimon dama wanda kwambɨñ indañmɨñguk endok ilan ña pakuk. ");
INSERT INTO nif_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Endɨ nanañ na-palɨñɨlɨmbi, tam nolɨ tuk mɨlɨñ kɨndem tuan wopum sɨnɨk wɨn tɨkem endoñ ña indambi, kumbam plon yalɨmukuk. ");
INSERT INTO nif_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gwañgwañiilɨ wɨn kañbi, gɨnañjɨ komba dɨumbi eñgɨlɨñ, “Tuk tuan wopum wandin nekta tɨmbɨ kolalak? ");
INSERT INTO nif_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nɨndɨ tuk wɨn kɨndem tualok kɨmɨtnamda, mɨnem walinin tɨkembi, ama pɨmbɨñesɨla emneñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesulɨ mandanjɨ nandɨ-daklembi enguk, “Tam ñala mɨlap nekta mañ? Endɨ nepek kɨndem sɨnɨk tɨ-namlak ee. ");
INSERT INTO nif_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ama pɨmbɨñesɨlɨ nain tuop sɨn gɨtañgan kunekalɨñ, gan natna sɨn gɨta nain tuop nɨm kuutat. ");
INSERT INTO nif_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tam ñalɨ tuk mɨlɨñnat i-namlak wɨn nak kɨmbambi nep kɨnditnekalɨñ wolok itañgan pɨñgɨpna tɨ-pañgɨpañgɨle tɨ-namlak. ");
INSERT INTO nif_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nak biañgan sanba: amalɨ dembek dembek ñambi, Anutulok kaundɨkñelok plon gɨñgɨt manda kɨndem ñɨn kwet tuop enekalɨñ, wandɨñ endɨ tam ñalɨ nepek tɨ-namguk wolok kasat wakɨt tɨ-semumbi, tam ñɨn nandɨ-sɨwɨtnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tɨmbi gwañgwa 12 endoññan nanin no koi Judas Iskaliot endɨ tapma ama biesɨloñ ñambi, ");
INSERT INTO nif_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","enɨ-nandɨmbi eñguk, “Tɨkap nak Yesu sɨndok kɨsɨnan kɨmɨletta, sɨndɨ nek namnelɨñ?” Eumbi, wolongan mɨnem kwandai satnin 30 mɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mɨumbi, kusei kɨmɨpi, Yesu bola tɨñmektok nain kɨndem dawan indauktok wala kɨmɨt-nandɨ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Plaua nanañ kɨmɨlɨ bendɨ nɨmnat nanalok gwɨlat kusei kɨmɨlɨmbi, gwañgwañiilɨ Yesuloñ bɨmbi nɨñgɨlɨñ, “Dɨk gwɨlattok nanañ delok tɨ-jumɨt tɨ-gamnambi nambep nandɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Eumbi, Yesulɨ ama nolok koi embi enguk, “Jelusalem lombi, endoñ ñam ñɨndɨñ nɨnekalɨñ, ‘Nɨnɨndauttɨ dɨka ñɨndɨñ elak, nokok nainnalɨ indalak, wala tɨmbi nak gwañgwanai gɨta dɨkoñ ilan bɨmbi, gwɨlattok nanañ nanetamɨñ.’” ");
INSERT INTO nif_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Tɨmbi gwañgwalɨ Yesulɨ eñguk wolok tuop tɨmbi, gwɨlattok nanañ tuk tɨ-jumɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kwet kɨlɨm eumbi, Yesu gɨt gwañgwañii 12 endɨ nanañ nanepi pi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nanañ na-palɨmbi Yesulɨ enguk, “Nak biañgan sɨnɨk sanba: sɨndoñ nanin nolɨ kanjɨknailok kɨsɨnan napɨletak.” ");
INSERT INTO nif_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wɨndɨñ eu nandɨmbi, gɨnañjɨ kola sɨnɨk taumbi, kusei kɨmɨpi, noñgan noñganlɨ Yesu nɨ-nandɨmbi eñgɨlɨñ, “Wopum, nakta nɨm bek?” ");
INSERT INTO nif_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Eumbi tambane enguk, “Ama no nakɨta yakayakan nanañ tɨkendepi, kɨtnet jawañ gɨnañ kot-suakamɨk endɨ napɨletak. ");
INSERT INTO nif_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Amalok Nɨñañdɨ Anutulok mandalɨ telak nɨtek kɨmbektok elak wɨndɨñgan kɨmbekak. Gan ama nin en bola tɨñmetak endɨ blangandok. Anutu en mek kaukak. Meñdɨ nɨm apmɨumda, wɨn kɨndem dañmek.” ");
INSERT INTO nif_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Eumbi, bola tɨndɨ ama Judaslɨ Yesu nɨ-nandɨmbi eñguk, “Nɨnɨndaut, nakta nɨm bek?” Eumbi nɨñguk, “Dɨtna elañ wɨndɨñgan.” ");
INSERT INTO nif_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nanañ na-palɨñɨlɨmbi, Yesulɨ plaua nanañ no tɨkembi, Anutula weñmɨmbi ombɨm gwañgwañiila plaua wɨn embi enguk, “Sɨndɨ tɨke nambɨt. Ñɨn nokoñ pɨñgɨpna.” Nambɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","wain wɨtna no tɨkembi, Anutu weñmɨmbi, wain wɨn embi enguk, “Sɨndɨ gɨtɨkkandɨ ñɨn nambɨt. ");
INSERT INTO nif_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wain tuk ñɨn nokoñ wekatna. Amatam asup endok yomjɨ bi-sem-bi-semlok nak wɨn lamɨt-semlet. Toptop ñɨn Anutulɨ amatamñii gɨt tɨlak wɨn wekatnalɨ tɨmbɨ kwambɨñ dalak. ");
INSERT INTO nif_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nak ñɨndɨñ sanba: nak wain tuk kwelan ñolok nombo nɨm nambetat. Nɨm sɨnɨk. Pakapmek Bepnalok kunum nɨlɨnɨlɨn gɨnañ nak wain tuk wɨn komblin sɨn gɨta yakayakan nanekamɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tɨmbi Yesu gɨt gwañgwañii endɨ kap no tiñgɨlɨñ. Tiu taleumbi, walinin pɨ ñambi, Oliv kwet jañgɨnnan lonepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ñañɨlɨmbi, Yesulɨ gwañgwañii enguk, “Anutulok manda no ñɨndɨñ youyoulɨn patak, ‘Nak sipsip ka-dɨkñe ama wɨlambi, kɨkesɨmɨn gɨnañ kuañ endɨ papusenenekalɨñ.’ Nepek inda-nametakta tɨmbi manda wolok tuop sɨndɨ gɨtɨk tim ñolondañgan nanandɨ-kɨlɨktɨnjɨ pi pɨutak. ");
INSERT INTO nif_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gan Anutulɨ nak kɨmnan nanin nepmɨum mɨlatmek, nak dama Galili kwelan ñawambi, sɨndɨ siñgi bɨ nambɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Eumbi, Petlolɨ tambane nɨñguk, “Nepek inda-gametakta tɨmbi dɨwɨndɨ nanandɨ-kɨlɨktɨnjɨ pi pɨumbi gambinetañ bek, gan nakta nɨm sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Eumbi nɨñguk, “Nak biañgan ganlet: man tim ñolok gɨnañnangan puputtɨ gama nɨm kɨtɨñɨlɨmbi, dɨk nain tɨpet gɨt no ‘En nɨm nandɨñmɨlet’ wɨndɨñ eutañ.” ");
INSERT INTO nif_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tɨmbi Petlolɨ nɨñguk, “Tɨkap endɨ dɨkɨta nɨtnɨttok nanɨ-nandɨnelɨñda, ‘Nak nɨm nandɨñmɨlet’ wɨndɨñ nɨm eutet. Nɨm sɨnɨk.” Tɨmbi gwañgwa dɨwɨn gɨtɨk endɨ bo wɨndɨñgan e-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tɨmbi Yesulɨ gwañgwañii gɨt kwet no koi Getsemane wandɨñ ñañguk. Ña tombi, ñɨndɨñ enguk, “Sɨndɨ ñolok pi palɨt, tɨmbi nak dakdan ñambi, nɨmolo tɨmbetet.” ");
INSERT INTO nif_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Wɨndɨñ embi, Petlo gɨta Sebedilok nɨñañiit tɨpet yanañgɨpi ñañguk. Ñañɨpi, walen kolaumbi, gɨnan mɨlataum ");
INSERT INTO nif_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","enguk, “Walena kola sɨnɨk taumbi, kɨmbepi nandɨlet. Sɨndɨ nakɨta ñɨñgan kaik palɨt.” ");
INSERT INTO nif_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Eñɨpi, lakat ñaña embi, gapok pɨmbi, nɨmolo ñɨndɨñ tɨñguk, “Ambep, tɨkap dɨk tuopta, nandɨ-nambi, mɨlap ñɨn napma tɨke. Gan dɨk dɨtnalok nanandɨñgañgot kɨmɨt-kle, nokoñ nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nɨmolo tɨ-talembi, gwañgwañii tɨpet gɨt no endoñ undane ñambi, yambum endɨ dou-palɨmbi, Petlo ñɨndɨñ nɨ-nandɨñguk, “Nɨtekta tɨmbi, sɨndɨ nain duman ñɨn nakɨta kaik patnelɨñdok tuop nɨm? ");
INSERT INTO nif_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sɨndɨ kaik papi, nɨmolo tɨ-palɨt. Nɨm kañbi, tɨ-kuyuk inda-samumbi pi pɨnelɨñ. Biañganak. Gɨnañjɨlɨ kundit kɨndem tɨndɨlok nandɨlak, gan pɨñgɨpsɨlɨ mɨlatalak.” ");
INSERT INTO nif_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Wɨndɨñ embi, nombo ñam nɨmolo ñɨndɨñ tɨñguk, “Bepna. Mɨlap ñɨn napma kleuktok telal no nɨm patakta, nak mɨlap wɨn bemettok nandɨlañ, wɨndɨñgan inda-namen.” Nɨmolo tɨ-talembi, ");
INSERT INTO nif_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","nombo undane gwañgwañiiloñ ña yambɨñguk wɨn: dausɨ mɨlataumbi dou-pakɨlɨñ. Wɨndɨñ yambɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","bɨndambo yambim ñambi, nɨmolo dama tɨñguk wakangot nombo tɨmbɨmbi, nain tɨpet gɨt no tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tɨmbi nombo undane ñam yambum dou-palɨmbi, ñɨndɨñ enguk, “Sɨndɨ gamañgot doumbi, pat-nandɨ tɨ-pakañ ba? Yakñesɨ. Amalok Nɨñañ bola tɨñmumbi, yom amalok kɨsɨnan pɨuktok nain inda-talelak. ");
INSERT INTO nif_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mɨlalɨmbi ñana. Da kawɨt: ama bola tɨ-namnamlok ip ñasɨñgan bɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesulɨ wɨndɨñ eñɨlɨmbi, gwañgwañii 12 endoññan nanin ama no koi Judas endɨ bɨñguk. Tɨmbi tapma ama biesɨ ba Juda ama biesɨ endɨ ama kɨmɨn wopum no en-mulɨmbi, endɨ kakit ba dimbanjɨ epmbi, Judas gɨta bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Endɨ gama nɨm bɨñɨlɨmbi, bola tɨndɨ ama walɨ kundit no daut semepi ñɨndɨñ enguk, “Ama nak nandɨ-koñgom tɨ-ñɨmbi weñmetet wɨn ama sɨndɨ lonjɨañ en wakan. En tɨkenekalɨñ!” ");
INSERT INTO nif_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Judaslɨ bɨ tombi, wolongan Yesuloñ bɨmbi, “Nɨnɨndaut, we gamlet!” nɨmbi, nandɨ-koñgom tɨ-ñɨm weñmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tɨmbɨmbi Yesulɨ nɨñguk, “Notna, nek tɨmbeñdok nandɨlañ wɨn platik tɨ.” Eumbi, amalɨ Yesuloñ bɨm kɨsɨ kot-suapi tɨkembi, tɨke-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wolongan ama Yesu gɨt pakɨlɨñ endoññan nanin nolɨ kakil ombap tiañembi, tapma amalok telak damanjɨ endok kena gwañgwa sɨlanin nolok pawan wɨlalɨm dɨkñe pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wɨndɨñ tɨmbɨmbi, Yesulɨ nɨñguk, “No en kakittɨ mik tɨlakta, en bo kakittɨ wɨlɨ kɨmbekak, wala tɨmbi kakitka il gɨnañ kɨmɨlɨ ñawɨn. ");
INSERT INTO nif_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nak guma Bepna kɨtɨñmambi, wolongan añelo kunakunatsɨ nɨmnat endɨ nep tɨmbɨ platanelɨñdok en-mulek wɨn dɨk nɨm nandɨlañ ba? ");
INSERT INTO nif_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Gan wɨndɨñ indaukta, nepek gɨtɨk Anutulok mandalɨ natnala inda-namektok elak walɨ bien nɨm indawɨk.” ");
INSERT INTO nif_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tɨmbi Yesulɨ yousɨmbi, ama kɨmɨn en tɨkenepi bɨñgɨlɨñ enda ñɨndɨñ enguk, “Nɨtek tɨmbi sɨndɨ kakit ba dimba mepi nepnepi bañ? Nak ama piñpiñen no ba? Sandap tuop nak tapma it sañ jimba gɨnañ pipapi, amatam enɨ-daut tɨ-sem tɨmbambi, sɨndɨ nɨm nepgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Gan plofet amalɨ manda youkɨlɨñ wolok bien indauktok nepek gɨtɨk ñɨn inda-talelak.” Tɨmbi gwañgwañii gɨtɨktɨ Yesu bimbi, pi ña-tɨlɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Tɨmbi ama Yesu tɨkeñgɨlɨñ endɨ en nañgɨpi, tapma ama telak damanjɨ Kaiapas endok ilnan ñañgɨlɨñ. (It wolok gɨnañ endɨkñe manda nandɨ-tale ama gɨt Juda ama biesɨ endɨ kɨmɨn tɨ-pakɨlɨñ.) ");
INSERT INTO nif_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ñañɨlɨmbi, Petlolɨ siñgi kandañ giñgiñgan ep kle ñambi, tapma ama telak damanjɨ endok it sañ jimba gɨnañ loñgɨlɨñ wolok ñambi loñguk. Lombi, Yesu nek indañmetak wɨn kaup nandɨmbi, mik ama gɨta pi pakuk. ");
INSERT INTO nif_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Tapma ama biesɨ gɨt Juda ama biesɨ dɨwɨn endɨ gɨtɨktɨ Yesu wɨlɨ kɨmnelɨñdok nandɨñgɨlɨñda tɨmbi, ama nindɨ Yesulok siñgin joñgo simbi, kusei juluñgan eu indauktok yolonjɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Tɨmbi ama asup endɨ bɨmbi, manda juluñgan embi youkɨlɨñ, gan endɨ wɨlɨ kɨmkɨmlok yom bien no nɨm eu indañgɨlɨñ. Siñgimek ama tɨpet no endɨ bɨmbi ");
INSERT INTO nif_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","eñgɨmɨk, “Ama ñalɨ manda no ñɨndɨñ eñguk, ‘Nak guma Anutulok it wiapi, sandap tɨpet gɨt no wolok gɨnañnan bɨndambo tɨmba kaitam mɨlalekak.’” ");
INSERT INTO nif_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wɨndɨñ eumbi, tapma amalok telak damanjɨ endɨ mɨlap ipi, Yesu nɨ-nandɨmbi eñguk, “Nɨtek? Mandalɨ gep youkamɨk wɨn biañgan ba juluñgan? Ba dɨk manda no tambane ewɨñdok tuop nɨm ba?” Endɨ wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesulɨ yom nɨmnat, gan wandingan embi, manda tambon no nɨm nɨñguk. Tɨmbi telak damanjɨlɨ nɨñguk, “Anutu kuñgu molom endok dainan manda biañgan eumbi nandɨna: Mesia wɨn Anutulɨ nɨ-mulɨmbi, bɨ-nɨmektok een wɨn dɨk wakan ba? Dɨk Anutulok Nɨñañ sɨnɨk ba?” ");
INSERT INTO nif_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Eumbi nɨñguk, “Elañ wakan. Gan nak ñɨndɨñ sanba: gamanda sɨndɨ kanekalɨñ wɨn: Amalok Nɨñañ endɨ Anutu Gembɨ Molom endok kii dɨndɨmnan pipapi, kunum gɨnañ nanin mulukua plon pɨukak.” Yesulɨ en Anutulok tuop sɨnɨk wɨndɨñ eñgukta tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","tapma amalok telak damanjɨ endɨ gɨnañ komba dɨumbi, kiupɨn blañganembi eñguk, “Endɨ Anutu nɨ-tɨke-pɨm yalilak yañ! Ama sɨlanin ñalɨ Anutu nɨ-suambatak wɨn sɨndɨ ip ka nandañ, wala tɨmbi ama nolɨ ama wolok kusei eu indauktok nombo nɨm tɨpɨkamɨñ. ");
INSERT INTO nif_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sɨndɨ enda nɨtek tɨñmɨlok nandañ?” Eumbi tambane nɨñgɨlɨñ, “Yomɨnla tɨmbi kɨmkɨmdok nandamɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wɨndɨñ eumbi, ama dɨwɨndɨ timan dai plon manjɨ iwɨt suambapi, kɨt ombɨmbi wɨkɨlɨñ, tɨmbi dɨwɨndɨ kɨt pɨndɨmdɨ wɨpi ");
INSERT INTO nif_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","nɨñgɨlɨñ, “Dɨk Mesia sɨnɨkta, plofet manda embi, wɨn nindɨ gwɨtak wɨn nɨnbɨ nandɨna!” ");
INSERT INTO nif_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yesu manda plon kɨmɨlɨñɨlɨmbi, Petlolɨ sañ jimba gɨnañ it pawan pipakuk. Pipalɨmbi, kena wembe nolɨ endoñ bɨmbi nɨñguk, “Dɨk bo Yesu Galili nanin endok sambat.” ");
INSERT INTO nif_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Gan Petlolɨ ama gɨtɨk endok dausɨnan e-sembɨmbi nɨñguk, “Nak dɨk manda elañ wɨn nɨm nandɨlet.” ");
INSERT INTO nif_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wɨndɨñ embi mɨlapi, sañ jimbalok yamanan ñaumbi, kena wembe nolɨ kañbi, wɨ pakɨlɨñ enda ñɨndɨñ enguk, “Ama ñɨn Yesu Nasalet nanin endok nol no.” ");
INSERT INTO nif_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Eumbi, Petlolɨ nombo e-kɨmɨsembɨmbi eñguk, “Anutulok dainan biañgan elet. Nak ama wɨn en nɨm nandɨñmɨlet.” ");
INSERT INTO nif_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nain nɨm ombataumbi, wolok ikɨlɨñdɨ Petloloñ bɨmbi nɨñgɨlɨñ, “Biañgan sɨnɨk, dɨk endok sambat. Mañga malaptɨ e-daklelak.” ");
INSERT INTO nif_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Eumbi, Petlolɨ manda kwambɨñgan embi, ñɨndɨñ enguk, “Biañgan sɨnɨk, nak en nɨm nandɨñmɨlet. Juluñgan eletta, Anutulɨ kɨndem nep tɨmbɨ kolawɨn.” Endɨ wɨndɨñ eu taleumbi, wolongan puputtɨ kɨtɨñguk. Kɨtɨumbi, ");
INSERT INTO nif_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Yesulɨ Petlo manda ñɨn nɨñguk wɨn nandɨ-sɨwɨkuk, “Puputtɨ gama nɨm kɨtɨñɨlɨmbi, dɨk nain tɨpet gɨt no ‘Nak en nɨm nandɨñmɨlet’ eutañ.” Wɨn nandɨ-sɨwɨpi, pawan pɨ ñambi, sɨmba gawat wopum tɨmbi kukuk. ");
INSERT INTO nif_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kwet salaumbi, tapma ama biesɨ gɨtɨk gɨta Juda amalok ama biesɨ endɨ Yesu wɨlɨ kɨmbektok e-sambat tɨm, ");
INSERT INTO nif_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yesu toalɨ top nañgɨp ñambi, Pilato wɨn Roma amalɨ Judia distrik ka-dɨkñeuktok nɨmbɨ taleñgɨlɨñ endok kiinan kɨmɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas Yesu bola tɨñmɨñguk endɨ ama biesɨlɨ Yesu manda plon kɨmɨpi, wɨlɨ kɨmbektok eu taleñgɨlɨñ wɨn yambɨñguk. Yambɨmbi, nepek tɨñguk wala nandum mɨlataumbi, mɨnem kwandai satnin 30 tapma ama biesɨ gɨta ama biesɨ dɨwɨn endɨ mɨñgɨlɨñ wɨn epbi, bɨndambo tambane emepi ñañguk. Ñam tombi ");
INSERT INTO nif_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","enguk, “Nak yom tɨmbi, ama yomɨn nɨmnat sɨndok kɨsɨnan kɨmɨlatta tɨmbi en ip wɨlɨ kɨmnepi tañ.” Wɨndɨñ eumbi nɨñgɨlɨñ, “Wɨn nɨndok nepek nɨm. Wɨn dɨtnalok nepek yañ.” ");
INSERT INTO nif_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wɨndɨñ eumbi, Judaslɨ mɨnem kwandai satnin wɨn tapma it sañ jimba gɨnañ kolɨ pɨumbi, en walinin pɨm ñambi, toa topmbi kɨmguk. ");
INSERT INTO nif_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Tɨmbi tapma ama biesɨlɨ Judaslɨ mɨnem kolɨ pɨñguk wɨn gamapi eñgɨlɨñ, “Mɨnem ñɨn ama wɨlɨ kɨmbetak endok wekailok tuan. Tapma ittok mɨnem gɨt yousɨnetamɨñda, endɨkñe manda maklenetamɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wala tɨmbi endɨ manda e-topmbi, mɨnem walɨ ama no kwet kambot pa tɨlɨñguk endok kwet no tuambi, ama mayañgan nasi nindɨ Jelusalem pap sembɨnekalɨñ endok amasum palektok eu taleñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Endɨ kwet wɨn Yesu kɨmkɨmlok tuanlɨ tuañgɨlɨñda tɨmbi, amatamdɨ kwet wolok koi Kwet Wekaiat wɨndɨñ kɨtɨñgɨlɨñ, wɨn ñɨndɨñgɨt gamañgot pa kɨtañ. ");
INSERT INTO nif_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Tapma ama biesɨlɨ wɨndɨñ tɨñgɨlɨñ, wɨn plofet Jelemaialɨ indauktok eñguk wolok tuop indañguk. Endɨ Mesialok plon ñɨndɨñ embi youp biñguk patak, “Islael amalɨ mɨnem kwandai satnin 30 walɨñgot ama wɨn tuanep e-topmɨumbi, mɨnem walɨñgan epbi, kwet kambot tɨndɨ amalok kwet no tuañgɨlɨñ, wɨn Wopum Anutulɨ molo manda nanguk wolok tuopkan tɨñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tɨmbi Yesulɨ ka-dɨkñe ama Pilato endok damanan ilɨmbi, ka-dɨkñelɨ nɨ-nandɨmbi eñguk, “Juda ama endok Ama Wapmañ dɨk ñakan ba?” Wɨndɨñ eumbi nɨñguk, “Ip elañ wɨndɨñgan.” ");
INSERT INTO nif_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gan tapma ama biesɨ gɨt Juda ama biesɨ dɨwɨndɨ manda kusei kusei nɨ-youkɨlɨñ, wolonda Yesulɨ manda tambon no nɨm tambanem enguk. ");
INSERT INTO nif_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tɨmbi Pilatolɨ nɨ-nandɨmbi eñguk, “Manda gɨtɨk gep youpi eañ wɨn dɨk nɨm nandɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Gan endɨ man galɨ kwambɨñ dambi, nepek nola manda tambon no nɨm tambane nɨñguk. Wɨndɨñ tɨñgukta, Pilatolɨ sɨlɨkñembi, nandɨ-gɨtɨñgɨtɨkñe tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kamaikamai gwɨlat nain tuop ka-dɨkñelɨ ñɨndɨñ pa tɨñguk: endɨ amatam kɨmɨn wopum nandɨ-sembi, ama nolok koi kɨtɨañgɨlɨñ en wakan it kwambɨñ gɨnañ nanin pɨsat-semlɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nain wolonda ama kolan no koi gɨñgɨlat it kwambɨñ gɨnañ kɨmɨlɨm pakuk, koi Balabas. ");
INSERT INTO nif_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wɨndɨñda amatam asuptɨ kɨmɨn tɨ-taleumbi, Pilatolɨ enɨ-nandɨmbi eñguk, “Sɨndɨ ama ninda nak pɨsat-samettok eañ, Balabas ba Yesu Mesia nɨnɨn enda eañ?” ");
INSERT INTO nif_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kusei ñɨndɨñda endɨ wɨndɨñ eñguk: amatamdɨ Yesu ka-galkta tɨñgɨlɨñda tɨmbi, ama biesɨlɨ en ka-gimbɨt tɨñɨpi tɨkembi, ka-dɨkñelok kiinan kɨmɨlɨmbi, kusasɨ yambɨ-daklembi, wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Tɨmbi endok kusei no ñɨndɨñ: endɨ ama yambɨ-dan kena pa tɨlɨñguk wolok pipalɨñɨlɨmbi, tamɨnlɨ manda ñɨndɨñ kɨmɨlɨm endoñ loumbi eñguk, “Dɨk ama ñɨn kolan no nɨm tɨñguk wɨn biu palen. Nak tim en ip lat kolan plon kañbi, nandɨwam mɨlatak.” Pilatolok tamɨnlɨ wɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","gan tapma ama biesɨ ba Juda ama biesɨ dɨwɨn endɨ amatamda engɨlɨñ, “Sɨndɨ Pilatola ñɨndɨñ nɨnekalɨñ, ‘Dɨk Balabas kak bimbi, Yesu wɨwɨttok eukañ!’” Wɨndɨñ embi, enɨ-gɨñgɨneumbi, wolok tuop nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tɨmbi ka-dɨkñelɨ amatam nombo en-nandɨmbi eñguk, “Ama tɨpet endoññan nanin nin pɨsalɨmettok eañ?” Eumbi, “Balabas” nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Eumbi enguk, “Tɨmbi Yesu Mesia nɨnɨn enda nɨtek tɨñmetet?” Eumbi, gɨtɨkkandɨ kɨtɨmbi nɨñgɨlɨñ, “Kloñbat plon lowɨn!” ");
INSERT INTO nif_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tɨmbi Pilatolɨ enguk, “Nɨtekta? Endɨ kolan nek tɨñguk?” Eumbi, wopumgan kɨtɨmbi, nain asupgan ñɨndɨñ eñgɨlɨñ, “Kloñbat plon lowɨn! Kloñbat plon lowɨn!” ");
INSERT INTO nif_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wɨndɨñ tɨmbɨmbi, Pilatolɨ ka-nandɨñguk wɨn: en Yesu nepek no tɨñmɨlok tuop nɨm. Tombon amatamdɨ gimbɨt tɨmbi, mik tɨnepi tɨñgɨlɨñ. Wɨndɨñda Yesulok kɨmkɨm wɨn Pilatolok yomɨn nɨm indauktok endɨ ñɨndɨñ tɨñguk: endɨ Juda amalok ep tɨndɨñ no klembi, tukta eumbi, tuk tɨke bɨ mɨumbi, dausɨnan kii wɨlɨpi enguk, “Ama endok kɨmkɨmlok mɨlap walɨ nokok plon nɨm loukak, wɨn sɨnlok nepek.” ");
INSERT INTO nif_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Eumbi, amatam gɨtɨk endɨ manjɨ noñgan kɨtɨ kolɨ ñaumbi nɨñgɨlɨñ, “Kɨm wɨn nɨndɨ ba komblinnii nɨndok plon loukak!” ");
INSERT INTO nif_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tɨmbi Pilatolɨ amatamdok manda kɨmɨt-klembi, Balabas pɨsat-sembi, Yesu waipnelɨñdok eñguk. Eumbi, wɨndɨñ tɨmbɨ taleumbi, mik amalɨ kloñbat plon wɨtnelɨñdok kɨsɨnan kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tɨmbi ka-dɨkñelok mik amalɨ Yesu nañgɨp pɨmbi, ka-dɨkñelok ilan ñam nɨsɨ kuñgɨlɨñnan wandɨñ lombi, nosii gɨtɨk en gɨta kɨmɨn kokɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tɨñɨpi, Yesu enlok dasindasin kiundɨpi, mik amalok sauloñ gɨmɨn no dasi-mɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","toa pɨsɨkñat bondɨnembi, kumbam plon dasi-mɨmbi, toña no kii dɨndɨm kandañ kɨmɨlɨmɨñgɨlɨñ. Wɨndɨñ tɨñɨpi, ña mɨlelem tɨmbi, nɨ-lakalakae tɨ-ñɨmbi eñgɨlɨñ, “We, Juda amalok ama wapma!” ");
INSERT INTO nif_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Eñɨpi, iwɨt endok plon suambapi, toña lom tɨkembi, walɨñgan kumbam plon nombo nombo wɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nepek kusei kusei wɨndɨñ tɨñmɨ-talembi, mik amalok sauloñ kiundɨpi, enloñ dasindasin nombo dasi-mɨm pɨumbi, kloñbat plon wɨtnepi nañgɨp pɨ ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pɨ ñañɨpi, telak plon ama no Sailini nanin koi Simon ña tɨmbɨ indañgɨlɨñ. Tɨmbɨ indambi, en nɨ-gɨñgɨneum Yesulok kloñbat bembɨmbi ñañgɨlɨñ. Ñambi, ");
INSERT INTO nif_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","kwet no koi Golgata wandɨñ ña tomgɨlɨñ. (Kot walan ñɨndɨñ, ‘Kumba Kwandat Kwet’.) ");
INSERT INTO nif_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ña tombi, wain tuk gɨta gwasap kimbɨñ wakɨt ep kiukiulɨn wɨn tɨke mɨum na-nandɨmbi, kunjitam biñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tɨmbi kloñbat plon wɨlɨ taleumbi, dasindasin tɨkenepi satu sañala kopi, dasindasin danbi epgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wɨndɨñ tɨmbi, pipapi ka-dɨkñe-pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tɨmbi kumbam mindin plon kusei neta wɨkɨlɨñ wolok manda ñɨndɨñ youp kɨmɨkɨlɨñ, “Ñɨn Yesu, Juda amalok Ama Wapmañjɨ.” ");
INSERT INTO nif_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tɨmbi ama piñpiñen tɨpet en gɨta yakan yandɨpbi, no tombon no tombon ep mambɨ ikɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tɨmbi ama wandɨñ ñañambɨt tɨñgɨlɨñ endɨ Yesula kumbanjɨ dɨñguneñɨpi nɨ-suambapi ");
INSERT INTO nif_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","nɨñgɨlɨñ, “Nɨtekta? Dɨk tapma it wiapi, nain tɨpet gɨt no wolok gɨnañnangan tɨmbɨ kaitauktok eñguñ wɨn. Nɨtek tɨmbi dɨtnalok pɨñgɨpka nɨm tɨke-kɨmɨtañ? Dɨk Anutulok Nɨñañ sɨnɨkta, kloñbat plon nanin pɨ!” ");
INSERT INTO nif_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tɨmbi tapma ama biesɨ wakɨt endɨkñe nandɨ-tale ama ba Juda ama biesɨ dɨwɨn endɨ bo wɨndɨñgot nɨ-kolakola embi eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ama dɨwɨsɨ ikan ep kɨmɨkuk, gan enlok pɨñgɨu tɨke-kɨmɨlektok tuop nɨm. En Islael ama nɨndok ama wapmañ sɨnɨkta, kloñbat plon nanin pɨwɨn! Pɨwɨmek, endɨ Mesia bɨmbɨndok een ip wakan wɨn nandɨ-kɨlɨktɨ tɨñmɨnetamɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Endɨ Anutulok plon panjañganembi, endok Nɨñañ sɨnɨk wɨndɨñ elak. Tɨkap wɨndɨñda, papa kana: Anutulɨ tɨke-kɨmɨlektok nandɨlak ba nɨm.” ");
INSERT INTO nif_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ama piñdasɨ tɨpet Yesu gɨt yandɨpgɨlɨñ endɨ bo wɨndɨñgot nɨmbɨ kolañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kwet nain boñgɨp tɨmbɨmbi, kwet tuop kɨlɨm indañguk. Inda-palɨmbi ñakap, 3 kilok tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wolongan Yesulɨ wopumgan kɨtɨmbi eñguk, “Eli, Eli, lama sabaktani.” Wɨn ñɨndɨñ, “Anutuna, Anutuna, nekta nambilañ?” ");
INSERT INTO nif_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tɨmbi wandɨñ pakɨlɨñ endoññan nanin dɨwɨndɨ manda wɨn nandɨmbi eñgɨlɨñ, “Endɨ plofet Elia kɨtɨñmɨlak.” ");
INSERT INTO nif_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Wolongan mik ama nolɨ woñep ñambi, nepek busukñanen walɨ tuk kɨndem tiañewɨk no tɨke bɨmbi, wain tuk kimbɨñ gɨnañ wɨsɨmbi, komba bem kusip plon topbi, Yesulɨ nanalok mɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gan dɨwɨsɨlɨ eñgɨlɨñ, “Biukɨn, Elialɨ tɨke-kɨmɨlepi bɨutak bek, wɨn kañmek.” ");
INSERT INTO nif_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tɨmbi Yesulɨ nombo wopumgan kɨtɨmbi, engan kɨmɨt nandum, woñ poñaumbi kɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Wolongan nepek ñɨndɨñ indañguk: tapma ilan sandum masipmasip wopum tɨñgɨlɨñ wɨn boñgɨpgan tawam blañganembi, gwat nanin pɨ lap taleñguk, tɨmbi kwet mɨnjat mɨnjat tɨmbɨmbi, kawat jɨñgɨn dɨwɨn tawa pɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Tɨmbi sumlok yama pɨsalɨmbi, Anutulok gɨñgɨt damañgan kɨm-taleñgɨlɨñ asuptɨ mɨlapi, ");
INSERT INTO nif_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","sumjɨ biñgɨlɨñ. Bimbi, Yesulɨ kɨmnan nanin mɨlalɨmbi, wolonda endɨ Anutulok it kwet dɨndɨm engano, wɨn Jelusalem, wandɨñ lombi, amatam asuptoñ inda-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mik amalok telak dama gɨt amañii Yesu ka-dɨkñe-pakɨlɨñ endɨ mɨnjamɨnjat ba nepek kusei kusei indañguk wɨn kañgɨlɨñ endɨ kolan mɨsɨmbi eñgɨlɨñ, “Biañganak. Ñɨne Anutulok Nɨñañ sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Yesulɨ Galili distrik nanin Jelusalem bɨñguknan tam asuptɨ en gɨta yakan bɨmbi, tɨmbɨ plata pa tɨ-ta-kuñgɨlɨñ. Yesu wɨlɨ kɨmguk sandap wolondañgan endɨ bo Golgata bɨ pakɨlɨñ, gan endɨ mayañgan ipi, dei posnembi kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Wɨn endoñ nanin no koi Malia Makdala nanin. Tɨmbi Malia no, Jekop gɨt Josep endok menjet. Tɨm no wɨn Sebedilok nɨñañiit endok menjet. ");
INSERT INTO nif_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ama mɨnemmat no Alimatia nanin endɨ bo Yesulok gwañgwa no, koi Josep. Maim pɨup tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","endɨ Pilatoloñ ñambi, Yesulok dalandanda eñguk. Eumbi, Pilatolɨ nandɨñmɨmbi, tɨke mɨnelɨñdok enguk. Eumbi, wolok tuop mɨumbi tɨkeñguk. ");
INSERT INTO nif_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tɨkembi, sandum satnin bamblum nɨmnat walɨ tɨmɨpi, ");
INSERT INTO nif_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","tɨke ñambi, enlok sum gɨnañnan kɨmɨkuk. Sum wɨn komblin sɨnɨk, kawat gɨnañ wɨn Josep enlok kulup bimbin. Joseptɨ Yesulok dalandan wolok kɨmɨpi, kawat wopum no munjulɨm bɨ yama masipmɨñguk. Wɨndɨñ tɨ-talembi, walinin pɨ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Joseptɨ dalandan sumnan kɨmɨlɨñɨlɨmbi, Malia Makdala nanin en gɨta Malia no endɨ sum dat kandañ pipapi ka-tuakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kwet salaum Sabat patnandɨ nain tɨmbɨmbi, tapma ama biesɨ gɨt Falisi ama endɨ yakan Pilatoloñ ñam ");
INSERT INTO nif_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","nɨmbi, Yesulok plon ñɨndɨñ eñgɨlɨñ, “Ama wopum, nɨndɨ ama julunjuluñdok walɨ gama kaik kuñɨpi, manda no eñguk wɨn nandɨna sɨwɨtak. Endɨ ñɨndɨñ eñguk, ‘Nain tɨpet gɨt no ñaumek, kɨmnan nanin mɨlaletat.’ ");
INSERT INTO nif_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wala tɨmbi dɨk eumbi, sum wɨn ka-dɨkñe-kɨliñ e-palɨmbi, nain tɨpet gɨt no wɨn taleukak. Nɨm kañbi, gwañgwañiilɨ ña dalandan kumbu tɨm tɨke ñambi, amatamda juluñgan ñɨndɨñ enɨnelɨñ a, ‘Yesu en ip kɨmnan nanin mɨlakuk.’ Wɨndɨñ enelɨñda, juluñɨt manda komblin walɨ Yesulɨ juluñɨt manda eñguk wɨn maklewɨk.” ");
INSERT INTO nif_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eumbi, Pilatolɨ nandɨ-sembi enguk, “Kɨndem a. Sɨndɨ mik ama dɨwɨn epmbi, sumnan yanañgɨp ñaum, sum masip kwambɨñ danelɨñdok nɨtek tɨnep nandañ wolok tuop tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wɨndɨñ eumbi, sumnan ñam, sum masip kwambɨñ danelɨñdok kawattɨ sum dai masipmɨñguk wolok plon nɨsɨlok kɨmɨsip no kɨmɨpi, ka-dɨkñe nelɨñdok mik ama wandɨñ yambium pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat patnandɨ nain taleumbi, kena nain kusei kɨmɨkɨmɨlɨnan kwet salawa salawa tɨmbɨmbi, Malia Makdala nanin gɨt Malia nolɨ endɨ Yesulok sum kandepi ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tɨmbi platik sɨnɨk kwet mɨnjamɨnjat wopum sɨnɨk mɨnjalɨmbi, wolonda Wopumdok añelo nolɨ kunum gɨnañ nanin pɨmbi, kawat sum masipmɨñguk wɨn manjaneum ñaumbi, kawat wolok plon pipakuk. ");
INSERT INTO nif_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Endok walan wɨn pɨsapɨsat walalan wandin, tɨmbi dasindasin wɨn satnin sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Tɨmbi ama sum ka-dɨkñe-pakɨlɨñ endɨ en kañbi, kolan mɨsɨñgɨlɨñda tɨmbi kɨsɨ kesɨsɨ blañblañ tɨmbɨmbi, amalɨ kɨmañ wandin kwelan pɨ pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tɨmbi añelolɨ tam tɨpetta enguk, “Nɨm mɨsɨndemɨk. Nak nandɨlet sɨtɨ Yesu kloñbat plon wɨkɨlɨñ en kandepi bamɨk. ");
INSERT INTO nif_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Gan endɨ ñɨ nɨm patak. Endɨ damañgan manda sanguk wolok tuop Anutulɨ tɨmbɨ mɨlalak. Kwel kɨnjangot ñɨ bɨ kawɨt. ");
INSERT INTO nif_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tɨmbi sɨtɨ plapkan ñambi, gwañgwañiila ñɨndɨñ enbɨt, ‘Endɨ kɨmnan nanin ikan mɨlalak, man ñɨndɨñgɨt dama Galili kwelan ñaumbi, sɨndɨ wandɨñ ña kanekalɨñ.’ Manda ip wakan sanlet.” ");
INSERT INTO nif_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wɨndɨñ eumbi, endɨ mɨsɨñgɨmɨk, gan sɨlɨsɨlɨ wopumdɨ gɨnañjet gɨnañ tokñeumbi, platikan sum bimbi, gɨñgɨt manda gwañgwañiila endepi woñep ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ñañɨlɨmbi, platik sɨnɨk Yesulɨ ep tɨmbɨ indam we semumbi, endɨ endoñ kesɨnan ña mɨlelem tɨmbi, tɨke-kañɨpi nɨ-wowoñe tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Tɨmbi Yesulɨ enguk, “Nɨm mɨsɨndemɨk, ña notnai Galili ñanelɨñdok enbɨmbi, wandɨñ ñam nambɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tam tɨpet endɨ gwañgwañiiloñ ñañɨlɨmbi, mik ama sum ka-dɨkñeñgɨlɨñ endoññan nanin dɨwɨndɨ it kwelan undane ñambi, nepek gɨtɨk sumnan indañguk wolok kasat wɨn tapma ama biesɨla tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Tɨmbi tapma ama biesɨlɨ Juda ama biesɨ dɨwɨn en gɨta kɨmɨn tɨmbi, ñɨndɨñ tɨnelɨñdok e-topbi, wolok tuop tɨñgɨlɨñ: endɨ mɨnem asupgan mik amala embi ");
INSERT INTO nif_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","engɨlɨñ, “Sɨndɨ amatamda ñɨndɨñ enɨnekalɨñ, ‘Nɨndɨ dou-patnambi, gwañgwañiilɨ tim bɨmbi, dalandan kumbu tɨkembi ñalɨñ.’ Wɨndɨñ enekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tɨkap manda wɨn Pilatolok pawan gɨnañ pɨukta, nɨndɨ mek ñam kambi, nepek ñɨn tɨ-dɨndɨm enambi, mɨlap no nɨm inda-samekak.” ");
INSERT INTO nif_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Eumbi, mik amalɨ mɨnem wopum wɨn ep ñambi, ama biesɨlɨ manda eñgɨlɨñ wolok tuop tɨñgɨlɨñ. Tɨmbi manda walɨ Juda amatamdok boñgɨpsɨnan eu sapakñe-tɨke-bɨñguk. ");
INSERT INTO nif_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Tɨmbi Yesulok gwañgwañii 11 endɨ Galili distrik ñambi, damañgan endɨ molo manda no enguk kwet jañgɨn wolok loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Loumbi, Yesulɨ wandɨñgan inda-semum kañbi mɨlelem tɨñmɨñgɨlɨñ. Gan dɨwɨsɨlɨ “Yesu en kamɨñ ba?” embi, gɨnañ tɨpet tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tɨmbi Yesulɨ gwañgwañiiloñ ñasɨñgan ñambi enguk, “Bep Anutulɨ kunum kwet yambɨ-dɨkñeuttok gembɨ gɨtɨk wɨn naka nam-taleñguk. ");
INSERT INTO nif_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wala tɨmbi sɨndɨ kwet tuop ñambi, amatam gɨtɨk nokok gwañgwanai ep tɨmbɨ indanekalɨñ, wɨn Bep, Nɨñañ gɨt Dɨndɨm Woñ endok kosɨ plon yatnañ tuk i-sembi, ");
INSERT INTO nif_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","endɨkñe manda san-daut tɨ-sam-kuñgut wɨn gɨtɨk enɨ-daut tɨ-semumbi tañgone-talenekalɨñ. Nandañ: nak nain tuop sɨn gɨta ku-ta-ñawambi, kwettok nain taleukak wolok tuop.” ");
INSERT INTO nif_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Yesu endɨ Mesia, Yambattok nɨñañ. Gɨñgɨt manda kɨndem endok plon ñɨndɨñ kusei kɨmɨtak. ");
INSERT INTO nif_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Manda no Yambattɨ Mesiala nɨñguk wɨn plofet Aisaialɨ ñɨndɨñ youp biñguk patak, “Nandɨlañ! Nak tɨplaplatna no kɨmɨlam ñambi, dɨkok telak dama tɨmbi, telak tɨ-dɨndɨm e-gamekak. ");
INSERT INTO nif_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ama no kwet ama nɨmnatnan ñɨndɨñ kɨtɨ-kolɨ ñalak, ‘Wopumdok telak tɨ-dɨndɨm tɨ-ñɨmɨt! Telak kelam tɨ-dɨndɨm tɨ-ñɨmnekalɨñ!’” ");
INSERT INTO nif_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tɨmbi manda wolok tuop ama no miti tuk i-sem-i-sem tɨñguk, koi Yoane, endɨ kwet ama nɨmnatnan ña-indañguk. Indambi, ñɨndɨñ eu pɨumbi enɨ-ta-kuñguk, “Sɨndɨ gɨnanjɨ tambanembi, kuñgu kolan bi-talembi, miti tuk inekalɨñ. Wolondamek Yambattɨ yomjɨ bi-samekak.” ");
INSERT INTO nif_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tɨmbi amatam Judia kwelan ba Jelusalem it kwelan pakɨlɨñ endɨ gɨtɨkkandɨ isɨ kwesɨ bimbi, Yoaneloñ ña indambi, yomjɨ e-jamilaumbi, Joldan tuk gɨnañ miti tuk i-sem-ta-kuñguk. ");
INSERT INTO nif_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoanelok dasindasin wɨn plofet amalok dasindasinjɨ wandiñ, wɨn kamel domdɨ tɨndɨn, tɨmbi endɨ boñgɨunan bɨt gwɨlaptɨ tem kulɨñguk. Nanañ tuk wɨn gotak gɨt bupit mɨnjɨp tuk koñgom kli gɨnañ nanin na-kulɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tɨmbi endɨ ñɨndɨñ eu pɨumbi, amatam enɨ-ta-kuñguk, “Ama no nokok siñgina kandañ indaup tɨlak endɨ nak nomɨk nɨm, endɨ ama loloñ sɨnɨk. Ama pɨmbɨñen, nak kambak ñandin ñalɨ nepek no tuop nɨm tɨ-ñɨmet. ");
INSERT INTO nif_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nak tuk sɨlaningot i-sam-ta-kulet, gan endɨ Dɨndɨm Yallɨ i-samekak.” ");
INSERT INTO nif_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yoanelɨ kena kusei kɨmɨlɨñɨlɨmbi, Yesulɨ Nasalet it kwet Galili provins gɨnañ pakuk. Pakapi, il kusei bimbi, Joldan tuknan ña-tombɨmbi, Yoanelɨ tuk i-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tuk i-ñɨm-taleumbi, Yesulɨ tuk pawañ loñɨpi dei loumbi kañguk wɨn: kunum pɨsalɨmbi, Dɨndɨm Yallɨ monɨk koi mambaip wandiñ walɨ endok plon pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pɨñɨlɨmbi, kunum gɨnañ nanin manda no ñɨndɨñ kɨtɨu pɨñguk, “Dɨk nɨñana noñgan sɨnɨk. Nak gambɨ-galk tambi, nandɨ-koñgom tɨ-gamlet.” ");
INSERT INTO nif_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tɨmbi wolondañgan Dɨndɨm Yallɨ Yesu kwet sɨlaninnan nɨ-mulɨmbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Kwet wandɨñ ama nɨmnat, gaut moyendɨñgot kuñgɨlɨñ. Yesulɨ wandɨñ ñambi, tim sandap 40 pakuk. Palɨñɨlɨmbi, Satañdɨ endoñ bɨmbi, tue-kañbi tɨ-ñɨm-ta-ku wɨt nɨm kañbi bim ñañguk. Tɨmbi añelolɨ bɨmbi, Yesu tɨmbɨ platañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yoane it kwambɨñ gɨnañ kɨmɨkɨlɨñ wolok siñgi kandañ Yesulɨ Galili kwelan undane-ñambi, Yambattok gɨñgɨt manda kɨndem eu pɨumbi, ");
INSERT INTO nif_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ñɨndɨñ enɨ-ta-ñañguk, “Yambattɨ nain wopum amatamñii yambɨ-dɨkñeuktok kɨmɨkuk. Nain wɨn ip indalak, wala tɨmbi sɨndɨ gɨnanjɨ tambanembi, kuñgu kolan bimbi, gɨñgɨt manda kɨndem ñɨn nandɨ-kwambɨñ danekalɨñ!” ");
INSERT INTO nif_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tɨmbi Yesulɨ Galili tuk guañ baliliñ ñañɨpi, Simon gɨt kwayañ Andlu yambɨñguk: endɨ tuk guañ gɨnañ ipi, pis lɨk molom molom kop tiañe tɨñgɨmɨk. Pis epep kena wɨn endok mɨnemjet kena wakan. ");
INSERT INTO nif_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesulɨ yambɨmbi kɨtɨ-sembi eñguk, “Sɨtɨ bɨwɨt!” embi enguk, “Sɨtɨ pis epep kena tɨ-ta-bamɨk. Kena wɨn bimbi bɨm, nak nep kle-kuumek, nak sep tɨmba pañgɨtaumbi, Yambattok amatam epep kena tɨ-kundekamɨk.” ");
INSERT INTO nif_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Enbɨmbi, platik sɨnɨk pis ba pislɨk bimbi, wolongan kusei kɨmɨpi, Yesu kle-ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tɨmbi Yesulɨ kambak jɨlop ñañɨpi, dakwaya tɨpet, Sebedilok nɨñañiit Yakobo gɨt Yoane, yambɨñguk: endɨ nosiit gɨta kɨkeñ plon papi, pis lɨk wopumjɨ tɨ-dɨndɨm e kena tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Yesulɨ yambɨmbi, wolongan en kle-kundemɨktok kɨtɨ-semumbi, beset Sebedi gɨt kena gwañgwañii kɨkeñ plon yambimbi, Yesu kle-ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tɨmbi Yesulɨ gwañgwañii gɨt Kapaneam it kwelan ña-kuñguk. Tɨmbi Sabat patnandɨ nain indaumbi, it kiyau gɨnañ lombi, kusei kɨmɨpi, amatamda enɨ-daut tɨ-sembi, nanandɨ emguk. ");
INSERT INTO nif_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Endɨ endɨkñe manda nandɨ-tale amalɨ enɨ-daut tɨ-semmañgɨlɨñ wɨndɨñ nɨm tɨñguk. Endɨ ama kosɨ gɨñgɨlat nomɨk manda gembɨnat sɨnɨk eñguk, wala tɨmbi amatam mandan nandɨñgɨlɨñ endɨ nandɨ-sɨlɨkñe-tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tɨmbi ama no yal kolannat it kiyau gɨnan pakuk ");
INSERT INTO nif_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","endɨ Yesula kɨtɨ-ñɨmbi eñguk, “Yesu Nasalet nanin, dɨk nekta nɨndok kandañ bɨñ? Dɨk nɨp tɨmbɨ kolaneñdok bɨñ ba? Nak dɨk nandɨ-gamlet: dɨk ama dɨndɨm Yambattoñ nanin.” ");
INSERT INTO nif_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wɨndɨñ eumbi, Yesulɨ yal kolan nɨ-ñombɨmbi nɨñguk, “Mañga galɨmbi, ama ñɨn kañbimbi poñau!” ");
INSERT INTO nif_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nɨmbɨmbi, yal kolandɨ ama mɨnjamɨnjat tɨñɨpi, kwawa wopumgan tɨmbi, amalok gɨnañ nanin ka-mɨsɨm poñañguk. ");
INSERT INTO nif_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wɨndɨñ tɨmbɨmbi, amatam gɨtɨktɨ ka-sɨlɨkñembi mɨsɨñɨpi, nɨsɨñgan ñɨndɨñ e-nandɨ-tɨñgɨlɨñ, “Nepek nek ñandin indalak? Nandɨnandɨ ñɨn gɨtikñin ba gembɨnat bien! Endɨ yal kolan wakɨt manda kwambɨm enbɨmbi, mandan nandɨmbi tañgoneañ.” ");
INSERT INTO nif_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tɨmbi Yesulok koi gɨñgɨt platik sɨnɨk Galili kwet tuop eu satañguk. ");
INSERT INTO nif_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tɨmbi Yesu gɨt gwañgwañii endɨ it kiyau bimbi, pawañ pɨ-ñañgɨlɨñ. Pɨ-ñaumbi, wolongan Simon gɨt Andlu endɨ Yesu, Yakobo gɨt Yoane yanañgɨlɨm ñambi, isetnan loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Lo-tombɨmbi Yesu nɨñgɨlɨñ, “Simon yapman tam jɨmbat pɨñgɨu kunduwat sɨnɨk walɨ tɨkeumbi dou-patak.” Wɨndɨñ nɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","endoñ ñañguk. Ñambi, kii plon tɨkem tɨmbɨm mɨlalɨmbi, jɨmbalɨ wolongan taleumbi, nana tuk emguk. ");
INSERT INTO nif_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tɨmbi maim daut pɨ-sembumbi, patnandɨ nain taleumbi, amatam jɨmbasɨat gɨt ama yal kolanjɨat gɨtɨk Yesuloñ yousɨyousɨñgan yanañgɨpi bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Tɨmbi Kapaneam nasɨ gɨtɨkkandɨ it yamanan kɨmɨn tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Tɨmbi Yesulɨ amatam jɨmbat kusei kuseilɨ ep mɨñguk asupgan ep tɨmbɨ kɨndem daumbi, yal kolan wakɨt kle-kot-semguk. Wɨndɨñ tɨmbɨmbi, yal endɨ en nin wɨn nandɨ-dakle-ñɨmumbi, manda nɨm enelɨñdok e-kɨmɨsip tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tɨmbi Yesulɨ kɨlɨm mulum gɨnañ mɨlapi, kwet ama nɨmnatnan pɨ-ñambi, wandɨñ nɨmolo tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Nɨmolo tɨ-palɨmbi, Simon gɨta noliilɨ mɨlapi, Yesu lonjɨmbi, lonjɨ-ta-ñakap ");
INSERT INTO nif_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","tɨmbɨ indaumbi nɨñgɨlɨñ, “Kapaneam amatam gɨtɨktɨ gambɨne eñɨpi gep lonjɨañ!” ");
INSERT INTO nif_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nɨmbɨmbi enguk, “Nandɨlet. Gan nak gɨñgɨt manda kɨndem ewa pɨuptok sɨnɨk indañgut, wala tɨmbi it kwet dɨwɨn ñasɨñgan pakañ wandɨñ ñana.” ");
INSERT INTO nif_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wɨndɨñ embi, Galili kwet tuop kuñɨpi, it kiyausɨ gɨnañ gɨñgɨt manda enɨenɨ kena tɨñɨpi, yal kolan wakɨt ep kle-kot-tɨ-sem-ta-kuñguk. ");
INSERT INTO nif_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tɨmbi ama no wanda kwambɨñnat endɨ Yesuloñ bɨmbi kakukule-eñɨpi, mɨlelem tɨ-ñɨmbi, kumbam dɨñgunembi nɨñguk, “Tɨkap dɨk nep tɨmbɨ kɨndem dawɨttok nandɨlañda, dɨk tuop.” ");
INSERT INTO nif_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Eumbi, Yesulɨ enda blan wopum tɨ-ñɨmbi, kii kosuap tɨkeñɨpi nɨñguk, “Nak nandɨ-gamlet, dɨk nombo kɨndem da!” ");
INSERT INTO nif_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Nɨmbɨmbi, platik sɨnɨk wandan kwambɨñ pailɨmbi, kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Tɨmbi Yesulɨ nɨ-kɨmɨsip kwambɨñ tɨ-ñɨmbi nɨñguk, “Nandɨlañ. Dɨk nimbek nola nepek inda-gamɨk wolok kasat joñgo nɨm enbekañ. Nɨm sɨnɨk. Dɨk ñambi, pɨñgɨpka tapma ama daulɨmɨumbi, kɨndem dañ wɨn gambɨ-nandukak. Tɨmbi Moselɨ endɨkñe manda eñguk wolok tuop dɨk tapma tɨmbɨmbi, amatam gɨtɨktɨ jɨmbatka talelak wɨn gambɨ-nandɨnekalɨñ.” Yesulɨ manda wɨndɨñ embi, dɨndɨmgan nɨ-mulɨmbi ");
INSERT INTO nif_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ñañguk. Gan endɨ kusei kɨmɨpi, kundit nek endok plon inda-ñɨmɨñguk wolok kasat amatamda tɨ-sem-ta-kuñɨpi eu satañguk. Wɨndɨñda tɨmbi Yesulɨ it kwelan indañgan ñañala nandum mɨlataumbi, kwet ama nɨmnatnan ña-pakuk. Ña-palɨñɨlɨmbi, amatam kwet tuop endoñ bɨ-teleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sandap dɨwɨn taleumbi, Yesulɨ bɨndambo Kapaneam it kwelan ña-tomguk. Tɨmbi amatam dɨwɨndɨ “Endɨ bɨk, ilan patak” eu sataumbi, ");
INSERT INTO nif_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","amatam asupgandɨ endoñ bɨñgɨlɨñ. Bɨmbi, it gɨnañ lo-pilɨ tokñeumbi, yamanan wakɨt pipap masip mɨumbi, gɨñgɨt manda enguk. ");
INSERT INTO nif_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Gɨñgɨt eñɨlɨmbi, ama dɨwɨn nolɨ endoñ bɨñgɨlɨñ, endoñnan nanin ama tɨpet gɨt tɨpet endɨ nosɨ no kii kesi dalandan tañgo plon bembi bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bɨmbi, Yesulok kuañ kuseinan kɨmɨtnelɨñdok ama kɨmɨn gɨnañ ñam wɨt nɨm kañbi, it pendɨm bat plon loñgɨlɨñ. Lombi, Yesulok kumbamnan kandañ pendɨm gɨnañ tɨmbi tombɨmbi, ama kii kesi dalandandok tañgo plon toalɨ topbi, it pendɨm plon nanin kɨmɨlɨm pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wɨndɨñ tɨmbɨmbi, Yesulɨ nanandɨ kɨlɨktɨnjɨlok kusei ka-nandɨ-tombi, ama kii kesi dalandanla nɨmbi eñguk, “Notna, yomga bi-gamlet.” ");
INSERT INTO nif_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Tɨmbi endɨkñe manda nandɨ-tale ama dɨwɨn wɨñgan pipakɨlɨñ endɨ gɨnanjɨ gɨnañ ñɨndɨñ kɨmɨt-nandɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nekta ama sɨlanin ñalɨ ‘Yomga bi-gamlet’ embi, Yambat nɨ-tɨke-pɨ-yalilak? Yom bimbilok gembɨ wɨn Yambattoñgot palɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Wɨndɨñ kɨmɨt-nandɨñɨlɨmbi, Yesulɨ wɨ ipkan gɨnañlɨ yambɨ-nandɨ-daklembi enguk, “Gɨnanjɨlɨ neta wɨndɨñ nandɨ-kunakunaeañ? ");
INSERT INTO nif_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tɨkap nak ama ñala ‘Mɨlapi, ipatka tɨkembi ñau!’ nɨmbambi, kɨndem dawɨkta, nak ‘Yom bi-gamlet’ nɨt walɨ wɨndɨñgot kɨndem indañmek. ");
INSERT INTO nif_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wɨndɨñda kwelan ñolok yom bimbilok gembɨ wɨn Ama Sɨsɨnɨktoñ palmɨlak wɨn daut samettok ");
INSERT INTO nif_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","nak ama kii kesi dalandan ñala ñɨndɨñ nɨlet, ‘Mɨlapi, ipatka tɨkembi, ikanan ñau!’” ");
INSERT INTO nif_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Yesulɨ wɨndɨñ nɨmbɨmbi, ama walɨ mɨlapi, wolongan ipal tɨkembi, amatam dausɨnangan poñañguk. Tɨmbi amatam gɨtɨktɨ ka-gɨtɨp gɨtɨp tɨmbi, Yambat nɨ-kɨndem dambi eñgɨlɨñ, “Nepek ñandin damañgan no nɨm kañgɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tɨmbi Yesulɨ bɨndambo tuk guañ baliliñnan pɨ-ñañguk. Ñaumbi, amatam kɨmɨn wopumgandɨ endoñ bɨumbi enɨ-daut tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Tɨmbi walinin yousɨm ñañɨpi, Alifaialok nɨñañ Livailɨ takis epep ilan pipalɨmbi kañbi nɨñguk, “Bɨm nep kle-ku!” Nɨmbɨmbi, kenan bimbi mɨlapi, kusei kɨmɨpi kle-ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Tɨmbi Livailɨ Yesu nɨ-tiañeum ilnan loumbi, nana towiñguk. Tɨmbi takis epep ama gɨta ama endɨkñe manda nɨm kɨmɨt-kle-kɨliñ eañ (ama wandisɨ asupgandɨ Yesu kleñgɨlɨñ) endɨ bo Yesu gɨt gwañgwañii en gɨta lombi, nana yakan nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tɨmbi Falisi ama endok boñgɨpsɨnan nanin endɨkñe manda nandɨ-tale ama dɨwɨn endɨ Yesu en gɨta pipapi, nana nambɨmbi kañbi, nandu mɨlataumbi, gwañgwañiila enbi eñgɨlɨñ, “En neta takis epep ama ba ama endɨkñe manda nɨm kɨmɨt-kle-kɨliñ eañ en gɨta papi, nana nalak?” ");
INSERT INTO nif_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eumbi, Yesulɨ manda wɨn nandɨmbi, ñɨndɨñ enbi eñguk, “Kɨndemsɨ endɨ gwasap amaloñ sɨlakan nɨm ñañ. Wɨn jɨmbasɨat endɨñgot gwasap amaloñ ñañ. Wɨndɨñgangot nak ama dɨndɨm enda nɨm bɨñgut. Nɨm a. Nak ama yomsɨat enɨ-tiañeupi bɨñgut.” ");
INSERT INTO nif_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Tɨmbi nain nola Yoane tuk i-sem-i-sem kena tɨñguk endok gwañgwañii gɨt Falisi ama endɨ sosɨlok telak kleñɨpi, nana gɨtɨk kɨmɨsip tɨñgɨlɨñ. Tɨñɨlɨmbi, ama dɨwɨn endɨ Yesuloñ bɨmbi nɨ-kañbi eñgɨlɨñ, “Yoanelok gwañgwañii ba Falisi ama endok gwañgwanjii endɨ nana kɨmɨsip tɨmbɨmbi, neta dɨkok gwañgwañgailɨ wɨndɨñ nɨm tañ?” ");
INSERT INTO nif_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nɨ-nandumbi, Yesulɨ enlok ba gwañgwañiilok plon ñɨndɨñ embi enguk, “Tɨkap ama nolɨ tam tɨmbektok nana sina wopum tɨmbɨmbi, nolii kɨtɨ-semum bɨñgɨlɨñ endɨ kɨndem nana kɨmɨsip tɨnelɨñ ba? Nɨm a. Ama walɨ nolii gɨta palɨñɨlɨmbi, nana kɨmɨsip kɨndem nɨm tɨnelɨñ. ");
INSERT INTO nif_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gan nain wɨn indaumbi, ama enɨ-tiañeñguk en noliilok boñgɨpsɨnan nanin yapma tɨke-ñaumbi, wolondamek noliilɨ nana kɨmɨsip tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesulɨ wɨndɨñ embi, sosɨloñ telak gɨt enloñ telak wolok eyout manda tɨpet embi, ñɨndɨñ enguk, “Nimbek nolɨ dasindasi damanin dɨkñendɨkñen plon sandum kusip komblin nɨm kɨmɨt takapbi youlek. Wɨndɨñ tɨmbekta, kaik walɨ damanin tiañeumbi blañganeumbi, gɨnañ wopumgan sɨnɨk indauk. ");
INSERT INTO nif_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tɨmbi bo wain tul komblin wain gwɨlap kawai gɨnañ nɨm wɨlɨ gɨlowɨk. Wɨndɨñ tɨmbekta, tullɨ bendɨ-wopum dambi, gwɨlap tɨmbɨ tawaumbi, tul gɨta gwɨlap kolandemɨk. Wala tɨmbi wain tul komblin wɨn gwɨlap komblin gɨnañ wɨlɨ gɨlolok.” ");
INSERT INTO nif_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tɨmbi Sabat patnandɨ nain nola Yesulɨ plaua kena boñgɨp dɨkñe-ñaupi ñaumbi, gwañgwañiilɨ en kle-ñañgɨlɨñ. Ñañɨpi, kusei kɨmɨpi, plaua mɨnjɨp met-nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Tɨmbi Falisi amalɨ yambɨmbi, Yesu nɨmbi eñgɨlɨñ, “Wɨ ka! Neta endɨ kɨmɨsip manda maklembi, patnandɨ nainda kena tañ?” ");
INSERT INTO nif_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Eumbi tambane-enguk, “Nain wolonda Abiatalɨ tapma amalok telak damanjɨ palɨñɨlɨmbi, Devit gɨt amañii nananjɨla gawat tɨ-palɨmbi, Devittɨ nɨtek tɨñguk? Sɨndɨ kasat wɨn nɨm pinat-nandɨñgɨlɨñ bek? Devit endɨ Yambattok it gɨnañ lombi, plaua Yambatta mɨmɨn mepi nañguk. Plaua wɨn tapma amalɨñgot nanalok, gan Devittɨ kɨmɨsip manda maklembi, plaua nañbi, noliila bo mep emumbi nañgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yesulɨ wɨndɨñ embi enɨ-daklembi eñguk, “Yambattɨ ama Sabatta tɨmbi nɨm tɨmbɨ indañguk. Nɨm sɨnɨk. Endɨ Sabat patnandɨ nain wɨn amatam ep tɨmbɨ pañgɨtanelɨñdok kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wala tɨmbi nak, Ama Sɨsɨnɨktɨ, amatamdɨ Sabat patnandɨ nainda nek nek kɨndem tɨndɨlok ewa talelak.” ");
INSERT INTO nif_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Tɨmbi Sabat patnandɨ nain nola Yesulɨ bɨndambo it kiyau gɨnañ loumbi, ama kii dalandan nolɨ wolok pipakuk. ");
INSERT INTO nif_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Palɨmbi, Yesulok kanjɨkñii endɨ Yesu manda plon kɨmɨtnelɨñdok nandɨñgɨlɨñ, wala tɨmbi endɨ Yesu Sabattok sambat kleñɨpi, ama wɨn kañbiutak, ba kɨmɨsip makleñɨpi, ama wɨn tɨmbɨ kɨndem dautak wala ka-tuakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Wɨndɨñ ka-tualɨñɨlɨmbi, Yesulɨ ama kii dalandan nɨ-tiañembi nɨñguk, “Mɨlapi indangan it!” Wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Falisi amala enɨ-kañbi eñguk, “Sabattok endɨkñe manda walɨ nɨtek elak? Patnandɨ nainda kɨndem ba kolan tɨlok, ama ep tɨmbɨ kɨndem dalok ba ep tɨmbɨ kɨmlok?” Yesulɨ wɨndɨñ enɨ-kaumbi, manda tambon nɨm tambane-nɨmbi, sɨlak nambɨm ñaumbi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tɨmbi Yesulok gɨnañ dɨ-kokop eneumbi tambane-yambɨmbi, gɨnañ kwambɨndanjɨla walen kolaumbi, ama wala ñɨndɨñ nɨñguk, “Kɨka kosuat!” Eumbi, kii kosuapi, kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tɨmbi Falisi ama endɨ it kiyau bimbi, pawañ poñambi, wolongan ama wapmañ Elottok sambatñii gɨt kɨmɨn tɨñgɨlɨñ. Kɨmɨn tɨmbi, kusei kɨmɨpi, nɨtek tɨmbi wɨtneñ eñɨpi, manda e-lonjɨ-tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu gɨt gwañgwañii endɨ pɨ-ñambi, Galili tuk guañ baliliñ ñañgɨlɨñ. Ñañɨlɨmbi, ama kɨmɨn wopumgan endɨ Yesu kleñgɨlɨñ. Endɨ Galili kwelan naningot nɨm a. Amatam Judia kwelan ");
INSERT INTO nif_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ba Jelusalem it kwelan, ba Idumaia kwelan ba Joldan tuk tambon kanda, ba Tilo gɨt Saidon it kwet kandañ pakañ, amatam asupgan endɨ Yesu kundit neknek tɨ-kuñguk wolok gɨñgɨt nandɨñgɨlɨñda tɨmbi endoñ bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Endɨ amatam asup ep tɨmbɨ kɨndem dañgukta, wala tɨmbi ama jɨmbasɨat ba wandanjɨat endɨ tɨke-kanelɨñdok kle-gɨmbupi, tambo kle-kot-tɨñgɨlɨñ. Wɨndɨñ tɨñgɨlɨñda tɨmbi, Yesulɨ kɨkeñ plon loup nandɨmbi, gwañgwañiila enguk, “Nɨm kañbi, amatamdɨ nep kamainelɨñ, wala tɨmbi kɨkeñ tipnam no bɨmbi namandɨ palen.” ");
INSERT INTO nif_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tɨmbi ama yal kolanjɨat Yesu kañgɨlɨñ endɨ kesinan mɨlelem tɨmbi dɨñgunembi, ñɨndɨñ kɨtɨñgɨlɨñ, “Dɨk Yambattok Nɨñañ sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wɨndɨñ kɨtɨñɨlɨmbi, Yesulɨ enlok kusei nɨm e-daklenelɨñdok enɨ-kɨmɨsip kwambɨñ tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tɨmbi Yesulɨ kwet kɨmɨn nolok lombi, ama epmep nandɨñguk wakan enɨ-tiañeum bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Bɨumbi, endoñnan nanin ama 12got epbi, kosɨ ‘enɨ-mumulɨn’ kɨtɨmbi enguk, “Sɨndɨ nakɨta kunelɨñdok sep danlet. Danbi sanɨ-mulambi, gɨñgɨt mandana e-ta-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tɨmbi yal kolan ep kle-kot-tɨ-semnelɨñdok gembɨ pat-samekak.” ");
INSERT INTO nif_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ama 12 Yesulɨ ep danguk endok kosɨ ñɨndɨñ: Simon (koi no Petlo kɨtɨñguk). ");
INSERT INTO nif_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Tɨmbi Sebedilok nɨñañiit Yakobo gɨt Yoane (endok koset komblin Boanelges ep kɨtɨñguk, nɨnɨlok manda plon ‘Endɨ dɨlɨmat wandiñ’). ");
INSERT INTO nif_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Tɨmbi Andlu, Filip, Batlomio, Mataiyo, Tomas, Yakobo Alifaialok nɨñañ, tɨmbi Tadaio, ba Simon Selot. ");
INSERT INTO nif_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tɨmbi Judas Iskaliot, ama endɨ Yesu bola tɨ-ñɨmguk. ");
INSERT INTO nif_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tɨmbi Yesulɨ gwañgwañii gɨt ilan ñañguk. Ñaumbi, bɨndambo amatam asuptɨ endoñ bɨ kɨmɨn tɨñgɨlɨñ. Nain tuop wɨndɨñ tɨñgɨlɨñda tɨmbi, Yesu gɨt gwañgwañii endok nana tuk ep na nain no nɨm inda-semguk. ");
INSERT INTO nif_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tɨmbi Yesulok wekal sambat endɨ gɨñgɨt wɨn nandɨmbi, “Gɨnañ kamalalak” embi, isɨ kusei bimbi, tɨkenelɨñdok ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ñañɨlɨmbi, endɨkñe manda nandɨ-tale ama dɨwɨn Jelusalem it kwelan pakɨlɨñ endɨ Yesu pakuknan bɨmbi ñɨndɨñ eu satañguk, “Belsebul endɨ Yesulok gɨnañnan patak”, ba “Yal kolandok yambɨ-dɨkñenjɨlɨ gembɨ mɨumbi, yal kolan ep kle-kotak.” ");
INSERT INTO nif_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Eumbi, Yesulɨ kɨtɨ-semum bɨumbi enguk, “Kusei nekta Satañdɨ enlok yalñii ep kle-kolek? ");
INSERT INTO nif_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tɨkap it kwet nolɨ tambɨpi, nɨsɨñgan mimbi, tambo wɨt-tɨnelɨñda, it kwet walɨ nɨm kwambɨñ dambi palek. ");
INSERT INTO nif_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ba sambat nolɨ tambɨpi, nɨsɨñgan mimbi, tambo wɨt-tɨnelɨñda, sambat walɨ nɨm kwambɨñ dambi patnelɨñ. ");
INSERT INTO nif_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Wɨndɨñgangot Satañdɨ ikan yalñiila kanjɨk tɨmbi, ep tambɨlɨmda, endɨ kwambɨñ dambi ilektok tuop nɨm. Endɨ tale-sɨn tawɨk. ");
INSERT INTO nif_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Tɨmbi Satañ endɨ ama no gembɨnat nomɨk. Ama nolɨ endok it gɨnañ gembɨnat lombi, gɨñgɨtñii joñgoñgan ep mektok tuop nɨm. Dama endɨ ama gembɨnat wɨn tɨkembi, toalɨ ap imbi bium palɨmek, gɨñgɨtñii palɨmlak wɨn kɨndem ep talewɨk.” ");
INSERT INTO nif_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yesulɨ wɨndɨñ embi yousɨmbi enguk, “Nak biañgan sanlet: amatamdɨ dɨwɨsɨla ba Yambatta kolan tɨ-ñɨmbi yom tañda, yom wɨn gɨtɨkkan Yambattɨ kɨndem bi-semekak. ");
INSERT INTO nif_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gan no endɨ Dɨndɨm Yal nɨ-kolalakta, endok yomɨn biñɨm-biñɨmlok tuop nɨm patak, yomɨn walɨ papat kwambɨñ palɨmekak.” ");
INSERT INTO nif_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Endɨkñe manda nandɨ-tale amalɨ Yesulok gɨnañnan yal kolan patak embi, Dɨndɨm Yallok kenan wɨndɨñ e-kolakola e-ta-kuañgɨlɨñda tɨmbi manda wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tɨmbi Yesu meñ kwayañii endɨ tombi, it pawan ipi, Yesu gɨt e-nandɨ-tɨnelɨñdok manda kɨmɨlɨm loñguk. ");
INSERT INTO nif_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Loumbi, amatam Yesu kle-gɨmbupi pipakɨlɨñ walɨ Yesu nɨmbi eñgɨlɨñ, “Meñga nokai pawan bɨ ipi, gambɨnep nandɨmbi eañ.” ");
INSERT INTO nif_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eumbi tambane-enguk, “Mena notnai wɨ nin?” ");
INSERT INTO nif_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Wɨndɨñ embi, amatam kle-gɨmbup pipakɨlɨñ yambɨñɨpi enguk, “Kawɨt! Nokok mena, notnai ñɨ pakañ. ");
INSERT INTO nif_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","No endɨ Yambattok man tañgonelakta, walɨ wakan nokok mena notnai sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tɨmbi Yesulɨ tuk guañ baliliñ ña-papi, bɨndambo kusei kɨmɨpi, amatam enɨ-daut tɨ-semguk. Nain wolonda amatam endoñ bɨ kɨmɨn tɨñgɨlɨñ wɨn wopumgan sɨnɨk, wala tɨmbi Yesulɨ kɨkeñ nolok plon lo pipalɨmbi, kambak munjulɨm ñaña eñguk. Tɨmbi amatam kɨmɨn gɨtɨktɨ tuk bambalnan pipakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Tɨmbi Yesulɨ nepek asuptok plon eyout manda embi, enɨ-daut tɨ-semguk. Tɨñɨpi enguk, ");
INSERT INTO nif_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nandɨwɨt! Ama nolɨ nana mɨnjɨp kokota kena gɨnañ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ñambi, mɨnjɨp kot-tɨ-kot-tɨ-ñañɨlɨmbi, dɨwɨn telak plon pɨumbi, monɨktɨ bɨmbi, yout-na-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Tɨmbi mɨnjɨp dɨwɨndɨ kwet lakatgot kawattɨ salaiñguknan pɨñgɨlɨñ. Wolok kwet lakat pakukta, mɨnjɨptɨ platikan tawa-lambɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","gan endɨ kakai plongot pakukta, maimdɨ lambɨ ep dɨumbi yañetambi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Tɨmbi mɨnjɨp dɨwɨndɨ koselek mɨnjɨp boñgɨpsɨnan pɨñgɨlɨñ endɨ yakayakan tawa-lambumbi, koselektɨ gembɨnjɨat lambɨ ep tapli-taleumbi, bien nɨm laliñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Tɨm mɨnjɨp dɨwɨndɨ kwet galk plon pɨñgɨlɨñ endɨ tawa-lambɨmbi, bien kɨndem sɨnɨk laliñgɨlɨñ. Kwandai dɨwɨndoñ bien lakat, dɨwɨndoñ kambak asup, dɨwɨndoñ asup sɨnɨk wɨndɨñ laliñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesulɨ eyout manda wɨndɨñ embi yousɨmbi enguk, “No en pawañnat endɨ mandana nandɨmbi tɨke-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tɨmbi amatam kɨmɨn gɨtɨk endɨ ña-taleumbi, Yesu, gwañgwañii 12 gɨta nosii dɨwɨn nɨsɨñgan pakɨlɨñ. Papi, eyout manda gɨtɨk eñguk wolok kusasɨla nɨ-kaumbi ");
INSERT INTO nif_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ñɨndɨñ enguk, “Telak nɨtek plon Yambattɨ amatamñii yambɨ-dɨkñelak wɨn damañgan pat-sembɨn pakuk, gan nak man sɨnda wakan sanba dakleumbi, kɨsɨ plon kɨmɨt-talelet. Gan amatamdɨ nokok gɨñgɨt nɨm inda-taleañ enda wakan nak nandɨnandɨ gɨtɨk wɨn eyout mandalɨñgot enɨ-daut tɨ-semlet. ");
INSERT INTO nif_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Wɨndɨñ tɨmbambi, endɨ deimbi kañ, gan nɨm ka-dakleañ, ba pawanjɨ kɨmɨpi nandañ, gan nɨm nandɨ-dakleañ. Endɨ ka-nandɨ-daklenelɨñda, gɨnanjɨ tambaneumbi, Yambattɨ yomjɨ kɨndem bi-semek.” ");
INSERT INTO nif_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tɨmbi Yesulɨ yousɨmbi enɨ-kañbi eñguk, “Eyout manda sanɨt wolok kusei nɨm nandɨ-dakleañ ba? Wɨndɨñda eyout manda gɨtɨk nɨtek nandɨ-talenelɨñ? ");
INSERT INTO nif_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nandañ! Ama nana mɨnjɨp kotak endɨ Yambattok manda e-kolɨ pɨlak. ");
INSERT INTO nif_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mɨnjɨp telak plon pɨlak wolok walan ñɨndɨñ: manda wɨn nandumbi, gɨnanjɨ gɨnañ pɨumbi, Satañdɨ platikan bɨ manda yapma tɨke-semlak. ");
INSERT INTO nif_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ba mɨnjɨp kwet kawatgot plon pɨlak: endɨ manda wɨn nandɨmbi nandɨ-koñgom tɨmbi nandɨ-dasiañ. ");
INSERT INTO nif_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gan manda wɨn gɨnanjɨ gɨnañ kakai nɨm tɨlakta, nain dumangangot tɨke-kuañ. Gɨñgɨt mandala tɨmbi mɨlap ba kanjɨk endok plon indaumbi, endɨ platikan sɨnɨk pipɨmbi biañ. ");
INSERT INTO nif_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ba mɨnjɨp koselek mɨnjɨp boñgɨpsɨnan pɨlak: ama dɨwɨn manda wɨn nandɨ-taleañ, ");
INSERT INTO nif_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","gan kwelalok mɨlap, ba mɨnem kwɨlɨkwɨlɨ wolok nandɨ-koñgom juluñgan, ba nepek kusei kusei dɨwɨsɨ wolok galktɨ gɨnanjɨ tokñeumbi, manda nandɨmbi, platik kamalaumbi, bien nɨm indalak. ");
INSERT INTO nif_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ba mɨnjɨp kwet galk plon pɨlak wolok walan wɨn ñɨndɨñ: ama endɨ wakan manda nandɨm kasɨlembi tɨke-kuañda, bien ep tɨndɨnjɨ plon inda-ta-ñalak: dɨwɨndɨ lakat, dɨwɨndɨ kambak asup, dɨwɨndɨ asup sɨnɨk laliañ.” ");
INSERT INTO nif_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Tɨmbi Yesulɨ Yambattok mandala ñɨndɨñ enbi eñguk, “Ama nolɨ sipala it gɨnañ tɨke-lombi, kambottɨ tapliwɨk ba pipat doundou kapmainan kɨmɨlek ba? Nɨm a! Endɨ it gɨnañ tɨke-lombi, indangan kɨmɨlɨmbi kolɨ salewɨk. ");
INSERT INTO nif_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wolok tuopgan manda gɨtɨk pat-sembɨn patak wɨn eu inda-daklelok. Tɨmbi nepek gɨtɨk wɨt-tapliñgɨlɨñ patak wɨn tɨmbɨ inda-daklelok. ");
INSERT INTO nif_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","No en pawañnat endɨ mandana ñɨn nandɨmbi tɨke-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Yesulɨ wɨndɨñ embi enguk, “Pawanjɨlɨ manda nɨtek nandañ wɨn nandɨmbi tɨke-kɨliñ enekalɨñ. Manda nɨtek nandɨmbi tañgoneañda, Yambattɨ wolok tuopgan nanandɨ sambi, nombo yousɨmbi samɨ-sɨnɨk taukak. ");
INSERT INTO nif_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Neta, no endɨ nanandɨ Yambattɨ mɨñguk wɨn tɨke-kulakta, endok nanandɨn wɨn tɨmbɨm wopum daukak. Gan no endɨ nanandɨ wɨn nandɨ-kɨmnembi nɨm tɨke-kulakta, nanandɨn palɨmlak wɨn apma tɨke-ñɨmɨumbi, sɨlak palekak.” ");
INSERT INTO nif_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Tɨmbi Yesulɨ yousɨmbi enguk, “Yambattɨ enlok gɨñgɨtñii telak nɨtek plon yambɨ-dɨkñeumbi inda-sata-tañ, nak wolok plon eyout manda no ñɨndɨñ sanba nandɨwɨt: ama nolɨ kena gɨnañ nana mɨnjɨp kot-tɨ-kot-tɨ-tɨlak. ");
INSERT INTO nif_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kot-talembi, ilan ñambi, tim sandap dou-mɨlat-ta-kuumbi, mɨnjɨp walɨ bendɨ-wopum dambi, mɨndiñ lambɨlak. Gan telak nɨtek plon lambɨlak wɨn en nɨm nandɨlak. ");
INSERT INTO nif_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kwet en kena tɨmbɨmbi, bien indalak. Dama mɨndiñ lambɨ-indaumbi, sap kɨmɨlɨmbi, siñgi kandañ bien indalak. ");
INSERT INTO nif_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Bien gɨlɨta-taleumbi, epep nain indaumbi, ama walɨ bien ep mɨlak.” ");
INSERT INTO nif_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesulɨ yousɨmbi enguk, “Yambattɨ telak nɨtek plon enlok gɨñgɨtñii tɨpet sɨnɨk wɨngan yambɨ-dɨkñeumbi inda-sata-tañ? Kusei wolok plon nɨndɨ eyout manda nek enambi dakleutak? ");
INSERT INTO nif_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yambattok kɨkesɨpmɨn wolok bendɨmbendɨn wɨn wambɨñ mɨnjɨp nomɨk. Mɨnjɨp wɨn tipnam sɨnɨk, mɨnjɨp dɨwɨn kena gɨnañ kokañ wɨn wolok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kwet plon kotnambi, lambɨ bendɨ-wopum dambi, yaya dɨwɨn gɨtɨk wɨn yapma klelak. Kii gayam wopumgan tɨmbɨmbi, monɨktɨ kɨndem wolok plon isɨ tɨmbi, pɨtiñ patnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesulɨ manda enɨ-ta-kumbi, eyout manda wandiñ asupgan eñguk; wɨn amatam nandɨnandɨnjɨlok tuop enbi, ");
INSERT INTO nif_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","kwapmeñgan eyout mandalɨñgot enɨlɨñguk. Gan eyout manda wolok bien gwañgwañii nɨsɨñgan palɨmek e-dakle-tɨ-semlɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Sandap wolonda kwet kɨlɨm eumbi, Yesulɨ kɨkeñ plon pipapi, gwañgwañiila enbi eñguk, “Nɨndɨ tuk guañ dɨkñembi, dat kandañ ñana.” Eumbi, gwañgwañiilɨ ama kɨmɨn gɨtɨk yambimbi, kɨkeñ plon lombi, Yesu joñgo nañgɨpi, tuk tambon kandañ ñañgɨlɨñ. Tɨmbi ama dɨwɨndɨ kɨkeñjɨ tɨkembi, ep klembi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ñañɨlɨmbi, sasale wopumgandɨ kusei kɨmɨpi, tuk pendɨlɨm mɨlapi, kɨkeñjɨ gɨnañ pɨumbi tokñeup tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Gan Yesulɨ joñgo wɨñgan kɨkeñ temɨk siñgi kandañ kumba gemba kɨmɨpi dou-pakuk. Tɨmbi gwañgwañiilɨ tɨmbɨ sɨlɨkñembi nɨñgɨlɨñ, “Nɨnɨndaut. Tuk guañ gɨnañ pɨnepi tamɨñ. Wɨn nɨm nandɨ-nɨmlañ ba?” ");
INSERT INTO nif_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nɨmbɨmbi mɨlapi, sasale nɨ-ñombɨmbi, tuk guañda nɨñguk, “Gitak! Busukñane!” Eumbi, sasalelɨ kɨlp eumbi, tuktɨ busukñembi pakuk. ");
INSERT INTO nif_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tɨmbi Yesulɨ gwañgwañiila enguk, “Neta gembɨnjɨ pɨlak? Nɨtekta tɨmbi, nakɨta kuañ, gan gama nɨm nandɨ-kɨlɨk tɨ-namañ?” ");
INSERT INTO nif_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Eumbi, dambe taletalet tɨmbi, nɨsɨñgan e-nandɨ-tɨmbi eñgɨlɨñ, “En ama nɨtnein, ñala sasale gɨt tuk guañdɨ man tañgoneamɨk?” ");
INSERT INTO nif_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tɨmbi Yesu gɨta gwañgwañii endɨ tuk guañ dɨkñembi, tambon kandañ, Gelasa amatamdok kwelan, ña-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tombi, Yesulɨ kɨkeñ bimbi, kwambɨñ loumbi, ama no yal kolannat amasumnan pakuk endɨ yambɨmbi Yesuloñ bɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Ama wɨn toa kwambɨñ ba aindɨ kii kesi nain nain im-mañgɨlɨñ, gan ama nolɨ endok gembɨn tɨke-pɨuktok tuop nɨm. Endɨ toa pat-tɨmbɨ dɨkñeumbi, ain wɨp mɨndɨ-palɨmbi pa glolɨñguk. Tɨmbi endɨ sañan daumbi, kii kesi toa ba aindɨ nombo imnelɨñdok tuop nɨm kaañgɨlɨñda kak biumbi, sumnan dou-mɨlat-pat-tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tim sandap tuop endɨ sumnan ba kwet jañgɨn plon papi, kwawa wopum tɨmbi, kawattɨ siñgin gwɨlap wɨpi dombɨmbi pa kulɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","8","Ama endɨ wakan mayañgan ipi, Yesu kañbi, endoñ woñep bɨumbi nɨñguk, “Yal kolan, dɨk ama gɨnañ nanin poñau!” Nɨmbi nɨ-gɨñgɨneumbi, bɨ-tombi, kesinan mɨlelem tɨ-ñɨmbi, kwambɨñgan kɨtɨmbi nɨñguk, “Yesu, Yambat Loloñ Sɨnɨk endok Nɨñañ, dɨk nek tɨ-namepi bɨlañ? Nak Yambattok koi plon ganlet: dɨk kena gɨm nɨm namekañ.” ");
INSERT INTO nif_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nɨmbɨmbi, Yesulɨ “Koka nin?” nɨ-nandumbi tambane-nɨñguk, “Kotna Kɨmɨn Gɨtɨk. Nɨndɨ asupgandɨ kuamɨñ, ñala.” ");
INSERT INTO nif_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Endɨ wɨndɨñ embi gɨñgɨnembi nɨñguk, “Nɨndɨ kwet ñɨn bineñdok nɨm nɨnɨ-mulekañ.” ");
INSERT INTO nif_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tɨmbi kamañgan bɨt asup kɨmɨn wopumgandɨ kloñnan kumbi, kwet mina-pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wɨndɨñda yal kolan endɨ Yesulɨ nandɨ-semumbi, bɨt gɨnanjɨ gɨnañ pɨnelɨñdok nɨ-nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nɨ-nandumbi nandɨ-semum ama gɨnañ nanin lambɨ poñambi, bɨt gɨnanjɨ gɨnañ pɨñgɨlɨñ. Pɨumbi, bɨttɨ kloñnan woñep pɨmbi, kwet bambalnan jɨlopi, tuk guañ gɨnañ pɨñgɨlɨñ. Bɨt lakat nɨm, 2000 netepek gɨtɨk endɨ pɨmbi, tuk nam kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tɨmbi bɨt kaulɨ-dɨkñe ama endɨ pimbi woñep ñambi, ama it kwelan ba kenanjɨ gɨnañ pakɨlɨñ tuop kasat tɨ-semgɨlɨñ. Tɨ-semumbi, endɨ nepek nek indañguk wɨn kanelɨñdok bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bɨmbi, Yesuloñ tombi, ama kañbi ka-nandɨñgɨlɨñ wɨn: ama yal kolan kɨmɨn gɨtɨknat kuñguk endɨ gɨnañ nanandɨn tombɨmbi, dasindasi kɨmɨpi, busukñanengan pipakuk. Amatamdɨ daut gɨtikñin wɨ kañbi mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nepek ka-nandɨ-tɨñgɨlɨñ endɨ ama yal kolannat kuñguktok plon ba bɨttok kandañ nepek indañguk wolok kasat tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kasat wɨn nandɨ-talembi, wɨnasɨlɨ wolongan Yesulɨ kwesɨ wɨn bim ñawɨktok nɨ-nandɨ-tɨmbɨmbi nandɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tɨmbi Yesulɨ kɨkeñ plon loñɨlɨmbi, ama yal kolan kle-kolɨmguk endɨ kle-ñawɨktok nɨ-nandɨ-tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Gan Yesulɨ nɨm embi nɨñguk, “Dɨk ika kwekanan ñambi, nokai gɨta kuñɨpi, Wopumdɨ telak nɨtek plon blan tɨ-gambi nandɨ-gambi, nepek wopum tɨ-kɨndem da-gam-talek wolok kasat tɨ-semekañ.” ");
INSERT INTO nif_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Eumbi, ama walɨ it kwet 10 wolok kandañ ñambi, kusei kɨmɨpi, Yesulɨ nepek tɨ-ñɨmguk wolok kasat tɨ-sem-kuumbi, amatam gɨtɨktɨ nandɨmbi nandɨ-gɨtɨp gɨtɨp tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Tɨmbi Yesu gɨt gwañgwañii endɨ kɨkeñ plon lombi, bɨndambo tuk guañ dɨkñembi, tambon kandañ ña-tomguk. Tombi, tuk baliliñnan palɨñɨlɨmbi, amatam asupgandɨ endoñ bɨmbi, kɨmɨn tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tɨñɨlɨmbi, it kiyau kaulɨ-dɨkñe ama no koi Jailus endɨ bɨmbi Yesu kañbi, kesinan mɨlelem tɨmbi ");
INSERT INTO nif_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","dɨñgunembi nɨ-kukulembi eñguk, “Wembana tipmɨnam endɨ sembupi tɨlak. Ñala dɨk kɨndem bɨmbi, kɨkalɨ endok plon kɨmɨlɨmbi, kɨndem dambi palen.” ");
INSERT INTO nif_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nɨmbɨ nandɨmbi, en gɨta ñañguk. Ñañɨlɨmbi, amatam kɨmɨn wopum endɨ kle-gɨmbupi, tambo kle-kot-tɨñɨpi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Endok boñgɨpsɨnan tam no ñañguk, endɨ tamdok jɨmbat tɨ-ta-kuumbi, gwɨlat 12 tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tɨmbi gwasap ama asuptɨ gwasap kusei kusei mɨumbi walɨ mɨlap yousɨ mɨumbi, siñgi gawat wopum sɨnɨk nandɨmbi kuñguk. Tɨmbi kena tɨñgɨlɨñ wolok tuan mɨnem kwɨlɨkwɨlɨ palɨmguk gɨtɨk wɨn em-taleñguk, gan jɨmbalɨ nɨm pañgɨtañguk. ");
INSERT INTO nif_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Tam endɨ wakan Yesulok gɨñgɨt nandɨlɨñgukta tɨmbi ñɨndɨñ kɨmɨt-nandɨ-tɨñguk, “Nak dasindasingot tɨke-kautetta, gumañ kɨndem dautet.” Wɨndɨñ nandɨmbi, amatam kɨmɨn gɨtɨk ñañgɨlɨñ boñgɨpsɨnan Yesulok siñgi kandañ ñambi, dasindasin tɨke-kañguk. ");
INSERT INTO nif_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tɨke-kaumbi, wolongan wekailɨ kala daumbi, pɨñgɨu pañgɨta-taleumbi nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tɨmbi Yesulok gembɨn nolɨ tiañeum nandɨmbi, wolongan tambanembi enɨ-nandɨmbi eñguk, “Nindɨ dasindasina tɨke-kalak?” ");
INSERT INTO nif_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Eñɨlɨmbi, gwañgwañiilɨ nɨñgɨlɨñ, “Kalañ: amatam kɨmɨn gɨtɨktɨ gep kle-gɨmbupi tambo kle-kot-tañ. Neta ‘Nindɨ neplak?’ elañ?” ");
INSERT INTO nif_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Gan Yesulɨ ‘Nindɨ sɨnɨk nep mɨk?’ wɨn ka-daklewɨktok yambɨ-ta-ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wɨndɨñ tɨmbɨmbi, tam endɨ pɨñgɨu plon kundit indañguk wala nandɨ-mɨsɨmbi, blañblañ tɨñɨpi Yesuloñ bɨñguk. Bɨmbi, kuañ dombɨnnan mɨlelem tɨ-ñɨmbi, enlok kusei eu tawaumbi nɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nɨmbɨmbi, Yesulɨ nɨñguk, “Wembe, nanandɨ kwambɨndañgala kɨndem dalañ. Mɨlapka taleumbi, waleñga kɨndem daumbi, ña kɨndemgot kuukañ.” ");
INSERT INTO nif_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesulɨ tam manda wɨndɨñ nɨ-palɨñɨlɨmbi, it kiyau kaulɨ-dɨkñelok ilnan nanin ama dɨwɨn manda tɨke-bɨmbi, nosɨ kañbi nɨñgɨlɨñ, “Wembañga ip sembɨlak. Ñala endaut amalɨ sɨlakan nektok ikanan kesɨt gawat ñautak?” ");
INSERT INTO nif_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Gan Yesulɨ manda wɨn nandɨ-kɨmnembi, kaulɨ-dɨkñela nɨñguk, “Nɨm mɨsɨwɨñ, sɨlak nandɨ-kɨlɨk tɨ-namɨ-ta-ñaukañ!” ");
INSERT INTO nif_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Wɨndɨñ embi, amatam gɨta gwañgwañii dɨwɨn en nɨm klenelɨñdok enɨ-kɨmɨsip tɨ-sembi, Petlo, Yakobo gɨta kwayañ Yoane endɨñgot yanañgɨpi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ñambi, kaulɨ-dɨkñelok ilan tombi, amatam kɨmɨn gɨñgɨlɨ ba mano kulɨm tɨmbi kut-palɨmbi yambɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yambɨ-nandɨmbi, it gɨnañ lombi enguk, “Sɨndɨ nekta gɨñgɨlɨ wopum tɨmbi kut-pakañ? Wembe ñɨn nɨm sembɨk, endɨ sɨlak dou patak.” ");
INSERT INTO nif_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wɨndɨñ eu nandɨmbi, kolan ka-kwalepgɨlɨñ. Gan Yesulɨ amatam gɨtɨk ep kleum pawan pɨumbi, wembe meñ beu gɨta gwañgwañii tɨpet gɨt no wɨn yanañgɨpi, wembe pakuknan loñguk. ");
INSERT INTO nif_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Lombi, wembe kii tɨkembi, nɨsɨlok manda plon “Talita kumi” nɨñguk, wɨn ñɨndɨñ, ‘Wembe tip, mɨlat ganlet.’ ");
INSERT INTO nif_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Eumbi, wolongan wembe walɨ mɨlapi, ñañambɨt tɨñguk. (Wembe wolok gwɨlalɨ 12.) Tɨmbi amatam wolok pakɨlɨñ endɨ nepek wɨn ka-sɨlɨkñembi, nanandɨnjɨ nɨm nandɨ-dakleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tɨmbi Yesulɨ kasat ama dɨwɨnda nɨm ennelɨñdok kɨmɨsip kwambɨñ tɨ-sembi, wembe wɨn nana mɨumbi nambektok enguk. ");
INSERT INTO nif_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Tɨmbi Yesulɨ kwet walinin ñambi, gwañgwañii gɨta il kuseinan ñam pakuk. ");
INSERT INTO nif_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pakap, Sabat patnandɨ nain indaumbi, it kiyau gɨnañ lombi, kusei kɨmɨpi, amatam enɨ-daut tɨ-semumbi nandɨñgɨlɨñ. Tɨmbi asuptɨ nandɨ-gɨtɨp gɨtɨp tɨmbi eñgɨlɨñ, “Ama sɨlanin ñalɨ manda gɨtɨk ñɨn denanin inda-ñɨmɨñguk? Nanandɨ wopuwopum ñɨn inda-ñɨmɨñguk wɨn netepein sɨnɨk? Ba kundit tɨndɨn walan wɨn engano sɨnɨk! ");
INSERT INTO nif_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Endɨ it tɨndɨ ama sɨlanin wɨn! Malialok nɨñañ, ba Yakobo, Jose, Juda gɨta Simon, endok dasɨ. Tɨmbi wiwii endɨ nɨn gɨta kuañ.” Wɨndɨñ embi nandɨ-ñɨmum pɨ-sɨnɨk tañguk. ");
INSERT INTO nif_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Tɨmbi Yesulɨ enguk, “It kwet dɨwɨn endɨ plofet ama nola nandum loloñ tɨlak, gan ilnan nasɨ ba nolii ba wekal kusipñii endɨ ka-mɨsɨ-tɨ-ñɨmañ.” ");
INSERT INTO nif_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wɨndɨñ tɨñgɨlɨñda tɨmbi, kundit engano tɨmbepi nandum mɨlataumbi, sɨlak ama jɨmbasat tɨpet sɨnɨk kiilɨ ep kaumbi, kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tɨñɨpi nandɨñguk, “Nekta sɨnɨk tɨmbi, kenanala nandum tlal tɨlak?” Wɨndɨñ nandɨñɨpi, enɨ-daut tɨ-semektok it kwet kle-gɨmbut-ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tɨmbi Yesulɨ gwañgwañii 12 enɨ-tiañeum bɨumbi, kena tɨnelɨñdok ama tɨpet tɨpet enɨ-mupi, yal kolan ep kle-semnelɨñdok gembɨ emguk. ");
INSERT INTO nif_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tɨmbi enguk, “Sɨndɨ ñanepi, nepek no nɨm tɨke-ñanekalɨñ, toñanjɨñgot. Nana ba lɨk wɨn nɨm tɨke-ñanekalɨñ, ba mɨnem kwandai gɨmɨn no dasindasinjɨ gɨnañ nɨm dasinekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kesɨsɨlok gwɨlap wɨnda tɨkenekalɨñ, dasindasi tɨpet wɨ nɨm, noñgangot dasinekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wɨndɨñ embi enguk, “It kwet nolok tombɨmbi, ama nolɨ sanɨ-tiañeumbi, endok il gɨnañ londekamɨk, it kwet wolok patekamɨk tuop endok ilnangot dou-mɨlat-tɨ-patekamɨk. ");
INSERT INTO nif_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tɨkap it kwet nolok tombɨmbi, wɨnasɨlɨ not nɨm tɨ-sambi, mandanjɨ nɨm nandɨnekalɨñda, yambimbi ñanekalɨñ. Ñanepi, kesɨsɨ plon kwɨlɨñ sapak wɨt-sapleum pɨukak. Wɨndɨñ tɨmbɨmbi, kundit kolan tɨñgɨlɨñ wɨn ka-nandɨ-tomnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Yesulɨ wɨndɨñ eumbi, gwañgwañiilɨ ñambi, amatam gɨnanjɨ tambanenelɨñdok gɨñgɨt manda engɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Tɨñɨpi, yal kolan asup ep kle-kot-semgɨlɨñ, ba jɨmbasat asup gwasap tullɨ saple-sembi, ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tɨmbi Yesulok koi gɨñgɨt pɨndɨ dañgukta tɨmbi, ama wapmañ Elot endɨ bo wɨn nandɨñguk. Ama dɨwɨsɨlɨ Yesula ñɨndɨñ eañgɨlɨñ, “Yoane, tuk i-sem-i-sem ama en wakan bɨndambo kɨmnan nanin mɨlakuk, wala tɨmbi endɨ kena gembɨnat tɨmbi kulak.” ");
INSERT INTO nif_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ba dɨwɨndɨ Yesula “En Elia” eañgɨlɨñ, ba dɨwɨndɨ “Endɨ plofet ama no, plofet ama damanin wandiñ nomɨk” eañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wɨndɨñ eumbi, Elottɨ wɨn nandɨmbi pa eñguk, “Yoane, ama wɨn damañgan natna ewa bim dombum kɨmguk, en wakan mɨlapi kulak.” ");
INSERT INTO nif_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Elot endɨ kusei ñɨndɨñda wɨndɨñ eñguk: endɨ bo enlok kwayañ Filip endok tamɨn koi Elodia apma tɨkeumbi, Yoanelɨ gɨñgɨt wɨn nandɨmbi nɨñguk, “Dɨk kwayañgalok tam matɨke-patañ wɨn kɨmɨsip manda maklelañ.” Endɨ wɨndɨñ nɨlɨñgukta, Elottɨ bo tamɨn nandɨ-ñɨmbi, kena gwañgwañii enɨ-mulɨmbi ñambi, Yoane tɨkembi, it kwambɨñ gɨnañ im kɨmɨlɨmbi pakuk. ");
INSERT INTO nif_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tɨmbi Elodialɨ Yoanela gimbɨt gɨnan gɨnañ tɨke-papi, wɨlektok nandɨñguk. Gan endɨ tuop nɨm, ");
INSERT INTO nif_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","neta Elottɨ Yoane tɨke-kamaiñguk. Endɨ Yoanela nandum ama dɨndɨm sɨnɨk, Yambattok kena tɨndɨlok ama no tɨmbɨmbi, enda ka-mɨsɨmɨsɨ e-tɨ-ñɨmguk. Tɨmbi endɨ Yoane nɨ-tiañembi, mandan nandɨlɨñguk. Nandɨñɨpi, “Nɨtek tɨmbet?” embi, gɨnañ tɨpet tɨmbi nandɨ-bendɨ-tɨlɨñguk. Gan endɨ Yoanelok mandan nandɨ-koñgom tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tɨmbi Yoane wɨlɨ kɨmbektok telak no Elodiala ñɨndɨñ inda-ñɨmɨñguk. Elottɨ indaindan nain indaumbi, amañii loloñ ba ama sañanjɨlok telak dama ba Galili kwettok ama biesɨ ep kɨmɨn tɨ-talembi, nana sina wopum tɨ-semguk. Tɨmbi endɨ kɨmɨn tɨmbi nana na-palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Elodia enlok wemban endɨ amaloñ ña tombi, dausɨnan kap tiñguk. Kap tiumbi, Elot gɨt yokñii endɨ kañbi nandɨ-kɨndem dañgɨlɨñ. Tɨmbi Elottɨ wembe sim nɨñguk, “Dɨk nepek wala ba wala eumbi gametet.” ");
INSERT INTO nif_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Embi e-kwambɨñ dambi nɨñguk, “Nepek wala ba wala eumbi, kɨndem gametet. Nak kwet ñɨn ka-dɨkñelet wala bo eumbi, kɨndem tambɨpi, tambon gametet.” ");
INSERT INTO nif_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wɨndɨñ eumbi, wembelɨ meñloñ ñambi nɨ-nandɨmbi nɨñguk, “Nak nektok sɨnɨk eutet?” Eumbi, meñlɨ nɨñguk, “Yoane miti tuk i-sem-i-sem tɨñguk endok kumbamla e!” ");
INSERT INTO nif_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Eumbi, wolongan platik sɨnɨk ñambi, Elottoñ tombi nɨñguk, “Dɨk ñɨndɨñgɨtañgan Yoanelok kumbam jawañ plon kɨmɨpi namɨñ!” ");
INSERT INTO nif_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Eumbi, Elottɨ nandum kola-sɨnɨk tañguk. Gan endɨ yokñiilok dausɨnan manda e-kwambɨñ da-ñɨmɨñgukta tɨmbi, mandan wɨn pi-pɨwɨktok tuop nɨm nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nɨm nandɨ-ñɨmlok, gan joñgo nandɨ-ñɨmbi, wolongan enlok kamaikamai ama no Yoanelok kumbam tɨke-bɨuptok nɨ-mukuk. Nɨ-mulɨmbi, it kwambɨñ gɨnañ ñambi, Yoanelok bim dombɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","kumbam jawañ gɨnañ kɨmɨpi tɨke-bɨ wembe mɨumbi, meñɨnlɨ kauptok tɨke-ñam mɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tɨmbi Yoane gwañgwañiilɨ gɨñgɨt wɨn nandɨmbi, it kwambɨñnan ñambi, Yoanelok dalandan tɨke-ñambi kɨndikɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tɨmbi Yesulɨ gwañgwañii 12 wɨn kenala enɨ-mukuk endɨ undane-bɨmbi, enloñ kɨmɨn tɨmbi, kena tɨñgɨlɨñ ba gɨñgɨt manda enɨ-daut tɨ-semgɨlɨñ wolok kasat gɨtɨk tɨ-ñɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tɨmbi amatam asup sɨnɨk walɨ yousɨyousɨ ñañambɨt tɨ-palɨmbi, Yesu gɨta gwañgwañii endɨ nana tuk nanelɨñdok nandɨñgɨlɨñ, gan nain no nɨm inda-semguk, wala tɨmbi Yesulɨ enguk, “Bɨumbi, nɨnɨñgan kwet ama nɨmnatnan ñana! Nain duman wandɨñ ña-kunambi, siñginjɨ busukñanewɨn.” ");
INSERT INTO nif_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wɨndɨñ eumbi, endɨ kɨkeñ plon lombi, nɨsɨñgan tuk guañ dɨkñembi, kwet ama nɨmnat tɨmbɨ dumalanelɨñdok ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ñañɨlɨmbi, amatam asuptɨ yambɨmbi yambɨ-nandɨ-tomgɨlɨñ. Tɨmbi amatam it kwet tuop nanin bɨñgɨlɨñ endɨ bo kesɨtɨ woñep ñambi, Yesulɨ ñanepi nandɨñguknan dama ña-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tɨmbi Yesulɨ wolok ña-tombi, kɨkeñ plon nanin pɨñɨpi, amatam kɨmɨn wopum yambɨmbi, gɨnañlɨ ñɨndɨñ nandɨñguk, “Sipsip yambɨ-dɨkñenjɨ nɨmnat nomɨk tañ”. Wɨndɨñ yambɨ-nandɨmbi, blan tɨ-sembi, kusei kɨmɨpi, nepek asup enɨ-daut tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Enɨ-daut tɨ-semumbi, maim daut ip pɨ-sembepi tɨñgukta tɨmbi, gwañgwañiilɨ endoñ bɨmbi nɨñgɨlɨñ, “Ñɨn kwet ama nɨmnatnan patnambi, maim daut ip pɨupi tɨlak. ");
INSERT INTO nif_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wala dɨk amatam enɨ-mulɨmbi, it kwet ba it jala ñasɨñgan pakañnan wolok ñambi, nananjɨ tua nambɨt.” ");
INSERT INTO nif_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eumbi tambane-enguk, “Sɨngan nana ep towiut!” Eumbi nandɨ-piasat tɨmbi nɨñgɨlɨñ, “Dɨk nek elañ? Nɨndɨ ñambi, mɨnem nek ñalɨ nana tuam bɨmbi emneñ? Mɨnem 200 wolok tuop nɨm!” ");
INSERT INTO nif_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Eumbi enguk, “Sɨnlok nana nɨtek pat-samlak ña kawɨt!” Eumbi ña kañbi undane-bɨmbi nɨñgɨlɨñ, “Plaua kɨt tambongot tɨm tuk gaut tɨpetgot pat-nɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Eumbi, Yesulɨ amatam kli kɨndem plon samba sambat pipatnelɨñdok enbɨmbi, dɨwɨndɨ 100, dɨwɨndɨ 50 wɨndɨñ pipakɨlɨñ. Pipalɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yesulɨ plaua kɨt tambon gɨta tuk gaut tɨpet wɨn epmbi, kunum plon dei loumbi, Yambat we ñɨmguk. We ñɨm-talembi, plaua ombɨmbi, gwañgwañii em-ta-ñaumbi, endɨ bo tɨke-papusenembi, amatam emgɨlɨñ. Tɨmbi Yesulɨ tuk gaut tɨpet wɨn wɨndɨñgot ep danbɨmbi, amatam gɨtɨkkan emumbi, ");
INSERT INTO nif_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","gɨtɨkkandɨ nañbi na-tokñeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Wɨndɨñ tɨmbɨmbi, plaua ba gaut wɨn na-tlatlap tɨm biñgɨlɨñ wɨn ep dasiumbi, sandɨñ lɨk 12 tokñeñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Amatam nana nañgɨlɨñ endoñnan nanin amalok kunakunasɨ wɨn 5000. ");
INSERT INTO nif_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tɨmbi wolongan Yesulɨ gwañgwañii enɨ-gɨñgɨnembi, kɨkeñ plon lombi, tuk guañ dɨkñembi, Betsaida it kwelan damandama ñanelɨñdok enɨ-mukuk. Enɨ-mulɨm ñañɨlɨmbi, Yesu en amatam isɨnan enɨ-mulepi pakuk. ");
INSERT INTO nif_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Papi enɨ-mut-talembi, nɨmolo tɨmbektok kwet jañgɨnnan loñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tɨmbi kwet kɨlɨm eumbi, gwañgwañiilok kɨkeñdɨ tuk guañ boñgɨpnan ñañɨlɨmbi, Yesu en engan kwambɨñnan papi, ");
INSERT INTO nif_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","yambɨñguk wɨn: sasalelɨ ñañgɨlɨñ kandañ bɨñgukta, kɨkeñ plon papi tuk kɨndit-tlalɨmbi yambɨñguk. Kwet gama nɨm salañɨlɨmbi, Yesulɨ tuk guañ plon kesɨtɨ ñambi ep tɨmbɨ dumalambi, yapma kle-ñaupi nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Tɨmbi gwañgwañiilɨ Yesu tuk guañ plon bɨumbi kañbi, “Walen tip no kamɨñ” wɨndɨñ kɨmɨt-nandɨñgɨlɨñ. Endɨ gɨtɨkkandɨ en kañbi mɨsɨmbi, gembɨnjɨ pɨumbi, kwawa tɨñgɨlɨñ. Gan Yesulɨ manda embi enguk, “Ñɨn natna ya, sɨmbasɨ busukñaneumbi nɨm mɨsɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Wɨndɨñ embi, kɨkeñ plon loumbi, sasalelɨ kɨlp eumbi, ka-sɨlɨkñembi nanandɨnjɨ nɨm nandɨ-dakleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Gɨnañ kwambɨñ kuñgɨlɨñda tɨmbi endɨ Yesulɨ plaualɨ kundit engano tɨñguk wolok kusei nɨm nandɨ-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tuk guañ dɨkñe-talembi, Genesalet kwelan tombi, kɨkeñ tɨke-kwambɨnda-kolɨ pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tɨmbi kɨkeñ plon nanin pɨumbi, wolongan amatam Yesu ka-dakleñgɨlɨñ endɨ ");
INSERT INTO nif_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","it kwet tuop woñep ñambi, kusei kɨmɨpi, jɨmbasat tañgo plon ep kɨmɨpi, Yesulɨ wandɨñ ba wandɨñ ñañguk tuop nandɨmbi, endoñ ep bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Endɨ it kwet tip ba wopum ba it jala nolok ba nolok ñaumbi, amatamdɨ jɨmbasat endoñ ep bɨmbi, ini plon yapɨkɨlɨñ. Yapɨpi nɨ-nandɨ-tɨmbi, dasindasin kusipgot tɨke-kanelɨñdok nandɨmbi nɨ-nandɨñgɨlɨñ. Tɨmbi nandɨ-semum tɨke-kañgɨlɨñ tuop kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tɨmbi Falisi ama gɨt endɨkñe manda nandɨ-tale ama dɨwɨn Jelusalem nanin bɨñgɨlɨñ endɨ bɨ Yesuloñ kɨmɨn tɨñgɨlɨñ. Kɨmɨn tɨmbi ");
INSERT INTO nif_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","kañgɨlɨñ wɨn: Yesulok gwañgwañii dɨwɨn endɨ sosɨlok telak nandɨ-kɨmnembi, kɨsɨ nɨm wɨlɨpi, nana sɨlak ep nambɨmbi yambɨñgɨlɨñ. Yambɨmbi nandum tuop nɨm tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Neta, Falisi ama gɨt Juda ama dɨndɨm kunepi nandañ endɨ gɨtɨk sosɨlok ep tɨndɨnjɨ ep kwambɨñ dambi kunelɨñdok enɨ-daut tɨ-semañ. Ep tɨndɨ no wɨn endɨ kɨsɨ nɨm wɨlɨkañda, nana nɨm nañ. ");
INSERT INTO nif_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tɨkap endɨ kɨmɨlɨ tuannanan ñambi bañ, nain wolonda tuk nɨm iyañda, endɨ nana nɨm nañ. Endɨ Yambattok dainan kɨndem patnelɨñdok jawañ kambot gɨta nepenepek dɨwɨn no pat-wɨlɨkañ, ba sosɨlok ep tɨndɨ wandiñgot dɨwɨn asupgan kɨmɨt-klembi tañ. ");
INSERT INTO nif_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wɨndɨñda Falisi ama gɨta endɨkñe manda nandɨ-tale ama endɨ Yesu ñɨndɨñ nɨ-kañgɨlɨñ, “Nɨtekta tɨmbi, gwañgwañgailɨ sosɨlok ep tɨndɨ nɨm kɨmɨt-klembi, kɨsɨ nɨm wɨlɨpi nana nañ?” ");
INSERT INTO nif_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nɨkaumbi enguk, “Ama man manbenjɨ tɨpelat! Eu inda manda no plofet Aisaialɨ youkuk wɨn sɨndok juluñɨtsɨlok kusei inda-dakle-kɨliñ elak. Yambattok manda wɨn ñɨndɨñ youyoulɨn patak, ‘Amatam ñalɨ manjɨlɨñgot kotna tɨke-loañ, gan gɨnañ nanandɨnjɨlɨ mayañgan sɨnɨk patak. ");
INSERT INTO nif_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Endɨ mandana nandɨ-kɨmnembi, ama sɨlanindok nandɨnandɨ enɨ-daut tɨ-semañ. Wɨndɨñda endɨ kap nɨmolo tɨmbi nanɨ-kɨndem da-tañ wɨn sɨlanin.’ ");
INSERT INTO nif_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Manda wolok tuop sɨndɨ Yambattok endɨkñe manda bimbi, amalok ep tɨndɨnjɨ tɨke-kwambɨñ dambi kleañ.” ");
INSERT INTO nif_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tɨmbi Yesulɨ yousɨmbi enguk, “Sɨndɨ sosɨlok ep tɨndɨnjɨ kɨmɨt-klenelɨñdok nandɨmbi, Yambattok endɨkñe mandan wɨlambane-kokotok kundit tɨ-kɨndem dañ. ");
INSERT INTO nif_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Neta, Moselɨ manda ñɨndɨñ embi youp biñguk patak, ‘Dɨk meñga bekala nandum loloñ tɨmbekak’, ba ‘No en meñ beula manda enɨ-suambat-tɨlakta, wɨlɨ kɨmbekak.’ Moselɨ wɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","gan sɨndok kandañ wɨn ñɨndɨñ sɨnɨk: ama no meñ ba beula ñɨndɨñ nɨlak, ‘Nepek nek pat-namlak wɨn Yambat mɨuptok e-kwambɨñ dañgut, wala tɨmbi gep kɨmɨlettok tuop nɨm.’ Endɨ wɨndɨñ nɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","sɨndɨ kɨmɨsip tɨ-ñɨmbi ñɨndɨñ nɨañ, ‘Dɨk meñga ba beka bɨndambo nɨm tɨke-kɨmɨlekañ.’ ");
INSERT INTO nif_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Wɨndɨñgangot sɨndɨ sosɨlok ep tɨndɨnjɨla yanañgɨp pɨñɨpi, Yambattok endɨkñe manda tɨmbɨ lakatalak. Tɨmbi sɨndɨ kundit kolan wandisɨ asupgan pat-tañ.” ");
INSERT INTO nif_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tɨmbi Yesulɨ bɨndambo amatam kɨtɨ-sembi enguk, “Sɨndɨ gɨtɨkkan mandana ñɨn nandɨmbi nandɨ-kɨliñ ewɨt. ");
INSERT INTO nif_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nepek gɨtɨk nambɨmbi mɨnjɨpsɨ gɨnañ pɨlak walɨ sep tɨmbɨ kolauptok tuop nɨm. Gan nepek gɨnanjɨ gɨnañ papi lambɨ-lamɨtak walɨ mek sep tɨmbɨ kolayañ.” ");
INSERT INTO nif_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tɨmbi Yesulɨ amatam kɨmɨn gɨtɨk yambimbi, gwañgwañii gɨta it gɨnañ lo-pakuk. Palɨmbi, gwañgwañiilɨ eyout manda eñguk wala nɨ-kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Nɨ-kaumbi enguk, “Sɨndɨ wɨndɨñgot nanandɨnjɨ nɨmnat bek? Nana walan kusei kusei nambɨmbi, mɨnjɨpsɨ gɨnañ pɨlak walɨ sep tɨmbɨ kolauptok tuop nɨm. Wɨn nɨm nandañ ba? ");
INSERT INTO nif_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nepek wandiñ walɨ amalok gɨnanjɨ gɨnañ sɨnɨk nɨm pɨlak. Nɨm sɨnɨk. Walɨ tem meñ gɨnañ pɨmbi, temdok telak plon dɨndɨmgan ñambi, tem koñ gɨnañ pɨlak.” (Yesulɨ wɨndɨñ embi, nana gɨtɨk Yambattok dainan kɨndem gɨtɨkgot embi enɨ-dakle-tɨ-semguk.) ");
INSERT INTO nif_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tɨmbi Yesulɨ yousɨmbi enguk, “Nepek amalok gɨnanjɨ gɨnañ papi lambɨ-lamɨtak walɨ biañgan ep tɨmbɨm kolayañ. ");
INSERT INTO nif_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nekta, wɨn amalok gɨnanjɨ gɨnañ nanin sɨnɨk nanandɨ kolan walɨ lambɨ-lamɨlɨmbi ñɨndɨñ tañ: endɨ telak joñgo kuañ, ba kumbu tañ, ba ama yandɨp kɨm-tañ, ba tam ba wapat noloñ kumbu tañ, ");
INSERT INTO nif_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ba ka-galkta tañ. Wɨndɨñ tɨmbi, tɨmɨpmɨle kusei kusei tañ. Tɨmbi endɨ not juluñɨt tañ, ba siñgi mɨsɨ ba mayek nɨmnat sasaleañ, ba not ka-gimbɨt tañ, ba manda winjɨt eañ, ba nɨsɨla nandum loloñ tɨlak. Wɨndɨñ tɨñɨpi, nandɨ-kamalambi kuañ. ");
INSERT INTO nif_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nepek kolan gɨtɨk walɨ amalok gɨnanjɨ gɨnañ papi lambɨmbi lamɨtak walɨ biañgan Yambattok dainan ep tɨmbɨ kolayañ.” ");
INSERT INTO nif_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Tɨmbi Yesulɨ mɨlapi, gwañgwañii gɨt Juda amatamdok kwet bimbi, Tail it kwet kandañ ñañguk. Ñambi, sɨlak pat-nandɨ-tɨmbepi it nolok gɨnañ lombi, amalɨ en wandɨñ patak wɨn nɨm nandɨ-ñɨmnelɨñdok nandɨñguk, gan endɨ pat-sembektok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nɨm sɨnɨk. Wembe no yal kolannat endok meñlɨ ‘Yesu wandɨñ patak’ nandɨmbi, wolongan endoñ bɨmbi, kesinan mɨlelem tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","dɨñgunembi, wembanlok gɨnañ yal kolan kle-ñɨmektok nɨ-gɨñgɨneñguk. Tam wɨn endɨ Juda tam nɨm. Endɨ Fonisia nanin, Silia kwelan indañguk, ");
INSERT INTO nif_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","wala tɨmbi Yesulɨ ñɨndɨñ nɨñguk, “Gwañgwa bɨsat endɨ nana dama na-tokñenekalɨñ. Nɨm kañbi, endok nana wɨn yapma tɨkembi, kamotta ep kot-semneñ.” ");
INSERT INTO nif_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Eumbi, tamdɨ tambane-nɨñguk, “Wopum, biañgan elañ. Gan gwañgwa bɨsat endɨ nana nambɨmbi dɨp kwelan pɨlak wɨn kamottɨ naañ.” ");
INSERT INTO nif_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Eumbi, Yesulɨ nanandɨ kɨlɨktɨnlok kusei ka-nandɨ-tombi nɨñguk, “Dɨk wɨndɨñ elañ, wala tɨmbi kɨndem a, ñau! Yal kolan endɨ wembañga ip kambimbi ñalak.” ");
INSERT INTO nif_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Eumbi, ilnan ñambi kañguk wɨn: biañgan yal kolan walɨ wemban kak ñaumbi, ipal plon pat-nandɨ-tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tɨmbi Yesulɨ gwañgwañii gɨt Tail it kwet kandañ pɨ-ñambi, Saidon it kwet dɨkñembi, Dekapolis kandañ ñambi, Galili tuk guañnan tomguk. ");
INSERT INTO nif_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tombɨmbi, ama no nañgɨp bɨmbi, Yesulɨ kii endok plon kɨmɨlektok nɨ-nandɨñgɨlɨñ. Ama wolok pawañ sipsipmɨn, tɨmbi man manben mɨlap, manda dɨndɨm ewɨktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tɨmbi Yesulɨ amatam kɨmɨn gɨtɨk wɨn yambimbi, ama wɨn tɨke-nañgɨpi ña nɨsetkan pakɨmɨk. Palɨñɨpi, Yesulɨ kii nɨñañ tɨpettɨ endok pawañ gɨnañ sua embi iwɨt suambi, man manben tɨke-kañguk. ");
INSERT INTO nif_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Tɨke-kañɨpi, kunum plon dei loumbi yayakñembi, enlok mandan plon “Efata” eñguk, wɨn “Dɨk tom!” ");
INSERT INTO nif_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Eumbi, ama wolok pawañ tombɨmbi, man manben salaktaumbi, kusei kɨmɨpi, manda dɨndɨm nandɨmbi eñguk. ");
INSERT INTO nif_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Tɨmbi Yesulɨ amatamda kasat wɨn nɨm eu satawɨktok enbi, kɨmɨsip kwambɨm tɨ-semguk. Nain asup kɨmɨsip wandiñgot tɨ-semlɨñguk, gan nɨm, endɨ gɨñgɨnembi pa eu satañguk. ");
INSERT INTO nif_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tɨmbi kasat wɨn nandɨñgɨlɨñ endɨ biañgan nandɨ-sɨlɨkñembi eñgɨlɨñ, “Kundit gɨtɨk tɨ-kulak wɨn kɨndem gɨtɨkgot. Endɨ ep tɨmbɨmbi, pawanjɨ kaman endɨ bo nandɨ-tomañ, tɨmbi manjɨ galɨñguk endɨ manda eañ.” ");
INSERT INTO nif_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tɨmbi nain wolonda bɨndambo amatam kɨmɨn wopum nolɨ Yesu gɨta papi, nananjɨ taleumbi sɨlak pakɨlɨñ. Palɨmbi, Yesulɨ gwañgwañii ep kɨmɨn tɨmbi enguk, ");
INSERT INTO nif_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Amatam nain tɨpet gɨt no nakɨta papi, nananjɨ taleumbi, blan tɨ-semlet. ");
INSERT INTO nif_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tɨkap nak sɨlak isɨnan enɨ-mulam ñanetañda, telak boñgɨpnan dausɨ diman tɨmbɨmbi kɨm-katap tɨnelɨñ. Dɨwɨn nolɨ kwet mayañgan nanin bɨmbɨn.” ");
INSERT INTO nif_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Eumbi tambane-nɨñgɨlɨñ, “Kwet ñolok it kwet nɨmnat. Nɨndɨ nana tuop denanin tɨkembi ep towinetamɨñ?” ");
INSERT INTO nif_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Eumbi enɨ-kañguk, “Sɨnlok nana nɨtek pat-samlak?” Eumbi nɨñgɨlɨñ, “Plaua kɨt tambon tɨpetgot pat-nɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tɨmbi Yesulɨ amatam enbɨmbi, kwelan pi-pakɨlɨñ. Pipalɨmbi, endɨ plaua kɨt tambon tɨpet ep papi, Yambat we ñɨmbi ep tambɨpi, gwañgwañiila emguk. Emɨ-ta-ñambi, danɨ-papusenembi emnelɨñdok enbɨmbi, wolok tuop tɨmbi emgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tɨñɨpi, Yesulɨ tuk gaut tiptip tɨpet sɨnɨk pat-semguk wɨ epbi, Yambat we ñɨmbi, wɨn bo danɨ-papusenembi emnelɨñdok enbɨmbi emɨ-ta-ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Tɨmbi amatamdɨ nana wɨn nañbi na-tokñeñgɨlɨñ. Tɨmbi nana na-tlatlap tɨmbɨmbi dɨp pakuk wɨn ep dasiumbi, sandɨñ lɨk wopum kɨt tambon tɨpet tokñeñguk. ");
INSERT INTO nif_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Amatam nana nañgɨlɨñ wɨn 4000 netepek. Tɨmbi Yesulɨ enɨ-mulɨm ñaumbi, ");
INSERT INTO nif_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","wolongan endɨ gwañgwañii gɨt kɨkeñ plon lombi, Dalmanuta kwet kandañ ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tɨmbi Falisi ama endɨ Yesu tue-kambi tɨ-ñɨmnepi endoñ bɨmbi, en gɨta e-taña-tambɨt tɨmbi gɨñgɨnembi, Yambattɨ endok kusei tɨmbɨ daklewɨktok nandɨmbi, kundit no tɨmbɨm kanelɨñdok nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nɨmbɨmbi, Yesulɨ gɨnañ kwambɨndanjɨla nandum mɨlataumbi enguk, “Neta amatam ñalɨ kundilɨ kanepi eañ? Nak biañgan sanlet: kundit wandiñ no nɨm daut samum kanekalɨñ. Nɨm sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yesulɨ wɨndɨñ embi, Falisi ama yambimbi, gwañgwañii gɨta bɨndambo kɨkeñ plon lombi, tuk guañ tambon kandañ ñanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ñañɨpi, gwañgwañiilɨ kamalambi, nana no nɨm ep bɨñgɨlɨñ, gan plaua noñgangot kɨkeñ plon pat-semguk. ");
INSERT INTO nif_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Tɨmbi Yesulɨ nandɨnandɨ moyendɨ gwañgwañiilok gɨnanjɨ gɨnañ bendɨ-wopum dawɨk wala mɨsɨmbi, molo manda eyout plon kɨmɨpi enguk, “Sɨndɨ Falisi ama ba ama wapmañ Elot endok plaua kɨmɨlɨ bendɨla ka-kɨliñ enekalɨñ!” ");
INSERT INTO nif_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Eumbi, gwañgwañiilɨ nɨsɨñgan “Nana nɨm pat-nɨmlakta wala elak bek” embi e-nandɨ-tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tɨmbɨmbi Yesulɨ wɨn nandɨmbi enɨ-kañbi eñguk, “Sɨndɨ nana nɨm wɨn neta e-nandɨ-tañ? Sɨndɨ kusatna gama nɨm nandɨmbi nandɨ-tomañ bek? Wɨndɨñ gɨnanjɨ kwambɨñ dañguk bek? ");
INSERT INTO nif_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Sɨndɨ dausat, gan nɨm kañ, ba pawanjat, gan manda nɨm nandañ, ba sɨndɨ nandɨ-kamalayañ bek? ");
INSERT INTO nif_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nak plaua kɨt tambongot wɨn tambɨpi, ama 5000 ep towiwambi, nambɨm dɨp pakuk wɨn sɨndɨ sandɨñ lɨk nɨtek dasium tokñeñguk?” Yesulɨ wɨndɨñ enɨ-kaumbi, “Lɨk 12 tɨna tokñeñguk” nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ba nak plaua kɨt tambon tɨpetgot walɨ amatam 4000 ep towiwambi, nambɨm dɨp pakuk wɨn sɨndɨ sandɨñ lɨk wopum nɨtek dasium tokñeñguk?” Eumbi, “Lɨk kɨt tambon tɨpet tɨna tokñeñguk” nɨñgɨlɨñ. Nɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ñɨndɨñ enguk, “Sɨndɨ kusatna gamañgot nɨm nambɨ-nandɨ-dakleañ bek?” ");
INSERT INTO nif_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tɨmbi Yesulɨ gwañgwañii gɨta Betsaida it kwelan ña-tomguk. Tombɨmbi, ama dai kolan no endoñ nañgɨp bɨmbi, tɨke-kauptok nɨ-nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Tɨmbi Yesulɨ ama en kii plon tɨkembi nañgɨlɨmbi, it kwet pawañ pɨñgɨmɨk. Tɨmbi Yesulɨ ama wolok dai plon iwɨt suambi, kiilɨ endok plon kɨmɨpi nɨ-kañguk, “Dɨk nepek no kalañ ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nɨmbɨmbi deimbi eñguk, “E. Nak ama dɨwɨn yambɨlet. Gan nak yambɨwambi, kombalɨ ñañ nomɨk tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Eumbi, nombo kii dai plon kɨmɨlɨmbi, dai gembɨnat deimbi, kɨndem dañguk. Kɨnde daumbi, nepenepek gɨtɨk wɨn ka-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tɨmbi Yesulɨ ama wɨn it kwelan nombo louptok nɨ-kɨmɨsipbi, dɨndɨmgan ilnan ñauktok nɨ-mukuk. ");
INSERT INTO nif_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Tɨmbi Yesulɨ gwañgwañii gɨta pɨ-ñambi, it kwet tiptip Sisalia Filipai it kwet wopum kle-gɨmbupi pakɨlɨñ wandɨñ ñañguk. Telak plon ñañɨpi, gwañgwañii enɨ-kañbi eñguk, “Amatamdɨ naka nin sɨnɨk pa nanɨañ?” ");
INSERT INTO nif_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Eumbi nɨñgɨlɨñ, “Dɨwɨndɨ dɨka Yoane amatam miti tuk i-sem-ta-kuñguk en ganɨañ. Tɨmbi dɨwɨndɨ dɨka Elia ganɨañ, wɨn plofet ama damanin endɨ bɨndambo indaup een ip wakan bek. Ba dɨka plofet damanin no pa ganɨañ.” ");
INSERT INTO nif_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Eumbi, Yesulɨ enɨ-nandɨmbi eñguk, “Gan sɨnla naka nin sɨnɨk nanɨañ?” Eumbi, Petlolɨ manda ñɨndɨñ tambane-nɨñguk, “Dɨtna Mesia wakan.” ");
INSERT INTO nif_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eumbi, Yesulɨ kɨmɨsip tɨ-sembi, gama enlok kusei ama nola nɨm ennelɨñdok enguk. ");
INSERT INTO nif_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tɨmbi wolongan Yesulɨ kusei kɨmɨpi, Yambattok nanandɨ kwambɨñ Mesia enlok plon ñɨndɨñ enɨ-daut tɨ-sembi enguk, “Amalok Nɨñan endɨ mɨlap ba siñgi gawat kusei kusei inda-ñɨmektok. Ama bɨesɨ, tapma ama biesɨ gɨt endɨkñe manda nandɨ-tale ama endɨ kusalɨ kaumbi, tuop nɨm tɨmbɨmbi, siñgi wɨlɨmɨumbi wɨlɨ kɨmbekak. Tɨmbi sandap tɨpet gɨt no tɨmbɨmbi, bɨndambo kɨmnan nanin mɨlalekak.” ");
INSERT INTO nif_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesulɨ wɨndɨñ eñɨpi enɨ-dakle-ta-ñañguk. Eu dakleumbi, Petlolɨ engan tiañem ñambi, kusei kɨmɨpi, manda wolok nɨ-ñombɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Gan Yesulɨ tambanembi, gwañgwañiilok dausɨnan Petlo nɨ-ñombɨmbi eñguk, “Satañ, dɨk nambi ñau! Dɨk amalok nanandɨñgot klelañ, Yambattoñ nɨm.” ");
INSERT INTO nif_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tɨmbi Yesulɨ amatam kɨmɨn wopum wakɨt gwañgwañii kɨtɨ-semum bɨumbi enguk, “Ama no endɨ nak nep kle-kuupi nandɨlakta endɨ enlok nanandɨn ba galk siñgi wɨpi, kloñbalɨ tɨke-lo-bembi, nep kle-kuuktok elet. ");
INSERT INTO nif_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Neta, no endɨ natnala ba gɨñgɨt manda kɨndemnalok kuñgun bi-namlak, endɨ wakan kunumdok kuñguñ taletalen nɨmnat inda-ñɨmekak. Gan no endɨ kwelalok kuñguñ enlok tɨke-kɨmɨlep nandɨlakta, endɨ kunumdok kuñguñ kola-ñɨmekak. ");
INSERT INTO nif_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kola-ñɨmɨumbi, kwelalok nepenepek kusei kusei gɨtɨk ep kasɨleñguk walɨ nɨtek tɨmbi tɨmbɨ londaukak? ");
INSERT INTO nif_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Endɨ kuñgun kolañguk wɨn nek ñalɨ tuambi, bɨndambo kasɨleukak? Wɨn tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Man ñɨndɨñgɨta Yambat siñgi wɨlɨmɨmbi, yomsɨat kuañ, ba dɨwɨndɨ naka ba mandanala maetambi kuañ. Nain taletalenan Ama Sɨsɨnɨktɨ dɨndɨm añelo yanañgɨpi, Beulok gembɨ ba kolsalennat indangan indaukak wolonda endɨ bo en maeta-ñɨmgɨlɨñ wɨn maeta-semekak.” ");
INSERT INTO nif_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesulɨ wɨndɨñ embi enguk, “Nak biañgan sɨnɨk sanlet: Yambattɨ nain kɨmɨkuk wɨn indaumbi kusei kɨmɨpi, amatam gɨtɨk ini plon gembɨnat yambɨ-dɨkñeukak. Tɨmbi biañgan ñɨ pakañ sɨndoñnan nanin dɨwɨn endɨ gama kaik kuñɨlɨmbi indaumek kanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kena nain kɨt tambon noñgan taleumbi, Yesulɨ gwañgwañii tɨpet gɨt no, wɨn Petlo, Yakobo gɨt Yoane yanañgɨlɨmbi, kwet jañgɨn ombap nolok lombi, wandɨñ nɨsɨñgan pakɨlɨñ. Palɨmbi, gwañgwañiilok dausɨnan Yesulok siñgin walan tɨkɨleumbi, ");
INSERT INTO nif_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","dasindasin salembi, walalan bien sɨnɨk indañguk. Kwelan ñolok ama nolɨ sandum satnin wandiñ tɨmbektok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Tɨmbi gwañgwañiilɨ plofet ama damanin tɨpet, Elia gɨt Mose, endɨ indambi, Yesu gɨta manda e-nandɨ-tɨmbɨmbi yambɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Yambɨmbi, kolan mɨsɨumbi, Petlolok nanandɨn kamalaumbi, “Manda nɨtek ewɨt?” embi, Yesula ñɨndɨñ nɨñguk, “Nɨnɨndaut! Ñɨ pakamɨñ wɨn kɨndem sɨnɨk. Wala tɨmbi it jala tɨpet gɨt no mana! Dɨkok no, Moselok no, Elialok no.” ");
INSERT INTO nif_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tɨmbi mulukua nolɨ pɨmbi ep tɨmɨlɨmbi, Yambattɨ mulukua gɨnañ nanin kɨtɨu pɨumbi enguk, “Ñɨne nokoñ nɨñana noñgan sɨnɨk. Nak en ka-galkta tɨ-ñɨmlet. Sɨndɨ endok manda tɨke-kwambɨñ dambi kunekalɨñ!” ");
INSERT INTO nif_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eumbi, gwañgwañiilɨ wolongan deimbi kañgɨlɨñ wɨn: Mose gɨt Elia endɨ ikan pailɨmbi, Yesu en noñgan palɨmbi kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tɨmbi endɨ kwet jañgɨn plon nanin pɨñɨpi, Yesulɨ nepek wɨ kañgɨlɨñ wolok manda kasat ama nola joñgo nɨm ennelɨñdok e-kɨmɨsip tɨ-semguk, kasat wɨn Amalok Nɨñan endɨ kɨmnan nanin mɨlalekak wolondamek kɨndem enelɨñdok enguk. ");
INSERT INTO nif_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Eumbi, endɨ Yesulok manda wɨn nandɨ-kwambɨñ dambi, nɨsɨñgan “Kɨmnan nanin mɨlatmɨlat wɨn nɨtek?” embi e-nandɨ-tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tɨmbi endɨ Yesu nɨ-kañbi eñgɨlɨñ, “Kusei nektok endɨkñe manda nandɨ-tale amalɨ Elia Mesialok telak dama bɨuptok pa eañ?” ");
INSERT INTO nif_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Eumbi, Yesulɨ Yoane miti tuk i-sem-ta-kuñguk endok plon ñɨndɨñ e-youpi enguk, “Elia endɨ biañgan Mesialok telak dama bɨmbi, amatam gɨnanjɨ tɨmbɨ kaitanelɨñdok bɨukak. Gan nɨtekta tɨmbi, Ama Sɨsɨnɨkta bo ñɨndɨñ youyoulɨn patak: endɨ siñgin gawat kusei kusei bembɨmbi, amalɨ nɨ-tɨke-pɨ sɨnɨk tanekalɨñ? ");
INSERT INTO nif_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Gan nak Eliala ñɨndɨñ sanba: endɨ bo ikan bɨumbi, amalɨ nɨsɨlok nanandɨ klembi, manda endok plon youyoulɨn patak wolok tuopgan nepek kusei kusei kolan tɨ-ñɨmgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tɨmbi Yesu gɨt gwañgwañii tɨpet gɨt no endɨ kwet jañgɨn bimbi pɨ-ñambi, gwañgwañii dɨwɨn pakɨlɨñnan tomgɨlɨñ. Tombi yambumbi, amatam kɨmɨn wopumdɨ ep gɨmbupi pakɨlɨñ, tɨmbi endɨkñe manda nandɨ-tale ama dɨwɨndɨ gwañgwañii gɨta e-tañan tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tɨmbi ama kɨmɨn gɨtɨk endɨ Yesu bɨumbi kañɨpi, ka-sɨlɨkñembi, endoñ woñep ñambi, we ñɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Tɨmbi Yesulɨ enɨ-nandɨmbi eñguk, “Sɨndɨ neta e-tañan tañ?” ");
INSERT INTO nif_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","18","Eumbi, amatamdok boñgɨpsɨnan nanin ama nolɨ Yesula ñɨndɨñ tambane-nɨñguk, “Endaut. Nak nɨñana yal kolan nat dɨk tɨmbɨ kɨndem dawɨktok nañgɨpi bɨt, gan dɨk nɨm palañda gwañgwañgailɨ yal kolan wɨn kleklelok enɨt, gan endɨ tɨ nɨm kañbi bilɨñ. Yal kolan walɨ endok man manben tɨmbɨ galɨumbi, manda nɨm pa elak. Nainñɨn inda-ñɨmlak tuop yallɨ nɨñana tɨmbɨ kolakolalok tɨke-kolɨmbi pa pɨlak. Tɨmbi man payak lambumbi, man sɨ-gɨlɨm dambi, pɨñgɨu dɨñdɨñ pat-tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesulɨ manda wɨn nandum mɨlataumbi enguk, “Nak gɨnañ kwambɨndanjɨla kunjit tɨlet. Nain nɨtek sɨnɨk nak nombo sɨn gɨta palambi, nandɨ-kɨlɨktɨ tɨ-namnekalɨñ? Gwañgwa wɨn nokoñ tɨkem bɨwɨt.” ");
INSERT INTO nif_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eumbi nañgɨp bɨumbi, yal kolan walɨ Yesu kañbi, wolongan gembɨ kopi, kwelan kolɨ pɨumbi, tɨkɨle-binjat tɨmbɨmbi, man payak lambɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tɨmbi Yesulɨ beu nɨ-kambi eñguk, “Nain nɨtek sɨnɨk kundit ñɨndɨñ tɨ-ta-bɨlak?” Eumbi nɨñguk, “Damañgan gwañgwa tip palɨmbi inda-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Nain asup yal kolan walɨ nɨñana komba galk gɨnañ ba tuk gɨnañ tɨke-kolɨmbi pa pɨumbi, wɨlɨ kɨmbektok tuop pat-tɨlak. Gan, tɨkap dɨk tuopta, nɨnda blan nandɨ-nɨmbi, nɨp kɨmɨlekañ.” ");
INSERT INTO nif_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Wɨndɨñ eumbi Yesulɨ nɨñguk, “Netekta ‘tɨkap dɨk tuopta’ nanɨlañ? Dɨk nandɨ: no en nandɨ-kɨlɨktɨnat kulakta Yambattɨ nek inda-ñɨmektok nandɨlak wolok tuopgan tɨ-ñɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Eumbi, wolongan gwañgwa beulɨ kɨtɨmbi nɨñguk, “Nak nandɨ-kɨlɨk tɨ-gamlet. Gan nandɨ-kɨlɨktɨna lakalakaen, wala tɨmbi nep tɨmbɨ pañgɨtawa.” ");
INSERT INTO nif_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tɨmbi Yesulɨ amatam asuptɨ endok kandañ woñep bɨñgɨlɨñ wɨn yambɨmbi, yal kolanlɨ gwañgwa wolok man ba pawañ masip mɨñguk wakan nɨ-ñombɨmbi nɨñguk, “Natna ganɨ-sipbi ganlet: poñambi, bɨndambo nɨm undane-bɨmbi pɨukañ.” ");
INSERT INTO nif_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Eumbi, yal kolandɨ kwawa embi, gwañgwa tɨmbɨ wopumgan gembɨ kolɨmbi, yal kolan en bim poñañguk. Poñaumbi, kwelan pi wɨpi, dalandan nomɨk palɨmbi, amatam kañgɨlɨñ endoñnan nanin asuptɨ “Kɨmlak” eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gan Yesulɨ gwañgwa kii plon tɨke-mɨlalɨmbi mɨlapi ikuk. ");
INSERT INTO nif_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tɨmbi Yesulɨ it gɨnañ lombi, gwañgwañii gɨt nɨsɨñgan papi nɨ-kañbi eñgɨlɨñ, “Kusei neta nɨndɨ yal kolan wɨn klenep tɨ pɨ kamɨñ?” ");
INSERT INTO nif_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eumbi enguk, “Yal kolan ñandisɨ endɨ nɨmololɨñgot gumañ ep klelok, nepek nolɨ nɨm.” ");
INSERT INTO nif_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Tɨmbi Yesu gɨt gwañgwañii endɨ wɨnanin ñambi, Galili kwet dɨkñembi ñañgɨlɨñ. Ñañɨpi, Yesulɨ gwañgwañii enɨ-daut tɨ-semep nandɨñgukta tɨmbi amalɨ en wandɨñ patak wɨn nɨm nandɨ-ñɨmnelɨñdok nandɨñgukta. Ñañɨpi, ñɨndɨñ enɨ-ta-ñañguk, “Amalok Nɨñan en kanjɨkñii endok kɨsɨ plon kɨmɨlɨmbi wɨlɨ kɨmbekak. Tɨmbi kena nain tɨpet gɨt no tɨmbɨmbi, kɨmnan nanin mɨlalekak.” ");
INSERT INTO nif_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gan gwañgwañii endɨ manda eñguk wolok kusei nɨm nandɨ-daklembi, nɨ-kanelɨñdok mɨsɨmbi biñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tɨmbi ñakap, Kapaneam it kwelan tombi, it gɨnañ lo-taleumbi, Yesulɨ gwañgwañii enɨ-nandɨmbi eñguk, “Telak plon nekta e-tañan tɨlɨñ?” ");
INSERT INTO nif_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Enɨ-nandumbi, endɨ telak plon “Gwañgwa nɨndok boñgɨpnɨnan nindɨ sɨnɨk nɨp maklembi, dama tɨlak?” embi, e-kle-kot-tɨñgɨlɨñda tɨmbi, manda nɨm embi gitakan pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Tɨmbi Yesulɨ pipapi, gwañgwañii 12 kɨtɨ-semum bɨumbi enguk, “Tɨkap ama nolɨ telak dama kuupi nandɨlakta, en wakan enla nandum pɨmbɨñ tɨmbɨmbi, nolii gɨtɨk endok siñgi kle-kumbi, tɨplaplainjɨ kuukak.” ");
INSERT INTO nif_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wɨndɨñ embi, gwañgwa tip no nañgɨp bɨmbi, boñgɨpsɨnan kɨmɨpi, kiilɨ kamai-papi enguk, ");
INSERT INTO nif_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“No endɨ naka tɨmbi gwañgwa ñandingan no not tɨ-ñɨmekta, endɨ nak not tɨ-namek. Tɨmbi no endɨ nak not tɨ-namekta, nakgot nɨm a, nin nanɨ-mukuk en not tɨ-ñɨmek.” ");
INSERT INTO nif_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tɨmbi Yoanelɨ Yesula “Nɨnɨndaut” embi nɨñguk, “Nain nola nɨndɨ ama nolɨ dɨkok koka embi, yal kolan ep kle-kot-semum kañgɨmɨñ. Gan endɨ nɨndoñnan nanin nɨm, wala tɨmbi nɨndɨ kɨmɨsip tɨ-ñɨmkap nɨm kañbi biñgɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Eumbi enguk, “No en kotna embi, kundit gembɨnat tɨlak, wandiñ walɨ nɨtek plon pañgɨtambi, platik nanɨ-kolauk? Wɨndɨñ tɨndɨlok tuop nɨm, wala tɨmbi nɨm kɨmɨsip tɨ-ñɨmnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Neta, no en nɨndok kenanɨla kanjɨk nɨm tɨ-nɨmlakta endɨ nɨndok notnɨ tɨlak. ");
INSERT INTO nif_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tɨmbi no endɨ Mesialok sambatñii kuañda tɨmbi tukgot gɨpi samek, enda nak biañgan sanlet: Yambattɨ plap kena kambakan wandiñ wolok tuan biañgan ombɨ-ñɨmekak. ");
INSERT INTO nif_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Tɨmbi no endɨ gɨñgɨtna koi nɨmnat ñandin no tɨmbɨ pipɨmbi yom tɨlakta, en blangandok. Endɨ kundit kolan wandiñ gama nɨm tɨñɨlɨmbi, nolɨ kawat wopum no tɨkembi, bim plon tembɨ-ñɨmbi, tuk kimbɨñ gɨnañ munjut-kolɨm pɨmbi kɨmbɨmda wɨn kɨndem. Nɨm kañbi, kundit kolan wandiñ tɨmbɨmbi, Yambattɨ kɨnjan mɨlap wopum ombɨ-ñɨmekak. ");
INSERT INTO nif_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tɨkap kɨkalɨ gep tɨmbɨ pipɨmbi yom tɨlañda, kɨka wɨn dombekañ. Wɨndɨñ tɨmbi, kɨka tambongot kukapi, kuñgu taletalen nɨmnat gɨnañ ñaukañ. Nɨm kañbi, kɨka tɨpelatkan kukapi, jɨmbɨñdok komba galk taletalen nɨmnat gɨnañ pɨwɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ba tɨkap kesɨkalɨ gep tɨmbɨ pipɨmbi yom tɨlañda, kesɨka wɨn dombekañ. Wɨndɨñ tɨmbi, kesɨka tambongot kukapi, kuñgu taletalen nɨmnat gɨnañ ñaukañ. Nɨm kañbi, kesɨka tɨpelatkan kukapi, jɨmbɨñnan gep kolɨ pɨwɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ba tɨkap daukalɨ gep tɨmbɨ pipɨmbi yom tɨlañda, dauka wɨn gɨtnei kolekañ. Wɨndɨñ tɨmbi, dauka tambongot kukapi, Yambattok kuñgu taletalen nɨmnat gɨnañ ñaukañ. Nɨm kañbi, dauka gɨtɨk kukapi, jɨmbɨñnan gep kolɨ pɨwɨñ. ");
INSERT INTO nif_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Jɨmbɨñ wandɨñ siñgin gawat taletalen nɨmnat palekak: wandɨñ bɨnem amalok gaumjɨ nañ endɨ nɨm kɨmnekalɨñ, ba kombalɨ papat kwambɨñ dɨmbi ei-ta-ñaukak.” ");
INSERT INTO nif_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yesulɨ wɨndɨñ embi enguk, “Siundɨlo tɨñɨpi, simu tapma plon kɨmɨkañ walɨ Yambattok dainan tapma tɨmbɨ kɨndem dalak. Wɨndɨñgangot Yambattok dainan kɨndem daneñdok komba dɨndɨnlɨ amatam nɨndɨ gɨtɨk inda-nɨmlak. ");
INSERT INTO nif_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Simu wɨn nepek kɨndem sɨnɨk. Gan, tɨkap simulok koñgom gembɨn pailekta, nombo kɨndem dawɨktok nepek no tuop nɨm tɨneñ. Wala tɨmbi sɨndɨ nosiilok boñgɨpsɨnan simu koñgom gembɨnnat nomɨk kumbi, ep kiupi busukñanengan kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Tɨmbi Yesulɨ gwañgwañii gɨt kwet wɨnanin yousɨm ñambi, Judia kwelan ba Joldan tuk tambon kandañ ñañguk. Ñañɨlɨmbi, amatam kɨmɨn no kɨmɨn no bɨndambo endoñ bɨmbi kɨmɨn tɨañgɨlɨñ. Tɨmbi kena pat-tɨlɨñguk wɨndɨñgangot bɨndambo enɨ-daut tɨ-sem-ta-kuñguk. ");
INSERT INTO nif_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tɨmbi Falisi ama dɨwɨndɨ bɨmbi, Yesu tue-kañbi tɨ-ñɨmnep nandɨñɨpi nɨ-kañbi eñgɨlɨñ, “Endɨkñe mandalɨ ama nolɨ kɨndem tamɨn kle-kolektok elak ba nɨtek?” ");
INSERT INTO nif_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Eumbi manda tambane-enguk, “Moselɨ sosiila endɨkñe manda nɨtek kɨmɨt-semguk?” ");
INSERT INTO nif_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eumbi nɨñgɨlɨñ, “Moselɨ ñɨndɨñ nandɨ-semguk: ama no endɨ tamɨn biup nandɨmbi, endok kusei pepa plon youp mɨmbi, kɨndem nɨ-kleuk.” ");
INSERT INTO nif_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Eumbi tambane-enguk, “Gɨnañ kwambɨndanjɨla Moselɨ endɨkñe manda wɨn youpi kɨmɨt-samguk. ");
INSERT INTO nif_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gan nain kusei kɨmɨkɨmɨlɨnan wɨn wɨndɨñ nɨm pakuk. Moselɨ ñɨndɨñ youkuk, ‘Yambattɨ ama ep tɨmbɨ indañguk wolonda endɨ ama gɨt tam indañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Kusei wala tɨmbi amalɨ meñ beu yambimbi, tamɨnloñ galɨ-kwambɨñ daumbi, ");
INSERT INTO nif_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","pɨñgɨp noñgan indayamɨk.’ Wɨndɨñ youyoulɨn patakta tɨmbi, ama gɨt tam endɨ nombo tɨpet nɨm tɨndemɨk. Endɨ wapatam tɨmbi, pɨñgɨp noñgan patemɨk. ");
INSERT INTO nif_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wala tɨmbi wapatam Yambattɨ ep kiukuk wɨn amalɨ nɨm tambɨlek.” ");
INSERT INTO nif_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tɨmbi Yesulɨ gwañgwañii gɨt bɨndambo ilan ña-palɨñɨpi, wapatam tambo ka-mɨsɨ-tañ wolok nɨ-nandumbi ");
INSERT INTO nif_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","tambane-enguk, “No endɨ tamɨn ka-mɨsɨmbi, tam komblin tɨlakta, ama walɨ wakan tamɨn kolan tɨ-ñɨmbi, Yambattok dainan telak joñgo kulak wakan. ");
INSERT INTO nif_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ba tam nolɨ wapai ka-mɨsɨmbi, ama komblin tɨlakta, endɨ bo wɨndɨñgangot telak joñgo kulak wakan.” ");
INSERT INTO nif_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tɨmbi amatamdɨ wembe gwañgwa tiptip Yesulɨ ep kawɨktok yanañgɨp bɨñgɨlɨñ. Bɨñɨlɨmbi, gwañgwañiilɨ kɨmɨsip tɨ-sembi enombɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wɨndɨñ tɨmbɨmbi, Yesulɨ yambɨm gɨnañ komba dɨumbi enguk, “Sɨndɨ wembe gwañgwa yambiumbi nokoñnan bɨwɨt! Yambattɨ ama ñandisɨ wakan enlok gɨñgɨt yambɨ-dɨkñelak, wala tɨmbi nombo nɨm kɨmɨsip tɨ-semnekalɨñ! ");
INSERT INTO nif_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nak biañgan sanlet: no endɨ wembe gwañgwalok tuop Yambattok kapmainan nɨm kulakta, endɨ wakan Yambattok gɨñgɨt nɨm.” ");
INSERT INTO nif_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wɨndɨñ embi, wembe gwañgwa noñgan noñgan ep ya-apbi, kiilɨ kumbanjɨ plon kɨmɨpi, ep gwɨlam tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tɨmbi Yesulɨ gwañgwañii gɨt telak kusei kɨmɨp ñanep tɨñɨlɨmbi, ama nolɨ endoñ woñep bɨmbi mɨlele-tɨ-ñɨm nɨ-nandɨmbi eñguk, “Endaut kɨndem. Nak nɨtek tɨmbi, kuñgu taletalen nɨmnat kasɨleutat?” ");
INSERT INTO nif_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Eumbi tambane-nɨñguk, “Kusei nekta naka kɨndem nanɨlañ? Ama nolɨ kɨndem nɨm, Yambat en noñgandɨ kɨndem. ");
INSERT INTO nif_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Dɨk endɨkñe manda Yambattɨ kɨmɨt-nɨmɨñguk wolok kusei ip nandɨlañ: ‘Dɨk ama wɨlɨ kɨm nɨm tɨmbekañ. Telak joñgo nɨm kuukañ. Kumbu nɨm tɨmbekañ. Ama joñgo siñgin nɨm siukañ. Ama nolok nepek joñgo nɨm tɨmbɨ pailɨm tɨke-ñɨmekañ. Dɨk nain tuop meñga bekala nandɨ-semum loloñ tɨndekamɨk.” ");
INSERT INTO nif_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Yesulɨ wɨndɨñ eumbi nɨñguk, “Endaut. Nak gwañgwa sim papi kusei kɨmɨp, endɨkñe manda wɨn gɨtɨk ikan tañgonembi kɨmɨt-kle-ta-bɨlet.” ");
INSERT INTO nif_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesulɨ dɨndɨmgan kambi, wale kɨndemda nandɨ-ñɨmbi nɨñguk, “Dɨk nepek noñgan walañgot tɨpɨkalañ. Wala tɨmbi dɨk ñam nepenepeka gɨtɨk tualok kɨmɨt-taleumbi, mɨnem gamnekalɨñ wɨn epmbi, ama pɨmbɨñesɨla emumek, tuan wopum kunum gɨnañ pat-gamekak. Wɨndɨñ tɨmek bɨmbi, nak nep kle-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ama walɨ mandan wɨn nandum mɨlataumbi, timan dai kolañguk. Endɨ il ba kenañ asup palɨmguk wɨ nɨm biuptok nandɨm gɨnañ mɨlataumbi, kak bim ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tɨmbi Yesulɨ gwañgwañii tɨkɨle-yambɨmbi enguk, “Ama kwɨlɨkwɨlɨnjɨat Yambattok gɨñgɨt indanep nandañda endɨ kena kwambɨñ tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Wɨndɨñ eumbi nandɨm nandɨ-sɨlɨkñeñgɨlɨñ. Tɨmbi Yesulɨ yousɨm “Nɨñanai” embi, nombo ñɨndɨñ enguk, “No endɨ Yambattok gɨñgɨt indaup nandɨlakta endɨ kena kwambɨñ tɨmbekak. ");
INSERT INTO nif_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel nolɨ lɨk bem gɨnañ tip wolok ña tombepi nandɨwɨmda, endɨ kena kwambɨñ tɨmbek. Tɨmbi ama kwɨlɨkwɨlɨlɨn wopum no endɨ Yambattok gɨñgɨt indaup nandɨlakta, endɨ wɨndɨñgot kena kwambɨñ tɨlak, gan endok kenañlɨ kamellok kenañ maklembi mɨlata-ñɨmekak.” ");
INSERT INTO nif_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Eumbi, gwañgwañiilɨ kolan sɨlɨkñembi, nɨsɨñgan e-nandɨ-tɨmbi eñgɨlɨñ, “Mɨlap wandiñda, nindɨ kuñgu taletalen nɨmnat wɨn tuop kasɨlewɨk?” ");
INSERT INTO nif_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Tɨmbi Yesulɨ dɨndɨmgan yambɨmbi enguk, “Ama endɨ nɨsɨlok gembɨnjɨla tuop nɨm, gan Yambattɨ kɨndem ep mek. En wakan nepenepek gɨtɨk tuop tɨ-taleuk.” ");
INSERT INTO nif_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wolongan Petlolɨ nɨñguk, “Yakñe! Nɨndok kandañ nɨtek? Nɨndɨ nepenepeknɨ gɨtɨk bi-talem bɨmbi, dɨk gep kle-kuamɨñ wɨn.” ");
INSERT INTO nif_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Eumbi enguk, “Nak biañgan sanba: no endɨ natnala ba gɨñgɨt manda kɨndemla tɨmbi il ba dalii ba kwayañii ba dalañii ba wiwii ba meñ beu ba gwañgwa bɨsatñii ba nana kenañ gɨtɨk bi-taleñguk, ");
INSERT INTO nif_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","endɨ wakan il gɨt dalii gɨt kwayañii gɨt dalañii gɨt wiwii gɨt meñii gɨt gwañgwa bɨsatñii gɨt nana kenañ inda-ñɨmbi, yousɨm nombo wopumgan inda-ñɨmekak. Tɨñɨpi, man kwelan ñolok naka tɨmbi kena gɨm mɨumbi, kunumdok kuñgu kusei kɨmɨlekak wolonda kuñgu taletalen nɨmnat inda-ñɨmekak. ");
INSERT INTO nif_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Nain wolonda ama man ñɨndɨñgɨt amatamdok dausɨnan damandama tañ endoñnan nanin asuptɨ siñgi patnekalɨñ. Tɨmbi siñgi sɨnɨk endok kandañ asuptɨ dama patnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tɨmbi endɨ Jelusalem it kwelan lonelɨñdok telak klem ñañgɨlɨñ. Yesu endɨ telak dama tɨ-semumbi, gwañgwañiilɨ endok kundit wɨ kañ nandɨ-bendɨ-tɨmbɨmbi, amatam ep kle-ñañgɨlɨñdɨ mɨsɨmɨsɨ plon ñañgɨlɨñ. Ñakap, Yesulɨ gwañgwañii 12 nɨsɨñgan bɨndambo ep kɨmɨn tɨmbi, enlok plon nepek inda-ñɨmekak wolok manda enɨ-dakle-semguk. Enɨ-dakle-semñɨpi, ");
INSERT INTO nif_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ñɨndɨñ enguk, “Sɨndɨ nandañ. Nɨndɨ Jelusalem it kwelan loamɨñ. Lo-tomnambi, Amalok Nɨñan wɨn tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama endok kɨsɨ plon kɨmɨlɨmbi, wɨlɨ kɨmbektok manda eu talembi, Roma amalok kɨsɨ plon kɨmɨtnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kɨmɨlɨmbi tɨ-lakalaka e-tɨ-ñɨmbi, manjɨ iwɨttɨ suambap bɨt gwɨlap pɨsɨkñattɨ waipbi wɨlɨ kɨmbekak. Tɨmbi maim tɨpet gɨt no tɨmbɨmbi, kɨmnan nanin mɨlalekak.” ");
INSERT INTO nif_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tɨmbi Sebedilok nɨñañiit tɨpet, Yakobo gɨt Yoane, endɨ Yesuloñ bɨmbi nɨñgɨmɨk, “Nɨnɨndaut. Nɨtɨ nepek nola ba nola endetamɨk wɨn dɨk nandɨmbi tɨ-nɨmeñdok nandamɨk.” ");
INSERT INTO nif_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Eumbi enguk, “Nak sɨta nek tɨ-samettok nandamɨk?” Enɨ-kaumbi, ");
INSERT INTO nif_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ama wapmañ patep nandɨñgɨmɨkta ñɨndɨñ nɨñgɨmɨk, “Dɨk inda-daklembi, amatam indangan yambɨ-dɨkñeukañ, nain wolonda nandɨ-nɨmumbi, nɨtoñ nanin nolɨ kɨka dɨndɨmnan, nolɨ kɨka kepmanan pipatekamɨk.” ");
INSERT INTO nif_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Gan Yesulɨ enguk, “Sɨtɨ manda eamɨk wolok kusei nɨm nandɨ-daklembi nanɨamɨk.” Endɨ wɨndɨñ embi, yousɨm mɨlap bemep tɨlak wolok ñɨndɨñ enguk, “Nak tuk kimbɨñ nambetat wɨn sɨtɨ gɨla nandekamɨk ba? Ba tuk iutat wɨn sɨtɨ gɨla indekamɨk ba?” Yesulɨ wɨndɨñ enɨ-kaumbi, ");
INSERT INTO nif_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Nɨtɨ tuop” eñgɨmɨk. Eumbi enguk, “Biañgan. Natna tuk nambetat wɨn sɨtɨ bo nandekamɨk, ba tuk iutat wɨn sɨtɨ bo indekamɨk. ");
INSERT INTO nif_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Gan nindɨ kɨtna sɨnɨk kandañ ba kɨtna kepma kandañ pipalekak wɨn nak ewa taleuktok tuop nɨm. Pipapipat wɨn Yambat en ikan tɨ-kɨliñ embi eu tale-semguk.” ");
INSERT INTO nif_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tɨmbi gwañgwañii kɨt tambon tambon endɨ manda wɨn nandɨmbi, Yoane gɨt Yakobo enda gɨnanjɨ komba dɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Tɨmbi Yesulɨ enɨ-tiañeum bɨumbi enguk, “Sɨndɨ nandañ, kwet tuop yambɨ-dɨkñe ama ba ama loloñ endɨ gɨñgɨtjii kɨndem nɨm pat-yambɨ-dɨkñeañ. Endɨ ama kunduwat, amatam endok kapmainan kuañda nandɨ-semum nɨsɨlok kena gwañgwa sɨlanin sɨnɨk tɨmbɨmbi, kena gɨm pat-emañ. ");
INSERT INTO nif_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gan sɨndok boñgɨpsɨnan wɨndɨñ nɨm inda-samektok sanlet. No endɨ sɨndok boñgɨpsɨnan ama wopum indaup nandɨlakta, endɨ tɨplaplapsɨ kuukak, ");
INSERT INTO nif_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ba telak damanjɨ kuup nandɨlakta, amatam gɨtɨk endok kena gwañgwa sɨlanin kuukak. ");
INSERT INTO nif_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ama Sɨsɨnɨk endɨ bo wɨndɨñgangot kulak. Endɨ amatam tɨplaplae tɨ-ñɨmnelɨñdok nɨm, endɨ tambon tɨplaplae tɨ-sembi, amatam asup endok kɨnjan kɨmbi, yomsɨlok tuan ombɨ-tale-semektok indañguk.” ");
INSERT INTO nif_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tɨmbi Yesulɨ gwañgwañii ba amatam kɨmɨn wopum gɨta Jeliko it kwelan bɨ tombi dɨkñem ñañguk. Wɨnanin ñañɨlɨmbi, ama no dai kolan amatamda mɨnem ba nanañla kɨtɨnat tɨ-kuñguk koi Batimaio, Timaiolok nɨñañ, endɨ telak pawañ pipakuk. ");
INSERT INTO nif_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Pipalɨñɨlɨm nɨmbi eñgɨlɨñ, “Yesu Nasalet nanin endɨ bɨlak.” Nɨmbɨ nandɨm kusei kɨmɨpi, Yesu Mesialok koi no plon kɨtɨ-ñɨmbi eñguk, “Yesu, Devittok Nɨñañ, dɨk blan tɨ-namɨñ!” Gembɨnat kɨtɨ-palɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","amatam asuptɨ nɨ-ñombɨmbi nɨñgɨlɨñ, “Gitakan pat!” Gan endɨ kwambɨñgan kɨtɨmbi eñguk, “Devittok Nɨñañ-o, blan tɨ-namɨñ!” ");
INSERT INTO nif_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wɨndɨñ eumbi, Yesulɨ bɨ ipi enguk, “Kɨtɨ-ñɨmɨm bɨwɨn.” Eumbi, ama dai kolan kɨtɨ-ñɨmbi nɨñgɨlɨñ, “Nɨm mɨsɨwɨñ. Endɨ kɨtɨ-gamlak. Mɨlapi ñau!” ");
INSERT INTO nif_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Eumbi, sauloñ kolɨ palɨmbi, dɨkop mɨlapi, Yesuloñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ñaumbi, Yesulɨ nɨ-nandɨm eñguk, “Nak nek tɨ-gamɨttok bɨlañ?” Eumbi nɨñguk, “Nandaut loloñ. Nak nombo deiup nandɨlet.” ");
INSERT INTO nif_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Eumbi nɨñguk, “Kɨndem a, ñau! Nanandɨ-kɨlɨktɨñgalɨ gep tɨmbɨm kɨndem dalañ.” Eumbi, wolongan ama wolok dai kɨndem daum deimbi, Yesu klem telak ñañguk tuop ñañguk . ");
INSERT INTO nif_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tɨmbi Yesu gɨta gwañgwañii endɨ lo-ñakap, Jelusalem it kwet tɨmbɨ dumalaumbi, kwet jañgɨn koi Oliv wolok loñgɨlɨñ. Loñɨpi, it kwet tɨpet, Betfage gɨt Betani, wandɨñ lo-tombi, Yesulɨ gwañgwañiit tɨpet enɨ-mupi ");
INSERT INTO nif_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","enguk, “Sɨtɨ it kwet da patak wolok ñandekamɨk! Ñam lombi, wolongan doñki nɨñañ toalɨ top bimbin kandetamɨk. Doñki endok plon ama nolɨ no nɨm pipapi ñañguk. Kañbi pɨsap nañgɨpi bɨwɨt! ");
INSERT INTO nif_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tɨkap nimbek nolɨ sambɨmbi, ‘Sɨtɨ neta wɨndɨñ tamɨk?’ eumbi, ñɨndɨñ nɨndekamɨk, ‘Molomdɨ kena mɨmbi, platik kɨmɨlɨ undanem bɨutak.’” ");
INSERT INTO nif_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yesulɨ wɨndɨñ eumbi ñam, doñki nɨñañ telak yamanan top bimbin kañbi pɨsakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pɨsat-palɨñɨlɨmbi, ama dɨwɨn wolok ikɨlɨñ endɨ enɨ-kañbi eñgɨlɨñ, “Sɨtɨ nek tɨndepi, toa pɨsakamɨk?” ");
INSERT INTO nif_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Enɨ-kaumbi, Yesulɨ manda eñguk wɨndɨñgan tambane-engɨmɨk. Eumbi yambium, ");
INSERT INTO nif_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","doñki nɨñañ Yesuloñ nañgɨpi ñañgɨmɨk. Ña-tombi, saulonjɨ kiundɨp doñkilok plon kɨmɨlɨmbi, Yesulɨ wolok plon lo-pipapi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tɨmbi amatam asuptɨ Yesu koi gɨñgɨt tɨke-lonelɨñdok saulonjɨ telak plon samba eñgɨlɨñ, dɨwɨndɨ kli sap kena gɨnañ nanin dombɨ mep bɨmbi, wɨndɨñgot telak plon ipaneñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tɨmbi amatam Yesu telak plon siñgi dama tɨm kle-ñañgɨlɨñ endɨ ñɨndɨñ kɨtɨmbi nɨ-tɨke-loñgɨlɨñ, “Yambattok koi tɨke-lowɨt! Ama ñɨn Molomdok koi plon nɨ-mulɨmbi bɨ indalak en nɨ-kɨndekɨndem ewɨt! ");
INSERT INTO nif_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Sotnɨ Devit endɨ gɨñgɨtñii kɨndem yambɨ-dɨkñeñguk, wɨndɨñgangot ama ñalɨ tɨ-nɨmekak, wala tɨmbi en nɨ-kɨndekɨndem ewɨt! Yambat kunum gɨnañ patak endok koi tɨke-lona!” ");
INSERT INTO nif_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesulɨ Jelusalem it kwelan lo-tombi, tapma it sañ simba gɨnañ loñguk. Lombi, nepek gɨtɨñgɨtɨk ka-nandɨ-tɨ-talembi, kwet kɨlɨm eumbi pɨm gwañgwañii 12 gɨt Betani it kwelan lombi douñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kwet salaumbi, Jelusalem ñanelɨñdok Betani it kwet bimbi, telak plon ñañɨpi, Yesulɨ nanañ gawat tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tɨmbi deium ñaumbi, komba koi fik no sakñat kañbi, “Bien patak bek?” embi ñam lonjɨñguk. Gan bien indainda nain nɨm indañgukta, sakgot pakuk. ");
INSERT INTO nif_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wandin kañbi, komba wala nɨñguk, “Dɨkok nana bien wɨn ama nolɨ nombo nɨm nambekak.” Eumbi, yala manda wɨn gwañgwañiilɨ nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ñakap, Jelusalem it kwelan lo-tomgɨlɨñ. Tombi, Yesulɨ tapma it sañ simba gɨnañ lombi, nepenepeksɨ tapma tɨndɨlok tuañgɨlɨñ yambɨñguk. Yambɨmbi nandum pɨ-sɨnɨk taumbi, kusei kɨmɨp ep kleñguk. Ep klembi, ama mɨnem tambo mɨ kena tɨñgɨlɨñ endok kɨmɨkɨmɨtsɨ ba ama mambaip pat-tuañgɨlɨñ endok gembanjɨ ep wɨlɨ tombokuk. ");
INSERT INTO nif_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tɨñɨpi, tapma it sañ simba gɨnañ nepek no tɨke-ña-bɨt nɨm tɨnelɨñdok kɨmɨsip tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tɨmbi amatam enɨ-daut tɨ-sembi eñguk, “Kwet ñolok plon Yambattok manda ñɨndɨñ youyoulɨn patak, ‘Itna ñɨn kwet tuop amalok nɨmolo it tɨmbekak.’ Gan sɨndɨ it ñɨn tɨmbɨmbi, kumbu ama sañan endok kawat tombañ wandiñ tɨlak.” ");
INSERT INTO nif_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Amatam kɨmɨn wopumdɨ Yesu manda enɨ-daut tɨ-semguk wɨn nandɨmbi nandɨ-sɨlɨkñe-tɨñgɨlɨñ. Tapma ama biesɨ gɨt endɨkñe manda nandɨ-tale ama endɨ wɨndɨñ nandɨmbi, Yesu nepek nek tɨñguk ba eñguk wolok gɨñgɨt nandɨmbi, amatamdɨ Yesuloñ kandañ ña galɨ-talenelɨñ wala mɨsɨmbi, wɨlɨ kɨmnelɨñdok telak e-lonjɨ-tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tɨmbi Yesu gɨt gwañgwañii endɨ kwet kɨlɨm eumbi tuop Jelusalem it kwet bimbi ñaañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kwet salaumbi, Jelusalem undane-ñañɨpi, fik komba wɨn pakuknan bɨndambo ña-tombi kañgɨlɨñ: komba walɨ kakainan kusei kɨmɨpi yañeta-lo-taleñguk. ");
INSERT INTO nif_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Tɨmbi Petlolɨ wɨ kañbi, Yesulɨ komba nɨ-ñombɨñguk wɨn nandɨ-sɨwɨpi nɨñguk, “Nɨnɨndaut, ñɨ ka! Komba nɨ-suambakuñ wɨn yañeta-talelak.” ");
INSERT INTO nif_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eumbi tambane-enguk, “Sɨndɨ Yambattɨ nepenepek gɨtɨkkan tuop tɨ-taleuk wɨn nandɨ-kwambɨñ dambi kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nak biañgan sanlet: tɨkap ama nolɨ kwet jañgɨn ñala ‘Mɨlapi, tuk kimbɨñ gɨnañ pɨ!’ embi, wɨndɨñ indauptok nandɨ-kwambɨñ dambi, gɨnañ tɨpet nɨm tɨlakta, wolok tuopgan inda-ñɨmekak. ");
INSERT INTO nif_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wɨndɨñda ñɨndɨñ sanba nandɨwɨt: sɨndɨ nɨmolo tɨñɨpi, nepek wala ba wala Yambat nɨ-nandumbi nandɨ-samekak wɨndɨñ nandɨ-kwambɨñ dambi kuañda, bien wolok tuopgan inda-samekak. ");
INSERT INTO nif_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Besɨ kunum gɨnañ patak endɨ sɨndok ep tɨndɨnjɨ kolan wɨn bi-samektok sɨndɨ nain tuop nɨmolo tɨñɨpi, dama nosɨ nola nandɨ-kola tɨ-ñɨmañ wɨn bi-ñɨmnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Tɨmbi Yesulɨ bɨndambo gwañgwañii gɨt Jelusalem it kwelan ña-tombi, tapma it sañ simba gɨnañ lom wandɨñ ñañambɨt tɨñguk. Tɨñɨlɨmbi, tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama gɨt ama biesɨ dɨwɨn endɨ endoñ bɨm ");
INSERT INTO nif_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","nɨ-kañbi eñgɨlɨñ, “Dɨk kundit ñandin tɨlañ wɨn gembɨ ba nanandɨ denanin tɨkembi pat-tɨlañ? Ba nindok manla pat-tɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Eumbi enguk, “Nak wɨndɨñgangot manda noñgan sɨnɨk sanɨ-nandutet. Wɨ nanbɨmek, nak nindok manla kundit tɨlet wɨn tambon sanɨ-dakleutet. ");
INSERT INTO nif_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yoane tuk i-sem-i-sem endɨ kena tɨñguk wɨn kunumdok ep tɨndɨn ba amalok ep tɨndɨn? Wɨn nanɨmbɨmbi nandɨwa.” ");
INSERT INTO nif_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wɨndɨñ eumbi, nɨsɨñgan e-tañan tɨmbi eñgɨlɨñ, “Nɨndɨ ‘kunumdok ep tɨndɨn’ wɨndɨñ enambi eutak, ‘Tɨmbi neta endok mandan nɨm nandɨ-kɨlɨktɨ tɨ-ñɨmgɨlɨñ?’ ");
INSERT INTO nif_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Gan nombo ‘amalok ep tɨndɨn’ wɨndɨñ enambi, amatamdɨ nɨtek tɨ-nɨmnetañ?” Wɨndɨñ embi mɨsɨñgɨlɨñ. Nekta, amatam gɨtɨktɨ Yoanela nandum plofet biañgan tɨñgukta tɨmbi. ");
INSERT INTO nif_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wɨndɨñda endɨ Yesu ñɨndɨñ tambane-nɨñgɨlɨñ, “Yoanelɨ kena tɨñguk wɨn kunumdok ep tɨndɨn ba amalok ep tɨndɨn wɨn nɨndɨ nɨm nandamɨñ.” Eumbi enguk, “Ale, wɨndɨñda nak bo nindok mandala kundit pat-tɨlet wɨn nɨm sanbetet. ");
INSERT INTO nif_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Tɨmbi Yesulɨ kusei kɨmɨpi, eyout mandalɨ manda enguk. Eñɨpi, ñɨndɨñ enguk, “Ama nolɨ kwet nolok wain kap tɨpimbi, dɨm kwambɨñ tɨñguk. Tɨmbi wain tul wɨsɨ-dottok kwet no kɨndipi, kawattɨ it ombap kloñ no kena ka-dɨkñelok kɨndilɨm ikuk. Tɨmbi endɨ wain bien dɨwɨn gama indaum epeplok nandɨñɨpi, ama dɨwɨn enbɨ taleumbi, kena gɨtɨk kɨsɨ plon kɨmɨkuk. Kɨmɨpi, ama en il kusei bimbi, kwet mayañgan sɨnɨk ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ña-kuñɨlɨmbi, wain bien indaumbi, mepmeptok nain indañguk. Indaumbi, kena molomdɨ kena gwañgwa no wain bien dɨwɨn ep bɨ-ñɨmektok nɨ-mulɨm ñambi, kena ka-dɨkñe amaloñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ña-tombɨmbi, ka-dɨkñe ama endɨ bien nɨm mɨmbi, endɨ gwañgwa wɨn tɨkem wɨpi, molomloñ sɨlak nɨ-mulɨmbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Undane-ñaumbi, molomdɨ kena gwañgwa no bɨndambo nɨ-mulɨmbi ñañguk. Ñaumbi, kumbam wɨlɨ tawaumbi, kundit mayetan tɨ-ñɨmɨumbi, molomloñ undane-ñañguk. Ñaumbi, ");
INSERT INTO nif_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","molomdɨ kena gwañgwa no bɨndambo nɨ-mulɨmbi, ka-dɨkñe endok kandañ ña-tombɨmbi wɨlɨ kɨmguk. Gan molomdɨ wandiñgan embi, kena gwañgwa asup bɨndambo enɨ-mulɨm ñañgɨlɨñ. Ñaumbi, endok plon wɨndɨñgangot ka-dɨkñelɨ kanjɨk tɨ-sembi, dɨwɨn sɨlak yandɨpbi, dɨwɨn yandɨp kɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Tɨmbi molom enlok ama noñgan ku-ñɨmɨñguk, wɨn enlok nɨñañ noñgan sɨnɨk en wakan gɨnañlɨ nandɨ-koñgom tɨ-ñɨmlɨñguk. Gan enda ñɨndɨñ kɨmɨt-nandɨ-ñɨmbi eñguk, ‘Ka-dɨkñe amalɨ natnalok nɨñana sɨnɨk en kañbi, nandum loloñ tɨmbɨm wain bien mɨmbi, nɨm wɨlɨ kolaukak.’ Wɨndɨñ nandɨmbi, siñgi sɨnɨk nɨñañ engan ka-dɨkñe amaloñ nɨ-mulɨmbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gan ka-dɨkñe kolasɨ endɨ nɨñañ wɨn kañbi, nɨsɨñgan ñɨndɨñ e-nandɨnandɨ tɨmbi eñgɨlɨñ, ‘Yakñesii, endɨ wakan kukapi, kena ñɨn kasɨleukak, wala tɨmbi wɨtnam kɨmbɨmbi, kena ñɨn nɨndok gɨñgɨt tɨmbekak.’ ");
INSERT INTO nif_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wɨndɨñ eñɨpi tɨke-wɨlɨ kɨmbɨmbi, kena pawañ joñgo kolɨm pɨñguk.” ");
INSERT INTO nif_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesulɨ eyout manda wɨndɨñ tɨ-sem-talembi enɨ-nandɨm eñguk, “Sɨndɨ nɨtek nandañ? Kena molom endɨ gɨñgɨt wɨn nandɨmbi, nɨtek tɨmbekak? Endɨ bɨ-tombi, ka-dɨkñe kolan yandɨp kɨmbi, ka-dɨkñe komblin bɨndambo ep indambi, wain kenañ endok kɨsɨ plon kɨmɨlekak.” ");
INSERT INTO nif_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yesulɨ wɨndɨñ embi, yousɨm enla manda ñɨndɨñ embi enɨ-nandɨñguk, “Yambattok manda youyoulɨn patak ñɨn sɨndɨ gama nɨm pinat-nandɨñgɨlɨñ bek? ‘It ta no it tɨndɨ amalɨ kenan nɨmnat embi siñgi wɨlɨmgɨlɨñ walɨ ta dɨwɨn yapma klembi, it tɨke-kwambɨñ dalak. ");
INSERT INTO nif_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Wɨn Wopumdɨ tɨmbɨ indaum kanambi, kundit gɨtikñin tɨlak.’” ");
INSERT INTO nif_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Yesulɨ wɨndɨñ eumbi, ama biesɨlɨ “Eyout manda wɨn nɨnla elak” nandɨ-daklembi, tɨkenelɨñdok nandɨñgɨlɨñ, gan amatam kɨmɨn wopum endɨ mik tɨ-semnelɨñ wala mɨsɨmbi, kak, kañbimbi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tɨmbi Juda ama biesɨlɨ Falisi ama dɨwɨn gɨta Elottok nolii dɨwɨn Yesu mandalɨ sɨsoñ tɨ-ñɨmnelɨñdok enɨ-mukɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Enɨ-mulɨmbi, Yesuloñ bɨm nɨmbi eñgɨlɨñ, “Endaut. Nɨndɨ dɨkok kusaka nandamɨñ: dɨk manda juluñɨt nɨm pa elañ. Dɨk loloñ ba pɨmbɨñ gɨtɨkkan sɨnɨk Yambattok telak dɨndɨm nɨnɨ-daut tɨ-nɨmbi, amalɨ nɨtek nandɨ-gamnelɨñ wala nɨm mɨsɨlañ. Ñala eumbi nandɨna: nɨndɨ Sisa, Roma kwettok ama wapmañ mayañgan sɨnɨk patak, enda takis mɨnem mɨnambi walɨ tuop tɨlak ba nɨm? ");
INSERT INTO nif_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Wɨn mɨlok ba nɨm mɨlok?” Wɨndɨñ eumbi, Yesulɨ juluñɨtsɨlok kusei nandɨ-daklembi enguk, “Sɨndɨ neta mandalɨ sɨsoñ tɨ-namañ? Sɨndɨ mɨnem kwandai satnin no tɨmbɨ indaumbi, daut namumbi kawa.” ");
INSERT INTO nif_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Eumbi, mɨnem tɨke-bɨm mɨum kañbi enɨ-nandɨmbi eñguk, “Ama walan ba kot kundit wɨn nindoñ?” Eumbi, endɨ “Sisaloñ” nɨñgɨlɨñ. Wɨndɨñ nɨmbɨmbi ");
INSERT INTO nif_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","enguk, “Sisalok gɨñgɨt wɨn Sisa enla tambon mɨnekalɨñ, ba Yambattok gɨñgɨt wɨn Yambat enla tambon mɨnekalɨñ.” Wɨndɨñ eñɨpi, ama biesɨlok sɨsoñ makleumbi, ka-piasat tɨ-ñɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tɨmbi Sadusi ama dɨwɨndɨ Yesuloñ bɨñgɨlɨñ. Endɨ kɨmnan nanin mɨlamɨlat wɨn nɨm patak eñɨpi enɨ-daut tɨ-sem-ta-kuañ. Endɨ Yesuloñ bɨmbi nɨ-nandɨm eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Endaut. Moselɨ Juda amatam nɨnda manda ñɨndɨñ yout-nɨmguk, ‘Ama nolɨ tam tɨkembi, yamɨn pap sembekta, kwayañlɨ dallok kanjalɨ tɨkembi, dallok gwañgwa bɨsat ep tɨmbɨ indanekalɨñ.’” ");
INSERT INTO nif_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Sadusi amalɨ wɨndɨñ embi yousɨm nɨñgɨlɨñ, “Damañgan dakwaya kɨt tambon tɨpet kuñgɨlɨñ. Endoñnan nanin tua endɨ dama tam tɨmbi, komblin nɨmnat, yamɨn papi sembɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sembumbi, monalɨ dallok kanjalɨ tɨkembi, wɨndɨñgangot yamɨn papi sembɨñguk. Sembumbi, gwik endok plon wɨndɨñgangot inda-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Dakwaya kɨt tambon tɨpet endɨ tam wakangot tɨkembi, yamɨn gɨtɨk papi sembɨ-taleñgɨlɨñ. Tɨmbi siñgi sɨnɨk kanjaksɨ walɨ wɨndɨñgot sembɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ama kɨt tambon tɨpet gɨtɨkkandɨ tam wakangot tɨkeñgɨlɨñda. Tɨkap, mɨlamɨlat nain indaukak, nain wolonda tam wɨn nindok sɨnɨk tɨmbekak?” ");
INSERT INTO nif_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sadusi amalɨ wɨndɨñ eumbi, Yesulɨ enguk, “Sɨndɨ Yambattok manda wolok kusei ba Yambattok gembɨn nɨm nandɨ-kɨliñ eañ bek, wala tɨmbi kɨmnan nanin mɨlamɨlata nandumbi kelam dalak? ");
INSERT INTO nif_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Amatamdɨ kɨmnan nanin mɨlapi, wapatam nɨm indanekalɨñ. Endɨ kunumdok añelo nomɨk sɨlak kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Tɨmbi Yambattɨ amatam kɨmnan nanin ep mɨm mɨlatnekalɨñ ba nɨm, wolok sɨndɨ Moselɨ kasat ñɨn youkuk wɨn nɨm pinat-nandañ ba? Mose endɨ komba tip no wolok plon komba manben indaum kañbi ñañguk. Ñaumbi, Yambattɨ ama ikan sembɨñgɨlɨñ endok plon ñɨndɨñ nɨñguk, ‘Nak Ablaamdok Yambat, Isakalok Yambat, Yakobolok Yambat, nak endok Yambatsɨ patet.’ Yambattɨ wɨndɨñ eñɨpi, ");
INSERT INTO nif_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ñɨndɨñ eu dakleñguk: endɨ sembɨsembɨndok Yambat nɨm a, endɨ kaik kuañ endok Yambat. Nekta, ama sembɨ-taleñgɨlɨñ endɨ bo Yambattok dainan kaik kuañda tɨmbi. Wɨndɨñda sɨndɨ mɨlamɨlat nɨm patak eañda, biañgan nandum kamalalak.” ");
INSERT INTO nif_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tɨmbi Yesu gɨt Sadusi ama endɨ manda e-kle-kot-tɨ-palɨñɨlɨmbi, endɨkñe manda nandɨ-tale ama no wolok bɨm yambɨñguk. Yambɨmbi, Yesulɨ manda tambon kɨndemgot tambane-enbɨm nandɨñgukta nɨ-kañbi eñguk, “Yambattɨ endɨkñe manda gɨtɨk kɨmɨt-nɨmɨñguk, tɨmbi nek ñalɨ dama tɨ-sembi, dɨwɨn gɨtɨk yapma kle-talelak?” ");
INSERT INTO nif_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Eumbi tambane-nɨñguk, “Endɨkñe manda ñalɨ dama sɨnɨk tɨlak, ‘Islael amatam sɨndɨ manda ñɨn nandɨmbi tɨke-kɨliñ enekalɨñ: Molom en noñgan. Endɨ nɨndok Yambatnɨ, dɨwɨn no nɨm pakañ. ");
INSERT INTO nif_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Wala tɨmbi dɨk gɨnañga gɨt waleñga tip gɨt nanandɨñga gɨt gembɨñga gɨtɨk Yambat Molomga endokgot bi-ñɨmekañ.’ ");
INSERT INTO nif_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Tɨmbi endɨkñe manda wandiñgan no ñɨndɨñ patak, ‘Dɨk dɨtnala tɨ-gamlañ, wɨndɨñgangot nokala tɨ-ñɨmekañ.’ Endɨkñe manda tɨpet walɨ endɨkñe manda dɨwɨn gɨtɨk yapma klembi pakamɨk.” ");
INSERT INTO nif_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yesulɨ wɨndɨñ eumbi, endɨkñe manda nandɨ-tale amalɨ “Waak!” embi nɨñguk, “Endaut, dɨk manda biañgan sɨnɨk elañ. Yambat en noñgangot, dɨwɨn no nɨm pakañ. ");
INSERT INTO nif_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tɨñɨpi, nɨndɨ endok gaut tapma sina dɨumbi, nepek dɨwɨn wɨndɨñgot tapma tɨ-ñɨmneñ wɨn kɨndem. Gan tɨkap nɨndɨ gɨnañnɨ gɨt nanandɨnɨ gɨt gembɨnɨ gɨtɨk endokgot bi-ñɨmneñ, ba nɨnla tɨ-nɨmamɨñ tuop wɨndɨñgangot notniila tɨ-semneñ, wɨn tapma kusei kusei yapma klembi, endok dainan kɨndem bien sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ama endɨ manda tambon wɨndɨñ eumbi, Yesulɨ endok nanandɨn kɨndem kañbi nɨñguk, “Dɨk Yambattok gɨñgɨt kɨndem indawɨñ.” Wɨndɨñ nɨmbɨmbi, Juda ama biesɨlɨ en mandalɨ sɨsoñ tɨ-ñɨmnepi mɨsɨmbi, nepek nola bɨndambo nɨm nɨ-kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tɨmbi Yesulɨ tapma it sañ simba gɨnañ papi, amatam enɨ-daut tɨ-sem-tɨñɨpi enɨ-kañbi eñguk, “Nɨtekta tɨmbi, endɨkñe manda nandɨ-tale ama endɨ Mesia en Devittok komblingot eañ? ");
INSERT INTO nif_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dɨndɨm Yallɨ Devittok gɨnañ tɨmbɨ tɨkɨleumbi, Devit en Mesiala ñɨndɨñ eñguk, ‘Yambat Wopumdɨ nokok Wopumnala ñɨndɨñ nɨñguk: Dɨk bɨmbi, kɨtna sɨnɨk kandañ pipapi, nakɨta amatam yambɨ-dɨkñe-kundekamɨk. Kuñɨpi, kanjɨtgai ep pɨ-yaliwambi, dɨkok kapmainan patnekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Wɨndɨñda Devit en Mesiala ‘Wopumna’ kɨtɨñguk, wala tɨmbi Mesia endɨ Devittok komblin sɨlaningot ba? Nɨm a. Endɨ Devittok Wopum.” Tɨmbi ama kɨmɨn wopum Yesulok manda nandɨmbi nandɨ-koñgom tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tɨmbi Yesulɨ enɨ-daut tɨ-sem-tɨñɨpi enguk, “Sɨndɨ endɨkñe manda nandɨ-tale ama endok nandɨnandɨnjɨ ba ep tɨndɨnjɨ ka-kɨliñ enekalɨñ! Dɨwɨn endɨ amatamdɨ yambum loloñ tɨmbektok nandañ, wala tɨmbi endɨ ama loloñ endok dasindasinjɨ pat-dasimbi, ‘tɨna nɨmbɨt’ tañ. Tɨmbi endɨ amatamdɨ kɨmɨn kwelan we semñɨpi, kosɨ tɨke-lonelɨñda nandañ. ");
INSERT INTO nif_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tɨñɨpi, it kiyau gɨnañ ba nana sina wopum gɨnañ endɨ ama loloñjɨlok pipapat plon patnepi nandañ. ");
INSERT INTO nif_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Endɨ tam kanjak juluñɨt tɨ-sembi, isɨ nepenepeksɨ yapma tɨkeañ, tɨmbi amatamdok dausɨnan tɨ-kelakelamjɨ kot-taplinelɨñdok nɨmolo ombap tañ. Endɨ ep tɨndɨnjɨ dɨndɨm walan tañ, wala tɨmbi Yambattɨ tuan mɨlap sɨnɨk ombɨ-semekak.” ");
INSERT INTO nif_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tɨmbi Yesulɨ tapma it gɨnañ papi, mɨnem Yambattok kɨmɨkɨlɨñ wolok tambon kandañ pipakuk. Pipapi kañɨlɨmbi amatamdɨ bɨ, mɨnem tapɨkot kawat dɨñgwinda gɨnañ dasiu pɨñguk. Amatam kwɨlɨkwɨlɨnjɨ wopum asuptɨ bɨmbi, mɨnem wopumgan kɨmɨlɨmbi pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tɨñɨlɨmbi, tam kanjak pɨmbɨñen nolɨ bɨmbi, mɨnem kwandai gɨmɨn tɨpet kɨmɨlɨmbi pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Tɨmbi Yesulɨ wɨn kañbi, gwañgwañii kɨtɨ-semum bɨumbi enguk, “Nak biañgan sanba: amatam dɨwɨn endɨ mɨnem wopumgan kolɨmbi, wopum gama nɨsɨlok pat-semlak. Gan tam kanjak pɨmbɨñen ñalɨ mɨnem nana tualok palɨmɨk wɨn gɨtɨk kolɨ taleumbi, ñam nɨmnat, sɨlanin sɨnɨk patak, wala tɨmbi mɨnem kɨmɨlak wɨn dɨwɨn gɨtɨkkandɨ kɨmɨlalɨñ wɨn yapma kle-talelak. ");
INSERT INTO nif_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tɨmbi Yesulɨ gwañgwañii gɨt tapma it sañ simba gɨnañ nanin pɨ-ñañɨpi, gwañgwañ nolɨ tapma it kɨt youpi nɨñguk, “Nɨnɨndaut, ñɨ kawɨñ! It gɨtɨk ñɨn engano kɨndem bien. Tɨmbi kawat wopum wopumdɨñgan tɨndɨn.” ");
INSERT INTO nif_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eumbi nɨñguk, “It wopum ñɨ yambɨlañ wala ganba: Juda amatamdok kanjɨksiilɨ bɨmbi, it gɨtɨk ñɨn wiapi, kawat no nɨm biumbi, kawat nollok plon palekak. Nɨm sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yesulɨ wɨndɨñ embi, Jelusalem it kwet bimbi, Oliv kwet jañgɨnnan loñguk. Lombi, tapma it tambon kandañ wolok pip palɨmbi, Petlo, Yakobo, Yoane gɨta Andlu endɨñgot endoñ bɨm nɨ-kambi eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Dɨk nɨnbɨmbi nandɨna: nepek nek tapma ittok plon elañ wɨn dawanda indaukak? Ba kundit nek ñalɨ dama indaumbi ka-nandɨnekamɨñ: mɨlap kusei gɨtɨk ip inda-nɨmep tɨlak?” ");
INSERT INTO nif_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Tɨmbi Yesulɨ nepek indaukak wolok enɨ-dakleñɨpi eñguk, “Sɨndɨ ka-kɨliñ embi kunekalɨñ. Nɨm kañbi, ama nolɨ tue-sambiumbi, juluñ mandan wɨn nandɨ-ñɨmnelɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ama asuptɨ nokok kotna plon bɨ-indambi, ‘Natna Mesia wakan’ embi, amatam asup tue-yambiumbi, juluñ mandanjɨ nandɨ-kwambɨñ danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","8","Tɨmbi ama sambat dɨwɨndɨ mɨlapi, sambat dɨwɨnda mik tɨ-semnekalɨñ, tɨmbi ama wapmañ dɨwɨndok sambattɨ mɨlapi, wapma dɨwɨndok sambatta mik tɨ-semnekalɨñ, wala tɨmbi sɨndɨ miktok gɨñgɨlɨ nandɨnekalɨñ, ba mik mayañgan indaumbi wolok gɨñgɨt nandɨnekalɨñ. Wɨndɨñ nandɨñɨpi, nɨm sɨlɨkñembi mɨsɨnekalɨñ. Nepek wɨn gɨtɨk biañgan indaukak, gan kwet nain taletalen walɨ gama nɨm. Tɨmbi mɨnjamɨnjat kwet nolok ba nolok tɨmbekak, ba nana map inda-semekak.” Yesulɨ wɨndɨñ embi, e-yout manda enbi eñguk, “Nepek wɨ gɨtɨk indaukak wɨn tamdɨ gwañgwa tɨkeup dama siñgin gawat lakalakat inda-ñɨmlak wandiñ indaukak. Gan siñgi kandañ mɨlap wopum sɨnɨk indaukak. ");
INSERT INTO nif_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Nain wolonda sɨnɨla nɨtek kuañ wɨn ka-kɨliñ embi kunekalɨñ. Kanjɨksiilɨ sepbi, mandala ama biesɨlok kɨsɨ plon sambiumbi, it kiyau gɨnañ sandɨpnekalɨñ. Tɨmbi sɨndɨ nokok gɨñgɨtnai kuañda tɨmbi yambɨ-dɨkñe ama ba ama wapmañ endok dausɨnan ipi, kusatna e-dakle-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Tɨmbi gɨñgɨt manda kɨndem wɨn biañgan amatam gɨtɨkta dama eu pɨum ennekalɨñ. Enɨ-taleumek, kwet nain taleukak. ");
INSERT INTO nif_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tɨmbi kwapme kwapme sepbi, mandala sanañgɨp ñañɨlɨmbi, ‘Manda nɨtek enetamɨñ?’ wɨndɨñ embi nandɨ-bendɨ-wopum itangan nɨm tɨnekalɨñ. Nɨm a! Nain wolonda sɨnɨñgan manda wɨn nɨm enekalɨñ. Wɨn Dɨndɨm Yallɨ gɨnanjɨ tokñeumbi, Yambattɨ manda samekak wɨn wakan enekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wolonda naka tɨmbi dallɨ kwayañ ba kwayañdɨ dal kanjɨktok kɨsɨ plon kɨmɨlɨmbi, yandɨp kɨmnekalɨñ. Ba beptɨ wembe gwañgwañii kanjɨktok kɨsɨ plon kɨmɨlɨmbi, yandɨp kɨmnekalɨñ. Tɨmbi wembe gwañgwalɨ meñjɨ besɨla kanjɨk tɨ-sembi, wɨndɨñgangot tɨmbɨmbi yandɨpmɨ-kɨmnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kotnala tɨmbi ama gɨtɨktɨ nandɨ-kola wopumgan tɨ-samɨ-kunekalɨñ. Gan amatam mɨlap wɨn ba wɨn gɨñgɨnembi bembi, kuañ tuop nep kwambɨñ da-kuañda en wakan Yambattɨ ep mekak.” ");
INSERT INTO nif_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Tɨmbi Yesulɨ yousɨmbi enguk, “Nepek kolan papait no tapma it gɨnañ, kɨmɨsip tɨndɨnnan, wandɨñ loukak. Loumbi, Yambattɨ wɨn kañbi, nandum pɨ-sɨnɨk taumbi, enlok il siñgi wɨlɨmekak. (No endɨ manda ñɨn pinapi, wolok kusei nandɨ-kɨliñ eukak.) Sɨndɨ nepek kolan wɨ kañbi, nain wolonda amatam Judia kwelan pakañ endɨ pimbi, kwet jañgɨnnan lonekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tɨmbi no endɨ it pawan papi, nepek nola it gɨnañ nombo nɨm loukak, ");
INSERT INTO nif_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ba no endɨ kena gɨnañ papi, sauloñɨn tɨkeupi undane ilan nɨm ñaukak. ");
INSERT INTO nif_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","O wem! Nain wolonda tam gwañgwa mɨnjɨpsat, ba gwañgwa num emañ endɨ blasɨñgandok. ");
INSERT INTO nif_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Tɨmbi sɨndɨ mɨlap wɨn gwi sasalɨ nainnan nɨm indauktok nɨmolo tɨ-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Neta, nain wolonda mɨlap wopum sɨnɨk indaukak. Yambattɨ kwet tɨmbɨ indañguknan bɨkap man ñɨndɨñgɨt mɨlap wandiñ no nɨm indañguk, tɨmbi bɨndambo nɨm indaukak. ");
INSERT INTO nif_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tɨkap Wopumdɨ nain wɨn nɨm tɨmbɨ dumalawɨmda, amatam gɨtɨkkan talenelɨñ. Gan endɨ amatam ep danbi enlok gɨñgɨt kasɨleñguk enda wakan nandɨ-sembi, nain wɨn ikan tɨmbɨ dumalañguk. ");
INSERT INTO nif_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nain wolonda ama nolɨ ñɨndɨñ bek sanbekta, ‘Yakñesii! Mesialɨ ñɨ patak’, ba ñɨndɨñ sanbek, ‘Wɨ kawɨt! Endɨ da patak!’, sɨndɨ manda wala nandum tlal tɨmbekak. ");
INSERT INTO nif_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Neta, Mesia juluñgan ba plofet ama juluñgan indambi, nɨsɨlok kusasɨ tɨmbɨ dakle-semnekalɨñdok amatam kundit engano sɨnɨk ep daut semum ka-sɨlɨkñenekalɨñ. Tɨkap endɨ tuopta, ama walɨ amatam Yambattɨ enlok gɨñgɨt ep danguk wɨn ep tɨmbɨ kamalanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Gan sɨnɨla ka-kɨliñ e-kunekalɨñ. Nak nepek gɨtɨk indaukak wolok itangan sanɨ-talelet.” ");
INSERT INTO nif_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Tɨmbi Yesulɨ yousɨmbi enguk, “Gan mɨlap wopum wɨn taleumek ‘wolonda maim dauttɨ bip mɨumbi, yakɨptɨ bo nɨm saleumbi, ");
INSERT INTO nif_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","kunum gɨnañ dɨmboñgɨptɨ pi-pɨnekalɨñ. Tɨmbi nepek nek kwambɨñ kunum gɨnañ pakañ ep mɨnjalɨmbɨ kwesɨ binekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tɨmbi nain wolonda amatam gɨtɨktɨ kanekalɨñ wɨn: Amalok Nɨñan endɨ mulukua gɨnañ gembɨn wopum ba kolsalen walalannat pɨmbi inda-dakleukak. ");
INSERT INTO nif_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Wolonda endɨ amatam dembek dembek kuañ enlok gɨñgɨt ep kasɨleñguk endɨ wakan enloñ ep kɨmɨn kolektok añelo enɨ-mulɨm ñambi, kunum kwet kɨmɨlɨ taleñguknan nanin ep kiutnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wɨndɨñ ñala sɨndɨ komba konelok plon nanandɨ ñɨn epnekalɨñ: kii gayam tukñat tɨmbi, sak kaik indaumek, maim nain indaup tɨlak wɨndɨñ nandañ. ");
INSERT INTO nif_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wɨndɨñgangot mɨlap gɨtɨk sanɨt wɨn indaum kañbi, sɨn ñɨndɨñ nandɨnekalɨñ: Ama Sɨsɨnɨk endɨ inda-dakleuptok nain ip dumala-ta-bɨlak. ");
INSERT INTO nif_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nak biañgan sanba nandɨwɨt: amatam man ñɨndɨñgɨt kuañ endoñnan nanin dɨwɨndɨ gama nɨm kɨmñɨlɨmbi, nepek wɨn gɨtɨk indaukak. ");
INSERT INTO nif_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunum kwet taleukak, gan nokok mandana gɨtɨktɨ nɨm paipi, papat kwambɨñ palekak. ");
INSERT INTO nif_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Nepek gɨtɨk wɨn nain wolonda sɨnɨk indaukak wɨn ama nimbek nolɨ nɨm nandɨlak. Añelo kunum gɨnañ pakañ ba Yambattok Nɨñañ en bo wɨn nɨm nandañ. Nɨm. Bep Yambat en noñgandɨñgot nandɨlak. ");
INSERT INTO nif_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Sɨndɨ nain wɨn dawanda sɨnɨk indaukak wɨn nɨm nandañ, wala tɨmbi ka-kɨliñ embi mandɨm kunekalɨñ! ");
INSERT INTO nif_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nain indaukak wɨn ñɨndɨñ: ama nolɨ il bimbi, kwet mayañgan ñaup tɨlak. Endɨ kena gwañgwañii kena molom molom danɨ-sembi, telak yama mandɨmandɨ endɨ ka-mandɨ-kɨliñ ewɨktok endɨkñe manda nɨ-talembi ñalak. ");
INSERT INTO nif_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wɨndɨñda it molomdɨ nain dawanda sɨnɨk bɨukak wɨn sɨndɨ nɨm nandañ. Endɨ kwet kɨlɨm eumbi, ba tim boñgɨp, ba puput noñgan kɨtɨumbi, ba kwet salaup tɨmbɨmbi, ba salasalanan tombekak wɨn sɨndɨ nɨm nandɨañda tɨmbi ka-mandɨ-kɨliñ e-kunekalɨñ! ");
INSERT INTO nif_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nɨm kañbi, dou-palɨmbi, molomdɨ platik sɨnɨk bɨ tombi, sep tɨmbɨ indawɨk. ");
INSERT INTO nif_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Endɨkñe manda ñɨn sanlet wɨn gɨñgɨtnai gɨtɨkkan sɨndok: ka-mandɨ-kɨliñ embi kunekalɨ.” ");
INSERT INTO nif_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tɨmbi gwɨlat wopum tɨpettɨ ep tɨmbɨ dumalañguk, wɨn kamaikamai nain gɨta plaua wɨlɨmbendɨ nɨmnat wolok gwɨlat. (Wolonda Islael amatamdɨ Yambattɨ Isip kwelan nanin ep kɨmɨkuk wolok pat-nandɨ-pakañ.) Gwɨlat walɨ sandap tɨpet wolok siñgi kandañ ep tɨmbɨ dumalañɨlɨmbi, tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama endɨ Yesu telak gitak plon tɨkembi wɨlɨ kɨmbektok telak yolonjɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ñɨndɨñ eñgɨlɨñ, “Gwɨlat gɨnañ wɨndɨñ tɨnambi, nɨm kɨndem daukak. Nɨm kañbi, amatam kɨmɨn wopum endɨ mɨlapi, gimbɨt tɨm, kesɨ tapma tɨmbi, mik tɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tɨmbi Yesulɨ Betani it kwelan ñambi, ama no damañgan wanda kwambɨñ inda-ñɨmɨñguk koi Simon endok ilnan nana na-pakuk. Palɨñɨlɨmbi, tam no endɨ pama tul mɨndɨñ kɨndem tuan wopum sɨnɨk wɨn tɨke-bɨmbi, kawat kanɨm bim ombɨ-gɨlombi, pama tul wɨn Yesulok kumbam plon yalɨmukuk. Yalɨmulɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ama dɨwɨsɨ wolok pakɨlɨñ endɨ tamda gɨnanjɨ komba dɨumbi nɨsɨñgan eñgɨlɨñ, “Neta sɨnɨk pama tul kɨndem ñɨn sɨlak tɨmbɨ kola-talelak? ");
INSERT INTO nif_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tuktok tuan wɨn wopum sɨnɨk, mɨnem 300 netepek. Endɨ tuk wɨn tualok kɨmɨlɨmda, mɨnem walinin tɨkembi, ama pɨmbɨñenda emɨwɨk.” Wɨndɨñ embi, tam nɨ-ñombɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","gan Yesulɨ enguk, “Biu palen! Sɨndɨ neta mɨlap mañ? Endɨ tɨ-kɨndekɨndem tɨ-namlak. ");
INSERT INTO nif_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ama pɨmbɨñesɨ endɨ nain tuop sɨn gɨta kuañ, wala tɨmbi nain nola ba nola ep mɨ-pañgɨtanep nandañda kɨndem tɨnelɨñ. Gan natna nain tuop sɨn gɨta nɨm paletat, ");
INSERT INTO nif_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","wala tɨmbi tam ñalɨ man ñɨndɨñgɨt nepek nek tuop tɨ-namek wolok tuop tɨk. Endɨ pama tul i-namɨk, wɨn nak kɨmbambi nep kɨnditnekalɨñ wolok itangan pɨñgɨpna tɨ-pañgɨpañgɨle tɨ-namɨk. ");
INSERT INTO nif_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nak biañgan sanlet: dembek dembek ñanekalɨñ tuop gɨñgɨt manda kɨndem ñɨn eu sataumbi, tam ñalɨ nepek nek tɨ-namɨk wolok kasat wakɨt kwet tuop tɨ-sembi, tam endok kasat eu kaik taukak.” ");
INSERT INTO nif_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nain wolonda Judas Iskaliot, Yesuloñ gwañgwañii 12 endoñnan nanin no, endɨ Yesu bola tɨ-ñɨmektok tapma ama biesɨloñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ñambi, wolok tuop enbɨmbi nandɨm gɨnañjɨ kɨndem daumbi, mɨnem mɨnepi nɨ-kwambɨñ dañgɨlɨñ. Tɨmbi Judalɨ kusei kɨmɨpi, “Yesu bola tɨ-ñɨmektok nain kɨndem delok indauk?” embi mandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Plaua wɨlɨmbendɨ nɨmnat sinjilok gwɨlat wolok kusei kɨmɨkɨmɨlɨnan Islael amatamdɨ sipsip nɨñañ wɨpi, tapma tɨmbi, Yambattɨ Isip kwelan nanin ep kɨmɨkuk wolok kɨmɨt-nandɨm pakañgɨlɨñ. Gwɨlat wɨn indaumbi, gwañgwañiilɨ Yesu nɨ-kañbi eñgɨlɨñ, “Nɨndɨ delok ñambi, gwɨlat ñolok nana tɨ-jumɨt tɨ-gamneñdok nandɨlañ?” ");
INSERT INTO nif_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Eumbi, Yesulɨ gwañgwañiit tɨpet enɨ-mupi enguk, “Sɨtɨ Jelusalem it kwet gɨnañ lombi, ama nolɨ tuk kambot bembi bɨ sep tɨmbɨ indautak en kle ñandekamɨk. En kle ñaumbi, ");
INSERT INTO nif_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","it nolok ña loutak wolok molomla ñɨndɨñ nɨndekamɨk, ‘Nɨnɨndauttɨ ñɨndɨñ elak: nak gwañgwanai gɨta it gɨnañ delok gwɨlattok nana nambetet?’ ");
INSERT INTO nif_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Eumbi, it gɨnañ wopum no tɨ-kɨliñ e-bimbin wɨn gwat patak daut sametak. Wolok tɨ-jumɨt tɨ-nɨmdekamɨk.” ");
INSERT INTO nif_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Eumbi, gwañgwañiit tɨpet endɨ nandɨmbi, wɨnanin ñam Jelusalem it kwelan loñgɨmɨk. Lo tombi, Yesulɨ eñguk wolok tuop inda-semumbi, gwɨlattok nana tɨ-jumɨt tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tɨmbi kwet kɨlɨm eumbi, Yesulɨ gwañgwañii 12 gɨta bɨmbi, it gɨnañnan loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Lom nana na-palɨñɨlɨmbi, Yesulɨ enguk, “Biañgan sanlet: sɨndoñnan nanin no nakɨta nana yakan nalak endɨ nak bola tɨ-nametak.” ");
INSERT INTO nif_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wɨndɨñ eumbi, gɨnañjɨ mɨlataumbi, noñgan noñgandɨ ñɨndɨñ nɨñgɨlɨñ, “Nakta nɨm bek?” ");
INSERT INTO nif_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nɨmbɨmbi enguk, “Wɨn gwañgwa 12 sɨndoñnan nanin no. Endɨ plaua dɨp tɨkembi, nakɨta tuk wɨtna noñgan gɨnañ youpi nalak, en wakan. ");
INSERT INTO nif_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Biañgan sɨnɨk. Manda youyoulɨn patak wolok tuop Ama Sɨsɨnɨk wɨn bola tɨ-ñɨmɨumbi wɨlɨ kɨmbekak. Gan ama nin bola tɨ-ñɨmetak en blangandok. Meñdɨ nɨm ap mɨumda, wɨn kɨndem.” ");
INSERT INTO nif_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Tɨmbi nana na-palɨñɨlɨmbi, Yesulɨ plaua no tɨkem gwɨlam tɨmbi, ombɨm gwañgwañiila embi enguk, “Tɨke nambɨt; ñɨn nokok gaumna.” ");
INSERT INTO nif_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wɨndɨñ embi, wain wɨtna no tɨkembi, gwɨlam tɨ-talem emumbi, gɨtɨkkandɨ wɨtna noñgan wolok gɨnañ nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nambɨmbi enguk, “Ñɨn nokok wekatna. Nak amatam asup endok kɨnjan kɨmbi, wekatna yalɨmutet. Walɨ wakan toptop Yambattɨ amatamñii gɨt tɨlak wɨn tɨmbɨ kwambɨñ dalak. ");
INSERT INTO nif_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nak biañgan sɨnɨk sanlet: nak wain tuk kwelan nombo nɨm nambetat. Yambattɨ gɨñgɨtñii indangan yambɨ-dɨkñeukak wolondamek nak en gɨta papi, wain tuk komblin engano wɨ mek nambetat.” ");
INSERT INTO nif_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tɨmbi Yambat nɨ-wɨt-ta-lo kap no tiu taleumbi, Oliv kwet jañgɨn tɨmbɨ dumalanepi pɨ-ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ñañɨpi, Yesulɨ gwañgwañiila enbi eñguk, “Yambattok manda no ñɨndɨñ youyoulɨn patak, ‘Nak ka-dɨkñe ama wɨla kɨmbɨmbi, sipsiptɨ papusenenekalɨñ.’ Wala tɨmbi sɨndɨ gɨtɨkkan siñgi wɨt-nambi pi ñanetañ. ");
INSERT INTO nif_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gan Yambattɨ kɨmnan nanin nep mɨum mɨlatmek, telak dama tɨ-sambi, Galili kwelan ñam wolok sambetat.” ");
INSERT INTO nif_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Eumbi, Petlolɨ nɨñguk, “Ama dɨwɨn gɨtɨktɨ gambimbi pi-ñanetañ bek, gan nakta nɨm sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Eumbi nɨñguk, “Nak biañgan ganba: man tim ñolondañgan puputtɨ nain tɨpet nɨm kɨtɨumbi, dɨk nain tɨpet gɨt no naka ‘En nɨm nandɨ-ñɨmlet’ eutañ.” ");
INSERT INTO nif_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eumbi, Petlolɨ gɨñgɨnembi nɨñguk, “Kɨndem dɨkɨta nep nulɨmbi kɨmbetet, gan nak dɨka ‘Nɨm nandɨ-ñɨmlet’ nɨm eutet. Nɨm sɨnɨk.” Eumbi, gwañgwañii gɨtɨkkandɨ wɨndɨñgangot nɨ-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tɨmbi Yesu gɨt gwañgwañii endɨ ñambi, kwet no koi Getsemane wolok ña-tomgɨlɨñ. Tombi, Yesulɨ gwañgwa dɨwɨnda enbi eñguk, “Sɨndɨ ñolok pipalɨmbi, nak ñam nɨmolo tɨmbi bɨutet.” ");
INSERT INTO nif_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Wɨndɨñ embi, Petlo, Yakobo gɨt Yoane yanañgɨpi ñañguk. Ñañɨpi, enlok plon nepek inda-ñɨmetak wala nandum mɨlata-sɨnɨk taumbi, gembɨñ pɨumbi ");
INSERT INTO nif_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","enguk, “Gɨnañna nandɨwa kola-sɨnɨk talak, kɨmbettok tuop nandɨlet. Sɨndɨ ñolok papi, ka-kɨliñ embi palɨt!” ");
INSERT INTO nif_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesulɨ wɨndɨñ embi, lakat ñaña em kwelan pi-pɨmbi, telak no palekta, mɨlap bembemdok nain walɨ en maklewɨk wala Yambat nɨmolo tɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Endɨ enlok manda plon beula “Abba” kɨtɨ-ñɨmbi nɨñguk, “O Bep! Dɨk nepenepek gɨtɨk tuop tɨ-talewɨñ, wala tɨmbi dɨk mɨlap ñɨn napma tɨke-namɨñ. Gan dɨk nokok nanandɨ nɨm kɨmɨt-kleukañ. Nɨm sɨnɨk. Dɨk nɨtek nandɨlañ, wolok tuopgan indawɨn.” ");
INSERT INTO nif_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tɨmbi Yesulɨ gwañgwañii tɨpet gɨt no endoñ undane-bɨmbi, yambum dou-palɨmbi, Petlo nɨ-ñombɨm nɨñguk, “Simon, dɨk doulañ ba? Dɨk nain dumangan kaik paleñdok tuop nɨm ba?” Wɨndɨñ embi enguk, ");
INSERT INTO nif_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","“Biañgan sɨnɨk: gɨnanjɨlɨ nepek kɨndem tɨmbepi nandɨlak, gan pɨñgɨpsɨlɨ gembɨn nɨmnat, wala tɨmbi ka-kɨliñ embi, nɨmolo tɨmbɨt. Nɨm kañbi, tue-kambi plon pi-pɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yesulɨ wɨndɨñ embi, nombo yambim ñambi, nɨmolo dama tɨñguk wɨndɨñgangot nombo tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nɨmolo tɨmbɨ taleumbi, nombo gwañgwañiiloñ undane-bɨm yambɨñguk wɨn: dausɨ mɨlataumbi dou-pakɨlɨñ. Dounan nanin mɨlapi, manda nɨtek nɨnelɨñ wala nandum mɨlatañguk. ");
INSERT INTO nif_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tɨmbi Yesulɨ nombo ña nɨmolo tɨ-talembi, gwañgwañiiloñ undane-bɨumbi, nain tɨpet gɨt no tɨmbɨmbi enguk, “Sɨndɨ gamañgot doumbi sɨlak pat-nandɨ-tañ ba? Ip tuop. Nandañ: Ama Sɨsɨnɨk yom amalok kɨsɨ plon kɨmɨkɨmɨttok nain ip indalak. ");
INSERT INTO nif_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ñala mɨlalɨmbi ñana. Wɨ kawɨt: bola tɨ-namlok ama ip nɨp tɨmbɨ dumalalak.” ");
INSERT INTO nif_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wɨndɨñ e-palɨñɨlɨmbi, wolongan Yesulok gwañgwañii 12 endoñnan nanin no, Judas Iskaliot, endɨ ama kɨmɨn wopum telak dama tɨ-semumbi bɨñgɨlɨñ, wɨn tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama ba ama biesɨ dɨwɨn endɨ enɨ-mulɨmbi, kakit ba kwandɨ mep bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bola tɨndɨ ama endɨ damañgan sambat ñɨndɨñ kɨmɨpi enguk, “Simumu tɨ-ñɨmambi, ama ip wakan embi, ña tɨke-kwambɨñ dam tɨke-ñanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Wɨndɨñ eñgukta kena gɨnañ tombi, dɨndɨmgan Yesuloñ bɨmbi, “Nɨnɨndaut, we!” embi, wopumgan simumu tɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wɨndɨñ tɨ-ñɨmɨum kañbi, gembɨnat ñam tɨke-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tɨmbi ama Yesu gɨta pakɨlɨñ endoñnan nanin nolɨ kakil tiañe lambɨmbi, tapma amalok telak damanjɨlok kena gwañgwa sɨlanin wɨlepi, pawangot wɨlalɨm pɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tɨmbi Yesulɨ enbi eñguk, “Sɨndɨ naka nandum kumbu ama sañan tɨmbɨmbi, kakit ba kwandɨ mep bɨ-tombi, nep mañ ba? ");
INSERT INTO nif_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Sandap tuop nak tapma it sañ simba gɨnañ lombi, sɨndok boñgɨpsɨnan papi, amatam enɨ-daut tɨ-sem-ta-bɨñɨlambi, nɨm nepgɨlɨñ. Gan manda youyoulɨn patak wolok tuop man inda-namɨwɨn.” ");
INSERT INTO nif_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wɨndɨñ eumbi, gwañgwañii gɨtɨktɨ en bimbi pim ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tɨmbi ama gwañgwa no sandum satningot tembi Yesu kle-ñañguk en wakɨt tɨkembi, ");
INSERT INTO nif_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","sandum tɨke-gɨlɨm dañgɨlɨñ. Gan endɨ sandum pɨsapi, biatan pi ñañguk. ");
INSERT INTO nif_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tɨmbi endɨ Yesu tɨkembi, tapma amalok telak damanjɨlok ilan nañgɨpi ñañgɨlɨñ. (Wandɨñ tapma ama biesɨ ba ama biesɨ dɨwɨn ba endɨkñe manda nandɨ-tale ama gɨtɨk endɨ bɨm kɨmɨn tɨñgɨlɨñ.) ");
INSERT INTO nif_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yesu tɨke-ñañɨlɨmbi, Petlolɨ kambak mayañgan siñgi kandañ ep klembi ñañguk. Ñakapi, tapma amalok telak damanjɨ endok sañ simba gɨnañnangan loñguk. Lombi, tapma amalok telak damanjɨ endok tɨplaplailii gɨta pipapi, komba seimbi pakuk. ");
INSERT INTO nif_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Tɨmbi tapma ama biesɨ en gɨta Juda amalok yambɨ-dɨkñenjɨ gɨtɨk endɨ Yesu wɨlɨ kɨmbektok nandɨñɨpi, ama Yesulok siñgin sinelɨñdok yolonjɨ-tlakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Neta, ama asuptɨ bɨmbi, joñgo siñgin simbi, juluñɨt manda eñgɨlɨñ. Gan endɨ mandanjɨ walan noñgangot nɨm eñgɨlɨñ, endɨ manda kusei kusei eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tɨmbi ama dɨwɨndɨ bɨ indambi, joñgo siñgin simbi eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nɨndɨ manda no ñɨndɨñ eumbi nandɨñgɨmɨñ, ‘Nak tapma it kɨttɨ tɨndɨn ñɨn wiapi, sandap tɨpet gɨt no wolok gɨnañnangan wolok kɨnjan kɨttɨ nɨm tɨndɨn no mamba ilekak.’ Wɨndɨñ eumbi nandɨñgɨmɨñ” eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Gan mandanjɨlok walan wɨn bo noñgan nɨm. ");
INSERT INTO nif_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tɨmbi tapma amalok telak damanjɨ endɨ mɨlapi indangan bɨ ipi, Yesu nɨ-nandɨmbi eñguk, “Dɨk manda tambon tuop nɨm ewɨñ ba? Ama walɨ dɨkok manda eañ wɨn nandum nɨtek tɨlak?” ");
INSERT INTO nif_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Eumbi, gitak papi, manda tambon no nɨm nɨñguk. Tɨmbi wolongan tapma amalok telak damanjɨ endɨ Yesu ñɨndɨñ nɨ-nandɨmbi eñguk, “Dɨtna Mesia wakan, Yambat nɨ-kɨndekɨndem eamɨñ endok Nɨñañ ba?” ");
INSERT INTO nif_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nɨ-nandumbi Yesulɨ nɨñguk, “Natna en wakan. Gamanda kanekalɨñ wɨn: Ama Sɨsɨnɨk endɨ Gembɨ Molomdok kii dɨndɨmnan pipalɨmbi, yakan amatam yambɨ-dɨkñendekamɨk. Tɨmbi en wakan kunum gɨnañ nanin mulukua plon undane-bɨumbi kanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Eumbi, tapma amalok telak damanjɨ endɨ manda wɨn nandum pɨ-sɨnɨk taumbi, kusalɨ tɨmbɨ daklewɨktok dasindasin wilapbi enguk, “Neta amala nombo enɨ-nandɨmbi, ama ñolok kusalɨla yout-lonjɨnetamɨñ? ");
INSERT INTO nif_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sɨndɨ ip nandɨlɨñ, endɨ enla Yambat eñɨpi, Yambat nɨ-tɨke-pɨ-yalilak. Wala nɨtek nandañ?” Eumbi, gɨtɨkkandɨ Yesu mandanlok kɨnjan tɨkewɨktok nandɨñgɨlɨñ tuop wɨlɨ kɨmbektok e-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Tɨmbi dɨwɨndɨ kusei kɨmɨpi, manjɨ iwɨt sua-ñɨmbi, timan dai sandumdɨ masipbi, kɨsɨlɨ wɨpi nɨñgɨlɨñ, “Nindɨ gwɨtak nɨnɨmbɨm indaumbi nandɨna!” Tɨmbi tɨplaplaelɨ Yesu tɨkembi, kɨsɨ pɨndɨmdɨ wɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tɨmbi Petlolɨ tapma amalok telak damanjɨlok it pawan sañ simba gɨnañ palɨñɨlɨmbi, ama wolok kena wembe nolɨ bɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petlolɨ komba sei-palɨm kañbi, ka-kɨliñ embi nɨñguk, “Dɨk bo Yesu Nasalet nanin en gɨta kulañ gambɨlet.” ");
INSERT INTO nif_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eumbi, Petlolɨ nɨñguk, “Nɨm a. Dɨk nek elañ nak nɨm nandɨlet.” Wɨndɨñ embi, sañ simba telak yamanan pɨ-ñaumbi, wolongan puputtɨ kɨtɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tɨmbi kena wembe endɨ Petlo kañɨpi, manda dama eñguk wɨndɨñgangot nombo embi, ama wolok pakɨlɨñda enbi eñguk, “Ama ñɨn Yesulok nol no ñakan.” ");
INSERT INTO nif_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eumbi, Petlolɨ nombo “Nak nɨm” embi gɨñgɨneñguk. Tɨmbi nain nɨm ombataumbi, nombo ama wolok ikɨlɨñ endɨ nɨñgɨlɨñ, “Dɨk Galili naninda tɨmbi dɨk biañgan endok nol no.” ");
INSERT INTO nif_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nɨmbɨmbi, Petlolɨ manda kwambɨñgan nombo nombo embi ñɨndɨñ enguk, “Biañgan sɨnɨk. Nak ama koi eañ wɨn nɨm nandɨ-ñɨmlet. Manda juluñɨt eletta, Yambattɨ kɨndem nep tɨmbɨ kolawa.” ");
INSERT INTO nif_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Eumbi, wolongan puputtɨ kɨtɨumbi, nain tɨpet tɨmbɨmbi, Petlolɨ Yesulɨ manda nɨñguk wɨn nandɨ-sɨwɨkuk. Yesulɨ ñɨndɨñ nɨñgukta, “Puputtɨ gama nain tɨpet nɨm kɨtɨñɨlɨmbi, dɨk dama nain tɨpet gɨt no naka ‘En nɨm nandɨ-ñɨmlet’ eutañ.” Petlolɨ manda wɨn nandɨ-tombi, sɨmbai kolaumbi, kolan sɨnɨk kukuk. ");
INSERT INTO nif_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kwet salaup tɨmbɨmbi, wolongan tapma ama biesɨ gɨt ama biesɨ dɨwɨn ba endɨkñe manda nandɨ-tale ama, wɨn endɨ Juda amatamdok yambɨ-dɨkñenjɨ gɨtɨk endɨ kɨmɨn tɨmbi, Yesu nek tɨ-ñɨmnelɨñdok manda e-topgɨlɨñ. E-topbi, Yesu kii top nañgɨp ñambi, Judia kwettok yambɨ-dɨkñe ama Pilato endok kii plon kɨmɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tɨmbi Pilatolɨ kañbi nɨ-nandɨm eñguk, “Ba dɨk Juda amatam endok ama wapmañ ba?” Eumbi tambane-nɨñguk, “Dɨtna elañ ip wakan.” ");
INSERT INTO nif_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Tɨmbi tapma ama biesɨ endɨ Yesulok siñgin si-sɨnɨk tañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wɨndɨñ tɨmbɨmbi, Pilatolɨ Yesu nombo nɨ-nandɨñɨpi eñguk, “Endɨ dɨkok manda asup embi, siñgiñga siyañ wɨn nandɨlañ. Dɨk manda tambon tuop nɨm ewɨñ ba?” ");
INSERT INTO nif_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Eumbi, manda no nɨm tambane-eumbi, Pilatolɨ wala nandɨ-bendɨ-tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gwɨlat tuop kamaikamai nain indaumbi, Pilatolɨ amatam nandɨ-sembi, ama nolok koi kɨtɨañgɨlɨñ en wakan it kwambɨñ gɨnañ nanin pɨsapi emlɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nain wolonda ama no koi Balabas it kwambɨñ gɨnañ pakuk. Endɨ nolii gɨta Roma ama mik tɨ-sembi, dɨwɨn yandɨp kɨmgɨlɨñ, wala tɨmbi ep imbi, it kwambɨñ gɨnañ yambiumbi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tɨmbi amatam kɨmɨn gɨtɨk endɨ Pilatoloñ lombi, kundit nek tɨ-semlɨñguk wɨndɨñgangot nombo tɨ-semektok nɨ-nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Tapma ama biesɨ endɨ Yesu koi gɨñgɨtta ka-gimbɨt tɨ-ñɨmbi, kusei wala en Pilatolok kii plon kɨmɨkɨlɨñda. Pilatolɨ wɨn nandɨmbi, amatam tambane-enguk, “Juda sɨndok ama wapmañ wɨn pɨsat-samettok nandañ ba?” ");
INSERT INTO nif_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gan tapma ama biesɨlɨ amatam enɨ-munjupi eñgɨlɨñ, “Sɨndɨ eumbi, endok kɨnjan Balabas pɨsat-sametak.” Tɨmbi amatamdɨ ama biesɨlɨ eñgɨlɨñ tuopgan eumbi, ");
INSERT INTO nif_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatolɨ nombo enɨ-nandɨmbi eñguk, “Wɨndɨñ eañda tɨmbi, ama ñɨn Juda ama sɨndok ama wapmañ nɨañ en wakan nek tɨ-ñɨmettok nandañ?” ");
INSERT INTO nif_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Eumbi, nombo kɨtɨmbi nɨñgɨlɨñ, “Kloñbat plon wɨlɨ kɨmbɨn!” ");
INSERT INTO nif_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eumbi enguk, “Neta wɨndɨñ tɨ-ñɨmet? Endɨ kundit kolan nek sɨnɨk tɨñguk?” Eumbi, endɨ kwambɨñgan kɨtɨmbi eñgɨlɨñ, “Kloñbat plon wɨlɨ kɨmbɨn!” ");
INSERT INTO nif_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eumbi, wolongan Pilatolɨ nandɨ-sembi, gɨnanjɨ busukñanewɨktok Balabas pɨsat-semguk. Pɨsat-sembi, Yesu waipnelɨñdok enbɨmbi, bɨt gwɨlap pɨsɨkñattɨ waipgɨlɨñ. Taleumbi, kloñbat plon wɨtnelɨñdok ama sañasɨlok kɨsɨ plon kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Tɨmbi ama sañasɨlɨ Yesu tɨkembi, nɨsɨlok sañ simba gɨnañ nañgɨpi ñañgɨlɨñ. Ña-tombi, nosii gɨtɨk ep mɨn tɨmbi, ");
INSERT INTO nif_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yesu tɨ-lakalaka e-tɨ-ñɨmnelɨñdok sauloñ gɨmɨn ama wapmañdok sauloñ nomɨk wɨn dasi-ñɨmbi, toa pɨsɨkñat walɨ bondɨnem kumbam plon dasi-mɨumbi, ama wapmañdok bundi walan tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dasi-ñɨm-taleumbi, ama noñgan noñgandɨ bɨmbi nɨñgɨlɨñ, “We! Juda amalok ama wapma!” Wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","toñalɨ kumbam plon wɨpi, iwɨt sua-ñɨmbi, juluñjuluñ mɨlelem tɨ-ñɨmñɨpi tɨ-kɨndem da-ñɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tɨ-lakalakae gɨtɨk tɨ-tale-ñɨmbi, sauloñ gɨmɨn wɨn kiundɨlɨñɨmbi, nombo enlok dasindasin dasi-ñɨmbi, kloñbat plon wɨtnepi nañgɨp ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ñañɨpi, ama no telak plon tɨmbɨ indañgɨlɨñ koi Simon Sailini it kwelan nanin, Alesande gɨt Rufus endok beset. Endɨ Jelusalem it kwelan lambum kañbi, kaikan Yesuloñ kloñbat bemektok nɨ-gɨñgɨneumbi bemum ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ñambi, kwet no koi Golgota (nɨnɨlok manda plon Kumbam kwandat) wolok Yesu nañgɨpi ña-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ña-tombi, siñgin gawattok gwasap wain tuk gɨt tambaneñgɨlɨñ wɨn mɨ-kaumbi, nɨm nañguk. ");
INSERT INTO nif_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Tɨmbi kloñbat plon kɨmɨp wɨpi mambɨ ikuk. Wɨndɨñ tɨ-talembi, dasindasin dannelɨñdok satu sañala kolɨm ep indaumbi wolok tuop danbi epgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nain wɨn 9 kilok tɨmbɨmbi, kloñbat plon wɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tɨmbi kusalɨlok manda ñɨndɨñ palañ plon youpi, kumbam kusipnan wɨlɨm pakuk, “Juda ama endok ama wapma.” ");
INSERT INTO nif_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Tɨñɨpi, kumbu ama sañan tɨpet Yesu gɨta kloñbat plon yandɨpgɨlɨñ, nolɨ Yesulok kii dɨndɨmnan, nolɨ kii kepmanan ep mambɨ ikɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tɨmbi amatam wolok ñañambɨt tɨñgɨlɨñ endɨ manda kusei kusei nɨmbi nɨ-lakalakae eñɨpi, kumbanjɨ dɨñgunembi nɨñgɨlɨñ, “Yɨɨi! Dɨk tapma it wiat-kopi, nain tɨpet gɨt no wolok gɨnañnangan nombo mambɨ ilepi eñguñ wɨn! Nɨtek? ");
INSERT INTO nif_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Gwɨlaka tɨke-kɨmɨlepi, kloñbat plon nanin pɨwɨñ!” ");
INSERT INTO nif_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Tɨmbi tapma ama biesɨ gɨt endɨkñe manda nandɨ-tale ama endɨ bo wɨndɨñgot Yesulok plon e-sasale manda nɨsɨñgan embi eñgɨlɨñ, “Nɨtek tɨmbi, endɨ ama dɨwɨn ep kɨmɨkuk, gan enlok siñgin tuop nɨm tɨke-kɨmɨtak. ");
INSERT INTO nif_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tɨkap endɨ biañgan Mesia, Islael amatam endok ama wapmañ kulakta, man ñɨndɨñgɨt kloñbat plon nanin pɨun. Wɨndɨñ tɨmbekta, kusalɨ ka-nandɨmbi nandɨ-kɨlɨktɨ tɨ-ñɨmnetamɨñ.” Tɨmbi ama tɨpet en gɨta yandɨpgɨlɨñ endɨ bo nɨ-kolañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tɨmbi maim boñgɨpnan palɨmbi, kwet tuop kɨlɨm indaumbi ñakap 3 kilok tɨkeñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","3 kilok tɨmbɨmbi, Yesulɨ enlok manda plon gembɨnat kɨtɨmbi eñguk, “Eloi, Eloi, lama sabaktani?”, wɨn nɨnɨlok manda plon “Yambatna Yambatna, nekta nambilañ?” ");
INSERT INTO nif_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tɨmbi ama dɨwɨn kamañgan ikɨlɨñ endɨ manda wɨn nandɨmbi eñgɨlɨñ, “Yakñesii! Plofet Elia kɨtɨ-ñɨmlak.” ");
INSERT INTO nif_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tɨmbi ama nolɨ woñep ñambi, dɨlɨñ tuk kimbɨñ gɨnañ nanin no tɨke-bɨm wain tuk kiitan gɨnañ wɨsɨmbi, komba bem plon imbi, Yesulɨ nambektok sua eumbi loñguk. Loumbi eñguk, “Papa kana, Elialɨ bɨmbi tɨke-pɨutak ba nɨm.” ");
INSERT INTO nif_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tɨmbi Yesulɨ wopumgan kɨtɨmbi kɨmguk. ");
INSERT INTO nif_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nain wolonda tapma ilan it gɨnañ delok Yambattɨ patak pa eañ wolok sandum wopum no tembɨmbi, it gɨnañ masip bimbin pakuk. Tɨmbi Yesulɨ kɨmbɨmbi, wolongan sandum wɨn boñgɨpgan blañganembi, gwat nanin wilap pɨ lap taleñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tɨmbi ama sañasɨlok telak damanjɨ endɨ ama kloñbat plon yandɨpgɨlɨñ yambɨ-pakuk. Yambɨ-papi, Yesulɨ kɨm walan engano kɨmguk wɨn kañbi eñguk, “Biañgan sɨnɨk, ama ñɨn Yambattok nɨñañ sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","41","Tɨmbi tam asup Galili nanin Yesu gɨt yakan Jelusalem bɨñgɨlɨñ endɨ bo wolok pakɨlɨñ. Dɨwɨndok kosɨ ñɨndɨñ: Malia Makdala nanin wakɨt Salome, tɨmbi Malia, Yakobolok ou ba endok kwayañ Joses endok menjet. Yesulɨ Galili kwelan kulɨñguk nain wolonda tam tɨpet gɨt no walɨ en gɨta kuñɨpi, tɨplaplae kena tɨ-ñɨmɨ-kulɨñgɨlɨñ. Tam walɨ gɨtɨk giñgiñgan ipi ka-tuakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Timlala tɨmbɨmbi, Sabat patnandɨ nain dumalaumbi, nepek gɨtɨk tɨ-jumɨt ba tɨ-dɨndɨm tɨndɨlok nain tɨpmɨn dañguk, wala tɨmbi ");
INSERT INTO nif_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Josep Alimatia nanin endɨ Yesulok dalandan platik sumnan kɨmɨlepi nandɨñguk. Josep endɨ Juda amatamdok yambɨ-dɨkñe ama endoñnan nanin no, ep tɨndɨn kɨndem koi gɨñgɨlat. Tɨmbi endɨ bo nain Yambattɨ gɨñgɨtñii indangan plon yambɨ-dɨkñeukak wala mandɨmandɨ kuñguk. Endɨ wakan mɨsɨmɨsɨ wɨlambanembi, Pilatoloñ lombi, Yesulok dalandanla nɨ-nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nɨ-nandumbi, Pilatolɨ “Yesu ip kɨmɨk” manda wɨn nandɨ-sɨlɨkñembi, ama sañasɨlok telak damanjɨ nɨ-tiañeum bɨumbi, “Yesu biañgan kɨmɨk ba nɨm?” wolok nɨ-nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nɨ-nandumbi, endɨ nɨ-dakle-ñɨmɨumbi, Pilatolɨ Josep nandɨ-ñɨmguk. ");
INSERT INTO nif_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tɨmbi Joseptɨ ñambi, sandum satnin ombap no tuambi, Yesulok dalandan kloñbat plon nanin tɨmbɨ bɨndɨlɨm pɨumbi tɨke-ñambi, sandumdɨ tɨmɨpi imguk. Im-talembi, kawat gɨnañ enlok gɨñgɨt kulukɨlɨñnan wolok ña kɨmɨkuk. Kɨmɨpi, kawat wopum no munjulɨmbi ña sum yama masipguk. ");
INSERT INTO nif_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Endɨ wɨndɨñ tɨñɨlɨmbi, Malia Makdala nanin gɨta Malia Joseslok meñ endɨ “Yesulok dalandan delok kɨmɨletak?” wɨndɨñ kɨmɨt-nandɨmbi ka-tuakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat patnandɨ nain taleumbi, Malia Makdala nanin en gɨta Malia Yakobo meñ tɨmbi Salome, endɨ salasalanan kandañ ñam, Yesulok dalandan saple-ñɨmnelɨñdok gwasap gɨt pama tul tuambi tɨ-jumɨt tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kena nain kusei kɨmɨkɨmɨlɨnan sala mulum tɨmbɨmbi, tam endɨ mɨlapi isɨ bimbi, Yesulok sum telak wɨn kle ñañɨlɨmbi, kwet salañguk. ");
INSERT INTO nif_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Endɨ telak plon ñañɨpi, nɨsɨñgan nandɨ-mɨlatambi eñgɨlɨñ, “Nindɨ nɨp kɨmɨpi, kawat wopum sum yama masip patak wɨn munjupi, dlɨtom nɨmetak?” ");
INSERT INTO nif_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Wɨndɨñ eñɨpi ña sumnan tombi, deium ñaumbi kañgɨlɨñ wɨn: kawattɨ sum yama kɨmɨsip pakuk wɨn ikan munjulɨmbi, tambon kandañ ña pakuk. Kawat wɨn wopum sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Tɨmbi endɨ sum gɨnañ lombi, ama gwañgwa no kɨt dɨndɨm kandañ pipalɨm kañgɨlɨñ, endok dasindasin ombap satnin sɨnɨk. Tamdɨ ama wɨn kañbi sɨlɨkñeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tɨmbi endɨ enguk, “Nɨm sɨlɨkñenelɨñ! Sɨndɨ Yesu Nasalet nanin kloñbat plon wɨkɨlɨñ en kanepi bañ, gan endɨ ñɨ nɨm patak. Kwel kɨnjangot ñɨ kawɨt! En ip mɨlalak. ");
INSERT INTO nif_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kak, ñawɨt! Sɨndɨ gwañgwañii gɨt Petlo endoñ ñambi, ñɨndɨñ enbɨt, ‘Yesulɨ manda dama sanguk wolok tuopgan endɨ telak dama tɨ-sambi, Galili kwelan ñaumbi, wolok kanekalɨñ.’” ");
INSERT INTO nif_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Eumbi, gembɨnjɨ pɨum blañblañ tɨmbi, sum bim pi ñañgɨlɨñ. Pi ñañɨpi, mɨsɨñgɨlɨñda tɨmbi ama nola nepek nek indañguk wolok kasat nɨm tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kena nain kusei kɨmɨkɨmɨlɨnan Yesulɨ salasalanan kɨmnan nanin mɨlapi, dama sɨnɨk Malia Makdala nanin endoñ indañguk. (Lap kandañ endɨ yal kolan kɨt tambon tɨpet tam endoñ gɨnañ ep kle-kokuk.) Yesulɨ tam endoñ indaum ");
INSERT INTO nif_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","pɨ-ñambi, ama Yesu gɨta kuñgɨlɨñ endoñ ñañguk. Ña yambumbi, kut-blanbla e-palɨñɨlɨmbi, nepek nek indañguk wolok tuop kasat tɨ-sembi ");
INSERT INTO nif_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","eñguk, “Yesu kaik palɨmbi kat.” Gan amalɨ manda wɨn nandumbi tlal tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wolok siñgi kandañ gwañgwañiit tɨpet endɨ Jelusalem it kwelan nanin pɨ-ñañɨlɨmbi, Yesu siñgin walan tɨkɨleumbi inda-semguk. ");
INSERT INTO nif_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Inda-semum undane-ñambi, nosiila kasat tɨ-semgɨmɨk. Gan endɨ nandumbi, wɨn bo tlalgot tɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tɨmbi gwañgwañii 11 endɨ nana na-palɨñɨlɨmbi, Yesulɨ siñgi endoñ bo inda-semguk. Inda-sembi, amatam en mɨlalɨmbi kañgɨlɨñ endok mandanjɨ nɨm nandɨ-kɨlɨk tɨmbi, gɨnañ kwambɨ tɨmbi, nandum tlal tɨñguk wala enombɨñguk. ");
INSERT INTO nif_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Tɨmbi enguk, “Sɨndɨ kwet tuop ñambi, nokok gɨñgɨt manda kɨndem ñɨn amatam gɨtɨkta eu sapakñaneukak! ");
INSERT INTO nif_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","No endɨ miti tuk i-talembi, gɨñgɨt manda kɨndem nandɨ-kwambɨñ dalakta, en wakan Yambattɨ tɨke-kɨmɨlekak. Gan no endɨ nandum tlal tɨlakta, enlok kusei tɨmbɨ dakleumbi, tambon ombɨ-tɨkeukak. ");
INSERT INTO nif_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tɨmbi Yambattɨ amatam gɨñgɨt manda kɨndem nandɨ-kwambɨñ dañ wɨn ep tɨmbɨ pañgɨtaumbi, kundit engano ñandin tɨnekalɨñ: endɨ yal kolan nokok kotna plon ep kle-kopi, manda komblin kwet dɨwɨndoñ wɨn enekalɨñ. ");
INSERT INTO nif_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tɨkap endɨ malet sañan upmat kɨsɨlɨ tɨke-lonelɨñ ba tuk kolan upmat nanelɨñ, nepek walɨ nɨm ep tɨmbɨ kolanekalɨñ. Tɨmbi endɨ wakan ama jɨmbasat endok plon kɨsɨ kɨmɨpi ep tɨmbɨ kɨndem danekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wopum Yesulɨ manda wɨn enɨ-taleumbi, Yambattɨ kunum gɨnañ tɨke-loñguk. Tɨke-loumbi, Yambat enlok kii dɨndɨmnan pip palɨmbi, yakan kunum kwet yambɨ-dɨkñeamɨk. ");
INSERT INTO nif_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tɨmbi gwañgwañiilɨ kwet tuop ñambi, gɨñgɨt manda kɨndem eu pɨñguk. Wɨndɨñ tɨmbɨmbi, Wopumdɨ mandanjɨ kwambɨñ dawɨktok ep tɨmbɨ pañgɨtaumbi, kundit engano sɨnɨk tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yambattɨ nepek gɨtɨk nɨndok boñgɨpnɨnan tɨmbɨ indañguk wolok kasat ama asuptɨ nanandɨnjɨlok tuop kiupi youkɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","wɨn kusei kɨmɨkɨmɨlɨnan nanin nepek indañguk wɨn dausɨlɨ kañbi, gɨñgɨt manda e-daut kena tɨñgɨlɨñ endɨ kasat wɨn tɨ-nɨmgɨlɨñ, wolok tuop endɨ wɨndɨñgangot kiupi youkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tɨmbi nak nepek gɨtɨk indañguk wɨn nain ombapgan e-lonjɨ kena tɨ-kɨliñ eñgutta tɨmbi ñɨndɨñ tɨmbettok nandɨlet: nak bo nepek indañguk wolok kasat sambat plon kɨmɨp youpi, lolona Tiofilus dɨka yout-gametat. ");
INSERT INTO nif_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wɨndɨñ tɨmbambi, ñɨndɨñ nandɨ-dakleukañ: nepek wolok kasat tɨ-gamgɨlɨñ walɨ biañgan wɨndɨñgan indañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Elottɨ Judia kwettok ama wapmañjɨ kuñɨlɨmbi, tapma ama no kuñguk koi Sakalaia. Endɨ telak dama no koi Abia endok sambat gɨta tapma it gɨnañ kena pa tɨlɨñguk. Tamɨn Elisabet endɨ bo Alondok sambat. ");
INSERT INTO nif_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wapatam tɨpet endɨ Yambattok dainan dɨndɨm sɨnɨk kumbi, Wopumdok endɨkñe manda ba telak gɨtɨk kɨmɨt-kleñgɨmɨkta yomjet no nɨm pat-semguk. ");
INSERT INTO nif_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gan Elisabet endɨ yamɨn pakukta tɨmbi endɨ gwañgwanjet bɨsat nɨmnat papi, gɨlɨk sɨnɨk tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nain nola ñɨndɨñ indañguk: Abialok sambat endɨ tapma ilan kena tɨndɨlok nain inda-semumbi, Sakalaialɨ bo Yambattoñ tapma tɨñmepi lom pakuk. ");
INSERT INTO nif_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Palɨñɨlɨmbi, tapma amalɨ “Wopumdɨ pataknan nindɨ lombi, pama mɨlɨñat si-ñɨmetak?” embi, tapma ama nɨsɨlok ep tɨndɨnjɨ klembi, tɨmbɨ-inda sañala kokɨlɨñ. Kolɨmbi, Sakalaia tɨmbɨ indaumbi, it gɨnañnan loñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pama mɨlɨñat sinjilok nain indaumbi, amatam asuptɨ tapma it sañ jimba gɨnañ kɨmɨn tɨmbi, nɨmolo tɨ-pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tɨmbi Wopumdok eñalo nolɨ Sakalaialoñ inda-ñɨmɨmbi, pama sinjilok sisuat wolok kɨt dɨndɨm kandañ ikuk. ");
INSERT INTO nif_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ilɨ kañbi ka-sɨlɨkñembi, kolan mɨsɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gan eñalolɨ ñɨndɨñ nɨñguk, “Sakalaia, dɨk nɨm mɨsɨwɨñ. Yambattɨ ikan nɨmoloñga nandɨñgukta ñɨndɨñ tɨ-gamekak: tamga Elisabet endɨ nɨñañga no apmɨumbi, koi Yoane kɨtɨukañ. ");
INSERT INTO nif_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Enda tɨmbi sɨmbaka kɨndem daumbi, sɨlɨsɨlɨ wopumdɨ gɨnañga tokñeukak. Tɨmbi endok indaindañɨla amatam asuptɨ bo sɨlɨsɨlɨ tɨ-ñɨmɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Kusei ñɨndɨñda wɨndɨñ tɨnekalɨñ: Wopumdɨ enda nandum loloñ sɨnɨk tɨlak. Gwañgwa walɨ kuñgun Wopum bi-ñɨmekakta tɨmbi wain ba tuk kimbɨñ nɨm nambekak. Tɨmbi endɨ meñ sɨmbai gɨnañnan palɨñɨlɨmbi, Dɨndɨm Woñdɨ tokñe-ñɨmumbi kuukak. ");
INSERT INTO nif_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Endɨ Islael amatam asup gɨnañjɨ ep tɨmbɨ tambanembi, Wopum Yambatsɨloñ undane ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yambattok gembɨ ba Woñ plofet Elialoñ palmɨñguk wɨndɨñgangot nɨñañgaloñ bo palmɨmbi, Wopumdok telak dama tɨmbekak. Endɨ bepsiilok gɨnañjɨ tambaneumbi, gwañgwanjii nombo wale kɨndem tɨ-semnekalɨñ, tɨmbi ama Yambattok manda wɨkañ endok gɨnañjɨ tambaneumbi, ama dɨndɨm kuañ endok nanandɨnjɨ klenekalɨñ. Wɨndɨñ tɨñɨpi, endɨ Wopum bɨmbɨñdok tɨ-pañgɨpañgɨle tɨ-semekak.” ");
INSERT INTO nif_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Tɨmbi Sakalaialɨ eñalola nɨmbi eñguk, “Mandañgala nɨtek nandɨwambi, biañgan tɨmbek? Nak gɨlɨk sɨnɨk tɨñgut, tɨmbi tamna endɨ bo gwɨlat asupgan makleñguk wɨn!” ");
INSERT INTO nif_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Eumbi nɨñguk, “Nak eñalo Gabliel, tɨmbi nak Yambattok ñasɨñgan kuñɨpi, kena pa tɨlet. Tɨmbi nak dɨkɨta manda embi, gɨñgɨt manda kɨndem ñɨn ganganlok embi, nanɨ-mulɨmbi bɨt. ");
INSERT INTO nif_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ale, dɨk nandɨ: gɨñgɨt manda ganɨt wolok tuop Yambattɨ nain kɨmɨkuknan indaukak. Gan dɨk mandana nɨm nanandɨ-kɨlɨk tɨlañda tɨmbi nak mañga kɨmɨsip gamambi, slak mañga kwap em palɨmbi, nepek ganɨt walɨ bien indaukak wolok tuop.” Eñalolɨ wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sakalaialɨ nain ombap tapma it gɨnañ sakñelam pakukta tɨmbi amatam mandɨ-pakɨlɨñ endɨ nandɨ-bendɨ tɨ-ñɨmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Tɨmbi endɨ sañ jimba gɨnañ pɨñguk nain wolonda endɨ manda enbektok tuop nɨm. Slak man kwap em papi, kɨttɨñgot tɨñgukta tɨmbi amatamdɨ “Endɨ tapma it gɨnañ nepek engano sɨnɨk no kañak” wɨndɨñ nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tapma ilan kenan tɨndɨlok nainñɨn taleumbi, Sakalaialɨ ilnan undane ñam ");
INSERT INTO nif_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","pat-ta-ñaumbi, tamɨn Elisabet endɨ gwañgwa mɨnjɨp tɨñguk. Tɨmbi yakɨp kɨt tombon endɨ ilnan gitakan pat-sembɨmbi, ñɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wopumdɨ nain ñɨndɨñgɨt nandɨ-nambi, amatamdok dausɨnan maetna tɨmbɨ tale-namektok ñɨndɨñ tɨmbɨ inda-namlak.” ");
INSERT INTO nif_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabettɨ yakɨp kɨt tombon noñgan gwañgwa mɨnjɨp tɨ-palɨñɨlɨmbi, Yambattɨ eñalo Gabliel Nasalet it kwelan Galili kandañ patak wandɨñ nɨ-mulɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","tam sim no ama gɨta gama nɨm kuñgun koi Malia endoñ ñañguk. Ama wapmañ Devit damañgan kuñguk endok komblin koi Josep tam sim wɨn endok gɨñgɨt wɨlɨmum pakuk. ");
INSERT INTO nif_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Eñalolɨ Malialoñ tombi we ñɨmɨmbi nɨñguk, “Wopumdɨ gɨnañ sɨloñ kɨndem tɨ-gambi, dɨkɨta patak.” ");
INSERT INTO nif_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wɨndɨñ eu nandɨmbi, gɨnan mɨlalɨmbi, nanandɨn nɨm dakleumbi, gɨnan gɨnañ “Manda wolok kusei wɨn nek?” embi, nanandɨ kena tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tɨmbi eñalolɨ nɨmbi eñguk, “Malia. Yambattɨ gɨnañ kɨndem tɨ-gambi nandɨ-gamlak, wala tɨmbi nɨm mɨsɨwɨñ! ");
INSERT INTO nif_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nandɨlañ. Dɨk gwañgwa mɨnjɨp tɨmbi, gwañgwa tɨkeukañ endok koi Yesu kɨtɨukañ. ");
INSERT INTO nif_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Endɨ ama wopum palɨmbi, Yambat Loloñ Sɨnɨk endok nɨñañ nɨnekalɨñ. Bep pañ Devit endɨ Islael amatamdok ama wapmañjɨ kuñguk, wɨndɨñgangot Wopum Yambattɨ en ama wapmañjɨ kɨmɨlɨm papi, ");
INSERT INTO nif_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","nain taletalen nɨmnat Jekoptok sambat, wɨn Islael amatam, yambɨ-dɨkñembi, endok ama wapmañjɨ kuukak.” ");
INSERT INTO nif_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tɨmbi Malialɨ eñalo nɨ-nandɨmbi eñguk, “Nepek wɨn nɨtek indaukak? Nak ama gɨta gama nɨm kuñgut, wala.” ");
INSERT INTO nif_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Eumbi tambane nɨñguk, “Dɨndɨm Woñdɨ dɨkoñnan pɨumbi, Yambat Loloñ Sɨnɨk endok gembɨnlɨ gep tapliukak, wala tɨmbi gwañgwa apmekañ endɨ giñgi sɨnɨk, tɨmbi Yambat enlok Nɨñañ nɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dɨkok sambatka tam no Elisabet en nandɨ-ñɨmlañ. Endɨ gɨlɨk, tɨmbi ‘En yamɨn’ wɨndɨñ nɨñgɨlɨñ, gan man ñɨndɨñgɨt endɨ bo gwañgwa mɨnjɨpmat kuumbi, yakɨp kɨt tombon noñgan ñalak. ");
INSERT INTO nif_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nekta, Yambattɨ nepek no tuop nɨm tɨmbek no nɨm patak.” ");
INSERT INTO nif_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Eumbi, Malialɨ tambane nɨñguk, “Ale. Nak Wopumdok kena wembe sɨlanin. Manda elañ, wolok tuop inda-namun.” Wɨndɨñ eumbi, eñalolɨ en kañ bimbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Wolonda Malialɨ tɨ-wɨlɨ dɨkñe tɨmbi, Galili kwet bimbi, Judia kwet pɨñɨlopɨlatnan platik sɨnɨk ñambi, it kwet nolok tomguk. Tombi, ");
INSERT INTO nif_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sakalaialok ilnan lombi, endok tamɨn Elisabet we ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","We ñɨmɨumbi nandumbi, wolongan gwañgwa Elisabettok sɨmbai gɨnañ pakuk walɨ gembɨnatgan sasɨk tɨñguk. Tɨmbi Dɨndɨm Woñdɨ endok gɨnañnan tokñeumbi, ");
INSERT INTO nif_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","wopumgan kɨtɨmbi, ñɨndɨñ eñguk, “Tam nɨndok boñgɨpniinan dɨk wakan gwɨlam gamgamɨn, tɨmbi gwañgwa tɨkeukañ wɨn wɨndɨñgangot gwɨlam ikan mɨmɨn.” ");
INSERT INTO nif_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Elisabettɨ wɨndɨñ embi yousɨmbi nɨñguk, “Gan nɨtek tɨmbi dɨk Wopumnalok meñlɨ tam pɨmbɨñen nak ñandin nokoñ bɨlañ? ");
INSERT INTO nif_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nak Wopumnalok meñ ganlet wɨn kusei ñɨndɨñda: nak dɨk we nameñ wɨn nandɨt nain wolondañgan gwañgwa nokok sɨmbatna gɨnañ patak endɨ sɨlɨsɨlɨ tɨmbi, sasɨk tɨk. ");
INSERT INTO nif_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tɨmbi Wopumdɨ nek ganguk wolok tuop indaukak wɨn nandɨ-kwambɨñ dambi tɨke-kulañda, amatam dɨwɨn yapma kle-patañ.” ");
INSERT INTO nif_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tɨmbi Malialɨ ñɨndɨñ eñguk, “Walenalɨ Wopum nɨ-loloñ elak, ");
INSERT INTO nif_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yambat nep kɨmɨtak enda gɨnañna tiptɨ nandɨ-koñgom tɨ-ñɨmlak. ");
INSERT INTO nif_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Nekta, nak endok kena wemben pɨmbɨñen, gan endɨ wandingan embi nandɨ-namguk, wɨn Yambat Gembɨ Molom endɨ kundit wopuwopum asup tɨ-namguk, wala tɨmbi amatam man ñɨndɨñgɨt kuañ ba siñgi kunekalɨñ endɨ naka ‘amatam dɨwɨn yapma kle-patak’ wɨndɨñ nanɨnekalɨñ. Endɨ Yambat dɨndɨm ba giñgi sɨnɨk, ");
INSERT INTO nif_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","amatam giñgiñgan tɨ-ñɨmañ busuk mamasa tɨ-sembi, ama sambat no ba no siñgi indanekalɨñ enda wɨndɨñgangot tɨ-sem-ta-ñaukak. ");
INSERT INTO nif_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Endɨ kundit gembɨnat pa tɨñɨpi, ama gɨnañjɨ gɨnañ nɨsɨla nandum loloñ tɨñguk wɨn ep tɨmbɨ papuseneñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Endɨ ama wapmañ gembɨnjɨat pipapatsɨ apma tɨke-sembi, amatam kosɨ nɨmnat enda kot gɨñgɨt emguk. ");
INSERT INTO nif_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Endɨ amatam nepenepekta lonjɨñgɨlɨñ enda gɨnañ sɨloñ tɨ-semumbi, nombo nɨm lonjɨñgɨlɨñ, gan amatam nepek asup pat-semguk wɨn enɨ-mulɨmbi, slak pɨm ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nɨndok bep pañniila enɨ-kwambɨñ dañguk wolok tuop endɨ kena gwañgwañii Islael wakan epmɨ platambi, Ablaam gɨta komblinñii nandɨ-sembi, busuk mamasa nain taletalen nɨmnat tɨ-semektok nɨm nandɨ-kamalañguk.” ");
INSERT INTO nif_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Malialɨ wɨndɨñ eu taleumbi, yakɨp tɨpet gɨt no ba nek Elisabet gɨta papi, undanem ilnan ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabettɨ gwañgwa tɨketɨkelok nain indaumbi, nɨñañ apguk. ");
INSERT INTO nif_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Endok sambalii gɨt ilnan nasiilɨ Wopumdɨ gɨnañ busuk tɨ-ñɨmɨñguk gɨñgɨt wɨn nandɨmbi, en gɨta sɨlɨsɨlɨ tɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","sande noñgan taleumbi, gwañgwa pɨñgɨu dɨp dombɨnepi bɨñgɨlɨñ. Bɨmbi, beulok koi Sakalaia wɨn kɨtɨnepi eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","gan meñlɨ “Wɨn nɨm” eñguk. Embi, “Koi Yoane kɨtɨkɨtɨlok” eñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eumbi nɨñgɨlɨñ, “Sambatsettok boñgɨpsɨnan ama no koi Yoane no nɨm patak.” Wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","kɨttɨñgan beu nɨ-nandɨmbi eñgɨlɨñ, “Dɨk kot nek mɨmɨlok nandɨlañ?” Eumbi, ");
INSERT INTO nif_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","kundit youyouttok nepenepela enbɨmbi, tɨke bɨ mɨumbi, “Koi Yoane” youkuk. Youlɨmbi, wɨn kañbi nandɨ-bendɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Tɨmbi wolongan Sakalaialok man mamben salaktaumbi, kusei kɨmɨpi, manda embi, Yambat nɨ-kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nepek wɨndɨñ inda-ñɨmɨumbi, il kwelnan nasilɨ kundit wɨn kañbi mɨsɨñgɨlɨñ. Tɨmbi nepek indañguk wolok gɨñgɨttɨ sapakñanembi, Judia kwet jañgɨnnan tuop ña-taleñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tɨmbi kasat wɨn nandɨñgɨlɨñ endɨ gɨtɨk nandɨ-kwɨnakwɨnalembi, Wopumdɨ gwañgwa wɨn gembɨnlɨ kasopmɨlak wɨn ka-nandɨ-tomgɨlɨñda ñɨndɨñ e-nandɨñgɨlɨñ, “Gwañgwa walɨ bendɨ wopum dambi, ama nɨtein sɨnɨk indaukak?” ");
INSERT INTO nif_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tɨmbi Dɨndɨm Woñdɨ Yoanelok beu Sakalaialok gɨnan tokñeumbi, Yambattɨ manda eelok nɨñguk wolok tuop embi, ñɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nɨndɨ Wopum, Islaellok Yambat, en kusei ñɨndɨñda nɨ-kɨndekɨndem tɨ-ñɨmɨna: endɨ amatamñii nandɨ-nɨmbi, toptop kolan gɨnañ nanin nɨp tuambi, nɨp kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Endɨ enlok kena aman Devit endok komblinñii boñgɨpsɨnan nanin ama gembɨnat no nɨp kɨmɨlektok tɨmbɨ inda-nɨmguk, ");
INSERT INTO nif_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","wɨn damañgan plofet amañiila enbɨmbi eñgɨlɨñ wolok tuop. ");
INSERT INTO nif_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Endɨ kanjɨknii ba ama gɨtɨk nandɨ-kola tɨ-nɨmañ endok kɨsɨnan nanin nɨpma tɨkeuktok wɨndɨñ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Endɨ bep pañnii busuk mamasa tɨ-sembi, en gɨta toptop tɨñguk wɨn nɨm nandɨ-kamalaukak. ");
INSERT INTO nif_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Endɨ enlok koi plon sotnɨ Ablaam ñɨndɨñ nɨ-kwambɨñ dañguk: ");
INSERT INTO nif_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","endɨ nandɨ-nɨmbi, kanjɨkniilok kɨsɨnan nanin nɨpma tɨkembi, nɨp tɨmbɨ pañgɨtaumbi, mɨsɨmɨsɨ nɨmnat nɨ-wowoñ tɨñɨpi, ");
INSERT INTO nif_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kuamɨñ tuop endok dainan gɨñgɨtñiiñgot dɨndɨm ku-ta-lonekamɨñ. ");
INSERT INTO nif_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tɨmbi nɨñana dɨkok kandañ nak ñɨndɨñ elet: Yambat Loloñ Sɨnɨk endɨ dɨk enlok plofet aman ganbekak. Nekta, dɨk Wopumdok telak dama tɨmbi, telak tɨ-dɨndɨm e-ñɨmekañ, ");
INSERT INTO nif_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","wɨn dɨk amatamñii ñɨndɨñ enɨ-daut tɨ-semekañ: ‘Wopumdɨ sepmektok nandɨlak, wolok tuop yomjɨ bi-samekak.’ ");
INSERT INTO nif_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nɨndok Yambatnɨ endɨ gɨnañ busuk molomda tɨmbi wɨndɨñ tɨlak. Endɨ ama wɨn nɨ-mulɨmbi, maim sonan wandin endɨ kunum gɨnañ nanin nɨndoñ pɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ama yomjɨla tɨmbi kɨlɨm gɨnañ kɨmdok gɨñgɨt kuañ kolɨ sale-semlak, endɨ busuktok telaknan nɨnañgɨlɨmbi kunekamɨñ.” Sakalaialɨ plofet manda wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tɨmbi gwañgwa walɨ bendɨ wopum daumbi, gɨnan tiptɨ wɨndɨñgot gembɨlañguk. Tɨmbi endɨ kwet ama nɨmnatnan ña ku-ta-ñakap, nain wɨn indaumbi, Islael amatamdok dausɨnan inda-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nain wolonda Sisa Augustos Roma kwet gɨtɨk kiup ka-dɨkñeñguk endɨ kwet tuop kot sambat tɨmbektok nandɨmbi, wolok tuop endɨkñe manda no kɨmɨlɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Kwiliniuslɨ Sisalok kapmainan Silia provinslok kandɨkñe ama kuñguk nain wolonda kot sambat walɨ indañguk. Damañgan wandin no nɨm tɨndɨn.) ");
INSERT INTO nif_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Wɨndɨñda amatam gɨtɨktɨ kosɨ kɨmɨtnepi bep pañ kasatsɨlok isɨ kuseinan ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseptɨ wɨndɨñgangot tɨñguk. Endɨ ama wapmañ damañgan kuñguk koi Devit endok sambatta tɨmbi, Nasalet it kwet Galili kwelan patak wɨn bimbi, Judia kwelan ñambi, Devittok il kusei koi Betleem wolok ñaupi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ñambi, Malia gɨñgɨt wɨlɨmɨum papi, gwañgwa mɨnjɨp tɨñguk en nañgɨlɨmbi, yakan koset kɨmɨttepi ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ña tom palɨñɨlɨmbi, gwañgwa tɨketɨkelok nain indaumbi, ");
INSERT INTO nif_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Malialɨ gwañgwa telak dama tɨkeñguk. Tɨkembi, sandumdɨ tɨmɨp imbi, makauttok jawañ gɨnañ kɨmɨkuk. Wɨn it kiyau tokñeñgukta tɨmbi makauktok ilan lo pakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tɨmbi wandɨñ kandañ sipsip kandɨkñe ama dɨwɨn endɨ Betleem it kwet pawan pa kumbi, sipsip kaulɨ-dɨkñe kena tim tɨ-pakɨlɨñ. Tɨ-palɨñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wopumdɨ eñalo no nɨ-mulɨm endoñ bɨ indaumbi, Wopumdok kolsalen walalan bien endok plon youlɨm kañbi, kolan mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Gan eñalolɨ enguk, “Sɨndɨ nɨm mɨsɨnelɨñ! Nak gɨñgɨt manda kɨndem no sɨndoñ tɨke bɨlet, tɨmbi manda walɨ amatam gɨtɨk gɨnañjɨ youlɨmbi, sɨlɨsɨlɨ tɨnekalɨñ. Manda wɨn ñɨndɨñ: ");
INSERT INTO nif_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ama ñɨn Yambat en amatamñii sepmektok nɨ-mutak, wɨn Mesia Wopumnɨ, endɨ man tim ñolondañgan Devittok il kwel Betleem wolok inda-samlak. ");
INSERT INTO nif_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Nak manda biañgan elet wɨn sɨndɨ ñɨndɨñ ka-nandɨnetañ: sɨndɨ gwañgwa gɨmɨn wakan tɨmbɨ indaumbi, sandumdɨ tɨmɨp imbi, makauktok jawañ gɨnañ kɨmɨlɨm palɨm kanetañ.” ");
INSERT INTO nif_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eñalolɨ wɨndɨñ eumbi, platik sɨnɨk eñalo kɨmɨn wopumdɨ kunum gɨnañ nanin pɨ indambi, Yambat nɨ-kɨndem dambi, ñɨndɨñ eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kunum loloñen gɨnañ Yambattok koi nɨ-ta-lowɨt, tɨmbi kwelan amatam gɨnañ kɨndem tɨ-semlak endok kandañ busuk pat-semekak.” ");
INSERT INTO nif_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tɨmbi eñalolɨ yambimbi, kunum gɨnañ undane ña-taleumbi, sipsip kandɨkñe amalɨ nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, “Yakñe! Nepek indalak wɨn Wopum en nɨnɨ-daklelak, wala tɨmbi Betleem ñambi kana!” ");
INSERT INTO nif_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wɨndɨñ embi, platik sɨnɨk ñambi, Malia gɨt Josep ep tɨmbɨ indaumbi, gwañgwa wɨn wakan makauktok jawañ gɨnañ palɨm kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kañbi, eñalolɨ gwañgwa wolok plon manda enguk wɨn kasat tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tɨmbi amatam sipsip kandɨkñe amalok kasat wɨn nandɨñgɨlɨñ endɨ gɨtɨk nanandɨ kena tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gan Malia endɨla manda wɨn gɨtɨkgan gɨnan gɨnañ dasimbi, nandɨ-kwɨnakwɨnalembi pa kulɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tɨmbi sipsip kandɨkñe amalɨ undanem kenanjɨnan pɨ ñañgɨlɨñ. Ñañɨpi, nepek gɨtɨk eñalolɨ enguk wolok tuop indañgukta tɨmbi endɨ nepek gɨtɨk nandɨmbi kañgɨlɨñ wolok Yambat nɨ-kɨndekɨndem embi, koi nɨ-ta-loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sande noñgan taleñɨlɨmbi, gwañgwa gɨmɨn pɨñgɨu dɨp dombɨndombɨlok nain indaumbi, meñ beulɨ koi Yesu kɨtɨñgɨmɨk. Endɨ gama meñ sɨmbai gɨnañ nɨm palɨñɨlɨmbi, eñalolɨ koi wakan ikan kɨtɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moselɨ endɨkñe manda dɨwɨn kɨmɨkuk walɨ ñɨndɨñ elak: tam gwañgwa ikan tɨketɨken endɨ nɨtek tɨmbi, bɨndambo Yambattok dainan tɨ-jamilambi, gumañ enloñ ñauk. Endɨkñe manda wɨn kɨmɨt-klendemɨktok nain indaumbi, Malia gɨta Josep endɨ gwañgwa tɨkembi, Wopum enlok bi-ñɨmɨndepi Jelusalem ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Endɨ Wopumdok endɨkñe manda ñɨn tañgonendemɨktok wɨndɨñ tɨñgɨmɨk, “Sɨndɨ ama ba ilalok gaut wapai telak dama indañ gɨtɨk Wopum enlok bi-ñɨmɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tɨmbi Wopumdok endɨkñe mandalɨ elak wolok tuop endɨ “mambaip sim tɨpet ba monɨk no mambaip wandin tɨpet” tapma tɨndemɨktok nandɨm ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nain wolonda ama no Jelusalem kuñguk koi Simeon. Endɨ ama dɨndɨm, Yambattok endɨkñe manda kɨmɨt-klembi, ama nin Yambattɨ nɨ-mulɨmbi Islael amatam enɨ-busuk tɨ-semekak en mandɨmbi kuñguk. Tɨmbi Dɨndɨm Woñdɨ en gɨta papi, ");
INSERT INTO nif_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ñɨndɨñ nɨ-dakle-taleñguk: endɨ gama kuñɨpi, Wopumdɨ Mesia nɨ-mulektok e-kwambɨñ dañguk wɨn kaukak. ");
INSERT INTO nif_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tɨmbi Dɨndɨm Woñdɨ Simeon tapma it sañ jimba gɨnañ nɨ-mulɨmbi lo pakuk. Palɨmbi, Yesu meñ beulɨ endɨkñe mandalɨ elak wolok tuop tɨ-ñɨmɨndemɨktok en wandɨñ tɨke ñaumbi, ");
INSERT INTO nif_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeondɨ gwañgwa wɨn kañbi tɨke apmbi, Yambat we ñɨmɨmbi nɨñguk, ");
INSERT INTO nif_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Molom, dɨk manda nanguñ wolok tuop inda-talelak, wala tɨmbi man ñɨndɨñgɨt kena gwañgwañga nandɨ-namumbi, busukñenengan semba. ");
INSERT INTO nif_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nak ama nindɨ gamanda amatamgai nɨpmekak en ip dautnalɨ kalet. ");
INSERT INTO nif_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Dɨk en ikan nɨmbɨ taleumbi nɨ-mulɨm amatam gɨtɨktɨ en kanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tɨmbi Islael amatamgai nɨnda kot gɨñgɨt nɨmekak, ba amatam dɨwɨndok telaka kolɨ sale-semekak.” ");
INSERT INTO nif_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeondɨ gwañgwala wɨndɨñ eumbi, meñ beulɨ wɨn nandɨmbi, nanandɨ kena tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Tɨmbi Simeondɨ gwɨlam tɨ-sembi, Yesu meñ Maliala ñɨndɨñ nɨñguk, “Nandɨlañ. Yambattɨ gwañgwa ñɨn nɨmbɨ taleumbi, Islael amatam asup endɨ en kɨmɨt-kleañ ba nɨm wolok tuopgan Yambattok dainan pi pɨnekalɨñ ba it-kwambɨñ danekalɨñ. Gwañgwa walɨ kɨmɨsalen no wandin Yambat en kɨmɨkuk, gan amatam asuptɨ siñgi wɨlɨmnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Enda tɨmbi amatam gɨnañ nanandɨnjɨ sembɨn wɨn tɨmbɨ dakle-taleukak. Tɨmbi nepek nɨñañgala inda-ñɨmekak kusei wala tɨmbi sɨmba gawattɨ kakit man pɨsɨkñat nomɨk waleñga bo youlekak.” Simeondɨ wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tɨmbi plofet tam gɨlɨk no kuñguk koi Ana endɨ bo tapma ilan pakuk. Endɨ Asellok sambat, Fanuellok wemban. Tam sim pakuk wolonda wapat tɨmbɨmbi, gwɨlat kɨt tombon tɨpetgot yakan kuñgɨmɨk. Kukap, ");
INSERT INTO nif_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","wapai sembumbi, slak tam kanjak pat-ta-bɨkap, gwɨlat 84 gɨtɨk ombɨñguk. Endɨ tapma ilan pat-kuñɨpi, tim sandap Yambat nɨ-wowoñ tɨñɨpi, nanañ kɨmɨsipbi, nɨmolo pa tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nain wolondañgan endɨ Yesu meñ beu gɨta Simeon yambɨmbi, endoñ bɨmbi, wolongan gwañgwa wala tɨmbi Yambat we ñɨmɨñguk. Tɨmbi amatam gɨtɨk Mesia Jelusalem nasi mɨlap gɨnañ nanin epmektok indaukak endok mandɨmandɨ kuñgɨlɨñ enda Analɨ gwañgwa wolok indaindanla gɨñgɨt enɨ-ta-ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yesu meñ beulɨ Wopumdok endɨkñe mandalɨ elak wolok tuop tɨ-talembi, iset kwesetnan Nasalet Galili kwelan undane ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tɨmbi gwañgwa wɨn nanandɨn kɨndemlɨ gɨnan tokñeumbi, bendɨ kwambɨñ daumbi, Yambattɨ gɨnañ kɨndem tɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gwɨlat tuop kamaikamai nain indalɨñgukta, Yesulok meñ beulɨ Jelusalem pa ñayañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tɨmbi Yesulok gwɨlat 12 tɨmbɨmbi, tañgɨmɨk tuop klembi, Jelusalem londepi Yesu gɨta ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ña pakap, gwɨlat taleumbi, ilan undane ñandepi, Yesu gwañgwa en Jelusalem kandañ sakñelam pakuk wɨn nɨm ka-nandɨmbi kañɨp ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Endɨ “Tua en amatam asup telak ñañ endok boñgɨpsɨnan ñalak” wɨndɨñ nandɨñɨpi, sandap noñgan nandɨ-bendɨ nɨmnat telak ñañgɨmɨk. Ñambi, kusei kɨmɨpi, sambatsettok ba nosettok boñgɨpsɨnan lonjɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Lonjɨ nɨm kañbi, undane Jelusalem ñañɨpi lonjɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tim sandap tɨpet gɨt no lonjɨlonjɨ kena tɨ-ñambi, gwañgwa tapma it sañ jimba gɨnañ tɨmbɨ indaumbi, kañgɨmɨk wɨn: endɨ endaut ama endok boñgɨpsɨnan pipapi, mandanjɨ nandɨmbi, wolok kuseila enɨ-nandɨ pa tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Endɨ mandanjɨ nandɨ-daklembi, kɨndem tambane-semgukta tɨmbi ama endok mandan nandɨñgɨlɨñ endɨ gɨtɨkgandɨ nandɨ-sɨlɨkñembi, nanandɨ kena tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tɨmbi meñ beulɨ en kañbi ka-sɨlɨkñembi, meñlɨ nɨñguk, “Gwañgwa kambak, nekta ñɨndɨñ sɨnɨk nɨlamɨtañ? Nandɨlañ, beka nɨtɨ gep lonjɨ kuñɨpi, nandɨ-bendɨ wopum tɨ-gamamɨk.” ");
INSERT INTO nif_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eumbi enguk, “Nɨtek tɨmbi nep lonjɨm kuamɨk? Nak Bepnalok ilnan ñolok palettok een wɨn sɨtɨ nɨm nandɨñgɨmɨk ba?” ");
INSERT INTO nif_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Wɨndɨñ eumbi, manda wolok kusei nɨm nandɨ-dakleñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tɨmbi walinin meñ beu gɨta pɨmbi, Nasalet it kwelan undane ñambi, endok kapmainjetnan kuñguk. Tɨmbi meñlɨ nepek gɨtɨk gwañgwalok plon indañguk wɨn gɨnan gɨnañ nandɨ-dasimbi kɨmɨt-nandɨ-kuñguk. ");
INSERT INTO nif_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Tɨmbi Yesulok pɨñgɨulɨ bendɨ wopum daumbi, nanandɨn bo wɨndɨñgangot tɨñgukta Yambat ba amalɨ bo wɨndɨñgot nandɨ-koñgom tɨ-ñɨmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tɨmbi Sisa Taibelius endɨ Roma kwet tuop wolok ama wapmañjɨ kuumbi, gwɨlat 15 tɨmbɨ dumalañguk. Wolonda Pontius Pilatolɨ Sisalok kapmai kumbi, Judia distrik ka-dɨkñeumbi, Elottɨ Galili distrik ka-dɨkñeñguk. Tɨmbi Elottok konombal Filiptɨ Itulia gɨt Tlakonitis distrik ka-dɨkñeumbi, Lisaniaslɨ Abilene distrik ka-dɨkñeñguk. ");
INSERT INTO nif_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Tɨmbi Anas en gɨta Kaiafas endɨ tapma amalok telak damanjɨ kuñgɨmɨk. Nain wolonda Yoane Sakalaialok nɨñañ endɨ kwet ama nɨmnatnan kuñguk. Kuumbi, Yambattɨ manda nɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jodan tuk baliliñ tuop kuñɨpi, manda eu pɨumbi, amatamda ñɨndɨñ enguk, “Yambattɨ yomjɨ bi-samektok sɨndɨ gɨnañ tambatambattok tuk inekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Yoanelɨ kena tɨñguk wɨn plofet Aisaialɨ manda no youkuk wolok tuop indañguk. Endok mandan pepa kwasa gɨnañ ñɨndɨñ youyoulɨn patak, “Ama nolɨ kwet ama nɨmnatnan kuñɨpi, ñɨndɨñ kɨtɨlak, ‘Wopumdok telak tɨ-dɨndɨm e-ñɨmɨt! Telak kelam tɨ-dɨndɨm e-ñɨmɨnekalɨñ! ");
INSERT INTO nif_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kwet wɨlɨñ gɨtɨk taplium tokñeumbi, kwet jañgɨn ba kwet kɨmɨn gɨtɨk tɨ-jamilenekalɨñ. Tɨmbi telak kelam tɨ-dɨndɨm embi, telak lopɨlat yout dɨndɨmembi tɨmbɨ jamilaukak. ");
INSERT INTO nif_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Tɨmbi amatam gɨtɨkgandɨ Yambattɨ telak nɨtek plon epma tɨkeukak wɨn ka-nandɨnekalɨñ.’” Aisaialɨ manda wɨndɨñ youkut wolok tuop Yoanelɨ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tɨmbi nain tuop ama kɨmɨn wopumgandɨ Yoaneloñ bɨmbi, gɨnañ tambatambattok tuk i-semektok nɨmbɨmbi, ñɨndɨñ pa enɨlɨñguk, “Malet sañandok komblinñii, sɨndɨ nokoñ bɨmbi, tukgot inelɨñdok nandañ ba? Nindɨ sanbɨmbi, telak wɨndɨñ Yambattok gimbɨt inda-samekak wɨn maklenelɨñ? Sɨndɨ kolanjɨlok kɨnjanlɨ sapma kleuktok nandañda, ");
INSERT INTO nif_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","gɨnañjɨ tambanembi, wolok bien kuñgunjɨnan tɨmbɨ indaumbi, gɨnañjɨ gɨnañ ñɨndɨñ nɨm nandɨnekalɨñ, ‘Bep pañnɨ Ablaam endok kɨndemla tɨmbi Yambattok gimbɨt maklenekamɨñ.’ Nak sanba nandɨwɨt: Yambattɨ kɨndem kawat ñɨn ep tɨkɨleumbi, Ablaamdok komblinñii indanelɨñ wɨn! Wala tɨmbi sɨndɨ bien kɨndem nɨm laliyañda, kilamek! ");
INSERT INTO nif_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kapinoñgo komba kuseinan ikan kɨmɨkɨmɨlɨn patak. Komba bien kɨndem nɨm pa laliyañ gɨtɨk wɨn jɨnbɨm gɨlo-taleumbi, komba gɨnañ kolɨ pɨm dɨukak.” ");
INSERT INTO nif_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tɨmbi amatamdɨ nɨ-nandɨmbi eñgɨlɨñ, “Wɨndɨñda nɨtek tɨnekamɨñ?” ");
INSERT INTO nif_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eumbi tambane enguk, “No endɨ kiupɨ tɨpet palmɨlakta, ama no kiupɨ nɨmnat enda no mɨlok. Ba nanala wɨndɨñgangot tɨlok.” ");
INSERT INTO nif_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tɨmbi takis epep ama dɨwɨn endɨ wɨndɨñgot tuk i-semektok bɨmbi nɨ-nandɨmbi eñgɨlɨñ, “Endaut, nɨndɨ nɨtek tɨnekamɨñ?” ");
INSERT INTO nif_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eumbi enguk, “Sɨndɨ gavmandɨ takis epnelɨñdok elak wolok tuopgot epbi, nɨm maklenekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tɨmbi mik amalɨ wɨndɨñgangot nɨ-nandɨmbi eñgɨlɨñ, “Tɨmbi nɨndɨla nɨtek tɨnekamɨñ?” Eumbi enguk, “Sɨndɨ ama nolok mɨnem kasɨlenelɨñdok tɨ-piñpiñe nɨm tɨ-ñɨmnekalɨñ, ba manda plon siñgin joñgo nɨm sinekalɨñ. Tambo sɨndɨ kenanjɨlok tuan samañ wala nandum tuop tɨmbekak.” ");
INSERT INTO nif_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tɨmbi amatam Yoanelok mandan nandɨñgɨlɨñ endok gɨnanjɨ mɨlalɨmbi, gɨnañjɨ gɨnañ ñɨndɨñ eñgɨlɨñ, ‘Mesia en wakan bek’. Wɨndɨñ nandɨ-kwɨnakwɨnalembi, nɨtek indawɨk wala mandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tɨmbi Yoanelɨ amatam gɨtɨkta ñɨndɨñ tambane enguk, “Nakta tukgot i-sam tɨ-kulet. Gan ama no indaup tɨlak endok gembɨnlɨ nak napma klelak. Endɨ wakan Dɨndɨm Woñ kombanat i-samekak. Tɨmbi nak pɨmbɨñen ñandin ñalɨ endok kesii gwɨlap kiundɨlɨmettok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ama no plaua mɨnjɨp gɨt gwɨlap ep danbi, mɨnjɨp wɨsɨ-kopi, gwɨlap ba kɨlɨkɨlɨk siu dɨlak, wɨndɨñgangot ama indaup tɨlak endɨ amatam ep danbi, gɨñgɨtñii epbi, dɨwɨn komba taletalen nɨmnat gɨnañ ep siu dɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoanelɨ wɨndɨñ embi, molo manda dɨwɨn asup eñɨpi, gɨñgɨt manda kɨndem amatamda enɨ-ta-kuñguk. ");
INSERT INTO nif_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tɨmbi ama wapmañ Elottɨ konombal Filip endok tamɨn Elodias matɨkeñguk ba tɨ-bomboe kusei kusei dɨwɨn tɨñgukta tɨmbi Yoanelɨ pa nɨ-ñombɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Gan Elottɨ tɨ-bomboen wɨn nɨm ka-daklembi, nombo yousɨmbi, Yoane tɨkembi, it kwambɨñ gɨnañ kɨmɨlɨm pɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yoanelɨ amatam gɨtɨk gɨnañjɨ tambɨneñgɨlɨñ wɨn tuk i-semñɨpi, Yesu bo tuk i-ñɨmɨñguk. Tuk i-ñɨmɨumbi, nɨmolo tɨñɨlɨmbi, kunum gɨnañ dɨlɨ tombɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Dɨndɨm Woñdɨ inda-daklembi, monɨk mambaip walan indambi, endok plon pɨ pipakuk. Tɨmbi kunum gɨnañ nanin kɨtɨkɨtɨ no ñɨndɨñ kɨtɨu pɨñguk, “Dɨk nɨñana noñgan sɨnɨk. Nak gɨnañnalɨ gep kasɨlembi, dɨka walena kɨndem dalak.” ");
INSERT INTO nif_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesulɨ gwɨlat 30 nɨtepek ombɨmbi, kenan kusei kɨmɨkuk. Amatam enda nandɨñgɨlɨñ en Joseptok nɨñañ. Tɨmbi Josep endɨ Elilok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli wɨn Matattok komblin, Matat wɨn Livailok komblin, Livai wɨn Melkilok komblin, Melki wɨn Janailok komblin, Janai wɨn Joseptok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep wɨn Matatiaslok komblin, Matatias wɨn Amoslok komblin, Amos wɨn Nahumlok komblin, Nahum wɨn Eslilok komblin, Esli wɨn Nagailok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai wɨn Maattok komblin, Maat wɨn Matatiaslok komblin, Matatias wɨn Semeindok komblin, Semein wɨn Josektok komblin, Josek wɨn Jodalok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda wɨn Joanandok komblin, Joanan wɨn Resalok komblin, Resa wɨn Selubabellok komblin, Selubabel wɨn Sealtiellok komblin, Sealtiel wɨn Nelilok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli wɨn Melkilok komblin, Melki wɨn Adilok komblin, Adi wɨn Kosamlok komblin, Kosam wɨn Elmadamdok komblin, Elmadam wɨn Erlok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er wɨn Josualok komblin, Josua wɨn Eliesellok komblin, Eliesel wɨn Jolimlok komblin, Jolim wɨn Matattok komblin, Mattat wɨn Livailok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livai wɨn Simeondok komblin, Simeon wɨn Judalok komblin, Juda wɨn Joseptok komblin, Josep wɨn Jonamlok komblin, Jonam wɨn Eliakimlok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim wɨn Melealok komblin, Melea wɨn Menalok komblin, Mena wɨn Matatalok komblin, Matata wɨn Natandok komblin, Natan wɨn Devittok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit wɨn Jesilok komblin, Jesi wɨn Obettok komblin, Obet wɨn Boaslok komblin, Boas wɨn Salmondok komblin, Salmon wɨn Nasondok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason wɨn Aminadaptok komblin, Aminadap wɨn Atmindok komblin, Atmin wɨn Arnilok komblin, Arni wɨn Heslondok komblin, Heslon wɨn Peleslok komblin, Peles wɨn Judalok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda wɨn Jekoptok komblin, Jekop wɨn Aisaktok komblin, Aisak wɨn Ablaamdok komblin, Ablaam wɨn Telalok komblin, Tela wɨn Nahollok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahol wɨn Seluktok komblin, Seluk wɨn Reulok komblin, Reu wɨn Pelektok komblin, Pelek wɨn Ebellok komblin, Ebel wɨn Selalok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela wɨn Kainandok komblin, Kainan wɨn Alpaksattok komblin, Alpaksat wɨn Semdok komblin, Sem wɨn Noalok komblin, Noa wɨn Lamettok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek wɨn Metuselalok komblin, Metusela wɨn Enoktok komblin, Enok wɨn Jalettok komblin, Jalet wɨn Maalalellok komblin, Maalalel wɨn Kainandok komblin, ");
INSERT INTO nif_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainan wɨn Enoslok komblin, Enos wɨn Settok komblin, Set wɨn Adamdok komblin, tɨmbi Adam wɨn Yambattɨ tɨmbɨ indañguk. ");
INSERT INTO nif_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tɨmbi Yesulɨ tuk i-taleumbi, Dɨndɨm Woñdɨ gɨnan gɨnañ tokñe palɨmgukta nañgɨlɨmbi, Jodan tuk bim kwet ama nɨmnatnan ña kuñguk. ");
INSERT INTO nif_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wandɨñ tim sandap 40 dou mɨlat tɨ-kuñɨlɨmbi, Satandɨ tɨ-kuyuk pa tɨ-ñɨmɨñguk. Nain wolonda nanañ no nɨm nam, slak kuñɨlɨmbi, tim sandap walɨ taleumbi, nanañ gawat tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tɨmbi Satandɨ ñɨndɨñ nɨñguk, “Dɨk Yambattok Nɨñan sɨnɨkta, kusaka tɨmbɨ dakleuktok kawat ñɨn nɨmbɨmbi, nanañ indawɨn!” ");
INSERT INTO nif_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Eumbi tambane nɨñguk, “Wɨndɨñ nɨm. Yambattok manda no ñɨndɨñ youyoulɨn patak, ‘Ama nanañlɨñgot kuñgun mɨuktok tuop nɨm.’” ");
INSERT INTO nif_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tɨmbi Satandɨ kwet loloñen nolok nañgɨp lombi, kwet tuop amatam kusei kusei kuañ wɨn gɨtɨkgan walawalan nomɨk nain dumangan daulɨmɨmbi ");
INSERT INTO nif_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","nɨñguk, “Kwet gɨtɨk wolok gembɨn ba paman wɨn nokok kɨtnanan kɨmɨlɨm ka-dɨkñelet, wala tɨmbi ama nola ba nola mɨmɨlok nandɨmbi, kɨndem kiinan kɨmɨlet. Nepek gɨtɨk wɨn dɨk gam-taletalelok nandɨlet, ");
INSERT INTO nif_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","wɨn tɨkap dɨk kesɨtnanan mɨlelem tɨ-nameñda, nepenepek gɨtɨk wɨn dɨkok gɨñgɨt tɨ-taleutak.” ");
INSERT INTO nif_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Eumbi tambane nɨñguk, “Yambattok manda no ñɨndɨñ youyoulɨn patak, ‘Dɨk Wopum Yambatka mɨlelem tɨ-ñɨmɨmbi, en noñgangot kɨmɨt-klelok.’” ");
INSERT INTO nif_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tɨmbi Satandɨ Yesu nañgɨpi, Jelusalem tapma it pendɨm kusip plon lo kɨmɨpi nɨnguk, “Dɨk Yambattok Nɨñañ sɨnɨkta, ñɨnanin dɨkopi ma pɨ! ");
INSERT INTO nif_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Kusei ñɨndɨñda dɨk nɨm kolautañ: Yambatta manda no ñɨndɨñ youyoulɨn patak, ‘Endɨ eñaloñiilok kɨsɨnan gapɨpi, gambɨ-dɨkñenelɨñdok enbekak.’ ");
INSERT INTO nif_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","No wɨn ñɨndɨñ, ‘Endɨ kɨsɨlɨ gep wɨt-ta-loumbi, kawattɨ kesɨka nɨm gaulek.’” ");
INSERT INTO nif_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Eumbi tambane nɨñguk, “Yambattok manda ñɨndɨñ elak, ‘Dɨk Wopum Yambatka endok gembɨn inda-dakleuktok tɨ-kuyuk nɨm tɨ-ñɨmekañ.’” ");
INSERT INTO nif_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satandɨ tɨ-kuyuk kusei kusei gɨtɨk tɨ-ñɨmum taleumbi, “Nain nolamek” embi kañ bimbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tɨmbi Yesulɨ Galili kwelan undane ñambi, Dɨndɨm Woñdok gembɨ plon kulɨñgukta endok gɨñgɨt walɨ kwet kle-gɨmbup pakañ tuop sapakñaneñguk. ");
INSERT INTO nif_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tɨmbi endɨ kwet wolok kle-gɨmbut kuñɨpi, it kiyaunjɨ gɨnañ gɨñgɨt manda enɨ-daut tɨ-sem pa tɨmbɨmbi, amatam gɨtɨktɨ koi gɨñgɨt tɨke-loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tɨmbi Nasalet it kwet kandañ pap bendɨñguknan bo ña tomguk. Tombi, Sabat patnandɨ nain indaumbi, ep tɨndɨn klembi, it kiyau gɨnañ loñguk. Lombi, manda pinat-semepi mɨlalɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","plofet Aisaialɨ manda youkuk wɨn tɨkembi, enda mɨñgɨlɨñ. Mɨumbi pɨsapi, manda ñɨndɨñ pakuk wɨn tɨmbɨ indaumbi pinat-semguk, ");
INSERT INTO nif_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wopumdɨ gɨñgɨt manda kɨndem ama pɨmbɨñesɨla enbettok nanbɨ taleñguk, wala tɨmbi endok Woñdɨ gembɨn namlak. Endɨ manda ñɨndɨñ ewa pɨuktok nanɨ-mukuk: toptop kolan plon pakañ wɨn pɨsat-semnekalɨñ, ba dausɨ sipmɨsipmɨn endok dausɨ tɨmbɨ tom-semnekalɨñ. Tɨmbi endɨ ñɨndɨñ tɨmbettok nanɨ-mukuk: nak ama ep pɨ yaliumbi pɨmbɨñen kuañ endok mɨlapsɨ tɨmba taleukak, ");
INSERT INTO nif_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ba Wopumdɨ amatamñii wale kɨndem tɨ-semsemlok nain indalak wɨn ewa pɨukak.” ");
INSERT INTO nif_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Manda wɨndɨñ pinat-talembi, pepa kwasa wɨn kwasanembi, it kiyau kena amala bɨnda mɨmbi, amatam enɨ-daut tɨ-semektok pipakuk. Tɨmbi it kiyau gɨnañ pakɨlɨñ endɨ gɨtɨkgandɨ daut endañgot deiñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tɨmbi Yesulɨ kusei kɨmɨpi, manda ñɨndɨñ enguk, “Gɨñgɨt manda pinalam nandañ walɨ man ñɨndɨñgɨt bien inda-daklelak.” ");
INSERT INTO nif_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Wɨndɨñ eumbi, amatam gɨtɨktɨ nɨ-kɨndem dambi, mandan nandum galkñat sɨnɨk tɨñgukta nanandɨ kena tɨmbi eñgɨlɨñ, “Nɨtek tɨmbi Joseptok nɨñgan walɨ manda wandin elak?” ");
INSERT INTO nif_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eumbi enguk, “Biañganak, sɨndɨ eyout manda ñɨndɨñ nanɨnetañ, ‘Tɨmbɨ kɨndenda ama, dɨk dɨtnalok pɨñgɨpka tɨmbɨ kɨndem da-mek’, wɨn Kapaneam it kwelan kena tɨmbɨm gɨñgɨtka nandɨñgɨmɨñ, wɨndɨñgangot ñolok ika kuseinan tɨmbɨmbi kana!” ");
INSERT INTO nif_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Wɨndɨñ embi yousɨmbi enguk, “Nak biañgan sanba: plofet ama no enlok ilnan nasiilɨ not nɨm pa tɨ-ñɨmañ. ");
INSERT INTO nif_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Sɨndɨ plofet Elia nek tɨñguk wɨn nandɨ-ñɨmɨt: endɨ kuñɨlɨmbi, gwɨlat tɨpet gɨt no gɨt yakɨp kɨt tambon noñgan gwi no nɨm pɨumbi, kwet tuop nanañ map wopum indañguk. Nak biañgan sanlet: nain wolonda Islael kwelan Juda tam kanjak asupgan kuñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","gan Yambattɨ Elia wɨn endoñ nɨm nɨ-mupi, endɨ Sidon kandañ tam kanjak no Salefat it kwelan kuñguk endoññan nɨ-mulɨm ñambi tɨke kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tɨmbi plofet Elisalɨ kuñɨlɨmbi, Islael kwelan Juda amatam asuptɨ wanda kwambɨñ yambo mawatsɨat kuñgɨlɨñ. Gan Elisalɨ endoñnan nanin no nɨm tɨmbɨ kɨndem dañguk, endɨ ama no koi Naman Silia kwelan nanin en noñgangot tɨmbɨ kɨndem dañguk.” ");
INSERT INTO nif_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tɨmbi it kiyau gɨnañ pakɨlɨñdɨ Yesulok manda wɨn nandɨmbi, gɨnañjɨ komba dɨumbi ");
INSERT INTO nif_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","mɨlapi, en it kwet pawan kle munjulɨm ñañguk. Isɨ kwesɨ wɨn kwet kɨmɨn plon pakukta, jɨmbɨñ malapnan tɨke nañgɨp ñambi, munjut kolɨ pɨuktok ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gan endɨ undanembi, kɨmɨn gɨtɨk boñgɨpsɨ gɨnañ yapma klembi, walinin pɨ ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ñambi, it kwet no koi Kapaneam Galili kwelan patak wandɨñ pɨ tombi pakuk. Papi, Sabat patnandɨ nainda gɨñgɨt manda enɨ-daut sem pa tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Endɨ ama biesɨlɨ manda gembɨnat eañ wɨndɨñ eñgukta tɨmbi nandɨ-gɨtɨñgɨtɨk tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sabat patnandɨ nain nola ama no yal kolanlɨ gɨnan gɨnañ pɨñguk endɨ it kiyau gɨnañ lom pakuk. Endɨ wopumgan kwawa tɨñɨpi eñguk, ");
INSERT INTO nif_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei, Yesu Nasalet nanin, dɨk nekta nɨndoñ bɨlañ? Dɨk nɨp tɨmbɨ kolaneñdok bɨlañ ba? Nak kusaka nandɨlet: dɨk Yambat enlok kena ama giñgi sɨnɨk wɨn.” ");
INSERT INTO nif_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wɨndɨñ eumbi, yal kolan wɨn nɨ-ñombɨñɨpi eñguk, “Dɨk mañga masipbi, amalok gɨnan nanin lambɨm po ñau.” Eumbi, yal kolandɨ ama wɨn munjut kolɨmbi, ama pakɨlɨñ endok boñgɨpsɨnan pɨñguk, gan yal endɨ ama wɨn nɨm tɨmbɨ kolaumbi, slak lambɨm po ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tɨmbi amatamdɨ kundit wɨn kañbi ka-sɨlɨkñembi, nanandɨ kena tɨmbi, nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, “Kai, ama ñalɨ manda nɨtnein sɨnɨk elak? Ama yambalat nomɨk endɨ yal kolan manda gembɨnat enbumbi lambɨm po ñañ!” ");
INSERT INTO nif_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Yesulɨ kundit wandin tɨmbɨmbi, endok gɨñgɨt walɨ kwet kle-gɨmbup pakañ tuop sapakñaneñguk. ");
INSERT INTO nif_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesulɨ it kiyau gɨnañ nanin pɨmbi, Simondok ilan loñguk. It wolok Simon yapman tam jɨmbat tɨmbi, pɨñgɨu komba dɨumbi pakuk. Tɨmbi Yesulɨ en tɨmbɨ plap tauktok nɨ-nandumbi, ");
INSERT INTO nif_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","tam pakuknan lombi mumuñembi, jɨmbat nɨ-ñombɨumbi, tam wɨn kañ biñguk. Wɨndɨñ tɨmbɨmbi, tam pɨñgɨu nandum pañgɨtaumbi, plapkan mɨlapi, Yesu gɨt nolii yambɨ-dɨkñeñguk. ");
INSERT INTO nif_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Maim pɨumbi, Sabat patnandɨ nain taleumbi, amalɨ nosii jɨmbat kusei kusei inda-semguk wɨn Yesuloñ yanañgɨp bɨumbi, kiilɨ ama gɨtɨk noñgan noñgan ep kañbi, ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tɨñɨpi, amatam asuptoñ yal kolanjɨ wakɨt ep kle-semumbi, kwawa wopumgan tɨñɨpi po ñambi, ñɨndɨñ eñgɨlɨñ, “Dɨk Yambattok Nɨñañ sɨnɨk.” Yal kolan endɨ Yesu en Mesia Yambattɨ nɨ-mukuk wɨndɨñ nandɨ-ñɨmɨñgɨlɨñ, wala tɨmbi enombɨmbi, manda eelok e-kɨmɨsip tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kwet salaup tɨmbɨmbi, Yesulɨ it bimbi, pɨ ña kwet ama nɨmnatnan ñambi pakuk. Tɨmbi amalɨ lonjɨ kukap tɨmbɨ indaumbi, tɨke kimbɨ dambi, en gɨta papatok nɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","gan endɨ ñɨndɨñ enguk, “Yambattɨ amatam yambɨ-dɨkñembi, ama wapmañjɨ kulak wolok gɨñgɨt manda kɨndem ewa pɨuktok endɨ nanɨ-mukuk, wala tɨmbi nak it kwet dɨwɨnnan bo ñauttok een.” ");
INSERT INTO nif_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Wɨndɨñ embi yambɨk bimbi, ña Judia kwet tuop kumbi, it kiyaunjɨ gɨnañ manda eu pɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nain nola Yesulɨ Genesalet tuk guañ kɨnanjatnan ilɨmbi, amatam kɨmɨn wopumdɨ Yambattok manda nandɨnepi kle-gɨmbupi, ñasɨ ñasɨñgan tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Tɨmbi Yesulɨ kɨnanjatnan kɨkeñ tɨpet palɨm kañbi, mɨkbalak epep amalɨ kɨkeñjɨ bimbi, lɨksɨ wɨlɨp pakɨlɨñ yambɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yambɨm endoñ ñambi, kɨkeñ nolok plon lombi, kɨkeñ molom Simon enda kambak munjulɨm ñaña euktok nɨñguk. Eumbi, wɨndɨñ tɨmbɨmbi, wolok pipapi, gɨñgɨt manda enɨ-daut kenan yousɨmbi tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tɨ-sem-talembi, Simon ñɨndɨñ nɨñguk, “Dɨk tuk guañ boñgɨpnan ñambi, mɨkbalak epeplok lɨksɨ wɨn mep kɨmɨlɨm gɨnañ ma pɨwɨt.” ");
INSERT INTO nif_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Eumbi tambane nɨñguk, “Endaut, nɨndɨ tim ombap kena gɨm slakan tɨmɨñ, tɨmbi mɨkbalak bien no nɨm epmɨmɨñ. Gan dɨkok mandala joñgo bɨndambo lɨk mep kɨmɨlam pɨnetañ.” ");
INSERT INTO nif_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Wɨndɨñ embi, endɨ lɨksɨ mep kɨmɨlɨm pɨumbi, mɨkbalak asup sɨnɨk melɨmbi, lɨk blañganenepi tɨñgɨlɨñ. Wɨndɨñ tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","nosii dɨwɨn kɨkeñ nolok plon kuñgɨlɨñ endɨ bɨ ep pañgɨtanelɨñdok kɨt wayo kot-semum bɨmbi, ep pañgɨtañgɨlɨñ. Tɨmbi mɨkbalak kɨkeñ tɨpet wolok gɨnañ ep dasi tokñeumbi, kɨkeñ tɨpet tuk gɨnañ pɨndepi tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tɨmbi Simon Petlolɨ wɨndɨñ indaum kañbi, Yesu kesiinan mɨlelem tɨmbi nɨñguk, “Wopum, nak ama yomnat, kak nambimbi ñau.” ");
INSERT INTO nif_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kusei ñɨndɨñda endɨ wɨndɨñ tɨñguk: en wakɨt ama gɨtɨk en gɨta kɨkeñ plon pakɨlɨñ endɨ mɨkbalak asup epgɨlɨñda tɨmbi mɨsɨmbi, nanandɨ kena tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tɨmbi Sebedilok nɨñañiit tɨpet Yakobo gɨt Yoane Simon gɨta mɨkbalak epep kena pa tɨñgɨmɨk endɨ wɨndɨñgangot tɨñgɨmɨk. Tɨmbi Yesulɨ Simon nɨmbi eñguk, “Nɨm mɨsɨwɨñ. Dɨk mɨkbalak tiatia tɨlañdɨ gamanda amatam enɨ-tiatia kena tɨmbi kuukañ.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","endɨ kɨkeñ ep tiañeumbi, kɨnanjat kwambɨñnan loumbi, nepenepek gɨtɨk bi-talembi, Yesulok gwañgwa indambi, en kle kuñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesulɨ Juda amatamdok it kwet no pakuk wandɨñ kuñɨlɨmbi, ama no pɨñgɨu gwɨlap gɨtɨk yambo mawattɨ sipmɨñguk endɨ bɨm Yesu kañbi, pi pɨm timan dai kwet plon kɨmɨp pɨndɨm papi, nɨ-kukulembi eñguk, “Wopum, tɨkap dɨk nep kɨmɨlep nandɨlañda, guma jɨmbatna tɨmbɨ taleumbi, kɨndem dawa.” ");
INSERT INTO nif_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Eumbi, kii kot suapi, ama wɨn tɨke-kañbi nɨñguk, “Nak nandɨ-gamlet. Dɨk kɨndem da!” Eumbi, wolongan wanda kwambɨñ walɨ pailɨmbi, kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Tɨmbi Yesulɨ manda kwambɨñ nɨmbi eñguk, “Nepek inda-gamlak wolok kasat ama nola nɨm tɨ-semekañ. Nɨm sɨnɨk. Dɨk ñambi, gwɨlapka tapma amala daulɨmɨumbi, jɨmbatka talelak wɨn gambɨ-dakleutak. Tɨmbi amatamdɨ wandañga biañgan ip talek wɨn gambɨ-nandɨnelɨñdok dɨk tapma tɨmbekañ, wɨn Moselɨ endɨkñe manda kɨmɨt-nɨmguk wolok tuop.” Yesulɨ wɨndɨñ eñguk, ");
INSERT INTO nif_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","gan kena tɨñguk wolok gɨñgɨttɨ sapakñane sɨnɨk taumbi, amatam asupgandɨ mandan nandɨnepi ba jɨmbatsɨ kle-semektok Yesuloñ bɨmbi, kɨmɨn pa tɨañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gan Yesulɨ wandingan embi, yambɨk bimbi, engan kwet ama nɨmnatnan ñam, nɨmolo pa tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nain nola Yesulɨ amatam enɨ-daut tɨ-semñɨlɨmbi, Falisi ama gɨta endɨkñe manda nandɨ-tale ama endɨ lo ñasɨñgan pipakɨlɨñ. Endɨ Jelusalem ba it kwet gɨtɨk Galili ba Judia kwelan pakañ walinin bɨmbɨn. Tɨmbi Wopumdok gembɨn jɨmbatsɨat ep tɨmbɨ kɨndem dalok Yesuloñ palmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nain wolonda ama dɨwɨndɨ nosɨ no kii kesii dalandan tañgo plon tañgonem bɨmbi, Yesulɨ it pakuknan lom dainan kɨmɨtnelɨñdok tɨ-tlakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amatamdɨ it wɨn tokñeñgɨlɨñda tɨmbi endɨ it gɨnañnan bem lonelɨñdok tuop nɨm, wala tɨmbi endɨ it pendɨm bat wolok lombi, pendɨm wiap blanganembi, toalɨ tañgo plon top gɨlɨm dambi, bium pɨ amatam boñgɨpsɨnan Yesulok kuañnan pɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wɨndɨñ tɨmbɨmbi, Yesulɨ nanandɨ kɨlɨktɨnjɨlok bien ka-nandɨmbi, ama wala ñɨndɨñ nɨñguk, “Notna, yomga gɨtɨk wɨn bi-gam-taletalen.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","endɨkñe manda nandɨ-tale gɨt Falisi ama endɨ kusei kɨmɨpi, nɨsɨñgan ñɨndɨñ e-nandɨ tɨñgɨlɨñ, “Yakii, ama manda winjɨt elak wɨn en nin? Wɨn Yambat en noñganlɨñgot yom bimbilok gembɨn palmɨlak yañ!” ");
INSERT INTO nif_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Tɨmbi Yesulɨ gɨnañ nanandɨnjɨ ka-nandɨmbi enɨ-nandɨmbi eñguk, “Kusei nɨtekta sɨndɨ gɨnañjɨ gɨnañ wɨndɨñ e-nandɨ tañ? ");
INSERT INTO nif_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Gembɨ nɨm pat-namumda, nak ‘Yomga bi-gam-taletalen’ nɨmbambi, ba ‘Mɨlapi ñau’ nɨmbambi, bien kɨndem indauk ba? Nɨm ya! ");
INSERT INTO nif_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gan nak Ama Sɨsɨnɨktɨ kwelan ñolok yom bimbilok gembɨn pat-namlak wɨn sɨndɨ nambɨ-daklenelɨñdok nak ñɨndɨñ tɨmbetet.” Wɨndɨñ eñɨpi, ama kii kesii dalandanla nɨmbi eñguk, “Nak ganlet: dɨk mɨlapi, ipatka tɨkembi, ikanan ñau.” Eumbi, ");
INSERT INTO nif_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","wolongan ama walɨ dausɨnangan mɨlapi, ipal tɨkembi, ilnan ñañɨpi, Yambat nɨ-kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tɨmbi amatam gɨtɨktɨ wɨn ka sɨlɨkñembi, nanandɨnjɨ nɨm dakleumbi, nepek mɨsɨmɨsɨn kañgɨlɨñ wala Yambat nɨ-ta-loñɨpi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Man nepek gɨtikñin indaumbi kamɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wolok siñgi kandañ Yesulɨ walinin pɨm ñambi, takis epep ama no koi Livai en takis epep ilan palɨmbi kañbi, ñɨndɨñ nɨñguk, “Dɨk bɨm nep kle ku.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livailɨ kenalok nepenepel gɨtɨk wɨn bi-talembi mɨlapi, Yesu kleñguk. ");
INSERT INTO nif_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Tɨmbi endɨ ilnan nanañ si-jumut wopumgan Yesulok tɨ-ñɨmɨumbi, wolongan takis epep ama ba ama dɨwɨn asupgan en gɨta nanañ yakan nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tɨmbi Falisi ama gɨt nosɨ dɨwɨn endɨkñe manda nandɨ-taleñgɨlɨñ endɨ wɨn kañbi nandum pɨumbi, e-balep tɨmbi, Yesulok gwañgwañii ñɨndɨñ engɨlɨñ, “Sɨndɨ nekta takis epep ama ba ‘yom ama’ dɨwɨn en gɨta nanañ yakan nañ?” Eumbi, ");
INSERT INTO nif_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesulɨ tambanem enguk, “Kɨndemsɨ endɨ gwasap amaloñ nɨm ñañ, wɨn jɨmbatsɨat endɨñgot gwasap amaloñ ñañ. ");
INSERT INTO nif_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ama nɨsɨla nandum dɨndɨm tɨlak nak en enɨ-tiañelok kwelan nɨm indañgut, tambo nak yom ama enbambi, gɨnañjɨ tambanenelɨñdok indañgut.” ");
INSERT INTO nif_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tɨmbi ama dɨwɨndɨ Yesu ñɨndɨñ nɨñgɨlɨñ, “Yoanelok gwañgwañii endɨ nain asup nanañ kɨmɨsipbi, nɨmolo kena pa tañ, tɨmbi Falisi amalok gwañgwanjii endɨ bo wɨndɨñgangot tañ, gan nɨtekta dɨkok gwañgwañgailɨ nanañ kɨmɨsip nain no nɨm kɨmɨpi, kɨmɨsip pa tañ?” Eumbi, ");
INSERT INTO nif_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","noliilok plon eyout manda ñɨndɨñ enbi eñguk, “Ama no tamɨn tɨlakta tɨmbi nolii gɨta na-sɨlɨsɨlɨ tɨñɨlɨmbi, sɨndɨ kɨndem noliilok nanañ kɨmɨsip tɨ-semnelɨñ ba? Nɨm ya! ");
INSERT INTO nif_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gan nain indaumbi, kanjɨkñiilɨ ama wɨn yapma tɨkenekalɨñ. Tɨkeumek, noliilɨ blan tɨmbi, nanañ kɨmɨsip tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Wɨndɨñ embi yousɨmbi, nepek komblin ba damanin wala eyout manda ñɨndɨñ bo enguk, “Ama nolɨ dasindasin komblin blañganembi, kusip tɨkembi, dasindasin damanin mambupmeuk ba? Nɨm ya! Endɨ wɨndɨñ tɨmbekta, dasindasin komblin wɨn kola-ñɨmek, tɨmbi dasindasin kusip komblin wakɨt dasindasin damanin endok tuopset noñgan nɨm tɨmbek. ");
INSERT INTO nif_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tɨmbi wain tul komblin wɨn meme gwɨlap damanin gɨnañ nɨm wɨlɨ gɨlolok. Wɨndɨñ tɨmbekta, wain tullɨ bendɨ wopum dambi, meme gwɨlap damanin tɨmbɨ tawa kolaumbi, wain kwelan poña pɨ-talewɨk. ");
INSERT INTO nif_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wala tɨmbi wain tul komblin wɨn gwɨlap komblin gɨnañ pa wɨlɨ gɨlolok. ");
INSERT INTO nif_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tɨmbi no en wain tuk damanin nañguk endɨ wala ‘Koñgom sɨnɨk’ embi, wain komblin wɨn nambepi kunjit talak.” ");
INSERT INTO nif_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat patnandɨ nain nola Yesulɨ plaua mɨnjɨp kenanan dɨkñe ñañɨlɨmbi, gwañgwañii en gɨta ñañgɨlɨñ endɨ plaua bien mep pañgɨpi, mɨnjɨp kaik nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Tɨmbi Falisi ama dɨwɨndɨ wɨn kañbi, nandum tuop nɨm tɨmbɨmbi engɨlɨñ, “Nɨtek tɨmbi sɨndɨ Sabattok endɨkñe manda wɨpi, kena nɨm tɨndɨlok elak wɨn tañ?” ");
INSERT INTO nif_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tɨmbi Yesulɨ tambane enguk, “Endɨkñe manda wɨwɨttok kandañ sɨndɨ Devit gɨta noliilɨ nanañ gawat palɨñɨlɨmbi, nɨtek tɨñguk wolok kasat wɨn nɨm pinap nandañ ba? ");
INSERT INTO nif_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Endɨ Yambattok ilan lombi, plaua nanañ endok bi-ñɨmɨmɨn wɨn mepi nañguk. Endɨkñe mandalɨ elak wolok tuop nanañ wɨn tapma ama endɨñgot nanalok, gan Devittɨ wɨn joñgo mep nambi, noliila bo emumbi nañgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wɨndɨñ embi yousɨmbi enguk, “Nak Ama Sɨsɨnɨktɨ Sabat patnandɨ naindok molomda tɨmbi wolonda nek guma tɨndɨlok wɨn ewa talelak.” ");
INSERT INTO nif_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat patnandɨ nain no indaumbi, Yesulɨ it kiyau gɨnañ lombi, enɨ-daut tɨ-palɨñɨlɨmbi, ama no kii dɨndɨm dalandañguk endɨ bo wolok bɨm pakuk. ");
INSERT INTO nif_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Tɨmbi Falisi gɨta endɨkñe manda nandɨ-tale ama endɨ Yesu kɨt yout tɨ-ñɨmnelɨñdok kusei lonjɨñgɨlɨñ, wɨndɨñda endɨ Yesulɨ Sabat patnandɨ nainnan ama no tɨmbɨ kɨndem dauk ba nɨm wolok ka-tuakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gan Yesulɨ nanandɨnjɨ wɨn ka-nandɨmbi, ama kii dalandan wɨn kɨtɨ-ñɨmɨmbi nɨñguk, “Mɨlap bɨmbi, ñolok it!” Wɨndɨñ eumbi mɨlapi, dausɨnan ikuk. ");
INSERT INTO nif_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tɨmbi Yesulɨ enbi eñguk, “Nak ñɨndɨñ sanɨ-nandutet: Sabattok endɨkñe mandalɨ nek tɨneñdok nandɨ-nɨmlak - ama tɨmbɨ kɨndem dalok ba ama tɨmbɨ kolalok, kuñgun tɨke-kɨmɨttok ba tɨmbɨ kɨmlok?” Wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","amatam wolok pakɨlɨñ yambɨ-ta-ña-talembi, ama kii dalandan ñɨndɨñ nɨñguk, “Kɨka kot suat” nɨmbɨmbi, wɨndɨñ tɨmbɨmbi, kiilɨ salaptambi, kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Tɨmbi gimbɨt wopumdɨ ama biesɨlok gɨnañjɨ tokñeumbi, Yesu nɨtek tɨmbɨ kolanelɨñdok wala nɨsɨñgan e-nandɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nain wolonda Yesulɨ nɨmolo tɨmbepi kwet jañgɨnnan lombi, tim ombap Yambat nɨmolo tɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kwet salaumbi, ama asup en kleañgɨlɨñ kɨtɨ-semum bɨumbi, endok boñgɨpsɨnan nanin ama 12got ep danbi, ‘enɨmumulɨn’ kot emguk. ");
INSERT INTO nif_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ama ep danguk endok kosɨ ñɨndɨñ: Simon (koi no Petlo kɨtɨñguk), tɨm kwayañ Andlu, Yakobo, Yoane, Filip, tɨm Batlomio, ");
INSERT INTO nif_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matayo, Tomas, tɨm Yakobo Alifaialok nɨñañ, tɨm Simon koi wɨn ‘Selot ama’ kɨtɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","tɨm Judas Yakobo nɨñañ, gɨta Judas Iskaliot, ama nin siñgi Yesu bola tɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tɨmbi Yesulɨ gwañgwañii ep danguk en gɨta kwet jañgɨnnan nanin pɨmbi, kwet kɨmbat nolok tombɨmbi, gwañgwañii asupgan dɨwɨndɨ en gɨta wandɨñ pakɨlɨñ. Tɨmbi endɨñgot nɨm, wɨn amatam kɨmɨn wopum Judia kwet tuop nanin ba Jelusalem nanin, ba Tilo Sidon it kwet tɨpet tuk kimbɨñ baliliñ pakamɨknan nanin ");
INSERT INTO nif_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","endɨ Yesulɨ manda eumbi nandɨnelɨñdok ba jɨmbatsɨ ep kle-kot tɨ-semektok bɨ palɨmbi nandɨ-sembi, ama dɨwɨn yal kolandɨ mɨlap emguk wɨn bo ep tɨmbɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tɨmbi amatam kɨmɨn wopum endɨ Yambattɨ Yesu gembɨ mɨumbi, amatam gɨtɨk ep tɨmbɨ kɨndem daumbi kañgɨlɨñ, wala tɨmbi endɨ tɨke-ka tɨnelɨñdok bañak lonjɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Tɨmbi Yesulɨ gwañgwañiiloñ dei yambɨmbi, ñɨndɨñ enguk, “Amatam nɨsɨla nandum pɨmbɨñen tɨlak sɨndɨ wakan Yambattok gɨñgɨtñii indambi kuañ, wala tɨmbi sɨndɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Man ñɨndɨñgɨt nepenepekta lonjɨ kuañ sɨndɨ wakan Yambattɨ sep tɨmbɨ tokñenekalɨñ, wala tɨmbi sɨndɨ amatam dɨwɨn yapma kle-pakañ. Man ñɨndɨñgɨt sɨmba blan plon kuañ sɨndɨ wakan sɨmba sasat plon kunekalɨñ, wala tɨmbi sɨndɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Sɨndɨ nak Ama Sɨsɨnɨk nep kle-kuañda tɨmbi amatamdɨ nandɨ-kola tɨ-samañ, ba nɨsɨlok boñgɨpsɨnan nanin sep kle-kotnelɨñdok sanɨ-suambapi, kosɨ tɨmbɨ kolalak, nain wolonda sɨndɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Wɨndɨñ inda-samekaknan walenjɨ kɨndem daumbi, sɨlɨsɨlɨ wopum inda-samumbi, kusei ñɨndɨñda dɨkondɨkot tɨnekalɨñ: bep pañjii endɨ plofet ama damañgan kuñgɨlɨñ enda wɨndɨñgangot pa tɨ-semumbi, tuanjɨ wopum kunum gɨnañ kasɨleñgɨlɨñ, tɨmbi sɨndɨ wɨndɨñgangot kasɨlenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gan mɨnem kwɨlɨkwɨlɨnjɨ wopum sɨndɨ blasɨñgan, wɨn sɨndɨ ikan nepenepesɨ kɨndem gɨtɨk wɨn kasɨle-taleañ. ");
INSERT INTO nif_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Man ñɨndɨñgɨt nɨm tɨ-blamblaem kuañ sɨndɨ blasɨñgan, wɨn sɨndɨ lonjɨ tɨ-kunekalɨñ. Man ñɨndɨñgɨt sɨmba sasat kɨndem plon kuañ sɨndɨ blasɨñgan, wɨn sɨndɨ kukulembi, sɨmba blan plon kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amatam gɨtɨktɨ sɨndok kosɨ tɨke-lonekalɨñ wolonda sɨndɨ blasɨñgan! Neta, bep pañjiilɨ plofet ama juluñgan endok kosɨ pa tɨke-loñgɨlɨñ, gan Yambattɨ plofet ama wandin wɨn yalamɨkuk.” ");
INSERT INTO nif_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesulɨ yousɨmbi enguk, “Mandana tɨkembi kuañ sɨnda ñɨndɨñ sanlet: sɨndɨ kanjɨksii gɨnañ kɨndem tɨ-sem-ta-kunekalɨñ, wɨn nandɨ-kola tɨ-samañ enda tɨ-kɨndekɨndem tɨ-sem-ta-kunekalɨñ, ");
INSERT INTO nif_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","yala tɨ-samañ enda gwɨlam tɨ-sem-ta-kunekalɨñ, kolan tɨ-samañ enda nɨmolo tɨ-sem-ta-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ama nolɨ bumga tambon wɨtakta, tambon bo wɨlektok tambane-ñɨmekañ. Ba nolɨ sauloñga galom tɨke-gamlakta, kiupɨñga bo bi-ñɨmɨumbi tɨkeukak. ");
INSERT INTO nif_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Dɨk nepek nola ganɨ-nandɨ tañ enda emekañ, ba nolɨ nepenepeka galom mep gamlak ombɨ-gamektok nɨm nɨ-gɨñgɨneukañ. ");
INSERT INTO nif_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ep tɨndɨn gɨtɨk dɨk nandɨ-galk tambi, amatamdɨ dɨka wɨndɨñ tɨ-gamnelɨñdok nandɨ-semlañ, dɨk bo wɨndɨñgan tɨ-sem-ta-kuukañ. ");
INSERT INTO nif_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tɨkap dɨk amalɨ gɨnañ kɨndem tɨ-gamañ endañgot gɨnañ kɨndem tɨ-semɨñda, nekta Yambattɨ ganɨ-kɨndem dawɨk? Yom ama endɨ bo wɨndɨñgangot pa tañ, wɨn endɨ ama nin gɨnañ kɨndem tɨ-semlak enda gɨnañ kɨndem tɨ-ñɨmañ. ");
INSERT INTO nif_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ba tɨkap dɨk amalɨ kɨndem tɨ-gamañ endañgot kɨndem tɨ-semɨñda, nekta Yambattɨ ganɨ-kɨndem dawɨk? Yom ama endɨ bo wɨndɨñgangot pa tañ. ");
INSERT INTO nif_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ba tɨkap dɨk ama nindɨ tambon ombɨ-gamnelɨñdok tuop wɨn nandɨ-kwambɨñ dalañ endañgot emɨñda, nekta Yambattɨ ganɨ-kɨndem dawɨk? Yom ama endɨ bo yom amala nepek emañ, wɨn tambon wolok tuopgan ombɨ-semnelɨñdok wɨndɨñ pa tañ. ");
INSERT INTO nif_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nɨm, wɨndɨñ nɨm tɨlok. Tambo sɨndɨ kanjɨksɨ gɨnañ kɨndem gɨt kundit kɨndem tɨ-sembi, nepek tambon nɨmnat embi, ombɨ-samnelɨñdok nɨm pa mandɨnekalɨñ. Sɨndɨ wɨndɨñ tɨnekalɨñda, tuanjɨ wopum pat-samekak, tɨmbi sɨndɨ Besɨ Yambat Loloñ Sɨnɨk endok ep tɨndɨn klembi, wembe gwañgwañii kuañ wɨn inda-dakleukak. Neta, endɨ wakan ama kolan pa tañ ba sɨmba kɨndem manda nɨm pa eañ enda kɨndem pa tɨ-semlak. ");
INSERT INTO nif_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Bepsɨlɨ amatam gɨnañ busuk tɨ-semlakta, wɨndɨñgangot sɨndɨ gɨnañ busuk tɨ-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Sɨndɨ amatam enɨ-pɨ nɨm tɨ-kunekalɨñ, tɨmbi Yambattɨ wɨndɨñgangot sanɨ-pɨ nɨm tɨmbekak. Sɨndɨ amatam yom plon nɨm ep kɨmɨt tɨ-kunekalɨñ, tɨmbi Yambattɨ wɨndɨñgangot yom plon nɨm sep kɨmɨlekak. Sɨndɨ amatamdok yomjɨ bi-sem tɨ-kunekalɨñ, tɨmbi Yambattɨ bo yomjɨ bi-samekak. ");
INSERT INTO nif_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Sɨndɨ amatam plap tɨ-sem tɨ-kunekalɨñ, tɨmbi Yambattɨ wɨndɨñgangot plap tɨ-samekak. Sɨndɨ plap tañ wolok tuop endɨ plap tɨ-sambi, nombo yousɨmbi, sam tokñe sɨnɨk taumbi, dɨwɨn lamɨp pɨukak. Nekta, sɨndɨ amala nɨtek tɨ-semañ, wolok tuopgan Yambattɨ sɨnda bo tɨ-samekak.” ");
INSERT INTO nif_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Tɨmbi Yesulɨ yousɨmbi, eyout manda ñɨndɨñ enguk, “Ama dai sipmɨsipmɨn endɨ nol no dai sipmɨsipmɨn gumañ nañgɨlek ba? Nɨm ya! Wɨn nɨset tɨpelat ban gɨnañ pɨndemɨk bek. ");
INSERT INTO nif_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Gwañgwa no endɨ nɨndaulɨn nɨm maklelak, gan endɨ nandɨnandɨ kena tɨmbɨ taleumek, endɨ nɨndaulɨndok tuop indauk bek. ");
INSERT INTO nif_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Nɨtek tɨmbi, dɨk nokalok dai gɨnañ kɨlɨkɨlɨk wɨn kalañ, gan dɨtnalok dauka gɨnañ komba bem patak wɨn nɨm ka-daklelañ? ");
INSERT INTO nif_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Dɨk komba bem dauka gɨnañ patak wɨn nɨm kañbi, nɨtek nokala ñɨndɨñ nɨmbeñ, ‘Notna, nak dauka gɨnañ kɨlɨkɨlɨk patak wɨn klewa lambɨ-gamɨñ.’ Ama man mamben tɨpelat, dama dɨtnalok dauka gɨnañ komba bem patak wɨn kle kopmek, siñgi kandañ ka-dɨndɨm embi, nokaloñ dai gɨnañ kɨlɨkɨlɨk patak wɨn kɨndem kleu lambɨ-ñɨmek. ");
INSERT INTO nif_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Komba kɨndem no endɨ bien kolan nɨm pa lalilak, wɨndɨñgangot komba kolan no endɨ bien kɨndem nɨm pa lalilak. ");
INSERT INTO nif_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Komba walɨ nɨtein wɨn bienlɨ mek tɨmbɨ daklelak. Kuañgɨmdɨ bien mandañ sɨnɨk indaumbi tɨkelok ba? Ba gɨnjattɨ bien gip indaumbi tɨkelok ba? Nɨm ya! ");
INSERT INTO nif_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Amalok kandañ wɨn wɨndɨñgot: nepek endok gɨnan tokñe patak walɨ wakan man gɨnañ lambumbi elak. Wolok tuop nepek kɨndem ama kɨndemlɨ gɨnan gɨnañ dasi-mɨñguk walɨ wakan bien kɨndem tɨmbɨ indalak, tɨmbi wɨndɨñgangot nepek kolan ama kolandɨ gɨnan gɨnañ dasi-mɨñguk walɨ wakan bien kolan tɨmbɨ indalak. ");
INSERT INTO nif_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Nekta slakan ‘Wopumnɨ’ manjɨlɨñgot pa nanañ, gan manda sanlet wɨn nɨm tañgoneañ? ");
INSERT INTO nif_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ama no nokoñ bɨmbi, mandana tɨke kulak endɨ ama nɨtein wɨn sanɨ-daut tɨ-sametet. ");
INSERT INTO nif_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Endɨ ama it kwambɨñ tɨñguk wandin. Endɨ it kɨndilɨñɨpi, ban ombap kɨndilɨm pɨumbi, ita mambɨ ilɨmbi, kawat ta kusei gɨnañ melɨ pɨumbi, gembɨnatgan youlɨ gɨlɨm da-taleñguk. Tɨmbi tuk gwam wopum indambi, it plon suañguk, gan endɨ tɨ-kɨndem dañgukta tɨmbi mɨnjulɨm, sasɨk nɨm tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tɨmbi ama no mandana nandɨ-kɨmkɨmnelak endɨ ama it joñgonjoñgo kɨndikuk wandin. Endɨ it kɨndilɨñɨpi, ta plongan kɨmɨpi, joñgonjoñgo kɨndikuk. Tɨmbi tuk gwam wopumdɨ it wolok plon suambi mɨnjulɨmbi, platik sɨnɨk gɨlom pɨmbi lɨlɨme-taleñguk.” ");
INSERT INTO nif_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesulɨ manda gɨtɨk wɨn amatam enbɨ taleumbi, Kapaneam it kwelan lo ña pakuk. ");
INSERT INTO nif_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wandɨñ kandañ mik ama telak damanjɨ no pakuk endok kena gwañgwa jɨmbat wopum tɨmbi, kɨmkɨmlok tuop tɨñguk. Endɨ kena gwañgwa wala nandum loloñ sɨnɨk tɨñgukta tɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Yesulok gɨñgɨt nandɨmbi, Judalok ama biesɨ dɨwɨn Yesuloñ enɨ-mukuk, wɨn endɨ Yesu nɨ-tiañeum bɨmbi, kena gwañgwa jɨmbalat tɨmbɨ kɨndem dauptok wɨndɨñ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tɨmbi ama walɨ Yesuloñ ña tombi, mik ama telak damanjɨlok kasat tɨ-ñɨmɨmbi nɨ-gɨñgɨnembi eñgɨlɨñ, “Telak damanjɨ wɨn kɨndem tɨke-kɨmɨleñdok tuop. ");
INSERT INTO nif_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nekta, endɨ Juda nɨndok sambat nɨm, ganmek nɨnda gɨnañ kɨndem pa tɨ-nɨmlak. Tɨñɨpi, it kiyaunɨ wɨn endɨñgan nɨp tɨmbɨ plap taumbi indañguk.” ");
INSERT INTO nif_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wɨndɨñ eumbi nandɨ-sembi, en gɨta ñañguk. Ñambi, telak damanjɨlok il tɨmbɨ dumalaumbi, telak damanjɨlɨ nolii Yesuloñ enɨ-mupi, manda ñɨndɨñ kɨmɨlɨmɨñguk, “Wopum, slakan kesɨk gawat nɨm bɨwɨñ. Nak kambak ñandin ñolok nekta nokok itnanangan bɨ nambeñ? ");
INSERT INTO nif_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nak bo daukanan bɨmbɨla nandɨwam mɨlatalak. Dɨk slak mandañgot eumbi, kena gwañgwana kɨndem dawɨn. ");
INSERT INTO nif_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Natna bo ama lolonailok kapmai kulet, tɨmbi nokok pɨmbɨmñennai dɨwɨn kuañ. Nak mik ama nola ‘Ñau!’ nɨmbambi ñalak, ba nola ‘Bo!’ nɨmbambi pa bɨlak. Tɨmbi kena gwañgwanala ‘Kena ñɨn tɨ!’ nɨmbambi, kena wɨn pa tɨlak.” ");
INSERT INTO nif_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Tɨmbi Yesulɨ telak damanjɨlok manda wala nandɨ-gɨtɨñgɨtɨk embi, undane amatam kɨmɨn wopum en kle bɨñgɨlɨñ yambɨmbi, ñɨndɨñ enguk, “Nak ñɨndɨñ sanlet: Islael sɨndok boñgɨpsɨnan bo nak ama nanandɨ-kɨlɨktɨnat ñandin no nɨm kañgut.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","telak damanjɨlɨ nolii enɨ-mukuk endɨ bɨndambo undanem ilan ña lombi, kena gwañgwa kɨndem dambi palɨmbi kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nain nɨm ombataumbi, Yesulɨ it kwet no koi Nain wandɨñ ñaumbi, gwañgwañii gɨt amatam kɨmɨn wopumdɨ en gɨta yakan ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ñambi, it kwet sañ yama tɨmbɨ dumalaumbi, ama dalandan no tañgonem pɨñgɨlɨñ. Wɨn tam kanjak nolok nɨñañ noñgan sɨnɨk endɨ sembɨñguk. Tɨmbi it kwet wɨnasɨ asuptɨ dalandan ba meñ ep klembi pɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tɨmbi Wopumdɨ tam kanjak wɨn kañbi, blan tɨ-ñɨmɨmbi nɨñguk, “Nɨm kuleñ.” ");
INSERT INTO nif_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wɨndɨñ eñɨpi, ña tañgo tɨke-kaumbi, ama tañgoneñgɨlɨñdɨ kak wɨñgan ilɨmbi, dalandanla nɨñguk, “Ama sim, nak ‘Mɨlat!’ ganlet.” ");
INSERT INTO nif_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wɨndɨñ eumbi, gwañgwa walɨ bɨnda mɨlap pipapi, kusei kɨmɨpi manda eñguk. Tɨmbi Yesulɨ meñla nɨñguk, “Nɨñañga ñɨn nañgɨpi ñau!” Eumbi nañgɨpi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tɨmbi amatam wɨ kañgɨlɨñ endɨ gɨtɨk mɨsɨmbi, Yambat nɨ-kɨndem dambi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Plofet wopum no boñgɨpnɨ gɨnañ indañguk kulak” ba “Yambattɨ amatamñii nɨp kɨmɨlektok bɨ inda-nɨmlak.” ");
INSERT INTO nif_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tɨmbi nek indañguk wolok gɨñgɨt walɨ sapakñanembi, Judia kwelan ba kwet kle-gɨmbup pakañ tuop eu sataumbi ña-taleñguk. ");
INSERT INTO nif_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoane tuk ii-sem endok gwañgwañiilɨ Yesulɨ kundit kusei kusei tɨñguk wolok kasat gɨtɨk enla tɨ-ñɨmɨ-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tɨmbi endɨ gwañgwa tɨpet kɨtɨ-semum bɨumbi, Yesula ñɨndɨñ nɨ-nandɨndemɨktok enɨ-mukuk, “Mesia bɨwɨktok een wɨn dɨk wakan ba? Ba ama nola mandɨneñ?” Wɨndɨñ embi enɨ-mulɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Yesuloñ ña tombi nɨñgɨmɨk, “Yoane tuk ii-sem endɨ ñɨndɨñ ganɨ-nandɨnda embi nɨnɨ-mulɨmbi bamɨk, ‘Mesia bɨwɨktok een wɨn dɨk wakan ba? Ba ama nola mandɨneñ?’” ");
INSERT INTO nif_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nain wolonda Yesulɨ amatam jɨmbatsɨat ba pɨñgɨp gawatsɨat asup wɨn ep tɨmbɨ kɨndem dambi, yal kolanjɨ wɨn ep kle kot-sembi, ama asup dausɨ sipsipmɨn tɨmbɨ tom-semguk. ");
INSERT INTO nif_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tɨmbi endɨ Yoanelok manda tambon ñɨndɨñ tambane enguk, “Sɨtɨ ñambi, nepek dautsettɨ kamɨk ba pawanjettɨ nandamɨk wolok kasat tɨ-ñɨmdekamɨk: dausɨ sipsipmɨn dausɨ tombɨm kañ, tɨmbi kesɨt nɨm kuañdɨ kesɨt kuañ. Amatam jɨmbat yambo mawatsɨat endok wandanjɨ wɨn ep tɨmbɨ gɨlɨta-semlak, pawanjɨ kamen pawanjɨ tombɨm nandañ. Ama sembɨsembɨn bɨndambo kaitambi mɨlakañ, tɨmbi ama pɨmbɨñesɨla gɨñgɨt manda kɨndem enbum nandañ. ");
INSERT INTO nif_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tɨmbi no en kusatna nambɨ-nandɨmbi, nandɨ-kolan nɨm tɨ-namlakta endɨ amatam dɨwɨn yapma kle-patak.” ");
INSERT INTO nif_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yoane gwañgwa tɨpet enɨ-mukuk endɨ undane pɨ ñaumbi, Yesulɨ kusei kɨmɨpi, ama kɨmɨn wopumda Yoanelok plon ñɨndɨñ enguk, “Kwet sɨlaninnan ñañgɨlɨñ wɨn sɨndɨ nek kanepi ñañgɨlɨñ? Wɨn sɨndɨ sasalelɨ pinjɨm pendɨlɨm ña-bɨ tɨlak wɨn kanepi ñañgɨlɨñ ba? ");
INSERT INTO nif_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tɨkap nɨmda, nek kanepi ñañgɨlɨñ? Ama dasindasin pamanat no kanepi ñañgɨlɨñ ba? Nandañ: ama dasindasinjɨ pamanjɨat ba pipapatsɨ kɨndem sɨnɨk endɨ ama wapmañdok isɨnan pa kuañ. ");
INSERT INTO nif_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Wɨndɨñda sɨndɨ nek sɨnɨk kanepi ñañgɨlɨñ? Plofet ama no kanepi ñañgɨlɨñ ba? I wakanak. Tɨmbi Yoanelok kandañ nak ñɨndɨñ sanlet: endɨ plofet dɨwɨn yapma kle-talelak. ");
INSERT INTO nif_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wɨn enda wakan Yambattok mandan ñɨndɨñ youyoulɨn patak, ‘Nak gɨñgɨt ee amana no nɨ-mulam ñambi, telak dama tɨ-gambi, telak tɨ-dɨndɨm e-gamekak.’ Wɨndɨñ youyoulɨn patak, ");
INSERT INTO nif_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","tɨmbi nak ñɨndɨñ sanlet: ama gɨtɨk kwelan dama indañgɨlɨñ endɨ Yoane nɨm makleañ, ganmek no en Yambattok gɨñgɨtñiilok boñgɨpsɨnan pɨmbɨñen sɨnɨk kulakta endɨ Yoane makle patak.” ");
INSERT INTO nif_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Takis epep ama gɨt amatam dɨwɨn endɨ manda wɨn nandɨ-talembi, Yoanelok kii plon tuk iñgɨlɨñda tɨmbi Yambattok telak wɨn dɨndɨm sɨnɨk tɨmbɨ dakleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gan Falisi gɨt endɨkñe manda nandɨ-tale ama endɨ gɨnañ tambatambattok tuk nɨm iñgɨlɨñda tɨmbi Yambattɨ nek tɨnelɨñdok nandɨñguk wala nandum tlal tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tɨmbi Yesulɨ yousɨmbi enguk, “Wɨndɨñda tɨmbi amatam man ñɨndɨñgɨt kuañ endɨ nɨtein? Nak endok kusasɨla eyout manda nek ewɨt? ");
INSERT INTO nif_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wɨn endɨ gwañgwa bɨsattɨ sañalala ipakanan pipapi, nosɨla kɨtɨ-sembi, ñɨndɨñ enɨañ, ‘Nɨndɨ pakñuak pendɨtnambi, sɨndɨ kap nɨm tilɨñ, ba kap mano tɨñɨtnambi, sɨndɨ ku-blamblae nɨm tɨlɨñ.’ ");
INSERT INTO nif_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kusei ñɨndɨñda nak sɨndok plon wɨndɨñ sanlet: Yoane tuk ii-sem endɨ indambi, nanañ kɨmɨsip pa tɨñguk, tɨñɨpi wain nɨm pa nalɨñguk wala sɨndɨ nandum tuop nɨm tɨmbɨmbi, enda ñɨndɨñ pa eañ, ‘Yal kolan endok gɨnañnan patak.’ ");
INSERT INTO nif_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tɨmbi nak Ama Sɨsɨnɨktɨ indambi, nanañ ba wain nañɨpi, kɨmɨsip nɨm pa tɨlet, wala sɨndɨ nandum tuop nɨm tɨmbɨmbi, ñɨndɨñ pa eañ, ‘Ama ñɨn kawɨt! Tɨmbɨ namba! Endɨ nanañ ba wain asup sɨnɨk pa nalak, ba takis epep ama ba yom ama not tɨ-semlak!’ ");
INSERT INTO nif_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sɨndɨ wɨndɨñ pa eañ, gan amatam Yambattok nanandɨn kɨmɨt-klem kuañ endɨ nanandɨ wɨn dɨndɨm sɨnɨk wakan daut nɨmañ.” ");
INSERT INTO nif_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Falisi ama nolɨ Yesu nanañ en gɨta nambektok nɨ-tiañeumbi, endok ilnan lombi, nanañ nanelɨñdok pi pakuk. ");
INSERT INTO nif_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tɨmbi yom tam no it kwet wolok kuñguk endɨ Yesula “Falisi amalok ilnan nanañ na patak” gɨñgɨt wɨn nandɨñgukta, pɨñgɨp saple mɨlɨñ kɨndem kanɨm kawat satnindɨ tɨndɨn no tɨkembi, it gɨnañ loñguk. ");
INSERT INTO nif_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Lombi, Yesulok kesiinan kandañ ñam papi kulɨmbi, dai tullɨ pɨ Yesulok kesii youlɨ gautaumbi, kumban saktɨ tɨmbɨ kalandaumbi, kesii nain ombapgan sɨmumuñ embi, pɨñgɨp saple mɨlɨññattɨ saple-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Tɨmbi Falisi ama Yesu nɨ-tiañeñguk endɨ wɨn kañbi, gɨnan gɨnañ ñɨndɨñ eñguk, “Tam ñɨn endɨ yom tam no. Ama walɨ biañgan plofet ama kuumda, tam tɨke-kalak ñolok kusei ka-nandɨ-taleuk.” ");
INSERT INTO nif_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tɨmbi Yesulɨ Falisi ama endok nanandɨn wɨn nandɨmbi nɨñguk, “Simon, nak manda no ganba nandɨ.” Eumbi nɨñguk, “Endaut, eumbi nandɨwa.” ");
INSERT INTO nif_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Eumbi nɨñguk, “Ama nolɨ mɨnem tambonlok ama tɨpetta emguk, nolok mɨnem kwandai 500, tɨmbi nolok mɨnem kwandai 50. ");
INSERT INTO nif_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Endɨ ombɨndemɨktok tuop nɨmda, blan tɨ-sembi, kak tambon wiat-semguk. Wɨndɨñda endoñnan nanin nindɨ nol maklembi, mɨnem molomda sɨmba kɨndem tɨ-ñɨmekak?” ");
INSERT INTO nif_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Eumbi nɨñguk, “Mɨnem kwandai 500 wialɨmɨñguk endɨ bek.” Eumbi, “Wɨn dɨndɨm elañ” nɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","undanem tam kañbi, Simon nɨñguk, “Tam ñɨn kalañ ba? Nak dɨkok ika gɨnañ lambɨwambi, dɨk ep tɨndɨnɨ nɨm klembi, not nɨm tɨ-namɨñ, wɨn dɨk kesɨtna wɨlɨwɨlɨttok tuk no nɨm gɨt-namɨñ, gan endɨ kesɨtna dai tullɨ wɨlɨpi, kumbam saktɨ sapleum kalandalak. ");
INSERT INTO nif_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Dɨk kɨtna ba bumna no nɨm sɨmumuñ tɨ-namɨñ, gan nak it gɨnañ lambɨt wolondañgan endɨ kusei kɨmɨpi, nɨm tɨndɨn wɨn, kesɨtna sɨmumuñ tɨ-namumbi, nain ñɨn bɨ tomlak. ");
INSERT INTO nif_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Dɨk kumbana tuk galk sɨlanindɨ nɨm saple-namɨñ, gan endɨ pɨñgɨp saple mɨlɨñ kɨndem bien walɨ kesɨtna saple-namɨk. ");
INSERT INTO nif_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Wɨndɨñda ñɨndɨñ ganlet: tam ñalɨ sɨmbai kɨndem da-sɨnɨk talakta tɨmbi wɨndɨñ tɨ-namlak. Walɨ ñɨndɨñ daut nɨmlak: endok yomɨn asupgan bimbin. Gan no endok yomɨn lakatgan bimbinda endɨ lakat wolok tuop sɨmbai kɨndem dalak.” ");
INSERT INTO nif_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Tɨmbi tamda nɨñguk, “Yomga gɨtɨk bi-gam-taletalen.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ama gɨtɨk en gɨta nanañ nam pakɨlɨñ endɨ kusei kɨmɨpi, gɨnañjɨ gɨnañ ñɨndɨñ nandɨñgɨlɨñ, “Endɨ ama nin sɨnɨk, ñala yom bimbi bo pa tɨlak?” ");
INSERT INTO nif_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Tɨmbi Yesulɨ tam nɨñguk, “Nanandɨ-kɨlɨktɨñgala tɨmbi Yambattɨ kolan gɨnañ nanin gepma tɨkek, wala tɨmbi busukñenengan ñaukañ.” ");
INSERT INTO nif_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wolok siñgi kandañ Yesulɨ kle-gɨmbut ñañɨpi, it kwet tip ba wopum wandɨñ manda eu pɨumbi, Yambattɨ amatamñii yambɨ-dɨkñelak wolok gɨñgɨt manda kɨndem enɨ-ta-kuñguk. Tɨmbi gwañgwañii 12 endɨ en gɨta yakan kuñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Tɨmbi dama Yesulɨ tam jɨmbatsɨat dɨwɨn ep tɨmbɨ kɨndem dañgɨlɨñ ba yal kolanjɨ ep kle kot-semguk endɨ bo en kle-kuñgɨlɨñ. Tam no wɨn Malia Makdala nanin (damañgan Yesulɨ yal kolan kɨt tambon tɨpet ep kle kolɨmɨñguk). ");
INSERT INTO nif_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Tɨmbi Yoana (endok wapai Kusa endɨ ama wapmañ Elottok it kaulɨ-dɨkñeñguk) gɨta Susana wakɨt tam asup dɨwɨn Yesu gɨta yakan ñañgɨlɨñ. Tam walɨ Yesu gɨt gwañgwañii plap tɨ-sembi, mɨnemjɨlɨ ep kasop tɨ-semmañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Amatam it kwet nolok ba nolok endɨ Yesuloñ bɨ kɨmɨn wopum tɨñɨlɨmbi, eyout manda no ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Ama nolɨ plaua nanañ mɨnjɨp kot-tikitiki tɨmbektok kenan gɨnañ ñañguk. Ña tom kolɨñɨlɨmbi, mɨnjɨp dɨwɨndɨ telak plon pɨumbi, amalɨ yali-ña-bɨ tɨmbɨmbi, monɨktɨ bɨ na-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tɨmbi mɨnjɨp dɨwɨn kwet kawakawalatnan pɨmbi, tawam lambɨmbi, tuk nɨmnatta tɨmbi yañetambi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Tɨmbi mɨnjɨp dɨwɨndɨ koselek mɨnjɨpnan pɨmbi, wakɨt yakan tawa lambɨñgɨlɨñda koselektɨ ep tapliumbi kɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mɨnjɨp dɨwɨn kwet kɨndem plon pɨmbi, tawa lambɨmbi, bien asup laliñgɨlɨñ, wɨn bien 100 100 wɨndɨñ laliñgɨlɨñ.” Yesulɨ wɨndɨñ embi yousɨmbi, ñɨndɨñ kɨtɨñguk, “No en pawañnat endɨ pawañ kɨmɨpi, nandɨ-tɨke-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tɨmbi Yesu gwañgwañiilɨ eyout manda eñguk wolok kusei nandɨnepi nɨ-kaumbi ");
INSERT INTO nif_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","enguk, “Yambattɨ nandɨ-sambi, amatamñii nɨtek yambɨ-dɨkñelak wɨn sanɨ-sɨwɨlɨmbi nandɨ-dakleañ. Gan nanandɨn sembɨn wɨn nak amatam dɨwɨn endɨla eyout mandalɨñgot enba nandɨañ. Wɨn endɨ kañbi nɨm ka-nandɨ-tomnelɨñdok ba nandɨmbi nɨm nandɨ-daklenelɨñdok wɨndɨñ pa tɨlet. ");
INSERT INTO nif_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Tɨmbi eyout manda et wolok kusei wɨn ñɨndɨñ: plaua mɨnjɨp wɨn Yambattok manda. ");
INSERT INTO nif_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mɨnjɨp telak plon pɨñgɨlɨñ wɨn amatamdɨ Yambattok manda nandɨ dasiumbi, Satandɨ bɨmbi, gɨnañjɨ gɨnañ manda patak wɨn yolom tɨke-semlak. Nɨm kañbi, endɨ manda wɨn tɨke-papi, Yambattok gɨñgɨt indanelɨñda, Satandɨ wɨndɨñ tɨ-semlak. ");
INSERT INTO nif_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mɨnjɨp kwet kawakawalatnan pɨñgɨlɨñ wandin walɨ manda nandɨmbi sɨlɨsɨlɨnat kasɨleañ. Gan endɨ wɨn plaua mɨnjɨptok kakai kwet gɨnañnan nɨm pɨlak wandin, wala tɨmbi endɨ nain dumangan nanandɨ-kɨlɨktɨ tañ, gan tɨ-kuyuk no inda-semumbi, nanandɨ-kɨlɨktɨnjɨ pipɨlak. ");
INSERT INTO nif_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mɨnjɨp koselek boñgɨpsɨnan pɨñgɨlɨñ wandin walɨ Yambattok manda nandɨm kuñɨlɨmbi, kwelalok mɨlap ba mɨnem kwɨlɨkwɨlɨ ba nepenepek sɨlɨsɨlɨ pa emlak walɨ nanandɨ-kɨlɨktɨnjɨ makleumbi, bukaiñgot pakañ. ");
INSERT INTO nif_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Tɨmbi mɨnjɨp kwet kɨndem gɨnañ pɨñgɨlɨñ wandin walɨ ama gɨnañ nanandɨnjɨ wɨn kɨndem ba dɨndɨm sɨnɨk, tɨmbi endɨ manda wɨn nandɨ-dasimbi, tɨke-kwambɨñ dambi gɨñgɨnem kuñɨpi, bienjɨat tañ.” ");
INSERT INTO nif_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Tɨmbi Yesulɨ yousɨmbi enguk, “Ama nolɨ kolsalen pɨndopi, kambottɨ nɨm tapliwɨk ba doundoulok palapalat kapmainan nɨm kɨmɨlek. Tambo endɨ kolsalen indañgan kɨmɨlɨmbi, ama it gɨnañ loañ kolɨ sale-semek. Yambattok mandan wɨndɨñgangot kusei ñɨndɨñda indañgan tɨmbɨ daklelok: ");
INSERT INTO nif_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","endɨ amatam nɨtek yambɨ-dɨkñelak wandɨñ kandañ nepek pat-sembɨn pakañ gɨtɨk ep tɨmbɨ indañgan indanekalɨñ, tɨmbi nanandɨ sembɨn gɨtɨk wɨn bo eu tawaukak. ");
INSERT INTO nif_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Wala tɨmbi sɨndɨ Yambattok mandan telak nɨtek nandɨmbi nandɨ-dakleañ wɨn ka-kɨliñ enekalɨñ. No en endok mandan nandɨmbi tɨke kulakta, Yambattɨ yousɨ mɨmbi, nanandɨn tɨmbɨ pañgɨtaumbi nandɨ-dakleukak. Gan no en mandan wɨn nɨm tɨke kulakta, nanandɨn palmektok nandɨlak wɨn apma tɨke-ñɨmumbi, slak palekak.” ");
INSERT INTO nif_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tɨmbi Yesulok meñ kwayañii endɨ Yesu kanepi bɨñgɨlɨñ, gan amatam kɨmɨn wopumdɨ masip pakɨlɨñda tɨmbi ñasɨñgan bɨmbɨlok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tɨmbi amalɨ Yesu ñɨndɨñ nɨñgɨlɨñ, “Meñga kwayañgailɨ gambɨnep nandɨmbi bɨlɨñ, pawan ikañ.” ");
INSERT INTO nif_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Eumbi tambane enguk, “Amatam Yambattok manda nandɨmbi kɨmɨt-kleañ endɨla mek nokok mena kwayanai tañ.” ");
INSERT INTO nif_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nain nola Yesulɨ gwañgwañii gɨta kɨkeñ plon lombi enguk, “Tuk guañ dɨkñembi, tambon kandañ ñana” eumbi, wolok ñanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ñañɨpi, doulɨ tɨmbɨ gwaseim douñguk. Dou palɨmbi, kwet jañgɨnnan nanin sasale wopumgan tuk guañnan pɨm pendɨlɨmbi, tuk kɨmɨn gɨtɨk mɨlap tawambi, kɨkeñ gɨnañ pɨm tokñeumbi, mɨlap wopum gɨnañ pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Tɨmbi gwañgwañiilɨ dounan nanin tɨmbɨ sɨlɨkñembi nɨñgɨlɨñ, “Bep bep, nɨndɨ ip kɨmnepi tamɨñ!” Eumbi mɨlapi, sasale wakɨt tuk kɨmɨn wopumgan lopɨlat sɨnɨk wɨn enombɨumbi, sasalelɨ kɨlp eumbi, tuktɨ busukñenengan pakuk. ");
INSERT INTO nif_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tɨmbi gwañgwañiila ñɨndɨñ enguk, “Nekta nɨm nandɨ-kɨlɨktɨ tañ?” Wɨndɨñ eumbi mɨsɨmbi, nanandɨ kena tɨmbi, nɨsɨ walɨñgan ñɨndɨñ e-nandɨ tɨñgɨlɨñ, “Ama ñɨn en nin sɨnɨk, ñala sasale gɨt tukta bo manda kwambɨñ enbumbi, man tañgoneamɨk?” ");
INSERT INTO nif_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu gɨt gwañgwañii endɨ tuk guañ dɨkñembi, Gelasa amatamdok kwet Galili distrik dat kandañ patak wandɨñ ña suañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Tɨmbi Yesulɨ kwet kwambɨñnan loumbi, ama walinin no yal kolannat endɨ endoñ bɨñguk. Ama walɨ nain ombapgan it ba dasindasin ka-mɨsɨmbi, biatan ama sumnan dou-mɨlat tɨmbi kulɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Endɨ Yesu kañbi, kesiinan pi pɨm papi, kwawa tɨmbɨmbi, yal kolandɨ Yesu ka-nandɨ-tomgukta amalok man plon wopumgan ñɨndɨñ kɨtɨmbi nɨñguk, “O Yesu, Yambat Loloñ Sɨnɨk endok Nɨñañ, dɨk nek tɨ-namepi bɨlañ? Dɨk nandɨ-nambi, kena gɨm nɨm namɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesulɨ yal kolan ama wɨn bim poñauktok manda kwambɨñ nɨñgukta yal walɨ wɨndɨñ eñguk. Yal kolan ama wolok gɨnan gɨnañnan pakɨlɨñ endɨ nɨ-gɨñgɨneumbi, tɨ-kelakelam pa tɨlɨñguk, wala tɨmbi amalɨ nain asup sen kwambɨñlɨ kii kesii topbi, nɨm pi ñauktok ka-dɨkñeañgɨlɨñ, gan endɨ sen tɨmbɨ dɨkñeumbi, yal kolandɨ nɨ-kleumbi, kwet ama nɨmnatnan ña kulɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Tɨmbi Yesulɨ nɨ-nandɨmbi eñguk, “Koka nin?” Eumbi, yal kolan asuptɨ endok gɨnan pɨ-ñɨmɨñgɨlɨñda tɨmbi “Kotna Kɨmɨn Gɨtɨk” nɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Tɨmbi yal kolandɨ ñɨndɨñ nɨmbi eñgɨlɨñ, “Dɨk jɨmbɨñ ñaneñdok nɨm nɨnɨ-muleñ” wɨndɨñ embi nɨ-gɨñgɨne tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kwet klokloñen wandɨñ bɨt asuptɨ mina-pakɨlɨñda tɨmbi yallɨ Yesu ñɨndɨñ nɨ-gɨñgɨneñgɨlɨñ, “Dɨk nandɨ-nɨmumbi, bɨt endok gɨnañjɨnan pɨneñ.” Eumbi nandɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nandɨ-semumbi, ama gɨnan nanin poñambi, bɨttok gɨnañjɨnan pɨumbi, bɨt kɨmɨn wopumdɨ kwet kloñnan wolok woñep pɨ ñambi, tuk guañnan pɨmbi, tuk nambi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wɨndɨñ tɨmbɨmbi, bɨt yambɨndɨkñe amalɨ nek indañguk wɨn kañbi pi ñambi, wolok kasat amatam it kwelan ba kanda ilan ña tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tɨmbi amatamdɨ nepek indañguk wɨn kanepi Yesuloñ bɨmbi kañgɨlɨñ wɨn: ama dama yal kolannat kulɨñguk endok nanandɨn dakleumbi, dasindasi dasimbi, Yesulok kesiinan pipalɨm kañbi mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Tɨmbi nepek nek indañguk wɨn dausɨlɨ kañgɨlɨñ endɨ ama yal kolannat kulɨñguk nɨtek kɨndem dañguk wolok kasat amatam dɨwɨnda tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wɨndɨñ tɨmbɨmbi, Gelasa nasi gɨtɨkgandɨ Yesu kundit tɨñguk wala kolan mɨsɨmbi, kwesɨ biuktok nɨ-nandɨñgɨlɨñ. Nɨ-nandumbi nandɨ-sembi, yambim ñauktok kɨkeñ plon loñguk. ");
INSERT INTO nif_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Tɨmbi ama yal kolannat kulɨñguk endɨ Yesu gɨta kuuktok nɨ-nandɨ tɨñguk, gan Yesulɨ ilan nɨ-mupi, ñɨndɨñ nɨñguk, ");
INSERT INTO nif_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Dɨk ikanan undanem ñambi, Yambattɨ kundit engano sɨnɨk tɨ-gamɨk wolok kasat amatamda tɨ-semekañ.” Eumbi, walinin pɨmbi, it kwelan undanem ñambi, Yesulɨ nepek tɨ-ñɨmɨñguk wɨn amatam gɨtɨkta kasat tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesulɨ bɨndambo tuk guañ tambon kandañ ña suaumbi, amatam en mandɨ pakɨlɨñ gɨtɨk endɨ sɨlɨsɨlɨ tɨmbi, not tɨ-ñɨmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tɨmbi it kiyaulok kandɨkñe ama no koi Jailus endɨ Yesuloñ bɨmbi, kesiinan pɨ pɨndɨm dou papi, kakukulembi, enlok ilnan nañgɨp ñauktok nɨñguk, ");
INSERT INTO nif_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","wɨn wemban noñgan sɨnɨk gwɨlalɨ 12 en kɨmbepi tɨñgukta tɨmbi wɨndɨñ tɨñguk. Tɨmbi Yesulɨ nandɨ-ñɨmɨmbi, en gɨta ñañɨlɨmbi, amatam kle ñañgɨlɨñ endɨ kle-gɨmbupi ñasɨñgan ñasɨñgan tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tɨmbi tam no tam jɨmbat inda-ñɨmɨumbi, ama nolɨ en tɨmbɨ kɨndem dauktok tuop nɨmda tɨ-tlalɨmbi, gwɨlat 12 ombɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Endɨ Yesu siñgin kandañgan tɨmbɨ dumalaumbi, dasindasinlok blemblem tɨke-kaumbi, wolongan wekailɨ kalandañguk. ");
INSERT INTO nif_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Tɨmbi Yesulɨ enguk, “Nindɨ neplak?” eumbi, amatam gɨtɨktɨ “Nɨm nɨm” eumbi, Petlolɨ nɨñguk, “Bep, dɨk amatam kɨmɨn wopumdɨ gep kle gɨmgɨm embi, ñasɨñgan ñasɨñgan tañ wɨn!” ");
INSERT INTO nif_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gan Yesulɨ gɨñgɨnembi enguk, “Nimbek ñalɨ kɨndem dauktok nepmɨumbi, gembɨnalɨ kena tɨmbɨm nandɨlet wɨn!” ");
INSERT INTO nif_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wɨndɨñ eumbi, tam endɨ pat-sembektok tuop nɨm wɨn nandɨ-daklembi, blañblañem bɨmbi, Yesu kesiinan pɨ papi, amatam dausɨnan kusei nekta tɨke-kañbi, wolongan kɨndem dañguk wolok kasat tɨ-ñɨmɨmbi nɨ-sɨwɨkuk. ");
INSERT INTO nif_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Tɨmbi Yesulɨ nɨñguk, “Wembana, nanandɨ-kɨlɨktɨñgalɨ gep tɨmbɨ kɨndem dalañ, ñala busukñeñgan ñau.” ");
INSERT INTO nif_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesulɨ manda wɨndɨñ eñɨlɨmbi, ama nolɨ it kiyau kandɨkñelok ilnan nanin manda tɨkembi, Jailusloñ bɨmbi nɨñguk, “Wembañga ip sembɨk, wala tɨmbi endaut nɨmbɨmbi, slakan wandɨñ kesɨk gawat nɨm ñauk.” ");
INSERT INTO nif_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gan Yesulɨ mandan wɨn tɨkembi, Jailus ñɨndɨñ nɨñguk, “Nɨm mɨsɨwɨñ, nandɨ-kɨlɨktɨñgot tɨ-namɨñ. Tɨmbi wembañga kɨndem dautak.” ");
INSERT INTO nif_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wɨndɨñ embi, ña Jailuslok ilnan tombi, it gɨnañnan ama dɨwɨn nɨm lonelɨñdok e-kɨmɨsip tɨ-sembi, Petlo, Yoane, Yakobo tɨm wembelok meñ beu endɨñgot yanañgɨlɨm loñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tɨmbi amatam it gɨnañnan pakɨlɨñ endɨ gɨtɨk wembela kut-blambla embi mano tɨ pakɨlɨñ, gan Yesulɨ enda ñɨndɨñ enguk, “Wembe ñɨn nɨm sembɨk, endɨ slak dou patak, wala tɨmbi mano nɨm tɨmbɨt.” ");
INSERT INTO nif_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wɨndɨñ eumbi, wolok pakɨlɨñdɨ wembe wɨn ikan sembɨñguk wɨn ka-nandɨñgɨlɨñda tɨmbi Yesulok mandala nandum tlal tɨmbɨmbi, tɨkɨle manda nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gan Yesulɨ wembe kii plon tɨkembi kɨtɨ-ñɨmɨmbi nɨñguk, “Wembe, dɨk mɨlat!” Eumbi, ");
INSERT INTO nif_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","wembe wolok gɨnañ tiptɨ undane bɨ pɨumbi, wolongan mɨlakuk. Mɨlalɨmbi, Yesulɨ nanañ no mɨumbi nambektok enguk. ");
INSERT INTO nif_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tɨmbi wembe meñ beulɨ kundit wɨn kañbi ka-sɨlɨkñembi, nanandɨnjet nɨm dakleñguk. Gan Yesulɨ enɨ-kɨmɨsip tɨ-sembi, nepek indañguk wɨn ama nola nɨm enɨnelɨñdok enguk. ");
INSERT INTO nif_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Tɨmbi Yesulɨ gwañgwañii 12 kɨtɨ-semum bɨumbi, yal kolan gɨtɨk ep kleklelok ba jɨmbat kusei kusei ep tɨmbɨ kɨndem dalok gembɨ embi, ");
INSERT INTO nif_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","amatam ep tɨmbɨ kɨndem danelɨñdok ba Yambattɨ yambɨ-dɨkñelak wolok gɨñgɨt eu pɨuktok enɨ-mukuk. ");
INSERT INTO nif_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Enɨ-mupi enguk, “Telak ñanepi nepek no nɨm mep ñanekalɨñ, wɨn toñanjɨ ba lɨksɨ ba nanañ ba mɨnem ba kiupɨ dɨwɨn nɨm epbi ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","It kwet nolok tombɨmbi, it molom nolɨ sanɨ-tiañeumbi, endok ilnan lonekalɨñ tuop, it wolokgot dou-mɨlat tɨmbi, walinin pɨm it kwet nolok ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ba it kwet nolɨ not nɨm tɨ-samnekalɨñda, it kwet wɨn binekalɨñ wolonda sɨndɨ Yambattɨ enda nandum pɨ-sɨnɨk talak wɨn daut semnelɨñdok wɨnasɨlok dausɨnan kesɨsɨ plon kɨlɨkɨlɨk wɨñgan wɨp mamañeum pɨumbi ñanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Tɨmbi gwañgwañiilɨ Yesu bimbi, it kwet kle-gɨmbut ñambi, kwet tuop gɨñgɨt manda kɨndem eu pɨumbi, amatam ep tɨmbɨ kɨndem dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tɨmbi Galili kwettok kandɨkñe ama Elot endɨ Yesu gɨt gwañgwañii nepek engano sɨnɨk gɨtɨk tɨñgɨlɨñ wolok kasat nandɨmbi, kusei ñɨndɨñda endok nanandɨn nɨm dakleñguk: ama dɨwɨndɨ “Yoane tuk ii-sem endɨ kɨmnan nanin mɨlakuk” wɨndɨñ pa eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","dɨwɨndɨ “Elia bɨndambo indauktok mandɨñgɨmɨñ endɨ wakan indañguk” wɨndɨñ pa eñgɨlɨñ, tɨmbi dɨwɨndɨ “Plofet ama damañgan sembɨñguk no kɨmnan nanin mɨlakuk” wɨndɨñ pa eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Tɨmbi Elottɨ eñguk, “Yoane wɨn nak ewambi, bim wɨlɨ dɨkñeñguk. Wɨndɨñda tɨmbi ama ñɨn endok koi gɨñgɨttɨ nokok pawañna gɨnañ pɨñguk wɨn nin sɨnɨk?” Wɨndɨñ embi, Yesu kauptok telak pa lonjɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tɨmbi enɨmumulɨn endɨ Yesuloñ undanem bɨmbi, kena nek tɨñgɨlɨñ wolok kasat tɨ-ñɨmɨumbi yanañgɨlɨmbi, nɨsɨñgot it kwet no koi Betsaida kandañ ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tɨmbi amatam kɨmɨn wopumdɨ gɨñgɨt wɨn nandɨñgɨlɨñda endɨ Yesu klembi, ñañguknan ñañgɨlɨñ. Ña tombɨmbi, Yesulɨ yambɨmbi not tɨ-sembi, Yambattɨ amatamñii yambɨ-dɨkñelak wolok plon manda enbi, amatam ep tɨmbɨ kɨndem danelɨñdok nɨ-nandɨñgɨlɨñ wɨn ep tɨmbɨ kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tɨmbi timlala tɨmbɨmbi, gwañgwañiilɨ Yesuloñ bɨmbi nɨñgɨlɨñ, “Ñɨn kwet sɨlaninnan pakamɨñ, wala dɨk amatam enɨ-mulɨmbi, it kwet ba kanda it ñasɨñgan pakañnan ñambi, nanañ tuk ba doundou it tɨmbɨ indawɨn.” ");
INSERT INTO nif_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Eumbi enguk, “Sɨn ep towiwɨt!” Eumbi nɨñgɨlɨñ, “Nɨndɨ plaua nanañ kɨt tambon gɨt mɨkbalak tɨpetgot pat-nɨmlak. Ba dɨk nɨndɨ ñambi, amatam gɨtɨk ñolok nanañ tuaneñdok wɨndɨñ nandɨ-nɨnɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Amatam asup kɨmɨn tɨ-pakɨlɨñ, gan amalok kwɨnakwɨnatsɨ wɨn 5,000 ba nek. Kusei wala tɨmbi gwañgwañiilɨ wɨndɨñ eñgɨlɨñ. Eumbi, Yesulɨ tambane enguk, “Amatam ep danbɨmbi, kɨmɨn no 50 no 50 wɨndɨñ pipalɨt.” ");
INSERT INTO nif_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wɨndɨñ eumbi, wolok tuop ep danbɨmbi pi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Tɨmbi Yesulɨ plaua kɨt tombon gɨta mɨkbalak tɨpet wɨn epbi, kunum plon deium loumbi, Yambat we ñɨmɨmbi, nanañ wɨn ombɨmbi, amatam danɨ-semnelɨñdok gwañgwañiila emguk. Emumbi, ");
INSERT INTO nif_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","gɨtɨkgandɨ nañgɨlɨñ. Na tokñe-taleumbi, nanañ na tla biñgɨlɨñ wɨn gamap dasiumbi, sandɨñ lɨk 12 tokñeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nain nola Yesulɨ engan nɨmolo kena tɨ-pap bɨmbi, gwañgwañii en gɨta pakɨlɨñ enda enɨ-nandɨmbi eñguk, “Amatamdɨ naka nin pa nanañ?” ");
INSERT INTO nif_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Eumbi tambane nɨñgɨlɨñ, “Asuptɨ dɨka Yoane tuk ii-sem pa ganañ, ba dɨwɨndɨ Elia bɨndambo indañguk wɨndɨñ pa eañ. Tɨmbi dɨwɨndɨ plofet damanin no mɨlapi kulak wɨndɨñ pa eañ.” ");
INSERT INTO nif_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Wɨndɨñ eumbi, nɨsɨla enɨ-nandɨmbi eñguk, “Gan sɨnla naka nin pa nanañ?” Eumbi, Petlolɨ “Dɨk Mesia Yambattɨ ganbɨ taleñguk” wɨndɨñ nɨñguk, ");
INSERT INTO nif_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","gan Yesulɨ enla Mesia sɨnɨk wɨn ama nola nɨm enɨnelɨñdok kɨmɨsip kwambɨñ tɨ-sembi ");
INSERT INTO nif_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","yousɨmbi enguk, “Nak Ama Sɨsɨnɨk nepek ñɨndɨñ inda-namektok een: Juda nɨndok ama biesɨ, tapma ama biesɨ gɨta endɨkñe manda nandɨ-tale ama endɨ nambum tuop nɨm tɨmbɨmbi, siñgi wɨt-nambi, pɨñgɨp gawat asupgan nambi, nulɨ kɨmbambi, sandap tɨpet gɨt no tɨmbɨmbi, Yambattɨ nep tɨmbɨm mɨlaletat.” ");
INSERT INTO nif_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Tɨmbi Yesulɨ ama gɨtɨkta ñɨndɨñ enguk, “No en nokok gɨñgɨt indam kuupi nandɨlakta, endɨ enlok nanandɨn siñgi wɨlɨmbi, sandap noñgan noñgan kloñbalɨ tɨke bembi, nak nep kle kuuktok elet. ");
INSERT INTO nif_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nekta, no en wɨndɨñ nɨm tɨmbi, kwelalok kuñgun enlok tɨke kamaiupi nandɨlakta, kuñgu kwambɨñ walɨ pailɨmekak. Tɨmbi no en naka tɨmbi kwelalok kuñgun biuktok tɨ-pañgɨtam patakta, kuñgu kwambɨñ walɨ palmekak. ");
INSERT INTO nif_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tɨkap amalɨ kwelalok nepenepek kusei kusei gɨtɨk ep kasɨleñɨlɨpi, kuñgun kolalak ba pailɨmlak, nepenepek walɨ en nɨtek tɨmbɨ londauk? Wɨn tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tɨkap kwelan ñolok ama nolɨ naka ba mandanala mayektalakta, endɨ kilamek! Neta, nain taletalenan nak Ama Sɨsɨnɨktɨ undane bɨ tombi, nakɨt Bepna ba kunumdok eñalo nɨndok nulɨnulɨn walɨ nep gɨmbulɨmbi, wolonda nak ama wala mayekta-ñɨmɨmbi, siñgi wɨlmetat. ");
INSERT INTO nif_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gan nak biañgan sanlet: ñɨ ikañ sɨndoñnan nanin dɨwɨn endɨ gama kaik kuñɨpi, Yambattɨ amatam indañgan yambɨ-dɨkñelak wɨn kanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesulɨ wɨndɨñ eu taleumbi, sande noñgan ñaumbi, Petlo, Yoane gɨt Yakobo yanañgɨpi, nɨmolo tɨmbepi kwet jañgɨn nolok loñguk. ");
INSERT INTO nif_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Lombi, nɨmolo tɨñɨlɨmbi, mam dai walan engano sɨnɨk tɨkɨleumbi, dasindasinlɨ bo satnin sɨnɨk kolɨ saleñguk. ");
INSERT INTO nif_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tɨmbi platik sɨnɨk ama tɨpet, Mose gɨt Elia, endɨ Yesu gɨta manda embi ikɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kunum nulɨnulɨnlɨ ep gɨmbulɨmbi, Yesulɨ kwet bimbi ñaukak wolok plon manda eñgɨmɨk, wɨn endɨ Yambattok nanandɨn kɨmɨt-kleñɨpi, Jelusalem kɨmbektok tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Eñɨlɨmbi, Petlo gɨt noliit endɨ doulɨ ep tɨmbɨ gwaseimbi dou pakɨlɨñ. Pakap sɨlɨkñembi, Yesulok nulɨnulɨn wakɨt ama tɨpet en gɨta ikɨmɨk yambɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Tɨmbi ama tɨpet endɨ Yesu bim ñañɨlɨmbi, Petlolɨ Yesu nɨñguk, “Bep, ñɨ pakamɨñ wɨn kɨndem sɨnɨk. Ñala it jala tɨpet gɨt no kɨnditna, dɨkok no, Elialok no, Moselok no.” Petlolɨ manda eñguk wolok kusei nɨm nandɨ-dakleñɨpi, joñgo eñguk. ");
INSERT INTO nif_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eñɨlɨmbi, mulukualɨ indambi ep tɨmɨlɨmbi, gwañgwalɨ mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tɨmbi mulukua gɨnañnan kɨtɨkɨtɨ nolɨ kɨtɨmbi enguk, “Ñɨn nokok nɨñana. Nak en kenana tɨmbektok kasɨleñgut; sɨndɨ endok mandan tɨke-kɨliñ e-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Manda eu taleumbi, gwañgwalɨ Yesu engan ilɨmbi kañgɨlɨñ. Tɨmbi nepek kañgɨlɨñ wala manjɨ galɨumbi, nain wolonda ama nola kasat nɨm tɨ-ñɨmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kwet salaumbi, Yesu gɨt gwañgwañii tɨpet gɨt no endɨ kwet jañgɨnnan nanin pɨ-taleumbi, amatam kɨmɨn wopum en mandɨ-pakɨlɨñ endɨ kanepi bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tɨmbi ama no boñgipsɨnan pakuk endɨ kɨtɨ-ñɨmɨmbi eñguk, “Endaut, nak dɨk nɨñana noñgan sɨnɨk wɨn nandɨ-ñɨmeñdok ganɨ-kukulelet. ");
INSERT INTO nif_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Nain nain yal kolan nolɨ tɨke-kwambɨñ dam tɨ-lamɨlɨmbi, platik sɨnɨk kwawa wopum tɨmbi, gembɨ kolɨmbi, man payak pa lambɨlak. Tɨñɨpi, nain noñgan noñgangot kañbiumbi, kɨndem pa patak. ");
INSERT INTO nif_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Wɨndɨñda tɨmbi nak gwañgwañgailɨ yal kolan wɨn klenelɨñdok enɨ-kukulet, gan endɨ yal kolan wɨn klenepi tɨ nɨm kambi bilɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tɨmbi Yesulɨ tambane eñguk, “Amatam man ñɨndɨñgɨt kuañ sɨndɨ ama kelakelamesɨ, tɨmbi nanandɨ-kɨlɨktɨnjɨ nɨm pat-samlak. Nak sɨn gɨta kuñgula kunjit tɨlet. Nain nɨtek sɨnɨk gamañgot sɨn gɨtañgan kuwambi, nanandɨ-kɨlɨktɨ inda-samekak?” Wɨndɨñ embi, gwañgwa beula nɨmbi eñguk, “Nɨñañga nañgɨp ñolok bo.” ");
INSERT INTO nif_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nañgɨp bɨñɨlɨmbi, yal kolanlɨ tɨke kolɨmbi, kwelan pɨmbi, gembɨ kokuk. Gan Yesulɨ yal nɨ-ñombɨmbi kle kolɨm ñaumbi, gwañgwa tɨmbɨ kɨndem daumbi, bɨndambo beulok kiinan kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tɨmbi amatam gɨtɨk endɨ Yambattok gembɨn wopum wandin kañbi ka-gɨtɨñgɨtɨk embi, nanandɨnjɨ nɨm dakleñguk. Amatamdɨ nepenepek gɨtɨk tɨñguk wala nanandɨ kena tɨñɨlɨmbi, Yesulɨ gwañgwañiila enbi eñguk, ");
INSERT INTO nif_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sɨndɨ pawanjɨ kɨmɨpi, manda ñɨn sanbep tɨlet wɨn nɨm nandɨ-kamalanekalɨñ. Nak Ama Sɨsɨnɨk kanjɨknailok kɨsɨnan napɨtnelɨñdok een.” ");
INSERT INTO nif_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gan gwañgwañiilɨ Yesu nek eñguk wɨn nɨm nandɨ-dakleñgɨlɨñ. Manda wolok kusei kɨmɨsembɨ-semɨnda tɨmbi nɨm nandɨ-kɨliñ embi, Yesu nɨ-nandɨnepi mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tɨmbi endɨ kusei kɨmɨpi, nɨsɨlok boñgɨpsɨnan nindɨ loloñ sɨnɨk tɨlak wala e-ka-lamɨt tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Tɨmbi Yesulɨ gɨnañ nanandɨnjɨ ka-nandɨ-daklembi, gwañgwa mɨnam no tɨke tiañe bɨmbi, en gɨta kɨmɨlɨ ilɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ñɨndɨñ enguk, “No en sɨndok boñgɨpsɨnan pɨmbɨñen sɨnɨk kulakta walɨ wakan loloñ sɨnɨk, wala tɨmbi no en nak nandɨ-nambi, gwañgwa ñandin nola not tɨ-ñɨmlakta, endɨ naka not tɨ-namlak, tɨmbi no en naka not tɨ-namlakta endɨ Yambatta not tɨ-ñɨmlak, wɨn Yambat nin nak nanɨ-mukuk enda not tɨ-ñɨmlak.” ");
INSERT INTO nif_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Tɨmbi Yoanelɨ nɨñguk, “Bep, ama nolɨ dɨkok koka kɨtɨmbi, yal kolan ep kleumbi kañgɨmɨñ, gan endɨ nɨn gɨta nɨm kuñɨpi, nɨm gep klelak, wala tɨmbi nɨndɨ nɨ-kɨmɨsip tɨ nɨm kañ biñgɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wɨndɨñ eumbi, Yesulɨ nɨñguk, “No en kanjɨk nɨm tɨ-samlakta endɨ not tɨ-samlak, wala tɨmbi sɨndɨ slakan nɨ-kɨmɨsip nɨm tɨ-ñɨmnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesu kunum gɨnañ nañgɨp lololok nain tɨmbɨ dumalañɨlɨmbi, nandɨ-gembɨlañɨpi, Jelusalem ñauktok ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ñañɨpi, ama dɨwɨn enɨ-mulɨmbi, telak dama ñañgɨlɨñ. Wɨn Yesu gɨt noliilok tɨ-jumut tɨ-semnelɨñdok ñambi, Samalia it kwet nolok ñam tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gan Yesulɨ Jelusalem ñaup tɨñgukta tɨmbi wɨnasɨlɨ enda nɨm nɨ-tiañenelɨñdok nandɨñgɨlɨñ. Wɨndɨñ tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesulok gwañgwañiit Yakobo gɨt Yoane endɨ wɨn nandɨmbi, nɨ-nandɨmbi eñgɨmɨk, “Wopum, nɨtɨ kɨtɨ nɨ-nandɨndambi, komba kunum gɨnan nanin pɨmbi, ep dɨum talenelɨñdok nandɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Eumbi tɨkɨle yambɨmbi, gwañgwa tɨpet wɨn enombɨumbi ");
INSERT INTO nif_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","yousɨmbi, it kwet nolok ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Telaknan ñañɨpi, ama nolɨ Yesula ñɨndɨñ nɨñguk, “Dɨk wandɨñ ba wandɨñ ñaupi, ñaukañ tuop gep kle kuutat.” ");
INSERT INTO nif_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Eumbi nɨñguk, “Klinalok toñgaut endɨ tombañjɨat, ba monɨk kunum plon kuañ endɨ bo isɨat, gan nak Ama Sɨsɨnɨkgan it nɨm pat-namlak.” ");
INSERT INTO nif_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tɨmbi Yesulɨ ama nola ñɨndɨñ nɨñguk, “Bɨ nak nep kle ku!” Gan ama walɨ ñɨndɨñ tambane nɨñguk, “Wopum, dɨk nandɨ-namumbi, dama ñambi, betna kɨndiletat.” ");
INSERT INTO nif_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Eumbi nɨñguk, “Yambiumbi, kɨmɨkɨmɨn nɨsɨ nosii ep kɨnditnekalɨñ. Gan dɨkta ñambi, Yambattɨ amatam indañgan yambɨ-dɨkñeukak wolok gɨñgɨt eu pɨukak.” ");
INSERT INTO nif_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tɨmbi ama nolɨ bo Yesula nɨmbi eñguk, “Wopum, nak gep kle-kuuttok nandɨlet, gan nandɨ-namum dama ilan ñambi, sambatnai enba nandumek bɨ gep kleutat.” ");
INSERT INTO nif_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Eumbi nɨñguk, “No en kena kusei kɨmɨpi, glimona pa tɨlak endɨ Yambattok kapmainan kena tɨndɨlok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Siñgi Yesulɨ bɨndambo gwañgwa 70 enbɨ taleumbi, endɨ it kwelan ba kwet ñaup eñguk tuop wandɨñ gwañgwañiilɨ tɨpet tɨpet telak dama ñanelɨñdok enɨ-mupi, ");
INSERT INTO nif_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ñɨndɨñ enguk, “Bien mepmeptok wɨn asup, gan kena tɨndɨlok ama wɨn lakat, wala tɨmbi sɨndɨ kena molom nɨmolo tɨ-ñɨmɨumbi, kena ama dɨwɨn ep tɨmbɨ indaumbi, kenan gɨnañ enɨ-mulɨmbi ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ñawɨt! Ñambi, ñɨndɨñ nandɨnekalɨñ: sɨndɨ sipsip nɨñañ wandin kamot moyen sañan endok boñgɨpsɨnan nak sanɨ-mulambi ña kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Sɨndɨ ñanepi, mɨnem wakɨt lɨk ba kesɨsɨ gwɨlap wɨn nɨm mep ñanekalɨñ. Tɨmbi telak plon ama yambɨmbi, manda manda nɨm tɨ-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","It nolok ba nolok lonepi, dama it wolok pakañ enda we sembi, ñɨndɨñ enɨnekalɨñ, ‘Busuk pat-samun.’ ");
INSERT INTO nif_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tɨkap busuk molom nolɨ it wolok kulakta, busuk mandanjɨlɨ enda gwɨlam tɨ-ñɨmekak. Tɨkap nɨmda, busuk mandanjɨ walɨ sɨnloñ undane bɨukak. ");
INSERT INTO nif_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Sɨndɨ it pɨmbɨñ nɨm kunekalɨñ. Kena tɨndɨn ama enda tuan ombɨ-mɨlok, wala tɨmbi it lonekalɨñ wolokgot pipat-mɨlat tɨmbi, nanañ tuk sep towiumbi nanekalɨñ walɨ wakan tuanjɨ tɨlak. ");
INSERT INTO nif_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","It kwet nolok ña tombɨmbi sep tiañembi, nanañ samumbi nanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tɨmbi wandɨñ ama jɨmbatsɨat ep tɨmbɨ kɨndem dambi, wɨnasɨla ñɨndɨñ enɨ-tɨ-kunekalɨñ, ‘Yambattɨ indañgan sambɨ-dɨkñeuktok nainñɨn dumala-talelak.’ ");
INSERT INTO nif_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Tɨmbi nain nola it kwet nolok ña tomñɨlɨmbi, sep tiañem not nɨm tɨ-samumbi, wolonda sɨndɨ ipakanan ñambi, ñɨndɨñ enɨnekalɨñ, ");
INSERT INTO nif_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nɨtɨ sɨndok plap no nɨm tɨke ñamɨk, wɨn sɨndok kɨlɨkɨlɨksɨlɨ kesɨtnetnan galɨlak wɨn bo wɨp mamañendambi pɨumbi, sɨnlok pat-samekak. Ganmek sɨndɨ ñɨndɨñ nandɨwɨt: Yambattɨ indañgan sambɨ-dɨkñeuktok nainñɨn dumala-talelak.’ Sɨndɨ wɨnasɨla wɨndɨñ enɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nak ñɨndɨñ sanlet: tombon ombɨ-tɨketɨkelok nainnan amatam siñgi wɨt-samsamɨn endok tombonjɨlɨ kolan tɨndɨn Sodom it kwelan kuñgɨlɨñ endok tombonjɨ maklelak. ");
INSERT INTO nif_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kolasin gɨt Betsaida nasɨ sɨndɨ kilañmet! Yambattɨ salamɨlekak! Nak kundit gembɨnat asup sɨndok kandañ tɨñgut walɨ Tilo ba Sidon it kwelan indaumda, platik sɨnɨk wɨnasɨlɨ gɨnanjɨ tambanembi, blandok dasindasin dasimbi, kwɨlɨñ plon pipatnelɨñ. Gan sɨndɨ gɨnañjɨ nɨm tambaneñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","wala tɨmbi Yambattɨ amatam yambɨ-danbekak wolonda sɨndɨ tombon ombɨ-tɨkenekalɨñ walɨ Tilo gɨt Sidon nasi tombonjɨ makleukak. ");
INSERT INTO nif_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tɨmbi Kapaneam nasi, sɨndɨ ‘Yambattɨ kunum gɨnañ nɨp loukak’ wɨndɨñ nɨm nandɨnekalɨñ! Nɨm sɨnɨk, sɨndɨ jɨmbɨñ sep kolɨ pɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila enguk, “No en mandanjɨ nandɨ-tɨke-kɨliñ eukak endɨ nokok mandana nandɨ-tɨke-kɨliñ eukak. Tɨmbi no en siñgi wɨt-samekak endɨ naka siñgi wɨt-namekak. Gan no en naka siñgi wɨt-namekak endɨ Yambatta siñgi wɨlɨmekak, wɨn Yambat nindɨ nak nanɨ-mukuk enda siñgi wɨlɨmekak.” ");
INSERT INTO nif_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Tɨmbi gwañgwa 70 Yesulɨ kena tɨndɨlok enɨ-mukuk endɨ sɨlɨsɨlɨ plon undane bɨmbi nɨmbi eñgɨlɨñ, “Wopum, nɨndɨ ñambi, dɨkok koka plon kena tɨnambi, yalɨ kolan endɨ bo mandanɨ pa tañgoneañ yañ!” ");
INSERT INTO nif_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Eumbi enguk, “Nak Satandɨ pɨumbi ka-tuakut wɨn pɨsapɨsattɨ kunum gɨnañ nanin pɨlak wandin. ");
INSERT INTO nif_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nandañ: sɨndɨ malet ba kauñ ep yalinelɨñdok ba kanjɨknɨ Satan endok gembɨn gɨtɨk tɨke-pɨ yalinelɨñdok nak ikan gembɨ sam-taleñgut pat-samlak, wala tɨmbi nepek nolɨ sep tɨmbɨ kolauktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gañgan sɨndɨ yal kolandɨ manjɨ tañgoneañ wala sɨlɨsɨlɨ nɨm tɨnekalɨñ. Nɨm. Sɨndok kosɨ kunumdok kot sambat gɨnañ youyoulɨn patak wala mek nandɨ-koñgom tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nain wolonda Dɨndɨm Woñdɨ Yesulok gɨnannan sɨlɨsɨlɨ wopum tɨmbɨ tokñe-ñɨmumbi, ñɨndɨñ eñguk, “Bep, kunum kwet molom, nak ñɨndɨñda ganɨ-kɨndem dalet: dɨk nanandɨñga ama nanandɨnjɨat ba nandɨ-daklenjɨat enda kɨmɨsembɨñguñ, wandingan embi wɨn amatam nanandɨnjɨ nɨmnat enda tɨmbɨ dakle-semguñ. Biañgan sɨnɨk, Bep, dɨk wɨndɨñ tɨmbepi nandɨñguñ tuop tɨñguñ.” ");
INSERT INTO nif_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tɨmbi amatamda ñɨndɨñ enguk, “Bepnalɨ gembɨn ba nanandɨn gɨtɨk wɨn naka nam-taleñguk. En noñganlɨñgot nak Nɨñañ nɨtein wɨn nandɨ-namlak. Tɨmbi nak wakɨt ama nin nak ep kasɨlembi, Bep daut semlet nɨndɨñgot Bep en nɨtein wɨn nandɨ-ñɨmamɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesulɨ gwañgwañii gɨta nɨsɨñgan palɨñɨlɨmbi, ñɨndɨñ enguk, “Amatam nindɨ nepek sɨndɨ kañ wolok tuop dausɨlɨ kañ endɨ amatam dɨwɨn yapma kle-pakañ. ");
INSERT INTO nif_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kusei ñɨndɨñda wɨndɨñ sanlet: plofet ama gɨta ama wapmañ damañgan kuñgɨlɨñ asuptɨ nepek sɨndɨ kañ wɨn kanepi nandɨ-koñgom tɨñgɨlɨñ, gan endɨ nɨm kañgɨlɨñ, ba manda sɨndɨ nandañ wɨn nandɨnepi nandɨ-koñgom tɨñgɨlɨñ, gan endɨ nɨm nandɨñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nain nola endɨkñe manda nandɨ-tale ama nolɨ Yesuloñ bɨ indambi, Yesulok nanandɨn ka-nanduktok e-ka tɨmbi nɨñguk, “Endaut, nak nɨtek tɨmbi, kuñgu taletalen nɨmnat wɨn kasɨlewɨt?” ");
INSERT INTO nif_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Eumbi nɨ-nandɨmbi eñguk, “Endɨkñe manda nɨtek youyoulɨn patak? Wɨn nɨnɨmbɨm nandɨna.” ");
INSERT INTO nif_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eumbi, ñɨn tambane nɨñguk, “Dɨk gɨnañga ba gɨnañga tip, gembɨñga ba nanandɨñga wɨn Wopum Yambatka endok gɨtɨk bi-ñɨm-taleumbi palmekak. Tɨmbi dɨtnala nandɨlañ, wɨndɨñgangot nokala nandɨ-ñɨmekañ.” ");
INSERT INTO nif_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wɨndɨñ eumbi, Yesulɨ nɨñguk, “Manda wɨn tambane elañ wɨn dɨndɨm sɨnɨk. Dɨk wɨndɨñgan tɨ-ta-kulañda, kuñgu kwambɨñ pakamekak.” ");
INSERT INTO nif_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Tɨmbi ama walɨ ‘Endɨkñe manda kɨmɨt-kle-taleñgut’ wɨndɨñ inda-dakleuktok Yesula ñɨndɨñ nɨ-nandɨmbi eñguk, “Tɨmbi ninda nandɨwambi, notna tɨmbekak?” ");
INSERT INTO nif_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Eumbi, Yesulɨ tambane eyout manda no ñɨndɨñ eñguk, “Ama nolɨ Jelusalem nanin Jeliko it kwelan pɨm ñaupi, telaknan ñañɨpi, ama piñdasɨ endok kɨsɨnan loñguk. Loumbi wɨpi, dasindasin gɨt kwɨlɨkwɨlɨ gɨtɨkan lom tɨke-ñɨm talembi, ama en kak bim ñaumbi, kɨmbepi tɨ pakuk. ");
INSERT INTO nif_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Palɨñɨlɨmbi, ñɨndɨñ indañguk: tapma ama nolɨ telak wolokgan pɨm ñambi ka-kɨmnembi, giñgiñgan ñambi, makle ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ñaumbi, tapma ittok kena ama nolɨ bo wolok bɨ tomguk endɨ wɨndɨñgangot ka-kɨmnembi, giñgiñgan ñambi, makle ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Gan ama Samalia nanin no telak wolokgan ñañguk endɨ ama wɨn pakuknan bɨ sua kañbi, blan tɨ-ñɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","endoñnan ñambi, wandan wɨn tuk galkñat wakɨt wain tuktɨ wɨlɨpi tɨmɨlɨmɨñguk. Tɨ-talembi, enlok doñki plon kɨmɨlɨm loumbi nañgɨp ñambi, patnandɨ ilan kɨmɨpi ka-dɨkñeñguk. ");
INSERT INTO nif_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Salaumbi kañɨp ñaupi, kena nain tɨpet wolok tuan mɨnem jimbi, patnandɨ it molom mɨmbi, ñɨndɨñ nɨñguk, ‘Dɨk ama ñɨn ka-dɨkñeukañ, tɨmbi mɨnem gamlet walɨ nain nɨtepektok tuop. Makleukakta, siñgi undane bɨmbi, yousɨmbi gametat.’” ");
INSERT INTO nif_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesulɨ wɨndɨñ embi, endɨkñe manda nandɨ-tale ama nɨ-nandɨmbi eñguk, “Ama tɨpet gɨt no endɨ ama nin piñdasɨlok kɨsɨnan loñguk wɨn kañgɨlɨñ. Dɨk nɨtek nandɨlañ, endoñnan nanin ama nin endɨ ama wolok nol sɨnɨk indalak?” ");
INSERT INTO nif_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Eumbi nɨñguk, “Gɨnañ busuk tɨ-ñɨmɨñguk en.” Tɨmbi Yesulɨ nɨñguk, “Dɨk bo ñambi, wɨndɨñgangot tɨ-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tɨmbi Yesulɨ gwañgwañii gɨt Jelusalem ñanepi, telaknan ñañɨpi, it kwet nolok tombɨmbi, tam no koi Mata endɨ ilnan nɨ-tiañeumbi loñguk. ");
INSERT INTO nif_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Loumbi, Matalok dalañ koi Malia endɨ Wopumdok kesiinan bɨ pipapi, mandan nandɨ-pakuk. ");
INSERT INTO nif_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Gan Mata endɨla nanañ neknek tɨ-jumupi, glimona tɨmbi, Yesuloñ indambi nɨ-ñombɨmbi nɨñguk, “Wopum. Dalana nambiumbi, natnañgan nanañ tɨ-jumut kena tɨlet. Dɨk wala nɨm nandɨlañ ba? Nɨmbɨm bɨm, nep kɨmɨlɨn.” ");
INSERT INTO nif_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Eumbi, Wopumdɨ tambane nɨñguk, “Mata Mata. Dɨk nepek asuptok nandɨ-bendɨ wopum tɨmbi, gɨnañga mɨlatalak, ");
INSERT INTO nif_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","gan dɨk nepek noñgangotta tɨpɨkalañ. Malia endɨla wɨn ep tɨndɨ kɨndem kasɨlelak wɨn nɨm apma tɨkelok. ");
INSERT INTO nif_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tɨmbi nain nola Yesulɨ kwet nolok nɨmolo tɨñguk. Tɨmbɨ taleumbi, gwañgwañiilok nanin nolɨ nɨmbi eñguk, “Wopum, Yoanelɨ gwañgwañiila nɨmololok sambat daut semguk, wɨndɨñgangot dɨk bo daut nɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Eumbi enguk, “Sɨndɨ nɨmolo tɨñɨpi, ñɨndɨñ enekalɨñ, ‘Bep, dɨkok koka wɨn giñgiñgan tɨ-gamlok. Dɨk amatam gɨtɨk nɨp tɨmbɨ gɨñgɨtkai indaneñ. ");
INSERT INTO nif_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Dɨk sandap noñgan noñgan wolok nanañ nɨmɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nɨndɨ amatamdɨ yom tɨ-nɨmañ wɨn gɨtɨk bi-semamɨñ, wala tɨmbi dɨk bo yomnɨ bi-nɨmɨñ. Dɨk tɨ-kuyuk plon nɨm nɨmbiwɨñ.’” ");
INSERT INTO nif_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Wɨndɨñ embi yousɨmbi enguk, “Tɨkap dɨk tim boñgɨpnan noka noloñ ñambi, kɨtɨu sɨlɨkñeumbi, ñɨndɨñ nɨmbeñ, ‘Nokok notna nolɨ telak bɨkap itnanan bɨumbi, nanañ towiupi yolonjɨlet, wala tɨmbi dɨk nanañ tɨpet gɨt no namɨñ, tɨmbi siñgimek tambon ombɨ-gametat.’ ");
INSERT INTO nif_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wɨndɨñ eumbi, noka it gɨnañgan dou patak endɨ ñɨndɨñ tambane ganbek bek, ‘Dɨk nekta douñatnan nanin nep sɨlɨkñelañ? It yama wesak ip kekakñet, tɨmbi wembe gwañgwanailɨ bo ip dou-talelɨñ, wala tɨmbi nɨtek mɨlapi gametet?’ ");
INSERT INTO nif_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nak ñɨndɨñ ganba: endɨ wɨndɨñ ganbi, dɨk endok nolla tɨmbi nɨm nandɨ-gamek bek, gañgan gɨñgɨneñgala tɨmbi endɨ joñgo mɨlapi, nepek nekta tɨpɨkalañ wɨn dɨka gamekak. ");
INSERT INTO nif_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Wɨndɨñda nak sɨnla ñɨndɨñ sanba nandɨwɨt: Yambatta nɨmolo tɨ-ñɨmñɨpi, nepek nola nɨ tɨ-kunekalɨñda wɨn kasɨlenekalɨñ, nepek nola lonjɨ tɨ-kunekalɨñda wɨn kanekalɨñ, tɨmbi yama wesak wɨt tɨ-kunekalɨñda pɨsat-samekak. ");
INSERT INTO nif_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Nekta, ama Yambattok plapta nɨ-nandañ endok kandañ wɨn ñɨndɨñ: nɨ-nandɨ tañdɨ kasɨleañ, lonjɨlonjɨ tañdɨ kañ, ba yama wesak wɨkañ enda pɨsat-semlak. ");
INSERT INTO nif_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ba sɨndoñ nanin bep nindɨ nɨñañlɨ mɨkbalakta nɨ-nandumbi, malet mɨwɨk ba? ");
INSERT INTO nif_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ba puput mɨnjɨpta nɨ-nandumbi, kauñ mɨwɨk ba? ");
INSERT INTO nif_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sɨndɨ kolan tɨndɨ ama, gañgan nepenepek kɨndem wembe gwañgwanjiila pa emañ. Wɨndɨñda nɨtek tɨmbi kunum Bepsɨ endɨ ama nindɨ Dɨndɨm Woñ kasɨlenelɨñdok nɨ-nandañ enda nɨm emek? Nɨm ya, endɨ sapma klembi, e-nandañ tuop emekak.” ");
INSERT INTO nif_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nain nola Yesulɨ ama nolok gɨnañnan yal kolan pɨ-ñɨmɨmbi man sipmɨñguk wɨn nɨ-kle-kolɨmbi po ñañguk. Ñaumbi, ama walɨ manda eumbi, amatamdɨ kundit wɨn kañgɨlɨñ endɨ ka piasat tɨmbi, nanandɨ kena tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gan dɨwɨndɨ ñɨndɨñ eñgɨlɨñ, “Endɨ yal kolan pa ep klelak wɨn yal kolandok telak damanjɨ Belsebul endok gembɨn plon tɨlak.” ");
INSERT INTO nif_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tɨmbi dɨwɨndɨ tɨ-kuyuk tɨ-ñɨmbi, Yambattok gembɨn palmɨlak wɨn tɨmbɨ dakle-semektok jimba kundit no tɨmbektok nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gan Yesulɨ gɨnañ nanandɨnjɨ wɨn ka-nandɨ-daklembi enguk, “Ama wapmañ nolok gɨñgɨtñiilɨ tambɨpi, nɨsɨñgan minelɨñda endɨ biañgan kola-talenekalɨñ. Tɨmbi sambat nolɨ bo wɨndɨñgangot tɨnelɨñda endɨ bo tawam papusenembi kolanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wɨndɨñgangot tɨkap Belsebul, wɨn Satan, endok sambaliilɨ tambɨpi, nɨsɨñgan miañda, kenanjɨlɨ nɨtek kwambɨñ dauk? Wɨn tuop nɨm. Wɨndɨñda tɨkap nak mandanjɨlok tuop klembi, Belsebullok gembɨnlɨ yal kolan pa ep klewamda, nak endok kenan tɨmba kolauk. ");
INSERT INTO nif_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Tɨmbi nepek no wɨn ñɨndɨñ: tɨkap Belsebullɨ gembɨ namumbi, yal kolan ep kle-semamda, nindɨ nosii gembɨ emumbi, endɨ yal kolan pa ep kle-semañ? Belsebul ba? Nɨm bek. Wɨndɨñda nɨtek tɨmbi nokok plon wɨndɨñ eañ? Sɨndɨ naka manda juluñɨt nanañ wɨn nosiilɨ wakan tɨmbɨ dakle-samnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gan tɨkap nak biañgan Yambattok gembɨnlɨ yal kolan pa ep kleletta, ñɨndɨñ inda-daklelak: sɨndɨ Yambattɨ sambɨ-dɨkñelak endok gembɨn wɨn ikan boñgɨpsiinan ka-nandañ. ");
INSERT INTO nif_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ama gembɨnat nolɨ miktok nepenepek gɨtɨk tɨwɨlɨ dɨkñembi, ilɨ ka-dɨkñe-kɨliñ elakta, gɨñgɨtñii ep tɨmbɨ kolanelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Endɨ miktok nepenepel walɨ tɨke kamaiuktok nandɨlak, gan ama no nolɨ wolok gembɨn maklelak endɨ ama woloñ bɨmbi, mik tɨ-ñɨmɨmbi maklelakta, endɨ miktok nepenepel wakɨt gɨñgɨtñii gɨtɨk apma ep danbi, enlok noliila emlak. ");
INSERT INTO nif_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Tɨmbi miktok kandañ wɨn ñɨndɨñ: no en not nɨm tɨ-namlakta endɨ kanjɨk tɨ-namlak, tɨmbi nindɨ nakɨta kena nɨm tɨmbi, gɨñgɨtnai ep kɨmɨn tɨlakta endɨ ep kleum papuseneañ.” ");
INSERT INTO nif_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesulɨ wɨndɨñ embi yousɨmbi enguk, “Tɨkap yal kolan nolɨ ama gɨnan gɨnañ nanin lambɨ poñaukta, endɨ yal pa kuañnan ñambi, pipapat lonjɨmbi kuwɨk. Lonjɨ tɨlapbi, ñɨndɨñ ewɨk, ‘Nak bɨndambo undane ñambi, pakutnan lowa.’ ");
INSERT INTO nif_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wɨndɨñ embi, ña kawɨk wɨn: it wɨn ikan jamimbi tɨ-dɨndɨm em bimbin palek. ");
INSERT INTO nif_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Wɨndɨñ kañbi ñambi, yal kolan en makleañ kɨt tombon tɨpet yanañgɨlɨm bɨmbi, it wandɨñ lombi, wolok kunelɨñ. Wɨndɨñ tɨmbɨmbi, ama blangan. Nekta, dama yal kolan noñgandɨ ama wɨn tɨmbɨ kolaumbi, siñgi yal kolan asuptɨ tɨmbɨ kola sɨnɨk tauk.” ");
INSERT INTO nif_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesulɨ manda wɨndɨñ eumbi, tam no amatam kɨmɨn tɨ-pakɨlɨñ endok boñgɨpsɨnan pakuk endɨ kɨtɨmbi, ñɨndɨñ nɨñguk, “Tam gapbi, num gamguk endɨ amatam dɨwɨn yapma klembi patak.” ");
INSERT INTO nif_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gan Yesulɨ tamdok mannan tɨkembi, ñɨndɨñ eñguk, “Wɨn amatam Yambattok mandan nandɨmbi tañgoneañ endɨ wakan amatam dɨwɨn yapma kle pakañ.” ");
INSERT INTO nif_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Amatamdɨ yousɨyousɨ pa bɨñɨlɨmbi, kɨmɨn wopumgan indaumbi, Yesulɨ kusei kɨmɨpi, ñɨndɨñ enguk, “Amatam man ñɨndɨñgɨt kuañ sɨndɨ kolasɨ. Sɨndɨ kusatna kañbi nambɨ-daklenelɨñdok jimba kundit no kanelɨñdok embi gɨñgɨneañ, gan jimba kundit no nɨm daut samum kanekalɨñ. Nɨm sɨnɨk. Wɨn Yonalok jimba kunditgot kanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nepek nek Yonala inda-ñɨmɨñguk wɨn Ninive nasila ñɨndɨñ daut semguk: wɨn Yambattɨ nɨ-mulɨmbi bɨñguk. Wɨndɨñgangot nak Ama Sɨsɨnɨk nepek nek inda-namekak wɨn amatam man ñɨndɨñgɨt kuañ sɨnda ñɨndɨñ daut samekak: wɨn Yambattɨ nanɨ-mulɨmbi indañgut. ");
INSERT INTO nif_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kwet no koi Siba wolok tam wapmalɨ manda plon lololok nainnan amatam man ñɨndɨñgɨt kuañ sɨn gɨta mɨlapi, kusasɨ tɨmbɨ dakleukak. Endɨ ama wapmañ Solomonda nandumbi, manda nandɨ-daklelok molom tɨmbɨmbi, endok mandan nanduktok kwet mayañgan sɨnɨk nanin endoñ ñañguk. Gañgan sɨndɨ ama Solomon maklelak endok mandan nandɨ-kɨmkɨmneañ, wala tɨmbi kɨnjan tɨkenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tɨmbi Ninive nasilɨ manda plon lololok nainnan amatam man ñɨndɨñgɨt kuañ sɨn gɨta mɨlapi, kusasɨ tɨmbɨ dakleukak. Endɨ Yonalok mandala gɨnañjɨ tambaneñgɨlɨñ, gañgan sɨndɨ ama Yona maklelak endok mandala wɨndɨñ nɨm tañ, wala tɨmbi kɨnjan tɨkenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ama nolɨ kolsalen pɨndopi, kambottɨ nɨm tapliwɨk ba kwet sembɨn nolok nɨm kɨmɨlek. Tambo endɨ indañgan kɨmɨpi, ama it gɨnañ loañ kolɨ sale-semlok wɨndɨñ tɨmbek. ");
INSERT INTO nif_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Daukalɨ pɨñgɨpkalok kolsale wandin. Daukalɨ kɨndemda, Yambattɨ kolsalen gamlak wala ka-dakleumbi, gɨnañga gɨtɨk kolɨ salelak. Daukalɨ kolanda, gɨnañga gɨnañ kɨlɨm mulumgot pakamlak. ");
INSERT INTO nif_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Wala tɨmbi kilañmek! Nɨm kañbi, kolsalen kasɨleup nandɨñguñ, gan kɨlɨm ikan kasɨleum pakamlak. ");
INSERT INTO nif_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wɨndɨñda tɨkap kolsalendɨ gɨnañga gɨtɨk tokñeumbi, kɨlɨm no nɨm pakamlakta, sipalaktɨ kolɨ sale-gamlak wɨndɨñgan dɨk bo kolɨ salelañ.” ");
INSERT INTO nif_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesulɨ manda eu taleumbi, Falisi ama nolɨ nanañ yakan nandemɨktok nɨ-tiañeumbi, ñam ilnan lombi, nanañ nanalok pipakuk. ");
INSERT INTO nif_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gan endɨ dama kii nɨm wɨlɨkukta tɨmbi Falisi ama walɨ nandɨ-bendɨ tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wopumdɨ nɨñguk, “Falisi sɨndɨ jawañ ba tuk wɨtna wɨn pawangot pa wɨlɨkañ wandin, gan sɨndɨ gɨnañjɨ gɨnañ kolan ba tɨ-piñpiñelɨ tokñem patak. ");
INSERT INTO nif_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Sɨndɨ ama kamasɨ! Yambattɨ nepek pawan tɨmbɨ indañguk, wɨndɨñgangot endɨ gɨnañ nɨm tɨmbɨ indañguk ba? ");
INSERT INTO nif_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pawandok nepek wala nandɨ-bendɨ wopum nɨm tɨnekalɨñ. Tambo sɨndɨ gɨnañjɨ wɨn pɨmbɨñesɨla bi-sembi, ep kɨmɨtnekalɨñ. Wɨndɨñ tɨnelɨñda, gɨnañjɨ gɨt ep tɨndɨnjɨ tɨpet walɨ Yambattok dainan jamilan indaukak. ");
INSERT INTO nif_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Falisi sɨndɨ nanañ kena gɨnañ nanin gɨtɨk wɨn tambɨpi, gwasap ba yaya wɨn bo kɨt tambon tambon tambɨpi, Yambattok tambon pa mañ, gan gɨnañjɨlɨ en nɨm kasɨleañ, ba ep tɨndɨn dɨndɨm nɨm pa tañ, wala tɨmbi sɨndɨ kilañmek! Yambat en mek sambekak. Sɨndɨ Yambatta tambon mɨñɨpi, enda ba amatamda gɨnañjɨ emnelɨñ ñak! ");
INSERT INTO nif_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Falisi sɨndɨ it kiyau gɨnañ pitit damañgot pitnelɨñdok nandañ, tɨmbi kɨmɨlɨ tuanan amatamdɨ we sambi, giñgiñgan tɨ-samnelɨñdok nandañ, wala tɨmbi kilañmet! ");
INSERT INTO nif_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Amatamdɨ sum sembɨn no nɨm ka-nandɨ-daklembi, wolok plon joñgo yalimbi kolayañ. Sɨndɨ sum sembɨn wandin, gan amatamdɨ nepenepek kolanlɨ sɨndok gɨnañjɨ tokñelak wɨn nɨm ka-nandɨ-dakleañ, wala tɨmbi kilañmet!” ");
INSERT INTO nif_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tɨmbi endɨkñe manda nandɨ-tale ama nolɨ Yesula nɨñguk, “Endaut, dɨk Falisi amala wɨndɨñ enlañda, nɨnda bo giñgiñgan nɨm tɨ-nɨmlañ.” ");
INSERT INTO nif_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eumbi enguk, “Endɨkñe nandɨ-tale ama sɨndɨ amatam nepek mɨlap tañgonenelɨñdok pa emum mɨlataumbi, ep tɨmbɨ pañgɨtanelɨñdok kɨt kɨmɨt no nɨm pa tɨ-semañ, wala tɨmbi kilañmet! Yambattɨ sɨndɨ bo sambekak. ");
INSERT INTO nif_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Sɨndɨ kilañmet! Plofet ama nin bep pañjiilɨ yandɨp kɨmgɨlɨñ endok sum gwatnam wɨn sɨndɨ tɨmbɨ kaik talak. ");
INSERT INTO nif_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Endɨ yandɨp kɨmgɨlɨñ, tɨmbi sɨndɨ sum gwatnamjɨ tɨmbɨ kaik tañ, wala tɨmbi bep pañjiilɨ plofet amala nek tɨ-semgɨlɨñ wɨn sɨndɨ ka nandum kɨndem sɨnɨk tɨlakta sɨn inda-dakleañ. ");
INSERT INTO nif_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kusei wɨndɨñda Yambat nanandɨ-tale molom endɨ ñɨndɨñ eñguk, ‘Nak plofet ba gɨñgɨt ee ama Islael amatamdoñ enɨ-mulam ñaumbi, endoñnan nanin dɨwɨn ep tɨmbɨ kolanelɨñdok kle-gɨmgɨm embi, dɨwɨn yandɨp kɨmnekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Wala tɨmbi plofet ama gɨtɨk kwet kusei kɨmɨkɨmɨlɨnan nanin bɨkap man ñɨndɨñgɨt yandɨp kɨmgɨlɨñ endok wekatsɨlok tuan kolan wɨn amatam man ñɨndɨñgɨt kuañ sɨndɨ ombɨ-tɨkenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wɨn Abellok plon kusei kɨmɨpi, Sakalaia ama nin sisuat gɨt tapma it wolok boñgɨpsetnan wɨlɨ kɨmguk endok plon talelak endok kɨmkɨmjɨlok tuan kolanla nak biañgan ñɨndɨñ sanlet: amatam man ñɨndɨñgɨt kuañ sɨndɨ wɨn ombɨ-tɨkenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Yambatta nanandɨlok telak walɨ it wandin. No en wolok gɨnañ lolakta endɨ Yambattok kusei ka-nandɨ-daklembi nandɨ-ñɨmlak. Endɨkñe manda nandɨ-tale ama sɨndɨ it wolok yama ki wɨn kɨmɨt kimbɨñ dañ, gan gɨnañ nɨm loñgɨlɨñ, tɨmbi amatamdɨ bo lonep nandɨñgɨlɨñ wɨn kɨmɨsip tɨ-semgɨlɨñ, wala tɨmbi kilañmet!” ");
INSERT INTO nif_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Yesulɨ wɨndɨñ eu taleumbi, walinin pɨ ñaumbi, Falisi gɨt endɨkñe nandɨ-tale ama endɨ kusei kɨmɨpi, kanjɨk kolan sɨnɨk tɨ-ñɨmbi, nɨ-nandɨ kusei kusei tɨñɨpi, ");
INSERT INTO nif_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kɨt yout tɨnelɨñdok enlok mandanlɨ sɨsoñ tɨ-ñɨmnep nandɨmbi, mandɨmandɨ tɨ-ñɨmgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nain wolonda amatam asup kwɨnakwɨnattok tuop nɨm endɨ bo Yesuloñ kɨmɨn tɨmbi kle-gɨmbupi, tambo yali tɨñgɨlɨñ. Tɨmbi Yesulɨ kusei kɨmɨpi, dama gwañgwañiila ñɨndɨñ enguk, “Sɨndɨ Falisi amalok plaua kɨmɨlɨmbendɨnjɨla ka-kɨliñ embi kunekalɨñ. Wɨn endɨ manjɨ mambenjɨ tɨpelat, tɨmbi ep tɨndɨnjɨ juluñɨt tañ wala elet. Nɨm kañbi, sɨndɨ bo wɨndɨñgangot tɨnelɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Biañgan sɨnɨk, nepek kɨmɨsembɨn gɨtɨk wɨn Yambattɨ tɨmbɨ indañgan indaumbi, nanandɨ sembɨn gɨtɨk wɨn tɨmbɨ dakleukak. ");
INSERT INTO nif_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wɨndɨñda sɨndɨ manda kɨlɨm gɨnañ eñgɨlɨñ wɨn maim plon eu indaukak, tɨmbi sɨndɨ nepek no it gɨnañnan manda janjak eñgɨlɨñ wɨn ipakanan wopumgan eu pɨukak.” ");
INSERT INTO nif_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yesulɨ yousɨmbi enguk, “Notnai, nak ñɨndɨñ sanba: amalɨ pɨñgɨpsɨñgot wɨlɨ kɨmnelɨñ, gan siñgi kandañ sep tɨmbɨ kolanelɨñdok gembɨ no nɨm pat-semlak enda nɨm mɨsɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Tambo ninda mɨsɨ-ñɨmlok wɨn daut sametet: Yambattɨ ama wɨlɨ kɨmbi, siñgi kandañ jɨmbɨñ kolɨ pɨuktok gembɨn palmɨlak enda mɨsɨmɨsɨ tɨ-ñɨmlok. Biañgan sɨnɨk sanlet: endañgot mek mɨsɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Monɨk tiptip kɨt tombongot wɨn mɨnem gɨmɨn tɨpettɨ tuatuan, gañgan Yambattɨ noñgan no nɨm kamala-ñɨmlak. ");
INSERT INTO nif_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Sɨndɨ endok dainan loloñ sɨnɨk, monɨk asup yapma kleañ, tɨmbi endɨ kumbanjɨ saktok kwɨnakwɨnatsɨ wɨn bo nandɨ-talelak, wala tɨmbi amala nombo nɨm mɨsɨ-semnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sanba nandɨwɨt. No en amalok dausɨnan ‘Nak Yesulok gɨñgɨt’ wɨndɨñ e-daklelakta, nak Ama Sɨsɨnɨktɨ Yambattok eñaloñiilok dausɨnan enda wakan ‘Endɨ nokok gɨñgɨt’ wɨndɨñ e-dakleutat. ");
INSERT INTO nif_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gan no en amalok dausɨnan naka ‘En nɨm nandɨ-ñɨmlet’ elakta, nak Yambattok eñaloñiilok dausɨnan enda wakan ‘En nɨm nandɨ-ñɨmlet’ eutat. ");
INSERT INTO nif_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tɨmbi no en Ama Sɨsɨnɨk nanɨ-kolalakta, endok yomɨn wɨn kɨndem bi-ñɨmlok, gan no en Dɨndɨm Woñ nɨ-lakalakae tɨlakta, endok yomɨn wɨn kɨmɨlɨm palmekak. ");
INSERT INTO nif_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","12","Amalɨ manda plon sepmbi, it kiyau gɨnañ ba gavmandok dainan ba lolonjiilok dausɨnan sapɨtnekalɨñ. Nain wolongan sɨnɨk Dɨndɨm Woñdɨ manda nek eelok wɨn daut samekak, wala tɨmbi wolonda sɨndɨ nandɨ-bendɨ wopum tɨmbi, ñɨndɨñ nɨm enekalɨñ, ‘Nɨndɨ manda nek enetamɨñ?’ Ba ‘Nek tambane enɨnetamɨñ?’” ");
INSERT INTO nif_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tɨmbi ama kɨmɨn wopum boñgɨpsɨnan ama nolɨ Yesu nɨmbi eñguk, “Endaut, datnalɨ betnettok kii bimbin wɨn en noñganlɨñgot ep kulak, wala tɨmbi dɨk nɨmbɨmbi, nokok tambon danbi namɨn.” ");
INSERT INTO nif_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eumbi nɨñguk, “Notna, ba ama nolɨ nak sambɨ-danbettok ba nepenepeset danɨ-samettok nanbɨ taleñguk ba? Nɨm ya, wɨn nokok kena nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wɨndɨñ embi yousɨmbi, amatamda enguk, “Nepek tokñetokñen walɨ kuñgu kɨndem nɨm samlak, wala tɨmbi sɨndɨ ka-kɨliñ embi, kuñgunjɨ ka-dɨkñe-kɨliñ enekalɨñ. Nɨm kañbi, kwɨlɨkwɨlɨ ba nepek nola ka-galkta tɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Wɨndɨñ embi, eyout manda no ñɨndɨñ embi enguk, “Ama mɨnem kwɨlɨkwɨlɨ asupmat endok nanañ kenan bien lali kɨndem daumbi, ");
INSERT INTO nif_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","nanandɨn gɨnañ ñɨndɨñ nandɨ-kwɨnakwɨnaleñguk, ‘Nɨtek tɨlok? Nanañ bien asup ñalɨ it kawai wolok gɨnañjɨnan wɨsɨ-kolettok tuop nɨm!’ Wɨndɨñ nandɨmbi ");
INSERT INTO nif_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","eñguk, ‘Kombɨkmek nandɨlet: nak wɨsɨ-kot it kawai gɨtɨk wɨn wiapi, komblin wopum asupgan kɨndipi, nanañ ba kwɨlɨkwɨlɨ gɨtɨk pat-namlak wɨn wolok wɨsɨ-koletat. ");
INSERT INTO nif_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tɨñɨpi, natnala ñɨndɨñ eutat: Ip ñak! Nak nepenepek kɨndem gwɨlat asuptok kɨmɨp kiulambi pat-namlakta tɨmbi kɨndem pat-nandɨmbi, na sɨlɨsɨlɨ tɨmbetat!’ ");
INSERT INTO nif_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Gan Yambattɨ tambon ñɨndɨñ nɨñguk, ‘Dɨk kamen, man tim ñolondañgan kuñguñga gapma tɨkelok. Tɨmbi nepek tɨ-jumut tɨñguñ walɨ nindok tɨmbekak?’” ");
INSERT INTO nif_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesulɨ eyout manda wɨndɨñ embi, yousɨmbi enguk, “No en kwelan ñolok kwɨlɨkwɨlɨ asup palmektok ep kiutak, gan nepek Yambattok dainan tuannat no nɨm palmɨlakta, endɨ ama kamen wandin.” ");
INSERT INTO nif_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila ñɨndɨñ enguk, “Nepek tokñetokñen walɨ kuñgu kɨndem nɨm samlakta tɨmbi nak kuñgunjɨlok ba pɨñgɨpsɨlok kandañ ñɨndɨñ sanlet: wɨn kuñgu ba pɨñgɨp walɨ bien tɨlak, nanañ ba dasindasin walɨ nɨm, wala tɨmbi sɨndɨ nanañ nek nanekalɨñ ba dasindasi nek dasinekalɨñ wala nandɨ-bendɨ wopum nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Sɨndɨ monɨk oeoe yambɨm nandɨwɨt: endɨ nanañ tɨpi-bimbi met nañ wɨndɨñ nɨm pa tañ, tɨmbi endɨ wɨsɨ-kot it bo nɨm pat-semlak, gañgan Yambattɨ tuopkan ep towilak. Sɨndɨla endok dainan monɨk yapma kleañda, nɨtek tɨmbi nɨm sep towiuk? ");
INSERT INTO nif_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tɨmbi sɨndoñnan nanin no endɨ nandɨ-bendɨ wopumlɨ kuñgun lakat yousum ombatawɨk ba? Nɨm ya! ");
INSERT INTO nif_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Sɨndɨ nepek tip kambak wandin tɨndɨlok tuop nɨm, wɨndɨñda kusei nekta nepek dɨwɨn wala nandɨ-bendɨ wopum pa tañ? ");
INSERT INTO nif_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pama klinan indañ wɨn yambɨm nandɨwɨt! Nak ñɨndɨñ sanba: endɨ kena meñ nɨm tañ, ba dasindasinjɨ bo nɨm pa youkañ, gañgan endok pamanjɨlɨ ama wapmañ Solomondɨ dasindasin kɨndem sɨnɨk pa dasilɨñguk endok paman wɨn maklelak. ");
INSERT INTO nif_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kli nepek pamanat kena gɨnañ man lambɨ indaumbi, desa dombɨmbi ep siu dɨnekalɨñ wandin wɨn bo Yambattɨ dasindasinjɨ kɨndem emlak, nɨtekta tɨmbi endɨ sɨndok dasindasinjɨ nɨm tɨmbɨ inda-samek? Wɨn nɨm nandañda, sɨndok nanandɨ-kɨlɨktɨnjɨ wɨn lakat sɨnɨk pat-samlak! ");
INSERT INTO nif_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","30","Amatam Yambat nɨm nandɨ-kɨlɨktɨ mañ endok nanandɨnjɨlɨ nanañ tuk nepek wandindokgot pat-semlak. Bepsɨlɨ ikan ñɨndɨñ nandɨ-talelak: nepek gɨtɨk wɨn nɨm pat-samekta sɨndɨ kunelɨñdok tuop nɨm, wala tɨmbi sɨndɨ amatam dɨwɨndɨ tañ wɨndɨñ nɨm tɨnekalɨñ, ba nandɨ-bendɨ wopum nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Tambo sɨndok nanandɨnjɨlɨ Ama Wapmañjɨlok gɨñgɨt kuñgulokgot pat-samekak, tɨmbi nepek wandin walɨ bo kuñgunjɨlok inda-samekak.” ");
INSERT INTO nif_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Tɨmbi Yesulɨ gwañgwañiila enbi eñguk, “Kɨkesmɨn tip, sɨndok Bepsɨlɨ ñɨndɨñ tɨndɨla nandum kɨndem dañguk: en ama wapmañjɨ kumbi, sɨndɨ en gɨta kandɨkñe kena tɨnelɨñdok nandɨmbi, wolok tuop tɨñguk, wala tɨmbi sɨndɨ mɨsɨmɨsɨ nɨmnat kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Sɨndɨ nepenepesɨ pat-samlak wɨn tuatualok kɨmɨpi, mɨnem walinin tɨkembi, pɨmbɨñesɨla emnekalɨñ. Wɨndɨñ tɨnekalɨñda, tuanjɨ nɨm taleukak wɨn kunum gɨnañ pat-samekak. Kumbu amalɨ wɨn kumbu tɨnelɨñdok tuop nɨm, ba kwɨnakamdɨ wɨn nɨm tɨmbɨ kolaukakta tɨmbi walɨ mɨnem lɨksɨ nɨm kolawɨk wandin. Sɨndɨ kwelalok nepenepek wala galk nɨm nandɨnekalɨñ. Tambo sɨndɨ nepek nek Yambattok dainan loloñ sɨnɨk wala galk nandɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kusei ñɨndɨñda: nepek gɨnañjɨlɨ kasɨleum pataknan kandañ gɨnañ nanandɨnjɨlɨ bo wandɨñ pat-samekak. ");
INSERT INTO nif_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Kena gwañgwalɨ molomjɨlɨ nanañ si-jumut tɨndɨnnan nanin undane ilan bɨmbi, wesak wɨlɨmbi, platik sɨnɨk pɨsalɨmnelɨñdok mandɨmandɨ pa tañ, wɨndɨñgangot sɨndɨ kolsalenjɨ pɨndolɨm dɨumbi, kena tɨndɨlok tɨ-pañgɨtam kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kena gwañgwalɨ wɨndɨñ tɨ-kuñɨlɨmbi, molomjɨlɨ undane bɨmbi kalak wɨn: kena gwañgwañiilɨ gama kaik papi, mandɨ pakañ. Kena gwañgwa wandin walɨ gwañgwa dɨwɨn yapma kle pakañ. Nak biañgan sanba: molomjɨlɨ kena tɨndɨlok tɨ-pañgɨpañgɨ tɨmbi, nanañ nanelɨñdok enɨ-tiañembi, nananjɨ kle-semekak. ");
INSERT INTO nif_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wɨn tim bomup ba puputtɨ kusei kɨmɨpi kɨtɨlaknan undane bɨmbi, kena gwañgwalɨ gama kaik palɨñɨlɨmbi ep tɨmbɨ indaukta, gwañgwa walɨ wakan dɨwɨn yapma kle pakañ. ");
INSERT INTO nif_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tɨmbi sɨndɨ nepek ñɨn nɨm nandɨ-kamalanekalɨñ: it molomdɨ kumbu amalɨ nain nekta sɨnɨk bɨwɨk wɨn nɨm nandɨlak. Nandɨwɨmda! endɨ kaik kuñɨpi, il wiapi, gɨnañ loup tɨmbɨmbi kɨmɨsip tɨ-ñɨmek. ");
INSERT INTO nif_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wɨndɨñgangot sɨndɨ ‘Ama Sɨsɨnɨktɨ man nɨm tombek bek’ wɨndɨñ nandɨñɨlɨmbi, wolongan kaikan bɨ tombekak. Wɨndɨñda tɨmbi sɨndɨ tomtomnalok tɨ-pañgɨtam kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tɨmbi Petlolɨ nɨñguk, “Wopum, eyout manda elañ wɨn nɨndokgot ba amatam gɨtɨktok?” ");
INSERT INTO nif_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Eumbi tambane eñguk, “Manda wɨn kandɨkñe ama matañgotañgolat nanandɨn kɨndem palmɨlak wandin wala elet. Wɨn en wakan molomñiilɨ kena gwañgwañii dɨwɨn yambɨ-dɨkñelok nɨmbɨ taleumbi, nanañ mepmettok nain dɨndɨm sɨnɨk danɨ-semektok nɨlak. Molomñɨlɨ kena manda wɨndɨñ nɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ña kukap undane bɨmbi kalak wɨn: kena gwañgwalɨ nek tɨmbektok nɨñguk wolok tuopkan tɨñgukta endɨ gwañgwa dɨwɨn yapma kle patak. ");
INSERT INTO nif_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nak biañgan kena gwañgwa enda ñɨndɨñ sanlet: molomñɨlɨ nepenepel gɨtɨk wɨn endɨ ka-dɨkñeuktok nɨmbɨ taleukak. ");
INSERT INTO nif_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gan tɨkap kena gwañgwa walɨ gɨnan gɨnañ ñɨndɨñ nanduk, ‘Molomnalɨ ña sakñelambi, platik nɨm bɨukak’ wɨndɨñ nandɨmbi, kusei kɨmɨpi, kena wembe gwañgwa dɨwɨn joñgo yandɨpbi, nanañ ba tuk kwambɨñ wopum nañbi, kamakama tɨmbekta, nek inda-ñɨmek? ");
INSERT INTO nif_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kena gwañgwa molomñɨlɨ kena nain nekta ba nain nekta sɨnɨk bɨukak wɨn nɨm nandɨlakta tɨmbi endɨ nɨm mandɨ palɨmbi, nain wolondañgan molomñɨlɨ undane bɨukak. Bɨmbi, ep tɨndɨn kolan wɨn kañbi, wolok kɨnjan tɨ-lamɨpi, amatam Molom nɨm kɨmɨt-kleañ en gɨta tuanjɨ kolan ombɨ-semekak. ");
INSERT INTO nif_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tɨkap kena gwañgwa walɨ molomñɨlok mandan nandɨñguk, gan nɨm tañgoneñguk ba nɨm tɨ-pañgɨpañgɨle tɨñgukta, en nain ombapgan waipmɨlok. ");
INSERT INTO nif_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gan tɨkap endɨ molomñɨlok mandan wɨn nɨm nandɨñgukta makleumbi, nain dumangan waipmɨlok. Wɨndɨñgangot tɨkap Yambattɨ ama nola gwɨlam asup mɨmɨnda endɨ wolok tuopkan tambon ombɨ-mɨlok nandɨlak, ba endok kiinan kena wopum kɨmɨkɨmɨlɨnda, endɨ wolok tuopkan kenalok bien indauktok nandɨlak.” ");
INSERT INTO nif_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesulɨ yousɨmbi enguk, “Nak komba kwelan kɨmɨlam dɨuktok indañgutta ñɨndɨñ nandɨlet: komba walɨ ikan dualɨmda, wɨn kɨndem sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Gan nak dama tuk walan no iilok nanbɨ taletalen. Tuk wɨn gama nɨm iñgutta tɨmbi mɨlap walɨ gɨnañna tɨmbɨ mɨlatalak. ");
INSERT INTO nif_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Sɨndɨ nak amatam kwelan ep tɨmba busukñenengan kunelɨñdok indañgut wɨndɨñ nandañ ba? Wɨndɨñ nɨm. Nak ñɨndɨñ sanba nandɨwɨt: tambo nak amatam ep tambɨlettok indañgut. Naka tɨmbi ");
INSERT INTO nif_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","man ñɨndɨñgɨtta kusei kɨmɨpi, kundit ñɨndɨñ inda-ta-ñaukak: sambat kɨt meñ noñgan yakan pa kuañ endɨ tambɨpi, kɨmɨn tɨpet indambi, tɨpettɨ tambon, tɨpet gɨt nolɨ tambon wɨndɨñ ipi, nɨsɨñgan tambon tambon kanjɨk tɨ-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Wɨndɨñ tambɨpi, bep nɨñan endɨ nɨsetkan tambon tambon ipi, kanjɨk tɨndekamɨk, tɨmbi me wemba endɨ bo nɨsetkan tambon tambon ipi, kanjɨk tɨndekamɨk, tɨmbi nambɨn tam gɨt yapman tam endɨ nɨsetkan tambon tambon ipi, kanjɨk tɨndekamɨk.” ");
INSERT INTO nif_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesulɨ amatam kɨmɨn wopumda yousɨm ñɨndɨñ bo enguk, “Sɨndɨ mulukualɨ tuk kimbɨñ kandañ indam bɨumbi kañbi, wolongan ñɨndɨñ pa eañ, ‘Gwi bɨutak’ wɨndɨñ eumbi, wolok tuop indalak. ");
INSERT INTO nif_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Tɨmbi sɨndɨ sasalelɨ klinan kandañ nanin pendɨp bɨumbi kañbi, ñɨndɨñ pa eañ, ‘Maim kunduwat dɨutak’ wɨndɨñ eumbi, wolok tuopkan indalak. ");
INSERT INTO nif_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ama manjɨ mambenjɨ tɨpelat! Sɨndɨ kunum gɨt kwettok plon nek indalak wɨn kañbi, maim iletak ba gwi pɨutak wɨn ka-kɨliñ eañ. Gan nɨtekta tɨmbi sɨndɨ man ñɨndɨñgɨt nepek nek indalak wɨn kañbi, kenanalok kusei nɨm ka-nandɨ-dakleañ? ");
INSERT INTO nif_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ba kusei nekta sɨnlok ep tɨndɨnjɨ plon nek ñalɨ dɨndɨm sɨnɨk wɨn bo nɨm ka-danbi, wolok tuop tañ? ");
INSERT INTO nif_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tɨkap ama nolɨ manda plon gapɨlep tɨmbɨmbi, sɨtɨ telaknan yakan ñañɨpi, mandanjet e-salendemɨktok nɨka tɨmbekañ. Nɨm kañbi endɨ gɨñgɨnembi, gep tiañembi, manda kandanloñ gapɨlɨmbi, endɨ bo tem dumandok kiinan gapɨlɨmbi, endɨ gepmbi, it kwambɨñnan gapɨlek. ");
INSERT INTO nif_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Biañgan ganlet, dɨk it kwambɨñ gɨnañ papi, mɨnem nɨtek ombɨ-ñɨmlok een wɨn gɨtɨk ombɨ-mɨ-taleuñ wolok tuop.” ");
INSERT INTO nif_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nain wolondañgan amatam wolok bɨ pakɨlɨñ endoñnan nanin dɨwɨndɨ Yesula kasat ñɨndɨñ tɨ-ñɨmgɨlɨñ: Galili ama dɨwɨndɨ tapma ilan tapma tɨñɨlɨmbi, Pilatolɨ eum yandɨpmɨum kɨmbɨmbi, wekatsɨlɨ pɨmbi, tapma gauttok wekatsɨlɨ wakɨt kiukuk. Kasat wɨndɨñ tɨ-ñɨmɨumbi ");
INSERT INTO nif_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","tambane enguk, “Mɨlap wandin inda-semgukta, ama wolok yomjɨlɨ Galili ama dɨwɨsɨlok yom makleñguk, sɨndɨ wɨndɨñ nandañ ba? ");
INSERT INTO nif_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nak ñɨndɨñ sanba: nanandɨnjɨ wɨn dɨndɨm nɨm. Gan sɨndok kandañ, tɨkap sɨndɨ gɨnañjɨ nɨm tambanem kunekalɨñda, wɨndɨñgangot sɨndɨ gɨtɨk kola-talenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tɨmbi amatam 18 Siloam kandañ kɨmgɨlɨñ wɨn endok kandañ nɨtek? It ombap jɨñgɨnlɨ gɨlombi, ep kot tapliñguk. Endok kolanjɨlɨ amatam dɨwɨn gɨtɨk Jelusalem kuañ endok kolanjɨ makleñguk, sɨndɨ wɨndɨñ nandañ ba? ");
INSERT INTO nif_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nak ñɨndɨñ sanba: nanandɨnjɨ wɨn dɨndɨm nɨm. Gan sɨndok kandañ, tɨkap sɨndɨ gɨnanjɨ nɨm tambanenekalɨñda, wɨndɨñgangot sɨndɨ gɨtɨk kola-talenekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Tɨmbi Yesulɨ eyout manda no ñɨndɨñ enguk, “Ama nolok wain kenan gɨnañ fik komba no tɨpium pakuk. Tɨmbi kena molomdɨ komba wɨn ka-nandɨ tɨmbepi bɨñguk, gan endɨ bien no nɨm lali palɨmbi kañguk. Bien nɨmnat kañbi, ");
INSERT INTO nif_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","kena kandɨkñe amala nɨmbi eñguk, ‘Kalañ: gwɨlat tɨpet gɨt no gɨtɨk wolok gɨnañnan nak ñañambɨ tɨmbi, komba bienda yolonjɨlet, gan endɨ bien no nɨm lalilak. Neta slakan sɨnɨk kwettok galk tiañe-talelak? Kak, dombɨ kot!’ ");
INSERT INTO nif_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Eumbi nɨñguk, ‘Molomna. Biumbi, gwɨlat noñgangot nombo yousɨ-mɨum palɨn. Palɨmbi, nak kwet tambɨpi, kuseinan makauttok tem kɨmɨpi kautat. ");
INSERT INTO nif_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gwɨlat no wolondamek bien laliukak bek. Tɨkap nɨmda, komba wɨn kɨndem dombɨ kolekañ.’” ");
INSERT INTO nif_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat patnandɨ nain nola Yesulɨ it kiyau nolok gɨnañnan amatam enɨ-daut tɨ-sem pakuk. ");
INSERT INTO nif_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tɨmbi tam no yal kolandɨ pɨ-ñɨmɨmbi, jɨmbat siñgin sait gɨnañ tɨmbɨ inda-ñɨmɨumbi, en dɨndɨm ilektok tuop nɨm, wala tɨmbi gwɨlat 18 wolok tuop plindambi pa kulɨñguk, endɨ bo wolok bɨ pakuk. ");
INSERT INTO nif_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Palɨmbi, Yesulɨ tam wɨn kañbi kɨtɨ-ñɨmɨum bɨumbi nɨñguk, “Tam, jɨmbat gep top-kɨliñ eñguk walɨ ip taleumbi, siñgiñga pañeun.” Wɨndɨñ eñɨpi, ");
INSERT INTO nif_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","kii endok plon kɨmɨlɨmbi, wolongan siñgin sait tɨ-dɨndɨm embi, kusei kɨmɨpi, Yambat nɨ-kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesulɨ Sabat patnandɨ nainnan tam wɨn tɨmbɨ kɨndem dañgukta tɨmbi it kiyaulok telak dama endɨ gɨnañ komba dɨumbi, amatam enombɨmbi, ñɨndɨñ eñguk, “Sandap kɨt tambon noñgan wɨn kena tɨndɨlok pat-samlak, wolonda endɨ sep tɨmbɨ kɨndem danelɨñdok bɨnekalɨñ, Sabat patnandɨ nainnan nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wɨndɨñ eumbi, Wopumdɨ tambane ñɨndɨñ nɨñguk, “Ama manjɨ mambenjɨ tɨpelat! Sɨndɨ gɨtɨk makauk ba doñkinjɨ wɨn Sabat patnandɨ nainnan isɨnan ep pɨsapi, tuk nanelɨñdok pa yanañgɨkañ. ");
INSERT INTO nif_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gan tam ñɨn Ablaamdok komblin endok kandañ wɨn nɨtek? Satandɨ gwɨlat 18 gɨtɨk topmɨumbi ku-ta-bɨlak, tɨmbi sɨndɨ en Sabat patnandɨ nainnan nɨm pɨsalɨmlok nandañ ba?” ");
INSERT INTO nif_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wɨndɨñ eumbi, kanjɨkñii gɨtɨktɨ mayek tam palɨmbi, amatam gɨtɨk endɨ kundit kɨndem sɨsɨnɨk tɨlɨñguk gɨtɨk wala sɨlɨsɨlɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Tɨmbi Yesulɨ yousɨmbi enguk, “Yambattok kandɨkñe wɨn nɨtein? Kandɨkñe walɨ nɨtek bendɨlak nak wolok plon eyout manda nek eut? ");
INSERT INTO nif_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Wɨn mastat mɨnjɨp ama nolɨ tɨkembi, kenan gɨnañ kokuk wandin. Mɨnjɨp tipnam walɨ lambɨ bendɨ wopum dambi, komba wopum tɨmbɨmbi, monɨktɨ isɨ kii gayam plon tɨñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Wɨndɨñ embi, bɨndambo ñɨndɨñ enguk, “Nak Yambattok kandɨkñe wɨn nɨtein eut? ");
INSERT INTO nif_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Wɨn plaua kɨmɨlɨmbendɨ tam nolɨ tɨkembi, plaua kwɨlan wopumgan wakɨt kiupi tambaneñguk wandin. Papalem kaumbi, kɨmɨlɨmbendɨ lakatgot walɨ plaua gɨtɨk wɨn tɨmbɨ bendɨ lambɨñguk.” ");
INSERT INTO nif_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesulɨ Jelusalem ñaupi, it kwet wopum ba tip wandɨñ ñañɨpi, amatam enɨ-daut tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tɨmbi ama nolɨ nɨ-kañbi eñguk, “Wopum, wɨn ama lakat endɨñgot Yambattɨ kolanjɨlok tuan wiat-semumbi, kunum gɨnañ lonekalɨñ ba nɨtek?” Eumbi enguk, ");
INSERT INTO nif_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nak ñɨndɨñ sanlet: amatam asuptɨ Yambattok kandañ ñanepi wɨt nɨm kanekalɨñ, wala tɨmbi sɨndɨ yama gik sɨnɨk wolok lonelɨñdok gembɨ kotnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","It molom endɨ mɨlapi, yama sip taleumek, sɨndɨ bɨ it pawan ipi, wesak wɨpi nɨnekalɨñ, ‘Wopum, yama pɨsat-nɨmɨñ.’ Eumbi, tambon ñɨndɨñ sanbekak, ‘Nak nɨm nandɨ-samlet. Sɨndɨ denasi?’ Sanbɨ nandɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","kusei kɨmɨpi, manda tombon ñɨndɨñ nɨnekalɨñ, ‘Nɨndɨ dɨkɨta yakan nanañ tuk nañgɨmɨñ, tɨmbi dɨk nɨndok ipakanan gɨñgɨt manda e-daut tɨñguñ.’ ");
INSERT INTO nif_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gan endɨ ñɨndɨñ sanbekak, ‘Nak ñɨndɨñ sanlet: sɨndɨ denasi wɨn nak nɨm nandɨ-samlet. Kolan tɨndɨ gɨtɨk sɨndɨ nambim ña-talewɨt!’ ");
INSERT INTO nif_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Tɨmbi kɨmɨsip tɨ-samgukta tɨmbi sɨndɨ kunum pawan papi, Ablaam, Aisak, Jekop gɨt plofet gɨtɨk endɨ Yambat gɨta kuñɨlɨmbi yambɨnekalɨñ, wolondamek sɨndɨ wandɨñ kukulembi, manjɨ sɨ-gɨlɨm danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tɨñɨlɨmbi, Yambattok gɨñgɨtñiilɨ kwet tambon tambon taletalenan nanin en gɨta kunelɨñdok bɨmbi, nanañ si-jumut tɨndɨnnan pipapi nanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nandañ: wolonda ñɨndɨñ indaukak: ama nin enda nandum siñgi kuañ endoñnan nanin dɨwɨsɨlɨ dama tɨnekalɨñ, tɨmbi damandaman kuañ endoñnan nanin dɨwɨsɨlɨ siñgi tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nain wolongan Falisi ama dɨwɨndɨ Yesuloñ bɨmbi nɨñgɨlɨñ, “Elottɨ gwɨlɨ kɨmbeñdok nandɨlak, wala tɨmbi dɨk ñalinin pɨ ñau.” ");
INSERT INTO nif_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eumbi enguk, “Sɨndɨ ñambi, kamot moyen wala ñɨndɨñ nɨmbɨt, ‘Nandɨlañ, nak man gɨt desa jɨmbatsɨat ep tɨmba kɨndem dambi, yal kolan ep kle-sembi, siñgi nombo yousɨ ñambi, kenana tɨmba taleukak.’ Sɨndɨ ña wɨndɨñ nɨmbɨ nandɨwɨn. ");
INSERT INTO nif_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Biañganak, plofet ama Jelusalemgot yandɨp kɨmkɨmlok, kwet nolok nɨm, wala tɨmbi nak man ba desa ba sisa telaknan yousɨ ñañalok een. ");
INSERT INTO nif_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jelusalem nasi, sɨndɨ blasɨñgandok. Sɨndɨ plofet ama pa yandɨp kɨmañ, tɨmbi ama sɨndoñ enɨ-mumulɨn bañ wɨn kawattɨ yandɨpmɨum kɨmañ. Puputtɨ nɨñañii ep kɨmɨn tɨmbi, papaulɨ ep kamailak, wɨndɨñgangot nain asupgan natnaloñ sep kɨmɨn tɨmbettok nandɨñgut, gan sɨndɨ nɨm nandɨ-namgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nandañ! Wopumdɨ sɨndok kwesɨ bimbi, nombo nɨm sep kamaiukak. Tɨmbi nak ñɨndɨñ sanba: sɨndɨ nombo nɨm nambɨnekalɨñ. Nɨm sɨnɨk. Sɨndɨ nokok plon ñɨndɨñ enekalɨñ, ‘Wopumdɨ ama nɨ-mulɨm nɨndoñ bɨlak en gwɨlam mɨlok!’ wolondamek nombo nambɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat patnandɨ nain nola Falisi ama loloñ nolɨ Yesu nanañ nanalok nɨ-tiañeumbi ña lo palɨmbi, nanañ beulok noliilɨ ka-tuakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tɨmbi ama no kii kesii bendɨmbendɨnat endɨ Yesulok dainan bɨ indaumbi ");
INSERT INTO nif_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","kañbi, endɨkñe manda nandɨ-tale ama gɨt Falisi ama enɨ-nandɨmbi eñguk, “Endɨkñe mandalɨ nek tɨneñdok nandɨ-nɨmlak - Sabat nainnan ama kɨndem tɨmbɨ kɨndem dalok ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Wɨndɨñ eumbi, manda no nɨm tambane nɨmbɨmbi, ama wɨn tɨkembi, tɨmbɨ kɨndem dambi nɨ-mulɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tɨmbi Yesulɨ enɨ-nandɨmbi eñguk, “Sabat patnandɨ nainnan nɨñañjɨ ba makauksɨ nolɨ tuk ban gɨnañ pɨukta, sɨndoñnan nanin nin endɨ platikan nɨm tiañeum lambek?” ");
INSERT INTO nif_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Wɨndɨñ eumbi, manda tambon tambane nɨnelɨñdok lonjɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tɨmbi ama enɨ-tiatiañen endɨ ama lolondok pitit plon pipatnelɨñdok pilɨmbi, Yesulɨ wɨn kañbi, eyout manda no ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Ama nolɨ nanañ sina tɨlaknan gep tiañeumbi, dɨk dɨtnalok nanandɨñgala ama lolondok pitit plon nɨm pipaleñ. Nɨm kañbi, ama loloñga no nanañ molomdɨ nɨ-tiañeñguk endɨ bɨumbi, ");
INSERT INTO nif_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","sɨtet tɨpelat sep tiañeñguk endɨ gambɨmbi, ñɨndɨñ ganbek, ‘Endok pitit wɨn, bi-ñɨmɨmbi, nolok pit.’ Wɨndɨñ ganbɨmbi, dɨk siñgi mayek tɨmbɨmbi, ganɨ-mulɨm siñgi sɨnɨk ña pipaleñ. ");
INSERT INTO nif_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wɨndɨñda tɨmbi, tambo gep tiañenekalɨñ wolonda dɨk pitit siñgi sɨnɨk wolok pilekañ. Wɨndɨñ tɨmbeñda, nanañ molomdɨ gambɨmbi ñɨndɨñ ganbek, ‘Notna, dɨk lo, pitit dama tɨke.’ Wɨndɨñ ganbɨmbi, dɨk ama dɨwɨn no gɨta yakan nanañ nalañ endok dausɨnan kot gɨñgɨt tɨkeukañ. ");
INSERT INTO nif_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nekta, ama gɨtɨk nɨsɨlok kosɨ gɨñgɨt tɨke-loañda endok kosɨ gɨñgɨt tɨke-pɨukak, tɨmbi no en kayombɨnem kulakta en tɨke-loukak.” ");
INSERT INTO nif_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tɨmbi Yesulɨ yousɨmbi, ama nɨ-tiañeñguk enda ñɨndɨñ nɨñguk, “Dɨk nanañ sina tip ba wopum tɨñɨpi, nokai ba dat kwayañgai ba sambakai ba dɨkok kwekanan nasɨ mɨnem kwɨlɨkwɨlɨnjɨat wandisɨ wɨn nɨm pa enɨ-tiañeukañ. Nɨm kañbi, endɨ bo tombon gep tiañembi, nepek nek tɨñguñ wolok tombon kwelan ñolok ombɨ-gamum tɨke-taleuñ. ");
INSERT INTO nif_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Tambo dɨk nanañ sina tɨñɨpi, ama pɨmbɨñesɨ wakɨt ama kɨsɨ ba kesɨsɨ ba dausɨ kolan wandisɨ enɨ-tiañeukañ. ");
INSERT INTO nif_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Endɨ tombon ombɨ-gamnelɨñdok tuop nɨm, gan ama dɨndɨm endɨ kɨmnan nanin mɨlatnekalɨñ wolondamek Yambattɨ tuañga kɨndem ombɨ-gamumbi, amatam dɨwɨn yapma kle palekañ.” ");
INSERT INTO nif_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Tɨmbi ama Yesu gɨta yakan nanañ nañgɨlɨñ endoñnan nanin nolɨ manda wɨn nandɨmbi, ñɨndɨñ nɨñguk, “No en Yambattɨ nanañ sina wopum gɨñgɨtñiilok tɨ-semekak wɨn nambekakta endɨ amatam dɨwɨn yapma kle patak.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesulɨ nɨñguk, “Nain nola ama nolɨ nanañ sina wopum tɨmbepi, amatam asup sɨnɨk enɨ-tiañeñguk. ");
INSERT INTO nif_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nanañ nanalok nain indaumbi, kena gwañgwa no nɨ-mulɨmbi, enɨ-tiatiañen endoñ ñambi enguk, ‘Nepenepek gɨtɨk ip tɨwɨlɨ dɨkñemɨñda tɨmbi sɨndɨ bɨwɨt!’ ");
INSERT INTO nif_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Gan endɨ noñgan noñgandɨ kusei kɨmɨpi, e-tembɨ manda nɨmbi eñgɨlɨñ. Ama dama ña kañguk endɨ ñɨndɨñ nɨñguk, ‘Nak kwet sanoñgat no tuañgut wɨn ña kauttok een, kusei wala tɨmbi nak nɨm bɨmbɨlok dɨk nokok blan mandana molomgala nɨmbekañ.’ ");
INSERT INTO nif_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tɨmbi ama noloñ ñaumbi, endɨ ñɨndɨñ nɨñguk, ‘Nak makauk wapai kɨt tombon tombon kena emettok ep tuañgut wɨn yanañgɨpi tɨkatɨka tɨmbepi ñaupi tɨlet, kusei wala tɨmbi nak nɨm bɨmbɨlok dɨk nokok blan mandana molomgala nɨmbekañ.’ ");
INSERT INTO nif_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tɨmbi nolɨ bo ñɨndɨñ nɨñguk, ‘Nak tam kombɨkan tɨñgutta tɨmbi ñañalok tuop nɨm.’ ");
INSERT INTO nif_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tɨmbi kena gwañgwalɨ undane bɨmbi, enɨ-tiatiañen endɨ nek eñgɨlɨñ wolok kasat gɨtɨk wɨn molomñɨla tɨ-ñɨmɨñguk. Tɨmbi nanañ beulɨ gɨnañ komba dɨumbi, kena gwañgwan ñɨndɨñ nɨñguk, ‘Dɨk platik sɨnɨk it kwettok telak tip ba wopum wandɨñ ñambi, ama pɨmbɨñesɨ wakɨt ama kɨsɨ ba kesɨsɨ kolan ba dausɨ sipsipmɨn yambɨmbi yanañgɨlɨm bɨwɨt.’ Wɨndɨñ eumbi, wolok tuopgan tɨmbi, undanem bɨmbi ");
INSERT INTO nif_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","nɨmbi eñguk, ‘Molomna, mandañga ip biennat tɨlak, gan it gɨnañ gama nɨm tokñek.’ ");
INSERT INTO nif_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wɨndɨñ eumbi nɨñguk, ‘Bɨndambo ñambi, it kwet pawan telak tip ba wopum tuop kuñɨpi, amatam yambetañ wɨn enɨ-gɨñgɨneumbi, itna gɨnañ tokñenelɨñdok bɨwɨt. ");
INSERT INTO nif_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nak ñɨndɨñ sanlet: ama dama enɨ-tiatiañen endoñnan nanin nolɨ nanañ tɨ-jumut tɨ-semɨt wɨn lakat no nɨm nanekalɨñ.’” ");
INSERT INTO nif_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tɨmbi amatam kɨmɨn wopum asuptɨ Yesu ñañguknan kle ñañɨlɨmbi undane yambɨmbi, ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“No en nakɨta kuupi nandɨlak, gan naka tɨmbi meñ beu wakɨt tamɨn ba wembe gwañgwañii ba dal kwayañii ba wiwii ba enlok kuñgun wɨn bo siñgi nɨm wɨt-semlakta, endɨ nokok gwañgwana sɨnɨk kuuktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tɨmbi no en enlok kloñbal nɨm tɨke bembi, nak nep kle kulakta, endɨ nokok gwañgwana sɨnɨk kuuktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tɨkap sɨndoñnan nanin nolɨ it wopumgan kɨndilep nandɨwɨkta, endɨ dama pipapi, ittok tuanla nandɨmbi, mɨnem palmɨlak walɨ it wɨn tɨmbɨ taleuktok tuop ba nɨm wɨn ka-nandɨwɨk. ");
INSERT INTO nif_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Nɨm kañ, yop tambi, it kusei kɨmɨlek, gan endɨ it tɨmbɨ taleuktok tuop nɨm, tɨmbi ama it wɨn ka-nandañ endɨ gɨtɨktɨ kusei kɨmɨpi nɨ-lakalaka embi, ");
INSERT INTO nif_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ñɨndɨñ enelɨñ, ‘Ama ñalɨ it plapkan kusei kɨmɨpi kɨndikuk, gan nɨtekta nɨm tɨmbɨ talelak?’ ");
INSERT INTO nif_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ba tɨkap ama wapmañ no endɨ ama wapmañ nol nola mik tɨ-ñɨmepi ñauk, endɨ nɨtek tɨmbek? Endɨ dama pipapi nandɨ-kɨliñ embi, endok ama lakatgot endɨ dɨwɨndok ama asupgan mik tɨ-semnelɨñdok tuop ba nɨm. ");
INSERT INTO nif_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Tɨkap nɨmda, kanjɨkñɨlɨ gama mayañgan palɨñɨlɨmbi, ama wapmañ walɨ kanjɨkñɨloñ manda kɨmɨlɨm ñaumbi nɨmbek, ‘Busuk inda-nɨmektok nɨtek tɨmbet?’ ");
INSERT INTO nif_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Wɨndɨñgangot sɨndɨ gɨñgɨtsii ba nepenepesɨ gɨtɨk pat-samlak wɨn siñgi wɨlmɨnelɨñdok nɨm tɨ-pañgɨtam pakañda, sɨndɨ nokok gwañgwanai sɨnɨk kunelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Palañ wɨn nepek koñgom sɨnɨk. Gan wolok koñgomlɨ talewɨkta, nɨtek tɨnambi, nombo koñgom dawɨk? Wɨndɨñ tɨndɨlok tuop nɨm! ");
INSERT INTO nif_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Palañ wandin wɨn nana kena gɨnañ ba gwɨlañgwɨlam gɨnañ kena nɨmnat, slak kolɨm ñalok. No en pawañnat endɨ pawañ kɨmɨpi, mandana nandɨ-kɨliñ eukak.” ");
INSERT INTO nif_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Tɨmbi takis epep ama ba yom ama asupgandɨ Yesulok mandan nandɨnepi pa baañgɨlɨñ. Wɨndɨñ tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Falisi ama gɨt endɨkñe manda nandɨ-tale ama endɨ yambɨmbi nandum pɨumbi, Yesula nɨ-wolwolk embi eñgɨlɨñ, “Ama walɨ yom ama not tɨ-sembi, en gɨta pipat-mɨlat tɨmbi, nanañ yakan pa nalak.” ");
INSERT INTO nif_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wɨndɨñ eumbi, Yesulɨ eyout manda no ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tɨkap sɨndoñ nanin ama nolɨ sipsip 100 yambɨ-dɨkñeñɨlɨmbi, noñgan nolɨ pailekta, biwɨk ba? Nɨm ya! Endɨ 99 dɨwɨn wɨn kwet kli pataknan yambium kli na-palɨmbi, noñgan pailak wɨn lonjɨ ñakap tɨmbɨ indauk wolok tuop. ");
INSERT INTO nif_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tɨmbɨ indambi, walen kɨndem daumbi, bupum mɨmbi undane ñauk. Ña ");
INSERT INTO nif_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ilnan tombi, nolii ba il kwelnan nasii kɨtɨ-semum bɨumbi enbek, ‘Sipsip pailak wɨn ip tɨmba indakta tɨmbi, bɨ nakɨta sɨlɨsɨlɨ tɨmbɨt!’ ");
INSERT INTO nif_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nak sanba nandɨwɨt: ama walɨ sipsip pait-palɨmbi tɨmbɨ indañguk wala sɨlɨsɨlɨ wopum tɨñguk, wɨndɨñgangot yom ama noñgan no endɨ gɨnañ tambanelak enda tɨmbi kunum gɨnañ sɨlɨsɨlɨ wopum sɨnɨk indaukak. Gan ama 99 endɨ ikan dɨndɨm kuañda tɨmbi gɨnañ tambatambatta nɨm nandañ enda tɨmbi sɨlɨsɨlɨ lakatgot indaukak.” ");
INSERT INTO nif_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesulɨ wɨndɨñ embi yousɨmbi enguk, “Tɨkap tam nolok mɨnem kwandai satnin kɨt tambon tambon palmek, tɨmbi noñgan no pailekta, kak biwɨk ba? Nɨm ya. Endɨ kolsalen pɨndopi, it jamimbi, lonjɨ-kɨliñ embi, tɨmbɨ indauk wolok tuop. ");
INSERT INTO nif_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tɨmbɨ indaumbi, nolii ba il kwelnan nasii kɨtɨ-semum bɨumbi enbek, ‘Mɨnemna pailak wɨn ip tɨmba indakta tɨmbi bɨ nakɨta sɨlɨsɨlɨ tɨmbɨt!’ ");
INSERT INTO nif_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nak ñɨndɨñ sanba nandɨwɨt: tam walɨ mɨnem kwandai pailɨmɨmbi tɨmbɨ indañguk wala sɨlɨsɨlɨ tɨñguk, wɨndɨñgangot yom ama noñgan no endɨ gɨnañ tambanelak enda tɨmbi Yambattok eñaloñiilok boñgɨpsɨnan sɨlɨsɨlɨ indalak.” ");
INSERT INTO nif_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tɨmbi Yesulɨ yousɨmbi enguk, “Ama no endok nɨñañiit tɨpet pakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Pakap, monalɨ beula ñɨndɨñ nɨñguk, ‘Bep, dɨk mɨnem kwɨlɨkwɨlɨ ba kwet pakamlak wɨn itañgan danbi, nokok tambon namɨñ.’ Eumbi, nepek gɨtɨk wɨn danbi emguk. ");
INSERT INTO nif_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Monalɨ nain nɨm ombataumbi, beulɨ nepenepek mɨñguk wɨn tualok kɨmɨt-talembi, mɨnem gɨtɨk epmbi, kwet mayañgan ñambi pat-tɨ-kuñguk. Kumbi, nandɨ-kamala-kuñɨpi, mɨnem epguk wɨn gɨtɨk kot-taleñguk. ");
INSERT INTO nif_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kot-taleumbi, kwet pakuknan wandɨñ nanañ map wopum indañguk. Indaumbi, gwañgwa walɨ nanañla lonjɨ nɨm kañbi, ");
INSERT INTO nif_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ama wɨnanin noloñ ña pa galɨumbi, bɨl yambɨ-dɨkñeuktok kena gɨnañ nɨ-mulɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ña kena tɨ-kuñɨpi, nanañ gawat tɨlɨñgukta tɨmbi bɨttok nanañ wɨn bo ep nanalok galk nandɨlɨñguk, gan enlok nanañ nepek no nɨm pa maañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Wɨndɨñ tɨ-kukap, gɨnañ nanandɨn tombɨmbi, ñɨndɨñ nandɨñguk, ‘Ama betnalok mɨnem kena tɨ-ñɨmañ gɨtɨk endok nanañ tuk wɨn mɨlapkan pat-semlak, gan nak endok nɨñañlɨ ñolok nanañnala kɨmbepi pa tɨlet. ");
INSERT INTO nif_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Wɨndɨñda nak kwet ñɨn bimbi, bɨndambo betnaloñ ña tombi, ñɨndɨñ nɨmbetat: Bep, nak Kunum Molom gɨt dɨk sɨta yom tɨ-samgut, ");
INSERT INTO nif_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","wala tɨmbi nak ñandin ñalɨ nombo nɨñañga sɨnɨk kuuptok tuop nɨm, slak nandɨ-namumbi, mɨnem kena tɨ-gambi kuutat.’ ");
INSERT INTO nif_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Wɨndɨñ nandɨmbi mɨlapi, wolongan beuloñ ñauktok ñañguk. Ñakap, kambak mayañgan il tɨmbɨ dumalaum bɨumbi, beulɨ kañguk. Kañbi ka-daklembi, blan tɨ-ñɨmbi, woñep ñam apbi, sɨmumuñ tɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Tɨmbi nɨñañlɨ ñɨndɨñ nɨñguk, ‘Bep, nak Kunum Molom gɨt dɨk sɨta yom tɨ-samgut, wala tɨmbi nak ñandin ñalɨ nombo dɨkok nɨñañga sɨnɨk kuuptok tuop nɨm.’ ");
INSERT INTO nif_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Gan beulɨ nandɨ-kɨmnembi, kena gwañgwañiila ñɨndɨñ enguk, ‘Sɨndɨ platik sɨnɨk ñambi, dasindasi engano pamanat wɨn tɨke bɨmbi dasi-ñɨmɨt, tɨmbi besa pamanat kii nɨñañ plon dasi-ñɨmɨmbi, kesɨ gwɨlap wakɨt dasi-ñɨmɨt. ");
INSERT INTO nif_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tɨmbi makauk nɨñañ kɨttɨ towium bendɨ wopum da-kɨliñe patak wɨn tɨke bɨm wɨp, sina wopum tɨmbi, sɨlɨsɨlɨ tɨna. ");
INSERT INTO nif_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Neta, nɨñana ñɨn endɨ kɨmguk ba paikuknan nanin nombo bɨ indambi, kaik patak.’ Wɨndɨñ eumbi, kusei kɨmɨpi, sɨlɨsɨlɨ wopum tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Tɨñɨlɨmbi, tuanlɨ kena gɨnañ pakuk walɨ ilan undane bɨm, it tɨmbɨ dumalaumbi, amatamdɨ kap tiumbi nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nandɨmbi, kena gwañgwa no kɨtɨ-ñɨmɨum bɨumbi, nɨ-nandɨ asup tɨmbi, ñɨndɨñ nɨ-kañguk, ‘Wɨ nek indalak?’ ");
INSERT INTO nif_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Eumbi nɨñguk, ‘Kwayañga mona ip bɨk patak. Tɨmbi pɨñgɨu gwɨlap no nɨm kolañgukta besettɨ eumbi, makauk nɨñañ kɨttɨ towium bendɨ wopum dañguk wɨn wɨpi, nanañ si-na tamɨñ.’ Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","tualɨ wala nandu pɨumbi, gɨnañ komba dɨumbi, it gɨnañnan nɨm lololok gɨñgɨneñguk. Tɨmbi beulɨ pɨmbi, tualoñ ñambi, nɨ-busumbusuk tɨ-ñɨmbi, it gɨnañ louktok nɨ-nandɨñɨpi nɨ-gɨñgɨneñguk. ");
INSERT INTO nif_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gan tualɨ tambane nɨñguk, ‘Nandɨlañ. Gwɨlat asupgan ñɨn nak kena gwañgwa sɨlanin nomɨk kena tɨ-gam-ta-bɨmbi, mandañga no nɨm wɨkut, ganmek dɨk notnai gɨt sɨlɨsɨlɨ tɨneñdok meme nɨñañ kambak no nɨm namguñ. ");
INSERT INTO nif_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Gan nɨñañga mona ñalɨ tam telak joñgo kuañ en gɨta kumbi, mɨnemga na-taleñguk en wandin walɨ bɨumbi, dɨk eumbi, makauk nɨñañ kɨttɨ towium bendɨ wopum dañguk wɨn dombɨmbi si-ñɨmañ.’ ");
INSERT INTO nif_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Eumbi, beulɨ nɨñguk, ‘Nɨñana, dɨk nepek nola nɨm lonjɨlañ. Nain tuop dɨk noñganlɨ nakɨta kulañ, tɨmbi nepenepek gɨtɨk pat-namlak wɨn dɨkok gɨñgɨt. ");
INSERT INTO nif_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kwayañga ñɨn endɨ kɨmguk ba paikuknan nanin nombo bɨ indambi kaik patak. Nɨtekta walenɨ nɨm kɨndem daumbi, na sɨlɨsɨlɨ nɨm tɨneñ?’” ");
INSERT INTO nif_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tɨmbi Yesulɨ gwañgwañiila eyout manda no ñɨndɨñ enguk, “Ama kwɨlɨkwɨlɨ wopummat nolɨ mɨnem kwɨlɨkwɨlɨ kena aman nolok kiinan ka-dɨkñeuktok kɨmɨt-talembi kuñguk. Kuumbi, nain nola ama dɨwɨndɨ kandɨkñelok plon kɨt yout manda ñɨndɨñ nɨñgɨlɨñ, ‘Endɨ nepenepeka ep tɨmbɨ pailektok tɨlak.’ Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","kandɨkñe kɨtɨ-ñɨmɨum bɨumbi nɨñguk, ‘Dɨkok plon manda eum nandɨt wɨn nɨtek? Dɨk kandɨkñe kena nombo tɨ-nameñdok tuop nɨm, wala tɨmbi yout sambat tɨmbɨmbi, mɨnem kwɨlɨkwɨlɨlok kusei dakleun.’ ");
INSERT INTO nif_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Tɨmbi kandɨkñelɨ gɨnan gɨnañ ñɨndɨñ nandɨñguk, ‘Molomnalɨ kandɨkñe kena napma tɨkelak, wala tɨmbi nak nɨtek tɨmbetat? Neta, nak kwet dɨplindɨplilok gembɨ no nɨm pat-namlakta, tɨmbi mɨnem kwɨlɨkwɨlɨ kɨtɨnatta maetalet. ");
INSERT INTO nif_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O, kombɨkmek nandɨlet! Tɨkap nak man wɨndɨñ wɨndɨñ tɨmbetta, molomnalɨ kenala nep kleukak, wolondamek amalɨ not tɨ-nambi, isɨnan gumañ nanɨ-tiañenelɨñ bek.’ ");
INSERT INTO nif_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Wɨndɨñ embi, molomñɨlok tombon tɨke-kuñgɨlɨñ noñgan noñgan kɨtɨ-semum bɨumbi, nola nɨ-kañbi eñguk, ‘Molomnalok tombon dɨkok kandañ nɨtek patak?’ ");
INSERT INTO nif_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Eumbi nɨñguk, ‘Oliv komba tul wɨn wɨlɨ gɨlo tɨndɨn wɨn kwet kambot 100 wolok tuop.’ Eumbi ñɨndɨñ nɨñguk, ‘Ale, dɨk tambon ombeñdok kundit youkuñ ñɨn tɨkembi, platik sɨnɨk pipapi, tambon 50 ombeñdok yout.’ ");
INSERT INTO nif_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wɨndɨñ embi, no nɨ-nandɨmbi eñguk, ‘Molomnalok tombon dɨkok kandañ nɨtek patak?’ Eumbi nɨñguk, ‘Plaua mɨnjɨp kɨmɨka tɨndɨn wɨn lɨk 100 wolok tuop.’ Eumbi nɨñguk, ‘Ale, dɨk tambon ombeñdok kundit youkuñ ñɨn tɨkembi, tambon 80 ombeñdok yout.’ Kandɨkñelɨ wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kwelalok nepektok kandañ ama kwet ñolok gɨñgɨt kuañ endɨ siñginjɨ tɨke-kɨmɨtnelɨñdok kundit tɨ-kɨndem dambi, ama Yambattok kolsalen gɨnañ kuañ wɨn yapma kleañ, wala tɨmbi molomlɨ kandɨkñe kelamdɨ nɨtek tɨñguk wɨn nandɨ-tombi, ñɨndɨñ eñguk, ‘Ama walɨ enlok siñgin tɨke-kɨmɨlektok kundit tɨ-kɨndem dañguk.’” ");
INSERT INTO nif_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yesulɨ eyout manda wɨndɨñ embi yousɨmbi enguk, “Nak ñɨndɨñ sanba: sɨndɨ wɨndɨñgangot kwelalok mɨnem kwɨlɨkwɨlɨ pat-samlak walɨ amatam not tɨ-sembi, ep kɨmɨtnekalɨñ. Wɨndɨñ tɨnekalɨñda, kwelalok nepenepek gɨtɨk kena mɨ-taleumek, kuñgu taletalen nɨmnatnan sanɨ-tiañeum lonekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","No en nepek sɨlanin kiinan kɨmɨlɨm patak wɨn ka-dɨkñe-kɨliñ elak walɨ wakan nepek bien wopum wɨndɨñgangot ka-dɨkñe-kɨliñ elak. Ba no en nepek sɨlanin kiinan kɨmɨlɨm patak wɨn dɨndɨmgan nɨm ka-dɨkñelak walɨ wakan nepek bien wopum wɨndɨñgangot dɨndɨmgan nɨm ka-dɨkñe-kɨliñ elak. ");
INSERT INTO nif_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wɨndɨñda tɨkap sɨndɨ kwelalok mɨnem kwɨlɨkwɨlɨ sɨlanin wɨn nɨm ka-dɨkñe-kɨliñ eñgɨlɨñda, nindɨ nepek Yambattok dainan biennat wɨn sɨndok kɨsɨnan ka-dɨkñenelɨñdok kɨmɨlekak? No nɨm. ");
INSERT INTO nif_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ba tɨkap sɨndɨ ama nolok nepek kɨsɨnan kɨmɨkuk wɨn nɨm ka-dɨkñe-kɨliñ eñgɨlɨñda, nindɨ nepek no sɨnlok pat-samektok samekak? Wɨn bo nɨm. ");
INSERT INTO nif_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kena gwañgwa sɨlanin endɨ molomñiit tɨpet endok kena tɨ-semektok tuop nɨm. Wɨndɨñ tɨmbekta, endɨ molomñɨn nola nandum pɨmbɨñen tɨmbɨmbi, nandɨ-kunjit tɨ-ñɨmek, tɨmbi molomñɨn no wɨn gɨnañlɨ kasɨlembi, tɨke-kwambɨñ dauk. Wɨndɨñgangot sɨndɨ Yambat ba mɨnem kwɨlɨkwɨlɨlok kena tɨpelatkan tɨ-kunelɨñdok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falisi ama mɨnem kwɨlɨkwɨlɨlok nandɨ-koñgom tɨañgɨlɨñ endɨ Yesulɨ manda wolok plon eu pɨumbi nandɨñɨpi, tima giak tɨ-ñɨmɨmbi, nɨ-sasale manda eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tɨmbi Yesulɨ enguk, “Sɨndɨ amatamdok dausɨnan dɨndɨm walan pa tañ, gan Yambattɨ gɨnañ nanandɨnjɨ nɨtein wɨn sambɨ-dakle-talembi, kusei ñɨndɨñda nandum tuop nɨm tɨ-samlak: nepek amalɨ nandum loloñ sɨnɨk tɨlak walɨ Yambattok dainan kolan papait sɨnɨk pa tɨlak. ");
INSERT INTO nif_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yoane tuk ii-sem endɨ gama nɨm indañɨlɨmbi, Moselok endɨkñe manda gɨta plofet amalɨ manda youkɨlɨñ wɨn eu pɨumbi, amatamdɨ kɨmɨt-kleñgɨlɨñ. Tɨmbi Yoanelɨ indañguk wolok siñgi kandañ Yambattɨ amatam nɨtek yambɨ-dɨkñelak wolok gɨñgɨt manda kɨndem eu pɨumbi, amatamdɨ endok gɨñgɨt indanelɨñdok gembɨ kokañ. ");
INSERT INTO nif_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gan endɨkñe manda gɨtɨktɨ gama papat kwambɨñ pakañ. Kunum kwet endɨ kɨndem paitekamɨk, gan endɨkñe manda endɨla lakat sɨnɨk no nɨm paitnekalɨñ. Nɨm sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Wɨndɨñda no en tamɨn kle-kopi, komblin tɨkelak, endɨ Yambattok dainan telak joñgo kulak, tɨmbi no en tam kle-kokolɨn no tɨkelak, endɨ wɨndɨñgangot telak joñgo kulak.” ");
INSERT INTO nif_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Tɨmbi Yesulɨ kasat no ñɨndɨñ tɨ-semguk, “Ama mɨnem kwɨlɨkwɨlɨlɨ wopumnat no kuñguk. Endɨ dasindasin pamanat tuan wopum pa dasimbi, sandap tuop nanañ sina wopum pa tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Endok telak yamanan ama pɨmbɨñen no kɨmɨlɨm pakuk, koi Lasalos. Wandalɨ endok pɨñgɨu gwɨlap gɨtɨk tɨmbɨ kolaumbi, ");
INSERT INTO nif_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","nanañla papi, ama kwɨlɨkwɨlɨnattok ilɨ gɨnañ nanañ na-tlapi, tɨ na gɨlam gɨnañ mep kokañ wɨn nambepi nandɨlɨñguk. Tɨmbi wɨndɨñgot nɨm. Kamottɨ bo bɨmbi, wandan bɨndaañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tɨmbi wɨnaña ama pɨmbɨñen endɨ sembumbi, eñalolɨ gɨnan tip nañgɨt-lombi, endok pañɨn Ablaam gɨta kɨmɨlɨm pakuk. Tɨmbi ama kwɨlɨkwɨlɨnat endɨ bo sembumbi kɨndit tapliñgɨlɨñ. Kɨndit taplimbi, ");
INSERT INTO nif_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","kolandok gɨñgɨt tɨmbi, pɨñgɨp gawat wopum nandɨ pakuk. Papi, deium loumbi, Ablaamdɨ Lasalos gɨta yakan mayañgan sɨnɨk palɨmbi yambɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yambɨmbi, kɨtɨu loumbi nɨñguk, ‘Bep pañ Ablaam! Nak komba galk ñolok gɨnañ papi, pɨñgɨp gawat wopum nandɨlet. Dɨk blan nandɨ-nambi, Lasalos nɨ-mulɨmbi, kii nɨñañ kusiptɨ tuk gɨnañ youp bɨmbi, mambena plon kɨmɨlɨm busukñenewɨn.’ ");
INSERT INTO nif_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Gan Ablaamdɨ tambane nɨñguk, ‘Nɨñana, dɨk nɨm nandɨ-kamalaukañ: sɨtɨ dama kaik pakɨmɨknan dɨk pipapat kɨndem kasɨle-taleñguñ, tɨmbi Lasaloslɨ nepek kolan kusei kusei inda-ñɨmɨumbi, blan plon pakuk. Gan man ñɨn endɨ ñolok busuk plon patak, tɨmbi dɨk pɨñgɨp gawat wopum nandɨlañ. ");
INSERT INTO nif_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Tɨmbi wɨngot nɨm. Masimasip no kɨmɨkɨmɨlɨn, wɨn kwet jambɨlan nɨndok ba sɨndok boñgɨpnɨnan patak, tɨmbi nɨndoñnan ba sɨndoñnan nanin nolɨ wɨn dɨkñembi, tambo ñaneñdok tuop nɨm.’ ");
INSERT INTO nif_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ablaamdɨ wɨndɨñ eumbi, ama walɨ nombo kɨtɨ-nandɨmbi nɨñguk, ‘Bep. Wɨndɨñda dɨk kɨndem Lasalos nɨ-mulɨmbi, bepnalok ilan ñambi, ");
INSERT INTO nif_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kwayanai kɨt tambon pakañ wɨn molo manda enbɨmbi, endɨ kuñgunjɨ tɨ-dɨndɨm ewɨt. Nɨm kañbi, endɨ bo kwet kolan ñolokgan pɨmbi, pɨñgɨp gawat wopum nandɨnelɨñ a!’ ");
INSERT INTO nif_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eumbi nɨñguk, ‘Neta Lasaloslɨ ñauktok elañ? Kwayañgailɨ Mose gɨt plofet amalɨ manda youyoulɨn wɨn gɨtɨk pat-semlak. Manda wɨn wakan nandɨmbi kɨmɨt-klenekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Eumbi, ama walɨ Ablaamda nɨmbi eñguk, ‘Bep. Wɨn tuop nɨm. Gan ama sembɨsembɨn nolɨ endoñ ñaukta, gɨnañjɨ kɨndem tambanenekalɨñ.’ ");
INSERT INTO nif_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eumbi nɨñguk, ‘Tɨkap endɨ Mose gɨt plofet ama endok mandanjɨ nandɨ-kɨmneyañda, ama nolɨ kɨmnan nanin mɨlapi, molo manda enbɨm, walɨ bo nɨm dakle-semek.’” ");
INSERT INTO nif_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tɨmbi Yesulɨ gwañgwañiila ñɨndɨñ enguk, “Nepek kusei kuseilɨ mek amatamda inda-sembi, ep tiañeum yom tañ. Gan ama kusei nindɨ tɨ-kuyuk plon enɨ-tiañelak endɨ blangan. ");
INSERT INTO nif_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kawat wopum no ama wolok bim plon tembɨmbi, tuk kimbɨñ gɨnañ youp munjup kolɨm pɨwɨk walɨ mɨlap, gan tɨkap endɨ gɨñgɨtna koi nɨmnat ñandin no tɨmbɨm yom plon pipɨlakta, Yambattɨ kɨnjan mɨlap wopum ombɨ-mɨumbi, mɨlata-sɨnɨk taukak. ");
INSERT INTO nif_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wala tɨmbi kuñgunjɨ ka-kɨliñ enekalɨñ. Tɨkap noka nolɨ yom tɨlakta, ep tɨndɨn kolan wɨn biuktok manda kwambɨñ nɨmbekañ, tɨmbi yomɨnla nandum blalaumbi, siñgi wɨtakta, yomɨn bi-ñɨmekañ. ");
INSERT INTO nif_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tɨmbi endɨ sandap noñgan gɨnañ nain asup yom tɨ-gamek, tɨmbi nombo nain nɨtek yom tɨ-gamguk tuop ñɨndɨñ ganbek, ‘Nak yomnala nandɨwam blalaumbi, siñgi wɨtet’ eumbi, dɨk yomɨn bi-ñɨmekañ.” ");
INSERT INTO nif_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Tɨmbi ama enɨ-mumulɨn endɨ Wopumda ñɨndɨñ nɨñgɨlɨñ, “Dɨk nanandɨ-kɨlɨktɨnɨ tɨmbɨ wopum da-nɨmɨn.” ");
INSERT INTO nif_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Eumbi tambane enguk, “Tɨkap nanandɨ-kɨlɨktɨnjɨ lakat mastat mɨnjɨp nomɨk pat-samekta, kɨndem komba kakai sakñen ñala ñɨndɨñ nɨnelɨñ, ‘Dɨk kakatka tamapi ñam, tuk kimbɨñ gɨnañ pɨmbi, tɨpi kwambɨñ da!’ Wɨndɨñ nɨmbɨmbi, komba walɨ wolongan mandanjɨ tañgonewɨk.” ");
INSERT INTO nif_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Tɨmbi Yesulɨ yousɨmbi enguk, “Tɨkap kena gwañgwa sɨlanin no nanañ kena ba sipsip yambɨ-dɨkñe kena tɨ-samekta, kena gɨnañ nanin undane ilan bɨumbi, sɨndoñnan nanin nolɨ ‘Platik sɨnɨk bɨmbi, nanañga ñɨn na!’ wɨndɨñ nɨmbek ba? ");
INSERT INTO nif_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nɨm ya. Tambo endɨ ñɨndɨñ nɨmbek, ‘Dɨk nanañ tɨ-jumut tɨ-nambi, dasindasiñga tɨ-dɨndɨm tɨmbi, nanañ tuk mep bɨ kle-namum nambamek, dɨtnalok siñgimek kle na.’ ");
INSERT INTO nif_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Tɨmbi kena gwañgwalɨ molomdok mandan tañgoneumbi, molomdɨ nɨ-kɨndem dawɨk ba? Nɨm ya. ");
INSERT INTO nif_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wala tɨmbi sɨndɨ wɨndɨñgangot nepek Molomjɨlɨ manda sanguk wɨn gɨtɨk tañgone-taleañda, ñɨndɨñ enekalɨñ, ‘Nɨndɨ kena gwañgwa ñandin ñalɨ kenanɨñgot tɨñgɨmɨñ, nɨnda nɨnɨ-kɨndem dalok tuop nɨm.’” ");
INSERT INTO nif_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tɨmbi Yesulɨ gwañgwañii gɨt Jelusalem ñaupi, kwet tɨpet, Samalia gɨt Galili, wolok baliliñjetnan klembi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ñambi, it kwet nolok loup tɨñɨlɨmbi, ama kɨt tambon tambon endɨ ña Yesu tɨmbɨ dumalañgɨlɨñ. Endɨ jɨmbat yambo mawatsɨat, amatamdɨ yambɨ-mɨsɨmɨsɨ taañgɨlɨñda tɨmbi mayañgan ipi ");
INSERT INTO nif_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kɨtɨ-ñɨmɨmbi nɨñgɨlɨñ, “Yesu, ama wopum, dɨk blan tɨ-nɨmbi nandɨ-nɨmɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wɨndɨñ kɨtɨumbi yambɨmbi, Moselok endɨkñe manda klenelɨñdok embi enguk, “Sɨndɨ gwɨlapsɨ tapma amala daut semnepi ñawɨt!” Wɨndɨñ eumbi ñañɨlɨmbi, wolongan wandanjɨ gɨlɨtañguk. ");
INSERT INTO nif_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tɨmbi gwɨlapsɨ kaum kɨndem daumbi, endoñnan nanin nolɨ nolii yambimbi, Yambat wopumgan nɨ-ta-lo tɨñɨpi, Yesuloñ undane bɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ama wɨn endɨ Juda ama nɨm, endɨ Samalia nanin. Endɨ Yesulok kesiinan bɨ pi pɨmbi, kwet plon pɨndɨm papi, sɨmba kɨndemda manda nɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Eumbi, Yesulɨ amatam en gɨta pakɨlɨñ ñɨndɨñ enguk, “Nak ama kɨt tambon tambon ep tɨmba kɨndem dalɨñ bek, gañgan ama kɨt tambon tɨpet tɨpet endɨ delok pakañ? ");
INSERT INTO nif_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Nɨtekta tɨmbi ama sambat nolok ñalɨ engangot undane bɨmbi, Yambat koi gɨñgɨt mɨlak?” ");
INSERT INTO nif_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wɨndɨñ embi nɨñguk, “Nanandɨ-kɨlɨktɨñgalɨ gep tɨmbɨ kɨndem dalañ. Kɨndem a, mɨlapi ñau!” ");
INSERT INTO nif_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","21","Yambattɨ dawanda kusei kɨmɨpi, amatam indañgan yambɨ-dɨkñeukak wala Falisi amalɨ Yesu nɨ-nandumbi, ñɨndɨñ tambane enguk, “Endɨ ikan boñgɨpsɨnan papi sambɨ-dɨkñelak, wala tɨmbi sɨndɨ nepek wolok kusei kɨmɨkɨmɨt wɨn dausɨlɨ kanelɨñdok tuop nɨm, ba amalɨ nosiila ñɨndɨñ nɨm enɨnekalɨñ, ‘Yakñesɨ, endɨ ñolok patak’ ba ‘Da patak’.” ");
INSERT INTO nif_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wɨndɨñ embi yousɨmbi, gwañgwañiila enguk, “Mɨlap nain indaukak wolonda sɨndɨ Ama Sɨsɨnɨk nak nain dumangangot nambɨnepi nandɨ-koñgom tɨnekalɨñ, gan nɨm nambɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Tɨmbi dɨwɨndɨ naka ‘En ñandɨñ patak’ ba ‘Wandɨñ patak’ wɨndɨñ sanɨnekalɨñ, gan sɨndɨ nandɨ-kɨmnembi, nɨm woñepi ep klenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kusei ñɨndɨñda: pɨsapɨsattɨ bayak eumbi, kunum kwet kusei kɨmɨkɨmɨlɨnan nanin ñam taleñguknan sale-talelak, wɨndɨñgangot Ama Sɨsɨnɨk nokok nainna indaumbi, indañgan tombetat. ");
INSERT INTO nif_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gan dama nak pɨñgɨp gawat ba mɨlap kusei kusei bemambi, amatam man ñɨndɨñgɨt kuañ endɨ siñgi wɨt-namnekalɨñ. Wɨndɨñ inda-namektok een. ");
INSERT INTO nif_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Amatamdɨ Noalok nainnan tuk gwam wopum gama nɨm indañɨlɨmbi nɨtek kuñgɨlɨñ, wɨndɨñgangot endɨ nak Ama Sɨsɨnɨk gama nɨm tomñɨlambi kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Endɨ nanañ tuk nambi, wapatam tɨñɨlɨmbi, Noalɨ kɨkeñ gɨnañ loñguk wolok tuop. Tɨmbi tuk gwam wopumdɨ suam ep walaimbi, yandɨp kɨm-taleñguk. ");
INSERT INTO nif_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lotilok nainnan wɨndɨñgangot indañguk: amatamdɨ nanañ tuk nayañgɨlɨñ, ba nepenepek tuatua kena ba nanañ kena ba it kɨndikɨndit kena pa taañgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","gan Lotilɨ Sodom it kwet biñguk sandap wolonda komba gɨt kawat kombanat kunum gɨnañ nanin gwi nomɨk pɨm yandɨpbi, ep dɨumbi kɨm-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Noa ba Lotilok nainnan mɨlaptɨ amatam kaikan inda-semguk, wɨndɨñgangot nak Ama Sɨsɨnɨktɨ tombi inda-dakleutatnan mɨlaptɨ inda-semekak. ");
INSERT INTO nif_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Sandap wolonda isɨ pawan ba kenanjɨ gɨnañ pakañ enda ñɨndɨñ tɨnelɨñdok nak elet: endɨ nepenepesɨ mep ñanelɨñdok isɨ gɨnañ nɨm lonekalɨñ ba undane isɨnan nɨm ñanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loti tamɨnloñ mɨlap inda-ñɨmɨñguk wɨn sɨndɨ nɨm nandɨ-kamalanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","No en kwelalok kuñgun enlok tɨke kamaiuktok gembɨ kotakta, kunumdok kuñgun pailɨmekak. Tɨmbi no en naka tɨmbi kwelalok kuñgun bilakta, kunumdok kuñgun walɨ palmekak. ");
INSERT INTO nif_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nak ñɨndɨñ sanlet: nain wolonda amatam tɨpettɨ tim ipat noñgan plon dou palɨmbi, no matɨkembi, no bium palekak. ");
INSERT INTO nif_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Tɨmbi tam tɨpet endɨ yakan nanañ mɨndɨ palɨñɨlɨmbi, no matɨkembi, no bium palekak.” ");
INSERT INTO nif_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Tɨmbi gwañgwañiilɨ nɨ-nandɨmbi eñgɨlɨñ, “Wopum, wɨn dendɨñ indaukak?” Eumbi, eyout manda no ñɨndɨñ enbi eñguk, “Nepek kɨmɨkɨmɨn pataknan monɨk oeoelɨ kɨmɨn tɨmbɨmbi, nepek delok patak wɨn inda-daklelak.” ");
INSERT INTO nif_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Tɨmbi gwañgwañiilɨ nain tuop nɨmolo tɨmbi gɨñgɨnembi, nɨm nandɨ-mɨlatanelɨñdok Yesulɨ eyout manda no ñɨndɨñ enbi ");
INSERT INTO nif_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","eñguk, “It kwet nolok manda kandan ama no kuñguk. Endɨ amala nɨm nandɨ-semlɨñguk, ba Yambatta bo giñgiñgan nɨm tɨ-ñɨmlɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tɨmbi it kwet wolok tam kanjak no kuñguk endɨ manda kandanloñ nain nain bɨmbi, ñɨndɨñ nɨlɨñguk, ‘Dɨk nandɨ-nambi, kanjɨkna nɨ-gɨñgɨneumbi, tambonna endok kandañ patak wɨn ombɨ-namekak.’ ");
INSERT INTO nif_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Wɨndɨñ eumbi, kandanlɨ nandɨ-kɨmnembi kulɨñguk. Kukapi, siñgimek enla ñɨndɨñ eñguk, ‘Nak ama nɨm nandɨ-semlet, ba Yambatta bo giñgiñgan nɨm tɨ-ñɨmlet. ");
INSERT INTO nif_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Gan wandingan embi, tam kanjak ñalɨ nain nain mɨlap ñɨn pa namlakta tɨmbi nak joñgo tɨke-kɨmɨlambi, tambon kak tɨkeukak. Nɨm kañbi, nain tuop gɨñgɨne bɨumbi jɨklotaut.’” ");
INSERT INTO nif_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Wopumdɨ eyout manda wɨndɨñ tɨ-sembi, gwañgwañiila enguk, “Sɨndɨ kandan ama kelamdɨ nek eñguk wɨn nandañ ba? Endɨ tam gɨñgɨnen wɨn tɨke-kɨmɨlepi eñguk. ");
INSERT INTO nif_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tɨmbi Yambattɨ amatam enlok ep kasɨleñguk wɨn nek tɨ-semekak? Endɨ gɨñgɨtñiilɨ tim sandap kɨtɨ-ñɨmañ wɨn nain ombapgan nandɨ-kɨmnembi, nɨm ep kɨmɨlek ba? Nɨm ya. ");
INSERT INTO nif_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nak ñɨndɨñ sanlet: nain nɨm ombataumbi, platik sɨnɨk ep kɨmɨlekak. Gan nak Ama Sɨsɨnɨktɨ bɨ tommek, nak wolonda amatam nanandɨ-kɨlɨktɨnjɨat dɨwɨn kwelan ep tɨmba indanekalɨñ ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tɨmbi Yesulɨ yousɨmbi, eyout manda no eñguk, wɨn ama endɨ dɨndɨm wɨndɨñ nandɨ-kwambɨñ dambi, dɨwɨnda nandum pɨmbɨñen tɨlak ama wandisɨ wala ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Nain nola ama tɨpet, wɨn Falisi ama no, tɨmbi takis epep ama no, endɨ nɨmolo tɨndepi tapma it gɨnañ loñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falisi ama endɨ lom ipi, gɨnan gɨnañ enla ñɨndɨñ nɨmolo tɨmbi eñguk, ‘Yambat. Ama dɨwɨn gɨtɨk endɨ mɨnem tiatia telak juluñgan kɨmɨt-kleañ, ba kundit kelam tañ, ba telak joñgo pa kuañ. Gan nak endɨ wandin nɨm, ba takis epep ama da patak en wandin bo nɨm, wala tɨmbi sɨmba kɨndemda manda ganlet. ");
INSERT INTO nif_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Sande noñgan gɨnañ nak sandap tɨpet endɨkñe manda klembi, nanañ gɨtɨk kɨmɨsipbi patet, ba nepenepek gɨtɨk epmɨlet wɨn kɨt tambon tambon tambɨpi, noñgan wɨn dɨkok pa gamlet.’ ");
INSERT INTO nif_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gan takis epep ama endɨ mayañgan sɨnɨk ipi, kunum gɨnañ deium lolola mɨsɨmbi, yomɨnlok sɨmba gawat tɨñɨpi, kuañ wɨpi, ñɨndɨñ nɨñguk, ‘Yambat. Nak ama yomat, dɨk mamasa tɨ-namɨñ.’” ");
INSERT INTO nif_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesulɨ eyout manda wɨn tɨ-sem-talembi enguk, “Nak ñɨndɨñ sanlet: ama ñalɨ Yambattok dainan dɨndɨm indambi, ilnan ñañguk, Falisi ama endɨla nɨm. Neta, ama gɨtɨk nɨsɨlok kosɨ gɨñgɨt tɨke-loañda Yambattɨ ep tɨke-pɨlak, gan no en kayombɨnelakta en Yambattɨ tɨke-lolak.” ");
INSERT INTO nif_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tɨmbi amatamdɨ Yesulɨ ñakñak bo ep kauptok nandɨmbi, endoñ yanañgɨpi bɨñgɨlɨñ. Bɨumbi, gwañgwañiilɨ yambɨmbi enombɨmbi enɨ-kɨmɨsip tɨ-semgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","gan Yesulɨ kɨtɨ-semum bɨumbi, gwañgwañiila enbi eñguk, “Wɨn ama ñandisɨ ñala wakan Yambattɨ enlok gɨñgɨtñii yambɨ-dɨkñelak, wala tɨmbi gwañgwa bɨsat yambiumbi nokoñ bɨwɨt. Telak masip nɨm tɨ-semnelɨñ. ");
INSERT INTO nif_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nak biañgan sanlet: no en Yambattok kapmainan gwañgwa bɨsat nomɨk nɨm kuup nandɨlakta, endɨ endok gɨñgɨt nɨm indaukak. Nɨm sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Tɨmbi Judalok telak dama nolɨ Yesula ñɨndɨñ nɨñguk, “Endaut kɨndem, nak kuñgu taletalen nɨmnat kasɨleuttok ep tɨndɨn nɨtek kleut?” ");
INSERT INTO nif_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Eumbi nɨñguk, “Nekta naka kɨndem nanlañ? Yambat en noñganlɨñgot kɨndem sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Dɨk endɨkñe manda ip nandɨ-talelañ: dɨk ama nolok tamɨn gɨta joñgo nɨm kundekamɨk, dɨk ama wɨlɨ kɨm nɨm tɨmbekañ, ba kumbu nɨm tɨmbekañ, ba ama nolok siñgin joñgo nɨm siukañ, tɨmbi meñga bekala giñgiñgan tɨ-sem-ta-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wɨndɨñ eumbi nɨñguk, “Manda elañ wɨn gɨtɨk nak ikan tip plongan kusei kɨmɨpi, tañgonem tɨ-ta-bɨlet.” ");
INSERT INTO nif_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesulɨ manda wɨn nandɨmbi, ñɨndɨñ nɨñguk, “Kɨndem, gan nepek noñgangot gama tɨmbeñdok patak wɨn ñɨndɨñ: dɨk nepenepek gɨtɨk pakamlak wɨn tualok kɨmɨlɨm tua-taleumbi, mɨnem wɨn danbi, ama pɨmbɨñesɨla emekañ. Wɨndɨñ tɨmbeñda, tambon tuañga wopum kunum gɨnañ pakamekak. Ale, wɨndɨñ tɨmbɨ taleumbi, bɨm nak nep kle-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wɨndɨñ eu nandɨmbi, mɨnem kwɨlɨkwɨlɨn asup sɨnɨk palmɨñgukta tɨmbi gɨnan mɨlatañguk. ");
INSERT INTO nif_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesulɨ wɨn kañbi enguk, “Ama mɨnem kwɨlɨkwɨlɨnjɨat Yambattok gɨñgɨt indanelɨñdok nandañ endɨ gliñgliñnat. ");
INSERT INTO nif_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamel nolɨ lɨk bemdok gɨnañ mɨnam wolok ña tombep nandumda endɨ gliñgliñ tɨmbek. Gan ama kwɨlɨkwɨlɨ wopumnat nolɨ Yambattok gɨñgɨt indambi, endok kapmainan kuup nandɨlakta endɨ gliñgliñ wopum sɨnɨk tɨmbek.” ");
INSERT INTO nif_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Wɨndɨñ eumbi, manda nandɨñgɨlɨñ endɨ ñɨndɨñ eñgɨlɨñ, “Ei, tɨkap wɨndɨñda, ama nolɨ kuñgu taletalen nɨmnat kasɨleuptok tuop no nɨm patak!” ");
INSERT INTO nif_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tɨmbi Yesulɨ enguk, “Nepek no amalɨ tɨmbektok tuop nɨm wɨn Yambattɨ tuop tɨ-talewɨk.” ");
INSERT INTO nif_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tɨmbi Petlolɨ nɨñguk, “Nɨndok kandañ bo nɨtek? Nɨndɨ nepenepet ba gɨñgɨtnii gɨtɨk pat-nɨmañ wɨn yambi-talembi, dɨk gep kle-kuamɨñ wɨn!” ");
INSERT INTO nif_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Eumbi enguk, “Nak biañgan sɨnɨk sanba nandɨwɨt: ama gɨtɨk Yambattok gɨñgɨt indam kunelɨñdok isɨ ba tamjii ba dasɨ kwayañjii ba menjɨ bepsɨ ba gwañgwanjɨ bɨsat yambi-taleañ endok kandañ wɨn ñɨndɨñ: ");
INSERT INTO nif_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","endɨ gɨñgɨtsii yambiñgɨlɨñ wolok kɨnjan kwelangan yousɨ-semum kasɨlenekalɨñ, tɨmbi gɨñgɨtsii komblin walɨ gɨñgɨtsii damanin wɨn yapma klelak. Tɨmbi nain gamañda indaukaknan endɨ kuñgu taletalen nɨmnat kasɨlenekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesulɨ gwañgwañii 12 walɨ nɨsɨñgan patnelɨñdok yanañgɨpi, ñɨndɨñ enguk, “Nandañ: nɨndɨ Jelusalem ñaneñdok ñamɨñ, tɨmbi wolok plofet amalɨ Ama Sɨsɨnɨk nokok plon manda gɨtɨk youyoulɨn wolok tuopkan indaukak. ");
INSERT INTO nif_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Juda amalɨ ama sambat nolok kɨsɨnan napɨlɨmbi, endɨ nanɨ-lakalaka embi, kolan tɨ-nambi, iwɨttɨ nep suambi, ");
INSERT INTO nif_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kolan sɨnɨk nep waipbi, nulɨm kɨmbetat. Tɨmbi maim tɨpet gɨt no ñaumbi, bɨndambo kɨmnan nanin kaitambi mɨlaletat.” ");
INSERT INTO nif_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesulɨ wɨndɨñ eñguk, gan gwañgwañiilɨ nek inda-ñɨmekak wɨn nɨm nandɨ-dakleñgɨlɨñ. Manda wolok kusei kɨmɨsembɨ-semum pakukta tɨmbi endɨ wɨn nɨm nandɨ-kɨliñ eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesulɨ Jeliko it kwet tɨmbɨ dumalaumbi, ama dai sisipmɨn no telak pawan pipapi, kɨtɨnat tɨ pakuk. ");
INSERT INTO nif_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Papi, amatam asup makleum nandɨmbi, enɨ-nandɨmbi eñguk, “Ñɨn nek tañ?” ");
INSERT INTO nif_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Eumbi nɨñgɨlɨñ, “Yesu Nasalet nanin endɨ bɨlak.” Wɨndɨñ eumbi ");
INSERT INTO nif_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","kɨtɨ-ñɨmɨmbi eñguk, “Yesu, Devittok Komblin, dɨk naka gɨnañ busuk tɨ-namɨñ!” Wɨndɨñ kɨtɨumbi, ");
INSERT INTO nif_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","telak dama tɨñgɨlɨñdɨ nɨ-ñombɨmbi eñgɨlɨñ, “Ei, gitak pat!”, gan ama walɨ wopumgan kɨtɨmbi eñguk, “Devittok Komblin-o, dɨk naka gɨnañ busuk tɨ-namɨñ!” ");
INSERT INTO nif_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tɨmbi Yesulɨ wɨñgan bɨ ipi, ama wɨn nañgɨpi endoñ bɨnelɨñdok eumbi, nañgɨp ñasɨñgan bɨumbi nɨ-nandɨmbi eñguk, ");
INSERT INTO nif_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nak nek tɨ-gamettok nandɨlañ?” Eumbi nɨñguk, “Wopum, nak bɨndambo daut deiuptok nandɨlet.” ");
INSERT INTO nif_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Wɨndɨñ eumbi, Yesulɨ nɨñguk, “Wɨndɨñda bɨndambo dei! Nanandɨ-kɨlɨktɨñgalɨ gep tɨmbɨ kɨndem dalañ.” ");
INSERT INTO nif_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Wɨndɨñ eumbi, wolongan dai tombɨm deimbi, Yesu klembi, Yambatta kot gɨñgɨt mɨñguk. Tɨmbi amatamdɨ kundit wɨn kañgɨlɨñ endɨ bo Yambat nɨ-ta-lo tɨñgɨlɨ ñ. ");
INSERT INTO nif_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tɨmbi Yesulɨ Jeliko it kwelan tombi, dɨkñe ñaupi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","It kwet wandɨñ ama no kuñguk, koi Sakius. Endɨ takis epep amalok telak damanjɨ no, en mɨnem kwɨlɨkwɨlɨ wopum palmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Endɨ Yesu kauptok nandɨ-koñgom tɨñguk, gan endɨ ama dumanda tɨmbi ama kɨmɨn gɨtɨktɨ masimasip tɨ-ñɨmɨumbi, kauktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Wɨndɨñda endɨ yapma klembi, dama woñep ñambi, komba endɨ lololok tuop nolok plon lombi, “Yesulɨ telak ñolok bɨutak” wɨndɨñ nandɨmbi, kauktok mandɨ pakuk. ");
INSERT INTO nif_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Tɨmbi Yesulɨ kwet wolok ña tombi, deium loumbi, Sakius kañbi nɨñguk, “Sakius. Platit pɨ! Nak man ñɨn dɨkok ilan ñam palettok elet.” ");
INSERT INTO nif_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Eumbi nandɨmbi, platit sɨnɨk pɨmbi, Yesu sɨlɨsɨlɨnat ilnan nɨ-tiañeumbi loñguk. ");
INSERT INTO nif_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tɨmbi amatam wɨ kañgɨlɨñ endɨ gɨtɨk kusei kɨmɨpi, e-balep tɨmbi eñgɨlɨñ, “Endɨ yom amalok ilan pap dowepi loñak.” ");
INSERT INTO nif_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Gan Sakiuslɨ mɨlap ipi, Wopum ñɨndɨñ nɨñguk, “Wopum, nak ñɨndɨñ tɨmbep nandɨlet: nak nepenepetna tambɨpi, tambon ama pɨmbɨñesɨla emetat. Ba nak nimbek nolok nepenepesɨ juluñ tɨmbi epgutta, nak bɨndambo nain tɨpet tɨpet ombɨ-semetat.” ");
INSERT INTO nif_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesulɨ manda wɨn nandɨmbi nɨñguk, “Ama ñalɨ bo Ablaamdok komblin kulakta tɨmbi Yambattɨ sandap ñolonda it ñolok kuañ en kolandok kiinan nanin sepma tɨkeumbi, kɨndem pakañ. ");
INSERT INTO nif_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nak Ama Sɨsɨnɨktɨ amatam pait-papal enda wakan ep lonjɨmbi epmektok indañgut.” ");
INSERT INTO nif_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesulɨ Jelusalem tɨmbɨ dumalañgukta tɨmbi amatamdɨ ñɨndɨñ nandɨñgɨlɨñ, ‘Yambattɨ kusei kɨmɨpi, indañgan nɨmbɨ-dɨkñeupi tɨlak.’ Kusei wɨndɨñda tɨmbi Yesulɨ yousɨmbi, eyout manda no amatam mandan nandɨ pakɨlɨñ enda ñɨndɨñ enbi ");
INSERT INTO nif_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","eñguk, “Ama loloñ nolɨ kwet kulɨñguknan wolok ama wapmañ indauktok nandɨñguk. Kusei wala tɨmbi endɨ ama wapmañjɨ nɨmbɨ taleuktok kwet mayañgan ñambi, nombo undane bɨuktok eñguk. ");
INSERT INTO nif_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Embi, kena gwañgwañii endoñnan nanin kɨt tambon tambon kɨtɨ-semum bɨumbi, ama noñgan noñgan mɨnem lɨk noñgan embi enguk, ‘Sɨndɨ mɨnem ñɨn tɨkembi, kena mɨñɨlɨmbi, nak ñam undane bɨutat wolok tuop.’ Wɨndɨñ embi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Tɨmbi endok gɨñgɨtñii nandɨ-kunjita tɨ-ñɨmɨñgɨlɨñ endɨ ama dɨwɨn ep danbi, en kle ñambi, ñɨndɨñ enelɨñdok enɨ-mukɨlɨñ, ‘Nɨndɨ ama ñɨn endɨ ama wapmañnɨ kuuptok nɨm nandamɨñ.’ ");
INSERT INTO nif_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Tɨmbi ama wɨn ama wapmañjɨ nɨmbɨ taleumbi, ilnan undanem bɨñguk. Bɨmbi, kena gwañgwa mɨnem emɨemɨn endɨ mɨnem wɨn nɨtek ka-dɨkñeum bendɨñguk wɨn ka-nanduktok endɨ kɨtɨ-semum bɨnelɨñdok eñguk. ");
INSERT INTO nif_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Eumbi, dama bɨñguktɨ ñɨndɨñ nɨñguk, ‘Molom, dɨk mɨnem lɨk noñgan namguñ, gan nak kenanewambi, mɨnem lɨk kɨt tambon tambon ikan yousɨmbi indañguk.’ ");
INSERT INTO nif_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Wɨndɨñ eumbi nɨñguk, ‘Kena gwañgwa kɨndem dɨk kundit kɨndem sɨnɨk tɨñguñ. Dɨk nepek tip mɨnam wɨn ka-dɨkñe-kɨliñ eñguñda tɨmbi it kwet kɨt tambon tambon yambɨ-dɨkñeuñdok ganba talelak.’ ");
INSERT INTO nif_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tɨmbi ama nolɨ bɨmbi nɨñguk, ‘Molom, dɨk mɨnem lɨk noñgan namguñ, gan nak kenanewambi, mɨnem lɨk kɨt tambon ikan yousɨmbi indañguk.’ ");
INSERT INTO nif_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Wɨndɨñ eumbi nɨñguk, ‘Ale, dɨk it kwet kɨt tombongot yambɨ-dɨkñeukañ.’ ");
INSERT INTO nif_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tɨmbi ama nolɨ bo bɨmbi nɨñguk, ‘Mɨnemga ñɨn. Nak wɨn sandumdɨ tɨmɨpi biwam pakuk. ");
INSERT INTO nif_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nekta, dɨk ama kunduwat, dɨk kena nɨm tɨñguñdɨ ama nolok kena meñdok bien epep pa tɨlañ, wala tɨmbi nandɨ-mɨsɨ-gambi, wɨndɨñ tɨñgut.’ ");
INSERT INTO nif_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Wɨndɨñ eumbi nɨñguk, ‘Kena gwañgwa kolan dɨk, dɨtnalok mandañga walɨñgan manda plon gapɨletak. Dɨk naka nandum nak ama kunduwat, kena nɨm tɨñguttɨ ama nolok kena meñdok bien epep pa tɨlet wɨndɨñ nandɨ-namlañ ba? ");
INSERT INTO nif_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Tɨkap wɨndɨñda, kusei nekta dɨk mɨnemna tɨkembi, mɨnem ilan nɨm kɨmɨkuñ? Kɨmɨlɨmda, mɨnem walɨ kenaneumbi, bien indaumbi bɨmbi epmet ñak.’ ");
INSERT INTO nif_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Wɨndɨñ embi, ama wolok ikɨlɨñ enda ñɨndɨñ enguk, ‘Mɨnem mɨñgut wɨn lom tɨkembi, ama nin mɨnem lɨk kɨt tambon tambon palmɨlak enda mɨwɨt.’ ");
INSERT INTO nif_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Eumbi nɨñgɨlɨñ, ‘Wopum, endɨ ikan kɨt tambon tambon palmɨlak wɨn!’ ");
INSERT INTO nif_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Wɨndɨñ eumbi enguk, ‘Nak ñɨndɨñ sanba: no en nepek ka-dɨkñelok mɨmɨn wɨn tɨke kulakta, enda nombo yousɨmbi mɨlok, tɨmbi no en wɨn nɨm tɨke kulakta, endok nepek palmɨlak wɨn apma tɨke-ñɨmlok. ");
INSERT INTO nif_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tɨmbi kanjɨknai yambɨ-dɨkñeuttok nɨm nandɨ-namgɨlɨñ wɨn sɨndɨ ñolok yanañgɨp bɨmbi, dautnanangan yandɨpmɨ kɨmbɨt.’” ");
INSERT INTO nif_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesulɨ wɨndɨñ eu taleumbi, Jelusalem it kwet tɨmbɨ dumalauktok yousɨmbi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ñakap, kwet kɨmɨn koi Oliv wolok lombi, Betfage gɨt Betani it kwet ep tɨmbɨ dumalaumbi, gwañgwañiit tɨpet enɨ-mupi ");
INSERT INTO nif_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","enguk, “Sɨtɨ it kwet da wolok ñawɨt. Ña tombi, doñki nɨñañ no toalɨ toptopmɨn palɨmbi kandetamɨk. Doñki nɨñañ wɨn gɨtikñin, wɨn ama nolɨ wolok plon no nɨm pipakɨlɨñ. Wɨn tɨmbɨ indaumbi pɨsapi nañgɨp bɨwɨt. ");
INSERT INTO nif_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tɨkap ama nolɨ ‘Nekta pɨsakamɨk?’ sanɨ-nandumbi, ñɨndɨñ nɨndekamɨk, ‘Wopumdɨ wala elak.’” ");
INSERT INTO nif_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tɨmbi ama tɨpet enɨ-mukuk endɨ ñambi, enguk wolok tuop tɨmbɨ indañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Tɨmbi doñki nɨñañ pɨsalɨñɨlɨpi, molomñiilɨ engɨlɨñ, “Sɨtɨ nekta ñɨn pɨsakamɨk?” ");
INSERT INTO nif_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Eumbi, “Wopumdɨ ñala elak” eñgɨmɨk. Eum nandɨ-semumbi, ");
INSERT INTO nif_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yesuloñ nañgɨp ña tombi, sauloñjet doñki nɨñañlok plon kɨmɨpi, Yesu tɨmbɨ plaptaumbi, wolok plon lo pipakuk. ");
INSERT INTO nif_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Pipalɨm nañgɨp ñaumbi, koi tɨke-lonelɨñdok amatamdɨ sauloñjɨ telak ñañguknan sambat plon ipane-ta-ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tɨmbi Yesulɨ Jelusalem tɨmbɨ dumalaumbi, Oliv kwet kɨmɨn klokloñennan pɨñɨlɨmbi, amatam kɨmɨn wopum en kle kuñgɨlɨñ endɨ kusei kɨmɨpi kot tɨmbi, e-sɨlɨsɨlɨ tɨñgɨlɨñ. Endɨ kundilɨ gembɨnat gɨtɨk tɨmbɨm kañgɨlɨñ wala tɨmbi Yambat wopumgan nɨ-kɨndekɨndem embi, ");
INSERT INTO nif_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ñɨndɨñ eñgɨlɨñ, “Wopumdɨ ama wapmañ nɨ-mulɨm nɨndoñ bɨlak enda gwɨlam mɨlok!’ Kunum Molom Loloñ sɨnɨk busuk nɨmlak endok koi nɨ-ta-lona!” Wɨndɨñ kɨtɨ-kolɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Falisi ama nindɨ amatam kɨmɨn wopumdok boñgɨpsɨnan ñañgɨlɨñ endoñnan nasi dɨwɨn endɨ manda wala nandum pɨumbi, Yesula nɨñgɨlɨñ, “Endaut, gwañgwañgai enombɨumbi biwɨt!” ");
INSERT INTO nif_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eumbi tambane enguk, “Nak ñɨndɨñ sanba: tɨkap endɨ binetañda, kawattɨ gɨtɨk ñalɨ kɨtɨnetañ.” ");
INSERT INTO nif_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Tɨmbi Yesulɨ Jelusalem tɨmbɨ dumalaumbi, it kwet wɨn kañbi, kut-blambla embi, ");
INSERT INTO nif_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ñɨndɨñ eñguk, “Jelusalem nasi, man ñɨndɨñgɨt telak nek ñalɨ busuk tɨmbɨ inda-samek wɨn nandɨnelɨñ ñak! Gan walɨ dausɨnan sembɨn palɨmbi, nɨm ka-dakleañ. ");
INSERT INTO nif_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kusei ñɨndɨñda wɨndɨñ sanlet: nain inda-samumbi, kanjɨksiilɨ bɨmbi, kwet tuop masip samnelɨñdok sañ wandin sep gɨmbu embi, dɨm pawan kwet kɨmɨlɨ loumbi, dɨm makleumbi, mikñat sɨndoñ lonekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Lombi, isɨ kwesɨ wakɨt wembe gwañgwanjii wolok kuañ sɨndɨ sandɨpbi, sep tɨmbɨ kola-talenekalɨñ. Tɨmbi isɨ wialɨmbi, kawat nolɨ nollok plon nɨm galɨ kwambɨñ dambi palekak. Yambattɨ sep plaptauktok sɨndoñ bɨñguk, gan sɨndɨ kilanjɨ wɨn nɨm ka-nandɨ-dakleñgɨlɨñda tɨmbi kanjɨksiilɨ wɨndɨñ tɨ-samnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tɨmbi Yesulɨ tapma it sañ jimba gɨnañ lombi, ama nepenepek tuatualok kɨmɨkɨlɨñ yambɨmbi, gɨnañ komba dɨumbi, kusei kɨmɨpi, walinin ep kle kolɨñɨpi ");
INSERT INTO nif_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","enguk, “Tapma it ñolok plon Yambattok manda ñɨndɨñ youyoulɨn patak, ‘Nokok itnalɨ nɨmolo tɨ-namnamlok it palekak’, gan sɨndɨ wɨn tɨmbɨmbi, kumbu ama piñdasɨ endok pat-sembɨ it nomɨk tɨlak.” ");
INSERT INTO nif_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tɨmbi Yesulɨ sandap tuop tapma ilan ñambi, amatam enɨ-daut tɨ-semñɨlɨmbi, tapma ama biesɨ gɨt endɨkñe manda nandɨ-tale ama ba Judalok telak damanjɨ endɨ en wɨlɨ kɨmnelɨñdok telak lonjɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","gan amatamdɨ endok mandan nandɨnelɨñdok en gɨta galɨñgɨlɨñda tɨmbi ama biesɨlɨ en wɨtnelɨñdok telak no nɨm kañgɨlɨ ñ. ");
INSERT INTO nif_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nain nola Yesulɨ tapma ilan amatam enɨ-daut tɨ-sembi, gɨñgɨt manda kɨndem enɨñɨlɨmbi, tapma ama biesɨ wakɨt endɨkñe manda nandɨ-tale ama ba ama biesɨ dɨwɨn endɨ kanep bɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ñɨndɨñ nɨ-nandɨñgɨlɨñ, “Dɨk tapma ilan ñolok kundit kusei kusei pa tɨlañ wɨn nindɨ wɨndɨñ tɨndɨlok gembɨ gamguk ba ganbɨ taleñguk wɨn nɨnbɨm nandɨna.” ");
INSERT INTO nif_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Eumbi tambane enguk, “Nak bo ekaeka no sanɨ-nandɨwambi nanbɨ nandɨwa: ");
INSERT INTO nif_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nindɨ Yoane nɨmbɨ taleumbi, tuk ii-sem kena tɨñguk? Wɨn Kunum Molomdɨ ba ama nolɨ?” ");
INSERT INTO nif_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Eumbi, nɨsɨñgan manda e-kle-kot tɨmbi eñgɨlɨñ, “‘Kunum Molomdɨ’ wɨndɨñ nɨnam, ñɨndɨñ nɨnbetak, ‘Wɨndɨñda sɨndɨ kusei nekta mandan nɨm nandɨ-kwambɨñ dañgɨlɨñ?’ ");
INSERT INTO nif_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ba ‘Ama nolɨ Yoane nɨmbɨ taleñguk’ wɨndɨñ nɨnam, amatam nin Yoane wɨn plofet ama nandɨ-kwambɨñ dañ endɨ kawattɨ nɨndɨp kɨmnetañ.” Wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ñɨndɨñ tambane nɨñgɨlɨñ, “Wɨn nindɨ nɨmbɨ taleñguk wɨn nɨm nandamɨñ.” Eumbi ");
INSERT INTO nif_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","enguk, “Ale, nak bo nindɨ nanbɨ taleumbi, kundit ñɨn pa tɨlet wɨn bo nɨm sanbetet.” ");
INSERT INTO nif_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Tɨmbi Yesulɨ kusei kɨmɨpi, amatamda eyout manda no ñɨndɨñ enguk, “Ama nolɨ wain kena tɨñguk. Wain tɨpi-talembi, kenan wɨn kandɨkñe amalok kɨsɨnan kɨmɨpi, nain ombapgan kwet mayañgan nolok ña kuuptok ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Bien epeplok nain indaumbi, kena gwañgwa sɨlanin no bien dɨwɨn epmektok kandɨkñe amaloñ nɨ-mulɨm ñañguk. Ña tombɨmbi, kandɨkñe amalɨ waipbi, slak undane ñauktok nɨ-mukɨlɨñ. Nɨ-mulɨm ñaumbi, ");
INSERT INTO nif_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","molomlɨ nombo kena gwañgwa sɨlanin no nɨ-mulɨm ña tombɨmbi, en bo waipbi, siñgi mayek tɨ-lamɨpi, slak undane ñauktok nɨ-mukɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tɨmbi molomdɨ nombo kena gwañgwa sɨlanin no nɨ-mukuk wɨn endɨ wɨt wekat mɨmbi kle kokɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wɨnaña wain kena molomdɨ enla embi eñguk, ‘Nɨtek tɨlok? Ip nandɨlet: nak nɨñana noñgangot wale kɨndem tɨ-ñɨmlet en nɨ-mulam ñaumek, giñgiñgan tɨ-ñɨmbi, bien nandɨ-ñɨmumbi epmek bek.’ Wɨndɨñ embi, nɨñañ nɨ-mulɨm ñaumbi, ");
INSERT INTO nif_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","kandɨkñelɨ nɨñañ wɨn kañbi, nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, ‘Ñalɨñgan beulok kii gwatnam bimbin kasɨleupi bɨlak bek. Wɨtnam kɨmbɨmbi, kena ñalɨ nɨndok gɨñgɨt tɨmbekak.’ Wɨndɨñ embi, ");
INSERT INTO nif_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","wain kena pawan munjɨmunjɨt tɨ pɨmbi, wɨlɨ kɨmguk. Sɨndɨ nɨtek nandañ, kandɨkñelɨ wɨndɨñ tɨñgɨlɨñda tɨmbi wain kena molomdɨ nɨtek tɨ-semekak? ");
INSERT INTO nif_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Endɨ bɨmbi, kandɨkñe wɨn gɨtɨk yandɨpmɨ kɨm-taleumbi, kenan wɨn kandɨkñe ama dɨwɨn nolok kɨsɨnan kɨmɨlekak wɨn!” Tɨmbi amatamdɨ manda wala nandum pɨumbi eñgɨlɨñ, “E e, wɨn nɨm! Wɨndɨñ nɨm tɨndɨlok!” ");
INSERT INTO nif_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Gan Yesulɨ dai gembɨnatgan yambɨmbi enguk, “Tɨkap wɨndɨñda, manda youyoulɨn ñalɨ nek plon e-yout tɨlak? ‘It kɨndikɨndit amalɨ ta kawattɨ tɨndɨn wɨn siñgi wɨlɨmgɨlɨñ walɨ wakan ta bien sɨnɨk, ta dɨwɨn gɨtɨk yapma klelak.’ ");
INSERT INTO nif_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tɨmbi ta wolok kandañ wɨn ñɨndɨñ: no en ta wolok plon pi wɨlekta, endɨ lɨlɨmeukak, tɨmbi ta walɨ ama nolok plon pɨ wɨlekta, wɨlɨ gakñeukak.” ");
INSERT INTO nif_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Tɨmbi endɨkñe manda nandɨ-tale ama gɨt tapma ama biesɨ endɨ Yesulɨ eyout manda wɨn nɨsɨla eñguk wɨn nandɨ-daklembi, nain wolondañgan tɨkenep nandɨñgɨlɨñ, gan endɨ amatamda mɨsɨmbi, kak biñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Endɨkñe manda nandɨ-tale ama gɨt tapma ama biesɨ endɨ Yesu Roma ama Judia kwet ka-dɨkñeñguk endok kiinan kɨmɨtnelɨñdok telak lonjɨñgɨlɨñ, wala tɨmbi endɨ Yesulɨ nek tɨñguk ba manda nek eñguk wala ka-tuapi, ama pawanjene deimbi, manda tɨke ku tañ wɨn enɨ-mulɨmbi, Yesuloñ ñañgɨlɨñ. Ñambi, mandalɨ sɨsoñ tɨ-ñɨmɨnelɨñdok dɨndɨm walan juluñgan tɨñɨpi, ");
INSERT INTO nif_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","nɨmbi eñgɨlɨñ, “Endaut, nɨndɨ nandɨ-gamamɨñ, dɨk manda elañ ba e-daut tɨlañ wɨn dɨndɨm sɨnɨk, tɨmbi ama loloñ ba pɨmbɨñen gɨtɨk manda telal noñgan plon enbi, Yambat nɨtek kɨmɨt-klenelɨñdok biañgan enɨ-daut pa tɨ-semlañ. ");
INSERT INTO nif_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Wɨndɨñda dɨk nɨnbɨ nandɨna: endɨkñe mandalɨ takis mɨnem Sisala mɨmɨlok nandɨ-nɨmlak ba nɨm?” ");
INSERT INTO nif_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Eumbi, tɨ-kuyuksɨ ka-daklembi enguk, ");
INSERT INTO nif_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mɨnem kwandai satnin no daut namɨt!” Eumbi daulɨmɨum kañbi enɨ-kañguk, “Ama walan gɨt koi kundit wolok patak wɨn nindoñ?” Eumbi tambane “Sisaloñ” nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Eumbi enguk, “Wɨndɨñda Sisalok gɨñgɨt wɨn Sisala tambane mɨnekalɨñ, tɨmbi Yambattok gɨñgɨt wɨn Yambatta tambane mɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Wɨndɨñ eumbi, amatamdok dausɨnan mandalɨ sɨsoñ tɨ-ñɨmɨnelɨñdok tuop nɨm endɨ Yesulok mandala nanandɨ kena tɨmbi, kwap em pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi amalɨ “Ama sembɨsembɨn endɨ nɨm mɨlamɨlattok” wɨndɨñ pa eañ endoñnan nanin dɨwɨndɨ Yesuloñ bɨmbi ");
INSERT INTO nif_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","nɨ-nandɨmbi eñgɨlɨñ, “Endaut, Moselɨ endɨkñe manda yout-nɨmguk walɨ ñɨndɨñ tɨneñdok elak: tɨkap ama nolɨ tamɨnnat yamɨn papi sembekta, endok dal ba kwayañlɨ endok tam kanjak wɨn tɨkembi, endok gwañgwa bɨsat ep tɨmbɨ inda-ñɨmɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ale, nain nola dakwaya kɨt tambon tɨpet kuñgɨlɨñ. Kuñɨpi, tualɨ tam tɨkembi, yamɨn papi sembɨñguk. Sembumbi, ");
INSERT INTO nif_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","mona gɨt gwik endɨ bo tam wakangot tɨkembi sembɨñgɨmɨk. Wɨn dakwaya kɨt tambon tɨpet endɨ gɨtɨk tam wɨn tɨkembi, yamɨn papi sembɨ-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tɨmbi siñgi tam endɨ bo lakat papalembi sembɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ale, ama dakwaya kɨt tambon tɨpet endɨ tam noñgangot wɨn tɨkeñgɨlɨñda tɨmbi, ama sembɨsembɨn kɨmnan nanin kaitambi mɨlatnekalɨñ nain wolonda tam wɨn endɨ nindok tam sɨnɨk tɨmbekak?” ");
INSERT INTO nif_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tɨmbi Yesulɨ enguk, “Amatam kwelan kuañ endɨ wapatam pa tañ, ");
INSERT INTO nif_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","gan Yambattɨ amatam nandum tuop tɨ-semumbi, jimba nolok nainnan kunelɨñdok kɨmnan nanin ep tɨmbɨ mɨlatnekalɨñ endɨ wapatam nɨm tɨnekalɨñ, ");
INSERT INTO nif_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","endɨ eñalolɨ kuañ wɨndɨñgangot kunekalɨñ. Tɨmbi Yambattɨ kɨmnan nanin ep tɨmbɨ mɨlakɨlɨñda tɨmbi endɨ enlok wembe gwañgwañii kumbi, bɨndambo sembɨnelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Tɨmbi Moselɨ bo ñɨndɨñ nɨnɨ-daklelak: ama sembɨsembɨn endɨ kɨmnan nanin pa mɨlakañ. Neta, komba mambenlɨ komba nolok plon duat-pakuk wolok kasat tɨñɨpi, Wopumda ñɨndɨñ elak, en ‘Ablaamdok Yambat ba Aisaktok Yambat ba Jekoptok Yambat’. ");
INSERT INTO nif_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Wɨndɨñda tɨmbi endɨ gɨtɨk Yambattok dainan kuñgunjɨat, wala tɨmbi Yambat endɨ ama kaik kuañ endok Yambat, ama sembɨsembɨn endok Yambat nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Tɨmbi endɨkñe manda nandɨ-tale ama dɨwɨndɨ ñɨndɨñ tambane nɨñgɨlɨñ, “Endaut, dɨk manda kɨndem bien elañ.” ");
INSERT INTO nif_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tɨmbi bɨndambo nɨ-nandɨnelɨñdok mɨsɨmbi, kak biñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tɨmbi Yesulɨ ñɨndɨñ enɨ-nandɨñguk, “Nɨtekta tɨmbi Mesia endɨ Devittok Komblin sɨnɨk wɨndɨñ pa eañ? ");
INSERT INTO nif_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kusei ñɨndɨñda wɨndɨñ sanɨ-kalet: Yambattɨ Mesiala manda no nɨñguk wɨn Devit en Kap gɨnañ ñɨndɨñ youkuk, ‘Molomdɨ nokok Wopumna ñɨndɨñ nɨñguk, Dɨk kɨtna dɨndɨm kandañ pipalɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kanjɨkgai wɨn ep pɨmbi, kesɨka kapmai yapɨletat wolok tuop.’ ");
INSERT INTO nif_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devittɨ Mesia ‘Wopumna’ nɨñgukta, Mesia endɨ nɨtek Devittok komblin?” ");
INSERT INTO nif_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amatam gɨtɨk nandɨ palɨñɨlɨmbi, Yesulɨ gwañgwañiila ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sɨndɨ endɨkñe manda nandɨ-tale ama yambɨ-nandɨ-kɨliñ embi kunekalɨñ. Endɨ ama loloñ nɨsɨlok dasindasin ombap dasimbi ña-bɨ tɨnep nandañ, ba amatam ipakanan kɨmɨn kokañ endɨ giñgiñgan tɨ-semnelɨñdok nandañ. Tɨmbi nanañ sina wopumnan ba it kiyau gɨnañ endɨ pitit kɨndem damandama pataknangot pitnepi nandañ. ");
INSERT INTO nif_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Tɨmbi endɨ tam kanjak juluñgan tɨ-sembi, isɨ ba nepenepesɨ yolom ep semañ, tɨmbi dɨndɨm walan tɨnelɨñdok nɨmolo ombap pa tañ. Juluñɨtsɨla tɨmbi kɨnjan yousɨ-semum ombɨ-tɨkenekalɨ.” ");
INSERT INTO nif_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tɨmbi Yesulɨ deium loumbi, amatam mɨnem kwɨlɨkwɨlɨnjɨat tapɨkot mɨnem dɨñgwinda gɨnañ kɨmɨlɨm pɨumbi yambɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tɨmbi tam kanjak pɨmbɨñen no endɨ bo bɨmbi, mɨnem gɨmɨn tɨpet kɨmɨlɨm pɨumbi kañbi ");
INSERT INTO nif_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","enguk, “Nak biañgan sanlet: tam kanjak pɨmbɨñen ñalɨ mɨnem kɨmɨlak walɨ amatam dɨwɨn gɨtɨktɨ mɨnem kɨmɨlalɨñ wɨn yapma klelak. ");
INSERT INTO nif_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Neta, dɨwɨn gɨtɨk endɨ nepek tokñetokñengan pat-semlaknan nanin tɨkembi, lakatgot tapɨkot kɨmɨlalɨñ, gan tam pɨmbɨñen endɨ nɨmɨninnan nanin nepek kuñgun ka-dɨkñelok tuop palmɨk wɨn gɨtɨk kɨmɨlak.” ");
INSERT INTO nif_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tɨmbi ama dɨwɨndɨ tapma it kañbi, wala ñɨndɨñ eñgɨlɨñ: it wɨn kawat kɨndemlɨ tɨndɨn, ba nepenepek tuan loloñ tapma mɨmɨn pakuk wala tɨmbi pama walalan indañguk. Tɨmbi Yesulɨ enguk, ");
INSERT INTO nif_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sɨndɨ nepek neta daukañga tañ wolok nak ñɨndɨñ sanba: nain indaumbi, kawat gɨtɨk ñɨn mep kolɨm kwelan pɨumbi, kawat nolɨ nolok plon no nɨm galɨ patnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wɨndɨñ eumbi nɨ-nandɨmbi eñgɨlɨñ, “Endaut, nepek wɨn nain nekta sɨnɨk indaukak, ba jimba kundit nek ñalɨ indaumbi kañbi, nepek walɨ indaupi tɨlak wɨn nandɨnekamɨñ?” ");
INSERT INTO nif_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tɨmbi enguk, “Sɨndɨ ka-kɨliñ embi kunekalɨñ! Nɨm kañbi, juluñ amalɨ juluñ tɨ-samnelɨñ. Ama asuptɨ nokok kotna plon bɨmbi, ñɨndɨñ enekalɨñ, ‘Nak Mesia wakan’, ba ‘Nain ip dumalalak’. Sɨndɨ ama wɨndɨñ pa eañ wɨn nɨm ep kle-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tɨmbi kantri nolok gɨnañ ba kantri dɨwɨndok boñgɨpsɨnan mik indaumbi, wolok gɨñgɨt nandɨnekalɨñ, wolonda sɨndɨ nɨm mɨsɨ-kolanekalɨñ. Nepek wandisɨ walɨ damandama indauktok een, gan nain taletalen walɨ wolongan nɨm indaukak.” ");
INSERT INTO nif_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tɨmbi yousɨmbi enguk, “Kantri nolɨ kantri nola mik tɨ-semumbi, ama wapmañjɨlok sambaliilɨ nɨsɨñgan minekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tɨmbi nain wolonda kwet kwet kenɨñ wopum ba nanañ map ba jɨmbat kusei kusei indaumbi, kɨm tambat indaukak, ba kunum plon jimba kundit ba nepek ka-mɨsɨmɨsɨn wopum indanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nepek gɨtɨk walɨ gamañ nɨm indañɨlɨmbi, endɨ naka tɨmbi sep tɨmbɨ kolanelɨñdok sep kle-gɨmgɨm embi sepbi, it kiyaunjɨ gɨnañ manda plon sapɨpi, it kwambɨñjɨ gɨnañ sep kɨmɨlɨmbi, ama wapmañ ba kandɨkñe ama endoñ sanañgɨlɨm ñambi, mandala dausɨnan itnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nain wolonda gɨñgɨt manda kɨndem ama wala enɨnelɨñdok kilanjɨ indaukak. ");
INSERT INTO nif_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","15","Nain wolonda natna nanandɨ sambi, manjɨ tɨmba londaumbi, kanjɨksii gɨtɨk endɨ sɨndok mandanjɨ nandɨmbi, mandanjɨ wɨtnelɨñdok ba manda walɨ juluñgan wɨn tɨmbɨ indauktok telal lonjɨnekalɨñ. Kusei wala tɨmbi sɨndɨ gɨnañjɨ gɨnañ ñɨndɨñ nandɨ-kwambɨñ danekalɨñ, ‘Nɨndɨ manda nek enambi, nɨp kasopmeukak wala itañgan nandɨ-kwɨnakwɨnale nɨm tɨnekamɨñ’. ");
INSERT INTO nif_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Menjɨ besɨ ba dasii kwayañjii ba wekat dɨpsɨ ba nosii endɨ bo bola tɨ-samumbi, kanjɨksiilɨ sɨndoñnan nanin dɨwɨn sandɨp kɨmnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kwet tuop amatamdɨ naka tɨmbi nandɨ-kunjit pa tɨ-samnekalɨñ, ");
INSERT INTO nif_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","gañgan Yambattok dainan kumbanjɨ sak noñgan no nɨm pailekak. ");
INSERT INTO nif_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Sɨndɨ gɨlɨm dambi kunekalɨñda, kuñgu kwambɨñjɨ kasɨlenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sɨndɨ kanekalɨñ wɨn: mik amalɨ bɨmbi, Jelusalem kle-gɨmbutnekalɨñ. Nain wolonda it kwet wɨn tɨmbɨ kolauktok nain dumalalak wɨndɨñ ka-nandɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ka-nandɨmbi, ñɨndɨñ tɨnekalɨñ: Judia kwelan pakañ endɨ kwet jangɨnnan pi ñanekalɨñ, tɨmbi Jelusalem pakañ endɨ bo walinin pɨ ñanekalɨñ, tɨmbi kwet nolok pakañ endɨ Jelusalem nɨm lonekalɨñ. Kusei ñɨndɨñda wɨndɨñ tɨnekalɨñ: ");
INSERT INTO nif_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","manda gɨtɨk it kwet wolok plon youyoulɨn patak wolok bien indauktok Jelusalem nasilɨ nain wolonda kolanjɨlok kɨnjan tɨkenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nain wɨn kolan sɨnɨkta tɨmbi tam gwañgwa mɨnjɨpsɨat ba tam ñakñakta num emañ endɨ blasɨñgandok. Mɨlap wopum sɨnɨk kwelan indaumbi, Yambattok gimbɨt wopum bien amatamdoñ inda-semumbi, ");
INSERT INTO nif_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","dɨwɨn kakittɨ yandɨpmɨum kɨmnekalɨñ, dɨwɨn ep topbi yanañgɨlɨmbi, kwet kwet ña-talenekalɨñ. Tɨmbi kwet nolok nasilɨ Jelusalem it kwet ma tɨkembi, ep pɨ-yali-ta-ñaumbi, Yambattɨ nain kɨmɨt-semguk wɨn taleukak wolok tuop.” ");
INSERT INTO nif_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Tɨmbi Yesulɨ yousɨmbi enguk, “Tɨmbi nepek gɨtikñin kusei kusei maim, yakɨp ba domboñgɨp plon indaukak, ba kwelan tuk kimbɨñdɨ tawambi, gɨñgɨlɨ wopum kɨtɨukak. Kusei wala tɨmbi kwet kwet kuañdɨ gɨnañjɨ mɨlataumbi, nanandɨnjɨ nɨm dakleukak. ");
INSERT INTO nif_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Tɨmbi nepek kwambɨñ kunum plon pakañ, wɨn maim, yakɨp, domboñgɨp nek, ep minjalɨmbi jɨlopbi, kwesɨ binekalɨñ, wala tɨmbi nepek kolan nek kwetta inda-ñɨmekak wala amatamdɨ mɨsɨmɨsɨñɨpi mandɨ-ta-kuñɨpi, kɨm katap tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wɨnaña kanekalɨñ wɨn: nak Ama Sɨsɨnɨktɨ mulukua gɨnañ pɨ tombi, gembɨ ba nulɨnulɨn wopumna tɨmba dakleukak. ");
INSERT INTO nif_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nepek mɨlap wandisɨ wakan kusei kɨmɨp indaumbi, Yambattɨ sapma tɨkeukak wolok nain tɨmbɨ dumalaukak wala tɨmbi sɨndɨ deium loumbi nandɨ-pañgɨtanekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Tɨmbi Yesulɨ eyout manda no ñɨndɨñ embi enguk, “Sɨndɨ komba fik ba komba dɨwɨn nandɨ-sɨwɨtnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Endɨ mindinjɨ tawa lambɨ dapmɨumbi, maim nain indaup tɨlak wɨn sɨndɨ dausɨlɨ kañbi nandɨ-dakleyañ. ");
INSERT INTO nif_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wɨndɨñgangot mɨlap walɨ indaumbi kañbi, ñɨndɨñ nandɨ-daklenekalɨñ, ‘Nain nɨm ombataumbi, Yambattɨ amatamñii indañgan yambɨ-dɨkñeukak’. ");
INSERT INTO nif_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nak biañgan sanba: ama sambat man ñɨndɨñgɨt kuañ endɨ gama nɨm kɨm-taleñɨlɨmbi, nepek gɨtɨk ñalɨ inda-taleukak. ");
INSERT INTO nif_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunum kwet endɨ talendekamɨk, gan nokok mandanalɨ nɨm taleukak. Nɨm sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Sɨnla kuñgunjɨ ka-dɨkñe-kɨliñ enekalɨñ. Nɨm kañbi, nanandɨnjɨlɨ tuk kimbɨñ ba nana sinat ba kwelalok mɨlap wolokgot pat-samumbi, Ama Sɨsɨnɨk nokok tomtomnala nandɨ-kamala-kuumbi, kaikan inda-samek. ");
INSERT INTO nif_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sɨsoñlɨ gaut gembɨnat kaikan tɨkelak, wɨndɨñgangot nain wopum walɨ amatam gɨtɨk kwet tuop kuañ kaikan inda-semekak. ");
INSERT INTO nif_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wala tɨmbi sɨndɨ nain tuop ka-kɨliñ embi, gembɨ pat-samektok nɨmolo tɨ-kuñɨpi, nepek inda-samekak wɨn gumañ maklembi, Ama Sɨsɨnɨk nokok dautnanan siñgi mɨsɨ nɨmnat indambi itnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesulɨ sandap tuop tapma ilan lombi, amatam enɨ-daut pa tɨ-semguk, tɨmbi kɨlɨm elɨñguk tuop endɨ pɨ Oliv kwet jañgɨn kandañ ñambi doulɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kwet salaumbi, amatam gɨtɨk endɨ tapma ilan lombi, Yesulok mandan nandɨnelɨñdok endoñ pa bɨañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Plaua nanañ kɨmɨlɨmbendɨ nɨmnat nanalok gwɨlat, koi no kamaikamai nain, wɨn tɨmbɨ dumalañguk. ");
INSERT INTO nif_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Tɨmbi tapma ama biesɨ gɨt endɨkñe manda nandɨ-tale ama endɨ amatam yambɨ-mɨsɨmɨsɨ tɨ-semñɨpi, Yesu wɨlɨ kɨmbektok telak gitak no lonjɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Yesulok gwañgwañii 12 endoñnan nanin no wɨn Judas, koi no Iskaliot kɨtɨañgɨlɨñ. Satandɨ endok gɨnan gɨnañ pɨmbi nañgɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","nolii yambimbi, tapma ama biesɨ ba ama tapma it kamaikamai tɨñgɨlɨñ endok telak damanjɨ endoñnan ñambi, telak nɨtek tɨmbi, Yesu bola tɨ-ñɨmɨumbi tɨkenelɨñdok en gɨta e-nandɨ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tɨmbɨm sɨmbasɨ kɨndem daumbi, bolalok tuan wɨn mɨnem mɨnepi e-kwambɨñ daumbi, ");
INSERT INTO nif_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judaslɨ gɨnañ noñgan tɨmbi nandɨ-tale-sembi, “Kɨndem” eñguk. Embi, amatam kɨmɨn gɨtɨktok dausɨnan yambɨ-sembɨmbi, bola tɨ-ñɨmektok nain kɨndem no lonjɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Plaua nanañ kɨmɨlɨmbendɨ nɨmnat nanalok gwɨlat wolok kusei kɨmɨkɨmɨlɨnan kamaikamai gwɨlat pa indalak. Nain wolonda endɨkñe mandalɨ sipsip nɨñañ noñgan noñgan tapma amalok dausɨnan wɨlɨ kɨmnelɨñdok elak. Sandap wɨn indaumbi, ");
INSERT INTO nif_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesulɨ Petlo gɨt Yoane enɨ-mupi enguk, “Sɨtɨ ñambi, gwɨlat ñolok nanañ tɨ-jumut tɨ-nɨmumbi nanetamɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eumbi nɨ-nandɨmbi eñgɨmɨk, “Dɨk delok tɨ-jumut tɨndendok nandɨlañ?” ");
INSERT INTO nif_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Eumbi tambane enguk, “Nandamɨk. Sɨtɨ Jelusalem it kwelan ña tombi, ama no tuk kambot bem ñautak en tɨmbɨ indaumbi, en klembi, it delok loutak wolok lombi, ");
INSERT INTO nif_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","it beula ñɨndɨñ nɨndekamɨk, ‘Nɨnɨndauttɨ ñɨndɨñ ganɨ-nandɨk: it gɨnañ wɨn delok patak nakɨt gwañgwanai gwɨlattok nanañ naneñdok nandɨlañ?’ Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","endɨ it gɨnañ wopum no plon patak tɨ-kɨliñ e-bimbin wɨn daut sametak. Wolok nanañ tuk tɨ-jumut tɨndekamɨk!” ");
INSERT INTO nif_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesulɨ wɨndɨñ eumbi, gwañgwañiittɨ ñambi kañgɨmɨk wɨn: nepek gɨtɨk Yesulɨ enguk wolok tuopgan indañguk. Wɨndɨñ kañbi, gwɨlattok nanañ tɨ-jumut tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tɨmbi nanañ nanalok nain indaumbi, Yesu en gɨta gwañgwañii kena tɨndɨlok enɨ-mumulɨn endɨ it gɨnañ wandɨñ lombi, nanañ nanelɨñdok pi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Pi palɨñɨpi, Yesulɨ enguk, “Nak gamañ mɨlap wopum bembetat. Gan dama nak kamaikamai gwɨlat ñolok nanañ sɨn gɨta nambepi nain ombapgan nandɨ-koñgom tɨ-ta-bɨñgut. ");
INSERT INTO nif_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kusei ñɨndɨñda wɨndɨñ sanlet: nak gwɨlat ñandin ñolok nanañ kwelan nombo nɨm nambetat. Wɨn nain taletalenan Yambattɨ amatam indañgan yambɨ-dɨkñeumbi, nanañ ñolok bien inda-dakleukak, wolondamek nak nombo gɨñgɨtnai gɨt yakan nanañ ñandin nambetat.” ");
INSERT INTO nif_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tɨmbi endɨ wɨtna no tɨkembi, Yambat we ñɨmɨmbi, gwañgwañiila enguk, “Sɨndɨ wain tuk ñɨn tɨkembi, sɨn tambo mɨñ tɨmbi nambɨt! ");
INSERT INTO nif_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kusei ñɨndɨñda wɨndɨñ sanlet: sandap ñɨn taleumbi, nak wain tuk nombo nɨm nambetat. Wɨn Yambattɨ amatam indañgan yambɨ-dɨkñeukak wolondamek nak wain tuk nombo nambetat.” ");
INSERT INTO nif_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wɨndɨñ embi, plaua no tɨkembi, Yambat we-ñɨmbi, ombɨ embi enguk, “Ñɨne nokok pɨñgɨpna nak tapma tɨ-samlet. Sɨndɨ nandɨ-sɨwɨt-namnelɨñdok plaua tɨke ombɨmbi, na tɨ-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nambɨ taleumbi, Yesulɨ wɨndɨñgangot wain wɨtna no tɨkembi enguk, “Wain tuk ñalɨ toptop komblin Yambattɨ amatamñii gɨta tɨlak wolok walan. Nak wekatnalɨ tapma tɨmbi yalɨmɨt-samñɨpi, toptop wɨn tɨmba kwambɨñ dalak.” ");
INSERT INTO nif_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yesulɨ wɨndɨñ embi yousɨmbi enguk, “Yakñesɨ! Ama bola tɨ-nam-tɨ-namlok endɨ nakɨta papi, yakan nanañ namɨk. ");
INSERT INTO nif_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nak Ama Sɨsɨnɨktɨ telak kɨmɨt-namnamɨn wɨn klembi, kɨm plon loutat. Gan ama bola tɨ-namlak en blangandok, Yambattɨ kɨnjan ombɨ-mekak.” ");
INSERT INTO nif_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wɨndɨñ eumbi, wolongan gwañgwalɨ “Nɨndoñnan nanin nindɨ kolan wandin tɨmbek?” embi, nɨsɨñgan manda e-nandɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tɨñɨpi endoñnan nanin nindɨ sɨnɨk amatamdok dausɨnan loloñ sɨnɨk wala bo nɨsɨñgan e-dombɨ-tañan tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tɨmbi Yesulɨ enguk, “Kwelan kuañ endok ama wapmanjii ba yambɨndɨkñenjii endɨ gɨñgɨtsii gembɨnatgan joñgo joñgo pa yambɨ-dɨkñeañ, gañgan endɨ amatamdɨ ‘Kɨndem tɨ-nɨmañ’ wɨndɨñ enɨnelɨñdok nandañ. ");
INSERT INTO nif_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gan sɨndok kandañ wɨndɨñ nɨm tɨlok. Nɨm sɨnɨk. Tambo sɨndok boñgɨpsɨnan lolonjɨlɨ ama pɨmbɨñen nomɨk kuukak, tɨmbi telak damanjɨlɨ tɨplaplape nomɨk kuuptok elet. ");
INSERT INTO nif_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Sɨndɨ nɨtek nandañ? Amatamdok dausɨnan nindɨ loloñ sɨnɨk, wɨn ama slak pipapi nanañ nalak endɨ loloñ, ba ama tɨplaplap tɨ-ñɨmlak endɨ loloñ? Wɨn slak pipapi nalak walɨ mek loloñ sɨnɨk, gañgan natna sɨndok boñgɨpsɨnan tɨplaplapsɨ nomɨk kulet. ");
INSERT INTO nif_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Nak mɨlap plon kuñɨlambi, sɨndɨ wakan nakɨta galɨ-kwambɨñ dambi ku-ta-bañ. ");
INSERT INTO nif_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tɨmbi Bepnalɨ amatamñii yambɨ-dɨkñeuttok nanbɨ taleñguk, wɨndɨñgangot natna sɨndɨ bo wɨndɨñ tɨnelɨñdok sanba talelak. ");
INSERT INTO nif_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Wɨn nak amatam indañgan yambɨ-dɨkñewamek, sɨndɨ kɨndem nakɨta yakan nanañ nambi, ama wapmañdok pitit plon pipapi, Islaellok sambat 12 yambɨ-danɨnelɨñdok wɨndɨñ tɨlet.” ");
INSERT INTO nif_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tɨmbi Yesulɨ eñguk, “Simon, Simon, dɨk nandɨ: plaua mɨnjɨp kɨlɨkɨlɨknat amalɨ bien epmektok ep papusenelak, wɨndɨñgangot Satandɨ nanandɨ-kɨlɨktɨnjɨ pi pɨuktok tɨ-kuyuk tɨ-samep nandɨmbi, sɨndok Yambatta nɨ-nandɨmbi, nandɨ-ñɨm-taleñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gan nak nanandɨ-kɨlɨktɨñgalɨ nɨm pi pɨuktok nɨmolo ikan tɨ-gam-talet. Tɨmbi dɨk undane bɨmbi, nombo nakɨt galɨ-kwambɨñ damek, nokai ep gembɨlaukañ.” ");
INSERT INTO nif_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Eumbi nɨñguk, “Wopum, nak dɨkɨta it kwambɨñ gɨnañ ba kɨmnan lololok tɨ-pañgɨtam patet.” ");
INSERT INTO nif_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Eumbi tambane nɨñguk, “Petlo, nak ganba nandɨ: puputtɨ man tim gama nɨm kɨtɨñɨlɨmbi, dɨk naka ‘Nak en nɨm nandɨ-ñɨmlet’ embi, nain tɨpet gɨt no e-sembɨ tɨ-nametañ.” ");
INSERT INTO nif_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wɨndɨñ embi yousɨmbi enɨ-nandɨmbi eñguk, “Nak kena tɨndɨlok sanɨ-mupi, mɨnem wakɨt lɨk ba kesɨsɨ gwɨlap nɨm mep ñanelɨñdok sanɨ-mulam ñañgɨlɨñ, nain wolonda sɨndɨ nepek nola tɨpɨkañgɨlɨñ ba nɨm?” Eumbi, tambane nɨñgɨlɨñ, “Nepek no nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tɨmbi yousɨmbi enguk, “Gan nain ñɨndɨñgɨtta no en mɨnemñɨn palmɨlakta wɨn tɨke-kuukak, tɨmbi lɨl wɨndɨñgot. Tɨmbi no en kakit ombap nɨm palmɨlakta, wolok tambon sauloñɨn tuatualok kɨmɨpi, kɨnjan kakit no tɨkeukak. ");
INSERT INTO nif_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kusei ñɨndɨñda tɨmbi wɨndɨñ elet: manda no ñɨndɨñ youyoulɨn patak, ‘Enda nandum kolan tɨndɨ ama tɨlak’, tɨmbi manda wolok tuop inda-namektok een. Biañganak: manda nokok plon youyoulɨn patak wolok bien indaupi tɨlak.” ");
INSERT INTO nif_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Eumbi nɨñgɨlɨñ, “Wopum, kakit ombap tɨpet pat-nɨmlak ñɨ ka.” Eumbi enguk, “Ip tuop.” ");
INSERT INTO nif_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tɨmbi Yesulɨ walinin pɨ ñambi, tim tuop tɨlɨñguk wolok tuop Oliv kwet jañgɨnnan ñaumbi, gwañgwañiilɨ kle ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ña kwet wolok tombi enguk, “Sɨndɨ tɨ-kuyuk nɨm inda-samektok nɨmolo tɨ-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wɨndɨñ embi yambɨk bimbi, kawat kolɨm ñalak wolok tuop ñambi, mɨlelem tɨmbi, nɨmolo ñɨndɨñ tɨñguk, ");
INSERT INTO nif_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Bep, dɨk nandum kɨndem dalakta, wɨtna ñɨn napma tɨke. Gan wandingan embi, nokok nanandɨ nɨm klewɨñ, wɨn dɨtna nɨtek inda-namektok nandɨlañ wolok tuop inda-namɨn.” ");
INSERT INTO nif_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tɨmbi kunum gɨnañ nanin eñalo nolɨ endoñ pɨ indambi, gembɨ mɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tɨmbi sɨmba gawattɨ makleumbi dɨñgunembi, nɨmolo gembɨnatgan tɨ-palɨmbi, kokoptɨ wekat nomɨk kwelan pɨtop pɨtop tɨmbi pɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nɨmolo tɨkap mɨlapi, gwañgwañiiloñ ñambi yambɨñguk wɨn: endɨ blandɨ ep tɨmbɨ gwasaeumbi dou pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Dou palɨmbi enguk, “Sɨndɨ nekta dou pakañ? Mɨlapi, tɨ-kuyuk nɨm inda-samektok nɨmolo tɨmbɨt.” ");
INSERT INTO nif_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesulɨ wɨndɨñ eñɨlɨmbi, ama kɨmɨn no endoñ bɨ inda-semgɨlɨñ. Endok gwañgwañii 12 endoñnan nanin no koi Judas endɨ damandama tɨ-sembi, sɨmumuñ tɨ-ñɨmektok endoñ bɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Gan Yesulɨ nɨñguk, “Judas, dɨk sɨmumuñdañgan Ama Sɨsɨnɨk bola tɨ-nametañ ba?” ");
INSERT INTO nif_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tɨmbi endok noliilɨ nepek indaup tɨñguk wɨn kañɨpi nɨñgɨlɨñ, “Wopum, kakittɨ yandɨpnemɨñ ba?” ");
INSERT INTO nif_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wɨndɨñ eñɨpi, endoñnan nanin nolɨ tapma amalok telak damanjɨ endok kena gwañgwan kakittɨ wɨlepi, pawan kii dɨndɨm kandañ nanin wɨlalɨm dɨkñe pɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Tɨmbi Yesulɨ wɨ kañbi enguk, “Biwɨt!” Wɨndɨñ embi, ama wolok pawanlok kɨnjannan kiilɨ tɨke-kaumbi, kɨndem dañguk. ");
INSERT INTO nif_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wɨndɨñ tɨmbi, tapma ama biesɨ wakɨt ama tapma it kamaikamai tɨañgɨlɨñ ba ama biesɨ dɨwɨn no en tɨkenepi bɨñgɨlɨñ enda ñɨndɨñ enguk, “Sɨndɨ naka nandumbi, nak ama piñpiñen tɨmbambi, kakit ba dimba nek mepi, nepnelɨñdok bañ ba? ");
INSERT INTO nif_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nak nain nain tapma ilan sɨn gɨtañgan kuñɨlambi, no nɨm nep kañgɨlɨñ. Gan man tim ñɨn kɨlɨm mulum molomdɨ gembɨnat kuñɨlɨmbi, nepnelɨñdok sɨndok nain inda-samlak.” ");
INSERT INTO nif_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tɨmbi endɨ Yesu tɨkembi ña, tapma amalok telak damanjɨlok ilan lonelɨñdok nañgɨp ñañgɨlɨñ. Telaknan ñañɨlɨmbi, Petlolɨ kambak mayañgan ep klembi ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Tɨmbi ama dɨwɨsɨlɨ sañ jimba boñgɨpnan komba no simbi, pipap sei-palɨñɨlɨmbi, Petlolɨ wolokgan pɨmbi, en gɨta pipakuk. ");
INSERT INTO nif_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pipalɨñɨlɨmbi, kena wembe nolɨ kombalok kolsalen duakuk gɨnañ pipalɨm kañbi, daut kwambɨñ kañbi eñguk, “Ama ñalɨ bo en gɨtañgan pa kulak.” ");
INSERT INTO nif_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eumbi, Petlolɨ e-sembɨ tɨmbi, tamda nɨñguk, “Nak en nɨm nandɨ-ñɨmlet.” ");
INSERT INTO nif_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Wɨndɨñ embi, nain gama nɨm ombataumbi, ama nolɨ kañbi nɨñguk, “Dɨk bo endok nosɨ no wakan.” Eumbi, Petlolɨ nɨñguk, “Nak nɨm.” ");
INSERT INTO nif_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Lakat papaleumbi, ama nolɨ bo gɨñgɨnembi eñguk, “Biañgan sɨnɨk: ama ñalɨ en gɨta pa kulak. Neta, endɨ bo Galili nanin!” ");
INSERT INTO nif_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Gan Petlolɨ ñɨndɨñ tambane nɨñguk, “Dɨk nek elañ nak nɨm nandɨlet.” Eñɨlɨmbi, wolongan puputtɨ kɨtɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kɨtɨumbi, Wopumdɨ undanembi, Petlo dɨndɨmgan kaumbi, Wopumdɨ manda nɨñguk wɨn nandɨ-tomguk. Manda wɨn ñɨndɨñ, “Man tim puputtɨ gama nɨm kɨtɨñɨlɨmbi, dɨk nain tɨpet gɨt no naka ‘Nak en nɨm nandɨ-ñɨmlet’ eutañ.” Manda wɨn nandɨ-sɨwɨpi, ");
INSERT INTO nif_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","sɨmbai kɨmbɨmbi, walinin pɨ ñambi, mano kwɨlɨm tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tɨmbi ama Yesu ka-dɨkñe pakɨlɨñ endɨ kusei kɨmɨpi, nɨ-suambapi waipbi, ");
INSERT INTO nif_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","timan dai bo masipbi nɨñgɨlɨñ, “Dɨk plofet manda embi, nindɨ gutak wɨn nɨnbɨ nandɨna!” ");
INSERT INTO nif_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Wɨndɨñ embi, manda winjɨt kusei kusei nɨmbi, koi nɨ-kolañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kwet salaumbi, Juda amatamdok ama biesɨ en gɨta tapma ama biesɨ gɨt endɨkñe manda nandɨ-tale ama endɨ kɨmɨn tɨ-palɨmbi, Yesu nañgɨpi dausɨnan loumbi, nɨkañbi eñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Dɨk Mesia sɨnɨk kulañda, nɨnbɨm nandɨna.” Eumbi enguk, “Nak wɨndɨñ sanbetta, sɨndɨ mandana nɨm nandɨ-kwambɨñ danetañ. ");
INSERT INTO nif_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ba nepek nola sanɨ-nandutta, tambon nɨm tambane nanɨnetañ. ");
INSERT INTO nif_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gan nain nɨm ombataumbi, nak Ama Sɨsɨnɨktɨ Yambat Gembɨ Molom kii dɨndɨmnan pipaletat.” ");
INSERT INTO nif_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Eu nandɨmbi, gɨtɨkgandɨ ñɨndɨñ nɨñgɨlɨñ, “Wɨndɨñda dɨk Yambattok Nɨñañ wɨndɨñ elañ ba?” Eumbi enguk, “Nak nɨm, wɨn sɨn eañ wakan.” ");
INSERT INTO nif_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Eumbi, nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, “Nɨndɨla ama ñolok kusei enlok man plon nanin eu pɨumbi nandamɨñ, wala tɨmbi wɨn inda-dakleuktok ama nola nombo nɨm lonjɨnetamɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tɨmbi kɨmɨn tɨ-pakɨlɨñ gɨtɨkgandɨ mɨlapi, Yesu Pilatoloñ nañgɨpi, ");
INSERT INTO nif_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","kusei kɨmɨpi, kɨt yout tɨmbi, ñɨndɨñ eñgɨlɨñ, “Nɨndɨ ama ñolok kusei ñɨndɨñ ka-nandamɨñ: endɨ amatamnii ep tɨmbɨ kamalalak. Tɨmbi takis mɨnem Roma ama wapmañ Sisala mɨmɨlok wɨn endɨ nɨnɨ-kɨmɨsip pa tɨ-nɨmlak, tɨñɨpi bo enla ñɨndɨñ pa elak, ‘Natna Mesia, ama wapma.’” ");
INSERT INTO nif_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tɨmbi Pilatolɨ Yesu nɨ-nandɨmbi eñguk, “Dɨk Juda amalok ama wapmañjɨ ba?” Eumbi nɨñguk, “Dɨtna elañ i wakan.” ");
INSERT INTO nif_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Eumbi, Pilatolɨ tapma ama biesɨla ba ama kɨmɨn wopum enda enbi eñguk, “Nak ama ñolok endɨkñe manda wɨwɨt bien no nɨm kalet.” ");
INSERT INTO nif_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gan endɨ gɨñgɨnembi nɨñgɨlɨñ, “Endɨ Judia kwet tuop amatam enɨ-daut tɨ-semñɨpi, Galili kwelan kusei kɨmɨpi bɨm Jelusalem ñolok amatam gɨnanjɨ ep tɨmbɨ mɨlatak.” ");
INSERT INTO nif_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatolɨ manda wɨn nandɨñgukta enɨ-nandɨmbi eñguk, “Ama ñɨn Galili nanin ba?” ");
INSERT INTO nif_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eumbi, “Oñ” eñgɨlɨñ. Eumbi, Pilatolɨ nandɨ-tomguk wɨn: Yesu wɨn kwet Elottɨ ka-dɨkñeñguk walinin. Tɨmbi Elottɨ bo nain wolonda Jelusalem pakukta tɨmbi Pilatolɨ Yesu endoñ nañgɨp ñanelɨñdok eñguk. Eumbi nañgɨp ñam tombɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Elottɨ en kañbi, kusei ñɨndɨñda sɨmbai kɨndem dañguk: Yesulok gɨñgɨttɨ nain asup pawan gɨnañ pɨumbi, endok dainan kundit engano tɨmbektok nandɨlɨñgukta tɨmbi endɨ nain ombapgan en kauktok mandɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wala tɨmbi endɨ manda kusei kusei nɨ-nandɨñguk, gan Yesulɨ Elottok mandan nandɨ-kɨmkɨmneñɨpi, tambon no nɨm tambanem nɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Tɨñɨpi, tapma ama biesɨ ba endɨkñe manda nandɨ-tale ama endɨ ñasɨñgan ipi, siñgin gembɨnatgan siñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tɨmbi Elot gɨt mik amañii endɨ nɨ-tɨke-pɨ-yalimbi, manda sañala tɨ-ñɨmɨñgɨlɨñ. Wɨndɨñ tɨmbi Elottɨ eumbi, Yesula dasindasi pamanat dasi-ñɨmɨmbi, nombo nañgɨpi, Pilatoloñ undane ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pilato gɨt Elot endɨ dama nɨsetkan kanjɨk tɨñɨpi kuñgɨmɨk, gan sandap wolondañgan endɨ not tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Tɨmbi Pilatolɨ tapma ama biesɨ wakɨt Juda amalok kandɨkñenjɨ ba amatam kɨmɨn gɨtɨk kɨtɨ-semum bɨumbi ");
INSERT INTO nif_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","enguk, “Sɨndɨ ama ñɨn nokoññan nañgɨp bɨmbi, endɨ amatam ep tɨmbɨ kamalalak wɨndɨñ nanɨlɨñ, gan nak sɨndok dausɨnan endok kusei tɨmba dakle-taleumbi, ñɨndɨñ sanlet: manda gɨtɨk endok plon e-yout tañ wolok bien no nɨm kalet. ");
INSERT INTO nif_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Elottɨ wɨndɨñgangot tɨk. Neta, endɨ eumbi, ama ñɨn bɨndambo nɨndoñ nañgɨp bañ. Wɨn ñɨndɨñ: endɨ kɨmkɨmlok kolan no nɨm tɨñguk, ");
INSERT INTO nif_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","wala tɨmbi nak nanandɨlokgot tɨ-lamɨpi, kak biwa ñautak.” ");
INSERT INTO nif_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gan amatam gɨtɨkgandɨ ka-kwawañganembi eñgɨlɨñ, “Barabas pɨsat-nɨmbi, ama ñɨn wɨlɨ kɨmbɨn.” ");
INSERT INTO nif_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabas endɨla nolii gɨta Jelusalem it kwelan papi, gavman mik tɨ-sembi, ama no wɨlɨ kɨmgukta tɨmbi it kwambɨñ gɨnañ kɨmɨlɨm pakuk.) ");
INSERT INTO nif_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tɨmbi Pilatolɨ Yesu pɨsalɨmektok nandɨmbi, amatamda nombo enguk. ");
INSERT INTO nif_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gan endɨ ñɨndɨñ kɨtɨkɨtɨñɨpi nɨñgɨlɨñ, “Kloñbat plon wɨlɨ kɨmbɨn!” ");
INSERT INTO nif_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tɨmbi Pilatolɨ mandanjɨ makleumbi, nain tɨpet gɨt no tɨmbɨmbi, ñɨndɨñ enguk, “Nekta sɨnɨk? Endɨ kolan nek sɨnɨk tɨñguk? Nak tɨmba dakleumbi, endɨ kɨmbektok bien no nɨm kalet, wala tɨmbi nak nanandɨlokgot tɨ-lamɨpi, kak biwa ñautak.” ");
INSERT INTO nif_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gan amatamdɨ gɨñgɨnembi, Yesu kloñbat plon wɨlɨ kɨmkɨmlok embi, kwambɨñgan kɨtɨmbi, manda sala wopum tɨmbi, Pilatolok mandan wɨlɨ pɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wala tɨmbi Pilatolɨ nandɨ-sembi, manda eñgɨlɨñ wolok bien indauptok eñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Endɨ e-gɨñgɨnenjɨla mandanjɨ tañgonembi, Barabas en nin gavman mik tɨ-sembi, ama wɨlɨ kɨmgukta tɨmbi it kwambɨñ gɨnañ kɨmɨkɨlɨñ en wakan amatamda pɨsapi emguk. Gan Yesu endɨla wɨn amatamdok mandanjɨla Pilatolɨ en mik amalok kɨsɨnan wɨlɨ kɨmnelɨñdok kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Endɨ Yesu walinin nañgɨp pɨñɨpi, ama no koi Simon Sairini nanin telak plon tɨmbɨ indañgɨlɨñ. Endɨ kena gɨnañ nanin bɨumbi tɨkembi, Yesulok kloñbat bembektok kii klup plon kɨmɨpi, en klem ñañalok nɨ-gɨñgɨneñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tɨmbi amatam kɨmɨn wopum en kleñgɨlɨñ endok boñgɨpsɨnan tam dɨwɨndɨ kut-blambla embi, mano tɨ-ñɨmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Wɨndɨñ tɨmbɨmbi, Yesulɨ undanem yambɨmbi enguk, “Jelusalem tam, sɨndɨ naka blan nɨm tɨmbi kutnelɨñ. Tambo sɨndɨ kusei ñɨndɨñda sɨnla ba wembe gwañgwanjiila kulɨt: ");
INSERT INTO nif_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","mɨlap nain no indaumbi, amatamdɨ ñɨndɨñ enekalɨñ, ‘Tamdɨ yamɨn papi, gwañgwa nɨm apgɨlɨñ ba num nɨm emgɨlɨñ endɨ tam dɨwɨn yapma kle pakañ.’ ");
INSERT INTO nif_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Wolongan endɨ kwet jañgɨnla ñɨndɨñ enɨnekalɨñ, ‘Sɨndɨ gɨlombi, nɨndok plon pɨwɨt!’, ba kwet kɨmɨnda ñɨndɨñ enɨnekalɨñ, ‘Sɨndɨ nɨndɨp tapliwɨt!’ ");
INSERT INTO nif_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Komba kaikta amalɨ nepek ñandin tɨ-ñɨmañda, kɨmkɨmɨnla nɨtek inda-ñɨmekak?” ");
INSERT INTO nif_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tɨmbi ama tɨpet, endɨ kolan tɨndɨn ama, endɨ bo Yesu gɨta yandɨpnelɨñdok yanañgɨpi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ñakap, kwet no koi Kumban Kwandat wandɨñ ña tombi, Yesu kloñbat plon wɨpi, kolan tɨndɨn tombon tombon yakan en gɨta yandɨpbi ep tembɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tɨmbi Yesulɨ nɨmolo nombo nombo tɨmbi, ñɨndɨñ eñguk, “Bep, endɨ nek tañ wolok kusei nɨm nandɨ-dakleañda tɨmbi yomjɨ bi-semɨñ.” Tɨmbi mik amalɨ Yesulok dasindasin ep dannelɨñdok nɨsɨñgan tɨmbɨ-inda sañala tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Kloñbat plon ep tembɨm biu palɨmbi, amatamdɨ ipi, daukañga tɨñgɨlɨñ, Juda ama biesɨlɨ bo e-lakalakae tɨmbi eñgɨlɨñ, “Endɨ amatam ep kɨmɨkuk. Endɨ biañgan Mesia wɨn Yambattɨ nɨmbɨ taleñguk en sɨnɨkta, kɨndem kusei tɨmbɨ dakleumbi, enlok siñgin tɨke-kɨmɨlɨn.” ");
INSERT INTO nif_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Tɨmbi mik amalɨ wɨndɨñgot manda sañala tɨ-ñɨmgɨlɨñ, wɨn endɨ endoñ bɨmbi, wain tuk kimbɨñ mɨ-wet tɨñɨpi, ");
INSERT INTO nif_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","nɨñgɨlɨñ, “Tɨkap dɨk Juda amalok ama wapmañjɨla, kɨndem siñgiñga tɨke-kɨmɨt!” ");
INSERT INTO nif_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tɨmbi Yesulok kusal kumbam mɨndiñnan komba plon ñɨndɨñ youp wɨp bium pakuk, “Ñɨn Juda amalok ama wapmañjɨ.” ");
INSERT INTO nif_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tɨmbi kolan tɨndɨn ama tɨpet Yesu gɨta kloñbat plon ep tembum pakɨmɨk endoñnan nanin nolɨ Yesu nɨ-kolambi eñguk, “Dɨk Mesia wakan ba? Wɨndɨñda dɨtnalok siñgiñga tɨke-kɨmɨlɨñɨpi, nɨtɨ wakɨt nɨp kɨmɨt!” ");
INSERT INTO nif_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gan nollɨ nɨ-ñombɨmbi nɨñguk, “En wɨlɨ kɨmkɨmlok eu talelɨñ, wɨndɨñgangot dɨk tɨ-gamañ, wala tɨmbi dɨk Yambattɨ nek tɨ-gamekak wala nɨm mɨsɨlañ ba? ");
INSERT INTO nif_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nɨtɨ kundit kolan tɨñgɨmɨkta tɨmbi tuan dɨndɨmgan ñakan ombɨ-tɨkeamɨk, gan ama ñalɨ kolan no nɨm tɨñguk.” ");
INSERT INTO nif_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wɨndɨñ embi, Yesula nɨñguk, “Yesu, dɨk kusei kɨmɨpi, amatamgai yambɨ-dɨkñeñɨpi, nak nandɨ-namekañ.” ");
INSERT INTO nif_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Eumbi nɨñguk, “Nak biañgan ganlet: dɨk man sandap ñolondañgan nakɨta kunum walalan gɨnañ paletañ.” ");
INSERT INTO nif_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Tɨmbi kwet boñgɨp taumbi, maim bipmɨumbi, kwet tuop kɨlɨm e palɨñɨlɨmbi, 3 kilok tɨñguk. Nain wolonda tapma ilan sandum masimasip wopum boñgɨp plon wilapmɨumbi, pan tɨpet indañguk. ");
INSERT INTO nif_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Tɨmbi Yesulɨ wopumgan kɨtɨmbi eñguk, “Bep, nak gɨnañna tip kɨka plon kɨmɨtet.” Wɨndɨñ eu taleumbi kɨmguk. ");
INSERT INTO nif_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tɨmbɨmbi, mik amalok telak damanjɨlɨ nepek indañguk wɨn ka-nandɨ-talembi, Yambat nɨ-ta-lombi eñguk, “Biañgan ama ñɨn ama dɨndɨm no.” ");
INSERT INTO nif_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tɨmbi ama kɨmɨn gɨtɨk nepek wɨn kanelɨñdok bɨñgɨlɨñ endɨ nek indañguk wɨn gɨtɨk ka-nandɨmbi, sɨmba gawat tɨñgɨlɨñda tɨmbi kuanjɨ wɨwɨlembi, isɨnan undane ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gan Yesulok nolii gɨt tam nin Galili nanin en klem bɨñgɨlɨñ endɨ kambak mayañgan ipi, nepek indañguk wɨn ka-nandɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ama no kuñguk koi Josep, ama kɨndem ba dɨndɨm no Arimatia it kwet Judia kwelan nanin. Endɨ ama biesɨ Juda amatam yambɨ-dɨkñeñgɨlɨñ endok sambat, ");
INSERT INTO nif_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","gan noliilɨ Yesulok plon manda nek e-topgɨlɨñ ba kundit nek tɨ-ñɨmɨñgɨlɨñ endɨ en gɨta gɨnañ noñgan nɨm tɨñguk. Endɨ Yambattɨ amatam indañgan yambɨ-dɨkñeukak wala nandɨ-koñgomnatgan mandɨ pa tɨlɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ama walɨ Pilatoloñ ñambi, Yesulok dalandanla nɨ-nandumbi nandɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nandɨ-ñɨmɨumbi ñambi, kloñbat plon nanin tamat tɨke-pɨmbi, sandum satninlɨ tɨmɨp imbi, tɨke ñambi, sum no kawat gɨnañ kulukululɨnan kɨmɨkuk. Sum wɨn ama no gama nɨm kɨmɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wɨn Sabat patnandɨ nain indaup tɨmbɨmbi, tɨwɨlɨndɨkñe nain dumalañgukta endɨ wɨndɨñ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Tɨmbi tam Yesu gɨta Galili nanin bɨmbɨn endɨ Josep klembi, sum ba Joseptɨ telak nɨtek plon Yesulok dalandan kɨmɨkuk wɨn ka-talembi, ");
INSERT INTO nif_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ilan undane ñañgɨlɨñ. Ñambi, gwasap ba pɨñgɨp saple mɨlɨñ kɨndem Yesulok dalandanlok tɨ-jumupi, endɨkñe manda tañgonembi, Sabatta pat-nandɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kena nain kusei kɨmɨkɨmɨlɨnan kwet salaup tɨmbɨmbi, tamdɨ gwasap mɨlɨñ kɨndem tɨ-jumut tɨñgɨlɨñ wɨn epbi, Yesulok sumnan ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ñam tombi kañgɨlɨñ wɨn: kawat sum dai masipmɨmɨn wɨn manjaneum tambon kandañ ña pakuk. ");
INSERT INTO nif_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tɨmbi endɨ sum tombañ gɨnañ loñgɨlɨñ, gan Wopum Yesulok dalandan nɨm palɨm kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nɨm kañbi, nek indañguk wala nanandɨnjɨ nɨm dakleñɨlɨmbi, platik sɨnɨk ama tɨpet dasindasinjet kolsalennat endɨ endoñ indambi ikɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tɨmbi tamdɨ yambɨ-sɨlɨkñembi, kolan mɨsɨñɨpi, mɨlelem tɨ-sembi, dausɨ kwelan deiumbi, tɨpettɨ engɨmɨk, “Sɨndɨ ama kaik patak enda nekta sembɨsembɨn endok boñgɨpsɨnan bɨ lonjañ? ");
INSERT INTO nif_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Endɨ ñolok nɨm patak, ikan mɨlalak. Endɨ dama Galili kwelan gama palɨñɨpi, manda ñɨn sanguk wɨn nandɨ-tombɨt, ");
INSERT INTO nif_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Nak Ama Sɨsɨnɨk nepbi, yom amalok kɨsɨnan napɨlɨmbi, kloñbat plon nulɨ kɨmbambi, sandap tɨpet gɨt no ñaumbi, kɨmnan nanin bɨndambo mɨlalettok een.’” Eñalolɨ wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","tamdɨ Yesulɨ manda eñguk wɨn nandɨ-tombi, ");
INSERT INTO nif_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","sumnan nanin undane pɨ ñambi, Yesulok gwañgwañii 11 gɨta nosii dɨwɨn yambɨmbi, nepek gɨtɨk inda-semguk wolok kasat tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wɨn Malia Makdala nanin, Yoana, Yakobolok meñ Malia, wakɨt tam dɨwɨn en gɨta pakɨlɨñ walɨ wakan ama nin Yesulɨ kenalok enɨmumulɨn endoñ ñambi, kasat tɨ-sem pa tɨñgɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","gan enɨmumulɨn endɨ tamdok mandala nandum tlal tɨmbɨmbi, nɨm nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Petlolɨ wandingan embi mɨlapi, sumnan woñep ñambi mumuñem paunjɨnem, gɨnañ deium loumbi kañguk wɨn: sandum Yesulok dalandan tɨmɨp imimɨn walɨñgot pakuk. Wɨndɨñ kañbi, ilan undane ñambi, nepek wɨn indañguk wolok nanandɨ kena tɨñguk. ");
INSERT INTO nif_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tɨmbi sandap wolondañgan Yesulok noliit tɨpet endɨ Jelusalem bimbi, Emaus ñandepi ñañgɨmɨk. It kwet wɨn 11 kilomita wolok tuop Jelusalem tɨmbɨ dumalaum patak. ");
INSERT INTO nif_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Tɨm ñañɨpi, nɨsetkan nepek gɨtɨk indañguk wolok manda e-nandɨ tɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Manda eu ñañambɨ tɨmbi, e-kle-kot tɨm pa ñañɨlɨmbi, Yesu en wakan siñginjetnan ep tɨmbɨ dumalaumbi, en gɨta yakan ñañguk. ");
INSERT INTO nif_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Gan nepek nolɨ dauset masipmɨumbi, nɨm ka-nandɨ-tomgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tɨmbi endɨ enɨ-nandɨmbi eñguk, “Sɨtɨ manda nektok e-kle-kot tɨñɨpi ñamɨk?” Eumbi, gitakan sɨnɨk ipi, dei-blambla embi pakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tɨmbi endoñnan nanin no koi Kleopas endɨ Yesu nɨ-kañbi eñguk, “Ama yok asupgan Jelusalem bɨ pakañ. Endoñnan nanin dɨk noñganlɨ kena nain lap kandañ wandɨñ nepek indañguk wɨn nɨm nandɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Eumbi, “Wɨn nek indañguk?” wɨndɨñ enɨ-kañguk. Enɨ-kaumbi, tambane nɨñgɨmɨk, “Nepek Yesu Nasalet nanin enda inda-ñɨmɨñguk wala eamɨk. Endɨ plofet ama no, tɨmbi manda gembɨnat eñguk ba kundit engano tɨñguk walɨ amatamda ñɨndɨñ daut semguk: Yambattɨ enda nandum loloñ sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Nɨndɨ ñɨndɨñ nandɨ-kwambɨñ dambi mandɨñgɨmɨñ: Yambattɨ Yesu en wakan Islael amatam nɨndɨ kolan gɨnañ nanin nɨpma tɨkeuktok nɨmbɨ taleñguk, gan nɨndok tapma ama biesɨ ba nɨmbɨndɨkñenɨlɨ en Roma amalok kɨsɨnan kɨmɨlɨmbi, wɨlɨ kɨmbektok manda embi, kloñbat plon wɨlɨm kɨmguk. Nepek wɨn ikan sisañgan inda-ñɨmɨumbi, biañgan kɨm-sɨnɨk tañguk. ");
INSERT INTO nif_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Tɨmbi wakangot nɨm. Nɨndoñnan nanin tam dɨwɨn endɨ nɨp tɨmbɨ sɨlɨkñenembi, nanandɨnɨ nɨm daklelak. Man salasalanan sɨnɨk endɨ sumnan ñalɨñ, ");
INSERT INTO nif_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","gan Yesulok dalandan nɨm kañbi undane bɨmbi, ñɨndɨñ nɨnɨlɨñ, ‘Nɨndɨ nepek engano kamɨñ, wɨn eñalolɨ Yesu kaik patak nɨnɨmbɨm yambɨmɨñ.’ Tamdɨ wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","nɨndoñnan nanin ama dɨwɨn endɨ bo sumnan ñambi kalɨñ wɨn, nepek tamdɨ sumda nɨnɨlɨñ wolok tuop palak. Gan Yesu en nɨm kalɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tɨmbi Yesulɨ enguk, “Sɨndɨ ama kamasɨ, plofet amalok mandanjɨ gɨtɨk gɨnañjɨ gɨnañ baiñgan baiñgan pa nandɨ-dasiañ. ");
INSERT INTO nif_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Endɨ Mesialɨ amatam epmektok mɨlap wakan bembɨmbi, Yambattɨ koi gɨñgɨt wopum mɨuktok youkɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Yesulɨ wɨndɨñ embi, Moselok plon kusei kɨmɨpi, Mose en wakɨt plofet ama dɨwɨndɨ Yesu enlok plon manda youkɨlɨñ gɨtɨk wɨn enɨ-dakleñguk. Enɨ-dakleñɨlɨmbi ñakap, ");
INSERT INTO nif_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","it kwet ama tɨpettɨ ñandep nandɨñgɨmɨk wɨn tɨmbɨ dumalañguk. Tɨmbi endɨ kaum Yesulɨ gamañgot yousɨm ñauktok tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tɨke-kimbɨ dambi nɨñgɨmɨk, “Kak, nɨkɨta pat! Maim ip pɨumbi kɨlɨm elak.” Wɨndɨñ nɨ-gɨñgɨneumbi, en gɨta palep it gɨnañ loñguk. ");
INSERT INTO nif_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Tɨmbi nanañ nanep tɨñɨlɨmbi, Yesulɨ plaua nanañ no tɨkembi, Yambat we-ñɨmɨmbi ombɨmbi emum tɨkeñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tɨkeñɨpi, dauset tombɨmbi ka-nandɨ-tombɨmbi, dausetnangan paikuk. ");
INSERT INTO nif_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tɨmbi endɨ nɨsetkan e-nandɨ tɨmbi eñgɨmɨk, “Biañgan sɨnɨk. Endɨ telaknan nɨkɨta bɨñɨpi, manda embi, Yambattok manda wolok bien nɨnɨ-dakleñɨlɨmbi, walenet biañgan mɨlalak!” ");
INSERT INTO nif_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wɨndɨñ eñɨpi, wolongan mɨlapi, Jelusalem undane ñañgɨmɨk. Ña tombi, Yesulok gwañgwañii 11 gɨt amatam dɨwɨn en gɨta kɨmɨn tɨ pakɨlɨñ ep tɨmbɨ indañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tɨmbi amatam walɨ ama tɨpetta ñɨndɨñ engɨlɨñ, “Wopumdɨ biañgan kɨmnan nanin mɨlapi, Simondoñ indañak!” ");
INSERT INTO nif_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Wɨndɨñ eumbi, ama tɨpet endɨ telaknan nek indañguk wolok kasat tɨ-sembi engɨmɨk, “Endɨ plaua nanañ no ombɨmbi nɨmumek, nɨtɨ ka-nandɨ-tommɨk.” ");
INSERT INTO nif_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Gwañgwañiilɨ gamañgot endañgan manda e-palɨñɨlɨmbi, Yesu en wakan boñgɨpsɨnan bɨ indam ipi enguk, “Busuk pat-samun.” ");
INSERT INTO nif_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Wɨndɨñ eumbi, ka piasat tɨmbi, kolan mɨsɨñɨpi, “Ama wale kamɨñ” embi nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Tɨmbi endɨ enguk, “Neta gɨnañjɨ mɨlataumbi, gɨnañ tɨpet tañ? ");
INSERT INTO nif_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Kɨtna kesɨtna kawɨt, ñɨn natna sɨnɨk yañ! Gwɨlatna tɨke-kañbi, ñɨndɨñ nambɨ-daklewɨt: nak gaumna gɨt kwandatna nat, gan wale tip endɨ gaum ba kwandatsɨ nɨm nat.” ");
INSERT INTO nif_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eu taleumbi, kii kesii daut semumbi kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kañbi, sɨlɨsɨlɨ gɨt nandɨ-bendɨlɨ gɨnañjɨ tokñeñgukta tɨmbi gama nɨm nandɨ-kwambɨñ dañgɨlɨñ. Tɨmbi endɨ enɨ-kañbi eñguk, “Sɨndok nanañ no patak ba?” ");
INSERT INTO nif_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Eumbi, mɨkbalak sinjin pan no mɨumbi ");
INSERT INTO nif_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","tɨkembi, dausɨnangan nañguk. ");
INSERT INTO nif_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Tɨmbi gwañgwañiila enbi eñguk, “Nak dama sɨn gɨta kuñɨpi, ñɨndɨñ sangut: Mose wakɨt plofet ama ba ama dɨwɨn gɨtɨk endɨ nokok plon e-yout tɨmbi, manda youkɨlɨñ patak manda gɨtɨk wolok bien indauptok een.” ");
INSERT INTO nif_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wɨndɨñ embi, Yambattok manda youyoulɨn patak wolok kusei nandɨ-kɨliñ enelɨñdok nanandɨnjɨ tɨmbɨ pañgɨtaumbi ");
INSERT INTO nif_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","enguk, “Nepek ñɨndɨñ indauktok youyoulɨn patak: Mesialɨ pɨñgɨp gawat bembi kɨmbi, sandap tɨpet gɨt no tɨmbɨmbi, kɨmnan nanin mɨlalekak. ");
INSERT INTO nif_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tɨmbi noliilɨ Jelusalem it kwelan kusei kɨmɨpi, endok koi plon amatam gɨtɨk kwet tuop kuañ enda ñɨndɨñ eu pɨukak, ‘Sɨndɨ gɨnañjɨ tambanenekalɨñda, Yambattɨ yomjɨ bi-samekak.’ Wɨndɨñ indauktok youyoulɨn. ");
INSERT INTO nif_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Sɨndɨ mek nepek gɨtɨk wɨn indañguk ba indaukak wolok gembɨ ipi e-daklenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nandɨwɨt! Bepnalɨ nek samektok e-kwambɨñ dañguk wɨn natna nɨ-mulambi, sɨndoñ pɨukak. Gan sɨndɨ Jelusalem ñɨñgan papi mandɨñɨlɨmbi, Yambattok gembɨn kunum gɨnañ nanin wɨn dasindasin nomɨk dasi-samekak wolok tuop.” ");
INSERT INTO nif_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Tɨmbi Yesulɨ gwañgwañii yanañgɨpi, Betani it kwet kandañ ñam tombi, kii tɨke-lombi, ep gwɨlam tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ep gwɨlam tɨ-semñɨpi yambɨk biumbi, Yambattɨ kunum gɨnañ tɨke-loumbi loñguk. ");
INSERT INTO nif_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Loñɨlɨmbi, gwañgwañiilɨ mɨlelem tɨ-ñɨmbi, sɨlɨsɨlɨ wopum tɨñɨpi, Jelusalem it kwelan undane ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ñambi, sandap tuop tapma it sañ jimba gɨnañ lombi, wolok Yambat nɨ-kɨndem dambi kuñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kwet nain kusei kɨmɨkɨmɨlɨnan Man Mandan endɨ ikan pakuk. Endɨ Kunum Yambat gɨt yakan kuñgɨmɨk, en bo Yambat. ");
INSERT INTO nif_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","En wakan kusei kɨmɨkɨmɨlɨnan Kunum Yambat gɨta yakan kuñguk, ");
INSERT INTO nif_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","tɨmbi endok mandanla nepek gɨtɨñgɨtɨk ep tɨmbɨ inda-taleñguk, wɨn telak nolok plon nepek no nɨm tɨmbɨ indaindan. ");
INSERT INTO nif_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Man Mandan en wakan kuñgu biañgan sɨsɨnɨk wolok kusei, tɨmbi kuñgu walɨ amatamdok kolsalen sɨsɨnɨk. ");
INSERT INTO nif_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tɨmbi kolsalen walɨ kɨlɨm gɨnañ kolɨ sale-ta-ñaumbi, kɨlɨmdɨ en makleuktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Kolsalen wolok gembɨn ilɨmektok Kunum Yambattɨ ama no koi Yoane nɨ-mulɨm bɨ indambi, kolsalen wolok kusei enɨ-daklembi, amatam gɨtɨkgandɨ endok mandan nandɨmbi, kolsalen wɨn nandɨ-kɨlɨktɨ tɨñmɨnelɨñdok wɨndɨñ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Kolsalen wɨn Yoane en nɨm, tambo endɨ kolsalen wolok kusei eu inda-dakleuktok indañguk. ");
INSERT INTO nif_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kolsalen sɨsɨnɨk, nindɨ amatam gɨtɨk kolɨ sale-semlak, endɨ kwelan indaupi tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Man Mandanlɨ kwet ñɨn tɨmbɨ indañguk, tɨmbi en wakan kwelan ama indambi, kwelan kuñguk, ganmek kwelalok amatamdɨ en wɨn nin sɨnɨk wɨn nɨm ka-nandɨ-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Wɨn endɨ enlok kwelnan wɨngan pɨ indambi kuñguk, gañgan enlok amatamñiilɨ siñgi wɨlmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gan ama en not tɨñmɨñgɨlɨñ, wɨn endok koi tɨke-kwambɨñ dañgɨlɨñ, endɨ gɨtɨk Man Mandanlɨ ep tɨmbɨ pañgɨtaumbi, Kunum Yambattok gwañgwa bɨsalii indañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Wɨn endɨ meñ beptok wekat sɨnɨk nɨm indañgɨlɨñ, ba amalok ka-galksɨla ba nanandɨnjɨla nɨm, tambo Kunum Yambat engan ep tɨmbɨmbi, enlok gwañgwa bɨsalii indañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Man Mandanlɨ kwelan ama gwɨlap ba gaummat indambi, nɨndok boñgɨpnɨnan dou mɨlat tɨñguk. Tɨmbi nɨndɨ dautnɨlɨ kañɨtnambi, endɨ enlok kusal engano wɨn tɨmbɨ inda-dakleumbi kañgɨmɨñ, wɨn endɨ Bep Yambattok Nɨñañ engano sɨnɨk. Bep en nɨ-mulɨm pɨm indambi, yousɨyousɨñgan Beulok gɨnan sɨloñ ba kusal sɨsɨnɨk wɨn tɨmbɨ inda-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Endok plon Yoanelɨ ñɨndɨñ e-daklembi kɨtɨmbi eñguk, “Wɨn ama wala wakan nak ñɨndɨñ sangut, ‘Ama nokok siñgi kandañ indalak endɨ nak gama nɨm indañɨlambi ikan pakuk, wala tɨmbi endɨ nak napma klelak.’” ");
INSERT INTO nif_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tɨmbi Man Mandanlɨ gɨnañ sɨloñ molom sɨnɨkta tɨmbi bɨsɨk kusei kuseilɨ nɨndɨ gɨtɨktok nain nain inda-nɨmguk. ");
INSERT INTO nif_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Wɨn Moselɨ Kunum Yambattok endɨkñe mandan Juda nɨndok bep pañniila emguk, tɨmbi Yesu Klistolɨ Kunum Yambattok gɨnan sɨloñ ba kusal sɨsɨnɨk wɨn tɨmbɨ inda-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nimbek nolɨ Bep Yambat nain nola no nɨm kañgɨlɨñ. Wɨn enlok Nɨñañ engano sɨnɨk en wakan Bep Yambattok kusal tɨmbɨ inda-dakleñguk. Neta, endɨ bo Yambat sɨnɨk, tɨmbi Beu gɨta ñasɨñgan sɨnɨk patak. ");
INSERT INTO nif_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda ama biesɨ Jelusalem pakɨlɨñ endɨ Yoanelok kusal, wɨn endɨ Mesia indaindalok een en wakan ba no, wɨn nandɨ-daklenelɨñdok nandɨñgɨlɨñ, wala tɨmbi endɨ tapma ama gɨt Livai ama dɨwɨn Yoaneloñ enɨ-mulɨm ña tombi, “Dɨk nin sɨnɨk?” nɨ-nandɨñgɨlɨñ. Tɨmbi Yoanelɨ ñɨndɨñ tambane enguk: ");
INSERT INTO nif_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","endɨ enlok kusal nɨm kɨmɨt-sembɨmbi, endɨ e-daklembi enguk, “Natna wɨn Mesia nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Wɨndɨñ eumbi, nɨ-nandɨmbi eñgɨlɨñ, “Tɨkap dɨk Mesia nɨmda, dɨk nin sɨnɨk? Ba dɨk plofet Elia bɨndambo indauktok een en ba?” Eumbi enguk, “Nak en nɨm.” Eumbi nɨñgɨlɨñ, “Wɨndɨñda dɨk plofet Mose nomɨk wɨn indauktok een en ba?” Eumbi, “Nak en bo nɨmgot” enguk. ");
INSERT INTO nif_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Wɨndɨñ eñgukta, bɨndambo nɨ-nandɨmbi eñgɨlɨñ, “Dɨk nin sɨnɨk? Nɨndɨ ama nɨnɨ-mukɨlɨñ enda manda tambon enɨneñdok dɨk kusaka nɨnbɨm nandɨna. Dɨk dɨtnala nɨtek elañ?” ");
INSERT INTO nif_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Eumbi, Yoanelɨ manda no plofet Aisaialɨ youyoulɨn wɨn kɨmɨt-klembi, ñɨndɨñ enguk, “‘Ama no kwet ama nɨmnatnan papi, Wopumdok telal tɨ-dɨndɨm ewɨt! wɨndɨñ kɨtɨlak’ wɨn natna wakan.” ");
INSERT INTO nif_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Tɨmbi Falisi amalɨ ama enɨ-mulɨmbi bɨñgɨlɨñ walɨ ");
INSERT INTO nif_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yoane ñɨndɨñ nɨ-nandɨñgɨlɨñ, “Tɨkap dɨk Mesia en nɨm, ba Elia ba plofet wɨn bo nɨm, wɨndɨñda dɨk nekta amatam tuk pa i-semlañ?” ");
INSERT INTO nif_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Eumbi tambane enguk, “Nak wɨn tukgot pa i-semlet, gan ama no sɨndok boñgɨpsɨnan kulak - sɨn endok kusal nɨm ka-nandɨ-dakleañ - ");
INSERT INTO nif_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","endɨ wakan nokok singi kandañ indaupi tɨlak, tɨmbi nak pɨmbɨñen ñandin ñalɨ endok kesɨi gwɨlaplok toan pɨsalɨmettok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Wɨn Yoanelɨ Betani it kwet, Jodan tuk maim lambɨlambɨn kandañ papi, tuk i-semlɨñguk kwet wolok wɨndɨñ indañguk. ");
INSERT INTO nif_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kwet salaumbi, Yoanelɨ Yesu bɨum kañbi, noliila ñɨndɨñ enguk, “Wɨ kawɨt: en Kunum Yambattok Sipsip Nɨñañ, nin endɨ kwelalok amatam gɨtɨk endok yomjɨlok mɨlap wɨn apma tɨke-taleukak! ");
INSERT INTO nif_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wɨn ama walañgan nak ñɨndɨñ eñgut, ‘Ama nindɨ nokok singi kandañ indalak, endɨ nak gama nɨm indañɨlambi ikan pakuk, wala tɨmbi endɨ nak napma klelak.’ ");
INSERT INTO nif_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Dama natna bo en nin sɨnɨk wɨn nɨm ka-dakleñgut, gan endok kusal Islael amatamda tɨmba inda-dakleuktok nak ñolok bɨmbi, tuk i-sem-i-sem kena kusei kɨmɨkut.” ");
INSERT INTO nif_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tɨmbi Yoanelɨ yousɨmbi, Yesulok plon ñɨndɨñ e-dakleñguk, “Dɨndɨm Woñdɨ mambaip wandin kunum gɨnañ nanin pɨmbi, endok plon pɨ palɨm kañgut. ");
INSERT INTO nif_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Damañgan nak bo en Mesia wɨn nɨm nandɨñmɨñgut, gan tuk i-sem-i-semlok nanɨ-mukuktɨ ñɨndɨñ nanguk, ‘Ama nindok plon nokok Woñnalɨ pɨ palɨmbi kaukañ en wakandɨ amatam Dɨndɨm Woñlɨ i-semekak.’ ");
INSERT INTO nif_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Eumbi, natna dautnalɨ wɨndɨñ indaumbi ka-taleletta tɨmbi ñɨndɨñ pa e-daklelet: ñɨn Kunum Yambattok Nɨñañ sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Salaunda Yoanelɨ kwet pakuknan wolok bɨndambo ñam ikuk. Tɨmbi gwañgwa en kle-ta-kuñgɨlɨñ endoñnan nanin tɨpettɨ en gɨta ikɨmɨk. Ilɨñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yoanelɨ Yesu yapma kle ñaum kañbi, gwañgwañiitta ñɨndɨñ enguk, “Wɨn kandemɨk! Kunum Yambattok Sipsip Nɨñañ wakan ñak!” ");
INSERT INTO nif_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eumbi, endɨ manda wɨn nandɨmbi, Yesu kle ñañgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Tɨmbi Yesulɨ tambanembi, ama tɨpet en kle bɨumbi yambɨmbi, enɨ-nandɨmbi eñguk, “Sɨtɨ nekta bamɨk?” Eumbi nɨñgɨmɨk, “Rabai” (wɨn nɨndok mandanɨ plon ‘endaut’), “dɨk it delok dou mɨlat pa tɨlañ?” ");
INSERT INTO nif_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Eumbi enguk, “Bɨmbi kandemɨk!” Yesulɨ wɨndɨñ eumbi, endɨ en kle ña it wɨn kañgɨmɨk. 4 kilok tɨmbɨmbi, en gɨta palɨmbi, tim tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ama tɨpet Yoanelok mandan nandɨmbi, Yesu kle ñañgɨmɨk, endoñnan nanin no wɨn Simon Petlolok kwayañ koi Andlu. ");
INSERT INTO nif_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Endɨ Yesu gɨta pakap kañbimbi, dɨndɨmgan ñam dal Simon lonjɨ-ta-ña kañbi nɨñguk, “Nɨtɨ Mesia ip kamɨk.” (Mesia wɨn Glik manda plon Klisto kɨtɨañ.) ");
INSERT INTO nif_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wɨndɨñ embi nañgɨlɨmbi, Yesuloñ ña tomgɨmɨk. Ña tombɨmbi, Yesulɨ Simon daut kwambɨñ kañbi nɨñguk, “Dɨk Simon Yoanelok nɨñañ. Koka komblin Sifas kɨtɨnekalɨñ.” (Kot ‘Sifas’ wɨn Grik manda plon Petlo.) ");
INSERT INTO nif_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Salaumbi, Yesulɨ Galili kwelan ñaupi nandɨmbi ñañguk. Ñañɨpi, Filip tɨmbɨ indaumbi nɨñguk, “Dɨk bɨ nak nep kle kuukañ.” ");
INSERT INTO nif_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filiptok it kwet wɨn Betsaida, wɨn Andlu gɨt Petlo endok iset kweset.) ");
INSERT INTO nif_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tɨmbi Filiptɨ ña Natanael tɨmbɨ indaumbi nɨñguk, “Ama walɨñgan Moselɨ endɨkñe manda gɨnañ ba plofet amalɨ bo indauktok youyoulɨn, wɨn Mesia en nɨndɨ ip kamɨñ. En Joseptoñ nɨñañ koi Yesu Nasalet it kwelan nanin.” ");
INSERT INTO nif_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Eumbi nɨ-nandɨmbi eñguk, “Akai! Ba nepek kɨndem no it kwet koi gɨñgɨl nɨmnat wandinnan indauktok tuop ba?” Eumbi, Filiptɨ nɨñguk, “Dɨtna bɨmek ka!” ");
INSERT INTO nif_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tɨmbi Yesulɨ Natanael bɨum kañbi, endok plon ñɨndɨñ eñguk, “Yakñe! Ama ñɨn endɨ Islael ama sɨsɨnɨk. Juluñɨt endok plon no nɨm palmɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Wɨndɨñ eumbi nɨ-nandɨmbi eñguk, “Nɨtek tɨmbi dɨk nokok kusatna wandin nandɨ-namlañ?” Eumbi nɨñguk, “Filiptɨ gama nɨm kɨtɨ-gamñɨlɨmbi, dɨk komba fik kapmainan pipalɨmbi gambɨt.” ");
INSERT INTO nif_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaellɨ manda wɨn nandɨmbi nɨñguk, “Endaut. Dɨk Kunum Yambattok Nɨñañ sɨnɨk, Islael nɨndok Ama Wapmañnɨ mandɨ pakamɨñ wɨn dɨk wakan!” ");
INSERT INTO nif_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Eumbi, Yesulɨ tambane nɨñguk, “Ba nak komba fik kapmainan pipalɨm gambɨt wɨndɨñ ganɨtta tɨmbi, dɨk wɨndɨñ nandɨ-kwambɨñ dalañ ba? Dɨk nepek gɨtikñin dɨwɨn siñgimek indaumbi kaukañ walɨ man nek indalak wɨn makleukak.” ");
INSERT INTO nif_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tɨmbi yousɨmbi nɨñguk, “Wɨn biañgan sɨnɨk. Nak ñɨndɨñ sanlet: sɨndɨ kanekalɨñ, wɨn kunum yama dɨlɨ tombɨmbi, Kunum Yambattok eñaloñiilɨ kwelan nanin kunum gɨnañ lombi, nak Ama Sɨsɨnɨk nokoñnan undane pɨmbi, wɨndɨñ lo ña pɨ pa tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kena nain tɨpet taleumbi, Galili kwelan it kwet no koi Kana wandɨñ ama nolɨ kɨkokot tɨmbi, nanañ sina wopum tɨñguk. Yesu meñlɨ wandɨñ pakuk, ");
INSERT INTO nif_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","tɨmbi Yesu gɨt gwañgwañii bo enɨ-tiañeum bɨmbi, wandɨñ pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Pakap, wain tuk taleumbi, Yesu meñlɨ Yesula ñɨndɨñ nɨñguk, “Wain ememlok wɨn ip talek.” ");
INSERT INTO nif_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Eumbi tambane nɨñguk, “Me, wɨn nokok nepek nɨm. Kusatna tɨmba inda-daklelok nain wɨn gama nɨm indak.” ");
INSERT INTO nif_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Eumbi, Yesu meñlɨ it wolok kena gwañgwala ñɨndɨñ enguk, “Endɨ nepek no sanbɨmbi, wolok tuop tɨnekalɨñ!” ");
INSERT INTO nif_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tɨmbi it wolok gɨnañ kawat kambot tuknat kɨt tombon, tombon noñgan pakuk, noñgan noñgan wolok wopum wɨn 80 ba 120 lita, wolok tuop. Wɨn Kunum Yambattok dainan tɨ-jamilan tɨndɨlok Juda amatamdɨ tuk walɨ kɨsɨ kesɨsɨ, nepek dɨwɨn wakɨt wɨlɨkañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tɨmbi Yesulɨ kambot wɨn kañbi, kena gwañgwala enguk, “Kambot ñɨ pakañ wɨn tuk gɨt-talewɨt!” Eumbi, kambot gɨtɨk wɨn gɨlɨm man plon tokñe-taleumbi ");
INSERT INTO nif_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","enguk, “Ale, tuk lakat no kambot gɨnañ nanin gɨpi, nanañ kandɨkñe amaloñ tɨke ñawɨt!” Eñguk wolok tuop tɨke ñambi, ");
INSERT INTO nif_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nanañ kandɨkñe amala mɨumbi, tuk walɨ ikan wain indañguk wɨn nakanaka tɨñguk. Nakanaka tɨmbi, wain tuk wɨn denanin wɨn nɨm nandɨñguk, wɨn kena gwañgwa gɨkɨlɨñ endɨñgot nandɨñgɨlɨñ, wala tɨmbi kandɨkñelɨ ama kɨkokot tɨñguk wɨn kɨtɨñmɨmbi ");
INSERT INTO nif_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","nɨñguk, “Kɨmɨn beu gɨtɨktɨ wain tuk kɨndem wɨn dama danbi, yoksiila emum nam, kamakama tɨmbɨmbi, wain kolan siñgimek danbi pa emañ. Gan dɨk wain tuk kɨndem tɨke-kimbɨñ dambi, kombɨtmek tɨke bɨlañ.” ");
INSERT INTO nif_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesulɨ Galili kandañ, Kana it kwelan tuk tɨmbɨ wain indañguk walɨ endok jimba kundil dama sɨsɨnɨk. Kundil wɨn tɨñɨpi, enlok kusal engano wɨn tɨmbɨ inda-dakleumbi, gwañgwañiilɨ kañbi nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sina walɨ taleumbi, Yesu meñ kwayañii ba gwañgwañii endɨ Kapaneam it kwelan ña tombi, sandap nɨtepekgot yakan wandɨñ pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juda amatamdok Kamaikamai gwɨlat walɨ indaup tɨmbɨmbi, Yesulɨ gwañgwañii gɨta Jelusalem lo ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ña tombi, tapma it sañ jimba gɨnañ lombi yambɨñguk, wɨn ama dɨwɨndɨ tapmalok makauk wakɨt sipsip ba mambaip tualok ep bɨ yapɨkɨlɨñ, tɨmbi ama dɨwɨndɨ mɨnem walan kusei kusei tombo mɨñ kena tɨ-pakɨlɨñ. Yesulɨ wɨn yambɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","toa no binjaneum gɨlɨm daumbi, ama wakɨt makauk ba sipsip gɨtɨk wɨn tapma it sañ jimba gɨnan nanin yandɨp kleum poña-taleumbi, ama mɨnem tombo mɨñ kena tɨ-pakɨlɨñ endok mɨnem kwandainjɨ gɨtɨk wɨn wɨlɨ papuseneumbi, endok kɨmɨkɨmɨtsɨ ep tambokuk. ");
INSERT INTO nif_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Tɨmbi endɨ ama mambaip tualok kɨmɨkɨlɨñ wɨn enombɨmbi eñguk, “Ei! Nepenepek gɨtɨk ñɨn platikan mep ña-talewɨt, tɨmbi nokok Bepnalok il ñɨn tɨmbɨm kɨmɨlɨ tua it sɨlanin inda-ta-bɨlak, wɨndɨñ nombo nɨm tɨnekalɨñ!” ");
INSERT INTO nif_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wɨndɨñ eumbi, gwañgwañiilɨ plofet manda no Kap nolok gɨnañ youyoulɨn patak wɨn nandɨ-sɨwɨkɨlɨñ. Manda wolok gɨnañ Mesialɨ Kunum Yambatta ñɨndɨñ nɨñguk, “Nak dɨkok ika tɨke-kimbɨñ dambi, it walɨ giñgi sɨnɨk palektok gɨñgɨneletta tɨmbi kuñguna kolaukak.” ");
INSERT INTO nif_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yesulɨ tapma ilan wɨndɨñ tɨñgukta tɨmbi Juda ama biesɨlɨ nɨmbi eñgɨlɨñ, “Dɨk jimba kundit nɨtek tɨmbɨmbi ka-dakleamɨñ, wɨn Kunum Yambattɨ tapma it kandɨkñe kena wandin tɨndɨlok ganbɨ taleñguk?” ");
INSERT INTO nif_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Eumbi tambane enguk, “Sɨndɨ Kunum Yambattok il ñɨn wialɨmbi, sandap tɨpet gɨt no wolok gɨnañnan nak bɨndambo mamba ilekak.” ");
INSERT INTO nif_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Eumbi nɨñgɨlɨñ, “Akai! Nɨndɨla tapma it ñɨn gwɨlat 46 gɨnañnan kɨndit-ta-bamɨñ, gan dɨkta sandap tɨpet gɨt no wolok gɨnañnan mambɨ ilepi elañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Gan Yesulɨ tapma itta sɨnɨk nɨm eñguk, tambo endɨ enlok pɨñgɨula eñguk. ");
INSERT INTO nif_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Tɨmbi Kunum Yambattɨ en kɨmnan nanin tɨmbɨ mɨlakuk, wolok siñgi kandañ gwañgwañiilɨ manda wɨn eñguk wɨn nandɨ-sɨwɨpi, Mesialok mɨlamɨlat plon manda youyoulɨn patak wakɨt manda Yesu en eñguk wɨn nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yesulɨ Kamaikamai gwɨlatta Jelusalem it kwelan palɨñɨpi, jimba kundit asup tɨmbɨmbi, amatam asuptɨ wɨn kañgɨlɨñda tɨmbi en wɨn Mesia sɨnɨk wɨn nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gan Yesu endɨla amatamdok nanandɨnjɨ plon nɨm panjañganeñguk, ");
INSERT INTO nif_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","wɨn kusei ñɨndɨñda: amatam gɨtɨk endɨ nɨtein wɨn Yesu en nandɨ-kɨliñ eñguk, tɨmbi endok gɨnañ nanandɨnjɨ yambɨ-nandɨ-dakle-taleñgukta tɨmbi, nɨsɨlok kusasɨ plon nimbek nolɨ Yesula nanandɨ mɨuktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","It kiyau wopum Juda amatam yambɨ-dɨkñeñgɨlɨñ, endoñnan nanin Falisi ama no koi Nikodemus. ");
INSERT INTO nif_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Endɨ tim nola Yesuloñ bɨmbi nɨñguk, “Endaut. Nɨndɨ gambɨ-nandɨ-dakleamɨñ, wɨn Kunum Yambattɨ dɨk endaut kuuñdok ganɨ-mupi, dɨkɨta patak. Neta, jimba kundit dɨk pa tɨlañ, wandin wɨn ama nolɨ nɨsɨlok gembɨnjɨ plon tɨnelɨñdok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Eumbi, Yesulɨ tambane nɨñguk, “Wɨn biañgan sɨnɨk. Tɨmbi Kunum Yambattok kandañ nak ñɨndɨñ ganba: tɨkap ama nolɨ indainda komblin bɨndambo nɨm indaukta, endɨ endok gɨñgɨt indauktok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Eumbi, Nikodemuslɨ nɨ-nandɨmbi eñguk, “Akai, ama gɨlɨktɨ indainda komblin wɨn telak nɨtek plon tuop indauk? Endɨ meñlok sɨmbai gɨnañ bɨndambo pɨumbi, meñlɨ apmektok tuop nɨm bek.” ");
INSERT INTO nif_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Eumbi, Yesulɨ tambane nɨñguk, “Wɨn biañgan sɨnɨk. Nak ñɨndɨñ ganba nandɨ: tɨkap Kunum Yambattɨ tuk wakɨt Woñɨnlɨ ama nɨm tɨmbɨ kaiktaumbi, indainda komblin indaukta, endɨ Kunum Yambattok gɨñgɨt indauktok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Wɨn amalok pɨñgɨu gwɨlap wɨn enlok meñ beuloñnan nanin, tɨmbi gɨnañ tiptok kuñgu sɨsɨnɨk wɨn Dɨndɨm Woñloñnan nanin. ");
INSERT INTO nif_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nak ‘Sɨndɨ indainda komblin indanelɨñdok’ ganɨt, wala nandɨ-gɨtɨñgɨtɨp nɨm tɨmbekañ. ");
INSERT INTO nif_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Sasalelɨ enlok nanandɨn klembi, pendɨp ñalak. Walɨ denanin bɨmbi delok ñalak wɨn dɨk nanduñdok tuop nɨm, dɨk gɨñgɨlɨñgot pa nandɨlañ. Wɨndɨñgangot Dɨndɨm Woñdɨ telak nɨtek plon amala kuñgu sɨsɨnɨk wɨn mɨumbi, komblin indalak, wɨn ama nolɨ kauktok ba nandɨ-dakleuktok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemuslɨ nɨ-nandɨmbi eñguk, “Woñdɨ kuñgu sɨsɨnɨk mɨlak walɨ nɨtek indauk?” ");
INSERT INTO nif_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Eumbi tambane nɨñguk, “Dɨk Islael amatamdok endautsɨ loloñ, gañgan nepek wɨn nɨm nandɨ-daklelañ bek? ");
INSERT INTO nif_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Biañgan ñak. Nak ñɨndɨñ ganba: nɨndɨ nepek nandɨ-kɨliñ eamɨñ wolok plon manda eamɨñ, ba nepek dautnɨlɨ kañgɨmɨñ wolok gembɨn ikamɨñ, gan sɨndɨ nɨndok mandanɨ nɨm pa nandɨ-dasiañ. ");
INSERT INTO nif_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nak nepek kwelan ñolok indañ wolok plon kasat tɨ-samgut, gan sɨndɨ nokok mandana nɨm nandɨ-kwambɨñ dañda tɨmbi, nɨtek plon pañgɨtambi, nepek kunum gɨnañ indañ wɨn sanbam nandɨ-kwambɨñ danelɨñ? ");
INSERT INTO nif_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ganmek sɨndoñnan nanin ama nolɨ kunumdok nepek ka-nandɨlok wandɨñ no nɨm loñgɨlɨñ. Nɨm. Nak Ama Sɨsɨnɨk noñganlɨñgot kunum gɨnañ kukap, kwelan ñolok pɨñgutta tɨmbi kunumdok nepek gɨtɨk wɨn nandɨ-talelet. ");
INSERT INTO nif_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Tɨmbi nak nandɨ-kɨlɨktɨ tɨ-namañdɨ kuñgu taletalen nɨmnat wɨn kasɨlenelɨñdok Kunum Yambattɨ Ama Sɨsɨnɨk nak nep lololok elak. Wɨn Islael amatamdɨ kwet sɨlaninnan kuñɨlɨmbi, amatam malettɨ eium kɨmnep tɨñgɨlɨñ wɨn ep kɨmɨlektok Moselɨ malet walawalan no tɨmbi, komba bem mioñ nolok plon tɨke-lo mambɨ ikuk, walan wɨndɨñgangot amatamdɨ kuñgu taletalen nɨmnat wɨn kasɨlenelɨñdok nep mambɨ loutat.” ");
INSERT INTO nif_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kunum Yambattɨ kwelalok amatam gɨtɨk engano sɨnɨk ep galk tañguk wɨn ñɨndɨñ tɨmbɨ inda-dakleñguk: endɨ enlok Nɨñañ engano sɨnɨk amatamda kɨm-semektok nɨ-mulɨmbi indañguk. Wɨndɨñda no en Nɨñañ nandɨ-kɨlɨktɨ tɨñmɨlakta, endɨ kolandok gɨñgɨt nɨm tɨmbekak, tambo endɨ kuñgu taletalen nɨmnat wɨn kasɨleukak. ");
INSERT INTO nif_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wɨn Kunum Yambattɨ Nɨñañ amatamdok kolanjɨlok kɨnjan eu taleuktok kwelan nɨm nɨ-mukuk, tambo endɨ kolanjɨlok kɨnjannan nanin yapma tɨkeuktok nɨ-mulɨmbi indañguk. ");
INSERT INTO nif_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nin endɨ Nɨñañ nandɨ-kɨlɨktɨ tɨñmɨmbi kulakta, Kunum Yambattɨ yomɨnlok kɨnjan tambon ombɨ-tɨkeuktok nɨm eu talelak. Gan nin endɨ Nɨñañ nɨm nandɨ-kɨlɨktɨ tɨñmɨmbi kulakta, endɨ Kunum Yambattok Nɨñañ engano sɨnɨk endok koi nɨm nandɨ-kɨlɨktɨ tɨlakta tɨmbi, Kunum Yambattɨ ikan yomɨnlok kɨnjan tambon ombɨ-tɨkeuktok eu taleñguk. ");
INSERT INTO nif_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wɨndɨñ tɨñguk wɨn kusei ñɨndɨñda: endɨ kolsalen kwelan ikan nɨ-mulɨmbi indañguk, gan kuñgunjɨ kolanda tɨmbi amatamdɨ kolsalen siñgi wɨlɨmbi, kɨlɨm kasɨleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Neta, ama gɨtɨk tɨ-mɨpmɨle tañ endɨ ep tɨndɨnjɨlok kusei inda-dakleñmek wala mɨsɨñɨpi, kolsalenla nandɨ-kunjit sɨnɨk tambi makleañ. ");
INSERT INTO nif_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gan nin endɨ Kunum Yambattok kusal sɨsɨnɨk wɨn kɨmɨt-klembi, tɨke-kwambɨñ dalakta, endɨ Kunum Yambat tañgoneñɨpi, kundit kɨndem pa tɨlak walɨ inda-dakleuktok kolsalen gɨnañ pa bɨlak. ");
INSERT INTO nif_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kamaikamai gwɨlat taleumbi, Yesulɨ gwañgwañii yanañgɨpi, Jelusalem nanin pɨmbi, Judia kwelan ña tombi, nain dɨwɨn gwañgwañii gɨta wandɨñ kuñɨpi, amatam tuk i-semlɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Yoane tuk i-sem-i-sem it kwambɨñ gɨnañ gama nɨm kɨmɨkɨlɨñda tɨmbi, endɨ bo kena wɨn tɨ-ta-kuñguk, wɨn it kwet koi Salim kandañ tuk asup pakukta tɨmbi, endɨ tuk no koi Ainon wolok palɨmbi, amatamdɨ yousɨyousɨñgan endoñ bɨumbi, tuk i-semlɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Tɨmbi nain nola Yoanelok gwañgwañii dɨwɨn gɨt Juda ama nolɨ kusei kɨmɨpi, kɨsɨ kesɨsɨ ba nepek kusei kusei dɨwɨn wɨn nɨtek wɨlɨpi, Kunum Yambattok dainan jamilan indaindalok plon e-tañan tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wɨndɨñ tɨmbi, Yoaneloñ ñambi nɨñgɨlɨñ, “Endaut, ama walɨ ba, dɨkɨta Jodan tuk tambon kandañ kuumbi, endok kusei pa nɨnɨ-dakleñguñ, wɨn Yesu endɨ bo nain ñɨndɨñgɨtañgan tuk i-sem-i-sem kena tɨmbɨmbi, amatam gɨtɨktɨ endoñ pa ñañ yañ!” ");
INSERT INTO nif_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Eumbi tambane enguk, “Wɨn kɨndem. Tɨkap Kunum Molomdɨ ama nɨm tɨke gwɨlam tɨñmekta, kenanlok bien walɨ indañmektok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Sɨnɨla nak ñɨndɨñ ewambi nandɨñgɨlɨñ, ‘Nak Mesia en nɨm, tambo nak endok telak dama tɨñmettok nanɨ-mulɨmbi bɨ indañgut.’ ");
INSERT INTO nif_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mesia nɨtok plon nak e-yout manda nɨtek ewɨt? Mesia wɨn, endɨ ama no tam gɨñgɨt wɨlɨmɨmɨn wandin. Tɨmbi ama wolok nol endok kandañ ipi, mandan nandɨlak wandin natna Yesulok gembɨn ipi, amatamdɨ endok mandan nandɨnepi ñañ wɨn nandɨlet, nain wolonda nandɨ-sɨlɨsɨlɨlɨ nokok gɨnañna tokñelak. ");
INSERT INTO nif_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Neta, Kunum Yambattɨ endok koi gɨñgɨt walɨ wopum daumbi, nokok kotna gɨñgɨt walɨ pɨpɨ euktok nandɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kunum gɨnañ nanin pɨmbi indalaktɨ ama gɨtɨk yapma klelak. Neta, kwelan ama endɨ kwettok gɨñgɨtñii, tɨmbi kwelalok nepek plon manda eañ, gan kunum gɨnañ nanin pɨmbi indañguktɨ wandin nɨm, tambo endɨ kwelan ama gɨtɨk yapma klembi, ");
INSERT INTO nif_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","nepek kunum gɨnañ kañguk ba nandɨñguk wolok plon elak, gañgan mandan wɨn noñgan noñgandɨñgot nandɨ-dasiañ. ");
INSERT INTO nif_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","34","Kunum Yambattɨ Nɨñañ nɨ-mukuk enda Dɨndɨm Woñ tokñetokñen mɨlakta tɨmbi, Woñ walɨ tɨmbɨ pañgɨtaumbi, Kunum Yambattok mandangot pa elak, wala tɨmbi nin endɨ mandan wɨn nandɨ-dasilak, endɨ ñɨndɨñ tɨmbɨ inda-daklelak: endɨ Kunum Yambattɨ biañgan molom sɨnɨk wɨndɨñ nandɨ-kwambɨñ dalakta. ");
INSERT INTO nif_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Beptɨ Nɨñañ tɨke-galk talak, tɨmbi endɨ nepek gɨtɨñgɨtɨk endok kiinan kɨmɨpi, ka-dɨkñeuktok nɨmbɨ taleñguk. ");
INSERT INTO nif_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Wɨndɨñda tɨmbi nin endɨ Kunum Yambattok Nɨñañ nandɨ-kɨlɨktɨ tɨñmɨlak, endɨ kuñgu taletalen nɨmnat wɨn ikan ñɨndɨñgɨtañgan kasɨlembi kulak, gan nin endɨ Nɨñañdok mandan nɨm tɨkembi kɨmɨt-klelak, endɨ kuñgu sɨsɨnɨk wɨn nɨm kasɨleukak. Tambo, Kunum Yambattɨ ikan yomɨnlok kɨnjan tambon ombɨ-tɨkeuktok eu taleumbi, palmekak. ");
INSERT INTO nif_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Tɨmbi manda no ñɨndɨñ eu sapakñaneñguk, “Amatamdɨ Yesulok gwañgwañii indaumbi, tuk i-semlak, endok kwɨnakwɨnatsɨlɨ Yoanelok gwañgwañii yapma klelak.” (Gan wɨn Yesulɨ tuk i-sem-i-sem kena nɨm tɨñguk, wɨn endok gwañgwañiilɨñgot amatam tuk i-sem pa tɨñgɨlɨñ.) Tɨmbi manda walɨ Falisi amalok pawanjɨ gɨnañ pɨñguk wɨn Yesulɨ nandɨ-tomguk, wolonda ");
INSERT INTO nif_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","endɨ Judia kwet bimbi, Galili kwelan bɨndambo undane ñaupi ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ñambi nandɨñguk, wɨn “Samalia distrik dama dɨkñeuttok.” ");
INSERT INTO nif_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Tɨmbi Yesulɨ Samalia kwelan ñañɨpi, it kwet no koi Sikal wɨn tɨmbɨ dumalaumbi, Juda gɨt Samalia nasilok bep pañjɨ Jekoptɨ kwet no nɨñañ Joseptok biñmɨñguk wolok tomguk. ");
INSERT INTO nif_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tɨmbi Jekoptɨ tuk ban no kɨndit-bium wolok pakuk, wala tɨmbi Yesulɨ telak ombapgan bɨñgukta tɨmbi gwaseimbi, ban baliliñnan pip pakuk. Kwet nain bomup tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samalia tam nolɨ tuk gɨlep bɨum kañbi nɨñguk, “Dɨk tuk gɨt nam!” ");
INSERT INTO nif_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Gwañgwañii endɨla it kwelan nanañ tuatuala ña-taleñgɨlɨñ.) ");
INSERT INTO nif_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yesulɨ wɨndɨñ eumbi, Juda amatamdɨ Samalia en gɨta not nɨm tañda tɨmbi tam walɨ nandɨ-sɨlɨkñembi nɨñguk, “Nɨtekta tɨmbi dɨk Juda amalɨ nak Samalia tam ñandin ñala tukta nanlañ?” ");
INSERT INTO nif_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Eumbi, Yesulɨ tambane nɨñguk, “Kunum Yambattɨ amatam nek sɨloñ tambongan ememlok nandɨlak wɨn dɨk nandɨ-dakleumda, ba nin sɨnɨk tukta ganlak wɨn ka-nandɨ-tombɨmda, dɨtna naka tukta nanbɨmbi, nak tuk ama tɨmbɨ kaiktalok wɨn gumañ gamam.” ");
INSERT INTO nif_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Tɨmbi tamdɨ nɨñguk, “Ama wopum, tuk ban ñɨn ombap sɨnɨk, tɨmbi tuk gɨñgɨttok bo nɨm pakamlakta tɨmbi, dɨk tuk ama tɨmbɨ kaiktalok elañ wɨn denanin gɨletañ? ");
INSERT INTO nif_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sotnɨ Jekop endɨ wakan tuk ban ñɨn kɨndit-nɨmbi, en wakɨt nɨñañii ba sipsip bulmakauñiilɨ tuk ñakan nayañgɨlɨñ. Nɨtek tɨmbi dɨk gumañ en makleuñdok nandɨlañ?” ");
INSERT INTO nif_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Wɨndɨñ eumbi, Yesulɨ tambane nɨñguk, “Amatam gɨtɨktɨ tuk ñolok gɨpi pa nañ, endok binjɨ bɨndambo kalandaukak. ");
INSERT INTO nif_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Gan no en tuk natna mɨwambi nambekak, endok bim nombo nɨm kalandañmekak. Tambo tuk nak mɨmɨlok pat-namlak, walɨ endok gɨnan gɨnañ tuk dai no wandin indambi, tɨmbɨ kaiktaumbi, papat kwambɨñgan kuukak.” ");
INSERT INTO nif_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tɨmbi tamdɨ manda wolok kusei nɨm nandɨ-tombi nɨñguk, “Ama wopum, dɨk tuk wɨn naka namekañ! Nɨm kañbi, nak nombo tukta kɨmbi, tuk gɨlepi, slakan ñandɨñ yousɨyousɨ bɨut.” ");
INSERT INTO nif_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Wɨndɨñ eumbi, Yesulɨ nɨñguk, “Ale, dɨk ña, wapaka kɨtɨ nañgɨpi, en gɨta undane bɨukañ.” ");
INSERT INTO nif_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Eumbi nɨñguk, “Nak wapatna nɨm nat.” Eumbi, Yesulɨ nɨñguk, “Dɨk wapaka nɨm nat elañ, wɨn dɨndɨm sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Gan dɨk wapakai epguñ wɨn kɨt tambon gɨtɨk, tɨmbi ama nin en gɨta man ñɨndɨñgɨt kulañ, endɨ dɨkok wapaka nɨm, wala tɨmbi manda elañ wɨn biañgan sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yesulɨ wɨndɨñ eñgukta tɨmbi tam walɨ nɨñguk, “Ama wopum, nak gambɨ-nandɨlet, wɨn dɨk plofet ama no. ");
INSERT INTO nif_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wɨndɨñda nak ganɨ-nandɨwa: kwet jañgɨn da patak wolok Samalia nɨnlok bep pañniilɨ Kunum Yambat mɨlelem tɨñmañgɨlɨñ. Nɨtek tɨmbi Juda sɨndɨ amatamdɨ Jelusalem it kwelangot Kunum Yambat mɨlelem tɨñmɨnelɨñdok pa eañ?” ");
INSERT INTO nif_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Eumbi Yesulɨ tambane nɨñguk, “Tam, dɨk manda ñɨn dɨka ganlet wɨn nandɨ-kwambɨñ daukañ: nain dumalaumbi, amatamdɨ kwet jañgɨn ñolokgot ba Jelusalem it kwet wolokgot Bep Yambat nɨm mɨlelem tɨñmɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samalia sɨndɨla Kunum Yambat mɨlelem tɨñmañ, endok kusal nɨm nandɨ-kɨliñ eañ, gan Juda ama nɨndɨla nin sɨnɨk mɨlelem tɨñmamɨñ en nandɨñmamɨñ, wɨn kusei ñɨndɨñda: Kunum Yambattɨ amatam gɨtɨk kolanjɨlok mɨlapnan nanin yapma tɨketɨkelok kenan wɨn Juda nɨndok kandañ kusei kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tɨmbi nɨm ombataumbi, nain wɨn ip inda-talelak, wolonda nɨ-wowoñ tɨndɨlok ama sɨsɨnɨk endɨ Beptok kusal sɨsɨnɨk wɨn nandɨ-kɨliñ eumbi, Woñɨnlɨ ep tɨmbɨ pañgɨtaumbi, nɨ-wowoñ tɨñmɨnekalɨñ. Wɨn ama wandin wala Beptɨ yambɨ-galk tambi, nɨ-wowoñ tɨñmɨnelɨñdok ep kasɨleup nandɨlak. ");
INSERT INTO nif_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kunum Yambat en ama nɨm, endɨ Woñ sɨnɨkta tɨmbi en mɨlelem tɨñmɨlok wolok telak biañgan sɨsɨnɨk noñgangot patak. Wɨn ñɨndɨñ: endok kusal sɨsɨnɨk wɨn nandɨ-kɨliñ eumbi, Woñɨnlɨ ep tɨmbɨ pañgɨtaumbi, nɨ-wowoñ tɨ-ñɨmlok.” ");
INSERT INTO nif_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Tɨmbi tamdɨ nɨñguk, “Nak nandɨlet wɨn Mesia, koi no Klisto kɨtɨañ, endɨ indauktok een. Tɨmbi endɨ indamek, nepek gɨtɨk nɨnɨ-dakle tɨ-nɨm-taleukak.” ");
INSERT INTO nif_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Tɨmbi Yesulɨ nɨñguk, “Nak nindɨ manda ganlet wɨn Mesia en wakan.” ");
INSERT INTO nif_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wolongan endok gwañgwañiilɨ undane bɨ tombi kañgɨlɨñ, wɨn Yesulɨ tam gɨta manda e-nandɨ tɨñguk, tɨmbi ka-sɨlɨkñembi, nanandɨ kena tɨñgɨlɨñ. Gan endoñnan nanin nolɨ Yesu ñɨndɨñ no nɨm nɨ-kañgɨlɨñ, “Dɨk nekta lonjɨmbi nɨ-nandɨlañ?” ba “Kusei nekta tam ñakɨta manda e-nandɨ tɨlañ?” ");
INSERT INTO nif_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tɨmbi tam walɨ tuk kambot tɨke-bɨñguk wɨn wolok biu palɨmbi, it kwelan undane ñambi, amatamda ñɨndɨñ enɨ-ta-kuñguk, ");
INSERT INTO nif_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Sɨndɨ nakɨta tuk bannan ñambi, ama no nokok ep tɨndɨnalok kusei gɨtɨk nanɨ-talelak en bɨm kawɨt! En Mesia wakan bek?” ");
INSERT INTO nif_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Wɨndɨñ eumbi, amatamdɨ it kwet bimbi, Yesu kanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Amatamdɨ gama nɨm bɨ tomñɨlɨmbi, gwañgwañiilɨ Yesu nɨ-gɨñgɨnembi eñgɨlɨñ, “Nɨnɨndaut, nanañga na!” ");
INSERT INTO nif_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Gan Yesulɨ tambane enguk, “Nokok nanañ pat-namlak wɨn sɨndɨ nɨm ka-nandɨ-dakleañ.” ");
INSERT INTO nif_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wɨndɨñ eumbi, nɨsɨñgan ñɨndɨñ e-nandɨ tɨñgɨlɨñ, “Ama nolɨ nanañ ep bɨm mɨk ba?” ");
INSERT INTO nif_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Tɨmbi Yesulɨ enɨ-daklembi eñguk, “Nak nin nanɨ-mukuk endok man tañgoneñɨpi, kenan tɨmbettok namguk wɨn gɨtɨk tɨmba taleukak, walɨ wakan nokok nanañna tɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tɨmbi Yesulɨ yousɨmbi enguk, “Amatamdɨ ñɨndɨñ pa eañ, ‘Yakɨp tɨpet tɨpet taleumbi, nanañ mepmeptok nain indaukak.’ Gan nak ñɨndɨñ sanlet, sɨndɨ dausɨ deium ñaumbi, amatam nɨndoñ bɨnep tañ wɨn yambɨt: endɨ kena gɨnañ nanañ bien epeptok ikan gɨlɨtalak wandin. ");
INSERT INTO nif_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","No en amatam wandin kuñgu taletalen nɨmnatnan yanañgɨtak, endɨ ama bien epep kena tɨmbi, tuan kɨndem kasɨlelak wandin. Wɨndɨñda tɨmbi tɨpitɨpi tɨlak gɨta bien epep tɨlaktɨ yakan bienla sɨlɨsɨlɨ tamɨk. ");
INSERT INTO nif_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Manda no ñɨndɨñ pa eañ, ‘Ama nolɨ tɨpitɨpi tɨmbɨmbi, nolɨ bien epep pa tɨlak.’ Wɨn kusei ñɨndɨñda tɨmbi manda walɨ sɨndok kandañ bien tɨlak: ");
INSERT INTO nif_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","sɨndɨ kena nolɨ tɨñgɨlɨñ wolok bien epnelɨñdok nak sanɨ-mulam ñañgɨlɨñ, wɨn dɨwɨn nolɨ kena meñ tɨñgɨlɨñ, tɨmbi sɨndɨ endok kenanjɨlok bien kasɨleañ.” ");
INSERT INTO nif_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samalia tamdɨ eñguk, “Endɨ nokok ep tɨndɨna gɨtɨk nanɨ-dakle-talelak,” wɨndɨñ eñgukta tɨmbi endok ilnan nasi asuptɨ Yesu en Mesia sɨnɨk wɨndɨñ wɨn nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Wɨndɨñda tɨmbi endɨ Yesuloñ bɨ tomgɨlɨñ, endɨ Yesulɨ en gɨta kuuptok gɨñgɨnembi, nɨ-tiañeumbi nandɨ-sembi, isɨ kwesɨnan sandap tɨpet kumbi, ");
INSERT INTO nif_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","gɨñgɨt manda enguk. Tɨmbi manda eñgukta tɨmbi amatam asupgan sɨnɨktɨ Yesu en Mesia sɨnɨk wɨn nandɨ-kwambɨñ dambi, ");
INSERT INTO nif_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","tamda ñɨndɨñ nɨñgɨlɨñ, “Wɨn dɨkok mandañgalañgot tɨmbi nɨndɨ nombo nɨm nandɨ-kwambɨñ damɨñ. Tambo, nɨndɨ nɨnlok pawannɨlɨ endok mandan nandɨmbi, ñɨndɨñ nandɨ-dakleamɨñ: biañgan sɨnɨk, ñɨne Mesia nin kwelalok amatam gɨtɨk kolanjɨlok kɨnjannan nanin yapma tɨkeukak en wakan.” ");
INSERT INTO nif_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesulɨ Samalia kwelan sandap tɨpet pakap, Galili kwelan ñaupi ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Endɨ damañgan ñɨndɨñ eñguk, “Plofet ama nolok ilnan nasilɨ giñgiñgan nɨm pa tɨñmañ.” ");
INSERT INTO nif_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Wɨndɨñda endɨ Galili kwelan undane ña tomguk, wolonda wɨnasɨ endɨ bo Kamaikamai gwɨlatta Jelusalem ñambi, Yesulɨ nepek nek wolok tɨñguk wɨn gɨtɨk kañgɨlɨñda tɨmbi enda not tɨñmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesulɨ Galili kwelan kuñɨpi, Kana it kwet wolok damañgan tuk tɨmbɨm wain indañguk, wandɨñ kandañ endɨ bɨndambo ñam pakuk. Tɨmbi Kapaneam it kwet walɨ Kana ñasɨñgan pakuk, wandɨñ ama wapmañdok kena ama nolɨ kuñguk. Endok nɨñañdɨ jɨmbat tɨñgukta tɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","endɨ Yesulɨ Judia kwelan nanin pɨmbi, Galili bɨ tomguk wolok gɨñgɨt nandɨmbi, wolongan endoñ bɨñguk. Bɨmbi, nɨ-gɨñgɨnembi, ñɨndɨñ eñguk, “Wandingan, dɨk nakɨta Kapaneam ñambi, nokok nɨñana sembepi tɨlak wɨn tɨmbɨ kɨndem dawɨn.” ");
INSERT INTO nif_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Wɨndɨñ eñgukta tɨmbi Yesulɨ ñɨndɨñ nɨñguk, “Tɨkap amatam sɨndɨ jimba kundit ba kundit gɨtikñin daut samambi nɨm kañda, sɨndɨ nak nɨm nandɨ-kɨlɨktɨ tɨ-namañ.” ");
INSERT INTO nif_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wɨndɨñ eumbi tambane nɨñguk, “Wopum, nɨm kañbi nɨñana sembekta, plapgan bɨumbi ñanda.” ");
INSERT INTO nif_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Gan Yesulɨ tambane nɨñguk, “Dɨk ñau. Nɨñañga ip kɨndem dam kulak.” Tɨmbi ama walɨ Yesulɨ manda nɨñguk wɨn nandɨ-kwambɨñ dambi, ilan ñaupi ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ñañɨlɨmbi, endok kena gwañgwañiilɨ en telaknan bɨ tɨmbɨ indaumbi, ñɨndɨñ nɨñgɨlɨñ, “Dɨkok nɨñañga ip kɨndem dak kulak.” ");
INSERT INTO nif_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Eumbi, nain nekta sɨnɨk kɨndem dañguk wala enɨ-nandumbi nɨñgɨlɨñ, “Desa 1 kilok timlala tɨmbɨmbi, siñgin komba dɨñguktɨ busukñeñguk.” ");
INSERT INTO nif_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Eumbi, beulɨ ka-nandɨ-dakleñguk, wɨn 1 kilok timlala sɨnɨk Yesulɨ “Nɨñañga kɨndem dam kulak” wɨndɨñ nɨñguk. Tɨmbi en gɨta amatam endok ilnan kuñgɨlɨñ endɨ gɨtɨktɨ Yesu nandɨ-kɨlɨktɨ tɨñmɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesulɨ Judia kwelan nanin Galili kwelan undane bɨ tombi, bɨndambo jimba kundit wɨn tɨmbɨmbi, nain tɨpet indañguk. ");
INSERT INTO nif_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nain nɨtepek ñaumbi, Juda amatamdok gwɨlat no tɨmbɨ dumalaumbi, Yesulɨ Galili kwet bimbi, Jelusalem undane ñam pakuk. ");
INSERT INTO nif_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jelusalem it kwettok sañ yama nolok koi wɨn Sipsiplok Yama, tɨmbi yama wolok ñasɨñgan tuk ban no patak, wolok koi wɨn Judalok mandanjɨ plon Betesta kɨtɨañ. Tuk ban walɨ palanda kɨt tambongot, ");
INSERT INTO nif_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","tɨmbi palanda wolok plon amatam jɨmbatsɨat asup, wɨn amatam dausɨ sipsipmɨn, ba kesɨsɨ kolan ba pɨñgɨpsɨ dalandañguk endɨ pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ama no gwɨlat 38 gɨtɨk jɨmbat tɨkeñgukta endɨ bo wolok pakuk. ");
INSERT INTO nif_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesulɨ tuk bannan ña tombi, ama wɨn kañbi ka-nandɨñguk, wɨn endɨ nain ombapgan wolok pakañguk. Wɨndɨñda endɨ ñɨndɨñ nɨ-nandɨmbi eñguk, “Dɨk kɨndem dauñdok nandɨ-galk tɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Eumbi, ama jɨmbalattɨ tambane nɨñguk, “Wopum, tuktɨ sasɨk tɨmbɨmbi, notna nolɨ nepmu plaptaumbi, tuk gɨnañ pɨut ñak! Nɨmda tɨmbi, natnañgan pɨmbɨlok gliñgliñ tɨmbambi, dɨwɨn nolɨ napma klembi, dama pa pañ.” ");
INSERT INTO nif_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Wɨndɨñ eumbi, Yesulɨ nɨñguk, “Dɨk mɨlapi, ipaka tɨkembi ñau.” ");
INSERT INTO nif_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tɨmbi wolongan ama walɨ kɨndem dambi mɨlapi, ipal tɨkembi ñañguk. Wɨn Sabat patnandɨ nainda wɨndɨñ indañgukta tɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Juda ama biesɨlɨ ama kɨndem dañgukta ñɨndɨñ nɨ-gɨñgɨnembi eñgɨlɨñ, “Man Sabat yañ! Dɨk nɨtek tɨmbi endɨkñe manda wɨpi, ipaka tɨkembi ñalañ?” ");
INSERT INTO nif_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Eumbi tambane enguk, “Ama nep tɨmbɨ kɨndem dat endɨ ñɨndɨñ nanɨk, “Dɨk ipaka tɨkembi ñau.” ");
INSERT INTO nif_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Eumbi nɨ-nandɨñgɨlɨñ, “Ama nindɨ ‘Ipaka tɨkembi ñau’ ganɨk?” ");
INSERT INTO nif_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Gan Yesulɨ kɨmɨn wopum wolok pakɨlɨñ endok boñgɨpsɨnan paikukta tɨmbi, ama kɨndem dañguktɨ en nin sɨnɨk wɨn nɨm nandɨ-ñɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Siñgi kandañ Yesulɨ ama wɨn tapma it sañ jimba gɨnañ tɨmbɨ indaumbi nɨñguk, “Nandɨlañ, dɨk ip kɨndem dañguñda, yom nombo nɨm tɨmbekañ. Nɨm kañbi, mɨlap wopum sɨnɨk nolɨ gepmek!” ");
INSERT INTO nif_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Eumbi, amalɨ walinin pɨm ña Juda ama biesɨloñ ñambi, Yesulɨ tɨmbɨ kɨndem dañguk wɨndɨñ eumbi nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yesulɨ kundit wandisɨ Sabat patnandɨ nainda pa tɨlɨñgukta tɨmbi, Juda ama biesɨlɨ kusei kɨmɨpi, mɨlap pa mɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Tɨmbi Yesulɨ enlok ep tɨndɨn kasopmeuktok ama biesɨla ñɨndɨñ enguk, “Bepnalɨ yousɨyousɨñgan kena tɨ-ta-kulakta tɨmbi nak bo wɨndɨñgangot tɨ-ta-kuutat.” ");
INSERT INTO nif_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Kusei wala tɨmbi Juda ama biesɨlɨ Yesu wɨlɨ kɨmbektok telak lonjɨ-sɨnɨk tañgɨlɨñ. Wɨn endɨ Sabattok endɨkñe manda lapɨkuk walañgot nɨm. Wɨn endɨ Kunum Yambatta “Bepna” eñguk, walɨ en tɨmbɨmbi, endɨ Kunum Yambat gɨt tuopset noñgan tɨñgukta tɨmbi wɨlɨ kɨmbektok telak lonjɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Tɨmbi Yesulɨ ñɨndɨñ tambane enguk, “Manda et walɨ biañgan sɨnɨk. Tɨmbi ñɨndɨñgot sanba: nak Kunum Yambattok Nɨñañdɨ natnalok nanandɨnala nepek no tɨmbettok tuop nɨm. Tambo nokok Bepnalɨ nepek nek tɨmbɨmbi kalet, wɨngot gumañ tɨmbet. Wɨn Beptɨ nepek nek pa tɨlak, wɨndɨñgangot nak endok Nɨñañdɨ pa tɨlet. ");
INSERT INTO nif_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tɨmbi endɨ gɨnañlɨ nep kasɨlembi, enlok ep tɨndɨn gɨtɨk wɨn daut namum kañbi pa tɨlet. Tɨmbi sɨndɨ ka-sɨlɨkñembi, nanandɨ kena tɨnelɨñdok, endɨ kundit gɨtikñin daut namum kañbi tɨmbetat, tɨmbi walɨ kundit damañgan tɨñgut wɨn makle tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Wɨn ñɨndɨñ: Bepnalɨ ama kɨmnan nanin ep tɨmbɨ mɨlalɨmbi, kuñgu emlak, wɨndɨñgangot nak endok Nɨñañlɨ bo ama ninda kuñgu emepi nandɨlet enda emlet. ");
INSERT INTO nif_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tɨmbi wɨngot nɨm. Beptɨ ama no nɨm yambɨ-danlak. Tambo amalɨ kuñgulok ba kɨmkɨmlok wɨn eu taletale kena wɨn Beptɨ nokok kɨtnanan kɨmɨt-taleñguk. ");
INSERT INTO nif_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Wɨn kusei ñɨndɨñda: endɨ enda kot gɨñgɨt mañ gɨtɨktɨ nak Nɨñañda wɨndɨñgangot kot gɨñgɨt namnelɨñdok nandɨlak. No en gɨñgɨnembi, nak Nɨñan kot gɨñgɨt nɨm namlak, endɨ Bep nanɨ-mukuk enda bo kot gɨñgɨt nɨm pa mɨlak. ");
INSERT INTO nif_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Wɨn biañgan sɨnɨk. Tɨmbi ñɨndɨñ sanba nandɨwɨt: nin endɨ nokok mandana kɨmɨt-klembi, Bep nanɨ-mukuk en nandɨ-kɨlɨktɨ tɨñmɨlak, endɨ kuñgu taletalen nɨmnat wɨn ikan palmɨlak. Wɨn endɨ damañgan kɨmlok gɨñgɨt kuñguk, gan kuñgu sɨsɨnɨk wolok gɨñgɨt ikan indambi kulak, tɨmbi yomɨnlok kɨnjan tambon nɨm ombɨ-tɨkeukak. ");
INSERT INTO nif_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Manda walɨ biañgan sɨnɨk. Tɨmbi nak ñɨndɨñ sanlet: nain indaup tɨlak wolonda amatam endok gɨnañjɨ tip kɨmkɨmɨn endɨ nak Kunum Yambattok Nɨñañ nokok mandana nandɨnekalɨñ. Biañgan ñak, nain wɨn ikan indak, tɨmbi mandana nandɨ-dasiañdɨ papat kwambɨñgan kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Wɨn kusei ñɨndɨñda: nokok Bepna en kuñgu molomdɨ amatam ep tɨmbɨ kaiktaumbi, kuñgu ememlok gembɨn palmɨlakta, tɨmbi nak endok Nɨñañdɨ wɨndɨñgangot tɨmbettok endɨ gembɨn wɨn naka bo namguk. ");
INSERT INTO nif_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tɨmbi nak Ama Sɨsɨnɨkta tɨmbi endɨ nak amatam yambɨ-danbettok ikan nanbɨ taleumbi, endɨ kuñgulok ba kɨmkɨmlok manda wɨn nak ewa taleukak. ");
INSERT INTO nif_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Sɨndɨ wala nanandɨ kena nombo nɨm tɨnekalɨñ, wɨn kusei ñɨndɨñda: nain indaukak wolonda sembɨsembɨn gɨtɨk endɨ nokok mana malap nandɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","sumjɨ binekalɨñ, wɨn kɨndem tɨndɨ endɨ mɨlapi, kuñgu kwambɨñ kunekalɨñ, tɨmbi kolan tɨndɨ endɨ mɨlapi, nak mandanjɨ ewa taleumbi, endɨ kolanjɨlok tambon ombɨ-tɨkenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nak natnalok nanandɨnala nepek no tɨmbeptok tuop nɨm. Wɨn Bepnalɨ nɨtek nanlak, wolok tuopgan nak amatam pa yambɨ-danɨ tɨlet. Tɨmbi nak telak dɨndɨm plon yambɨ-danɨ tɨlet, wɨn kusei ñɨndɨñda: nak natnalok nanandɨna nɨm kɨmɨt-klelet, tambo Bep nanɨ-mukuk endok man tañgonembi kɨmɨt-klelet.” ");
INSERT INTO nif_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tɨmbi Yesulɨ yousɨmbi, ama biesɨla enguk, “Tɨkap nak noñganlɨñgot natnalok kusatna e-daklewamda, sɨndɨ wala nandum biañgan nɨm tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Gan kusatna e-daklelok no patak, wɨn Bepna en wakan. Tɨmbi nak ñɨndɨñ nandɨ-daklelet: endɨ manda nokok plon elak walɨ biañgan sɨnɨk tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tɨmbi sɨnɨ nokok kusatna tɨmbɨ inda-daklenelɨñdok ama enɨ-mulɨmbi, endɨ Yoane tuk i-sem-i-semloñ ñam nɨ-nandɨñgɨlɨñ, wolonda Yoanelɨ kusatna sɨsɨnɨk wɨn sanɨ-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Natna kusatna inda-dakleuktok endok ba ama nolok mandan plon nɨm panjañganelet, ganmek sɨndɨ Yoanelok mandan nandɨ-dasiumbi, Kunum Yambattɨ kolanjɨlok kɨnjannan nanin sapma tɨkeuktok nak Yoanelok mandan wɨn sanɨ-kaikta tɨlet. ");
INSERT INTO nif_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Sipalaktɨ duapi kolɨ salelak, wɨndɨñgan Yoanelɨ nokok kusatna tɨmbɨ sale-samumbi, sɨnɨ nain dumangan endok mandanla tɨmbi nandɨ-koñgomnat sɨlɨsɨlɨ wopumgan tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kusatna tɨmba inda-dakleuktok nepek no pat-namlak, tɨmbi walɨ Yoanelok mandan maklelak. Wɨn nokok Bepnalɨ nak kena tɨmba taleuktok namguk, wɨn nak kundit pa tɨlet, walɨ wakan endɨ nak nanɨ-mulɨmbi indañgut wɨn tɨmbɨ inda-daklelak. ");
INSERT INTO nif_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tɨmbi wɨngot nɨm. Bepna nanɨ-mukuk endɨ bo kusatna tɨmbɨ inda-daklelak. Sɨndɨ nain nola endok man malap nɨm nandɨñgɨlɨñ, ba endok walan nɨm kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tɨmbi endok mandan sɨndok gɨnañjɨ gɨnañ nɨm nandɨ-dasium patak, wɨn kusei ñɨndɨñda: endɨ nak wakan nanɨ-mulɨmbi indañgut, ganmek sɨndɨ nokok mandana nɨm nandɨ-kwambɨñ dañ. ");
INSERT INTO nif_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Sɨndɨ kuñgu taletalen nɨmnat wolok telak wɨn manda youyoulɨn gɨnañ tɨmbɨ inda-samektok nandañda tɨmbi manda wɨn pinat-lonjɨ kena pa tɨ-kɨliñ eañ, tɨmbi manda walɨ wakan nokok kusatna eu daklelak, ");
INSERT INTO nif_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","gañgan sɨndɨ gɨñgɨnembi, nak sep tɨmba pañgɨtaumbi, kuñgu sɨsɨnɨk wɨn kasɨlenelɨñdok nokoñ nɨm pa bañ. ");
INSERT INTO nif_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Amalɨ kot gɨñgɨt namañ ba nɨm namañ, nak wala nandɨ-koñgom nɨm pa tɨlet. ");
INSERT INTO nif_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Gan sɨndok kandañla wɨndɨñ nɨm. Nak nandɨ-kɨliñ tɨ-sambi, sambɨ-nandɨ-daklelet, wɨn sɨndok gɨnañjɨlɨ Kunum Yambat nɨm kasɨleañ. ");
INSERT INTO nif_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Neta, nokok Bepnalɨ nanɨ-mulɨmbi, endok kɨnjannan sɨndoñ bɨñgut, ganmek sɨndɨ siñgi wɨwɨt pa tɨ-namañ. Gan tɨkap ama nolɨ enlok nanandɨnla sɨndoñ bɨlakta, sɨndɨ not pa tɨñmañ. ");
INSERT INTO nif_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Sɨndɨ nosiilɨ kot gɨñgɨt samañ wala nandɨ-koñgom pa tañ, gan Kunum Yambat noñgan sɨnɨktɨ kot gɨñgɨt samektok sɨn gembɨ nɨm pa kokañ. Wɨndɨñda tɨmbi sɨndɨ nɨtek nokok mandana nandɨ-kwambɨñ danelɨñ? ");
INSERT INTO nif_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Bepnalok dainan nindɨ sɨnɨk mandalɨ sep youpi sanɨ-kolaukak? Wɨn nak nɨm! Sɨndɨ wɨndɨñ nɨm nandɨ-namnekalɨñ. Wɨn ama sɨndɨ sep kɨmɨlektok nandɨ-kwambɨñ dañ, wɨn Mose en wakan mandalɨ sep youlekak! ");
INSERT INTO nif_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Endɨ nokok plon manda youkuk, wala tɨmbi tɨkap sɨndɨ endok mandan nandɨ-kwambɨñ daumda, nokok mandana bo nandɨ-kwambɨñ danelɨñ. ");
INSERT INTO nif_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Gan tɨkap sɨndɨ Moselɨ manda youkuk wɨn nɨm nandɨ-kwambɨñ dañda, nokok mandana nɨtek nandɨ-kwambɨñ danelɨñ?” ");
INSERT INTO nif_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tɨmbi Yesulɨ Galili kwelan undanem bɨ pakap, nain nola kɨkeñ tɨkembi, Galili tuk guañ, wolok koi no Taibelias, wɨn dɨkñembi, tombon kandañ gwañgwañii gɨta wandɨñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tɨmbi amatam kɨmɨn wopumdɨ Yesulɨ jimba kundit ama jɨmbatsɨatta tɨ-semlɨñguk wɨn pa kayañgɨlɨñda tɨmbi, en kle-gɨmgɨm embi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tɨmbi Yesulɨ tambon kandañ ña tombi, kwet jañgɨn nolok lombi, gwañgwañii gɨta pip pakuk. ");
INSERT INTO nif_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Nain wolonda Juda amatamdok gwɨlat wopum no, koi Kamaikamai gwɨlat, walɨ dumalañguk.) ");
INSERT INTO nif_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tɨmbi Yesulɨ deium ñaumbi, amatam kɨmɨn wopum endoñ bɨumbi yambɨmbi, Filipta nɨ-nandɨmbi eñguk, “Nɨndɨ nanañ denanin tuambi, amatam ñandin sɨnɨk ep towineñ?” ");
INSERT INTO nif_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Endɨ amatam ep towiuktok nandɨ-sambat ikan tɨñguk, gan Filiptok nanandɨ-kɨlɨktɨn ka-nanduktok wɨndɨñ eñguk.) ");
INSERT INTO nif_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tɨmbi Filiptɨ tambane nɨñguk, “Tɨkap nɨndɨ kena tɨmbi, sandap 200 wolok tuan pat-nɨmumda, mɨnem walɨ plaua nanañ tuanambi, amatam noñgan noñganlɨ lakatgot nanelɨñda, walɨ gama tuop nɨm tɨ-semek.” ");
INSERT INTO nif_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tɨmbi Yesulok gwañgwa no koi Andlu, Simon Petlolok kwayañ, endɨ Yesu ñɨndɨñ nɨñguk, ");
INSERT INTO nif_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gwañgwa no ñɨn patak, endok plaua nanañ wɨn bali kwɨlanlɨ tɨndɨn kɨt tambongot gɨt mɨkbalak sinjin tɨpet palmɨlak. Gan plaua gɨt mɨkbalak wandin walɨ amatam asupgan pakañ nɨtek tuop tɨ-semek?” ");
INSERT INTO nif_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tɨmbi Yesulɨ gwañgwañii enbɨmbi, endɨ amatamdɨ pip patnelɨñdok enbɨmbi pipakɨlɨñ. (Kwet wolok kli asup pakuk.) Tɨmbi ama endok kwɨnakwɨnatsɨ wɨn 5,000 ba nɨtepek. ");
INSERT INTO nif_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tɨmbi Yesulɨ plaua nanañ wɨn epbi, Kunum Yambat weñmɨmbi, amatam wolok pipakɨlɨñ enda danɨ-semnelɨñdok gwañgwañiila emguk. Emu taleumbi, mɨkbalak tɨpetta wɨndɨñgangot tɨñguk. Tɨmbi amatamdɨ nandɨ-galksɨlok tuop epbi nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na tokñeumbi, Yesulɨ gwañgwañiila enguk, “Nanañ nambɨmbi, dɨp pat-ta-ñalak wɨn kiulɨt! Nɨm kañbi, binam pap kolauk.” ");
INSERT INTO nif_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wɨndɨñda endɨ amatamdɨ nanañ na-tɨlap biñgɨlɨñ wɨn kiukɨlɨñ, wɨn plaua nanañ kɨt tambongot wolok dɨpdɨplɨ sandɨñ lɨk 12 tokñeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amatamdɨ Yesulɨ jimba kundit wɨn tɨmbɨm kañgɨlɨñda tɨmbi manda ñɨndɨñ eu satañguk, “Biañgan sɨnɨk, Kunum Yambattɨ plofet nɨ-mulɨm kwelan indauktok een wɨn ama ip ñakan sɨnɨk!” ");
INSERT INTO nif_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Endɨ wɨndɨñ eumbi, Yesulɨ yambɨ-nandɨñguk, wɨn amatamdɨ en kaikgan tɨkembi, ama wapmañjɨ wɨndɨñ mambɨ ilektok nandɨ-sambat tɨñgɨlɨñ, wala tɨmbi endɨ yambɨk bimbi, bɨndambo engan kwet jañgɨnnan loñguk. ");
INSERT INTO nif_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Timlala tɨmbɨmbi, Yesulok gwañgwañiilɨ kwet jañgɨnnan nanin tuk guañnan pɨmbi pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Pakap, kwet kɨlɨm eumbi, Yesulɨ endoñ gama nɨm bɨñgukta tɨmbi endɨ kɨkeñ plon lombi, tuk guañ dɨkñembi, ña Kapaneam kandañ ñanepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ñañɨlɨmbi, sasale wopum bɨmbi, tuk pendɨlɨmbi, tuktok gembɨndɨ wopumgan mɨlakuk. ");
INSERT INTO nif_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Endɨ 5 ba 6 kilomita wolok tuop kɨndit ñambi kañgɨlɨñ, wɨn Yesu kesɨktɨ tuk plon yaliyali bɨmbi, kɨkeñ tɨmbɨ dumalaum kañbi mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gan Yesulɨ enguk, “Ñɨn natna sɨnɨk, nɨm mɨsɨnelɨñ.” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","gwañgwañiilɨ kɨkeñ gɨnañ nañgɨp lonelɨñdok nandɨ-koñgom tɨñgɨlɨñ, tɨmbi wolongan kɨkeñdɨ kwet ñanepi ñañgɨlɨñ wandɨñ ña suañguk. ");
INSERT INTO nif_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kwet salaumbi, amatam tuk guañ tambon kandañ gamañgot pakɨlɨñ endɨ ka-nandɨ-tomgɨlɨñ, wɨn “Desa kɨkeñ noñganlɨñgot ñolok pakuk, gan Yesulɨ wolok plon nɨm loñguk. Wɨn gwañgwañii nɨsɨñgot wolok plon lombi ña-taleñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tɨmbi kɨkeñ dɨwɨndɨ Taibelias it kwelan nanin bɨmbi, Yesulɨ Kunum Yambat weñmɨmbi, amatam nanañ ep towiñguk kwet wolok ñasɨñgan bɨ tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tɨmbi amatamdɨ ka-nandɨ-tomgɨlɨñ, wɨn Yesu gɨt gwañgwañiilɨ kwet wolok nombo nɨm pakɨlɨñ, wala tɨmbi endɨ kɨkeñ wandɨñ bɨ tomgɨlɨñ wolok plon lombi, Yesu lonjɨnepi Kapaneam it kwelan ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ñambi, Yesu en tuk guañ tambon kandañ tɨmbɨ indaumbi, nɨ-nandɨmbi eñgɨlɨñ, “Endaut, dɨk dawanda ñandɨñ bɨñ?” ");
INSERT INTO nif_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tɨmbi Yesulɨ e-nandɨnjɨ wɨn nandɨ-kɨmnembi, ñɨndɨñ tambane enguk, “Ba sɨndɨ nak jimba kundit asup tɨmbam kañbi, kusatna nandɨ-dakleñgɨlɨñda tɨmbi nep lonjañ ba? Wɨn biañgan nɨm! Nak sanlet, wɨn sɨndɨ nandɨ-galksɨlok tuop nanañ na tokñeñgɨlɨñ, walañgot tɨmbi nep lonjañ. ");
INSERT INTO nif_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sɨndɨ nanañ kolalak wandin kasɨlenelɨñdok kena boñgɨt nɨm tɨnekalɨñ. Tambo sɨndɨ nanañ walɨ sep tɨmbɨ kaiktaumbi, kuñgu taletalen nɨmnat samlak wɨn kasɨlenelɨñdok gɨñgɨnembi, kena boñgɨt tɨnekalɨñ. Tɨmbi nak Ama Sɨsɨnɨktɨ nanañ wakan sametat, wɨn kusei ñɨndɨñda: Bep Yambattɨ nak wɨndɨñ tɨmbettok nanbɨ taleñguk.” ");
INSERT INTO nif_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wɨndɨñ eumbi, endɨ nɨ-nandɨñgɨlɨñ, “Ale, nɨndɨ Kunum Yambattok kenan tɨneñdok nɨtek sɨnɨk tɨlok?” ");
INSERT INTO nif_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Eumbi tambane enguk, “Kunum Yambat endɨ ñɨndɨñ tɨnelɨñdok nandɨ-samlak: sɨndɨ endɨ ama nin nɨ-mulɨm pɨ indañguk, wɨn natna nandɨ-kɨlɨktɨ tɨ-nam-ta-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Amatamdɨ manda wɨn nandɨmbi, ñɨndɨñ nɨ-nandɨñgɨlɨñ, “Ale, dɨk jimba kundit nek sɨnɨk no tɨmbɨm kañmek, dɨk manda biañgan elañ wɨn gumañ nandɨ-kwambɨñ daneñ? Wɨn ñɨndɨñ youyoulɨn patak, ‘Endɨ nanañ kunum gɨnañ nanin emum nayañgɨlɨñ,’ wala tɨmbi Mose endɨla nɨndok bep pañniila nanañ koi mana wɨn kwet sɨlaninnan emumbi nayañgɨlɨñ. Wɨndɨñda dɨtna kundit engano nek sɨnɨk daut nɨmetañ?” ");
INSERT INTO nif_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Eumbi tambane enguk, “Endɨ nanañ wɨn nayañgɨlɨñ wɨn biañgan sɨnɨk, gan nak ñɨndɨñ sanba: nanañ kunum gɨnañ nanin emguk wɨn Mose nɨm. Tambo nokok Bepna en wakan nanañ sɨsɨnɨk wɨn kunum gɨnañ nanin pa samlak. ");
INSERT INTO nif_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Wɨn kusei ñɨndɨñda: nek ñalɨ kunum gɨnañ nanin pɨmbi, kwelalok amatam kuñgu sɨsɨnɨk emlak, walɨ nanañ biañgan sɨsɨnɨk Kunum Yambat en pa samlak wakan.” ");
INSERT INTO nif_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Eumbi nɨñgɨlɨñ, “Wopum, dɨk nain tuop nanañ wɨn nɨmekañ.” ");
INSERT INTO nif_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Eumbi enguk, “Kuñgu sɨsɨnɨk wolok nanañ wɨn natna wakan. No en nokoñ bɨmbi, nep yousɨmbi, nandɨ-kɨlɨktɨ tɨ-namlakta, endok gɨnan tipmɨnlɨ nanañ tukta nombo nɨm kɨmbekak. ");
INSERT INTO nif_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gan nak sangut wolok tuop sɨndɨ nokok kusatna ikan nambɨ-nandañ, gañgan nɨm nandɨ-kɨlɨktɨ tañ. ");
INSERT INTO nif_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Bepnalɨ amatam nokok kɨtnanan yapɨtak, endɨ gɨtɨktɨ nokok kandañ bɨ-talenekalɨñ. Tɨmbi nokok kandañ bañ wɨn nak endoñnan nanin no nɨm ep kleutat. Nɨm sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wɨn kusei ñɨndɨñda: nak natnalok mana tañgoneupi kunum gɨnañ nanin kwelan ñɨn nɨm pɨñgut. Tambo Bepnalɨ nanɨ-mukuk endok man mandan tañgoneuttok indañgut. ");
INSERT INTO nif_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tɨmbi endok man mandan wɨn ñɨndɨñ: amatam nokok kɨtnanan yapɨt-taleñguk, endoñnan nanin walɨ no nɨm pait-talenekalɨñ. Tambo nak endɨ gɨtɨk ep kamaimbi, nain taletalennan kɨmnan nanin epma mɨlat-talenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Wɨn Bepnalɨ ñɨndɨñ indauptok nandɨ-galk talak: amatam nin endok Nɨñañ nokok kusatna nambɨ-daklembi, nandɨ-kɨlɨktɨ tɨ-namañ, endɨ gɨtɨk kuñgu taletalen nɨmnat wɨn kasɨlenekalɨñ, tɨmbi nain taletalennan natna mek kɨmnan nanin epma mɨlatnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesulɨ “Nanañ kunum gɨnañ nanin pɨñguk wɨn natna” wɨndɨñ eñgukta tɨmbi, Juda ama biesɨlɨ kusei kɨmɨpi, endok plon e-balep tɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, “En Yesu yañ, Joseptok nɨñañ wɨn, tɨmbi nɨndɨ endok meñ beu nandɨ-semamɨñ! Nɨtekta tɨmbi ama wandin walɨ kunum gɨnañ nanin kwelan pɨñguk wɨndɨñ pa elak?” ");
INSERT INTO nif_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Eumbi tambane enguk, “Sɨndɨ sɨnlok boñgɨpsɨnan e-balembalep nombo nɨm tɨmbɨt. ");
INSERT INTO nif_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Bep nin nak nanɨ-mukuk en amatam nokoñ nɨm yanañgɨlɨmda, ama nolɨ nokoñ bɨmbi, nep kle kunelɨñdok tuop nɨm. Tɨmbi nain taletalennan natna mek kɨmnan nanin ep tɨmba mɨlatnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Plofet amalɨ manda youkɨlɨñ wolok gɨnañ ñɨndɨñ youyoulɨn patak, ‘Kunum Yambattɨ amatam gɨtɨk enɨ-daut tɨ-sembi, nanandɨ emekak.’ Wɨndɨñda tɨmbi amatam Beptɨ nanandɨ emlak wɨn nandɨmbi nandɨ-dasiañ, endɨ gɨtɨktɨ nokoñ bɨmbi, nep kle kuañ. ");
INSERT INTO nif_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ama nolɨ Bep dailɨ kañguk wɨndɨñ nɨm sanlet. Wɨn nak Bep gɨt kukap kwelan pɨ indañgut, nak noñgandɨñgot en kañgut. ");
INSERT INTO nif_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Wɨn biañgan sɨnɨk. Tɨmbi ñɨndɨñ sanlet: nin endɨ nandɨ-kɨlɨktɨ tɨ-nam-kulakta, endɨ Bep gɨt papat kwambɨñgan kulak. ");
INSERT INTO nif_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kuñgu sɨsɨnɨk wolok nanañ wɨn natna wakan. ");
INSERT INTO nif_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Sɨndok bep pañjiilɨ kwet sɨlaninnan kuñɨpi, nanañ koi mana kunum gɨnañ nanin pɨñguk wɨn nayañgɨlɨñ, gañgan endɨ sembɨ-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gan nanañ sɨsɨnɨk kunum gɨnañ nanin pɨñguk walɨ mana wandin nɨm. Tambo nin endɨ nanañ wakan nalak, endɨ nɨm sembekak.” ");
INSERT INTO nif_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yesulɨ yousɨmbi enguk, “Nanañ kunum gɨnañ nanin pɨmbi, kuñgu sɨsɨnɨk wɨn pa samlak wɨn natna wakan. No en nanañ wɨn pa nalakta, endɨ papat kwambɨñgan kuukak. Nanañ wɨn nokok pɨñgɨpna, tɨmbi kwelalok amatamdɨ papat kwambɨñgan kunelɨñdok nak tapma tɨ-semetat.” ");
INSERT INTO nif_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yesulɨ wɨndɨñ eñgukta tɨmbi Juda ama biesɨlɨ gɨnañjɨ komba dɨumbi, kusei kɨmɨpi, nɨsɨñgan e-tañan tɨmbi, ñɨndɨñ eñgɨlɨñ, “Ama wandin walɨ enlok pɨñgɨu nɨnda nɨmum naneñdok telak no nɨm patak!” ");
INSERT INTO nif_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Eumbi enguk, “Manda et walɨ biañgan sɨnɨk. Tɨmbi ñɨndɨñgot sanlet: tɨkap sɨndɨ Ama Sɨsɨnɨk nokok pɨñgɨpna gɨt wekatna nɨm nanekalɨñda, kuñgu sɨsɨnɨk walɨ nɨm pat-samekak. ");
INSERT INTO nif_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Gan nokok pɨñgɨpna gɨt wekatna na-ta-kulaktɨ kuñgu taletalen nɨmnat wɨn ip palmɨlak, tɨmbi nain taletalennan natna en kɨmnan nanin tɨmba mɨlalekak. ");
INSERT INTO nif_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wɨn kusei ñɨndɨñda: nokok pɨñgɨpna gɨt wekatna walɨ nanañ tuk sɨsɨnɨk. ");
INSERT INTO nif_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wɨndɨñda tɨmbi nin endɨ nokok pɨñgɨpna gɨt wekatna na-ta-kulak, endɨ nakɨta galɨ-kwambɨñ dambi kulak, tɨmbi nak en gɨta galɨ-kwambɨñ dambi kulet. ");
INSERT INTO nif_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Bep kuñgu molomdɨ nanɨ-mupi, kuñgu namgukta tɨmbi kulet. Wɨndɨñgangot nin endɨ nak nep na-ta-kulakta, nak kuñgu sɨsɨnɨk wɨn ip pa mɨletta tɨmbi endɨ papat kwambɨñgan kuukak. ");
INSERT INTO nif_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nanañ kunum gɨnañ nanin pɨñguk wɨn natna wakan. Nanañ ñalɨ bep pañdɨ nanañ koi mana wɨn nambi, kukap sembɨñgɨlɨñ wandin nɨm. Tambo nin endɨ nanañ ñɨn pa nalakta, endɨ papat kwambɨñgan kuukak.” ");
INSERT INTO nif_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesulɨ Kapaneam it kwelan papi, it kiyau gɨnañ amatam enɨ-daut tɨ-semguk, wolonda endɨ manda wɨndɨñ eñguk. ");
INSERT INTO nif_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Amatamdɨ Yesulɨ enlok pɨñgɨu gɨt wekai nanala manda eum nandɨmbi, en kle-kuñgɨlɨñ, endoñnan nanin asuptɨ ñɨndɨñ eñgɨlɨñ, “Manda ñɨn mɨlap sɨnɨk yañ. Nindɨ sɨnɨk kɨndem nandɨ-dasiuk?” ");
INSERT INTO nif_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Gan endɨ e-balep wɨndɨñ tɨñgɨlɨñ wɨn Yesulɨ enlok gɨnan gɨnañ ikan nandɨ-daklembi enguk, “Manda walɨ sɨndok nanandɨ-kɨlɨktɨnjɨ tɨmbɨ kolalak ba? ");
INSERT INTO nif_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wɨndɨñda tɨmbi tɨkap sɨndɨ nak Ama Sɨsɨnɨktɨ dama pakutnan undane lowambi nambɨnelɨñda, nɨtek nandɨ-namnelɨñ? ");
INSERT INTO nif_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Wɨn Kunum Yambattok Woñɨn walɨ wakan kuñgu sɨsɨnɨk wɨn samlak, tɨmbi kwelan ama nolɨ wolok sep plaptauktok tuop nɨm. Wɨn natna manda sanɨ-talelet walɨ sep tɨmbɨ pañgɨtaumbi, sɨndɨ Woñ wakɨt kuñgu sɨsɨnɨk wɨn gumañ kasɨleañ. ");
INSERT INTO nif_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ganmek sɨndoñnan nanin dɨwɨndɨ nokok mandana nɨm nandɨ-dasiañ.” (Yesulɨ manda wɨn eñguk wɨn kusei ñɨndɨñda: endɨ kenan kusei kɨmɨkuknan ikan yambɨ-nandɨ-dakleñguk, wɨn ama nindɨ en nɨm nandɨ-kɨlɨktɨ tɨñmɨñgɨlɨñ, ba nin sɨnɨktɨ en kanjɨkñiilok kɨsɨnan kɨmɨlekak.) ");
INSERT INTO nif_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Tɨmbi yousɨmbi enguk, “Amatam dɨwɨndɨ nokok mandana nɨm nandɨ-dasiañda tɨmbi nak ñɨndɨñ ikan sanɨt: tɨkap Beptɨ ama no nɨm nandɨ-taleñmekta, endɨ nokoñ bɨmbi, nep kle-kuuktok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Yesulɨ manda wɨndɨñ eu taleumbi, en kle-kuñgɨlɨñnan nanin asuptɨ en siñgi wɨlɨm ñambi, en gɨta nombo nɨm kuñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wɨndɨñda tɨmbi Yesulɨ gwañgwañii 12 enɨ-nandɨmbi eñguk, “Ba sɨndɨ bo nak nambɨk bimbi, ñanepi nandañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Eumbi, Simon Petlolɨ tambane nɨñguk, “Wopum, nɨndɨ dɨk gambineñda, nindoñ sɨnɨk ñaneñ? Neta, manda kuñgu taletalen nɨmnat wɨn tɨmbɨ inda-nɨmlak wɨn dɨk noñgandɨñgot pa nɨnɨlañ. ");
INSERT INTO nif_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Tɨmbi nɨndɨla ikan gambɨ-nandɨ-daklembi, nandɨ-kwambɨñ damɨñ, wɨn dɨk wakan Kunum Yambattɨ gep danbi ganɨ-mukuk.” ");
INSERT INTO nif_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tɨmbi Yesulɨ tambane enguk, “Natnañgan gwañgwa 12 sep kasɨleñgut. Ganmek sɨndoñnan nanin nolɨ kolan molomdok gɨñgɨt kulak.” ");
INSERT INTO nif_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Wɨndɨñ eñguk wɨn Simon Iskaliottok nɨñañ Judas enda eñguk. Wɨn kusei ñɨndɨñda: Judas endɨ gwañgwa 12 endoñnan nanin no, ganmek endɨ Yesu kanjɨkñiilok kɨsɨnan kɨmɨlepi tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wolok siñgi kandañ Juda ama biesɨlɨ Yesu wɨlɨ kɨmnelɨñdok telak lonjɨñgɨlɨñda tɨmbi, endɨ Judia kwelan nombo nɨm kuñgulok nandɨmbi, Galili kwet wandɨñ kandañ kle-gɨmbut ñambi kuñguk. ");
INSERT INTO nif_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tɨmbi Juda amatamdok gwɨlat no, wɨn gonjala it gɨnañ papattok gwɨlat walɨ dumalañguk. Gwɨlat wɨn Jelusalem indauptok tɨñgukta tɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yesulok kwayañiilɨ ñɨndɨñ nɨñgɨlɨñ, “Dɨk ñalinin pɨmbi, gwɨlatta Judia kwelan ñambi, kundit engano pa tɨlañ wɨn wolok tɨmbekañ. Wɨndɨñda amatam gep kle-kuañ endɨ wɨn gumañ kanelɨñ. ");
INSERT INTO nif_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Neta, kot gɨñgɨt tɨkeuktok nandɨlaktɨ kena pat-sembɨn nɨm pa tɨlak. Dɨk kundit wandin pa tɨlañda tɨmbi, kwelan kuañ gɨtɨk enda dɨkok kusaka tɨmbɨ inda-dakle-semun.” ");
INSERT INTO nif_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Yesulok kwayañiilɨ bo en Mesia sɨnɨk wɨn nɨm nandɨ-kwambɨñ dañgɨlɨñda tɨmbi manda wɨndɨñ eñgɨlɨñ.) ");
INSERT INTO nif_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wɨndɨñda Yesulɨ tambane enguk, “Nokok nainna gama nɨm indañguk, gan sɨndɨla gwɨlatta nain no ba nola ñanepi ñanelɨñ, walɨ bo kɨndemgot. ");
INSERT INTO nif_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wɨn kwelalok gɨñgɨtñiilɨ kusei nɨmnat nɨtek tɨmbi sambɨ-kunjit tɨ-samnelɨñ, gan nakta endok kunditsɨ kolan wɨn ewa dakle-ta-kuletta tɨmbi, endɨ nambɨ-kunjitta pa tɨ-namañ. ");
INSERT INTO nif_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Sɨndɨ sɨngan gwɨlatta Jelusalem ñanekalɨñ, gan nakta nainna gama nɨm indañgukta tɨmbi nɨm ñautat.” ");
INSERT INTO nif_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Wɨndɨñ embi, Galili kwelan wɨñgan pakuk. ");
INSERT INTO nif_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesulok kwayañiilɨ Jelusalem gwɨlatta ña-taleumbi, endɨ bo ñañguk, gan endɨ indañgan nɨm ñañguk, endɨ pat-sembɨn gitañgitak ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tɨmbi gwɨlat wolonda Juda ama biesɨlɨ en lonjɨmbi, “Ama wɨn dek?” embi, e-nandɨ-ta-kuñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tɨmbi kɨmɨn wopumdok boñgɨpsɨnan asuptɨ Yesulok plon manda janjat eñgɨlɨñ. Dɨwɨndɨ “Endɨ ama kɨndem” wɨndɨñ eumbi, dɨwɨndɨ ñɨndɨñ eñgɨlɨñ, “Nɨm, endɨ amatam nanandɨnjɨ tɨmbɨ kamalalak.” ");
INSERT INTO nif_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gan Juda ama biesɨla mɨsɨñgɨlɨñda tɨmbi ama nolɨ Yesulok plon manda indañgan no nɨm eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Gwɨlat ip palɨm boñgɨptaumbi, Yesulɨ tapma it sañ jimba gɨnañ lombi, kusei kɨmɨpi, amatam enɨ-daut tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tɨmbi Juda ama biesɨlɨ endok mandan nandɨmbi, nanandɨ kena tɨmbi eñgɨlɨñ, “Endɨkñe manda nandɨ-tale ama nolɨ en nɨm nɨ-daulɨmɨñguk, gan nɨtek tɨmbi nandɨnandɨ wopum wandin palmɨlak?” ");
INSERT INTO nif_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wɨndɨñ eumbi, Yesulɨ tambane enguk, “Nak nanandɨ emlet wɨn natnaloñnan nanin nɨm, wɨn Kunum Yambat nindɨ nanɨ-mukuk endoñnan nanin. ");
INSERT INTO nif_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tɨmbi no endɨ Kunum Yambattok man kɨmɨt-kleuptok nandɨmbi kɨmɨt-klelak, endɨ ka-nandɨ-dakleukak, wɨn nanandɨ walɨ denanin sɨnɨk, wɨn Kunum Yambattoñnan nanin, ba ama sɨlanin no nomɨk natnalok nanandɨnala pa elet. ");
INSERT INTO nif_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Enlok nanandɨnla manda elaktɨ enlok koi gɨñgɨt tɨke-louptok wɨndɨñ pa tɨlak. Gan nin endɨ nɨ-mukuk endok koi gɨñgɨt tɨke-louptok kena tɨlak, endɨ biañgan molom, juluñɨt endok kandañ no nɨm palmɨlak. ");
INSERT INTO nif_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moselɨ Kunum Yambattok endɨkñe mandan sɨndok bep pañjiila enɨ-daut tɨ-semguk wɨn pat-samlak, gañgan sɨndoñnan nanin nolɨ manda gɨtɨk wɨn no nɨm kɨmɨt-kleañ. Wɨndɨñda tɨmbi sɨndɨ kusei nekta nak sɨnɨk nepbi, nɨlɨm kɨmbettok telak lonjañ?” ");
INSERT INTO nif_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Eumbi, kɨmɨn gɨtɨktɨ tambane nɨñgɨlɨñ, “Nindɨ gwɨlɨ kɨmbeñdok telak lonjɨlak? Yal kolandɨ pɨ-gamumbi, e-kamakama tɨlañ!” ");
INSERT INTO nif_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Eumbi enguk, “Nak Sabat patnandɨ nainnan kundit engano noñgan tɨñgutta tɨmbi, sɨndɨ gɨtɨk wala nandum pɨumbi, nanandɨ kena tañ. ");
INSERT INTO nif_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sɨndok kandañ, sɨndɨ nɨñañjiilok siñginjɨ dɨp gwɨlap wɨn Sabat patnandɨ nainnan bo pa dombañ, Moselɨ bep pañjiila enguk wolok tuop. (Gan dombɨ kundit telak wɨn Moseloñ nanin nɨm, wɨn sɨndok bep pañjiiloñ nanin.) ");
INSERT INTO nif_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tɨkap sɨndɨ Moselok endɨkñe mandan wɨn nɨm wɨtnelɨñdok nɨñañjiilok siñginjɨ dɨp gwɨlap wɨn Sabat patnandɨ nainnan bo kɨndem pa dombañda, nɨtek tɨmbi sɨndɨ nak Sabat patnandɨ nainnan ama nolok siñgin gɨtɨk tɨmba kɨndem da-taleñguk, wala gimbɨt tɨ-namañ? ");
INSERT INTO nif_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Sɨndɨ yop tambi, ama dausɨlɨñgot yambɨ-danbi, yom plon nombo nɨm yapɨtnekalɨñ. Tambo sɨndɨ nek walɨ Kunum Yambattok dainan dɨndɨm sɨnɨk wolok tuop ama yambɨ-danbi, dɨndɨmgan tɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wolonda Jelusalem nasi dɨwɨndɨ kusei kɨmɨpi, nɨsɨñgan Yesulok plon ñɨndɨñ e-nandɨ tɨmbi eñgɨlɨñ, “Nɨndok ama biesɨlɨ ama wɨwɨttok nandañ wɨn ñakan bek. ");
INSERT INTO nif_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nɨtek tɨmbi endɨ ñolok indañgan ipi, manda samakgan elak, tɨmbi ama biesɨlɨ enda manda no nɨm nɨañ? Ba endɨ en Mesia sɨnɨk wɨndɨñ biañgan nandɨ-ñɨmañ bek? ");
INSERT INTO nif_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Gan nɨtek? Mesia en indaumek, endɨ denanin wɨn no nɨm nandɨñmɨnekalɨñ, gan nɨndɨla ama ñolok il kusei wɨn nandɨñmamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wɨndɨñda tɨmbi Yesulɨ tapma it sañ jimba gɨnañ amatam enɨ-daut tɨ-semñɨpi, manda tambon ñɨndɨñ wopumgan eu pɨñguk, “Sɨndɨ nokok kusatna nandɨ-nambi, nak denanin wɨn biañgan nandɨ-namañ ba? Gan nak natnalok nanandɨnala nɨm bɨ indañgut. Tambo nin nak nanɨ-mukuk, endɨ biañgan molom sɨnɨk. Sɨndɨla en nɨm nandɨñmañ, ");
INSERT INTO nif_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","gan nakta en nandɨ-kɨliñ tɨñmɨlet, wɨn kusei ñɨndɨñda: nak en gɨta palambi nanɨ-mulɨmbi, pɨ indañgut.” ");
INSERT INTO nif_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesulɨ Kunum Yambattoknan nanin pɨñguk wɨndɨñ eñgukta tɨmbi ama dɨwɨndɨ en tɨkenepi tɨ-tɨlakɨlɨñ, gan endok kɨmkɨmlok nainñɨn gama nɨm indañgukta tɨmbi, amalɨ en tɨkenelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ganmek kɨmɨn gɨtɨk endok boñgɨpsɨnan amatam asuptɨ Yesu en Mesia sɨnɨk wɨn nandɨ-kwambɨñ dambi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Ama ñalɨ Mesia wandin indambi, jimba kundit asup pa tɨlak! Ama nolɨ indam, en makleuktok tuop nɨm bek ya.” ");
INSERT INTO nif_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kɨmɨn gɨtɨktɨ Yesulok plon manda janjat wɨndɨñ eumbi, Falisi amalɨ wɨn nandɨmbi, tapma ama biesɨla enbɨmbi, endɨ tapma ittok kamaikamai ama dɨwɨn yakan enɨ-mulɨmbi, Yesu tɨkenepi ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tɨmbi Yesulɨ eñguk, “Nak nain dumangangot sɨn gɨta gama paletat. Pakap, nanɨ-mukuk endoñ undane ñawambi, ");
INSERT INTO nif_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","sɨndɨ nak nep lonjɨmbi, nɨm nambɨnekalɨñ, tɨmbi nak paletatnan sɨndɨ ñanelɨñdok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wɨndɨñ eumbi, Juda ama biesɨlɨ nɨsɨñgan ñɨndɨñ e-nandɨñgɨlɨñ, “Nɨndɨ en lonjɨmbi nɨm kanekamɨñ, wɨndɨñ elakta tɨmbi endɨ dendɨñ ñaupi elak? Ba endɨ nɨndok notnii dɨwɨn papusenem papi, Grik amalok boñgɨpsɨnan kuañ endoñ ñambi, Grik ama enɨ-daut tɨ-semepi elak ba? ");
INSERT INTO nif_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tɨmbi nɨndɨ lonjɨnekamɨñ, gan nɨm kanekamɨñ, tɨmbi nɨndɨ endɨ palekaknan ñaneñdok tuop nɨm wɨndɨñ elak, manda wolok kusei wɨn nɨtek?” ");
INSERT INTO nif_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gonjala it gwɨlat wolok nain taletalen walɨ loloñ sɨnɨk. Sandap wolonda Yesulɨ tapma it sañ jimba gɨnañ mɨlap ipi, kɨtɨ-kolɨ pɨumbi eñguk, “No en tukta kɨmlakta, endɨ nokoñ bɨmbi nambɨn! ");
INSERT INTO nif_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kunum Yambattok mandan youyoulɨn patak, wolok tuop nin endɨ naka nandɨ-kɨlɨktɨ tɨ-namlakta, ‘tuk en tɨmbɨ kaiktauktok walɨ endok gɨnan gɨnañ tokñe map pɨne-ta-ñaukak.’” ");
INSERT INTO nif_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesulɨ tuktok plon eñguk, wɨn endɨ Dɨndɨm Woñlok plon eñguk. (Wɨn Yesu nandɨ-kɨlɨktɨ tɨ-ñɨmañdɨ Woñ wɨn kasɨlenepi tɨñgɨlɨñ, gan nain wolonda Kunum Yambattɨ Yesulok pipapal engano patak wolok undane louktok gama nɨm tɨke-loñgukta tɨmbi Dɨndɨm Woñ gama nɨm nɨ-mulɨmbi, kwelan pɨñguk.) ");
INSERT INTO nif_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yesulɨ wɨndɨñ eumbi nandɨñgɨlɨñ, wolonda dɨwɨndɨ ñɨndɨñ eñgɨlɨñ, “Biañgan sɨnɨk, ama ñalɨ plofet indaindalok een ip en wakan.” ");
INSERT INTO nif_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Tɨmbi dɨwɨndɨ eñgɨlɨñ, “Endɨ Mesia sɨnɨk.” Gan dɨwɨndɨ ñɨndɨñ eñgɨlɨñ, “Nɨm ya! Mesialɨ Galili kwelan nɨm indauktok een! ");
INSERT INTO nif_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Manda youyoulɨn patak walɨ ñɨndɨñ elak: Mesialɨ Devittok komblin, tɨmbi endok il kusei Betleem wandɨñ indaukak.” ");
INSERT INTO nif_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wɨndɨñda tɨmbi amatamdɨ Yesu en nin wala embi tambɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Tɨmbi dɨwɨndɨ en tɨkenelɨñdok nandɨ-galk tɨñgɨlɨñ, gan ama nolɨ en nɨm tɨke-kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tɨmbi tapma it kamaikamai amalɨ undanembi, tapma ama biesɨ gɨt Falisi amaloñ ña tombɨmbi, endɨ enɨ-kañbi eñgɨlɨñ, “Kusei nekta sɨndɨ en nɨm tɨke nañgɨpi bañ?” ");
INSERT INTO nif_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Eumbi tambane engɨlɨñ, “Manda elak wandin ama nolɨ no nɨm eumbi nandɨñgɨmɨñ!” ");
INSERT INTO nif_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Eumbi, Falisi amalɨ enombɨmbi eñgɨlɨñ, “Nɨm kañbi, endɨ sɨnda bo juluñɨt tɨ-samek. ");
INSERT INTO nif_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ba kandɨkñe ama gɨt Falisi ama nɨndoñnan nanin nolɨ Yesu wɨn nandɨ-kɨlɨktɨ tɨñmɨñguk ba? Nɨm yañ! ");
INSERT INTO nif_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wɨn kɨmɨn gɨtɨk, nindɨ Moselok endɨkñe manda nɨm nandɨ-dakleañda tɨmbi jɨmbɨñdok gɨñgɨt kunelɨñdok nandɨ-semamɨñ, endɨ wakan Yesu nandɨ-kɨlɨktɨ tɨñmañ.” ");
INSERT INTO nif_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tɨmbi ama biesɨ endoñnan nanin no koi Nikodemus, ama nindɨ damañgan tim no Yesu kauptok ñañguk, endɨ ñɨndɨñ enguk, ");
INSERT INTO nif_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nɨndok endɨkñe mandanɨlɨ ñɨndɨñ tɨneñdok elak: nɨndɨ yop tambi, ama kɨt yout tamɨñ tambon manda ena taleumbi, wɨndɨñ nɨm tɨñmɨlok. Tambo nɨndɨ endok ep tɨndɨn wɨn eu inda-dakleuktok nain mɨmbi, endok kusal wɨn ka-nandɨ-daklembi, wolok siñgi kandañmek endok mandan ena talelak.” ");
INSERT INTO nif_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Eumbi, noliilɨ tambane nɨñgɨlɨñ, “Nɨm kañbi, dɨtna bo endok nol no Galili nanin! Tɨkap dɨk manda youyoulɨn patak wɨn pinat-lonjɨlonjɨ tɨmbeñda, dɨk ka-dakleuñ, wɨn Galili kwelan plofet ama no nɨm indanelɨñdok een.” ");
INSERT INTO nif_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wɨndɨñ eumbi, endɨ walinin pɨm ñambi, isɨnan ña-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Gan Yesu endɨla Oliv kwet jañgɨnnan ñambi loñguk. ");
INSERT INTO nif_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kwet salawa salawa tɨmbɨmbi, Yesulɨ tapma it sañ jimba gɨnañ bɨndambo undane loumbi, amatam gɨtɨktɨ endoñ bɨm kle-gɨmbulɨmbi, endɨ pip papi, kusei kɨmɨpi enɨ-daut tɨ-semguk. ");
INSERT INTO nif_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tɨñɨlɨmbi, endɨkñe manda nandɨ-tale ama gɨt Falisi ama dɨwɨn endɨ tam wapaiat no telak joñgo kuum kañbi tɨkeñgɨlɨñ wɨn nañgɨp bɨmbi, amatam Yesulok mandan nandɨ-pakɨlɨñ endok boñgɨpsɨnan kɨmɨlɨm ilɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Yesula nɨmbi eñgɨlɨñ, “Endaut, tam ñɨn telak joñgo kuñɨlɨmbi tɨkeumbi, nañgɨpi bamɨñ. ");
INSERT INTO nif_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moselok endɨkñe mandalɨ tam wandisɨ wɨn kawattɨ yandɨp kɨm tɨndɨlok nɨnlak. Ale, dɨkta nɨtek tɨ-ñɨmɨneñdok ewɨñ?” ");
INSERT INTO nif_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Endɨ Yesu manda plon kɨmɨtnelɨñdok kusei lonjɨmbi, mandanjɨlɨ sɨsoñ tɨñmɨnep nandɨmbi, wɨndɨñ nɨ-nandɨñgɨlɨñ. Gan Yesulɨ nandɨ-kɨmnembi, mumuñanembi, kwet kwɨlɨñ plon kii nɨñanlɨ kundit youkuk. ");
INSERT INTO nif_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tɨñɨlɨmbi, nombo nombo nɨ-nandumbi, mɨlap ipi enguk, “Sɨndoñnan nanin nindɨ yom no nɨm tɨñguk, wandin walɨ kɨndem telak dama tɨ-sambi, kawat tɨke kopi wɨlɨn.” ");
INSERT INTO nif_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tɨmbi Yesulɨ bɨndambo mumuñanembi, kwet kwɨlɨñ plon kii nɨñanlɨ kundit youkuk. ");
INSERT INTO nif_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tɨmbi amalɨ manda wɨn nandɨmbi, endɨ kusei kɨmɨpi, noñgan noñgandɨ walinin pɨm ñañgɨlɨñ, wɨn ama gwɨlatsɨ wopum endɨ dama ñaumbi, dɨwɨndɨ bo ep klem ña-taleumbi, Yesu gɨta tam endɨñgot pakɨmɨk. ");
INSERT INTO nif_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Tɨmbɨmbi Yesulɨ mɨlap deimbi, tam nɨ-nandɨmbi eñguk, “Tam, ama kɨt yout tɨ-gamlɨñ endɨ dek? Ba dɨkok yomgalok tambon ombɨ-tɨkeuñdok ama nolɨ nombo nɨm elak ba?” ");
INSERT INTO nif_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Eumbi nɨñguk, “Wopum, no nɨm.” Tɨmbi Yesulɨ nɨñguk, “Nak bo dɨk tamboñga ombɨ-tɨkeuñdok nɨm elet. Kɨndem a, ñau, tɨmbi yom nombo nɨm tɨ-ta-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tɨmbi Yesulɨ bɨndambo amatamda manda enbi eñguk, “Kwelan kuañdok kolsalen wɨn natna. No en nak nep kle-kulakta, endɨ nain no ba nola kɨlɨm gɨnañ nɨm kuukak. Tambo endɨ kolsalen kuñgu sɨsɨnɨk mɨlak walɨ palmekak.” ");
INSERT INTO nif_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tɨmbi Falisi amalɨ manda wala nandum pɨumbi nɨñgɨlɨñ, “Dɨtnalok kusaka e-daklelañda tɨmbi manda elañ walɨ biañgan nɨm tɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Eumbi tambane enguk, “Wɨndɨñ nɨm. Nak natnalok kusatna e-daklelet, ganmek nokok mandanalɨ biañgan tɨlak, wɨn kusei ñɨndɨñda: nak denanin bɨñgut ba dendɨñ ñautat wɨn nandɨ-talelet. Gan sɨndɨla nak denanin bɨñgut ba dendɨñ ñautat wɨn nɨm nandañ. ");
INSERT INTO nif_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tɨmbi sɨnlok nanandɨnjɨlok tuop ama pa yambɨ-danɨ tɨ-semañ, gan nakta wɨndɨñ nɨm pa tɨlet. ");
INSERT INTO nif_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Gan tɨkap nak ka-danɨ kena tɨmbetta, nak wɨn natnañgan nɨm tɨmbet, tambo Bep nak nanɨ-mukuk en nɨtɨ ka-danɨ kena wɨn yakan tamɨk, wala tɨmbi walɨ dɨndɨm euk. ");
INSERT INTO nif_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Tɨmbi sɨnlok endɨkñe mandanjɨ gɨnañ manda no ñɨndɨñ youyoulɨn patak: tɨkap ama tɨpettɨ nepek nolok plon gembɨ ipi, manda noñgan eamɨkta, endok mandanjet walɨ biañgan. ");
INSERT INTO nif_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ale, sɨndɨ nokok mandanala wɨndɨñgangot nandum biañgan tɨmbekak. Neta, natnalok kusatna e-daklelet, tɨmbi Bep nanɨ-mukuk endɨ bo gembɨ it-nambi, nokok kusatna e-daklelak.” ");
INSERT INTO nif_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yesulɨ wɨndɨñ eumbi, endɨ nɨ-nandɨmbi eñgɨlɨñ, “Tɨmbi dɨkok bepka gembɨ it-gamlak endɨ dek?” Eumbi enguk, “Sɨndɨ nak nɨm nandɨ-namañ, ba nokok Bepna bo nɨm nandɨ-ñɨmañ. Neta, tɨkap sɨndɨ nak nin sɨnɨk wɨn nandɨ-namumda, nokok Bepna en bo ip nandɨñmɨnelɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Yesulɨ tapma it sañ jimba gɨnañ papi, tapɨkot mɨnem dasiyañgɨlɨñ kandañ wolok pipapi, amatam enɨ-daut tɨ-semñɨpi, manda wɨn eñguk. Ganmek en wɨlɨ kɨmnelɨñdok nain walɨ gama nɨm indañgukta tɨmbi, ama nolɨ en nɨm tɨkeñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Tɨmbi Yesulɨ yousɨmbi, ñɨndɨñ enguk, “Nain nɨm ombataumbi, nak sambim ñautat, tɨmbi sɨndɨ Mesia lonjɨ-tɨlapi, sɨndok yomjɨ gama pat-samumbi kɨmnekalɨñ. Tɨmbi natna ñautatnan sɨndɨ ñanelɨñdok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Wɨndɨñ eñgukta tɨmbi Juda ama biesɨlɨ nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Endɨ elak, wɨn endɨ ñaukaknan nɨndɨ ñaneñdok tuop nɨm. Wɨndɨñ elakta tɨmbi endɨ enlok kuñgun tɨmbɨ kolauktok elak ba nɨtek?” ");
INSERT INTO nif_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Tɨmbi Yesulɨ yousɨmbi enguk, “Sɨndɨla kwelan nanin, gan nakta kunum gɨnañ nanin. Sɨndɨla kwet ñolok gɨñgɨt, gan nakta kwet ñolok gɨñgɨt nɨm. ");
INSERT INTO nif_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kusei wala tɨmbi nak ñɨndɨñ sanɨt: sɨndok yomjɨ gama pat-samumbi kɨmnekalɨñ. Wɨn tɨkap sɨndɨ nokok kusatna papat kwambɨñ wɨn nɨm nandɨ-kwambɨñ dañda, sɨndok yomjɨ biañgan pat-samumbi kɨmnekalɨñ ñak.” ");
INSERT INTO nif_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Eumbi nɨ-nandɨñgɨlɨñ, “Dɨk nin sɨnɨk wɨn nɨnbɨ nandɨna.” Eumbi tambane enguk, “Nak nin? Wɨn nak kena kusei kɨmɨkɨmɨlɨnan eñgut ip wakan. ");
INSERT INTO nif_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nak sɨndok kusasɨ tɨmba inda-dakleumbi sanɨ-danbettok manda asupgan gumañ ewɨt. Tɨmbi manda elet walɨ biañgan sɨnɨk. Neta, nanɨ-mukuktɨ biañgan molom sɨnɨk, tɨmbi nak endɨ manda nanbɨmbi nandɨlet, wɨndɨñgangot kwelan kuañda pa enlet.” ");
INSERT INTO nif_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesulɨ Bep Yambattok plon manda enguk wɨn nɨm nandɨ-dakleñgɨlɨñda tɨmbi ");
INSERT INTO nif_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesulɨ yousɨmbi enguk, “Sɨndɨ nak Ama Sɨsɨnɨk kloñbat plon nep lomek, ñɨndɨñ nambɨ-nandɨnekalɨñ: kusatna sangut wɨn natna, tɨmbi natnalok nanandɨnala nepek no nɨm pa tɨlet, tambo Beptɨ nanandɨ namguk wolok tuopgangot nak manda pa elet. ");
INSERT INTO nif_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tɨmbi nanɨ-mukuk en wakan nakɨta pat-ta-kulak, wɨn endɨ nokok ep tɨndɨna gɨtɨk wɨn kau kɨndem dalakta tɨmbi nain nola nak nɨm nambiñguk.” ");
INSERT INTO nif_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Manda wɨndɨñ eñɨlɨmbi, amatam asuptɨ en Mesia sɨnɨk wɨn nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Tɨmbi Yesulɨ Juda ama nin ip nandɨ-kɨlɨktɨ tɨñmɨñgɨlɨñ enda ñɨndɨñ enguk, “Tɨkap sɨndɨ nokok mandana kɨmɨt-kle tɨ-ta-kuañda, sɨndɨ nokok gwañgwanai biañgan sɨsɨnɨk, ");
INSERT INTO nif_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","tɨmbi Kunum Yambattok kusal sɨsɨnɨk wɨn ka-nandɨ-talenekalɨñ. Tɨmbi walɨ sep pɨsalɨmbi, sɨndɨ samaktangan kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Eumbi, endɨ manda wala nandum pɨumbi, tambane nɨñgɨlɨñ, “Nɨndɨ Ablaamdok komblinñii, nain nola ama nolok kapmainan kena gwañgwa sɨlanin no nɨm kuñgɨmɨñ. Nɨtek tɨmbi dɨk elañ, wɨn walɨ nɨp pɨsalɨmbi, samaktangan kunekamɨñ?” ");
INSERT INTO nif_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Eumbi tambane enguk, “Sɨndɨ Ablaamdok komblinñii wɨn biañgan sɨnɨk. Gan nak ñɨndɨñ sanba: amatam yom tɨ-kuañ gɨtɨk endɨ yomjɨlɨ ep topmumbi, kena gwañgwa sɨlanin wandin wolok kapmainan kuañ. ");
INSERT INTO nif_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tɨmbi sɨndɨ yomlok kena gwañgwa sɨlanin kuañda tɨmbi Kunum Yambattok ilan pipapat kwambɨñ nɨm pat-samlak, gan nak Molomdok Nɨñañdɨ Bepnalok ilan papat kwambɨñgan kulet. ");
INSERT INTO nif_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Wɨndɨñda tɨmbi tɨkap sɨndɨ nak nandɨ-tale-namnelɨñda, nak Molomdok Nɨñañdɨ yomdok toptopnan nanin sep pɨsalambi, sɨndɨ biañgan Kunum Yambattok sambalii samaktangan kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tɨmbi Yesulɨ yousɨmbi enguk, “Sɨndɨ Ablaamdok sambalii wɨn nandɨ-samlet, ganmek sɨndɨ nokok mandana nɨm nandɨ-dasiañda tɨmbi nɨlɨ kɨmbettok telak lonjañ. ");
INSERT INTO nif_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nakta Bepnalok kandañ nek kañgut wala manda elet, gan sɨndɨla sɨnlok bepsɨlɨ sanguk wolok tuopkan pa tañ.” ");
INSERT INTO nif_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Eumbi tambane nɨñgɨlɨñ, “Nɨnɨlok bep pañnɨ wɨn Ablaam en wakan.” Eumbi enguk, “Tɨkap Ablaamdɨ sɨndok bep pañjɨ sɨsɨnɨk palɨmda, sɨndɨ endok telak kɨndem wɨn ikan kɨmɨt-klembi kunelɨñ. ");
INSERT INTO nif_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Gan nɨtek? Nak Kunum Yambattok kusal sɨsɨnɨk wɨn endoñnan nanin kasɨleñgut wakangot pa sanlet, gañgan sɨndɨ nɨlɨ kɨmbettok telak lonjañ wɨn! Ablaamdɨ kundit wandin no nɨm tɨñguk, ");
INSERT INTO nif_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","wala tɨmbi endɨ sɨndok bep pañjɨ sɨsɨnɨk nɨm. Sɨndok bepsɨ sɨsɨnɨk no patak, tɨmbi sɨndɨ endok wekai pa kleañ.” Wɨndɨñ eñgukta tɨmbi nɨñgɨlɨñ, “Nɨnɨlok menɨ patnɨ Salalɨ telak joñgo wandin no nɨm kuñɨpi nɨpguk. Nɨm sɨnɨk. Nɨndɨ Ablaamdok komblinñii, wala tɨmbi Kunum Yambat en noñgandɨ nɨndok Bepnɨ sɨsɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Wɨndɨñ eumbi enguk, “Tɨkap Kunum Yambattɨ biañgan sɨndok Bepsɨ sɨsɨnɨk palɨmda, sɨndɨ gɨnañjɨlɨ nep kasɨlenelɨñ. Wɨn kusei ñɨndɨñda: wɨn Kunum Yambat enlok kandañnan nanin nak pɨmbi, kwelan ñolok indañgut patet. Tɨmbi natnalok nanandɨnala wɨndɨñ nɨm tɨñgut. Tambo endɨ nak nanɨ-mulɨmbi pɨ indañgut. ");
INSERT INTO nif_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nak manda elet wɨn sɨndɨ kusei nekta nɨm nandɨ-dakleañ? Wɨn kusei ñɨndɨñda: sɨndɨ nokok mandana nandɨ-dasindasila kunjit pa tañ. ");
INSERT INTO nif_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Sɨndɨ wɨn bepsɨ Satan endok komblinñii, tɨmbi endok wekai klembi, endɨ nɨtek tɨmbep nandɨ-galk talak wɨn sɨndɨ tɨnep nandañ. Nain kusei kɨmɨkɨmɨlɨnan nanin endɨ amatam ep tɨmbɨ kola tɨ-ta-bɨlak. Tɨmbi juluñɨt molom sɨsɨnɨkta tɨmbi endɨ kusei sɨsɨnɨk wɨn nain no ba nola nɨm pa kɨmɨt-klelak. Tambo endɨ juluñɨt molom gɨtɨktok kusei, wala tɨmbi juluñ manda elak wɨn enlok gɨnañ nanandɨn klembi pa elak. ");
INSERT INTO nif_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gan nakta Kunum Yambattok kusal sɨsɨnɨk wɨn sanletta tɨmbi, sɨndɨ nokok mandana nɨm nandɨ-kwambɨñ dañ. ");
INSERT INTO nif_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Sɨndoñnan nanin nolɨ nak kolan tɨñgut wɨn tɨmbɨ inda-dakleuktok tuop nɨm. Wɨndɨñda tɨmbi nak endok kusal sɨsɨnɨk wɨn sanletta, sɨndɨ nɨtekta tɨmbi mandana nɨm nandɨ-kwambɨñ dañ? ");
INSERT INTO nif_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kunum Yambattok gɨñgɨtñiilɨ endok mandan pa nandɨ-dasiañ, gan sɨndɨla endok gɨñgɨtñii nɨm kuañda tɨmbi wɨndɨñ nɨm pa tañ.” ");
INSERT INTO nif_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tɨmbi Juda ama Yesulok mandan nandɨ pakɨlɨñ endɨ ñɨndɨñ nɨñgɨlɨñ, “Dɨk Samalia ama pɨmbɨñen yal kolannat wɨndɨñ eñgɨmɨñ, wɨn nɨndɨ manda biañgan eñgɨmɨñ yañ!” ");
INSERT INTO nif_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Eumbi tambane enguk, “Nak yal kolanna nɨmnat. Tambo nokok kuñgunalɨ ba mandanalɨ Bepnalok koi gɨñgɨt tɨmba wopum dalak, ganmek sɨndɨla nokok kotna gɨñgɨt tɨmbɨ kolalak. ");
INSERT INTO nif_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Natna kotna gɨñgɨt tɨke-louptok kena nɨm pa tɨlet. Tambo no patak nokok kotnalɨ gɨñgɨt tɨkeuptok nandɨlak, tɨmbi endɨ wakan amatam gɨtɨk yambɨ-danbekak. ");
INSERT INTO nif_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wɨn biañgan sɨnɨk. Tɨmbi nak ñɨndɨñ sanba: no en nokok mandana kɨmɨt-klembi kulakta, endok plon kɨm nɨm indañmekak. Nɨm sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wɨndɨñ eumbi, Juda amalɨ amalok pɨñgɨpsɨ sɨlanin wala eumbi, wɨndɨñ nandɨñɨpi nɨñgɨlɨñ, “Dɨk yal kolanganat wɨn ip gambɨ-nandɨ-dakleamɨñ! Ablaam gɨta plofet ama endɨ sembɨ-taleñgɨlɨñ, gañgan dɨk wɨn ñɨndɨñ elañ, ‘No en nokok mandana kɨmɨt-klembi kulakta, endok plon kɨm nɨm indañmekak.’ ");
INSERT INTO nif_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Dɨkɨ nɨndok bep pañnɨ Ablaam maklelañ ba? Nɨm ya! En gɨt plofet amalɨ sembɨ-taleñgɨlɨñ, wala tɨmbi dɨk wandin walɨ dɨtnala nandum nin sɨnɨk tɨmbɨmbi, manda wandin elañ?” ");
INSERT INTO nif_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Eumbi, Yesulɨ tambane enguk, “Natna kotna gɨñgɨt tɨke-lowamda, walɨ tlal tɨmbek. Wɨn nokok Bepnalɨ wakan kotna gɨñgɨt pa tɨke-lolak. Sɨndɨ en sɨndok Yambatsɨ kɨtɨañ, ");
INSERT INTO nif_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","gan en nɨm nandɨ-kɨliñ eañ. Natna en nandɨ-kɨliñ tɨñmɨlet. Tɨkap nak ‘en nɨm nandɨ-kɨliñ elet’ wɨndɨñ ewamda, sɨndɨ nomɨk manda juluñgan eut. Gan nak en nandɨ-kɨliñ tɨñmɨmbi, endok mandan kɨmɨt-klembi kulet. ");
INSERT INTO nif_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Sɨndok bep pañjɨ Ablaam endɨla nandɨñguk, wɨn nak kwelan indam kuwambi kauktok, tɨmbi wala sɨlɨsɨlɨ wopum tɨñguk. Tɨmbi endɨ wɨndɨñ indaumbi kañguk, wolonda sɨmbai kɨndem dañguk.” ");
INSERT INTO nif_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wɨndɨñ eumbi nɨñgɨlɨñ, “Akae! dɨk gama gwɨlat 50 nɨm maklelañdɨ nɨtek tɨmbi ‘nak Ablaam kañgut’ wɨndɨñ elañ?” ");
INSERT INTO nif_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Eumbi tambane enguk, “Wɨn biañgan sɨnɨk. Tɨmbi nak ñɨndɨñ sanlet: Ablaamdɨ gama nɨm indañɨlɨmbi, nak papat kwambɨñgan kulettɨ ikan pakut.” Yesulɨ enla wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Juda amalɨ endɨ Kunum Yambat nɨ-tɨke-pɨ-yalilak wɨndɨñ nandɨmbi, wɨtnelɨñdok kawat mekɨlɨñ, gan endɨ yambɨ-sembɨmbi, tapma it sañ jimba gɨnañ nanin pɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nain nola Yesulɨ telaknan ñañɨpi, ama no meñ simbai gɨnañ nanin dai sisipmɨn indañguk wɨn kañguk. ");
INSERT INTO nif_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Tɨmbi endok gwañgwañiilɨ nɨ-kañbi eñgɨlɨñ, “Nɨnɨndaut, wɨn enlok yomda ba meñ beulok yomjetta tɨmbi dai sisipmɨn indañguk?” ");
INSERT INTO nif_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Eumbi enguk, “Wɨn enlok ba meñ beulok yomla tɨmbi nɨm, wɨn Kunum Yambattɨ tɨke-kɨmɨlɨñɨlɨmbi, amatamdɨ endok kundil engano sɨnɨk wɨn ka-daklenelɨñdok dai sisipmɨn indañguk. ");
INSERT INTO nif_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tɨmbi nɨndɨ Bep nak nanɨ-mukuk endok kundil engano wɨn gama sala palɨñɨlɨmbi tɨlok. Nain nɨm ombataumbi, kɨlɨm eumbi, ama nolɨ kena no tɨmbektok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Gan kwelan kulet tuop nak kwelan kuañ endok kolsalenjɨ wakan.” ");
INSERT INTO nif_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wɨndɨñ eu taleumbi, kwet plon iwɨt suambi, kwet gɨt tambaneumbi, ganji indaumbi, ama dai sipsipmɨn dai gwɨlap plon saplembi, ");
INSERT INTO nif_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ñɨndɨñ nɨñguk, “Dɨk Siloam tuk guañnan ñambi, timañga daut wɨlɨt.” (Kot Siloam wɨn nɨnɨlok mandanɨnan ‘nɨ-mumulɨn’.) Tɨmbi ama walɨ ñambi, timan daut wɨlɨlɨmbi, dai tombɨmbi, kɨndem deimbi, ilnan undane ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tɨmbi endok nolii gɨt ama dɨwɨn nin endɨ dama mɨnemda kɨtɨnat tɨ-semñɨlɨumbi kañgɨlɨñ, endɨ en kañbi, nɨsɨñgan e-nandɨ tɨmbi eñgɨlɨñ, “Ama kwelan pipapi, mɨnemda kɨtɨnat tɨlɨñguk en wakan bek.” ");
INSERT INTO nif_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Eumbi, dɨwɨndɨ eñgɨlɨñ, “En ñak,” tɨmbi dɨwɨndɨ ñɨndɨñ pa eñgɨlɨñ, “Nɨm yañ, ama no en nomɨk.” Tɨmbi endɨ enguk, “Wɨn natna ñakan.” ");
INSERT INTO nif_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Eumbi nɨ-nandɨmbi eñgɨlɨñ, “Wɨndɨñda dɨk nɨtek tɨmbi dauka tombɨmbi deilañ?” ");
INSERT INTO nif_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Eumbi tambane enguk, “Ama koi Yesu kɨtɨañ endɨ kwet tɨke ganji tɨmbi, nokok dautna gwɨlap plon saplembi, ñɨndɨñ nanɨk, ‘Dɨk Siloam tuk guañnan ñambi, timañga daut wɨlɨt.’ Wolok tuop nak ñambi, wɨlɨlambi, dautna tomɨk.” ");
INSERT INTO nif_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Wɨndɨñ eumbi, endok noliilɨ “Ama wɨn dek?” nɨ-kaumbi, “Nak en nɨm nandɨñmɨlet” enguk. ");
INSERT INTO nif_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Tɨmbi endɨ ama dama dai sisipmɨn kuñguk wɨn nañgɨpi, Falisi amaloñ ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Wɨn Sabat patnandɨ nainnan Yesulɨ kiilɨ ganji tɨmbi, ama wolok dai plon sapleumbi, dai tomguk, ");
INSERT INTO nif_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","wala tɨmbi Falisi amalɨ wala nandum pɨumbi, endɨ bo kusei kɨmɨpi, telak nɨtek plon dai tomguk wala nɨ-kaumbi, ñɨndɨñ tambane enguk, “Endɨ ganji nokok dautna plon sapleumbi, nak timana daut wɨlɨpi deilet.” ");
INSERT INTO nif_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wɨndɨñda Falisi ama dɨwɨndɨ Yesula ñɨndɨñ eñgɨlɨñ, “Ama walɨ Sabat patnandɨ naindok endɨkñe manda maklembi, kena pa tɨlak, wala tɨmbi Kunum Yambattɨ en nɨm nɨ-mulɨm bɨm indañguk.” Gan dɨwɨndɨ ñɨndɨñ eñgɨlɨñ, “Nɨtek tɨmbi yom amalɨ jimba kundit wandin gumañ pa tɨmbek?” Wɨndɨñ embi, nɨsɨñgan tambɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wɨndɨñda endɨ ama dai sisipmɨn indañguk enda bɨnda nɨ-nandɨmbi eñgɨlɨñ, “Wɨn endɨ dɨtnalok dauka tɨmbɨ tomguk, wala tɨmbi dɨtna ama wala nɨtek sɨnɨk elañ?” Eumbi enguk, “Nak enda nandɨwam endɨ plofet ama no tɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Gan ama walɨ dai sisipmɨn kuumbi, endok dai tomguk, wɨn Juda ama biesɨlɨ gama nɨm nandɨ-kwambɨñ dañgɨlɨñ, wala tɨmbi endɨ ama wolok meñ beu kɨtɨ-semum bɨumbi ");
INSERT INTO nif_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","enɨ-nandɨñgɨlɨñ, “Ñɨne sɨtok nɨñañjet ba? Tɨmbi sɨtɨ dai sisipmɨn indañguk wɨndɨñ eamɨk ba? Wɨndɨñda nɨtek tɨmbi endɨ man ñɨndɨñgɨt deilak?” ");
INSERT INTO nif_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Eumbi tambane engɨmɨk, “En nɨtok nɨñanet, dai sisipmɨn indaindan wɨn nandɨñmamɨk. ");
INSERT INTO nif_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gan nɨtek tɨmbi man ñɨndɨñgɨt deilak, ba nindɨ sɨnɨk endok dai tɨmbɨ tomguk, wɨnda mek nɨtɨla nɨm nandɨ-dakleamɨk. Wɨn enla nɨ-kawɨt! Endɨ ip bendɨmbi, ama tɨlakta tɨmbi kɨndem enlok kusei e-dakleutak.” ");
INSERT INTO nif_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Juda ama biesɨlɨ ikan e-toptopmɨn, wɨn tɨkap ama nolɨ Yesula en Mesia sɨnɨk wɨn indañgan eukta, ama biesɨlɨ en it kiyau gɨnañ nanin kle-kolɨmbi, pawan pa kuuk. Kusei wala tɨmbi ama wolok meñ beulɨ Juda ama biesɨla mɨsɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ñɨndɨñ eñgɨmɨk, “Endɨ ip bendɨmbi, ama tɨlakta tɨmbi enla nɨ-kawɨt!” ");
INSERT INTO nif_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tɨmbi ama biesɨlɨ ama dai sisipmɨn kuñguk wɨn bɨndambo kɨtɨñmum bɨumbi nɨñgɨlɨñ, “Nɨndɨ ama wala yom ama sɨnɨk wɨndɨñ nandɨñmamɨñ, wala tɨmbi dɨk manda biañgan embi, dɨkok daukalɨ tomguk, wala Kunum Yambat en wakan nɨ-kɨndem daukañ, ama wɨn nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Eumbi tambane enguk, “Endɨ yom ama ba nɨm, wɨn nak nɨm nandɨlet. Gan nak nepek no nandɨ-kɨliñ elet wɨn ñɨndɨñ: nak dautna sisipmɨn kuñguttɨ man deilet.” ");
INSERT INTO nif_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Eumbi yousɨmbi nɨ-kañgɨlɨñ, “Nɨtek tɨ-gamguk? Ba nɨtek tɨmbi dauka tɨmbɨ tomguk?” ");
INSERT INTO nif_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Eumbi tambane enguk, “Nak wɨn ikan sanɨ-talet, gan sɨndɨ nandɨnepi kunjit tɨlɨñ. Nekta manda kɨlɨk wɨngan bɨndambo sanbam nandɨnepi eañ? Nɨm kañbi sɨndɨ bo endok gwañgwañii indanelɨñdok nandɨnelɨñ?” ");
INSERT INTO nif_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Tɨmbi ama biesɨlɨ nɨ-suambapi eñgɨlɨñ, “Dɨkta ama wolok gwañgwan, gan nɨndɨla Moselok gwañgwañii. ");
INSERT INTO nif_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tɨmbi nɨndɨla ka-nandɨ-dakleamɨñ, wɨn Kunum Yambattɨ Mosela kena manda nɨñguk, gan ama wolok kena tɨndɨlok gembɨn wɨn denanin wɨn nɨm nandɨñmamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Eumbi tambane enguk, “Akai! Ñɨn nepek gɨtikñin sɨnɨk yañ! Sɨndɨ endok gembɨn wɨn denanin wɨn nɨm nandɨñmañ, ganmek endɨ nokok dautna tɨmbɨ tomguk! ");
INSERT INTO nif_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nɨndɨ gɨtɨk nandɨ-dakleamɨñ, wɨn Kunum Yambattɨ yom ama nɨm nandɨ-semlak. Tambo nin endɨ Kunum Yambat kɨmɨt-klembi, man tañgone-kulakta, Kunum Yambattɨ endok nɨmolo wɨn nandɨmbi nandɨñmɨlak. ");
INSERT INTO nif_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ba kwet kusei kɨmɨkɨmɨlɨnan nanin bɨkap man ñɨndɨñgɨt, ama no dai sisipmɨn indaindan endok dai tɨmbɨ tomguk, wolok kasat no ip nandɨñgɨmɨñ ba? Nɨm ya! ");
INSERT INTO nif_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wɨndɨñda tɨkap ama ñalɨ Kunum Yambattoknan nanin nɨm bɨumda, nepek wandin no tɨmbektok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Wɨndɨñ eumbi, ama biesɨlɨ tambane nɨñgɨlɨñ, “Dɨk meñgalok simbai gɨnañ nanin yom ama indañguñdɨ kulañ wandin walɨ nɨnda nɨtek tɨmbi nanandɨ nɨmeñdok nandɨlañ?” Wɨndɨñ embi kle-kokɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tɨmbi Yesulɨ ama wɨn kle-kokɨlɨñ wolok kasat wɨn nandɨmbi, ama wɨn kauptok ñambi, tɨmbɨ indaumbi, nɨ-nandɨmbi eñguk, “Dɨk Ama Sɨsɨnɨk enda nandɨ-kɨlɨktɨ tɨñmɨlañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Eumbi tambane nɨnguk, “Ama wopum, nak en nandɨ-kɨlɨktɨ tɨñmettok Ama Sɨsɨnɨk wɨn nin, wɨn dɨk nanbɨm nandɨwa.” ");
INSERT INTO nif_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Eumbi nɨñguk, “Dɨk en ip kalañ ñak. Biañgan sɨnɨk, nak manda ganlet natna Ama Sɨsɨnɨk wakan.” ");
INSERT INTO nif_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Wɨndɨñ eumbi nɨñguk, “Wopum. Nak nandɨ-kɨlɨktɨ tɨ-gamlet.” Wɨndɨñ eñɨpi, mɨlelem tɨñmɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Tɨmbi Yesulɨ ñɨndɨñ eñguk, “Nak kusei ñɨndɨñda tɨmbi kwelan indañgut: naka tɨmbi dausɨ sisipmɨn kuañ endok dausɨ tombɨmbi, deimbi ka-daklenekalɨñ, tɨmbi nin endɨ ñɨndɨñ nandañ, ‘nɨndɨ dautnɨ deimbi ka-dakleamɨñ,’ endɨ dausɨ sisipmɨn papat kwambɨñgan kunekalɨñ. Tɨmbi endɨ ka-dakleañ ba nɨm, wolok tuopgan Kunum Yambattɨ yambɨ-danbekak.” ");
INSERT INTO nif_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tɨmbi Falisi ama dɨwɨn Yesu gɨta pakɨlɨñ endɨ manda wɨn nandɨmbi nɨñgɨlɨñ, “Nɨtek? Nɨndɨ dautnɨ sisipmɨn nɨme!” ");
INSERT INTO nif_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Eumbi enguk, “Tɨkap sɨndɨ ‘Nɨm ka-dakleamɨñ’ wɨndɨñ eumda, sɨndok yomjɨlok mɨlap nɨm pat-samum, gan sɨndɨ ‘Ka-dakleamɨñ’ wɨndɨñ juluñgan eañda tɨmbi, sɨndok yomjɨlok mɨlap wɨn kɨmɨlɨm pat-samlak.” ");
INSERT INTO nif_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesulɨ yousɨmbi, Falisi amala enguk, “Manda elet walɨ biañgan sɨnɨk. Tɨmbi ñɨndɨñ sanlet: nin endɨ sipsip sañ gɨnañ loupi, yamanan nɨm loñɨpi, nolok joñgo lapɨpi pɨuk, endɨ kumbu ama ba tɨ-piñpiñen. ");
INSERT INTO nif_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gan nin endɨ yamanan lolak, endɨ sipsiplok kandɨkñenjɨ en wakan. ");
INSERT INTO nif_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ama endɨ yamanan bɨumbi, yama kandɨkñe amalɨ yama pa pɨsalɨmlak, tɨmbi sipsiptɨ endok man pa kɨmɨt-kleañ, wɨn endɨ enlok sipsipñiilok kosɨ kɨtɨ-semum bɨumbi, yanañgɨlɨmbi, kwelan pɨmbi ñañ. ");
INSERT INTO nif_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kwelan pɨ ña-taleumbi, kandɨkñenjɨlɨ telak dama tɨ-semlak, tɨmbi sipsiptɨ endok man malap nandɨñmañda tɨmbi en pa kle ñañ. ");
INSERT INTO nif_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gan endɨ ama gɨtikñin no nɨm kle ñanelɨñ. Tambo endɨ man malap walan no nandañda tɨmbi mɨsɨmbi pi ñanelɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesulɨ Falisi amala eyout manda wɨndɨñ enguk, gan endɨ manda wolok kusei wɨn nɨm nandɨ-dakleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wɨndɨñda tɨmbi Yesulɨ bɨndambo enbi eñguk, “Manda walɨ biañgan sɨnɨk. Tɨmbi ñɨndɨñ sanlet: sipsiptɨ Bep Yambattoñ lololok yama wɨn natna. ");
INSERT INTO nif_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nak gama nɨm indañɨlambi, ama nindɨ sipsiploñ bɨmbi, juluñgan yambɨ-dɨkñeñgɨlɨñ, endɨ kumbu ama ba tɨ-piñpiñen ama, gan sipsiptɨ endok mandanjɨ nɨm nandɨ-dasimbi kɨmɨt-kleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nak noñgandɨ yama wakan. No en nokoñ bɨmbi, Bep Yambattok sañ gɨnañ lolakta, en nɨm kolauktok nak en tɨke-kamaiutat, tɨmbi endɨ mɨsɨmɨsɨ nɨmnat kumbi, nepek nola nɨm lonjukak. ");
INSERT INTO nif_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kumbu amalɨ sipsip kumbu tɨndɨlok ba yandɨp kɨmlok ba ep tɨmbɨ kolanelɨñdok walañgot pa bɨlak. Gan natna indañgut, wɨn nokok gɨñgɨtnailɨ kuñgu sɨsɨnɨk wakɨt bɨsɨk tokñetokñen walɨ endok pat-semektok indañgut.” ");
INSERT INTO nif_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Tɨmbi Yesulɨ yousɨmbi eñguk, “Natna wɨn sipsiplok kandɨkñenjɨ kɨndem. Kandɨkñe kɨndem endɨ sipsipñiila tɨmbi nandɨ-koñgomnat kɨm-semek. ");
INSERT INTO nif_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Gan ama nin mɨnem kenañgot pa tɨlak, endɨla sipsiplok kandɨkñenjɨ ba bepsɨ nɨm. Endɨ kamot moyendɨ bɨumbi kalakta, mɨsɨmbi, sipsip yambimbi pim ñaumbi, kamottɨ sipsip ep sɨ kleumbi papuseneañ. ");
INSERT INTO nif_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ama walɨ mɨnem kenañgot tɨmbi, sipsip nɨm nandɨ-semlakta tɨmbi wɨndɨñ pa tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Gan natnala sipsiplok kandɨkñenjɨ kɨndem. Beptɨ nandɨ-kɨliñ tɨ-namumbi, nak nandɨ-kɨliñ tɨñmɨlet, wɨndɨñgangot nokok gɨñgɨtnaila nandɨ-kɨliñ tɨ-semambi, endɨ naka nandɨ-kɨliñ tɨ-namañ. Tɨmbi wɨngot nɨm. Nokok sipsipnaila tɨmbi nandɨ-koñgomnat kɨm-semetat. ");
INSERT INTO nif_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tɨmbi sipsip ñalañgot nɨm a. Sipsip dɨwɨn no wakɨt pat-namañ. Endɨ sañ ñolok gɨnañ nanin nɨm, gan nak endɨ wakɨt yanañgɨt bɨmbɨlok. Endɨ nokok mana malapna nandɨmbi, nep kɨmɨt-kleumbi, nokok sipsipnai gɨtɨktɨ kɨkesɨmɨn noñgan indaumbi, nak noñgandɨ endok kandɨkñenjɨ kuutat. ");
INSERT INTO nif_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bepnalɨ nep kasɨlembi, gɨnañlɨ nandɨ-koñgom pa tɨ-namlak wɨn kusei ñɨndɨñda: nak kɨmnan nanin bɨndambo mɨlalettok nandɨ-koñgomnat kɨmbetat. ");
INSERT INTO nif_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nak nɨm nandɨ-tale-semamda, ama nolɨ nɨlɨ kɨmnelɨñdok tuop nɨm, gan nak nandɨ-tale-sembi, nandɨ-koñgomnat kɨmbetat. Wɨn Bepnalɨ nokok kuñguna bimbi, bɨndambo tɨketɨkelok gembɨ nambi, wɨndɨñ tɨmbettok nanɨ-dɨkñeñguk.” ");
INSERT INTO nif_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesulɨ wɨndɨñ eñgukta tɨmbi Juda amatamdɨ nɨsɨñgan bɨndambo tambɨpi, ");
INSERT INTO nif_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","asuptɨ ñɨndɨñ eñgɨlɨñ, “Yal kolan nolɨ endok gɨnan gɨnañ pɨumbi, kamakama tɨlak. Endok mandan slakan neta nandɨlok?” ");
INSERT INTO nif_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tɨmbi dɨwɨndɨ eñgɨlɨñ, “Ama yal kolannat nolɨ manda wandin nɨm euk. Tɨmbi wɨngot nɨm. Yal kolan nolɨ dai sisipmɨn endok dai tɨmbɨ tombektok tuop nɨm ya!” ");
INSERT INTO nif_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tɨmbi gwɨlat no Jelusalem indañguk wolonda Juda amatamdɨ bep pañjiilɨ tapma it tɨmbɨ kaiktañguk nain wɨn nandɨ-kaikta pa tañ. Gwi sasale nain tɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesulɨ tapma it sañ jimba gɨnañ Solomondok palanda plon ñañambɨt tɨñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juda amatamdɨ bɨmbi, en klem gɨmbup papi nɨñgɨlɨñ, “Dɨkok kusaka nain nɨtek gamañgot kɨmɨt-sembumbi, nɨndɨ dɨka nin sɨnɨk wala gɨnañ tɨpet tamɨñ? Tɨkap dɨk Mesia sɨnɨkta, kusaka indangan nɨnɨ-dakleukañ.” ");
INSERT INTO nif_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Eumbi tambane enguk, “Nak wɨn ikan sangut, gan sɨndɨ nɨm nandɨ-kwambɨñ da-namañ. Nak Bepnalok koi plon kundit engano pa tɨlet walɨ mek kusatna tɨmbɨ inda-daklelak, ");
INSERT INTO nif_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","gan sɨndɨ sipsipnai nɨmda tɨmbi wɨn nɨm nandɨ-kwambɨñ dañ. ");
INSERT INTO nif_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nokok sipsipnailɨ mandana nandɨ-dasimbi kɨmɨt-kleañ. Wɨn nak nandɨ-kɨliñ tɨ-semlet, tɨmbi endɨ nak nep kɨmɨt-klembi kuañ. ");
INSERT INTO nif_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Tɨmbi nak kuñgu taletalen nɨmnat emlet, tɨmbi endɨ kolandok gɨñgɨt nombo nɨm tɨnekalɨñ, tɨmbi ama nolɨ nokok kɨtnanan nanin no nɨm kɨwɨlap tɨmbi epmekak. ");
INSERT INTO nif_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wɨn nokok Bepna, nin endɨ gɨñgɨtnai kɨtnanan yapɨkuk, endɨ mek nepek gɨtɨkgan yapma kle-talelak, wala tɨmbi ama nolɨ Bepnalok kiinan nanin gɨñgɨtnai kɨwɨlap tɨmbi, epnelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Bep nɨtɨ noñgan tamɨk.” ");
INSERT INTO nif_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Manda wala tɨmbi amatamdɨ bɨndambo kawattɨ wɨlɨ kɨmnelɨñdok kawat mekɨlɨñ, ");
INSERT INTO nif_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","gan Yesulɨ enguk, “Nak kundit kɨndem kusei kusei Beptoñ nanin sɨndok dausɨnan tɨmbambi kañgɨlɨñ. Sɨndɨ kundit nek sɨnɨkta tɨmbi kawattɨ nɨtnepi tañ?” ");
INSERT INTO nif_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Eumbi tambane nɨñgɨlɨñ, “Wɨn kundit kɨndem nola tɨmbi wɨndɨñ nɨm tamɨñ. Wɨn dɨk kwelan ama sɨlanin wandin walɨ dɨtnala Kunum Yambat eñɨpi, en nɨ-tɨke-pɨ-yalilañda tɨmbi nɨndɨ kawattɨ gwɨtnepi tamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Wɨndɨñ eumbi, Yesulɨ enlok kusal kasopmeuktok Kunum Yambattok mandan nolok plon e-yout tɨmbi, ñɨndɨñ tambane enguk, “Sɨndok endɨkñe mandanjɨ gɨnañ youyoulɨn patak, wɨn Kunum Yambattɨ ama dɨwɨnda ñɨndɨñ enguk, ‘Nak sangut wɨn sɨndɨ yambat’. ");
INSERT INTO nif_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tɨmbi nɨndɨ nandamɨñ, manda youyoulɨn patak walɨ nain tuop biañgan sɨnɨk. Ale, tɨkap Kunum Yambat en wakan ama sɨlaninda manda embi, endok kosɨ ‘yambat’ kɨtɨñgukta, ");
INSERT INTO nif_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","nɨtek tɨmbi sɨndɨ nak kɨt yout tɨ-namañ, tɨmbi ‘Nak Kunum Yambattok Nɨñañ’ wɨndɨñ eñgukta tɨmbi nak en nɨ-tɨke-pɨ-yalilet wɨndɨñ eañ? Wɨn Beptɨ en wakan nak enlok kenan tɨndɨlok nak nep kasɨlembi, nanɨ-mulɨmbi, kwelan pɨ indañgut. ");
INSERT INTO nif_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kɨndem a, tɨkap nak Bepnalok kenan nɨm pa tɨletta, kak, nak endok Nɨñañ wɨn nɨm nandɨ-kwambɨñ danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gan tɨkap nak Bepnalok kenan wɨn tɨletta, nak endok Nɨñañ wɨn nandɨ-kwambɨñ danekalɨñ. Wɨn sɨndɨ nokok mandanala tɨmbi wɨn nɨm nandɨ-kwambɨñ danelɨñ bek, ganmek nokok kunditnala tɨmbi wɨn nandɨ-kwambɨñ dawɨt. Wɨndɨñ tɨnelɨñda, sɨndɨ ka-daklembi nandɨ-daklenekalɨñ, wɨn Beptɨ nokok gɨnañ patak, tɨmbi nak endok gɨnañ patet.” ");
INSERT INTO nif_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesulɨ wɨndɨñ eñgukta tɨmbi amatamdɨ bɨndambo tɨke ñanep nandɨñgɨlɨñ, gan endɨ kɨsɨnan nanin jɨlop paipi ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Tɨmbi Yesulɨ Jodan tuk dɨkñembi, maim lambɨlak kandañnan undane ñambi, Yoanelɨ damañgan tuk i-sem-i-sem kena tɨñguknan wandɨñ ña kuñguk. Kuñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","amatam asuptɨ endoñ bɨmbi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Yoanelɨ jimba kundit engano no nɨm tɨñguk, ganmek endɨ ama ñolok plon manda eñguk gɨtɨk walɨ biañgan sɨnɨk.” ");
INSERT INTO nif_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Wɨndɨñ eñɨpi, wolok pakɨlɨñ asuptɨ Yesu en Mesia wɨn nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ama no koi Lasalos endɨ jɨmbat wopum tɨ-pakuk. Lasaloslɨ wiwiit Malia gɨt Mata en gɨta Betani it kwelan kuñguk, tɨmbi Malia wɨn tam nin endi siñgimek Wopumdok kesɨi pɨñgɨp saple mɨlɨñnattɨ wɨlɨpi, kumbam saktɨ tɨmbɨ kalandañguk. Lasaloslɨ jɨmbat tɨ-palɨñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","endok wiwiittɨ Yesuloñ manda ñɨndɨñ kɨmɨlɨm loñguk, “Wopum, dɨk nandɨ: noka gɨnañgalɨ kasɨlelañ endɨ jɨmbat tɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tɨmbi Yesulɨ kasat wɨn nandɨmbi, ñɨndɨñ eñguk, “Jɨmbat indañmɨñguk walɨ endɨ kɨmbektok nɨm. Tambo walɨ Kunum Yambattok koi gɨñgɨt wopum dauktok ba nak Kunum Yambattok Nɨñañ nokok kusatna engano wɨn tɨmbɨ inda-dakleuktok indañmɨñguk.” ");
INSERT INTO nif_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Tɨmbi Yesulɨ Mata wakɨt dalañ Malia ba wiu Lasalos wɨn ep galk tañguk. ");
INSERT INTO nif_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wɨndɨñda tɨmbi endɨ ‘Lasaloslɨ jɨmbat tɨlak’ gɨñgɨt wɨn nandɨmbi, kwet pakuk wolok sandap tɨpet nombo yousɨm pakuk. ");
INSERT INTO nif_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Pakap, gwañgwañiila enguk, “Bɨumbi, Judia kwelan bɨndambo undane ñana.” ");
INSERT INTO nif_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Eumbi nɨñgɨlɨñ, “Nɨnɨndaut, Judia nasilɨ kawattɨ gwɨtnep tɨñgɨlɨñ, nain nɨm ombataumbi, dɨk bɨndambo wandɨñ undane ñauñdok elañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Eumbi tambane enguk, “Sandap noñgan gɨnañ aua 12got kwettɨ sala patak. Wala tɨmbi sandap kulaktɨ kwet ñolok kolsalen kalakta tɨmbi yout-kasalam nɨm pa tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Gan tim kulaktɨ kolsalen nɨm palmɨlakta tɨmbi yout-kasalam pa tɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesulɨ wɨndɨñ eñɨpi, yousɨmbi enguk, “Notnɨ Lasaloslɨ dou patak, gan nak ñambi, tɨmba sɨlɨkñem mɨlalekak.” ");
INSERT INTO nif_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Eumbi, gwañgwañiilɨ nɨñgɨlɨñ, “Wopum, tɨkap endɨ dou patakta, jɨmbalɨ taleumbi, kɨndem daukak.” ");
INSERT INTO nif_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Wɨn Yesulɨ Lasaloslok kɨmdok plon e-yout tɨñguk, gan gwañgwañiilɨ endɨ dou sɨlanin wala elak wɨndɨñ nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wɨndɨñda tɨmbi Yesulɨ indañgan enɨ-daklembi eñguk, “Lasaloslɨ ip sembɨk, ");
INSERT INTO nif_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","gan sɨnda tɨmbi nak en gɨta nɨm pakut wala sɨmbatnalɨ kɨndem dalak. Wɨn kusei ñɨndɨñda: nain ñolonda nokok kusatna nandɨ-kwambɨñ da-sɨn tanelɨñdok nainjɨ indalak. Gan man ñɨn endoñ ñana.” ");
INSERT INTO nif_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Eumbi, wolongan Tomas koi no Didimus endɨ gwañgwa dɨwɨnda ñɨndɨñ enguk, “Ale, wɨndɨñda nɨndɨ bo ñambi, nɨnɨndaut en gɨta kɨmna.” ");
INSERT INTO nif_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tɨmbi Yesulɨ Betani it kwet kandañ ña tombi, Lasaloslɨ nain tɨpet tɨpet ikan sum gɨnañ taplium pakuk wolok kasat nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani wɨn mayañgan nɨm, 3 kilomita ba nɨtek Jelusalem tɨmbɨ dumalaum patak, ");
INSERT INTO nif_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","wala tɨmbi amatam asuptɨ Jelusalem bimbi, Malia gɨt Matalok wiset sembɨñgukta tɨmbi enɨ-kɨlɨktɨ tɨnepi endoñ bɨ taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tɨmbi nimbek nolɨ Matala “Yesu bɨlak” wɨndɨñ nɨmbɨ nandɨmbi, endɨ telak plon ña tɨmbɨ indañguk, gan Malialɨ ilan pipakuk. ");
INSERT INTO nif_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Tɨmbi Matalɨ Yesula nɨñguk, “Wopum, dɨk ñolok palɨmda, witnalɨ nɨm sembek. ");
INSERT INTO nif_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ganmek man ñɨndɨñgɨtañgan ñɨndɨñ nandɨlet: dɨk Kunum Yambatta nɨtek tɨmbektok nɨ-nandutañda, nandɨ-gametak.” ");
INSERT INTO nif_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Eumbi nɨñguk, “Dɨkok wikalɨ bɨndambo kɨmnan nanin mɨlapi kuukak.” ");
INSERT INTO nif_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Eumbi, Matalɨ nɨñguk, “Kunum Yambattɨ nain taletalennan amatam gɨtɨk ep tɨmbɨ mɨlatnekalɨñ, wolondamek nokok witnalɨ bo mɨlalekak wɨnda nak nandɨ-daklelet ñak.” ");
INSERT INTO nif_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Eumbi nɨñguk, “Amatam ep mɨlamɨlat ba kuñgu ememlok molom wɨn natna ñakan. Wala tɨmbi naka nandɨ-kɨlɨktɨ tɨ-namlaktɨ kɨmbek bek, ganmek kuñgun sɨsɨnɨk walɨ gama palmekak. ");
INSERT INTO nif_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wɨn amatam kaik papi, naka nandɨ-kɨlɨktɨ tɨ-namañ gɨtɨk endɨ sembɨnelɨñ, ganmek kɨm biañgan walɨ nain no ba nola nɨm inda-semekak. Dɨk wɨn nandɨ-kwambɨñ dalañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Eumbi, Matalɨ nɨñguk, “Wopum, biañgan ñak! Tɨmbi nak manda ñɨn bo nandɨ-kwambɨñ dalet: Mesia, Kunum Yambattok Nɨñañ, nin kwelan ñolok indauptok een, wɨn dɨtna wakan.” ");
INSERT INTO nif_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matalɨ wɨndɨñ eu taleumbi, ilan undane ñambi, dalañ Malia kɨtɨñmɨmbi, manda janjat tɨmbi, ñɨndɨñ nɨñguk, “Nɨnɨndauttɨ bɨ tombi, kɨtɨ-gamlak.” ");
INSERT INTO nif_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Eu nandɨmbi, wolongan platik mɨlapi, Yesuloñ ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Yesulɨ it kwet gɨnañ gama nɨm loñguk, tambo endɨ Matalɨ en tɨmbɨ indañguk wolok pakuk.) ");
INSERT INTO nif_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tɨmbi Jelusalem nasi, nindɨ Malia gɨta it gɨnañ papi, nɨ-kɨlɨktɨ tɨñgɨlɨñ, endɨ Malia platik sɨnɨk mɨlapi, pawan pɨm ñaumbi kañgɨlɨñ. Kañbi, “Endɨ sumnan kut-blamblan eup ñalak” wɨndɨñ nandɨmbi, kle ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tɨmbi Malialɨ Yesu pakuknan ña tombi kañguk, wolonda endɨ kesɨinan mɨlelem tɨmbi nɨñguk, “Wopum, dɨk ñolok palɨmda, witnalɨ nɨm sembek!” ");
INSERT INTO nif_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wɨndɨñ eu taleumbi, kut-blamblan eñguk, tɨmbi Jelusalem nasi en gɨta bɨñgɨlɨñ endɨ bo mano tɨñgɨlɨñ. Tɨmbi Yesulɨ wɨn yambɨñguk, wolonda endok gɨnañlɨ mɨlata-sɨnɨk taumbi, blan ba gimbɨt walan wandin deiñguk. ");
INSERT INTO nif_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tɨmbi enɨ-nandɨñguk, “Delok kɨmɨlɨm patak?” Eumbi nɨñgɨlɨñ, “Wopum, ñɨn bɨ ka.” ");
INSERT INTO nif_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tɨmbi Yesulɨ sumdok telaknan ñañɨpi, dai tullɨ pɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wɨndɨñda Jelusalem nasilɨ nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Wɨ kawɨt! Endɨ Lasalos gɨnañlɨ sɨnɨk tɨke-kasɨleñguk yañ.” ");
INSERT INTO nif_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gan endoñnan nanin dɨwɨndɨ ñɨndɨñ eñgɨlɨñ, “Nɨtek tɨmbi ama dai sipsipmɨn endok dai tɨmbɨ tomguktɨ ama ñɨn nɨm tɨke-kɨmɨlɨmbi sembɨñguk?” ");
INSERT INTO nif_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tɨmbi Yesulɨ bɨndambo gɨnañ mɨlata sɨnɨk taumbi, sumnan ña tomguk. Lasalos wɨn kawat tombañ nolok gɨnañ kɨmɨpi, yama wɨn kawat wopumdɨ masip bimbin. ");
INSERT INTO nif_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tɨmbi Yesulɨ enguk, “Kawat tɨke ñawɨt!” Eumbi, ama sembɨsembɨndok wiu Mata endɨ tambane nɨñguk, “Wopum, nain tɨpet tɨpet ikan sembɨ-pakukta tɨmbi ip mɨlɨñ tɨlak yañ!” ");
INSERT INTO nif_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Eumbi, Yesulɨ nɨñguk, “Nak ikan ñɨndɨñ ganɨt: tɨkap dɨk naka nandɨ-kɨlɨktɨ tɨ-namlañda, Kunum Yambattok kusal engano wɨn inda-dakleumbi kautañ.” ");
INSERT INTO nif_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wɨndɨñda ama dɨwɨndɨ kawat wɨn tɨke ñaumbi, Yesulɨ deium loumbi, ñɨndɨñ eñguk, “Bep, dɨk nokok nɨmolona ikan nandɨ-namlañ, wala tɨmbi nak we ganlet. ");
INSERT INTO nif_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Dɨk nain tuop nandɨ-namlañ, wɨn natna nandɨ-talelet. Gan nak amatam ñolok ikañ enda nandɨ-sembi, endɨ dɨtna wakan nanɨ-mulɨm indañgut wɨn nandɨ-kwambɨñ danelɨñdok wɨndɨñ et.” ");
INSERT INTO nif_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wɨndɨñ eu taleumbi, wopumgan kɨtɨmbi eñguk, “Lasalos, dɨk pɨ!” ");
INSERT INTO nif_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eumbi, kɨmguktɨ kaiktambi pɨñguk. Tɨmbi kii kesɨi ba kumbam wɨn sandumdɨ tapli imimɨnda tɨmbi Yesulɨ enguk, “Sandum pɨsalɨm, samakgan kuwɨn.” ");
INSERT INTO nif_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Wɨndɨñda Jelusalem nasi Malia kanep bɨñgɨlɨñ endoñnan nanin asuptɨ Yesulɨ Lasalos nɨtek tɨñmɨñguk wɨn ka-nandɨñgɨlɨñda tɨmbi en Mesia sɨnɨk wɨn nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gan dɨwɨndɨ Falisi amaloñ ñambi, Yesulɨ nɨtek tɨñguk wolok kasat tɨ-semgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wɨndɨñda tapma ama biesɨ gɨt Falisi ama endɨ Judalok it kiyau wopumdok ama gɨtɨk kɨtɨ-semum bɨumbi, kɨmɨn tɨmbi, nɨsɨñgan Yesulok plon ñɨndɨñ e-nandɨ tɨñgɨlɨñ, “Nɨtek tɨlok? Ama walɨ jimba kundit asupgan sɨnɨk pa tɨlak wɨn! ");
INSERT INTO nif_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tɨkap nɨndɨ binambi, wɨndɨñgot tɨ-kuukta, amatam gɨtɨkgandɨ en Mesia wɨndɨñ nandɨ-kwambɨñ dambi, enda tɨmbi kusei kɨmɨpi, nɨndok kandɨkñenii Roma nasi mik tɨ-semumbi, endɨ bɨmbi, nɨndok tapma it wakɨt ama sambat ñɨn nɨpma tɨkeumbi kolanekamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tɨmbi ama biesɨ endoñnan nanin no, wɨn Kaiafas, endɨ gwɨlat wolonda tapma amalok telak damanjɨ kuñguk, tɨmbi endɨ ñɨndɨñ enguk, “Sɨndɨ ka-nandɨ-daklenjɨ nɨmnat yañ! ");
INSERT INTO nif_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nɨm kañbi Juda ama nɨn gɨtɨk kola-taleneñ, wala tɨmbi wɨn sɨndok kandañ kɨndem, tɨkap ama noñganlɨñgot amatam gɨtɨktok kɨnjannɨ kɨm-nɨmek. Sɨndɨ wɨn nɨm ka-nandɨ-dakleañ bek.” ");
INSERT INTO nif_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafaslɨ wɨndɨñ eñguk, gan endɨ manda wɨn enlok nanandɨnla nɨm eñguk. Tambo endɨ gwɨlat wolonda tapma amalok telak damanjɨ pakukta, plofet manda eñɨpi, ñɨndɨñ eñguk: Yesulɨ Juda amatamdok kɨnjan kɨm-semepi tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Tɨmbi endokgot nɨm. Endɨ Kunum Yambattok gɨñgɨtñii kwet nolok nolok papusenem pakañ ep kiulɨmbi, sambat noñgan tɨnelɨñdok kɨmbepi tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiafaslɨ wɨndɨñ eñgukta tɨmbi Juda ama biesɨlɨ sandap wolondañgan kusei kɨmɨpi, nɨsɨñgan e-sambat tɨ-kumbi, Yesu wɨlɨ kɨmnelɨñdok telak lonjɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Wɨndɨñda tɨmbi Yesulɨ Jelusalem nasi endok boñgɨpsɨnan indañgan nombo nɨm kuñguk. Tambo endɨ walinin pɨm ñambi, kwet no kwet sɨlanin ñasɨñgan patak wolok ñambi, it kwet no koi Eflaim wolok gwañgwañii gɨta kuñguk. ");
INSERT INTO nif_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tɨmbi Juda amatamdok Kamaikamai gwɨlat dumalaumbi, amatam asuptɨ isɨ kwesɨ bimbi, Kunum Yambattok dainan jamilan indanelɨñdok itañgan tapma ilan tɨ-pañgɨpañgɨle tɨnepi Jelusalem lo ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ñambi, Yesu lonjɨmbi, tapma it sañ jimba gɨnañ ipi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Sɨndɨ nɨtek nandañ? Endɨ gwɨlatta nɨm bɨukak bek.” ");
INSERT INTO nif_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Wɨndɨñ eñgɨlɨñ wɨn kusei ñɨndɨñda: tapma ama biesɨ gɨt Falisi amalɨ Yesu tɨkenelɨñdok manda kwambɨñ no ñɨndɨñ eu satañguk, “Tɨkap ama nolɨ Yesu delok patak wɨn nandɨlakta, wɨn nɨnbɨ nandɨmbi, en tɨkeneñdok.” ");
INSERT INTO nif_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kamaikamai gwɨlat gama nɨm indañɨlɨmbi, sandap kɨt tambon noñgan gama palɨmbi, Yesulɨ nolii gɨt Betani it kwelan ña tomguk. Betani wɨn Lasalos, nin Yesulɨ kɨmnan nanin tɨmbɨ mɨlakuk, endok il kwel. ");
INSERT INTO nif_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yesulɨ wolok tombɨmbi, nanañ sina tɨ-ñɨmɨumbi, Yesu gɨta nanañ nañgɨlɨñ endoñnan nanin no wɨn Lasalos, tɨmbi Matalɨ yambɨ-dɨkñeñguk. Nanañ na-palɨñɨlɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Malialɨ wɨlɨñgɨlo no tɨkembi, Yesuloñ ña indambi, pɨñgɨp saple mɨlɨñ kɨndem tuan loloñ sɨnɨk endok kesɨi plon yalɨmɨpi, kumbam saktɨ tɨmbɨ kalandañguk. Tɨmbi pɨñgɨp saplelok mɨlɨñ kɨndem walɨ it gɨtɨk wɨn tokñeñguk. ");
INSERT INTO nif_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tɨmbi Yesulok gwañgwañii endoñnan nanin no koi Judas Iskaliot, ama nin endɨ siñgi kandañ Yesu kanjɨkñiilok kɨsɨnan kɨmɨkuk, endɨ Malialɨ kundit tɨñguk wala nandum pɨumbi eñguk, ");
INSERT INTO nif_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Yakai! Nɨndɨ pɨñgɨp saple wɨn tuatualok kɨmɨtnem tuaumda, gwɨlat noñgandok kena naindok tuan walinin epbi, gumañ pɨmbɨñesɨla emneñ!” ");
INSERT INTO nif_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gan endɨ ama pɨmbɨñesɨla nɨm nandɨ-semguk, tambo endɨ kumbu pa tɨñgukta tɨmbi wɨndɨñ eñguk. Wɨn amatamdɨ Yesu gɨt gwañgwañiila mɨnem emgɨlɨñ wɨn Judaslɨ ka-dɨkñembi, walinin gitakan enlok pa eplɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Tɨmbi Yesulɨ Judasla nɨmbi eñguk, “Maliala mɨlap nɨm mɨwɨñ! Wɨn nak kɨmbambi, nep kɨndit taplinekalɨñ, wolok itañgan nokok pɨñgɨpna tɨ-pañgɨpañgɨle tɨ-namektok endɨ pɨñgɨp saple wɨn tuatualok nɨm kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pɨmbɨñesɨlɨ nain tuop sɨn gɨta kuumbi, kɨndem ep kɨmɨtnekalɨñ, gan nakta kwelan ñolok sɨn gɨta papat kwambɨñgan nɨm kuutat.” ");
INSERT INTO nif_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tɨmbi Jelusalem nasi asupgan sɨnɨk endɨ Yesu Betani it kwelan pakuk wolok gɨñgɨt nandɨmbi, kanepi bɨñgɨlɨñ. Tɨmbi engot nɨm. Endɨ Yesulɨ Lasalos kɨmnan nanin tɨmbɨ mɨlakuk en bo kanepi bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Wɨn Lasalosla tɨmbi amatam asuptɨ Yesulok kandañ ña-talembi, nandɨ-kɨlɨktɨ tɨñmɨñgɨlɨñ, wala tɨmbi tapma ama biesɨlɨ Lasalos bo wɨlɨ kɨmnelɨñdok e-sambat tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kwet salaumbi, amatam kɨmɨn gɨtɨk gwɨlatta Jelusalem bɨñgɨlɨñ endɨ Yesulɨ wolok loupi tɨñguk manda wɨn nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nandɨmbi, Yesulok koi gɨñgɨt tɨke-lonelɨñdok komba gandua wandin wolok kii gayam ombɨm epbi, it kwet bimbi, telaknan tɨmbɨ indauktok ñambi, ñɨndɨñ kɨtɨmbi eñgɨlɨñ, “Hosana! Nɨ-ta-lona! Ama ñɨn Wopumdok koi plon bɨumbi, Kunum Yambattɨ gwɨlam tɨñmɨn! Endɨ Islael nɨndok Ama Wapmañni! ");
INSERT INTO nif_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Tɨmbi Yesulɨ doñki sim no tɨmbɨ indaumbi, wolok plon pipapi ñañguk. Wɨn plofet manda ñɨndɨñ youyoulɨn patak wolok tuop indañguk, ");
INSERT INTO nif_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saion nasi sɨndɨ nɨm mɨsɨnelɨñ! Wɨ kawɨt! Sɨndok ama wapmañjɨ doñki nɨñañ plon pipapi bɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","(Nain wolonda Yesulok gwañgwañiilɨ nek indañguk wolok walan gama nɨm nandɨ-dakleñgɨlɨñ. Wɨn Kunum Yambattɨ Yesu kɨmnan nanin tɨmbɨ mɨlapi, endok pipapal engano wolok undane loñguk, wolok siñgi kandañmek endɨ nandɨ-tomgɨlɨñ, wɨn plofet amalɨ Yesulok plon wɨndɨñ indauktok youyoulɨn, tɨmbi wolok tuopgan indañmɨñguk.) ");
INSERT INTO nif_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tɨmbi kɨmɨn wopum Yesulɨ Lasalos kɨtɨñmɨmbi, kɨmnan nanin tɨmbɨ mɨlapi, sum gɨnañnan nanin lambumbi kañgɨlɨñ, endɨ yousɨmbi, nek indañguk wɨn e-saktañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kɨmɨn gɨtɨk Kamaikamai gwɨlatta Jelusalem bɨñgɨlɨñ, endɨ Yesu telak plon tɨmbɨ indanelɨñdok ñañgɨlɨñ, wɨn kusei ñɨndɨñda: Yesulɨ jimba kundit wandin tɨñguk wolok gɨñgɨt sapakñeumbi, endɨ nandɨmbi, telak plon tɨmbɨ indanelɨñdok ñañgɨlɨñ. Ñaumbi, ");
INSERT INTO nif_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Falisi amalɨ wɨn kañbi, nandum tuop nɨm tɨmbɨmbi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Wɨ kawɨt! Kwelan kuañ gɨtɨktɨ en ip klem kunepi ñañ! Nɨndɨ nek kusei kusei tamɨñ, walɨ bien nɨmnat wandin inda-daklelak!” ");
INSERT INTO nif_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Amatam gwɨlatta Kunum Yambat mɨlelem tɨñmɨnelɨñdok Jelusalem bɨñgɨlɨñ endok boñgɨpsɨnan Grik ama dɨwɨn pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Filip endɨ Betsaida it kwet Galili kwelan nanin, tɨmbi sambat walɨ endoñ bɨmbi nɨñgɨlɨñ, “Ama wopum, nɨndɨ Yesu kanep nandamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Eumbi, Filiptɨ ñambi, Andlu nɨmbɨ nandumbi, yakan Yesuloñ ñambi, eñgɨlɨñ wolok tuop nɨñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tɨmbi Yesulɨ ñɨndɨñ tambane enguk, “Nak Ama Sɨsɨnɨk nokok pipatna engano wolok undane louttok nain walɨ ip inda-talelak. ");
INSERT INTO nif_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Wɨn biañgan sɨnɨk. Tɨmbi ñɨndɨñ sanlet: tɨkap nanañ mɨnjɨptɨ kwelan nɨm pɨmbi kɨmbekta, en noñgangot palek. Gan tɨkap endɨ kɨmbekta, endɨ bien asup laliuk. ");
INSERT INTO nif_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nin endɨ enlok kuñgun tɨke-kimbɨñ dalakta, endok kuñgun papat kwambɨñgan nɨm palmekak. Gan nin endɨ kwelan ñolok kumbi, naka tɨmbi kuñgun enlok nɨm tɨke-kimbɨñ dalakta, walɨ wakan kuñgun wɨn tɨke kamaimbi, papat kwambɨñgan palmekak. ");
INSERT INTO nif_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wɨn no en nokok kena gwañgwana kulakta, endɨ nak nep kle kuwɨn. Nak nep kle kuñɨpi, natna patetnan endɨ bo palekak. Tɨmbi nokok Bepnalɨ kena gwañgwana kuañ gɨtɨkta kot gɨñgɨt emekak.” ");
INSERT INTO nif_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Tɨmbi Yesulɨ enlok kɨmla kɨmɨt-nandɨmbi yousɨmbi eñguk, “Man nokok gɨnañna mɨlataumbi, nɨtek ewɨt? ‘Bep, dɨk mɨlap inda-namep tɨlak ñɨn napma tɨke’ wɨndɨñ ewɨt ba? Nɨm a. Wɨn nak mɨlap wɨn bemettok indañgutta tɨmbi wɨndɨñ nɨm eutet. ");
INSERT INTO nif_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tambo nak ñɨndɨñ elet, ‘Bep, dɨkok kusaka engano wɨn tɨmbɨ inda-dakleumbi, kokalɨ wopum dawɨn.’” Yesulɨ wɨndɨñ eumbi, kunum gɨnañ nanin manda nolɨ ñɨndɨñ eu pɨñguk, “Nokok kusatna engano wɨn ikan tɨmba inda-dakleumbi, kotnalɨ wopum dañguk, tɨmbi wɨndɨñgangot bɨndambo tɨmbetat.” ");
INSERT INTO nif_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kɨmɨn gɨtɨk wolok pakɨlɨñ endɨ kɨtɨkɨtɨ wɨn nandɨmbi, dɨwɨndɨ “Dɨlɨmat kɨtɨlak” eumbi, dɨwɨndɨ “Eñalo nolɨ manda nɨlak” wɨndɨñ eñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tɨmbi Yesulɨ tambane enguk, “Manda walɨ nak nep tɨmbɨ plaptauktok nɨm, walɨ sɨndɨ sep tɨmbɨ plaptauktok pɨlak. ");
INSERT INTO nif_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Man ñɨndɨñgɨt nain inda-taleumbi, ñɨndɨñ indaukak: Kunum Yambattɨ kwelalok amatam gɨtɨk yambɨ-danbi, tambonjɨ ombɨ-tɨkenelɨñdok eu taleukak, tɨmbi kwet ñolok kandɨkñe Satan en wakan wɨlɨ pɨukak. ");
INSERT INTO nif_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Gan natnalok kandañ wɨn ñɨndɨñ: nak kwelan nanin nep loumek, nak amatam gɨtɨktɨ nokoñ bɨmbɨlok telak dɨlɨ-tom-semetat.” ");
INSERT INTO nif_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesulɨ wɨndɨñ eñguk, wɨn endɨ kɨmkɨm nɨtein kɨmbektok wɨn e-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tɨmbi amatamdɨ tambane nɨñgɨlɨñ, “Manda youyoulɨn patak walɨ Mesia papat kwambɨñgan kuuktok eumbi pa nandɨñgɨmɨñ. Nɨtek tɨmbi dɨk Ama Sɨsɨnɨk kloñbat plon tɨke-loumbi kɨmbektok elañ? Dɨk Ama Sɨsɨnɨk nɨtein wandin ñala manda wɨn elañ?” ");
INSERT INTO nif_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tɨmbi Yesulɨ enlok plon manda embi, ñɨndɨñ enguk, “Kolsalenlɨ nain dumangangot gama sɨndok boñgɨpsɨnan pat-samekak. Nɨm kañbi kɨlɨmdɨ sapma kleuk, wala tɨmbi sɨndɨ kolsalen gama pat-samlak tuop wolok gɨnañ yousɨmbi kunekalɨñ. Neta, kɨlɨm gɨnañ kulaktɨ dendɨñ ñalak wala nɨm nandɨ-daklelak. ");
INSERT INTO nif_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Wɨndɨñda tɨmbi kolsalendok kuseilɨ sɨn gɨta gama palɨñɨlɨmbi, sɨndɨ kolsalen molom indanelɨñdok en nandɨ-kɨlɨktɨ tɨñmɨnekalɨñ.” Yesulɨ wɨndɨñ eu taleumbi, amatam yambɨk bim ñambi, yambɨ-sembɨm pa kuñguk. ");
INSERT INTO nif_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesulɨ jimba kundit asupgan amatamdok dausɨnan ip tɨñguk, gan asuptɨ wandingan embi gɨñgɨnembi, en Mesia wɨn nɨm nandɨ-kwambɨñ dañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Wɨn plofet Aisaialɨ manda no youkuk patak walɨ bien tɨmbektok wɨndɨñ indañguk. Manda wɨn ñɨndɨñ, “Wopum, nɨndɨ gɨñgɨt manda eñgɨmɨñ wɨn amatam tɨpet sɨnɨktɨ nandɨ-kwambɨñ dañgɨlɨñ, ba dɨkok gembɨñga daut semguñ wɨn ka-dakleñgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Endɨ Yesu nandɨ-kɨlɨktɨ tɨñmɨnelɨñdok tuop nɨm. Wolok kusei wɨn Aisaialɨ ñɨndɨñ youkuk, ");
INSERT INTO nif_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nak Kunum Yambattɨ endok dausɨ masipbi, gɨnañjɨ tɨmba kwambɨñ dañguk. Nɨm kañbi, endɨ dausɨlɨ nokok kunditna kañbi, gɨnañjɨlɨ nandɨ-kɨliñ embi, tambanem, nokoñ bɨumbi, natna ep tɨmba kaikta-talenekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaialɨ wɨndɨñ youkuk, wɨn kusei ñɨndɨñda: Kunum Yambattɨ Mesialok kusal engano wɨn Aisaia itañgan daulɨmɨum kañbi, endɨ nepek eukak ba tɨmbekak wolok plon youkuk. ");
INSERT INTO nif_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ganmek nain wolongan Juda ama biesɨlok boñgɨpsɨnan bo asuptɨ Yesu nandɨ-kɨlɨktɨ tɨñmɨñgɨlɨñ, gan endɨ Falisi amala mɨsɨñgɨlɨñda tɨmbi wɨn nɨm e-indañgɨlɨñ. Nɨm kañbi, endɨ it kiyau gɨnañ nanin ep kle-kolɨmbi, pawan kunelɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ama walɨ amatam enɨ-kɨndem dañ wala nandɨ-galk wopum tɨñgɨlɨñ, ganmek Kunum Yambattok kandañ nandɨ-galk wopum wandin nɨm tɨmbi, nandɨ-kɨlɨktɨnjɨ kɨmɨt-sembɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Tɨmbi Yesulɨ wopumgan kɨtɨmbi, ñɨndɨñ eu pɨñguk, “Nak nandɨ-kɨlɨktɨ tɨ-namlaktɨ nakgot nɨm nandɨ-kɨlɨktɨ tɨ-namlak, tambo endɨ Bep nak nanɨ-mukuk en bo nandɨ-kɨlɨktɨ tɨñmɨlak. ");
INSERT INTO nif_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Wɨndɨñgangot nak nambɨlaktɨ nanɨ-mukuk en bo kalak. ");
INSERT INTO nif_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Amatam nak nandɨ-kɨlɨktɨ tɨ-namañ, endɨ kɨlɨm gɨnañ nombo nɨm kunelɨñdok nak kolsalen wandin kwelan pɨ indañgut. ");
INSERT INTO nif_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nak kwelan kuañ yambɨ-danbi, endok kolanjɨlok tambon ewa taleuktok nɨm indañgut. Tambo nak kolanjɨlok tambonnan nanin yapma tɨkeuttok indañgut. Kusei wala tɨmbi tɨkap ama nolɨ nokok mandana nandɨ-kɨmkɨmnelakta, natna en ka-danbi, endok tambon ewa talelak wɨndɨñ nɨm tɨlet. ");
INSERT INTO nif_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tambo nin endɨ nak siñgi wɨt-nambi, nokok mandana nɨm nandɨ-dasilak en ka-danbi, tambon eu taleuktok no patak, wɨn nak manda eñgut walɨ wakan en kwet nain taletalenan ka-danbi, tambon ombɨ-tɨkeuktok eu taleukak. ");
INSERT INTO nif_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wɨn kusei ñɨndɨñda: nak natnalok nanandɨnala manda nɨm eñgut. Tambo Bep nak nanɨ-mukuk en wakan nak manda nek ba nɨtek eelok wɨn nanɨ-dɨkñeñguk. ");
INSERT INTO nif_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tɨmbi nak ñɨndɨñ nandɨ-kɨliñ elet: endɨ manda euttok nanɨ-dɨkñeñguk, manda walɨ amatam ep tɨmbɨmbi, kuñgu taletalen nɨmnat kunekalɨñ. Wɨndɨñda tɨmbi nak endɨ manda nɨtek eelok nanguk, wolok tuopgangot pa elet.” ");
INSERT INTO nif_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kamaikamai gwɨlat indaup tɨmbɨmbi, Yesulɨ kwelan ñolok bimbi, Beuloñ undane lololok nain indañguk wɨn ka-nandɨ-dakleñguk. Endɨ ama nin kwelan ñolok en kɨmɨt-kle kuñgɨlɨñ wɨn ep galk tɨ-ta-bɨñguk, tɨmbi yousɨmbi, kwelan gama kuñguk tuop ep galkta tɨñguk wɨn daut semguk. ");
INSERT INTO nif_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesu gɨt gwañgwañii endɨ tim nanañ na-palɨñɨlɨmbi, ñɨndɨñ indañguk: Satandɨ Judas, Simon Iskaliottok nɨñañ, enda ikan gɨnan gɨnañ nanandɨ mɨmbi, Yesu kanjɨkñiilok kɨsɨnan kɨmɨlektok nɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Gañgan Yesulɨ nandɨñguk, wɨn Beptɨ nepek gɨtɨk endok kiinan kɨmɨlɨmbi ka-dɨkñeñguk, tɨmbi endɨ Kunum Yambattoñnan nanin pɨñguktɨ endoñ undane louptok tɨñguk. Wɨndɨñ nandɨñɨpi, ");
INSERT INTO nif_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","nanañ na-pakɨlɨñnan nanin mɨlapi, dasindasin ombap kiundɨp kɨmɨpi, tɨmbɨkalanda no tɨkembi, boñgɨunan temguk. ");
INSERT INTO nif_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tɨñɨpi, tuk jawañ gɨnañ wɨlɨ pɨumbi, kusei kɨmɨpi, gwañgwañii kesɨsɨ wɨlɨt-sembi, tɨmbɨkalanda boñgɨunan temguk walɨ tɨmbɨ kalandañguk. ");
INSERT INTO nif_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wɨndɨñ tɨ-sem-ta-ñakap, Simon Petloloñ bɨ tombɨmbi nɨñguk, “Wopum, nɨm kañbi dɨkɨ nokok kesɨtna wɨlɨlep tɨmbeñ a.” ");
INSERT INTO nif_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Eumbi tambane nɨñguk, “Natna nek tɨ-samlet wolok kusei wɨn dɨk man ñɨndɨñgɨta nɨm nandɨ-daklelañ, gan gamamek nandɨ-tombekañ.” ");
INSERT INTO nif_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Eumbi, Petlolɨ kɨmɨsip tɨñmɨmbi nɨñguk, “Dɨk nain no ba nola nokok kesɨtna no nɨm wɨlɨt-namekañ.” Eumbi, Yesulɨ nɨñguk, “Tɨkap nak nɨm wɨlɨt-gametetta, dɨk nokok gɨñgɨt yousɨm kuuñdok tuop nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Eumbi, Simon Petlolɨ nɨñguk, “Wopum, tɨkap wɨndɨñda, dɨk nandɨ-nambi, kesɨtnañgot nɨm wɨlɨt-nameñ, tambo dɨk nokok kɨtna ba kumbana wakɨt wɨlɨt-namekañ!” ");
INSERT INTO nif_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Eumbi, Yesulɨ nɨñguk, “Nin endɨ tuk ikan ik, endɨ jamilan sɨsɨnɨk, gan kesɨiñgot wɨlɨwɨlɨttok. Tɨmbi gɨnañjɨlok kandañ sɨndɨ jamilan sɨnɨk, gan gɨtɨk sɨnɨk nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesulɨ nin sɨnɨktɨ en kanjɨkñiilok kɨsɨnan kɨmɨpi tɨñguk wɨn ikan ka-nandɨñgukta tɨmbi ñɨndɨñ eñguk, “sɨndɨ gɨtɨk sɨnɨk jamilan nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesulɨ gwañgwañiilok kesɨsɨ wɨlɨt-talembi, dasindasin ombap bɨndambo dasimbi, kwel kɨnjannan undane ña pip papi enɨ-nandɨñguk, “Sɨndɨ nak nek tɨ-samɨt wolok kusei ka-nandɨ-tomañ ba nɨm? Wɨn ñɨndɨñ: ");
INSERT INTO nif_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","nak sɨndok Sanɨndautsɨ ba Wopumjɨ kuletta tɨmbi sɨndɨ ‘Nɨnɨndaut’ ba ‘Wopum’ nanɨañ wɨn dɨndɨm eañ. ");
INSERT INTO nif_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wɨndɨñda tɨkap nak sɨndok Wopumjɨ ba Sanɨndautsɨlɨ sɨndok kesɨsɨ wɨlɨt-sam-taleletta, sɨngan kesɨsɨ tambo wɨlɨlɨm tɨ-ta-kulok. ");
INSERT INTO nif_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nak telak wɨn daut samɨt, wɨn sɨndɨ bo nak nomɨk kosɨ gɨñgɨt wɨn biu pɨumbi, nak tɨ-samɨt wɨndɨñgan sɨndɨ tambo tɨke-kɨmɨt tɨ-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Biañgan ñak. Nak ñɨndɨñ sanlet: kena gwañgwa sɨlanindɨ molomjɨlok kapmainan kuañ, tɨmbi ama kena tɨndɨlok enɨ-mulɨm ñañ endɨ bo nin enɨ-mukuk endok kapmainan kuañ. ");
INSERT INTO nif_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sɨndɨ nepek sanɨt wolok walan ip nandɨ-dakleañda, tɨkap sɨndɨ wolok tuop tɨ-kunekalɨñda, sɨndɨ Kunum Yambattok dainan amatam dɨwɨn yapma kle-patnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Tɨmbi Yesulɨ yousɨmbi enguk, “Nak sɨndɨ gɨtɨk amatam dɨwɨn yapma kle-patnekalɨñ wɨndɨñ nɨm elet. Nak ama nɨtein nokok gwañgwanai kunelɨñdok ep kasɨleñgut wɨn nandɨ-dakle-samlet, tɨmbi nak nin kasɨleñgut wɨn plofet manda no youyoulɨn patak walɨ bien tɨmbektok kasɨleñgut. Wɨn ñɨndɨñ, ‘Ama no notna wandin nakɨta yakan nanañ nalak, endɨ kanjɨk tɨ-namlak.’ ");
INSERT INTO nif_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nak man ñɨn wolok plon itañgan kasat tɨ-samlet, wɨn kusei ñɨndɨñda: wɨndɨñ inda-namumek, sɨndɨ nokok kusatna papat kwambɨñ wɨn nandɨ-kwambɨñ danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nak kusatnala elet walɨ biañgan sɨnɨk. Tɨmbi ñɨndɨñ sanlet: nin endɨ nak ama nɨ-mukut enda not tɨñmɨlak, endɨ Kunum Yambattok dainan nak wakan not tɨ-namlak, tɨmbi nin endɨ not tɨ-namlak, endɨ nak nanɨ-mukuk enda bo not tɨñmɨlak.” ");
INSERT INTO nif_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesulɨ wɨndɨñ e-talembi, gɨnañ mɨlata-sɨnɨk taumbi, indañgan e-daklembi enguk, “Manda et walɨ biañgan sɨnɨk, wɨn nak ñɨndɨñ sanlet: sɨndoñnan nanin nolɨ bola tɨ-nambi, kanjɨknailok kɨsɨnan napɨletak.” ");
INSERT INTO nif_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Tɨmbi gwañgwañiilɨ Yesulɨ ninda sɨnɨk eñguk wala gama nɨm nandɨ-daklembi, nandɨ-bendɨ wopum tɨmbi, tambo ka tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tɨmbi endoñnan nanin no, wɨn gwañgwa nin Yesulɨ gɨnañlɨ kasɨleñguk endɨ Yesulok ñasɨñgan kii dɨndɨm kandañ pakuk, ");
INSERT INTO nif_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","wala tɨmbi Petlolɨ enda kiilɨ walawala tɨmbi nɨñguk, “Ninda sɨnɨk elak wɨn dɨk nɨ-ka!” ");
INSERT INTO nif_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wɨndɨñ tɨmbɨmbi, gwañgwa walɨ Yesulok kandañ ñaña embi nɨ-nandɨñguk, “Wopum, wɨn nin?” ");
INSERT INTO nif_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Eumbi, Yesulɨ tambane nɨñguk, “Nak plaua nanañ dɨp ñɨn wɨtna gɨnañ wɨsɨmbi, mɨwam nambetak en wakan.” Wɨndɨñ eñɨpi, plaua nanañ dɨp wɨn wɨsɨmbi, Judas Simon Iskaliottok nɨñañda mɨumbi ");
INSERT INTO nif_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","tɨkeumbi, wolongan Satandɨ Judaslok gɨnañ pɨ-ñɨmɨñguk. Tɨmbi Yesulɨ nɨñguk, “Dɨk nepek tɨmbep tɨlañ wɨn platik sɨnɨk tɨ.” ");
INSERT INTO nif_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Endɨ wɨndɨñ eñguk, gan nanañ na-pakɨlɨñ dɨwɨn nolɨ endɨ kusei nekta wɨndɨñ nɨñguk wɨn nɨm nandɨ-dakleñgɨlɨñ. Nɨm nandɨ-daklembi, ");
INSERT INTO nif_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judaslɨ endok mɨnemjɨ ka-dɨkñeñgukta tɨmbi dɨwɨndɨ Yesulɨ Judasla ñɨndɨñ ba nek nɨñguk wɨndɨñ nandɨñgɨlɨñ, “Dɨk ñambi, gwɨlatta nek nanalok tɨpɨkamɨñ wɨn tua,” ba “Pɨmbɨñesɨla mɨnem em.” ");
INSERT INTO nif_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tɨmbi Judaslɨ nanañ dɨp wɨn tɨke-taleumbi, wolongan walinin kɨlɨm gɨnañ pɨm ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judaslɨ walinin ip pɨm ñaumbi, Yesulɨ gwañgwañii dɨwɨn ñɨndɨñ enguk, “Ama Sɨsɨnɨk nokok kusatna engano walɨ man inda-dakleupi tɨlak, tɨmbi nek inda-namepi tɨlak, walɨ Kunum Yambattok kusal engano wɨn tɨmbɨ inda-dakleukak. ");
INSERT INTO nif_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Tɨkap nak endok kusal engano wɨn tɨmba inda-daklelakta, nain nɨm ombataumbi, endɨ bo nokok kusatna engano wɨn tɨmbɨ inda-dakleukak. ");
INSERT INTO nif_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Gwañgwanai, nak nain dumangot gama sɨn gɨta kuutat. Kukap ñawambi, sɨndɨ nep lonjɨnekalɨñ, gan nak Juda ama biesɨla engut wɨndɨñgangot sɨnda ñɨndɨñ sanlet, ‘Nak ñautatnan sɨndɨ ñanelɨñdok tuop nɨm.’ ");
INSERT INTO nif_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wɨndɨñda tɨmbi nak endɨkñe manda komblin sanbi, sɨndɨ gɨnañjɨlɨ tambo tɨke-galk tɨnelɨñdok sanɨ-dɨkñelet, wɨn nak sep galk tɨ-samguttɨ tɨ-samlet, telak wolok tuopgan sɨndɨ bo tambo tɨke-galk tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tɨkap sɨndɨ wɨndɨñ tɨ-kunekalɨñda, amatam gɨtɨktɨ sɨndɨ nokok gwañgwanai kuañ wɨn sambɨ-nandɨ-tomnekaliñ.” ");
INSERT INTO nif_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Tɨmbi Simon Petlolɨ Yesu nɨ-nandɨñguk, “Wopum, dɨk dendɨñ ñaukañ?” Eumbi tambane nɨñguk, “Nak ñautatnan dɨk man ñɨn nep klem ñauñdok tuop nɨm, gan gamamek dɨk nep klembi ñaukañ.” ");
INSERT INTO nif_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Eumbi nɨ-nandɨmbi eñguk, “Wopum, nɨtek tɨmbi nak man ñɨn gep klem ñauttok tuop nɨm? Nak kuñguna bimbi, kɨm-gamettok pañgɨtam patet.” ");
INSERT INTO nif_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Wɨndɨñ eumbi, Yesulɨ nɨñguk, “Ba dɨkok kuñguñga bimbi, kɨm-nametañ ba? Wɨn biañgan nɨm! Nak ñɨndɨñ ganlet: puputtɨ gamañ nɨm kɨtɨñɨlɨmbi, dɨk naka nain tɨpet gɨt no e-sembɨ tɨ-nametañ.” ");
INSERT INTO nif_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila ñɨndɨñ enguk, “Gɨnañjɨ mɨlataumbi, nandɨ-bendɨ wopum tañ wɨndɨñ nombo nɨm tɨnekalɨñ. Tambo sɨndɨ Kunum Yambattok plon panjañganembi, wɨndɨñgangot nokok plon panjañgane-ta-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nokok Bepnalok il kuseinan it gɨnañ asup patak. Nɨm palɨmda, nak ñɨndɨñ nɨm sanbet, ‘Nak ñambi, it tɨwɨlɨ dɨkñe tɨ-sametat.’ ");
INSERT INTO nif_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tɨmbi nak ñambi, it tɨwɨlɨ dɨkñe tɨ-sam-talemek, undane bɨmbi, sanañgɨlambi, sɨndɨ bo natna kuutatnan kunelɨñdok ñanekamɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tɨmbi nak kwet delok ñautat, wolok telak wɨn sɨndɨ ip nandɨ-taleañ.” ");
INSERT INTO nif_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tɨmbi Tomaslɨ nɨñguk, “Wopum, dɨk dendɨñ ñaukañ wɨn nɨndɨ nɨm nandɨ-dakleamɨñ, wala tɨmbi telak wɨn nɨtek nandɨ-dakleneñ?” ");
INSERT INTO nif_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Eumbi nɨñguk, “Natna telaktok kusei, manda biañgan sɨsɨnɨktok kusei, ba kuñgu sɨsɨnɨktok kusei. Nak napma klembi, Beptoñ tomtom wɨn no nɨm sɨnɨk patak. ");
INSERT INTO nif_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sɨndɨ nak nandɨ-kɨliñe tɨ-namumda, Bepna bo nandɨñmɨnelɨñ. Tɨmbi sɨndɨ man kusei kɨmɨpi, en nandɨ-kɨliñ tɨñmañ. Biañgan ñak, sɨndɨ en ikan kañgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tɨmbi Filiptɨ nɨñguk, “Wopum, dɨk Bep daut nɨmumbi, nandɨna tuop tɨ-nɨmek.” ");
INSERT INTO nif_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Eumbi nɨñguk, “Filip, nak nain ombapgan sɨn gɨta ip kuñgut, ganmek dɨk nokok kusatna gama nɨm nambɨ-nandɨ-tomlañ ba? No en nak nambɨñguktɨ Bep ip kañguk. Wɨndɨñda dɨk nekta ‘Bep daut nɨmekañ’ elañ? ");
INSERT INTO nif_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Beptɨ nokok gɨnañ palɨmbi, nak endok gɨnañ patet. Dɨk wɨn nɨm nandɨ-kwambɨñ dalañ ba? Nɨtɨ noñgan tamɨkta tɨmbi nak manda sanlet wɨn natnalok nanandɨnala nɨm pa elet. Tambo Bep nokok gɨnañ pataktɨ enlok kenan pa tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Beptɨ nokok gɨnañ palɨmbi, nak endok gɨnañ patet, sɨndɨ manda wɨn nandɨ-kwambɨñ da-kunekalɨñ. Tɨkap sɨndɨ nak wɨndɨñ eletta tɨmbi wɨn nandɨ-kwambɨñ danelɨñdok tuop nɨmda, kundit ep tɨmbambi kañgɨlɨñda tɨmbi wɨndɨñ tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Biañgan sɨnɨk, sɨndɨ kunditnala tɨmbi wɨndɨñ tɨnekalɨñ. Tɨmbi kundit tɨndɨlok kandañ nak ñɨndɨñ sanlet: nin endɨ nak nandɨ-kɨlɨktɨ tɨ-nam tɨ-kulakta, endɨ bo kena ba kundit natna tɨlet wɨndɨñgangot tɨmbekak. Tɨmbi endok kenan ba kundil walɨ natna kena ba kundit tɨñgut wɨn makleukak. Wɨn kusei ñɨndɨñda: nak Bepnaloñ loutat. ");
INSERT INTO nif_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Lowambi, sɨndɨ nokok kotnalok plon kɨtɨ-nambi, nek ba nek tɨ-samettok nanɨ-nandɨañ, wolok tuop nak Nɨñañdɨ Bepnalok kusal engano wɨn tɨmba inda-dakleuktok tɨ-sametat. ");
INSERT INTO nif_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wɨn tɨkap sɨndɨ nokok gɨñgɨtnai kuañda tɨmbi nek ba nek tɨ-samettok nanɨ-nandɨnekalɨñda, natna wɨn tɨ-sametat.” ");
INSERT INTO nif_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila ñɨndɨñ enguk, “Tɨkap sɨndɨ gɨnañjɨlɨ nep galk tañda, nak sɨndɨ nek tɨnelɨñdok sanɨ-dɨkñelet wolok tuop tɨ-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Tɨmbi nak Bepta nɨ-nandɨwambi, endɨ sɨndok Pañgembɨlanjɨ no nɨ-mulɨm pɨumbi, nokok kɨnjan sɨn gɨta papat kwambɨñgan kuukak. ");
INSERT INTO nif_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nak Dɨndɨm Woñ Beptok kusal sɨsɨnɨk wɨn tɨmbɨ inda-daklelak enla elet. Kwelalok gɨñgɨtñii endɨla en nɨm ka-nandañ ba en nɨm nandɨñmañ, wala tɨmbi endɨ en kasɨlenelɨñdok tuop nɨm. Gan Woñ walɨ sɨn gɨta kulak, tɨmbi sɨndok gɨnañjɨ gɨnañ pɨmbi, palekakta tɨmbi sɨndɨla en nandɨ-kɨliñ tɨñmañ. ");
INSERT INTO nif_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Nak sambiwambi, pañgembɨlanjɨ nɨmnat nomɨk nɨm kunekalɨñ. Nɨm. Nak sɨndoñ undane bɨutat. ");
INSERT INTO nif_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Wɨn nain nɨm ombataumbi, kwelalok gɨñgɨtñiilɨ nombo nɨm nambɨnekalɨñ, gan sɨndɨla bɨndambo nambɨnekalɨñ. Tɨmbi nak papat kwambɨñgan kuletta tɨmbi sɨndɨ bo kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sɨndɨ bɨndambo nambɨmek, ñɨndɨñ ka-nandɨ-daklenekalɨñ: nak Beptok gɨnañ patet, tɨmbi sɨndɨ nokok gɨnañ palɨmbi, nak sɨndok gɨnañ patet. ");
INSERT INTO nif_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nin endɨ nokok endɨkñe mandana nandɨ-dasimbi kɨmɨt-kle-kulakta, endɨ wakan gɨnañlɨ nep galk tambi, nep kasɨlelak. Tɨmbi nin endɨ wɨndɨñ tɨ-namlak, en wakan Bepnalɨ tɨke-galk taukak, tɨmbi natna bo en tɨke-galk tambi, nokok kusatna tɨmba inda-dakle-ñɨmekak.” ");
INSERT INTO nif_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tɨmbi Judas no, wɨn Judas Iskaliot en nɨm, walɨ Yesu nɨ-nandɨmbi eñguk, “Wopum, nɨtek tɨmbi dɨkok kusaka wɨn nɨndañgot tɨmbɨ inda-dakle-nɨmep elañ, gan kwelalok amatam dɨwɨnda nɨm?” ");
INSERT INTO nif_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tɨmbi Yesulɨ tambane nɨñguk, “Tɨkap nolɨ gɨnañlɨ nep kasɨle-kulakta, endɨ nokok mandana kɨmɨt-kle-kulak. Tɨmbi Bepnalɨ ama wandin wɨn tɨke-galk tambi, Bep nɨtɨ endoñ bɨmbi, en gɨta yakan papat kwambɨñgan kundekamɨk. ");
INSERT INTO nif_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Gan nin endɨ gɨnañlɨ nɨm nep kasɨle-kulakta, endɨ nokok mandana nɨm kɨmɨt-klelak. Tɨmbi manda sanbambi nandañ wolok kandañ wɨn ñɨndɨñ: wɨn natnalok manda nɨm, wɨn Bep nin nak kwelan nanɨ-mukuk enlok mandan. ");
INSERT INTO nif_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nak gama sɨn gɨta kuñɨpi, nepek gɨtɨk wɨn sanɨ-ta-bɨlet. ");
INSERT INTO nif_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Gan gamanda Beptɨ sɨndok Pañgembɨlanjɨ, wɨn Dɨndɨm Woñ, nɨ-mulɨm pɨmbi, nokok kɨnjannan sɨn gɨta kuukak. Tɨmbi endɨ wakan nepenepek gɨtɨk sanɨ-daut tɨ-sambi, natna manda sangut gɨtɨk wɨn tɨmbɨ kaikta-samumbi, bɨnda nandɨ-tomnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nak sambɨk bimbi, nokok busukna bɨsɨkñat pat-samektok samlet. Busuk samettok pat-namlak walɨ busuk kwelan nanin wandin nɨm. Nak busuk wɨn samletta tɨmbi sɨndok gɨnañjɨlɨ mɨlataumbi, mɨsɨmɨsɨ nɨm tɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nak manda ñɨndɨñ ikan sanbambi nandɨlɨñ, ‘Nak sambɨk bimbi, ñakap, sɨndoñ bɨndambo undane bɨutat.’ Sɨndɨ gɨnañjɨlɨ biañgan nep galk tambi, nep kasɨle-kuumda, nak Beptoñ ñautat wala sɨndɨ naka tɨmbi nandɨ-sɨlɨsɨlɨ tɨnelɨñ. Neta, Bepnalɨ nak napma klembi, loloñ sɨnɨk patakta. ");
INSERT INTO nif_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nepek gamamek indaukak wɨn nak man ñɨn itañgan sanɨ-talelet, wɨn kusei ñɨndɨñda: nak sanɨt wolok tuop indaukak, wolondamek sɨndɨ nak manda biañgan elet wɨn gumañ nandɨ-kwambɨñ danekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nak sɨn gɨta manda nombo yousɨm sansanlok nain lakatgot pat-namlak, wɨn kusei ñɨndɨñda: kwettok kandɨkñe ama Satan endɨ nep tɨmbɨ kolauttok bɨupi tɨlak. Endɨ nepek no tɨ-namektok gembɨ nɨm palmɨlak, ");
INSERT INTO nif_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","gan nak wandingan embi nɨm kɨmɨsip tɨñmɨlet. Tambo nak Bepna gɨnañnalɨ kasɨlelet wɨn kwelan kuañdɨ nambɨ-nandɨ-daklenelɨñdok Bepnalɨ nanɨ-dɨkñeñguk wolok tuopgan tɨlet. Ale, ip mɨlapi, pɨm ñana.” ");
INSERT INTO nif_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Tɨmbi Yesulɨ yousɨmbi, gwañgwañiila enbi eñguk, “Natna wain komba sɨsɨnɨk, tɨmbi nokok Bepnalɨ wain kenalok kandɨkñe ama. ");
INSERT INTO nif_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Endɨ nokok kɨtna gayam bien nɨm laliañ gɨtɨk wɨn dombɨmbi, ep kolɨm ñalak. Tɨmbi nokok kɨtna gayam bien laliañ walɨ bien lali-sɨnɨk tanelɨñdok endɨ tɨ-dɨndɨme kena pa tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Tɨmbi komba kii gayam bien lalilalilok tɨ-dɨndɨm eañ, wandin nak manda sanbambi nandɨ-dasiñgɨlɨñ walɨ ikan sep tɨ-dɨndɨm eumbi, Kunum Yambattok dainan dɨndɨm indañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tɨkap kii gayamdɨ komba plon nɨm yousɨm patakta, walɨ engan bien laliuktok tuop nɨm, wɨndɨñgangot tɨkap sɨndɨ natnalok plon nɨm yousɨm pakañda, bienjɨ lalinelɨñdok tuop nɨm. Wɨndɨñda tɨmbi sɨndɨ natnalok plon yousɨmbi pat-ta-kunekalɨñ, tɨmbi natna sɨndok plon yousɨmbi pat-ta-kuutat. ");
INSERT INTO nif_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Natna wain komba, tɨmbi sɨndɨ nokok kɨtna gayam. Nin endɨ nokoñ yousumbi, nak bo endoñ yousɨletta, walɨ wakan bien asup pa lalilak. Wɨn kusei ñɨndɨñda: nak napma klembi, bien lalilalilok telak no nɨm patak. ");
INSERT INTO nif_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tɨkap ama nolɨ nokoñ nɨm yousɨmbi patakta, endɨ komba gayam dombɨ kokottok wandin: wɨn tɨke kolɨmbi, yañetaumbi, kii gayam dɨwɨn gɨta ep kiupi, komba gɨnañ ep siu dɨndɨlok. ");
INSERT INTO nif_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tɨkap sɨndɨ nokoñ yousɨm pakañ, tɨmbi nokok mandana nandɨ-dasiañgɨlɨñ wɨn kɨmɨt-kle-kuañda, sɨndɨ Kunum Yambattɨ wɨndɨñ ba wɨndɨñ tɨ-samektok nandañ wala kɨndem nɨ-nandumbi, nandɨ-samekak. ");
INSERT INTO nif_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nandɨ-samumbi, sɨndɨ telak wɨndɨñ plon bien asup laliumbi, nokok gwañgwanai kuañ wɨndɨñ inda-daklelak, tɨmbi nokok Bepnalɨ kot gɨñgɨt tɨkelak.” ");
INSERT INTO nif_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yesulɨ yousɨmbi, gwañgwañiila enguk, “Beptɨ nep galk tañguk, wɨndɨñgangot nak sep galk tañgut. Tɨmbi nak yousɨmbi, sep galk ta-ñauttok sɨndɨ nokoñ yousɨm patnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wɨn natna Bepnalok endɨkñe mandan kɨmɨt-kle-talembi, endoñ yousɨm patet, tɨmbi endɨ yousɨyousɨñgan nep galk talak, wɨndɨñgangot tɨkap sɨndɨ nokok endɨkñe mandana kɨmɨt-kleañda, sɨndɨ nokoñ yousɨm patnekalɨñ, tɨmbi nak yousɨyousɨñgan sep galk tautat. ");
INSERT INTO nif_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Wɨn nak sɨmba sasat nandɨlet wɨn sɨndɨ bo nandɨmbi, gɨnanjɨ gɨnañ tokñeumbi pat-samektok nandɨlet, wala tɨmbi nokok mandana kɨmɨt-klenelɨñdok sanɨt. ");
INSERT INTO nif_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tɨmbi endɨkñe mandana wɨn ñɨndɨñ: nak sep galk tañgut, wɨndɨñgangot sɨndɨ gɨnañjɨlɨ tambo tɨke-galk tɨ-ta-kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tɨkap ama nolɨ noliila ep galk tambi kɨm-semekta, endɨ ep galk tɨndɨlok telak dɨwɨn gɨtɨk patak wɨn makle-sɨn tauk. ");
INSERT INTO nif_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tɨmbi tɨkap sɨndɨ nokok endɨkñe mandana kɨmɨt-kle-kuañda, sɨndɨ nokok notnai sɨnɨk inda-dakleañ. ");
INSERT INTO nif_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nak sɨnda kena gwañgwa nombo nɨm sanlet, tambo nak sɨnda nokok notnai sanɨ-talelet. Wɨn kusei ñɨndɨñda: kena gwañgwalɨ molomdɨ nek nandɨ-sambat tɨlak wɨn nɨm nandɨlak, gan nokok Bepnalɨ nepek gɨtɨñgɨtɨk nanguk wɨn nak sɨnda sanɨ-dakle-talewambi, sɨndɨ ikan nandɨ-taleañ. ");
INSERT INTO nif_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sɨndɨ nak nɨm nep kasɨleñgɨlɨñ. Tambo natna sep kasɨlembi, ñɨndɨñ tɨnelɨñdok sep dangut: sɨndɨ ñambi, bienjɨ tɨmbɨ indaukak, wɨn bien papat kwambɨñgan palekak wandin. Wɨndɨñ indaumek, sɨndɨ nokok kotna plon Bep kɨtɨñmɨmbi, nepek no ba no tɨ-samektok nɨ-nandañ, endɨ wolok tuop sɨnɨk tɨ-samekak. ");
INSERT INTO nif_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nak endɨkñe manda ñɨn bɨndambo sanba nandɨwɨt: sɨndɨ gɨnañjɨlɨ tambo tɨke-galk tɨ-ta-kunekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesulɨ bɨndambo yousɨmbi, ñɨndɨñ enguk, “Amatam kwelalok gɨñgɨt kuañdɨ nandɨ-kunjitta tɨ-samumbi, wolonda sɨndɨ nɨm nandɨ-kamalanekalɨñ, wɨn kwelalok gɨñgɨt kuañdɨ dama naka ip nandɨ-kunjitta tɨ-namgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sɨndɨ kwelalok gɨñgɨt kuumda, endɨ sɨnda nandum endok nosii tɨmbɨmbi, sep galk tanelɨñ. Gan nak endok boñgɨpsɨnan nanin sep kasɨlewambi, sɨndɨ natnalok gɨñgɨtnai kumbi, kwelalok gɨñgɨt nombo nɨm kuañ. Kusei wala tɨmbi endɨ sɨnda nandɨ-kunjitta tɨ-samañ. ");
INSERT INTO nif_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sɨndɨ manda ñɨn dama sangut wɨn nandɨ-tombɨt, ‘Kena gwañgwa sɨlanindɨ molomjɨlok kapmainan kuañ.’ Kusei wala tɨmbi tɨkap kwelalok gɨñgɨtñiilɨ nak nep tɨmbɨ kolauttok nep kle-gɨmgɨm eñgɨlɨñda, wɨndɨñgangot sɨndɨ bo sep tɨmbɨ kolanelɨñdok sep kle-gɨmgɨm enekalɨñ, tɨmbi tɨkap endɨ nokok mandana nandɨ-dasimbi kɨmɨt-kleñgɨlɨñda, wɨndɨñgangot endɨ sɨndok mandanjɨ bo nandɨ-dasimbi kɨmɨt-klenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Endɨ Bep nanɨ-mukuk en nɨm nandɨ-kɨliñ tɨñmañ, wala tɨmbi sɨndɨ nokok gɨñgɨtnai kuañda tɨmbi endɨ kolan wandin wɨn tɨ-samnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nak indambi, Bepnalok mandan engut wɨn ikan nɨm enbamda, yomjɨlok mɨlap nɨm pat-semek. Gan nak indambi, endok mandan engutta tɨmbi endɨ yom tɨndɨlok e-tembɨ manda no nɨm pat-semlak. ");
INSERT INTO nif_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Naka nandɨ-kunjitta tɨ-namlaktɨ Bepnala bo nandɨ-kunjitta tɨñmɨlak. ");
INSERT INTO nif_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ba nak kundit gembɨnat gɨtikñin amalɨ nɨm tɨndɨn endok boñgɨpsɨnan nɨm pa tɨmbamda, yomjɨlok mɨlap nɨm pat-semek. Gan endɨ kundit wɨn kañgɨlɨñ, ganmek Bep nɨta nandɨ-kunjitta tɨ-nɨmgɨlɨñ, wala tɨmbi yomjɨlok mɨlap kɨmɨlɨm pat-semlak. ");
INSERT INTO nif_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Endok endɨkñe mandanjɨ gɨnañ ñɨndɨñ youyoulɨn patak, ‘Endɨ naka slakan nandɨ-kunjitta tɨ-namgɨlɨñ,’ tɨmbi manda walɨ bien tɨmbektok endɨ wɨndɨñ tɨ-namgɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Yesulɨ yousɨmbi enguk, “Siñgimek nak sɨndok Pañgembɨlanjɨ wɨn Beptok kandañ nanin nɨ-muletat. Woñ walɨ Beptoñnan nanin pɨmbi, endok kusal sɨsɨnɨk wɨn tɨmbɨ inda-daklelak. Pɨmek, nokok kusatna e-dakle tɨmbekak, ");
INSERT INTO nif_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","tɨmbi sɨnɨ bo nokok kusatna e-dakle tɨ-ta-kunekalɨñ. Wɨn kusei ñɨndɨñda: sɨndɨ nak kena kusei kɨmɨkut naningan nakɨta ku-ta-bañ. ");
INSERT INTO nif_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nepek kolan sanɨt wandin walɨ inda-samumek, sɨndok nandɨ-kɨlɨktɨnjɨ wolonda nɨm pi pɨuktok nak manda gɨtɨk wɨn sanɨt. ");
INSERT INTO nif_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Endɨ it kiyaunjɨ gɨnañ nanin sep kle-kolɨmbi, pawan kunekalɨñ. Tɨmbi wɨndɨñgot nɨm. Nain indaumbi, nin endɨ sɨndoñnan nanin no wɨlɨ kɨmbekakta, endɨ ‘telak wolok plon Kunum Yambat kɨmɨt-klelet’ em nandukak, gan endɨ tɨmbɨ kamalaukak. ");
INSERT INTO nif_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Endɨ Bep nɨtɨ nɨm nandɨ-kɨliñ tɨ-nɨmañda tɨmbi wɨndɨñ tɨ-samnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nepek gamamek indaukak, wɨn nak man ñɨn itañgan sanɨ-talelet. Wɨn kusei ñɨndɨñda: nak sanɨt wolok tuop tɨ-samnekalɨñ, wolondamek nak endok plon manda sangut wɨn sɨndɨ nandɨ-tomnekalɨñ. Nak sɨn gɨta kuñgutta tɨmbi kena kusei kɨmɨkut wolonda nepek wolok kasat gama nɨm tɨ-samgut. ");
INSERT INTO nif_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gan man ñɨndɨñgɨt nak Bep nanɨ-mukuk endoñnan ñaupi tɨlet, gañgan sɨndoñnan nanin nolɨ ‘Dɨk dendɨñ ñaukañ?’ wɨndɨñ no nɨm nanɨ-nandañ. ");
INSERT INTO nif_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Tambo nak ñañalok manda mɨlap wandin sanletta tɨmbi, sɨmba gawattɨ sɨndok gɨnanjɨ tokñelak. ");
INSERT INTO nif_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gan nak manda ñɨndɨñ elet walɨ biañgan tɨlak: nak sambi ñautat wolok bien walɨ sɨndoñ inda-samekak. Neta, tɨkap nak nɨm sambi ñautta, Pañgembɨlalɨ sɨndoñ nɨm bɨwɨk. Tɨkap nak sambi ñautatta, nak en nɨ-mulambi, sɨndoñ bɨukak. ");
INSERT INTO nif_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Bɨmek, kwelalok gɨñgɨtñiila tɨmbɨ dakle-semumbi, nandɨ-kwambɨñ danekalɨñ, wɨn yom wɨn nek sɨnɨk, ba nin endɨ wɨn dɨndɨm sɨnɨk, ba Kunum Yambattɨ nɨtek sɨnɨk yambɨ-danbekak wɨn endɨ nɨm nandɨ-daklembi, nandum kamalalak. ");
INSERT INTO nif_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wɨn ñɨndɨñ: endɨ nak nɨm nandɨ-kɨlɨktɨ tɨ-namañ, walɨ yom biañgan sɨsɨnɨk. ");
INSERT INTO nif_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tɨmbi dɨndɨm kuñgulok kandañ wɨn ñɨndɨñ: nak Beptoñ undane ñawambi, sɨndɨ nombo nɨm nambɨnekalɨñ, walɨ nak dɨndɨm sɨnɨk wɨn tɨmbɨ inda-dakleukak. ");
INSERT INTO nif_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tɨmbi ka-danɨ kenalok kandañ wɨn ñɨndɨñ: Kunum Yambattɨ kwet ñolok kandɨkñe ama Satan ikan ka-danbi, tambon ombɨ-tɨkeuktok eu taleñgukta tɨmbi amatam bo yambɨ-danbekak. ");
INSERT INTO nif_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Manda sansanlok gama asup patak, gan man ñɨndɨñgɨt sɨndɨ wɨn gɨtɨk nandɨ-daklembi, nandɨ-dasinelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gan Woñdɨ Kunum Yambattok kusal sɨsɨnɨk wɨn tɨmbɨ inda-daklelak. Endɨ pɨmek, sɨndok nanandɨnjɨ ep tɨmbɨ pañgɨtaumbi, Yambattok kusal sɨsɨnɨk wɨn nandɨ-daklenekalɨñ. Wɨn kusei ñɨndɨñda: Woñdɨ enlok nanandɨnla manda no nɨm eukak, tambo manda nɨtek nɨmbɨmbi nandɨlak wolok tuop endɨ eukak, ba nepek nek siñgimek indaukak wɨn sanbɨ indaukak. ");
INSERT INTO nif_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Tɨmbi endɨ nak manda nɨmbambi nandɨlak wɨn sanbɨ indaukakta tɨmbi, endɨ nokok kusatna engano wɨn tɨmbɨ inda-dakleukak. ");
INSERT INTO nif_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bep nɨtok nanandɨnet wɨn noñganda tɨmbi nak ñɨndɨñ sanɨt, ‘Nak manda Woñda nɨmbambi nandɨlak wɨn sɨnda sanɨ-dakleukak.’” ");
INSERT INTO nif_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesulɨ yousɨmbi enguk, “Nain nɨm ombataumbi, sɨndɨ nombo nɨm nambɨnekalɨñ, tɨmbi nain nɨm ombataumbi, bɨndambo nambɨnekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wɨndɨñ eumbi, endok gwañgwañii dɨwɨndɨ nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Endɨ ñɨndɨñ elak, ‘Nain nɨm ombataumbi, nɨndɨ nombo nɨm kanekamɨñ, tɨmbi nain nɨm ombataumbi, bɨndambo en kanekamɨñ,’ tɨmbi ‘Endɨ Beptoñ undane ñaukakta tɨmbi wɨndɨñ indaukak.’ Manda wolok walan walɨ nek plon e-yout tɨlak?” ");
INSERT INTO nif_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Wɨndɨñ eñɨpi, nɨsɨñgan e-nandɨñgɨlɨñ, “‘Nain nɨm ombatalak’ manda wolok walan wɨ nɨtek? Nek elak wɨn nɨndɨ nɨm nandɨ-dakleamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Tɨmbi endɨ wala nɨ-nandɨnelɨñdok nandumbi, Yesulɨ yambɨ-nandɨ-daklembi enguk, “Nak ñɨndɨñ sanɨt, ‘Nain nɨm ombataumbi, sɨndɨ nombo nɨm nambɨnekalɨñ, tɨmbi nain nɨm ombataumbi, bɨndambo nambɨnekalɨñ.’ Wɨn manda wolok kuseila sɨngan e-nandɨ tañ ba? ");
INSERT INTO nif_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Manda et walɨ biañgan sɨnɨk. Tɨmbi nak ñɨndɨñ sanlet: nak kɨmbambi, sɨndɨ kut-blamblan embi, mano tɨnekalɨñ, gan kwelalok gɨñgɨtñiilɨ sɨlɨsɨlɨ tɨnekalɨñ. Tɨmbi sɨndok gɨnañjɨ mɨlata sɨnɨk taumbi patnekalɨñ, gan sɨndɨ bɨndambo nambɨmbi, sɨndok nandɨ-mɨlapsɨlok kɨnjannan sɨlɨsɨlɨlɨ inda-samekak. ");
INSERT INTO nif_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wɨn tamdɨ gwañgwa tɨkelak wandin inda-samekak. Endok pɨñgɨp gawat tɨndɨlok nainñɨn indalakta tɨmbi gɨnan mɨlata sɨnɨk taumbi patak, gan endɨ gwañgwa tɨkemek, gwañgwan indañmɨlak walɨ sɨlɨsɨlɨ mɨumbi, mɨlap wɨn ip kamalalak. ");
INSERT INTO nif_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wɨndɨñgangot nain ñolonda sɨndok gɨnañjɨ mɨlatalak, gan nak bɨndambo bɨ sambambi nambɨnekalɨñ, wolonda walenjɨlɨ bo kɨndem daumbi, sɨlɨsɨlɨlɨ gɨnañjɨ tokñeukak, tɨmbi ama nolɨ sɨndok sɨlɨsɨlɨnjɨ solom tɨkenelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nain wɨn indaumek, sɨndɨ nepek nolok plon nombo nɨm nak nanɨ-nandɨnekalɨñ. Wɨn biañgan sɨnɨk. Tɨmbi nak ñɨndɨñ sanlet: sɨndɨ nepek no ba nola nokok Bepnala nɨ-nandɨnekalɨñ, wolok tuop endɨ nokok kotna plon samekak. ");
INSERT INTO nif_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Sɨndɨ nokok kotna plon enda nepek nola nɨm nɨ-nandɨ-ta-bɨñgɨlɨñ. Ale, man ñɨn sɨndɨ kɨndem gɨñgɨnembi, nɨ-nandɨ tɨ-ta-kunekalɨñ, tɨmbi wolok tuopgan inda-samumbi, nandɨ-sɨlɨsɨlɨlɨ gɨnañjɨ tokñeukak.” ");
INSERT INTO nif_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yesulɨ yousɨmbi, ñɨndɨñ enguk, “Nak manda sanɨ-ta-bɨlet wɨn eyout mandalɨñgot sanlɨñgut, gan nain indaumbi, nak manda eñɨpi, eyout manda nombo nɨm sanbetat. Tambo nokok Bepnalok plon indañgan kasat tɨ-sametat. ");
INSERT INTO nif_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nain wolonda sɨndɨ nokok kotna plon Bep nɨ-nandɨnekalɨñ. Nak Beptɨ sep kɨmɨlektok nɨ-nandutat wɨndɨñ nɨm sanlet, tambo ñɨndɨñ sanlet: wɨn sɨn en nɨ-nandɨnekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Wɨn kusei ñɨndɨñda: sɨndɨ gɨnañjɨlɨ nak nep galk tambi, nak Beptoñnan nanin pɨñgut wɨn nandɨ-kwambɨñ da-kuañda tɨmbi endɨ sep galk tambi, nɨ-nandɨnjɨ nandɨ-samekak. ");
INSERT INTO nif_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nak en gɨta pakap kwelan pɨmbi indañgutta, man ñɨn kwet ñɨn bimbi, endoñ undane loupi tɨlet.” ");
INSERT INTO nif_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wɨndɨñ eumbi, gwañgwañiilɨ nɨñgɨlɨñ, “Ei! man ip dɨk eyout manda bimbi, manda indañgan nɨnɨlañ wɨn! ");
INSERT INTO nif_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Man ñɨn nɨndɨ gambɨ-nandamɨñ, wɨn dɨk nepek gɨtɨñgɨtɨk nandɨ-talelañ, tɨmbi nɨndɨ gama nɨm ganɨ-nandɨnambi, dɨk ikan nɨndok nanandɨnɨ ka-nandɨ-daklelañ. Kusei wala tɨmbi nɨndɨ dɨk Kunum Yambattoñnan nanin pɨñguñ wɨn nandɨ-kwambɨñ damɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tɨmbi Yesulɨ tambane enguk, “Ba sɨndɨ biañgan ip nandɨ-kwambɨñ da-namañ ba? ");
INSERT INTO nif_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Nandañ! Nɨm ombataumbi, nain ñɨn ip inda-talelak: nokok kanjɨknailɨ sep kleumbi, sɨndɨ nak nambium, natnañgan palambi, sɨndɨ noñgan noñgandɨ papusenembi, isɨnan pi ña-talenetañ, ganmek nokok Bepnalɨ nakɨta patakta tɨmbi nak natnañgan nɨm paletet. ");
INSERT INTO nif_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sɨndɨ nokok gɨnañ kuañda tɨmbi busuk bɨsɨkñat wɨn kasɨleumbi pat-samektok nak manda wɨn sanɨt. Kwelan ñolok mɨlap kusei kusei pat-samlak, gan nak kwelalok gembɨn kolan wɨn ip wɨla pɨñgukta tɨmbi sɨndok sɨmbatsɨ saleun.” ");
INSERT INTO nif_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesulɨ manda wɨn eu taleumbi, kunum gɨnañ deium loumbi, Beula nɨmolo ñɨndɨñ tɨñmɨñguk, “Ambep, nak mɨlap bembi, kɨmbettok nain ip indalak. Dɨk nandɨ-namumbi, nak dɨkok Nɨñañgalɨ kusaka engano wɨn tɨmba inda-dakleuktok dɨk bo nokok kusatna engano wɨn tɨmbɨ inda-dakleukañ. ");
INSERT INTO nif_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Dɨk ama nep kɨmɨt-klenelɨñdok namguñ, tɨmbi nak kuñgu taletalen nɨmnat enda emettok nandɨñguñ, wala tɨmbi dɨk nak amatam gɨtɨk yambɨ-dɨkñeuttok napɨkuñ. ");
INSERT INTO nif_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tɨmbi kuñgu taletalen nɨmnat wolok walan wɨn ñɨndɨñ: endɨ Kunum Yambat sɨsɨnɨk noñgangot dɨk nandɨ-kɨliñ tɨ-gamañ, tɨmbi Yesu Mesia dɨk nanɨ-mukuñ naka nandɨ-kɨliñ tɨ-namañ. ");
INSERT INTO nif_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Dɨk naka kena tɨmbettok namguñ wɨn gɨtɨk tɨmba taleñguk, tɨmbi telak wolok plon dɨtnalok kusaka engano wɨn kwelan ñolok tɨmba inda-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ale, Bep, man ñɨn dɨk nandɨ-nambi, natnalok kusatna engano wɨn ñɨndɨñ tɨmbɨ inda-daklewɨn: kwet gama nɨm indañɨlɨmbi, nak dɨkɨta kuñɨpi, nokok pipapatna engano pat-namguk wɨn dɨk bɨndambo naka namumbi pat-namun. ");
INSERT INTO nif_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Dɨk kwelan kuañ endoñnan nanin dɨwɨn ep danbi, nokok gwañgwanai kunelɨñdok yapɨkuñ, tɨmbi nak dɨkok kusaka enda enɨ-dakle-semambi, endɨ dɨk nandɨ-kɨliñ tɨ-gamañ. Wɨn endɨ dɨkok gɨñgɨtkai, gan dɨk nakɨta kunelɨñdok yapɨkuñ, tɨmbi nak yambɨ-dɨkñewambi, endɨ dɨkok mandañga kɨmɨt-kle-kumbi, ");
INSERT INTO nif_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","man ñɨndɨñgɨt nambɨ-nandɨ-dakleañ, wɨn dɨk nepek gɨtɨñgɨtɨk namumbi pat-namlak walɨ biañgan dɨkoñnan nanin. Endɨ wɨndɨñ nandɨ-dakleañ, ");
INSERT INTO nif_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","wɨn kusei ñɨndɨñda: dɨk manda naka nanguñ wɨn nak enda enba taleñguk. Ewambi, endɨ nandɨ-dasimbi, nak dɨkoñnan nanin pɨ indañgut wɨn biañgan ka-nandɨ-dakleañ, tɨmbi dɨk nanɨ-mukuñ wɨn ip nandɨ-kwambɨñ da-taleañ. ");
INSERT INTO nif_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nak enda tɨmbi nɨmolo tɨ-gamlet. Nak man ñɨndɨñgɨt kwelan kuañ gɨtɨkta nɨmolo nɨm tɨ-gamlet. Tambo nak ama nin dɨk nokok gwañgwanai kunelɨñdok yapɨkuñ endañgot nɨmolo tɨ-gamlet, wɨn kusei ñɨndɨñda: endɨ dɨkok gɨñgɨtkai sɨnɨk. ");
INSERT INTO nif_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wɨn nokok gɨñgɨt kuañ endɨ gɨtɨk dɨkok gɨñgɨtkai, tɨmbi dɨkok gɨñgɨtkai gɨtɨk endɨ nokok gɨñgɨtnai. Tɨmbi endok kuñgunjɨlɨ nokok kusatna engano wɨn tɨmbɨ inda-daklelak. ");
INSERT INTO nif_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nak kombɨkan dɨkoñ bɨutat, tɨmbi kwelan ñolok nombo nɨm yousɨmbi kuutat, gan endɨla kwelan yousɨmbi kunekalɨñ. Bep Giñgi Sɨnɨk nɨtɨ noñgan tamɨk, wɨndɨñgangot endɨ bo noñgan tɨnelɨñdok dɨk nandɨ-nambi, dɨkok gembɨñga naka namguñ walɨ ep kamaiukañ. ");
INSERT INTO nif_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nak en gɨta kuñɨpi, dɨk gembɨ namguñ walɨ ep kamaimbi yambɨ-dɨkñe-ta-bɨñgut. Tɨmbi endoñnan nanin no kolandok gɨñgɨt kuñguk en noñgandɨñgot kolañguk, nolii dɨwɨnlɨ nɨm. Wɨn manda youyoulɨn patak walɨ bien tɨmbektok wɨndɨñ indañguk. ");
INSERT INTO nif_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ale, nak dɨkoñ bɨupi tɨlet, gan nak nandɨ-sɨlɨsɨlɨ tɨlet wolok tuopgan endɨ bo nandɨ-sɨlɨsɨlɨ tɨnelɨñdok nak kwelan ñolok gamañgot patetta manda gɨtɨk ñɨn enbambi nandañ. ");
INSERT INTO nif_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Dɨk manda nanguñ wɨn nak enda enɨ-talewambi, endɨ nandɨ-dasiñgɨlɨñ, tɨmbi natna kwet ñolok gɨñgɨt nɨm kulet, wɨndɨñgangot endɨ bo kwet ñolok gɨñgɨt nombo nɨm kuañ, wala tɨmbi kwelalok gɨñgɨt kuañdɨ nandɨ-kunjitta tɨ-semañ. ");
INSERT INTO nif_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Dɨk kwet ñalinin yapma tɨkeuñdok nɨmolo nɨm tɨ-gamlet. Tambo nak ñɨndɨñ nɨmolo tɨ-gamlet: dɨk ep kamaiumbi, kolan molomdɨ ep tɨmbɨ kolanelɨñdok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Natna kwet ñolok gɨñgɨt nɨm, wɨndɨñgangot endɨ bo kwet ñolok gɨñgɨt nɨm kuañ. ");
INSERT INTO nif_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wɨndɨñda tɨmbi dɨkok mandañgalɨ kusaka sɨsɨnɨk wɨn e-daklelak, walɨ ep tɨmbɨ pañgɨtaumbi, endɨ dɨtnalok gɨñgɨtkaiñgot kunekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Dɨk nak kwelan nanɨ-mulɨmbi indañgut, wɨn dɨkok kenañga tɨmbettok. Wɨndɨñgangot nak bo endɨ kwelan enɨ-mut-talelet. ");
INSERT INTO nif_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Tɨmbi endɨ bo biañgan kuñgunjɨ dɨkok bi-gamnelɨñdok nak dɨkok kenañga tɨmbettok kuñguna dɨkok bi-gam-talelet.” ");
INSERT INTO nif_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Tɨmbi Yesulɨ nɨmolo yousɨm tɨmbi eñguk, “Bep, nak gwañgwanai 11 endañgot nɨmolo nɨm tɨ-gamlet. Tambo nak amatam nin endɨ gwañgwanailok mandanjɨ nandɨmbi, nandɨ-kɨlɨktɨ tɨ-namnekalɨñ, enda bo nɨmolo tɨ-gamlet. ");
INSERT INTO nif_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Wɨn Bep dɨk nokok gɨnañ palɨmbi, nak dɨkok gɨnañ palambi, nɨtɨ noñgan tamɨk, wɨndɨñgangot endɨ bo noñgan tɨnelɨñdok nak nɨmolo tɨlet. Tɨmbi kwelan kuañ gɨtɨktɨ dɨk wakan nak nanɨ-mukuñ wɨn nandɨ-kwambɨñ danelɨñdok nak nandɨ-kɨlɨktɨ tɨ-namnekalɨñdɨ Bep nɨtok gɨnañ patnelɨñdok nɨmolo tɨlet. ");
INSERT INTO nif_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nɨtɨ noñgan tamɨk, wɨndɨñgangot endɨ bo noñgan tɨnelɨñdok nak nandɨ-sembi, dɨk pipapat engano naka namguñ pat-namlak wɨn emambi pat-semlak. ");
INSERT INTO nif_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Wɨn endɨ noñgan sɨnɨk inda-talembi, noñgan tɨnelɨñdok nak endok gɨnañ palambi, dɨk nokok gɨnañ patañ. Endɨ wɨndɨñgan noñgan tɨnekalɨñ, wolonda kwelan kuañ gɨtɨktɨ ka-nandɨ-daklenekalɨñ, wɨn dɨk wakan nanɨ-mukuñ, tɨmbi dɨk nak nep galk tañguñ, wɨndɨñgangot nak nandɨ-kɨlɨktɨ tɨ-namañ wɨn ep galk tañguñ. ");
INSERT INTO nif_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Kunum kwet gama nɨm indañɨlɨmbi, dɨk nak nep galk tañguñda tɨmbi pipapat engano wɨn namguñ pat-namlak. Bep, nak ñɨndɨñ indauktok nandɨ-galk talet: amatam nakɨta kunelɨñdok namguñ, endɨ bo natna kuutatnan nakɨta kumbi, nokok pipapat engano wɨn kanekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Bep ep tɨndɨn dɨndɨm molom, kwelalok gɨñgɨtñiilɨ dɨka nɨm nandɨ-gamañ, gan nakta nandɨ-kɨliñ tɨ-gamlet, tɨmbi dɨk nanɨ-mulɨmbi indañgut wɨn nokok gwañgwanai ñalɨ ka-nandɨ-tom-taleañ. ");
INSERT INTO nif_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nak dɨkok kusaka engano wɨn daut semgut, tɨmbi yousɨmbi daut sem-ta-ñautat. Wɨn dɨk nak nep galk talañ, wɨndɨñgan endɨ bo tambo ep galk tanelɨñdok ba nak en gɨta kuuttok wɨndɨñgan tɨ-semetat.” ");
INSERT INTO nif_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesulɨ nɨmolo tɨmbɨ taleumbi, gwañgwañii gɨt pakɨlɨñnan nanin pɨm ñambi, tuk no koi Kitlon wɨn dɨkñembi, oliv komba kena no wandɨñ pakuknan ña tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Endɨ wolok nain asup kɨmɨn tañgɨlɨñda tɨmbi Judas Yesu endok kanjɨkñiilok kɨsɨnan kɨmɨlepi tɨñguk endɨ bo kwet wɨn nandɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wɨndɨñda tapma ama biesɨ gɨt Falisi amalɨ tapma ittok kamaikamai ama dɨwɨn enɨ-mukɨlɨñ en wakɨt Romalok mik ama dɨwɨn Judaslɨ ep kiulɨmbi, endɨ tou gɨt sipalak ep pɨndopi, miktok nepenepek epmumbi, Judaslɨ yanañgɨlɨmbi, kwet wolok bɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Bɨumbi, Yesulɨ nɨtek indañmektok wɨn ikan nandɨ-taleñɨpi, ña ep tɨmbɨ indaumbi enguk, “Sɨndɨ nin lonjañ?” ");
INSERT INTO nif_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eumbi tambane nɨñgɨlɨñ, “Yesu Nasalet nanin.” Eumbi enguk, “Wɨn nak ñakan.” (Tɨmbi Judas Yesu kanjɨkñiilok kɨsɨnan kɨmɨkuk endɨ ama wolok boñgɨpsɨnan ikuk.) ");
INSERT INTO nif_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesulɨ “Wɨn nak ñakan” wɨndɨñ eumbi, wolongan amalɨ nandɨ-sɨlɨkñembi, siñgisiñgilok ñambi, pi pɨ-taleñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wɨndɨñ tɨmbɨmbi, bɨndambo enɨ-nandɨmbi eñguk, “Sɨndɨ nin lonjañ?” Eumbi, “Yesu Nasalet nanin” wɨndɨñ nɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Eumbi, Yesulɨ tambane enguk, “Wɨn nak ñakan wɨn ikan sanɨt. Wɨndɨñda tɨkap sɨndɨ nak nep lonjañda, notnai ñɨn yambiumbi ñawɨt.” ");
INSERT INTO nif_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesulɨ manda wɨndɨñ eñguk, wɨn endɨ dama Beula ñɨndɨñ nɨñguk walɨ bien tɨmbektok eñguk, “Dɨk ama nakɨta kunelɨñdok namguñ wɨn nak yambɨ-dɨkñewambi, no nɨm paikɨlɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Tɨmbi Simon Petlolɨ kakit tɨke bɨñguk wɨn tiañeum lambumbi, tapma amalok telak damanjɨ endok kena gwañgwa sɨlanin no koi Malkus endok pawan kɨt dɨndɨm kandañ nanin wɨlalɨm pi pɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wɨndɨñ tɨmbɨmbi, Yesulɨ Petlola nɨñguk, “Dɨkok kakitka kwelnan suaeum pɨwɨn. Bepnalɨ engan mɨlap ñɨn kɨmɨt-namguk wɨn nɨtekta tɨmbi nɨm bembet?” ");
INSERT INTO nif_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Tɨmbi mik ama wakɨt endok telak damanjɨ ba tapma ittok kamaikamai ama endɨ Yesu tɨkembi, kii imbi ");
INSERT INTO nif_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","nañgɨpi, ama no koi Anas endoñ dama ñañgɨlɨñ. Anas endok wembanlok wapai koi Kaiafas endɨ gwɨlat wolonda tapma amalok telak damanjɨ kuñguk. ");
INSERT INTO nif_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Wɨn Kaiafas en wakan Juda ama biesɨla nanandɨ dama ñɨndɨñ emguk, “Ama noñganlɨñgot amatam gɨtɨktok kɨnjanjɨ kɨmbek wɨn kɨndem.” ");
INSERT INTO nif_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yesu nañgɨp ñañɨlɨmbi, Simon Petlo gɨt Yesulok gwañgwa no endɨ siñgi klem ñañgɨmɨk. Tapma amalok telak damanjɨ endok sambaliilɨ gwañgwa no wɨn nandɨñmɨñgɨlɨñ, wala tɨmbi endɨ telak damalok il sañ jimba gɨnañ Yesu kɨndem klem loñguk, ");
INSERT INTO nif_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","gan Petlolɨ telak yama pawan ikuk. Tɨmbi gwañgwa nin telak damanjɨlok sambaliilɨ nandɨñmɨñgɨlɨñ endɨ pɨ ñambi, telak yama kandɨkñe wembela Petlolok plon manda nɨmbɨmbi, yama pɨsalɨmbi, gwañgwa walɨ Petlo nañgɨlɨmbi, gɨnañ loñgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Loumbi, yama kandɨkñe wembe walɨ Petlo nɨ-kañbi eñguk, “Nɨm kañbi, dɨk bo ama wolok gwañgwa no?” Eumbi nɨñguk, “E, nak nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sasale tɨñgukta tɨmbi tapma amalok telak damanjɨ endok kena gwañgwa gɨt tapma ittok kamaikamai ama endɨ komba sim ipi, sei-palɨmbi, Petlo endɨ bo boñgɨpsɨnan ña ipi, komba sei-pakuk. ");
INSERT INTO nif_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Tɨmbi Anas tapma amalok telak damanjɨ damañgan pakuk endɨ Yesu nɨ-kañbi, endok gwañgwañiilok plon ba manda e-daut tɨlɨñguk wolok plon nɨ-nandɨnandɨ tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tɨmbi Yesulɨ ñɨndɨñ tambane nɨñguk, “Nak amatam gɨtɨkta indañgan manda engut, wɨn Juda amatam gɨtɨktɨ it kiyaunjɨ gɨnañ ba tapma ilan kɨmɨn tañ wolok nain tuop manda enɨ-daut tɨ-sem-ta-kuñgut, tɨmbi nak kwet sembɨnnan nepek no nɨm eñgut. ");
INSERT INTO nif_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wala tɨmbi nekta naka nanɨ-nandɨlañ? Manda enbambi nandɨñgɨlɨñ enda enɨ-kaukañ; endɨ mek nak nek engut wɨn nandañ.” ");
INSERT INTO nif_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wɨndɨñ eumbi, kamaikamai ama ñasɨñgan ikɨlɨñ endoñnan nanin nolɨ Yesu timan dai plon wɨpi nɨñguk, “Dɨk tapma amalok telak damanjɨ enda nɨtekta manda wɨndɨñ tambane nɨlañ?” ");
INSERT INTO nif_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Eumbi tambane nɨñguk, “Manda ewa kamalalakta, wɨn kusei nanɨ-dakleumbi nandɨwa, ba dɨndɨm eletta, dɨk nekta slakan nɨtañ?” ");
INSERT INTO nif_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tɨmbi Anaslɨ eumbi, Yesu kii im-bimbin nañgɨp ñambi, tapma amalok telak damanjɨ Kaiafas endoñ ñañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tɨmbi Simon Petlolɨ komba sei-palɨñɨlɨmbi, nɨ-nandɨmbi eñgɨlɨñ, “Nɨm kañbi, dɨk bo ama wolok gwañgwa no?” Eumbi, e-kɨmɨt-sembɨmbi enguk, “E, nak nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tɨmbi tapma amalok telak damanjɨ endok kena gwañgwa no, wɨn ama nindok pawan Petlolɨ wɨlɨ dɨkñeñguk endok wekai dɨptɨ Petlola ñɨndɨñ nɨñguk, “Dɨk oliv komba kena gɨnañ en gɨta kuumbi gambɨt wɨn!” ");
INSERT INTO nif_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Eumbi, bɨndambo “Wɨn nak nɨm” eumbi, wolongan puputtɨ kɨtɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kwet salaumbi, Juda ama biesɨlɨ Kaiafaslok il bimbi, pɨm ñambi, Yesu nañgɨpi, kandɨkñe ama Pilatolok ilan ñañgɨlɨñ, gan il gɨnañ nɨm loñgɨlɨñ, wɨn kusei ñɨndɨñda: endɨ Roma ama Pilatolok il gɨnañ loumda, Kunum Yambattok dainan kolambi, Kamaikamai gwɨlattok nanañ sandap wolonda nanelɨñdok tuop nɨm. It gɨnañ nɨm lombi, sañ jimba gɨnañ palɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilatolɨ pɨm, endoñ ñambi, enɨ-nandɨmbi eñguk, “Sɨndɨ ama ñala manda nɨtek embi, kɨt yout tɨñmañ?” ");
INSERT INTO nif_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Eumbi tambane nɨñgɨlɨñ, “Endɨ kolan tɨndɨ ama nɨm palɨmda, dɨkok kɨkanan slakan nɨm kɨmɨtneñ.” ");
INSERT INTO nif_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Eumbi, Pilatolɨ enguk, “Tɨkap wɨndɨñda, sɨn en tɨkembi, sɨnlok endɨkñe mandanjɨ kɨmɨt-klembi, manda plon kɨmɨlɨt.” Eumbi, ama biesɨlɨ nɨñgɨlɨñ, “Juda nɨndok endɨkñe mandanɨlɨ en kɨmkɨmlok elak, gan Roma sɨndok endɨkñe mandanjɨlɨ nɨndɨ sep lapɨpi, wɨndɨñ tɨneñdok kɨmɨsip patak.” ");
INSERT INTO nif_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Juda ama biesɨlɨ Pilatola wɨndɨñ nɨñgɨlɨñ, walɨ tɨmbɨ inda-dakleñguk, wɨn Yesulɨ damañgan kɨmkɨm nɨtein kɨmbektok e-dakleñguk, manda walɨ bien tɨmbep tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Tɨmbi kandɨkñe Pilatolɨ ama biesɨlok mandanjɨ nandɨ-talembi, kandɨkñe amalok it gɨnañ undane lombi, Yesu kɨtɨñmum bɨumbi nɨ-nandɨmbi eñguk, “Ba dɨk ñakan Juda amatamdok ama wapmañjɨ ba?” ");
INSERT INTO nif_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Eumbi tambane nɨ-nandɨñguk, “Ba dɨk manda wɨn dɨtnalok nanandɨñgala elañ, ba dɨwɨndok manjɨ klembi elañ?” ");
INSERT INTO nif_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Eumbi nɨñguk, “Natna Juda ama nɨm, wala tɨmbi dɨkok kusaka nɨtek nandɨ-gamet? Wɨn dɨtnalok amatamgai gɨt tapma ama biesɨlɨ gepbi, nokok kɨtnanan gapɨkañ. Dɨk nɨtek sɨnɨk tɨñguñ?” ");
INSERT INTO nif_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Eumbi tambane nɨñguk, “Nokok ama wapmañ kuñguna wɨn kwet ñolok nɨm. Wɨn kwet ñolok palɨmda, nokok kena gwañgwanailɨ kanjɨknai mik tɨ-semumbi, endɨ nɨtek plon nepbi, Juda ama biesɨlok kɨsɨnan napɨtnelɨñ? Gan nokok ama wapmañ kuñguna wɨn kwet ñolok nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Tɨmbi Pilatolɨ nɨñguk, “Wɨndɨñda dɨtna ama wapmañ wɨndɨñ elañ ba?” Eumbi tambane nɨñguk, “Naka ama wapmañ nanlañ wɨn dɨndɨm elañ. Wɨn kusei biañgan sɨsɨnɨk wɨn e-dakle kena tɨmbettok menalɨ napmɨumbi, kwelan indañgut. Tɨmbi nin endɨ kusei biañgan sɨsɨnɨk wɨn tɨke-kwambɨñ dalok nandɨ-galk tañ gɨtɨk endɨ nokok mandana nandɨmbi nandɨ-dasiañ.” ");
INSERT INTO nif_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Eumbi, Pilatolɨ nɨñguk, “Kusei biañgan sɨsɨnɨk wɨn nek sɨnɨk?” Tɨmbi Pilatolɨ bɨndambo pɨmbi, Juda amatamdoñ ñambi enguk, “Nakta endok kolan no nɨm tɨmba indalak. ");
INSERT INTO nif_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gan nak sɨndok ep tɨndɨnjɨ no kɨmɨt-klembi, Kamaikamai gwɨlat tuop ama no it kwambɨñ gɨnañ nanin sɨndok pa pɨsat-samlet, wala tɨmbi sɨndɨ nak ama ñɨn Juda amatamdok ama wapmañjɨ nɨnɨn en pɨsat-samettok nandañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wɨndɨñ eumbi, endɨ kwawañganembi, tambane nɨñgɨlɨñ, “Nɨm yañ! Barabas kak pɨsat-nɨmɨñ!” Barabas wɨn endɨ ama piñpiñen nin Roma ama mik tɨ-semlɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wolongan Pilatolɨ eumbi, mik amalɨ toa pɨsɨk asupnat gaut gwɨlaptɨ tɨndɨn walɨ Yesu waipgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tɨmbi ama wapmañ walan esɨlɨmɨñɨpi, toa no pɨsɨkñat walɨ bondɨnembi, kumbannan kɨmɨlɨ pɨumbi, sauloñ gɨmɨn dasi-mɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Wɨndɨñ tɨñɨpi, ama noñgan noñgan endoñ bɨñgɨlɨñ tuop endɨ walan noñgangot tɨmbi, “Judalok ama wapmañjɨ, we!” wɨndɨñ nɨmbi, timan dai plon kɨt pɨndɨm wɨkɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Tɨmbi Pilatolɨ bɨndambo pɨmbi, kɨmɨn gɨtɨktoñ ñambi enguk, “Nandɨwɨt: nak en sɨndoñ nañgɨp bɨwambi, sɨndɨ ñɨndɨñ ka-nandɨwɨt: nakta endok yomɨnlok bien lonjɨ nɨm kañ bilet.” ");
INSERT INTO nif_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Tɨmbi Yesu en toa pɨsɨkñat bondɨnen gɨt sauloñ gɨmɨnnat wakɨt pɨ ilɨmbi, Pilatolɨ daut sembi enguk, “Ama ñɨn kawɨt!” ");
INSERT INTO nif_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wɨndɨñ eumbi, tapma ama biesɨ gɨt tapma ittok kamaikamai amalɨ Yesu kañgɨlɨñ, wolongan endɨ wopumgan kɨtɨmbi eñgɨlɨñ, “Kloñbat plon wɨlɨ kɨmbɨn!” Eumbi, Pilatolɨ manjɨnan tɨkembi enguk, “Nakta endok yomɨn yolonjɨletta tɨmbi sɨndɨ en tɨkembi, kloñbat plon wɨlɨt.” ");
INSERT INTO nif_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tɨmbi Juda ama biesɨlɨ tambane nɨñgɨlɨñ, “Endɨ enla ‘Nak Kunum Yambattok Nɨñañ’ wɨndɨñ pa elak, tɨmbi endɨkñe manda pat-nɨmlak walinin nolɨ ama wandisɨ wɨn yandɨp kɨmnelɨñdok elak.” ");
INSERT INTO nif_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tɨmbi Pilatolɨ Yesulok plon manda wandin wɨn nandɨñguk wolonda endɨ wɨlɨ kɨmnelɨñdok eu taletalela mɨsɨ sɨnɨk tambi, ");
INSERT INTO nif_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Yesu it gɨnañ nañgɨp lombi, nɨ-kañbi eñguk, “Dɨk denanin sɨnɨk?” Gan Yesulɨ tambon no nɨm tambane nɨñguk, ");
INSERT INTO nif_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","wala tɨmbi Pilatolɨ nɨñguk, “Nɨtek? Ba dɨk manda tambon no nɨm nanlañ ba? Nak dɨk slak gambiwam kuuñdok ba ewa kloñbat plon kɨmbeñdok gembɨ pat-namlak, wɨn dɨk nɨm nandɨ-daklelañ ba?” ");
INSERT INTO nif_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tɨmbi Yesulɨ tambane nɨñguk, “Kunum Yambattɨ gembɨ nɨm gamumda, nepek no tɨ-nameñdok gembɨ no nɨm pakamek. Kusei wala tɨmbi ama nin nak dɨkok kɨkanan napɨkuk endok yomɨnlɨ dɨkok yomga maklelak.” ");
INSERT INTO nif_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatolɨ manda wala tɨmbi Yesu kañbiuktok telak lonjɨñguk, gan Juda ama biesɨlɨ kwawa tɨmbi kɨtɨmbi, Pilatola nɨñgɨlɨñ, “No en enla ama wapmañ elak, endɨ Roma ama wapmañ Sisala kanjɨk tɨñmɨmbi e-ta-pɨ tɨñmɨlak. Wɨndɨñda tɨkap dɨk ama ñɨn kañbiutañda, dɨk bo Sisalok nol nɨm indalañ.” ");
INSERT INTO nif_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatolɨ manda wɨndɨñ nandɨmbi, wolongan endɨ Yesulok mandan eu taleuktok en nañgɨp pɨmbi, ka-danɨ amalok pitit plon pipakuk, kwet kawat pɨndɨmlɨ galgalɨn wolok. (Juda amalok mandanjɨnan kwet wolok koi wɨn Gabata.) ");
INSERT INTO nif_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sandap wolondañgan Juda amalɨ Kamaikamai gwɨlattok nepek gɨtɨk tɨ-jumɨt tɨñɨlɨmbi, kwet boñgɨp taumbi, Pilatolɨ pitit plon pipapi, Juda amatamda e-sasale manda enbi eñguk, “Ale, sɨndok ama wapmañjɨ ñɨn kawɨt!” ");
INSERT INTO nif_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Eumbi, endɨ kɨtɨmbi eñgɨlɨñ, “Nañgɨp ñawɨt! Nañgɨp ñawɨt! Nañgɨp ñambi, kloñbat plon wɨlɨ kɨmbɨn!” Tɨmbi Pilatolɨ enguk, “Nɨtek? Sɨndok ama wapmañjɨ ñakan ñak! Ba nak en kloñbat plon wɨlɨ kɨmnelɨñdok eut ba?” Eumbi, tapma ama biesɨlɨ ñɨndɨñ tambane nɨñgɨlɨñ, “Nimbek no en nɨndok ama wapmañnɨ nɨm, Sisa en noñgan.” ");
INSERT INTO nif_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wolongan Pilatolɨ nandɨ-sembi, Yesu kloñbat plon wɨlɨ kɨmnelɨñdok kɨsɨnan kɨmɨkuk. ");
INSERT INTO nif_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wɨndɨñda mik amalɨ Yesu walinin nañgɨp ñambi, enlok kloñbat mɨum bembɨmbi, kwet no koi Kumba Kwandat, Judalok mandanjɨnan Golgata, wandɨñ nañgɨp ñambi, ");
INSERT INTO nif_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","kloñbat plon wɨkɨlɨñ. Tɨmbi kolan tɨndɨ ama tɨpet wakɨta yandɨpbi, no tombon no tombon, tɨm Yesu en endok boñgɨpsetnan ep samba embi, mambɨ ikɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Tɨmbi Pilatolɨ eu taleumbi, Yesulok kumbam mɨndiñ plon kundit ñɨndɨñ youp kɨmɨkɨlɨñ, “Yesu Nasalet nanin, Juda amalok ama wapmañjɨ.” ");
INSERT INTO nif_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kundit wɨn Juda wakɨt Roma ba Grik endok mandanjɨ plon youp kɨmɨkɨlɨñ, tɨmbi Yesu wɨkɨlɨñ wɨn it kwet ñasɨñgan pakukta tɨmbi Juda ama asupgandɨ manda wɨn kañbi pinakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Tɨmbi Juda amalok tapma ama biesɨlɨ kundit wala kañ nandum tuop nɨm tɨmbɨmbi, Pilato nɨmbi eñgɨlɨñ, “Dɨk ‘Juda amalok ama wapmañjɨ’ wɨndɨñ nɨm yout. Tambo ñɨndɨñ yout, ‘Ama ñalɨ en ‘Nak Juda amalok ama wapmañjɨ’ eñguk.’” Wɨndɨñ eumbi, ");
INSERT INTO nif_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatolɨ tambane enguk, “Ewam youlalɨñ wɨndɨñgan palɨn.” ");
INSERT INTO nif_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tɨmbi mik amalɨ Yesu kloñbat plon wɨt-talembi, endok dasindasin tɨpet tɨpet wɨn ep danbi, molom tuop tuop epgɨlɨñ. Tɨmbi endɨ wɨndɨñgot endok kiupɨn ombap tɨkembi kañgɨlɨñ, wɨn kiupɨ wɨn sandum noñgandɨñgot tɨndɨn, dɨmbo nɨmnat, ");
INSERT INTO nif_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","wala tɨmbi endɨ wala kau kɨndem daumbi, nɨsɨñgan ñɨndɨñ eñgɨlɨñ, “Wɨn wilapnambi kolauk, wala tɨmbi molom nin sɨnɨk wɨn indauktok nɨndɨ tɨmbɨ-indalok sañala tɨna!” Wɨndɨñ embi, tɨmbɨ-inda sañala tɨmbɨmbi, kiupɨ wolok molom indaumbi, manda ñɨndɨñ youyoulɨn patak walɨ bien tɨñguk, “Endɨ nokok dasindasina ep danbi, sandumnala tɨmbi tɨmbɨ-inda sañala tɨñgɨlɨñ.” Wolok tuopgan mik amalɨ tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Tɨmbi Yesulok meñ wakɨt meñlok dalañ, ba Klopas tamɨn koi Malia, tɨmbi Malia Makdala nanin endɨ Yesulok kloñbalɨ kuseinan ikɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tɨmbi Yesulɨ enlok meñ gɨt gwañgwan nin gɨnañlɨ kasɨleñguk wɨn endɨ ñasɨñgan ilɨmbi kañbi, gwañgwa wolok plon meñla ñɨndɨñ nɨñguk, “Tam, ñɨn dɨkok nɨñañga wakan.” ");
INSERT INTO nif_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wɨndɨñ em tambanembi, gwañgwa wala ñɨndɨñ nɨñguk, “Ñɨn dɨkok meñga wakan.” Tɨmbi nain wolonda gwañgwa walɨ Yesulok meñ nañgɨlɨmbi, endok ilnan ñaumbi ka-dɨkñeñguk. ");
INSERT INTO nif_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wolok siñgi kandañ Yesulɨ nandɨñguk, wɨn endɨ kena nek tɨmbektok indañguk wɨn gɨtɨk ip tɨmbɨ taleñguk. Tɨmbi manda enlok plon youyoulɨn patak walɨ bien tɨmbektok endɨ ñɨndɨñ eñguk, “Tukta kɨmlet.” ");
INSERT INTO nif_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tɨmbi kwet kambot nolok gɨnañ wain tuk kimbɨñ wɨlɨmbi, wolok pakuk. Wɨndɨñda ama nolɨ nepek busukñanen tuk tiañelok no tɨkembi, walɨ wain tuk gɨnañ wɨsɨmbi, komba koi hisop wolok bem kusip bañak gɨnañ kɨmɨpi, man plon kɨmɨlɨm loumbi nañguk. ");
INSERT INTO nif_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wain tuk kimbɨñ wɨn nañbi eñguk, “Ip tɨmba talelak.” Wɨndɨñ eñɨpi, kumbam bium gwasei pɨumbi, kuñgun Kunum Yambattok kiinan kɨmɨpi kɨmɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Sandap wolonda Sabat patnandɨ nain wopum indaup tɨmbɨmbi, Juda amatamdɨ wolok tɨ-pañgɨpañgɨle tɨñgɨlɨñ. Tɨmbi Juda ama biesɨlɨ ama kloñbat plon yandɨpmɨum pakɨlɨñ endok pɨñgɨpsɨlɨ Sabat nainnan yousɨm papatta nandum tuop nɨm tɨmbɨmbi, Pilatoloñ ñambi nɨñgɨlɨñ, “Dɨk kɨndem nandɨ-nɨmbi, mik amala enbɨmbi, endɨ endok kesɨsɨ kwandat wɨlɨ gɨlo-semum platikan kɨmbɨmbi, pɨñgɨpsɨ ep pɨmbi, ep ñawɨt.” Wɨndɨñ eumbi, Pilatolɨ mik amala enbɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","endɨ ama tɨpet Yesu gɨt yandɨpgɨlɨñ endoñ ñambi, dama nolok kesi kwandai wɨlɨ gɨloumbi, siñgi nolok wɨndɨñgot tɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tɨmbi Yesuloñ bɨm kañgɨlɨñ, wɨn en ikan kɨmɨñguk. Wɨndɨñ kañbi, endok kesɨi kwandai nɨm wɨlɨ gɨloñguk. ");
INSERT INTO nif_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gan mik ama nolɨ bambau kandañ basamdɨ youlɨ tombɨmbi, wolongan wekat gɨt tuktɨ yalɨmulɨmbi, Yesulɨ biañgan kɨmɨñguk wɨn inda-dakleñguk. ");
INSERT INTO nif_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wɨn sɨndɨ bo nandɨ-kɨlɨktɨ tɨnelɨñdok nepek wɨn dailɨñgan indaum kañguktɨ wolok gembɨn ipi elak. Endok e-dakle mandan walɨ biañgan tɨlak, tɨmbi endɨ manda biañgan elak wɨn ikan nandɨ-talelak. ");
INSERT INTO nif_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nepek nek indañguk walɨ manda youyoulɨn patak walɨ bien tɨmbektok indañguk. Neta, manda nolɨ ñɨndɨñ elak, “Kwandai no nɨm wɨlɨ gɨlolok,” ");
INSERT INTO nif_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","tɨmbi no wɨn ñɨndɨñ, “Endɨ ama youlɨ tomtomɨn enda daut deinekalɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Josep Alimatia nanin endɨ Yesulok gwañgwa no kuñguk, gan Juda ama biesɨla mɨsɨñgukta tɨmbi gitañgitak pat-sembɨñguk. Yesu kɨmɨñgukta endɨ Pilatoloñ ñambi, ñɨndɨñ nɨ-nandɨñguk, “Nak Yesulok dalandan kɨndem tɨke ñawɨt ba?” Eumbi nandɨ-ñɨmumbi, ñam Yesu kloñbat plon nanin bɨndɨpi, tɨke ñañguk. ");
INSERT INTO nif_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tɨmbi Nikodemus damañgan tim nola Yesu ña kañguk endɨ bo bɨñguk. Endɨ gwasap mɨlɨñ kɨndem walan tɨpet 30 kilo ba nɨtek kiukiulɨn wɨn ep bɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ama tɨpet endɨ Yesulok dalandan tɨkembi, Juda amalɨ dalandanjɨlok plon pa tañ telak wɨn klembi, gwasap endok plon kɨmɨpi, sandum satnindɨ tɨmɨp imgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yesu kloñbat plon wɨkɨlɨñ kwet wolok ñasɨñgan gwatnam kena no pakuk, tɨmbi kena wolok gɨnañ sum kawat tombañ gɨtikñin no pakuk, wolok ama dalandan gama no nɨm kɨmɨkɨmɨlɨn. ");
INSERT INTO nif_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Sabat patnandɨ nain wɨn indaup tɨmbɨmbi, sum ñasɨñgan pakukta tɨmbi endɨ Yesulok dalandan wolok tɨke ña kɨmɨpi, sum telak yama masipgɨmɨk. ");
INSERT INTO nif_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Kena nain kusei kɨmɨkɨmɨlɨnan kwet gama nɨm salañɨlɨmbi, Malia Makdala nanin endɨ Yesulok sumnan ñambi kañguk, wɨn kawat sum telak yama masimasipmɨn wɨn tɨke lo tambon kɨmɨlɨm pakuk. ");
INSERT INTO nif_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wɨndɨñ kañbi, woñep ñambi, Simon Petlo gɨt gwañgwa no Yesulɨ gɨnañlɨ tɨke-kasɨlelɨñguk endoñ ñambi enguk, “Wopumdok dalandan sumnan nanin tɨke ñambi, delok kɨmɨlɨm patak wɨn nɨndɨ nɨm nandamɨñ.” ");
INSERT INTO nif_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wolongan Petlo gɨt nol endɨ iset bimbi, sumnan ñandepi ");
INSERT INTO nif_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","yakan woñep ñañgɨmɨk, gan nol walɨ Petlo maklembi, dama sumnan tomguk. ");
INSERT INTO nif_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tombi, telak yama pawan mumuñembi, gɨnañ deium loumbi, sandum Yesulok dalandan tɨmɨtɨmɨlɨn wɨn kañguk, gan gɨnañ nɨm loñguk. ");
INSERT INTO nif_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tɨmbi Simon Petlolɨ siñgi klem bɨ tombi, sum gɨnañ lombi kañguk, wɨn Yesulok kwel kɨnjannan sandumlɨñgot pakuk. ");
INSERT INTO nif_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Sandum no endok kumbam imimɨn walɨ dɨwɨn no gɨt nɨm pakuk. Tambo sandum wɨn engan kwasanembi, giñgiñgan kɨmɨlɨm pakuk. ");
INSERT INTO nif_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tɨmbi gwañgwa dama sumnan tomguk endɨ wɨndɨñgot gɨnañ lombi, nepenepek gɨtɨk wɨn kañbi, Yesu mɨlakuk wɨn nandɨ-kwambɨñ dañguk. ");
INSERT INTO nif_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Nain wolonda endɨ Kunum Yambattok mandanlɨ Mesialɨ kɨmnan nanin mɨlalektok elak wɨn gama nɨm nandɨ-tomgɨlɨñ.) ");
INSERT INTO nif_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tɨmbi gwañgwa tɨpet endɨ isetnan undane ñañgɨmɨk, ");
INSERT INTO nif_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","gan Malia Makdala nanin endɨ sumnan undane bɨ tom papi, pawan ipi, kut-blamblan eñguk. Tɨñɨpi mumuñembi, sum gɨnañ deium loumbi, ");
INSERT INTO nif_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","eñalo tɨpet dasindasinjet satnin wɨn yambɨñguk. Endɨ Yesulok kwel kɨnjannan pipakɨmɨk, nolɨ kumbam kandañ pilɨmbi, nolɨ kesɨi kandañ pipakuk. ");
INSERT INTO nif_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pipapi nɨñgɨmɨk, “Tam, dɨk neta kut-blamblan elañ?” Eumbi enguk, “Nokok Wopumnalok dalandan tɨke ñam, delok kɨmɨlɨm patak wɨn nɨm nandɨlet.” ");
INSERT INTO nif_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wɨndɨñ eñɨpi undanembi, Yesu siñgi kandañ ilɨmbi kañguk, gan endɨ en gama nɨm ka-nandɨ-tomguk. ");
INSERT INTO nif_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tɨmbi Yesulɨ nɨ-kañbi eñguk, “Tam, dɨk neta kut-blamblan elañ? Ba ninda lonjɨlañ?” Nɨ-kaumbi, Malialɨ “Kena kandɨkñe ama kalet” wɨndɨñ nandɨmbi nɨñguk, “Ama wopum. Tɨkap dɨk ñalɨ tɨke ñañañda, nanbɨ nandɨmbi, dɨk kwet delok kɨmɨlañnan ñambi, natna tɨke ñam kɨndit tapliutet.” ");
INSERT INTO nif_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Tɨmbi Yesulɨ Malialok koi kɨtɨumbi, endɨ tɨkɨle ka-nandɨ-tombi, Juda mandanjɨnan “Rabonai” nɨñguk. (Wɨn nɨnɨlok mandanɨnan ‘Nokok nandautna’.) ");
INSERT INTO nif_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Malialɨ Yesula wɨndɨñ kɨtɨmbi, tɨke-kaumbi, Yesulɨ nɨñguk, “Nambɨk bi! Nak gama Bepnaloñ nɨm undane loñgut, wala tɨmbi nombo nɨm nep kawɨñ. Dɨk nokok kwayanailoñ ñambi, ñɨndɨñ enbekañ, ‘Wɨn nokok Betna gɨt sɨndok Bepsɨ, nokok Yambatna gɨt sɨndok Yambatsɨ, nak endoñ undane loupi tɨlet.’” ");
INSERT INTO nif_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Tɨmbi Malia Makdala nanin endɨ Yesulok gwañgwañiiloñ ña tombi enguk, “Nak Wopum ip kat” embi, Yesulɨ manda nɨñguk wɨn wakan kasat tɨ-semumbi nandɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kena nain kusei kɨmɨkɨmɨlɨnan sandap wolonda kwet kɨlɨm eumbi, Yesulok gwañgwañiilɨ kɨmɨn tɨ-pakɨlɨñ. Endɨ Juda ama biesɨla mɨsɨñgɨlɨñda tɨmbi it yama kekak tɨ sip kwambɨñ da-talembi pakɨlɨñ. Palɨñɨlɨmbi, Yesu en boñgɨpsɨnan indam ipi enguk, “Busuk pat-samun.” ");
INSERT INTO nif_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wɨndɨñ e-talembi, enlok kii bim tɨpet wakɨt bambau gilɨn daut semumbi, endɨ Wopum en wakan wɨn ka-nandɨ-tom sɨnɨk tambi, sɨlɨsɨlɨlɨ tokñe-semguk. ");
INSERT INTO nif_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Tɨmbi Yesulɨ bɨndambo enguk, “Busuk pat-samun. Beptɨ nak nanɨ-mukuk, wɨndɨñgangot nak bo sɨndɨ sanɨ-mutet.” ");
INSERT INTO nif_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Wɨndɨñ e-talembi, man woñlɨ ep pendɨpi enguk, “Sɨndok gɨnañjɨ gɨnañ Dɨndɨm Woñ kasɨlewɨt! Kasɨle-talemek, ");
INSERT INTO nif_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Woñ walɨ daut samlak, wɨn Kunum Yambattɨ ama nolok yomɨn biñmɨñguk ba nɨm, tɨmbi wolok tuop sɨndɨ amatamda kɨndem ñɨndɨñ enɨ-dakle-semnekalɨñ, ‘Yomjɨlok mɨlap wɨn wiat-taletalen,’ ba ‘Yomjɨlok mɨlap wɨn kɨmɨlɨm pat-samlak.’” ");
INSERT INTO nif_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yesulɨ inda-semguk wolonda endok gwañgwañii 12 endoñnan nanin no koi Tomas (koi no Didimus) endɨ nolii gɨt nɨm pakuk. ");
INSERT INTO nif_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nɨm pakukta, endok noliilɨ ñɨndɨñ nɨñgɨlɨñ, “Nɨndɨ Wopum kañgɨmɨñ!” Gan endɨ enguk, “Tɨkap nak dautnalɨ biliñdok gil endok kii bim plon nɨm kautat, tɨmbi kɨtna nɨñañlɨ kii bim wandan gɨnañnan nɨm suaeutat, tɨmbi bambau wanda wɨn nɨm tɨke-kautatta, sɨndɨ nek eañ wɨn nak nɨm sɨnɨk nandɨ-kwambɨñ dautat.” ");
INSERT INTO nif_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sande noñgan taleumbi, gwañgwalɨ bɨndambo it gɨnañnan kɨmɨn tɨmbɨmbi, Tomaslɨ en gɨta yakan pakɨlɨñ. Endɨ yama kekak tɨ sip kwambɨñ da-talembi pakɨlɨñ, ganmek Yesulɨ bɨndambo boñgɨpsɨnan bɨ indam ipi enguk, “Busuk pat-samun.” ");
INSERT INTO nif_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Wɨndɨñ eñɨpi, Tomasla kii bim daulɨmɨmbi nɨñguk, “Kɨka nɨñañ kɨtna gil plon kɨmɨpi, kɨtna ka! Tɨmbi kɨka kot suapi, nokok bambatna tɨke-nandɨ! Dɨk nandɨ-bendɨ nombo nɨm tɨmbekañ, tambo nak kaik patet wɨn nandɨ-kwambɨñ daukañ!” ");
INSERT INTO nif_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Eumbi tambane nɨñguk, “Dɨk nokok Wopumna gɨt Yambatna.” ");
INSERT INTO nif_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Eumbi, Yesulɨ nɨñguk, “Ba dɨk nambɨlañda tɨmbi nandɨ-kɨlɨktɨ tɨ-namlañ ba? Nin endɨ nɨm nambañ, gan wandingan embi nandɨ-kɨlɨktɨ tɨ-namañ, endɨ Bepnalok dainan amatam dɨwɨn yapma kle pakañ.” ");
INSERT INTO nif_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesulɨ gwañgwañiilok dausɨnan jimba kundit dɨwɨn asupgan tɨñguk, gan wɨn pepa ñolok gɨnañnan nɨm youyoulɨn patak. ");
INSERT INTO nif_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gan kundit youyoulɨn patak walɨ kusei ñɨndɨñda youyoulɨn: sɨndɨ manda ñɨn pinat nandɨ tɨmbi, Yesu en Mesia, Kunum Yambattok Nɨñañ, wɨn nandɨ-kwambɨñ danekalɨñ, tɨmbi nandɨ-kwambɨñ dañɨpi, endok gɨñgɨtñii kuañda tɨmbi kuñgu sɨsɨnɨk wɨn kasɨlenekalɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Yesulɨ gwañgwañiiloñ dama Jelusalem inda-semguk, wolok siñgi kandañ endɨ bɨndambo Galili kwelan tuk guañ koi Taibelias wolok inda-semguk. Wɨn ñɨndɨñ: ");
INSERT INTO nif_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petlo, Tomas (endok koi no Didimus) gɨt Natanael Kana it kwet Galili kwelan nanin, wakɨt Sebedilok nɨñañiit tɨpet ba Yesulok gwañgwañiit tɨpet no yakan kɨmɨn tɨ-pakɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Palɨñɨlɨmbi, Simon Petlolɨ noliila enguk, “Nak mɨkbalak lolonjɨla ñautet.” Eumbi nɨñgɨlɨñ, “Nɨndɨ dɨkɨta yakan ñanetamɨñ.” Wɨndɨñ embi, walinin pɨm ñambi, kɨkeñ plon lom ñambi, mɨkbalak lɨk tiatia kena tɨñgɨlɨñ, gan tim ombap wolonda mɨkbalak no nɨm epgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kwet salaup tɨmbɨmbi, gwañgwañiilɨ Yesu kɨnanjatnan palɨmbi kañgɨlɨñ, gan endɨ en Yesu wɨn nɨm ka-nandɨ-tomgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Tɨmbi Yesulɨ kɨtɨ-sembi enguk, “Notnai! Ba sɨndɨ mɨkbalak no nɨm epmɨlɨñ ba?” Eumbi, “Nɨm epmamɨñ” wɨndɨñ nɨmbɨmbi, ");
INSERT INTO nif_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","endɨ enguk, “Ale. Lɨksɨ kɨkeñ kɨt dɨndɨm kandañ kolɨ pɨumbi epnetañ.” Eumbi, endɨ bɨndambo lɨk wɨn kolɨ pɨumbi, mɨkbalak asup epgɨlɨñda tɨmbi lɨk wɨn tiañeum kɨkeñ plon lambɨlambɨlok tuop nɨm. ");
INSERT INTO nif_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wolongan Yesulɨ gwañgwa gɨnañlɨ tɨke-kasɨleañguk endɨ Petlola ñɨndɨñ nɨñguk, “Wɨn Wopum engan!” Simon Petlolɨ manda “Wopum” wɨndɨñ nandɨmbi, dasindasin kiundɨp biñguk wɨn tɨke dasimbi, Yesuloñ ñaupi, tuk guañ gɨnañ dɨkokuk. ");
INSERT INTO nif_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Tɨmbi gwañgwa dɨwɨndɨ Petlo kɨkeñ plon klembi, mɨkbalak lɨk tokñetokñen wɨn tiañembi, kɨnanjatnan bɨ tomgɨlɨñ. Kwet wɨn mayañgan sɨnɨk nɨm, 100 mita ba nɨtek wolok tuop. ");
INSERT INTO nif_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kɨnanjatnan pɨmbi, komba dɨ-papal kañgɨlɨñ, tɨmbi komba galk plon mɨkbalak wakɨt plaua nanañ dɨwɨn palɨmbi kañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Tɨmbi Yesulɨ enguk, “Mɨkbalak kombɨkan epmɨlɨñ dɨwɨn ep bɨwɨt!” ");
INSERT INTO nif_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Eumbi, Simon Petlolɨ kɨkeñ plon lombi, mɨkbalak lɨk tiañeumbi, tuk pawan kɨnanjatnan lambɨñguk. Mɨkbalak wopum sɨnɨk 153 gɨtɨk walɨ pɨ lɨk tɨmbɨ tokñeñgɨlɨñ, ganmek lɨk walɨ nɨm blañganeñguk. ");
INSERT INTO nif_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Tɨmbi Yesulɨ bɨm, nanañ nanelɨñdok enguk. Gwañgwañiilɨ en Wopum wɨn ip nandɨñmɨñgɨlɨñda tɨmbi, endɨ gɨtɨk walɨ “Dɨk nin?” wɨndɨñ nɨ-nandɨnep mɨsɨñgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Tɨmbi Yesulɨ bɨmbi, plaua wakɨt mɨkbalak epbi, emumbi nañgɨlɨñ. ");
INSERT INTO nif_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesulɨ kɨmnan nanin mɨlakuk wolok siñgi kandañ endɨ gwañgwañiiloñ wɨndɨñ inda-semumbi, nain tɨpet gɨt no tɨñguk. ");
INSERT INTO nif_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nanañ nanbɨ taleumbi, Yesulɨ Simon Petlo nɨ-nandɨmbi eñguk, “Simon Yoanelok nɨñañ, dɨk nokok gwañgwanai dɨwɨn ñɨn yapma klembi, gɨnañgalɨ nak nep kasɨle-sɨnɨk talañ ba?” Eumbi nɨñguk, “Tɨmbi, Wopum, nak gɨnañnalɨ dɨk gep kasɨlelet wɨn dɨk ip nandɨlañ.” Wɨndɨñ eumbi, Yesulɨ enlok gɨñgɨtñiilok plon Petlola ñɨndɨñ nɨñguk, “Nokok sipsip nɨñanai ep towi tɨ-ta-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tɨmbi bɨndambo nɨ-nandumbi, nain tɨpet tɨñguk, “Simon Yoanelok nɨñañ, dɨk gɨnañgalɨ nak nep kasɨle-sɨnɨk talañ ba?” Eumbi nɨñguk, “Tɨmbi, Wopum, nak gɨnañnalɨ dɨk gep kasɨlelet wɨn dɨk ip nandɨlañ.” Wɨndɨñ eumbi nɨñguk, “Nokok sipsipnai yambɨ-dɨkñe tɨ-ta-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Tɨmbi bɨndambo nɨ-nandumbi, nain tɨpet gɨt no tɨñguk, “Simon Yoanelok nɨñañ, dɨk gɨnañgalɨ nak nep kasɨlelañ ba?” Yesulɨ “Dɨk gɨnañgalɨ nak nep kasɨlelañ ba?” wɨndɨñ eumbi, nain tɨpet gɨt no tɨñgukta tɨmbi, Petlolɨ gɨnañ kolaumbi nɨñguk, “Wopum, dɨk nepek gɨtɨk ip nandɨ-talembi, nak gɨnañnalɨ dɨk gep kasɨlelet wɨn nambɨ-nandɨlañ.” Eumbi, Yesulɨ nɨñguk, “Nokok sipsipnai ep towi tɨ-ta-kuukañ. ");
INSERT INTO nif_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Wɨn biañgan tɨmbekañ. Tɨmbi nak ñɨndɨñ ganba nandɨ. Dɨk sim plon papi, dɨtnañgan bɨñgwɨlap tembi, delok ñaupi nandɨlɨñguñ wolok tuopkan samasamakgan ñalɨñguñ, gan dɨk gɨlɨk tɨmbekañ nain wolonda dɨk kɨka tɨke-loumbi, nimbek nolɨ gep topmbi, kwet nɨm ñañalok nandɨ-galk talañnan ganañgɨlɨmbi ñaukañ.” ");
INSERT INTO nif_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesulɨ wɨndɨñ embi, Petlolɨ Kunum Yambattok koi gɨñgɨt mɨuktok telak nɨtek plon kɨmbekak wɨn tɨmbɨ inda-dakleñguk.) Tɨmbi yousɨmbi, ñɨndɨñ nɨñguk, “Dɨk nak nep kle-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tɨmbi Petlolɨ tambanem kañguk, wɨn Yesulɨ gwañgwa nin gɨnañlɨ tɨke-kasɨleñguk endɨ ep klem bɨñguk. (Endɨ gwɨlattok nanañ yakan na-pakɨlɨñ, wolonda gwañgwa walɨ wakan Yesulok plon panjañganembi nɨ-nandɨmbi eñguk, “Wopum, wɨn nindɨ sɨnɨk dɨk kanjɨkkailok kɨsɨnan gapɨlekak?”) ");
INSERT INTO nif_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petlolɨ gwañgwa wɨn kañbi, Yesu nɨ-nandɨmbi eñguk, “Wopum, ama ñolok kandañ nɨtek indañmekak?” ");
INSERT INTO nif_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Eumbi nɨñguk, “Tɨkap nak undanem bɨ tombetat, endɨ wolok tuop yousɨmbi kuuktok nandɨñmetta, walɨ dɨkok nepek nɨm. Dɨkta nak nep kle-kuukañ.” ");
INSERT INTO nif_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Tɨmbi manda walɨ Yesu kɨmɨt-kle-kuañgɨlɨñ endok boñgɨpsɨnan sapakñeumbi, ama walɨ nɨm kɨmbekak wɨndɨñ nandɨñgɨlɨñ. Gan Yesulɨ Petlola ñɨndɨñ nɨm nɨmbi eñguk, “Gwañgwa walɨ nɨm kɨmbekak.” Tambo endɨ ñɨndɨñgot eñguk, “Tɨkap nak undanem bɨ tombetat, endɨ wolok tuop yousɨmbi kuuktok nandɨñmetta, walɨ dɨkok nepek nɨm.” ");
INSERT INTO nif_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Gwañgwa walɨ wakan nepek gɨtɨk wolok gembɨn ipi, ñolok yout-talelak. Tɨmbi nɨndɨ mandan youkuk wala nandɨna biañgan sɨnɨk tɨlak. ");
INSERT INTO nif_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesulɨ kundit kusei kusei asup dɨwɨn no wakɨt tɨñguk. Tɨmbi nak ñɨndɨñ nandɨlet: nɨndɨ kundit gɨtɨñgɨtɨk wɨn youtnamda, pepa asup sɨnɨk indaumbi, nɨndɨ kwet tuop tuop pepa gɨtɨk wɨn kɨmɨtneñdok kwet lonjɨneñ. ");
ALTER TABLE nif_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
