﻿USE sofia;
DROP TABLE IF EXISTS sofia.nhyNT_vpl;
CREATE TABLE nhyNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nhyNT_vpl WRITE;
INSERT INTO nhyNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yinmej yejwan katlej oyajkej ya wejkawitl iweyitajwan in Jesucristo, katlej walajtok nelwatl de David, iwan noijki walajtok nelwatl de Abraham. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham oyáj tepapan de Isaac. Isaac oyáj tepapan de Jacob. Jacob oyáj tepapan de Judá iwan oksekimej ikniwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá iwan isiwa Tamar okinpixkej inpilwan katlej intoka Fares iwan Zara. Iwan Fares oyáj tepapan de Esrom. Esrom oyáj tepapan de Aram. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram oyáj tepapan de Aminadab. Aminadab oyáj tepapan de Naasón. Naasón oyáj tepapan de Salmón. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón iwan isiwa Rahab okipixkej inkone itoka Booz. Booz iwan isiwa Rut okipixkej inkone itoka Obed. Obed oyáj tepapan de Isaí. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iwan Isaí oyáj tepapan de yen rey David. In rey David oyáj tepapan de Salomón. Imaman in Salomón yen katlej oyeka isiwa in Urías. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón oyáj tepapan de Roboam. Roboam oyáj tepapan de Abías. Abías oyáj tepapan de Asa. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa oyáj tepapan de Josafat. Josafat oyáj tepapan de Joram. Joram oyáj tepapan de Uzías. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías oyáj tepapan de Jotam. Jotam oyáj tepapan de Acaz. Acaz oyáj tepapan de Ezequías. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías oyáj tepapan de Manasés. Manasés oyáj tepapan de Amón. Amón oyáj tepapan de Josías. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías oyáj tepapan de Jeconías iwan noijki okinpixke oksekimej ipilwan, itech nekatej tonaltin nijkuak in judiojtin okinwikakej presojtin para itech país de Babilonia. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ompa itech país de Babilonia, Jeconías okipixke se ikone itoka Salatiel. Salatiel oyáj tepapan de Zorobabel. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel oyáj tepapan de Abiud. Abiud oyáj tepapan de Eliaquim. Eliaquim oyáj tepapan de Azor. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor oyáj tepapan de Sadoc. Sadoc oyáj tepapan de Aquim. Aquim oyáj tepapan de Eliud. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud oyáj tepapan de Eleazar. Eleazar oyáj tepapan de Matán. Matán oyáj tepapan de Jacob. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob oyáj tepapan de José. Yon José yen katlej oyeka iokich in María. Iwan yon María okitlakatilij in Jesús katlej tikixmatij yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Opanokej majtlaktle iwan nawi tetajmej desde Abraham asta David. Noijki opanokej majtlaktle iwan nawi tetajmej desde David asta ijkuak okinwikakej itech país de Babilonia. Iwan noijki opanokej majtlaktle iwan nawi tetajmej desde ijkuak okinwikakej itech país de Babilonia asta ijkuak otlakatiko in Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijkín nik otlakatke in Jesucristo. María yokichixtoka ma ajsi tonale para monamiktis iwan José. Pero antes de mosetiliskej, María okiwalmachilij ya kipia ikone ijtik itlalax ika ipoder in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iwan José, katlej yoyeka para monamiktis iwan María, yej oyeka kuale tlakatl, iwan mach okinekke kipijpinatis in María. Por yonik okiyejyekoj kikawas ichtaka. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nijkuak ijkón okiyejyekoj kichiwas, owalaj se ángel katlej okualtitlanke in Señor. Yon ángel okimonextilij itech ikochteemikilis in José, iwan okilwij: ―José, tekone de David, amo ximomawti timosetilis iwan María para yetos mosiwa. Porke por yen ipoder in Espíritu Santo okichij ma kipia yon konetl. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María kipias ikone, iwan tiktokayotis JESÚS, porke Yej kimakixtis ipueblo de itlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nochi in yin otlapanok para ma mochiwa tlan okijtoj in toSeñor por medio de yen profeta Isaías: ");
INSERT INTO nhyNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","In ichpochtle kipias se ikone, iwan ikone yetos itoka Emanuel, Emanuel kijtosneki: Dios towan kajki. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nijkuak José oijsak, okichij ijkón ken okilwij iángel in Señor, iwan omonamiktij iwan María. ");
INSERT INTO nhyNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero in José mach semi okochke iwan María asta ijkuak otlakatke ikone, iwan José okitokayotij in konetl Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús otlakatke itech pueblo de Belén, itech estado de Judea, iwan nijkuak Herodes oyeka rey. Ijkuakón owalajkej ik ikisayan tonale sekimej ixtlamatkej de sitlaltin iwan oejkokej itech weyikan de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tlajtlantiwitzej: ―¿Kanin kajki in konetl katlej otlakatke para yetos Rey de yen judiojtin? Porke isitlal otikitakej desde ik ikisayan tonale, iwan otiwalajkej otikweyikixtikoj. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","In rey Herodes okimakak tlapololistle nijkuak ijkón okikakke, iwan nochtin tlakaj de Jerusalén noijki okinmakak tlapololistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes okinnotzke nochtin tlayekankej tiopixkej iwan noijki in tlamachtijkej de itlanawatil in Moisés. Iwan okintlajtlanij kanin tlakatis in Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iwan yejwan okilwijkej: ―Tlakatis itech pueblo de Belén itech estado de Judea. Porke ijkón okijkuiloj in profeta: ");
INSERT INTO nhyNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Tej, Belén, katlej tikaj itech tlale de Judea, maski titzikitzin, tej okachi tiweyikistok (tiweyititok). Porke motech kisas se tlayekanke, katlej kinyekanas nopilwan judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ijkuakón Herodes okinnotzke ichtaka in ixtlamatkej de sitlaltin, iwan okintlajtlanij itech tlan tonale meroj omonextij in sitlale. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Satepan okintitlanke itech pueblo de Belén, iwan okinmilwij: ―Ompa xiwian, iwan kuale xitlajtlanikan de yon konetl. Iwan nijkuak ankajsiskej, annechilwiskej, para nej noijki nias nikweyikixtiti. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nijkuak otlanke okintlapowij in rey, yejwan oyajkej. Iwan sitlale katlej okitakej ik ikisayan in tonale, okinyekanaya asta ijkuak oajsitoj Belén, iwan sitlale omoketzato kan oyeka in konetl. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iwan nijkuak okitakej in sitlale sa tekitl opakej. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Satepan okalakej kalijtik, iwan okitakej in konetl iwan María katlej imaman. Omotlankuaketzkej iwan okiweyikixtijkej. Okintlapojkej inkajajwan iwan okitlatliokolijkej ika oro, ika kopale, iwan ika ajwiakayotl katlej itoka mirra. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Satepan, itech inkochteemikilis, Dios okinmilwij mach ok ma wian inawak Herodes. Tonses, oyajkej para inchan itech oksé ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nijkuak oyajkej in ixtlamatkej de sitlaltin, ijkuakón, owalaj se ángel de toSeñor iwan okimonextilij itech ikochteemikilis in José. Okilwij: ―Ximewa, iwan xikwika in konetl iwan imaman asta itech país de Egipto. Ompa ximokawakan asta ijkuak Nej nimitznawatis xikisakan. Porke Herodes kitemos in konetl para kimiktis. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iwan niman yon yuak nijkuak oijsak in José, okiwikak in konetl iwan imaman para Egipto. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Iwan ompa omokajkej asta ijkuak omikke in Herodes. Ijkón otlapanok para ma mochiwa tlan okijtoj in toSeñor por medio de yen profeta nijkuak okijtoj: “Oniknotzke in noKone ma kisa de Egipto.” ");
INSERT INTO nhyNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nijkuak in Herodes okimomakak kuenta nik okikajkayajkej in nekatej ixtlamatkej de sitlaltin, sa tekitl okualanke, iwan otlanawatij ma kinmiktikan nochtin in chochokotzitzintin de ome xiwitl para ik tlani katlej chantij itech pueblo de Belén, iwan nochtin in pueblojtin katlej katej ik ompa. Porke in ixtlamatkej de sitlaltin okilwijkaj in Herodes nik ya kipia kej ome xiwitl nijkuak yakinika okinmonextilij in yon sitlale. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijkón otlamochij ken okijtoj in profeta Jeremías: ");
INSERT INTO nhyNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Itech pueblo de Ramá mokaki tzajtzilistle de tekokojkayotl, iwan chokilistle de neyolkokole. Yen Raquel kinchokilia ipilwan, iwan mach kineki moyolosewis, porke yokinmiktilijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Iwan nijkuak omikke in Herodes, se ángel de toSeñor okimonextilij in José itech ikochteemikilis ompa Egipto. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Okilwij: ―Ximewa, iwan ximokuepa xikwika in konetl iwan imaman para mopaís de Israel. Porke yomikkej katlej okinekiaj kimiktianij in konetl. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ijkuakón José omejke iwan omokuepke iwan konetl iwan imaman para itech país de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero nijkuak José okimatke nik itech estado de Judea, mach ok yen Herodes oyeka rey sino yen itelpoch katlej itoka Arquelao, tonses omomawtij yas ompa. ToTajtzin Dios okilwij in José itech ikochteemikilis, ma wia itech estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tonses, oyáj itech yon estado iwan omochantij itech se pueblo itoka Nazaret. Ijkón otlapanok ken okijtojkej in profetajtin, nik in Cristo kitokayotiskej nazareno. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Itech nekatej tonaltin in Juan Tlakuateekij owalaj kan tlawaki de estado de Judea, iwan okinmachtij in tlakaj katlej owalajkej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Okinmilwiaya: ―Ximoyolkuepakan inawak toTajtzin Dios, porke yoajsiko in tonale para Dios tlanawatis amonawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yen yin Juan de akin otlajtoj in profeta Isaías, nijkuak okijtoj: Se tlajtole mokaki tetzajtzilia kan tlawaki, iwan kijta: “Xikyektlalikan iwan xikmelawakan iojwi in Señor.” ");
INSERT INTO nhyNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Itzotzol in Juan oyeka de itzojmio kameyo iwan omotlajkoilpiaya ika se kuetlaxtle. Okinkuaya chapulimej (xolinmej) iwan okikuaya nektle. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Miekej tlakaj owalayaj inawak Juan, owalayaj de weyikan de Jerusalén, de nochi in estado de Judea iwan de nochtin in tlalmej katlej katej ik weyatl Jordán. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nijkuak omoyolkuitiayaj de intlajtlakol, in Juan okinkuateekiaya ijtik in weyatl Jordán. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Iwan nijkuak in Juan okinmitak miekej fariseos iwan saduceos owalayaj inawak para mokuateekiskej, okinmilwij: ―¡Namejwan kej ankoamej! ¿Akin oamechilwij ke tla anmokuateekiskej welis ancholoskej de itech ikualanilis in Dios katlej amopan witz? ");
INSERT INTO nhyNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xikchiwakan tlan kuale para ma mota nik ya anmoyolkuepkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Iwan amo xikmolwikan ke ankatej kuale porke antepilwan de Abraham. Ipan melajka namechilwia, ke asta yinmej temej in Dios welis kinkuepas ipilwan in Abraham. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Namejwan ankatej ken tlatokkuanmej katlej mach tlakij. Nochtin in tlatokkuanmej katlej mach tlakij motzontekiskej iwan kintlamotlaskej ijtik tlitl. In acha sa mochixtok para kintzontekis asta itech innelwayo in tlatokkuanmej katlej mach tlakij. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nej melawak namechkuateekia ika atl kej se señas nik melawak anmoyolkuepkej. Pero satepan de nej witz oksé katlej okachi nechpanawilia, porke okachi weyikistok (weyititok) iwan amo ken nej, iwan mach notech powi nion para nikkakkixtis. Yej amechkuateekis ika Espíritu Santo iwan ika tlitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yej ejkos kej se tlakatl katlej pewas kichipawas in trigo. Iwan trigo katlej ya chipawak kitlaatis ijtik kueskomatl, pero itlajsolo kitlamotlas ijtik tlitl katlej mach keman sewis. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús okiske de estado de Galilea iwan oejkok itech weyatl Jordán kan oyeka in Juan Tlakuateekij, ompa owalaj para ma kikuateeki in Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero in Juan mach okinekia kikuateekis. Okijtoj: ―Moneki yen tejwatzin xinechkuateeki. ¿Sejpa yej tejwatzin tikneki ma nimitzkuateeki? ");
INSERT INTO nhyNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús okinankilij: ―Axan ijkón moneki tikchiwaskej, porke in Dios ijkón kineki ma tikchiwakan nochi tlan kuale. Juan mach ok itlaj okijtoj iwan okikuateekij in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nijkuak Jesús omokuateekij iwan nijkuak owalmej de ijtik atl, in ilwikak otlapowik iwan okitak in Espíritu Santo owaltemok ipan Jesús kej se paloma. ");
INSERT INTO nhyNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iwan omokakke se tlajtole de ilwikak. Okijtoj: ―Yen yin notlasojKone, katlej inawak nipaki. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Satepan, in Espíritu Santo okiwikak in Jesús kan tlawaki kan diablo okinekia kitlajtlakolmayawini in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Okixikoj mach otlakuaj omenpoale tonale iwan omenpoale yuale, iwan satepan otiojsij. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ijkuakón, in tetlajtlakolmayaj owalaj inawak Jesús para kitlajtlakolmayawis, iwan okilwij: ―Tla melawak Tej titeKone de Dios, xikchiwa ma mokuepa pan in yinmej temej. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesús okinankilij: ―In tiotlajkuilole kijta: “In tlakatl mach welis yolitos san ika tlakuale, sino noijki ika nochi tlajtole katlej Dios kijta.” ");
INSERT INTO nhyNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Satepan, in diablo okiwikak in Jesús itech iweyikan in toTajtzin Dios, yen weyikan de Jerusalén, iwan okitlejkoltij ipan weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Iwan okilwij: ―Tla melawak Tej titeKone de Dios, ximotlamotla asta ipan tlale. Porke in tiotlajkuilole kijta: Dios kinwaltitlanis iangelwan ma mitzpalewikan. Mitzajkokuiskej ika inma, para amo tikmomagati itlaj tetl itech mokxi. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús okilwij: ―Noijki in tiotlajkuilole kijta: “Amo xikyejyeko in Señor moDios para tikitas tlanon kichiwas.” ");
INSERT INTO nhyNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satepan, in diablo okiwikak in Jesús ipan se tepetl wejkapan, iwan okinmititij nochtin paismej de ixko yin tlaltikpak, iwan nochi tlan kipiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Iwan okilwij: ―Nochi in yin nimitzmakas, tla timotlankuaketzas iwan tinechweyikixtis. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tonses, Jesús okinankilij: ―Xitzinkisa, Satanás, porke in tiotlajkuilole kijta: “Xikweyikixti in Señor moDios, iwan sanwel Yej xiktekipano.” ");
INSERT INTO nhyNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ijkuakón in diablo okikajtej in Jesús, iwan owalajkej sekimej angelestin iwan okimonekuitlawijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nijkuak Jesús okimatke nik in Juan Tlakuateekij okitzakej telpiloyan, ijkuakón Yej okiske de estado de Judea iwan oyáj itech estado de Galilea itech ipueblo Nazaret. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero mach omokaj itech ipueblo Nazaret, sino yej oyáj ochantito itech oksé pueblo itoka Capernaum, katlej kajki itempan lago, iwan kajki itech región de Zabulón iwan de Neftalí. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ijkón otlapanok para ma mochiwa tlan okijkuiloj in profeta Isaías: ");
INSERT INTO nhyNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Tlale de Zabulón iwan tlale de Neftalí, ojtle katlej panotok itempan lago, ik ne lado de yen weyatl Jordán, tlale de Galilea kan chantij katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nochtin yonmej tlakaj katlej oyekaj ijtik tlatleyualotl okitakej se weyi tlanextle. Opetlanke in tlanextle para katlej oyekaj itech iekawilo in mikilistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde ijkuakón in Jesús opéj tetlapowia, iwan okijtoaya: ―Ximoyolpejpenakan (ximoyolkuepakan) de amotlajtlakol, porke yoajsiko in tonale para tlanawatis in Dios amonawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús onejnentiaya itempan lago de Galilea. Okinmitak omen iknimej: Se itoka Simón, noijki kinotzaj Pedro, iwan oksé itoka Andrés. Okintlamotlatokaj inmichmatlawan ijtik atl, porke yejwan oyekaj michmajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús okinmilwij: ―Namejwan anmichmajkej. Pero axan xiwikikan nowan, para ankintlapowiskej in tlakaj de notlajtol para ma momakixtikan kej yeskia ankinkitzkiskej michimej. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","San niman okinkajtejkej inmichmatlawan iwan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ok achitzin tlayakapan, Jesús okinmitak ok omen iknimej: Se itoka Santiago iwan oksé itoka Juan, itelpokawan in Zebedeo, katlej oyekaj iwan intaj itech se barko okintilichojtokaj inmichmatlawan. Iwan Jesús okinnotzke. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yejwan san niman okajtejkej inbarko iwan intaj, iwan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús onemia itech nochi in estado de Galilea, otlamachtiaya itech intiopanwan in judiojtin. Otetlapowiaya de yen kuale tlajtole katlej temakixtia de kenik in Dios tlanawatia. Iwan okinpajtiaya in tlakaj de nochi kokolistle iwan de nochi kualolistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Otlapoayaj de Jesús asta ik nowian (nian nepa) país de Siria. Iwan tlakaj okinwalwikiliayaj nochtin katlej okipiayaj nochi tlamantle de kualolistle iwan de kokolistle, katlej okipiayaj mach kuale ejekatl, katlej mimikij, iwan katlej wilanmej (temetlamej). Iwan Jesús okinpajtij nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Oyayaj iwan Jesús miekej tlakaj de estado de Galilea iwan de se región kan oyekaj majtlaktle pueblojtin katlej okitokayotiayaj Decápolis. Noijki oyayaj miekej de weyikan de Jerusalén, de estado de Judea, iwan de ik ne lado de yen weyatl Jordán. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nijkuak in Jesús okinmitak miekej tlakaj, otlejkok ipan se tepetl, iwan ompa omotlalij. Imomachtijkawan omijkuanijkej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iwan Yej opéj kinmachtia ijkín: ");
INSERT INTO nhyNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Ma pakikan katlej momachiliaj pobrestin ipan inyolo, porke yejwan kipiaj parte itech ilwikak kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Ma pakikan katlej chokaj, porke yejwan moyolosewiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Ma pakikan katlej mach moweyinekij, porke yejwan kimoaxkatiskej in tlale katlej Dios okinkakitij kinmakas. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Ma pakikan katlej melawak kinekij yeskej yolchipawakej, ken nijkuak akaj tiojsiwi iwan amiki. Porke yejwan ixwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Ma pakikan katlej teiknomatij, porke Dios noijki kinmiknomatis. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Ma pakikan katlej yolchipawakej, porke yejwan kitaskej in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Ma pakikan katlej kichiwaj ma yeto yolosewilistle, porke Dios kinnotzas kej ikonewan. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Ma pakikan katlej kintlatlalochtiaj por kichiwaj tlan Dios kineki, porke yejwan kipiaskej parte itech ilwikak kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Xipakikan namejwan nijkuak in tlakaj amechwikaltiskej, nijkuak amechtlatlalochtiskej, iwan nijkuak amechtlajtoltlatlaliliskej por annechneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xipakikan, porke namejwan ankiresibiroskej se weyi tlaxtlawile ompa ilwikak. Xikelnamikikan nik in ya wejkawitl profetajtin noijki okintlatlalochtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Namejwan ankatej ken istatl ixko yin tlaltikpak. Pero tla in istatl kipolos ipuyeka, ¿kenik oksemi puyeyas? Mach ok kuale, sa se kitlamotla ipan ojtle iwan in tlakaj sa ipan tlajtlaksaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Namejwan ankatej ken tlanextle ixko yin tlaltikpak, ken se weyikan katlej kajki ipan se tepetl iwan mach weli motlaatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nion amakaj kitlikuitia se tlanextle para se kitlaatis itlampa se chikiwitl. Sino se kitlalia ajkopan para ma kintlawili nochtin katlej katej kalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Namejwan no ijkón, ma tlawi namotlanex inmixpan nochtin in tlakaj, para ma kitakan tlan kuale ankichiwaj, iwan ijkón ma kiweyikixtikan namoPapan Dios katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Amo xikyejyekokan ke oniwalaj onikpojpoloko itlanawatil in Moisés o noso tlan okijkuilojkej in profetajtin. Mach oniwalaj para nikpojpolos, sino oniwalaj para nikchiwas nochi tlan kijta. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pero ipan melajka namechilwia, mientras yetos in ilwikak iwan tlaltikpak, mach poliwis nion se letra, iwan nion se punto katlej ijkuilitok itech itlanawatil in Moisés, asta ma mochiwa nochi tlan omijkuiloj. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por yonik, tla akaj amo kichiwas kuenta kanaj se tlanawatile de Moisés, maski wel tzikitzin ma yeto, iwan tla akaj tlamachtis amo ma kichiwakan kuenta in yon tlanawatile, yon tlakatl sa tekitl tzikitzin yetos ompa ilwikak kan Dios tlanawatia. Pero tla akaj kichiwas iwan tlamachtis tlan kijta in yon tlanawatile, yetos sa tekitl weyi ompa ilwikak kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Por yonik namechilwia nik mach ankalakiskej ompa ilwikak kan Dios tlanawatia, in tla amo ankichiwaskej tlan kuale ixpan Dios okachi ke tlan kichiwaj in tlamachtijkej de itech itlanawatil in Moisés iwan fariseos. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Namejwan ya ankikakej ke ya wejkawitl okinmilwijkej namoweyitajwan: “Amo xitemikti, porke akin temiktis kipia de kitemaktiskej (kitemaktiliskej) innawak tekiwajkej para kitlajtlakoltiskej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero Nej namechilwia, ke tla akaj kualanis inawak ikni, kipia de wetziti kan tlaixkomakaj (tlatzonmanaj) para kitlajtlakoltiskej. Iwan akin kilwis in ikni tonto, kipia de kixkomakaskej itech se junta para kitlajtlakoltiskej. Iwan akin kiwikaltis in ikni, yetos tlajtlakolej iwan welis yas ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Por yonik, tla ijkuak ya tikitki moofrenda kan kajki in artal iwan ijkuakón tikwalelnamiki nik in mokni mitzkualanijtok, ");
INSERT INTO nhyNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","okachi kuale xikajtewa moofrenda ompa itech artal, iwan xiwia ximotlapojpolwiti iwan mokni. Iwan ijkuakón ya welis timokuepas kan artal iwan xiktemaka moofrenda. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Tla akaj mitztilwia kan tlaixkomakaj (tlatzonmanaj), xajsikan san se tlajtole achtoj mientras tiweli, para amo ma mitztemakti (mitztemaktili) inawak in jues. Porke in tla amo, in jues mitztemaktis inmak in mayoltin iwan mitztzakuaskej telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ipan melajka nimitzilwia, nik amo tikisas de ompa asta amo xiktlaxtlawa in salúltimo sentabo para tikisas. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Namejwan ya ankikakej nik ya wejkawitl okinmilwijkej namoweyitajwan: “Amo ximomekatikan.” ");
INSERT INTO nhyNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero Nej namechilwia, tla akaj kixelewia se siwatl, kijtosneki ya kimomekatia ipan iyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Por yonik, tla moyekixtololo mitztoktia xiwetzi ipan tlajtlakole, okachi kuale xikmokixtili iwan xiktlamotla wejka. Porke okachi kuale xikpolo se parte de motlalnakayo, ke nochi motlalnakayo ma kitlamotlakan ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Iwan tla moyekma mitztoktia xiwetzi ipan tlajtlakole, okachi kuale xikmotzontekili iwan xiktlamotla wejka. Porke okachi kuale xikpolo se parte de motlalnakayo, ke nochi motlalnakayo ma kitlamotlakan ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Namejwan noijki ya ankikakej nik ya wejkawitl okinmilwijkej namoweyitajwan: “Akin kikajkawas isiwa, kipia de kimakas se amatl kan kijtojtos nik mokajkawa iwan isiwa.” ");
INSERT INTO nhyNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero Nej namechilwia, tla se tlakatl mokajkawa iwan isiwa, maski isiwa mach momekatia, yon tlakatl kijtosneki kimaka parte isiwa ma momekati iwan akaj tlakatl. Iwan tla akaj monamiktis iwan yon siwatl, kijtosneki iwan momekatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Namejwan noijki ya ankikakej nik ya wejkawitl okinmilwijkej namoweyitajwan: “Tla tej tikijta tikchiwas itlaj tlamantle iwan asta tikijta Dios tlachixtok, tonses moneki xikchiwa.” ");
INSERT INTO nhyNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero Nej namechilwia, amo xikijtokan Dios tlachixtok, iwan nion amo xikijtokan tlachixtok in ilwikak nik melawak tlan ankijtaj, porke in Dios ompa ewatok tlanawatijtok. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nion amo xikijtokan tlachixtok in tlaltikpak nik melawak tlan ankijtaj, porke ompa tlaksatokej ikxiwan in toTajtzin Dios. Nion amo xikijtokan tlachixtok in weyikan de Jerusalén nik melawak tlan ankijtaj, porke in toweyi Rey Dios yen yon iweyikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nion amo xikijtokan tlachixtok namotzontekon nik melawak tlan ankijtaj, porke mach welis ankichiwaskej se amotzonkal ma istaya o noso ma tliliwia. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Amo ijkón xikchiwakan. Okachi kuale xikijtokan “kuale kaj” o noso “amo”, porke tla ankijtoskej Dios tlachixtok, kijtosneki ankichiwaj tlan amo kuale, iwan Amo Kuale Tlakatl yen yon kineki xikchiwakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Namejwan ya ankikakej nik ya wejkawitl omijtoj: “Tla akaj teixkopina, ma kixkopinakan yej noijki. Tla akaj tetlanmayawi, ma kitlanmayawikan yej noijki.” ");
INSERT INTO nhyNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero Nej namechilwia, tla akaj anmechtoktia itlaj amo kuale, amo xikkuepaltikan. Sino, tla akaj amechixtlatzinia se lado, xikkawili noijki ma mitzixtlatzini in oksé lado. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tla akaj kineki mitzwikas kan tlaixkomakaj (tlatzonmanaj) para mitzkixtilis motzotzol, xikmaka noijki mokoton. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tla akaj mitznekatoktia xitlamama se kilómetro, tej xitlamama ome kilómetro. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tla akaj mitztlajtlanilia itlaj tlamantle, tej xikmaka. Iwan tla akaj itlaj mitztlanewilia, xiktlaneti. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Noijki ya ankikakej nik ya wejkawitl omijtoj: “Xiktlasojtla mokni, iwan xikkokoli akin mitzkokolia.” ");
INSERT INTO nhyNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero Nej namechilwia, xikintlasojtlakan akinmej amechkokoliaj, iwan ximotiotzajtzilikan por yen akinmej amechtlatlalochtiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ijkón namejwan anyeskej antekonewan de namoPapan Dios katlej kajki ilwikak. Porke Yej kichiwa in tonale ma kisa para katlej mach kualtin iwan para katlej kualtin, iwan kichiwa ma kiawi para katlej kichiwaj tlan kuale iwan para katlej kichiwaj tlan amo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Porke in tla namejwan ankintlasojtlaj sanwel katlej amechtlasojtlaj, ¿tlan welis ankitlaniskej? Asta katlej tlakobraroaj ika impuestos no ijkón kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iwan tla ankintlajpaloaj san yen namokniwan, ¿ankichiwaj itlaj tlan oksekimej mach welij kichiwaj? Asta katlej mach kixmatij Dios no ijkón kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xiekan namejwan ipan melajka ankualtin tlakaj, ken namoPapan Dios katlej kajki ilwikak Yej ipan melajka kuale tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Xikpiakan kuidado nijkuak ankichiwaskej tlan kuale, amo xikchiwakan inmixpan tlakaj san para ma kitakan tlan ankichiwaj. Tla ijkón ankichiwaskej, mach welis ankiresibiroskej in tlaxtlawile katlej kitemakas namoPapan Dios katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Por yonik, nijkuak itlaj ankitetliokoliskej amo xiktematiltikan nian nepa, ken kichiwaj in tlakaj katlej ome inmixko. Porke yejwan ijkón kichiwaj itech tiopanmej iwan ipan ojtle, para ma kinmitakan iwan ma tlapoakan kuale de yejwan. Ipan melajka namechilwia, nik in yonmej tlakaj mach ok itlaj tlaxtlawile kiresibiroskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nijkuak in tej itlaj tiktetliokolis, amakaj ma kimati nion yen moamigo katlej okachi iwan timuika. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Tla itlaj tiktemakas xiktemaka san ichtaka. Iwan moPapan Dios katlej kita nochi tlan tikchiwa ichtaka, Yej mitzmakas motlaxtlawil. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Nijkuak amejwan anmotiotzajtziliskej, amo xikchiwakan ken kichiwaj in tlakaj katlej ome inmixko, katlej kiwelitaj motiotzajtziliskej mokejketokej itech tiopanmej iwan itech eskinajtin de yen ojmej para ma kinmitakan. Ipan melajka namechilwia, nik in yonmej tlakaj mach ok itlaj tlaxtlawile kiresibiroskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero tej, nijkuak timotiotzajtzilis, xikalaki mokalijtik, ximokaltzakua iwan ximotiotzajtzili ompa ichtaka inawak moPapan Dios. Iwan moPapan Dios katlej kita tlan tikchiwa ichtaka, Yej mitzmakas motlaxtlawil. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Iwan nijkuak anmotiotzajtziliskej amo san ompa xikkueptokan in tlajtole, ken kichiwaj in tlakaj katlej mach kixmatij Dios, porke yejwan kiyejyekoaj tla san ompa kikueptoskej in tlajtole okachi kinkakilis in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amo xikchiwakan ken yejwan, porke namoPapan Dios ya kimati tlan namechpoloa antes de ankitlajtlaniliskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Namejwan moneki ximotiotzajtzilikan ijkín: ToPapan Dios katlej tejwatzin tikaj ilwikak, Ma nochtin in tlakaj ma mitzyektenewakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma ajsiki in tonale nijkuak tikinnawatis nochtin in tlakaj. Ma mochiwa tlan tikmonekiltia ixko yin tlaltikpak, ijkón ken tlan tikmonekiltia ma mochiwa ompa ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Xitechmaka axan tlan tikkuaskej katlej nochipa ika tipanoskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Iwan xitechtlapojpolwi de totlajtlakol, ken tejwan noijki tikintlapojpolwiaj akinmej techtoktiaj tlan amo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Iwan amo xitechmotekawili ma techtlajtlakolmayawi in Amo Kuale Tlakatl, sino xitechmakixti de inawak. Timitztlajtlaniliaj in yin porke tejwatzin tiknawatia nochi, tikpia poder, iwan tikpia mawisotlanextle iktlanke (ik tlami). Ijkón ma yeto. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Porke tla namejwan antetlapojpolwiaj de nochi tlan amechtoktiaj, namoPapan Dios katlej kajki ilwikak noijki amechtlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero in tla namejwan amo antetlapojpolwiskej, noijki namoPapan Dios mach amechtlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Nijkuak amejwan anmosawaskej, amo ximoiknotlachaltikan ken kichiwaj in tlakaj katlej ome inmixko, porke yejwan moiknotlachaltiaj para ma kinmitakan nik mosawtokej. Ipan melajka namechilwia, nik mach ok itlaj tlaxtlawile kiresibiroskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Tej nijkuak timosawas, ximixami iwan kuale ximotzijtzikui. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ijkón, mach akaj kimatis kox timosawtok, sanwel kimatis moPapan Dios katlej yetos mowan, iwan moPapan Dios katlej kimati tlan tikchiwa ichtaka, Yej mitzmakas motlaxtlawil. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Amo xikololokan rikojyotl ixko yin tlaltikpak, kan tlakuakualo iwan tlapalani, iwan tlachtekij. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sino xikololokan rikojyotl ompa ilwikak, kan mach tlakuakualo, iwan mach tlapalani, iwan nion mach tlachtekij. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porke kan yetos namorikojyo, ompa yetos noijki namoyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Namoixtololowan ankinpiaj kej se tlanextle para namoanima, iwan tla namoixtololowan kualemej, namoanima kipias tlanextle. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero in tla namoixtololowan mach kualemej por yen tlajtlakole, nochi namoanima yetos ijtik tlatleyualotl. Ijkón kiné, tla namotlanex yomokuepke tlatleyualotl itech namoanima por yen tlajtlakole, kijtosneki ankatej itech se weyi tlatleyualotl iwan mach onkaj oksé tlatleyualotl ijkón. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Mach akaj tlakatl welis kinpias ome itekowan, porke welis kitlasojtlas in se iwan oksé mach kitlasojtlas, o noso welis kitlakitas in se iwan oksé mach kitlakitas. Mach welis ankitekipanoskej in Dios mientras amechyoltilantok in rikojyotl. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Por yonik namechilwia, amo ximotlanemililtikan por tlan ankikuaskej o noso tlan ankoniskej para anyolitoskej, nion amo ximotlanemililtikan por tlan ankonakiskej. ¿Amo ankimatij nik in tonemilis okachi ipatij ke totlakual? ¿Amo ankimatij noijki nik in totlalnakayo okachi ipatij ke tlan tikonakiaj? ");
INSERT INTO nhyNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xikinmitakan in totomej katlej patlantinemij. Mach tookaj, mach pixkaj, iwan nion mach itlaj kitlaatiaj ijtik kueskomatl. Pero namoPapan katlej kajki ilwikak Yej kintlamaka. Iwan namejwan okachi amopatij iwan amo ken totomej. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tla akaj de amejwan sa tekitl tlanemilia porke kineki moskaltis ok tlajko metro, ¿kox welis moskaltis? ");
INSERT INTO nhyNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’¿Tlanik namejwan wel anmotlanemililtiaj por tlan ankonakiskej? Xikitakan kenik moskaltiaj in xochimej ipan tepetl. Mach tekipanoaj iwan nion mach tlajtzomaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero Nej namechilwia ke nion rey Salomón mach semi omotzotzoltij ken se de yon xochitl maski omotzotzoltiaya ika katlej okachi kuale itzotzol. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iwan tla Dios ijkón kitlakentia in xochitl katlej axan kajki ipan tepetl iwan mostla wiptla mochichinos ijtik tlitl, ¿kenik amo ma amechtzotzolti namejwan? ¡Namejwan wel tzikitzin namotlaneltokalis! ");
INSERT INTO nhyNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amo ximotlanemililtikan kiné, amo xikmolwikan: “¿Tlan tikkuaskej? o noso ¿tlan tikoniskej? o noso ¿tlan tikonakiskej?” ");
INSERT INTO nhyNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nochi in yin tlamantle ika motlanemililtiaj in tlakaj katlej mach kixmatij Dios. Pero namejwan ankipiaj namoPapan katlej kajki ilwikak katlej ya kimati tlan amechpoloa. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Por yonik, namejwan achtoj xikchiwakan tlan Dios amechnawatia ipan namoyolo para xikchiwakan ken Yej kineki. Iwan ijkón Dios amechmakas noijki nochi yon tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ijkón kiné, amo ximotlanemililtikan por yen mostla, porke mostla welis oksemi anmotlanemililtiskej. Kada tonale yipa ankipiaskej tlan ika anmotlanemililtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Amo xikinpojpoakan oksekimej, para namejwan noijki amo ma amechpojpoakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porke tla antepojpoaskej namejwan noijki amechpojpoaskej. Porke Dios amechtoktis ijkón ken namejwan antetoktiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Kenik in tej weli tikistlakawia in mokni por yen tlajtlakole tlan kichiwa, iwan tej mach timota nik tikaj okachi titlajtlakolej? ");
INSERT INTO nhyNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Iwan, ¿kenik weli tikilwia in mokni: “Mach ok xitlajtlako”, iwan tej tikchijtok miek tlajtlakole? ");
INSERT INTO nhyNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Teixkajkayaj! Achtoj tej xikkawa in tlajtlakole katlej miek tikchijtok, iwan ijkón welis tikilwis in mokni mach ok ma tlajtlako. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Itlajtol in Dios katlej chipawak amo xikinmakakan in tlakaj katlej kipiaj mach kuale inyolo. Porke yon kej yeskia ankinmakaj in chichimej ma kikuakan tlan Dios iaxka, iwan noijki kej yeskia ankinmakaj in pitzomej ma kikuakan se tlamantle katlej sa tekitl patíoj. Porke yejwan san ipan tlajtlaksaskej iwan welis mokuepaskej amotech iwan amechkuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xiktlajtlanilikan Dios tlan amechpoloa, iwan Yej amechmakas. Xiktemokan tlan amechpoloa, iwan ankajsiskej. Xiktatalatzakan puerta, iwan Dios amechtlatlapolis. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porke akin itlaj kitlajtlani, kiresibiroa. Iwan akin itlaj kitemoa, kajsi. Iwan akin kitatalatza in puerta, kitlatlapoliaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Welis tikmakas mokone se tetl nijkuak mitztlajtlanilis se pan? ");
INSERT INTO nhyNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O noso welis tikmakas se koatl nijkuak mitztlajtlanilis se michin? ");
INSERT INTO nhyNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Iwan tla namejwan katlej mach ankualtin ankimatij ankinmakaj namopilwan tlan kuale, ¿amo ankineltokaj nik in namoPapan katlej kajki ilwikak welis kinmakas itlaj tlan kuale akinmej kitlajtlaniliskej? ");
INSERT INTO nhyNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ijkón kiné, namejwan xikinchiwilikan oksekimej ijkón ken namejwan ankinekij ma amechchiwilikan. Nochi in tlanawatile de Moisés iwan nochi tlan okijkuilojkej in profetajtin yen yon tlan kijtaj xikchiwakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Xikalakikan itech puerta kopichtik katlej yawi ilwikak. Porke in puerta katlej kuyawak iwan ojtle katlej patlaktik tewikaj kan tlaixpolojkan, iwan miekej tlakaj yawij ipan yon ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero sa tekitl kopichtik in puerta iwan sa tekitl pitzaktzin in ojtle katlej tewikaj itech nemilistle, iwan mach miekej kajsij. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Xikpiakan kuidado de nekatej tlakaj teixkajkayajkej katlej mochiwaj tlapoaj de Dios. Yejwan motaj kej kualtin tlakaj, pero mach melawak, motaj kej ichkamej pero yejwan katej kej koyomej. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Namejwan welis ankinmixmatiskej kuale por yen tlan kichiwaj. Porke mach moteki uvas itech witztle, iwan nion mach moteki igos itech nojpale. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nochi tlatoktle kuale kitemaka kuale itlakilo, pero in tlatoktle katlej mach kuale noijki kitemaka itlakilo mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Se tlatoktle kuale mach kitemaka itlakilo mach kuale, iwan se tlatoktle katlej mach kuale mach weli kitemaka itlakilo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nochi tlatoktle katlej mach kitemaka kuale itlakilo, se kitzonteki iwan se kitlamotla ijtik tlitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ijkón kiné, namejwan welis ankinmixmatiskej kuale por yen tlan kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Miekej tlakaj nechilwiaj: “Señor, Señor”, pero mach nochtin kalakiskej ilwikak kan Dios tlanawatia. Sino kalakiskej san yejwan katlej kichiwaj tlan kimonekiltia in noPapan katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Miekej nechilwiskej itech nekáj tonale: “Señor, Señor, ¿amo tikelnamiki nik in tejwan otitetlapowijkej ika motoka, iwan ika motoka otikinkixtijkej demoniojtin, iwan ika motoka otikinchijkej miekej milagrostin?” ");
INSERT INTO nhyNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ijkuakón Nej nikinmilwis: “Mach semi onamechixmatke. Ximachiwakan de Nej, tlajtlakolejkej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ijkón kiné, akin kikaki iwan kichiwa tlan nikijta, yon ken se tlakatl ixtlamatke katlej okichij ikal ipan tepejxitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Owalaj se tlamawisolkiawatl, iwan otlatlawitonke ik nian nepa, iwan chikawak oejekak, iwan mach owetzke in yon kale porke kajki ipan tepejxitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero akin nechkaki iwan amo kichiwa tlan nikijta, yon ken se tlakatl katlej mach kimati tlakaki iwan okichij ikal ijtik xale. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Owalaj se tlamawisolkiawatl, otlatlawitonke ik nian nepa, iwan chikawak oejekak, iwan kale owetzke iwan nochi oxitinke. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nijkuak Jesús otlanke okintlapowij, nochtin in tlakaj sa otlajtlachixkej (omomajmawtijkej) de kenik okinmachtiaya. ");
INSERT INTO nhyNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porke otlamachtiaya ika chikawak tlanawatile, iwan amo ken otlamachtiayaj in tlamachtijkej de itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nijkuak Jesús otemok de ipan tepetl, miekej tlakaj oyajkej Iwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ijkuakón omijkuanij inawak Jesús se tlakatl katlej opalania inakayo, omotlankuaketzke iyakapan iwan okilwij: ―Señor, tla tikmonekiltiani, welini tinechpajtiani. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús okitlalij ima ipan yon tlakatl iwan okilwij: ―Nej nikneki xipajti. Iwan san niman opajtik de ikokolis. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iwan Jesús okilwij: ―Xikkaki, amakaj itlaj xikilwi. San xiwia inawak in tiopixke, iwan xiktemaka moofrenda tlan Moisés otlanawatij ma motemaka, para ijkón nochtin ma kimatikan nik in Dios yomitzpajtij de mokokolis. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nijkuak Jesús okalakke itech pueblo de Capernaum, ijkuakón se kapitan omijkuanij inawak Jesús, iwan okitlatlawtij. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Okilwij: ―Señor, notekipanoj kajki nokalijtik mokokoa, owijwilantik iwan sa tekitl wapawiswilo. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús okinankilij: ―Ompa niawi nikpajtiti. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","In kapitan okilwij: ―Señor, mach notech powi xikalaki nokalijtik. Iwan mach moneki xiwia asta ompa, san nian xikijto ma pajti iwan notekipanoj pajtis. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yon nej kuale nikmati. Porke nej noijki nimomatok nikintlakita notlayekankej. Iwan noijki nikinpia soldadojtin katlej nechtlakitaj. Iwan tla nikilwis se de yejwan: “Xiwia ne”, in yej yawi. Iwan tla nikilwis oksé: “Xiwiki”, in yej witz. Iwan tla nikilwis in notekipanoj: “Xikchiwa yin tekitl”, in yej kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nijkuak ijkón okikakke in Jesús, sa otlajtlachixke (omomajmawtij), iwan okinmilwij in tlakaj katlej Iwan oyayaj: ―Ipan melajka namechilwia, nik mach nikajsi nion se judío katlej kipia weyi itlaneltokalis ken yin tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Iwan namechilwia nik witzej miekej tlakaj de ik ikisayan tonale iwan de ik ipoliwian tonale, iwan motlaliskej tlakuaskej iwan Abraham, iwan Isaac, iwan Jacob, ompa ilwikak kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero miekej judiojtin katlej Dios okinekia ma kalakikan ompa kan Yej tlanawatia, yeskej kalan ijtik tlatleyualotl. Ompa chokaskej iwan motlanteteyitzaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ijkuakón Jesús okilwij in kapitan: ―Xiwia mochan, iwan ma mochiwa ijkón ken tej tikneltoka. Iwan san niman ijkuakón opajtik itekipanoj in kapitan. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús oyáj ichan Pedro, iwan okitajsik imonan in Pedro wetok ipan itlapech kipia totonik. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús okimakitzkij imonan in Pedro, iwan in totonik okiske. Imonan Pedro omejke iwan okintlamakak. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nijkuak owaltlatleyuak okinwikilijkej in Jesús miekej tlakaj katlej okipiayaj ejekamej mach kualtin. Iwan san ika se tlajtole okinkixtij in yonmej ejekamej, iwan noijki okinpajtij nochtin katlej omokokoayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ijkón otlapanok para ma mochiwa tlan okijtoj in profeta Isaías, nijkuak okijtoj: “Yej otechpajtij de tokokolis iwan otechpojpolilij in tokualolis.” ");
INSERT INTO nhyNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nijkuak Jesús okitak opéj kiyawaloaj miekej tlakaj, ijkuakón okinnawatij imomachtijkawan ma panokan oksé lado de yen lago. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Iwan ijkuakón omijkuanij inawak Jesús se tlamachtij itech tlanawatile de Moisés, iwan okilwij: ―Tlamachtij, nikneki nimitzwikas san kan Tej tias. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús okinankilij: ―In ostomej kipiaj inkuyok, iwan totomej kipiaj intepajsol, pero Nej katlej onimochij nitlakatl mach nikpia kan nimosewis. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Oksé de yen imomachtijkawan noijki okilwij: ―Señor, xinechkawili achtoj ma niktookati nopapan. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús okinankilij: ―Xiwiki nowan, xikinkawa katlej mach nechneltokaj yejwan ma kintookakan inmikkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús otlejkok itech se barko, iwan imomachtijkawan oyajkej Iwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ijkuakón opéj ejeka chikawak iwan atl opéj motlatlamotla ipan barko iwan oatemiaj. Pero Jesús okochtoka. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Tonses imomachtijkawan okijxitijkej, iwan okilwijkej: ―¡Señor, xitechmakixti! ¡Tiapolakij! ");
INSERT INTO nhyNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yej okinnankilij: ―¿Tlanik wel anmomawtiaj? Namejwan wel tzikitzin namotlaneltokalis. Ijkuakón, omoketzke, okajwak in ejekatl iwan atl, iwan san niman omokaj sa tlamantok. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Imomachtijkawan sa otlajtlachixkej (omomajmawtijkej). Iwan okijtojkej: ―¿Akin yin tlakatl, porke asta yen ejekatl iwan atl kitlakitaj? ");
INSERT INTO nhyNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nijkuak Jesús oajsito oksé lado de yen lago, itech tlale de pueblo de Gadara, ijkuakón omen tlakaj katlej okipiayaj ejekamej mach kualtin owalkiskej de kan mikkakuyoktin iwan omijkuanijkej inawak Jesús. Oyekaj sa tekitl temajmawtijkej iwan mach akaj owelia opanoaya ipan yon ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nijkuak okitakej in Jesús, otzajtzikej, iwan okijtojkej: ―¡Amo ximokalaki towan, Jesús, teKone de Dios! ¿Otiwalaj nian para titechtlajyowiltis antes de ajsiki in tonale? ");
INSERT INTO nhyNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iwan mach wejka de ompa, oyekaj miekej pitzomej otlakuajtokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iwan ejekamej mach kualtin okitlatlawtijkej in Jesús: ―Tla titechkixtis de intech yinmej tlakaj, tonses xitechkawili ma tikalakikan intech nekatej pitzomej. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús okinmilwij: ―Xiwian kiné. In ejekamej mach kualtin okiskej de intech yonmej tlakaj iwan okalakej intech nekatej pitzomej. Iwan san niman ijkuakón nochtin in pitzomej omotlalojkej iwan omotepejxiwitoj asta ijtik atl, iwan ompa omoatlanwijkej iwan omikkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","In tlajpixkej de yonmej pitzomej ocholojkej. Iwan nijkuak oajsikej itech pueblo opéj kitematiltiaj nochi tlan otlapanok iwan de yen tlakaj katlej okipiayaj ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Satepan nochtin in tlakaj de yon pueblo oyajkej kan oyeka in Jesús, iwan nijkuak okitakej okitlatlawtijkej ma wia de ompa de itech intlal. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesús otlejkok itech se barko, opanok oksé lado de yen lago, iwan oajsito itech pueblo de Capernaum kan Yej ochantia. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ompa oajsikoj sekimej tlakaj katlej okualwikiliayaj in Jesús se tlakatl ipan itlapech katlej owijwilantik. Iwan nijkuak Jesús okitak intlaneltokalis in yonmej tlakaj, ijkuakón okilwij in kokoxke: ―Ximoyolojchikawa, nokone. Nimitztlapojpolwia de nochi motlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Pero sekimej tlamachtijkej de itlanawatil in Moisés okiyejyekojkej: “Yin tlakatl tlajtoa biero de Dios.” ");
INSERT INTO nhyNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Jesús okimomakak kuenta de tlan okiyejyekoayaj, iwan okinmilwij: ―¿Tlanik namejwan mach kuale tlan ankiyejyekoaj? ");
INSERT INTO nhyNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Katlij yen okachi mach owij nikilwis in kokoxke: “Nimitztlapojpolwia de nochi motlajtlakol”, o noso nikilwis: “Ximewa, iwan xinejnemi”? ");
INSERT INTO nhyNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero xikmatikan nik in Nej katlej onimochij nitlakatl, nikpia poder ixko yin tlaltikpak para nitetlapojpolwis itech tlajtlakole. Iwan ijkuakón okilwij in tlakatl katlej owijwilantik: ―Ximewa, xikajkokui motlapech iwan xiwia mochan. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tonses in yej omoketzke iwan oyáj para ichan. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","In tlakajtin nijkuak ijkón okitakej, sa otlajtlachixkej (omomajmawtijkej) iwan okiweyikixtijkej in toTajtzin Dios por okinmakak in tlakaj ipoder ijkón ken Jesús okimakak. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús okiske de ompa, okitak se tlakatl itoka Mateo oewatoka kan yej otlakobrarojtoka ika impuestos. Iwan Jesús okilwij: ―Xiwiki nowan. Tonses in Mateo omoketzke iwan oyáj iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Itech se tonale, Jesús otlakuajtoka ichan Mateo inwan miekej katlej tlakobraroaj ika impuestos, iwan sekimej tlajtlakolejkej. Nochtin yejwan owalajkej omotlalijkej san sekan iwan Jesús iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nijkuak in fariseos ijkón okitakej, okinmilwijkej in momachtijkej: ―¿Tlanik namotlamachtij tlakua inwan tlakaj tlajtlakolejkej iwan noijki tlakua inwan tlakaj katlej tlakobraroaj ika impuestos? ");
INSERT INTO nhyNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús okikakke iwan okinmilwij: ―In tlakaj katlej mach mokokoaj mach intech moneki tepajtij, sino intech moneki yen katlej mokokoaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ximomachtikan tlan kijtosneki in tlajtole katlej ijkuilitok itech tiotlajkuilole: “Nikneki xiteiknomatikan, mach nikneki xinechinmiktilikan yolkamej para ika annechweyikixtiskej.” Nej mach oniwalaj onikinnotzako katlej yolchipawakej, sino oniwalaj onikinnotzako katlej tlajtlakolejkej para ma moyolkuepakan inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Imomachtijkawan in Juan Tlakuateekij omijkuanijkej inawak Jesús iwan okitlajtlanijkej: ―Tejwan iwan fariseos timosawaj (tiayunaroaj) miekpa, ¿tlanik momomachtijkawan mach mosawaj? ");
INSERT INTO nhyNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús okinnankilij: ―¿Kox welis moyolkokoskej iinbitadoswan in novio nijkuak yej inwan yetos? Pero ajsis tonale nijkuak in yej mach ok inwan yetos, iwan ijkuakón welis moyolkokoskej iwan mosawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Mach akaj kiyektlalia se tzotzole katlej ya tlajtlantok iwan kitilichoa ika se pedaso tzotzole yankuik, porke in tzotzole yankuik mololoa iwan kitzayana in tzotzole katlej ya tlajtlantok, iwan okachi tzayani. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nion mach se kitlalia vino yankuik ijtik kulambre katlej ya tlajtlantok. In vino yankuik kitzomonia in kulambre katlej ya tlajtlantok, iwan vino iwan kulambre parejo ijtlakawij. Por yonik, in vino yankuik moneki motlalis ijtik kulambre yankuik, para ijkón san ken omen ma tlaxikokan. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iwan nijkuak Jesús okintlapowijtoka in tlakaj de yon tlajtole, ijkuakón owalaj se tlayekanke judío, omotlankuaketzke iyakapan Jesús iwan okilwij: ―Nochpoch yakin tlami omikke. Pero tla tejwatzin tias iwan tla ipan tikintlalis momawan, moyolkuis (moyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús omoketzke, oyáj iwan yon tlakatl iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ijkuakón se siwatl katlej yokipiaya majtlaktle iwan ome xiwitl de oestlapowik, omijkuanij ik ikuitlapan in Jesús iwan okitzkilij itzotzol san itempantzin. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Porke okimolwij: “Tla siera najsis niktlakenkitzkis, welis nipajtis.” ");
INSERT INTO nhyNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero Jesús omokuepke, okitlatak in siwatl iwan okilwij: ―Ximoyolojchikawa, nokone, yotipajtik porke otinechneltokak. Iwan san niman ijkuakón opajtik in siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nijkuak Jesús oajsito ichan tlayekanke judío, okinmitak in tlapitzkej yomoyektlalijkej para kitookatiwej in ichpochtle, iwan in tlakaj okuawtzajtziaj ika chokilistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús okinmilwij: ―Xikisakan de nian, yin ichpochtle mach ya miki, sino yej kochi. In tlakaj okiwewetzkilijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero Yej okinkixtij. Ijkuakón okalakke iwan okimakitzkij in ichpochtle, iwan ichpochtle omejke. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iwan itech nochi nekáj país okimatkej de tlan otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nijkuak Jesús okiske de ompa, omen tlakaj katlej mach tlachiaj ikuitlapan oyajkej tzajtzitiwej: ―¡Xitechiknomati tejwatzin, tekone de David! ");
INSERT INTO nhyNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nijkuak Jesús okalakke kalijtik, in tlakaj katlej mach tlachiaj omijkuanijkej inawak Jesús, iwan Jesús okintlajtlanij: ―¿Ankineltokaj namejwan nik welis namechpajtis? Yejwan okijtojkej: ―Tikneltokaj, Señor. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tonses Jesús okintlalij imawan ipan inmixtololowan, iwan okinmilwij: ―Ma mochiwa ijkón ken namejwan ankineltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iwan san niman ya kuale otlachixkej. Iwan Jesús okinnawatij: ―Amakaj ma kimati de kenik anpajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero niman nijkuak okiskej, opéj tetlapowiaj itech nochi in yon región de tlan Jesús okichij. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nijkuak okiskej in yonmej tlakaj katlej mach otlachiayaj, ijkuakón oksekimej tlakaj okiwikilijkej in Jesús se tlakatl nontzin katlej okipiaya se ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nijkuak Jesús okikixtij in ejekatl mach kuale, in tlakatl nontzin opéj tlajtoa. In tlakaj sa otlajtlachixkej (omomajmawtijkej), iwan okijtoayaj: ―¡Mach semi otikitayaj yin tlamantle itech yin país de Israel! ");
INSERT INTO nhyNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero in fariseos okijtoayaj: ―Yin tlakatl kinkixtia mach kualtin ejekamej ika ipoder in tlayekanke demonio. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús onemia itech nochtin weyikantin iwan pueblojtin, iwan otlamachtiaya itech intiopanwan in judiojtin de kada lugar. Okitematiltiaya in kuale tlajtole katlej temakixtia de kenik in Dios tlanawatia, iwan okinpajtiaya de nochi kokolistle iwan de nochi kualolistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nijkuak okinmitak in tlakaj, okinmiknomaj, porke oyekaj kej iknomej iwan mach okimatiaj tlan kichiwaskej, oyekaj kej ichkamej katlej mach kipiaj tlajpixke. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ijkuakón okinmilwij imomachtijkawan: ―Katej miekej tlakaj katlej moneki kikakiskej notlajtol, pero mach katej miekej katlej kitematiltiaj notlajtol. Kej yeskia onkaj miek tekitl itech pixkale iwan tekipanojkej mach miekej katej. ");
INSERT INTO nhyNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Por yonik, xiktlajtlanilikan in Dios katlej iteko yon pixkale ma kintitlani okachi tekipanojkej para ma pixkatij. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús okinpejpenke majtlaktle iwan ome imomachtijkawan, okinmakak poder para kinkixtiskej ejekamej mach kualtin iwan para tepajtiskej de nochi kokolistle iwan de nochi kualolistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yinmej yejwan in majtlaktle iwan ome itlatitlanilwan katlej okinpejpenke: Achtoj in Simón, katlej noijki kinotzaj Pedro, iwan noijki okipejpenke in ikni itoka Andrés. Noijki okinpejpenke in Jacobo iwan ikni Juan, katlej itelpokawan in Zebedeo. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Noijki okinpejpenke in Felipe, Bartolomé, Tomás, Mateo katlej okololoaya impuestos. Jacobo itelpoch in Alfeo, iwan Tadeo. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón katlej onemia iwan cananistas, iwan Judas Iscariote katlej satepan okitemaktij (okitemaktilij) in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús okintitlanke majtlaktle iwan omen imomachtijkawan iwan ijkín okinnajnawatij: ―Amo xiwian kan katej katlej mach judiojtin, nion amo xikalakikan itech pueblojtin de Samaria. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sino xiwian kan katej in tokniwan judiojtin katlej mopolojtinemij kej ichkamej. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xiwian, iwan xikinmatiltikan nik yoajsiko in tonale para Dios tlanawatis ipan inyolo in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xikinpajtikan in kokoxkej, xikinyolitikan in mikkamej, xikinpajtikan katlej nakayopalanij, iwan xikinkixtikan in ejekamej mach kualtin. Namejwan Dios oamechtliokolij ipoder, tonses moneki no amo xitlakobrarokan por ankitekipanoltiskej in yon poder. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Amo xikitkikan itlaj tomin, ");
INSERT INTO nhyNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nion amo xikitkikan amotlaxkal para ankikuaskej ipan ojtle, nion amo xikitkikan ome amotzotzol, nion ome pares amokak, nion amokarrotij. Porke akinmej ankinpalewiskej yejwan kipiaj de amechmakaskej tlan amechpolos, porke namejwan ankitekipanoaj in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Nijkuak anmajsiskej itech se weyikan o itech se pueblo, xiktemokan se katlej kuale tlakatl iwan ompa ximokawakan ichan asta ijkuak ankisaskej de yon lugar. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nijkuak ankalakiskej kalijtik, xitetlajpalokan. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tla in chanejkej kuale amechresibiroaj, Dios kintiochiwas ika yolosewilistle. Pero tla amo amechresibiroaj kuale, Dios mach kinmakas yolosewilistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Iwan tla amo amechresibiroaj iwan nion amo kinekij amechkakiliskej, xikisakan de yon kalijtik o noso de yon pueblo, iwan ximokxitlaltzejtzelokan kej yeskia se señas nik okixpanawijkej in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ipan melajka namechilwia, ke itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), intlajyowilis in yonmej tlakaj yetos okachi weyi ke para nekatej tlakaj de Sodoma iwan de Gomorra. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’¡Kuale xikkakikan! Nej namechtitlani kej amichkamej kan katej koyomej. Xiekan anlistojtin ken koamej, pero xiekan anpasensiajtin ken palomastin iwan amo xitetoktikan tlan amo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Xikpiakan kuidado, porke amechtemaktiskej (omechtemaktiliskej) inmak tekiwajkej, iwan amechwitekiskej itech tiopanmej. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iwan asta amechtemaktiskej inmak gobernadortin iwan inmak reytin por annechneltokaj. Ijkuakón namejwan moneki antlajtoskej de notlajtol inmixpan yonmej tekiwajkej, iwan inmixpan in tlakaj katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero nijkuak amechtemaktiskej inmak tekiwajkej, amo xitlanemilikan por kenik antlajtoskej o noso tlan ankijtoskej. Porke itech yon ora Dios amechmakas tlajtole tlan ankijtoskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Porke mach amejwan antlajtoskej, sino yen iEspíritu namoPapan Dios katlej tlajtos por amejwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’In teikni kitemaktis (kitemaktilis) in ikni ma kimiktikan, in tetaj kitemaktis ikone ma kimiktikan, in tepilwan inpan mokuepaskej in tetajmej iwan kintemaktiskej para ma kinmiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochtin amechkokoliskej por annechneltokaj. Pero akin kixikos nochi tlan panos, Dios kimakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nijkuak amechtlatlalochtiskej itech se pueblo, xicholokan xiwian itech oksé pueblo. Ipan melajka namechilwia, nik in Nej katlej onimochij nitlakatl niwitz oksemi antes de antlamiskej anyaskej itech nochtin pueblojtin de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Se katlej momachtij mach kipanawilia itlamachtij, iwan se katlej san tekipanoj mach kipanawilia iteko. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Se katlej momachtij ma paki tla ajsiti ken itlamachtij, iwan se katlej tekipanoj ma paki tla ajsiti ken iteko. Iwan tla Nej, akin nikaj kej nitepapan de familia nechtokayotiaj niBeelzebú, namejwan noijki amechtokayotiskej san tlan amo. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Amo xikinmiimakasikan in tlakaj. Porke nochi tlan tlatitok kipia de nesis, iwan nochi tlan amo momati kipia de momatis. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tlan Nej namechilwia san yen namejwan, xikijtokan inmixpan nochtin. Iwan tlan namechilwia ichtaka, xiktematiltikan kan nochtin kuale ma kikakikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amo xikinmiimakasikan in tlakaj katlej kinekij amechmiktiskej, porke mach itlaj welis kitoktiskej namoanima. Xikimakasikan in Dios katlej kipia poder para kixpolos namotlalnakayo iwan para kixpolos namoanima ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Amo monamakaj ome tototzitzintin por se sentabo? Pero nion se de yejwan mach mikis tla namoPapan Dios mach kimonekiltia. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Iwan Nej namechilwia namejwan nik in Dios kimati asta keski namotzonkal ankipiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ijkón kiné, amo ximomawtikan. Namejwan okachi anpatiojkej iwan amo ken inpatij miekej tototzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Tla akaj kijtos inmixpan tlakaj nik kineltoka nik in Nej nitemakixtij de yej, Nej noijki nikijtos ixpan noPapan katlej kajki ilwikak nik in yej noaxka. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Iwan tla akaj kijtos mach nechixmati inmixpan tlakaj, Nej noijki nikijtos mach nikixmati ixpan noPapan katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Amo xikyejyekokan ke Nej oniwalaj para ma yeto yolosewilistle ixko yin tlaltikpak. Mach oniwalaj para namechmakas yolosewilistle, sino in tlakaj moxexeloskej por Nej. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Oniwalaj para nikinxixinis in tlakaj. In tlakatl mach motlajtolnamikis iwan ipapan, iwan ichpochtle mach motlajtolnamikis iwan imaman. In siwamontle mach motlajtolnamikis iwan imonan. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Se tlakatl welis yeskej ikontraswan mismo yejwan ifamiliareswan. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Akin kitlasojtla ipapan o noso imaman okachi ke Nej, mach yetos noaxka. Iwan akin kitlasojtlas itelpoch o noso ichpoch okachi ke Nej, mach yetos noaxka. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iwan akin amo kinekis witz nowan iwan amo kinekis trabajojpanos asta komo para ma kimiktikan itech krus, mach powis noaxka. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Akin kinekis kipalewis inemilis, kipolos, pero tla akaj kipoloa inemilis por Nej, kajsis inemilis katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Akin namejwan amechresibiroa, Nej nechresibiroa. Iwan akin Nej nechresibiroa, noijki kiresibiroaj akin onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Akin kiresibiroa se profeta porke in profeta kitekipanoa in Dios, kimakaskej itlaxtlawil ijkón ken kimakaj se profeta. Iwan akin kiresibiroa se katlej kuale tlakatl, kimakaskej itlaxtlawil ijkón ken kimakaj se katlej kuale tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iwan akin kintliokolis siera se xikale atl sesek se de yinmej nomomachtijkawan, ipan melajka namechilwia nik kipias itlaxtlawil. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nijkuak Jesús otlanke okinnajnawatij in majtlaktle iwan ome imomachtijkawan, ijkuakón oyáj de ompa para tlamachtis iwan kitematiltis itlajtol in Dios itech pueblojtin de yon región. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","In Juan Tlakuateekij otzaktoka telpiloyan, iwan nijkuak okimatke tlan okichiwaya in Cristo Jesús, ijkuakón okintitlanke omen imomachtijkawan inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Iwan imomachtijkawan in Juan okitlajtlanijkej in Jesús: ―¿Yen tejwatzin tiCristo katlej Dios techilwijtiwitz kipia de witz o noso ok moneki tikchiaskej ma wiki? ");
INSERT INTO nhyNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús okinnankilij: ―Xiwian iwan xikilwikan in Juan nochi tlan namejwan ankitakej iwan ankikakej. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xikilwikan ke katlej mach otlachiayaj axan ya tlachiaj, in koxomej ya kuale nejnemij, katlej opalania innakayo yopajtikej de inkokolis, katlej mach otlakakiaj axan ya tlakakij, in mikkamej moyolkuij, iwan pobrestin kikakij in kuale tlajtole katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ma paki akin amo kipoloa itlaneltokalis nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nijkuak imomachtijkawan in Juan oyajkej, ijkuakón Jesús opéj kintlapowia in tlakaj de yen Juan Tlakuateekij. Okinmilwij: ―¿Akin anyajkej ankitatoj ne kan tlawaki? ¿Ankitatoj se tlakatl katlej itlaneltokalis kiitki in ejekatl no ken nijkuak in ejekatl kiitki se akatl? ");
INSERT INTO nhyNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Akin kiné ankitatoj? ¿Ankitatoj se tlakatl katlej omotzotzoltiaya ika kuale itzotzol? Namejwan kuale ankimatij ke katlej kuale motzotzoltiaj katej ichan reytin. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pero, ¿akin ankiskej ankitatoj? ¿Se profeta? Melawak, yej okachi kipanawilia ke se profeta. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","In tiotlajkuilole tlapoa de yen Juan, kijta: Nej niktitlani notlatematiltij moyakapan, ma mitzyektlalili in ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ipan melajka namechilwia, ke asta axan mach onkaj nion se tlakatl katlej okachi kipanawilia in Juan Tlakuateekij. Pero akin okachi tzikitzin de itech ilwikak kan Dios tlanawatia yen okachi weyi ke Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde ijkuak in Juan Tlakuateekij opéj kitematiltia itlajtol in Dios iwan opéj tlakuateekia, in tlakaj mochikawaj kinekij kalakiskej kan Dios tlanawatia. Iwan kalakij sanwel katlej melawak mochijchikawaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Asta axan nochtin in profetajtin iwan tlanawatile de Moisés otlapojkej de Cristo asta ijkuak owalaj in Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Iwan tla namejwan ankinekij ankineltokaskej, Juan yen profeta Elías katlej okipiaya de witz. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Akin kipia itlakakilis, ma kikaki. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Tlan ika welis nikinkompararos in tlakaj de yin tiempo? Yejwan katej ken telpokamej katlej motlaliaj mawiltiaj itech tiankistle iwan kintzajtziliaj inmamigoswan, ");
INSERT INTO nhyNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","kinmilwiaj: “Mach ijkón nik anmawiltiaj. Tejwan otamechtlapichilijkej para ximijtotikan, pero mach anmijtotijkej. Otamechtlakuikilijkej se tlakuikale teyolkokoj, pero mach ankinekej anchokakej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pues, owalaj in Juan, katlej omosawaya (oayunaroaya) iwan mach itlaj vino okonia. Iwan namejwan ankijtojkej ke kipia se ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Satepan oniwalaj Nej katlej onimochij nitlakatl, iwan nitlakua iwan nikoni. Iwan namejwan ankijtaj ke nitlakuani iwan nitlawanke, iwan ankijtaj inwan nimuika in tlajtlakolejkej iwan katlej tlakobraroaj ika impuestos. Pero nijkuak in Dios akaj kimaka tlalnamikilistle, kimomaka kuenta nik melawak tlan nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Tonses Jesús opéj kinmistlakawia in tlakaj itech pueblojtin kan okinchij okachi miekej milagrostin, porke in yonmej tlakaj mach omoyolkuepayaj de intlajtlakol. Okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Pobre de tej, pueblo de Corazín! ¡Pobre de tej, pueblo de Betsaida! Porke tla itech weyikan de Tiro iwan itech weyikan de Sidón kitanij in milagrostin katlej amejwan ya ankitakej, ya ke tiempo yeskia yomoyolkuepkej. Iwan motzotzoltianij de luto iwan motlikonexwianij, para kiteititianij nik yomoyolkuepkej de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero Nej namechilwia, nik itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), namejwan ankipiaskej okachi weyi tlajyowilistle ke in tlakaj de weyikan de Tiro iwan de Sidón. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Iwan namejwan de pueblo de Capernaum, ¿ankiyejyekoaj anyaskej ilwikak? ¡Pues amo! Namejwan anyaskej asta tliko. Porke tla in tlakaj de weyikan de Sodoma kitanij in milagrostin katlej amejwan ya ankitakej, yon weyikan yeni asta axan. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero Nej namechilwia, nik itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), namejwan ankipiaskej okachi weyi tlajyowilistle ke nekatej tlakaj de región de Sodoma. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Itech yon tonale, Jesús okijtoj: ―Nimitzonweyikixtia Papan, tejwatzin titlanawatia itech ilwikak iwan ixko yin tlaltikpak. Nimitzweyikixtia porke otikchij amo ma kimomakakan kuenta tlan kijta motlajtol katlej momachiliaj wel kimatij iwan momachiliaj wel kuale intzontekon, iwan otikinmajsikamatiltij in tlakaj katlej mach moweyinekij. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ijkón otikchij, Papan, porke ijkón otikmonekiltij. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’NoPapan onechmaktilij nochi tlamantle. Iwan Nej niiKone mach akaj nechixmati, sino san yej noPapan nechixmati. Iwan mach akaj kixmati noPapan, sino san yen Nej niiKone nikixmati iwan noijki nekatej tlakaj katlej Nej nikneki ma kixmatikan noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xiwikikan nonawak, aminochtin namejwan katlej antekipanojtokej iwan antlamamajtokej itech tlajyowilistle de tlajtlakole, iwan Nej namechmakas nesewile. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xinechmokawilikan ma namechpalewi, iwan xinechmokawilikan ma namechmachti, porke Nej nipasensia iwan mach nimoweyinekke. Ijkón namejwan ankipiaskej nesewile ipan amoanima. ");
INSERT INTO nhyNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porke in tekitl katlej namechmaka mach tesotlaj. Iwan in tlamachtile katlej moneki xikchiwakan yon kej se tlamamale katlej mach etik. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Itech nekatej tonaltin Jesús onejnentiaya kan toktok trigo itech weyi tonale. Imomachtijkawan Jesús opéj tiojsiwij iwan opéj kitekij trigo iwan opéj kikuaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nijkuak in fariseos ijkón okitakej, okilwijkej in Jesús: ―Xikita, momomachtijkawan kitekij in trigo iwan axan weyi tonale, iwan tlanawatile de Moisés kijta mach se ma kichiwa yon itech weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero Jesús okinmilwij: ―¿Amo keman ankileroaj tlan okichij in rey David nijkuak in yej iwan ikompañeroswan otiojsijkej? ");
INSERT INTO nhyNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","David okalakke ikalijtik in Dios iwan okikuaj in pan katlej tlatiochiwaloj, katlej mach oyeka para kikuanij in David iwan ikompañeroswan, sino san yejwan tiopixkej welis kikuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O noso amo keman ankileroaj tlan kijta itlanawatil in Moisés, nik in tiopixkej tekipanoaj itech weyi tiopan iwan amo mosewiaj itech weyi tonale, iwan yon mach tlajtlakole? ");
INSERT INTO nhyNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero Nej namechilwia nik in Nej akin axan nian nikaj okachi niweyikistok (niweyititok) ke yon weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Namejwan mach ankimomakaj kuenta tlan kijta in tiotlajkuilole: “Nikneki xiteiknomatikan, mach nikneki xinechinmiktilikan yolkamej para ika annechweyikixtiskej.” Tla amejwan ankimomakanij kuenta, mach ankintlajtlakolmakanij in tlakaj katlej mach kipiaj tlajtlakole. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Porke Nej katlej onimochij nitlakatl, Nej nikpia de nikijtos tlanon moneki se kichiwas itech weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Satepan, Jesús oyáj de ompa iwan okalakke itech se tiopan de yen judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Iwan ompa oyeka se tlakatl katlej omawakke. In fariseos okitemoliayaj in Jesús itlaj tlan ika welis kitilwiskej, iwan okitlajtlanijkej: ―¿Kox techkawilia itlanawatil in Moisés ma tikpajtikan se kokoxke itech weyi tonale? ");
INSERT INTO nhyNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús okinnankilij: ―Tla se de amejwan kipia se ichka iwan motepejxiwia ijtik kuyoktle itech weyi tonale, ¿amo anyaskej ankikixtitiwej? ");
INSERT INTO nhyNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pues, ¿amo okachi ipatij se tlakatl ke se ichka? Por yonik, welis tikchiwaskej itlaj tlan kuale itech weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tonses in Jesús okilwij in tlakatl katlej omawakke: ―Xikmelawa moma. Iwan nijkuak okimelaj, opajtik ima iwan omokaj ya kuale ken oksé ima. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","In fariseos okiskej de itech intiopan, iwan opéj motlatlalwiaj para kimiktiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nijkuak Jesús okimatke, oyáj de ompa, iwan miekej tlakaj oyajkej Iwan. Jesús okinpajtiaya nochtin in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Iwan okinnawatiaya amakaj itlaj ma kilwikan akin Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ijkón otlapanok para ma mochiwa tlan okijtoj in profeta Isaías, nijkuak okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yin yej notekipanoj, katlej Nej onikpejpenke, katlej Nej niktlasojtla iwan nipaki por Yej. Niktlalis noEspíritu itech Yej, iwan kinmatiltis nochtin in tlakaj de ixko yin tlaltikpak ke kada se tlakatl nikixkomakas según tlan okichij. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Mach momagatinemis, nion mach tzajtzitinemis, nion mach akaj kikakis itlajtol ipan ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kipias kuale iyolo para nekatej katlej mach chijchikawakej, iwan kinpalewis katlej yakin mewaj, asta ijkuak ma mochiwa nochi tlan kuale ken Yej kineki. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iwan nochtin in tlakaj de ixko yin tlaltikpak kichiaskej momakixtiskej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Satepan okiwikilijkej in Jesús se tlakatl katlej kipia se ejekatl mach kuale, iwan noijki mach tlachia iwan nontzin. Jesús okipajtij in tlakatl iwan ya owelik otlachixke iwan ya owelik otlajtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nochtin in tlakaj sa otlajtlachixkej (omomajmawtijkej), iwan okijtojkej: ―¿Kox yen yin ikone in David katlej Dios okijtoj techwaltitlanilis? ");
INSERT INTO nhyNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero nijkuak in fariseos ijkón okikakej, okijtojkej: ―Yin tlakatl kinkixtia in ejekamej mach kualtin ika ipoder in Beelzebú, in tlayekanke demonio. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús okimatia tlan okiyejyekoayaj, iwan okinmilwij: ―Tla in tlakaj de se país pewas momijmiktiskej entre yejwan mismo, yon país tlajtlamis. Iwan tla in tlakaj de se pueblo o noso de se familia sa tekitl pewas momagaskej, no mach wejkawitl yeskej san sekan. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijkón noijki, tla Satanás kikixtis in Satanás, kijtosneki yej mismo momaga. Ipoder mach wejkawas iwan niman pojpoliwis. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Namejwan ankijtaj ke Nej nikinkixtia in ejekamej mach kualtin ika ipoder in Beelzebú. Tla ijkón yeni, ¿tonses akin kinmaka poder namomomachtijkawan para kinkixtiaj in ejekamej mach kualtin? Yejwan kiné ma kijtokan kox melawak o noso amo tlan namejwan annechilwiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero Nej nikinkixtia in ejekamej mach kualtin ika ipoder iEspíritu in toTajtzin Dios, iwan yon kijtosneki nik in Dios ya pewa tlanawatia amonawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Welis akaj kalakis ichan se tlakatl katlej chikawak iwan kichtekilis tlan kipia, in tla amo achtoj kijilpia? Solamente tla kijilpis welis kitlachtekis. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Akin amo kajki nowan, kajki kontra Nej. Iwan akin amo nowan kinpixka animajtin, san kinmamayawi. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Por yonik namechilwia, nik in Dios kintlapojpolwis in tlakaj de nochi tlajtlakole iwan de nochi tlan amo kuale kijtoskej, pero tla tlapoaskej biero de yen Espíritu Santo, Dios mach kintlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iwan tla akaj tlajtos kontra Nej katlej onimochij nitlakatl, Dios welis kitlapojpolwis, pero akin tlajtos biero de yen Espíritu Santo, Dios mach kitlapojpolwis, nion axan ixko yin tlaltikpak iwan nion satepan nijkuak yopanok in yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Se katlej kuale kuawitl, kitemaka itlakilo kuale. Iwan tla in kuawitl mach kuale, noijki kitemaka itlakilo mach kuale. Porke in kuawitl moixmati por yen itlakilo. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Namejwan kej ankoamej! Mach ankualtin, ¿kenik welis ankijtoskej itlaj tlan kuale? Porke tlan kijta se tlakatl ika iten kisa de tlan tentok ipan iyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Se kuale tlakatl kijta tlan kuale porke ipan iyolo onkaj tlan kuale, iwan se tlakatl mach kuale kijta tlan amo kuale porke ipan iyolo onkaj tlan amo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pero Nej namechilwia ke itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), nochtin namejwan ankitemakaskej kuenta de nochi tlajtole tlan amo kuale katlej ankijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ijkón kiné, ika namotlajtol katlej kuale mach amechtlajtlakolmakaskej, pero ika namotlajtol katlej mach kuale ika amechtlajtlakolmakaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ijkuakón sekimej fariseos iwan tlamachtijkej de itlanawatil in Moisés, okilwijkej in Jesús: ―Tlamachtij, tiknekij tikitaskej xikchiwa se milagro kej se señas nik in Tej melawak tiwitz de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús okinnankilij: ―Namejwan mach ankualtin iwan mach ankitlakitaj in Dios. Iwan axan ankinekij ma nikchiwa se milagro para annechneltokaskej. Pero mach namechmakas oksé milagro, sino san yen milagro tlan opanok in profeta Jonás. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Porke ijkón ken Jonás oyeka eyi tonale iwan eyi yuale ijtik se weyi michin, ijkón noijki in Nej katlej onimochij nitlakatl nietos ijtik tlale eyi tonale iwan eyi yuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","In tlakaj de Nínive omoyolkuepkej nijkuak in Jonás okintlapowij de itlajtol in Dios. Iwan itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos) yejwan kinmixkomakaskej in tlakaj de yin tiempo, porke mach omoyolkuepkej, maski onikintlapowij de itlajtol in Dios, iwan Nej okachi niweyikistok (niweyititok) ke Jonás. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Iwan in reina katlej owalaj de ik tlani kan okachi wejka de ixko yin tlaltikpak para kikakilis iixtlamachilis in rey Salomón, yej noijki itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos) kinmixkomakas in tlakaj de yin tiempo, porke mach kinekij nechkakiliskej, iwan Nej okachi niweyikistok (niweyititok) ke Salomón. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Nijkuak se ejekatl mach kuale kisa de itech se tlakatl, nemi kan tlawaki kitemojtinemi kan mosewis. Iwan tla amo kajsis, kimolwia: ");
INSERT INTO nhyNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nimokuepas oksemi itech nekáj tlakatl kan onikiske.” Iwan nijkuak walmokuepa, kajsitajsi in yon tlakatl kej se kale kan mach akaj chanti, tlachipawkan iwan tlayektlalitok. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Satepan yawi kinnotzatij oksekimej chikomen ejekamej okachi bierojkej ke yej, iwan nochtin yawij mochantitiwej itech yon tlakatl, iwan satepan yon tlakatl mokawa okachi pior ke antes. Ijkón noijki mochiwaskej in tlakaj katlej mach kualtin de yin tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús ok okintlapowijtoka in tlakaj, iwan ijkuakón oejkokej imaman iwan ikniwan. Omokajkej kalan, iwan okinekiaj motlapowianij Iwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ijkuakón se tlakatl okilwij in Jesús: ―Momaman iwan mokniwan katej kalan mitznotzaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Yej okinankilij: ―¿Akin nomaman, iwan akinmej nokniwan? ");
INSERT INTO nhyNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ijkuakón Jesús okinmajpilwij imomachtijkawan, iwan okijtoj: ―Yinmej yejwan nomaman iwan yejwan nokniwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porke akin kichiwa tlan kimonekiltia noPapan katlej kajki ilwikak, yen yon nokni tlakatl, yen yon nokni siwatl, iwan yen yon nomaman. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Yon tonale Jesús okiske kalijtik iwan omotlalito itempan lago. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iwan komo omololojkej miekej tlakaj kan Yej oyeka, okachi kuale in Jesús otlejkok itech se barko iwan ompa ipan omotlalij, iwan nochtin in tlakaj omokajkej atlatentle. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ijkuakón okinmachtij miek tlamantle ika ejemplos. Okijtoj: ―Se tlakatl okiske otookato. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Iwan nijkuak otookatoka, sekin semiya owetzke ipan ojtle. Tonses owalajkej in totomej iwan okikuajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Oksekin semiya owetzke ijtik teyoj, kan mach oyeka miek tlale. Yon semiya okiske totoka porke mach wejkatlan oyeka in tlale. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero nijkuak okiske in tonale, okichichinoj, iwan komo mach okipiaya wejkatlan inelwayo, owakke. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Oksekin semiya owetzke itzalko in bierojxiwitl, omoskaltij okachi miek yon bierojxiwitl, iwan tlatoktle oxiwmikke. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero oksekin semiya owetzke kan kuale tlale, iwan otlakke. Sekin tlatoktle okitemakak san de se semiya se siento itliolo, iwan oksekin okitemakak eyinpoale itliolo, iwan oksekin okitemakak senpoale iwan majtlaktle itliolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Tla ankinekij ankimomakaskej kuenta, xikkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tonses imomachtijkawan in Jesús omijkuanijkej inawak iwan okitlajtlanijkej: ―¿Tlanik tikintlapowia in tlakaj ika ejemplos? ");
INSERT INTO nhyNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yej okinnankilij: ―Namejwan Dios amechkawilia xikmatikan tlan oyeka tlatitok de kenik Dios tlanawatia ompa ilwikak. Pero Dios mach kinkawilia yejwan ma kimatikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Porke akin kinekis moskaltis okachi itech itlajtol in Dios, moskaltis okachi. Iwan katlej amo kinekis, kipolos asta tlan ya kimati. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Por yonik nikintlapowia ika ejemplos, porke maski kitaj tlan nikchiwa iwan maski kikakij tlan nikijta, yejwan mach kimomakaj kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ijkón, mochiwa itech yejwan tlan okijtoj in profeta Isaías: Namejwan ika amotlakakilis antlakakiskej, pero mach itlaj ankimomakaskej kuenta. Ika amoixtololowan antlachiaskej, pero mach ankimatiskej tlanon kijtosneki tlan ankitaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porke in yinmej tlakaj wel oyoltlakuawakej, yejwan omonakastzajtzakej, iwan omoixtzajtzakej para amo tlachiaskej ika inmixtololowan, iwan nion amo kinekij tlakakiskej ika intlakakilis, nion mach itlaj kinekij kimomakaskej kuenta ipan inyolo, iwan nion mach kinekij moyolkuepaskej nonawak para ma nikinmakixti. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Pero namejwan xipakikan, porke antlachiaj ika amoixtololowan, iwan ankimatij tlan kijtosneki tlan ankitaj. Iwan ankimomakaj kuenta tlan ankikakij nikijta. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ipan melajka namechilwia, ke miekej profetajtin iwan miekej tlakaj katlej kualtin de nekáj tiempo okinekiaj kitaskej iwan kikakiskej tlan namejwan axan ankitaj iwan ankikakij, pero mach okitakej iwan nion mach okikakej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Xikkakikan kiné tlan kijtosneki in ejemplo de yen tlatookak. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Katlej okikakej in tlajtole de kenik in Dios tlanawatia, iwan amo kimomakaj kuenta, yonmej ken semiya katlej owetzke ipan ojtle. Witz in Amo Kuale Tlakatl iwan kinkixtilia in tlajtole katlej omotookak ipan inyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","In semiya katlej owetzke ijtik teyoj, kijtosneki in tlakaj katlej kikakij in tlajtole iwan niman kiresibiroaj ika pakilistle, ");
INSERT INTO nhyNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero komo mach wejkatlan monelwayotiaj, niman nelwayowakij. Iwan nijkuak pewa trabajojpanoaj o noso pewa kintlatlalochtiaj por yen itlajtol in Dios, walmosotlawaj iwan kikawaj in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","In semiya katlej owetzke itzalko in bierojxiwitl, kijtosneki yejwan katlej kikakij itlajtol in Dios, pero sa tekitl tlanemiliaj itech tlamantin de yin nemilistle iwan kinkajkayawa in rikojyotl. Nochi in yin tlamantle kijyomiktia itlajtol in Dios katlej omotookak ipan inyolo, iwan mach tlakij. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero in semiya katlej omotookak kan kuale tlale, kijtosneki yejwan katlej kikakij itlajtol in Dios iwan kimomakaj kuenta, iwan kitemakaj miek tlakilotl. Iwan sekimej san de se semiya kitemakaj se siento intliolo, sekimej kitemakaj eyinpoale intliolo, iwan sekimej kitemakaj senpoale iwan majtlaktle intliolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús okinmilwij oksé ejemplo, okijtoj: ―Iwan ixko yin tlaltikpak kan Dios tlanawatia no ijkón ken se tlakatl katlej okitookak kuale semiya itlalaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero nijkuak in tlaltekowaj iwan itekipanojkej okochtokaj, owalaj in tlakatl katlej kikokolia in tlaltekowaj iwan okitookak xiwitl mach kuale kan toktok trigo, iwan oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nijkuak in trigo omoskaltij iwan omiawatik, ijkuakón oneske noijki in mach kuale xiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Tonses in tekipanojkej oyajkej okilwitoj in tlaltekowaj: “Señor, tla tejwatzin otiktookak kuale semiya, ¿de kan okiske kiné, in mach kuale xiwitl?” ");
INSERT INTO nhyNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Pero yej okinmilwij: “Se katlej nechkokolia ijkón okichij.” In tekipanojkej okitlajtlanijkej: “¿Tikneki ma tiwian ma tikwiwitlatij in mach kuale xiwitl?” ");
INSERT INTO nhyNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero yej okinmilwij: “Amo, porke tla ankiwiwitlaskej in mach kuale xiwitl, welis noijki ankiwiwitlaskej in trigo. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Okachi kuale xikkawakan ma moskaltikan san sekan asta ijkuak se kololos. Iwan ijkuakón nikintitlanis sekimej tekipanojkej para achtoj ma kololokan in mach kuale xiwitl iwan ma kimanojoijilpikan para kichichinoskej. Iwan satepan nikinmilwis ma kololokan in trigo para niktlaatis ijtik nokueskon.” ");
INSERT INTO nhyNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús noijki okintlalilij yin ejemplo: ―Kan Dios tlanawatia yon noijki ken iyolo in mostaza katlej se tlakatl kitooka itlalaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Iwan iyolo in mostaza yen okachi tzikitzin de nochtin semiyas. Pero nijkuak moskaltia, yen moskaltia okachi weyi tlatoktle iwan motlami weyi kuawitl, ke asta in totomej motepajsoltiaj ipan imamayo. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Noijki okinmilwij in yin ejemplo: ―Kan Dios tlanawatia yon noijki ken levadura para pan katlej se siwatl kineloa ika eyi tlatamachiwale de arina, para kisamawas nochi in yon tixtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nochtin in yinmej tlamantin Jesús okinmilwij in tlakaj ika ejemplos. Iwan nochipa nijkuak okintlapowiaya, okintlapowiaya ika ejemplos. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Para ma mochiwa tlan okijtoj in profeta: Nitlapoas ika ejemplos. Nikinmijtos tlamantin katlej mach akaj kinmati desde ijkuak in Dios okichij in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tonses in Jesús okinmakaj in tlakaj iwan okalakke kalijtik, kan imomachtijkawan omijkuanijkej inawak iwan okitlajtlanijkej: ―Xitechtomili in ejemplo de yen mach kuale xiwitl katlej okiske itzalko in trigo. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ijkuakón Jesús okinmilwij: ―Nej katlej onimochij nitlakatl, yen Nej in nekáj tlakatl katlej okitookak in kuale semiya. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Iwan notlalaj, yen tlaltikpak. In kuale semiya, yejwan in tlakaj katlej kipiaskej parte kan Dios tlanawatia. In mach kuale semiya, yejwan in tlakaj katlej kinnawatia in Amo Kuale Tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Iwan in tekokolij de yen tlaltekowaj katlej okitookak in mach kuale xiwitl, yen diablo. Iwan nijkuak kololoskej in trigo, yen yon kijtosneki nijkuak tlamis in tlaltikpak. Iwan katlej kololoaj in trigo, yejwan in angelestin. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ijkón ken mowiwitla in mach kuale xiwitl iwan mochichinoa ijtik tlitl, ijkón noijki yetos nijkuak tlamis in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nej katlej onimochij nitlakatl nikualintitlanis noangelwan kan katej noaxkawan, para ma kinkixtikij nochtin katlej tetlajtlakolmayajkej iwan katlej kichiwaj tlan mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iwan kintlamotlaskej ijtik tliko, kan chokaskej iwan motlanteteyitzaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iwan katlej kichiwaj tlan Dios kineki, petlaniskej ken tonale ompa kan tlanawatia inPapan. Akin kineki kimomakas kuenta, ma kikaki. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’In tlakatl katlej kikawilia in Dios ma kinawati, yon ken se tlakatl katlej okajsik tomin tlalpachitok itech se tlale. Nijkuak okajsik in yon tomin, oksemi ompa okitlaatij. Iwan ika pakilistle oyáj ichan, iwan okinamakak nochi tlan kipia. Iwan okikoj in yon tlale kan okajsik in tomin tlalpachitok. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Noijki, in tlakatl katlej kikawilia in Dios ma kinawati, no ken se tlasemanke kintemojtinemi perlas patiojkej, ");
INSERT INTO nhyNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","iwan nijkuak kajsi se perla katlej patíoj, yawi ichan, iwan kinamaka nochi tlan kipia, iwan kikowa yon perla. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Kan Dios tlanawatia yon noijki ken se michmatlatl katlej kitlamotlaj ijtik atl iwan kinmololoa nochi tlatlamantle de michimej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nijkuak temi in michmatlatl, in michmajkej kikixtiaj atlatentle, iwan ompa motlaliaj kinpejpenaj in michimej. In michimej katlej kualemej kintlaliaj ijtik chikiwitl, iwan katlej mach kualemej kintlamotlaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ijkón yetos noijki nijkuak tlamis in tlaltikpak. Kisaskej in angelestin iwan kinxeloskej in tlakaj katlej mach kualtin de intech in tlakaj katlej kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Iwan kintlamotlaskej in tlakaj katlej mach kualtin ijtik tliko, kan chokaskej iwan motlanteteyitzaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tonses Jesús okintlajtlanij: ―¿Ankimomakaj kuenta namejwan nochi in yin tlamantle? Yejwan otlanankilijkej: ―Aján, Señor, tikmomakaj kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ijkuakón okinmilwij: ―Nijkuak se tlamachtij itech tlanawatile de Moisés momachtia kenik in Dios tlanawatia, weli tlamachtia ika yankuik tlamachtile iwan ika katlej mach ok yankuik. No ijkón ken se chanej katlej kimati kinkixtia de tlan kintlaatijtok ikalijtik, kinkixtia ikosaswan katlej yankuikej iwan katlej mach ok yankuikej. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nijkuak in Jesús otlanke okinmilwij in yinmej ejemplos, oyáj de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Iwan oajsito ipueblo. Ompa opéj tlamachtia itech tiopan, iwan tlakaj sa otlajtlachiayaj (omomajmawtiayaj), iwan okijtoayaj: ―¿Kan okikuito yin tlakatl nochi yin ixtlamachilistle? ¿Kenik weli kinchiwa in yinmej milagrostin? ");
INSERT INTO nhyNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Amo yen yin itelpoch in kuawxinke? ¿Amo imaman itoka María, iwan ikniwan intoka Jacobo, José, Simón, iwan Judas? ");
INSERT INTO nhyNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Amo nian chantij noijki in siwamej katlej ikniwan? ¿Kan okikuito kiné, nochi yin ixtlamachilistle? ");
INSERT INTO nhyNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iwan por yonik in tlakaj mach ok okiwelitakej, iwan mach ok okinekej okikakej. Pero Jesús okinmilwij: ―Akin tlapoa de Dios se kitlakitas ik nian nepa, menos itech ipueblo iwan itech ichan. ");
INSERT INTO nhyNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iwan mach okinchij miekej milagrostin ompa, porke yejwan mach otlaneltokakej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Itech nekatej tonaltin Herodes in tetrarca katlej oyeka gobernador de estado de Galilea, okikakke de tlan Jesús okichiwaya, ");
INSERT INTO nhyNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","iwan ijkuakón okinmilwij itekipanojkawan: ―Nekáj tlakatl yen Juan Tlakuateekij. Yomoyolkuik oksemi satepan de omikke, iwan por yonik kinchiwa wejweyin milagrostin. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes ijkón okijtoj, porke itech nekatej tonaltin yej otlanawatij ma kikitzkikan in Juan, ma kikadenaijilpikan iwan ma kitzakuakan telpiloyan. Ijkón okichij in Herodes porke okitlankuamotlatoka in Felipe maski oyeka ikni. In siwatl oyeka itoka Herodías. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Juan okilwiaya in Herodes: ―Tikchijtok se weyi tlajtlakole porke iwan tikaj mokoñada. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes okinekia kimiktiani in Juan, pero okinmiimakasia in tlakaj. Porke nochtin okimatiaj nik in Juan oyeka profeta de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero nijkuak okumpliroj xiwitl in Herodes, ichpoch in Herodías omijtotij inmixpan nochtin iinbitadoswan in Herodes, iwan Herodes sa tekitl okiwelitak. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iwan okilwij ipan melajka nik kimakas nochi san tlan yej kitlajtlanilis. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tonses in ichpochtle achtoj omotlapowij iwan imaman, iwan satepan okilwij in Herodes: ―Xinechmaka ika se plato itzontekon in Juan Tlakuateekij. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nijkuak ijkón okikakke in rey Herodes, omoyolkokoj, pero komo yokilwijka ipan melajka nik kimakas nochi san tlan kitlajtlanilis iwan inmixpan iinbitadoswan, tonses otlanawatij ma kimakakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iwan otlanawatij ma kikechtzontekikan in Juan ompa telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Iwan okualkuikej ika se plato itzontekon, iwan okimaktilijkej in ichpochtle, iwan yej okimakak imaman. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Satepan oejkokej imomachtijkawan in Juan, okitkikej itlalnakayo iwan oyajkej okitookatoj. Satepan oyajkej okimatiltitoj in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nijkuak in Jesús okimatke, oyáj de ompa iselti itech se barko, iwan oyáj se lugar kan tlalkawale kan mach akaj tlakatl nemi. Pero in tlakaj okimatkej, okiskej de inpueblojwan iwan oyajkej okajsitoj nejnentiwej. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nijkuak Jesús otemok de itech barko, okinmitak miekej tlakaj, iwan okinmiknomaj, iwan okinpajtij in kokoxkej katlej okualinwikayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nijkuak yopéj tiotlaki, imomachtijkawan in Jesús omijkuanijkej inawak, iwan okilwijkej: ―Yotiotlakik, iwan nian mach akaj chanti. Xikintitlani in tlakaj para ma wian ik pueblojtin, para ma kikowatij tlan kikuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús okinmilwij: ―Mach moneki ma wian. Namejwan xikintlamakakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Iwan yejwan okinankilijkej: ―Nian tikpiaj san makuile pan iwan ome michin. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iwan Jesús okinmilwij: ―Xinechinwalkuilikan nian. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ijkuakón Jesús otlanawatij ma motlalikan in tlakaj kan xiwyoj. Satepan okitilanke in makuile pan iwan ome michimej, oajkopantlachixke omotlasojkamatke inawak Dios, iwan okipojpostekke in pan iwan okinmakak imomachtijkawan, iwan yejwan okinxejxelilijkej nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nochtin kuale otlakuajkej asta oixwikej. Satepan okintemitijkej majtlaktle iwan ome chikimej de pantlapojpostektle iwan michintlakojkotonale de katlej osobraroj. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Iwan katlej otlakuajkej oyekaj kej makuile mil tlakaj, mach okinpojkej in siwamej nion pilalaktin. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Satepan Jesús okinnawatij imomachtijkawan ma tlejkokan itech barko para ma panokan oksé lado de yen lago ma sa tlayekanakan, mientras in Yej ok okinmakawaya in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iwan satepan de okinmakaj, Jesús otlejkok itech se tepetl omotiotzajtzilito iselti. Nijkuak owaltlatleyuak, Jesús ompa oyeka iselti. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","In barko yoyaya tlatlajko lago. In atl omajkokuia ipan barko porke in ejekatl inpan oyaya. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Iwan san kualkan ok otlatleyuatoka, Jesús okinmajsito nejnentiw ipan atl. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iwan nijkuak imomachtijkawan okitakej nejnentiw ipan atl, omomawtijkej iwan otzajtzikej: ―¡Se temawtij! ");
INSERT INTO nhyNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús okinnotzke, iwan okinmilwij: ―Amo ximomawtikan, Nej niJesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ijkuakón Pedro otlanankilij, okijtoj: ―Señor, tla yen tejwatzin, xikchiwa ma ninejnemi ipan atl asta kan tejwatzin tikaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Iwan Jesús okilwij: ―Xiwiki kiné. Ijkuakón Pedro otemok de itech barko iwan opéj nejnemi ipan atl para yas kinamikitij in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero nijkuak okimomakak kuenta nik wel chikawak ejeka, omomawtij. Iwan komo opéj apolaki, otzajtzik: ―¡Señor, xinechmakixti! ");
INSERT INTO nhyNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","San niman Jesús okimakitzkij, iwan okilwij: ―Wel tzikitzin motlaneltokalis. ¿Tlanik mach otinechneltokak? ");
INSERT INTO nhyNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Iwan nijkuak otlejkokej itech barko, in ejekatl omoketzke. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ijkuakón katlej oyekaj itech barko omotlankuaketzkej iyakapan Jesús iwan okiweyikixtijkej, okijtojkej: ―Melawak nik tejwatzin titeKone de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Satepan de otlankej opanokej de itech yon lago, oajsitoj itech tlale de Genesaret. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nijkuak in tlakaj de yon lugar okixmatkej nik yen Jesús, oyajkej okitematiltitoj itech nochi yon región, iwan okualinwikilijkej nochtin kokoxkej kan Yej oyeka. ");
INSERT INTO nhyNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Okitlatlawtiayaj ma kinkawili ma kikitzkilikan itzotzol maski san yen itempantzin. Iwan nochtin katlej okikitzkilijkej itzotzol, opajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ijkuakón sekimej fariseos iwan tlamachtijkej de itlanawatil in Moisés katlej owalajkej de Jerusalén, omijkuanijkej inawak Jesús, iwan okitlajtlanijkej: ");
INSERT INTO nhyNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Tlanik momomachtijkawan mach kitlakitaj in kostumbres katlej otechkajtewilijkej in ya wejkawitl toweyitajwan? Porke mach momajtekiaj nijkuak tlakuaj ken otechmachtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iwan Jesús okintlajtlanij: ―¿Tlanik namejwan noijki mach ankitlakitaj itlanawatil in Dios iwan yej okachi ankitlakitaj namokostumbre? ");
INSERT INTO nhyNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Porke in Dios okijtoj: “Xiktlakita mopapan iwan momaman”, iwan “Akin biero kitenewilis ipapan o noso imaman, ma kimiktikan.” ");
INSERT INTO nhyNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero namejwan ankijtaj ke se tlakatl welis kilwis ipapan o noso imaman: “Mach welis nimitzpalewis ika tlan mitzpoloa, porke tlan nikpia yonikmaktilij in Dios.” ");
INSERT INTO nhyNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Namejwan ankijtaj ke mach ok moneki se kinpalewis in tetajmej. Ijkón namejwan ankijtlakoaj itlanawatil in Dios porke ankichiwaj yej tlan de amejwan amokostumbre. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Teixkajkayajkej! Yompa tlan okijtoj in profeta Isaías de amejwan, nijkuak okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Yinmej tlakaj nechtlakitaj san ika inten, pero inyolo kajki wejka de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","San tekitl nechweyikixtiaj, tlamachtiaj ika intlayejyekolis in tlakaj kej yeskia itlanawatil in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ijkuakón Jesús okinnotzke in tlakaj, iwan okinmilwij: ―Xikkakikan iwan xikmomakakan kuenta tlan namechilwis: ");
INSERT INTO nhyNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tlan kalaki ijtik iten se tlakatl mach yon kiyolsokiotia. Sino kiyolsokiotia yen tlan kisa de ijtik iten. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ijkuakón imomachtijkawan omijkuanijkej inawak Jesús, iwan okitlajtlanijkej: ―¿Tikmati nik in fariseos okualankej nijkuak okikakej tlan otikijtoj? ");
INSERT INTO nhyNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero Yej okinnankilij: ―NoPapan katlej kajki ilwikak, kiwiwitlas ika nochi inelwayo nochi tlatoktle katlej mach okitookak. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xikinkawakan. Porke in yonmej fariseos katej kej yeskia mach tlachiaj. Iwan tla se katlej mach tlachia kiyekanas oksé katlej noijki mach tlachia, san ken omen welis wetziskej ijtik se kuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedro otlanankilij okijtoj: ―Xitechtomili in yon ejemplo. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús okijtoj: ―¿Noijki mach ankimomakaj kuenta namejwan? ");
INSERT INTO nhyNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Amo ankimomakaj kuenta ke nochi tlan kalaki ijtik iten se tlakatl kalaki ijtik itlalax, iwan satepan kisa kalan? ");
INSERT INTO nhyNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero tlan kisa de ijtik iten se tlakatl, kisa de ijtik iyolo. Iwan yen yon kiyolsokiotia. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porke de ipan inyolo in tlakaj kisa in mach kuale tlayejyekolistle, temiktiaj, momekatiaj katlej tlanamiktiltin iwan katlej mach tlanamiktiltin, tlachtekij, tlakajkayawaj, iwan tewikaltiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yen yonmej tlamantin katlej kiyolsokiotia se tlakatl. Pero tla se tlakuas iwan mach se momajtekis, yon mach kiyolsokiotia in tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús okiske de ompa iwan oyáj ik región de Tiro iwan de Sidón. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Se siwatl cananea katlej ochantia itech yon región, owalaj kuawtzajtzitiwitz inawak Jesús. Okijtoj: ―¡Señor, tekone de David, xinechiknomati! Nochpoch kipia se ejekatl mach kuale iwan kitlajyowiltia. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús mach okinankilij. Ijkuakón imomachtijkawan omijkuanijkej inawak iwan okitlatlawtijkej, okilwijkej: ―Xiknawati in siwatl ma wia, porke kuawtzajtzitiwitz tokuitlapan. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tonses Jesús okilwij in siwatl: ―Dios mach onechwaltitlanke para ma nikinpalewi oksekimej tlakaj, sino san yen tlakaj de Israel, katlej katej kej ichkamej katlej mopolojtokej. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero in siwatl omijkuanij inawak iwan omotlankuaketzke iyakapan, okilwij: ―Señor, xinechpalewi. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iwan Jesús okilwij: ―Mach kuale kaj tla yej namejwan namechmakas tlan kintokaroa in judiojtin. Porke yon kej yeskia niktlamaka se chichij ika intlakual ikonewan in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero in siwatl okijtoj: ―Aján, Señor. Pero noijki in chichimej kikuaj in tlakualpayextle katlej tepewi itlampa mesa nijkuak tlakuaj intekowan. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijkuakón Jesús okilwij: ―Siwatl, sa tekitl weyi motlaneltokalis. Ma mochiwa ijkón ken tej tikneki. Iwan san niman ijkuakón yon ichpoch opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús okiske de ompa iwan oyáj itempan lago de Galilea. Satepan otlejkok ipan se tepetl iwan ompa omotlalij. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Miekej tlakaj oajsitoj kan Jesús oyeka, ompa okinwikilijkej katlej koxomej, katlej mach tlachiaj, katlej nontzitzintin, katlej matepomej, iwan miekej oksekimej kokoxkej okachi. Okintlalijkej ikxitlan Jesús, iwan Yej okinpajtij. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iwan in tlakaj sa otlajtlachiayaj (omomajmawtiayaj), nijkuak okinmitayaj in nontzitzintin opéj tlajtoaj, nijkuak in matepomej okisaya oksé yankuik inma, nijkuak in koxomej ya kuale onejnemiaj, iwan nijkuak ya kuale otlachixkej katlej mach otlachiayaj. Iwan opéj kiweyikixtiaj in toTajtzin Dios de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ijkuakón Jesús okinnotzke imomachtijkawan, iwan okinmilwij: ―Nikinmiknomati in yinmej tlakaj, porke ya kipia eyi tonale katej nian nowan iwan mach itlaj kipiaj tlan kikuaskej. Mach nikneki nikintitlanis inchan ma tiojsijtiwian, porke welis kuatleyuiliskej ipan ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tonses imomachtijkawan okilwijkej: ―Nian mach akaj chanti, ¿kan tikkixtiskej tanto pan para tikintlamakaskej asta achinmej tlakaj? ");
INSERT INTO nhyNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús okintlajtlanij: ―¿Keski pan ankipiaj? Iwan yejwan okinankilijkej: ―Chikome pan iwan kanaj keskimej michimej. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tonses Jesús otlanawatij ma motlalikan in tlakaj ipan tlale. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Okintilanke in chikome pan iwan michimej, iwan omotlasojkamatke inawak Dios. Satepan okikojkotonke in pan iwan michimej iwan okinmajmakak in imomachtijkawan, iwan yejwan okinxejxelilijkej nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nochtin otlakuajkej asta oixwikej. Iwan asta okintemitijkej chikome chikimej de yen pedasos katlej osobraroj. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iwan tlakaj katlej otlakuajkej oyekaj kej nawi mil tlakaj, mach okinpojkej in siwamej nion pilalaktin. ");
INSERT INTO nhyNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Satepan Jesús okinmakaj in tlakaj, otlejkok itech barko iwan oyáj itech región de Magdala. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Oejkokej in fariseos iwan saduceos para kitlajtlakolmayawiskej in Jesús, iwan okitlajtlanilijkej ma kichiwa se milagro kej se señas para kitaskej kox melawak in Yej witz de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Yej okinnankilij: ―Nijkuak tiotlaki, namejwan ankijtaj: “Yetos kuale tiempo, porke tlachichiliwia ik ilwikak.” ");
INSERT INTO nhyNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iwan nijkuak tlanesi ankijtaj: “Axan yetos mach kuale tiempo porke tlachichiliwia iwan tlamixtemi.” ¡Teixkajkayajkej! Namejwan kuale ankixyejyekoaj tlan ankitaj itech ilwikak pero mach ankixyejyekoaj nochi tlan ankitaj tlan tlamochijtok itech yin tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Namejwan mach ankualtin iwan mach ankitlakitaj in Dios. Iwan axan ankinekij ma nikchiwa se milagro para annechneltokaskej. Pero mach namechmakas oksé milagro, sino san yen milagro tlan opanok in profeta Jonás. Jesús ompa okinkajtej iwan oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nijkuak in momachtijkej opanokej oksé lado de yen lago, okelkajkej de kitkinij in pan. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ijkuakón Jesús okinmilwij: ―Ximotlachilikan de yen inlevadura in fariseos iwan saduceos. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Imomachtijkawan opéj kimolwiaj entre yejwan: ―Ijkón techilwia porke mach otikualkuikej in pan. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús okimomakak kuenta, iwan okinmilwij: ―¿Tlanik ankimolwiaj ke mach ankipiaj pan? Namejwan wel tzikitzin namotlaneltokalis. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ayamo ankimomakaj kuenta, iwan nion mach ok ankelnamikij de yen makuile pan katlej onikinxejxelilij in makuile mil tlakaj, iwan keski chikiwitl osobraroj? ");
INSERT INTO nhyNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Iwan nion mach ok ankelnamikij de yen chikome pan katlej onikinxejxelilij in nawi mil tlakaj, iwan keski chikiwitl ankololojkej de tlan osobraroj? ");
INSERT INTO nhyNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Kenik mach ankimomakakej kuenta nik in Nej mach onitlapoaya de yen pan, nijkuak onamechilwij ximotlachilikan de yen inlevadura in fariseos iwan saduceos? ");
INSERT INTO nhyNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ijkuakón imomachtijkawan okimomakakej kuenta nik in Jesús mach okinmilwiaya ma motlachilikan de yen ilevadura in pan, sino okinmilwij ma motlachilikan de yen intlamachtil in fariseos iwan saduceos. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nijkuak Jesús oajsito itech región kan kajki in weyikan de Cesarea de Filipo, ijkuakón okintlajtlanij imomachtijkawan: ―Nijkuak in tlakaj motlapowiaj de Nej katlej onimochij nitlakatl, ¿ken kijtaj? ¿Akin Nej? ");
INSERT INTO nhyNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Yejwan okijtojkej: ―Sekimej kijtaj tejwatzin tiJuan Tlakuateekij. Oksekimej kijtaj tejwatzin tiElías, iwan oksekimej kijtaj tejwatzin tiJeremías o noso akaj oksé profeta. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Iwan Yej okintlajtlanij: ―Iwan namejwan, ¿ken ankijtaj? ¿Akin Nej? ");
INSERT INTO nhyNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedro okinankilij: ―Tejwatzin tiCristo, titeKone de Dios katlej nochipa yolitok. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iwan Jesús okilwij: ―Xipaki tej, Simón, titekone de Jonás, porke mach akaj tlakatl mitzajsikamatiltia nik in Nej niCristo, sino yen noPapan katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iwan Nej noijki nimitzilwia nik in tej tiPedro (kijtosneki tetl), iwan itech yin tetl nikinnotzas notlaneltokawan. Porke tej otiknextij tlan melawak. Iwan nochtin katlej nechneltokaskej, kiresibiroskej tlan melawak. Iwan ipoder in mikilistle mach semi welis kintlanis. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iwan tej nimitzinmakas in yabejtin de ilwikak kan Dios tlanawatia para tikintlatlapolis in tlakaj. Iwan katlej tikijtos kipiaj intlajtlakol ixko yin tlaltikpak, ompa ilwikak in Dios noijki kijtos nik kipiaj intlajtlakol. Iwan katlej tikijtos mach kipiaj intlajtlakol ixko yin tlaltikpak, ompa ilwikak in Dios noijki kijtos nik mach kipiaj intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ijkuakón Jesús okinnawatij imomachtijkawan amakaj itlaj ma kilwikan kox yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ijkuakón Jesús opéj kinyekilwia imomachtijkawan, nik kipia de yas Jerusalén iwan kitlajyowiltiskej miek in tlayekankej tetajtzitzintin, in tlayekankej tiopixkej, iwan in tlamachtijkej de itlanawatil in Moisés. Iwan okinmilwij nik kimiktiskej, pero ipan eyi tonale moyolkuis (moyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tonses in Pedro okiwikak in Jesús ik se lado iwan opéj kajwa por ijkón okijtoj, okilwij: ―Amo Dios ma kimonekilti, Señor. Amo semi ijkón xipano de tlan tikijta. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús omokuepke iwan okilwij in Pedro: ―Xitzinkisa de Nej, Satanás. San tinechtzatzakuilia. Porke mach mitztekipachoa tlan Dios kineki, sino mitztekipachoa tlan kinekij in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Satepan Jesús okinmilwij imomachtijkawan: ―Tla akaj kineki witz nonawak, ma wiki kiné, pero moneki ayakmo ma kichiwa san tlan yej kinekis. Sino kipia de kixikos nochi san tlan panos, ma wiki nowan iwan maski ma kimiktikan itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Porke tla akaj kineki kipalewis inemilis, kipolos. Pero tla akaj kipolos inemilis por Nej, kipalewis inemilis. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mach itlaj ipatij tla se tlakatl kimoaxkatis nochi in tlaltikpak iwan satepan kipolos ianima. Porke mach itlaj onkaj ixko yin tlaltikpak tlan ika welis kitlaxtlawas para kipalewis ianima. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Porke Nej katlej onimochij nitlakatl niwitz ika imawisotlanex in noPapan iwan iangelwan, iwan ijkuakón kada se tlakatl niktlaxtlawis según tlan okichij. ");
INSERT INTO nhyNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ipan melajka namechilwia, ke sekimej tlakaj katlej nian katej, mach kixmatiskej in mikilistle asta amo ma nechitakan Nej katlej onimochij nitlakatl ma pewa nitlanawati. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Chikuasen tonale satepan, Jesús okiwikak in Pedro, in Jacobo iwan ikni itoka Juan, oyajkej itech se weyi tepetl. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jesús omoixpatlak ompa inmixpan. Ixko opetlanke ken tonale, iwan itzotzol opetlankaistayak ken tlanextle. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iwan owalmonextijkej in Moisés iwan Elías, motlapowijtokej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijkuakón Pedro okilwij in Jesús: ―Señor, sa kuale nian tikatej. Tla tikneki, nian ma tikinchiwakan eyi akawalkaltin, se para tejwatzin, se para Moisés, iwan se para Elías. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nijkuak ok otlapojtoka in Pedro, ijkuakón se mixtle okinkenke iwan omokakke se tlajtole de ijtik yon mixtle, okijtoj: ―Yen yin notlasojKone, akin inawak nipaki. Xikkakilikan itlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nijkuak ijkón okikakej, in momachtijkej omotlankuaketzkej asta okitennamikej in tlale, iwan sa tekitl omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ijkuakón Jesús omijkuanij innawak imomachtijkawan, okintlalij imawan inpan iwan okinmilwij: ―Ximoketzakan. Amo ximomawtikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iwan nijkuak otlajtlachixtewakej, mach ok akaj okitakej, sino sa yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nijkuak otemoayaj de ipan tepetl, Jesús okinnawatij: ―Amakaj itlaj xikilwikan de tlan ankitakej, asta ijkuak Nej katlej onimochij nitlakatl ma nimoyolkui oksemi de itech nomikilis. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tonses imomachtijkawan okitlajtlanijkej in Jesús: ―¿Tlanik kiné, kijtaj in tlamachtijkej de itlanawatil in Moisés nik in Elías yen kipia de witz achtoj antes de witz in Cristo? ");
INSERT INTO nhyNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús okinnankilij: ―Melawak, Elías achtoj witz, iwan yej kiyektlalis nochi. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero Nej namechilwia ke Elías yowitza, iwan yejwan mach okineltokilijkej iwan yej san tlan amo okitoktijkej. Iwan Nej katlej onimochij nitlakatl no ijkón nechtlajyowiltiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ijkuakón imomachtijkawan okimomakakej kuenta nik in Jesús okintlapowiaya de yen Juan Tlakuateekij. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nijkuak oajsitoj kan oyekaj in tlakaj, se tlakatl omijkuanij inawak Jesús omotlankuaketzke iyakapan, iwan okilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Señor, xikiknomati notelpoch, mimiki iwan sa tekitl panoa tekokojkayotl. Miekpa wetzi ijtik tlitl iwan ijtik atl. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nian onikinwalwikilij momomachtijkawan, pero mach welij kipajtiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nijkuak Jesús ijkón okikakke, okijtoj: ―¡Namejwan wel mach antetlakitakej iwan ankiyejyekoaj tlan mach kuale! ¿Asta keman nietos amowan? ¿Asta keman ijkón namechxikojtos? Xinechwalwikilikan nian in telpochtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ijkuakón Jesús okajwak in ejekatl mach kuale, iwan okiske de itech yon telpochtle. Iwan san niman ijkuakón opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Satepan imomachtijkawan omijkuanijkej inawak Jesús se lado, iwan okitlajtlanijkej: ―¿Tlanik in tejwan mach otiwelikej otikixtijkej in ejekatl mach kuale? ");
INSERT INTO nhyNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús okinmilwij: ―Porke amechpoloa miek tlaneltokalistle. Ipan melajka namechilwia, tla ankipiaskej tlaneltokalistle maski san ken se semiyajtzin de mostaza, anwelinij ankilwianij in yin tepetl: “Ximijkuani de nian iwan xiwia ik ne”, iwan in tepetl mijkuaniani. Nochi anwelinij ankichiwanij tla melawak namejwan ankipianij tlaneltokalistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero in yinmej ejekamej mach kualtin welis ankinkixtiskej tla anmotiotzajtziliskej iwan anmosawaskej (onmayunaroskej). ");
INSERT INTO nhyNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Se tonale, nijkuak ok oyekaj itech estado de Galilea, Jesús okinmilwij nik in Yej katlej omochij tlakatl kitemaktiskej (kitemaktiliskej) inmak in tlakaj katlej mach kualtin, ");
INSERT INTO nhyNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iwan nechmiktiskej, pero ipan eyi tonale nimoyolkuis (nimoyolitis). Iwan imomachtijkawan sa tekitl omoyolkokojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nijkuak Jesús iwan imomachtijkawan oajsitoj itech pueblo de Capernaum, katlej tlakobraroaj ika impuestos para in weyi tiopan omijkuanijkej inawak in Pedro, iwan okitlajtlanijkej: ―¿Namotlamachtij kox kitlaxtlawa impuesto para in weyi tiopan? ");
INSERT INTO nhyNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro otlanankilij: ―Kenik amo. Satepan nijkuak in Pedro okalakke kalijtik kan oyeka in Jesús, yen Jesús achtoj okilwij in Pedro: ―¿Ken tikita, Simón? In reytin de ixko yin tlaltikpak, ¿akinmej kinkobraroaj ika impuestos? ¿Kinkobraroaj katlej chantij itech se pueblo o noso katlej mach ompa chantij? ");
INSERT INTO nhyNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro okinankilij: ―Katlej mach ompa chantij. Jesús okilwij: ―Tonses kijtosneki in chanejkej mach kipiaj de kitlaxtlawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero maski amo tikpiaj de tiktlaxtlawaskej, iwan para amakaj ma kualani, xiwia kan lago, xikkajkawa moanzuelo ijtik atl, iwan in michin katlej achtoj tikixtis, xikkamachalolti iwan tikkajxilis se tomin, iwan ika xiktlaxtlawa in de Nej noimpuesto iwan de tej moimpuesto. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Itech yonmej tonaltin imomachtijkawan omijkuanijkej inawak Jesús iwan okitlajtlanijkej: ―¿Akin okachi weyikistok (weyititok) kan Dios tlanawatia? ");
INSERT INTO nhyNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ijkuakón Jesús okinotzke se chokotzin, okitlalij tlatlajko de kan yejwan oyekaj, ");
INSERT INTO nhyNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","iwan okijtoj: ―Ipan melajka namechilwia, tla namejwan amo anmoyolkuepaj iwan amo anmochiwaj ken pilalaktin, mach ankalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ijkón kiné, akin okachi weyikistok (weyititok) kan Dios tlanawatia, yen katlej moiknomati iwan mochiwa ken yin chokotzin. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Iwan akin kiresibiroa se chokotzin ken yin itech notoka, kijtosneki Nej nechresibiroa. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Tla akaj kitoktis ma wetzi ipan tlajtlakole se de yinmej tzitzikinmej katlej nechneltokaj, okachi kuale ma kilpilikan ikechtlan se metlatl iwan ma kiwitlazokan ijtik atl kan okachi tlawejkatlan. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Pobrestin tlaltikpaktlakaj! Porke sa tekitl onkaj tlan ika se wetzis ipan tlajtlakole. Nochipa ijkón yetos, pero ¡pobre in tlakatl katlej kitoktis akaj oksé ma wetzi ipan tlajtlakole! ");
INSERT INTO nhyNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Por yonik, tla moma o noso mokxi mitztoktia xiwetzi ipan tlajtlakole, okachi kuale xikinmotzontekili iwan wejka xikintlamotla. Porke okachi kuale xikalaki ilwikak timatepoj o noso tikoxo, ke ma mitztlamotlakan ijtik tlitl katlej mach keman sewis ika nochi ome momawan o noso ika nochi ome mokxiwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Iwan tla moixtololo mitztoktia xiwetzi ipan tlajtlakole, okachi kuale xikmokixtili. Porke okachi kuale xikalaki ilwikak ika se moixtololo, ke ika nochi ome moixtololowan ma mitztlamotlakan ijtik tliko kan xotlatok in tlitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Amo xikchiwakan menos se de yin achintzin. Porke ompa ilwikak iángel nochipa kajki ixpan noPapan katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Porke Nej katlej onimochij nitlakatl oniwalaj onikinmakixtiko katlej mopolojtinemij. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Kenamij ankitaj? Tla se tlakatl kinpia se siento ichkamej, iwan tla kipolos se, ¿amo kinkajtewas in nawinpoale iwan kaxtole iwan nawi ipan tepetl iwan yas kitemotij katlej opoliwik? ");
INSERT INTO nhyNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iwan tla kajsi, ipan melajka namechilwia ke okachi pakis por yon ichka, ke por nekatej in nawinpoale iwan kaxtole iwan nawi katlej mach okinpoloj. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ijkón noijki, namoPapan katlej kajki ilwikak mach kineki ma mopolo nion se de yinmej achintzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Tla se mokni omitztoktij itlaj amo kuale, xiknotza iselti iwan xikilwi tlan omitztoktij. Tla mitzkaki, kijtosneki yotikmotlanilij, porke oksemi anmowikaskej kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero tla amo mitzkaki, ijkuakón xiknotza se o kanaj omen tlaneltokakej, para ke nochi tlan mijtos ma kimatikan omen o noso eyin testigojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Iwan tla nion yejwan mach kinkaki, ijkuakón xikinmilwi nochtin in tiopantlaneltokakej. Iwan tla nion yejwan noijki mach kinkaki, tonses xikitakan yon tlakatl kej se katlej mach kineltoka Dios o noso kej se katlej tlakobraroa ika impuestos. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Ipan melajka namechilwia, ke nochi katlej tikijtos kipiaj intlajtlakol ixko yin tlaltikpak, ompa ilwikak in Dios noijki kijtos nik kipiaj intlajtlakol. Iwan katlej tikijtos mach kipiaj intlajtlakol ixko yin tlaltikpak, ompa ilwikak in Dios noijki kijtos nik mach kipiaj intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Noijki namechilwia, tla omen de amejwan anmotlaliskej san se tlajtole ixko yin tlaltikpak para ankitlajtlaniskej itlaj ika tiotzajtzilistle, noPapan katlej kajki ilwikak amechmakas. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Porke kan mololoaj omen o noso eyin katlej nechneltokaj, Nej noijki ompa inwan nikaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ijkuakón Pedro omijkuanij inawak Jesús iwan okitlajtlanij: ―Señor, ¿keski buelta niktlapojpolwis se nokni tla onechtoktij itlaj mach kuale? ¿Asta chikome buelta? ");
INSERT INTO nhyNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús okinankilij: ―Mach nimitzilwia xiktlapojpolwi san chikome buelta, sino asta eyinpoale iwan majtlaktle de chikome buelta, in tej moneki nochipa xiktlapojpolwi. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Por yonik, kan Dios tlanawatia yon ken se rey katlej okinekke kichiwas kuenta iwan itekipanojkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Iwan nijkuak opéj kichiwa kuenta, okualwikilijkej se itekipanoj katlej okiwikiliaya miek miyones de tomin. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Komo itekipanoj mach okipiaya tomin para kikuepilis, ijkuakón in rey otlanawatij ma kinamakakan yon tlakatl iwan isiwa, iwan ipilwan, iwan nochi tlan kipia, para ika ma kitlaxtlawa tlan kitewikilia. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ijkuakón itekipanoj omotlankuaketzke iyakapan rey iwan okitlatlawtij: “Señor, nimitztlatlawtia xinechonchia ok keski tonale iwan nimitzkuepilis nochi tlan nimitzwikilia.” ");
INSERT INTO nhyNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","In rey okiknomatke, okitlapojpolwij de nochi tlan okiwikiliaya iwan okikajkaj ma wia. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero niman nijkuak in yon tlakatl okiske, okinamikke se ikompañero noijki tekipanoj de yen rey, katlej okiwikiliaya kanaj kexkich tomin. Okikechkitzkij iwan opéj kikechpatzka, iwan okilwij: “¡Xinechkuepili tlan tinechwikilia!” ");
INSERT INTO nhyNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tonses ikompañero omotlankuaketzke iyakapan iwan okitlatlawtij, okilwij: “Nimitztlatlawtia xinechonchia ok keski tonale, iwan nimitzkuepilis nochi tlan nimitzwikilia.” ");
INSERT INTO nhyNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero yej mach okinekke kichias, sino yej okiwikak okitzakuato telpiloyan para ma kikuepili nochi tlan kiwikilia. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nijkuak oksekimej itekipanojkawan in rey ijkón okitakej, sa tekitl omoyolkokojkej. Iwan oyajkej okilwitoj in rey nochi tlan okitakej otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ijkuakón in rey otlanawatij ma kinotzatij yon itekipanoj, iwan okilwij: “Tej mach tikuale tinotekipanoj. Nej onimitztlapojpolwij de nochi tlan otinechwikiliaya, porke otimotlatlawtij nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tej noijki omonekia tikiknomatini mokompañero, ijkón ken nej onimitziknomatke.” ");
INSERT INTO nhyNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","In rey sa tekitl okualanke, iwan otlanawatij ma kitlajyowiltikan asta kan ma kitlaxtlawa nochi tlan kitewikilia. ");
INSERT INTO nhyNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Satepan de ijkón okinmilwij, in Jesús okijtoj: ―NoPapan katlej kajki ilwikak, no ijkón kitoktis akin amo kinekis kitlapojpolwis se ikni ika nochi iyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nijkuak Jesús otlanke okijtoj yin tlajtole, ijkuakón okiske de estado de Galilea iwan oyáj itech estado de Judea, ik ne lado de yen weyatl Jordán ik ikisayan tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sa tekitl miekej tlakaj ikuitlapan oyajkej, iwan ompa okinpajtij in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ijkuakón sekimej fariseos omijkuanijkej inawak Jesús para kitlajtlakolmayawiskej, iwan okitlajtlanijkej: ―¿Kox kuale kajki in se tlakatl kikawas isiwa san ika itlaj tzikitzin? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús okinnankilij: ―¿Amo ankileroaj in tiotlajkuilole kan kijta nijkuak in Dios opéj kichiwa in tlaltikpak, iwan ijkuakón noijki okinchij in tlakatl iwan siwatl? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iwan noijki kijta in tiotlajkuilole: “Por yonik in tlakatl kikawas ipapan iwan imaman para mosetilis iwan isiwa, iwan de omen, mochiwas sa se tlakatl.” ");
INSERT INTO nhyNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mach ok yeskej omen, sino sa se. Por yonik, katlej Dios yokinsetilij mach kipia de kinxeelos akaj tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tonses okitlajtlanijkej: ―¿Tlanik kiné, Moisés okitekawilij tla akaj tlakatl kineki mosiwakawas, moneki kimakas isiwa se amatl kan ma kijto nik mosiwakawa? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús okinmilwij: ―Moisés okitekawilij se tlakatl ma mosiwakawa, porke mach itlaj ankinekij ankimomakaskej kuenta de tlan kuale. Pero achtoj mach ijkón oyeka. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nej namechilwia, tla se tlakatl kikawa isiwa, iwan monamiktis iwan akaj oksé siwatl, kijtosneki iwan momekatia. Pero tla isiwa kichiwa tlajtlakole de momekatia iwan akaj tlakatl, tonses iokich welis kikawas in yon isiwa. Iwan tla akaj monamiktis iwan yon siwatl katlej yokikajkajkej, kijtosneki no iwan momekatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ijkuakón imomachtijkawan okilwijkej: ―Tla melawak mach kuale se mokajkawas iwan isiwa, okachi kuale mach akaj ma monamikti. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús okinmilwij: ―Mach nochtin welij kimomakaj kuenta yin tlajtole, sino sanwel nekatej katlej Dios kinpalewia ma kimomakakan kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Katej sekimej tlakaj katlej mach monamiktiaj porke desde intlakatilis otlakatkej mach welis kinpiaskej inkonewan. Sekimej mach monamiktiaj porke okintoktijkej amo ma welikan ma kinpiakan inkonewan. Iwan sekimej mach kinekij monamiktiskej porke kitemoaj kenik okachi kuale kitekipanoskej in Dios. Akin kinekis yetos iselti, ma yeto kiné iselti. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Satepan okualinwikilijkej in Jesús sekimej pilalaktin, para inpan ma kintlali imawan, iwan para ma tiotzajtzi por yejwan. Pero imomachtijkawan opéj kinmajwaj katlej okualinwikayaj in pilalaktin. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús okinmilwij: ―Xikinkawakan in pilalaktin ma wikikan nonawak, amo xikintzatzakuilikan. Porke in tlakaj katlej yolyamankej ken pilalaktin, kalakiskej ilwikak kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jesús okintlalij imawan inpan pilalaktin, iwan satepan oyáj de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Se tlakatl omijkuanij inawak Jesús iwan okitlajtlanij: ―Tlamachtij, tejwatzin wel tikuale tlakatl. ¿Tlan welis itlaj kuale nikchiwas para nikpias nemilistle katlej mach keman tlamis? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús okilwij: ―¿Tlanik tinechilwia nikuale tlakatl? Mach onkaj oksé kuale tlakatl, sino san yen Dios. Pero tla tikneki tikalakis ilwikak, moneki xikintlakita itlanawatilwan in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iwan tlakatl okilwij in Jesús: ―¿Katlij yejkej tlanawatiltin? Iwan Jesús okilwij: ―Amo xitemikti, amo ximomekati, amo xitlachteki, amakaj xiktlajtoltlatlalili, ");
INSERT INTO nhyNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","xikintlakita mopapan iwan momaman, iwan xiktlasojtla mokni ken tej timotlasojtla. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iwan yon tlakatl okilwij: ―Nochi yon nikchijtiwitz desde nitzikitzin. ¿Tlan oksé nechpoloa nikchiwas? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús okilwij: ―Tla tikneki tietos entero tikuale tlakatl, xiwia mochan iwan xiknamaka nochi tlan tikpia iwan tomin xikinmaka katlej pobrestin. Ijkón welis tikpias rikojyotl ompa ilwikak. Iwan ijkuakón kemaj xiwiki iwan xinemi nowan. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero in tlakatl nijkuak ijkón okikakke, oyáj omoyolkokojtiaj, porke sa tekitl okimopialiaya. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ijkuakón Jesús okinmilwij imomachtijkawan: ―Ipan melajka namechilwia, nik sa tekitl owij para katlej kimopialiaj kalakiskej ilwikak kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Oksemi namechilwia, ke okachi mach owij para se kameyo panos kan kuyontok in akuxaj ke para se katlej kimopialia kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Imomachtijkawan sa otlajtlachixkej (omomajmawtijkej) nijkuak ijkón okikakej, iwan okimolwiayaj entre yejwan: ―¿Akin kiné welis momakixtis? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús okintlatak, iwan okinmilwij: ―Yin tlamantle in tlakaj mach welij kichiwaj, pero Dios nochi weli kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tonses in Pedro okilwij: ―Señor, tejwan otikwalkajtejkej nochi tlan otikpiayaj porke tiknekij tiaskej mowan. ¿Tlan tikkajsiskej kiné? ");
INSERT INTO nhyNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús okinankilij: ―Ipan melajka namechilwia, itech nekatej tonaltin nijkuak nochi moyankuilis, nijkuak Nej katlej onimochij nitlakatl nimotlalis itech nosiya katlej kipia weyi imawisotlanex, namejwan noijki katlej nowan anwalajkej anmotlaliskej noijki ipan majtlaktle iwan ome siyajtin, para ankinmixkomakaskej in majtlaktle iwan ome familias de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iwan akinmej okiwalkajtejkej inkal, inmikniwan okichtin o noso siwamej, inpapan, inmaman, insiwa, inpilwan, o noso intlal, por Nej, kiresibiroskej sien buelta okachi de tlan okikajtejkej, iwan noijki Dios kinmakas nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero miekej yeskej salúltimo katlej axan katej achtoj, iwan yeskej achtoj katlej axan katej salúltimo. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Porke ompa ilwikak kan Dios tlanawatia yon ken se tlaltekowaj, katlej okiske kualkan okintemoto sekimej tlapalewijkej para kitekiskej uvas. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Iwan omokajkej kintlaxtlawis se denario tomin por se tonale. Iwan okintitlanke ma tekipanotij itlalaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Satepan in tlaltekowaj okiske kej las nuebe de kualkan, iwan okinmitak itech tiankistle oksekimej tlapalewijkej katlej omajxilijtokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iwan okinmilwij: “Xiwian namejwan noijki xitekipanotij notlalaj, iwan namechtlaxtlawis ijkón ken moneki ankitlaniskej.” Iwan yejwan oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","In tlaltekowaj oksemi okiske kej tlajko tonale, iwan noijki kej las tres de tiotlakke, okintemoto oksekimej tlapalewijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Iwan kej las sinko de tiotlakke, oksemi oyáj itech tiankistle iwan okinmajsik oksekimej tlapalewijkej katlej omajxilijtokaj, iwan okinmilwij: “¿Tlanik nian antleyuilijkej iwan mach antekipanoaj?” ");
INSERT INTO nhyNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Yejwan okinankilijkej: “Porke mach akaj techtlakewa.” Ijkuakón in tlaltekowaj okinmilwij: “Namejwan xiwian noijki xitekipanotij notlalaj, iwan namechtlaxtlawis ijkón ken moneki ankitlaniskej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nijkuak otleyuak, in tlaltekowaj okilwij itekipanoj katlej kita in tekitl: “Xikinnotza in tlapalewijkej iwan xikintlaxtlawi, achtoj xikintlaxtlawi katlej okalakej satepan, iwan satepan xikintlaxtlawi katlej achtoj okalakej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tonses oejkokej in tlapalewijkej katlej okalakej kej las sinko de tiotlakke, iwan kada se de yejwan okitlaxtlawijkej se denario tomin. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iwan nijkuak okintokaroto kintlaxtlawiskej in tekipanojkej katlej achtoj okalakej, okiyejyekojkej kintlaxtlawianij okachi. Pero noijki okintlaxtlawijkej kada se de yejwan se denario tomin. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pero nijkuak okintlaxtlawijkej, opéj kixnamikij in tlaltekowaj, ");
INSERT INTO nhyNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","iwan okilwijkej: “Nekatej katlej okalakej satepan otekipanojkej san se ora, iwan otikintlaxtlawij no ken tejwan.” ");
INSERT INTO nhyNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Pero in tlaltekowaj okinankilij se de yejwan: “Amigo, mach nimitztoktia itlaj tlan amo kuale. ¿Amo otimokajkej ke nimitztlaxtlawis se denario tomin por tinechpalewis? ");
INSERT INTO nhyNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xikitzki motlaxtlawil iwan xiwia. Nej nikneki nikmakas katlej okalakke satepan noijki ken tej onimitzmakak. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Amo welis nikchiwas san tlan nej niknekis ika notomin? ¿O noso timoxikoa por wel nikuale tlakatl?” ");
INSERT INTO nhyNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Ijkón kiné, miekej katlej axan katej salúltimo, yeskej achtoj. Iwan katlej axan katej achtoj, yeskej salúltimo. Porke Dios kinnotza miekej tlakaj pero san sekimej kinpejpena para ma yekan iaxkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nijkuak Jesús yoyaya para Jerusalén, okinwikak ik se lado in majtlaktle iwan ome imomachtijkawan iwan okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Axan tejwan tiawij Jerusalén. Iwan Nej katlej onimochij nitlakatl nechtemaktiskej (nechtemaktiliskej) inmak in tlayekankej tiopixkej iwan inmak in tlamachtijkej de itlanawatil in Moisés. Iwan yejwan nechtlajtlakoltiskej para ma nechmiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nechtemaktiskej inmak in tlakaj katlej mach judiojtin para ma nechpijpinatikan, para ma nechwitekikan iwan para ma nechmajmasoltikan itech krus. Pero ipan eyi tonale nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ijkuakón isiwa in Zebedeo, omijkuanij inawak Jesús inwan omen itelpokawan, omotlankuaketzke iyakapan para kitlajtlanilis se favor. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús okilwij: ―¿Tlan tikneki? In tenan okijtoj: ―Nimitztlatlawtia xitlanawati ma motlalikan in yinmej notelpokawan, se ik moyekma iwan oksé ik moopochma, nijkuak tejwatzin pewas titlanawatis. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero Jesús okinankilij: ―Namejwan mach ankimatij tlan ankitlajtlanij. Jesús okintlajtlanij itelpokawan in yon tenan: ―¿Kox welis namejwan ankixikoskej anpanoskej ken tlan Nej nipanos? ¿Kox welis anmokuateekiskej ika tekokojkayotl katlej ika nimokuateekis? Iwan yejwan okijtojkej: ―Tiweliskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús okinmilwij: ―Ipan melajka, namejwan anpanoskej ken Nej nipanos, iwan anmokuateekiskej ika tekokojkayotl katlej ika nimokuateekis. Pero tla anmotlaliskej ik noyekma o noso ik noopochma, mach Nej nikijtos, sino noPapan kintlalis ompa katlej Yej yokinpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","In oksekimej majtlaktin momachtijkej nijkuak ijkón okikakej, okualankej innawak in yonmej omen iknimej. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús okinnotzke, iwan okinmilwij: ―Namejwan kuale ankimatij ke akinmej mochiwaj gobiernojtin de se país, tlanawatiaj ika miek tlanawatile. Iwan tlakaj katlej okachi weyikistokej (weyititokej), yejwan okachi tlanawatiaj chikawak itech se pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero namejwan mach ijkón xiekan, sino tla se de amejwan kineki weyikistos, kipia por kintekichiwilis in oksekimej. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Iwan akin kineki tlayekantos de yen namejwan, kipia por kintekichiwilis nochtin in oksekimej, ");
INSERT INTO nhyNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ijkón ken Nej katlej onimochij nitlakatl mach oniwalaj para ma nechpalewikan, sino Nej oniwalaj para nitlapalewis iwan para niktemakas nonemilis, iwan ijkón niktlaxtlawas para nikinmakixtis miekej de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nijkuak yejwan yokistiayaj de itech weyikan de Jericó, miekej tlakaj oyajkej ikuitlapan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Omen tlakaj katlej mach tlachiaj oewatokaj ipan ojtle, iwan nijkuak okikakej nik in Jesús opanoaya ik ompa, otzajtzikej chikawak okijtojkej: ―Señor, iKone in David, xitechiknomati. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","In tlakaj okinmajwakej para ayakmo ma tzajtzikan, pero yejwan okachi otzajtzikej chikawak: ―Señor, iKone in David, xitechiknomati. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ijkuakón Jesús omoketzke, okinnotzke in omen tlakaj katlej mach tlachiaj, iwan okintlajtlanij: ―¿Tlan ankinekij ma namechtokti? ");
INSERT INTO nhyNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tonses yejwan okilwijkej: ―Señor, tiknekij titlachiaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús okinmiknomatke, okintlalij imawan ipan inmixtololowan, iwan san niman ijkuakón ya kuale otlachixkej, iwan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nijkuak oajsitoj itech pueblo de Betfagé, inakastlan Olivostepetl mach ok wejkatzin de Jerusalén, ijkuakón Jesús okintitlanke omen imomachtijkawan ");
INSERT INTO nhyNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iwan okinmilwij: ―Xiwian itech nekáj pueblo katlej kajki tlayakapan. Ompa ankajsitiwej se burra ilpitok iwan ikone. Xikintotomakan iwan xinechinwalwikilikan. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Iwan tla akaj itlaj amechilwis, xikilwikan nik in Señor kinneki, iwan san niman amechinkawiliki. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ijkón otlapanok para ma mochiwa tlan okijtoj in profeta: ");
INSERT INTO nhyNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xikinmilwikan in tlakaj de Sión: “Xikita, moRey walmuika monawak, pasensiatzin, yetiwitz ipan se burrajtzin, ipan ikone in burra katlej tlamama.” ");
INSERT INTO nhyNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ijkuakón imomachtijkawan oyajkej iwan okichijkej ijkón ken Jesús okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Okualwikakej in burra iwan ikonetzin, iwan okinkentilijkej intlakenwan inpan iwan Jesús otlejkok ipan burra. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Iwan tlakaj, sa tekitl miekej oyekaj, okinsojsojkej intlakenwan ipan ojtle, iwan oksekimej okisojsojkej ixiwyo in kuanmej. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","In tlakaj katlej oyayaj tlayakapan iwan katlej oyayaj tlakuitlapan, otzajtziaj okijtoayaj: ―¡Hosana! ¡Oejkok iKone in rey David! ¡Ma Dios kitiochiwa katlej okiwaltitlanke para tlanawatis! ¡Hosana! ¡Ma weyijkatlalito in toTajtzin Dios katlej kajki ilwikak! ");
INSERT INTO nhyNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nijkuak Jesús okalakke itech weyikan de Jerusalén, nochtin oyomonkej iwan otlajtlaniaj: ―¿Akin yin tlakatl? ");
INSERT INTO nhyNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Iwan tlakaj okijtoayaj: ―Yin yen Jesús, in profeta de pueblo de Nazaret, de estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Satepan Jesús okalakke ijtik weyi tiopan de Dios, iwan okinkixtij nochtin katlej ompa otlanamakatokaj iwan otlakojtokaj. Okintlatlamochilij inmesajwan in tominpatlakej, iwan okintlatlamochilij insiyajwan in palomasnamakakej. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iwan okinmilwij: ―Itech tiotlajkuilole kijta: “Nokal kinotzaskej kale de tiotzajtzilistle”, pero namejwan ya ankikuepkej se kale de ichtekej. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ompa ijtik in weyi tiopan omijkuanijkej inawak Jesús sekimej tlakaj katlej mach tlachiaj iwan sekimej koxomej, iwan Jesús okinpajtij. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero in tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés, sa tekitl okualankej nijkuak okitakej in milagrostin katlej Jesús okinchiwaya, iwan nijkuak okinkakej kenik in pilalaktin otzajtziaj chikawak ijtik in weyi tiopan, nijkuak okijtoayaj: “¡Hosana! ¡Oejkok iKone in David!” ");
INSERT INTO nhyNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ijkuakón okilwijkej in Jesús: ―¿Tikkaki tlan kijtaj in yinmej pilalaktin? Iwan Jesús okinnankilij: ―Aján, nikinkaki. ¿Amo semi ankileroaj in tiotlajkuilole kan tlapoa de yon tlajtole? Kan kijta: Otikchij ke in pilalaktin iwan konemej katlej ok chiichij, ma mitztlakuikilikan ika melajka kuale weyikixtilistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ijkuakón Yej okinkajtej, okiske de itech yon weyikan, iwan oyáj itech pueblo de Betania iwan ompa omokaj yon yuak. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","In kualkan, nijkuak Jesús yomokuepaya para Jerusalén, otiojsij. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Okitak ipan ojtle se igoskuawitl, omijkuanij kan oyeka yon kuawitl, pero mach itlaj igos okajsik, sino okipiaya san puro ixiwyo. Ijkuakón, Jesús okilwij in igoskuawitl: ―Mach ok semi xitlaki. Iwan san niman ijkuakón in igoskuawitl owakke. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nijkuak imomachtijkawan ijkón okitakej, sa otlajtlachixkej (omomajmawtijkej) iwan okitlajtlanijkej in Jesús: ―¿Kenik in igoskuawitl owakke san niman? ");
INSERT INTO nhyNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús okinnankilij: ―Ipan melajka namechilwia, tla ankipiaj tlaneltokalistle iwan amo anmoijtitlapowiskej, amo san yen igoskuawitl welis ankiwatzaskej, sino asta welis ankilwiskej yin tepetl: “Ximijkuani de nian iwan ximotlamotla ijtik atl”, iwan ijkón tlapanos. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tla amejwan ankineltokaj nik in Dios amechmakas nochi tlan ankitlajtlaniliskej, tonses xikmatikan nik in Dios melawak amechmakas nijkuak anmotiotzajtziliskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iwan ijkuakón Jesús okalakke ijtik in weyi tiopan, iwan mientras otlamachtijtoka, ijkuakón omijkuanijkej inawak in tlayekankej tiopixkej iwan tlayekankej tetajtzitzintin judiojtin, iwan okitlajtlanijkej: ―¿Ika tlan tlanawatijkayotl tikchiwa nochi yin tlamantle tlan tikchijtinemi? ¿Akin omitzmakak yon tlanawatijkayotl? ");
INSERT INTO nhyNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús okinnankilij: ―Nej noijki namechtlajtlanis se tlajtole, tla namejwan annechnankiliskej, tonses Nej noijki namechilwis ika tlan tlanawatijkayotl nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Akin okinawatij in Juan ma tlakuateeki? ¿Yen Dios okinawatij, o noso yen tlakaj okinawatijkej? Iwan opéj kimolwiaj entre yejwan, okijtoayaj: ―Tla tikijtoskej yen Dios okinawatij, techilwis: “¿Tlanik mach ankineltokakej?” ");
INSERT INTO nhyNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Iwan tla tikilwiskej ke okinawatijkej in tlakaj, kualaniskej nochtin. Tejwan tikinmiimakasij in tlakaj porke nochtin kimatij nik in Juan oyeka profeta. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tonses okinankilijkej in Jesús: ―Mach tikmatij akin okinawatij. Ijkuakón Jesús noijki okinmilwij: ―Pues Nej noijki mach namechilwis ika tlan tlanawatijkayotl nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús okinmilwij: ―¿Kenamij ankiyejyekoaj yin ejemplo? Se tlakatl okinpiaya omen itelpokawan. Omijkuanij inawak se, iwan okilwij: “Nokone, xiwia xitekipanoti axan itech nouvasyoj.” ");
INSERT INTO nhyNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Itelpoch okinankilij: “Mach nias.” Pero satepan okipatlak itlayejyekol iwan oyáj otekipanoto. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","In tetaj omijkuanij inawak oksé itelpoch, iwan noijki okilwij ma wia ma tekipanoti itech iuvasyoj, iwan itelpoch okinankilij: “Kuale kajki, nias.” Pero mach oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Katlij yen de yonmej omen okichij tlan okinekia in tetaj? Yejwan okijtojkej: ―Yen katlej achtoj okinawatij. Tonses in Jesús okinmilwij: ―Ipan melajka namechilwia, ke katlej tlakobraroaj ika impuestos iwan siwamej momekatijkej, yejwan achtoj kalakiskej kan Dios tlanawatia iwan namejwan satepan. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Porke Juan owalaj oamechmatiltiko kenik welis anmoyolkuepaskej inawak Dios, iwan namejwan mach ankineltokakej. Pero katlej tlakobraroaj ika impuestos iwan siwamej momekatijkej, yejwan okineltokakej. Pero namejwan maski ankitakej nik in yejwan omoyolkuepkej, namejwan mach anmoyolkuepkej iwan nion mach ankineltokakej tlan oamechilwij in Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xikkakikan yin oksé ejemplo: Oyeka se tetaj katlej ouvastookak. Okikorraltij ika kuawitl. Okichij se tanke para ompa kipatzkas uvas, iwan okichij se torre wejkapan para ipan tlejkos para kimonekuitlawis iuvasyoj. ’Satepan okinkajtewilij sekimej tekipanojkej para ma kimonekuitlawikan iwan satepan kimokawiskej tlaatlajko de tlan kisas, iwan yej oyáj wejka itech oksé país. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nijkuak oajsik in tonale para uvastekiskej, ijkuakón okintitlanke sekimej itekipanojkawan para ma kikuitij tlan kitokaroa. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero in tekipanojkej okinkitzkijkej iwan okinmagakej itekipanojkawan in tlaltekowaj. In se okimagakej, in se okimiktijkej, iwan oksekimej okinmojmotlakej ika tetl. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","In tlaltekowaj oksemi okintitlanke oksekimej itekipanojkawan, okachi miekej ke achtoj. Pero in tekipanojkej no ijkón okintoktijkej ken katlej achtoj okintitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Salúltimo okititlanke ikone, iwan okimolwij: “Kitlakitaskej in nokone.” ");
INSERT INTO nhyNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero nijkuak okitakej ikone, in tekipanojkej okimolwijkej entre yejwan: “Yin ikone yen kimokawis in tlale. Ma tikmiktikan, iwan tejwan tikmoaxkatiskej itlal.” ");
INSERT INTO nhyNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ijkuakón kiné, okikitzkijkej, okikixtijkej de itech yon uvasyoj, iwan okimiktijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Nijkuak witz in tlaltekowaj de yon uvasyoj, ¿tlan kintoktis in yonmej tekipanojkej katlej okinkajtewilij iuvasyoj? ");
INSERT INTO nhyNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Okilwijkej: ―Kinmiktis in yonmej tekipanojkej mach kualtin, iwan mach kinmiknomatis. Iwan satepan kinmaktilis iuvasyoj oksekimej tekipanojkej, katlej kimakaskej tlan kitokaros nijkuak ajsis tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tonses Jesús okintlajtlanij: ―¿Amo semi ankileroaj in tiotlajkuilole? In tiotlajkuilole ijkín kijta: In tetl katlej in kalchijkej mach okixitakej, omochij yen tetl katlej okachi kichikajtok in kale. Yin tetl owalaj de yen toSeñor iwan tejwan tikmotetzawiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Por yonik namechilwia, nik namejwan mach ok amechtokaros anyeskej kan Dios tlanawatia, sino kintokaros in tlakaj katlej kitemakaskej in tlakilotl katlej Dios kineki. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Iwan akin wetzis ipan yon tetl, kipojpostekis. Iwan tla yon tetl wetzis ipan akaj, sa tekitl kikuejkuechos. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nijkuak in tlayekankej tiopixkej iwan fariseos okinkakej yonmej ejemplos katlej Jesús okinmijtoj, okimomakakej kuenta nik yejwan okimilwijtoka. ");
INSERT INTO nhyNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ijkuakón okinekiaj kikitzkianij in Jesús, pero okinmiimakaskej in tlakaj, porke in tlakaj okineltokayaj nik in Jesús Yej se profeta. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús oksemi opéj kintlapowia ika ejemplos, okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Kan Dios tlanawatia yon ken se rey katlej okichij se ilwitl nijkuak okinamiktij itelpoch. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","In rey okintitlanke itekipanojkawan ma kinnotzatij iinbitadoswan, pero iinbitadoswan mach okinekej oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","In rey oksemi okintitlanke oksekimej itekipanojkawan, okinmilwij: “Xikinmilwikan noinbitadoswan, in tlakuale yokualtik. Notorojwan iwan noyolkawan katlej tojtomawakej yonikinmiktij, iwan nochi ya tlayektlalitok. Ma wikikan ilwitl.” ");
INSERT INTO nhyNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero iinbitadoswan mach okichijkej kuenta. Se oyáj otekipanoto itlalaj, se oyáj otlasemanato, ");
INSERT INTO nhyNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","iwan oksekimej okinkitzkijkej itekipanojkawan in rey, okinmagakej iwan okinmiktijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ijkuakón in rey sa tekitl okualanke, iwan okintitlanke isoldadojwan para ma kinmiktitij katlej otemiktijkej iwan para ma kinchichinilikan inpueblo. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Tonses okinmilwij itekipanojkawan: “In tlakuale yokualtik para yen ilwitl, pero nochtin katlej onikinminbitaroj mach okintokaroaya para witzej porke mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xiwian ipan ojtle iwan xikinminbitarokan nochtin akinmej ankinmajsiskej, ma wikikan nian itech ilwitl kan monamiktiaj.” ");
INSERT INTO nhyNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ijkuakón itekipanojkawan in rey oyajkej ipan ojtle iwan okinmololojkej nochtin katlej okinmajsikej, katlej mach kualtin iwan katlej kualtin. Iwan ijkón in kalijtik otenke de tlakaj itech yon ilwitl kan monamiktiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Ijkuakón in rey okalakke kalijtik para kinmitas katlej inbitadostin, okitak ompa oyeka se tlakatl katlej mach omotzotzoltij ken omonekia motzotzoltiani para yon ilwitl kan monamiktiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iwan rey okitlajtlanij: “Amigo, ¿kenik otikalakke nian iwan mach otimotzotzoltij ken moneki para tietos itech yin ilwitl kan monamiktiaj?” Pero in tlakatl mach okinankilij. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tonses in rey okinmilwij katlej otlaserbirojtokaj: “Xikijilpikan itech ikxiwan iwan itech imawan, iwan xiktlamotlakan kalan ijtik tlatleyualotl, kan chokas iwan motlanteteyitzas.” ");
INSERT INTO nhyNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Porke Dios kinnotza miekej tlakaj pero san sekimej kinpejpena para ma yekan iaxkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ijkuakón in fariseos oyajkej, iwan omotlatlalwijkej kenik kimayawiskej in Jesús ika itlaj tlajtole para ika kitilwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","In fariseos okintitlankej sekimej intekipanojkawan iwan sekimej itekipanojkawan in Herodes, para ma kitlajtlaniitij in Jesús: ―Tlamachtij, tikmatij nik tejwatzin tikijta tlan melawak, iwan titlamachtia ipan melajka kenik se nemis ken Dios kineki, iwan mach timotekawilia akaj ma mitzkajkayawa, porke mach tikita akin tejwan kox tirikojtin o noso tipobrestin. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Xitechilwi kiné, kenamij tikyejyekoa: ¿Kox kuale se kitlaxtlawas impuestos para César o noso amo? ");
INSERT INTO nhyNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesús okimatia nik mach kuale tlan yejwan okiyejyekoayaj, iwan okinmilwij: ―¿Tlanik ankinekij annechmayawiskej ika itlaj tlajtole? Namejwan san anteixkajkayajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xinechititikan se tomin katlej ika motlaxtlawa impuesto. Yejwan okimakakej se denario tomin. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ijkuakón Jesús okintlajtlanij: ―¿De akin ixko in yin iwan de akin itoka katlej nian ijkuilitok? ");
INSERT INTO nhyNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Okinankilijkej: ―De César. Iwan Jesús okinmilwij: ―Xikmakakan in César tlan de yen César, iwan xikmakakan Dios tlan de yen Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Nijkuak ijkón okikakej, sa otlajtlachixkej (omomajmawtijkej). Satepan okikajtejkej iwan oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Itech yon tonale noijki, in saduceos omijkuanijkej inawak Jesús, katlej kijtaj mach melawak moyolkuiskej (moyolitiskej) in mikkamej. Iwan okitlajtlanijkej: ");
INSERT INTO nhyNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tlamachtij, Moisés okijtoj tla se tlakatl yomonamiktij iwan miki iwan mach okinpixke ipilwan, in ikni in yon difunto kipia de monamiktis iwan viuda para kinpialis ipilwan in ikni in difunto. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ijkón kiné, nian entre tejwan oyekaj chikomen iknimej. In tetiachka achtoj omonamiktij, iwan omikke. Komo amo okinpixke ipilwan, okajtej isiwa para ikni. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","No ijkón omochij ikni katlej kiwaltoka, iwan satepan no ijkón omochij in oksé katlej kiwaltoka, iwan ijkón omochijkej san ken nochtin chikomen iknimej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iwan satepan de omijmikkej nochtin iknimej noijki omikke in siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tonses, itech nekáj tonale nijkuak moyolkuiskej (moyolitiskej) in mikkamej, ¿katlij yej de nochtin yonmej chikomen iknimej yetos isiwa? Porke nochtin omonamiktijkej iwan yon siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús okinnankilij: ―Namejwan mach ompa tlan ankijtaj, porke mach ankimomakaj kuenta in tiotlajkuilole nion mach ankimomakaj kuenta de ipoder in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porke nijkuak moyolkuiskej (moyolitiskej) in mikkamej, in tlakaj iwan siwamej mach monamiktiskej, sino yeskej kej angelestin de Dios ompa ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero ken ya timotlapowijtokej de yen mikkamej moyolkuiskej, ¿amo ankileroaj tlan Dios oamechilwij? Porke okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nej niDios de Abraham, de Isaac iwan de Jacob.” In Dios mach Dios de mikkamej, sino de katlej yolitokej. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","In tlakaj nijkuak ijkón okikakej, sa otlajtlachixkej (omomajmawtijkej) por yen itlamachtil in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nijkuak in fariseos okimatkej nik in Jesús okinkamatzakke in saduceos, ijkuakón yejwan omololojkej inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Iwan se de yejwan katlej tlamachtij itech tlanawatile de Moisés, okitlajtlanij para kitlajtlakolmayawis: ");
INSERT INTO nhyNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tlamachtij, ¿katlij yen tlanawatile okachi weyi de nochtin in tlanawatiltin? ");
INSERT INTO nhyNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús okilwij: ―“Xiktlasojtla in Señor moDios ika nochi moyolo, ika nochi moanima, iwan ika nochi motlalnamikilis.” ");
INSERT INTO nhyNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yen yin tlanawatile okachi weyi iwan yen tlayekantok. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iwan onkaj oksé tlanawatile, ikniyo: “Xiktlasojtla mokni ken tej timotlasojtla.” ");
INSERT INTO nhyNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Yinmej omen tlanawatiltin kijtosneki yen nochi tlan kijta itlanawatil in Moisés iwan nochi tlan kijta intlamachtil in profetajtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Iwan mientras ok oololitokaj in fariseos, Jesús okintlajtlanij, ");
INSERT INTO nhyNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","okinmilwij: ―¿Tlan ankiyejyekoaj namejwan de yen Cristo? ¿De akin iKone? Yejwan okilwijkej: ―De yen rey David. ");
INSERT INTO nhyNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tonses Jesús okinmilwij: ―Tla namejwan ijkón ankiyejyekoaj, tonses, ¿tlanik kiné in David ika Espíritu Santo okinotzke “noSeñor”? Porke David okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","In toTajtzin Dios okilwij in noSeñor yin tlajtole: “Ximotlali ik noyekma, asta ijkuak Nej nimitztlalis titlayekanke de yejwan katlej mitzkokoliaj.” ");
INSERT INTO nhyNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ijkón kiné, tla David okinotzke “noSeñor”, ¿kenijki kiné ma yeto ikone? ");
INSERT INTO nhyNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iwan mach akaj owelik okinankilij nion se tlajtole, iwan desde yon tonale nion se mach ok omixewij ok itlaj okitlajtlanij. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ijkuakón Jesús okinmilwij in tlakaj iwan imomachtijkawan: ");
INSERT INTO nhyNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―In tlamachtijkej de itlanawatil in Moisés iwan fariseos motlaliaj para amechmachtiskej ken otlamachtij in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ijkón, nochi tlan amechilwiskej xikneltokakan iwan xikchiwakan. Pero amo xikchiwakan tlan yejwan kichiwaj, porke yejwan mach kichiwaj tlan kijtaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Porke yejwan kintoktiaj in tlakaj ma kinmamakan miekej tlanawatiltin, katlej sa tekitl owijtitok para se kinxikos. Pero yejwan nion siera ika se inmajpil mach kinekij kajkokuiskej yon tlamamale. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Teixkajkayawaj kichiwaj tlan kuale para ma kinmitakan. Noijki teixkajkayawaj ke yolchipawakej, kitkij wejweyin textos de tiotlajkuilole ijtik kajajtzitzintin de kuetlaxtle iwan kimotlaliliaj inmixkuak iwan itech inma. Iwan noijki kiwelitaj kitlaliskej intlaken okachi tenweweyakej ken katlej kinmonakiaj oksekimej tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iwan itech se tlakuale kitemoaj katlej okachi kuale lugar para tlakuaskej, iwan itech tiopanmej kinekij motlaliskej tlayakapan kan motlaliaj katlej okachi tlayekantokej, ");
INSERT INTO nhyNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","iwan kinekij ma kinyektlajpalokan itech tiankistle iwan kinekij ma kinmilwikan tlamachtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Pero namejwan amo xikchiwakan de ma amechilwikan antlamachtijkej, porke nochtin namejwan anmiknimej iwan ankipiaj san se amoTlamachtij, yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iwan amakaj xikilwikan “papan” ixko yin tlaltikpak, porke san se namoPapan ankipiaj, katlej kajki ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nion amo xikchiwakan ma amechilwikan antlayekankej, porke san se namoTlayekanke ankipiaj, yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Akin kintekichiwilis oksekimej, yen okachi weyikistos de yen namejwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Porke akin moweyinekis, mopinatis. Pero akin amo moweyinekis, weyikistos. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan amejwan anfariseos, anteixkajkayajkej! Porke ankintlatzakuiaj in tlakaj para amo ma kalakikan ilwikak kan Dios tlanawatia. Iwan nion amejwan mach ankalakij, iwan nion amo ankinkawiliaj ma kalakikan akinmej kinekij kalakiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan namejwan anfariseos, anteixkajkayajkej! Porke namejwan ankinkalkixtiliaj in viudajtin, iwan antlaixkajkayawaj anmotiotzajtziliaj sa tekitl para ma amechitakan ke ankichiwaj tlan kuale. Iwan por yonik namejwan ankitlaxtlawaskej okachi weyi namotlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan namejwan anfariseos, anteixkajkayajkej! Porke ik nowian (nian nepa) tlaltikpak ankitemoaj akin welis ankitlaneltokitiskej ika namotlamachtil. Iwan nijkuak ya ankajsikej, ankikuepaj okachi sa tekitl yolbierotik de ke namejwan. Iwan ijkón aminochtin anyaskej ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Ay de amejwan, ankatej kej antlayekankej katlej mach antlachiaj! Porke namejwan ankijtaj tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in weyi tiopan, yon mach itlaj kijtosneki, pero tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in oro katlej kajki ijtik in weyi tiopan, yon kipia por kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Melawak mach antlachiaj iwan antzontemej! ¿Katlij yen okachi importante: yen oro, o noso yen weyi tiopan katlej kitiochijtok in oro? ");
INSERT INTO nhyNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iwan noijki namejwan ankijtaj tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in artal, yon mach itlaj kijtosneki. Pero tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in ofrenda katlej kajki ipan artal, yon kipia por kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Melawak mach antlachiaj iwan antzontemej! ¿Katlij yen okachi importante: yen ofrenda, o noso yen artal katlej kitiochijtok in ofrenda? ");
INSERT INTO nhyNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Porke tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in artal, kijtosneki noijki tlachixtok nochi tlan ompa kajki ipan artal. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Iwan tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in weyi tiopan, kijtosneki noijki tlachixtok in Dios katlej ompa chanti. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Iwan noijki tla se tlakatl kijtos nik melawak tlan kijta iwan asta kijtos tlachixtok in ilwikak, kijtosneki noijki kijtojtok tlachixtok isiya in Dios, iwan noijki kijtojtok tlachixtok in Dios katlej motlalia itech yon siya. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan namejwan anfariseos, anteixkajkayajkej! Porke namejwan ankitemakaj namodiesmo de xiwitl ajwiakayotl de menta, de anís iwan de komino. Pero mach ankichiwaj katlej okachi importante tlan kijta in tlanawatile, de se ma kichiwa tlan melawak, de se ma teiknomati, iwan de se ma tlaneltoka inawak Dios. Kuale in tla se kitemakas diesmo, pero noijki moneki se kichiwas katlej okachi importante. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Namejwan ankatej kej antlayekankej katlej mach tlachiaj, ankitzejtzeloaj tlan ankonij para amo ma pano kanaj itlaj sayolintzin, ¡pero ankitoloaj asta se kameyo! ");
INSERT INTO nhyNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan namejwan anfariseos, anteixkajkayajkej! Porke namejwan ankichipawaj in vaso iwan plato san ik tlixko, pero ik tlijtik anyolbierotikej. Porke namoijtik antentokej de ichtekayotl iwan de nochi tlan amo kuale tlan namejwan ankichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Namejwan anfariseos mach antlachiaj. Achtoj xikchipawakan in vaso iwan plato ik tlijtik, iwan ijkón anyeskej anchipawakej noijki ik tlixko. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan namejwan anfariseos, anteixkajkayajkej! Porke namejwan ankatej ken mikkakuyoktin katlej ik tlixko motaj kuakualtzitzintin, pero ik tlijtik tentokej de omitl de mikkamej iwan de nochi pitzoyotl. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ijkón noijki namejwan, ik tlixko anmotaj kej ankualtin tlakaj, pero ik tlijtik antentokej de teixkajkayawalistle iwan de tlajtlakole. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés iwan namejwan anfariseos, anteixkajkayajkej! Porke namejwan kuakualtzin ankinchiwiliaj inmikkakuyokwan in profetajtin, iwan antlachijchiwaj kan toktokej katlej oyajkej kualtin tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iwan ankijtaj: “Tla tejwan ya tienij itech nekatej tonaltin nijkuak oyekaj in ya wejkawitl toweyitajwan, mach tikinpalewianij tikinmiktianij in profetajtin.” ");
INSERT INTO nhyNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ika yon, namejwan amonewian ankimokuitiaj nik antepilwan de nekatej tlakaj katlej okinmiktijkej in profetajtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Xikyakatlamikan kiné, in tlajtlakole katlej okipewaltijkej in ya wejkawitl namoweyitajwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Koamej! ¡Namejwan kej ankoamej! ¿Kenik ancholoskej de yen tlajyowilistle de ijtik tliko? ");
INSERT INTO nhyNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Por yonik, Nej ok namechinwalintitlanilijtos sekimej profetajtin iwan sekimej tlamachtijkej itech yankuik tlanawatile. Pero namejwan sekimej ankinmiktiskej iwan sekimej ankinmajmasoltiskej itech krus, iwan oksekimej ankinwitekiskej itech namotiopanwan, iwan oksekimej ankintlatlalochtijtinemiskej nian nepa itech pueblojtin kan ajsiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ijkón kiné, amopan wetzis in tlajtlakole de nochtin in tlakaj katlej kualtin katlej okinmiktijkej, desde yen Abel katlej oyáj kuale tlakatl asta Zacarías ikone in Berequías, katlej namejwan ankimiktijkej ijtik in weyi tiopan iyakapan artal. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ipan melajka namechilwia, nik nochi in yon tlajtlakole wetzis inpan tlakaj katlej axan katej. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ay, Jerusalén, Jerusalén, tej tikinmiktia in profetajtin iwan tikinmojmotla ika tetl katlej Dios kualintitlani monawak! ¡Miekpa oniknekke nikinmololos mokonewan, ken se pio kinmololoa ikonewan itlampa iajaswan, pero mach otiknekke! ");
INSERT INTO nhyNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Axan Dios mach ok amechpalewis, sino amechkawas. ");
INSERT INTO nhyNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Por yonik kiné, namechilwia nik mach oksemi annechitaskej asta ma ajsiki nekáj tonale nijkuak namejwan ijkín ankijtoskej: “¡Ma Dios kitiochiwa katlej okiwaltitlanke para tlanawatis!” ");
INSERT INTO nhyNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús okiske de kan weyi tiopan, iwan nijkuak yoyaya, ijkuakón imomachtijkawan omijkuanijkej inawak iwan opéj kititiaj in wejweyin kalmej katlej iaxkawan in weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Iwan Jesús okinmilwij: ―¿Ankinmitaj nochtin in yonmej wejweyin kalmej? Ipan melajka namechilwia, nian mach ok mokawas pepechitos nion se tetl ipan oksé tetl, nochi xitinis. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Satepan oyajkej ipan tepetl katlej itoka Olivostepetl. Iwan nijkuak Jesús omotlalij ompa, imomachtijkawan omijkuanijkej inawak ichtaka, iwan okilwijkej: ―Xitechilwi, ¿keman tlapanos iwan katlij yen señas tikchiaskej nijkuak tiwalmuikas? ¿Iwan keman tlamis in tlaltikpak? ");
INSERT INTO nhyNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús okinnankilij: ―Xikpiakan kuidado, amakaj ma amechkajkayawa. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porke miekej witzej ika notoka kijtoskej: “Nej niCristo”. Iwan miekej kinkajkayawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Namejwan ankimatiskej onkaj guerra iwan motlapowiskej yetos guerra, pero amo ximomawtikan, ijkón kipia de tlapanos. Pero ayamo tlamis in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Se país momagas iwan oksé país, iwan se pueblo momagas iwan oksé pueblo. Yetos apistle, yetos kokolistle, iwan tlalolinis nian nepa. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero nochi yon tlajyowilistle yakin ik pewas ken nijkuak se siwatl pewa ijtikualo nijkuak ya ajsi ora kitlakatilis ikone. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Ijkuakón namejwan amechtemaktiskej (omechtemaktiliskej) para amechkojkokoskej iwan amechmiktiskej. Nochtin amechkokoliskej por annechneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Itech nekatej tonaltin miekej wetziskej ipan tlajtlakole iwan mach ok tlaneltokaskej inawak Dios, mokokoliskej se iwan oksé, iwan motemaktiskej se iwan oksé. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Monextiskej miekej tekajkayajkej profetajtin, iwan kinkajkayawaskej miekej. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Sa tekitl momiekilis miek tlajtlakole, iwan miekej mach ok motlasojtlaskej nion se iwan oksé. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero akin kixikos nochi tlan panos, Dios kimakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iwan yin kuale tlajtole katlej temakixtia de kenik in Dios tlanawatia, motematiltis itech nochi in tlaltikpak, para ke nochtin in tlakaj de nochtin paismej ma kimatikan. Iwan ijkuakón tlamis in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Noijki namejwan ankitaskej tlapanos tlan okijkuiloj in profeta Daniel, okijtoj ajsis tonale namejwan ankitaskej moketos itlaj bierotik Kan Tlatiochiwalojkan de yen weyi tiopan kan amo kipia de ompa yetos ―akin kileros yin tlan okijkuiloj in Daniel, ma kimomaka kuenta―, ");
INSERT INTO nhyNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ijkuakón katlej yeskej Judea, ma cholokan asta inpan tepemej. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iwan akin yetos ipan ikal amo ma temo ma kixtiti itlaj ikalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Iwan akin yetos itlalaj, amo ma mokuepa ichan para ma kikuiti itzotzol. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Pobrestin siwamej katlej itech nekatej tonaltin kipiaskej inkone intlalaxko iwan katlej selikkonewajkej! ");
INSERT INTO nhyNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xiknotzakan Dios amo ma amechtokaro ancholoskej nijkuak meroj sewa, iwan nion nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porke ijkuakón yetos miek tlajyowilistle iwan temawtij, ken mach semi ijkón tlamochiwa desde ijkuak opéj in tlaltikpak asta axan, iwan nion mach oksemi ijkón tlamochiwas satepan. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Iwan tla Dios amo kitzikitziniliani in yonmej tonaltin mach akaj momakixtiani. Pero yokitzikitzinilij por yejwan katlej Dios kintlasojtla katlej Yej yokinpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Ijkuakón, tla akaj amechilwis: “Xikitakan, nian kajki in Cristo”, o noso “Xikitakan, nepa kajki”, amo xikneltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porke monextiskej Cristojtin iwan profetajtin tekajkayajkej, iwan kinchiwaskej señalestin iwan milagrostin, para ika tlakajkayawaskej, iwan kinekiskej kinkajkayawaskej noijki katlej Dios yokinpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nej yonamechilwij antes de tlamochiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Por yonik, tla amechilwiskej: “Xikitakan, nepa kajki kan tlawaki”, amo xiwian. Iwan tla amechilwiskej: “Xikitakan, nian kajki itech kuarto”, amo xikneltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Porke ijkón ken ijkuak tlapejpetlani ik ikisayan tonale iwan tlawia asta ik ipoliwian tonale, ijkón Nej noijki akin onimochij nitlakatl ik nian nepa nechitaskej nijkuak niwitz. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ijkón ken nijkuak tikinmitaj in tzojpilomej pewa mololoaj kan kajki se mikkatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Iwan san niman nijkuak panos in tlajyowilistle itech nekatej tonaltin, in tonale tlanexosewis, in metztle sewis, mach ok metztonas, in sitlaltin wetziskej de ilwikak, iwan chikawalistin katlej katej ilwikak papatlakaskej (bibiokaskej). ");
INSERT INTO nhyNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iwan ijkuakón motas se señal de Nej katlej onimochij nitlakatl, ninesis itech ilwikak, iwan ijkuakón nochtin in tlajtlakolejkej de ixko yin tlaltikpak chokaskej nijkuak nechitaskej niwitz ijtik mixtle de ilwikak, ika miek nopoder iwan ika weyi nomawisotlanex. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iwan nikinwalintitlanis noangelwan, iwan ika se chikawak tlapitzalistle, kinmololoskej in tlakaj katlej Nej yonikinpejpenke de ik nowian (nian nepa) ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Xikmomakakan kuenta in ejemplo de yen igoskuawitl: Nijkuak pewa moselialtia imamayo iwan pewa moxiwyotia, namejwan ya ankimatij nik ya pewas tlaxiwyoas. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ijkón noijki, nijkuak namejwan ankitaskej nochi in yon ya pewas tlapanos, ijkuakón noijki xikmatikan nik in Nej katlej onimochij nitlakatl ya niwalkistiwitz kaltempan. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ipan melajka namechilwia, nik nochi in yin tlapanos antes de mikiskej in tlakaj katlej katej itech yinmej tonaltin. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","In ilwikak iwan yin tlaltikpak mach ok yetoskej, nochi poliwiskej, pero notlajtol mach poliwis, sino kipia de mochiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Mach akaj kimati tlan tonale iwan tlan ora nijkuak niwalmokuepas, nion yen angelestin de ilwikak mach kimatij, nion Nej niiKone in Dios no mach nikmati, san yen noPapan Dios kimati. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Iwan ijkón ken oyeka itech tiempo de Noé, no ijkón yetos nijkuak niwitz Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Itech nekatej tonaltin, antes de mokajkawani in tlamawisolkiawatl, in tlakaj oilwitlakuayaj iwan okoniaj, omonamiktiayaj iwan okintlajtlaniaj ichpokamej. Ijkón okichijtokaj asta itech nekáj tonale nijkuak in Noé okalakke ijtik in weyi barko. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","In tlakaj mach okichijkej kuenta asta ijkuak owalaj in tlamawisolkiawatl iwan nochtin okinmiktij. No ijkón tlapanos nijkuak niwitz Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nijkuak Nej niwitz, omen tlakaj sepantekipanojtoskej intlalaj. Se kiwikaskej iwan oksé kikajtewaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Omen siwamej sepantistoskej inkalijtik. Se kiwikaskej iwan oksé kikajtewaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Xiijsatokan, kiné, porke mach ankimatij tlan ora witz namoSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Xikmomakakan kuenta yin tlamantle, tla se tetaj kimatini tlan ora witz in ichtekke, ijsatoni iwan amo kitekawiliani akaj ma kalaki ikalijtik para ma kitlachteki. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Por yonik, namejwan noijki kuale ximoyektlalikan. Porke Nej katlej onimochij nitlakatl niwitz nijkuak namejwan mach annechchiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Namejwan kox antekipanojkej de konfiansa iwan antlalnamikilisejkej, katlej toSeñor oamechtlalij xikitakan in tekitl itech ichan iwan xikintlamakakan in tekipanojkej nijkuak ajsis ora? ");
INSERT INTO nhyNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xipakikan namejwan tla ijkuak niwalmokuepas namechajsiki ankichijtokej tlan onamechnawatij. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ipan melajka namechilwia, nik namechtlalis xikitakan nochi tlan noaxka. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero tla amejwan mach ankualtin antekipanojkej iwan ankiyejyekoskej ke niwejkawas para niwalmokuepas, ");
INSERT INTO nhyNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","iwan tla pewa ankinwitekij in oksekimej tekipanojkej, iwan pewa anmiilwitlakuaj iwan antlawanaj, ");
INSERT INTO nhyNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","namoSeñor witz itech se tonale nijkuak namejwan mach ankichiaj, iwan itech se ora katlej namejwan mach ankimatij. ");
INSERT INTO nhyNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Sa tekitl amechwitekis, iwan amechtlalis inwan teixkajkayajkej kan anchokaskej iwan anmotlanteteyitzaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Kan Dios tlanawatia tlamochiwas ken omochijkej in majtlaktin ichpokamej katlej okitkikej inkandil iwan oyajkej okinamikitoj in novio. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Makuile de yonmej ichpokamej oyekaj tlalnamikilisejkej iwan ok makuiltin amo. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Katlej mach oyekaj tlalnamikilisejkej, nijkuak okitkikej inkandil, mach okitkikej inmaseite para kintemitiskej oksemi. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero oksekimej ichpokamej katlej tlalnamikilisejkej okitkikej inboteya de aseite iwan inkandil. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Iwan komo in novio mach oejkoya totoka, okochisnekkej in ichpokamej, iwan okochkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Satepan, kej tlajko yuak, okikakej se tlajtole: “¡Ompa witz in novio, xiknamikitij!” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tonses nochtin in ichpokamej omejtewakej iwan okinyektlalijkej inkandilwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iwan in makuiltin ichpokamej katlej mach tlalnamikilisejkej okinmilwijkej in oksekimej makuiltin katlej tlalnamikilisejkej: “Xitechmakakan sekin namoaseite, porke tokandilwan ya sewtokej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero in ichpokamej tlalnamikilisejkej okinnankilijkej: “Amo, porke tla tamechmakaskej mach kajxilis nion para tejwan. Okachi kuale xiwian xikmokowitij kan kinamakaj.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero nijkuak in makuiltin ichpokamej katlej mach tlalnamikilisejkej oyajkej okimokowitoj inmaseite, ijkuakón oejkok in novio. In ichpokamej katlej yomoyektlalijkej okalakej iwan novio itech yon ilwitl kan monamiktia in novio, iwan omotzakke in puerta. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Satepan oejkokej in oksekimej makuiltin ichpokamej katlej mach okipiayaj inmaseite, otlatatalatzkej iwan okijtojkej: “¡Señor, xitechtlatlapoli!” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero yej okinnankilij: “¡Mach namechixmati akin namejwan! ¡Xiwian!” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ijkuakón Jesús okinmilwij: ―Por yonik, namejwan xiijsatokan, porke mach ankimatij tlan tonale nion tlan ora nijkuak Nej katlej onimochij nitlakatl niwitz. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Kan Dios tlanawatia yon ken se tlakatl katlej antes de kisas para oksé país, okinnotzke itekipanojkawan iwan okinmakak itomin para ika ma tekipanokan. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Se itekipanoj okimakak makuile mil pesos, oksé okimakak ome mil pesos, iwan oksé okimakak mil pesos. Okinmakak según tlan yejwan welinij kitekipanoltianij. Satepan yon tlakatl okiske iwan oyáj wejka. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","In tekipanoj katlej okimakakej makuile mil pesos, okichij negosio ika, iwan okitlanke ok makuile mil pesos. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iwan tekipanoj katlej okimakakej ome mil pesos, noijki okitlanke ok ome mil pesos. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero oksé tekipanoj katlej okimakakej mil pesos, okitookak in tomin ijtik tlale para amo kipolos. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Opanok tiempo, inteko omokuepato, iwan opéj kinchiwilia kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","In tekipanoj katlej okimakakej makuile mil pesos, okimakak iteko ok makuile mil pesos, iwan okilwij: “Señor, otinechmakak makuile mil pesos, nian kajki ok makuile mil katlej oniktlanke.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Iwan iteko okilwij: “Kuale otikchij. Tej tikuale tinotekipanoj iwan de konfiansa. Iwan komo kuale otiktekipanoltij tlan tzikitzin onimitzmakak, por yonik axan nimitztlalis xikita okachi miek tlamantle. Axan, xikalaki iwan nowan xipaki.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","In tekipanoj katlej okimakakej ome mil pesos okitemakak ikuenta ijkín: “Señor, otinechmakak ome mil pesos, nian kajki ok ome mil katlej oniktlanke.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","In iteko okilwij: “Kuale otikchij. Tej tikuale tinotekipanoj iwan de konfiansa. Iwan komo kuale otiktekipanoltij tlan tzikitzin onimitzmakak, por yonik axan nimitztlalis xikita okachi miek tlamantle. Axan, xikalaki iwan nowan xipaki.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero in tekipanoj katlej okimakakej mil pesos, okilwij in iteko: “Señor, komo nikmati nik wel chikawak titlanawatia, iwan tikmoaxkatia tlan amo otiktlanke iwan tikmopixkia tlan amo otiktookak, ");
INSERT INTO nhyNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","onimomawtij, iwan okachi kuale oniktlaatij motomin. Pero nian kajki, ajsitok nochi motomin.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Iteko okinankilij: “Tej mach tikuale tinotekipanoj iwan titlatziwke, tla otikmatia nik oniknekia nikmokawiani tlan tiktlanini, ");
INSERT INTO nhyNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","siera tikonkawani notomin itech banko para kitlanini ikoneyo, para nijkuak niejkoni, nikresibiroani notomin iwan tlan yokitlanke.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ijkuakón iteko okinmilwij katlej ompa oyekaj: “Xikixtilikan in mil pesos, iwan xikmakakan katlej kipia majtlaktle mil. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Porke akin kipia, okachi kimakaskej, iwan kipias okachi miek. Iwan akin amo kipia, kikixtiliskej asta yen tzikitzin tlan kipia. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iwan yin tekipanoj tlatziwke, xiktlamotlakan kalan ijtik tlatleyualotl kan chokas iwan motlanteteyitzas.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Iwan nijkuak Nej katlej onimochij nitlakatl niwitz ika nomawisotlanex inwan nochtin noagelwan, ijkuakón nimotlalis itech nosiya katlej kipia imawisotlanex para nitlaixkomakas (nitlatzonmanas). ");
INSERT INTO nhyNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iwan nochtin in tlakaj de nochtin paismej mololoskej noyakapan, iwan nikinseladojkixtis ken se tlajpixke kinseladojkixtia ichkamej iwan tentzomej. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nochkawan nikintlalis ik noyekma iwan tentzomej nikintlalis ik noopochma. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ijkuakón Nej niRey nikinmilwis katlej yeskej ik noyekma: “Xiwikikan namejwan, katlej oamechtiochij noPapan. Xiwikikan iwan xikalakikan kan nitlanawatia kej niRey, kan Dios otlayektlalij para amejwan desde ijkuak okichij in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Porke nijkuak Nej onitiojsij, namejwan annechtlamakakej. Nijkuak Nej onamikke, namejwan annechatlitijkej. Nijkuak mach onikpiaya kan nimokalotis (nimotepialtis), namejwan annechkalotijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nijkuak mach onikpiaya tlan nikonakis, namejwan annechmakakej notzotzol. Nijkuak onimokokoj, namejwan annechtlajpalotoj. Nijkuak onitzaktoka telpiloyan, namejwan annechitatoj.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ijkuakón katlej oyajkej kualtin tlakaj kijtoskej: “Señor, ¿keman otimitzitakej otitiojsij, iwan otimitztlamakakej? ¿O noso keman otimitzitakej otamikke, iwan otimitzatlitijkej? ");
INSERT INTO nhyNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿O noso keman otimitzitakej amo otikpiaya kan timokalotis, iwan otimitzkalotijkej, o noso amo otikpiaya tlan tikonakis, iwan otimitzmakakej motzotzol? ");
INSERT INTO nhyNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O noso keman otimitzitakej otimokokoj, o noso otitzaktoka telpiloyan, iwan otiajkej otimitzitatoj?” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nej niRey nikinnankilis: “Ipan melajka namechilwia, ke nochi tlan ankichijkej por nochtin yinmej nokniwan maski sensiyojtzitzintin, kijtosneki yen Nej nannechchiwilijkej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Ijkuakón noijki Nej niRey nikinmilwis katlej yeskej ik noopochma: “Xitzinkisakan de Nej, namejwan mach ankualtin. Xiwian ijtik tlitl katlej mach keman sewis katlej Dios okichij para yen diablo iwan iangelwan. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Porke ijkuak onitiojsij, namejwan mach annechtlamakakej. Nijkuak onamikke, namejwan mach annechatlitijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nijkuak amo onikpiaya kan nimokalotis, namejwan mach annechkalotijkej. Nijkuak amo onikpiaya tlan nikonakis, namejwan mach annechmakakej notzotzol. Nijkuak onimokokoj iwan nijkuak onitzaktoka telpiloyan, namejwan mach annechitatoj.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iwan ijkuakón yejwan nechilwiskej: “Señor, ¿keman otimitzitakej otitiojsij o noso otamikke, o noso amo otikpiaya kan timokalotis, o noso amo otikpiaya tlan tikonakis, o noso otimokokoj, o noso otitzaktoka telpiloyan, iwan amo otimitzpalewijkej?” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ijkuakón Nej niRey nikinnankilis: “Ipan melajka namechilwia, ke nijkuak namejwan mach ankinekej ankinpalewijkej nokniwan, maski sensiyojtzitzintin, kijtosneki yen Nej mach annechpalewijkej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Iwan yonmej katlej mach kualtin yaskej iktlanke (ik tlami) kan tlajyowiskej, iwan katlej yolchipawakej kalakiskej kan kipiaskej nemilistle kan mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nijkuak in Jesús otlanke okijtoj nochi in yon tlajtole, okinmilwij imomachtijkawan: ");
INSERT INTO nhyNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Namejwan ya ankimatij, nik sa ome tonale poliwi para yen ilwitl itoka pascua. Iwan Nej katlej onimochij nitlakatl nechtemaktiskej (nechtemaktiliskej) para nechmajmasoltiskej itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Itech yonmej tonaltin in tlayekankej tiopixkej, iwan tlamachtijkej de itlanawatil in Moisés iwan tlayekankej tetajtzitzintin judiojtin, omololojkej kan patio de yen palacio kan chanti in weyi tiopixke itoka Caifás. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ompa omotlapowijkej para kitemoskej kenik kikitzkiskej in Jesús ika itlaj tlakajkayawalistle para ijkón welis kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero okijtoayaj: ―Mach tikitzkiskej itech ilwitl, para amo kualaniskej in tlakaj iwan yomoniskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús oyeka itech pueblo de Betania, ichan Simón, katlej Jesús okipajtij nijkuak opalania inakayo. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ijkuakón se siwatl omijkuanij inawak Jesús katlej okitkia se boteyajtzin de alabastro tentok de ajwiakayotl katlej patíoj, iwan okiteekilij in Jesús ipan itzontekon kan oewatoka itech mesa. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nijkuak imomachtijkawan ijkón okitakej, okualankej iwan okijtojkej: ―¿Tlanik yin siwatl san okawiltij in ajwiakayotl? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Porke welini monamakani patíoj, iwan se kinmakani in tomin katlej pobrestin. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús okikakke, iwan okinmilwij: ―¿Tlanik anmokuejsoaj inawak yin siwatl? Porke kuale tlan okichij. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","In pobrestin nochipa ankinpiaskej, pero Nej mach nochipa annechpiaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yin siwatl nijkuak onechteekilij ajwiakayotl itech notlalnakayo, kijtosneki okiyektlalij notlalnakayo para nijkuak nimotookas. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ipan melajka namechilwia, ke ik nowian (nian nepa) ixko yin tlaltikpak kan motematiltis in tlajtole katlej temakixtia, noijki se kitemakas kuenta de tlan okichij in yin siwatl iwan ijkón se kelnamikis. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ijkuakón se imomachtijkaw itoka Judas Iscariote de yen majtlaktle iwan omen momachtijkej, oyáj omotlapowito inwan tlayekankej tiopixkej ");
INSERT INTO nhyNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","iwan okinmilwij: ―¿Kech annechmakaskej tla namechmaktilis in Jesús? Tonses yejwan okilwijkej kimakaskej senpoale iwan majtlaktle tomin de plata. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iwan desde ijkuakón Judas opéj kitemoa kenik welis kinmaktilis in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Nijkuak opéj in ilwitl de pascua yakin se tonale, nijkuak mokua in pan katlej mach kipia levadura, ijkuakón imomachtijkawan Jesús omijkuanijkej inawak, iwan okitlajtlanijkej: ―¿Kan tikneki ma tikyektlalitij in tiotlakantlakuale de pascua para tikmomajsewis? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yej okinmilwij: ―Xiwian itech weyikan de Jerusalén, ichan se tlakatl katlej iwan yonimotlapowij iwan xikilwikan: “In Tlamachtij kijta: Yoajsiko noora, moneki mochan nikmomajsewis in tiotlakantlakuale de pascua iwan nomomachtijkawan.” ");
INSERT INTO nhyNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Imomachtijkawan okichijkej ijkón ken okinnawatij in Jesús, iwan okiyektlalijkej in tiotlakantlakuale de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nijkuak otlatleyuak, Jesús omotlalij itech mesa inwan majtlaktle iwan omen imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Iwan nijkuak otlakuajtokaj, Jesús okinmilwij: ―Ipan melajka namechilwia, nik se de amejwan nechtemaktis (nechtemaktilis). ");
INSERT INTO nhyNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yejwan sa tekitl omoyolkokojkej, iwan opéj kitlajtlaniaj kada se de yejwan: ―Señor, ¿kox yen nej? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús okinnankilij: ―Katlej kajakia ipan ijtik plato kan Nej noijki nikajakia nopan, yen yon katlej nechtemaktis (nechtemaktilis). ");
INSERT INTO nhyNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nej katlej onimochij nitlakatl nimikis ijkón ken kijta in tiotlajkuilole. Pero ¡pobre in tlakatl katlej nechtemaktis! Okachi kuale mach tlakatini yon tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ijkuakón okitlajtlanij in Judas, katlej kitemaktis, iwan okilwij: ―Tlamachtij, ¿kox yen nej? Jesús okinankilij: ―Aján, tej meroj. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mientras otlakuajtokaj, Jesús okitilanke in pan, iwan omotlasojkamatke inawak Dios, satepan okipojpostekke in pan iwan okinmajmakak imomachtijkawan, iwan okinmilwij: ―Xikkuakan. Yin yen notlalnakayo. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ijkuakón okitilanke in kopa, iwan omotlasojkamatke inawak Dios, satepan okinpanoltilij imomachtijkawan, iwan okinmilwij: ―Xikonikan yin kopa aminochtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Yin yen noeso, katlej yankuik akuerdo, katlej toyawis para ijkón miekej tlapojpolwiloskej de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero namechilwia, ke desde axan mach ok nikonis iayo uvas asta nekáj tonale nijkuak amowan nikonis iayo uvas yankuik katlej onkaj kan noPapan tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Satepan de okitlakuikakej se tiotlakuikale, oyajkej ipan Olivostepetl. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iwan ijkuakón Jesús okinmilwij: ―Namejwan aminochtin annechkajtewaskej noselti yin yuak, porke in tiotlajkuilole kijta: “Nikmiktis in tlajpixke iwan ichkamej xixiniskej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero satepan de nimoyolkuis (nimoyolitis), Nej sa nitlayekanas para Galilea iwan satepan namejwan ompa annechitajsij. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ijkuakón Pedro, okilwij: ―Maski nochtin ma mitzkajtewakan, nej mach nimitzkawas. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tonses Jesús okinankilij: ―Ipan melajka nimitzilwia nik yin yuak, antes de tzajtzis in kaxtil, ijkuakón tej yotikijtoj eyi buelta nik mach tinechixmati. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iwan Pedro okilwij: ―Maski mowan ma nechmiktikan, nej mach keman nimitzkawas. Iwan nochtin imomachtijkawan no ijkón okijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ijkuakón Jesús okinwikak imomachtijkawan se lugar tlatokkuawyoj itoka Getsemaní, iwan okinmilwij: ―Nian ximotlalikan, mientras Nej niawi nimotiotzajtziliti ik ne. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Okiwikak in Pedro iwan omen ipilwan in Zebedeo, iwan Jesús opéj sa tekitl mosentiroa iwan opéj moyolkokoa sa tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ijkuakón Jesús okinmilwij: ―Nikmachilia itech noanima ya niixpoliwi de neyolkokole. Nian ximokawakan xiijsatokan nowan. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús oyáj ok achitzin ik tlayakapan, ompa omotlankuaketzke asta okitennamikke in tlale, iwan omotiotzajtzilij okijtoj: ―Papan, in tla welis, xinechkixtili in yin tekokojkayotl. Pero amo ma mochiwa ken Nej nikneki, sino ken tejwatzin tikmonekiltia. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ijkuakón Jesús omokuepke kan oyekaj eyin imomachtijkawan, iwan okinmajsitajsik kochtokej. Iwan okilwij in Pedro: ―¿Amo ankixikojkej nion se ora anmijsatokej nowan? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xiijsatokan iwan ximotiotzajtzilijtokan, para amo ma amechmayawi in tlajtlakole. Namoespíritu kineki kichiwas tlan kuale, pero namotlalnakayo mach tlaxikoa. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús oyáj ipan ojpatian omotiotzajtzilito, iwan omotiotzajtzilij ijkín: ―Papan, tla amo welis nimakisas de itech yin tekokojkayotl, tonses ma mochiwa kiné tlan tejwatzin tikmonekiltis. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Oksemi omokuepke kan oyekaj imomachtijkawan, iwan oksemi okinmajsitajsik kochtokej, porke inpan omopachoj in kochilistle. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Oksemi okinkajtej, iwan oyáj omotiotzajtzilito ya eyi buelta, iwan oksemi okijtoj tlan achtoj okijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Satepan oyáj kan oyekaj imomachtijkawan, iwan okinmilwij: ―Axan keman xikochikan iwan ximosewikan. Yoajsik ora, Nej katlej onimochij nitlakatl ya nechtemaktiskej (nechtemaktiliskej) inmak in tlakaj tlajtlakolejkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ximewakan, ma tiwian. Yompa witz katlej nechtemaktis. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ok otlapojtoka nijkuak oejkok in Judas, katlej oyeka se de yejwan majtlaktle iwan omen imomachtijkawan, okualinwikaya miekej tlakaj kiwalkuij espada iwan kiwalkuij kuawitl. Yinmej tlakaj okualintitlankej in tlayekankej tiopixkej iwan tlayekankej tetajtzitzintin judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pero in Judas antes de kinmaktilis in Jesús, achtoj okinmilwij in tlakaj kenik kinmititis. Okinmilwij: ―Katlej nej nikixpipitzos, yen yon Jesús. Xikitzkikan iwan xikwikakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Satepan in Judas omijkuanij inawak Jesús iwan okijtoj: ―¡Noltij Tlamachtij! Iwan okixpipitzoj. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iwan Jesús okinankilij: ―Amigo, ¿tlan otikchiwako? Ijkuakón omijkuanijkej okitzkijkej in Jesús, iwan okiwikakej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ijkuakón se imomachtijkaw in Jesús okikixtij iespada iwan okinakastzontekke itekipanoj in weyi tiopixke. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ijkuakón Jesús okilwij: ―Xiktlaati moespada. Porke nochtin akinmej kimomagaskej ika espada, noijki mikiskej ika espada. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Amo tikmati tla Nej niknekini, welini niktlajtlaniliani noPapan, ma kualintitlani miles de angelestin para ma nechpalewikij iwan san niman kualintitlanini? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tla ijkón nikchiwas, ¿kenik mochiwas tlan kijta tiotlajkuilole, katlej kijta nik ijkón nipanos? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tonses Jesús okinmilwij in tlakaj: ―¿Annechkitzkikoj namejwan ika espada iwan ika kuawitl kej yeskia niichtekke? Nochipa onieka amowan itech in weyi tiopan onitlamachtijtoka iwan mach keman annechkitzkijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero nochi yin nipanoa para ma mochiwa tlan kijta in tiotlajkuilole katlej okijkuilojkej in profetajtin. Ijkuakón nochtin imomachtijkawan okikajtejkej iselti in Jesús iwan ocholojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Katlej okitzkijkej in Jesús okiwikakej ixpan weyi tiopixke Caifás, kan oololitokaj in tlamachtijkej de itlanawatil in Moisés iwan tlayekankej tetajtzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pero in Pedro inkuitlapan oyáj de wejka asta kan patio de ichan in weyi tiopixke, ompa okalakke iwan omotlalij inwan mayoltin para kitas tlanon tlapanos. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","In tlayekankej tiopixkej, iwan tlayekankej tetajtzitzintin, iwan nochtin de yen junta, okitemoayaj kenik kimayawiskej in Jesús ika tlajtoltlatlalilistle para kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero mach itlaj okajxiliayaj tlan ika kistlakawiskej, maski miekej okijtojkej tlan amo melawak. Pero satepan omoketzkej omen tlakaj teistlakawijkej katlej mach kualtin, ");
INSERT INTO nhyNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","iwan okijtojkej: ―Yin tlakatl okijtoj: “Nej welis nikxitinis in weyi tiopan de Dios, iwan san ika eyi tonale nikkewaltis oksemi.” ");
INSERT INTO nhyNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tonses in tlayekanke tiopixke omoketzke, iwan okilwij in Jesús: ―¿Amo titlanankilis? ¿Melawak tlan yejwan mitzistlakawiaj? ");
INSERT INTO nhyNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús mach otlanankilij. Ijkuakón in tlayekanke tiopixke okilwij: ―Nimitznawatia ika itoka in toTajtzin Dios katlej nochipa yolitok, xitechilwi kox yen tej tiCristo, iKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús okinankilij: ―Aján yen Nej, ijkón ken tej yotikijtoj. Iwan noijki namechilwia, nik namejwan annechitaskej Nej katlej onimochij nitlakatl niewatos ik iyekma in Dios katlej kipia weyi ipoder, iwan niwitz de ilwikak ijtik mixtle. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ijkuakón in tlayekanke tiopixke omotlakentzayanke, iwan okijtoj: ―¡Yin tlakatl kixpanawia in Dios! ¿Tlan para moneki ok akaj ma kistlakawi de tlan yokijtoj? Namejwan ya ankikakej tlan yej inewian yokimokuitij. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Namejwan ken ankijtaj? Iwan yejwan okijtojkej: ―¡Tlajtlakolej, moneki ma miki! ");
INSERT INTO nhyNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ijkuakón okixchijchakej iwan okimaitenkej. Oksekimej okixtlajtlatzinijkej ");
INSERT INTO nhyNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","iwan okilwijkej: ―Tej komo tiCristo, ¡tla xitlajto (xikadibinaro) akin omitzmaak! ");
INSERT INTO nhyNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pedro oewatoka kalan kan patio, iwan ijkuakón se tlapalewijkasiwatl omijkuanij inawak iwan okilwij: ―Tej noijki otinemia iwan Jesús katlej de estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedro mach okimokuitij, okijtoj: ―Mach nikmati tlan tikijta. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro yokistiaya ik puertajko, oksé siwatl okitak, iwan okinmilwij katlej ompa oyekaj: ―Yin tlakatl noijki onemia iwan Jesús de pueblo de Nazaret. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedro oksemi mach okimokuitij, iwan asta okijtoj nik in Dios tlachixtok. Okijtoj: ―Mach nikixmati in yon tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Okachitzin satepan, katlej ompa oyekaj omijkuanijkej inawak in Pedro, iwan okilwijkej: ―Ya nele, tej noijki se de yejwan, porke mokaki oksé nik titlapoa. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ijkuakón opéj tlawikaltia iwan asta okijtoj nik in Dios tlachixtok mach melawak. Okijtoj: ―Mach nikixmati in yon tlakatl. Iwan san niman ijkuakón owaltzajtzik in kaxtil. ");
INSERT INTO nhyNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ijkuakón Pedro okelnamikke tlan achtoj okilwij in Jesús: “Antes de tzajtzis in kaxtil, tej ijkuakón yotikijtoj ya eyi buelta nik mach tinechixmati.” Iwan Pedro okiske de ompa iwan ochokak sa tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nijkuak otlaneske, nochtin in tlayekankej tiopixkej inwan tlayekankej tetajtzitzintin judiojtin, omotlalijkej san se tlajtole kenamij kichiwaskej para kimiktiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Okiwikakej ilpitiw iwan okimaktilijkej in gobernador Poncio Pilato. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Satepan Judas, katlej okitemaktij (okitemaktilij) in Jesús, nijkuak okitak nik in Jesús yokitlajtlakoltijkej para mikis, omoyolpejpenke (omoyolkuepke) de tlan okichij, iwan oyáj okinkuepilito in senpoale iwan majtlaktle tomin de plata in tlayekankej tiopixkej iwan tlayekankej tetajtzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Iwan okinmilwij: ―Yonitlajtlakoj, porke oniktemaktij yon tlakatl katlej mach itlaj tlajtlakole okichij. Pero yejwan okilwijkej: ―Tejwan mach totekiw. ¡Ompa tej xikita! ");
INSERT INTO nhyNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ijkuakón Judas okitlamotlak in tomin ijtik in weyi tiopan, okiske, iwan oyáj omokechpiloto. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","In tlayekankej tiopixkej okololojkej in tomin iwan okijtojkej: ―Mach welis tiktlaliskej yin tomin ijtik kaja kan motlalia in ofrenda, porke ika okitlaxtlajkej imikilis se tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iwan satepan omotlalijkej san se tlajtole para ika yon tomin kikowiliskej itlal in Xoktzinchij, para kipiaskej kan kintookaskej in tlakaj katlej mach ompa chanejkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Por yonik yon tlale itoka asta axan, Tlale de Estle. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iwan ijkón omochij tlan okijtoj in profeta Jeremías, nijkuak okijtoj: “Okitilankej (okonankej) in senpoale iwan majtlaktle tomin de plata, achón tomin katlej okitemakakej in tlakaj de Israel por Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Iwan ika yon tomin okikowilijkej itlal in Xoktzinchij, ijkón ken onechnawatij in Señor.” ");
INSERT INTO nhyNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús oyeka ixpan gobernador itoka Pilato, iwan yin gobernador okitlajtlanij in Jesús: ―¿Yen tej tiRey de judiojtin? Jesús okilwij: ―Aján, ijkón ken tej yotikijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iwan maski in tlayekankej tiopixkej iwan tlayekankej tetajtzitzintin opéj kistlakawiaj, in Jesús mach itlaj okijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ijkuakón Pilato okilwij: ―¿Amo tikkaki tlan yejwan kijtaj de tej? ");
INSERT INTO nhyNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús mach itlaj okinankilij. Iwan Pilato sa otlajtlachixke (omomajmawtij). ");
INSERT INTO nhyNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","In gobernador okipiaya kostumbre ke itech ilwitl de pascua kikajkawas se preso, san katlij yej kitlajtlaniliskej in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ijkuakón otzaktoka telpiloyan se tlakatl katlej ik nowian (nian nepa) okitokayomatiaj itoka Barrabás. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iwan nijkuak omololojkej miekej tlakaj, in Pilato okintlajtlanij: ―¿Katlij yej namejwan nankinekij ma nikkajkawa: yen Barrabás, o noso yen Jesús, katlej kinotzaj Cristo? ");
INSERT INTO nhyNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Porke in Pilato okimomakak kuenta nik in tiopixkej omoxikoayaj, iwan por yonik okitemaktijkej (okitemaktilijkej) in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mientras Pilato oewatoka ipan isiya para tlaixkomakas (tlatzonmanas), isiwa otlatitlanke ma kilwitij: “Amo ximokalaki iwan yon tlakatl yolchipawak, porke yin yuak wel onechmajmawtij tlan onikteemikke de yej.” ");
INSERT INTO nhyNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero in tlayekankej tiopixkej iwan tlayekankej tetajtzitzintin okintlatlalwijkej in tlakaj para ma kitlajtlanilikan ma kikajkawakan in Barrabás, iwan ma kimiktikan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","In gobernador oksemi okinmilwij: ―¿Katlij yej de yinmej omen ankinekij ma nikkajkawa? Iwan yejwan okijtojkej: ―Xikkajkawa in Barrabás. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato okintlajtlanij: ―¿Iwan tlan nikchiwas iwan Jesús, katlej kinotzaj Cristo? Nochtin okilwijkej: ―¡Xikmajmasolti itech krus! ¡Ma miki! ");
INSERT INTO nhyNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Tonses in Pilato okinmilwij: ―Pero, ¿tlan okichij? Pero yejwan oksemi otzajtzikej: ―¡Xikmajmasolti itech krus! ¡ma miki! ");
INSERT INTO nhyNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nijkuak in Pilato okitak nik mach itlaj owelia okichiwaya iwan yej okachi oyomoniaj, ijkuakón otlanawatij ma kikuitij atl iwan omomajtekij inmixpan nochtin tlakaj, iwan okijtoj: ―Nej mach nikmati de imikilis in yin tlakatl. Ompa amejwan xikitakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iwan nochtin in tlakaj okijtojkej: ―¡Yon xitechkawili tejwan iwan topilwan ma yeto tejwan totlajtlakol de imikilis! ");
INSERT INTO nhyNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tonses in Pilato okikajkaj in Barrabás. Iwan satepan otlanawatij ma kiwitekikan in Jesús, iwan okinmaktilij in tlakaj para ma kimajmasoltikan itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Satepan isoldadojwan in gobernador okiwikakej in Jesús kan palacio, iwan okiyawalojkej nochtin in soldadojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Satepan okixixinijkej (okixipetzojkej), iwan okonakiltijkej se tlakemitl weyak chichiltikatlilmiktik ken katlej konakiaj in reytin. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Okichijkej se korona de witztle iwan okitlalilijkej ipan itzontekon. Okitzkiltijkej se vara itech iyekma kej tekiwaj. Iwan omotlankuaketzayaj iyakapan, okipinawiayaj okijtoayaj: ―¡Viva in Rey de judiojtin! ");
INSERT INTO nhyNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Iwan okichijchayaj, iwan okikixtilijkej in vara iwan ika okikuawijwitekiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Satepan de okipinawijkej, okikixtilijkej in tlakemitl chichiltikatlilmiktik iwan oksemi okonakiltijkej itzotzol. Satepan okiwikakej para kimajmasoltiskej itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nijkuak yoyayaj ipan ojtle, okinamikej se tlakatl de pueblo de Cirene itoka Simón. Iwan okitoktijkej ma kimamali ikrus in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nijkuak oajsitoj se lugar itoka Gólgota, kijtosneki Mikkatzontekomatl, ");
INSERT INTO nhyNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","okimakakej ma koni vino katlej okinelojkej ika se pajtle chichik. Pero nijkuak okiyekoj, mach okinekke okonik. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nijkuak yokimajmasoltijkej itech krus, in soldadojtin omotlaankej para kimoxejxeliliskej entre yejwan itzotzol in Jesús. Ijkón omochij tlan ya wejkawitl okijtoj in profeta: “Omotlaankej, iwan okimoxejxelilijkej notzotzol entre yejwan.” ");
INSERT INTO nhyNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Iwan satepan omotlalijkej para kitlatoskej (kikuidarojtoskej). ");
INSERT INTO nhyNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ik ikuapak okitlalilijkej se letrero ijkuilitok por tlanik okimajmasoltijkej itech krus. Kijtojtok: “Yin yen Jesús, inRey in judiojtin.” ");
INSERT INTO nhyNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Noijki omen ichtekej okinmajmasoltijkej itech krus san sekan iwan Jesús, se ik iyekma iwan oksé ik iopochma. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iwan katlej ik ompa opanoayaj otlajtoayaj biero de Yej, iwan okoliniayaj intzontekon ");
INSERT INTO nhyNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","okijtoayaj: ―¿Amo otikijtoaya nik welini tikxitiniani in weyi tiopan iwan san ika eyi tonale welini oksemi tikewaltiani? Ma tikitakan kiné. Xitemo de itech krus tla melawak tej titeKone de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","No ijkón okipinawiayaj in tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés, noijki in fariseos iwan tlayekankej tetajtzitzintin, okijtoayaj: ");
INSERT INTO nhyNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Okinmakixtij oksekimej, pero yej inewian mach weli momakixtia. Tla melawak yen Rey de Israel, ma temo de itech krus, para tikneltokaskej nik melawak yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tla okitlalij itlaneltokalis inawak Dios, tonses ma kimakixti in Dios, tla melawak kitlasojtla. Porke Yej okijtoj nik in Yej teKone de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","In ichtekej katlej okinmajmasoltijkej itech krus iwan Jesús noijki otlajtoayaj biero de Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ijkuakón itech nochi in tlaltikpak otlatleyuak, desde tlajko tonale asta las tres de tiotlakke. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iwan itech yon ora kej las tres de tiotlakke, Jesús otzajtzik chikawak: ―Elí, Elí, ¿lama sabactani? ―kijtosneki: Dios mío, Dios mío, ¿tlanik otinechkaj noselti? ");
INSERT INTO nhyNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sekimej katlej ompa oyekaj, okikakej iwan okijtojkej: ―Yin tlakatl kinotza in profeta Elías. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","San niman ijkuakón se de yejwan omotlaloj okikuito se esponja, iwan satepan de okisiaj ika iayo uvas xokok, okilpij itech se kuawitl iwan okiyaktilij para ma koni. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero oksekimej okijtojkej: ―Xikkawa. Ma tikitakan kox witz kimakixtiki in Elías. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús oksemi otzajtzik chikawak, iwan omikke. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iwan san niman ijkuakón in kortina de yen weyi tiopan otlajkotzayanke, desde tlakpak asta tlakxitlan. Otlalolinke ixko yin tlaltikpak, in temej otlajtlapankej, ");
INSERT INTO nhyNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","in mikkakuyoktin otlatlapokej. Iwan miekej mikkamej omoyolkuikej katlej otlaneltokakej inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yinmej katlej omoyolkuikej okiskej de ijtik inmikkakuyok satepan de omoyolkuik in Jesús, iwan okalakej itech weyikan de Jerusalén, katlej tlatiochiwaloj, kan miekej tlakaj okinmitakej. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","In kapitan iwan katlej iwan oyekaj okitlatokaj in Jesús, nijkuak okitakej otlalolinke iwan nochi tlan otlapanok, sa tekitl omomawtijkej iwan okijtojkej: ―Yin tlakatl melawak nik yen iKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ompa oyekaj miekej siwamej okonitokaj de wejka, katlej owalajkej iwan Jesús desde estado de Galilea asta Jerusalén katlej okipalewijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ompa oyeka in María de pueblo de Magdala, iwan María katlej inmaman in Jacobo iwan José, iwan noijki ompa oyeka inmaman katlej ipilwan in Zebedeo. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nijkuak owalixtlamikke, oejkok se tlakatl de pueblo de Arimatea katlej okimopialiaya, itoka José, iwan katlej noijki oyeka imomachtijkaw in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yon José oyáj okitato in Pilato iwan okitlajtlanilij itlalnakayo in Jesús. Tonses in Pilato otlanawatij ma kimakakan. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José okitemowij itlalnakayo in Jesús de itech krus iwan okimiloj ika se sábana chipawak ");
INSERT INTO nhyNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","iwan okitlalij ijtik imikkakuyok yankuik, katlej okikuyonijkej ikxitlan se tepejxitl. Okitankachojtiaj se weyi tetl tankachtik para ika okikamatzakke, iwan satepan oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ompa oyeka in María de pueblo de Magdala iwan oksé María, oewatokaj iyakapan mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Owalmostlatik, satepan de yen tonale nijkuak in judiojtin omotlayektlaliliayaj para mosewiskej itech weyi tonale, in tlayekankej tiopixkej iwan fariseos, oyajkej okitatoj in Pilato ");
INSERT INTO nhyNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","iwan okilwijkej: ―Nian otimitzitakoj tejwatzin, porke otikelnamikej ke nekáj tekajkayaj, nijkuak ok onemia, okijtoj ke satepan de mikini ipan eyi tonale moyolkuini. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Por yonik, xitlanawati ma kitlatokan in mikkakuyoktle asta ma ajsi eyi tonale, amo san kichiwa imomachtijkawan yaskej kikixtitiwej de yuak, iwan satepan kijtojtinemiskej nik omoyolkuik satepan de omikke. Porke in tlamo, okachi kinkajkayawas in tlakaj iwan amo san ken achtoj okinkajkayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato okinmilwij: ―Nian katej nosoldadojwan. Xikinwikakan iwan ompa namejwan xikitakan de kuale ma tlachixtokan asta kan welij. ");
INSERT INTO nhyNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tonses oyajkej iwan kuale okiyekkamatzakej in mikkakuyoktle iwan okiseyarojkej in tetl katlej ika okikamatzakej, iwan ompa okinkajtejkej in soldadojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nijkuak yopanok in weyi tonale, iwan yotlanestiwalaya de yen yakinika tonale de yen samana, María de pueblo de Magdala, iwan oksé María, oyajkej okitatoj in mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Iwan san niman ijkuakón owaltlalolinke, porke se iángel in Señor owaltemok de ilwikak iwan owalaj kan kajki in mikkakuyoktle, okijkuanij in tetl katlej ika okamatzaktoka iwan ipan omotlalij. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","In ángel opetlania kej se tlapetlanalistle, iwan itzotzol oyeka istak kej mixtle katlej sa tekitl istak. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","In soldadojtin nijkuak okitakej sa tekitl opapatlakakej (obibiokakej) de nemajmawtile, iwan omokajkej kej mikkamej. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ijkuakón in ángel okinmilwij in siwamej: ―Amo ximomawtikan. Nej nikmati nik ankitemoaj in Jesús, katlej okimajmasoltijkej itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mach nian kajki, porke in Yej yomoyolkuik, ijkón ken Yej okijtoj. Xiwikikan xikitakij kan ankitlalijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iwan xiwian totoka iwan xikinmilwikan imomachtijkawan nik in Yej yomoyolkuik de itech imikilis. Iwan Yej tlayekanas yas para Galilea iwan namejwan ompa ankitajsiskej. Yen yin tlan omonekia namechilwiani. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ijkuakón in siwamej okiskej de kan mikkakuyoktle iwan oyajkej totoka ika miek nemajmawtile iwan ika miek pakilistle. Omotlalojkej okinmatiltitoj imomachtijkawan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pero, Jesús okinnamikke ipan ojtle iwan okintlajpaloj. Tonses in siwamej omijkuanijkej inawak Jesús, okimetznapalojkej iwan okiweyikixtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús okinmilwij: ―Amo ximomawtikan. Xiwian xikinmilwitij nokniwan ma wian para Galilea, iwan ompa nechitajsij. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mientras in siwamej oyajkej kan oyekaj in momachtijkej, sekimej soldadojtin katlej okitlatokaj in mikkakuyoktle oyajkej itech weyikan de Jerusalén okinmatiltitoj in tlayekankej tiopixkej nochi tlan otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Yonmej tlayekankej tiopixkej oyajkej omotlapowitoj inwan tlayekankej tetajtzitzintin, iwan satepan de omotlalijkej san se tlajtole, okinmakakej miek tomin in soldadojtin, ");
INSERT INTO nhyNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","iwan okinmilwijkej: ―Namejwan xikijtokan ke imomachtijkawan oyajkej de yuak okichtekitoj itlalnakayo, mientras namejwan ankochtokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Iwan tla in gobernador kimatis ke ankochtokaj iwan kualanis, tejwan iwan timotlapowiskej para amitlaj ma amechilwi. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tonses in soldadojtin okitilankej in tomin iwan okichijkej ijkón ken okinmilwijkej. Iwan asta axan ijkón kineltokaj in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","In majtlaktin iwan se momachtijkej oyajkej para Galilea, ipan se tepetl kan Jesús okinmilwij ompa motaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iwan nijkuak okitakej in Jesús okiweyikixtijkej. Maski sekimej mach okineltokayaj kox yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús omijkuanij innawak iwan okinmilwij: ―NoPapan Dios onechmakak nochi tekiwajkayotl para ma nitlanawati ompa ilwikak iwan ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Por yonik, xiwian iwan xikinmachtikan nochtin in tlakaj de ixko yin tlaltikpak para ma yekan nomomachtijkawan. Iwan xikinkuateekikan ika itoka noPapan, ika itoka iKone, iwan ika itoka in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Iwan xikinmachtikan ma kichiwakan nochi tlan Nej yonamechnawatij. Iwan xikelnamiktokan nik in Nej amowan nietos nochi tonale, asta ijkuak tlamis in tlaltikpak. Ijkón ma yeto.");
INSERT INTO nhyNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ijkín nik opéj in kuale tlajtole katlej temakixtia de Jesucristo iKone in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","In profeta Isaías ya wejkawitl ijkín okijkuiloj: Niktitlani notlatematiltij moyakapan, ma mitzyektlalili in ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Se tlajtole mokaki tetzajtzilia kan tlawaki kijta: “Xikyektlalikan iwan xikmelawakan iojwi in Señor.” ");
INSERT INTO nhyNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Se tonale in Juan Tlakuateekij oyeka kan tlawaki okinkuateekijtoka in tlakaj, okinmilwiaya ma moyolkuepakan inawak toTajtzin Dios para ma kintlapojpolwi de intlajtlakol iwan ijkón welis mokuateekiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nochtin de yen estado de Judea, iwan nochtin de yen weyikan de Jerusalén, owalayaj okiwalkakiaj iwan okimokuitiayaj intlajtlakol. Juan okinkuateekiaya ijtik in weyatl Jordán. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Itzotzol in Juan oyeka de itzojmio kameyo iwan omotlajkoilpiaya ika se kuetlaxtle, iwan okinkuaya chapulimej (xolinmej) iwan okikuaya nektle. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iwan Juan otetlapowiaya ijkín: ―Nokuitlapan witz se katlej nechpanawilia, porke okachi weyikistok (weyititok) ke nej, iwan mach notech powi nion para nimotoolos nikaktotomas. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nej onamechkuateekij ika atl pero Yej amechkuateekis ika Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Itech yonmej tonaltin, Jesús owalaj de itech ipueblo Nazaret de estado de Galilea, iwan Juan okikuateekij in Jesús ijtik in weyatl Jordán. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Nijkuak Jesús owalmej de ijtik atl, ijkuakón okitak in ilwikak otlapowik iwan in Espíritu Santo owaltemok ipan Jesús kej se paloma. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iwan omokakke se tlajtole de ilwikak. Okijtoj: ―Tej tinotlasojKone, iwan sa tekitl nipaki monawak. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ijkuakón in Espíritu Santo okiwikak in Jesús kan tlawaki. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ompa omokaj omenpoale tonale, oyeka innawak yolkamej tekuanimej. Iwan ompa in Satanás okinekia kitlajtlakolmayawini in Jesús, pero satepan owalajkej in angelestin iwan yejwan okimonekuitlawijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Satepan de okitzakej in Juan ijtik telpiloyan, Jesús oyáj Galilea okitematiltito in kuale tlajtole katlej temakixtia de kenik in Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Okijtoaya: ―Yoajsiko in tonale para Dios tlanawatis amotech. Ximoyolkuepakan inawak Dios iwan xikneltokakan in kuale tlajtole katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús opanotiaya itempan lago de Galilea iwan ompa okinmitak in Simón iwan Andrés katlej iknimej, okintlamotlatokaj inmichmatlawan ijtik atl porke yejwan oyekaj michmajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús okinmilwij: ―Namejwan anmichmajkej. Pero axan xiwikikan nonawak, para ankintlapowiskej in tlakaj de notlajtol para ma momakixtikan kej yeskia ankinkitzkiskej michimej. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","San niman okinkajtejkej inmichmatlawan iwan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesús oyáj ok achitzin tlayakapan, iwan okinmitak in Jacobo iwan Juan katlej iknimej, itelpokawan Zebedeo, oyekaj ijtik se barko okinyejyektlalijtokaj inmichmatlawan. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesús san niman okinnotzke, iwan yejwan kiné okikajtejkej intaj Zebedeo ijtik barko iwan itekipanojkawan, iwan yejwan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesús oajsito itech pueblo de Capernaum, iwan itech se sábado, nijkuak weyi tonale, Jesús okalakke itech se tiopan de yen judiojtin iwan opéj kinmachtia. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","In tlakaj sa otlajtlachiayaj (omomajmawtiayaj) de kenik okinmachtiaya, porke Yej okinmachtiaya ika chikawak tlanawatile iwan amo ken otlamachtiayaj in tlamachtijkej de itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Itech yon tiopan oyeka se tlakatl katlej okipiaya se ejekatl mach kuale, iwan okualankatzajtzik. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Okijtoj: ―¿Tlan tikneki towan, Jesús de Nazaret? ¿Otiwalaj otechxixiniko? Nej nikmati akin Tej, Tej tiiyolchipawkaKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús okajwak in ejekatl mach kuale, iwan okilwij: ―¡Xiktzakua moten, iwan xikisa de itech yin tlakatl! ");
INSERT INTO nhyNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","In ejekatl mach kuale okitoktij in tlakatl ma mimiki chikawak, iwan okiske de itech. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nochtin omomawtijkej iwan omotlajtlaniayaj: ―¿Tlanon kijtosneki yin? ¡Tlamachtia ika se tlamantle yankuik iwan ika chikawak tlanawatile! Asta yen ejekamej mach kualtin kinnawatia iwan kitlakitaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iwan totoka omomatke tlan Jesús okichiwaya itech nochi in estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nijkuak okiskej de itech yon tiopan, Jesús, Jacobo iwan Juan, oyajkej ichan Simón iwan noijki ichan Andrés. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Imonan Simón owetoka ika miek totonik. Jesús okilwijkej mokokoa imonan Simón. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iwan Yej omijkuanij inawak, okimakitzkij iwan okewaltij. Iwan ijkuakón san niman okiske in totonik iwan opéj kintlamaka. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nijkuak opoliwito in tonale iwan otlatleyuak, okinwikilijkej in Jesús nochtin kokoxkej, iwan katlej okipiayaj ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iwan nochtin tlakaj de yon pueblo omololojkej kaltempan. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús okinsewij (okinpajtij) de nochi kokolistle, iwan okinkixtij miekej demoniojtin pero mach okinkawilij ma tlajtokan porke yejwan okixmatiaj in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","San kualkan ok otlatleyuatoka, Jesús omejke iwan okiske, iwan oyáj se lado kan yetos san Yej iselti para motiotzajtzilis. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón iwan oksekimej katlej iwan oyekaj, oyajkej okitemotoj in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nijkuak okajsikej okilwijkej: ―Nochtin mitztemoaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iwan Yej okinnankilij: ―Ma tiwian intech oksekimej pueblojtin katlej katej serka, para nikinmatiltis in kuale tlajtole porke por yonik oniwalaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ijkón Jesús onenke itech nochi in estado de Galilea okintlapowij de yen kuale tlajtole iwan okinkixtij in demoniojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Se tlakatl katlej opalania inakayo omijkuanij inawak Jesús, omotlankuaketzke iwan okilwij: ―Tla tikmonekiltis, tiwelis tinechpajtis. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús okiknomaj, okitlalij ima ipan yon tlakatl iwan okilwij: ―Aján, nikneki. Axan san niman xipajti. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","San niman okiske ikokolis iwan omokaj chipawak. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús okimakaj san niman, iwan okinajnawatij okilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Xikkaki, iwan amakaj xiktlapowi, san xiwia inawak in tiopixke, iwan xiktemaka moofrenda tlan Moisés otlanawatij ma motemaka para ijkón nochtin ma kimatikan nik in Dios yomitzpajtij de mokokolis. ");
INSERT INTO nhyNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero nijkuak in tlakatl oyáj, opéj nochtin kintlapowia de kenik opajtik. Por yonik in Jesús mach ok owelia okalakia itech pueblojtin, okalakia san ichtaka. Iwan omokawaya kalan kan amakaj chanti, pero in tlakaj owalayaj de nochtin pueblojtin okiwalitayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kanaj keski tonale satepan, Jesús oksemi omokuepke para Capernaum. In tlakaj okimatkej nik in Yej oyeka itech se kale. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Omololojkej miekej tlakaj, iwan mach ok oakej kalijtik iwan miekej omokajkej kaltempan, iwan Yej okinmatiltiaya in kuale tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ijkuakón owalajkej nawin tlakaj kan Jesús oyeka, okualwikiliayaj se tlakatl katlej owijwilantik. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Komo sa tekitl miekej tlakaj oyekaj, mach owelik okikalakijkej kalijtik. Ijkuakón in kale okikuatlapojkej iwan ik ompa okitemowijkej ika nochi itlapech. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nijkuak Jesús okitak intlaneltokalis, ijkuakón okilwij in kokoxke: ―Nokone, nimitztlapojpolwia de nochi motlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Sekimej tlamachtijkej de itlanawatil in Moisés ompa oewatokaj, iwan okiyejyekojkej: ");
INSERT INTO nhyNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tlanik yin tlakatl ijkón kijta? Tlajtoa biero de Dios. San yen Dios welis tetlapojpolwis.” ");
INSERT INTO nhyNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesús okimatia tlan yejwan okiyejyekoayaj, iwan okinmilwij: ―¿Tlanik namejwan ankiyejyekoaj mach kuale? ");
INSERT INTO nhyNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Katlij yen okachi mach owij nikilwis in kokoxke: “Nimitztlapojpolwia de nochi motlajtlakol”, o noso nikilwis: “Ximewa. Xikajkokui motlapech iwan xinejnemi”? ");
INSERT INTO nhyNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ijkín Nej nikchiwa para ijkón namejwan xikmatikan nik in Nej katlej onimochij nitlakatl, nikpia poder ixko yin tlaltikpak para nikintlapojpolwis in tlakaj de intlajtlakol. Ijkuakón okilwij in tlakatl katlej owijwilantik: ");
INSERT INTO nhyNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Tej nimitzilwia, ximewa, xikajkokui motlapech iwan xiwia mokalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","San niman in kokoxke omejke, okajkokke itlapech iwan oyáj. Nochtin katlej okitakej sa otlajtlachixkej (omomajmawtijkej) iwan okiweyikixtijkej in toTajtzin Dios, iwan okijtojkej: ―¡Mach semi otikitayaj yin tlamantle! ");
INSERT INTO nhyNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesús oksemi oyáj itempan lago de Galilea, miekej tlakaj omololojkej ompa iwan okinmachtij. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Oyáj okachi tlayakapan iwan okitak in Leví, itelpoch in Alfeo, oewatoka kan yej kololoa impuestos. Jesús okilwij: ―Xiwiki nowan. Leví omoketzke iwan okiwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús oyáj otlakuato ichan Leví. Miekej katlej tlakobraroaj ika impuestos iwan sekimej tlajtlakolejkej, noijki oyajkej, iwan omotlalijkej iwan Jesús iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","In fariseos iwan katlej tlamachtijkej de itlanawatil in Moisés, okitakej in Jesús otlakuajtoka inwan katlej tlakobraroaj ika impuestos iwan tlajtlakolejkej, iwan okintlajtlanijkej imomachtijkawan: ―¿Tlanik in Jesús tlakua iwan koni inwan tlakaj tlajtlakolejkej iwan katlej tlakobraroaj ika impuestos? ");
INSERT INTO nhyNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús okinkakke iwan okinmilwij: ―In tlakaj katlej mach mokokoaj mach intech moneki tepajtij. Nej mach oniwalaj onikinnotzako katlej yolchipawakej, onikinnotzako katlej tlajtlakolejkej para ma moyolkuepakan inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Imomachtijkawan in Juan iwan fariseos mach otlakuayaj porke omomatokaj omosawayaj. Sekimej owalajkej kan Jesús oyeka iwan okilwijkej: ―¿Tlanik imomachtijkawan in Juan iwan fariseos mosawaj iwan momomachtijkawan mach mosawaj? ");
INSERT INTO nhyNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús okinmilwij: ―Katlej iinbitadoswan in novio mach kinekiskej mosawaskej nijkuak yej monamiktijtok, nijkuak ok ilwichijtoskej iwan novio mach welis mosawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Porke ajsis tonale nijkuak in novio mach ok inwan yetos, iwan ijkuakón welis mosawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mach akaj kiyektlalia se tzotzole katlej ya tlajtlantok iwan kitilichoa ika se pedaso tzotzole yankuik, porke in tzotzole yankuik mololoa iwan kitzayana in tzotzole katlej ya tlajtlantok, iwan okachi tzayani. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mach akaj kitlalia vino yankuik ijtik kulambre katlej ya tlajtlantok. In vino yankuik kitzomonia in kulambre katlej ya tlajtlantok, iwan nokiwi in vino iwan kulambre ijtlakawi. In vino yankuik moneki motlalis ijtik in kulambre yankuik. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se tonale Jesús onejnentiaya kan toktok trigo meroj nijkuak weyi tonale. Nijkuak ik ompa opanotiayaj imomachtijkawan opéj kitekij in trigo. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","In fariseos okitlajtlanijkej in Jesús: ―Xikita, ¿tlanik in yejwan kichiwaj tlan itlanawatil in Moisés kijta amo se ma kichiwa itech weyi tonale? ");
INSERT INTO nhyNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iwan Yej okinmilwij: ―¿Amo ankileroaj tlan okichij in rey David nijkuak yej iwan ikompañeroswan otiojsijkej? ");
INSERT INTO nhyNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David okalakke ikalijtik in Dios iwan okikuaj in pan katlej tlatiochiwaloj, nijkuak Abiatar oyeka weyi tiopixke. In tlanawatile de Moisés kijta nik san yen tiopixkej welis kikuaskej in pan, pero in David okikuaj iwan asta okinmajmakak ikompañeroswan. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Noijki in Jesús okinmilwij: ―Dios achtoj okinchij in tlakaj, iwan satepan okichij in weyi tonale para kinpalewis in tlakaj. Pero Dios mach okichij in weyi tonale para ma kinnawati in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Por yonik, Nej katlej onimochij nitlakatl, Nej nikpia de nikijtos tlanon kuale se kichiwas nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús oksemi oyáj itech se tiopan iwan ompa okitak se tlakatl katlej owakke se ima. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Sekimej fariseos moxikoanimej, okonitokaj in Jesús kox kipajtis yon tlakatl itech weyi tonale para ika welis kitilwiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ijkuakón Jesús okilwij in tlakatl katlej owakke ima: ―Ximoketza tlayakapan. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Tonses, Jesús okintlajtlanij in fariseos: ―¿Tlan kijta itlanawatil in Moisés, kipia de mochiwas tlan kuale itech weyi tonale, o noso mochiwas tlan mach kuale? ¿Moneki se kipalewis in tlakatl itech inemilis o noso se kixpolos? Pero yejwan mach ok itlaj okijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús okintlatak in fariseos iwan okualanke, iwan omoyolkokoj porke sa tekitl yoltlakuawakej. Ijkuakón okilwij in kokoxke: ―Xikmelawa moma. In kokoxke okimelaj ima iwan san niman ijkuakón opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","In fariseos okiskej omotlatlalwitoj inwan itekipanojkawan Herodes, para kitemoskej kenik welis kimiktiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús oyáj itempan lago inwan imomachtijkawan, miekej tlakaj noijki oyajkej, de estado de Galilea iwan de estado de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","De weyikan de Jerusalén iwan de estado de Idumea, iwan katlej katej ikuitlapan in weyatl Jordán, iwan de yen pueblojtin katlej katej serka de yen weyikan de Tiro iwan de Sidón. Sa tekitl miekej tlakaj oyajkej inawak Jesús nijkuak okimatkej tlan Yej okichiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesús okinmilwij imomachtijkawan ma kijkuanilikan se barko para itech tlejkos, para amo ma kipajpatzmiktikan in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Sa tekitl miekej okinpajtij, asta oksekimej kokoxkej sa omopatzmiktiayaj entre yejwan, porke nochtin okinekiaj kitilkoanij in Jesús para pajtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nijkuak in demoniojtin okitakej in Jesús, omotlankuaketzkej iyakapan iwan okuawtzajtzikej: ―¡Tej titeKone de Dios! ");
INSERT INTO nhyNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Yej okinmajwak chikawak iwan okinmilwij mach itlaj ma kijtokan de Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jesús otlejkok ipan se tepetl, okinnotzke katlej Yej okinpejpenke iwan yejwan owalajkej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ijkón okinpejpenke in majtlaktle iwan ome itlatitlanilwan para ma yetokan inawak, iwan para kintitlanis ma kitematiltikan itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jesús okinmakak poder para kinpajtiskej kokoxkej iwan para kinkixtiskej demoniojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yinmej tlakaj yejwan katlej Jesús okinpejpenke: In Simón okitokayotij Pedro, noijki ");
INSERT INTO nhyNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","okinpejpenke in Jacobo iwan Juan katlej iknimej, itelpokawan Zebedeo, katlej Jesús okintokayotij Boanerges, kijtosneki kuejsijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Noijki okinpejpenke: Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo itelpoch in Alfeo, Tadeo, Simón katlej onemia inwan cananistas, ");
INSERT INTO nhyNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","iwan Judas Iscariote, katlej satepan okitemaktij (okitemaktilij) in Jesús inmak tekiwajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Satepan Jesús oyáj itech se kale. Oksemi omololojkej miekej tlakaj, por yonik Yej iwan imomachtijkawan asta mach ok oweliaj oyektlakuayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nijkuak okimatkej ifamiliareswan in Jesús, oyajkej okinotzatoj, yejwan okimolwiayaj yokuatlapoloj. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Sekimej tlamachtijkej de itlanawatil in Moisés owalajkej de weyikan de Jerusalén. Iwan yejwan okijtojkej: ―Yin Jesús kipia se ejekatl mach kuale itoka Beelzebú, katlej tlayekanke demonio, yen Beelzebú okimakak ipoder para ma kinkixti ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús okinnotzke iwan okintlapowij ika ejemplos. Okinmilwij: ―¿Kenik welis in Satanás kikixtis in Satanás? ");
INSERT INTO nhyNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Se país mach welis motlajkoxelos porke mach ok welis monawatis. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tla se familia tlajkoxelitos noijki mach welis san sekan chantitoskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tla Satanás momagas inewian iwan motlajkoxelos, tonses mach ok yetos, sino san niman pojpoliwis. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Se ichtekke mach welis kalakis ichan se tlakatl katlej chikawak para kitlachtekis. Sino achtoj moneki kijilpis iwan ijkuakón welis kitlachtekis. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Ipan melajka namechilwia, nochtin katlej kichiwaj tlajtlakole iwan tlajtoaj biero, Dios welis kintlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero tla akaj tlajtoa biero de yen Espíritu Santo, Dios mach keman kitlapojpolwis, sino yetos tlajtlakolej para iktlanke (ik tlami). ");
INSERT INTO nhyNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús ijkón okinmilwij, porke yejwan okijtojkej ke Yej kipia se ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ijkuakón oejkokej imaman iwan ikniwan in Jesús pero omokajkej kalan. Katlej ompa oyekaj kalan okinmilwijkej ma konnotzakan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","In tlakaj katlej oewatokaj iwan okiyawalojtokaj in Jesús, okilwijkej: ―Momaman iwan mokniwan mitztemoaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yej okinnankilij: ―¿Akin nomaman iwan akin nokniwan? ");
INSERT INTO nhyNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Okintlatak katlej ompa okiyawalojtokaj iwan okijtoj: ―Yinmej yejwan nomaman iwan yejwan nokniwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nochtin katlej kichiwaj tlan Dios kineki, yen yon nokni tlakatl, yen yon nokni siwatl iwan yen yon nomaman. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús oksemi opéj tlamachtia inakastlan lago de Galilea. Sa tekitl miekej tlakaj omololojkej inawak, iwan okachi kuale otlejkok itech se barko katlej oyeka tlatentle ijtik atl iwan ompa ipan omotlalij. In tlakaj oyekaj itempan atl. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Okinmachtij de miek tlamantle iwan okintlapowij ika ejemplos para ma kimomakakan kuenta. Okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―¡Xikkakikan kuale tlan namechilwis! Se tlakatl okiske otookato. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nijkuak otookatoka, sekin semiya owetzke ipan ojtle. In totomej owalajkej iwan okikuajkej in semiya. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Oksekin owetzke ijtik teyoj, okiske totoka porke mach okipiaya miek tlale. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero nijkuak chikawak otonak, okichichinoj porke mach okipiaya wejkatlan inelwayo. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Oksekin owetzke itzalko in bierojxiwitl, omoskaltij okachi miek yon xiwitl, iwan tlatoktle mach semi omoskaltij porke oxiwmikke iwan mach otlakke. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Oksekin owetzke kan kuale tlale, okiske iwan otlakke miek. Sekin semiya okitemakak senpoale iwan majtlaktle itliolo san de se semiya, iwan oksekin okitemakak eyinpoale itliolo iwan oksekin asta se siento itliolo. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Iwan okinmilwij: ―Tla ankinekij ankimomakaskej kuenta, xikkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nijkuak omokaj sa yen Jesús, in majtlaktle iwan omen iwan kanaj keskimej oksekimej, ijkuakón okitlajtlanijkej in Jesús tlan kijtosneki in ejemplo de yen tlatookak. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yej okinmilwij: ―Namejwan Dios yoamechkawilij xikmatikan tlan oyeka tlatitok de kenik in Dios tlanawatia. Oksekimej katlej mach ya kimatij, se kinmatiltia ika ejemplos. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Para ijkón, maski ma kitakan, mach ma kimomakakan kuenta tlan kitaj. Iwan maski ma kikakikan, mach ma kimatikan tlanon kijtosneki tlan kikakij. Iwan ijkón yejwan mach moyolkuepaskej, iwan Dios mach kintlapojpolwis de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesús okinmilwij: ―Tla amo ankimomakaj kuenta yin ejemplo, tonses ¿kenik welis ankimomakaskej kuenta de yen oksekimej ejemplos? ");
INSERT INTO nhyNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tlan omotookak yon kej yeskia yen itlajtol in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","In semiya katlej owetzke ipan ojtle yon kej yeskia yejwan katlej kikakij in tlajtole, pero san niman ejko in Satanás iwan kikixtia in tlajtole katlej omotookak ipan inyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","In semiya katlej owetzke ijtik teyoj, yon ken se tlakatl katlej kiresibiroa itlajtol in toTajtzin Dios ika pakilistle nijkuak kikaki. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero mach wejkatlan monelwayotia iwan san niman nelwayowaki ipan iyolo. Pewa trabajojpanoa iwan pewa kitlatlalochtiaj por yen itlajtol in toTajtzin Dios, walmosotlawa iwan kikawa in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","In semiya katlej owetzke itzalko in bierojxiwitl, yon ken sekimej katlej kikakij in tlajtole, ");
INSERT INTO nhyNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero sa tekitl tlanemiliaj itech tlamantin de yin nemilistle, kawiliaj ma moskalti in bierojxiwitl ipan inyolo. Kinekij kipiaskej miek tomin iwan kinekij kipiaskej miek tlamantle, yon ken bierojxiwitl katlej mach kikawilia ma tlaki in tlatoktle de yen itlajtol in Dios ipan inyolo. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","In semiya katlej omotookak kan kuale tlale, yon ken tlakaj katlej melawak kikakij itlajtol in Dios iwan kiresibiroaj ipan inyolo. Yonmej tlakaj katej ken semiya katlej kitemakaj senpoale iwan majtlaktle intliolo san de se semiya, iwan sekimej kitemakaj eyinpoale intliolo, iwan sekimej kitemakaj asta se siento intliolo. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesús okinmilwij: ―Mach akaj kitlalia se tlanextle itlampa se chikiwitl o noso itlampa se tlapechtle. Sino motlalia ajkopan para ma tlawi. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nochi katlej amo momati kipia por momatis, iwan nochi katlej kajki tlatitok kipia por nesis. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tla ankinekij ankimomakaskej kuenta, xikkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesús okinmilwij: ―Moneki kuale xikkakikan tlan ankikakij. Ijkón ken tlan namejwan ankitemakaskej, Dios no ijkón amechmakas iwan amechmakas asta okachi. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Porke akin kinekis moskaltis okachi itech itlajtol in Dios, moskaltis okachi. Iwan katlej amo kinekis, kipolos asta tlan ya kimati. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús okijtoj: ―Namechilwis se ejemplo para xikmatikan kenik in Dios tlanawatia: se tlakatl otlatookak itlalaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tla kochis nochi yuale iwan tla mewas o noso amo mewas nochi kualkan, in tlatoktle moskaltijtiw, pero yej mach kimati kenik moskaltia, ");
INSERT INTO nhyNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","inewian in tlale kitlakiltia in tlatoktle, achtoj kisa iwan moxiwyotia iwan satepan miawati, xiloti iwan motliolotia. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Iwan nijkuak walchikawa, in tlakatl kipixka porke yokualtik. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Satepan Jesús okinmilwij: ―¿Tlan ika welis tikparejaroskej para xikmomakakan kuenta kenik in Dios tlanawatia? O noso, ¿tlan ejemplo welis namechilwis para okachi xikmomakakan kuenta? ");
INSERT INTO nhyNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Yon ken iyolo mostaza, katlej okachi tzikitzin de miek oksekin semiya. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero nijkuak se kitooka, kisa iwan moskaltia okachi weyi de nochi namotlatok. Momamayotia iwan totomej asta itech motepajsoltiaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús okintlapowij ika miek ejemplos asta kan okimomakayaj kuenta in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Pero nijkuak oyeka san Yej iwan imomachtijkawan, okinyekilwiaya para ma kimomakakan kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Itech yon tonale nijkuak otleyuak, Jesús okinmilwij imomachtijkawan: ―Ma tipanokan oksé lado. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tonses, imomachtijkawan okinkajtejkej in tlakaj katlej ompa inwan oyekaj iwan okiwikakej in Jesús itech se barko katlej itech yoyeka. Oksekimej barkojtin noijki no oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Satepan owalaj se ejekatl chikawak iwan atl opéj motlamotla ipan barko iwan opéj atemi. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús okochtoka tlakuitlapan ipan se ikpale. Iwan okijxitijkej okilwijkej: ―¡Tlamachtij! ¿Amo tikmomaka kuenta nik tiapolakij? ");
INSERT INTO nhyNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yej owalmej iwan okajwak in ejekatl iwan okilwij in atl: ―¡Ximoketza! ¡San xieto! San niman in ejekatl omoketzke iwan atl sa omokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesús okinmilwij imomachtijkawan: ―¿Tlanik wel anmomawtiaj? ¿Ayamo antlaneltokaj inawak Dios? ");
INSERT INTO nhyNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yejwan sa tekitl omomawtijkej iwan okimolwijkej entre yejwan: ―¿Akin Yin tlakatl, porke asta yen ejekatl iwan atl kitlakitaj? ");
INSERT INTO nhyNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús iwan imomachtijkawan oajsitoj oksé lado de yen lago asta ipan intlal in gadarenostlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nijkuak Jesús otemok de itech barko, san niman ijkuakón se tlakatl omijkuanij inawak Jesús. Yon tlakatl ochantia ijtik mikkakuyoktin iwan okipiaya se ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Mach akaj owelia okilpiaya nion por ika kadena. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Miek buelta okimaijilpiayaj iwan okimetzijilpiayaj (okikxijilpiayaj) ika kadena, pero yej omokotonaya. Mach akaj owelia okitlania. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tonayan iwan yuak, onemia kan teyoj iwan ijtik kuyoktin kan okinkalakiayaj mikkamej. Otzajtzitinemia iwan omotejtekia ika tetl. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nijkuak yon tlakatl okitak in Jesús desde wejka, omotlaloj iwan omotlankuaketzke iyakapan. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Iwan otzajtzik chikawak: ―¿Tlan tikneki nowan, Jesús, iKone in Dios Weyikistok (Weyititok)? ¡Nimitztlatlawtia ika itoka in Dios amo xinechtitlani ijtik tliko! ");
INSERT INTO nhyNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesús okilwij: ―¡Tej ejekatl mach tikuale, xikisa de itech yin tlakatl! ");
INSERT INTO nhyNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iwan Jesús okitlajtlanij: ―¿Tlan motoka? Yej okilwij: ―Notoka miek porke timiekej. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","In ejekamej mach kualtin omotlatlawtijkej amo ma kintitlani wejka de itech yon región. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ik ompa oyekaj miekej pitzomej otlakuajtokaj inakastlan tepetl. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Iwan ejekamej mach kualtin okitlatlawtijkej, okilwijkej: ―Xitechkawili ma tikalakikan intech nekatej pitzomej. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús okinkawilij kiné, iwan in ejekamej mach kualtin okiskej de itech in tlakatl iwan okalakej intech yonmej pitzomej, iwan yonmej pitzomej okikistewakej iwan omotepejxiwitoj ijtik atl iwan ompa omoatlanwijkej iwan omikkej. Oyekaj kej ome mil pitzomej. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Katlej okinmonekuitlawiayaj in pitzomej omotlalojkej oyajkej itech pueblo iwan itech tlalmej, otetlapowitoj de tlan otlamochij. Miekej omololojkej iwan okitakoj tlan otlamochij. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Nijkuak oajsikoj kan oyeka in Jesús, okitakej in tlakatl katlej okinpiaya ejekamej mach kualtin, ewatok iwan ya tzotzoltitok iwan ya kipia kuale itlalnamikilis. In tlakaj omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","In tlakaj katlej okitakej tlan otlamochij otetlapowijkej de tlan otlapanok de yen tlakatl iwan de yen pitzomej. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ijkuakón okitlatlawtijkej in Jesús ma wia de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús otlejkok itech se barko. In tlakatl katlej okinpiaya in ejekamej mach kualtin, okitlatlawtij in Jesús ma kiwika. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero in Jesús mach okawilij, iwan okilwij: ―Xiwia mochan kan katej mofamiliareswan, iwan xikinmaka kuenta in wejweyin tlamantin tlan Dios okinchij por tej, iwan kenik in Señor omitziknomaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","In tlakatl oyáj, iwan opéj tetlapowia itech nekáj región kan oyekaj majtlaktle pueblojtin kan kitokaxtiaj Decápolis, ompa opéj kintlapowia nochtin tlakaj tlan Jesús okichij por yej, iwan nochtin sa otlajtlachiayaj (omomajmawtiayaj). ");
INSERT INTO nhyNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús oksemi opanok oksé lado de yen lago itech barko, iwan miekej tlakaj omijkuanijkej inawak inakastlan lago. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Satepan se tlakatl itoka Jairo, katlej oyeka se de yen tlayekankej de itech intiopan in judiojtin de yon lugar, nijkuak okitak in Jesús, omijkuanij iwan omotlankuaketzke iyakapan. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Iwan okitlatlawtij: ―Nochpoch ya ixpolitok. Xiwia nochan iwan xiktlali moma ipan nochpoch para ma pajti. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús oyáj, iwan miekej tlakaj noijki oyajkej asta sa okipajpatzmiktiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ompa tlatzalko oyaya se siwatl kokoxke. Yokipiaya majtlaktle iwan ome xiwitl de oestlapowik. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yomotlamij de inwan tepajtijkej iwan yokitlamij nochi itomin katlej okipiaya. Mach opajtia yej okachi omochiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nijkuak okimaj otlapoayaj de Jesús, oyáj okitato, omotititzke intzalko in tlakaj iwan okitzotzolkitzkij in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Okimolwiaya: “Tla siera najsis niktlakenkitzkis, welis nipajtis.” ");
INSERT INTO nhyNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","San niman nijkuak okitzotzolkitzkij omoketzke iestlapowilis iwan san niman okimachilij opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús totoka okimomakak kuenta ke ika ipoder okipajtij akaj. Omokuepke ik tlakuitlapan iwan okinmilwij in tlakaj katlej Iwan oyayaj: ―¿Akin okikitzkij notlaken? ");
INSERT INTO nhyNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Imomachtijkawan okilwijkej: ―Tikita miekej tlakaj towan witzej asta sa techpajpatzmiktijtiwitzej. ¿Tlanik titlajtlani? “¿Akin okikitzkij notlaken?” ");
INSERT INTO nhyNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesús okintlatak nochtin tlakaj para kitas akin ijkón okichij. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","In siwatl omomajmawtij iwan opapatlakak (obibiokak) porke okimomakak kuenta tlan yotlamochij itech. Omijkuanij, omotlankuaketzke iyakapan Jesús iwan okimakak kuenta de yen tlan omochiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iwan Jesús okilwij: ―Nokone, motlaneltokalis omitzpajtij. Xiwia ika pakilistle, yotisewik de mokokolis. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nijkuak ok otlapojtoka in Jesús, sekimej tlakaj owalajkej de ichan Jairo iwan okilwijkej: ―Mochpoch yomikke, ayakmo xikkuejsokan in Tlamachtij. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús okikakke iwan okilwij in Jairo: ―Amo ximomawti, tej sanwel xiktlali motlaneltokalis nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jesús mach okinekke ma wia akaj Iwan, san yen Pedro, iwan omen iknimej katlej intoka Jacobo iwan Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Oajsitoj ichan Jairo iwan okinmitajsikej motlatlaloaj in tlakaj, moyolkokoaj iwan kuawtzajtzij. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jesús omijkuanij iwan okintlajtlanij: ―¿Tlanik wel ankuawtzajtzij iwan anchokaj? Yin ichpochtle mach ya miki, yej kochi. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","In tlakaj okiwewetzkilijkej in Jesús, pero Yej okinkixtij nochtin de ompa kalijtik. Ijkuakón okinnotzke in tetajmej de yen ichpochtle, iwan eyin imomachtijkawan, iwan okalakej kalijtik kan oyeka yon ichpochtle. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Okimakitzkij yon ichpochtle iwan okilwij: ―Talita, kum ―kijtosneki: Ichpochtle, Nej nimitzilwia, ximewa. ");
INSERT INTO nhyNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","San niman yon ichpochtle katlej okipiaya majtlaktle iwan ome xiwitl, omejke iwan opéj nejnemi, iwan nochtin sa otlajtlachixkej (omomajmawtijkej). ");
INSERT INTO nhyNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús okinnawatij amitlaj ma kijtokan de tlan otlamochij. Iwan okinmilwij ma kitlamakakan yon ichpochtle. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús okiske de Capernaum iwan oyáj itech ipueblo Nazaret. Imomachtijkawan noijki oyajkej Iwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Itech weyi tonale, opéj tlamachtia itech se tiopan de yen judiojtin, miekej tlakaj omijkuanijkej para kikakiskej in Jesús. Miekej sa otlajtlachiayaj (omomajmawtiayaj) iwan okijtoayaj: ―¿Kan okuito yin tlakatl nochi tlan kichiwa, tlan ixtlamachilistle kipia? ¿Kenik weli kinchiwa nochtin yinmej milagrostin? ");
INSERT INTO nhyNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yin yen kuawtlaxinke, itelpoch in María iwan tikinmixmatij ikniwan intoka Jacobo, José, Judas iwan Simón. Noijki tikinmixmatij ikniwan katlej siwamej katlej nian chantij itech yin pueblo. Iwan omokuejsojkej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús okinmilwij: ―Akin tlapoa de Dios se kitlakitas ik nowian (nian nepa), pero mach kitlakitaskej itech ipueblo, nion iparienteswan iwan nion itech ichan. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Por yonik Jesús mach okinchij miekej milagrostin ompa. San inpan sekimej kokoxkej okitlalij ima, iwan opajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesús sa otlajtlachixke (omomajmawtij) porke mach otlaneltokayaj inawak. Iwan oyáj itech pueblojtin katlej katej ik ompa serka, ompa oyáj otlamachtito. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesús okinnotzke majtlaktle iwan ome imomachtijkawan iwan opéj kintitlani ojomen. Okinmakak poder para ma kinkixtikan ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iwan okinmilwij mach itlaj ma kitkikan nion se bolsa, nion tlakuale iwan nion tomin, san se karrotij ma kitkikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Welis kitkiskej inkakuan iwan intzotzol san yej tlan konakijtiwej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Okinmilwij: ―Nijkuak ankalakiskej itech se kale, ximokawakan ompa asta ijkuak ankisaskej de itech yon pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Tla kanaj mach amechresibiroaj o noso mach amechkakiliaj, san niman nijkuak ankisaskej de yon lugar, ximokxitlaltzejtzelokan. Ma kimomakakan kuenta nik mach kuale tlan yejwan kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Oyajkej iwan otetlapowijkej de itlajtol in toTajtzin Dios, okinmilwiayaj nochtin tlakaj ma moyolkuepakan de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Okinkixtijkej miekej ejekamej mach kualtin, iwan okintlalilijkej aseite miekej kokoxkej iwan opajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","In rey Herodes okikakke motlapowiaj de yen Jesús ik nowian (nian nepa). Iwan Herodes okijtoj: ―In Juan Tlakuateekij yomoyolkuik satepan de omikke iwan por yonik kinchiwa milagrostin. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Oksekimej okijtoayaj: ―Yon yen profeta Elías. Iwan oksekimej okijtoayaj: ―Yon se profeta ken katlej ya wejkawitl oyekaj profetajtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nijkuak in Herodes ijkón okikakke okijtoj: ―Yin yen Juan Tlakuateekij, katlej nej onitlanawatij ma kikechtzontekikan iwan axan yomoyolkuik oksemi satepan de omikke. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodes otlanawatij ma kikitzkikan in Juan, ma kijilpikan ika kadena iwan ma kitzakuakan telpiloyan. Herodes ijkón okichij para kipaktis isiwa katlej itoka Herodías. Herodías achtoj oyeka tesiwa de yen Felipe ikni in Herodes, pero satepan Herodes okisiwakixtilij in Felipe maski oyeka ikni. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","In Juan Tlakuateekij okilwiaya in rey Herodes: ―Tikchijtok se weyi tlajtlakole porke iwan tikaj mokoñada. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías okikokoliaya in Juan iwan okinekia kimiktis. Pero mach okajsia kenik kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes mach okinekia kimiktis in Juan porke okimatia nik in yej kuale tlakatl, por yonik Herodes okipiaya kuidado de amitlaj kitoktiskej in Juan. Herodes okiwelitaya ma kitlapowi in Juan, pero nijkuak okikakia, sa otlajtlachiaya (omomajmawtiaya) iwan mach ok okimatia tlan kijtos. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero se tonale in siwatl Herodías okajsik kenik kimiktis in Juan. Herodes okitemakak se tlaxkale nijkuak omixtonaltij (ikumpleaños). Okinnotzke nochtin tekiwajkej de yon país, kapitanmej de soldadojtin iwan katlej okachi tlatlayekantokej de itech estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ichpoch in Herodías owalaj iwan omijtotij inyakapan nochtin katlej ompa oyekaj. Herodes iwan iinbitadoswan sa tekitl okiwelitakej. Ijkuakón Herodes okilwij in ichpochtle: ―Xinechtlajtlanili san tlan tej tiknekis iwan nimitzmakas. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Iwan asta okilwij: ―Ipan melajka, san tlanon tinechtlajtlanilis, nimitzmakas asta tlajko de tlan niknawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Yon ichpochtle oyáj okitlajtlaniito imaman para ma kilwi tlanon kitlajtlanilis. Iwan imaman okijtoj: ―Xiktlajtlanili itzontekon in Juan Tlakuateekij. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","San niman omotlaloj in ichpochtle inawak Herodes iwan okilwij: ―Nikneki xinechmaka axan san niman, ika se plato itzontekon in Juan Tlakuateekij. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes sa tekitl omoyolkokoj, pero komo yokisentlalij itlajtol inmixpan iinbitadoswan, tonses okichij ijkón ken okijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tonses okinawatij se soldado ma kikuiti itzontekon in Juan Tlakuateekij. In soldado oyáj telpiloyan okechtzontekito in Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Satepan okitkik ika se plato iwan okimaktilij in ichpochtle. Iwan ichpochtle okimakak imaman. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nijkuak imomachtijkawan in Juan okimatkej, okitlajtlanitoj in mikkatl para kitookaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","In momachtijkej owalajkej inawak Jesús para kimatiltiskej nochi tlan okichijkej iwan tlan otlamachtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús okinmilwij: ―Xiwikikan nowan ik se lado iwan ximosewikan achitzin. Ijkón okinmilwij porke sa tekitl miekej tlakajtin owalayaj inawak Jesús, iwan asta mach ok omajxiliayaj otlakuayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Otlejkokej kiné itech se barko iwan oyajkej se lugar kan tlalkawale kan mach akaj tlakatl nemi. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Miekej okinmitakej iwan okinmixmatkej nijkuak oyajkej, ijkuakón noijki miekej oyajkej totoka okinnamiktiajkej, otlakotontiajkej ik pueblojtin iwan oajsitoj ompa achtoj ke yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nijkuak Jesús otemok de itech barko, okinmitak sa tekitl miekej tlakaj ompa yokichixtokaj, okinmiknomaj porke oyekaj kej ichkamej katlej mach kipiaj tlajpixke. Iwan okinmachtij de miek tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sa tiotlakke imomachtijkawan omijkuanijkej inawak Jesús iwan okilwijkej: ―Nian mach itlaj onkaj iwan yotiotlakik. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xikintitlani in tlakaj ma wian ik rancherías iwan ik pueblojtin katlej katej serka, para ma kikowatij tlan kikuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesús okinmilwij: ―Namejwan xikintlamakakan. Yejwan okilwijkej: ―Mach kajxilis tikkowaskej ome siento denarios de pan para tikinmajmakaskej nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yej okinmilwij: ―¿Keski pan ankipiaj? Xikitakan. Nijkuak okitakej, okilwijkej: ―Tikpiaj makuile pan iwan ome michimej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ijkuakón Jesús okinnawatij ma motlalikan in tlakaj por grupojtin, kan xiwyoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Omotlalijkej grupojtin de sejsen siento iwan de tlatlajko siento. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús okitilanke in makuile pan iwan ome michimej, oajkopantlachixke iwan omotlasojkamatke inawak Dios. Okipojpostekke in pan iwan okinmakak imomachtijkawan para ma kinxejxelilikan in tlakaj. Noijki Jesús okinkojkotonke in ome michimej iwan nochtin okinxejxelilijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nochtin kuale otlakuajkej asta oixwikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Satepan, imomachtijkawan okololojkej majtlaktle iwan ome chikimej tentokej de pantlapojpostektle iwan de michtlakojkotonale. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Iwan katlej otlakuajkej oyekaj kej makuile mil tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Satepan, Jesús okintitlanke imomachtijkawan itech se barko, ma tlayekanakan asta itech oksé lado de yen lago, ma ajsitij itech pueblo de Betsaida. Yej ok okinmakawaya in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Iwan nijkuak oyajkej nochtin, Jesús oyáj ik ajko ipan tiliwik iwan ompa omotiotzajtzilij. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nijkuak otleyuak, in barko oyeka itlajko in lago, iwan Jesús oyeka iselti itempan atl. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yej okinmitak imomachtijkawan yosotlawakej porke in ejekatl okinmixnamiktiwalaya iwan barko mach ok owelia oyaya totoka. Kej las tres de kualkan, Jesús oyáj nejnentiw ixko atl iwan ya kinpanawiskia. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nijkuak imomachtijkawan okitakej, okijtojkej xamo se temawtij, omomawtijkej iwan otzajtzikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Porke nochtin okitakej iwan omomawtijkej. San niman Yej, okinnotzke iwan okinmilwij: ―Amo ximomawtikan, Nej niJesús. Ximoyolojchikawakan. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Otlejkok itech barko, iwan omoketzke in ejekatl, iwan yejwan sa otlajtlachixkej (omomajmawtijkej). ");
INSERT INTO nhyNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ayamo okimomakayaj kuenta de yen milagro katlej Jesús okichij de yen pan iwan de yen michimej, iwan oyekaj ok yoltlakuawakej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Okiatrabesarojkej in lago iwan oajsitoj se lugar itoka Genesaret. Ompa inakastlan lago okilpijkej in barko. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Nijkuak Jesús otemok de itech barko, in tlakaj san niman okixmatkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ijkuakón nochtin tlakaj de yon lugar omotlatlalojkej okitematiltijkej nik in Jesús oejkok itech yon lugar. Nochtin tlakaj de yon región okualinwikakej nochtin kokoxkej asta kan oyeka in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iwan san kan Yej oyaya, itech weyikantin, rancherías, pueblojtin, tlalkawaltin o noso ipan ojtle, ompa okintlaliliayaj in kokoxkej, iwan okitlatlawtiayaj ma kinkawili maski san ma kikitzkilikan itzotzol para ma pajtikan. Iwan nochtin katlej okikitzkilijkej itzotzol opajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","In fariseos iwan sekimej tlamachtijkej de itlanawatil in Moisés owalajkej de weyikan de Jerusalén iwan omololojkej inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Miekpa okinmitayaj imomachtijkawan otlakuayaj iwan mach omomajtekiayaj. Pero in fariseos omomajtekiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(In fariseos iwan oksekimej judiojtin omomajtekiayaj miekpa nijkuak otlakuayaj porke ijkón okinmititijkej inweyitajwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iwan nijkuak owalmokuepayaj de tiankisko, tla amo momajtekiskej miekpa mach tlakuaskej, iwan okipiayaj oksekimej kostumbres okachi: okinpajpakayaj basojtin, jarrojtin iwan oksekimej trastestin de tepostin, iwan asta kamajtin.) ");
INSERT INTO nhyNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","In fariseos iwan tlamachtijkej de itlanawatil in Moisés okitlajtlanijkej in Jesús: ―¿Tlanik momomachtijkawan mach kineltokaj tlan otechmachtijkej in ya wejkawitl toweyitajwan? ¿Tlanik tlakuaj iwan mach momajtekiaj ken tejwan? ");
INSERT INTO nhyNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yej okinnankilij: ―Melawak ken okijtoj Isaías nik namejwan san anteixkajkayajkej. Nijkuak okijkuiloj ken Dios okilwij: Yinmej tlakaj nechtlakitaj san ika inten, pero inyolo kajki wejka de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mach itlaj ipatij intiotzajtzilis. Tlan yejwan tlamachtiaj yon mach witz de Dios, sino yon kisa san de itech yejwan intlayejyekolis. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Namejwan mach ankineltokaj tlan otechnawatij in Dios, iwan namejwan yej oksé tlamantle tlan ankichiwaj, yej anmotlapajpakiaj iwan ankineltokaj se tlanawatile de amejwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesús noijki okinmilwij: ―Namejwan ankikawaj se lado tlan Dios otechnawatij, iwan yej ankichiwaj de tlan namejwan anmotlayejyekol. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés okijtoj: “Xikintlakita mopapan iwan momaman.” Noijki okijtoj: “Akin biero kitenewilia ipapan o noso imaman, ma kimiktikan.” ");
INSERT INTO nhyNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero namejwan ankijtaj ke se tlakatl welis kilwis ipapan o noso imaman: “Mach welis nimitzpalewis ika tlan mitzpoloa porke ya Corbán.” (Corbán kijtosneki tlan nikpia yonikmaktilij in Dios.) ");
INSERT INTO nhyNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ijkón, namejwan mach ankitekawiliaj ma se kipalewi ipapan o noso imaman. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Namejwan ankikawaj se lado itlajtol in Dios iwan yej ankichiwaj tlan de amejwan anmokostumbre. Iwan noijki ankinchiwaj oksekimej tlamantin ken yinmej. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús okinnotzke nochtin tlakaj iwan okinmilwij: ―Xinechkakikan aminochtin iwan xikmomakakan kuenta tlan nikijta. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nochi tlan kalakis ijtik se tlakatl mach kiyolsokiotis. Tlan kisa de ipan iyolo in tlakatl yej yon kiyolsokiotia. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tla ankinekij ankimomakaskej kuenta, xikkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Satepan de okinkajtej in tlakaj se lado, Jesús okalakke itech se kale, imomachtijkawan opéj kitlajtlaniaj tlan kijtosneki de tlan okinmakak kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yej okinnankilij: ―¿Namejwan no mach ankimomakaj kuenta? ¡Xikkakikan! Tlan kalaki ijtik se tlakatl mach itlaj kitoktia. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porke mach kalaki ijtik iyolo, sino ijtik itlalax iwan satepan kisa kalan. Ijkón Jesús okinmilwij nik chipawak nochi tlan mokua. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Noijki okijtoj: ―In tlajtlakole katlej kisa de itech se tlakatl, yen yon kiyolsokiotia. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","De ijtik inyolo in tlakaj kisa katlej mach kuale tlalnamikilistle, momekatiaj katlej tlanamiktiltin iwan katlej mach tlanamiktiltin, temiktiaj, ");
INSERT INTO nhyNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tlachtekij, tominpitzomej, kitetoktiaj tlan amo kuale, tekajkayajkej, kiwelitaj mopaktiskej ika intlalnakayo, moxikoanimej, tepojpoaj, moweyinekij, iwan mach kimatij tlakakij. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochi yon mach kuale tlamanyotl kisa de ijtik inyolo in tlakaj iwan kinyolsokiotia. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús oyáj ik región de Tiro iwan ik región de Sidón. Okalakke itech se kale, iwan okinekia mokawani ompa para mach akaj ma kimati kanin kaj, pero mach owelik omotlaatij de nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Se tenan okipiaya ichpoch katlej okipiaya se ejekatl mach kuale. In tenan okimatke kan oyeka in Jesús, oyáj inawak iwan omotlankuaketzke ikxitlan. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yin tenan mach judía, yej oyeka griega, otlakatke Sirofenicia. Okitlatlawtij in Jesús ma kikixtili in ichpoch in ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Iwan Jesús okilwij: ―Achtoj ma nikinpalewi nojudiojikniwan. Tej mach tijudía. Tla tej nimitzpalewis, yon kej yeskia niktlamaka se chichij ika intlakual ikonewan Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","In tenan okinankilij: ―Aján, Señor. Pero nijkuak ikonewan Dios tlakuaj ipan mesa, tepewi sekin intlakualpayex, iwan chichimej kikuaj yon tlakualpayextle. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús okilwij: ―Kuale otitlanankilij, xiwia, in ejekatl mach kuale yokiske de itech mochpoch. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","In tenan oyáj para ichan iwan okitajsik ichpoch wetok ipan itlapech, iwan ejekatl mach kuale yokiske. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús okiske de región de Tiro iwan opanok ik región de Sidón. Satepan opanok itech tlalmej kan katej majtlaktle pueblojtin kan noijki kitokaxtiaj Decápolis, iwan oajsito kan lago de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ompa okiwikilijkej se tlakatl nontzin iwan mach otlakakia. Okitlatlawtijkej in Jesús ma kitlali ima ipan yon tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús okiwikak ik se lado iselti, okinkalakij imajpilwan ijtik inakaswan in yon tlakatl, ochijchak iwan okikitzkilij inenepil. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Satepan Jesús otlachixke ik ilwikak, oelsijsij iwan okilwij: ―¡Efata! ―kijtosneki: ¡Ximotlapokan! ");
INSERT INTO nhyNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","San niman ijkuakón yon tlakatl onakastlapowik, noijki onenepilkaxanke iwan opéj tlajtoa kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Satepan, Jesús okinnawatij in tlakaj mach itlaj ma kijtokan de tlan okichij, pero yejwan okachi okixoyawayaj in tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Nochtin sa otlajtlachixkej (omomajmawtijkej) de tlan otlamochij, iwan okijtoayaj: ―Yin Jesús kuale kinchiwa nochtin yinmej tlamantin. Katlej mach tlakakij kintlakakitia iwan katlej mach tlajtoaj kintlajtoltia. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Se tonale omololojkej miekej tlakaj iwan mach okipiayaj tlan kikuaskej, Jesús okinnotzke imomachtijkawan iwan okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Nikinmiknomati in yinmej tlakaj ya kipiaj eyi tonale nowan iwan mach kipiaj tlan kikuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tla amo nikintlamakas iwan nikinmilwis ma wian inchan, welis kuatleyuiliskej ipan ojtle, porke sekimej de yejwan owalajkej de wejka. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Imomachtijkawan okilwijkej: ―Nian mach akaj chanti, ¿kan tikkuitiwej pan para tikintlamakaskej? ");
INSERT INTO nhyNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús okinmilwij: ―¿Keski pan ankipiaj? Yejwan okijtojkej: ―Chikome pan. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ijkuakón okinmilwij in tlakaj ma motlalikan. Okitilanke in chikome pan iwan omotlasojkamatke inawak Dios, okipojpostekke in pan iwan okinmakak imomachtijkawan para ma kinxejxelilikan in tlakaj iwan yejwan ijkón okichijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Noijki okinpiayaj sekimej michintzitzintin. Jesús noijki omotlasojkamatke inawak Dios iwan okinmilwij imomachtijkawan ma kinxejxelilikan in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nochtin kuale otlakuajkej asta oixwikej. Iwan satepan okololojkej tlan osobraroj iwan asta otenke chikome chikiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Otlakuajkej kej nawi mil tlakaj. Iwan satepan Jesús okinmakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Satepan Jesús otlejkok itech se barko iwan imomachtijkawan iwan oyajkej. Iwan oajsitoj se lugar itoka Dalmanuta. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","In fariseos oejkokej inawak Jesús iwan opéj Iwan motlatlajtolkuepaj. Okitlajtlanilijkej ma kichiwa se milagro kej se señas para kitaskej nik melawak kichiwa ika ipoder in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús oelsijsij iwan okinmilwij: ―Namejwan ankinekij annechtlajtlakolmayawiskej, annechtlajtlaniliaj se weyi milagro. Ipan melajka namechilwia ke namejwan mach ankitaskej nion se milagro de ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ompa okinkajtej iwan oksemi otlejkok itech barko iwan opanok oksé lado de yen lago de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Imomachtijkawan in Jesús mach okitkikej pan itech barko, porke okelkajkej iwan okitkikej san se pan. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús okinmilwij: ―Ximotlachilikan de itech inlevadura in fariseos iwan de itech ilevadura in Herodes. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Imomachtijkawan opéj kimolwiaj se iwan oksé: ―Ijkón techilwia porke otikelkajkej in pan. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús okimatia tlan okiyejyekoayaj iwan okinmilwij: ―¿Tlanik ankimolwiaj ke ankelkajkej in pan? Wel ankuatlakuawakej, mach ankimomakaj kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ankipiaj anmixtololowan pero mach antlachiaj. Ankipiaj anmonakaswan pero mach antlakakij. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Xikelnamikikan nijkuak onikinpojpostekke in makuile pan iwan onikinmajmakak makuile mil tlakaj para ma tlakuakan. ¿Keski chikiwitl otenke de pan katlej osobraroj? Yejwan otlanankilijkej: ―Majtlaktle iwan ome chikiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Iwan nijkuak onikinpojpostekke in chikome pan para nawi mil tlakaj, ¿keski chikiwitl otenke de yen pedasos katlej osobraroj? Yejwan okilwijkej: ―Chikome chikiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ijkuakón okinmilwij: ―¿Mach ya ankimomakaj kuenta? ¿Ankiyejyekoaj Nej nitlanemilia por amo ankualkuikej in pan? ");
INSERT INTO nhyNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Satepan owalajkej itech pueblo de Betsaida, iwan okualwikilijkej se tlakatl katlej mach tlachia, okitlatlawtijkej in Jesús ma kintlali imawan ipan yon tlakatl para ma pajti. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesús okimatilanke iwan okixtij de itech yon pueblo. Satepan okitlalilij ichijchi itech ixtololowan, okintlalij imawan ipan iwan okitlajtlanij kox ya weli itlaj kita. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ijkuakón opéj tlachia iwan okilwij: ―Nikinmita in tlakaj kej kuanmej iwan nikinmita nejnemij. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesús oksemi okintlalij imawan ipan ixtololowan yon tlakatl iwan okinawatij kuale ma tlachia. Iwan ijkuakón yon tlakatl opajtik iwan opéj kuale tlachia. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ijkuakón Jesús okititlanke ma wia para ichan, iwan okilwij: ―Amo xikalaki itech pueblo iwan amo akaj itlaj xikilwi. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Satepan Jesús iwan imomachtijkawan oyajkej itech se región kan oyekaj sekimej pueblojtin. Yonmej pueblojtin okinnawatiaya se weyikan itoka Cesarea de Filipo. Nijkuak onejnentokaj okintlajtlanij: ―¿Ken kijtaj in tlakaj? ¿Akin Nej? ");
INSERT INTO nhyNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yejwan okilwijkej: ―Sekimej kijtaj tejwatzin tiJuan Tlakuateekij, sekimej kijtaj tejwatzin tiElías o noso akaj oksé profeta. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Yej okinmilwij: ―Iwan namejwan, ¿ken ankijtaj? ¿Akin Nej? Pedro okilwij: ―Tejwatzin tiCristo. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús okinmilwij amakaj itlaj ma kilwikan de Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús opéj kinmachtia nik in Yej akin omochij tlakatl tlajyowis de miek tlamantle. In tlayekankej tetajtzitzintin, in tlayekankej tiopixkej iwan in tlamachtijkej de itlanawatil in Moisés mach kiresibiroskej. Yejwan kimiktiskej pero ipan eyi tonale moyolkuis (moyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesús okinmilwij ipan melajka nochi tlan panos, iwan mach itlaj okintlaatilij. Pero ijkuakón Pedro okiwikak in Jesús ik se lado, iwan opéj kajwa por ijkón okijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús omokuepke para okonimitak imomachtijkawan, iwan ijkuakón okajwak in Pedro iwan okilwij: ―¡Xitzinkisa, Satanás! Porke tej mach mitztekipachoa tlan Dios kineki, sino mitztekipachoa tlan kinekij in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesús okinnotzke in tlakaj iwan imomachtijkawan iwan okinmilwij: ―Tla akaj kineki witz nonawak, ma wiki kiné, pero moneki ayakmo ma kichiwa san tlan yej kinekis. Sino kipia de kixikos nochi san tlan panos, maski ma kimiktikan itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tla akaj kineki kipalewis inemilis, kipolos, pero tla akaj kipoloa inemilis por Nej iwan por yen itlajtol in toTajtzin Dios, kipalewis inemilis. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mach itlaj ipatij tla se tlakatl kimoaxkatis nochi in tlaltikpak iwan satepan kipolos ianima. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mach weli mokowa se anima. ");
INSERT INTO nhyNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Akin pinawa de Nej iwan de notlajtol inmixpan yinmej tlaltikpaktlakaj momekatijkej iwan tlajtlakolejkej, Nej katlej onimochij nitlakatl noijki nipinawas de yej nijkuak niwitz ika imawisotlanex in noPapan iwan noijki niwitz inwan angelestin yolchipawakej. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús okinmilwij: ―Ipan melajka namechilwia, sekimej katlej nian katej, mach kixmatiskej in mikilistle asta amo ma kitakan kenik in Dios tlanawatis ika miek ipoder. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Chikuasen tonale satepan, Jesús oyáj ipan tepetl okinwikak in Pedro, Jacobo iwan Juan. Iwan ompa inmixpan omopatlak itzotzol in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Itzotzol opetlanke sa tekitl istak, iwan mach akaj tlakatl de nian tlaltikpak welis ijkón kikawas, maski sa tekitl ma kipaka mach ijkón nik istayas. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iwan ijkuakón omonextijkej in Moisés iwan Elías omotlapowijtokaj iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro okilwij in Jesús: ―Tlamachtij, sa kuale nian tikatej mowan. Ma tikinchiwakan eyi akawalkaltin, se para tejwatzin, se para Moisés iwan se para Elías. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedro mach okimatke tlan okijtoj, porke yejwan omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ijkuakón se mixtle okinkenke iwan se tlajtole omokakke okijtoj: ―Yin yen notlasojKone, xikkakilikan itlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nijkuak omotlachilijtewakej nian nepa, mach ok akaj okitakej sino sa yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nijkuak owaltemoayaj de ipan tepetl, Jesús okinmilwij imomachtijkawan mach itlaj ma kijtokan de tlan okitakej, asta ijkuak in Yej akin omochij tlakatl ma moyolkui oksemi satepan de mikis. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Okitlaatijkej kiné ipan inyolo iwan omotlajtlaniayaj tlan kijtosneki moyolkuis (moyolitis) oksemi satepan de mikis. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Okitlajtlanijkej in Jesús: ―¿Tlanik in tlamachtijkej de itlanawatil in Moisés kijtaj ke Elías yej kipia de witz achtoj antes de witz in Cristo? ");
INSERT INTO nhyNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús okinnankilij: ―Ipan melajka namechilwia, Elías achtoj witz iwan yej tlayektlalis nochi, kajki ijkuilitok nik in Nej katlej onimochij nitlakatl nimoyolkokos sa tekitl iwan nechkokoliskej in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero nikneki xikmatikan nik in Elías yowitza iwan tlakaj okitoktijkej san tlan yejwan okinekej, ijkón ken ijkuilitok de tlan panoani in yej. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nijkuak omokuepato in Jesús kan oyekaj imomachtijkawan, okinmitak miekej tlakaj okinyawalojtokaj, iwan sekimej tlamachtijkej de itlanawatil in Moisés omokuejsoayaj iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Nochtin sa otlajtlachixkej (omomajmawtijkej) nijkuak okitlatewakej in Jesús, iwan niman omotlalojkej inawak okitlajpalotoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesús okintlajtlanij: ―¿Tlanik wel anmotlajtolnanankiliaj inwan nomomachtijkawan? ");
INSERT INTO nhyNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Se tlakatl katlej ompa oyeka okijtoj: ―Tlamachtij, nian nimitzwalwikilia notelpoch, kipia se ejekatl mach kuale iwan onontik. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","San kan yawi, in ejekatl mach kuale kikitzkia iwan kitlalwiteki, kamaposoni, motlanteteyitza iwan sojsosoka. Onikintlatlawtij momomachtijkawan ma kikixtilikan in ejekatl mach kuale iwan mach owelikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús okinmilwij: ―¡Namejwan wel mach antlaneltokakej! ¿Asta keman nietos amowan? ¿Asta keman ijkón nanmechxikojtos? Xinechwalwikilikan in telpochtle. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ijkuakón okiwikakej in telpochtle inawak Jesús, iwan nijkuak in ejekatl mach kuale okitak in Jesús, niman okitoktij in telpochtle ma motlalwiteki chikawak iwan omijtikueptinenke iwan okamaposonke. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús okitlajtlanij in tetaj de yon telpochtle: ―¿Ya wejkawitl ijkón mochiwa? In tetaj okinankilij: ―Desde chokotzin. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Miekpa kitoktia ma wetzi ijtik tlitl iwan ijtik atl para ma miki. Tla tejwatzin tiwelini itlaj tikchiwani, xitechiknomati iwan xitechpalewi. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús okinankilij: ―Amo xikijto: “Tla tejwatzin tiwelini itlaj tikchiwani.” Tla tej tikneltoka, tonses Dios welis mitzpalewis itech nochi tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","San niman in tetaj otzajtzik chikawak okijtoj: ―¡Señor, nikneltoka! ¡Xinechpalewi ma nitlaneltoka okachi ken moneki! ");
INSERT INTO nhyNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nijkuak Jesús okitak opéj mololoaj miekej tlakaj, okijtoj: ―¡Tej, ejekatl mach tikuale, tinakastzajtzaktok iwan tinontle! ¡Nimitznawatia xikisa de ijtik yin telpochtle iwan mach oksemi xikalaki ijtik! ");
INSERT INTO nhyNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","In ejekatl mach kuale okuawtzajtzik, okimimiktij iwan okikuekuepke in telpochtle iwan okiske de ijtik. In telpochtle omokaj kej mikkatl. Iwan miekej okijtojkej yomikke in telpochtle. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ijkuakón Jesús, okimakitzkij iwan okewaltij. Iwan telpochtle omoyekketzke. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nijkuak in Jesús okalakke itech se kale iwan imomachtijkawan, ompa yejwan inselti okitlajtlanijkej in Jesús: ―¿Tlanik in tejwan mach otiwelikej otikixtijkej in ejekatl mach kuale? ");
INSERT INTO nhyNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yej okinmilwij: ―Yinmej ejekamej mach kualtin, welis ankinkixtiskej tla anmotiotzajtziliskej iwan anmosawaskej (onayunaroskej). ");
INSERT INTO nhyNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesús iwan imomachtijkawan okiskej de ompa iwan opanokej ik estado de Galilea. Pero Jesús mach okinekke akaj ma kimati kanin kajki. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Porke okinekia kinmachtis imomachtijkawan. Okinmilwiaya: ―Nej katlej onimochij nitlakatl nechtemaktiskej (nechtemaktiliskej) inmak in tlakaj iwan nechmiktiskej, pero eyi tonale satepan de yonimikke nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yejwan mach okimomakakej kuenta de tlan okinmilwiaya, iwan okimakaskej de kitlajtlaniiskej tlan kijtosneki. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Oajsitoj itech pueblo de Capernaum, nijkuak in Jesús oyeka kalijtik, okintlajtlanij: ―¿Tlan nankimolwijtiwalayaj ipan ojtle? ");
INSERT INTO nhyNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yejwan mach otlanankilijkej, porke okimolwijtiwalayaj akin de yejwan okachi weyikistok (weyititok). ");
INSERT INTO nhyNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ijkuakón Jesús omotlalij iwan okinnotzke in majtlaktle iwan omen imomachtijkawan. Okinmilwij: ―Tla akaj kineki tlayekantos, kipia de motzikitzinilis, iwan yej yetos tekipanoj de nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesús okitlalij se chokotzin tlatlajko de kan yejwan oyekaj, omotlalij iwan okinapaloj iwan okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Akin kiresibiros se chokotzin ken yin, kijtosneki Nej nechresibiroa, iwan akin nechresibiroa, amo san Nej nechresibiroa, sino noijki akin onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan okilwij in Jesús: ―Tlamachtij, otiktakej se tlakatl kinkixtia ejekamej mach kualtin ika motoka, iwan otikilwijkej mach ijkón ma kichiwa, porke yej mach towan nemi. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesús okinmilwij: ―Xikkawilikan, porke akin kichiwa milagro ika notoka, mach welis tlajtos biero de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Akin amo kajki kontra tejwan, towan kajki. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ipan melajka namechilwia, akin anmechmakas se xikale de atl ika notoka, san akin, porke amejwan annoaxkawan, ipan melajka namechilwia nik kiresibiros itlaxtlawil. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’In chochokomej nechneltokaj, pero tla akaj kichiwa se de yin tzikitzin ma wetzi ipan tlajtlakole, okachi kuale ma kilpilikan ikechtlan se metlatl iwan ma kitlamotlakan ijtik atl. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tla moma mitztoktia xieto titlajtlakolej, xikmotzontekili. Okachi kuale xikalaki ilwikak timatepoj ke tias ika nochi ome momawan ijtik tliko, kan tlitl mach keman sewis, ");
INSERT INTO nhyNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","kan okuilimej mach mikij iwan in tlitl mach keman sewi. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tla mokxi mitztoktia xieto titlajtlakolej, xikmotzontekili. Okachi kuale xikalaki ilwikak tikoxo ke ma mitztlamotlakan ijtik tliko ika nochi ome mokxiwan, ");
INSERT INTO nhyNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","kan okuilimej mach mikij iwan in tlitl mach keman sewi. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iwan tla moixtololo mitztoktia xieto titlajtlakolej, xikmokixtili. Porke okachi kuale xikalaki kan Dios tlanawatia ika se moixtololo ke ika nochi ome moixtololowan ma mitztlamotlakan ijtik tliko, ");
INSERT INTO nhyNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","kan okuilimej mach mikij iwan in tlitl mach keman sewi. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Porke nochtin in tlakaj weliaskej ika tlitl, ken in tlakuale welia ika istatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","In istatl sa tekitl kuale, pero tla in istatl kipolos ipuyeka, ¿kenik oksemi puyeyas? Namejwan xipuyextokan iwan kuale ximoyekwikakan. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús okiske de pueblo de Capernaum iwan oyáj ik estado de Judea iwan oksé lado de yen weyatl Jordán, ompa omololojkej in tlakaj iwan Yej opéj kinmachtia ijkón ken nochipa okichiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sekimej fariseos omijkuanijkej para kitlajtlakolmayawiskej iwan okitlajtlanijkej: ―¿Kox kuale kaj tla se tlakatl kikawas isiwa? ");
INSERT INTO nhyNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús okinnankilij: ―¿Tlan kijta itlanawatil in Moisés? ");
INSERT INTO nhyNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yejwan otlanankilijkej: ―Moisés okitekawilij ma mosiwakawa in tlakatl, tla kitemaka se amatl kan ma kijto nik mokajkawa iwan isiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesús okinmilwij: ―Moisés okitemakak in tlanawatile de yen mosiwakawaj, porke mach ankinekij ankimomakaskej kuenta de itlaj tlan kuale. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero nijkuak Dios okichij in tlaltikpak, noijki okichij in tlakatl iwan siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Por yonik in tlakatl kikajtewas ipapan iwan imaman para mosetilis iwan isiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Iwan de omen yetos sa se tlakatl. Iwan ijkón mach ok yetoskej omen sino sa se. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por yonik, mach akaj ma kinxeelo katlej Dios yokinsetilij. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nijkuak yokatkaj kalijtik imomachtijkawan okitlajtlanijkej oksemi de yen yon tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús okinmilwij: ―Akin kikawa isiwa iwan monamiktia iwan oksé siwatl, kijtosneki ya kimomekatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tla se siwatl kikawa iokich iwan monamiktia iwan oksé tlakatl, kijtosneki noijki ya kimomekatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesús okinwikilijkej sekimej pilalaktin para inpan ma kintlali imawan. Imomachtijkawan opéj kinmajwaj katlej okinwikayaj in pilalaktin. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús okinmitak, okualanke iwan okinmilwij imomachtijkawan: ―Xikinkawakan in pilalaktin ma wikikan nonawak, amo xikintzatzakuilikan. Porke in tlakaj katlej yolyamankej ken pilalaktin, kalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ipan melajka namechilwia, tla se tlakatl amo kikawilis in Dios ma tlanawati ipan iyolo ken se chokotzin kimokawilia, yon tlakatl mach kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jesús okinnapaloj in pilalaktin, satepan okintlalij imawan inpan yonmej pilalaktin iwan okintiochij. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús oksemi ya oonewaya para kiseguiroani iojwi, ijkuakón se tlakatl omotlaloj inawak, omotlankuaketzke iwan okilwij: ―Tlamachtij, Tej wel tikuale tlakatl. ¿Tlan welis nikchiwas para nikpias nemilistle katlej mach keman tlamis? ");
INSERT INTO nhyNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús okilwij: ―¿Tlanik tinechilwia nikuale tlakatl? Mach onkaj oksé kuale tlakatl, sanwel yen Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ya tikmati tlan kijtaj in tlanawatiltin: “Amo xitemikti, amo ximomekati, amo xitlachteki, amakaj xiktlajtoltlatlalili, amo xitlakajkayawa, iwan xikintlakita mopapan iwan momaman.” ");
INSERT INTO nhyNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","In tlakatl otlanankilij: ―Tlamachtij, nochi in yon nikchijtiwitz desde nitzikitzin. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús okitlatak ika tlasojtlalistle iwan okilwij: ―Oksé mitzpoloa tikchiwas. Xiwia iwan xiknamaka nochi tlan tikpia, iwan tomin xikinmaka in pobrestin. Ijkón tikpias rikojyotl ompa ilwikak. Iwan nompa, xiwiki nonawak iwan pewa xinemi nowan. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nijkuak ijkón okikakke in tlakatl oyáj omoyolkokojtiaj porke sa tekitl okimopialiaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesús otlachixke ik nian nepa iwan okinmilwij imomachtijkawan: ―In tlakaj katlej kimopialiaj sa tekitl owij para kalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Imomachtijkawan sa otlajtlachixkej (omomajmawtijkej) de tlan okijtoj pero Jesús okinmilwij oksemi: ―Nokonewan, sa tekitl owij para katlej kimopialiaj kalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Okachi mach owij para se kameyo panos kan kuyontok in akuxaj, ke para se katlej kimopialia kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yejwan sa otlajtlachixkej (omomajmawtijkej) iwan okimolwiayaj entre yejwan: ―Tla ijkón, ¿akin kiné welis momakixtis? ");
INSERT INTO nhyNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús okintlatak iwan okijtoj: ―In tlakaj mach weli kichiwaj, pero Dios nochi weli kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pedro opéj kilwia in Jesús: ―Tejwan otikajkej nochi tlan otikpiayaj para tiaskej mowan. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús okijtoj: ―Ipan melajka namechilwia, nochtin akinmej okikajkej inkal, ikniwan, inpapan, inmaman, insiwa, inpilwan o noso intlal por Nej iwan por yen kuale tlajtole katlej temakixtia, ");
INSERT INTO nhyNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kajsiskej axan itech yin tiempo sien buelta okachi de inkalwan, ikniwan, inmaman, inkonewan iwan intlalwan maski kintlatlalochtiskej. Pero itech nekáj tiempo katlej witz satepan kipiaskej in nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero miekej katlej axan weyikistokej (weyititokej), satepan mach ok weyikistoskej. Iwan miekej katlej axan mach weyikistokej, satepan weyikistoskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Oyayaj para weyikan de Jerusalén, iwan Jesús otlayekanaya. Imomachtijkawan sa otlajtlachiayaj (omomajmawtiayaj) iwan oyayaj tlakuitlapan ika nemajmawtile. Ijkuakón Jesús okinnotzke in majtlaktle iwan omen imomachtijkawan, iwan opéj kinmilwia tlan mochiwas in Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesús okinmilwij: ―Xikkakikan. Ma tiwian para weyikan de Jerusalén kan Nej katlej onimochij nitlakatl nechtemaktiskej (nechtemaktiliskej) inmak in tlayekankej tiopixkej iwan inmak in tlamachtijkej de itech tlanawatile de Moisés. Yejwan nechtlajtlakoltiskej para ma nechmiktikan, iwan nechtemaktiskej inmak in tlakaj katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nechpijpinatiskej, nechwitekiskej, nechchijchijchaskej iwan nechmiktiskej, pero eyi tonale satepan nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo iwan Juan, ipilwan Zebedeo, omijkuanijkej inawak Jesús iwan okilwijkej: ―Tlamachtij, tiknekij xitechchiwili tlan timitztlajtlaniliskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yej okinmilwij: ―¿Tlan ankinekij? ");
INSERT INTO nhyNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yejwan okilwijkej: ―Xitechkawili ma timotlalikan ik monakastlan, se ik moyekma iwan se ik moopochma itech momawisotlanex. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús okinnankilij: ―Namejwan mach ankimatij tlan ankitlajtlanij. ¿Kox welis namejwan ankixikoskej anpanoskej ken tlan Nej nipanos? ¿Kox welis anmokuateekiskej ika tekokojkayotl katlej Nej ika nimokuateekis? ");
INSERT INTO nhyNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yejwan okijtojkej: ―Tiweliskej. Jesús okinmilwij: ―Ipan melajka namechilwia, satepan namejwan anpanoskej ken Nej nipanos, anmokuateekiskej ika tekokojkayotl katlej Nej ika nimokuateekis. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tla anmotlaliskej ik noyekma o noso ik noopochma, mach Nej nikijtos. Dios kintlalis ompa akinmej yokinpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nijkuak in oksekimej majtlaktin okikakej, okualankej inawak Jacobo iwan inawak Juan. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús okinnotzke iwan okinmilwij: ―Namejwan ankimatij akinmej mochiwaj gobiernojtin de se país, tlanawatiaj ika miek tlanawatijkayotl. In tlakaj katlej okachi wejweyikistokej (wejweyititokej), yejwan okachi tlanawatiaj chikawak itech se pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero namejwan mach ijkón kipia de yetos, akin kineki weyikistos de yen namejwan, kipia por kinpalewis in oksekimej. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Akin kineki tlayekantos de yej namejwan, kipia por kintekichiwilis nochtin in oksekimej. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porke Nej katlej onimochij nitlakatl mach oniwalaj para ma nechpalewikan, sino oniwalaj para nitepalewis iwan para niktemakas nonemilis, iwan ijkón miekej nikinmakixtis de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Satepan Jesús iwan imomachtijkawan oajsitoj itech weyikan de Jericó. Iwan nijkuak Jesús iwan imomachtijkawan iwan miekej oksekimej tlakaj yoyayaj de ompa, ijkuakón Bartimeo ikone in Timeo, ik ompa oewatoka ipan ojtle omijtlanijtoka porke mach otlachiaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Iwan okikakke nik in Jesús de Nazaret ik ompa panoa, iwan ijkuakón okitzajtzilij: ―¡Jesús, iKone in David, xinechiknomati! ");
INSERT INTO nhyNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Miekej okilwijkej ma mokamatzakua pero yej okachi chikawak otzajtzik: ―¡IKone in David, xinechiknomati! ");
INSERT INTO nhyNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús omokuepke iwan okinmilwij: ―¡Xiknotzatij! Yejwan okinotzatoj iwan okilwijkej: ―¡Ximoketza iwan xipaki, Jesús mitznotza! ");
INSERT INTO nhyNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ijkuakón yej okitlamotlak ikoton, omoketewak iwan oyáj inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús okilwij: ―¿Tlan tikneki ma nimitztokti? Bartimeo okinankilij: ―Tlamachtij, nikneki nitlachias. ");
INSERT INTO nhyNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús okilwij: ―Ya welis timuikas. Yotipajtik porke otikneltokak nik welis nimitzpajtis. Iwan san niman ijkuakón ya owelik otlachixke kuale iwan opéj yawi iwan Jesús ipan iojwi. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Oajsikoj itech pueblo de Betfagé iwan itech pueblo de Betania iyakapan in Olivostepetl, mach ok wejka de yen weyikan de Jerusalén. Ijkuakón Jesús okintitlanke omen imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Okinmilwij: ―Xiwian itech pueblo katlej kajki tlayakapan, iwan san niman nijkuak anmajsitiwej ompa ankitaskej se burro ilpitok katlej mach ya semi akaj ipan tlejko. Xiktotomakan iwan xinechwalwikilikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tla akaj anmechilwis: “¿Tlanik ankitotomaj?”, xikilwikan nik in Señor kineki iwan san niman mitzkawiliki. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Oyajkej, iwan okajsitajsikej in burro ilpitok kaltempan itempan ojtle iwan okitotonkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iwan sekimej katlej ompa oyekaj okinmilwijkej: ―¿Tlanik ankitotomaj yon burro? ");
INSERT INTO nhyNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Imomachtijkawan in Jesús okijtojkej ijkón ken Yej okinmilwij, iwan okinkawilijkej ma kiwikakan. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tonses okiwikakej yon burro kan oyeka in Jesús, iwan okinkentilijkej intlakenwan ipan burro, iwan Jesús ipan otlejkok. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Miekej tlakaj okinsojsojkej intlakenwan ipan ojtle, iwan oksekimej okisojsojkej ixiwyo in kuanmej. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Nochtin katlej otlayekanayaj iwan katlej oyayaj tlakuitlapan otzajtziaj chikawak: ―¡Hosana! ¡Ma Dios kitiochiwa katlej okiwaltitlanke para tlanawatis! ");
INSERT INTO nhyNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ma Dios kitiochiwa katlej ya tlanawatis ken otlanawatij in toweyitaj David! ¡Hosana! ¡Ma weyikisto in toTajtzin Dios katlej kajki ilwikak! ");
INSERT INTO nhyNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús okalakke itech weyikan de Jerusalén iwan okalakke ijtik in weyi tiopan iwan otlachixke ik nowian (nian nepa). Satepan oyáj inwan majtlaktle iwan omen para Betania porke yotiotlakijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ipan oksé tonale, nijkuak owalkiskej de Betania, Jesús otiojsij. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Okitak de wejka se igoskuawitl okipiaya ixiwyo. Omijkuanij inakastlan kuawitl para kitas kox kipia igos, pero mach itlaj okipiaya porke mach ya oyeka itiempo, sino okipiaya san puro ixiwyo. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ijkuakón Jesús okilwij in igoskuawitl: ―Mach ok keman ok akaj ma kikua motlakilo. Iwan imomachtijkawan okikakej. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Satepan oksemi oejkokej itech weyikan de Jerusalén. Jesús okalakke ijtik in weyi tiopan iwan opéj kinkixtia in tlakaj. Okinkixtij in tlanamakakej iwan tlakojkej. Okintlatlamochilij inmesajwan in tominpatlakej iwan okintlatlamochilij insiyajwan in palomasnamakakej. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mach okitekawilij akaj ma kitki itlaj tlanamaktle ijtik in weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Okinmachtij okinmilwij: ―Kajki ijkuilitok: “Nokal kinotzaskej kale de tiotzajtzilistle para nochi in tlaltikpak.” Pero namejwan ya ankikuepkej se kale de ichtekej. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","In tlamachtijkej de itlanawatil in Moisés iwan tlayekankej tiopixkej okikakej iwan opéj kitemoaj kenik kimiktiskej. Pero mach oweliaj itlaj okichiwayaj porke okinmiimakasiaj in tlakaj de inpan ma wikikan, porke nochtin sa otlajtlachiayaj (omomajmawtiayaj) iwan okiwelitayaj tlan Jesús okinmachtiaya. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Sa tiotlakke Jesús iwan imomachtijkawan okiskej de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","San kualkan opanokej kan oyeka in igoskuawitl iwan okitakej ya owakke ik nochi inelwayo. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro okualelnamikke iwan okilwij in Jesús: ―¡Tlamachtij, xikita! ¡Yowakke in igoskuawitl katlej otikajwak! ");
INSERT INTO nhyNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús okijtoj: ―Xikpiakan tlaneltokalistle inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ipan melajka namechilwia tla akaj kilwis yin tepetl: “Ximijkuani iwan ximotlamotla ijtik atl.” Iwan tla amo kiyejyekojtos kox mijkuanis o noso amo mijkuanis, sino kineltokas ika nochi iyolo nik mijkuanis, tonses ipan melajka in tepetl mijkuanis. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por yonik namechilwia, nijkuak ankitlajtlaniliskej toTajtzin Dios ma amechmaka itlaj tlamantle, moneki xikneltokakan nik melawak amechmakas, iwan ijkón welis ankipiaskej tlan ankitlajtlanij. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iwan nijkuak anmotiotzajtziliskej, tla amo kuale ankatej iwan akaj, xiktlapojpolwikan para ijkón noijki namoPapan Dios katlej kajki ilwikak ma amechtlapojpolwi de amotlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Tla namejwan amo antetlapojpolwiaj, Dios noijki mach amechtlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Oksemi oyajkej itech weyikan de Jerusalén. Mientras onemia ompa kan weyi tiopan, in tlayekankej tiopixkej, in tlamachtijkej de itlanawatil in Moisés iwan tlayekankej tetajtzitzintin judiojtin, omijkuanijkej inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Okitlajtlanijkej: ―¿Ika tlan tlanawatijkayotl otikinkixtij in tlanamakakej de ijtik in weyi tiopan? ¿Akin omitzmakak in yon tlanawatijkayotl? ");
INSERT INTO nhyNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús okinnankilij: ―Nej noijki namechtlajtlanis se tlajtole, xinechnankilikan iwan namechilwis ika tlan tlanawatijkayotl nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","In tlakuateekilistle de Juan Tlakuateekij, ¿yon se tlanawatile de tlakaj o noso de Dios? Xinechnankilikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yejwan omotlajtlanijkej, iwan okimolwijkej: ―Tla tikilwiskej de toTajtzin Dios, techilwis: “¿Tlanik mach ankineltokakej?” ");
INSERT INTO nhyNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero, mach welis tikilwiskej nik yon tlanawatile de tlakaj. Yejwan okinmiimakaskej in tlakaj iwan okiyejyekojkej amo san kichiwa nochtin inpan mokuepaskej, porke nochtin okineltokayaj nik in Juan melawak oyeka se profeta de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yejwan okinankilijkej in Jesús: ―Mach tikmatij. Tonses in Jesús noijki okinmilwij: ―Nej noijki mach namechilwis akin onechmakak yin tlanawatijkayotl para ijkón ma nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús opéj kintlapowia ika ejemplos, okinmilwij: ―Se tlakatl okitookak uvas itlalaj. Okitlatzakuij iwan okichij se tanke kan kipatzkas uvas. Noijki okichij se torre wejkapan para kimonekuitlawis itlatok. Satepan okinkajtewilij sekimej tekipanojkej ma kimonekuitlawikan iwan omokajkej kimokawiskej tlaatlajko de tlan tlakis, iwan oyáj wejka itech oksé país. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Nijkuak ya kuale para kitekiskej in uvas, iteko in uvasyoj okititlanke se itekipanoj innawak in yonmej tekipanojkej, para ma kikuiti tlan kitokaroa. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","In tekipanojkej okikitzkijkej iwan okimagakej iwan okikuepkej san ijki. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Tonses iteko yon uvasyoj okititlanke oksé itekipanoj, iwan tekipanojkej okikuatlajtlapankej ika tetl, iwan okilwijkej san tlan amo. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Iteko yon uvasyoj okititlanke oksé itekipanoj, iwan tekipanojkej okimiktijkej. Iwan miekej oksekimej okintitlanke, sekimej okinmagakej iwan oksekimej okinmiktijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Omokaj sa yen itelpoch, san yej se itlasojkone, okititlanke iwan okimolwij: “Komo notelpoch, kitlakitaskej.” ");
INSERT INTO nhyNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","In tekipanojkej okimolwijkej: “Yin itelpoch kimokawis nochi nijkuak in tetaj mikis, ma tikmiktikan iwan tejwan tikmokawiskej nochi.” ");
INSERT INTO nhyNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Okikitzkijkej iwan okimiktijkej ompa itlalaj iwan okikixtijkej okitlamotlatoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ijkuakón Jesús okintlajtlanij: ―¿Tlan kichiwas iteko de yon uvasyoj? Witz iwan kinmiktis in tekipanojkej mach kualtin. Satepan in uvasyoj kinmaktilis oksekimej tekipanojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Amo ankileroaj itlajtol in toTajtzin Dios tlanon kijta? Sekan ijkin kijta: In tetl katlej in kalchijkej mach okixitakej, omokuepke yen tetl katlej okachi kichikajtok in kale. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yin tetl owalaj de yen toSeñor iwan tikitaj sa tekitl kuakualtzin. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ijkuakón okinekiaj kitzakuanij in Jesús, porke okimomakakej kuenta nik okinmixnamikke ika yon ejemplo. Iwan komo ompa oyekaj miekej tlakaj, mach ok itlaj okijtojkej, mejor oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","In fariseos iwan sekimej itekipanojkawan in Herodes oyajkej kan Jesús oyeka. Okitemoliayaj kanaj se tlajtole tlan ika kualtis kitilwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Omijkuanijkej inawak Jesús iwan okilwijkej: ―Tlamachtij, tikmatokej nik in tejwatzin tikijta tlan melawak, mach timotekawilia ma mitzkajkayawakan in tlakaj, mach tikita akin tejwan kox tirikojtin o noso tipobrestin. Tej titlamachtia ipan melajka kenik se nemis ken Dios kimonekiltia. ¿Kox kuale se kitlaxtlawas impuestos para César o noso amo? ¿Tiktlaxtlawaskej o noso amo tiktlaxtlawaskej? ");
INSERT INTO nhyNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Jesús yokimatia nik san teixkajkayajkej, iwan okinmilwij: ―¿Tlanik ankinekij annechmayawiskej ika itlaj tlajtole? Xinechwalkuilikan se tomin ma nikita. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Nijkuak okimakakej se tomin, ijkuakón okintlajtlanij: ―¿De akin ixko yin iwan de akin itoka katlej nian ijkuilitok? Iwan yejwan okilwijkej: ―De César. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ijkuakón Jesús okinmilwij: ―Xikmakakan in César tlan de yen César, iwan xikmakakan Dios tlan de yen Dios. Iwan yejwan sa otlajtlachixkej (omomajmawtijkej) de kenik okinnankilij. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satepan owalajkej sekimej saduceos katlej kijtaj mach melawak moyolkuiskej (moyolitiskej) in mikkamej. Por yonik okitlajtlanijkej in Jesús, okijtojkej: ");
INSERT INTO nhyNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tlamachtij, Moisés otechkajtewilij ijkuilitok, tla se tlakatl omonamiktij, miki iwan mach okinpixke ikonewan iwan isiwa, in ikni in difunto kipia de monamiktis iwan viuda para kinpialis ikonewan ipatka in difunto. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Semi oyekaj, chikomen iknimej. In tetiachka achtoj omonamiktij pero omikke iwan mach okinpixke ikonewan. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tonses katlej kiwaltoka omonamiktij iwan viuda, pero yej noijki omikke iwan mach okinpixke ikonewan. No ijkón opanok in oksé katlej kiwaltoka. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Iwan nochtin in chikomen iknimej ijkón opanokej, iwan nion se mach okipixke ikone. Satepan noijki omikke in siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nijkuak nochtin moyolkuiskej (moyolitiskej), iwan ya yolitoskej, ¿katlij yej de yejwan yetos isiwa? Porke san ken nochtin iknimej omonamiktijkej iwan yon siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús okinnankilij: ―Namejwan mach ompa tlan ankijtaj, porke mach ankimomakaj kuenta de yen tiotlajkuilole iwan nion de yen ipoder in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Porke nijkuak in mikkamej moyolkuiskej (moyolitiskej), in tlakaj iwan siwamej mach monamiktiskej, yejwan yeskej ken angelestin ken katlej katej ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Komo ya timotlapowijtokej de yen mikkamej moyolkuiskej, ¿amo ankileroaj in libro de Moisés, kan tlapoa de se kuatlanwitztle katlej otlatlaya? Dios okilwij in Moisés: “Nej niDios de Abraham, de Isaac iwan de Jacob katlej yolitokej nowan.” ");
INSERT INTO nhyNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡In Dios, mach Dios de mikkamej, sino de katlej yolitokej! Melawak nik mach ompa tlan ankijtaj namejwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Se tlamachtij itech tlanawatile de Moisés omijkuanij, okinkakke omotlatlajtolkuepayaj iwan okikakke nik Jesús kuale otlanankilij. Ijkuakón okitlajtlanij in Jesús: ―¿Katlij yen tlanawatile okachi importante de nochtin? ");
INSERT INTO nhyNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús okinankilij: ―In tlanawatile katlej okachi importante yen yin: “Xikkaki, Israel, in Señor toTeko, yen toDios, san Yej se Señor onkaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Xiktlasojtla in Señor moDios ika nochi moyolo, ika nochi moanima, ika nochi motlalnamikilis iwan ika nochi mochikawalis.” ");
INSERT INTO nhyNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Oksé tlanawatile katlej ikniyo yen yin: “Xiktlasojtla in mokni ken tej timotlasojtla.” Mach katej oksekimej tlanawatiltin okachi ken yinmej omen. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iwan tlamachtij itech tlanawatile de Moisés okilwij: ―Kuale kajki, Tlamachtij. Melawak tlan tikijta. Onkaj san se Dios, iwan mach onkaj oksé ken Yej. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iwan moneki tiktlasojtlaskej in Dios ika nochi toyolo, ika nochi totlalnamikilis iwan ika nochi tochikawalis. Iwan moneki tikintlasojtlaskej oksekimej ken tejwan timotlasojtlaj, yon okachi kuale iwan amo ken nochtin in yolkamej katlej tikinmiktiaj iwan tikinchichinoaj ipan artal katlej tikinmakaj kej se tlamanale in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús komo okitak in tlamachtij itech tlanawatile de Moisés otlanankilij ika kuale itzontekon, okilwij: ―Mach tikaj wejka para tikalakis kan Dios tlanawatia. Iwan mach ok akaj omixewij okitlajtlanij ok itlaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús oksemi otlamachtijtoka ompa ijtik weyi tiopan iwan okijtoj: ―¿Tlanik in tlamachtijkej de itlanawatil in Moisés kijtaj ke in Cristo yen ikone in David? ");
INSERT INTO nhyNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porke in Espíritu Santo okitlajtoltij in David iwan inewian in David okijtoj: In toTajtzin Dios okilwij in noSeñor yin tlajtole: “Ximotlali ik noyekma, asta ijkuak Nej nimitztlalis titlayekanke de yejwan katlej mitzkokoliaj.” ");
INSERT INTO nhyNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Ankineltokaj namejwan nik in David kilwiani ikone noSeñor? Ompa oyekaj sa tekitl miekej tlakaj iwan okikakiaj in Jesús ika pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús itech itlamachtil okijtoaya: ―Xikpiakan kuidado de yen tlamachtijkej de itlanawatil in Moisés, kiwelitaj nemiskej ika kuajkuale intlaken weweyak, iwan kinekij ma kinyektlajpalokan nijkuak nemij itech tiankistle. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yejwan noijki kiwelitaj motlaliskej itech tiopanmej asta tlayakapan kan okachi kuale lugar, iwan itech se ilwitl noijki kitemoaj katlej okachi kuale lugar kan tlakuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iwan kinnekatoktiaj in viudajtin ma kitemakakan asta tlan amo kipiaj, iwan tlaixkajkayawaj motiotzajtziliaj sa tekitl. Yonmej kitlaxtlawaskej okachi weyi tlajtlakole. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús oewatoka iyakapan kaja kan konkajkawaj in tomin para in weyi tiopan. Jesús okonimitoka in tlakaj kenik okonkajkawayaj in tomin ijtik in kaja. Miekej katlej okimopialiayaj okonkajkawayaj okachi miek tomin. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ijkuakón oejkok se viuda pobre, okoninkajkaj ome tominmej de cobre katlej mach okachi itlaj ipatij. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ijkuakón Jesús okinnotzke imomachtijkawan iwan okinmilwij: ―Ipan melajka namechilwia, nik in yin viuda pobre, okonkajkaj okachi miek ke nochtin oksekimej katlej okonkajkajkej intomin ijtik kaja. ");
INSERT INTO nhyNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porke nochtin okonkajkajkej katlej kinsobraroa porke kipiaj tomin, pero yin viuda pobre okonkajkaj nochi tlan okipiaya tlan ika motlamakani. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nijkuak Jesús okiske de ijtik in weyi tiopan, se de yen imomachtijkaw okijtoj: ―¡Tlamachtij! Xikinmita in yinmej kuajkualtin temej iwan kuajkualtin kalmej. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús okilwij: ―¿Tikinmita nochtin yinmej kuajkualtin kalmej? Satepan nochtin xitiniskej, mach ok mokawas nion oksé tetl pepechitos ipan oksé tetl. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Satepan Jesús iwan imomachtijkawan oyajkej ipan Olivostepetl, katlej kajki iyakapan weyi tiopan. Iwan nijkuak Jesús ompa yoewatoka, ijkuakón Pedro, Jacobo, Juan iwan Andrés okitlajtlanijkej in Jesús san ichtaka: ");
INSERT INTO nhyNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xitechilwi, ¿kemanian tlapanos iwan katlij yen tikchiaskej kej señas iwan kemanian tlapanos de yen tlan tikijta? ");
INSERT INTO nhyNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Iwan Jesús opéj kinmilwia: ―Xikpiakan kuidado, amakaj ma amechkajkayawa. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Miekej witzej ika notoka kijtoskej: “Nej niCristo.” Iwan miekej kinkajkayawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Nijkuak namejwan ankikakiskej nik onkaj guerra o noso motlapowiskej yetos guerra, amo ximomawtikan ijkón kipia de tlapanos pero mach ya tlamis in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porke se país momagas iwan oksé país, iwan se pueblo momagas iwan oksé pueblo. Tlalolinis chikawak miek lado iwan yetos apistle. Yon yakin se ik pewas de itech tekokojkayotl ken se siwatl nijkuak yoajsik ora para kitlakatilis ikone. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Namejwan ximotlachilikan porke anmechtemaktiskej (omechtemaktiliskej) inmak tekiwajkej iwan anmechwitekiskej itech tiopanmej. Anmechwikaskej inmak gobernadortin iwan inmak reytin por yen notlajtol, iwan ompa inmixpan namejwan welis antetlapowiskej de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero achtoj moneki ma motematilti notlajtol katlej temakixtia itech nochi in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amo ximotekipachokan por tlan ankijtoskej nijkuak amechtemaktiskej inmak tekiwajkej, ijkuakón xitlajtokan, porke mach amejwan antlajtoskej, sino yen Espíritu Santo katlej tlajtos. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","In teikni kitemaktis ikni ma kimiktikan, in tetaj kitemaktis ikone ma kimiktikan, in tepilwan inpan mokuepaskej in tetajmej iwan kintemaktiskej para ma kinmiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nochtin amechkokoliskej por Nej, pero akin kixikos nochi tlan panos, Dios kimakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Nijkuak ankitaskej itlaj bierotik moketos itech weyi tiopan, kan mach kipia de ompa yetos, ijkuakón katlej yeskej Judea, ma cholokan asta ipan tepemej. (Akin kineki kimomakas kuenta, ma kilero itlajkuilol in Daniel.) ");
INSERT INTO nhyNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iwan akin yetos ipan ikal amo ma temo ma kixtiti itlaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Iwan akin yetos itlalaj amo ma mokuepa ichan para ma kikuiti itzotzol. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Pobrestin in siwamej katlej itech yonmej tonaltin kipiaskej inkone intlalaxko iwan katlej yeskej selikkonewajkej! ");
INSERT INTO nhyNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xiktlatlawtikan Dios de mach ma tlapano nijkuak sewa. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porke itech yonmej tonaltin yetos weyi tekokojkayotl, ken mach semi ijkón tlamochiwa desde ijkuak opéj in tlaltikpak katlej Dios okichij, iwan nion mach oksemi ijkón tlamochiwas satepan. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Iwan tla in Señor amo kitzikitziniliani in yonmej tonaltin mach akaj mopalewiani. Pero yokitzikitzinilij por yejwan katlej kintlasojtla katlej Yej yokinpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ijkuakón tla akaj amechilwis: “Xikitakan nian kajki in Cristo”, o noso “Xikitakan nepa kajki”, amo xikneltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Monextiskej Cristojtin iwan profetajtin tekajkayajkej, iwan kinchiwaskej señalestin iwan milagrostin para ika tlakajkayawaskej, iwan kinekiskej kinkajkayawaskej noijki katlej Dios yokinpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Ximotlachilikan! Nej yonamechilwij antes de tlamochiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Satepan de itech nekatej tonaltin, nijkuak nochi yotlapanok de yen weyi tekokojkayotl, in tonale tlanexosewis, in metztle sewis, mach ok metztonas. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","In sitlaltin wetziskej de ilwikak iwan chikawalistin katlej katej ilwikak papatlakaskej (bibiokaskej). ");
INSERT INTO nhyNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ijkuakón in tlakaj nechitaskej Nej katlej onimochij nitlakatl niwitz ijtik mixtle ika miek nopoder iwan ika weyi nomawisotlanex. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iwan ijkuakón nikinwalintitlanis noangelwan iwan kinmololoskej in tlakaj katlej Nej yonikinpejpenke de ik nian nepa itech nochi in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Xikmomakakan kuenta in ejemplo de yen igoskuawitl: Nijkuak pewa moselialtia imamayo iwan pewa moxiwyotia, namejwan ya ankimatij nik ya pewas in tiempo de tlaxiwyoas. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","No ijkón nijkuak ankitaskej ya pewas tlapanos itech in yonmej nemajmawtiltin, ijkuakón noijki xikmatikan nik in Nej katlej onimochij nitlakatl ya niwalkistiwitz itech puerta. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ipan melajka namechilwia, nochi yin tlapanos antes de mikiskej in tlakaj de yin tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","In ilwikak iwan yin tlaltikpak mach ok yetoskej, pojpoliwiskej, pero notlajtol mach pojpoliwis, sino kipia de mochiwas. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Mach akaj kimati tlan tonale iwan tlan ora nijkuak niwalmokuepas, nion yejwan angelestin de ilwikak mach kimatij, nion Nej niiKone in Dios no mach nikmati, san yen noPapan Dios kimati. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Por yonik, xiijsatokan, xitlachixtokan iwan ximotiotzajtzilijtokan, porke mach ankimatij kemanian ajsiki in yon tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Yon kej yeskia se tlakatl oyáj de viaje, okinkajtewilij itekipanojkawan ma kimonekuitlawikan in kale, kada se okikajtewilij itekiw, iwan se okinawatij ma tlachixto. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ijkón kiné, namejwan xitlachixtokan porke mach ankimatij kemanian ejkoki iteko in kale, kox tiotlakke, o noso tlajkoyuak, o noso ijkuak waltzajtzis in kaxtil, o noso ijkuak walanesis. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Amo san kichiwa onkisaki iwan anmechajsiki ankochtokej. ");
INSERT INTO nhyNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Tlan namechilwia namejwan, noijki nikinmilwia nochtin: Xitlachixtokan. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sa ome tonale opoliwia para ilwitl de pascua nijkuak mokua in pan katlej mach kipia levadura. In saduceos iwan tlamachtijkej de itlanawatil in Moisés, okitemoliayaj in Jesús kenik welis kikitzkiskej ika tlakajkayawalistle iwan ijkón kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero okimolwiayaj: ―Mach tikitzkiskej itech ilwitl para amo kualaniskej in tlakaj iwan yomoniskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús oyeka itech pueblo de Betania ichan Simón katlej okipiaya se kokolistle, katlej opalania inakayo. Jesús ijkuakón oewatoka itech mesa, oejkok se siwatl kiwalkui se boteyajtzin de alabastro tentok de ajwiakayotl de nardo katlej kuale iwan patíoj, okitlapanke in boteyajtzin iwan okiteekilij in ajwiakayotl ipan itzontekon in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sekimej katlej ompa oyekaj okualankej iwan okimolwiayaj: ―¿Tlanik san okawiltij in ajwiakayotl? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Welini monamakani patíoj ken tlan kitlani se tlakatl katlej tlapalewia de se xiwitl, iwan se kinmakaskia in tomin katlej pobrestin. Iwan okajwakej chikawak in yon siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús okijtoj: ―Xikkawakan, ¿tlanik ankajwaj? Yej kuale tlan onechtoktij. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","In pobrestin nochipa ankinpiaskej iwan welis ankinpalewiskej san keman ankinekiskej, pero Nej mach nochipa annechpiaskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yin siwatl okichij tlan owelik. Yonechajwialij para ijkuak nimotookas. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ipan melajka namechilwia ke nian nepa ixko yin tlaltikpak, kan motematiltis in tlajtole katlej temakixtia, noijki motematiltis tlan okichij in yin siwatl iwan ijkón se kelnamikis. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, se de yen majtlaktle iwan omen, oyáj okinmitato in tlayekankej tiopixkej para kinmaktilis in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","San niman nijkuak okikakej, opakej iwan okilwijkej kimakaskej tomin in Judas. Ijkón yej okitemoaya keman okachi kuale para kinmaktilis in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nijkuak opéj ilwitl de pascua yakin se tonale, nijkuak mokua in pan katlej mach kipia levadura, nijkuak noijki okimiktiayaj in ichkatzin de pascua, in momachtijkej okitlajtlanijkej in Jesús: ―¿Kan tikneki ma tikyektlalitij in tiotlakantlakuale de pascua? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ijkuakón okintitlanke omen imomachtijkawan okinmilwij: ―Xiwian itech pueblo, ompa ankajsitiwej se tlakatl katlej kitki iatekon. Xiwian iwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Iwan kan ajsiti ompa xiktlajtlanikan iteko in kale: “In Tlamachtij tlajtlani: ¿Katlij yen kuarto kan nikuas in tiotlakantlakuale de pascua inwan nomomachtijkawan?” ");
INSERT INTO nhyNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Yej amechititis se kuarto weyi katlej kajki ajkopan iwan ya tlayektlalitok. Ompa xikchiwakan in tiotlakantlakuale de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","In momachtijkej okiskej iwan oyajkej itech pueblo. Okajsitajsikej nochi ken Jesús okinmilwij iwan okichijkej in tiotlakantlakuale de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nijkuak owaltlatleyuak, Jesús iwan majtlaktle iwan omen imomachtijkawan oejkokej kalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nijkuak otlakuajtokaj ipan mesa, Jesús okinmilwij: ―Ipan melajka namechilwia, nik se de amejwan katlej nian nowan tlakuajtok, nechtemaktis (nechtemaktilis). ");
INSERT INTO nhyNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yejwan omoyolkokojkej iwan opéj kitlajtlaniaj se por se: ―¿Kox nej? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús okinmilwij: ―Se de yen namejwan anmajtlaktin iwan amomen, katlej kajakia ipan ijtik in plato kan Nej noijki nikajakia. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nej katlej onimochij nitlakatl nipanos ijkón ken kijta in tiotlajkuilole, pero ¡pobre akin nechtemaktis (nechtemaktilis)! Mejor amo tlakatini. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nijkuak otlakuajtokaj, in Jesús okitilanke in pan iwan omotlasojkamatke inawak Dios. Okipojpostekke in pan iwan okinmajmakak imomachtijkawan, iwan Jesús okijtoj: ―Xikkuakan, yin yen notlalnakayo. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ijkuakón okitilanke in kopa iwan omotlasojkamatke inawak Dios, satepan okinpanoltilij imomachtijkawan iwan nochtin okonikej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Okinmilwij: ―Yin yen noeso, katlej yankuik akuerdo inawak Dios, katlej toyawis para miekej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ipan melajka namechilwia, ke mach ok nikonis iayo uvas asta itech nekáj tonale nijkuak nikonis iayo uvas yankuik katlej onkaj kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Satepan de okitlakuikakej se tiotlakuikale, oyajkej ipan Olivostepetl. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ijkuakón Jesús okinmilwij: ―Namejwan aminochtin annechkajtewaskej noselti, porke kajki ijkuilitok kijta: “Nikmiktis in tlajpixke iwan ichkamej xixiniskej.” ");
INSERT INTO nhyNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Satepan de ijkuak nimoyolkuis (nimoyolitis), namechyekanas ik estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro okijtoj: ―Maski nochtin ma mitzkajtewakan, nej mach nimitzkawas. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesús okilwij: ―Ipan melajka, yin yuak antes de tzajtzis in kaxtil ome buelta, tej ijkuakón yotikijtoj ya eyi buelta nik mach tinechixmati. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedro okachi omochijchikawaya: ―Maski mowan ma nechmiktikan, nej mach keman nimitzkawas. Iwan nochtin ijkón okijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Satepan oyajkej ik tlatokkuawyoj kan kilwiaj Getsemaní, iwan Jesús okinmilwij imomachtijkawan: ―Ximotlalikan nian mientras Nej niawi nimotiotzajtziliti. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Okinwikak in Pedro, Jacobo iwan Juan, iwan opéj moyolkokoa iwan opéj mosentiroa sa tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Okinmilwij: ―Nikmachilia itech noanima ya niixpoliwi de neyolkokole. Nian ximokawakan iwan xiijsatokan. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Oyáj achitzin ik tlayakapan, ompa omotlankuaketzke asta okitennamikke in tlale. Iwan okimotlatlawtilij in Dios, tla kualtini, amo ma kawili ma pano tekokojkayotl itech nekáj ora. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Itech itiotzajtzilis okijtoj: ―Abba, Papan, tejwatzin nochi tiweli tikchiwa, xinechkixtili yin tekokojkayotl, pero amo ma mochiwa ken Nej nikneki, sino ken tejwatzin tikmonekiltia. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Satepan omokuepke kan oyekaj eyin imomachtijkawan iwan okinmajsito kochtokej, iwan okilwij in Pedro: ―Simón, ¿tikochi? ¿Amo otikxikoj tiijsatok nion se ora? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xiijsatokan iwan ximotiotzajtzilijtokan, para amo ma amechmayawi in tlajtlakole, namoespíritu kineki kichiwas tlan kuale, pero namotlalnakayo mach tlaxikoa. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesús oyáj oksemi omotiotzajtzilito iwan oksemi okijtoj tlan achtoj yokijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nijkuak omokuepato, oksemi okinmitajsik kochtokej porke inpan omopachoj in kochilistle. Iwan mach ok okimatiaj tlan kijtoskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Nijkuak omokuepato ya eyi buelta, okinmilwij: ―¿Ankiseguiroaj anmosewiaj iwan ankochij? ¡Xiijsakan! Yoajsik ora, porke Nej katlej onimochij nitlakatl ya nechtemaktiskej (nechtemaktiliskej) inmak in tlakaj tlajtlakolejkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Ximewakan ma tiwian! Xikitakan, ya ompa witz katlej nechtemaktis. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ok otlapojtoka iwan ijkuakón oejkok in Judas, se de yen majtlaktle iwan omen imomachtijkawan, kualinwika miekej tlakaj kiwalkuij espada iwan kiwalkuij kuawitl. In yonmej tlakaj okualintitlankej in tlayekankej tiopixkej, in tlamachtijkej de itlanawatil in Moisés iwan tlayekankej tetajtzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Iwan Judas antes de kitemaktis (kitemaktilis) in Jesús, ijkín okinmilwij in tlakaj: ―Akin nej nikixpipitzos yen yon Jesús, xikitzkikan kuale iwan xikwikakan. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Niman nijkuak oejkok in Judas, omijkuanij inawak Jesús iwan okilwij: ―¡Tlamachtij! Iwan ijkuakón okixpipitzoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","San niman ijkuakón omijkuanijkej in tlakaj iwan okitzkijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero se imomachtijkaw in Jesús okikixtij iespada iwan okinakastzontekke itekipanoj in weyi tiopixke. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iwan Jesús okinmilwij: ―¿Tlanik anwalajkej annechkitzkikoj ika espada iwan ika kuawitl? Mach niichtekke. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nochipa onieka amowan itech in weyi tiopan onitlamachtijtoka iwan mach keman annechkitzkijkej. Pero ijkín nipanoa para ma mochiwa tlan kijta in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nochtin imomachtijkawan ochocholojkej iwan okikajtejkej iselti in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Se telpochtle ompa oyaya otlakentitiaya san ika se sábana katlej kuale, pero nijkuak okitzkijkej, ");
INSERT INTO nhyNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","omoxolkopinke iwan ocholoj sa xitlatztik. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Okiwikakej in Jesús imak in weyi tiopixke, iwan omololojkej in tlayekankej tiopixkej, in tlayekankej tetajtzitzintin iwan tlamachtijkej de itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedro oyaya san wejka iwan omokaj kan patio de yen ichan in weyi tiopixke, iwan ompa omotlalij omototonijtoka itech tlikuile inwan sekimej tlamonekuitlawijkej de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","In tlayekankej tiopixkej iwan nochtin katlej tlatlanawatijkej tlaixkomakakej (tlatzonmankej), okistlakawiayaj ika san tlan amo, tlan ika welis kimayawiskej in Jesús iwan ijkón kualtis kimiktiskej, pero mach itlaj okajxiliayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Miekej okijtojkej tlan amo melawak (tlen amo ijkón). Sekimej okijtoayaj se tlamantle iwan oksekimej okijtoayaj oksé tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sekimej tlakaj mach kualtin omoketzkej iwan okistlakawijkej in Jesús okijtojkej: ");
INSERT INTO nhyNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Tejwan otikkakej okijtoj: “Nikxitinis yin weyi tiopan katlej okichijkej in tlakaj, iwan san ika eyi tonale nikkewaltis oksé katlej mach akaj tlakatl kichiwas.” ");
INSERT INTO nhyNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Maski ijkón okijtoayaj mach oajsiaj san se tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ijkuakón omoketzke tlatlajko in weyi tiopixke iwan okitlajtlanij in Jesús: ―¿Amitlaj tikijtos de tlan yinmej mitzistlakawiaj? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesús mach otlanankilij. Iwan in weyi tiopixke oksemi okitlajtlanij: ―¿Yen tej tiCristo titeKone de Dios katlej tikweyitenewaj? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús okinankilij in weyi tiopixke: ―Aján, yen Nej, iwan namejwan annechitaskej Nej katlej onimochij nitlakatl niewatos ik iyekma in Dios katlej kipia weyi ipoder, iwan namejwan annechitaskej niwitz de ilwikak ijtik mixtle. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iwan in weyi tiopixke omotlakentzayanke iwan okijtoj: ―¿Tlan para moneki okachi ankistlakawiskej? ");
INSERT INTO nhyNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","¡Namejwan ya ankikakej nik otlajtoj kej yeskia yen Dios! ¿Tlan ankijtaj? Nochtin okijtojkej nik tlajtlakolej iwan moneki ma kimiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sekimej opéj kichijchijchaj, okixilpiayaj iwan okimaitemayaj, iwan okilwiayaj: ―¡Tla xitlajto (xikadibinaro), akin omitzmaak! Iwan mayoltin noijki okixtlajtlatziniayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro oyeka tlatlampa kan patio, iwan ik ompa opanok se siwatl itlapalewij in weyi tiopixke. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nijkuak okitak in pedro mototonijtok, omoketzke iwan okitlatak, iwan okijtoj: ―Tej noijki otinemia iwan Jesús de pueblo de Nazaret. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedro mach okimokuitij iwan okijtoj: ―Mach nikixmati iwan nion mach nikmati tlan tikijta. Iwan okiske ik kalan iwan ijkuakón otzajtzik in kaxtil. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","In tlapalewijkasiwatl, oksemi okitak in Pedro iwan opéj kinmilwia katlej ompa oyekaj: ―Yin se de yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro oksemi mach okimokuitij. Ok achitzin satepan, katlej ompa oyekaj oksemi okilwijkej in Pedro: ―Ipan melajka, tej se de yejwan, porke in tej noijki de estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ijkuakón Pedro opéj tlawikaltia iwan okijtoj nik in Dios tlachixtok nik melawak tlan kijta. Okijtoj: ―Mach nikixmati yon tlakatl katlej namejwan ankitenewaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ijkuakón in kaxtil otzajtzik oksemi. Pedro ijkuakón okelnamikke tlan achtoj okilwijka in Jesús: “Antes de tzajtzis in kaxtil ome buelta, tej ijkuakón yotikijtoj ya eyi buelta nik mach tinechixmati.” Iwan ochokak sa tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","San kualkan, omololojkej katlej tlayekantokej tiopixkej, in tlayekankej tetajtzitzintin, in tlamachtijkej de itlanawatil in Moisés iwan nochtin de yen junta, okiwikakej in Jesús ilpitiw okimaktilitoj in Pilato. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","In Pilato okitlajtlanij: ―¿Yen tej tiRey de judiojtin? Jesús okilwij: ―Ijkón ken tej yotikijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iwan katlej tlayekantokej tiopixkej okistlakawiayaj de miek tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato oksemi okitlajtlanij: ―¿Mach itlaj tikijtos de nochi tlan mitzistlakawiaj? ");
INSERT INTO nhyNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesús mach itlaj okijtoj. In Pilato sa otlajtlachixke (omomajmawtij) por amo otlanankilij in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Nochi xiwitl itech ilwitl, Pilato okikajkawaya se de yen katlej tzaktokej san katlij yej okitlajtlaniliayaj ma kikajkawa. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Se tlakatl itoka Barrabás otzaktoka inwan itemiktijikniwan, yonmej otemiktijkej itech se pleito inawak gobierno. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iwan miekej tlakaj omololojkej inawak Pilato iwan okilwijkej ma kichiwa ken nochi xiwitl kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato okinnankilij: ―¿Ankinekij ma nikajkawa yen Rey de judiojtin? ");
INSERT INTO nhyNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato okimatia nik in tlayekankej tiopixkej okitemaktijkej (okitemaktilijkej) in Jesús porke itech omoxikoayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero in tlayekankej tiopixkej okintlatlalwijkej in tlakaj para ma kilwikan in Pilato okachi kuale ma kikajkawa yen Barrabás. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilato okintlajtlanij oksemi: ―¿Tlan ankinekij ma nikchiwa iwan yin tlakatl katlej ankilwiaj Rey de judiojtin? ");
INSERT INTO nhyNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yejwan otlanankilijkej chikawak: ―¡Xikmajmasolti itech krus, ma miki! ");
INSERT INTO nhyNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilato okinmilwij: ―¿Tlanik? ¿Tlan okichij? Pero yejwan okachi okuawtzajtziaj: ―¡Xikmajmasolti itech krus, ma miki! ");
INSERT INTO nhyNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pero in Pilato okinekke mokawas kuale inwan tlakaj iwan okikajkaj in Barrabás. Iwan otlanawatij ma kiwitekikan in Jesús iwan satepan okitemaktij (okitemaktilij) para ma kimajmasoltikan itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","In soldadojtin okiwikakej in Jesús kan patio de yen palacio iwan okinmololojkej nochtin in soldadojtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Okonakiltijkej se kapa chichiltikatlilmiktik iwan okitlalilijkej se korona de witztle itech itzontekon. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iwan opéj tzajtzij: ―¡Viva in Rey de judiojtin! ");
INSERT INTO nhyNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iwan okikuawijwitekiaj ika tlakotl, okichijchijchayaj, iwan omotlankuaketzayaj omochiwayaj kej yeskia kiyektlajpaloaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Satepan de otlanke okipinawijkej, okixtilijkej ikapa chichiltikatlilmiktik iwan okonakiltijkej itzotzol, iwan satepan okiwikakej para kimajmasoltiskej itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ik ompa opanotiaya se tlakatl de país de Cirene itoka Simón katlej tetaj de yen Alejandro iwan de yen Rufo, witz de itlalaj. Iwan nijkuak Simón opanotoka ik ompa, okitoktijkej ma kimamali ikrus in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Okiwikakej in Jesús itech se lugar katlej kitokayotiaj Gólgota (kijtosneki mikkatzontekomatl). ");
INSERT INTO nhyNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iwan okimakakej vino nelitok iwan mirra pero mach okinekke okonik. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nijkuak in Jesús okimajmasoltijkej itech krus, in soldadojtin omotlaankej para kitaskej akin de yejwan kimokawis itzotzol in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oyeka kej las nuebe de kualkan nijkuak okimajmasoltijkej itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iwan ik ikuapak okitlalilijkej se letrero ijkuilitok por tlanik okimajmasoltijkej itech krus, kijtojtok: “Rey de yen judiojtin.” ");
INSERT INTO nhyNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Noijki okinmajmasoltijkej itech krus omen ichtekej ik inajnakastlan in Jesús, se ik iyekma iwan oksé ik iopochma. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Otlapanok ijkón ken kijta in tiotlajkuilole: “Okitakej kej yeskia tlajtlakolej.” ");
INSERT INTO nhyNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Katlej opanoayaj ik ompa okoliniayaj intzontekon iwan otlajtoayaj biero de yen Jesús iwan okilwiayaj: ―Tej otiknekia tiktlamotlani in weyi tiopan iwan otikijtoj tikchiwani san ika eyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Axan ximomakixti tej monewian iwan xitemo de itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","In tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés, noijki okipinawiayaj in Jesús, okimolwiayaj: ―Okinpalewij oksekimej pero yej inewian mach weli mopalewia. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ma tikitakan ma temo de itech krus in Cristo, Rey de yen judiojtin, iwan tikneltokaskej. In ichtekej katlej okinmajmasoltijkej itech krus noijki otlajtoayaj biero de yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Desde tlajko tonale iwan asta las tres de tiotlakke sa tekitl otlatleyuak ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iwan kej las tres, Jesús otzajtzik chikawak okijtoj: ―Eloi, Eloi, ¿lama sabactani? ―kijtosneki: Dios mío, Dios mío, ¿tlanik otinechkaj noselti? ");
INSERT INTO nhyNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iwan sekimej katlej ompa oyekaj okikakej iwan okijtojkej: ―¡Xikkakikan! Kinotza in profeta Elías. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Se de yejwan omotlaloj iwan okisiawato se tzotzole ika iayo in uvas katlej xokok. Okilpij iyak se kuawitl weyak iwan okimakak ma koni iwan okijtoj: ―Xikkawakan, tikitaskej kox in profeta Elías witz kitemowiki de itech in krus. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesús otenak chikawak iwan omikke. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","In kortina de yen weyi tiopan otlajkotzayanke desde tlakpak asta tlakxitlan. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","In kapitan de yen soldadojtin, okonitoka in Jesús nijkuak otenak iwan nijkuak omikke, iwan okijtoj: ―Ipan melajka, yin tlakatl oyeka iKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Sekimej siwamej oyekaj ompa okonitokaj de wejka, ompa oyeka in María de pueblo de Magdala, María imaman in José iwan de Jacobo xokoyotl, iwan oksé in siwatl itoka Salomé. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","In yonmej siwamej okiwikatinemiaj in Jesús iwan okipalewiayaj nijkuak oyeka itech estado de Galilea. Noijki ompa oyekaj miekej oksekimej siwamej katlej owalajkej iwan Jesús itech weyikan de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ijkuakón yon tiotlakke omotlayektlalilijtokaj para walmostlatis mosewiskej porke ya yetos weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Se tlakatl itoka José de pueblo de Arimatea, oyeka kuale tlakatl iwan oyeka tewan tlanawatij de itech injunta in judiojtin. José noijki okichiaya keman pewas tlanawatis in Dios. Omixchikaj oyáj inawak Pilato okitlajtlanilito itlalnakayo in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato sa otlajtlachixke (omomajmawtij) nijkuak okikakke nik in Jesús yomikke. San niman okinotzke in kapitan de yen soldadojtin iwan okitlajtlanij kox yomikke in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nijkuak in kapitan okilwij nik yomikke, in Pilato okawilij in José ma kiwika in mikkatl. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","José okikoj se kuale sábana de lino, okitemowij in tlalnakatl de itech krus, okikimiloj iwan okitookak ijtik se weyi mikkakuyoktle katlej okikuyonijkej ikxitlan se tepejxitl, iwan ika se weyi tetl patlaktik iwan tankachtik ika okikamatzakke. ");
INSERT INTO nhyNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","In María de pueblo de Magdala iwan María imaman José okitakej kan okitookakej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nijkuak opanok in weyi tonale, in María de pueblo de Magdala, in María imaman Jacobo iwan Salomé, okikojkej ajwiakayotl para kitlaliliskej itlalnakayo in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","In yakinika tonale de yen samana, san kualkan yakin okisako tonale, oyajkej kan okitookakej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Oyayaj motlapowijtiwej entre yejwan: ―¿Akin techijkuanilis in tetl de itech mikkakuyoktle? ");
INSERT INTO nhyNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero nijkuak oajsitoj, okitakej in weyi tetl katlej ika okamatzaktoka in mikkakuyoktle, mach ok okatka ken okikajtejkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Iwan nijkuak okalakej ijtik in mikkakuyoktle okitakej ik inyekma ewatok se telpochtle ika itzotzol weyak iwan istak. Iwan siwamej omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero yej okinmilwij: ―Amo ximomawtikan, namejwan ankitemoaj in Jesús de pueblo de Nazaret katlej okimajmasoltijkej itech krus, ¡Yej yomoyolkuik! ¡Mach ok nian kajki! Xikitakan kan ankitlalijkaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Axan xiwian iwan xikinmilwikan imomachtijkawan iwan Pedro, nik in Jesús Yej tlayekanas yas para Galilea iwan namejwan ompa ankitajsiskej ijkón ken Yej achtoj yoamechilwij. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ijkuakón in siwamej okikistewakej de ijtik in mikkakuyoktle, porke omomawtijkej iwan asta opapatlakatokaj (obibiokatokaj), iwan mach akaj itlaj okilwijkej porke omomawtiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nijkuak Jesús omoyolkuik, yon domingo kualkan, achtoj okimotitij in María de pueblo de Magdala katlej okinkixtilij chikome ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yej oyáj iwan okinmatiltij imomachtijkawan Jesús katlej omoyolkokojtokaj iwan ochokatokaj. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Iwan nijkuak okinmilwij nik in yej okitak in Jesús yolitok, yejwan mach okineltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jesús omoixpatlak iwan satepan okinmotitij omen imomachtijkawan katlej oyayaj ik tlalkawale. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yejwan noijki okinmatiltijkej in oksekimej momachtijkej iwan noijki mach okinneltokilijkej. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Okachi satepan okinmotitij san ken majtlaktle iwan se imomachtijkawan, nijkuak yejwan oewatokaj otlakuajtokaj. Jesús okinmajwak porke mach tlaneltokakej iwan por yoltlakuawakej, porke mach okinneltokilijkej katlej okinmilwijkej nik okitakej in Jesús yolitok. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iwan okinmilwij: ―Xiwian itech nochi in tlaltikpak iwan xikintlapowikan nochtin de yen kuale notlajtol katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Akin kineltokas iwan mokuateekis, mopalewis. Iwan akin amo kineltokas, Dios mach kitlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iwan akinmej kineltokaskej welis kinchiwaskej miekej señalestin ken yinmej: Ika notoka kinkixtiskej demoniojtin iwan tlajtoskej ika oksekimej yankuikej tlajtoltin. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kinkitzkiskej koamej, iwan tla koniskej itlaj katlej pajyoj, mach itlaj mochiwaskej, kintlaliskej inmawan inpan kokoxkej iwan pajtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nijkuak otlanke okintlapowij, in Señor Jesús omotlejkawijtiaj (otlejkok) ik ilwikak, iwan omotlalij ik iyekma in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Imomachtijkawan okiskej otetlapowitoj ik nowian (nian nepa) de yen tlajtole katlej temakixtia. In Señor Jesús okinpalewiaya iwan okinmititiaya nik melawak nochi tlan kijta itlajtol in toTajtzin Dios, iwan yejwan okinchiwayaj wejweyin milagrostin ika ipoder in toTajtzin Dios. Ijkón ma yeto.");
INSERT INTO nhyNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Nokni Teófilo, miekej tlakaj yokijkuilojkej nochi tlan otlapanok de tlan Jesucristo okichij de tlan tejwan kuale tikmatij. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","In Señor imomachtijkawan okitakej ika inmixtololowan tlan otlapanok desde ijkuak opéj nemij iwan toSeñor Jesús, iwan noijki otetlapowijkej de itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nej noijki kuale onimomachtij ika kuidado nochi yin tlamantle tlan otlapanok, iwan noijki tlan otlapanok desde ijkuak ayamo owalaya in toSeñor Jesucristo ixko yin tlaltikpak. Por yonik, tejwatzin Teófilo, nikita kuale nimitztlajkuililis de yin tlan otlapanok iwan nochi yolik nimitzmakatias kuenta, ");
INSERT INTO nhyNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","para okachi xikyekmati tlan melawak de tlan yomitzmachtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nijkuak Herodes oyeka rey de Judea, itech yon tiempo oyeka se tiopixke itoka Zacarías, katlej oyeka tewan de se grupo de tiopixkej de Abías. Isiwa in Zacarías oyeka itoka Elisabet, katlej noijki walajtok nelwatl de Aarón. Yon Aarón yen katlej yakinika oyáj tiopixke. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías iwan isiwa Elisabet oyekaj yolchipawakej inawak Dios, iwan okichiwayaj nochi tlan kijta itlanawatil in Señor, asta mach okipiayaj de tlanon ika se kinmistlakawis. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero mach okipiayaj inkone, porke Elisabet mach owelia okinpiaya, iwan san ken omen yoyekaj tetajtzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Se tonale, nijkuak Zacarías otekipanojtoka kej tiopixke ijtik in weyi tiopan, nijkuak okitokaroj in grupo de Abías de tekipanos, ");
INSERT INTO nhyNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","iwan komo okipiayaj kostumbre, motlanij para aber akin kitokaros kichichinos in kopale, ijkuakón yen Zacarías otlatlanke iwan yej okitokaroj kalakis tlapopochwis ijtik in weyi tiopan de toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mientras Zacarías otlapopochwijtoka tlijtik, nochtin in tlakaj omotiotzajtzilijtokaj kalan de yen weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ijkuakón se iángel in Señor okimonextilij in Zacarías. Yon ángel omoketoka ik yekmaitl de yen artal kan kichichinoaj in kopale. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías sa otlajtlachixke (omomajmawtij) iwan omomajmawtij nijkuak okitak in ángel. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero in ángel okilwij: ―Zacarías, amo ximomawti, porke Dios yokikakke motiotzajtzilis, iwan mosiwa Elisabet kipias se ikone, katlej tiktokayotis Juan. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Sa tekitl tikpias pakilistle, iwan noijki miekej pakiskej nijkuak yej tlakatis. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Porke yej weyikistos inawak Dios. Mach konis vino iwan nion mach konis itlaj oksé katlej teiwintij, iwan tentos de Espíritu Santo desde antes de tlakatis. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Yej kichiwas miekej tlakaj de Israel ma moyolkuepakan inawak in Señor katlej yejwan inDios. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yej achtoj kinyektlalilis inyolo in tlakaj para ma kiresibirokan in toSeñor katlej satepan witz. Kipias iyolo iwan kipias poder ken Elías okipixke. Kichiwas ma moyekwikakan in tetajmej inwan inpilwan, iwan katlej mach kitlakitaj Dios ma kipiakan tlalnamikilistle, ijkón ken kipiaj katlej kualtin tlakaj. Para ijkón kinyekketzas in tlakaj para weliskej kiresibiroskej in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías okitlajtlanij in ángel: ―¿Kenik nikmatis kox melawak? Porke nej iwan nosiwa ya titetajtzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","In ángel okinankilij: ―Nej niGabriel, niktekipanoa in toTajtzin Dios. Yej onechwaltitlanke para ma nimitzilwiki yin kuale tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero axan, komo mach otikneltokak tlan onimitzilwij, axan tinontis iwan mach ok welis titlajtos asta ijkuak tlakatis in mokone. Iwan nochi yin tlan nimitzilwijtok ijkón mochiwas nijkuak ajsis tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ijkuakón in tlakaj oyekaj kalan okichixtokaj in Zacarías, iwan otlanemilijtokaj de tlanik wejkajtok iwan mach walkisa totoka de ijtik in weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nijkuak in Zacarías okiske, mach ok owelik okintlapowij. Ijkuakón okimomakakej kuenta nik in Dios okititij itlaj tlamantle kej yeskia se teemiktle ijtik in weyi tiopan. Zacarías okintlapowiaya sa ika señas, porke onontik. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nijkuak otlankej in tonaltin de otekipanoj in Zacarías itech in weyi tiopan, oyáj para ichan. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Satepan de yon, Elisabet omokonetij, iwan mach okiske de ichan kej makuile metztle, okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Axan in Señor onechchiwilij tlan kuale ika itlasojtlalis, para mach ok ma nechpinawikan por amo niweli nikinpia nokonewan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nijkuak Elisabet yokipiaya chikuasen metztle de omokonetij, Dios okualtitlanke iángel Gabriel itech se pueblo de estado de Galilea itoka Nazaret, ");
INSERT INTO nhyNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kan ochantia se ichpochtle itoka María. Yon María yokatka para monamiktis iwan se tlakatl itoka José, katlej walajtok nelwatl de yen rey David. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","In ángel okalakke kan okatka in María iwan okilwij: ―Xipaki tejwatzin María. Dios sa tekitl tikpaktia. In Señor mowan kajki iwan Dios omitzpejpenke de nochtin siwamej. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero nijkuak okitak in ángel, sa otlajtlachixke (omomajmawtij) iwan mach ok okimatke tlan kijtos, iwan okimolwij tlan kijtosneki yon tlan kijta in ángel. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ijkuakón in ángel okilwij: ―María, amo ximomawti, porke Dios tikpaktia. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Axan tikpias mokone, iwan tiktlakatilis se chokotzin, iwan tiktokayotis Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yej sa tekitl weyikistos (weyititos), iwan kinotzaskej iKone in Dios weyikistok, iwan toSeñor Dios kitlalis ma yeto Rey para ma tlanawati ijkón ken otlanawatij in ya wejkawitl iweyitaj David, ");
INSERT INTO nhyNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yej nochipa yetos tekiwaj itech país de Israel, iwan itekiwajkayo mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tonses María okitlajtlanij in ángel: ―¿Kenik ma nikpia nokone iwan mach nikpia nookich? ");
INSERT INTO nhyNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","In ángel okinankilij: ―In Espíritu Santo witz mopan, iwan ipoder in Dios weyikistok (weyititok) mitzkemis kej mixtle. Por yonik, in konetl tlakatis yolchipawak iwan kinotzaskej iKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Moprima Elisabet noijki kipias se iKone maski ya tenantzin, katlej miekej okijtoayaj mach weli kinpia ikonewan, pero axan ya kipia chikuasen metztle de omokonetij. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Dios nochi weli kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tonses in María okijtoj: ―Nej niitekipanoj in Señor. Ma kichiwa nowan ijkón ken yotikijtoj. Ijkuakón in ángel owalpoliwik. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Itech yonmej tonaltin María oyáj totoka itech se pueblo katlej oyeka ik tepeyoj de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Nijkuak oajsito itech yon pueblo, okalakke ichan Zacarías iwan okitlajpaloj in Elisabet. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iwan nijkuak Elisabet okikakke okitlajpaloj in María, in konetl omolinij itlalaxko in Elisabet, iwan otenke de Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Iwan okijtoj chikawak: ―Dios omitztiochij okachi ke nochtin in siwamej, iwan okitiochij mokone katlej tikpixtok motlalaxko. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Akin nej, komo para ma wiki ma nechtlajpaloki imaman in noSeñor? ");
INSERT INTO nhyNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Porke san niman nijkuak onikakke otinechtlajpaloj, nokone omolinij noijtik ika pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Xipaki, porke otikneltokak, porke mochiwas nochi tlan toSeñor omitzilwij. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ijkuakón María okijtoj: Noanima kiweyikixtia in Señor, ");
INSERT INTO nhyNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","iwan noyolo paki inawak Dios noTemakixtij. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Porke maski nitzikitzin iwan san niitekipanoj, Yej onechelnamikke, iwan desde axan nochtin in tlaltikpaktlakaj kijtoskej nik in Dios onechtiochij sa tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Porke Dios katlej yolchipawak iwan katlej kipia nochi poder notech okinchij wejweyin tlamantin. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nochipa kinmiknomatis nochtin akinmej kitlakitaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kinchiwa wejweyin tlamantin ika ipoder. Okinkaj se lado katlej moweyinekij. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","In tekiwajkej okinkixtij de itech intlanawatijkayo, iwan okinmakak weyikixtilistle katlej moiknomatij. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Katlej otiojsiwiaj okinmakak nochi tlan kuale, iwan katlej kimopialiaj mach itlaj okinmakak. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Okipalewij in país de Israel katlej itekipanoj, mach okelkaj de kinmiknomatis, ");
INSERT INTO nhyNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","okichij ijkón ken okinmilwijka in ya wejkawitl toweyitajwan, ijkón ken tlan okilwijka in Abraham iwan nochtin ipilwan, nik kintlasojtlas nochipa. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María omokaj iwan Elisabet kej eyi metztle, iwan satepan omokuepke para ichan. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nijkuak oajsik tonale para kitlakatilis ikone in Elisabet, okitlakatilij se chokotzin. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nijkuak ibesinoswan iwan iparienteswan okimatkej kenik in Señor okiknomatke iwan okichij tlan kuale, ijkuakón oyajkej okitlajpalotoj iwan opakej iwan Elisabet. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Owalchikometik oyajkej okisirkunsidarotoj in chokotzin, iwan okinekiaj kitokayotianij Zacarías ijkón ken itoka in tetaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero in tenan okijtoj: ―Amo. Moneki tiktokayotiskej Juan. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Iwan okilwijkej: ―¿Tlanik? Mach akaj ijkón itoka itech mofamilia. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ijkuakón okitlajtlanijkej ika señas in tetaj, para kimatiskej kenamij kineki kitokayotis ichokotzin. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","In tetaj okitlajtlanke se amatl para itech kijkuilos, iwan ijkín okijkuiloj: “Yetos itoka Juan.” Iwan nochtin sa otlajtlachixkej (omomajmawtijkej). ");
INSERT INTO nhyNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iwan san niman ijkuakón Zacarías oksemi owelik otlajtoj, iwan opéj kiweyikixtia in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nochtin ibesinoswan sa otlajtlachixkej. Iwan oxoyawik (oxitinki) in tlajtole de tlan otlamochij itech nochi in yon región tepeyoj de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nochtin akinmej okikakiaj, okiyejyekoayaj iwan omotlajtlaniayaj se iwan oksé: ―¿Tlan itekiw yetos in yon chokotzin? Ijkón okijtoayaj porke ya nele melawak in Señor okimakak ipoder in yon chokotzin. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, ipapan Juan, otenke de Espíritu Santo iwan okijtoj tlan Dios okimakak ma kijto. Ijkín okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ma tikweyikixtikan in Señor, Dios de Israel, porke owalaj otechpalewiko, tejwan katlej tikatej kej ipueblo para techmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yotechmakak se chikawak toTemakixtij katlej walajtok nelwatl de yen rey David katlej itekipanoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ijkón ken Dios yokijtojka ya wejkawitl itech inten in profetajtin yolchipawakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nik techmakixtis de inmak tokontraswan iwan de nochtin akinmej techkokoliaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iwan kipias iteiknotlamachilis towan ijkón ken okinmilwijka in ya wejkawitl toweyitajwan, iwan mach kelkawas in akuerdo tlan okijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dios ijkón okilwij in ya wejkawitl toweyitaj Abraham. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Okilwij nik techmakixtis de inmak tokontraswan, para ma tiktekipanokan ika ixchikawalistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Okilwij ma tiekan tiyolchipawakej iwan ma tiekan tikualtin tlakaj inawak Dios asta ijkuak timikiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iwan tej, tinokone, mitznotzaskej tiprofeta de Dios weyikistok (weyititok), porke tej titlayekanas para tikyektlalijtias iojwi in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Para tikinmatiltis in tlakaj de ipueblo kenik momakixtiskej, para ijkón Dios kintlapojpolwis de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","In toTajtzin Dios kintlapojpolwia porke sa tekitl kipia weyi iteiknotlamachilis. Iwan ika iteiknotlamachilis techwaltitlanilis se yankuik tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Para kinmakas tlanextle katlej nemij ijtik tlatleyualotl iwan katlej nemij ijtik mikilistle, iwan para techyekanas ipan ojtle de yolosewilistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","In chokotzin Juan omoskaltiaya iwan Dios okichikawaya ipan ianima, iwan ochantito kan tlawaki asta ijkuak oajsik tonale nijkuak okinmotitij in tlakaj de Israel iwan opéj kintlapowia de itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Itech nekatej tonaltin in weyi tlanawatij Augusto César otlanawatij ma majkokui se censo itech nochtin in tlakaj de nochi in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yin yakinika censo omochij nijkuak Cirenio oyeka gobernador de Siria. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nochtin oyayaj para inpueblo para ompa moijkuiloskej itech censo. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Por yonik, in José okiske de pueblo de Nazaret, de estado de Galilea, iwan oyáj itech estado de Judea, itech pueblo de Belén, kan otlakatke in rey David, porke in José owalajtoka nelwatl de David. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","José oyáj ompa Belén san sekan iwan María para moijkuiloskej itech censo. Porke María iwan José yakin omonamiktijkej, iwan María yokipiaya ikone ijtik itlalax. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iwan nijkuak oyekaj Belén, oajsik in tonale para tlakatis ikone in María. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ompa okitlakatilij ikone katlej yankuiotl, okimiloj ika tzinkuemej iwan okitekak ijtik se kajon katlej okipiaya sakatl kan otlakuayaj in yolkamej. Porke mach ok oyeka lugar itech yon kale kan tekalotiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Mach wejka de Belén oyekaj sekimej tlajpixkej okinmonekuitlawijtokaj de yuak inmichkawan. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","San niman ijkuakón okinmonextilij se iángel in Señor, iwan okintlawilij imawisotlanex in Señor, iwan yejwan sa tekitl omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero in ángel okinmilwij: ―Amo ximomawtikan, porke oniwalaj para namechmatiltis se kuale tlajtole, katlej welis kinpaktis nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Axan itech ipueblo in David otlakatke namoTemakixtij, yen Cristo in toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iwan para welis ankixmatiskej, namejwan ankitemoskej iwan ankajsiskej in konetzintle kimilitok ika tzinkuemej, iwan wetok ijtik se kajon katlej kipia sakatl kan tlakuaj in yolkamej. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ijkuakón omonextijkej ik inakastlan ángel, oksekimej miekej angelestin de ilwikak, katlej okiweyikixtiayaj in toTajtzin Dios. Okijtoayaj: ");
INSERT INTO nhyNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Dios ma kipia yektenewalistle ompa ilwikak, iwan ixko yin tlaltikpak ma yeto yolosewilistle itech nochtin katlej kipaktiaj in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nijkuak in angelestin omokuepkej para ilwikak, in tlajpixkej opéj kimolwiaj se iwan oksé: ―Ma tiwian kiné para Belén. Ma tikitatij tlan otlamochij, tlan otechmatiltij in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Oyajkej totoka iwan okitajsikej in María iwan José, iwan konetl wetok ijtik kajon kan tlakuaj in yolkamej. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nijkuak okitakej in konetl, okitemakakej kuenta nochi tlan okinmilwij in ángel de yon konetl, ");
INSERT INTO nhyNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","iwan nochtin katlej okikakej de tlan okijtojkej in tlajpixkej sa otlajtlachixkej (omomajmawtijkej). ");
INSERT INTO nhyNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María nochi in yon okitlaatij ipan iyolo, iwan nochipa okelnamikia nochi tlan otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","In tlajpixkej omokuepkej kan oyekaj inmichkawan. Oyajkej okiweyikixtijtiajkej iwan okiyektenejtiajkej in toTajtzin Dios por nochi tlan okikakej iwan okitakej, ijkón ken okinmilwij in ángel. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nijkuak ochikometik de otlakatke in konetl, okisirkunsidarojkej iwan okitokayotijkej Jesús, ijkón ken ángel okilwij in María antes de mokonetis. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nijkuak opanokej in tonaltin de omochipajkej, ijkón ken kijta in tlanawatile de Moisés, okiwikakej in konetl Jesús itech weyikan de Jerusalén para kixpantiliskej in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ijkón okichijkej porke itech itiotlajkuilol in Señor kijta: “Nochtin katlej konemej yankuiomej kipiaj de kinmixpantiliskej in Señor para yeskej iaxkawan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Oyajkej kiné, para kitemakaskej ome yolkamej para ma kinmiktikan ipan artal iwan kimakaskej toTajtzin Dios kej se tlamanale, ijkón ken kijta itlanawatil in Señor, omen kokolotzitzintin o noso omen palomastin. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Itech nekáj tiempo ochantia Jerusalén se tlakatl itoka Simeón. Oyeka kuale tlakatl iwan sa tekitl omotemaktiaya inawak Dios, iwan okichiaya kemanian tlakatis akin kinmakixtis in tlakaj de Israel. Simeón otentoka de Espíritu Santo, ");
INSERT INTO nhyNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","iwan okimatiltijka nik mach mikis asta amo ma kita in Cristo, katlej toSeñor kiwaltitlanis. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Iwan in Espíritu Santo okitoktij in Simeón ma wia kan weyi tiopan. Iwan nijkuak in tetajmej de yen konetl Jesús okiwikakej ompa kan weyi tiopan para kichiwaskej según tlan kijta itlanawatil in Moisés, ");
INSERT INTO nhyNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón okinapaloj in konetl Jesús iwan okiweyikixtij in Dios. Okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Señor, axan ya welis tinechkawilis ma nimiki ika kuale, porke axan yotikchij tlan otinechilwijka nej nimotekipanoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yonikitak ika noixtololowan in toTemakixtij katlej yotikkualtitlanke, ");
INSERT INTO nhyNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","iwan katlej yotiktlalij inmixpan nochtin in tlakaj de ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yej kajki kej se tlanextle katlej kintlawilis katlej mach judiojtin, iwan kinmakas tetlakitalistle mokonewan katlej judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José iwan imaman Jesús sa otlajtlachixkej (omomajmawtijkej) de tlan okijtoj in Simeón de yen konetl Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ijkuakón Simeón okintiochij, iwan okilwij in María imaman in Jesús: ―Yin mokone, Dios okitlalij para miekej tlakaj de Israel moixpoloskej porke mach kineltokaskej. Pero miekej tlakaj momakixtiskej inawak porke kineltokaskej. Iwan Yej kiteititis in ojtle para kalakiskej ilwikak inawak Dios, pero miekej mach kinekiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Iwan ijkón miekej tlakaj tlan kiyejyekoaj ipan inyolo nochi momatis. Pero para tej nochi in yin yetos kej se espada katlej kitzopitis moanima. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ompa oyeka noijki se siwatl profeta, itoka Ana, ichpoch in Fanuel, de familia de Aser. Yoyeka tenantzin. Omonamiktijka wel ok ichpochtle, iwan oyeka iwan iokich san chikome xiwitl, ");
INSERT INTO nhyNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","iwan axan yoyeka viuda ya nawinpoale iwan nawi xiwitl. Mach okisaya de kan weyi tiopan, sino okitekipanoaya in toSeñor yuale tonale, omosawaya (oayunaroaya) iwan omotiotzajtziliaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Yon viuda Ana owalaj itech yon ora, iwan omotlasojkamatke inawak Dios. Iwan opéj kintlapowia de yon konetl Jesús nochtin in tlakaj de Jerusalén katlej okichiayaj ma wiki in Cristo para kinmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Satepan de okichijkej nochi tlan kijta itlanawatil in Señor, omokuepkej para Galilea, itech inpueblo de Nazaret. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","In chokotzin Jesús omoskaltiaya iwan omochikawaya, iwan okajsia miek ixtlamachilistle. Iwan toTajtzin Dios okitiochiwaya miek. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Itajwan in Jesús nochi xiwitl oyayaj Jerusalén itech ilwitl de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nijkuak Jesús okipixke majtlaktle iwan ome xiwitl, Yej iwan itajwan oyajkej Jerusalén ijkón ken okichiwayaj nochi xiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nijkuak otlanke ilwitl, iwan yomokuepayaj para inpueblo Nazaret, in chokotzin Jesús omokaj Jerusalén, pero imaman iwan ipapan mach okimomakakej kuenta kox omokaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Itajwan okiyejyekojkej nik in Jesús ompa owalaya inwan oksekimej tlakaj. Pero nijkuak yonejnenkej se tonale, opéj kitemoaj kan owalayaj infamiliareswan iwan inmamigoswan, ");
INSERT INTO nhyNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pero mach okajsikej. Tonses oksemi omokuepkej para Jerusalén okitemotoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eyi tonale satepan okajsikej kan weyi tiopan, ompa oewatoka inwan tlamachtijkej de itlanawatil in Moisés, okinkaktoka iwan okintlatlajtlaniaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iwan nochtin akinmej okikakiaj sa omotlajtlachialtiayaj (omomajmawtiayaj) porke okipiaya kuale ixtlamachilistle iwan porke kuale okinnankiliaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nijkuak itajwan okitakej, sa otlajtlachixkej. Iwan imaman okilwij: ―Nokone, ¿tlanik ijkón otitechtoktij? Mopapan iwan nej sa tekitl titlanemiliaj timitztemojtinemij. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ijkuakón Jesús okinmilwij: ―¿Tlanik annechtemoaj? ¿Amo ankimatij nik moneki nikchiwas in tekitl de noPapan? ");
INSERT INTO nhyNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yejwan mach okimomakakej kuenta tlan okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ijkuakón Jesús omokuepke inwan para Nazaret iwan okintlakitaya itajwan. María okitlaatiaya ipan iyolo nochi yon tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús okachi omoskaltiaya iwan okajsia okachi ixtlamachilistle, iwan okipaktiaya in toTajtzin Dios iwan noijki okinpaktiaya in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nijkuak Tiberio César yokipiaya kaxtole xiwitl de weyi tekiwaj de Roma, Poncio Pilato oyeka gobernador itech estado de Judea, Herodes oyeka gobernador itech estado de Galilea, iwan Felipe ikni in Herodes oyeka gobernador de estado de Iturea iwan de estado de Traconite, iwan Lisanias oyeka gobernador de estado de Abilinia. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás iwan Caifás oyekaj wejweyin tiopixkej. Itech yon tiempo Dios okitlapowij in Juan, itelpoch in Zacarías, kan tlawaki. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Por yonik, in Juan oyáj itech nochtin in tlalmej katlej katej inakastlan weyatl itoka Jordán. Okinmilwiaya in tlakaj ma moyolkuepakan inawak Dios para ma kintlapojpolwi de intlajtlakol, iwan ijkón ma mokuateekikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ijkón ken profeta Isaías okijkuiloj: Se tlajtole mokaki tetzajtzilia kan tlawaki: “Xikyektlalikan iwan xikmelawakan iojwi in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nowian (nian nepa) kan tlawewejkatlan moixmanas, nochtin tepemej iwan tepetzitzintin moixmanaskej, in ojmej katlej chichijkoltikej momelawaskej, in ojmej kan tlawewejkatlan kipia de moixmanaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Iwan nochtin in tlaltikpaktlakaj kitaskej kenik temakixtis in Dios.” ");
INSERT INTO nhyNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Miekej tlakaj owalayaj inawak Juan para ma kinkuateeki, iwan Juan okinmilwiaya: ―¡Namejwan kej ankoamej! ¿Akin oamechilwij tla anmokuateekiskej welis ancholoskej de itech ikualanilis in Dios katlej amopan witz? ");
INSERT INTO nhyNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xikchiwakan tlan kuale para ma mota nik melawak ya anmoyolkuepkej. Iwan amo xikmolwikan: “Tejwan tiwalajtokej nelwatl de Abraham.” Porke ipan melajka namechilwia, ke asta yinmej temej Dios welis kinkuepas nelwamej de Abraham. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","In acha sa mochixtok para kintzontekis in kuanmej. Iwan nochtin in kuanmej katlej mach kitemakaj kuale intlakilo, se kintzontekis iwan se kintlamotlas ijtik tlitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ijkuakón in tlakaj okitlajtlanijkej: ―¿Tlan moneki tikchiwaskej kiné? ");
INSERT INTO nhyNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan okinnankilij: ―Akin kipia ome ikamisa, ma kimaka se akin amo kipia. Iwan akin kipia tlan kikuas, ma kimaka sekin akin amo kipia tlan kikuas. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Noijki owalajkej sekimej katlej tlakobraroaj ika impuestos para mokuateekiskej, iwan okitlajtlanijkej in Juan: ―Tlamachtij, ¿tlanon moneki tikchiwaskej in tejwan? ");
INSERT INTO nhyNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan okinmilwij: ―Amo xitlakobrarokan okachi de tlan moneki antlakobraroskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Noijki sekimej soldadojtin okitlajtlanijkej: ―Iwan tejwan, ¿tlanon moneki tikchiwaskej? Iwan yej okinmilwij: ―Amakaj itlaj xikixtilikan, nimpor amo xikmajmawtikan iwan nion amo xikistlakawikan de itlaj tlan amo okichij. Iwan xikixitakan namotlaxtlawil. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Komo nochtin in tlakaj okichixtokaj ma wiki in Cristo san niman, por yonik in yejwan okiyejyekoayaj xamo yen Juan in Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero in Juan okinmilwij nochtin: ―Nej, melawak, namechkuateekia ika atl. Pero witz se tlakatl katlej amechkuateekis ika Espíritu Santo iwan ika tlitl. Yej okachi kipia poder iwan amo ken nej, iwan nion mach notech powi nion para nikaktotomas. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yej ejkos kej se tlakatl katlej pewas kichipawas in trigo. In trigo katlej ya chipawak kitlaatis ijtik ikueskon, pero itlajsolo kitlamotlas ijtik tlitl katlej mach keman sewis. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ijkón, iwan ika okachi miek oksekin tlajtole de tlanajnawatilistle, Juan okintlapowiaya in tlakaj de yen yankuik kuale tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Noijki okajwak in gobernador Herodes, porke okimosiwatij in Herodías katlej oyeka ikuñada. Yon Herodías oyeka isiwa in Felipe, ikni in Herodes. Juan noijki okajwak in Herodes porke okichij miek oksekin tlamantle tlan mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero Herodes mach okinekke okikakke, sino okichij oksé tlamantle tlan mach kuale, okitzakke in Juan ijtik telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pero nijkuak ayamo okitzakuayaj in Juan, otlamochij ke nijkuak in Juan okinkuateekijtoka miekej tlakaj, ijkuakón noijki omokuateekij in Jesús. Iwan mientras Jesús omotiotzajtziliaya inawak Dios, in ilwikak otlapowik ");
INSERT INTO nhyNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iwan in Espíritu Santo owaltemok ipan Jesús kej se paloma. Iwan omokakke se tlajtole de ilwikak, ijkín okijtoj: ―Tej tinotlasojKone, iwan sa tekitl nipaki monawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús okipiaya kej senpoale iwan majtlaktle xiwitl nijkuak opéj tetlapowia de itlajtol in toTajtzin Dios. In tlakaj kiyejyekoaj nik in Jesús oyáj tekone de José. José oyáj tekone de Elí, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","iwan Elí oyáj tekone de Matat, Matat oyáj tekone de Leví, Leví oyáj tekone de Melqui, Melqui oyáj tekone de Jana, Jana oyáj tekone de José, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José oyáj tekone de Matatías, Matatías oyáj tekone de Amós, Amós oyáj tekone de Nahúm, Nahúm oyáj tekone de Eslí, Eslí oyáj tekone de Nagai, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai oyáj tekone de Maat, Maat oyáj tekone de Matatías, Matatías oyáj tekone de Simei, Simei oyáj tekone de José, José oyáj tekone de Judá, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá oyáj tekone de Joana, Joana oyáj tekone de Resa, Resa oyáj tekone de Zorobabel, Zorobabel oyáj tekone de Salatiel, Salatiel oyáj tekone de Neri, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri oyáj tekone Melqui, Melqui oyáj tekone de Adi, Adi oyáj tekone de Cosam, Cosam oyáj tekone de Elmodam, Elmodam oyáj tekone de Er, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er oyáj tekone de Josué, Josué oyáj tekone de Eliezer, Eliezer oyáj tekone de Jorim, Jorim oyáj tekone de Matat, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat oyáj tekone de Leví, Leví oyáj tekone de Simeón, Simeón oyáj tekone de Judá, Judá oyáj tekone de José, José oyáj tekone de Jonán, Jonán oyáj tekone de Eliaquim, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim oyáj tekone de Melea, Melea oyáj tekone de Mainán, Mainán oyáj tekone de Matata, Matata oyáj tekone de Natán, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán oyáj tekone de David, David oyáj tekone de Isaí, Isaí oyáj tekone de Obed, Obed oyáj tekone de Booz, Booz oyáj tekone de Salmón, Salmón oyáj tekone de Naasón, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón oyáj tekone de Aminadab, Aminadab oyáj tekone de Aram, Aram oyáj tekone de Esrom, Esrom oyáj tekone de Fares, Fares oyáj tekone de Judá, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá oyáj tekone de Jacob, Jacob oyáj tekone de Isaac, Isaac oyáj tekone de Abraham, Abraham oyáj tekone de Taré, Taré oyáj tekone de Nacor, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor oyáj tekone de Serug, Serug oyáj tekone de Ragau, Ragau oyáj tekone de Peleg, Peleg oyáj tekone de Heber, Heber oyáj tekone de Sala, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala oyáj tekone de Cainán, Cainán oyáj tekone de Arfaxad, Arfaxad oyáj tekone de Sem, Sem oyáj tekone de Noé, Noé oyáj tekone de Lamec, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec oyáj tekone de Matusalén, Matusalén oyáj tekone de Enoc, Enoc oyáj tekone de Jared, Jared oyáj tekone de Mahalaleel, Mahalaleel oyáj tekone de Cainán, ");
INSERT INTO nhyNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán oyáj tekone de Enos, Enos oyáj tekone de Set, Set oyáj tekone de Adán, Adán oyáj tekone de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús okiske de ijtik in weyatl Jordán tentok de Espíritu Santo. Iwan in Espíritu Santo okiwikak kan tlawaki. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ompa omokaj omenpoale tonale, iwan in diablo okinekia kitlajtlakolmayawini in Jesús. Mach itlaj okikuaj nion tlenon itech yon omenpoale tonale, iwan satepan otiojsij. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satepan in diablo okilwij: ―Tla melawak titeKone de Dios, xikilwi in yin tetl ma mokuepa pan. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús okinankilij: ―In tiotlajkuilole kijta: “In tlakatl mach yolitos san ika tlakuale, sino noijki ika nochi tlajtole katlej Dios kijta.” ");
INSERT INTO nhyNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Satepan in diablo okiwikak ipan se tepetl wejkapan, iwan san niman okinmititij nochtin in paismej katlej katej ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Iwan in diablo okilwij: ―Nej nimitzmakas nochi tlanawatijkayotl iwan weyikixtilistle itech yinmej paismej. Porke nej nochi noaxka, iwan welis nikmakas san akin nej niknekis. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Tla timotlankuaketzas noyakapan iwan tinechweyikixtis, nochi in yin yetos moaxka. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero Jesús okinankilij: ―Xitzinkisa de Nej, Satanás, porke in tiotlajkuilole kijta: “Xikweyikixti in Señor moDios, iwan sanwel Yej xiktekipano.” ");
INSERT INTO nhyNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Satepan in diablo okiwikak itech weyikan de Jerusalén iwan okitlejkoltij ikpak in weyi tiopan, iwan okilwij: ―Tla melawak titeKone de Dios, ximotlamotla asta ipan tlale. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Porke itech in tiotlajkuilole kijta: Dios kinnawatis iangelwan ma mitzpalewikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mitzajkokuiskej ika inma, para amo tikmomagati itlaj tetl itech mokxi. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús okinankilij: ―In tiotlajkuilole noijki kijta: “Amo xikyejyeko in Señor moDios para tikitas tlanon kichiwas.” ");
INSERT INTO nhyNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","In diablo ayakmo owelia ken kichiwas para kitlajtlakolmayawini in Jesús, iwan okikaj por se tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús omokuepke itech estado de Galilea tentok de ipoder in Espíritu Santo, iwan nochtin in tlakaj de yon región omotlapowiayaj de Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Itech nochtin pueblojtin otlamachtiaya itech tiopanmej de yen judiojtin, iwan nochtin okiweyikixtiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Satepan Jesús oyáj para Nazaret, itech ipueblo kan Yej omoskaltij. Nijkuak weyi tonale okalakke itech se tiopan de yen judiojtin, ijkón ken Yej okimatia okichiwaya, iwan omoketzke para kileros in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Okimakakej in libro katlej okijkuiloj in profeta Isaías. Iwan nijkuak okitlapoj, okajsik kan ijkuilitok ijkín: ");
INSERT INTO nhyNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","IEspíritu in Señor notech kajki, porke Dios onechtlalij para ma nikintlapowi in pobrestin de yen yankuik kuale tlajtole. Onechwaltitlanke para ma nikinpajti katlej moyolkokoaj, para ma nikinmatilti in tlajtole katlej temakixtia katlej ilpitokej ipan tlajtlakole, para ma nikintlachialti katlej mach tlachiaj, para ma nikinmakixti katlej kintlajyowiltiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Iwan para ma niktematilti nik yoajsiko in tonale para Dios kintiochiwas nochtin akinmej witzej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Satepan Jesús okitzakke in libro, okimakak katlej tlapalewia itech yon tiopan iwan omotlalij. Iwan nochtin katlej oyekaj itech yon tiopan sa okitlajtlatakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ijkuakón Yej opéj ijkín kijta: ―Yin tiotlajkuilole katlej yakin tlami ankikakej axan yomochij tlan kijta. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nochtin kuale otlajtoayaj de Jesús, iwan sa omotlajtlachialtiayaj (omomajmawtiayaj) de yen kuakualtzin tlajtole katlej okinmilwiaya. Iwan omotlajtlaniayaj: ―¿Amo yen yin ikone in José? ");
INSERT INTO nhyNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús okinmilwij: ―Namejwan xamo ankinekij annechilwiskej in yin tlajtole: “Tepajtij, tej monewian ximopajti.” Iwan noijki xamo ankinekij annechilwiskej ke nochi tlamantle katlej ankikakej onikchij Capernaum, noijki ankinekij ma nikchiwa nian itech nopueblo. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Noijki okinmilwij: ―Ipan melajka namechilwia, nik mach akaj profeta kiresibiroaj ika kuale itech ipueblo. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Noijki ipan melajka namechilwia nik oyekaj miekej viudajtin itech país de Israel itech nekáj tiempo nijkuak Elías oyeka profeta, nijkuak mach okiawik kej eyi xiwitl iwan tlajko, iwan oyeka miek apistle itech nochi in país de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Dios mach okititlanke in Elías nion siera inawak se viuda de Israel, sino okititlanke inawak se viuda katlej ochantia itech pueblo de Sarepta, katlej serka motok iwan weyikan de Sidón. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Noijki itech nekáj tiempo nijkuak Eliseo oyeka profeta, noijki oyekaj miekej tlakaj katlej opalania innakayo itech país de Israel. Pero Eliseo mach okipajtij nion se de yejwan, sino okipajtij san yen Naamán, katlej oyeka de país de Siria. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nijkuak okikakej yon tlan okinmilwij, nochtin katlej oyekaj itech yon tiopan sa tekitl okualankej. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Omokeketewakej iwan okikixtijkej in Jesús de itech yon pueblo, iwan okiwikakej asta ikpak in tepetl kan oyeka yon pueblo, para ompa kitepejxiwianij. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero Jesús opanok intzalko iwan oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Satepan Jesús oyáj para Capernaum, se pueblo katlej kajki itech estado de Galilea, iwan ompa opéj kinmachtia in tlakaj nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Sa omotlajtlachialtiayaj (omomajmawtiayaj) de kenik okinmachtiaya, porke otlamachtiaya ika miek tlanawatile. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Itech se tiopan de yen judiojtin oyeka se tlakatl katlej okipiaya se ejekatl mach kuale, iwan otzajtzik okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―¡Xitechkawa! ¿Tlan tikpia towan, Jesús de Nazaret? Nej nikmati akin Tej. Tej tiiyolchipawkaKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús okajwak in ejekatl mach kuale, iwan okilwij: ―¡Xiktzakua moten, iwan xikisa de itech yon tlakatl! Ijkuakón in ejekatl mach kuale okitlalwitekke in tlakatl inyakapan, iwan okiske de itech, iwan mach ok itlaj okitoktij. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nochtin omomajmawtijkej, iwan okimolwiayaj se iwan oksé: ―¿Tlan kijtosneki yin tlamachtile? Itlajtol kipia tlanawatile iwan kipia poder porke kinnawatia in ejekamej mach kualtin, iwan yejwan kitlakitaj iwan kisaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iwan itech nochi yon región omotlapowiayaj de tlan Jesús okichiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús okiske de itech yon tiopan iwan okalakke ichan Simón. Imonan in Simón sa tekitl ototonkawiloaya, iwan okitlatlawtijkej in Jesús ma kipajti. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús omijkuanij kan oyeka in siwatl iwan okajwak in totonik, iwan totonik okiske. Iwan san niman in siwatl omejke iwan opéj kintlamaka. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nijkuak ya ompolitiw in tonale, nochtin in tlakaj katlej okinpiayaj inkokoxkawan okualinwikilijkej in Jesús. In kokoxkej okipiayaj tlatlamantle kokolistle, pero Jesús okintlalij imawan inpan nochtin kokoxkej iwan opajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Miekej de yonmej kokoxkej okinpiayaj ejekamej mach kualtin. Nijkuak okisayaj in ejekamej mach kualtin, otzajtziaj chikawak, okijtoayaj: ―¡Tej titeKone de Dios! Pero Jesús okinmajwak in ejekamej mach kualtin iwan mach okinkawilij ma tlajtokan, porke yejwan okimatiaj nik in Jesús yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nijkuak owalmostlatik, Jesús okiske de itech yon pueblo de Capernaum iwan oyáj se lugar kan yetos san Yej iselti. Pero in tlakaj okitemojkej, iwan nijkuak okajsikej okitlatlawtijkej amo ma wia. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús okinmilwij: ―Noijki moneki niktematiltis itech oksekimej pueblojtin in kuale tlajtole katlej temakixtia de kenik in Dios tlanawatia, porke por yonik oniwalaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ijkón, Jesús otlamachtijtinemia itech nochtin tiopanmej de yen judiojtin de estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Se tonale, Jesús oyeka itempan lago itoka Genesaret, iwan sa tekitl miekej tlakaj oyekaj iwan asta sa ipan omotojtopewayaj, para kikakiskej itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús okinmitak ome barkojtin oyekaj itempan atl, iwan michmajkej yokiskej okinpakatoj inmichmatlawan. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Otlejkok itech se barko, katlej iaxka in Simón, iwan okilwij ma kitzinkixti achitzin de itempan atl. Omotlalij itech yon barko iwan desde ompón opéj kinmachtia in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nijkuak otlanke otlapoj, okilwij in Simón: ―Xikijkuani in barko kan okachi tlawejkatlan, iwan ompa xikintlamotlakan namomichmatlawan. Ompa ximichmakan. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","In Simón okinankilij: ―Tlamachtij, nochi in se yuale ya otitekipanojkej iwan mach itlaj otikajsikej, pero komo tejwatzin tinechilwia ompa ma niktlamotla nomichmatlaw, ijkón nikchiwas kiné. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nijkuak ijkón okichijkej, okinkitzkijkej sa tekitl miekej michimej asta okojkotonia imichmatlaw. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ijkuakón okinchiwilijkej señas inkompañeroswan katlej oyekaj itech oksé barko para ma kinpalewitij. Yejwan oyajkej iwan okinsepantemitijkej inbarkojwan asta ya meroj apolakinij. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nijkuak ijkón okitak in Simón Pedro, omotlankuaketzke iyakapan Jesús, iwan okilwij: ―Xitzinkisa de nej, Señor, porke nej nitlajtlakolej. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","In Simón ijkón okilwij in Jesús, porke yej iwan nochtin ikompañeroswan sa otlajtlachixkej (omomajmawtijkej) por yen sa tekitl miekej michimej okinkixtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Noijki sa otlajtlachixkej in Jacobo iwan Juan ipilwan in Zebedeo, katlej oyekaj iamigoswan in Simón. Pero Jesús okilwij in Simón: ―Amo ximomawti, porke desde axan ya pewas tikintlapowis in tlakaj de notlajtol para ma momakixtikan kej yeskia tikinkitzkis michimej. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Satepan okintilankej inbarkojwan asta ipan tlale, ompa okajtejkej nochi iwan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nijkuak Jesús oyeka itech se pueblo, ompa oejkok se tlakatl kokoxke katlej opalania inakayo, iwan nijkuak okitak in Jesús, omotlankuaketzke iyakapan asta okitennamikke in tlale iwan okitlatlawtij okilwij: ―Señor, tla tiknekini, tiwelis tinechpajtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ijkuakón Jesús okitlalij ima ipan kokoxke, iwan okilwij: ―Aján, nikneki. Axan san niman xipajti. Iwan san niman ijkuakón in kokolistle opojpoliwik. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Satepan Jesús okinawatij in tlakatl amakaj itlaj ma kilwi. Okilwij: ―Xiwia, ximoteitititi inawak in tiopixke, iwan xiktemaka moofrenda tlan Moisés kijta itech itlanawatil, de ke nochtin katlej pajtij de innakayopalanalis, kipiaj de kitemakaskej inmofrenda, para ijkón nochtin ma kimatikan nik yotipajtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ik nowian (nian nepa) omotlapowiayaj okachi de Jesús, iwan miekej tlakaj omololoayaj para kikakiskej iwan para ma kinpajti de inkokolis. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero Jesús miekpa omoseladojkixtiaya de innawak in tlakaj, iwan oyaya ik se lugar kan yetos iselti para motiotzajtzilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Se tonale, kan Jesús otlamachtijtoka, ik ompa oewatokaj sekimej fariseos, iwan sekimej tlamachtijkej de itlanawatil in Moisés, katlej owalajkej de nochtin pueblojtin de estado de Galilea, de estado de Judea iwan de weyikan de Jerusalén. ToTajtzin Dios okimakak poder in Jesús para okinpajtiaya in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ijkuakón oejkokej sekimej tlakaj okiwalwikayaj se tlakatl wilan (temetlatzin) ipan itlapech, iwan okinekiaj kikalakianij kalijtik para kitlaliskej iyakapan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero mach owelik okikalakijkej, porke ompa oyekaj miekej tlakaj. Tonses otlejkokej ikpak kale. Okikuatlapojkej in kale, iwan ik ompa okitemowijkej in wilan ipan itlapech asta tlatlajko de kan oyekaj in tlakaj iwan kan oyeka in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nijkuak in Jesús okitak nik melawak okineltokayaj in yonmej tlakaj, ijkuakón okilwij in kokoxke: ―Tlakatl, nimitztlapojpolwia de nochi motlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ijkuakón in tlamachtijkej de itlanawatil in Moisés iwan fariseos opéj kiyejyekoaj: “¿Akin yin tlakatl? ¿Tlanik tlajtoa biero de Dios? Mach akaj welis tetlapojpolwis itech tlajtlakole, sino san yen Dios welis tetlapojpolwis.” ");
INSERT INTO nhyNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús yokimatia tlan okiyejyekojtokaj, iwan okinmilwij: ―¿Tlanik ijkón ankiyejyekoaj? ");
INSERT INTO nhyNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Katlij yen okachi mach owij nikijtos: “Nimitztlapojpolwia de nochi motlajtlakol”, o noso nikijtos: “Ximewa iwan xinejnemi”? ");
INSERT INTO nhyNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero axan Nej nikneki namechititis nik in Nej katlej onimochij nitlakatl, nikpia tlanawatile ixko yin tlaltikpak para nikintlapojpolwis in tlakaj de intlajtlakol. Ijkuakón okilwij in tlakatl katlej wilan: ―Tej nimitzilwia, ximewa, xikajkokui motlapech iwan xiwia mochan. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","San niman ijkuakón, in wilan (temetlatzin) omoketzke inyakapan, okajkokke itlapech iwan oyáj para ichan okiweyikixtijtiaj in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nochtin sa omotlajtlachialtijkej (omomajmawtijkej) iwan okiweyikixtijkej in toTajtzin Dios, iwan ika miek nemajmawtile okijtojkej: ―Axan yotikitakej se weyi tlamantle katlej mach semi otikitayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Satepan de yon, Jesús okiske iwan okitak se tlakatl katlej tlakobraroa ika impuestos itoka Leví. Oewatoka kan otlakobraroaya ika impuestos, iwan Jesús okilwij: ―Xiwiki nowan. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví omoketzke, okikajtej nochi, iwan oyáj iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Satepan, Leví okichij se weyi ilwitl ichan para yen Jesús. Ompa oyekaj miekej tlakaj tlakobrarojkej ika impuestos iwan miekej oksekimej tlakaj oewatokaj inwan itech mesa. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Pero in fariseos iwan in tlamachtijkej de itlanawatil in Moisés opéj kinpojpoaj imomachtijkawan in Jesús, iwan okinmilwijkej: ―¿Tlanik namejwan antlakuaj iwan ankonij inwan tlakaj tlajtlakolejkej iwan noijki inwan tlakaj katlej tlakobraroaj ika impuestos? ");
INSERT INTO nhyNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús okinnankilij: ―Se tepajtij mach moneki ma kinpajti katlej kualtin iwan katlej mach mokokoaj, sino moneki ma kinpajti katlej mokokoaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nej mach oniwalaj onikinnotzako katlej yolchipawakej, sino onikinnotzako katlej tlajtlakolejkej para ma moyolkuepakan de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ijkuakón yejwan okitlajtlanijkej in Jesús: ―¿Tlanik imomachtijkawan in Juan iwan fariseos mosawaj iwan motiotzajtziliaj miekpa, pero momomachtijkawan tlakuaj iwan konij? ");
INSERT INTO nhyNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús okinnankilij: ―¿Welis namejwan ankintoktiskej ma mosawakan katlej inbitadostin nijkuak katej itech se ilwitl kan monamiktiaj, mientras in novio ompa kajki inwan? ");
INSERT INTO nhyNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero ajsis tonale nijkuak kinkixtiliskej in novio, iwan ijkuakón kemaj welis mosawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Noijki okinmilwij yin ejemplo: ―Mach akaj kiteki se pedaso tzotzole yankuik para ika kitilichos se tzotzole katlej ya tlajtlantok. Tla ijkón se kichiwas, tzayanis in tzotzole katlej ya tlajtlantok, iwan in pedaso de tzotzole yankuik mach kinamikis in tzotzole katlej ya tlajtlantok. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Noijki mach akaj kitlalia vino yankuik ijtik kulambre katlej ya tlajtlantok. Porke in vino yankuik kitzomonia in kulambre katlej ya tlajtlantok, iwan nokiwi in vino iwan kulambre ijtlakawi. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","In vino yankuik moneki motlalis ijtik kulambre yankuik, iwan ijkón san ken omen kixikoskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iwan akin konis in vino katlej ya wejkawitl ewa, satepan mach ok kinekis konis vino katlej yankuik, porke kijtos: “In vino katlej ya wejkawitl ewa, okachi welik.” ");
INSERT INTO nhyNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ya semi nijkuak weyi tonale, Jesús onejnentiaya kan toktok trigo, iwan imomachtijkawan okitektiayaj in trigo. Okitoxomayaj iwan okikuayaj itliolo in trigo. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ijkuakón sekimej fariseos okintlajtlanijkej: ―¿Tlanik ijkón ankichiwaj namejwan tlan amo techkawilia in totlanawatil ma tikchiwakan nijkuak weyi tonale? ");
INSERT INTO nhyNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús okinnankilij: ―¿Amo keman ankileroaj tlan okichij in rey David nijkuak yej iwan ikompañeroswan oapismikiaj? ");
INSERT INTO nhyNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David okalakke ijtik in weyi tiopan, iwan okitilanke in pan katlej tlatiochiwaloj, okikuaj in pan, iwan asta okinmajmakak noijki ikompañeroswan para ma kikuakan. Maski itlanawatil in Moisés kijta nik san yen tiopixkej welis kikuaskej yon pan. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Noijki okinmilwij: ―Nej katlej onimochij nitlakatl, Nej nikpia de nikijtos tlanon welis mochiwas nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Itech oksé weyi tonale, Jesús okalakke itech se tiopan de yen judiojtin iwan ompa opéj tlamachtia. Ompa oyeka se tlakatl katlej owakke iyekma. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","In tlamachtijkej de itlanawatil in Moisés iwan fariseos sa okixpixtokaj in Jesús para kitaskej kox kipajtis in yon tlakatl itech weyi tonale, iwan ijkón welis kitilwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús okimatia tlan yejwan okiyejyekojtokaj, iwan okilwij in tlakatl katlej omawakke: ―Ximoketza iwan xiwiki nian tlatlajko. In tlakatl omoketzke tlatlajko. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ijkuakón Jesús okinmilwij in oksekimej: ―Namechtlajtlanis se tlajtole: ¿Tlanon techkawilia itlanawatil in Moisés ma se kichiwa nijkuak weyi tonale? ¿Ma se kichiwa tlan kuale o noso tlan amo kuale? ¿Ma tikmakixtikan se tlakatl itech inemilis, o noso ma tikmiktikan? ");
INSERT INTO nhyNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tonses Jesús okintlatak nochtin katlej okiyawalojtokaj, iwan okilwij in tlakatl: ―Xikmelawa moma. In tlakatl okimelaj ima, iwan opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero in tlamachtijkej de itlanawatil in Moisés iwan fariseos sa tekitl okualankej, iwan opéj kimolwiaj se iwan oksé tlanon welis kitoktiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Itech yonmej tonaltin Jesús oyáj ipan se tepetl omotiotzajtzilito, iwan nochi in se yuale omotiotzajtzilijtoka inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nijkuak otlaneske, okinnotzke imomachtijkawan, iwan okinpejpenke majtlaktle iwan ome de yonmej imomachtijkawan, katlej okintokaxtij tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ijkín intoka in tlatitlaniltin: Simón, katlej Jesús okitokayotij Pedro, Andrés ikni in Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO nhyNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo itelpoch in Alfeo, Simón katlej onemia inwan cananistas, ");
INSERT INTO nhyNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ikni in Jacobo, iwan Judas Iscariote, katlej satepan okitemaktij (okitemaktilij) in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús otemok de ipan tepetl iwan omoketzke se lugar kan tlalixtlawak iwan imomachtijkawan iwan miekej oksekimej tlakaj. Miekej tlakaj owalajkej de nochi in estado de Judea, de weyikan de Jerusalén iwan de región de weyikan de Tiro iwan de weyikan de Sidón katlej katej itempan atl. Owalajkej para kikakiskej in Jesús iwan para ma kinpajti de inkokolis. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Akinmej okipiayaj ejekamej mach kualtin iwan otlajyowiayaj por yon, noijki opajtikej. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nochtin in tlakaj okinekiaj kikitzkiskej in Jesús, porke Yej okinpajtiaya nochtin ika ipoder. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ijkuakón Jesús okintlatak imomachtijkawan iwan okinmilwij: ―Xipakikan namejwan katlej anpobrestin, porke namejwan ankipiaj parte kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Xipakikan namejwan katlej axan antiojsiwij, porke namejwan anmixwiskej. ’Xipakikan namejwan katlej axan anchokaj, porke satepan namejwan anpakiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Xipakikan namejwan nijkuak in tlakaj amechkokoliskej, nijkuak mach amechresibiroskej, nijkuak amechwikaltiskej, iwan nijkuak tlajtoskej biero de amejwan porke annechneltokaj Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sa tekitl xipakikan nijkuak ijkón anpanoskej, porke namejwan ankiresibiroskej se weyi tlaxtlawile ompa ilwikak. Porke in ya wejkawitl inweyitajwan no ijkón okintoktijkej in ya wejkawitl profetajtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Pero anpobrestin namejwan katlej ankimopialiaj, porke in pakilistle katlej axan ankipiaj tlamis nochi san ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Anpobrestin namejwan katlej axan anmixwitokej, porke satepan antiojsiwiskej. ’Anpobrestin namejwan katlej axan anwetzkaj, porke satepan namejwan anchokaskej de neyolkokole. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Anpobrestin namejwan nijkuak nochtin in tlakaj tlapoaskej kuale de amejwan, porke in ya wejkawitl namoweyitajwan noijki otlapoayaj kuale de yen profetajtin tekajkayajkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Pero namejwan katlej annechkakij namechilwia: Xikintlasojtlakan namokontraswan. Xikinchiwilikan tlan kuale akinmej amechkokoliaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xiktlajtlanilikan in Dios ma kintiochiwa akinmej amechwikaltiaj. Xiktlajtlanilikan in Dios ma kintiochiwa akinmej amechtoktiaj tlan amo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tla akaj mitzixtlatzinia ik se lado, xikkawili noijki ma mitzixtlatzini in oksé lado. Iwan tla akaj mitzkixtilia mokoton, xikkawili noijki ma kitki mokamisa. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tla akaj mitztlajtlanilis itlaj, xikmaka. Iwan akin mitzkixtilis itlaj tlan moaxka, ayakmo xiktlajtlanili. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xikinchiwilikan in oksekimej ijkón ken namejwan ankinekij ma amechchiwilikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tla namejwan ankintlasojtlaj san yen katlej amechtlasojtlaj, ¿kox kuale tlan ankichiwaj? Asta in tlajtlakolejkej no ijkón kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","O noso tla ankinchiwiliaj tlan kuale san yen akinmej amechchiwiliaj tlan kuale, ¿kox kuale tlan ankichiwaj? In tlajtlakolejkej no ijkón kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iwan tla ankintlanetiaj itlaj san yen akinmej ankiyejyekoaj ankiresibiroskej noijki itlaj de yejwan, ¿kox kuale tlan ankichiwaj? Porke noijki in tlajtlakolejkej kimotlatlanetiaj itlaj entre yejwan, iwan kichiaj noijki itlaj kiresibiroskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero namejwan moneki xikintlasojtlakan namokontraswan, iwan xikinchiwilikan tlan kuale iwan xikintlanetikan tlan kinekij iwan amo xikchiakan ma amechmakakan itlaj por ankintlanetiaj. Ijkón ankipiaskej miek amotlaxtlawil, iwan namejwan anyeskej antekonewan de Dios weyikistok (weyititok). Porke Yej sa tekitl yolyamanke iwan kinchiwilia tlan kuale in tlakaj katlej mach kimatij motlasojkamatij iwan katlej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Namejwan xiekan anteiknomatkej, ijkón ken namoPapan Dios Yej teiknomatke. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Amo xikinpojpoakan in oksekimej iwan nion amo xikintlajtlakoltikan para ijkón Dios noijki amo ma amechtlajtlakolti. Xitetlapojpolwikan, iwan Dios amechtlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xiktemakakan, iwan Dios amechmakas. Dios amechmakas miek, ken ijkuak se kitemaka se tlatamachiwale tentok de tliole, tijtilintok, kuale tetentok iwan tzontitok, porke Dios amechmakas ijkón ken namejwan ankitemakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús noijki okijtoj se ejemplo: ―¿Welis se tlakatl katlej mach tlachia kiyekanas oksé katlej noijki mach tlachia? ¿Amo san ken omen welis wetzitiwej ijtik se kuyoktle? ");
INSERT INTO nhyNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Se katlej momachtij mach kipanawilia katlej itlamachtij. Pero nijkuak tlamis momachtis, noijki yetos ken itlamachtij. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Kenik in tej weli tikistlakawia in mokni por yen tlajtlakole katlej kichiwa, iwan tej mach timota nik tikchijtok okachi weyi tlajtlakole? ");
INSERT INTO nhyNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿O noso kenik weli tikilwia in mokni: “Mach ok xitlajtlako”, iwan tej tikchijtok miek tlajtlakole? ¡Teixkajkayaj! Achtoj tej xikkawa in tlajtlakole katlej miek tikchijtok, iwan ijkón welis tikilwis in mokni mach ok ma tlajtlako maski mach miek tlajtlakole tlan kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Se tlatoktle kuale mach kitemaka itlakilo mach kuale, iwan se tlatoktle katlej mach kuale mach weli kitemaka itlakilo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Porke nochi kuawitl moixmati por yen itlakilo. Mach moteki igos itech nojpale, nion mach moteki uvas itech kuatlanwitztle. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Se kuale tlakatl kijta tlan kuale porke ipan iyolo onkaj tlan kuale, iwan se tlakatl katlej mach kuale kijta tlan amo kuale porke ipan iyolo onkaj tlan amo kuale. Porke ika iten kijta tlan onkaj ipan iyolo. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Tlanik namejwan annechnotzaj, “Señor, Señor”, iwan mach ankichiwaj tlan namechilwia? ");
INSERT INTO nhyNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Akin witz nonawak, iwan nechkakilia notlajtol iwan kichiwa tlan nikijta, yon ken se tlakatl ");
INSERT INTO nhyNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","katlej okichij ikal, pero achtoj otlakuyonij wejkatlan, iwan okitlalij in cimiento ipan tetl. Nijkuak oweyiyak in kiawalatl, in atl okimomagato chikawak in kale, pero mach okolinij porke okipiaya icimiento ipan tetl. ");
INSERT INTO nhyNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero akin nechkaki iwan amo kichiwa tlan nikijta, yon ken se tlakatl katlej okichij ikal ipan tlale, iwan mach kipia icimiento. Iwan nijkuak oweyiyak in kiawalatl iwan okimomagato chikawak in kale, owetzke iwan nochi oxitinke. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nijkuak Jesús otlanke okintlapowij in tlakaj, oyáj para pueblo de Capernaum. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ompa oyeka se kapitan romano katlej okipiaya se itekipanoj katlej okitlasojtlaya, iwan katlej omokokoaya iwan ya oixpolitoka. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nijkuak in kapitan okikakke otlapoayaj de Jesús, ijkuakón okintitlanke sekimej tlayekankej tetajtzitzintin judiojtin para ma kitlatlawtitij ma wiki ma kipajtiki itekipanoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yejwan omijkuanijkej inawak Jesús iwan opéj kitlatlawtiaj miek, okilwiayaj: ―Yin kapitan moneki xikpalewi, ");
INSERT INTO nhyNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","porke yej kintlasojtla in judiojtin, iwan yej inewian otlanawatij ma kichiwakan totiopan ika itomin. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tonses Jesús oyáj inwan. Pero nijkuak ya onajsiaj ichan kapitan, in kapitan okintitlanke sekimej iamigoswan para ma kilwikan in Jesús: ―Señor, amo xitlanemili, porke mach notech powi xikalaki nokalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Por yonik nion mach onimixewij oniaj onimitztemoto nonewian. San xikijto ma pajti notekipanoj iwan yej pajtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Porke nej noijki nimomatok nikintlakita notlayekankej. Iwan noijki nikinpia soldadojtin katlej nechtlakitaj. Iwan tla nikilwis se de yejwan: “Xiwia ne”, in yej yawi. Iwan tla nikilwis oksé: “Xiwiki”, in yej witz. Iwan tla nikilwis in notekipanoj: “Xikchiwa yin tekitl”, in yej kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nijkuak Jesús ijkón okikakke, sa omotlajtlachialtij (omomajmawtij). Ijkuakón omokuepke iwan okintlatak in tlakaj katlej oyayaj ikuitlapan iwan okijtoj: ―Ipan melajka namechilwia, ke mach nikajsi nion se judío katlej kipia weyi itlaneltokalis ken yin tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","In tlakaj katlej okintitlankaj omokuepkej ichan kapitan iwan okajsitajsikej itekipanoj in kapitan yopajtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Satepan de yon, Jesús oonewak ik se pueblo itoka Naín. Imomachtijkawan iwan miekej tlakaj noijki oyayaj iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nijkuak oajsitoj kalyakapan de yon pueblo, okitak yawij kitookatiwej se mikkatl. Yon mikkatl oyeka ikone se viuda katlej okipixke san yon se ikone. Miekej tlakaj de yon pueblo okiakompañaroayaj in viuda. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nijkuak in Señor okitak in viuda, okiknomatke iwan okilwij: ―Amo xichoka. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ijkuakón Jesús omijkuanij iwan okitlalij ima ipan kaja. Iwan katlej okikechpanoayaj in kaja omoketzkej. Iwan Jesús okilwij in mikkatl: ―Telpochtle, Nej nimitzilwia: ¡Ximoketza! ");
INSERT INTO nhyNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tonses katlej omikka, omotlalij iwan opéj tlapoa, iwan Jesús okimaktilij imaman. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nochtin omomawtijkej nijkuak ijkón okitakej, iwan opéj kiweyikixtiaj in toTajtzin Dios, okijtoayaj: ―Omonextij se weyi profeta tonawak. Noijki okijtoayaj: ―Dios owalaj para kinpalewis in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nochi in estado de Judea iwan nochtin pueblojtin katlej okiyawalojtokaj, okimatkej tlan Jesús okichij. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Imomachtijkawan in Juan Tlakuateekij okilwiayaj nochi tlan Jesús okichiwaya. Tonses in Juan okinnotzke omen imomachtijkawan, ");
INSERT INTO nhyNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","iwan okintitlanke inawak Jesús para ma kitlajtlaniitij kox melawak yen Cristo katlej kipia de witz, o noso ok moneki kichiaskej ma wiki. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Itlatitlanilwan in Juan omijkuanijkej inawak Jesús, iwan okitlajtlanijkej: ―In Juan Tlakuateekij otechwaltitlanke ma timitztlajtlaniikij kox yen tejwatzin tiCristo katlej kipia de witz, o noso ok moneki tikchiaskej ma wiki. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nijkuak imomachtijkawan in Juan oajsitoj inawak Jesús, Yej ijkuakón meroj okinpajtijtoka miekej tlakaj katlej okipiayaj tlatlamantle kokolistle, iwan okinkixtiaya ejekamej mach kualtin, iwan okintlachialtiaya katlej mach otlachiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ijkuakón Jesús okinnankilij: ―Xiwian iwan xikilwikan in Juan tlan namejwan ya ankitakej iwan ya ankikakej. Xikilwikan nik in tlakaj katlej mach otlachiayaj axan ya tlachiaj, in koxomej ya kuale nejnemij, katlej opalania innakayo axan ya chipawij de inkokolis, katlej mach otlakakiaj axan ya tlakakij, in mikkamej moyolkuij, iwan in pobrestin kikakij in kuale tlajtole katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ma paki akin amo kipolos itlaneltokalis nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nijkuak oyajkej katlej Juan okintitlanka, ijkuakón Jesús opéj kintlapowia in tlakaj de yen Juan Tlakuateekij: ―¿Tlan anyajkej ankitatoj ne kan tlawaki? ¿Ankitatoj se tlakatl katlej itlaneltokalis kiitki in ejekatl no ken ijkuak in ejekatl kiitki se akatl? ");
INSERT INTO nhyNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Akin kiné ankitatoj? ¿Ankitatoj se tlakatl katlej omotlakentiaya ika kuale itzotzol? Namejwan kuale ankimatij ke katlej kuale motlakentiaj katej ichan reytin. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Tonses, ¿tlan ankiskej ankitatoj? ¿Se profeta? Melawak, yej okachi kipanawilia ke se profeta. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","In tiotlajkuilole tlapoa de yen Juan kan kijta: Nej niktitlani notlatematiltij moyakapan, ma mitzyektlalili in ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Iwan namechilwia, ke entre nochtin in tlakaj mach akaj onkaj katlej okachi ma kipanawili in Juan Tlakuateekij. Pero se tlaneltokak katlej okachi tzikitzin de kan Dios tlanawatia yen yon okachi weyi ke Juan. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nochtin in tlakaj iwan asta katlej tlakobraroaj ika impuestos nijkuak okikakej tlan okintlapowij in Juan, omotemakakej ma kinkuateeki, porke okineltokakej iwan okitakej nik sa tekitl kuale itlajtol in toTajtzin Dios katlej Juan okinmachtiaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero in fariseos iwan in tlamachtijkej de itlanawatil in Moisés mach okineltokakej, mach okinekej ma kinkuateeki in Juan, iwan ijkón yejwan mach okinekej tlan Dios okinekia para yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iwan toSeñor Jesús okijtoj: ―¿Tlan ika welis nikinkompararos in tlakaj de yin tiempo? ");
INSERT INTO nhyNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yejwan ken telpokamej katlej motlaliaj mawiltiaj itech tiankistle iwan kintzajtziliaj inmamigoswan, kinmilwiaj: “Mach ijki nik anmawiltiaj. Tejwan otamechtlapichilijkej para ximijtotikan, pero mach anmijtotijkej. Otamechtlakuikilijkej se tlakuikale teyolkokoj, pero mach ankinekej anchokakej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porke, owalaj in Juan katlej mach otlakuaya porke omosawaya (oayunaroaya) iwan mach okonia vino, iwan namejwan ankijtaj ke kipia se ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Satepan, oniwalaj Nej katlej onimochij nitlakatl, iwan nitlakua iwan nikoni. Iwan namejwan ankijtaj wel nitlakuani iwan nitlawanke, iwan ankijtaj inwan nimowika in tlajtlakolejkej iwan katlej tlakobraroaj ika impuestos. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero in ixtlamachilistle de Dios mota por tlan se kichiwa ika Dios iixtlamachilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Se fariseo okinbitaroj in Jesús ma tlakuati ichan. Jesús oyáj ichan fariseo iwan omotlalij itech mesa. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ijkuakón se siwatl momekatij de yon pueblo, nijkuak okimatke nik in Jesús oyáj otlakuato ichan fariseo, ijkuakón yej ompa oajsito okitkia se boteyajtzin de alabastro tentok de ajwiakayotl. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Omotlalij ikxitlan Jesús chokatok iwan opéj kikxipaka ika ixayo. Satepan opéj kikxiwajwatza ika itzonkal, okikxipipitzoj iwan okiteekilij ajwiakayotl ipan ikxiwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nijkuak ijkón okitak in fariseo katlej okinbitaroj in Jesús, okiyejyekoj: “Tla yin tlakatl melawak yeskia profeta, kimomakani kuenta akin kikikitzkijtok iwan tlan itekiw in siwatl, porke yin siwatl tlajtlakolej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ijkuakón Jesús okilwij in fariseo: ―Simón, nikneki nimitzilwis se tlajtole. In fariseo okinankilij: ―Xinechilwi, Tlamachtij. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús okijtoj: ―Omen tlakaj okiwikiliayaj tomin se katlej tetomintlanetij. Se okiwikiliaya makuile siento denariojtomin, iwan oksé okiwikiliaya omenpoale iwan majtlaktle denariojtomin. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iwan komo mach oweliaj okikuepiliayaj, in tetomintlanetij okintlapojpolwij san ken omen. Axan xinechilwi, ¿akin okachi okipialij tlasojtlalistle de yonmej omen? ");
INSERT INTO nhyNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón okinankilij: ―Nej nikijta yen katlej okachi okitlapojpolwij de tlan okiwikiliaya. Jesús okilwij: ―Melawak tlan tikijta. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tonses Jesús okitlatak in siwatl, iwan okilwij in Simón: ―¿Tikita yin siwatl? Onikalakke mokalijtik, iwan mach otinechmakak atl para nokxiwan. Pero yin siwatl onechikxipakke ika ixayo, iwan onechikxiwajwatzke ika itzonkal. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tej mach otinechixpipitzoj, pero yej nechikxipipitzojtok desde onikalakke. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Tej mach otinechtlalilij aseite ipan notzontekon, pero yej onechteekilij ajwiakayotl ipan nokxiwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Por yonik nimitzilwia, yin siwatl mota nik okichij miek tlajtlakole iwan axan Nej yoniktlapojpolwij de nochi itlajtlakol porke nikita nik sa tekitl nechtlasojtla. Nijkuak se tlakatl kimachilia mach okachi moneki ma kitlapojpolwikan, tonses noijki san achitzin motlasojkamatis nijkuak kitlapojpolwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ijkuakón okilwij in siwatl: ―Nimitztlapojpolwia de nochi motlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iwan inbitadostin katlej ompa oewatokaj iwan Jesús, opéj kimolwiaj entre yejwan: ―¿Akin yin tlakatl? ¿Tlanik mixewia tetlapojpolwia itech tlajtlakole? ");
INSERT INTO nhyNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús okilwij in siwatl: ―Motlaneltokalis yomitzmakixtij. Xiwia ika kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Satepan de yon, Jesús onemia itech miekej weyikantin iwan itech miekej pueblojtin, okitematiltijtinemia iwan otetlapowijtinemia de yen kuale tlajtole katlej temakixtia de kenik Dios tlanawatia. In majtlaktle iwan omen imomachtijkawan oyayaj iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Noijki Iwan oyayaj sekimej siwamej katlej okinpajtij de mach kualtin ejekamej iwan de tlatlamantle kokolistle. Sekimej de yejwan katlej oyayaj iwan Jesús itoka María katlej noijki kinotzaj Magdalena katlej de pueblo de Magdala. Itech yon María okiskej chikomen ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Noijki oyaya in Juana, isiwa in Chuza, yon tlakatl Chuza yej okitaya nochi tlan iaxka in rey Herodes. Noijki oyaya in Susana, iwan miekej oksekimej siwamej katlej okipalewiayaj in Jesús ika tlan okipiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miekej okiskej de inpueblo para kitaskej in Jesús. Iwan nijkuak omololojkej miekej tlakaj, ijkuakón okintlapowij ika se ejemplo. Okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Se tlakatl oyáj otookato. Nijkuak otookatoka, sekin semiya owetzke ipan ojtle. In tlakaj ipan otlajtlaksakej, iwan totomej okikuajkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Oksekin semiya owetzke ijtik teyoj. Iwan nijkuak yon semiya okiske, niman owakke porke okipoloaya kuechawalotl. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Oksekin semiya owetzke itzalko xiwitl witzoj, iwan in xiwitl witzoj okixiwmiktij in semiya katlej okiske. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Iwan oksekin semiya owetzke kan kuale tlale. Iwan nijkuak okiske, omoskaltij iwan okipixke kuale itlakilo, iwan kada se semiya okitemakak asta se siento itliolo. Nijkuak Jesús otlanke ijkón okijtoj, ijkuakón okinmilwij chikawak: ―Tla ankinekij ankimomakaskej kuenta, xikkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Imomachtijkawan okitlajtlanijkej tlan kijtosneki yon ejemplo. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Iwan Jesús okinmilwij: ―Namejwan Dios yoamechkawilij xikmatikan tlan oyeka tlatitok de kenik Dios tlanawatia. Pero oksekimej se kinmachtia ika ejemplos, para ijkón, maski ma kitakan tlan nikchiwa, mach ma kimomakakan kuenta tlan kitaj. Iwan maski ma kikakikan notlajtol, mach ma kimatikan tlan kikakij. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’In ejemplo katlej yonamechilwij kijtosneki yen yin: In semiya yon kej yeskia itlajtol in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","In semiya katlej owetzke ipan ojtle yon ken akinmej kikakij itlajtol in Dios, pero witz in diablo iwan kinkixtilia in tlajtole katlej omotookak ipan inyolo, para amo ma kineltokakan iwan amo ma momakixtikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","In semiya katlej owetzke ijtik teyoj, yon ken akinmej kikakij itlajtol in Dios iwan kiresibiroaj ika pakilistle, pero mach wejkatlan monelwayotiaj. Kineltokaj san kanaj keski tonale, pero nijkuak pewa tlajyowiaj ijkuakón mosotlawaj iwan kikawaj in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","In semiya katlej owetzke itzalko in xiwitl witzoj, yon ken akinmej kikakij itlajtol in Dios pero mach welij tlakij porke sa tekitl tlanemiliaj de kenik mopanoltiskej, iwan kenik morikojtiliskej iwan kenik mopaktiskej itech innemilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero in semiya katlej owetzke kan kuale tlale, yon ken akinmej ika kuale inyolo melawak kikakij itlajtol in Dios iwan nochipa kichiwaj tlan kijta itlajtol. Yonmej melawak kitemakaj kuale intlakilo. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Mach akaj kitlikuitia se tlanextle para satepan kixtzakuas ika itlaj o noso kitlalis itlampa se kuawtlapechtle, sino motlalia ajkopan, para ma kintlawili nochtin akinmej kalakiskej kalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Porke nochi katlej amo momati kipia por momatis, iwan nochi katlej kajki tlatitok kipia por nesis iwan motas. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Ijkón kiné, kuale xikkakikan. Porke akin kinekis moskaltis okachi itech itlajtol in Dios, moskaltis okachi. Iwan katlej amo kinekis, kipolos asta tlan ya kimati. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Satepan imaman iwan ikniwan Jesús oejkokej kan Yej oyeka, pero mach owelikej oasitoj asta inawak porke oyekaj miekej tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iwan se tlakatl okilwij in Jesús: ―Momaman iwan mokniwan katej kalan iwan kinekij mitzitaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero Jesús okinmilwij: ―In tlakaj katlej kikakij itlajtol in Dios iwan kichiwaj tlan kijta, kijtosneki yejwan nomaman iwan yejwan nokniwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Se tonale Jesús otlejkok itech se barko iwan imomachtijkawan, iwan okinmilwij: ―Ma tipanokan oksé lado de yin atl. Iwan oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iwan nijkuak opanotiayaj, Jesús okochke. Ijkuakón owalaj se ejekatl chikawak iwan atl opéj motlamotla ipan barko iwan opéj atemi asta ya meroj apolakini. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ijkuakón okijxitijkej in Jesús, iwan okilwijkej: ―¡Tlamachtij! ¡Tlamachtij! ¡Tiapolakij! Jesús omoketzke iwan okajwak in ejekatl iwan atl katlej omotlatlamotlaya. Ijkuakón omoketzke in ejekatl iwan atl iwan nochi omokaj sa tlamantok. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ijkuakón Jesús okinmilwij imomachtijkawan: ―¿Kanin kajki namotlaneltokalis? Yejwan sa tekitl omomawtijkej iwan sa otlajtlachixkej (omomajmawtijkej), iwan omotlajtlaniayaj se iwan oksé: ―¿Akin yin tlakatl? ¿Kenik weli kinnawatia in ejekatl iwan atl iwan kitlakitaj? ");
INSERT INTO nhyNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Satepan oejkokej ipan intlal in gadarenostlakaj, katlej kajki oksé lado de yen atl iwan kixnamiktok in estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nijkuak Jesús otemok de itech barko, ijkuakón se tlakatl de yon pueblo omijkuanij inawak Jesús. Yon tlakatl ya wejkawitl okinpiaya ejekamej mach kualtin. Mach omotzotzoltiaya iwan nion mach ochantia itech se kale, sino ochantia ijtik mikkakuyoktin. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nijkuak in tlakatl okitak in Jesús, otzajtzik chikawak iwan omotlankuaketzke ikxitlan, iwan okijtoj chikawak: ―¿Tlan tikneki nowan, Jesús, teKone de Dios Weyikistok (Weyititok)? Nimitztlatlawtia amo xinechtitlani ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ijkón okijtoj porke Jesús okinawatijtoka in mach kuale ejekatl ma kisa de ijtik in tlakatl. Ya wejkawitl in ejekatl mach kuale yokimoaxkatijka in tlakatl. Iwan miek buelta okijilpiayaj ika kadena itech imawan iwan itech ikxiwan. Pero yej okinkojkotonaya in kadenajtin, iwan in mach kuale ejekatl okitoktiaya ma wia kan tlawaki. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús okitlajtlanij: ―¿Tlan motoka? Iwan yej okinankilij: ―Nej nikpia miek notoka. Ijkón okijtoj porke oyekaj sa tekitl miekej ejekamej mach kualtin katlej okalakej ijtik in tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iwan in ejekamej mach kualtin okitlatlawtijkej in Jesús amo ma kintitlani ijtik in kuyoktle weyi katlej mach kipia kan ontlami. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Komo oyekaj miekej pitzomej otlakuajtokaj ipan tepetl, in mach kualtin ejekamej okitlatlawtijkej in Jesús ma kinkawili ma kalakikan inmijtik in pitzomej. Jesús okinkawilij kiné. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ijkuakón in ejekamej mach kualtin okiskej de ijtik in tlakatl iwan okalakej inmijtik in pitzomej, iwan pitzomej nochtin okikistewakej iwan omotepejxiwitoj ixkuak se tepejxitl iwan owetzkej asta ijtik atl, nochtin omoatlanwijkej iwan omikkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","In tlajpixkej de yonmej pitzomej, nijkuak okitakej tlan otlamochij, omotlalojkej oyajkej okitematiltitoj itech pueblo iwan ik tetlalaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","In tlakaj oyajkej okitatoj tlan otlamochij. Nijkuak oajsitoj kan oyeka in Jesús, okajsitajsikej in tlakatl katlej ijtik okiskej in ejekamej mach kualtin, ewatok ikxitlan Jesús. Ya tzotzolejtok iwan ya ika kuale itlalnamikilis. Iwan omomajmawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Akinmej okitakej tlan otlamochij, otetlapowijkej kenik opajtik in tlakatl katlej ijtik okiskej in ejekamej mach kualtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tonses nochtin in tlakaj de yon región de Gadara opéj kitlatlawtiaj in Jesús ma wia de ompa, porke sa tekitl omomawtiayaj. Ijkuakón kiné, Jesús otlejkok itech barko iwan oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","In tlakatl katlej ijtik okiskej in ejekamej mach kualtin, okitlatlawtij in Jesús ma kikawili ma wia Iwan, pero Jesús okinawatij ma mokawa. Okilwij: ");
INSERT INTO nhyNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ximokuepa mochan, iwan xitetlapowi de nochi in wejweyin tlamantin tlan Dios okichij por tej. In tlakatl oyáj, iwan otetlapowij itech nochi in pueblo de nochi tlan Jesús okichij por yej. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nijkuak Jesús omokuepke oksé lado de yen lago, in tlakaj okiresibirojkej ika pakilistle. Porke nochtin okichixtokaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ijkuakón owalaj se tlakatl itoka Jairo, katlej oyeka tlayekanke de itech se tiopan de yen judiojtin. Yon tlakatl omotlankuaketzke ikxitlan Jesús iwan okitlatlawtij ma wia ichan, ");
INSERT INTO nhyNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","porke okipiaya san se itakkoj de majtlaktle iwan ome xiwitl, katlej yomiktoka. Nijkuak Jesús yoyaya ichan Jairo, miekej tlakaj no Iwan oyayaj iwan asta sa okipajpatzmiktiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ompa intzalko oyaya se siwatl katlej okipiaya majtlaktle iwan ome xiwitl de oestlapowik, iwan yokitlamij nochi itomin innawak in tepajtijkej, iwan mach akaj owelia okipajtiaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yon siwatl omijkuanij ikuitlapan Jesús iwan okitempankitzkilij itzotzol, iwan san niman ijkuakón omoketzke iestlapowilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ijkuakón Jesús okijtoj: ―¿Akin okitzkij notlaken? Nochtin okijtoayaj nik in yejwan mach okikitzkilijkej, ijkuakón Pedro iwan ikompañeroswan okijtojkej: ―Tlamachtij, in tlakaj mitzpajpatzmiktiaj iwan mitztojtopewaj, ¿tlanik ok titlajtlani akin okitzkij motlaken? ");
INSERT INTO nhyNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús okijtoj: ―Akaj onechtlakenkitzkij. Porke onikmachilij notech okiske poder iwan nikmati nik akaj opajtik ika nopoder. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nijkuak in siwatl okimomakak kuenta nik mach welis kitlaatis de kenik opajtik, owalaj papatlakatiwitz (bibiokatiwitz) iwan omotlankuaketzke ikxitlan Jesús. Okimokuitij nochi inmixpan nochtin tlakaj por tlanik okitzotzolkitzkij, iwan kenik opajtitiwetzke san niman nijkuak okitzotzolkitzkij. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ijkuakón Jesús okilwij in siwatl: ―Nokone, yotipajtik porke otinechneltokak. Xiwia ika kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Nijkuak in Jesús ok okitlapowijtoka in siwatl, ijkuakón oejkok se tlakatl katlej owalaj de ichan Jairo, yon Jairo yen katlej tlayekanke de tiopan, iwan yon tlakatl okilwij in Jairo: ―Motakkoj yomikke. Ayakmo xiktekimaka in Tlamachtij. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero nijkuak Jesús okikakke, okilwij: ―Amo ximomawti. Tej san xitlaneltokato, iwan motakkoj pajtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nijkuak Jesús oajsito ichan Jairo, Jesús mach akaj okawilij ma kalaki Iwan, san yen Pedro, Jacobo, Juan iwan tetajmej de yen takkoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nochtin okichokilijtokaj iwan omoyolkokojtokaj. Pero Jesús okinmilwij: ―Amo xichokakan. In takkoj ayamo miki, sino yej san kochi. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Yejwan san okiwewetzkilijkej, porke okimatiaj nik yomikke. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tonses in Jesús okimakitzkij in takkoj iwan okilwij chikawak: ―Takkoj, ximewa. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","San niman ianima omokuepke oksemi itech inemilis iwan owalmejtewak. Jesús okinnawatij ma kitlamakakan in takkoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","In tetajmej de yon takkoj sa otlajtlachixkej (omomajmawtijkej). Pero Jesús okinnawatij amakaj itlaj ma kilwikan de tlan otlamochij. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús okinmololoj in majtlaktle iwan omen imomachtijkawan iwan okinmakak poder iwan tlanawatijkayotl para kinkixtiskej nochi tlamantle de ejekamej mach kualtin, iwan para tepajtiskej de nochi kokolistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Okintitlanke ma kitematiltitij de kenik Dios tlanawatia, iwan ma kinpajtikan in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iwan okinmilwij: ―Amitlaj xikitkikan nijkuak anyaskej ipan ojtle, nion karrotij, nion bolsa, nion pan, nion tomin, iwan nimpor amo xikitkikan ome namotzotzol. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","San katlij yej kalijtik kan anmajsiskej, ompa ximokawakan asta ijkuak ankisaskej de itech yon pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iwan kan amo kinekiskej anmechresibiroskej, xikisakan de itech yon pueblo iwan ximokxitlaltzejtzelokan, para ma kimomakakan kuenta nik mach kuale tlan yejwan kichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yejwan, kiné, oyajkej itech nochtin pueblojtzitzintin, okitematiltijtiajkej in kuale tlajtole katlej temakixtia iwan okinpajtijtiajkej in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","In gobernador o noso rey Herodes okimatke nochi tlan Jesús okichiwaya, iwan mach ok okimatia tlan kichiwas, porke sekimej okijtoayaj ke Juan Tlakuateekij yomoyolkuik oksemi satepan de omikke. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Oksekimej okijtoayaj yen profeta Elías yomonextij. Iwan oksekimej okijtoayaj yon se katlej ya wejkawitl profeta yomoyolkuik. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes okijtoj: ―Nej nonewian onitlanawatij ma kikechtzontekikan in Juan. ¿Akin yin, kiné, wel nikkaki motlapowiaj de yej? Iwan Herodes okitemoaya kenik welis kitas in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nijkuak in tlatitlaniltin omokuepatoj, okimatiltijkej in Jesús nochi tlan okichijkej. Satepan okinwikak iwan oyajkej san yejwan inselti ik se lugar kan tlalkawale kan mach akaj tlakatl nemi, iwan mach wejka de pueblo de Betsaida. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero nijkuak in tlakaj okimatkej, oyajkej okajsitoj. Jesús okinresibiroj iwan okintlapowij de kenik Dios tlanawatia iwan okinpajtij in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nijkuak otiotlakik, in majtlaktle iwan omen imomachtijkawan omijkuanijkej inawak Jesús iwan okilwijkej: ―Xikintitlani in tlakaj para ma mosewitij iwan ma kitemotij tlan kikuaskej. Ma wian ik pueblojtzitzintin iwan ik rancherías katlej katej serka, porke nian kan tikatej mach itlaj onkaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús okinmilwij: ―Namejwan xikintlamakakan. Yejwan okilwijkej: ―Mach tikpiaj tlanon tikinmakaskej, sanwel tikpiaj makuile pan iwan ome michimej. ¿O noso tikneki ma tiwian ma tikkowatij sekin tlakuale para nochtin? ");
INSERT INTO nhyNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Oyekaj kej makuile mil tlakaj. Ijkuakón Jesús okinmilwij imomachtijkawan: ―Xikinnawatikan ma motlalikan por grupojtin de ojomen poale iwan majtlaktle. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ijkón okichijkej iwan nochtin omotlalijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ijkuakón Jesús okintilanke in makuile pan iwan ome michimej. Oajkopantlachixke, omotlasojkamatke inawak Dios por yon pan iwan michimej, iwan satepan de okinkojkotonke, okinmakak imomachtijkawan para ma kinxejxelilikan in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nochtin kuale otlakuajkej asta oixwikej. Satepan okintemitijkej majtlaktle iwan ome chikimej de pedasos katlej osobraroj. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se tonale nijkuak Jesús omotiotzajtzilijtoka iselti iwan noijki ompa Iwan oyekaj imomachtijkawan, okintlajtlanij: ―¿Ken kijta in tlakaj? ¿Akin Nej? ");
INSERT INTO nhyNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yejwan okinankilijkej: ―Sekimej kijtaj tejwatzin tiJuan Tlakuateekij. Oksekimej kijtaj tejwatzin tiElías, iwan sekimej kijtaj tejwatzin tiprofeta katlej ya wejkawitl otimikke iwan axan yotimoyolkuik. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Tonses Jesús okintlajtlanij: ―Iwan namejwan, ¿ken ankijtaj? ¿Akin Nej? Iwan Pedro okilwij: ―Tejwatzin tiCristo katlej Dios omitzwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús kuale okinnawatij amakaj itlaj ma kilwikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iwan okinmilwij: ―Nej katlej onimochij nitlakatl sa tekitl nitlajyowis miek. In tlayekankej tetajtzitzintin, in tlayekankej tiopixkej, iwan tlamachtijkej de itlanawatil in Moisés mach nechnekiskej iwan nechmiktiskej. Pero ipan eyi tonale nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iwan okinmilwij nochtin: ―Tla akaj kineki witz nonawak, ma wiki kiné, pero moneki ayakmo ma kichiwa san tlan yej kinekis. Sino kipia de kixikos nochipa nochi san tlan panos iwan ma wiki nowan maski ma kimiktikan itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Porke akin kinekis kimakixtis inemilis, kipolos, pero akin kipolos inemilis por Nej, kimakixtis inemilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Porke mach itlaj ipatij tla se tlakatl kimoaxkatis nochi tlan onkaj ixko yin tlaltikpak, iwan satepan ianima yas ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tla se tlakatl pinawas de Nej iwan de notlajtol, Nej noijki akin onimochij nitlakatl nipinawas de yon tlakatl nijkuak niwitz ika nomawisotlanex, iwan ika imawisotlanex in noPapan iwan angelestin yolchipawakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pero ipan melajka namechilwia, sekimej katlej nian katej, mach kixmatiskej in mikilistle asta amo ma kitakan kenik in Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Satepan de opanok kanaj chikueyi tonale de ijkuak okijtoj in yon tlamantle, Jesús otlejkok ipan se tepetl omotiotzajtzilito, okinwikak in Pedro, Jacobo iwan Juan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nijkuak Jesús omotiotzajtzilijtoka, ixko omopatlak, iwan noijki omopatlak itzotzol iwan sa tekitl oistayak iwan opetlanke. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ijkuakón omonextijkej omen tlakaj omotlapowijtokaj iwan Jesús. Yen Moisés iwan Elías. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Omonextijkej kinyawalojtok imawisotlanex in Dios petlantok sa tekitl, omotlapowijtokaj iwan Jesús de kenik tlajyowis iwan kenik ixpoliwis itech weyikan de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Maski in Pedro iwan ikompañeroswan sa tekitl okochisnekiaj, omokajkej ijsatokej, iwan okitakej imawisotlanex in Jesús iwan ok omen tlakaj katlej Iwan oyekaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nijkuak nekatej tlakaj okajtejtiayaj in Jesús, ijkuakón Pedro okilwij: ―Tlamachtij, sa kuale nian tikatej. Ma tikinchiwakan eyi akawalkaltin, se para tejwatzin, se para Moisés iwan se para Elías. Pero Pedro mach okimatia tlan okijtoaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Iwan mientras Pedro ijkón okijtojtoka, ijkuakón owalaj se mixtle iwan okinkenke, iwan nijkuak yoyekaj ijtik in mixtle, omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ijkuakón omokakke se tlajtole de ijtik mixtle. Ijkín omokakke okijtoj: ―Yin yen notlasojKone, xikkakilikan itlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nijkuak otlanke omokakke yon tlajtole, ijkuakón okitakej in Jesús sa iselti. Yejwan mach ok itlaj okijtojkej, iwan itech nekatej tonaltin mach akaj itlaj okilwijkej de tlan okitakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Owalmostlatik, nijkuak otemokej de ipan tepetl, miekej tlakaj okinamikitoj in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ijkuakón se tlakatl katlej oyaya intzalko in tlakaj, okijtoj chikawak: ―Tlamachtij, nimitztlatlawtia xinechitili nokone, porke san yen se nikpia. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Se ejekatl mach kuale kikitzkia iwan kitzajtzitia iwan kitoktia ma mimiki iwan ma kamaposoni. Kikojkokoa iwan mach kineki kikajkawas. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Onikintlatlawtij momomachtijkawan ma kikixtilikan in ejekatl mach kuale, pero mach owelikej. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús okinankilij: ―¡Namejwan mach antlaneltokakej iwan ankiyejyekoaj tlan mach kuale! ¿Asta keman nietos amowan? ¿Asta keman ijkón namechxikojtos? Nian xinechwalwikili mokone. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Pero nijkuak in telpochtle yomijkuanijtiaya inawak Jesús, in ejekatl mach kuale okitlalwitekke iwan okitoktij ma mimiki. Pero Jesús okajwak in ejekatl mach kuale, iwan okipajtij in telpochtle iwan okimaktilij ipapan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nochtin sa otlajtlachixkej (omomajmawtijkej) de yen ipoder in toTajtzin Dios. Mientras nochtin sa otlajtlachiayaj de tlan Jesús okichiwaya, Jesús okinmilwij imomachtijkawan: ");
INSERT INTO nhyNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Kuale xikkakikan yin tlan namechilwis iwan amo xikelkawakan: Nej katlej onimochij nitlakatl nechtemaktiskej (nechtemaktiliskej) inmak in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero imomachtijkawan mach okimomakayaj kuenta tlan okinmilwiaya, porke Dios ayamo okinkawiliaya ma kimomakakan kuenta. Iwan okimakasiaj de kitlajtlaniiskej tlan kijtosneki. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Satepan imomachtijkawan opéj motlatlajtolkuepaj de akin okachi weyikistok (weyititok) de entre yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero Jesús okimomakak kuenta de tlan yejwan okiyejyekoayaj. Ijkuakón okitilanke se chokotzin, iwan okitlalij inakastlan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Iwan okinmilwij: ―Akin kiresibiros se chokotzin ken yin ika notoka, kijtosneki Nej nechresibiroa. Iwan akin Nej nechresibiroa, noijki kiresibiroa akin onechwaltitlanke. Porke akin kintekichiwilis in oksekimej, yen yon okachi weyikistos. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ijkuakón Juan okilwij: ―Tlamachtij, otiktakej se tlakatl kinkixtia ejekamej mach kualtin ika motoka. Iwan tejwan otikilwijkej ayakmo ijkón ma kichiwa, porke mach towan nemi. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús okilwij: ―Xikkawilikan ma kichiwa, porke akin amo kajki kontra tejwan, towan kajki. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nijkuak yoajsia in tonale para Jesús tlejkos ilwikak, opéj nejnemi ika yolchikawalistle para Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Okintitlanke sekimej itlatitlanilwan ma tlayekanakan ma wian itech se pueblo de estado de Samaria, para ma kitemolitij kan motepialtis (mokalotis). ");
INSERT INTO nhyNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero in tlakaj samaritanojtin katlej ochantiaj itech yon pueblo mach okinekej okiresibirojkej porke okitakej nik in Yej yawi para Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nijkuak imomachtijkawan Jacobo iwan Juan ijkón okitakej, okilwijkej in Jesús: ―Señor, ¿tikneki ma titlanawatikan ma wetzi tlitl de ilwikak para ma kinmixpolo nochtin, ijkón ken okichij in profeta Elías? ");
INSERT INTO nhyNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ijkuakón Jesús okintlatak iwan okinmajwak, okinmilwij: ―Namejwan mach ankimatij akin namechtoktia para xikualanikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Porke Nej katlej onimochij nitlakatl mach oniwalaj onikinmixpoliliko inmanima in tlakaj, sino oniwalaj para nikinmakixtis. Satepan oyajkej para oksé pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nijkuak oyayaj ipan ojtle, ijkuakón se tlakatl okilwij in Jesús: ―Señor, nikneki nimitzwikas san kanik tias. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús okinankilij: ―In ostomej (astomej) kipiaj inkuyok, in totomej kipiaj intepajsol. Pero Nej katlej onimochij nitlakatl mach nikpia nion kan nimosewis. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús okilwij oksé tlakatl: ―Xiwiki nowan. Pero yej okilwij: ―Señor, xinechkawili achtoj ma niktookati nopapan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús okinankilij: ―Xikinkawili katlej amo nechneltokaj yejwan ma kintookakan inmikkawan. Pero tej, xiwia iwan xiktematilti de kenik in Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Iwan oksé tlakatl noijki okilwij in Jesús: ―Señor, nikneki nimitzwikas, pero achtoj xinechkawili ma nikinyolopachoti katlej katej nochan. ");
INSERT INTO nhyNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Jesús okilwij: ―Akin nemi itech iojwi in Dios iwan satepan kinekis mokuepas kan achtoj oyeka, yon ken se tlakatl katlej kitzkijtiw in arado nijkuak tlaxawa iwan tlachia ik ikuitlapan. Yon tlakatl mach serbiros kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Satepan de yin, in Señor Jesús okinpejpenke eyinpoale iwan majtlaktle imomachtijkawan, iwan okintitlanke ojomen itech nochtin pueblojtin iwan itech nochtin lugartin kan satepan Yej yas. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Okinmilwij: ―Sa tlalwis miekej tlakaj katej kej se pixkale sa tekitl weyi, pero tejwan katlej tipixkakej mach timiekej. Por yonik, xiktlajtlanilikan in Dios katlej iteko in yon pixkale ma kualintitlani oksekimej tekipanojkej para ma pixkakij. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xiwian. Nej namechtitlani kej amichkamej kan katej koyomej. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xikitkikan bolsa, nion tomin, nion kakmej. Iwan nion amo ximoketzakan ipan ojtle para akaj xiktlajpalokan. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nijkuak ankalakiskej itech se kalijtik, achtoj xitetlajpalokan, xikijtokan: “Ximoyolosewikan aminochtin namejwan katlej nian ankatej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tla akaj katlej ompa chanti kuale amechresibiroa, Dios kitiochiwas ika yolosewilistle. Pero tla amo amechresibiroa, Dios mach kimakas yolosewilistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ompa ximokawakan itech yon kale, iwan xikkuakan iwan xikonikan tlan yejwan amechmakaskej. Porke se tekipanoj moneki kimakaskej itlaxtlawil. Amo san nian nepa ximotepialtijtinemikan (ximokalotijtinemikan). ");
INSERT INTO nhyNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nijkuak anmajsiskej itech se pueblo kan amechresibiroskej, xikkuakan tlan amechmakaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xikinpajtikan in kokoxkej katlej ompa yeskej, iwan xikinmilwikan: “Yoajsiko in tonale para Dios tlanawatis amonawak.” ");
INSERT INTO nhyNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero tla anmajsiskej itech se pueblo kan amo amechresibiroskej, xikisakan ipan ojtle iwan xikijtokan: ");
INSERT INTO nhyNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Asta yen tlale de amopueblo katlej otechajsik ipan tokxi, tiktzejtzeloaj para xikmatikan nik mach kuale tlan ankichiwaj. Pero xikmatikan, nik in Dios ya meroj amechnawatis.” ");
INSERT INTO nhyNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nej namechilwia, ke itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), intlajyowilis in yonmej tlakaj yetos okachi weyi ke para nekatej tlakaj de Sodoma. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Pobre de tej, pueblo de Corazín! ¡Pobre de tej, pueblo de Betsaida! Porke tla itech pueblo de Tiro iwan itech pueblo de Sidón kitanij in milagrostin katlej amejwan ankitaj, ya ke tiempo yeskia yomoyolkuepkej. Iwan motzotzoltianij de luto iwan motlikonexwianij, para kiteititianij nik yomoyolkuepkej de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), namejwan ankipiaskej okachi weyi tlajyowilistle ke in tlakaj de pueblo de Tiro iwan de Sidón. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwan namejwan de pueblo de Capernaum, ¿ankiyejyekoaj ke antlejkoskej asta ilwikak? Namejwan anyaskej asta ijtik tliko. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Akin amechkaki namejwan, kijtosneki yen Nej nechkaki. Iwan akin amo amechresibiroa, kijtosneki yen Nej mach nechresibiroa. Iwan akin Nej mach nechresibiroa, kijtosneki noijki mach kiresibiroa akin onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","In eyinpoale iwan majtlaktin imomachtijkawan omokuepatoj ika pakilistle, iwan okilwijkej in Jesús: ―Señor, asta in ejekamej mach kualtin otechtlakitakej nijkuak otikinkixtijkej ika motoka. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús okinmilwij: ―Aján, Nej onikitak in Satanás kenik owetzke de ilwikak kej se tlapetlanalistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nej onamechmakak poder para inpan antlajtlaksaskej in koamej iwan kolomej, iwan para ankitlaniskej nochi ipoder in Amo Kuale Tlakatl, iwan mach itlaj anmochiwaskej tlan mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero amo xipakikan porke amechtlakitaj in ejekamej mach kualtin, sino xipakikan porke namotoka ya kajki ijkuilitok ompa ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Itech yon ora in Espíritu Santo okimakak in Jesús miek pakilistle, iwan Jesús okijtoj: ―Papan, nimitzonweyikixtia tejwatzin tiiTeko in ilwikak iwan tlaltikpak. Nimitzonweyikixtia porke otikintlaatilij in tlamantin para amo ma kimatikan in tlakaj katlej momachiliaj wel kimatij iwan momachiliaj wel kuale intzontekon, iwan otikinnextilij in tlakaj katlej mach moweyinekij. Ijkón otikchij, Papan, porke ijkón otikmonekiltij. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’NoPapan onechmaktilij nochi tlamantle. Nej niiKone mach akaj kimati akin Nej, sino san yen noPapan kimati akin Nej. Iwan mach akaj kimati akin noPapan, sino san Nej niiKone nikmati akin Yej iwan noijki nekatej tlakaj akinmej Nej nikneki ma kimatikan akin noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ijkuakón okintlatak imomachtijkawan iwan okinmilwij san yejwan inselti: ―Xipakikan namejwan porke ankitaj ika namoixtololo tlan axan ankitaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Porke ya wejkawitl miekej profetajtin iwan reytin okinekiaj kitanij tlan axan namejwan ankitaj, pero mach okitakej. Okinekiaj kikakinij tlan axan namejwan ankikakij, pero mach okikakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Se tlamachtij itech tlanawatile de Moisés okinekke kitlajtlakolmayawis in Jesús, iwan okitlajtlanij: ―Tlamachtij, ¿tlanon moneki nikchiwas para nikpias nemilistle katlej mach keman tlamis? ");
INSERT INTO nhyNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús okinankilij: ―¿Tlanon kijta itlanawatil in Moisés? ¿Tlanon tikmomaka kuenta? ");
INSERT INTO nhyNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","In tlamachtij itech tlanawatile de Moisés okijtoj: ―“Xiktlasojtla in Señor moDios ika nochi moyolo, ika nochi moanima, ika nochi mochikawalis iwan ika nochi motlalnamikilis. Iwan xiktlasojtla mokni ken tej timotlasojtla.” ");
INSERT INTO nhyNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ijkuakón Jesús okilwij: ―Kuale otitlanankilij. Tla ijkón tikchiwas tikpias nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero in tlamachtij itech tlanawatile de Moisés okinekke mokawas kuale teixpan, iwan okilwij in Jesús: ―¿Iwan akin yon nokni? ");
INSERT INTO nhyNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ijkuakón Jesús okinankilij: ―Se tlakatl oyaya de Jerusalén para Jericó, iwan ipan ojtle okitlachtekijkej sekimej ichtekej iwan okitkilijkej nochi tlan okitkia, iwan okitkilijkej asta itzotzol. Okimagakej iwan oyajkej, iwan yej okikajtejkej medio mikkatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Satepan oonkisako se tiopixke katlej ik ompa opanok itech yon ojtle. Pero nijkuak okitak, san okitlayawalwij iwan okipanawij. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Noijki se levita katlej tekipanoa itech tiopan no ik ompa opanok, iwan nijkuak okitak, noijki san okitlayawalwij iwan okipanawij. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero se tlakatl de estado de Samaria katlej opanoaya ipan yon ojtle, nijkuak okitak, okiknomatke. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Omijkuanij inawak, iwan okipajtilij ika aseite iwan ika vino kan okiejeskixtijkej, iwan okimililij ika se tzotzole. Satepan, okitlejkoltij ipan iburro, iwan okiwikak itech se kale kan motepialtiaj (mokalotiaj) iwan ompa okimonekuitlawij. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Owalmostlatik, nijkuak in tlakatl de Samaria ya yani, okixtij ome tomin iwan okimakak iteko in kale kan motepialtiaj, iwan okilwij: “Xikmonekuitlawi yin tlakatl, iwan tla monekis itlaj okachi, nimitztlaxtlawilijtejko nijkuak nimokuepati.” ");
INSERT INTO nhyNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Axan kiné, ¿katlij yej de yonmej eyin tlakaj tikita omochij kej ikni in tlakatl katlej okitlachtekijkej? ");
INSERT INTO nhyNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","In tlamachtij itech tlanawatile de Moisés okijtoj: ―Yen katlej okiknomatke. Ijkuakón Jesús okilwij: ―Kuale kajki. Axan xiwia iwan no ijkón xikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús iwan imomachtijkawan okiseguiroayaj oyayaj para Jerusalén, iwan oajsitoj itech se pueblojtzin. Se siwatl itoka Marta okinkalotij itech ikalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta okipiaya se ikni siwatl itoka María. Iwan yin María omotlalij ikxitlan Jesús para kikakis tlan okijtoaya in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero Marta okachi omotekipachoaya itech itekiw, omijkuanij inawak Jesús iwan okilwij: ―Señor, ¿amo tikmomaka kuenta nik in nokni nechkawilia in tekitl san nej ma nikchiwa? Xikilwi ma nechpalewi. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Jesús okinankilij: ―Marta, Marta, sa tekitl timotekipachoa iwan timotlanemililtia ika miek tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero onkaj san se tlamantle katlej moneki okachi ika se motekipachos. María okipejpenke yon tlamantle iwan mach akaj welis kikixtilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se tonale Jesús omotiotzajtzilijtoka se lugar, iwan nijkuak otlanke omotiotzajtzilij, se de imomachtijkaw okilwij: ―Señor, xitechmachti kenik timotiotzajtziliskej, ijkón ken Juan Tlakuateekij okinmachtij imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús okinmilwij: ―Nijkuak anmotiotzajtziliskej, xikijtokan: ToTajtzin Dios katlej tikaj ilwikak, ma nochtin kiyektenewakan motoka. Ma ajsiki yon tonale nijkuak titlanawatis. Ma mochiwa tlan tikmonekiltia ixko yin tlaltikpak ijkón ken mochiwa ompa ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xitechmaka axan tlan tikkuaskej katlej ika tipanoskej yin tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Xitechtlapojpolwi de totlajtlakol, porke tejwan noijki tikintlapojpolwiaj nochtin akinmej techtoktiaj tlan amo kuale. Iwan amo xitechmotekawili ma techtlajtlakolmayawi in Amo Kuale Tlakatl para ma titlajtlakokan. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús noijki okinmilwij: ―Tla akaj de amejwan kipia se iamigo iwan yawi ichan kej tlajko yuak, iwan kilwia: “Amigo, xinechtlaneti eyi pan, ");
INSERT INTO nhyNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","porke se noamigo yakin oejkok nokalijtik iwan witz de wejka, iwan mach nikpia tlan nikmakas ma kikua.” ");
INSERT INTO nhyNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iwan tla nekáj tlakatl waltlanankilis desde ikalijtik, iwan kilwis: “Amo xinechkuejso. Ya tzaktok in puerta, iwan nokonewan ya kochtokej nowan ipan totlapech. Mach welis nimoketzas para nimitzinmakati.” ");
INSERT INTO nhyNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ipan melajka namechilwia, tla okachi mochikawas kitlajtlanilis, iamigo moketzas iwan kimakas tlan kinekis, pero amo por wel iamigo, sino porke mochikawa kitlajtlanilia. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Por yonik Nej namechilwia: Xiktlajtlanilikan Dios tlan amechpoloa, iwan Yej amechmakas. Xiktemokan tlan amechpoloa, iwan ankajsiskej. Xiknotzakan Dios, iwan Yej amechtlatlapolis. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porke akin kitlajtlani, kiresibiroa. Akin kitemoa, kajsi. Iwan akin tlatatalatza itech puerta, kitlatlapoliaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Akaj de amejwan antetajmej mixewis kimakas ikone se tetl nijkuak kitlajtlanilis se pan? ¿O noso mixewis kimakas se koatl nijkuak kitlajtlanilis se michin? ");
INSERT INTO nhyNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O noso mixewis kimakas se kolotl nijkuak kitlajtlanilis se teksistle? ");
INSERT INTO nhyNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Axan kiné, tla namejwan katlej mach ankualtin, ankimatij ankinmakaj namokonewan itlaj tlan kuale, kenik namoPapan katlej kajki ilwikak amo ma kinmaka in Espíritu Santo akinmej kitlajtlaniliskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús okikixtijtoka se ejekatl mach kuale de ijtik se tlakatl katlej okitoktijtoka ma yeto nontle. Iwan nijkuak in ejekatl mach kuale okiske, in tlakatl ya owelik otlajtoj. In tlakaj sa otlajtlachixkej (omomajmawtijkej) nijkuak ijkón okitakej, ");
INSERT INTO nhyNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","pero sekimej okijtojkej: ―Yin tlakatl kinkixtia ejekamej mach kualtin ika ipoder in tlayekanke demonio itoka Beelzebú. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Oksekimej, okinekiaj kitlajtlakolmayawiskej in Jesús, iwan okitlajtlaniliayaj ma kichiwa se milagro de ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Yej okimatia tlan okiyejyekoayaj, iwan okinmilwij: ―Tla in tlakaj de se país momijmiktiskej san entre yejwan, yon país pojpoliwis. Iwan tla itech se familia mokualaniskej entre yejwan, yon familia noijki xixinis. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ijkón noijki, tla Satanás moxelos de inwan ejekamej mach kualtin, ¿kenik welis wejkawas ipoder? Ijkín Nej namechilwia porke namejwan ankijtaj ke Nej nikinkixtia ejekamej mach kualtin ika ipoder in Beelzebú. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero tla ijkón yeni, ¿welis ankijtoskej namejwan ke namomomachtijkawan noijki kinkixtiaj ejekamej mach kualtin ika ipoder in Beelzebú? Xikintlajtlanikan aber tlan kijtoskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero tla Dios nechmaka ipoder para ma nikinkixti ejekamej mach kualtin, tonses kijtosneki in Dios yowalaj para tlanawatis amonawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Nijkuak se tlakatl chikawak kimonekuitlawia ikalijtik ika miekej iteposwan, tlan kipixtok ompa ikalijtik mach akaj welis kikixtilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tla witz oksé tlakatl okachi chikawak ke yej iwan kitlanis, tonses kinkixtilis iteposwan katlej ika mopalewiani, iwan kitkilis nochi tlan iaxka. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Akin amo kajki nowan, kajki kontra Nej. Iwan akin amo nowan kinpixka animajtin, san kinxixinia. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Nijkuak se ejekatl mach kuale kisa de ijtik se tlakatl, nemi kan tlawaki, kitemojtinemi kan mosewis. Iwan nijkuak amo kajsi, kimolwia: “Nimokuepas oksemi itech nekáj tlakatl kan onikiske.” ");
INSERT INTO nhyNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Iwan nijkuak mokuepa, kajsitajsi in yon tlakatl kej se kale kan tlachipawkan iwan tlayektlalitok. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Tonses yawi kinnotzatij oksekimej chikomen ejekamej okachi piorestin ke yej, iwan nochtin yawij mochantitiwej itech yon tlakatl, iwan satepan yon tlakatl mokawa okachi pior ke antes. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mientras Jesús ijkón otlapojtoka, ijkuakón se siwatl owaltzajtzik de intzalko in tlakaj: ―Ma paki in siwatl katlej omitztlakatilij iwan omitzchichitij. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Jesús okijtoj: ―Okachi kuale, ma pakikan akinmej kikakij itlajtol in Dios iwan kichiwaj tlan kinmilwia. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","In tlakaj opéj okachi kiyawaloaj in Jesús, iwan Yej opéj kinmilwia: ―In tlakaj de yin tiempo sa tekitl mach kualtin, iwan axan kinekij ma nikchiwa se milagro. Pero mach nikinmakas oksé milagro, sino san yen milagro tlan opanok in profeta Jonás. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Porke ijkón ken Jonás omochij kej se señas para nekatej tlakaj katlej ochantiaj itech weyikan de Nínive, ijkón noijki Nej katlej onimochij nitlakatl nimochiwas kej se señas para in tlakaj de yin tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos), nijkuak kinmixkomakaskej in tlakaj de yin tiempo, in reina katlej owalaj de ik tlani kan okachi wejka de ixko yin tlaltikpak para kikakilis iixtlamachilis in rey Salomón, yej noijki itech nekáj tonale de tlaixkomakalistle moketzas iwan kintlajtlakoltis in tlakaj de yin tiempo, porke mach kinekij nechkakiskej, iwan Nej okachi niweyikistok (niweyititok) ke Salomón. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","In tlakaj katlej ochantiaj itech weyikan de Nínive, yejwan noijki moketzaskej itech nekáj tonale de tlaixkomakalistle (tlatzonmanalos) iwan kintlajtlakoltiskej in tlakaj de yin tiempo. Porke yejwan omoyolkuepkej de intlajtlakol nijkuak okintlapowij in Jonás. Iwan axan, Nej okachi niweyikistok (niweyititok) ke Jonás iwan mach kinekij nechkakiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Mach akaj kitlikuitia se tlanextle para kitlaatis, o noso para kitlalis itlampa se chikiwitl, sino se kitlalia ajkopan, para ma kintlawili nochtin akinmej kalakiskej kalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Namoixtololowan yejwan katej kej yeskia se tlanextle para namotlalnakayo. Tla namoixtololowan kualemej, noijki namotlalnakayo kipias tlanextle. Pero in tla namoixtololowan mach kualemej, noijki nochi namotlalnakayo kipias tlatleyualotl. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Xikpiakan kuidado kiné, amo ma mokuepa tlatleyualotl katlej yeskia tlanextle para namotlalnakayo. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Porke tla nochi namotlalnakayo kipia tlanextle, iwan amo kipia nion se tlatleyualotl, nochi welis ankitaskej, ken nijkuak se tlanextle amechtlawilia. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Nijkuak Jesús otlanke otlapoj, ijkuakón se fariseo okilwij ma tlakuati ichan. Jesús okalakke ikalijtik in fariseo iwan omotlalij itech mesa. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","In fariseo sa omotlajtlachialtij (omomajmawtij) nijkuak okitak nik in Jesús mach omomajtekij antes de tlakuas. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero in Señor Jesús okijtoj: ―Namejwan anfariseos ankichipawaj in vaso iwan plato ik tlixko, pero ik tlijtik namejwan anyolbierotikej. Porke namoijtik antentokej de ichtekayotl iwan nochi tlan amo kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Wel antzontemej! Dios okichij namotlalnakayo, pero noijki okichij namoyolo. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Xikchiwakan tlan kuale ika nochi amoyolo, iwan ijkón nochi namoyolo yetos chipawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Ay de amejwan, anfariseos! Namejwan ankitemakaj namodiesmo de menta, de ruda iwan de nochi tlamantle xiwitl. Pero mach ankichiwaj tlan Dios kijta, nik moneki se kinchiwilis in tlakaj tlan intech powi iwan moneki se kitlasojtlas in Dios. Kuale in tla se diesmaros, pero noijki moneki se kichiwas katlej okachi importante. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Ay de amejwan, anfariseos! Ankiwelitaj anmotlaliskej itech kuale lugar itech tiopanmej, iwan ankinekij ma amechyektlajpalokan nijkuak annemij tiankistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Ay de amejwan, anfariseos iwan antlamachtijkej de itlanawatil in Moisés, anteixkajkayajkej! Namejwan ankatej ken mikkakuyoktin katlej mach motaj, in tlakaj inpan panoaj iwan mach kimatij kox tlabiero nik tlijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ijkuakón okinankilij se tlamachtij de itlanawatil in Moisés, okilwij: ―Tlamachtij, nijkuak ijkón tikijta, tejwan noijki titechpijpinatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús okijtoj: ―¡Ay de amejwan noijki, antlamachtijkej de itlanawatil in Moisés! Porke namejwan ankintoktiaj in tlakaj ma kinmamakan miekej tlanawatiltin, katlej sa tekitl owij para se kinxikos, iwan namejwan nion siera ika se amomajpil mach ankinekij ankitilkoskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Ay de amejwan, porke ankinchiwiliaj inmikkakuyok in profetajtin katlej okinmiktijkej in ya wejkawitl namoweyitajwan! ");
INSERT INTO nhyNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Para amejwan ankitaj kuale tlan yejwan okichijkej. Porke yejwan okinmiktijkej in profetajtin, iwan namejwan ankinchiwiliaj inmikkakuyok. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Por yonik Dios itech iixtlamachilis okijtoj: “Namechintitlanilis profetajtin iwan tlatitlaniltin, iwan sekimej de yejwan kinmiktiskej iwan oksekimej kintlatlalochtiskej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Porke in tlakaj de yin tiempo, inpan wetzis in tlajtlakole de inmikilis de nochtin profetajtin katlej okinmiktijkej desde ijkuak opéj in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Desde ijkuak okimiktijkej in Abel iwan asta ijkuak okimiktijkej in Zacarías, katlej okimiktijkej ijtik in weyi tiopan iyakapan artal. Por yonik namechilwia, yon tlajtlakole inpan wetzis in tlakaj de yin tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Ay de amejwan, antlamachtijkej de itlanawatil in Moisés! Porke mach ankinkawiliaj in tlakaj ma kimomakakan kuenta tlan Dios techmachtia. Porke nion amejwan mach ankinekij ankimomakaskej kuenta, iwan nion mach ankinkawiliaj in oksekimej ma kimomakakan kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nijkuak Jesús okinmilwij yin tlajtole, in tlamachtijkej de itlanawatil in Moisés iwan fariseos sa tekitl okualankej, iwan opéj kitlajtlania de miek tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Okinekiaj kajxilianij kanaj itlaj tlajtole tlan Yej kijtoani para ijkón welis ika kitilwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Satepan miekej tlakaj opéj mololoaj, sa tekitl miekej omololojkej asta sa omotojtopewayaj entre yejwan. Jesús opéj achtoj kinmilwia imomachtijkawan: ―Ximotlachilikan de itech inlevadura in fariseos, kijtosneki, ximotlachilikan de itech inteixkajkayawalis. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porke nochi katlej amo momati kipia por momatis, iwan nochi katlej kajki tlatitok kipia por nesis. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Por yonik, nochi tlan amejwan ankijtojkej ijtik tlatleyualotl, nochi mokakis kan tlanestok. Iwan tlan ankijtojkej ichtaka amokalijtik, kijtoskej chikawak kan nochtin kuale kikakiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Namejwan katlej annoamigoswan namechilwia, amo xikinmiimakasikan katlej weliskej kimiktiskej namotlalnakayo, iwan satepan mach ok welis ok itlaj amechtoktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero Nej namechilwis akin moneki ankimakasiskej: xikimakasikan toTajtzin Dios katlej welis amechmiktis, iwan ika ipoder welis kititlanis namoanima ijtik tliko. Ijkón kiné, moneki xikimakasikan yen toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’¿Amo monamakaj makuile tototzitzintin por makuile sentabo? Pero maski amo okachi itlaj inpatij, Dios mach kelkawa nion se tototzin. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Iwan Dios asta kimati keski amotzonkal ankipiaj. Amo ximomawtikan. Namejwan okachi amopatij iwan amo ken inpatij miekej tototzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Iwan nej namechilwia, ke akin kijtos inmixpan tlakaj ke kineltoka nik in Nej nitemakixtij de yej, Nej noijki akin onimochij nitlakatl, nikijtos inmixpan iangelwan Dios nik in yej noaxka. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero tla akaj kijtos inmixpan tlakaj ke amo nechixmati, Nej noijki nikijtos inmixpan iangelwan Dios nik mach nikixmati. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Iwan akin tlajtos kontra Nej katlej onimochij nitlakatl, Dios welis kitlapojpolwis. Pero akin tlajtos biero de yen Espíritu Santo, Dios mach kitlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Nijkuak amechwikaskej itech tiopanmej, o noso inmixpan juestin o noso inmixpan tekiwajkej, amo xitlanemilikan por kenik antlanankiliskej o noso tlan ankijtoskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pero nijkuak ajsis ora de antlajtoskej, in Espíritu Santo amechilwis tlan ankijtoskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Se tlakatl katlej oyeka intzalko in tlakaj okilwij in Jesús: ―Tlamachtij, xikilwi nokni ma nechmaka in herencia katlej nechtokaroa. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jesús okilwij: ―Tlakatl, ¿akin onechtlalij ma nieto Nej kej nijues o noso ma nieto kej nitlaxeloj? ");
INSERT INTO nhyNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Iwan okinmilwij nochtin: ―Ximotlachilikan, amo ma kineki namoyolo tlan kita. Porke se tlakatl maski ma kipia miek rikojyotl yon mach welis kimakas nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ijkuakón okinmilwij se ejemplo: ―Oyeka se tlakatl katlej sa tekitl okimopialiaya, opixkak sa tekitl miek, porke otlamochiwilij. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Iwan okimolwij: “¿Tlan nikchiwas? Mach nikpia kan niktlaatis nochi tlan onikpixkak.” ");
INSERT INTO nhyNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iwan okimolwij: “Ya nikmati tlan nikchiwas. Nikinxixinis nokueskonwan iwan nikinchiwas okachi wejweyin, ompa niktlaatis nochi tlan onikpixkak iwan nochi tlan nikpia. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Satepan nikmolwis ipan noanima: Nikpia miek tlatitok tlan noaxka para miek xiwitl, ma nimosewi, ma nitlakua, ma natli, iwan ma nipaki.” ");
INSERT INTO nhyNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero in Dios okilwij: “¡Tzontetl! Yin yuak timikis, iwan tlan yotiktlaatij, ¿akin kimokawis?” ");
INSERT INTO nhyNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ijkón mochiwaj in tlakaj katlej kipiaj miek tlamantle san para yejwan, pero mach itlaj kipiaj inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Satepan Jesús okinmilwij imomachtijkawan: ―Namechilwia, kiné, amo ximotlanemililtikan por tlan ankikuaskej para anyolitoskej, nion por tlan ankonakiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Namonemilis okachi ipatij ke tlan ankikuaj, iwan namotlalnakayo okachi ipatij ke tlan ankonakiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xikinmitakan in kakalomej, mach tookaj, mach pixkaj, mach kipiaj inkueskon iwan nion mach kanaj kipiaj kan kitlaatiaj intlakual. Pero Dios kintlamaka. Iwan namejwan okachi amopatij iwan amo ken totomej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Tla akaj de amejwan sa tekitl tlanemilia porke kineki moskaltis ok tlajko metro, ¿kox welis moskaltis? ");
INSERT INTO nhyNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tla mach anwelij ankichiwaj se tlamantle tzikitzin, ¿tlanik, kiné, antlanemiliaj itech oksekimej tlamantin? ");
INSERT INTO nhyNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Xikitakan kenik moskaltiaj in xochimej, mach tekipanoaj iwan nion mach ijkitij (tlajtzomaj). Pero Nej namechilwia ke nion rey Salomón mach semi omotlakentij ken se de yinmej xochimej maski omotlakentiaya ika itzotzol katlej okachi patíoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iwan tla Dios ijkón kitlakentia in xochitl, katlej axan ompa kajki ipan tepetl iwan mostla wiptla mochichinos ijtik tlitl, ¿kenik amo ma amechtlakenti namejwan? ¡Namejwan wel tzikitzin namotlaneltokalis! ");
INSERT INTO nhyNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Por yonik, amo sa tekitl xitlanemilikan por tlan ankikuaskej o noso tlan ankoniskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porke in tlakaj katlej mach kixmatij Dios kitemoaj nochi in yon tlamantle. Pero namejwan ankipiaj namoPapan Dios katlej ya kimati tlan amechpoloa. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pero namejwan achtoj xiktemokan ma Dios tlanawati ipan namoyolo. Iwan ijkón Dios amechmakas nochi yon tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Amo ximomawtikan, namejwan maski mach anmiektzitzintin annochkawan, namoPapan Dios kipia pakilistle para amechkawilis xitlanawatikan noijki kan Yej tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xiknamakakan tlan ankipiaj, iwan tomin xikinmakakan in pobrestin. Xiktemitikan rikojyotl ika bolsa katlej mach tlajtlamis ompa ilwikak. Yon rikojyotl mach keman tlamis. Mach welis kuakualos iwan nion mach welis kitkis akaj ichtekke. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porke kan yetos namorikojyo, noijki ompa yetos namoyolo. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Sa xitzotzoltitokan iwan sa xikpixtokan namokandil ma xotlato. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xiekan kej antekipanojkej katlej kichixtokej inteko ma mokuepati kan monamiktiaj, para san niman kitlatlapoliskej nijkuak tlatatalatzas nijkuak yej ejkos. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma pakikan in tekipanojkej katlej kinmajsiki inteko ijsatokej nijkuak yej ejkos. Ipan melajka namechilwia, nik inewian inteko kinsiyajtlalis itech mesa iwan kintlamakas. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maski ma ejko kej tlajko yuak o noso ya tlanestiwitz, iwan tla kinmajsiki ijsatokej, ma pakikan yonmej tekipanojkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Xikmatikan kiné, tla se tetaj kimatini tlan ora witz in ichtekke, ijsatoni iwan amo kitekawiliani akaj ma kalaki ikalijtik para ma kitlachteki. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Namejwan noijki xiijsatokan. Porke Nej katlej onimochij nitlakatl niwitz nijkuak namejwan mach annechchiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ijkuakón Pedro okitlajtlanij: ―Señor, ¿otikijtoj yon ejemplo san para tejwan, o noso para nochtin? ");
INSERT INTO nhyNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","44","In Señor okijtoj: ―Nikilwia san akin yetos, katlej tekipanoj de konfiansa iwan tlalnamikilisej, katlej kitlalia in Señor ma kintlamaka in oksekimej tekipanojkej. Tla ijkuak ejkos iteko iwan kajsiki kichijtok tlan okinawatij, ipan melajka namechilwia, ke yon iteko kitlalis ma kitili nochi tlan iaxka. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero tla yon tekipanoj kiyejyekos ke wejkawas iteko para walmokuepas, iwan pewas kinmagas in oksekimej tekipanojkej iwan kriadajtin, iwan pewas ilwitlakuas iwan konis iwan iwintis, ");
INSERT INTO nhyNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ijkuakón ejkos iteko itech se tonale nijkuak itekipanoj mach kichia, iwan itech se ora katlej mach kimati. Sa tekitl kitlajyowiltis iwan kitlalis ma yeto inwan katlej mach tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’In tekipanoj katlej kimati tlanon kineki iteko, pero mach motlalia listo para nijkuak yej witz nimpor amo kichiwa tlan yej kineki, sa tekitl kiwitekis. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero in tekipanoj katlej mach okimatke tlanon okinekia iteko, iwan okinchij sekin tlamantin katlej moneki ika ma kiwitekikan, kiwitekiskej kiné pero mach sa tekitl. Porke nijkuak in Dios kichiwa se tlakatl ma yeto moesoj, noijki kitlajtlanilia ma kichiwa miek tekitl. Iwan nijkuak in Dios kimaka se tlakatl ma yeto moesoj de miek tlamantle, noijki okachi miek tekitl kitlajtlanilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Nej oniwalaj ixko yin tlaltikpak para nikinmakas in tlakaj yankuik tlaneltokalistle katlej xotlas kej tlitl ipan inyolo. Iwan sa tekitl niknekiskia ya ma xotlato. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero nikpia de nimokuateekis ika se tlakuateekilistle de tlajyowilistle. Iwan sa tekitl nitlajyowia asta ma mochiwa tlan kipia de mochiwas notech. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amo xikyejyekokan ke Nej oniwalaj para ma yeto yolosewilistle ixko yin tlaltikpak. ¡Amo! Sino in tlakaj moxexeloskej por yen Nej. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Porke de nian para tlayakapan, makuiltin de itech se familia mach ok yeskej san se tlajtole, eyin mach motlajtolnamikiskej inwan omen, iwan omen no mach ok motlajtolnamikiskej inwan eyin. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","In tepapan mach ok motlajtolnamikis iwan ikone, iwan tekone mach motlajtolnamikis iwan ipapan. In temaman mach motlajtolnamikis iwan ichpoch, iwan ichpoch mach motlajtolnamikis iwan imaman. In temonan mach motlajtolnamikis iwan siwamontle, iwan siwamontle mach motlajtolnamikis iwan imonan. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús noijki okinmilwij in tlakaj: ―Nijkuak namejwan ankitaj motlalia in mixtle ik ipoliwian tonale, namejwan ankijtaj nik kiawis, iwan ijkón tlamochiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iwan nijkuak in ejekatl witz ik tlani, namejwan ankijtaj nik tonas, iwan ijkón tlamochiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Teixkajkayajkej! Namejwan kuale ankixyejyekoaj tlanon tlamochiwa itech ilwikak iwan ixko in tlaltikpak. ¿Kenik kiné, mach ankixyejyekoaj tlan nikchiwa itech yin tiempo? ");
INSERT INTO nhyNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Tlanik mach ankiyejyekoaj namejwan amonewian para ankichiwaskej tlan kuale? ");
INSERT INTO nhyNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tla akaj mitztilwia innawak tekiwajkej, xikchiwa de iwan ximotlapojpolwi mientras anyawij ipan ojtle, para amo ma mitzwika ixpan jues. Porke in tla amo, in jues mitztemaktis (mitztemaktilis) imak in mayol, iwan mayol mitztzakuas telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Iwan mach tikisas de ompa asta amo xiktlaxtlawa in salúltimo sentabo para tikisas. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Itech nekatej tonaltin sekimej tlakaj okilwijkej in Jesús nik in Pilato okinmiktij sekimej tlakaj de estado de Galilea, iwan inmeso de yonmej tlakaj okineloj iwan inmeso de sekimej yolkamej katlej yejwan okinmiktijkej para kixpantiliskej in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús okinmilwij: ―¿Ankiyejyekoaj namejwan nik ijkón opanokej in tlakaj de Galilea porke oyekaj okachi tlajtlakolejkej ke oksekimej tlakaj de Galilea? ");
INSERT INTO nhyNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Amo! Namejwan noijki anmikiskej tla amo anmoyolkuepaskej inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O noso ankineltokaj namejwan ke nekatej kaxtoltin iwan eyin tlakaj katlej omikkej nijkuak in torre de Siloé inpan owetzke, oyekaj okachi tlajtlakolejkej ke oksekimej katlej ochantiaj Jerusalén? ");
INSERT INTO nhyNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Amo! Namejwan noijki anmikiskej tla amo anmoyolkuepaskej inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ijkuakón Jesús okinmilwij yin ejemplo: ―Se tlakatl okipiaya se igoskuawitl otoktoka itech iuvasyoj, se tonale oyáj okitato kox yotlakke, pero mach itlaj igos okajsik. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Tonses okilwij in tlakatl katlej kimonekuitlawia in uvasyoj: “Ya kipia eyi xiwitl nikkualiita yin igoskuawitl xamo kipia itlaj igos, iwan mach keman itlaj nikajsi. Xiktzonteki, porke san tlatzakuilijtok itech yin tlale.” ");
INSERT INTO nhyNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero in tlakatl katlej kimonekuitlawia yon uvasyoj okinankilij: “Señor, ok xikkawa yin xiwitl. Niktlayamanilis iwan nikmajadajtemis. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xamo tlakis. Pero tla amo tlaki, ijkuakón keman tiktzontekiskej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nijkuak weyi tonale Jesús otlamachtijtoka itech se tiopan de yen judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Iwan ompa oyeka se siwatl katlej yokipiaya kaxtole iwan eyi xiwitl de kokoxke. Se ejekatl mach kuale okikaj kuitlapantomotztik yon siwatl iwan mach owelia omokuitlapanmelawaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nijkuak Jesús okitak, okinotzke iwan okilwij: ―Siwatl, axan yotipajtik de mokokolis. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesús okintlalij imawan ipan yon siwatl, iwan san niman ijkuakón okuitlapanmelawik in siwatl, iwan opéj kiweyikixtia in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero in tlayekanke de yon tiopan okualanke porke Jesús okipajtij in siwatl nijkuak weyi tonale, iwan okinmilwij in tlakaj: ―Onkaj chikuasen tonale para se tekipanos. Itech yonmej tonaltin xiwikikan kiné para ximopajtikan, iwan amo ximopajtikan nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ijkuakón in Señor Jesús okinankilij: ―Teixkajkayajkej, ¿amo ankitotomaj namejwan namotoro o noso namoburro nijkuak weyi tonale iwan anyawij ankatlititiwej? ");
INSERT INTO nhyNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iwan yin siwatl katlej walajtok nelwatl de Abraham, iwan katlej Satanás okilpijtoka ika yin kokolistle ya kaxtole iwan eyi xiwitl, ¿amo omonekia noijki se kitotomas de ikokolis maski ma yeto weyi tonale? ");
INSERT INTO nhyNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nijkuak Jesús ijkón okijtoj, nochtin ikontraswan sa opinajkej. Pero nochtin in tlakaj opakiaj por yen wejweyin tlamantin katlej Jesús okinchiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ijkuakón Jesús okijtoj: ―¿Tlan ika welis nikkompararos para xikmomakakan kuenta kenik in Dios tlanawatia? ¿Tlan ejemplo welis namechilwis para xikmomakakan kuenta? ");
INSERT INTO nhyNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yon ken iyolo in mostaza katlej se tlakatl kitooka itlalaj. Achtoj kisa, satepan moskaltia iwan motlami se weyi kuawitl, iwan asta itech motepajsoltiaj in totomej ipan imamayo. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús noijki okijtoj: ―¿Tlan ika welis nikkompararos para xikmomakakan kuenta kenik in Dios tlanawatia? ");
INSERT INTO nhyNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yon ken levadura katlej se siwatl kineloa ika eyi tlatamachiwale de arina, iwan levadura kisamawa nochi in tixtle. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús nijkuak oyaya para Jerusalén, opanotiaya iwan otlamachtijtiaya itech pueblojtin iwan itech pueblojtzitzintin. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iwan se tlakatl okitlajtlanij: ―Señor, ¿keskimej tlakaj kinmakixtis in toTajtzin Dios de intlajtlakol? ¿San kanaj keskimej? Jesús okinankilij: ");
INSERT INTO nhyNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Xikchiwakan de xikalakikan itech puerta kopichtik katlej yawi ilwikak. Porke Nej namechilwia, nik miekej tlakaj kinekiskej kalakiskej, pero mach weliskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yetos kej se chanej katlej mewas iwan kitzakuas in puerta. Tonses namejwan katlej anyeskej kalan, antlatatalatzaskej itech puerta iwan ankijtoskej: “Señor, xitechtlatlapoli.” Pero yej amechnankilis: “Mach namechixmati akin namejwan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ijkuakón namejwan pewas ankijtoskej: “Tejwan otitlakuajkej iwan otikonikej mowan, iwan tejwatzin otitlamachtij ipan ojmej de topueblo.” ");
INSERT INTO nhyNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero yej amechnankilis: “Yonamechilwij nik mach namechixmati akin namejwan. Ximachiwakan de Nej aminochtin namejwan katlej antlajtlakolejkej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ompa anchokaskej iwan anmotlanteteyitzaskej, nijkuak ankitaskej in Abraham, Isaac, Jacob iwan nochtin in profetajtin katlej katej kan Dios tlanawatia, iwan namejwan amechwalkixtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porke witzej tlakaj de ik ajko, de ik tlani, de ik ikisayan tonale iwan de ik ipoliwian tonale, para motlaliskej tlakuaskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iwan sekimej katlej axan mach wejweyikistokej (weyititokej) satepan wejweyikistoskej, iwan katlej axan wejweyikistokej satepan mach ok wejweyikistoskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ijkuakón itech yon tonale oejkokej sekimej fariseos iwan okilwijkej in Jesús: ―Xiwia de nian, porke in rey Herodes kineki mitzmiktis. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero Jesús okinnankilij: ―Xiwian xikilwitij yon ostotl Herodes: “Axan iwan mostla ok nikinkixtijtos ejekamej mach kualtin iwan ok nikinpajtijtos in kokoxkej, iwan asta ipan eyi tonale nitlamis.” ");
INSERT INTO nhyNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero nikpia de nikseguiros noojwi axan, mostla iwan wiptla, porke nochtin in profetajtin kipiaj de mikiskej itech weyikan de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Jerusalén, Jerusalén, tej tikinmiktia in profetajtin, iwan tikinmojmotla ika tetl katlej Dios kualintitlani monawak! ¡Miekpa oniknekke nikinmololos mokonewan, kej se pio kinmololoa ikonewan itlampa iajaswan, pero mach otiknekke! ");
INSERT INTO nhyNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xikitakan kiné, Dios mach ok yetos amowan, sino amechkawas. Iwan Nej namechilwia, nik mach oksemi annechitaskej asta ma ajsiki in nekáj tonale nijkuak namejwan ijkín ankijtoskej: “Ma Dios kitiochiwa katlej okiwaltitlanke para tlanawatis.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nijkuak weyi tonale Jesús oyáj otlakuato ichan se tlayekanke fariseo, iwan oksekimej fariseos sa okixpixtokaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Noijki ompa oyeka iyakapan Jesús se tlakatl katlej otetenke. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ijkuakón Jesús okintlajtlanij in tlamachtijkej de itlanawatil in Moisés iwan fariseos: ―¿Kuale se kipajtis se kokoxke nijkuak weyi tonale, o noso amo? ");
INSERT INTO nhyNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero yejwan mach itlaj okijtojkej. Tonses Jesús okimakitzkij in kokoxke iwan okipajtij, iwan okilwij ma wia. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iwan Jesús okinmilwij in fariseos: ―¿Akin de amejwan amo kikixtia iburro o noso itoro tla wetzi ijtik se kuyoktle maski ma yeto weyi tonale? ");
INSERT INTO nhyNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iwan yejwan mach ok owelikej ok itlaj okijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nijkuak Jesús okitak kenik in inbitadostin okipejpenayaj katlej okachi kuale lugar para motlaliskej itech mesa, ijkuakón okinmakak yin ejemplo: ");
INSERT INTO nhyNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Nijkuak akaj mitzinbitaros itech se ilwitl kan monamiktiaj, amo ximotlali kan okachi kuale lugar, porke welis ejkos oksé inbitado katlej okachi weyikistok (weyititos) ke tej. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Iwan katlej oamechinbitaroj, welis mitzilwis: “Xikkawili yin tlakatl ompa ma motlali.” Ijkuakón tej tiixpinawas iwan tias timotlaliti asta tlatentle. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Okachi kuale, nijkuak mitzinbitaroskej, ximotlali asta tlatentle. Para ke nijkuak mitzitas akin omitzinbitaroj, mitzilwis: “Amigo, ximotlali nian kan okachi kuale lugar.” Ijkón mitzweyimatiskej katlej ompa inwan timotlalis. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porke akin moweyinekis, mopinatis. Pero akin amo moweyinekis, weyikistos (weyititos). ");
INSERT INTO nhyNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús noijki okilwij in tlakatl katlej okinbitaroj ma tlakuati ichan: ―Nijkuak tiknekis tiktemakas se tlaxkale tonayan o noso tiotlakke, amo xikinminbitaro moamigoswan, nion mokniwan, nion moparientejwan, nion mobesinoswan katlej kimopialiaj. Porke yejwan welis noijki mitzinbitaroskej, iwan ijkón yejwan momakuepaskej mowan. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Okachi kuale, nijkuak tiilwichiwas, xikinminbitaro in pobrestin, wilanmej (temetlamej), koxomej, iwan katlej mach tlachiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iwan ijkón tikpias pakilistle. Porke yejwan mach welis momakuepaskej mowan, pero Dios mitzkuepilis nijkuak moyolkuiskej (moyolitiskej) in yolchipawakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Se tlakatl katlej oewatoka itech mesa nijkuak ijkón okikakke, okilwij in Jesús: ―Ma paki akin tlakuas kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ijkuakón Jesús okilwij: ―Se tlakatl okitemakak se weyi tiotlakantlakuale, iwan otlanawatij ma kinminbitarokan miekej tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iwan nijkuak oajsik ora para tlakuaskej, okititlanke se itekipanoj ma kinmilwiti iinbitadoswan: “Xiwikikan, porke nochi ya kuale kajki.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero nochtin opéj kijtaj ma kintlapojpolwikan porke mach welis yaskej. Achtoj se okijtoj: “Yakin onikoj se tlale, iwan nikneki nias nikitati. Nimitztlatlawtia xinechtlapojpolwi porke mach welis nias.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Oksé okijtoj: “Onikinkoj makuile yunta de torojtin, iwan niawi nikinyejyekoti. Nimitztlatlawtia xinechtlapojpolwi porke mach welis nias.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iwan oksé okijtoj: “Yakin onimonamiktij, iwan por yonik mach welis nias.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nijkuak in tekipanoj omokuepato, okimakak kuenta iteko nochi tlan okilwijkej. Tonses iteko okualanke iwan okilwij itekipanoj: “Xiwia totoka ipan ojmej iwan ipan ojpitzaktin de yen pueblo, iwan nian xikinwalinwika in pobrestin, wilanmej (temetlamej), koxomej iwan katlej mach tlachiaj.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Okachi satepan itekipanoj okijtoj: “Señor, yonikchij ken otinechnawatij, iwan ok onkaj miek lugar.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ijkuakón iteko okilwij itekipanoj: “Xiwia ipan ojmej iwan itech tlalmej, iwan xikintokti ma kalakikan para ma temi nokalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porke Nej namechilwia ke nion se de nekatej katlej achtoj onikinminbitaroj mach tlakuas itech notiotlakantlakual.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miekej tlakaj oyayaj iwan Jesús. Iwan Yej omokuepke iwan okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tla akaj kineki witz nowan, iwan okachi kitlasojtlas ipapan, imaman, isiwa, ipilwan, ikniwan iwan asta inemilis, mach welis yetos nomomachtijkaw tla okachi kintlasojtlas yejwan iwan amo yen Nej. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Akin amo kinekis witz nowan iwan amo kinekis tlajyowis asta komo para ma kimiktikan itech krus, mach welis yetos nomomachtijkaw. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tla akaj de amejwan kineki kichiwas se kale, ¿amo achtoj motlalis kichiwas kuenta para kixyejyekos kox kajxilis tlan kipia para welis kitlamis? ");
INSERT INTO nhyNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tla kichiwa in cimiento iwan satepan mach weli kitlamia, nochtin akinmej kitaskej pewas kipinawiskej ");
INSERT INTO nhyNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","iwan kijtoskej: “Yin tlakatl opéj kichiwa se kale, iwan mach owelik okitlamij.” ");
INSERT INTO nhyNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O noso tla se rey kineki kipias guerra iwan oksé rey, ¿amo achtoj motlalis para kixyejyekos kox ika majtlaktle mil soldadojtin welis mokitzkis iwan oksé rey katlej witz ika senpoale mil soldadojtin? ");
INSERT INTO nhyNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Iwan tla amo welis, nijkuak in oksé rey ok wejka witz, ijkuakón kintitlanilis sekimej itlatitlanilwan para ma motlapojpolwikan para ayakmo momagaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ijkón kiné, tla se de amejwan amo kikawas nochi tlan kipia, mach welis yetos nomomachtijkaw. ");
INSERT INTO nhyNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’In istatl sa tekitl kuale, pero tla in istatl kipolos ipuyeka, ¿kenik oksemi puyeyas? ");
INSERT INTO nhyNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mach ok welis se kitekipanoltis nion para yen tlale iwan nion para majada, sino sa se kitlamotla. Akin kineki kimomakas kuenta, ma kikaki. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nochtin katlej tlakobraroaj ika impuestos iwan tlajtlakolejkej omololoayaj inawak Jesús para kikakiskej, ");
INSERT INTO nhyNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","iwan por yonik in fariseos iwan tlamachtijkej de itlanawatil in Moisés opéj tlapoaj de Yej, okijtoayaj: ―Yin tlakatl moneloa inwan tlajtlakolejkej, iwan inwan tlakua. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ijkuakón Jesús okinmilwij in yin ejemplo: ");
INSERT INTO nhyNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tla se de amejwan kipia se siento ichkamej iwan kipolos se, ¿amo kinkajtewas in nawinpoale iwan kaxtole iwan nawi ichkamej kan tlajpixtos, iwan yas kitemotij ichka katlej opoliwik, asta kan kajsis? ");
INSERT INTO nhyNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iwan tla yokajsik, kimokechpanoltia ika pakilistle, ");
INSERT INTO nhyNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","iwan ejko ichan, kinmololoa iamigoswan iwan ibesinoswan iwan kinmilwia: “Nowan xipakikan, porke yonikajsik nochka katlej onikpolojka.” ");
INSERT INTO nhyNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nej namechilwia, itech ilwikak no ijkón tlamochiwa. Ompa onkaj miek pakilistle nijkuak se tlajtlakolej moyolkuepa de itlajtlakol, ke por nawinpoale iwan kaxtole iwan nawi yolchipawakej katlej mach ok moneki moyolkuepaskej de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’¿Tlan kichiwa se siwatl tla kipia majtlaktle tomin de plata iwan kipoloa se? ¿Amo kitlikuitia se tlanextle iwan tlachpana yolik ikalijtik asta ijkuak kajsi itomin? ");
INSERT INTO nhyNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iwan nijkuak kajsi, kinmololoa amigaswan iwan ibesinaswan iwan kinmilwia: “Nowan xipakikan, porke yonikajsik notomin katlej onikpolojka.” ");
INSERT INTO nhyNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nej namechilwia, iangelwan in toTajtzin Dios noijki pakij miek nijkuak se tlajtlakolej moyolkuepa de itlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús noijki okijtoj: ―Se tlakatl okinpiaya omen itelpokawan, ");
INSERT INTO nhyNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","iwan katlej okachi xokoyotl okilwij ipapan: “Papan, xinechmaka in herencia katlej nechtokaroa.” Tonses in tetaj okinxejxelilij tlan okipiaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kanaj keski tonale satepan, in telpochtle katlej okachi xokoyotl okinamakak nochi tlan okimakak ipapan, iwan oyáj wejka itech oksé estado, kan san okawiltij itomin iwan mach kuale tlan okichijtinemia. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nijkuak otlanke okitlajtlamij itomin, owalaj se apistle itech nekáj estado, iwan yej mach ok okipiaya tlan kikuas. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Satepan oyáj okitemoto tekitl inawak se tlakatl de yon estado, yon tlakatl okimakak tekitl iwan okititlanke itlalaj ma kinmonekuitlawiti pitzomej. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Iwan okinekia kikuani xiwitl itoka algarrobas katlej okikuayaj in pitzomej, pero mach akaj okimakaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Ijkuakón opéj moomelia (moyejyekoa) iwan okimolwij: “Nochan katej tekipanojkej katlej kipiaj miek tlan kikuaj, iwan nej nian nipanotok apistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nimokuepas inawak nopapan, iwan nikilwis: Papan, onitlajtlakoj inawak Dios iwan onitlajtlakoj monawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mach ok notech powi para xinechita kej nimokone, xinechita sa kej nekatej tlakaj katlej mitzpalewiaj.” ");
INSERT INTO nhyNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Tonses omoketzke iwan omokuepke ichan ipapan. ’Nijkuak ok wejka owalaya, ipapan okitak iwan okiknomatke. Omotlaloj okinamikito, okinanapaloj (okinawajtekke) iwan okixpijpipitzoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ijkuakón itelpoch okilwij: “Papan, onitlajtlakoj inawak Dios iwan onitlajtlakoj monawak. Mach ok notech powi xinechita kej nimokone.” ");
INSERT INTO nhyNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ipapan okinmilwij itekipanojkawan: “Xikkualkuikan totoka katlej okachi kuale tzotzole, iwan xiktzotzoltikan. Xikaniyojtikan itech imajpil iwan xikkaktikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Xikualwikakan in torojkonetl katlej tomawak iwan xikmiktikan. Tikkuaskej iwan tikchiwaskej ilwitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Porke yin nokone yomikka, iwan axan oksemi omoyolkuik. Opolika, iwan axan yotikajsikej.” Iwan opéj kichiwaj ilwitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Oksé itelpoch katlej tetiachka otekipanojtoka itlalaj. Iwan nijkuak omokuepato iwan yoejkotiwalaya ichan, okikakke tlapitzaj ichan iwan okinmitak mijtotiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ijkuakón okinotzke se katlej ompa tekipanoa iwan okitlajtlanij tlan onkaj ichan. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","In tekipanoj okilwij: “Mokni yomokuepato. Iwan mopapan otlanawatij ma kimiktikan in torojkonetl katlej tomawak, porke mokni oejkok kuale iwan chikawak.” ");
INSERT INTO nhyNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","In telpochtle katlej tetiachka sa tekitl okualanke iwan mach okinekia kalakini ikalijtik. In tetaj okiske iwan opéj kitlatlawtia ma kalaki. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero itelpoch okilwij ipapan: “Tejwatzin kuale tikmati nik ya miek xiwitl nimitztekipanoa, nochipa nimitztlakita, iwan mach semi tinechmaka nion se tentzonkonetl para nikchiwas se ilwitl inwan noamigoswan. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero axan oejkok yin mokone, katlej san okawiltij motomin inwan siwamej momekatijkej, iwan asta otikmiktilij se torojkonetl tomawak.” ");
INSERT INTO nhyNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ijkuakón ipapan okilwij: “Nokone, tej nochipa nowan tikaj, iwan nochi tlan nikpia moaxka. ");
INSERT INTO nhyNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero axan moneki tikchiwaskej ilwitl iwan ma tipakikan, porke mokni yomikka, iwan axan yomoyolkuik. Opolika, iwan axan yotikajsikej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús noijki okinmilwij imomachtijkawan: ―Oyeka se tlakatl katlej okimopialiaya iwan okipiaya se itekipanoj katlej okitaya nochi tlan okipiaya. Pero iteko okilwijkej ke itekipanoj san kawiltilia tlan iaxka. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ijkuakón iteko okinotzke itekipanoj iwan okilwij: “¿Tlanik ijkón nechilwiaj de tej? Xinechmaktili nochi in kuenta de tlan titekipanojtiwitz, porke mach ok tietos tinotekipanoj.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ijkuakón in tekipanoj okimolwij: “¿Axan tlan nikchiwas porke noteko nechkixtilis in tekitl? Mach nikxikos nitekipanos ika ajsalon, iwan nipinawa nimijtlanijtinemis. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya nikmati tlan nikchiwas, para ke nijkuak nechkixtis noteko nikinpias akinmej nechresibiroskej inchan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Tonses okinnotzke katlej okiwikiliayaj iteko. Katlej achtoj okinotzke okilwij: “¿Kexkich tikwikilia in noteko?” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iwan yej okijtoj: “Nikwikilia se siento barriltin de aseite.” In tekipanoj okilwij: “Nian kajki moresibo. Niman ximotlali iwan xikchiwa oksé resibo san de tlajko siento barriltin.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Satepan okitlajtlanij oksé katlej kiwikilia iteko: “Tej, ¿kexkich tikwikilia in noteko?” Iwan yej okilwij: “Se siento koxtal de trigo.” Tonses in tekipanoj okilwij: “Nian kajki moresibo. Xikchiwa oksé resibo san de nawinpoale koxtal.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nijkuak okimatke iteko, okijtoj nik in yon itekipanoj omotlalij listo porke okitemoj kenik kichiwas satepan. Porke in tlaltikpaktlakaj okachi listojtin para kitekipanoltiskej itlaj tlamantle iwan amo ken ikonewan Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Nej namechilwia ke okachi kuale xiktekipanoltikan in rikojyotl katlej onkaj ixko yin tlaltikpak, para ijkón xiwelikan xikinpiakan namoamigoswan, iwan nijkuak tlamis in rikojyotl welis amechresibiroskej kan anchantiskej nochipa. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Akin kimati kitekipanoltia itlaj tlamantle tzikitzin ika kuale iyolo, tonses noijki welis kitekipanoltis itlaj tlamantle miek. Iwan akin amo kimati kitekipanoltia itlaj tlamantle tzikitzin porke mach kipia kuale iyolo, tonses noijki mach welis kitekipanoltis itlaj tlamantle miek. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Axan kiné, tla itech in rikojyotl katlej onkaj ixko yin tlaltikpak namejwan mach ankitekipanoltiaj ken moneki, tonses mach welis amechmaktiliskej katlej melawak rikojyotl. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Iwan tla namejwan mach kuale ankitekipanoltiaj itlaj tlamantle katlej amo amoaxka, tonses mach welis amechaxkatiskej itlaj tlamantle para xiktekipanoltikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Mach akaj tekipanoj welis kinpias ome itekowan, porke welis kitlasojtlas in se iwan oksé mach kitlasojtlas, o noso welis kitlakitas in se iwan oksé mach kitlakitas. Mach welis ankitekipanoskej in Dios mientras amechyoltilantok in rikojyotl. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","In fariseos katlej okiwelitayaj tomin, okikaktokaj nochi tlan Jesús okijtoaya iwan san okiwetzkiliayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Tonses Jesús okinmilwij: ―Namejwan anmochiwaj ke yeskia melawak ankualtin inmixpan tlakaj, pero Dios kixmati namoyolo. Onkaj tlamantle katlej in tlakaj kiweyimatij, pero toTajtzin Dios kikokolia. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Itlanawatil in Moisés iwan intlamachtil in profetajtin omotekipanoltijkej asta ijkuak owalaj in Juan Tlakuateekij. Desde ijkuakón motematiltijtiwitz in kuale tlajtole de kenik Dios tlanawatia. Iwan axan nochtin mochijchikawaj kinekij kalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Okachi mach owij pojpoliwis in ilwikak iwan tlaltikpak, ke se letra katlej ijkuilitok itech itlanawatil in Moisés amo ma mochiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tla se tlakatl kikawa isiwa iwan monamiktia iwan oksé siwatl, kijtosneki ya kimomekatia. Iwan akin monamiktia iwan se siwatl katlej omokajkaj iwan iokich, noijki kijtosneki ya kimomekatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Oyeka se tlakatl katlej okimopialiaya. Omotzotzoltiaya ika tzotzole moradotik sa tekitl patíoj iwan omochijchiwaya kej yeskia se rey. Iwan momostla okichiwaya ilwitl iwan okikowaya miek tlakuale katlej sa tekitl kuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Noijki oyeka se pobre itoka Lázaro, katlej nochi itlalnakayo otentoka de tzotzotl. Iwan omotlaliaya ipan tlale ikaltempan in tlakatl katlej okimopialiaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Yon pobre okinekia kikuani tlan owetzia de ipan imesa in tlakatl katlej okimopialiaya. Iwan asta in itzkuinmej okipajpaliliayaj itzotzowan. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Se tonale in pobre omikke, iwan angelestin okiwikakej inawak Abraham kan ilwikak. In tlakatl katlej okimopialiaya noijki omikke, iwan okitookakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","In tlakatl katlej okimopialiaya sa tekitl otlajyowiaya ijtik tliko, oajkopantlachixke iwan okitak de wejka in Abraham iwan Lázaro. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ijkuakón otzajtzik okijtoj: “Papan Abraham, xinechiknomati, iwan xiknawati in Lázaro ma kisiawa imajpil, iwan ma wiki ma kiseseliki nonenepil. Porke sa tekitl nitlajyowia ijtik yin tlitl.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham okilwij: “Nokone, xikelnamiki nik in tej otikpixke miek tlamantle nijkuak otinemia ixko in tlaltikpak, iwan Lázaro opanok miek tlamantle mach kuale. Axan yej nian kipia pakilistle, iwan tej titlajyowia. ");
INSERT INTO nhyNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iwan onkaj se tlamantle katlej sa tekitl tlawejkatlan katlej techxelojtok. Iwan akinmej kinekiskej yaskej de nian para ompa, mach weliskej, nion akinmej kinekiskej witzej de ompa para nian noijki mach weliskej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Tonses in tlakatl katlej okimopialiaya okilwij: “Nimitztlatlawtia kiné, papan Abraham, xiktitlani in Lázaro ichan nopapan, ");
INSERT INTO nhyNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","kan nikinpia makuiltin nokniwan, para ma kintlapowiti, iwan ijkón amo ma wikikan yejwan noijki itech yin tlajyowilistle.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham okilwij: “Yejwan kipiaj tlan okijkuiloj in Moisés iwan tlan okijkuilojkej in profetajtin. Ma kikakikan tlan yejwan kijtaj.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","In tlakatl katlej okimopialiaya okinankilij: “Amo, mach ijkón, papan Abraham, pero tla akaj katlej yomikke iwan moyolkuis (moyolitis) oksemi iwan yas kintlapowiti, yejwan moyolkuepaskej de intlajtlakol.” ");
INSERT INTO nhyNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham okilwij: “Tla amo kinekij kikakiskej itlajtol in Moisés iwan intlajtol in profetajtin, tonses maski ma moyolkui akaj tlakatl no mach kinekiskej kikakiskej maski ma kintlapowi.” ");
INSERT INTO nhyNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús okinmilwij imomachtijkawan: ―Nochipa yetos tlan ika tlajtlakoskej in tlakaj. Pero ¡pobre in tlakatl katlej kitoktis akaj oksé ma wetzi ipan tlajtlakole! ");
INSERT INTO nhyNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Okachi kuale ma kilpilikan ikechtlan se metlatl iwan ma kitlamotlakan ijtik atl, ke ma kitokti ma wetzi ipan tlajtlakole se de yinmej tzitzikinmej. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Xikpiakan kuidado. ’Tla se mokni tlajtlakoa motech, xiknotza iwan xikajwa. Tla mitzkaki iwan moyolpejpena (moyolkuepa), xiktlapojpolwi. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Maski ma tlajtlako motech chikome buelta se tonale, iwan chikome buelta witz monawak mitzilwiki: “Mach ok ijkón nikchiwas”, in tej xiktlapojpolwi. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","In tlatitlaniltin okilwijkej in Señor: ―Xitechmaka okachi tlaneltokalistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ijkuakón in Señor okinmilwij: ―Tla amejwan ankipianij tlaneltokalistle, maski tzikitzin kej isemiya in mostaza, welini ankilwianij yin sicomorojkuawitl: “Ximowiwitla de nian iwan ximotooka ijtik atl”, iwan kuawitl amechtlakitani. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tla akaj de amejwan kipia se itekipanoj iwan tla yomokuepato otlaxawato o noso otlajpiato, ¿kox ankilwiaj: “Xiwiki ximotlali xitlakua”? ");
INSERT INTO nhyNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Amo, sino ankilwiaj: “Xinechchiwili tlan nikuas, xiktlejtlejkolti momakamisa iwan xinechtlamaka asta ma tlami ma nitlakua iwan ma natli. Satepan tej welis titlakuas iwan tatlis.” ");
INSERT INTO nhyNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Kox ankitlasojkamatij namejwan namotekipanoj por kichiwa tlan ankinawatiaj? Namejwan kuale ankimtij nik amo. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijkón noijki namejwan, nijkuak antlamiskej ankichiwaskej nochi tlan Dios amechnawatia, moneki xikijtokan: “Tejwan mach tikualtin titekipanojkej, porke mach otikchijkej okachi de tlan otechnawatijkej ma tikchiwakan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nijkuak Jesús oonewak para Jerusalén, opanok ik estado de Samaria iwan ik estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nijkuak oajsik itech se pueblojtzin, owalajkej okinamikikoj majtlaktin tlakaj katlej opalania innakayo, pero san wejka omoketzkej ");
INSERT INTO nhyNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","iwan otzajtzikej chikawak: ―¡Jesús, Tlamachtij, xitechiknomati! ");
INSERT INTO nhyNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nijkuak in Jesús okinmitak, okinmilwij: ―Xiwian ximoteitititij innawak in tiopixkej. Iwan nijkuak yoyayaj ipan ojtle, opajtikej iwan ochipawikej itech innakayo. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ijkuakón se de yejwan, nijkuak omotlatak yochipawik de ikokolis, omokuepke, kiweyikixtijtiw in toTajtzin Dios chikawak. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Omotlankuaketzke iyakapan Jesús, asta okitennamikke in tlale iwan omotlasojkamatke inawak. Yon tlakatl oyeka de estado de Samaria. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ijkuakón Jesús okijtoj: ―¿Amo anmajtlaktin katlej anpajtikej? ¿Kanin katej in oksekimej chiknawin? ");
INSERT INTO nhyNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿San yen yin tlakatl katlej mach judío omokuepke para kiweyikixtis in Dios? ");
INSERT INTO nhyNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Tonses in Jesús okilwij in tlakatl: ―Ximoketza iwan xiwia. Otipajtik porke otinechneltokak. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","In fariseos okitlajtlanijkej in Jesús keman ajsis tonale nijkuak Dios pewas tlanawatis. Iwan Jesús okinnankilij: ―In tlakaj mach welis kitaskej nijkuak Dios pewas tlanawatis. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nimpor mach kijtoskej: “Xikitakan, nian kajki”, o noso “Xikitakan nepa kajki”. Porke Dios ya tlanawatijtok ipan inyolo in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ijkuakón okinmilwij imomachtijkawan: ―Ajsis tonale namejwan ankinekiskej annechitaskej Nej katlej onimochij nitlakatl iwan ankinekiskej oksemi ma nieto amowan, pero mach ok annechitaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iwan sekimej tlakaj amechilwiskej: “Xikitakan, nian kajki”, o noso “Xikitakan, ne kajki.” Amo xikneltokakan, nion amo xiwian xinechtemotij. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Porke ijkón ken nijkuak tlapetlani ik se lado de itech ilwikak iwan tlawia asta itech oksé lado de ilwikak, ijkón Nej noijki akin onimochij nitlakatl ik nowian (nian nepa) nechitaskej itech nekáj tonale nijkuak niwitz. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero achtoj moneki nitlajyowis miek, iwan nechkokoliskej in tlakaj katlej nemij itech yinmej tonaltin. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ijkón ken otlamochij itech nekáj tiempo de Noé, no ijkón tlamochiwas nijkuak niwitz Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","In tlakaj otlakuayaj iwan okoniaj, omonamiktiayaj iwan okintlajtlaniaj ichpokamej. Ijkón okichijtokaj asta itech nekáj tonale nijkuak in Noé okalakke ijtik in weyi barko, iwan ijkuakón omokajkaj in tlamawisolkiawatl iwan nochtin okinpojpoloj. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ijkón noijki otlamochij itech nekáj tiempo de Lot: otlakuayaj iwan okoniaj, otlakowayaj iwan otlanamakayaj, otlatookayaj iwan okalchiwayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero nijkuak Lot okiske de itech weyikan de Sodoma, owetzke tlitl iwan azufre de ilwikak, iwan nochtin okinmiktij. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijkón noijki tlamochiwas itech nekáj tonale nijkuak niwalmonextis Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Itech nekáj tonale, tla akaj yetos ipan ikal, amo ma temo para kikixtiti tlan kipia itech ikalijtik. Iwan tla akaj kajki itlalaj, amo ma walmokuepa para ichan. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xikelnamikikan tlan omochij isiwa in Lot. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Akin kinekis kipalewis inemilis, kipolos. Pero akin kipolos inemilis por Nej, kipalewis inemilis. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Namechilwia nik in yon yuak kochtoskej omen ipan se tlapechtle. Se kiwikaskej iwan oksé kikajtewaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Omen siwamej sepantistoskej inkalijtik. Se kiwikaskej iwan oksé kikajtewaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Omen tlakaj sepantekipanojtoskej intlalaj. Se kiwikaskej iwan oksé kikajtewaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nijkuak ijkón okikakej, okitlajtlanijkej: ―¿Kan ijkón tlamochiwas, Señor? Iwan Jesús okinnankilij: ―Kan wetos se mikkatl, ompa mololoskej in tzojpilomej. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús okinmilwij se ejemplo para kinmachtis nik moneki se motiotzajtzilis nochipa, iwan amo se ma mosotlawa. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Okinmilwij: ―Oyeka itech se pueblo se jues katlej mach okimakasia in Dios, iwan okinkokoliaya nochtin tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Itech yon pueblo oyeka noijki se viuda, katlej okonitaya in yon jues para ma kipalewi itech se pleito porke okinekiaj kitojtoktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Opanok miek tonale in jues mach okinekia kipalewis, pero satepan okimolwij: “Maski mach nikimakasi in Dios iwan maski nikinkokolia in tlakaj, ");
INSERT INTO nhyNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nikpalewis in yin siwatl, porke san mokueptok nechwaliita, para ayakmo okachi ma nechkuejso iwan ma nechyolajxiti.” ");
INSERT INTO nhyNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iwan Señor okijtoj: ―Xikkakikan tlan okijtoj in mach kuale jues. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿In Dios kox amo welis kinpalewis noijki itlapejpenalwan, katlej tonayan iwan yuak kimotlatlawtiliaj ma kinpalewi? ¿Kox wejkawas para kinpalewis? ");
INSERT INTO nhyNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nej namechilwia nik mach wejkawas. Pero Nej katlej onimochij nitlakatl nijkuak niwitz, ¿kox ok nikinmajsiki in tlakaj katlej tlaneltokaj nonawak ixko yin tlaltikpak? ");
INSERT INTO nhyNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús okinmilwij oksé ejemplo, okinmilwij katlej momachiliaj kualtin tlakaj iwan okinmitayaj kej yeskia mach itlaj inpatij in oksekimej. Okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Omen tlakaj oyajkej kan weyi tiopan omotiotzajtzilitoj: se oyeka fariseo, iwan oksé oyeka tlakobraroj ika impuestos. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","In fariseo omoketoka iwan omotiotzajtzilijtokaj ijkín: “Dios, nimitztlasojkamachilia porke nej mach nikchiwa ken oksekimej, katlej ichtekej, katlej mach kualtin iwan katlej momekatijkej. Iwan nion mach nikchiwa ken yin tlakobraroj ika impuestos. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nej nimosawa (niayunaroa) ome buelta se samana, iwan nimitzmaka in diesmo de nochi tlan niktlani.” ");
INSERT INTO nhyNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero in tlakatl katlej tlakobraroj ika impuestos san wejka omoketzke iwan nion mach omixewiaya ajkopantlachias, sino san omoelpantlatziniaya iwan okijtoaya: “¡Dios, xinechiknomati, porke nej nitlajtlakolej!” ");
INSERT INTO nhyNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nej namechilwia nik in yon tlakobraroj ika impuestos omokuepke para ichan ya chipawak de itlajtlakol. Pero in fariseo amo. Porke akin moweyinekis, mopinatis. Pero akin amo moweyinekis, weyikistos (weyititos). ");
INSERT INTO nhyNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","In tlakaj okinwalinwikayaj inpilalakkonewan para Jesús ma kintlali imawan inpan. Pero nijkuak imomachtijkawan okitakej, opéj kinmajwaj katlej okinwalinwikayaj in pilalaktin. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús okinnotzke iwan okinmilwij: ―Xikinkawakan in pilalaktin ma wikikan nonawak, amo xikintzatzakuilikan. Porke in tlakaj katlej yolyamankej ken pilalaktin, kalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ipan melajka namechilwia, akin amo kikawilis Dios ma tlanawati ipan iyolo ken se chokotzin kimokawilia, in yon tlakatl mach kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Se tlakatl tlayekanke judío okitlajtlanij in Jesús: ―Tlamachtij, tejwatzin tikuale tlakatl, ¿tlan moneki nikchiwas para nikpias nemilistle katlej mach keman tlamis? ");
INSERT INTO nhyNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús okilwij: ―¿Tlanik tinechilwia nikuale tlakatl? Mach onkaj oksé kuale tlakatl sanwel yen Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ya tikmati tlan kijtaj in tlanawatiltin: “Amo ximomekati, amo xitemikti, amo xitlachteki, amakaj xiktlajtoltlatlalili, xiktlakita mopapan iwan momaman.” ");
INSERT INTO nhyNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","In tlakatl okilwij: ―Nochi in yon nikchijtiwitz desde nichokkoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nijkuak ijkón okikakke in Jesús, okilwij: ―Oksé tlamantle mitzpoloa tikchiwas: xiknamaka nochi tlan tikpia iwan in tomin xikinmaka in pobrestin. Ijkón tikpias rikojyotl ompa ilwikak. Iwan nompa, xiwiki nonawak iwan pewa xinemi nowan. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero yon tlakatl nijkuak ijkón okikakke, sa tekitl omoyolkokoj, porke sa tekitl okimopialiaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nijkuak Jesús okitak nik sa tekitl omoyolkokoj yon tlakatl, okijtoj: ―Sa tekitl owij para nekatej katlej kimopialiaj kalakiskej kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Okachi mach owij para se kameyo panos kan kuyontok in akuxaj, ke para se katlej kimopialia kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iwan katlej ijkón okikakej okijtojkej: ―Tonses, ¿akin kiné welis momakixtis? ");
INSERT INTO nhyNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús okinmilwij: ―Tlan amo welij kichiwaj in tlakaj, Dios weli kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro okilwij: ―Señor, tejwan otikajtejkej nochi tlan otikpiayaj para tiaskej mowan. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ijkuakón Jesús okinnankilij: ―Ipan melajka namechilwia, ke akin okikajtej ikal, o noso ipapan, o noso ikniwan, o noso isiwa, o noso ipilwan, para kichiwas tlan Dios kinawatia, ");
INSERT INTO nhyNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kiresibiros okachi miek de tlan okikajtej. Kiresibiros okachi miek itech yin tiempo, iwan kipias nemilistle katlej mach keman tlamis itech nekáj tiempo katlej satepan yetos. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús okinwikak ik se lado in majtlaktle iwan omen imomachtijkawan, iwan okinmilwij: ―Axan ma tiwian para Jerusalén, kan mochiwas nochi tlan okijkuilojkej in profetajtin de yen Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nechtemaktiskej (nechtemaktiliskej) inmak in tlakaj katlej mach judiojtin, nechpijpinatiskej, nechwikaltiskej iwan nechchijchijchaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Iwan satepan de nechwitekiskej, nechmiktiskej. Pero ipan eyi tonale nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yejwan mach okimomakakej kuenta tlan okinmilwij, nion mach okimatiaj de tlanon okintlapowiaya. Mach okimomakakej kuenta yon tlamantle porke ok otlatitoka para yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nijkuak Jesús yoajsitiaya itech weyikan de Jericó, se tlakatl katlej mach tlachia oewatoka itempan ojtle omoijtlanijtoka. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nijkuak okikakke opanoayaj miekej tlakaj ik ompa, in tlakatl katlej mach tlachia otlajtlanke tlan tlamochiwa. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Iwan okilwijkej nik in Jesús de Nazaret ik ompa panotiw. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ijkuakón otzajtzik chikawak okijtoj: ―¡Jesús, iKone in David, xinechiknomati! ");
INSERT INTO nhyNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Katlej oyayaj tlayakapan okajwakej para ma mokamatzakua, pero yej okachi chikawak otzajtzik: ―¡Jesús, iKone in David, xinechiknomati! ");
INSERT INTO nhyNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tonses in Jesús omoketzke iwan otlanawatij ma kiwalwikilikan. Nijkuak oejkok iyakapan, okitlajtlanij: ");
INSERT INTO nhyNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tlan tikneki ma nimitztokti? In tlakatl katlej mach tlachia okijtoj: ―Señor, nikneki nitlachias. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús okilwij: ―¡Xitlachia! Motlaneltokalis yomitzmakixtij. ");
INSERT INTO nhyNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","San niman ijkuakón in tlakatl ya owelik otlachixke. Satepan yej oyáj iwan Jesús kiweyikixtijtiw in toTajtzin Dios. Iwan nochtin in tlakaj katlej okitakej, noijki okiweyikixtijkej in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Satepan Jesús okalakke itech weyikan de Jericó iwan onejnentiaya itech se ojtle, ");
INSERT INTO nhyNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","iwan ompa oyeka se tlakatl katlej okimopialiaya itoka Zaqueo, katlej tlayekanke tlakobraroj ika impuestos, ");
INSERT INTO nhyNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","iwan yon Zaqueo okinekia kixmatis in Jesús. Pero mach owelia okitaya porke oyekaj sa tekitl miekej tlakaj iwan Zaqueo oyeka chaparrotzin. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ijkuakón omotlaloj tlayakapan, iwan para welis kitas in Jesús, otlejkok itech se kuawitl itoka sicómoro serka de kanik Jesús panos. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nijkuak Jesús opanok ik ompa, otlachixke ik ajkopan iwan okilwij: ―Zaqueo, xitemo totoka, porke axan nikneki nimokalotis mokalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Tonses in Zaqueo otemok totoka, iwan okiresibiroj in Jesús ika pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nijkuak ijkón okitakej, nochtin opéj kipojpoaj, okijtoayaj ke Jesús okalakke omokalotito ichan se tlakatl tlajtlakolej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Satepan Zaqueo omoketzke iwan okilwij in Señor: ―Señor, nikinmakas in pobrestin tlajko de nochi tlan nikpia. Iwan tla akaj onikajkayaj para oniktlachtekij, nikkuepilis nawi buelta okachi de tlan onikixtilij. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús okilwij: ―Axan yomomakixtijkej in tlakaj de yin kale. Porke yin Zaqueo noijki walajtok nelwatl de Abraham iwan tlaneltoka ken Abraham otlaneltokak. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Porke Nej katlej onimochij nitlakatl oniwalaj onikintemoko iwan onikinmakixtiko katlej mopolojtokej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mientras in tlakaj okikakiaj yon tlajtole, Jesús okinmilwij se ejemplo, porke yoyeka serka de Jerusalén iwan yejwan okiyejyekoayaj nik in Dios san niman ya pewas tlanawatis ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ijkuakón okinmilwij: ―Oyeka se tlakatl katlej kimopialia iwan weyikistok (weyititok), oyáj wejka para kiresibiros itekiwajkayo de rey iwan satepan oksemi walmokuepas. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antes de yas, okinnotzke majtlaktin itekipanojkawan, kada se okimakak se tomin katlej miek ipatij, iwan okinmilwij: “Xiktekipanoltikan yin tomin para xiktlanikan okachi mientras ma nimokuepati.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero in tlakaj de ipueblo okikokoliayaj, iwan por yonik okintitlankej sekimej tlakaj para ma kijtotij: “Mach tiknekij yin tlakatl ma technawati kej rey.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero okiresibiroj itekiwajkayo de rey, iwan omokuepke para ipueblo. Nijkuak oejkok, okintekuitlanke itekipanojkawan katlej okinmakak in tomin, para kimatis kexkich okitlanke kada se. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Achtoj se oejkok iwan okijtoj: “Señor, motomin okitlanke majtlaktle buelta okachi.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","In rey okinankilij: “Kuale kajki. Tej tikuale titekipanoj. Iwan komo kuale otiktekipanoltij tlan san tzikitzin onimitzmakak, por yonik axan nimitztlalis xitlanawati itech majtlaktle pueblojtin.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Oksé oejkok iwan okijtoj: “Señor, motomin okitlanke makuile buelta okachi.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","In rey noijki okilwij: “Tej noijki nimitztlalis xitlanawati itech makuile pueblojtin.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Satepan oksé oejkok iwan okijtoj: “Señor, nian kajki motomin. Oniktlaatij ika se panito. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Porke onimitzimakaske, porke tejwatzin wel chikawak titlanawatia, iwan tikmoaxkatia tomin katlej mach otiktlanke iwan tikmopixkia tlan amo otiktookak.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ijkuakón in rey okilwij: “Tej mach tikuale titekipanoj, ika tlan tej monewian yotikijtoj ika yon nimitztlajtlakoltis. Tla tikmati nik chikawak nitlanawatia, iwan nikmoaxkatia in tomin katlej mach oniktlanke iwan nikmopixkia tlan amo oniktookak, ");
INSERT INTO nhyNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿tlanik amo otikkawato notomin itech banko, para nijkuak niejkoni, nikresibiroani notomin iwan ikoneyo?” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iwan okinmilwij katlej ompa oyekaj: “Xikixtilikan in tomin katlej onikmakak, iwan xikmakakan katlej kipia majtlaktle tomin.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Iwan yejwan okilwijkej in rey: “Pero Señor, yej ya kipia majtlaktle tomin.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero in rey okinmilwij: “Nej namechilwia, ke akin kipia, kimakaskej okachi miek. Iwan akin amo kipia, kikixtiliskej asta yen tzikitzin tlan kipia. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iwan nekatej nokontraswan katlej mach kinekij ma nieto nirey para ma nikinnawati, xikinwalinwikakan iwan noixpan xikinmiktikan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Satepan de ijkón okijtoj, Jesús oksemi oonewak para weyikan de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nijkuak ya onajsitiw itech pueblo de Betfagé iwan itech pueblo de Betania, ya serka kan kajki in Olivostepetl, ijkuakón okintitlanke ome imomachtijkawan, ");
INSERT INTO nhyNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","okinmilwij: ―Xiwian itech nekáj pueblojtzin katlej kajki ne tlayakapantzin, iwan nijkuak anmajsitiwej ankitaskej se burro ilpitok, katlej mach ya semi akaj ipan tlejko. Xiktotomakan iwan xikualwikakan. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tla akaj amechtlajtlanis tlanik ankitotomaj, xikilwikan nik in Señor kineki. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Imomachtijkawan oyajkej, iwan okajsitajsikej nochi ken Jesús okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Iwan nijkuak okitotontokaj in burro, itekowan in burro okintlajtlanijkej: ―¿Tlanik ankitotomaj in burro? ");
INSERT INTO nhyNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Iwan yejwan otlanankilijkej: ―Porke in Señor kineki. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ijkuakón okiwikilijkej in Jesús, okinkixtijkej intlakenwan iwan okinkentilijkej in burro iwan ipan okitlejkoltijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nijkuak Jesús oyaya ipan burro, in tlakaj okinsojtiayaj intlakenwan ipan ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iwan nijkuak Jesús oajsik kan pewa temolistle de kan Olivostepetl, nochtin se monton imomachtijkawan opéj tzajtzij chikawak ika pakilistle iwan okiweyikixtiayaj in toTajtzin Dios por nochtin in milagrostin katlej yokitakej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Okijtoayaj: ―¡Ma Dios kitiochiwa in Rey katlej okualtitlanke in toTajtzin Dios! ¡Ma tlayolosewto itech ilwikak, iwan ma tikweyikixtikan toTajtzin Dios katlej kajki ilwikak! ");
INSERT INTO nhyNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ijkuakón sekimej fariseos katlej ompa oyekaj inwan in tlakaj, okilwijkej in Jesús: ―Tlamachtij, xikinmajwa momomachtijkawan katlej ijkón kijtaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús okinnankilij: ―Nej namechilwia, tla yejwan mokamatzakuaskej, in temej tzajtziskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nijkuak oajsito serka de itech weyikan de Jerusalén, iwan nijkuak okitak, ochokak, ");
INSERT INTO nhyNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","iwan okijtoj: ―¡Ay, Jerusalén! ¡Ojalá tikmomakani kuenta itech yin tonale katlej mitzmakani yolosewilistle! Pero axan mach tikmomakas kuenta porke Dios yomitztlaatilij. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Porke witzej tonaltin, nijkuak mokontraswan mitzyawaloskej iwan mitztlatzakuiskej. Ik nowian (nian nepa) mitzyawaloskej iwan mitzmagaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mitztlamotlaskej ipan tlale. Kinmiktiskej katlej motech chantij, iwan mach kikawaskej nion se tetl nepanitos ipan oksé tetl. Porke mach otikmomakak kuenta nijkuak Dios omitzitako para mitzmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Satepan Jesús okalakke ijtik in weyi tiopan iwan opéj kinkixtia de ompa katlej otlanamakayaj iwan katlej otlakowayaj, ");
INSERT INTO nhyNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iwan okinmilwij: ―Itech tiotlajkuilole kijta: “Nokal yetos kale de tiotzajtzilistle”. Pero namejwan ya ankikuepkej se kale de ichtekej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nochi tonale Jesús otlamachtiaya itech weyi tiopan. Pero in tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés, iwan in tlayekankej de itech yon weyikan opéj kitemoaj kenik welis kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero mach okajsiaj kenik kichiwaskej, porke nochtin in tlakaj okinekiaj kikakiskej nochi tlan Jesús okijtoaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se tonale nijkuak Jesús oyeka kan weyi tiopan okinmachtijtoka in tlakaj, iwan okinmatiltijtoka in kuale tlajtole katlej temakixtia, ijkuakón oejkokej in tlayekankej tiopixkej iwan in tlamachtijkej de itlanawatil in Moisés, iwan in tlayekankej tetajtzitzintin judiojtin, ");
INSERT INTO nhyNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","iwan okilwijkej: ―Xitechilwi, ¿ika tlan tlanawatijkayotl tikchiwa in yin tlamantle? ¿Akin omitzmakak in yon tlanawatijkayotl? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ijkuakón Jesús okinnankilij: ―Nej noijki namechtlajtlanis se tlajtole. Xinechnankilikan: ");
INSERT INTO nhyNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Akin okinawatij in Juan ma tlakuateeki? ¿Yen Dios okinawatij, o noso yen tlakaj okinawatijkej? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ijkuakón opéj kimolwiaj entre yejwan ijkín: ―¿Ken tikilwiskej? Tla tikijtoskej yen Dios okinawatij, techilwis: “¿Tlanik kiné mach ankineltokakej?” ");
INSERT INTO nhyNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iwan tla tikijtoskej yejwan in tlakaj okinawatijkej, nochtin in tlakaj techmiktiskej ika tetl, porke yejwan kuale kimatij nik in Juan oyeka profeta de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iwan okinankilijkej ke mach kimatij akin okinawatij in Juan ma tlakuateeki. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Tonses in Jesús okinmilwij: ―Pues Nej noijki mach namechilwis ika tlan tlanawatijkayotl nikchiwa in yon tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Satepan Jesús opéj kintlapowia in tlakaj, iwan okinmilwij yin ejemplo: ―Oyeka se tlakatl katlej okitookak miek uvas, iwan satepan okinkajtewilij sekimej tekipanojkej para ma kimonekuitlawikan iwan satepan kimokawiskej tlaatlajko de tlan tlakis, iwan oyáj de ompa iwan owejkawato kan oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nijkuak ya kuale para kitekiskej in uvas, okititlanke se itekipanoj innawak in yonmej tekipanojkej para ma kitlajtlaniti tlan kitokaroa. Pero in tekipanojkej okimagakej iwan okikuepkej san ijki. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Satepan iteko in uvasyoj okititlanke oksé itekipanoj. Pero noijki okimagakej. San tlan amo okilwijkej iwan okikuepkej san ijki. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iteko in uvasyoj oksemi okititlanke oksé itekipanoj, pero in tekipanojkej noijki okikojkokojkej iwan okikixtijkej kalan. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Satepan, iteko in uvasyoj okimolwij: “¿Tlan nikchiwas? Niktitlanis notlasojkone. Nijkuak kitaskej, xamo kitlakitaskej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero nijkuak in tekipanojkej okitakej, okimolwijkej se iwan oksé: “Yin ikone yen katlej kimokawis tlan iaxka in tetaj. Ma tikmiktikan, para tejwan tikmoaxkatiskej in uvasyoj.” ");
INSERT INTO nhyNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ijkuakón okikixtijkej in tekone de kan uvasyoj iwan okimiktijkej. Satepan Jesús okintlajtlanij: ―Axan kiné, ¿tlan kichiwas iteko in uvasyoj? ¿Tlan kintoktis in tekipanojkej? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yon iteko in uvasyoj yas iwan kinmixpolos nekatej tekipanojkej, iwan iuvasyoj kinmakas oksekimej para ma kimonekuitlawikan. Nijkuak in tlakaj ijkón okikakej, okijtojkej: ―¡Amo ma Dios kimonekilti! ");
INSERT INTO nhyNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús okintlatak, iwan okijtoj: ―¿Tlan kijtosneki kiné tlan kijta in tiotlajkuilole? Kan kijta: In tetl katlej in kalchijkej mach okixitakej, omochij yen tetl katlej okachi kichikajtok in kale. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Iwan akin wetzis ipan yon tetl, pojpostekis. Iwan tla in tetl wetzis ipan akaj, kikuejkuechos. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","In tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés okinekiaj kikitzkianij in Jesús itech yon ora, porke okimomakakej kuenta nik okinkajkakitij ika yon ejemplo. Pero mach okikitzkijkej, porke okinmiimakasiaj in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Satepan okintitlankej sekimej tlakaj para ma kixpiakan in Jesús iwan omochiwayaj kej kualtin tlakaj, para welis kikakiskej itlaj tlajtole katlej ika welis kimayawiskej iwan ijkón welis kitemaktiskej (kitemaktiliskej) imak in gobernador. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Por yonik yejwan okitlajtlanijkej in Jesús: ―Tlamachtij, tikmatij nik tikijta tlan melawak iwan noijki titlamachtia tlan melawak, iwan tejwatzin mach tikinmita in tlakaj kox rikojtin o noso pobrestin, sino titlamachtia ipan melajka kenik se nemis ken Dios kineki. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Xitechilwi: ¿Kox kuale se kitlaxtlawas impuesto para César o noso amo? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero Jesús okimatia nik mach kuale tlan okiyejyekojtokaj iwan nik okinekiaj kimayawiskej ika itlaj tlajtole. Iwan okinmilwij: ―¿Tlanik ankinekij annechmayawiskej ika itlaj tlajtole? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Xinechititikan se tomin. ¿De akin ixko iwan akin itoka katlej nestok itech yin tomin? Yejwan okijtojkej: ―De César. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tonses in Jesús okinmilwij: ―Pues xikmakakan in César tlan de yen César, iwan xikmakakan Dios tlan de yen Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iwan mach owelikej okitlajtolmayajkej de tlan okijtoaya inmixpan tlakaj. Sino okachi sa omotlajtlachialtiayaj (omomajmawtiayaj) de kenik otlanankiliaya, iwan mach ok itlaj okijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Satepan, sekimej saduceos oyajkej okitatoj in Jesús. In yonmej saduceos mach kineltokaj kox welis moyolkuiskej (moyolitiskej) in mikkamej. Iwan okitlajtlanijkej in Jesús: ");
INSERT INTO nhyNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Tlamachtij, Moisés otechkajtewilij ijkuilitok, ke tla se tlakatl omonamiktij, miki iwan mach okipixke nion se ikone iwan isiwa, ikni in difunto kipia de monamiktis iwan yon viuda para kinpias ikonewan para ijkón welis yeskej kej yeskia ikonewan in difunto. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Axan kiné, oyekaj chikomen iknimej. In yankuiotl achtoj omonamiktij, pero omikke iwan mach okinpixke ikonewan. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Oksé ikni katlej kiwaltoka omonamiktij iwan yon viuda, iwan noijki omikke iwan mach okinpixke ikonewan. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ijkuakón oksé katlej kiwaltoka omonamiktij iwan yon viuda, iwan ijkón okichijkej nochtin in oksekimej, iwan san ken chikomen iknimej omikkej iwan mach okipixkej nion se inkone. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Satepan noijki omikke in viuda. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tonses, nijkuak moyolkuiskej (moyolitiskej) in mikkamej, ¿katlij yen de yonmej chikomen yetos isiwa? Porke nochtin chikomen omonamiktijkej iwan yon siwatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tonses in Jesús okinnankilij: ―Itech yin tlaltikpak, in tlakaj iwan siwamej monamiktiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero nijkuak in tlakaj iwan siwamej moyolkuiskej oksemi de itech inmikilis, iwan katlej Dios kinkawilis ajsiskej ompa ilwikak, mach ok motlajtlaniskej iwan nion mach ok monamiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Porke mach ok mikiskej. Yeskej kej angelestin, iwan yeskej ikonewan in Dios porke yokinyolitij. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Inewian Moisés, okiteititij nik in mikkamej moyolkuiskej, kan tlapoa de se kuatlanwitztle katlej otlatlaya. Kan Dios okilwij in Moisés nik yen Dios de Abraham, de Isaac iwan de Jacob. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Iwan Dios amo Dios de mikkamej, sino de katlej yolitokej. Porke nochtin katlej iaxkawan Dios, yonmej nochtin yolitokej. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ijkuakón sekimej tlamachtijkej de itlanawatil in Moisés okilwijkej: ―Tlamachtij, kuale tlan otikijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iwan mach ok omixewijkej ok itlaj okitlajtlanijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ijkuakón Jesús okinmilwij: ―¿Tlanik kijtaj nik in Cristo katlej Dios okipejpenke yen ikone in David? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porke inewian in David kijta itech libro de Salmos: In toTajtzin Dios okilwij in noSeñor yin tlajtole: “Ximotlali ik noyekma, ");
INSERT INTO nhyNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","asta ijkuak Nej nimitztlalis titlayekanke de yejwan katlej mitzkokoliaj.” ");
INSERT INTO nhyNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Tla inewian David okinotzke in Cristo “noSeñor”; ¿kenik kiné in Cristo ma yeto iKone in David? ");
INSERT INTO nhyNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nochtin in tlakaj otlakaktokaj nijkuak in Jesús okinmilwij imomachtijkawan: ");
INSERT INTO nhyNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ximotlachilikan de yen tlamachtijkej de itlanawatil in Moisés, porke kiwelitaj nemiskej ika intlaken weweyak, iwan kinekij ma kinyektlajpalokan nijkuak nemij tiankistle. Iwan itech tiopanmej kiwelitaj motlaliskej kan motlaliaj in tlayekankej, iwan kitemoaj motlaliskej kan okachi kuale lugar itech ilwimej. ");
INSERT INTO nhyNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iwan yejwan noijki kinkixtiliaj inkalwan in viudajtin, iwan tlaixkajkayawaj motiotzajtziliaj sa tekitl para ma kinmitakan kichiwaj tlan kuale. Por yonik in yejwan kitlaxtlawaskej okachi weyi intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús oyeka ijtik in weyi tiopan iwan ompa okinmitak in tlakaj katlej kimopialiaj, okonkajkawayaj intomin ijtik in kaja kan mololoa in ofrenda. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Noijki ompa okitak se viuda pobre katlej okonkajkaj ijtik in yon kaja ome tomintzitzintin de cobre. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iwan Jesús okijtoj: ―Ipan melajka namechilwia, nik in yin viuda pobre okonkajkaj okachi miek ke nochtin oksekimej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porke nochtin konkajkawaj intomin katlej kinsobraroa, pero yin viuda pobre okonkajkaj nochi tlan okipiaya tlan ika motlamakani. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nijkuak sekimej omotlapowijtokaj de yen weyi tiopan, iwan de yen temej kualtzitzintin, iwan de yen tlamantin kualtzitzintin katlej ompa oyekaj kej ofrendajtin, ijkuakón Jesús okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ajsis tonale nijkuak nochi yin tlamantle katlej namejwan axan ankitaj xitinis, iwan nion se tetl mach ok mokawas nepanitos ipan oksé tetl. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ijkuakón okitlajtlanijkej: ―Tlamachtij, ¿keman ijkón tlapanos? ¿Tlan señas tikitaskej nijkuak ijkón pewas tlapanos? ");
INSERT INTO nhyNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús okijtoj: ―Xikpiakan kuidado de amakaj ma amechkajkayawa. Porke miekej witzej ika notoka kijtoskej: “Nej niCristo”, iwan noijki kijtoskej: “Yoajsik ora.” Pero amo xikinneltokilikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nijkuak ankimatiskej onkaj guerra iwan momagaj ik nowian (nian nepa), amo ximomawtikan, porke ijkón kipia de tlapanos achtoj. Pero ijkuakón mach ya tlamis in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús noijki okinmilwij: ―Se país momagas iwan oksé país, iwan se pueblo momagas iwan oksé pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Miek lado tlalolinis chikawak, yetos apistle iwan yetos kokolistle. Motaskej tlamantin temajmawtijkej iwan señalestin wejweyin de ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Pero achtoj, namejwan amechtlatlalochtiskej, amechkukuyotzaskej asta itech tiopanmej iwan asta itech telpiloyan, iwan amechwikaskej inyakapan reytin iwan inyakapan gobernadortin. Ijkón anpanoskej por annechneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pero ijkuakón namejwan xikintlapowikan de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Iwan xikchiwakan de amo ximotlanemililtikan de kenik antlanankiliskej para anmopalewiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porke Nej namechmakas tlajtole iwan tlalnamikilistle ke namokontraswan mach kixikoskej iwan nion mach weliskej amechnankiliskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iwan asta amotajwan, amokniwan, amoparienteswan, iwan amoamigoswan yejwan mismo amechtemaktiskej (omechtemaktiliskej). Sekimej de amejwan amechmiktiskej, ");
INSERT INTO nhyNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","iwan nochtin in tlakaj amechkokoliskej por Nej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero nion se amotzonkal de amotzontekon mach poliwis. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tla anmoyekketoskej itech namotlaneltokalis, se tonale welis anmomakixtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Nijkuak ankitaskej in weyikan de Jerusalén yokiyawalojkej miekej soldadojtin, xikmatikan nik san niman kixixititzaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ijkuakón katlej yeskej Judea ma cholokan asta ipan tepemej. Katlej yeskej itech weyikan de Jerusalén ma kisakan de ompa, iwan katlej yeskej intlalaj amo ma mokuepakan oksemi para Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porke itech nekatej tonaltin Dios kintlajyowiltis in tlakaj katlej mach kuale otetoktijkej, para ma mochiwa nochi tlamantle tlan kijta in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Pobrestin in siwamej katlej itech nekatej tonaltin kipiaskej inkone intlalaxko iwan katlej yeskej selikkonewajkej! Porke yetos weyi tlajyowilistle ixko yin tlaltikpak, iwan ikualanilis in Dios witz inpan yinmej tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sekimej mikiskej itech guerra, iwan oksekimej kintzakuaskej itech oksekimej paismej. Iwan katlej mach judiojtin ipan tlajtlaksaskej in weyikan de Jerusalén, asta kan Dios kijtos ma tlami yon tiempo de ijkón ma kichiwakan in tlakaj katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Ijkuakón motaskej señalestin itech tonale, itech metztle iwan itech sitlaltin. Iwan itech tlaltikpak in tlakaj momajmawtiskej iwan mach ok kimatiskej tlanon kichiwaskej, porke in atl kukuyokas chikawak iwan motlatlamotlas. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","In tlakaj sa tekitl momawtiskej asta kuatleyuiliskej de nemajmawtile nijkuak kimomakaskej kuenta tlan tlapanos ixko yin tlaltikpak. Porke asta in chikawalistin katlej katej ilwikak papatlakaskej (bibiokaskej). ");
INSERT INTO nhyNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ijkuakón kemaj nechitaskej, Nej katlej onimochij nitlakatl, niwitz ijtik mixtle ika nopoder iwan ika nomawisotlanex. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nijkuak pewas ijkón tlapanos, ximoyolojchikawakan iwan xiajkopantlachiakan, porke niman namechmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesús noijki okinmakak yin ejemplo: ―Xikitakan in igoskuawitl, o noso itlaj oksé kuawitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nijkuak ankitaj pewa selia, namejwan ankimatij yoajsiko in tiempo de tonalko. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ijkón noijki, nijkuak ankitaskej pewas panoskej in yonmej tlamantin, xikmatikan nik ya meroj pewas tlanawatis in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Ipan melajka namechilwia, nik nochi in yin tlapanos antes de mikiskej in tlakaj de yin tiempo. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","In ilwikak iwan yin tlaltikpak mach ok yetoskej, poliwiskej, pero notlajtol mach poliwis, kipia de mochiwas. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Xikpiakan kuidado. Amo xiyoltlakuawakan ika tlan amo kuale. Amo san xitlakuajtinemikan, amo xitlawantinemikan iwan nion amo xikkawilikan in tlanemilile de yin nemilistle ma amechijtlako. Porke Nej san nonkisaki itech nekáj tonale, iwan amo nikneki ijkón namechajsiki. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porke yetos kej se trampa katlej kinkitzkis nochtin tlakaj katlej nemij ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xiijsatokan kiné. Ximotiotzajtzilijtokan nochi tonale para amo xipanokan itech yonmej tlamantin katlej panoskej, para ijkón welis anmajsitiwej noyakapan Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús otlamachtiaya tonayan itech weyi tiopan, iwan de yuak oyaya kan Olivostepetl iwan ompa omokawaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iwan nochtin tlakaj oyayaj kan weyi tiopan nochi kualkan para kikakiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yoajsia ilwitl nijkuak mokua in pan katlej mach kipia levadura, kijtosneki yen ilwitl de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","In tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés okitemoayaj kenik kimiktiskej in Jesús, pero mach oweliaj porke okinmiimakasiaj in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ijkuakón Satanás okalakke ipan iyolo in Judas, katlej kinotzaj Iscariote. Yej oyeka se de yejwan majtlaktle iwan omen imomachtijkawan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Oyáj okinmitato iwan okintlapowito in tlayekankej tiopixkej iwan tlayekankej de tiopan, de kenik kinmaktilis in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yejwan opakej iwan okilwijkej kimakaskej tomin. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas okijtoj kuale kajki iwan opéj kitemoa kenik kitemaktis (kitemaktilis) nijkuak mach ma kimomakakan kuenta in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oajsiko yon tonale de ilwitl nijkuak mokua in pan katlej mach kipia levadura, nijkuak kimiktiaj se ichkatzin para ika kelnamikij nijkuak in Dios okinkixtij de Egipto. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Iwan Jesús okintitlanke in Pedro iwan Juan ika yin tlanawatile: ―Xiwian xikchiwatij in tiotlakantlakuale de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yejwan okitlajtlanijkej: ―¿Kan tikneki ma tikchiwatij? ");
INSERT INTO nhyNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús okinnankilij: ―Nijkuak ankalakiskej itech weyikan, ankinamikiskej se tlakatl katlej kitki iaxoktzin. Xiwian ikuitlapan asta itech kale kan yej kalakis, ");
INSERT INTO nhyNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","iwan xikilwikan iteko in kale: “In Tlamachtij kijta: ¿Katlij yen kuarto kan nikmomajsewis in tiotlakantlakuale de pascua inwan nomomachtijkawan?” ");
INSERT INTO nhyNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ijkuakón yej amechititis se weyi kuarto ik ajkopan, ya tlayektlalitok. Ompa xikchiwakan in tiotlakantlakuale. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yejwan oyajkej iwan okajsitajsikej nochi ken Jesús okinmilwij, iwan okichijkej in tiotlakantlakuale de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nijkuak oajsik ora, Jesús iwan itlatitlanilwan omotlalijkej itech mesa. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ijkuakón Jesús okinmilwij: ―Ya wejkawitl niknektiwitz nikuas amowan yin tiotlakantlakuale de pascua antes de nimikis. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pues namechilwia nik mach ok semi nikuas, asta ijkuak ma mochiwa de tlanon kijtosneki in yin tlakuale kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Satepan okitilanke in kopa, omotlasojkamatke inawak Dios iwan okijtoj: ―Xikonikan yin, iwan xikmoxejxelilikan aminochtin namejwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pues namechilwia nik mach ok semi nikonis iayo uvas asta ma ejko in tonale nijkuak in Dios pewas tlanawatis. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Satepan, okitilanke in pan iwan omotlasojkamatke inawak Dios. Satepan okipojpostekke in pan iwan okinmakak imomachtijkawan. Okijtoj: ―Yin yen notlalnakayo, iwan niktemaka por yen namejwan. Xikchiwakan yin para ika xinechelnamikikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","No ijkón okichij ika in kopa, satepan de otiotlakantlakuajkej, okijtoj: ―Yin kopa kijtosneki yen yankuik akuerdo katlej mochiwas ika noeso, iwan nokiwis por amejwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero xikitakan, in tlakatl katlej nechtemaktis (nechtemaktilis), nowan kajki itech mesa. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Melawak, Nej katlej onimochij nitlakatl nimikis ijkón ken Dios kimonekiltia. Pero ¡pobre in tlakatl katlej nechtemaktis! ");
INSERT INTO nhyNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ijkuakón entre yejwan opéj motlajtlaniaj akin de yejwan ijkón kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Noijki opéj motlatlajtolkuepaj akin de yejwan okachi weyikistok. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús okinmilwij: ―In reytin de ixko yin tlaltikpak mochiwaj kej tekomej itech paismej kan tlanawatiaj. Iwan tlakaj kinmilwiaj “tekiwajkej katlej kichiwaj tlan kuale”. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero namejwan mach ijkón xikchiwakan. Sino, akin kineki weyikistok de amejwan, kipia de kintekipanos nochtin oksekimej ijkón ken se telpochtle kimonekuitlawia se tetajtzin. Iwan akin okachi tlayekantos, ma mochiwa kej se tlapalewij. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Akin okachi weyikistok, katlej motlalia itech mesa o noso katlej tetlamaka? ¿Amo yen katlej motlalia itech mesa? Pero Nej maski namotlayekanke, nikaj amowan ken se katlej tetlamaka. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Namejwan nochipa ya antlajyowijtinenkej nowan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Por yonik, Nej namechtlalis para xitlanawatikan, ijkón ken noPapan Nej onechtlalij ma nitlanawati. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Namejwan antlakuaskej iwan antlaoniskej itech nomesa ompa kan nitlanawatis. Anmotlaliskej ipan siyajtin para ankimixkomakaskej in majtlaktle iwan ome familias de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","In Señor noijki okijtoj: ―Simón, Simón, xikkaki. Satanás yokitlajtlanke para amechtzejtzelos ken trigo. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero Nej yonikmotlatlawtilij in Dios para amo xikpolo motlaneltokalis. Iwan nijkuak oksemi timokuepas nonawak, xikinpalewi mokniwan para ma moyekketokan itech intlaneltokalis. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón okilwij: ―Señor, nimotemaka nias mowan maski ma nechtzakuakan o noso maski ma nechmiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús okilwij: ―Pedro, nimitzilwia nik axan, antes de tzajtzis in kaxtil, ijkuakón tej yotikijtoj eyi buelta nik mach tinechixmati. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ijkuakón Jesús okintlajtlanij: ―Nijkuak onamechtitlanke iwan onamechilwij amo xikitkikan itlaj bolsa, nion tomin, nion kaktle, ¿kox itlaj oamechpoloj? Yejwan okijtojkej: ―Mach itlaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tonses okinmilwij: ―Pero axan, akin kipia ibolsa, ma kitki iwan noijki ma kitki imorral. Iwan akin amo kipia iespada ma kinamaka itzotzol iwan ma kimokowi se iespada. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Porke namechilwia nik kipia de mochiwas notech yin tlan kijta in tiotlajkuilole: “Okitakej kej yeskia se tlakatl mach kuale.” Porke nochi tlan kajki ijkuilitok de Nej, kipia nik mochiwas. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ijkuakón yejwan okijtojkej: ―Señor, nian katej ome espadajtin. Jesús okinmilwij: ―Ya kuale kajki, ayakmo itlaj xikijtokan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Satepan Jesús okiske. Ijkón ken Yej okimatia okichiwaya, oyáj ipan Olivostepetl. Imomachtijkawan noijki oyajkej ikuitlapan. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nijkuak Jesús ompa oajsito, okinmilwij: ―Ximotiotzajtzilikan, para amo amopan ma wiki in Amo Kuale Tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesús omijkuanij de innawak iwan oyáj ik se lado wejkatzin ken nijkuak se kitlamotla se tetl de wejka, ompa omotlankuaketzke iwan omotiotzajtzilij. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Okijtoj: ―Papan, tla tejwatzin tikmonekiltia, xinechmakixti de itech yin tlajyowilistle. Pero amo ma mochiwa ken Nej nikneki, sino ken tejwatzin tikmonekiltia. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ijkuakón okimonextilij se ángel de ilwikak para kimakas chikawalistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Iwan nijkuak omoyolkokojtoka sa tekitl, omotiotzajtziliaya okachi. Wejweyi itonil ochipinia ipan tlale kej estle. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nijkuak otlanke omotiotzajtzilij, omoketzke iwan oyáj kan oyekaj imomachtijkawan, iwan okinmajsitajsik kochtokej, porke in sotlawalistle iwan neyolkokole okinkochpachoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jesús okinmilwij: ―¿Tlanik ankochij? Ximewakan, iwan ximotiotzajtzilikan para amo amopan ma wiki in Amo Kuale Tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús ok otlapojtoka, iwan ijkuakón oejkokej miekej tlakaj. Katlej itoka Judas, katlej oyeka se de yen majtlaktle iwan omen imomachtijkawan Jesús, okualinyekanaya. Omijkuanij inawak Jesús iwan okixpipitzoj. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ijkuakón Jesús okilwij: ―Judas, ¿ijkín tinechixpipitzoa para tinechtemaktia (techtemaktilia) Nej katlej onimochij nitlakatl? ");
INSERT INTO nhyNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Katlej oyekaj iwan Jesús, nijkuak okitakej tlan pewa tlapanoa, okitlajtlanijkej: ―Señor, ¿tikneki ma tikmomagakan inwan ika espada? ");
INSERT INTO nhyNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iwan se de yejwan okinakastzontekke se tlakatl itekipanoj in tlayekanke tiopixke, okitzontekilij iyeknakas. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús okijtoj: ―Xikinkawakan. Ya kuale kajki. Ijkuakón Jesús okitzkilij inakas in yon tlakatl iwan opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesús okinmilwij in tlayekankej tiopixkej, in tlayekankej de tiopan iwan tlayekankej tetajtzitzintin, katlej owalajkej okikitzkikoj: ―¿Anwalajkej annechkitzkikoj ika espada iwan ika kuawitl kej yeskia niichtekke? ");
INSERT INTO nhyNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nochipa onieka amowan itech weyi tiopan, iwan mach annechkitzkijkej. Pero itech yin ora Dios amechkawilia xikchiwakan tlan amejwan ankinekij, iwan tlan kineki in Amo Kuale Tlakatl katlej tlanawatia ijtik tlatleyualotl. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iwan ijkuakón okitzkijkej in Jesús, iwan okiwikakej ichan tlayekanke tiopixke. Pedro san wejka okonitiaya. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ompa tlatlajko patio, in tlakaj okitlalijkej se tlikuile, iwan omotlalijkej okiyawalojkej. Pedro noijki omotlalij intzalko. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Satepan se tlapalewijkasiwatl, nijkuak okitak in Pedro ewatok iyakapan tlikuile, okitlatak kuale iwan okijtoj: ―Yin tlakatl noijki onemia iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero in Pedro mach okimokuitij, iwan okijtoj: ―Siwatl, nej mach nikixmati. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Achitzin satepan, oksé tlakatl okitak iwan okilwij: ―Tej noijki se de yejwan. Pero in Pedro okijtoj: ―Amo, nej mach inwan nipowi. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kej se ora satepan, oksé okiyekijtoj: ―Ipan melajka, yin tlakatl onemia iwan Jesús, porke yin noijki de estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ijkuakón Pedro okijtoj: ―Tlakatl, mach nikmati tlan tikijta. Iwan san niman ijkuakón, nijkuak in Pedro ok otlapojtoka, otzajtzik in kaxtil. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ijkuakón in Señor omokuepke iwan okitlatak in Pedro, iwan Pedro okelnamikke tlan Señor okilwijka: “Axan, antes de tzajtzis in kaxtil, ijkuakón tej yotikijtoj eyi buelta nik mach tinechixmati.” ");
INSERT INTO nhyNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iwan ijkuakón Pedro okiske iwan ochokak sa tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","In tlakaj katlej okipixtokaj in Jesús, okipinawiayaj iwan okiwitekiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Okixilpiayaj iwan okixwijwitekiaj, iwan okilwiayaj: ―¡Tla xitlajto (xikadibinaro), akin omitzmaak! ");
INSERT INTO nhyNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iwan san tlan amo okilwiayaj para ika okipijpinatijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nijkuak otlaneske, omololojkej in tlayekankej tetajtzitzintin judiojtin, in tlayekankej tiopixkej, iwan tlamachtijkej de itlanawatil in Moisés, iwan okiwikakej in Jesús kan tlaixkomakaj (tlatzonmanaj) in judiojtin. Ompa okitlajtlanijkej: ");
INSERT INTO nhyNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Xitechilwi, ¿kox tej in tiCristo? Yej okinnankilij: ―Tla namechilwis nik yen Nej, namejwan mach annechneltokiliskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Iwan tla itlaj namechtlajtlanis, mach annechnankiliskej, iwan nion mach annechkajkawaskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iwan desde axan Nej katlej onimochij nitlakatl niewatos ik iyekma in toTajtzin Dios katlej kipia nochi poder. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ijkuakón nochtin okitlajtlanijkej: ―¿Tonses kijtosneki tej titeKone de Dios? Jesús okinnankilij: ―Aján, yen Nej. Ijkón ken namejwan ya ankijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Tonses yejwan okijtojkej: ―Mach ok moneki ok akaj ma kistlakawi. Yotikkakej tlan Yej inewian yokimokuitij. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ijkuakón nochtin omoketzkej, iwan okiwikakej in Jesús inawak Pilato. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ompa opéj kistlakawiaj, okijtoayaj: ―Otikajsikej yin tlakatl kinkuatlapololtijtinemi in tlakaj. Kijta nik mach moneki se kitlaxtlawas impuestos para César, iwan kijta nik yen Cristo, kijtosneki Yej se Rey. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Tonses in Pilato okitlajtlanij: ―¿Yen tej tiRey de judiojtin? Jesús okinankilij: ―Ijkón ken tej tikijta. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ijkuakón Pilato okinmilwij in tlayekankej tiopixkej iwan tlakaj: ―Mach itlaj tlajtlakole nikkajxilia yin tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero yejwan okachi chikawak okijtojkej: ―Kinkuatlapololtijtinemi in tlakaj ika itlamachtil itech nochi in estado de Judea. Opéj kinkuatlapololtia itech estado de Galilea, iwan axan asta nian ijkón kichijtinemi. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nijkuak in Pilato ijkón okikakke, otlajtlanke kox in Jesús Yej de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Nijkuak okilwijkej nik in Yej de ompa, ijkuakón okititlanke inawak Herodes, katlej oyeka gobernador de yon estado de Galilea, katlej noijki ompa omajsia itech weyikan de Jerusalén itech yonmej tonaltin. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nijkuak Herodes okitak in Jesús, Herodes sa tekitl opakke. Ya wejkawitl okinekia kitas, porke okikakia otlapoayaj de Yej, iwan okinekia kitas ma kichiwa se milagro. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes miek okitlatlajtlanij, pero Jesús mach itlaj okinankilij. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ompa oyekaj noijki in tlayekankej tiopixkej iwan tlamachtijkej de itlanawatil in Moisés, katlej okistlakawiayaj chikawak ika miek tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tonses Herodes iwan isoldadojwan okitojtoktijkej san tlan amo iwan okipinawijkej, okitzotzoltijkej ika se kuale tzotzole ijkón ken motzotzoltia se rey. Satepan Herodes oksemi okititlanke inawak Pilato. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Itech yon tonale Pilato iwan Herodes omochijkej amigostin. Porke achtoj mach omoyekwikayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Satepan Pilato okinmololoj in tlayekankej tiopixkej, in tekiwajkej iwan nochtin in tlakaj, ");
INSERT INTO nhyNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","iwan okinmilwij: ―Namejwan annechwalwikilijkej yin tlakatl, ankijtaj kinkuatlapololtijtinemi in tlakaj. Pero nej yoniktlatzintokij amoixpan, iwan ya ankitakej nik mach itlaj onikkajxilij itlaj tlan amo kuale de tlan ika amejwan ankitilwiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nion Herodes mach itlaj okajxilij, porke oksemi onechwaltitlanilij. Yin tlakatl mach itlaj okichij komo para ma se kimikti. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","San nitlanawatis ma kiwitekikan iwan satepan nikkajkawas. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato ijkón okinmilwij, porke kada xiwitl itech ilwitl de pascua in tekiwajkej romanostin okipiayaj kostumbre de okikajkawayaj se preso. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nochtin opéj kuawtzajtzij: ―¡Xikmikti yon tlakatl iwan xikkajkawa in Barrabás! ");
INSERT INTO nhyNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yon Barrabás okitzakej telpiloyan porke okintlatlalwij miekej tlakaj ma momagakan iwan gobierno ompa itech weyikan de Jerusalén, iwan noijki porke otemiktij. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato oksemi okintlapowij in tlakaj, porke okinekia kikajkawani in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero yejwan oksemi otzajtzikej chikawak: ―¡Xikmajmasolti itech krus! ¡Xikmajmasolti itech krus! ¡Ma miki! ");
INSERT INTO nhyNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilato okinmilwij ya eyi buelta: ―¿Tlanik? ¿Kox itlaj okichij mach kuale? Nej mach itlaj nikkajxilia itlaj tlan mach kuale komo para ma se kimikti. Nitlanawatis ma kiwitekikan iwan satepan nikkajkawas. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yejwan okachi otzajtziaj chikawak, okijtoayaj ma kimajmasoltikan itech krus. Yejwan iwan tlayekankej tiopixkej sa tekitl otzajtzikej, asta kan okajsikej tlan okinekiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ijkuakón kiné in Pilato okichij tlan yejwan okinekiaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iwan ijkón, okikajkaj in tlakatl katlej otzaktoka por okintlatlalwijka in tlakaj ma momagakaj iwan gobierno iwan por otemiktij. Porke yejwan ijkón okitlajtlankej. Pero Pilato okinmaktilij in Jesús para ma kitoktikan san tlan yejwan kinekiskej. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nijkuak opéj kiwikaj in Jesús para kimajmasoltiskej itech krus, ijkuakón okikitzkijkej se tlakatl de estado de Cirene itoka Simón, katlej owalaya de itlalaj, iwan okitoktijkej ma kimama in krus iwan ma kitki ikuitlapan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Miekej tlakaj oyayaj ikuitlapan Jesús, iwan noijki oyayaj miekej siwamej katlej ochokayaj iwan otzajtziaj de neyolkokole por Yej. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesús omokuepke iwan okinmilwij: ―Namejwan ansiwamej de Jerusalén, amo xichokakan por Nej, sino xichokakan por amejwan iwan por amopilwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porke ajsis tonale nijkuak ijkín mijtos: “Ma pakikan in siwamej katlej mach welij kinpiaj inkonewan, iwan katlej mach keman okintlakatilijkej inkonewan, iwan katlej mach keman otlachichitijkej.” ");
INSERT INTO nhyNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ijkuakón in tlakaj pewas kinmilwiskej in tepemej: “Topan xiwetzikij”, iwan kinmilwiskej in tepetzitzintin: “Xitechtlaatikan.” ");
INSERT INTO nhyNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tla Nej katlej mach nikpia tlajtlakole nipanoa tlajyowilistle, ¿kenik amo ma panokan tlajyowilistle in oksekimej katlej kipiaj tlajtlakole? No ken se kuawitl xoxowik, tla welij kichichinoaj maski xoxowik, ¿kenik amo ma kichichinokan katlej wakke? ");
INSERT INTO nhyNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Noijki okinwikayaj omen tlakaj katlej mach kualtin para kinmiktiskej itech krus iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nijkuak oajsitoj itech nekáj lugar kan kitokayotiaj Mikkatzontekomatl, ompa okimajmasoltijkej itech krus in Jesús, iwan noijki okinmajmasoltijkej omen tlakaj katlej mach kualtin: se ik iyekma in Jesús iwan oksé ik iopochma. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nijkuak in Jesús okimajmasoltijkej itech krus, okijtoj: ―Papan, xikintlapojpolwi, porke mach kimatij tlan kichiwaj. In soldadojtin omotlankej para kitaskej kenik kimoxejxeliliskej entre yejwan itzotzol in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Miekej tlakaj ompa otlachixtokaj. In tekiwajkej sa tekitl okiwetzkiliayaj in Jesús, okijtoayaj: ―Okinmakixtij oksekimej. Axan Yej inewian ma momakixti, tla melawak yen Cristo katlej Dios okipejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","In soldadojtin noijki okiwetzkiliayaj in Jesús, omijkuanijkej inawak iwan okimakakej ma koni iayo uvas xokok, ");
INSERT INTO nhyNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","iwan okilwiayaj: ―Tla tej tiRey de judiojtin, ximomakixti tej monewian. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iwan ikuapak okipiaya se letrero ijkuilitok ika tlajtole griego, latín iwan hebreo, okijtoaya: “YIN YEN REY DE JUDIOJTIN.” ");
INSERT INTO nhyNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Se de yen omen tlakaj katlej mach kualtin katlej ompa opilkatoka itech krus, noijki san tlan amo okilwij, okijtoj: ―Tla tej tiCristo, monewian ximomakixti, iwan xitechmakixti in tejwan noijki. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero in oksé katlej noijki mach kuale, okajwak iwan okilwij: ―¿Amo tikimakasi in Dios, maski ya tikmati nik san sekan timikiskej? ");
INSERT INTO nhyNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tejwan technamiki ma techtlajyowiltikan, porke ya tiktlaxtlajtokej tlan otikchijkej, pero yin tlakatl mach itlaj okichij. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iwan okilwij in Jesús: ―Jesús, xinechelnamiki itech nekáj tonale nijkuak oksemi tiwalmuikas para titlanawatis. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús okinankilij: ―Ipan melajka nimitzilwia, axan tias nowan itech paraíso. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nijkuak oajsik kej tlajko tonale, otlatleyuak itech nochi in tlaltikpak iwan owejkaj asta las tres de tiotlakke. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","In tonale mach ok otlawij, iwan kortina de yen weyi tiopan otlajkotzayanke. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ijkuakón Jesús otzajtzik chikawak: ―Papan, ipan momatzin niktlalia noanima. Nijkuak otlanke ijkón okijtoj, omikke. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nijkuak in kapitan romano okitak tlan otlamochij, okiweyikixtij in toTajtzin Dios, okijtoj: ―Yin tlakatl melawak nik oyeka kuale tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nochtin in tlakaj katlej ompa oyekaj iwan okitakej nochi tlan otlamochij, omokuepkej moyolkokojtiwej iwan moelpantlatzinijtiwej. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero nochtin katlej inwan omixmatia in Jesús, iwan siwamej katlej owalajkej iwan Jesús desde estado de Galilea, san wejka omokajkej konitokej nochi yon tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Oyeka se tlakatl itoka José. Oyeka kuale tlakatl iwan oyeka yolchipawak inawak Dios, ipueblo itoka Arimatea katlej kajki itech estado de Judea. José noijki tewan opowia kan tlaixkomakaj (tlatzonmanaj) in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José okichiaya keman Dios pewas tlanawatis, iwan yej mach inwan oyeka san se tlajtole in tlakaj katlej powij kan tlaixkomakaj, porke okitak nik mach ijki tlan okitoktijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ijkuakón oyáj okitato in Pilato iwan okitlajtlanilij ma kikawili ma kitki itlalnakayo in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Satepan de okitemowij de itech krus, okikimiloj ika se sábana iwan okitlalij ijtik se mikkakuyoktle katlej okikuyonijkej itech se tepejxitl, kan mach ya semi akaj kitookaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iwan itech yon tonale oyeka nijkuak otlayektlaliayaj in judiojtin, para amo tekipanoskej nijkuak walmostlatis porke ya weyi tonale, iwan itech yon tonale in judiojtin mosewiaj. Iwan yoajsia ora para pewas in weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","In siwamej katlej owalajkej iwan Jesús desde estado de Galilea, noijki oyajkej iwan José. Yejwan okitakej in mikkakuyoktle, iwan okitakej kenik okitlalijkej itlalnakayo in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Nijkuak omokuepkej inkalijtik, okiyektlalijkej sekin ajwiakayotl iwan sekin aseite para kaltiliskej itlalnakayo in Jesús. Iwan nijkuak oajsik in weyi tonale, omosewijkej ijkón ken kijta itlanawatil Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","In yakinika tonale de yen samana, in siwamej omokuepkej kan mikkakuyoktle san kualkan mach ya owalkisaya in tonale, okitkiaj in ajwiakayotl katlej okiyektlalijkej. Oksekimej siwamej noijki inwan oyayaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Nijkuak oajsikej kan mikkakuyoktle, okajsitajsikej in tetl katlej ika okamatzaktoka, yoyeka ik se lado. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iwan nijkuak okalakej tlijtik, mach okajsikej itlalnakayo in Señor Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mach ok okimatiaj tlan kichiwaskej, iwan ijkuakón okinmitakej omen tlakaj moketokej ik innakastlan, otlakentitokaj ika intlaken petlantok. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","In siwamej omomawtijkej iwan omotlankuaketzkej iwan omotoolojkej asta ipan tlale. Pero in yonmej tlakaj okinmilwijkej in siwamej: ―¿Tlanik ankitemoaj se katlej yolitok nian kan kintookaj in mikkamej? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús mach nian kajki. Yej yomoyolkuik. Xikelnamikikan tlan oamechilwij nijkuak ok oyeka itech estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Okijtoj nik in Yej, katlej omochij tlakatl, nik yipa kitemaktianij (kitemaktilianij) inmak in tlakaj tlajtlakolejkej, iwan nik yipa kimajmasoltianij itech krus, iwan nik okipiaya por moyolkuis (moyolitis) ipan eyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ijkuakón in siwamej okelnamikej tlan Jesús okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Iwan satepan de omokuepatoj de kan mikkakuyoktle, okinmatiltijkej nochi tlan otlapanok in majtlaktle iwan se tlatitlaniltin iwan nochtin oksekimej. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","In yonmej siwamej oyekaj yen María de pueblo de Magdala, Juana, María imaman Jacobo, iwan oksekimej siwamej. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero in tlatitlaniltin okiyejyekojkej mach melawak tlan okijtoayaj in siwamej, iwan mach okinneltokilijkej. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ijkuakón Pedro okistewak iwan omotlaloj oyáj kan mikkakuyoktle. Iwan nijkuak ompa oajsito, oontlachixke ik tlijtik, okinmitak sa yen sabanajtin ompa oyekaj. Oyáj para ichan iwan sa omotlajtlachialtij (omomajmawtij) de tlan otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Itech yon mismo tonale, omen tlakaj katlej okineltokayaj in Jesús onejnentiayaj ipan ojtle oyayaj asta se pueblo itoka Emaús, katlej oyeka de wejka kanaj majtlaktle iwan se kilómetro de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Omotlapowijtiayaj de nochi tlan otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Iwan mientras omotlapowijtiayaj de nochi tlan otlapanok, ijkuakón Jesús inewian omijkuanij innawak iwan opéj inwan nejnemi. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero maski yejwan okitayaj, oyeka kej itlaj tlamantle katlej okintzakuiliaya para amo ma kixmatikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ijkuakón Jesús okintlajtlanij: ―¿De tlan namotlapowiaj mientras annejnemij? ¿Tlanik wel anmoyolkokoaj? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Se de yejwan katlej itoka Cleofas, okinankilij: ―Nochtin kimatij tlan otlamochij Jerusalén itech yinmej tonaltin. Asta katlej mach ompa chantij kimatij. ¿San yen tejwatzin in amo tikmati? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Tonses in Jesús okinmilwij: ―¿Tlan otlamochij? Yejwan okilwijkej: ―De yen Jesús de pueblo de Nazaret, katlej oyeka profeta iwan okipiaya poder de nochi tlan okichiwaya, iwan de nochi tlan okijtoaya inawak Dios iwan innawak nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","In tlayekankej tiopixkej iwan totekiwajkawan, okitemaktijkej (okitemaktilijkej) inmak in tlanawatijkej romanostin, para ma kitlajtlakoltikan ma miki, iwan okimajmasoltijkej itech se krus. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Tejwan otikchiayaj Yej kimakixtiani in topaís de Israel. Pero axan, ya kipia eyi tonale de ijkón otlamochij. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Maski sekimej siwamej katlej towan powij yotechmajmawtijkej de tlan techmakaj kuenta, porke oyajkej san kualkan kan mikkakuyoktle, ");
INSERT INTO nhyNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","iwan komo mach okajsikej itlalnakayo in Jesús, owalajkej otechilwikoj nik okitakej kej yeskia se teemiktle, okinmitakej sekimej angelestin katlej okinmilwijkej nik in Jesús yolitok. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sekimej tlakaj de tejwan oyajkej kan mikkakuyoktle, iwan okajsitajsikej ijkón ken siwamej otechilwijkej, pero mach okitakej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ijkuakón Jesús okinmilwij: ―¡Melawak amechpoloa tlalnamikilistle, iwan sa tekitl owij ankineltokaj nochi tlan okijtojkej in profetajtin! ");
INSERT INTO nhyNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Amo okipiaya de tlajyowis in Cristo itech nochi in yon tlamantle, antes de kalakis kan imawisotlanex? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ijkuakón opéj kinyekilwia tlan okijkuiloj in Moisés iwan nochi tlan okijkuilojkej in profetajtin de yon tlamantle kan tlapoa de Yej. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nijkuak oajsikej itech pueblo kan yejwan oyayaj, Jesús omochij komo kej yawi okachi wejka. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero yejwan okichijkej de ma mokawa inwan. Okilwijkej: ―Ximokawa towan, porke yotiotlakik, iwan ya tlatleyuas. Jesús mach ok oyáj iwan ompa inwan omokaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iwan nijkuak inwan yoewatoka itech mesa, okitilanke in pan iwan okitiochij. Satepan okipojpostekke iwan okinmajmakak. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iwan san niman ijkuakón oixtlajtlapokej, iwan okiyekixmatkej. Pero Yej san owalpoliwik. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwan okimolwijkej se iwan oksé: ―¿Amo otikpiayaj miek pakilistle ipan toyolo ne ipan ojtle nijkuak otechtlapowijtiwalaya, iwan otechyekilwiaya tlan kijta in tiotlajkuilole? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Tonses san niman ijkuakón, omokuepkej para Jerusalén. Iwan okinmajsitajsikej in majtlaktin iwan se tlatitlaniltin oololitokaj inwan oksekimej katlej ompa inwan oyekaj. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","In majtlaktin iwan se tlatitlaniltin okijtojkej: ―Melawak nik omoyolkuik in Señor, iwan Simón noijki yokitak. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ijkuakón, in omen tlakaj katlej okineltokayaj in Jesús noijki opéj kintlapowiaj de tlan opanokej ipan ojtle, iwan kenik okiyekixmatkej in Jesús nijkuak okipojpostekke in pan. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yejwan ok omotlapowijtokaj de yon tlamantle, iwan Jesús ijkuakón owalmonextij ik tlatlajko iwan okintlajpaloj, okinmilwij: ―Ximoyolosewikan. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yejwan omomawtijkej iwan opapatlakakej (obibiokakej) de majkayotl. Yejwan okiyejyekojkej xamo se anima. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesús okinmilwij: ―¿Tlanik anmomawtiaj? ¿Tlanik anmoijtitlapowiaj ipan namoyolo? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xikinmitakan nomawan iwan nokxiwan. Yen Nej. Xinechmachilikan iwan xinechitakan. Porke se anima mach kipia inakayo nion iomio, ken namejwan ankitaj nikpia. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nijkuak ijkón okinmilwij, okinmititij imawan iwan ikxiwan. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero yejwan mach oweliaj okineltokayaj, pero sa tekitl opakiaj iwan sa omotlajtlachialtijkej (omomajmawtijkej). Iwan Jesús okinmilwij: ―¿Ankipiaj itlaj para nikuas? ");
INSERT INTO nhyNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ijkuakón okimakakej se pedaso michin tliwakej iwan se nepale (tlanepale) de nektle. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús okitilanke (okitzkij) iwan okikuaj inmixpan. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ijkuakón okinmilwij: ―Tlan onipanok, yen tlan onamechilwij nijkuak ok onieka amowan: nik okipiaya por mochiwani nochi tlan ijkuilitok de Nej itech itlanawatil in Moisés, iwan itech intlajkuilol in profetajtin, iwan noijki tlan kijta in Salmos. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ijkuakón okintlapolij intlalnamikilis para ma kimomakakan kuenta tlan kijta in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iwan okinmilwij: ―Ijkón kajki ijkuilitok, Nej niCristo onikpiaya por nimikini, iwan ipan eyi tonale nimoyolkuini oksemi. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iwan moneki xipewakan desde nian Jerusalén iwan asta itech nochtin paismej de ixko yin tlaltikpak, xikinmilwikan ke nochtin akinmej kikawaskej de tlajtlakoskej iwan mokuepaskej inawak Dios, Dios kintlapojpolwis de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Namejwan ankitakej nochi tlan otlamochij iwan nochi tlan onipanok. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iwan axan xikkakikan, Nej namechwaltitlanilis amopan tlan noPapan oamechilwij. Pero ximokawakan nian Jerusalén asta xikresibirokan in poder katlej witz de ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Satepan, Jesús okinkixtij de itech yon weyikan iwan okinwikak asta pueblo de Betania. Satepan okinmajkokke imawan iwan okintiochij. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Iwan mientras okintiochiwaya, okinkajtejtiaj iwan omotlejkawijtiaj (otlejkok) ik ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yejwan, satepan de okiweyikixtijkej, omokuepkej para Jerusalén ika miek pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iwan nochipa oyekaj itech weyi tiopan okiweyikixtiayaj in toTajtzin Dios. Ijkón ma yeto.");
INSERT INTO nhyNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nijkuak ayamo otzinpewaya in tlaltikpak, yoyeka in Cristo, iwan Cristo oyeka iwan Dios, iwan Cristo yen Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cristo yoyeka iwan Dios desde itzintian tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cristo okichij nochi tlan onkaj, iwan tla amo por yen Cristo, mach yeni nochi tlan axan onkaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Itech Cristo oyeka nemilistle, iwan yon nemilistle oyeka yen tlanextle para nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Yon tlanextle tlawia kan tlatleyua. Iwan yon tlatleyualotl mach weli kisewia in tlanextle. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Oyeka se tlakatl itoka Juan katlej Dios okualtitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Okualtitlanke para yetos testigo para ma tetlapowi de yon tlanextle, para ijkón nochtin ma kineltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan mach oyeka yen tlanextle, sino yej owalaj para tetlapowis de yon tlanextle. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo yen katlej melawak tlanextle, katlej kintlawilia nochtin in tlakaj, iwan owalaj ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo oyeka ixko yin tlaltikpak, iwan yen okichij in tlaltikpak. Pero in tlaltikpaktlakaj mach okimomakakej kuenta akin Yej. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cristo owalaj innawak in tlakaj katlej iaxkawan, pero katlej iaxkawan mach okiresibirojkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero sekimej katlej okiresibirojkej iwan otlaneltokakej inawak, Cristo okinmakak poder para ma yekan ipilwan toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Otlakatkej kej ipilwan, pero mach otlakatkej ken nijkuak tlakati se konetl. Nion mach otlakatkej por yen tetajmej okinekej kinpiaskej inkonewan, sino otlakatkej kej ipilwan Dios porke yen toTajtzin Dios okimonekiltij ma tlakatikan inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Cristo omochij tlakatl iwan towan onenke ixko yin tlaltikpak, iwan otikitakej imawisotlanex, imawisotlanex de san Yej se iKone in toTajtzin Dios. Otechmakak miek itlasojtlalis iwan otechmachtij tlan melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan otetlapowij de Cristo, iwan chikawak okijtoj: ―Yen yin tlakatl de akin nej onikijtoaya nijkuak onikijtoj: “Katlej witz satepan de nej, okachi weyikistok (weyititok) ke nej, porke Yej yoyeka desde okachi achtoj antes de nej nitlakatini.” ");
INSERT INTO nhyNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tinochtin tejwan tikresibirojtokej miek tlamantle tlan kuale de Cristo. Porke Yej techtlasojtla iwan techmachtia tlan melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios otechmakak itlanawatil por medio de Moisés. Pero itlasojtlalis iwan tlan melawak owalaj por medio de Jesucristo. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Dios mach semi akaj kita. Pero iKone katlej san Yej se, katlej noijki Dios, iwan katlej kajki iwan iPapan, yen otechixmatiltiko in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","In judiojtin de Jerusalén okintitlankej sekimej tiopixkej iwan sekimej levitas para ma kitlajtlaniikan in Juan akin yej. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iwan Juan okinmilwij ipan melajka: ―Mach nej niCristo. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iwan okitlajtlanijkej: ―Tonses, ¿akin tej? ¿Tej tiElías? Juan okijtoj: ―Amo, nej mach niElías. Oksemi okitlajtlanijkej: ―¿Yen tej tiprofeta katlej kipia de witz? Juan okinnankilij: ―Amo, mach nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ijkuakón kiné okilwijkej: ―¿Akin tej kiné? Moneki xitechilwi para ijkón welis tikinmakaskej itlaj rason katlej otechwaltitlankej. ¿Tlan welis titechilwis de tej? ");
INSERT INTO nhyNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan okinnankilij: ―Yen Nej katlej nitetzajtzilia kan tlawaki: “Xikmelawakan iojwi in Señor” ―ijkón ken ya wejkawitl okijtoj in profeta Isaías nik ijkón nikchiwas. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Katlej oyajkej okitatoj in Juan oyekaj intlatitlanilwan in fariseos. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Iwan okitlajtlanijkej: ―¿Tlanik kiné titlakuateekia tla amo yen tej tiCristo, nion amo yen tej tiElías, nion amo yen tej tiprofeta katlej tikchiaj ma wiki? ");
INSERT INTO nhyNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan okinnankilij ijkín: ―Nej nitlakuateekia ika atl. Pero amowan kajki se akin namejwan mach ankixmatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yen yon katlej witz satepan de nej. Iwan nion mach notech powi para nikaktotomas. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Yon otlamochij itech tlale de pueblo de Betábara, ik ne lado de yen weyatl Jordán, kan Juan otlakuateekiaya. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Owalmostlatik, Juan okitak in Jesús owalaya inawak, iwan okijtoj: ―Xikitakan iichkatzin in toTajtzin Dios, katlej kintlapojpolwis in tlaltikpaktlakaj de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yen yin tlakatl de katlej nej onikijtoj: “Satepan de nej witz se tlakatl katlej okachi weyikistok (weyititok) ke nej. Yej yipa yoyeka desde okachi achtoj, antes de nej nitlakatini.” ");
INSERT INTO nhyNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nej mach onikixmatia. Pero por yonik nej nitlakuateekijtiwitz ika atl para ijkón in tlakaj de Israel ma kixmatikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan noijki okijtoj: ―Nej onikitak in Espíritu Santo owaltemok de ilwikak kej se paloma iwan ipan omotlalij. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nej mach ya onikixmatia, pero akin onechwaltitlanke ma nitlakuateeki ika atl, onechilwij: “Nijkuak tikitas in Espíritu Santo waltemos iwan motlalis ipan se tlakatl, yen yon katlej tlakuateekis ika Espíritu Santo.” ");
INSERT INTO nhyNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iwan nej yonikitak, iwan por yonik namechilwia nik yen yon iKone in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Owalmostlatik, in Juan oksemi ompa oyeka iwan omen imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Iwan nijkuak okitak nik in Jesús ik ompa opanoaya, okijtoj: ―Xikitakan iichkaKone in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iwan yonmej omen imomachtijkawan in Juan okikakej tlan okijtoj. Iwan satepan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nijkuak in Jesús omokuepke iwan okinmitak nik ikuitlapan oyayaj, okinmilwij: ―¿Tlan ankitemoaj? Iwan yejwan okijtojkej: ―Rabí ―kijtosneki Tlamachtij―, ¿kan tichanti? ");
INSERT INTO nhyNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Iwan Jesús okinmilwij: ―Xiwikikan iwan xikitakan. Ijkuakón yejwan oyajkej iwan Jesús iwan okitakej kan chanti, iwan ompa omokajkej iwan Jesús yon tonale, porke yoyeka kej las kuatro de tiotlakke. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés, ikni in Simón Pedro, oyeka se de yonmej omen katlej okikakej tlan okijtoj in Juan iwan satepan oyajkej iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés niman oyáj okitemoto ikni katlej itoka Simón, iwan okilwij: ―Yotikajsikej in Mesías ―kijtosneki Cristo o noso Tlapejpenale de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iwan okiwikak inawak Jesús. Nijkuak in Jesús okitak, okilwij: ―Tej tiSimón, titekone de Jonás. Tej yetos motoka tiCefas ―kijtosneki Pedro o noso Tetl. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Owalmostlatik, in Jesús okiyejyekoj yas ik estado de Galilea. Ompa okitak in Felipe iwan okilwij: ―Xiwiki nowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe oyeka de pueblo de Betsaida, kan ochantiaj Andrés iwan Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe okitemoto in Natanael, iwan okilwij: ―Yotikajsikej in tlakatl de katlej Moisés okijtoj walani iwan okijkuiloj itech itlanawatil. In ya wejkawitl profetajtin noijki okijkuilojkej de yon tlakatl. Iwan yon tlakatl yen Jesús ikone in José de pueblo de Nazaret. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael okijtoj: ―¿Welis kisas itlaj kuale itech pueblo de Nazaret? Felipe okinankilij: ―Xiwiki xikitaki. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nijkuak in Jesús okitak in Natanael yowalaya inawak, okijtoj: ―Nian witz se katlej melawak israelita, katlej amo tlakajkayawa. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael okitlajtlanij in Jesús: ―¿Kenik tinechixmati? Iwan Jesús okinankilij: ―Antes de mitznotzati in Felipe, nijkuak otieka itlampa igoskuawitl, Nej onimitzitak. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ijkuakón Natanael okijtoj: ―Tlamachtij, tejwatzin titeKone de Dios. Tejwatzin tiRey de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús okinankilij: ―Por onimitzilwij nik onimitzitak itlampa igoskuawitl, ¿por yonik tinechneltoka? Okachi wejweyin tlamantin tikinmitas ke yon. ");
INSERT INTO nhyNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesús noijki okijtoj: ―Ipan melajka namechilwia, namejwan ankitaskej in ilwikak tlapotos, iwan angelestin de Dios tlejkoskej iwan temoskej nopan Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Owiptlatik, omochij se ilwitl kan monamiktiaj itech pueblo de Caná itech estado de Galilea. Ompa oyeka imaman in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Noijki okinminbitarojkej in Jesús iwan imomachtijkawan itech yon ilwitl. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Iwan nijkuak otlanke in vino, imaman in Jesús okilwij: ―Mach ok kipiaj vino. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús okinankilij: ―Tejwatzin nanan, mach moneki xinechilwi tlanon moneki nikchiwas. Mach ya ajsi ora para pewas nitekipanos. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Imaman okinmilwij katlej otlaserbirojtokaj: ―Xikchiwakan nochi tlan Yej amechilwis. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ompa oyekaj chikuasen wejweyin xoktzinmej katlej ika okitlaliayaj atl in judiojtin, para ika omomajtekiayaj kej se kostumbre para omochipawayaj inawak Dios. Ijtik kada se xoktzin oakia kanaj se sien litros de atl. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús okinmilwij in tlaserbirojkej: ―Xikintemitikan yinmej xoktzinmej ika atl. Yejwan okintemitijkej asta otenkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Iwan Jesús okinmilwij: ―Axan xikixtikan achitzin, iwan xikitkilikan in tlakatl katlej tlayekanke de yen tlaserbirojkej. Okitkilijkej kiné. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","In yon tlayekanke okiyekoj in atl katlej omokuepke vino, mach okimatia de kan owalaj, san yen katlej tlaserbiroaj katlej okixtijkej atl okimatiaj de kan owalaj. Iwan ijkuakón in tlayekanke okinotzke in novio. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Okilwij: ―Nochtin in tlakaj kitemaka achtoj katlej kuale vino, iwan nijkuak ya miek yokonikej, ijkuakón kitemakaj katlej okachi barato. Pero tejwatzin otikaj katlej kuale vino para satepan tiktemakas. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yen yin katlej yakinika milagro okichij in Jesús itech pueblo de Caná de Galilea. Ika yon milagro okiteititij ipoder. Iwan imomachtijkawan otlaneltokakej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Satepan de yon, Jesús oyáj para Capernaum, ompa opanok kanaj keski tonale iwan imaman, iwan ikniwan, iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nijkuak yoajsia inmilwiw in judiojtin katlej itoka pascua, Jesús oyáj para Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iwan okinmitajsik ijtik in weyi tiopan in bakajnamakakej, in ichkanamakakej, in palomasnamakakej, iwan in tominpatlakej katlej ompa oewatokaj itech inmesa. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesús okichij se chikotejmekatl, iwan okinkixtij de kan patio de yen weyi tiopan ika nochi inmichkawan iwan inbakajwan. Okinxoyawilij intomin in tominpatlakej, iwan okintlatlamochilij inmesajwan. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jesús okinmilwij in palomasnamakakej: ―Xikinkixtikan namopalomaswan de nian. Amo xikkuepakan kej se tiankistle ikalijtik in noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ijkuakón okelnamikej imomachtijkawan nik in tiotlajkuilole kijta: “Sa tekitl niktlasojtla mokalijtik ika nochi noyolo.” ");
INSERT INTO nhyNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","In judiojtin okitlajtlanijkej: ―¿Kenik otimixewij otikinkixtij? Tla Dios omitzilwij ijkón xikchiwa, xitechititi kiné se milagro. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesús okinnankilij: ―Xikxitinikan yin weyi tiopan iwan san ika eyi tonale oksemi nikchiwas. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","In judiojtin okijtojkej: ―Yin weyi tiopan omochij ika omenpoale iwan chikuasen xiwitl. ¿Iwan Tej san ika eyi tonale tikneki tikchiwas oksemi? ");
INSERT INTO nhyNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero in weyi tiopan de katlej Jesús okijtoaya, kijtosneki yen itlalnakayo. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Por yonik, nijkuak omoyolkuik oksemi satepan de omikke, imomachtijkawan okelnamikej yon tlan okijtoj, iwan okineltokakej tlan kijta in tiotlajkuilole iwan tlan Jesús okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iwan nijkuak Jesús oyeka Jerusalén itech ilwitl de pascua, miekej otlaneltokakej inawak porke okitakej wejweyin señalestin okinchiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús mach okinneltokiliaya, porke Yej kuale okinmixmatia nochtin ipan inyolo. ");
INSERT INTO nhyNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Mach omonekia akaj ma kilwi tlanon kiyejyekoaj in tlakaj, porke Yej inewian yokimatia tlanon kiyejyekoaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Oyeka se tlakatl fariseo itoka Nicodemo, iwan oyeka tlayekanke judío. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yon Nicodemo oyáj de yuak okitato in Jesús iwan okilwij: ―Tlamachtij, tejwan tikmatij nik tejwatzin omitzwaltitlanke in toTajtzin Dios para xitechmachtiki. Porke mach akaj tlakatl welis kinchiwas in milagrostin tla Dios amo iwan yetos. Tla Dios iwan yetos, tonses welis kinchiwas in milagrostin ijkón ken tejwatzin tikinchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús okilwij in Nicodemo: ―Ipan melajka nimitzilwia: Akin amo tlakatis oksemi, mach welis kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iwan Nicodemo okitlajtlanij: ―¿Kenik welis oksemi tlakatis se katlej ya weyi tlakatl? ¿Kox welis kalakis ijtik imaman iwan tlakatis oksemi? ");
INSERT INTO nhyNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iwan Jesús okinankilij: ―Ipan melajka nimitzilwia: Akin amo tlakatis ika atl iwan akin amo tlakatis ika Espíritu Santo, mach welis kalakis kan Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Se tlakatl katlej tlakati itech imaman kipia inakayo iwan iomio, pero se tlakatl katlej tlakati itech Espíritu Santo kiresibiroa se yankuik nemilistle ipan ianima. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo ximotlajtlachialti (ximomajmawti) por nimitzilwia: “Moneki titlakatis oksemi.” ");
INSERT INTO nhyNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","In ejekatl yawi san kanik kineki, iwan tikkaki kokuyoka. Pero mach tikmati de kan witz iwan nion mach tikmati kan yawi. Ijkón noijki akin tlakati itech Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo oksemi okitlajtlanij: ―¿Yon kenamij? ");
INSERT INTO nhyNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús okinankilij: ―¿Tej tiweyitlamachtij de Israel, iwan amo tikmomaka kuenta? ");
INSERT INTO nhyNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ipan melajka nimitzilwia, tejwan tikijtaj de tlan tikmatij. Titetlapowiaj de tlan yotikitakej, pero namejwan mach ankineltokaj tlan tamechilwiaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tla nimitzilwia itlaj tlamantle de nian tlaltikpak, iwan amo tinechneltoka, ¿kenik kiné tikneltokas tla nimitzilwis itlaj tlamantle de ilwikak? ");
INSERT INTO nhyNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Mach semi akaj tlejko ilwikak, sino san Nej akin oniwaltemok de ilwikak, Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Iwan ijkón ken Moisés okajkokke in koatl kan tlawaki, ijkón noijki nechajkokuiskej Nej katlej onimochij nitlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Para ijkón, nochtin akinmej nechneltokaskej ma kipiakan nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Dios sa tekitl kintlasojtla in tlaltikpaktlakaj, iwan por yonik okitemakak in san Yej se iKone, para ke nochtin akinmej kineltokaskej, amo ma mopolokan, sino ma kipiakan nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios mach okualtitlanke iKone itech yin tlaltikpak para ma kinpojpolo in tlaltikpaktlakaj, sino okualtitlanke para ma kinmakixti. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Akin kineltoka iKone in Dios, mach mopoloa. Pero akin amo kineltoka, kijtosneki yomopoloj porke amo otlaneltokak inawak katlej san Yej se iKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Akinmej amo kineltokaj, kijtosneki yomopolojkej. Porke Nej oniwalaj itech yin tlaltikpak kej se tlanextle. Pero in tlaltikpaktlakaj okachi okiwelitakej in tlatleyualotl (tlatleyuwalistle) iwan amo yen tlanextle. Okachi kiwelitaj in tlatleyualotl porke kichiwaj tlan mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nochtin akinmej kichiwaj tlan mach kuale, kikokoliaj in tlanextle iwan amo mijkuaniaj inawak, para amo ma mota intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero akinmej kichiwaj tlan melawak, mijkuaniaj kan kajki in tlanextle, para ma mota nik kichijtokej tlan Dios kineki. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Satepan de yon, Jesús oyáj iwan imomachtijkawan itech región de Judea, iwan ompa inwan omokaj kanaj keski tonale, iwan okinkuateekij miekej tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan noijki otlakuateekijtoka itech pueblo de Enón, inakastlan pueblo de Salim, porke ompa oyeka miek atl. Iwan in tlakaj oyayaj inawak in Juan iwan omokuateekiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Porke ijkuakón in Juan mach ya okitzakuayaj telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Imomachtijkawan in Juan opéj motlatlajtolkuepaj inwan sekimej judiojtin de kenik moneki se yetos chipawak inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iwan oyajkej okilwitoj in Juan: ―Tlamachtij, in tlakatl katlej oyeka mowan ik ne lado itech weyatl Jordán, de katlej tejwatzin otitechtlapowij, axan nochtin yawij inawak para mokuateekiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan okinnankilij: ―Kada se tlakatl Dios okimakak itekiw para ma kichiwa tlan Dios kineki. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Namejwan amonewian annechkakej onikijtoj nik mach nej niCristo, sino Dios onechwaltitlanke antes de Yej witz. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Nijkuak akaj monamiktia, in novio yen katlej kipixtok in novia, iwan iamigo in novio sa tekitl paki nijkuak kikaki tlajtoa in novio. Ijkón nej noijki, sa tekitl nipaki nijkuak nikkaki nik nochtin tlakaj yawij inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yej kipia de weyikistias (weyititias) iwan nej nitzikitzinixtias. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Katlej owaltemok de ilwikak, okachi weyikistok (weyititok) de nochtin. In tlaltikpaktlakaj katlej powij de nian tlaltikpak, tlajtoaj de tlan onkaj ixko yin tlaltikpak. Pero katlej owaltemok de ilwikak okachi weyikistok de nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yej kitemaka kuenta de tlan okitak iwan de tlan okikakke, pero mach akaj kineltoka tlan Yej kijta. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Akin kineltoka tlan Yej kijta, kimomaka kuenta nik in Dios kijta tlan melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pero Jesús katlej Dios okiwaltitlanke, noijki tlapoa de tlan Dios kijta, porke Dios kimaka nochi in poder katlej kipia iEspíritu. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ToPapan Dios kitlasojtla iKone, iwan okimaktilij ma kinawati nochi tlan onkaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Akin kineltoka iKone in toTajtzin Dios, kipia nemilistle katlej mach keman tlamis. Pero akin amo kineltoka yon iKone, mach kipias yon nemilistle, sino ipan witz ikualanilis in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","In fariseos okimatkej nik in Jesús okinpiaya okachi miekej imomachtijkawan iwan okinkuateekiaya okachi miekej ke Juan. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Maski amo yen Jesús okinkuateekiaya, sino yen imomachtijkawan otlakuateekiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Iwan nijkuak Jesús ijkón okimatke, okiske de estado de Judea, iwan omokuepke oksemi para estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Iwan Jesús okipiaya para panos ik estado de Samaria. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Oajsito kiné, itech se pueblo de Samaria itoka Sicar, inakastlan in tlale katlej Jacob okimakak ikone José. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Iwan ompa oyeka in poso de Jacob. Jesús osotlawak de onejnenke iwan omotlalij itempan yon poso. Oyeka kej tlajko tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ijkuakón owalaj se siwatl de Samaria para kikixtis atl. Iwan Jesús okilwij: ―Xinechmaka achitzin atl ma natli. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ijkuakón imomachtijkawan meroj yajtokej itech pueblo okikowatoj tlan kikuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","In siwatl samaritana okinankilij: ―¿Tlanik tinechtlajtlanilia ma nimitzmaka atl? Tej tijudío iwan nej nisamaritana. (Ijkón okijtoj porke in judiojtin mach monekij inwan samaritanojtin.) ");
INSERT INTO nhyNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iwan Jesús okilwij: ―Tej mach tikmati tlan Dios kitetliokolia, iwan mach tinechixmati akin Nej. Nej nimitztlajtlanilia xinechmaka achitzin moaw. Tla tej tikmatini akin Nej, tonses yen Nej tinechtlajtlaniliani ma nimitzmaka noaw. Nej welis nimitzmakas yon atl katlej kitemaka nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iwan siwatl okilwij: ―Señor, mach tikpia tlan ika tikkixtis atl, iwan in poso wejkatlan. Tonses, ¿kan tikkuiti yon atl katlej kitemaka nemilistle para tinechmakas? ");
INSERT INTO nhyNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Okachi tiweyikistok (tiweyititok) in Tej ke in ya wejkawitl toweyitaj Jacob? Porke yen toweyitaj Jacob katlej otechmakak yin poso, kan yej oatlia iwan noijki nian oatliaj ipilwan iwan iyolkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús okinankilij: ―Nochtin akinmej koniskej yin atl, oksemi amikiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero akin konis in atl katlej Nej nikmakas, mach oksemi amikis. Porke in atl katlej Nej nikmakas yetos kej se ameyale katlej mextos ipan iyolo iwan kimakas nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ijkuakón in siwatl okilwij: ―Señor, xinechmaka yon atl para mach ok keman ma namiki, iwan nion mach ok keman ma nikixtiki atl itech yin poso. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús okilwij: ―Xiwia xiknotzati mookich iwan xiwikikan nian. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","In siwatl okinankilij: ―Mach nikpia nookich. Jesús okilwij: ―Melawak tlan tikijta nik mach tikpia mookich. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porke yotikinpixke makuiltin mookichwan, iwan katlej axan tikpia mach mookich. Melawak tlan tikijta. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nijkuak ijkón okikakke in siwatl, okilwij: ―Señor, nikmomaka kuenta nik tejwatzin tiprofeta. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","In ya wejkawitl toweyitajwan samaritanojtin okiweyikixtiayaj in toTajtzin Dios itech yin tepetl, pero namejwan anjudiojtin ankijtaj nik moneki se kiweyikixtis in Dios itech weyikan de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iwan Jesús okinankilij: ―Siwatl, xinechneltokili. Ajsis tonale, nijkuak mach ok monekis anwitzej itech yin tepetl, iwan nion mach ok monekis anyaskej Jerusalén para ankiweyikixtiskej in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Namejwan ansamaritanojtin mach ankimatij akin nankiweyikixtiaj. Pero tejwan katlej tijudiojtin tikmatij akin tikweyikixtiaj. Porke por yen judiojtin owalaj itlajtol in Dios para ma kimatikan in tlaltikpaktlakaj kenik welis momakixtiskej de itech tlajtlakole, para ijkón welis kipiaskej yankuik nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pero ajsiki se tonale nijkuak in tlakaj kiweyikixtiskej in toPapan Dios ika nochi inyolo iwan ipan melajka ken Dios kineki, iwan axan yon tonale yoajsiko. ToPapan Dios, ijkón kineki ma kichiwakan akinmej kiweyikixtiaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dios Yej Espíritu, iwan akinmej kiweyikixtiskej moneki ma kiweyikixtikan ika nochi inyolo iwan ipan melajka. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","In siwatl okilwij: ―Nikmati nik witz in Mesías, katlej kilwiaj Cristo. Iwan nijkuak Yej witz techtomilis nochi yin tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús okilwij: ―Yen Nej niCristo, katlej axan Nej mowan nimotlapowijtok. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iwan ijkuakón oejkokej imomachtijkawan. Sa otlajtlachixkej (omomajmawtijkej) por okitakej motlapowijtok iwan se siwatl samaritana. Pero mach akaj omixewij okitlajtlanij tlan kineki yon siwatl, o noso de tlanon motlapowiaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ijkuakón in siwatl okikajtej iaxoktzin, iwan oyáj ompa ipueblo, iwan okinmilwij in tlakaj: ");
INSERT INTO nhyNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xiwikikan, xikitakij se tlakatl katlej onechilwij nochi tlan onikchij. Xamo yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ijkuakón okiskej de itech yon pueblo, iwan oyajkej kan oyeka in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mientras, imomachtijkawan okitlatlawtiayaj in Jesús ma tlakua, okilwiayaj: ―Tlamachtij, ximotlamajsewi. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Yej okinmilwij: ―Nej nikpia se tlakuale katlej namejwan mach ankixmatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Imomachtijkawan opéj kimolwiaj entre yejwan: ―¿Xamo akaj okiwalkuilij itlaj tlan kikuas? ");
INSERT INTO nhyNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús okinmilwij: ―Notlakual kijtosneki moneki nikchiwas tlan kimonekiltia akin onechwaltitlanke. Iwan nixwis nijkuak niktlamis in tekitl katlej onechmakak. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Nijkuak namejwan antookaj ankitaj: “Moneki tikchiaskej nawi metztle para tipixkaskej.” Pero Nej namechilwia: Xitlachiakan kuale kan tlatokyoj, yotlachikawak iwan ya kuale para se pixkas. In tlakaj katej kej tlatoktin katlej yochikawakej iwan moneki se kinpixkas para Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Iwan akin kinpixka animajtin kipias itlaxtlawil, iwan katlej kinpixkaj kipiaskej nemilistle katlej mach keman tlamis. Iwan ijkón, katlej tooka iwan katlej pixka san sekan ma pakikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Melawak ijkón ken kijta in tlajtole: “Se tlakatl katlej tooka iwan satepan oksé tlakatl katlej pixka.” ");
INSERT INTO nhyNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nej onamechtitlanke xiwian xikpixkatij katlej namejwan mach ankitookakej. Oksekimej katlej otekipanojkej iwan namejwan sa anpixkaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Miekej samaritanojtin de yon pueblo otlaneltokakej inawak Jesús por yej tlan okinmilwij in siwatl: “Onechilwij nochi tlan onikchij.” ");
INSERT INTO nhyNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nijkuak in samaritanojtin owalajkej inawak Jesús, okitlatlawtijkej inwan ma mokawa. Jesús ompa omokaj ome tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iwan itech yon ome tonale otlaneltokakej inawak Jesús okachi miekej tlakaj por tlan Yej inewian okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iwan okilwijkej in siwatl: ―Axan tikneltokaj amo san por tlan tej otitechilwij, sino porke tejwan tonewian yotikkakej noijki, iwan yotikmatkej ipan melajka nik Yej kinmakixtis in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Satepan de yon ome tonale, Jesús okiske de ompa, iwan oyáj itech estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ken okijtoj in Jesús, se profeta mach kitlakitaj itech ipueblo. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nijkuak oajsito Galilea, nochtin in tlakaj de ompa okiresibirojkej ika pakilistle. Yonmej tlakaj oyekaj Jerusalén nijkuak okitakej in Jesús nochi tlan okichij itech ilwitl de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Satepan Jesús oksemi oyáj itech pueblo de Caná de Galilea, kan Yej okikuepke vino in atl. Iwan itech pueblo de Capernaum oyeka se weyi tekiwaj de yen rey, katlej okipiaya se ikone kokoxke. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nijkuak yon tekiwaj okimatke nik in Jesús yomokuepato de estado de Judea iwan yoejkoko itech estado de Galilea, oyáj para Caná okitato in Jesús. Okitlatlawtij iwan ma wia para Capernaum ma kipajtiliti ikone, porke yamiktok. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iwan Jesús okilwij: ―Namejwan mach itlaj ankineltokaj tla amo ankitaj itlaj milagro o noso itlaj señal. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iwan yon tekiwaj okilwij: ―Señor, san niman xiwiki antes de mikis nokone. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ijkuakón Jesús okilwij: ―Ximokuepa mokalijtik, mokone yopajtik. In tlakatl okineltokak tlan Jesús okilwij, iwan oyáj para ichan. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nijkuak yoajsitiaya ichan, itekipanojkawan okinamikitoj, iwan okilwijkej: ―¡Mokone yopajtik! ");
INSERT INTO nhyNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iwan yej okintlajtlanij tlan ora opéj mijmati ikone, iwan yejwan okilwijkej: ―Yala kej la una de tiotlakke, okiske in totonik. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ijkuakón in tetaj okimomakak kuenta ke meroj itech yon ora in Jesús okilwij: “Mokone yopajtik.” Iwan yej iwan nochi ifamilia otlaneltokakej inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yin milagro ya ipan ojpa okichij in Jesús itech estado de Galilea, okichij satepan de owalaj de estado de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Satepan de yon tlan okichij in Jesús, oyáj para Jerusalén, kan judiojtin kichiwaskej se ilwitl itech yon weyikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Iwan itech weyikan de Jerusalén, inakastlan puerta katlej kitokayotiaj puerta de ichkamej, ompa oyeka se tanke katlej ika tlajtole hebreo itoka Betesda, katlej okinpiaya makuile korredortin. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Iwan itech yonmej korredortin oyekaj miekej kokoxkej owejwetokaj ipan tlale. Sekimej mach otlachiayaj, sekimej oyekaj koxomej iwan sekimej oyekaj wilanmej (temetlamej). ");
INSERT INTO nhyNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Se iángel in Señor kemanti owaltemoaya iwan okoliniaya in atl. Iwan nochtin okichiayaj yon ora nijkuak owaltemoaya in ángel. Iwan akin achtoj omoapolakiaya, opajtia san tlan kokolistle okipiaya. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ompa oyeka se tlakatl katlej yokipiaya senpoale iwan kaxtole iwan eyi xiwitl de mokokoa. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iwan nijkuak in Jesús okitak ompa wetok in yon tlakatl, okimomakak kuenta nik yokipiaya miek xiwitl de kokoxke, iwan okitlajtlanij: ―¿Tikneki tipajtis? ");
INSERT INTO nhyNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Iwan in kokoxke okinankilij: ―Señor, mach nikpia akin nechapolakis ijtik in tanke nijkuak molinia in atl. Porke nochipa nijkuak nej nikneki nimoapolakis, oksé achtoj moapolakijtiwetzi. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús okilwij: ―Ximoketza, xikajkokui mopetl iwan xiwia. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","San niman ijkuakón yon tlakatl opajtik, okajkokke ipetl iwan opéj nejnemi. Yon tonale oyeka sábado nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ijkuakón in tlayekankej judiojtin okilwijkej in tlakatl katlej opajtik: ―Axan sábado, mach welis tikmamas mopetl. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Iwan yej okinnankilij: ―Katlej onechpajtij, onechilwij: “Xikajkokui mopetl iwan xiwia.” ");
INSERT INTO nhyNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yejwan okitlajtlanijkej: ―¿Akin yon tlakatl katlej omitzilwij: “Xikajkokui mopetl iwan xiwia”? ");
INSERT INTO nhyNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero in tlakatl katlej opajtik mach okimatia akin okipajtij, porke in Jesús okalakke intzalko in tlakaj katlej oyekaj itech nekáj lugar iwan mach ok okitak. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Satepan, Jesús okitak in yon tlakatl kan weyi tiopan, iwan okilwij: ―Xikkaki, yotipajtik, ayakmo xitlajtlako, para amo timochiwas itlaj okachi temawtij. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Yon tlakatl oyáj okinmilwito in tlayekankej judiojtin nik yen Jesús katlej okipajtij. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Por yonik in tlayekankej judiojtin okijtojkej kimiktiskej in Jesús, porke otepajtiaya nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero Jesús okinmilwij: ―NoPapan nochipa tekipanojtok kichijtok tlan kuale, iwan Nej no ijkón nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Por yonik in tlayekankej judiojtin okachi okinekej kimiktiskej, porke amo okitlakitaya in weyi tonale iwan porke omoteixmachtiaya nik in Yej iwan toTajtzin Dios san se, iwan ijkón omochiwaya noijki ken Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesús okinmilwij: ―Ipan melajka namechilwia: Nej katlej niiKone in Dios, mach welis itlaj nikchiwas san tlan Nej niknekis, sino Nej nikchiwa tlan nikita kichiwa noPapan. Nochi tlan kichiwa noPapan, yen yon noijki tlan Nej nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Porke noPapan nechtlasojtla Nej katlej niiKone, iwan nechititia nochi tlan kichiwa. Iwan nechititis okachi wejweyin tlamantin iwan amo ken yinmej, iwan namejwan sa anmotlajtlachialtiskej (onmomajmawtiskej). ");
INSERT INTO nhyNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porke noPapan kinyolitia in mikkamej iwan kinmaka nemilistle. Ijkón noijki Nej katlej niiKone in Dios nikmakas nemilistle katlej Nej niknekis nikmakas. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","NoPapan mach teyolkuitia, yen Nej katlej onechtlalij para ma nikinyolkuiti nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Para ijkón nochtin ma nechtlakitakan Nej katlej niiKone in Dios, ijkón ken kitlakitaj noPapan. Akin amo nechtlakita Nej katlej niiKone in Dios, tonses noijki mach kitlakita noPapan katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ipan melajka namechilwia: Akin kikaki notlajtol, iwan kineltoka katlej onechwaltitlanke, kipias nemilistle katlej mach keman tlamis. Iwan mach akaj kitlajtlakoltis, yon kijtosneki yokiske de itech mikilistle iwan axan yakipia nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ipan melajka namechilwia: Ajsis tonale iwan yon tonale yoajsiko. Axan, in tlakaj katlej katej kej mikkamej, kikakiskej notlajtol de Nej katlej niiKone in Dios. Iwan nochtin katlej kikakiskej notlajtol Nej nikinmakas yankuik nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ijkón ken noPapan kipia nemilistle itech Yej iwan weli kitemaka nemilistle, ijkón noijki okichij Nej katlej niiKone in Dios ma nikpia nemilistle notech para ijkón noijki ma niktemaka nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Iwan noijki onechmakak tlanawatijkayotl para nikinmixkomakas (nikintzonmanas) in tlaltikpaktlakaj, porke Nej katlej onimochij nitlakatl yen Nej niiKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo ximotlajtlachialtikan (ximomajmawtikan) de tlan namechilwia, porke ajsis tonale nijkuak nochtin katlej toktokej kikakiskej notlajtol, ");
INSERT INTO nhyNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","iwan kisaskej de ijtik inmikkakuyok. Akinmej okichijkej tlan kuale moyolkuiskej (moyolitiskej) iwan kipiaskej nemilistle katlej mach keman tlamis. Iwan akinmej okichijkej tlan amo kuale, moyolkuiskej para kintlajtlakoltiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nej mach welis itlaj nikchiwas san tlan Nej niknekis. Nitlayolkuitia ijkón ken noPapan nechnawatia ma nikchiwa. Iwan nitlayolkuitia ijkón ken moneki porke mach nikchiwa san tlan Nej nikneki, sino Nej nikchiwa tlan kineki noPapan katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tla namechtlapowiani itlaj katlej kisa san de Nej, tonses yeni mach itlaj ipatij tlan nikijta. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Onkaj oksé akin tlajtoa de Nej, iwan nikmati ke tlan kijta de Nej yon melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Namejwan ankintitlankej sekimej tlakaj inawak in Juan Tlakuateekij, iwan tlan yej okinmilwij de Nej yon melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero mach moneki akaj tlakatl ma amechmatilti akin Nej. Sino Nej san namechelnamiktia tlan Juan okijtoj para xitlaneltokakan iwan ximomakixtikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan oyeka kej tlanextle katlej otlikuitoka iwan otlawiaya, iwan miekej tlakaj okiwelitakej. Iwan ijkón namejwan anpakej kanaj keski tonale itech itlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero Nej nikpia se testigo katlej okachi weyi ke Juan. Tlan Nej nikchiwa yen tlan noPapan onechtlalij ma nikchiwa, iwan yon tlan nikchiwa kiteititia nik melawak yen noPapan onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Iwan noPapan katlej onechwaltitlanke noijki kiteititia nik in Nej niitlatitlanil, maski namejwan mach semi ankikakij iwan nion mach semi ankitaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nion itlajtol mach weli kalaki ipan amoyolo, porke mach annechneltokaj Nej katlej noPapan onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Namejwan anmomachtiaj in tiotlajkuilole porke ankiyejyekoaj welis amechmakas nemilistle katlej mach keman tlamis. Pues yon tiotlajkuilole tlapoa de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iwan namejwan mach ankinekij anwitzej nonawak para xikpiakan nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nej mach niktemoa namejwan kuale xitlapoakan de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Porke Nej kuale namechixmati, nik mach melawak ankipiaj itlasojtlalis in Dios ipan namoyolo. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nej oniwalaj porke noPapan onechwaltitlanke ma niwiki, iwan namejwan mach annechneltokaj. Pero tla witz akaj oksé tlakatl katlej san yej inewian kiyejyekos witz, yen yon okachi ankineltokiliskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Kenik welis annechneltokiliskej namejwan, tla san entre amejwan anmoweyikixtiaj se iwan oksé, iwan mach keman ankiyejyekoaj tlanon moneki ankichiwaskej para ma amechweyikixti in Dios katlej onkaj san Yej se? ");
INSERT INTO nhyNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo xikyejyekokan nik in Nej namechtilwis inawak noPapan. Sino onkaj oksé akin namechtilwis, kijtosneki yen itlanawatil in Moisés, katlej namejwan ankichiaj amechmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Porke tla amejwan ankineltokanij tlan Moisés okijtoj, tonses namejwan annechneltokanij, porke tlan yej okijkuiloj tlapoa de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero tla amo ankineltokaj tlan yej okijkuiloj, ¿kenik welis ankineltokaskej tlan Nej namechilwia? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Satepan de yon, Jesús opanok oksé lado de yen mar de Galilea katlej noijki itoka Tiberias. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Miekej tlakaj oyajkej iwan Jesús porke okinmitayaj in señalestin katlej Yej okinchiwaya ika ipoder itech in kokoxkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Tonses Jesús otlejkok itech se tepetl, iwan ompa omotlalij iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ijkuakón yoajsia in tonale de yen inmilwiw in judiojtin katlej itoka pascua. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nijkuak in Jesús okitak nik sa tekitl miekej tlakaj owalayaj inawak, ijkuakón okilwij in Felipe: ―¿Kan tikkowatiwej pan para ma tlakuakan nochtin yinmej tlakaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús ijkón okitlajtlanij in Felipe para kitas tlan kijtos, porke in Jesús yokimatia tlanon kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Iwan Felipe okinankilij: ―Mach kajxilis tikkowaskej ome siento denarios de pan para ma tlakuakan nochtin, porke mach kajxilis kikuaskej nion ajachintzitzin. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ijkuakón in Andrés, ikni in Simón Pedro, katlej noijki oyeka imomachtijkaw in Jesús, okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nian kajki se chokkoj katlej kipia makuile pan de sebada iwan ome michin, pero mach kajxilis para nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ijkuakón Jesús okijtoj: ―Xikinmilwikan nochtin ma motlalikan. Itech yon lugar oyeka xiwyoj, iwan nochtin omotlalijkej. Iwan oyekaj kej makuile mil tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesús okitilanke in pan, omotlasojkamatke inawak Dios, iwan okinxejxelilij in tlakaj katlej oewatokaj. Iwan noijki ijkón okichij ika michimej, iwan tlakaj kuale otlakuajkej asta oixwikej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iwan nijkuak nochtin yoixwikej, in Jesús okinmilwij imomachtijkawan: ―Xikololokan nochi tlan osobraroj para amitlaj ma ijtlakawi. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yejwan okololojkej katlej osobraroj de yon makuile pan de sebada, iwan okintemitijkej majtlaktle iwan ome chikimej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nijkuak in tlakaj okitakej yon milagro katlej Jesús okichij, okijtojkej: ―Ipan melajka, yen yin profeta katlej otikchixtokaj ma wiki ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero nijkuak in Jesús okimomakak kuenta nik okinekiaj kiwikanij ika chikawak para ma yeto rey, in Yej oksemi oyáj ik ajko ipan tepetl para ompa yetos iselti. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nijkuak otlatleyuak, imomachtijkawan otemokej de ipan tepetl iwan oyajkej itempan mar de Galilea, ");
INSERT INTO nhyNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","otlejkokej itech se barko iwan opéj panoaj oksé lado de yen atl asta pueblo de Capernaum. Ijkuakón yotlatleyuak iwan Jesús mach ya oejkoya. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Opéj ejeka iwan atl opéj motlatlamotla chikawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Iwan nijkuak yoyayaj kej makuile o chikuasen kilómetro itech barko, okitakej in Jesús walnejnemi ipan atl iwan yokualinmajsia. Iwan yejwan omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero Yej okinmilwij: ―Amo ximomawtikan, Nej niJesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ijkuakón yejwan sa tekitl opakej iwan okitlejkoltijkej ijtik barko. Iwan san niman oajsitoj itech tlale kan yejwan oyayaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Sekimej tlakaj omokajkej oksé lado de yen atl. Owalmostlatik, okitakej nik in Jesús mach otlejkok iwan imomachtijkawan itech barko. Okimatiaj nik san yejwan imomachtijkawan oyajkej inselti, iwan Jesús omokaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero oksekimej barkojtin de pueblo de Tiberias, owalajkej serka de yon lugar kan okikuajkej pan satepan de ijkuak in toSeñor okimakak tlasojkamachilistle in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Iwan nijkuak in tlakaj okimomakakej kuenta nik in Jesús mach ompa oyeka, nion imomachtijkawan, otlejkokej itech sekimej barkojtin, iwan oyajkej para Capernaum okitemotoj in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nijkuak okajsitoj in Jesús itech oksé lado de yen atl, okilwijkej: ―Tlamachtij, ¿keman otejkok nian? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iwan Jesús okinnankilij: ―Ipan melajka namechilwia, namejwan annechtemoaj amo porke melawak ankimomakakej kuenta tlan kijtosneki in señal, sino porke onamechtlamakak iwan anmixwikej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amo xitekipanokan por yen tlakuale katlej tlami, sino xitekipanokan por yen tlakuale katlej mach keman tlami iwan katlej kitemaka nemilistle katlej mach keman tlamis. Nej katlej onimochij nitlakatl namechmakas yon tlakuale, por yonik onechwaltitlanke noPapan Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iwan yejwan okitlajtlanijkej: ―¿Tlan moneki tikchiwaskej para ma tikchiwakan tlan Dios kineki? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús okinnankilij: ―Yen yin tlan Dios kineki xikchiwakan. Yej kineki xinechneltokakan Nej porke Yej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Iwan yejwan okilwijkej: ―¿Tlan milagro titechititis para ma tikitakan iwan para ma timitzneltokakan? ¿Tlan milagro titechititis? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","In ya wejkawitl toweyitajwan okikuajkej in pan katlej itoka maná, ne kan tlawaki. Ijkón ken kijta in tiotlajkuilole: “Dios okinmakak pan de ilwikak para ma kikuakan.” ");
INSERT INTO nhyNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iwan Jesús okinmilwij: ―Ipan melajka namechilwia: Mach yen Moisés akin okinmakak in pan de ilwikak, sino yen noPapan katlej kitemaka in melawak pan de ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porke in pan katlej Dios kitemaka yen katlej owaltemok de ilwikak iwan kinmaka nemilistle in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ijkuakón yejwan okilwijkej: ―Señor, xitechmaka nochipa yon pan. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iwan Jesús okinmilwij: ―Yen Nej nipan katlej niktemaka nemilistle. Akin witz nonawak, mach ok keman tiojsiwis. Iwan akin tlaneltokas nonawak, mach ok keman amikis. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero Nej yonamechilwij nik namejwan maski ya annechtlatokej mach annechneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochtin katlej noPapan kimonekiltis ma wikikan nonawak, Nej nikinresibiros iwan mach nikijtos amo. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porke mach oniwaltemok de ilwikak para nikchiwas san tlan Nej niknekis, sino para nikchiwas tlan kineki akin onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iwan noPapan katlej onechwaltitlanke, amo kineki ma nikpolo nion se de nochtin katlej onechinmakak, sino kineki ma nikinyoliti itech nekáj sa iyakatlanka tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Porke noPapan katlej onechwaltitlanke, kineki nochtin akinmej kimatiskej nik Nej niiKone in Dios iwan tlaneltokaskej nonawak, ma kipiakan nemilistle katlej mach keman tlamis. Iwan kineki ma nikinyoliti itech nekáj sa iyakatlanka tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ijkuakón in judiojtin opéj mokualankatlapowiaj de Jesús, porke okijtoj: “Nej nipan katlej oniwaltemok de ilwikak.” ");
INSERT INTO nhyNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iwan okijtojkej: ―¿Amo yen yin Jesús, ikone in José? Tejwan tikixmatij ipapan iwan imaman. ¿Kenik kijta nik in Yej owaltemok de ilwikak? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iwan Jesús okinmilwij: ―Amo xikualankatlajtokan entre namejwan. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mach akaj tlakatl welis witz nonawak san por yej kinekis. Sino san yen noPapan katlej onechwaltitlanke welis kichiwas akaj tlakatl ma wiki nonawak. Iwan Nej nikyolitis itech nekáj sa iyakatlanka tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kajki ijkuilitok itech in tiotlajkuiloltin katlej okijkuilojkej in profetajtin: “Dios kinmachtis nochtin.” Ijkón kiné, nochtin akinmej kikakiskej noPapan iwan kimomakaskej kuenta tlan kinmachtia, witzej nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Amo kijtosneki akaj yokitak in noPapan Dios, sino san yen Nej katlej oniwalaj kan Yej kajki, yen Nej katlej yonikitak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ipan melajka namechilwia: Akin tlaneltoka nonawak kipia nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nej nipan katlej niktemaka nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","In ya wejkawitl namoweyitajwan okikuajkej in pan katlej itoka maná ne kan tlawaki, iwan maski yejwan okikuajkej yon pan, omikkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero akinmej kikuaskej in pan katlej owaltemok de ilwikak, mach mikiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nej nipan katlej niktemaka nemilistle katlej oniwaltemok de ilwikak. Akin kikuas yin pan, yolitos nochipa. In pan katlej nej niktemakas kijtosneki yen notlalnakayo, iwan niktemakas para ma kipiakan nemilistle in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ijkuakón in judiojtin opéj kualanij iwan okijtoayaj entre yejwan: ―¿Kenik yin tlakatl kineki techmakas itlalnakayo ma tikuakan? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús okinmilwij: ―Ipan melajka namechilwia: Tla namejwan amo ankikuaskej notlalnakayo de Nej katlej onimochij nitlakatl, iwan tla amo ankoniskej noeso, mach ankipiaskej nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Akin kikua notlalnakayo iwan koni noeso, kipia nemilistle katlej mach keman tlamis, iwan Nej nikyolitis itech nekáj sa iyakatlanka tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Porke notlalnakayo yon melawak tlakuale, iwan noeso yon melawak tlaonilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Akin kikua notlalnakayo iwan koni noeso, kijtosneki kajki nonawak iwan Nej nikaj inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","NoPapan katlej onechwaltitlanke, kipia nemilistle, iwan Nej nikpia nemilistle inawak. Ijkón noijki akin nechmomajsewia, noijki kipia nemilistle nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yen yin pan katlej owaltemok de ilwikak, iwan yin pan mach ken pan katlej itoka maná katlej okikuajkej in ya wejkawitl namoweyitajwan, iwan maski okikuajkej yon pan yejwan omikkej. Akin kikuas yin pan yolitos nochipa. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús okinmachtij in tlakaj de yin tlamantle ompa Capernaum itech se tiopan de yen judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nijkuak ijkón okikakej in tlakaj katlej onemiaj iwan Jesús, okijtojkej: ―Wel owijtitok para se welis kimomakas kuenta. ¿Akin welis kimomakas kuenta? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pero Jesús okimomakak kuenta nik in yonmej tlakaj mach okiwelitakej tlan okinmilwij, iwan Yej okinmilwij: ―¿Ankualanij por yen tlan namechilwia? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tlan ankiyejyekoskej kiné, tla namejwan annechitaskej Nej katlej onimochij nitlakatl nitlejkos ilwikak kan achtoj onieka? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Se tlakatl ianima yen yon kimaka nemilistle itlalnakayo. Itlalnakayo mach itlaj kipalewia tla kipoloa ianima. Notlajtol katlej yonamechilwij amechmaka nemilistle ijkón ken ianima se tlakatl kimaka nemilistle itlalnakayo. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero katej sekimej de amejwan katlej mach nechneltokaj. Jesús yokimatia desde achtoj akinmej amo otlaneltokayaj iwan akin kitemaktis (kitemaktilis). ");
INSERT INTO nhyNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iwan Jesús okijtoj: ―Por yonik namechilwia ke mach akaj tlakatl welis witz nonawak tla noPapan amo kimonekiltis. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde ijkuakón, miekej tlakaj katlej onemiaj iwan Jesús, okikajkej iwan mach ok Iwan onenkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ijkuakón Jesús okinmilwij in majtlaktle iwan omen imomachtijkawan: ―¿Noijki namejwan ankinekij anyaskej? ");
INSERT INTO nhyNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro okinankilij: ―Señor, ¿akin oksé inawak tiaskej? Tejwatzin tikpia tlajtole katlej kitemaka nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Iwan tejwan yotikneltokakej iwan ya tikmatokej nik tejwatzin tiiyolchipawkaKone in toTajtzin Dios katlej yolitok. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iwan Jesús okinmilwij: ―Nej onamechpejpenke namejwan anmajtlaktin iwan amomen, pero se de amejwan itekipanoj in diablo. ");
INSERT INTO nhyNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús otlajtoaya de yen Judas Iscariote itelpoch in Simón, porke satepan yen okitemaktij (okitemaktilij) in Jesús, maski oyeka se de yen majtlaktle iwan omen imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Satepan de yon, Jesús onemia itech estado de Galilea. Mach okinekia nemis itech estado de Judea, porke in tlayekankej judiojtin okinekiaj kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Iwan yoajsia inmilwiw in judiojtin itoka tabernáculos. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ikniwan Jesús okilwijkej: ―Amo nian ximokawa. Xiwia Judea, para ijkón momomachtijkawan katlej ompa katej ma kinmitakan noijki in milagrostin katlej Tej tikinchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nijkuak akaj tlakatl kineki ma kixmatikan mach kichiwa itlaj tlamantle san ichtaka sino kichiwa teixpan. Tonses, in Tej moneki xikchiwa inmixpan nochtin in tlakaj para ijkón nochtin ma kitakan tlan tikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nion yen ikniwan mach okineltokayaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iwan Jesús okinmilwij: ―Mach ya ajsi tonale para nias ompa, pero para amejwan san katlij yej tonale welis anyaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","In tlaltikpaktlakaj mach welis amechkokoliskej namejwan. Pero Nej nechkokoliaj, porke Nej nikinmilwia nik yejwan kichiwaj tlan mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Namejwan xiwian ilwitl. Nej mach nias, porke mach ya ajsi tonale para nias ompa. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iwan satepan de ijkón okinmilwij, Jesús ompa omokaj itech estado de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Satepan de ijkuak yoyajkej ikniwan, Jesús noijki oyáj itech yon ilwitl, oyáj san ichtaka para amo ma kitakan nochtin tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","In tlayekankej judiojtin okitemoayaj ompa itech ilwitl, iwan okijtoayaj: ―¿Kanin kajki in yon tlakatl itoka Jesús? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Nochtin tlakaj omotlapowiayaj de Yej. Sekimej okijtoayaj: “Jesús kuale tlakatl.” Iwan oksekimej okijtoayaj: “Jesús mach kuale, san kinkajkayajtinemi in tlakaj.” ");
INSERT INTO nhyNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero mach akaj otlapoaya de Yej inmixpan tlakaj porke okinmiimakasiaj in tlayekankej judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Iwan nijkuak ya tlajko yawi in yon ilwitl, Jesús okalakke ijtik in weyi tiopan iwan ompa opéj tlamachtia. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","In judiojtin sa omotlajtlachialtiayaj (omomajmawtiayaj) iwan okijtoayaj: ―¿Kenik in yin tlakatl wel kimati miek iwan nion amo omoixtlamachtij? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús okinnankilij: ―Notlamachtilis mach kisa de Nej, sino yon witz de noPapan Dios katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tla akaj kineki kichiwas tlan Dios kimonekiltia, welis kimomakas kuenta nik notlamachtilis witz de Dios, iwan mach de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Akin tlapoa san de yej itlayejyekolis, kijtosneki kineki ma kiweyikixtikan. Pero Nej nikneki nikweyikixtis katlej onechwaltitlanke. Nej nikijta tlan melawak, iwan mach nitlakajkayawa. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés oamechmakak namejwan in tlanawatile pero nion se de amejwan mach kichiwa tlan kijta yon tlanawatile. ¿Tlanik namejwan ankinekij annechmiktiskej? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","In tlakaj okinankilijkej: ―Tej tikpia demonio. ¿Akin kineki mitzmiktis? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús okinmilwij: ―Aminochtin sa anmotlajtlachialtijkej (omomajmawtijkej) san por onikpajtij se kokoxke nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés oamechilwij xikchiwakan in sirkunsisión (maski mach yen Moisés okipewaltij in sirkunsisión sino katlej ya wejkawitl iweyitajwan). Iwan namejwan ankisirkunsidaroaj se chokotzin maski ma yeto weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Axan kiné, tla namejwan ankisirkunsidaroaj se chokotzin nijkuak weyi tonale porke itech yon tonale okitokaroj mosirkunsidaros, namejwan maski ma yeto weyi tonale ankisirkunsidaroaj porke ankinekij anmokawaskej kuale itech itlanawatil in Moisés. ¿Tlanik kiné namejwan ankualanij nonawak por onikpajtij se tlakatl nijkuak weyi tonale? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amakaj xikistlakawikan san por ankinekiliskej. Sino xikistlakawikan tla melawak ankimatij nik mach kuale tlan okichij. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sekimej katlej ochantiaj Jerusalén okijtoayaj: ―¿Amo yen yin tlakatl katlej kitemojtinemij para kimiktiskej? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xikitakan, tlapojtok inmixpan nochtin in tlakaj, iwan mach akaj itlaj kilwia. ¿Xamo in tekiwajkej melawak yokineltokakej nik in yin tlakatl yen Cristo? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero tejwan tikmatij de kan owalaj in yin tlakatl. Iwan nijkuak witz in Cristo, mach akaj kimatis de kan witz. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesús ok otlamachtijtoka ijtik in weyi tiopan, iwan nijkuak ijkón okikakke, okijtoj chikawak: ―Namejwan annechixmatij iwan ankimatij de kan oniwalaj. Nej amo oniwalaj san por Nej nikneki, sino oniwalaj porke onechwaltitlanke in Dios katlej itech onkaj tlan melawak, iwan katlej namejwan mach ankixmatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero Nej nikixmati porke Nej oniwalaj de Yej inawak, iwan Yej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Por yonik okinekiaj kikitzkianij. Pero amakaj okikitzkij porke mach ya oajsia in tonale para kikitzkiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iwan miekej otlaneltokakej inawak, iwan okijtoayaj: ―Tejwan tikneltokaj nik yen yin Cristo porke mach akaj oksé welis witz iwan kinchiwas okachi wejweyin milagrostin ken yin Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","In fariseos okikakej tlan okijtoayaj in tlakaj de yen Jesús. Ijkuakón in tlayekankej tiopixkej iwan in fariseos okintitlankej sekimej mayoltin para ma kikitzkikan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iwan Jesús okijtoj: ―Sa kanaj keski tonale namowan nietos, iwan satepan nimokuepas inawak noPapan Dios katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Namejwan annechtemoskej, pero mach annechajsiskej. Porke kan Nej nias, namejwan mach welis anyaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","In judiojtin opéj motlajtlaniaj entre yejwan: ―¿Kanin yas iwan amo welis tikajsiskej? ¿Kox yas innawak in tojudiojikniwan katlej chantitokej ipan intlal in griegojtin? ¿Kox yas kinmachtitij in griegojtin? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tlan kijtosneki tlan kijta: “Annechtemoskej, pero mach annechajsiskej, porke kan Nej nias, namejwan mach welis anyaskej”? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","In sa iyakatlanka tonale de yon ilwitl, katlej okachi weyi tonale, Jesús omoketzke iwan okijtoj chikawak: ―Tla akaj amiki, ma wiki nonawak iwan ma atli. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tla akaj nechneltokas, tonses ipan iyolo meyas atl katlej kitemaka yankuik nemilistle, ijkón ken kijta in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús ijkón okijtoj kijtosneki akinmej kineltokaskej in Jesús kiresibiroskej in Espíritu Santo. Ijkuakón ayamo owalaya in Espíritu Santo porke in Jesús mach ya oyaya ilwikak para kiweyikixtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sekimej de yonmej tlakaj nijkuak ijkón okikakej okijtojkej: ―Ipan melajka yin yen profeta katlej otikchixtokaj ma wiki. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Iwan oksekimej okijtoayaj: ―Yin yen Cristo. Pero sekimej okijtoayaj: ―Amo. Mach yen Cristo. Porke in Cristo mach witz de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","In tiotlajkuilole kijta nik in Cristo kipia de witz nelwatl de yen rey David. Iwan noijki kijta nik witz de pueblo de Belén kan ochantia in David. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Por yonik in tlakaj omoxelojkej por yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sekimej de yejwan okinekiaj kikitzkianij. Pero mach akaj okikitzkij. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","In mayoltin oyajkej innawak in tlayekankej tiopixkej iwan innawak in fariseos. Iwan yejwan okintlajtlanijkej in mayoltin: ―¿Tlanik mach ankiwalwikakej? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","In mayoltin otlanankilijkej: ―Mach keman tikkakij akaj tlakatl ijkón nik tlapoa. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tonses in fariseos okinmilwijkej in mayoltin: ―¿Noijki namejwan yoamechkajkayaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Kox ya ankitakej akaj de totekiwajkawan o noso akaj de tejwan tifariseos yotitlaneltokakej inawak Jesús? ");
INSERT INTO nhyNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero nekatej tlakaj katlej mach kixmatij in tlanawatile de Moisés iwan tlaneltokaj inawak yon Jesús, Dios kintlajtlakoltis. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo, katlej okachi achtoj oyáj de yuak okitato in Jesús, iwan katlej oyeka noijki fariseo, okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Totlanawatil kijta nik mach welis tiktlajtlakolmamaltiskej se tlakatl san tekitl, tla mach achtoj tikyolkuitiaj para tikmatiskej tlan okichij. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Iwan yejwan okilwijkej: ―¿Tej noijki xamo tiwitz de Galilea? Xiktemo itech tiotlajkuilole iwan tikmomakas kuenta nik mach keman kisas nion se profeta de Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ijkuakón kada se de yejwan oyajkej para inchan. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero Jesús oyáj kan Olivostepetl. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Owalmostlatik san kualkan, oksemi oyáj itech in weyi tiopan, iwan miekej tlakajtin omijkuanijkej inawak. Iwan Jesús omotlalij opéj kinmachtia. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ijkuakón in tlamachtijkej de itlanawatil in Moisés iwan in fariseos okiwikakej ompa se siwatl katlej okajsikej momekatijtok iwan se tlakatl. Iwan okiketzkej tlatlajko. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Iwan okilwijkej in Jesús: ―Tlamachtij, yin siwatl otikajsikej kimomekatijtok se tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","In tlanawatile de Moisés otechnawatij ma tikmiktikan ika tetl akin ijkón kichiwa. ¿Iwan Tej ken tikijta? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Okitlajtlanijkej ijkón porke okinekiaj kitlajtlakolmayawiskej para kajsiskej itlaj tlan ika kitilwiskej. Pero Jesús omotooloj iwan opéj tlajkuiloa ipan tlale ika imajpil. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero komo okachi okitlajtlaniayaj, Yej omoyekketzke iwan okinmilwij: ―Tla akaj de amejwan mach kipia itlaj tlajtlakole, ma yen achtoj ma kimotla ika tetl. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iwan oksemi omotooloj iwan oksemi opéj tlajkuiloa ipan tlale. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iwan yejwan nijkuak ijkón okikakej, okistiajkej sejsen por sejsen. Opéj achtoj kisaj katlej okachi tetajtzitzintin. Nijkuak omokaj sa yen Jesús iwan siwatl katlej oyeka tlatlajko, ");
INSERT INTO nhyNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ijkuakón oksemi omoyekketzke in Jesús iwan okitlajtlanij in siwatl: ―Siwatl, ¿katlimej katlej omitztilwiayaj? ¿Amakaj omitztlajtlakoltij? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","In siwatl okinankilij: ―Amo, Señor. Nion se. Iwan Jesús okilwij: ―Nion Nej mach nimitztlajtlakoltia. Xiwia, iwan ayakmo xitlajtlako. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús oksemi okintlapowij in tlakaj, iwan okinmilwij: ―Nej nitlanextle de yen tlaltikpaktlakaj, akin walmuikas nonawak, mach semi nemis ijtik tlatleyualotl, sino kipias tlanextle katlej kitemaka nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Iwan in fariseos okilwijkej: ―Tlan Tej tikijta kisa san de Tej. Iwan tlan tikijta mach melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús okinnankilij: ―Tlan Nej nikijta yon melawak, maski kisa de Nej tlan nikijta, porke Nej nikmati de kan oniwalaj iwan kan niawi. Pero namejwan mach ankimatij de kan oniwalaj nion kan niawi. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Namejwan antetlajtlakoltiaj ijkón ken kichiwaj in tlaltikpaktlakaj. Nej mach akaj niktlajtlakoltia. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero tla Nej nitetlajtlakoltis, nitetlajtlakoltis itech tlan melawak, porke mach nitetlajtlakoltia san Nej, sino titetlajtlakoltiaj Nej iwan noPapan katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Namejwan itech namotlanawatil ankipiaj ijkuilitok ke nijkuak omen testigojtin parejo kijtaj san se tlajtole, tonses melawak tlan kijtaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nej namechmatiltia tlan de Nej, iwan noPapan katlej onechwaltitlanke noijki amechmatiltia de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iwan yejwan okitlajtlanijkej: ―¿Kanin kajki moPapan? Jesús okinnankilij: ―Namejwan mach annechixmatij, iwan nion mach ankixmatij noPapan. Tla amejwan anechixmatinij, noijki ankixmatinij noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesús okijtoj yon tlajtole nijkuak otlamachtijtoka ijtik in weyi tiopan, kan oyeka in kaja kan okonkajkawayaj in tomin para yen weyi tiopan. Iwan mach akaj okikitzkij, porke mach ya oajsia tonale para kikitzkiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús oksemi okinmilwij: ―Nej nias, iwan namejwan annechtemoskej, pero anmikiskej ipan nanmotlajtlakol porke kan Nej nias namejwan mach welis anyaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ijkuakón in judiojtin okijtojkej: ―¿Xamo momiktis, por yonik kijta nik mach welis tiaskej kan Yej yawi? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iwan Jesús okinmilwij: ―Namejwan anpowij de nian tlaltikpak, pero Nej nipowi de ilwikak. Namejwan san antlaltikpaktlakaj, pero Nej amo. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por yonik namechilwia nik anmikiskej ipan namotlajtlakol, porke tla amo annechneltokaj nik in Nej niCristo, anmikiskej ipan namotlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ijkuakón yejwan okitlajtlanijkej: ―Tonses, ¿akin Tej? Jesús okinnankilij: ―Yonamechilwij desde achtoj akin Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nikpia miek tlamantle tlan namechilwis iwan miek tlan namechtlajtlakoltis namejwan. Melawak tlan nikijta, ijkón ken katlej onechwaltitlanke Yej melawak. Iwan tlan Nej onikakke de Yej, yen yon tlan nikimilwia in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero in judiojtin mach okimomakakej kuenta ke okintlapowiaya de yen iPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Por yonik okinmilwij: ―Nijkuak namejwan annechajkokuiskej ajkopan Nej katlej onimochij nitlakatl, ijkuakón ankimomakaskej kuenta nik yen Nej. Iwan ankimomakaskej kuenta nik mach itlaj nikchiwa san tlan kisa de Nej, sino sanwel nikijta tlan noPapan yonechmachtij. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Porke katlej onechwaltitlanke Yej nowan kajki. NoPapan mach nechkawa noselti, porke Nej nochipa nikchiwa tlan Yej kipaktia. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nijkuak in Jesús otlanke okijtoj nochi yon tlajtole, miekej otlaneltokakej inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús okinmilwij in judiojtin katlej otlaneltokakej inawak: ―Tla namejwan ankichijtoskej tlan kijta notlamachtil, tonses melawak anyeskej annomomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Iwan ankixmatiskej tlan melawak, iwan yon tlan melawak amechmakixtis de inawak namoteko para ayakmo ma amechnawatijto. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Iwan yejwan okinankilijkej: ―Tejwan tiwalajtokej nelwatl de Abraham, iwan mach semi akaj tikpiaj oksé kej toteko. ¿Kenik tikijta in Tej nik titechmakixtis de inawak toteko? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iwan Jesús okinmilwij: ―Ipan melajka namechilwia, nochtin akinmej kichiwaj tlajtlakole, kijtosneki yon tlajtlakole yen inteko. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Iwan se tlakatl katlej yen yon iteko mach welis powis itech ifamilia in toTajtzin Dios, pero se katlej tekone de Dios yon kemaj powi iktlanke (ik tlami) itech ifamilia in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ijkón kiné, tla Nej niiKone in Dios namechmakixtis de inawak namoteko, tonses namejwan anmokawaskej melawak antlamakixtiltin. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nikmati nik namejwan anwalajtokej nelwatl de Abraham. Pero ankinekij annechmiktiskej porke mach ankiresibiroaj ipan namoyolo tlan namechilwia. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nej nikijta tlan noPapan nechititia, iwan namejwan ankichiwaj tlan namopapan amechnawatia. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iwan yejwan okilwijkej: ―Tejwan topapan yen Abraham. Iwan Jesús okinmilwij: ―Tla Abraham yeni yen namopapan, tonses ankichiwanij tlan yej okichij. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Maski yonamechilwij tlan melawak tlan Dios nechititia, namejwan ankinekij annechmiktiskej. Abraham mach ijkón okichij. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Namejwan ankichiwaj ijkón ken tlan kichiwa namopapan. Yejwan okilwijkej: ―Tejwan mach tiichtakapiltin, tejwan tikpiaj san se topapan, topapan yen toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ijkuakón Jesús okinmilwij: ―Tla yen Dios yeskia namopapan, namejwan annechtlasojtlanij, porke Nej oniwalaj de Dios ixko yin tlaltikpak. Mach oniwalaj san por Nej oniknekke, sino porke Dios onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ankimatij por tlanik mach ankimomakaj kuenta tlan namechilwia? Mach ankimomakaj kuenta porke mach ankinekij ankikakiskej tlan namechilwia. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Namejwan namopapan yen diablo, iwan namejwan ankichiwaj tlan yej kineki. In diablo yej temiktij desde opejke in tlaltikpak. Mach keman itlaj kijta tlan melawak porke mach itlaj kipia ipan iyolo tlan melawak. Nochipa san tlakajkayajtinemi porke yen yon itekiw, porke yipa tekajkayaj, iwan yen tetaj de nochtin akinmej tlakajkayawaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero komo Nej nikijta tlan melawak, por yonik namejwan mach annechneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Akin de amejwan welis nechnextilis nik nikpia itlaj tlajtlakole? Iwan tla nikijta tlan melawak, ¿tlanik mach annechneltokaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Akin powi inawak Dios, kikaki itlajtol in Dios, pero komo namejwan mach anpowij inawak Dios, por yonik mach ankinekij ankikakiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iwan ijkuakón in judiojtin okilwijkej: ―Yompa tlan tikijtaj, Tej tisamaritano iwan tikpia demonio. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iwan Jesús okinnankilij: ―Nej mach nikpia nion se demonio, sino Nej nikweyimati in noPapan. Pero namejwan mach annechweyimatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nej mach nikintemoa in tlakaj para ma nechweyikixtikan, onkaj se katlej kintemoa para ma nechweyikixtikan, iwan katlej kinmixkomakas akinmej amo nechweyikixtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ipan melajka namechilwia, akin kichiwas tlan Nej nikijta, mach keman mikis. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ijkuakón in judiojtin okinankilijkej: ―Axan kuale tikmomakaj kuenta nik melawak tikpia demonio. Abraham iwan nochtin in profetajtin omikkej, iwan Tej tikijta: “Akin kichiwas tlan Nej nikijta, mach keman mikis.” ");
INSERT INTO nhyNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Kox okachi tiweyikistok in Tej ke topapan Abraham? Yej omikke iwan in profetajtin noijki omikkej. ¿Akin timomachilia in Tej? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iwan Jesús okinnankilij: ―Tla Nej niktemoani noweyikixtilis, tonses noweyikixtilis mach itlaj ipatij. Pero katlej nechweyikixtia, yen noPapan, katlej namejwan ankijtaj yen namoDios. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Namejwan mach ankixmatij. Nej nikixmati, iwan tla nikijtoani mach nikixmati, nietoskia noijki nitekajkayaj ken namejwan. Pero Nej melawak nikixmati, iwan nikchiwa tlan Yej kijta. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","In ya wejkawitl namopapan Abraham, opakke porke okimatke nik niwitz ixko yin tlaltikpak. Yej itech itlaneltokalis onechitak iwan por yonik opakke. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ijkuakón in judiojtin okilwijkej in Jesús: ―Ayamo tikpia omenpoale iwan majtlaktle xiwitl, ¿iwan tikijta otikitak in Abraham? ");
INSERT INTO nhyNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iwan Jesús okinmilwij: ―Ipan melajka namechilwia, desde antes de tlakatis in Abraham, Nej yipa yonieka. ");
INSERT INTO nhyNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ijkuakón in judiojtin okonintilankej sekimej temej para kimojmotlaskej in Jesús. Pero Yej omotlaatij, opanok intzalko iwan okiske de ijtik in weyi tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nijkuak Jesús oyaya ipan ojtle, okitak se tlakatl katlej mach otlachiaya desde itlakatilis. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iwan imomachtijkawan okitlajtlanijkej: ―Tlamachtij, ¿tlanik yin tlakatl otlakatke mach tlachia? ¿Por otlajtlakojkej ipapanwan, o noso porke yej otlajtlakoj? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús okinnankilij: ―Mach por yej otlajtlakoj nion mach por otlajtlakojkej ipapanwan. Sino para itech ma mota tlan Dios weli kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Itech yinmej tonaltin Nej nikpia de nikchiwas in tekitl de noPapan Dios katlej onechwaltitlanke, porke ajsis tonale nijkuak mach ok akaj welis tekipanos. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mientras Nej nikaj ixko yin tlaltikpak, nikaj kej se tlanextle katlej kinyoltlawilia in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Satepan de ijkuak ijkón okijtoj, ochijchak ipan tlale, okipaatlak achitzin akuitlatl iwan okixaltilij ipan ixtololowan in tlakatl katlej mach tlachia. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Iwan okilwij: ―Xiwia ximixpakati itech ameyale katlej itoka Siloé ―Siloé kijtosneki Tlatitlanile. In tlakatl katlej mach tlachia oyáj omixpakato. Iwan nijkuak omokuepato ya owelik otlachixke. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ijkuakón nochtin katlej ibesinoswan iwan nochtin katlej achtoj okitayaj omijtlanijtinemia, okijtojkej: ―¿Amo yen yin tlakatl katlej omijtlanijtinemia? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sekimej okijtoayaj: ―Yej yin tlakatl. Oksekimej okijtoayaj: ―Amo, mach yej. Maski ijkón mota. Pero in tlakatl yej inewian okijtoaya: ―Yen nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Iwan okitlajtlanijkej: ―¿Iwan kenik axan ya kuale titlachia? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yej okinnankilij: ―In tlakatl katlej itoka Jesús okichij achitzin akuitlatl, iwan onechixaltilij ipan noixtololowan, iwan onechilwij: “Xiwia ximixpakati itech ameyale katlej itoka Siloé.” Oniaj, iwan nijkuak onimixpakke, ya kuale onitlachixke. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iwan okitlajtlanijkej: ―¿Kanin kajki in yon tlakatl? Iwan yej okinnankilij: ―Mach nikmati. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Satepan okiwikakej in tlakatl katlej mach otlachiaya okinmixpantilijtoj in fariseos. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Oyeka weyi tonale nijkuak in Jesús okichij akuitlatl, iwan okitlachialtij in tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","In fariseos okitlajtlanijkej in tlakatl kenik ya weli tlachia. Iwan yej okinmilwij: ―Onechixaltilij akuitlatl itech noixtololowan, onimixpakke, iwan axan ya kuale nitlachia. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ijkuakón sekimej fariseos okijtojkej: ―In tlakatl katlej ijkón okichij mach owalaj de Dios, porke mach kitlakita in weyi tonale. Iwan oksekimej okijtoayaj: ―Pero, ¿kenik weli kinchiwa milagrostin in tla Yej tlajtlakolej? Iwan mach oyekaj san se tlajtole entre yejwan iwan omoxelojkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Iwan oksemi okitlajtlanijkej in tlakatl katlej mach otlachiaya: ―¿Iwan tej, tlan tikijta de nekáj tlakatl katlej omitztlachialtij? Iwan yej okijtoj: ―Nej nikijta nik in yon tlakatl profeta. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero in tlayekankej judiojtin mach okineltokayaj kox melawak mach otlachiaya iwan axan ya kuale tlachia, iwan asta okinnotzkej itajwan. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iwan okintlajtlanijkej: ―¿Yen yin namotelpoch katlej namejwan ankijtaj otlakatke mach tlachia? ¿Kenik in axan ya kuale tlachia? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Itajwan otlanankilijkej: ―Tikmatij nik in yej totelpoch, iwan tikmatij nik otlakatke mach tlachia. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero mach tikmatij kenik ya weli tlachia, nion mach tikmatij akin okitlachialtij. Xiktlajtlanikan yej, mach ok tzikitzin, yej welis amechilwis kenik opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Itajwan ijkón okijtojkej porke okinmiimakasiaj in tlayekankej judiojtin, porke in tlayekankej judiojtin yokichijkaj san se tlajtole ke tla akaj kijtos nik Jesús yen Cristo, kikixtiskej iktlanke (ik tlami) de itech intiopan. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por yonik okijtojkej itajwan: “Xiktlajtlanikan yej, mach ok konetl.” ");
INSERT INTO nhyNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","In tlayekankej judiojtin oksemi okinotzkej in tlakatl katlej mach otlachiaya, iwan okilwijkej: ―Xikijto tlan melawak ixpan Dios. Porke tejwan tikmatij nik in Jesús Yej tlajtlakolej. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Iwan yej okinnankilij: ―Nej mach nikmati kox tlajtlakolej o noso amo. San tlan nej nikmati, mach onitlachiaya iwan axan ya weli nitlachia. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Iwan oksemi okitlajtlanijkej: ―¿Tlan omitztoktij? ¿Kenik omitztlachialtij? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Iwan yej okinnankilij: ―Yonamechilwij, iwan mach ankineltokaj, ¿tlanik ankinekij oksemi ma namechilwi? ¿Noijki namejwan ankinekij anyeskej imomachtijkawan? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ijkuakón okajwakej iwan okilwijkej: ―Tej tiimomachtijkaw de Yej. Pero tejwan tiimomachtijkawan de Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tejwan tikmatij nik in Dios okinotzke in Moisés, pero yin tlakatl nion mach tikmatij de kan owalaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","In tlakatl katlej mach otlachiaya okinnankilij: ―¿Kenijki? ¡Kenik namejwan mach ankimatij de kan owalaj, iwan nej yonechtlachialtij! ");
INSERT INTO nhyNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tikmatij nik in Dios mach kinkaki in tlajtlakolejkej. Kinkaki san yen katlej kiweyikixtiaj iwan kichiwaj tlan Dios kimonekiltia. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde ijkuak opéj in tlaltikpak mach semi tikkakij akaj tlakatl ma kitlachialti se katlej mach tlachia desde itlakatilis. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tla yin tlakatl amo walani de Dios, mach itlaj welini kichiwani. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iwan yejwan okilwijkej: ―Tej otitlakatke titentok de tlajtlakole, ¿iwan axan tikneki titechmachtis? Iwan okikixtijkej iktlanke (ik tlami) de itech intiopan. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús okimatke nik in tlakatl katlej mach otlachiaya okikixtijkej iktlanke (ik tlami) de itech intiopan. Iwan nijkuak in Jesús okinamikke yon tlakatl, okitlajtlanij: ―¿Titlaneltoka inawak iKone in Dios? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Iwan yej okilwij: ―Señor, xinechilwi akin yon, para ma nitlaneltoka inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iwan Jesús okilwij: ―Tej yotikitak. Yen Nej katlej axan Nej mowan nimotlapowijtok. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ijkuakón in tlakatl omotlankuaketzke iyakapan Jesús, iwan okilwij: ―Nimitzneltoka, tejwatzin noSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Iwan Jesús okilwij: ―Nej oniwalaj ixko yin tlaltikpak para nikinmilwis kox kuale o noso amo kuale tlan kichiwaj in tlaltikpaktlakaj. Iwan ijkón, katlej mach tlachiaj ma tlachiakan, iwan katlej tlachiaj mach ma tlachiakan. ");
INSERT INTO nhyNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Sekimej fariseos katlej ik ompa oyekaj, nijkuak ijkón okikakej, okitlajtlanijkej: ―¿Kijtosneki tejwan noijki mach titlachiaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iwan Jesús okinnankilij: ―Tla melawak namejwan yeskia mach antlachianij, mach ankipianij tlajtlakole. Pero komo namejwan ankijtaj nik kuale antlachiaj, tonses namotlajtlakol amotech kajki, porke mach melawak ankimomakaj kuenta tlan kijta notlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Ipan melajka namechilwia, in tlajpixke kalaki itech puerta de yen korral, iwan akin kalakis oksé lado iwan amo itech puerta de yen korral, yon ichtekke. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Porke in tlajpixke katlej kinmonekuitlawia ichkamej kalaki itech puerta. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Se tlakatl kitlapolia puerta in tlajpixke para ma kalaki, iwan ichkamej kitenkakij. Iichkawan kinnotza ika intoka, iwan kinkixtia de ijtik inkorral. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Iwan nijkuak nochtin yokinkixtij, kinwika kinyekana. Iwan ichkamej ikuitlapan yawij, porke kitenkakij. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero se katlej mach kixmatij mach iwan yawij, sino kicholiliaj, porke mach kitenkakij se katlej mach kixmatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús okintlalilij yon ejemplo, pero yejwan mach okimomakakej kuenta tlan Jesús okinekia ma kimatikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesús oksemi okinmilwij: ―Ipan melajka namechilwia, Nej nikaj kej se puerta kanik kalakij ichkamej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nochtin akinmej owalajkej antes de Nej niwitz, oyajkej ichtekej, iwan ichkamej mach okintenkakej nijkuak okinnotzkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nej nikaj kej nipuerta. Iwan akin notech kalakis, momakixtis. Yetos kej se ichka katlej kalaki iwan kisa kan puerta iwan kajsi itlakual. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’In ichtekke owalaj san para tlachtekis, san temiktia iwan san teixpoloa. Pero Nej oniwalaj para in tlakaj ma kipiakan nemilistle. Iwan yon nemilistle tentok de nochi tlamantle tlan kuale. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yen Nej katlej nikuale nitlajpixke. In kuale tlajpixke kitemaka inemilis por yen ichkamej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero akin san tetlajpialia, nijkuak kita witz in koyotl, kinkajtewa in ichkamej iwan choloa, porke mach melawak tlajpixke iwan ichkamej mach iaxkawan. In koyotl kinkitzkia sekimej ichkamej iwan oksekimej kinchochololtia. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Yon katlej san tetlajpialia choloa porke san tekipanoj iwan por yonik mach kinchiwa kuenta in ichkamej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Yen Nej katlej nikuale nitlajpixke. Ijkón ken noPapan nechixmati iwan Nej nikixmati noPapan, no ijkón Nej nikinmixmati nochkawan iwan yejwan nechixmatij. Iwan Nej niktemaka nonemilis por yen ichkamej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Noijki nikinpia oksekimej ichkamej katlej mach katej ijtik yin korral, iwan moneki nikinwalwikas noijki. Yejwan nechtenkakiskej, iwan nochtin yeskej san sekan, iwan yetos san se tlajpixke. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’NoPapan nechtlasojtla porke niktemaka nonemilis por yen nochkawan, para satepan oksemi nikajsis nonemilis nijkuak nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mach akaj welis nechkixtilis nonemilis, sino Nej nonewian niktemaka. Nikpia poder para niktemakas nonemilis, iwan nikpia poder para oksemi nikajsis nonemilis. Ijkón noPapan onechnawatij ma nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Nijkuak in judiojtin okikakej yon tlajtole, oksemi omoxelojkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Miekej de yejwan okijtoayaj: ―¿Tlanik ankineltokaj tlan amechilwia? Kipia se demonio iwan kualoko. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Oksekimej okijtoayaj: ―Akin kipia demonio mach ijkón nik tlapoa. Se tlakatl katlej kipia demonio mach welis kitlachialtis se katlej mach tlachia. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ompa Jerusalén okichijtokaj ilwitl katlej okichiwayaj kada xiwitl para kelnamikij nijkuak okiyankuilijkej in weyi tiopan. Iwan oyeka meroj nijkuak sewa. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús ik ompa onentoka itech weyi tiopan itech Korredor de Salomón. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ijkuakón in judiojtin okiyawalojkej iwan okitlajtlanijkej: ―¿Asta keman kuale tikmatiskej de Tej? Tla melawak yen Tej tiCristo, melajka xitechilwi. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús okinnankilij: ―Yonamechilwij iwan mach annechneltokaj. In tlamantin katlej Nej nikinchiwa ika ipoder noPapan kiteititiaj nik Nej niCristo. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero namejwan mach annechneltokaj, porke namejwan mach annochkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nochkawan nechtenkakij, iwan Nej nikinmixmati iwan yejwan witzej nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nej nikinmaka nemilistle katlej mach keman tlamis. Iwan mach semi mikiskej, iwan mach akaj welis nechinkixtilis. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NoPapan katlej onechinmakak nochkawan, Yej kipia okachi weyi ipoder iwan mach akaj onkaj oksé ken Yej, iwan mach akaj welis kinkixtilis. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","NoPapan iwan Nej tisetitokej san se. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","In judiojtin oksemi okonintilankej temej para kimojmotlaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero Jesús okinmilwij: ―Amoixpan nikchijtiwitz miek tlamantle ika ipoder in noPapan. ¿Tlan tlamantle mach kuale onikchij komo para ika xinechmojmotlakan ika tetl? ");
INSERT INTO nhyNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","In judiojtin okinankilijkej: ―Mach timitzmojmotlaskej por tlan kuale tikchiwa. Sino porke tikixpanwia in toTajtzin Dios. Tej san tikomokiera tlakatl, iwan timochiwa kej yeskia tiDios. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús okinmilwij: ―Itech namotlanawatil ijkuilitok nik in Dios okijtoj: “Nej onikijtoj, namejwan andiosmej.” ");
INSERT INTO nhyNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tikmatij ke tlan kijta in tiotlajkuilole mach welis se kipatlas. Iwan Dios okintokayotij diosmej in tlakaj katlej okiresibirojkej itlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Iwan tla Dios onechpejpenke iwan onechwaltitlanke ixko yin tlaltikpak, ¿tlanik kiné, namejwan ankijtaj ke nikixpanawia in Dios por onikijtoj nik in Nej niiKone? ");
INSERT INTO nhyNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tla amo nikinchiwa milagrostin ken noPapan kinchiwa, amo xinechneltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero tla nikinchiwa, xikinneltokakan kiné in milagrostin katlej nikinchiwa, maski amo ankineltokaj tlan namechilwia. Para xikneltokakan iwan xikmatikan nik melawak noPapan nowan kajki iwan Nej Iwan nikaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Oksemi okinekiaj kikitzkianij, pero Jesús okincholilij. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús omokuepke oksemi ik ne lado de yen weyatl Jordán, kan otlakuateekiaya in Juan Tlakuateekij, iwan ompa omokaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Miekej tlakaj oyajkej inawak, iwan okijtoayaj: ―Maski in Juan mach okichij itlaj milagro, nochi tlan okijtoj de yin Jesús ya nele melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iwan miekej otlaneltokakej inawak Jesús itech yon lugar. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Oyeka se tlakatl katlej omokokoaya itoka Lázaro, katlej ochantia iwan ikniwan María iwan Marta itech pueblo de Betania. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Yon María, ikni in Lázaro, yen katlej okiteekilij ajwiakayotl in toSeñor itech ikxiwan iwan okinwajwachilij ika itzonkal. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ijkón kiné, María iwan Marta otlatitlankej ma kilwitij in Jesús: ―Señor, moamigo Lázaro chikawak mokokoa. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nijkuak okikakke in Jesús okijtoj: ―Yon kokolistle mach kimiktis, sino ika moteititis iweyikixtilis in Dios. Iwan ika yon kokolistle noijki ika moteititis noweyikixtilis Nej katlej niiKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús sa tekitl okintlasojtlaya in Marta, in María iwan Lázaro, ");
INSERT INTO nhyNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","iwan maski okilwijkej nik in Lázaro chikawak mokokoa, Yej ok omokaj ome tonale kan oyeka. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Satepan okimilwij imomachtijkawan: ―Ma tiwian oksemi itech estado de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Imomachtijkawan okilwijkej: ―Tlamachtij, mach ya wejkika ompa in judiojtin okinekiaj mitzmiktianij ika tetl, ¿iwan oksemi tikneki tias ompa? ");
INSERT INTO nhyNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús okinmilwij: ―¿Amo kipia in tonale majtlaktle iwan ome ora? Tla se nemis nijkuak tlanestok, mach se motepotlamis porke tlanestok. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero tla se nemis nijkuak tlatleyua, welis se motepotlamis porke mach tlanestok. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Satepan Jesús okinmilwij: ―In tokni Lázaro kochtok, iwan Nej nikijxitis. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Imomachtijkawan okilwijkej: ―Señor, tla san kochtok, kijtosneki pajtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús ijkón okijtoj porke in Lázaro yomikke, iwan imomachtijkawan okiyejyekojkej san kochi. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ijkuakón Jesús okinyekilwij: ―In Lázaro yomikke. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nipaki porke mach ompa onieka. Nipaki porke yon se kuale para amejwan para okachi xitlaneltokakan. Axan ma tiwian ma tikitatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ijkuakón in Tomás, katlej kitokayotiaj Kuatejtzin, okinmilwij in oksekimej momachtijkej: ―Tejwan noijki ma tiwian, para ma timikikan san sekan iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nijkuak in Jesús oajsito Betania, okimatiltijkej nik in Lázaro ya kipia nawi tonale de toktok. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania oyeka serka de Jerusalén, san kanaj eyi kilómetro de wejka. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Iwan miekej judiojtin oyajkej otetlajpalotoj ichan Marta iwan María, para kinyolojchikawaskej por omikke in Lázaro. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nijkuak in Marta okimatke nik in Jesús ya ompa witz, okiske okinamiktiaj, pero in María omokaj kalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta okilwij in Jesús: ―Señor, tla nian tieni, nokni mach mikini. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero nej nikmati nik in Dios mitzmakas nochi tlan tiktlajtlanilis. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús okinankilij: ―Mokni moyolkuis (moyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta okilwij: ―Ya nikmati nik moyolkuis nijkuak nochtin in mikkamej moyolkuiskej nijkuak sa iyakatlanka tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Tonses in Jesús okilwij: ―Nej nikinyolitis in mikkamej iwan Nej nikinmakas nemilistle. Akin nechneltoka, maski mikis, moyolkuis iwan kipias nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Iwan nochtin katlej ok yolitokej iwan nechneltokaj, mach keman mikiskej. ¿Tikneltoka tlan nimitzilwia? ");
INSERT INTO nhyNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta okilwij: ―Nikneltoka, Señor. Nikneltoka nik tejwatzin tiCristo, titeKone de Dios. Yen tejwatzin katlej tejwan otikchiayaj ma wiki ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Satepan de ijkón okijtoj in Marta, oyáj okinotzato in María katlej ikni, iwan okilwij ichtaka: ―In Tlamachtij nian kajki iwan mitznotza. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nijkuak ijkón okikakke in María, omoketewak iwan oyáj okitato in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús ayamo okalakia itech pueblo, ok oyeka kan Marta okinamikke. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","In judiojtin katlej oyekaj kalijtik katlej okiyolosewijtokaj in María, nijkuak okitakej in María omoketewak iwan okistewak, yejwan noijki okikistewakej iwan oyajkej ikuitlapan. Yejwan okiyejyekojkej yawi chokatij kan toktok in Lázaro. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Nijkuak in María oajsito kan oyeka in Jesús, omotlankuaketzke ikxitlan, iwan okilwij: ―Señor, tla nian tieni, nokni mach mikini. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús okitak in María sa tekitl choka iwan noijki okinmitak in judiojtin noijki chokaj katlej owalayaj ikuitlapan. Ijkuakón Jesús sa tekitl omoyolkokoj iwan oyoltilinke. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iwan okintlajtlanij: ―¿Kan nankitookakej? Yejwan okilwijkej: ―Xiwiki xikitaki, Señor. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iwan Jesús ochokak. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ijkuakón in judiojtin okijtojkej: ―Xikitakan sa tekitl okitlasojtlaya. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Iwan sekimej de yejwan okijtoayaj: ―Yin Jesús katlej okitlachialtij in tlakatl katlej mach otlachiaya, ¿amo owelik itlaj okichij para amo ma miki in Lázaro? ");
INSERT INTO nhyNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús oksemi omoyolkokoj iwan omijkuanij kan toktok in Lázaro. Oyeka ijtik se mikkakuyoktle, okamatzaktoka ika se tetl patlaktik. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iwan Jesús okijtoj: ―Xikijkuanikan in tetl. Marta ikni in mikkatl, okilwij in Jesús: ―Señor, yotzojyayak, porke yakipia nawi tonale de omikke. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús okinankilij: ―¿Amo onimitzilwij tla tikneltokas, tikitas imawisotlanex in Dios? ");
INSERT INTO nhyNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ijkuakón okijkuanijkej in tetl. Jesús oajkopantlachixke, iwan okijtoj: ―Papan, nimitztlasojkamachilia porke tinechkaki. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nej nikmati nik nochipa tinechkaki, iwan ijkín nikijta para ke in tlakaj katlej nian katej ma kineltokakan nik tejwatzin otinechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nijkuak otlanke ijkón okijtoj, ijkuakón okijtoj chikawak: ―¡Lázaro, xiwalkisa! ");
INSERT INTO nhyNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Iwan Lázaro katlej omikka okiske kikimilitiwitz ika tzotzole itech ikxiwan iwan itech imawan, iwan ixkikimilitiwitz ika se tzotzole kej payoj. Iwan Jesús okinmilwij: ―Xiktotomakan iwan xikkawakan ma wia. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ijkuakón otlaneltokakej inawak Jesús miekej judiojtin katlej otetlajpalotoj inawak María porke okitakej tlan Jesús okichij. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero sekimej de yejwan oyajkej okinmitatoj in fariseos, okinmilwitoj tlan Jesús okichij. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ijkuakón in fariseos iwan in tlayekankej tiopixkej omololojkej iwan omotlapowijkej, okijtojkej: ―¿Tlan tikchiwaskej? Yin tlakatl kinchiwa miekej milagrostin. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tla tikkawiliskej ijkón ma kichiwa, nochtin tlaneltokaskej inawak, iwan tekiwajkej romanostin witzej iwan kixitiniskej in toweyi tiopan katlej tlatiochiwaloj, iwan kimoaxkatiskej in topaís. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero se de yejwan katlej itoka Caifás, katlej oyeka weyi tiopixke itech yon xiwitl, okinmilwij: ―Namejwan mach itlaj ankimatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nion mach ankimomakaj kuenta nik okachi kuale para tejwan ma miki se tlakatl por nochtin in tlakaj, ke ma timikikan tinochtin tejwan tijudiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pero tlan okijtoj in Caifás mach okiske de yej itlayejyekolis, sino komo oyeka weyi tiopixke itech yon xiwitl, Dios okitlajtoltij in Caifás nik in Jesús mikis por yen judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Iwan amo mikis san por yen judiojtin, sino noijki mikis para kinmololos nochtin ikonewan Dios katlej xintokej ixko nochi in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Desde yon tonale in tekiwajkej judiojtin opéj kitemoaj kenik kimiktiskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Por yonik in Jesús mach ok omonextiaya inmixpan in judiojtin. Sino okiske de itech yon región de Judea iwan oyáj itech se pueblo itoka Efraín, katlej kajki serka kan tlawaki. Iwan ompa omokaj iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Opoliwia sa kanaj keski tonale para ajsiki imilwiw in judiojtin katlej itoka pascua. Miekej tlakaj de miekej pueblojtin yowalajtokaj Jerusalén para mochipawaskej de intlajtlakol antes de pewas yon ilwitl de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ijkuakón okitemoayaj in Jesús, iwan nijkuak yoyekaj nochtin itech weyi tiopan omotlajtlaniayaj: ―¿Tlan ankiyejyekoaj? ¿Kox witz ilwitl in Jesús, o noso amo? ");
INSERT INTO nhyNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","In fariseos iwan in tlayekankej tiopixkej otlanawatijkej tla akaj kimatis kanin kajki in Jesús, ma kinmatilti, para kikitzkiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Chikuasen tonale antes de yen ilwitl de pascua, Jesús oyáj itech pueblo de Betania, kan chanti in Lázaro katlej Jesús okiyolitij. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ompa okichiwilijkej se tlakuale in Jesús. Marta okinserbiroaya, iwan Lázaro noijki ompa oewatoka inakastlan Jesús otlakuajtokaj ipan mesa. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","María okiwalkuik kej tlajko litro de ajwiakayotl de nardo, katlej sa tekitl patíoj, iwan okinokilij ipan ikxiwan in Jesús. Satepan okikxiwajwatzke ika itzonkal, iwan nochi in kalijtik otlaajwiayak ika in ajwiakayotl. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ijkuakón itelpoch in Simón itoka Judas Iscariote, katlej oyeka se de yen imomachtijkaw in Jesús, iwan katlej okitemaktij (okitemaktilij) satepan, okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tlanik amo omonamakak yin ajwiakayotl? Porke yin ajwiakayotl ipatij ken tlan kitlani se tlakatl katlej tlapalewia de se xiwitl, iwan se kinmakani in tomin katlej pobrestin. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ijkón okijtoj mach por melawak okinmiknomatia in pobrestin, sino porke oyeka ichtekke. Judas oyeka tesorero de nochtin imomachtijkawan in Jesús, iwan okichtekia yon tomin katlej okitkitinemia. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iwan Jesús okilwij: ―Xikkawa. Porke yin tlan kichiwa, yen para nekáj tonale nijkuak nechtookaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","In pobrestin nochipa ankinpiaskej, pero Nej mach nochipa annechpiaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Miekej judiojtin okimatkej nik in Jesús oyeka itech pueblo de Betania, iwan oyajkej ompa, amo san para kitaskej in Jesús sino noijki para kitaskej in Lázaro. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","In tlayekankej tiopixkej okijtojkej kimiktiskej in Lázaro noijki. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Porke por yen Lázaro miekej judiojtin okikajkej tlan achtoj okineltokayaj iwan opéj tlaneltokaj inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Owalmostlatik, nijkuak okimatkej nik in Jesús yowalaya para Jerusalén, ijkuakón miekej tlakaj owalajkej ilwitl. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Okimatejtekej sekin soyatl iwan okiskej okinamikitoj in Jesús, iwan otzajtziaj chikawak: ―¡Hosana! ¡Ma Dios kitiochiwa katlej okiwaltitlanke para tlanawatis! ¡Ma Dios kitiochiwa in Rey de Israel! ");
INSERT INTO nhyNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús okajsik se burro iwan ipan otlejkok, ijkón ken kijta in tiotlajkuilole: ");
INSERT INTO nhyNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Amo ximomawtikan, tlakaj de Sión. Xikitakan namoRey ya walmuika. Yetiwitz ipan se burro. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Itech yon tonale imomachtijkawan mach okimomakakej kuenta tlan kijtosneki yon tlamantle tlan otlamochij. Pero satepan nijkuak in Jesús oyáj ilwikak, okelnamikej ke nochi yon yokatka ijkuilitok itech tiotlajkuilole kan otlapoaya de yen Jesús, iwan ijkón otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","In tlakaj katlej oyekaj iwan Jesús iwan okitakej nijkuak okitzajtzilij in Lázaro de kan imikkakuyok iwan okiyolitij oksemi satepan de omikke, otetlapowiayaj de tlan okitakej otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Por yonik, in tlakaj okiskej okinamikitoj in Jesús, porke okimatkej okichij se weyi milagro. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero in fariseos okimolwiayaj entre yejwan: ―Xikitakan, nochtin in tlakaj yawij inawak iwan tejwan mach itlaj tiwelij tikchiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Itech yon ilwitl de pascua noijki ompa oyekaj sekimej griegojtin katlej noijki oyajkej okiweyikixtitoj in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yonmej griegojtin omijkuanijkej inawak Felipe katlej oyeka de pueblo de Betsaida de estado de Galilea. Iwan okilwijkej: ―Señor, tiknekij tikitaskej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Tonses in Felipe oyáj okilwito in Andrés tlan okilwijkej. Iwan satepan san sekan oyajkej okilwitoj in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ijkuakón Jesús okinmilwij: ―Yoajsiko in tonale nijkuak in Nej katlej onimochij nitlakatl nechweyikixtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ipan melajka namechilwia, tla se semiya amo se kitookas, nochipa yetos san ijkón se semiya. Pero tla se kitookas kitemakas miek semiya. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Akin amo kitemakas inemilis nonawak, kipolos nijkuak mikis. Iwan akin kitemakas inemilis nonawak ixko yin tlaltikpak, mach kipolos, sino kipias nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tla akaj kineki nechtekipanos, moneki nowan ma wiki. Iwan kan Nej nietos, ompa yetos noijki notekipanoj. Tla akaj nechtekipanos, noPapan kiweyikixtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Axan sa tekitl nimoyolkokoa. ¿Iwan tlan nikijtos? Mach welis nikijtos: “Papan, xinechmakixti de itech yin tekokojkayotl katlej axan ya nipanotok.” Mach welis ijkón nikijtos, porke por yonik oniwalaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Satepan Jesús okilwij iPapan: ―Papan, xikweyikixti motoka. Iwan ijkuakón omokakke se tlajtole de ilwikak, okilwij in Jesús: ―Yonikweyikixtij iwan oksemi nikweyikixtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","In tlakaj katlej ompa oyekaj, nijkuak okikakej in yon tlajtole, okijtojkej okikakej se tlatikuinalistle. Iwan oksekimej okijtoayaj: ―Se ángel okinotzke. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesús okinmilwij: ―Yon tlajtole katlej omokakke mach omokakke para yen Nej ma nikkaki, sino omokakke para yen namejwan xikkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Axan yoajsiko tonale para Dios kinmixkomakas (kintzonmanas) katlej mach nechneltokaj, iwan mach ok tlanawatis in Amo Kuale Tlakatl ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iwan nijkuak nechmajmasoltiskej itech krus nian ixko yin tlaltikpak, nikinyoltilanas nochtin in tlakaj para ma wikikan nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ijkón okijtoj para ma kimomakakan kuenta kenik mikis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iwan tlakaj okinankilijkej: ―In tiotlajkuilole techilwia nik in Cristo yolitos iktlanke (ik tlami). ¿Kenik in Tej tikijta ke katlej omochij tlakatl kipiloskej itech krus para ma miki? ¿Akin yon omochij tlakatl? ");
INSERT INTO nhyNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesús okinmilwij: ―Sa kanaj keski tonale nietos amowan Nej katlej nikintlawilia in tlakaj ipan inyolo. Xinechneltokakan axan mientras anwelij para amo ximopolokan iktlanke (ik tlami). In tlakaj katlej mach kinekij ma nikintlawili, nemij ijtik tlatleyualotl iwan mach kimomakaj kuenta kox mopoloskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Nej nikaj kej nitlanextle. Xikneltokakan notlajtol katlej namechmatiltia nik Nej namechnotza, iwan anyeskej annokonewan iwan Nej namechtlawilis ipan namoyolo. Nijkuak in Jesús otlanke ijkón okijtoj, oyáj de ompa iwan okinmonetlatilij. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Maski Jesús okinchiwaya miekej wejweyin milagrostin inmixpan nochtin tlakaj, mach nochtin otlaneltokayaj inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ijkón otlamochij para ma mochiwa tlan okijkuiloj in profeta Isaías: Señor, mach miekej kineltokaj tlan tejwan tikinmatiltiaj de tejwatzin. Mach akaj kimomaka kuenta kox welis tikmakixtis ika mopoder. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ijkón kiné, mach oweliaj okineltokayaj, iwan in Isaías noijki okijkuiloj: ");
INSERT INTO nhyNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios okintoktij amo ma tlachiakan iwan ma yoltlakuawakan, para amo ma yektlachiakan ika inmixtololowan, iwan amo ma kimomakakan kuenta ika inyolo, iwan amo ma moyolkuepakan, iwan ijkón amo nikinpajtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías ijkón okijtoj porke okitak iweyikixtilis in Jesús, iwan otlajtoj de Yej. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iwan miekej judiojtin otlaneltokakej inawak Jesús, asta intekiwajkawan noijki otlaneltokakej, pero mach akaj otlapoaya de yon, porke okinmiimakasiaj in fariseos, porke mach okinekiaj ma kinkixtikan iktlanke (ik tlami) de itech intiopan. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yejwan okinekiaj mokawaskej kuale inwan tlakaj maski amo ma mokawakan kuale iwan Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iwan Jesús okijtoj chikawak: ―Akin nechneltoka, amo san Nej nechneltoka, sino noijki kineltoka in noPapan katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iwan akin nechita, kita noijki katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nej oniwalaj ixko yin tlaltikpak kej se tlanextle. Iwan nikintlawilia ipan inyolo nochtin akinmej nechneltokaj, iwan mach keman yeskej ijtik tlatleyualotl. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero akin kikaki notlajtol iwan amo kineltoka, mach yen Nej niktlajtlakoltis. Porke Nej mach oniwalaj para nikintlajtlakoltis in tlaltikpaktlakaj, Nej oniwalaj para nikinmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Akin amo nechneki iwan amo kineki kikakis notlajtol, onkaj akin kitlajtlakoltis. Kijtosneki yen tlajtole katlej Nej nikijta, yen yon kitlajtlakoltis itech nekáj sa iyakatlanka tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Porke Nej mach nikijta san tlan Nej nikyejyekoa. NoPapan katlej onechwaltitlanke, Yej onechnawatij tlanon moneki nikijtos iwan tlanon moneki nitlamachtis. ");
INSERT INTO nhyNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Iwan nikmati ke tlan noPapan onechnawatij ma namechilwi, kitemaka nemilistle katlej mach keman tlamis. Ijkón kiné, tlan Nej nikijta, nikijta ijkón ken Yej onechnawatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sa se tonale opoliwia para ilwitl de pascua. Iwan Jesús yokimatia nik yoajsiko in tonale para kikajtewas yin tlaltikpak iwan yas inawak iPapan. Yej nochipa okintlasojtlak imomachtijkawan katlej Iwan oyekaj ixko yin tlaltikpak. Iwan sa tekitl okintlasojtlak asta omotemakak ma kimiktikan por yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nijkuak in Jesús otlakuajtoka inwan imomachtijkawan, ijkuakón in diablo okalakke ipan iyolo in Judas Iscariote, itelpoch in Simón, para ma kitemakti (ma kitemaktili) in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús yokimatia nik iPapan yokimaktilij nochi tlamantle imak, iwan nik in Yej owalaj de Dios, iwan nik oksemi mokuepas inawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jesús omoketzke de kan otlakuajtokaj, okikixtij itlaken iwan omotlajkoilpij ika se tzotzole. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Satepan okitlalij atl ijtik se ajpatzintle, iwan opéj kinmikxipaka iwan satepan opéj kinmikxiwajwatza ika se tzotzole katlej ika omotlajkoilpijka. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nijkuak okitokaroto kiikxipakas in Simón Pedro, okilwij: ―Señor, ¿tejwatzin tinechikxipakas? ");
INSERT INTO nhyNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús okinankilij: ―Axan mach tikmomaka kuenta tlanik ijkón nikchiwa, pero satepan tikmomakas kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro okilwij: ―Nej mach semi tinechikxipakas. Iwan Jesús okilwij: ―Tla amo nimitzikxipakas, mach nowan tipowis. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro okinankilij: ―Tla ijkón, Señor, amo san nokxiwan xikinpaka, sino noijki xikinpaka nomawan iwan notzontekon. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ijkuakón Jesús okilwij: ―Akin yomaltij, moneki sa yen ikxiwan kinpakas porke ya kajki nochi chipawak. Iwan namejwan ya ankatej anchipawakej maski mach aminochtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesús yokimatia akin kitemaktis (kitemaktilis), iwan por yonik okijtoj: “Mach aminochtin anchipawakej.” ");
INSERT INTO nhyNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Satepan de ijkuak otlanke okinmikxipajpakke, Jesús oksemi okonakij itlaken, iwan omotlalij oksemi itech mesa iwan okinmilwij: ―¿Ankimomakakej kuenta tlanik ijkón onikchij? ");
INSERT INTO nhyNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Namejwan annechnotzaj Tlamachtij iwan annechnotzaj Señor. Iwan yon kuale tlan ankijtaj porke melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pues tla Nej niSeñor iwan niTlamachtij onamechikxipakke, namejwan no ijkón moneki xikchiwakan se iwan oksé. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nej namechmaka se ejemplo para namejwan no ijkón xikchiwakan ken Nej onikchij. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ipan melajka namechilwia, se katlej san tekipanoj mach weli mochiwa okachi weyi ken iteko, nion se tlatitlanile mach weli mochiwa okachi weyi ken katlej tlatitlani. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tla ankimomakaj kuenta iwan ankichiwaj yin tlamantle tlan namechilwia, tonses xipakikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Tlan nikijta amo nikijta para aminochtin. Nej nikmati akinmej onikinpejpenke. Iwan kipia de mochiwas tlan kijta in tiotlajkuilole: “Akin nowan tlakua, omokuepke nokontra.” ");
INSERT INTO nhyNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Desde axan namechilwia maski ayamo tlapanoa, para ke nijkuak tlapanos, xikneltokakan nik yen Nej niCristo katlej namejwan ankichiayaj ma wiki. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ipan melajka namechilwia, tla akaj de amejwan amechresibiroa kej notlatitlanil, kijtosneki Nej nechresibiroa. Akin Nej nechresibiroa, kijtosneki kiresibiroa noijki akin onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Satepan de ijkuak ijkón okijtoj, Jesús sa tekitl omoyolkokoj, iwan okinyekilwij: ―Ipan melajka namechilwia, nik se de amejwan nechtemaktis (nechtemaktilis). ");
INSERT INTO nhyNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ijkuakón imomachtijkawan opéj motlajtlataj se iwan oksé, porke mach okimatiaj akin ijkón kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Se de yejwan katlej Jesús sa tekitl okitlasojtlaya, oyeka inakastlan otlakuajtoka, ");
INSERT INTO nhyNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","in Simón Pedro okichiwilij señas para ma kitlajtlani in Jesús akin ijkón kichiwas katlej kitemaktis. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Yej omijkuanij okachi asta ik ielpan in Jesús, iwan okitlajtlanij: ―Señor, ¿akin ijkón kichiwas? ");
INSERT INTO nhyNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús okinankilij: ―Nikajakis se pedaso pan, iwan akin Nej nikmakas, yen yon. Ijkuakón okajakij se pedaso pan iwan okimakak in Judas Iscariote, itelpoch in Simón. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Iwan niman nijkuak Judas okikuaj in pan, in Satanás okalakke ipan iyolo. Iwan Jesús okilwij: ―Tlan tikyejyekojtok tikchiwas, xikchijtiwetzi san niman. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Iwan nion se de yejwan katlej otlakuajtokaj itech mesa mach okimomakakej kuenta por tlanik ijkón okilwij. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Komo in Judas oyeka tesorero, sekimej okiyejyekojkej xamo in Jesús okilwij ma wia ma kikowati itlaj para yen ilwitl, o noso itlaj ma kinmaka in pobrestin. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Nijkuak in Judas otlanke okikuaj in pan, niman okiske. Iwan ijkuakón oyeka ya yuak. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Satepan de ijkuak in Judas okiske, in Jesús okijtoj: ―Axan moteititis noweyikixtilis de Nej katlej onimochij nitlakatl, iwan moteititis iweyikixtilis in Dios itech tlan Nej nikchiwas. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Iwan tla Nej katlej onimochij nitlakatl nikteititis iweyikixtilis in Dios, in Dios noijki kiteititis noweyikixtilis. Iwan kichiwas san niman. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nokonewan, mach ok wejkika amowan nietos. Namejwan annechtemoskej, iwan ijkón ken onikinmilwij in oksekimej judiojtin, no ijkón axan namejwan namechilwia: Mach welis anyaskej kan Nej niawi. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nej namechmaka yin yankuik tlanawatile: Ximotlasojtlakan se iwan oksé. Ijkón ken Nej namechtlasojtla, namejwan no ijkón ximotlasojtlakan se iwan oksé. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Tla namejwan amotlasojtlaskej se iwan oksé, nochtin in tlakaj kimomakaskej kuenta nik melawak namejwan annomomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro okitlajtlanij in Jesús: ―Señor, ¿kanin timuikas? Jesús okinankilij: ―Kan Nej niawi, axan mach welis nowan tias, pero satepan welis nowan tias. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedro okilwij: ―Señor, ¿tlanik amo welis nimitzwikas? Nej asta welis nimotemakas ma nechmiktikan por tejwatzin. ");
INSERT INTO nhyNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús okinankilij: ―¿Ipan melajka tikneki timotemakas maski ma mitzmiktikan por Nej? Ipan melajka nimitzilwia, antes de tzajtzis in kaxtil, tej ijkuakón yotikijtoj eyi buelta mach tinechixmati. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Amo ximotlanemililtikan nion amo ximoyolkokokan. Xikneltokakan Dios iwan xinechneltokakan Nej noijki. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Ompa ilwikak kan kajki noPapan katej miekej kalmej, iwan Nej niawi nitlayektlaliti para amejwan. Nijkuak nochi ya kuale yetos, ijkuakón niwalmokuepas oksemi. Niwitz namechnotzaki para xiekan iktlanke (ik tlami) kan Nej nietos. Iwan tla amo ijkón yeni, tonses Nej namechyekilwiani. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Namejwan ankimatij kan Nej niawi, iwan ankixmatij in ojtle. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás okilwij in Jesús: ―Señor, mach tikmatij kan tiawi, ¿kenik tikmatiskej katlij yen ojtle? ");
INSERT INTO nhyNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús okinankilij: ―Yen Nej niojtle, yen Nej nimelawak iwan yen Nej ninemilistle. Tla akaj amo nechneltoka, mach welis ajsis inawak noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tla amejwan ankimatinij akin Nej, noijki ankimatinij akin noPapan. Iwan desde axan ya ankixmatij, porke ya ankitakej. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Tonses in Felipe okilwij: ―Señor, xitechkawili ma tikitakan moPapan, iwan ika yon tiyolopachiwiskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús okinankilij: ―Yakipia miek tonale namowan nikaj, ¿iwan ayamo tinechixmati Felipe? Akin yonechitak, kijtosneki noijki yokitak in noPapan. ¿Kenik kiné in tej tikijta ma nanmechititi in noPapan? ");
INSERT INTO nhyNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Amo tikneltoka nik in Nej nikaj iwan noPapan iwan noPapan kajki nowan? Tlan Nej namechilwia mach nikijta san tlan Nej nikyejyekoa. NoPapan katlej kajki nowan, yen kichiwa in tekitl por medio de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xinechneltokakan nik Nej nikaj iwan noPapan iwan noPapan kajki nowan. Iwan tla amo ankineltokaj tlan namechilwia, xikinneltokakan siera notlatekipanolwan tlan Nej nikinchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ipan melajka namechilwia, akin nechneltoka, noijki kinchiwas in tlatekipanoltin katlej Nej nikinchiwa, iwan kinchiwas asta okachi wejweyin porke Nej niawi inawak noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iwan nochi tlan ankitlajtlaniskej ika notoka, Nej nikchiwas, para ijkón ma kiweyikixtikan noPapan por medio de Nej niiKone. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tla itlaj ankitlajtlaniskej ika notoka, Nej nikchiwas. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tla amejwan annechtlasojtlaj, xikchiwakan tlan namechnawatia. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iwan Nej niktlajtlanilis noPapan ma amechwaltitlanili oksé Teyolojchikaj, para ma yeto nochipa amowan, ");
INSERT INTO nhyNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yen Espíritu Santo katlej kiteititia tlan melawak. In tlaltikpaktlakaj katlej mach noaxkawan, mach welis kipiaskej yon Espíritu porke mach kitaj iwan nion mach kixmatij. Pero namejwan ankixmatij, porke amowan kajki iwan nochipa amowan yetos. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Mach namechkawas amiknomej. Nej niwalmokuepas oksemi iwan nietos amowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mach ok wejkika in tlaltikpaktlakaj mach ok nechitaskej. Pero namejwan annechitaskej. Nej niyolitok nochipa, iwan por yonik namejwan noijki anyolitoskej nochipa. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Itech nekáj tonale namejwan ankimatiskej nik in Nej nikaj itech noPapan, iwan namejwan ankatej notech, iwan Nej nikaj amotech. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Akin kipia notlanawatil, iwan kichiwa, yon tlakatl nechtlasojtla. Iwan akin nechtlasojtla, noPapan kitlasojtlas, iwan Nej noijki niktlasojtlas iwan nimoteititis itech. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ijkuakón oksé Judas (amo Judas Iscariote) okitlajtlanij: ―Señor, ¿tlanik timoteititis san towan iwan amo inwan tlaltikpaktlakaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús okinankilij: ―Akin nechtlasojtla, kichiwa tlan nikijta. Iwan noPapan kitlasojtlas, iwan noPapan iwan Nej tiwitzej para timochantiskej ipan iyolo. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Akin amo nechtlasojtla, mach kichiwa kuenta tlan nikijta. Iwan in tlajtole katlej namejwan ankikakij mach noaxka, sino iaxka in noPapan katlej onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Namechilwia nochi yin tlamantle mientras ok nikaj amowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero in Teyolojchikaj, yen Espíritu Santo katlej noPapan kiwaltitlanis ika notoka, Yej amechmachtis nochi tlamantle. Iwan amechelnamiktis nochi tlamantle katlej Nej yonamechilwij. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Namechkajtewilia yolosewilistle. Iwan noyolosewilis katlej namechmakas mach ken kitemakaj in tlaltikpaktlakaj. Amo xitlanemilikan nion amo ximomawtikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya ankikakej nik yonamechilwij nik niawi, iwan oksemi niwitz para nietos amowan. Tla annechtlasojtlanij ipan melajka, tonses anpakinij porke niawi inawak noPapan. Porke noPapan okachi weyikistok ke Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Axan kiné, yonamechilwij antes de tlapanos, para ke nijkuak tlapanos xitlaneltokakan nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Mach ok wejkika namechtlapowis, porke ompa witz in diablo katlej kinnawatia in tlaltikpaktlakaj. Maski yej mach welis itlaj nechtoktis. ");
INSERT INTO nhyNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero Nej nikchiwas tlan nechnawatia noPapan, para ijkón ma kimatikan in tlaltikpaktlakaj nik melawak niktlasojtla noPapan. Ximoketzakan. Ma tiwian de nian. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Yen Nej katlej melawak niuvaskuawitl iwan noPapan yen kitekipanoa in uvaskuawitl. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tla se nomayo amo tlaki, kitzonteki. Pero tla kuale tlaki, kichipawas para ma tlaki okachi. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Namejwan ya ankatej anchipawakej por yen tlajtole katlej Nej yonamechilwij. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xiekan notech, iwan Nej nietos amotech. Se imayo in uvaskuawitl mach welis tlakis san iselti. Moneki tlakitzkijtos itech itlaktzonyo. Ijkón noijki namejwan. Mach welis itlaj ankichiwaskej tla amo anyeskej notech. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nej nikaj kej niuvaskuawitl, iwan namejwan ankatej kej annomamayowan. Akin tlakitzkijtos notech iwan Nej nitlakitzkijtos itech, kitemakas miek tlakilotl. Porke tla amo anyeskej notech mach welis itlaj ankichiwaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Akin amo yetos notech, kitekiskej iwan kitlamotlaskej kalan kej se imayo in uvaskuawitl katlej mach kuale, iwan wakis. Satepan kololoskej iwan kitlamotlaskej ijtik tlitl para ma tlatla. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Tla namejwan nochipa anyeskej notech, iwan notlajtol yetos amotech, xiktlajtlanikan nochi tlan ankinekiskej, iwan Dios amechmakas. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Moweyikixtia noPapan nijkuak namejwan ankitemakaj miek tlakilotl, iwan ijkón mota noijki nik namejwan annomomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nej namechtlasojtla namejwan ijkón ken noPapan nechtlasojtla. Xiekan ika notlasojtlalis katlej Nej ika namechtlasojtla. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tla ankichiwaskej tlan Nej namechnawatia, anyeskej itech notlasojtlalis. Ijkón ken Nej noijki nikchiwa tlan nechnawatia noPapan iwan nikaj itech itlasojtlalis. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nej namechilwia nochi yin tlajtole para xipakikan ken Nej nipaki, iwan namopakilis ma momiekili. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yen yin tlan namechnawatia xikchiwakan: Ximotlasojtlakan ken Nej namechtlasojtla. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Akin kitemakas inemilis por yen iamigoswan kijtosneki sa tekitl kintlasojtla. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tla amejwan ankichiwaskej tlan Nej namechnawatia, kijtosneki amejwan annoamigoswan. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mach ok namechnotzas kej annotekipanojkawan, porke se katlej san tekipanoj mach kimati tlan kichiwa iteko. Nej namechnotzas annoamigoswan, porke yonamechmatiltij nochi tlan noPapan onechilwij. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mach yen namejwan annechpejpenkej, sino yen Nej onamechpejpenke. Iwan namechmakatok namotekiw para xiwian kan namechtitlani. Nej nikneki namejwan nochipa xiktlakilijtokan miek tlakilotl. Iwan ijkón nochi tlan ankitlajtlaniliskej noPapan ika notoka, Yej amechmakas. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Tlan Nej namechnawatia xikchiwakan yen yin: Ximotlasojtlakan se iwan oksé. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tla in tlaltikpaktlakaj amechkokoliaj, xikmatikan nik in Nej yonechkokolijkej okachi achtoj ke namejwan. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tla namejwan noijki anyenij ken katej in antlaltikpaktlakaj, in tlaltikpaktlakaj amechtlasojtlanij ken yejwan motlasojtlaj. Pero Nej onamechpejpenke namejwan de itech yonmej tlaltikpaktlakaj, iwan por yonik yejwan amechkokoliaj porke mach ok inwan anpowij. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xikelnamikikan tlan onamechilwij: “Se katlej san tekipanoj mach weli mochiwa okachi weyi ken iteko.” Tla Nej nechtlatlalochtiaj, namewan noijki amechtlatlalochtiskej. Iwan tla Nej onechkakilijkej, namejwan noijki amechkakiliskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Namejwan amechtoktiskej nochi yon tlamantle porke annechneltokaj, iwan porke yejwan mach kixmatij akin onechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Tla Nej amo niwalani, iwan nion amo nikintlapowiani, tonses mach kipianij tlajtlakole, pero axan mach itlaj kipiaj tlan kimotenwiskej komo para kijtoskej nik mach kipiaj tlajtlakole. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Akin Nej nechkokolia, noijki kikokolia in noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tla Nej amo nikchiwani entre yejwan itlaj tlamantle katlej mach semi akaj weli kichiwa, tonses mach kipianij tlajtlakole. Pero miek tlamantle yokitakej yonikchij, iwan maski ijkón, techkokoliaj Nej iwan noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ijkón tlapanoa para ma mochiwa in tlajtole katlej kajki ijkuilitok itech tiotlajkuilole katlej yejwan itech mokitzkiaj: “Nechkokoliaj iwan nion mach onkaj tlan ika.” ");
INSERT INTO nhyNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Nej namechwaltitlanilis in Teyolojchikaj katlej witz de noPapan. In Teyolojchikaj yen Espíritu katlej melawak, katlej witz de inawak noPapan. Nijkuak Yej witz, amechmatiltis de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Iwan namejwan noijki ankitematiltiskej de Nej porke namejwan anyekaj nowan desde ijkuak opéj nitlamachtia. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Namechilwia yin tlajtole para amo xikpolokan namotlaneltokalis. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Namejwan amechkixtiskej iktlanke (ik tlami) de itech amotiopan, iwan ajsis tonale tla akaj amechmiktis kiyejyekos ke ika yon kitekipanoa in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ijkón kichiwaskej porke mach kixmatij noPapan iwan nion Nej mach nechixmatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Namechilwia nochi yin tlan tlapanos para ke nijkuak ajsis ora, xikelnamikikan tlan Nej yonamechilwij. ’Achtoj mach onamechilwij tlan axan namechilwia, porke onieka amowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero axan Nej niawi inawak noPapan katlej onechwaltitlanke. Iwan nion se de amejwan mach nechtlajtlania kan niawi. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yej pewa anmoyolkokoaj por yonamechilwij yin tlajtole. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero Nej namechilwia tlan melawak, ke okachi kuale para namejwan ma niwia. Porke tla amo nias, in Teyolojchikaj mach witz para yetos amowan. Pero tla nias, Nej nikkualtitlanis. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nijkuak Yej witz, kinmatiltis in tlaltikpaktlakaj nik nemij itech tlajtlakole iwan nik moneki moyolkuepaskej, iwan kinmatiltis nik welis yeskej yolchipawakej inawak Dios, iwan nik in Dios noijki kinmixkomakas nochtin in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","In Teyolojchikaj kinmatiltis in tlaltikpaktlakaj nik in yejwan tlajtlakolchijtokej porke mach tlaneltokaj nonawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yej kinmatiltis nik in Nej melawak nikpia nonemilis chipawak inawak noPapan Dios, porke Nej nimokuepas kan kajki noPapan iwan mach ok annechitaskej. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Iwan Yej kinmatiltis in tlaltikpaktlakaj nik in Dios kinmixkomakas (kintzonmanas) nochtin katlej kichiwaj tlan amo kuale, porke in diablo, katlej tlanawatia ixko yin tlaltikpak, yokitlajtlakoltijkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Nikpia ok sekin tlajtole katlej nikneki namechilwis, pero axan mach welis ankimomakaskej kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Iwan nijkuak witz in Espíritu katlej melawak, Yej amechyekanas itech nochi tlan melawak. Porke mach kijtos itlaj san tlan Yej kiyejyekos, sino nochi tlan kikakis yen yon kijtos. Iwan amechmatiltis tlan satepan tlapanos. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yej kichiwas in tlakaj ma nechweyikixtikan porke amechmachtis miek tlamantle de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nochi tlan iaxka noPapan noijki Nej noaxka. Por yonik onikijtoj nik amechmachtis miek tlamantle de Nej. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Mach ok wejkika namejwan mach ok annechitaskej, iwan mach wejkawas oksemi annechitaskej, porke Nej niawi inawak noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ijkuakón sekimej de imomachtijkawan omotlajtlanijkej: ―¿Tlan kijtosneki yon tlan techilwia: “Mach ok wejkika namejwan mach ok annechitaskej, iwan mach wejkawas oksemi annechitaskej”, iwan tlan kijtosneki: “Porke Nej niawi inawak noPapan”? ");
INSERT INTO nhyNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tlan kijtosneki: “Mach ok wejkika”? Mach tikmomakaj kuenta tlan kijta. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús okimomakak kuenta nik okinekiaj kitlajtlanianij, iwan okinmilwij: ―Nej yonamechilwij mach ok wejkika namejwan mach ok annechitaskej, iwan mach wejkawas oksemi annechitaskej. ¿Yen yon tlan namejwan anmotlajtlaniaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ipan melajka namechilwia, namejwan anchokaskej iwan anmoyolkokoskej, iwan in tlaltikpaktlakaj pakiskej. Pero maski namejwan anmoyolkokoskej, namoneyolkokolis mokuepas pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nijkuak se siwatl ya kitlakatilis ikone, kikokoa itlalnakayo, porke yoajsiko iora para kitlakatilis ikone. Pero satepan de ijkuak yotlakatke ikone, mach ok kelnamiki kox okikokoj itlalnakayo, sino ya kipia pakilistle porke otlakatke se konetl ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ijkón noijki namejwan, axan anmoyolkokoaj. Pero oksemi annechitaskej, iwan anpakiskej, iwan mach akaj welis amechkixtilis namopakilis. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Itech nekáj tonale mach ok itlaj annechtlajtlaniskej. Ipan melajka namechilwia, noPapan amechmakas nochi tlan ankitlajtlaniliskej ika notoka. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Asta axan, namejwan mach itlaj ankitlajtlanij ika notoka. Xiktlajtlanikan iwan ankiresibiroskej, para namopakilis ma momiekili. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Nej namechilwijtok yin tlajtole ika ejemplos. Pero ajsis tonale mach ok namechtlapowis ika ejemplos, sino namechtlapowis ika tlajtole katlej okachi mach owij para ankimomakaskej kuenta de noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Itech nekáj tonale, namejwan ankitlajtlaniliskej noPapan itlaj tlamantle ika notoka. Nej mach nikijta nik moneki niktlatlawtis noPapan por amejwan, ");
INSERT INTO nhyNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","porke noPapan yipa amechtlasojtla. Yej amechtlasojtla porke namejwan annechtlasojtlaj, iwan porke ankineltokaj nik in Nej oniwalaj de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Oniwalaj de inawak noPapan iwan onajsiko ixko yin tlaltikpak. Iwan axan nikajtewa yin tlaltikpak para nimokuepas oksemi inawak noPapan. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ijkuakón imomachtijkawan okilwijkej: ―Axan ya titlapojtok ika tlajtole katlej okachi mach owij para tikmomakaj kuenta iwan mach ok titechtlapoawia ika ejemplos. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Axan tikmomakaj kuenta nik nochi tlamantle tikmati, iwan mach ok moneki akaj ma mitztlajtlani tlan kijtosneki motlamachtil. Por yonik tikneltokaj nik melawak otiwalaj de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús okinnankilij: ―¿Axan kemaj ankineltokaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya ajsi ora, iwan mach ok wejkawas, nijkuak namejwan anxixiniskej iwan kada se kitzkis iojwi, iwan annechkawaskej noselti. Pero mach nikaj noselti, porke noPapan kajki nowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nochi yin namechilwia para xikpiakan yolosewilistle nonawak. Namejwan antlajyowiskej ixko yin tlaltikpak, pero ximoyolojchikawakan, porke Nej yonitlatlanke itech nochi tlan onkaj ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Satepan de okijtoj yon tlajtole, Jesús oajkopantlachixke ik ilwikak, iwan okijtoj: ―Papan, yoajsiko ora. Xinechweyikixti Nej nimoKone, para ijkón Nej noijki nimitzweyikixtis tejwatzin. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Porke tejwatzin otinechtlalij ma nitlanawati itech nochtin in tlaltikpaktlakaj, para ma nikinmaka nemilistle katlej mach keman tlamis nochtin katlej yotinechinmakak. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iwan nochtin katlej kipiaj yon nemilistle katlej mach keman tlamis, yomitzixmatkej iwan kimatij nik melawak tejwatzin tiDios, iwan mach onkaj oksé. Iwan noijki yonechixmatkej Nej niJesucristo katlej tejwatzin otinechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nej yonimitzweyikixtij ixko yin tlaltikpak. Iwan yoniktlamij notekiw katlej otinechnawatij ma nikchiwa. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Axan kiné, Papan, xinechweyikixti monawak ika weyikixtilistle katlej mowan onikpiaya desde ijkuak in tlaltikpak ayamo oyeka. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’In tlakaj katlej otikinpejpenke de itech yinmej tlaltikpaktlakaj para otinechinmakak, yonikinmatiltij akin tejwatzin. Oyekaj moaxkawan, iwan tejwatzin otinechinmakak, iwan yejwan okineltokakej motlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Axan ya kimatij nik nochi tlamantle katlej otinechmakak witz de tejwatzin. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Porke nochi tlan tejwatzin otinechilwij, Nej yonikinmilwij, iwan yejwan okineltokakej. Yokimomakakej kuenta nik melawak oniwalaj de tejwatzin, iwan kineltokaj nik tejwatzin otinechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nej nimitztlatlawtia por yejwan. Mach nimitztlatlawtia por yen tlaltikpaktlakaj katlej mach nechneltokaj, sino nimitztlatlawtia por yejwan katlej otinechinmakak, porke moaxkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nochi tlan noaxka noijki moaxka, iwan tlan moaxka noijki noaxka. Iwan yejwan nechweyikixtiaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nej mach ok nietos ixko yin tlaltikpak, porke ya niawi monawak, pero yejwan ok mokawaskej ixko yin tlaltikpak. Papan, tejwatzin tichipawak, tejwatzin xikinmonekuitlawi ika mopoder de yen motokatzin, para ma setitokan san se, ijkón ken tejwan tisetitokej san se. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nijkuak Nej inwan onieka ixko yin tlaltikpak, Nej onikinmonekuitlawiaya ika mopoder katlej tejwatzin otinechinmakak. Nej onikinmonekuitlawij para amo ma mopolokan, iwan nion se de yejwan mach omopoloj, sino omopoloj san yen katlej yoyeka para mopolos, para ma mochiwa tlan kijta in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Axan Nej niawi monawak. Iwan nikijta yin tlajtole mientras ok nikaj ixko yin tlaltikpak, para ma kipiakan miek pakilistle ipan inyolo ijkón ken Nej nikpia. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nej yonikinmakak motlajtol nomomachtijkawan, iwan in tlaltikpaktlakaj katlej mach mitzixmatij kinkokoliaj, porke nomomachtijkawan mach ok powij inwan tlaltikpaktlakaj ijkón ken Nej noijki mach nipowi inwan tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mach nimitztlatlawtia xikinkixti de ixko yin tlaltikpak, sino xikinpalewi para amo ma kinkajkayawa in Amo Kuale Tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ijkón ken Nej mach nipowi inwan tlaltikpaktlakaj, yejwan noijki mach powij inwan tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xikintlali ma yekan itech tlan melawak para ma mitztekipanokan san yen tejwatzin. Motlajtol yen yon melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ijkón ken tejwatzin otinechwaltitlanke nian kan katej in tlaltikpaktlakaj, Nej noijki nikintitlani kan katej in tlaltikpaktlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Nej nimotemaktia (nimotemaktilia) por yejwan para nikchiwas tlan tejwatzin tikneki, para ijkón yejwan noijki ma motemaktikan ma kichiwakan tlan tejwatzin tikneki por yen motlajtol katlej melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Amo nimitztlatlawtia san para nomomachtijkawan, sino noijki para nekatej katlej tlaneltokaskej nonawak nijkuak kinkakiliskej intlajtol de nomomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nimitztlatlawtia nochtin yejwan ma setitokan san se. Ijkón ken tejwatzin, Papan, iwan Nej tisetitokej san se. Nimitztlatlawtia yejwan ma setitokan towan san se. Iwan ijkón in tlaltikpaktlakaj ma kineltokakan nik tejwatzin otinechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yejwan yonikinmakak weyikixtilistle katlej tejwatzin otinechmakak, para ma setitokan san se, ijkón ken tejwatzin iwan Nej tisetitokej san se. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nej nietos intech iwan tejwatzin tietos notech para ijkón melawak ma setitokan san se. Iwan ijkón in tlaltikpaktlakaj ma kimomakakan kuenta nik tejwatzin otinechwaltitlanke, iwan nik melawak tikintlasojtla ijkón ken tejwatzin tinechtlasojtla. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’Papan, nikneki ke katlej tejwatzin otinechinmakak noijki ma yekan nowan kan Nej nietos, para ma kitakan nomawisotlanex katlej otinechmakak porke otinechtlasojtlak desde ijkuak in tlaltikpak ayamo omochiwaya. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Papan, tejwatzin tikuale tlakatl, in tlaltikpaktlakaj mach mitzixmatij. Pero Nej nimitzixmati, iwan yinmej katlej otinechinmakak yokimatkej nik tejwatzin otinechwaltitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nej yonikinmatiltij akin tejwatzin iwan ok nikinmatiltijtos. Nej nikneki yejwan ma motlasojtlakan ijkón ken tejwatzin tinechtlasojtla porke Nej nietos ipan inyolo. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nijkuak Jesús otlanke okijtoj yon tlajtole, oyáj iwan imomachtijkawan ik ne lado de yen barrankajtzin katlej itoka Cedrón. Ompa oyeka se lugar tlatokkuawyoj, iwan ompa okalakke in Jesús iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iwan Judas, katlej ijkuakón ya yawi kitemaktiti (kitemaktilitij) in Jesús, okixmatia yon lugar. Porke miekpa ompa omololoayaj in Jesús iwan imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ijkuakón Judas ompa oajsito kinwika miekej soldadojtin iwan miekej mayoltin de yen tlayekankej tiopixkej iwan de yen fariseos. Oajsitoj ompa ika kandil iwan ika okotl motlawilijtiwej, iwan nochi intejtepos. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero komo in Jesús yokimatia nochi tlan panos, okiske okinnamikito iwan okintlajtlanij: ―¿Akin nankitemoaj? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Iwan yejwan okinankilijkej: ―Tiktemoaj in Jesús de Nazaret. Iwan Jesús okijtoj: ―Yen Nej. Noijki ompa inwan owalaya in Judas katlej ijkuakón yokitemaktijtoka (yokitemaktilijtoka) in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nijkuak in Jesús okinmilwij: “Yen Nej”, oajketiajkej otepewitoj ipan tlale. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús oksemi okintlajtlanij: ―¿Akin nankitemoaj? Iwan yejwan oksemi okinankilijkej: ―Tiktemoaj in Jesús de Nazaret. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús oksemi okinmilwij: ―Yonamechilwij nik yen Nej. Tla yen Nej nannechtemoaj, tonses xikinkawilikan ma wian in yinmej katlej nowan katej. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ijkón okijtoj para ma mochiwa tlan achtoj okijtoj: “Katlej otinechinmakak, nion se de yejwan mach onikpoloj.” ");
INSERT INTO nhyNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ijkuakón Simón Pedro okipixtoka iespada, okikixtij iwan okinakastzontekke itech iyeknakas itekipanoj in weyi tiopixke. Katlej okinakastzontekej itoka Malco. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesús okilwij in Pedro: ―Xikkalaki de kan otikkixtij moespada. In tekokojkayotl katlej noPapan yokitlalij ma nipano, moneki ijkón nipanos maski ma yeto sa tekitl tekokoj. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","In soldadojtin iwan koronel, iwan inmayolwan in judiojtin, okikitzkijkej in Jesús iwan okijilpijkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Iwan okiwikakej achtoj ichan Anás, porke Anás oyeka temontaj de yen Caifás, iwan Caifás oyeka weyi tiopixke itech yon xiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yon Caifás yen katlej okachi achtoj okimilwijka in judiojtin ke okachi kuale ma miki se tlakatl por nochtin in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro iwan oksé imomachtijkaikni san de wejka okonitiayaj in Jesús. Oksé imomachtijkaikni kuale omixmatia iwan weyi tiopixke Anás, por yonik okalakke iwan Jesús kan patio. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero in Pedro omokaj kalan itech puerta. Por yonik in oksé imomachtijkaikni katlej iwan omixmatia in weyi tiopixke, okiske iwan omotlapowij iwan se tlapalewijkasiwatl de yen weyi tiopixke, para ma kikawili ma kalaki in Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","In tlapalewijkasiwatl okitlajtlanij in Pedro: ―¿Amo tej noijki tiimomachtijkaw de nekáj tlakatl? Pedro okinankilij: ―Nej amo. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Komo wel chikawak osewatoka, in tlapalewijkej iwan mayoltin okitlalijkej se tlitl iwan omototonijtokaj mokejketokej. Pedro noijki ompa inwan omoketoka omototonijtoka. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","In weyi tiopixke Anás opéj kitlatzintokia in Jesús de yen imomachtijkawan iwan de yen itlamachtil. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús okinankilij: ―Nej nochipa onitetlapowiaya inmixpan nochtin in tlakaj. Nochipa onitlamachtiaya itech amotiopanwan iwan itech in weyi tiopan kan mololoaj nochtin in judiojtin. Mach itlaj onikijtoj san ichtaka. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tlanik yen Nej tinechtlatzintokia? Xikintlatzintoki yejwan katlej onechkakej onikintlapowij. Yejwan kimatij tlan onikijtoj. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nijkuak Jesús ijkón okijtoj, ijkuakón se de yen mayoltin katlej ompa oyeka, okikamatlatzinij in Jesús, iwan okilwij: ―¿Ijkón nik tiknankilia in weyi tiopixke? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús okinankilij: ―Tla onikijtoj itlaj mach kuale, xinechilwi. Iwan tla kuale tlan Nej nikijta, ¿tlanik tinechmaga? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Satepan Anás okititlanke in Jesús inawak in weyi tiopixke Caifás. Jesús ok oijilpitoka nijkuak okititlankej inawak yon Caifás. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pedro ok omoketoka mototonijtok, iwan okitlajtlanijkej: ―¿Amo tej noijki tiimomachtijkaw de nekáj tlakatl? Pedro mach okimokuitij, iwan okijtoj: ―Amo, nej mach niimomachtijkaw. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ijkuakón se de yen itekipanoj in weyi tiopixke, ipariente in tlakatl katlej Pedro okinakastzontekke, okitlajtlanij: ―¿Amo yen tej onimitzitak iwan Jesús kan tlatokkuawyoj? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro oksemi mach okimokuitij, iwan san niman ijkuakón otzajtzik in kaxtil. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jesús okikixtijkej de ichan Caifás iwan okiwikakej kan palacio kan ochantia in gobernador itoka Pilato. Iwan komo yotlanestiwalaya, in judiojtin mach okinekej okalakej kan palacio para amo moyolsokiotiskej porke okinekiaj yeskej yolchipawakej para welis kikuaskej in tlakuale de pascua. Porke in judiojtin tla kalakiskej ichan se katlej mach judío, yejwan kijtaj ke moyolsokiotiaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Por yonik, in Pilato okiske kalan kan yejwan oyekaj, iwan okinmilwij: ―¿Tlan ika nankitilwiaj yin tlakatl? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yejwan otlanankilijkej: ―Tla yin tlakatl amo kichiwani itlaj tlan amo kuale, mach timitzmaktilianij. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato okinmilwij: ―Xikmowikilikan, iwan xikixkomakakan (xiktzonmanakan) namejwan ijkón ken kijta namotlanawatil. Pero in judiojtin okilwijkej: ―Pero itlanawatil in César mach techkawilia in tejwan akaj ma tikmiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iwan ijkón omochij de tlan achtoj okijtoj in Jesús de kenik mikis. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ijkuakón Pilato oksemi okalakke itech ipalacio, okinotzke in Jesús iwan okilwij: ―¿Yen tej tiRey de judiojtin? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús okilwij: ―¿Kisa de tej tinechtlajtlania kox niRey, o noso porke akaj oksé omitzilwij nik Nej niRey? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato okinankilij: ―Nej mach nijudío. Mojudiojikniwan iwan tlayekankej tiopixkej yejwan omitztemaktikoj (omitztemaktilikoj) nonawak. ¿Tlan otikchij? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús otlanankilij: ―Nej mach nitlanawatia nian ixko yin tlaltikpak. Tla ijkón yeni, notekipanojkawan nechpalewianij para amo ma nechtemaktikan inmak in judiojtin. Pero Nej mach nitlanawatia nian ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ijkuakón Pilato okitlajtlanij: ―¿Tonses kijtosneki in Tej tiRey? Jesús okinankilij: ―Yen Nej niRey ijkón ken tej yotikijtoj. Nej onitlakatke para nietos niRey iwan oniwalaj ixko yin tlaltikpak para niktematiltis tlan melawak. Nochtin katlej kineltokaj tlan melawak, nechkakij. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato okilwij: ―¿Iwan tlanon yon melawak? Nijkuak in Pilato ijkón okitlajtlanij, san niman okiske oksemi omotlapowito inwan judiojtin, iwan okinmilwij: ―Mach itlaj tlajtlakole nikkajxilia. ");
INSERT INTO nhyNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero namejwan ankipiaj kostumbre de ma namechkajkawili se preso itech ilwitl de pascua. ¿Ankinekij ma nikkajkawa in Rey de judiojtin? ");
INSERT INTO nhyNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ijkuakón nochtin otzajtzikej oksemi, okijtojkej: ―¡Amo, amo xikajkawa yon tlakatl! ¡Xikkajkawa yen Barrabás! Iwan yon Barrabás oyeka ichtekke. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ijkuakón Pilato okikixtij in Jesús iwan otlanawatij ma kiwitekikan ika chikote katlej kipia tepostle iyak. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","In soldadojtin okichijkej se korona de witztle iwan okikuaonakiltijkej itech itzontekon, iwan okonakiltijkej se kapa chichiltikatlilmiktik. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iwan omijkuanijkej inawak iwan okijtoayaj: ―¡Viva in Rey de judiojtin! Iwan okixtlajtlatziniayaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato okiske oksemi, iwan okimilwij in judiojtin: ―Xikitakan, nian namechwalwikilia, para xikmomakakan kuenta nik mach itlaj tlajtlakole nikkajxilia. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús okiske kan patio kikuaonakijtiwitz se korona de witztle iwan konakijtiwitz se kapa chichiltikatlilmiktik. Iwan Pilato okinmilwij: ―Xikitakan, nian kajki in tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nijkuak okitakej in tlayekankej tiopixkej iwan mayoltin, otzajtzikej chikawak: ―¡Xikmajmasolti itech krus! ¡Ma miki! Pilato okinmilwij: ―Amejwan xikwikakan iwan xikmajmasoltikan itech krus, porke nej mach itlaj tlajtlakole nikkajxilia. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","In judiojtin okinankilijkej: ―Tejwan tikpiaj se tlanawatile, iwan totlanawatil kijta ma miki in yon tlakatl, porke motenewa nik yen iKone in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nijkuak in Pilato ijkón okikakke, okachi omomawtij. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Oksemi okalakke itech ipalacio iwan okitlajtlanij in Jesús: ―¿Tej de kan otiwalaj? Pero in Jesús mach okinankilij. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Tonses in Pilato okilwij: ―¿Amo tinechnankilis? ¿Amo tikmati nik nej welis nitlanawatis para ma mitzmajmasoltikan itech krus, o noso welis nitlanawatis ma mitzkajkawakan? ");
INSERT INTO nhyNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús okinankilij: ―Mach itlaj welini tinechtoktiani ika motlanawatil, tla Dios amo kimonekiltiani. Por yonik, akin momak onechtemaktij (onechtemaktilij) okachi kipia weyi tlajtlakole ke tej. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Desde ijkuakón in Pilato opéj kitemoa ken kichiwas para kikajkawas in Jesús. Pero in judiojtin otzajtziaj chikawak okijtoayaj: ―¡Tla tikkajkawas in yon tlakatl, mach tiiamigo de yen toweyi tlanawatij César! ¡Akin kineki motenewas kej rey, kijtosneki kikokolia in César! ");
INSERT INTO nhyNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nijkuak ijkón okikakke in Pilato, otlanawatij ma kiwalkixtikan in Jesús, iwan Pilato omotlalij kan tlaixkomakaj (tlatzonmanaj), kan ika tlajtole hebreo kitokayotiaj Gabata, kijtosneki Piso de Tetl. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Yon tonale yotlayektlalijtokaj para yen walmostlatis ya ilwitl de pascua, iwan ijkuakón oyeka kej tlajko tonale. Ijkuakón Pilato okinmilwij in judiojtin: ―¡Nian kajki namoRey! ");
INSERT INTO nhyNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero yejwan otzajtzikej: ―¡Ma miki! ¡Ma miki! ¡Xikmajmasoltikan itech krus! ¡Ma miki! Pilato okinmilwij: ―¿Ankinekij ma nikmajmasolti itech krus namoRey? In tlayekankej tiopixkej okinankilijkej: ―¡Tejwan mach tikpiaj oksé rey, sino san yen César! ");
INSERT INTO nhyNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ijkuakón Pilato okinmaktilij in Jesús para ma kimajmasoltikan itech krus, iwan yejwan okiwikakej. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús okiske kikechpanojtiw ikrus asta kan kitokayotiaj Mikkatzontekomatl, katlej ika tlajtole hebreo itoka Gólgota. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ompa okimajmasoltijkej itech krus, iwan noijki ompa okinmajmasoltijkej ok omen tlakaj ik inajnakastlan. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato okijkuiloj se letrero, iwan okitlalij ik ikuapak ikrus in Jesús. Ijkín okijtoaya in letrero: “Jesús de Nazaret, Rey de yen judiojtin.” ");
INSERT INTO nhyNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Miekej judiojtin okilerojkej yon letrero, porke kan okimajmasoltijkej in Jesús itech krus oyeka serka de yen weyikan de Jerusalén, iwan letrero oijkuilitoka ika tlajtole hebreo, ika tlajtole griego iwan ika tlajtole latín. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Por yonik in tlayekankej tiopixkej judiojtin okilwijkej in Pilato: ―Amo xikijkuilo, “Rey de yen judiojtin”; sino xikijkuilo “In tlakatl katlej motenewa Rey de yen judiojtin.” ");
INSERT INTO nhyNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero in Pilato okinnankilij: ―Tlan yonikijkuiloj, ijkón ma mokawa. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nijkuak in soldadojtin okimajmasoltijkej in Jesús itech krus, okontilankej itzotzol in Jesús iwan okitoktijkej nawi pedaso iwan okimoxejxelilijkej entre nawin soldadojtin. Noijki okontilankej itlaken katlej mach oyeka tlajtzomale iwan omotlantoka san se tzotzole desde tlikpak asta tlakxitlan. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","In soldadojtin okimolwijkej entre yejwan: ―Mach ma tiktzayanakan, okachi kuale ma timotlanikan, aber akin kitlanis. Ijkón otlamochij ken kijta in tiotlajkuilole: “Okimoxejxelilijkej notzotzol, iwan omotlaankej ika notlaken.” Ijkón okichijkej in soldadojtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ikxitlan ikrus in Jesús oyekaj imaman, iknitzin imaman, isiwa in Cleofas iwan María de pueblo de Magdala. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Nijkuak in Jesús okitak ompa moketok imaman, iwan imomachtijkaw katlej sa tekitl okitlasojtlaya, ijkuakón okilwij imaman: ―Nanan, noan kajki mokone. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Satepan okilwij imomachtijkaw: ―Noan kajki momaman. Desde ijkuakón imomachtijkaw okimonekuitlawij kej yeskia imaman. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Satepan de yon, komo in Jesús yokimatia nik nochi itekiw yotlanke, okijtoj para ma mochiwa tlan kijta in tiotlajkuilole: ―¡Namiki! ");
INSERT INTO nhyNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ompa oyeka se xoktzin otentoka de iayo uvas xokok. Okisiajkej se esponja ika yon iayo uvas katlej xokok, okiyakailpijkej itech se kuawitl de hisopo, iwan okiyaktilijkej itech iten. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nijkuak in Jesús okonik yon iayo uvas xokok, okijtoj: ―Nochi notekiw yoniktlamij. Ijkuakón omotzonpiloj, okitemaktij (okitemaktilij) ianima iwan omikke. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Se tonale antes de yen ilwitl de pascua, in judiojtin okijtojkej mach ma mokawakan in mikkamej itech inkrus nijkuak weyi tonale, porke oyeka weyi ilwitl itech yon tonale. Por yonik in tlayekankej judiojtin okilwijkej in Pilato ma tlanawati ma kinmetzpojpostekikan katlej okinmajmasoltijkej itech krus iwan ma kinkixtikan de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","In soldadojtin oyajkej iwan okinmetzpojpostekej in omen tlakaj katlej okinmajmasoltijkej itech krus ik inajnakastlan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Iwan nijkuak in soldadojtin omijkuanijkej kan oyeka in Jesús, okitakej yomikke. Por yonik mach okimetzpojpostekej. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero se soldado, okikestzopitij ika se kuawitl weyak yakateposoj, iwan san niman ijkuakón okiske estle iwan atl. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nej nochi kuale onikitak, iwan namechilwia tlan melawak, para namejwan noijki xikneltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Yon tlamantle omochij para ma mochiwa tlan kijta in tiotlajkuilole: “Nion se iomio mach kipostekiliskej.” ");
INSERT INTO nhyNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Iwan oksekan de yen tiotlajkuilole noijki kijta: “Kitaskej katlej okikestzopitijkej.” ");
INSERT INTO nhyNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Satepan de yon, José de pueblo de Arimatea, katlej oyeka imomachtijkaw in Jesús san ichtaka porke okinmiimakasia in judiojtin, okitlatlawtij in Pilato ma kikawili ma kitki itlalnakayo in Jesús. Pilato okikawilij ma kitki. Tonses in José oyáj iwan okitkik itlalnakayo in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo noijki oyáj okiwikak in José, Nicodemo yen katlej achtoj oyajka okitato in Jesús de yuak. Yej okitkik kej senpoale iwan majtlaktle kilo de ajwiakayotl, nelitok de mirra iwan áloes. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","José iwan Nicodemo okitkikej itlalnakayo in Jesús iwan okikimilojkej ika bendajtin katlej okinsiajkej ika yon ajwiakayotl. Okichijkej ijkón ken inkostumbre in judiojtin kichiwaj nijkuak kitookaj se mikkatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kan okimajmasoltijkej in Jesús itech krus, ik ompa serka oyeka se lugar tlatokkuawyoj, iwan itech yon lugar oyeka se mikkakuyoktle kan mach ya akaj okitookayaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ompa okikalakijkej itlalnakayo in Jesús para okitookakej, porke yon mikkakuyoktle oyeka serka iwan porke ya pewani in weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","In yakinika tonale de yen samana, in María de pueblo de Magdala oyáj kan okitookakej in Jesús san kualkan, ok otlatleyuatoka. Iwan okitajsik in mikkakuyoktle mach ok okamatzaktoka ika tetl. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ijkuakón omotlaloj oyáj kan oyeka in Simón Pedro iwan oksé momachtij, katlej Jesús okitlasojtlaya, iwan okinmilwij: ―¡Yokiwikakej itlalnakayo in toSeñor de itech mikkakuyoktle, iwan mach tikmatij kan okitlalijkej! ");
INSERT INTO nhyNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro iwan oksé momachtij okiskej iwan oyajkej kan oyeka in mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","San ken omen omotlalojkej san sekan, pero in oksé momachtij omotlaloj okachi ke Pedro iwan oajsito achtoj kan oyeka in mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Oontlachixke ik tlijtik, iwan okinmitak in bendajtin ompa oyekaj, pero mach omixewij okalakke. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Satepan oajsiko in Simón Pedro, katlej owalaya tlakuitlapan, iwan okalakke ijtik in mikkakuyoktle. Yej noijki okinmitak in bendajtin. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Iwan noijki okitak in panito katlej oyeka ipan itzontekon in Jesús, iwan mach oyeka iwan bendajtin, sino oyeka ik se lado otejkuixtoka. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ijkuakón okalakke noijki in oksé momachtij katlej achtoj oajsito itech mikkakuyoktle. Okitak tlan otlamochij, iwan okineltokak nik mach ompa oyeka in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Porke ayamo kuale okimomakayaj kuenta tlan kijta in tiotlajkuilole nik kipia de moyolkuis (moyolitis) oksemi. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Satepan in yonmej omen momachtijkej omokuepkej para inchan. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","María omokaj chokatok kalan inakastlan mikkakuyoktle. Nijkuak ochokatoka omotooloj iwan oontlachixke ijtik in mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iwan okinmitak omen angelestin otzotzoltitokaj ika intlaken istak. Oewatokaj kan oyeka itlalnakayo in Jesús, se ik ikxitlan iwan oksé ik itzontekonpan. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","In angelestin okitlajtlanijkej in María: ―Siwatl, ¿tlanik tichoka? Yej okinnankilij: ―Yokiwikakej noSeñor, iwan mach nikmati kan okikawatoj. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nijkuak ijkón okijtoj, omokuepke iwan okitak in Jesús ompa moketok, pero mach okixmaj kox yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús okitlajtlanij: ―Siwatl, ¿tlanik tichoka? ¿Akin tiktemoa? María okimolwij xamo yen tlamonekuitlawij de yon tlatokkuawyoj, iwan okilwij: ―Tataj, tla tejwatzin otikwikak, xinechilwi kan otikkawato, iwan nej niknotzatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús okilwij: ―¡María! Yej omokuepke iwan okilwij ika tlajtole hebreo: ―¡Raboni! ―kijtosneki Tlamachtij. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús okilwij: ―Xinechkajkawa, porke mach ya nimotlejkawia (nitlejko) inawak noPapan. Pero xiwia xikinmilwiti nokniwan, ke nimotlejkawis inawak noPapan, katlej namejwan noijki amoPapan, katlej noDios iwan katlej namejwan noijki amoDios. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ijkuakón in María de pueblo de Magdala oyáj okinmilwito in momachtijkej nik okitak in Señor, iwan noijki okinmilwij tlan okinawatij. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nijkuak otlatleyuak itech yon yakinika tonale de yen samana, in momachtijkej omololojkej iwan omokaltzajtzakej porke okinmiimakasiaj in judiojtin. Ijkuakón Jesús owalmonextij ik tlatlajko de kan yejwan oyekaj iwan okintlajpaloj, okinmilwij: ―Ximoyolosewikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Satepan de ijkón okijtoj, okinmititij imawan iwan ikestlan. Yejwan opakej porke oksemi okitakej in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ijkuakón Jesús okinmilwij oksemi: ―Ximoyolosewikan. Ijkón ken noPapan onechwaltitlanke, ijkón Nej noijki namechtitlani. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iwan okinmijpitzke imomachtijkawan, iwan okinmilwij: ―Xikresibirokan in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Akin namejwan ankitlapojpolwiskej de itlajtlakol, mokawas chipawak. Iwan akin amo ankitlapojpolwiskej de itlajtlakol, mokawas tlajtlakolej. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero in Tomás, se de yen majtlaktle iwan omen momachtijkej, katlej okitokayotiayaj Kuatej, mach ompa okatka inwan nijkuak in Jesús okinmotitij. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Satepan in oksekimej imomachtijkaikniwan okilwijkej: ―Yotikitakej in toSeñor. Pero in Tomás okinnankilij: ―Tla amo nikinmitas imawan iwan tla amo nikkalakis nomajpil kan okimakujkuyunijkej ika klabostin, iwan noijki tla amo nikkalakis noma itech ikestlan, mach nikneltokas. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Chikueyi tonale satepan, in momachtijkej oksemi omololojkej itech se kale, iwan ijkuakón in Tomás ompa oyeka inwan. Nochtin in puertajtin otzajtzaktokaj, pero Jesús oksemi owalmonextij ik tlatlajko. Iwan okintlajpaloj okinmilwij: ―Ximoyolosewikan. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ijkuakón okilwij in Tomás: ―Xikinmita nomawan iwan xikkalaki momajpil itech nomakpal. Noijki xikkalaki moma ik nokestlan. Amo xieto mach titlaneltokak, sino xieto titlaneltokak. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ijkuakón Tomás okilwij: ―¡Tejwatzin tinoDios iwan tinoSeñor! ");
INSERT INTO nhyNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús okilwij in Tomás: ―Axan tikneltoka porke otinechitak. Ma pakikan katlej amo nechitaj iwan nechneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús okinchij miekej oksekimej milagrostin inmixpan imomachtijkawan, katlej mach ijkuilitokej itech yin libro. ");
INSERT INTO nhyNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero nochi yin tlan ijkuilitok itech yin libro, omijkuiloj para namejwan xikneltokakan nik in Jesús yen Cristo, iKone in toTajtzin Dios. Iwan tla namejwan antlaneltokaskej inawak ankipiaskej nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Satepan de yon, Jesús okinmotitij imomachtijkawan inakastlan mar itoka Tiberias. Iwan ijkín otlamochij: ");
INSERT INTO nhyNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Imomachtijkawan Jesús oyekaj san sekan, oyeka in Simón Pedro, Tomás katlej kitokayotiaj Kuatej, Natanael katlej oyeka de Caná de Galilea, noijki ipilwan Zebedeo, iwan ok omen imomachtijkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro okinmilwij: ―Niawi nimichmati. Yejwan okinankilijkej: ―Ma timitzwikakan. Ijkuakón kiné, otlejkokej itech se barko. Pero yon yuak mach itlaj michin okajsikej. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nijkuak yotlanestiwalaya, Jesús owalmonextij ik atlatentle, pero imomachtijkawan mach okimatiaj kox yen Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús okintlajtlanij: ―Telpokamej, ¿ankinmajsikej michimej? Yejwan okinankilijkej: ―¡Amo! ");
INSERT INTO nhyNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesús okinmilwij: ―Xiktlamotlakan in michmatlatl ik iyekma in barko, iwan ankinmajsiskej michimej. Ijkón okichijkej kiné, iwan satepan, mach ok oweliaj okikixtiayaj in michmatlatl porke okinkitzkijkej sa tekitl miekej michimej. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ijkuakón in momachtij katlej Jesús okitlasojtlaya, okilwij in Pedro: ―¡Yen toSeñor! San niman nijkuak ijkón okikakke in Simón Pedro nik yen Señor, omotzotzoltijtiwetzke, porke oyeka xitlatztik, iwan omotlamotlak ijtik atl. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Oksekimej momachtijkej oajsitoj atlatentle itech barko, okitilantiayaj in michmatlatl tentok de michimej. Oyekaj san kanaj se sien metros de kan atlatentle. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nijkuak otemokej ipan tlale, okitakej se michin iwan se pan ipan tlixochtle. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús okinmilwij: ―Xikkualinkuikan sekimej michimej katlej yakin ankinkitzkijkej. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro otlejkok itech barko iwan okitilanke in michmatlatl asta atlatentle tentok de wejweyin michimej. Okinpoj, iwan oyekaj se siento iwan omenpoale iwan majtlaktle iwan eyi michimej. Maski okinkitzkijkej miekej michimej, mach otzayanke in michmatlatl. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesús okinmilwij: ―Xiwikikan xitlakuakij. Iwan nion se imomachtijkaw mach omixewij okitlajtlanij akin Yej, porke kuale okimatiaj nik yen toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Satepan Jesús omijkuanij, okitilanke in pan iwan okinmajmakak. Iwan noijki ijkón okichij ika michin. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ika yon omochij ya eyi buelta okinmotitij in Jesús imomachtijkawan, satepan de omoyolkuik oksemi de ijkuak omikka. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Satepan de otlanke otlakuajkej, in Jesús okitlajtlanij in Simón Pedro: ―Simón, ikone in Jonás, ¿tinechtlasojtla okachi ke momomachtijkaikniwan? Pedro okinankilij: ―Aján, Señor, tejwatzin kuale tikmati nik sa tekitl nimitzneki. Jesús okilwij: ―Xikintlakualti nochkakonewan. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesús okitlajtlanij oksemi: ―Simón, ikone in Jonás, ¿tinechtlasojtla? Pedro okinankilij: ―Aján, Señor, tejwatzin kuale tikmati nik nimitzneki. Jesús okilwij: ―Xikinpia nochkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ipan eyi buelta oksemi okitlajtlanij: ―Simón, ikone in Jonás, ¿melawak tinechneki? Nijkuak in Jesús okitlajtlanij ya eyi buelta kox melawak kineki, ijkuakón Pedro omoyolkokoj por ijkón okitlajtlanij. Iwan okinankilij: ―Señor, tejwatzin nochi tikmati. Tejwatzin kuale tikmati nik melawak nimitzneki. Jesús okilwij: ―Xikintlamaka nochkawan. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ipan melajka nimitzilwia, nijkuak otieka titelpochtle, otimotzotzoltiaya iwan otiaya san kan tej otiknekia. Pero nijkuak titetajtis, timajmasos iwan oksé mitztzotzoltis, iwan mitzwikas kan amo tiknekis tias. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús ijkón okijtoj para okinmatiltij kenik mikis in Pedro satepan, iwan kenik kiweyikixtis in Dios ika imikilis. Satepan okilwij: ―Xiwiki nowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nijkuak in Pedro omokuepke, okitak in oksé imomachtijkaw katlej Jesús okitlasojtlaya, oyaya inkuitlapan, katlej oyeka itech in tiotlakantlakuale iwan omijkuanijka ik ielpan in Jesús, iwan okitlajtlanijka: “Señor, ¿akin mitztemaktis (mitztemaktilis)?” ");
INSERT INTO nhyNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nijkuak in Pedro okitak, okitlajtlanij in Jesús: ―Señor, ¿iwan yin tlakatl tlan mochiwas? ");
INSERT INTO nhyNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús okilwij: ―Tla Nej niknekis ma mokawa asta ijkuak niwalmokuepas, tej mach motekiw. Tej xiwiki nowan. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ijkuakón yon tlajtole oxoyawik (oxitinki) intech in momachtijkej tlaneltokakej, okimatkej nik nekáj momachtij mach mikis. Pero Jesús mach okijtoj nik mach mikis. Sino Yej okijtoj: “Tla Nej niknekis ma mokawa asta ijkuak niwalmokuepas, tej mach motekiw.” ");
INSERT INTO nhyNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nekáj momachtij yen nej. Nej onikitak tlan otlapanok, iwan onikijkuiloj itech yin libro. Iwan namejwan ankimatij nik nochi tlan nikijta yon melawak. ");
INSERT INTO nhyNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesús okinchij oksekimej tlamantin okachi. Iwan tla nochi moijkuiloani se por se de tlan Jesús okichij, mach akinij ixko yin tlaltikpak in librojtin katlej mijkuiloanij. Ijkón ma yeto.");
INSERT INTO nhyNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nokni Teófilo: Itech yakinika nolibro onikijkuiloj nochi tlan Jesús okichij iwan nochi tlan otlamachtij desde ijkuak okipewaltij itekiw, ");
INSERT INTO nhyNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","iwan asta ijkuak oyáj ilwikak. Antes de yas ilwikak, ika iEspíritu Santo okinnawatijtewak in tlatitlaniltin katlej Jesús okinpejpenke para ma kichiwakan tlan okinmilwij. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Satepan de omikke, Jesús okinmotitij itlatitlanilwan de miek tlamantle para ma kimomakakan kuenta nik in Yej yolitok. Okinmotitij omenpoale tonaltin. Itech yonmej omenpoale tonaltin okintlapowij de kenik in Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nijkuak in Jesús ok oyeka inwan itlatitlanilwan, okinnawatij mach ma wian de Jerusalén. Okinmilwij: ―Xikchiakan asta ma mochiwa tlan noPapan oamechilwij, ijkón ken Nej noijki yonamechilwij. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ipan melajka, Juan otlakuateekij ika atl, pero sa kanaj keski tonale namejwan anmokuateekiskej ika Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Katlej omololojkej iwan Jesús, okitlajtlanijkej: ―Señor, ¿tikmakixtis itech yinmej tonaltin in topaís de Israel para sa yej iselti ma monawati? ");
INSERT INTO nhyNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesús okinnankilij: ―Namejwan mach amechtokaroa ankimatiskej itech tlan tonale o noso keman itlaj kichiwas in noPapan. Sanwel Yej kimati iwan Yej kijta tlan kichiwas. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Iwan nijkuak in Espíritu Santo witz ipan namoyolo, namejwan ankiresibiroskej ipoder iwan ankisaskej antetlapowitiwej de Nej ik Jerusalén, ik nochi in región de Judea iwan de Samaria, iwan asta kan katej okachi wejka de ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Satepan de otlanke okintlapowij, Jesús omotlejkawijtiaj (otlejkotiaj) ik ilwikak, mientras imomachtijkawan okonitokaj, opoliwito ijtik mixtle iwan mach ok okitakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iwan nijkuak okonitokaj kenik omotlejkawijtiaj ik ilwikak, omen tlakaj otlakentitokaj de istak omonextijkej ik innakastlan, ");
INSERT INTO nhyNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","iwan okintlajtlanijkej: ―Tlakaj de Galilea, ¿tlanik ankonitokej in ilwikak? Yin Jesús katlej oyeka amowan iwan katlej ya ankitakej yoyáj ik ilwikak, witz oksemi ijkón ken ankitakej oyáj. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Owalmokuepkej in tlatitlaniltin para Jerusalén owalajkej desde kan Olivostepetl, kej se kilómetro nik wejka. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nijkuak oajsitoj Jerusalén, okalakej kalijtik iwan otlejkokej ajkopan itech oksé piso kan yejwan okalotitokaj. Ompa oyeka in Pedro, Juan, Jacobo, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo itelpoch in Alfeo, Simón katlej onemia inwan cananistas, iwan Judas itelpoch in Jacobo. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Noijki ompa oyekaj sekimej siwamej. Ompa oyeka in María imaman in Jesús iwan ikniwan in Jesús. Nochtin yejwan omololoayaj nochipa para motiotzajtziliskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Itech yonmej tonaltin in tokniwan tlaneltokakej omololojkej kej se siento iwan senpoale, Pedro omoketzke tlatlajko iwan okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nokniwan, xinechkakikan. Ya wejkawitl in rey David okijkuiloj tlan okilwij in Espíritu Santo, de tlan Judas panoani, katlej okinyekanke katlej okitzkijkej in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas opowia towan iwan noijki towan otekipanoaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pero omotlalkowij ika yen tomin katlej okimakakej de itlajtlakol. Satepan ompa ipan itlal owetzke ika itzontekon iwan oxijxitinke, iwan okuetlaxkolkojkopinke. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Katlej ochantiaj Jerusalén nijkuak okimatkej, okitokayotijkej nekáj tlale Acéldama, kijtosneki ika intlajtol arameo Tlale de Estle. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Itech libro de Salmos kijtojtok: Ichan ma mokawa iselti kale, iwan mach akaj ompa ma chanti. Noijki itech oksé Salmo kijta: Katlej de yej itekiw oksé ma kipatkayoti. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nian katej sekimej tlakaj katlej onemiaj towan nochipa nijkuak in toSeñor Jesús Iwan otinemiaj, ");
INSERT INTO nhyNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","desde ijkuak in Juan okikuateekij in Jesús iwan asta ijkuak omotlejkawij (otlejkok) ik ilwikak. Moneki kiné, ke se de yejwan towan ma mosetili, para ijkón noijki ma kitematilti nik in Jesús omoyolkuik. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ijkón kiné, okinpejpenkej omen tlakaj: se itoka José Justo katlej noijki kinotzaj Barsabás, iwan oksé itoka Matías. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Satepan omotiotzajtzilijkej okijtojkej: ―Señor, tejwatzin tikinmixmati nochtin tlakaj ipan inyolo, xitechititi katlij yej de yinmej omen tlakaj katlej tejwatzin yotikpejpenke ");
INSERT INTO nhyNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para ma tekipano kej tlatitlanile ipatka in Judas, katlej okipoloj itekiw de tlatitlanile iwan oyáj kan kitokaroa yetos. ");
INSERT INTO nhyNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ijkuakón omotlaankej in yonmej omen, iwan otlatlanke in Matías, iwan desde ijkuakón omosetilij inwan oksekimej majtlaktin iwan se tlatitlaniltin para ijkón omochijkej ya majtlaktin iwan omen. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nijkuak oajsiko ilwitl de Pentecostés, nochtin oyekaj san sekan itech se kale. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Iwan ijkuakón owaltlakokuyokak, kej se ejekatl chikawak, omokakke owalaya de ilwikak. Iwan okiwiwixoj nochi in kale kan yejwan oyekaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iwan owalmonextijkej sekimej tlimej iwan omoxexelojkej ipan kada se de yejwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iwan nochtin otenkej de Espíritu Santo iwan opéj tlapoaj ika oksekimej tlajtoltin. Iwan okijtoayaj tlan Espíritu Santo okintoktiaya ma kijtokan. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Itech yonmej tonaltin oyekaj Jerusalén miekej judiojtin katlej sa tekitl omotemaktiayaj inawak Dios. Yonmej judiojtin owalajkej de nian nepa ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nijkuak okikakej owaltlakokuyokak, san niman omololojkej miekej iwan mach ok okimatiaj tlan kijtoskej, porke kada se de yejwan tlatitlaniltin opéj kintlapowiaj in tlakaj ika de yejwan intlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Melajka sa otlajtlachixkej (omomajmawtijkej), iwan okimolwiayaj: ―¿Amo owalajkej de Galilea nochtin yinmej katlej tlapojtokej? ");
INSERT INTO nhyNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Pero kada se de tejwan tikinkakij techtlapowiaj ika totlajtol, ¿kenik welij? Tejwan otiwalajkej de miekan paismej de ixko yin tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sekimej owalajkej de país de Partia, de Media, de Elam, de Mesopotamia, de Judea, de Capadocia, de Ponto iwan de Asia, ");
INSERT INTO nhyNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","noijki nian katej sekimej de Frigia, de Panfilia, de Egipto iwan de regionmej de Africa kanik kajki in pueblo de Cirene. Noijki nian katej sekimej de Roma katlej nian chantij. Sekimej de yejwan yipa judiojtin desde otlakatkej, iwan oksekimej okalakej itech intiotlamachtil in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Noijki owalajkej sekimej de Creta iwan de Arabia. Tinochtin tikinkakij in yinmej tlatitlaniltin tlapoaj kada se de yejwan ika totlajtol. Techinkakitiaj miekej tlamantin wejweyin de tlan Dios kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nochtin sa otlajtlachiayaj (omomajmawtiayaj) iwan mach ok okimatiaj tlan kijtoskej, iwan omotlajtlaniayaj: ―¿Tlan kijtosneki nochi yin tlan tlamochijtok? ");
INSERT INTO nhyNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero sekimej okinpinawiayaj, okijtoayaj: ―¡Yinmej iwintij! ");
INSERT INTO nhyNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ijkuakón Pedro omoketzke inwan oksekimej majtlaktin iwan se tlatitlaniltin, iwan chikawak okijtoj: ―Judiojtin iwan nochtin katlej nian chantij Jerusalén, xikkakikan iwan xikmatikan kuale nochi tlan namechilwis. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Yinmej mach iwintij ken namejwan ankijtaj, porke wel ok kualkan, yakin las nuebe. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nian tlamochijtok tlan ya wejkawitl okijtoj in profeta Joel: ");
INSERT INTO nhyNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Dios kijta: Ijkín tlapanos itech nekatej sa iyakatlanka tonaltin. Niktitlanis noEspíritu intech nochtin tlaltikpaktlakaj. Namopilwan kijtoskej tlan satepan tlapanos. In telpokamej kitaskej itlaj kej yeskia teemiktokej, iwan in tetajtzitzintin kikochteemikiskej tlan tlapanos. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Noijki nikinnokilis noEspíritu katlej notekipanojkawan, nikinnokilis in tlakaj iwan siwamej itech nekatej tonaltin, iwan kitenkixtiskej in tiotlajtole tlan Dios kinmakas. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","De itech ilwikak nikinnextilis wejweyin señalestin, iwan ipan yin tlaltikpak nikinnextilis señalestin ika estle, ika tlitl iwan ika mixpoktle. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","In tonale mach ok tlawis, iwan in metztle chichiliwias kej estle, antes de ajsiki in weyi tonale de toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iwan nochtin akinmej kitlajtlaniliskej in toSeñor ma kinmakixti, in Señor kinmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Xikkakikan kiné tlakaj de Israel tlan namechilwis: Jesús de Nazaret, Dios okipejpenke. Namejwan kuale ankimatij porke Jesús okipixke miek poder para okinchij milagrostin iwan señalestin anmoixpan. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Namejwan ankikitzkijkej iwan ankitemaktijkej (onkitemaktilijkej) inmak in tlakaj tlajtlakolejkej, iwan ankimiktijkej itech krus, ijkón ken Dios yokimatia iwan okinekke ijkón ma pano. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Dios okiyolitij iwan okimakixtij de itech mikilistle. Porke in mikilistle mach owelik okitlanke in Jesús iwan Yej omoyolkuik oksemi. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Achtoj in rey David otlajtoj de yen Jesús, okijtoj: Nochipa onikitaya in Señor noyakapan. Yej ik noyekma, mach akaj welis itlaj nechtoktis. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por yonik niyolpaki, iwan noten tlakuika ika pakilistle. Maski nimelatok, nikmati nik nimoyolkuis (nimoyolitis). ");
INSERT INTO nhyNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porke amo tikkawas noanima kan tliko, nion amo tikkawas ma ijtlakawi notlalnakayo de Nej nimochipawkaKone. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Otinechititij in kuale ojtle kan nias para nikpias nemilistle nochipa, iwan nikpias miek pakilistle nijkuak nietos mowan. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Nokniwan, nikneki namechilwis nik in rey David omikke iwan okitookakej, iwan asta axan tikmatij kanin toktok. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David oyeka profeta, iwan okimatia nik in Dios okilwij ipan melajka, nik kitlalis se Rey se de iwejkaixwi katlej satepan motlalis itech isiya para tlanawatis. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ijkón kiné, kej yeskia okonitoka, David otlajtoj de kenik moyolkuini in Cristo. Okijtoj nik in Dios mach kikawani kan tliko iwan itlalnakayo mach ijtlakawini. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ijkón kiné, Dios yokiyolitij in Jesús, iwan tejwan titlatitlaniltin tinochtin otikitakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yej omoyolkuik ika poder para omotlalij ik iyekma in toTajtzin Dios, yen toTajtzin Dios okimakak in Espíritu Santo katlej achtoj Jesús okijtoj techwaltitlanilis, iwan axan Yej yotechnokilij iEspíritu katlej namejwan axan ankitaj iwan ankikakij. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Porke mach yen David katlej otlejkok ilwikak, porke yej inewian okijtoj: In Dios okilwij in noSeñor: “Ximotlali ik noyekma, ");
INSERT INTO nhyNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","asta ijkuak Nej nimitztlalis titlayekanke de yejwan katlej mitzkokoliaj.” ");
INSERT INTO nhyNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Tlakaj de Israel, kuale xikmatikan iwan ipan melajka, nik in Jesús katlej ankimajmasoltijkej itech krus. Dios okitlalij para ma yeto yen toSeñor iwan yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nijkuak okikakej yon tlajtole katlej ompa oololitokaj, sa tekitl omoyolkokojkej, iwan okitlajtlanijkej in Pedro iwan oksekimej tlatitlaniltin: ―Tokniwan, ¿tlan moneki tikchiwaskej? ");
INSERT INTO nhyNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pedro okinnankilij: ―Ximoyolkuepakan inawak Dios iwan ximokuateekikan kada se de amejwan ika itoka in toSeñor Jesucristo, para ijkón Dios amechtlapojpolwis de amotlajtlakol, iwan ijkón Yej amechtliokolis iEspíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Dios okisentlalij amechmakas iEspíritu Santo namejwan iwan namopilwan, iwan noijki nekatej tlakaj katlej katej wejka. Kijtosneki nochtin in tlakaj katlej Dios kinnotzas ma yekan iaxkawan. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro okintlapowij ika okachi oksekin tlajtole iwan okinyekilwij: ―¡Amo inwan ximonelokan in tlakaj katlej mach kinekij kikakiskej in melajkayotl! ");
INSERT INTO nhyNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ijkón kiné, katlej okineltokakej tlan okijtoj in Pedro, omokuateekijkej. Iwan yon tonale omajxitijkej oksekimej tlaneltokakej kej eyi mil tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nochtin omotekipachoayaj de tlan okinmachtiayaj in tlatitlaniltin, iwan okimoxejxeliliayaj nochi tlan okipiayaj, omotiotzajtziliayaj iwan omololoayaj para kisepankuaskej in pan para kelnamikiskej imikilis in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Miekej milagrostin iwan señalestin okinchiwayaj in tlatitlaniltin. Iwan nochtin in tlakaj opéj momawtiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nochtin in tlaneltokakej omoyekwikayaj iwan okipiayaj san se inyolo, iwan okimoxejxeliliayaj tlan okipiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Okinnamakayaj intlalwan iwan nochi tlan okipiayaj iwan okinpalewiayaj katlej mach itlaj okipiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Nochipa omololoayaj kan weyi tiopan, iwan itech inkajkalijtik okisepankuayaj in pan para kelnamikiskej imikilis in Jesús, iwan osepantlakuayaj ika pakilistle, ");
INSERT INTO nhyNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","iwan okiweyikixtiayaj in toTajtzin Dios. Iwan nochtin in tlakaj okintlakitayaj in tlaneltokakej, iwan nochi tonale omomiekiliayaj katlej toSeñor okinmakixtiayaj de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Se tonale, Pedro iwan Juan oyajkej kan weyi tiopan de Jerusalén kej las tres de tiotlakke para motiotzajtziliskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ompa kan weyi tiopan oyeka se koxo desde itlakatilis, nochipa okiwikayaj iwan okitlaliayaj ompa kaltempan kan kilwiaj Kuakualtzin, iwan okinmijtlaniliaya tomin katlej ompa okalakiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nijkuak in koxo okinmitak in Pedro iwan Juan ya kalaktiwej ijtik in weyi tiopan, okinmijtlanilij tomin. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Yejwan okitlatakej, iwan Pedro okilwij in koxo: ―Xitechtlata. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","In koxo okinyektlatak, iwan okichixtoka ma kimakakan itlaj tomin. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","In Pedro okilwij: ―Mach nikpia plata nion oro, pero tlan nikpixtok nimitzmakas. Ika itoka in Cristo Jesús de Nazaret, ximoketza iwan xinejnemi. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Satepan de ijkón okilwij, in Pedro okitilanke ika iyekma iwan okiketzaltij, iwan nijkuak okontilanke oyekmejmelawikej imetztlalwayowan. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ijkón yej omoketewak iwan opéj nejnemi kuale, iwan okalakke ijtik in weyi tiopan inwan tlatitlaniltin, nejnentiw iwan ajkotzikuintiw iwan okiweyikixtijtiaya in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nijkuak nochtin in tlakaj okitakej ya nemi iwan kiweyikixtia in toTajtzin Dios, ");
INSERT INTO nhyNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","niman okixmatkej nik yen tlakatl katlej ompa omotlaliaya iwan omijtlaniaya ika tomin itech tiopankaltentle kan kitokayotiaj Kuakualtzin. Sa tekitl omotetzawijkej iwan omomawtijkej por yen tlan omochij in koxo. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","In tlakatl katlej opajtik mach ok semi okinkawaya in Pedro iwan Juan. Nochtin in tlakaj sa tekitl omotetzawijkej, iwan oyajkej omotlalojkej okinmitatoj kan kitokayotiaj Korredor de Salomón. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","In Pedro nijkuak ijkón okitak, okinmilwij: ―¿Tlanik anmotetzawiaj namejwan tlakaj de Israel? ¿Tlanik antechtlajtlataj? ¿Kox ankiyejyekoaj tejwan otikpajtijkej in koxo ika topoder para ma nejnemi? O noso ¿kox ankiyejyekoaj porke tikpiaj tonemilis chipawak iwan por yonik in yin tlakatl owelik otikpajtijkej? ");
INSERT INTO nhyNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Yen Dios okipajtij in koxo, yen Dios de Abraham, de Isaac, de Jacob, iwan de yen ya wejkawitl toweyitajwan. Dios okipajtij iwan ika okiweyikixtij in Jesús katlej iKone, katlej namejwan ankitemaktijkej (okinkitemaktilijkej) imak Pilato, yej okinekia kikajkawani iwan namejwan mach ankinekej. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Namejwan yej ankitlajtlankej ma kikajkawakan se tlakatl katlej temiktij, iwan mach ankinekej ma kikajkawakan katlej oyáj yolchipawak iwan kuale tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Iwan ijkón namejwan ankimiktijkej katlej techmaka nemilistle, pero Dios okiyolitij oksemi satepan de omikke, iwan tejwan kuale tikmatij porke otikitakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Yin tlakatl katlej amejwan ankitaj iwan ankixmatij, Dios okipajtij iktlanke (ik tlami) porke tikneltokaj ipoder in Jesús. Iwan por tikneltokaj in Jesús, axan Yej amoixpan okipajtij. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Nokniwan, nikmati ke nijkuak amejwan iwan amotekiwajkawan ankimiktijkej in Jesús, mach ankimatkej tlan ankichijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ijkón, Dios okichij tlan achtoj okitematiltij ika nochtin inten in profetajtin, de tlan panoani iCristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Por yonik, namejwan ximoyolpejpenakan iwan ximoyolkuepakan inawak Dios, para ma amechtlapojpolwi de amotlajtlakol, iwan ijkón in Señor kichiwas ma mosewi namoanima. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Iwan noijki oksemi kiwaltitlanis in Cristo katlej Dios yokipejpenke desde achtoj, kijtosneki kiwaltitlanis in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Maski axan in Jesús kipia de yetos ilwikak asta ma tlami ma kiyektlali in Dios nochi tlamantle. Ya wejkawitl ijkón okijtoj ika inten in profetajtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés okinmilwij in ya wejkawitl toweyitajwan: “In Señor toDios kichiwas ma kisa de amejwan se profeta ken nej. Xikneltokilikan yon profeta nochi tlan anmechilwis, ");
INSERT INTO nhyNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","porke akin amo kineltokilis nekáj profeta, Dios kixpolos iwan mach ok powis inwan ipilwan.” ");
INSERT INTO nhyNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Iwan nochtin in profetajtin, desde Samuel para nian, otlapojkej noijki de yinmej tonaltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Namejwan antepilwan de nekatej profetajtin, iwan namejwan anmaktiskej de tlan Dios okinmilwij kinmakas in ya wejkawitl toweyitajwan. Dios okilwij in Abraham: “Por yen mopilwan nikintiochiwas nochtin in tlakaj de ixko yin tlaltikpak.” ");
INSERT INTO nhyNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nijkuak in Dios okiyolitij iKone, oamechwaltitlanilij achtoj namejwan katlej anjudiojtin para ma amechtiochiwa, para xikkawakan de xitlajtlakokan. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro iwan Juan ok okintlapowijtokaj in tlakaj, iwan ijkuakón oajsikoj in tiopixkej, in komandante de yen weyi tiopan iwan saduceos. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nochtin okualaniaj porke Pedro iwan Juan okinmachtiayaj in tlakaj, iwan okinmilwiayaj nik in mikkamej moyolkuiskej (moyolitiskej) porke Jesús omoyolkuik. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Tonses okinkitzkijkej iwan okintzakej, iwan asta yen oksé tonale okijtojkej kintlatzintokiskej porke yotiotlakik. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Miekej katlej okikakej itlajtol in Dios okineltokakej, iwan san yen okichtin okinpojkej oyekaj kej makuile mil tlakaj katlej otlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Owalmostlatik omololojkej Jerusalén in tlanawatijkej judiojtin, in tlayekankej tetajtzitzintin iwan tlamachtijkej de itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Noijki ompa oyekaj in wejweyin tiopixkej, Anás, Caifás, Juan, iwan Alejandro. Iwan nochtin infamiliareswan in wejweyin tiopixkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Pedro iwan Juan okinketzkej tlatlajko iwan okintlajtlanijkej: ―¿Ika tlan tlanawatijkayotl ankichijkej ma pajti in kokoxke, o noso akin oamechnawatij xikpajtikan in kokoxke? ");
INSERT INTO nhyNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pedro tentok de Espíritu Santo okinnankilij: ―Namejwan antlanawatijkej iwan antlayekankej tetajtzitzintin de yin pueblo. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tla axan namejwan antechtlajtlaniaj kenik otikpalewijkej in kokoxke, iwan kenik opajtik, ");
INSERT INTO nhyNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","pues axan, tamechmatiltiaj amoixpan para ma kimati nochi in pueblo de Israel, nik in yin tlakatl katlej kajki amoixpan, opajtik ika itoka in Cristo Jesús de pueblo de Nazaret, katlej namejwan ankimiktijkej itech krus iwan satepan Dios okiyolitij. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yin Jesús, Yej kej se tetl katlej kuale iwan namejwan ankatej kej ankalchijkej. Yon kuale tetl namejwan mach ankinekej, pero Yej omochij yen tetl katlej okachi kichikajtok in tepamitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mach onkaj oksé tlakatl akin welis techmakixtis, porke Dios mach otechmakak oksé tlakatl para inawak ma timomakixtikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nijkuak in tlayekankej de itech junta okimomakakej kuenta nik in Pedro iwan Juan melawak ixchijchikawakej iwan mach ixtlamatkej, sa otlajtlachixkej (omomajmawtijkej). Iwan ijkuakón noijki okimomakakej kuenta nik melawak onemiaj iwan Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Iwan tlakatl katlej opajtik ompa oyeka inwan Pedro iwan Juan, iwan por yonik mach ok owelik ok itlaj okijtojkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ijkuakón okinkixtijkej de kan junta se achitzin, iwan omonotzkej san yen tlayekankej de itech junta para motlapowiskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Okijtojkej: ―¿Tlan welis tikintoktiskej in yinmej tlakaj? Nochtin in chanejkej de Jerusalén kimatij nik okichijkej se weyi milagro, iwan mach welis tikijtoskej nik mach melawak. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Iwan para amo okachi ma xoyawi (xitini) yin tlajtole, ma tikinmajmawtikan, para ke de nian para tlayakapan mach ok ma tetlapowikan de Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ijkuakón oksemi okinnotzkej ma kalakikan Pedro iwan Juan iwan okinnawatijkej ayakmo ma tetlapowikan iwan ayakmo ma tlamachtikan itlaj de Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro iwan Juan otlanankilijkej: ―Kuale xikyejyekokan namejwan kox Dios kimonekiltia yej amejwan se ma amechneltokili iwan amo se ma kineltokili in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Tejwan mach welis tikkawaskej de tikijtoskej de tlan yotikitakej iwan yotikkakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ijkuakón okinmajmawtijkej in Pedro iwan Juan iwan okinkajkajkej ma wian. Mach okajsikej kenik welis itlaj kintoktiskej, porke nochtin in tlakaj okiweyikixtiayaj in Dios por yen tlakatl katlej opajtik. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Iwan in tlakatl katlej opajtik ika yin milagro, okipiaya okachi de omenpoale xiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro iwan Juan, nijkuak okinkajkajkej, oyajkej kan oyekaj in oksekimej intekitijkaikniwan, iwan okinmakakej kuenta de nochi tlan tlayekankej tiopixkej iwan tlayekankej tetajtzitzintin okinmilwijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Satepan de okinkakilijkej, nochtin omotiotzajtzilijkej okijtojkej: ―ToWeyi tlanawatij Dios, tejwatzin otikchij in ilwikak, in tlaltikpak, in atl iwan nochi tlan onkaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tejwatzin ika Espíritu Santo iwan de itech iten motekipanoj David otikijtoj: ¿Tlanik mokualaniaj in paismej? ¿Tlanik in tlaltikpaktlakaj san tlan amo kajsij kiyejyekoaj? ");
INSERT INTO nhyNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","In tekiwajkamej de nochi in tlaltikpak omosetilijkej, para motlatlalwiskej para yaskej en kontra de yen Dios iwan de iCristo temakixtij. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Tikmatij nik melawak in Herodes, iwan Poncio Pilato, iwan judiojtin iwan katlej mach judiojtin omololojkej nian Jerusalén iwan omokuepkej kontra mochipawkaKone Jesús katlej tejwatzin otikpejpenke. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Okichijkej nochi tlan desde achtoj otikyejyekoj iwan otikmonekiltij ijkón ma mochiwa. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Axan Señor, xikita tlan kinekij techtoktiskej, iwan xitechyolojchikawa tejwan timotekipanojkawan para ma tiktematiltikan motlajtol ika ixchikawalistle. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iwan ika mopoder ma pajtikan in kokoxkej iwan ma mochiwakan milagrostin iwan señalestin ika itoka in mochipawkaKone Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nijkuak otlankej omotiotzajtzilijkej, kan oololitokaj otlalolinke, iwan nochtin otenkej de Espíritu Santo, iwan otetlapowiayaj de itlajtol in toTajtzin Dios ika ixchikawalistle. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nochtin in tlaneltokakej okipiayaj san se intlalnamikilis. Mach akaj okijtoaya ke tlan kipixtok san para yej, sino para nochtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","In tlatitlaniltin ika miek poder okitematiltiayaj kenik omoyolkuik in Señor Jesús, iwan Dios nochtin okintiochiwaya miek. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Nion se de yejwan mach itlaj okipoloaya, iwan akin okinpiaya itlalwan o noso ikalwan, okinnamakaya iwan tomin nochi okitemakaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","In tomin okinmaktiliayaj in tlatitlaniltin, para ma kinxejxelilikan in tlaneltokakej katlej okinpoloaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ijkón okichij se tlakatl itoka José, katlej walajtok nelwatl de familia de Leví iwan katlej otlakatke itech tlale katlej pankistok itech atl itoka Chipre, katlej in tlatitlaniltin okitokayotijkej Bernabé, kijtosneki teyolojchikaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Yon tlakatl okinamakak itlal iwan tomin okinmaktilij in tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Oyeka se tlakatl itoka Ananías, yej iwan isiwa Safira omotlalnamakijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Yon tlakatl omotlatlalwij iwan isiwa de kimokawiskej sekin de yon tlaltomin iwan oksekin okinmakak in tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro okilwij: ―Ananías, ¿tlanik okimoaxkatij moyolo in Satanás, iwan omitztoktij xikkajkayawa in Espíritu Santo, para xikmokawi sekin tomin de tlan omitztlaxtlawilijkej de yen motlal? ");
INSERT INTO nhyNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Amo oyeka moaxka in tlale? Iwan satepan de otiknamakak, ¿amo oyeka moaxka in tomin? ¿Tlanik otikkawilij moyolo ma tlakajkayawa? Mach otikinkajkayaj in tlakaj, sino otiknekia tikajkayawani in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nijkuak ijkón okikakke, Ananías owetzito ipan tlale iwan omikke. Iwan nochtin katlej okimatkej sa tekitl omomawtijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ijkuakón owalajkej sekimej telpokamej, okikimilojkej in tlalnakatl iwan okitookatoj. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kej eyi ora satepan oejkok isiwa in Ananías, iwan mach okimatia tlan otlapanok. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro okitlajtlanij: ―Xinechilwi, ¿ankinamakakej in tlale ika yon ipatij ken nankijtaj? Iwan yej otlanankilij: ―Melawak, ika yon ipatij. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pedro okilwij: ―¿Tlanik namejwan anmotlatlalwijkej para ankiyejyekoskej iEspíritu in Señor? Nian witzej katlej okitookatoj mookich, iwan axan tej noijki mitzwikaskej mitztookatiwej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","San niman ijkuakón Safira owetzito ikxitlan Pedro iwan omikke. Nijkuak omokuepatoj in telpokamej, okajsitejkokej in Safira yomikke, okikixtijkej iwan okitookatoj inakastlan iokich. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iwan nochtin in tiopantlaneltokakej iwan nochtin katlej okimatkej tlan otlapanok, sa tekitl omomawtijkej inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","In tlatitlaniltin okinchiwayaj miekej milagrostin iwan señalestin innawak in tlakaj. Iwan nochtin in tlaneltokakej omololoayaj kan kitokayotiaj Korredor de Salomón. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mach akaj omixewiaya mosetilis inwan, pero nochtin in tlakaj okinyektlakitayaj in tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Iwan omomiekiliayaj miekej okichtin iwan siwamej katlej okineltokayaj in toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Por yonik, asta okinkixtiayaj in kokoxkej ipan ojtle, okintlaliayaj ipan intlapech iwan inpan inpetl para nijkuak panos in Pedro, siera ma kinmekawili ika iekawilo para ma pajtikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Noijki miekej oksekimej pueblojtin de ik ompa serka, owalayaj Jerusalén okualinwikayaj kokoxkej iwan katlej okipiayaj ejekamej mach kualtin, iwan nochtin opajtiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","In weyi tiopixke iwan grupo de saduceos katlej ompa inwan oyekaj, sa tekitl omoxikojkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Okinkitzkijkej in tlatitlaniltin iwan okintzakej telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero se iángel in Señor okintlapoj de yuak iwan okinkixtij. Okijtoj: ");
INSERT INTO nhyNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Xiwian. Xikalakikan ijtik in weyi tiopan iwan xikinmatiltikan nochtin de nochi yin yankuik nemilistle. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yejwan okineltokakej tlan okinmilwij in ángel. Nijkuak otlaneske, okalakej ijtik in weyi tiopan iwan opéj tlamachtiaj. Iwan ijkuakón in weyi tiopixke iwan katlej iwan oyekaj okichijkej junta iwan okinnotzkej in tlayekankej tetajtzitzintin de Israel para ma mololokan. Iwan otlanawatijkej ma kualinwikakan in tlatitlaniltin de kan telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero nijkuak in mayoltin oajsitoj telpiloyan, mach ok okinmajsitajsikej in tlatitlaniltin. Tonses omokuepkej okitematiltitoj, ");
INSERT INTO nhyNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","okijtojkej: ―Otikajsitajsikej in puerta kuale tzaktok, iwan soldadojtin oyekaj iyakapan puerta kan otzaktokaj. Pero nijkuak otiktlapojkej in puerta, mach ok akaj otikajsikej tlijtik. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nijkuak ijkón okikakej, in weyi tiopixke, in komandante de weyi tiopan iwan oksekimej tlayekankej tiopixkej, omotlanemililtijkej iwan okimolwiayaj tlanon welis tlapanos satepan de yon tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ijkuakón oejkok se tlakatl, iwan okinmilwij: ―Xikkakikan, katlej amejwan ankintzakej katej itech weyi tiopan kinmachtijtokej in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","In komandante de weyi tiopan iwan imayolwan, oyajkej oksemi okinnotzatoj, pero mach itlaj okintoktijkej, porke okinmiimakasiaj in tlakaj de ma kinmojmotlakan ika tetl. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nijkuak okualinwikakej in tlatitlaniltin, okinteixpantijkej itech junta iwan in weyi tiopixke okintlatzintokij okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tejwan kuale otamechnawatijkej mach ok xitlamachtikan ika itoka yon tlakatl Jesús. Iwan xikitakan tlan ya ankichijkej, ya ankixoyajkej (onkixitinijkej) namotlamachtilis itech nochi in weyikan de Jerusalén, iwan asta antechmamaltiaj nik tejwan otikmiktijkej yon tlakatl. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pedro iwan oksekimej tlatitlaniltin otlanankilijkej: ―Tejwan tikpiaj de tikchiwaskej tlan Dios kijta iwan amo tlan namejwan ankijtaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","In Dios katlej ya wejkawitl toweyitajwan okineltokakej Yej okiyolitij in Jesús katlej namejwan ankimiktijkej nijkuak ankimajmasoltijkej itech krus. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios okiweyijkatlalij in Jesús ik iyekma iwan okimonekiltij yen Jesús ma yeto toTlayekanke iwan toTemakixtij. Dios ijkón okichij para ke in tlakaj de Israel ma moyolpejpenakan (ma moyolkuepakan) de intlajtlakol iwan ijkón Dios kintlapojpolwis. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tejwan nochi otikitakej iwan tikmatij tlan axan titetlapowiaj, iwan noijki kimati in Espíritu Santo. Dios techmaka in Espíritu Santo tinochtin katlej tikneltokaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Katlej oyekaj itech junta, nijkuak okikakej in yon tlajtole, sa tekitl omokuejsojkej iwan okinekiaj kinmiktianij in tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero ompa oyeka se tlakatl fariseo itoka Gamaliel, katlej oyeka tlamachtij itech tlanawatile de Moisés, iwan nochtin in tlakaj sa tekitl okitlakitayaj. Yin Gamaliel omoketzke iwan otlanawatij ma kinkixtikan kalan in tlatitlaniltin se achitzin. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Iwan okijtoj: ―Tetajmej de Israel, xikpiakan kuidado de tlan ankinekij ankintoktiskej in yinmej tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xikelnamikikan namejwan, ke ya wejkikatzin omonextij se tlakatl itoka Teudas. Yon Teudas omoweyikixtij, iwan okinyekanaya kej nawi siento tlakaj. Pero yon Teudas okimiktijkej, iwan katlej okinyekanaya ochocholojkej iwan nochi ompa otlanke. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Satepan de Teudas omonextij Judas de estado de Galilea, meroj nijkuak omochij censo, iwan noijki okinyekanke miekej, pero noijki okimiktijkej, iwan nochtin katlej okinyekanke opojpolikej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Por yonik, namechilwia xikinkawakan in yinmej tlakaj, amo inwan ximokalakikan. Porke tla yin tlamachtile kisa de tlakaj, se tonale kipia de pojpoliwis. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero tla kisa de Dios, mach welis ankitzakuiliskej. Xikpiakan kuidado, amo san kichiwa yej ankinekij ankimomagaskej iwan Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yejwan kiné okinakasnamikej tlan okinmilwij in Gamaliel. Okinnotzkej in tlatitlaniltin, okinwitekej iwan okinmilwijkej mach ok ma kitenewakan itoka in Jesús, iwan okinkajkajkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","In tlatitlaniltin okiskej de itech yon junta ika pakilistle, porke Dios okinkawilij ma tlajyowikan iwan ma kinpijpinatikan por okitenewayaj itoka in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Iwan momostla itech weyi tiopan iwan kalpan, mach okawayaj de otlamachtiayaj iwan de okitematiltiayaj de Jesucristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Itech nekatej tonaltin, komo okachi omomiekiliayaj in momachtijkej tlaneltokakej, katlej otlajtoayaj griego opéj kinmixnamikij katlej otlajtoayaj hebreo, okijtoayaj ke momostla nijkuak okinxejxeliliayaj tlan kikuaskej, in viudajtin griegajtin mach okinmakayaj ijkón ken katlej okinmakayaj viudajtin hebreas. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ijkuakón in majtlaktle iwan omen tlatitlaniltin okinmololojkej nochtin in momachtijkej tlaneltokakej iwan okinmilwijkej: ―Mach kuale kaj, tla tikkawaskej de titetlapowiskej de itlajtol in Dios, iwan yej pewas titetlamakaskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Okachi kuale, xikinpejpenakan chikomen de tokniwan katlej kuale kintlakitaj, katlej kipiaj kuale intlalnamikilis iwan ma tentokan de Espíritu Santo, para yejwan ma kichiwakan yon tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Tejwan tikseguiroskej timotiotzajtzilijtoskej iwan tiktematiltijtoskej itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nochtin okinakasnamikej tlan okijtojkej in tlatitlaniltin, okipejpenkej in Esteban, tentok de tlaneltokalistle iwan de Espíritu Santo, noijki okipejpenkej in Felipe, Prócoro, Nicanor, Timón, Pármenas iwan Nicolás de Antioquía katlej mach judío pero okalakke itech intiotlamachtil in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Satepan nochtin in chikomen okualinwikakej innawak in tlatitlaniltin, omotiotzajtzilijkej iwan inpan okintlalijkej inmawan. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Itlajtol in toTajtzin Dios opéj xoyawi (xitini) okachi, iwan ompa Jerusalén in momachtijkej tlaneltokakej okachi omomiekiliayaj. Noijki miekej tiopixkej judiojtin otlaneltokakej itech yon tlaneltokalistle de Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dios okitemitij in Esteban de tlaneltokalistle iwan de Espíritu Santo, iwan okinchiwaya milagrostin iwan señalestin intech in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero omonextijkej sekimej de itech se tiopan de yen judiojtin katlej kinmilwiaj Esclavos Libertados, iwan sekimej de Cirene, de Alejandría, de Cilicia iwan de Asia, iwan yejwan opéj motlatlajtolkuepaj iwan Esteban. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero mach oweliaj okitlaniaj, porke yej otlanankiliaya ika ixtlamachilistle katlej okimakaya in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ijkuakón okinmichtakatlatlalwijkej sekimej tlakaj para ma kijtokan ke okikakej in Esteban otlajtoaya biero de Moisés iwan otlajtoaya biero de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iwan por yonik sa tekitl oyomonkej in tlakaj iwan tlayekankej tetajtzitzintin iwan tlamachtijkej de itlanawatil in Moisés. Sa tekitl okualankej iwan okikitzkijkej in Esteban iwan okiwikakej itech junta. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Okintemojkej sekimej tlajtoltlatlalijkej, iwan yonmej okijtojkej: ―Yin tlakatl tlapojtinemi biero de yin weyi tiopan tlatiochiwaloj iwan tlajtoa biero de itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Otikkakej okijtoj ke Jesús de Nazaret, kixixinis in weyi tiopan iwan kinpatlas in kostumbres katlej Moisés otechinkajtewilij. ");
INSERT INTO nhyNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Iwan nochtin katlej ompa oewatokaj itech junta, nijkuak okitlatakej in Esteban, okitakej ixko kej yeskia ixko se ángel. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","In weyi tiopixke okitlajtlanij in Esteban: ―¿Kox melawak nochi tlan yejwan mitzistlakawiaj? ");
INSERT INTO nhyNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Yej otlanankilij: ―Nokniwan iwan tetajmej de Israel, xinechkakikan: In toWeyijkatlalitok Dios, ya wejkawitl okimonextilij in toweyitaj Abraham, nijkuak oyeka itech tlale de Mesopotamia, antes de onchantini kan pueblo de Harán, ");
INSERT INTO nhyNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","iwan Dios okilwij: “Xikisa de itech motlal iwan xikinkajtewa moparientejwan, iwan xiwia itech oksé tlale katlej Nej nimitzititis.” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ijkuakón Abraham okiske de itech tlale de Caldea iwan oyáj ochantito itech pueblo de Harán. Satepan de omikke ipapan, Dios okualwikak in Abraham itech yinmej tlalmej, kan namejwan axan anchantij. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Pero mach itlaj okikajtewilij itech yin tlale, nimpor kan kitlalis se ikxi. Pero Dios okilwij nik kitlaltis, iwan satepan de ijkuak yej mikis in tlale mokawas para ipilwan, maski ijkuakón in Abraham mach ya okipiaya nion se ikone. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Noijki, Dios okilwij ke ipilwan chantiskej itech oksé país kan amo intlal, yeskej kej tlanamaktin iwan kintekipanoltiskej sa tekitl, iwan kinnekatoktiskej kej nawi siento xiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero noijki Dios okilwij: “Nej nikinmixkomakas (kintzonmanas) in tlakaj de yon país akinmej kintekipanoltiskej iwan kinnekatoktiskej mopilwan. Satepan kisaskej de ompa iwan nechweyikixtiskej itech yin tlale.” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios omotlapowij iwan Abraham iwan omokajkej san se tlajtole de ke Abraham kichiwas in sirkunsisión. Nijkuak ochikometik de otlakatke in Isaac, in tetaj Abraham okisirkunsidaroj. Noijki ijkón okichij in Isaac iwan ikone Jacob, iwan Jacob noijki ijkón okichij iwan ipilwan katlej oyajkej tetajmej de yen majtlaktle iwan ome familias de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Yinmej majtlaktin iwan omen iknimej yejwan oyajkej in ya wejkawitl toweyitajwan, yejwan wel omoxikojkej miek de inmikni José, iwan okinamakakej para ma kiwikakan itech país de Egipto. Pero Dios oyeka iwan José, ");
INSERT INTO nhyNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","iwan okipalewij itech nochi tlan otlajyowij. Dios okimakak in José ixtlamachilistle iwan okipalewij para ke in Faraón rey de Egipto, ma kiyolejkita in José. Yin rey okitlalij in José ma yeto gobernador de Egipto iwan ma kita nochi tlan iaxka in rey. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Satepan owalaj miek apistle iwan miek tlajyowilistle itech nochi in tlale de Egipto iwan itech tlale de Canaán, iwan ya wejkawitl toweyitajwan mach okipiayaj tlan kikuaskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero nijkuak in Jacob okimatke onkaj trigo itech país de Egipto, okintitlanke ompa ipilwan yejwan in ya wejkawitl toweyitajwan. Ijkuakón yakinika ompa oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nijkuak oyajkej ipan ojpa, José omoteixmachtij inawak ikniwan, iwan ijkón in Faraón okimatke de tlan rasa oyeka in José. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Satepan, José otlanawatij ma kualinwikakan ipapan iwan ifamilia, para ma mochantitij Egipto. Por nochtin oyekaj kej eyinpoale iwan kaxtole. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ijkón, Jacob oyáj omochantito Egipto, ompa omikke iwan ompa omikkej noijki ipilwan, yejwan in ya wejkawitl toweyitajwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Intlalnakayo okinwikakej para itech pueblo de Siquem, iwan okintookakej ijtik imikkakuyok in Abraham katlej yej okimokowij ika miek platajtomin. Achtoj, ompa Siquem ipilwan in Hamor okinamakiltijkej in Abraham in yon mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Nijkuak yoajsitiwalaya in tonale para mochiwas tlan Dios okilwij in Abraham, topueblo de Israel sa tekitl omomiekilij ompa Egipto. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pero itech yonmej tonaltin, okalakke oksé rey ompa Egipto katlej mach itlaj okimatia de José. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Yon rey okinkajkayaj tokniwan iwan okinnekatoktij in ya wejkawitl toweyitajwan, okinnawatij ma kintlamotlakan inselikkonewan katlej chochokotzitzintin para ma mikikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Itech yonmej tonaltin otlakatke Moisés. Dios okiwelitak in yon konetl, iwan tetajmej okiskaltijkej inkalijtik san eyi metztle. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nijkuak okikawatoj kalan in konetl, ichpoch in rey Faraón okajsik iwan okiskaltij kej yeskia ikone. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Iwan ijkón Moisés okixtlamachtijkej ika nochi tlan okimatiaj in egipcios, yej oyeka sa tekitl ixtlamatke para tlajtos iwan para tekipanos. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Nijkuak okipixke omenpoale xiwitl, Moisés oyáj okintlajpaloto ikniwan de ipueblo Israel. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Pero nijkuak okitak se tlakatl egipcio okinekatoktijtoka se tlakatl israelita, Moisés okipalewij in israelita iwan okimiktij in egipcio. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés okimolwij ke ikniwan de ipueblo Israel kimomakanij kuenta, nik yen Dios katlej okititlanke in Moisés para ma kinmakixti, pero yejwan mach okimomakakej kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Omostlatik, Moisés okinmitak omen tlakaj de Israel omomagatokaj, iwan yej okinekia kinyolosewis, okinmilwij: “Namejwan anmiknimej, ¿tlanik ankimomagaj?” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ijkuakón katlej otemagatoka okitopej in Moisés, iwan okilwij: “¿Akin omitztlalij kej titekiwaj o noso kej tijues para ximokalaki towan? ");
INSERT INTO nhyNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tikneki tinechmiktis noijki, ken yala otikmiktij in egipcio?” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nijkuak ijkón okikakke, Moisés ocholoj iwan oyáj kan tlale de Madián. Ompa ochantik tepueblo iwan ompa okinpixke ome ipilwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Opanok kanaj omenpoale xiwitl satepan, se tonale oyeka kan tlawaki ipan se tepetl itoka Sinaí, ompa okimonextilij se ángel ijtik tlitl kan otlatlaya se kuatlanwitztle. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés sa otlajtlachixke (omomajmawtij) de tlan okitak, iwan nijkuak omijkuanij para kiyekitas okachi, ijkuakón okikakke itlajtol in Señor: ");
INSERT INTO nhyNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nej niDios de moweyitajwan. Nej niDios de Abraham, de Isaac iwan de Jacob.” Moisés opéj papatlaka (bibioka) de majkayotl iwan mach ok omixewiaya ok kitlatas. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ijkuakón in Señor okilwij: “Ximokakkixti porke kan titlaksatok tlatiochiwaloj. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yonikitak kenik tlajyowiaj nopilwan katlej katej Egipto. Yonikinkakilij inneyolkokolis iwan oniwaltemok para nikinmakixtis. Axan kiné, xiwiki, nimitztitlanis Egipto.” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Maski yejwan okikokolijkej in Moisés iwan okilwijkej: “¿Akin omitztlalij kej titekiwaj o noso kej tijues para ximokalaki towan?” Dios okitlalij in Moisés iwan okititlanke kej tekiwaj iwan kej temakixtij, iwan ángel okipalewij katlej okimonextilij itech kuatlanwitztle katlej otlatlatoka. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Yen Moisés okinkixtij de Egipto in ya wejkawitl toweyitajwan, iwan okinchij milagrostin iwan señalestin itech nekáj tlale de Egipto, itech mar itoka Chichiltik iwan kan tlawaki, ijkón okichij kej omenpoale xiwitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Yen yon Moisés katlej achtoj okinmilwij in tlakaj de Israel: “Dios anmechwaltitlanilis se profeta ken nej onechwaltitlanke, iwan kisas de yen namejwan. Xikneltokilikan tlan amechilwis.” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yen yon Moisés katlej oyeka inwan tlakaj de Israel kan tlawaki, noijki katlej okitlapowij in ángel kan tepetl Sinaí, noijki katlej oyeka inwan ya wejkawitl toweyitajwan, iwan noijki katlej okimaktilijkej in tlajtole katlej kitemaka nemilistle, para satepan tejwan ma techpanoltili. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero in ya wejkawitl toweyitajwan mach okineltokilijkej, sino omixkuepkej iwan okinekiaj mokuepanij para Egipto. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Okilwijkej in Aarón: “Xitechinchiwili sekimej diosmej katlej ma techyekanakan, porke mach tikmatij tlan opanok in Moisés katlej otechkixtij de Egipto.” ");
INSERT INTO nhyNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iwan ijkuakón okichijkej se dios kej se torojkonetl, okitlamiktilijkej iwan okitlamanilijkej. Iwan omopaktijkej por tlan yejwan okimochiwilijkej ika inmawan. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Por yonik Dios okinkaj, iwan okinkawilij ma kinweyikixtikan in sitlaltin de ilwikak. Ijkón ken kajki ijkuilitok itech inlibro in profetajtin: Tlakaj de Israel, ¿itech yonmej omenpoale xiwitl kan tlawaki kox yen Nej nannechtlamiktilijkej iwan nannechtlamanilijkej? ");
INSERT INTO nhyNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pues amo, yej ankitkiaj itiopantzin in dios Moloc iwan sitlale de yen dios Renfán. Yonmej diosmej namejwan ankinchijkej iwan ankinweyikixtijkej. Por yonik, Nej namechkixtis de itech amotlal, iwan namechtitlanis asta okachi wejka de yen país de Babilonia. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’In ya wejkawitl toweyitajwan okitkitinemiaj kan tlawaki se mantajtiopantzin iwan ompa ijtik okitkiaj in temej kan oijkuilitoka itlanawatilwan in toTajtzin Dios. Yon mantajtiopantzin Moisés okichij ijkón ken Dios okinextilij iwan okinawatij ijkón ma kichiwa. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Yon mantajtiopantzin katlej okichij Moisés, opanok inmak in ya wejkawitl toweyitajwan iwan okualkuikej nian nijkuak okitlankej in guerra de itech pueblojtin katlej mach judiojtin. Nijkuak Josué oyeka tlayekanke, Dios okinkixtij nekatej tlakaj de itech intlal, iwan ya wejkawitl toweyitajwan okonankej in tlale. In ya wejkawitl toweyitajwan okipixkej in mantajtiopantzin asta ijkuak oyeka in rey David. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios okitlasojtlak miek in David. Iwan David okinekke kichiwas se weyi tiopan para ke ipilwan in Jacob ompa ma kiweyikixtikan in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero mach yen David okichij in weyi tiopan de toTajtzin Dios, sino yen Salomón okichij. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Maski in Dios katlej Weyikistok (Weyititok) mach chanti itech tiopanmej katlej kinchiwaj in tlakaj. Ken okijtoj in profeta: ");
INSERT INTO nhyNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kijta in Señor, In ilwikak yen kan niewatok iwan in tlaltikpak yen kan tlaksatokej nokxiwan. ¿Tlan kale ankinekij annechchiwiliskej namejwan? ¿Kan nichantis iwan kan nimosewis? ");
INSERT INTO nhyNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Amo yen Nej katlej onikchij in ilwikak iwan tlaltikpak? ");
INSERT INTO nhyNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban okinmilwiaya: ―Pero namejwan sa tekitl anyoltlakuawakej. Mach ankinekij ankikakiskej itlajtol in Dios iwan nion mach ankinekij ankineltokiliskej. Nochipa ankixpanawiaj in Espíritu Santo, ijkón okichijkej in ya wejkawitl namoweyitajwan iwan namejwan no ijkón ankichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Iwan namoweyitajwan noijki okintlatlalochtijkej in profetajtin. Yejwan okinmiktijkej in profetajtin akinmej okijtoayaj nik se tonale witz in tlakatl katlej mach kipia nion se tlajtlakole, iwan axan yon tlakatl yowitza, iwan namejwan ankitemaktijkej (onkitemaktilijkej) iwan ankimiktijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Namejwan ankiresibirojkej in tlanawatiltin de Dios katlej oamechmakakej in angelestin, pero mach ankichiwaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nijkuak okikakej tlan okijtoj in Esteban, sa tekitl okualankej asta omotlanteteyitzkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero in Esteban otentoka de Espíritu Santo, oajkopantlachixke ik ilwikak iwan okitak imawisotlanex in Dios. Okitak in Jesús moketok ik iyekma in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iwan okijtoj: ―Xikitakan, nikita in ilwikak tlapotok. Nikita in Jesús katlej omochij tlakatl moketok ik iyekma in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ijkuakón yejwan omonakastzajtzakej iwan okuawtzajtzikej chikawak, iwan nochtin omotlalojkej iwan okikitzkijkej in Esteban. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Okixtijkej in Esteban de itech weyikan de Jerusalén iwan okimojmotlakej ika tetl. Iwan katlej okimojmotlakej okinkajtejkej intlakenwan ma kintlato se telpochtle itoka Saulo. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nijkuak okimojmotlatokaj, Esteban omotiotzajtzilij, okijtoj: ―Señor Jesús, xikresibiro noanima. ");
INSERT INTO nhyNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Satepan omotlankuaketzke iwan okijtoj chikawak: ―Señor, amo xikinchiwili kuenta yin tlajtlakole tlan kichiwaj. Nijkuak otlanke ijkón okijtoj, omikke. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo okijtoj kuale kajki ma kimiktikan in Esteban. Itech nekáj tonale opéj kintlatlalochtiaj in tlaneltokakej katlej oyekaj Jerusalén. Nochtin ochocholojkej ik región de Judea iwan ik región de Samaria, pero in tlatitlaniltin mach ocholojkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sekimej tlaneltokakej katlej sa tekitl omotemaktiayaj inawak Dios okitookatoj in Esteban. Sa tekitl okichokilijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero in Saulo opéj kintlatlalochtia in tlaneltokakej. Okalakia kalpan, okinkixtiaya iwan okinkokuyotzaya okichtin iwan siwamej iwan okintzakuaya telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Iwan katlej ochocholojkej de Jerusalén, otetlapowiayaj de yen kuale tlajtole katlej temakixtia ik nian nepa san kanik oyayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe, se de yejwan katlej ocholojkej, oyáj itech se weyikan itech estado de Samaria iwan ompa opéj tetlapowia de Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Miekej tlakaj omololoayaj iwan okikakiaj ika nochi inyolo tlan okinmilwiaya in Felipe. Okitayaj okinchiwaya señalestin. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Miekej tlakaj katlej okipiayaj ejekamej mach kualtin opajtikej, iwan ejekamej asta otzajtziaj nijkuak okisayaj. Noijki opajtikej in koxomej iwan wilanmej (temetlamej). ");
INSERT INTO nhyNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Iwan por yonik, oyeka miek pakilistle itech yon weyikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ompa itech yon weyikan oyeka se tlakatl itoka Simón. Yon Simón oyeka texoxke (brujo) iwan okinkajkayawaya ika itexoxalis (ibrujería) in tlakaj de yon estado de Samaria. Okijtoaya nik mach akaj oyeka oksé ken yej. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nochtin in tlakaj, desde pilalaktin asta katlej ya tetajmej okineltokiliayaj in Simón. Okijtoayaj: ―Yin Simón kipia poder de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Iwan okineltokiliayaj, porke ika itexoxalis ya wejkawitl kinkajkayajtiwitz. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Iwan nijkuak yejwan okikakej in kuale tlajtole katlej temakixtia katlej Felipe okinmatiltij, yejwan okineltokakej. Felipe okintlapowij kenik in Dios tlanawatia iwan okintlapowij de Jesucristo. Miekej okichtin iwan siwamej omokuateekijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Noijki in Simón texoxke okineltokak iwan omokuateekij, iwan opéj kiwikatinemi in Felipe. Okinmitaya in wejweyin milagrostin iwan señalestin, iwan sa omotetzawiaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","In tlatitlaniltin katlej oyekaj Jerusalén okimatkej nik in tlakaj de itech estado de Samaria okineltokakej itlajtol in Dios. Ijkuakón ompa okintitlankej in Pedro iwan Juan. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nijkuak ompa oajsitoj, omotiotzajtzilijkej por yen yankuikej tlaneltokakej de Samaria, para ma kiresibirokan noijki in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porke ayamo okipiayaj ipan inyolo in Espíritu Santo, porke san ok omokuateekijkej ika itoka in toSeñor Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ijkuakón Pedro iwan Juan okintlalijkej inmawan inpan yonmej tokniwan, iwan ijkuakón okiresibirojkej in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","In Simón texoxke okinmitak in tlatitlaniltin okintlaliayaj inmawan inpan tlaneltokakej iwan okiresibiroayaj in Espíritu Santo. Iwan ijkuakón yej okinmijijtolij tomin in tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Okinmilwij: ―Xinechmakakan nej noijki yon poder, para nijkuak nej nikintlalis nomawan ipan akaj tlakatl, ma kiresibiro noijki in Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pedro okinankilij: ―¡Motomin mowan ma pojpoliwi! Tej tikyejyekoa ke tlan Dios techmaka weli mokowa ika tomin. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tej mach itlaj tikpia towan iwan nion mach mitztokaroa tikpias itlaj itech yin tekitl, porke moyolo mach kajki chipawak inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ximoyolpejpena (ximoyolkuepa) de yin tlajtlakole tlan tikchiwa, iwan xiknotza in Dios, iwan xamo ijkón mitztlapojpolwis de tlan tikyejyekoa ipan moyolo. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Porke nikita sa tekitl tichichikatentok iwan motlajtlakol mitztakatzojtok. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Tonses in Simón okinmilwij: ―Xitiotzajtzikan por nej, para amitlaj ma nipano de tlan ya annechilwijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Satepan de otlapojkej iwan de okitematiltijkej itlajtol in Dios, in tlatitlaniltin omokuepkej para Jerusalén. Iwan itech miekej pueblojtin itech estado de Samaria kanik opanotiayaj, ompa okitematiltijtiajkej noijki in kuale tlajtole katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Satepan se iángel in Señor okilwij in Felipe: ―Ximoketza iwan xiwia ik tlani. Xiwia ipan ojtle katlej yawi de Jerusalén para Gaza. Yon ojtle panotok kan tlawaki. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe omoketzke iwan oyáj. Iwan ipan ojtle okajsito se tlakatl de país de Etiopía. Yon tlakatl eunuco oyeka weyi tekiwaj tesorero de se reina itoka Candace, reina de Etiopía. Yon tlakatl owalaya de Jerusalén kan okiweyikixtito in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Yoyaya para ichan ewatotiw ipan ikarreta, iwan okilerojtiaya itlajkuilol in profeta Isaías. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","In Espíritu Santo okilwij in Felipe: ―Xiwia xikajsiti nekáj karreta. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Nijkuak in Felipe okajsito, okikakke in tlakatl etiope kilerojtiw itlajkuilol in profeta Isaías, iwan okitlajtlanij: ―¿Kox tikmomaka kuenta tlan tiklerojtiw? ");
INSERT INTO nhyNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","In etiope okinnankilij: ―¿Kenik nikmomakas kuenta? Mach onkaj akin nechtomilis. In etiope okitlatlawtij in Felipe ma tlejko iwan ma motlali inakastlan. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tlan okilerojtiaya in etiope, ijkín kijta: Okiwikakej kej se ichka kan tlamiktiaj. Iwan kej se ichkatzin mach tzajtzi nijkuak kiximaj, no ijkón Yej mach itlaj okijtoj nijkuak okimiktijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Okimawispolojkej, okitlajtlakoltijkej iwan okimiktijkej maski mach itlaj okichij. ¿Kenik welis se tlajtos de ipilwan? Tla antes de kinpiani yej okikixtilijkej inemilis. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","In tekiwaj etiope okitlajtlanij in Felipe: ―Nimitztlatlawtia xinechilwi, ¿de akin tlapoa in profeta, tlapoa de yej o noso de akaj oksé? ");
INSERT INTO nhyNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Tonses in Felipe, opéj kitlapowia de yen itlajkuilol Isaías kan etiope okilerojtiaya, iwan okitlapowij de yen kuale tlajtole katlej temakixtia de Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Okachi tlayakapan, oajsitoj se lado kan oyeka atl, iwan tlakatl etiope okijtoj: ―Nian onkaj atl, ¿amo welis tinechkuateekis? ");
INSERT INTO nhyNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe okilwij: ―Tla ika nochi moyolo tikneltoka in Cristo, tonses welis. In tlakatl etiope okilwij: ―Nikneltoka nik in Jesucristo yen iKone in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","In tlakatl etiope okilwij itekipanoj ma kiketzalti ikarreta, iwan san ken omen otemokej ijtik atl, iwan Felipe okikuateekij in etiope. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nijkuak okiskej de ijtik atl, iEspíritu in toSeñor okiwikak in Felipe, iwan tekiwaj etiope mach ok okitak, iwan oyáj ipan iojwi ika pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pero in Felipe oneske asta itech weyikan de Azoto, iwan de ompa oyáj otetlapowijtiaj de yen kuale tlajtole katlej temakixtia itech pueblojtin kanik yej opanotiaya asta oajsito itech weyikan de Cesarea. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","In Saulo, ok okualantinemia iwan okintemojtinemia in momachtijkej tlaneltokakej de toSeñor, para kinmiktis. Por yonik, oyáj okitato in weyi tiopixke, ");
INSERT INTO nhyNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","iwan okitlajtlanilij se amatlanawatile para kiteititis itech tiopanmej de yen judiojtin katlej katej itech weyikan de Damasco, kan kijtojtiw ma kikawilikan ma kinkitzki san akin kajsis, okichtin iwan siwamej katlej nemij itech iojwi in Jesús, para kinwalinwikas kintzakuaki Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Iwan nijkuak yoyaya ipan ojtle iwan yoajsitiaya itech weyikan de Damasco, ijkuakón owalaj ipan Saulo se tlawile de ilwikak teixmijmiktij. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ijkuakón Saulo owetzito ipan tlale, iwan okikakke se tlajtole, okilwij: ―Saulo, Saulo, ¿tlanik wel tinechtemojtinemi iwan tikneki tinechkojkokos? ");
INSERT INTO nhyNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo otlanankilij: ―¿Akin tej, tejwatzin? In tlajtole okinankilij: ―Nej niJesús, katlej tej tiktemojtinemi. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Axan, ximoketza iwan xiwia itech weyikan, ompa mitzilwiskej tlan tikchiwas. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","In tlakaj katlej oyayaj iwan Saulo, omomawtijkej iwan omokajkej sa tlakaktokej, porke okikakej ke akaj otlajtoaya pero mach akaj okitakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Satepan Saulo omoketzke de ipan tlale, pero nijkuak okintlapoj ixtololowan, mach ok owelik otlachixke. Sa okimatilankej iwan okiwikakej para itech weyikan de Damasco. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ompa oyeka eyi tonale, mach ok otlachiaya, mach ok otlakuaya iwan nion mach ok itlaj okonia. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ompa Damasco ochantia se tlakatl momachtij tlaneltokak itoka Ananías, katlej in toSeñor okimonextilij kej yeskia teemiktok. Okilwij: ―¡Ananías! Yej otlanankilij: ―Nian nikaj, Señor. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","In Señor okilwij: ―Ximoketza iwan xiwia itech ojtle katlej itoka Melaktik, iwan xitlajtlani kan ichan Judas, iwan ompa xitlajtlani kox ompa kajki se tlakatl de Tarso itoka Saulo, yej ompa motiotzajtzilijtok. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Iwan maski amo tlachia, yej omitzitak kej yeskia okitemikke, kan tej Ananías tikalaki kalijtik iwan tikintlalia momawan ipan para ma tlachia oksemi. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ijkuakón Ananías okijtoj: ―Señor, miekej yonechtlapowijkej de yon tlakatl Saulo, iwan de nochi tlan yokintoktij in yolchipawakej de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iwan axan yowalaj nian, kiwalkui se amatlanawatile de yen tlayekankej tiopixkej para kinkitzkis iwan kinwikas nochtin katlej kitenewaj motoka. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero in Señor okilwij: ―Xiwia, porke yonikpejpenke yon tlakatl Saulo, para ma kintlapowi de Nej in tlakaj katlej mach judiojtin, iwan noijki para ma kintlapowi in reytin iwan tlakaj de Israel. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nej nikititis kenik tlajyowis por Nej. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías oyáj ichan Judas kan oyeka in Saulo. Okalakke iwan okintlalij imawan ipan Saulo, iwan okilwij: ―Nokni Saulo, in Señor Jesús, katlej omitzmonextilij ipan ojtle kan otiwalaya, onechwaltitlanke para xitlachia oksemi iwan para xitemi de Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","San niman otepewik de itech ixtololowan in Saulo sekin kej tlatlapachtle (kakapachtli), iwan otlachixke oksemi. Satepan omoketzke iwan omokuateekij. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Satepan otlakuaj iwan okitzkij chikawalistle oksemi, iwan omokaj kanaj keski tonale inwan tlaneltokakej de Damasco. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","San niman Saulo opéj tetlapowia itech tiopanmej de yen judiojtin nik Jesús yen iKone in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nochtin katlej okikakiaj sa otlajtlachiayaj (omomajmawtiayaj), iwan okijtoayaj: ―¿Amo yen yin tlakatl katlej okintemoaya ne Jerusalén akinmej kitenewaj itoka in Jesús? ¿Amo yen yin noijki katlej owalaj nian para kinkitzkis in tlaneltokakej iwan kintemaktis (kintemaktilis) inmak in tlayekankej tiopixkej? ");
INSERT INTO nhyNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero in Saulo otlajtoaya ika ixchikawalistle. Okinkamatzakke in judiojtin katlej ochantiaj Damasco. Iwan ika itlajtol in Dios okinmititiaya nik in Jesús yen Cristo katlej Dios okipejpenke para techmakixtis. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Opanok kanaj keski tonale, in judiojtin omotlatlalwijkej para kimiktiskej in Saulo, ");
INSERT INTO nhyNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","pero yej san niman okimatke. Tonayan iwan yuak okixpiayaj itech puerta de yon weyikan para kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero imomachtijkawan in Saulo, okikalakijkej ijtik se chikiwitl iwan okitemowijkej de yuak itech tepamitl katlej kiyawalojtok in weyikan. Iwan ijkón nik ocholoj. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nijkuak in Saulo oajsito Jerusalén, okinekia mosetilis inwan in momachtijkej tlaneltokakej. Pero nochtin okimakasiaj, porke mach okineltokayaj nik in yej noijki yomokuepke momachtij tlaneltokak. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero in Bernabé okiwikak in Saulo okinmixpantilito in tlatitlaniltin. Okinmakak kuenta kenik okitak iwan kenik okitlapowij in Señor ipan ojtle nijkuak oyaya para itech weyikan de Damasco, iwan kenik otetlapowij de Jesús ika ixchikawalistle ompa Damasco. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ijkón, Saulo omokaj ompa Jerusalén iwan onemia inwan tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Otetlapowiaya de toSeñor ika ixchikawalistle. Otetlapowiaya iwan omotlajtolkuekuepaya inwan judiojtin katlej otlapoayaj griego. Pero yejwan okitemoaya kenik kimiktiskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nijkuak in tokniwan tlaneltokakej okimatkej, okiwikakej in Saulo para itech weyikan de Cesarea, iwan de ompa okititlankej para itech weyikan de Tarso. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Itech yonmej tonaltin in tiopantlaneltokakej de regionmej de Judea, de Galilea iwan de Samaria, oyolosewtinemiaj iwan okajsiaj chikawalistle itech intlaneltokalis iwan opéj nemij ken toSeñor kineki. In Espíritu Santo okinyolojchikawaya iwan omomiekiliayaj okachi. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nijkuak in Pedro okintlajpalojtinemia nochtin in yolchipawakej, noijki oyáj okintlapowito in yolchipawakej katlej ochantiaj Lida. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa okajsito se tlakatl wilan (temetlatzin) itoka Eneas, katlej yokiwikaya chikueyi xiwitl wetok ipan itlapech. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ijkuakón Pedro okilwij: ―Eneas, Jesucristo mitzpajtia, ximewa iwan xikajkokui mopetl. Eneas san niman owalmejtewak. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iwan nochtin katlej ochantiaj itech weyikan de Lida iwan itech weyikan de Sarón okitakej kenik opajtik in Eneas iwan okineltokakej itlajtol in toSeñor Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Itech nekatej tonaltin oyeka itech weyikan de Jope, se siwatl momachtij tlaneltokak itoka ika arameo Tabita, ika griego Dorcas kijtosneki masatl. Yej oyeka sa tekitl kuale tlakatl iwan okinpalewiaya katlej mach itlaj okipiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Itech nekatej tonaltin, Dorcas omokokoj iwan omikke. Satepan de okipakej itlalnakayo, okimelajkej ajkopan ijtik se kuarto. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","In weyikan de Jope iwan weyikan de Lida mach wejka omotokaj, Pedro omajsia Lida iwan komo in momachtijkej tlaneltokakej okimatkej nik in yej ompa majsi, okintitlankej omen tlakaj ma kilwitij: ―San nimantzin xiwiki nian Jope. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pedro okinwikak. Nijkuak oajsito ompa, okiwikakej ajkopan ijtik kuarto kan melatok in mikkatl, iwan nochtin in viudajtin okiyawalojkej in Pedro chokatokej, iwan okinmititijkej in kuemej iwan ichkapayojtin tlan Dorcas okinchiwilij nijkuak ok oyolitoka. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro okinkixtij nochtin. Omotlankuaketzke iwan omotiotzajtzilij. Satepan omokuepke para kanik kajki in mikkatl, iwan okilwij: ―¡Tabita, ximewa! Ijkuakón Tabita okintlapoj ixtololowan. Nijkuak okitak in Pedro, omotlalij. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pedro okimakitzkij in Dorcas iwan okiketzaltij. Satepan okinnotzke in tokniwan yolchipawakej iwan viudajtin, iwan okinmixpantilij yolitok. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Yon tlan otlapanok omomatke itech nochi in weyikan de Jope, iwan miekej okineltokakej in toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro omokaj miek tonale ompa Jope. Omokaj ichan Simón katlej kitekipanoa kuetlaxtle. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Itech weyikan de Cesarea oyeka se tlakatl itoka Cornelio. Yej oyeka kapitan de se siento soldadojtin, iwan yon grupo de soldadojtin okitokayotiayaj Italiano. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio iwan nochi ifamilia sa tekitl omotemaktiayaj inawak Dios. Yej okitemakaya miek tomin para okinpalewiaya in judiojtin katlej mach itlaj okipiayaj, iwan nochipa omotiotzajtziliaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Se tonale, kej las tres de tiotlakke Cornelio okitak kej yeskia se teemiktle, okitak se ángel de Dios katlej okalakke ikalijtik kan yej oyeka iwan okilwij: ―¡Cornelio! ");
INSERT INTO nhyNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelio okimelajkatlatak in ángel ika miek nemawtile iwan okinankilij: ―¿Tlanon tikneki, Señor? In ángel okilwij: ―Dios ya mitzkaktiwitz nijkuak timotiotzajtzilia iwan nochi tlan tikchijtiwitz para tikinpalewia katlej mach itlaj kipiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Xikintitlani sekimej tlakaj itech weyikan de Jope para ma kinotzatij in Simón, katlej noijki kinotzaj Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Kalotitok ichan oksé tlakatl katlej noijki itoka Simón, katlej kitekipanoa kuetlaxtle, iwan chanti itempan atl. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nijkuak in ángel oyáj, Cornelio okinnotzke omen itekipanojkawan iwan se soldado katlej sa tekitl omotemaktiaya inawak Dios katlej okipalewiaya in Cornelio. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Okintlapowij de nochi tlan okitak, iwan satepan okintitlanke para Jope. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Owalmostlatik, kej tlajko tonale, nijkuak yejwan oyayaj ipan ojtle iwan yoajsitiayaj Jope, ijkuakón Pedro otlejkok omotiotzajtzilito ikpak kale kan okalotitoka. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sa tekitl otiojsijtoka iwan okinekia tlakuas, iwan mientras okichiwilijtokaj tlan kikuas, Dios okititij kej yeskia se teemiktle, ");
INSERT INTO nhyNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","okitak in ilwikak otlapowik iwan owaltemoaya ipan tlale kej se weyi manta oilpitiwalaya nawkan lado. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Itech yon manta oyekaj miekej yolkamej de nawi inmikxiwan, noijki katlej motilanaj ipan tlale iwan katlej patlanij. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ijkuakón Pedro okikakke se tlajtole, okilwij: ―Ximoketza Pedro, xitlamikti iwan xitlakua. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pedro otlanankilij: ―¡Amo, Señor! Nej mach semi nikua itlaj yolkatl katlej mach chipawak o noso mach kuale para mokuas, katlej itlanawatil in Moisés mach techkawilia ma tikkuakan. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","In tlajtole oksemi okilwij: ―Amo xikijto mach chipawak tlan Dios yokichipaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ijkón otlapanok eyi buelta, iwan satepan in manta oksemi otlejkok ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nijkuak in Pedro ok otlanemilijtoka tlan kijtosneki tlan okitak, ijkuakón oajsikoj kaltempan itekipanojkawan in Cornelio, katlej tlajtlantiwitzej kan ichan in Simón. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nijkuak oajsikoj otlajtlankej chikawak kox ompa kalotitok se tlakatl itoka Simón, katlej noijki kinotzaj Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nijkuak in Pedro ok otlanemilijtoka tlan kijtosneki tlan okitak, in Espíritu Santo okilwij: ―Xikkaki, mitztemoaj eyin tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ximoketza, xitemo iwan xikinwika iwan amo xikmolwi kox tias o noso amo porke Nej onikinwalintitlanke. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pedro otemok iwan okinmilwij itekipanojkawan in Cornelio: ―Yen nej katlej namejwan ankitemoaj. ¿Tlan nankinekiaj? ");
INSERT INTO nhyNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yejwan okinankilijkej: ―Otechwaltitlanke in kapitan Cornelio, yej sa tekitl kuale tlakatl iwan motemaktia inawak Dios, iwan nochtin in judiojtin kuale tlajtoaj de yej. Se ángel de toTajtzin Dios okilwij ma mitzwaltekuitlani para xiwia ichan Cornelio, para ma kikaki tlan tejwatzin tikilwis. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ijkuakón Pedro okinmilwij ma kalakikan, iwan yon yuak ompa omokajkej. Owalmostlatik in Pedro okinwikak. Noijki oyajkej inwan oksekimej tokniwan tlaneltokakej de Jope. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Owalwiptlatik oajsitoj Cesarea kan Cornelio okinchixtoka. Noijki ompa oyekaj ifamiliareswan iwan sekimej tlakaj katlej kuale inwan omoyekwikaya, katlej okinnotzke para ma kixmatikan in Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nijkuak in Pedro oajsito kaltempan, Cornelio okiske okinamikito, iwan omotlankuaketzke ikxitlan para kiweyikixtis. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Tonses in Pedro okiketzaltij, iwan okilwij: ―Ximoketza, nej noijki nitlakatl ken tej. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iwan okalakej motlapowijtiwej, okinmitajsik in Pedro miekej tlakaj ololitokej. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ijkuakón Pedro okinmilwij: ―Namejwan ankimatij ke itlanawatil in Moisés mach kitekawilia ma monelo se judío iwan se katlej mach judío. Pero Dios onechititij ke nion se tlakatl mach ma nikita kej mach kuale o noso mach chipawak inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Por yonik, san niman nijkuak annechtekuitlankej, oniwalaj iwan mach itlaj onikijtoj. Nikneki nikmatis kiné, por tlanik annechnotzatoj. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio okinankilij: ―Ya kipia nawi tonale, kej de yin ora de las tres de tiotlakke, nej nian onieka nochan onimotiotzajtzilijtoka, iwan ijkuakón onechmonextilij se tlakatl tlakenpetlantok. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iwan onechilwij: “Cornelio, Dios yokikakke motiotzajtzilis iwan okelnamikke tlan tikchiwa para tikinpalewia katlej mach itlaj kipiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xiktekuitlani itech weyikan de Jope, ma kinotzatij in Simón katlej noijki kinotzaj Pedro, kalotitok ichan oksé Simón, katlej kitekipanoa kuetlaxtle iwan chanti itempan atl.” ");
INSERT INTO nhyNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Por yonik san niman onimitztekuitlanke, iwan niktlasojkamati por otiwalaj. Axan nian tikatej tinochtin ixpan Dios, iwan tiknekij tikkakiskej nochi tlan toSeñor omitzilwij xiwiki xitechilwiki. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ijkuakón Pedro opéj kintlapowia, okijtoj: ―Axan nikmomaka kuenta ipan melajka nik in Dios mach kintlasojtla san sekimej iwan oksekimej amo, ");
INSERT INTO nhyNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","sino itech nochi in tlaltikpak in Dios kinneki akinmej kitlakitaj iwan kichiwaj tlan kuale. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios otechmakak itlajtol tejwan tijudiojtin, otechmatiltij in tlajtole de yolosewilistle itech yen toSeñor Jesucristo, yen Señor de tinochtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Namejwan kuale ankimatij tlan otlapanok itech nochi in tlale de Judea. Opejke itech estado de Galilea, satepan de ijkuak otetlapowij iwan otlakuateekij in Juan. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Namejwan ankimatij nik in Dios okititlanke in Espíritu Santo itech Jesús de Nazaret para okipixke poder. Iwan ankimatij nik in Jesús okichiwaya tlan kuale. Okinpajtij nochtin akinmej okintlajyowiltiaya in diablo. Jesús okichij nochi yon porke Dios okipalewiaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tejwan kuale tikmatij porke otikitakej nochi tlan okichiwaya in Jesús, itech región de Judea iwan itech weyikan de Jerusalén. Satepan okimajmasoltijkej itech se krus iwan okimiktijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero Dios okiyolitij ipan eyi tonale, iwan okichij ma techmotiti. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mach okinmotitij nochtin, sino san tejwan katlej Dios achtoj otechpejpenke para satepan ma tiktematiltikan tlan otikitakej. Nijkuak omikke iwan oksemi omoyolkuik, tejwan otitlakuajkej iwan otikonikej Iwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iwan Yej otechtitlanke ma titetlapowikan iwan ma tikinmatiltikan in tlakaj, nik yen Dios okitlalij in Jesús kej jues para techixkomakas (techtzonmanas) tinochtin katlej tiyolitokej iwan noijki katlej yomikkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ya wejkawitl nochtin in profetajtin otlajtojkej de Yej. Okijtojkej nik nochtin akinmej kineltokaskej in toSeñor Jesús ika itoka, Dios kintlapojpolwis de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pedro ok otlapojtoka iwan ijkuakón in Espíritu Santo owalaj intech nochtin akinmej okikaktokaj itlajtol. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iwan in tlaneltokakej judiojtin katlej okiwalwikakej in Pedro, sa otlajtlachixkej (omomajmawtijkej) porke Dios okinnokilij iEspíritu Santo noijki katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Porke okinkakiaj otlapoayaj iwan okiweyikixtiayaj in Dios ika oksekimej tlajtoltin. Yonmej tlajtoltin mach semi okinkakiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ijkuakón Pedro okijtoj: ―¿Amo welis mokuateekiskej noijki in yinmej tlakaj katlej yokiresibirojkej in Espíritu Santo noijki ken tejwan? ");
INSERT INTO nhyNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iwan otlanawatij ma mokuateekikan ika itoka in toSeñor Jesucristo. Satepan okitlatlawtijkej in Pedro ma mokawa ompa inwan kanaj keski tonale. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","In tlatitlaniltin iwan tokniwan tlaneltokakej katlej oyekaj Judea, okimatkej ke noijki katlej mach judiojtin okikakej iwan okineltokakej itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Iwan nijkuak in Pedro omokuepke para Jerusalén, sekimej tlaneltokakej judiojtin katlej yotlaneltokakej inawak Jesús okajwakej in Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Okilwijkej: ―¿Tlanik otiwia otikinmitato katlej mach judiojtin iwan otitlakuatoj inwan? ");
INSERT INTO nhyNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pedro opéj kinmaka kuenta de nochi tlan otlamochij iwan okinmilwij: ");
INSERT INTO nhyNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Nijkuak nej onieka itech weyikan de Jope, iwan nijkuak onimotiotzajtzilijtoka, onikitak kej yeskia onikteemikke, onikitak se manta patlawak ilpitok nawkan lado, iwan owaltemoaya de ilwikak asta kan nej onieka. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Onikonyekitak para nikitas tlanon okipiaya ik tlijtik, iwan onikinmitak sekimej yolkamej de nawi inmikxiwan, sekimej yolkamej tekuanimej, sekimej katlej motilanaj ipan tlale iwan sekimej katlej patlanij. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iwan onikakke se tlajtole onechilwij: “Ximoketza Pedro, xitlamikti iwan xitlakua.” ");
INSERT INTO nhyNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero nej onitlanankilij: “Amo, Señor. Nej mach semi nikua itlaj yolkatl katlej mach chipawak o noso mach kuale para mokuas, tlan itlanawatil in Moisés mach techkawilia ma tikkuakan.” ");
INSERT INTO nhyNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ijkuakón in tlajtole de ilwikak oksemi onechilwij: “Amo xikijto mach chipawak tlan Dios yokichipaj.” ");
INSERT INTO nhyNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ijkón otlapanok eyi buelta, iwan san niman nochi oksemi otlejkok ik ilwikak. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Niman ijkuakón, eyin tlakaj de Cesarea oajsitoj kan onikalotitoka onechtemojtiayaj porke se tlakatl de Cesarea okintitlanke ma nechtemotij. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","In Espíritu Santo onechnawatij ma niwia inwan iwan mach ma nikmolwi kox nias o noso amo. Noijki oyajkej nowan yinmej chikuasemej tokniwan. Nijkuak otajsitoj Cesarea, tinochtin otikalakej ichan se tlakatl itoka Cornelio, ");
INSERT INTO nhyNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","yej otechtlapowij kenik okitak se ángel omoketoka ikalijtik iwan okilwij: “Xikintitlani sekimej tlakaj itech weyikan de Jope para ma kinotzatij in Simón, katlej noijki kinotzaj Pedro, ");
INSERT INTO nhyNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","iwan yej amechilwis kenik welis anmomakixtiskej de amotlajtlakol, tej iwan nochtin katlej katej mochan.” ");
INSERT INTO nhyNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nijkuak opéj nikintlapowia, in Espíritu Santo owalaj intech yonmej tokniwan ijkón ken tejwan totech owalaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ijkuakón onikelnamikke de tlan okijtoj in toSeñor: “Ipan melajka, in Juan otlakuateekij ika atl, pero namejwan anmokuateekiskej ika Espíritu Santo.” ");
INSERT INTO nhyNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Iwan axan, tla Dios kinmaka yejwan noijki in Espíritu Santo, katlej tejwan noijki otechmakak nijkuak otikneltokakej in toSeñor Jesucristo, ¿akin nej para ma nikilwi in Dios mach ijkón ma kichiwa? ");
INSERT INTO nhyNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nijkuak in tlaneltokakej de Jerusalén okikakej in yon tlajtole, mach ok itlaj okijtojkej iwan okiweyikixtijkej in toTajtzin Dios, iwan okijtojkej: ―¡Axan tikmomakaj kuenta ke noijki katlej mach judiojtin, Dios kinkawilia ma moyolpejpenakan (ma moyolkuepakan) de intlajtlakol para ijkón welis kipiaskej nemilistle katlej mach keman tlamis! ");
INSERT INTO nhyNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Nijkuak okimiktijkej in Esteban, opéj noijki kintlatlalochtiaj in oksekimej tlaneltokakej. Sekimej ocholojkej oyajkej itech país de Fenicia, itech país de Chipre iwan itech weyikan de Antioquía. Itech yonmej lugartin okitematiltijkej in kuale tlajtole katlej temakixtia, pero okinmatiltijkej san yen judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pero sekimej tlaneltokakej de Chipre iwan de Cirene oajsikoj itech weyikan de Antioquía, iwan yejwan noijki okintlapowijkej katlej mach judiojtin, okinmatiltiayaj in kuale tlajtole katlej temakixtia de toSeñor Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ToSeñor okinmakak poder para otetlapowijkej, iwan miekej okikajkej tlan achtoj okineltokayaj, iwan okineltokakej in toSeñor Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Nijkuak in tiopantlaneltokakej de Jerusalén okimatkej tlan tlapanotok ne Antioquía, ijkuakón okititlankej in Bernabé ma wia ompa. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nijkuak in Bernabé oajsito ompa Antioquía, okitajsik kenik in Dios okintiochiwaya, iwan sa tekitl opakke. Okinyolojchikaj nochtin, okinmilwij ika nochi inyolo ma moyekketokan inawak toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé oyeka kuale tlakatl, tentok de Espíritu Santo iwan tentok de tlaneltokalistle. Iwan ijkón sa tekitl miekej omosetilijkej okachi inawak toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Satepan, Bernabé oyáj itech weyikan de Tarso okitemoto in Saulo. Nijkuak okajsik, okiwikak para itech weyikan de Antioquía. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ompa omokajkej inwan tiopantlaneltokakej se xiwitl. Okinmachtijkej miekej tlakaj. Ompa Antioquía yakinika in momachtijkej tlaneltokakej opéj kintokayotiaj kristianostin. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Itech nekatej tonaltin, sekimej profetajtin oyajkej de Jerusalén asta Antioquía. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Se de yejwan itoka Agabo, omoketzke iwan okitematiltij ika Espíritu Santo nik yetos miek apistle itech nochi in tlaltikpak. Iwan ijkón otlapanok itech nekatej tonaltin nijkuak in Claudio oyeka weyi tlanawatij de Roma. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ijkuakón in momachtijkej tlaneltokakej de Antioquía, okimolwijkej kinpalewiskej ika san tlan yejwan weliskej kitemakaskej, para kintitlaniliskej inmikniwan tlaneltokakej katlej chantij itech estado de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iwan ijkón okichijkej. Tlan okololojkej Antioquía, okitkikej in Bernabé iwan Pablo, iwan yejwan okinmitkilijkej in tiopantlayekankej de estado de Judea. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Noijki itech nekatej tonaltin, in rey Herodes opéj kintlatlalochtia sekimej tiopantlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Okimiktij in Jacobo ikni in Juan ika espada, ");
INSERT INTO nhyNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","komo okitak okinpaktij in judiojtin, tonses noijki otlanawatij ma kikitzkikan in Pedro. Yon otlapanok meroj itech ilwitl nijkuak mokua in pan katlej mach kipia levadura. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nijkuak Herodes okitzkij in Pedro, okitzakke telpiloyan. Okintlalij nawi grupojtin de nanawin soldadojtin para ma kitlatokan. Herodes okimolwij kinmixpantilis in tlakaj san ma pano in ilwitl de pascua. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ijkón in soldadojtin kuale okitlatokaj in Pedro itech telpiloyan. Pero in tiopantlaneltokakej mach ok omosewiayaj de omotiotzajtziliayaj inawak Dios por yen Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Yon yuak antes de tlanesis para Herodes kinmixpantilis in tlakaj, in Pedro okochtoka ilpitok ika ome kadenajtin iwan okitlatokaj omen soldadojtin ik inajnakastlan, iwan oksekimej soldadojtin oyekaj kaltempan ompa telpiloyan. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ijkuakón owalmonextij se iángel in Señor iwan owaltlapetlanke ompa ijtik telpiloyan. In ángel okitilkoj in Pedro ik ikestlan, okijxitij iwan okilwij: ―¡Ximewa totoka! San niman in kadenajtin owetzkej de itech imawan Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","In ángel okilwij: ―Ximotzotzolti iwan ximokakti. Nijkuak in Pedro omotzotzoltij iwan omokaktij, in ángel oksemi okilwij: ―Xikonaki mokoton iwan tiawij. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro oyáj iwan ángel. Mach okimatia kox melawak tlan okichijtoka in ángel. Okimolwiaya xamo san kiteemiktok. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Okipanawijkej se grupo de soldadojtin iwan okipanawijkej oksé grupo, iwan nijkuak oajsitoj kan sajwan de tepostle katlej kajki itempan ojtle, in sajwan omotlapoj iselti. In ángel iwan Pedro okiskej, iwan satepan de okipanawijkej se ojtle, in ángel okikajtej sa iselti in Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ijkuakón Pedro okimomakak kuenta, iwan okijtoj: ―Axan ipan melajka nikmomaka kuenta nik in Señor okualtitlanke iángel para nechmakixtis de imak Herodes, iwan de tlan okinekiaj nechtoktianij in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nijkuak okimomakak kuenta nik melawak okiske de ijtik telpiloyan, Pedro oyáj ichan María, imaman in Juan akin noijki kinotzaj Marcos, kan miekej oololitokaj omotiotzajtzilijtokaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nijkuak in Pedro otlatatalatzke kan puerta de itempan ojtle, se ichpochtle itoka Rode oyáj otlachiato akin tlatatalatza. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nijkuak okitenkakke nik yen Pedro, sa tekitl opakke iwan mach okitlatlapolij, yej omotlaloj ik kalijtik okinmilwito nik in Pedro kajki kan puerta. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ijkuakón okilwijkej in Rode: ―¡Tej tikuatlapoloa! Pero yej okinmilwij nik melawak. Iwan yejwan okijtojkej: ―Mach yej, xamo san iángel. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pedro ok otlatatalatoka kan sajwan. Iwan nijkuak otlatlapojkej, okitakej iwan sa otlajtlachixkej (omomajmawtijkej). ");
INSERT INTO nhyNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero yej okinchiwilij señas ika ima de ma mokamatzakuakan, iwan okintlapowij de kenik in Señor okikixtij de kan otzaktoka. Iwan okinmilwij: ―Xiktlapowikan in Jacobo iwan tokniwan tlaneltokakej de tlan onipanok. Satepan okiske de ompa iwan oyáj oksé lado. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nijkuak otlaneske, in soldadojtin sa tekitl opéj motlatlaloaj iwan mach ok okimatiaj tlan kichiwaskej porke mach okimatiaj tlan opanok in Pedro. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes otlanawatij ma kitemokan kuale in Pedro pero mach okajsikej. Ijkuakón okintlatzintokij in soldadojtin iwan komo mach owelik okimakakej itlaj rason, otlanawatij ma kinmiktikan. Satepan, Herodes okiske de estado de Judea iwan oyáj ochantito itech weyikan de Cesarea. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","In rey Herodes okualantoka innawak in tlakaj de weyikan de Tiro iwan de Sidón katlej de oksé país, pero yonmej tlakaj omotlalijkej san se tlajtole iwan oyajkej okitatoj in Herodes asta Cesarea. Se tlakatl itoka Blasto, tekiwaj de yen rey Herodes, okimoamigojtijkej iwan okitlatlawtijkej yen ma kitlapowi in Herodes para ma kintlapojpolwi iwan mach ok ma kualani, porke in tlakaj de Tiro iwan tlakaj de Sidón okonkuiaj tlan kikuaskej itech ipaís in rey. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodes okitlalij se tonale para inwan motlapowis in tlakaj de Tiro iwan de Sidón. Iwan nijkuak oajsiko yon tonale, Herodes omotzotzoltij ika katlej okachi kuale itzotzol katlej konakiaj in reytin, omotlalij itech isiya de rey, iwan ijkuakón okintlapowij. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ijkuakón in tlakaj opéj tzajtzij chikawak: ―¡Yin katlej techtlapowijtok, techtlapowijtok se dios mach se tlakatl! ");
INSERT INTO nhyNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","San niman ijkuakón, iángel in Señor okichij in Herodes ma mokokojtiwetzi, porke mach okiweyikixtij in Dios, ochakaloak iwan omikke. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Itlajtol in Dios omotematiltiaya iwan oxoyawia (oxitinia) okachi ik nian nepa. ");
INSERT INTO nhyNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nijkuak in Bernabé iwan Saulo yokitlamijkej intekiw ne Jerusalén, omokuepkej para Antioquía. Okiwikakej in Juan katlej noijki kinotzaj Marcos. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kan oyekaj in tiopantlaneltokakej de Antioquía, oyekaj sekimej profetajtin iwan sekimej tlamachtijkej. Ompa oyeka: Bernabé, Simón katlej okitokayotiayaj Tliltik, Lucio de Cirene, Saulo iwan Manaén katlej iwan omoskaltij in Herodes tetrarca, katlej otlanawatiaya Galilea. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Se tonale, nijkuak omosawtokaj (oayunarojtokaj) iwan okichijtokaj kulto, in Espíritu Santo okijtoj: ―Xikinxelokan in Bernabé iwan Saulo para ma kichiwakan in tekitl katlej yonikinpejpenilij. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Satepan de omosawkej iwan okichijkej kulto, okintlalijkej inmawan inpan iwan okinmakajkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Satepan in Espíritu Santo okintitlanke in Bernabé iwan Saulo para itech pueblo de Seleucia, iwan de ompa otlejkokej itech se barko iwan oyajkej itech tlale katlej pankistok itech atl itoka Chipre. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nijkuak oajsitoj itech weyikan de Salamina katlej kajki itempan atl. Ompa opéj tetlapowiaj de itlajtol in toTajtzin Dios itech intiopanwan in judiojtin. Bernabé iwan Saulo okiwikakej in Juan Marcos para ma kinpalewi. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Onenkej itech nochi in tlale katlej pankistok itech atl itoka Chipre iwan oajsitoj asta kan pueblo de Pafos, ompa okajsitoj se texoxke (brujo) judío itoka Barjesús, katlej otlakajkayawaya okijtoaya nik in yej profeta de Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Yon texoxke omowikaya iwan gobernador Sergio Paulo, in gobernador oyeka tlalnamikilisej. Okintekuitlanke in Bernabé iwan Saulo, porke okinekia kikakis itlajtol in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero Barjesús katlej noijki itoka Elimas kijtosneki texoxke, omotlayakapankaketzke innawak in Bernabé iwan Saulo, porke mach okinekia in gobernador ma kineltoka itlajtol in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ijkuakón in Saulo katlej noijki kinotzaj Pablo, tentok de Espíritu Santo, okitlatak in texoxke ");
INSERT INTO nhyNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","iwan okilwij: ―¡Tekajkayaj! ¡Yolbiero! ¡Tekone de diablo! ¡Tikkokolia nochi tlan kuale! ¿Asta kemanian tikkawas de tikinkajkayajtinemis in tlakaj para amo ma kajsikan in melaktik ojtle de Dios? ");
INSERT INTO nhyNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Axan tiktlaxtlawas inawak in Señor, tiixkokoxkatis (tiixpachitis) iwan mach welis titlachias kanaj keski tonale. San niman ijkuakón Elimas owalixtlatleyuilij (owalixtlatlayowilij), iwan sa otlamatemoaya para akaj ma kimatilana porke mach ok otlachiaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nijkuak in gobernador okitak tlan otlapanok, okineltokak. Sa omotlajtlachialtij (omomajmawtij) de yen itlamachtil in toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo iwan itekitijkaikniwan otlejkokej itech barko okiskej de pueblo de Pafos iwan oyajkej para kan pueblo de Perge, itech región de Panfilia. Pero ompa in Juan Marcos okinkajtej iwan omokuepke para Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Satepan yejwan oyajkej de Perge asta Antioquía, katlej kajki itech región de Pisidia. Ompa nijkuak weyi tonale, okalakej itech se tiopan de yen judiojtin iwan ompa omotlalitoj. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Satepan de otlankej okilerojkej in libro de Moisés iwan tlan okijkuilojkej in profetajtin, in tlayekankej de yon tiopan okilwijkej se tlakatl katlej ompa oyeka ma koninmilwiti in Pablo iwan Bernabé, ijkín: ―Nokniwan, tla ankinekij ankijtoskej itlaj para ma moyolojchikawakan in tlakaj, xikijtokan. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ijkuakón Pablo omoketzke iwan okinchiwilij señas ika ima para mach ok ma tlapoakan. Okijtoj: ―Xikkakikan namejwan tlakaj de Israel, iwan namejwan katlej mach anjudiojtin katlej ankimakastokej in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","In Dios de topaís Israel okinpejpenke in ya wejkawitl toweyitajwan. Okinekke ma yekan sa tekitl miekej, iwan ijkón omochij nijkuak ok oyekaj itech nekáj país de Egipto. Satepan, Dios ika weyi ipoder, okinkixtij de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios okinxikoj de nochi tlan yejwan okichiwayaj kan tlawaki kej omenpoale xiwitl, ");
INSERT INTO nhyNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","iwan okinpojpoloj chikome regionmej itech país de Canaán, iwan yonmej tlalmej okinmakak in ya wejkawitl toweyitajwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Satepan, Dios okintlalilij juestin kej nawi siento iwan tlajko xiwitl asta itech nekatej tonaltin nijkuak in Samuel oyeka profeta. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","In ya wejkawitl toweyitajwan okitlajtlankej se rey para ma kinnawati, iwan Dios okinmakak in Saúl kej rey, iwan Saúl okinnawatij omenpoale xiwitl. Saúl oyeka ikone in Cis iwan oyeka familia de Benjamín. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Okachi satepan, Dios okipatlak in Saúl, iwan okitlalij in David kej rey, iwan Dios okijtoj: “Yonikitak in David ikone in Isaí, yej kuale tlakatl iwan sa tekitl nechyolpaktia, iwan yej kichiwas nochi tlan Nej niknekis.” ");
INSERT INTO nhyNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","’Jesús oyeka se de inelwayo in David iwan Dios okititlanke in Jesús para ma kinmakixti in tlakaj de Israel, ijkón ken Dios achtoj yokisentlalijka. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes de walani in Jesús, in Juan Tlakuateekij okintlapowij nochtin in tlakaj de Israel, okinmilwiaya ma moyolpejpenakan (ma moyolkuepakan) de intlajtlakol iwan ma mokuateekikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kanaj keski tonale antes de mikis in Juan, okijtoj: “Mach yen nej katlej namejwan ankiyejyekoaj. Mach yen nej niCristo katlej Dios okijtoj kiwaltitlanis. Pero satepan de nej witz in Cristo katlej nej mach notech powi nion para nikkaktotomas.” ");
INSERT INTO nhyNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Nokniwan, namejwan katlej antepilwan de Abraham, iwan namejwan katlej mach anjudiojtin katlej ankimakastokej in Dios, yin tlajtole katlej temakixtia yin para tinochtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Katlej chantij Jerusalén iwan tlayekankej de ompa, mach okimatiaj akin Jesús, nion mach okimomakayaj kuenta de intlajtol in profetajtin maski omoleroaya itech tiopanmej de yen judiojtin nochipa nijkuak weyi tonale. Nijkuak okimiktijkej in Jesús, mach okimomakakej kuenta nik okichijkej tlan ya wejkawitl okijtojkej in profetajtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Maski mach okajxilijkej nion itlaj tlajtlakole para ika ma kimiktikan, yejwan okitlajtlanilijkej in Pilato ma tlanawati ma kimiktikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ijkón okichijkej nochi tlan okijtoaya in tiotlajkuilole de tlan panoani in Jesús. Satepan okitemowijkej itlalnakayo de itech krus iwan okitookakej ijtik se mikkakuyoktle. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Pero Dios okiyolitij oksemi satepan de omikke. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Satepan de omoyolkuik in Jesús, okinmotitij miek buelta, katlej Iwan onemiaj desde estado de Galilea iwan asta weyikan de Jerusalén. Axan, yejwan katlej kitematiltiaj de Jesús para nochtin ma kimatikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Iwan axan tejwan tamechmatiltiaj yin kuale tlajtole katlej temakixtia, katlej Dios desde okachi achtoj okinkakitij in ya wejkawitl toweyitajwan de tlan kichiwani satepan. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tejwan komo titepilwan de ya wejkawitl toweyitajwan, Dios yokichij towan tlan achtoj okinmilwijka in ya wejkawitl toweyitajwan. Okichij nijkuak Dios okiyolitij in Jesús. Ijkón omochij ken kajki ijkuilitok ipan ome salmo: “Tej tinoKone, axan Nej onimitztlalij kej tinoKone.” ");
INSERT INTO nhyNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios yokijtojka nik kiyolitis oksemi de itech imikilis para mach ma ijtlakawi itlalnakayo, Dios ijkín okijtoj iwan kajki ijkuilitok: “Namejwan namechmakas nochi in tlatiochiwalistle tlan onikilwij in David nikmakas.” ");
INSERT INTO nhyNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Por yonik noijki kijta itech oksé Salmo: “Amo tikkawas ma ijtlakawi itlalnakayo de motekipanoj yolchipawak.” ");
INSERT INTO nhyNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David omikke nijkuak otlanke itekiw de iwan ipueblo ijkón ken Dios okinekia. Iwan okitookakej ijtik se mikkakuyoktle kan otoktokaj iweyitajwan, iwan itlalnakayo oijtlakawik. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero itlalnakayo in Jesús mach oijtlakawik porke Dios okiyolitij. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Xikmatikan kiné nokniwan, tejwan tamechmatiltiaj nik san yen Jesús welis amechtlapojpolwis de amotlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Nochtin akinmej kineltokaj in Jesús, Dios kinresibiroa kej yolchipawakej, iwan mach ok kinchiwilia kuenta intlajtlakol, amo ken itlanawatil in Moisés mach owelik otechtlapojpolwij. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Xikpiakan kuidado kiné, para amo anpanoskej namejwan tlan okijkuilojkej in profetajtin. Yejwan okijkuilojkej ijkín: ");
INSERT INTO nhyNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Xikitakan, namejwan katlej mach ankimatij antlakakij, anmotlajtlachialtiskej (onmomajmawtiskej) iwan anpojpoliwiskej, porke nikchiwas itlaj weyi nijkuak ok anyolitoskej, ke namejwan mach ankineltokaskej maski akaj ma anmechtlapowi de tlan nikchiwas. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Satepan de otlanke otlapoj in Pablo, yej iwan Bernabé okiskej de itech yon tiopan. In tlakaj okintlatlawtijkej para oksemi ma kintlapowikan de Jesús itech oksé weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Nijkuak nochtin opéj kisaj de itech yon tiopan, miekej judiojtin oyajkej iwan Pablo iwan Bernabé. Noijki oyajkej inwan sekimej katlej mach judiojtin katlej yokalakej itech intiotlamachtil in judiojtin. Pablo iwan Bernabé okinnajnawatijkej nochtin in tlakaj ma moyekketokan itech itlasojtlalis in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Owalchikometik, nijkuak weyi tonale, kasi nochtin in tlakaj de weyikan de Antioquía omololojkej para kikakiskej itlajtol in Señor. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Sekimej judiojtin nijkuak okitakej nik miekej tlakaj omololojkej, sa tekitl omoxikojkej. Opéj kitlajtolnanamikij in Pablo iwan opéj kiwikaltiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ijkuakón in Pablo iwan Bernabé otlajtojkej ika ixchikawalistle. Okinmilwijkej in judiojtin: ―Omonekia achtoj namejwan katlej anjudiojtin ma tamechmatiltikan itlajtol in toTajtzin Dios. Pero namejwan mach ankinekij ankineltokaskej. Tlan namejwan ankichiwaj mota nik mach amotech powi ankipiaskej in nemilistle katlej mach keman tlamis. Por yonik axan tejwan tikinmatiltitiwej katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ijkón tikchiwaskej porke in toSeñor ijkón otechnawatij, okijtoj: Onimitztlalij kej se tlanextle para xikintlawili in tlakaj katlej mach judiojtin, para xikinmitkili in kuale tlajtole katlej temakixtia itech nochi in tlaltikpak. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Katlej mach judiojtin, nijkuak ijkón okikakej, sa tekitl opakej iwan opéj kijtaj nik itlajtol in Señor sa tekitl kuale. Iwan okineltokakej nochtin katlej Dios okinpejpenke para kipiaskej nemilistle katlej mach keman tlamis. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ijkón omotematiltij itlajtol in Señor itech nochi nekáj región. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero in judiojtin xijxikuintin omotlatlalwijkej inwan sekimej siwamej katlej okachi wejweyikistokej iwan sa tekitl omotemaktiayaj itech itlanawatil in Moisés. Noijki okintlatlalwijkej sekimej tlakaj katlej okachi tlayekankej de itech yon weyikan. Okintlatlalwijkej para ma kintlatlalochtikan in Pablo iwan Bernabé. Okintlatlalochtijkej de itech yon weyikan de Antioquía iwan de itech oksekimej pueblojtin katlej ik ompa serka oyekaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ijkón kiné, in tlatitlaniltin omoikxitzejtzelojkej, kijtosneki nik mach intlajtlakol tla in yonmej tlakaj mach kiresibiroaj itlajtol in Dios. Iwan oyajkej para itech weyikan de Iconio. ");
INSERT INTO nhyNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero in momachtijkej tlaneltokakej oyoltentokaj ika pakilistle iwan ika Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ompa itech weyikan de Iconio Pablo iwan Bernabé okalakej san sekan itech se tiopan de yen judiojtin, iwan otetlapowijkej ika miek poder. Iwan ijkón miekej otlaneltokakej tanto judiojtin iwan katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero in judiojtin katlej mach okineltokakej, okintlatlalwijkej katlej mach judiojtin, iwan okichijkej de ma kiyejyekokan mach kuale de yen tokniwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Por yonik, in Pablo iwan Bernabé ompa omokajkej miek tonale. Otetlapowijkej ika miek ixchikawalistle, porke omotenmachojtokaj inawak toSeñor. Iwan toSeñor okinmakaya poder para ma kinchiwakan señalestin iwan milagrostin. Ijkón, Dios okichiwaya ma kimomakakan kuenta in tlakaj nik melawak tlan Pablo iwan Bernabé okijtoayaj de itlasojtlalis in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","In tlakaj de yen weyikan de Iconio omoxelojkej, sekimej oyajkej inwan judiojtin iwan sekimej oyajkej inwan tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Satepan in judiojtin iwan katlej mach judiojtin, okichijkej san se tlajtole inwan tekiwajkej, para kinwikaltiskej iwan kinmojmotlaskej in tlatitlaniltin. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero in Pablo iwan Bernabé, nijkuak okimatkej, ocholojkej iwan oyajkej itech weyikantin de Listra iwan de Derbe katlej katej itech estado de Licaonia, iwan itech oksekimej pueblojtin de ik ompa. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Iwan ompa noijki okitematiltiayaj in kuale tlajtole katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Itech weyikan de Listra ompa oyeka se tlakatl katlej mach owelia onejnemia. Mach onejnemia porke oyeka koxo desde itlakatilis. Yon tlakatl ompa oewatoka, ");
INSERT INTO nhyNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","okikaktoka tlan Pablo okijtoaya. Pablo okiyektlatak iwan okimomakak kuenta nik in yon koxo okipiaya miek tlaneltokalistle para welis pajtis. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ijkuakón Pablo okilwij chikawak: ―¡Ximoyekketza! In tlakatl owalmoketewak iwan ya owelik onejnenke. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nijkuak okitakej tlan okichij in Pablo, in tlakaj de yon estado de Licaonia opéj kuawtzajtzij ika de yejwan intlajtol, okijtojkej: ―¡Owaltemokej yinmej diosmej kej tlakaj! ");
INSERT INTO nhyNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Bernabé okitokayotijkej dios Júpiter, iwan Pablo okitokayotijkej dios Mercurio, porke yen otlapoaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","In tiopixke de dios Júpiter, katlej okipiaya itiopan kalyakapan, okualinwikak torojtin iwan okinkechonakiltij sekin kej xochikoronajtin. In tiopixke iwan nochtin chanejkej okinekiaj kinmiktilianij yonmej torojtin para ika kinweyikixtiskej in Pablo iwan Bernabé kej indioswan. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero nijkuak in Pablo iwan Bernabé okimomakakej kuenta tlan okinekiaj kichiwanij, omoelpantzotzoltzayankej iwan okalakej intzalko in tlakaj, kuawtzajtzitiwej. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Okijtoayaj: ―¡Tlakaj! ¿Tlanik ijkón ankichiwaj? Tejwan noijki titlakaj ken namejwan. Tejwan otiwalajkej otamechmatiltikoj in kuale tlajtole katlej temakixtia. Iwan otiwalajkej para tamechilwiskej nik moneki de ankinkawaskej in yinmej tlamantin katlej axan ankichiwaj, katlej mach itlaj inpatij. Okachi kuale ximokuepakan inawak Dios katlej yolitok, katlej okichij in ilwikak, in tlaltikpak, in atl iwan nochi tlan onkaj intech. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ya wejkawitl in Dios okinkawilij in tlakaj ma kichiwakan san tlan yejwan okinekiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Yej nochipa okinmititiaya akin Yej por tlan kuale okinchiwiliaya. Yej techwaltitlanilia in kiawatl iwan kuale tlakilotl, noijki techmaka tlan tikkuaj iwan techmaka pakilistle. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pero maski ijkón okinmilwijkej, in tlatitlaniltin owij nik owelikej okinkawaltijkej in yonmej tlakaj, para amo ma kinmiktilikan in torojtin para ika ma kinweyikixtikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ijkuakón oajsikoj sekimej judiojtin de weyikan de Antioquía iwan de Iconio, iwan okinkuatlapololtijkej in tlakaj itech yon weyikan de Listra. Yonmej judiojtin okintlatlalwijkej in tlakaj para ma kimojmotlakan in Pablo ika tetl. Satepan de okimojmotlakej ika tetl, yejwan okiyejyekojkej yokimiktijkej, iwan okikokuyotzkej okikixtijkej asta kalyakapan. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Iwan nijkuak in momachtijkej tlaneltokakej okiyawalotoj in Pablo, yej omoketzke iwan okalakke oksemi itech weyikan. Owalmostlatik in Pablo iwan Bernabé okiskej de ompa iwan oyajkej para itech weyikan de Derbe. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ompa itech weyikan de Derbe okitematiltijkej in kuale tlajtole katlej temakixtia iwan miekej omochijkej momachtijkej tlaneltokakej. Satepan oksemi omokuepkej itech weyikan de Listra, itech weyikan de Iconio iwan itech weyikan de Antioquía. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Itech yonmej weyikantin okinyolojchikajkej in momachtijkej tlaneltokakej, iwan okinnajnawatijkej ma moyekketokan itech intlaneltokalis, iwan okinmilwijkej ke para se ajsiti inawak Dios kan Yej tlanawatia kipia de se tlajyowis. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Iwan itech kada lugar kan omololoayaj in tiopantlaneltokakej okintlalijkej sekimej tlayekankej para yejwan ma kinyekanakan in tokniwan. Iwan nijkuak omotiotzajtzilijkej iwan omosawkej (oayunarojkej), okintlalijkej ipan imatzin in toSeñor katlej yejwan yokineltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Satepan Pablo iwan Bernabé opanokej ik región de Pisidia iwan oajsitoj itech región de Panfilia. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Okitematiltijkej itlajtol in toTajtzin Dios itech weyikan de Perge. Satepan oyajkej asta itech weyikan de Atalia. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ompa Atalia otlejkokej itech barko iwan oyajkej para itech weyikan de Antioquía. Okachi achtoj Pablo iwan Bernabé yejwan okiskej de ompa Antioquía nijkuak yakinika opéj inviaje. Itech nekáj tonale nijkuak okiskej, in tlaneltokakej omotiotzajtzilijkej para Dios ma kinpalewi iwan ma kintiochiwa itech yon tekitl katlej Dios okinmakak. Iwan axan Pablo iwan Bernabé yomokuepatoj porke yokitlamijkej yon tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nijkuak oajsitoj Antioquía, okinmololojkej nochtin in tlaneltokakej iwan okintlapowijkej de nochi tlan Dios okichij inwan. Noijki okintlapowijkej de kenik in toTajtzin Dios yokinresibiroj in tlakaj katlej mach judiojtin para yejwan noijki ma tlaneltokakan inawak Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo iwan Bernabé omokajkej ompa miek tonale inwan momachtijkej tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Itech nekatej tonaltin, sekimej tlakaj okiskej de estado de Judea iwan oyajkej asta itech weyikan de Antioquía. Iwan opéj kinmachtiaj in tokniwan tlaneltokakej okinmilwiayaj ke para welis momakixtiskej kipiaj de mosirkunsidaroskej ijkón ken Moisés otlanawatij. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo iwan Bernabé omotlatlajtolkuepkej chikawak inwan yonmej tlakaj. Por yonik in tlaneltokakej de Antioquía okinpejpenkej in Pablo, iwan Bernabé iwan oksekimej tokniwan para ma wian Jerusalén, ma kiyektlalitij yon tlamantle de sirkunsisión. Okintitlankej ma motlapowitij inwan tlatitlaniltin iwan noijki inwan tiopantlayekankej de Jerusalén. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","In tlaneltokakej de Antioquía okintitlankej kiné ma wian. Iwan nijkuak oyajkej, opanokej ik región de Fenicia iwan ik estado de Samaria. Ompa kanik oyayaj okintlapowiayaj in tokniwan kenik katlej mach judiojtin okikajkej tlan achtoj okineltokayaj iwan axan ya kineltokaj in toTajtzin Dios. Iwan nochtin in tokniwan sa tekitl opakej nijkuak ijkón okikakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nijkuak in Pablo iwan Bernabé oajsitoj Jerusalén, nochtin in tlaneltokakej, in tlatitlaniltin iwan in tiopantlayekankej okinresibirojkej ika pakilistle. Pablo iwan Bernabé okintlapowijkej nochi tlan Dios okichij innawak. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero omoketzkej sekimej de yen grupo de judiojtin intoka fariseos katlej yotlaneltokakej inawak Jesús, iwan okijtojkej: ―Kipiaj de mosirkunsidaroskej in tlaneltokakej katlej mach judiojtin, iwan kipiaj de kichiwaskej tlan kijta itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ijkuakón omololojkej in tlatitlaniltin iwan tiopantlayekankej para moyektlapowiskej de yon tlamantle de sirkunsisión. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Satepan de omotlapowijkej miek, Pedro omoketzke iwan okinmilwij: ―Nokniwan, namejwan ankimatij nik ya wejkawitl in Dios onechpejpenke de entre amejwan, para nikinmatiltis in kuale tlajtole katlej temakixtia katlej mach judiojtin, para ijkón yejwan noijki ma kikakikan iwan ma kineltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","In Dios katlej techixmati tinochtin ipan toyolo, otechititij nik ipan melajka kinresibiroa katlej mach judiojtin porke okinmakak in Espíritu Santo ijkón ken tejwan noijki otechmakak. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios mach techresibiroa san tejwan iwan yejwan amo, sino tinochtin techresibiroa, porke yejwan noijki okinyolchipaj de intlajtlakol porke otlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Iwan axan, ¿tlanik ankikuejsoaj in Dios? Porke namejwan ankinmakaj se tlamamale katlej mach judiojtin, katlej nion ya wejkawitl toweyitajwan iwan nion tejwan mach tiwelij tikmamaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Sino tejwan tikneltokaj nik in toSeñor Jesús techmakixtia por yen iteiknotlamachilis, ijkón ken kinmakixtia ika iteiknotlamachilis katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Iwan nochtin omokajkej sa tlakaktokej. Iwan okinkakilijkej tlan Pablo iwan Bernabé okinmilwiayaj de nekatej milagrostin iwan señalestin tlan yejwan okichijkej innawak katlej mach judiojtin ika ipoder in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Nijkuak otlankej otlapojkej in Pablo iwan Bernabé, Jacobo okijtoj: ―Nokniwan, xinechkakikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro otechtlapowij de kenik nijkuak yakinika in Dios opéj kinnotza katlej mach judiojtin, iwan okinpejpenke sekimej de yejwan katlej mach judiojtin para ma yekan iaxkawan iwan ma kiyektenewakan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tlan okijtoj in Simón Pedro ya ompa tlan okijkuilojkej in profetajtin, ijkín okijkuilojkej itech tiotlajkuilole: ");
INSERT INTO nhyNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Satepan de yin, niwalmokuepas oksemi iwan niktlalis kej rey se tlakatl katlej tlakatis de nelwatl de David. Ijkón ken se tlakatl oksemi kichiwa ikal nijkuak xitini, Nej no ijkón nikchiwas para ijkón in judiojtin ma kipiakan se rey. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Para ijkón nochtin oksekimej tlaltikpaktlakaj ma kitemokan in Señor, iwan nochtin katlej mach judiojtin kinekiskej nechtemoskej, porke yeskej noaxkawan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ijkón kijta in Señor, iwan ya wejkawitl ijkón yokitematiltijka yin tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Por yonik, nej nikijta, nik in yonmej katlej mach judiojtin katlej yomokuepkej inawak Dios, mach ok ma tikinnonotzakan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","San se kintlajkuililis para mach ma kikuakan itlaj tlamanale katlej kinmaniliaj in santojtin, in tlakaj iwan siwamej amo ma momekatikan, iwan mach ok ma kikuakan nakatl de yolkamej katlej amo kinkixtiliaj inmeso, iwan nion mach ma kikuakan estle. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ijkón tikinmilwiskej porke ijkón kijta in tlanawatile de Moisés, iwan desde ya wejkawitl katej tlakaj itech nochtin weyikantin katlej tetlapowiaj de yon tlanawatile. Tetlapowiaj itech tiopanmej de yen judiojtin nochi chikome nijkuak weyi tonale. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","In tlatitlaniltin iwan tiopantlayekankej, iwan nochtin in tiopantlaneltokakej, okijtojkej kinpejpenaskej sekimej de yejwan para ma wian iwan Pablo iwan Bernabé itech weyikan de Antioquía. Okipejpenkej in Judas katlej noijki kinotzaj Barsabás, iwan noijki okipejpenkej in Silas. Yonmej oyekaj katlej okachi tlayekantokej de itech yonmej tokniwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Yejwan okitkikej yin amatlajkuilole, katlej ijkín okijtoaya: “Tejwan titlatitlaniltin iwan tokniwan tiopantlayekankej tamechijkuililiaj yin amatlajkuilole. Tamechontlajpaloaj namejwan antlaneltokakej katlej mach anjudiojtin katlej anchantij itech weyikan de Antioquía, itech región de Siria iwan itech región de Cilicia. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Otikmatkej nik sekimej tlakaj oyajkej de nian para ompa katlej mach tejwan otikintitlankej, oamechnonotzatoj iwan oamechkuatlapololtitoj, porke amechilwiaj ximosirkunsidarokan iwan xikchiwakan nochi tlan kijta itlanawatil in Moisés. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Por yonik, tinochtin otiksepanyejyekojkej otikinpejpenkej sekimej de tejwan tokniwan para ma wian ma amechitatij san sekan iwan Pablo iwan Bernabé totetlasojkaikniwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pablo iwan Bernabé yomotemaktijkej (omotemaktilijkej) ika nochi inyolo maski ma kinmiktikan por yen toSeñor Jesucristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Por yonik axan, tamechintitlaniliaj in Judas iwan Silas, yejwan noijki anmechyekilwiskej nochi yin tlamantle. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","In Espíritu Santo okitak kuale iwan tejwan noijki, de mach ok tamechmakaskej itlaj oksé tlamamale xikchiwakan, sino san yen ");
INSERT INTO nhyNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","amo xikkuakan itlaj tlamanale katlej kinmaniliaj in santojtin. Amo xikkuakan estle iwan nakatl de yolkamej katlej mach kinkixtiliaj inmeso. In tlakaj iwan siwamej amo ma momekatikan. Tla ankichiwaskej tlan yotamechilwijkej, tonses kuale kajki. Ma Dios amechtiochiwa.” ");
INSERT INTO nhyNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Satepan, Pablo, Bernabé, Judas iwan Silas omoyolopachojkej iwan oyajkej para Antioquía. Iwan ompa Antioquía okinmololojkej nochtin tokniwan tlaneltokakej iwan okinmaktilijkej in amatlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nijkuak in tokniwan tlaneltokakej okilerojkej, sa tekitl opakej por yen tlan okijtoaya in amatlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Iwan komo in Judas iwan Silas noijki oyekaj profetajtin, yejwan okintlatlapololtijkej iwan okinyolojchikajkej in tokniwan tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Judas iwan Silas opanokej ompa Antioquía kanaj keski tonale. Iwan nijkuak okijtojkej mokuepaskej oksemi para Jerusalén innawak tokniwan katlej okualintitlankej, okinyolopachojkej kiné iwan okinmilwijkej ma wian ika kuale. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Pero in Silas okijtoj mokawas ompa Antioquía. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pablo iwan Bernabé noijki omokajkej ompa Antioquía. Yejwan iwan miekej oksekimej tlaneltokakej okiseguirojkej tlamachtiaj iwan kitematiltiaj itlajtol in toSeñor. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Keski tonale satepan, Pablo okilwij in Bernabé: ―Ma tiwian ma tikintlajpalotij oksemi in tokniwan itech nochtin in weyikantin kan otiktematiltijkej itlajtol in toSeñor, para tikmatiskej kenamij katej. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé okinekia kiwikani in Juan katlej noijki kinotzaj Marcos, ");
INSERT INTO nhyNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","pero in Pablo okiyejyekoj mach kualtis kiwikaskej porke achtoj in Juan Marcos okinkajtej ne itech tlale de Panfilia iwan mach ok okiseguiroj inwan itech yon tekitl. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iwan komo mach omotlajtolwelitakej iwan omokualanijkej, okachi kuale omoxelojkej. Bernabé okiwikak in Juan Marcos, oonewakej otlejkokej itech se barko para oyajkej asta Chipre. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ijkuakón Pablo okipejpenke in Silas para ma kiwika. In tlaneltokakej de Antioquía omotiotzajtzilijkej iwan okintlalijkej ipan itlasojtlalis in toSeñor. Satepan in Pablo iwan Silas oyajkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Opanokej ik tlale de Siria iwan ik tlale de Cilicia. Okinyolojchikajtiayaj nochtin in tiopantlaneltokakej ik nowian (nian nepa) kanik opanotiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo iwan Silas oajsitoj itech weyikan de Derbe iwan itech weyikan de Listra, kan okajsitoj se momachtij tlaneltokak itoka Timoteo, itelpoch de se siwatl tlaneltokak judía iwan ipapan oyeka griego. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","In tokniwan tlaneltokakej de Listra iwan de Iconio otlajtoayaj kuale de Timoteo. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo okinekke ma wia iwan Timoteo, pero achtoj okisirkunsidaroj porke in judiojtin katlej chantij itech nekatej weyikantin kan yaskej okimatiaj ke ipapan in Timoteo oyeka griego. Pablo mach okinekke ma kijtokan in yonmej judiojtin nik in Timoteo mach kichiwa in tlamantle de sirkunsisión. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Itech nochtin weyikantin kanik yejwan opanotiayaj, okinmatiltijtiajkej in tlaneltokakej de yen tlanawatiltin katlej omonekia de kichiwaskej, katlej in tlatitlaniltin iwan tiopantlayekankej de Jerusalén okijtojkej ma mochiwa. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","In tiopantlaneltokakej okajsikej okachi chikawalistle itech intlaneltokalis, iwan nochi tonale omomiekiliayaj okachi in tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Iwan komo in Espíritu Santo amo okinkawilij ma kitematiltikan itlajtol in Dios itech tlale de Asia, yejwan otlakotonkej ik región de Frigia iwan ik región de Galacia, ");
INSERT INTO nhyNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","iwan oajsitoj kan monamiktokej in tlalmej de Misia iwan de Bitinia. Satepan okimolwijkej kalakiskej itech yon tlale de Bitinia, pero in Espíritu Santo mach okinkawilij. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ijkón, san opanokej ik inakastlan in tlale de Misia, iwan oajsitoj itech weyikan de Troas katlej kajki itempan atl. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yon yuak, Pablo okitak kej yeskia teemiktok, okitak se tlakatl de tlale de Macedonia, omoketoka iyakapan iwan okitlatlawtiaya: “Xipano ik Macedonia iwan xitechpalewi.” ");
INSERT INTO nhyNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nijkuak in Pablo okitak in yon kej yeskia teemiktle, niman otimotlayektlalilijkej iwan otiktemojkej se barko para tiaskej itech nekáj tlale de Macedonia, kuale otikmatiaj nik in Dios otechnotoka para ompa ma tiktematiltitij in kuale tlajtole katlej temakixtia. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Otikiskej kiné de itech weyikan de Troas itech se barko, iwan otiajkej melajka itech tlale katlej pankistok itech atl itoka Samotracia, iwan owalmostlatik otajsitoj itech weyikan de Neápolis. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Iwan de ompa otiajkej para itech weyikan de Filipos, yon weyikan okachi weyikistok de itech yonmej tlalmej de Macedonia, kan chantij romanostin, iwan ompa otimokajkej kanaj keski tonale. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Se sábado, nijkuak weyi tonale, otikiskej de itech yon weyikan, iwan otiajkej itempan se weyatl, kan sekimej kimatij yawij ompa onmotiotzajtziliaj. Otimotlalijkej iwan otikintlapowijkej in siwamej katlej ompa oololitokaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Se de yonmej siwamej itoka Lidia. Yon siwatl oyeka de Tiatira iwan oyeka tzotzolnamakak de katlej kuale tzotzole moradotik. Yej noijki okiweyikixtiaya in toTajtzin Dios. Ompa oyeka iwan okikakke tlan otikijtoayaj, in Señor okiyoltlapoj para kuale ma kikaki tlan Pablo okijtoaya. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Yej iwan nochi ifamilia omokuateekijkej. Iwan satepan Lidia otechtlatlawtij. Otechilwij: ―Tla melawak namejwan ankiyejyekoaj nik in nej nikneltoka in Señor, xiwalmuikakan ximokalotikan nokalijtik. Iwan sa tekitl otechtlatlawtij ma timokawakan ichan, iwan ompa otimokajkej kiné. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Se buelta, nijkuak otiayaj para nekáj lugar kan motiotzajtziliaj, otiknamikej se ichpochtle tekipanoj okipiaya se ejekatl mach kuale iwan otetlamatkawiaya iwan okitlania miek tomin para okinmakaya itekowan. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Yon ichpochtle opéj techseguiroa tejwan iwan Pablo, iwan okijtoaya chikawak: ―Yinmej tlakaj itekipanojkawan Dios katlej Weyikistok (Weyititok) iwan amechmatiltiaj in kuale ojtle para anmomakixtiskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ijkón okichijtinenke miek tonale, asta kan Pablo okikuejsoj, omokuepke iwan okilwij in ejekatl katlej okipiaya in ichpochtle: ―Ika itoka in Señor Jesucristo, nimitznawatia xikisa de itech. Iwan san niman ijkuakón okiske in ejekatl mach kuale. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero nijkuak itekowan yon ichpochtle okitakej nik mach ok kitlani tomin para yejwan, ijkuakón okinkitzkijkej in Pablo iwan Silas iwan okinwikakej inmak in tekiwajkej itech kancha de yon weyikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Iwan okinteixpantitoj innawak in juestin, iwan okijtojkej: ―Yinmej judiojtin kinkuapajsolojtinemij (kinkuatlapololtijtinemij) in tlakaj de toweyikan, ");
INSERT INTO nhyNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","iwan tlamachtijtinemij de oksé tlamantle katlej tejwan mach tiknekij iwan nion mach welis tikchiwaskej, porke tejwan tiromanostin. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ijkuakón in tlakaj okinyawalojkej in Pablo iwan Silas iwan okinmistlakawiayaj ika san tlan amo. In juestin otlanawatijkej ma kintzotzolkixtikan iwan ma kinwitekikan ika tlakotl. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Iwan satepan de okinwitekej miek, okintzakej. Okinawatijkej in tetzakke kuale ma kintlato. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Nijkuak otlanke okinajnawatijkej in tetzakke, okinkalakij okintzakuato asta kan okachi tlijtik de ijtik telpiloyan, iwan okinmikxikuawkalakij itech se tabla tilaktik itoka cepo. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pero kej tlajko yuak, Pablo iwan Silas omotiotzajtzilijtokaj iwan okitlakuikilijtokaj in toTajtzin Dios, iwan oksekimej katlej otzaktokaj okinkaktokaj, ");
INSERT INTO nhyNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","iwan san niman ijkuakón otlalolinke chikawak asta okiwiwixoj icimiento in telpiloyan, iwan san niman ijkuakón noijki owaltlapokej nochtin puertajtin. Iwan nochtin in tlakaj katlej otzaktokaj okojkotonkej inkadenawan katlej ika oijilpitokaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","In tetzakke oijsak iwan okinmitak nochtin in puertajtin tlapotokej. Ijkuakón okikixtij iespada para momiktis, porke okimolwij yocholojkej katlej otzaktokaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero in Pablo okitzajtzilij chikawak: ―¡Amo ximomikti! Nian tikatej tinochtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ijkuakón in tetzakke okitlajtlanke se tlanextle, iwan omotlaloj ik tlijtik papatlakatiw (bibiokatiw) ika nemawtile, omotlankuaketzke iwan omopachoj inmikxitlan Pablo iwan Silas. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Satepan okinkixtij kalan iwan okintlajtlanij: ―Xinechilwikan namejwantzitzintin, ¿tlan moneki nikchiwas para nimomakixtis? ");
INSERT INTO nhyNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yejwan okinankilijkej: ―Xikneltoka in Señor Jesús, iwan ijkón welis timomakixtis iwan noijki welis momakixtis nochi mofamilia. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Satepan Pablo iwan Silas okitlapowijkej de itlajtol in Señor in tetzakke iwan noijki nochtin katlej iwan ochantiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","San niman yon yuak, in tetzakke okinpakilij kan okinxojxolejkej, iwan san niman yej iwan nochi ifamilia omokuateekijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Satepan in tetzakke okinwikak in Pablo iwan Silas itech ikalijtik iwan okintlamakak. Yej iwan ifamilia opakej miek por okineltokakej in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nijkuak otlaneske, in juestin okintitlankej sekimej mayoltin kan oyeka in tetzakke, para ma kinkajkawakan in Pablo iwan Silas. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","In tetzakke okilwij in Pablo: ―In juestin onechnawatijkej ma namechkajkawa, axan ya kualtis ankisaskej iwan xiwian ika kuale. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero in Pablo okinmilwij in mayoltin: ―Tejwan tiromanostin, iwan otechwitekej teixpan iwan nion mach otechtlatzintokijkej achtoj kox otikchijkej itlaj tlan mach kuale, iwan san tekitl otechtzakej. ¿Iwan axan kinekij techkajkawaskej san ichtaka? ¡Amo! Ma wikikan yejwan innewian ma techkixtikij. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","In mayoltin okinmatiltitoj in juestin. In yonmej juestin omomawtijkej nijkuak okimatkej nik in Pablo iwan Silas yejwan romanostin. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Oyajkej kiné in juestin, omotlapojpolwitoj iwan Pablo iwan Silas por tlan okintoktijkej, okinkixtijkej de telpiloyan iwan okintlatlawtijkej ma wian de itech yon weyikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nijkuak in Pablo iwan Silas okiskej de telpiloyan, oyajkej ichan Lidia. Satepan de okinmitakej iwan de okinyolojchikajkej in tokniwan tlaneltokakej, okiskej de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Nijkuak oyajkej, in Pablo iwan Silas opanokej ik weyikan de Anfípolis iwan ik weyikan de Apolonia, iwan satepan oajsitoj itech weyikan de Tesalónica, kan judiojtin okipiayaj se intiopan. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo oyáj itech se tiopan, ijkón ken yej okimatia okichiwaya, oyáj ipan eyi samana kada sábado nijkuak weyi tonale iwan okintlapowij de tlan kijta in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Okinyekilwiaya nik in Cristo okipiaya de tlajyowis, mikis iwan moyolkuis (moyolitis). Okinmilwij: ―In Jesús katlej nej namechmatiltia namejwan, yen Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ijkuakón sekimej judiojtin omokuepkej tlaneltokakej iwan omosetilijkej iwan Pablo iwan Silas. Noijki omokuepkej tlaneltokakej sekimej griegojtin katlej sa tekitl omotemaktiayaj inawak Dios, iwan noijki omokuepkej tlaneltokakej miekej siwamej katlej okachi wejweyikistokej (wejweyititokej) de itech yon weyikan. Yejwan noijki omosetilijkej iwan Pablo iwan Silas. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Iwan judiojtin katlej mach tlaneltokakej, omoxikojkej miek, iwan okintlatlalwijkej sekimej tlakaj tlatziwkej katlej mach kuale inyolo. Okintlatlalwijkej iwan asta okinkuakualanijkej in tlakaj de yon weyikan de Tesalónica. Oyajkej ichan Jasón, okintemotoj in Pablo iwan Silas, para kinkixtiskej iwan kintemaktiskej (kintemaktiliskej) inmak in tlakaj de yon weyikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pero komo mach okinmajsitoj, tonses okiwikakej in Jasón iwan oksekimej tokniwan tlaneltokakej, okinkokuyotzkej ipan tlale iwan oyajkej okintemaktitoj (okintemaktilitoj) innawak tekiwajkej de yon weyikan. Iwan nochtin tlakaj otzajtziaj chikawak: ―¡Yinmej tlakaj tekuapajsolojtinemij (tekuatlapololtijtinemij) itech nochi in tlaltikpak, iwan axan nian noijki yowalajkej! ");
INSERT INTO nhyNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","¡Jasón okinkalotij ichan! Nochtin yejwan mach ok kitlakitaj itlanawatil in rey César. Yejwan kijtaj ke onkaj oksé rey, itoka Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Nijkuak ijkón okikakej, in tlakaj iwan tekiwajkej okachi omokuakualanaltijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Pero in Jasón iwan oksekimej tokniwan tlaneltokakej okitlaxtlajkej para okinkajkajkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","San niman yon yuak in tokniwan okinyolopachojkej in Pablo iwan Silas para ma wian itech weyikan de Berea. Nijkuak oajsitoj, oyajkej kan intiopan in judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Yonmej judiojtin de Berea okipiayaj okachi kuale intlalnamikilis iwan amo ken judiojtin de Tesalónica, ika miek pakilistle okiresibirojkej itlajtol in toTajtzin Dios, iwan nochipa okileroayaj in tiotlajkuilole para kitaskej kox melawak tlan okinmilwiayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ijkón, miekej judiojtin otlaneltokakej. Noijki otlaneltokakej miekej siwamej griegajtin katlej okachi wejweyikistokej (wejweyititokej) de itech yon weyikan, iwan noijki otlaneltokakej miekej tlakaj griegojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero nijkuak in judiojtin de Tesalónica okimatkej nik in Pablo okitematiltijtoka itlajtol in Dios noijki itech weyikan de Berea, oyajkej para ompa. Iwan ompa noijki okintlatlalwijkej iwan okinkuakualanijkej in tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pero in tokniwan tlaneltokakej san niman okititlankej in Pablo para ma wia asta itempan atl, pero in Silas iwan Timoteo omokajkej ompa Berea. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Katlej okiwikayaj in Pablo okikajkawatoj asta itech weyikan de Atenas. Satepan owalmokuepkej para Berea ika itlanawatil in Pablo para ma kilwikan in Silas iwan Timoteo de ma kajsitij san niman ompa Atenas. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nijkuak in Pablo okinchixtoka in Silas iwan Timoteo ompa Atenas, omoyolkokoj miek porke okinmitak miekej diosmej itech yon weyikan. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Por yonik, yej okintlapowiaya in judiojtin itech intiopan iwan noijki okintlapowiaya katlej mach judiojtin katlej omotemaktiayaj inawak Dios. Noijki nochi tonale okintlapowiaya itech tiankistle katlej ik ompa omololoayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ompa oyekaj sekimej ixtlamatkej katlej kintokayotiaj epicúreos iwan oksekimej ixtlamatkej katlej kintokayotiaj estoicos, opéj iwan motlatlajtolkuepaj. Iwan sekimej okijtoayaj: ―¿Tlan kineki techilwis yin tlakatl katlej wel tlapoa? Iwan oksekimej okijtoayaj: ―Nesi ke tetlapowijtinemi de oksekimej diosmej. Ijkón okijtoayaj porke Pablo okinmatiltiaya de Jesús iwan de kenik omoyolkuik. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ijkuakón in tlakaj okiwikakej in Pablo kan Areópago, kan kichiwaj junta katlej okachi ixtlamatkej, iwan okitlajtlanijkej: ―¿Welis tikmatiskej katlij yen yankuik tlamachtile tikkualkui? ");
INSERT INTO nhyNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Porke tej titechilwia tlan mach tikmomakaj kuenta, iwan tiknekij tikmatiskej tlan kijtosneki nochi yon. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ijkón okijtojkej porke nochtin tlakaj de Atenas iwan katlej amo de Atenas pero ompa chantij, mach itlaj oksé tlamantle okichiwayaj, sino sanwel okikakiaj iwan omotlapowiayaj de itlaj tlamantle yankuik. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ijkuakón Pablo omoketzke tlatlajko kan Areópago, iwan okijtoj: ―Tlakaj de Atenas, nikita nik namejwan wel ankintlakitaj namodioswan. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Onitlajtlachixtinenke kan katej namodioswan, iwan ompa onikitak se artal katlej kipia ijkuilitok: “Para yen Dios katlej mach tikixmatij”. Iwan axan, in Dios katlej namejwan ankiweyikixtiaj iwan mach ankixmatij, axan de yen yon nej nikneki namechtlapowis. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’In Dios katlej okichij in tlaltikpak iwan nochi tlan onkaj itech, yen Señor iaxka in ilwikak iwan tlaltikpak. Mach chanti itech tiopanmej ken katlej kinchiwaj in tlakaj, ");
INSERT INTO nhyNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","nion mach moneki akaj tlakatl itlaj ma kichiwa por Yej, porke Yej mach itlaj kipoloa. Yej techmaka tonemilis tinochtin, techmaka toijyoyo para ma tiwelikan ma timijyotikan iwan techmaka nochi tlan tikpiaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’San itech se tlakatl katlej itoka Adán, Dios okinchij nochtin in tlakaj de ixko yin tlaltikpak para ma chantikan ik nowian (nian nepa), iwan noijki keski tonale kipiaj de yolitoskej iwan kan kipiaj de chantiskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dios ijkón okichij para ke nochtin in tlakaj de yin tlaltikpak ma kitemokan, xamo welis tlamatemoskej iwan kajsiskej, maski ipan melajka, in Dios mach kajki wejka de kada se de tejwan. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Porke ika ipoder in Dios tiyolitokej, timoliniaj iwan tikatej. Ijkón ken sekimej poetas de amejwan okijtojkej: “Tejwan titepilwan de Dios.” ");
INSERT INTO nhyNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Ijkón kiné, tla tejwan titepilwan de Dios, amo ma tikyejyekokan nik in Dios tlachiwale de oro, de plata o noso de tetl ken kinchiwaj in tlakaj, iwan kiyejyekoaj ijkón nik kaj in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ya wejkawitl in Dios mach okinchiwilij kuenta intlajtlakol in tlakaj, porke mach okimatiaj tlan okichiwayaj, pero axan kinnawatia nochtin in tlakaj de yin tlaltikpak, ma moyolpejpenakan (ma moyolkuepakan) de intlajtlakol. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Porke yokitlalij se tonale, nijkuak nochtin in tlakaj de yin tlaltikpak kinyolkuitis ika itlakamelawalis de yen Cristo Jesús katlej Dios okipejpenke. Dios okinmititij nochtin in tlakaj nik melawak ijkón kichiwas nijkuak okiyolitij in Jesús satepan de omikke. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nijkuak okikakej nik in mikkamej moyolkuiskej (moyolitiskej), sekimej okipinawijkej iwan oksekimej okijtojkej: ―Okachi kuale itech oksé tonale oksemi welis titechtlapowis. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ijkuakón in Pablo okiske de ompa. ");
INSERT INTO nhyNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero sekimej tlakaj okineltokakej in toSeñor iwan oyajkej iwan Pablo. Se de yejwan itoka Dionisio, se tlakatl tlayekanke de kan Areópago, iwan noijki se siwatl itoka Dámaris, iwan noijki otlaneltokakej oksekimej. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Satepan, Pablo okiske de Atenas iwan oyáj itech weyikan de Corinto. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ompa okajsito se judío itoka Aquila, de región de Ponto. Ijkuakón mach ya wejkika, in Aquila iwan isiwa Priscila oajsikoj de Italia, okiskej de ompa porke in weyi tlanawatij Claudio, otlanawatij ke nochtin in judiojtin ma kinkixtikan de itech weyikan de Roma, ikapital in país de Italia. Ijkuakón Pablo oyáj okintlajpaloto itech inkalijtik. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Aquila iwan Priscila yejwan intekiw oyeka okinchiwayaj mantajkaltin, no ken Pablo, iwan por yonik in Pablo ompa omokaj para inwan tekipanos. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Iwan nochi sábado, nijkuak weyi tonale, Pablo oyaya kan intiopan in judiojtin. Ompa okintlapowiaya in judiojtin iwan katlej mach judiojtin. Pablo okinekia ma kineltokakan in Cristo. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nijkuak in Silas iwan Timoteo oajsikoj de Macedonia, Pablo okikaj itekiw iwan okixkawij (omomelij) tetlapowia de itlajtol in toTajtzin Dios. Okinmilwij in judiojtin nik in Cristo katlej yejwan kichixtokej yowitza. Okinmilwij nik in Jesús yen Cristo. Cristo kijtosneki itlapejpenal in Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero in judiojtin okualankej inawak iwan opéj kiwikaltiaj. Pablo omotlakentzejtzeloj kej se señas nik mach okiresibirojkej itlajtol in toTajtzin Dios, iwan okinmilwij: ―Amejwan namotlajtlakol tla anmopoloskej. Mach ok nej notlajtlakol. De axan para tlayakapan nej nikinmatiltis itlajtol in toTajtzin Dios in tlakaj katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pablo okiske de kan intiopan in judiojtin iwan oyáj ichan se tlakatl itoka Ticio Justo, katlej otlaneltokaya inawak Dios iwan ochantia inakastlan yon tiopan. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Se tlakatl itoka Crispo tlayekanke de itech yon tiopan, okineltokak in Señor, yej iwan nochi ifamilia. Noijki miekej tlakaj de Corinto, nijkuak okikakej itlajtol in toTajtzin Dios, okineltokakej iwan omokuateekijkej. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Se yuak in Pablo okitak in Señor kej yeskia oteemiktoka okilwij: ―Amo ximomawti, xiktematilti notlajtol iwan amo ximokamatzakua. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Porke Nej mowan nikaj iwan mach akaj itlaj welis mitztoktis, porke ok miekej tlakaj nikinpia itech yin weyikan katlej nechneltokaskej. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ijkón, Pablo omokaj itech weyikan de Corinto se xiwitl iwan tlajko, otlamachtiaya de itlajtol in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pero itech yonmej tonaltin nijkuak in romano Galión oyeka gobernador itech estado de Acaya, omololojkej sekimej judiojtin katlej okualankej inawak in Pablo iwan okitzkijkej iwan okiwikakej kan tlaixkomakaj (tlatzonmanaj) ixpan gobernador Galión. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Okilwijkej in gobernador: ―Yin tlakatl kintlaneltokitia nochtin in tlakaj para ma kiweyikixtikan in Dios ika oksé tlamantle iwan amo ken kijta totlanawatil. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo ya tlajtoani, pero ijkuakón Galión okinmilwij in judiojtin: ―Tla amejwan anjudiojtin ankistlakawiaj yin tlakatl por otlachtekke o noso por otemiktij, o noso por okichij itlaj oksé tlamantle mach kuale, nian nikaj nej para namechkakilis. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero komo namejwan annechnotzaj san por yej tlan tlamachtia yin tlakatl iwan de tokayomej, iwan de amotlanawatilwan, ompa amejwan xikitakan, porke nej mach nikneki nimokalakis amowan kej nijues. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iwan okinkixtij ika chikawak de kan tlaixkomakaj (tlatzonmanaj). ");
INSERT INTO nhyNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ijkuakón nochtin okitzkijkej in Sóstenes, se tlayekanke de kan yon tiopan, iwan okiwitekej ompa teixpan kan tlaixkomakaj. Pero in gobernador Galión mach okinchij kuenta. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo ok omokaj Corinto miek tonale. Oajsik tonale otlayolopachoj de innawak in tokniwan tlaneltokakej, iwan satepan Pablo iwan Priscila iwan Aquila otlejkokej san sekan itech se barko para oyajkej itech región de Siria. Pero kan pueblo de Cencrea, Pablo omoxinke tetextik (kuameloj), para ijkón okichij tlan achtoj okisentlalij inawak Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Nijkuak oajsitoj itech weyikan de Éfeso, Pablo okinkajtej in Priscila iwan Aquila iwan yej oyáj itech intiopan in judiojtin, ompa omotlapowij inwan judiojtin katlej ompa omololoayaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yejwan okilwiayaj ma mokawa kanaj keski tonale inwan, pero in Pablo mach okinekke. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Otlayolopachoj de innawak. Okinmilwij: ―Tla Dios kineki, namechtlajpaloki oksemi. Satepan Pablo otlejkok itech se barko iwan okiske de itech weyikan de Éfeso. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pablo oajsito itech weyikan de Cesarea iwan de ompa oyáj para itech weyikan de Jerusalén. Oyáj okintlajpaloto in tiopantlaneltokakej. Satepan omokuepke para itech weyikan de Antioquía. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Ompa Antioquía omokaj kanaj keski tonale. Satepan oksemi okiske iwan oyáj itech región de Galacia iwan itech región de Frigia. Kanik yej opanotiaj okinyolojchikajtiaj nochtin in momachtijkej tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Itech nekatej tonaltin oajsiko itech weyikan de Éfeso se judío itoka Apolos, de pueblo de Alejandría. Kuale okimatia otlapoaya iwan kuale okixmatia in tiotlajkuilole. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Okiyekixmatia iojwi in Señor, iwan otetlapowiaya ika pakilistle. Tlan Apolos otetlapowiaya iwan tlan otlamachtiaya de Jesús yon melawak, pero san yen tlakuateekilistle de Juan tlan okimatia. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos opéj kintlapowia nochtin itech intiopan in judiojtin ika ixchikawalistle. Pero nijkuak in Priscila iwan Aquila okikakej in Apolos, okinotzkej iwan okiyekmatiltijkej okachi de iojwi in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nijkuak in Apolos okijtoj yas ik región de Acaya, in tokniwan tlaneltokakej de Éfeso okiyolojchikajkej kiné ma wia. Okintlajkuililijkej in momachtijkej tlaneltokakej de Acaya para ma kiresibirokan ika kuale. Nijkuak oajsito ompa, okinpalewij miek katlej Dios ika itlasojtlalis okichij ma tlaneltokakan. ");
INSERT INTO nhyNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Porke inmixpan nochtin in tlakaj okinkajkakitiaya nik in judiojtin mach ijki nik katej. Iwan in judiojtin mach ok itlaj okijtoayaj. Apolos okichiwaya kuale ma kimomakakan kuenta de itlajtol in toTajtzin Dios porke omokitzkiaya itech tiotlajkuilole, okinmititiaya nik in Jesús yen Cristo katlej Dios okitlalij para tlanawatis. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nijkuak Apolos ok oyeka Corinto, Pablo oyáj otlakotontiaj ik tepeyoj iwan oajsito itech weyikan de Éfeso, ompa okinmajsito sekimej momachtijkej tlaneltokakej. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Pablo Okintlajtlanij: ―¿Ankiresibirojkej in Espíritu Santo nijkuak antlaneltokakej? Yejwan okinankilijkej: ―Mach keman tikkakij kox onkaj Espíritu Santo. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ijkuakón Pablo okintlajtlanij: ―Tonses, ¿tlan tlakuateekilistle ankineltokakej kiné? Yejwan okijtojkej: ―Otimokuateekijkej ijkón ken otlakuateekiaya in Juan Tlakuateekij. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo okinmilwij: ―Melawak, Juan okinkuateekiaya in tlakaj iwan yon kijtosneki nik in tlakaj yomoyolpejpenkej (yomoyolkuepkej) de intlajtlakol. Pero noijki okinmilwiaya kipiaj de kineltokaskej katlej walmuikas satepan de yen Juan, kijtosneki ma kineltokakan in Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nijkuak okikakej tlan Pablo okinmilwij, omokuateekijkej ika itoka in toSeñor Jesús. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Iwan nijkuak in Pablo okintlalij imawan inpan yonmej tokniwan, in Espíritu Santo owalaj inpan, iwan otlapoayaj ika oksekimej tlajtoltin, iwan opéj kijtaj tlan Dios okinmilwiaya ma kijtokan. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Por nochtin oyekaj kanaj majtlaktle iwan ome tlakaj. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo oyaya itech intiopan in judiojtin kanaj eyi metztle, kan okitematiltiaya itlajtol in toTajtzin Dios ika ixchikawalistle. Okintlapowiaya iwan okintlaneltokitiaya in tlakaj de kenik in Dios tlanawatia. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero sekimej sa tekitl oyoltlakuawakej iwan mach okinekej okineltokakej itlajtol in Dios. Inmixpan nochtin in tlakaj otlajtoayaj mach kuale de iojwi in Dios. Ijkuakón Pablo omoxeloj de yejwan, iwan okinwikak in momachtijkej tlaneltokakej kan se eskuela kan noijki otlamachtiaya se tlakatl itoka Tirano. Pablo ompa okinmachtiaya momostla. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ijkón okichij kej ome xiwitl. Por yonik nochtin katlej ochantiaj itech región de Asia okikakej itlajtol in toSeñor Jesús, nochtin in judiojtin iwan katlej mach judiojtin. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Pablo okinchiwaya wejweyin milagrostin ika ipoder in toTajtzin Dios. ");
INSERT INTO nhyNT_vpl VALUES ("AC19_12","074_