﻿USE sofia;
DROP TABLE IF EXISTS sofia.nhx_vpl;
CREATE TABLE nhx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nhx_vpl WRITE;
INSERT INTO nhx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nigaj ijkuilijtoꞌ ito̱ka̱mej yej iyikyapatajwe̱wejmej Jesucristo, yej te̱píltzi̱mpa katka iga David iwá̱n David te̱píltzi̱mpa katka iga Abraham. ");
INSERT INTO nhx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham mochij te̱taj iga Isaac, iwá̱n Isaac mochij te̱taj iga Jacob, iwá̱n Jacob mochij te̱taj iga Judá iwá̱n iyikni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá iwá̱n isiwa̱ꞌ yej ito̱ka̱ꞌ Tamar mochijkej te̱tajmej iga Fares iwá̱n Zara. Fares mochij te̱taj iga Esrom. Esrom mochij te̱taj iga Aram. ");
INSERT INTO nhx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram mochij te̱taj iga Aminadab, iwá̱n Aminadab mochij te̱taj iga Naasón, iwá̱n Naasón mochij te̱taj iga Salmón. ");
INSERT INTO nhx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón mochij te̱taj iga Booz, te̱ye̱ꞌ ito̱ka̱ꞌ Rahab. Booz mochij te̱taj iga Obed, te̱ye̱ꞌ ito̱ka̱ꞌ Rut. Obed mochij te̱taj iga Isaí. ");
INSERT INTO nhx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí mochij te̱taj iga rey David, David kipiáꞌ se̱ ipiltzi̱n yej ito̱ka̱ꞌ Salomón yej kitaꞌ iwá̱n inó̱n siwa̱ꞌ yej isíwa̱ꞌpa katka Urías. ");
INSERT INTO nhx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón mochij te̱taj iga Roboam, iwá̱n Roboam mochij te̱taj iga Abías, iwá̱n Abías mochij te̱taj iga Asa. ");
INSERT INTO nhx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mochij te̱taj iga Josafat, iwá̱n Josafat mochij te̱taj iga Joram, iwá̱n Joram mochij te̱taj iga Uzías. ");
INSERT INTO nhx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías mochij te̱taj iga Jotam, iwá̱n Jotam mochij te̱taj iga Acaz, iwá̱n Acaz mochij te̱taj iga Ezequías. ");
INSERT INTO nhx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías mochij te̱taj iga Manasés, iwá̱n Manasés mochij te̱taj iga Amón, iwá̱n Amón mochij te̱taj iga Josías. ");
INSERT INTO nhx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jeconías iwá̱n iyikni̱wa̱n itajmej ito̱ka̱ꞌ Josías. Ini̱mej ipilowa̱n onokoj kua̱ꞌ rey de país Babilonia kipre̱sojwij israeli̱tajmej iga kiwi̱gakej Babilonia. ");
INSERT INTO nhx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kua̱ꞌ kí̱skeja Babilonia, Jeconías kipiáꞌ ipiltzi̱n yej ito̱ka̱ꞌ Salatiel. Iwá̱n Salatiel kipiáꞌ ipiltzi̱n yej ito̱ka̱ꞌ Zorobabel. ");
INSERT INTO nhx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel mochij te̱taj iga Abiud, iwá̱n Abiud mochij te̱taj iga Eliaquim, iwá̱n Eliaquim mochij te̱taj iga Azor. ");
INSERT INTO nhx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor mochij te̱taj iga Sadoc, iwá̱n Sadoc mochij te̱taj iga Aquim, iwá̱n Aquim mochij te̱taj iga Eliud. ");
INSERT INTO nhx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud mochij te̱taj iga Eleazar, iwá̱n Eleazar mochij te̱taj iga Matán, iwá̱n Matán mochij te̱taj iga Jacob. ");
INSERT INTO nhx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob mochij te̱taj iga José, yej iwe̱wej María. Ini̱nya María yej iye̱ꞌ Jesús, ini̱nya Jesús yej tikto̱ka̱wiáj Cristo. ");
INSERT INTO nhx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ijkó̱n panoj catorce te̱tajwe̱wetkej yej ipilówa̱mpa ipilowa̱n Abraham este iga onókoya David. Panoj no̱ catorce te̱tajwe̱wetkej yej ipilówa̱mpa ipilowa̱n David este kua̱ꞌ israeli̱tajmej kiwi̱gakej preso Babilonia, iwá̱n panoj seꞌoꞌ má̱j catorce te̱tajwe̱wetkej este kua̱ꞌ onókoya Cristo. ");
INSERT INTO nhx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijkí̱n iga onoko Jesucristo: María yej iye̱ꞌ Jesús onóyaya iga yawi mona̱mikti̱ti iwá̱n José. Eꞌ kua̱ꞌ aya mona̱miktiáj, María xo̱lo̱yowiꞌ iga ipode̱r iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Iwá̱n José yej mochi̱was iwé̱j María, poxsan katka ye̱ꞌnemiá, iwá̱n ayoꞌ kinekiá mamona̱mikti iwá̱n María; eꞌ malej ijkó̱n, José akinekiá mamomati iga María ónoꞌya iwá̱n seꞌ ta̱gaꞌ; yéj kejla̱ntoya iga ichtákasan mamokajte̱waka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mie̱j inó̱n kejla̱ntoya, kochiꞌ iwá̱n kite̱miꞌ iga se̱ iyá̱ngel Dios wa̱laj iwá̱n ijkí̱n kijlij: —José, tej yej ipiltzi̱n ipilówa̱mpa David, amo ximajmawi iga timona̱miktiá iwá̱n María, iga inó̱n xo̱lo̱ꞌ yej kitalaxwijtoꞌ, ino̱nwaꞌ kimáꞌ iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Yéj yawi kitati se̱ ichoochi̱n, iwá̱n tikto̱ka̱wi̱j JESÚS, iga yéj yawi kima̱nawi̱ti ige̱ntej iga ayoꞌ makichijtoka̱n yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Inó̱n sucede̱roj iga mamochi̱wa kensan ikya kijtoj toTe̱ko ipan se̱ profeta kua̱ꞌ kijtoj ijkí̱n: ");
INSERT INTO nhx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Se̱ takotzi̱n yej aya kichijchimi ta̱gaꞌ, xo̱lo̱yowis iwá̱n kitas ichoochi̱n, moto̱ka̱wi̱j Emanuel, yej kijto̱jneki: Dios onoꞌ towa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Kua̱ꞌ José isaꞌ iga te̱miktoya, kichij kensan kijlij iyá̱ngel Dios iwá̱n kíkuiꞌya María iga isiwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Eꞌ José aya kitechowa̱ya María este iga onoko ikone̱ꞌ. Iwá̱n inó̱n kone̱ꞌ kito̱ka̱wijkej JESÚS. ");
INSERT INTO nhx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús onoko Belén, se̱ a̱ltepe̱ꞌ yej onoꞌ ipan estado de Judea. Íkua̱ꞌ manda̱rojtoya rey Herodes. Entonces asikej Jerusalén sekin tajta̱gaꞌ yej wa̱lkej iki̱sáya̱mpa to̱nati̱ꞌ. Ino̱mej tajta̱gaꞌ momachtijkej ken iga ojonokej si̱talimej, iwá̱n kijliáj Re̱yejma̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Iwá̱n tatajtantinemiáj: —¿Ka̱n onoꞌ irre̱y judiyojmej yej nacé̱rojoꞌ? Nejeme̱n nikitakej isi̱talin ne‑iga iki̱sáya̱mpa to̱nati̱ꞌ iwá̱n niwa̱lkej nikweyimati̱lti̱koj. ");
INSERT INTO nhx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kua̱ꞌ iní̱n kimatiꞌ rey Herodes ayꞌya kojasiá te̱ kichi̱waya, iwá̱n inewi gente de Jerusalén akojasiajoꞌ no̱ te̱ kichi̱wayaj. ");
INSERT INTO nhx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Iwá̱n Herodes kino̱tzaꞌ inochi ije̱fejmej sacerdo̱tejmej iwá̱n inochi yej tamachtiáj ipan iley Dios. Iwá̱n kitajtankej ka̱n yawi nace̱ro̱ti Cristo. ");
INSERT INTO nhx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yejeme̱n kijtojkej: —Yawi nace̱ro̱ti ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Belén yej onoꞌ ipan estado de Judea. El profeta kijkuiloj ijkí̱n: ");
INSERT INTO nhx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Tej, Belén, yej tonoꞌ ipan estado de Judá, malej iga ti‑a̱ltepe̱tzi̱n, eꞌ ayéj yej má̱j ti‑ali̱mpa, no̱ tivale̱rowa kensan ino̱mej wejweyi a̱ltepe̱ꞌ yej onoꞌ ipan estado de Judá; iga ipan tej yawi ki̱sati se̱ yej manda̱rowa, yej yawi kicuida̱ro̱ti noge̱ntej de Israel. ");
INSERT INTO nhx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Iwá̱n el rey Herodes kichtakano̱tzaꞌ yej kitakej si̱talin; íkua̱ꞌya kimati̱ltijkej ke̱man nokta ne̱siko in inó̱n si̱talin. ");
INSERT INTO nhx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Iwá̱n Herodes kiti̱tan Belén ino̱mej tajta̱gaꞌ, kijlijkej ijkí̱n: —Xa̱ka̱n Belén, xikte̱mo̱tij inó̱n chooli̱ntzi̱n este ka̱n xikasika̱n. Kua̱ꞌ ankasíkeja, xine‑ijli̱kij sej iga nej no̱ maniá manikweyimati̱lti̱ti. ");
INSERT INTO nhx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kua̱ꞌ tamiꞌ kikakikej yej kijtoj Herodes, Re̱yejma̱gojmej yájkija. Iwá̱n inó̱n si̱talin yej kitakej iki̱sáya̱mpa to̱nati̱ꞌ, tapano̱tia̱ya iwá̱n moketzato ka̱n nokta onoꞌ chooli̱ntzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Kua̱ꞌ kitakej inó̱n si̱talin poxsan yo̱lpa̱kikej. ");
INSERT INTO nhx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iwá̱n kalakkej kalijtiꞌ, iwá̱n kitakej chooli̱ntzi̱n iwá̱n María yej te̱ye̱ꞌ. Motankua̱ketzkej iwá̱n kiweyimati̱ltijkej chooli̱ntzi̱n. Iwá̱n yejeme̱n kiki̱xtijkej rega̱lojmej iga kimakakej chooli̱ntzi̱n, oro, incienso iwá̱n mirra yej ken bálsamo. ");
INSERT INTO nhx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Iwá̱n Dios kite̱miktij ino̱mej iga ayoꞌ nokta maya̱ka̱n ka̱n onoꞌ Herodes; inó̱n iga yejeme̱n yajkij sej icha̱mej, eꞌ ipan seꞌya ojti. ");
INSERT INTO nhx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Kua̱ꞌ re̱yejma̱gojmej yájkija, se̱ iyá̱ngel Dios kite̱mikti̱ko José, iwá̱n kijlij: —Ximoketza, xikui̱ga Egipto chooli̱ntzi̱n iwá̱n iye̱ꞌ. Ómpaoꞌ xonoka̱n este kua̱ꞌ sej nimitzno̱tzas. Porque Herodes yawi kite̱mo̱ti chooli̱ntzi̱n iga makimikti. ");
INSERT INTO nhx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Iwá̱n José moketzaꞌ tayowaka̱n, kiwi̱gaꞌ Egipto chooli̱ntzi̱n iwá̱n iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ompiga onoyaj este que miguiꞌ Herodes. Iní̱n mochij iga mamochi̱wa yej Dios kijtoj ipan se̱ profeta, ijkí̱n ijkuilijtoꞌ: “Este Egipto nikno̱tzaꞌ noPiltzi̱n.” ");
INSERT INTO nhx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kua̱ꞌ Herodes kimatiꞌ iga kikajkayajkej ino̱mej re̱yejma̱gojmej, poxsan kuejkuesiwiꞌ. Iwá̱n tatekimáꞌ iga makimijmikti̱tij nochi choolili̱n yej aya kipiáj o̱me años, yej cha̱ntitokej Belén iwá̱n ipan a̱ltepe̱mej yej najna̱ꞌsan onokej. Herodes kijtoj o̱me años, iga anka achó̱n a̱n kiwi̱gaya Jesús, ke̱ꞌsan kijtojkej re̱yejma̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Iwá̱n ompa mochij yej kijkuiloj el profeta Jeremías. Ijkí̱n ijkuilijtoꞌ: ");
INSERT INTO nhx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mokaguiꞌ iga wa̱ꞌtzajtzilo̱ꞌ ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Ramá. Cho̱kalo̱ꞌ iwá̱n poxsan mokno̱matilo̱ꞌ. Rake̱lwaꞌ in yej cho̱gaꞌ iga ipilowa̱n, iwá̱n awel moyo̱lta̱lij, iga ipilowa̱n kimijmiktilíjkeja. ");
INSERT INTO nhx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kua̱ꞌ miꞌya Herodes, se̱ iyá̱ngel Dios kite̱miktij José ompa Egipto, kijlij: ");
INSERT INTO nhx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Ximoketza, xikui̱ga chooli̱ntzi̱n iwá̱n iye̱ꞌ iwá̱n xaj sej Israel ka̱n amonoyaj iga mikíkeja ino̱mej yej kimikti̱jnekiáj chooli̱ntzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Iwá̱n José moketzaꞌ iwá̱n kiwi̱gaꞌ chooli̱ntzi̱n iwá̱n iye̱ꞌ ipan país de Israel. ");
INSERT INTO nhx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Eꞌ kua̱ꞌ José kimatiꞌ iga manda̱rówaya sej Arquelao yej ipíltzi̱mpa Herodes ipan ta̱jli de Judea, José majmawiꞌ iga yawi ompiga. Eꞌ Dios sej kite̱miktij, kijlij iga mayawi ipan estado de Galilea, iwá̱n ompiga yajkij. ");
INSERT INTO nhx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Kua̱ꞌ asikej ipan estado de Galilea, mocha̱nti̱toj ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Nazaret. Iní̱n mochij iga mamochi̱wa ken kijtojkej profe̱tajmej iga Jesús cha̱ntitos Nazaret. ");
INSERT INTO nhx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Inó̱n ve̱j Juan yej tabautiza̱rowa asiꞌ ipan desierto yej onoꞌ ipan estado de Judea iga kipowa ye̱ꞌnoti̱ciaj, ");
INSERT INTO nhx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","iwá̱n kijtowa̱ya: —Xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti iga ayoꞌ wejkatis iga Dios yawi reina̱ro̱ti ipan tejemej. ");
INSERT INTO nhx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","De ini̱nya Juan yej el profeta Isaías tajtoj, kua̱ꞌ kijtoj: Mokaki a̱ꞌpa tzajtzi ipan desierto, kijtowa: “Xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti, ijkó̱n ankitapowaj ojti iga toTe̱ko.” ");
INSERT INTO nhx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan kakijtinemiá itzótzol yej chijtoya iga itzojmiyo camello, iwá̱n tajko‑ilpitinemiá iga kuetax, iwá̱n kikua̱ya chapolin iwá̱n kuayojnekti. ");
INSERT INTO nhx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Iwá̱n ki̱skej de Jerusalén, de Judea iwá̱n inochi yej cha̱ntitoyaj najna̱ꞌsan we̱ya̱ꞌ Jordán iga kikakikoj Juan. ");
INSERT INTO nhx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iwá̱n kua̱ꞌ la gente mote̱nxitónkeja iga kichijkej yej aye̱kti, íkua̱ꞌya Juan kibautiza̱rowa̱ya ino̱mej ipan we̱ya̱ꞌ Jordán. ");
INSERT INTO nhx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eꞌ kua̱ꞌ Juan kitaꞌ iga nemi ya̱yaj miaꞌ fariseojmej iwá̱n saduceojmej iga no̱ mamobautiza̱ro̱ka̱n, kijlijkej: —¡Amejeme̱n ken nokta ipilowa̱n kowa̱mej! ¿A̱ꞌyéj mitzijlijkej iga anyawij anmoma̱nawi̱tij kua̱ꞌ Dios yawi tacastiga̱ro̱ti? ");
INSERT INTO nhx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xiye̱ꞌnemika̱n iga mane̱si iga ankikajtéjkeja iga ankichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Amo ximoweyimatika̱n iga ankijtowaj: “Nejeme̱n no‑ikyapatajwe̱wejmej Abraham”; ¡Nimitzijliáj iga ini̱mej temej Dios wel kichi̱wa ipilowa̱n Abraham! ");
INSERT INTO nhx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Há̱chajwaꞌ ónoꞌya iga yawi motzojtzontekiti kuawimej este ipan inelwayomej. Inochi kuawiꞌ yej ayá̱ꞌ ye̱ꞌta̱ki, motzonteki iwá̱n moakiá tiko. ");
INSERT INTO nhx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nej nimitzbautiza̱rowaj iga a̱ꞌti, iga mane̱si iga anmoyo̱lpatákeja. Eꞌ yej wi̱‑oꞌ, yawij mitzbautiza̱ro̱tij iga el Espíritu Santo iwá̱n iga tiꞌti. Yéj kipiá má̱j poder que nej, iwá̱n nej ni alí̱n ayá̱ꞌ neajasi iga manikui̱guili igaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yéj kiki̱tzkijtoꞌ yej iga kichijchi̱wa trigo iga kitasolki̱xtiá. Iwá̱n trigo ka̱nas ka̱n moa̱na; eꞌ itasolyo kitati̱j ipan tiꞌti yej ayí̱ꞌ se̱wis. ");
INSERT INTO nhx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Iwá̱n Jesús ki̱saꞌ Galilea, iwá̱n asito ka̱n Juan tabautiza̱rojtoya ipan we̱ya̱ꞌ Jordán, iga no̱ mamobautiza̱ro. ");
INSERT INTO nhx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Eꞌ Juan akinekiá makibautiza̱ro, kijlij: —¿Te iga tiwi̱ꞌ iga nej manimitzbautiza̱ro? Nejwaꞌ in yej nikneki iga tej xine̱bautiza̱ro. ");
INSERT INTO nhx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Eꞌ Jesús kijlij Juan: —Iná̱n tej amo te̱ xikijto; iga ijkó̱n kajasi iga matikchi̱waka̱n inochi ken Dios kineki. Iwá̱n Juan mote̱máꞌ iga kibautiza̱roj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kua̱ꞌ Jesús tamiꞌ mobautiza̱roj, ki̱saꞌ ipan a̱ꞌti. Iwá̱n tapowiꞌ cielo, iwá̱n kitaꞌ iyEspí̱ritoj Dios temoj, ken tikita se̱ jojtoko, iwá̱n moketzako iyakapan. ");
INSERT INTO nhx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Iwá̱n mokaguiꞌ ipan cielo se̱ tájto̱l yej kijtoj: —Iní̱n nokta in noPiltzi̱n yej nikpoxcho̱kiliá, iwá̱n yéj ne̱yo̱lchikajtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Iwá̱n iyEspí̱ritoj Dios kiwi̱gaꞌ Jesús ipan desierto ka̱n ayá̱ꞌ cha̱ntitolo̱ꞌ, iga ompiga Tzitzimiꞌ makita siga ayá̱ꞌ kichi̱walti̱j yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús ayá̱ꞌ takuaj cuarenta días iwá̱n cuarenta yówal, iwá̱n maya̱naꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Iwá̱n Tzitzimiꞌ kitechoj Jesús. Tzitzimiꞌ kinekiá iga Jesús makichi̱wa yej aye̱kti, kijlij: —Siga tejya nokta iPiltzi̱n Dios, xikijli ini̱mej temej iga mamochi̱waka̱n pa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Eꞌ Jesús kijlij Tzitzimiꞌ: —Ijkí̱n ijkuilijtoꞌ itájto̱l Dios: “Ayá̱ꞌ gasan tákual wel ono ta̱gaꞌ, no̱ wel ono iga kichi̱wa ken kijtowa itájto̱l Dios.” ");
INSERT INTO nhx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Iwá̱n Tzitzimiꞌ kiwi̱gaꞌ Jesús ipan weyi‑a̱ltepe̱ꞌ Jerusalén, kitejkawi̱ltij este iyi̱xko, ka̱n má̱j ajko ipan inó̱n weyitio̱pan, ");
INSERT INTO nhx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","iwá̱n kijtoj Tzitzimiꞌ: —Siga tejya nokta ipiltzi̱n Dios, este nigaj ximopata̱nalti ta̱lpan; iga itájto̱l Dios ijkí̱n ijkuilijtoꞌ: Dios kiti̱tanis iya̱ngelejmej iga mamitzpale̱wi̱ka̱n, iga mamitzmajkuitia̱ka̱n iga amo ximokxiwi̱teki ipan teꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús kijtoj: —No̱ ijkuilijtoꞌ itájto̱l Dios: “Amo xiktajtanili moTe̱ko Dios iga makichi̱wa tejté̱ iga san mane̱si iga wel kichi̱wa.” ");
INSERT INTO nhx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seꞌ ve̱j Tzitzimiꞌ kiwi̱gaꞌ Jesús ipan se̱ tepe̱ꞌ yej pox ajko, iwá̱n kine̱xtilij inochi pai̱smej yej onoꞌ ipan iní̱n ta̱jli iwá̱n inochi yej kipiáj; ");
INSERT INTO nhx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","iwá̱n kijtoj Tzitzimiꞌ: —Nej nimitzmakas inewi iní̱n siga timotankua̱ketza iga xine̱weyimati̱lti. ");
INSERT INTO nhx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Iwá̱n Jesús kijlij: —Tzitzimiꞌ, xicholo note̱noj, iga ijkí̱n ijkuilijtoꞌ itájto̱l Dios: “Xikweyimati̱lti moTe̱ko Dios iwá̱n xikchi̱wa kensan yéj kineki.” ");
INSERT INTO nhx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iwá̱n Tzitzimiꞌ kikájteja Jesús. Iwá̱n wa̱lkej a̱ngelejmej iga kipale̱wi̱koj in Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kua̱ꞌ Jesús kimatiꞌ iga Juan kipre̱sojwijkej, yajki ipan estado de Galilea. ");
INSERT INTO nhx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Eꞌ ayá̱ꞌ ka̱wiꞌ Nazaret ka̱n ícha̱n katka, sino que yajki mocha̱nti̱to ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Capernaum. Inó̱n a̱ltepe̱ꞌ onoya ipan a̱te̱n iwá̱n ipan íta̱l Zabulón iwá̱n Neftalí. ");
INSERT INTO nhx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ijkí̱n kichij Jesús iga mamochi̱wa yej el profeta Isaías ijkí̱n kijkuiloj: ");
INSERT INTO nhx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Íta̱l Zabulón iwá̱n Neftalí, ipan inó̱n ojti yej yawi láma̱r, iyi̱ka̱mpa we̱ya̱ꞌ Jordán, ipan Galilea ka̱n cha̱ntitokej yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ino̱mej gente yej ken onoyaj ka̱n takomichka̱n iga ayá̱ꞌ ki̱xmatiáj Dios, ken tikita kita̱wijkej se̱ weyi ta̱wi̱lyo̱ꞌ iga asiꞌ itájto̱l Dios. Ino̱mej majmatoyaj iga mamikika̱n, eꞌ iná̱n kita̱wíjkeja weyi ta̱wi̱lyo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Iwá̱n íkua̱ꞌya Jesús pe̱waꞌ kipowa itájto̱l Dios, kijtoj: —Xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti iga ayoꞌ wejka̱was iga yawi reina̱ro̱ti Dios. ");
INSERT INTO nhx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús nejnentia̱ya ipan a̱te̱n laguna yej ito̱ka̱ꞌ Galilea. Ompa kitaꞌ Simón yej no̱ ito̱ka̱ꞌ Pedro, iwá̱n Andrés yej iyíkni̱mpa. Yejeme̱n atarraye̱rojmej. Iwá̱n ompa atarraya̱rojtoyaj ipan inó̱n a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iwá̱n Jesús kijlij ino̱mej: —Xine̱tokaka̱n, iwá̱n nikchi̱was iga ankinechko̱skej yej mane̱tokaka̱n ken iná̱n to̱poj ankiki̱tzkiáj. ");
INSERT INTO nhx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Iwá̱n imaní̱n kikajtejkej iyatarra̱yajmej iwá̱n kitokákeja Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iwá̱n achi má̱j nejnenkej, kitakej o̱me̱n tajta̱gaꞌ, Jacobo iwá̱n Juan yej ipilówa̱mpa Zebedeo. Ompa onoyaj ipan á̱ka̱l iwá̱n itaj. Ompa kitamanijtoyaj iyatarra̱yajmej. Iwá̱n Jesús kino̱tzaꞌ in ino̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Iwá̱n íkua̱ꞌsan ompa kikajtejkej itaj iwá̱n á̱ka̱l. Iwá̱n kitokákeja Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús panoj no̱ya̱n ipan estado de Galilea, tamachtijtinemiá ipan tio̱pamej yej ojonoyaj ipan a̱ltepe̱mej. Kipowaya ye̱ꞌnoti̱ciaj ken iga Dios yawi reina̱ro̱ti. Iwá̱n kachitialtij nochi yej se̱seꞌpa iga we̱titoyaj. ");
INSERT INTO nhx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Iwá̱n no̱ya̱n momatiꞌ ipan estado de Siria, iga Jesús taachitialtijtinemiꞌ, iwá̱n no̱ kiwi̱guilijkej yej kipiayaj de se̱seꞌpa kokolis, yej kuajkualoj, yej ta̱tapoliwij, yej kipiayaj ma̱lespí̱ritoj iwá̱n yej ikxitakua̱wayaxtoyaj. Iwá̱n nochi ini̱mej kachitialtij Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Miaꞌ de Galilea kitokakej Jesús, yej cha̱ntitoyaj ipan íta̱l diez a̱ltepe̱ꞌ yej kijliáj Decápolis, iwá̱n de Jerusalén iwá̱n inewi no̱ de Judea, iwá̱n ino̱mej yej cha̱ntitokej iyi̱ka̱mpa we̱ya̱ꞌ Jordán. ");
INSERT INTO nhx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Kua̱ꞌ Jesús kitaꞌ inewi gente yej kitokatinemiáj, tejkaj ipan se̱ tepe̱ꞌ iwá̱n ompa mota̱lij. Iwá̱n idisci̱polojmej kiyawalojkej. ");
INSERT INTO nhx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Iwá̱n Jesús pe̱waꞌ kimachtij idisci̱polojmej, ijkí̱n kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Pa̱kij yej kimachi̱liáj ipan iya̱lmajmej iga yejéme̱nsan awel te̱ kichi̱waj iwá̱n ijko̱nya iga kite̱mowaj Dios, iga yejéme̱nya kipiaskej Dios iga iTe̱komej. ");
INSERT INTO nhx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Pa̱kij yej cho̱kaj, Dios yawi kiyo̱lchika̱wati ino̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Pa̱kij yej moali̱mpamatij, iga yejeme̱n mochi̱waskej itatki inó̱n ta̱jli yej Dios kijtoj iga kimakaskej. ");
INSERT INTO nhx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Pa̱kij yej kipoxyo̱lmakatokej iga kichi̱wasnekij yej ye̱kti, ino̱mej sí, Dios kipale̱wi̱j. ");
INSERT INTO nhx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Pa̱kij yej ta‑ikne̱liáj, iga Dios yawi no̱ kikne̱li̱tij ino̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Pa̱kij yej ipan iya̱lmajmej kejla̱ntokej yej ye̱kti, yejeme̱n sí kitaskej Dios. ");
INSERT INTO nhx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Pa̱kij yej kinekij iga maonolo tamelá̱, iga Dios kijli̱j iga yéj ipilowa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Pa̱kij yej kikno̱chi̱waj iga san kichi̱waj yej Dios kineki, iga yejéme̱nya kipiaskej Dios iga iTe̱komej. ");
INSERT INTO nhx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Xipa̱ktoka̱n kua̱ꞌ mitzijijliáj kuajkuantas iwá̱n kua̱ꞌ mitzikno̱chi̱waj iwá̱n kua̱ꞌ mitzpantiáj iga ankichi̱waj yej aye̱kti, iga san nej anne̱tokaj. ");
INSERT INTO nhx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","’Xipa̱ktoka̱n iga ipan cielo yawij mitzmakatij yej pox ye̱kti; iga ijkó̱n no̱ kikno̱chijkej profe̱tajmej yej ikya onoyaj. ");
INSERT INTO nhx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Amejeme̱n ipan iní̱n ta̱jli ken tikita an‑istamej. Eꞌ siga istaꞌ ayoꞌ istawe̱liꞌ, ¿téjasoꞌ iga moneki? Ayoꞌ ye̱kti iga nité̱, sino que motajkáliya iwá̱n mota̱táksaya. ");
INSERT INTO nhx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Amejeme̱n no̱ ken anta̱wi̱lmej ipan iní̱n ta̱jli. Se̱ weyi‑a̱ltepe̱ꞌ yej onoꞌ iyi̱xko tepe̱ꞌ awel mi̱ya̱na. ");
INSERT INTO nhx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Niga motatiá se̱ cándi̱l iga mamota̱li itampa tejté̱, ma̱jwaꞌ mota̱liá ajko iga makita̱wi yej onokej kalijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ijko̱nsan no̱ amejeme̱n xikchi̱waka̱n yej ye̱kti iyi̱xtaj la gente, iwá̱n kua̱ꞌ mitzitaskej iga ankichijtokej yej ye̱kti, kiweyimati̱lti̱skej toTaj Dios yej onoꞌ ajko. ");
INSERT INTO nhx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Amo ankijto̱skej iga niwa̱laj iga nikpolo̱ko iley Moisés o ka̱n tamachtijkej profe̱tajmej. Nej ayá̱ꞌ inó̱n nikchi̱wako, ma̱jwaꞌ nikchi̱wako ken iga nokta kajasi iga mamochi̱wa ken tatekimakaj. ");
INSERT INTO nhx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Iwá̱n no̱ nimitznojma‑ijliáj, mie̱j iga onos cielo iwá̱n ta̱jli, nisé̱ punto nisé̱ letra awel mopolowa ipan iley Moisés, este que nochi mamochi̱wa yej mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Inó̱n iga yej kiyokakajte̱wa iga kichi̱wa ken tatekimaka se̱ iley Dios, malej iga inó̱n ley né̱sikiꞌ ayá̱ꞌ má̱j te̱ te‑ijliá, wa̱n ijkó̱n matamachti, inó̱n mo‑itas ken yej ayéj te̱ iteki ka̱n reina̱rowa Dios. Eꞌ yej makichi̱wa ken ijkuilijtoꞌ la ley iwá̱n ijko̱nsan no̱ kine̱xtiliá sekin iga makichi̱waka̱n, inó̱n má̱j kiye̱ꞌitaskej ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Iwá̱n no̱ nimitzijliáj, siga ayá̱ꞌ má̱j anye̱ꞌnemij que fariseojmej iwá̱n ken yej tamachtiáj ipan la ley, nike̱man ayá̱ꞌ ankalakiskej ka̱n Dios reina̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ankikakíkeja ken kijlijkej amo‑ikyapatajwa̱n iga: “Amo xitamikti, siga agaj tamiktiá, makimikti̱ka̱n.” Ijkó̱n kijtoj iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Eꞌ iná̱n nimitzijliáj igasan se̱ mamokuejkueso iwá̱n iyikni̱n, Dios yawi kijuzga̱ro̱ti. Iwá̱n yej kijliá iyikni̱n: “Tixe̱toꞌ”, inó̱n kiki̱tzki̱skej yej má̱j manda̱rowaj. Iwá̱n yej kijliá iyikni̱n: “Tipáchto̱l”, ya̱ti ka̱n onoꞌ tiwelo̱n yej ayí̱ꞌ se̱wi. ");
INSERT INTO nhx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Siga tia tikmakati iyofre̱ndaj Dios ipan altar iwá̱n tikejla̱nte̱wa iga mitzkuesowilijtoꞌ mokni̱n, ");
INSERT INTO nhx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ómpaoꞌ xikajte̱wa moofre̱ndaj ite̱noj altar iwá̱n xaj achto ximoyo̱lta̱li̱ti iwá̱n mokni̱n. Íkua̱ꞌya sí welja tikta̱li̱ti moofre̱ndaj. ");
INSERT INTO nhx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Siga agaj mitzdemanda̱rowa iwá̱n mitzwi̱gaj iyi̱xtaj juez, ipan ójtisan ximotajto̱lti iga ximoyo̱lta̱li íwa̱n. Porque siga mitzwi̱ga iyi̱xtaj juez, juez kitekimakas policiyajmej iga mitzaki̱skej kuákalko. ");
INSERT INTO nhx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nimitzijliá iga atiki̱sas ompa este que xikixta̱wa inewi ke̱ꞌ mitztajtaniliáj. ");
INSERT INTO nhx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Moisés este ikyay kijtoj: “Yej na̱miktitoꞌ amo mayawi wa̱n seꞌ.” ");
INSERT INTO nhx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Eꞌ nej nimitzijliáj siga se̱ ta̱gaꞌ kitachi̱liá se̱ siwa̱ꞌ iwá̱n ipan iya̱lmaj kinekiskia̱ya maguiꞌ mamásiya íwa̱n, ini̱nwaꞌ taxí̱maꞌya nokta, malej iga kejla̱n ipansan iya̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Siga se̱ moyi̱x mitzchi̱waltiá yej aye̱kti, xiki̱xti iwá̱n xiktajkali wejka; má̱j ye̱kti xikpolo se̱ moyi̱x que inochi mocue̱rpoj makaki̱ka̱n pan tiwelo̱n yej ayí̱ꞌ se̱wis. ");
INSERT INTO nhx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Siga moye̱ꞌma̱ꞌ mitzchi̱waltiá yej aye̱kti, xiktzonteki iwá̱n xiktajkali wejka; má̱j ye̱kti xikpolo se̱ moma̱ꞌ que inochi mocue̱rpoj makaki̱ka̱n pan tiwelo̱n yej ayí̱ꞌ se̱wis. ");
INSERT INTO nhx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Moisés no̱ este ikyay kijtoj: “Siga se̱ ta̱gaꞌ kika̱wa isiwa̱ꞌ, makimaka se̱ a̱maꞌ ka̱n makijto iga mokájkeja.” ");
INSERT INTO nhx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Eꞌ nej nimitzijliáj yej kiyokaka̱wa isiwa̱ꞌ malej iga isiwa̱ꞌ ayá̱ꞌ nemi yawi wa̱n seꞌ, inó̱n ta̱gaꞌ kichi̱wa iga isiwa̱ꞌ mamasi wa̱n seꞌ; iwá̱n inó̱n seꞌ ta̱gaꞌ yej íwa̱n mona̱mikti̱j no̱ taxi̱ma. ");
INSERT INTO nhx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’No̱ ankimatij iga amo‑ikyapatajwa̱n kijlijkej: “Amo xike̱lka̱wa iga tikchi̱wa yej iyi̱xtaj toTe̱ko tikijtoj nokta iga tikchi̱was.” ");
INSERT INTO nhx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Eꞌ nej nimitzijliáj iga amo xikta̱li̱ka̱n agaj o tejté̱ iga testigo kua̱ꞌ ankijtowaj iga ankichi̱waskej tejté̱. Niga cielo iga ompa manda̱rowa Dios; ");
INSERT INTO nhx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","niga ta̱jli iga ompa kita̱liá iyikxi Dios; niga Jerusalén iga ino̱nwaꞌ iciudad el Rey yej kipoxweyimatij. ");
INSERT INTO nhx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Niga motzontekon, iga tej awel tikchi̱wa iga se̱ motzónkal mamochi̱wa ista̱ꞌ o pi̱stiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Má̱j ye̱kti iga xikijto “kena” kua̱ꞌ tikmati iga tia tikchi̱wati, iwá̱n xikijto “ayá̱ꞌ” kua̱ꞌ tikmati iga ayá̱ꞌ tia tikchi̱wati. Yej ayá̱ꞌ ijkó̱n kichi̱wa, kichi̱wa yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Moisés este ikyay kijtoj: “Siga agaj mitzi̱xkope̱wa, no̱ xiki̱xkope̱wa, iwá̱n siga agaj mitztankope̱wa, no̱ xiktankope̱wa.” ");
INSERT INTO nhx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Eꞌ nej nimitzijliáj iga amo ijko̱nsan no̱ xikchi̱wili yej mitzchi̱wiliá yej aye̱kti; ma̱jwaꞌ siga agaj mitzxa̱ygatatzi̱na, xikmaka seꞌ moxa̱yaꞌ iga mamitzmaga. ");
INSERT INTO nhx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Iwá̱n siga agaj mitzdemanda̱rowa iwá̱n mitzkui̱liá mokua̱ch, xikmaka no̱ makiwi̱ga mochama̱rraj. ");
INSERT INTO nhx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Iwá̱n siga agaj mitztekimaka iga xikui̱guili tejté̱ yej eti̱ꞌ se̱ kilómetro, tej xikui̱ga o̱me kilómetro. ");
INSERT INTO nhx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Siga agaj mitztajtaniliá tejté̱, xikmaka. Agaj yej kineki mitzta̱ke̱wiliá tejté̱, amo xikijli iga ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Moisés este ikyay kijtoj: “Xikcho̱kili mokni̱n iwá̱n xikijiya yej mitzijiya.” ");
INSERT INTO nhx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Eꞌ nej nimitzijliáj xikcho̱kili̱ka̱n yej mitzijiyaj, xikye̱ꞌijli̱ka̱n yej mitzma̱lijliáj, xikchi̱wili̱ka̱n yej ye̱kti yej ayá̱ꞌ mitzye̱ꞌitaj, xiktajtanili̱ka̱n Dios iga maye̱ꞌonoka̱n ino̱mej yej mitzpantiáj iwá̱n mitzikno̱chi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ijkó̱n amejeme̱n anmochi̱waskej ipilówa̱mpa amoTaj Dios yej onoꞌ ipan cielo; iga yéj kichi̱wa iga mata̱wi to̱nati̱ꞌ ka̱n onoꞌ yej kichi̱wa yej ye̱kti iwá̱n yej kichi̱wa yej aye̱kti, iwá̱n kiti̱tani no̱ tiawa̱ꞌ iga yej ye̱ꞌnemij iwá̱n iga yej ayompa nemij. ");
INSERT INTO nhx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eꞌ siga amejeme̱n ankicho̱kiliáj yejsan no̱ mitzcho̱kiliáj, ¿té̱ anmo̱ta̱niliáj iga ijkó̱n ankichi̱waj? Este yej kicobra̱rowaj impuesto iga Roma ijkó̱n no̱ kichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Iwá̱n siga ankisaluda̱rowaj yejsan amokni̱n, ijkó̱n ayá̱ꞌ nemi ankichi̱waj tejté̱ yej sekin no̱ akichi̱waj. Ijkó̱n no̱ kichi̱waj yej ayá̱ꞌ ki̱xmatij Dios. ");
INSERT INTO nhx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xipoxye̱ꞌnemika̱n, ijkó̱n kensan amoTaj Dios yej onoꞌ ipan cielo nochipa kichi̱wa yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesús no̱ kijtoj: —Kua̱ꞌ ankichi̱waj tejté̱ yej ye̱kti, amo xikchi̱waka̱n iga san mamitzitaka̱n. Siga ijkó̱n ankichi̱waj, amoTaj Dios yej onoꞌ ipan cielo ayá̱ꞌ mitzmakaskej nité̱. ");
INSERT INTO nhx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kua̱ꞌ tikpale̱wiá agaj yej amotapialiá, amo xikpojtinemi ken kichi̱waj ino̱mej yej mopajpantiáj iga ye̱ꞌnemij iga kipojtinemij tio̱pan‑ijtiꞌ iwá̱n kajka̱n pano̱lo iga makiweyimati̱lti̱ka̱n. Nimitzijliáj iga ino̱mej ino̱nsan mota̱niliáj, iwá̱n Dios ayá̱ꞌ kiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Eꞌ tej kua̱ꞌ agaj tikpale̱wiá yej amotapialiá, amo xikmati̱lti ni agaj. ");
INSERT INTO nhx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ma̱jwaꞌ xikchi̱wa ichtákasan. Iwá̱n Dios yej mitzitztoꞌ iga ichtákasan nemi tikchi̱wa yawi mitzmakati yej pox ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Kua̱ꞌ antajtowaj wa̱n Dios, amo xikchi̱waka̱n ken ino̱mej yejsan mopajpantiáj iga ye̱ꞌnemij, ino̱mej kiye̱ꞌmatij iga ejkati‑ora̱dowaj tio̱pan‑ijtiꞌ iwá̱n ipan calle ka̱nsan makitaka̱n. Nimitznojma‑ijliáj iga ini̱mej ino̱nsan mota̱niliáj, iwá̱n Dios ayá̱ꞌ kikakij. ");
INSERT INTO nhx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Eꞌ tej kua̱ꞌ titajtowa wa̱n Dios, xikalaki kalijtiꞌ, iwá̱n ximokaltzakua iwá̱n xitajto wa̱n Dios yej ompa onoꞌ mowa̱n. Iwá̱n Dios yej mitzitztoꞌ ka̱n ichtákasan nemi ti‑ora̱dowa, yawi mitzmakati yej tiktajtani. ");
INSERT INTO nhx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Kua̱ꞌ titajtowa iwá̱n Dios, amo xikojpa‑ijto tajto̱lmej yej ayá̱ꞌ mitzpale̱wiá ka̱nsan mawejka̱wa iga tita̱tapojtoꞌ iwá̱n Dios, ken kichi̱waj yej ayá̱ꞌ ki̱xmatij Dios. Yejeme̱n a̱n kijtowaj iga ijkó̱n kichi̱waj, ma̱jya kikakiskej Dios. ");
INSERT INTO nhx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amo xikchi̱waka̱n ken yejeme̱n; iga amoTaj Dios kimátiya te̱ mitzpolowaj malej iga aya ankitajtaniliáj. ");
INSERT INTO nhx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Amejeme̱n ijkí̱n xitajto̱ka̱n iwá̱n Dios: NoTaj yej tonoꞌ ipan cielo, nochi makiweyimati̱lti moto̱ka̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Xirreina̱ró̱kiya. Mamochi̱wa ken tej tikneki ipan ta̱jli, ijkó̱n ken mochijtoꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Notakualmej yej nochipa moneki, xine̱makaka̱n a̱man. ");
INSERT INTO nhx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Xinee̱lka̱wili̱ka̱n yej nikchijkej yej aye̱kti, ijkó̱n ken nejeme̱n no̱ nike̱lka̱wiliáj yej ne̱chi̱wilijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Xine̱pale̱wi̱ka̱n iga amo manikchi̱wasnekika̱n yej aye̱kti; amo xine̱semakaka̱n kua̱ꞌ Tzitzimiꞌ ne̱chi̱walti̱jnekij yej aye̱kti. Iga tej nokta yej tirreina̱rowa, iwá̱n tej yej nochi wel tikchi̱wa iwá̱n inó̱n moweyipode̱r nochipa nokta onos. Ijkó̱nyawaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Siga anke̱lka̱wiliáj yej agaj mitzchi̱wiliáj yej aye̱kti, amoTaj yej onoꞌ ipan cielo no̱ mitze̱lka̱wili̱skej yej ankichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Eꞌ siga ayá̱ꞌ anke̱lka̱wiliáj yej mitzchi̱wiliáj yej aye̱kti, amoTaj ayá̱ꞌ no̱ mitze̱lka̱wili̱skej yej aye̱kti ankichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Kua̱ꞌ anmayuna̱rowaj, amo mane̱si iga anmokno̱matij ken ino̱mej yej san mopajpantiáj iga ye̱ꞌnemij. Yejemej kinekij makitaka̱n iga mayuna̱rojtokej. Eꞌ nimitznojma‑ijliáj iga yej inó̱n kichi̱waj, kipiaja yej mota̱nilijkej. ");
INSERT INTO nhx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Eꞌ tej kua̱ꞌ timayuna̱rowa, ximotzijtzikui iwá̱n ximi̱xa̱mi, ");
INSERT INTO nhx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","iga amo mane̱si iga timayuna̱rojtoꞌ. Petz moTaj Dios yej ichtákasan mowa̱n onoꞌ, yéjsan kimatis yej nemi tikchi̱wa. Iwá̱n iyi̱xtaj tokni̱wa̱n mitzmakas yej kajasi iga mamitzmaka. ");
INSERT INTO nhx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Amo xiknejnechko̱ka̱n yej pox vale̱rowa nigaj ipan ta̱jli ka̱n wel kitolowa we̱chi iwá̱n wel ankine̱mpolo̱skej, iwá̱n ka̱n wel kalakij yej tachtekij. ");
INSERT INTO nhx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Má̱j ye̱kti xiknejnechko̱ka̱n ipan cielo komati yej pox vale̱rowa. Ompa ateyi we̱chi yej tane̱mpolowa, iwá̱n niga no̱ yej tachtekij ayꞌya kalakiskej. ");
INSERT INTO nhx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porque ka̱n onoꞌ yej mitzyo̱ltila̱na ompa nochipa tikejla̱ntos. ");
INSERT INTO nhx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Moyi̱x ken tikita se̱ cándi̱l yej mitzta̱wiá; siga moyi̱x ye̱kti, mitzta̱wijtos. ");
INSERT INTO nhx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Eꞌ siga moyi̱x aye̱kti, tonos ken kua̱ꞌ takomichka̱n. Siga inó̱n cándi̱l yej tikpiá ayá̱ꞌ ta̱wiá, poxsan titako̱mititos. ");
INSERT INTO nhx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Ayagaj wel kipiá o̱me ipatró̱n, iga sé̱sanwaꞌ in yej kiye̱ꞌitas, iwá̱n seꞌ kijiyas, o se̱ kitokas iwá̱n seꞌ kikajte̱was. Inó̱n iga awel ankitokaj Dios siga mitzyo̱ltila̱naj tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Nimitzijliáj: Amo xitayo̱koyaka̱n iga te̱ anyawij ankikua̱tij iwá̱n te̱ anyawij ankoni̱tij iga wel xonoka̱n, niga amotzótzol yej ankaki̱skej. ¿Ix aya̱ꞌtaj má̱j vale̱rowa amovi̱daj que tákual, iwá̱n amocue̱rpoj má̱j que tzótzol? ");
INSERT INTO nhx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ximi̱xkui̱ti̱ka̱n ipan to̱to̱mej yej pata̱ntinemij; yejeme̱n ayá̱ꞌ to̱kaj niga tapixkaj iwá̱n ayá̱ꞌ no̱ ke̱naj yej mopixka. Eꞌ malej ijkó̱n, Dios yej amóTajpa kitamaka no̱ ino̱mej to̱to̱mej. ¡Amejeme̱n má̱j anvale̱rowaj que to̱to̱mej! ");
INSERT INTO nhx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Iwá̱n a̱ꞌ de amejeme̱n iga san matayo̱koya wel weyás seꞌ alí̱n? ");
INSERT INTO nhx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Iwá̱n, ¿te iga no̱ amejeme̱n antayo̱koyaj iga amotzótzol? Taꞌ xikitaka̱n ken iga weyáj xo̱chimej ipan a̱ka̱walyoj, ayá̱ꞌ tekipanowaj niga tajtzomaj. ");
INSERT INTO nhx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Eꞌ nimitzijliáj niga el rey Salomón malej iga moye̱ꞌtaajakia̱ya; ayá̱ꞌ kaxilij ken ino̱mej xo̱chimej yej mojmo̱nsajtikej. ");
INSERT INTO nhx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iwá̱n siga Dios ijkó̱n kimo̱nsajchi̱wa kuaxiwiyoj yej a̱man onoꞌ ipan a̱ka̱walyoj iwá̱n mo̱sta tatas ipan tiꞌti, ¿kén iga ayá̱ꞌ mitztzotzolyo̱ti̱skej, amejeme̱n yej alí̱n anmoconfia̱rowaj ipan Dios? ");
INSERT INTO nhx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Inó̱n íga amo xitayo̱koyaka̱n iwá̱n amo xikijto̱ka̱n: “¿Te̱ niawij nikua̱tij? o ¿te̱ niawij nikoni̱tij? iwá̱n ¿ka̱n niawij nikasitij notzotzolmej yej nikajaki̱skej?” ");
INSERT INTO nhx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yej ayá̱ꞌ ki̱xmatij Dios tayo̱koyaj iga nochi iní̱n; eꞌ amejeme̱n ankipiáj se̱ amoTaj yej onoꞌ ipan cielo yej kimati te̱ mitzpolowaj amocha̱n. ");
INSERT INTO nhx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Eꞌ ximote̱makaka̱n iga Dios marreina̱ro ipan amejeme̱n, iwá̱n xikchi̱waka̱n ken yéj kineki, iwá̱n ijkó̱n nochi ini̱mej yej mitzpolowaj, anyawij ankipiatij. ");
INSERT INTO nhx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Amo xitayo̱koyaka̱n iga yej mo̱stapa mochi̱was, yej mo̱stapa, mó̱stapaya sej ankitaskej. Onoꞌ komati yej te̱yo̱lmiktiá ipan sejsé̱ día. ");
INSERT INTO nhx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Amo xitajuzga̱ro̱ka̱n, iga Dios amo no̱ mamitzjuzga̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Iga Dios yawi mitzjuzga̱ro̱tij ijkó̱n kensan sekin ankijuzga̱rowaj. Achó̱n ke̱ꞌ agaj ankimakaskej, acho̱nsan no̱ Dios mitzmakaskej. ");
INSERT INTO nhx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Te iga tiki̱xtachi̱liá mokni̱n iga kipiá tasoltzi̱n ipan iyi̱x iwá̱n ayá̱ꞌ tikita iga tej tikpiá tapan ipan moyi̱x? ");
INSERT INTO nhx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Siga ayá̱ꞌ tikita iga tikpiá weyi tapan ipan moyi̱x, ¿kén timi̱xe̱wiá iga tikijliá mokni̱n: “Nokni̱n, achi manimitzki̱xtili tasoltzi̱n yej tikpiá ipan moyi̱x”? ");
INSERT INTO nhx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Tej yej timopajpantiáj iga tiye̱ꞌnemi!, xiki̱xti achto inó̱n tapan yej onoꞌ ipan moyi̱x iwá̱n ijkó̱n wel tikye̱ꞌitas iga tiki̱xtiliá tásol ipan iyi̱x mokni̱n. ");
INSERT INTO nhx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Yej itatki Dios amo xikmakaka̱n pe̱lomej, amo santá̱ꞌ mitztza̱tzaya̱naskej. Yej pox patiyoj amo xikmakaka̱n koyame̱mej iga amo makita̱taksaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xiktajtanika̱n, iwá̱n Dios mitzmakaskej; xikte̱mo̱ka̱n iwá̱n ankasiskej; xikaltzotzonaka̱n iwá̱n mitzkaltapowili̱skej. ");
INSERT INTO nhx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Iga yej kitajtani, kimakaj; iwá̱n yej kite̱mowa, kasi; iwá̱n yej kaltzotzona, kikaltapowiliáj. ");
INSERT INTO nhx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿Ix wel se̱ de amejeme̱n kimakas ipiltzi̱n se̱ teꞌti kua̱ꞌ kitajtaniliá tákual? ");
INSERT INTO nhx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O ix kimakas kowa̱ꞌ kua̱ꞌ kitajtaniliá se̱ to̱poj? ");
INSERT INTO nhx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Siga amejemej yej ankichi̱waj yej aye̱kti, wel ankimakaj yej ye̱kti amopilowa̱n, ¡amoTaj yej onoꞌ ajko ipan cielo, má̱j kimakas yej ye̱kti a̱ꞌsan iga kitajtanili̱j! ");
INSERT INTO nhx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Ijkó̱n ken amejeme̱n ankinekij mamitzchi̱wili̱ka̱n sekin, ijkó̱n no̱ amejeme̱n xikchi̱wili̱ka̱n; ijkó̱n kijtowa iley Moisés iwá̱n yej kijkuilojkej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Xikalakika̱n ipan kalte̱n yej tzo̱ltiꞌ. Iga kalte̱n iwá̱n ojti yej tawi̱ga ka̱n mopojpolo̱lo, kojkoyaktiꞌ, iwá̱n miaꞌ yej ompa yawij. ");
INSERT INTO nhx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Eꞌ kalte̱n iwá̱n ojti yej tawi̱ga ka̱n onoꞌ Dios, poxsan tzo̱ltiꞌ, iwá̱n ayá̱ꞌ miaꞌ yej ompa yawij. ");
INSERT INTO nhx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Amo mamitzkajkaya̱waka̱n yej kijtowaj iga Dio̱skiꞌ kitajto̱lmakaj. Ini̱mej né̱sikiꞌ até̱ wel mitzchi̱wiliáj, eꞌ má̱j ipan iya̱lmajmej ken tikita te̱kua̱nimej. ");
INSERT INTO nhx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Amejeme̱n wel anki̱xmatij ken iga nemi agaj ipansan yej kichi̱waj; puej ayá̱ꞌ moteki uva ipan witztako̱ꞌ, niga no̱ moteki ita̱kilka a̱makuawiꞌ ipan ista̱ꞌwitz. ");
INSERT INTO nhx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nochi ye̱ꞌkuawiꞌ ye̱ꞌta̱ki, iwá̱n yej ayéj ye̱ꞌkuawiꞌ, ayejye̱kti ita̱kilka. ");
INSERT INTO nhx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yej ye̱ꞌkuawiꞌ awel mochi̱wa ita̱kilka yej ayá̱ꞌ yejye̱kti, niga yej ayéj ye̱ꞌkuawiꞌ awel mochi̱wa ita̱kilka yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nochi kuawiꞌ yej ayá̱ꞌ ye̱ꞌta̱ki, motzonteki iwá̱n motatiá. ");
INSERT INTO nhx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Inó̱n iga amejeme̱n anki̱xmatiskej ino̱mej san ken iga kichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Ayá̱ꞌ nochi yej ne‑ijliáj “noTe̱ko, noTe̱ko” yawij kalakitij ka̱n reina̱rowa Dios, sino que inó̱mejsan yej kichi̱waj ken kineki noTaj yej onoꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kua̱ꞌ asis inó̱n día, miaꞌ yawij ne‑ijli̱tij: “NoTe̱ko, noTe̱ko, nejeme̱n nikpowakej motájto̱l, iwá̱n ipan moto̱ka̱ꞌ niki̱xtijkej ma̱lespi̱ritojmej, iwá̱n ipan moto̱ka̱ nikchijkej miaꞌ yej ayí̱ꞌ mo‑ita.” ");
INSERT INTO nhx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Eꞌ nej nikijli̱skej: “Ayí̱ꞌ nimitzi̱xmatikej; xicholo̱ka̱n note̱noj, amejeme̱n yej ankichi̱waj yej aye̱kti.” ");
INSERT INTO nhx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Yej kikaki notájto̱l iwá̱n kichi̱wa yej nikijtowa, ken tikita se̱ ta̱gaꞌ yej poxsan tajla̱ntoꞌ yej kichij íkal ipan se̱ weyiteꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wa̱laj tiawa̱ꞌ, wejweyakej a̱ꞌtimej iwá̱n wa̱laj ejekaꞌ yej pox tajpalej ipan inó̱n kajli; eꞌ ayá̱ꞌ kiwetzi̱ltij iga to̱ktoꞌ ipan teꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Eꞌ yej kikaki notájto̱l iwá̱n ayá̱ꞌ kichi̱wa yej nikijtowa, inó̱n ken tikita yej ayá̱ꞌ ye̱ꞌtajla̱ntoꞌ, yej kichij íkal ipan xa̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wa̱laj tiawa̱ꞌ, wejweyakej a̱ꞌtimej, iwá̱n wa̱laj ejekaꞌ ipan inó̱n kajli, iwá̱n wetziꞌ. ¡Melaꞌxi̱xiti̱niꞌ nokta! ");
INSERT INTO nhx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Kua̱ꞌ Jesús tamiꞌ tajtoj, yej takaktoyaj san tajtachi̱xtikajkej kén iga Jesús tamachtia̱ya; ");
INSERT INTO nhx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","iga ijkó̱n ken tamachtia̱ya, ne̱siá iga kimati te̱ nemi kijtowa, ayéj ken yej tamachtiáj ipan iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kua̱ꞌ Jesús temoj ipan tepe̱ꞌ, poxsan kitokatiajkij. ");
INSERT INTO nhx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Iwá̱n kina̱ꞌtechoj se̱ ta̱gaꞌ yej nemi pala̱ni ikajlo̱ꞌ iga kipiaya lepra, motankua̱ketzaꞌ iyi̱xtaj Jesús, iwá̱n kijtoj: —NoTe̱ko, siga tikneki, wel xine̱pajti. ");
INSERT INTO nhx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iwá̱n Jesús kichijchin in inó̱n yej we̱titoya, kijlij: —Kena, nikneki xipajti. Kua̱ꞌ inó̱n kijtoj, achitiáꞌ yej kipiaya lepra. ");
INSERT INTO nhx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Iwá̱n kijlij: —Taꞌ xikaki, amo agaj xikijli; xaj ka̱n onoꞌ sacerdote iga mamitzita, iwá̱n xikta̱li moofre̱ndaj ken tatekimaka iley Moisés, iga nochi makimati iga tipájtiꞌya. ");
INSERT INTO nhx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kua̱ꞌ Jesús asiꞌ ipan a̱ltepe̱ꞌ Capernaum, se̱ capitán de Roma yajki kitecho̱to Jesús iwá̱n kitekiꞌtajtanilij, ");
INSERT INTO nhx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","kijlij: —NoTe̱ko, notekipanowa̱ni wetztoꞌ nocha̱n pan itapech iga poxsan kuajkualo̱toꞌ isempan iwá̱n este awel mo̱li̱na. ");
INSERT INTO nhx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesús kijlij: —Nej nia̱ti nikachitialti̱ti. ");
INSERT INTO nhx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Inó̱n capitán kijtoj: —NoTe̱ko, akajasi xikalaki nocha̱n, san xikijto iga maachitiá notekipanowa̱ni, iwá̱n achitiás. ");
INSERT INTO nhx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nej no̱ onoꞌ yej ne̱tekimaka iwá̱n no̱ niktekimaka solda̱dojmej. Kua̱ꞌ nikti̱tani se̱ mayawi kanaj, yawi; iwá̱n kua̱ꞌ seꞌ nikijliá iga mawi̱ki, wi̱ꞌ; iwá̱n kua̱ꞌ nikijliá notekipanowa̱ni iga makichi̱wa tejté̱, kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kua̱ꞌ Jesús inó̱n kikaguiꞌ, madmira̱doj iwá̱n kijlij yej kitokatinemiáj: —Nimitzijliáj iga anikasiꞌ nisé̱ israelita yej mamopoxconfia̱ro ipan nej ken iní̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nej nimitzijliáj iga poxsan wi̱tzelo̱j ka̱n iki̱sáya̱mpa to̱nati̱ꞌ iwá̱n ikalakíya̱mpaꞌ, iwá̱n mota̱li̱skej iga takua̱skej wa̱n Abraham, Isaac iwá̱n Jacob ipan cielo ka̱n reina̱rowa Dios; ");
INSERT INTO nhx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","eꞌ yej onóyaja iga maya̱ka̱n katka ka̱n reina̱rowa Dios, kaki̱skej ka̱n takomichka̱n, ompa cho̱kaskej este tangueguetzekaskej. ");
INSERT INTO nhx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iwá̱n Jesús kijlij inó̱n capitán: —Xaja mocha̱n, iwá̱n mamochi̱wa ijkó̱n ken ticre̱doj. Iwá̱n íkua̱ꞌsan in inó̱n tekipanowa̱ni achitiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús yajki cha̱n Pedro, wa̱n kasito imona̱n Pedro wetztoꞌ ipan tapech iga kawa̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesús kima̱ki̱tzkij, iwá̱n íkua̱ꞌsan se̱wiꞌ ikajlo̱ꞌ; iwá̱n mokétzaꞌya iga kitamáꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kua̱ꞌ tayowátiꞌya, kiwi̱guilijkej Jesús miaꞌ yej kipiayaj ma̱lespi̱ritojmej; iwá̱n Jesús iga san kitekimáꞌ ma̱lespi̱ritojmej, kikijki̱xtij, iwá̱n no̱ kachitialtij nochi yej we̱titoyaj. ");
INSERT INTO nhx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iní̱n mochij iga mamochi̱wa ken kijtoj el profeta Isaías: “Yéj te̱pajtij, iwá̱n yéj te̱achitialtij.” ");
INSERT INTO nhx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kua̱ꞌ Jesús kitaꞌ iga poxsan kipo̱lojtokej, kitekimáꞌ idisci̱polojmej iga maa̱panó̱ka̱nya ipan laguna. ");
INSERT INTO nhx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Iwá̱n se̱ yej tamachtiá ipan iley Moisés kitecho̱ko Jesús, iwá̱n kijlij: —Tamachtia̱ni, nej nikneki manimitztokatinemi ka̱nsan tia. ");
INSERT INTO nhx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Eꞌ Jesús kijlij: —Koyo̱mej kipiáj ixapoyomej ka̱n kochij, iwá̱n to̱to̱mej kipiáj ixekemej; eꞌ nej yej iPiltzi̱n Ta̱gaꞌ anikpiá ka̱n achi manimokuajtetonti. ");
INSERT INTO nhx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Iwá̱n seꞌ idiscí̱poloj, kijlij: —NoTe̱ko, maniaoꞌ achto manikto̱kati notaj. ");
INSERT INTO nhx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús kijlij: —Xine̱toka, xika̱wili yej ken miktokej iga makito̱kaka̱n yej miktokej. ");
INSERT INTO nhx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iwá̱n Jesús tejkaj ipan weyi á̱ka̱l, senyajki iwá̱n idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tajko laguna pe̱waꞌ se̱ ejekaꞌ yej pox tajpalej este a̱te̱miaya á̱ka̱l. Eꞌ Jesús kochtoya. ");
INSERT INTO nhx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Iwá̱n idisci̱polojmej kixitijkej Jesús, kijlijkej: —¡NoTe̱ko, xine̱ma̱nawi̱ka̱n! ¡Némiya ti‑a̱wetzij! ");
INSERT INTO nhx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesús kijtoj: —¿Te iga poxsan anmajmawij? ¡Amejeme̱n ali̱ntzi̱n anmoconfia̱rowaj nopan! Iwá̱n Jesús moketzaꞌ, kajajwaꞌ ejekaꞌ iwá̱n a̱ꞌti, iwá̱n santaka̱mpolijtika̱wiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tajta̱gaꞌ san tajtachi̱xtikajkej, iwá̱n kijtojkej: —¿Ix a̱ꞌtaj yéj nokta a̱n in iní̱n ta̱gaꞌ yej este ejekaꞌ iwá̱n a̱ꞌti kitajto̱lkakij? ");
INSERT INTO nhx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kua̱ꞌ Jesús asiꞌ iyi̱ka̱mpa laguna ipan estado de Gadara, o̱me̱n tajta̱gaꞌ ki̱skej posa̱ntoj, iwá̱n kitechojkej Jesús. Iyo̱mexti̱n kipiayaj mal espí̱ritoj, wa̱n poxsan tata̱talo̱chtia̱yaj, iwá̱n ipan inó̱n ojti ayágajoꞌ wel panowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iwá̱n tzajtzikej: —¿Té̱ tikneki nowa̱mej, tej Jesús yej iPiltzi̱n Dios? ¿Ix tiwa̱laj ane̱yoka‑ikno̱chi̱wakoj malej iga aya asi hora? ");
INSERT INTO nhx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Iwá̱n ayá̱ꞌ wejka iga ompa, takuajtinemiáj miaꞌ koyame̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Iwá̱n ma̱lespi̱ritojmej kitekiꞌtajtanilijkej Jesús ijkí̱n: —Siga anne̱ki̱xtiájyawaꞌ, xine̱ti̱tanika̱n ipan koyame̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Iwá̱n Jesús kijtoj: —Ómpayawaꞌ, xikalakitij. Iwá̱n ino̱mej ma̱lespi̱ritojmej ki̱skej ipan tajta̱gaꞌ iwá̱n kalakitoj ipan koyame̱mej; iwá̱n nochi ino̱mej koyame̱mej mobarranca̱rojkej iwá̱n wejwetzitoj ipan a̱ꞌti iwá̱n ompa a̱mikikej. ");
INSERT INTO nhx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yej kicuida̱rojtinemiáj koyame̱mej mo̱ka̱cholojkej. Kua̱ꞌ asíkeja ipan a̱ltepe̱ꞌ, kipojkej nochi yej mochij ipan ino̱mej tajta̱gaꞌ yej kipiayaj ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iwá̱n nochi yej cha̱ntitokej ipan inó̱n a̱ltepe̱ꞌ yajkij ka̱n onoꞌ Jesús. Iwá̱n kua̱ꞌ iténoja onokej, kitekiꞌijlijkej iga makí̱saya ipan ita̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iwá̱n Jesús tejkaj ipan se̱ weyi á̱ka̱l iga a̱panoj iwá̱n asiꞌ ka̱n iya̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ompa kiwi̱guilijkej se̱ ta̱gaꞌ yej awel nejnemi nokta, wetztia̱ya ipan itapech. Kua̱ꞌ Jesús kitaꞌ ken iga yejeme̱n moconfia̱rowa̱yaj ipan yéj, kijlij yej we̱titoya: —Amo ximajmawi nopíj; nochi yej tikchij yej aye̱kti nimitze̱lka̱wiliaya. ");
INSERT INTO nhx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iwá̱n sekin yej tamachtiáj ipan iley Moisés, kua̱ꞌ iní̱n kikakikej, kijtojkej ipan iya̱lmajmej: “Iní̱n ta̱gaꞌ iga ijkó̱n kijtowa, kima̱lijliá Dios.” ");
INSERT INTO nhx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Eꞌ Jesús kimatiá te̱ kejla̱ntoyaj, kijtoj: —¿Te iga ankejla̱mikij yej aye̱kti ipan amoa̱lmajmej? ");
INSERT INTO nhx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Kéntaj má̱j wel manikijto: “Nochi yej tikchij yej aye̱kti nimitzperdona̱rowílija”, o manikijli: “Ximoketza iwá̱n xaja”? ");
INSERT INTO nhx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Iná̱n sí, nia nimitzne̱xtili̱tij iga nej yej iPiltzi̱n Ta̱gaꞌ ipan iní̱n ta̱jli wel nikperdona̱rowiliá yej se̱ kichi̱wa yej aye̱kti. Iwá̱n Jesús kijlij yej awel nejnemi: —Ximoketza, xikui motapech iwá̱n xaja mocha̱n. ");
INSERT INTO nhx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iwá̱n moketzaꞌ iwá̱n yájkiya icha̱n. ");
INSERT INTO nhx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kua̱ꞌ la gente inó̱n kitakej, majmawikej iwá̱n kiweyimati̱ltijkej Dios iga kimáꞌ inó̱n poder tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús ki̱saꞌ ompa ka̱n onoya, iwá̱n kitaꞌ se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Mateo, e̱watoya ka̱n kicobra̱rojtoya impuestos iga Roma, iwá̱n kijlij: —Xine̱toka. Iwá̱n Mateo moketzaꞌ iwá̱n kitogaꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús takuajtoya kalijtiꞌ, iwá̱n asiꞌ miaꞌ yej kicobra̱rowa̱yaj impuestos iga gobierno iwá̱n sekin yej ayá̱ꞌ ye̱ꞌnemij, iwá̱n ki̱xna̱nkej mesa iwá̱n idisci̱polojmej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eꞌ kua̱ꞌ fariseojmej kitakej iga Jesús nemi sentakuaj iwá̱n ino̱mej, kitajtankej idisci̱polojmej: —¿Te iga amomae̱stroj sentakua wa̱n yej kicobra̱rowa̱yaj impuestos iga Roma iwá̱n yej kichi̱waj yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús kikaguiꞌ yej kijtojtokej iwá̱n kijtoj: —Yej ye̱ktitokej, ayá̱ꞌ kajasi iga mamoachitialti̱ka̱n, eꞌ yej we̱titokej, kena, kajasi. ");
INSERT INTO nhx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xa̱ka̱n iwá̱n ximomachti̱ka̱n yej kijto̱jneki ken ijkuilijtoꞌ itájto̱l Dios: “Nej nikneki xita‑ikne̱li̱ka̱n; ayéj iga xine̱miktili̱ka̱n yo̱lka̱mej.” Pues nej ayá̱ꞌ niwa̱laj nikno̱tzako yej kijtowaj iga ye̱ꞌnemij. Ma̱jwaꞌ niwa̱laj nikno̱tzako yej kichi̱waj yej aye̱kti iga mamoyo̱lpataka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yej kitokatinemiáj Juan yej tabautiza̱rowa yajkij ka̱n onoꞌ Jesús, iwá̱n kitajtankej: —¿Te iga nejeme̱n iwá̱n fariseojmej nipoxmayuna̱rowaj iwá̱n modisci̱polojmej ayá̱ꞌ mayuna̱rowaj? ");
INSERT INTO nhx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús kijtoj: —¿Ix wel mokno̱matitoskej te‑ikni̱wa̱n ka̱n mona̱miktilo mie̱j ompa onoꞌ iwa̱mej chokotzi̱n yej mona̱miktiá? Eꞌ asiti día kua̱ꞌ chokotzi̱n kiwi̱gaskej. Íkua̱ꞌya sí mayuna̱ro̱skej. ");
INSERT INTO nhx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","’Iwá̱n ayagaj kitamaniá se̱ tzotzolsósol iga tzotzoltájkol yej mokówagoꞌ; iga yej mokówagoꞌ a̱kuis, iwá̱n má̱j weyi kitzaya̱nas tzotzolsósol. ");
INSERT INTO nhx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Awel no̱ moakiá vino yej kichíjkejoꞌ ipan ikyapakuetaxtekon iga vino yej kichíjkejoꞌ moposa̱wa iwá̱n kipoxo̱nas kuetaxtekon iwá̱n ne̱mpoliwis vino iwá̱n kuetaxtekon. Inó̱n iga, ye̱kti mamoaki vino yej kichíjkejoꞌ ipan kuetaxtekon yej móchijoꞌ. Ijkó̱n apoliwis vino niga kuetaxtekon. ");
INSERT INTO nhx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Mie̱j Jesús ta̱tapojtóyaoꞌ, asiꞌ se̱ yej kimanda̱rowa judiyojmej, motankua̱ketzaꞌ ite̱noj, iwá̱n kijlij: —Nosiwa̱piltzi̱n nokto̱ꞌ miguiꞌ, eꞌ siga tia nocha̱n, iwá̱n tikta̱li̱j moma̱ꞌ ipan nosiwa̱piltzi̱n, ojpa‑isas sej. ");
INSERT INTO nhx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús moketzaꞌ iwá̱n yajki iwá̱n idisci̱polojmej iwá̱n inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Iwá̱n se̱ siwa̱ꞌ yej we̱titoya doce años iga ki̱stoya ken imé̱s yej awel pachiwiá, kitechoj Jesús itepotztájbapa iwá̱n kichijchimilij ite̱mpan isota̱ntzótzol; ");
INSERT INTO nhx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","yéj kijtoj ipan iya̱lmaj: “Iga san nia nikchijchimili̱ti itzótzol, nia ni‑achitiati.” ");
INSERT INTO nhx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Eꞌ Jesús tacháꞌ itepotztaj, kitaꞌ inó̱n siwa̱ꞌ, iwá̱n kijlij: —Xipa̱ki, nopíj, ti‑achitiaꞌya iga timoconfia̱roj ipan nej. Iwá̱n íkua̱ꞌsan inó̱n siwa̱ꞌ achitiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kua̱ꞌ Jesús asiꞌ cha̱n inó̱n jefe yej ito̱ka̱ꞌ Jairo, kitaꞌ iga tapi̱tztolo̱ꞌ iga yáwija kito̱katij yej miktoꞌ, iwá̱n pox tzajtzitolo̱ꞌ iga cho̱kayaj. ");
INSERT INTO nhx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús kijtoj: —Xiki̱saka̱n nigaj; takotzi̱n ayá̱ꞌ miktoꞌ, yejwaꞌ kochtoꞌ. Iwá̱n kiwejwetzkilijkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Eꞌ Jesús kikijki̱xtij yej onoyaj kalijtiꞌ, iwá̱n kalaꞌ, kima̱ki̱tzkij takotzi̱n iwá̱n kipale̱wij iga moketzaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iwá̱n no̱ya̱n ipan inó̱n ta̱jli momatiꞌ yej Jesús kichij. ");
INSERT INTO nhx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kua̱ꞌ Jesús ki̱saꞌ ompa, o̱me pachamej kitokakej, kitzajtzilijtia̱yaj: —¡Achi xine‑ikne̱li̱ka̱n tej yej iPiltzi̱n David! ");
INSERT INTO nhx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iwá̱n kua̱ꞌ Jesús kalaꞌ kalijtiꞌ, pachamej kitechojkej, iwá̱n Jesús kijtoj: —¿Ix ankicre̱dowaj iga wel nimitztachalti̱skej? Pachamej kijtojkej: —Kena, noTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Iwá̱n Jesús kiji̱xchijchin in ino̱mej pachamej, iwá̱n kijtoj: —Mamochi̱wa ijkó̱n ken amejeme̱n anmoconfia̱rojkej. ");
INSERT INTO nhx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Iwá̱n tachákeja. Iwá̱n Jesús kitekimáꞌ nokta ino̱mej: —Amo agaj xikijli̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Eꞌ yejeme̱n kí̱skejsan ompa, kipojtinenkej no̱ya̱n yej Jesús kichij. ");
INSERT INTO nhx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kua̱ꞌ ki̱stiá̱yaja, sekin asikej yej kiwajliguilijkej Jesús se̱ no̱noj yej kipiaya ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eꞌ kua̱ꞌ Jesús kikí̱xtija inó̱n ma̱lespí̱ritoj, welja tajtoj in no̱noj. Yej ompa onoyaj san tajtachi̱xtikajkej, kijtojkej: —¡Ayí̱ꞌ mo‑itaꞌ ipan Israel ken iní̱n! ");
INSERT INTO nhx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Eꞌ fariseojmej kijtowa̱yaj: —Ije̱fej ma̱lespi̱ritojmej kimáꞌ iní̱n ta̱gaꞌ iga wel kiki̱xtiá ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús nentinemiá no̱ya̱n ipan weyi a̱ltepe̱mej iwá̱n ipan a̱ltepe̱tzitzi̱n, tamachtijtinemiá ipan tio̱pamej ipan sejsé̱ a̱ltepe̱ꞌ. Kipowaya ye̱ꞌnoti̱ciaj kén iga reina̱rowa Dios, iwá̱n kachitialtia̱ya inochi yej we̱titokej iwá̱n yej kualo̱tokej. ");
INSERT INTO nhx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Kua̱ꞌ Jesús kitaꞌ yej ompa chapa̱ntokej, kikne̱lij iga kitaꞌ tayo̱koxtokej iwá̱n siatokej iwá̱n pa̱payi̱ntokej, ken tikita borre̱gojmej yej ate̱koyojkej. ");
INSERT INTO nhx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iwá̱n Jesús kijlij idisci̱polojmej: —Nimitzijliáj, mela̱ꞌwaꞌ iga onoꞌ miaꞌ yej wel moconfia̱rowaj ipan nej, eꞌ ayá̱ꞌ miaꞌ yej kipowaj ye̱ꞌnoti̱ciaj. Yej aya kikakij, inó̱mejwaꞌ ken se̱ weyi mi̱jli yej némiya tayoksi. ");
INSERT INTO nhx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Inó̱n iga xiktajtanili̱ka̱n yej iTe̱ko mi̱jli iga makiti̱tani tekipanowa̱nimej iga makitekítijya yej onoꞌ pan mi̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iwá̱n Jesús kino̱tzaꞌ doce idisci̱polojmej iwá̱n kimáꞌ poder iga wel makiki̱xti̱ka̱n ma̱lespi̱ritojmej iwá̱n iga wel makachitialti̱ka̱n yej de se̱seꞌpa iga we̱titokej iwá̱n nochi yej kuajkualo̱tokej. ");
INSERT INTO nhx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iní̱n ito̱ka̱mej yej Jesús kitapejpen iga itati̱tanimej yej no̱ kijliáj apo̱stolejmej: yej achto ito̱ka̱ꞌ Simón, yej no̱ ito̱ka̱ꞌ Pedro, iwá̱n Andrés yej yéjpasan iyikni̱n; Jacobo iwá̱n Juan yej ipilówa̱mpa Zebedeo; ");
INSERT INTO nhx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, iwá̱n Mateo yej kicobra̱rowa̱ya impuestos iga Roma; Jacobo yej ipíltzi̱mpa Alfeo; Lebeo yej no̱ ito̱ka̱ꞌ Tadeo; ");
INSERT INTO nhx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón yej iparti̱doj nacionalista; iwá̱n Judas Iscariote, yej má̱j despué̱j kinamáꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Kua̱ꞌ Jesús kiti̱tan ini̱mej doce apo̱stolejmej, ijkí̱n kijlijkej: —Amo xa̱ka̱n ka̱n cha̱ntitokej yej ayéj judiyojmej, niga xa̱ka̱n ipan a̱ltepe̱mej yej onokej ipan estado de Samaria; ");
INSERT INTO nhx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ma̱jwaꞌ xa̱ka̱n xikitatij judiyojmej yej pojpolijtinemij ken borre̱gojtzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xikijlijtinemika̱n iga iná̱n sí na̱ꞌya onoꞌ iga Dios yawi reina̱ro̱ti ipan tejemej. ");
INSERT INTO nhx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xikachitialti̱ka̱n yej we̱titokej, xikojpa‑ixiti̱ka̱n yej miktokej, xikpajti̱ka̱n yej pala̱ntokej ikajlo̱mej iga kipiáj lepra, xiki̱xti̱ka̱n ma̱lespi̱ritojmej. Amejeme̱n ayá̱ꞌ ankikojkej iga iní̱n wel ankichi̱waj, amejeme̱n no̱ amo mamitzixta̱waka̱n iga iní̱n ankichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Amo no̱ xikui̱gaka̱n ni alí̱n tomi̱n, ");
INSERT INTO nhx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","niga xikui̱gaka̱n amomórra̱l ipan ojti; niga seꞌ amotzótzol, niga seꞌ gakti, niga bastón; iga yej tekipanowa kajasi iga makitamakaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Kua̱ꞌ amasiskej ipan se̱ a̱ltepe̱ꞌ o a̱ltepe̱tzi̱n, xikte̱mo̱ka̱n ompa agaj yej mitzye̱ꞌitaj iwá̱n ómpaoꞌ xika̱wika̱n icha̱n este que matami amotekipáno̱l wa̱n anki̱saskej ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kua̱ꞌ ankalakiskej icha̱n, xikijli̱ka̱n iga maonoka̱n tamelá̱. ");
INSERT INTO nhx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Siga yej ompa cha̱ntitokej kajasi iga ijkó̱n xikijli̱ka̱n, ijkó̱n mochi̱was; eꞌ siga ayá̱ꞌ kajasi, amo xiktajtanilika̱n Dios iga tamelá̱ maonoka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Eꞌ siga ayá̱ꞌ mitzo̱mema̱wiáj niga mitzkakisnekij, xiki̱saka̱n ipan inó̱n kajli o ipan inó̱n a̱ltepe̱ꞌ iwá̱n xiktzejtzelo̱ka̱n amokxi iga maxi̱ni ta̱lpíno̱l. ");
INSERT INTO nhx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nimitzijliáj iga kua̱ꞌ Dios tajuzga̱ro̱j, yej cha̱ntitokej ipan inó̱n a̱ltepe̱ꞌ má̱j kicastiga̱ro̱skej que yej cha̱ntitokej a̱ltepe̱mej Sodoma iwá̱n Gomorra. ");
INSERT INTO nhx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Taꞌ xikakika̱n, nej nimitzti̱tanij ken tikita amborre̱gojmej itza̱la̱n koyo̱mej. Eꞌ xonoka̱n listo ken tikita ankowa̱mej, iwá̱n ximochi̱waka̱n ken anjojtokomej iga amo agaj xikchi̱wili̱ka̱n yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Amo xike̱lka̱waka̱n iga la gente mitzwi̱gaskej ka̱n onoꞌ tekiwajmej, iwá̱n mitzmagaskej ipan tio̱pamej. ");
INSERT INTO nhx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iwá̱n iga notechko mitzwi̱gaskej iná̱ꞌ gobernado̱rmej iwá̱n re̱yejmej; ijkó̱n iga wel antajto̱skej de nej iyi̱xtaj yejemej iwá̱n yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Eꞌ kua̱ꞌ mitzwi̱gaskej iná̱ꞌ yej manda̱rowaj, amo xitayo̱koyaka̱n iga ayá̱ꞌ ankimatij te̱ anyawij ankijto̱tij; iga kua̱ꞌ antajto̱skej, Dios mitztajto̱lmakaskej. ");
INSERT INTO nhx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Iga ayéj amejeme̱n yej antajto̱skej, sino que iyEspí̱ritoj amoTaj Dios in yej yawi tajto̱ti ipan amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Se̱ tokni̱n yawi kite̱lwi̱ti iyikni̱n iga makimikti̱ka̱n, iwá̱n te̱taj kite̱lwi̱j ipiltzi̱n iga makimikti̱ka̱n, iwá̱n te̱pilowa̱n kite̱lwi̱skej itajmej iga makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochi yawij mitzijiyatij iga nej anne̱tokaj; eꞌ yej mane̱toka este que mamiki, yawi moma̱nawi̱ti. ");
INSERT INTO nhx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kua̱ꞌ mitztalo̱chti̱skej ipan se̱ a̱ltepe̱ꞌ, xa̱ka̱n ipan seꞌ a̱ltepe̱ꞌ; nimitznojma‑ijliáj iga nej yej iPiltzi̱n Ta̱gaꞌ nia niwi̱tzeti kua̱ꞌ aya ampanowaj no̱ya̱n ipan a̱ltepe̱mej ka̱n icha̱mej israeli̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Yej nemi momachtiá ayá̱ꞌ má̱j tamati ken yej tamachtiá, iwá̱n nisé̱ tekipanowa̱ni ayá̱ꞌ má̱j tayaka̱ntoꞌ que ipatró̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Se̱ discípulo makisenta̱li iya̱lmaj iga mochi̱was kensan imae̱stroj, iwá̱n tekipanowa̱ni kensan ite̱ko. Siga nej yej nimanda̱rowa ne‑ijliáj iga niTzitzimiꞌ, ¿ix ayá̱ꞌ no̱ mitzijli̱skej iga amejeme̱n no̱ antzitzimimej yej anne̱tokaj? ");
INSERT INTO nhx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Inó̱n iga amo agaj xikmajmawili̱ka̱n. Ateyi nité̱ yej ichtákasan maono yej ayá̱ꞌ momatis, wa̱n ateyi nité̱ yej i̱ya̱ntoꞌ yej ayá̱ꞌ mone̱xti̱j. ");
INSERT INTO nhx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yej nimitzijliáj ka̱n tamichka̱n, amejeme̱n xikpowaka̱n no̱ya̱n ka̱n onolo̱ꞌ; yej nimitzichtaka‑ijliáj, xitzajtzika̱n iga xikijto̱ka̱n iga nochi makikaki. ");
INSERT INTO nhx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amo xikmajmawili̱ka̱n yej wel mitzmiktiáj, iga awel kimiktiáj toa̱lmaj; ma̱jwaꞌ xikmajmawili̱ka̱n yej wel te̱melaꞌpolowa iwá̱n wel kiti̱tani toa̱lmaj ka̱n tawewelkatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’¿Ix ayá̱ꞌ monamaka o̱me to̱to̱tzitzi̱n iga se̱ tomi̱ntzi̱n? Eꞌ malej ijkó̱n, nisé̱ to̱to̱ꞌ ayá̱ꞌ miki sin que amoTaj Dios amo makimati. ");
INSERT INTO nhx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pues este amotzónkal Dios kimati ke̱ꞌ ankipiáj. ");
INSERT INTO nhx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Amo ximajmawika̱n, amejeme̱n má̱j anvale̱rowaj que miaꞌ to̱to̱tzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Inewi yej kinojma‑ijtowa iyi̱xtaj la gente iga ne̱toka, nej no̱ iyi̱xtaj noTaj yej onoꞌ ipan cielo, nia nikijto̱ti iga ne̱toka. ");
INSERT INTO nhx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Eꞌ yej iyi̱xtaj la gente kijtowa iga ayá̱ꞌ ne̱toka, nej no̱ iyi̱xtaj noTaj yej onoꞌ ipan cielo nia nikijto̱ti iga ayá̱ꞌ ne̱toka. ");
INSERT INTO nhx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Amo ankijto̱skej iga nej niwa̱laj ipan iní̱n ta̱jli iga tamelá̱ maonolo; ayá̱ꞌ niwa̱laj iga tamelá̱ maonolo, sino iga mamokuejkuesojtolo. ");
INSERT INTO nhx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Niwa̱laj iga ta̱gaꞌ makikuesowili itaj, iwá̱n siwa̱piltzi̱n makikuesowili iye̱ꞌ, iwá̱n siwa̱mon makikuesowili imona̱n; ");
INSERT INTO nhx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ijkó̱n iga sejsé̱ mokuejkueso̱j iwa̱nsan iyikní̱mejpa. ");
INSERT INTO nhx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’Yej makicho̱kili itaj o iye̱ꞌ má̱j que nej, inó̱n ayá̱ꞌ kajasi iga mane̱toka; yej makicho̱kili iyokichpiltzi̱n o isiwa̱piltzi̱n má̱j que nej, inó̱n ayá̱ꞌ kajasi iga mane̱toka; ");
INSERT INTO nhx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","yej kinekis mane̱toka, eꞌ ayá̱ꞌ kikechpanowa icru̱z, ayá̱ꞌ kajasi iga mamochi̱wa nodiscí̱poloj. ");
INSERT INTO nhx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yej kineki san mamoma̱nawi, yawi poliwiti, eꞌ yej mamiki iga ne̱toka, nochipa onos nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Yej mitzo̱mema̱wiáj, néjyawaꞌ in yej neo̱mema̱wiáj; iwá̱n yej neo̱mema̱wiá no̱ ki‑o̱mema̱wiáj yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yej ki‑o̱mema̱wiá se̱ profeta yej kiti̱tani Dios, yawij kimakatij yej ye̱kti kensan kimakaj se̱ profeta, yej ki‑o̱mema̱wiá se̱ tokni̱n yej te‑ijikni̱n, yawij kimakatij yej ye̱kti kensan kimakaj se̱ tokni̱n yej te‑ijikni̱n. ");
INSERT INTO nhx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Iwá̱n si agaj kimaka yej nej ne̱toka yej amoweyimati, malej alí̱n sese̱ka̱ꞌ ipan wájkal, nimitzijliáj iga inó̱n sí Dios kimakas yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kua̱ꞌ Jesús tamiꞌ kino̱no̱tzaꞌ inó̱n doce idisci̱polojmej, ki̱saꞌ ompa iga yajki tamachti̱to iwá̱n kipowato ye̱ꞌnoti̱ciaj ipan a̱ltepe̱mej yej onokej ipan ta̱jli de Galilea. ");
INSERT INTO nhx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan pre̱sojtitoya wa̱n kimatiꞌ yej Cristo nemi kichi̱wa. Iwá̱n Juan kiti̱tan o̱me̱n idisci̱polojmej iga makitatij Jesús, ");
INSERT INTO nhx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","iga ijkí̱n makitajtanika̱n: —¿Ix tejya in Cristo yej yawi wi̱tzeti, o nikcháskejoꞌ sewoꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús kijtoj: —Xa̱ka̱n xikijli̱tij Juan nochi yej nigaj nemi ankitaj iwá̱n yej nemi ankikakij. ");
INSERT INTO nhx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xikpowili̱ka̱n iga pachamej tachaja, ko̱xomej nejnémija, yej pala̱ntia̱yaj ikajlo̱mej iga kipiáj lepra, achitiákeja, yej ayá̱ꞌ takakiáj, iná̱n takákija, yej miktoyaj, ojpa‑isákeja, yej ayá̱ꞌ motapialiáj, mopowiliá ye̱ꞌnoti̱ciaj ken iga Dios tasalva̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pa̱ktos yej ayá̱ꞌ kikajte̱wa iga moconfia̱rowa ipan nej. ");
INSERT INTO nhx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kua̱ꞌ yájkija itati̱tanimej Juan, Jesús pe̱ꞌya ta̱tapowaꞌ de Juan, kijlij la gente: —¿Té̱ ankitato̱yaj ipan desierto? ¿Ix se̱ ojtaꞌ yej ko̱o̱li̱na ejekaꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Siga ayá̱ꞌ, ¿té̱taj ankitato̱yaj? ¿Ix se̱ ta̱gaꞌ yej ye̱ꞌtaajakijtoꞌ? Amejeme̱n ankimatij iga yej moye̱ꞌtaajakiáj, onokej icha̱n re̱yejmej. ");
INSERT INTO nhx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Iwá̱n, ¿té̱ nokta ankitato̱yaj? ¿Ix se̱ profeta? Kena, yéj ma̱jya sej que se̱ profeta. ");
INSERT INTO nhx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","De ino̱nya Juan tajtowa ka̱n ijkí̱n ijkuilijtoꞌ: Nikti̱tani notati̱tan iga mo‑i̱xtaj matayaka̱na, iga ken kua̱ꞌ mamitzojtápoya. ");
INSERT INTO nhx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jesús no̱ kijtoj: —Nimitznojma‑ijliáj iga desde ikyay este iná̱n ateyi ni agaj yej má̱j tayaka̱ntoꞌ que Juan yej tabautiza̱rowa, eꞌ yej momachi̱liá iga até̱ iteki de inochi yej mote̱makaj iga Dios marreina̱ro ipan yejeme̱n, inó̱n yej má̱j tayaka̱ntoꞌ que Juan. ");
INSERT INTO nhx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","’Desde kua̱ꞌ wa̱laj Juan yej tabautiza̱rowa este iná̱n, onoꞌ miaꞌ yej kijiyaj iyojwi Dios, wa̱n onoꞌ yej kichi̱wasnekij iga mapoliwi. ");
INSERT INTO nhx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Desde ikyay iwá̱n este iná̱n iga wa̱laj Juan, nochi profe̱tajmej iwá̱n iley Moisés, kijtojkej iga wi̱ꞌ reina̱ro̱ki Dios. ");
INSERT INTO nhx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Siga anne̱cre̱dowaj, Juanwaꞌ in profeta Elías yej wi̱tziaya. ");
INSERT INTO nhx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yej annakasyojkej, xine̱ye̱ꞌkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Amejeme̱n yej ina̱mpa amonokej anne̱sij ken tikita ko̱kone̱ꞌ yej ma̱wiltiáj ipan tajkoa̱ltepe̱ꞌ iwá̱n kitzajtziliáj iyikni̱wa̱n: ");
INSERT INTO nhx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Nejeme̱n nimitztapi̱tzilijkej iga a̱ka iwá̱n ayá̱ꞌ anmijto̱tijkej, nejeme̱n nimitzikno̱takui̱kilijkej iwá̱n ayá̱ꞌ ancho̱kakej.” ");
INSERT INTO nhx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kua̱ꞌ wa̱lka Juan yej mayuna̱rowa̱ya iwá̱n ayí̱ꞌ ta̱wa̱naꞌ, amejeme̱n ankijtojkej iga kipiá ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Niwa̱laj nej iPiltzi̱n Ta̱gaꞌ yej nitakua iwá̱n ni‑a̱ti, ankijtowaj iga nipoxtakua iwá̱n nita̱wa̱na, nimotókakiꞌ iwá̱n yej ayá̱ꞌ ye̱ꞌnemij iwá̱n yej kicobra̱rowaj impuestos iga Roma. Kua̱ꞌ tikitaj iga ye̱ꞌnemij yej momelaꞌconfia̱rowaj ipan Dios, ne̱si iga Dios nochi kimati te̱ kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iwá̱n Jesús pe̱ꞌ kajajwaꞌ yej cha̱ntitokej ipan a̱ltepe̱mej ka̱n má̱j kichij mila̱grojmej yej ayi̱ꞌpa mo‑ita, iga yej ompa cha̱ntitoyaj ayá̱ꞌ nemi kikajte̱wayaj iga kichi̱waj yej aye̱kti, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Lástima yej ancha̱ntitokej a̱ltepe̱ꞌ Corazín! ¡Anla̱stimajmej yej ancha̱ntitokej a̱ltepe̱ꞌ Betsaida! Siga ipan a̱ltepe̱ꞌ Tiro iwá̱n Sidón mochijka mila̱grojmej yej ankitakej, yejemej íkyasan kikajtejkaj iga kichi̱waj yej aye̱kti iwá̱n mone̱xtia̱yaj iga kakia̱yaj itzotzolmej yej moakiá kua̱ꞌ mikilo iga mokno̱matij iwá̱n monejnexwia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Eꞌ nimitzijliáj iga kua̱ꞌ Dios tajuzga̱ro̱j, má̱j mitzcastiga̱ro̱skej que yej cha̱ntitokej a̱ltepe̱mej Tiro iwá̱n Sidón. ");
INSERT INTO nhx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amejeme̱n yej amocha̱n a̱ltepe̱ꞌ Capernaum, ¿ankijtowaj a̱n anya̱tij ipan cielo? Ma̱jwaꞌ yawij mitzaki̱tij ka̱n onokej yej miktokej. Eꞌ siga katka yej icha̱mej a̱ltepe̱ꞌ Sodoma kitayaj mila̱grojmej yej amejeme̱n ankitakej, inó̱n a̱ltepe̱ꞌ onóyasan este iná̱n. ");
INSERT INTO nhx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Eꞌ nimitzijliáj iga kua̱ꞌ Dios tajuzga̱ro̱j, amejeme̱n má̱j mitzcastiga̱ro̱skej que ino̱mej de Sodoma. ");
INSERT INTO nhx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Iwá̱n Jesús kijtoj: —NoTaj yej tikchij cielo iwá̱n ta̱jli, nimitzweyimati̱ltiá iga tikne̱xtilij yej ayá̱ꞌ moweyimatij inó̱n yej ayá̱ꞌ tikne̱xtilij yej tamatij ");
INSERT INTO nhx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","iga tej ijkó̱n tikneꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesús no̱ kijtoj: —NoTaj ne̱maꞌya inochi yej onoꞌ. Ayagaj ne̱melaꞌi̱xmati nej yej iPiltzi̱n Dios, isé̱ltisan te̱Taj Dios ne̱melaꞌi̱xmati. Iwá̱n ayagaj no̱ kimelaꞌi̱xmati te̱Taj; nosé̱ltisan nej yej iPiltzi̱n, iwá̱n ino̱mej yej nej nikneki iga maki̱xmatika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xiwi̱tzeka̱n note̱noj, amonochi̱n amejeme̱n yej ansiatokej iga antekipanowaj iwá̱n an‑eti̱ꞌmiktokej, iwá̱n nej nikchi̱was iga ximose̱wi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xicre̱do̱ka̱n yej nimitzijliáj, iwá̱n ximi̱xkui̱ti̱ka̱n ipan nej, nej ayá̱ꞌ lue̱ nikuejkuesiwi, niga ayá̱ꞌ nimoweyimati ipan noa̱lmaj; iwá̱n anyo̱lajkatiaskej. ");
INSERT INTO nhx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Iga yej nej nimitztekimakaj, wel ankichi̱waskej, iwá̱n yej nimitzijliáj iga xikchi̱waka̱n, ayéj ken yej awel mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Se̱ día kua̱ꞌ mose̱wilo, Jesús iwá̱n idisci̱polojmej nemi pano̱tia̱yaj mi̱lijtiꞌ. Idisci̱polojmej maya̱nakej, iwá̱n pe̱ꞌ iga kitektiajkij trigo iga kikuajkej. ");
INSERT INTO nhx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kua̱ꞌ fariseojmej inó̱n kitakej, kijlijkej Jesús: —Taꞌ xikita, modisci̱polojmej nemi tekipanowaj; inó̱n aye̱kti iga mamochi̱wa ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Eꞌ Jesús, kijtoj: —¿Ix aya̱ꞌtaj ankilee̱rojkej yej kichij David iwá̱n yej íwa̱n senemiáj kua̱ꞌ maya̱nakej? ");
INSERT INTO nhx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kalaꞌ tio̱pan‑ijtiꞌ iwá̱n kikuaj ino̱mpa pa̱n yej kíkuajpa sacerdote, ino̱mpa awel kikua David niga yej íwa̱n nemiáj; wel kikua̱yaj petz sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Ix no̱ ayí̱ꞌ ankilee̱rowaj iley Moisés iga sacerdo̱tejmej ipan weyitio̱pan wel tekipanowaj ipan día kua̱ꞌ mose̱wilo?, iwá̱n ijkó̱n ayá̱ꞌ kichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","¡A̱nya sí nimitzijliáj iga nej ma̱jya sej que weyitio̱pan! ");
INSERT INTO nhx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Mataj amejeme̱n aya ankimatij te̱ kijto̱jneki ka̱n ijkí̱n ijkuilijtoꞌ: “Nej nikneki xita‑ikne̱li̱ka̱n, anikneki iga xine̱miktili̱ka̱n yo̱lka̱mej.” Maga katka ankimatiáj, ayá̱ꞌ ankipantia̱yaj nodisci̱polojmej yej nemi kichi̱waj yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Puej nej yej iPiltzi̱n Ta̱gaꞌ wel nitatekimaka te̱ wel mamochi̱wa ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iwá̱n Jesús ki̱saꞌ ompa iwá̱n kalaꞌ tio̱pan. ");
INSERT INTO nhx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ompa onoya se̱ ta̱gaꞌ yej ma̱takua̱wayaxtoꞌ. Iwá̱n fariseojmej kite̱mowilia̱yaj ken makima̱wetzi̱lti̱ka̱n Jesús, kitajtankej: —¿Ixtaj wel moachitialtiá yej we̱titoꞌ ipan día kua̱ꞌ mose̱wilo? ");
INSERT INTO nhx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús kijtoj: —¿A̱ꞌyéj de amejeme̱n, siga kipiá se̱ borrego iwá̱n mawetzi xapoko ipan día kua̱ꞌ mose̱wilo, ix ayá̱ꞌ ya̱j kiki̱xti̱ti? ");
INSERT INTO nhx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Iwá̱n nej nimitzijliáj iga má̱j vale̱rowa se̱ ta̱gaꞌ que se̱ borrego! Inó̱n iga wel mochí̱ yej ye̱kti ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Iwá̱n Jesús kijlij inó̱n ta̱gaꞌ: —Xikmela̱wa moma̱ꞌ. Iwá̱n kua̱ꞌ kimélaja ima̱ꞌ, ye̱ktiaꞌya kensan seꞌ ima̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kua̱ꞌ fariseojmej ki̱skej ka̱n onoꞌ Jesús, monechkojkej iga kejla̱nkej kén iga yawij kimikti̱tij Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kua̱ꞌ Jesús kimatiꞌ inó̱n, ki̱saꞌ ompa, iwá̱n pox miaꞌ kitokakej wa̱n kachitialtij inochi yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Iwá̱n yej kachitialtia̱ya, kitekimáꞌ iga amo makijto̱ka̱n a̱ꞌyéj in yéj. ");
INSERT INTO nhx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iní̱n mochij iga mamochi̱wa ken kijtoj profeta Isaías, kua̱ꞌ kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ini̱nya yej tekipanowa iga nej, yej niktapejpen, yej nikpoxneki, iwá̱n ne̱yo̱lchikajtoꞌ. Ípan nia nikta̱li̱ti noEspí̱ritoj, iwá̱n yéj yawi kipowati ken iga no̱ wel nikma̱nawiáj yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ayá̱ꞌ tate̱nkuepili̱j niga tzajtzis, ayagaj kikakis itájto̱l ipan ca̱llejmej. ");
INSERT INTO nhx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kikne̱liá yej ayá̱ꞌ tajpalej, kipale̱wiá yej mosemakasneki, ken agaj yej kitimaka se̱ cándi̱l yej se̱wisneki, ijkó̱n kichi̱was te kua̱ꞌ no̱ya̱n ipan ta̱jli mamochi̱wa yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Iwá̱n nochi gente de miaꞌ pai̱smej moconfia̱ro̱skej ipan yéj iga kima̱nawi̱skej. ");
INSERT INTO nhx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Iwá̱n Jesús kiwi̱guilijkej se̱ ta̱gaꞌ yej pacha iwá̱n awel tajtowa iga kipiaya ma̱lespí̱ritoj. Jesús kachitialtij inó̱n ta̱gaꞌ; welja tacháꞌ iwá̱n welja tajtoj. ");
INSERT INTO nhx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nochi gente san tajtachi̱xtikajkej iwá̱n kijtojkej: —¿Ix a̱n ini̱nya in iPiltzi̱n rey David? ");
INSERT INTO nhx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Eꞌ kua̱ꞌ fariseojmej kikakikej inó̱n, kijtojkej: —Iní̱n ta̱gaꞌ kiki̱xtiá ma̱lespi̱ritojmej ipan ipode̱r Tzitzimiꞌ, yej ije̱féjmejpa inochi ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús kimatiá te̱ kejla̱ntoyaj, iwá̱n kijtoj: —Siga se̱ país mochi̱wa o̱me grupo iga mosepankuejkuesowaj, inó̱n país políwiya; iwá̱n siga se̱ a̱ltepe̱ꞌ o siga se̱ familia mosepankuejkuesowaj, awel wejka̱wa iga onos. ");
INSERT INTO nhx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijko̱nsan no̱ Tzitzimiꞌ, siga igá̱najsan kiki̱xtiá ma̱lespi̱ritojmej, yej yéjpasan itatki, inó̱n kijto̱jneki iga ayá̱ꞌ wejka̱was iga tamis ipode̱r. ");
INSERT INTO nhx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iwá̱n siga anne̱pantiáj iga nej niki̱xtiá ma̱lespí̱ritoj iga ipode̱r Tzitzimiꞌ, in yej mitztokaj, ¿ix iga ipode̱r Tzitzimiꞌ kiki̱xtiáj ma̱lespí̱ritoj? Yejémejsan mone̱xtiáj iga ayéj ijkó̱n ken anne‑ijliáj. ");
INSERT INTO nhx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nej niki̱xtiá ma̱lespí̱ritoj iga ipode̱r iyEspí̱ritoj Dios, iwá̱n iní̱n kijto̱jneki iga ásiꞌya tiempo iga Dios marreina̱ro ipan amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’¿Kén wel se̱ kalaki cha̱n se̱ ta̱gaꞌ yej tajpalej iga makikui̱li yej itatki, siga ayá̱ꞌ achto kilpiá? Ijkó̱n wel kikui̱li̱j yej itatki. ");
INSERT INTO nhx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’Yej ayá̱ꞌ kiye̱ꞌita yej nikchi̱wa, ino̱nwaꞌ ne‑ijiya; yej ayá̱ꞌ ne̱pale̱wiá; ino̱nwaꞌ tapojpolowa. ");
INSERT INTO nhx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Inó̱n iga nimitzijliáj, Dios wel ke̱lka̱wiliá nochi yej agaj kichi̱wa yej aye̱kti iwá̱n yej kijtowa yej aye̱kti; eꞌ siga ma̱ltajtowaj iga iyEspí̱ritoj Dios, inó̱n Dios ayoꞌ ke̱lka̱wili̱j. ");
INSERT INTO nhx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Siga agaj ma̱ltajtowa iga nej yej iPiltzi̱n Ta̱gaꞌ, inó̱n Dios ke̱lka̱wili̱j; eꞌ yej mama̱ltajto iga iyEspí̱ritoj Dios, inó̱n nike̱man ayꞌya ke̱lka̱wili̱skej niga ipan iní̱n vida, niga ipan seꞌ vida. ");
INSERT INTO nhx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Siga ye̱ꞌkuawiꞌ, ye̱ꞌta̱ki; siga ayéj ye̱ꞌkuawiꞌ, aye̱kti no̱ ita̱kilka. Se̱ kuawiꞌ mo‑i̱xmati ipansan ita̱kilka. ");
INSERT INTO nhx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Amejeme̱n ken ipilowa̱n kowa̱mej! ¿Kén anyawij ankijto̱tij yej ye̱ꞌtájto̱l siga amejeme̱n ankichijtokej yej aye̱kti? Puej yej ankijtowaj, ijkó̱n onoꞌ ipan amoa̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yej ye̱ꞌnemi, ye̱ꞌtajtowa, iga ipan iya̱lmaj onoꞌ yej ye̱kti, eꞌ ta̱gaꞌ yej aye̱ꞌnemi kijtowa tájto̱l yej ajaye̱kti iga ipan iya̱lmaj ijkó̱n kejla̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Eꞌ nej nimitzijliáj iga kua̱ꞌ Dios tajuzga̱ro̱j, nochi yawij mote̱nxitomatij te iga ayompa tajtojkej. ");
INSERT INTO nhx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Iga inó̱n yej tikijtoj, yawij mitzjuzga̱ro̱tij, ómpaya ne̱sis siga tikchij yej ye̱kti o yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sekin fariseojmej iwá̱n yej tamachtiáj ipan la ley, kijlijkej Jesús: —Tamachtia̱ni, niknekij manikitaka̱n iga xikchi̱wa yej ayi̱ꞌpa mo‑ita yej Dio̱ssan wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesús kijtoj: —Amejeme̱n yej ankichijtokej yej aye̱kti iwá̱n ayá̱ꞌ ankicre̱dowaj Dios, anne̱tajtaniliáj iga manimitzne̱xtili̱ka̱n yej ayi̱ꞌpa mo‑ita. Eꞌ ayá̱ꞌ nimitzne̱xtili̱skej seꞌpa yej ayi̱ꞌpa mo‑ita, petz yej Dios kichi̱wilij Jonás. ");
INSERT INTO nhx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ijkó̱n ken Jonás onoya e̱yi día iwá̱n e̱yi yówal iyijtiko to̱pojwé̱j, ijko̱nsan no̱ nej yej iPiltzi̱n Ta̱gaꞌ nonos ta̱ltampa e̱yi día iwá̱n e̱yi yówal. ");
INSERT INTO nhx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Kua̱ꞌ Dios tajuzga̱ro̱j, yej icha̱mej weyi‑a̱ltepe̱ꞌ Nínive, moketzaskej iga mitzjuzga̱ro̱skej, iwá̱n kijto̱skej iga ankichijkej yej aye̱kti; iga yej cha̱ntitokej Nínive, kua̱ꞌ Jonás kipowaꞌ itájto̱l Dios, kikajtejkej iga kichi̱wayaj yej aye̱kti; iwá̱n nej ma̱jya sej que Jonás. ");
INSERT INTO nhx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kua̱ꞌ Dios tajuzga̱ro̱j, moketzas no̱ la reina yej manda̱roj ipan ta̱jli de Sabá iga mitzjuzga̱ro̱skej, iwá̱n kijto̱j iga ayompa ankichijkej. Inó̱n reina wejka nejnen iga makikakiki yej kimati rey Salomón; iwá̱n nej ma̱jya sej que Salomón. ");
INSERT INTO nhx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesús no̱ kijtoj: —Kua̱ꞌ se̱ ma̱lespí̱ritoj ki̱sa ipan se̱ ta̱gaꞌ, nentinemi ipan wá̱ꞌta̱l iga kite̱mojtinemi ka̱n makalaki; iwá̱n siga ayá̱ꞌ kasi, kijtowa: ");
INSERT INTO nhx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Nia sej nimokuepati nocha̱n, ka̱n niki̱saꞌ.” Kua̱ꞌ mokuepa, kasi inó̱n ta̱gaꞌ ken se̱ kajli yej ise̱lti onoꞌ, este tajtachpa̱ntolo̱ꞌ iwá̱n tayejye̱ꞌta̱lijtolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Iwá̱n yawi kikuiti seꞌ siete ma̱lespí̱ritoj yej ma̱jya sej que yéj, iwá̱n inochi̱n mocha̱ntiáj ipan inó̱n ta̱gaꞌ, iwá̱n inó̱n ta̱gaꞌ mochi̱was ma̱jya sej aye̱kti que achto. Ijko̱nsan no̱ mochi̱was iwá̱n ini̱mej gente yej ayá̱ꞌ ye̱ꞌnemij. ");
INSERT INTO nhx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús kita̱tapo̱wijtóyaoꞌ la gente, kua̱ꞌ asiꞌ iye̱ꞌ iwá̱n iyikni̱wa̱n. Awel kalakikej este kalijtiꞌ iga matajto̱ka̱n wa̱n yéj. ");
INSERT INTO nhx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Eꞌ agaj kimati̱ltij Jesús, kijlij: —Moye̱ꞌ iwá̱n mookichikni̱wa̱n onokej fuera iwá̱n kinekij matajto̱ka̱n mowa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Eꞌ Jesús kijlij inó̱n yej kimati̱ltij: —¿A̱ꞌyéj noye̱ꞌ iwá̱n a̱ꞌyéj nookichikni̱wa̱n? ");
INSERT INTO nhx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Iwá̱n Jesús kimajpilwij idisci̱polojmej, iwá̱n kijtoj: —Nigaj onoꞌ noye̱ꞌ iwá̱n nookichikni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yej kichi̱wa ken kineki noTaj yej onoꞌ ipan cielo, ino̱nwaꞌ in nookichikni̱n, nosiwa‑ikni̱n iwá̱n noye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Inó̱n día Jesús ki̱saꞌ kalijtiꞌ iwá̱n mota̱lij ipan lagu̱najte̱n. ");
INSERT INTO nhx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iga póxsanya monechko̱lo̱ꞌ, Jesús tejkaj ipan se̱ weyi á̱ka̱l iwá̱n ompa mota̱lij, iwá̱n nochi tokni̱mej ka̱wikej ipan a̱te̱n. ");
INSERT INTO nhx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Iwá̱n pe̱waꞌ se̱seꞌpa iga tamachtij ka̱n wel mamiji̱xkui̱tilo, kijtoj: —Se̱ ta̱gaꞌ yajki to̱kato, kipa̱pata̱náltijpa trigo. ");
INSERT INTO nhx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","’Ka̱n nemi to̱ktiá, onoꞌ yej wetzitoj ipan ojti, iwá̱n wa̱lkej to̱to̱mej iwá̱n kikuajkej. ");
INSERT INTO nhx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Onoꞌ yej wetzito tetza̱la̱n, ka̱n onoꞌ ajalí̱n ta̱jli. Iwá̱n inó̱n íyo̱l trigo ixwaꞌ nimaní̱n iga ta̱jli ayá̱ꞌ pox tilaktiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Eꞌ kua̱ꞌ to̱natiki̱saꞌ, pili̱niꞌ, iwá̱n wa̱guiꞌ iga ayá̱ꞌ monelwatij. ");
INSERT INTO nhx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Onoꞌ yej wetzito ipan witzyoj, witzyoj wejweyakej iwá̱n kijiyo̱miktij tato̱ꞌ iwá̱n ayá̱ꞌ ta̱guiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Eꞌ onoꞌ yej wetzito ipan yé̱ꞌta̱l, iwá̱n poxsan mochij; sekin ipan sejsé̱ imia̱wayo kita̱lilij cien íyo̱l ipan se̱ íyo̱l yej kito̱gaꞌ, iwá̱n sekin kita̱lilij sesenta íyo̱l, iwá̱n sekin treinta. ");
INSERT INTO nhx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yej annakasyojkej, ¡xine̱ye̱ꞌkakika̱n! ");
INSERT INTO nhx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iwá̱n disci̱polojmej kitechojkej Jesús iwá̱n kitajtankej: —¿Te iga ipan mi̱xkui̱tilis tikmachtiá la gente? ");
INSERT INTO nhx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús kijtoj: —Amejeme̱n Dios mitzmati̱ltiáj yej aya agaj kimati ken yéj reina̱rowa, eꞌ yejemej awel kimatij. ");
INSERT INTO nhx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Yej kipiá, yawij má̱j kimakatij, este po̱póxsanya sej yawi kipiati; eꞌ yej akipiá, este yej alí̱n kipiá, yawij kikui̱li̱tij. ");
INSERT INTO nhx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Inó̱n iga sekin nikpowiliapa ka̱n mami̱xkui̱ti̱ka̱n; iga yejemej tacháj, eꞌ ken tikita yej pachamej, kikakij, eꞌ ayá̱ꞌ kimatij te̱ iteki, ken tikita yej ayá̱ꞌ takakij. ");
INSERT INTO nhx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ipan yejemej mochi̱wa yej kijtoj el profeta Isaías, kijtoj: Amejeme̱n ankikakiskej, eꞌ ayá̱ꞌ ankimatiskej te̱ kijto̱jneki; ankitaskej, eꞌ ken kua̱ꞌ nité̱ ayá̱ꞌ ankitakej. ");
INSERT INTO nhx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Iga ini̱mej poxsan moyo̱ltakua̱wilijkej, ayá̱ꞌ ye̱ꞌtakakij, kitzajtzaktokej iyi̱xmej; iga amo matachaka̱n iga iyi̱xmej, niga matakakika̱n iga inakasmej, niga makentende̱ro̱ka̱n iga iya̱lmajmej, niga mawi̱tzeka̱n note̱noj iga manikachitialti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","’Eꞌ amejeme̱n xipa̱kika̱n iga anne‑itztokej iwá̱n ankikakij notájto̱l. ");
INSERT INTO nhx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nimitzijliáj iga miaꞌ profe̱tajmej iwá̱n re̱yejmej kitasnekiá̱j iní̱n yej ankitztokej iwá̱n ayá̱ꞌ kitakej; kinekiáj makikakika̱n iní̱n yej amejeme̱n nemi ankikakij, iwá̱n ayá̱ꞌ kikakikej. ");
INSERT INTO nhx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Iná̱n xikakika̱n, nia nimitzijli̱tij te̱ kijto̱jneki inó̱n ka̱n mi̱xkui̱tilo ipan inó̱n yej to̱ka. ");
INSERT INTO nhx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yej kikakij ye̱ꞌnoti̱ciaj yej tane̱xtiliá ken iga reina̱rowa Dios iwá̱n ayá̱ꞌ kimatij te̱ kijto̱jneki, inó̱mejwaꞌ ken tikita inó̱n íyo̱l trigo yej wetziꞌ ipan ojti, iwá̱n wi̱ꞌ Tzitzimiꞌ iwá̱n ke̱lka̱waltiá notájto̱l yej acha̱ onoya ipan iya̱lmajmej. ");
INSERT INTO nhx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Iwá̱n inó̱n íyo̱l trigo yej wetzito tetza̱la̱n, inó̱n kijto̱jneki yej kikakij itájto̱l Dios iwá̱n poxsan pa̱kij kua̱ꞌ kicre̱dójkejoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Eꞌ como ayá̱ꞌ wel monelwatiáj wejkatan, ayá̱ꞌ wejkatis iga moconfia̱rojtoskej nopan iga kua̱ꞌ kipiás se̱ prueba o kikno̱chi̱waj iga kicre̱dowaj itájto̱l Dios, ayá̱ꞌ kijyo̱wiáj, iwá̱n kikajté̱waja iga moconfia̱rowaj nopan. ");
INSERT INTO nhx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Iwá̱n inó̱n trigo yej wetziꞌ ipan witzyoj, inó̱n kijto̱jneki ino̱mej yej kikakij itájto̱l Dios, eꞌ poxsan kipiasnekij kuajkuantas yej onoꞌ ipan iní̱n ta̱jli, iwá̱n mokajkaya̱waj ipan tomi̱n. Nochi inó̱n, kichi̱wa iga itájto̱l Dios make̱lka̱wa iwá̱n inó̱n tokni̱n awel kichi̱wa yej ye̱kti ");
INSERT INTO nhx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Eꞌ inó̱n íyo̱l trigo yej wetzito ka̱n ye̱ꞌta̱jli, inó̱n kijto̱jneki yej kikakij itájto̱l Dios iwá̱n kentende̱rowaj. Ino̱mej kichi̱waj yej ye̱kti ken tikita inó̱n íyo̱l trigo yej kimáꞌ cien, sesenta iwá̱n ken yej kimáꞌ treinta íyo̱l ipan se̱ imia̱wayo. ");
INSERT INTO nhx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús kipowaꞌ seꞌ ka̱n mi̱xkui̱tilo: —Ka̱n reina̱rowa Dios ken tikita se̱ ta̱gaꞌ yej kito̱gaꞌ ye̱ꞌsemi̱llaj ipan ími̱l. ");
INSERT INTO nhx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Eꞌ kua̱ꞌ kojkochtólo̱ꞌya, wa̱laj se̱ yej kijiya ite̱ko mi̱jli, iwá̱n itza̱la̱n trigo kichtakato̱kako chakalsakaꞌ iwá̱n yájkiya. ");
INSERT INTO nhx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Eꞌ kua̱ꞌ weyaꞌya trigo iwá̱n mia̱watapa̱nikej, íkua̱ꞌya ne̱siꞌ in inó̱n chakalsakaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Iwá̱n tekipanowa̱nimej yajkij kitatoj ite̱ko mi̱jli, kijlijkej: “Patrón, esi inó̱n semilla yej tikto̱gaꞌ momi̱lpan ye̱ꞌsemi̱llaj, ¿ix kéntaj a̱n iga ixwaꞌ chakalsakaꞌ?” ");
INSERT INTO nhx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ite̱ko mi̱jli kijtoj: “Anka agaj yej ne‑ijiya kichtakato̱kako.” Ino̱mej mo̱nsojmej kijtojkej: “¿Ix tikneki mania̱ka̱n manikwiwitatij?” ");
INSERT INTO nhx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ite̱ko mi̱jli kijtoj: “Amo, siga anyawij ankiwiwitatij chakalsakaꞌ, wel no̱ ankiwiwitaj trigo. ");
INSERT INTO nhx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xikajte̱waka̱n, ka̱ma sen‑onoka̱n este kua̱ꞌ motekis trigo; íkua̱ꞌ nikti̱tanis tekipanowa̱nimej yej makiwiwitaka̱n achto chakalsakaꞌ iwá̱n makinechko̱ka̱n iga makitati̱ka̱n, iwá̱n kinechko̱skej trigo ka̱n moe̱na.” ");
INSERT INTO nhx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús kine̱xtilij seꞌ ka̱n mami̱xkui̱tilo: —Ka̱n reina̱rowa Dios, ken tikita se̱ íyo̱l mostaza yej se̱ ta̱gaꞌ kito̱gaꞌ ipan íta̱l. ");
INSERT INTO nhx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Malej iga íyo̱l mostaza má̱j ali̱mpa de inochi yej onoꞌ; eꞌ kua̱ꞌ weyá mochi̱wa ma̱jya sej que nochi yej to̱ktoꞌ ka̱n tatojto̱kalo, mochi̱wa weyi kuawé̱j iwá̱n ipan imajma̱ꞌ moxeketiáj to̱to̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús tamachtij seꞌ ka̱n mami̱xkui̱tilo: —Ka̱n reina̱rowa Dios, ken tikita levadura yej se̱ siwa̱ꞌ ka̱xakualowa iwá̱n komati harina, iwá̱n moposa̱wa inewi tixti. ");
INSERT INTO nhx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús nochipa tamachtij ka̱n wel mami̱xkui̱tilo, ayá̱ꞌ tamachtij siga ayá̱ꞌ tajtowa ka̱n mi̱xkui̱tilo. ");
INSERT INTO nhx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Inó̱n mochij iga mamochi̱wa ken kijtoj se̱ profeta: Nia nitajto̱ti ka̱n wel mami̱xkui̱tilo. Nia nikijto̱ti yej aya i̱ꞌ momatiá este que Dios kichij ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús kikajtej la gente yej ompa onoyaj iwá̱n yájkiya kalijtiꞌ, ompa idisci̱polojmej kitechojkej Jesús iwá̱n kitajtankej: —Ta̱ xine‑ijli̱ka̱n te̱ kijto̱jneki o̱n chakalsakaꞌ yej ixwaꞌ mi̱lijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús kijtoj: —Yej kito̱ka ye̱ꞌsemi̱llaj ino̱nwaꞌ nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Iwá̱n mi̱jli kijto̱jneki no̱ya̱n ipan ta̱jli. Ye̱ꞌsemi̱llaj kijto̱jneki nochi yej kichi̱waj ken kineki Dios, chakalsakaꞌ kijto̱jneki yej kichi̱waj ken kineki Tzitzimiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yej ta‑ijiya, yej kito̱gaꞌ chakalsakaꞌ, ino̱nwaꞌ Tzitzimiꞌ. Kua̱ꞌ motekis trigo, kijto̱jneki kua̱ꞌ tamis iní̱n ta̱jli, iwá̱n tekipanowa̱nimej yej kitekiskej, inó̱n kijto̱jneki a̱ngelejmej. ");
INSERT INTO nhx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ijkó̱n ken chakalsakaꞌ monejnechkowa iga motatiá, ijko̱nsan no̱ mochi̱was kua̱ꞌ Dios tajuzga̱ro̱j. ");
INSERT INTO nhx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nej yej iPiltzi̱n Ta̱gaꞌ nikti̱tanis noa̱ngelejmej iga makikijki̱xti̱ka̱n ipan norre̱inoj yej tachi̱waltiáj yej aye̱kti iwá̱n yej kichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Iwá̱n kaki̱skej ipan tiwelo̱n, ompa cho̱katoskej este tajtangueguetzekaskej. ");
INSERT INTO nhx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Iwá̱n ino̱mej yej kichijkej ken kineki Dios, ta̱wi̱skej ken tikita to̱nati̱ꞌ ka̱n reina̱rowa Dios. Yej annakasyojkej, ¡xikye̱ꞌkakika̱n! ");
INSERT INTO nhx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Ka̱n reina̱rowa Dios ken tikita tejé̱ yej pox patiyoj yej i̱ya̱ntoꞌ ipan agaj íta̱l. Se̱ ta̱gaꞌ kasiꞌ yej pox patiyoj iwá̱n ómpasan sej ki̱ya̱n; iwá̱n pox pa̱ktiajki icha̱n iga kinamakato nochi yej kipiá iwá̱n kikowaꞌ inó̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’No̱ ka̱n reina̱rowa Dios ken tikita se̱ tanamakani yej kite̱mojtinemi perla yej pox mojmo̱nsajtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kua̱ꞌ kasi se̱ yej pox patiyoj, yawi icha̱n iga kinamakati inochi yej kipiá iga kikowa inó̱n perla. ");
INSERT INTO nhx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ka̱n reina̱rowa Dios ken tikita se̱ re̱dej yej mota̱liá ipan láma̱r, iwá̱n ípan kuaka̱wi de se̱seꞌpa to̱poj. ");
INSERT INTO nhx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kua̱ꞌ té̱miꞌya re̱dej, kiki̱xtiaja ipan a̱tate̱n, iwá̱n ómpaya mota̱liáj iga kitapejpenaj in to̱poj. Yej ye̱kti kakijtiawij chikiwiko, eꞌ yej ayéj ye̱ꞌto̱poj kitajkalij. ");
INSERT INTO nhx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ijkó̱n mochi̱was kua̱ꞌ tamis iní̱n ta̱jli; wi̱tzeskej a̱ngelejmej iga kiyokati̱kij yej ayá̱ꞌ ye̱ꞌnemij iwá̱n yej ye̱ꞌnemij, ");
INSERT INTO nhx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","iwá̱n yej aye̱kti kichi̱waj, kaki̱skej ipan tiwelo̱n, ompa cho̱kaskej este tajtangueguetzekaskej. ");
INSERT INTO nhx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iwá̱n Jesús kitajtan idisci̱polojmej: —¿Ix ankimatij te̱ nemi nikijtowa? Yejemej kijtojkej: —Kena, nikmatij. ");
INSERT INTO nhx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Iwá̱n Jesús kijtoj: —Kua̱ꞌ se̱ yej tamachtiá ipan la ley momachtiá ken iga reina̱rowa Dios, ne̱si ken se̱ ite̱ko kajli yej kimati te̱ keje̱ntoꞌ kalijtiꞌ, iwá̱n ompa kikijki̱xtiá yej kaxítijoꞌ iwá̱n yej ikyay kipiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kua̱ꞌ Jesús tamiꞌ tamachtij ipan ino̱mej ka̱n mi̱xkui̱tilo, yájkiya, ");
INSERT INTO nhx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","iwá̱n asito ipan iya̱ltepe̱ꞌ. Ompa pe̱ꞌ tamachtij tio̱pan, wa̱n yej ompa takaktoyaj, madmira̱dojkej, kijtowa̱yaj: —¿Ix ka̱n a̱n momachtij in iní̱n ta̱gaꞌ iga pox tajto̱lmati? ¿Kén iga wel kichi̱wa milagro yej ayi̱ꞌpa mo‑ita? ");
INSERT INTO nhx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Esi ini̱nwaꞌ ipiltzi̱n carpintero; iye̱ꞌ ito̱ka̱ꞌ María iwá̱n iyikni̱mej ito̱ka̱mej Jacobo, José, Simón iwá̱n Judas. ");
INSERT INTO nhx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Isiwa‑ikni̱wa̱n nigaj no̱ icha̱mej. ¿Kén kichi̱wa iga kipoxmati iwá̱n iga wel kichi̱wa milagro? ");
INSERT INTO nhx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Inó̱n iga ayá̱ꞌ kitajto̱lkuikej. Eꞌ Jesús kijtoj: —Se̱ profeta no̱ya̱n kiye̱ꞌitaj, eꞌ ayéj ijkó̱n ipan iya̱ltepe̱ꞌ niga ka̱n onokej iyikni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Inó̱n iga Jesús ipan iya̱ltepe̱ꞌ ayá̱ꞌ kichij miaꞌ milagro, iga ayá̱ꞌ moconfia̱rowa̱yaj ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gobernador Herodes yej manda̱rowa̱ya Galilea, kikaguiꞌ yej kichijtinemi Jesús, ");
INSERT INTO nhx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","iwá̱n kijlij itekipanowa̱nimej: —Ino̱nwaꞌ Juan yej tabautiza̱rowa̱ya, yéj nokta ojpa‑isaꞌ sej ka̱n miktoya. Inó̱n iga wel kichi̱wa milagro yej ayí̱ꞌ mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Íkyaya Juan kijlij Herodes: —Aye̱kti iga tikuiꞌ iga mosiwa̱ꞌ Herodías, yej isiwa̱ꞌ katka mokni̱n Felipe. Kua̱ꞌ inó̱n kikáꞌ, Herodes tatekimáꞌ iga makilpi̱ka̱n Juan iga makipre̱sojwi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes kimikti̱jnekiá Juan, eꞌ kimajmawilia̱ya la gente, iga momatiá iga Juan katka profeta. ");
INSERT INTO nhx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Eꞌ kua̱ꞌ iyilwi Herodes iga icu̱mpleaños, isiwa̱piltzi̱n Herodías mijto̱tij iyi̱xtaj yej ompa onoyaj, iwá̱n Herodes kipoxye̱ꞌitaꞌ, ");
INSERT INTO nhx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","kinojma‑ijlij nokta iga yawi kimakati te̱san kitajtanis inó̱n takotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Iwá̱n inó̱n takotzi̱n, kitajtan kensan iye̱ꞌ kijlij, ijkí̱n kijlij Herodes: —Nikneki xine̱maka ipan se̱ plato itzontekon Juan yej tabautiza̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodes mokno̱matiꞌ iga inó̱n kikáꞌ; eꞌ como kíjtoja iwá̱n kikakikej yej ompa takuajtoyaj iga yawi kimakati te̱san kitajtanis inó̱n takotzi̱n, inó̱n iga tatekimáꞌ iga makimakaka̱n yej kitajtan. ");
INSERT INTO nhx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Iwá̱n Herodes tati̱tan iga makikechtekitij Juan ka̱n pre̱sojtitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Iwá̱n kiwajligakej itzontekon Juan ipan se̱ pla̱tojwé̱j, iwá̱n kimajkui̱ltíjkeja inó̱n takotzi̱n iwá̱n kimakato iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Iwá̱n idisci̱polojmej Juan asikej ka̱n miktoꞌ Juan iwá̱n kito̱kátoja, iwá̱n yajkij kimati̱lti̱toj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kua̱ꞌ Jesús kimatiꞌ iga kimiktíjkeja Juan, ki̱saꞌ ompa, tejkaj ipan se̱ á̱ka̱l iga yajki ka̱n ayagaj onoꞌ. Eꞌ momátiꞌsan, iwá̱n ki̱salo̱ꞌ ipan a̱ltepe̱mej, iwá̱n kitokatiajkij, ikxinejnentiájkijpa. ");
INSERT INTO nhx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kua̱ꞌ Jesús témoja ipan á̱ka̱l, kitaꞌ iga poxsan mialo̱ꞌ, iwá̱n kikne̱lij nochi ino̱mej iwá̱n kachitialtij nochi yej we̱titoyaj. ");
INSERT INTO nhx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Iwá̱n kua̱ꞌ némiya tayowati, idisci̱polojmej kitechojkej Jesús, iwá̱n kijlijkej: —Tió̱taꞌya, nigaj ayá̱ꞌ cha̱ntitolo̱ꞌ. Xikijli ini̱mej gente iga maya̱ka̱n ipan a̱ltepe̱tzitzi̱n, iwá̱n ompiga makikowaka̱n te̱ kikua̱skej. ");
INSERT INTO nhx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús kijtoj: —Amo mayajya̱ka̱n; amejeme̱n xiktamakaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Disci̱polojmej kijtojkej: —Anikpiáj te̱ má̱j, petz se̱ ma̱noj pa̱n iwá̱n o̱me to̱poj. ");
INSERT INTO nhx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Iwá̱n Jesús kijtoj: —Nijpa xine̱wajliguili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jesús tatekimáꞌ iga mamota̱lilo ipan sakatzitzi̱n. Kikuiꞌ inó̱n se̱ ma̱noj pa̱n iwá̱n inó̱n o̱me to̱poj, ajkotacháꞌ iga kimáꞌ gracias Dios iwá̱n kita̱tajkoloj pa̱n, iwá̱n kimajmáꞌ idisci̱polojmej iga makimajmakaka̱n la gente. ");
INSERT INTO nhx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Takuajkej inochimej este ijixwikej, iwá̱n kua̱ꞌ disci̱polojmej kinechkojkej tákual yej ayꞌ kikuajkej, te̱miꞌ doce chikiwiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Yej takuajkej ken cinco mil tajta̱gaꞌ iyókawaꞌ in siwa̱tkej iwá̱n ko̱kone̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kua̱ꞌ támiꞌya takuajkej, Jesús kitekimáꞌ idisci̱polojmej iga matejkawíka̱nya ipan á̱ka̱l iga maa̱pano̱ka̱n achto yejeme̱n, mie̱j Jesús tanawatijtiká̱wigoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kua̱ꞌ yájkija, Jesús tejkaj ipan tepe̱ꞌ ise̱lti iga tajto̱to wa̱n Dios. Ompa onoya ise̱lti te kua̱ꞌ tayowatiꞌ, ");
INSERT INTO nhx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","iwá̱n á̱ka̱l ya̱yay tajko laguna. Iwá̱n maréja̱l paré̱j mowi̱tekiá ipan á̱ka̱l iga ki̱xna̱ntiá̱yapa ejekaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kua̱ꞌ tane̱stíwi̱ꞌya, Jesús yajki ka̱n nemi yawij idisci̱polojmej ipan á̱ka̱l, Jesús nejnentia̱ya iyi̱xko a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Iwá̱n kua̱ꞌ disci̱polojmej kitakej iga nejnentiwi̱ꞌ ipan a̱ꞌti, poxsan momajtijkej, iwá̱n mo̱ka̱tzajtzikej: —¡Taꞌ xikitaka̱n, se̱ á̱nimaj! ");
INSERT INTO nhx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Eꞌ Jesús nimaní̱n kijtoj: —¡Tamelá̱ xonoka̱n! ¡Nej niJesús, amo ximajmawika̱n! ");
INSERT INTO nhx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Iwá̱n Pedro kijtoj: —NoTe̱ko siga melá̱ꞌ iga tej, xikijto iga maninejnentiapa iyi̱xko a̱ꞌti este ka̱n tej tonoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesús kijtoj: —Xinejnémiwaꞌ. Iwá̱n Pedro temoj ipan á̱ka̱l, iwá̱n a̱nejnentia̱ya iyi̱xko a̱ꞌti iga ya̱ya ka̱n onoꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Eꞌ kua̱ꞌ kimachi̱lij ejekaꞌ yej pox tajpalej, momajtij iwá̱n pe̱waꞌ iga mi̱sawiá iwá̱n tzajtziꞌ: —¡NoTe̱ko xine̱ma̱nawi! ");
INSERT INTO nhx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iwá̱n nimaní̱n Jesús kima̱tila̱n Pedro, iwá̱n kijlij: —¡Mataj tej nema̱n timoconfia̱rowa nopan! ¿Te iga ayá̱ꞌ timomelaꞌconfia̱roj ipan nej? ");
INSERT INTO nhx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kua̱ꞌ iyo̱mextimej tejkájkeja ipan á̱ka̱l, pachiwiꞌ in ejekaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iwá̱n yej onoyaj ipan á̱ka̱l motankua̱ketzkej iyi̱xtaj Jesús iwá̱n kijtojkej: —Mataj melá̱ꞌ, tej iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","A̱panojkej iwá̱n asikej ipan ta̱jli de Genesaret. ");
INSERT INTO nhx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kua̱ꞌ yej ompa cha̱ntitokej ki̱xmatikej iga Jesús, kipojkej no̱ya̱n ipan inó̱n ta̱jli, wa̱n kiwijwi̱gakej ite̱noj Jesús nochi yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Iwá̱n yej we̱titokej kitejtekiꞌijlikej Jesús iga mamote̱maka iga makichijchimili̱ka̱n malej ite̱mpan itzótzol, iwá̱n nochi yej kichijchimilijkej, achitiakej. ");
INSERT INTO nhx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kitechojkej Jesús sekin fariseojmej iwá̱n yej tamachtiáj ipan iley Moisés, ino̱mej wa̱lkej Jerusalén iwá̱n kitajtankej: ");
INSERT INTO nhx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Te iga modisci̱polojmej ayá̱ꞌ kichi̱waj ken to‑ikyapatajwe̱wetkej tane̱xtilia̱yaj iga mamochi̱wa? ¡Ayá̱ꞌ moma̱pa̱kaj kua̱ꞌ yáwija takua̱tij! ");
INSERT INTO nhx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Iwá̱n Jesús tatajtan: —¿Te iga ayá̱ꞌ ankichi̱waj ken tatekimaka Dios? Ma̱jwaꞌ ankichi̱waj ken amejéme̱mpa antamachtiáj. ");
INSERT INTO nhx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Dios ijkí̱n tatekimáꞌ: “Xikchi̱wa ken mitztekimaka motaj iwá̱n moye̱ꞌ iwá̱n xikpale̱wi̱ka̱n”, iwá̱n “Yej makima̱lijli itaj o iye̱ꞌ, kajasi iga mamíkiya.” ");
INSERT INTO nhx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Eꞌ amejeme̱n ankijtowaj iga se̱ ta̱gaꞌ wel ijkí̱n kijliá itaj o iye̱ꞌ: “Awel nimitzpale̱wiáj, iga nochi yej nikpiá nikmaꞌya toDio̱s.” ");
INSERT INTO nhx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yej ijkó̱n kijtowa iwá̱n akineki makipale̱wi itaj o iye̱ꞌ, ayꞌ makichi̱wa. Ijkó̱n amejeme̱n nemi ankikajte̱waj yej Dios mitztekimakakej, ma̱jwaꞌ ankitokaj ken antekitamachtiáj. ");
INSERT INTO nhx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Amejeme̱n san anmopajpantiáj iga anye̱ꞌnemij! Ómpaya ken kijtoj el profeta Isaías, iga amejeme̱n nokta ijkí̱n kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Iga amoté̱mejsan anne̱weyimati̱ltiáj, eꞌ má̱j ipan amoa̱lmajmej ni alí̱n nokta ayá̱ꞌ anneejla̱mikij. ");
INSERT INTO nhx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ígasan anne̱weyimati̱ltiáj, iga antane̱xtiliáj ken ta̱gaꞌ tatekimaka iwá̱n tane̱xtiliá. ");
INSERT INTO nhx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iwá̱n Jesús kino̱tzaꞌ la gente, iwá̱n kijlij: —Xikakika̱n iwá̱n xikentende̱ro̱ka̱n: ");
INSERT INTO nhx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nité̱ yej agaj kikua o koniá kichi̱wiliá iga Dios ayoꞌ makiye̱ꞌita, eꞌ yej aye̱kti kijtowa, inó̱n kena, wel kichi̱wa iga Dios amo makiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iwá̱n disci̱polojmej kitechojkej Jesús, iwá̱n kijlijkej: —¿Ix tikmati iga fariseojmej kikualomatikej kua̱ꞌ kikakikej yej tikijtoj? ");
INSERT INTO nhx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Eꞌ Jesús kijtoj: —NoTaj yej onoꞌ ipan cielo kichi̱was wa̱n fariseojmej ken kichi̱wa se̱ mi̱lchi̱wani: tato̱ꞌ yej ayá̱ꞌ kito̱gaꞌ, yawi kiwiwitati este inelwayo. ");
INSERT INTO nhx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ka̱ma kuesiwika̱n; yejémejwaꞌ ken tikita pachamej yej kojkui̱ltiáj ipacha‑ikni̱mej. Siga se̱ pacha kojkui̱ltiá seꞌ pacha, yawij senwetzitij ipan se̱ xapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iwá̱n Pedro kijlij Jesús: —Nejeme̱n niknekij xine‑ijli̱ka̱n te̱ kijto̱jneki inó̱n yej tikijtoj. ");
INSERT INTO nhx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús kijtoj: —¿In amejéme̱ntaj no̱ ayá̱ꞌ ankimatij te̱ kijto̱jneki yej nej nikijtoj? ");
INSERT INTO nhx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ix aya̱ꞌtaj ankimatij iga kua̱ꞌ tejté̱ tikuaj yawi tojtiko iwá̱n ki̱sa? ");
INSERT INTO nhx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Eꞌ yej ankijtowaj yej ajaye̱kti, inó̱n ki̱sa pan amoa̱lmaj, inó̱nyawaꞌ in yej kichi̱wa iga Dios amitzye̱ꞌitaj. ");
INSERT INTO nhx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Iga se̱ ipan iya̱lmaj kejla̱miki iga kichi̱wasneki yej ajaye̱kti, iga tamiktiáj, iga yej mona̱míktija yawi wa̱n seꞌ, iga masij agaj kua̱ꞌ áyapa mona̱miktiáj, iga tachtekij, iga takajkaya̱waj, iwá̱n iga tapo̱powaj. ");
INSERT INTO nhx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ini̱mej yej kichi̱wiliá iga Dios ayoꞌ makiye̱ꞌita agaj, eꞌ kua̱ꞌ se̱ takua aya̱ꞌpa moye̱ꞌma̱pa̱ka, inó̱n ayá̱ꞌ kichi̱was iga Dios ayoꞌ kiye̱ꞌitas. ");
INSERT INTO nhx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús ki̱saꞌ ompa iwá̱n yajki ipan íta̱l a̱ltepe̱mej Tiro iwá̱n Sidón. ");
INSERT INTO nhx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Se̱ siwa̱ꞌ de Canaán yej cha̱ntitoya ipan inó̱n ta̱jli, tzajtzitiwa̱laj ka̱n onoꞌ Jesús: —¡NoTe̱ko, tej yej iPiltzi̱n David, achi xine‑ikne̱li! Notaochi̱n kipiá ma̱lespí̱ritoj iwá̱n poxsan kikno̱chi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Eꞌ Jesús akino̱tzaꞌ inó̱n siwa̱ꞌ. Iwá̱n idisci̱polojmej kina̱ꞌtecho̱toj Jesús, kijtojkej: —¡Xikijli inó̱n siwa̱ꞌ iga mayáwiya; ayꞌya matzajtzitiwi̱ki totepotztaj! ");
INSERT INTO nhx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús kijlij inó̱n siwa̱ꞌ: —Dios ne̱ti̱tan iga nikpale̱wi̱ko petz israeli̱tajmej yej pojpolijtinemij ken tikita borre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Eꞌ inó̱n siwa̱ꞌ motankua̱ketzaꞌ iyi̱xtaj Jesús iwá̱n kijlij: —¡NoTe̱ko, achi xine̱pale̱wi! ");
INSERT INTO nhx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Iwá̱n Jesús kijlij: —Awel agaj kikui̱liá itákual ipilowa̱n iga makimaka pe̱lomej. ");
INSERT INTO nhx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Eꞌ inó̱n siwa̱ꞌ kijtoj: —Je̱kej, ijkó̱n nokta noTe̱ko, eꞌ pe̱lomej kikuaj takualta̱tájkol yej kipejpenaj yej xi̱ni itampa mesa ka̱n takuaj ite̱komej. ");
INSERT INTO nhx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iwá̱n Jesús kijlij inó̱n siwa̱ꞌ: —¡Nej nikita iga tej pox timoconfia̱rowa nopan! Mamochi̱wa ken tej tikneki. Iwá̱n íkua̱ꞌsan achitiáꞌ itaochi̱n inó̱n siwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús ki̱saꞌ ompa iwá̱n panoj ipan a̱te̱n laguna yej ito̱ka̱ꞌ Galilea, iwá̱n tejkaj ipan se̱ tepe̱ꞌ iwá̱n ompa mota̱lij. ");
INSERT INTO nhx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Miaꞌ asiꞌ ka̱n yéj e̱watoya, kiwi̱guilijkej yej ko̱xomej, pachamej, no̱nojmej, yej ma̱takua̱wayaxtokej iwá̱n miaꞌ má̱j yej we̱titokej. Kika̱watoj ite̱noj Jesús iwá̱n yéj nochi kachitialtij. ");
INSERT INTO nhx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Inó̱n íga poxsan madmira̱do̱lo̱ꞌ iga kitakej yej no̱nojtitoyaj welya tajtojkej, yej ma̱takua̱wayaxtoyaj, ye̱ktiakej ima̱mej, yej ko̱xotitoyaj welya nejnenkej, iwá̱n yej pachatitoyaj welya no̱ tachakej. Iwá̱n pe̱ꞌ iga poxsan kiweyimati̱ltijkej iDio̱s israeli̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iwá̱n Jesús kino̱tzaꞌ idisci̱polojmej, iwá̱n kijlijkej: —Nej cho̱ka noa̱lmaj iga ini̱mej gente kipiaya e̱yi días iga nigaj onokej nowa̱n, iwá̱n ayá̱ꞌ kipiáj te̱ kikuaj, iwá̱n anikneki maniktijti̱taníka̱nya, awel mamaya̱ntia̱ka̱n, amo tapoliwiskej ipan ojti. ");
INSERT INTO nhx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Idisci̱polojmej kijtojkej: —Eꞌ ¿ká̱nyawaꞌ a̱n nikuitij tákual iga nochi yejemej, nigaj ayagaj cha̱ntitoꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús tatajtan: —¿Ké̱skitaj pa̱n ankipiáj in amejeme̱n? Kijtojkej idisci̱polojmej: —Siete pa̱n iwá̱n alí̱n to̱pojtzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iwá̱n Jesús tatekimáꞌ iga nochi gente mamotajta̱li̱ka̱n ta̱lpan. ");
INSERT INTO nhx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Iwá̱n Jesús kikuiꞌ inó̱n siete pa̱n iwá̱n inó̱n to̱pojmej, iwá̱n kimáꞌ gracias Dios. Kita̱tajkoloj iwá̱n kimajmáꞌ idisci̱polojmej iga yejeme̱n makimajmakaka̱n inochi gente. ");
INSERT INTO nhx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Iwá̱n nochi takuajkej este ijixwikej. Iwá̱n kinechkojkej takualta̱tájkol yej ayoꞌ kikuajkej este te̱miꞌ siete chikiwiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Takuajkej cuatro mil tajta̱gaꞌ, iyókapa siwa̱tkej iwá̱n ko̱kone̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Iwá̱n Jesús kijlij ino̱mej gente iga mayá̱ka̱nya, kalakito ipan á̱ka̱l iga yájkiya ite̱noj a̱ltepe̱ꞌ de Magdala. ");
INSERT INTO nhx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseojmej iwá̱n saduceojmej yajkij kitatoj Jesús, iwá̱n iga wel makima̱wetzi̱lti̱ka̱n, kitajtanili̱toj iga makine̱xtili̱ka̱n tejté̱ yej ayi̱ꞌpa mo‑ita yej Dio̱ssan wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Eꞌ Jesús kijtoj: —Kua̱ꞌ kalaktiaya to̱nati̱ꞌ iwá̱n ankitaj este chi̱ltiꞌ cielo, amejeme̱n ankijtowaj: “A̱n sí mo̱sta yawi to̱nati.” ");
INSERT INTO nhx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iwá̱n yowaltiꞌ ankijtowaj: “Iná̱n sí ataye̱ka̱n iga este chi̱ltiꞌ cielo iwá̱n tamixtaj.” Amejeme̱n ankimatij te̱ kijto̱jneki kua̱ꞌ ankitaj ken mota̱liá cielo, eꞌ awel ankentende̱rowaj yej nejpa nemi nikchi̱wa yej Dios nemi mitzne̱xtiliáj. ");
INSERT INTO nhx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Amejeme̱n ayá̱ꞌ anye̱ꞌnemij niga ankicre̱dowaj Dios, ankinekij xikitaka̱n yej ayi̱ꞌpa mo‑ita; eꞌ ayá̱ꞌ nimitzne̱xtili̱skej yej ayi̱ꞌpa mo‑ita, petz yej Dios kichi̱wilij Jonás. Iwá̱n Jesús yájkiya. ");
INSERT INTO nhx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kua̱ꞌ idisci̱polojmej a̱panojkej, ke̱lkajkej iga makiwi̱gaka̱n pa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iwá̱n Jesús kijtoj: —Taꞌ xikakika̱n; amo xikchi̱waka̱n ken kitekichi̱waj fariseojmej iwá̱n saduceojmej, iga yejemej né̱sikiꞌ ye̱ꞌnemij, sie̱mpa ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Disci̱polojmej mojlia̱yaj: —Anka ijkó̱n te‑ijliá iga atikuajligakej pa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Eꞌ Jesús kimatiꞌ te̱ kijtojtokej idisci̱polojmej, iwá̱n kijlijkej: —¿Te iga ankijtowaj iga ayá̱ꞌ ankipiáj pan? ¡Mataj amejeme̱n ayá̱ꞌ amomelaꞌconfia̱rowaj ipan nej! ");
INSERT INTO nhx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Ix ayꞌya ankejla̱mikij kua̱ꞌ tiktamakakej cinco mil tajta̱gaꞌ gasan cinco pa̱n? ¿Ix ayꞌya ankejla̱mikij ke̱ꞌ chikiwiꞌ ankite̱mijkej iga tákual yej ayꞌ kikuajkej? ");
INSERT INTO nhx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ix ayꞌya no̱ ankejla̱mikij iga siete pa̱n tiktamakakej cuatro mil tajta̱gaꞌ? ¿Ix ayꞌya ankejla̱mikij ke̱ꞌ chikiwiꞌ ankite̱mijkej iga tákual yej ayꞌ kikuajkej? ");
INSERT INTO nhx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Te iga ayá̱ꞌ ankentende̱rojkej iga nej ayá̱ꞌ nemi nitajtowa de pa̱n kua̱ꞌ nimitzijlijkej iga amo xikuika̱n ilevadu̱rajmej fariseojmej iwá̱n saduceojmej? ");
INSERT INTO nhx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Disci̱polojmej kimatikej iga Jesús ayá̱ꞌ nemi kijtowa levadura yejpa mota̱liliá pa̱n, sino que kijtoj iga amo makicre̱do̱ka̱n ken tamachtiáj fariseojmej iwá̱n saduceojmej. ");
INSERT INTO nhx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kua̱ꞌ Jesús asito ipan íta̱l a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Cesarea Filipo, kitajtan idisci̱polojmej: —In sekin, ¿té̱ kijtowaj de nej yej iPiltzi̱n Ta̱gaꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Disci̱polojmej kijtojkej: —Sekin kijtowaj iga tej tiJuan yej tabautiza̱rowa̱ya; sekin sej kijtowaj iga tej ikyapaprofe̱taj Elías, iwá̱n sekin sej kijtowaj iga tej ikyapaprofe̱taj Jeremías o agaj profeta. ");
INSERT INTO nhx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jesús tatajtan: —In amejeme̱n, ¿té̱ ankijtowaj de nej? ");
INSERT INTO nhx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón yej no̱ ito̱ka̱ꞌ Pedro kijtoj: —Tej tiCri̱stoj, yej iPiltzi̱n Dios yej isatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Iwá̱n Jesús kijtoj: —Xipa̱ki tej Simón yej ipiltzi̱n Jonás iga ayéj ta̱gaꞌ mitzmati̱ltij, noTaj yej onoꞌ ipan cielo mitzmati̱ltij. ");
INSERT INTO nhx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Iwá̱n nej, nimitzijliá iga tej moto̱ka̱ꞌ Pedro, iwá̱n ken mochi̱wa kajli ipan teꞌti, ijkó̱n ipan iní̱n teꞌti nikchi̱was iga miaꞌ moconfia̱ro̱skej pan nej iwá̱n Tzitzimiꞌ ayá̱ꞌ kita̱nili̱j. ");
INSERT INTO nhx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nia nimitzmakati notájto̱l yej ken tikita llave iga wel makalakilo ipan cielo ka̱n reina̱rowa Dios; yej ipan iní̱n ta̱jli tej tikijto̱j iga awel mochi̱wa, Dios yej onoꞌ ipan cielo kijto̱j no̱ iga awel. Iwá̱n yej tej tikijto̱j iga wel mochi̱wa ipan iní̱n ta̱jli, Dios yej onoꞌ ipan cielo no̱ kijto̱j iga wel. ");
INSERT INTO nhx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesús kijlij idisci̱polojmej iga amo agaj makijli̱ka̱n iga yéj Cristo. ");
INSERT INTO nhx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Íkua̱ꞌya Jesús pe̱ꞌ kijlij idisci̱polojmej: —Nej yej iPiltzi̱n Ta̱gaꞌ, yawij ne‑ikno̱chi̱watij poxsan iwá̱n yawij ne‑ijiyatij we̱wetkej yej manda̱rowaj iwá̱n ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés. Yawij ne̱mikti̱tij iwá̱n ipan e̱yi día nia ni‑ojpa‑isati sej. ");
INSERT INTO nhx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedro kiwi̱gaꞌ Jesús ka̱n iyokamej, pe̱ꞌ kijlij iga amo makijto ijkó̱n: —¡Amo Dios makineki! ¡Ayí̱ꞌ ijkó̱n mamitzchi̱wili̱ka̱n! ");
INSERT INTO nhx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Eꞌ Jesús kitachi̱lij Pedro iwá̱n kijlij: —¡Tzitzimiꞌ, xicholo note̱noj!, tej tine̱tzakuiliá. Tej ayá̱ꞌ tikejla̱miki ken Dios kejla̱miki, sino que tikejla̱miki ken tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jesús kijlij idisci̱polojmej: —Siga agaj kineki mane̱toka, ayꞌya makichi̱wa yej yéj kineki, iwá̱n manejnemi ipan noojwi malej iga makikno̱chi̱waka̱n poxsan este makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yej ayá̱ꞌ kinekis mamiki, yawi mikiti; eꞌ yej mikis iga nej ne̱toka, nochipa onos nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Itejas in ta̱gaꞌ iga makipiá inochi yej onoꞌ ipan iní̱n ta̱jli, siga yawi melaꞌpoliwiti iya̱lmaj? Ayagaj wel kikowa iga amo makipolo iya̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Iga nej yej iPiltzi̱n Ta̱gaꞌ niwi̱ꞌ iwá̱n iweyipode̱r toTaj iwá̱n no̱ iya̱ngelejmej, íkua̱ꞌya sí yawi kipaga̱ro̱ti sejsé̱ kensan iga kichij. ");
INSERT INTO nhx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nej nimitznojma‑ijliáj iga sekin yej nij onokej ayá̱ꞌ mikiskej este que mane‑itaka̱n maniwi̱ki nej yej iPiltzi̱n Ta̱gaꞌ iga manirreina̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kua̱ꞌ pánoja seis días, Jesús kiwi̱gaꞌ Pedro, Jacobo iwá̱n Juan yej iyíkni̱mpa Jacobo, iwá̱n yejéme̱nsan yajkij ipan se̱ tepe̱ꞌ yej wejkapan. ");
INSERT INTO nhx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ompa iyi̱xtaj ino̱mej idisci̱polojmej, Jesús seꞌpay ne̱siꞌ. Ta̱wij ixa̱yaꞌ kenya to̱nati̱ꞌ, itzótzol mochij este ichkátiꞌsan, este ta‑i̱xse̱wia̱ya. ");
INSERT INTO nhx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iwá̱n íkua̱ꞌya kitakej iga ne̱sikoj ikyapaprofe̱tajmej Elías iwá̱n Moisés, ta̱tapojtokej iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Iwá̱n Pedro kijlij Jesús: —NoTe̱ko, ¡ye̱kti iga nigaj nonokej! Siga tikneki, manikchi̱waka̱n e̱yi ra̱nchojtzitzi̱n, se̱ iga tej, se̱ iga Moisés iwá̱n seꞌ iga Elías. ");
INSERT INTO nhx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Mie̱j tajtojtoya Pedro wa̱laj se̱ mixti yej ta̱wiá iwá̱n kitzakuakoj. Iwá̱n ipan inó̱n mixti mokáꞌ se̱ tájto̱l yej kijtoj: —Ini̱nwaꞌ nokta in noPiltzi̱n yej nikpoxcho̱kiliá, iwá̱n yéj ne̱yo̱lchikajtoꞌ. Yéj xikakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kua̱ꞌ inó̱n kikakikej disci̱polojmej, motzojtzonto̱kkej este ta̱lpan, iwá̱n poxsan majmawikej. ");
INSERT INTO nhx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iwá̱n Jesús kitechoj idisci̱polojmej iwá̱n kita̱lij ima̱ꞌ ipan yejemej, iwá̱n kijlijkej: —Ximoketzaka̱n, amo ximajmawika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iwá̱n kua̱ꞌ tachakej, ayoꞌ má̱j agaj kitakej, isé̱ltisan Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Kua̱ꞌ némiya temowaj ipan tepe̱ꞌ, ijkí̱n kitekimáꞌ idisci̱polojmej: —Amo agaj xikijli̱ka̱n yej ankitakej, ankipowaskej este iga nej yej iPiltzi̱n Ta̱gaꞌ mani‑ojpa‑isa sej. ");
INSERT INTO nhx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iwá̱n disci̱polojmej kitajtankej Jesús: —¿Te ígataj yej tamachtiáj ipan iley Moisés kijtowaj iga achto wi̱ꞌ ikyapaprofe̱taj Elías? ");
INSERT INTO nhx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús kijtoj: —Kena, melá̱ꞌ iga Elías wi̱ꞌ achto, iga yéj nochi kiye̱ꞌta̱li̱j. ");
INSERT INTO nhx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Eꞌ nej nimitzijliáj iga Elías wá̱lkaya, iwá̱n yejemej ayá̱ꞌ ki̱xmatikej, ma̱jwaꞌ kichi̱wilijkej ken yejemej kinekikej. Ijko̱nsan no̱ nej yej iPiltzi̱n Ta̱gaꞌ yawij ne‑ikno̱chi̱watij. ");
INSERT INTO nhx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iwá̱n idisci̱polojmej kimatikej iga Jesús nemi tajtowa de Juan yej tabautiza̱rowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kua̱ꞌ asitoj ka̱n onolo̱ꞌ, se̱ ta̱gaꞌ kitechoj Jesús iwá̱n motankua̱ketzaꞌ iyi̱xtaj, kijlij: ");
INSERT INTO nhx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—NoTe̱ko, achi xikikne̱li nopiltzi̱n yej ta̱tapoliwi, poxsan kikno̱chijtoꞌ iní̱n kokolis; we̱wetzi tiko iwá̱n ipan a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nikui̱guilíjkaya modisci̱polojmej, eꞌ yejeme̱n awel kachitialtijkej. ");
INSERT INTO nhx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesús kijtoj: —¡Mataj amejeme̱n ayá̱ꞌ anmomelaꞌconfia̱rojtokej nopan iwá̱n ayá̱ꞌ anye̱ꞌnemij! ¿Este ké̱manoꞌ má̱j nia nonoti iwá̱n amejeme̱n? ¿Este ke̱man nia nimitzijyo̱wijtotij? Xine̱wajliguili̱ka̱n in chokotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Iwá̱n Jesús kajajwaꞌ inó̱n ma̱lespí̱ritoj, iwá̱n kiki̱xtij ipan inó̱n chokotzi̱n, iwá̱n íkua̱ꞌya achitiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kua̱ꞌ iyokámeja onokej disci̱polojmej iwá̱n Jesús, disci̱polojmej tatajtankej: —¿Te iga a̱n nokta nejeme̱n awel niki̱xtilijkej in inó̱n ma̱lespí̱ritoj? ");
INSERT INTO nhx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesús kijtoj: —Iga amejeme̱n ayá̱ꞌ anmomelaꞌconfia̱ro̱waj nopan. Siga katka anmoconfia̱rowa̱yaj malej alí̱n ke̱ꞌpa íyo̱l mostaza, wel ankijlia̱yaj iní̱n tepe̱ꞌ: “Xicholo ompa iwá̱n xaj nepa”; iwá̱n inó̱n tepe̱ꞌ cholo̱j. Nochi wel ankichi̱wayaj siga anmomelaꞌconfia̱ro̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Iní̱mpawaꞌ nokta ma̱lespí̱ritoj ayá̱ꞌ ki̱sa siga ayá̱ꞌ achto xi‑ora̱do̱ka̱n iwá̱n ximayuna̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Mie̱j Jesús iwá̱n idisci̱polojmej senemiáj ipan estado de Galilea, Jesús kijtoj: —Nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱ki̱tzki̱tij, ");
INSERT INTO nhx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","iwá̱n yawij ne̱mikti̱tij, eꞌ ipan e̱yi día iga nimikis, nia sej ni‑ojpa‑isati. Kua̱ꞌ inó̱n kikakikej disci̱polojmej pox mokno̱matikej. ");
INSERT INTO nhx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kua̱ꞌ Jesús iwá̱n idisci̱polojmej asitoj a̱ltepe̱ꞌ Capernaum, yej kicobra̱rowaj impuesto iga weyitio̱pan yajkij kitatoj Pedro, kitajtankej: —In yej mitzmachtiáj, ¿ix aya̱ꞌtaj kimaka tomi̱n iga weyitio̱pan? ");
INSERT INTO nhx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedro kijtoj: —Kena, kixta̱wa. Kua̱ꞌ Pedro kalaꞌ kalijtiꞌ, Jesús tatajtan: —¿Kén tikijtowa in tej, Simón? In re̱yejmej de iní̱n ta̱jli, ¿ix kicobra̱rowa yej yejpa ige̱ntej o yej wéjkapa icha̱mej? ");
INSERT INTO nhx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedro kijtoj: —Yej wejka icha̱mej. Jesús kijtoj: —Ánkawaꞌ yej yejpa ige̱ntej ayá̱ꞌ kicobra̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Eꞌ iga amo agaj matikuejkueso̱ka̱n, xaj xitapilo̱ti ne̱ laguna, iwá̱n yej áchtopa tikpilo̱j, ipan ite̱n tia tikasili̱ti se̱ tomi̱n yej kimakas iga xikixta̱wa no‑impue̱stoj iwá̱n yej de tej, iwá̱n xaj xikixta̱wati. ");
INSERT INTO nhx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Íkua̱ꞌ disci̱polojmej kitechojkej Jesús iwá̱n kitajtankej: —¿A̱ꞌyéj má̱j tayaka̱ntoꞌ ka̱n Dios reina̱rowa? ");
INSERT INTO nhx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iwá̱n Jesús kino̱tzaꞌ se̱ choochi̱n iwá̱n kiketzaꞌ tajkoya̱n ka̱n onokej idisci̱polojmej, ");
INSERT INTO nhx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","iwá̱n kijtoj: —Nimitznojma‑ijliáj siga ayá̱ꞌ ankipataskej ken annemij iwá̱n ayá̱ꞌ anmochi̱waj ken iní̱n choochi̱n, awel reina̱rowa Dios ipan amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yej má̱j tayaka̱ntoꞌ ka̱n reina̱rowa Dios, yej moali̱mpamati iwá̱n mochi̱wa ken iní̱n choochi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Siga agaj ko̱mema̱wiá se̱ ken iní̱n choochi̱n iga ne̱toka, ken kua̱ꞌ nejya yej nemi neo̱mema̱wiá. ");
INSERT INTO nhx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Si agaj makichi̱walti yej aye̱kti se̱ de ini̱mej yej ne̱tokaj, yej ayá̱ꞌ moweyimatij, má̱j ye̱kti katka makipi̱pilo̱lti̱ka̱n se̱ weyiteꞌti ipan ikech iwá̱n makimo̱taka̱n láma̱rko iga ompa maa̱miki. ");
INSERT INTO nhx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Ipan iní̱n ta̱jli pox onoꞌ yej kiyo̱ltila̱na se̱ iga makichi̱wa yej aye̱kti! Inó̱n nochipa onos, eꞌ poxsan kikno̱chi̱waskej yej matachi̱walti yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Inó̱n iga, siga moma̱ꞌ o mokxi mitzchi̱waltiá yej aye̱kti, xikteki iwá̱n xiktajkali wejka, má̱j ye̱kti xikalaki ka̱n onoꞌ Dios tima̱tájkol o tikxitájkol, eꞌ ayá̱ꞌ mitzmo̱taskej ipan tiwelo̱n yej ayí̱ꞌ se̱wis iwá̱n o̱me moma̱ꞌ iwá̱n o̱me mokxi. ");
INSERT INTO nhx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Siga moyi̱x mitzchi̱waltiá yej aye̱kti, xiki̱xti iwá̱n xiktajkali wejka, má̱j ye̱kti xikalaki ka̱n onoꞌ Dios iga se̱ moyi̱x que xikpiá o̱me iwá̱n mamitzmo̱taka̱n ipan tiwelo̱n yej ayí̱ꞌ se̱wis. ");
INSERT INTO nhx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Amo xikali̱mpamatika̱n ini̱mej yej ne̱tokaj. Nimitzijliáj iga iya̱ngelejmej yej kicuida̱rowaj, nochipa onokej iyi̱xtaj noTaj ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Nej yej iPiltzi̱n Ta̱gaꞌ niwa̱laj nikma̱nawi̱ko yej pojpoliwika. ");
INSERT INTO nhx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Kén ankitaj? Siga se̱ ta̱gaꞌ makipiá cien borrego, iwá̱n se̱ makipolo, ¿ix ayá̱ꞌ ómpaoꞌ kikajte̱was inó̱n noventa y nueve iwá̱n ya̱j kite̱mo̱ti yej poliwiꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iwá̱n siga casis, poxsan pa̱kis. Má̱j pa̱kis que iga ino̱mej noventa y nueve yej ayá̱ꞌ polijtoyaj. ");
INSERT INTO nhx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ijko̱nsan no̱ amoTaj yej onoꞌ ipan cielo, akineki mapoliwi nisé̱ de ini̱mej yej ne̱tokaj. ");
INSERT INTO nhx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Siga mokni̱n mitzchi̱wiliá tejté̱ yej aye̱kti, xitajto wa̱n yéj ka̱n amó̱me̱nsan iwá̱n xikijli iga ayompa yej mitzchi̱wilij. Siga mitztajto̱lkui̱lij, tiktá̱nija mokni̱n iga wel sej anmoye̱ꞌitaj. ");
INSERT INTO nhx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Eꞌ siga ayá̱ꞌ mitztajto̱lkui̱liá, xikno̱tza se̱ o o̱me tokni̱n iga no̱ makimatika̱n yej yawi mojto̱ti. Itájto̱l Dios kijtowa iga kua̱ꞌ agaj kite̱lwiáj, maonoka̱n o̱me o má̱j yej kitztoskej. ");
INSERT INTO nhx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Siga yejemej no̱ ayá̱ꞌ kitajto̱lkuij, xikmatí̱ltiya inochi tokni̱mej yej ne̱tokaj, siga yejemej no̱ ayá̱ꞌ kitajto̱lkuij, xikitaka̱n ken se̱ yej ná̱mo̱l yej ayá̱ꞌ ki̱xmati Dios, o ken se̱ yej kicobra̱rowa impuesto. ");
INSERT INTO nhx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Nej nimitzijliáj, yej ipan iní̱n ta̱jli ankijto̱skej iga awel mochi̱wa, Dios yej onoꞌ ipan cielo kijto̱j no̱ iga awel. Iwá̱n yej ankijto̱skej iga wel mochi̱wa ipan iní̱n ta̱jli, Dios yej onoꞌ ipan cielo no̱ kijto̱j iga wel. ");
INSERT INTO nhx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’No̱ nimitzijliáj, siga o̱me de amejeme̱n ipan iní̱n ta̱jli ankisentajtanij tejté̱ kua̱ꞌ an‑ora̱dowaj, noTaj yej ono ipan cielo yawij mitzmakatij. ");
INSERT INTO nhx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Iga ka̱n o̱me̱n o e̱yi tokni̱wa̱n monechkowaj iga ne̱weyimati̱ltiáj, nej ompa nonoꞌ tatajkoya̱n. ");
INSERT INTO nhx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Iwá̱n Pedro kitajtanito Jesús: —NoTe̱ko, ¿ke̱ꞌ ve̱j wel manikperdona̱rowili nokni̱n yej ne̱chi̱wiliá yej aye̱kti? ¿Ix este siete ve̱j? ");
INSERT INTO nhx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús kijtoj: —Nej ayá̱ꞌ nimitzijliá iga siete ve̱j, sino que este setenta veces siete. ");
INSERT INTO nhx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Inó̱n iga ka̱n reina̱rowa Dios, ken tikita se̱ rey yej kicobra̱rowa itekipanowa̱nimej yej kidebe̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kua̱ꞌ nemi tacobra̱rowa, kiwajliguilijkej se̱ itekipanowa̱ni yej debe̱rowa̱ya poxsan komati tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Eꞌ inó̱n tekipanowa̱ni ayá̱ꞌ kipiaya tomi̱n iga makikuepa ke̱ꞌ debe̱rowa, el rey tatekimáꞌ iga makinamakaka̱n iga esclavo iwá̱n isiwa̱ꞌ iwá̱n ipilowa̱n iwá̱n inochi yej kipiaya iga wel makikuepa ke̱ꞌ debe̱rowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Iwá̱n inó̱n tekipanowa̱ni motankua̱ketzaꞌ iyi̱xtaj el rey, iwá̱n kijlij: “NoTe̱ko acho̱ꞌ xine̱chá, iwá̱n nochi motomi̱n nia nimitzkuepeli̱ti.” ");
INSERT INTO nhx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Iwá̱n el rey kicho̱kilij inó̱n tekipanowa̱ni, iwá̱n kijlij iga make̱lká̱waya inó̱n yej kidebe̱rowa iwá̱n ayꞌya kipre̱sojwij. ");
INSERT INTO nhx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Eꞌ kí̱saꞌsan inó̱n tekipanowa̱ni, masiꞌ iwá̱n seꞌ itekipanowa̱ni‑ikni̱n yej kidebe̱rowa̱ya alí̱n. Kikechpa̱tzkaꞌ iwá̱n némiya kimiktia̱ya, kijlij: “¡Xine̱mákayakej yej tine̱debe̱rowa!” ");
INSERT INTO nhx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Iwá̱n inó̱n itekipanowa̱ni‑ikni̱n, motankua̱ketzaꞌ iyi̱xtaj iwá̱n kijlij: “Acho̱ꞌ xine̱chá, iwá̱n nochi motomi̱n nia nimitzkuepeli̱ti.” ");
INSERT INTO nhx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Eꞌ yéj ayá̱ꞌ kikne̱lij, ma̱jwaꞌ kipre̱sojwij iga makikuepa inochi ke̱ꞌ debe̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kua̱ꞌ sekin tekipanowa̱nimej kitakej inó̱n, kualo̱ꞌ iya̱lmajmej, iwá̱n nochi yajkij kipowili̱toj el rey. ");
INSERT INTO nhx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Iwá̱n el rey kino̱tzaꞌ inó̱n yej tapre̱sojwij, iwá̱n kijlij: “¡Titekipanowa̱ni yej pox tikchi̱wa yej aye̱kti! Nej nimitze̱lka̱wilij nochi yej tine̱debe̱rowa̱ya, iga tine̱tekiꞌtajtanilij. ");
INSERT INTO nhx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tej no̱ katka xikcho̱kili mokni̱n yej mitzdebe̱rowa, ken nej nimitzikne̱lij.” ");
INSERT INTO nhx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Iwá̱n el rey poxsan kuejkuesiwiꞌ, iwá̱n tatekimáꞌ iga makicastiga̱ro̱ka̱n este que makikuepa nochi ke̱ꞌ debe̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iwá̱n Jesús kijtoj: —Ijko̱nsan no̱ noTaj yej onoꞌ ipan cielo yawi kichi̱wati iwá̱n amejeme̱n, siga ayá̱ꞌ anke̱lka̱wiliáj iga nochi amoa̱lmaj yej mitzchi̱wiliáj amokni̱n. ");
INSERT INTO nhx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kua̱ꞌ Jesús tamiꞌ tajtoj, ki̱saꞌ Galilea, iwá̱n asiꞌ ipan estado de Judea yej onoꞌ iyi̱ka̱mpa we̱ya̱ꞌ Jordán. ");
INSERT INTO nhx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pox komati gente kitogaꞌ, iwá̱n ompa Jesús kachitialtij yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Iwá̱n sekin fariseojmej kitechojkej Jesús ka̱nsan makima̱wetzi̱lti̱ka̱n, kitajtankej: —¿Ix wel se̱ ta̱gaꞌ kikajte̱wa isiwa̱ꞌ iga san tejte‑iga? ");
INSERT INTO nhx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús kijtoj: —¿Ix ayí̱ꞌ ankilee̱rowaj ka̱n ijkuilijtoꞌ itájto̱l Dios, kijtowa iga kua̱ꞌ pe̱waꞌ nochi yej onoꞌ, Dios “kichij ta̱gaꞌ iwá̱n siwa̱ꞌ”? ");
INSERT INTO nhx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Iwá̱n kijtoj: “Inó̱n iga se̱ ta̱gaꞌ, kua̱ꞌ mona̱miktiá, kikajte̱was itaj iwá̱n iye̱ꞌ iga moseka̱ntí̱skeja iwá̱n isiwa̱ꞌ, iwá̱n iyo̱mextimej mochi̱waskej ken se̱san.” ");
INSERT INTO nhx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iwá̱n ayꞌya onoskej ken o̱memej, sino que se̱san. Inó̱n iga amo agaj makiyokati yej Dios kise̱tilij. ");
INSERT INTO nhx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseojmej kitajtankej Jesús: —¿Te ígataj Moisés kijtoj iga se̱ ta̱gaꞌ wel kika̱wa isiwa̱ꞌ siga kichi̱wiliá se̱ a̱maꞌ ka̱n kijtowa iga momelaꞌkájkeja? ");
INSERT INTO nhx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús kijtoj: —Moisés kijtoj iga wel xika̱waka̱n amosiwa̱ꞌ iga anyo̱ltakuaktikej, eꞌ desde kua̱ꞌ mochij ta̱jli, Dios ayí̱ꞌ kineꞌ ijkó̱n. ");
INSERT INTO nhx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nej nikijtowa iga yej kiyokaka̱wa isiwa̱ꞌ, ayejpa iga isiwa̱ꞌ nemi yawi wa̱n seꞌ, inó̱n ta̱gaꞌ yej takajte̱wa, siga mona̱miktiá iwá̱n seꞌ siwa̱ꞌ, ino̱nwaꞌ nemi taxi̱ma iwá̱n yej mona̱miktij. Iwá̱n ta̱gaꞌ yej mamona̱mikti iwá̱n se̱ siwa̱ꞌ yej mokajtej, no̱ taxi̱ma. Yej taxi̱ma kajasi iga mamocastiga̱ro. ");
INSERT INTO nhx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Idisci̱polojmej Jesús kijtojkej: —Siga ijko̱nwaꞌ kichi̱wa se̱ ta̱gaꞌ iwá̱n isiwa̱ꞌ, má̱j ye̱kti katka iga ámowaꞌ mamona̱miktilo. ");
INSERT INTO nhx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús kijtoj: —Iní̱n ayá̱ꞌ nochi wel kentende̱rowa, petz ino̱mej yejsan Dios kine̱xtiliá. ");
INSERT INTO nhx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Onoꞌ se̱seꞌpa iga ta̱gaꞌ amona̱miktiá: sekin itekímeja iga amona̱miktiáj, eꞌ onokej sekin tajta̱gaꞌ yej kiyokakapa̱rowaj iga amo masiwa̱yowika̱n. Eꞌ onokej sekin yej ayá̱ꞌ mona̱miktiáj iga má̱j wel makipowaka̱n itájto̱l Dios. Yej kineki ijkó̱n kichi̱wa, makichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kiwi̱guilijkej sekin ko̱kone̱ꞌ Jesús iga makita̱lili ima̱mej iwá̱n makitajtanili Dios iga maye̱ꞌonoka̱n; eꞌ disci̱polojmej, pe̱ꞌya kajajwakej yej nemi kajaxitiáj ko̱kone̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Eꞌ Jesús, kijtoj: —Xika̱waka̱n in ko̱kone̱ꞌ, ka̱ma mane̱techo̱ka̱n, amo xikojtzakuili̱ka̱n; iga yej mochi̱wa ken ini̱mej ko̱kone̱ꞌ, kajasi iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Iwá̱n Jesús kita̱lilij ima̱mej ko̱kone̱ꞌ, iwá̱n ki̱saꞌ ompa. ");
INSERT INTO nhx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Se̱ ta̱gaꞌ yajki kitato Jesús, iwá̱n kitajtan: —Tamachtia̱ni yej tiye̱ꞌnemi, ¿té̱ nikchi̱was yej ye̱kti iga wel nochipa manono iwá̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús kijtoj: —¿Te iga tine̱tajtaniliá katiá yej ye̱kti iga mamochi̱wa? Sé̱sanwaꞌ in yej kichi̱wa yej ye̱kti, ino̱nwaꞌ Dios. Eꞌ siga tonosneki nochipa wa̱n Dios, xikchi̱wa ken tatekimaka Dios. ");
INSERT INTO nhx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iwá̱n chokotzi̱n kijtoj: —¿Katiapa yej Dios te̱tekimaka? Jesús kijlij: —Amo xitamikti; yej na̱miktitoꞌ amo mayawi wa̱n seꞌ, amo xitachteki wa̱n amo xikijto yej ayéj ijkó̱n; ");
INSERT INTO nhx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","xikye̱ꞌita motaj iwá̱n moye̱ꞌ; iwá̱n xikcho̱kili mokni̱n kensan tej timocho̱kiliá. ");
INSERT INTO nhx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chokotzi̱n kijtoj: —Inochi inó̱n nikchíjtoꞌya este kua̱ꞌ aya niyo̱lej; ¿te̱‑oꞌ má̱j ne̱polowa? ");
INSERT INTO nhx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús kijtoj: —Siga tikneki xiye̱ꞌono iyi̱xtaj Dios, xiknamaka nochi yej tikpiá, iwá̱n xikmajmaka yej ayá̱ꞌ motapialiáj. Ijkó̱n tia tikpiati yej pox vale̱rowa ipan cielo; wa̱n xiwi̱ki iwá̱n xine̱toka. ");
INSERT INTO nhx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Eꞌ kua̱ꞌ chokotzi̱n kikaguiꞌ yej kijlij Jesús, mokno̱matitiájkiya iga poxsan motapialia̱ya. ");
INSERT INTO nhx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iwá̱n Jesús kijlij idisci̱polojmej: —Nej nimitzijliáj iga se̱ yej moconfia̱rowa ipan itomi̱n awel mote̱maka iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nimitzojpa‑ijliáj iga má̱j wel panowa se̱ camello ipan ixapoyo a̱ko̱xaj, que se̱ yej motapialiá mamomaka iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kua̱ꞌ inó̱n kikakikej idisci̱polojmej este madmira̱dojkej, iwá̱n motajtankej: —¿A̱ꞌtaj wel moma̱nawi̱j? ");
INSERT INTO nhx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús kitachi̱lij idisci̱polojmej, iwá̱n kijtoj: —Tajta̱gaꞌ iní̱n awel kichi̱waj, eꞌ Dios kena, wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Iwá̱n Pedro kijtoj: —NoTe̱ko, nejeme̱n nikajtéjkeja nochi yej nikpiayaj, iwá̱n nimitztokakej. ¿Té̱ nimota̱nili̱skej? ");
INSERT INTO nhx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús kijtoj: —Nimitznojma‑ijliáj iga inó̱n ve̱j kua̱ꞌ Dios kichi̱was iga ta̱jli maye̱ꞌono, kua̱ꞌ nej yej iPiltzi̱n Ta̱gaꞌ nimota̱li̱j ka̱n nirreina̱rowa, amejeme̱n yej anne̱tokakej, anyawij no̱ anmota̱li̱tij ipan doce wejweyi asiento ka̱n anmanda̱ro̱skej iga sejsé̱ de amejeme̱n ankijuzga̱ro̱skej sejsé̱ de inó̱n doce tribu yej wa̱lkej ipan ipilowa̱n Israel. ");
INSERT INTO nhx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Nochi yej iga san ne̱tokaj kikajtejkej ikalmej, iyokichikni̱mej, isiwa‑ikni̱mej, itajmej, iye̱mej, ipilowa̱n, o ita̱lmej, Dios yawi kimakati cien veces má̱j de lo que kikajtejkej, iwá̱n yawij onotij nochipa iwá̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Eꞌ miaꞌ yej iná̱n tayaka̱ntokej, yawij ka̱witij tatepotztaj, iwá̱n yej iná̱n onokej tatepotztaj, yawij tayaka̱ntotij. ");
INSERT INTO nhx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesús kijtoj: —Ka̱n reina̱rowa Dios, ken tikita se̱ ta̱gaꞌ yej kipiá weyi u̱vajyoj, iní̱n ta̱gaꞌ ki̱saꞌ isájpasan iga kite̱mo̱to imo̱nsojmej iga maya̱ka̱n makitekitij uva. ");
INSERT INTO nhx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Kua̱ꞌ kásiꞌya mo̱nsojmej, motajto̱ltijkej ke̱ꞌ yawij kita̱ni̱tij inó̱n día, iwá̱n kití̱tanya imi̱lpan iga matekipano̱tij. ");
INSERT INTO nhx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Iwá̱n ite̱ko mi̱jli ki̱saꞌ sej ken las nueve de la mañana, iwá̱n kitaꞌ sekin yej onokej tajkoa̱ltepe̱ꞌ, até̱ kichijtokej. ");
INSERT INTO nhx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Iwá̱n kijlijkej: “Xa̱ka̱n no̱ xiktekitij uva nomi̱lpan, iwá̱n nimitzixta̱waskej ke̱ꞌ nokta mota̱niá.” Iwá̱n yejeme̱n yajkij tekipano̱toj. ");
INSERT INTO nhx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","’Ite̱ko mi̱jli ki̱saꞌ sej ken tajkodía, iwá̱n ki̱saꞌ sej ken las tres tio̱takpan, ijko̱nsan sej kichij ken achto. ");
INSERT INTO nhx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Iwá̱n ken las cinco tio̱takpan sej yajki tajkoa̱ltepe̱ꞌ, iwá̱n kasiꞌ sekin yej ayá̱ꞌ te̱ kichijtokej, kijlijkej: “¿Te iga nij amonokej semilwiꞌ wa̱n até̱ ankichijtokej?” ");
INSERT INTO nhx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kijtojkej: “Iga ayagaj ne̱te̱mowaj iga manitekipano̱ka̱n.” Iwá̱n kijtoj ite̱ko mi̱jli: “Xa̱ka̱n no̱ xitekipano̱tij nomi̱lpan, iwá̱n nimitzixta̱waskej ke̱ꞌ nokta mota̱niá.” ");
INSERT INTO nhx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kua̱ꞌ tayówaya, ite̱ko mi̱jli kijlij yej kinentiá tekipanowa̱nimej: “Xikno̱tzáka̱nya in yej tekipanojkej, iwá̱n xikixta̱wáka̱nya. Xikixta̱waka̱n achto yej último pejkej iga tekipanowaj, iwá̱n xitamiti ipan yej achto pejkej.” ");
INSERT INTO nhx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iwá̱n asikej yej kalakkej iga tekipanowaj las cinco tio̱takpan, iwá̱n sejsé̱ kimakakej ke̱ꞌ nokta mota̱niá se̱ día. ");
INSERT INTO nhx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kua̱ꞌ asikej yej achto kalakkej iga tekipanowaj, kijtojkej anka má̱j komati kita̱ni̱skej; eꞌ sejsé̱ kimakakej ke̱ꞌ nokta mota̱niá se̱ día. ");
INSERT INTO nhx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eꞌ kua̱ꞌ a̱n kixtájkeja, tekipanowa̱nimej pe̱waꞌ mokuesojkej wa̱n yej ite̱ko mi̱jli, ");
INSERT INTO nhx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","kijtojkej: “Ini̱mej yej tió̱taꞌya kalakkej, tekipanojkej se̱san hora, wa̱n tikixtaj acho̱nsan no̱ ke̱ꞌ nejemej anne‑ixtajkej yej nikijyo̱wijkej tekipáno̱l wa̱n nito̱natatakej semilwiꞌ.” ");
INSERT INTO nhx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ite̱ko mi̱jli kijlij se̱ de yejemej: “Ej, ayá̱ꞌ nemi nimitzchi̱wiliá yej aye̱kti. ¿Ix aya̱ꞌtaj tikajkej iga tia tikta̱ni̱ti ke̱ꞌ mota̱niá se̱ día? ");
INSERT INTO nhx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xikui motomi̱n, iwá̱n xaja. Nej nikneki manikixta̱wa iní̱n yej ú̱ltimoja kalaꞌ, ke̱ꞌsan tej nimitzixtaj. ");
INSERT INTO nhx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ix aya̱ꞌtaj nej nikmati te̱ nikchi̱wa wa̱n notomi̱n? ¿O tine‑i̱xita iga nite‑ijikni̱n?” ");
INSERT INTO nhx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Inó̱n iga yej iná̱n onokej tatepotztaj yawij tayaka̱ntotij, iwá̱n yej iná̱n tayaka̱ntokej yawij ka̱witij tatepotztaj; iga miaꞌ yej kino̱tzaskej, eꞌ ayá̱ꞌ inochi̱n yawij kitapejpenatij. ");
INSERT INTO nhx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kua̱ꞌ Jesús némiya yawi Jerusalén, kiwi̱gaꞌ doce idisci̱polojmej ka̱n iyokamej iwá̱n kijlijkej: ");
INSERT INTO nhx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Iná̱n ankitaj iga nemi tiawij Jerusalén, ompiga ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés yawij ne̱ki̱tzki̱tij nej yej iPiltzi̱n Ta̱gaꞌ, iwá̱n yawij kijto̱tij iga mane̱mikti̱ka̱n ");
INSERT INTO nhx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","iwá̱n ne̱ti̱taniskej iyi̱xtaj yej ayéj judiyojmej iga mane̱pi̱najti̱ka̱n, mane̱magaka̱n iwá̱n mane̱mikti̱ka̱n ipan cruz, eꞌ ipan e̱yi día ni‑ojpa‑isas sej. ");
INSERT INTO nhx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Isiwa̱ꞌ Zebedeo iwá̱n ipilowa̱n, yej ito̱ka̱ꞌ Jacobo iwá̱n Juan, kitecho̱toj Jesús. Te̱ye̱ꞌ iyi̱xtaj Jesús motankua̱ketzaꞌ iga kitajtanilij tejté̱. ");
INSERT INTO nhx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iwá̱n Jesús kitajtan: —¿Te̱ tikneki? Te̱ye̱ꞌ kijtoj: —Xikijto iga ka̱n tirreina̱ro̱j se̱ de ini̱mej nopilowa̱n mamota̱li moye̱ꞌka̱mpa iwá̱n seꞌ mamota̱li moo̱pochka̱mpa. ");
INSERT INTO nhx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Eꞌ Jesús kijtoj: —Amejeme̱n ayá̱ꞌ ankimatij te̱ ankitajtanij. ¿Ix ankijyo̱wi̱skej ken nej nikijyo̱wi̱j kua̱ꞌ ne̱castiga̱ro̱skej? ¿Ix wel ampano̱skej ka̱n nej nipano̱j? Yejemej kijtojkej: —Kena, wel. ");
INSERT INTO nhx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús kijtoj: —Kena, ankijyo̱wi̱skej ken nej nia nikijyo̱wi̱ti kua̱ꞌ ne‑ikno̱chi̱waskej, iwá̱n ampano̱skej ka̱n nej nipano̱j, eꞌ iga agaj mamota̱li noye̱ꞌka̱mpa o noo̱pochka̱mpa, inó̱n ayéj nej nikmati, yawij kimakatij yejsan noTaj kitapejpen iga yawij mota̱li̱tij. ");
INSERT INTO nhx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kua̱ꞌ ino̱mej seꞌ diez disci̱polojmej inó̱n kikakikej, kikuesowilijkej Jacobo iwá̱n Juan. ");
INSERT INTO nhx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Iwá̱n Jesús kino̱tzaꞌ idisci̱polojmej iwá̱n kijtoj: —Amejeme̱n ankimátija iga yej manda̱rowaj ipan pai̱smej poxsan kitajtaksa ige̱ntej, iwá̱n yej goberna̱rowaj yo̱lki̱saj pan yej até̱ iteki, ka̱nsan mane̱si iga manda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Eꞌ iwá̱n amejeme̱n ayéj ijkó̱n. Ma̱jwaꞌ yej kineki matayaka̱nto ipan amejeme̱n, inó̱n achto makipale̱wi tokni̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Siga agaj de amejeme̱n kineki matayaka̱nto, mamochi̱wa esclavo iga nochi tokni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ijkó̱n nej yej iPiltzi̱n Ta̱gaꞌ ayá̱ꞌ niwa̱laj iga mane̱pale̱wi̱ka̱n, sino que iga manitapale̱wi, iwá̱n iga manimiki iga miaꞌ manikxitoma yej ken ilpitokej iga aye̱kti kichijtokej. ");
INSERT INTO nhx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kua̱ꞌ yejemej nemi ki̱sayaj weyi‑a̱ltepe̱ꞌ Jericó, Jesús poxsan kitokatia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ompa onoyaj o̱me̱n pachamej eje̱watoyaj ojte̱noj; kua̱ꞌ kikakikej iga ómpaya nemi panowa Jesús, tzajtzikej: —¡NoTe̱ko, tej iPiltzi̱n David, áchikej xine‑ikne̱li̱ka̱n! ");
INSERT INTO nhx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Yej ompa chapa̱ntia̱yaj kajajwakej pachamej iga ayoꞌ má̱j matzajtzitoka̱n, eꞌ pachamej ma̱jya tzajtzikej: —¡NoTe̱ko, tej yej iPiltzi̱n David, áchikej xine‑ikne̱li̱ka̱n! ");
INSERT INTO nhx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iwá̱n Jesús moketzaꞌ, kino̱tzaꞌ pachamej iwá̱n tatajtan: —¿Te̱ ankinekij manimitzchi̱wili̱ka̱n? ");
INSERT INTO nhx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Pachamej kijtojkej: —NoTe̱ko, niknekij manitachaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iwá̱n Jesús kikne̱lij ino̱mej pachamej, iwá̱n kiji̱xchijchin, iwá̱n íkua̱ꞌsan in pachamej welja tachakej, iwá̱n kitokákeja Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Kua̱ꞌ asitiáwija Jerusalén, iwá̱n asikej a̱ltepe̱ꞌ Betfagé, ite̱noj tepe̱ꞌ yej ito̱ka̱ꞌ Olivos, Jesús kiti̱tan o̱me idisci̱polojmej, ");
INSERT INTO nhx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","iwá̱n kijlijkej: —Xa̱ka̱n ipan ine̱pa a̱ltepe̱tzi̱n yej onoꞌ to‑i̱xtaj. Ompa anyawij ankasitij se̱ burra ilpitoꞌ, no̱ ompa onoꞌ se̱ bu̱rrojtzi̱n. Xikxitomaka̱n, iwá̱n xine̱wajliguili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Siga agaj tejté̱ mitzijliáj, xikijli̱ka̱n: “ToTe̱ko kineki, iwá̱n nimaní̱n sej mitzka̱wili̱kij.” ");
INSERT INTO nhx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Inó̱n mochij iga mamochi̱wa ken kijtoj se̱ profeta, kua̱ꞌ ijkí̱n kijkuiloj: ");
INSERT INTO nhx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xikijli̱ka̱n yej cha̱ntitokej Jerusalén: “Xikitaka̱n, amorre̱y wi̱ꞌ iga amejemej, ayá̱ꞌ moweyimati, tejkatiwi̱ꞌ ipan se̱ burro, yej aya i̱ꞌ moxi̱lajtiá.” ");
INSERT INTO nhx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iwá̱n disci̱polojmej yajkij, iwá̱n kichijkej kensan Jesús kitekimakakej. ");
INSERT INTO nhx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Kiwajligakej burra iwá̱n ipiltzi̱n; iwá̱n disci̱polojmej kipechtijkej bu̱rrojtzi̱n iga itzotzolmej, iwá̱n Jesús tejkaj. ");
INSERT INTO nhx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pox onoya miaꞌ gente; yejemej kipata̱wilijtiajkij itzotzolmej ipan ojti. Sekin sej kitekikej imajma̱ꞌ so̱ya̱ꞌ iga kita̱lijtiajkij ipan ojti. ");
INSERT INTO nhx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Yej tapano̱tia̱yaj iwá̱n yej ya̱yaj tatzi̱mpan tzajtzitia̱yaj, ijkí̱n tzajtzikej: —¡Mamoweyimati̱lti iPiltzi̱n rey David! ¡Mamoweyimati̱lti yej kiti̱tani toTe̱ko Dios! ¡Mamoweyimati̱lti Dios yej onoꞌ ipan cielo! ");
INSERT INTO nhx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kua̱ꞌ Jesús ásiꞌya Jerusalén, nochi gente akojasiáj te̱ nemi mochi̱wa, iwá̱n miaꞌ tatajtaniáj: —¿A̱ꞌyéj a̱n in iní̱n? ");
INSERT INTO nhx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","La gente kijtowa̱ya: —Ini̱nwaꞌ profeta Jesús, yej moskaltij Nazaret ipan ta̱jli de Galilea. ");
INSERT INTO nhx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kua̱ꞌ Jesús kalaꞌ ipan ipa̱tiojyo weyitio̱pan, kikijki̱xtij ino̱mej yej tanamakatoyaj iwá̱n yej takojtoyaj. Kitzijtzi̱nkuepaꞌ me̱sajmej ka̱n kipatatoyaj na̱mo̱ltomi̱n iga tio̱pantomi̱n. Iwá̱n no̱ kiyajyagatope̱wilijkej ka̱n mota̱lia̱yaj yej kinamakatoyaj jojtoko. ");
INSERT INTO nhx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Iwá̱n Jesús kijtoj: —Ijkí̱n ijkuilijtoꞌ itájto̱l toTe̱ko: “Nókal yawi moto̱ka̱wi̱ti kajli ka̱n ora̱do̱lo”; eꞌ amejeme̱n ankikueptokej ka̱n mi̱ya̱naj yej tachtekij. ");
INSERT INTO nhx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ompa weyitio̱pan kitecho̱toj Jesús sekin pachamej iwá̱n ko̱xomej, iwá̱n kachitialtij. ");
INSERT INTO nhx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Eꞌ kuejkuesiwikej ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan la ley kua̱ꞌ kitakej iga Jesús taachitialtij, iwá̱n iga kikakikej ko̱kone̱ꞌ tzajtzitokej iga kijtojtoyaj: “¡Mamoweyimati̱lti iPiltzi̱n Rey David!” ");
INSERT INTO nhx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iwá̱n kijlijkej Jesús: —¿Ix tikaki yej ini̱mej kijtojtojkej? Jesús kijtoj: —Kena, nikaki. Eꞌ amejeme̱n, ¿ix ayí̱ꞌ ankilee̱rowaj itájto̱l Dios ka̱n kijtowa?: Tikchij iga ko̱kone̱ꞌ iwá̱n xo̱lo̱mej yej chí̱chijoꞌ, mamitztakui̱kili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iwá̱n Jesús ki̱saꞌ Jerusalén, iwá̱n yajki a̱ltepe̱ꞌ Betania iwá̱n ompiga kochiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Iwá̱n yowaltiꞌ kua̱ꞌ nemi sej yawi Jerusalén, Jesús maya̱naꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kitaꞌ se̱ higue̱rajkuawiꞌ yej ojte̱noj onoya, iwá̱n kitechoj iga makita siga ta̱ktoꞌ, eꞌ ayá̱ꞌ ta̱ktoya, kipiaya petz iyiswáyosan. Iwá̱n ijkí̱n kijlij inó̱n kuawiꞌ: —¡Nike̱man nokta amo xita̱ki! Iwá̱n imani̱nsan wa̱guiꞌ in inó̱n kuawiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kua̱ꞌ inó̱n kitakej idisci̱polojmej moyo̱lmajtijkej, iwá̱n kitajtankej Jesús: —¿Ix ken iga imani̱nsan wa̱guiꞌ in higue̱rajkuawiꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Iwá̱n Jesús kijtoj: —Nej nimitzijliáj siga amejeme̱n anmomelaꞌconfia̱rowaj pan Dios ayejsan ijkí̱n wel ankichi̱waskej ken nikchi̱wilij iní̱n higue̱rajkuawiꞌ, amejeme̱n no̱ wel ankijli̱skej iní̱n tepe̱ꞌ: “Xicholo ompa ka̱n tonoꞌ, iwá̱n xaj láma̱rko”, iwá̱n ijkó̱n mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nochi yej ankitajtanili̱skej Dios kua̱ꞌ nemi an‑ora̱dowaj, siga ankimelaꞌcre̱do̱skej, mitzmakaskej. ");
INSERT INTO nhx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iwá̱n Jesús kalaꞌ weyitio̱pan, iwá̱n mie̱j tamachtijtoya ompa, kitechojkej ije̱fejmej sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej, iwá̱n kitajtankej: —¿Té̱ moteki in tej iga tikchi̱wa ijkí̱n? ¿A̱ꞌ mitztekimáꞌ iga wel xikchi̱wa iní̱n? ");
INSERT INTO nhx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús kijtoj: —Nej no̱ manimitztajtanika̱n, siga anne‑ijli̱skej, nia nimitzijli̱tij a̱ꞌyéj ne̱tekimaka iga nikchi̱wa ijkí̱n. ");
INSERT INTO nhx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿A̱ꞌyéj kiti̱tan Juan iga matabautiza̱ro̱ki? ¿Ix Dios kiti̱tan o tajta̱gaꞌ? Eꞌ pe̱ꞌya mosepanta̱tapo̱wijkej, mojlijkej: —Siga tikijtowaj iga Dios kiti̱tan, yawi te‑ijli̱ti: “¿Te ígataj ayá̱ꞌ ankitajto̱lkakikej?” ");
INSERT INTO nhx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Siga tikijtowaj tajta̱gaꞌ kiti̱tan, tikmajmawiliáj la gente, nochi kimati iga Juan Dios kitajto̱lmakaya. ");
INSERT INTO nhx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Iwá̱n ijkí̱n kijlijkej Jesús: —Ayá̱ꞌ nikmatij. Iwá̱n Jesús kijtoj: —Nej no̱ ayá̱ꞌ nimitzijliáj a̱ꞌyéj ne̱tekimaka iga manikchi̱wa ijkí̱n. ");
INSERT INTO nhx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús tatajtan: —¿Amejeme̱n ken ankitaj iní̱n? Se̱ ta̱gaꞌ kipiaya o̱me ipilowa̱n; iwá̱n kijlij se̱ de yejemej: “Nopíj, xaj xitekipano̱ti ipan u̱vajyoj.” ");
INSERT INTO nhx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Te̱piltzi̱n kijtoj: “¡Ayá̱ꞌ nikneki!” Eꞌ má̱j má̱j moyo̱lpataꞌ, yájkisan tekipano̱to. ");
INSERT INTO nhx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Iwá̱n te̱taj kitato seꞌ ipiltzi̱n, ijko̱nsan no̱ kijlij; wa̱n inó̱n te̱piltzi̱n kijtoj: “Kena notaj, nia̱ti.” Eꞌ ayá̱ꞌ yajki. ");
INSERT INTO nhx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Katiapa de ini̱mej kichij ken kitekimáꞌ itaj? Yejeme̱n kijtojkej: —Yej achto kitekimáꞌ. Iwá̱n Jesús kijtoj: —Nimitzijliáj iga ino̱mej yej kicobra̱rowaj impuesto iga Roma iwá̱n siwa̱tkej yej najna̱mo̱lnemij, achto kalakiskej ka̱n reina̱rowa Dios que amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wá̱lkaya Juan yej tabautiza̱rowa kine̱xtili̱ko la gente ken iga maye̱ꞌnemika̱n, iwá̱n amejeme̱n ayá̱ꞌ ankitajto̱lkakikej; eꞌ yej kicobra̱rowaj impuestos iwá̱n siwa̱tkej yej najna̱mo̱lnemij, kena kicre̱dojkej. Eꞌ amejeme̱n malej ankitakej iní̱n, eꞌ ayá̱ꞌ anmoyo̱lpatakej. ");
INSERT INTO nhx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xikakika̱n iní̱n seꞌ yej nia nikijto̱ti: Ite̱ko mi̱jli kito̱gaꞌ uva iwá̱n kikola̱ltij; iwá̱n kichij se̱ pozo ka̱n mopa̱tzka uva, iwá̱n kichij se̱ torre iga wel matachalo no̱ya̱n ka̱n onoꞌ u̱vajyoj. ’Iwá̱n ite̱ko u̱vajyoj kita̱ke̱waltij sekin tekipanowa̱nimej iwá̱n yajki wejka. ");
INSERT INTO nhx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kua̱ꞌ asiꞌ itie̱mpoj iga motékiya uva, kiti̱tan sekin imo̱nsojmej iga makitajtanili̱tij yej kita̱ke̱waltijkej u̱vajyoj ke̱ꞌ ki̱xta̱waskej ite̱ko. ");
INSERT INTO nhx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Eꞌ yej kita̱ke̱waltijkej u̱vajyoj, kiki̱tzkijkej iwá̱n kimagakej itati̱tan ite̱ko u̱vajyoj, seꞌ itati̱tan kimiktijkej iwá̱n seꞌ kitewijkej. ");
INSERT INTO nhx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ite̱ko u̱vajyoj, kiti̱tan ma̱jya miaꞌ imo̱nsojmej; eꞌ yej kita̱kejtokej u̱vajyoj, ijko̱nsan kichi̱wilijkej ken yej achto tati̱tanimej. ");
INSERT INTO nhx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Inó̱n kitaꞌ ite̱ko mi̱jli, kiti̱tan ipiltzi̱n, kijtoj: “Yawij kirrespeta̱ro̱tij nopiltzi̱n.” ");
INSERT INTO nhx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Eꞌ kua̱ꞌ kitakej te̱piltzi̱n, tekipanowa̱nimej mojlijkej: “Iní̱nyawaꞌ in yej yawi mochi̱wati ite̱ko iní̱n ta̱jli yej ítajpa kikajte̱was, matikmiktí̱ka̱nya nokta iga maka̱wi íta̱l iga tejemej.” ");
INSERT INTO nhx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kiki̱tzkijkej iwá̱n kiki̱xtijkej ipan u̱vajyoj, iwá̱n kimiktijkej. ");
INSERT INTO nhx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iwá̱n Jesús tatajtan: —Kua̱ꞌ mawi̱ki ite̱ko u̱vajyoj, ¿te a̱n kichi̱wili̱j yej kita̱kejtoyaj u̱vajyoj? ");
INSERT INTO nhx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yejeme̱n kijtojkej: —Ino̱mej yej kita̱kejtoyaj u̱vajyoj yawij kimikti̱tij niga kikne̱li̱skej. Iwá̱n seꞌ tekipanowa̱nimej kita̱ke̱walti̱j, iwá̱n ino̱mej kua̱ꞌ asis itie̱mpoj iga moteki uva, kimakaskej yej kitoca̱rowa ite̱ko u̱vajyoj. ");
INSERT INTO nhx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iwá̱n Jesús kijtoj: —In amejeme̱n, ¿ix ayí̱ꞌ ankilee̱rowaj ka̱n ijkí̱n ijkuilijtoꞌ? Quijtowa: Teꞌti yej kitajkalkej yej kalchi̱waj, inó̱n teꞌti iná̱n yej achto mota̱lij. Iní̱n kichij toTe̱ko iwá̱n pox mo̱nsaj tikitaj. ");
INSERT INTO nhx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Amejeme̱n ankijtowaj iga amonoskej ka̱n Dios reina̱rowa, eꞌ nimitzijliáj iga ayá̱ꞌ ankalakiskej, seꞌwaꞌ in yej yawi kalakiti, yej kichi̱wa ken Dios kineki. ");
INSERT INTO nhx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yej mawetzi ipan iní̱n teꞌti yej kitajkalkej yej kalchi̱waj, yawi mopojpostekiti; iwá̱n siga teꞌti agaj mawetzi iyakapan, yawi mochi̱wati píno̱lsan. ");
INSERT INTO nhx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kua̱ꞌ ije̱fejmej sacerdo̱tejmej iwá̱n fariseojmej kikakikej yej Jesús kijtojtoya, imaní̱n kimatikej iga ino̱nwaꞌ iga yejeme̱n nemi tajtowa. ");
INSERT INTO nhx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Íkua̱ꞌsan kinekiáj makiki̱tzki̱ka̱n Jesús iga makipre̱sojwi̱ka̱n, eꞌ kimajmawilia̱yaj la gente iga kijtowa̱yaj iga Dios kitajto̱lmakaya Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús pe̱waꞌ sej tata̱tapo̱wij ka̱n wel mami̱xkui̱tilo, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ka̱n reina̱rowa Dios, ken tikita se̱ rey yej kilwichi̱wiliá ipiltzi̱n iga mona̱miktiá. ");
INSERT INTO nhx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kiti̱tan imo̱nsojmej mata‑ijitatij, eꞌ te‑ikni̱wa̱n akinekikej. ");
INSERT INTO nhx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Sej kiti̱tan sekin imo̱nsojmej, kijlijkej: “Xikijli̱ka̱n te‑ikni̱wa̱n iga tákual ónoꞌya. Nikmíktija noto̱rojmej iwá̱n seꞌpa noyo̱lka̱mej yej tojtomaktiꞌ, ónoꞌya nochi yej monekis; mawi̱tzéka̱nya nigaj ka̱n mona̱miktilo.” ");
INSERT INTO nhx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Eꞌ te‑ikni̱wa̱n ayá̱ꞌ nokta kinekikej. Se̱ de yejemej yajki imi̱lpan, seꞌ yajki tanamakato, ");
INSERT INTO nhx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","iwá̱n sekin te‑ikni̱wa̱n kiki̱tzkijkej imo̱nsojmej el rey iwá̱n kimagakej poxsan; este kimiktijkej. ");
INSERT INTO nhx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iwá̱n el rey poxsan kuesiwiꞌ, iwá̱n kiti̱tan isolda̱dojmej iga makimijmikti̱tij ino̱mej yej tamiktijkej iwá̱n iga makitati̱ka̱n iya̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Iwá̱n inó̱n rey kijlij imo̱nsojmej: “Nochi ónoꞌya yej monekis iga mona̱miktilo, ino̱mej te‑ikni̱wa̱n ayá̱ꞌ kajasiáj iga mawi̱tzeka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xa̱ka̱n ipan ca̱llejmej yej onokej tajkoa̱ltepe̱ꞌ iwá̱n xikijli̱ka̱n a̱ꞌsan ne̱siꞌ, matakua̱kij iga a̱man mona̱miktiá nopiltzi̱n.” ");
INSERT INTO nhx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Mo̱nsojmej yajkij ipan ca̱llejmej iwá̱n kijlijkej yej ye̱ꞌnemij wa̱n yej ayá̱ꞌ ye̱ꞌnemij iga matakua̱tij ka̱n mona̱miktilo, ijkó̱n te̱miꞌ me̱sajmej ka̱n mota̱lia̱yaj te‑ikni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Kua̱ꞌ el rey kitato yej ki̱xna̱ntókeja mesa, kitaꞌ se̱ ta̱gaꞌ yej ayá̱ꞌ kakijtoꞌ itzótzol yej moakiá kua̱ꞌ mona̱miktilo. ");
INSERT INTO nhx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Iwá̱n el rey kijlij: “Ej, ¿kén nokta tikalaꞌ nigaj aya̱ꞌpa tikakijtoꞌ motzótzol yej moakiá kua̱ꞌ mona̱miktilo?” Eꞌ ta̱gaꞌ ayá̱ꞌ tajtoj. ");
INSERT INTO nhx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Inó̱n rey, kitekimáꞌ yej ompa tapale̱wia̱yaj: “Xikijikxi‑ilpi̱ka̱n iwá̱n xikmajma‑ilpi̱ka̱n, iwá̱n xiki̱xti̱ka̱n iwá̱n xikpata̱nalti̱ka̱n ka̱n takomichka̱n, ompa yawi cho̱kati este tajtangueguetzekas.” ");
INSERT INTO nhx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Dios miaꞌ kino̱tza, eꞌ ayá̱ꞌ nochi kitapejpena. ");
INSERT INTO nhx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Iwá̱n fariseojmej yajkij iwá̱n motajto̱ltijkej iga makite̱nte̱mo̱ka̱n ken iga makima̱wetzi̱lti̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Iwá̱n kiti̱tankej sekin yej de yejéme̱mpa iwá̱n sekin yej kitokaj rey Herodes iga ijkí̱n makijli̱tij Jesús: —Tamachtia̱ni, nejeme̱n nikmatij iga yej tikijtowa ijko̱nya nokta, iwá̱n titane̱xtiliá iga makichi̱waka̱n ken Dios kineki, iwá̱n ayá̱ꞌ tikchi̱wiliá caso yej kijtowa la gente iga tej ayá̱ꞌ titajtowa iga san mamitzye̱ꞌitaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Taꞌ xine‑ijli̱ka̱n: ¿Ix ye̱kti iga manikixta̱waka̱n impuesto iga rey César o ayá̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Eꞌ Jesús kimatiꞌ iga kitajtankej iga san kite̱nte̱mowaj, iwá̱n Jesús kijtoj: —Amejeme̱n yej antakajkaya̱waj iga ankitokaj Dios, ¿te iga anne̱te̱nte̱mowaj? ");
INSERT INTO nhx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xine̱ne̱xtili̱ka̱n se̱ tomi̱n yej iga mo‑ixta̱wa impuesto. Iwá̱n kiwi̱guilijkej in tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kua̱ꞌ Jesús kitaꞌ tomi̱n, tatajtan: —¿A̱ꞌyéj ixa̱yaꞌ iwá̱n ito̱ka̱ꞌ yej nigaj ijkuilijtoꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yejeme̱n kijtojkej: —Rey César. Jesús kijtoj: —Puej xikmakaka̱n rey César yej yejpa itatki, iwá̱n xikmakaka̱n Dios yej yéjpa itatki. ");
INSERT INTO nhx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kua̱ꞌ inó̱n kikakikej, san tajtachi̱xtikajkej; iwá̱n yájkija, ómpaya kikajtejkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Íkua̱ꞌsan sekin saduceojmej yajkij kitatoj Jesús. Saduceojmej kijtowaj iga yej mikij ayoꞌ ojpa‑isaj; inó̱n iga ijkí̱n kitajtankej Jesús: ");
INSERT INTO nhx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Tamachtia̱ni, Moisés kijtoj siga se̱ ta̱gaꞌ yej siwa̱yoj miki iwá̱n ayá̱ꞌ kikajte̱was nisé̱ ipiltzi̱n, iyikni̱n ta̱gaꞌ yej miꞌ mamona̱mikti iwá̱n isiwa̱ꞌ yej miꞌ iga ken kua̱ꞌ makipiaka̱n ipilowa̱n yej miꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nij ijkó̱n mochij wa̱n nejeme̱n: onoyaj siete tajta̱gaꞌ yej se̱san itajmej iwá̱n se̱san iye̱mej. Yej te̱ko̱ko achto mona̱miktij, iwá̱n miguiꞌ. Eꞌ iga ayá̱ꞌ kikajtej nisé̱ ipiltzi̱n, siwa̱ꞌ mona̱miktij iwá̱n iwéjpo̱l. ");
INSERT INTO nhx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ijko̱nsan no̱ mochij iwá̱n seꞌ, iwá̱n ijkó̱n nochi mochij, este que masiꞌ siete iwé̱j. ");
INSERT INTO nhx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iwá̱n miguiꞌ no̱ siwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","In kua̱ꞌ ojpa‑isaskej yej miktokej, ¿katiapa a̱n de inó̱n siete mochi̱was iwé̱j in inó̱n siwa̱ꞌ? iga na̱miktitoya iwá̱n inochimej. ");
INSERT INTO nhx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús kijtoj: —Amejeme̱n ayompa antajla̱mikij, ayá̱ꞌ ankimatij ken tamachtiá itájto̱l Dios, niga ayá̱ꞌ anki̱xmatij ken Dios wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kua̱ꞌ yej miktokej ojpa‑isaskej, ayꞌya mona̱mikti̱skej, niga ipilowa̱n ayoꞌ kina̱mikti̱skej, iga mochi̱waskej ken tikita iya̱ngelejmej Dios yej onokej ipan cielo, yej no̱ ayá̱ꞌ mona̱miktiáj. ");
INSERT INTO nhx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Eꞌ iga ojpa‑isaskej yej miktokej, ¿ayá̱ꞌ ankilee̱rojkej yej Dios mitzijlijkej? Ijkí̱n kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nej iDio̱s Abraham, Isaac iwá̱n Jacob.” Dios ayéj iDio̱s yej miktokej, sino que iDio̱s yej isatokej. ");
INSERT INTO nhx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kua̱ꞌ la gente inó̱n kikakikej, poxsan madmira̱dojkej iga ijkó̱n tamachtiá Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kua̱ꞌ fariseojmej kimatikej iga saduceojmej awel kite̱nkuepiliáj Jesús, monechkojkej iga kisen‑itatoj Jesús; ");
INSERT INTO nhx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","iwá̱n se̱ yej tamachtiá ipan iley Moisés kineꞌ makima̱wetzi̱lti Jesús; ijkí̱n kitajtan: ");
INSERT INTO nhx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Tamachtia̱ni, ¿katiapa mandamiento ipan iley Dios yej más achto mamochi̱wa? ");
INSERT INTO nhx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús kijlij: —“Xikcho̱kili moTe̱ko Dios iga inewi moa̱lmaj, iwá̱n iga inochi moespí̱ritoj iwá̱n yéj nochipa xikejla̱nto.” ");
INSERT INTO nhx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Iní̱nyawaꞌ in yej achto mandamiento yej má̱j mamochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Iwá̱n el segundo áchisan kensan iní̱n, kijtowa: “Xikcho̱kili mokni̱n kensan tej timocho̱kiliá.” ");
INSERT INTO nhx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ipan iní̱n o̱me mandamiento taksa inochi ley iwá̱n ken iga tamachtiáj profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Mie̱j fariseojmej nechkatóyajoꞌ iná̱ꞌ, ");
INSERT INTO nhx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús tatajtan: —¿Amejeme̱n, te̱ ankijtowaj iga Cristo? ¿A̱ꞌyéj ipiltzi̱n? Kijtojkej: —Ipiltzi̱n David. ");
INSERT INTO nhx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesús kijtoj: —¿Te̱ ígataj a̱n David iga kitajto̱lmáꞌ IyEspí̱ritoj Dios, kijlij Cristo “noTe̱ko”? David ijkí̱n kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ToTe̱ko kijlij noTe̱ko: “Ximota̱li ila̱doj noye̱ꞌma̱ꞌ ka̱n nimanda̱rowa, este que manikta̱li mokxitampa yej mitzijiyaj.” ");
INSERT INTO nhx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Kén wel Cristo yej itati̱tan Dios ma‑ipiltzi̱n David, esi David no̱ kijliá iga iTe̱ko? ");
INSERT INTO nhx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iwá̱n ayagaj wel kite̱nkuepilij, iwá̱n desde íkua̱ꞌ ayoꞌ má̱j agaj mi̱xe̱wij iga makitajtani Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jesús kijlij la gente iwá̱n idisci̱polojmej: ");
INSERT INTO nhx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Yej tamachtiáj ipan la ley iwá̱n fariseojmej momachi̱liáj iga yejéme̱nsan yej wel tane̱xtiliáj iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Inó̱n iga nimitzijliáj, xikchi̱waka̱n nochi yej mitzijliáj, eꞌ amo xikchi̱waka̱n yej yejeme̱n kichijtokej, iga yejeme̱n kijtowaj iga mamochi̱wa tejté̱, eꞌ yejemej ayá̱ꞌ kichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yejeme̱n tatekimakaj iga mamochi̱wa yej ayagaj wel kichi̱wa, iwá̱n tatekiꞌchi̱waltiáj, eꞌ yejémejsan akichi̱waj ni alí̱n. ");
INSERT INTO nhx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Inochi kichi̱waj ka̱nsan makitaka̱n. Kita̱liáj pan iyi̱xkua̱ꞌ iwá̱n ipan ima̱mej itájto̱l Dios yej ijkuilijtoꞌ ipan a̱matzi̱n yej onoꞌ ipan ca̱jajtzitzi̱n iga san mane̱si, iwá̱n kakiáj itzotzolmej yej kipiá we̱weyaꞌ ibi̱bilonka. ");
INSERT INTO nhx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ka̱n takualo, yejeme̱n mota̱li̱jnekij ipan ye̱ꞌasie̱ntoj ka̱n mota̱liáj yej má̱j tayaka̱ntokej, iwá̱n ijko̱nsan no̱ kinekij makichi̱waka̱n ipan tio̱pamej. ");
INSERT INTO nhx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yejeme̱n kinekij inochi gente makisaluda̱ro̱ka̱n tajkoa̱ltepe̱ꞌ, iwá̱n makijli̱ka̱n “tamachtia̱ni”. ");
INSERT INTO nhx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Eꞌ amejeme̱n amo ximote̱makaka̱n iga mamitzijli̱ka̱n “tamachtia̱ni”, iga amejeme̱n amonochi̱n anmojliáj “nokni̱n”, iwá̱n ankipiáj se̱san Tamachtia̱ni, petz nejsan yej niCristo. ");
INSERT INTO nhx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Iwá̱n ipan iní̱n ta̱jli amo agaj xikijli̱ka̱n notaj, iga ankipiáj se̱san amoTaj yej onoꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Iwá̱n amo no̱ ximote̱makaka̱n iga mamitzijli̱ka̱n iga antamachtia̱nimej iga nose̱lti yej niCri̱stoj yej nitamachtia̱ni yej nimitzmachtiáj kén iga xinemika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Yej kipale̱wiá sekin de amejeme̱n inó̱n yej má̱j tayaka̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yej igá̱najsan moweyimati yawij kali̱mpamatitij, eꞌ yej moali̱mpamati, inó̱n yawij kiweyimati̱lti̱tij. ");
INSERT INTO nhx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’¡Lástima amejeme̱n yej antamachtiáj ipan la ley iwá̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij!, ankitzakuiliáj sekin iga amo makalakika̱n ipan iyojwi Dios. Niga amejeme̱n ayá̱ꞌ ankalakij wa̱n ankitzakuiliáj iga amo makalakika̱n yej kalakisnekij ipan iyojwi Dios. ");
INSERT INTO nhx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’¡Lástima amejeme̱n yej antamachtiáj ipan la ley iwá̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij!, ankikui̱liáj ikalmej yej we̱wejmikikej iwá̱n iga amo mane̱si yej ankichijtokej, pox anwejka̱waj iga an‑ora̱dowaj. Inó̱n iga amejeme̱n má̱j yawij mitzikno̱chi̱watij. ");
INSERT INTO nhx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Lástima amejeme̱n yej antamachtiáj ipan la ley iwá̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij! Amejeme̱n poxsan wejka annejnemij ipan ta̱jli iwá̱n ipan láma̱r iga ankite̱mojtinemij yej wel ankiyo̱lyama̱naj iga makichi̱waka̱n no̱ ken amejeme̱n ankichi̱waj, eꞌ kua̱ꞌ ankiyo̱lyamá̱nkeja inó̱n tokni̱n ma̱jya kajasi iga mayawi ka̱n tawewelkatoꞌ, ma̱jya sej que amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Lástima amejeme̱n, momati iga antaye̱ꞌojkui̱ltiáj ipan iyojwi Dios, eꞌ ayá̱ꞌ anki̱xmatij! Ankijtowaj: “Siga agaj kijtowa iga kichi̱was tejté̱ iwá̱n kikui iga testigo weyitio̱pan, até̱ kichij siga ayá̱ꞌ kichi̱was; eꞌ siga kikui iga testigo i‑o̱rojyo weyitio̱pan, inó̱n sí aye̱kti siga akichi̱wa.” ");
INSERT INTO nhx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Anxe̱toktikej iwá̱n ken ampachamej! ¿Katiapa má̱j ye̱kti: ix oro o weyitio̱pan yej kichi̱wa iga mamoye̱ꞌita oro iga onoꞌ tio̱pan‑ijtiꞌ? ");
INSERT INTO nhx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iwá̱n no̱ ankijtowaj amejeme̱n: “Si agaj kijtowa iga kichi̱was tejté̱ iwá̱n kikui iga testigo altar yej onoꞌ weyitio̱pan, até̱ kichij siga ayá̱ꞌ kichi̱was; eꞌ siga kikui iga testigo ofrenda yej onoꞌ iyi̱xko altar, inó̱n sí aye̱kti siga akichi̱wa.” ");
INSERT INTO nhx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Anxe̱toktikej iwá̱n ampachamej! ¿Katiapa má̱j ye̱kti: ofrenda o altar? Yej má̱j yé̱ktiwaꞌ altar iga kichi̱wa iga mavale̱ro ofrenda iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Yej kita̱lij iga testigo altar, ayéj testigo petz altar, no̱ yej onoꞌ iyi̱xko. ");
INSERT INTO nhx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yej kita̱lij testigo weyitio̱pan, ayéj testigo petz weyitio̱pan, no̱ Dios, iga ompa icha̱n. ");
INSERT INTO nhx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yej kikui testigo cielo iga kijtowa iga kichi̱was tejté̱, no̱ nemi kita̱liá Dios de testigo iga ompa e̱watoꞌ ka̱n reina̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Lástima amejeme̱n yej antamachtiáj ipan la ley iwá̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij! Amejeme̱n ankimakaj Dios amodie̱zmoj nochi yej ankipiáj este yej má̱j ali̱mpa íyo̱l wa̱n iyiswayo yej yawi ipan especia, eꞌ ayá̱ꞌ ankichi̱waj yej má̱j ye̱kti yej kijtowa iley Moisés, iga xiye̱ꞌnemika̱n, xita‑ikne̱li̱ka̱n iwá̱n iga ximoconfia̱ro̱ka̱n ipan Dios. Ino̱nwaꞌ in xikchi̱waka̱n, eꞌ amo xikajte̱waka̱n iga ankita̱liáj amodie̱zmoj. ");
INSERT INTO nhx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Amejeme̱n momati iga antaye̱ꞌojkuiltiáj ipan iyojwi Dios, eꞌ ayá̱ꞌ anki̱xmatij. Amejeme̱n kua̱ꞌ ankoniáj tejté̱, ankiki̱xtiliáj se̱ asastzi̱n, eꞌ ayá̱ꞌ ankitaj iga ankimelaꞌtolowaj se̱ camello! ");
INSERT INTO nhx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Lástima amejeme̱n yej antamachtiáj ipan iley Moisés iwá̱n anfariseojmej, né̱sikiꞌ anye̱ꞌnemij sie̱mpa ayá̱ꞌ!, kenkua̱ꞌ ankipajpa̱kaj plato iwá̱n posillo fue̱rájbapa, eꞌ amejeme̱n ipan amoa̱lmajmej ankejla̱ntokej iga antachtekij iwá̱n anmopoxtapiali̱jnekij. ");
INSERT INTO nhx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Amejeme̱n anfariseojmej yej ken ampachamej: achto xikpa̱kaka̱n iyijtiko vaso iwá̱n plato, ijkó̱n no̱ ejtos fue̱rájbapa. ");
INSERT INTO nhx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Anla̱stimajmej yej antamachtiáj ipan iley Moisés iwá̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij!, amejeme̱n ken tikita se̱ a̱nimajxapo yej este ijísta̱ꞌsan iyí̱xkopa, este ye̱ꞌne̱si, eꞌ ta‑ijtiꞌ te̱ntoꞌ iwá̱n a̱nimajomimej iwá̱n kuajkuantas yej pala̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ijkó̱n in amejeme̱n; mitzítajkiꞌ pox anye̱ꞌnemij; eꞌ san anmopajpantiáj iga anye̱ꞌnemij iwá̱n poxsan ankichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Anla̱stimajmej yej antamachtiáj ipan la ley iwá̱n amejeme̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij! Amejeme̱n yej ankichi̱wiliáj ikalyotzitzi̱n ka̱n to̱ktokej profe̱tajmej, iwá̱n poxsan ankimo̱nsajtiliáj ikalyotzitzi̱n ka̱n moto̱kaj yej ye̱ꞌnemij. ");
INSERT INTO nhx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Iwá̱n ankijtowaj: “Siga katka tonóyaja kua̱ꞌ to‑ikyapatajwa̱n kimiktijkej profe̱tajmej, tejeme̱n ayá̱ꞌ tikpale̱wia̱yaj kua̱ꞌ kimiktijkej profe̱tajmej.” ");
INSERT INTO nhx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iga ijkó̱n ankijtowaj, anmokui̱tiáj iga amejeme̱n ipilowa̱n yej kimiktijkej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Iná̱n, ¡xiktami̱ka̱n yej amo‑ikyapatajwa̱n kitzi̱ntijkej! ");
INSERT INTO nhx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’¡Ankowa̱mej! ¡Kowa̱mej amokni̱wa̱n! ¿Kénya anmoma̱nawi̱skej ka̱n ta‑ikno̱chi̱was tiwelo̱n? ");
INSERT INTO nhx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Inó̱n iga nia nimitzti̱tanili̱tij profe̱tajmej, yej kimatij ken iga wel maye̱ꞌnemilo, iwá̱n yej mitzmachtiáj ipan iley Moisés. Eꞌ amejeme̱n anyawij ankimikti̱tij iwá̱n sekin ankiclava̱ro̱skej ipan cruz iwá̱n onoꞌ yej ipan tio̱pamej anyawij ankimagatij, ipan sejsé̱ a̱ltepe̱ꞌ anyawij ankitalo̱chti̱tij. ");
INSERT INTO nhx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Inó̱n iga yawij mitzcastiga̱ro̱tij iga nochi yej ikya amotajwe̱wetkej kimiktijkej ino̱mej tajta̱gaꞌ yej ye̱ꞌnemiáj, desde Abel yej ye̱ꞌnemiá, iwá̱n este Zacarías yej ipíltzi̱mpa Berequías, yej amejeme̱n ankimiktijkej iyi̱xtaj weyitio̱pan, ite̱noj altar. ");
INSERT INTO nhx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nej nimitzijliáj iga yawij mitzcastiga̱ro̱tij amonochi̱n iga iní̱n yej ankichijkej. ");
INSERT INTO nhx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jesús kijtoj: —¡Amejeme̱n, amejeme̱n yej ancha̱ntitokej Jerusalén, yej ankimiktiáj profe̱tajmej iwá̱n ankitejtemiktiáj tati̱tanimej yej Dios mitzti̱taniliáj! ¡Miaꞌ ve̱j nikneꞌ manimitznechko̱ka̱n ken pio‑ilamaj kinechkowa ipilowa̱ntzitzi̱n iya̱stakapaltampa, eꞌ ayá̱ꞌ ankinekikej! ");
INSERT INTO nhx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Taꞌ xikitaka̱n, iná̱n amoweyitio̱pan yawi ka̱witi ise̱lti; ");
INSERT INTO nhx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","iwá̱n nimitzijliáj iga ayá̱ꞌ má̱j anyawij anne‑itatij este kua̱ꞌ antajto̱skej de nej ijkí̱n: “Matikweyimati̱lti̱ka̱n yej wi̱ꞌ, yej toTe̱ko Dios kiti̱tani.” ");
INSERT INTO nhx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús ki̱saꞌ weyitio̱pan iwá̱n némiya ya̱ya, íkua̱ꞌ idisci̱polojmej kitechojkej iwá̱n pe̱waꞌ iga kitajtachi̱lijkej ken iga chijtoꞌ weyitio̱pan. ");
INSERT INTO nhx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Eꞌ Jesús kijtoj: —¿Ankitaj ini̱mej kalwe̱wetkej? Nigaj ayá̱ꞌ yawi ka̱witi nisé̱ teꞌti yej mane̱nekpanijto. Nochi yawij moxijxiti̱natij. ");
INSERT INTO nhx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iwá̱n yajkij ipan tepe̱ꞌ yej ito̱ka̱ꞌ Olivos. Kua̱ꞌ Jesús ómpaya e̱watoꞌ, idisci̱polojmej kichtakatajtankej ijkí̱n: —¿Ké̱manya nokta yawi mochi̱wati o̱n yej tikijtoj? ¿Té̱ mo‑itas kua̱ꞌ tíwi̱ꞌya, iwá̱n iga poliwílo̱jya nokta? ");
INSERT INTO nhx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Iwá̱n Jesús kijtoj: —Amo agaj mitzkajkaya̱waskej, ");
INSERT INTO nhx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","iga miaꞌ yawij wi̱tzetij iwá̱n mopajpanti̱skej iga nej, sie̱mpa ayéj. Ijkí̱n kijto̱skej: “Nejya el Cristo”; iwá̱n miaꞌ yawij kikajkaya̱watij. ");
INSERT INTO nhx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kua̱ꞌ ankikakiskej iga nijnijiga némiya momijmiktilo, iwá̱n ankikakiskej iga seꞌ ta̱jli no̱ némiya momijmiktilo, amo ximomajti̱ka̱n, inó̱n nochi nokta yawi mochi̱wati, eꞌ aya yej iga poliwilo. ");
INSERT INTO nhx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Se̱ país momijmikti̱j iwá̱n sewoꞌ, iwá̱n se̱ nación momijmikti̱j iwá̱n seꞌ; iwá̱n poxsan a̱pistajtiás, poxsan no̱ onos kokolis iwá̱n onos ta̱lo̱li̱n nijnijiga. ");
INSERT INTO nhx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nochi iní̱n aya yéj iga poliwilo, pé̱waoꞌ iga mokno̱chi̱walo. ");
INSERT INTO nhx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Amejeme̱n yawij mitzki̱tzki̱tij iga mitzmagaskej iwá̱n mitzmikti̱skej. Nochi mitzijiyaskej iga anne̱tokaj. ");
INSERT INTO nhx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Íkua̱ꞌ miaꞌ yawij kikajte̱watij iga ne̱tokaj, iwá̱n yawij mo‑iji̱yatij. Onos yej kimikti̱jnekiskej yej ne̱tokaj wa̱n sekin kine̱xti̱skej ka̱n onokej yej mi̱ya̱ntokej. ");
INSERT INTO nhx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yawij wi̱tzetij miaꞌ yej takajkaya̱waj, kijto̱skej iga yejemej profe̱tajmej, sie̱mpa ayéj, iwá̱n miaꞌ yawij kikajkaya̱watij. ");
INSERT INTO nhx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Poxsan mochi̱was yej aye̱kti, iwá̱n miaꞌ kikajte̱waskej iga te‑ijikni̱mej. ");
INSERT INTO nhx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Eꞌ yej moconfia̱rojtoꞌ nochipa ipan nej, inó̱n moma̱nawi̱j. ");
INSERT INTO nhx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iní̱n ye̱ꞌnoti̱ciaj yej kijtowa ken iga reina̱rowa Dios, yawi mopowati no̱ya̱n ipan iní̱n ta̱jli, iga nochi gente makimati. Íkua̱ꞌya sí yáwiya tamiti nochi kua̱ꞌ Dios tajuzga̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’El profeta Daniel kijkuiloj iga mochi̱was yej pox aye̱kti weyitio̱pan‑ijtiꞌ; kua̱ꞌ ankitaskej iga inó̱n ónoꞌya ka̱n moweyimati̱ltiá Dios —yej kilee̱rowa, makentende̱ro—, ");
INSERT INTO nhx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","yej onoskej ipan estado de Judea mayá̱ka̱nya ipan tepe̱yoj. ");
INSERT INTO nhx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yej onos iyi̱xko kajli ipan ipetayo, amo matemo iga makiki̱xti tejté̱ kalijtiꞌ; ");
INSERT INTO nhx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","iwá̱n yej nemis mi̱lijtiꞌ, ayoꞌ mayawi icha̱n iga makikuiti itzótzol. ");
INSERT INTO nhx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Lástima siwa̱tkej inó̱n día iga yej tatalaxwijtokej iwá̱n yej tachi̱chitijtokej! ");
INSERT INTO nhx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xiktajtanili̱ka̱n Dios iga kua̱ꞌ ancholo̱skej amo kua̱ꞌ tasektaj, niga ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Poxsan nokta mokno̱chi̱walo̱j, ayí̱ꞌ ijkó̱n mo‑itaꞌ este kua̱ꞌ pe̱waꞌ mochij iní̱n ta̱jli. Niga mochí̱wasoꞌ sej ijkó̱n. ");
INSERT INTO nhx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Siga toTe̱ko ayá̱ꞌ kixelo̱j ino̱mej días, ayagaj moma̱nawi̱j; eꞌ kixelo̱j iga kicho̱kiliá ino̱mej yej yéj kitapejpen. ");
INSERT INTO nhx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Siga agaj mitzijli̱skej: “Taꞌ xikitaka̱n nigaj onoꞌ Cristo”, o “Xikitaka̱n nepa onoꞌ”, amejeme̱n amo xiktajto̱lkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iga yawij wi̱tzetij iwá̱n mopajpanti̱skej iga nej, sie̱mpa ayéj, kijto̱skej “Nejya niCristo”, iwá̱n kijto̱skej iga yejeme̱n profe̱tajmej iga Dios kitajto̱lmakaj, sie̱mpa takajkaya̱waj. Yawij kichi̱watij mila̱grojmej yej ayi̱ꞌpa mo‑ita iga matakajkaya̱waka̱n, este wel anka kikajkaya̱waskej yej Dios kitapejpen. ");
INSERT INTO nhx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nej iní̱n nochi nimitzmati̱ltíjkeja malej aya mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Inó̱n iga, siga mitzijliáj: “Taꞌ xikitaka̱n, nepa onoꞌ ipan desierto”, amo xa̱ka̱n; o si agaj mitzijli̱skej “Ne̱kiꞌ onoꞌ kalijtiꞌ”, amo xiktajto̱lkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ijkó̱n ken ankitaj kua̱ꞌ tapeta̱ni iwá̱n ta̱wiá este iki̱saya̱n to̱nati̱ꞌ iwá̱n este ikalakiya̱n, ijkó̱n kua̱ꞌ nia niwi̱tzeti nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ka̱n onoꞌ yej míktoꞌya, ompa monechkowaj mo̱ximej. ");
INSERT INTO nhx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesús kijtoj: —Kua̱ꞌ páno̱jya ino̱mej días iga mokno̱chi̱walo̱j, yawi tako̱mitiati iga ayꞌya ta̱wi̱j to̱nati̱ꞌ, niga ayꞌya tame̱tzto̱nas; si̱talimej yej onokej ipan cielo wejwetziskej. Nochi yej onokej ipan cielo mojo̱li̱naskej. ");
INSERT INTO nhx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Iwá̱n mo‑itas ipan cielo iga nine̱síkiya nej yej iPiltzi̱n Ta̱gaꞌ, iwá̱n nochi gente yawij cho̱katij iga majmawiskej, iwá̱n ne‑itaskej nej yej iPiltzi̱n Ta̱gaꞌ iga niwi̱ꞌ ipan mixti, nita̱wijtiwi̱ꞌ iga noweyipode̱r. ");
INSERT INTO nhx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Iwá̱n niktekimakas noa̱ngelejmej iga recio matapi̱tzaka̱n iga trompeta iga makinechko̱ka̱n yej niktapejpen, yej nijnijiga onokej no̱ya̱n ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Ximi̱xkui̱ti̱ka̱n ipan higue̱rajkuawiꞌ: Kua̱ꞌ ankitaj némiya ki̱sa iseliska iwá̱n némiya iswayowij, ankimatij iga wi̱ꞌya to̱nalis. ");
INSERT INTO nhx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ijko̱nsan no̱, kua̱ꞌ ankitaskej iga némiya mochi̱wa nochi yej nimitzijlijkej, xikmatika̱n iga aké̱ꞌ poliwi iga nej níwi̱ꞌya sej. ");
INSERT INTO nhx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nimitzijliáj iga nochi iní̱n yawi mochi̱wati kua̱ꞌ aya mikij yej iná̱n onokej. ");
INSERT INTO nhx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Cielo iwá̱n ta̱jli poliwiskej, eꞌ yej nikijtoj, nochi yawi mochi̱wati. ");
INSERT INTO nhx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Eꞌ ayagaj nokta kimati te̱ día o te̱ hora, ayagaj kimati, niga a̱ngelejmej yej onokej ipan cielo, niga nej yej iPiltzi̱n Dios, isé̱ltisan noTaj Dios, kimati. ");
INSERT INTO nhx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Ijko̱nsan ken mochij kua̱ꞌ onoya Noé, ijko̱nsan no̱ kua̱ꞌ niwi̱ꞌ nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Kua̱ꞌ aya a̱poliwilo iga tiawa̱ꞌ, nemi takualowa̱ya iwá̱n nemi a̱tilowa̱ya iwá̱n nemi mona̱miktia̱yaj iwá̱n sekin nemi kina̱miktia̱yaj isiwa̱pilowa̱n, ijkó̱n kichijtoyaj este iga Noé kalaꞌ ipan weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Iwá̱n ayagaj kimatiá, este que wa̱laj tiawa̱ꞌ yej pox recio iwá̱n nochi a̱mikikej. Ijko̱nsan no̱ kua̱ꞌ niwi̱ꞌ nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Inó̱n ve̱j o̱me ta̱gaꞌ onoskej mi̱lijtiꞌ; se̱ kiwi̱gaskej iwá̱n seꞌ kikajte̱waskej. ");
INSERT INTO nhx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","O̱me siwa̱tkej tapaya̱ntoskej; se̱ kiwi̱gaskej, iwá̱n seꞌ kikajte̱waskej. ");
INSERT INTO nhx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Inó̱n íga xisatoka̱n iga ayá̱ꞌ ankimatij te ke̱man nia niwi̱tzeti nej yej amoTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Eꞌ xikmatika̱n iní̱n, siga ite̱ko kajli kimatiá te̱ hora wi̱ꞌ tayowaka̱n yej tachteki, ayá̱ꞌ kochá iwá̱n ayá̱ꞌ mote̱makas iga makikaltapo̱ka̱n iga makitachtekika̱n. ");
INSERT INTO nhx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Inó̱n iga amejeme̱n xisatoka̱n iga xine̱chi̱xtoka̱n; nej yej iPiltzi̱n Ta̱gaꞌ niwi̱ꞌ kua̱ꞌ ayá̱ꞌ ankimatitokej. ");
INSERT INTO nhx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kijtoj Jesús: —Nimitzijliáj iga ye̱ꞌtekipanowa̱ni nochipa kichi̱wa ken kijtowa ite̱ko, iwá̱n kimati yej mamochi̱wa; ino̱mpa tekipanowa̱ni ite̱ko kitapejpena iga makita nochi ikalijtiꞌ, wa̱n este matatamaka kua̱ꞌ nokta takualo. ");
INSERT INTO nhx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pa̱ktoꞌ inó̱n tekipanowa̱ni iga kua̱ꞌ wi̱ꞌ ite̱ko kasiki kichijtoꞌ ken kitekimakakej. ");
INSERT INTO nhx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nimitzijliáj iga inó̱n tekipanowa̱ni yawij kita̱li̱tij iga makimanda̱ro inochi yej itátkipa ite̱ko. ");
INSERT INTO nhx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Eꞌ siga inó̱n tekipanowa̱ni kichi̱was yej aye̱kti, iwá̱n makijto ipan iya̱lmaj: “Note̱ko wejká̱wasoꞌ iga asis”, ");
INSERT INTO nhx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","iwá̱n pe̱was iga kikno̱chi̱was sekin tekipanowa̱nimej, iwá̱n pe̱was iga takua, iwá̱n senta̱wa̱na iwá̱n sekin, ");
INSERT INTO nhx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ite̱ko yawi wi̱tzeti kua̱ꞌ inó̱n tekipanowa̱ni ayá̱ꞌ kichi̱xtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Iwá̱n poxsan yawi kicastiga̱ro̱tij; kensan ino̱mej yej mopajpantiáj iga ye̱ꞌnemij. Yawi cho̱kati iwá̱n este tangueguetzekas. ");
INSERT INTO nhx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesús kijtoj: —Ka̱n reina̱rowa Dios ken tikita diez takomej yej kikuikej icandi̱lmej de aceite iwá̱n yajkij ka̱n mona̱miktilo iga ki̱xna̱mikitoj chokotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco de yejemej moxe̱toꞌtilijkej, iwá̱n seꞌ cinco ye̱ꞌtajla̱ntokej. ");
INSERT INTO nhx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Yej xe̱toktikej kikuikej icandi̱lmej, eꞌ ayá̱ꞌ kiwi̱gakej aceite iga sej maka̱ta̱lili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yej ye̱ꞌtajla̱ntokej, kinentia̱yaj má̱j aceite ipan ibote̱llajmej, iyoka yej kinentia̱yaj ipan icandi̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Chokotzi̱n poxsan wejkaj, iwá̱n takomej inochimej kochisnekikej iwá̱n kochikej. ");
INSERT INTO nhx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Wa̱n tajkoyówal tzajtzilo̱ꞌ: “¡Wi̱ꞌya chokotzi̱n, xiki̱xna̱mikítija!” ");
INSERT INTO nhx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nochi ino̱mej takomej mopejpentiketzkej ka̱n kochtoyaj, iwá̱n pe̱wakej iga ka̱ta̱liliáj icandi̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Iwá̱n ino̱mej cinco takomej yej moxe̱toꞌtilijkej, kijlijkej ino̱mej yej ye̱ꞌtajla̱ntokej: “Achi xine̱makaka̱n amoaceitej, iga némiya se̱wi nocandi̱lmej.” ");
INSERT INTO nhx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Eꞌ takomej yej ye̱ꞌtajla̱ntokej, kijtojkej: “Ayá̱ꞌ, akimakas iga tonochimej. Má̱j ye̱kti xa̱ka̱n xikowatij ka̱n monamaka iga no̱ xikpiaka̱n amoaceitej.” ");
INSERT INTO nhx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mie̱j ino̱mej cinco takomej yej moxe̱toꞌtilijkej nemi ya̱yaj kikowatij aceite, asiꞌ chokotzi̱n. Takomej yej kipiáyaja aceite kalakkej iwá̱n chokotzi̱n ka̱n mona̱miktilo iwá̱n tzakuiꞌ kalte̱n. ");
INSERT INTO nhx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Iwá̱n asikoj takomej yej takowato̱yaj, kijtojkej: “¡Juu, juu, achi xine̱kaltapo̱wili̱ka̱n!” ");
INSERT INTO nhx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Eꞌ chokotzi̱n kijtoj: “Nimitznojma‑ijliáj iga ayá̱ꞌ nokta nimitzi̱xmatij.” ");
INSERT INTO nhx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesús kijlij idisci̱polojmej: —Xisatoka̱n, iga ayá̱ꞌ ankimatij ke̱man niwe̱jasiki, nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Ka̱n reina̱rowa Dios ken tikita se̱ ta̱gaꞌ yej motapialiá yej yá̱tiya wejka ipan seꞌ país, kino̱tzaꞌ itekipanowa̱nimej iga kikajte̱wilij tomi̱n iga makitekipano̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Se̱ de yejemej kimáꞌ cinco tawaxa̱n tomi̱n, seꞌ kimáꞌ o̱me tawaxa̱n tomi̱n, iwá̱n seꞌ kimáꞌ se̱san, ijkó̱n nochi kimajmáꞌ ke̱ꞌsan wel kitekipano̱ltiá. Iwá̱n yájkiya wejka ipan seꞌ ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Iwá̱n inó̱n tekipanowa̱ni yej kimakakej cinco tawaxa̱n tomi̱n, kitekipanoj iwá̱n kita̱nilij seꞌ cinco. ");
INSERT INTO nhx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ijko̱nsan no̱ yej kimakakej o̱me tawaxa̱n tomi̱n, kita̱nilij seꞌ o̱me. ");
INSERT INTO nhx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Eꞌ yej kimakakej se̱san, yajki ki̱ya̱nato itomi̱n ite̱ko, kichkuaꞌ ta̱jli iwá̱n kito̱gaꞌ inó̱n tomi̱n yej kimakakaj. ");
INSERT INTO nhx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Kua̱ꞌ pox wejkaj, ite̱ko ino̱mej tekipanowa̱nimej wa̱laj sej, íkua̱ꞌya kichij cuenta iwá̱n yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Achto asiko yej kimakakej cinco tawaxa̱n tomi̱n, iwá̱n kimáꞌ seꞌ má̱j cinco yej yéjpaya kita̱nilij, kijtoj: “Note̱ko, tine̱magaꞌ cinco tawaxa̱n tomi̱n, iná̱n nigaj onoꞌ seꞌ cinco yej nejya nikta̱nilij.” ");
INSERT INTO nhx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ite̱ko kijtoj: “Ómpaya ken tikchij, tej sí tiye̱ꞌtekipanowa̱ni iga tikchij ken nimitzijlij; como tikpi̱wij yej alí̱n nimitzmakaka, iná̱n nia nimitzmakati iga xitekipano ipan yej má̱j komati. Xikalákiya iga matisempa̱kika̱n.” ");
INSERT INTO nhx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Má̱j má̱j asiko inó̱n tekipanowa̱ni yej kimakakaj o̱me tawaxa̱n tomi̱n, iwá̱n kijtoj: “Note̱ko, tine̱makaka o̱me tawaxa̱n tomi̱n, iná̱n nikuajli̱ꞌ na̱wi, nikta̱nilij seꞌ o̱me.” ");
INSERT INTO nhx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ite̱ko kijtoj: “Ómpaya ken tikchij, tej sí tiye̱ꞌtekipanowa̱ni iga tikchij ken nimitzijlij; iga tikpi̱wij yej alí̱n nimitzmakaka, iná̱n nia nimitzmakati iga xitekipano ipan yej má̱j komati. Xikalákiya iga matisempa̱kika̱n.” ");
INSERT INTO nhx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Eꞌ kua̱ꞌ asiꞌ inó̱n tekipanowa̱ni yej kimakakaj se̱san tawaxa̱n tomi̱n, kijlij ipatró̱n: “Note̱ko, nej nikmatiá iga tipoxyo̱ltakuaktiꞌ iwá̱n titapixka ka̱n ayá̱ꞌ tito̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Inó̱n iga nimitzi̱makasiꞌ, iwá̱n nikto̱gaꞌ motomi̱n, eꞌ nigaj onoꞌ yej motatki.” ");
INSERT INTO nhx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ite̱ko kijlij: “Ayéj tiye̱ꞌtekipanowa̱ni, atikyo̱lmaka iga titekipanowa, tikmatiaya iga nej nitapixka ka̱n ayá̱ꞌ nito̱gaꞌ; ");
INSERT INTO nhx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","maséj tika̱wato in notomi̱n ipan banco, ijkó̱n kua̱ꞌ nimokuepaya tine̱makaya notomi̱n wa̱n seꞌ alí̱n yej kita̱nij.” ");
INSERT INTO nhx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Iwá̱n kijlij yej ompa onoyaj: “Xikui̱li̱ka̱n inó̱n tawaxa̱ntomi̱n yej kipiaya, iwá̱n xikmakaka̱n inó̱n yej kipiá diez. ");
INSERT INTO nhx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Iga yej kipiá, má̱j yawij kimakatij, este po̱póxsanya sej yawi kipiati; eꞌ yej ayá̱ꞌ kipiá, este yej alí̱n kipiá yawij kikui̱li̱tij. ");
INSERT INTO nhx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Iwá̱n iní̱n ta̱gaꞌ yej atekipano̱jneki, xiki̱xti̱ka̱n iga maono ka̱n tako̱mi iga ompa macho̱kato este magueguetzeka itan.” ");
INSERT INTO nhx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Kua̱ꞌ nej yej iPiltzi̱n Ta̱gaꞌ niwi̱ꞌ ken se̱ rey, ne̱yawalojtiwi̱tzej noa̱ngelejmej, iwá̱n nimota̱li̱j ipan weyi asie̱ntoj ka̱n nirreina̱ro̱j. ");
INSERT INTO nhx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Iwá̱n nochi gente yej onoꞌ ipan iní̱n ta̱jli yawij monechko̱tij no‑i̱xtaj, iwá̱n nej nia nikyojyokati̱tij, ken tikita yej kicuida̱rowa yo̱lka̱mej kiyojyokatiá borre̱gojmej iwá̱n chi̱vojmej. ");
INSERT INTO nhx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iwá̱n borre̱gojmej yawij ka̱witij noye̱ꞌka̱mpa, iwá̱n chi̱vojmej yawij ka̱witij noo̱pochka̱mpa. ");
INSERT INTO nhx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wa̱n nej yej Rey nia nikijli̱ti yej ka̱witij noye̱ꞌka̱mpa: “Xiwi̱kíka̱nya yej mitzpale̱wijkej noTaj iga xiye̱ꞌonoka̱n; xikalakika̱n ka̱n Dios reina̱rowa. Ijkó̱n kineꞌ Dios desde iga mochij iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nimaya̱naꞌ iwá̱n amejeme̱n anne̱tamakakej; kua̱ꞌ ni‑a̱tanekiá, annea̱makakej; kua̱ꞌ ninemiá ka̱n ayéj nocha̱n, anne̱kochtijkej amocha̱n. ");
INSERT INTO nhx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kua̱ꞌ anikpiaya notzótzol, anne̱tzotzolyo̱tijkej; kua̱ꞌ niwe̱titoya, anneo̱mema̱wijkej; kua̱ꞌ nonoya preso, anne̱paxa̱lowili̱toj.” ");
INSERT INTO nhx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Iwá̱n yej kichi̱waj ken Dios kineki, kijto̱skej: “NoTe̱ko, ¿ké̱man nimitzitakej iga timaya̱ntinemiá iwá̱n nimitztamakakej? ¿O ké̱man nimitzitakej iga ta̱tanektinemiá iwá̱n nimitza̱makakej? ");
INSERT INTO nhx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ké̱man nimitzitakej iga tinemiá ka̱n ayéj mocha̱n iwá̱n nimitzkochtijkej nocha̱mej? ¿O ké̱man mitzpoloj motzótzol iwá̱n nimitztzotzolyo̱tijkej? ");
INSERT INTO nhx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿O ké̱man nimitzitakej tiwe̱titoya, o tonoya ipan cárcel iwá̱n nimitzpaxa̱lowili̱toj?” ");
INSERT INTO nhx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","El Rey kijto̱j: “Nej nimitzijliáj, kua̱ꞌ tejté̱ ankichi̱wilijkej yej ye̱kti ini̱mej nokni̱wa̱n yej moali̱mpamatij, ino̱nwaꞌ nej anne̱chi̱wilijkej.” ");
INSERT INTO nhx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Iwá̱n el Rey kijli̱j yej onokej iyo̱pochka̱mpa: “Xicholo̱ka̱n no‑i̱xtaj amejeme̱n yej amonókeja iga anyawij ampoliwitij; xa̱ka̱n ipan tiwelo̱n yej ayí̱ꞌ se̱wi yej onoꞌ iga Tzitzimiꞌ iwá̱n iga iya̱ngelejmej. ");
INSERT INTO nhx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nimaya̱naꞌ, iwá̱n ayá̱ꞌ anne̱tamakakej, ni‑a̱taneguiꞌ iwá̱n ayá̱ꞌ annea̱makakej. ");
INSERT INTO nhx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ninemiá ka̱n ayéj nocha̱n, iwá̱n ayá̱ꞌ anne̱kochtijkej amocha̱n. Anikpiaya notzótzol, amejeme̱n ayá̱ꞌ anne̱tzotzolyo̱tijkej; kua̱ꞌ niwe̱titoya iwá̱n nonoya preso, ayá̱ꞌ anne̱paxa̱lowili̱toj.” ");
INSERT INTO nhx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Iwá̱n yejemej kijto̱skej: “NoTe̱ko, ¿ké̱man nimitzitakej timaya̱ntinemi, o ti‑a̱tanektinemi, o tiwejkacha̱nej, atikpiaya motzótzol, o tiwe̱titoya, o tonoya ipan cárcel, iwá̱n ayá̱ꞌ nimitzpale̱wijkej?” ");
INSERT INTO nhx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Iwá̱n inó̱n Rey kijto̱j: “Nimitzijliáj iga kua̱ꞌ ayá̱ꞌ ankichi̱wilijkej yej ye̱kti ini̱mej nokni̱wa̱n yej moali̱mpamatij, nej no̱ ayá̱ꞌ anne̱chi̱wilijkej.” ");
INSERT INTO nhx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ini̱mej ya̱tij ka̱n ayí̱ꞌ tamis iga kikno̱chi̱waskej, eꞌ yej kichi̱waj ken Dios kineki, yawij onotij nochipa wa̱n Dios, ayí̱ꞌ mikiskej. ");
INSERT INTO nhx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kua̱ꞌ Jesús tamiꞌ nochi kijtoj iní̱n, kijlij idisci̱polojmej: ");
INSERT INTO nhx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Amejeme̱n ankimátija iga mo̱sta se̱ día ásisya iyilwiyo la Pascua; nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱ki̱tzki̱tij iwá̱n yawij ne̱mikti̱tij ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Iwá̱n ije̱fejmej sacerdo̱tejmej, wa̱n yej tamachtiáj ipan la ley iwá̱n we̱wetkej yej kimanda̱rowaj judiyojmej, monejnechkojkej cha̱n Caifás, yej ije̱fej ije̱féjmejpa sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ompa mota̱tapo̱wijkej iga makiki̱tzki̱ka̱n Jesús, eꞌ matakajkaya̱wáka̱mpa iga makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kijtowa̱yaj: —Ayá̱ꞌ tikchi̱waskej kua̱ꞌ nentoꞌ ilwiꞌ, iga amo makuesiwilo. ");
INSERT INTO nhx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kua̱ꞌ Jesús onoya a̱ltepe̱ꞌ Betania cha̱n Simón yej kipiaya lepra, ");
INSERT INTO nhx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","se̱ siwa̱ꞌ yajki ka̱n onoꞌ Jesús, kiwajli̱ꞌ se̱ ibote̱yajtzi̱n yej kipiaya aceite yej poxsan ajwiya̱ꞌ iwá̱n pox vale̱rowa, iwá̱n kitoya̱wilij ipan itzontekon Jesús ka̱n ki̱xna̱ntoya mesa. ");
INSERT INTO nhx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Kua̱ꞌ disci̱polojmej inó̱n kitakej, kuesiwikej, mojlijkej: —¿Te iga in iní̱n aceite kiyokatoyajkej? ");
INSERT INTO nhx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iní̱n wel katka mamonamaka iga komati tomi̱n, iwá̱n inó̱n tomi̱n tikmajmakayaj yej ayá̱ꞌ motapialiáj. ");
INSERT INTO nhx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús kikaguiꞌ yej kijtojkej disci̱polojmej, kijtoj: —¿Te iga nemi ankikuejkuesowaj iní̱n siwa̱ꞌ? Inó̱n yej ne̱chi̱wilij poxsan nikye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Yej ayá̱ꞌ motapialiáj, nochipa onoskej amowa̱n, eꞌ nej ayá̱ꞌ nochipa nij anne̱piaskej. ");
INSERT INTO nhx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Iga iní̱n siwa̱ꞌ kitoyaj iní̱n yej ajwiya̱ꞌ noyakapan, tane̱xtiliá iga ijkí̱n ne̱chi̱wili̱skej kua̱ꞌ ne̱to̱kaskej. ");
INSERT INTO nhx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nimitzijliáj iga nó̱ya̱nsan ka̱n mopowas ipan inewi iní̱n ta̱jli, kén iga Dios tama̱nawiá, yawi no̱ mopowati yej kichij iní̱n siwa̱ꞌ, iwá̱n ijkó̱n moejla̱mikis yej kichij. ");
INSERT INTO nhx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Se̱ de ino̱mej doce idiscí̱poloj yej ito̱ka̱ꞌ Judas Iscariote, yajki kitato ije̱fejmej sacerdo̱tejmej, ");
INSERT INTO nhx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","iwá̱n kijlij: —Siga nimitzpale̱wiáj iga xiki̱tzki̱ka̱n Jesús, ¿ké̱ꞌ tomi̱n anne̱makaskej? Iwá̱n yejemej kipaga̱rojkej treinta tomi̱n de plata. ");
INSERT INTO nhx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Iwá̱n íkua̱ꞌya Judas kite̱moj ke̱man wel makiki̱tzki̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Inó̱n día kua̱ꞌ pe̱waꞌ iyilwiyo la Pascua, kua̱ꞌ mokua pa̱n yej ayá̱ꞌ kipiá levadura, disci̱polojmej kitechojkej Jesús, kitajtankej: —¿Ka̱n tikneki manimitzchi̱wili̱tij tákual iga tikilwichi̱wili̱skej la Pascua? ");
INSERT INTO nhx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús kijtoj: —Xa̱ka̱n Jerusalén, icha̱n inó̱n ta̱gaꞌ yej anki̱xmatij iwá̱n xikijli̱ka̱n: “ToTamachtia̱ni kijtowa ijkí̱n: Nej ali̱nsan poliwi iga yáwija ne̱mikti̱tij, mocha̱n nikpano̱lti̱jneki iyilwiyo la Pascua iwá̱n nodisci̱polojmej.” ");
INSERT INTO nhx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Disci̱polojmej kichijkej ken kijtoj Jesús, iwá̱n kichijkej tákual iga kilwichi̱wiliáj la Pascua. ");
INSERT INTO nhx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kua̱ꞌ tayowátiꞌya, Jesús ki̱xna̱n mesa iwá̱n doce idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mie̱j takuajtoyaj, kijtoj: —Nimitznojma‑ijliáj iga se̱ de amejeme̱n yawi ne̱ne̱xti̱ti iga mane̱ki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Disci̱polojmej poxsan mokno̱matikej; iwá̱n sejsé̱ pe̱ꞌ kitajtankej Jesús; —¿NoTe̱ko, ix nej? ");
INSERT INTO nhx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Iwá̱n Jesús kijtoj: —Se̱ de amejeme̱n yej íwa̱n nemi nisentakua ipansan iní̱n plato, yawi ne‑ichtakane̱xti̱ti iga mane̱mikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nimitzijliáj iga nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱mikti̱tij ken ijkuilijtoꞌ, eꞌ lástima inó̱n ta̱gaꞌ yej yawi ne̱ne̱xti̱ti iga mane̱ki̱tzki̱ka̱n. ¡Má̱j ye̱kti katka iga inó̱n ta̱gaꞌ amo maki‑onolti̱ka̱n! ");
INSERT INTO nhx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iwá̱n Judas, yej yawi tane̱xti̱ti, kijtoj: —Tamachtia̱ni, ¿ix nejya a̱n? Jesús kijlij: —Kena, tejya nokta. ");
INSERT INTO nhx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mie̱j takuajtoyaj, Jesús kikuiꞌ pa̱n, kimáꞌ gracias Dios, iwá̱n kua̱ꞌ kita̱tajkóloja, kimajmáꞌ idisci̱polojmej, kijtoj: —Xikua̱ka̱n iní̱n pa̱n, ini̱nwaꞌ nocue̱rpoj. ");
INSERT INTO nhx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Iwá̱n kikuiꞌ se̱ vaso yej kipiá vino, kimáꞌ gracias Dios iwá̱n sejsé̱ sejsé̱ kimakatiajkij idisci̱polojmej, kijlijkej: —Xikoni̱ka̱n amonochi̱n, ");
INSERT INTO nhx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","iga ini̱nwaꞌ noesyo yej kijto̱jneki iga nikchi̱wa seꞌya pacto, iga nia niktoya̱wati noesyo iga miaꞌ mamoperdona̱ro yej kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Eꞌ nimitzijliáj iga ayoꞌ má̱j nikoni̱j iní̱mbapa uva iya̱yo este kua̱ꞌ tiksen‑oni̱skej nuevo vino ka̱n Dios reina̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kua̱ꞌ tamiꞌ kitakui̱kilijkej Dios, yajkij ipan se̱ tepe̱ꞌ yej ito̱ka̱ꞌ Olivos. ");
INSERT INTO nhx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Iwá̱n Jesús kijtoj: —Amejeme̱n amonochi̱n iní̱n yówal ankikajte̱waskej iga anmoconfia̱rowaj ipan nej; iga ijkí̱n ijkuilijtoꞌ: “Nikmikti̱j ite̱ko borre̱gojmej iwá̱n borre̱gojmej pa̱payi̱niskej.” ");
INSERT INTO nhx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Eꞌ kua̱ꞌ ni‑ojpa‑isas sej, kua̱ꞌ anya̱skej Galilea, nej achto nia̱ti. ");
INSERT INTO nhx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Iwá̱n Pedro kijtoj: —Malej iga inochi̱n mamitzsenkokajte̱waka̱n, eꞌ nej ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús kijlij: —Nej nimitzijliá iga iní̱n yówal kua̱ꞌ aya takui̱ka ka̱yo, tia tikijto̱ti e̱yi ve̱j iga ayá̱ꞌ tine‑i̱xmati. ");
INSERT INTO nhx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pedro kijtoj: —Malej iga matisenmikika̱n, nej ayá̱ꞌ nikito̱j iga ayá̱ꞌ nimitzi̱xmati. Iwá̱n nochi idisci̱polojmej ijko̱nsan no̱ kijtojkej. ");
INSERT INTO nhx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Iwá̱n Jesús asito iwá̱n idisci̱polojmej ka̱n kijliáj Getsemaní. Ompa kijlij idisci̱polojmej: —Nijoꞌ ximota̱li̱ka̱n, nej maniaoꞌ nepa, manitajto̱ti wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jesús kikuite̱waꞌ Pedro iwá̱n iyo̱mexti ipilowa̱n Zebedeo. Jesús pe̱waꞌ iga poxsan mokno̱matiꞌ iwá̱n moyo̱lmiktij. ");
INSERT INTO nhx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Iwá̱n kijtoj: —Poxsan nimokno̱mati este ken nimikisnékiya. Nijoꞌ xika̱wika̱n, xisatoka̱n nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jesús yajki achi má̱j wejkatzi̱n, iwá̱n kite̱ne̱wij Dios este motzonto̱gaꞌ ta̱lpan, ijkí̱n kijtoj: —NoTaj, siga wel mochi̱was, xine̱ma̱nawi iga amo mane̱mikti̱ka̱n; eꞌ amo mamochi̱wa ken nej nikneki, mamochi̱wa ken tej tikneki. ");
INSERT INTO nhx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesús yajki sej ka̱n onoꞌ idisci̱polojmej iwá̱n kasitoj kojkochtokej; iwá̱n kijlij Pedro: —¿Ix ni alí̱n awel an‑isatoj nowa̱n malej se̱ hora? ");
INSERT INTO nhx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xijisatoka̱n iwá̱n xi‑ora̱do̱ka̱n iga amo mamitzta̱nili̱ka̱n Tzitzimiꞌ. Ipan amoa̱lmajmej ankiyo̱lmakatokej iga ankichi̱waj yej ye̱kti, eꞌ amogá̱najsan awel ankichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesús sej ora̱do̱to, iwá̱n ijkí̱n kitajtanilij Dios: —NoTaj, siga ayꞌ wel tejte‑oꞌ mochi̱wa iga amo mane̱mikti̱ka̱n, mamochi̱wa ken tej tikneki. ");
INSERT INTO nhx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Kua̱ꞌ mokuepaꞌ sej Jesús, kasikoj idisci̱polojmej kojkochtokej iga poxsan kochisnekiáj. ");
INSERT INTO nhx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Iwá̱n kikajtej sej idisci̱polojmej iga yajki sej ora̱do̱to, inó̱n ve̱jwaꞌ e̱yi ve̱ja iga yawi ora̱do̱ti, iwá̱n ijko̱nsan sej kijtoj. ");
INSERT INTO nhx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Iwá̱n yajki sej ka̱n onoꞌ idisci̱polojmej, iwá̱n kijlijkej: —¿Ix ankojkochtókejoꞌ? ¿Nemi anmose̱wiáj? Wí̱tzeja yej kitekichijtokej yej aye̱kti iga yawij ne̱ki̱tzki̱tij, nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ximoketzáka̱nya, tiáka̱nya; wi̱ꞌya yej ne̱ne̱xtiá. ");
INSERT INTO nhx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús ta̱tapojtóyaoꞌ iwá̱n idisci̱polojmej, kua̱ꞌ asiko Judas, se̱ de ino̱mej doce idiscí̱poloj Jesús. Asiko iwá̱n miaꞌ yej kitokatiwi̱tziáj. Kiwajligayaj espada iwá̱n kuawiꞌ, ini̱mej kiti̱tan sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ijkí̱n kijtoj Judas kua̱ꞌ aya kine̱xtiá katiá in Jesús: —Yej ankitaskej nikpipitzo̱j, ino̱nya nokta xiki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Iwá̱n Judas kitechoj Jesús, iwá̱n kijlij: —¿Kén tikmati, noTamachtia̱ni? Iwá̱n kipipitzoj. ");
INSERT INTO nhx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús kijlij: —Ej, in tej ¿té̱ tikuiko? Iwá̱n kisempo̱lójkeja in Jesús iga kiki̱tzkijkej, iwá̱n kiwi̱gákeja preso. ");
INSERT INTO nhx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Eꞌ se̱ yej nemiá iwá̱n Jesús, kiki̱xtij iyespa̱daj, iwá̱n kinagasteguiꞌ se̱ yej imó̱nsojpa ije̱fej sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Iwá̱n Jesús kijtoj: —Xike̱na moespa̱daj ipan ikajlo̱ꞌ, iga nochi yej tamiktiáj iga espada, yawij no̱ kimikti̱tij iga espada. ");
INSERT INTO nhx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ix atikmati iga nej wel katka niktajtaniliá noTaj más de setenta y dos mil a̱ngelejmej iga mane̱ma̱nawi̱ka̱n? ");
INSERT INTO nhx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Eꞌ siga ijkó̱n, ¿kéntaj mochi̱was ken ijkuilijtoꞌ? Inó̱n iga ye̱kti mamochi̱wa kensan kijtowa itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iwá̱n Jesús kijlij ino̱mej gente: —¿Ix anwa̱lkej anne̱kuikoj ken kua̱ꞌ se̱ yej tachteꞌ? ¿Ix inó̱n iga ankiwajligakej espada iwá̱n kuawiꞌ? Nej nochipa nimota̱lia̱ya amowa̱n iga nitamachtijtoya weyitio̱pan, iwá̱n ayí̱ꞌ anne̱ki̱tzkijkej. ");
INSERT INTO nhx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Nochi iní̱n nemi panowa iga mamochi̱wa ken kijkuilojkej profe̱tajmej ipan itájto̱l Dios. Iwá̱n nochi disci̱polojmej kikajtejkej ise̱lti Jesús, iwá̱n chojcholojkej. ");
INSERT INTO nhx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iwá̱n kiwi̱gakej Jesús iyi̱xtaj Caifás yej ije̱fej sacerdo̱tejmej. Ompa no̱ onoyaj yej tamachtiáj ipan la ley iwá̱n yej kimanda̱rowaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Eꞌ Pedro kiwejkatokatiajki Jesús este que asiꞌ ipan ipa̱tioj ije̱fej sacerdo̱tejmej, ompa kalaꞌ iwá̱n mota̱lij wa̱n policiyajmej iga makita té̱ kichi̱wili̱skej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Iwá̱n ije̱fejmej sacerdo̱tejmej iwá̱n nochi yej kimanda̱rowaj judiyojmej, kite̱mowilia̱yaj Jesús tejté̱ yej aye̱kti kichij ka̱nsan makipanti̱ka̱n iga wel makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eꞌ akasilijkej nité̱ yej aye̱kti, malej iga miaꞌ kiyokapantia̱yaj Jesús. Iwá̱n wa̱lkej o̱me̱n yej tayokapantiáj, ");
INSERT INTO nhx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","kijtojkej: —Iní̱n ta̱gaꞌ kijtoj: “Nej wel nikxi̱xiti̱na iweyitio̱pan Dios, iwá̱n e̱yi día ne̱wiguiliá iga sej manikojpachi̱wa.” ");
INSERT INTO nhx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Iwá̱n ije̱fej sacerdo̱tejmej, moketzaꞌ, iwá̱n kijlij Jesús: —¿Aya̱ꞌtaj titajtowa achi? ¿Ix ayá̱ꞌ tikaki iga nemi mitzte̱lwiáj? ");
INSERT INTO nhx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Eꞌ Jesús atajtoj. Iwá̱n ije̱fej sacerdo̱tejmej, kijtoj: —Nej nimitztajtani ipan ito̱ka̱ꞌ Dios yej isatoꞌ iga xine̱nojma‑ijli̱ka̱n siga tejya nokta Cristo yej iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús kijtoj: —Ijkó̱n ken tej tikitoj. Iwá̱n nimitzijliáj iga anyawij anne‑itatij iga nej yej iPiltzi̱n Ta̱gaꞌ ni‑e̱watos ila̱doj iye̱ꞌma̱ꞌ Dios yej nochi wel kichi̱wa, iwá̱n anne‑itaskej kua̱ꞌ nemi niwi̱ꞌ ipan mixti cie̱lojkóbapa. ");
INSERT INTO nhx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Íkua̱ꞌya ije̱fej sacerdo̱tejmej, kitza̱tzaya̱n itzótzol iga kuejkuesiwiꞌ, iwá̱n kijtoj: —Iní̱n ta̱gaꞌ kima̱lijlij Dios. Ayꞌya tiknekij má̱j agaj tejté̱ makijto ico̱ntraj Jesús, némiya tikakij iga kima̱lijliá Dios. ");
INSERT INTO nhx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Kén ankijtowaj amejeme̱n? Yejemej kijtojkej: —¡Kichij yej aye̱kti, kajasi iga mamomikti! ");
INSERT INTO nhx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Íkua̱ꞌya kixa̱ygachijchakej iwá̱n kimagakej. Sekin kixa̱ygatatzi̱nakej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Kijlia̱yaj: —Tej Cristo, ¡siga tiprofe̱taj, taꞌ xikijto a̱ꞌyéj mitzmagaꞌ! ");
INSERT INTO nhx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mie̱j Pedro e̱watoya fuera ipan patio, se̱ isirvie̱ntaj Caifás kitechoj iwá̱n kijlij: —¡Tej no̱ tinemiá iwá̱n Jesús yej de Galilea! ");
INSERT INTO nhx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Eꞌ Pedro iyi̱xtaj nochi yej ompa onoyaj kijtoj iga ayá̱ꞌ ki̱xmati Jesús, kijtoj: —Ayá̱ꞌ nikmati de te̱ nemi titajtowa. ");
INSERT INTO nhx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pedro ki̱stia̱ya ipan ipue̱rtajyo patio iwá̱n seꞌ sirvienta kitaꞌ, kijlij yej ompa onoyaj: —Iní̱n ta̱gaꞌ no̱ nemiá iwá̱n Jesús yej de Nazaret. ");
INSERT INTO nhx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Iwá̱n Pedro sej kijtoj iga aki̱xmati, este kito̱ka̱wij Dios iga ijkó̱n nokta, kijtoj: —Ayá̱ꞌ niki̱xmati in inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Eꞌ aya wejkatiꞌ, yej ompa onoyaj kitechojkej Pedro iwá̱n kijlijkej: —Mataj tejwaꞌ no̱ de yejéme̱mpa iga tikakij ipan sanmotájto̱l. ");
INSERT INTO nhx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pedro kijtojte̱waꞌ: —Ayá̱ꞌ niki̱xmati in inó̱n Ta̱gaꞌ. ¡Dios mane‑ikno̱chi̱wa siga nemi nimitzkajkaya̱waj! Iwá̱n íkua̱ꞌya takui̱ktiki̱saꞌ se̱ ka̱yo. ");
INSERT INTO nhx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Iwá̱n Pedro kejla̱n yej kijtoj Jesús: “Kua̱ꞌ aya takui̱ka ka̱yo, tia tikijto̱ti e̱yi ve̱j iga ayá̱ꞌ tine‑i̱xmati.” Iwá̱n Pedro ki̱saꞌ ompa iwá̱n poxsan cho̱gaꞌ este kualo̱ꞌ iya̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kua̱ꞌ tané̱siꞌya, nochi ije̱fejmej sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej, motajto̱ltijkej ken iga yawij kimikti̱tij Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Iwá̱n kilpitiajkij iga kika̱watoj iyi̱xtaj Pilato yej gobernador romano. ");
INSERT INTO nhx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Kua̱ꞌ Judas kiné̱xtija Jesús iga makiki̱tzki̱ka̱n, iwá̱n Jesús yáwija kimikti̱tij, Judas kimachi̱lij iga pox aye̱kti kichij iwá̱n kikuepili̱toj sej in inó̱n treinta tomi̱n de plata ije̱fej sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Kijtoj Judas: —Nej nikchij yej aye̱kti iga niknamáꞌ Jesús yej ayá̱ꞌ nemi kichi̱wa yej aye̱kti iga makimikti̱ka̱n. Yejemej kijtojkej: —Inó̱n nejeme̱n ayoꞌ nikmatij, ino̱nwaꞌ tej tikmati. ");
INSERT INTO nhx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Iwá̱n Judas kitajtájkal in inó̱n tomi̱n weyitio̱pan‑ijtiꞌ, ki̱ste̱waꞌ iwá̱n yajki mopi̱pilo̱to. ");
INSERT INTO nhx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ije̱fejmej sacerdo̱tejmej, kipejpejpenkej inó̱n tomi̱n, iwá̱n kijtojkej: —Iní̱n tomi̱n awel matikaki̱ka̱n ka̱n tiknechkowaj ofre̱ndajmej, iga iní̱n ipati̱ꞌ iyesyo Jesús iga yawi mikiti. ");
INSERT INTO nhx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Iwá̱n motajto̱ltijkej iga inó̱n tomi̱n, makikuika̱n iga mamokowa ta̱jli yej ito̱ka̱ꞌ, Íta̱l yej Tekipanowa iga Sokiꞌ, ka̱n moto̱kaskej yej wejkacha̱nejkej. ");
INSERT INTO nhx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Inó̱n ta̱jli este iná̱n ito̱ka̱ꞌ Esta̱jli iga mokowaꞌ iga tomi̱n yej iga kimiktijkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ijkó̱n mochij ken kijtoj el profeta Jeremías, kua̱ꞌ kijtoj: “Kikuikej inó̱n treinta tomi̱n de plata, achó̱n ipati̱ꞌ kita̱lilijkej israeli̱tajmej, ");
INSERT INTO nhx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","iwá̱n iga inó̱n tomi̱n mokowaꞌ ta̱jli yej ito̱ka̱ꞌ, Íta̱l yej Tekipanowa iga Sokiꞌ, ijkó̱n ken ne̱tekimáꞌ toTe̱ko.” ");
INSERT INTO nhx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús kiwi̱gakej iyi̱xtaj el gobernador, iwá̱n kitajtan: —¿Ix tejya in iRre̱y judiyojmej? Jesús kijtoj: —Ijko̱nya ken tej tikijtowa. ");
INSERT INTO nhx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kua̱ꞌ ije̱fejmej sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej kite̱lwia̱yaj Jesús, Jesús até̱ kijtoj. ");
INSERT INTO nhx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Iwá̱n Pilato kijlij Jesús: —¿Ix atikaki nochi yej nemi mitzte̱lwiáj? ");
INSERT INTO nhx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Eꞌ Jesús ayá̱ꞌ kijtoj nité̱ nokta iwá̱n in gobernador poxsan madmira̱doj. ");
INSERT INTO nhx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ipan iyilwiyo la Pascua el gobernador kitekimajka̱waya se̱ preso, san katiá kijto̱skej la gente. ");
INSERT INTO nhx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ompa onoya se̱ preso yej inochi ki̱xmatiá iga kichi̱wa yej aye̱kti, ito̱ka̱ꞌ Barrabás. ");
INSERT INTO nhx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kua̱ꞌ la gente nechkatokej, Pilato kijlij la gente: —¿A̱ꞌyéj ankinekij manikmajka̱wa? ¿Ix Barrabás o Jesús yej kijliáj el Cristo? ");
INSERT INTO nhx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Iga Pilato kimatiá iga kiki̱tzkijkej Jesús iga ki̱xitayaj. ");
INSERT INTO nhx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Mie̱j Pilato e̱watoya ipan iweyi‑asie̱ntoj ka̱n manda̱rowa, isiwa̱ꞌ kitati̱tanilij iga kijlij: “Amo te̱ xikchi̱wili iní̱n ta̱gaꞌ, yéj ayá̱ꞌ nemi kichi̱wa yej aye̱kti. Nej yowa̱n nikte̱miꞌ poxsan yej ajaye̱kti iga yéj.” ");
INSERT INTO nhx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Eꞌ ije̱fejmej sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej, kijlijkej la gente iga makijto̱ka̱n iga makimajka̱waka̱n Barrabás iwá̱n Jesús makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Gobernador sej tatajtan: —¿A̱ꞌyéj de iní̱n o̱me̱n ankinekij manikmajka̱wa? Yejemej kijtojkej: —Xikmajka̱wa Barrabás. ");
INSERT INTO nhx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato kitajtan la gente: —¿Te̱ ankinekij manikchi̱wili Jesús yej kito̱ka̱wiáj el Cristo? Inochimej kijtojkej: —¡Xikmikti ipan cruz! ");
INSERT INTO nhx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato kijtoj: —¿Ix te̱ kichij yej aye̱kti? Eꞌ ma̱jya tzajtzikej iga kijtojkej: —¡Xikmikti ipan cruz! ");
INSERT INTO nhx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kua̱ꞌ Pilato kitaꞌ iga ayoꞌ te̱ wel kichi̱wa iga la gente ma̱jya tzajtzikej, tatekimáꞌ iga makikui̱li̱tij a̱ꞌti iga mamoma̱pa̱ka iyi̱xtaj la gente, kijtoj: —Ayéj notechko iga mamiki iní̱n ta̱gaꞌ, yéj ayá̱ꞌ kichij yej aye̱kti, ompa amejeme̱n xikitaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Iwá̱n nochi gente kijtoj: —Nejéme̱nyawaꞌ iwá̱n nopilowa̱n manimokui̱ti̱ka̱n iga mamiki. ");
INSERT INTO nhx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iwá̱n Pilato kimajkaj Barrabás, iwá̱n tatekimáꞌ iga makimagaka̱n Jesús iwá̱n kimáꞌ la gente iga makimikti̱ka̱n ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Iwá̱n isolda̱dojmej Pilato kiwi̱gakej Jesús al palacio, iwá̱n kipo̱loj komati solda̱dojmej. ");
INSERT INTO nhx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iwá̱n kipejpetzojkej Jesús iwá̱n kajaki̱ltijkej tzótzol yej este chí̱ltiꞌsan. ");
INSERT INTO nhx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Iwá̱n kita̱lilijkej ipan itzontekon se̱ corona de witzti yej kiyawalchijkej, iwá̱n kiki̱tzkiltijkej no̱ se̱ kuawiꞌ ipan iye̱ꞌma̱ꞌ. Iwá̱n motankua̱ketzayaj iyi̱xtaj iga kaja̱wilmatikej; kijlia̱yaj: —¡Xiye̱ꞌono iRre̱y judiyojmej! ");
INSERT INTO nhx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","No̱ kichijchayaj, iwá̱n iga kuawiꞌ kikuajkua̱wi̱tekkej. ");
INSERT INTO nhx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kua̱ꞌ támiꞌya kaja̱wilmatikej, kiki̱xtilijkej sej inó̱n tzótzol yej chi̱ltiꞌ iwá̱n kajaki̱ltijkej sej yej itzótzolpa nokta. Iwá̱n kiwi̱gákeja iga kimikti̱toj ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kua̱ꞌ ki̱stiá̱yaja ipan palacio, kasikej se̱ ta̱gaꞌ yej icha̱n a̱ltepe̱ꞌ Cirene yej ito̱ka̱ꞌ Simón; yéjya kitekimakakej iga makiwi̱guili Jesús icru̱z. ");
INSERT INTO nhx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Kua̱ꞌ asikej ka̱n kito̱ka̱wiáj Gólgota, yej kijto̱jneki Ka̱n onoꞌ Kuaomiꞌ, ");
INSERT INTO nhx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ompa kimakakej Jesús iga makoni vino yej ne̱nelijtoꞌ iwá̱n yej pox chichi̱ꞌ iga amo mapoxkualo; eꞌ kua̱ꞌ Jesús, kimachi̱lij, akineꞌ konij. ");
INSERT INTO nhx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kua̱ꞌ kiclava̱rójkejya ipan cruz, solda̱dojmej kikuikej itzótzol Jesús iga kirrifa̱rojkej iga makimatika̱n aja̱ꞌyéj kikuis. Ijkó̱n kichijkej iga mamochi̱wa ken kijtoj se̱ profeta: “Kirrifa̱rojkej notzótzol iga makimatika̱n aja̱ꞌyéj kikuis.” ");
INSERT INTO nhx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Iwá̱n ómpaya motajta̱lkej iga kitztoyaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iwá̱n ikua̱pan kijkuilojkej yej kijtowa te íga kimiktijkej ipan cruz. Ijkí̱n ijkuilijtoya: “INÍ̱N JESÚS YEJ IRRE̱Y JUDIYOJMEJ.” ");
INSERT INTO nhx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Iwá̱n na̱ꞌ ka̱n kiclava̱rojkej Jesús pan cruz, no̱ kiclava̱rojkej o̱me yej tachtekij, ipan sejsé̱ icru̱z, se̱ ila̱doj iye̱ꞌma̱ꞌ, seꞌ iyo̱pochka̱mpa. ");
INSERT INTO nhx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iwá̱n yej panowa̱yaj ite̱noj Jesús, kipi̱najtia̱yaj, este kikua̱tzejtzelowilia̱yaj ");
INSERT INTO nhx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","iga kijlia̱yaj: —Tej tikijtoj iga tikxiti̱nas weyitio̱pan, iwá̱n ipan e̱yi día wel sej tikojpachi̱wa, moga̱naj ximoma̱nawi. Siga tej iPiltzi̱n Dios, xitemo ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ijko̱nsan no̱ ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan la ley iwá̱n fariseojmej iwá̱n yej kimanda̱rowaj judiyojmej, kipi̱najtia̱yaj Jesús, iwá̱n mojlia̱yaj: ");
INSERT INTO nhx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Sekin kima̱nawij, igá̱najsan awel moma̱nawiá, siga yéj iRre̱y Israel, matemo ipan cruz iga maticre̱do̱ka̱n ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yéj moconfia̱roj ipan Dios; iná̱n Dios makima̱nawi, siga melá̱ꞌ iga kineki, porque yéj kijtoj: “Nej iPiltzi̱n Dios.” ");
INSERT INTO nhx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ijko̱nsan no̱ yej tachtekkej, yej no̱ kiclava̱rojkej ipan sejsé̱ cruz, kipi̱najtijkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kua̱ꞌ asiꞌ tajkodía, no̱ya̱n ipan ta̱jli tako̱mitiáꞌ, ijkó̱n tako̱mititoya este las tres tio̱takpan. ");
INSERT INTO nhx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Iwá̱n íkua̱ꞌya Jesús tzajtziꞌ iga inochi itájpal, kijtoj: —Elí, Elí, ¿lama sabactani? —yej kijto̱jneki: TinoDio̱s, tinoDio̱s, ¿te iga tine̱kájteja? ");
INSERT INTO nhx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sekin yej ompa onoyaj kikakikej iwá̱n kijtojkej: —Taꞌ xikakika̱n, nemi kino̱tza ikyapa profeta Elías. ");
INSERT INTO nhx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Iwá̱n se̱ de yejemej motaloj iga kikuito tejté̱ yej ken ichkaꞌ, iwá̱n ka̱pachoj iga xoko̱ꞌvi̱noj, kita̱lij ipan se̱ weyaꞌojtaꞌ iga kitecho̱ltijkej iga makichichi̱na. ");
INSERT INTO nhx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Eꞌ sekin kijtojkej: —Xikajte̱wa, matikitaka̱n siga wi̱ꞌ in Elías iga kima̱nawi̱ki. ");
INSERT INTO nhx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús sej tzájtziꞌpa iga tajtoj, iwá̱n míguiꞌya. ");
INSERT INTO nhx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Íkua̱ꞌya tzótzol yej iga tajkotzaktoya weyitio̱pan, tajkotzaya̱niꞌ, pe̱waꞌ ajko iwá̱n tzaya̱ntiwa̱laj este tani. Mojo̱li̱n ta̱jli iwá̱n este xa̱xama̱niꞌ temej. ");
INSERT INTO nhx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Iwá̱n a̱nimajxapomej tajtapowikej; iwá̱n miaꞌ yej miktokej, yej kicre̱dojkej Dios, ojojpa‑isakej. ");
INSERT INTO nhx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ini̱mej kijki̱skej a̱nimajxapoko kua̱ꞌ Jesús ojpa‑ísaꞌya, iwá̱n yajkij ipan weyi‑a̱ltepe̱ꞌ Jerusalén, iwá̱n ompa miaꞌ kitakej. ");
INSERT INTO nhx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ije̱fej solda̱dojmej iwá̱n yej íwa̱n kicuida̱rojtoyaj Jesús, kua̱ꞌ kitakej mo̱li̱n ta̱jli iwá̱n nochi yej mochij, poxsan majmawikej iwá̱n kijtojkej: —Mataj melá̱ꞌ iní̱n ta̱gaꞌ iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ompa onoyaj miaꞌ siwa̱tkej yej wéjkasan tajtachi̱xtoyaj yej kipale̱wijtinemiáj Jesús iwá̱n kitokakej desde Galilea. ");
INSERT INTO nhx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","No̱ ompa onoya María Magdalena, María yej íye̱ꞌpa Jacobo iwá̱n José, iwá̱n iye̱ꞌ yej ipilówa̱mpa Zebedeo. ");
INSERT INTO nhx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kua̱ꞌ némiya tayowati, wa̱laj se̱ ta̱gaꞌ yej motapialiá yej ito̱ka̱ꞌ José, yej icha̱n a̱ltepe̱ꞌ Arimatea, yéj no̱ idiscí̱poloj katka Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Iní̱n ta̱gaꞌ yajki kitato Pilato iwá̱n kitajtanilij icue̱rpoj Jesús iga makito̱ka; iwá̱n Pilato tatekimáꞌ iga makimakaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José kikuiꞌ icue̱rpoj Jesús, kiki̱kimiloj iga se̱ sábana yej ejtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Iwá̱n kito̱kato ipan se̱ a̱nimajtexapoꞌ yej kichi̱wilíjkejoꞌ José. Kua̱ꞌ kite̱ntzákuaꞌya a̱nimajxapoꞌ iga se̱ weyiyawalteꞌti, yájkiya. ");
INSERT INTO nhx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ompa onoya María Magdalena iwá̱n seꞌ María, eje̱watoyaj ite̱noj a̱nimajxapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ipan seꞌya día, día kua̱ꞌ mose̱wilo, ije̱fejmej sacerdo̱tejmej iwá̱n fariseojmej monechkojkej iga yajkij kitatoj Pilato, ");
INSERT INTO nhx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kijli̱toj: —Tekiwaj, nejeme̱n nikejla̱mikij iga inó̱n yej takajkaya̱wa, kua̱ꞌ aya miki, kijtoj iga kua̱ꞌ kipiaya e̱yi días iga miktoꞌ, yawi sej ojpa‑isati. ");
INSERT INTO nhx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Inó̱n iga xitatekimaka iga makicuida̱ro̱tij ka̱n moto̱gaꞌ e̱yi día, amo santá̱ꞌ ya̱skej idisci̱polojmej iwá̱n kiki̱xti̱skej icue̱rpoj iwá̱n kijto̱skej: “Ojpa‑ísaꞌya ka̱n miktoya.” Ijkó̱n ma̱jya sej takajkaya̱waskej que achto. ");
INSERT INTO nhx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato kijtoj: —Nigaj onoꞌ solda̱dojmej iga matacuida̱ro̱tij. Xa̱ka̱n iwá̱n xikitaka̱n iga maye̱ꞌtzakto a̱nimajxapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iwá̱n yajkij iwá̱n kiye̱ꞌtzakkej a̱nimajxapoꞌ, kita̱lilijkej se̱ sello inó̱n teꞌti yej kite̱ntzaktoꞌ a̱nimajxapoꞌ, iwá̱n ompa kikajtejkej solda̱dojmej iga matacuida̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kua̱ꞌ pánoja día iga mose̱wilo, kua̱ꞌ tane̱stíwi̱ꞌya sej ipan domingo, María Magdalena iwá̱n seꞌ María, yajkij kitatoj ka̱n moto̱gaꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Iwá̱n poxsan mo̱li̱n ta̱jli iga wa̱laj ipan cielo se̱ iyá̱ngel Dios este ka̱n to̱ktoꞌ Jesús. Iwá̱n ke̱naꞌ weyiteꞌti yej iga te̱ntzaktoya a̱nimajtexapoꞌ, iwá̱n mota̱lij ipan inó̱n weyiteꞌti. ");
INSERT INTO nhx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Inó̱n ángel peta̱niá ken tikita kua̱ꞌ tapeta̱ni, iwá̱n itzótzol este ichkatiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Kua̱ꞌ solda̱dojmej inó̱n kitakej kuekuechkakej iga majmawikej iwá̱n wetzikej, kajkej ken tikita yej miktokej. ");
INSERT INTO nhx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","El ángel kijlij siwa̱tkej: —Amo ximajmawika̱n. Nej nikmati iga ankite̱mowaj Jesús, yej kimiktijkej ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ayá̱ꞌ nigaj onoꞌ, yejwaꞌ ojpa‑ísaꞌya, kensan kijtoj. Iná̱n xikitakij ka̱n kita̱lkaj. ");
INSERT INTO nhx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Iwá̱n xá̱ka̱nya semi, xikmati̱lti̱ka̱n idisci̱polojmej: “Yéj miktoyay, eꞌ ojpa‑ísaꞌya sej, iwá̱n yéj yawi asiti achto Galilea que amejeme̱n, iwá̱n ompígaya ankitaskej.” Inó̱n yej niwa̱laj nimitzmati̱lti̱koj. ");
INSERT INTO nhx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Iwá̱n siwa̱tkej ki̱skej a̱nimajtexapoko, malej majmawikej, eꞌ yejemej pa̱ktia̱yaj iga kijli̱toj idisci̱polojmej nochi yej kitakej. ");
INSERT INTO nhx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Iwá̱n Jesús mi̱xne̱xtij iyi̱xtajmej siwa̱tkej iwá̱n kisaluda̱rojkej. Yejeme̱n kitechojkej Jesús, iwá̱n kiweyimati̱ltijkej este kijikxina̱palojkej. ");
INSERT INTO nhx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús kijtoj: —Amo ximajmawika̱n. Xa̱ka̱n xikijli̱tij nokni̱mej iga maya̱ka̱n Galilea, iwá̱n ompígaya ne‑itaskej. ");
INSERT INTO nhx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mie̱j ini̱mej siwa̱tkej nemi yawij, sekin solda̱dojmej yej tacuida̱rojtoyaj, yajkij ipan a̱ltepe̱ꞌ, iwá̱n kipowilijkej ije̱fejmej sacerdo̱tejmej nochi yej mochij. ");
INSERT INTO nhx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ini̱mej ije̱fej sacerdo̱tejmej yajkij tajto̱toj wa̱n yej kimanda̱rowaj judiyojmej iga motajto̱ltijkej iwá̱n kimakakej komati tomi̱n solda̱dojmej, ");
INSERT INTO nhx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kijlijkej ijkí̱n: —Amejeme̱n xikijto̱ka̱n iga tayowaka̱n, mie̱j ankochtoyaj, wa̱lkej idisci̱polojmej Jesús iwá̱n kichtekkej icue̱rpoj. ");
INSERT INTO nhx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Siga el gobernador makimati nochi iní̱n, nejeme̱n niawij nikyo̱lyama̱natij, iwá̱n até̱ mitzchi̱wili̱skej. ");
INSERT INTO nhx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Iwá̱n solda̱dojmej kikuikej inó̱n tomi̱n, iwá̱n kichijkej ken kijlijkej. Iwá̱n ijkó̱n kipowaj judiyojmej este iná̱n. ");
INSERT INTO nhx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ijkó̱n iga inó̱n once apo̱stolejmej yajkij Galilea, ipan tepe̱ꞌ ka̱n Jesús kijtoj iga maya̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kua̱ꞌ kitakej Jesús, kiweyimati̱ltijkej; malej iga sekin ayá̱ꞌ kitawelcre̱dowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús kitechoj idisci̱polojmej, iwá̱n kijtoj: —Iná̱n Dios kichij iga wel manirreina̱ro ipan cielo iwá̱n nigaj ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Xa̱ka̱n no̱ya̱n kajká̱n onolo̱ꞌ ipan nochi pai̱smej iwá̱n xikne̱xtili̱ka̱n ino̱mej gente iga mane̱tokaka̱n; xikbautiza̱ro̱ka̱n ipan ito̱ka̱ꞌ toTaj, ipan ito̱ka̱ꞌ te̱Piltzi̱n iwá̱n ipan ito̱ka̱ꞌ el Espíritu Santo, ");
INSERT INTO nhx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","iwá̱n xikne̱xtilí̱ka̱nya iga makichi̱waka̱n nochi yej nimitzijlijkej. Iwá̱n xikmatika̱n iga nej nonoꞌ amowa̱n nochipa, este kua̱ꞌ tamis iní̱n ta̱jli. Ijkó̱nyawaꞌ.");
INSERT INTO nhx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ijkí̱n pe̱wa ye̱ꞌnoti̱ciaj de Jesucristo, yej Dio̱spa iPiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ikya profeta Isaías ijkí̱n kijkuiloj ken Dios kijlij: Taꞌ xikaki, nikti̱tanis se̱ notati̱tan mie̱j tej aya nimitzti̱tani, iga tayaka̱nas iga mata‑ijli̱ti iga mamoprepara̱dojtoka̱n iga tiwi̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mokaki itájto̱l inó̱n tati̱ta̱n, tajtowa recio ipan desierto. Kijtowa: “Xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti, ijkó̱n ankitapowaj ojti iga toTe̱ko.” ");
INSERT INTO nhx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ijkó̱n Juan tabautiza̱rowa̱ya ipan desierto iwá̱n kijlij iga nochi makikajte̱wáka̱nya iga kichi̱waj yej aye̱kti, iwá̱n mamobautiza̱ro̱ka̱n; ijkó̱n Dios makiperdona̱rowili̱ka̱n yej kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nochi yej cha̱ntitokej ipan estado de Judea, iwá̱n yej cha̱ntitokej Jerusalén, ya̱yaj kikakitij Juan itájto̱l. Iwá̱n kua̱ꞌ la gente mote̱nxitónkeja iga kichijkej yej aye̱kti, íkua̱ꞌya Juan kibautiza̱rowa̱ya ino̱mej ipan we̱ya̱ꞌ Jordán. ");
INSERT INTO nhx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan kakijtinemiá itzótzol yej chijtoya iga itzojmiyo camello, iwá̱n tajko‑ilpitinemiá iga kuetax, iwá̱n kikua̱ya chapolin iwá̱n kuayojnekti. ");
INSERT INTO nhx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Iwá̱n Juan ijkí̱n tata̱tapo̱wia̱ya: —Ne̱tokatiwi̱ꞌ se̱ yej má̱j tayaka̱ntoꞌ que nej, yej ni alí̱n aneajasi iga manikxitomili igaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iwá̱n nej iná̱n nimitzbautiza̱rojkej iga a̱ꞌti, eꞌ yéj yawi mitzbautiza̱ro̱tij iga el Espíritu Santo. ");
INSERT INTO nhx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ino̱mej día, Jesús ki̱saꞌ ipan iya̱ltepe̱ꞌ ka̱n ícha̱n katka; inó̱n a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Nazaret, yej onoꞌ ipan íta̱l Galilea. Iwá̱n Juan kibautiza̱roj Jesús ipan we̱ya̱ꞌ Jordán. ");
INSERT INTO nhx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iwá̱n kua̱ꞌ ki̱stia̱ya ipan a̱ꞌti, Jesús kitaꞌ iga tapowiꞌ cielo, iwá̱n temoj ipan yéj iyEspí̱ritoj Dios ken se̱ jojtoko. ");
INSERT INTO nhx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Iwá̱n mokaguiꞌ itájto̱l Dios; kijtoj: —Tej nokta tinoPiltzi̱n yej nimitzpoxcho̱kiliá. Tej tine̱yo̱lchikajtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kua̱ꞌ Jesús mobautizá̱roja, iyEspí̱ritoj Dios kiwi̱gaꞌ ipan desierto ka̱n ayá̱ꞌ cha̱ntitolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ompiga Jesús onoya cuarenta días iwá̱n anima̱lmej; iwá̱n wa̱laj Tzitzimiꞌ iga katka makichi̱walti yej aye̱kti; iwá̱n wa̱lkej a̱ngelejmej iga kipale̱wi̱koj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kua̱ꞌ el gobernador kipre̱sójwija Juan, Jesús yajki ipan estado de Galilea, kipowato ye̱ꞌnoti̱ciaj kén iga Dios te̱ma̱nawiá. ");
INSERT INTO nhx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ijkí̱n kijtowa̱ya Jesús: —A̱n sí ásiꞌya yej mochi̱xtoya, iwá̱n iná̱n ayoꞌ wejkatis iga yawi reina̱ro̱ti Dios. Ayꞌya má̱j xikchi̱waka̱n yej aye̱kti, iwá̱n xicre̱dó̱ka̱nya ye̱ꞌnoti̱ciaj. ");
INSERT INTO nhx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús nejnentia̱ya ipan a̱te̱n laguna yej ito̱ka̱ꞌ Galilea. Ompa kitaꞌ Simón iwá̱n Andrés yej iyíkni̱mpa. Yejeme̱n atarraye̱rojmej. Iwá̱n ompa atarraya̱rojtoyaj ipan inó̱n a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iwá̱n Jesús kijtoj: —Xine̱tokaka̱n, iwá̱n nikchi̱was iga ankinechko̱skej yej mane̱tokaka̱n, ken iná̱n to̱poj ankiki̱tzkiáj. ");
INSERT INTO nhx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iwá̱n íkua̱ꞌsan kikajtejkej iyatarra̱yajmej, iwá̱n kitokákeja Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Iwá̱n Jesús achi má̱j nejnen, kitaꞌ ompa onokej Jacobo iwá̱n Juan yej ipilówa̱mpa Zebedeo. Onoyaj ipan á̱ka̱l, kitamanijtoyaj iyatarra̱yajmej. ");
INSERT INTO nhx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iwá̱n Jesús kino̱tzaꞌ ino̱mej. Iwá̱n yejemej kikajtejkej Zebedeo yej itájmejpa iwá̱n imo̱nsojmej ipan á̱ka̱l. Kitokákeja Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Asitoj ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Capernaum. Iwá̱n kua̱ꞌ asiꞌ día kua̱ꞌ mose̱wilo, Jesús kalaꞌ tio̱pan iwá̱n pe̱waꞌ tamachtij. ");
INSERT INTO nhx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Eꞌ madmira̱dojkej kén iga tajtowa, porque Jesús kua̱ꞌ tamachtia̱ya ne̱siá iga kimati te̱ nemi kijtowa, ayéj ken yej tamachtiáj ipan iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tio̱pan‑ijtiꞌ onoya se̱ ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj, iwá̱n tzajtzite̱waꞌ; kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Té anne̱chi̱wili̱koj Jesús de Nazaret? ¿Ix tiwa̱laj iga anne̱polo̱koj? Nej nimitzi̱xmati, iwá̱n nikmati iga tej nokta yej Dios mitztapejpen. ");
INSERT INTO nhx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iwá̱n Jesús kajajwaꞌ inó̱n ma̱lespí̱ritoj, kijlij: —¡Ayoꞌ xitzajtzito! ¡Xikajte̱wa iní̱n ta̱gaꞌ! ");
INSERT INTO nhx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Iwá̱n inó̱n ma̱lespí̱ritoj kikuekuechkaltij inó̱n ta̱gaꞌ, iwá̱n tzajtzitiki̱saꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Iwá̱n nochi majmawikej poxsan, iwá̱n mosepantajtankej: —¿Té̱taj i̱n? ¿Té̱ yejtaj in iní̱n yej nemo̱ꞌ te̱ne̱xtiliá? ¡Ini̱nya sí ta̱gaꞌ wel kitekimaka ma̱lespi̱ritojmej iwá̱n kicre̱dowaj! ");
INSERT INTO nhx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Iwá̱n nimaní̱n no̱ya̱n momatiꞌ ipan estado de Galilea yej Jesús kichij. ");
INSERT INTO nhx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kua̱ꞌ Jesús ki̱saꞌ tio̱pan, yajki iwá̱n Jacobo iwá̱n Juan; asitoj icha̱n Simón ka̱n icha̱n no̱ Andrés. ");
INSERT INTO nhx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Eꞌ imona̱n Simón wetztoya iga kawa̱ntoꞌ, iwá̱n kijlijkej Jesús iga we̱titoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iwá̱n Jesús kitechoj, iwá̱n kima̱kí̱tzkijpa iga kiketzaꞌ, iwá̱n íkua̱ꞌsan imona̱n Pedro se̱wiꞌ ikajlo̱ꞌ iwá̱n pe̱wa tatamáꞌ. Kitamáꞌ Jesús iwá̱n yej íwa̱n nemiáj. ");
INSERT INTO nhx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kua̱ꞌ kálaꞌya to̱nati̱ꞌ, iwá̱n némiya tako̱miti kiwajwaliguilijkej Jesús nochi yej se̱seꞌpa iga we̱titoyaj iwá̱n yej kipiayaj ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Iwá̱n nochi de inó̱n a̱ltepe̱ꞌ monechkojkej kalte̱noj. ");
INSERT INTO nhx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús kachitialtij miaꞌ yej se̱seꞌpa iga we̱titoyaj iwá̱n yej kipiayaj ma̱lespi̱ritojmej, nochi kiki̱xtilijkej. Akimakaltij iga matajto̱ka̱n ma̱lespi̱ritojmej iga kimatiáj a̱ꞌyéj in Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kua̱ꞌ tane̱stíwi̱ꞌya, eꞌ takó̱mi‑oꞌ, Jesús moketzaꞌ, iwá̱n yajki ise̱lti ora̱do̱to ka̱n ate̱lo. ");
INSERT INTO nhx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón iwá̱n yej íwa̱n nemiáj yajkij kite̱mo̱toj. ");
INSERT INTO nhx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Kua̱ꞌ kasíkeja, kijlijkej: —Nochi nemi mitzte̱mowaj. ");
INSERT INTO nhx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Eꞌ Jesús kijtoj: —Matia̱ka̱y ipan seꞌ a̱ltepe̱mej yej najna̱ꞌsan onokej iga manikpowa ye̱ꞌnoti̱ciaj no̱ ompí, iga inó̱n nokta niwa̱laj. ");
INSERT INTO nhx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iwá̱n Jesús nemiá no̱ya̱n Galilea ipan tio̱pamej yej ojonoyaj ipan a̱ltepe̱mej, kipojtinemiá itájto̱l toTe̱ko iwá̱n kiki̱xtijtinemiꞌ ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Se̱ ta̱gaꞌ yej nemi pala̱ni ikajlo̱ꞌ iga kipiaya lepra kitecho̱to Jesús, iwá̱n motankua̱ketzaꞌ iná̱ꞌ. Kijlij: —Siga tikneki wel xine̱pajti. ");
INSERT INTO nhx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús kikne̱lij, kichijchin iga ima̱ꞌ, iwá̱n kijlij: —Kena, nikneki xipajti. ");
INSERT INTO nhx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kua̱ꞌ kijtoj ijkó̱n, pájtiꞌya yej we̱titoya. ");
INSERT INTO nhx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús kijlij iga mayáwiya, iwá̱n ijkí̱n kino̱no̱tzaꞌ: ");
INSERT INTO nhx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Taꞌ xikaki, amo xikijli agaj kén iga ti‑achitiáꞌ, tej xaj ka̱n onoꞌ sacerdote iga mamitzita iwá̱n xikta̱li moofre̱ndaj iga tipájtiꞌya, kensan iley Moisés tatekimaka iga mamochi̱wa ijkó̱n. Iga nochi makimati iga tipájtiꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Eꞌ inó̱n ta̱gaꞌ yajki, pe̱waꞌ kipowaꞌ nochi yej mochij, inó̱n iga Jesús ayoꞌ mone̱xtia̱ya ipan a̱ltepe̱ꞌ, nemiá ka̱nsan ayagaj onoya, eꞌ ya̱yaj kitatij miaꞌ yej de sejséꞌ a̱ltepe̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Panoj achi días, Jesús yajki sej Capernaum. Kua̱ꞌ nó̱ya̱nya momatiꞌ iga yéj ónoꞌya kalijtiꞌ ");
INSERT INTO nhx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","monejnechko̱lo̱ꞌ este ayoꞌ kito̱tolowa̱yaj kalijtiꞌ niga kalte̱noj; iwá̱n Jesús kipojtoya itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Iwá̱n asitoj na̱wi tajta̱gaꞌ yej kiwi̱gakej se̱ ta̱gaꞌ yej awel nejnemi nokta. ");
INSERT INTO nhx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eꞌ kua̱ꞌ kitakej iga awel kalakij ka̱n onoꞌ Jesús iga poxsan onolo̱ꞌ kalijtiꞌ, tajta̱gaꞌ kixiti̱nkej alí̱n ipetayo kajli ka̱n kimatiáj iga onoꞌ Jesús, iwá̱n ompa kipi̱pilojtitemowijkej ipan itapech in inó̱n yej awel nejnemi. ");
INSERT INTO nhx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Eꞌ kua̱ꞌ Jesús kitaꞌ kén iga moconfia̱rowa̱yaj ipan yéj, kijlij yej we̱titoya: —Nopíj, nochi yej tikchij yej aye̱kti, nimitze̱lka̱wiliaya. ");
INSERT INTO nhx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Eꞌ ompa e̱watoyaj sekin yej tamachtiáj ipan iley Moisés; iwá̱n kijtojkej ipan iya̱lmajmej: ");
INSERT INTO nhx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Te iga ijkó̱n tajtowa iní̱n ta̱gaꞌ? Nemi kima̱lijliá Dios, iga ayagaj wel tae̱lka̱wiliá yej se̱ kichi̱wa yej aye̱kti, petz Dios san.” ");
INSERT INTO nhx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Eꞌ Jesús kimatiá te̱ kejla̱ntoyaj, iwá̱n kijtoj: —¿Te iga ijkó̱n ankejla̱mikij ipan amoa̱lmajmej? ");
INSERT INTO nhx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Kén má̱j wel manikijli iní̱n yej awel nejnemi? ¿Ix manikijli: “Nochi yej tikchij yej aye̱kti nimitze̱lka̱wílija”, o manikijli: “Ximoketza, xikui motapech, iwá̱n xaja”? ");
INSERT INTO nhx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","A̱n sí, nia nimitzne̱xtili̱tij iga nej yej iPiltzi̱n Ta̱gaꞌ, ipan iní̱n ta̱jli wel nike̱lka̱wiliá yej se̱ kichi̱wa yej aye̱kti. Iwá̱n Jesús kijlij yej awel nejnemi: ");
INSERT INTO nhx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Tej nimitzijliá, ximoketza, xikui motapech, iwá̱n xaja mocha̱n. ");
INSERT INTO nhx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iwá̱n inó̱n yej awel nejnemi íkua̱ꞌya moketzaꞌ, kikuiꞌ itapech, iwá̱n ki̱ste̱waꞌ iyi̱xtaj nochi yej ompa onoyaj. Iwá̱n ino̱mej san tajtachi̱xtikajkej, iwá̱n ijkí̱n kijtojkej iga kiweyimati̱ltijkej Dios: —¡Ayí̱ꞌ ijkí̱n tikitaj! ");
INSERT INTO nhx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iwá̱n Jesús yajki sej ipan lagu̱najte̱n. Iwá̱n kua̱ꞌ nochi kitatoj, Jesús kimachtij. ");
INSERT INTO nhx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kua̱ꞌ Jesús pano̱tia̱ya, kitaꞌ ka̱n e̱watoya Leví, yej ipíltzi̱mpa Alfeo iga kicobra̱rojtoya impuesto iga Roma, iwá̱n kijlij: —Xine̱toka. Iwá̱n Leví moketzaꞌ iwá̱n kitogaꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús iwá̱n idisci̱polojmej takuajkej cha̱n Leví iwá̱n miaꞌ yej kicobra̱rowa̱yaj impuesto iga gobierno iwá̱n sekin yej ayompa nemij no̱ sentakuajkej íwa̱n; iga miaꞌ yej kitokatinemiáj. ");
INSERT INTO nhx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kua̱ꞌ yej tamachtiáj ipan iley Moisés iwá̱n fariseojmej kitakej iga nemi sentakua iwá̱n ino̱mej, kijlijkej disci̱polojmej: —¿Te iga amomae̱stroj sentakua wa̱n yej kicobra̱rowa̱yaj impuestos iga Roma iwá̱n yej kichi̱waj yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kua̱ꞌ Jesús inó̱n kikaguiꞌ, kijtoj: —Yej ye̱ktitokej ayá̱ꞌ kinekij yej taachitialtiá, yej we̱titokej, kena kinekij. Nej ayá̱ꞌ niwa̱laj nikte̱mo̱ko yej ye̱ꞌnemij. Nikte̱mo̱ko yej kichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yej kitokatinemiáj Juan iwá̱n fariseojmej mayuna̱rojtoyaj, iwá̱n sekin kitajtanitoj Jesús, kijlijkej: —In yej kitokaj Juan iwá̱n fariseojmej, ¿te iga mayuna̱rowaj, iwá̱n modisci̱polojmej ayá̱ꞌ mayuna̱rowaj? ");
INSERT INTO nhx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús kijtoj: —¿Ix wel amo matakua̱ka̱n te‑ikni̱wa̱n ka̱n mona̱miktilo kua̱ꞌ chokotzi̱n yej mona̱miktiá onoꞌ iwa̱mej? Siga ompa onoꞌ chokotzi̱n, awel mamayuna̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Eꞌ yawi asítisan kua̱ꞌ kiwi̱gaskej chokotzi̱n, íkua̱ꞌ kena, mayuna̱ro̱skej. ");
INSERT INTO nhx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","’Iwá̱n ayagaj kitamaniá se̱ tzotzolsósol iga tzotzoltájkol yej mokówagoꞌ; iga yej mokówagoꞌ a̱kuis, iwá̱n má̱j weyi kitzaya̱nas tzotzolsósol. ");
INSERT INTO nhx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ipan ikyapakuetaxtekon awel no̱ moakiá vino yej kichíjkejoꞌ, iga vino yej kichíjkejoꞌ moposa̱wa iwá̱n kipoxo̱nas kuetaxtekon iwá̱n ne̱mpoliwis vino iwá̱n kuetaxtekon. Inó̱n iga, ye̱kti iga ipan kuetaxtekon yej móchijoꞌ mamoaki vino yej kichíjkejoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Se̱ día kua̱ꞌ mose̱wilo, Jesús pano̱tia̱ya mi̱lijtiꞌ, iwá̱n idisci̱polojmej pe̱ꞌ iga kitejtektiajkij trigo. ");
INSERT INTO nhx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseojmej kijtojkej: —Taꞌ xikita, ¿te iga modisci̱polojmej kichi̱waj tekipáno̱l yej aye̱kti mamochi̱wa ipan día kua̱ꞌ mose̱wilo? ");
INSERT INTO nhx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Eꞌ Jesús kijtoj: —¿Ix ayí̱ꞌ ankilee̱rojkej yej ikya kichij David iwá̱n yej íwa̱n nemiáj kua̱ꞌ cholojtinemiáj, iwá̱n maya̱nakej? ");
INSERT INTO nhx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David kalaꞌ tio̱pan, íkua̱ꞌ Abiatar katka kimanda̱rowa̱ya sacerdo̱tejmej. Iwá̱n David, kikuaj pa̱mej yej itátkipa Dios, yej wel kikua̱ya petz sacerdo̱tejmej, iwá̱n kimáꞌ no̱ yej íwa̱n nemiáj. ");
INSERT INTO nhx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iwá̱n Jesús no̱ kijtoj: —Dios achto kichij ta̱gaꞌ, después kitekimáꞌ iga mamose̱wi se̱ día; inó̱n kijto̱jneki iga ta̱gaꞌ má̱j importante que día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Nej yej iPiltzi̱n Ta̱gaꞌ wel nitatekimaka te̱ wel mamochi̱wa ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús yajki sej ipan itio̱pamej israeli̱tajmej, iwá̱n ompa onoya se̱ ta̱gaꞌ yej ma̱takua̱wayaxtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Iwá̱n kipi̱pixtoyaj Jesús iga makitaka̱n siga kachitialti̱j ipan día kua̱ꞌ mose̱wilo, ka̱nsan wel makite̱lwi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús kijlij yej ma̱takua̱wayaxtoꞌ: —Ximoketza iwá̱n xiwi̱ki tatajkoya̱n. ");
INSERT INTO nhx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jesús kitajtan yej ompa onoyaj: —¿Kén te̱ wel mochi̱wa ipan día kua̱ꞌ mose̱wilo; yej ye̱kti, o yej aye̱kti? ¿Mamoachitialti agaj o mamomikti? Eꞌ yejemej atajtojkej. ");
INSERT INTO nhx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús kitachi̱lij ino̱mej; kikuesowílijpa, iwá̱n moyo̱lmiktij iga ino̱mej yo̱ltakuaktikej. Jesús kijlij inó̱n yej ma̱takua̱wayaxtoꞌ: —Xikmela̱wa moma̱ꞌ. Iwá̱n inó̱n ta̱gaꞌ kimelaj ima̱ꞌ, iwá̱n ye̱ktiaꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Iwá̱n ino̱mej fariseojmej ki̱skej; yajkij motajto̱lti̱toj iwá̱n sekin yej kitokaj rey Herodes, iga makimikti̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iwá̱n Jesús yajki ipan lagu̱najte̱n iwá̱n idisci̱polojmej, iwá̱n kitogaꞌ komati gente de Galilea. ");
INSERT INTO nhx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kua̱ꞌ kimatikej iga Jesús kichi̱waya kuajkuantas yej ayi̱ꞌpa mo‑ita, ki̱skej gente de Judea, de Jerusalén, de Idumea, yej icha̱mej iyi̱ka̱n we̱ya̱ꞌ Jordán, de Tiro iwá̱n Sidón, iwá̱n yej najna̱ꞌsan icha̱mej iga yajkij kitatoj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Inó̱n íga Jesús kijlij idisci̱polojmej iga makite̱mowili̱ka̱n se̱ á̱ka̱l iga ompa matejkawi, iga amo makipi̱pitzko̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iga kachitialtij komati iwá̱n miaꞌ yej we̱titoyaj, este mopi̱lowa̱yaj iga kichijchimisnekiáj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kua̱ꞌ yej kipiayaj ma̱lespi̱ritojmej kitayaj Jesús, motankua̱ketzayaj iyi̱xtaj, iwá̱n tzajtziáj: —¡Tej iPiltzi̱n Dios! ");
INSERT INTO nhx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Eꞌ Jesús kitekimáꞌ iga amo nokta makijto̱ka̱n a̱ꞌyéj in yéj. ");
INSERT INTO nhx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iwá̱n Jesús tejkaj ipan se̱ tepe̱ꞌ iwá̱n ompa kino̱tzaꞌ yej yéjsan kitapejpen; iwá̱n yajkij ka̱n onoꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Iwá̱n kitapejpen doce de yejemej iga íwa̱n manemika̱n iwá̱n iga makipowaka̱n itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Iwá̱n kijlijkej iga wel mataachitialti̱ka̱n iwá̱n iga wel makiki̱xti̱ka̱n ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ijkí̱n ito̱ka̱mej inó̱n doce yej kitapejpen Jesús: Simón, yej no̱ kito̱ka̱wij Pedro; ");
INSERT INTO nhx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo iwá̱n iyikni̱n yej ito̱ka̱ꞌ Juan, yej ipilówa̱mpa Zebedeo, Jesús kijlia̱ya Boanerges, yej kijto̱jneki “tajta̱gaꞌ yej nimaní̱n kuejkuesiwij.” ");
INSERT INTO nhx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Kitapejpenkej Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo yej ipiltzi̱n Alfeo, Tadeo iwá̱n Simón yej iparti̱doj nacionalista. ");
INSERT INTO nhx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Iwá̱n Judas Iscariote, yej má̱j má̱j kinamáꞌ Jesús. Iwá̱n Jesús kalaꞌ iwá̱n idisci̱polojmej ipan se̱ kajli. ");
INSERT INTO nhx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Iwá̱n sej poxsan monechko̱lo̱ꞌ, este Jesús iwá̱n idisci̱polojmej ayoꞌ wel takua̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kua̱ꞌ kimatikej yej Jesús iparie̱ntejmej, wa̱lkej ka̱n onoꞌ iga makiwi̱gaka̱n, porque kijtowa̱yaj iga ayoꞌ ye̱ꞌtajla̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","No̱ yej tamachtiáj ipan la ley yej wa̱lkej Jerusalén, kijtojkej: —Iní̱n ta̱gaꞌ nemi wa̱n Tzitzimiꞌ yej ijé̱fejpa ma̱lespi̱ritojmej, iwá̱n iga ipode̱r Tzitzimiꞌ kiki̱xtiá ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Iwá̱n Jesús kino̱tzaꞌ la gente, iwá̱n kipowilijkej se̱ ka̱n mami̱xkui̱tilo, kijtoj: —¿Kén wel Tzitzimiꞌ makiki̱xti Tzitzimiꞌ? ");
INSERT INTO nhx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Siga se̱ país mochi̱wa o̱me grupo iga mosenkuejkuesowaj, inó̱n país awel wejka̱was. ");
INSERT INTO nhx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Iwá̱n siga se̱ familia mose̱pankuejkuesowaj, awel wejka̱was iga mase̱titoka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Siga Tzitzimiꞌ igá̱najsan kiki̱xtiá ma̱lespi̱ritojmej, yej yéjpasan itatki, awel wejka̱was, iwá̱n ompa tamis ipode̱r. ");
INSERT INTO nhx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Ayagaj wel kalaki cha̱n se̱ ta̱gaꞌ yej tajpalej iga makikui̱li yej itatki, siga ayá̱ꞌ achto kilpiá; ijkó̱n sí wel kitakuijkui̱li̱j. ");
INSERT INTO nhx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Nimitznojma‑ijliáj, iga Dios nochi wel ke̱lka̱wiliá yej kichi̱waj yej aye̱kti, iwá̱n nochi yej makijto̱ka̱n yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Eꞌ yej mama̱ltajto iga iyEspí̱ritoj Dios, ayoꞌ wel nike̱man moe̱lka̱wili̱j, nochipa Dios kejla̱mikilijtos. ");
INSERT INTO nhx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ijkó̱n kijtoj Jesús iga kijlijtoyaj iga kipiaya ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mie̱j ómpaoꞌ onoya Jesús, asiꞌ iye̱ꞌ iwá̱n iyokichikni̱wa̱n, eꞌ kajkej fuera, iwá̱n tati̱tankej iga makino̱tzatij Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Yej eje̱watoyaj iwá̱n kiyawalojtoyaj Jesús, kijtojkej: —Moye̱ꞌ iwá̱n mookichikni̱wa̱n onokej fuera iga mitzte̱mowaj. ");
INSERT INTO nhx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús kijtoj: —¿A̱ꞌyéj noye̱ꞌ iwá̱n nookichikni̱wa̱n? ");
INSERT INTO nhx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kitachi̱lij yej kiyawalojtokej, iwá̱n kijtoj: —Iní̱mejwaꞌ in noye̱ꞌ iwá̱n nokni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yej kichi̱wa ken Dios kineki, ino̱nwaꞌ in nookichikni̱n, nosiwa‑ikni̱n iwá̱n noye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús pe̱waꞌ sej tamachtij ipan lagu̱najte̱n, iwá̱n monechkoj komati gente ka̱n yéj onoya. Póxsanya katka komatimej, este Jesús tejkaj ipan se̱ weyi á̱ka̱l yej onoya ipan laguna, iwá̱n ompa mota̱lij iga tamachtij. Nochi gente onoya ipan a̱te̱n. ");
INSERT INTO nhx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Iwá̱n pe̱waꞌ tamachtij ipan miaꞌ ka̱n wel mami̱xkui̱tilo; iwá̱n kua̱ꞌ tamachtijtoya, kijtowa̱ya: ");
INSERT INTO nhx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Xikakika̱n iní̱n: Se̱ ta̱gaꞌ yajki to̱kato. ");
INSERT INTO nhx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kua̱ꞌ nemi kipa̱pata̱naltiá íyo̱l trigo, onoꞌ yej wetzitoj ipan ojti, iwá̱n wa̱lkej to̱to̱mej iwá̱n kikuajkej. ");
INSERT INTO nhx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Onoꞌ yej wetzitoj tetza̱la̱n, ka̱n onoꞌ ajalí̱n ta̱jli. Iwá̱n inó̱n íyo̱l trigo ixwaꞌ nimaní̱n iga ta̱jli ayá̱ꞌ pox tilaktiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Eꞌ kua̱ꞌ to̱natiki̱saꞌ, pili̱niꞌ, iwá̱n wa̱guiꞌ iga ayá̱ꞌ monelwatij. ");
INSERT INTO nhx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Onoꞌ yej wetzito ipan witzyoj; witzyoj wejweyakej iwá̱n kijiyo̱miktij tato̱ꞌ iwá̱n ayá̱ꞌ ta̱guiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Eꞌ onoꞌ yej wetzito ka̱n yé̱ꞌta̱l. Ixwakej iwá̱n wejweyakej, iwá̱n pox mochij. Ipan sejsé̱ imia̱wayo kita̱lilij treinta, iwá̱n sekin kita̱lilij sesenta, iwá̱n sekin kita̱lilij cien. ");
INSERT INTO nhx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesús kijtoj: —Yej annakasyojkej, xine̱ye̱ꞌkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kua̱ꞌ Jesús ká̱wiꞌya ise̱lti, yej onoyaj ite̱noj iwá̱n los doce disci̱polojmej kitajtankej te̱ kijto̱jneki o̱n ka̱n mami̱xkui̱tilo. ");
INSERT INTO nhx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús kijtoj: —Amejeme̱n Dios mitzmati̱ltiáj yej aya agaj kimati ken iga yéj reina̱rowa; eꞌ yej aya kicre̱dowaj, yej nikmachtiáj, nochi nikpowiliajpa ka̱n mami̱xkui̱ti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ijkó̱n malej iga matachaka̱n, ken tikita ayá̱ꞌ tacháj. Malej iga matakakika̱n eꞌ amo makentende̱ro̱ka̱n nité̱, iga amo mamoyo̱lpataka̱n iwá̱n iga amo make̱lka̱wili̱ka̱n yej kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Kijtoj no̱: —¿Ix ayá̱ꞌ ankentende̱rowaj in iní̱n ka̱n mi̱xkui̱tilo? ¿Kéntaj anyawij ankentende̱ro̱tij sékinoꞌ má̱j ka̱n mami̱xkui̱tilo? ");
INSERT INTO nhx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Yej to̱ka, inó̱n ken yej kipowa itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sekin ken tikita íyo̱l trigo yej wetziꞌ ipan ojti: kikakij itájto̱l Dios, eꞌ kua̱ꞌ kikakíkeja, wi̱ꞌ Tzitzimiꞌ iga ke̱lka̱walti̱kij tájto̱l yej ken kua̱ꞌ to̱ktoya ipan iya̱lmajmej. ");
INSERT INTO nhx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sekin ken íyo̱l trigo yej wetziꞌ ipan teyoj, kikakij itájto̱l Dios iwá̱n kiye̱ꞌitaj. ");
INSERT INTO nhx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Eꞌ ken kua̱ꞌ ayá̱ꞌ nelwayojkej iwá̱n ayá̱ꞌ wejka̱waj. Eꞌ kua̱ꞌ panowa yej kiyo̱lmiktiáj o kijiyaj iga ne̱tokaj, mosemákaja. ");
INSERT INTO nhx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Iwá̱n sekin ken tikita íyo̱l trigo yej xi̱niꞌ ipan witzyoj; kikakij itájto̱l Dios, ");
INSERT INTO nhx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","eꞌ kiyo̱ltila̱na nochi yej onoꞌ ipan iní̱n ta̱jli, kineki makipoxpiá tomi̱n iwá̱n ijkó̱n iga mopojpolowa, iwá̱n kuajkuantas kineki makipiá; nochi iní̱n ke̱lka̱waltiá itájto̱l Dios iwá̱n ayá̱ꞌ kichi̱wa yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Eꞌ onoꞌ sekin yej kikakij itájto̱l Dios iwá̱n kiye̱ꞌitaj iwá̱n kichi̱waj yej ye̱kti. Sekin ken íyo̱l trigo yej kimáꞌ este treinta iwá̱n sekin ken yej kimáꞌ sesenta iwá̱n sekin ken yej kimáꞌ este cien ita̱kilka. ");
INSERT INTO nhx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","No̱ kijtoj: —¿Ix mota̱liá tiꞌti itampa cajo̱n o itampa tapech? Awel, tiꞌti mota̱liá ajko iga mata̱wi. ");
INSERT INTO nhx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Puej inewi yej i̱ya̱ntoꞌ yawi mone̱xti̱ti. Iwá̱n nochi yej mo‑ichtaka‑ijtoj, yawi momatiti. ");
INSERT INTO nhx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yej annakasyojkej, xine̱ye̱ꞌkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iwá̱n no̱ kijtoj: —Xikye̱ꞌkakika̱n yej nimitzijliáj, siga ankiyo̱lmakaj, ankentende̱ro̱skej. Achó̱n ke̱ꞌ agaj ankimakaskej, acho̱nsan no̱ Dios mitzmakaskej. ");
INSERT INTO nhx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yej kipiá, yawij má̱j kimakatij; eꞌ yej akipiá, este yej alí̱n kipiá, yawij kikui̱li̱tij. ");
INSERT INTO nhx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús kijtoj no̱: —Ken iga reina̱rowa Dios, ken tikita se̱ ta̱gaꞌ yej to̱ka. ");
INSERT INTO nhx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kochi iwá̱n tane̱si moketza; á̱wil seꞌya día, yej kito̱gaꞌ ixwa iwá̱n weyá iwá̱n yéj akimati kén iga ixwaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ta̱jli kixwaltiá; achto pochi̱ni iwá̱n má̱j má̱j ki̱sa imia̱wayo iwá̱n chika̱wayay íyo̱l. ");
INSERT INTO nhx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kua̱ꞌ chika̱ꞌya ita̱kilka, kitékija iwá̱n mosasakay. ");
INSERT INTO nhx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kijtoj no̱ Jesús: —Nia nimitzpowili̱tij seꞌ ka̱n mami̱xkui̱tilo iga xikmatika̱n kén iga Dios reina̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ken tikita íyo̱l mostaza yej moto̱ka iwá̱n mochi̱wa weyikuawiꞌ, malej iga má̱j ali̱mpa de nochi semilla yej onoꞌ ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eꞌ kua̱ꞌ motó̱gaꞌya, weyá má̱j sej que nochi tato̱ꞌmej, majma̱yowi poxsan, este to̱to̱mej wel moxeketiáj ompa iga tasejka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesús tamachtia̱ya miaꞌ ka̱n mami̱xkui̱tilo, este ke̱ꞌ yejemej wel kentende̱rowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Siga ayá̱ꞌ kipowaya ka̱n mami̱xkui̱tilo, ayá̱ꞌ tamachtia̱ya; idisci̱polojmej ka̱n iyokamej kijlia̱yaj te̱ kijto̱jneki inó̱n ka̱n mami̱xkui̱tilo. ");
INSERT INTO nhx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ino̱nsan día kua̱ꞌ tayowátiꞌya, Jesús kijlij idisci̱polojmej: —Mati‑a̱pano̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Iwá̱n Jesús kikajtej la gente iwá̱n yajkij iwá̱n idisci̱polojmej ipan ino̱nsan weyi á̱ka̱l ka̱n tamachtijtoya, iwá̱n kitokatiajkij sékinoꞌ má̱j a̱ka̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Eꞌ tzi̱ntiꞌ se̱ ejekaꞌ yej pox tajpalej, iwá̱n poxsan mopa̱palakachowa̱ya a̱ꞌti este kajkalakiá ipan á̱ka̱l iwá̱n némiya a̱te̱miá. ");
INSERT INTO nhx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Eꞌ Jesús kochtia̱ya itzi̱nkopa á̱ka̱l, mokuajtetontijtia̱ya iga kuajteton. Kixitijkej iwá̱n kijlijkej: —¡Tamachtia̱ni! ¿In tej, atikita iga némiya ti‑a̱wetzij? ");
INSERT INTO nhx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús moketzaꞌ, kajajwaꞌ ejekaꞌ iwá̱n kijlij a̱ꞌti: —¡Xipachiwi! ¡Xónosan! Iwá̱n inó̱n ejekaꞌ pachiwiꞌ, iwá̱n santaka̱mpolijtika̱wiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Iwá̱n Jesús kijlij idisci̱polojmej: —¿Te iga poxsan anmajmawij? ¿Ix áyataj anmoconfia̱rowaj ipan nej? ");
INSERT INTO nhx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iwá̱n yejeme̱n poxsan majmatikajkej, iwá̱n yejéme̱nsan mose̱sepantajtaniáj: —¿A̱ꞌtaj yéj a̱n nokta in iní̱n ta̱gaꞌ yej este ejekaꞌ iwá̱n a̱ꞌti kitajto̱lkakij? ");
INSERT INTO nhx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Asikej iyi̱ka̱mpa laguna, ka̱n ito̱ka̱ꞌ Gadara. ");
INSERT INTO nhx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kua̱ꞌ Jesús temoj ipan á̱ka̱l; ki̱xna̱n se̱ ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj, iwá̱n inó̱n ta̱gaꞌ ki̱saꞌ posa̱ntoj. ");
INSERT INTO nhx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Inó̱n ta̱gaꞌ kochá ka̱n moto̱kalo iwá̱n ayagaj wel kilpia̱ya malej iga cadena. ");
INSERT INTO nhx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Miaꞌ ve̱j kilpijkaj iga cadena ipan iyikxi iwá̱n ipan imajma̱ꞌ, eꞌ yéj kiko̱koto̱naya, ayagaj nokta wel kidomina̱rowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nochipa nentinemiá; semilwiꞌ iwá̱n senyówal, tzajtzitinemiá ipan tepe̱yoj iwá̱n ka̱n moto̱kalo, igá̱najsan momagatinemiá iga teꞌti. ");
INSERT INTO nhx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eꞌ kua̱ꞌ kiwejka‑itaꞌ Jesús, motaloj iwá̱n motankua̱ketzato iyi̱xtaj. ");
INSERT INTO nhx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tzajtzité̱waꞌpa iga kijlij: —¿Té̱ tikneki nowa̱n, tej Jesús yej iPiltzi̱n Dios yej onoꞌ pox ajko? Nimitztajtaniliá iga amo xine‑ikno̱chi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ijkó̱n kijtoj iga Jesús ijkí̱n kijlijtoya: —¡Ma̱lespí̱ritoj, xiki̱sa ipan iní̱n ta̱gaꞌ! ");
INSERT INTO nhx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesús kitajtan: —¿Té̱ moto̱ka̱ꞌ? Iwá̱n kijtoj: —Noto̱ka̱ꞌ Miaꞌ, iga nipoxkomatimej. ");
INSERT INTO nhx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Iwá̱n kitekiꞌtajtanilij Jesús iga amo makiti̱tani wejka in ino̱mej ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ompiga onoya miaꞌ koyame̱mej, takuajtinemiáj ipan tepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma̱lespi̱ritojmej ijkí̱n kitekiꞌtajtanilijkej Jesús: —Xine̱ti̱tanika̱n iga manikalakika̱n ipan koyame̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesús kijlij iga maya̱ka̱n ompiga; iwá̱n ino̱mej ma̱lespi̱ritojmej kijki̱stejkej ipan ta̱gaꞌ, iwá̱n kalakitoj ipan anka dos mil koyame̱mej, iwá̱n ino̱mej momajma̱petzko̱toj ipan barranko iwá̱n wetzitoj lagu̱najijtiꞌ. Iwá̱n ompa a̱mikikej. ");
INSERT INTO nhx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yej kicuida̱rojtinemiáj koyame̱mej mo̱ka̱cholojkej iwá̱n yajkij kipowatoj ipan a̱ltepe̱ꞌ iwá̱n ipan ra̱nchojmej iwá̱n yajkij la gente kitatoj te̱ sucede̱roj. ");
INSERT INTO nhx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Kua̱ꞌ asikej ka̱n onoꞌ Jesús, kitakej inó̱n ta̱gaꞌ yej kipiaya ma̱lespi̱ritojmej, ye̱ꞌtajlá̱ntoꞌya iwá̱n este e̱watoꞌ; iwá̱n majmawikej. ");
INSERT INTO nhx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Iwá̱n ino̱mej yej kitakej, kipojkej de inó̱n ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj, iwá̱n de koyame̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Iwá̱n la gente kitekiꞌijlijkej Jesús iga makí̱saya ipan ita̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kua̱ꞌ Jesús nemi tejkawi ipan á̱ka̱l, inó̱n ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj, kitekiꞌijlij iga mayáwiya íwa̱n. ");
INSERT INTO nhx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Eꞌ Jesús ayá̱ꞌ kineꞌ, kijlij: —Xaj mocha̱n ka̱n onokej mokni̱wa̱n. Xikpowili̱ka̱n inewi yej toTe̱ko kichij iwá̱n tej, iwá̱n iga mitzikne̱lij. ");
INSERT INTO nhx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iwá̱n inó̱n ta̱gaꞌ kipowaꞌ nochi san ken iga kichij Jesús iwá̱n yéj. Kipojtinemiꞌ no̱ya̱n ipan íta̱l diez a̱ltepe̱ꞌ yej kijliáj Decápolis iwá̱n nochi kiye̱ꞌkakikej. ");
INSERT INTO nhx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kua̱ꞌ Jesús iwá̱n idisci̱polojmej a̱panojkej ipan á̱ka̱l, pox kipo̱lojkej Jesús; iwá̱n yéj ka̱ꞌ ipan a̱te̱n. ");
INSERT INTO nhx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iwá̱n asiko se̱ ta̱gaꞌ yej manda̱rowa ipan se̱ itio̱pan israeli̱tajmej. Inó̱n ta̱gaꞌ ito̱ka̱ꞌ Jairo; kua̱ꞌ yéj kitaꞌ Jesús, motankua̱ketzaꞌ iyikxite̱noj. ");
INSERT INTO nhx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Iwá̱n poxsan kitajtanilij iwá̱n kijlij: —Notaochi̱n némiya miki. Achi xaj xikta̱lili̱ti moma̱ꞌ iga maachitiá iwá̱n amo mamiki. ");
INSERT INTO nhx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iwá̱n Jesús yajki íwa̱n. Komati gente kipo̱lojtia̱ya, este mopi̱pitzkojtia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iwá̱n ompa ya̱ya no̱ se̱ siwa̱ꞌ yej we̱titoya, iga doce años ki̱stoya esti ken imé̱s yej awel pachiwiá. ");
INSERT INTO nhx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Iwá̱n miaꞌ médico, awel kipale̱wijkej, ma̱jwaꞌ kikno̱chi̱wayaj inó̱n siwa̱ꞌ, iwá̱n motatámija, eꞌ ayá̱ꞌ achitiáꞌ, ma̱jwaꞌ nemi we̱tiaya. ");
INSERT INTO nhx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Kua̱ꞌ kikaguiꞌ iga ompa nemi Jesús, inó̱n siwa̱ꞌ kitechojtiajki itepotztájbapa ka̱n po̱lijtia̱lo; iwá̱n kichijchimilij isota̱ntzótzol. ");
INSERT INTO nhx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ipan iya̱lmaj kijtowa̱ya: “Masa a̱n nikchijchimili̱j itzótzol ni‑achitiás.” ");
INSERT INTO nhx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Iwá̱n íkua̱ꞌsan pachiwiꞌ iga kitztoya ken imé̱s; iwá̱n kimachí̱lija iga melaꞌachitiaꞌya nokta. ");
INSERT INTO nhx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Iwá̱n Jesús kimatiꞌ iga ipode̱r agaj kachitialtij. Tacháꞌ itepotztajpa ka̱n po̱lijtia̱lo, iwá̱n tatajtan: —¿A̱ꞌyéj ne̱chijchimilij notzótzol? ");
INSERT INTO nhx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Idisci̱polojmej kijtojkej: —Tikita iga mitzpi̱pitzkojtiawij, iwá̱n titatajtani: “¿A̱ꞌyéj ne̱chijchin?” ");
INSERT INTO nhx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Eꞌ Jesús ta̱tacháꞌ no̱ya̱n iga makita a̱ꞌyéj in yej kichijchin. ");
INSERT INTO nhx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Inó̱n siwa̱ꞌ kuekuechkatoya iga majmatoya iga kichijchimilij itzótzol. Yajki iyi̱xtaj Jesús motankua̱ketzato, iwá̱n kinojma‑ijlij te̱ kichij. ");
INSERT INTO nhx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús kijlij: —Nopíj, iga timoconfia̱roj ipan nej, ti‑achitiaꞌya. Iná̱n xaja tamelá̱, ti‑achitiaꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mie̱j ta̱tapojtóyaoꞌ Jesús, asikej sekin yej wa̱lkej icha̱n Jairo, inó̱n yej manda̱rowa ipan se̱ tio̱pan. Kijtojkej: —¡Mosiwa̱piltzi̱n miꞌya! Ayoꞌ má̱j xikuejkueso toTamachtia̱ni. ");
INSERT INTO nhx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Eꞌ Jesús akitajto̱lkuiꞌ yej tajtojkej, iwá̱n kijlij Jairo: —Amo ximajmawi. Ximoconfia̱ro ipan nej. ");
INSERT INTO nhx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iwá̱n Jesús ayoꞌ kineꞌ iga makitoka nochi, Pé̱dro‑san, Jacobo iwá̱n Juan yej iyikni̱n Jacobo. ");
INSERT INTO nhx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kua̱ꞌ asíkeja cha̱n Jairo, Jesús kitaꞌ iga po̱po̱lijtolo̱ꞌ, pox cho̱katolo̱ꞌ iwá̱n wa̱ꞌtzajtzitolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kalaꞌ Jesús iwá̱n kijtoj: —¿Te iga poxsan an‑o̱yojtokej iwá̱n anwa̱ꞌtzajtzitokej? Iní̱n takotzi̱n ayá̱ꞌ miktoꞌ, yejwaꞌ kochtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Iwá̱n Jesús kiwejwetzkilijkej, eꞌ Jesús kikijki̱xtij inochi̱n. Kájkejsan Jesús iwá̱n yej íwa̱n senemiáj, takotzi̱n itaj iwá̱n iye̱ꞌ ka̱n mejmelajtoꞌ takotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iwá̱n Jesús kima̱ki̱tzkij takotzi̱n yej miktoꞌ iwá̱n tajtoj ipan itájto̱l, yej hebréojpa, kijtoj: —Talita, cumi —yej kijto̱jneki: Takotzi̱n, nimitzijliá iga ximoketza. ");
INSERT INTO nhx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Íkua̱ꞌsan in inó̱n takotzi̱n yej kipiaya doce años, moketzaꞌ, iwá̱n néjnenya. Iwá̱n poxsan moyo̱lmajtilo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Eꞌ Jesús tatekimáꞌ iga amo mamopowa yej mochij. No̱ tatekimáꞌ iga mamotamákaya takotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús ki̱saꞌ ompa iga mokuepaꞌ ipan íta̱l, iwá̱n kitokakej idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Kua̱ꞌ asiꞌ día kua̱ꞌ mose̱wilo, Jesús pe̱waꞌ tamachtij tio̱pan. Yej kikakiáj kén iga tamachtijtoya, san tajtachi̱xtika̱wiáj. Kijtowa̱yaj: —Iní̱n ta̱gaꞌ, ¿ka̱n momachtij iga pox tajto̱lmati? ¿A̱ꞌ ijkó̱n kine̱xtilij? ¡Pox wel kichi̱wa milagro yej ayi̱ꞌpa mo‑ita! ");
INSERT INTO nhx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ix ayejtaj el carpintero, inó̱n yej ipiltzi̱n María? Itzo̱yowa̱n ito̱ka̱ꞌ Jacobo, José, Judas iwá̱n Simón. Iwá̱n isiwa‑ikni̱wa̱n nigaj no̱ icha̱mej. Iwá̱n ayá̱ꞌ kitajto̱lkuikej. ");
INSERT INTO nhx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesús kijtoj: —Se̱ profeta nochi kitajto̱lkui̱liáj; eꞌ ipan iya̱ltepe̱ꞌ iwá̱n icha̱n ayá̱ꞌ kitajto̱lkuij niga iyikni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesús ompa awel kichij ni se̱ milagro; sékinsan kachitialtij, kita̱lílijpa ima̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Madmira̱dowa̱ya iga ino̱mej ayá̱ꞌ kicre̱dowa̱yaj. Iwá̱n Jesús tamachtijtinemiꞌ ipan a̱ltepe̱mej yej najna̱ꞌsan. ");
INSERT INTO nhx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iwá̱n Jesús kino̱tzaꞌ ino̱mej doce idisci̱polojmej. Iwá̱n pe̱ꞌ kitijti̱tan iga maya̱ka̱n ojo̱me̱n. Iwá̱n kimáꞌ poder iga wel makiki̱xti̱ka̱n ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iwá̱n kijlijkej iga amo makiwi̱gaka̱n nité̱ ipan ojti ka̱n ya̱skej, petz bastón. Kijlijkej iga amo makiwi̱gaka̱n mórra̱l, niga tákual, niga tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Iwá̱n makajakijtia̱ka̱n igakmej, iwá̱n sejse̱san ikua̱chmej, ayá̱ꞌ este ojo̱me. ");
INSERT INTO nhx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Iwá̱n kijlijkej no̱: —San ka̱n amasitij, ipan se̱ kajli ka̱n wel amonoskej, ómpaoꞌ xika̱wika̱n este matami amotekipáno̱l iwá̱n anki̱saskej ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Iwá̱n siga kanaj ayá̱ꞌ mitzo̱mema̱wiáj niga mitzkakisnekij, xiki̱saka̱n ompa, xiktzejtzelo̱ka̱n amokxita̱lpíno̱l iga makimatika̱n iga ayá̱ꞌ kichijkej yej ye̱kti. Nimitzijliáj iga ino̱mej, kua̱ꞌ Dios tajuzga̱ro̱j, yejemej má̱j kikno̱chi̱waskej que yej de Sodoma iwá̱n de Gomorra iga ayá̱ꞌ mitzo̱mema̱wijkej. ");
INSERT INTO nhx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jesús idisci̱polojmej ki̱skej iga kipojtinenkej iga la gente mamoyo̱lpata. ");
INSERT INTO nhx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Iwá̱n yejeme̱n komati kiki̱xtijkej ma̱lespi̱ritojmej, iwá̱n kikua̱pa̱tzojkej iga aceite miaꞌ yej we̱titoyaj, iwá̱n achitiakej. ");
INSERT INTO nhx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nó̱ya̱nya momatiá yej kichij Jesús, no̱ kimatiꞌ el rey Herodes, iwá̱n kijtoj: —Juan yej tabautiza̱rowa̱ya ojpa‑isaꞌ sej ka̱n miktoya, inó̱n iga wel kichi̱wa milagro yej ayí̱ꞌ mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sekin kijtowa̱yaj: —Ini̱nwaꞌ leju̱ntoj Elías. Iwá̱n sekin kijtowa̱yaj: —Ini̱nwaꞌ profeta kensan yej ikyapamej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kua̱ꞌ Herodes kikaguiꞌ iní̱n, kijtoj: —Ini̱nwaꞌ Juan yej nitatekimáꞌ iga makikechtekika̱n, iwá̱n iná̱n ojpa‑isaꞌ ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Gobernador Herodes kisiwa̱kui̱lij iyikni̱n yej ito̱ka̱ꞌ Felipe. Isiwa̱ꞌ ito̱ka̱ꞌ Herodías. Herodes tatekimáꞌ iga Juan makilpi̱ka̱n iga cadena iwá̱n makipre̱sojwi̱ka̱n, iga ");
INSERT INTO nhx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan ijkí̱n kiji̱xko‑ijlij Herodes: —Aye̱kti iga tiksiwa̱kui̱lij mokni̱n. ");
INSERT INTO nhx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías kijiyaya Juan iwá̱n kinekiá makimikti, eꞌ ayá̱ꞌ welitiaya, ");
INSERT INTO nhx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","iga Herodes kimatiá iga Juan ayá̱ꞌ nemi kichi̱wa yej aye̱kti, yéj ye̱ꞌnemiá, iwá̱n kimajmawilia̱ya, inó̱n iga ayá̱ꞌ kinekiá iga isiwa̱ꞌ makimikti Juan. Herodes kiye̱ꞌkakiá ken iga ta̱tapowaya Juan, malej iga ayá̱ꞌ kentende̱rowa̱ya inewi. ");
INSERT INTO nhx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Eꞌ Herodías kásiꞌsan ken iga yawi kimikti̱ti Juan. Kua̱ꞌ asiꞌ icu̱mpleaños Herodes, ilwichij, kitamáꞌ yejsan je̱fejmej iwá̱n comanda̱ntejmej iwá̱n yej manda̱rowaj Galilea. ");
INSERT INTO nhx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kua̱ꞌ nentoꞌ ilwiꞌ, isiwa̱piltzi̱n Herodías mijto̱tij. Iwá̱n Herodes iwá̱n yej íwa̱n sentakuajtoyaj kipoxye̱ꞌitakej ken iga mijto̱tij, iwá̱n Herodes kijlij takotzi̱n: —Xine̱tajtanili santé̱ tiknekis, iwá̱n nimitzmakas. ");
INSERT INTO nhx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Herodes kinojma‑ijtoj iga kimakas san te̱ kitajtanili̱j, malej iga makitajtani iga makimanda̱ro tajko país. ");
INSERT INTO nhx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kua̱ꞌ takotzi̱n ki̱saꞌ ompa, kijlij iye̱ꞌ: —¿Té̱ niktajtanili̱j? Iye̱ꞌ kijlij: —¡Xiktajtani itzontekon Juan yej tabautiza̱rowa! ");
INSERT INTO nhx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Takotzi̱n kalaꞌ nimaní̱n ka̱n onoya Herodes, iwá̱n kijlij: —Nikneki xine̱maka sémisan ipan se̱ plato itzontekon Juan yej tabautiza̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Iwá̱n Herodes poxsan mokno̱matiꞌ, eꞌ como kíjtoja iga nochi kichi̱was san te̱ motajtanili̱j, iwá̱n kikakikej yej ompa takuajtoyaj, inó̱n iga kichij yej kitajtanilijkej. ");
INSERT INTO nhx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Imani̱nsan el gobernador kitekimáꞌ se̱ isolda̱doj iga makiwajliguili itzontekon Juan. ");
INSERT INTO nhx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Inó̱n soldado yajki kikechtekito Juan ka̱n onoya preso. Iwá̱n kiwi̱gaꞌ itzontekon ipan se̱ pla̱tojwé̱j, kimajkui̱ltij takotzi̱n iwá̱n yéj kimakato iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kua̱ꞌ kimatikej idisci̱polojmej Juan, yajkij kikuitoj ka̱n miktoꞌ, iwá̱n yajkij kito̱katoj. ");
INSERT INTO nhx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iwá̱n apo̱stolejmej monechkojkej iwá̱n Jesús, iwá̱n kipowilijkej inewi yej kichijkej iwá̱n ken iga tamachtijkej. ");
INSERT INTO nhx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús kijlij iyapo̱stolejmej: —Xine̱tokaka̱n, matia̱ka̱n matimose̱wi̱tij ka̱n ayagaj onoꞌ. Iga miaꞌ yej asiáj iwá̱n ya̱yaj, iwá̱n wi̱tziáj má̱j, este Jesús iwá̱n idisci̱polojmej ayoꞌ kasiáj lugar iga takua̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesús iwá̱n iyapo̱stolejmej tejkajkej ipan á̱ka̱l iga yajkij ka̱n ayagaj onoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Eꞌ miaꞌ kitaꞌ kua̱ꞌ yajkij. Ki̱xmatikej iga Jesús, iwá̱n yej ichajcha̱n ipan a̱ltepe̱mej, ompiga motalojkej ka̱n yawi Jesús, iwá̱n achto yejemej asikej. ");
INSERT INTO nhx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kua̱ꞌ Jesús ki̱saꞌ ipan á̱ka̱l, kitaꞌ iga poxsan mialo̱ꞌ, iwá̱n kikne̱lij. Kitaꞌ iga yejeme̱n ken borre̱gojtzitzi̱n yej ate̱koyojkej; iwá̱n pe̱waꞌ iga kuajkuantas kimachtijkej. ");
INSERT INTO nhx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kua̱ꞌ tió̱taꞌya, idisci̱polojmej kijli̱toj Jesús: —Tió̱taꞌya iwá̱n nigaj ayagaj cha̱ntitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xikijli tokni̱mej iga maya̱ka̱n ipan a̱ltepe̱tzitzi̱n iga makikowatij te̱ kikuaj. ");
INSERT INTO nhx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Eꞌ Jesús kijtoj: —Amejeme̱n xiktamakaka̱n. Yejeme̱n kijtojkej: —¡Malej iga manikpiaka̱n ke̱ꞌ se̱ kita̱niá ocho meses, awelsan nikowaskej pa̱n iga nochi! ");
INSERT INTO nhx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús kijtoj: —¿Ke̱ski pa̱n ankipiáj? Xa̱ka̱n xikitatij. Kua̱ꞌ kimatikej, kijtojkej: —Onoꞌ se̱ mano pa̱n iwá̱n o̱me michin. ");
INSERT INTO nhx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Iwá̱n kitekimakakej iga mamota̱li̱ka̱n ipan sakatzitzi̱n; ");
INSERT INTO nhx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","iwá̱n motajta̱lkej de cien iwá̱n de cincuenta. ");
INSERT INTO nhx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesús kikuiꞌ inó̱n se̱ mano pa̱n iwá̱n inó̱n o̱me to̱poj, ajkotacháꞌ iga kimáꞌ gracias Dios. Iwá̱n kita̱tajkoloj pa̱n, iwá̱n kimajmáꞌ idisci̱polojmej iga makirreparti̱ro̱ka̱n. No̱ kirreparti̱roj michin. ");
INSERT INTO nhx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Takuajkej inochimej este ijixwikej. ");
INSERT INTO nhx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Iwá̱n disci̱polojmej kite̱mijkej doce chikiwiꞌ pa̱n iwá̱n michin yej ayꞌ mokuaj. ");
INSERT INTO nhx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yej takuajkej, cinco mil tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kua̱ꞌ támiꞌya takuajkej, Jesús kitekimáꞌ idisci̱polojmej iga matejkawíka̱nya ipan á̱ka̱l iga maa̱pano̱ka̱n achto yejeme̱n iga maya̱ka̱n se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Betsaida. Jesús tanawatijtiká̱wigoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kua̱ꞌ tanawátija, Jesús ora̱do̱to ipan tepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kua̱ꞌ tayowátiꞌya, á̱ka̱l ka̱n nemi ya̱yaj disci̱polojmej, ya̱yay tajko laguna. Iwá̱n Jesús onóyaoꞌ ka̱n ka̱wiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Kitaꞌ iga idisci̱polojmej ayoꞌ wel a̱rremia̱rowaj, iga ki̱xna̱ntiá̱yajpa ejekaꞌ. Iwá̱n kua̱ꞌ tane̱stíwi̱ꞌya, Jesús kitechoj idisci̱polojmej, nejnentia̱ya iyi̱xko a̱ꞌti; mochij iga némiya pano̱tia̱ya. ");
INSERT INTO nhx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kua̱ꞌ disci̱polojmej kitakej iga agaj nejnentiá iyi̱xko a̱ꞌti, kijtojkej anka á̱nimaj, iwá̱n tzajtzikej. ");
INSERT INTO nhx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Inochi̱n kitakej iwá̱n momajtijkej. Eꞌ Jesús imaní̱n kino̱tzkej: —¡Tamelá̱ xonoka̱n! ¡Nej Jesús, amo ximajmawika̱n! ");
INSERT INTO nhx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Iwá̱n Jesús tejkaj no̱ ipan á̱ka̱l ka̱n onokej iwá̱n pachiwiꞌ ejekaꞌ; disci̱polojmej san tajtachi̱xtikajkej; poxsan madmira̱dojkej. ");
INSERT INTO nhx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Yejeme̱n ayá̱ꞌ kiye̱ꞌentende̱rowa̱yaj inó̱n yej ya̱lwapa kichij Jesús iga tatamáꞌ, iga pox kua̱takuaktikej. ");
INSERT INTO nhx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","A̱panojkej iwá̱n asikej ipan ta̱jli de Genesaret; ompa kilpijkej á̱ka̱l ipan a̱te̱n. ");
INSERT INTO nhx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kua̱ꞌ ki̱skej ipan á̱ka̱l, la gente imaní̱n ki̱xmatikej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Iwá̱n temota̱ta̱lojkej iga kikuitoj yej we̱titokej ipan a̱ltepe̱mej yej najna̱ꞌsan, kiwajwaligakej ipan tapech iga kika̱wili̱toj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Iwá̱n no̱ya̱n ka̱nsan ya̱ya, ipan weyi a̱ltepe̱mej, o siga a̱ltepe̱tzitzi̱n o ipan rancho, ompa kita̱lia̱yaj yej we̱titokej ka̱n panowa Jesús. Iwá̱n kitekiꞌtajtanilia̱yaj iga achi makichijchimili̱ka̱n ite̱mpan itzótzol. Iwá̱n nochi yej kichijchimilijkej achitiakej. ");
INSERT INTO nhx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Fariseojmej iwá̱n sekin yej tamachtiáj ipan iley Moisés yej wa̱lkej Jerusalén, kitechojkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yejemej kitakej idisci̱polojmej Jesús iga ayá̱ꞌ moma̱pa̱kakej, iga takuajkej iwá̱n ima̱sokiyomej. Ayá̱ꞌ moma̱pa̱kakej ken tatekimaka ileymej. Inó̱n íga kima̱litakej. ");
INSERT INTO nhx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Iga fariseojmej iwá̱n nochi judiyojmej kitekichi̱waj ken itajwe̱wejmej kitekichi̱wayaj iga ayá̱ꞌ takuaj siga ayá̱ꞌ achto moma̱pa̱kaj miaꞌ ve̱j. ");
INSERT INTO nhx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Iwá̱n siga yajkaj tajkoa̱ltepe̱ꞌ, siga aya moma̱pa̱kaj, ayá̱ꞌ takuaj. Iwá̱n onoꞌ miaꞌ yej yejeme̱n kitekichi̱wayaj, ken iga tapajpa̱kalo iwá̱n ken iga mopa̱ka tapech.) ");
INSERT INTO nhx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Fariseojmej iwá̱n yej tamachtiáj ipan iley Moisés, tatajtankej: —¿Te iga modisci̱polojmej ayá̱ꞌ kichi̱waj ken tane̱xtilijkej totajwe̱wetkej?, takuaj iwá̱n ima̱sokiyomej. ");
INSERT INTO nhx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús kijtoj: —Amejeme̱n yej anmopajpantiáj iga anye̱ꞌnemij, ómpaya ken kijtoj el profeta Isaías de amejeme̱n, ijkuilijtoꞌ: Iga amoté̱mejsan anne̱weyimati̱ltiáj, eꞌ má̱j ipan amoa̱lmajmej ni alí̱n nokta ayá̱ꞌ anneejla̱mikij. ");
INSERT INTO nhx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ígasan anne̱weyimati̱ltiáj, iga antane̱xtiliáj ken ta̱gaꞌ tatekimaka iwá̱n tane̱xtiliá. ");
INSERT INTO nhx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ankikajtejkej ken tatekimaka Dios, iga ankichi̱waj ken tatekimaka ta̱gaꞌ: ken iga tapajpa̱kalo iwá̱n ankichi̱waj miajmiáꞌ yej áchisan ijijkó̱n. ");
INSERT INTO nhx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","No̱ kijlia̱yaj: —Amejeme̱n ankikajte̱waj ken tatekimaka Dios iga ankichi̱waj ken amejéme̱mpa antamachtiáj. ");
INSERT INTO nhx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés kijtoj: “Xik‑respeta̱ro motaj iwá̱n moye̱ꞌ”, iwá̱n “Yej makima̱ldeci̱ro itaj iwá̱n iye̱ꞌ, inó̱n mamomíktiya.” ");
INSERT INTO nhx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Eꞌ amejeme̱n ankijtowaj iga se̱ ta̱gaꞌ wel kijliá itaj o iye̱ꞌ: “Nopáj, nomáj, iná̱n awel nimitzpale̱wi̱j, iga yej nikpiá, inó̱n iga toDio̱s nikmakas noofre̱ndaj.” ");
INSERT INTO nhx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Siga ijkó̱n, ankijtówajwaꞌ iga ayoꞌ nokta makipale̱wi itaj iwá̱n iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Iga ijkó̱n ankichi̱waj áyoꞌwaꞌ ankitajto̱lkuij Dios iga má̱j ankitokaj ken yej ikya mochi̱waya iga ijkó̱n amose̱sepanne̱xtiliáj. Miaꞌ yej ankichijtokej yej ijijkó̱mpasan. ");
INSERT INTO nhx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesús sej kino̱tzaꞌ la gente, iwá̱n kijtoj: —Amonochi̱n xikakika̱n iwá̱n xikentende̱ro̱ka̱n yej nia nikijto̱ti: ");
INSERT INTO nhx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nité̱ yej agaj kikua kichi̱wiliá iga Dios ayoꞌ makiye̱ꞌita. Eꞌ yej se̱ kichi̱wa yej aye̱kti, inó̱n sí Dios ayá̱ꞌ kiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Amejeme̱n yej annakasyojkej, xine̱ye̱ꞌkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kua̱ꞌ Jesús kikajtej la gente iwá̱n kálaꞌya kalijtiꞌ, idisci̱polojmej kitajtankej té̱ kijto̱jneki in inó̱n ka̱n mi̱xkui̱tilo. ");
INSERT INTO nhx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jesús kijtoj: —¿In amejeme̱n aya̱ꞌtaj no̱ ankentende̱rowaj? Nité̱ yej agaj kikua kichi̱wiliá iga Dios ayoꞌ makiye̱ꞌita, ");
INSERT INTO nhx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","iga inó̱n ayá̱ꞌ asi este ipan iya̱lmaj, sino que iyijtíkosan iwá̱n kiki̱xtiá sej. Inó̱n kijtoj iga nochi tákual wel mokua iwá̱n ayá̱ꞌ kitzakuiliá iga makina̱ꞌtecho Dios. ");
INSERT INTO nhx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Iwá̱n Jesús kijtoj: —Yej agaj kichi̱wa yej aye̱kti, inó̱n sí Dios ayá̱ꞌ kiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iga yej kichijtoꞌ yej aye̱kti, ijkó̱n kejla̱ntoꞌ ipan iya̱lmaj; onoꞌ yej na̱miktitoꞌ yej yawi wa̱n seꞌ, sekin masij áyapa mona̱miktiáj, sekin tamiktiá, ");
INSERT INTO nhx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","onoꞌ yej tachteki, onoꞌ yej kineki makipiá yej ayéj itatki, onoꞌ yej ayá̱ꞌ ye̱ꞌnemi, onoꞌ yej takajkaya̱wa, yej pox tae̱le̱wiá malej iga na̱miktítoꞌya, onoꞌ yej ta‑i̱xita iga kipiasneki tejté̱, yej tapo̱powa, yej moweyimati, iwá̱n yej xejxe̱toꞌnemij. ");
INSERT INTO nhx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochi ini̱mej yej aye̱kti yej se̱ kichi̱wa, inó̱n ki̱sa ipan iya̱lmaj iwá̱n inó̱n kichi̱was iga Dios ayoꞌ kiye̱ꞌitas. ");
INSERT INTO nhx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús yajki ipan íta̱l Tiro iwá̱n Sidón. Kalaꞌ kalijtiꞌ iwá̱n yéj ayá̱ꞌ kinekiá iga mamomati, eꞌ awel mi̱ya̱n. ");
INSERT INTO nhx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Imaní̱n kimatiꞌ se̱ siwa̱ꞌ yej kipiaya se̱ itaochi̱n yej kipiaya ma̱lespí̱ritoj. Inó̱n siwa̱ꞌ kitato Jesús iwá̱n motankua̱ketzaꞌ iyikxite̱noj. ");
INSERT INTO nhx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Inó̱n siwa̱ꞌ sentaman iga griego itájto̱l iwá̱n irra̱zaj sirofenicia. Kitajtanilij Jesús iga achi makiki̱xtili̱ti inó̱n ma̱lespí̱ritoj itaoli̱n. ");
INSERT INTO nhx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Eꞌ Jesús kijlij: —Nej achto manikpale̱wi noge̱ntej, siga tej achto nimitzpale̱wiá, ken tikita nikui̱liá tákual ko̱kone̱ꞌ iwá̱n nikmaka pe̱lomej. ");
INSERT INTO nhx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Siwa̱ꞌ kijtoj: —Je̱kej, ijkó̱n nokta noTe̱ko, eꞌ pe̱lomej yej onokej itampa mesa, kipejpenaj takualta̱tájkol yej ko̱kone̱ꞌ kixi̱niáj ka̱n nemi takuaj. ");
INSERT INTO nhx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús kijtoj: —Ómpaya ken tikijtoj; welya xaj, ma̱lespí̱ritoj kí̱saꞌya ipan motaoli̱n. ");
INSERT INTO nhx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kua̱ꞌ inó̱n siwa̱ꞌ asito icha̱n, kasito itaoli̱n wetztoꞌ ipan tapech, iwá̱n ayoꞌ kipiá ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús sej ki̱saꞌ Tiro iwá̱n pano̱te̱waꞌ Sidón, iwá̱n ipan sekin no̱ a̱ltepe̱mej yej onoꞌ íta̱l diez a̱ltepe̱ꞌ yej kijliáj Decápolis, este asiꞌ ipan laguna de Galilea. ");
INSERT INTO nhx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ompa kiwajliguilijkej se̱ ta̱gaꞌ yej nagastzaktoꞌ iwá̱n yej ayá̱ꞌ pox wel ki̱sa itájto̱l kua̱ꞌ tajtowa, iwá̱n kitajtanilijkej Jesús iga makita̱li ima̱ꞌ ipan inó̱n ta̱gaꞌ iga maachitiá. ");
INSERT INTO nhx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús kiwi̱gaꞌ inó̱n ta̱gaꞌ ka̱n iyokamej, iwá̱n kakilij imájpil ipan inakas. Kichijchalwij imájpil iwá̱n kichijchimilij ile̱nguaj. ");
INSERT INTO nhx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Iwá̱n Jesús ajkotacháꞌ, este mijneltij, iwá̱n kijtoj: —¡Efata! —yej kijto̱jneki: ¡Xitapówiya! ");
INSERT INTO nhx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Íkua̱ꞌsan nagastapowiꞌ in inó̱n yej nagastzaktoya, iwá̱n kiye̱ꞌta̱lilij ile̱nguaj iwá̱n welya ye̱ꞌtajtoj. ");
INSERT INTO nhx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús kijlijkej ino̱mej iga amo agaj makijli̱ka̱n. Entre más kijlijkej iga amo makijto̱ka̱n, ma̱jwaꞌ kipowatoj. ");
INSERT INTO nhx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iwá̱n la gente poxsan madmira̱dowa̱yaj, iwá̱n kijtowa̱yaj: —Ini̱nya sí kichi̱wa nochi yej ye̱kti, este yej nagastzaktoꞌ kinagastapowa, iwá̱n yej awel tajtowa, wel kitajto̱ltiá. ");
INSERT INTO nhx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Íkua̱ꞌ poxsan monejnechko̱lo̱ꞌ, iwá̱n akipiayaj te̱ kikuaj. Iwá̱n Jesús kino̱tzaꞌ idisci̱polojmej, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Cho̱ka noa̱lmaj iga ini̱mej gente, iga kipiaya e̱yi días iga nigaj onokej nowa̱n, iwá̱n ayá̱ꞌ kipiáj te̱ kikuaj. ");
INSERT INTO nhx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Siga niktijti̱tanij ichajcha̱n, ijkó̱n maya̱ntia̱skej, wel tapoliwij ipan ojti iga sekin wa̱lkej wejka. ");
INSERT INTO nhx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Idisci̱polojmej kijtojkej: —¿Kén mamotamaka ini̱mej gente nigaj ka̱n ayagaj cha̱ntitoꞌ? ");
INSERT INTO nhx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús tatajtan: —¿Ké̱skitaj pa̱n ankipiáj? Yejeme̱n kijtojkej: —Sié̱tejsan. ");
INSERT INTO nhx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iwá̱n Jesús kijlij la gente iga mamotajta̱li̱ka̱n ta̱lpan, iwá̱n Jesús kikuiꞌ inó̱n siete pa̱n iga kimáꞌ gracias Dios. Iwá̱n kita̱tajkoloj iwá̱n kimajmáꞌ idisci̱polojmej iga yejemej makimajmakaka̱n la gente. ");
INSERT INTO nhx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kipiayaj no̱ alí̱n to̱pojtzitẕin, iwá̱n Jesús kimáꞌ gracias Dios iwá̱n no̱ tatekimáꞌ iga makimajmakaka̱n la gente. ");
INSERT INTO nhx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nochi takuajkej este ijixwikej. Disci̱polojmej kite̱mijkej siete chikiwiꞌ iga takualta̱tájkol yej ayoꞌ kikuajkej. ");
INSERT INTO nhx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Iga nóchiya takuajkej ken cuatro mil. Iwá̱n Jesús kijlij la gente iga mayá̱ka̱nya. ");
INSERT INTO nhx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iwá̱n Jesús tejkájkeja ipan á̱ka̱l iwá̱n idisci̱polojmej iga yajkij seꞌ a̱ltepe̱ꞌ yej kijliáj Dalmanuta. ");
INSERT INTO nhx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseojmej wa̱lkej ka̱n onoꞌ Jesús iwá̱n pe̱ꞌ kikuejkuesino̱tzkej, kitajtanili̱toj iga makine̱xtili̱ka̱n tejté̱ yej ayi̱ꞌpa mo‑ita yej Dio̱ssan wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús achi má̱j mijneltij, iwá̱n kijtoj: —¿Te iga ini̱mej gente kinekij makitaka̱n yej ayi̱ꞌpa mo‑ita?, nimitzijliáj iga ayá̱ꞌ kitaskej. ");
INSERT INTO nhx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","La gente ka̱wikej; Jesús iwá̱n idisci̱polojmej yajkij tejkawitoj ipan á̱ka̱l iga yajkij a̱sentápal. ");
INSERT INTO nhx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kua̱ꞌ yajkij ayá̱ꞌ kiwi̱gayaj te̱ kikua̱skej iga ke̱lkajkej, petz sé̱tzi̱nsan pa̱n kiwi̱gayaj ipan á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús kijlij idisci̱polojmej: —Taꞌ xikakika̱n; amo xikchi̱waka̱n ken kitekichi̱waj fariseojmej iwá̱n yej kitokaj Herodes, iga yejemej né̱sikiꞌ ye̱ꞌnemij, sie̱mpa ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iwá̱n disci̱polojmej mojlia̱yaj: —Anka ijkó̱n te‑ijliá iga atikuajligakej pa̱n. ");
INSERT INTO nhx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús kimatiꞌ te̱ mojlijtoyaj iwá̱n kijtoj: —¿Te iga nemi anmo‑ijliáj iga ayá̱ꞌ ankipiáj pa̱n? ¿Ke̱ ayá̱ꞌ ankimatij iga nej, iga se̱ pa̱n wel nikchí̱ komati? ¿Ix poxsan anyo̱ltakuaktikej? ");
INSERT INTO nhx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ankipiáj amoyi̱x iwá̱n ayá̱ꞌ antacháj? ¿Annakasyojkej iwá̱n ayá̱ꞌ antakakij? ¿Ayoꞌ ankejla̱mikij? ");
INSERT INTO nhx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kua̱ꞌ nik‑reparti̱roj cinco pa̱n entre cinco mil tokni̱wa̱n, ¿ké̱ꞌ chikiwiꞌ te̱miꞌ yej ta̱tájkol yej ká̱wigoꞌ? Iwá̱n yejeme̱n kijtojkej: —¡Doce! ");
INSERT INTO nhx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesús sej kijtoj: —Kua̱ꞌ iga siete pa̱n nikmajmakakej cuatro mil tajta̱gaꞌ, ¿ké̱ski chikiwiꞌ ankinejnechkojkej iga inó̱n yej ayá̱ꞌ kikuajkej? Iwá̱n yejeme̱n kijtojkej: —¡Siete! ");
INSERT INTO nhx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jesús kijtoj: —¿Amejeme̱n aya ankentende̱rowaj? ");
INSERT INTO nhx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Má̱j má̱j asikej ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Betsaida; iwá̱n Jesús kiwajliguilijkej se̱ pacha, kitekiꞌtajtanilijkej iga makichijchimi. ");
INSERT INTO nhx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Iwá̱n Jesús kima̱wila̱n in pacha iga kiki̱xtij ipan a̱ltepe̱ꞌ; iwá̱n kita̱lilij ichíjchal ipan iyi̱x, iwá̱n kita̱lilij ima̱mej, iwá̱n kitajtan siga tejte̱ya kita. ");
INSERT INTO nhx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Yej pacha katka, kijtoj: —Kena nitachá, nikita tajta̱gaꞌ ken tikita kuawimej, eꞌ nikita iga nejnemij. ");
INSERT INTO nhx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iwá̱n Jesús sej kita̱lilij ima̱mej ipan iyi̱x, iwá̱n ta̱gaꞌ tachi̱xtiki̱saꞌ, iwá̱n achitiáꞌ. Welja ye̱ꞌtachaꞌ este wejka. ");
INSERT INTO nhx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iwá̱n Jesús kití̱tanya icha̱n, kijlij: —Amo xaj tajkoa̱ltepe̱ꞌ, amo xikijto iga nimitztachaltij. ");
INSERT INTO nhx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesús iwá̱n idisci̱polojmej yajkij ipan íta̱l a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Cesarea Filipo, ipan ojti, Jesús kitajtan idisci̱polojmej: —In sekin, ¿té̱ kijtowaj de nej? ");
INSERT INTO nhx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Yejeme̱n kijtojkej: —Sekin kijtowaj iga tej tiJuan yej tabautiza̱rowa̱ya. Sekin kijtowaj iga tej Elías, iwá̱n sekin kijtowaj iga tej agaj profeta. ");
INSERT INTO nhx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesús kijtoj: —In amejeme̱n, ¿té̱ ankijtowaj de nej? Pedro kijtoj: —Tej tiCri̱stoj. ");
INSERT INTO nhx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Eꞌ Jesús kitekimáꞌ iga amo makijli̱ka̱n ni agaj iga yéj in Cristo. ");
INSERT INTO nhx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Iwá̱n Jesús pe̱ꞌ kijlij idisci̱polojmej iga poxsan yawij kikno̱chi̱watij, kijtoj: —Nej yej iPiltzi̱n Ta̱gaꞌ, yawij ne‑ikno̱chi̱watij poxsan iwá̱n yawij ne‑ijiyatij we̱wetkej yej manda̱rowaj iwá̱n ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés. Yawij ne̱mikti̱tij iwá̱n ipan e̱yi día nia ni‑ojpa‑isati sej. ");
INSERT INTO nhx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ijkó̱n iga kinojma‑ijlijkej. Iwá̱n Pedro kiwi̱gaꞌ Jesús ka̱n iyokamej, pe̱ꞌ kajájwaꞌpa iga kijlij iga amo makijto ijkó̱n. ");
INSERT INTO nhx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Eꞌ Jesús mokuepaꞌ iga kitachi̱lij idisci̱polojmej, iwá̱n kajajwaꞌ Pedro, kijlij: —¡Tzitzimiꞌ, xicholo note̱noj! Iga tej ayá̱ꞌ tikejla̱miki ken Dios kejla̱miki, sino que tikejla̱miki ken tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iwá̱n Jesús kino̱tzaꞌ idisci̱polojmej iwá̱n la gente, kijtoj: —Siga agaj kineki mane̱toka, ayꞌya makichi̱wa yej yéj kineki, iwá̱n manejnemi ipan noojwi, malej iga makikno̱chi̱waka̱n poxsan este makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iga yej ayá̱ꞌ mote̱makas iga makimikti̱ka̱n, yawi mikiti; eꞌ nochi yej makimikti̱ka̱n iga nej ne̱toka iwá̱n iga kipowa ye̱ꞌnoti̱ciaj, inó̱n sí moma̱nawi̱j. ");
INSERT INTO nhx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Té̱ mota̱nili̱j ta̱gaꞌ siga makipiá nochi yej onoꞌ ipan iní̱n ta̱jli, iwá̱n makipolo iya̱lmaj? ");
INSERT INTO nhx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Ke̱ꞌ wel kixta̱was iga makikowa iya̱lmaj? ");
INSERT INTO nhx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Siga ipan iní̱n ta̱jli ka̱n mopoxchi̱wa yej aye̱kti agaj mapi̱na̱wa iga notájto̱l iwá̱n iga ne‑i̱xmati, nej no̱ yej iPiltzi̱n Ta̱gaꞌ, nia nikijto̱ti iga ayéj nodiscí̱poloj. Inó̱n nikijto̱j kua̱ꞌ niwi̱ꞌ sej ipan ita̱wi̱lyo noTaj Dios, kua̱ꞌ niwi̱ꞌ iwá̱n iya̱ngelejmej. ");
INSERT INTO nhx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús no̱ kijtoj: —Nimitznojma‑ijliáj iga sekin yej nij onokej ayá̱ꞌ mikiskej este makitaka̱n kén iga Dios reina̱rowa iga ipode̱r. ");
INSERT INTO nhx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kua̱ꞌ pánoja seis días, Jesús yajki ipan se̱ tepe̱ꞌ yej wejkapan, kiwi̱gaꞌ petz Pedro, Jacobo, iwá̱n Juan; iwá̱n ompa iyi̱xtajmej yejemej, Jesús seꞌpay ne̱siꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Itzótzol este xo̱taꞌ, mokuepaꞌ este ichkatiꞌ; ayagaj ijkó̱n wel kikajte̱wa malej iga makiye̱ꞌpa̱ka. ");
INSERT INTO nhx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iwá̱n disci̱polojmej kitakej iga ne̱sikoj ikyapaprofe̱tajmej Elías iwá̱n Moisés; kitakej iga ta̱tapojtokej iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pedro kijlij Jesús: —Tamachtia̱ni, ¡ye̱ktia̱ iga nigaj nonokej! Manikchi̱waka̱n e̱yi ra̱nchojtzitzi̱n, se̱ iga tej, seꞌ iga Moisés iwá̱n seꞌ iga Elías. ");
INSERT INTO nhx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Kijtoj ijkó̱n iga ayoꞌ kimatiá te̱ kijtowa iga disci̱polojmej poxsan majmatoyaj. ");
INSERT INTO nhx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Íkua̱ꞌsan temoj mixti ipan yejeme̱n, iwá̱n kitzakuakej, iwá̱n ipan inó̱n mixti kikakikej se̱ tájto̱l yej wa̱laj ipan cielo, kijtoj: —Ini̱nwaꞌ nokta in noPiltzi̱n yej nikpoxcho̱kiliá. Yéj xikakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kua̱ꞌ disci̱polojmej tachi̱xtiki̱skej, ayoꞌ onoyaj in sekin, isé̱ltisan Jesús onoya iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kua̱ꞌ némiya temo̱tia̱yaj ipan inó̱n tepe̱ꞌ, Jesús kijlij idisci̱polojmej iga amo makipowili̱ka̱n agaj inó̱n yej kitakej, ké̱manoꞌ, este kua̱ꞌ kimiktí̱skeja iwá̱n ojpa‑isas sej, yéj yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Inó̱n iga yejemej ayagaj kipowilijkej, malej iga motajtantoyaj iga te̱ a̱n kijtowa̱ya Jesús iga ojpa‑isas sej. ");
INSERT INTO nhx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Iwá̱n kitajtankej Jesús: —¿Te iga yej tamachtiáj ipan iley Moisés kijtowaj iga achto wi̱ꞌ ikyapaprofe̱taj Elías? ");
INSERT INTO nhx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesús kijtoj: —Kena, melá̱ꞌ iga Elías wi̱ꞌ achto, iga yéj nochi kiye̱ꞌta̱li̱j. ¿Kén kijtowa ka̱n ijkuilijtoꞌ itájto̱l Dios iga nej yej iPiltzi̱n Ta̱gaꞌ? Kijtowa iga poxsan yawij ne‑ikno̱chi̱watij, iwá̱n ne̱pi̱najti̱skej. ");
INSERT INTO nhx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Eꞌ nej nimitzijliáj iga Elías wá̱lkaya, iwá̱n la gente kichi̱wilijkej san ken kinekikej, ijkó̱n kensan ijkuilijtoꞌ iga te̱ yawij kichi̱wili̱tij yéj. ");
INSERT INTO nhx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iwá̱n mokuepkej ka̱n onokej sekin disci̱polojmej, kitakej iga miaꞌ gente onoyaj, iwá̱n yej tamachtiáj ipan iley Moisés mote̱nki̱tzkijkej iwá̱n disci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iwá̱n kua̱ꞌ kitakej Jesús, pox pa̱kikej, iwá̱n nochi motajtalojkej iga ki̱xna̱nkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Iwá̱n Jesús tatajtan: —¿Te iga nemi anmote̱nki̱tzkiáj? ");
INSERT INTO nhx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Se̱ yej ompa onoya kijtoj: —Tamachtia̱ni, nigaj nimitzwajliguilij nopiltzi̱n, kipiá ma̱lespí̱ritoj yej kino̱nojtilijtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Iní̱n ma̱lespí̱ritoj ka̱nsan ne̱siꞌ kiki̱tzkiá, kiwetzi̱ltiá este ta̱lpan. Iwá̱n ompa chijchalposo̱ni, iwá̱n kiguiguitzikaltiá itan. Iwá̱n nopiltzi̱n san kueta̱ntika̱wi. Niktajtanilíjkaja modisci̱polojmej iga makiki̱xtili̱ka̱n, eꞌ awelitiakej. ");
INSERT INTO nhx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús kijtoj: —¡Mataj amejeme̱n ayá̱ꞌ anmomelaꞌconfia̱rojtokej nopan! ¿Este ké̱manoꞌ má̱j nia nonoti iwá̱n amejeme̱n? ¿Este ke̱man nia nimitzijyo̱wijtotij? Taꞌ xine̱wajliguili̱ka̱n in chokotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iwá̱n kiwajliguilijkej, iwá̱n kua̱ꞌ inó̱n ma̱lespí̱ritoj kitaꞌ Jesús, íkua̱ꞌ sej kiki̱tzkij, iwá̱n wetziꞌ este ta̱lpan, momi̱mimiloj, iwá̱n chijchalposo̱niꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús kitajtan itaj chokotzi̱n: —¿Ké̱skiya años kipiá iga ijkí̱n onoꞌ? Itaj kijtoj: —Este iga séligoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Miaꞌ ve̱j iní̱n ma̱lespí̱ritoj kimo̱ta nopiltzi̱n tiko iwá̱n a̱tampa iga makimikti. A̱nwaꞌ nimitztajtaniko, ix ayá̱ꞌ wel tiki̱xtilia̱ya iní̱n ma̱lespí̱ritoj. Xine̱pale̱wi̱ka̱n, achi xine‑ikne̱li̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús kijlij: —Siga timoconfia̱rowa iga niwel, wel. Iga yej moconfia̱rowa ipan nej, nochi wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iwá̱n itaj inó̱n chokotzi̱n kijtoj recio: —¡Nimoconfia̱rowa; xine̱pale̱wi iga manimomelaꞌconfia̱ro! ");
INSERT INTO nhx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kua̱ꞌ Jesús kitaꞌ iga nemi monechko̱lo, kajajwaꞌ inó̱n ma̱lespí̱ritoj, kijlij: —Ti‑espíritu yej titano̱nojtiliá, iwá̱n yej titanagastzakua, nej nimitztekimaka iga xikí̱saya, xiká̱waya in iní̱n chokotzi̱n, iwá̱n ayoꞌ sej xikalaki ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Iwá̱n ma̱lespí̱ritoj tzajtziꞌ recio, kitze̱tzejtzeloj sej, iwá̱n ki̱saꞌ, este kitapolo̱ltijtika̱wiꞌ chokotzi̱n. Iwá̱n miaꞌ yej ompa onoyaj kijtowa̱yaj iga miꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Eꞌ Jesús kima̱ki̱tzkij, iwá̱n kikétzaꞌya in inó̱n chokotzi̱n; ejkatika̱ꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iwá̱n Jesús yajki kalakito kalijtiꞌ. Idisci̱polojmej kitajtankej Jesús ka̱n ise̱ltimej; kijtojkej: —Nejeme̱n, ¿te iga awel niki̱xtijkej inó̱n ma̱lespí̱ritoj? ");
INSERT INTO nhx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesús kijtoj: —Es que ini̱mpa ma̱lespí̱ritoj awel tiki̱xtiáj siga ayá̱ꞌ ti‑ora̱dowaj, iwá̱n siga ayá̱ꞌ timayuna̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kua̱ꞌ ompa ki̱skej, pano̱tejkej Galilea. Iwá̱n Jesús ayá̱ꞌ kinekiá iga mamomati. ");
INSERT INTO nhx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Kijlia̱ya idisci̱polojmej: —Nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱ki̱tzki̱tij iwá̱n ne̱mikti̱skej, eꞌ ipan e̱yi día iga nimikis, nia sej ni‑ojpa‑isati. ");
INSERT INTO nhx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Eꞌ yejeme̱n ayá̱ꞌ kentende̱rowa̱yaj yej Jesús kijtowa̱ya. Kitajtanisnekiáj, eꞌ awelitiꞌ, iga kimajmawilia̱yaj iga kitajtaniáj. ");
INSERT INTO nhx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Kua̱ꞌ asikej a̱ltepe̱ꞌ Capernaum, iwá̱n onóyaja kalijtiꞌ, Jesús kitajtan idisci̱polojmej: —¿Té̱ in yej anmo‑ijlijtiwi̱tziáj ipan ojti? ");
INSERT INTO nhx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Eꞌ disci̱polojmej atajtojkej, iga ipan ojti mojlijtiwi̱tziáj iga a̱ꞌyéj a̱n in yej má̱j tayaka̱ntos de yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Iwá̱n Jesús mota̱lij, iwá̱n kino̱tzaꞌ ino̱mej doce idisci̱polojmej; kijtoj: —Si agaj de amejeme̱n kineki má̱j matayaka̱nto, mamomachi̱li ken yej onoꞌ este tatepotztaj iwá̱n makipale̱wi nochi tokni̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Kima̱tila̱n se̱ choochi̱n iwá̱n kiketzaꞌ tajkoya̱n. Kinawaj, iwá̱n kijlij idisci̱polojmej: ");
INSERT INTO nhx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Siga agaj ki‑o̱mema̱wiá se̱ ken iní̱n choochi̱n iga ne̱toka, ken kua̱ꞌ nejya yej nemi neo̱mema̱wiá. Iwá̱n inó̱n yej ne̱‑o̱mema̱wiá, no̱ ki‑o̱mema̱wiá yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iwá̱n idiscí̱poloj yej ito̱ka̱ꞌ Juan, kijlij Jesús: —Tamachtia̱ni, nikitakej se̱ yej ipan moto̱ka̱ꞌ kiki̱xtiá ma̱lespí̱ritoj, eꞌ como ayá̱ꞌ nemi iwá̱n tejeme̱n, nika̱waltijkej. ");
INSERT INTO nhx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Eꞌ Jesús kijtoj: —Amo xika̱walti̱ka̱n, iga yej kichi̱wa milagro ipan noto̱ka̱ꞌ, awel ne̱ma̱lijliá. ");
INSERT INTO nhx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yej ayá̱ꞌ te̱ma̱lita inó̱n te̱pale̱wiá. ");
INSERT INTO nhx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A̱ꞌsan ne̱siꞌ yej mitzmakaj malej se̱ wájkal a̱ꞌti ipan noto̱ka̱ꞌ igasan anne̱tokaj, nimitzijliáj iga inó̱n sí Dios kimakas yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesús no̱ kijtoj: —Si agaj makichi̱walti yej aye̱kti se̱ de ini̱mej yej ne̱tokaj, yej ayá̱ꞌ moweyimatij, má̱j ye̱kti katka makipilo̱lti̱ka̱n se̱ weyiteꞌti ipan ikech iwá̱n makimo̱taka̱n láma̱rko. ");
INSERT INTO nhx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Siga itechko moma̱ꞌ tikchi̱wa yej aye̱kti, ximoma̱tajkolo; má̱j ye̱kti xikalaki ka̱n onoꞌ Dios iwá̱n se̱ moma̱ꞌ, eꞌ amo xaj iwá̱n o̱me moma̱ꞌ ka̱n wewelkatoꞌ tiꞌti yej awel se̱wi, ");
INSERT INTO nhx_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ka̱n okuilimej ayí̱ꞌ mikij iwá̱n tiꞌti ayí̱ꞌ se̱wi. ");
INSERT INTO nhx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Siga itechko mokxi tikchi̱wa yej aye̱kti, ximokxitajkolo, má̱j ye̱kti xikalaki ka̱n onoꞌ Dios tikxitepon, eꞌ amo xaj iwá̱n o̱me mokxi ka̱n wewelkatoꞌ tiꞌti yej ayí̱ꞌ se̱wi, ");
INSERT INTO nhx_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ka̱n okuilimej ayí̱ꞌ mikij iwá̱n tiꞌti ayí̱ꞌ se̱wi. ");
INSERT INTO nhx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Iwá̱n siga moyi̱x mitzchi̱waltiá yej aye̱kti, xiki̱xti, má̱j ye̱kti xikalaki ka̱n onoꞌ Dios iga se̱ moyi̱x, eꞌ amo xikalaki iwá̱n o̱me moyi̱x ka̱n tawewelkatoꞌ, ");
INSERT INTO nhx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ka̱n okuilimej ayí̱ꞌ mikij iwá̱n tiꞌti ayí̱ꞌ se̱wi. ");
INSERT INTO nhx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ijkó̱n ken tiꞌti kitatiá tásol, iwá̱n istaꞌ kichi̱wa iga nakaꞌ amo mapala̱ni, ijkó̱n no̱ yej ne̱tokaj panowaj ipan prueba iga maye̱ꞌnemika̱n iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Istaꞌ pox ye̱kti, eꞌ siga ayꞌya istawe̱liꞌ, ¿tejas iga moneki? Amejeme̱n xitamopaka̱n ken istaꞌ iwá̱n xonoka̱n tamelá̱ iwá̱n sekin. ");
INSERT INTO nhx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús ki̱saꞌ Capernaum, iwá̱n yajki ipan estado de Judea iwá̱n iyi̱ka̱n we̱ya̱ꞌ Jordán iki̱sáya̱mpa to̱nati̱ꞌ. Ompa sej monejnechko̱lo̱ꞌ, iwá̱n pe̱waꞌ sej tamachtij ken nochipa kitekichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Iwá̱n sekin fariseojmej kitechojkej Jesús ka̱nsan makima̱wetzi̱lti̱ka̱n ipan itájto̱l. Kitajtankej siga se̱ ta̱gaꞌ wel kikajte̱wa isiwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesús kijtoj: —¿Kén mitztekimakakej Moisés? ");
INSERT INTO nhx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yejeme̱n kijtojkej: —Moisés kijtoj iga se̱ ta̱gaꞌ wel kika̱wa isiwa̱ꞌ, siga kichi̱wiliá se̱ a̱maꞌ ka̱n kijtowa iga momelaꞌkájkeja. ");
INSERT INTO nhx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Iwá̱n Jesús kijtoj: —Moisés mitzkajte̱wilijkej inó̱n ley iga poxsan anyo̱ltakuaktikej. ");
INSERT INTO nhx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Eꞌ kua̱ꞌ pe̱waꞌ, Dios kichij inewi yej onoꞌ, kichij ta̱gaꞌ iwá̱n siwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Inó̱n iga se̱ ta̱gaꞌ, kua̱ꞌ mona̱miktiá, kikajte̱was itaj iwá̱n iye̱ꞌ iga moseka̱ntí̱skeja iwá̱n isiwa̱ꞌ, ");
INSERT INTO nhx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","iwá̱n iyo̱mextimej mochi̱waskej ken se̱san.” Ayoꞌ o̱me̱n, sino que se̱san. ");
INSERT INTO nhx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Inó̱n iga amo agaj makiyokati yej Dios kise̱tilij. ");
INSERT INTO nhx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kua̱ꞌ Jesús iwá̱n idisci̱polojmej onókeja kalijtiꞌ, kitajtankej sej Jesús de inó̱n. ");
INSERT INTO nhx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús kijtoj: —Yej kiyokaka̱wa isiwa̱ꞌ, iwá̱n mona̱miktiá iwá̱n seꞌ, iga ijkó̱n kichi̱wa, kichi̱wiliá yej aye̱kti yej áchtopa isiwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ijko̱nsan no̱ siwa̱ꞌ, siga kiyokaka̱wa iwé̱j, iwá̱n mona̱miktiá iwá̱n seꞌ, iga ijkó̱n kichi̱wa, kichi̱wiliá yej aye̱kti yej áchtopa iwé̱j. ");
INSERT INTO nhx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iwá̱n Jesús kiwijwi̱guilia̱yaj ko̱kone̱ꞌ iga makitajtanili Dios iga maye̱ꞌonoka̱n. Eꞌ disci̱polojmej pe̱wakej iga kajajwakej ino̱mej yej nemi asij iwá̱n iko̱kone̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kua̱ꞌ Jesús kitaꞌ iga ijkó̱n nemi kichi̱waj idisci̱polojmej, kuesiwiꞌ, kijtoj: —Xika̱waka̱n in ko̱kone̱ꞌ, ka̱ma mane̱techo̱ka̱n, amo xikojtzakuili̱ka̱n; iga yej mochi̱wa ken ini̱mej ko̱kone̱ꞌ, kajasi iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nimitznojma‑ijliáj iga yej ayá̱ꞌ mote̱makas iga Dios makimanda̱ro ken se̱ yej aya yo̱lej, awel kalakis ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iwá̱n kinawajkej, iwá̱n kitajtá̱lijpa ima̱ꞌ iga kite̱ne̱wij Dios iga yejemej. ");
INSERT INTO nhx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kua̱ꞌ Jesús némiya ojkui, motalojtiwa̱laj se̱ ta̱gaꞌ, iwá̱n motankua̱ketztiki̱saꞌ ite̱noj, iwá̱n kitajtan: —Tamachtia̱ni yej tiye̱ꞌnemi, ¿té̱ nikchi̱was iga nochipa manono iwá̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús kijlij: —¿Te iga tine‑ijliá iga niye̱ꞌnemi? Sé̱sanwaꞌ in yej kichi̱wa yej ye̱kti, ino̱nwaꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tej tikmátiya ken Dios tatekimaka: “Yej na̱miktitoꞌ amo mayawi wa̱n seꞌ; amo xitamikti; amo xitachteki; amo xitakajkaya̱wa; amo xikijto yej ayéj ijkó̱n, xikye̱ꞌita motaj iwá̱n moye̱ꞌ.” ");
INSERT INTO nhx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta̱gaꞌ kijtoj: —Tamachtia̱ni, inewi iní̱n nikchijtoꞌ este kua̱ꞌ aya niyo̱lej. ");
INSERT INTO nhx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iwá̱n Jesús kitachi̱lij iwá̱n kiye̱ꞌitaꞌ, iwá̱n kijlij: —Se̱san mitzpolowa iga xikchí̱: xiknamaka inewi yej tikpiá, iwá̱n xikmajmaka yej ayá̱ꞌ motapialiáj. Ijkó̱n tikpiás yej pox ye̱kti ipan cielo; iwá̱n xine̱toka, malej iga este mamitzmikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kua̱ꞌ ta̱gaꞌ kikaguiꞌ inó̱n, mokno̱matiꞌ, iwá̱n ijkó̱n mokno̱matitiajki iga pox kipiaya tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iwá̱n Jesús ta̱tacháꞌ nij neí, iwá̱n kijlij idisci̱polojmej: —¡Pox difícil iga yej motapialiáj mamote̱makaka̱n iga Dios marreina̱ro ipan yejeme̱n! ");
INSERT INTO nhx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Iwá̱n disci̱polojmej poxsan madmira̱dojkej iga ijkó̱n kijtoj Jesús. Eꞌ Jesús sej kijtoj: —Nopilowa̱n, ¡nimitzijliáj iga se̱ yej moconfia̱rowa ipan itomi̱n, poxsan difícil iga mote̱maka iga Dios marreina̱ro ipan yej! ");
INSERT INTO nhx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Má̱j wel mapano se̱ camello ipan ixapoyo a̱ko̱xaj, que se̱ yej motapialiá mamote̱maka iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kua̱ꞌ disci̱polojmej kikakikej iní̱n, poxsan madmira̱dojkej, iwá̱n motajtaniáj: —¿A̱ꞌtaj wel moma̱nawi̱j? ");
INSERT INTO nhx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesús kitachi̱lij idisci̱polojmej, iwá̱n kijtoj: —Tajta̱gaꞌ awel kichi̱waj, eꞌ Dios wel kichi̱wa; iga Dios ateyi yej ken awel makichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iwá̱n Pedro kijlij: —NoTe̱ko, nejeme̱n nikajtejkej inewi yej nikpiayaj, iwá̱n némiya nimitztokaj. ");
INSERT INTO nhx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Iwá̱n Jesús kijtoj: —Nimitzijliáj, siga agaj kikajte̱wa íkal, o iyikni̱wa̱n, o itaj, o iye̱ꞌ, o isiwa̱ꞌ, o ipilowa̱n, o íta̱l, igasan ne̱tokaj iwá̱n iga kipowaj itájto̱l Dios, ");
INSERT INTO nhx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nimitzijliáj iga ipan iní̱n ta̱jli yawij kipiatij cien ve̱j má̱j, kajlimej, iyikni̱wa̱n, iye̱mej, ipilowa̱n iwá̱n ita̱lmej, malej iga kijiyaj; iwá̱n ipan seꞌ ta̱jli yej wi̱‑oꞌ nochipa onoskej. ");
INSERT INTO nhx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Eꞌ miaꞌ yej iná̱n tayaka̱ntokej, yawij ka̱witij tatepotztaj, iwá̱n yej iná̱n onokej tatepotztaj yawij tayaka̱ntotij. ");
INSERT INTO nhx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús iwá̱n idisci̱polojmej nemi ya̱yaj Jerusalén; Jesús tapano̱tia̱ya. Disci̱polojmej poxsan madmira̱dojkej; iwá̱n sekin kimo̱ka̱tokatia̱yaj. Iwá̱n Jesús kino̱tzaꞌ, iyoka ino̱mej disci̱polojmej, iwá̱n kijlijkej yej yawij kichi̱wili̱tij kua̱ꞌ asis Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kijtoj: —Ken ankitaj amejeme̱n, nemi tiawij Jerusalén. Ompa nej yej iPiltzi̱n Ta̱gaꞌ, yawij ne̱ki̱tzki̱tij ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés, yawij kijto̱tij iga mane̱mikti̱ka̱n iwá̱n ne̱ti̱taniskej ipan ima̱mej yej ayéj togé̱ntejpa. ");
INSERT INTO nhx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yawij ne̱pi̱najti̱tij, ne̱magaskej, ne̱chijchaskej, iwá̱n ne̱mikti̱skej; eꞌ ipan e̱yi día iga nimikis, nia ni‑ojpa‑isati sej. ");
INSERT INTO nhx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jacobo iwá̱n Juan, yej ipilowa̱n Zebedeo, kitechojkej Jesús, iwá̱n kijlijkej: —Tamachtia̱ni, niknekij iga achi xine̱chi̱wili̱ka̱n yej nimitztajtaniliáj. ");
INSERT INTO nhx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yéj kijtoj: —¿Te̱ ankinekij manikchí̱? ");
INSERT INTO nhx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Kijtojkej: —Xikchí̱ iga nejeme̱n, kua̱ꞌ tiaya tirreina̱ro̱ti, manimota̱li̱ka̱n ompa ka̱n tej timota̱li̱j, se̱ moye̱ꞌka̱mpa, sewoꞌ moo̱pochka̱mpa. ");
INSERT INTO nhx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús kijtoj: —Amejeme̱n ayá̱ꞌ ankimatij te̱ nemi ankitajtanij. ¿Ix ankijyo̱wi̱skej ken nej nikijyo̱wi̱j kua̱ꞌ ne‑ikno̱chi̱waskej? ¿Ix wel ampano̱skej ka̱n nej nipano̱j? ");
INSERT INTO nhx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yejeme̱n kijtojkej: —Kena, wel. Jesús kijtoj: —Kena ankijyo̱wi̱skej inewi sufrimiento ken nej nia nikijyo̱wi̱ti kua̱ꞌ ne‑ikno̱chi̱waskej, iwá̱n ampano̱skej ka̱n nej nipano̱j. ");
INSERT INTO nhx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Eꞌ iga ximota̱li̱ka̱n noye̱ꞌka̱mpa o noo̱pochka̱mpa, inó̱n nej ayá̱ꞌ nikmati, iga notaj Dios kimati a̱ꞌyéj kimakas. ");
INSERT INTO nhx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kua̱ꞌ ino̱mej seꞌ diez disci̱polojmej kimatikej inó̱n, kikuesowilijkej Jacobo iwá̱n Juan. ");
INSERT INTO nhx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Eꞌ Jesús tano̱tzaꞌ, kijtoj: —Amejeme̱n ankimatij iga yej manda̱rowaj ipan iní̱n ta̱jli, poxsan kitajtaksa ige̱ntej iwá̱n yej goberna̱rowaj, yo̱lki̱saj pan yej até̱ iteki, ka̱nsan mane̱si iga manda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Eꞌ amejeme̱n ayéj ijkó̱n. Ma̱jwaꞌ yej kineki matayaka̱nto ipan amejeme̱n, inó̱n achto makipale̱wi tokni̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Iwá̱n agaj yej kineki matayaka̱nto, mamochi̱wa esclavo iga nochi tokni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Iga nej yej iPiltzi̱n Ta̱gaꞌ ayá̱ꞌ niwa̱laj iga mane̱pale̱wi̱ka̱n, sino iga manitapale̱wi iwá̱n iga manimiki iga miaꞌ manikxitoma yej ken ilpitokej iga aye̱kti kichijtokej. ");
INSERT INTO nhx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iwá̱n asikej Jericó. Kua̱ꞌ Jesús ki̱stia̱ya ompa iwá̱n idisci̱polojmej iwá̱n poxsan miaꞌ gente, se̱ pacha e̱watoya ipan ojte̱n, kitajtantoya tomi̱n. Ito̱ka̱ꞌ Bartimeo, yej ipíltzi̱mpa Timeo. ");
INSERT INTO nhx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kua̱ꞌ kikaguiꞌ iga nemi kitechojtiá Jesús de Nazaret, pacha tzajtziꞌ: —¡Jesús, iPiltzi̱n David, achi xine‑ikne̱li! ");
INSERT INTO nhx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sekin kajajwakej iga ayoꞌ matzajtzito, eꞌ yéj ma̱jya tzajtziꞌ: —¡Jesús, iPiltzi̱n David, áchikej xine‑ikne̱li! ");
INSERT INTO nhx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús moketzaꞌ iwá̱n kijtoj: —Xikno̱tzatij. Iwá̱n kino̱tzatoj inó̱n pacha, kijlijkej: —Ximoconfia̱ro iwá̱n ximoketza, iga nemi mitzno̱tza. ");
INSERT INTO nhx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Iwá̱n inó̱n pacha kitájkal itejkuix, este witó̱niꞌpa iga moketzaꞌ, iwá̱n kitecho̱to Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús kitajtan: —¿Té̱ tikneki manimitzchi̱wili? Pacha kijtoj: —Tamachtia̱ni, ¡nikneki manitachá! ");
INSERT INTO nhx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús kijtoj: —Iga timoconfia̱roj, titachaꞌya, welja tia. Iwá̱n íkua̱ꞌsan inó̱n pacha welja tacháꞌ, iwá̱n kitokatiájkiya Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kua̱ꞌ Jesús iwá̱n idisci̱polojmej asitiá̱yaja Jerusalén, ite̱noj a̱ltepe̱mej yej ito̱ka̱ꞌ Betfagé iwá̱n Betania, yej onokej iyi̱xtaj tepe̱ꞌ yej ito̱ka̱ꞌ Olivos, Jesús kiti̱tan o̱me idisci̱polojmej, ");
INSERT INTO nhx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","kijtoj: —Xa̱ka̱n a̱ltepe̱tzi̱n yej nijígasan onoꞌ, kua̱ꞌ amasiskej, ankasiskej se̱ burro ilpitoꞌ, yej aya agaj kitejkawiliá. Xikxitomaka̱n iwá̱n xikuajligaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Iwá̱n siga agaj mitztajtanij te íga ankixitomaj, xikijli̱ka̱n: “ToTe̱ko kineki, iwá̱n nimaní̱n sej mitzka̱wili̱ki.” ");
INSERT INTO nhx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Yajkij, iwá̱n kasikej inó̱n burro ilpitoꞌ pue̱rtajte̱noj ipan ojti, iwá̱n kixitonkej. ");
INSERT INTO nhx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Iwá̱n yej ompa onoyaj kijtojkej: —¿Té̱ nemi ankichi̱waj? ¿Te iga nemi ankixitomaj in burro? ");
INSERT INTO nhx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iwá̱n yejeme̱n kijtojkej kensan Jesús kijtoj; iwá̱n kijlijkej iga wel makiwi̱gaka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Iwá̱n inó̱n burro, kiwi̱guilijkej Jesús, kipechtijkej burro iga yejemej itzotzolmej, iwá̱n Jesús tejkaj. ");
INSERT INTO nhx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Iwá̱n miaꞌ kipata̱wilijtiajkij itzotzolmej ipan ojti, iwá̱n sekin kitejtekkej imajma̱ꞌ so̱ya̱ꞌ iwá̱n kita̱lijkej ipan ojti. ");
INSERT INTO nhx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iwá̱n ino̱mej yej tayanka̱ntia̱yaj iwá̱n yej wi̱tziáj tatzi̱mpan, pe̱ꞌ tzajtzikej: —¡Mamoweyimati̱lti Dios! ¡Mamoweyimati̱lti yej kiti̱tani toTe̱ko Dios! ");
INSERT INTO nhx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Mamoweyimati̱lti yej wi̱ꞌ manda̱ro̱ki ken manda̱roj rey David! ¡Mamoweyimati̱lti Dios yej onoꞌ ipan cielo! ");
INSERT INTO nhx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús asiꞌ Jerusalén iwá̱n kalaꞌ weyitio̱pan. Iwá̱n kua̱ꞌ nóchiya kitaꞌ yej ompa onoꞌ, iga némiya tayowati, yajkij Betania iwá̱n doce idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kua̱ꞌ tané̱siꞌya sej, ki̱skej Betania; Jesús maya̱naꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Iwá̱n wéjkasan kitaꞌ se̱ higue̱rajkuawiꞌ yej iswayoj, iwá̱n yajki kitato siga kipiá ita̱kilka, eꞌ kitaꞌ iga ayá̱ꞌ ta̱ktoꞌ, akasiꞌ nité̱, petz iyiswáyosan puej aya itie̱mpoj iga maono yej yoksiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesús kino̱tzaꞌ inó̱n higue̱rajkuawiꞌ, kijlij: —Ayoꞌ agaj mitzkua̱li̱j mota̱kilka. Iwá̱n idisci̱polojmej kikakikej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Asikej Jerusalén. Iwá̱n kua̱ꞌ Jesús kalaꞌ ipan ipa̱tiojyo weyitio̱pan, kikijki̱xtij yej ompa tanamakatokej, iwá̱n yej takojtokej. Iwá̱n kitzijtzi̱nkuepaꞌ me̱sajmej ka̱n mokambia̱rowa tomi̱n iwá̱n ka̱n mota̱liáj yej kinamakaj jojtokomej. ");
INSERT INTO nhx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iwá̱n Jesús kijtoj iga awel panowa agaj ipan ipa̱tiojyo weyitio̱pan siga kiwi̱ga tejté̱. ");
INSERT INTO nhx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Iwá̱n Jesús kijtoj: —Ka̱n ijkuilijtoꞌ itájto̱l Dios, ijkí̱n kijtowa: “Nókal yawi moto̱ka̱wi̱ti kajli ka̱n ora̱dowaj de inochi pai̱smej”, eꞌ amejeme̱n ankikueptokej ka̱n mi̱ya̱naj yej tachtekij. ");
INSERT INTO nhx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iwá̱n ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan la ley, kimatikej te̱ kichij Jesús, iwá̱n kite̱mowa̱yaj ken iga makimikti̱ka̱n iga kimajmawilia̱yaj, puej nochi kiye̱ꞌitayaj ken iga tamachtiá. ");
INSERT INTO nhx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Eꞌ kua̱ꞌ némiya tako̱miti, Jesús ki̱saꞌ Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iwá̱n yowaltiꞌ kua̱ꞌ pano̱tia̱yaj, kitakej iga higue̱rajkuawiꞌ wa̱ꞌya este inelwayo. ");
INSERT INTO nhx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Iwá̱n Pedro kejla̱n, iwá̱n kijlij Jesús: —Tamachtia̱ni, taꞌ xikita in higue̱rajkuawiꞌ yej ya̱lwa tikajajwaꞌ, a̱n sí wa̱ꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús kijtoj: —Ximoconfia̱ro̱ka̱n ipan Dios. ");
INSERT INTO nhx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nimitznojma‑ijliáj, iga a̱ꞌsan makijli ine̱pa tepe̱ꞌ: “Xicholo ompa ka̱n tonoꞌ, iwá̱n xaj láma̱rko”, siga momelaꞌconfia̱rowa iga inewi iya̱lmaj, iwá̱n siga kicre̱dowa iga inó̱n yej kijtoj yawi mochi̱wati, ijkó̱n mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Inó̱n iga nimitzijliáj iga inewi yej ankitajtanili̱skej Dios kua̱ꞌ nemi an‑ora̱dowaj, iwá̱n siga ankicre̱dowaj iga mitzmakaskej, ijkó̱n mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Iwá̱n kua̱ꞌ nemi ankite̱ne̱wiáj Dios, siga agaj tikuesowilijtoꞌ, xike̱lka̱wili yej mitzchi̱wilij, ijkó̱n no̱ amoTaj yej onoꞌ ajko ipan cielo mitze̱lka̱wili̱skej yej ankichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Siga amejeme̱n ayá̱ꞌ anke̱lka̱wiliáj yej agaj mitzchi̱wiliáj yej aye̱kti, amoTaj yej onoꞌ ipan cielo ayá̱ꞌ no̱ mitze̱lka̱wili̱skej yej ankichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iwá̱n sej mokuepkej Jerusalén. Jesús nemiá weyitio̱pan, kitecho̱toj ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan la ley iwá̱n yej kimanda̱rowaj judiyojmej, ");
INSERT INTO nhx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","kitajtankej Jesús: —¿Té̱ moteki in tej iga tikchi̱wa iní̱n? ¿A̱ꞌ mitztekimáꞌ iga wel xikchi̱wa iní̱n? ");
INSERT INTO nhx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús kijtoj: —Nia no̱ nimitztajtanitij, iwá̱n xine‑ijli̱ka̱n iwá̱n nimitzijli̱skej a̱ꞌyéj ne̱tekimáꞌ iga nikchi̱wa iní̱n. ");
INSERT INTO nhx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿A̱ꞌyéj kiti̱tan Juan iga matabautiza̱ro? ¿Ix Dios kiti̱tan, o tajta̱gaꞌ? Xine‑ijli̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Iwá̱n yejéme̱nsan mota̱tapo̱wia̱yaj, mojlia̱yaj: —Siga tikijto̱skej iga Dios kiti̱tan Juan, Jesús yawi kijto̱ti: “¿Te ígataj ayá̱ꞌ ankitajto̱lkakikej?” ");
INSERT INTO nhx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Iwá̱n awel tikijto̱skej iga kiti̱tan ta̱gaꞌ. Ijkó̱n kijtojkej ga kimajmawiliáj la gente, iga nochi kimatiá iga Juan Dios kitajto̱lmakaya. ");
INSERT INTO nhx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iwá̱n kijlijkej Jesús: —Anikmatij. Iwá̱n Jesús kijtoj: —Nej no̱ ayá̱ꞌ nimitzijliáj a̱ꞌyéj ne̱tekimaka iga manikchi̱wa ijkí̱n. ");
INSERT INTO nhx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iwá̱n Jesús pe̱waꞌ tata̱tapo̱wij ka̱n mami̱xkui̱tilo, kijtoj: —Se̱ ta̱gaꞌ kito̱gaꞌ u̱vajyoj. Kikola̱ltij, iwá̱n kichij se̱ pozo ka̱n mopa̱tzka uva. Kichij se̱ torre iga wel matachalo no̱ya̱n ka̱n onoꞌ u̱vajyoj. ’Iwá̱n kita̱ke̱waltij sekin tekipanowa̱nimej iwá̱n yajki wejka. ");
INSERT INTO nhx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kua̱ꞌ némiya yoksi uva, ite̱ko kiti̱tan se̱ mo̱nsoj, kijlij: “Xaj xiktajtanili̱ti yej nemi tekipanowaj iga mane̱makáka̱nya uva ke̱ꞌ nej ne̱toca̱rowa.” ");
INSERT INTO nhx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eꞌ yejeme̱n kiki̱tzkijkej iwá̱n kimagakej iwá̱n akimakakej nité̱. ");
INSERT INTO nhx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ite̱ko u̱vajyoj kiti̱tan seꞌ mo̱nsoj; eꞌ inó̱n no̱ kitewijkej, kikuajkua̱tzaya̱nkej iwá̱n kuajkuantas kijlijkej. ");
INSERT INTO nhx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kiti̱tan sewoꞌ, inó̱n sí este kimiktijkej. Má̱j má̱j kiti̱tan sekin, ino̱mej no̱ kimagakej iwá̱n sekin kimiktijkej. ");
INSERT INTO nhx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Eꞌ kipiaya se̱ ipiltzi̱n yej poxsan kicho̱kilia̱ya iwá̱n kiti̱tan inó̱n, kijtoj: “Iní̱n sí nopiltzi̱n kiye̱ꞌitaskej.” ");
INSERT INTO nhx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Eꞌ tekipanowa̱nimej, yejéme̱nsan kijtojkej: “Iní̱nyawaꞌ in yej yawi mochi̱wati ite̱ko iní̱n ta̱jli, yej ítajpa kikajte̱was, matikmiktí̱ka̱nya nokta iga maka̱wi íta̱l iga tejemej.” ");
INSERT INTO nhx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Iwá̱n kiki̱tzkijkej, kimiktijkej iwá̱n kiki̱xtijkej ipan u̱vajyoj. ");
INSERT INTO nhx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iwá̱n Jesús tatajtan: —¿Té a̱n kichi̱was ite̱ko mi̱jli? Wi̱ꞌ iwá̱n kimikti̱j ino̱mej tekipanowa̱nimej, iwá̱n inó̱n u̱vajyoj kimakas seꞌ tekipanowa̱nimej. ");
INSERT INTO nhx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Ix ayí̱ꞌ ankitaj ka̱n ijkí̱n ijkuilijtoꞌ? Kijtowa: Yej nemi kalchi̱waj kitajkalkej se̱ teꞌti yej kijtojkej iga aye̱kti, eꞌ ino̱nya yej mochi̱wako má̱j ye̱ꞌteꞌti. ");
INSERT INTO nhx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ijkó̱n kichij toTe̱ko, iwá̱n poxsan timadmira̱dowaj iga tikitaj. ");
INSERT INTO nhx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Iwá̱n kinekiáj makipre̱sojwi̱ka̱n Jesús iga kimatikej iga yejemej nemi kikajkaktiáj. Eꞌ kimajmawilijkej yej ompa chapa̱ntoyaj, kikajtejkej iwá̱n yájkija. ");
INSERT INTO nhx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Eꞌ despué̱j kiti̱tanilijkej sej sékinoꞌ más fariseojmej iwá̱n sekin yej kitokaj rey Herodes, ka̱nsan Jesús makijto tejté̱ iga wel makite̱lwi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Kua̱ꞌ ino̱mej asitoj, kijtojkej: —Tamachtia̱ni, nikmatij iga tej ómpaya ken tikijtowa, iwá̱n tej ayá̱ꞌ tikchi̱wiliá caso ken mitzijliáj, tej nochi ijko̱nsan tikjuzga̱rowa; melá̱ꞌ iga titamachtiá yej Dio̱spa iyojwi. ¿Ix ye̱kti manikixta̱waka̱n impuesto iga rey César o ayá̱ꞌ? ¿Ix nikmakaskej o anikmakaskej? ");
INSERT INTO nhx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Eꞌ Jesús kimatiꞌ iga kima̱wetzi̱lti̱jnekiáj, kijtoj: —¿Te iga anne̱proba̱rowaj? Xine̱wajliguili̱ka̱n se̱ tomi̱n, iga manikita. ");
INSERT INTO nhx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kiwajliguilijkej, iwá̱n kua̱ꞌ kitaꞌ, Jesús tatajtan: —¿Iní̱n a̱ꞌyéj ixa̱yaꞌ iwá̱n a̱ꞌyéj ito̱ka̱ꞌ yej nigaj ijkuilijtoꞌ? Yejemej kijtojkej: —Rey César. ");
INSERT INTO nhx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Iwá̱n Jesús kijtoj: —Xikmakaka̱n rey César yej yéjpa itatki, iwá̱n xikmakaka̱n Dios yej yéjpa itatki. Iwá̱n fariseojmej san tajtachi̱xtikajkej iga yej kijtoj. ");
INSERT INTO nhx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Iwá̱n sekin saduceojmej yajkij kitatoj Jesús. Yejemej kijtowaj iga yej mikij ayoꞌ ojpa‑isaj, iwá̱n ijkí̱n kitajtankej: ");
INSERT INTO nhx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tamachtia̱ni, Moisés ne‑ijkuilowilijtikajkej iní̱n ley; siga se̱ ta̱gaꞌ miki, iwá̱n kika̱wa isiwa̱ꞌ, eꞌ ayá̱ꞌ kikajte̱wa nisé̱ ipiltzi̱n, iyikni̱n inó̱n yej miguiꞌ, kikuis inó̱n viuda iga ken kua̱ꞌ makipiá ipilowa̱n yej miguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Onoyaj siete tajta̱gaꞌ yej se̱san itajmej iwá̱n se̱san iye̱mej. Yej te̱ko̱ko achto mona̱miktij, eꞌ miguiꞌ kua̱ꞌ aya pilwaj. ");
INSERT INTO nhx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Iwá̱n imá̱mil inó̱n yej miguiꞌ mona̱miktij iwá̱n yej katka isiwa̱ꞌ yej miꞌ, iwá̱n no̱ miguiꞌ, iwá̱n ayá̱ꞌ no̱ kikajtej ipilowa̱n. Iwá̱n ijko̱nsan no̱ mochij iwá̱n seꞌ imá̱mil. ");
INSERT INTO nhx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ijkó̱n ino̱mej siete, nochi mona̱miktijkaj iwá̱n ino̱nsan siwa̱ꞌ, iwá̱n ayagaj kikajtej ipiltzi̱n. Iwá̱n má̱j má̱j miguiꞌ no̱ siwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","In kua̱ꞌ ojpa‑isaskej yej miktokej, ¿katiapa a̱n de inó̱n siete mochi̱was iwé̱j in inó̱n siwa̱ꞌ?, iga na̱miktitoya iwá̱n inochimej. ");
INSERT INTO nhx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús kijtoj: —Amejeme̱n ayompa antajla̱mikij iga ayá̱ꞌ anki̱xmatij itájto̱l Dios, niga yej wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kua̱ꞌ yej miktokej ojpa‑isaskej, ayꞌya mona̱mikti̱skej, niga ipilowa̱n ayoꞌ kina̱mikti̱skej, iga mochi̱waskej ken tikita iya̱ngelejmej Dios yej onokej ipan cielo yej no̱ ayá̱ꞌ mona̱miktiáj. ");
INSERT INTO nhx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Eꞌ iga ojpa‑isaskej yej miktokej, ¿ix ayí̱ꞌ nokta ankilee̱rowaj ka̱n kén iga Dios tajtoj ipan se̱ witztako̱ꞌ yej we̱welo̱ntoya? Eꞌ Dios kijlij Moisés: “Nej niDio̱s, yej iDio̱spa no̱ Abraham, Isaac iwá̱n Jacob.” ");
INSERT INTO nhx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Dios ayéj iDio̱s yej miktokej, sino que iDio̱s yej isatokej; amejeme̱n ayompa antajla̱mikij. ");
INSERT INTO nhx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ompa asito no̱ se̱ yej tamachtiá ipan iley Moisés; yéj takaktoya kua̱ꞌ Jesús ta̱tapojtoya iwá̱n kimatiá iga ompay ken kijlij yej íwa̱n ta̱tapojtoya. Kitajtan: —De inewi mandamiento yej onoꞌ, ¿katiapa a̱n yej achto? ");
INSERT INTO nhx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús kijtoj: —Yej má̱j achto mandamiento ijkí̱n kijtowa: “Taꞌ xikaki, gente de Israel, toTe̱ko Dios, yéjsan ise̱lti toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Xikcho̱kili moTe̱ko Dios iga inewi moa̱lmaj, iwá̱n iga inochi moespí̱ritoj iwá̱n iga inewi motájpal iwá̱n yéj nochipa xikejla̱nto.” Ini̱nwaꞌ in yej má̱j achto mandamiento. ");
INSERT INTO nhx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Iwá̱n onoꞌ sewoꞌ áchisan ijko̱mpa, kijtowa: “Xikcho̱kili mokni̱n kensan tej timocho̱kiliá.” Ateyi seꞌ mandamiento yej má̱j vale̱rowa ken ini̱mej. ");
INSERT INTO nhx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iwá̱n inó̱n yej tamachtiá ipan la ley kijlij: —Ompay ken tikijtoj Tamachtia̱ni iga onoꞌ se̱san Dios, iwá̱n ateyi seꞌ ken yéj. ");
INSERT INTO nhx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Iwá̱n iga matiknekika̱n toDio̱s iga inewi toa̱lmaj, iga inewi toespí̱ritoj iwá̱n iga inewi totájpal, iwá̱n yéj nochipa matikejla̱ntoka̱n iwá̱n matikcho̱kili̱ka̱n tokni̱n kensan tejemej timocho̱kiliáj. Iga ijkó̱n mochi̱wa má̱j vale̱rowa que nochi ofrenda yej motatiá iga momaka Dios. ");
INSERT INTO nhx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Kua̱ꞌ Jesús kitaꞌ iga ómpaya ken kijtoj, kijlij: —Ali̱nsan poliwi iga Dios marreina̱ro ipan tej. Iwá̱n ayoꞌ agaj má̱j mi̱xe̱wij iga kitajtajtan. ");
INSERT INTO nhx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús tamachtijtoya tio̱pan; kijtojtoya: —¿Te iga yej tamachtiáj ipan la ley kijtowaj iga Cristo ipiltzi̱n David? ");
INSERT INTO nhx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porque David kijtoj kua̱ꞌ kitajto̱lmáꞌ iyEspí̱ritoj Dios, kijtoj ijkí̱n: ToTe̱ko kijlij noTe̱ko: “Ximota̱li ila̱doj noye̱ꞌma̱ꞌ ka̱n nimanda̱rowa, este que manikta̱li mokxitampa yej mitzijiyaj.” ");
INSERT INTO nhx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Kén wel Cristo yej itati̱tan Dios ma‑ipiltzi̱n David, esi David no̱ kijliá iga iTe̱ko? Iwá̱n yej po̱lijtoyaj kiye̱ꞌkaktoyaj. ");
INSERT INTO nhx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús ijkí̱n tamachtia̱ya: —Amo mamitzkajkaya̱waka̱n yej tamachtiáj ipan iley Moisés, puej kiye̱ꞌmatij iga makinenti̱ka̱n sota̱ntzótzol, iwá̱n kinekij makisaluda̱ro̱ka̱n tajkoa̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yejeme̱n mota̱li̱jnekij tio̱pan‑ijtiꞌ ipan ye̱ꞌasie̱ntoj ka̱n mota̱liáj yej má̱j tayaka̱ntokej, iwá̱n ijko̱nsan no̱ kinekij makichi̱waka̱n ka̱n takualo, ");
INSERT INTO nhx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","iwá̱n kikui̱liáj ikalmej yej we̱wejmikikej, iwá̱n mopajpantiáj iga wejka̱waj iga ora̱dowaj. Yejeme̱n má̱j yawij kicastiga̱ro̱tij. ");
INSERT INTO nhx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Se̱ ve̱j Jesús e̱watoya tio̱pan, kitztoya kén iga kakia̱yaj iyofre̱ndajmej ipan cajo̱n, iwá̱n miaꞌ yej motapialiáj kakia̱yaj komati tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iwá̱n wa̱laj se̱ yej ayá̱ꞌ motapialiá iwá̱n ipan cajo̱n kakij o̱me tomi̱n de cobre yej ayá̱ꞌ pox vale̱rowa. ");
INSERT INTO nhx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iwá̱n Jesús kino̱tzaꞌ idisci̱polojmej, kijlijkej: —Nimitznojma‑ijliáj iga iní̱n siwa̱ꞌ yej we̱wejmíꞌ, yej ayá̱ꞌ motapialiá, kakij má̱j que nochi yej nemi kakiáj tomi̱n ipan cajo̱mej; ");
INSERT INTO nhx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","puej nochi kita̱lijkej yej kisobra̱rowaj; eꞌ yéj, malej ayá̱ꞌ motapialiá, kimáꞌ inewi yej kipiaya iga takua̱ya. ");
INSERT INTO nhx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kua̱ꞌ Jesús ki̱saꞌ weyitio̱pan, se̱ idiscí̱poloj kijlij: —¡Tamachtia̱ni, taꞌ xikita kejke̱ꞌpa teꞌti, iwá̱n kejke̱ꞌpa kalwe̱wetkej! ");
INSERT INTO nhx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Eꞌ Jesús kijtoj: —¿Ankitaj ini̱mej kalwe̱wetkej? Nigaj ayá̱ꞌ yawi ka̱witi nisé̱ teꞌti yej mane̱nekpanijto. Nochi yawij moxijxiti̱natij. ");
INSERT INTO nhx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jesús iwá̱n idisci̱polojmej yajkij ipan tepe̱ꞌ yej ito̱ka̱ꞌ Olivos, yej onoꞌ iyi̱xtaj weyitio̱pan. Iwá̱n kua̱ꞌ Jesús e̱watoꞌ ompiga, Pedro, Jacobo, Juan iwá̱n Andrés, ijkí̱n kichtakatajtankej: ");
INSERT INTO nhx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Niknekij xine‑ijli̱ka̱n ké̱man mochi̱was in inó̱n. ¿Té̱ mo‑itas kua̱ꞌ ayoꞌ wejka iga nochi iní̱n mochi̱was? ");
INSERT INTO nhx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús kijtoj: —Amo agaj mitzkajkaya̱waskej, ");
INSERT INTO nhx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","iga miaꞌ yawij wi̱tzetij iwá̱n mopajpanti̱skej iga nej, sie̱mpa ayéj. Ijkí̱n kijto̱skej: “Nejya el Cristo”; iwá̱n miaꞌ yawij kikajkaya̱watij. ");
INSERT INTO nhx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Eꞌ kua̱ꞌ amejeme̱n ankikakiskej momijmiktilo nijnijiga, amo ximajmawika̱n, ijkó̱n nokta yawi mochi̱wati; eꞌ aya yej iga poliwilo̱j. ");
INSERT INTO nhx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Iga se̱ país momijmikti̱j iwá̱n sewoꞌ, iwá̱n se̱ nación momijmikti̱j iwá̱n seꞌ; onos ta̱lo̱li̱n nijnijiga, iwá̱n poxsan a̱pistajtiás iwá̱n nijnijiga mokuejkueso̱lo̱j; Nochi iní̱n aya yéj iga poliwilo̱j, pé̱waoꞌ iga mokno̱chi̱walo. ");
INSERT INTO nhx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Eꞌ ximocuida̱ro̱ka̱n amejéme̱nsan iga mitzwi̱gaskej ka̱n onokej yej manda̱rowaj iwá̱n tio̱pan mitzmagaskej, iwá̱n iga anne̱tokaj mitzwi̱gaskej iyi̱xtaj yej manda̱rowaj iwá̱n re̱yejmej; ijkó̱n iga wel antajto̱skej de nej iyi̱xtajmej. ");
INSERT INTO nhx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Eꞌ kua̱ꞌ aya poliwilo, mopowas no̱ya̱n ipan ta̱jli kén iga Dios tama̱nawiá. ");
INSERT INTO nhx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Eꞌ kua̱ꞌ mitzwi̱gaskej iyi̱xtaj yej manda̱rowaj, amo xitayo̱koyaka̱n iga te̱ ankijto̱skej, niga xike̱ejla̱ntoka̱n. Ankijto̱skej yej íkua̱ꞌ Dios mitzijli̱skej iga xikijto̱ka̱n; iga ayéj amejeme̱n yej antajto̱skej, sino que iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Se̱ tokni̱n yawi kite̱lwi̱ti iyikni̱n iga makimikti̱ka̱n, iwá̱n te̱taj kite̱lwi̱j ipiltzi̱n iga makimikti̱ka̱n, iwá̱n te̱pilowa̱n kite̱lwi̱skej itajmej iga makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nochi yawij mitzijiyatij iga nej anne̱tokaj; eꞌ yej moconfia̱rojtoꞌ nochipa ipan nej, inó̱n moma̱nawi̱j. ");
INSERT INTO nhx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’El profeta Daniel kijkuiloj iga mochi̱was yej pox aye̱kti weyitio̱pan‑ijtiꞌ; kua̱ꞌ amejeme̱n ankitaskej iga onoꞌ yej akajasi iga maono weyitio̱pan‑ijtiꞌ, —yej kilee̱rowa makentende̱ro—, yej onoskej ipan estado de Judea, mayá̱ka̱nya ipan tepe̱yoj. ");
INSERT INTO nhx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yej onos iyi̱xko kajli ipan ipetayo, ayoꞌ matemo, niga makalaki iga makikijki̱xti yej kipiá kalijtiꞌ; ");
INSERT INTO nhx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","iwá̱n yej nemi imi̱lpan, ayoꞌ mayawi icha̱n iga makikuiti itzótzol. ");
INSERT INTO nhx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Lástima siwa̱tkej inó̱n día iga yej tatalaxwijtokej iwá̱n yej tachi̱chitijtokej! ");
INSERT INTO nhx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xiktajtanili̱ka̱n Dios iga kua̱ꞌ ancholo̱skej amo kua̱ꞌ sektaj; ");
INSERT INTO nhx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","porque ino̱mej días poxsan mokno̱chi̱walo̱j, este ayí̱ꞌ ijkó̱n mo‑itaꞌ desde iga kichij Dios iní̱n ta̱jli, iwá̱n ayí̱ꞌ ijkó̱n mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Siga toTe̱ko ayá̱ꞌ kixelo̱j ino̱mej días, ayagaj moma̱nawi̱j; eꞌ kixelo̱j iga kicho̱kiliá ino̱mej yej yéjpa kitapejpen. ");
INSERT INTO nhx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Iwá̱n siga agaj mitzijli̱skej: “Taꞌ xikitaka̱n nigaj onoꞌ Cristo”, o “Taꞌ xikitaka̱n nepa onoꞌ”, amejeme̱n amo xiktajto̱lkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iga yawij wi̱tzetij iwá̱n mopanti̱skej iga nej, sie̱mpa ayéj, kijto̱skej “Nejya niCristo”, iwá̱n kijto̱skej iga yejeme̱n profe̱tajmej iga Dios kita̱jto̱lmakaj, sie̱mpa takajkaya̱waj. Yawij kichi̱watij mila̱grojmej yej ayi̱ꞌpa mo‑ita iga matakajkaya̱waka̱n, este wel anka kikajkaya̱waskej yej Dios kitapejpen. ");
INSERT INTO nhx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Eꞌ xikye̱ꞌkakika̱n, iga áchtoya nochi nimitzmati̱ltijkej. ");
INSERT INTO nhx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesús kijtoj: —Kua̱ꞌ páno̱jya ino̱mej días iga mokno̱chi̱walo̱j, yawi tako̱mitiati iga ayꞌ ta̱wi̱j to̱nati̱ꞌ, niga ayꞌya tame̱tzto̱nas; ");
INSERT INTO nhx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","si̱talimej yej onokej ipan cielo wejwetziskej, nochi yej onoꞌ ipan cielo mojo̱li̱naskej. ");
INSERT INTO nhx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Íkua̱ꞌya ne‑itaskej nej yej iPiltzi̱n Ta̱gaꞌ yej niwi̱ꞌ ipan mixti, nita̱wijtiwi̱ꞌ iga noweyipode̱r. ");
INSERT INTO nhx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Iwá̱n niktekimakas noa̱ngelejmej iga recio matapi̱tzaka̱n iga trompeta iga makinejnechko̱ka̱n yej niktapejpen yej nijnijiga onokej no̱ya̱n ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Ximi̱xkui̱ti̱ka̱n ipan higue̱rajkuawiꞌ: Kua̱ꞌ ankitaj némiya ki̱sa iseliska iwá̱n némiya iswayowi, ankimatij iga wi̱ꞌya to̱nalis. ");
INSERT INTO nhx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ijko̱nsan no̱ kua̱ꞌ ankitaskej iga némiya mochi̱wa nochi yej nimitzijlijkej, xikmatika̱n iga ayꞌya ke̱ꞌ poliwi iga nej níwi̱ꞌya sej. ");
INSERT INTO nhx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nimitzijliáj iga nochi iní̱n mochi̱was kua̱ꞌ aya mikij yej iná̱n onokej. ");
INSERT INTO nhx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Cielo iwá̱n ta̱jli poliwiskej, eꞌ yej nikijtoj, nochi yawi mochi̱wati. ");
INSERT INTO nhx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Eꞌ ayagaj nokta kimati te̱ día o te̱ hora, ayagaj kimati, niga a̱ngelejmej yej onokej ipan cielo, niga nej yej iPiltzi̱n Dios, isé̱ltisan noTaj Dios kimati. ");
INSERT INTO nhx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Inó̱n iga amejeme̱n xisatoka̱n, xitachi̱xtoka̱n iwá̱n xikte̱ne̱wijtoka̱n Dios iga ayá̱ꞌ ankimatij ké̱man mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nej ken se̱ ta̱gaꞌ yej yajki wejka, kua̱ꞌ aya ki̱sa icha̱n, kitekimáꞌ itekipanowa̱nimej, sejsé̱ kimáꞌ itekipáno̱l iwá̱n kiti̱tan iga se̱ matachi̱xto ipan kalte̱n. ");
INSERT INTO nhx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Amejeme̱n xisatoka̱n iga ayá̱ꞌ ankimatij ke̱man wi̱ꞌ ite̱ko kajli, tayowaka̱n, o tajkoyówal, o kua̱ꞌ takui̱ka ka̱yo, o yowaltiꞌ; ");
INSERT INTO nhx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","amo santá̱ꞌ niwe̱jki̱saki iwá̱n nimitzasikij ankojkochtokej. ");
INSERT INTO nhx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Yej nimitzijliáj amejeme̱n, nochi nikijliáj: xisatoka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Poliwiasan dos días iga mo‑ilwichi̱wiliá la Pascua, iwá̱n iga mokua pa̱n yej ayá̱ꞌ kipiá levadura. Ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés kite̱mowilia̱yaj kén iga makiki̱tzki̱ka̱n Jesús malej iga matakajkaya̱wáka̱mpa iwá̱n makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kijtowa̱yaj: —Ayá̱ꞌ tikchi̱waskej kua̱ꞌ nentoꞌ ilwiꞌ, iga amo makuesiwilo. ");
INSERT INTO nhx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mie̱j Jesús onoya ipan a̱ltepe̱tzi̱n yej ito̱ka̱ꞌ Betania, onoya icha̱n Simón yej kipiaka lepra. Mie̱j ki̱xna̱ntoya mesa, asiꞌ se̱ siwa̱ꞌ yej kinentia̱ya se̱ bote̱yajtzi̱n yej chijtoꞌ iga teꞌti yej ito̱ka̱ꞌ alabastro. Ípan kiwi̱gaꞌ aceite yej ajwiya̱ꞌ yej kijliáj nardo yej pox patiyoj; iwá̱n inó̱n siwa̱ꞌ kikechposteꞌ bote̱yajtzi̱n, iwá̱n kitoya̱wilij ipan itzontekon Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Eꞌ sekin yej ompa kitajtachi̱lijtoyaj, kuesiwikej iwá̱n kijtojkej: —¿Te iga kiyokatoyajkej iní̱n aceite yej pox ajwiya̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Masejtaj monamáꞌ iga ke̱ꞌ se̱ kita̱niá trescientos días iga mamomajmaka yej ayá̱ꞌ motapialiáj. Iwá̱n kajajwakej inó̱n siwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Eꞌ Jesús kijtoj: —Xika̱waka̱n. ¿Te iga ankikuejkuesowaj? Yéj ne̱chi̱wilij yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Yej ayá̱ꞌ motapialiáj, nochipa onoskej amowa̱n, iwá̱n kua̱ꞌ ankinekiskej wel ankipale̱wiáj; eꞌ nej ayá̱ꞌ nochipa nij anne̱piaskej. ");
INSERT INTO nhx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Iní̱n siwa̱ꞌ kichij yej wel kichí̱, machtówija iga ne̱ta̱lilij yej ajwiya̱ꞌ ipan notzontekon, iga ijkó̱n ne̱chi̱wili̱skej kua̱ꞌ yawij ne̱to̱katij. ");
INSERT INTO nhx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nimitzijliáj iga ka̱nsan ipan inewi iní̱n ta̱jli mopowas kén iga Dios tama̱nawiá, yawi no̱ mopowati yej kichij iní̱n siwa̱ꞌ, iwá̱n ijkó̱n moejla̱mikis yej kichij. ");
INSERT INTO nhx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, se̱ de ino̱mej doce idiscí̱polojpa Jesús, yajki kitato ije̱fejmej sacerdo̱tejmej iga kijli̱to iga yéj yawi kipale̱wi̱ti iga makiki̱tzki̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kua̱ꞌ yejeme̱n kikakikej inó̱n, poxsan pa̱kikej iwá̱n kijlikej Judas iga yawij kimakatij tomi̱n. Iwá̱n íkua̱ꞌya Judas pe̱waꞌ iga kite̱moj ké̱man wel makiki̱tzki̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ipan día kua̱ꞌ pe̱waꞌ iyilwiyo la Pascua, kua̱ꞌ mokua pan yej ayá̱ꞌ kipiá levadura, momiktiá se̱ borre̱gojtzi̱n iga mokua, disci̱polojmej kitajtankej Jesús: —¿Ka̱n tikneki manimitzchi̱wili̱tij tákual iga tikilwichi̱wili̱skej la Pascua? ");
INSERT INTO nhx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Iwá̱n Jesús kiti̱tan o̱me̱n idisci̱polojmej, kijlij: —Xa̱ka̱n Jerusalén, iwá̱n ompa ankitecho̱skej se̱ ta̱gaꞌ kiwi̱ga a̱ꞌti ipan a̱ko̱miꞌ. Inó̱n xiktokaka̱n, ");
INSERT INTO nhx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","iwá̱n ka̱n yéj kalakis, xikijli̱ka̱n ite̱ko inó̱n kajli: “Kijtowa in Tamachtia̱ni: ¿Ipan katiapa cuarto nicena̱ro̱j ipan iyilwi la Pascua iwá̱n nodisci̱polojmej?” ");
INSERT INTO nhx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ite̱ko kajli yawi mitzne̱xtili̱tij se̱ weyi cuarto pan segundo piso ka̱n ónoꞌya nochi yej ankinekiskej, ompa xikchi̱waka̱n yej tikua̱skej. ");
INSERT INTO nhx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Disci̱polojmej yajkij iwá̱n asikej a̱ltepe̱ꞌ, iwá̱n kasikej nochi kensan kijtoj Jesús; iwá̱n ompay kichijkej tákual iga kilwichi̱wiliáj la Pascua. ");
INSERT INTO nhx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kua̱ꞌ tayowátiꞌya, Jesús iwá̱n doce idisci̱polojmej, yajkij ompa. ");
INSERT INTO nhx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kua̱ꞌ ki̱xna̱ntókeja mesa iga takuaj, Jesús kijtoj: —Nimitznojma‑ijliáj iga se̱ de amejéme̱mpa yej nemi nigaj íwa̱n nisentakua, yawi ne̱ne̱xti̱ti iga mane̱ki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iwá̱n yejemej mokno̱matikej, mosepantajtaniáj: —¿Ix nejya a̱n? Seꞌ no̱ kijtoj: —¿Ix nejya a̱n? ");
INSERT INTO nhx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús kijtoj: —Se̱ de amejeme̱n yej ando̱cejmej, yej íwa̱n nemi nisentakua ipansan iní̱n plato, ino̱nwaꞌ in yej yawi ne‑ichtakane̱xti̱ti iga mane̱mikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nimitzijliáj iga nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱mikti̱tij ken ijkuilijtoꞌ; eꞌ ¡lá̱stimaj inó̱n ta̱gaꞌ yej yawi ne‑ichtakane̱xti̱ti iga mane̱mikti̱ka̱n! Má̱j ye̱kti katka iga inó̱n ta̱gaꞌ amo maki‑onolti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mie̱j nemi takuaj, Jesús kikuiꞌ se̱ pa̱n, kimáꞌ gracias Dios iwá̱n kita̱tajkoloj iga kimajmáꞌ idisci̱polojmej. Kijtoj: —Xikuika̱n iní̱n pa̱n iwá̱n xikua̱ka̱n, ini̱nwaꞌ nocue̱rpoj. ");
INSERT INTO nhx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Iwá̱n Jesús kikuiꞌ vaso yej kipiá vino, kimáꞌ gracias Dios, iwá̱n kimajmáꞌ idisci̱polojmej, iwá̱n inochi̱n konijkej. ");
INSERT INTO nhx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesús kijtoj: —Iní̱n kijto̱jneki noesyo iga nikchi̱wa seꞌya pacto, iwá̱n toya̱wis iga miaꞌ maye̱ꞌono iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nimitzijliáj iga ayoꞌ má̱j nikoni̱j uva iya̱yo, nikoni̱j sej nuevo vino este kua̱ꞌ nonos ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kua̱ꞌ tamiꞌ kitakui̱kilijkej Dios, yajkij ipan se̱ tepe̱ꞌ yej ito̱ka̱ꞌ Olivos. ");
INSERT INTO nhx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iwá̱n Jesús kijtoj: —Amejeme̱n amonochi̱n ankikajte̱waskej iga anmoconfia̱rowaj ipan nej iní̱n yówal iga ijkí̱n ijkuilijtoꞌ: “Nikmikti̱j ite̱ko borre̱gojmej, iwá̱n borre̱gojmej pa̱payi̱niskej.” ");
INSERT INTO nhx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Eꞌ kua̱ꞌ ni‑ojpa‑isas sej, kua̱ꞌ anya̱skej Galilea, nej achto nia̱ti. ");
INSERT INTO nhx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pedro kijtoj: —Malej iga inochi̱n mamitzsenkokajte̱waka̱n, eꞌ nej ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Eꞌ Jesús kijtoj: —Nimitznojma‑ijliá iga iní̱n yówal, kua̱ꞌ aya takui̱ka ka̱yo o̱me ve̱j, tej e̱yi ve̱jya tikijto̱j iga ayá̱ꞌ tine‑i̱xmati. ");
INSERT INTO nhx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Eꞌ Pedro sej kijlij Jesús: —Malej iga matisenmikika̱n, nej ayá̱ꞌ nikito̱j iga ayá̱ꞌ nimitzi̱xmati. Iwá̱n inochi̱n ijkó̱n kijtojkej. ");
INSERT INTO nhx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iwá̱n asikej ka̱n kijliáj Getsemaní, iwá̱n kijlij idisci̱polojmej: —Nijoꞌ ximota̱li̱ka̱n, nej maniaoꞌ manitajto̱ti wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kiwi̱gákejsan petz Pedro, Jacobo iwá̱n Juan ka̱n ora̱do̱to. Iwá̱n Jesús pe̱waꞌ iga poxsan mokno̱matiꞌ iwá̱n moyo̱lmiktij. ");
INSERT INTO nhx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Iwá̱n kijtoj: —Poxsan nimokno̱mati este ken nimikisnékiya. Nijoꞌ xika̱wika̱n wa̱n xisatoka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Iwá̱n Jesús yajki achi má̱j wejka, iwá̱n motankua̱ketzaꞌ ta̱lpan iga kitajtanilij Dios siga wel amo makikno̱chi̱waka̱n ken yawij kichi̱wili̱tij íkua̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ijkí̱n kite̱ne̱wij Dios: —NoTaj, noPa̱paj tej nochi wel tikchi̱wa; xine̱ma̱nawi kua̱ꞌ yawij ne‑ikno̱chi̱watij, eꞌ amo mamochi̱wa ken nej nikneki, mamochi̱wa ken tej tikneki. ");
INSERT INTO nhx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iwá̱n Jesús yajki sej ka̱n onoꞌ idisci̱polojmej, kasitoj kojkochtokej; iwá̱n Jesús kijlij Pedro: —Simón, ¿ixtaj tikochtoꞌ? ¿Ix awel achi xisato malej se̱ hora? ");
INSERT INTO nhx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xisatóka̱nya, iwá̱n xi‑ora̱do̱ka̱n iga amo mamitzta̱nili̱ka̱n Tzitzimiꞌ. Nikmati iga amoa̱lmaj kineki xikchi̱waka̱n ken nej nikneki, eꞌ amogá̱najsan awel ankichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yajki sej ora̱do̱to iwá̱n kijtoj inó̱mejsan tájto̱l ken achto. ");
INSERT INTO nhx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kua̱ꞌ sej yajki ka̱n onokej idisci̱polojmej, sej kasitoj kojkochtokej iga poxsan kochisnekiáj, inó̱n iga aweljoꞌ te̱ kijtojkej. ");
INSERT INTO nhx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kua̱ꞌ e̱yi ve̱jya iga ora̱do̱to̱yay, kijtoj: —¿Ix ankojkochtókejoꞌ? ¿Nemi anmose̱wiáj? Wí̱tzeja yej kipoxchi̱waj yej aye̱kti iga yawij ne̱ki̱tzki̱tij nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ximoketzaka̱n, matiá̱ka̱nya; wi̱ꞌya yej ne̱ne̱xtiá. ");
INSERT INTO nhx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús ta̱tapojtóyaoꞌ kua̱ꞌ asiko Judas, se̱ de inó̱n doce yej idiscí̱polojpa katka. Judas wa̱laj iwá̱n miaꞌ gente yej kiwajligakej espada iwá̱n kuawiꞌ. Ino̱mej kiti̱tankej ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan la ley iwá̱n yej kimanda̱rowaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ijkí̱n kijtoj Judas kua̱ꞌ aya kine̱xtiá katiá in Jesús: —Yej ankitaskej nikpipitzo̱j, ino̱nya nokta xiki̱tzki̱ka̱n iwá̱n xikye̱ꞌilpitia̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kua̱ꞌ asiꞌ ite̱noj Jesús, kijlij: —Tamachtia̱ni, Tamachtia̱ni. Iwá̱n kipipitzoj. ");
INSERT INTO nhx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Iwá̱n kiki̱tzkijkej Jesús, iwá̱n kiwi̱gakej. ");
INSERT INTO nhx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Eꞌ se̱ de ino̱mej yej onoya iwá̱n Jesús, kiki̱xtij iyespa̱daj, iwá̱n kinagastéꞌ itekipanowa̱ni ije̱fej sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iwá̱n Jesús kijtoj: —¿Ix anwa̱lkej anne̱kuikoj ken kua̱ꞌ se̱ yej tachteꞌ? ¿Ix inó̱n iga ankiwajligakej espada iwá̱n kuawiꞌ? ");
INSERT INTO nhx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nej nochipa nonoya amowa̱n iga nitamachtijtoya weyitio̱pan, iwá̱n ayí̱ꞌ anne̱ki̱tzkijkej. Eꞌ iní̱n nemi mochi̱wa kensan ijkuilijtoꞌ ipan itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iwá̱n nochi disci̱polojmej kikajtejkej ise̱lti Jesús, iwá̱n chojcholojkej. ");
INSERT INTO nhx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Eꞌ se̱ chokotzi̱n kitokatia̱ya Jesús, tejkuixtia̱ya iga se̱ tzótzol, iwá̱n kiki̱tzkijkej; ");
INSERT INTO nhx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","eꞌ yéj ompa kikajtej itzótzol iwá̱n choloj ipetzka̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iwá̱n kiwi̱gakej Jesús iyi̱xtaj ije̱fej sacerdo̱tejmej, iwá̱n ompa monechkojkej sacerdo̱tejmej yej tayaka̱ntokej, yej kimanda̱rowaj judiyojmej iwá̱n yej tamachtiáj ipan la ley. ");
INSERT INTO nhx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Eꞌ Pedro kiwejkatokatiajki Jesús, este ipan ipa̱tioj ije̱fej sacerdo̱tejmej, iwá̱n Pedro mota̱lij wa̱n policiyajmej; moskojtoyaj tite̱noj. ");
INSERT INTO nhx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ije̱fejmej sacerdo̱tejmej iwá̱n nochi yej kimanda̱rowaj judiyojmej, kite̱mowa̱yaj tejté̱ yej mane̱si iga Jesús kichij yej aye̱kti iga wel makimikti̱ka̱n; eꞌ ayá̱ꞌ kasilia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iwá̱n miaꞌ yej kipantia̱yaj Jesús, eꞌ ayá̱ꞌ se̱san itajto̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Iwá̱n sekin tajtojkej iga kipantijkej Jesús, kijtojkej: ");
INSERT INTO nhx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Nejeme̱n nikakikej iga Jesús kijtoj ijkí̱n: “Nej nia nikxi̱xiti̱nati iní̱n weyitio̱pan yej tama̱chí̱wal, iwá̱n ipan e̱yi días nia sej nikchi̱wati seꞌ yej ayéj tama̱chí̱walpa.” ");
INSERT INTO nhx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Eꞌ malej ijkó̱n kipantia̱yaj, ayá̱ꞌ sansé̱ kijtowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Iwá̱n ije̱fej sacerdo̱tejmej moketzaꞌ iyi̱xtaj sekin, iwá̱n kitajtan Jesús: —¿Aya̱ꞌtaj titajtowa achi? ¿Ix ayá̱ꞌ tikaki iga nemi mitzte̱lwiáj? ");
INSERT INTO nhx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Eꞌ Jesús atajtoj. Ije̱fej sacerdo̱tejmej sej kitajtan: —¿Ix tejya in tiCri̱stoj yej iPiltzi̱n Dios yej kiweyimati̱ltiáj? ");
INSERT INTO nhx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús kijtoj: —Nejya nokta. Anyawij anne‑itatij nej yej iPiltzi̱n Ta̱gaꞌ ne̱watos ila̱doj iye̱ꞌma̱ꞌ Dios yej nochi wel kichi̱wa, iwá̱n anne‑itaskej nemi niwi̱ꞌ ipan mixti cie̱lojkóbapa. ");
INSERT INTO nhx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iwá̱n ije̱fej sacerdo̱tejmej, kitza̱tzaya̱n itzótzol iga kuejkuesiwiꞌ iwá̱n kijtoj: —Ayoꞌ tiknekij agaj má̱j mate‑ijli de yéj. ");
INSERT INTO nhx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Amejeme̱n ankikakikej iga kima̱lijlij Dios; ¿kén ankijtowaj amejeme̱n? Iwá̱n inochi̱n kijtojkej iga mamomíktiya. ");
INSERT INTO nhx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sekin pe̱wakej iga kichijchakej, iwá̱n ki̱xtzakkej iwá̱n kimagakej, kijlia̱yaj: —¡Siga tiprofe̱taj, taꞌ xikijto a̱ꞌyéj mitzmagaꞌ! Iwá̱n policiyajmej kixa̱ygatatzi̱nkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedro onoya tani ipan patio, iwá̱n íkua̱ꞌ ompa asiꞌ se̱ isirvie̱ntaj ije̱fej sacerdo̱tejmej; ");
INSERT INTO nhx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","iwá̱n kua̱ꞌ kitaꞌ iga Pedro nemi moskowa tite̱noj, kitachi̱lijtiká̱ꞌ, iwá̱n kijlij: —Tej no̱ tinemiá iwá̱n Jesús de Nazaret. ");
INSERT INTO nhx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Eꞌ Pedro kijtoj iga ayá̱ꞌ, kijtoj: —Aniki̱xmati, niga nikmati de te̱ nemi titajtowa. Iwá̱n Pedro ki̱saꞌ jue̱rájbapa ka̱n kalakilo, iwá̱n íkua̱ꞌ takui̱gaꞌ se̱ ka̱yo. ");
INSERT INTO nhx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Iwá̱n inó̱n sirvienta sej kitachi̱lijtiki̱saꞌ Pedro, iwá̱n kijlij yej ompa ojonokej: —Iní̱n ta̱gaꞌ de yejéme̱mpa. ");
INSERT INTO nhx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Eꞌ Pedro sej kijtoj iga aki̱xmati Jesús. Ayá̱ꞌ wejkatiꞌ, yej ompa onoyaj sej kijlijkej Pedro: —Mataj tejwaꞌ tinemiá no̱ iwá̱n yejemej; tej de Galilea iga nikakij titajtowa kensan yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Iwá̱n Pedro kijtoj iga kitztoꞌ Dios iwá̱n makikno̱chi̱wa siga takajkaya̱wa, iwá̱n kijtoj: —Ayá̱ꞌ niki̱xmati inó̱n ta̱gaꞌ yej nemi anne‑ijliáj. ");
INSERT INTO nhx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Iwá̱n íkua̱ꞌ takui̱gaꞌ sej in ka̱yo. Iwá̱n Pedro kejla̱n yej kijtoj Jesús: “Kua̱ꞌ ka̱yo aya takui̱ka o̱me ve̱j, tej tia tikijto̱ti e̱yi ve̱j iga ayá̱ꞌ tine‑i̱xmati.” Iwá̱n kua̱ꞌ Pedro inó̱n kejla̱n, pe̱ꞌ iga cho̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kua̱ꞌ tane̱siꞌ, ije̱fejmej sacerdo̱tejmej monechkojkej iwá̱n we̱wetkej yej kimanda̱rowaj judiyojmej, iwá̱n yej tamachtiáj ipan la ley iwá̱n nochi yej kimanda̱rowaj judiyojmej. Iwá̱n Jesús kilpitiajkij iga kika̱watoj iyi̱xtaj pilato. ");
INSERT INTO nhx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato kitajtan: —¿Ix tejya in iRre̱y judiyojmej? Jesús kijtoj: —Ijko̱nya ken tej tikijtowa. ");
INSERT INTO nhx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iwá̱n ije̱fejmej sacerdo̱tejmej kitejte̱lwia̱yaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Iwá̱n Pilato sej kitajtan Jesús: —¿In tej atikijtowa nité̱? Taꞌ xikaki nochi yej mitzijliáj iga mitzte̱lwiáj. ");
INSERT INTO nhx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Eꞌ Jesús nité̱ akijtoj; inó̱n iga Pilato poxsan madmira̱doj. ");
INSERT INTO nhx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ipan iyilwi la Pascua, Pilato nochipa kimajka̱waya se̱ preso yej la gente kitapejpenaya. ");
INSERT INTO nhx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Onoya se̱ preso yej ito̱ka̱ꞌ Barrabás; sen‑onoyaj iwá̱n sekin yej no̱ tamiktijkej kua̱ꞌ yajkij ico̱ntraj igobie̱rnoj. ");
INSERT INTO nhx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Iwá̱n miaꞌ wa̱lkej, iwá̱n pe̱ꞌ kijlijkej Pilato iga makimajka̱wa se̱ ken kitekichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilato kijtoj: —¿Ix ankinekij manikmajka̱wa iRre̱y judiyojmej? ");
INSERT INTO nhx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Iní̱n kijtoj iga kimatiá iga ije̱fejmej sacerdo̱tejmej ki̱xitayaj Jesús, inó̱n iga kiwi̱gakej iyi̱xtaj. ");
INSERT INTO nhx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Eꞌ ije̱fejmej sacerdo̱tejmej kitejtekimakakej la gente iga makitajtanika̱n iga makimajka̱waka̱n Barrabás. ");
INSERT INTO nhx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Iwá̱n Pilato sej tatajtan: —¿Té̱ ankinekij manikchi̱wili yej ankijliáj iRre̱y judiyojmej? ");
INSERT INTO nhx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yejeme̱n tzajtzíkejpa iga kijtojkej: —¡Xikmikti ipan cruz! ");
INSERT INTO nhx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Eꞌ Pilato kijtoj: —¿Té̱taj kichij yej aye̱kti? Eꞌ yejeme̱n ma̱jya tzajtzikej: —¡Xikmikti ipan cruz! ");
INSERT INTO nhx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Eꞌ Pilato kinekiá makiye̱ꞌitaka̱n, inó̱n iga kimajkaj Barrabás iwá̱n kitekimáꞌ solda̱dojmej iga makimagaka̱n Jesús iwá̱n iga makimikti̱tij ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Iwá̱n solda̱dojmej kiwi̱gakej Jesús ipan ipa̱tioj palacio, iwá̱n kinejnechkojkej nochi solda̱dojmej. ");
INSERT INTO nhx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Iwá̱n kaki̱ltijkej se̱ sota̱ntzótzol yej a̱xokotiꞌ, iwá̱n se̱ corona de witzti yej kijkitikej iga kiyawalchijkej. ");
INSERT INTO nhx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iwá̱n pe̱wakej iga kitzajtzilijkej: —¡Xiye̱ꞌono iRre̱y judiyojmej! ");
INSERT INTO nhx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Iwá̱n kikuajkua̱wi̱tekkej iga kuawiꞌ, kichijchakej, iwá̱n motankua̱ketzakej iná̱ꞌ, iga ken kiweyimati̱ltia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kua̱ꞌ kaja̱wilmatíkeja, kiki̱xtilijkej inó̱n tzótzol yej a̱xokotiꞌ, iwá̱n sej kaki̱ltijkej sej yej itzótzolpa nokta, iwá̱n kiki̱xtijkej iga kimikti̱toj ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Iwá̱n se̱ ta̱gaꞌ yej icha̱n a̱ltepe̱ꞌ Cirene, yej ito̱ka̱ꞌ Simón, yej ítajpa Alejandro iwá̱n Rufo, ompa pano̱tia̱ya iga yajka imi̱lpan, iwá̱n yéj kitekimakakej iga makiwi̱guili Jesús icru̱z. ");
INSERT INTO nhx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Iwá̱n kiwi̱gakej Jesús ka̱n kijliáj Gólgota, yej kijto̱jneki Ka̱n onoꞌ Kuaomiꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iwá̱n kimakakej vino yej ne̱nelijtoꞌ iwá̱n remedio yej ito̱ka̱ꞌ mirra, eꞌ Jesús akonij. ");
INSERT INTO nhx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Kua̱ꞌ kiclava̱rójkeja ipan cruz, solda̱dojmej kikuikej itzótzol Jesús iga kirrifa̱rojkej iga makimatika̱n te̱ kiwi̱gas sejsé̱ de yejemej. ");
INSERT INTO nhx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Yowaltiꞌ las nueve kua̱ꞌ kiclava̱rojkej Jesús ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iwá̱n kita̱lkej ikua̱pan ka̱n kijkuilojkej te íga kimiktijkej, ijkí̱n ijkuilijtoya: “IRRE̱Y JUDIYOJMEJ.” ");
INSERT INTO nhx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Iwá̱n na̱ꞌ ka̱n kiclava̱rojkej Jesús pan cruz, no̱ kiclava̱rojkej o̱me yej tachtekij, ipan sejsé̱ icru̱z, se̱ ila̱doj iye̱ꞌma̱ꞌ iwá̱n seꞌ iyo̱pochka̱mpa. ");
INSERT INTO nhx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ijkó̱n iga mochij yej ijkuilijtoꞌ ipan itájto̱l Dios: “Kitakej ken se̱ yej kichij yej aye̱kti.” ");
INSERT INTO nhx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iwá̱n yej panowa̱yaj ite̱noj Jesús, kipi̱najtia̱yaj, este kikua̱tzejtzelowilia̱yaj iga kijlia̱yaj: —Aykiꞌ, tej tikijtoj iga tikxiti̱nas weyitio̱pan, iwá̱n ipan e̱yi día wel sej tikojpachi̱wa, ");
INSERT INTO nhx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","moga̱naj ximoma̱nawi, iwá̱n xitemo ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ijko̱nsan no̱ ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj pan la ley, kipi̱najtia̱yaj, iwá̱n mojlia̱yaj: —Sekin kima̱nawij, eꞌ yéj ima̱tika awel moma̱nawiá. ");
INSERT INTO nhx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Siga Cristo yej iRre̱y israeli̱tajmej tikitaskej iga temo̱j ipan cruz, ijkó̱n sí ticre̱do̱skej. Iwá̱n yej na̱ꞌ pilojtoyaj ipan sejsé̱ icru̱z, no̱ ma̱ltajtowa̱yaj iga Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kua̱ꞌ asiꞌ tajkodía, no̱ya̱n ipan ta̱jli tako̱mitiáꞌ, ijkó̱n tako̱mititoya este las tres tio̱takpan. ");
INSERT INTO nhx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Iwá̱n íkua̱ꞌya Jesús tzajtziꞌ iga inochi itájpal, kijtoj: —Eloi, Eloi, ¿lama sabactani? —yej kijto̱jneki: TinoDio̱s, tinoDio̱s, ¿te iga tine̱kájteja? ");
INSERT INTO nhx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sekin yej ompa onoyaj, kikakikej, iwá̱n kijtojkej: —Taꞌ xikakika̱n, nemi kino̱tza ikyapa profeta Elías. ");
INSERT INTO nhx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Iwá̱n se̱ de yejéme̱mpa motaloj, ka̱pacho̱to tejté̱ yej ken ichkaꞌ pan xoko̱ꞌvi̱noj. Kilpij ipan ojtaꞌ, iwá̱n kitecho̱ltij Jesús, iga makichichi̱na. Kijtoj: —Xikajte̱waka̱n, matikitaka̱n siga wi̱ꞌ Elías kitemo̱wi̱ki. ");
INSERT INTO nhx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iwá̱n Jesús tzájtziꞌpa iga tajtoj, iwá̱n míguiꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iwá̱n tzótzol yej iga tajkotzaktoya weyitio̱pan, tajkotzaya̱niꞌ, pe̱waꞌ ajko iwá̱n tzaya̱ntiwa̱laj este tani. ");
INSERT INTO nhx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ije̱fej solda̱dojmej yej onoya iyi̱xtaj Jesús, kua̱ꞌ kitaꞌ kén iga tzajtziꞌ iwá̱n miguiꞌ, kijtoj: —Mataj melá̱ꞌ iní̱n ta̱gaꞌ iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ompa no̱ onoyaj sekin siwa̱tkej, tachi̱xtoyaj wejka; onoyaj María Magdalena, iwá̱n seꞌ María yej iyé̱mejpa José iwá̱n Jacobo yej te̱tzo̱yo̱ꞌ, iwá̱n ompa no̱ onoya seꞌ siwa̱ꞌ ito̱ka̱ꞌ Salomé. ");
INSERT INTO nhx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ini̱mej siwa̱tkej kitokatinemiáj Jesús, iwá̱n kipale̱wijkej kua̱ꞌ nemiá Galilea. Ompa onoyaj no̱ miaꞌ siwa̱tkej yej senyajkij Jerusalén iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Inó̱n día kichi̱waj yej monekis iga mo̱stapa día kua̱ꞌ mose̱wilo. Kua̱ꞌ némiya tayowati, ");
INSERT INTO nhx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","se̱ ta̱gaꞌ yej ito̱ka̱ꞌ José yej icha̱n a̱ltepe̱ꞌ Arimatea yej onoya ipan inó̱n grupo yej tayaka̱ntokej yej kimanda̱rowa̱yaj judiyojmej, yajki kitato Pilato iwá̱n ayá̱ꞌ majmawiꞌ iga kitajtan icue̱rpoj Jesús iga makito̱ka. Yéj no̱ kichi̱xtoya ke̱man wi̱ꞌ reina̱ro̱ki Dios. ");
INSERT INTO nhx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato madmira̱doj kua̱ꞌ kikáꞌ iga nimaní̱n miꞌ Jesús, iwá̱n kino̱tzaꞌ ije̱fej solda̱dojmej iga kitajtan iga ix a̱n ijko̱nya. ");
INSERT INTO nhx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kua̱ꞌ inó̱n capitán kimati̱ltij iga miꞌya Jesús, Pilato kijlij José iga wel kito̱kas Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Iwá̱n José kikowato se̱ sábana, iwá̱n yajki kitemowi̱to icue̱rpoj Jesús ipan cruz iwá̱n kiki̱kimiloj iga inó̱n tzótzol. Iwá̱n kito̱gaꞌ ipan se̱ texapoꞌ yej ichkuatoyay. Iwá̱n kite̱ntzakuaꞌ iga se̱ weyiyawalteꞌti. ");
INSERT INTO nhx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena iwá̱n seꞌ María yej íye̱ꞌpa José, kitakej ka̱n kito̱kkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kua̱ꞌ pánoja día iga mose̱wilo, María Magdalena, Salomé, iwá̱n María yej íye̱ꞌpa Jacobo, kikojkej yej ajwiya̱ꞌ iga kita̱liliáj icue̱rpoj Jesús. ");
INSERT INTO nhx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Iwá̱n isájpasan domingo asitoj ka̱n to̱ktoꞌ Jesús, kí̱saꞌya to̱nati̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Iwá̱n mojlia̱yaj: —¿A̱ꞌyéj a̱n tee̱nili̱j teꞌti yej iga te̱ntzaktoꞌ inó̱n a̱nimajtexapoꞌ? ");
INSERT INTO nhx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eꞌ kua̱ꞌ tachakej, kitakej iga inó̱n weyiteꞌti ayoꞌ kite̱ntzaktoya a̱nimajtexapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kua̱ꞌ kalakkej a̱nimajtexapoko, kitakej se̱ chokotzi̱n e̱watoꞌ a la derecha, kakijtoꞌ se̱ weyaꞌtzótzol yej ista̱ꞌ; iwá̱n momajtijkej. ");
INSERT INTO nhx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Eꞌ yéj kijtoj: —Amo ximajmawika̱n; amejeme̱n ankite̱mo̱koj Jesús de Nazaret, yej kimiktijkej ipan cruz. Yéj ojpa‑ísaꞌya; ayoꞌ teyi nigaj. Taꞌkiꞌ xikitaka̱n ka̱n kite̱kakaj. ");
INSERT INTO nhx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Xá̱ka̱nya iná̱n, iwá̱n xikijli̱ka̱n idisci̱polojmej iwá̱n Pedro: “Jesús yawi asiti achto Galilea que amejeme̱n, iwá̱n ompígaya ankitaskej, ijkó̱n ken mitzijlijkej.” ");
INSERT INTO nhx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ino̱mej siwa̱tkej cholotiki̱skej a̱nimajtexapoko; kuekuechkatiajkij iga momajtijkej. Iwá̱n ayagaj te̱ kijlijkej iga majmawiáj. ");
INSERT INTO nhx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kua̱ꞌ ojpa‑ísaꞌya Jesús, isájpasan domingo, ki̱xne̱xtilij achto María Magdalena, yej kiki̱xtilij ikya siete ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yéj yajki kimati̱lti̱to yej kitokatinemiáj Jesús; kasitoj mokno̱matitoyaj iwá̱n cho̱katoyaj. ");
INSERT INTO nhx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kua̱ꞌ yejemej kimatikej iga Jesús ojpa‑isaꞌ iwá̱n iga María kítaꞌya, yejeme̱n akicre̱dojkej. ");
INSERT INTO nhx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Después Jesús ki̱xne̱xtilij o̱me̱n yej nemi ya̱yaj ipan ojti wéjkaya iga a̱ltepe̱ꞌ; eꞌ séꞌpaya iga ne̱siá. ");
INSERT INTO nhx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yejemej no̱ yajkij iga kimati̱lti̱toj sekin, eꞌ yejemej no̱ ayá̱ꞌ kicre̱dowilijkej ken iga kijtojkej. ");
INSERT INTO nhx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Má̱j má̱j Jesús ki̱xne̱xtilij once idisci̱polojmej ka̱n nemi takuaj. Iwá̱n Jesús kajajwaꞌ ino̱mej iga ayá̱ꞌ kicre̱dowa̱yaj iga yo̱ltakuaktíkejoꞌ iga ayá̱ꞌ kicre̱dowilijkej ino̱mej yej kitakej iga Jesús ojpa‑ísaꞌya. ");
INSERT INTO nhx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Iwá̱n Jesús kijlij idisci̱polojmej: —Xa̱ka̱n no̱ya̱n ipan ta̱jli iwá̱n xikpowili̱ka̱n nochi gente ye̱ꞌnoti̱ciaj kén iga Dios tama̱nawiá. ");
INSERT INTO nhx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Yej kicre̱do̱j iwá̱n mobautiza̱ro̱j, Dios kima̱nawi̱j; eꞌ yej akicre̱do̱j, Dios kikno̱chi̱was. ");
INSERT INTO nhx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Iwá̱n ino̱mej yej kicre̱do̱skej kichi̱waskej yej ayi̱ꞌpa mo‑ita. Ipan noto̱ka̱ꞌ kiki̱xti̱skej ma̱lespi̱ritojmej, iwá̱n yawij tajto̱tij ipan nuevo tajto̱lmej. ");
INSERT INTO nhx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kiki̱tzki̱skej kowa̱mej iga ima̱mej, iwá̱n siga koni̱skej tejté̱ yej te̱miktiá, até̱ kichi̱wili̱skej. Kita̱li̱skej ima̱mej ipan yej we̱titokej, iwá̱n achitiaskej. ");
INSERT INTO nhx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kua̱ꞌ tamiꞌ tajtoj wa̱n idisci̱polojmej, toTe̱ko Jesús tejkaj ipan cielo, yajki mota̱li̱to ila̱doj iye̱ꞌma̱ꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Iwá̱n disci̱polojmej ki̱skej iga kipowatoj no̱ya̱n kén iga Dios tama̱nawiá. ToTe̱ko Jesús kipale̱wia̱ya idisci̱polojmej iga kua̱ꞌ kipowayaj ye̱ꞌnoti̱ciaj, kichi̱waya yej ayi̱ꞌpa mo‑ita iga mane̱si iga melaꞌcie̱rtoj yej kijtowa̱yaj. Ijkó̱nyawaꞌ.");
INSERT INTO nhx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Miaꞌya kinekiáj makiye̱ꞌijkuilo̱ka̱n yej Jesús kichij mie̱j onoya nowa̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ijkó̱n kensan ne̱mati̱ltijkej yej kinojma‑itakej yej kichij Jesús iwá̱n kipowakej inó̱n ye̱ꞌnoti̱ciaj. ");
INSERT INTO nhx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nej niLucas no̱ nitatajtantinemiꞌ iga manikmelaꞌmati este ka̱n pe̱waꞌ yej kichij Jesús. Iwá̱n tej Teófilo yej mitzpoxye̱ꞌitaj, ye̱kti iga no̱ manimitzijkuilowili nochi kensan nikmati ");
INSERT INTO nhx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","iga xikmelaꞌmati iga ijko̱nya nokta in inó̱n yej mitzne̱xtilijkej. ");
INSERT INTO nhx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kua̱ꞌ Herodes onoya iga rey ipan estado de Judea, onoya se̱ sacerdote yej ito̱ka̱ꞌ Zacarías yej igrú̱pojpa katka Abías. Isiwa̱ꞌ Zacarías ito̱ka̱ꞌ Elisabet, irrá̱zajpa no̱ Aarón yej sacerdote. ");
INSERT INTO nhx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Iwá̱n iyo̱mextimej ye̱ꞌnemiáj iyi̱xtaj Dios, nochipa kichi̱wayaj ken kijtowa iley toTe̱ko, iwá̱n ayagaj wel kijtowa̱ya iga kichijtoyaj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Eꞌ ayá̱ꞌ kipiayaj nisé̱ ipiltzi̱n iga Elisabet ayá̱ꞌ wel pilowaya. Iwá̱n póxsanya katka yo̱lejkej inó̱n ve̱j. ");
INSERT INTO nhx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Se̱ día igru̱poj Zacarías kitoca̱roj iga kichi̱wa itekiyo sacerdote iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Iwá̱n ken iga kitekichi̱wayaj sacerdo̱tejmej, kichijkej rifa iga makimatika̱n a̱ꞌyéj yawi kitati̱ti incienso. Iwá̱n kitoca̱roj Zacarías iga makitati incienso ipan íkal toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kua̱ꞌ nemi kitatia̱ya incienso, nochi gente ora̱dojtoya fuera. ");
INSERT INTO nhx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Iwá̱n Zacarías ki̱xne̱xtili̱ko se̱ ángel yej kiti̱tan toTe̱ko. Kua̱ꞌ kitaꞌ este ejkatoꞌ na̱ꞌ altar ka̱n motatiá incienso. Ejkatoꞌ lado derecho inó̱n altar. ");
INSERT INTO nhx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kua̱ꞌ Zacarías kitaꞌ el ángel, ayoꞌ kimatiꞌ te̱ kichi̱waya iwá̱n poxsan momajtij. ");
INSERT INTO nhx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Eꞌ el ángel kijlij: —Zacarías, amo ximajmawi, Dios kikaꞌya yej nemi tiktajtaniliá, iwá̱n mosiwa̱ꞌ Elisabet yawi kipiati se̱ ipiltzi̱n yej tia tikto̱ka̱wi̱ti Juan. ");
INSERT INTO nhx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tia tipa̱kiti poxsan, iwá̱n miaꞌ no̱ yawij pa̱kitij kua̱ꞌ nace̱ro̱j ");
INSERT INTO nhx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","iga mopiltzi̱n poxsan yawi kiye̱ꞌitati Dios. Ayá̱ꞌ yawi koni̱ti okti, nité̱ yej tata̱wa̱ntiá. Iwá̱n kipiás nokta el Espíritu Santo este kua̱ꞌ kitalaxwíjtosoꞌ iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Iwá̱n yawi kiyo̱lyama̱nati miaꞌ gente de Israel iga makitoka Dios yej iTe̱komej. ");
INSERT INTO nhx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Iwá̱n mopiltzi̱n tayaka̱ntiá̱j iyi̱xtaj toTe̱ko iwá̱n kipiás espíritu yej kipiaya el profeta Elías iga wel makichi̱wa ken kichij yéj. Kichi̱was iga te̱tajmej mamoye̱ꞌitaka̱n iwá̱n ipilowa̱n, iwá̱n iga yej ayá̱ꞌ tacre̱dowaj wel matacre̱do̱ka̱n. Ijkó̱n kichi̱was iga la gente wel maki‑o̱mema̱wi toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Iwá̱n Zacarías kitajtan el ángel: —¿Kén nikmatis siga mochi̱was ken nemi tikijtowa? Nej niwé̱weja iwá̱n nosiwa̱ꞌ no̱ ilámaja. ");
INSERT INTO nhx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","El ángel kijtoj: —Nej niGabrie̱l yej nonoꞌ iyi̱xtaj Dios; yéj ne̱ti̱tan iga manitajto̱ki mowa̱n iga manimitzmati̱lti iní̱n ye̱ꞌnoti̱ciaj. ");
INSERT INTO nhx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Eꞌ iná̱n, iga aticre̱doj yej nimitzijlij, tia tino̱nojtitoti, iwá̱n titajto̱j sej este kua̱ꞌ mochí̱wasya yej nimitzijlij. ");
INSERT INTO nhx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mie̱j la gente fuera kichi̱xtoyaj Zacarías, mosepantajtantoyaj iga te íga áyasan ki̱sa weyitio̱pan‑ijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kua̱ꞌ Zacarías ki̱sako, ayꞌya wel tajtowa̱ya, santama̱ma̱no̱tzaya. Ijkó̱n iga la gente kimatikej iga tejté̱ ki̱xne̱xtilij weyitio̱pan‑ijtiꞌ. Iwá̱n no̱nojtiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Iwá̱n kua̱ꞌ Zacarías kimaxítija iga tekipanowa̱ya weyitio̱pan, yájkiya icha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Iwá̱n xo̱lo̱yowiꞌ Elisabet yej isíwa̱ꞌpa Zacarías. Iwá̱n Elisabet cinco me̱j ayá̱ꞌ ki̱saꞌ icha̱n, ijkí̱n kijtowa̱ya ipan iya̱lmaj: ");
INSERT INTO nhx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“NoTe̱ko ne̱ta̱lij ijkí̱n iga ayꞌya má̱j mane̱pi̱najti̱ka̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kua̱ꞌ kiwí̱gaya seis meses iga xo̱lo̱yowiꞌ Elisabet, Dios kiti̱tan el ángel Gabriel ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Nazaret ipan estado de Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Iwá̱n yajki cha̱n se̱ takotzi̱n yej ito̱ka̱ꞌ María yej aya ki̱xmatiá ta̱gaꞌ. Eꞌ onoyay comprometida iga yawi mona̱mikti̱ti iwá̱n se̱ ta̱gaꞌ yej ito̱ka̱ꞌ José yej irrá̱zajpa rey David. ");
INSERT INTO nhx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Iwá̱n el ángel kalaꞌ este ka̱n onoya María, iwá̱n ijkí̱n kijlij: —¡Xiyo̱lpa̱ki iga tej mitztapejpen Dios iwá̱n iga toTe̱ko onoꞌ mowa̱n! Dios mamitzyo̱lchika̱wa má̱j que inewi siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kua̱ꞌ María kitaꞌ el ángel, este moyo̱lmajtij iga kikáꞌ yej kijtoj. Iwá̱n motajtan iga té̱ a̱n kijto̱jneki inó̱n yej kijtoj. ");
INSERT INTO nhx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","El ángel kijlij: —María, amo ximajmawi, Dios mitzye̱ꞌita iwá̱n mitztapejpen. ");
INSERT INTO nhx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Iná̱n tia tixo̱lo̱yowiti iwá̱n tia tikpiati se̱ mopiltzi̱n iwá̱n tikto̱ka̱wi̱j JESÚS. ");
INSERT INTO nhx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yéj yawij kipoxweyimati̱lti̱tij iwá̱n kito̱ka̱wi̱skej no̱ iga iPiltzi̱n Dios yej onoꞌ pox ajko. Iwá̱n toTe̱ko Dios kichi̱was iga maono iga rey ken David yej iyikyapatajwe̱wej ");
INSERT INTO nhx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","iga makigoberna̱ro nochipa la gente de Israel. Iwá̱n atamis iga goberna̱ro̱j. ");
INSERT INTO nhx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Iwá̱n María kijlij el ángel: —¿Kén nia nixo̱lo̱yowiti esi nej aya nono wa̱n ta̱gaꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","El ángel kijlij: —IyEspí̱ritoj Dios wi̱ꞌ ipan tej iwá̱n Dios yej onoꞌ ajko iga ipode̱r yawi mitztzakuati. Inó̱n iga moxo̱lo̱ꞌ yej yawi nace̱ro̱ti, inó̱n wi̱ꞌ de Dios iwá̱n kijli̱skej iga Dio̱spa iPiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Taꞌ manimitzijlo̱ꞌ, Elisabet yej moparié̱ntajpa, xo̱lo̱yówiꞌya no̱ malej iga ilámaja. Yej kijlia̱yaj iga ayí̱ꞌ pilowaya iná̱n kipiá seis meses iga xo̱lo̱yowiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Iga Dios ateyi yej ken awel makichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Iwá̱n María kijtoj: —Nej manikchi̱wa ken kineki toTe̱ko, iwá̱n Dios makichi̱wa ipan nej ken tikijtoj. Iwá̱n kua̱ꞌ tamiꞌ tajtoj María, yájkiya el ángel. ");
INSERT INTO nhx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ayá̱ꞌ wejkatiꞌ, María nimaní̱n yajki kipaxa̱lowili̱to Elisabet yej cha̱ntitoya ipan se̱ a̱ltepe̱ꞌ yej onoꞌ ipan tepe̱yoj, ipan estado de Judea ");
INSERT INTO nhx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iwá̱n kalaꞌ cha̱n Zacarías, kino̱tzaꞌ Elisabet. ");
INSERT INTO nhx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Iwá̱n kua̱ꞌ Elisabet kikáꞌ iga kino̱tzkej, este italaxijtiꞌ wiwitogaꞌ ixo̱lo̱ꞌ, iwá̱n íkua̱ꞌ iyEspí̱ritoj Dios kitajto̱lmáꞌ Elisabet, ");
INSERT INTO nhx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","iwá̱n kijtoj recio: —Dios mitzye̱ꞌítaya má̱j que inochi siwa̱tkej. Iwá̱n no̱ kiye̱ꞌítaꞌya moxo̱lo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Té̱ noteki in nej iga mane̱paxa̱lowili̱ki yej íye̱ꞌpa noTe̱ko? ");
INSERT INTO nhx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kua̱ꞌ nikáꞌ iga tine̱no̱tzaꞌ, este wiwitogaꞌ notalaxijtiko noxo̱lo̱ꞌ iga pa̱guiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tej tipa̱ktoꞌ iga ticre̱doj toTe̱ko iga yawi mochi̱wati yej mitzijlij. ");
INSERT INTO nhx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Iwá̱n kijtoj María: Noa̱lmaj kiweyimati̱ltiá toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Iwá̱n noespí̱ritoj pa̱ki iyi̱xtaj Dios yej ne̱ma̱nawij. ");
INSERT INTO nhx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iga Dios ne̱tapejpen iga iyescla̱vaj, yej ayá̱ꞌ nimotapialiá. Iwá̱n este a̱man iwá̱n nochipa kijto̱skej iga Dios ne̱ye̱ꞌita, ");
INSERT INTO nhx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","iga Dios yej nochi wel kichi̱wa, kichij ipan nej yej poxsan ye̱kti. ¡Mamoweyimati ito̱ka̱ꞌ! ");
INSERT INTO nhx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios nochipa kikne̱liá yej kimajmawiliá. ");
INSERT INTO nhx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Iga kichij yej ayagaj wel kichi̱wa; kita̱nilij yej mopoxweyimatij. ");
INSERT INTO nhx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kiki̱xtij re̱yejmej ka̱n manda̱rowa̱yaj, iwá̱n kichij iga makiweyimati̱lti̱ka̱n yej ayá̱ꞌ moweyimatij. ");
INSERT INTO nhx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yej nemi a̱pismikiáj, Dios kimáꞌ yej ye̱kti, iwá̱n yej motapialia̱yaj ayá̱ꞌ kimáꞌ nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Dios kipale̱wij la gente de Israel yej kicre̱dowaj, iwá̱n ayá̱ꞌ ke̱lkaj iga kikne̱lij. ");
INSERT INTO nhx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Iga Dios ijkó̱n kijlij to‑ikyapatajwa̱n, iga nochipa kipale̱wi̱j Abraham iwá̱n nochi ipilowa̱n ipilówa̱mpa. ");
INSERT INTO nhx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Iwá̱n María ka̱wiꞌ cha̱n Elisabet ken e̱yi me̱j iwá̱n yajki sej icha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kua̱ꞌ asiꞌ hora iga Elisabet taonoltiá, kitaꞌ se̱ ichoochi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kua̱ꞌ kimatikej iveci̱nojmej iwá̱n iparie̱ntejmej iga toTe̱ko poxsan kikne̱lij Elisabet, yajkij kiyo̱lchika̱watoj. ");
INSERT INTO nhx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Iwá̱n kua̱ꞌ xo̱lo̱tzi̱n kipiaya ocho día, kiwi̱gakej iga kicircuncida̱ro̱toj ken kitekichi̱waj israeli̱tajmej. Iwá̱n kinekiáj iga makito̱ka̱wi̱ka̱n Zacarías ken ítajpa ito̱ka̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Eꞌ iye̱ꞌ kijtoj: —¡Ayéj ijkó̱n! Yéj yawi moto̱ka̱wi̱ti Juan. ");
INSERT INTO nhx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kijtojkej: —¿Te iga? Esi ateyi nisé̱ amokni̱wa̱n yej ijkó̱n ito̱ka̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Iwá̱n Zacarías san kima̱ma̱no̱tzakej iga kitajtankej kén kito̱ka̱wi̱j ichoochi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Itaj kitajtan tejté̱ ka̱n matajkuilo, iwá̱n kijkuiloj: “Ito̱ka̱ꞌ Juan.” Iwá̱n inewi san tajtachi̱xtikajkej. ");
INSERT INTO nhx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Iwá̱n Zacarías íkua̱ꞌya tajtoj sej iwá̱n pe̱waꞌ kiweyimati̱ltij Dios. ");
INSERT INTO nhx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nochi yej najna̱ꞌsan icha̱mej momajtijkej, iwá̱n no̱ya̱n ipan estado de Judea, yej cha̱ntitokej ipan tepe̱mej kipowayaj yej mochij. ");
INSERT INTO nhx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iwá̱n nochi yej kikakiáj inó̱n ta̱tapowalis, mosepantajtaniáj: —¿Té̱ a̱n itekiyo kipiás in iní̱n choochi̱n? Iga ne̱siá iga Dios onoya iwá̱n choochi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Iwá̱n ipan Zacarías, yej ítajpa choochi̱n, asiꞌ iyEspí̱ritoj Dios iwá̱n kijtoj tájto̱l yej Dio̱spa kimáꞌ: ");
INSERT INTO nhx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Mamoweyimati̱lti toTe̱ko, yej iDio̱spa Israel, iga wa̱laj kima̱nawi̱ko ige̱ntej. ");
INSERT INTO nhx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Te̱ti̱tanilij se̱ yej te̱salva̱rowa yej kipoxpiá poder yej ipiltzi̱n yej ipilówa̱mpa David yej kichij ken Dios kineki. ");
INSERT INTO nhx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ijkó̱n kensan Dios ikya kijtoj ipan iprofe̱tajmej yej ye̱ꞌnemikej, ");
INSERT INTO nhx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","iga yéj yawi te̱ma̱nawi̱ti de ino̱mej yej te̱mikti̱jnekij iwá̱n de inochi yej te‑ijiyaj. ");
INSERT INTO nhx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Iga mane̱si iga kikne̱liá to‑ikyapatajwa̱n, iwá̱n ayá̱ꞌ ke̱lka̱wa iga kichij pacto iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Iní̱n yej Dios kinojma‑ijlij to‑ikyapatajwé̱j Abraham iga yawi kichi̱wati: ");
INSERT INTO nhx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","yawi te̱ma̱nawi̱ti ipan toenemi̱gojmej, iwá̱n ayꞌya timajmawiskej iga tiktokaj Dios, ");
INSERT INTO nhx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","iwá̱n nochipa tiye̱ꞌnemiskej iwá̱n tiye̱ꞌonoskej iyi̱xtaj. ");
INSERT INTO nhx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Iwá̱n tej nopiltzi̱n, mitzto̱ka̱wi̱skej iprofe̱taj Dios yej onoꞌ pox ajko, iga tej titayaka̱nas iyi̱xtaj toTe̱ko iga tikye̱ꞌta̱lijtiá̱j iyojwi, ");
INSERT INTO nhx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","iga xikmati̱lti ige̱ntej toTe̱ko ken iga ke̱lka̱wili̱skej yej kichi̱waj yej aye̱kti iwá̱n ijkó̱n kima̱nawi̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iga toDio̱s poxsan te‑ikne̱liá, inó̱n iga este ajko ka̱n onoꞌ, te̱ti̱taniliá se̱ yej ken kua̱ꞌ te̱ta̱wi̱ki ipan toa̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Iwá̱n iga makita̱wi yej onokej ka̱n takomichka̱n, ino̱mej yej majmatokej iga mikiskej. Iwá̱n teojmaka ipan ojti yej te̱ne̱xtiliá iga wel matonoka̱n tamelá̱. ");
INSERT INTO nhx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iwá̱n chooli̱ntzi̱n nemi weyaya iwá̱n má̱j ki̱xmatitia̱ya Dios. Iwá̱n onoya ipan desierto ka̱n ayagaj onoꞌ, este que iyi̱xtaj la gente de Israel mone̱xtij te̱ itekiyo in yéj. ");
INSERT INTO nhx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kua̱ꞌ goberna̱rowa̱ya rey César Augusto, tatekimáꞌ iga no̱ya̱n mamochi̱wa censo. ");
INSERT INTO nhx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iní̱n achto censo kichijkej kua̱ꞌ Cirenio manda̱rowa̱ya Siria. ");
INSERT INTO nhx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Iwá̱n inewi gente yajkij ipan iya̱ltepe̱mej kajká̱n nace̱rojkej iga kijkuilo̱toj ito̱ka̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Inó̱n iga José ki̱saꞌ Nazaret, a̱ltepe̱ꞌ yej onoꞌ ipan estado de Galilea. Iwá̱n yajki ipan estado de Judea ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Belén ka̱n nace̱roj rey David, iga José irrá̱zajpa David. ");
INSERT INTO nhx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Yajki mo‑ijkuilo̱to iwá̱n María este Belén. María onoyay iga yawi mona̱mikti̱ti iwá̱n José. María xo̱ló̱yoja, eꞌ ayéj iga íwa̱nya onoya. ");
INSERT INTO nhx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Iwá̱n kua̱ꞌ onókeja Belén, asiꞌ hora iga María taonoltiá. ");
INSERT INTO nhx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Iwá̱n ompa kitaꞌ iyokichko̱pompiltzi̱n, iwá̱n kikijkimiloj iga tzótzol iwá̱n kite̱gaꞌ ipan kuacajo̱n ka̱n motamaka kawa̱yojmej, iga ayꞌya onoya ka̱n kochij yej paxa̱lowaj. ");
INSERT INTO nhx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ayá̱ꞌ wejka iga Belén onoyaj sekin yej kicuida̱rojtoyaj borre̱gojmej. Iwá̱n ino̱mej senyówal onoyaj ipan sakayoj. ");
INSERT INTO nhx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kémpasan ki̱xne̱xtili̱koj se̱ iyá̱ngel toTe̱ko. Iwá̱n iweyipode̱r toTe̱ko ta̱wij ka̱n onoyaj yejeme̱n iwá̱n pox majmawikej. ");
INSERT INTO nhx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Eꞌ el ángel kijtoj: —Amo ximajmawika̱n. Nimitzmati̱lti̱koj ye̱ꞌnoti̱ciaj, iwá̱n inewi yej kikakiskej, yo̱lpa̱kiskej: ");
INSERT INTO nhx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","iga a̱man nace̱ro̱co ipan iya̱ltepe̱ꞌ David se̱ yej mitzma̱nawi̱koj, toTe̱ko, el Cristo yej itati̱tan Dios. ");
INSERT INTO nhx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Iga xikmatika̱n iga ayá̱ꞌ nemi nimitzkajkaya̱waj, anyawij ankasitij se̱ xo̱lo̱tzi̱n kijkimilijtoꞌ iga tzótzol iwá̱n wetztoꞌ ipan se̱ kuacajo̱n ka̱n motamaka kawa̱yojmej. ");
INSERT INTO nhx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Iwá̱n kémpasan miji̱xne̱xti̱koj iná̱ꞌ el ángel má̱j komati a̱ngelejmej yej wa̱lkej ipan cielo iwá̱n inochi̱n kiweyimati̱ltia̱yaj Dios iwá̱n kijtowa̱yaj: ");
INSERT INTO nhx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Mamoweyimati̱lti Dios ipan cielo yej onoꞌ má̱j ajko, iwá̱n ipan iní̱n ta̱jli maonoka̱n tamelá̱ nochi yej Dios kiye̱ꞌita! ");
INSERT INTO nhx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Iwá̱n kua̱ꞌ yájkija sej a̱ngelejmej ipan cielo, pasto̱rmej pe̱wakej iga mose̱sepan‑ijliáj: —Tiáka̱nwaꞌ Belén, matikitatij yej sucede̱roj, yej te̱mati̱ltij toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Iwá̱n nimaní̱n yajkij, kasitoj María iwá̱n José, iwá̱n wetztoꞌ xo̱lo̱tzi̱n ipan kuacajo̱n. ");
INSERT INTO nhx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Kua̱ꞌ pasto̱rmej kitákeja chooli̱ntzi̱n, kimati̱ltijkej José iwá̱n María yej el ángel kijlijkej de inó̱n chooli̱ntzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iwá̱n nochi yej kikakikej yej kipowayaj pasto̱rmej, san tajtachi̱xtika̱wiáj. ");
INSERT INTO nhx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Eꞌ María ka̱naꞌ ipan iya̱lmaj nochi yej kijlijkej, iwá̱n nochipa kejla̱mikiá. ");
INSERT INTO nhx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Iwá̱n pasto̱rmej yajkij sej ka̱n onoyaj, kiweyimati̱ltijtiajkij Dios iwá̱n kitakui̱kilijtiajkij iga inó̱n yej kikakikej iwá̱n kitakej, iga nochi mochij kensan el ángel kijtoj. ");
INSERT INTO nhx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kua̱ꞌ chooli̱ntzi̱n kipiaꞌya ocho día, yajkij kicircuncida̱ro̱toj iwá̱n kita̱lilijkej ito̱ka̱ꞌ JESÚS, ino̱nsan to̱ka̱ꞌ yej el ángel kijlij María kua̱ꞌ aya xo̱lo̱yowiá. ");
INSERT INTO nhx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Iwá̱n kua̱ꞌ asiꞌ día iga mopurifica̱rowaj yejeme̱n, ken kijtowa iley Moisés, chooli̱ntzi̱n kiwi̱gakej Jerusalén iga makipresenta̱ro̱ka̱n iyi̱xtaj toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ijkó̱n kichijkej iga ipan iley toTe̱ko, ijkí̱n ijkuilijtoꞌ: “Inewi ko̱ponchoochi̱n yej nace̱rowa, mochi̱waskej itatki toTe̱ko.” ");
INSERT INTO nhx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Iwá̱n yajkij kimakatoj iyofre̱ndaj Dios ken kijtowa iley toTe̱ko: o̱me so̱lin o o̱me jojtokotzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Inó̱n ve̱j, Jerusalén onoya se̱ ta̱gaꞌ ito̱ka̱ꞌ Simeón, pox ye̱ꞌnemiá iwá̱n kiweyimati̱ltia̱ya Dios. Yéj kichi̱xtoya yej kima̱nawi̱ki israeli̱tajmej. IyEspí̱ritoj Dios onoya iwá̱n Simeón, ");
INSERT INTO nhx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","iwá̱n kimati̱ltij iga aya mikis este que makita Cristo yej Dios kitapejpen iwá̱n kiti̱tanis. ");
INSERT INTO nhx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kua̱ꞌ itaj iwá̱n iye̱ꞌ chooli̱ntzi̱n Jesús kiwi̱gakej weyitio̱pan iga makichi̱waka̱n ken la ley tatekimaka, iyEspí̱ritoj Dios kitekimáꞌ Simeón iga mayawi no̱ weyitio̱pan. ");
INSERT INTO nhx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Íkua̱ꞌ Simeón kinawaj chooli̱ntzi̱n iwá̱n ijkí̱n kijtoj iga kiweyimati̱ltij Dios: ");
INSERT INTO nhx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","NoTe̱ko, iná̱n welja nimikis tamelá̱, iga nikítaꞌya yej tine‑ijlij. ");
INSERT INTO nhx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Niknojma‑ítaꞌya yej tasalva̱rowa, ");
INSERT INTO nhx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","yej tikti̱tan iga nochi gente. ");
INSERT INTO nhx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yéj ken kita̱wi̱j ipan iya̱lmajmej nochi gente yej ayéj de Israel. Iwá̱n yawij kiweyimati̱lti̱tij Israel iga nij nace̱roj yej tasalva̱rowa. ");
INSERT INTO nhx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José iwá̱n iye̱ꞌ Jesús yo̱ltrikpakej kua̱ꞌ Simeón tajtowa̱ya de chooli̱ntzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Iwá̱n Simeón kitajtanilij Dios iga maye̱ꞌonoka̱n, iwá̱n kijlij María yej íye̱ꞌpa Jesús: —Dios kitapejpen iní̱n choochi̱n iga ípan, miaꞌ de Israel mopojpolo̱skej iwá̱n miaꞌ mosalva̱ro̱skej. Iwá̱n iní̱n poxsan yawij kijiyatij, ");
INSERT INTO nhx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ijkó̱n ne̱sis yej la gente kejla̱ntokej ipan iya̱lmajmej. Eꞌ tej tia timopoxyo̱lmikti̱ti, tikmachi̱li̱j ken tikita se̱ espada yawi mitzyo̱lsolo̱ti. ");
INSERT INTO nhx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ompa no̱ onoya se̱ siwa̱ꞌ yej Dios kitajto̱lmakaya, yej ito̱ka̱ꞌ Ana, yej ipíltzi̱mpa katka Fanuel, yej irrá̱zajpa Aser. Inó̱n ve̱j pox ilámaja. Yéj mona̱miktijka kua̱ꞌ takótzi̱noꞌ, eꞌ siete á̱ñojsan sen‑onoyaj, iwá̱n miꞌ iwé̱j. ");
INSERT INTO nhx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Iwá̱n Ana kiwi̱gayay ochenta y cuatro año. Ayá̱ꞌ ki̱saya ipan weyitio̱pan iga kiweyimati̱ltia̱ya toTe̱ko semilwiꞌ iwá̱n senyówal iga mayuna̱rowa̱ya iwá̱n ora̱dowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kua̱ꞌ tamiꞌ tajtoj Simeón, íkua̱ꞌ asiꞌ Ana iwá̱n pe̱waꞌ iga kimaka gracias Dios iwá̱n kipowaꞌ de xo̱lo̱ꞌ iyi̱xtaj la gente de Jerusalén yej kichi̱xtoyaj se̱ yej makima̱nawi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kua̱ꞌ kichíjkeja inewi yej kijtowa iley toTe̱ko, mokuepkej sej ipan estado de Galilea, ipan iya̱ltepe̱mej yej ito̱ka̱ꞌ Nazaret. ");
INSERT INTO nhx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Iwá̱n chooli̱ntzi̱n nemi moskaltia̱ya iwá̱n asitia̱ya itájpal iwá̱n pox tamatitia̱ya, iwá̱n Dios kipoxye̱ꞌitaya iwá̱n kipale̱wia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Itaj iwá̱n iye̱ꞌ Jesús ya̱yaj cada año Jerusalén iga mo‑ilwichi̱wiliá la Pascua. ");
INSERT INTO nhx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kua̱ꞌ kipiaꞌya doce años Jesús, yajkij sej Jerusalén iga yejemej kitekichi̱wayaj iyilwi la Pascua. ");
INSERT INTO nhx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kua̱ꞌ támiꞌya ilwiꞌ, inó̱n día yáwija icha̱mej. Eꞌ Jesús ka̱wiꞌ Jerusalén, itaj iwá̱n iye̱ꞌ niga kitakej ka̱n ka̱wiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yejemej kijtojkej anka Jesús ya̱ya tatza̱la̱n ka̱n po̱lijtia̱lo. Kua̱ꞌ nejnénkeja semilwiꞌ, íkua̱oꞌ kite̱mojkej ka̱n ya̱yaj iyikni̱wa̱n iwá̱n yej ki̱xmatiáj; ");
INSERT INTO nhx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","eꞌ ayá̱ꞌ kasikej. Iwá̱n mokuepakej sej Jerusalén iga kite̱mo̱toj ompiga. ");
INSERT INTO nhx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Este ipan e̱yi día kasitoj weyitio̱pan, e̱watoꞌ ka̱n onoyaj yej tamachtiáj ipan la ley. Iwá̱n Jesús kikaktoya yej tamachtiáj ipan la ley iwá̱n kitajtantoya. ");
INSERT INTO nhx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iwá̱n nochi yej kikaktoyaj san tajtachi̱xtika̱wiáj iga kitayaj iga poxsan kua̱yama̱niꞌ iwá̱n iga kua̱ꞌ kitajtaniáj, kimatiá kén kijtowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kua̱ꞌ itaj iwá̱n iye̱ꞌ kitakej, san tajtachi̱xtikajkej. Iwá̱n iye̱ꞌ kijtoj: —Nopiltzi̱n, ¿te iga iní̱n anne̱chi̱wilijkej? Motaj iwá̱n nej nimitzte̱mojtinemiáj este ken nichó̱kaja. ");
INSERT INTO nhx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús kijtoj: —¿Te iga anne̱te̱mojtinemiáj? ¿Ix ayá̱ꞌ ankimatij iga manono ka̱n íkal noTaj? ");
INSERT INTO nhx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Eꞌ yejemej ayá̱ꞌ kimatikej te̱ kijto̱jneki yej kijtoj. ");
INSERT INTO nhx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iwá̱n Jesús senyájkiya iwa̱mej a̱ltepe̱ꞌ Nazaret. Iwá̱n Jesús kipoxcre̱dowa̱ya itaj iwá̱n iye̱ꞌ. Iwá̱n iye̱ꞌ Jesús nochipa kejla̱ntoya nochi iní̱n ipan iya̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iwá̱n Jesús ma̱jya nemi weyaya iwá̱n ma̱jya tamatitia̱ya. Iwá̱n Dios iwá̱n la gente kiye̱ꞌitayaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kua̱ꞌ kipiaꞌya quince año iga rey Tiberio César manda̱rojtoya ipan miaꞌ país, Poncio Pilato manda̱rojtoya ipan estado de Judea, Herodes manda̱rojtoya ipan estado de Galilea, Felipe yej iyikni̱n Herodes manda̱rojtoya ipan esta̱dojmej de Iturea iwá̱n Trakonites, iwá̱n Lisanias manda̱rojtoya ipan estado de Abilinia. ");
INSERT INTO nhx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás iwá̱n Caifás kimanda̱rowa̱yaj sacerdo̱tejmej. Inó̱n tiempo ipan desierto Dios kitajto̱lmáꞌ Juan yej ipiltzi̱n Zacarías. ");
INSERT INTO nhx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Iwá̱n Juan panoj no̱ya̱n ipan a̱te̱n Jordán, kijlijtinemiꞌ la gente iga yejeme̱n makikajte̱wáka̱nya iga kichi̱waj yej aye̱kti iwá̱n mamobautiza̱ro̱ka̱n iga Dios makiperdona̱rowili̱ka̱n yej kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Iní̱n mochij ken kijkuiloj el profeta Isaías: Mokaki a̱ꞌpa tajtowa recio ipan desierto, kijtowa: “Xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti, ijkó̱n ankitapowaj ojti iga toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Inewi a̱xapowe̱wetkej mota̱lakili̱j, iwá̱n inewi tepe̱yoj iwá̱n inewi tepe̱tzitzi̱n no̱ moxiti̱nas iga makanivela̱ro̱ka̱n, ma̱malich‑ojtimej yawij mela̱wayatij, ojtimej ka̱n a̱a̱xapotiꞌ, taye̱ka̱ntiás; ");
INSERT INTO nhx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","nochi gente kitas iga Dios tama̱nawiá.” ");
INSERT INTO nhx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kua̱ꞌ la gente ya̱yaj ite̱noj Juan iga mamobautiza̱ro̱ka̱n, yéj ijkí̱n kijlia̱ya: —¡Amejeme̱n ken nokta ipilowa̱n kowa̱mej! ¿A̱ꞌyéj mitzijlijkej iga anyawij anmoma̱nawi̱tij kua̱ꞌ Dios yawi tacastiga̱ro̱ti? ");
INSERT INTO nhx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xiye̱ꞌnemika̱n iga mane̱si iga ankikajtéjkeja iga ankichi̱waj yej aye̱kti. Iwá̱n amo xikijto̱ka̱n: “Nejeme̱n no‑ikyapatajwe̱wejmej Abraham.” Nimitzijliáj iga ini̱mej temej Dios wel kichi̱wa ipilowa̱n Abraham. ");
INSERT INTO nhx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Há̱chajwaꞌ ónoꞌya iga yawi motzojtzontekiti kuawimej este ipan inelwayomej. Inochi kuawiꞌ yej ayá̱ꞌ ye̱ꞌta̱ki, motzonteki iwá̱n moakiá tiko. ");
INSERT INTO nhx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Iwá̱n la gente tatajtankej: —¿Té̱taj nikchi̱waskej? ");
INSERT INTO nhx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan kijtoj: —Yej kipiá o̱me ikua̱ch, makimaka yej ayá̱ꞌ kipiá nisé̱. Iwá̱n yej kipiá tákual makimaka yej akipiá. ");
INSERT INTO nhx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wa̱lkej no̱ iga mamobautiza̱ro̱ka̱n sekin yej kicobra̱rowa̱yaj impuestos iga Roma iwá̱n kitajtankej Juan: —Tamachtia̱ni, in nejemej, ¿té̱ nikchi̱waskej? ");
INSERT INTO nhx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan kijtoj: —Xitacobra̱do̱ka̱n acho̱nsan ke̱ꞌ mitztekimakaj yej mitzmanda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Iwá̱n solda̱dojmej no̱ tatajtankej: —In nejeme̱n, ¿té̱ nikchi̱waskej? Juan kijtoj: —Amo agaj xikmajmajti̱ka̱n, niga xikna̱mo̱lpanti̱ka̱n ka̱nsan xikui̱li̱ka̱n itomi̱n Iwá̱n xitawelonóka̱nya, achó̱n ke̱ꞌya iga ankita̱niáj. ");
INSERT INTO nhx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nochi gente kitajtachi̱lijtoyaj Juan, iwá̱n motajtaniáj ipan iya̱lmajmej: “¿Ix el Cristo in Juan?” ");
INSERT INTO nhx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Eꞌ Juan kijtoj: —Nej, nimitzbautiza̱rowaj iga a̱ꞌti, eꞌ seꞌ yej wi̱ꞌ, yawi mitzbautiza̱ro̱tij iga el Espíritu Santo iwá̱n tiꞌti. Yéj má̱j tayaka̱ntoꞌ que nej, este akajasi iga nej manikxitomili imekayo igaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yéj kiki̱tzkijtoꞌ yej iga kichijchi̱wa trigo iga kitasolki̱xtiá. Iwá̱n trigo ka̱nas ka̱n moa̱na; eꞌ itasolyo kitati̱j ipan tiꞌti yej ayí̱ꞌ se̱wis. ");
INSERT INTO nhx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ijkó̱n, iwá̱n iga sekin má̱j tano̱no̱tzalis, Juan kipowilia̱ya ye̱ꞌnoti̱ciaj la gente. ");
INSERT INTO nhx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Iwá̱n Juan kajajwaꞌ el gobernador Herodes iga kikuiꞌ iga isiwa̱ꞌ ikuñada yej ito̱ka̱ꞌ Herodías, yej isíwa̱ꞌpa katka Felipe, iwá̱n iga inochi yej aye̱kti kichi̱waya Herodes. ");
INSERT INTO nhx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Eꞌ Herodes kíchijoꞌ má̱j yej aye̱kti iga kipre̱sojwij Juan. ");
INSERT INTO nhx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kua̱ꞌ Juan tabautiza̱rojtoya, kibautiza̱roj no̱ Jesús. Iwá̱n kua̱ꞌ Jesús ora̱dojtoya, cielo tapowiꞌ, ");
INSERT INTO nhx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","iwá̱n iyEspí̱ritoj Dios temoj ipan yéj, ken se̱ jojtoko iwá̱n mokaguiꞌ se̱ tájto̱l ipan cielo, kijtoj: —Tej nokta tinopiltzi̱n yej nimitzpoxcho̱kiliá, tej tine̱yo̱lchikajtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús kipiaya ken treinta años kua̱ꞌ pe̱waꞌ itekipáno̱l yej Dios kimáꞌ. Momatiá iga Jesús itaj ito̱ka̱ꞌ José. Elí mochij te̱taj iga José, ");
INSERT INTO nhx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","iwá̱n Matat mochij te̱taj iga Elí, iwá̱n Leví mochij te̱taj iga Matat, iwá̱n Melqui mochij te̱taj iga Leví, iwá̱n Jana mochij te̱taj iga Melqui, iwá̱n José mochij te̱taj iga Jana, ");
INSERT INTO nhx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","iwá̱n Matatías mochij te̱taj iga José, iwá̱n Amós mochij te̱taj iga Matatías, iwá̱n Nahúm mochij te̱taj iga Amós, iwá̱n Esli mochij te̱taj iga Nahúm, iwá̱n Nagai mochij te̱taj iga Esli, ");
INSERT INTO nhx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","iwá̱n Maat mochij te̱taj iga Nagai, iwá̱n Matatías mochij te̱taj iga Maat, iwá̱n Semei mochij te̱taj iga Matatías, iwá̱n Josek mochij te̱taj iga Semei, iwá̱n Judá mochij te̱taj iga Josek, ");
INSERT INTO nhx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","iwá̱n Joanán mochij te̱taj iga Judá, iwá̱n Resa mochij te̱taj iga Joanán, iwá̱n Zorobabel mochij te̱taj iga Resa, iwá̱n Salatiel mochij te̱taj iga Zorobabel, iwá̱n Neri mochij te̱taj iga Salatiel, ");
INSERT INTO nhx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","iwá̱n Melqui mochij te̱taj iga Neri, iwá̱n Adi mochij te̱taj iga Melqui, iwá̱n Cosam mochij te̱taj iga Adi, iwá̱n Elmodam mochij te̱taj iga Cosam, iwá̱n Er mochij te̱taj iga Elmodam, ");
INSERT INTO nhx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","iwá̱n Josué mochij te̱taj iga Er, iwá̱n Eliezer mochij te̱taj iga Jesús, iwá̱n Jorim mochij te̱taj iga Eliezer, iwá̱n Matat mochij te̱taj iga Jorim, ");
INSERT INTO nhx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","iwá̱n Leví mochij te̱taj iga Matat, iwá̱n Simeón mochij te̱taj iga Leví, iwá̱n Judá mochij te̱taj iga Simeón, iwá̱n José mochij te̱taj iga Judá, iwá̱n Jonam mochij te̱taj iga José, iwá̱n Eliaquim mochij te̱taj iga Jonam, ");
INSERT INTO nhx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","iwá̱n Melea mochij te̱taj iga Eliaquim, iwá̱n Mainán mochij te̱taj iga Melea, iwá̱n Matata mochij te̱taj iga Mainán, iwá̱n Natán mochij te̱taj iga Matata, ");
INSERT INTO nhx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","iwá̱n David mochij te̱taj iga Natán, iwá̱n Isaí mochij te̱taj iga David, iwá̱n Obed mochij te̱taj iga Isaí, iwá̱n Booz mochij te̱taj iga Obed, iwá̱n Salmón mochij te̱taj iga Booz, iwá̱n Naasón mochij te̱taj iga Salmón, ");
INSERT INTO nhx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","iwá̱n Aminadab mochij te̱taj iga Naasón, iwá̱n Aram mochij te̱taj iga Aminadab, iwá̱n Esrom mochij te̱taj iga Aram, iwá̱n Fares mochij te̱taj iga Esrom, iwá̱n Judá mochij te̱taj iga Fares, ");
INSERT INTO nhx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","iwá̱n Jacob mochij te̱taj iga Judá, iwá̱n Isaac mochij te̱taj iga Jacob, iwá̱n Abraham mochij te̱taj iga Isaac, iwá̱n Taré mochij te̱taj iga Abraham, iwá̱n Nacor mochij te̱taj iga Taré, ");
INSERT INTO nhx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","iwá̱n Serug mochij te̱taj iga Nacor, iwá̱n Ragau mochij te̱taj iga Serug, iwá̱n Peleg mochij te̱taj iga Ragau, iwá̱n Heber mochij te̱taj iga Peleg, iwá̱n Sala mochij te̱taj iga Heber, ");
INSERT INTO nhx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","iwá̱n Cainán mochij te̱taj iga Sala, iwá̱n Arfaxad mochij te̱taj iga Cainán, iwá̱n Sem mochij te̱taj iga Arfaxad, iwá̱n Noé mochij te̱taj iga Sem, y Lamec mochij te̱taj iga Noé, ");
INSERT INTO nhx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","iwá̱n Matusalén mochij te̱taj iga Lamec, iwá̱n Enoc mochij te̱taj iga Matusalén, iwá̱n Jared mochij te̱taj iga Enoc, iwá̱n Mahalaleel mochij te̱taj iga Jared, iwá̱n Cainán mochij te̱taj iga Mahalaleel, ");
INSERT INTO nhx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","iwá̱n Enós mochij te̱taj iga Cainán, iwá̱n Set mochij te̱taj iga Enós, iwá̱n Adán mochij te̱taj iga Set, iwá̱n Dios mochij te̱taj iga Adán. ");
INSERT INTO nhx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Kua̱ꞌ Jesús ki̱saꞌ ipan we̱ya̱ꞌ Jordán, kipiaya nokta iyEspí̱ritoj Dios, iwá̱n iyEspí̱ritoj Dios kiwi̱gaꞌ Jesús ipan desierto ka̱n ayá̱ꞌ cha̱ntitolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ompa onoya cuarenta días, ayá̱ꞌ takuaj ino̱mej días iwá̱n maya̱naꞌ. Iwá̱n Tzitzimiꞌ kinekiá iga Jesús makichi̱wa yej aye̱kti, ");
INSERT INTO nhx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","kijlij: —Siga tejya nokta iPiltzi̱n Dios, xikijli iní̱n teꞌti iga mamochi̱wa pa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús kijtoj: —Ijkí̱n ijkuilijtoꞌ itájto̱l Dios: “Ayá̱ꞌ gasan tákual wel ono ta̱gaꞌ, no̱ wel ono iga kichi̱wa ken kijtowa itájto̱l Dios.” ");
INSERT INTO nhx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Iwá̱n Tzitzimiꞌ kiwi̱gaꞌ Jesús ipan se̱ tepe̱ꞌ yej pox ajko iwá̱n kine̱xtilij nimani̱nsan inochi pai̱smej yej onoꞌ ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tzitzimiꞌ kijlij Jesús: —Nej nimitzta̱li̱j iga xikmanda̱ro inochi iní̱n mo̱nsaj pai̱smej yej nej ne̱makakej iwá̱n wel nikmaka a̱ꞌsan nej nikneki. ");
INSERT INTO nhx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Siga timotankua̱ketza iga tine̱weyimati̱ltiá, inochi nimitzmakas. ");
INSERT INTO nhx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús kijlij: —Tzitzimiꞌ, xicholo note̱noj, iga ijkí̱n ijkuilijtoꞌ itájto̱l Dios: “Xikweyimati̱lti moTe̱ko Dios iwá̱n xikchi̱wa kensan yéj kineki.” ");
INSERT INTO nhx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Iwá̱n Tzitzimiꞌ kiwi̱gaꞌ Jesús ipan weyi‑a̱ltepe̱ꞌ Jerusalén, kitejkawi̱ltij este iyi̱xko, ka̱n má̱j ajko ipan inó̱n weyitio̱pan, iwá̱n kijtoj Tzitzimiꞌ: —Siga tejya nokta iPiltzi̱n Dios, este nigaj ximopata̱nalti ta̱lpan; ");
INSERT INTO nhx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","iga itájto̱l Dios ijkí̱n ijkuilijtoꞌ: Dios kiti̱tanis iya̱ngelejmej iga mamitzpale̱wi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mitzmajkuitia̱skej, iga amo ximokxiwi̱teki ipan teꞌti. ");
INSERT INTO nhx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús kijlij: —Kijtowa no̱ itájto̱l Dios: “Amo xiktajtanili moTe̱ko Dios iga makichi̱wa tejté̱ iga san mane̱si iga wel kichi̱wa.” ");
INSERT INTO nhx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Tzitzimiꞌ kikajtejka Jesús kua̱ꞌ kitaꞌ iga awel kichi̱waltij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesús yajki sej Galilea, iwá̱n iyEspí̱ritoj Dios kipale̱wij iga nochi wel makichi̱wa. Ipan inó̱n ta̱jli no̱ya̱n momatiá yej yéjpa kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesús tamachtia̱ya ipan itio̱pamej israeli̱tajmej, iwá̱n nochi kiweyimati̱ltia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús yajki Nazaret, ka̱n moskaltij. Ipan día kua̱ꞌ mose̱wilo, kalaꞌ tio̱pan ken iga nochipa kichi̱waya. Iwá̱n moketzaꞌ iga kilee̱roj itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kimakakej se̱ a̱maꞌ yej kijkuiloj el profeta Isaías, iwá̱n kua̱ꞌ kitapoj, kasiꞌ ka̱n ijkí̱n ijkuilijtoꞌ: ");
INSERT INTO nhx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","IyEspí̱ritoj toTe̱ko ne̱pale̱wiá, Dios ne̱tapejpen iga manikui̱guili ye̱ꞌnoti̱ciaj yej ayá̱ꞌ motapialiáj. Ne̱ti̱tan iga manikachitialti yej moyo̱lmiktijtokej, iwá̱n iga manikijto̱ki ken iga maxitomika̱n yej ken ilpitokej, iwá̱n iga maniktachalti yej pachamej. Ne̱ti̱tan iga manikma̱nawi̱ki yej kikno̱chi̱waj. ");
INSERT INTO nhx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ne̱ti̱tan iga manikpowa iga toTe̱ko iná̱n tama̱nawí̱koya. ");
INSERT INTO nhx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iwá̱n Jesús kiki̱kimiloj in inó̱n a̱maꞌ iwá̱n kimáꞌ yej manda̱rowa, iwá̱n Jesús mota̱lij. Eꞌ yej ompa onoyaj tio̱pan, kitachi̱lijtikajkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Yéj kijtoj: —A̱man amo‑i̱xtaj mocumpli̱roj iní̱n yej nigaj ijkuilijtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nochi ye̱ꞌtajtoj iga Jesús, iwá̱n madmira̱dojkej iga pox mo̱nsaj yej kijtojtoya. Motajtaniáj: —¿In iní̱n ayejtaj ipiltzi̱n José? ");
INSERT INTO nhx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús kijtoj: —Amelá̱ꞌ anne‑ijli̱jnekij yej mojtowa: “Médico, ximoachitialti moma̱tika”; iwá̱n anne‑ijli̱skej: “Yej nikakikej yej tikchij Capernaum, xikchi̱wa no̱ nigaj ipan móta̱l.” ");
INSERT INTO nhx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Iwá̱n kijtoj sej Jesús: —Nimitzijliáj iga nisé̱ profeta ayá̱ꞌ kitajto̱lkuij ipan iya̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nimitzijliáj iga onoyaj komati viu̱dajmej ipan Israel kua̱ꞌ onoya el profeta Elías, kua̱ꞌ ayá̱ꞌ wetziꞌ tiawa̱ꞌ tres año y medio iwá̱n no̱ya̱n a̱pistajtitoya; ");
INSERT INTO nhx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","eꞌ, Dios ayá̱ꞌ kiti̱tan Elías cha̱n nisé̱ yej we̱wejmíꞌ de Israel, kiti̱tan iga mayawi cha̱n se̱ yej we̱wejmíꞌ de Sarepta yej onoꞌ ite̱noj a̱ltepe̱ꞌ Sidón. ");
INSERT INTO nhx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Inó̱n ve̱j kua̱ꞌ onoya Eliseo, onoyaj no̱ komati de Israel yej pala̱ntia̱ya inakayomej iga kipiayaj lepra. Eꞌ nisé̱ de Israel ayá̱ꞌ kipajtilij, se̱tzi̱n kipajtilij yej ito̱ka̱ꞌ Naamán yej icha̱n ipan país de Siria. ");
INSERT INTO nhx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Kua̱ꞌ inó̱n kikakikej, inochi yej onoyaj tio̱pan, pox kuejkuesiwikej. ");
INSERT INTO nhx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Moketzkej ka̱n eje̱watoyaj, kiki̱xtijkej Jesús ipan a̱ltepe̱ꞌ; inó̱n a̱ltepe̱ꞌ onoya iyi̱xko tepe̱ꞌ, iwá̱n Jesús kiwi̱gakej este ka̱n má̱j ajko ipan tepe̱ꞌ, iga ompa makibarranca̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Eꞌ Jesús panoj tatza̱la̱n, iwá̱n yájkiya. ");
INSERT INTO nhx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús yajki ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Capernaum, estado de Galilea, iwá̱n ipan día kua̱ꞌ mose̱wilo, tamachtia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iwá̱n yejeme̱n madmira̱dowa̱yaj ken iga tamachtia̱ya, porque kua̱ꞌ tajtowa̱ya ne̱siá iga kimati te̱ nemi kijtowa. ");
INSERT INTO nhx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Tio̱pan onoya se̱ ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj, iwá̱n tzajtziꞌ iga kijtoj: ");
INSERT INTO nhx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Xine̱kajte̱waka̱n; ¿té̱ tikpiá iwá̱n nejeme̱n, Jesús de Nazaret? ¿Ix tiwa̱laj iga anne̱polo̱koj? Nej nimitzi̱xmati a̱ꞌyéj tej, tejwaꞌ yej atikchi̱wa yej aye̱kti iwá̱n mitzti̱tan Dios. ");
INSERT INTO nhx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iwá̱n Jesús kajajwaꞌ inó̱n ma̱lespí̱ritoj, kijlij: —¡Ayoꞌ xitzajtzito! ¡Xikajte̱wa iní̱n ta̱gaꞌ! Iwá̱n inó̱n ma̱lespí̱ritoj kiwetzi̱ltij este ipan ta̱jli in inó̱n ta̱gaꞌ, iyi̱xtaj ino̱mej gente, iwá̱n ki̱saꞌ ipan inó̱n ta̱gaꞌ, iwá̱n até̱ kichi̱wilij. ");
INSERT INTO nhx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nochi momajtijkej iwá̱n mose̱sepan‑ijlia̱yaj: —Ayí̱ꞌ tikakij yej ijkí̱n matajto; iní̱n ta̱gaꞌ pox wel tatekimaka; ¡ma̱lespi̱ritojmej kicre̱dowaj iwá̱n ki̱saj! ");
INSERT INTO nhx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Iwá̱n nochi yej kichi̱waya Jesús, no̱ya̱n momatiá ipan inó̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús ki̱saꞌ tio̱pan iwá̱n yajki cha̱n Simón. Kasito imona̱n Simón poxsan kawa̱ntoꞌ, iwá̱n kijlijkej Jesús iga makachitialti. ");
INSERT INTO nhx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús moto̱loj ka̱n wetztoya imona̱n Simón iwá̱n kajajwaꞌ kawa̱n iwá̱n sé̱wiꞌya ikajlo̱ꞌ. Iwá̱n íkua̱ꞌsan moketzaꞌ in imona̱n Pedro, iwá̱n kíchija tákual iga tatamáꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kua̱ꞌ kálaꞌya to̱nati̱ꞌ, nochi yej kipiayaj icha̱mej yej se̱seꞌpa iga we̱titoyaj, kiwi̱gakej ka̱n onoya Jesús; iwá̱n kita̱lij ima̱ꞌ ipan sejsé̱ de yejeme̱n iwá̱n kachitialtijkej. ");
INSERT INTO nhx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Miaꞌ kipiayaj ma̱lespí̱ritoj, iwá̱n kua̱ꞌ ki̱sayaj, tzajtziáj, kijtowa̱yaj: —Tej iPiltzi̱n Dios. Eꞌ Jesús kajajwaya ma̱lespi̱ritojmej, ayá̱ꞌ kimakaltia̱ya iga matajto̱ka̱n, porque kimatiáj iga Jesús el Cristo yej Dios kiti̱tan. ");
INSERT INTO nhx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kua̱ꞌ tane̱siꞌ, Jesús ki̱saꞌ ipan a̱ltepe̱ꞌ iwá̱n yajki ka̱n ayagaj onoꞌ. Eꞌ la gente kite̱mojkej iwá̱n asikej este ka̱n onoya. Kinekiáj iga maká̱wi‑oꞌ iwá̱n aya mayawi, ");
INSERT INTO nhx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","eꞌ Jesús kijlij la gente: —Es que nia no̱ nikpowati ye̱ꞌnoti̱ciaj ipan seꞌ a̱ltepe̱mej iga ken reina̱rowa Dios, iga inó̱n nokta ne̱ti̱tankej. ");
INSERT INTO nhx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ijkó̱n Jesús kipojtinemiá itájto̱l Dios ipan tio̱pamej yej onoꞌ Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Se̱ día Jesús onoya Genesaret ipan lagu̱najte̱n, iwá̱n wa̱lkej komati gente este kipi̱pitzkowa̱yaj Jesús iga kikakisnekiáj itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Iwá̱n Jesús kitaꞌ o̱me á̱ka̱l yej onoyaj ipan a̱te̱n, iwá̱n yej tama̱tawiáj temojkej iga kipajpa̱kaj irre̱dejmej. ");
INSERT INTO nhx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Iwá̱n Jesús tejkaj ipan se̱ de ino̱mej á̱ka̱l yej itátkipa Simón. Iwá̱n Jesús kijlij Simón iga achi má̱j makiwejkatili á̱ka̱l iga a̱tate̱n. Iwá̱n Jesús mota̱lij ipan á̱ka̱l iga kimachtij yej ompa chapa̱ntokej. ");
INSERT INTO nhx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Kua̱ꞌ támiꞌya tamachtij, Jesús kijlij Simón: —Xikui̱ga moá̱ka̱l ka̱n ma̱jya wejkatan iwá̱n ompa xito̱pojma̱ka̱n iga amoatarra̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón kijtoj: —Tamachtia̱ni, senyówal nito̱pojmajkej iwá̱n nisé̱ aniki̱tzkijkej. Ya que tej nemi tine̱tekimaka, nia sej nito̱pojma̱ti. ");
INSERT INTO nhx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Kua̱ꞌ inó̱n kichijkej, kiki̱tzkijkej komati to̱poj, iwá̱n este tzajtzaya̱niꞌ irre̱dejmej. ");
INSERT INTO nhx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iwá̱n kima̱no̱tzkej yej onoyaj ipan seꞌ á̱ka̱l iga maya̱ka̱n makipale̱wi̱tij. Iwá̱n yajkij, iwá̱n kite̱mijkej iyo̱mexti á̱ka̱l, iwá̱n este ken a̱wetziaja. ");
INSERT INTO nhx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kua̱ꞌ iní̱n kitaꞌ Simón Pedro, motankua̱ketzaꞌ ite̱noj Jesús iwá̱n kijlij: —NoTe̱ko, amo xine̱techo iga nej ayá̱ꞌ niye̱ꞌnemi. ");
INSERT INTO nhx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ijkó̱n kijtoj Pedro iga pox majmatoya; ijko̱nsan no̱ nochi yej íwa̱n nemiáj iga pox komati yej kiki̱tzkijkej. ");
INSERT INTO nhx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","No̱ momajtij Jacobo iwá̱n Juan yej ipilowa̱n Zebedeo, yej tekipanowa̱yaj iwá̱n Simón. Eꞌ Jesús kijlij Simón: —Amo ximajmawi, iná̱n tipe̱was iga tiknechkowa yej mane̱tokaka̱n, ken iná̱n to̱poj tiki̱tzkiá. ");
INSERT INTO nhx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Iwá̱n kua̱ꞌ kiki̱xtíjkeja iya̱ka̱lmej ipan a̱tate̱n, ómpaya kikajtejkej inewi iwá̱n kitokákeja Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Se̱ día onoya Jesús ipan se̱ a̱ltepe̱ꞌ, wa̱laj se̱ ta̱gaꞌ yej nemi pala̱ni ikajlo̱ꞌ iga kipiaya lepra. Iwá̱n kua̱ꞌ kitaꞌ Jesús, motankua̱ketzaꞌ iwá̱n motzonto̱gaꞌ este ipan ta̱jli iwá̱n ijkí̱n kicho̱kistajtanilij: —Note̱ko, siga tej tikneki, wel xine̱pajti. ");
INSERT INTO nhx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús kichijchin iga ima̱ꞌ iwá̱n kijlij: —Kena, nikneki xipajti. Iwá̱n íkua̱ꞌsan pajtiꞌ ka̱n pala̱ntia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesús kijlij inó̱n yej achitiáꞌ iga amo agaj makijli a̱ꞌ kipajtij, iwá̱n kijlij: —Xaj ka̱n onoꞌ sacerdote iga mamitzita, iwá̱n xikmaka moofre̱ndaj Dios, ken Moisés tatekimáꞌ, iga Dios mitzpájtija iwá̱n iga mamomati iga tipájtiꞌya. ");
INSERT INTO nhx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","No̱ya̱n momatitia̱ya iga taachitialtia̱ya Jesús, iwá̱n komati gente monechkowa̱yaj iga makikakika̱n yej kijtowa iwá̱n iga makachitialti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Eꞌ Jesús kikajte̱wa̱ya la gente iga ise̱lti ya̱ya tajto̱ti iwá̱n Dios ka̱n ayagaj onoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Se̱ día tamachtijtoya Jesús, iwá̱n ompa e̱watoyaj fariseojmej iwá̱n yej tamachtiáj ipan iley Moisés, yej wa̱lkej de inochi a̱ltepe̱mej yej onoꞌ ipan estado de Galilea, de Judea iwá̱n de Jerusalén; iwá̱n ipode̱r Dios mone̱xtia̱ya kua̱ꞌ Jesús taachitialtia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Iwá̱n asikej sekin tajta̱gaꞌ yej kiwajliguilijkej ipan tapech se̱ ta̱gaꞌ yej awel nejnemi nokta. Kinekiáj makaki̱ka̱n kalijtiꞌ iga makite̱kaka̱n iyi̱xtaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Eꞌ awel kalakkej iga pox onolo̱ꞌ. Tejkajkej iyi̱xko kajli iwá̱n kixiti̱nkej ipetayo, iwá̱n ompa kipi̱pilojtitemowijkej ipan itapech in inó̱n yej awel nejnemi iga kita̱lkej tajkoya̱n, ite̱noj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Kua̱ꞌ Jesús kitaꞌ ken iga moconfia̱rowa̱yaj ipan yéj, kijlij yej we̱titoya: —Nochi yej tikchij yej aye̱kti, nimitze̱lka̱wiliaya. ");
INSERT INTO nhx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iwá̱n fariseojmej iwá̱n yej tamachtiáj ipan iley Moisés, kijtojkej ipan iya̱lmajmej: “¡Iní̱n ta̱gaꞌ nemi kima̱lijliá Dios! Ayagaj wel tae̱lka̱wiliá yej se̱ kichi̱wa yej aye̱kti, petz Dios san.” ");
INSERT INTO nhx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Eꞌ Jesús kimatiá te̱ kejla̱ntoyaj, iwá̱n kijtoj: —Amejeme̱n, ¿te iga ijkó̱n ankejla̱mikij ipan amoa̱lmajmej? ");
INSERT INTO nhx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Katiá má̱j wel manikijli: “Nochi yej tikchij yej aye̱kti nimitze̱lka̱wílija”, o manikijli: “Ximoketza iwá̱n xaja”? ");
INSERT INTO nhx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","A̱n sí, nia nimitzne̱xtili̱tij iga nej yej iPiltzi̱n Ta̱gaꞌ, ipan iní̱n ta̱jli wel nike̱lka̱wiliá yej se̱ kichi̱wa yej aye̱kti. Iwá̱n Jesús kijlij yej awel nejnemi: —Tej nimitzijliá, ximoketza, xikui motapech iwá̱n xaja mocha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Iwá̱n in inó̱n yej awel nejnemiá; íkua̱ꞌsan moketzaꞌ iyi̱xtajmej, kikuiꞌ itapech ka̱n wetztoya iwá̱n yájkiya icha̱n, iwá̱n kiweyimati̱ltijtia̱ya Dios. ");
INSERT INTO nhx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iwá̱n nochi tajtachi̱xtikajkej iwá̱n kiweyimati̱ltijkej Dios. Iwá̱n majmatitajtojkej: —Iná̱n sí, tikitakej yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kua̱ꞌ ki̱saꞌ Jesús, kitaꞌ se̱ yej kicobra̱rojtoya impuestos iga Roma. Inó̱n ta̱gaꞌ ito̱ka̱ꞌ Leví, e̱watoya ompa ka̱n kicobra̱rojtoya impuestos. Jesús kijlij: —Xine̱toka. ");
INSERT INTO nhx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Iwá̱n Leví moketzaꞌ, kikajtej inewi itekipáno̱l, iwá̱n kitogaꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Iwá̱n Leví icha̱n, kichij weyi‑ilwiꞌ iga Jesús. Ompa onoyaj miaꞌ yej no̱ yej kicobra̱rojtoya impuestos iga gobierno iwá̱n sékinoꞌ má̱j yej ki̱xna̱ntoyaj mesa iwá̱n yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eꞌ fariseojmej iwá̱n yej tamachtiáj ipan iley Moisés, pe̱wakej iga kipo̱powaj idisci̱polojmej Jesús, kijlijkej: —¿Te iga ansentakuaj iwá̱n ansen‑a̱tij iwá̱n yej kicobra̱rowa̱yaj impuestos iga Roma iwá̱n yej kichi̱waj yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús kijtoj: —Yej ye̱ktitokej ayá̱ꞌ kinekij yej maki‑achitialti̱ka̱n, sino que yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nej ayá̱ꞌ niwa̱laj nikno̱tzako yej kijtowaj iga ye̱ꞌnemij. Ma̱jwaꞌ niwa̱laj nikno̱tzako yej kichi̱waj yej aye̱kti iga mamoyo̱lpataka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kijlijkej Jesús: —¿Te iga yej kitokaj Juan iwá̱n yej kitokaj fariseojmej pox mayuna̱rowaj iwá̱n pox ora̱dowaj, eꞌ modisci̱polojmej nochipa a̱tij iwá̱n takuaj? ");
INSERT INTO nhx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús kijtoj: —Awel mayuna̱ro̱skej te‑ikni̱wa̱n ka̱n mona̱miktilo kua̱ꞌ ompa onoꞌ iwa̱mej chokotzi̱n yej mona̱miktiá. ");
INSERT INTO nhx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ásissan día iga kiwi̱gaskej in chokotzi̱n; íkua̱ꞌ kena, mayuna̱ro̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iwá̱n kipowaꞌ no̱ iní̱n iga mami̱xkui̱tilo: —Ayagaj kiteki tájkol inue̱vojwí̱pi̱l iga makitamani iwi̱pi̱lsósol. Siga kichí̱ ijkó̱n, kisosolo̱j inue̱vojwí̱pi̱l. Iwá̱n ayá̱ꞌ ye̱ꞌne̱sis wi̱pi̱lsósol iga tamanijtos iga tájkol yej nué̱vojoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ipan ikyapakuetaxtekon awel no̱ moakiá vino yej kichíjkejoꞌ iga vino yej kichíjkejoꞌ moposa̱wa iwá̱n kipoxo̱nas kuetaxtekon iwá̱n ne̱mpoliwis vino iwá̱n kuetaxtekon. ");
INSERT INTO nhx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Inó̱n iga, ye̱kti iga ipan kuetaxtekon yej móchijoꞌ mamoaki vino yej kichíjkejoꞌ. Ijkó̱n apoliwis vino niga kuetaxtekon. ");
INSERT INTO nhx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Iwá̱n ni agaj yej koniá ikyapavi̱noj kinekis makoni yej kichíjkejoꞌ, iga kijtowa: “Mataj ikyapavi̱noj má̱j xo̱chajya̱ꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Se̱ día kua̱ꞌ mose̱wilo, Jesús pano̱tia̱ya mi̱lijtiꞌ, iwá̱n idisci̱polojmej pe̱ꞌ iga kitektiajkij trigo iwá̱n ko̱xtia̱yaj iga ima̱mej iwá̱n kikuajtia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sekin fariseojmej kijtojkej: —¿Te iga ankichi̱waj tekipáno̱l yej aye̱kti mamochi̱wa ipan día kua̱ꞌ mose̱wilo? ");
INSERT INTO nhx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús kijlij: —¿Ix ayí̱ꞌ ankilee̱rojkej yej kichij David iwá̱n yej senemiáj kua̱ꞌ maya̱nakej? ");
INSERT INTO nhx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kalaꞌ tio̱pan, kikuiꞌ pa̱nmej yej itátkipa Dios. David kikuaj ino̱mpa pa̱n iwá̱n kimáꞌ no̱ yej íwa̱n nemiáj, malej iga ayá̱ꞌ wel kikua̱ya ná̱mo̱l, petz sacerdo̱tejmej wel kikua̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iwá̱n kijtoj Jesús: —Nej yej iPiltzi̱n Ta̱gaꞌ wel nitatekimaka te̱ wel mamochi̱wa ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ipan sewoꞌ día kua̱ꞌ mose̱wilo, Jesús kalaꞌ tio̱pan iwá̱n pe̱waꞌ iga tamachtij. Iwá̱n ompa onoya se̱ ta̱gaꞌ yej takua̱wayaxtoꞌ iye̱ꞌma̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Iwá̱n ino̱mej yej tamachtiáj ipan iley Moisés iwá̱n fariseojmej kipi̱piayaj Jesús iga makitaka̱n siga kachitialti̱j ipan día kua̱ꞌ mose̱wilo. Iga ijkó̱n wel makasika̱n ken iga makite̱lwi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Eꞌ Jesús kimatiá te̱ kejla̱ntoyaj, iwá̱n kijlij ta̱gaꞌ yej ma̱takua̱wayaxtoꞌ: —Ximoketza iwá̱n xiwi̱ki tatajkoya̱n. Iwá̱n ta̱gaꞌ moketzaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iwá̱n Jesús kijtoj: —Nia nimitztajtanitij: ¿Té̱ a̱n wel mochi̱wa ipan día kua̱ꞌ mose̱wilo; yej ye̱kti o yej aye̱kti? ¿Mamoachitialti agaj o mamomikti? ");
INSERT INTO nhx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Iwá̱n Jesús kitachi̱lij inochi yej ompa onoyaj iwá̱n kijlij inó̱n ta̱gaꞌ: —Xikmela̱wa moma̱ꞌ. Ijkó̱n kichij in ta̱gaꞌ iwá̱n ye̱ktiaꞌya ima̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yej ompa onoyaj poxsan kuejkuesiwikej, iwá̱n pe̱wakej iga mota̱tapo̱wijkej té̱ wel kichi̱wilia̱yaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ayá̱ꞌ wejkatiꞌ, Jesús yajki tajto̱to iwá̱n Dios ipan se̱ tepe̱ꞌ iwá̱n senyówal ora̱dojtoya. ");
INSERT INTO nhx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kua̱ꞌ tané̱siꞌya, kino̱tzaꞌ idisci̱polojmej iwá̱n kitapejpen doce de yejeme̱n, ino̱mej kito̱ka̱wij apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Iní̱n ito̱ka̱mej: Simón yej no̱ kito̱ka̱wij Pedro; Andrés yej iyikni̱n Simón, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO nhx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo yej ipiltzi̱n Alfeo; Simón yej iparti̱doj nacionalista, ");
INSERT INTO nhx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, yej iyíkni̱mpa Jacobo iwá̱n Judas Iscariote yej má̱j despué̱j kine̱xtij iga makiki̱tzki̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús temoj iwa̱mej ipan tepe̱ꞌ, iwá̱n ka̱witoj ipan planada. Iwá̱n ompa onoyaj idisci̱polojmej iwá̱n no̱ komati yej wa̱lkej ipan estado de Judea, iwá̱n yej icha̱mej a̱ltepe̱ꞌ Jerusalén iwá̱n no̱ yej icha̱mej lama̱rte̱noj na̱ꞌ a̱ltepe̱mej Tiro iwá̱n Sidón. Asikej ompa iga kikakitoj itájto̱l Jesús iwá̱n iga maachitiaka̱n yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iwá̱n yej kipiayaj ma̱lespi̱ritojmej no̱ kachitialtia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Iwá̱n nochi kinekiáj makichijchimika̱n Jesús, iga ipan yéj ki̱saya poder iwá̱n inochi kachitialtia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iwá̱n Jesús kitachi̱lij idisci̱polojmej iwá̱n kijlij: —Xipa̱ktoka̱n yej ayá̱ꞌ anmotapialiáj, iga ankipiáj Dios iga amoTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Xipa̱ktoka̱n amejeme̱n yej iná̱n anmaya̱naj iga an‑ixwiskej. ’Xipa̱ktoka̱n yej iná̱n ancho̱kaj, iga anwetzkaskej. ");
INSERT INTO nhx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Xipa̱ktoka̱n kua̱ꞌ mitzijiyaj, iwá̱n kua̱ꞌ mitzki̱xtiáj ipan amoa̱ltepe̱ꞌ iga akinekij xonoka̱n iwa̱mej, iwá̱n kua̱ꞌ kuajkuantas mitzijliáj iwá̱n kua̱ꞌ mitzpi̱najtiáj iga anne̱tokaj nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Xipa̱kika̱n este xiwi̱wito̱nika̱n inó̱n día, iga ipan cielo yawij mitzmakatij yej pox ye̱kti, iga ijko̱nsan no̱ iyikyapatajmej ini̱mej gente kipoxikno̱chijkej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Eꞌ anla̱stimajmej yej ankipoxpiáj tomi̱n, iga nij ampa̱kíkeja. ");
INSERT INTO nhx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Anla̱stimajmej yej iná̱n an‑ixwitokej, porque anyawij anmaya̱natij. ’Anla̱stimajmej yej iná̱n anwetzkaj, iga anyawij ancho̱katij iwá̱n anmokno̱matiskej. ");
INSERT INTO nhx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Anla̱stimajmej kua̱ꞌ inewi tajta̱gaꞌ ye̱ꞌtajto̱skej iga amejeme̱n, iga ijko̱nsan no̱ iyikyapatajmej yejeme̱n ye̱ꞌtajtojkej iga yej ayéj melaꞌprofe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Eꞌ amejeme̱n yej anne̱kaktokej nimitzijliáj: Xikcho̱kili̱ka̱n yej ayá̱ꞌ mitzye̱ꞌitaj, xikchi̱wili̱ka̱n yej ye̱kti yej mitzijiyaj. ");
INSERT INTO nhx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xikye̱ꞌijli̱ka̱n yej mitzma̱lijliáj. Xikte̱ne̱wi̱ka̱n Dios iga ino̱mej yej mitzpantiáj. ");
INSERT INTO nhx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Siga agaj mitzxa̱ygatatzi̱na, xikmaka seꞌ moxa̱yaꞌ iga mamitzmaga, iwá̱n siga agaj mitzkui̱liá mochama̱rraj, xikmaka no̱ mokua̱ch iga makiwi̱ga. ");
INSERT INTO nhx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Siga agaj mitztajtaniliá tejté̱, xikmaka, iwá̱n yej mitzkui̱liá yej motátkipa, amo xiktajtanili iga mamitzkuepili. ");
INSERT INTO nhx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xikchi̱wili̱ka̱n sekin ijkó̱n ken amejeme̱n ankinekij mamitzchi̱wili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Siga ankicho̱kiliáj yejsan no̱ mitzcho̱kiliáj, ¿té̱ anmota̱nili̱skej? Este yej kichi̱waj yej aye̱kti, ijkó̱n no̱ kichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Siga ankichi̱wiliáj yej ye̱kti yejsan mitzchi̱wiliáj yej ye̱kti, ¿té̱ anmota̱nili̱skej? Ijkó̱n no̱ kichi̱waj yej ayá̱ꞌ ye̱ꞌnemij. ");
INSERT INTO nhx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Iwá̱n siga ankita̱ke̱waltiáj tomi̱n ino̱mej yejsan wel mitzkuepiliáj, ¿té̱ anmota̱nili̱skej? Yej kichi̱waj yej aye̱kti no̱ kita̱ke̱waltiáj yejsan wel kikuepili̱skej seꞌ achó̱n. ");
INSERT INTO nhx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Eꞌ amejeme̱n xikcho̱kili̱ka̱n yej mitzijiyaj iwá̱n xikchi̱waka̱n yej ye̱kti, iwá̱n siga antata̱ke̱waltiáj tejté̱, amo xikchaka̱n iga mamitzkuepili̱ka̱n. Ijkó̱n anmota̱nili̱skej yej pox ye̱kti, iwá̱n amejeme̱n anmochi̱waskej ipilowa̱n Dios yej ajko onoꞌ, iga yéj no̱ kikne̱liá yej ayá̱ꞌ taagradece̱rowaj iwá̱n yej kichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Amejeme̱n xita‑ikne̱li̱ka̱n kensan no̱ amoTaj Dios ta‑ikne̱liá. ");
INSERT INTO nhx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Amo xitajuzga̱ro̱ka̱n iwá̱n Dios ayá̱ꞌ no̱ mitzjuzga̱ro̱skej. Amo xikijli̱ka̱n ni agaj iga ayompa nemi, iwá̱n Dios no̱ ayá̱ꞌ mitzijli̱skej iga ayompa annemij. Xike̱lka̱waka̱n yej mitzchi̱wiliáj yej aye̱kti, iwá̱n Dios no̱ ijkó̱n mitzchi̱wili̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yej ankipiáj xikmakaka̱n sekin, iwá̱n Dios no̱ mitzmakaskej. Yawi mitzmakatij ipan amomórra̱l este te̱mis, este tejtekualtitos, iwá̱n este áyoꞌya kitolo̱j amomórra̱l. Achó̱n ke̱ꞌ agaj ankimakaskej, acho̱nsan no̱ Dios mitzmakaskej. ");
INSERT INTO nhx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús ijkí̱n kijtoj iga mami̱xkui̱tilo: —¿Ix wel se̱ pacha kima̱wila̱ntiá seꞌ pacha iga makojkui̱lti? ¿Ix ayá̱ꞌ a̱n wetziskej iyo̱mextimej ipan se̱ xapoꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yej nemi momachtiá ayá̱ꞌ má̱j tamati ken yej tamachtiá, kua̱ꞌ kitámi̱jya iga momachti̱j, kaxíli̱jya yej tamachtiá. ");
INSERT INTO nhx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Te iga tiki̱xtachi̱liá mokni̱n iga kipiá tasoltzi̱n ipan iyi̱x iwá̱n ayá̱ꞌ tikita iga tej tikpiá tapan ipan moyi̱x? ");
INSERT INTO nhx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Siga ayá̱ꞌ tikita iga tikpiá weyi tapan ipan moyi̱x, ¿kén timi̱xe̱wiá iga tikijliá mokni̱n: “Nokni̱n, achi manimitzki̱xtili tasoltzi̱n yej tikpiá ipan moyi̱x”? ¡Tej yej timopajpantiá iga tiye̱ꞌnemi!, xiki̱xti achto inó̱n tapan yej onoꞌ ipan moyi̱x iwá̱n ijkó̱n wel tikye̱ꞌitas iga tiki̱xtiliá tásol ipan iyi̱x mokni̱n. ");
INSERT INTO nhx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Nisé̱ kuawiꞌ yej mokua̱liá ita̱kilka wel kipiá ita̱kilka yej ayá̱ꞌ mokua. Iwá̱n kuawiꞌ yej ayá̱ꞌ mokua̱liá ita̱kilka, awel no̱ kipiá ita̱kilka yej mamokua. ");
INSERT INTO nhx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sejsé̱ kuawiꞌ mo‑i̱xmati ipansan ita̱kilka: ayá̱ꞌ moteki ita̱kilka a̱makuawiꞌ ipan witzkuawiꞌ, niga moteki uva ipan cha̱wawitz. ");
INSERT INTO nhx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ta̱gaꞌ yej ye̱ꞌnemi, ye̱ꞌtajtowa, iga ipan iya̱lmaj kejla̱ntoꞌ yejsan ye̱kti. Iwá̱n ta̱gaꞌ yej ayá̱ꞌ ye̱ꞌnemi, kuajkuantas kijtowa iga ipan iya̱lmaj onoꞌ yej ajaye̱kti, iga yej onoꞌ ipan iya̱lmaj inó̱n kijtowa. ");
INSERT INTO nhx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Te iga anne‑ijliáj “NoTe̱ko, noTe̱ko”, iwá̱n ayá̱ꞌ ankichi̱waj yej nimitzijliáj? ");
INSERT INTO nhx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nia nimitzijli̱tij ken ne̱si inó̱n yej wi̱ꞌ note̱noj, yej kikaki notájto̱l iwá̱n kichi̱wa yej nikijtowa. ");
INSERT INTO nhx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Inó̱n ken tikita se̱ ta̱gaꞌ yej kichij íkal de material. Achto ta̱lichkuaꞌ wejkatan iga kajli mataksato ipan weyiteꞌti. Kua̱ꞌ weyáꞌ a̱ꞌti iwá̱n wa̱laj a̱rreso̱moj yej pox tajpalej ipan kajli, niga wel ko̱li̱n, iga inó̱n kajli to̱ktoꞌ ipan teꞌti. ");
INSERT INTO nhx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Eꞌ yej ne̱tajto̱lkaki iwá̱n ayá̱ꞌ kichi̱wa yej nikijtowa, inó̱n ken tikita se̱ ta̱gaꞌ yej kichij íkal ipan petz ta̱jli iwá̱n ayá̱ꞌ kipiá ka̱n taksatoꞌ. Iwá̱n kua̱ꞌ weyáꞌ a̱ꞌti, wa̱laj a̱rreso̱moj yej pox tajpalej ipan inó̱n kajli iwá̱n inó̱n kajli wetziꞌ iwá̱n melaꞌxi̱xiti̱niꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kua̱ꞌ Jesús tamiꞌ tata̱tapo̱wij, yajki a̱ltepe̱ꞌ Capernaum. ");
INSERT INTO nhx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ompa cha̱ntitoya se̱ capitán yej kimanda̱rowa̱ya solda̱dojmej de Roma, kipiaya se̱ itekipanowa̱ni yej kipoxcho̱kilia̱ya, eꞌ we̱titoya. Ali̱nsan poliwiá iga mikiá. ");
INSERT INTO nhx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kua̱ꞌ inó̱n capitán kikaguiꞌ yej Jesús kichijtoꞌ, kiti̱tan we̱wetkej yej kimanda̱rowaj judiyojmej iga makijli̱tij Jesús iga makachitialti itekipanowa̱ni inó̱n capitán. ");
INSERT INTO nhx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yejeme̱n yajkij kitatoj Jesús, iwá̱n ijkí̱n kitejtekiꞌijlijkej: —Inó̱n capitán kajasi iga xikpale̱wi, ");
INSERT INTO nhx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","iga kiye̱ꞌita tokni̱wa̱n yej no̱ israeli̱tajmej, iwá̱n yéj ne̱chi̱wilijkej notio̱pamej. ");
INSERT INTO nhx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús yajki iwa̱mej. Eꞌ kua̱ꞌ asitiá̱yaja cha̱n inó̱n capitán, inó̱n capitán kiti̱tan iyami̱gojmej iga ijkí̱n makijli̱tij: —NoTe̱ko, akajasi xikalaki nocha̱n, ayá̱ꞌ neajasi iga xasi nokalijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Inó̱n iga ayá̱ꞌ nimi̱xe̱wij iga nimitzte̱mo̱to noma̱tika. Eꞌ xikíjtosan iga maye̱ktiá notekipanowa̱ni iwá̱n ye̱ktiás. ");
INSERT INTO nhx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nej no̱ onoꞌ yej ne̱tekimaka iwá̱n no̱ niktekimaka solda̱dojmej. Kua̱ꞌ nikti̱tani se̱ mayawi kanaj, yawi; iwá̱n kua̱ꞌ seꞌ nikijliá iga mawi̱ki, wi̱ꞌ; iwá̱n kua̱ꞌ nikijliá notekipanowa̱ni iga makichi̱wa tejté̱, kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kua̱ꞌ inó̱n kikáꞌ Jesús, madmira̱doj, iwá̱n kitachi̱lij yej kitokatinemiáj, kijlijkej: —Nimitzijliáj iga anikasiꞌ nisé̱ israelita yej mamopoxconfia̱ro ipan nej ken iní̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kua̱ꞌ tati̱tanimej yajkij icha̱n capitán, kasitoj tekipanowa̱ni, achitiaꞌya. ");
INSERT INTO nhx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jesús iwá̱n idisci̱polojmej iwá̱n komati gente nemi ya̱yaj ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Naín. ");
INSERT INTO nhx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kua̱ꞌ asitiá̱yaja ipan a̱ltepe̱ꞌ, kitaꞌ iga nemi yawij kito̱katij se̱ yej miꞌ, yej ise̱lpiltzi̱n se̱ yej we̱wejmíꞌ. Miaꞌ kipo̱lojtia̱yaj yej de ompamej. ");
INSERT INTO nhx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kua̱ꞌ toTe̱ko kitaꞌ, cho̱gaꞌ iya̱lmaj iga inó̱n viuda, iwá̱n kijlij: —Amo xicho̱ka. ");
INSERT INTO nhx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iwá̱n kitechoj tapechtzi̱n ka̱n mejmelajtia̱ya á̱nimaj iwá̱n kichijchin. Iwá̱n mokejketzkej yej nemi kiwi̱gayaj. Jesús kijlij á̱nimaj: —Chokotzi̱n, nimitzijliá: ¡ximoketza! ");
INSERT INTO nhx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iwá̱n mota̱lij in yej miktoyay iwá̱n pé̱waꞌya tajtoj. Iwá̱n Jesús kimaꞌya iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iwá̱n nochi yej ompa onoyaj momajtijkej iwá̱n ijkí̱n kiweyimati̱ltia̱yaj Dios: —Te‑i̱xna̱mikiko se̱ profeta yej kipoxpiá poder. Iwá̱n kijtowa̱yaj no̱: —Dios wa̱laj kipale̱wi̱ko ige̱ntej. ");
INSERT INTO nhx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Iwá̱n yej kichij Jesús, no̱ya̱n Judea momatiꞌ iwá̱n este ipan a̱ltepe̱mej yej najna̱ꞌsan onokej. ");
INSERT INTO nhx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan kimatiꞌ yej kichij Jesús iga kipowilijkej idisci̱polojmej. Iwá̱n Juan kino̱tzaꞌ o̱me idiscí̱poloj, ");
INSERT INTO nhx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","iwá̱n kiti̱tan iga makitajtanitij Jesús: “¿Ix tejya in Cristo yej yawi wi̱tzeti, o nikcháskejoꞌ sewoꞌ?” ");
INSERT INTO nhx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kua̱ꞌ idisci̱polojmej Juan kitechojkej Jesús, kijlijkej: —Juan yej tabautiza̱rowa ne̱ti̱tankej iga manimitztajtanikij; “¿Ix téjyakiꞌ in Cristo yej yawi wi̱tzeti, o nikcháskejoꞌ sewoꞌ?” ");
INSERT INTO nhx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iwá̱n íkua̱ꞌ Jesús kachitialtij miaꞌ yej se̱seꞌpa iga we̱titoyaj, iwá̱n yej kipiayaj ma̱lespí̱ritoj, iwá̱n no̱ kitachaltij miaꞌ pachamej. ");
INSERT INTO nhx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Iwá̱n Jesús kijtoj: —Xa̱ka̱n xikijli̱tij Juan inochi yej ankitakej iwá̱n yej ankikakikej: pachamej tachaja, ko̱xomej nejnémija, yej pala̱ntia̱yaj inakayomej iga kipiayaj lepra, achitiákeja, yej ayá̱ꞌ takakiáj, iná̱n takákija, yej miktoyaj, ojpa‑isákeja. Iwá̱n yej ayá̱ꞌ motapialiáj, mopowiliaya ye̱ꞌnoti̱ciaj ken iga Dios tasalva̱rowa. ");
INSERT INTO nhx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Pa̱ktos yej ayá̱ꞌ kikajte̱wa iga moconfia̱rowa ipan nej. ");
INSERT INTO nhx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kua̱ꞌ yájkija itati̱tanimej Juan, Jesús pe̱ꞌ tata̱tapo̱wij de Juan; kijtoj: —¿Té̱ ankitato̱yaj ipan desierto? ¿Ix se̱ ojtaꞌ yej ko̱o̱li̱na ejekaꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Iwá̱n siga ayá̱ꞌ, ¿té̱taj ankitato̱yaj? ¿Ix se̱ ta̱gaꞌ yej ye̱ꞌtaajakijtoꞌ? Amejeme̱n ankimatij iga yej moye̱ꞌtaajakiáj iwá̱n nemij ken kinekij, cha̱ntitokej cha̱n re̱yejmej. ");
INSERT INTO nhx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Iwá̱n, ¿té̱ nokta ankitato̱yaj? ¿Ix se̱ profeta? Kena, yéj ma̱jya sej que se̱ profeta. ");
INSERT INTO nhx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","De Juan tajtoj ka̱n ijkí̱n ijkuilijtoꞌ: Nikti̱tani notati̱tan iga mo‑i̱xtaj matayaka̱na, iga ken kua̱ꞌ mamitzojtápoya. ");
INSERT INTO nhx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nimitznojma‑ijliáj iga ateyi nisé̱ profeta yej má̱j tayaka̱ntoꞌ que Juan yej tabautiza̱rowa, eꞌ yej momachi̱liá iga até̱ iteki de inochi yej mote̱makaj iga Dios marreina̱ro ipan yejeme̱n, inó̱n yej má̱j tayaka̱ntoꞌ que Juan. ");
INSERT INTO nhx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nochi yej kikakikej itájto̱l Juan este yej kicobra̱rowa̱yaj impuestos iga Roma, no̱ mobautiza̱rojkej iwá̱n ijkó̱n kichijkej ken Dios tatekimaka. ");
INSERT INTO nhx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Eꞌ fariseojmej iwá̱n yej tamachtiáj ipan la ley, ayá̱ꞌ mobautiza̱rojkej iná̱ꞌ Juan, iwá̱n ayá̱ꞌ kinekikej yej Dios kinekiá makichi̱wa iga yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Iwá̱n toTe̱ko kijtoj: —Amejeme̱n yej ina̱mpa amonokej anne̱sij ken tikita ");
INSERT INTO nhx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ko̱kone̱ꞌ yej ma̱wiltiáj ipan tajkoa̱ltepe̱ꞌ iwá̱n kitzajtziliáj iyikni̱wa̱n: “Nejeme̱n nimitztapi̱tzilijkej iga a̱ka iwá̱n ayá̱ꞌ anmijto̱tijkej; nejeme̱n nimitzikno̱takui̱kilijkej iwá̱n ayá̱ꞌ ancho̱kakej.” ");
INSERT INTO nhx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ijkó̱n ini̱mej gente; wa̱laj Juan yej tabautiza̱rowa yej akikua̱ya pa̱n niga konia̱ya vino iwá̱n amejeme̱n ankijtowaj iga kipiaya ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Iwá̱n niwa̱laj nej yej iPiltzi̱n Ta̱gaꞌ yej nitakua iwá̱n nikoniá vino, iwá̱n ankijtowaj iga nipoxtakua iwá̱n nita̱wa̱na, nimotókakiꞌ iwá̱n yej ayá̱ꞌ ye̱ꞌnemij iwá̱n ino̱mej yej kicobra̱rowaj impuestos iga Roma. ");
INSERT INTO nhx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kua̱ꞌ tikita ken iga ye̱ꞌnemij yej momelaꞌconfia̱rowaj ipan Dios, ne̱si iga Dios nochi kimati te̱ kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Se̱ fariseo kijlij Jesús iga matakua̱ti icha̱n, iwá̱n kalaꞌ kalijtiꞌ. Iwá̱n kua̱ꞌ ki̱xná̱ntoꞌya mesa, ");
INSERT INTO nhx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","asito se̱ siwa̱ꞌ yej ayá̱ꞌ ye̱ꞌnemi. Inó̱n siwa̱ꞌ de ompa, iwá̱n kimatiꞌ iga Jesús yajki takua̱to cha̱n inó̱n fariseo. Kiwi̱gaꞌ se̱ ibote̱yajtzi̱n yej chijtoꞌ de teꞌti yej ito̱ka̱ꞌ alabastro. Ípan kiwi̱gaꞌ aceite yej pox ajwiya̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Iwá̱n itepotztajpa Jesús, cho̱gaꞌ iyikxite̱noj, iwá̱n inó̱n siwa̱ꞌ, iga iyi̱xa̱ꞌ kikxipa̱tzoj. Iwá̱n kiwa̱ki̱ltij iga itzónkal, iwá̱n kikxipipitzoj iwá̱n kitajta̱lilij aceite yej pox ajwiya̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kua̱ꞌ fariseo yej nemi kitamaka Jesús, kitaꞌ yej nemi kichi̱wa inó̱n siwa̱ꞌ, kijtoj ipan iya̱lmaj: “Siga iní̱n ta̱gaꞌ katka melaꞌprofe̱taj, kimatiá katiábapa iní̱n siwa̱ꞌ yej nemi kichijchimi; ayá̱ꞌ ye̱ꞌnemi.” ");
INSERT INTO nhx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iwá̱n Jesús kijlij fariseo: —Simón, nimitzijli̱jneki achi tejté̱. Fariseo kijtoj: —Tamachtia̱ni, xine‑ijli. ");
INSERT INTO nhx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús kijtoj: —Onoya o̱me ta̱gaꞌ yej kidebe̱rowa̱yaj yej tata̱ke̱wa tomi̱n. Se̱ debe̱rowa̱ya ke̱ꞌ se̱ kita̱niá quinientos días iwá̱n seꞌ ke̱ꞌ kita̱niá cincuenta días. ");
INSERT INTO nhx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iwá̱n nisé̱ de yejemej awel kikuepaꞌ inó̱n tomi̱n, iwá̱n inó̱n yej tata̱ke̱wa tomi̱n, kijlij yej debe̱rowaj iga ayꞌya makikuepaka̱n inó̱n tomi̱n. Iná̱n xine‑ijli, ¿katiapa de yejemej má̱j kicho̱kili̱j? ");
INSERT INTO nhx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón kijtoj: —Anka yej má̱j komati tomi̱n ke̱lka̱wilij iga kidebe̱rowa̱ya. Jesús kijtoj: —Ómpaya ken tikijtoj Simón. ");
INSERT INTO nhx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iwá̱n Jesús kitachi̱lij siwa̱ꞌ, iwá̱n kijlij Simón: —Taꞌ xikita iní̱n siwa̱ꞌ. Nikalaꞌ mocha̱n iwá̱n ayá̱ꞌ tine‑ikxipa̱gaꞌ. Eꞌ iní̱n siwa̱ꞌ ne‑ikxipa̱gaꞌ iga iyi̱xa̱ꞌ iwá̱n ne‑ijikxiwa̱ki̱ltij iga itzónkal. ");
INSERT INTO nhx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tej ayá̱ꞌ tine̱pipitzoj; eꞌ iní̱n siwa̱ꞌ, desde que nikalaꞌ, ayá̱ꞌ nemi kikajte̱wa iga kipipitzowa nokxi. ");
INSERT INTO nhx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ayá̱ꞌ tine̱ta̱lilij aceite ipan notzontekon; eꞌ yéj ne̱ta̱lilij aceite yej ajwiya̱ꞌ ipan nokxi. ");
INSERT INTO nhx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Inó̱n iga nimitzijliá, ne̱poxcho̱kilij iga nike̱lka̱wílija yej poxsan aye̱kti kichij. Eꞌ yej nike̱lka̱wiliá alí̱n yej kichi̱wa yej aye̱kti, inó̱n ayá̱ꞌ poxsan ne̱cho̱kili̱j. ");
INSERT INTO nhx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iwá̱n Jesús kijlij inó̱n siwa̱ꞌ: —Inochi yej tikchij yej aye̱kti nimitze̱lka̱wílija. ");
INSERT INTO nhx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iwá̱n yej iwa̱mej ompa takuajtoyaj, motajtankej: —¿A̱ꞌyéj i̱n yej wel no̱ ke̱lka̱wiliá yej se̱ kichi̱wa yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús kijlij inó̱n siwa̱ꞌ: —Iga timoconfia̱roj ipan Dios, mitzma̱náwija. Xiyo̱lpa̱ktiaya. ");
INSERT INTO nhx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Iwá̱n Jesús yajki ipan nochi wejweyi a̱ltepe̱mej iwá̱n ipan a̱ltepe̱tzitzi̱n iga kipojtinemiá ye̱ꞌnoti̱ciaj ken iga Dios reina̱rowa. Nemiá iwá̱n doce idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nemiáj no̱ sekin siwa̱tkej yej Jesús kachitialtij yej kipiayaj ma̱lespí̱ritoj iwá̱n yej we̱titoyaj. Se̱ de yejeme̱n María, yej ito̱ka̱ꞌ no̱ Magdalena yej iyakapan ki̱saꞌ siete ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","No̱ Juana yej isiwa̱ꞌ Chuza, Chuza kipale̱wia̱ya Herodes ka̱n manda̱rowa. Iwá̱n seꞌ ito̱ka̱ꞌ Susana iwá̱n sékinoꞌ má̱j yej kipale̱wia̱yaj Jesús iga kimakakej yej itatkímejpa. ");
INSERT INTO nhx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Miaꞌ ki̱skej ipan i‑a̱ltepe̱mej iga kitatoj Jesús. Iwá̱n poxsan monechko̱lo̱ꞌ. Iwá̱n Jesús kipowaꞌ iní̱n iga mami̱xkui̱tilo: ");
INSERT INTO nhx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Se̱ ta̱gaꞌ yajki to̱kato, kipa̱pata̱náltijpa íyo̱l trigo. Onoꞌ yej wetzito ipan ojti iwá̱n kita̱taksayaj yej ompa panowa̱yaj. Wa̱lkej to̱to̱mej iwá̱n kikuajkej. ");
INSERT INTO nhx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Onoꞌ yej wetzito tetza̱la̱n ka̱n onoꞌ ajalí̱n ta̱jli; kua̱ꞌ íxwaꞌya, ta̱lwa̱guiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Onoꞌ yej wetzito ipan witzyoj. Kua̱ꞌ witzyoj sen‑ixwakej iwá̱n tato̱ꞌ, witzyoj ta‑ijiyo̱miktij. ");
INSERT INTO nhx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Eꞌ onoꞌ yej wetzito ipan yé̱ꞌta̱l. Kua̱ꞌ weyakej, pox mochij; iwá̱n ipan sejsé̱ imia̱wayo kita̱lilij este cien íyo̱l. Kua̱ꞌ tamiꞌ kijtoj inó̱n, Jesús recio tajtoj: —Yej annakasyojkej, xine̱ye̱ꞌkakika̱n. ");
INSERT INTO nhx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Idisci̱polojmej Jesús kitajtankej: —¿Té̱ kijto̱jneki in iní̱n ka̱n mi̱xkui̱tilo? ");
INSERT INTO nhx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kijtoj Jesús: —Amejeme̱n Dios mitzmati̱ltiáj ken iga yéj reina̱rowa, inó̱n yej ayagaj kimati. Eꞌ sekin nikpowiliapa ka̱n mami̱xkui̱ti̱ka̱n, ijkó̱n malej iga tachaskej, ken kua̱ꞌ ayá̱ꞌ tacháj, iwá̱n malej iga matakakika̱n ayá̱ꞌ kimatiskej te̱ kijto̱jneki. ");
INSERT INTO nhx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Ijkí̱n kijto̱jneki inó̱n ka̱n mi̱xkui̱tilo: Íyo̱l trigo kijto̱jneki itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Iwá̱n yej wetziꞌ ipan ojti, inó̱n kijto̱jneki yej kikakíkeja itájto̱l Dios iwá̱n wi̱ꞌ Tzitzimiꞌ iga ke̱lka̱waltiáj inó̱n yej kikakikej iga amo makicre̱do̱ka̱n iwá̱n amo mamoma̱nawi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yej wetziꞌ ipan teyoj, inó̱n kijto̱jneki yej este yojyo̱lpa̱kij kua̱ꞌ kikakij itájto̱l Dios; eꞌ ayéj iga kimelaꞌcre̱dowaj, ken tikita tato̱ꞌ yej ayá̱ꞌ nelwayoj. Ino̱mej ayá̱ꞌ nochípaya kicre̱dojtoskej, iga kua̱ꞌ kitantia̱rowaj, kikajte̱waj iyojwi Dios. ");
INSERT INTO nhx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Inó̱n íyo̱l trigo yej wetziꞌ ipan witzyoj, kijto̱jneki yej kikakij itájto̱l Dios, eꞌ mopojpolowaj iga kiyo̱ltila̱naj yej kejla̱ntokej, kipoxpiasnekij tomi̱n iwá̱n kichi̱waj kensan iya̱lmaj kineki, akichi̱waj yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eꞌ yej wetziꞌ ipan ye̱ꞌta̱jli, inó̱n kijto̱jneki yej kicre̱dowaj itájto̱l Dios iga inochi iya̱lmaj, iwá̱n ayí̱ꞌ mosemakaj ipan iyojwi Dios iwá̱n kichi̱waj yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Ayagaj kixo̱taltiá icándi̱l iwá̱n makiko̱ntepacho, niga kita̱liá tapechtampa. Ma̱jwaꞌ kita̱liá ajko iga mata̱wi, iga matachaka̱n yej kalakij. ");
INSERT INTO nhx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ateyi nité̱ yej i̱ya̱ntoꞌ yej amo mamone̱xti. Ateyi yej ichtákasan yej ke̱man amo mamomelaꞌmati. ");
INSERT INTO nhx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Taꞌ xikye̱ꞌkakika̱n; yej kipiá, yawij má̱j kimakatij, eꞌ yej ayá̱ꞌ kipiá este yej kijtowa iga kipiá yawij kikui̱li̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iyokichikni̱wa̱n Jesús iwá̱n iye̱ꞌ yajkij kitatoj Jesús, eꞌ awel asikej ite̱noj iga poxsan kipo̱lojtoyaj. ");
INSERT INTO nhx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iwá̱n kijlijkej Jesús: —Moye̱ꞌ iwá̱n mookichikni̱wa̱n onokej fuera iwá̱n mitzitasnekij. ");
INSERT INTO nhx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús kijtoj: —Yej kikakij itájto̱l Dios iwá̱n kichi̱waj ken kijtowa, inó̱mejwaꞌ in noye̱ꞌ iwá̱n nookichikni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Se̱ día Jesús tejkaj ipan weyi á̱ka̱l iwá̱n idisci̱polojmej, iwá̱n Jesús kijtoj: —Mati‑a̱pano̱ka̱n. Iwá̱n yajkij. ");
INSERT INTO nhx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kua̱ꞌ nemi a̱panowa̱yaj, Jesús mokochkui̱lij. Iwá̱n ipan laguna kitzi̱ntijkej se̱ ejekaꞌ yej pox tajpalej, iwá̱n á̱ka̱l pe̱waꞌ iga a̱te̱miꞌ iwá̱n este ken a̱wetziaja. ");
INSERT INTO nhx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iwá̱n kixitijkej Jesús, kijlijkej: —¡Tamachtia̱ni! ¡Tamachtia̱ni! ¡Némiya ti‑a̱wetzij! Iwá̱n moketzaꞌ Jesús, kajajwaꞌ ejekaꞌ iwá̱n a̱ꞌti, iwá̱n pachiwikej, iwá̱n santaka̱mpolijtika̱wiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Iwá̱n Jesús kijlij idisci̱polojmej: —¿Te iga ayá̱ꞌ anmoconfia̱rojkej ipan nej? Eꞌ yejeme̱n majmatika̱wikej iwá̱n san tajtachi̱xtikajkej, iwá̱n mosepantajtankej: —¿A̱ꞌyéj a̱n in iní̱n ta̱gaꞌ yej este ejekaꞌ iwá̱n a̱ꞌti wel kitekimaka iwá̱n kitajto̱lkakij? ");
INSERT INTO nhx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iwá̱n kua̱ꞌ a̱panójkeja, asikej Gadara yej onoꞌ iyi̱ka̱n laguna, iyi̱xtaj Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iwá̱n kua̱ꞌ témoja Jesús, ki̱xna̱mikito se̱ ta̱gaꞌ de ompa yej íkyaya kipiaya ma̱lespí̱ritoj, iwá̱n nochípaya nemiá ipetzka̱n iwá̱n ayꞌya katka cha̱nej, kochá posa̱ntoj. ");
INSERT INTO nhx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kua̱ꞌ inó̱n ta̱gaꞌ kitaꞌ Jesús, motankua̱ketzaꞌ iyi̱xtaj, iwá̱n tzajtziꞌ, kijtoj: —¿Té̱ tikneki nowa̱n, tej Jesús yej iPiltzi̱n Dios yej onoꞌ pox ajko? Nimitztajtaniliá iga amo xine‑ikno̱chi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ijkó̱n kijtoj iga Jesús kitekimakatoya ma̱lespí̱ritoj iga maki̱sa ipan inó̱n ta̱gaꞌ. Má̱j achto ma̱lespí̱ritoj miaꞌ ve̱j kiki̱tzkia̱ya, malej iga kijikxi‑ilpia̱yaj iwá̱n kimajma‑ilpia̱yaj iga amo macholo; eꞌ yéj sankiko̱koto̱naya inó̱n cadena. Iwá̱n ma̱lespí̱ritoj kiwi̱gaya ipan desierto ka̱n ayagaj cha̱ntitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús kitajtan: —¿Té̱ moto̱ka̱ꞌ? Iwá̱n kijlij: —Noto̱ka̱ꞌ Miaꞌ. Kijtoj ijkó̱n iga miaꞌ ma̱lespi̱ritojmej onoyaj ipan inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kitajtanilijkej Jesús iga amo makiti̱tani̱ka̱n xapoko yej ayá̱ꞌ kipiá ka̱n tantoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ipan tepe̱ꞌ takuajtinemiáj miaꞌ koyame̱mej, iwá̱n ma̱lespi̱ritojmej kitekiꞌtajtanilijkej Jesús iga makalakika̱n ipan koyame̱mej; iwá̱n Jesús ompa kiti̱tan ino̱mej ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kua̱ꞌ kí̱skeja ipan inó̱n ta̱gaꞌ, kalákkeja ipan koyame̱mej, iwá̱n inochi momajma̱petzko̱toj ipan barranko, wetzitoj ipan laguna iwá̱n ompa a̱mikikej. ");
INSERT INTO nhx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kua̱ꞌ inó̱n kitakej yej kicuida̱rojtinemiáj koyame̱mej, mo̱ka̱cholojkej iwá̱n yajkij kipowatoj ipan a̱ltepe̱ꞌ iwá̱n ipan a̱ltepe̱tzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","La gente yajkij kitatoj yej mochij. Iwá̱n yajkij ka̱n onoꞌ Jesús; kasitoj inó̱n ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj este e̱watoꞌ ite̱noj Jesús; taajakíjtoꞌya iwá̱n ye̱ꞌtajlá̱ntoꞌya. Iwá̱n majmawikej. ");
INSERT INTO nhx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Iwá̱n yej kitakej, kipojkej inewi san kén kitakej iga ye̱ktiáꞌ inó̱n ta̱gaꞌ yej kipiaya ma̱lespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nochi gente de Gadara iwá̱n yej najna̱ꞌsan icha̱mej kitekiꞌijlijkej Jesús iga makí̱saya ompa iga poxsan majmawiáj. Iwá̱n Jesús kalaꞌ ipan á̱ka̱l iwá̱n ya̱yay. ");
INSERT INTO nhx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iwá̱n inó̱n ta̱gaꞌ yej ípan ki̱saꞌ ma̱lespi̱ritojmej, kitekiꞌtajtanilij iga mayáwiya íwa̱n. Eꞌ Jesús kitekimáꞌ iga maka̱wi, kijlij: ");
INSERT INTO nhx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Xaj mocha̱n, iwá̱n xikpowa nochi yej Dios mitzchi̱wilij. Inó̱n ta̱gaꞌ yajki, iwá̱n kipowaꞌ no̱ya̱n ipan inó̱n a̱ltepe̱ꞌ yej Jesús kichij ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kua̱ꞌ Jesús asito sej Galilea, nochi kichi̱xtoya iwá̱n pa̱kikej iga ki‑o̱mema̱wijkej. ");
INSERT INTO nhx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Iwá̱n asiꞌ se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Jairo yej manda̱rowa tio̱pan. Inó̱n ta̱gaꞌ motankua̱ketzato iyikxite̱noj Jesús, iwá̱n iga inewi iya̱lmaj kitajtanilij iga mayawi icha̱n ");
INSERT INTO nhx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","iga kipiaya ise̱ltaochi̱n ken de doce años yej mikisnekiaya. Ka̱n nemi ya̱ya Jesús, este kipi̱pitzkowa̱yaj iga miaꞌ yej kitokaj. ");
INSERT INTO nhx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Iwá̱n nemi ya̱ya no̱ ompa se̱ siwa̱ꞌ yej we̱titoya, doce años ki̱stoya ken imé̱s yej awel pachiwiá. Kitámija inewi itomi̱n iga yajka iwá̱n me̱dicojmej iwá̱n ayagaj wel kachitialtij. ");
INSERT INTO nhx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Inó̱n siwa̱ꞌ kitechoj Jesús itepotztájbapa iwá̱n kichijchimilij ite̱mpan itzótzol, iwá̱n íkua̱ꞌ pachiwiꞌ iga ki̱stoya ken imé̱s. ");
INSERT INTO nhx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iwá̱n Jesús kijtoj: —¿A̱ꞌyéj ne̱chijchin? Nochi kijtojkej iga ayéj yejeme̱n. Pedro iwá̱n yej iwá̱n nemiáj, kijtojkej: —Tamachtia̱ni, nemi mitzpi̱pitzkowaj iwá̱n mitzya̱yagatope̱waj nijnijiga, iwá̱n tikijtówa‑oꞌ: “¿A̱ꞌyéj ne̱chijchin?” ");
INSERT INTO nhx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Eꞌ Jesús kijtoj sej: —Agaj ne̱chijchin, nikmachi̱lij iga ipan nej ki̱saꞌ poder. ");
INSERT INTO nhx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kua̱ꞌ siwa̱ꞌ kitaꞌ iga awel mi̱ya̱na, kuekuechkatiajki, motankua̱ketzato iyikxite̱noj Jesús. Kinojma‑ijtoj iyi̱xtaj la gente te iga kichijchin iwá̱n kén iga ye̱ktiáꞌ íkua̱ꞌsan. ");
INSERT INTO nhx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús kijlij: —Nopíj, iga timoconfia̱roj ipan nej, ti‑achitiaꞌya. Xaja tamelá̱. ");
INSERT INTO nhx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mie̱j ta̱tapojtóyaoꞌ Jesús, a̱ꞌpa asiꞌ yej wa̱laj icha̱n Jairo, inó̱n yej manda̱rowa tio̱pan, kijlij: —Mosiwa̱piltzi̱n miꞌya, ayꞌya má̱j xikuejkuesojto toTamachtia̱ni. ");
INSERT INTO nhx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eꞌ Jesús kikáꞌ iwá̱n kijtoj: —Amo ximajmawi, ximoconfia̱ro ipan nej iwá̱n mopiltzi̱n ye̱ktiás. ");
INSERT INTO nhx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kua̱ꞌ asiꞌ Jesús cha̱n Jairo, ayá̱ꞌ kineꞌ a̱ꞌsan ne̱siꞌ makalaki, petz Pedro, Santiago, Juan, itaj takotzi̱n iwá̱n iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nochi mokno̱matitoyaj iwá̱n cho̱katoyaj iga inó̱n takotzi̱n. Eꞌ Jesús kijtoj: —Amo xicho̱katoka̱n, takotzi̱n ayá̱ꞌ miktoꞌ, yejwaꞌ kochtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Iwá̱n Jesús kiwejwetzkilijkej, iga kimatiáj iga míktoꞌya in inó̱n takotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Eꞌ Jesús kiki̱tzkilij ima̱ꞌ iwá̱n recio kino̱tzaꞌ: —¡Takotzi̱n, ximoketza! ");
INSERT INTO nhx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Iwá̱n sej ojpa‑isaꞌ iwá̱n nimaní̱n moketzaꞌ. Iwá̱n Jesús tatekimáꞌ iga mamotamakátiya in takotzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Itaj iwá̱n iye̱ꞌ san tajtachi̱xtikajkej; eꞌ Jesús tatekimáꞌ iga amo agaj makimati yej mochij. ");
INSERT INTO nhx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús kinechkoj doce idisci̱polojmej iwá̱n kimáꞌ poder iga wel makiki̱xti̱ka̱n ma̱lespi̱ritojmej, iwá̱n no̱ iga makachitialti̱ka̱n yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kiti̱tankej iga makijto̱ka̱n kén iga reina̱rowa Dios, iwá̱n iga mataachitialti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Iwá̱n kijlijkej: —Amo xikui̱gaka̱n nité̱ ipan ojti. Niga bastón, niga mórra̱l, niga tákual, niga tomi̱n, iwá̱n amo xikui̱gaka̱n o̱me amokua̱ch. ");
INSERT INTO nhx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ka̱n amasitij agaj icha̱n, ómpasan xika̱wika̱n este que matami amotekipáno̱l iwá̱n anki̱saskej ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Iwá̱n ka̱n ayá̱ꞌ mitzo̱mema̱wi̱skej, xiki̱saka̱n ipan inó̱n a̱ltepe̱ꞌ, xiktzejtzelo̱ka̱n amokxita̱lpíno̱l iga makimatika̱n iga ayá̱ꞌ kichijkej yej ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iwá̱n ki̱skej, yajkij ipan inewi a̱ltepe̱tzitzi̱n, kipojtinenkej ye̱ꞌnoti̱ciaj kén iga Dios tasalva̱rowa iwá̱n kachitialtijtinenkej yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rey Herodes kikáꞌ yej kichijtinemi Jesús; iwá̱n ayꞌya kimatiá te̱ kichi̱waya iga sekin kijtowa̱yaj: —Anka ojpa‑isaꞌ sej Juan ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sekin kijtowa̱yaj: —O mi̱xne̱xti̱ko el profeta Elías. Iwá̱n sekin kijtowa̱yaj: —Anka ojpa‑isaꞌ sej agaj ikyapaprofe̱taj. ");
INSERT INTO nhx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Eꞌ Herodes kijtoj: —Esi nej nitatekimáꞌ iga makikechtekika̱n Juan, ¿a̱ꞌyejtaj a̱n in iní̱n yej nikaki kipowaj kuajkuantas iga yéj? Inó̱n iga Herodes kitasnekiá Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kua̱ꞌ mokuepkej iyapo̱stolejmej Jesús, kipowilijkej inewi yej kichijkej. Iwá̱n Jesús kinechkoj idisci̱polojmej iwá̱n kiwi̱gaꞌ ka̱n ayagaj onoꞌ, na̱ꞌsan se̱ a̱ltepe̱ꞌ ito̱ka̱ꞌ Betsaida. ");
INSERT INTO nhx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Eꞌ kua̱ꞌ la gente kimatiꞌ, kitokakej no̱, iwá̱n Jesús ki‑o̱mema̱wij in ino̱mej, iwá̱n kita̱tapo̱wijkej kén iga reina̱rowa Dios iwá̱n kachitialtij yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kua̱ꞌ tió̱taꞌya, kitecho̱toj Jesús doce iyapo̱stolejmej, iwá̱n kijlijkej: —Xikijli la gente mayá̱ka̱nya mamose̱wi̱tij, iwá̱n makite̱mo̱tij tákual ipan a̱ltepe̱ꞌ iwá̱n ipan a̱ltepe̱tzitzi̱n yej najná̱ꞌ onokej, iga nigaj ateyi nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesús kijtoj: —Amejeme̱n xiktamakaka̱n. Yejeme̱n kijtojkej: —Eꞌ, nikpiajsan se̱ mano pa̱n iwá̱n o̱me to̱poj, ¿ix nikowatij tákual iga nochi ini̱mej? ");
INSERT INTO nhx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Onoyaj ken cinco mil tajta̱gaꞌ. Eꞌ Jesús kijlij idisci̱polojmej: —Xikijli̱ka̱n iga mamota̱li̱ka̱n de cincuenta en cincuenta. ");
INSERT INTO nhx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ijkó̱n kichijkej, iwá̱n nochi motajta̱lkej. ");
INSERT INTO nhx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Iwá̱n Jesús kikuiꞌ se̱ mano pa̱n iwá̱n o̱me to̱poj iwá̱n ajkotacháꞌ iwá̱n kimáꞌ gracias Dios iga tákual, iwá̱n kipo̱posteꞌ. Iwá̱n kimajmakakej disci̱polojmej iga makimajmakaka̱n la gente. ");
INSERT INTO nhx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Takuajkej inochimej este ijixwikej, iwá̱n disci̱polojmej kite̱míjkejoꞌ doce chikiwiꞌ de tákual yej ayꞌ kikuajkej. ");
INSERT INTO nhx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se̱ día Jesús iyoka ora̱dojtoya. Ompa no̱ onoyaj idisci̱polojmej, iwá̱n Jesús tatajtan: —In sekin, ¿té̱ kijtowaj de nej? ");
INSERT INTO nhx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yejeme̱n kijtojkej: —Sekin kijtowaj tej tiJua̱n yej tabautiza̱rowa̱ya; sekin kijtowaj iga tej Elías; iwá̱n sekin kijtowaj iga tej anka tiikyapaprofe̱taj yej ojpa‑isaꞌ sej. ");
INSERT INTO nhx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Iwá̱n kitajtankej sej: —In amejeme̱n, ¿té̱ ankijtowaj de nej? Iwá̱n Pedro kijlij: —Tej tiCri̱stoj yej itati̱tan Dios. ");
INSERT INTO nhx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Eꞌ Jesús kitekimáꞌ idisci̱polojmej iga amo makijli̱ka̱n agaj iga yéj Cristo. ");
INSERT INTO nhx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Iwá̱n kijlijkej: —Nej yej iPiltzi̱n Ta̱gaꞌ, yawij ne‑ikno̱chi̱watij poxsan iwá̱n yawij ne‑ijiyatij we̱wetkej yej manda̱rowaj iwá̱n ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés. Yawij ne̱mikti̱tij iwá̱n ipan e̱yi día nia ni‑ojpa‑isati sej. ");
INSERT INTO nhx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Iwá̱n Jesús kijlij nochi gente: —Siga agaj kineki mane̱toka, ayꞌya makichi̱wa yej yéj kineki, iwá̱n manejnemi ipan noojwi nochipa malej iga makikno̱chi̱waka̱n poxsan este makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Yej ayá̱ꞌ kinekis mamiki, yawi mikiti; eꞌ yej mikis iga nej ne̱toka, nochipa onos nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Itejas in ta̱gaꞌ siga makipiá inochi yej onoꞌ ipan iní̱n ta̱jli, siga ima̱tika mamopolo o mamiki? ");
INSERT INTO nhx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Siga agaj pi̱na̱wa iga ne̱toka iwá̱n iga kipowa notájto̱l, ijkó̱n no̱ nej yej iPiltzi̱n Ta̱gaꞌ, nipi̱na̱was iga yéj kua̱ꞌ niwi̱ꞌ nigoberna̱ro̱ki iwá̱n iweyipode̱r noTaj, iwá̱n a̱ngelejmej yej xojxo̱tatiwi̱tzej. ");
INSERT INTO nhx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nimitznojma‑ijliáj iga sekin yej nij onokej ayá̱ꞌ mikiskej este que makitaka̱n kén iga reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kipiáꞌ ken ocho días iga kipojtoya inó̱n, Jesús tejkaj ipan se̱ tepe̱ꞌ ora̱do̱to. Kiwi̱gaꞌ Pedro, Juan iwá̱n Jacobo. ");
INSERT INTO nhx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kua̱ꞌ ora̱dojtoya, moxa̱ygapataꞌ iwá̱n itzótzol mokuepaꞌ este ichkatiꞌ iwá̱n melaꞌta̱wij. ");
INSERT INTO nhx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Iwá̱n ne̱sikoj o̱me̱n tajta̱gaꞌ iga ta̱tapowakoj iwá̱n Jesús, ikyapaprofe̱tajmej Moisés iwá̱n Elías. ");
INSERT INTO nhx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Íkua̱ꞌ kiyawalojtoyaj weyi ta̱wi̱lka̱n yej ipode̱rpa Dios. Iwá̱n kipojtoyaj kén iga yawi kikno̱chi̱watij Jesús iwá̱n kén iga yawi mikiti en Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Malej iga Pedro iwá̱n yej íwa̱n nemiáj pox kochisnekiáj, eꞌ yejeme̱n akochkej iwá̱n kitakej ita̱wi̱lyo Jesús iwá̱n ino̱mej o̱me̱n tajta̱gaꞌ yej onoyaj iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kua̱ꞌ némiya ya̱yaj ino̱mej tajta̱gaꞌ iga kikajté̱waja Jesús, Pedro kijlij Jesús: —Tamachtia̱ni, ¡pox ye̱kti iga nonokej nigaj! Manikchi̱waka̱n e̱yi ra̱nchojtzitzi̱n, se̱ iga tej, se̱ iga Moisés iwá̱n se̱ iga Elías. Eꞌ Pedro akimatiá te̱ kijtowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kua̱ꞌ ini̱noꞌ kijtojtoya, wa̱laj se̱ mixti kitzakuakoj. Iwá̱n majmawikej disci̱polojmej kua̱ꞌ mixtzakuikej. ");
INSERT INTO nhx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iwá̱n wa̱laj se̱ tájto̱l ipan mixti, kijtoj: —Ini̱nwaꞌ nokta in noPiltzi̱n yej nikpoxcho̱kiliá; yéj xikakika̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kua̱ꞌ tamiꞌ mokaguiꞌ tájto̱l ipan mixti, Jesús isé̱ltiya onoya. Eꞌ yejeme̱n ayá̱ꞌ te̱ kijtojkej iwá̱n ayagaj kipowilijkej yej kitakej. ");
INSERT INTO nhx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ipan seꞌ día kua̱ꞌ temo̱tiwi̱tziayaj ipan tepe̱ꞌ, komati gente mi̱xna̱nkej iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Iwá̱n se̱ ta̱gaꞌ de yejeme̱n tajtoj recio: —Tamachtia̱ni, nimitztajtaniliá iga achi xikita iní̱n nose̱lpiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Se̱ ma̱lespí̱ritoj kiyokaki̱tzkiá iwá̱n kitzajtzi̱ltiá iwá̱n kikuejkuekuechkaltiá iwá̱n chijchalposo̱ntiá. Kipoxikno̱chi̱wa iwá̱n ayá̱ꞌ kikajte̱wasneki. ");
INSERT INTO nhx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nikijlíjkaja modisci̱polojmej iga makiki̱xtili̱ka̱n iní̱n espíritu, eꞌ ayá̱ꞌ welitiakej. ");
INSERT INTO nhx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús kijtoj: —¡Mataj amejeme̱n ayá̱ꞌ anmomelaꞌconfia̱rojtokej nopan iwá̱n ayá̱ꞌ anye̱ꞌnemij! ¿Este ké̱manoꞌ má̱j nia nonoti iwá̱n amejeme̱n, iwá̱n nia nimitzijyo̱wijtotij? Xikuajliga nijiga mopiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kua̱ꞌ chokotzi̱n kina̱ꞌtechojtia̱ya Jesús, ma̱lespí̱ritoj kitájkal este ipan ta̱jli iga kikuejkuekuechkaltij recio. Eꞌ Jesús kajajwaꞌ inó̱n ma̱lespí̱ritoj iwá̱n kachitialtij inó̱n chokotzi̱n. Iwá̱n kimáꞌ sej itaj. ");
INSERT INTO nhx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iwá̱n inewi gente san tajtachi̱xtikajkej iga kitakej iweyi poder Dios. Mie̱j inewi moyo̱lmajtijtoyaj iga yej Jesús kichij, kijlij idisci̱polojmej: ");
INSERT INTO nhx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Xikye̱ꞌkakika̱n iní̱n, iwá̱n amo xike̱lka̱waka̱n; nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱ka̱watij ipan ima̱ꞌ yej ne‑ijiyaj. ");
INSERT INTO nhx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Eꞌ yejeme̱n ayá̱ꞌ kentende̱rowa̱yaj yej kijlia̱yaj, iga ken kua̱ꞌ i̱xtzaktoyaj iga aya makentende̱ro̱ka̱n, iwá̱n majmawiáj iga kitajtaniáj Jesús iga té̱ kijto̱jneki ino̱mej tajto̱lmej. ");
INSERT INTO nhx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Iwá̱n idisci̱polojmej pe̱wakej iga mosejsepan‑ijliáj iga a̱ꞌyéj a̱n de yejeme̱n má̱j tayaka̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Eꞌ Jesús kimatiꞌ te̱ kejla̱ntoyaj, kikuiꞌ se̱ choochi̱n iwá̱n kiketzaꞌ ite̱noj, ");
INSERT INTO nhx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","iwá̱n kijlijkej: —Yej ki‑o̱mema̱wiá iní̱n choochi̱n iga ne̱toka, nej neo̱mema̱wiá; iwá̱n yej neo̱mema̱wiá nej, ki‑o̱mema̱wiá no̱ yej ne̱ti̱tan. Iga yej moali̱mpamati ken iní̱n choochi̱n, inó̱n yej má̱j importante. ");
INSERT INTO nhx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan kijlij Jesús: —Tamachtia̱ni, nikitakej se̱ ta̱gaꞌ yej kite̱ne̱wiá̱yapa moto̱ka̱ꞌ iga kiki̱xtia̱ya ma̱lespí̱ritoj iwá̱n niktekimakakej iga amo makichi̱wa, iga ayá̱ꞌ senemi towa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús kijtoj; —Amo xika̱walti̱ka̱n, iga yej ayá̱ꞌ te̱ma̱lita inó̱n te̱pale̱wiá. ");
INSERT INTO nhx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kua̱ꞌ asitiaya iga Jesús tejkáwisya sej ipan cielo, kisenta̱lij iya̱lmaj iga yawi Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jesús kiti̱tan sekin iga maya̱ka̱n ipan se̱ a̱ltepe̱ꞌ de Samaria iga kite̱mo̱toj ka̱n ka̱wiskej. ");
INSERT INTO nhx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Eꞌ samarita̱nojmej ayá̱ꞌ kinekikej iga ompa maka̱wi Jesús iga kimatikej iga nemi ya̱yaj Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kua̱ꞌ kitakej inó̱n, Santiago iwá̱n Juan yej idisci̱polójmejpa Jesús, kijlijkej: —NoTe̱ko, ¿ix tikneki maniktajtanili̱ka̱n Dios iga matemo tiꞌti iga makipolo̱ka̱n yejeme̱n, ken kichij el profeta Elías? ");
INSERT INTO nhx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Iwá̱n Jesús kitachi̱lij iwá̱n kajajwaꞌ in ino̱mej: —Amejeme̱n ayá̱ꞌ anki̱xmatij iyEspí̱ritoj Dios yej mitznentiáj. ");
INSERT INTO nhx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nej yej iPiltzi̱n Ta̱gaꞌ ayá̱ꞌ niwa̱laj nitapolo̱ko, niwa̱laj nitama̱nawi̱ko iga amo mapoliwilo. Iwá̱n yájkija ipan seꞌ a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kua̱ꞌ nemi ya̱yaj ipan ojti, se̱ ta̱gaꞌ kijlij Jesús: —NoTe̱ko, nej nikneki manimitztokatinemi ka̱nsan tia. ");
INSERT INTO nhx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús kijtoj: —Koyo̱mej kipiáj ixapoyomej ka̱n kochij, iwá̱n to̱to̱mej kipiáj ixekemej, eꞌ nej yej iPiltzi̱n Ta̱gaꞌ, anikpiá ka̱n achi manimokuajtetonti. ");
INSERT INTO nhx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús kijlij seꞌ: —Xine̱toka. Eꞌ yéj kijtoj: —NoTe̱ko, maniaoꞌ achto manikto̱kati notaj. ");
INSERT INTO nhx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús kijtoj: —Xika̱wili yej ken miktokej iga makito̱kaka̱n yej miktokej. Tej xaj, iwá̱n xikpowa kén iga reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Seꞌ kijlij: —NoTe̱ko, nikneki manimitztoka, eꞌ achto maniknawati̱ti yej onokej nocha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús kijtoj: —Yej nemi ara̱dowa iwá̱n ta̱tachi̱xtiá itepotztajpa, ayá̱ꞌ kajasi iga matekipano iga Dios. ");
INSERT INTO nhx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Iwá̱n toTe̱ko kitapejpen seꞌ setenta iwá̱n kiti̱tan ojo̱me̱n iga maya̱ka̱n ipan nochi a̱ltepe̱mej iwá̱n no̱ya̱n ka̱n yéj yawi pano̱ti. ");
INSERT INTO nhx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kijlijkej: —Mela̱ꞌwaꞌ iga onoꞌ miaꞌ yej wel moconfia̱rowaj ipan nej, eꞌ ayá̱ꞌ miaꞌ yej kipowaj ye̱ꞌnoti̱ciaj. Yej aya kikakij, inó̱mejwaꞌ ken se̱ weyi mi̱jli yej némiya tayoksi. Inó̱n iga xiktajtanili̱ka̱n yej iTe̱ko mi̱jli iga makiti̱tani tekipanowa̱nimej iga makitekítijya yej onoꞌ pan mi̱jli. ");
INSERT INTO nhx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Amejeme̱n xa̱ka̱n; nimitzti̱tanij ken tikita amborre̱gojmej itza̱la̱n koyo̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xikui̱gaka̱n amomórra̱l, niga ka̱n anke̱naj amotomi̱mej, niga seꞌ amogakmej; iwá̱n amo ximoke̱ketztia̱ka̱n iga xita̱tapojtoka̱n iwá̱n agaj yej íwa̱n anmasij ipan ojti. ");
INSERT INTO nhx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Kua̱ꞌ ankalakiskej ipan se̱ kajli, achto ijkí̱n xikijto̱ka̱n: “Xonoka̱n tamelá̱.” ");
INSERT INTO nhx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Siga ompa onoꞌ se̱ yej kineki maono tamelá̱, ipan yéj mochi̱was inó̱n yej ankijtowaj, eꞌ siga ayá̱ꞌ kineki maono tamelá̱, ayá̱ꞌ mochi̱was ken ankijtowaj. ");
INSERT INTO nhx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Xika̱wika̱n ipan ino̱nsan kajli, xikua̱ka̱n iwá̱n xikoni̱ka̱n yej mitzmakaj; pues yej tekipanowa kajasi iga makixta̱waka̱n. Amo xikalaktinemika̱n ipan se̱sé̱ kajli. ");
INSERT INTO nhx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","’Kua̱ꞌ amasiskej ipan se̱ a̱ltepe̱ꞌ iwá̱n mitzo̱mema̱wiáj, xikua̱ka̱n yej mitzmakaskej; ");
INSERT INTO nhx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","xikachitialti̱ka̱n yej we̱titokej yej ompa onokej, iwá̱n xikijli̱ka̱n: “Ayoꞌ wejkatis iga reina̱ro̱j Dios ipan amejeme̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Eꞌ siga amasij ipan se̱ a̱ltepe̱ꞌ iwá̱n ayá̱ꞌ mitzo̱mema̱wiáj, xa̱ka̱n ipan ca̱llejmej, iwá̱n xikijto̱ka̱n: ");
INSERT INTO nhx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Este ta̱lpo̱ꞌ yej onoꞌ ipan amoa̱ltepe̱ꞌ sa̱liwiꞌ ipan nokximej, niktzejtzelojkej iga mane̱si iga ayá̱ꞌ anne̱ye̱ꞌitakej. Eꞌ xikmatika̱n iga ayoꞌ wejkatis iga reina̱ro̱j Dios.” ");
INSERT INTO nhx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nimitzijliáj iga kua̱ꞌ Dios tajuzga̱ro̱j, yej cha̱ntitokej ipan inó̱n a̱ltepe̱ꞌ má̱j kicastiga̱ro̱skej que yej icha̱mej katka a̱ltepe̱ꞌ Sodoma. ");
INSERT INTO nhx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Lástima yej ancha̱ntitokej a̱ltepe̱ꞌ Corazín! ¡Lástima yej ancha̱ntitokej a̱ltepe̱ꞌ Betsaida! Siga ipan a̱ltepe̱ꞌ Tiro iwá̱n Sidón mochijka mila̱grojmej yej amejeme̱n ankitakej, desde ikya kikajtejkaj iga kichi̱waj yej aye̱kti, iwá̱n mone̱xtia̱yaj iga kajakia̱yaj itzotzolmej yej moakiá kua̱ꞌ mikilo, iga mokno̱matij iwá̱n mota̱líjkaja ipan nexti. ");
INSERT INTO nhx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Eꞌ kua̱ꞌ Dios tajuzga̱ro̱j, amejeme̱n má̱j yawij mitzcastiga̱ro̱tij que yej cha̱ntitokej a̱ltepe̱mej Tiro iwá̱n Sidón. ");
INSERT INTO nhx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iwá̱n amejeme̱n yej amocha̱n a̱ltepe̱ꞌ Capernaum, ¿ankijtowaj a̱n anya̱tij ipan cielo? ¡Yáwijwaꞌ mitzaki̱tij ka̱n onokej yej miktokej! ");
INSERT INTO nhx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesús kijlij sej idisci̱polojmej: —Yej amejeme̱n mitzkakij, ne̱kakij nej; iwá̱n yej ayá̱ꞌ mitztajto̱lkuij, nej ayá̱ꞌ ne̱tajto̱lkuij, iwá̱n yej ayá̱ꞌ ne̱tajto̱lkuij, ayá̱ꞌ kitajto̱lkuij yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Iwá̱n ino̱mej setenta yej yajkaj, yo̱lpa̱ktiwa̱lkej, kijtojkej: —AnnoTe̱ko, este tzitzimimej kichi̱waj ken niktekimakaj ipan moto̱ka̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús kijtoj: —Kena, nej nikitaꞌ iga Tzitzimiꞌ nemi wetzi ipan cielo ken se̱ teyo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nej nimitzmakakej poder iga wel xitaksaka̱n ipan kowa̱mej iwá̱n ipan ko̱lo̱mej, iwá̱n iga wel xikta̱nili̱ka̱n nochi amoenemi̱gojmej, iga amo mamitzchi̱wili̱ka̱n nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Eꞌ amo xiyo̱lpa̱kika̱n iga ma̱lespi̱ritojmej mitzcre̱dowaj, xiyo̱lpa̱kika̱n iga amoto̱ka̱mej ijkuilíjtoꞌya ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Íkua̱ꞌ Jesús yo̱lpa̱guiꞌ iga iyEspí̱ritoj Dios kiyo̱lchikaj, iwá̱n kijtoj: —NoTaj yej tikchij cielo iwá̱n ta̱jli, nimitzweyimati̱ltiá iga tikne̱xtilij yej ayá̱ꞌ moweyimatij inó̱n yej ayá̱ꞌ tikne̱xtilij yej tamatij, iga tej ijkó̱n tikneꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’NoTaj ne̱maꞌya inochi yej onoꞌ. Ayagaj ne̱melaꞌi̱xmati nej yej iPiltzi̱n Dios, isé̱ltisan te̱Taj Dios ne̱melaꞌi̱xmati. Iwá̱n ayagaj no̱ kimelaꞌi̱xmati te̱Taj; nosé̱ltisan nej yej iPiltzi̱n, iwá̱n ino̱mej yej nej nikneki iga maki̱xmatika̱n. ");
INSERT INTO nhx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iwá̱n kitachi̱lij idisci̱polojmej, kijlij: —Pa̱kiskej yej makitaka̱n yej ankitztokej; ");
INSERT INTO nhx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","iga nimitzijliáj iga miaꞌ profe̱tajmej iwá̱n re̱yejmej kitasnekiá̱j iní̱n yej ankitztokej, iwá̱n ayá̱ꞌ kitakej; kinekiáj makikakika̱n iní̱n yej amejeme̱n nemi ankikakij, iwá̱n ayá̱ꞌ kikakikej. ");
INSERT INTO nhx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Iwá̱n se̱ yej tamachtiá ipan iley Moisés, moketzaꞌ iga tajtoj iga san kinekiá makita te̱ kijto̱j Jesús iwá̱n kitajtan: —Tamachtia̱ni, ¿té̱ nikchi̱was iga wel manono nochipa iwá̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús kijtoj: —¿Té̱ ijkuilijtoꞌ ipan la ley? ¿Kén tikentende̱rowa? ");
INSERT INTO nhx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iwá̱n yej tamachtiá ipan la ley, kijtoj: —“Xikcho̱kili moTe̱ko Dios iga inewi moa̱lmaj, iwá̱n iga inochi moespí̱ritoj iwá̱n iga inewi motájpal iwá̱n yéj nochipa xikejla̱nto, iwá̱n xikcho̱kili mokni̱n kensan tej timocho̱kiliá.” ");
INSERT INTO nhx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús kijtoj: —Ómpaya ken tikijtoj. Siga inó̱n tikchi̱was, nochipa tonos iwá̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Eꞌ inó̱n yej tamachtiá ipan la ley moweyimatiá iyi̱xtaj yej ompa onoyaj, iwá̱n kitajtan Jesús: —¿A̱ꞌyejtaj in nokni̱n? ");
INSERT INTO nhx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesús kijtoj: —Se̱ ta̱gaꞌ ki̱saꞌ Jerusalén iga yawi Jericó. Iwá̱n ipan ojti kitachtekijkej, este itzótzol kikui̱lijkej, kimagakej, iwá̱n este kitapolo̱ltijkej iwá̱n ompa kikajtejkej. ");
INSERT INTO nhx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Eꞌ kémpasan ipan inó̱n ojti pano̱tia̱ya se̱ sacerdote; eꞌ san kitachi̱lij iwá̱n san kipatilij. ");
INSERT INTO nhx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Se̱ levita yej tekipanowa ipan weyitio̱pan no̱ ompa asiꞌ, kitachi̱lij iwá̱n no̱ san kipatilij. ");
INSERT INTO nhx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Eꞌ se̱ ta̱gaꞌ yej cha̱ntitoꞌ Samaria nemi ya̱ya ipan ino̱nsan ojti, kua̱ꞌ kitaꞌ, kikne̱lij. ");
INSERT INTO nhx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Iwá̱n kina̱ꞌtechoj iwá̱n kipajtilij ka̱n kimagakej. Kita̱lilij aceite iwá̱n vino, iwá̱n kilpilij iga tzótzol. Kitejkawi̱ltij ipan ibu̱rroj iwá̱n kiwi̱gaꞌ ipan se̱ kajli iwá̱n ompa kicuida̱rojtoya. ");
INSERT INTO nhx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ipan seꞌya día kua̱ꞌ yáwiya, kiki̱xtij tomi̱n yej vale̱rowa ke̱ꞌ se̱ kita̱niá o̱me día iwá̱n kimáꞌ ite̱ko kajli, iwá̱n kijlij: “Xine̱cuida̱rowili iní̱n ta̱gaꞌ, iwá̱n siga má̱j tigasta̱ro̱j, nimitzkuepili̱j kua̱ꞌ nimokuepas.” ");
INSERT INTO nhx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesús kijtoj: —De ini̱mej e̱yi ta̱gaꞌ, ¿a̱ꞌ mochij iyikni̱n inó̱n ta̱gaꞌ yej kitachtekijkej? ");
INSERT INTO nhx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yej tamachtiá ipan la ley kijtoj: —Yej kikne̱lij. Iwá̱n Jesús kijtoj: —Xaj iwá̱n ijko̱nsan no̱ xikchí̱ tej. ");
INSERT INTO nhx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús ojkuiꞌ sej iwá̱n asiꞌ ipan se̱ a̱ltepe̱tzi̱n ompa ka̱n se̱ siwa̱ꞌ yej ito̱ka̱ꞌ Marta ki‑o̱mema̱wij icha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta kipiaya se̱ isiwa‑ikni̱n yej ito̱ka̱ꞌ María, iwá̱n mota̱lij iyikxite̱noj Jesús iga makikaki yej yéj kijtojtoya. ");
INSERT INTO nhx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Eꞌ Marta, kiyo̱ltila̱ntoya iga kichi̱wa miaꞌ itekipáno̱l, kina̱ꞌtechoj Jesús iwá̱n kijlij: —NoTe̱ko, ¿ix ayá̱ꞌ tikita iga nosiwa‑ikni̱n ne̱senkoka̱wiliá notekipáno̱l? Xikijli iga mane̱pale̱wi. ");
INSERT INTO nhx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jesús kijtoj: —Marta, Marta, mitzyo̱ltila̱ntoꞌ iwá̱n poxsan mitzyo̱lmiktiá kuajkuantas. ");
INSERT INTO nhx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Eꞌ se̱san yej má̱j ye̱kti. María kitapejpen yej ye̱kti iwá̱n ayagaj yawi kika̱walti̱ti. ");
INSERT INTO nhx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se̱ día Jesús ora̱dojtoya ipan se̱ lugar iwá̱n kua̱ꞌ tamiꞌ ora̱doj se̱ idiscí̱poloj kitajtan: —NoTe̱ko, xine̱ne̱xtili̱ka̱n ken iga mani‑o̱ra̱do̱ka̱n, ijkó̱n ken Juan kine̱xtilij no̱ idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús kijtoj: —Kua̱ꞌ antajtowaj wa̱n Dios, xikijto̱ka̱n: NoTaj yej tonoꞌ ipan cielo, nochi makiweyimati̱lti moto̱ka̱ꞌ. Xirreina̱ró̱kiya. Mamochi̱wa ken tej tikneki ipan ta̱jli, ijkó̱n ken mochijtoꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Notakualmej yej nochipa niknekij, xine̱makaka̱n a̱man. ");
INSERT INTO nhx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Xinee̱lka̱wili̱ka̱n yej nikchijkej yej aye̱kti, ijkó̱n ken nejemej no̱ nike̱lka̱wiliáj yej ne̱chi̱wilijkej yej aye̱kti. Xine̱pale̱wi̱ka̱n iga amo manikchi̱wasnekika̱n yej aye̱kti; amo xine̱semakaka̱n kua̱ꞌ Tzitzimiꞌ ne̱chi̱walti̱jnekij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Iwá̱n no̱ kijlijkej: —Siga se̱ de amejeme̱n makipiá se̱ amigo iwá̱n tajkoyówal makijli̱ti: “Amigo, achi manimitztajtanili e̱yi mopa̱n ");
INSERT INTO nhx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","iga se̱ noami̱goj ásigoꞌ, wa̱laj wejka iwá̱n anikpiá te̱ nikualtiá.” ");
INSERT INTO nhx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Iwá̱n yej onoꞌ kalijtiꞌ, makijto: “Amo xine̱kuejkueso̱ki, nikaltzáktoꞌya, niwejwetztókeja iwá̱n nopilowa̱ntzitzi̱n. Awel nimoketza, awel nimitzmaka nité̱.” ");
INSERT INTO nhx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nimitzijliáj iga ayá̱ꞌ yawi moketzati iga san iyami̱goj, sino que iga nemi kitekiꞌtajtaniliá iwá̱n yawi kimakati inewi yej kipolowa. ");
INSERT INTO nhx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Inó̱n iga nimitzijliáj: Xiktajtanika̱n, iwá̱n Dios yawi mitzmakatij, xikte̱mo̱ka̱n iwá̱n ankasiskej, xikaltzotzonaka̱n iwá̱n mitzkaltapowili̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Iga yej kitajtani, kimakaj; iwá̱n yej kite̱mowa, kasi; iwá̱n yej kaltzotzona, kikaltapowiliáj. ");
INSERT INTO nhx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","’¿Ix wel se̱ de amejeme̱n ante̱tajmej kimakas ipiltzi̱n se̱ teꞌti kua̱ꞌ kitajtaniliá tákual? ¿O kua̱ꞌ kitajtaniliá to̱poj, kimakas se̱ kowa̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O kua̱ꞌ kitajtaniliá pioteksis, ix kimakas se̱ ko̱lo̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Siga amejemej yej ankichi̱waj yej aye̱kti, wel ankimakaj yej ye̱kti amopilowa̱n, ¡amoTaj yej onoꞌ ajko ipan cielo, ma̱jya sej kimakas iyEspí̱rito Santo a̱ꞌsan kitajtanili̱j! ");
INSERT INTO nhx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús kiki̱xtijtoya ma̱lespí̱ritoj ipan se̱ ta̱gaꞌ iga inó̱n ma̱lespí̱ritoj kino̱nojtilijtoya. Kua̱ꞌ ki̱saꞌ ma̱lespí̱ritoj, no̱noj welja tajtoj. Kua̱ꞌ inó̱n kitakej yej ompa onoyaj, san tajtachi̱xtikajkej. ");
INSERT INTO nhx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Eꞌ sekin kijtojkej: —Tzitzimiꞌ yej ijé̱fejpa ma̱lespi̱ritojmej, kimáꞌ poder iní̱n ta̱gaꞌ iga kiki̱xtiá ma̱lespi̱ritojmej. ");
INSERT INTO nhx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Sekin iga makima̱wetzi̱lti̱ka̱n Jesús, kitajtanilia̱yaj iga makichi̱wa tejté̱ yej mane̱si iga wi̱ꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Eꞌ Jesús kimatitoyay te̱ kejla̱ntoyaj in ino̱mej, iwá̱n kijlijkej: —Siga se̱ país mochi̱wa o̱me grupo iga mosepankuejkuesowaj, inó̱n país políwiya. Iwá̱n siga se̱ familia mose̱pankuejkuesowaj, aka̱wis ni agaj. ");
INSERT INTO nhx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ijkó̱n no̱ Tzitzimiꞌ siga isé̱ltisan moki̱xtiá, ¿kén yawi kipiati ipode̱r? Iní̱n nikijtowa iga amejeme̱n ankijtowaj iga nej niki̱xtiá ma̱lespí̱ritoj ipan ipode̱r Tzitzimiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eꞌ siga anne̱pantiáj iga nej niki̱xtiá ma̱lespí̱ritoj ipan ipode̱r Tzitzimiꞌ, in yej mitztokaj, ¿ix iga ipode̱r Tzitzimiꞌ kiki̱xtiáj ma̱lespí̱ritoj? Yejémejsan mone̱xtiáj iga ayéj ijkó̱n ken anne‑ijliáj. ");
INSERT INTO nhx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nej niki̱xtiá ma̱lespí̱ritoj iga ipode̱r Dios, inó̱n kijto̱jneki iga ásiꞌya tiempo iga Dios marreina̱ro ipan amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Kua̱ꞌ se̱ ta̱gaꞌ yej pox tajpalej kipiá yej iga moma̱nawiá, ayagaj wel kitachtekiá icha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Eꞌ siga wi̱ꞌ seꞌ yej má̱j tajpalej iwá̱n kita̱niliá, kikui̱liá inewi yej iga moma̱nawiá yej ípan moconfia̱rowa̱ya iwá̱n kichtekiliáj inewi yej kipiá. ");
INSERT INTO nhx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’Yej ayá̱ꞌ kiye̱ꞌita yej nikchi̱wa, ino̱nwaꞌ ne‑ijiya; yej ayá̱ꞌ ne̱pale̱wiá; ino̱nwaꞌ tapojpolowa. ");
INSERT INTO nhx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jesús no̱ kijtoj: —Kua̱ꞌ se̱ ma̱lespí̱ritoj ki̱sa ipan se̱ ta̱gaꞌ, nentinemi ipan wá̱ꞌta̱l iga kite̱mojtinemi ka̱n makalaki; iwá̱n siga ayá̱ꞌ kasi, kijtowa: “Nia sej nimokuepati nocha̱n, ka̱n niki̱saꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kua̱ꞌ mokuepa kasi inó̱n ta̱gaꞌ ken se̱ kajli yej tajtachpa̱ntolo̱ꞌ iwá̱n tayejye̱ꞌta̱lijtolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Iwá̱n yawi kikuiti seꞌ siete ma̱l espíritu yej ma̱jya sej que yéj, iwá̱n inochi̱n mocha̱ntiáj ipan inó̱n ta̱gaꞌ, iwá̱n inó̱n ta̱gaꞌ kichi̱was ma̱jya sej yej aye̱kti que achto. ");
INSERT INTO nhx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Mie̱j ta̱tapojtóyaoꞌ Jesús, se̱ siwa̱ꞌ tajtojté̱ꞌ recio, kijtoj: —¡Mayo̱lpa̱kto inó̱n siwa̱ꞌ yej mitzonoltij iwá̱n mitziskaltij! ");
INSERT INTO nhx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús kijtoj: —¡Má̱j mayo̱lpa̱kika̱n yej kikakij itájto̱l Dios iwá̱n yej kichi̱waj ken kijtowa! ");
INSERT INTO nhx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Má̱j ajasitia̱yaj ka̱n onoya Jesús iwá̱n pe̱waꞌ iga kijtoj: —Ini̱mej gente pox ma̱lojmej iga kinekij manikchi̱wa yej ayi̱ꞌpa mo‑ita, eꞌ ayá̱ꞌ nia nikne̱xtili̱tij nité̱, petz yej Dios kichi̱wilij Jonás. ");
INSERT INTO nhx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ijkó̱n ken yej cha̱ntitoyaj Nínive kitakej ipode̱r Dios ipan Jonás, ijkó̱n no̱ yej á̱mampa onokej kitaskej ipode̱r Dios ipan nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kua̱ꞌ Dios tajuzga̱ro̱j, moketzas no̱ la reina yej manda̱roj ipan ta̱jli de Sabá iga mitzjuzga̱ro̱skej, iwá̱n kijto̱j iga ayompa ankichijkej. Inó̱n reina wejka nejnen iga makikaki yej kimati rey Salomón; iwá̱n nej ma̱jya sej que Salomón. ");
INSERT INTO nhx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Kua̱ꞌ Dios tajuzga̱ro̱j, yej icha̱mej weyi‑a̱ltepe̱ꞌ Nínive, moketzaskej iga mitzjuzga̱ro̱skej, iwá̱n kijto̱skej iga ankichijkej yej aye̱kti; iga yej cha̱ntitokej Nínive, kua̱ꞌ Jonás kipowaꞌ itájto̱l Dios, kikajtejkej iga kichi̱wayaj yej aye̱kti; iwá̱n nej ma̱jya sej que Jonás. ");
INSERT INTO nhx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Ayagaj kixo̱taltiá icándi̱l iwá̱n maki̱ya̱na, niga kita̱liá itampa cajo̱n, sino que kita̱liá ajko iga yej kalakiskej matachaka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Moyi̱x ken tikita se̱ cándi̱l yej mitzta̱wiá; siga moyi̱x ye̱kti, mitzta̱wijtos. Eꞌ siga aye̱kti, tonos ken kua̱ꞌ takomichka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ximocuida̱ro iga inó̱n tiꞌti yej tikpiá amo mase̱wi. ");
INSERT INTO nhx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eꞌ siga mono̱ya̱n mitzta̱wijtoꞌ inó̱n tiꞌti, ayá̱ꞌ tonos ken takomichka̱n, no̱ya̱n titachás, ken kua̱ꞌ se̱ cándi̱l mitzta̱wijtos. ");
INSERT INTO nhx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kua̱ꞌ tamiꞌ tajtoj Jesús, se̱ fariseo kijlij iga matakua̱ti icha̱n. Jesús yajki, kalaꞌ icha̱n iwá̱n kí̱xna̱nya mesa. ");
INSERT INTO nhx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Iwá̱n fariseo ayá̱ꞌ kiye̱ꞌitaꞌ iga Jesús ayá̱ꞌ achto moma̱pá̱ꞌ ken kitekichi̱waj kua̱ꞌ takuaj. ");
INSERT INTO nhx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Eꞌ toTe̱ko kijlij: —Amejeme̱n fariseojmej kenkua̱ꞌ ankipajpa̱kaj plato iwá̱n posillo fue̱rájbapa, eꞌ amejeme̱n ipan amoa̱lmajmej ankejla̱ntokej iga antachtekij iwá̱n ankichi̱wasnekij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ampachto̱lmej! ¿Ix ayá̱ꞌ ankimatij iga yej kichij fue̱rájbapa kichij no̱ yej ta‑ijtikpa? ");
INSERT INTO nhx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nimitzijliáj iga achi xikmakaka̱n ken tejté̱ yej ankipiáj, ino̱mej yej ayá̱ꞌ motapialiáj iwá̱n ijkó̱n anye̱ꞌonoskej iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Anla̱stimajmej fariseojmej!, iga ankaparta̱rowiliáj Dios diez por ciento de hierba buena, de chichi̱ꞌkuaxiwiꞌ iwá̱n de inewi kuaxiwimej yej mókuapa. Eꞌ ayá̱ꞌ ankichi̱waj ken Dios kineki iwá̱n ayá̱ꞌ ankinekij Dios. Ini̱nwaꞌ in yej ye̱kti iga xikchi̱waka̱n iwá̱n amo xike̱lka̱waka̱n iga xikyokati̱ka̱n yej itátkipa Dios. ");
INSERT INTO nhx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Anla̱stimajmej fariseojmej!, iga ka̱n takualo anmota̱li̱jnekij ipan ye̱ꞌasie̱ntoj ka̱n mota̱liáj yej má̱j tayaka̱ntokej yej onokej tio̱pan, iwá̱n ankinekij iga nochi mamitzsaluda̱ro̱ka̱n tajkoa̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Anla̱stimajmej yej antamachtiáj ipan la ley iwá̱n anfariseojmej, anmopajpantiáj iga anye̱ꞌnemij!, ken tikita an‑a̱nimajxapomej yej ane̱si, yej kipa̱patiliá la gente iwá̱n akitaj. ");
INSERT INTO nhx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iwá̱n se̱ yej tamachtiá ipan la ley, kijtoj: —Tamachtia̱ni, iga inó̱n tikijtoj, anne̱po̱powaj no̱ nejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Eꞌ Jesús kijtoj: —¡Anla̱stimajmej, yej antamachtiáj ipan la ley!, iga ankitekimakaj amoge̱ntej makichi̱waka̱n yej ayagaj wel kichi̱wa. Eꞌ amejeme̱n niga achi ankipale̱wiáj. ");
INSERT INTO nhx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Anla̱stimajmej!, yej ankichi̱wiliáj ikalyotzitzi̱n ka̱n to̱ktokej profe̱tajmej yej kimijmiktijkej amotajwa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Iga ijkó̱n ankichi̱waj, ankiye̱ꞌitaj yej kichijkej amotajwa̱n. Yejeme̱n kimijmiktijkej iwá̱n amejeme̱n ankichi̱wiliáj ikalmej ka̱n to̱ktokej. ");
INSERT INTO nhx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Inó̱n iga Dios yej nochi kimati kijtoj: “Nia nimitzti̱tanili̱tij profe̱tajmej iwá̱n notati̱tanimej, sekin de yejemej anyawij ankimikti̱tij iwá̱n sekin anyawij ankitalo̱chti̱tij.” ");
INSERT INTO nhx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Eꞌ Dios yawi kikulpa̱ro̱ti la gente de ina̱mpa de inó̱n i‑esyomej inewi profe̱tajmej yej kimijmiktijkej este iga kua̱ꞌ pe̱waꞌ iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pe̱waꞌ este iga kimiktijkej Abel iwá̱n este iga kimiktijkej Zacarías, yej kimiktijkej iyi̱xtaj weyitio̱pan, ite̱noj altar. Iná̱n nimitzijliáj iga Dios yawi kicastiga̱ro̱ti la gente yej iná̱n onokej iga mikikej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Anla̱stimajmej yej antamachtiáj ipan la ley!, iga ankitzakuaj itájto̱l Dios, amejeme̱n ayá̱ꞌ anki̱xmatij Dios iwá̱n ankitzakuiliáj yej ki̱xmatisnekij. ");
INSERT INTO nhx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kua̱ꞌ Jesús tamiꞌ kijtoj iní̱n, yej tamachtiáj ipan la ley iwá̱n fariseojmej pe̱waꞌ iga kuejkuesiwikej iwá̱n kitajtajtankej poxsan Jesús; ");
INSERT INTO nhx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kimelaꞌte̱mowilia̱yaj ka̱nsan makijto se̱ tájto̱l iga wel makima̱wetzi̱lti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Iwá̱n monechkojkej miles de gente este moto̱tope̱wayaj. Iwá̱n Jesús achto pe̱waꞌ kijlij idisci̱polojmej: —Taꞌ xikakika̱n: amo xikchi̱waka̱n ken kitekichi̱waj fariseojmej, iga yejemej né̱sikiꞌ ye̱ꞌnemij, sie̱mpa ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ateyi nisé̱ yej mochi̱wa ichtákasan yej ayá̱ꞌ mamomati, iwá̱n ateyi nisé̱ yej i̱ya̱ntoꞌ yej amo mamomati. ");
INSERT INTO nhx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Nimitzijliáj iga inewi yej ankijtowaj ka̱n takomichka̱n, yawi mokakiti ka̱n tachalpan iwá̱n siga amo‑ichtakata̱tapo̱wiáj ankaltzaktókejpa, yawi motzajtzitipowati ka̱n no̱ya̱n mokaki. ");
INSERT INTO nhx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Nokni̱wa̱n, nimitzijliáj iga amo xikmajmawili̱ka̱n yej tamiktiáj, eꞌ má̱j má̱j awel te̱ kichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Eꞌ nia nimitzijli̱tij a̱ꞌyéj xikmajmawili̱ka̱n; xikmajmawili̱ka̱n Dios yej wel mitzmiktiáj iwá̱n wel mitzmo̱taj ka̱n tawewelkatoꞌ, ino̱nwaꞌ in yej xikmajmawili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’Ankimatij iga monamaka cinco to̱to̱tzitzi̱n iga o̱me tomi̱ntzitzi̱n, eꞌ Dios ayá̱ꞌ ke̱lka̱wa nisé̱ de inó̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Dios kimati ke̱ꞌ amotzonkalmej ankipiáj ipan amotzontekon. Amo ximajmawika̱n, amejemej má̱j anvale̱rowaj que miaꞌ to̱to̱tzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Nimitzijliáj iga inewi yej kinojma‑ijtowa iyi̱xtaj la gente iga ne̱toka, nej yej iPiltzi̱n Ta̱gaꞌ, no̱ nia nikijto̱ti iyi̱xtaj iya̱ngelejmej Dios iga ne̱toka. ");
INSERT INTO nhx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Eꞌ yej makijto iyi̱xtaj la gente iga ayá̱ꞌ ne̱toka, no̱ nia nikijto̱ti iyi̱xtaj iya̱ngelejmej Dios iga ayá̱ꞌ ne̱toka. ");
INSERT INTO nhx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Siga agaj makijto yej aye̱kti iga iPiltzi̱n Ta̱gaꞌ, Dios weljoꞌ ke̱lka̱wili̱j yej kijtoj, eꞌ yej mama̱ltajto iga iyEspí̱ritoj Dios, inó̱n Dios ayoꞌ ke̱lka̱wili̱j. ");
INSERT INTO nhx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Kua̱ꞌ mitzwi̱gaskej tio̱pan o iyi̱xtaj jue̱zmej o iyi̱xtaj yej manda̱rowaj; amo xitayo̱koyaka̱n iga ayá̱ꞌ ankimatij te̱ anyawij ankijto̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","IyEspí̱ritoj Dios yawi mitzne̱xtili̱tij te̱ anyawij ankijto̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Se̱ tokni̱n itza̱la̱n gente kijlij Jesús: —Tamachtia̱ni, xikijli nokni̱n iga mane̱maka achi yej ne̱ka̱wilijkej notajmej. ");
INSERT INTO nhx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Eꞌ Jesús kijlij: —Ej, ¿a̱ꞌyéj ne̱ta̱lij iga juez iga manimitzmajmakaka̱n yej amotatki? ");
INSERT INTO nhx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Kijtoj no̱: —Ximocuida̱ro̱ka̱n, amo xikpoxpiasnekika̱n tejté̱ yej awel ankipiáj. Se̱ ta̱gaꞌ awel ye̱ꞌono iga san makipiá komati yej pox patiyoj. ");
INSERT INTO nhx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iwá̱n kipowilijkej se̱ ka̱n wel mi̱xkui̱tilo: —Onoya se̱ ta̱gaꞌ yej poxsan motapialia̱ya iwá̱n pox mochi̱waya yej kito̱kaya pan ími̱l, iwá̱n pox mochi̱waya yej kito̱kaya. ");
INSERT INTO nhx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Inó̱n ta̱gaꞌ ijkí̱n kijtowa̱ya ipan iya̱lmaj: “¿Té̱ iná̱n nia nikchi̱wati? Ayá̱ꞌ nikpiá ka̱n nika̱na yej niki̱xtij ipan nómi̱l.” ");
INSERT INTO nhx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iwá̱n kijtoj: “Nikmátiya te̱ nia nikchi̱wati, nia nikxijxiti̱nati ka̱n nika̱na nokose̱chaj iga manikchi̱wa yej má̱j wejweyi, iwá̱n ompa nia nika̱nati inewi nokose̱chaj, iwá̱n inewi yej nikpiá. ");
INSERT INTO nhx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Iwá̱n nia nikijli̱ti noa̱lmaj: Noa̱lmaj, paré̱j timotae̱nilijtoꞌ iga miaꞌ año; ximose̱wi, xitakua, xi‑a̱ti, xipa̱ki.” ");
INSERT INTO nhx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Eꞌ Dios kijlij: “Ta̱gaꞌ yej ken atitajla̱ntoꞌ, ini̱nsan yówal tia timikiti, iwá̱n yej tika̱ntoꞌ, ¿a̱ꞌyéj tika̱wili̱j?” ");
INSERT INTO nhx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ijkó̱n mochi̱wa se̱ yej kinejnechkowa itomi̱n iga yéjsan; eꞌ iyi̱xtaj Dios ayá̱ꞌ kipiá nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jesús kijlij idisci̱polojmej: —Nimitzijliáj iga amo xikyo̱koyaka̱n té̱ anyawij ankikua̱tij iga wel xonoka̱n, niga xikyo̱koyaka̱n amotzotzolmej yej anyawij ankaki̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Tejemej má̱j tivale̱rowaj que tákual iwá̱n tocue̱rpoj má̱j sej que tzótzol. ");
INSERT INTO nhx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Taꞌ xikitaka̱n to̱to̱mej ayá̱ꞌ mi̱lchi̱waj iwá̱n niga tapixkaj iwá̱n akipiáj kajli ka̱n ka̱naj yej kipixkaj, iwá̱n Dios kitamakaj. ¡Puej amejeme̱n má̱j anvale̱rowaj que to̱to̱mej! ");
INSERT INTO nhx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Iwá̱n a̱ꞌ de amejemej iga san matayo̱koya iga chapatiꞌ, wel weyás seꞌ alí̱n? ");
INSERT INTO nhx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Siga awel ankichi̱waj iní̱n yej alí̱n, ¿te iga anmoyo̱lmiktiáj ipan sewoꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Taꞌ xikitaka̱n ken iga weyáj xo̱chimej, ayá̱ꞌ tekipanowaj iwá̱n niga tajtzomaj. Eꞌ nimitzijliáj niga el rey Salomón malej iga moye̱ꞌtaajakia̱ya; ayá̱ꞌ kaxilij ken ino̱mej xo̱chimej yej mojmo̱nsajtikej. ");
INSERT INTO nhx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iwá̱n siga Dios ijkó̱n kimo̱nsajchi̱wa kuaxiwiyoj yej a̱man onoꞌ ipan a̱ka̱walyoj iwá̱n mo̱sta tatas ipan tiꞌti, ¿kén iga ayá̱ꞌ mitztzotzolyo̱ti̱skej, amejeme̱n yej alí̱n anmoconfia̱rowaj ipan Dios? ");
INSERT INTO nhx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amejeme̱n amo xitayo̱koyaka̱n iga ayoꞌ te̱ ankikua̱skej o té̱ anyawij ankoni̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yej ayá̱ꞌ ki̱xmatij iyojwi Dios, tayo̱koyaj iga nochi iní̱n, eꞌ amoTaj yej onoꞌ ajko kimátiya te̱ mitzpolowaj amocha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Eꞌ ximote̱makaka̱n iga Dios marreina̱ro ipan amejeme̱n, iwá̱n nochi ini̱mej yej mitzpolowaj anyawij ankipiatij. ");
INSERT INTO nhx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jesús kijtoj: —Amo ximajmawika̱n, amejeme̱n yej ken amborre̱gojmej yej ayá̱ꞌ ankomatimej, eꞌ toTaj kineki iga íwa̱n xisenmanda̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xiknamakaka̱n yej ankipiáj iwá̱n xikmakaka̱n yej akipiáj. Ijkó̱n ken anke̱naj amotomi̱n ipan yej ayí̱ꞌ tamis, iwá̱n ipan cielo ken ankipiáj amotomi̱n yej ayi̱ꞌpa tami, ka̱n ayagaj tachteki, iwá̱n ka̱n we̱chi ayá̱ꞌ taxi̱xiti̱na. ");
INSERT INTO nhx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ka̱n onoꞌ yej mitzyo̱ltila̱na ompa nochipa tikejla̱ntos. Jesús kijtoj: ");
INSERT INTO nhx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Xine̱chi̱xtoka̱n iga niwi̱ꞌ, xitaajakijtóka̱nya iwá̱n maxo̱tátoya amomecho̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xonoka̱n ken inó̱n tekipanowa̱nimej yej kichi̱xtokej ite̱komej iga maasi, iga yajki ka̱n mona̱miktilo, iga kua̱ꞌ asis, kikaltapowili̱skej kua̱ꞌ kaltzotzonas. ");
INSERT INTO nhx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pa̱ktokej tekipanowa̱nimej iga kua̱ꞌ asis ite̱ko makasikij isatokej; nimitznojma‑ijliáj iga ite̱ko yawi ki̱xna̱nti̱tij ipan mesa iwá̱n yéjsan ima̱tika kita̱li̱j tákual. ");
INSERT INTO nhx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pa̱ktokej yejemej siga kasitij isatokej, malej iga asis tajkoyówal o kua̱ꞌ isájpasan. ");
INSERT INTO nhx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Iwá̱n iní̱n xikmatika̱n, siga se̱ ite̱ko kajli kimatiá katka ke̱man yawi asiti yej tachteki, ayá̱ꞌ mokochkui̱li̱j iwá̱n ayá̱ꞌ mote̱makas iga makikaltapo̱ka̱n iga makitachtekika̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Inó̱n iga amejeme̱n xisatoka̱n iga xine̱chi̱xtoka̱n; nej yej iPiltzi̱n Ta̱gaꞌ niwi̱ꞌ kua̱ꞌ ayá̱ꞌ ankimatitokej. ");
INSERT INTO nhx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pedro kitajtan: —NoTe̱ko, ¿ix tikpowaꞌ iní̱n iga manimi̱xkui̱ti̱ka̱n nejémejsan o iga inochi? ");
INSERT INTO nhx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Kijtoj toTe̱ko: —¿A̱ꞌyéj onos ken inó̱n ye̱ꞌtekipanowa̱ni yej nochipa kichi̱wa ken kijliá ite̱ko, yej kita̱liá iga makimanda̱ro sekin itekipanowa̱nimej ipan icha̱n iga matatamaka kua̱ꞌ takualo? ");
INSERT INTO nhx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pa̱ktoꞌ inó̱n tekipanowa̱ni iga kua̱ꞌ asis ite̱ko makasiki kichijtoꞌ ken kitekimakakej. ");
INSERT INTO nhx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nimitzijliáj iga inó̱n tekipanowa̱ni yawij kita̱li̱tij iga makimanda̱ro inochi yej itátkipa ite̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Eꞌ siga inó̱n tekipanowa̱ni makijto ipan iya̱lmaj: “Note̱ko wejká̱wasoꞌ iga asis”, iwá̱n pe̱was iga kikno̱chi̱was sekin tekipanowa̱nimej, tajta̱gaꞌ iwá̱n siwa̱tkej. Iwá̱n pe̱was iga takua iwá̱n a̱ti este ta̱wa̱na. ");
INSERT INTO nhx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yawi asiti ite̱ko inó̱n tekipanowa̱ni kua̱ꞌ ayá̱ꞌ kichi̱xtoꞌ, iwá̱n kua̱ꞌ ayá̱ꞌ kimatitoꞌ, iwá̱n yawi kicastiga̱ro̱ti, kiti̱tanis ka̱nsan yawij yej ayá̱ꞌ tacre̱dowaj. ");
INSERT INTO nhx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Tekipanowa̱ni yej kimajmati te̱ kineki ite̱ko iwá̱n ayá̱ꞌ kejla̱mikis iga makichi̱wa, yawij kimagatij poxsan. ");
INSERT INTO nhx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Eꞌ yej ayá̱ꞌ kimatitoꞌ iga kichi̱wa yej kajasi iga makicastiga̱ro̱ka̱n, inó̱n ayá̱ꞌ poxsan yawij kimagatij. Siga agaj Dios kimaka komati, no̱ kitajtanili̱j komati; siga agaj Dios poxsan kipialiá confianza, poxsan maye̱ꞌnemi. ");
INSERT INTO nhx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Nej niwa̱laj niktikuilti̱ko tiꞌti ipan iní̱n ta̱jli, ¡iwá̱n nejwaꞌ niknekiá iga mawe̱weló̱ntoya! ");
INSERT INTO nhx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nia nipano̱ti ken ipan se̱ bautismo iga yawij ne̱poxikno̱chi̱watij, ¡poxsan nimoyo̱lmiktijtoꞌ malej ga aya asi inó̱n día iga mamochi̱wa! ");
INSERT INTO nhx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ankijtowaj a̱n niwa̱laj iga xonoka̱n tamelá̱ ipan iní̱n ta̱jli? Nimitzijliáj iga ayá̱ꞌ; niwa̱laj iga ximoyojyokati̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Desde iná̱n, cinco ipan se̱ kajli yawij yojyokatitotij, e̱yi kijiyaskej yej o̱memej, iwá̱n o̱me̱n kijiyaskej e̱yi. ");
INSERT INTO nhx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Te̱taj yawi kijiyati ipiltzi̱n iwá̱n te̱piltzi̱n yawi kijiyati itaj; te̱ye̱ꞌ yawi kijiyati isiwa̱piltzi̱n, isiwa̱piltzi̱n yawi kijiyati iye̱ꞌ; móna̱nti yawi kijiyati isiwa̱mon iwá̱n siwa̱mon yawi kijiyati imona̱n. ");
INSERT INTO nhx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús kijlij no̱ la gente: —Kua̱ꞌ ankitaj moketza mixti ikalakiya̱n to̱nati̱ꞌ, ankijtowaj iga yawi wi̱tzeti tiawa̱ꞌ, iwá̱n ijkó̱n mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Iwá̱n kua̱ꞌ tejkawi ejekaꞌ, ankijtowaj iga yawi tadoto̱nitiati, iwá̱n ijkó̱n mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Amejeme̱n antakajkaya̱waj iga ankitokaj Dios! Amejemej ankimatij yej kijto̱jneki mixti iwá̱n yej mochi̱was ipan ta̱jli, ¿iwá̱n te íga awel ankentende̱rowaj yej nejpa nemi nikchi̱wa yej Dios nemi mitzne̱xtiliáj? ");
INSERT INTO nhx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’¿Te iga ayá̱ꞌ amogá̱najsan anmo‑ijliáj iga ankichijtokej yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Siga agaj mitzdemanda̱rowa iwá̱n mitzwi̱ga ka̱n manda̱ro̱lo, ximoyo̱lta̱lí̱ka̱nsan ipan ojti. Porque siga mitzwi̱ga iyi̱xtaj juez, juez kitekimakas policiyajmej iga mitzaki̱skej kuákalko. ");
INSERT INTO nhx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nimitzijliá iga atiki̱sas ompa este que xikixta̱wa inewi ke̱ꞌ mitztajtaniliáj. ");
INSERT INTO nhx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Íkua̱ꞌsan wa̱lkej sekin iwá̱n kita̱tapo̱wijkej Jesús iga Pilato kimijmiktij sekin tajta̱gaꞌ de Galilea kua̱ꞌ onoyaj tio̱pan, iwá̱n ino̱mej iyesyomej kisene̱tilij iwá̱n iyesyo yo̱lka̱mej yej kimakayaj iga iyofre̱ndaj Dios. ");
INSERT INTO nhx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iwá̱n Jesús kijtoj: —¿Ankijtowaj amejeme̱n iga ijkó̱n kichi̱wilijkej ino̱mej de Galilea iga má̱j kichijkej yej aye̱kti que sekin galileos? ");
INSERT INTO nhx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nimitzijliáj iga ayá̱ꞌ; siga ayá̱ꞌ anmoyo̱lpataj, amonochi̱n anyawij ampoliwitij no̱. ");
INSERT INTO nhx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O amejeme̱n ankijtowaj iga ino̱mej dieciocho yej mikikej kua̱ꞌ torre de Siloé wetziꞌ iwá̱n kitepachojkej, má̱j kichijkej yej aye̱kti que sekin yej cha̱ntitokej Jerusalén? ");
INSERT INTO nhx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nimitzijliáj iga ayá̱ꞌ; siga ayá̱ꞌ anmoyo̱lpataj, amonochi̱n anyawij ampoliwitij no̱. ");
INSERT INTO nhx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús kijtoj iní̱n iga mami̱xkui̱tilo: —Se̱ ta̱gaꞌ kipiaya se̱ higue̱rajkuawiꞌ yej ixwatoya ipan íta̱l, iwá̱n yajki kitato siga ayá̱ꞌ ta̱ktoꞌ; eꞌ ayá̱ꞌ kasilij nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kijlij yej kicuida̱rowa ta̱jli: “Kipiaya e̱yi xiwiꞌ iga niktekite̱moli̱ki ita̱kilka iní̱n higue̱rajkuawiꞌ iwá̱n ayí̱ꞌ nikasiliá. Xiktzontékiya; ¿te iga yawi ta̱lpolojtoti, ayéj iga ta̱ki?” ");
INSERT INTO nhx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Inó̱n yej kicuida̱rowa̱ya ta̱jli kijtoj: “Patrón, acho̱ꞌ xikajte̱wa iní̱n xiwiꞌ; manikaxa̱níli‑oꞌ ta̱jli iwá̱n nia nikta̱lili̱ti abono. ");
INSERT INTO nhx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ijkó̱n sí, anka tá̱kisya; eꞌ siga ayá̱ꞌ ta̱kis, xiktzontekiy.” ");
INSERT INTO nhx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jesús tamachtijtoya tio̱pan ipan se̱ día kua̱ꞌ mose̱wilo ");
INSERT INTO nhx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","iwá̱n ompa onoya se̱ siwa̱ꞌ yej kipiaya dieciocho año iga we̱titoꞌ. Se̱ ma̱lespí̱ritoj kitepoꞌwijkolojtoya iwá̱n ni alí̱n awel kimela̱waya itepoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kua̱ꞌ Jesús kitaꞌ, kino̱tzaꞌ iwá̱n kijlij: —Ti‑achitiaꞌya. ");
INSERT INTO nhx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iwá̱n kita̱lilij ima̱mej ipan inó̱n siwa̱ꞌ iwá̱n íkua̱ꞌsan tepoꞌmela̱wayaꞌ iwá̱n pe̱waꞌ kiweyimati̱ltij Dios. ");
INSERT INTO nhx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Eꞌ yej manda̱rowa tio̱pan kuejkuesiwiꞌ iga Jesús taachitialtij ipan día kua̱ꞌ mose̱wilo, kijlij yej ompa onoyaj: —Onoꞌ seis día iga tekipano̱lo. Ipan ino̱mej día xiwi̱tzeka̱n, ximoachitialti̱kij, ayéj ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iwá̱n toTe̱ko kijtoj: —Amejeme̱n antakajkaya̱waj iga ankitokaj Dios, ¿ix ayá̱ꞌ ankixitomaj amoto̱roj o amobu̱rroj ipan día kua̱ꞌ mose̱wilo iga anyawij anka̱makatij? ");
INSERT INTO nhx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Iwá̱n iní̱n siwa̱ꞌ ipiltzi̱n ipilówa̱mpa Abraham. Iwá̱n Tzitzimiꞌ kenkua̱ꞌ kilpitoya iga kokolis dieciocho año, ¿ix ayá̱ꞌ katka mamoxitoma malej iga ipan día kua̱ꞌ mose̱wilo? ");
INSERT INTO nhx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kua̱ꞌ Jesús tamiꞌ iní̱n kijtoj, nochi yej ta‑ijiyayaj mopi̱najtijkej. Eꞌ nochi pa̱kiáj kua̱ꞌ kitayaj iga Jesús kichi̱waya yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús kijtoj: —¿Kén wel nimitzijli̱skej iga reina̱rowa Dios?, ¿iwá̱n té̱ wel nikmacho̱ti̱j? ");
INSERT INTO nhx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nikmacho̱tiá iwá̱n se̱ íyo̱l mostaza yej kito̱ka se̱ ta̱gaꞌ ipan íta̱l, ixwa iwá̱n weyá este que mochi̱wa weyikuawiꞌ, iwá̱n to̱to̱mej moxeketiáj ipan imajma̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Kijtoj no̱ Jesús: —¿Iga te̱ íwa̱n wel nikmacho̱tiá ken iga Dios reina̱rowa? ");
INSERT INTO nhx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nikmacho̱tiá iwá̱n levadura yej se̱ siwa̱ꞌ ka̱xakualowa iwá̱n komati harina, iwá̱n moposa̱wa inewi tixti. ");
INSERT INTO nhx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kua̱ꞌ Jesús nemi ya̱ya Jerusalén, pano̱tia̱ya ipan a̱ltepe̱mej iwá̱n ipan a̱ltepe̱tzitzi̱n iga tamachtijtia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Iwá̱n a̱ꞌpa kijtoj: —NoTe̱ko, ¿ix ayá̱ꞌ ke̱ꞌ yej moma̱nawiáj? Jesús kijtoj: ");
INSERT INTO nhx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Xitekiꞌkalakika̱n ipan kalte̱n yej tzo̱ltiꞌ, nimitzijliáj iga miaꞌ kalakisnekiskej iwá̱n ayá̱ꞌ welitiaskej. ");
INSERT INTO nhx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kua̱ꞌ ite̱ko kajli mokétzasya iwá̱n kitzákuasya kalte̱n, amejemej yej amonokej fuera ankaltzotzonaskej iwá̱n ankijto̱skej: “Nokó̱w, nokó̱w, achi xine̱kaltapo̱ka̱n.” Eꞌ yéj mitzijli̱skej: “Ayá̱ꞌ nimitzi̱xmatij.” ");
INSERT INTO nhx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Iwá̱n ankijto̱skej: “Tisentakuajkej iwá̱n tisen‑a̱tikej, iwá̱n anne̱machtijkej ipan noca̱llejmej.” ");
INSERT INTO nhx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Eꞌ yéj mitzijli̱skej: “Nimitzijlíjkeja iga ayá̱ꞌ nimitzi̱xmatij. Xicholo̱ka̱n note̱noj, amonochi̱n yej ankichi̱waj yej aye̱kti.” ");
INSERT INTO nhx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ankitaskej Abraham, Isaac, Jacob iwá̱n inewi profe̱tajmej yej onokej ka̱n reina̱rowa Dios, mie̱j amejeme̱n amonoskej fuera, anyawij ancho̱katij iwá̱n antangueguetzekaskej. ");
INSERT INTO nhx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Wi̱tzelo̱j del nó̱rtejpa iwá̱n del sur iwá̱n ka̱n iki̱sáya̱mpa to̱nati̱ꞌ iwá̱n ikalakíya̱mpa iga mamota̱li̱ka̱n iga matakua̱ka̱n ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yej iná̱n onokej tatepotztaj yawij tayaka̱ntotij, iwá̱n yej iná̱n tayaka̱ntokej yawij ka̱witij tatepotztaj. ");
INSERT INTO nhx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Íkua̱ꞌsan asikej sekin fariseojmej iwá̱n kijlijkej: —Xikí̱saya nigaj iwá̱n xaja iga Herodes mitzmikti̱jneki. ");
INSERT INTO nhx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Eꞌ yéj kijtoj: —Xa̱ka̱n iwá̱n xikijli̱ka̱n inó̱n koyo̱ꞌ yej takajkaya̱wa: “Iga a̱man iwá̱n mo̱sta nia nikijki̱xti̱ti ma̱lespi̱ritojmej iwá̱n nia nitaachitialti̱ti iwá̱n mo̱sta se̱ día niktami̱j notekipáno̱l.” ");
INSERT INTO nhx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Eꞌ kipiá iga a̱man, mo̱sta iwá̱n mo̱sta se̱ día nia ninejnemiti, iga awel mamiki se̱ profeta siga ayá̱ꞌ onoꞌ Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Amejeme̱n, amejeme̱n, yej ancha̱ntitokej Jerusalén, yej ankimiktiáj profe̱tajmej iwá̱n ankitejtemiktiáj tati̱tanimej yej Dios mitzti̱taniliáj! ¡Miaꞌ ve̱j nikneꞌ manimitznechko̱ka̱n ken pio‑ilamaj kinechkowa ipilowa̱ntzitzi̱n iya̱stakapaltampa, eꞌ ayá̱ꞌ ankinekikej! ");
INSERT INTO nhx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Taꞌ xikitaka̱n, iná̱n amoweyitio̱pan yawi ka̱witi ise̱lti; iwá̱n nimitzijliáj iga ayá̱ꞌ má̱j anyawij anne‑itatij este kua̱ꞌ antajto̱skej de nej ijkí̱n: “Matikweyimati̱lti̱ka̱n yej wi̱ꞌ, yej toTe̱ko Dios kiti̱tani.” ");
INSERT INTO nhx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Se̱ día kua̱ꞌ mose̱wilo, Jesús yajki takua̱to cha̱n se̱ ije̱fej fariseojmej, iwá̱n sekin fariseojmej kipi̱pixtoyaj. ");
INSERT INTO nhx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ompa no̱ onoya iyi̱xtaj Jesús se̱ ta̱gaꞌ yej pojposa̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iwá̱n Jesús kitajtan yej tamachtiáj ipan la ley iwá̱n fariseojmej: —¿Ix wel taachitialtilo ipan día kua̱ꞌ mose̱wilo, o ayá̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Eꞌ yejemej até̱ kijtojkej. Jesús kiki̱tzkij yej we̱titoya iwá̱n kachitialtij, iwá̱n kijlij iga mayáwiya icha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Iwá̱n kijlij sej fariseojmej: —¿A̱ꞌyéj de amejeme̱n, siga ibu̱rroj o ito̱rojwé̱j mawetzi xapoko, ix ayá̱ꞌ íkua̱ꞌsan kiki̱xti̱j malej iga día kua̱ꞌ mose̱wilo? ");
INSERT INTO nhx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Iwá̱n ayá̱ꞌ nokta wel kite̱nkuepilia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kua̱ꞌ Jesús kitaya iga yejemej kitapejpenayaj iga mamota̱li̱ka̱n ka̱n mota̱liáj yej má̱j tayaka̱ntokej, ijkí̱n kino̱no̱tzkej: ");
INSERT INTO nhx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Kua̱ꞌ agaj mitzinvita̱rowa ka̱n mona̱miktilo, amo ximota̱li ka̱n mota̱liáj yej paré̱j tayaka̱ntokej, iga wel asi seꞌ yej má̱j tayaka̱ntoꞌ que tej, ");
INSERT INTO nhx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","iwá̱n yej mitzinvita̱roj wel mitzijliá: “Achi ximoketza iga mamota̱li iní̱n tokni̱n.” Iwá̱n tia timopi̱najti̱ti iga tia timota̱li̱ti ka̱n mota̱liá ná̱mo̱l. ");
INSERT INTO nhx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kua̱ꞌ mitzinvita̱rowaj, ximota̱li ka̱n mota̱liá ná̱mo̱l; iga kua̱ꞌ mawi̱ki yej mitzinvita̱roj, mamitzijli: “Amigo, ximota̱li ka̱n mota̱liá yej má̱j tayaka̱ntoꞌ.” Ijkó̱n mitzye̱ꞌitaskej poxsan yej ki̱xna̱ntoskej mesa. ");
INSERT INTO nhx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Porque yej igá̱najsan moweyimati, inó̱n yawij kali̱mpamatitij, iwá̱n yej moali̱mpamati, yawij kiweyimatitij. ");
INSERT INTO nhx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús kijlij no̱ inó̱n yej ta‑invita̱rowa: —Kua̱ꞌ tikchi̱wa ilwiꞌ o se̱ cena, amo xikinvita̱ro yej íwa̱n timoye̱ꞌita, niga mokni̱wa̱n, niga moparie̱ntejmej, niga moveci̱nojmej yej motapialiáj; iga yejemej wel mitzinvita̱ro̱skej iwá̱n ijkó̱n mitzma̱kuepaskej. ");
INSERT INTO nhx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kua̱ꞌ titatamakasneki, xikno̱tza iga mawi̱tzeka̱n yej ayá̱ꞌ motapialiáj, ma̱tepomej, ko̱xomej iwá̱n pachamej. ");
INSERT INTO nhx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Iwá̱n tipoxpa̱ktos iga yejemej awel mitzma̱kuepaskej; eꞌ tej yawij mitzma̱kuepatij kua̱ꞌ yej ye̱ꞌnemij ojpa‑isaskej ka̱n miktokej. ");
INSERT INTO nhx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kua̱ꞌ kikáꞌ iní̱n, se̱ yej ki̱xna̱ntoya mesa kijlij Jesús: —Pa̱ktoꞌ yej takua ipan ilwiꞌ yej kichi̱wiliáj ino̱mej yej mote̱makaj iga Dios marreina̱ro ipan yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iwá̱n Jesús kijlij: —Se̱ ve̱j se̱ ta̱gaꞌ kichij komati tákual, iwá̱n tati̱tan iga makino̱tzatij miaꞌ gente. ");
INSERT INTO nhx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Iwá̱n kua̱ꞌ takuáloya, kiti̱tan imo̱nsoj iga ijkí̱n makijlí̱tija: “Xiwi̱kíka̱nya, iga ónoꞌya nochi.” ");
INSERT INTO nhx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Eꞌ inochi pe̱wakej iga ijkí̱n kijtojkej; yej achto kijtoj: “Achi xine̱disculpa̱ro, nikówagoꞌ se̱ ta̱jli iwá̱n kipiá iga nia nikitati.” ");
INSERT INTO nhx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Seꞌ kijtoj: “Nikówagoꞌ cinco yunta iwá̱n nia nikitati ken tekipanowaj. Nimitztajtaniliá iga amo ximoyo̱lmikti iga awel ompa nonos.” ");
INSERT INTO nhx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Iwá̱n seꞌ kijtoj: “Nimona̱míktijoꞌ inó̱n iga awel nia̱ti.” ");
INSERT INTO nhx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Iwá̱n inó̱n mo̱nsoj yajki kipowili̱to ite̱ko inewi kensan kijlijkej. Iwá̱n te̱taj kuejkuesiwiꞌ, iwá̱n kijlij imo̱nsoj: “Xaj tajkoa̱ltepe̱ꞌ iwá̱n ipan ojtimej, iwá̱n xikijli iga mawi̱tzeka̱n yej ayá̱ꞌ motapialiáj, ma̱tepomej, ko̱xomej iwá̱n pachamej.” ");
INSERT INTO nhx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Má̱j má̱j mo̱nsoj kijtoj: “Note̱ko níkchija ken tine‑ijlij, iwá̱n kitolówa‑oꞌ má̱j ka̱n mota̱lilo.” ");
INSERT INTO nhx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Te̱taj kijlij imo̱nsoj: “Xaj ipan ca̱llejmej, ipan ojtimej iwá̱n xiktekiꞌyo̱lyamanaka̱n sekin iga makalakika̱n iga mate̱mi nókal. ");
INSERT INTO nhx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nimitzijliáj iga nisé̱ de ino̱mej yej achto nikijlijkaj, yawij takua̱tij.” ");
INSERT INTO nhx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Miaꞌ gente kitokaya Jesús, iwá̱n yéj mokuepaꞌ iga kijtoj: ");
INSERT INTO nhx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Siga agaj wi̱ꞌ iga ne̱toka, iwá̱n ayá̱ꞌ ne̱cho̱kiliá má̱j que itaj, má̱j que iye̱ꞌ, má̱j que isiwa̱ꞌ, má̱j que ipilowa̱n, iwá̱n má̱j que iyikni̱mej, iwá̱n mane̱toka, malej iga este makimikti̱ka̱n iga nej, inó̱n awel mochi̱wa nodiscí̱poloj. ");
INSERT INTO nhx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yej kinekis mane̱toka, eꞌ ayá̱ꞌ kikechpanowa icru̱z, awel mochi̱was nodiscí̱poloj. ");
INSERT INTO nhx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Siga se̱ de amejeme̱n kichi̱wasneki se̱ torre, ¿ix ayá̱ꞌ achto kitas ke̱ꞌ tomi̱n kiwi̱gas iga makita ken kiye̱kawi̱lti̱j? ");
INSERT INTO nhx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Siga san makipe̱walti iwá̱n awel makiye̱kawi̱lti, nochi yej kitas yawi kipi̱najti̱ti. ");
INSERT INTO nhx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Iwá̱n kijto̱skej: “Iní̱n ta̱gaꞌ san kipe̱waltij iwá̱n awel kiye̱kawi̱ltij.” ");
INSERT INTO nhx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kua̱ꞌ se̱ rey yawi momijmikti̱ti iwá̱n seꞌ rey, ¿ix ayá̱ꞌ achto kitas siga wel kita̱niliá siga kimatitoꞌ iga isolda̱dojmej onoꞌ diez mil, iwá̱n yej íwa̱n yawij momijmikti̱tij onokej veinte mil? ");
INSERT INTO nhx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Siga momachi̱liá iga yawi kipolo̱ti, kua̱ꞌ seꞌ rey maónooꞌ wejka, kitati̱tanili̱j iga amo mamomijmikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ijkó̱n nokta, a̱ꞌsan ne̱siꞌ de amejeme̱n yej ayá̱ꞌ makikajte̱wa inewi yej kipiá, awel mochi̱wa nodiscí̱poloj. ");
INSERT INTO nhx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesús no̱ kijtoj: —Istaꞌ pox ye̱kti; eꞌ siga ayꞌya istawe̱liꞌ, ¿kénoꞌ tawe̱lialti̱j? ");
INSERT INTO nhx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ayoꞌ ye̱kti iga nité̱, motajkáliya. Yej kipiá inakasmej, makikakika̱n. ");
INSERT INTO nhx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nochi yej kicobra̱rowa̱yaj impuestos iga Roma iwá̱n yej najna̱mo̱lnemiáj ya̱yaj iná̱ꞌ Jesús iga kikakitij. ");
INSERT INTO nhx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseojmej iwá̱n yej tamachtiáj ipan la ley, ijkí̱n kipo̱powa̱yaj Jesús: —Iní̱n ko̱mema̱wiá yej ayá̱ꞌ ye̱ꞌnemij, iwá̱n este íwa̱n sentakuaj. ");
INSERT INTO nhx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Iwá̱n Jesús kipowaꞌ se̱ ka̱n mami̱xkui̱tilo, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Siga se̱ de amejeme̱n makipiá cien borrego iwá̱n se̱ makipolo, ¿ix ayá̱ꞌ ómpaoꞌ kikajte̱was inó̱n noventa y nueve ipan sakayoj, iwá̱n ya̱j kite̱mo̱ti yej poliwiꞌ este ka̱n casis? ");
INSERT INTO nhx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iwá̱n kua̱ꞌ kásisya, pa̱kis iwá̱n kikechpáno̱jya iga kiwi̱gas. ");
INSERT INTO nhx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Iwá̱n kua̱ꞌ ásisya icha̱n, kinechko̱j iyami̱gojmej iwá̱n iveci̱nojmej, kijto̱j: “Matipa̱kika̱n, iga iná̱n nikásiꞌya noborre̱goj yej nikpolojka.” ");
INSERT INTO nhx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pues nej nimitzijliáj iga má̱j pa̱kilo̱j ipan cielo kua̱ꞌ se̱ yej kichi̱waya yej aye̱kti moyo̱lpata, que iga ino̱mej noventa y nueve yej ye̱ꞌnemij iga moyo̱lpatákeja. ");
INSERT INTO nhx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Siga se̱ siwa̱ꞌ makipiá diez tomi̱n iwá̱n se̱ makipolo, ¿ix ayá̱ꞌ kixo̱talti̱j tiꞌti iwá̱n tachpa̱nas kalijtiꞌ, iyo̱lpan kite̱mo̱j este ka̱n casis? ");
INSERT INTO nhx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Iwá̱n kua̱ꞌ kásisya, kinechko̱j iyami̱gajmej iwá̱n iveci̱najmej, kijli̱skej: “Matisempa̱kika̱n iga nikásiꞌya notomi̱n yej nikpolojka.” ");
INSERT INTO nhx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ijko̱nsan no̱ pa̱kij iya̱ngelejmej Dios kua̱ꞌ se̱ yej kichi̱waya yej aye̱kti moyo̱lpata. ");
INSERT INTO nhx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iwá̱n kijtoj no̱ Jesús: —Se̱ ta̱gaꞌ kipiaya o̱me ipilowa̱n, ");
INSERT INTO nhx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","iwá̱n yej te̱tzo̱yo̱ꞌ kijlij itaj: “Notaj, xine̱mákaya yej mochi̱was notatki.” Iwá̱n itaj kimáꞌ ke̱ꞌ kitoca̱rowaj sejsé̱. ");
INSERT INTO nhx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Iwá̱n ayá̱ꞌ wejkatiꞌ, yej te̱tzo̱yo̱ꞌ kinamáꞌ inewi yej kimakakaj, iwá̱n yajki wejka ipan seꞌya estado. Iwá̱n ompiga kitolo̱to itomi̱n iga ayá̱ꞌ ye̱ꞌnemiá. ");
INSERT INTO nhx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eꞌ kua̱ꞌ motatámija, íkua̱ꞌsan no̱ pox a̱pistajtiáꞌ ipan inó̱n estado iwá̱n pe̱waꞌ iga maya̱na. ");
INSERT INTO nhx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Iwá̱n yajki cha̱n se̱ ta̱gaꞌ yej de ompa iga kitajtanili̱to tekipáno̱l, iwá̱n kiti̱tan rancho iga makicuida̱ro̱ti koyame̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Iwá̱n kinekiá maguiꞌ makíkuaya algarroba yej itákualpa koyame̱mej, eꞌ ayagaj kimakaya. ");
INSERT INTO nhx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Iwá̱n ijkí̱n kijtoj ipan iya̱lmaj: “¡Notaj kipiá miaꞌ itekipanowa̱nimej iwá̱n ompa icha̱n kipiáj komati tákual, eꞌ nej nigaj nemi nimaya̱nmiki! ");
INSERT INTO nhx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nej nia̱ti sej cha̱n notaj, iwá̱n kua̱ꞌ nasiti nikijli̱j: Notaj, nikchij yej aye̱kti iyi̱xtaj Dios iwá̱n no̱ nimitzchi̱wilij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ayoꞌ kajasi iga xine‑ita ken mopiltzi̱n; eꞌ acho̱ꞌ xineo̱mema̱wi malej kenya se̱ motekipanowa̱ni.” ");
INSERT INTO nhx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Má̱j má̱j ojkuiꞌ iga yajki cha̱n itaj. ’Iwá̱n kua̱ꞌ asitia̱yay, te̱taj wéjkasan kitaꞌ ipiltzi̱n iwá̱n kikne̱lij. Iwá̱n motalojtiajki, ki̱xna̱mikito, kikechna̱paloj iwá̱n este kipipitzoj. ");
INSERT INTO nhx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iwá̱n te̱piltzi̱n kijlij itaj: “Notaj, nikchij yej aye̱kti iyi̱xtaj Dios iwá̱n no̱ nimitzchi̱wilij yej aye̱kti, iwá̱n ayoꞌ kajasi iga xine‑ita ken mopiltzi̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Eꞌ itaj ijkí̱n kitekimáꞌ itekipanowa̱nimej: “Xikuajliguili̱ka̱n yej má̱j ye̱ꞌtzótzol iwá̱n xiktaajaki̱lti̱ka̱n; iwá̱n xikta̱lili̱ka̱n se̱ anillo ipan imájpil iwá̱n xikaki̱lti̱ka̱n igaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Iwá̱n xikuitij to̱rojtzi̱n yej má̱j tomaktiꞌ, iwá̱n xikmiktí̱ka̱nya iga matitakua̱ka̱n iga tiawij tikilwichi̱wili̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Iga iní̱n nopiltzi̱n, ken kua̱ꞌ miktoyay, iwá̱n iná̱n sej isaꞌ. Poliwíkaya, iwá̱n iná̱n sej wa̱laj.” Iwá̱n pe̱wakej iga kilwichi̱wilijkej. ");
INSERT INTO nhx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Eꞌ inó̱n sewoꞌ te̱piltzi̱n yej má̱j te̱ko̱ko, ayá̱ꞌ onoya, nemiá ipan kuayoj. Iwá̱n kua̱ꞌ asitiwi̱tziaya icha̱n, kikaguiꞌ iga nentoꞌ ilwiꞌ iwá̱n nemi mijto̱tilo. ");
INSERT INTO nhx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kua̱ꞌ inó̱n kikaguiꞌ, kino̱tzaꞌ se̱ chokotzi̱n, kijlij: “¿Té̱taj mochi̱wa?” ");
INSERT INTO nhx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Iwá̱n kijlij: “Asiꞌ sej mokni̱n yej yájkaya. Iwá̱n motaj tatekimáꞌ iga mamomikti se̱ to̱rojtzi̱n yej má̱j tomaktiꞌ, iga ye̱ꞌasiꞌ sej ipiltzi̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Iwá̱n poxsan kuesiwiꞌ iyikni̱n yej má̱j te̱ko̱ko, iwá̱n ayoꞌ kinekiá makalaki kalijtiꞌ. Má̱j má̱j ki̱saꞌ itaj, iwá̱n kijli̱to iga makalaki. ");
INSERT INTO nhx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Te̱piltzi̱n yej te̱ko̱ko kijtoj: “Nej ikyay nimitzpale̱wijtoꞌ, iwá̱n nochipa nikchi̱wa ken tine‑ijliá. Iwá̱n ayí̱ꞌ tine̱maka nisé̱ chi̱vojtzi̱n iga mani‑ilwichi̱waka̱n iwá̱n noami̱gojwa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Eꞌ iná̱n asiꞌ iní̱n mopiltzi̱n yej nemito̱yay iwá̱n siwa̱tkej, yej kitoloj inewi yej tikmakaka, iwá̱n iná̱n tikmiktilij se̱ to̱rojtzi̱n yej má̱j tomaktiꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Itaj kijtoj: “Taꞌ xine̱kaki nopiltzi̱n, tej nochipa tonoꞌ note̱noj, iwá̱n inewi yej nej nikpiá, tej motatki. ");
INSERT INTO nhx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Eꞌ iná̱n ye̱kti iga mati‑ilwichi̱waka̱n iwá̱n matipa̱kika̱n iga mokni̱n ken kua̱ꞌ mikikay, iwá̱n sej isaꞌ. Poliwíkaya, iwá̱n iná̱n sej wa̱laj.” ");
INSERT INTO nhx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús no̱ kipowilij idisci̱polojmej: —Onoya se̱ ta̱gaꞌ yej poxsan motapialia̱ya, kipiaya no̱ se̱ iyencarga̱doj, iwá̱n inó̱n iyencarga̱doj yajkij kite̱lwi̱toj iná̱ꞌ ipatró̱n iga nemi kimalgasta̱rowiliá itomi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iwá̱n ipatró̱n kino̱tzaꞌ, kijlij: “¿Té̱ iteki in yej ne‑ijliáj iga tej? Xine̱mati̱lti de inochi motekipáno̱l yej tikchij iga ayꞌya má̱j tonos iga tino‑encarga̱doj.” ");
INSERT INTO nhx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Iwá̱n inó̱n encargado kijtoj ipan iya̱lmaj: “¿Té̱ nikchi̱was?, nopatró̱n némiya ne̱ki̱xtiá iga nej iyencarga̱doj ipan itekipáno̱l. Ayá̱ꞌ wel niktekipanowa ta̱jli, iwá̱n nipi̱ná̱ iga maniktajtantinemi tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nikmátiya te̱ nia nikchi̱wati, iga manikpiá a̱ꞌyéj maneo̱mema̱wi̱ka̱n ipan icha̱mej kua̱ꞌ ayꞌya nikpiás tekipáno̱l.” ");
INSERT INTO nhx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Iwá̱n kino̱tzaꞌ sejsé̱ sejsé̱ yej kidebe̱rowa̱yaj ipatró̱n. Yej áchtosan kitajtan, kijlij: “¿Ké̱ꞌ tikdebe̱rowa nopatró̱n?” ");
INSERT INTO nhx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Iwá̱n yéj kijtoj: “Nikdebe̱rowa cuatro mil litros de aceite.” Inó̱n yej encargado kijlij: “Xikui morreci̱boj iwá̱n nimaní̱n xikijkuilo iga dos mil litros tikdebe̱rowa.” ");
INSERT INTO nhx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Iwá̱n kitajtan sewoꞌ: “In tej, ¿ké̱ꞌ tikdebe̱rowa?” Iwá̱n kijlij: “Cien koyaꞌkóxta̱l de harina.” Iwá̱n el encargado kijlij: “Xikui morreci̱boj iwá̱n nimaní̱n xikijkuilo iga ochéntajsan tikdebe̱rowa.” ");
INSERT INTO nhx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Malej iga el encargado takajkayaj, ipatró̱n kiye̱ꞌitaꞌ ken kichij iga kimati kén iga wel mopale̱wiá. Wa̱n kijtoj sej Jesús: —Yej ayá̱ꞌ ki̱xmatij toTe̱ko, má̱j kimatij ken iga mopale̱wiáj que yej ki̱xmatij toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nej nimitzno̱no̱tzaj iga amotomi̱n yej de iní̱n ta̱jli, xikuika̱n iga xikpale̱wi̱ka̱n tokni̱mej, iga ijkó̱n kua̱ꞌ anmikiskej, támisya tomi̱n iga amejeme̱n, iwá̱n onos yej mitzo̱mema̱wi̱skej ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Yej ye̱ꞌnemi kua̱ꞌ kipiá alí̱n, no̱ ye̱ꞌnemis kua̱ꞌ kipiás komati; yej takajkaya̱wa kua̱ꞌ kipiá alí̱n, no̱ takajkaya̱was kua̱ꞌ kipiás komati. ");
INSERT INTO nhx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Siga ayá̱ꞌ ankichi̱waj yej ye̱kti wa̱n tomi̱n yej onoꞌ ipan iní̱n ta̱jli, ayagaj wel mitzmakaskej yej má̱j vale̱rowa ipan cielo ");
INSERT INTO nhx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Siga ipan yej ayéj amotatki ayá̱ꞌ ankichi̱waj yej ye̱kti, ayagaj wel mitzmakaj tejté̱ iga amotatki. ");
INSERT INTO nhx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Ayagaj wel kipiá o̱me ipatró̱n, iga sé̱sanwaꞌ in yej kiye̱ꞌitas, iwá̱n seꞌ kijiyas, o se̱ kitokas iwá̱n seꞌ kikajte̱was. Inó̱n iga awel ankitokaj Dios siga mitzyo̱ltila̱naj tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseojmej yej poxsan kipiasnekij tomi̱n kikaktoyaj inewi ini̱mej tájto̱l, iwá̱n kipi̱najtia̱yaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Iwá̱n Jesús kijlij fariseojmej: —Amejéme̱nya nokta yej ankijtowaj iyi̱xtaj tokni̱mej iga anye̱ꞌnemij, eꞌ Dios ki̱xmati amoa̱lmajmej; yej tajta̱gaꞌ kipoxye̱ꞌitaj, Dios ayá̱ꞌ kiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Este kua̱ꞌ onóyaoꞌ Juan yej tabautiza̱rowa, inó̱n ve̱j onóyaoꞌ iley Moisés iwá̱n yej tane̱xtilijkej profe̱tajmej. Iná̱n mopowa ye̱ꞌnoti̱ciaj kén iga reina̱rowa Dios, iwá̱n miaꞌ kalakisnekij. ");
INSERT INTO nhx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Má̱j fácil iga cielo iwá̱n ta̱jli mapoliwi, que iga amo mamocumpli̱ro inochi iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Nochi ta̱gaꞌ yej kiyokaka̱wa isiwa̱ꞌ iwá̱n mona̱miktiá wa̱n seꞌ siwa̱ꞌ, kichi̱wa yej aye̱kti; iwá̱n yej mona̱miktiá iwá̱n siwa̱ꞌ yej kikajtoꞌ iwe̱wej, no̱ kichi̱wa yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Onoya se̱ ta̱gaꞌ yej poxsan motapialia̱ya, kakia̱ya yejsan ye̱ꞌtzótzol yej mo̱nsajtiꞌ iwá̱n nochipa kichi̱waya weyi‑ilwiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Onoya no̱ se̱ ta̱gaꞌ yej ayá̱ꞌ motapialia̱ya, ito̱ka̱ꞌ Lázaro, yej pala̱ntoya ikajlo̱ꞌ ino̱ya̱n, iwá̱n mota̱lia̱ya ta̱lpan ipan ikalte̱n inó̱n yej motapialia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Iwá̱n kinekiá makikua ipotzkilka tákual yej xijxi̱ni ipan ime̱saj inó̱n yej motapialia̱ya; iwá̱n pe̱lomej kina̱ꞌtechowa̱yaj iga kipajpalowili̱tij ikajlo̱ꞌ ka̱n pala̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Eꞌ se̱ día miguiꞌ yej ayá̱ꞌ motapialia̱ya, iwá̱n a̱ngelejmej kiwi̱gakej ipan cielo ite̱noj Abraham. Iwá̱n yej motapialia̱ya no̱ miguiꞌ iwá̱n kito̱kkej. ");
INSERT INTO nhx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Inó̱n yej motapialia̱ya kikno̱chijtoyaj ipan tiꞌti yej ayí̱ꞌ se̱wis, wéjkasan kitaꞌ Abraham, iwá̱n Lázaro ite̱noj. ");
INSERT INTO nhx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Iwá̱n tzajtziꞌ: “Notaj Abraham, xine‑ikne̱li, xikti̱tani Lázaro iga maka̱pacho imajpilpu̱ntaj ipan a̱ꞌti, iwá̱n mawi̱ki makisese̱li̱ki nole̱nguaj iga nemi ne‑ikno̱chi̱wa poxsan iní̱n tiwelo̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Eꞌ Abraham kijtoj: “Nopiltzi̱n, xikejla̱miki iga tej kua̱ꞌ tisatoya, timotapialia̱ya, Lázaro poxsan mo‑ikno̱chij. Iná̱n yéj yo̱lpa̱ktoꞌ nigaj, iwá̱n tej iná̱n timokno̱chi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Iwá̱n awel nokta se̱ yawi ompígapa, iga onoꞌ se̱ a̱xapowe̱wej yej te̱yokatiá iga amo matimona̱ꞌtecho̱ka̱n, inó̱n iga yej kineki mayawi ompí, ayá̱ꞌ wel, niga yej de ompí awel wi̱tzej nijiga.” ");
INSERT INTO nhx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Iwá̱n yej motapialia̱ya kijtoj: “Nimitzijliá, notaj Abraham iga xikti̱tani Lázaro cha̱n notaj, ");
INSERT INTO nhx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","iga nikpiá cinco nokni̱wa̱n, iga makita̱tapo̱wi̱tij iga amo mawi̱tzeka̱n nigaj ka̱n mokno̱chi̱walo.” ");
INSERT INTO nhx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Eꞌ Abraham kijlij: “Ompiga onoꞌ yej kijkuiloj Moisés iwá̱n profe̱tajmej, ¡inó̱n makikakika̱n!” ");
INSERT INTO nhx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yej motapialia̱ya kijtoj: “Kena notaj Abraham, eꞌ siga agaj de ini̱mej yej miktókeja mayawi, kipataskej kén iga nemij.” ");
INSERT INTO nhx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Eꞌ Abraham kijlij: “Siga ayá̱ꞌ kicre̱dowaj yej Moisés iwá̱n profe̱tajmej kijkuilojkej, ayá̱ꞌ no̱ kitajto̱lkuiskej se̱ yej miktoꞌ malej iga maojpa‑isa.” ");
INSERT INTO nhx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús kijlij idisci̱polojmej: —Nochipa onos yej kiyo̱ltila̱na se̱ iga makichi̱wa yej aye̱kti; eꞌ ¡poxsan kikno̱chi̱waskej yej matachi̱walti yej aye̱kti! ");
INSERT INTO nhx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Má̱j ye̱kti katka makimo̱taka̱n láma̱rko wa̱n se̱ weyiteꞌti makilpili̱ka̱n ipan ikech, que iga yéj itechko se̱ de ini̱mej yej ne̱tokaj makichi̱walti yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ximocuida̱ro̱ka̱n. ’Siga mokni̱n mitzchi̱wiliá yej aye̱kti, xikno̱no̱tza; siga moyo̱lpata, xike̱lka̱wili yej mitzchi̱wilij. ");
INSERT INTO nhx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Malej iga mitzchi̱wiliá yej aye̱kti siete ve̱j ipan se̱ día, iwá̱n siete ve̱j mamitzijli̱ki: “Ayꞌ iná̱n nikchi̱was ijkó̱n.” Xike̱lka̱wili yej mitzchi̱wilij. ");
INSERT INTO nhx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Itati̱tanimej kijlijkej toTe̱ko: —Xine̱pale̱wi̱ka̱n iga má̱j manimoconfia̱ro̱ka̱n pan tej. ");
INSERT INTO nhx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iwá̱n toTe̱ko kijtoj: —Siga anmoconfia̱rowaj malej alí̱n ke̱ꞌ se̱ íyo̱l ajonjoli̱n, wel ankijlia̱yaj kuawe̱wej: “Xiwiwita nigaj iwá̱n xixwati ipan láma̱r”, iwá̱n inó̱n kuawiꞌ mitztajto̱lkuiskej. ");
INSERT INTO nhx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Siga se̱ de amejeme̱n kipiá se̱ esclavo iwá̱n kua̱ꞌ ásigoꞌ iga yajka mi̱lpan, iga támiꞌya ara̱dojtoya o kicuida̱rojtoya gana̱dojmej, ¿ix tikijli̱j: “Ximopano̱lti iwá̱n ximota̱li iga xitakua”? ");
INSERT INTO nhx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ayá̱ꞌ, ma̱jwaꞌ tikijliá: “Xikta̱li momándi̱l wa̱n xine̱chi̱wili iga manitakua iwá̱n mana̱ti. Iwá̱n tej sej titakua̱j iwá̱n ta̱tis.” ");
INSERT INTO nhx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Anka ayá̱ꞌ tikijli̱j: “Gracias”, iga moescla̱voj kichij ken tiktekimáꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ijkó̱n no̱ amejeme̱n, kua̱ꞌ ankitami̱skej iga ankichi̱waj inewi yej Dios mitztekimakaj, xikijto̱ka̱n: “Ni‑escla̱vojmej yej awel má̱j te̱ nikchi̱waj, iga nikchijkej yejsan ne̱tekimakakej.” ");
INSERT INTO nhx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kua̱ꞌ Jesús nemi yawi Jerusalén, pano̱tiajki ka̱n mi̱xna̱ntoꞌ ita̱lmej Samaria iwá̱n Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Kua̱ꞌsan asiꞌ ipan se̱ a̱ltepe̱tzi̱n, mi̱xna̱n iwá̱n diez tajta̱gaꞌ yej pala̱ntokej ikajlo̱mej iga kipiayaj lepra, eꞌ mokejketzkej wéjkasan de ka̱n onoya Jesús ");
INSERT INTO nhx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","iwá̱n tzajtzikej: —¡Jesús, Tamachtia̱ni, achi xine‑ikne̱li̱ka̱n! ");
INSERT INTO nhx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Kua̱ꞌ Jesús kitaꞌ, kijlijkej: —Xa̱ka̱n iná̱ꞌ sacerdo̱tejmej. Mie̱j nemi ya̱yaj, achitiakej. ");
INSERT INTO nhx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Iwá̱n se̱ de yejeme̱n, kua̱ꞌ mo‑itaꞌ iga achitiaꞌya, mokuepaꞌ, este tzájtziꞌpa iga kiweyimati̱ltijtiwa̱laj Dios. ");
INSERT INTO nhx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Motankua̱ketzaꞌ iyi̱xtaj Jesús, motzonto̱gaꞌ este ipan ta̱jli, iga kimáꞌ gracias. Iní̱n ta̱gaꞌ katka de Samaria. ");
INSERT INTO nhx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iwá̱n Jesús kijtoj: —¿Ix aya̱ꞌtaj die̱jmej yej pajtikej? ¿Ka̱n onokej ino̱mej sewoꞌ nueve? ");
INSERT INTO nhx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ix ini̱nsan ise̱lti yej ayéj israelita mokuepaꞌ iga kiweyimati̱lti̱ko Dios? ");
INSERT INTO nhx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iwá̱n kijlij ta̱gaꞌ: —Ximoketza iwá̱n xaja; tiye̱ktiaꞌya iga timoconfia̱roj ipan Dios. ");
INSERT INTO nhx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseojmej kitajtankej Jesús iga ké̱man pe̱was iga reina̱ro̱j Dios. Iwá̱n yéj kijtoj: —Kua̱ꞌ pe̱was iga reina̱rowa Dios, ayéj ken tejté̱ yej mo‑ítapa. ");
INSERT INTO nhx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ayá̱ꞌ yawi mo‑ijtoti: “Nigaj onoꞌ”, o “Ompa onoꞌ”; iga Dios reina̱rówaya ipan amoa̱lmajmej. ");
INSERT INTO nhx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iwá̱n Jesús kijlij idisci̱polojmej: —Wi̱ꞌoꞌ kua̱ꞌ ankinekiskej xonoka̱n wa̱n nej yej iPiltzi̱n Ta̱gaꞌ, eꞌ ayá̱ꞌ anne‑itaskej. ");
INSERT INTO nhx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sekin mitzijli̱skej: “Nigaj onoꞌ”, o “Ompa onoꞌ.” Eꞌ amo xa̱ka̱n iwá̱n niga xiktokaka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Iga ijkó̱n ken kua̱ꞌ mo‑ita iga tapeta̱ni iwá̱n kita̱wiá no̱ya̱n cielo, ijkó̱n kua̱ꞌ nia niwi̱tzeti, nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Eꞌ achto yawij ne‑ikno̱chi̱watij poxsan, iwá̱n yej iná̱n onokej ayá̱ꞌ ne̱tajto̱lkuiskej. ");
INSERT INTO nhx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Ken mochij kua̱ꞌ onoya Noé, ijko̱nsan no̱ mochi̱was inó̱n día kua̱ꞌ nimokuepas nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nemi takualowa̱ya iwá̱n nemi a̱tilowa̱ya, mona̱miktia̱yaj iwá̱n kina̱miktia̱yaj isiwa̱pilowa̱n, este ipan inó̱n día kua̱ꞌ Noé kalaꞌ ipan weyi á̱ka̱l. Iwá̱n wa̱laj pox recio tiawa̱ꞌ iwá̱n inochi̱n a̱mikikej. ");
INSERT INTO nhx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ijko̱nsan no̱ mochij kua̱ꞌ onóyaoꞌ Lot: nemi takualowa̱ya iwá̱n nemi a̱tilowa̱ya, takowayaj iwá̱n tanamakayaj, to̱kayaj iwá̱n mokaltia̱yaj; ");
INSERT INTO nhx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","eꞌ kua̱ꞌ Lot ki̱saꞌ ipan a̱ltepe̱ꞌ Sodoma, wetziꞌ tiꞌti iwá̱n azufre yej wa̱laj ipan cielo, iwá̱n kimiktij nochi. ");
INSERT INTO nhx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ijkó̱n yawi mochi̱wati kua̱ꞌ nej yej iPiltzi̱n Ta̱gaꞌ niwi̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Íkua̱ꞌ, siga agaj onos iyi̱xko kajli ipan ipetayo, ayꞌya matemo iga matakijki̱xti; siga agaj onos imi̱lpan, ayꞌya mamokuepa icha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xikejla̱mikíka̱nsan yej isíwa̱ꞌpa Lot. ");
INSERT INTO nhx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Yej ayá̱ꞌ kinekis mamiki iga ne̱toka, yawi mopojpolo̱ti; eꞌ yej mikis iga ne̱toka, nochipa onos nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Nimitzijliáj iga ipan inó̱n yówal kua̱ꞌ niwi̱ꞌ, o̱me̱n senkochtoskej; se̱ kiwi̱gaskej, iwá̱n seꞌ kikajte̱waskej. ");
INSERT INTO nhx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O̱me̱n siwa̱tkej tapaya̱ntoskej; se̱ kiwi̱gaskej, iwá̱n seꞌ kikajte̱waskej. ");
INSERT INTO nhx_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","O̱me ta̱gaꞌ sen‑onoskej mi̱lpan; se̱ kiwi̱gaskej, iwá̱n seꞌ kikajte̱waskej. ");
INSERT INTO nhx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kua̱ꞌ kikakikej iní̱n, kitajtankej: —¿NoTe̱ko in inó̱n ka̱n mochi̱was? Iwá̱n Jesús kijtoj: —Ka̱n onos yej miktoꞌ, ompa monechko̱skej mo̱ximej. ");
INSERT INTO nhx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús kipowilij idisci̱polojmej ka̱n mami̱xkui̱ti̱ka̱n, kine̱xtilijkej iga nochipa makite̱ne̱wi̱ka̱n Dios iwá̱n amo mamosemakaka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kijtoj: —Ipan se̱ a̱ltepe̱ꞌ onoya se̱ juez yej ayá̱ꞌ kimajmawilia̱ya Dios niga kitajto̱lkuiá agaj. ");
INSERT INTO nhx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ipan ino̱nsan a̱ltepe̱ꞌ onoya no̱ se̱ siwa̱ꞌ yej miꞌ iwé̱j, tekiya̱ya kitati el juez iwá̱n kijlia̱ya: “Xine̱pale̱wi iga manikta̱nili yej ne‑ijiya.” ");
INSERT INTO nhx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Á̱wil wéjkaja iwá̱n el juez ayá̱ꞌ nemi kichi̱wa nité̱, eꞌ má̱j, má̱j, kijtoj: “Malej iga ayá̱ꞌ nikmajmawiliá Dios niga niktajto̱lkui̱liá agaj, ");
INSERT INTO nhx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","eꞌ iní̱n yej we̱wejmíꞌ, ne̱kuejkuesojtinemi, nia nikma̱nawi̱ti iga ayoꞌ mawi̱wi̱ki, amo santá̱ꞌ ne̱melaꞌkuejkueso̱j.” ");
INSERT INTO nhx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Iwá̱n toTe̱ko kijtoj: —Inó̱n yej kijtoj juez yej ayá̱ꞌ ye̱ꞌnemi. ");
INSERT INTO nhx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿In Dios ix ayá̱ꞌ kima̱nawi̱j no̱ yej kitapejpen, yej tano̱tztokej nochipa?, in Dios, ¿ix wejka̱was iga kima̱nawi̱j? ");
INSERT INTO nhx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nimitzijliáj iga ayá̱ꞌ wejka̱was iga kima̱nawi̱skej. Eꞌ kua̱ꞌ nej yej iPiltzi̱n Ta̱gaꞌ niwi̱ꞌ, ¿ix nikasíki‑oꞌ ipan iní̱n ta̱jli yej moconfia̱rowaj ipan nej? ");
INSERT INTO nhx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús kipowaꞌ iní̱n seꞌ ka̱n mi̱xkui̱tilo iga ino̱mej yej momachi̱liáj iga ye̱ꞌnemij, malej iga ta‑ijiyaj: ");
INSERT INTO nhx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—O̱me ta̱gaꞌ yajkij tio̱pan ora̱do̱toj, se̱ fariseo katka iwá̱n sewoꞌ inó̱n yej kicobra̱rowa̱ya impuestos iga Roma. ");
INSERT INTO nhx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo ejkati‑o̱ra̱doj, kijliá Dios: “Tej tinoTaj, nimitzmaka gracias iga nej ayéj ken sekin, tachtekij, ayá̱ꞌ ye̱ꞌnemij, iwá̱n yawij iwá̱n siwa̱tkej. Nej ayéj ken iní̱n yej kicobra̱rowa impuestos iga Roma. ");
INSERT INTO nhx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nej nimayuna̱rowa o̱me ve̱j ipan semana iwá̱n nimitzmaka diez ipan cada cien inewi yej nikta̱niá.” ");
INSERT INTO nhx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Yej kicobra̱rowa̱ya impuestos iga Roma ka̱wiꞌ este ken nepa iwá̱n ayá̱ꞌ mi̱xe̱wia̱ya iga ajkotachaya, ma̱jwaꞌ moe̱lwi̱tekiá iwá̱n kijtowa̱ya: “¡Dios, xine‑ikne̱li iga nej nikchijtoꞌ yej aye̱kti!” ");
INSERT INTO nhx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Kijtoj no̱ Jesús: —Nimitzijliáj iga kua̱ꞌ iní̱n ta̱gaꞌ tamiꞌ ora̱doj, yajki icha̱n iwá̱n Dios kiye̱ꞌítaꞌya, eꞌ inó̱n fariseo Dios ayá̱ꞌ kiye̱ꞌitaꞌ. Yej moweyimati, yawij kali̱mpamatitij, eꞌ yej moali̱mpamati, yawij kiweyimatitij. ");
INSERT INTO nhx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Kiwi̱gayaj no̱ ko̱kone̱tzitzi̱n iná̱ꞌ Jesús, iga makitajtanili Dios iga maye̱ꞌonoka̱n; eꞌ kua̱ꞌ disci̱polojmej kitakej, pe̱wakej iga kajajwakej yej kiwi̱gayaj ko̱kone̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Iwá̱n Jesús kino̱tzkej iwá̱n kijtoj: —Xika̱waka̱n in ko̱kone̱ꞌ, ka̱ma mane̱techo̱ka̱n, amo xikojtzakuili̱ka̱n; iga yej mochi̱wawa ken ini̱mej ko̱kone̱ꞌ, kajasi iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nimitznojma‑ijliáj iga yej ayá̱ꞌ mote̱makas iga Dios makimanda̱ro ken se̱ yej aya yo̱lej, awel kalakis ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Se̱ yej manda̱rowa kitajtan Jesús: —Tamachtia̱ni yej tiye̱ꞌnemi, ¿té̱ nikchi̱was iga manono nochipa iwá̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús kijtoj: —¿Te iga tine‑ijliá iga niye̱ꞌnemi? Sé̱sanwaꞌ in yej kichi̱wa yej ye̱kti, ino̱nwaꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tikmátiya yej Dios tatekimaka iga mamochi̱wa: “Yej na̱miktitoꞌ amo mayawi wa̱n seꞌ, amo xitamikti, amo xitachteki, amo xitakajkaya̱wa, xikye̱ꞌita motaj iwá̱n moye̱ꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ta̱gaꞌ kijlij: —Inó̱n nochipa nikchijtoꞌ desde ga aya niyo̱lej. ");
INSERT INTO nhx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Kua̱ꞌ inó̱n kikáꞌ Jesús, kijtoj: —Mitzpolówaoꞌ se̱san: xiknamaka inewi yej tikpiá iwá̱n xikmaka yej ayá̱ꞌ motapialiáj, iwá̱n ijkó̱n tikpiás yej Dios má̱j kiye̱ꞌita; iwá̱n xiwi̱ki iga xine̱toka. ");
INSERT INTO nhx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eꞌ kua̱ꞌ ta̱gaꞌ kikáꞌ iní̱n, mokno̱matiꞌ iga poxsan kipiaya tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kua̱ꞌ kitaꞌ iga mokno̱matiꞌ, kijtoj Jesús: —¡Pox difícil iga yej motapialiáj mamote̱makaka̱n iga Dios marreina̱ro ipan yejeme̱n! ");
INSERT INTO nhx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Má̱j wel panowa se̱ camello ipan ixapoyo a̱ko̱xaj que se̱ yej motapialiá mamote̱maka iga Dios marreina̱ro ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Yej kikakikej, tatajtankej: —Iwá̱n, ¿a̱ꞌtaj wel moma̱nawi̱j? ");
INSERT INTO nhx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús kijtoj: —Yej awel kichi̱wa tajta̱gaꞌ, Dios wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pedro kijlij: —NoTe̱ko, nejemej nikajtejkej inewi yej notatkímejpa iga nimitztokákeja. ");
INSERT INTO nhx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yéj kijtoj: —Nimitznojma‑ijliáj siga agaj iga san kineki iga Dios marreina̱ro ipan yéj, kikajte̱wa íkal, o kikajte̱wa isiwa̱ꞌ, o iyikni̱wa̱n, o itaj iwá̱n iye̱ꞌ o ipilowa̱n, ");
INSERT INTO nhx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","inó̱n yawi kipiati yej ye̱kti ipan iní̱n ta̱jli, iwá̱n ipan seꞌ vida nochipa onos iwá̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús kino̱tzaꞌ iyokamej doce idisci̱polojmej iwá̱n kijlijkej: —Nimitzijliáj iga matia̱ka̱n Jerusalén, iwá̱n yáwiya mochi̱wati inewi yej kijkuilojkej profe̱tajmej iga nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Puej yawij ne̱ti̱tanitij ite̱nojmej yej ayéj de Israel, iwá̱n yawij ne̱pi̱najti̱tij, iwá̱n kuajkuantas yej aye̱kti ne‑ijli̱skej, iwá̱n ne̱chijchaskej. ");
INSERT INTO nhx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ne̱magaskej iwá̱n yawij ne̱mikti̱tij; eꞌ ipan e̱yi día nia ni‑ojpa‑isati ka̱n nimiktos. ");
INSERT INTO nhx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yejeme̱n ayá̱ꞌ kentende̱rojkej yej kijtoj, iwá̱n aya wel kimatiáj te̱ kijto̱jneki itájto̱l, iwá̱n ayá̱ꞌ kentende̱rowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kua̱ꞌ Jesús asitiájkiya a̱ltepe̱te̱noj Jericó, se̱ pacha e̱watoya ojte̱noj kitajtantoya tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kua̱ꞌ kikáꞌ iga poxsan nemi pano̱lo, tatajtan té̱ mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kijlijkej iga Jesús de Nazaret nemi panowa ompa. ");
INSERT INTO nhx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Iwá̱n tzajtziꞌ, kijtoj: —¡Jesús, iPiltzi̱n David, achi xine‑ikne̱li! ");
INSERT INTO nhx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Iwá̱n yej tayaka̱ntia̱yaj, kajajwayaj yej pacha iga ayꞌya matzajtzito, eꞌ yéj tzajtziꞌ má̱j: —¡IPiltzi̱n David, áchikej xine‑ikne̱li! ");
INSERT INTO nhx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús moketzaꞌ iwá̱n tati̱tan iga makiwajliguili̱ka̱n. Kua̱ꞌ ina̱ꞌya onoya, Jesús kitajtan: ");
INSERT INTO nhx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Té̱ tikneki manimitzchi̱wili? Pacha kijtoj: —NoTe̱ko, nikneki manitachá. ");
INSERT INTO nhx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús kijlij: —¡Xitachaya! Iga timoconfia̱roj ipan nej, ti‑achitiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Íkua̱ꞌsan tacháꞌ in pacha iwá̱n kitógaꞌya Jesús, iwá̱n kiweyimati̱ltijtiajki Dios. Nochi kitaꞌ iní̱n iwá̱n no̱ kiweyimati̱ltijkej Dios. ");
INSERT INTO nhx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús kalaꞌ ipan a̱ltepe̱ꞌ Jericó iwá̱n pano̱tia̱ya ompa. ");
INSERT INTO nhx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Cha̱ntitoya ompa se̱ ri̱cojta̱gaꞌ ito̱ka̱ꞌ Zaqueo. Zaqueo ije̱fejmej katka yej kicobra̱rowa̱ya impuestos iga Roma. ");
INSERT INTO nhx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yéj kinekiá maki̱xmati Jesús, eꞌ ayá̱ꞌ ki̱xasiá iga pox onolo̱ꞌ iwá̱n Zaqueo chapatiꞌ katka. ");
INSERT INTO nhx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iwá̱n motalojtiajki iga tayaka̱n, tejkawito ipan a̱makuawiꞌ iga makita, iga Jesús ompa yawi pano̱ti. ");
INSERT INTO nhx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kua̱ꞌ Jesús asiꞌ ompa, ajkotacháꞌ, iwá̱n kijlij: —Zaqueo, xitemo nimaní̱n iga a̱man nia nika̱witi mocha̱n. ");
INSERT INTO nhx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zaqueo temoj imaní̱n iwá̱n pa̱guiꞌ iga ko̱mema̱wij Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Kua̱ꞌ kitakej iní̱n, nochi pe̱wakej iga kipo̱powaj Jesús iga yajki ka̱wito cha̱n se̱ yej ayompa nemi. ");
INSERT INTO nhx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Iwá̱n Zaqueo moketzaꞌ, kijlij toTe̱ko: —Taꞌ xikita noTe̱ko, nia nikmakati la mitad notomi̱n yej amotapialiáj; iwá̱n siga agaj nikichtekilij tejté̱, nia nikuepili̱ti cuatro ve̱j má̱j. ");
INSERT INTO nhx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús kijlij: —A̱man Dios mitzma̱nawij tej wa̱n mofami̱liaj iga timoconfia̱roj pan yéj, kensan Abraham moconfia̱roj. ");
INSERT INTO nhx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nej yej iPiltzi̱n Ta̱gaꞌ, niwa̱laj nikte̱mo̱ko iwá̱n nikma̱nawi̱ko yej polijtokej. ");
INSERT INTO nhx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kua̱ꞌ kikakikej iní̱n, Jesús kipowaꞌ no̱ se̱ ka̱n mi̱xkui̱tilo, iga na̱ꞌya onoya ipan a̱ltepe̱ꞌ Jerusalén iwá̱n la gente kijtojkej iga ayá̱ꞌ wejkatis, wi̱ꞌya reina̱ro̱ki Dios. ");
INSERT INTO nhx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kijlijkej: —Onoya se̱ ta̱gaꞌ yej ye̱ꞌnemi iwá̱n yajki wejka ipan seꞌya país iga makita̱li̱ka̱n iga rey iwá̱n sej mokuepas. ");
INSERT INTO nhx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Kua̱ꞌ aya yawi, kino̱tzaꞌ diez itekipanowa̱nimej iwá̱n kimáꞌ komati tomi̱n sejsé̱ de yejeme̱n, kijlijkej: “Xiktekipano̱ka̱n iní̱n tomi̱n este que manimokuepa.” ");
INSERT INTO nhx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Eꞌ ipaisa̱nojmej kijiyayaj iwá̱n kiti̱tankej yej makijli̱tij: “Ayá̱ꞌ niknekij iga iní̱n ta̱gaꞌ mane̱manda̱ro̱ka̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Eꞌ ta̱gaꞌ kita̱lijkej iga rey, iwá̱n mokuepaꞌ ipan ipaí̱s. Kua̱ꞌ asiꞌ, tati̱tan iga makino̱tzatij tekipanowa̱nimej yej kimakakej tomi̱n, iga makimati ke̱ꞌ kita̱nkej sejsé̱ de yejemej. ");
INSERT INTO nhx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yej achto asiꞌ, kijlij: “Note̱ko, motomi̱n pi̱wiꞌ diez ve̱j má̱j.” ");
INSERT INTO nhx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","El rey kijtoj: “Ye̱ktia̱; tej tiye̱ꞌtekipanowa̱ni; iga tikchij yej ye̱kti ipan inó̱n alí̱n, nia nimitzta̱li̱ti iga xikmanda̱ro diez a̱ltepe̱ꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Iwá̱n asiꞌ seꞌ iwá̱n kijlij: “Note̱ko, motomi̱n pi̱wiꞌ cinco ve̱j má̱j.” ");
INSERT INTO nhx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Inó̱n no̱ kijlij: “Tej tia tikmanda̱ro̱ti cinco a̱ltepe̱ꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Eꞌ seꞌ asiꞌ iwá̱n kijtoj: “Note̱ko, nigaj onoꞌ motomi̱n. Niktzotzolkimilojtoya; ");
INSERT INTO nhx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","puej nimitzmajmawilij iga tiyo̱ltakuaktiꞌ, iga tikui yej aya̱ꞌpa tiktekipanoj iwá̱n titapixka ka̱n ayá̱ꞌ tito̱gaꞌ.” ");
INSERT INTO nhx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Iwá̱n kijlij el rey: “Tej ayéj tiye̱ꞌtekipanowa̱ni, iga yejsan kijtoj mote̱n, nia nimitzjuzga̱ro̱ti. Siga tikmatiá iga nej niyo̱ltakuaktiꞌ, nikui yej aya̱ꞌpa niktekipanoj iwá̱n nitapixka ka̱n ayá̱ꞌ nito̱gaꞌ, ");
INSERT INTO nhx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿te ígataj ayá̱ꞌ tika̱wato notomi̱n ipan banco, iga kua̱ꞌ nimokuepas nocha̱n, makita̱ni seꞌ alí̱n?” ");
INSERT INTO nhx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Iwá̱n rey kijlij yej ompa onoyaj: “Xikui̱li̱ka̱n inó̱n tomi̱n iwá̱n xikmakaka̱n yej kipi̱wi̱ltij diez ve̱j má̱j.” ");
INSERT INTO nhx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Yejemej kijlijkej: “Annote̱ko, ¡eꞌ yéj kipiáy diez ve̱j má̱j!” ");
INSERT INTO nhx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Yéj kijtoj: “Pues nimitzijliáj iga yej kipiá, yawij má̱j kimakatij; eꞌ yej ayá̱ꞌ kipiá, este yej alí̱n kipiá, yawij kikui̱li̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Iwá̱n yej ne‑ijiyaj, yej ayá̱ꞌ kinekiáj iga manikgoberna̱ro̱ka̱n, xikuajligaka̱n nigaj iwá̱n xikmikti̱ka̱n no‑i̱xtaj.” ");
INSERT INTO nhx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kua̱ꞌ Jesús tamiꞌ kijtoj iní̱n, ójkuiꞌya iga yajki Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kua̱ꞌ asitiá̱yaja a̱ltepe̱ꞌ Betfagé iwá̱n Betania, iná̱ꞌ tepe̱ꞌ yej ito̱ka̱ꞌ Olivos, kiti̱tan o̱me idisci̱polojmej, ");
INSERT INTO nhx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","kijtoj: —Xa̱ka̱n ipan a̱ltepe̱tzi̱n yej má̱j nijígasan onoꞌ, iwá̱n kua̱ꞌ an‑asiskej, anyawij ankasitij se̱ burro ilpitoꞌ, yej aya agaj kitejkawiliá. Xikxitomaka̱n iwá̱n xikuajligaka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Siga agaj mitztajtanij te íga ankixitomaj, xikijli̱ka̱n iga toTe̱ko kineki. ");
INSERT INTO nhx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Idisci̱polojmej yajkij iwá̱n kasitoj kenya nokta kijtoj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kua̱ꞌ nemi kixitomaj in burro, ite̱komej kitajtankej: —¿Te iga ankixitomaj? ");
INSERT INTO nhx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yejeme̱n kijlijkej: —Iga toTe̱ko kineki. ");
INSERT INTO nhx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Iwá̱n kiwi̱gakej ka̱n onoꞌ Jesús iwá̱n kipechtijkej burro iga yejemej itzotzolmej iwá̱n ompa kitejkawi̱ltijkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ken iga Jesús nemi ya̱ya, la gente kipata̱wilijtiajkij itzotzolmej ipan ojti. ");
INSERT INTO nhx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iwá̱n kua̱ꞌ asikej ka̱n pé̱waya iga temowaj ipan tepe̱ꞌ yej ito̱ka̱ꞌ Olivos, inewi idisci̱polojmej pe̱wakej iga ko̱yowilijkej iga pa̱kij iwá̱n kiweyimati̱ltijkej Dios iga nochi yej kichij yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Kijtowa̱yaj: —¡Mamoweyimati̱lti Rey yej kiti̱tani toTe̱ko Dios! ¡Matikweyimati̱lti̱ka̱n Dios iwá̱n matiye̱ꞌonoka̱n iyi̱xtaj! ");
INSERT INTO nhx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iwá̱n sekin fariseojmej yej onoyaj tatza̱la̱n, kijlijkej Jesús: —Tamachtia̱ni, xikijli modisci̱polojmej iga ayꞌya matzajtzitoka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Eꞌ Jesús kijtoj: —Nimitzijliáj siga ini̱mej ayꞌ tajtowaj, temej tzajtziskej. ");
INSERT INTO nhx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kua̱ꞌ Jesús asitiájkiya Jerusalén, iwá̱n kitaꞌ inó̱n a̱ltepe̱ꞌ, cho̱gaꞌ, ");
INSERT INTO nhx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","kijtoj: —¡Siga ankimatiáj iga a̱man wel anye̱ꞌonoskej iyi̱xtaj Dios, anye̱ꞌonóyaja! Eꞌ iná̱n inó̱n i̱ya̱ntoꞌ, awel ankitaj. ");
INSERT INTO nhx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wi̱ꞌ día kua̱ꞌ yej mitzijiyaj no̱ya̱n mitzyawalo̱skej, nijnijí mitztzakuili̱skej ");
INSERT INTO nhx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","iwá̱n mitzxiti̱nili̱skej amokalmej. Mitzmijmikti̱skej iwá̱n ayá̱ꞌ ka̱wis nisé̱ teꞌti yej mane̱nekpanijto; iga ayá̱ꞌ ankiye̱ꞌitakej kua̱ꞌ Dios wa̱laj mitzma̱nawi̱koj. ");
INSERT INTO nhx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Iwá̱n Jesús kalaꞌ ipan ipa̱tiojyo weyitio̱pan iwá̱n pe̱waꞌ kikijki̱xtij yej ompa tanamakatoyaj iwá̱n yej ompa takojtoyaj, ");
INSERT INTO nhx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","iwá̱n kijtoj: —Ipan itájto̱l toTe̱ko ijkuilijtoꞌ: “Nókal yawi moto̱ka̱wi̱ti kajli ka̱n ora̱do̱lo”; eꞌ amejeme̱n ankikueptokej ka̱n mi̱ya̱naj yej tachtekij. ");
INSERT INTO nhx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iwá̱n nochipa Jesús tamachtia̱ya ipan weyitio̱pan. Eꞌ ije̱fejmej sacerdo̱tejmej, iwá̱n yej tamachtiáj ipan iley Moisés iwá̱n yej manda̱rowaj kite̱mowa̱yaj kén iga makimikti̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Eꞌ ayá̱ꞌ kasiáj ken kichi̱wayaj, iga inochi̱n kikakisnekiáj yej Jesús kijtojtoya. ");
INSERT INTO nhx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se̱ día kua̱ꞌ Jesús tamachtijtoya ipan weyitio̱pan wa̱n kipojtoya ye̱ꞌnoti̱ciaj, asikoj ije̱fejmej sacerdo̱tejmej, yej tamachtiáj ipan la ley iwá̱n yej kimanda̱rowaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Iwá̱n kijlijkej: —Xine‑ijli̱ka̱n té̱ moteki in tej iga tikchi̱wa ijkí̱n. ¿A̱ꞌ mitztekimáꞌ iga wel xikchi̱wa iní̱n? ");
INSERT INTO nhx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iwá̱n Jesús kijtoj: —Nej no̱ nia nimitztajtanitij. Xine‑ijli̱ka̱n: ");
INSERT INTO nhx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿a̱ꞌyéj kiti̱tan Juan iga matabautiza̱ro?, ¿ix Dios kiti̱tan, o tajta̱gaꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Iwá̱n pe̱wakej iga mosepantajtanij: —Siga tikijliáj iga Dios kiti̱tan, yawi kijto̱ti. “¿Te ígataj ayá̱ꞌ ankitajto̱lkakikej?” ");
INSERT INTO nhx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Iwá̱n awel tikijtowaj iga kiti̱tan tajta̱gaꞌ iga tokni̱mej wel te̱temiktiáj, iga nochi kimatij iga Juan Dios kitajto̱lmakaya. ");
INSERT INTO nhx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Iwá̱n kijtojkej iga ayá̱ꞌ kimatij a̱ꞌyéj kiti̱tan Juan iga matabautiza̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iwá̱n Jesús tajtoj sej: —Nej no̱ ayá̱ꞌ nimitzijliáj a̱ꞌyéj ne̱tekimaka iga manikchi̱wa ijkí̱n. ");
INSERT INTO nhx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iwá̱n Jesús pe̱waꞌ kipowaꞌ iní̱n ka̱n mami̱xkui̱tilo: —Se̱ ta̱gaꞌ kitó̱ꞌ u̱vajyoj, iwá̱n kita̱ke̱waltij tekipanowa̱nimej iga makitekipano̱ka̱n, iwá̱n inó̱n ta̱gaꞌ ki̱saꞌ, wejka̱wato. ");
INSERT INTO nhx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kua̱ꞌ tá̱guiꞌya uva, kiti̱tan se̱ imo̱nsoj iga tekipanowa̱nimej makimakaka̱n yej yéjpa kikuis. Eꞌ yejemej kimagakej iwá̱n kiti̱tankej ijka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Iwá̱n ite̱ko mi̱jli kiti̱tan seꞌ imo̱nsoj, eꞌ inó̱n no̱ kijlijkej kuajkuantas, kimagakej iwá̱n no̱ kiti̱tankej ijka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Iwá̱n kiti̱tan sewoꞌ, eꞌ tekipanowa̱nimej no̱ kimagakej in inó̱n tati̱tan iwá̱n no̱ kiki̱xtijkej. ");
INSERT INTO nhx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Iwá̱n ite̱ko u̱vajyoj kijtoj: “¿Té̱ nikchi̱was? Nia nikti̱taniti nopiltzi̱n yej nikpoxcho̱kiliá; anka yéj kirrespeta̱ro̱skej.” ");
INSERT INTO nhx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Eꞌ kua̱ꞌ tekipanowa̱nimej kitakej, mosepan‑ijlijkej: “Iní̱nyawaꞌ in yej yawi mochi̱wati ite̱ko iní̱n ta̱jli yej ítajpa kikajte̱was, matikmiktí̱ka̱nya nokta iga maka̱wi íta̱l iga tejemej.” ");
INSERT INTO nhx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kiki̱xtijkej ipan u̱vajyoj iwá̱n kimiktijkej. Iwá̱n Jesús tatajtan: —Amejeme̱n, ¿kén ankitaj? Ite̱ko u̱vajyoj, ¿té a̱n kichi̱wili̱j in ino̱mej? ");
INSERT INTO nhx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Puej ya̱ti iwá̱n yawi kimikti̱ti ino̱mej tekipanowa̱nimej iwá̱n sékinwaꞌ in kimakas u̱vajyoj. Kua̱ꞌ kikakikej iní̱n, kijtojkej: —¡Amo Dios moneki̱lti̱j! ");
INSERT INTO nhx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Eꞌ Jesús kitachi̱lij ino̱mej iwá̱n kijtoj: —¿Té̱ kijto̱jneki in yej ijkuilijtoꞌ ijkí̱n?: Teꞌti yej ayá̱ꞌ kikuikej yej kalchi̱waj, inó̱n iná̱n yej má̱j moneki. ");
INSERT INTO nhx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","A̱ꞌsan wetzis ipan inó̱n teꞌti, po̱postekis; iwá̱n siga teꞌti wetzi ipan agaj, mochi̱was ken píno̱l. ");
INSERT INTO nhx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kua̱ꞌ kimatikej iga iní̱n tájto̱l yejemej nemi kikajkaktiáj, ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés kinekiáj makiki̱tzki̱ka̱n Jesús iga makipre̱sojwi̱ka̱n. Eꞌ ayá̱ꞌ kichijkej nité̱ iga kimajmawilia̱yaj la gente. ");
INSERT INTO nhx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kiti̱tankej yej makipi̱piaka̱n Jesús yej né̱siajkiꞌ ye̱ꞌnemij iga san makima̱wetzi̱lti̱ka̱n Jesús, yejemej kinekiáj iga Jesús makijto tejté̱ ka̱nsan wel makiwi̱gaka̱n iná̱ꞌ gobernador. ");
INSERT INTO nhx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Tatajtankej yej tapi̱piáj: —Tamachtia̱ni, nikmatij iga yej tej tikijtowa iwá̱n yej tej titane̱xtiliá melaꞌcie̱rtoj iwá̱n tej ayá̱ꞌ titayokajuzga̱rowa. Tej sí titane̱xtiliá iga se̱ manemi ken Dios te‑ijliá. ");
INSERT INTO nhx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Xine‑ijli̱ka̱n: ¿Ix ye̱kti iga matikixta̱waka̱n to‑impue̱stoj rey César de Roma, o ayá̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús kimatiꞌ iga ino̱mej kima̱wetzi̱lti̱jnekiáj iwá̱n kijtoj: —¿Te iga anne̱proba̱rowaj? ");
INSERT INTO nhx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Xine̱ne̱xtili̱ka̱n se̱ tomi̱n. ¿A̱ꞌyéj ixa̱yaꞌ iwá̱n a̱ꞌyéj ito̱ka̱ꞌ yej nigaj ijkuilijtoꞌ? Kijtojkej: —Rey César. ");
INSERT INTO nhx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús kijtoj: —Puej xikmakaka̱n rey César yej yéjpa itatki iwá̱n xikmakaka̱n Dios yej itatki Dios. ");
INSERT INTO nhx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Awel kima̱wetzi̱ltijkej iga yej kijtoj iyi̱xtaj la gente, eꞌ poxsan kiye̱ꞌitakej yej kijtoj iwá̱n até̱ kijtojkej. ");
INSERT INTO nhx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iwá̱n sekin yej kijliáj saduceojmej, yajkij kitatoj Jesús. Ino̱mej saduceojmej tamachtiáj iga ayá̱ꞌ ojpa‑isaj yej miktokej, inó̱n iga kitajtankej ijkí̱n: ");
INSERT INTO nhx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tamachtia̱ni, ijkuilijtoꞌ ipan iley Moisés ijkí̱n: siga se̱ ta̱gaꞌ yej na̱miktitoꞌ miki, iwá̱n ayá̱ꞌ kikajte̱wa nisé̱ ipiltzi̱n wa̱n isiwa̱ꞌ, iyikni̱n yej miꞌ mamona̱mikti iwá̱n viuda iga ken makipiá ipilowa̱n inó̱n yej miꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Onoyaj siete tajta̱gaꞌ yej se̱san itajmej iwá̱n se̱san iye̱mej. Yej te̱ko̱ko achto mona̱miktij, eꞌ miguiꞌ kua̱ꞌ aya pilwaj. ");
INSERT INTO nhx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Iwá̱n imá̱mil mona̱miktij no̱ iwá̱n ino̱nsan siwa̱ꞌ, iwá̱n no̱ miguiꞌ kua̱ꞌ aya pilwaj. ");
INSERT INTO nhx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Iwá̱n iyojpamá̱mil no̱ mona̱miktij íwa̱n. Iwá̱n inewi los siete ijko̱nsan no̱ kichijkej iwá̱n mikikej, nisé̱ de yejemej akipiáꞌ ipiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Iwá̱n má̱j má̱j siwa̱ꞌ no̱ miguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","In kua̱ꞌ ojpa‑isaskej yej miktokej, ¿katiapa a̱n de inó̱n siete mochi̱was iwé̱j in inó̱n siwa̱ꞌ, iga na̱miktitoya iwá̱n inochimej? ");
INSERT INTO nhx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús kijtoj: —Ipan iní̱n ta̱jli tajta̱gaꞌ iwá̱n siwa̱tkej mona̱miktiáj. ");
INSERT INTO nhx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Eꞌ yej kajasiskej iga maasika̱n ipan seꞌ vida iga ojpa‑isaskej, ayꞌya mona̱mikti̱skej, niga kina̱mikti̱skej ipilowa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ayꞌya wel mikiskej puej yawij mochi̱watij ken a̱ngelejmej, iwá̱n yawij mochi̱watij ipilowa̱n Dios iga ojpa‑isákeja. ");
INSERT INTO nhx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Eꞌ iga yej miktokej ojpa‑isaskej, Moisés te̱ne̱xtiliá ka̱n ijkuilijtoꞌ de inó̱n witztako̱ꞌ yej we̱we̱lo̱ntoya, ompa ijkí̱n kino̱tzaꞌ toTe̱ko: “IDio̱s Abraham, iwá̱n iDio̱s Isaac iwá̱n iDio̱s Jacob.” ");
INSERT INTO nhx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Dios ayéj iDio̱s yej miktokej, sino que iDio̱s yej isatokej. Iga Dios, nochi isatokej. ");
INSERT INTO nhx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Iwá̱n sekin yej tamachtiáj ipan iley Moisés kijlijkej: —Ómpaya ken tikijtoj, Tamachtia̱ni. ");
INSERT INTO nhx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Iwá̱n ayꞌya má̱j mi̱xe̱wijkej iga kitajtankej. ");
INSERT INTO nhx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús tatajtan: —¿Te iga kijtowaj iga el Cristo ipiltzi̱n David? ");
INSERT INTO nhx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Puej Davidsan kijtoj ipan libro de los Salmos, kijtoj: ToTe̱ko Dios kijlij noTe̱ko: “Ximota̱li ila̱doj noye̱ꞌma̱ꞌ ka̱n nimanda̱rowa, ");
INSERT INTO nhx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","este que manikta̱li mokxitampa yej mitzijiyaj.” ");
INSERT INTO nhx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Kén wel Cristo yej itati̱tan Dios ma‑ipiltzi̱n David, esi David no̱ kijliá iga iTe̱ko? ");
INSERT INTO nhx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nochi kikaktoya, iwá̱n Jesús kijlij idisci̱polojmej: ");
INSERT INTO nhx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Amo mamitzkajkaya̱waka̱n yej tamachtiáj ipan iley Moisés, puej kiye̱ꞌmatij iga makinenti̱ka̱n sota̱ntzótzol, iwá̱n kinekij makisaluda̱ro̱ka̱n tajkoa̱ltepe̱ꞌ. Yejeme̱n mota̱li̱jnekij tio̱pan‑ijtiꞌ pan ye̱ꞌasie̱ntoj ka̱n mota̱liáj yej má̱j tayaka̱ntokej, iwá̱n ijko̱nsan no̱ kinekij makichi̱waka̱n ka̱n takualo. ");
INSERT INTO nhx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Iwá̱n kichtekiliáj ikalmej viu̱dajmej iwá̱n iga amo mane̱si iga ayompa nemij, pox wejka̱waj iga ora̱dowaj. Yejemej Dios má̱j yawij kicastiga̱ro̱tij. ");
INSERT INTO nhx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús kitachi̱lijtoya yej motapialiáj kua̱ꞌ nemi kakia̱yaj iyofre̱ndajmej ipan se̱ cajo̱n ka̱n moa̱na tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Iwá̱n kitaꞌ no̱ se̱ yej we̱wejmíꞌ yej ayá̱ꞌ motapialiá, nemi kakiá o̱me tomi̱n de cobre yej ayá̱ꞌ pox vale̱rowa. ");
INSERT INTO nhx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Iwá̱n Jesús kijtoj: —Nimitznojma‑ijliáj iga iní̱n viuda yej ayá̱ꞌ motapialiá, kakij má̱j que nochi; ");
INSERT INTO nhx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","puej nochi kita̱lijkej yej kisobra̱rowaj; eꞌ yéj, malej ayá̱ꞌ motapialiá, kimáꞌ inewi yej kipiaya iga takua̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sekin ta̱tapojtoyaj de weyitio̱pan iga pox mo̱nsaj temej yej iga chijtoꞌ. Iwá̱n no̱ kijtojtoyaj de yej kimajmakakej iga mamo̱nsajtachá weyitio̱pan. Iwá̱n Jesús kijtoj: ");
INSERT INTO nhx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Iná̱n ankitztokej, eꞌ wi̱ꞌ se̱ día kua̱ꞌ aka̱wis nisé̱ teꞌti yej mane̱nekpanijto. Nochi yawij moxijxiti̱natij. ");
INSERT INTO nhx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iwá̱n kitajtankej: —Tamachtia̱ni, ¿in iní̱n, ké̱man mochi̱was? ¿Té a̱n mo‑itas kua̱ꞌ ayꞌya wejkatis iga yawi mochi̱wati? ");
INSERT INTO nhx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús kijtoj: —Amo agaj mitzkajkaya̱waskej; iga miaꞌ yawij wi̱tzetij iwá̱n mopajpanti̱skej iga nej, sie̱mpa ayéj. Ijkí̱n kijto̱skej: “Nejya el Cristo”, iwá̱n “Na̱ꞌya iga poliwilo.” Eꞌ amejeme̱n amo xiktokaka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kua̱ꞌ ankikakiskej iga kanaj némiya momijmiktilo, iwá̱n ipan se̱ país mokuejkueso̱lo, amo ximajmawika̱n, puej iní̱n wi̱ꞌ achto, eꞌ aya yéj iga poliwilo. ");
INSERT INTO nhx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iwá̱n kijtoj sej: —Mokuejkueso̱skej se̱ nación iwá̱n seꞌ, iwá̱n se̱ país momijmikti̱skej iwá̱n seꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pox mo̱li̱nas ta̱jli, iwá̱n pox a̱pistajtiás, onos no̱ya̱n kokolis, iwá̱n pox majmawilo̱j iga mo‑itas ipan cielo yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Eꞌ kua̱ꞌ aya mochi̱wa iní̱n, mitzki̱tzki̱skej iwá̱n mitzikno̱chi̱waskej. Mitzwi̱gaskej ipan tio̱pamej iga mamitzjuzga̱ro̱ka̱n, mitzaki̱skej kuákalko, mitzwi̱gaskej ite̱noj re̱yejmej iwá̱n iyi̱xtaj gobernado̱rmej iga anne̱tokaj. ");
INSERT INTO nhx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Íkua̱ꞌya wel antajto̱skej de nej. ");
INSERT INTO nhx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Xiksenta̱li̱ka̱n amoa̱lmajmej iga amo xike̱ejla̱ntoka̱n te̱ ankijto̱skej iga ximotajtowili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porque nej nimitztajto̱lmakaskej iga xikmatika̱n te̱ ankijto̱skej iwá̱n nisé̱ yej mitzijiyaj wel mitzte̱nkuepili̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Eꞌ amejemej amótajsan, amokni̱wa̱n iwá̱n yej íwa̱n anmoye̱ꞌitaj mitzne̱xti̱skej iga anne̱tokaj. Iwá̱n sekin de amejeme̱n mitzmikti̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Iwá̱n nochi mitzijiyaskej iga anne̱tokaj. ");
INSERT INTO nhx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Eꞌ nisé̱ amotzónkal yej onoꞌ ipan amotzontekon yawi poliwiti. ");
INSERT INTO nhx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nochipa ximoconfia̱rojtoka̱n ipan toTe̱ko iwá̱n yéj mitzma̱nawi̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Kua̱ꞌ ankitaskej Jerusalén kiyawalójtoꞌya solda̱dojmej, xikmatika̱n iga yáwija kixi̱xiti̱natij. ");
INSERT INTO nhx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Iwá̱n yej onokej ipan estado de Judea, mayá̱ka̱nya ipan tepe̱yoj; yej onokej ipan a̱ltepe̱ꞌ Jerusalén, maki̱saka̱n, iwá̱n yej onokej imi̱lpamej, amo mamokuepaka̱n pan a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Iga ino̱mej días Dios kicastiga̱ro̱j yej ayompa nemij, iga yawi mochi̱wati inewi kensan ijkuilijtoꞌ ipan itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Pox mokno̱matiskej siwa̱tkej yej íkua̱ꞌ xo̱lo̱yojkej o yej nemi tachi̱chitiáj! Iga Dios poxsan yawij kicastiga̱ro̱tij yej cha̱ntitokej Israel iga kikuesowiliáj. ");
INSERT INTO nhx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sekin kimikti̱skej iga espada iwá̱n sekin yawij kiwi̱gatij preso ipan sekin pai̱smej; yej ayéj de Israel yawij kita̱taksatij yej cha̱ntitokej Jerusalén. Iní̱n kichi̱waskej este kua̱ꞌ kijto̱j Dios. ");
INSERT INTO nhx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesús no̱ kijtoj: —Ne̱sis yej ayi̱ꞌpa mo‑ita ipan el sol, ipan me̱tzti iwá̱n ipan si̱talimej; iwá̱n ipan ta̱jli la gente ayꞌya yawij kimatitij te̱ yawij kichi̱watij iwá̱n momajti̱skej iga pox tikui̱ntoꞌ láma̱r iwá̱n maréja̱l. ");
INSERT INTO nhx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","La gente tapoliwiskej iga majmawiskej iga kejla̱ntoskej te̱ nokta yawi mochi̱wati ipan iní̱n ta̱jli; iwá̱n este si̱talimej mojo̱li̱naskej. ");
INSERT INTO nhx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Iwá̱n ne‑itaskej nej yej iPiltzi̱n Ta̱gaꞌ iga niwi̱ꞌ ipan mixti, nita̱wijtiwi̱ꞌ iga noweyipode̱r. ");
INSERT INTO nhx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kua̱ꞌ pe̱was mochi̱wa iní̱n yej nimitzijlíjkejoꞌ, má̱j ximanima̱ro̱ka̱n, iwá̱n xajkotachaka̱n iga na̱ꞌya wi̱ꞌ yej mitzma̱nawi̱skej. ");
INSERT INTO nhx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Kipowilijkej no̱ se̱ ka̱n mi̱xkui̱tilo: —Taꞌ xikitaka̱n higue̱rajkuawiꞌ o seꞌ na̱mo̱lkuawiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kua̱ꞌ ankitaj iga selkayo̱ki̱say, ankimatij iga wi̱ꞌya to̱nalis. ");
INSERT INTO nhx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ijko̱nsan no̱, kua̱ꞌ ankitaskej iga mochi̱was iní̱n yej nimitzijlíjkejoꞌ, xikmatika̱n iga na̱ꞌya wi̱ꞌ reina̱ro̱ki Dios. ");
INSERT INTO nhx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Nimitznojma‑ijliáj iga yawi mochi̱wati nochi iní̱n, kua̱ꞌ aya mikij yej iná̱n onokej. ");
INSERT INTO nhx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Iní̱n cielo iwá̱n ta̱jli poliwiskej, eꞌ yej nikijtoj, nochi yawi mochi̱wati. ");
INSERT INTO nhx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Xiye̱ꞌtajla̱ntoka̱n; amo xikyo̱lmakaka̱n iga ankichi̱waj yej mitzyo̱ltila̱naj yej aye̱kti, amo xita̱wa̱naka̱n iwá̱n amo mamitzyo̱lmikti̱ka̱n yej ankipiasnekij, iga kua̱ꞌ tajuzga̱rolo̱j amo mitzwe̱jasikij ");
INSERT INTO nhx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ken se̱ yej wetzi ipan trampa. Yej cha̱ntitokej ipan iní̱n ta̱jli, inewi kiwe̱jasikij. ");
INSERT INTO nhx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Amejeme̱n xikchijtoka̱n yej ye̱kti iwá̱n xikte̱ne̱wijtoka̱n Dios nochipa iga wel mamitzma̱nawi̱ka̱n ipan nochi yej yawi mochi̱wati, iwá̱n iga wel xonoka̱n no‑i̱xtaj, nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús nochipa tamachtia̱ya weyitio̱pan, iwá̱n tayowaka̱n ka̱wiá ipan tepe̱ꞌ yej ito̱ka̱ꞌ Olivos. ");
INSERT INTO nhx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Iwá̱n nochi ya̱yaj weyitio̱pan isajpa iga kikakitij. ");
INSERT INTO nhx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ayꞌ wejka iga mochi̱wa ilwiꞌ kua̱ꞌ mokua pa̱n yej ayá̱ꞌ kipiá levadura yej kijliáj no̱ iyilwiyo la Pascua, ");
INSERT INTO nhx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés kite̱mowa̱yaj ken iga wel makimikti̱ka̱n Jesús, eꞌ awel kichi̱wayaj iga kimajmawilia̱yaj la gente. ");
INSERT INTO nhx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Iwá̱n Tzitzimiꞌ kalaꞌ ipan Judas yej no̱ kijlia̱yaj Iscariote, se̱ de idiscí̱polojpa Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yéj yajki kitato ije̱fejmej sacerdo̱tejmej iwá̱n ije̱fejmej policiyajmej yej manda̱rowaj weyitio̱pan, iga kijli̱to iga yéj yawi kipale̱wi̱ti iga makiki̱tzki̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yejemej pa̱kikej iwá̱n kijlijkej Judas iga yawij kimakatij tomi̱n; ");
INSERT INTO nhx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas mote̱máꞌ iga kichi̱was, iwá̱n kite̱mowa̱ya kén iga makiki̱tzki̱ka̱n Jesús kua̱ꞌ ayagaj onoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Asiꞌ día kua̱ꞌ pe̱waꞌ iyilwiyo la Pascua, kua̱ꞌ mokua pan yej ayá̱ꞌ kipiá levadura iwá̱n kimiktiáj borre̱gojtzi̱n iga mokua. ");
INSERT INTO nhx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús kiti̱tan Pedro iwá̱n Juan, kijlijkej: —Xa̱ka̱n xikchi̱watij tákual iga tisentakua̱skej ipan iyilwi la Pascua. ");
INSERT INTO nhx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yejemej kitajtankej: —¿Ka̱n tikneki manikchi̱waka̱n? ");
INSERT INTO nhx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús kijtoj: —Kua̱ꞌ ankalakiskej Jerusalén, anyawij ankasitij se̱ ta̱gaꞌ kiwi̱ga a̱ꞌti ipan se̱ a̱ko̱miꞌ. Xiktokaka̱n este ka̱n kalakis kalijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Iwá̱n xikijli̱ka̱n ite̱ko kajli: “Tamachtia̱ni mitztajtani: ¿Ipan katiapa cuarto nicena̱ro̱j ipan iyilwi la Pascua iwá̱n nodisci̱polojmej?” ");
INSERT INTO nhx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Yéj yawi mitzne̱xtili̱tij se̱ weyi cuarto pan segundo piso ka̱n ónoꞌya nochi yej ankinekiskej; ompa xikchi̱waka̱n tákual. ");
INSERT INTO nhx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yejeme̱n yajkij iwá̱n kasikej nochi ken Jesús kijlijkej, iwá̱n kichijkej tákual iga kilwichi̱wiliáj la Pascua. ");
INSERT INTO nhx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kua̱ꞌ asiꞌ hora, Jesús iwá̱n iyapo̱stolejmej ki̱xna̱nkej mesa. ");
INSERT INTO nhx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús kijtoj: —¡Poxsan niknektoya matisentakua̱ka̱n ipan la Pascua mie̱j aya nimiki! ");
INSERT INTO nhx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Iga nimitzijliáj iga ayoꞌ má̱j nikchi̱was, este que mamochi̱wa ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iwá̱n kikuiꞌ vaso yej kipiaya vino iwá̱n kimáꞌ gracias Dios, iwá̱n kijtoj: —Xikuika̱n iní̱n vaso iwá̱n ajachi xikoni̱ka̱n; ");
INSERT INTO nhx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","nimitzijliáj iga ayoꞌ nia nikoni̱ti vino este que mawi̱ki marreina̱ro̱ki Dios. ");
INSERT INTO nhx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iwá̱n kikuiꞌ pa̱n iwá̱n kimáꞌ gracias Dios, kita̱tajkoloj iwá̱n kimajmakakej sejsé̱ de yejemej, kijlijkej: —Ini̱nwaꞌ nocue̱rpoj yej nikmaka iga nimikis iga amejeme̱n. Xiktekikua̱ka̱n iní̱n iga amo xine‑e̱lka̱waka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ijko̱nsan no̱ kichij iwá̱n vaso yej kipiá vino, kua̱ꞌ támiꞌya cena̱rojkej, kijtoj: —Iní̱n yej nemi ankoniáj, kijto̱jneki noesyo yej yawi toya̱witi iga amejemej iga nikchi̱wa nuevo pacto iga wel anye̱ꞌonoskej iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Eꞌ iná̱n yej yawi ne‑ichtakane̱xti̱ti, nigaj íwa̱n nemi nisentakua. ");
INSERT INTO nhx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nimitzijliáj iga nej yej iPiltzi̱n Ta̱gaꞌ yawij ne̱mikti̱tij ken ikyay mo‑ijkuiloj, eꞌ ¡Dios poxsan kikno̱chi̱was yej yawi ne‑ichtakane̱xti̱ti iga mane̱mikti̱ka̱n! ");
INSERT INTO nhx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iwá̱n pe̱wakej iga mosepantajtanij iga a̱ꞌyéj a̱n in yej kichtakane̱xti̱ti Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Iwá̱n idisci̱polojmej mosejsepan‑ijlijkej iga katiapa de yejemej má̱j tayaka̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Eꞌ Jesús kijtoj: —Ipan iní̱n ta̱jli, re̱yejmej yej manda̱rowaj poxsan kitajtaksa ige̱ntej, eꞌ yejéme̱nsan mojliáj iga kipale̱wiáj ige̱ntej. ");
INSERT INTO nhx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Eꞌ amejeme̱n amo xikchi̱waka̱n ijkó̱n, ma̱jwaꞌ yej tayaka̱ntoꞌ, mamochi̱wa ken yej má̱j chokótzi̱noꞌ; iwá̱n yej manda̱rowa, inó̱n achto makipale̱wi tokni̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Puej, ¿a̱ꞌyéj má̱j tayaka̱ntoꞌ, yej e̱watoꞌ iga takua o yej taservi̱rowa iga kita̱liá tákual? ¿Ix aya̱ꞌtaj má̱j tayaka̱ntoꞌ yej ki̱xna̱ntoꞌ mesa? Puej nej nigaj nonoꞌ iwá̱n amejemej ken se̱ yej taservi̱rowa. ");
INSERT INTO nhx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Amejeme̱n nochipa amonoyaj nowa̱n kua̱ꞌ poxsan nej tejté̱ ne̱yo̱lmiktijtoya. ");
INSERT INTO nhx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Inó̱n iga nej nimitzmakaj iga xitagoberna̱ro̱ka̱n ken noTaj ne̱máꞌ iga manitagoberna̱ro. ");
INSERT INTO nhx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Iwá̱n amejeme̱n antakua̱skej iwá̱n an‑a̱tiskej ipan nome̱saj ka̱n nitagoberna̱ro̱j iwá̱n nia nimitzmakatij iga xikjuzga̱ro̱ka̱n ino̱mej doce tribu yej wa̱lkej ipan ipilowa̱n Israel. ");
INSERT INTO nhx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Kijtoj sej toTe̱ko: —Simón, Simón, taꞌ xikita, Tzitzimiꞌ kineki mamitztzejtzelo̱ka̱n ken kitzejtzelowaj trigo iga maki̱sa itasolyo. ");
INSERT INTO nhx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Eꞌ nikte̱néwija Dios iga tej, iga amo xikajte̱wa iga timoconfia̱rowa ipan nej. Kua̱ꞌ timomelaꞌconfiá̱roja, xikpale̱wi mokni̱wa̱n iga nochipa mamoconfia̱rojtoka̱n ipan nej. ");
INSERT INTO nhx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simón kijlij: —NoTe̱ko, nej niksentá̱lija noa̱lmaj iga maniá mowa̱n ipan cárcel, iwá̱n este manimiki iwá̱n tej. ");
INSERT INTO nhx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesús kijtoj: —Pedro, nimitzijliá iga á̱mansan nokta, kua̱ꞌ áyapa takui̱ka ka̱yo, e̱yi ve̱j tikijto̱j iga ayá̱ꞌ tine‑i̱xmati. ");
INSERT INTO nhx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesús kitajtan idisci̱polojmej: —Kua̱ꞌ nimitzti̱tankaj iwá̱n ayá̱ꞌ ankiwi̱gakaj tomi̱n, niga amomórra̱l iwá̱n niga amogakmej, ¿ix mitzpolojkej tejté̱? Yejeme̱n kijtojkej: —Nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Iwá̱n kijlijkej sej: —Iná̱n sí, yej kipiá imórra̱l makiwi̱ga, iwá̱n yej kipiá ka̱n kakiá itomi̱n, no̱ makiwi̱ga; iwá̱n yej ayá̱ꞌ kipiá iyespa̱daj, makinamaka ikua̱ch iga makikowa. ");
INSERT INTO nhx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Iga nimitzijliáj iga yáwisan mochi̱wati ipan nej yej ijkuilijtoꞌ: “Kijtowaj iga motoka iwá̱n yej ayompa nemij.” Puej yej ijkuilijtoꞌ iga nej, inewi mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yejemej kijtojkej: —NoTe̱ko, nigaj onoꞌ o̱me espada. Iwá̱n yéj kijtoj: —Ómpasan yej ankichijtokej. ");
INSERT INTO nhx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iwá̱n Jesús yajki ken iga nochipa ya̱ya ipan tepe̱ꞌ yej ito̱ka̱ꞌ Olivos, iwá̱n idisci̱polojmej kitokakej. ");
INSERT INTO nhx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kua̱ꞌ ásiꞌya ompa, kijlijkej: —Xi‑ora̱do̱ka̱n iga amo mamitzta̱nili̱ka̱n Tzitzimiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Iwá̱n Jesús yajki achi má̱j wejka, ke̱ꞌ ka̱n se̱ kaxitiá iga kabenta̱rowa teꞌti, motankua̱ketzaꞌ iwá̱n tajtoj wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kijtoj: —Notaj, siga tikneki, xine̱ma̱nawi iga amo mane‑ikno̱chi̱waka̱n; eꞌ amo mamochi̱wa ken nej nikneki, mamochi̱wa ken tej tikneki. ");
INSERT INTO nhx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kua̱ꞌ kijtoj inó̱n, ki̱xne̱xtili̱ko se̱ ángel yej wa̱laj pan cielo iga kiyo̱lchika̱wako. ");
INSERT INTO nhx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús má̱j kite̱ne̱wij Dios iga pox tayo̱koxtoya, iwá̱n iyi̱to̱n chichipikaya ipan ta̱jli kenya esti. ");
INSERT INTO nhx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Kua̱ꞌ moketzaꞌ iga tamiꞌ ora̱doj, yajki ka̱n onoyaj idisci̱polojmej, iwá̱n kasitoj kojkochtokej iga pox mokno̱matij. ");
INSERT INTO nhx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iwá̱n kijlijkej: —¿Te iga ankojkochtokej? Ximoketzaka̱n iwá̱n xi‑ora̱do̱ka̱n, iga amo mamitzta̱nili̱ka̱n Tzitzimiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Tajtojtóyaoꞌ Jesús, kua̱ꞌ asiko miaꞌ gente yej kiwajli̱ꞌ Judas, se̱ de inó̱n doce idisci̱polojmej. Judas tayaka̱ntia̱ya iwá̱n kina̱ꞌtechoj iga kipipitzo̱to Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesús kijlij: —Judas, ¿ix tine̱pipitzówapa iga tine̱ne̱xtiá iga mane̱ki̱tzki̱ka̱n, nej yej iPiltzi̱n Ta̱gaꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yej onoyaj iwá̱n Jesús, kitztoyaj yej nemi mochi̱wa, kitajtankej: —NoTe̱ko, ¡maniktzojtzontekíka̱nya iga espada! ");
INSERT INTO nhx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Iwá̱n se̱ de yejemej kinagastzonteꞌ se̱ itekipanowa̱ni yej ijé̱fejpa sacerdo̱tejmej, kitekilij inakas yej ilá̱dojpa iye̱ꞌma̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesús kijtoj: —Xikajte̱waka̱n; ómpaya matami. Iwá̱n kinagaschijchin inó̱n ta̱gaꞌ, iwá̱n kiye̱ktialtij. ");
INSERT INTO nhx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iwá̱n Jesús kijlij ije̱fejmej sacerdo̱tejmej, policiyajmej yej de weyitió̱pampa iwá̱n yej kimanda̱rowaj judiyojmej yej wa̱lkej iga kikuikoj: —¿Ix anwa̱lkej anne̱kuikoj ken kua̱ꞌ se̱ yej tachteꞌ? ¿Ix inó̱n iga ankiwajligakej espada iwá̱n kuawiꞌ? ");
INSERT INTO nhx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nochipa nonoya amowa̱n weyitio̱pan, iwá̱n ayá̱ꞌ anne̱ki̱tzkijkej, eꞌ ásiꞌya hora iga amejemej, iga iná̱n Tzitzimiꞌ manda̱rowa. ");
INSERT INTO nhx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Kiki̱tzkijkej Jesús iwá̱n kiwi̱gakej cha̱n ije̱fej sacerdo̱tejmej; iwá̱n Pedro kiwejkatokatia̱ya. ");
INSERT INTO nhx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Iwá̱n tita̱lijkej tajkopa̱tioj, iwá̱n kiyawalojkej inó̱n tiꞌti; Pedro no̱ ompa mota̱lij iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Iwá̱n se̱ sirvienta kua̱ꞌ kitaꞌ este e̱watoꞌ iná̱ꞌ tiꞌti, kitachi̱lijtiká̱ꞌ iwá̱n kijtoj: —Ini̱nwaꞌ no̱ nemiá iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Eꞌ Pedro kijtoj iga ayá̱ꞌ, kijtoj: —Nej ayá̱ꞌ niki̱xmati. ");
INSERT INTO nhx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ayá̱ꞌ wejkatiꞌ, seꞌ kitaꞌ iwá̱n kijlij: —Tej no̱ de yejéme̱mpa. Pedro kijtoj: —Ayá̱ꞌ ej, ayéj nej. ");
INSERT INTO nhx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kipiáꞌ ken se̱ hora, seꞌ kijlij: —Mataj iní̱n no̱ onoya iwá̱n yéj. Kéntaj ne̱si iga de Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pedro kijtoj: —Ej, anikmati de te̱ titajtowa. Kua̱ꞌ nokta tajtojtoya Pedro, takui̱gaꞌ se̱ ka̱yo. ");
INSERT INTO nhx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ToTe̱ko mokuepaꞌ iwá̱n kitachi̱lij Pedro. Iwá̱n Pedro kejla̱n yej toTe̱ko kijlij: “Kua̱ꞌ aya takui̱ka ka̱yo, tia tikijto̱ti e̱yi ve̱j iga ayá̱ꞌ tine‑i̱xmati.” ");
INSERT INTO nhx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iwá̱n Pedro ki̱saꞌ ompa iwá̱n pox cho̱gaꞌ este kualo̱ꞌ iya̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tajta̱gaꞌ yej kicuida̱rojtoyaj Jesús, kipi̱najtia̱yaj iwá̱n kimagayaj. ");
INSERT INTO nhx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ki̱xtzakuayaj iga tzótzol iwá̱n kixa̱ygatatzi̱nayaj, iwá̱n kitajtaniáj: —¡Siga tiprofe̱taj, taꞌ xikijto a̱ꞌyéj mitzmagaꞌ! ");
INSERT INTO nhx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Iwá̱n kuajkuantas kijlijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kua̱ꞌ tané̱siꞌya, monechkojkej yej kimanda̱rowaj judiyojmej, ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan iley Moisés iwá̱n kiwi̱gakej Jesús iyi̱xtajmej. Iwá̱n ompa kitajtankej: ");
INSERT INTO nhx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Taꞌ xine‑ijli̱ka̱n, ¿ix tejya in Cristo? Jesús kijtoj: —Siga nimitzijliáj iga kena, ayá̱ꞌ anne̱tajto̱lkuiskej. ");
INSERT INTO nhx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Iwá̱n siga nimitztajtaniskej, ayá̱ꞌ anne̱contesta̱ro̱skej, niga anne̱majka̱waskej. ");
INSERT INTO nhx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Eꞌ nej yej iPiltzi̱n Ta̱gaꞌ á̱mansan nia nimota̱li̱ti ila̱doj iye̱ꞌma̱ꞌ Dios yej nochi wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Iwá̱n nochi kitajtankej: —¿Ix tejtaj in iPiltzi̱n Dios? Jesús kijtoj: —Nejya nokta, ken amejeme̱n ankijtojkej. ");
INSERT INTO nhx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iwá̱n yejemej kijtojkej: —Ayꞌ tiknekij agaj má̱j mate‑ijli de yéj; toma̱tika nokta tikakikej yej kijtoj. ");
INSERT INTO nhx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nochi moketzkej, iwá̱n Jesús kiwi̱gakej ka̱n manda̱rowa Pilato. ");
INSERT INTO nhx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Iwá̱n iyi̱xtaj pe̱wakej iga kite̱lwiáj Jesús: —Iní̱n ta̱gaꞌ nikasitoj ka̱n kikajkayajtinemi nokni̱mej, kijtowa iga ámokiꞌ manikixta̱waka̱n impuesto iga rey César, iwá̱n kijtowa iga yéjwaꞌ in Cristo, se̱ rey. ");
INSERT INTO nhx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato kitajtan: —¿Ix tejya in iRre̱y judiyojmej? Jesús kijtoj: —Ijko̱nya ken tej tikijtowa. ");
INSERT INTO nhx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Iwá̱n Pilato kijlij ije̱fejmej sacerdo̱tejmej iwá̱n la gente: —Iní̱n ta̱gaꞌ ayá̱ꞌ nikasiliá siga kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Eꞌ yejemej ma̱jsan kijtojkej: —Ijkó̱n ken tamachtijtinemi, kikajkayajtinemi nochi ipan estado de Judea. Pe̱waꞌ ipan estado de Galilea iwá̱n asiꞌ este nigaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Kua̱ꞌ Pilato kikáꞌ iní̱n, tatajtan siga inó̱n ta̱gaꞌ de Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Iwá̱n kua̱ꞌ Pilato kimatiꞌ iga Jesús de Galilea, estado ka̱n manda̱rowa Herodes, kiti̱tan Jesús iná̱ꞌ Herodes. Ino̱mej día Herodes no̱ nemiá Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Kua̱ꞌ Herodes kitaꞌ Jesús, poxsan yo̱lpa̱guiꞌ iga kipox‑itasnekiá, puej kipoxkakiá ka̱n kipowaj de Jesús, iwá̱n kichaya iga makichi̱wa iyi̱xtaj tejté̱ yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kitajtajtan miaꞌ ve̱j, eꞌ Jesús ayá̱ꞌ kijtoj nité̱. ");
INSERT INTO nhx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ompa no̱ onoyaj ije̱fejmej sacerdo̱tejmej iwá̱n yej tamachtiáj ipan la ley, poxsan kite̱lwijtoyaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes iwá̱n isolda̱dojmej kaja̱wilkuikej Jesús, iwá̱n iga kipi̱najtijkej, kajaki̱ltijkej tzótzol yej patiyoj ken yej kakiá se̱ rey. Iwá̱n Herodes kiti̱tan sej ka̱n onoꞌ Pilato. ");
INSERT INTO nhx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Iwá̱n íkua̱ꞌya Pilato iwá̱n Herodes moye̱ꞌitákeja iga mo‑ijiyayaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato kinechkoj ije̱fejmej sacerdo̱tejmej iwá̱n la gente iwá̱n yej manda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Iwá̱n kijlijkej: —Amejemej anne̱wajliguilijkej iní̱n ta̱gaꞌ iwá̱n anne‑ijliáj iga takajkayajtinemi: eꞌ nej niktájtanya amo‑i̱xtaj iwá̱n ayá̱ꞌ nemi nikasiliá yej kichij yej aye̱kti ken amejemej ankijtowaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Niga Herodes akasilij, puej te̱ti̱tanilij sej. Ankitaj iga ayá̱ꞌ kichij nité̱ yej kajasi iga mamomikti. ");
INSERT INTO nhx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Niasan nikikno̱chi̱wati iwá̱n nia sej nikmajka̱wati. ");
INSERT INTO nhx_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kua̱ꞌ iyilwi la Pascua, Pilato nochipa kimajka̱waya se̱ preso yej kitapejpenaya la gente. ");
INSERT INTO nhx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eꞌ inochi gente tzajtzikej: —¡Inó̱n xikmikti! ¡Xikmajka̱wa Barrabás! ");
INSERT INTO nhx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Inó̱n Barrabás kakijkaj ipan cárcel iga kichij revolución ipan a̱ltepe̱ꞌ ico̱ntraj gobernador iwá̱n iga tamiktij. ");
INSERT INTO nhx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato kimajka̱wasnekiá Jesús iwá̱n sej kitajtan la gente, ");
INSERT INTO nhx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","eꞌ yejeme̱n tzajtzikej má̱j recio: —¡Xikmikti ipan cruz! ¡Xikmikti ipan cruz! ");
INSERT INTO nhx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ipan e̱yi ve̱j iga tatajtan Pilato, kijtoj: —Puej, ¿té̱taj kichij yej aye̱kti? Nej ayá̱ꞌ nikasiliá nité̱ yej kajasi iga mamiki. Nia nicastiga̱ro̱ti iwá̱n nia nikmajka̱wati. ");
INSERT INTO nhx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Eꞌ la gente iwá̱n ije̱fejmej sacerdo̱tejmej tzajtzikej má̱j recio iga makimikti̱ka̱n ipan cruz, este que kitajto̱lkuikej. ");
INSERT INTO nhx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Iwá̱n Pilato tatekimáꞌ iga mamochi̱wa ken kitajtanilijtoyaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iwá̱n kimajkaj inó̱n ta̱gaꞌ yej yejeme̱n kitapejpenkej yej onoya ipan cárcel iga kichij revolución iwá̱n iga tamiktij. Iwá̱n Pilato kentregá̱rojsan Jesús iga la gente makichi̱wili̱ka̱n ken kinekiáj. ");
INSERT INTO nhx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kua̱ꞌ kiwi̱gakej Jesús iga kiclava̱ró̱tija ipan cruz, nemi wi̱tziaya ipan mi̱lojti se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Simón, yej icha̱n a̱ltepe̱ꞌ Cirene, iwá̱n yéj kimakakej cruz iga makisa̱lojtiá itepotztaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kitokatia̱yaj Jesús miaꞌ gente iwá̱n siwa̱tkej yej cho̱katia̱yaj iga Jesús, iwá̱n tzajtziáj iga mokno̱matiáj. ");
INSERT INTO nhx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eꞌ Jesús kitachi̱lijkej iwá̱n kijlijkej: —Siwa̱tkej yej ancha̱ntitokej Jerusalén, amo xicho̱kaka̱n iga nej; xicho̱káka̱nwaꞌ iga amejeme̱n iwá̱n iga amopilowa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Porque wi̱ꞌ día kua̱ꞌ mojto̱j: “Pa̱ktoꞌ yej ayá̱ꞌ pilowa, siwa̱tkej yej ayí̱ꞌ taonoltij, chi̱chiwalmej yej ayí̱ꞌ tachi̱chitij.” ");
INSERT INTO nhx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Iwá̱n la gente de inó̱n tiempo pe̱was iga kijli̱j tepe̱mej: “Xine̱tepacho̱ka̱n”, iwá̱n tepe̱tzitzi̱n: “Xine‑i̱ya̱naka̱n.” ");
INSERT INTO nhx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Siga iní̱n ne̱chi̱wiliáj nej, yej anikchij yej aye̱kti, ¿ix ayá̱ꞌ ma̱jya kikno̱chi̱waskej yej kichijtokej yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kiwi̱gayaj no̱ o̱me̱n yej kichijkej yej aye̱kti iga makisenmikti̱ka̱n iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kua̱ꞌ asíkeja ompa ka̱n kijliáj Kuaomiꞌ, ompa kiclava̱rojkej Jesús ipan cruz. No̱ kiclava̱rojkej ipan sej se̱ icru̱z o̱me̱n yej kichijkej yej aye̱kti, se̱ ila̱doj iye̱ꞌma̱ꞌ iwá̱n seꞌ iyo̱pochka̱mpa. ");
INSERT INTO nhx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús kijtoj: —NoTaj, xike̱lka̱wili̱ka̱n yej nemi kichi̱waj, iga ayá̱ꞌ kimatij te̱ kichijtokej. Iwá̱n solda̱dojmej kirrifa̱rojkej itzótzol Jesús iga makitaka̱n aja̱ꞌyéj kikuis. ");
INSERT INTO nhx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","La gente ompa tachi̱xtoyaj. Iwá̱n este yej manda̱rowaj kipi̱najtia̱yaj Jesús, kijlia̱yaj: —Sekin kima̱nawij; mamoma̱nawi igá̱najsan, siga melá̱ꞌ iga yeja in Cristo yej Dios kitapejpen. ");
INSERT INTO nhx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Solda̱dojmej no̱ kipi̱najtia̱yaj Jesús. Kitechojkej iwá̱n kimakakej iga makoni xoko̱ꞌvi̱noj. ");
INSERT INTO nhx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kijlijkej: —Siga tej in iRre̱y judiyojmej, moga̱naj ximoma̱nawi. ");
INSERT INTO nhx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Iwá̱n onoya se̱ tajkuílo̱l ikua̱pan ipan tájto̱l griego, latín iwá̱n hebreo, kijtowa̱ya: “INI̱NWAꞌ IN IRRE̱Y JUDIYOJMEJ.” ");
INSERT INTO nhx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Se̱ yej kichij yej aye̱kti, yej no̱ pi̱pilojtoya ipan cruz, kima̱lijlij Jesús: —¡Siga tej in el Cristo, ximoma̱nawi iwá̱n xine̱ma̱nawi̱ka̱n no̱ nejemej! ");
INSERT INTO nhx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Eꞌ sewoꞌ kajajwaꞌ in inó̱n, kijlij: —¿Ni alí̱n ayá̱ꞌ tikmajmawiliá Dios? Tikmatitoꞌ iga nemi no̱ mitzcastiga̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Tejemej kajasi iga nemi te̱castiga̱rowaj, iga nemi tikixta̱waj yej tikchijkej yej aye̱kti; eꞌ iní̱n ta̱gaꞌ ayá̱ꞌ kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Iwá̱n kijtoj sej: —Jesús, xineejla̱miki kua̱ꞌ tia̱j ka̱n titagoberna̱ro̱j. ");
INSERT INTO nhx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús kijtoj: —Nimitzijliá iga á̱mansan tonos nowa̱n ka̱n paré̱j taye̱ka̱n ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tajkodía tako̱mitiꞌ no̱ya̱n ipan ta̱jli este las tres tio̱takpan. ");
INSERT INTO nhx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ayꞌya to̱naya iwá̱n tastalyo̱ꞌ ayꞌya ne̱siá. Tzótzol yej iga tajkotzaktoya weyitio̱pan de Jerusalén tzaya̱niꞌ itajkoya̱n. ");
INSERT INTO nhx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús tzajtziꞌ recio iwá̱n kijtoj: —¡Notaj, ipan moma̱ꞌ nikta̱liá noespí̱ritoj! Kua̱ꞌ kijtoj iní̱n, miguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kua̱ꞌ ije̱fej solda̱dojmej kitaꞌ yej nemi mochi̱wa, kiweyimati̱ltij Dios, kijtoj: —Mataj melá̱ꞌ iní̱n ta̱gaꞌ ayá̱ꞌ kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nochi yej ompa onoyaj, iwá̱n kitakej yej mochij, pox mokno̱matitiajkij. ");
INSERT INTO nhx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Inewi iyami̱gojwa̱n Jesús, iwá̱n siwa̱tkej yej kitokatinemiáj este ipan estado de Galilea, wéjkasan kitachi̱lijtoyaj. ");
INSERT INTO nhx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Onoya se̱ ta̱gaꞌ pox te‑ijikni̱n iwá̱n ye̱ꞌnemiá, ito̱ka̱ꞌ José. Yéj icha̱n a̱ltepe̱ꞌ Arimatea, ipan el estado de Judea, inó̱n ta̱gaꞌ no̱ senmanda̱rowa̱ya iwá̱n ije̱fejmej judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Eꞌ yéj ayá̱ꞌ kinekiá makichi̱wa ken kichijkej nochi je̱fejmej kua̱ꞌ kijtojkej iga mamiki Jesús. Iní̱n José kichaya iga marreina̱ro Dios. ");
INSERT INTO nhx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yajki kitato Pilato iga kitajtanili̱to icue̱rpoj Jesús iga makito̱ka. ");
INSERT INTO nhx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kua̱ꞌ kitemówija ipan cruz, kiki̱kimiloj iga sábana iwá̱n kakij ipan se̱ a̱nimajtexapoꞌ ka̱n aya agaj moto̱ka. ");
INSERT INTO nhx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Iní̱n mochij kua̱ꞌ moprepara̱do̱lo iga mo̱stapa mose̱wilo iwá̱n inó̱n hora pe̱wasnekiáy. ");
INSERT INTO nhx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Iwá̱n siwa̱tkej yej kitokatinemiáj Jesús este ipan estado de Galilea, yajkij kitatoj ka̱n motó̱ꞌ iwá̱n kitakej kén nokta kita̱lijkej icue̱rpoj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kua̱ꞌ mokuépkeja icha̱mej kichijkej yej ajwiya̱ꞌ iwá̱n pomada; siwa̱tkej mosejkej ipan día kua̱ꞌ mose̱wilo ken iga kitekimakaj iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Isájpasan domingo, siwa̱tkej yajkij sej posa̱ntoj. Kiwi̱gakej yej ajwiya̱ꞌ yej yejémejsan kichijkej iwá̱n senyajkij iwá̱n sékinoꞌ má̱j siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Kua̱ꞌ asíkeja ompa, weyiteꞌti yej kite̱ntzaktoya a̱nimajtexapoꞌ, kimimilójkeja. ");
INSERT INTO nhx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Iwá̱n kalakkej, eꞌ ayoꞌ kasikej icue̱rpoj in toTe̱ko Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Momajtijtika̱wikej iwá̱n ayꞌya kimatiáj te̱ kichi̱wayaj, kua̱ꞌ kitakej o̱me̱n tajta̱gaꞌ ejejkatokej ite̱nojmej, este pe̱peta̱ni itzotzolmej. ");
INSERT INTO nhx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Siwa̱tkej poxsan momajtijkej iwá̱n motzonto̱lojkej; eꞌ ino̱mej tajta̱gaꞌ kijtojkej: —¿Te iga ankite̱mowaj yej isatoꞌ ka̱n onoꞌ yej miktokej? ");
INSERT INTO nhx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ayꞌya nigaj onoꞌ, yejwaꞌ ojpa‑ísaꞌya. Xikejla̱mikíka̱nsan yej mitzijlijkej kua̱ꞌ onóyaoꞌ ipan estado de Galilea. ");
INSERT INTO nhx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kijtoj iga iPiltzi̱n Ta̱gaꞌ wetziasan ipan ima̱mej yej kichi̱waj yej aye̱kti iwá̱n kimikti̱skej ipan cruz, iwá̱n ipan e̱yi día ojpa‑isas sej. ");
INSERT INTO nhx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Iwá̱n siwa̱tkej kejla̱nkej yej kijtoj Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kua̱ꞌ mokuépkeja iga onoyaj ka̱n a̱nimajtexapoꞌ, kipowilijkej inewi yej sucede̱roj inó̱n once apo̱stolejmej iwá̱n yej iwa̱mej onoyaj. ");
INSERT INTO nhx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Iní̱n ito̱ka̱mej yej kipowilijkej apo̱stolejmej: María Magdalena, Juana, María yej íye̱ꞌpa Jacobo, iwá̱n sekin má̱j siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Eꞌ apo̱stolejmej kijtojkej anka lo̱kajtiákeja, iwá̱n ayá̱ꞌ kitajto̱lkuikej. ");
INSERT INTO nhx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Eꞌ Pedro moketzaꞌ iwá̱n motalojtiajki iga yajki posa̱ntoj. Iwá̱n kua̱ꞌ tachato texapoko, ayá̱ꞌ kitaꞌ nité̱, petz iyókaya onoya ista̱ꞌtzótzolmej yej iga kimilijtoya Jesús iwá̱n yajki sej icha̱n, yo̱lmajmatiajki iga yej kitaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ipansan inó̱n día o̱me̱n disci̱polojmej nemi ya̱yaj se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Emaús. Kipiaya ken once kilómetros este Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Kipojtia̱yaj inewi yej mochij. ");
INSERT INTO nhx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kua̱ꞌ nokta ta̱tapojtia̱yaj, Jesús kina̱ꞌtechoj inó̱n o̱me̱n, iwá̱n némiya senya̱yaj. ");
INSERT INTO nhx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Eꞌ yejemej ken tejté̱ ki̱xtzaktoyaj iga amo maki̱xmatika̱n a̱ꞌyéj in inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús tatajtan: —¿Té̱ ankipojtiawij, iwá̱n te íga anmokno̱matij? ");
INSERT INTO nhx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Iwá̱n se̱ de yejemej yej ito̱ka̱ꞌ Cleofas kijtoj: —Nochi kimati yej mochij Jerusalén ini̱mej días. ¿Ix tejsan yej ompa tonoya yej atikmati? ");
INSERT INTO nhx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yéj tatajtan: —¿Té̱ sucede̱roj? Yejeme̱n kijlijkej: —Yej kichi̱wilijkej Jesús yej icha̱n Nazaret, se̱ profeta katka yej kichij yej pox ye̱kti iga ipode̱r iwá̱n iga itájto̱l, ijkó̱n Dios kipoxye̱ꞌitaꞌ iwá̱n la gente no̱ kiye̱‑itaꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ije̱fejmej sacerdo̱tejmej iwá̱n yej manda̱rowaj kentrega̱rojkej iga mamiki ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nejemej nikchi̱xtoyaj iga yéj kima̱nawia̱ya el país de Israel. A̱nwaꞌ kipiáy e̱yi día iga panoj inewi inó̱n. ");
INSERT INTO nhx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Eꞌ sekin siwa̱tkej yeguin ne̱majmajtijkej iga yajkaj posa̱ntoj kua̱ꞌ tane̱stíwi̱ꞌoꞌ ");
INSERT INTO nhx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","iwá̱n ayá̱ꞌ kasikej icue̱rpoj Jesús. Iwá̱n wa̱lkej ne̱powili̱koj iga ki̱xne̱xtilijkej o̱me̱n a̱ngelejmej iwá̱n kijlijkej iga Jesús isatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Sekin nokni̱wa̱n yajkij no̱ posa̱ntoj, iwá̱n yajkij kasitoj a̱nimajtexapoꞌ kenya nokta siwa̱tkej kijtojkej, eꞌ ayá̱ꞌ kitakej Jesús. ");
INSERT INTO nhx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iwá̱n Jesús kijtoj: —Amejeme̱n pox ankua̱takuaktikej iwá̱n ayá̱ꞌ wel ankitajto̱lkuij profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eꞌ Dios kineꞌ iga Cristo makikno̱chi̱waka̱n antes iga mayawi ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iwá̱n pe̱waꞌ iga kinejne̱xtilijkej itájto̱l Dios ka̱n tajtowa de Cristo, pe̱waꞌ pan ili̱broj Moisés iwá̱n kine̱xtilijtiajkij pan inewi ili̱brojmej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Kua̱ꞌ asitiájkija ipan a̱ltepe̱ꞌ ka̱n ya̱yaj, Jesús kichij ken kua̱ꞌ ya̱ya má̱j wejka. ");
INSERT INTO nhx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Eꞌ yejemej kijlijkej: —Xika̱wi iwá̱n nejemej, iga tió̱taꞌya, némiya tako̱mitiá. Iwá̱n Jesús kalaꞌ kalijtiꞌ iga ka̱wiꞌ iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kua̱ꞌ ki̱xna̱ntókeja mesa, kikuiꞌ pa̱n iwá̱n kua̱ꞌ tamiꞌ ora̱doj, kipo̱posteꞌ iwá̱n kimajmakakej. ");
INSERT INTO nhx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iwá̱n íkua̱ꞌya i̱xtapowikej iwá̱n ki̱xmatíkeja iga Jesús: eꞌ yéj sanpolijte̱waꞌ. ");
INSERT INTO nhx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Iwá̱n mosepan‑ijlijkej: —Inó̱n iga este ye̱kti tikmachi̱lia̱yaj ipan toa̱lmaj kua̱ꞌ te̱ta̱tapo̱wia̱ya ipan ojti iga te̱ne̱xtilijtiwi̱tziaya itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iwá̱n íkua̱ꞌsan sej ojkuikej iga yajkij Jerusalén iwá̱n kasitoj nechkatokej once apo̱stolejmej iwá̱n icompañe̱rojwa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Iwá̱n kijtojkej yej nechkatoyaj: —Mataj kena ojpa‑isaꞌ sej toTe̱ko, porque ki̱xne̱xtílija Simón. ");
INSERT INTO nhx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Iwá̱n ino̱mej o̱me̱n no̱ kipowakej yej kisucede̱rojkej ipan ojti. Iwá̱n kijlijkej iga ki̱xmatikej Jesús este kua̱ꞌ kimajmakákeja pa̱n. ");
INSERT INTO nhx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Mie̱j inó̱n kipojtoyaj, Jesús mi̱xne̱xti̱ko tatajkoya̱n iwá̱n kisaluda̱rojkej ijkí̱n: —Tamelá̱ xonoka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yejemej poxsan momajtijkej, kijtojkej iga kitztoyaj á̱nimaj. ");
INSERT INTO nhx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Eꞌ Jesús kijtoj: —¿Te iga anmajmatokej?, iwá̱n ¿te iga ijkó̱n ankejla̱mikij? ");
INSERT INTO nhx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Taꞌ xikitaka̱n noma̱mej iwá̱n nokximej. Nej nokta. Taꞌkiꞌ xine̱chijchimika̱n iwá̱n xine‑itaka̱n: á̱nimaj ayá̱ꞌ nakayoj iwá̱n ayá̱ꞌ omiyoj, eꞌ nej ni‑omiyoj iwá̱n ninakayoj iwá̱n anne‑itztokej. ");
INSERT INTO nhx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kua̱ꞌ kijtoj inó̱n, kine̱xtij ima̱mej iwá̱n iyikximej. ");
INSERT INTO nhx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eꞌ yejemej iga pa̱ktoyaj iwá̱n iga moyo̱lmajtijtoyaj, ayá̱ꞌ kicre̱dowa̱yaj. Iwá̱n Jesús kijtoj: —¿Ix ankipiáj achi tákual? ");
INSERT INTO nhx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Kimakakej tájkol ta‑ixkalto̱poj iwá̱n tájkol pána̱l. ");
INSERT INTO nhx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Iwá̱n yéj kikuiꞌ, iwá̱n kikuaj ka̱n kitztokej. ");
INSERT INTO nhx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Iwá̱n kijtoj: —Ini̱nya nokta yej nimitzpowilijkej kua̱ꞌ nonóyaoꞌ amowa̱n: iga mamochi̱wa ipan nej inewi yej ijkuilijtoꞌ ipan iley Moisés iwá̱n ipan ili̱brojmej profe̱tajmej iwá̱n ipan libro de los salmos. ");
INSERT INTO nhx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Iwá̱n kichij iga makentende̱ro̱ka̱n itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Iwá̱n kijtoj: —Ijkuilijtoꞌ iga Cristo mikiasan iwá̱n ojpa‑isaya sej ipan e̱yi día. ");
INSERT INTO nhx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iwá̱n iní̱n ye̱ꞌnoti̱ciaj mopowas ipan noto̱ka̱ꞌ desde Jerusalén iwá̱n ipan nochi pai̱smej. Mopowas iga mamoyo̱lpataka̱n iga Dios wel make̱lka̱wili yej kichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amejeme̱n ankitakej ini̱mej yej mochij. ");
INSERT INTO nhx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Iwá̱n nia nimitzti̱tanili̱tij yej noTaj kijtoj iga mitzmakaskej. Eꞌ amejeme̱n xika̱wika̱n nigaj, ipan a̱ltepe̱ꞌ Jerusalén este que xikpiaka̱n poder yej wi̱ꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iwá̱n Jesús kiwi̱gaꞌ idisci̱polojmej na̱ꞌ a̱ltepe̱ꞌ Betania iwá̱n kajajkoꞌ ima̱ꞌ iwá̱n kite̱ne̱wij Dios iga maye̱ꞌonoka̱n. ");
INSERT INTO nhx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kua̱ꞌ kitajtanílija Dios iga maye̱ꞌonoka̱n, majkejtiajki iga yajki ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Iwá̱n yejemej kiweyimati̱ltijkej Jesús iwá̱n pa̱ktiájkija iga yajkij Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iwá̱n nochipa onoyaj weyitio̱pan iga kiweyimati̱ltia̱yaj Dios. Ijkó̱nyawaꞌ.");
INSERT INTO nhx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kua̱ꞌ pe̱waꞌ nochi, onóyaya in Tájto̱l; iwá̱n inó̱n Tájto̱l onoya iwá̱n Dios iwá̱n yéj in Dios. ");
INSERT INTO nhx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Puej kua̱ꞌ pe̱waꞌ, yéj onoya iwá̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ipan yéj, Dios kichij nochi yej onoꞌ; ateyi nité̱ yej onoꞌ yej inó̱n Tájto̱l ayá̱ꞌ kichij. ");
INSERT INTO nhx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yéj kichij iga nochi yej isatoꞌ maonoka̱n, wa̱n kita̱wia̱ya pan iya̱lmajmej nochi gente. ");
INSERT INTO nhx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iní̱n ta̱wi̱lyo̱ꞌ ta̱wiá ka̱n tako̱mi iwá̱n tako̱mitilyo̱ꞌ awel kise̱wiá. ");
INSERT INTO nhx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Onoya se̱ ta̱gaꞌ ito̱ka̱ꞌ Juan, yej Dios kiti̱tan, ");
INSERT INTO nhx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","wa̱laj kinojma‑ijto̱ko itekiyo inó̱n ta̱wi̱lyo̱ꞌ, iga nochi makicre̱do̱ka̱n ipan ta̱wi̱lyo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ayéj inó̱n ta̱wi̱lyo̱ꞌ, kiti̱tánkejsan iga ye̱ꞌtajto̱ko de ta̱wi̱lyo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Inó̱n melaꞌta̱wi̱lyo̱ꞌ yej kita̱wiá nochi gente, ito̱ka̱ꞌ Jesucristo, némi‑oꞌ asiá ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Inó̱n Tájto̱l onoya ipan ta̱jli; iwá̱n malej iga Dios kichij ipan Jesucristo nochi yej onoꞌ, yej cha̱ntitokej ipan ta̱jli aki̱xmatikej. ");
INSERT INTO nhx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jesús wa̱laj ipan íta̱l, eꞌ judiyojmej yej igé̱ntejpa ako̱mema̱wijkej. ");
INSERT INTO nhx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Eꞌ yej ko̱mema̱wijkej iwá̱n moconfia̱rojkej ipan yéj, yéj kichij iga ini̱mej mamochi̱waka̱n ipilowa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ayéj ken ipilowa̱n na̱mo̱lte̱tajmej yej nace̱rowaj iga ijkó̱n kineki ta̱gaꞌ, sino que ini̱mej ipilowa̱n nokta Dios. ");
INSERT INTO nhx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Iwá̱n inó̱n Tájto̱l mochij ta̱gaꞌ, iwá̱n cha̱ntitoya iwá̱n nejeme̱n, poxsan te‑ijikni̱n iwá̱n ayí̱ꞌ takajkaya̱wa. Iwá̱n nikitakej iweyipode̱r, ino̱nwaꞌ iweyipode̱r ise̱lpiltzi̱n toTaj. ");
INSERT INTO nhx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan tajtoj de yéj, iwá̱n kijtoj: —De iní̱n nitajtoj kua̱ꞌ nikijtoj iga yej wi̱ꞌ despué̱j de nej, achto que nej, iga onóyaya kua̱ꞌ nej aya nonoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Dios te̱maka yej ye̱kti, ayéj se̱ ve̱j, miaꞌ ve̱j, iga te̱poxcho̱kiliá. ");
INSERT INTO nhx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dios kimáꞌ iley Moisés iga yéj mate̱ne̱xtili, eꞌ ipan Jesucristo te̱ne̱xtilij kén iga te̱cho̱kiliá iwá̱n ayá̱ꞌ te̱kajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aya i̱ꞌ nokta agaj kita Dios; ise̱lpiltzi̱n, yej melaꞌse̱titoꞌ iwá̱n toTaj, yéj te̱ne̱xtilij kén in Dios. ");
INSERT INTO nhx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judiyojmej yej icha̱mej Jerusalén kiti̱tankej sacerdo̱tejmej iwá̱n levi̱tajmej iga maya̱ka̱n ka̱n onoꞌ Juan iwá̱n kitajtankej: —¿A̱ꞌyéj in tej? ");
INSERT INTO nhx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Iwá̱n Juan kinojma‑ijtoj: —Nej ayéj niCri̱stoj. ");
INSERT INTO nhx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iwá̱n sej kitajtankej: —¿A̱ꞌtaj yej in tej? ¿Ix tiprofe̱taj Elías? Juan kijtoj: —Ayéj. Iwá̱n kitajtankej: —¿Ixtaj tej in inó̱n profeta yej momatiá iga asiá? Kijtoj: —Ayéj. ");
INSERT INTO nhx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Iwá̱n kijlijkej: —¿A̱ꞌtaj yéj nokta in tej? Niknekij manikmati̱lti̱ka̱n yej ne̱ti̱tankej. ¿Té̱ wel anne‑ijliáj de tej? ");
INSERT INTO nhx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Juan kijtoj: —Nej inó̱n yej ijkí̱n kijtowa ipan desierto: “Xiktapowili̱ka̱n toTe̱ko se̱ weyi‑ojti yej melaktiꞌ” —ijkó̱n ken kijtoj el profeta Isaías. ");
INSERT INTO nhx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Yej tajto̱to̱yaj iwá̱n Juan, kiti̱tankej fariseojmej, ");
INSERT INTO nhx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","iwá̱n tatajtankej: —Sigataj ayéj tiCri̱stoj, niga ti‑Elías, niga tiprofe̱taj ¿Te ígataj titabautiza̱rowa? ");
INSERT INTO nhx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan kijtoj: —Nej nitabautiza̱rowa iga a̱ꞌti; eꞌ iwá̱n amejeme̱n onoꞌ se̱ yej ayá̱ꞌ anki̱xmatij ");
INSERT INTO nhx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","iwá̱n ne̱tokatiwi̱ꞌ, malej iga yéj tayaka̱ntoꞌ má̱j que nej. Nej aneajasi ni alí̱n iga manikxitomili imekayo igaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Inochi iní̱n mochij pan a̱ltepe̱ꞌ Betania, iyi̱ka̱mpa we̱ya̱ꞌ Jordán iki̱sáya̱mpa to̱nati̱ꞌ, ka̱n Juan tabautiza̱rojtoya. ");
INSERT INTO nhx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ipanya seꞌ día, Juan kitaꞌ Jesús iga kina̱ꞌtechojtiwi̱ꞌ, iwá̱n kijtoj: —Taꞌ xikitaka̱n, ini̱nwaꞌ in yej Dios iCorde̱roj yej wel kiperdona̱rowa yej aye̱kti yej kichij la gente. ");
INSERT INTO nhx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","De yéj nitajtoj kua̱ꞌ nikijtoj: “Notepotztaj wi̱ꞌ se̱ yej achto que nej, iga onóyaya achto que nej.” ");
INSERT INTO nhx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nej no̱ ayá̱ꞌ niki̱xmatiá; eꞌ nej nitabautiza̱rojtiwa̱laj iga a̱ꞌti, iga nokta la gente de Israel maki̱xmati. ");
INSERT INTO nhx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juan no̱ kijtoj: —Nej nikitaꞌ iyEspí̱ritoj Dios temoj ipan cielo ken se̱ jojtoko, iwá̱n sa̱liwito ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nej aya nikmatiá a̱ꞌyéj; eꞌ yej ne̱ti̱tan iga manitabautiza̱ro̱ki iga a̱ꞌti, ne‑ijlij: “Yej tikitas ipan yéj temowa iyEspí̱ritoj Dios iwá̱n moketza iyakapan, inó̱nyawaꞌ in yej tabautiza̱rowa iga iyEspí̱ritoj Dios.” ");
INSERT INTO nhx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nej niknojma‑ítaꞌya, iwá̱n nej nikijtowa iga yéj nokta iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ipanya seꞌ día, Juan onoya ómpasan sej iwá̱n o̱me yej kitokatinemiáj. ");
INSERT INTO nhx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Kua̱ꞌ kitaꞌ nemi panowa Jesús, Juan kijtoj: —¡Taꞌ xikitaka̱n, iné̱pawaꞌ in Dios iCorde̱roj! ");
INSERT INTO nhx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Iyo̱mexti̱n yej kitokatinemiáj Juan, kikakikej iga ijkó̱n kijtoj, iwá̱n kitokakej Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iwá̱n Jesús tacháꞌ tatepotztaj, iwá̱n kitaꞌ iga kitokatiawij, iwá̱n kijlijkej: —¿Té̱ ankite̱mowaj? Yejeme̱n kijtojkej: —Tamachtia̱ni, ¿ka̱n iná̱n ticha̱ntitoꞌ? ");
INSERT INTO nhx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesús kijtoj: —Xiwi̱tzeka̱n xikitakij. Iwá̱n yajkij iwá̱n kitakej ka̱n onoya. Inó̱n hora las cuatro tio̱takpan iwá̱n ompa tayowatiakej. ");
INSERT INTO nhx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés yej iyikni̱n Simón Pedro, se̱ de inó̱n o̱me̱n yej kikakikej Juan iwá̱n kitokakej Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrés, lo que kichij, achto yajki kite̱mo̱to iyikni̱n yej ito̱ka̱ꞌ Simón iwá̱n kijlij: —Nikasíkeja in Mesías —yej kijto̱jneki Cristo. ");
INSERT INTO nhx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Iwá̱n Andrés kiwi̱gaꞌ Simón ka̱n onoya Jesús, iwá̱n kua̱ꞌ Jesús kitaꞌ kijlij: —Tej tiSimó̱n, ipiltzi̱n Jonás, eꞌ iná̱n tia timoto̱ka̱wi̱ti Cefas —yej kijto̱jneki Pedro. ");
INSERT INTO nhx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ipanya seꞌ día, Jesús kiyo̱lmáꞌ iga yawi ipan íta̱l Galilea, iwá̱n kasiꞌ Felipe iwá̱n kijlij: —Xine̱toka. ");
INSERT INTO nhx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Iní̱n Felipe icha̱n katka a̱ltepe̱ꞌ Betsaida, ka̱nsan no̱ cha̱ntitoyaj Andrés iwá̱n Pedro. ");
INSERT INTO nhx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe yajki kite̱mo̱to Natanael, iwá̱n kijlij: —Nikasíkeja inó̱n ta̱gaꞌ yej Moisés ikyay kijkuiloj ipan libro de la ley, de Yéj no̱ kijkuilojkej profe̱tajmej. Ino̱nwaꞌ nokta Jesús yej ipiltzi̱n José yej icha̱n a̱ltepe̱ꞌ Nazaret. ");
INSERT INTO nhx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Kijtoj Natanael: —¿Ix wel ki̱sa tejté̱ yej ye̱kti ipan a̱ltepe̱ꞌ Nazaret? Felipe kijtoj: —Taꞌkiꞌ xikitaki. ");
INSERT INTO nhx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kua̱ꞌ Jesús kitaꞌ iga kina̱ꞌtechojtia̱ya Natanael, kijtoj: —Nigaj wi̱ꞌ se̱ yej melaꞌisraeli̱taj, yej ayí̱ꞌ takajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Iwá̱n Natanael tatajtan: —¿Kén iga tine‑i̱xmati? Iwá̱n Jesús kijlij: —Nej achto nimitzitaꞌ kua̱ꞌ Felipe aya mitzno̱tza, kua̱ꞌ tonoya itampa higue̱rajkuawiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael kijtoj: —Tamachtia̱ni, tej iPiltzi̱n Dios, tej tiRre̱y ipan Israel. ");
INSERT INTO nhx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesús kijtoj: —¿Ix tine̱cre̱dowa iga san nimitzijlij iga nimitzitaꞌ itampa higue̱rajkuawiꞌ? Tia‑oꞌ má̱j tikitati yej ayi̱ꞌpa mo‑ita que yej iná̱n nimitzijlij. ");
INSERT INTO nhx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","No̱ kijtoj Jesús: —Nimitznojma‑ijliáj, iga amejeme̱n anyawij ankitatij iga cielo tapojtoꞌ, iwá̱n iya̱ngelejmej Dios tejkawiskej iwá̱n temo̱skej ipan nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kua̱ꞌ panoj e̱yi día, mona̱miktilo̱ꞌ ipan a̱ltepe̱ꞌ Caná, ipan íta̱l Galilea. Iye̱ꞌ Jesús ompa onoya. ");
INSERT INTO nhx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús iwá̱n idisci̱polojmej no̱ mota̱lkej ka̱n mona̱miktilo. ");
INSERT INTO nhx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tamiꞌ vino, iwá̱n iye̱ꞌ Jesús kijtoj: —Ayꞌya kipiáj vino. ");
INSERT INTO nhx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesús kijtoj: —Nomá̱w, inó̱n tejemej ayá̱ꞌ tikmatij. Aya kajasi iga manimone̱xti a̱ꞌyéj nej. ");
INSERT INTO nhx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Iwá̱n María kijlij yej kiki̱xtijtoyaj vino: —Xikchi̱waka̱n nochi kensan Jesús mitzijliáj. ");
INSERT INTO nhx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ompa onoya seis a̱ko̱miꞌ de teꞌti, ka̱n judiyojmej kakiáj a̱ꞌti iga moe̱wi̱ltia̱yaj iga ijkó̱n kitekichi̱wayaj. Ipan sejsé̱ a̱ko̱miꞌ kitolowa̱ya ken cien litros a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús kijlij yej kiki̱xtijtoyaj vino: —Xikte̱mi̱ka̱n iga a̱ꞌti ini̱mej a̱ko̱mimej. Iwá̱n kakilijkej a̱ꞌti este yejye̱ꞌte̱miꞌ, ");
INSERT INTO nhx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","iwá̱n Jesús kijtoj: —Iná̱n xiki̱xti̱ka̱n alí̱n, iwá̱n xikui̱guili̱ka̱n yej mencarga̱rowa iní̱n ilwiꞌ. Ijkó̱n kichijkej. ");
INSERT INTO nhx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Iwá̱n yej kita̱lkej iga makita te̱ moneki ipan inó̱n ilwiꞌ, kimachi̱lij a̱ꞌti yej mochij vino, niga kimatiꞌ ka̱n wa̱laj; petz yej kiki̱xtijtoyaj vino kimatiáj iga yejeme̱n kajakijkej a̱ꞌti. Iwá̱n yej mencarga̱rowa ipan inó̱n ilwiꞌ, kino̱tzaꞌ chokotzi̱n yej mona̱miktiá, ");
INSERT INTO nhx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","iwá̱n kijlij: —Nó̱ya̱nsan ka̱n mona̱miktilo, achto mooniá vino yej má̱j ye̱kti, iwá̱n kua̱ꞌ te‑ikni̱wa̱n koníjkeja poxsan, mooniaya sej na̱mo̱lvi̱noj. Eꞌ tej tike̱naꞌ vino yej má̱j ye̱kti, este iná̱n‑oꞌ nemi mooniá. ");
INSERT INTO nhx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iní̱n yej Jesús kichij Caná ipan estado de Galilea, áchto‑oꞌ kichij milagro ka̱n kine̱xtij iweyipode̱r; iwá̱n idisci̱polojmej kicre̱dojkej ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kua̱ꞌ móchija inó̱n, yajki ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Capernaum, yajki iwá̱n iye̱ꞌ, iyikni̱wa̱n iwá̱n idisci̱polojmej; iwá̱n ayá̱ꞌ pox miaꞌ día ompa onoyaj. ");
INSERT INTO nhx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kua̱ꞌ na̱ꞌya iyilwi la Pascua yej kitekichi̱waj judiyojmej, Jesús yajki ipan weyi‑a̱ltepe̱ꞌ Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Iwá̱n pan ipa̱tiojyo weyitio̱pan kasito yej kinamakaj to̱rojmej, borre̱gojmej iwá̱n jojtokomej, iwá̱n yej e̱watoyaj iga kipatatoyaj na̱mo̱ltomi̱n iga tio̱pantomi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kua̱ꞌ inó̱n kitaꞌ, Jesús kikuiꞌ tájkol reata iga tamajmagaꞌ iwá̱n kiki̱xtij nochi ipan ipa̱tiojyo tio̱pan, iwa̱nya iborre̱gojmej iwá̱n ito̱rojmej. Iwá̱n yej kikambia̱rowa̱yaj tomi̱n kita̱tajkalilijkej ta̱lpan in tomi̱n iwá̱n kitzijtzi̱nkuepilijkej ime̱sajmej. ");
INSERT INTO nhx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Yej kinamakaj jojtokomej kijlij: —¡Inochi iní̱n xikijki̱xti̱ka̱n nigaj! ¡Amo xikchi̱waka̱n iga íkal noTaj mamokuepa ken kajli ka̱n monamaka kuajkuantas! ");
INSERT INTO nhx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Iwá̱n idisci̱polojmej kejla̱nkej yej ijkuilijtoꞌ pan itájto̱l Dios ka̱n kijtowa: “Poxsan nikneki íkal noDio̱s, inó̱n iga poxsan nikuesiwi.” ");
INSERT INTO nhx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Iwá̱n judiyojmej tatajtankej: —¿Te̱ wel anne̱ne̱xtiliáj iga mane̱si iga wel tikchi̱wa iní̱n yej tikchij? ");
INSERT INTO nhx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iwá̱n Jesús kijtoj: —Xikxiti̱naka̱n iní̱n tio̱pan, iwá̱n e̱yi día ne̱wi̱guili̱j iga sej nikojpachi̱was. ");
INSERT INTO nhx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Iwá̱n judiyojmej kijtojkej: —Cuarenta y seis años tekipano̱lo̱ꞌ iga mochij iní̱n tio̱pan; ¿ix e̱yi día mitzwi̱guili̱j iga sej tikojpachi̱was? ");
INSERT INTO nhx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Eꞌ inó̱n tio̱pan yej Jesús kijtojtoya, kijto̱jneki icue̱rpoj. ");
INSERT INTO nhx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Inó̱n iga, kua̱ꞌ Jesús ojpa‑isaꞌ ka̱n miktoya, idisci̱polojmej kejla̱nkej iní̱n yej kijtoj, iwá̱n kicre̱dojkej itájto̱l Dios yej ijkuilijtoꞌ iwá̱n tajto̱lmej yej Jesús kijtoj. ");
INSERT INTO nhx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Kua̱ꞌ Jesús onoya Jerusalén, ka̱n mo‑ilwichi̱wiliá la Pascua, miaꞌ kicre̱dojkej ipan yéj iga kitayaj kichijchi̱waya milagro. ");
INSERT INTO nhx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Eꞌ Jesús ayá̱ꞌ moconfia̱rowa̱ya ipan yejemej, iga Jesús ki̱xmatiáj nochi ino̱mej. ");
INSERT INTO nhx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Malej iga ayagaj kijlij kén kejla̱miki la gente, yéj kimatia̱ya ken kejla̱miki nochi gente. ");
INSERT INTO nhx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Onoya se̱ ta̱gaꞌ ito̱ka̱ꞌ Nicodemo, yéj fariseo katka, se̱ de ije̱fejmej judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nicodemo yajki tayowaka̱n kipaxa̱lowili̱to Jesús, iwá̱n kijlij: —Tamachtia̱ni, nikmatij iga Dios mitzti̱tan iga xine̱machti̱ka̱n, iga ayagaj wel kichi̱wa milagro ken yej tej tikchi̱wa siga Dios ayá̱ꞌ onoꞌ íwa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iwá̱n Jesús kijtoj: —Nimitznojma‑ijliá nokta, yej ayá̱ꞌ ojpanace̱rowa, awel kita ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemo tatajtan: —¿Kén wel maojpanace̱ro se̱ ta̱gaꞌ yej wé̱weja? ¿Ix wel sej ojpakalaki iyijtiko iye̱ꞌ iga maojpanace̱ro? ");
INSERT INTO nhx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iwá̱n Jesús kijtoj: —Nimitznojma‑ijliá, yej ayá̱ꞌ nace̱rowa iga a̱ꞌti iwá̱n iga Espíritu, awel kalaki ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ta̱gaꞌ wa̱n siwa̱ꞌ kitaj ipilowa̱n; eꞌ petz iyEspí̱ritoj Dios wel kichi̱wa iga ximochi̱wa ipiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo ximadmira̱do iga nimitzijliá: “Mitzpolowaj iga amonochi̱n xi‑ojpanace̱ro̱ka̱n sej.” ");
INSERT INTO nhx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ejekaꞌ nó̱ya̱nsan panowa, tikaki iga na̱wati, eꞌ ayá̱ꞌ tikmati ka̱n wi̱ꞌ niga ka̱n yawi. Ijko̱nsan no̱ inochi yej nace̱rowaj iga iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemo sej ki‑ojpatajtan: —¿In o̱n, ken a̱n iga mochi̱wa? ");
INSERT INTO nhx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesús kijtoj: —¿Tej yej tikmachtiá israeli̱tajmej, iwá̱n ayá̱ꞌ tikmati in iní̱n? ");
INSERT INTO nhx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nej nimitznojma‑ijliá iga nejemej nikijtowaj yejsan nikmatij, iwá̱n niknojma‑ijtowaj yej nikitákeja, eꞌ amejeme̱n ayá̱ꞌ ankicre̱dowaj yej nejemej nimitzijliáj. ");
INSERT INTO nhx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Siga ayá̱ꞌ anne̱cre̱dowaj kua̱ꞌ nej nimitzijliáj de yej onoꞌ ipan iní̱n ta̱jli, ¿kén anyawij anne̱cre̱do̱tij siga nimitzta̱tapo̱wiáj de yej onoꞌ ipan cielo? ");
INSERT INTO nhx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Aya agaj tejkawi ipan cielo, sino que yej temoj ipan cielo; ken tikijtowaj nej yej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ijkó̱n ken Moisés kua̱ꞌ ipan desierto kajkoꞌ pan kuawiꞌ se̱ kowa̱ꞌ yej chijtoꞌ iga tepos, ijkó̱n nej yej iPiltzi̱n Ta̱gaꞌ yawij neajkokuitij, ");
INSERT INTO nhx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","iga inochi yej mamoconfia̱ro̱ka̱n ipan nej, amo mapoliwika̱n, ma̱jwaꞌ nochipa maonoka̱n wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Dios poxsan kicho̱kilij inochimej yej onokej ipan iní̱n ta̱jli, este kimáꞌ ise̱lpiltzi̱n, iga inochi yej makicre̱do ipan yéj amo mapoliwi, ma̱jwaꞌ nochipa maono wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dios ayá̱ꞌ kiti̱tan iPiltzi̱n ipan iní̱n ta̱jli iga makijto iga makicastiga̱ro la gente, ma̱jwaꞌ iga makima̱nawi. ");
INSERT INTO nhx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yej kicre̱dowa ipan iPiltzi̱n Dios, ayoꞌ kicastiga̱ro̱skej iga kichij yej aye̱kti; eꞌ yej ayá̱ꞌ kicre̱dowa, Dios kíjtoja iga yawi kicastiga̱ro̱ti iga kichij yej aye̱kti iga ayá̱ꞌ kicre̱dowa ipan ise̱lPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yej ayá̱ꞌ kicre̱dowaj, onoꞌ iga yawij mikitij, iga kua̱ꞌ wa̱laj yej tata̱wi̱ko ipan iní̱n ta̱jli, má̱j kinekkej maonoka̱n ka̱n takomichka̱n iga kichi̱wayaj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Inochi yej kichi̱waj yej aye̱kti kijiyaj yej ye̱kti, iwá̱n ayá̱ꞌ kina̱ꞌtechowaj ta̱wi̱lyo̱ꞌ iga amo mamo‑ita yej kichijtokej. ");
INSERT INTO nhx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Eꞌ yej kichijtokej ken kijtowa itájto̱l Dios, kina̱ꞌtechowaj ta̱wi̱lyo̱ꞌ iga mane̱si iga kichijtokej ken kineki Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kua̱ꞌ tamiꞌ kijtoj iní̱n, Jesús yajki iwá̱n idisci̱polojmej ipan íta̱l Judea, ka̱n ka̱wiꞌ iwa̱mej iga tabautiza̱rojtoya. ");
INSERT INTO nhx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juan no̱ tabautiza̱rojtoya ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Enó̱n, iná̱ꞌ a̱ltepe̱ꞌ Salim, iga ompa onoya we̱ya̱ꞌ; iwá̱n la gente ya̱yaj iwá̱n mobautiza̱rowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Iní̱n mochij kua̱ꞌ Juan aya kipre̱sojwiáj. ");
INSERT INTO nhx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Eꞌ sekin yej kitokatinemiáj Juan pe̱wakej iga mote̱nki̱tzkijkej iwá̱n sekin judiyojmej, iga san kén iga moe̱wi̱ltilo iga maye̱ꞌonolo iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Iwá̱n yajkij kijli̱toj Juan: —Tamachtia̱ni, yej onoya mowa̱n a̱sentápal we̱ya̱ꞌ Jordán, iki̱sáya̱mpa to̱nati̱ꞌ, de inó̱n yej anne̱ta̱tapo̱wijkej de yéj, iná̱n nemi tabautiza̱rowa iwá̱n nochi gente kitoka. ");
INSERT INTO nhx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan kijtoj: —Ayagaj wel kipiá nité̱ siga Dios ayá̱ꞌ kimaka. ");
INSERT INTO nhx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Amejeme̱n nokta ane̱kakikej iga niknojma‑ijtoj iga nej ayéj niCri̱stoj, nejwaꞌ se̱ yej kiti̱tankej achto que yéj. ");
INSERT INTO nhx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ka̱n mona̱miktilo, chokótzi̱nwaꞌ in yej kipiá takotzi̱n; iwá̱n yej chokotzi̱n iyami̱goj yej ompa no̱ onoꞌ, san takaki, poxsan pa̱ki iga kikaktoꞌ nemi ta̱tapowa chokotzi̱n. Ijko̱nsan no̱ nej iná̱n nipoxyo̱lpa̱ki. ");
INSERT INTO nhx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Iná̱n yéj sej yawij kiweyimati̱lti̱tij, iwá̱n nej yawij neali̱mpamatitij. ");
INSERT INTO nhx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","’Ipiltzi̱n Dios yej wi̱ꞌ ajko inó̱n yej nochi kimanda̱rowa. Yej onoꞌ ipan ta̱jli inó̱n de nigaj, iwá̱n kijtowa de yej onoꞌ ipan ta̱jli. Eꞌ yej wi̱ꞌ ipan cielo inó̱n kimanda̱rowa nochi, ");
INSERT INTO nhx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","iwá̱n kijtowa yejsan kitaꞌ iwá̱n yej kikaguiꞌ; eꞌ ayagaj kicre̱dowa yej yéj kijtowa. ");
INSERT INTO nhx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Eꞌ siga agaj kicre̱dowa, kine̱xtiá iga yej Dios kijtowa ijko̱nya nokta; ");
INSERT INTO nhx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","pues yej Dios kiti̱tan, kijtowa tájto̱l yej Dios kijtowa, iga Dios nokta kimaka iyEspí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Te̱Taj kicho̱kiliá iPiltzi̱n, iwá̱n kimáꞌ iga wel makimanda̱ro inochi yej onoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yej kicre̱dowa ipan te̱Piltzi̱n, nochipa yawi onoti wa̱n Dios; eꞌ yej ayá̱ꞌ kineki kicre̱dowa ipan te̱Piltzi̱n, ayá̱ꞌ yawi onoti wa̱n Dios, sino que Dios yawi kicastiga̱ro̱ti poxsan. ");
INSERT INTO nhx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseojmej kimatikej iga Jesús má̱j komati gente kitokatinemiáj iwá̱n tabautiza̱rowa̱ya má̱j sej que Juan ");
INSERT INTO nhx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(malej iga ayejwaꞌ in Jesús yej tabautiza̱rowa̱ya, sino que idisci̱polojmej). ");
INSERT INTO nhx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Kua̱ꞌ Jesús kimatiꞌ yej mojtowa̱ya, ki̱saꞌ Judea wa̱n yajki sej Galilea. ");
INSERT INTO nhx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Inó̱n ojti ka̱n nemi ya̱ya, panowa̱ya ipan íta̱l Samaria. ");
INSERT INTO nhx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Inó̱n iga asiꞌ ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Sicar yej onoꞌ ipan íta̱l Samaria, na̱ꞌsan íta̱l José yej pox ikyay kimáꞌ itaj yej ito̱ka̱ꞌ Jacob. ");
INSERT INTO nhx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ompa onoya pozo yej Jacob kichij. Jesús siawiꞌ iga nejnen, mota̱lij po̱sojte̱noj ken tajkodía. ");
INSERT INTO nhx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wa̱laj se̱ siwa̱ꞌ de Samaria a̱takuiko, iwá̱n Jesús kijlij: —Achi xine̱maka a̱ꞌti manikoni. ");
INSERT INTO nhx_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Íkua̱ꞌ idisci̱polojmej yájkija ipan a̱ltepe̱ꞌ kikowatoj te̱ kikuaj. ");
INSERT INTO nhx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Siwa̱ꞌ de Samaria kijtoj: —¿Te iga tine̱tajtaniliá a̱ꞌti iga xikoni, tej tijudiyoj, iwá̱n nej nisiwa̱ꞌ de Samaria? (Iga judiyojmej iwá̱n samarita̱nojmej ayá̱ꞌ moye̱ꞌitayaj.) ");
INSERT INTO nhx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesús kijtoj: —Siga tikmatiá katka yej Dios tamaka iwá̱n a̱ꞌyéj nej yej nemi nimitztajtaniliá a̱ꞌti, tej tine̱tajtanilia̱ya, iwá̱n nimitzmakaya a̱ꞌti yej isatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Siwa̱ꞌ kijtoj: —Esi atikpiá ga te̱ tiki̱xtiá a̱ꞌti, iwá̱n pozo poxsan wejkatan. ¿Ka̱n tia tikasiti a̱ꞌti yej isatoꞌ iga xine̱maka? ");
INSERT INTO nhx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Notajwe̱wejmej Jacob ne̱ka̱wilijkej iní̱n pozo, yéj no̱ nigaj kiki̱xtia̱ya a̱ꞌti iga konia̱ya iwá̱n ipilowa̱n iwá̱n iyo̱lka̱mej. In tej, ¿ix ma̱jya sej que yéj? ");
INSERT INTO nhx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesús kijtoj: —Nochi yej koniáj ini̱mpa a̱ꞌti, sejoꞌ a̱tanekiskej; ");
INSERT INTO nhx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","eꞌ yej makoni a̱ꞌti yej nej nia nikmakati, ayí̱ꞌoꞌ a̱tanekis. Iga inó̱n a̱ꞌti yej nikmakas, ki̱stos ipan yéj ken se̱ a̱tzontekon yej kichi̱wa iga wel maono nochipa wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Siwa̱ꞌ kijtoj: —Áchiwaꞌ xine̱maka in ino̱mpa a̱ꞌti, iga ayꞌya mani‑a̱taneki iwá̱n ayꞌ maniki̱ki̱xti̱ki nigaj. ");
INSERT INTO nhx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús kijtoj: —Xaj xikno̱tzati mowe̱wej iwá̱n xiwi̱ki sej. ");
INSERT INTO nhx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Siwa̱ꞌ kijtoj: —Ayá̱ꞌ niwe̱wejyoj. Jesús kijlij: —Ómpaya ken tikijtoj iga ayá̱ꞌ tiwe̱wejyoj; ");
INSERT INTO nhx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","iga tikasíkaya cinco mowe̱wej, iwá̱n yej iná̱n tikpiá ayéj mowe̱wej. Ómpaya nokta ken tikijtoj. ");
INSERT INTO nhx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kua̱ꞌ iní̱n kikaguiꞌ siwa̱ꞌ, kijtoj: —Nej nikita iga tej tiprofe̱taj. ");
INSERT INTO nhx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Notajwe̱wetkej, samarita̱nojmej, kiweyimati̱ltijkej Dios nigaj ipan iní̱n tepe̱ꞌ; eꞌ amejeme̱n anjudiyojmej ankijtowaj iga Jerusale̱nsan petz ómpasan wel moweyimati̱ltiá Dios. ");
INSERT INTO nhx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesús kijtoj: —Tej xine̱cre̱do, yawi asiti hora iga amejeme̱n anyawij ankiweyimati̱lti̱tij toTaj, ayꞌya anwi̱tzeskej ipan iní̱n tepe̱ꞌ niga anyá̱skejoꞌ Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Amejeme̱n ansamarita̱nojmej ayá̱ꞌ ankimatij a̱ꞌyéj ankiweyimati̱ltiáj; eꞌ nejeme̱n nikmatij a̱ꞌyéj nemi nikweyimati̱ltiáj, puej Dios kitapejpen judiyojmej iga pan nejemej maki̱sa yej tasalva̱rowa. ");
INSERT INTO nhx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Eꞌ asis hora, iwá̱n ina̱nya nokta kua̱ꞌ yej kimelaꞌweyimati̱ltiáj toTaj, yawij kichi̱watij ijkó̱n ken kineki iyEspí̱ritoj Dios. Iga toTaj ijkó̱n kineki makichi̱waka̱n yej kiweyimati̱ltiáj. ");
INSERT INTO nhx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Dio̱swaꞌ Espíritu, iwá̱n yej kiweyimati̱ltiáj makichi̱waka̱n ken kajasi, ijkó̱n ken kineki Dios iyEspí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Siwa̱ꞌ kijtoj: —Nej nikmati iga yawi wi̱tzeti in Mesías —yej kito̱jneki Cristo—; iwá̱n kua̱ꞌ yéj mawi̱ki, nochi ne̱nojma‑ijli̱skej yej ayá̱ꞌ nikmatij. ");
INSERT INTO nhx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesús kijtoj: —Ino̱nwaꞌ nej, yej nemi ta̱tapowa mowa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Iwá̱n íkua̱ꞌ asikej idisci̱polojmej, iwá̱n san tajtachi̱xtikajkej iga kitakej Jesús ta̱tapojtoꞌ iwá̱n siwa̱ꞌ. Eꞌ ayagaj mi̱xe̱wij iga makitajtani te̱ kinekiá inó̱n siwa̱ꞌ, o te̱ kipojtoyaj. ");
INSERT INTO nhx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Siwa̱ꞌ kikajtej iya̱ko̱n iwá̱n yajki a̱ltepe̱ꞌ, iwá̱n kijlij la gente: ");
INSERT INTO nhx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Xikitatij se̱ ta̱gaꞌ yej ne̱nojma‑ijlij inochi yej nikchij. ¿Ix ayéj a̱n ini̱nya in Mesías? ");
INSERT INTO nhx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Iwá̱n ki̱skej ipan a̱ltepe̱ꞌ iga yajkij ka̱n onoya Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mie̱j disci̱polojmej kitejtekiꞌijlijtoyaj Jesús: —Tamachtia̱ni, achi xitakua. ");
INSERT INTO nhx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Eꞌ yéj kijtoj: —Nej nikpiá tákual yej amejeme̱n ayá̱ꞌ anki̱xmatij. ");
INSERT INTO nhx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Iwá̱n idisci̱polojmej pe̱wakej iga mose̱sepantajtanij: —¿Ix ayá̱ꞌ a̱n kiwajliguilijkej tejté̱ yej kikuaj? ");
INSERT INTO nhx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Eꞌ Jesús kijtoj: —Iga manikchi̱wa ken kineki yej ne̱ti̱tan, iwá̱n maniktamili itekipáno̱l; ino̱nwaꞌ in notákual. ");
INSERT INTO nhx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Amejeme̱n ankijtowaj: “Políwi‑oꞌ cuatro meses iga la cosecha”; eꞌ nej nimitzijliáj: Xikitaka̱n mi̱jlimej, chika̱ꞌya yej motojto̱gaꞌ iwá̱n welja moteki. ");
INSERT INTO nhx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yej kinechkowa yej kiki̱xtiá pan mi̱jli, Dios yawi kimakati yej ye̱kti. Iwá̱n yej kicre̱dowaj, nochipa onoskej wa̱n Dios iga yej kipowa itájto̱l Dios iwá̱n yej kinechkowa yej kiki̱xtiá pan mi̱jli, masempa̱kika̱n. ");
INSERT INTO nhx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iga melá̱ꞌ nokta ken yej mojtowa: “Se̱waꞌ in yej kito̱ka, iwá̱n seꞌ in yej kinechkowa yej kiki̱xtiá pan mi̱jli.” ");
INSERT INTO nhx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nej nimitzti̱tankej amejeme̱n iga xikosecha̱ro̱ka̱n ka̱n ayá̱ꞌ antekipanojkej; séwoꞌwaꞌ in yej tekipanojkej, eꞌ amejéme̱nwaꞌ in yej ankitekij yej yejeme̱n kito̱kkej. ");
INSERT INTO nhx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Miaꞌ yej cha̱ntitokej ipan inó̱n a̱ltepe̱ꞌ de Samaria kicre̱dojkej Jesús iga ijkí̱n kijtoj siwa̱ꞌ: “Ne‑ijlij inochi yej nikchij.” ");
INSERT INTO nhx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Iwá̱n kua̱ꞌ asikej yej wa̱lkej Samaria, kitejtekiꞌijlijkej Jesús iga maká̱wi‑oꞌ iwá̱n yejeme̱n. Yéj ka̱wiꞌ ompa o̱me días, ");
INSERT INTO nhx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","iwá̱n miaꞌ má̱j kicre̱dojkej iga kikakikej yej yéj kijtowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Iwá̱n kijlijkej siwa̱ꞌ: —Iná̱n nicre̱dowaj, ayejsan iga inó̱n yej tej anne‑ijlijkej, sino que iga nejeme̱n no̱ nikakikej iwá̱n nikmatij iga yéj nokta in Cristo yej kisalva̱rowa nochi gente yej onoꞌ ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kua̱ꞌ pánoja inó̱n o̱me días, Jesús ki̱saꞌ Samaria iwá̱n yajki ipan íta̱l Galilea. ");
INSERT INTO nhx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Porque Jesús kijtoj iga nisé̱ profeta ayá̱ꞌ kiye̱ꞌitaj ipan iya̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kua̱ꞌ asiꞌ Galilea, yej ompa cha̱ntitoyaj ki‑o̱mema̱wijkej Jesús, iga la gente no̱ yajkaj Jerusalén iga kilwichi̱wili̱toyaj la Pascua iwá̱n kitakej inochi yej íkua̱ꞌ kichij Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús yajki sej a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Caná yej onoꞌ estado de Galilea, ka̱n kichij vino iga a̱ꞌti. Iwá̱n ompa onoya se̱ ta̱gaꞌ yej itekipanowa̱ni el rey. Inó̱n ta̱gaꞌ icha̱n a̱ltepe̱ꞌ Capernaum wa̱n we̱titoya ipiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kua̱ꞌ inó̱n tekipanowa̱ni kimatiꞌ iga Jesús kí̱saꞌya Judea iwá̱n ásiꞌya Galilea, yajki kitato iwá̱n kitejtekiꞌijlij iga mayawi icha̱n iga maki‑achitialti ipiltzi̱n, yej mikisnekiaya. ");
INSERT INTO nhx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesús kijtoj: —Amejeme̱n ayá̱ꞌ ankicre̱dowaj, siga ayá̱ꞌ ankitaj tejté̱ yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Eꞌ inó̱n tekipanowa̱ni kijtoj: —NoTe̱ko, nimaní̱n xaj, mie̱j aya miki nopiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesús kijtoj: —Xaj mocha̱n; mopiltzi̱n isatoꞌ. Inó̱n ta̱gaꞌ kicre̱doj yej Jesús kijlij, iwá̱n yajki. ");
INSERT INTO nhx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Mie̱j asitia̱ya icha̱n, itekipanowa̱nimej ki̱xna̱mikitoj iwá̱n kijlijkej: —¡Mopiltzi̱n isatoꞌ! ");
INSERT INTO nhx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yéj kitajtan itekipanowa̱nimej te̱ hora pe̱waꞌ iga yé̱ktiya kimachi̱lij ipiltzi̱n, iwá̱n kijlijkej: —Ya̱lwa a la una de la tarde pojpoliwiꞌ iga kawa̱ntoya. ");
INSERT INTO nhx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Te̱taj kejla̱n iga inó̱n hora nokta kua̱ꞌ Jesús kijlij: “Mopiltzi̱n isatoꞌ”; iwá̱n yéj iwá̱n inochi ifami̱liaj kicre̱dojkej ipan Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iga ini̱nya o̱me ve̱j Jesús kichij milagro kua̱ꞌ yajki Galilea iga ki̱saꞌ Judea. ");
INSERT INTO nhx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Má̱j má̱j judiyojmej nemi ilwichi̱wayaj ken kitekimakaj itájto̱l Dios, iwá̱n Jesús yajki sej Jerusalén ka̱n nentoꞌ ilwiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ipan inó̱n a̱ltepe̱ꞌ, ite̱noj puerta yej ito̱ka̱ꞌ borre̱gojmej onoya se̱ a̱yawalwé̱j, ipan hebreo ito̱ka̱ꞌ Betesda, kipiá cinco itasejka̱nyo. ");
INSERT INTO nhx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ompa wejwetztoyaj komati yej we̱titokej, pachamej, ko̱xomej iwá̱n sekin yej awel mo̱li̱nayaj yej kichi̱xtoyaj mamo̱li̱na a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Iga kua̱ꞌsan iyá̱ngel Dios temowa̱ya ipan a̱ꞌti iwá̱n kipe̱peya̱waltia̱ya; iwá̱n yej achto kalakiá ipan a̱ꞌti, kua̱ꞌ pachiwiá iga pe̱peya̱waya, achitiaya san katiapa kokolis makipiá. ");
INSERT INTO nhx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ompa onoya se̱ ta̱gaꞌ yej we̱titoya treinta y ocho años. ");
INSERT INTO nhx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Kua̱ꞌ Jesús kitaꞌ iga ompa wetztoꞌ, kimatiꞌ iga ikyay ompa onoꞌ, kitajtan: —¿Ix tikneki xi‑achitiá? ");
INSERT INTO nhx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Yej we̱titoꞌ kijtoj: —NoTe̱ko, ayagaj ne‑akiá a̱tampa kua̱ꞌ pe̱peya̱waya a̱ꞌti. Kua̱ꞌ nikneki manikalaki, sewoꞌ achto kalaki. ");
INSERT INTO nhx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesús kijlij: —Ximoketza, xikui motapech iwá̱n xaja. ");
INSERT INTO nhx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Íkua̱ꞌsan in inó̱n ta̱gaꞌ achitiáꞌ, kikuiꞌ itapech iwá̱n pe̱waꞌ nejnen. Eꞌ como inó̱n día mose̱wilo, ");
INSERT INTO nhx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","judiyojmej kijlijkej yej achitiáꞌ: —Iní̱n día mose̱wilo; aye̱kti iga xikui̱ga motapech. ");
INSERT INTO nhx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Inó̱n ta̱gaꞌ kijtoj: —Yej neachitialtij, ne‑ijlij: “Xikui motapech iwá̱n xaja.” ");
INSERT INTO nhx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yejeme̱n kitajtankej: —¿A̱ꞌyéj in inó̱n yej mitzijlij: “Xikui motapech iwá̱n xaja”? ");
INSERT INTO nhx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Eꞌ inó̱n ta̱gaꞌ ayá̱ꞌ kimatiá a̱ꞌyéj kachitialtij, iga Jesús kajka̱kalaꞌ tatza̱tza̱la̱n, inó̱n iga aki̱xmatiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Iwá̱n Jesús kasiꞌ weyitio̱pan in inó̱n yej kachitialtij, iwá̱n kijlij: —Taꞌ xine̱kaki, iná̱n ti‑achitiaꞌya, ayꞌya xikchi̱wa yej aye̱kti, iga amo ma̱jya sej tiwe̱tiás. ");
INSERT INTO nhx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iwá̱n inó̱n ta̱gaꞌ yajki, iwá̱n kijlij judiyojmej iga Jesu̱swaꞌ in yej ki‑achitialtij. ");
INSERT INTO nhx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Inó̱n iga judiyojmej kite̱mowa̱yaj Jesús iwá̱n kimikti̱jnekiáj, iga taachitialtia̱ya ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Eꞌ Jesús kijtoj: —NoTaj nochipa tekipanowa, iwá̱n nej no̱ nitekipanowa. ");
INSERT INTO nhx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Inó̱n iga judiyojmej ma̱jya kimikti̱jnekiáj Jesús, ayejsan iga ayá̱ꞌ kichi̱waya ken tatekimaka la ley iga amo matekipano ipan día kua̱ꞌ mose̱wilo, no̱ kijtowa̱ya iga iTaj Dios, ijkó̱n kijto̱jneki iga yéj no̱ Dios. ");
INSERT INTO nhx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iwá̱n Jesús kijtoj: —Nimitznojma‑ijliáj iga nej yej iPiltzi̱n Dios nose̱lti awel nikchi̱wa nité̱; nikchí̱wasan petz yejsan nikita iga kichi̱wa noTaj. Inochi yej kichi̱wa noTaj, no̱ nikchi̱wa nej yej nite̱Piltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","NoTaj ne̱poxcho̱kiliá iwá̱n ne̱ne̱xtiliá inochi yej kichi̱wa; iwá̱n yáwi‑oꞌ má̱j ne̱ne̱xtili̱ti miaꞌ yej ayagaj wel kichi̱wa, iga inó̱n ankitaskej, te anmoyo̱lmajti̱skej. ");
INSERT INTO nhx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Iga ijkó̱n ken noTaj kixitiá yej miktokej iwá̱n kimaka vida, no̱ nej yej te̱Piltzi̱n yej nej niknekis, nikmakas vida. ");
INSERT INTO nhx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Te̱Taj ayá̱ꞌ tajuzga̱rowa, nej yej iPíltzi̱nya ne̱máꞌ iga wel manitajuzga̱ro, ");
INSERT INTO nhx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","iga inochi gente mane̱weyimati̱lti nej yej te̱Piltzi̱n kensan noTaj no̱ kiweyimati̱ltiáj. Yej ayá̱ꞌ kiweyimati̱ltiáj te̱Piltzi̱n, ayá̱ꞌ no̱ kiweyimati̱ltiá noTaj yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Nimitznojma‑ijliáj: Yej kikaki yej nikijtowa iwá̱n kicre̱dowa ipan yej ne̱ti̱tan, nochipa yawi onoti wa̱n Dios; ayoꞌ mojto̱j iga makicastiga̱ro̱ka̱n iga kichij yej aye̱kti, mikíkaya wa̱n ojpa‑ísaꞌya sej. ");
INSERT INTO nhx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nimitznojma‑ijliáj, iga yawi asiti la hora, iwá̱n á̱mansan nokta, kua̱ꞌ yej miktokej yawij kikakitij notájto̱l nej yej iPiltzi̱n Dios; iwá̱n yej kicre̱do̱skej yawij isatij. ");
INSERT INTO nhx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Iga noTaj Dios wel tamaka vida, no̱ ne̱máꞌ nej yej iPiltzi̱n iga manitamaka vida. ");
INSERT INTO nhx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Iwá̱n ne̱máꞌ poder iga wel manitajuzga̱ro, iga nej iPiltzi̱n Ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo ximoyo̱lmajti̱ka̱n iga iní̱n nikijtowa, iga yawi asiti kua̱ꞌ nochi yej miktokej yawij kikakitij notájto̱l ");
INSERT INTO nhx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","iwá̱n kijki̱saskej kajka̱n to̱ktokej. Yej kichijkej yej ye̱kti, yawij ojpa‑isatij iwá̱n nochípaya onoskej wa̱n Dios; eꞌ yej kichijkej yej aye̱kti, yawij ojpa‑isatij iga yawij kicastiga̱ro̱tij. ");
INSERT INTO nhx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Nej awel nikchi̱wa nité̱ yej nejsan nikneki. Nitajuzga̱rowa ijkó̱n ken ne̱tekimaka noTaj, iwá̱n yej nej nikchi̱wa ijko̱nya nokta, iga ayá̱ꞌ nemi nikchi̱wa ken nej nikneki, sino que nemi nikchi̱wa ijkó̱n ken kineki toTaj yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Siga nejsan katka manikijto iga ómpaya ken nikchijtoꞌ, wel mojtowa iga nemi nitakajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Eꞌ onoꞌ sewoꞌ yej ye̱ꞌta̱tapowa iga nej, iwá̱n nej nikmati iga inó̱n yej nemi ye̱ꞌtajtowa iga nej, ayá̱ꞌ takajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Amejeme̱n ankiti̱tankej yej makitajtanitij Juan, iwá̱n yej yéj kijtoj, melá̱ꞌ nokta. ");
INSERT INTO nhx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Eꞌ nej ayá̱ꞌ nikneki iga agaj maye̱ꞌtajto de nej, iní̱n nikijtowa iga xicre̱do̱ka̱n yej kijtoj Juan wa̱n ximosalva̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan kua̱ꞌ tamachtij, itájto̱l ken tikita katka se̱ tiꞌti yej we̱welo̱ntoya iwá̱n ta̱wia̱ya, iwá̱n amejeme̱n ankinekikej xipa̱kika̱n iga inó̱n tiꞌti yej ayá̱ꞌ wejkaj mitzta̱wijtoyaj. ");
INSERT INTO nhx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Eꞌ nej nikpiá ka̱n niktaksaltiá notájto̱l, má̱j ye̱kti que yej kijtoj Juan. Yej nej nikchi̱wa, inó̱n yej toTaj ne‑ijlij iga manikchi̱wa, iwá̱n inó̱n yej nikchi̱wa, kine̱xtiá iga kena, toTaj ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Iwá̱n toTaj yej ne̱ti̱tan, no̱ ye̱ꞌtajtowa iga nej, iwá̱n amejeme̱n ayí̱ꞌ ankikakij itájto̱l, niga ayí̱ꞌ ankitaj, ");
INSERT INTO nhx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","niga ankipiáj itájto̱l ipan amoa̱lmajmej iga ayá̱ꞌ ankicre̱dowaj ipan nej yej ne̱ti̱tan toTaj. ");
INSERT INTO nhx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Amejeme̱n anmoye̱ꞌmachtiáj itájto̱l Dios, iga amejeme̱n ankijtowaj iga wel ompa ankasij yej mitzne̱xtiliáj kén wel xonoka̱n nochipa wa̱n Dios; ompa ka̱n ijkuilijtoꞌ tajtowa de nej, ");
INSERT INTO nhx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","eꞌ amejeme̱n ayá̱ꞌ ankinekij xine̱techo̱ka̱n iga xonoka̱n nochipa wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Nej ayá̱ꞌ nikneki agaj maye̱ꞌtajto de nej. ");
INSERT INTO nhx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Iwá̱n nej nimitzi̱xmatij, iwá̱n nikmati iga ayá̱ꞌ ankinekij Dios. ");
INSERT INTO nhx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nej ne̱ti̱tan noTaj, iwá̱n amejeme̱n ayá̱ꞌ anne̱tajto̱lkuij; iwá̱n siga seꞌ mayokawi̱ki yej ayagaj kiti̱tan, inó̱n sí ankitajto̱lkui̱li̱skej. ");
INSERT INTO nhx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Kén wel anne̱cre̱do̱skej, siga amejéme̱nsan ankinekij iga tokni̱mej mamitzweyimati̱lti̱ka̱n, iwá̱n ayí̱ꞌ annemij ken kajasi iga Dios mamitzye̱ꞌitaka̱n? ");
INSERT INTO nhx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo ankijto̱skej iga nej nimitzte̱lwi̱skej iyi̱xtaj noTaj; yejwaꞌ mitzte̱lwiáj Moisés, yej amejeme̱n ípan anmoconfia̱rojtokej. ");
INSERT INTO nhx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Siga katka amejeme̱n xicre̱do̱ka̱n yej Moisés kijtoj, nej no̱ katka anne̱cre̱dowa̱yaj, iga yej kijkuiloj Moisés tajtowa de nej. ");
INSERT INTO nhx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Eꞌ siga ayá̱ꞌ ankicre̱dowaj yej yéj kijkuiloj, ¿kén anyawij ankicre̱do̱tij yej nimitzijliáj? ");
INSERT INTO nhx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kua̱ꞌ Jesús tamiꞌ tajtoj, yajki iyi̱ka̱mpa lago de Galilea, yej no̱ ito̱ka̱ꞌ lago de Tiberias. ");
INSERT INTO nhx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Miaꞌ kitokatinemiáj iga kitakej kichij milagro kua̱ꞌ kachitialtijtinemiꞌ yej we̱titokej. ");
INSERT INTO nhx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iwá̱n Jesús tejkaj ipan tepe̱ꞌ iwá̱n ompa mota̱lij iwá̱n idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Na̱ꞌya katka iga la Pascua, yej iyilwi judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Kua̱ꞌ Jesús kitaꞌ iga pox komati yej nemi asij, kijlij Felipe: —¿Ka̱n tia̱skej tikowatij tákual iga inochi ini̱mej gente? ");
INSERT INTO nhx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Inó̱n kijtoj iga makikaki te̱ kijto̱j Felipe, iga Jesús kimatiá te̱ yawi kichi̱wati. ");
INSERT INTO nhx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe kijtoj: —Ke̱ꞌ se̱ kita̱niá ocho meses ni alí̱n ayá̱ꞌ kimaka iga matikowaka̱n tákual iga matikmajmakaka̱n ajachi ini̱mej gente. ");
INSERT INTO nhx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Iwá̱n Andrés yej iyikni̱n Simón Pedro, yej no̱ idiscí̱poloj Jesús, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Nigaj onoꞌ se̱ choochi̱n, kipiá cinco pa̱n de cebada iwá̱n o̱me to̱poj; eꞌ iní̱n ni alí̱n ayá̱ꞌ kimaka iga poxsan timiakejmej. ");
INSERT INTO nhx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iwá̱n Jesús kijtoj: —Xikijli̱ka̱n inochi mamota̱li̱ka̱n. Ompa onoya sakatzitzi̱n, iwá̱n motajta̱lijkej ken cinco mil tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iwá̱n Jesús kikuiꞌ ino̱mej pa̱n, kua̱ꞌ támiꞌya kimáꞌ gracias Dios, kimajmáꞌ idisci̱polojmej iga yejemej makimajmakaka̱n yej eje̱watoyaj. Ijko̱nsan no̱ kichij iwá̱n to̱poj, kimajmakakej este ke̱ꞌ kinekikej. ");
INSERT INTO nhx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kua̱ꞌ ixwíkeja, Jesús kijlij idisci̱polojmej: —Inochi xiknechko̱ka̱n yej ayꞌ kikuajkej, iga amo mapetzpoliwi nité̱. ");
INSERT INTO nhx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Yejeme̱n nochi kikuikej, iwá̱n kite̱mijkej doce chikiwimej ita̱tajkolka yej ayꞌya mokuaj de inó̱n cinco pa̱n de cebada. ");
INSERT INTO nhx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kua̱ꞌ la gente kitaꞌ iga Jesús kichij milagro, kijtojkej: —Kena, iní̱n profeta yej momatiá iga yawi wi̱tzeti ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Eꞌ como Jesús kimatiꞌ iga kinekiáj makitekiꞌwi̱gaka̱n iga makita̱li̱ka̱n de rey, ki̱saꞌ ompa, iwá̱n yajki iyi̱xko tepe̱ꞌ, iga kinekiá maono ise̱lti. ");
INSERT INTO nhx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kua̱ꞌ tayowátiꞌya, idisci̱polojmej Jesús yajkij laguna, ");
INSERT INTO nhx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tejkajkej ipan se̱ á̱ka̱l iwá̱n pe̱wakej a̱panowaj iga maasika̱n Capernaum. Inó̱n hora melaꞌtakomíchka̱nya nokta, iwá̱n Jesús aya asiá. ");
INSERT INTO nhx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Iwá̱n íkua̱ꞌ pe̱waꞌ ejekaꞌ yej pox tajpalej iwá̱n mopa̱palakachowa̱ya a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kua̱ꞌ nejnénkeja ipan á̱ka̱l ken cinco o seis kilómetros, kitakej Jesús iga nejnentiwi̱ꞌ iyi̱xko a̱ꞌti iga kina̱ꞌtechojtiwi̱ꞌ á̱ka̱l, iwá̱n majmawikej. ");
INSERT INTO nhx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesús kijtoj: —¡Nej niJesús, amo ximajmawika̱n! ");
INSERT INTO nhx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Iwá̱n yejeme̱n tao̱mema̱wijkej iga kitejkawi̱ltijkej Jesús ipan á̱ka̱l, iwá̱n nimani̱nsan asikej ompiga ka̱n nemi ya̱yaj. ");
INSERT INTO nhx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ipanya seꞌ día, yej ka̱wikej iyi̱ka̱mpa a̱ꞌti, kimatikej iga Jesús idisci̱polojmej yajkij ipan inó̱n se̱tzi̱n á̱ka̱l yej ompa onoya, iwá̱n Jesús ayá̱ꞌ ya̱ya iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mie̱j seꞌ a̱ka̱lmej asikej yej ki̱skej ipan a̱ltepe̱ꞌ Tiberias, asikej na̱ꞌsan ka̱n takuajkej kua̱ꞌ toTe̱ko kimáꞌ gracias Dios iga tákual. ");
INSERT INTO nhx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Inó̱n iga kua̱ꞌ la gente kitakej iga ompa ateyi Jesús, niga idisci̱polojmej, tejtejkajkej ipan a̱ka̱lmej iwá̱n yajkij Capernaum iga kite̱mo̱toj. ");
INSERT INTO nhx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kua̱ꞌ yejeme̱n asikej iyi̱ka̱mpa laguna, kasikej Jesús iwá̱n kitajtankej: —Tamachtia̱ni, ¿ke̱man tiwa̱laj nijiga? ");
INSERT INTO nhx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesús kijtoj: —Nej nikijtowa iga amejeme̱n ane̱te̱mojtinemij iga san antakuajkej este amixwikej, ayéj iga ankicre̱dojkej yej ankitakej iga nikchi̱wa milagro. ");
INSERT INTO nhx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amo xitekipano̱ka̱n iga san tákual yej tami, sino que iga tákual yej kichi̱wa iga xonoka̱n nochipa wa̱n Dios. Inó̱mpawaꞌ in tákual yej nia nimitzmakatij, nej yej iPiltzi̱n Ta̱gaꞌ, iga Dios yej tóTajpa kijlij iga ijkó̱n makichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kitajtankej: —¿Te̱ nikchi̱waskej iga manikchi̱waka̱n ken Dios kineki? ");
INSERT INTO nhx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesús kijtoj: —Dios kineki iga xicre̱do̱ka̱n ipan inó̱n yej yéj kiti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Iwá̱n kitajtankej: —¿Te̱ milagro wel anne̱ne̱xtiliáj iga manikitaka̱n iga manimitzcre̱do̱ka̱n? ¿Te̱ wel tikchi̱wa? ");
INSERT INTO nhx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ikya notajwe̱wejmej kikuajkej maná ipan desierto, ken kijtowa ka̱n ijkuilijtoꞌ: “Dios kimáꞌ ino̱mej iga makikua̱ka̱n pa̱n yej wa̱laj ipan cielo.” ");
INSERT INTO nhx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesús kijtoj: —Nej nimitzijliáj: Ayéj Moisés yej tamajmaka pa̱n yej wi̱ꞌ ipan cielo, sino que noTaj yej tamajmaka in melaꞌpa̱n yej wi̱ꞌ ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Iga inó̱n pa̱n yej Dios tamaka, inó̱n yej temoj ipan cielo, iwá̱n kimaka vida nochi gente. ");
INSERT INTO nhx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Iwá̱n yejeme̱n kijtojkej: —NoTe̱ko, nochipa xine̱makaka̱n ino̱mpa pa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iwá̱n Jesús kijtoj: —Nejwaꞌ in inó̱n pa̱n yej tamaka vida. Yej ne̱toka ayí̱ꞌ yawi maya̱nati; iwá̱n yej ne̱cre̱dowa, ayí̱ꞌ yawi a̱tanekiti. ");
INSERT INTO nhx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Eꞌ ken nimitzijlíjkeja, ayá̱ꞌ anne̱cre̱dowaj, malej iga anne‑itákeja. ");
INSERT INTO nhx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochi yej toTaj ne̱maka, ne̱tokaj; iwá̱n yej ne̱tokaj, aniksenkokajte̱waskej. ");
INSERT INTO nhx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Iga nej ayá̱ꞌ niwa̱laj ipan cielo iga san manikchi̱waki kensan nikneki, sino que iga manikchi̱wa ken kineki yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Iwá̱n ijkí̱n kineki toTaj yej ne̱ti̱tan; iga amo manikpolo nisé̱ yej yéj ne̱ti̱tanilij, sino que manikojpa‑ixiti ke̱man kua̱ꞌ yéj wi̱ꞌ tajuzga̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yej ne̱ti̱tan kineki iga inochi yej kitachi̱liá iPiltzi̱n Dios, iwá̱n kicre̱dowa ipan yéj, nike̱man ayꞌya mikis, iwá̱n nej nia nikojpa‑ixiti̱ti kua̱ꞌ Dios wi̱ꞌ tajuzga̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Inó̱n iga judiyojmej pe̱wakej kipo̱powakej Jesús, iga sankiꞌ kijtoj: “Nej nipa̱n yej temoj ipan cielo.” ");
INSERT INTO nhx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Iwá̱n kijtojkej: —¿In iní̱n ayejtaj Jesús yej ipiltzi̱n José? Tejeme̱n tiki̱xmatij itaj iwá̱n iye̱ꞌ. ¿Iwá̱n iná̱n kijtowa igakiꞌ temoj ipan cielo? ");
INSERT INTO nhx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iwá̱n Jesús kijtoj: —Ayꞌya xine̱po̱pojtoka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ayagaj wel ne̱toka siga ayá̱ꞌ kiwajliga toTaj yej ne̱ti̱tan; iwá̱n nej nia nikojpa‑ixiti̱ti kua̱ꞌ Dios wi̱ꞌ tajuzga̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ipan a̱mamej ka̱n kijkuilojkej profe̱tajmej, kijtowa: “Dios yawi kimachti̱ti inochi.” Nochi yej kikaki toTaj, momachtiá ípan, iwá̱n ne̱toka. ");
INSERT INTO nhx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ayéj iga ágaja kitaꞌ toTaj; nikítaꞌsan nej yej niwa̱laj de Dios. ");
INSERT INTO nhx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nej nimitzijliáj, yej ne̱cre̱dowa, nochipa yawi onoti wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nejwaꞌ in pa̱n yej nitamaka vida. ");
INSERT INTO nhx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Amo‑ikyapatajwa̱n kikuajkej maná ipan desierto, iwá̱n malej ijkó̱n, mikíkejsan; ");
INSERT INTO nhx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","eꞌ nej nitajtowa de inó̱n pa̱n yej temowa ipan cielo; yej kikua inó̱n pa̱n, ayá̱ꞌ mikis. ");
INSERT INTO nhx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nejwaꞌ in inó̱n pa̱n yej isatoꞌ; yej temoj ipan cielo. Yej kikua iní̱n pa̱n, yawi onoti nochipa wa̱n Dios. Iní̱n pa̱n yej nia nikmakati, ini̱nwaꞌ nonakayo. Nia nikmakati iga makipiá vida nochi gente. ");
INSERT INTO nhx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Judiyojmej pe̱wakej iga mose̱sepan‑ijliáj: —¿Kén mate̱maka inakayo iga matikua̱ka̱n? ");
INSERT INTO nhx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesús kijtoj: —Nej nimitzijliáj, siga ayá̱ꞌ ankikuaj nonakayo nej yej iPiltzi̱n Ta̱gaꞌ iwá̱n ayá̱ꞌ ankoniáj noesyo, awel amisatoskej iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yej kikua nonakayo iwá̱n koniá noesyo, nochipa yawi onoti wa̱n Dios; iwá̱n nia nikojpa‑ixiti̱ti kua̱ꞌ Dios wi̱ꞌ tajuzga̱ro̱ki. ");
INSERT INTO nhx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Iga nonakayo melaꞌtákual nokta, iwá̱n noesyo melá̱ꞌ nokta yej mooniá. ");
INSERT INTO nhx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yej kikua nonakayo iwá̱n koniá noesyo, se̱titoꞌ nowa̱n, iwá̱n nej nise̱titoꞌ íwa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ToTaj yej ne̱ti̱tan isatoꞌ, iwá̱n nej nisatoꞌ iga yéj; ijko̱nsan no̱ yej kikua nonakayo, onos iga nej. ");
INSERT INTO nhx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nej ayéj ken inó̱n pa̱n yej kijliáj maná yej kikuajkej amo‑ikyapatajwa̱n, malej iga kikuajkej, eꞌ mikíkejsan. Nej pa̱n yej temoj ipan cielo. Yej kikua iní̱nbapa pa̱n, yawi onoti nochipa wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesús ijkó̱n tamachtij tio̱pan ipan a̱ltepe̱ꞌ Capernaum. ");
INSERT INTO nhx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kua̱ꞌ kikakikej kén iga Jesús tamachtiá, miaꞌ yej kitokatinemiáj Jesús kijtojkej: —Iní̱n yej kijtowa ayagaj kojasi; ¿A̱ꞌ wel kitajto̱lkui̱li̱j? ");
INSERT INTO nhx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesús kimatiꞌ iga yej kitokatinemiáj kipo̱pojtoyaj, tatajtan: —¿Ix mitzkuesowaj iga ijkó̱n nitamachtij? ");
INSERT INTO nhx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Te̱ ankijtowa̱yaj siga xine‑itaka̱n nej yej iPiltzi̱n Ta̱gaꞌ, nemi nitejkawi ka̱n achto nonoya? ");
INSERT INTO nhx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Espí̱ritojwaꞌ in yej kichi̱wa iga matonoka̱n; ise̱lti tonakayo akichi̱wa nité̱, iwá̱n tajto̱lmej yej nimitzijlijkej wa̱laj ipan Espíritu iwá̱n tamaka vida. ");
INSERT INTO nhx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Eꞌ ónogoꞌ sekin de amejeme̱n yej ayá̱ꞌ kicre̱dowaj. Eꞌ Jesús kimatiáy aja̱ꞌyéj yej ayá̱ꞌ kicre̱dowa̱yaj, iwá̱n a̱ꞌyéj yawi kine̱xti̱ti iga makiki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Iwá̱n kijtoj: —Inó̱n iga nimitzijlíjkeja iga ayagaj wel wi̱ꞌ ka̱n nonoꞌ, siga toTaj ayá̱ꞌ kiwajliga. ");
INSERT INTO nhx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iwá̱n íkua̱ꞌya, miaꞌ yej kitokatinemiáj Jesús kikajtejkej, iwá̱n ayꞌya nemiáj iwá̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesús kitajtan doce idisci̱polojmej: —¿Amejeme̱n no̱ anya̱jnékija? ");
INSERT INTO nhx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro kijtoj: —NoTe̱ko, ¿a̱ꞌya seꞌ maniktokaka̱n? Motájto̱l ne̱ne̱xtiliáj kén iga wel manonoka̱n nochipa wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nejeme̱n nicre̱dójkeja, iwá̱n nikmatij iga tej tiCri̱stoj yej iPiltzi̱n Dios yej isatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesús kijtoj: —¿Ix aya̱ꞌtaj ando̱cejmej nimitztapejpenkej? Iwá̱n se̱ de amejeme̱n tzitzimiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Kua̱ꞌ iní̱n kijtoj, Jesús nemi tajtowa de Judas Iscariote, ipiltzi̱n Simón, iga Judas yawi kine̱xti̱ti iga makiki̱tzki̱ka̱n, malej iga yéj se̱ de inó̱n doce idiscí̱poloj Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kua̱ꞌ nochi iní̱n panoj, Jesús nemiá ipan íta̱l Galilea; ayá̱ꞌ kinekiá maono ipan íta̱l Judea, iga ompa judiyojmej kimikti̱jnekiáj Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Eꞌ como asitia̱yay iyilwi ra̱nchojtzitzi̱n, se̱ ilwiꞌ yej kichi̱wayaj judiyojmej, ");
INSERT INTO nhx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","iyikni̱wa̱n kijlijkej: —Amo xika̱wi nigaj; xaj Judea iga yej mitztokaj yej ompiga onokej, no̱ makitaka̱n yej tikchi̱wa yej ayi̱ꞌpa mo‑ita. ");
INSERT INTO nhx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Siga agaj kineki maki̱xmatika̱n, ayá̱ꞌ kichi̱wa tejté̱ ichtákasan, eꞌ siga tikneki mamitzi̱xmatika̱n, yej tikchi̱wa, xikchi̱wa ka̱n nochi mamitzita. ");
INSERT INTO nhx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Niga iyikni̱wa̱n ayá̱ꞌ kicre̱dowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iwá̱n Jesús kijtoj: —Aya asi noho̱raj, eꞌ iga amejeme̱n malej iga ná̱mo̱l hora, nochi ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yej ayá̱ꞌ ne̱cre̱dojtokej, amejeme̱n awel mitzijiyaj, eꞌ nej, kena ne‑ijiyaj, iga nikne̱xtiliáj iga kichijtokej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amejeme̱n xa̱ka̱n ilwitaj; nej ayá̱ꞌ nia iga aya asi noho̱raj. ");
INSERT INTO nhx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kua̱ꞌ tamiꞌ iní̱n kijtoj, Jesús ka̱wiꞌ Galilea. ");
INSERT INTO nhx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Eꞌ kua̱ꞌ yájkija iyikni̱wa̱n, Jesús yajki no̱ ilwitaj, malej iga ayagaj kitaꞌ, ken kua̱ꞌ ichtakayajki. ");
INSERT INTO nhx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judiyojmej kite̱mowa̱yaj Jesús ilwitaj, iwá̱n kijtowa̱yaj: —¿Ix ka̱n a̱n onoꞌ in inó̱n ta̱gaꞌ? ");
INSERT INTO nhx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Iwá̱n poxsan miaꞌ ta̱tapowayaj de Jesús. Sekin kijtowa̱yaj: “Iní̱n ta̱gaꞌ pox kichi̱wa yej ye̱kti”, eꞌ sekin kijtowa̱yaj: “Iní̱n ayá̱ꞌ kichi̱wa yej ye̱kti; takajkaya̱wa.” ");
INSERT INTO nhx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Eꞌ la gente ichtákasan tajtowa̱yaj de Jesús iga kimajmawilia̱yaj judiyojmej yej manda̱rowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kua̱ꞌ ná̱wiya día iga nentoya ilwiꞌ, Jesús kalaꞌ tio̱pan‑ijtiꞌ iwá̱n pe̱ꞌ iga tamachtiá. ");
INSERT INTO nhx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judiyojmej madmira̱dowa̱yaj, iwá̱n kijtowa̱yaj: —¿Kén kichi̱wa in iní̱n ta̱gaꞌ iga pox wel tamachtiá? Ayá̱ꞌ momachtij. ");
INSERT INTO nhx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesús kijtoj: —Ken nimitzmachtiáj ayéj nejsan nikijtowa, iga ijkó̱n kijtowa yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Siga agaj kineki makichi̱wa ken kineki Dios, yawi ki̱xmatiti siga yej nitamachtiá wi̱ꞌ de Dios o nejsan nikijtowa. ");
INSERT INTO nhx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Siga nogá̱najsan niknekiá manimoweyimati, nejsan nimotajtowilia̱ya. Eꞌ nikneki mamoweyimati̱lti yej ne̱ti̱tan. Inó̱n iga yej nikijtowa, ijko̱nya nokta iwá̱n ayá̱ꞌ nitakajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’¿Ix ayejtaj Moisés mitzmakakej la ley? Iwá̱n nisé̱ de amejeme̱n ayá̱ꞌ kichi̱wa ken ijkuilijtoꞌ. ¿Te iga anne̱mikti̱jnekij? ");
INSERT INTO nhx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","La gente kijtojkej: —¡Tinemi wa̱n Tzitzimiꞌ! ¿A̱ꞌyéj mitzmikti̱jneki? ");
INSERT INTO nhx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús kijtoj: —Igasan nikchij yej ye̱kti ipan día kua̱ꞌ mose̱wilo, ayá̱ꞌ ankiye̱ꞌitakej. ");
INSERT INTO nhx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Eꞌ Moisés mitzne̱xtilijkej iga ximocircuncida̱ro̱ka̱n, (malej iga ayéj achto Moisés yej tatekimáꞌ iga mamocircuncida̱ro̱lo, yajkij amo‑ikyapatajwa̱n), inó̱n iga amejeme̱n ankicircuncida̱rowaj se̱ choochi̱n malej iga ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Iwá̱n iná̱n amejeme̱n iga san ankichi̱waj ken kijtowa iley Moisés, ankicircuncida̱rowaj se̱ choochi̱n ipan día kua̱ꞌ mose̱wilo, ¿te ígataj mitzkuesowaj iga nitaachitialtij ipan día kua̱ꞌ mose̱wilo? ");
INSERT INTO nhx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amo xitajuzga̱ro̱ka̱n san ken ankitaj, kua̱ꞌ agaj ankijuzga̱rowaj, xitaye̱ꞌjuzga̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sekin yej cha̱ntitoyaj Jerusalén, pe̱wakej tatajtankej: —¿Ix ayéj iní̱n in yej kite̱mojtinemij iga makimikti̱ka̱n? ");
INSERT INTO nhx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Taꞌ xikitaka̱n, ne̱ ta̱tajtojtoꞌ ka̱n onolo̱ꞌ, iwá̱n ayagaj kijliá nité̱, in yej manda̱rowaj, ¿ix a̱n kimelaꞌkre̱dójkeja iga iní̱n ta̱gaꞌ in Cristo? ");
INSERT INTO nhx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Eꞌ tejeme̱n tikmatij de ka̱n wi̱ꞌ; iwá̱n kua̱ꞌ mawi̱ki Cristo, ayagaj yawi kimatiti de ka̱n wi̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kua̱ꞌ Jesús kikaguiꞌ iní̱n, tamachtijtoya tio̱pan‑ijtiꞌ, iwá̱n tajtoj recio: —¡Wa̱ntaj ankijtowaj iga anne‑i̱xmatij wa̱n ankimatij ka̱n niwa̱laj! Eꞌ ayá̱ꞌ niyokawa̱laj, sino que ne̱ti̱tan se̱ yej ayí̱ꞌ takajkaya̱wa, yej amejeme̱n ayá̱ꞌ anki̱xmatij. ");
INSERT INTO nhx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nej sí niki̱xmati iga ipan yéj niki̱saꞌ, iwá̱n yéj ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iwá̱n kinekiáj makiki̱tzki̱ka̱n, eꞌ ayagaj kima̱ta̱lilij iga Dios aya kineꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Miaꞌ yej kicre̱dojkej ipan yéj, iwá̱n kijtojkej: —Kua̱ꞌ mawi̱ki Cristo, ¿ix ma̱jya yawi kichi̱wati milagro que iní̱n ta̱gaꞌ kichi̱wa? ");
INSERT INTO nhx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseojmej kikakikej yej la gente kipojtoyaj de Jesús; iwá̱n fariseojmej iwá̱n ije̱fejmej sacerdo̱tejmej kiti̱tankej policiyajmej yej tacuida̱rowaj weyitio̱pan iga makiki̱tzki̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Iwá̱n Jesús kijtoj: —Ayá̱ꞌ niwejka̱was iga amowa̱n nia nonoti, iwá̱n nia̱ti sej ka̱n onoꞌ yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Amejeme̱n anne̱te̱mo̱skej, eꞌ ayá̱ꞌ anneasiskej, iga awel anya̱skej ka̱n nej nonos. ");
INSERT INTO nhx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judiyojmej pe̱wakej iga mose̱sepantajtanij: —In iní̱n, ¿ka̱n a̱n ya̱ti iga ayꞌya wel tikasiskej? ¿Ix a̱n ya̱ti kimachti̱ti judiyojmej yej cha̱ntitokej ipan íta̱l grie̱gojmej, ino̱mej yej pa̱payi̱ntinemij iwá̱n kimachti̱j no̱ grie̱gojmej? ");
INSERT INTO nhx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ix te̱ a̱n kijto̱jneki in inó̱n yej kijtoj: “Anne̱te̱mo̱skej, eꞌ ayá̱ꞌ anneasiskej, iga awel anya̱skej ka̱n nia nonoti”? ");
INSERT INTO nhx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kua̱ꞌ ásiꞌya día iga tami ilwiꞌ, inó̱n día nokta yej má̱j weyi‑ilwiꞌ; inó̱n día, Jesús moketzaꞌ iwá̱n tajtoj recio: —Siga agaj a̱taneki, mawi̱ki ka̱n nonoꞌ iwá̱n maa̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xicre̱do̱ka̱n notájto̱l iwá̱n ipan amoa̱lmajmej ki̱stos ken we̱ya̱mej yej kichi̱waj iga xonoka̱n nochipa wa̱n Dios. Ijkó̱n kijtowa ka̱n ijkuilijtoꞌ itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iga inó̱n kijtoj Jesús, kijtoj iga yej kicre̱do̱j itájto̱l, kipiás iyEspí̱ritoj Dios; íkua̱ꞌ aya wi̱tziá iyEspí̱ritoj Dios, iga Jesús aya kiweyimati̱ltia̱yaj ipan cielo iga aya ojpa‑isa. ");
INSERT INTO nhx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sekin yej ompa onoyaj kua̱ꞌ kikakikej iní̱n, kijtojkej: —Iní̱n ta̱gaꞌ profeta nokta yej tikchi̱xtoyaj. ");
INSERT INTO nhx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Sekin kijtowa̱yaj: —Ini̱nya in Cristo. Eꞌ sekin kijtojkej: —¿Ix wel Cristo ma de Galilea? ");
INSERT INTO nhx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ka̱n ijkuilijtoꞌ kijtowa iga Cristo yawi ki̱sati ipan ipilówa̱mpa ipilowa̱n rey David iwá̱n nace̱ro̱j Belén, ipansan inó̱n a̱ltepe̱ꞌ ka̱n icha̱n David. ");
INSERT INTO nhx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Inó̱n iga moyojyokatilo̱ꞌ iga itechko Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Sekin kinekiáj makipre̱sojwi̱ka̱n Jesús, eꞌ ayagaj mi̱xe̱wij. ");
INSERT INTO nhx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Policiyajmej yajkij ka̱n onokej fariseojmej iwá̱n ije̱fejmej sacerdo̱tejmej, iwá̱n kitajtankej: —¿Te iga ayá̱ꞌ ankiwajligakej? ");
INSERT INTO nhx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policiyajmej kijtojkej: —¡Ayí̱ꞌ nikakij agaj matajto ken iní̱n ta̱gaꞌ! ");
INSERT INTO nhx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Iwá̱n fariseojmej kijtojkej: —¿Amejeme̱n no̱ya mitzkajkayajkej? ");
INSERT INTO nhx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Ix ágaja de toje̱fejmej o de tejémejpa fariseojmej kicré̱doja ipan yéj? ");
INSERT INTO nhx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Eꞌ ini̱mej yej kitokaj Jesús aki̱xmatij iley Moisés, inó̱n iga Dios yawi kicastiga̱ro̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo yej se̱ ve̱j yajka tayowa kitato̱ya Jesús, yej no̱ katka fariseo, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Toley tatekimaka iga awel tikijtowaj iga mamiki se̱ ta̱gaꞌ siga ayá̱ꞌ achto tikakij wa̱n tikmatij te̱ kikomete̱roj. ");
INSERT INTO nhx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Iwá̱n kijlijkej: —¿In tej no̱ tigalileo? Ximomachti ka̱n ijkuilijtoꞌ, iwá̱n tikitas iga nisé̱ profeta ayá̱ꞌ wa̱laj de Galilea. ");
INSERT INTO nhx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Iwá̱n sejsé̱ de yejemej yájkija icha̱mej. ");
INSERT INTO nhx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Eꞌ Jesús yajki ipan tepe̱ꞌ yej ito̱ka̱ꞌ Olivos. ");
INSERT INTO nhx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ipan seꞌ día, yowaltiꞌ yajki tio̱pan. Iwá̱n nochi gente kitechoj, iwá̱n Jesús mota̱lij iwá̱n pe̱waꞌ tamachtij. ");
INSERT INTO nhx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Iwá̱n yej tamachtiáj ipan la ley iwá̱n fariseojmej, kiwajliguilijkej Jesús se̱ siwa̱ꞌ yej kima̱wetzi̱ltijkej wa̱n se̱ ta̱gaꞌ yej ayá̱ꞌ íwa̱n na̱miktitoꞌ iwá̱n kita̱lkej itajkoya̱n la gente, ");
INSERT INTO nhx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","iwá̱n kijlijkej Jesús: —Tamachtia̱ni, iní̱n siwa̱ꞌ nikma̱wetzi̱ltijkej iwá̱n se̱ ta̱gaꞌ yej ayá̱ꞌ íwa̱n na̱miktitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Iley Moisés te̱tekimaka iga ijki̱mpa siwa̱ꞌ matiktemikti̱ka̱n. ¿In tej, ken tikijtowa? ");
INSERT INTO nhx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Inó̱n kijlijkej ka̱nsan makima̱wetzi̱lti̱ka̱n, iga ijkó̱n wel makite̱lwi̱ka̱n. Iwá̱n Jesús mokototzoj iwá̱n pe̱waꞌ tajkuiloj ipan ta̱jli iga imájpil. ");
INSERT INTO nhx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eꞌ como kitajtantóyajsan, moketzaꞌ iwá̱n kijtoj: —Agaj de amejemej yej momachi̱liá iga ayí̱ꞌ kichij yej aye̱kti, inó̱n achto makipata̱naltili teꞌti iní̱n siwa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Iwá̱n sej mokototzoj iwá̱n ma̱joꞌ tajkuiloj ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eꞌ yejemej kua̱ꞌ iní̱n kikakikej, momachi̱lijkej iga aye̱ꞌnemij, iwá̱n sejsé̱ sejsé̱ ki̱stiajki. Achto ki̱skej yej we̱wétkeja. Iwá̱n kua̱ꞌ nóchiya ki̱skej, Jesús ká̱wiꞌsan iwá̱n siwa̱ꞌ iga ompay kikajtejkej. ");
INSERT INTO nhx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iwá̱n Jesús moketzaꞌ iwá̱n como kitaꞌ iga petz síwa̱ꞌsan onoya, kijlij: —Siwa̱ꞌ, ¿ka̱n onokej in yej mitzmikti̱jnekiáj? ¿Ix ayagaj kijtoj iga ximiki? ");
INSERT INTO nhx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Siwa̱ꞌ kijtoj: —Ayagaj, noTe̱ko. Jesús kijtoj: —Nej no̱ ayá̱ꞌ nikijtowa iga ximiki; iná̱n xaja iwá̱n ayoꞌ xikchi̱wa yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesús tajtoj sej iwá̱n la gente, iwá̱n kijtoj: —Nej yej nikta̱wiá nochi gente pan iya̱lmajmej; yej ne̱toka ayí̱ꞌ nemis ka̱n takomichka̱n, ma̱jwaꞌ kipiás yej kita̱wiá ipan iya̱lmaj iwá̱n kipiás nokta vida. ");
INSERT INTO nhx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseojmej kijtojkej: —Tejsan timotajtowiliá, iwá̱n iga mogá̱najsan timotajtowiliá, avale̱rowa. ");
INSERT INTO nhx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesús kijtoj: —Malej iga nejsan nimotajtowiliá, eꞌ kena vale̱rowa, iga nikmati ka̱n niwa̱laj iwá̱n nikmati ka̱n nia, eꞌ amejeme̱n ayá̱ꞌ ankimatij ka̱n niwa̱laj niga ka̱n nia. ");
INSERT INTO nhx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amejemej antajuzga̱rowaj ken kiye̱ꞌita ta̱gaꞌ. Nej ayagaj nikjuzga̱rowa, ");
INSERT INTO nhx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","eꞌ siga nitajuzga̱rowa, nikchi̱wa ken kajasi iga ayá̱ꞌ nikchi̱wa nose̱lti, sino que iwá̱n noTaj yej ne̱ti̱tan, íwa̱n nitajuzga̱rowa. ");
INSERT INTO nhx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ipan amoley ijkuilijtoꞌ, iga kua̱ꞌ o̱me kitakej te̱ mochij iwá̱n sansé̱ kijtowaj yej kitakej, inó̱n yej kijtowaj, ijko̱nya. ");
INSERT INTO nhx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nej nimotajtowiliá, iwá̱n noTaj yej ne̱ti̱tan mochi̱wa seꞌ yej ne̱tajtowiliá. ");
INSERT INTO nhx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iwá̱n kitajtankej: —¿Ka̱n onoꞌ moTaj? Jesús kijtoj: —Amejemej ayá̱ꞌ ane‑i̱xmatij, iwá̱n ayá̱ꞌ no̱ anki̱xmatij noTaj, siga ane‑i̱xmatiáj, no̱ anki̱xmatiáj noTaj. ");
INSERT INTO nhx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iní̱n tajto̱lmej kijtoj Jesús kua̱ꞌ nemi tamachtiá weyitio̱pan, ite̱noj cajo̱ntzi̱n ka̱n moakiá tomi̱n iga ofrenda. Eꞌ ni agaj ayá̱ꞌ kiki̱tzkij, iga Dios aya kineꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesús kijlij sej judiyojmej: —Nej nia̱ti, iwá̱n amejemej anne̱te̱mo̱skej, eꞌ anyawij anmikitij iga ankichijtokej yej aye̱kti wa̱n ayá̱ꞌ mitzperdona̱rowili̱skej yej ankichi̱waj. Ka̱n nej nia, amejemej awel anyawij. ");
INSERT INTO nhx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iwá̱n judiyojmej kijtojkej: —¿Ix anka kejla̱miki iga momikti̱j, anka inó̱n iga kijtowa iga awel tia̱skej ka̱n yéj yawi? ");
INSERT INTO nhx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesús kijtoj: —Amejeme̱n nigaj amocha̱n ipan iní̱n ta̱jli, nej nocha̱n ajko. Amejemej de iní̱n ta̱jli, iwá̱n nej ayéj de iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Inó̱n iga nimitzijlijkej iga amejemej anyawij anmikitij iga ankichijtokej yej aye̱kti wa̱n ayá̱ꞌ mitzperdona̱rowili̱skej yej ankichi̱waj. Siga amejemej ayá̱ꞌ ankicre̱do̱skej iga nej niCri̱stoj, anmikiskej wa̱n ayá̱ꞌ mitzperdona̱rowili̱skej yej ankichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iwá̱n kitajtankej Jesús: —¿A̱ꞌtaj yej in tej? Jesús kijtoj: —Ino̱nsan ken nimitzijlijkej achto. ");
INSERT INTO nhx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ónogoꞌ komati yej wel nimitzijliáj yej ayompa ankichi̱waj. Eꞌ yej ne̱ti̱tan ayá̱ꞌ takajkaya̱wa iwá̱n nikijliá la gente kensan nikaguiꞌ kijtowa yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Eꞌ yejemej ayá̱ꞌ kimatikej iga nemi tajtowa de Dios yej iTaj. ");
INSERT INTO nhx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Inó̱n iga Jesús kijtoj: —Kua̱ꞌ amejemej anyawij anneajkokuitij ipan cruz, nej yej iPiltzi̱n Ta̱gaꞌ, íkua̱ꞌ ankimatiskej a̱ꞌyéj nej. Ayá̱ꞌ nikchi̱wa yej nej nikneki, nikijtowa kensan noTaj ne̱ne̱xtilij. ");
INSERT INTO nhx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iga yej ne̱ti̱tan onoꞌ nowa̱n; noTaj ayá̱ꞌ ne̱semaka, iga nochipa nikchi̱wa yej yejpa kiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kua̱ꞌ Jesús kijtoj ini̱mej tájto̱l, miaꞌ kicre̱doj ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesús kijlij judiyojmej yej kicre̱dojkej ipan yéj: —Siga amejemej amoconfia̱rojtoskej ipan notájto̱l, anmochi̱waskej annomelaꞌdisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Iwá̱n anki̱xmatiskej yej melá̱ꞌ nokta, iwá̱n ken kua̱ꞌ ayoꞌ nité̱ mitzilpitoskej. ");
INSERT INTO nhx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yejemej kijtojkej: —Nejemej ipilowa̱n ipilówa̱mpa Abraham iwá̱n ayí̱ꞌ nimochi̱waskej agaj iyescla̱voj; ¿te iga tej tikijtowa iga ne̱xitomaskej? ");
INSERT INTO nhx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús kijlij judiyojmej: —Nimitzijliáj iga inochi yej kichi̱wa yej aye̱kti, ilpitoꞌ iga inó̱n yej kichi̱wa yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Se̱ esclavo ayá̱ꞌ nochipa onos ipan se̱ kajli. Eꞌ se̱ te̱piltzi̱n, kena, kajasi maono nochipa pan se̱ kajli. ");
INSERT INTO nhx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Inó̱n iga, siga nej yej iPiltzi̱n Dios nimitzxitomaj, amejeme̱n anmelaꞌxitontoskej. ");
INSERT INTO nhx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nikmati iga amejemej ipilówa̱mpa Abraham. Eꞌ anne̱mikti̱jnekij iga ayá̱ꞌ ankichi̱waj ken nikijtowa. ");
INSERT INTO nhx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nej nikijtowa yej ne̱ne̱xtilij noTaj, iwá̱n amejemej ankichi̱waj yej amotaj mitzne̱xtilijkej. ");
INSERT INTO nhx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yejemej kijtojkej: —Notájmejwaꞌ Abraham. Iwá̱n Jesús kijtoj: —Siga katka amejemej ipilowa̱n Abraham, ankichi̱wayaj ken yéj kichij. ");
INSERT INTO nhx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Eꞌ iná̱n amejeme̱n anne̱mikti̱jnekij iga san nimitzijlijkej yej melá̱ꞌ, yej Dios ne̱ne̱xtilij. ¡Abraham ayí̱ꞌ ijkó̱n kichij! ");
INSERT INTO nhx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Amejemej ankichi̱waj ken kichi̱wa amotaj. Iwá̱n yejemej kijtojkej: —Nejemej ayéj nipejpemej. Nikpiáj se̱san notajmej, ino̱nwaꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús kijtoj: —Siga melá̱ꞌ iga Dios amotaj, amejemej anne̱nekiáj, iga nej ne̱ti̱tan Dios. Ayá̱ꞌ niyokawa̱laj, sino que Dios ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Te iga ayá̱ꞌ ankentende̱rowaj yej nikijtowa? Iga ayá̱ꞌ nokta ankikakisnekij notájto̱l. ");
INSERT INTO nhx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Amejemej amotaj tzitzimiꞌ, iwá̱n ankichi̱wasnekij ken amotaj kineki. Tzitzimiꞌ nochipa tamiktiá iwá̱n takajkaya̱wa. Ayí̱ꞌ kijtowa yej melá̱ꞌ nokta, wa̱n kua̱ꞌ takajkaya̱wa momelaꞌne̱xtiá ken iga yéj nokta. Yéjwaꞌ takajkaya̱wa nokta iwá̱n kichi̱wa iga matakajkaya̱walo. ");
INSERT INTO nhx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Eꞌ nej nimitzijliáj yej melá̱ꞌ iwá̱n amejemej ayá̱ꞌ anne̱cre̱dowaj. ");
INSERT INTO nhx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿A̱ꞌyéj de amejemej wel ne̱ne̱xtiliá iga nikchij yej aye̱kti? Iwá̱n siga nej nikijtowa yej melá̱ꞌ, ¿te iga ayá̱ꞌ anne̱cre̱dowaj? ");
INSERT INTO nhx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yej itatki Dios, kikaki itájto̱l Dios. Eꞌ iga amejemej ayéj de Dios, inó̱n iga ayá̱ꞌ ankikakij notájto̱l. ");
INSERT INTO nhx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iwá̱n judiyojmej kijtojkej: —Ómpaya ken nikijtowaj iga tej tisamarita̱noj iwá̱n tikpiá iyespí̱ritoj tzitzimiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús kijtoj: —Ayá̱ꞌ nikpiá nisé̱ ma̱lespí̱ritoj. Nej nikweyimati̱ltiá noTaj iwá̱n amejeme̱n anneali̱mpamatij. ");
INSERT INTO nhx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nej ayá̱ꞌ nikte̱mowa iga mane̱weyimati̱lti̱ka̱n, eꞌ onoꞌ se̱ yej kineki iga mane̱weyimati̱lti̱ka̱n, iwá̱n yéj tajuzga̱rowa. ");
INSERT INTO nhx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nimitznojma‑ijliáj siga agaj kichi̱wa ken nej nikijtowa, nike̱man ayá̱ꞌ mikis. ");
INSERT INTO nhx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Iwá̱n judiyojmej kijtojkej: —A̱n sí nikmatij iga tikpiá ma̱lespí̱ritoj. Abraham iwá̱n nochi profe̱tajmej mikikej iwá̱n tej tikijtowa: “Siga agaj kichi̱wa ken nej nikijtowa, nike̱man ayá̱ꞌ mikis.” ");
INSERT INTO nhx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿In tej, ix ma̱jya sej que to‑ikyapatajwe̱wej Abraham? Porque yéj miguiꞌ, iwá̱n profe̱tajmej no̱ mikikej, ¿a̱ꞌtaj yéj timomachi̱liá in tej? ");
INSERT INTO nhx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesús kijtoj: —Siga nejsan nimoweyimati̱ltiá, ijkó̱n ayá̱ꞌ movale̱rowa. Eꞌ noTaj yej ne̱weyimati̱ltiá, ino̱nsan yej ankijtowaj iga amoDio̱s. ");
INSERT INTO nhx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eꞌ amejemej ayá̱ꞌ anki̱xmatij. Nej sí niki̱xmati; iwá̱n siga nikijto̱j iga ayá̱ꞌ niki̱xmati, no̱ te̱wa̱n nitakajkaya̱was ken amejemej. Eꞌ nej sí niki̱xmati iwá̱n nikchi̱wa ken yéj kijtowa. ");
INSERT INTO nhx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham, yej amo‑ikyapatajmej, pa̱guiꞌ iga kitasnekiá iga niwi̱tziá; iwá̱n kitaꞌ, iwá̱n poxsan yo̱lpa̱guiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judiyojmej kijlijkej Jesús: —Aya tikpiá niga cincuenta años, ¿iwá̱n tikijtowa iga tikitaꞌya Abraham? ");
INSERT INTO nhx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesús kijtoj: —Nimitznojma‑ijliáj iga kua̱ꞌ aya teyá Abraham, nej nonoyay. ");
INSERT INTO nhx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iwá̱n kikuikej teꞌti iga kitemiktia̱yaj Jesús; eꞌ Jesús mi̱ya̱n, iwá̱n ki̱saꞌ ipan weyitio̱pan; panoj tatza̱la̱n iwá̱n yajki. ");
INSERT INTO nhx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ka̱n pano̱tia̱ya Jesús, kitaꞌ se̱ ta̱gaꞌ yej itékiya iga pacha. ");
INSERT INTO nhx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Iwá̱n idisci̱polojmej kitajtankej: —Tamachtia̱ni, ¿te iga a̱n itékiya ga pacha iní̱n ta̱gaꞌ? ¿Ix iga itaj o iye̱ꞌ kichijkej yej aye̱kti, o iga yéj nokta kichij yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesús kijtoj: —Ayéj iga yéj kichij yej aye̱kti, niga itaj niga iye̱ꞌ kichijkej yej aye̱kti, sino que iga ipan yéj mamone̱xti yej Dios wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mie̱j nonoꞌ amowa̱n nia nikchi̱wati itekipáno̱l yej ne̱ti̱tan, iga kua̱ꞌ yawi tayowatiati, ayágajoꞌ wel tekipano̱j. ");
INSERT INTO nhx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mie̱j nonoꞌ ipan iní̱n ta̱jli nej kenkua̱ꞌ nikta̱wiá la gente pan iya̱lmajmej. ");
INSERT INTO nhx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kua̱ꞌ Jesús tamiꞌ iní̱n kijtoj, chijchaꞌ ta̱lpan wa̱n kichij alí̱n sokiꞌ iga ichíjchal, iwá̱n inó̱n sokiꞌ kita̱lilij ipan iyi̱x yej pacha. ");
INSERT INTO nhx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Iwá̱n Jesús kijtoj: —Xaj ximo‑i̱xpa̱kati ipan a̱yawalwé̱j yej ito̱ka̱ꞌ Siloé —Siloé kijto̱jneki “yej kiti̱tankej”. Pacha yajki iwá̱n mo‑i̱xpa̱gaꞌ, iwá̱n kua̱ꞌ mokuepaꞌ, welja tachaya. ");
INSERT INTO nhx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Iwá̱n yej najna̱ꞌsan icha̱mej iwá̱n yej ki̱xmatiajya iga pacha, kijtojkej: —¿Ix ayéj iní̱n yej mota̱lia̱ya iga kitajtaniá tomi̱n? ");
INSERT INTO nhx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Sekin kijtojkej: —Kena, yéjya. Sekin sej kijtojkej: —Ayéj yéj, eꞌ ijkó̱mpasan ken yéj. Eꞌ yej katka pacha kijtoj: —Nejya yej katka nipacha. ");
INSERT INTO nhx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Iwá̱n kitajtankej: —¿Te̱ mitzchi̱wilijkej iga wel xitachá? ");
INSERT INTO nhx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yéj kijtoj: —Inó̱n ta̱gaꞌ yej ito̱ka̱ꞌ Jesús, kichij alí̱n sokiꞌ iwá̱n ne̱ta̱lilij ipan noyi̱x iwá̱n ne‑ijlij: “Xaj ipan a̱yáwal yej ito̱ka̱ꞌ Siloé iwá̱n ximo‑i̱xpa̱ka.” Nej niajki iwá̱n kua̱ꞌ nimo‑i̱xpa̱gaꞌ, welja nitacháꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iwá̱n kitajtankej: —¿Ka̱n onoꞌ inó̱n ta̱gaꞌ? Iwá̱n yéj kijtoj: —Anikmati. ");
INSERT INTO nhx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Iwá̱n yej katka pacha kiwi̱gakej iyi̱xtaj fariseojmej. ");
INSERT INTO nhx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Eꞌ kua̱ꞌ Jesús kichij sokiꞌ iga kachitialtij pacha, inó̱n día katka kua̱ꞌ mose̱wilo, ");
INSERT INTO nhx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","inó̱n iga fariseojmej sej kitajtankej yej katka pacha kén iga i̱xtapowiꞌ. Yej katka pacha kijtoj: —Ne̱ta̱lilij sokiꞌ ipan noyi̱x, iwá̱n nimo‑i̱xpa̱gaꞌ iná̱n welja nitachá. ");
INSERT INTO nhx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sekin fariseojmej kijtojkej: —Inó̱n ta̱gaꞌ yej kichij ijkó̱n, ayéj Dios kiti̱tan, iga tekipanowa malej iga día kua̱ꞌ mose̱wilo. Eꞌ sekin kijtojkej: —¿Kén wel kichi̱was milagro se̱ ta̱gaꞌ yej ayompa nemi? Iwá̱n ayá̱ꞌ sansé̱ kijtowa̱yaj, ");
INSERT INTO nhx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","iwá̱n sej ki‑ojpatajtankej inó̱n yej katka pacha: —Tej, ¿te̱ tikijtowa de inó̱n yej mitzi̱xtapoj? Iwá̱n yéj kijtoj: —Nej nikijtowa iga yéj profeta. ");
INSERT INTO nhx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Eꞌ judiyojmej ayá̱ꞌ kicre̱dowa̱yaj iga inó̱n ta̱gaꞌ pacha katka, iwá̱n iná̱n welja tachá, este que kino̱tzkej itaj iwá̱n iye̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iwá̱n kitajtankej: —¿Ix iní̱n in amopiltzi̱n yej ankijtowaj itékiya iga pacha? ¿Kén iga iná̱n welja tachá? ");
INSERT INTO nhx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Itaj iwá̱n iye̱ꞌ pacha kijtojkej: —Nikmatij iga iní̱n nopiltzi̱n, itékiya iga pacha. ");
INSERT INTO nhx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Eꞌ ayá̱ꞌ nikmatij ken kichij iga iná̱n welja tachá, niga no̱ nikmatij a̱ꞌyéj ki̱xtapoj. Yéj xiktajtanika̱n, yéjwaꞌ yó̱leja, wel ima̱tika mitzijliáj ken kichij iga iná̱n ayꞌya pacha. ");
INSERT INTO nhx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Itaj iwá̱n iye̱ꞌ ijkí̱n kijtojkej iga kimajmawilia̱yaj judiyojmej, iga judiyojmej motajto̱ltíjkaja iga kiki̱xtia̱yaj ipan tio̱pan yej kijtowa̱ya iga Jesús el Mesías. ");
INSERT INTO nhx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Inó̱n iga itaj iwá̱n iye̱ꞌ kijtojkej: “Yéj xiktajtanika̱n, yéjwaꞌ yó̱leja.” ");
INSERT INTO nhx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Iwá̱n judiyojmej sej kino̱tzkej yej katka pacha, iwá̱n kijlijkej: —Xine̱nojma‑ijli̱ka̱n iyi̱xtaj Dios; nejemej nikmatij iga inó̱n ta̱gaꞌ kichijtoꞌ yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yej katka pacha kijtoj: —Nej anikmati siga kichijtoꞌ yej aye̱kti o ayá̱ꞌ, yej sí nikmati iga nej katka nipacha iwá̱n iná̱n welja nitachá. ");
INSERT INTO nhx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Sej kitajtankej: —¿Te̱ mitzchi̱wilij? ¿Kén iga mitzi̱xtapoj? ");
INSERT INTO nhx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yéj kijtoj: —Nimitzijlíjkejakej, eꞌ amejemej ayá̱ꞌ anne̱cre̱dowaj, ¿te iga ankinekij iga sej manikojpa‑ijto? ¿Ixtaj no̱ ankinekij xiktokaka̱n? ");
INSERT INTO nhx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Judiyojmej kajajwakej yej katka pacha, iwá̱n kijlijkej: —Tej sí tiktoka nokta in inó̱n ta̱gaꞌ. Eꞌ nejemej niktokaj Moisés. ");
INSERT INTO nhx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nejemej nikmatij iga Dios tajtoj iwá̱n Moisés, eꞌ inó̱n ta̱gaꞌ anikmatij ka̱n wa̱laj. ");
INSERT INTO nhx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ta̱gaꞌ yej katka pacha kijtoj: —¡Nej iní̱n sí anikojasi! Amejemej ayá̱ꞌ ankimatij ka̱n wa̱laj iwá̱n nej ne‑i̱xtapoj. ");
INSERT INTO nhx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tikmatij iga Dios ayá̱ꞌ kikaki yej kichi̱wa yej aye̱kti, kikákisan yej kiweyimati̱ltiáj iwá̱n kichi̱waj ken kineki Dios. ");
INSERT INTO nhx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Nike̱man ayí̱ꞌ mokaki iga se̱ yej itékiya iga pacha, agaj wel maki̱xtapo. ");
INSERT INTO nhx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Siga katka iní̱n ta̱gaꞌ ayá̱ꞌ wa̱laj de Dios, awel nité̱ kichi̱waya. ");
INSERT INTO nhx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Iwá̱n judiyojmej kijtojkej: —Tej yej motékiya iga tikchíjtoꞌya yej aye̱kti, ¿tikneki xine̱machti̱ka̱n? Iwá̱n kiki̱xtijkej ipan tio̱pan. ");
INSERT INTO nhx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús kimatiꞌ iga kiki̱xtijkej ipan tio̱pan inó̱n yej pacha katka, iwá̱n kua̱ꞌ Jesús kasiꞌ, kitajtan: —¿In tej, ix ticre̱dowa ipan iPiltzi̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Yej pacha katka kijtoj: —Noko̱ko, xine‑ijli a̱ꞌyéj o̱n iga nej manicre̱do ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús kijtoj: —Tikítaꞌya, nej yej nemi nita̱tapowa mowa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iwá̱n inó̱n ta̱gaꞌ, motankua̱ketzaꞌ ite̱noj Jesús, iwá̱n kijtoj: —Nicre̱dowa, noTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesús kijtoj: —Nej niwa̱laj ipan iní̱n ta̱jli iga manikne̱xti katiapa yej ye̱kti iwá̱n katiapa yej aye̱kti. Nej niwa̱laj iga yej pachamej matachaka̱n, iwá̱n yej iga tacháj, mamochi̱waka̱n ken pachamej. ");
INSERT INTO nhx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Iwá̱n sekin fariseojmej yej onoyaj ite̱noj Jesús, kua̱ꞌ iní̱n kikakikej, kitajtankej: —¿In nejemej, no̱ nipachamej? ");
INSERT INTO nhx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesús kijtoj: —Siga amejemej katka ampachamej, Dios ayá̱ꞌ mitzitayaj iga ankichijkej yej aye̱kti. Eꞌ iga ankijtowaj iga antacháj, Dios mitzitaj iga ankichijtokej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesús sej kijlij fariseojmej: —Nimitznojma‑ijliáj iga yej ayá̱ꞌ kalaki ipan ipue̱rtajyo kóla̱l ka̱n onokej borre̱gojmej, ma̱jwaꞌ kalaki seꞌ lado, ino̱nwaꞌ yej tachteki, iwá̱n tamaga iga kikui yej ayéj itatki. ");
INSERT INTO nhx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Eꞌ yej kalaki ipan puerta, ino̱nwaꞌ in pastor yej kicuida̱rowa borre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Yej tacuida̱rowa pan puerta, kitapowiliá puerta iga makalaki pastor, iwá̱n borre̱gojmej kitajto̱lkakij. Pastor kino̱tza ipan ito̱ka̱mej, iwá̱n kikiki̱xtiá kóla̱lko. ");
INSERT INTO nhx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Iwá̱n kua̱ꞌ kikijkí̱xtija inochi borre̱gojmej, in pastor tapanowa, iwá̱n borre̱gojmej kitokaj iga kitajto̱lkakij. ");
INSERT INTO nhx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Eꞌ ayá̱ꞌ kitokaj seꞌ yej aki̱xmatij, ma̱jwaꞌ sencholowaj, iga ayá̱ꞌ kitajto̱lkakij yej ná̱mo̱l. ");
INSERT INTO nhx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús kine̱xtilij ka̱n mami̱xkui̱ti̱ka̱n, eꞌ yejemej akimatikej te̱ kijto̱jneki. ");
INSERT INTO nhx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Inó̱n iga Jesús sej kijlij fariseojmej: —Nimitznojma‑ijliáj iga nej ken nipue̱rtaj ka̱n kalaki borre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Inochi yej wa̱lkej achto que nej, inó̱mejwaꞌ yej tachtekij iwá̱n tamagaj iga kikuij yej ayéj itatkimej; eꞌ borre̱gojmej ayá̱ꞌ kitajto̱lkakikej. ");
INSERT INTO nhx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nej nipue̱rtaj, yej ipan nej kalaki, moma̱nawiá, ken tikita inó̱n borrego yej ki̱sa iwá̱n kalaki iwá̱n kasi sakaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Yej tachteki wi̱ꞌ iga san tachtekiki, tamiktiá iwá̱n tapolowa, eꞌ nej niwa̱laj iga xiye̱ꞌonoka̱n nochipa, wa̱n amo mamitzpolo̱ka̱n nité̱. ");
INSERT INTO nhx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nej yej nikye̱ꞌcuida̱rowa borre̱gojmej. Pastor yej kiye̱ꞌcuida̱rowa borre̱gojmej este mote̱maka iga mamiki. ");
INSERT INTO nhx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Eꞌ yej tekipanowa iga san tata̱niá, kua̱ꞌ kita wi̱ꞌ se̱ weyi koyo̱ꞌ, ompa kikajte̱wa borre̱gojmej, iwá̱n cholowa, iga ayéj pastor iwá̱n iga ayéj itatki borre̱gojmej. Iwá̱n weyi koyo̱ꞌ kita̱talochtiá borre̱gojmej, iwá̱n sempa̱payi̱nij. ");
INSERT INTO nhx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inó̱n ta̱gaꞌ cholowa iga yéj kinékisan tomi̱n, ayéj borre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","’Nej yej nikye̱ꞌcuida̱rowa borre̱gojmej, inó̱n iga niki̱xmati noborre̱gojmej iwá̱n noborre̱gojmej no̱ ne‑i̱xmatij. ");
INSERT INTO nhx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ijkó̱n ken noTaj ne‑i̱xmati nej no̱ niki̱xmati noTaj; iwá̱n nej nimote̱maka iga manimiki iga noborre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nikpiá no̱ seꞌ noborre̱gojmej, yej ayá̱ꞌ onoꞌ ipan iní̱n kóla̱l, iwá̱n nia no̱ nikuajligati ipan iní̱n kóla̱l. Ijkó̱n yejemej no̱ ne̱tajto̱lkakiskej, iwá̱n onos se̱san kóla̱l iga borre̱gojmej iwá̱n se̱san pastor. ");
INSERT INTO nhx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Inó̱n iga noTaj ne̱cho̱kiliá, iga nimote̱maka iga nimiki iga noborre̱gojmej iwá̱n sej ni‑ojpa‑isas. ");
INSERT INTO nhx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ayagaj wel ne̱miktiá, sino que nej nimoyokate̱maka iga nimiki. Nej wel nimote̱maka iga mane̱mikti̱ka̱n iwá̱n wel sej ni‑ojpa‑isa. Ijkó̱n ne̱tekimáꞌ noTaj. ");
INSERT INTO nhx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kua̱ꞌ judiyojmej kikakikej inó̱n tajto̱lmej, sej moyojyokatijkej. ");
INSERT INTO nhx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Miaꞌ kijtowa̱yaj: —¿Te iga ankichi̱wiliáj caso, yejwaꞌ kipiá ma̱lespí̱ritoj iwá̱n lo̱kojtitoꞌ? ");
INSERT INTO nhx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Eꞌ sekin kijtowa̱yaj: —Ayagaj yej kipiá ma̱lespí̱ritoj wel ijkó̱n tajtowa. ¿Ix wel se̱ ma̱lespí̱ritoj ki̱xtapowa pachamej? ");
INSERT INTO nhx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Inó̱n ve̱j sektaj, iwá̱n Jerusalén nemi kilwichi̱wilia̱yaj weyitio̱pan. ");
INSERT INTO nhx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús onoya weyitio̱pan, ila̱doj kalte̱n yej ito̱ka̱ꞌ Salomón, ");
INSERT INTO nhx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","iwá̱n judiyojmej kiyawalojkej Jesús, iwá̱n tatajtankej: —¿Este ke̱man nikmelaꞌmatiskej a̱ꞌyéj in tej? Siga tej tiCri̱stoj xine̱nojma‑ijli̱ka̱n nokta. ");
INSERT INTO nhx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesús kijtoj: —Nimitzijlíjkeja iwá̱n ayá̱ꞌ anne̱cre̱dojkej. Yej ankitaj nikchi̱wa iga ijkó̱n nokta ne̱tekimaka noTaj, inó̱n kimelaꞌne̱xtiá a̱ꞌyéj in nej. ");
INSERT INTO nhx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Eꞌ amejemej ayá̱ꞌ ankicre̱dowaj iga ayéj anoborre̱gojmej, ijkó̱n ken nimitzijlíjkeja. ");
INSERT INTO nhx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noborre̱gojmej ne̱tajto̱lkakij, iwá̱n nej no̱ niki̱xmatij iwá̱n ne̱tokaj. ");
INSERT INTO nhx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Nej nikchi̱wa iga nochipa maonoka̱n iwá̱n noTaj, iwá̱n ayagaj ne̱kui̱li̱j. ");
INSERT INTO nhx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nochi noborre̱gojmej ne̱máꞌ noTaj, yéj má̱j kipiá poder que nochi, iwá̱n ayagaj wel kikui̱liá yej kipiá ipan ima̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nej iwá̱n noTaj se̱san. ");
INSERT INTO nhx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iwá̱n judiyojmej sej kikuikej teꞌti iga kipata̱naltiliáj Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iwá̱n Jesús kijtoj: —Níkchija miaꞌ yej ye̱kti amo‑i̱xtaj iga ipode̱r noTaj; ¿iga katiapa de inó̱n yej nikchij annetemiti̱jnekij? ");
INSERT INTO nhx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judiyojmej kijtojkej: —Ayá̱ꞌ niawij nimitztewi̱tij iga tikchij yej ye̱kti, sino que iga tima̱ltajtoj iga Dios; tej tita̱gaꞌ iwá̱n tikijtowa iga tiDio̱s. ");
INSERT INTO nhx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús kijlij judiyojmej: —Ipan amoley ijkuilijtoꞌ yej Dios kijtoj: “Amejeme̱n andio̱smej.” ");
INSERT INTO nhx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tikmatij iga yej kijtowa itájto̱l Dios ijko̱nya nokta, iwá̱n Dios kito̱ka̱wij dio̱smej ino̱mej yej kikakikej itájto̱l. ");
INSERT INTO nhx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Siga Dios ne̱tapejpen iwá̱n ne̱ti̱tan ipan iní̱n ta̱jli, ¿kén ankijto̱skej iga nima̱ltajtoj iga nikijtoj iga nej iPiltzi̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Siga ayá̱ꞌ nikchi̱wa yej kichi̱wa noTaj, amo xine̱cre̱do̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Eꞌ siga nikchi̱wa yej kichi̱wa noTaj, malej ayá̱ꞌ anne̱cre̱dowaj nej, eꞌ xicre̱do̱ka̱n yej nikchi̱wa, iga xikmelaꞌmatika̱n nokta iga noTaj onoꞌ nowa̱n iwá̱n nej nonoꞌ iwá̱n noTaj. ");
INSERT INTO nhx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Sej kiwi̱gasnekiáj preso, eꞌ Jesús choloj. ");
INSERT INTO nhx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iwá̱n Jesús yajki ipan we̱ya̱ꞌ Jordán iki̱sáya̱mpa to̱nati̱ꞌ, iwá̱n ompa ka̱wiꞌ, ka̱n Juan tekitabautiza̱rowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Miaꞌ gente yajkij kitatoj, iwá̱n kijtowa̱yaj: —Melá̱ꞌ iga Juan ayá̱ꞌ kichij nisé̱ milagro, eꞌ nochi ken kijtoj Jesús, ómpaya nokta. ");
INSERT INTO nhx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Miaꞌ kicre̱doj Jesús ompa ka̱n onoyaj. ");
INSERT INTO nhx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Onoya se̱ ta̱gaꞌ yej we̱titoya yej ito̱ka̱ꞌ Lázaro. Isiwa‑ikni̱mej ito̱ka̱ꞌ María iwá̱n Marta, Lázaro iwá̱n isiwa‑ikni̱mej icha̱mej Betania. ");
INSERT INTO nhx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Iní̱n María yej isiwa‑ikni̱n Lázaro yej we̱titoya, ini̱nya María yej kitoya̱wilij aceite yej ajwiya̱ꞌ ipan iyikxi toTe̱ko iwá̱n kiwa̱ki̱ltij iga itzónkal. ");
INSERT INTO nhx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ino̱mej o̱me siwa̱tkej tati̱tankej iga ijkí̱n makijli̱tij Jesús: —NoTe̱ko, moami̱goj yej tikpoxcho̱kiliá, we̱titoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Kua̱ꞌ Jesús inó̱n kikaguiꞌ, kijtoj: —Iní̱n kokolis ayá̱ꞌ kimikti̱j, ino̱nwaꞌ iga mamoweyimati̱lti Dios kua̱ꞌ mone̱xtiá yej yéj wel kichi̱wa iwá̱n iga no̱ mamone̱xti iga nej iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Malej iga Jesús kipoxcho̱kilia̱ya Marta, María iwá̱n Lázaro, ");
INSERT INTO nhx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","kua̱ꞌ kijlijkej iga Lázaro we̱titoꞌ, Jesús ká̱wigoꞌ o̱me día ompa ka̱n onoya. ");
INSERT INTO nhx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Iwá̱n kijlij idisci̱polojmej: —Tiaka̱n sej Judea. ");
INSERT INTO nhx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Idisci̱polojmej kijlijkej: —Tamachtia̱ni, i̱kí̱n judiyojmej mitztemikti̱jnekiáj, ¿iná̱n sej tia̱jneki ompiga? ");
INSERT INTO nhx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesús kijtoj: —¿Ix aya̱ꞌtaj ankimatij iga día kipiá doce hora? Siga se̱ nejnemi ipan día, ayá̱ꞌ mokxiwi̱teki iga ta̱wi̱lpan. ");
INSERT INTO nhx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Eꞌ siga se̱ nejnemi tayowaka̱n, mokxiwi̱teki iga ayá̱ꞌ ta̱wi̱lpan. ");
INSERT INTO nhx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iwá̱n Jesús kijtoj: —Toami̱goj Lázaro kóchiꞌya, eꞌ nia nikixiti̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Disci̱polojmej kijtojkej: —NoTe̱ko, siga kóchiꞌya, inó̱n kito̱jneki iga yawi achitiati. ");
INSERT INTO nhx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Eꞌ Jesús iní̱n kijtoj iga Lázaro míguiꞌya, iwá̱n idisci̱polojmej kejla̱ntoyaj anka kochtoya. ");
INSERT INTO nhx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iwá̱n Jesús kinojma‑ijtoj: —Lázaro míguiꞌya. ");
INSERT INTO nhx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nipa̱ki iga ayá̱ꞌ ompa nonoya, iga ijkó̱n má̱j ye̱kti iga amejemej xine̱cre̱do̱ka̱n. Eꞌ tiaka̱n matikitatij. ");
INSERT INTO nhx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iwá̱n Tomás yej kijliáj Kua̱tej, kijlij sekin yej no̱ disci̱polojmej: —Tiaka̱n no̱ iga matimikika̱n wa̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kua̱ꞌ asiꞌ ompiga, Jesús kimatiꞌ iga Lázaro kiwí̱gaya na̱wi día iga kito̱kakej. ");
INSERT INTO nhx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania onoya ite̱noj Jerusalén, mo‑itztoyaj ken e̱yi kilómetro; ");
INSERT INTO nhx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","iwá̱n miaꞌ judiyojmej yajkij kipaxa̱lowili̱toj Marta iwá̱n María iga kiyo̱lchika̱watoj, iga miguiꞌ iyikni̱n. ");
INSERT INTO nhx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kua̱ꞌ Marta kimatiꞌ iga Jesús nemi asi, yajki ko̱mema̱wi̱to, eꞌ María ka̱wiꞌ kalijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Iwá̱n Marta kijli Jesús: —NoTe̱ko, siga nigaj katka tonoya, nokni̱n ayá̱ꞌ mikiá. ");
INSERT INTO nhx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Eꞌ malej ijkó̱n, nej nikmati iga Dios yawi mitzmakati nochi yej tej tiktajtanili̱j. ");
INSERT INTO nhx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesús kijtoj: —Mokni̱n yawi ojpa‑isati. ");
INSERT INTO nhx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta kijtoj: —Kena, nej nikmati iga yawi ojpa‑isati kua̱ꞌ yej miktókeja ojpa‑isaskej ipan último día. ");
INSERT INTO nhx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iwá̱n Jesús kijtoj: —Nejwaꞌ in yej nitaojpa‑ixitiá iwá̱n yej nitamaka vida. Yej kicre̱dowa ipan nej, malej iga mamiki, ojpa‑isas, ");
INSERT INTO nhx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","iwá̱n nochi yej isatokej iwá̱n kicre̱dowaj ipan nej, ayá̱ꞌ mikiskej nike̱man. ¿Ix ticre̱dowa yej nikijtowa? ");
INSERT INTO nhx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marta kijtoj: —Kena noTe̱ko, nej nicre̱dowa iga tej el Cristo yej iPiltzi̱n Dios, yej wi̱tziá ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kua̱ꞌ tamiꞌ iní̱n kijtoj, Marta yajki kino̱tzato María yej iyíkni̱mpa iwá̱n ki‑ichtaka‑ijlij: —In Tamachtia̱ni nígaja onoꞌ iwá̱n mitzno̱tza. ");
INSERT INTO nhx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Kua̱ꞌ María inó̱n kikaguiꞌ, nimaní̱n moketzaꞌ iwá̱n yajki ka̱n onoꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesús aya asiá ipan inó̱n a̱ltepe̱ꞌ, onoya ompa ka̱n Marta ki̱xna̱mikito. ");
INSERT INTO nhx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kua̱ꞌ kitakej María moketzaꞌ iwá̱n ki̱ste̱waꞌ, judiyojmej yej onoyaj cha̱n María iga kiyo̱lchika̱waj, kitokakej, yejemej kijtojkej anka yawi ka̱n moto̱gaꞌ Lázaro iga cho̱kati. ");
INSERT INTO nhx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kua̱ꞌ María asiꞌ ka̱n onoꞌ Jesús, motankua̱ketzaꞌ ite̱noj iwá̱n kijlij: —NoTe̱ko, siga nigaj tonoya, nokni̱n ayá̱ꞌ mikiá. ");
INSERT INTO nhx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kua̱ꞌ Jesús kitaꞌ iga cho̱katoꞌ María iwá̱n judiyojmej yej íwa̱n wa̱lkej, Jesús poxsan mokno̱matiꞌ este kualo̱ꞌ iya̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Iwá̱n Jesús tatajtan: —¿Ka̱n ankito̱kakej in Lázaro? Yejemej kijtojkej: —NoTe̱ko, xiwi̱ki xikitaki. ");
INSERT INTO nhx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Iwá̱n Jesús cho̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judiyojmej kijtojkej: —Taꞌ xikitaka̱n ken iga kipoxcho̱kilia̱ya Lázaro. ");
INSERT INTO nhx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Eꞌ sekin de yejemej kijtojkej: —In iní̱n yej kitachaltij yej pacha, ¿ix awel katka tejté̱ kichij iga Lázaro amo mamiki? ");
INSERT INTO nhx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús sej cho̱gaꞌ iya̱lmaj, kitechoj a̱nimajxapoꞌ, inó̱n xapoꞌ te̱ntzaktoya iga se̱ weyiteꞌti. ");
INSERT INTO nhx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesús kijtoj: —Xika̱naka̱n inó̱n teꞌti. Eꞌ Marta yej iyikni̱n yej miguiꞌ, kijlij Jesús: —NoTe̱ko, anka machaya a̱n in nokni̱n, iga kiwi̱gaya na̱wi día iga miguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Eꞌ Jesús kijtoj: —¿Ix ayá̱ꞌ nimitzijlij, siga ticre̱dowa tia tikitati iweyipode̱r Dios? ");
INSERT INTO nhx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Iwá̱n ke̱nakej teꞌti ka̱n kita̱lkaj yej miktoꞌ. Iwá̱n Jesús ajkotacháꞌ ipan cielo iwá̱n kijtoj: —NoTaj, nimitzmaka gracias iga tinekaguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nej nikmati iga nochipa tine̱kaki, eꞌ nikijtoj iní̱n iga ini̱mej gente yej nij onokej makicre̱do̱ka̱n iga tej tine̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kua̱ꞌ tamiꞌ iní̱n kijtoj, tzájtziꞌpa iga kijtoj: —¡Lázaro, xiki̱sa ompa! ");
INSERT INTO nhx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lázaro yej miktoyay, ki̱saꞌ, majma‑ilpitoya iwá̱n ijikxiilpitoya iga tzótzol iwá̱n xa̱ygatzaktoya iga tzótzol. Jesús kijtoj: —Xikxi̱xitomaka̱n iwá̱n mayáwiya. ");
INSERT INTO nhx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Iwá̱n miaꞌ judiyojmej yej senyajkij iwá̱n María kua̱ꞌ kitakej yej kichij Jesús, kicre̱dojkej ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Eꞌ sekin de yejemej yajkij kitatoj fariseojmej, iwá̱n kipowilijkej yej kichij Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Iwá̱n fariseojmej iwá̱n ije̱fejmej sacerdo̱tejmej monechkojkej wa̱n yej kimanda̱rowaj judiyojmej iga mota̱tapo̱wijkej iwá̱n kijtojkej: —¿Te̱ tikchi̱waskej? Iní̱n ta̱gaꞌ nemi kichi̱wa miaꞌ milagro. ");
INSERT INTO nhx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Siga ijko̱nsan tikajte̱waj, nochi gente yawi kicre̱do̱ti ipan yéj, iwá̱n yej manda̱rowaj Roma wi̱tzej iga kixi̱xiti̱nakij toweyitio̱pan iwá̱n topaí̱s. ");
INSERT INTO nhx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Eꞌ se̱ de yejemej yej ito̱ka̱ꞌ Caifás yej inó̱n año onoya iga ije̱fej sacerdo̱tejmej, kijtoj: —Amejemej ayá̱ꞌ ankimatij nité̱, ");
INSERT INTO nhx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","niga ankimatij iga má̱j ye̱kti mamiki se̱ ta̱gaꞌ iga nochi gente, eꞌ amo mapoliwi nochi tokni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Eꞌ Caifás ayejsan iga yéj kiyoka‑ijtoj; iga yéj katka ije̱fej sacerdo̱tejmej inó̱n año, kijtoj ijkó̱n iga Dios kitajto̱lmáꞌ iga Jesús yawi mikiti iga inewi judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ayejsan iga judiyojmej, sino que yawi mikiti iga makinechko nochi ipilowa̱n Dios yej pa̱payi̱ntokej no̱ya̱n pan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Inó̱n iga este íkua̱ꞌ, yej kimanda̱rowaj judiyojmej motajto̱ltijkej iga makimikti̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Inó̱n iga Jesús ayꞌya mone̱xtia̱ya iyi̱xtaj judiyojmej, sino que ki̱saꞌ ipan inó̱n íta̱l Judea iwá̱n yajki ite̱noj desierto ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Efraín. Iwá̱n ompa ka̱wiꞌ iwá̱n idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ayꞌya wejka iga judiyojmej kichi̱waj ilwiꞌ yej kijliáj Pascua, iwá̱n miaꞌ gente de miaꞌ a̱ltepe̱mej yajkij Jerusalén iga kichi̱waj yej moneki iga wel makiweyimati̱lti̱ka̱n Dios, iní̱n kichi̱wayaj kua̱ꞌ aya pe̱wa iyilwi la Pascua. ");
INSERT INTO nhx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Kite̱mojtinemiáj Jesús, iwá̱n kua̱ꞌ onoyaj tio̱pan, mose̱sepantajtaniáj: —¿Kén ankijtowaj? ¿Ix wi̱ꞌ a̱n ilwitaj, o ayá̱ꞌ? ");
INSERT INTO nhx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Fariseojmej iwá̱n ije̱fejmej sacerdo̱tejmej tatekimakakej iga si agaj kimati ka̱n onoꞌ Jesús, makijto, iga makiki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Poliwiaoꞌ seis día iga mochi̱wa ilwiꞌ yej kijliáj la Pascua. Jesús yajki Betania ka̱n cha̱ntitoya Lázaro, inó̱n yej ki‑ojpa‑ixitij ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ompa kichijkej tákual iga ko̱mema̱wijkej Jesús; Marta kitajta̱lia̱ya tákual, iwá̱n Lázaro se̱ de ino̱mej yej takuajtoyaj iwá̱n Jesús ipan mesa. ");
INSERT INTO nhx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Iwá̱n María kiwajli̱ꞌ ken medio litro aceite yej ajwiya̱ꞌ yej chijtoꞌ de se̱ xo̱chiꞌ yej ito̱ka̱ꞌ nardo, yej poxsan patiyoj iwá̱n kitoya̱wilij Jesús ipan iyikxi, iwá̱n kiwa̱ki̱ltilij iga itzónkal. Iwá̱n no̱ya̱n kalijtiꞌ taajwiya̱yaya. ");
INSERT INTO nhx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Iwá̱n Judas Iscariote, yej ipiltzi̱n Simón, se̱ de idiscí̱poloj Jesús yej yawi kine̱xti̱ti Jesús iga makiki̱tzki̱ka̱n, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Te iga ayá̱ꞌ monamáꞌ iní̱n yej ajwiya̱ꞌ iga mamopale̱wi yej amotapialiáj? Iní̱n ipatiyo ke̱ꞌ se̱ kita̱niá ipan trescientos días. ");
INSERT INTO nhx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Eꞌ Judas kijtoj iní̱n, ayéj iga kineki mamopale̱wi yej amotapialiáj, sino que iga tachteki, como yéj kinechkowa̱ya tomi̱n, kichtekiá yej ompa ke̱naya. ");
INSERT INTO nhx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iwá̱n Jesús kijtoj: —Xikajte̱wa, iga yéj nemi machtowiá iga ne̱tajta̱liliá yej ne̱ta̱lili̱skej kua̱ꞌ ne̱to̱kaskej. ");
INSERT INTO nhx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Yej amotapialiáj, nochipa onos amowa̱n, eꞌ nej ayá̱ꞌ nochipa nij anne̱piaskej. ");
INSERT INTO nhx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Miaꞌ judiyojmej kimatikej iga Jesús onoꞌ Betania, iwá̱n yajkij ompiga, ayejsan iga kitatoj Jesús, no̱ kitatoj Lázaro yej Jesús ki‑ojpa‑ixitij ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Iwá̱n ije̱fejmej sacerdo̱tejmej motajto̱ltijkej iga no̱ yawij kimikti̱tij Lázaro, ");
INSERT INTO nhx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","iga itechko yéj, miaꞌ judiyojmej kikajtejkej iga kitokaj sacerdo̱tejmej iga kitókaja Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Miaꞌ gente yajki Jerusalén iga kilwichi̱wiliáj la Pascua; ipan seꞌya día kimatikej iga Jesús yawi asiti ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Iwá̱n kimajma̱tekkej so̱ya̱ꞌ iwá̱n yajkij ki̱xna̱mikitoj Jesús, tzajtzitiajkij: —¡Mamoweyimati̱lti Dios! ¡Mamoweyimati̱lti yej kiti̱tani toTe̱ko Dios! ¡Maye̱ꞌtajto̱lo iga iRre̱y Israel! ");
INSERT INTO nhx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús kasiꞌ se̱ burro iwá̱n tejkaj ípan, ken kijtowa ka̱n ijkuilijtoꞌ itájto̱l Dios: ");
INSERT INTO nhx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Amo ximajmawika̱n yej ancha̱ntitokej ipan a̱ltepe̱ꞌ Jerusalén; xikitaka̱n iga wi̱ꞌ moRrey, tejkatiwi̱ꞌ ipan se̱ burro. ");
INSERT INTO nhx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kua̱ꞌ inó̱n kichij Jesús idisci̱polojmej ayá̱ꞌ kentende̱rowa̱yaj, eꞌ má̱j má̱j kua̱ꞌ Jesús yájkiya ipan cielo, kejla̱nkej iga nochi inó̱n ijkuilijtoya de yéj, inó̱n iga ijkó̱n mochij. ");
INSERT INTO nhx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","La gente yej onoyaj kua̱ꞌ Jesús kino̱tzaꞌ Lázaro xapoko iwá̱n kitakej kén iga ki‑ojpa‑ixitij, kipowayaj yej kitakej. ");
INSERT INTO nhx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Inó̱n iga la gente ki̱xna̱mikitoj Jesús, iga kimatikej iga kichij inó̱n milagro. ");
INSERT INTO nhx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Iwá̱n fariseojmej mosepan‑ijlijkej: —Ankitákeja, awel te̱ tikchi̱waj. Taꞌ xikitaka̱n, nochi gente kitoka Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Yajkij no̱ sekin grie̱gojmej iwá̱n ino̱mej gente yej yajkij Jerusalén ilwitaj iga kiweyimati̱lti̱toj Dios. ");
INSERT INTO nhx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ini̱mej grie̱gojmej kitechojkej Felipe, yej de Betsaida, estado de Galilea, iwá̱n kitajtankej: —Ej, niknekij manikitaka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe yajki kijli̱to Andrés iwá̱n iyo̱mextimej yajkij kijli̱toj Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iwá̱n Jesús kijtoj: —Ásiꞌya hora iga iPiltzi̱n Ta̱gaꞌ yawij kiweyimati̱lti̱tij. ");
INSERT INTO nhx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nimitzijliáj siga se̱ íyo̱l trigo ayá̱ꞌ wetzi ipan ta̱jli iwá̱n miki, segui̱rówasan iga ono se̱san; eꞌ siga miki yawi pi̱witi komati íyo̱l. ");
INSERT INTO nhx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yej igá̱najsan mocho̱kiliá, yawi poliwiti, eꞌ yej ipan iní̱n ta̱jli mote̱maka iga makisufri̱ro iga nej ne̱toka, nochipa yawi onoti wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Siga agaj kineki matekipano iga nej, mane̱toka; iwá̱n ka̱n nej nonos, ompa no̱ onos yej tekipanowa iga nej. Siga agaj tekipanowa iga nej, noTaj yawi kiye̱ꞌitati. ");
INSERT INTO nhx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Iná̱n pox nitayo̱koxtoꞌ; ¿te̱ nia nikijto̱ti? ¿Ix manikijto: “NoTaj, xine̱ma̱nawi ipan iní̱n yej yawij ne̱chi̱wili̱tij iná̱n”? Eꞌ iga inó̱n nokta niwa̱laj. ");
INSERT INTO nhx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","NoTaj, xikchi̱wa iga makiweyimati̱lti̱ka̱n moto̱ka̱ꞌ. Iwá̱n mokáꞌ se̱ tájto̱l ipan cielo yej kijtoj: —Níkchija iga mamoweyimati̱lti, iwá̱n sej nia nikweyimati̱lti̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Yej ompa takaktoyaj, kijtowa̱yaj iga tatikui̱niꞌ, iwá̱n sekin kijtowa̱yaj: —Se̱ ángel kino̱tzaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iwá̱n Jesús kijtoj: —Ayéj iga nej mokaguiꞌ iní̱n tájto̱l, sino que iga amejemej. ");
INSERT INTO nhx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Á̱manya nokta, Dios yawi kijuzga̱ro̱ti nochi yej onokej ipan iní̱n ta̱jli, iwá̱n a̱man yawi kiki̱xti̱tij tzitzimiꞌ yej manda̱rowa ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iwá̱n kua̱ꞌ neajkokuiskej ipan cruz, nochi yawi ne̱cre̱do̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iga iní̱n yej Jesús kijtoj, kijtoj kén iga yawi mikiti. ");
INSERT INTO nhx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Iwá̱n la gente kijtoj: —Ka̱n ijkuilijtoꞌ la ley kijtowa iga Cristo nochipa onos. ¿Te ígataj tikijtowa iga iPiltzi̱n Ta̱gaꞌ yawij kajkokuitij ipan se̱ cruz? ¿A̱ꞌyéj in inó̱n iPiltzi̱n Ta̱gaꞌ? ");
INSERT INTO nhx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iwá̱n Jesús kijtoj: —Yej ta̱wiá ónosoꞌ iwá̱n amejemej, eꞌ ayá̱ꞌ wejka̱was iga onos amowa̱n. Xinemika̱n mie̱j ankipiajoꞌ inó̱n yej ta̱wiá, iga amo mamitztecho̱ka̱n yówal; iga yej nejnemi takomichka̱n akimati ka̱n yawi. ");
INSERT INTO nhx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xicre̱do̱ka̱n ipan yej mitzta̱wiáj, mie̱j ónogoꞌ amowa̱n, ijkó̱n annemiskej ka̱n taxo̱talpa̱n. Kua̱ꞌ tamiꞌ inó̱n kijtoj, Jesús yajki ka̱n awel kasikej. ");
INSERT INTO nhx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Malej iga Jesús kíchija miaꞌ milagro iyi̱xtaj yejemej, ayá̱ꞌ kicre̱dojkej ipan yéj ");
INSERT INTO nhx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","iga mamochi̱wa ken kijkuiloj el profeta Isaías: NoTe̱ko, ¿a̱ꞌyéj kicre̱doj notájto̱l? ¿A̱ꞌyéj kine̱xtilij toTe̱ko ipode̱r? ");
INSERT INTO nhx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Inó̱n iga awel kicre̱dowa̱yaj iga ijkí̱n no̱ kijkuiloj Isaías: ");
INSERT INTO nhx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios kipajpachatilij iwá̱n kiyo̱ltakua̱wilij, iga amo matachaka̱n iga iyi̱xmej, niga makentende̱ro̱ka̱n iga iya̱lmajmej, niga mawi̱tzeka̱n note̱noj iga manikachitialti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías kijtoj inó̱n iga kitaꞌ iweyipode̱r Jesús, iwá̱n tajtowa̱ya de yéj. ");
INSERT INTO nhx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Eꞌ malej ijkó̱n, miaꞌ judiyojmej kicre̱dojkej Jesús, este yej má̱j tayaka̱ntokej, eꞌ ayá̱ꞌ momelaꞌne̱xtia̱yaj iga kimajmawilia̱yaj fariseojmej iga amo makiki̱xti̱ka̱n tio̱pan. ");
INSERT INTO nhx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Akicre̱dojkej ipan Jesús iga má̱j kinekiáj iga la gente makiye̱ꞌitaka̱n, que Dios makiye̱ꞌita. ");
INSERT INTO nhx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús tajtoj recio: —Yej kicre̱dowa ipan nej, ayá̱ꞌ ipansan nej kicre̱dowa, no̱ ipan noTaj yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yej nej ne‑ita, no̱ kita yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nej yej nita̱wiá, niwa̱laj ipan iní̱n ta̱jli iga yej ne̱cre̱dowa amo maono ka̱n takomichka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Eꞌ siga agaj kikaki notájto̱l iwá̱n ayá̱ꞌ kichi̱wa ken nikijtowa; ayéj nej yej nikjuzga̱rowa iga nej ayá̱ꞌ niwa̱laj iga nitajuzga̱ro̱ko, sino que iga nitasalva̱ro̱ko. ");
INSERT INTO nhx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yej ane̱ye̱ꞌita iwá̱n ayá̱ꞌ ne̱tajto̱lkui, ónoꞌya a̱ꞌ kijuzga̱rowa: notájto̱l yej nikijtoj, inó̱n yawi kijuzga̱ro̱ti ipan último día. ");
INSERT INTO nhx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Iga yej nikijtowa, ayá̱ꞌ nejsan nikte̱nchi̱wa; noTaj yej ne̱ti̱tan ne̱tekimaka iwá̱n ne̱ne̱xtiliá te̱ manikijto. ");
INSERT INTO nhx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nikmati iga inó̱n yej tatekimaka noTaj, kichi̱wa iga yej kicre̱dowaj nochipa maonoka̱n wa̱n yéj. Yej nikijtowa, nikijtowa ken noTaj ne̱tekimaka. ");
INSERT INTO nhx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Kua̱ꞌ mo̱stápaya iyilwiyo la Pascua, Jesús kimatiáy iga ásiꞌya hora iga yawi kikajte̱wati iní̱n ta̱jli iga yáwiya ka̱n onoꞌ toTaj. Yéj nochipa kicho̱kilij yej kitokatinemiáj, yej onoyaj ipan iní̱n ta̱jli, iwá̱n iga mikis ne̱sis iga kipoxcho̱kiliá ini̱mej yej yéj itatki. ");
INSERT INTO nhx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nemi cena̱rowa̱yaj. Ompa no̱ onoya Judas Iscariote yej ipíltzi̱mpa Simón. Tzitzimiꞌ áchtoya kijlij Judas ipan iya̱lmaj iga makine̱xti Jesús iga makiki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús kimatiáy iga toTaj kimaꞌya nochi poder, kimatiá iga yéj kiti̱tan iwá̱n yawi sej ka̱n onoꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Moketzaꞌ ka̱n nemi cena̱rowa, kiki̱xtij isota̱ntzótzol iwá̱n motajko‑ilpij iga toalla. ");
INSERT INTO nhx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Iwá̱n kakij a̱ꞌti ipan se̱ xí̱kal iwá̱n pe̱waꞌ kikxipa̱ka idisci̱polojmej, iwá̱n kijikxiwa̱tztiajki iga tzótzol yej iga tajko‑ilpitoya. ");
INSERT INTO nhx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kua̱ꞌ asiꞌ ite̱noj Simón Pedro, Pedro kijtoj: —NoTe̱ko, ¿ix kajasi iga tej xine‑ikxipa̱ka? ");
INSERT INTO nhx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesús kijtoj: —Iná̱n ayá̱ꞌ tikentende̱rowa yej nemi nikchi̱wa, eꞌ ke̱man tikentende̱ro̱j. ");
INSERT INTO nhx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro kijlij: —Ayí̱ꞌ nimomakas iga xine‑ikxipa̱ka. Jesús kijtoj: —Siga ayá̱ꞌ nimitzikxipa̱ka, awelwaꞌ timochi̱wa tinodisci̱poloj. ");
INSERT INTO nhx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simón Pedro kijtoj: —NoTe̱ko, ámosanwaꞌ xine‑ikxipa̱ka; no̱ xine̱ma̱pa̱ka iwá̱n no̱ xine̱kua̱pa̱ka. ");
INSERT INTO nhx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Eꞌ Jesús kijtoj: —Yej má̱ltijoꞌ kinékisan mamo‑ikxipa̱ka iga ino̱ya̱n ejtoꞌ. Iwá̱n amejeme̱n an‑ejtokej, malej iga ayá̱ꞌ amonochi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Kijtoj iga ayá̱ꞌ inochi̱n ejtokej, iga kimatiá a̱ꞌyéj yawi kine̱xti̱ti iga makiki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Kua̱ꞌ tamiꞌ ta‑ijikxipa̱gaꞌ, Jesús sej kakij isota̱ntzótzol, iwá̱n sej ki̱xna̱n mesa iwá̱n kijtoj: —¿Ix ankentende̱rowaj yej nimitzchi̱wilijkej? ");
INSERT INTO nhx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Amejeme̱n anne‑ijliáj iga nej amoMae̱stroj iwá̱n iga amoTe̱ko, iwá̱n ómpaya iga ijkó̱n anne‑ijliáj. ");
INSERT INTO nhx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Siga nej amoMae̱stroj iwá̱n amoTe̱ko, nimitzikxipa̱kakej, ijko̱nsan no̱ amejeme̱n ximosepan‑ikxipa̱kaka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nej nimitzne̱xtilijkej ken xikchi̱waka̱n, iga ijko̱nsan no̱ xikchi̱waka̱n ken nimitzchi̱wilijkej. ");
INSERT INTO nhx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nimitznojma‑ijliáj iga nisé̱ tekipanowa̱ni awel mochi̱wa ma̱jya sej que ipatró̱n, iwá̱n nisé̱ yej kiti̱tankej ayá̱ꞌ ma̱jya sej que yej tati̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Siga ankentende̱rowaj iní̱n yej nimitzijlijkej iwá̱n ankichi̱waj, anyo̱lpa̱ktoskej. ");
INSERT INTO nhx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Iní̱n ayá̱ꞌ nemi nimitzijliáj amonochi̱n, iga nikye̱ꞌi̱xmati aja̱ꞌyéj niktapejpen. Eꞌ yawi mochi̱wati yej kijtowa ka̱n ijkuilijtoꞌ: “Yej takua nowa̱n, ne‑ijiyay.” ");
INSERT INTO nhx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Áchtoya iní̱n nimitzijliáj iga kua̱ꞌ mochi̱was, amejeme̱n xikmatika̱n a̱ꞌyéj nej. ");
INSERT INTO nhx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nimitznojma‑ijliáj iga yej ki‑o̱mema̱wiá yej nej nikti̱tani, nej neo̱mema̱wiá, iwá̱n yej neo̱mema̱wiá, ki‑o̱mema̱wiá yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Kua̱ꞌ tamiꞌ iní̱n kijtoj, Jesús poxsan moyo̱lmiktij, iwá̱n kinojma‑ijtoj: —Nimitznojma‑ijliáj, iga se̱ de amejeme̱n yawi ne̱ne̱xti̱ti iga mane̱ki̱tzki̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Iwá̱n disci̱polojmej mose̱sepantachi̱lijkej iga ayá̱ꞌ kimatiáj de a̱ꞌyéj nemi tajtowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Se̱ de idiscí̱poloj, yej Jesús kipoxcho̱kilia̱ya, takuajtoyaj ite̱noj; ");
INSERT INTO nhx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","iwá̱n Simón Pedro kima̱no̱tzaꞌ iga kitajtan de a̱ꞌyéj nemi tajtowa. ");
INSERT INTO nhx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Iwá̱n inó̱n discípulo má̱j kina̱ꞌtechoj Jesús, iwá̱n kitajtan: —NoTe̱ko, ¿a̱ꞌyéj? ");
INSERT INTO nhx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesús kijtoj: —Nia nitapalo̱ti iga tájkol pa̱n, iwá̱n yej nikmakas, ino̱nya nokta. Iwá̱n tapaloj iga tájkol pa̱n iwá̱n kimáꞌ Judas Iscariote, yej ipiltzi̱n Simón. ");
INSERT INTO nhx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kua̱ꞌ Judas kikuiꞌ pa̱n, Tzitzimiꞌ kalaꞌ ipan iya̱lmaj. Iwá̱n Jesús kijtoj: —Yej tia tikchi̱wati, xikchí̱waya sémiya. ");
INSERT INTO nhx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Eꞌ ni agaj yej ki̱xna̱ntoyaj mesa akimatiꞌ te íga ijkó̱n kijlij. ");
INSERT INTO nhx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas kinentia̱ya kuetaxbo̱lsaj ka̱n ke̱naya tomi̱n, sekin kijtojkej anka Jesús nemi kijliá iga makikowa tejté̱ yej moneki ipan ilwiꞌ o makimaka tejté̱ yej ayá̱ꞌ motapialiáj. ");
INSERT INTO nhx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kua̱ꞌ Judas kíkuiꞌya in pa̱n, ki̱saꞌ. Íkua̱ꞌwaꞌ takó̱miya. ");
INSERT INTO nhx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kua̱ꞌ Judas kí̱saꞌya, Jesús kijtoj: —Iná̱n mone̱xtiá iweyipode̱r iPiltzi̱n Ta̱gaꞌ, iwá̱n iweyipode̱r Dios mone̱xtiá ipan yéj. ");
INSERT INTO nhx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Siga iPíltzi̱mpa Ta̱gaꞌ kine̱xtiá iweyipode̱r Dios, Dios kine̱xti̱j iweyipode̱r iPiltzi̱n, iwá̱n ina̱nwaꞌ yáwiya kine̱xti̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nopilowa̱ntzitzi̱n, ayoꞌ má̱j nonos amowa̱n. Amejeme̱n anne̱te̱mo̱skej; eꞌ ino̱nsan yej nikijlij judiyojmej, ino̱nsan no̱ nimitzijliáj amejeme̱n: Ayá̱ꞌ wel anya̱skej ka̱n nej nia. ");
INSERT INTO nhx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nimitzmakaj iní̱n nuevo mandamiento: ximose̱pancho̱kili̱ka̱n. Ijkó̱n ken nej nimitzcho̱kiliáj, amejeme̱n no̱ ximose̱pancho̱kili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Siga anmose̱pancho̱kiliáj, nochi kimatis iga amejeme̱n annodisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedro kitajtan Jesús: —NoTe̱ko, ¿ka̱n tia? Jesús kijtoj: —Ka̱n nej nia; iná̱n awel tine̱tokas, eꞌ ke̱man tine̱tokas. ");
INSERT INTO nhx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Iwá̱n Pedro kijtoj: —NoTe̱ko, ¿te iga iná̱n awel nimitztokas? Nej niksentá̱lija noa̱lmaj iga manimiki iga tej. ");
INSERT INTO nhx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesús kijtoj: —¿Ix melá̱ꞌ iga tiksentá̱lija moa̱lmaj iga timikis iga nej? Nimitznojma‑ijliá iga kua̱ꞌ áyapa takui̱ka ka̱yo, tia tikijto̱ti e̱yi ve̱j iga ayá̱ꞌ tine‑i̱xmati. ");
INSERT INTO nhx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Kijtoj Jesús: —Amo xitayo̱koxtoka̱n, ximoconfia̱ro̱ka̱n ipan Dios iwá̱n ipan nej no̱. ");
INSERT INTO nhx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ipan íkal noTaj pox onoꞌ ka̱n wel mocha̱ntilo, siga ayéj ijkó̱n, nimitzijlia̱yaj katka. Niáoꞌwaꞌ nikchi̱wati ka̱n ximocha̱nti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kua̱ꞌ nia̱jya iwá̱n nimitzchi̱wilí̱skeja ka̱n amonoskej, niwi̱ꞌ sej iga nimitzkuikij, iga ka̱n nonos nej, ompa no̱ xonoka̱n amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Amejeme̱n ankimatij ka̱n nia, iwá̱n anki̱xmatij ojti. ");
INSERT INTO nhx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomás kijtoj: —NoTe̱ko ayá̱ꞌ nikmatij ka̱n tia; ¿kén nikmatiskej in inó̱n ojti? ");
INSERT INTO nhx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesús kijtoj: —Nejwaꞌ in inó̱n ojti, nej yej anitakajkaya̱wa, wa̱n nitamaka vida. Ayagaj wel asi ka̱n onoꞌ toTaj Dios siga ayá̱ꞌ moconfia̱rowa ipan nej. ");
INSERT INTO nhx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Siga katka xine‑i̱xmatika̱n, no̱ anki̱xmatiáj noTaj; iwá̱n iná̱n anki̱xmátija, iwá̱n ankitákeja. ");
INSERT INTO nhx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Felipe kijtoj: —NoTe̱ko, xine̱ne̱xtilí̱ka̱nwaꞌ in toTaj, iwá̱n ayoꞌ má̱j nimitztajtantoskej. ");
INSERT INTO nhx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús kijtoj: —Felipe, ikyay ninemi iwá̱n amejeme̱n, ¿iwá̱n áyataj tine‑i̱xmati? Yej ne‑ítaꞌya, kitaꞌ no̱ toTaj; ¿te ígataj tine‑ijliá iga manimitzne̱xtili̱ka̱n toTaj? ");
INSERT INTO nhx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ayá̱ꞌ ticre̱dowa iga nej nise̱titoꞌ wa̱n toTaj iwá̱n toTaj se̱titoꞌ wa̱n nej? Yej nimitzijliáj, ayá̱ꞌ nejsan nikte̱nchi̱wa, toTaj yej íwa̱n nise̱titoꞌ, ne̱tajto̱lmaka. Nochi yej nikchi̱wa, yéjwaꞌ in yej kichijtoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xine̱cre̱do̱ka̱n iga nej nise̱titoꞌ wa̱n toTaj, iwá̱n toTaj se̱titoꞌ wa̱n nej; siga ayá̱ꞌ anne̱cre̱dowaj, xicre̱do̱ka̱n ipan yej ankitaj nikchi̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nimitznojma‑ijliáj, yej ne̱cre̱dowa, yawi no̱ kichi̱wati yej nej nikchi̱wa; iwá̱n yawi kichi̱wati ma̱jya sej que nej nikchij, iga nej nia ka̱n onoꞌ toTaj. ");
INSERT INTO nhx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iwá̱n nochi yej ankitajtanili̱skej toTaj iga anmoconfia̱rowaj nopan, nej nimitzmakaskej, iga ipode̱r toTaj mamone̱xti ipan nej yej iPiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Nej nikchi̱was nochi te̱san amejeme̱n anne̱tajtanili̱skej iga anmoconfia̱rowaj nopan. ");
INSERT INTO nhx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesús no̱ kijtoj: —Siga amejeme̱n anne̱cho̱kiliáj, xikchi̱waka̱n ken nimitztekimakaj. ");
INSERT INTO nhx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Iwá̱n nia niktajtanili̱ti toTaj iga mamitzti̱tanili̱ka̱n seꞌ yej mamitzpale̱wi̱ka̱n, iwá̱n mamitzyo̱lchika̱waka̱n iga nochipa maono amowa̱n: ");
INSERT INTO nhx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","iní̱n iyEspí̱ritoj Dios yej ijko̱nya nokta ken tane̱xtiliá. Yej aki̱xmatij Dios awel kipiaskej iyEspí̱ritoj, iga ayá̱ꞌ kitaj iwá̱n aki̱xmatij; eꞌ amejeme̱n anki̱xmatij iga yéj onoꞌ iwá̱n amejeme̱n iwá̱n nochipa onos ipan amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ayá̱ꞌ nimitzsenkokajte̱waskej; niwi̱ꞌ sej iga nonos iwá̱n amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Alí̱n poliwi iga la gente ayꞌya má̱j ne‑itas, eꞌ amejeme̱n anne‑itaskej; iwá̱n iga nej nisatoꞌ, amejeme̱n no̱ an‑isatoskej. ");
INSERT INTO nhx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Íkua̱ꞌ amejeme̱n ankimatiskej iga nej nise̱titoꞌ wa̱n noTaj, iwá̱n nej nise̱titoꞌ iwá̱n amejeme̱n, iwá̱n amejeme̱n anse̱titokej wa̱n nej. ");
INSERT INTO nhx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yej kimati iwá̱n kichi̱wa ken nitatekimaka, ne̱si iga ne̱cho̱kiliá nokta, iwá̱n noTaj kicho̱kili̱j inó̱n yej ne̱cho̱kiliá iwá̱n nej no̱ nikcho̱kiliá, iwá̱n nimone̱xti̱j iyi̱xtaj kén nokta in nej. ");
INSERT INTO nhx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Judas (ayéj yej kito̱ka̱wiáj Iscariote) kijtoj: —NoTe̱ko, ¿te iga tia timone̱xti̱ti no‑i̱xtajmej iwá̱n ayéj iyi̱xtajmej la gente yej amitzi̱xmatij? ");
INSERT INTO nhx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesús kijtoj: —Yej ne̱cho̱kiliá, ne̱tajto̱lkaki; iwá̱n noTaj yawi kicho̱kili̱ti, iwá̱n noTaj iwá̱n nej niwi̱tzej iga nisen‑onokij wa̱n yéj. ");
INSERT INTO nhx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yej ayá̱ꞌ ne̱cho̱kiliá, ayá̱ꞌ ne̱tajto̱lkui; yej iná̱n nemi nimitzijliáj ayéj nejsan nikyoka‑ijtowa, sino que noTaj yej ne̱ti̱tan ne̱tajto̱lmaka. ");
INSERT INTO nhx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Nemi nimitzijliáj nochi iní̱n mie̱j nónogoꞌ amowa̱n; ");
INSERT INTO nhx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","eꞌ iyEspí̱ritoj Dios yej mitzyo̱lchika̱waj, yej toTaj mitzti̱tanili̱skej iga makikui notekipáno̱l, yawi mitzne̱xtili̱tij nochi, iwá̱n mitzejla̱nti̱skej inewi yej nimitzijlijkej. ");
INSERT INTO nhx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Nej niaya, eꞌ nikchi̱was iga xonoka̱n tamelá̱. Ijkó̱n iga amonoskej tamelá̱, ayéj ken onokej ino̱mej yej ayá̱ꞌ ki̱xmatij Dios. Amo ximoyo̱lmikti̱ka̱n niga ximajmawika̱n. ");
INSERT INTO nhx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Anne̱kakíkeja iga nimitzijlijkej iga niaya, iwá̱n niwi̱ꞌ sej iga nonoki iwá̱n amejeme̱n. Siga melá̱ꞌ iga anne̱nekij, ampa̱kiáj iga ankimatij iga nia ka̱n onoꞌ toTaj iga yéj ma̱jya sej que nej. ");
INSERT INTO nhx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Iní̱n áchtoya nimitzijliáj iga kua̱ꞌ mochi̱was, ximoconfia̱ro̱ka̱n pan nej. ");
INSERT INTO nhx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Ayꞌya má̱j nitajto̱j iwá̱n amejeme̱n; iga wi̱ꞌya Tzitzimiꞌ yej manda̱rowa ipan iní̱n ta̱jli. Malej iga nej ni alí̱n awel te̱ ne̱chi̱wiliá, ");
INSERT INTO nhx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ijkó̱n nokta yawi mochi̱wati, iga la gente yej ayá̱ꞌ ki̱xmatij Dios, makimatika̱n iga nikpoxneki toTaj iwá̱n nikchi̱wa ken iga yéj ne̱tekimáꞌ. Ximoketzaka̱n, matiá̱ka̱nya. ");
INSERT INTO nhx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kijtoj Jesús: —Nejwaꞌ kenkua̱ꞌ imelaꞌmekayo uva, iwá̱n noTaj kenkua̱ꞌ yej kicuida̱rowa inó̱n imekayo. ");
INSERT INTO nhx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nomajma̱ꞌ yej ayá̱ꞌ ta̱kilyowij, kimajma̱chijchi̱waj; eꞌ yej kita iga ta̱ki, kitejtekiliá imajma̱tzitzi̱n kajká̱n kineki iga má̱j mata̱ki. ");
INSERT INTO nhx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Amejeme̱n kenkua̱ꞌ imajma̱ꞌ uva yej kitejtekilíjkeja imajma̱tzitzi̱n iwá̱n anye̱ꞌonókeja iga inó̱n yej nimitzmachtijkej. ");
INSERT INTO nhx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ijkó̱n xise̱titoka̱n iwá̱n nej, ken nej nise̱titoꞌ iwá̱n amejeme̱n. Ken ima̱ꞌ uva awel ta̱ki isé̱ltisan siga ayá̱ꞌ sa̱lijtoꞌ ipan imekayo; ijko̱nsan no̱ amejeme̱n, awel ankichi̱waj nité̱ yej ye̱kti, siga ayá̱ꞌ anse̱titokej wa̱n nej. ");
INSERT INTO nhx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Nejwaꞌ in u̱vajmekaꞌ, iwá̱n amejeme̱n imajma̱ꞌ. Yej se̱titoꞌ wa̱n nej, nej nise̱titoꞌ iwá̱n yéj iwá̱n poxsan ta̱ki. Siga ayá̱ꞌ amonokej nowa̱n, awel ankichi̱waj nité̱. ");
INSERT INTO nhx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yej ayá̱ꞌ se̱titoꞌ iwá̱n nej, yawij kitajkalitij, iwá̱n wa̱kis ken tikita imajma̱ꞌ kuawiꞌ yej monejnechkowa iwá̱n kitatiáj. ");
INSERT INTO nhx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Siga amejemej anse̱titokej iwá̱n nej, iwá̱n ankichi̱waj kensan nimitzne̱xtilijkej, xiktajtanika̱n yej ankinekij iwá̱n noTaj mitzmakaskej. ");
INSERT INTO nhx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","NoTaj poxsan kiweyimati̱ltiáj kua̱ꞌ amejeme̱n ankichi̱waj yej ye̱kti, iwá̱n ijkó̱n ne̱si iga anne̱melaꞌtokaj. ");
INSERT INTO nhx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nej nimitzpoxcho̱kiliáj ken noTaj ne̱poxcho̱kiliá; nochipa xikchi̱waka̱n ken nimitzijliáj iga nimitzpoxcho̱kiliáj. ");
INSERT INTO nhx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Siga ankichi̱waj ken nimitzijlijkej, nochipa nimitzcho̱kili̱skej, ijkó̱n ken noTaj ne̱cho̱kiliá iga nikchi̱wa yej yéj ne̱tekimaka. ");
INSERT INTO nhx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Nimitzijliáj nochi iní̱n iga xipa̱ktoka̱n ken nej, ijkó̱n anmelaꞌpa̱ktoskej. ");
INSERT INTO nhx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ini̱nwaꞌ in nimitztekimakaj iga xikchi̱waka̱n: ximose̱pancho̱kili̱ka̱n ken nej nimitzcho̱kiliáj. ");
INSERT INTO nhx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ayagaj má̱j wel kine̱xti̱j iga kicho̱kiliá iyami̱gojmej sino que yejsan momaka iga mamiki iga yejemej. ");
INSERT INTO nhx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amejeme̱n anmochi̱waskej anoami̱gojmej siga ankichi̱waj yej nimitztekimakaj. ");
INSERT INTO nhx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayꞌya nimitzijli̱skej iga annosie̱rvojmej, iga siervo ayá̱ꞌ kimati yej kichi̱wa ipatró̱n. Nimitzijliáj iga anoami̱gojmej, iga nimitzne̱xtilíjkeja nochi yej noTaj ne‑ijlij. ");
INSERT INTO nhx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ayéj amejeme̱n yej anne̱tapejpenkej; sino que nej yej nimitztapejpenkej iga nimitzijliáj iga xa̱ka̱n iwá̱n xikchi̱waka̱n yej ye̱kti ken tikita se̱ u̱vajmekaꞌ yej pox ta̱ki iwá̱n ita̱kilka ayá̱ꞌ nimaní̱n pala̱nis. Ijkó̱n toTaj mitzmakaskej nochi yej ankitajtanili̱skej iga anmoconfia̱rowaj pan nej. ");
INSERT INTO nhx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iní̱n yej nimitztekimakaj iga xikchi̱waka̱n: iga ximose̱pancho̱kili̱ka̱n sewoꞌ iwá̱n seꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Siga yej ayá̱ꞌ ki̱xmatij Dios mitzijiyaj, xikmatika̱n iga nej achto ne‑ijiyakej. ");
INSERT INTO nhx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Siga amejeme̱n aya katka anki̱xmatiáj Dios, yej ayá̱ꞌ ki̱xmatij Dios mitzcho̱kilia̱yaj, ken kicho̱kiliáj yej de yejéme̱mpasan. Eꞌ nej nimitztapejpenkej ka̱n amonoyaj itza̱la̱n yej ayá̱ꞌ ki̱xmatij Dios, inó̱n iga yejemej mitzijiyaj iga ayꞌya ankichi̱waj ken yejemej. ");
INSERT INTO nhx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xikejla̱mikika̱n iní̱n yej nimitzijlijkej: “Nisé̱ tekipanowa̱ni má̱j manda̱rowa que ipatró̱n.” Siga nej ne‑ijiyakej, amejeme̱n no̱ yawij mitzijiyatij; siga ino̱mej kichijkej ken nikne̱xtilijkej, no̱ kichi̱waskej ken ankine̱xtili̱skej. ");
INSERT INTO nhx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nochi iní̱n yawij mitzchi̱wili̱tij iga anne̱tokaj, iga ayá̱ꞌ ki̱xmatij yej ne̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Siga ayá̱ꞌ niwi̱tziá iga nikpowilia̱yaj notájto̱l, ayá̱ꞌ kimatiáj siga kichijtokej yej aye̱kti, eꞌ iná̱n awel kijtowaj iga ayá̱ꞌ kichijtokej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yej nej ne‑ijiya, no̱ kijiya noTaj. ");
INSERT INTO nhx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ayá̱ꞌ ne̱siá siga kichijtokej yej aye̱kti siga nej ayá̱ꞌ nikchijka iyi̱xtajmej mila̱grojmej yej ayagaj wel kichi̱wa, eꞌ kitákeja yej nikchij; eꞌ malej ijkó̱n, ne‑ijiyaj iwá̱n no̱ kijiyaj noTaj. ");
INSERT INTO nhx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Eꞌ iní̱n mochij iga mamochi̱wa ken ijkuilijtoꞌ ipan iley yejemej: “Ne‑ijiyakej malej ayá̱ꞌ nemi nikchi̱wa yej aye̱kti.” ");
INSERT INTO nhx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Nia niktajtanili̱ti toTaj iga mamitzti̱tanili iyEspí̱ritoj. Inó̱n iyEspí̱ritoj mitzpale̱wiáj iwá̱n mitzyo̱lchika̱waj iga mitzne̱xtiliáj yej melaꞌcie̱rtoj de nej, ");
INSERT INTO nhx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","iwá̱n amejeme̱n no̱ ankipowaskej de nej, iga este kua̱ꞌ pe̱waꞌ iga nij ninemi, ansenemikej nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jesús kijlij idisci̱polojmej: —Iní̱n nimitzijliáj iga amo xikajte̱waka̱n iga ximoconfia̱ro̱ka̱n ipan nej. ");
INSERT INTO nhx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yawij mitzki̱xti̱tij ipan amotio̱pamej, iwá̱n kua̱ꞌ agaj de yejemej mitzmikti̱skej, yejemej kejla̱ntoskej iga ijkó̱n kichi̱waj, nemi kichi̱waj ken Dios kineki. ");
INSERT INTO nhx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Iní̱n kichi̱waskej iga aya ki̱xmatij toTaj niga nej. ");
INSERT INTO nhx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Nimitzijliáj iní̱n, iga kua̱ꞌ ijkó̱n mochi̱was, xikejla̱mikika̱n iga nej nimitzijlíjkeja. ’Iní̱n animitzijlijkej achto iga nonoya amowa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Eꞌ iná̱n nia iga manono iwá̱n yej ne̱ti̱tan; iwá̱n nisé̱ de amejeme̱n ayá̱ꞌ ne̱tajtani ka̱n nia. ");
INSERT INTO nhx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ma̱jwaꞌ, amokno̱matikej iga yej nimitzijlijkej. ");
INSERT INTO nhx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Eꞌ ayá̱ꞌ nimitzkajkaya̱waj: ye̱kti iga maniá, iga siga ayá̱ꞌ nia, el Espíritu Santo yej mitzyo̱lchika̱waj ayá̱ꞌ wi̱ꞌ iga maonoki amowa̱n; eꞌ siga nia, nia nimitzti̱tanili̱tij. ");
INSERT INTO nhx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kua̱ꞌ yéj wi̱ꞌ, yawi kine̱xtili̱ti la gente iga kichijtokej yej aye̱kti iwá̱n kine̱xtili̱skej iga onoꞌ se̱ ojti ka̱n ye̱ꞌnemilo iwá̱n iga Dios yawi tajuzga̱ro̱ti. ");
INSERT INTO nhx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kichijtokej yej aye̱kti iga ayá̱ꞌ moconfia̱rowaj nopan; ");
INSERT INTO nhx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","kimatiskej katiapa in ye̱ꞌojti iga nej nia ka̱n onoꞌ toTaj, iwá̱n amejeme̱n ayꞌya anne‑itaskej. ");
INSERT INTO nhx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Kimatiskej iga Dios yawi tajuzga̱ro̱ti, iga yej manda̱rowa no̱ya̱n ipan iní̱n ta̱jli ónoꞌya iga yawij kicastiga̱ro̱tij. ");
INSERT INTO nhx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ma̱joꞌ nimitzijli̱jnekij, eꞌ amejeme̱n iná̱n aya wel ankentende̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kua̱ꞌ wi̱ꞌ iyEspí̱ritoj Dios, yéj mitzmachti̱skej nochi yej melaꞌcie̱rtoj, iwá̱n ayá̱ꞌ tajto̱j kensan yéj kineki, yawi kijto̱ti inewi yejsan kikakis, iwá̱n yawi mitzmati̱lti̱tij nochi yej mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yéj yawi ne̱weyimati̱lti̱ti, iga kikuis yej nej notájto̱l, iwá̱n mitzne̱xtili̱skej amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Inewi yej kipiá toTaj, notatki no̱; inó̱n iga nikijtoj iga el Espíritu kikuis notájto̱l iwá̱n mitzne̱xtili̱skej amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Alí̱n poliwi iga ayꞌya ane‑itaskej, eꞌ pano̱j seꞌ alí̱n tiempo anyawij sej anne‑itatij iga nia ka̱n onoꞌ toTaj. ");
INSERT INTO nhx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Iwá̱n sekin idisci̱polojmej mosepantajtankej seꞌ iwá̱n seꞌ: —¿Ix te a̱n te‑ijli̱jneki iga te‑ijliá? “Alí̱n poliwi iga ayꞌya ane‑itaskej, eꞌ pano̱j seꞌ alí̱n tiempo anyawij sej anne‑itatij”, iwá̱n te iteki o̱n, “Nia ka̱n onoꞌ toTaj.” ");
INSERT INTO nhx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Te a̱n kijto̱jneki in inó̱n “alí̱n tiempo”? Ayá̱ꞌ tikmatij de te̱ nemi tajtowa. ");
INSERT INTO nhx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús kimatiꞌ iga kitajtanisnekiáj, iwá̱n kijlijkej: —Nej nimitzijlijkej iga poliwi alí̱n iga ayoꞌ anne‑itaskej iwá̱n pano̱j seꞌ alí̱n tiempo sej anne‑itaskej. ¿Ix iní̱n in yej anmotajtantokej amejeme̱n? ");
INSERT INTO nhx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nimitznojma‑ijliáj iga anyawij ancho̱katij iwá̱n anmokno̱matiskej, eꞌ yej aki̱xmatij Dios yawij pa̱kitij. Eꞌ malej iga anmokno̱matitoskej, anyawij ampa̱kitij. ");
INSERT INTO nhx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kua̱ꞌ se̱ siwa̱ꞌ yawi taonolti̱ti, pilkualo̱toꞌ, iga ásiꞌya hora; eꞌ kua̱ꞌ nacé̱roja xo̱lo̱ꞌ ke̱lká̱waya iga pilkualo̱ꞌ, iga pá̱ktoꞌya iga kítaꞌya ixo̱lo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ijkó̱n no̱ amejeme̱n amokno̱matij iná̱n; eꞌ nej nimokuepas iga nimitzitakij sej, iwá̱n anyo̱lpa̱kiskej, iwá̱n ayagaj wel mitzka̱walti̱skej iga ampa̱kij. ");
INSERT INTO nhx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Ipan inó̱n día ayꞌya ane̱tajtaniskej nité̱. Nimitznojma‑ijliáj iga toTaj yawi mitzmakatij inewi yej xiktajtanili̱ka̱n iga anmoconfia̱rowaj ipan nej. ");
INSERT INTO nhx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Este iná̱n ayá̱ꞌ nemi ankitajtanij nité̱ ipan noto̱ka̱ꞌ; xiktajtanika̱n, iwá̱n mitzmakaskej iga ximelaꞌpa̱kika̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jesús kijtoj: —Nimitzijlijkej nochi iní̱n ka̱n ximi̱xkui̱ti̱ka̱n, eꞌ yawi asiti hora iga ayꞌya nimitzmachti̱skej ka̱n ximi̱xkui̱ti̱ka̱n, iga nimitzmelaꞌta̱tapo̱wi̱skej de toTaj. ");
INSERT INTO nhx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Inó̱n día amejeme̱n ankitajtanili̱skej ipan noto̱ka̱ꞌ, iwá̱n ayá̱ꞌ nikijtowa iga nia niktajtanili̱ti toTaj iga amejeme̱n, ");
INSERT INTO nhx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","iga toTaj mitzpoxcho̱kiliáj. Mitzcho̱kiliáj iga amejeme̱n anne̱cho̱kiliáj, iwá̱n ankicre̱dojkej iga nej niwa̱laj de Dios. ");
INSERT INTO nhx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Niki̱saꞌ iyi̱xtaj toTaj iga niwa̱laj ipan iní̱n ta̱jli, eꞌ iná̱n nikajte̱wa iní̱n ta̱jli iga nia sej ka̱n onoꞌ toTaj. ");
INSERT INTO nhx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Iwá̱n idisci̱polojmej kijtojkej: —Iná̱n sí nemi anne‑ijliáj yej wel nikentende̱rowaj, ayejoꞌ ka̱n manimi̱xkui̱ti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Iná̱n nikitaj iga nochi tikmati, iwá̱n ayꞌ kineki iga agaj mamitztajtani, inó̱n iga nicre̱dowaj iga tiwa̱laj ka̱n onoꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesús kijtoj: —¿Iná̱n ankicre̱dówaja? ");
INSERT INTO nhx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Pues ásiya la hora, iwá̱n ina̱nya nokta kua̱ꞌ amejeme̱n ampa̱payi̱niskej iwá̱n nijnijiga anya̱skej, iwá̱n anne̱senkokajte̱waskej. Eꞌ ayá̱ꞌ nose̱lti nonos, toTaj onoꞌ nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nimitzijliáj iní̱n iga xonoka̱n tamelá̱ iga anse̱titókeja nowa̱n. Ipan iní̱n ta̱jli amejeme̱n yawij mitzikno̱chi̱watij; eꞌ xiksenta̱li̱ka̱n amoa̱lmaj ipan nej, nej nikta̱nílija nochi yej onoꞌ ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kua̱ꞌ tamiꞌ iní̱n kijtoj, Jesús tacháꞌ cie̱lojkóbapa iwá̱n kijtoj: —NoTaj, ásiꞌya hora. Xikweyimati̱lti moPiltzi̱n, iga nej yej moPiltzi̱n no̱ manimitzweyimati̱lti. ");
INSERT INTO nhx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Puej tej tikchij iga moPiltzi̱n makipiá poder ipan inewi gente, puej tej tikmáꞌ iga wel makijto iga nochi yej tej tikmáꞌ nochipa maonoka̱n wa̱n tej. ");
INSERT INTO nhx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Iga se̱ maono nochipa mowa̱n, kineki mamitzi̱xmati, tej yej mosé̱ltisan timelaꞌDio̱s, iwá̱n nej Jesucristo yej tej tikti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Nej nimitzweyimatí̱ltija nij ipan iní̱n ta̱jli, iwá̱n niktámija yej tine̱ti̱tan manikchi̱waki. ");
INSERT INTO nhx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","NoTaj, iná̱n xine̱maka inó̱n poder yej nikpiaya kua̱ꞌ nonoya mowa̱n kua̱ꞌ aya teyá ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Ini̱mej yej tiktapejpen ipan iní̱n ta̱jli iwá̱n tine̱máꞌ iga mane̱tokaka̱n, nikmati̱ltíjkeja a̱ꞌyéj tej. Tejpa katka motatki, iwá̱n tej tine̱máꞌ, iwá̱n kichijkej ken kijtowa motájto̱l. ");
INSERT INTO nhx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Iná̱n kimatij iga inewi yej nikpiá, tej tine̱máꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Puej nikpowilij motájto̱l yej tej tine̱máꞌ, iwá̱n yejeme̱n kiye̱ꞌkuikej. Kicre̱dójkeja iga tej nokta tine̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Nimitztajtaniliá iga yejeme̱n; ayá̱ꞌ nimitztajtaniliá iga yej ayá̱ꞌ mitzi̱xmatij, sino que iga ino̱mej yej tine̱máꞌ iga tej motatki. ");
INSERT INTO nhx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Inewi yej notatki, tej no̱ motatki, iwá̱n yej motatki, notatki no̱; ne̱weyimati̱ltiáj iga yejeme̱n moconfia̱rowaj ipan nej. ");
INSERT INTO nhx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Nej ayꞌya má̱j nonos ipan iní̱n ta̱jli; eꞌ yejemej kena, ká̱wijoꞌ ipan iní̱n ta̱jli, iwá̱n nej nia iga manono mowa̱n. NoTaj yej mitzajasi iga mamitzweyimati̱lti̱ka̱n, iga mopode̱r xiko̱mema̱wi yej tine̱máꞌ, iga maonoka̱n se̱san iya̱lmajmej kensan tej iwá̱n nej. ");
INSERT INTO nhx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kua̱ꞌ nonoya iwa̱mej ipan iní̱n ta̱jli, nicuida̱rowa̱ya iga mopode̱r ino̱mej yej tej tine̱máꞌ, iwá̱n niko̱mema̱wia̱yaj. Iwá̱n nisé̱ de yejeme̱n apoliwiꞌ, petz inó̱n yej wa̱laj iga yawi melaꞌpoliwiti, iga mamochi̱wa ken kijtowa ka̱n ijkuilijtoꞌ motájto̱l. ");
INSERT INTO nhx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Iná̱n nia ka̱n tej tonoꞌ; iwá̱n nikijtowa iní̱n mie̱j nónogoꞌ ipan ta̱jli, iga yejemej no̱ mapa̱kika̱n ken nej nipa̱ktoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nej nikpowilíjkeja motájto̱l, eꞌ yej amitzi̱xmatij kijiyaj yej mitzi̱xmatij, iga yejemej ayoꞌ kichi̱waj ken yej ayá̱ꞌ mitzcre̱dowaj, kensan nej no̱ ayá̱ꞌ nikchi̱wa ken yej ayá̱ꞌ mitzcre̱dowaj. ");
INSERT INTO nhx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ayá̱ꞌ nimitztajtaniliá iga xiki̱xti ipan iní̱n ta̱jli, sino que xikma̱nawi̱ka̱n iga Tzitzimiꞌ amo makina̱ꞌtecho yejemej. ");
INSERT INTO nhx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ijkó̱n ken nej ayá̱ꞌ nikchi̱wa ken yej amitzcre̱dowaj, yejeme̱n no̱ ayá̱ꞌ kichi̱waj ken yej amitzcre̱dowaj. ");
INSERT INTO nhx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Motájto̱l melaꞌcie̱rtoj; xikchi̱wa iga kua̱ꞌ kikakij, makisenta̱li̱ka̱n iya̱lmajmej iga makichi̱waka̱n ken tej tikneki. ");
INSERT INTO nhx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ken nej tine̱ti̱tan ka̱n onokej yej ayá̱ꞌ mitzi̱xmatij, ijkó̱n no̱ nikti̱tanij yejeme̱n ka̱n onokej yej ayá̱ꞌ mitzi̱xmatij. ");
INSERT INTO nhx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Niksenta̱liá noa̱lmaj iga manikchi̱wa ken tej tikneki. Nikchi̱wa iga yejeme̱n, iga yejemej no̱ makisenta̱li̱ka̱n iya̱lmajmej iga makichi̱waka̱n ken kijtowa motájto̱l yej melaꞌcie̱rtoj. ");
INSERT INTO nhx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ayá̱ꞌ nimitztajtaniliá iga yejémejsan, no̱ iga yej ne̱cre̱dó̱skejoꞌ kua̱ꞌ kikakiskej motájto̱l yej kipowaskej. ");
INSERT INTO nhx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Nimitztajtaniliá iga yejemej maonoka̱n se̱san iya̱lmajmej kensan tej tinoTaj, tise̱titokej. Iwá̱n makipiaka̱n se̱san iya̱lmajmej ipan tejemej, iga yej aya mitzi̱xmatij makicre̱do̱ka̱n iga tej tine̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nikmakakej ino̱nsan poder yej tej tine̱máꞌ, iga maonoka̱n ken se̱san, ijkó̱n ken tej iwá̱n nej tise̱titokej. ");
INSERT INTO nhx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nej nonoꞌ ipan yejeme̱n, iwá̱n tej tonoꞌ ipan nej, iga yejemej mamelaꞌse̱tiaka̱n, iwá̱n ijkó̱n yej ayá̱ꞌ mitzi̱xmatij, makimatika̱n iga tej tine̱ti̱tan, iwá̱n tikpoxcho̱kiliáj yejemej kensan nej tine̱cho̱kiliá. ");
INSERT INTO nhx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’NoTaj, ini̱mej yej ne̱tokaj, tej tine̱máꞌ, nikneki maonoka̱n ka̱n nej nonos, iga makitaka̱n inó̱n weyipode̱r yej tine̱máꞌ; iga tine̱cho̱kilij desde kua̱ꞌ aya mochi̱wa iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","NoTaj, yej nochipa tikchi̱wa yej ye̱kti, yej amitzcre̱dowaj, ayá̱ꞌ mitzi̱xmatij; eꞌ nej nimitzi̱xmati, iwá̱n ini̱mej yej ne̱tokaj kimatij iga tej tine̱ti̱tan. ");
INSERT INTO nhx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nikne̱xtilíjkeja a̱ꞌyéj tej, iwá̱n ijkó̱n nia nikchijtoti, iga ken tej tine̱cho̱kiliá, ijko̱nsan no̱ yejeme̱n makicho̱kili̱ka̱n sekin iwá̱n mase̱titoka̱n wa̱n nej. ");
INSERT INTO nhx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Kua̱ꞌ tamiꞌ iní̱n kijtoj, Jesús ki̱saꞌ iwá̱n idisci̱polojmej iga yajkij iyi̱ka̱mpa a̱tzi̱n yej ito̱ka̱ꞌ Cedrón. Ompa onoya se̱ huerto ka̱n Jesús kalaꞌ iwá̱n idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Iwá̱n Judas yej yawi kine̱xti̱ti Jesús iga makiki̱tzki̱ka̱n, no̱ ki̱xmatiá inó̱n huerto iga miaꞌ ve̱j Jesús ompa monechkoj iwá̱n idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Iwá̱n Judas asiko iwá̱n komati solda̱dojmej iwá̱n sekin policiyajmej yej tacuida̱rowaj weyitio̱pan yej kiti̱tankej ije̱fejmej sacerdo̱tejmej iwá̱n fariseojmej, kinentia̱yaj iyespa̱dajmej, iwá̱n mecho̱mej iwá̱n candi̱lmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Eꞌ Jesús kimatiaya te̱ yawij kichi̱wili̱tij, iwá̱n tatajtan: —¿A̱ꞌyéj ankite̱mowaj? ");
INSERT INTO nhx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yejeme̱n kijtojkej: —Jesús de Nazaret. Jesús kijtoj: —Nejya nokta. Judas yej nemi kine̱xtiá Jesús iga makiki̱tzki̱ka̱n, ompa no̱ onoya iwá̱n yejemej. ");
INSERT INTO nhx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kua̱ꞌ Jesús kijtoj: “Nejya nokta”, tzi̱ncholojkej iwá̱n wejwetzikej este ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús sej tatajtan: —¿A̱ꞌyéj ankite̱mowaj? Yejeme̱n kijtojkej: —Jesús de Nazaret. ");
INSERT INTO nhx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús kijtoj: —Nimitzijlíjkeja iga nej nokta. Siga nej anne̱te̱mowaj xikajte̱wáka̱nya ini̱mej iga maya̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iní̱n mochij iga mamochi̱wa yej Jesús kijlij iTaj: “Yej tine̱máꞌ, nisé̱ ayá̱ꞌ nikpoloj.” ");
INSERT INTO nhx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Iwá̱n Simón Pedro kipiaya se̱ espada, kiki̱xtij, iwá̱n kitekilij inakas yej ilá̱dojpa iye̱ꞌma̱ꞌ se̱ yej ito̱ka̱ꞌ Malco, yej itekipanowa̱ni ije̱fej sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Eꞌ Jesús kijlij Pedro: —Xikaki sej moespa̱daj pan ikajlo̱ꞌ. Siga toTaj kinekis iga mane‑ikno̱chi̱waka̱n, ¿ix aya̱ꞌtaj mane‑ikno̱chi̱waka̱n? ");
INSERT INTO nhx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Iwá̱n solda̱dojmej iwá̱n icomanda̱ntejmej iwá̱n judiyojmej ipoliciyajmej, kiki̱tzkijkej Jesús iwá̱n kilpijkej. ");
INSERT INTO nhx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kiwi̱gakej icha̱n Anás yej imontaj Caifás, yej inó̱n año onoya iga ije̱fej sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Iní̱n Caifás ino̱nsan yej kijlij judiyojmej iga má̱j ye̱kti mamiki se̱san ta̱gaꞌ iga inochi gente. ");
INSERT INTO nhx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro iwá̱n seꞌ discípulo kitokatia̱yaj Jesús. Inó̱n seꞌ discípulo ki̱xmatiá ije̱fej sacerdo̱tejmej, inó̱n iga kalaꞌ iwá̱n Jesús ipan ipa̱tioj ije̱fej sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Eꞌ Pedro ka̱wiꞌ kalte̱noj. Inó̱n iga inó̱n sewoꞌ discípulo yej ki̱xmati ije̱fej sacerdo̱tejmej ki̱saꞌ iwá̱n tajtoj iwá̱n takotzi̱n yej tacuida̱rojtoya pan kalte̱n, iwá̱n ijkó̱n iga wel kalaꞌ Pedro. ");
INSERT INTO nhx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Takotzi̱n kitajtan Pedro: —¿Ayéj tej se̱ idiscí̱poloj Jesús? Pedro kijtoj: —Ayéj, ayéj nej. ");
INSERT INTO nhx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Puej sektaj katka, tekipanowa̱nimej iwá̱n policiyajmej yej tacuida̱rowaj weyitio̱pan, tita̱lkej, iwá̱n ompa moskojtoyaj. Pedro no̱ ompa ejkatoya iwa̱mej iga moskojtoya. ");
INSERT INTO nhx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ije̱fej sacerdo̱tejmej pe̱waꞌ kitajtani Jesús iga de te̱ tamachtia̱ya iwá̱n aja̱ꞌyéj idisci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús kijtoj: —Nej nitajtoj iyi̱xtaj nochi gente; nochipa nitamachtij tio̱pamej iwá̱n ipan weyitio̱pan yej onoꞌ Jerusalén ka̱n monechkowaj nochi judiyojmej, iwá̱n até̱ nikichtaka‑ijtoj. ");
INSERT INTO nhx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Te iga nej tine̱tajtani? Xiktajtani yej ne̱kakikej, iwá̱n yejeme̱n makijto̱ka̱n te̱ nikijtoj. Yejeme̱n kimatij te̱ nikijtoj. ");
INSERT INTO nhx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kua̱ꞌ Jesús kijtoj iní̱n, se̱ policía yej kicuida̱rowa weyitio̱pan, yej ompa onoya, kixa̱ygatatzi̱n, iwá̱n kijlij: —¿Ijkó̱n tikte̱nkuepiliá ije̱fej sacerdo̱tejmej? ");
INSERT INTO nhx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesús kijtoj: —Siga ayompa nitajtoj, xikijto te̱ nikijtoj yej aye̱kti; eꞌ siga ompay ken nikijtoj, ¿te iga nemi tine̱maga? ");
INSERT INTO nhx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Iwá̱n Anás kiti̱tan Jesús, ilpitiajki ka̱n manda̱rowa Caifás, yej ijé̱fejpa sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mie̱j Pedro ómpasan ejkatoya iga moskojtoya tite̱noj, kitajtankej: —¿In tej ayéj se̱ idiscí̱poloj Jesús? Pedro kijtoj iga ayá̱ꞌ ki̱xmati Jesús, kijtoj: —Ayá̱ꞌ, ayéj nej. ");
INSERT INTO nhx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Iwá̱n kitajtan itekipanowa̱ni ijé̱fejpa sacerdo̱tejmej iparie̱ntej inó̱n ta̱gaꞌ yej kinagastajkolojka Pedro: —¿Ix animitzitaꞌ iga íwa̱n tonoya ipan huerto? ");
INSERT INTO nhx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedro kijtoj sej iga aki̱xmati, iwá̱n íkua̱ꞌya takui̱gaꞌ ka̱yo. ");
INSERT INTO nhx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iwá̱n kiki̱xtijkej Jesús icha̱n Caifás iga kiwi̱gakej ipan palacio ka̱n onoꞌ gobernador yej ito̱ka̱ꞌ Pilato. Íkua̱ꞌ tane̱stiwi̱tziayay, judiyojmej ayá̱ꞌ kalakikej ipan palacio igakiꞌ wel kimopaj iga ompa onokej yej ayéj judiyojmej, iwá̱n ijkó̱n awel cena̱rowa̱yaj pan iyilwi la Pascua. ");
INSERT INTO nhx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Inó̱n iga Pilato ki̱saꞌ iga tajtoj iwa̱mej; iwá̱n kijtoj: —¿In iní̱n ta̱gaꞌ te̱ kichij yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yejemej kijtojkej: —Siga iní̱n katka ayá̱ꞌ kichij yej aye̱kti, ayá̱ꞌ katka nimitzwajliguilia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilato kijtoj: —Xikui̱gaka̱n amejeme̱n iwá̱n xikchi̱wili̱ka̱n ijkó̱n ken tatekimaka amoleymej. Judiyojmej kijtojkej: —Eꞌ nejemej nijudiyojmej ne̱manda̱rówajsan no̱ iwá̱n awel nitatekimakaj iga agaj mamiki. ");
INSERT INTO nhx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ijkó̱n mochij yej Jesús kijtoj iga ken iga yawi mikiti. ");
INSERT INTO nhx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilato sej kalaꞌ ipan palacio, kino̱tzaꞌ Jesús iwá̱n kitajtan: —¿Ix tejya in irre̱y judiyojmej? ");
INSERT INTO nhx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesús kijtoj: —¿Ix pan tejsan ijkó̱n tine̱tajtani o agaj mitzta̱tapo̱wij de nej? ");
INSERT INTO nhx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilato kijtoj: —Tikmati iga ayéj nijudiyoj. Yej mogé̱ntejpa iwá̱n ije̱fejmej sacerdo̱tejmej mitzka̱wakoj nij no‑i̱xtaj. ¿Te̱taj tikchij yej aye̱kti? ");
INSERT INTO nhx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iwá̱n Jesús kijtoj: —Ka̱n nirreina̱rowa ayéj ipan iní̱n ta̱jli. Siga ijkó̱n katka, yej ne̱tokaj wel ne̱ma̱nawia̱yaj iga amo mane̱ki̱tzki̱ka̱n judiyojmej. Eꞌ norre̱inoj ayá̱ꞌ onoꞌ nigaj. ");
INSERT INTO nhx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Iwá̱n Pilato kijtoj: —¿In tejtaj se̱ rey? Jesús kijtoj: —Nej nirre̱y, ken tej tikijtowa. Nej inó̱n iga ninace̱roj iwá̱n niwa̱laj ipan iní̱n ta̱jli iga nikijto̱ko yej melá̱ꞌ nokta. Nochi yej ki̱xmatij iwá̱n kijtowaj yej melaꞌcie̱rtoj, ne̱tajto̱lkakij. ");
INSERT INTO nhx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilato kijtoj: —¿Te̱ iteki in yej melaꞌcie̱rtoj? Kua̱ꞌ tamiꞌ kitajtajtan, Pilato sej ki̱saꞌ iga tajto̱to iwá̱n judiyojmej, iwá̱n kijtoj: —Nej ayá̱ꞌ nikasiliá siga iní̱n ta̱gaꞌ kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Eꞌ amejeme̱n nochipa ankitekimajkawaj se̱ preso kua̱ꞌ iyilwiyo la Pascua, ¿iná̱n, ix ankinekij manikmajka̱wa irre̱y judiyojmej? ");
INSERT INTO nhx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iwá̱n sej nochi tzajtzikej: —¡Inó̱n amo xikmajka̱wa! ¡Xikmajka̱wa Barrabás! Eꞌ Barrabás se̱ yej tachteki. ");
INSERT INTO nhx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Iwá̱n Pilato tatekimáꞌ iga makimagaka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Solda̱dojmej kita̱lilijkej ipan itzontekon Jesús se̱ corona de witzti yej kiyawalchijkej iwá̱n kaki̱ltijkej se̱ tzótzol yej este ken tata̱ꞌcha̱potiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Iwá̱n kina̱ꞌtechojkej iga kijli̱toj: —¡Nimitzweyimati̱ltiáj tej iRre̱y judiyojmej! Iwá̱n kixa̱ygatatzi̱nkej. ");
INSERT INTO nhx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato ki̱saꞌ sej, iwá̱n kijtoj: —Taꞌ xikitaka̱n, niki̱xtij iga xikmatika̱n iga ayá̱ꞌ nikasiliá siga kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Iwá̱n ki̱saꞌ Jesús iwá̱n icoro̱naj yej chijtoꞌ iga witzti ipan itzontekon iwá̱n kakijtia̱ya tzótzol yej chi̱ltiꞌ yej este a̱cha̱potiꞌ. Pilato kijtoj: —¡Nija onoꞌ in iní̱n ta̱gaꞌ! ");
INSERT INTO nhx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Kua̱ꞌ kitakej ije̱fejmej sacerdo̱tejmej iwá̱n policiyajmej, pe̱wakej iga tzajtzikej: —¡Xikmikti ipan cruz! ¡Xikmikti ipan cruz! Pilato kijtoj: —Puej xikui̱gáka̱nya iwá̱n xikmikti̱ka̱n ipan cruz amejeme̱n, nej ayá̱ꞌ nikasiliá siga kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Eꞌ judiyojmej kijtojkej: —Nejeme̱n nikpiáj se̱ ley, inó̱n ley kijtowa iga yawi mikiti, iga igá̱najsan mojlia̱ya iga yéj iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kua̱ꞌ iní̱n kikáꞌ Pilato, ma̱jya majmawiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Kalaꞌ sej al palacio iwá̱n kitajtan Jesús: —¿Ká̱ntaj in tej mocha̱n? Eꞌ Jesús até̱ kijtoj. ");
INSERT INTO nhx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Iwá̱n Pilato kijtoj: —¿Iwá̱n aya̱ꞌtaj tine̱no̱tza? ¿Ix ayá̱ꞌ tikmati iga nej wel nitatekimaka iga mamitzmikti̱ka̱n ipan cruz iwá̱n wel no̱ nimitzmajka̱wa? ");
INSERT INTO nhx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesús kijtoj: —Awel tikchi̱wa nité̱ ipan nej siga Dios ayá̱ꞌ kineki; inó̱n iga yej nij ne̱ka̱wakoj mo‑i̱xtaj, má̱j kichijkej yej aye̱kti que tej. ");
INSERT INTO nhx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Desde íkua̱ꞌ Pilato kite̱mowa̱ya ken iga makimajka̱wa Jesús; eꞌ judiyojmej tzajtzikej: —¡Siga tikmajka̱wa, tej ayéj iyami̱goj el rey César! ¡Nochi yej mochi̱wa rey, mochi̱wasneki iyenemi̱goj el rey César! ");
INSERT INTO nhx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kua̱ꞌ Pilato iní̱n kikáꞌ, tatekimáꞌ iga makiki̱xti̱ka̱n Jesús, iwá̱n Pilato mota̱lij ipan iweyi‑asie̱ntoj ka̱n manda̱rowa, ompa ka̱n ipan hebreo ito̱ka̱ꞌ Gabata, yej kijto̱jneki piso de teꞌti. ");
INSERT INTO nhx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Inó̱n mochij kua̱ꞌ kipolowa̱ya se̱ día iga mochi̱wa iyilwi la Pascua, ken tajkodía. Iwá̱n Pilato kijlij judiyojmej: —¡Nigaj onoꞌ amorre̱y! ");
INSERT INTO nhx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Eꞌ yejeme̱n tzajtzikej: —¡Mamiki! ¡Mamiki! ¡Xiclavá̱ropa ipan cruz! Pilato tatajtan: —¿Ix nikmiktiá ipan cruz amorre̱y? Eꞌ ije̱fej sacerdo̱tejmej kijtoj: —Nejeme̱n ayá̱ꞌ nikpiáj seꞌ rey, petz isé̱ltisan rey César. ");
INSERT INTO nhx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Iwá̱n pilato kentrega̱roj Jesús iga makimikti̱ka̱n ipan cruz, iwá̱n yejemej kiwi̱gakej. ");
INSERT INTO nhx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iwá̱n Jesús ki̱saꞌ, kiwi̱gaya icru̱z iga yajki ka̱n ito̱ka̱ꞌ Kuaomiꞌ, ipan hebreo kijliáj Gólgota. ");
INSERT INTO nhx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ompa kiclava̱rojkej Jesús ipan cruz. No̱ kiclava̱rojkej ite̱noj o̱me tajta̱gaꞌ ipan sejsé̱ icru̱z, se̱ de cada lado, Jesús onoya tatajkoya̱n. ");
INSERT INTO nhx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato tati̱tan iga makita̱lili̱tij se̱ tajkuílo̱l ipan icru̱z, yej kijtowa̱ya: “JESÚS DE NAZARET, IRRE̱Y JUDIYOJMEJ.” ");
INSERT INTO nhx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ka̱n kiclava̱rojkej Jesús ipan cruz, na̱ꞌsan weyi‑a̱ltepe̱ꞌ Jerusalén, inó̱n iga miaꞌ judiyojmej kitajto̱ltijkej inó̱n tajkuílo̱l yej ijkuilijtoya ipan hebreo, ipan griego iwá̱n ipan latín. ");
INSERT INTO nhx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Inó̱n iga ije̱fejmej sacerdo̱tejmej kijlijkej Pilato: —Amo xikijkuilo “iRre̱y judiyojmej”; má̱j ye̱kti xikijkuilo “Iní̱n mojliá iga iRre̱y judiyojmej.” ");
INSERT INTO nhx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Eꞌ Pilato kijtoj: —Yej nikijkuíloja, ijko̱nya maka̱wi. ");
INSERT INTO nhx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Kua̱ꞌ kiclava̱rójkeja Jesús ipan cruz, na̱wi solda̱dojmej morreparti̱rowilijkej itzotzolmej Jesús. Ijkó̱n no̱ kichi̱wayaj wa̱n isota̱ntzótzol, eꞌ como inó̱n tzótzol ayá̱ꞌ sa̱sa̱lijtoya, se̱san iga ijkititoya desde ajko wa̱n este tani, ");
INSERT INTO nhx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","solda̱dojmej mosepan‑ijlijkej: —Amo matiktza̱tzaya̱naka̱n; matik‑rifa̱ro̱ka̱n iga matikitaka̱n a̱ꞌyéj kikuis. Ijkó̱n mochij ken ijkuilijtoꞌ itájto̱l Dios ka̱n kijtowa: “Mota̱tajkolowilijkej notzótzol iwá̱n kirrifa̱rojkej nosota̱ntzótzol.” Ijkó̱n kichijkej solda̱dojmej. ");
INSERT INTO nhx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Iye̱ꞌ Jesús iwá̱n isiwa‑ikni̱n iye̱ꞌ onoyaj ite̱noj cruz ka̱n Jesús onoya, no̱ onoyaj María yej isiwa̱ꞌ Cleofas iwá̱n María Magdalena. ");
INSERT INTO nhx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kua̱ꞌ Jesús kitaꞌ iye̱ꞌ iwá̱n iná̱ꞌ onoꞌ idiscí̱poloj yej má̱j kicho̱kilia̱ya, kijlij iye̱ꞌ: —Nomáj, ine̱pa xikita ken mopiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Iwá̱n kijlij inó̱n idiscí̱poloj: —Xikneki noye̱ꞌ ken moye̱ꞌ. Iwá̱n desde íkua̱ꞌ, ícha̱n inó̱n discípulo ki‑o̱mema̱wij María. ");
INSERT INTO nhx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kua̱ꞌ nochi panoj iní̱n, Jesús kimatiꞌ iga nóchiya mochij, iwá̱n iga mamochi̱wa ken ijkuilijtoꞌ, kijtoj: —Na̱taneki. ");
INSERT INTO nhx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ompa onoya se̱ jarro yej te̱ntoya iga xoko̱ꞌvi̱noj, iwá̱n ka̱pachojkej tejté̱ yej ken ichkaꞌ ipan xoko̱ꞌvi̱noj, iwá̱n kilpijkej ipan se̱ ima̱ꞌ kuawiꞌ yej ito̱ka̱ꞌ hisopo iwá̱n kite̱nwi̱ltijkej iga makichichi̱na. ");
INSERT INTO nhx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Kua̱ꞌ Jesús konij xoko̱ꞌvi̱noj, kijtoj: —Móchija nochi. Iwá̱n motzompiloj, íkua̱ꞌya miguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kipolowa̱ya se̱ día iga mochi̱wa iyilwi la Pascua, iwá̱n judiyojmej ayá̱ꞌ kinekiáj iga a̱nimajmej maka̱wika̱n ipan icru̱zmej ipan día sábado, iga inó̱n día kipoxweyimatiáj. Inó̱n iga kijlijkej Pilato iga matatekimaka iga makipojpostekili̱ka̱n iyikximej yej onokej ipan icru̱zmej iga má̱j nimaní̱n mamikika̱n iwá̱n makitemowí̱ka̱nya. ");
INSERT INTO nhx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Iwá̱n solda̱dojmej yajkij, iwá̱n kipo̱postekilijkej iyikximej yej achto ta̱gaꞌ, iwá̱n seꞌ ta̱gaꞌ yej onoya no̱ ipan icru̱z iná̱ꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Eꞌ kua̱ꞌ kina̱ꞌtechojkej Jesús, kitakej iga míktoꞌya, inó̱n iga ayá̱ꞌ kijikxipostekikej. ");
INSERT INTO nhx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Eꞌ se̱ soldado kisoloj ise̱kate̱noj iga ila̱nzaj, iwá̱n ki̱saꞌ esti iwá̱n a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Iní̱n kipowa yej kitaꞌ, iwá̱n ijko̱nya ken kijtowa, yéj kimati iga ijko̱nya nokta yej kijtowa iga amejeme̱n no̱ xicre̱do̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Iní̱n mochij iga mamochi̱wa ken ijkuilijtoꞌ: “Ayá̱ꞌ kipo̱postekilijkej nisé̱ iyomiyo.” ");
INSERT INTO nhx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Iwá̱n seꞌ ka̱n ijkuilijtoꞌ itájto̱l Dios kijtowa: “Kitaskej yej kisolojkej.” ");
INSERT INTO nhx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kua̱ꞌ nochi iní̱n mochij, José yej icha̱n a̱ltepe̱ꞌ Arimatea, kitajtanilij Pilato iga wel makiwi̱ga icue̱rpoj Jesús iga makito̱ka. José no̱ kitokaya Jesús, malej iga ichtákasan iga kimajmawilia̱ya judiyojmej. Pilato kijlij iga wel kiwi̱gaꞌ icue̱rpoj Jesús, iwá̱n José yajki kikuito. ");
INSERT INTO nhx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Asiꞌ no̱ Nicodemo yej se̱ yówal yajka tajto̱to̱ya iwá̱n Jesús, kiwajli̱ꞌ ken treinta kilos yej ajwiya̱ꞌ, nelijtoꞌ iga mirra iwá̱n áloes. ");
INSERT INTO nhx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ijkó̱n iga José iwá̱n Nicodemo kikuikej icue̱rpoj Jesús, iwá̱n kiki̱kimilojkej iga venda yej kakalijtoꞌ iga yej ajwiya̱ꞌ, ken iga kitekichi̱wayaj judiyojmej iga kito̱kaj a̱nimajmej. ");
INSERT INTO nhx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ompa ka̱n kimiktijkej Jesús ipan cruz onoya se̱ huerto, iwá̱n ipan huerto onoya se̱ a̱nimajtexapoꞌ yej kichíjkejoꞌ, ka̱n aya agaj kito̱kaj. ");
INSERT INTO nhx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ompa kakijkej icue̱rpoj Jesús, iga inó̱n a̱nimajtexapoꞌ na̱ꞌsan onoya, iwá̱n pe̱wasnekiáy inó̱n día kua̱ꞌ mose̱wiáj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ipan domingo, María Magdalena yajki isájpasan posa̱ntoj, kua̱ꞌ takó̱mi‑oꞌ; iwá̱n kitaꞌ iga ayꞌya teyá weyiteꞌti yej kite̱ntzaktoya a̱nimajtexapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Iwá̱n motalojtiajki ka̱n onoꞌ Simón Pedro iwá̱n seꞌ discípulo, inó̱n yej Jesús kipoxcho̱kilia̱ya, iwá̱n kijlijkej: —¡Kichté̱kkeja toTe̱ko ompa ka̱n onoya ipan a̱nimajtexapoꞌ, iwá̱n iná̱n atikmatij ka̱n kiwi̱gakej! ");
INSERT INTO nhx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pedro iwá̱n sewoꞌ discípulo yajkij ka̱n onoꞌ a̱nimajtexapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Iyo̱mextimej mosentalojtiajkij; eꞌ sewoꞌ motaloj má̱j nimaní̱n que Pedro iwá̱n má̱j achto asiꞌ ka̱n onoꞌ a̱nimajtexapoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Iwá̱n moto̱loj iga kitachi̱lij, iwá̱n kitaꞌ iga ompa onoꞌ tzotzolmej yej iga ki̱kimilijtoya Jesús, eꞌ inó̱n discípulo ayá̱ꞌ kalaꞌ este ta‑ijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Iwá̱n Simón Pedro asiꞌ no̱ iwá̱n kalaꞌ ipan a̱nimajtexapoꞌ. Yéj no̱ kitaꞌ iga ompa onoꞌ tzotzolmej, ");
INSERT INTO nhx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","iwá̱n tzótzol yej iga kikua̱kimilojkej Jesús, ayꞌya onoya seka̱n iwá̱n seꞌ tzotzolmej, iyokay kimilijtoya. ");
INSERT INTO nhx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Iwá̱n kalaꞌ ipan a̱nimajtexapoꞌ seꞌ discípulo yej achto asiꞌ iwá̱n kitaꞌ no̱ yej mochij iwá̱n kicre̱doj. ");
INSERT INTO nhx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Puej aya kentende̱rowa̱yaj yej kitojwa itájto̱l Dios iga Jesús ojpa‑isas ka̱n miktos. ");
INSERT INTO nhx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Iwá̱n ino̱mej disci̱polojmej yajkij sej icha̱mej. ");
INSERT INTO nhx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Eꞌ María cho̱katika̱wiꞌ fuera ite̱noj a̱nimajtexapoꞌ iwá̱n moto̱loj iga tacháꞌ xapo‑ijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Iwá̱n kitaꞌ o̱me̱n a̱ngelejmej yej este ijichkatiꞌ itzotzolmej, eje̱watokej ka̱n kita̱lkaj icue̱rpoj Jesús; se̱ e̱watoꞌ ka̱n katka ikua̱pan iwá̱n seꞌ iyikxitan. ");
INSERT INTO nhx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","A̱ngelejmej tatajtankej: —In tej, ¿te iga ticho̱katoꞌ? Yéj kijtoj: —Iga kiwi̱gakej noTe̱ko, iwá̱n anikmati ka̱n kika̱watoj. ");
INSERT INTO nhx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tamiꞌ kijtoj iní̱n, kua̱ꞌ tacháꞌ itepotztajpa, ompa kitaꞌ Jesús, eꞌ ayá̱ꞌ kimatiá siga Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús kitajtan: —In tej, ¿te iga ticho̱katoꞌ? ¿A̱ꞌyéj tikte̱mowa? Yéj kijtoj anka yej kicuida̱rowa̱ya huerto, iwá̱n kijlij: —Nokój, siga tej tikui̱gaꞌ a̱nimaj, xine‑ijli ka̱n tika̱wato iga maniá manikuiti. ");
INSERT INTO nhx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iwá̱n Jesús kijlij: —¡María! Yéj mokuepaꞌ iwá̱n kijlij ipan hebreo: —¡Raboni! —yej kijto̱jneki Tamachtia̱ni. ");
INSERT INTO nhx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús kijtoj: —Xine̱majka̱wa iga aya nitejkawi ka̱n onoꞌ noTaj. Eꞌ xaj iwá̱n xikijli nokni̱wa̱n iga nia ka̱n onoꞌ noTaj iwá̱n amoTaj no̱ amejeme̱n, noDio̱s iwá̱n amejeme̱n no̱ amoDio̱s. ");
INSERT INTO nhx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Iwá̱n María Magdalena yajki kimati̱lti̱to disci̱polojmej iwá̱n kijtoj: —Nikitaꞌ toTe̱ko. Iwá̱n kijlijkej nochi yej toTe̱ko kijtoj. ");
INSERT INTO nhx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ino̱nsan domingo, kua̱ꞌ tayoway, disci̱polojmej nechkatoyaj iwá̱n kaltzaktoyaj iga kimajmawilia̱yaj judiyojmej. Jesús kalaꞌ iwá̱n moketzaꞌ itajkoya̱n disci̱polojmej, iwá̱n kijtoj ijkí̱n: —¡Tamelá̱ xonoka̱n! ");
INSERT INTO nhx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tamiꞌ kijtoj iní̱n, kine̱xtilijkej ka̱n kisolojkej, ipan ima̱mej iwá̱n ise̱kate̱noj. Iwá̱n yejeme̱n pa̱kikej kua̱ꞌ kitakej toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Iwá̱n Jesús kijtoj sej: —Tamelá̱ xonoka̱n. Ijkó̱n ken toTaj ne̱ti̱tan, nej no̱ nimitzti̱tanij amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Iwá̱n Jesús kipi̱tzaꞌ yejeme̱n, iwá̱n kijtoj: —Manimitzmakáka̱nya iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yej amejeme̱n ankiperdona̱rowili̱skej agaj yej kichij yej aye̱kti, Dios no̱ kiperdona̱ro̱j; yej ayá̱ꞌ ankiperdona̱rowili̱skej, inó̱n Dios no̱ ayá̱ꞌ kiperdona̱ro̱j. ");
INSERT INTO nhx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Eꞌ Tomás se̱ de ino̱mej doce idiscí̱poloj, yej kijlia̱yaj Kua̱tej, ayá̱ꞌ ompa onoya kua̱ꞌ asiꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Iwá̱n sekin disci̱polojmej kijlijkej: —Nikitákeja toTe̱ko. Eꞌ Tomás kijtoj: —Siga ayá̱ꞌ nikitaliá ima̱mej ka̱n panoj cla̱vojmej, iwá̱n ayá̱ꞌ nikakiá nomájpil ka̱n kisoloj cla̱vojmej, iwá̱n siga anikakiá noma̱ꞌ ka̱n kisolojkej ise̱katan, ayá̱ꞌ nicre̱dowa. ");
INSERT INTO nhx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kua̱ꞌ panoj ocho días, disci̱polojmej sej nechkatoyaj kalijtiꞌ, iwá̱n íkua̱ꞌ Tomás ompa no̱ onoya. Malej iga tzajtzaktoya kalte̱n, eꞌ Jesús kalaꞌ, moketzaꞌ tajkoya̱n ka̱n onokej yejeme̱n iwá̱n ijkí̱n kijtoj: —Tamelá̱ xonoka̱n. ");
INSERT INTO nhx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Iwá̱n kijlij Tomás: —Xikaki nigaj momájpil, iwá̱n xikita noma̱mej; iwá̱n xikuajliga moma̱ꞌ iwá̱n xikaki nose̱katan. Amo xiyo̱ltakuaktiꞌ, sino que xicre̱do ipan nej. ");
INSERT INTO nhx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Iwá̱n Tomás kijtoj: —¡TinoTe̱ko iwá̱n tinoDio̱s! ");
INSERT INTO nhx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús kijtoj: —Tomás, iná̱n ticre̱dowa iga tine‑itaꞌ. ¡Pa̱kij yej ne̱cre̱dowaj malej iga ayá̱ꞌ ne‑itaj! ");
INSERT INTO nhx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesús kíchijoꞌ miaꞌ milagro iyi̱xtaj idisci̱polojmej, eꞌ ayá̱ꞌ ijkuilijtoꞌ ipan iní̱n a̱maꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Eꞌ iní̱n mo‑ijkuiloj iga xicre̱do̱ka̱n iga Jesús in Cristo, iPiltzi̱n Dios, iga ankicre̱dowaj ipan yéj, wel nochipa xonoka̱n wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kua̱ꞌ tamiꞌ iní̱n, Jesús ki̱xne̱xtilij sej idisci̱polojmej ipan lagu̱najte̱n. Inó̱n laguna ito̱ka̱ꞌ Tiberias. Ijkí̱n kichij: ");
INSERT INTO nhx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Seka̱n onoyaj Simón Pedro, Tomás yej kijlia̱yaj Kua̱tej, Natanael yej de Caná del estado de Galilea, ipilowa̱n Zebedeo iwá̱n sewoꞌ má̱j o̱me̱n disci̱polojmej. ");
INSERT INTO nhx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simón Pedro kijtoj: —Nia nito̱pojma̱ti. Yejemej kijtojkej: —Nejemej no̱ niawij mowa̱n. Tejkajkej ipan se̱ á̱ka̱l, iwá̱n yajkij; eꞌ inó̱n yówal ayá̱ꞌ kiki̱tzkijkej nisé̱. ");
INSERT INTO nhx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kua̱ꞌ tane̱stiwi̱tziayay, Jesús ne̱siko ipan a̱te̱n, eꞌ idisci̱polojmej ayá̱ꞌ kimatiáj siga yéj. ");
INSERT INTO nhx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Iwá̱n Jesús kijtoj: —Nokni̱wa̱n, ¿ix acha̱ ankiki̱tzkijkej to̱poj? Yejeme̱n kijtojkej: —Ni se̱. ");
INSERT INTO nhx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Iwá̱n Jesús kijtoj: —Xikmo̱taka̱n amorre̱dej ila̱doj moye̱ꞌka̱mpa amoá̱ka̱l iwá̱n ankiki̱tzki̱skej. Ijkó̱n kichijkej, iwá̱n ayꞌya wel kiki̱xtia̱yaj re̱dej iga komati to̱poj kipiaya. ");
INSERT INTO nhx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Iwá̱n inó̱n discípulo yej Jesús kipoxcho̱kilia̱ya, kijlij Pedro: —¡Ino̱nwaꞌ toTe̱ko! Kua̱ꞌ kikáꞌ Simón Pedro iga toTe̱ko, motaajakij, iga ayá̱ꞌ kakijtoya itzótzol, iwá̱n momo̱taꞌ a̱tampa. ");
INSERT INTO nhx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sekin disci̱polojmej asikej ipan playa iwá̱n á̱ka̱l, kitila̱ntiajkij re̱dej yej kipiaya komati to̱pojmej, puej onoyaj ken cien metros iga a̱te̱n. ");
INSERT INTO nhx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kua̱ꞌ temójkeja ipan á̱ka̱l kasitoj Jesús kipiá pa̱n iwá̱n nemi kixka se̱ michin pan tékol. ");
INSERT INTO nhx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús kijtoj: —Xikuajligaka̱n achi to̱poj yej ankiki̱tzkíjkejoꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro tejkaj ipan á̱ka̱l iwá̱n kiwawatatzoj este ipan playa inó̱n re̱dej yej kiwajligaya ciento cincuenta y tres wejweyi to̱poj; malej iga komati, eꞌ re̱dej ayá̱ꞌ tzaya̱niꞌ ");
INSERT INTO nhx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iwá̱n Jesús kijtoj: —Xitakuá̱kija. Iwá̱n nisé̱ de idisci̱polojmej ami̱xe̱wia̱ya iga kitajtaniáj a̱ꞌyéj in yéj, iga kimatiáj iga toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Iwá̱n Jesús tana̱ꞌtechoj, kikuiꞌ pa̱n iwá̱n kimajmakakej yejeme̱n; ijko̱nsan no̱ kichij iwá̱n to̱poj. ");
INSERT INTO nhx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Iga iní̱n e̱yi ve̱ja iga Jesús ki̱xne̱xtilij idisci̱polojmej kua̱ꞌ ojpa‑isaꞌ. ");
INSERT INTO nhx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kua̱ꞌ tamiꞌ takuajkej, Jesús kitajtan Simón Pedro: —Simón, ipiltzi̱n Jonás, ¿ix tine̱cho̱kiliá má̱j que ini̱mej? Pedro kijtoj: —Kena noTe̱ko, tej tikmati iga nimitzcho̱kiliá. Iwá̱n Jesús kijtoj: —Xine̱cuida̱rowíliwaꞌ noborre̱gojtzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Sej kitajtan, iga iní̱n o̱me ve̱jya: —Simón, ipiltzi̱n Jonás, ¿ix tine̱cho̱kiliá? Pedro kijtoj: —Kena noTe̱ko, tej tikmati iga nimitzcho̱kiliá. Jesús kijtoj: —Xicuida̱ro noborre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iga iní̱n e̱yi ve̱ja kitajtan: —Simón, ipiltzi̱n Jonás, ¿ix tine̱cho̱kiliá? Pedro mokno̱matiꞌ iga e̱yi ve̱ja kitajtanij iga si kicho̱kiliá; iwá̱n kijlij: —NoTe̱ko, tej nochi tikmati; tej tikmati iga nimitzcho̱kiliá. Jesús kijtoj: —Xicuida̱ro noborre̱gojtzitzi̱n. ");
INSERT INTO nhx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nimitznojma‑ijliá iga kua̱ꞌ tichokótzi̱noꞌ, timotaajakia̱ya iga tia̱ya ka̱n tej tikneki; eꞌ kua̱ꞌ tiwé̱weja, tikmela̱was moma̱ꞌ iwá̱n seꞌ mitztaajaki̱lti̱j iwá̱n mitzwi̱gas ka̱n ayá̱ꞌ tikneki. ");
INSERT INTO nhx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Iga iní̱n kijtoj, Jesús nemi kijtowa kén iga Pedro yawi mikiti iwá̱n ijkó̱n kiweyimati̱lti̱j Dios. Iwá̱n Jesús kijtoj: —¡Xine̱toka! ");
INSERT INTO nhx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Kua̱ꞌ Pedro tacháꞌ itepotztajpa, kitaꞌ iga kitokatiwa̱laj inó̱n yej Jesús kipoxcho̱kilia̱ya, ino̱nsan yej e̱watoya ite̱noj kua̱ꞌ cena̱rojtoyaj iwá̱n kitajtan: “NoTe̱ko, ¿a̱ꞌyéj in yej yawi mitzne̱xti̱ti iga mamitzki̱tzki̱ka̱n?” ");
INSERT INTO nhx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Kua̱ꞌ Pedro kitaꞌ, kitajtan Jesús: —NoTe̱ko, in iní̱n ¿te̱ yawi kipasa̱ro̱ti? ");
INSERT INTO nhx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesús kijtoj: —Siga nikneki ma‑isato este kua̱ꞌ nej niwi̱ꞌ, inó̱n tej atikmati. Tej xine̱toka. ");
INSERT INTO nhx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Iwá̱n mopowaꞌ iga inó̱n discípulo ayá̱ꞌ mikis. Eꞌ Jesús ayá̱ꞌ kijtoj iga ayá̱ꞌ mikis, sino que kijtoj: “Siga nikneki ma‑isato este kua̱ꞌ nej niwi̱ꞌ, inó̱n tej atikmati.” ");
INSERT INTO nhx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nejsan in inó̱n discípulo yej nikpowa nochi iní̱n yej nikitaꞌ, iwá̱n nikijkuiloj. Iwá̱n nikmati iga ayá̱ꞌ nitakajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ónogoꞌ má̱j yej Jesús kichij; siga mamo‑ijkuilo katka sejsé̱ sejsé̱, anka ipan inewi ta̱jli akitolo̱j a̱mamej yej mo‑ijkuilo̱j. Ijkó̱nyawaꞌ.");
INSERT INTO nhx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teófilo yej nimitzpoxye̱ꞌita, ipan yej achto noli̱broj, nimitzijkuilowilij nochi ken iga Jesús kichij wa̱n tamachtij este iga pe̱waꞌ itekipáno̱l, ");
INSERT INTO nhx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","iwá̱n este iga tejkaj ipan cielo. Kua̱ꞌ aya yawi ipan cielo kitapejpen iyapo̱stolejmej wa̱n iga el Espíritu Santo kitekimakakej te̱ makichi̱waka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kua̱ꞌ Jesús ojpa‑isaꞌ ka̱n miktoya, yéj ima̱tika mi̱xne̱xtij iyi̱xtaj yejemej, iwá̱n cuarenta día ki̱xne̱xtilijtoya iga makitaka̱n iga melá̱ꞌ iga isatoꞌ. Kita̱tapo̱wia̱yaj kén iga reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mie̱j Jesús sen‑onoyaj iwá̱n iyapo̱stolejmej kijlij iga aya maki̱saka̱n Jerusalén, kijtoj: —Xikchaka̱n este iga maasi yej toTaj kijtoj iga yawi mitzmakatij, ijkó̱n kensan nimitzijlijkej. ");
INSERT INTO nhx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Melá̱ꞌ iga Juan tabautiza̱roj iga a̱ꞌti, eꞌ amejeme̱n ayoꞌ ke̱ꞌ poliwi iga Dios yawi mitzbautiza̱ro̱tij iga el Espíritu Santo. ");
INSERT INTO nhx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Yej ompa nechkatoyaj iwá̱n Jesús, kitajtankej: —NoTe̱ko, ¿ix á̱manya tikchi̱was iga sej ise̱lti mamomanda̱ro topaí̱s Israel? ");
INSERT INTO nhx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iwá̱n Jesús kijtoj: —Ino̱nwaꞌ ayá̱ꞌ kajasi iga amejeme̱n xikmatika̱n ke̱man mochi̱was, petz toTaj kimati ke̱man yawi kichi̱wati. Inó̱n yéjsan wel kichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Eꞌ kua̱ꞌ el Espíritu Santo onos ipan amejeme̱n, ankipiáskeja poder, iwá̱n anki̱saskej iga anta̱tapowaskej de nej. Anya̱tij Jerusalén iwá̱n no̱ya̱n ipan estado de Judea, iwá̱n este Samaria, iwá̱n este ka̱n má̱j wejwejka ipan nochi ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kua̱ꞌ tamiꞌ kijtoj inó̱n, mie̱j kitajtachi̱lijtoyaj, Jesús pe̱ꞌ tejkaj iga yajki ipan cielo; iwá̱n se̱ mixti kitzakuako iwá̱n ayoꞌ má̱j kitakej. ");
INSERT INTO nhx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Iwá̱n mie̱j ajajkotachi̱xtoyaj iga Jesús nemi tejkawi, íkua̱ꞌya ne̱sikoj ite̱nojmej o̱me̱n tajta̱gaꞌ yej este ijista̱ꞌ itzotzolmej, ");
INSERT INTO nhx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","iwá̱n kijlijkej: —Tajta̱gaꞌ de Galilea, ¿te iga antajtachi̱xtokej ipan cielo? Ini̱nsan Jesús yej amo‑i̱xtaj tejkaj ipan cielo, yawi sej wi̱tzeti kensan iná̱n ankitakej yajki. ");
INSERT INTO nhx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Iwá̱n ki̱skej ipan tepe̱ꞌ yej ito̱ka̱ꞌ Oli̱vojyoj iga yajkij Jerusalén. Ayá̱ꞌ pox wejka nejnenkej, ken se̱ kilómetro, ke̱ꞌsan la ley tatekimakaya iga wel manejnemilo ipan día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Kua̱ꞌ asikej Jerusalén, tejkajkej ipan segundo piso ipan kajli ka̱n ka̱wiáj. Ompa onoyaj Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo yej Alfeo ipiltzi̱n, Simón yej iparti̱doj nacionalista, iwá̱n Judas yej iyikni̱n Jacobo. ");
INSERT INTO nhx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nochi yejemej nochipa monechkowa̱yaj iga ora̱dowa̱yaj iwá̱n iyikni̱wa̱n Jesús iwá̱n María yej íye̱ꞌpa Jesús iwá̱n sekin siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ino̱mej días Pedro moketzaꞌ tajkoya̱n ka̱n nechkatokej ken ciento veinte yej kitokaj toTe̱ko, wa̱n kijtoj: ");
INSERT INTO nhx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Nokni̱wa̱n, sányasan mochi̱waya yej ijkuilijtoꞌ yej el Espíritu Santo áchtoya kitajto̱lmáꞌ David, iga tajtoj de Judas yej kojkui̱ltij ino̱mej yej kiki̱tzkijkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas tejéme̱mpa katka, iwá̱n tisentekipanojtoyaj íwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yéj kikowaꞌ se̱ ta̱jli iga inó̱n tomi̱n yej kimakakej iga kichij yej aye̱kti, iwá̱n ompa tzonto̱ktiajki, este talaxpoxo̱niꞌ, ki̱saꞌ nochi ikuitáxkol. ");
INSERT INTO nhx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kua̱ꞌ yej cha̱ntitokej Jerusalén kimatikej, kito̱ka̱wijkej inó̱n ta̱jli Acéldama, yej ipan itajto̱lmej yejeme̱n kijto̱jneki Ta̱jli yej Esyoj. ");
INSERT INTO nhx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Iga ipan Salmos kijtowa ijkí̱n: Íkal maka̱wi ise̱lti, ayoꞌ agaj mamocha̱nti ompa. Iwá̱n kijtowa no̱: Seꞌ makikui yej yejpa katka itekipáno̱l. ");
INSERT INTO nhx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Nigaj iwá̱n tejemej onokej tajta̱gaꞌ yej nemiáj nochipa iwá̱n tejemej kua̱ꞌ toTe̱ko Jesús onoya towa̱n, ");
INSERT INTO nhx_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","este iga Juan kibautiza̱roj iwá̱n este iga tejkaj ipan cielo. Ye̱kti iga se̱ de yejemej mamose̱tili wa̱n tejemej iga no̱ makipowa iga ojpa‑isaꞌ toTe̱ko Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Iwá̱n kitapejpenkej o̱me̱n de yejemej: Matías wa̱n José yej no̱ kipiaya seꞌ o̱me ito̱ka̱ꞌ: Barsabás iwá̱n Justo. ");
INSERT INTO nhx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ijkí̱n kite̱ne̱wijkej Dios: —NoTe̱ko, tej yej tiki̱xmati nochi noa̱lmajmej, xine̱ne̱xtili̱ka̱n de ini̱mej o̱me̱n katiapa tiktapejpena ");
INSERT INTO nhx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","iga matekipano ken apóstol, yej katka itekipáno̱l Judas yej kipoloj iga kichij yej aye̱kti iwá̱n yajki ka̱n kajasi. ");
INSERT INTO nhx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Iwá̱n kichijkej rifa iwá̱n kita̱nij Matías. Iwá̱n desde íkua̱ꞌ mose̱tílija iwá̱n ino̱mej once apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kua̱ꞌ asiꞌ iga mochi̱wa ilwiꞌ yej kijliáj Pentecostés, nochi yej kitokaj Jesús, séka̱nsan onoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kua̱ꞌ kikakikej we̱jtikui̱niko yej wa̱laj ipan cielo ken se̱ ejekaꞌ yej pox tajpalej. Iwá̱n na̱watitoya no̱ya̱n kalijtiꞌ ka̱n eje̱watoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Iwá̱n ne̱siko ken tile̱nguaj, xojxo̱tato ipan sejsé̱ sejsé̱ de yejemej. ");
INSERT INTO nhx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Iwá̱n el Espíritu Santo asiꞌ ipan yejeme̱n, iwá̱n pe̱ꞌ tajtojkej ipan se̱seꞌpa tájto̱l kensan el Espíritu Santo kitajto̱ltia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ino̱mej días Jerusalén onoyaj judiyojmej yej kitekiweyimati̱ltia̱yaj Dios, yej no̱ya̱n wa̱lkej ipan pai̱smej. ");
INSERT INTO nhx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kua̱ꞌ kikakikej tatikui̱ntoꞌ, monechko̱lo̱ꞌ iwá̱n ayoꞌ kimatiáj te̱ kichi̱wayaj, iga kikaktokej nemi tajtowaj ipan sejsé̱ itajto̱lmej yejemej. ");
INSERT INTO nhx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Madmira̱dojkej, iwá̱n este moyo̱lmajtijkej, iwá̱n mojlia̱yaj: —In ini̱mej, ¿ayejtaj de Galilea in yej nemi tajtowaj? ");
INSERT INTO nhx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Kéntaj welij tikakij nemi tajtowaj ipan sejse̱pa totájto̱l? ");
INSERT INTO nhx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nigaj onokej yej wa̱lkej Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto iwá̱n ta̱jli yej ito̱ka̱ꞌ Asia, ");
INSERT INTO nhx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia iwá̱n Panfilia, Egipto, wa̱n a̱ltepe̱mej África yej onoꞌ iyi̱ka̱n Cirene. No̱ yej wa̱lkej Roma yej nigaj cha̱ntitokej; sekin de yejemej melaꞌjudiyojmej, sekin yej kicre̱dojkej ken kicre̱dowaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Onokej no̱ yej wa̱lkej Creta iwá̱n Arabia; eꞌ tonochi̱n tikakij ipan totajto̱lmej te̱powiliáj yej Dios kichi̱wa yej pox ye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Inochi̱n moyo̱lmajtijtoyaj este ayꞌya kimatiáj te̱ kichi̱wayaj, iwá̱n motajtaniáj: —¿Nochi iní̱n, té̱ a̱n kijto̱jneki? ");
INSERT INTO nhx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Eꞌ sekin kipi̱najtia̱yaj iwá̱n kijtowa̱yaj: —Iní̱mejwaꞌ ta̱wa̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Iwá̱n Pedro moketzaꞌ iwá̱n ino̱mej once apo̱stolejmej; kijtoj recio: —Judiyojmej iwá̱n nochi yej ancha̱ntitokej Jerusalén; xikmatika̱n iwá̱n xikye̱ꞌkakika̱n iní̱n yej nia nimitzijli̱tij. ");
INSERT INTO nhx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ini̱mej ayá̱ꞌ ta̱wa̱mej ken amejeme̱n ankijtowaj, ¿ix ayá̱ꞌ ankitaj iga yowáltigoꞌ? Las nue̱vejoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ini̱nwaꞌ nemi mochi̱wa yej el profeta Joel íkyaya kijtoj ijkí̱n: ");
INSERT INTO nhx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kijtoj Dios; kua̱ꞌ ayoꞌ wejka iga nitajuzga̱ro̱ki, nia nikmakati noEspí̱ritoj nochi gente, amookichpilowa̱n iwá̱n amosiwa̱pilowa̱n nia niktajto̱lmakatij, iwá̱n chokomej kitaskej yej nej Dios nikne̱xtili̱skej, iwá̱n yej we̱wetkej te̱mikiskej. ");
INSERT INTO nhx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ino̱mej días nikmakas noEspí̱ritoj tajta̱gaꞌ wa̱n siwa̱tkej yej ne̱tokaj, iwá̱n yawij tajto̱tij de nej. ");
INSERT INTO nhx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nia nikne̱xti̱ti nopode̱r ajko ipan cielo, iwá̱n tani ipan ta̱jli onos yej tane̱xtiliá: esti, tiꞌti iwá̱n mixti de po̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","El sol ayꞌya ta̱wi̱j, iwá̱n me̱tzti mochi̱was ken tikita esti, inó̱n mochi̱was kua̱ꞌ aya asi inó̱n día kua̱ꞌ poxsan majmawilo̱j iga wi̱ꞌ toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Eꞌ nochi yej kite̱ne̱wiá ito̱ka̱ꞌ toTe̱ko, moma̱nawi̱skej. ");
INSERT INTO nhx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Nokni̱mej yej no̱ an‑israeli̱tajmej, xikakika̱n yej nia nimitzijli̱tij: Dios kiye̱ꞌitaꞌ Jesús yej icha̱n Nazaret. Iwá̱n amo‑i̱xtaj Jesús kichij miaꞌ milagro, iwá̱n yej pox ye̱kti iga Dios kipale̱wij. Iní̱n amejeme̱n ankimátija. ");
INSERT INTO nhx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Dios kejla̱ntoya desde ikya iga Jesús makikno̱chi̱waka̱n wa̱n mawetzi pan ima̱mej yej kijiyaj. Amejeme̱n ankiki̱tzkijkej iwá̱n ankika̱watoj ipan ima̱mej tajta̱gaꞌ yej poxsan ayompa nemij, wa̱n kimiktijkej Jesús ipan cruz. ");
INSERT INTO nhx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Eꞌ Dios sej kixitij, ijkó̱n iga kiki̱xtij ka̱n miktoya, porque Jesús wel ojpa‑isaꞌ ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","El rey David tajtoj ijkí̱n de Jesús: Nochipa toTe̱ko onoꞌ no‑i̱xtaj; iga yéj onoꞌ noná̱ꞌ, nité̱ ane̱kuekuechkaltiá. ");
INSERT INTO nhx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Inó̱n iga nipoxyo̱lchikajtoꞌ iwá̱n nitakui̱ka iga nipa̱ktoꞌ, malej iga se̱ día nimikis, niye̱ꞌonoꞌ iga nimoconfia̱rowa ipan Dios. ");
INSERT INTO nhx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ayá̱ꞌ tine̱kajte̱was ka̱n onoꞌ yej miktokej; ayá̱ꞌ no̱ tiknekis iga nej yej nochipa nimitzweyimati̱ltiá, mapala̱ni nonakayo. ");
INSERT INTO nhx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tine̱ne̱xtilij ojtimej yej ne̱wi̱ga ka̱n wel niye̱ꞌonos, iwá̱n poxsan niyo̱lpa̱kis iga tonoꞌ nowa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pedro no̱ kijtoj: —Nokni̱wa̱n, nochi kimati iga to‑ikyapatajwe̱wej David miguiꞌ iwá̱n moto̱gaꞌ, iwá̱n este iná̱n tikmatij ka̱n to̱ktoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Eꞌ David yajki profeta, iwá̱n kimatitoyay iga Dios kinojma‑ijlij iga ipan se̱ de ipilowa̱n ipilówa̱mpa yawi ki̱sati Cristo yej yawi mochi̱wati rey. ");
INSERT INTO nhx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Inó̱n iga David, este ikyay kenkua̱ꞌ kitztoyay, kijtoj iga Cristo yawi ojpa‑isati iwá̱n ayá̱ꞌ ka̱wis ka̱n onokej yej miktokej iwá̱n ayá̱ꞌ pala̱nis inakayo. ");
INSERT INTO nhx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pues Dios ki‑ojpa‑ixitij ini̱nya Jesús, iwá̱n inó̱n nonochimej nikmelaꞌitakej. ");
INSERT INTO nhx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesús yajki ipan cielo iga Dios kiwi̱gaꞌ iwá̱n mota̱lij ila̱doj iye̱ꞌma̱ꞌ, iwá̱n toTaj Dios kimáꞌ iyEspí̱rito Santo kensan kijtoj. Iní̱n yej iná̱n amejeme̱n nemi ankitaj iwá̱n ankikakij wi̱ꞌ de yéj. ");
INSERT INTO nhx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Eꞌ ayéj David yej tejkaj ipan cielo; puej yéjsan kijtoj ijkí̱n: ToTe̱ko kijlij noTe̱ko: “Ximota̱li ila̱doj noye̱ꞌma̱ꞌ ka̱n nimanda̱rowa, ");
INSERT INTO nhx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","este que manikta̱li mokxitampa yej mitzijiyaj.” ");
INSERT INTO nhx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Amonochimej an‑israeli̱tajmej, xikmatika̱n iga inó̱n Jesús yej ankimiktijkej ipan cruz, Dios kita̱lij iga mamochi̱wa toTe̱ko iwá̱n iga mamochi̱wa Cristo. ");
INSERT INTO nhx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Kua̱ꞌ inó̱n kikakikej, pox mokno̱matikej iwá̱n kitajtankej Pedro iwá̱n sekin apo̱stolejmej: —Nokni̱wa̱n, ¿te̱ wel manikchi̱waka̱n? ");
INSERT INTO nhx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Iwá̱n Pedro kijtoj: —Xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti wa̱n xikna̱ꞌtecho̱ka̱n Dios iwá̱n ximobautiza̱ro̱ka̱n sejsé̱ de amejeme̱n ipan ito̱ka̱ꞌ Jesucristo, iga mamitzperdona̱rowili̱ka̱n yej ankichijkej yej aye̱kti; iwá̱n Dios mitzmakaskej iyEspí̱rito Santo. ");
INSERT INTO nhx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ToTe̱ko Dios mitzijliáj, iga iní̱n mitzmakaskej amejeme̱n iwá̱n amopilowa̱n, iwá̱n ino̱mej yej wejka onokej; sanké̱ꞌ toTe̱ko kino̱tzas. ");
INSERT INTO nhx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ayejsan ijkó̱n tano̱no̱tzaꞌ Pedro, ma̱joꞌ no̱ tano̱no̱tzaꞌ ijkí̱n: —Ximoma̱nawi̱ka̱n iga Dios amo mamitzikno̱chi̱waka̱n ken kikno̱chi̱waskej ino̱mej yej kimiktijkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Yej kitajto̱lkui̱lij Pedro, mobautiza̱rojkej; yej íkua̱ꞌ kicre̱dojkej Jesús, asiꞌ este ken tres mil. ");
INSERT INTO nhx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Iwá̱n inochi̱n kichi̱wayaj kensan apo̱stolejmej kine̱xtilia̱yaj, iwá̱n se̱san iya̱lmajmej kipiayaj, seka̱n kichi̱wayaj la Santa Cena wa̱n sen‑ora̱dowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Iwá̱n inochi̱n madmira̱dojkej iga kitayaj iga Dios kine̱xtia̱ya ipode̱r ipan apo̱stolejmej kua̱ꞌ kichi̱wayaj miaꞌ milagro. ");
INSERT INTO nhx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Iwá̱n inochi̱n yej kicre̱dojkej toTe̱ko se̱san iya̱lmajmej kipiayaj iwá̱n nochi yej itatkimej kisempiayaj. ");
INSERT INTO nhx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Iwá̱n kinamakayaj nochi yej itatkímejpa, iwá̱n itomi̱nyo moparti̱rowilia̱yaj ke̱ꞌsan iga se̱ kipolowa. ");
INSERT INTO nhx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Iwá̱n nochipa monechkowa̱yaj weyitio̱pan, iwá̱n sentakua̱yaj icha̱mej sekin, inochi̱n pa̱ktoyaj iwá̱n ayagaj moweyimatiá. ");
INSERT INTO nhx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kiweyimati̱ltia̱yaj Dios iwá̱n nochi gente kiye̱ꞌitaya yej kichijtokej; iwá̱n toTe̱ko cada día kichi̱waya iga makomatiaka̱n yej moma̱nawijkej iga moconfia̱rojkej ipan Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pedro iwá̱n Juan nemi senya̱yaj weyitio̱pan tio̱taꞌ las tres, iga inó̱n hora nokta kite̱ne̱wia̱yaj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ompa tio̱pan onoya se̱ ta̱gaꞌ yej itékiya nokta iga awel nejnemi, nochipa katka kika̱watij tio̱pan, ipan kalte̱n yej ito̱ka̱ꞌ Mo̱nsajtiꞌ iga kitajtanilia̱ya tomi̱n yej ompa kalakiáj. ");
INSERT INTO nhx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kua̱ꞌ inó̱n yej awel nejnemi kitaꞌ Pedro iwá̱n Juan iga nemi kalakij tio̱pan, kitajtanilijkej tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Entonces Pedro iwá̱n Juan kitachi̱lijkej inó̱n yej awel nejnemi, iwá̱n Pedro kijlij: —Xine̱tachi̱li̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yej awel nejnemi tachi̱xtiki̱saꞌ, yéj kijtoj anka yawij kimakatij tejté̱. ");
INSERT INTO nhx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Eꞌ Pedro kijtoj: —Anikpiá plata niga oro, eꞌ yej nikpiá nia nimitzmakati: Jesucristo yej de Nazaret nochi wel kichi̱wa iwá̱n yéj ne̱ti̱tan, inó̱n iga nimitzijliá, ximoketza wa̱n xinejnemi. ");
INSERT INTO nhx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pedro, kiki̱tzkilij iye̱ꞌma̱ꞌ iwá̱n kiketzaꞌ, iwá̱n íkua̱ꞌsan tojtomiꞌ inochi iyikxi. ");
INSERT INTO nhx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Iwá̱n inó̱n yej awel nejnejmi witó̱niꞌpa iga moketzaꞌ, iwá̱n pe̱ꞌya nejnen, senkalákkeja tio̱pan iwá̱n Pedro wa̱n Juan, wi̱wito̱ntinemiá iwá̱n kiweyimati̱ltijtinemiá Dios. ");
INSERT INTO nhx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nochi kitakej iga nejnemiaya iwá̱n kiweyimati̱ltia̱ya Dios. ");
INSERT INTO nhx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ki̱xmatiáj iga ino̱nya ta̱gaꞌ yej mota̱lia̱ya ipan tio̱pan ikalte̱nyo yej ito̱ka̱ꞌ Mo̱nsajtiꞌ iga kitajtaniá tomi̱n, iwá̱n poxsan madmira̱dojkej wa̱n moyo̱lmajtijkej iga inó̱n kitakej. ");
INSERT INTO nhx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inó̱n yej awel nejnejmiá, ayoꞌ kinekiá makikajte̱wa Pedro iwá̱n Juan, iwá̱n nochi gente madmira̱dojkej iwá̱n yajkij weyitió̱pampa ka̱n ikalte̱nyo yej ito̱ka̱ꞌ Salomón ka̱n yejeme̱n onoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Inó̱n kitaꞌ Pedro, kijtoj: —Nokni̱mej yej no̱ an‑israeli̱tajmej, ¿te iga anmoyo̱lmajtiáj? ¿Te iga nejeme̱n anne̱tachi̱liáj kenkua̱ꞌ nejemej nikachitialtijkej iní̱n ta̱gaꞌ? ¿Ix nikachitialtijkej iga nejemej niwelitij o iga niye̱ꞌnemij iyi̱xtaj Dios? ");
INSERT INTO nhx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ayéj ijkó̱n, ma̱jwaꞌ ino̱nsan iDio̱s to‑ikyapatajwa̱n Abraham, Isaac iwá̱n Jacob kichij iní̱n iga kipoxye̱ꞌita Jesús yej iPiltzi̱n. Inó̱n Jesús yej amejeme̱n ankijiyakej iwá̱n ankika̱watoj ipan ima̱ꞌ Pilato yej gobernador. Kua̱ꞌ Pilato kinekiá makimajka̱wa, amejeme̱n ayá̱ꞌ ankinekikej. ");
INSERT INTO nhx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Amejemej katka xiktajtowili̱ka̱n iga makimajka̱waka̱n Jesús yej ayá̱ꞌ kichij yej aye̱kti, ma̱jwaꞌ ankijtojkej iga makimajka̱waka̱n seꞌ ta̱gaꞌ yej tamiktij. ");
INSERT INTO nhx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ijkó̱n iga ankimiktijkej inó̱n yej te̱maka vida. Eꞌ Dios ki‑ojpa‑ixitij ka̱n miktoya, inó̱n nejemej niknojma‑itakej. ");
INSERT INTO nhx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iga nimoconfia̱rowaj iga Jesús wel nochi kichi̱wa, achitiáꞌ iní̱n ta̱gaꞌ yej iná̱n ankitaj iwá̱n anki̱xmatij. Igasan nimoconfia̱rowaj ipan Jesús inó̱n nokta iga melaꞌachitiáꞌ in iní̱n ta̱gaꞌ yej onoꞌ amo‑i̱xtaj. ");
INSERT INTO nhx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Nokni̱wa̱n, nikmati iga kua̱ꞌ amejeme̱n iwá̱n yej mitzmanda̱rowaj ankimiktijkej Jesús, ayá̱ꞌ ankimatiáj te̱ nemi ankichi̱wayaj. ");
INSERT INTO nhx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Eꞌ ijkó̱n Dios kichij iga mamochi̱wa ken ikya kijtojkej profe̱tajmej iga Cristo yawij kikno̱chi̱watij. ");
INSERT INTO nhx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Inó̱n iga xikajte̱wáka̱nya iga ankichi̱waj yej aye̱kti wa̱n xikna̱ꞌtecho̱ka̱n Dios, iga mamitzperdona̱rowili̱ka̱n yej ankichijkej yej aye̱kti. Iwá̱n toTe̱ko kichi̱was iga xiye̱ꞌonoka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Iwá̱n Dios no̱ mitzti̱tanili̱skej Jesús yej el Cristo yej íkyaya kitapejpen iga mitzti̱tanilia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Malej iga iná̱n Jesucristo ká̱wisoꞌ ipan cielo este que Dios makiyejye̱ꞌta̱li nochi, ken kijtoj ipan iprofe̱tajmej yej ye̱ꞌnemikej yej ikyay onoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ijkó̱n Moisés kijlij to‑ikyapatajwa̱n: “ToTe̱ko Dios yawi mitzti̱tanili̱tij se̱ profeta yej de amejéme̱mpa, ijkó̱n ken nej ne̱ti̱tan. Xikchi̱waka̱n nochi yej yéj mitzijli̱skej, ");
INSERT INTO nhx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","iga nochi yej ayá̱ꞌ kitajto̱lkuis inó̱n profeta, ayꞌya wel onos ka̱n onoskej ipilowa̱n Dios.” ");
INSERT INTO nhx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Iwá̱n nochi profe̱tajmej desde Samuel iwá̱n yej despue̱ja tajtojkej, no̱ kijtojkej yej iná̱n nemi mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Yej Dios kijlij profe̱tajmej iga kichi̱was, inó̱n iga amejeme̱n xiye̱ꞌonoka̱n. Dios kichij se̱ pacto iwá̱n to‑ikyapatajwe̱wetkej, kua̱ꞌ ijkí̱n kijlij Abraham: “Nej nikchi̱was iga pan mopilowa̱n ipilówa̱mpa, nochi gente yej onokej ipan iní̱n ta̱jli maye̱ꞌonoka̱n.” ");
INSERT INTO nhx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kua̱ꞌ Dios ki‑ojpa‑ixitij iPiltzi̱n, amejemej achto mitzti̱tanilijkej iga mamitzyo̱lchika̱waka̱n iwá̱n iga xikajte̱waka̱n iga ankichi̱waj yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mie̱j Pedro iwá̱n Juan ta̱tapojtóyajoꞌ iwá̱n la gente, asikej sacerdo̱tejmej iwá̱n saduceojmej iwá̱n ije̱fej policiyajmej yej kicuida̱rowaj weyitio̱pan. ");
INSERT INTO nhx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kuesitoyaj iga Pedro iwá̱n Juan tane̱xtilijtoyaj iga kena, ojpa‑isaskej yej miktokej iwá̱n inó̱n mone̱xtij kua̱ꞌ ojpa‑isaꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kiki̱tzkijkej Pedro iwá̱n Juan eꞌ iga tió̱taꞌya katka kiwi̱gakej ipan cárcel, iwá̱n senyówal ompa onoyaj, kiki̱xtijkej este iga tane̱siꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Eꞌ miaꞌ yej kikakikej yej kipojtoya Pedro, kicre̱dojkej; iwá̱n yej kitokaj Jesús masiꞌ ken cinco mil, petz tajtá̱gaꞌsan iyoka siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ipan seꞌya día, monechkojkej Jerusalén ije̱fejmej judiyojmej, totajwe̱wetkej yej manda̱rowaj iwá̱n yej tamachtiáj ipan la ley. ");
INSERT INTO nhx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ompa no̱ onoya Anás yej kimanda̱rowa sacerdo̱tejmej, Caifás, Juan, Alejandro, iwá̱n inewi iyikni̱wa̱n sacerdo̱tejmej yej manda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Iwá̱n kikuitoj Pedro iwá̱n Juan, iwá̱n kita̱lkej tajkoya̱n, iwá̱n ijkí̱n kitajtankej: —¿A̱ꞌ mitzijlijkej iga wel antamachtiáj ijkí̱n? ¿A̱ꞌyéj mitzmakakej poder iga wel antaachitialtiáj? ");
INSERT INTO nhx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Iwá̱n el Espíritu Santo kitajto̱lmáꞌ Pedro, kijtoj: —Amejeme̱n yej anmanda̱rowaj, iwá̱n notajwe̱wetkej de Israel: ");
INSERT INTO nhx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ya que amejeme̱n anne̱tajtanij te íga nikchi̱wilijkej yej ye̱kti iní̱n ta̱gaꞌ yej we̱titoya iwá̱n ankinekij xikmatika̱n kén iga achitiáꞌ, ");
INSERT INTO nhx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","niknojma‑ijtowa amo‑i̱xtaj iga makimati nochi israeli̱tajmej, iga iní̱n ta̱gaꞌ yej to‑i̱xtaj onoꞌ, achitiáꞌ iga ipode̱r Jesucristo de Nazaret, inó̱n Jesús yej amejemej ankimiktijkej ipan cruz iwá̱n Dios ki‑ojpa‑ixitij ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Amejemej yej ken ankalchi̱waj, iní̱n Jesús ken se̱ teꞌti yej ankitajkalkej, eꞌ iní̱n teꞌti kitakej iga ma̱jya sej ye̱kti iwá̱n kikuikej iga ípan pe̱waꞌ iga mochij kajli. ");
INSERT INTO nhx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Petz Jesús wel te̱ma̱nawiá; iga Dios te̱ti̱tanilij Jesús iwá̱n ateyi seꞌ ipan iní̱n ta̱jli, yej ípan wel timoma̱nawiáj. ");
INSERT INTO nhx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kua̱ꞌ yej manda̱rowaj kitakej iga Pedro iwá̱n Juan pox tajto̱lmatij, madmira̱dojkej iga kimatiáj iga Pedro wa̱n Juan, na̱mo̱lmej yej ayá̱ꞌ pox momachtijkej; wa̱n kicre̱dojkej iga nemiáj wa̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ompa ejkatoya iwá̱n yejeme̱n inó̱n ta̱gaꞌ yej achitiáꞌ, inó̱n íga awel te̱ kijlia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Entonces kitekimakakej Pedro iwá̱n Juan iga maki̱saka̱n ka̱n monechkowaj yej manda̱rowaj iga kinekiáj yejéme̱nsan maka̱wika̱n iga mata̱tapowaka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kijtowa̱yaj: —¿Te̱ yej tiawij tikchi̱wili̱tij ini̱mej tajta̱gaꞌ? Nochi de Jerusalén kimatij iga kichijkej iní̱n milagro, inó̱n awel tikijtowaj iga ayá̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Eꞌ iga ayoꞌ má̱j mapi̱wi iní̱n tájto̱l ipan a̱ltepe̱ꞌ, matikmajmajti̱ka̱n iga ayoꞌ agaj makipowili̱ka̱n de Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Iwá̱n kino̱tzkej, kitekimakakej iga ayoꞌ nokta matajto̱ka̱n niga matamachti̱ka̱n de Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pedro iwá̱n Juan kijtojkej: —Amejeme̱n, ¿kén ankitaj?, ¿ix má̱j ye̱kti iyi̱xtaj Dios manimitztajto̱lkui̱li̱ka̱n amejeme̱n o maniktajto̱lkui̱li̱ka̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Puej nejemej awel nikajte̱waj iga nikijtowaj yej nikitakej iwá̱n nikakikej. ");
INSERT INTO nhx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Iwá̱n yej manda̱rowaj kimajmajtijkej Pedro wa̱n Juan iwá̱n kimajkajkej. Akasikej kén iga wel makikno̱chi̱waka̱n iga nochi gente kiweyimati̱ltia̱ya Dios iga inó̱n ta̱gaꞌ yej achitiáꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Inó̱n ta̱gaꞌ yej ipan yéj mochij milagro iga achitiáꞌ, kipiayay má̱j de cuarenta años. ");
INSERT INTO nhx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kua̱ꞌ Pedro iwá̱n Juan kimajkájkeja, yajkij ka̱n onokej yej kicre̱dowaj Jesucristo, iwá̱n kipowilijkej inewi yej kijtojkej ije̱fejmej sacerdo̱tejmej iwá̱n we̱wetkej yej manda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kua̱ꞌ inó̱n kikakikej, inochi̱n kisente̱ne̱wijkej Dios, kijtojkej: —NoTe̱ko, tej tiDio̱s yej tikchij cielo, ta̱jli, láma̱r iwá̱n inewi yej onoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Tej iga moEspí̱rito Santo tiktajto̱lmáꞌ David yej mitztoka, kijtoj: ¿Te iga kuejkuesiwilo ipan pai̱smej, iwá̱n la gente kejla̱mikij iga kichi̱waj yej aye̱kti yej niga kipale̱wiáj? ");
INSERT INTO nhx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Re̱yejmej yej onokej ipan iní̱n ta̱jli inochi̱n monechkojkej, yej manda̱rowaj ipan a̱ltepe̱mej mosenechkojkej, yajkij ico̱ntraj toTe̱ko wa̱n ico̱ntraj Cristo yej kiti̱tan. ");
INSERT INTO nhx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Melá̱ꞌ iga nigaj ipan iní̱n a̱ltepe̱ꞌ mosenechkojkej Herodes iwá̱n Poncio Pilato iwá̱n la gente de Israel iwá̱n yej ayéj de Israel, mota̱lkej ico̱ntraj moPiltzi̱n Jesús yej tej tiktapejpen iga marreina̱ro. ");
INSERT INTO nhx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Iga inó̱n, yejemej kichijkej nochi yej tej tikejla̱ntoya iga ijkó̱n yawi mochi̱wati. ");
INSERT INTO nhx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","NoTe̱ko xikita iga ne̱mikti̱jnekij iwá̱n xine̱pale̱wi̱ka̱n iga amo manimajmawika̱n iga manikpowaka̱n motájto̱l. ");
INSERT INTO nhx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Iwá̱n iga mopode̱r maachitiaka̱n yej we̱titokej iwá̱n mamochi̱wa weyi mila̱grojmej ipan ito̱ka̱ꞌ moPiltzi̱n Jesús yej ayí̱ꞌ kichij yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kua̱ꞌ tamiꞌ ora̱dojkej, ompa ka̱n nechkatoyaj takuekuechkaꞌ; iwá̱n inochimej kipiayaj nokta el Espíritu Santo, iwá̱n ayꞌya majmawikej iga kipowaj itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nochi yej kicre̱dojkej toTe̱ko se̱san iya̱lmajmej kipiayaj. Ayagaj motatkinekiá tejté̱ yej kipiaya, ma̱jwaꞌ inewi yej kipiayaj, kijtowayaj iga nochi isentatkimej. ");
INSERT INTO nhx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Iwá̱n apo̱stolejmej kipowilijkej nochi gente iga toTe̱ko Jesús ojpa‑isaꞌ, iwá̱n kicre̱dojkej. Dios poxsan kipale̱wia̱yaj inochimej. ");
INSERT INTO nhx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ateyá ni agaj de yejeme̱n yej amakipiá tejté̱, iga inochimej yej kipiayaj ita̱lmej o ikalmej kinamakayaj, iwá̱n itomi̱nyo kiwi̱gayaj ");
INSERT INTO nhx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","iwá̱n kimakayaj apo̱stolejmej, iwá̱n yejemej kimajmakayaj nochi tokni̱wa̱n sanké̱ꞌ kipolowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ijkó̱n kichij se̱ levita yej ito̱ka̱ꞌ José, yej nace̱roj ipan tajkóta̱l yej ito̱ka̱ꞌ Chipre. Apo̱stolejmej kita̱lilijkej José seꞌ ito̱ka̱ꞌ, kito̱ka̱wijkej Bernabé, yej kijto̱jneki Yej Tayo̱lchika̱wa; ");
INSERT INTO nhx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","iní̱n ta̱gaꞌ kipiaya se̱ íta̱l iwá̱n kinamáꞌ, iwá̱n itomi̱nyo kika̱wili̱to apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Eꞌ se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Ananías iwá̱n Safira yej isiwa̱ꞌ, kinamakakej ita̱lmej. ");
INSERT INTO nhx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iní̱n ta̱gaꞌ kikuiꞌ achi inó̱n tomi̱n, iwá̱n achi kika̱wili̱toj apo̱stolejmej ken tikita acho̱nya nokta iga kinamakakej. Iwá̱n isiwa̱ꞌ nochi kimatiá. ");
INSERT INTO nhx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Iwá̱n Pedro kijtoj: —Ananías, ¿te iga kalaꞌ Tzitzimiꞌ ipan moa̱lmaj iwá̱n tikneꞌ xikajkaya̱wa el Espíritu Santo iga tikuiꞌ achi itomi̱nyo inó̱n ta̱jli yej tiknamáꞌ? ");
INSERT INTO nhx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ix ayéj motatki katka in ta̱jli? Iwá̱n siga tiknamáꞌ, ¿ix ayéj motatki no̱ in tomi̱n? ¿Te iga ijkó̱n tikchij? Ayéj nejemej anne̱kajkayajkej, Dio̱swaꞌ in tikneꞌ xikajkaya̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kua̱ꞌ inó̱n kikáꞌ Ananías, miktiwétziꞌya. Iwá̱n nochi yej kimatikej, poxsan majmawikej. ");
INSERT INTO nhx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Iwá̱n asikej sekin chokomej, kikimilojkej iga tzótzol iwá̱n yajkij kito̱katoj. ");
INSERT INTO nhx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Panoj ken e̱yi horas, kalakito isiwa̱ꞌ Ananías, yéj aya kimatiá iga míguiꞌya iwé̱j. ");
INSERT INTO nhx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pedro kitajtan: —Taꞌ xine‑ijli, ¿ix achó̱n iga ankinamakakej in amóta̱l ke̱ꞌ ankijtowaj? Iwá̱n siwa̱ꞌ kijtoj: —Kena, achó̱n. ");
INSERT INTO nhx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Iwá̱n Pedro kijlij: —¿Te iga anmotajto̱ltijkej iga ankinekikej xikajkaya̱waka̱n iyEspí̱ritoj toTe̱ko? Taꞌ xikita, ne̱ wi̱tzej yej kito̱kato̱yaj mowé̱j; iná̱n tej no̱ yawij mitzwi̱gatij. ");
INSERT INTO nhx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Iwá̱n íkua̱ꞌsan miktiwetziꞌ iyikxite̱noj Pedro. Kua̱ꞌ kalakkej chokomej kasitoj siwa̱ꞌ míktoꞌya, iwá̱n kiki̱xtijkej iwá̱n kito̱kkej ite̱noj iwé̱j. ");
INSERT INTO nhx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Iwá̱n inochimej yej kicre̱dojtoyaj Jesucristo iwá̱n nochi yej kimatikej yej mochij, poxsan majmawikej. ");
INSERT INTO nhx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Iga Dios kipale̱wij apo̱stolejmej, kichi̱wayaj miaꞌ mila̱grojmej iyi̱xtaj la gente. Inochi̱n yej kicre̱dowa̱yaj toTe̱ko monechkowa̱yaj weyitio̱pan, ite̱noj puerta yej ito̱ka̱ꞌ Salomón. ");
INSERT INTO nhx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ni agaj yej ayá̱ꞌ kicre̱dowa̱ya Jesucristo mi̱xe̱wia̱ya iga masen‑onoka̱n iwa̱mej, eꞌ la gente poxsan kiye̱ꞌitayaj ino̱mej tokni̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Yej kicre̱dowa̱yaj toTe̱ko, ma̱jya miakiayaj, tajta̱gaꞌ iwá̱n siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Este kiki̱xtiayaj ipan calle yej we̱titokej, kite̱kayaj ipan tapech iwá̱n ipan petaꞌ, iga kua̱ꞌ pano̱j Pedro, malej itó̱nal maasi ipan sekin de yejemej. ");
INSERT INTO nhx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Iwá̱n miaꞌ no̱ yej najna̱ꞌsan iya̱ltepe̱mej, ya̱yaj Jerusalén, kiwi̱gayaj iyenfe̱rmojmej iwá̱n yej kikno̱chijtoyaj ma̱lespi̱ritojmej iwá̱n nochi achitiakej. ");
INSERT INTO nhx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Iwá̱n ije̱fej sacerdo̱tejmej iwá̱n nochi saduceojmej yej íwa̱n onoyaj, ki̱xitayaj apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Iwá̱n kiki̱tzkijkej apo̱stolejmej iwá̱n kipre̱sojwijkej. ");
INSERT INTO nhx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Eꞌ se̱ iyá̱ngel toTe̱ko yajki tayowaka̱n kitapowili̱toj cárcel, iwá̱n kiki̱xtijkej, kijlijkej: ");
INSERT INTO nhx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Xa̱ka̱n, ximoketzatij weyitio̱pan iwá̱n xikta̱tapo̱wi̱tij la gente ken iga wel manejnemika̱n ipan iyojwi Dios. ");
INSERT INTO nhx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iga inó̱n kikakikej, ipan seꞌya día isájpasan kalakkej weyitio̱pan iwá̱n pe̱wakej tamachtijkej. Eꞌ ije̱fej sacerdo̱tejmej iwá̱n yej íwa̱n ompa onoyaj, kinechkojkej nochi yej kimanda̱rowaj israeli̱tajmej, iwá̱n tatekimakakej iga mamokuiti apo̱stolejmej ka̱nkiꞌ onokej ca̱rcelijtiꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kiti̱tankej policiyajmej yej tacuida̱rowaj weyitio̱pan. Eꞌ kua̱ꞌ asitoj ipan cárcel, akasíkejoꞌ, iwá̱n mokuepkej iga tamati̱lti̱toj. ");
INSERT INTO nhx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Kijtojkej: —Nikasitoj cárcel ye̱ꞌtzaktoꞌ iwá̱n ipan kalte̱n ejejkatokej policiyajmej. Eꞌ kua̱ꞌ niktapojkej, ompa ayagaj onoya. ");
INSERT INTO nhx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kua̱ꞌ inó̱n kikakikej ije̱fej sacerdo̱tejmej iwá̱n ije̱fej policiyajmej yej tacuida̱rowaj weyitio̱pan iwá̱n ino̱mej sacerdo̱tejmej yej no̱ manda̱rowaj, mojlia̱yaj: atikmatij ke̱man tamatis iní̱n. ");
INSERT INTO nhx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Íkua̱ꞌ asito se̱ ta̱gaꞌ iwá̱n kijtoj: —Tajta̱gaꞌ yej ankakijkaj ipan cárcel onókeja weyitio̱pan, némiya tamachtiáj. ");
INSERT INTO nhx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ije̱fej policiyajmej iwá̱n policiyajmej yej takuida̱rowaj, yajkij kikuitoj tamelá̱ iga kimajmawilia̱yaj la gente iga wel kitemiktiáj. ");
INSERT INTO nhx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kua̱ꞌ kaxiti̱toj, kiwi̱gakej iyi̱xtaj yej kimanda̱rowaj judiyojmej, iwá̱n ije̱fej sacerdo̱tejmej kijlij apo̱stolejmej: ");
INSERT INTO nhx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Nejeme̱n nimitzijlíjkeja iga ayoꞌ nokta xitamachti̱ka̱n yej kichij Jesús. ¿Iwá̱n te̱ ankichijkej? Amejeme̱n antamachtijtinénkeja no̱ya̱n Jerusalén iwá̱n ankinekij xine̱panti̱ka̱n iga nejemej nikmiktijkej inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Iwá̱n Pedro iwá̱n sekin apo̱stolejmej kijtojkej: —Má̱j ye̱kti manikchi̱waka̱n ken kijtowa Dios, que manikchi̱waka̱n ken kijtowaj tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","IDio̱s to‑ikyapatajwa̱n, ki‑ojpa‑ixitij Jesús; inó̱n yej ankiclava̱rojkej ipan se̱ cruz iga ankimiktijkej. ");
INSERT INTO nhx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios kiwi̱gaꞌ ajko iwá̱n kita̱lij ila̱doj iye̱ꞌma̱ꞌ, kita̱lij iga mamanda̱ro iwá̱n matasalva̱ro. Ijkó̱n israeli̱tajmej wel makikajte̱waka̱n iga ayompa nemij iga Dios makiperdona̱ro yejemej. ");
INSERT INTO nhx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Inó̱n nejemej niknojma‑itakej iwá̱n nimitzpowiliáj, iwá̱n no̱ mitzne̱xtiliáj el Espíritu Santo. Inó̱n Espíritu, Dios kimaka yejsan kichi̱wa ken yéj kijtowa. ");
INSERT INTO nhx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kua̱ꞌ inó̱n kikakikej, kuejkuesiwikej iwá̱n kinekiáj makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Iwá̱n ompa ka̱n nechkatoyaj yej manda̱rowaj onoya se̱ fariseo yej ito̱ka̱ꞌ Gamaliel yej tamachtiá ipan iley Moisés, inó̱n ta̱gaꞌ poxsan kiye̱ꞌitayaj. Moketzaꞌ iwá̱n kijtoj iga achi alí̱n maki̱saka̱n apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Iwá̱n Gamaliel kijlij yej manda̱rowaj: —Nokni̱wa̱n de Israel, cuidáj tejté̱ ankichi̱wiliáj ini̱mej tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xikejla̱mikika̱n ken ikya kichij Teudas, yéj kiyo̱lmakatoya iga mamanda̱ro. Iwá̱n kitokakej ken cuatrocientos tajta̱gaꞌ; eꞌ yéj kimiktíjkejsan, iwá̱n nochi yej kitokayaj pa̱payi̱nikej iwá̱n ompa nochi tamiꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Má̱j despué̱j, kua̱ꞌ nemi mocensa̱ro̱lo, Judas yej de Galilea poxsan miaꞌ kinechkoj yej kitokayaj; eꞌ yéj no̱ kimiktijkej, iwá̱n yej kitokayaj inochimej pa̱payi̱nikej. ");
INSERT INTO nhx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Inó̱n iga nimitzijliáj iga xikajte̱waka̱n ka̱ma manemika̱n ini̱mej tajta̱gaꞌ, amo te̱ xikchi̱wili̱ka̱n. Porque siga nemi kichi̱waj kensan yejeme̱n kinekij, yáwisan tamiti. ");
INSERT INTO nhx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Eꞌ siga kichi̱waj yej Dios kineki iga mamochi̱wa, amejeme̱n awel te̱ ankichi̱wili̱skej. Achi xitamajmawili̱ka̱n, amo santá̱ꞌ ankikuejkuesojtoskej Dios. ");
INSERT INTO nhx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Iwá̱n nochi kitajto̱lkui̱lij inó̱n ta̱gaꞌ. Iwá̱n kino̱tzkej apo̱stolejmej, kimagakej iwá̱n kitekimakakej iga ayoꞌ má̱j mata̱tapowaka̱n ipan ito̱ka̱ꞌ Jesús; iwá̱n kimajkajkej. ");
INSERT INTO nhx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Iwá̱n apo̱stolejmej kí̱skeja iyi̱xtaj yej manda̱rowaj, poxsan pa̱ktiajkij iga Dios kitaꞌ iga wel kijyo̱wiáj kua̱ꞌ kikno̱chijkej iga moconfia̱rojkej ipan Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Iwá̱n nochipa tamachtia̱yaj iwá̱n kipowayaj itájto̱l Jesucristo. Ya̱yaj ipan weyitio̱pan, iwá̱n no̱ tamachtijtinemiáj ipan kajlimej. ");
INSERT INTO nhx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Iwá̱n inó̱n ve̱j yej kitokaj Jesucristo nemi má̱j miakiayaj. Iwá̱n yej tajtowaj hebreo nochipa tamajmakayaj tákual. Iwá̱n yej tajtowaj griego mote̱lwijkej wa̱n yej tajtowaj hebreo. Kijtojkej iga kua̱ꞌ momajmakayaj tákual, ayá̱ꞌ kiye̱ꞌatende̱rowaj siwa̱tkej yej tajtowaj griego yej mikíkeja iwe̱wejmej. ");
INSERT INTO nhx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Iwá̱n ino̱mej doce apo̱stolejmej kinechkojkej nochi yej kitokaj Jesús iwá̱n kijtojkej: —Akajasi iga manikajte̱waka̱n iga nikpowaj itájto̱l Dios iga san tákual manikmajmakaka̱n tokni̱wa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Inó̱n iga nokni̱wa̱n, xiktapejpenaka̱n siete tajta̱gaꞌ yej ankitaj ye̱ꞌnemij, iwá̱n yej kimatij te̱ kichi̱waj, iwá̱n yej kipiáj nokta el Espíritu Santo iga yejeme̱n makichi̱waka̱n iní̱n tekipáno̱l. ");
INSERT INTO nhx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nejeme̱n nikte̱ne̱wijtoskej Dios, iwá̱n nitamachtijtoskej ipan itájto̱l. ");
INSERT INTO nhx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Iwá̱n nochi kiye̱ꞌitakej yej kijtojkej apo̱stolejmej. Iwá̱n kitapejpenkej Esteban, se̱ ta̱gaꞌ yej poxsan moconfia̱rowa̱ya ipan Dios, iwá̱n kipiaya nokta el Espíritu Santo. No̱ kitapejpenkej Felipe, Prócoro, Nicanor, Timón, Parmenas iwá̱n Nicolás de Antioquía yej ayéj judío, yéj íkyaya kicre̱doj ken iga tane̱xtilia̱yaj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Iwá̱n kiwi̱gakej ite̱noj apo̱stolejmej, yejemej kita̱lijkej ima̱mej ipan itzontekomej ino̱mej siete tokni̱mej iwá̱n ki‑ora̱dowilijkej. ");
INSERT INTO nhx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Iwá̱n itájto̱l Dios miaꞌya nemi kicre̱dowa̱ya, iwá̱n yej kitokaj Jesús poxsan miakiakej ompa Jerusalén. Este no̱ miaꞌ sacerdo̱tejmej yej judiyojmej kicre̱dojkej Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Dios kimáꞌ poder Esteban iga makichi̱wa mila̱grojmej iga la gente makicre̱do̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eꞌ sekin judiyojmej yej asij tio̱pan yej ito̱ka̱ꞌ “Escla̱vojmej yej ite̱komej kimajkájkeja”, iwá̱n sekin yej de Cirene, de Alejandría, de Cilicia, de Asia, pe̱wakej iga mote̱nki̱tzkiáj iwá̱n Esteban. ");
INSERT INTO nhx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Eꞌ awel kita̱nilijkej iga el Espíritu Santo kipale̱wij Esteban iga kimáꞌ tájto̱l yej ómpaya nokta ken kijtoj. ");
INSERT INTO nhx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Iwá̱n ino̱mej kixta̱wakej sekin iga makijto̱ka̱n iga Esteban ma̱ltajtowa iga iley Moisés, iwá̱n ma̱ltajtowa iga Dios. ");
INSERT INTO nhx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ijkó̱n kichijkej iga makuejkuesiwika̱n la gente iwá̱n nochi we̱wetkej yej manda̱rowaj iwá̱n yej tamachtiáj ipan la ley iwá̱n ki‑o̱nkawijkej Esteban; kiki̱tzkijkej iwá̱n kiwi̱gakej iyi̱xtaj ka̱n monechkowaj yej kimanda̱rowaj nochi judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Iwá̱n no̱ kite̱mojkej yej tapantiáj, kijtojkej: —Iní̱n ta̱gaꞌ atami iga ma̱ltajtowa iga iní̱n toweyitio̱pan ka̱n moweyimati Dios, iwá̱n tajtowa ico̱ntraj iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nikakikej kijtojtoꞌ iga Jesús de Nazaret yawi kixiti̱nati iní̱n weyitio̱pan iwá̱n yawi kipatati ken tiktekichi̱waj ken Moisés te̱ne̱xtilij iga matikchi̱waka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Yej manda̱rowaj iwá̱n nochi yej ompa e̱watoyaj, kua̱ꞌ kitachi̱lijkej Esteban, kitakej iga ixa̱yaꞌ kenya se̱ ángel. ");
INSERT INTO nhx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ije̱fej sacerdo̱tejmej ijkí̱n kitajtan Esteban: —¿Ix melá̱ꞌ iga ijkó̱n? ");
INSERT INTO nhx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Iwá̱n yéj kijtoj: —Nokni̱wa̱n iwá̱n annotajwe̱wetkej, xine̱kakika̱n yej nia nimitzijli̱tij. Inó̱n toDio̱s yej nochi wel kichi̱wa, ki̱xne̱xtilij to‑ikyapatajwe̱wej Abraham kua̱ꞌ onoya ipan ta̱jli yej ito̱ka̱ꞌ Mesopotamia, kua̱ꞌ aya yawi mocha̱nti̱ti a̱ltepe̱ꞌ Harán. ");
INSERT INTO nhx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Iwá̱n Dios kijlij: “Xikajte̱wa móta̱l iwá̱n mokni̱wa̱n iwá̱n xaj ipan inó̱n ta̱jli yej nej nia nimitzne̱xtili̱ti.” ");
INSERT INTO nhx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Iwá̱n Abraham ki̱saꞌ pan país yej ito̱ka̱ꞌ Caldea iwá̱n yajki mocha̱nti̱to a̱ltepe̱ꞌ Harán. Kua̱ꞌ Abraham miꞌyaꞌ itaj, Dios sej kiki̱xtij ompa iwá̱n kiwajli̱ꞌ ka̱n iná̱n amejeme̱n ancha̱ntitokej. ");
INSERT INTO nhx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Eꞌ ayá̱ꞌ kimáꞌ íta̱l yej ma‑itátkipay; ni alí̱n nokta ayá̱ꞌ kimáꞌ ka̱n wel mataksa. Eꞌ Dios kijlij iga yawi kimakati yej mochi̱was itatki, iwá̱n kua̱ꞌ míkisya, ka̱wis iga ipilowa̱n ipilówa̱mpa, malej íkua̱ꞌ Abraham aya kipiaya ipilowa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Iwá̱n Dios kijlij iga yej ipilowa̱n ipilówa̱mpa ya̱tij mocha̱nti̱tij ipan seꞌ ta̱jli yej ayéj itatkimej. Ompa yawij onotij iga escla̱vojmej iwá̱n kikno̱chi̱toskej cuatrocientos años. ");
INSERT INTO nhx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Iwá̱n Dios no̱ kijlij: “Nej nia nicastiga̱ro̱ti yej mitzescla̱vojtili̱skej. Iwá̱n mopilowa̱n ipilówa̱mpa yawij ki̱satij ompa, iwá̱n wi̱tzej ne̱weyimati̱lti̱kij nigaj.” ");
INSERT INTO nhx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Dios motajto̱ltij iwá̱n Abraham, kimáꞌ inó̱n costumbre yej mojliá circuncisión iga mane̱si iga motajto̱ltij íwa̱n. Inó̱n iga kua̱ꞌ Isaac kipiaya ocho días iga nace̱roj, Abraham kicircuncida̱roj, iwá̱n ijko̱nsan no̱ kichij Isaac iwá̱n ipiltzi̱n yej ito̱ka̱ꞌ Jacob. Iwá̱n ijko̱nsan no̱ kichij Jacob iwá̱n ipilowa̱n, ino̱mej doce ipilowa̱n yej mochijkej iga te̱tajmej ipan nación de Israel. ");
INSERT INTO nhx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Ino̱mej ipilowa̱n Jacob yej yajkij to‑ikyapatajwa̱n kijiyakej itzo̱yo̱mej yej ito̱ka̱ꞌ José, iwá̱n kinamakakej, iwá̱n ino̱mej yej takojkej kiwi̱gakej Egipto. Eꞌ Dios onoya iwá̱n José ");
INSERT INTO nhx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","wa̱n kima̱nawij kua̱ꞌ kikno̱chi̱wayaj. Dios kine̱xtilij ken wel makichi̱wa iga wel makiye̱ꞌita Faraón el rey de Egipto. Inó̱n iga Faraón kita̱lij José iga mamochi̱wa gobernador ipan Egipto iwá̱n no̱ manda̱rowa̱ya cha̱n Faraón. ");
INSERT INTO nhx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Iwá̱n poxsan a̱pistajtiáꞌ iwá̱n tayo̱koyayaj no̱ya̱n ipan íta̱l Egipto iwá̱n Canaán, wa̱n totajwa̱n akasiajoꞌ te̱ kikua̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kua̱ꞌ Jacob kimatiꞌ iga Egipto onoꞌ trigo, kiti̱tan ipilowa̱n yej to‑ikyapatajwa̱n matakowatij. Ijkó̱n iga achto ve̱j yajkij Egipto. ");
INSERT INTO nhx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Entonces kua̱ꞌ seꞌ ve̱j yajkij yejeme̱n, José mote̱nxítonya iyi̱xtaj iyikni̱wa̱n, wa̱n íkua̱ꞌya el rey Faraón kimatiꞌ katiapa itaj wa̱n iyikni̱mej José. ");
INSERT INTO nhx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Iwá̱n José tati̱tan makikuitij Jacob yej ítajpa iwá̱n inochi iyikni̱wa̱n; iga inochimej masiꞌ setenta y cinco. ");
INSERT INTO nhx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ijkó̱n iga Jacob yajki mocha̱nti̱to Egipto iwá̱n ompa miguiꞌ, iwá̱n ompa mikikej no̱ ipilowa̱n yej to‑ikyapatajwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Iwá̱n iyomiyomej Jacob kiwi̱gakej ipan ta̱jli yej ito̱ka̱ꞌ Siquem, iwá̱n kito̱kakej ipan a̱nimajtexapoꞌ yej Abraham kikowilij ipilowa̱n Hamor. ");
INSERT INTO nhx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Kua̱ꞌ ayoꞌ wejka iga mochi̱was yej Dios kijlij Abraham iga yawi kichi̱wati nokta, judiyojmej poxsan pi̱wikej Egipto. ");
INSERT INTO nhx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ompa Egipto pe̱ꞌ manda̱roj seꞌ rey yej aki̱xmatiá José. ");
INSERT INTO nhx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Iní̱n rey kikajkayaj totajwa̱n iwá̱n kikno̱chijkej, kitekimakakej iga makisenkokajte̱waka̱n seliꞌ choolili̱n iga mamijmikika̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Íkua̱ꞌ nace̱roj Moisés. Yéj kua̱ꞌ séligoꞌ, Dios poxsan kiye̱ꞌitaꞌ. Itaj iwá̱n iye̱ꞌ kiskaltijkej e̱yi mes ompa icha̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kua̱ꞌ tatekimakakej iga kikajtéjkeja ise̱lti iga mamiki, isiwa̱piltzi̱n el rey de Egipto kasiꞌ iwá̱n kiskaltij ken ipiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Inó̱n iga Moisés momachtij ken momachtiáj egi̱pciojmej. Yéj manda̱rowa̱ya poxsan iwá̱n nochi ken tatekimakaya mochi̱waya. ");
INSERT INTO nhx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Kua̱ꞌ kipiaya cuarenta años, Moisés yajki kipaxa̱lowili̱to iyikni̱wa̱n, ino̱mej yej de Israel. ");
INSERT INTO nhx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ompa kitaꞌ se̱ egipcio kimagatoya se̱ yej iyikní̱mejpa. Iwá̱n kima̱nawi̱to iwá̱n kimiktij inó̱n egipcio yej tamagatoya. ");
INSERT INTO nhx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Yéj kijtoj anka iyikni̱wa̱n kimatiskej iga Dios kiti̱tan iga makima̱nawi̱ka̱n, eꞌ yejeme̱n ayá̱ꞌ kimatikej. ");
INSERT INTO nhx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Iwá̱n ipan seꞌya día, Moisés kasito o̱me̱n israelita nemi momagaj, iwá̱n kitaka̱waltia̱yaj, kijlijkej: “¿Te iga anmomagaj? Esi de amejéme̱mpasan.” ");
INSERT INTO nhx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kua̱ꞌ kikáꞌ inó̱n yej tamagatoya, este kiyagatopej Moisés, kijlij: “Tej ayagaj mitzta̱lij iga tije̱fej o tijue̱z iga xine̱taka̱wa̱lti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ix tikneki no̱ xine̱mikti ken ya̱lwa tikmiktij inó̱n egipcio?” ");
INSERT INTO nhx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kua̱ꞌ Moisés inó̱n kikáꞌ, choloj iwá̱n yajki mocha̱nti̱to ipan ta̱jli yej ito̱ka̱ꞌ Madián. Ompa onoya ken yej wejkacha̱nej iwá̱n kipiáꞌ o̱me̱n ipilowa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Kua̱ꞌ pánoja cuarenta años, Moisés onoya ipan desierto iná̱ꞌ tepe̱ꞌ yej ito̱ka̱ꞌ Sinaí. Ompa ki̱xne̱xtilij se̱ ángel ipan se̱ witztako̱ꞌ yej we̱welo̱ntoya. ");
INSERT INTO nhx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés momajtij iga inó̱n yej kitztoya, iwá̱n kua̱ꞌ kitechoj iga makiye̱ꞌita, kikáꞌ itájto̱l toTe̱ko, kijlij: ");
INSERT INTO nhx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Nej yej iDio̱spa amo‑ikyapatajwe̱wetkej, Abraham, Isaac, iwá̱n Jacob.” Iwá̱n Moisés kuekuechkatoya iga majmawiá, iwá̱n ayoꞌ mi̱xe̱wia̱ya iga kitachi̱lia̱ya. ");
INSERT INTO nhx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Iwá̱n toTe̱ko kijlij: “Xiki̱xti mogaꞌ yej tikakijtoꞌ, porque nij ka̱n titaksatoꞌ, nej nonoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nikitztoꞌ ken iga kikno̱chi̱waj noge̱ntej yej onokej Egipto, nikaki iga este tejtenaj. Inó̱n íga niwa̱laj iga nikma̱nawi̱koj. Iná̱n xiwi̱ki iga nia sej nimitzti̱taniti Egipto.” ");
INSERT INTO nhx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Malej iga yejeme̱n kima̱lijlijkej Moisés, kua̱ꞌ kijlijkej: “¿A̱ꞌyéj mitzta̱lij iga tije̱fej o tijue̱z?” Eꞌ Dios kiti̱tan ken jefe iga makima̱nawi̱ti ige̱ntej. Kiti̱tan iyá̱ngel maki̱xne̱xtili̱ti Moisés ipan witztako̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moise̱swaꞌ in yej kiki̱xtij Egipto to‑ikyapatajwa̱n. Yéj kichij milagro ompiga Egipto iwá̱n ipan inó̱n Chi̱ltiꞌ láma̱r iwá̱n ipan desierto ka̱n nemiáj cuarenta años. ");
INSERT INTO nhx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ino̱nsan Moisés kijlij israeli̱tajmej: “Dios yawi mitzti̱tanili̱tij se̱ profeta yej de amejéme̱mpasan, ken nej ne̱ti̱tan. Xikakika̱n yej yéj mitzijliáj.” ");
INSERT INTO nhx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Iní̱n Moisés yej onoya iwá̱n la gente ompiga ipan desierto, iwá̱n el ángel yej kino̱tzaꞌ ipan tepe̱ꞌ Sinaí. Iwá̱n onoya wa̱n to‑ikyapatajwa̱n, Moisés yej kimakakej itájto̱l yej tamaka vida iga tejemej sej mate̱makaka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Eꞌ ino̱mej totajwa̱n ayá̱ꞌ kinekikej makichi̱waka̱n ken kijtowa, ma̱jwaꞌ kinekiáj sej mamokuepaka̱n Egipto. ");
INSERT INTO nhx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Iwá̱n kijlijkej Aarón: “Niknekij xine̱chi̱wili̱ka̱n dio̱smej iga mateojkui̱ltijtia̱ka̱n tejemej. Porque atikmatij te̱ kichij inó̱n Moisés yej te̱ki̱xtij Egipto.” ");
INSERT INTO nhx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Iwá̱n kichijkej ken se̱ to̱rojtzi̱n iga idio̱smej iga makiweyimati̱lti̱ka̱n, iwá̱n kikuikej miaꞌ yo̱lka̱mej iga kimiktilijkej teposto̱rojtzin iwá̱n yejeme̱n pa̱kikej iga kichijkej inó̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Iwá̱n Dios kikajtej yejeme̱n, kisemakákeja iga makiweyimati̱lti̱ka̱n si̱talimej. Ijkí̱n ijkuilijtoꞌ ipan ili̱broj profe̱tajmej: Amejeme̱n de Israel, ¿ix amejeme̱n ankimiktijkej yo̱lka̱mej iga anne̱makakej ofrenda kua̱ꞌ amonoyaj ipan desierto cuarenta años? ");
INSERT INTO nhx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","¡Ayá̱ꞌ! Ma̱jwaꞌ ankinentia̱yaj ikuetaxtio̱pan dios Moloc, iwá̱n ankinentia̱yaj si̱talin yej kijliáj dios Renfán. Ino̱mej imágenes yej amejéme̱nsan ankichijkej iga xikweyimati̱lti̱ka̱n. Inó̱n iga niawij nimitzki̱xti̱tij ka̱n amonokej; nimitzwi̱gaskej este iyi̱ka̱mpa país de Babilonia. ");
INSERT INTO nhx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Ipan desierto to‑ikyapatajwa̱n kipiayaj se̱ kuetaxtio̱pan ka̱n ka̱nayaj inó̱n o̱me patachteꞌti ka̱n ijkuilijtoya la ley. Inó̱n kuetaxtio̱pan kichij Moisés kensan Dios kine̱xtilij iga makichi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","To‑ikyapatajwa̱n kimakakej inó̱n kuetaxtio̱pan ipilowa̱n iwá̱n kaxitijkej este nigaj. Senwa̱lkej iwá̱n Josué iga kita̱lkui̱li̱koj seꞌ gente yej nigaj cha̱ntitoyaj. Ino̱mej gente Dios kiki̱xtij iga kimakakej íta̱l totajwa̱n. Ijko̱nya iga ka̱wiko inó̱n kuetaxtio̱pan este iga manda̱roj el rey David. ");
INSERT INTO nhx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dios poxsan kiye̱ꞌitaꞌ el rey David iwá̱n yéj kineꞌ makichi̱wili se̱ íkal Dios yej iDio̱spa Jacob, ka̱n wel maono. ");
INSERT INTO nhx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Eꞌ rey Salomón in yej kichij Dios íkal. ");
INSERT INTO nhx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Malej iga Dios yej kipoxpiá poder, ayá̱ꞌ mocha̱ntiá ipan tio̱pamej yej kima̱chí̱wajpa tajta̱gaꞌ. Ken kijtoj se̱ profeta: ");
INSERT INTO nhx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ipan cielo nimota̱liá iga nimanda̱rowa, iwá̱n ipan ta̱jli nimokxitetoniá. ¿Katiábapa nókal ne̱chi̱wili̱skej? ¿Ka̱n wel nimose̱wi̱j?, kijtowa toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ixtaj ayéj nej nikchij iga noma̱ꞌ nochi yej onoꞌ? ");
INSERT INTO nhx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Esteban kíjtojoꞌ no̱: —Eꞌ amejeme̱n nochipa anyo̱ltakuaktikej, amonakas iwá̱n amoa̱lmaj ken yej ayá̱ꞌ ki̱xmatij Dios. Nochipa ankichi̱waj yej ayá̱ꞌ kineki el Espíritu Santo. Amejeme̱n kensan amo‑ikyapatajwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Amo‑ikyapatajwa̱n kikno̱chijkej nochi profe̱tajmej, este kimijmiktijkej yej kijtojkej iga yawi wi̱tzeti Cristo, yej ye̱ꞌnemi. Iwá̱n kua̱ꞌ wa̱laj, amejéme̱nsan sej ankentrega̱rojkej iwá̱n ankimiktijkej. ");
INSERT INTO nhx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Malej iga a̱ngelejmej mitzmakakej iley Dios, eꞌ amejeme̱n ayá̱ꞌ ankichijkej ken kijtowa. ");
INSERT INTO nhx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kua̱ꞌ kikakikej yej kijtojtoya Esteban, poxsan kuejkuesiwikej este kigueguetzekaltijkej itamej iga kijiyaj Esteban. ");
INSERT INTO nhx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Eꞌ yéj kimelaꞌpiaya el Espíritu Santo, ajkotacháꞌ ipan cielo iwá̱n kitaꞌ ka̱n Dios ta̱wijtoꞌ, wa̱n kitaꞌ ompa ejkatoꞌ Jesús ila̱doj iye̱ꞌma̱ꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Iwá̱n kijtoj: —¡Taꞌ xikitaka̱n! Nikitztoꞌ tapojtoꞌ cielo, iwá̱n ompa onoꞌ Jesús ila̱doj iye̱ꞌma̱ꞌ Dios. ");
INSERT INTO nhx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Eꞌ yejemej monajnagastzakkej iga ima̱mej, tzajtzikej iwá̱n kisempo̱lojkej Esteban. ");
INSERT INTO nhx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Kiwawatatzojtiki̱xtijkej ipan a̱ltepe̱ꞌ iga kitemikti̱toj. Iwá̱n ino̱mej yej nemi tatemiktiáj kika̱wato̱yaj isota̱ntzotzolmej iyikxite̱noj se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Saulo iga makicuida̱rowili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mie̱j nemi kitemiktiáj, Esteban kite̱ne̱wij Dios, kijtoj: —NoTe̱ko Jesús, xiko̱mema̱wi noespí̱ritoj. ");
INSERT INTO nhx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Iwá̱n motankua̱ketzaꞌ, iwá̱n tajtoj recio, kijtoj: —NoTe̱ko, amo xikwelkui̱li yej aye̱kti yej nemi ne̱chi̱wiliáj. Kua̱ꞌ tamiꞌ inó̱n kijtoj, míguiꞌya. ");
INSERT INTO nhx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo kiye̱ꞌitaꞌ iga kimiktijkej Esteban. Ino̱nsan día pe̱wakej iga paré̱j kite̱mojkej iga kikno̱chi̱waj yej kicre̱dojtokej Jesús yej icha̱mej Jerusalén. Nochi pa̱payi̱nikej, onoꞌ yej yajki ipan íta̱l Judea iwá̱n Samaria. Apo̱stoléjmejsan kajkej Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Sekin tajta̱gaꞌ yej kicre̱dojtokej Dios, kito̱kkej Esteban, iwá̱n poxsan cho̱kakej. ");
INSERT INTO nhx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Iwá̱n Saulo kikno̱chi̱wa̱ya yej kicre̱dojtokej Jesús, kalakiá ipan sejsé̱ kajli iga kiwawatatzojtiki̱xtia̱ya tajta̱gaꞌ iwá̱n siwa̱tkej iwá̱n kiwi̱gayaj preso. ");
INSERT INTO nhx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Eꞌ yej cholojkej Jerusalén, no̱ya̱n san ka̱n yajkij kipowayaj itájto̱l Dios yej tasalva̱rowa, ");
INSERT INTO nhx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Se̱ de yejeme̱n yej ito̱ka̱ꞌ Felipe, yajki se̱ a̱ltepe̱ꞌ yej onoꞌ ipan íta̱l Samaria, iwá̱n ompa pe̱waꞌ kipowaꞌ itájto̱l Cristo. ");
INSERT INTO nhx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ompa monechko̱lowa̱ya iwá̱n nochi kikakiáj yej kijtowa̱ya Felipe, iwá̱n no̱ kitayaj iga kichi̱waya milagro. ");
INSERT INTO nhx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Miaꞌ yej kipiaya ma̱lespí̱ritoj achitiakej, iwá̱n ma̱lespi̱ritojmej kua̱ꞌ ki̱sayaj ipan ino̱mej este tzajtzitiki̱sayaj. Iwá̱n no̱ achitiakej yej takua̱wayaxtoyaj iwá̱n yej ko̱xomej. ");
INSERT INTO nhx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Inó̱n iga poxsan pa̱ktoyaj ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Eꞌ onoya no̱ se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Simón yej motamatiliá iwá̱n kikajkayajtoya la gente de Samaria, kinekiá iga makita la gente iga yéj ayéj ná̱mo̱l. ");
INSERT INTO nhx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Kitajto̱lkakiá yej má̱j aya yo̱lej este yej má̱j yó̱leja, kijtowa̱yaj: —Iní̱n Simón kinentiá nokta iweyipode̱r Dios. ");
INSERT INTO nhx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kitajto̱lkui̱lia̱yaj iga inó̱n itamatilis, íkyaya kikajkayajtokej. ");
INSERT INTO nhx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Eꞌ kua̱ꞌ kicre̱dojkej inó̱n ye̱ꞌnoti̱ciaj yej Felipe kipowaꞌ ken iga reina̱rowa Dios, iwá̱n iga mamosalva̱ro̱ka̱n ipan ito̱ka̱ꞌ Jesucristo, mobautiza̱rojkej tajta̱gaꞌ iwá̱n siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Kicre̱doj no̱ inó̱n Simón, iwá̱n mobautiza̱roj, iwá̱n kitokatinemiáy Felipe, madmira̱dojtoya iga kitaya iga kichi̱waya milagros. ");
INSERT INTO nhx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kua̱ꞌ apo̱stolejmej yej onoyaj Jerusalén kimatikej iga yej icha̱mej Samaria kicre̱dójkeja itájto̱l Dios, kiti̱tankej maya̱ka̱n ompiga Pedro iwá̱n Juan. ");
INSERT INTO nhx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Asitoj ompiga, ora̱dojkej iga ino̱mej yej kicre̱dojkej Jesús iga makipiaka̱n el Espíritu Santo. ");
INSERT INTO nhx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Porque aya wi̱tziá iyEspí̱ritoj Dios niga ipan se̱ de yejéme̱mpa, onóyajsan bautizado ipan ito̱ka̱ꞌ toTe̱ko Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Iwá̱n Pedro iwá̱n Juan kita̱lkej ima̱mej ipan ino̱mej, iwá̱n ino̱mej kipiákeja iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kua̱ꞌ Simón kitaꞌ iga wa̱laj iyEspí̱ritoj Dios iga apo̱stolejmej kita̱líjkejsan ima̱mej ipan ino̱mej, Simón kinekiá makixta̱wa apo̱stolejmej; ");
INSERT INTO nhx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","kijtoj: —Xine̱makaka̱n no̱ inó̱n poder iga a̱ꞌsan ípan manikta̱lili noma̱ꞌ makipiá no̱ iyEspí̱ritoj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Iwá̱n Pedro kijlij: —Ximiki wa̱n motomi̱n iga tikowasneki imako̱ka Dios. ");
INSERT INTO nhx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tej ayá̱ꞌ mitzajasi iga xikpiá; iyi̱xtaj Dios tej tikchijtoꞌ yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xikajté̱waya iga tikchi̱wa yej aye̱kti, iwá̱n xiktajtanili Dios siga wel mitze̱lka̱wili̱j inó̱n yej tikejla̱n ipan moa̱lmaj. ");
INSERT INTO nhx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nimitzita iga ipan moa̱lmaj titapox‑i̱xita, iwá̱n tikchijtoꞌ yej aye̱kti, inó̱n kenkua̱ꞌ mitzilpitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Iwá̱n kijtoj Simón: —Amejeme̱n xikte̱ne̱wi̱ka̱n Dios iga nej iga amo mamochi̱wa inó̱n yej anne‑ijlijkej. ");
INSERT INTO nhx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Kua̱ꞌ apo̱stolejmej tamiꞌ ta̱tapowakej ipan itájto̱l Dios, mokuepkej Jerusalén. Ipan ojti kipojtiwa̱lkej ye̱ꞌnoti̱ciaj ipan miaꞌ a̱ltepe̱tzitzi̱n yej onokej ipan íta̱l Samaria. ");
INSERT INTO nhx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Después se̱ iyá̱ngel toTe̱ko kijlij Felipe: —Ximoketza, iwá̱n xaj taníbapa ipan ojti yej ki̱sa Jerusalén iwá̱n yawi a̱ltepe̱ꞌ Gaza. Inó̱n ojti panowa ipan desierto. ");
INSERT INTO nhx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ijkó̱n Felipe moketzaꞌ wa̱n yajki ompiga; iwá̱n ipan ojti masiꞌ iwá̱n se̱ ta̱gaꞌ yej icha̱n ipan ta̱jli Etiopía. Inó̱n ta̱gaꞌ poxsan tayaka̱ntoya, yéj ke̱nilijtoya itomi̱n la reina de Etiopía yej ito̱ka̱ꞌ Candace. Inó̱n ta̱gaꞌ yajka Jerusalén iga kiweyimati̱lti̱to̱ya Dios. ");
INSERT INTO nhx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Inó̱n ta̱gaꞌ némiya ya̱ya ícha̱n; e̱watia̱ya ipan ikuacarre̱taj, kilee̱rojtia̱ya inó̱n libro yej kijkuiloj el profeta Isaías. ");
INSERT INTO nhx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","IyEspí̱ritoj Dios kijlij Felipe: —Xiktecho inó̱n kuacarre̱taj iwá̱n xisenyawi ite̱noj. ");
INSERT INTO nhx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Kua̱ꞌ Felipe kitechoj, kikáꞌ iga kilee̱rojtia̱ya inó̱n libro yej kijkuiloj Isaías, iwá̱n kitajtan: —¿Ix tikmati te̱ kijto̱jneki in yej tiklee̱rojtiá? ");
INSERT INTO nhx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Iwá̱n kijtoj inó̱n ta̱gaꞌ: —¿Kén nia nikmatiti si ayagaj ne‑ijliá te̱ kijto̱jneki? Iwá̱n kijlij Felipe iga matejkawi iga mamota̱li ite̱noj. ");
INSERT INTO nhx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ka̱n kilee̱rojtia̱ya ijkí̱n ijkuilijtoꞌ: Kiwi̱gakej kimikti̱toj ken se̱ borrego; iwá̱n ken borre̱gojtzi̱n kua̱ꞌ kitejtekiliáj itzojmiyo, atzajtzi, ijko̱nsan yéj no̱ atajtoj. ");
INSERT INTO nhx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kali̱mpamatikej, ayá̱ꞌ kitajto̱lkui̱lij yej kijuzga̱rowa. ¿Iwá̱n a̱ꞌ tajtowa iga ipilowa̱n?, iga kimiktijkej ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Iwá̱n inó̱n ta̱gaꞌ de Etiopía kitajtan Felipe: —Achi xine‑ijli de a̱ꞌyéj tajtowa iní̱n profeta. ¿Ix iga yéjsan o iga sewoꞌ? ");
INSERT INTO nhx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Iwá̱n Felipe pe̱waꞌ tajtoj de inó̱n yej kilee̱rojtia̱ya inó̱n ta̱gaꞌ de Etiopía, iwá̱n kipowilij ye̱ꞌnoti̱ciaj de Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ka̱n nemi yawij, asitoj ka̱n onoꞌ a̱ꞌti. Kijtoj inó̱n ta̱gaꞌ: —Nij onoꞌ a̱ꞌti; ¿ix awel tine̱bautiza̱ro̱j? ");
INSERT INTO nhx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe kijtoj: —Siga tikmelaꞌcre̱dowa iga inewi moa̱lmaj, wel. Iwá̱n kijtoj: —Nicre̱dowa iga Jesucristo iPiltzi̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Iwá̱n kiketzaltij ikuacarre̱taj; iwá̱n iyo̱mextimej yajkij a‑ijtiꞌ. Iwá̱n ómpaya Felipe kibautiza̱roj inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kua̱ꞌ kí̱skeja a‑ijtiꞌ, iyEspí̱ritoj toTe̱ko kiwi̱gaꞌ Felipe. Inó̱n ta̱gaꞌ ayoꞌ má̱j kitaꞌ Felipe; eꞌ ta̱gaꞌ kikuiꞌ iyojwi este pa̱ktiajki. ");
INSERT INTO nhx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe asito sej este ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Azoto, iwá̱n pano̱tiajki ipan sejsé̱ a̱ltepe̱ꞌ iga kipojtinemiꞌ ye̱ꞌnoti̱ciaj de Jesús este que asiꞌ a̱ltepe̱ꞌ Cesarea. ");
INSERT INTO nhx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulo kijtojtóyasan iga yawi kimikti̱ti yej kitokaj Jesús. Inó̱n iga yajki kitato ije̱fej sacerdo̱tejmej, ");
INSERT INTO nhx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","kitajtanito a̱mamej ka̱n makijto iga yejemej kitekimakaj iga mayawi Damasco iga makite̱mo̱ti ipan itio̱pamej judiyojmej yejsan kitokaj iyojwi Jesucristo. San a̱ꞌ casis, kiwi̱gas preso este Jerusalén, tajta̱gaꞌ o siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eꞌ kua̱ꞌ nemi ya̱ya ipan ojti iga asitia̱yay Damasco, wa̱laj ipan cielo se̱ tiꞌti yej kiwe̱jta̱wi̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo wetziꞌ este ta̱lpan, kikáꞌ a̱ꞌpa ijkí̱n kijlij: —Saulo, Saulo, ¿te iga tine‑ikno̱chi̱wa? ");
INSERT INTO nhx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo kijtoj: —¿A̱ꞌyejtaj in tej? Iwá̱n kijlij: —Nej niJesús. Nejwaꞌ in yej nemi tine‑ikno̱chi̱wa. Iga ijkó̱n tikchi̱wa, tejsan moma̱tika nemi timo‑ikno̱chi̱wa, ken kua̱ꞌ se̱ toro kitiliksa ipu̱ntaj kuawiꞌ yej iga momajmajtiá. ");
INSERT INTO nhx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Iwá̱n Saulo este kuekuechkaꞌ iga majmawi, kijlij: —NoTe̱ko, ¿te̱taj tikneki manikchi̱wa? ToTe̱ko kijlij: —Ximokétzaya, xaj Damasco. Ompiga yawij mitzijli̱tij te̱ tia tikchi̱wati. ");
INSERT INTO nhx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ino̱mej tajta̱gaꞌ yej nemi ya̱yaj iwá̱n Saulo pox momajtijtikajkej iga kikakikej a̱ꞌpa tajtoj, eꞌ akitakej ni agaj. ");
INSERT INTO nhx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Iwá̱n Saulo moketzaꞌ ka̱n wetztoya, kua̱ꞌ mi̱xtapoj, ayoꞌ wel tachaya. Iwá̱n kima̱wila̱ntiajkij. Ijkó̱n kaxiti̱toj Damasco. ");
INSERT INTO nhx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ompa onoya e̱yi día, awel tachaya, atakuaj niga konij nité̱. ");
INSERT INTO nhx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ompa Damasco onoya se̱ yej ito̱ka̱ꞌ Ananías yej kitoka Jesucristo, wa̱n toTe̱ko ki̱xne̱xtilij, kijlij: —¡Ananías! Iwá̱n yéj kijlij: —Nigaj nonoꞌ noTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Iwá̱n toTe̱ko kijlij: —Xi‑ójkuiya, xaj ipan calle yej ito̱ka̱ꞌ Melaktiꞌ. Ompa cha̱n Judas, xikte̱mo̱ti se̱ de Tarso yej ito̱ka̱ꞌ Saulo, yéj iná̱n nemi ne̱te̱ne̱wiá. ");
INSERT INTO nhx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Niki̱xne̱xtílija iga kalakito se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Ananías iwá̱n kita̱lilij ima̱ꞌ iga sej matachá. ");
INSERT INTO nhx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Kua̱ꞌ inó̱n kikáꞌ Ananías, kite̱nkuepilij: —NoTe̱ko, eꞌ inó̱n ta̱gaꞌ, miaꞌ tokni̱mej ne‑ijlijkej kén iga yéj poxsan kikno̱chij ino̱mej yej Jerusalén mitztokaj. ");
INSERT INTO nhx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Iwá̱n iná̱n wa̱laj no̱ este nigaj. Este kiwajli̱ꞌ se̱ a̱maꞌ ka̱n ije̱fej sacerdo̱tejmej kitekimáꞌ iga wel makiwi̱gaka̱n preso yej mitzweyimati̱ltiáj. ");
INSERT INTO nhx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Eꞌ toTe̱ko, kijlij: —Xaja, iga yéj niktapejpen iga makipowa notájto̱l. Makipowili̱ti yej ayéj de Israel iwá̱n irre̱yejmej, iwá̱n no̱ yej de Israel. ");
INSERT INTO nhx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nej nia nikne̱xtili̱ti iga yéj yawij poxsan kikno̱chi̱watij iga ne̱toka. ");
INSERT INTO nhx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Iwá̱n Ananías yajki ipan inó̱n kajli ka̱n onoya Saulo. Kua̱ꞌ kalaꞌ, kita̱lilij ima̱ꞌ, iwá̱n kijlij: —Saulo, tinokni̱n, toTe̱ko Jesús yej mitzi̱xne̱xtilij ipan ojti ka̱n nemi tiwi̱tziá, ne̱ti̱tan iga wel sej xitachá, no̱ iga xikpiaya el Espíritu Santo. ");
INSERT INTO nhx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Íkua̱ꞌsan kojkopé̱ꞌ ipan iyi̱xmej tejté̱ ken to̱poj iyajwayo; ijkó̱n iga welya sej tacháꞌ. Iwá̱n yajki mobautiza̱ro̱to; ");
INSERT INTO nhx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","tamiꞌ inó̱n, takuaj wa̱n kikuiꞌ sej itájpal. Iwá̱n acho̱ꞌ ompa ka̱wiꞌ wa̱n tokni̱wa̱n yej kitokaj Jesucristo yej icha̱mej Damasco. ");
INSERT INTO nhx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Íkua̱ꞌsan pe̱waꞌ iga kipowa itájto̱l Jesucristo ipan itio̱pamej judiyojmej, kijtojtinemiá iga Jesús, Dios nokta iPiltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Iwá̱n nochi yej kikaktoyaj madmira̱dowa̱yaj, kijtowa̱yaj: —¿Ix ayejtaj iní̱n ta̱gaꞌ yej Jerusalén kite̱mojtinemiá iga makikno̱chi̱wa yej kite̱ne̱wiáj ito̱ka̱ꞌ Jesús? ¿Ix ayéj yejsan no̱ yej wa̱laj nigaj iga makijilpitiwi̱ga katka ite̱noj ije̱fejmej sacerdo̱tejmej? ");
INSERT INTO nhx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eꞌ Saulo má̱j kiyo̱lmakaya iga kipowa toTe̱ko itájto̱l ipan a̱ltepe̱ꞌ Damasco. Kinojma‑ijtowa̱ya iga makimatika̱n iga Jesu̱sya nokta in el Cristo yej Dios kitapejpen; judiyojmej este akojasiáj ken iga makite̱nkuepili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kua̱ꞌ pánoja miaꞌ día, judiyojmej motajto̱ltijkej iga makimikti̱ka̱n Saulo; ");
INSERT INTO nhx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","eꞌ yéj kimatiꞌ iga kimikti̱jnekiáj. Kichi̱xtoyaj kajka̱n ki̱salo ipan a̱ltepe̱ꞌ semilwiꞌ iwá̱n senyówal iga makimikti̱ka̱n; ");
INSERT INTO nhx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","eꞌ yej kitokaj Saulo, tayowaka̱n kakijkej ipan se̱ pa̱nchikiwé̱j, iwá̱n kipi̱pilojtitemowijkej ipan muro yej iga kola̱ltitoya a̱ltepe̱ꞌ, ijkó̱n iga choloj. ");
INSERT INTO nhx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Kua̱ꞌ Saulo asito Jerusalén, kinekiá mamosenechko̱ka̱n iwá̱n yej no̱ kitokaj Jesús; eꞌ inochimej kimajmawilia̱yaj iga akicre̱dowa̱yaj siga yéj no̱ kitókaya Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Eꞌ Bernabé kiwi̱gaꞌ ka̱n onoꞌ apo̱stolejmej. Iwá̱n kipowaꞌ kén iga ipan ojti toTe̱ko ki̱xne̱xtilij Saulo, iga toTe̱ko kino̱tzaꞌ, iwá̱n kén iga kua̱ꞌ onoya Damasco, Saulo amajmawiꞌ iga kipowaꞌ itájto̱l Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ijkó̱n Saulo ka̱wiꞌ Jerusalén, ya̱yaj iwa̱mej ka̱nsan kinekiá. ");
INSERT INTO nhx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Amajmawiá iga kipowaya itájto̱l toTe̱ko, este mote̱nki̱tzkia̱ya iwá̱n judiyojmej yej tajtowa̱yaj griego. Eꞌ yejeme̱n kinekiáj makimikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kua̱ꞌ yej kitokaj Jesús kimatikej iga kimikti̱jnekiáj Saulo, kiwi̱gakej Cesarea iwá̱n kiti̱tankej iga mayawi Tarso. ");
INSERT INTO nhx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Iwá̱n tokni̱wa̱n yej kicre̱dojtoyaj Jesús yej onoyaj no̱ya̱n Judea, Galilea iwá̱n Samaria, tamelá̱ onoyaj iga ayꞌya kikno̱chi̱wayaj, ma̱jya kisenta̱lia̱yaj iya̱lmajmej ipan Dios. Ye̱ꞌnemiáj ken tatekimaka toTe̱ko iwá̱n nemi miakiayaj iga el Espíritu Santo kipale̱wia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kua̱ꞌ Pedro kipaxa̱lowilijtinemiá yej kitokaj Jesús, yajki no̱ kitato yej cha̱ntitokej a̱ltepe̱ꞌ Lida. ");
INSERT INTO nhx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa kasito se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Eneas yej wetztoya ipan itapech ocho años, awel moketzaya iga takua̱wayaxtoya. ");
INSERT INTO nhx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Iwá̱n Pedro kijlij: —Eneas, Jesucristo mitzachitiáltija. Ximoketza iwá̱n xiꞌye̱tá̱liya ka̱n tiwetztoya. Eneas nimaní̱n moketzaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Iwá̱n nochi kitakej yej cha̱ntitokej a̱ltepe̱ꞌ Lida wa̱n ipan ta̱jli de Sarón, iwá̱n kitokákeja toTe̱ko Jesús yej el Mesías. ");
INSERT INTO nhx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ipan a̱ltepe̱ꞌ Jope onoya se̱ siwa̱ꞌ yej kitoka Jesucristo, ito̱ka̱ꞌ Tabita. Ipan griego kijto̱jneki Dorcas. Yéj nochipa kichijtoya yej ye̱kti; kipale̱wia̱ya yej ayá̱ꞌ motapialia̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Iwá̱n ino̱mej días we̱tiáꞌ wa̱n miguiꞌ. Kua̱ꞌ ka̱ltíjkeja, kiwi̱gakej ajko ipan seꞌ piso. ");
INSERT INTO nhx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Iwá̱n Jope ayá̱ꞌ wejka iga Lida; kua̱ꞌ yej kitokaj Jesús kimatikej iga Pedro onoꞌ Lida, kiti̱tankej o̱me̱n iga ijkí̱n makijli̱tij: —¿Ix wel sémisan tia̱j Jope nowa̱mej? ");
INSERT INTO nhx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Iwá̱n Pedro mote̱máꞌ, yajki iwa̱mej. Kua̱ꞌ asikej Jope, kiwi̱gakej ka̱n onoꞌ a̱nimaj, iwá̱n nochi yej we̱wejmikikej chojcho̱katókejpa iga kiyawalojkej Pedro, kine̱xtilijkej wi̱pi̱lmej iwá̱n kua̱chtimej yej Dorcas kichij kua̱ꞌ aya miki. ");
INSERT INTO nhx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Iwá̱n Pedro kikijki̱xtij nochi yej ompa onoyaj iwá̱n motankua̱ketzaꞌ iga kite̱ne̱wij Dios; iwá̱n kitachi̱lij á̱nimaj, kijtoj: —Tabita, ximoketza. Iwá̱n kitapoj iyi̱x, kitaꞌ iga ompa onoꞌ Pedro, mota̱lij. ");
INSERT INTO nhx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Iwá̱n Pedro kima̱ki̱tzkij iga kiketzaꞌ. Iwá̱n kino̱tzkej yej kitokaj Jesús, wa̱n yej we̱wejmikikej, iga makitaka̱n iga Tabita isaꞌ sej. ");
INSERT INTO nhx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Inó̱n momatiꞌ no̱ya̱n ipan a̱ltepe̱ꞌ Jope, iwá̱n miaꞌ kicre̱dojkej ipan toTe̱ko Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Iwá̱n Pedro wejkaj achi ka̱wiꞌ ipan inó̱n a̱ltepe̱ꞌ cha̱n se̱ yej ito̱ka̱ꞌ Simón, yej kichi̱wa kuajkuantas iga kuetax. ");
INSERT INTO nhx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ipan a̱ltepe̱ꞌ Cesarea onoya se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Cornelio yej ikapitán cien soldado roma̱nojmej, inó̱mejwaꞌ kijlia̱yaj Italiano. ");
INSERT INTO nhx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Inó̱n ta̱gaꞌ wa̱n nochi yej onoꞌ icha̱n kicre̱dowa̱yaj wa̱n kimajmawilia̱yaj Dios. No̱ kipale̱wia̱ya miaꞌ judiyojmej yej amotapialia̱yaj iwá̱n nochipa kite̱ne̱wia̱ya Dios. ");
INSERT INTO nhx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Se̱ tio̱taꞌ ken las tres, ki̱xne̱xtili̱ko se̱ iyá̱ngel Dios, kinojma‑itaꞌ kalakiko ka̱n yéj onoꞌ, kijlij: —¡Cornelio! ");
INSERT INTO nhx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Iwá̱n yéj kitachi̱lijtiki̱saꞌ el ángel wa̱n kimo̱ka̱tajtan: —¿Anka tejté̱ íga? El ángel kijtoj: —Dios mitzkaki kua̱ꞌ tikte̱ne̱wiá iwá̱n mitzita kua̱ꞌ tikpale̱wiá yej ayá̱ꞌ motapialiáj. ");
INSERT INTO nhx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Iná̱n xikti̱tani sekin tajta̱gaꞌ iga maya̱ka̱n Jope, iga makino̱tzatij Simón, yej ito̱ka̱ꞌ no̱ Pedro, ");
INSERT INTO nhx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","onoꞌ cha̱n sewoꞌ Simón yej tekipanowa iga kuetax, yej cha̱ntitoꞌ lama̱rte̱noj. Yéj yawi mitzijli̱ti yej tia tikchi̱wati. ");
INSERT INTO nhx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kua̱ꞌ yájkiya el ángel yej tajtojtoya íwa̱n, Cornelio kino̱tzaꞌ o̱me̱n itekipanowa̱nimej iwá̱n se̱ soldado yej kiye̱ꞌitaya, yej no̱ kicre̱dowa Dios. ");
INSERT INTO nhx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Iwá̱n kua̱ꞌ támiꞌya kipowilij nochi kén iga kitaꞌ, kiti̱tan iga maya̱ka̱n a̱ltepe̱ꞌ Jope. ");
INSERT INTO nhx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ipan seꞌya día mie̱j nemi yawij ipan ojti iwá̱n asitiá̱yaja Jope, Pedro tejkaj iyi̱xko kajli ken tajkodía iga kite̱ne̱wiá Dios. ");
INSERT INTO nhx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Iwá̱n poxsan maya̱naya, kinekiá maguiꞌ matákuaya. Kua̱ꞌ nemi kichi̱wiliáj itákual, Dios kine̱xtilij Pedro te̱pa iteki en visión. ");
INSERT INTO nhx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kimelaꞌitaꞌ iga cielo tapowiꞌ, pilojtiwi̱tziá te tani se̱ ken tikita weyimántia̱l, ijilpitiwi̱tziá ipan na̱wi inakas. ");
INSERT INTO nhx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ipan inó̱n weyimántia̱l onoya se̱seꞌpa yo̱lka̱mej; yej kipiáj na̱wi iyikximej, yej moe̱lwawatatzowaj iwá̱n yej pata̱nij. ");
INSERT INTO nhx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Iwá̱n kikaguiꞌ se̱ tájto̱l yej kijlij: —Pedro, ximoketza, xikmikti iwá̱n xikua. ");
INSERT INTO nhx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Eꞌ Pedro kijtoj: —NoTe̱ko, awel, iga nej ayí̱ꞌ nikua yej kijtowa motájto̱l iga amokua. ");
INSERT INTO nhx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Iwá̱n inó̱n yej kino̱tzaꞌ, sej kijlij: —Yej Dios kijtowa iga wel mokua, tej amo xikijli iga aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ijkó̱n mochij e̱yi ve̱j, iwá̱n inó̱n weyimántia̱l sej tejkaj ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kua̱ꞌ Pedro tayo̱koxtoya iga akimatiá te̱ kijto̱jneki inó̱n yej Dios kine̱xtilij, asitoj tajta̱gaꞌ yej Cornelio kiti̱tan. Tatajtantiwa̱lkej ka̱n icha̱n Simón, este asikej ipan ikalte̱n. ");
INSERT INTO nhx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Tano̱tzkej, tatajtankej: —¿Ix nigaj onoꞌ se̱ yej ito̱ka̱ꞌ Simón yej no̱ ito̱ka̱ꞌ Pedro? ");
INSERT INTO nhx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Kua̱ꞌ Pedro kejlá̱ntogoꞌ inó̱n yej kitaꞌ, el Espíritu Santo kijlij: —Taꞌ xikaki; e̱yi tajta̱gaꞌ mitzte̱mowaj. ");
INSERT INTO nhx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ximokétzaya, iwá̱n xitemo. Amo te̱ xikejla̱miki, xaj iwa̱mej iga ino̱mej nej nikti̱tan. ");
INSERT INTO nhx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Iwá̱n Pedro temoj, kitechoj ino̱mej tajta̱gaꞌ yej Cornelio kiti̱tan. Kijlij: —Nejwaꞌ in yej anne̱te̱mowaj; ¿te iga anwa̱lkej? ");
INSERT INTO nhx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Iwá̱n yejeme̱n kijtojkej: —Niwa̱lkej iga ne̱ti̱tankej el capitán Cornelio. Yéj poxsan ye̱ꞌnemi iwá̱n kiweyimati̱ltiá Dios. Nochi judiyojmej kipoxye̱ꞌitaj Cornelio iwá̱n kipoxnekij. Se̱ iyá̱ngel Dios kitekimáꞌ iga mamitzno̱tzaki iga xajkiꞌ ícha̱n, iga makikaki yej tej tia tikijli̱ti. ");
INSERT INTO nhx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Iwá̱n Pedro kijlij iga makalakika̱n kalijtiꞌ, iwá̱n ompa ka̱wikej iga kochkej. Kua̱ꞌ tané̱siꞌya, Pedro yajki iwá̱n yejeme̱n; yajkij no̱ sekin yej kitokaj Jesús yej ompa icha̱mej Jope. ");
INSERT INTO nhx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ipan seꞌ día asitoj Cesarea ka̱n Cornelio kichi̱xtóyaja iwá̱n sekin iyikní̱wa̱mpa wa̱n iyami̱gojmej yej íwa̱n moye̱ꞌitaj, yej yéj kijlij iga ompa maonoka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kua̱ꞌ Pedro asito, Cornelio ki̱xna̱mikito, iwá̱n motankua̱ketzaꞌ iyi̱xtaj iga katka makiweyimati̱lti. ");
INSERT INTO nhx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Eꞌ Pedro kiketzaꞌ, kijlij: —Ximoketza. Nej no̱ nita̱gaꞌ kensan tej. ");
INSERT INTO nhx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Iwá̱n ta̱tapojtiajkij te kalijtiꞌ, ompa kasitoj miaꞌ yej nechkatokej. ");
INSERT INTO nhx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Iwá̱n Pedro kijtoj: —Amejeme̱n ankimátija iga nej yej nijudiyoj, noley ne̱ne̱xtiliá iga awel manimonechko iwá̱n yej ayéj judío, niga manikalaki ícha̱n; eꞌ Dios ne̱ne̱xtilij iga amo manikijli ni agaj iga akajasi iga makina̱ꞌtecho Dios. ");
INSERT INTO nhx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Inó̱n íga kua̱ꞌ ne̱no̱tzatoj, niwa̱laj; ayá̱ꞌ nikijtoj iga ayá̱ꞌ nia. Iná̱n nikmatisneki te íga anne̱no̱tzakej. ");
INSERT INTO nhx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio kijtoj: —Kipiá na̱wi días, ken las tres tio̱takpan, nigaj nocha̱n nimayuna̱rojtoya iwá̱n nikte̱ne̱wijtoya Dios ken tiktekichi̱waj, iwá̱n ne‑i̱xne̱xtili̱ko se̱ ta̱gaꞌ, nikitaꞌ iga kinentiá itzótzol yej este pe̱peta̱ni. ");
INSERT INTO nhx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Iwá̱n ne̱no̱tzaꞌ, ne‑ijlij: “Cornelio, Dios mitzkaki kua̱ꞌ tikte̱ne̱wiá iwá̱n mitzitztoꞌ iga tikpale̱wiá yej amotapialiáj. ");
INSERT INTO nhx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Iná̱n xikti̱tani yej maya̱ka̱n Jope iga makikuitij Simón yej ito̱ka̱ꞌ no̱ Pedro. Onoꞌ cha̱n sewoꞌ Simón yej kicurti̱rowa kuetax, yej cha̱ntitoꞌ lama̱rte̱noj. Kua̱ꞌ ásisya, mitzta̱tapo̱wi̱j.” ");
INSERT INTO nhx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Inó̱n iga imaní̱n nimitztati̱tanilij, iwá̱n ye̱ktia̱ iga tiwa̱laj. Iná̱n nigaj nonokej nonochi̱n iyi̱xtaj Dios wa̱n niknekij manikakika̱n nochi yej Dios mitztekimáꞌ iga xine‑ijli̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Iwá̱n Pedro pe̱waꞌ tajtoj: —Iná̱n sí nikmelaꞌmati iga Dios ayá̱ꞌ se̱san kiye̱ꞌita, ");
INSERT INTO nhx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","kiye̱ꞌita yej kimajmawiliáj iwá̱n kichi̱wa yej ye̱kti, judío o a̱ꞌsan ne̱si yej onoꞌ ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios kino̱tzaꞌ ipilowa̱n ipilówa̱mpa Israel, kipowilijkej iga wel onoj tamelá̱ iyi̱xtaj siga moconfia̱rowaj pan Jesús yej Mesías, yej tonochi̱n toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Amejeme̱n ankimatij yej mochij no̱ya̱n ipan íta̱l judiyojmej, pe̱waꞌ Galilea kua̱ꞌ Juan kipowaꞌ itájto̱l Dios iwá̱n tabautiza̱roj. ");
INSERT INTO nhx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ankimatij no̱ ken iga Dios kimáꞌ Jesús de Nazaret iyEspí̱rito Santo iga wel makichijtinemi yej ye̱kti iwá̱n makachitialtijtinemi nochi yej tzitzimiꞌ kikno̱chijtoya. Jesús kichi̱waya inó̱n iga Dios onoya íwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","’Nejemej sí nikitakej inochi yej kichijtinemiꞌ Jesús ipan estado de Judea wa̱n ipan a̱ltepe̱ꞌ Jerusalén. Ompa kimiktijkej, kiclava̱rójkejpa ipan kuacru̱z. ");
INSERT INTO nhx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Iní̱n Jesús, Dios ki‑ojpa‑ixitij ipan tercer día, iwá̱n kichij iga mane‑i̱xne̱xtili̱ka̱n nejemej. ");
INSERT INTO nhx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ayá̱ꞌ inochi̱n ki̱xne̱xtilijkej, ne‑i̱xne̱xtilijkej nejéme̱nsan yej ikyay ne̱tapejpenkej iga manikpowaka̱n iga isatoꞌ Jesús. Nejeme̱n nisentakuajkej iwá̱n nisen‑a̱tikej iwá̱n yéj, kua̱ꞌ ojpa‑ísaꞌya ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Iwá̱n ne̱ti̱tankej iga manikpowaka̱n, manikijli̱tij nochi iga Dios kita̱lij Jesús iga makijuzga̱ro yej isatokej iwá̱n yej miktokej. ");
INSERT INTO nhx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Iwá̱n te ikyay profe̱tajmej tajtowaj iga Jesús, kijtowaj iga nochi yej kisenta̱liáj iya̱lmaj ipan Jesús, kiperdona̱rowa yej kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ta̱tapojtóyaoꞌ Pedro, kua̱ꞌ wa̱laj el Espíritu Santo ipan inochi̱n yej takaktoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Iwá̱n judiyojmej yej kitokaj Jesús yej wa̱lkej wa̱n Pedro, san tajtachi̱xtikajkej iga Dios no̱ kimáꞌ iyEspí̱rito Santo yej ayéj judiyojmej, ");
INSERT INTO nhx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","iga kikakiáj iga tajtojtokej ipan se̱séꞌpaya tájto̱l iwá̱n kiweyimati̱ltijtoyaj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Iwá̱n Pedro kijtoj: —¿Ix wel agaj kijtowa iga amo mamobautiza̱ro̱ka̱n ipan a̱ꞌti ini̱mej yej Dios kimajmaꞌya no̱ iyEspí̱rito Santo kensan tejeme̱n te̱majmáꞌ? ");
INSERT INTO nhx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Iwá̱n tatekimáꞌ iga mamobautiza̱ro̱ka̱n ipan ito̱ka̱ꞌ Jesucristo. Kua̱ꞌ tamiꞌ mobautiza̱rojkej, kijlijkej Pedro iga maká̱wi‑oꞌ acho̱ꞌ días má̱j iwá̱n yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apo̱stolejmej iwá̱n yej kitokaj Jesús yej onoyaj Judea, kimatikej iga no̱ kicre̱dójkeja itájto̱l Dios yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kua̱ꞌ Pedro asiꞌ Jerusalén, judiyojmej yej tatekimakaj iga mamocircuncida̱ro̱ka̱n yej ayéj judiyojmej, pe̱ꞌ ta‑iji̱xko‑ijlijkej, ");
INSERT INTO nhx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","kijtojkej: —Tejémejpa tijudiyojmej, ¿te iga tikpaxa̱lowili̱to ino̱mej yej ayéj judiyojmej, iwá̱n este titakuaj iwa̱mej? ");
INSERT INTO nhx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Iwá̱n Pedro kipowaꞌ inochi yej mochij este ka̱n pe̱waꞌ, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nej nonoya Jope, iwá̱n kua̱ꞌ nikte̱ne̱wijtoya Dios, yéj ne‑i̱xne̱xtilij tejté̱. Nikitaꞌ ken se̱ weyimántia̱l, temo̱tiwa̱laj ipan cielo, ijilpitiwa̱laj ipan na̱wi inajnakastan, temoj este ka̱n nej nonoya. ");
INSERT INTO nhx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Niktachi̱lijtika̱wiꞌ iga manikitaꞌ te̱ kipiaya, ompa nikitaꞌ yo̱lka̱mej yej kipiá na̱wi iyikxi, yej te̱kuaj, yej moe̱lwawatatzowaj iwá̱n yej pata̱nij. ");
INSERT INTO nhx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Iwá̱n nikáꞌ se̱ tájto̱l ne‑ijlij: “Ximoketza Pedro, xikmikti iwá̱n xikua.” ");
INSERT INTO nhx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Eꞌ nej nikijlij: “Awel noTe̱ko, iga nej ayí̱ꞌ nikua yej kijtowa motájto̱l iga amokua.” ");
INSERT INTO nhx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Iwá̱n sej nikáꞌ inó̱n tájto̱l yej wa̱laj ipan cielo, ne‑ijlij: “Yej Dios kijtowa iga wel mokua, tej amo xikijli iga aye̱kti.” ");
INSERT INTO nhx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ijkó̱n nikitaꞌ e̱yi ve̱j, iwá̱n nochi sej tejkaj ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Íkua̱ꞌsan asikej kalijtiꞌ ka̱n nonoya e̱yi tajta̱gaꞌ yej wa̱lkej Cesarea iga ne̱te̱mo̱koj. ");
INSERT INTO nhx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","IyEspí̱ritoj Dios ne‑ijlij iga maniá, eꞌ amo manimajmawi. No̱ yajkaj ini̱mej seis yej kitokaj Jesús, iwá̱n nikalakkej cha̱n se̱ ta̱gaꞌ ");
INSERT INTO nhx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","yéj ne̱powilijkej ken iga icha̱n kitaꞌ se̱ iyá̱ngel Dios ejkatoya iwá̱n kijlij: “Agaj xikti̱tani ipan a̱ltepe̱ꞌ Jope iga makino̱tzatij Simón yej no̱ ito̱ka̱ꞌ Pedro; ");
INSERT INTO nhx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","yéj yawi mitzijli̱ti ken iga wel ximoma̱nawi, tej iwá̱n inochi mofami̱liaj.” ");
INSERT INTO nhx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kua̱ꞌ pe̱ꞌ nikta̱tapo̱wijkej, el Espíritu Santo wa̱laj iyakapamej, kensan tejemej no̱ kua̱ꞌ achto asiꞌ ipan tejemej. ");
INSERT INTO nhx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Íkua̱ꞌya nikejla̱n yej kijtoj toTe̱ko: “Juan tabautiza̱rowa iga a̱ꞌti, eꞌ amejeme̱n mitzbautiza̱ro̱skej iga el Espíritu Santo.” ");
INSERT INTO nhx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Siga Dios kimakakej yejemej yej tejemej no̱ te̱makakej yej ticre̱dojkej toTe̱ko Jesucristo, ¿te̱ noteki in nej iga amo manikchi̱wa ken kineki Dios? ");
INSERT INTO nhx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Iwá̱n kua̱ꞌ yej de Jerusalén yej kitokaj Jesús kikakikej inó̱n, ate‑oꞌ kijtojkej, iwá̱n kiweyimati̱ltijkej Dios, kijtojkej: —¡Mataj no̱ yej ayéj judiyojmej Dios kineꞌ iga no̱ makikajte̱waka̱n iga kichi̱waj yej aye̱kti iga no̱ maonoka̱n nochipa ite̱noj! ");
INSERT INTO nhx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kua̱ꞌ kimiktíjkeja Esteban, pe̱wakej kikno̱chijkej yej kitokaj Jesús, sekin cholojkej iwá̱n yajkij Fenicia, Chipre iwá̱n Antioquía. Ompa kipowilijkej itájto̱l Dios yejsan judiyojmej, eꞌ yej ayéj judiyojmej ayá̱ꞌ kipowilijkej. ");
INSERT INTO nhx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Eꞌ sekin yej kitokaj Jesucristo yej icha̱mej Chipre iwá̱n Cirene asikej pan a̱ltepe̱ꞌ Antioquía iwá̱n no̱ kita̱tapo̱wijkej yej ayéj judiyojmej, kipowilijkej ye̱ꞌnoti̱ciaj de Jesús yej toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ipode̱r toTe̱ko onoya wa̱n yejemej. Iwá̱n miaꞌ kicre̱dojkej toTe̱ko iwá̱n kikajtejkej ken ikya kicre̱dojtoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kua̱ꞌ tokni̱wa̱n de Jerusalén yej kicre̱dojtokej toTe̱ko, kimatikej nochi iní̱n yej mochij, kiti̱tankej Bernabé iga mayawi Antioquía. ");
INSERT INTO nhx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Kua̱ꞌ ompiga asito, kitaꞌ kén iga Dios kiye̱ꞌitaꞌ ino̱mej, iwá̱n poxsan yo̱lpa̱guiꞌ. Kino̱no̱tzkej iga makicre̱do̱ka̱n toTe̱ko iga nochi iya̱lmajmej iwá̱n makichi̱waka̱n ken yéj kineki. ");
INSERT INTO nhx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bernabé poxsan te‑ijikni̱n, kipiaya el Espíritu Santo, iwá̱n poxsan moconfia̱rojtoya ipan Dios. Iwá̱n miaꞌya gente kicre̱dojkej toTe̱ko iga yéj kita̱tapowij. ");
INSERT INTO nhx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Iwá̱n Bernabé yajki Tarso iga kite̱mo̱to Saulo; iwá̱n kua̱ꞌ kasiꞌ kiwi̱gaꞌ Antioquía. ");
INSERT INTO nhx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ompa monechkojtoyaj se̱ año iwá̱n tokni̱wa̱n iwá̱n kimachtijkej miaꞌ gente; ompa Antioquía achto ve̱j kito̱ka̱wijkej cristia̱nojmej yej kitokaj Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Inó̱n tiempo sekin profe̱tajmej ki̱skej Jerusalén iga yajkij Antioquía. ");
INSERT INTO nhx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Se̱ de yejemej yej ito̱ka̱ꞌ Agabo moketztiki̱saꞌ ka̱n nechkatoyaj yej kitokaj Jesús, iwá̱n kijtoj ken iga Dios iyEspí̱ritoj kitajto̱lmáꞌ iga yawi a̱pistajtiati no̱ya̱n. Iní̱n mochij kua̱ꞌ goberna̱rojtoya rey Claudio. ");
INSERT INTO nhx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Entonces yej kitokaj Jesús yej icha̱mej Antioquía kijtojkej iga yawij kiti̱tanili̱tij tomi̱n iga kipale̱wiáj yej kitokaj Jesús yej cha̱ntitokej Judea, ke̱ꞌya iga se̱ wel kimaka. ");
INSERT INTO nhx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iwá̱n ijkó̱n kichijkej, iwá̱n inó̱n tomi̱n kika̱watoj Bernabé iwá̱n Saulo, kimakakej iyancia̱nojmej ino̱mej yej kicre̱dowaj Jesucristo yej onokej Judea. ");
INSERT INTO nhx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Inó̱n ve̱j el rey Herodes pe̱waꞌ iga kiki̱tzkij sekin yej kitokaj Jesucristo iga kikno̱chi̱waj. ");
INSERT INTO nhx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Iwá̱n iga espada kimiktijkej Jacobo yej Juan iyikni̱n. ");
INSERT INTO nhx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Iwá̱n kua̱ꞌ el rey kitaꞌ iga nochi judiyojmej kiye̱ꞌitakej iga kimiktijkej Jacobo, tatekimáꞌ iga no̱ mamoki̱tzki Pedro. Inó̱n mochij kua̱ꞌ nentoya ilwiꞌ yej kijliáj Pascua kua̱ꞌ mokua pa̱n yej ayá̱ꞌ kipiá levadura. ");
INSERT INTO nhx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kua̱ꞌ kiki̱tzkíjkeja Pedro, Herodes kipre̱sojwij, ompa kicuida̱rojtoyaj na̱wi grupo solda̱dojmej, ipan cada grupo onoya na̱wi solda̱dojmej. Herodes kejla̱ntoya iga kiwi̱gaya iyi̱xtaj la gente kua̱ꞌ pánojya iyilwiyo la Pascua. ");
INSERT INTO nhx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iwá̱n Pedro onoya preso, eꞌ paré̱j kicuida̱rojtoyaj. Eꞌ tokni̱wa̱n yej kitokaj Jesucristo ayá̱ꞌ siawiáj iga kite̱ne̱wijtoyaj Dios iga makipale̱wi Pedro. ");
INSERT INTO nhx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ino̱nsan yówal antes iga Herodes makiwi̱ga Pedro iyi̱xtaj la gente, Pedro kochtoya itajkoya̱n o̱me soldado, majma‑ilpitoya iga o̱me cadena, iwá̱n sekin solda̱dojmej kicuida̱rojtoyaj ikalte̱nyo cárcel. ");
INSERT INTO nhx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Iwá̱n we̱jki̱sako se̱ iyá̱ngel toTe̱ko, este ta̱wí̱lpanya onoyaj ca̱rcelijtiꞌ. Iwá̱n inó̱n ángel kichijchin Pedro ipan iyájkol iga kixitij iwá̱n kijlij: —Nimaní̱n ximokétzaya. Iwá̱n ino̱mej cadena yej iga ma‑ilpitoya, xijxitomiꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Iwá̱n el ángel kijlij: —Ximotajko‑ílpiya iga mocintoro̱n iwá̱n xikajákiya mogaꞌ. Kua̱ꞌ Pedro kíchija ijkó̱n, el ángel kijlij: —Xikaki mosota̱ntzótzol iwá̱n xine̱toka. ");
INSERT INTO nhx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pedro ki̱saꞌ iwá̱n kitokatia̱ya el ángel, eꞌ ayá̱ꞌ kitawelcre̱dowa̱ya yej el ángel nemi kichi̱wa. Yéj kijtowa̱ya anka kite̱miktoya. ");
INSERT INTO nhx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eꞌ kua̱ꞌ kitaꞌ kipatilíjkeja yej áchtopa guardia, kua̱ꞌ kitaꞌ seꞌya kipatilijkej, iwá̱n kua̱ꞌ asíkeja ka̱n kalte̱n de tepos yej onoꞌ ca̱llejte̱noj, inó̱n kalte̱n yokatapowiꞌ, ki̱skej, iwá̱n kua̱ꞌ kipatilijkej se̱ calle, el ángel ómpaya kikajtej Pedro. ");
INSERT INTO nhx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Íkua̱ꞌya Pedro kimatiꞌ, iwá̱n kijtoj: —Iná̱n sí niknojmamatiꞌ iga toTe̱ko kiti̱tan iyá̱ngel iga mane̱ma̱nawi ipan ima̱ꞌ Herodes iwá̱n de inochi yej judiyojmej kinekiáj mane̱chi̱wili̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Mie̱j inó̱n kejla̱ntoya, Pedro yajki cha̱n María, yej iye̱ꞌ Juan yej ito̱ka̱ꞌ no̱ Marcos, ompa nechkatoyaj miaꞌ yej kite̱ne̱wijtoyaj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Kua̱ꞌ Pedro kaltzotzon ipan puerta yej onoꞌ ojte̱noj, se̱ takotzi̱n yej ito̱ka̱ꞌ Rode yajki kitato a̱ꞌyéj tano̱tztoya. ");
INSERT INTO nhx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Kua̱ꞌ kitajto̱lkaguiꞌ iga Pedro, ayá̱ꞌ kikaltapoj, sino que iga yo̱lpa̱guiꞌ, motalojtiajki kalijtiꞌ iga tamati̱lti̱to iga Pedro ónoꞌya ipan kalte̱n. ");
INSERT INTO nhx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Iwá̱n kijlijkej: —Tej anka ayꞌya titajla̱ntoꞌ. Eꞌ yéj kijtowa̱ya iga kena. Iwá̱n yejeme̱n kijtojkej: —Anka ayéj yéj; anka iyá̱ngel. ");
INSERT INTO nhx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Eꞌ Pedro tano̱tztóyasan ipan kalte̱n. Iwá̱n kua̱ꞌ kikaltapowilíjkeja iwá̱n kitakej, momajtijkej. ");
INSERT INTO nhx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Eꞌ Pedro tama̱no̱tzaꞌ iga ayoꞌ matajtojtoka̱n, iwá̱n pe̱ꞌ kipowaꞌ kén iga toTe̱ko kiki̱xtij ipan cárcel; iwá̱n kijtoj: —Iní̱n xikmati̱lti̱ka̱n no̱ Jacobo iwá̱n yej kitokaj Jesús. Después ki̱saꞌ ompa; yajki seꞌ lado. ");
INSERT INTO nhx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kua̱ꞌ tane̱siꞌ, solda̱dojmej ayꞌya nokta kojasiáj te̱ kichi̱wayaj iga ayá̱ꞌ kimatiáj ka̱n yajki Pedro. ");
INSERT INTO nhx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herodes tatekimáꞌ iga makite̱mo̱tij, eꞌ como ayá̱ꞌ kasikej, kua̱ꞌ támiꞌya kitajtajtankej in solda̱dojmej, tatekimáꞌ iga makimijmikti̱ka̱n solda̱dojmej igakiꞌ itechkomej choloj Pedro. Iwá̱n Herodes ki̱saꞌ Judea iwá̱n yajki mocha̱nti̱to Cesarea. ");
INSERT INTO nhx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes kikuesowilijtoya la gente yej cha̱ntitoyaj a̱ltepe̱mej Tiro iwá̱n Sidón, eꞌ ino̱mej gente kikowayaj te̱ kikuaj ipan ipaí̱s el rey Herodes. Inó̱n iga sekin de yejemej yajkij kitatoj se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Blasto yej kipiaya itekipáno̱l ka̱n manda̱rowa Herodes, iwá̱n yéj kitajtowilijkej iga maonoka̱n tamelá̱. ");
INSERT INTO nhx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Se̱ día Herodes kitati̱tanilij ino̱mej, iwá̱n inó̱n día Herodes kakij ye̱ꞌtzótzol iga mane̱si iga rey; iwá̱n mota̱lij ipan iweyi asiento ka̱n manda̱rowa iwá̱n tajtoj iyi̱xtaj la gente. ");
INSERT INTO nhx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","La gente pe̱ꞌ tzajtzikej iga kijtojkej: —¡Iní̱n yej nemi tajtowa, se̱ nokta dios, ayéj na̱mo̱lta̱gaꞌ! ");
INSERT INTO nhx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Iwá̱n íkua̱ꞌsan wa̱laj se̱ iyá̱ngel toTe̱ko, kichij iga Herodes mamenferma̱ro iga ayá̱ꞌ kiweyimati̱ltij Dios. Iwá̱n má̱j má̱j okuilyowiꞌ iwá̱n miguiꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Eꞌ itájto̱l toTe̱ko ma̱jya momatiá, iwá̱n nó̱ya̱nya momatitia̱ya. ");
INSERT INTO nhx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Kua̱ꞌ Bernabé iwá̱n Saulo tamiꞌ itekipano̱lmej, yajkij Jerusalén, senyajkij iwá̱n Juan yej ito̱ka̱ꞌ no̱ Marcos. ");
INSERT INTO nhx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ipan a̱ltepe̱ꞌ Antioquía ka̱n monechkowa̱yaj yej kitokaj Jesucristo onoya profe̱tajmej iwá̱n yej tamachtia̱yaj. Onoya Bernabé iwá̱n Simón (yej kijlia̱yaj Pi̱stiꞌta̱gaꞌ), iwá̱n Lucio de Cirene, Manaén (yej moskaltijkej seka̱n iwá̱n Herodes el gobernador de Galilea) iwá̱n Saulo. ");
INSERT INTO nhx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Se̱ día, kua̱ꞌ ino̱mej monechkojtoyaj iga kiweyimati̱ltiáj toTe̱ko, iwá̱n mayuna̱rojtoyaj, kijtoj el Espíritu Santo: —Xine̱tapejpenili̱ka̱n Bernabé iwá̱n Saulo, iga makichi̱watij tekipáno̱l yej iga nikno̱tzakej. ");
INSERT INTO nhx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Iwá̱n kua̱ꞌ támiꞌya ora̱dojkej, iwá̱n mayuna̱rojkej, kita̱lilijkej ima̱mej ipan itzontekomej, iwá̱n kinawatijkej Bernabé iwá̱n Saulo. ");
INSERT INTO nhx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Iwá̱n iyEspí̱ritoj Dios kiti̱tankej Bernabé iwá̱n Saulo iga maya̱ka̱n a̱ltepe̱ꞌ Seleucia iwá̱n ompa tejkajkej ipan weyi á̱ka̱l iga yajkij tajkóta̱l Chipre. ");
INSERT INTO nhx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kua̱ꞌ asikej Salamina ka̱n moketza a̱ka̱lmej, pe̱wakej iga kipowaj itájto̱l Dios ipan itio̱pamej judiyojmej. Juan ompa no̱ nemiá iga kipale̱wijtinemiá ino̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nejnenkej no̱ya̱n ipan inó̱n tajkóta̱l este asikej ipan a̱ltepe̱ꞌ Pafos. Ompa kasikej se̱ judío yej ito̱ka̱ꞌ Barjesús. Motamatiliá iwá̱n takajkayajtinemiá, kijtowa̱ya iga Dios kitajto̱lmakaya. ");
INSERT INTO nhx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Inó̱n yej motamatiliá moye̱‑itaya iwá̱n el gobernador Sergio Paulo. Inó̱n gobernador poxsan kua̱yama̱niꞌ, wa̱n kino̱tzkej Bernabé iwá̱n Saulo, iga kinekiá makikaki itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Yej motamatiliá, ipan tájto̱l griego no̱ ito̱ka̱ꞌ Elimas. Elimas ayá̱ꞌ kiye̱ꞌitaꞌ ino̱mej iwá̱n akineꞌ iga el gobernador makicre̱do itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Iwá̱n Saulo yej no̱ ito̱ka̱ꞌ Pablo, poxsan kipiaya nokta iyEspí̱ritoj Dios, kitachi̱lijtiká̱ꞌ ");
INSERT INTO nhx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","iwá̱n kijlij: —¡Tejya yej poxsan titakajkayajtoꞌ iwá̱n tikchijtoꞌ yej aye̱kti, tej motaj Tzitzimiꞌ yej kijiya nochi yej ye̱kti! ¿Te iga tiktzakuiliá iga sekin amo makicre̱do̱ka̱n Dios? ");
INSERT INTO nhx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Iná̱n yawi mitzcastiga̱ro̱ti toTe̱ko; tia tipachatiati. Wejka̱was iga atikitas to̱nati̱ꞌ. Iwá̱n íkua̱ꞌsan pachatiáꞌ; melaꞌtako̱mpachijtika̱wiꞌ. Kite̱mojtinemiꞌ a̱ꞌyéj wel makima̱wila̱ntiá. ");
INSERT INTO nhx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kua̱ꞌ el gobernador kitaꞌ inó̱n yej mochij, kicre̱doj iga madmira̱doj kén iga kipowakej itájto̱l toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Iwá̱n Pablo iwá̱n yej senemiáj tejkajkej ipan weyi á̱ka̱l ompa Pafos, yajkij asitoj ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Perge, yej onoꞌ ipan estado de Panfilia. Eꞌ Juan kikajtej yejemej, mokuepaꞌ Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pablo iwá̱n sekin ki̱skej Perge, iwá̱n asitoj ipan a̱ltepe̱ꞌ Antioquía, yej onoꞌ ipan estado de Pisidia. Kua̱ꞌ asiꞌ día kua̱ꞌ mose̱wilo, yajkij ipan itio̱pamej judiyojmej, kalakkej iwá̱n mota̱lkej. ");
INSERT INTO nhx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kua̱ꞌ moleé̱roja iley Moisés iwá̱n yej kijkuilojkej profe̱tajmej, yej manda̱rowaj tio̱pan kino̱tzkej Pablo iwá̱n sekin, kijlijkej: —Nokni̱mej siga tejté̱ anne‑ijli̱jnekij yej nigaj nonokej iga anne̱no̱no̱tzaj, xine‑ijli̱ka̱n iná̱n. ");
INSERT INTO nhx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Iwá̱n Pablo moketzaꞌ iwá̱n tama̱no̱tzaꞌ iga amo agaj mata̱tapojto, iwá̱n kijtoj: —Xine̱kakika̱n, amejeme̱n tajta̱gaꞌ de Israel iwá̱n yej ankimajmawiliáj Dios: ");
INSERT INTO nhx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","IDio̱s israeli̱tajmej kitapejpen to‑ikyapatajwa̱n, iwá̱n kichij iga mapi̱wika̱n poxsan ipilowa̱n kua̱ꞌ cha̱ntitoyaj ipan ta̱jli yej ito̱ka̱ꞌ Egipto. Iwá̱n ima̱tika kiki̱xtijkej ompiga. ");
INSERT INTO nhx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios kijyo̱wij cuarenta años ken kichijtinemiáj ipan desierto, ");
INSERT INTO nhx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","iwá̱n kipoloj siete naciones yej onoyaj ipan íta̱l Canaán, iwá̱n inó̱n ta̱jli kimáꞌ to‑ikyapatajwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Iwá̱n má̱j má̱j, cuatrocientos cincuenta años manda̱rojtiwa̱lkej jue̱zmej este iga profeta Samuel onoko. ");
INSERT INTO nhx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Iwá̱n la gente kinekikej iga makipiaka̱n se̱ rey iga makimanda̱ro̱ka̱n. Iwá̱n Dios kita̱lij Saúl iga mamanda̱ro cuarenta años, yej ipíltzi̱mpa Cis. Inó̱n Cis irra̱zaj Benjamín. ");
INSERT INTO nhx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Después Dios kiki̱xtij Saúl, iwá̱n kita̱lij David iga rey. Dios ye̱ꞌtajtoj iga David, kijtoj: “Nikasiꞌ David, yej ipíltzi̱mpa Isaí, se̱ ta̱gaꞌ yej nikpoxye̱ꞌita iwá̱n yéj yawi kichi̱wati ken nej nikneki.” ");
INSERT INTO nhx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jesús yajki se̱ de ipilowa̱n ipilówa̱mpa David. Jesús yej Dios kitapejpen iga makima̱nawi israeli̱tajmej kensan kijtoj. ");
INSERT INTO nhx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Kua̱ꞌ aya wi̱ꞌ Jesús, Juan kipowilia̱ya itájto̱l Dios nochi israeli̱tajmej. Kijlia̱yaj iga makikajte̱wáka̱nya iga kichi̱waj yej aye̱kti iwá̱n mamobautiza̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kua̱ꞌ Juan ayꞌya wejka iga mikis, kijtoj: “Nej ayéj inó̱n yej amejeme̱n ankejla̱ntokej; yéj wi̱ꞌoꞌ. Nej ayá̱ꞌ neajasi iga manikxitomili imekayo igaꞌ.” ");
INSERT INTO nhx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Nokni̱wa̱n yej ipilówa̱mpa Abraham, iwá̱n amonochi̱n yej ankimajmawiliáj Dios: iga amejéme̱nya nokta mitzti̱tanilijkej iní̱n tájto̱l yej mitzma̱nawiáj. ");
INSERT INTO nhx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Iga yej cha̱ntitoyaj Jerusalén iwá̱n yej ompa manda̱rowa̱yaj ayá̱ꞌ kimatikej a̱ꞌyéj in Jesús. Niga kentende̱rowa̱yaj itajto̱lmej profe̱tajmej, yej molee̱rowa nochipa pan día kua̱ꞌ mose̱wilo; ijkó̱n kua̱ꞌ kimiktijkej Jesús kichijkej ken kijkuilojkej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Malej akasilijkej te íga makimikti̱ka̱n, eꞌ kitekiꞌtajtanilijkej Pilato iga matatekimaka iga makimikti̱ka̱n Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kua̱ꞌ kichíjkeja nochi kensan ijkuilijtoꞌ itájto̱l Dios ka̱n tajtowa de yéj, kitemowijkej ipan cruz, iwá̱n kito̱kátoja. ");
INSERT INTO nhx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Eꞌ Dios ki‑ojpa‑ixitij ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Iwá̱n miaꞌ días Jesús ki̱xne̱xtilij yej íwa̱n senemiáj Galilea iwá̱n Jerusalén. Iná̱n yejemej yej kita̱tapo̱wiáj la gente ken iga kitakej. ");
INSERT INTO nhx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","’Iná̱n nejemej nemi nimitzpowiliáj ye̱ꞌnoti̱ciaj de inó̱n yej Dios kijlij to‑ikyapatajwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Tejemej ipilówa̱mpa yejemej, Dios kíchija yej kijtoj iga ki‑ojpa‑ixitij Jesús ka̱n miktoya, ijkó̱n ijkuilijtoꞌ ipan salmos dos: “Tej tinopiltzi̱n; a̱man nej nikchij iga wel xono.” ");
INSERT INTO nhx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios kijtoj iga yawi ki‑ojpa‑ixiti̱ti ka̱n miktoꞌ iga amo mapala̱ni, ijkó̱n kijtowa ka̱n ijkuilijtoꞌ pan itájto̱l Dios: “Nia nimitzmakatij yej ye̱kti ken nikijlij David.” ");
INSERT INTO nhx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Inó̱n iga no̱ ipan seꞌ salmo, kijtowa ijkí̱n: “Tej Dios, ayá̱ꞌ tiksemakas iga mapala̱ni inakayo motekipanowa̱ni yej tikpoxneki.” ");
INSERT INTO nhx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Melá̱ꞌ iga David kimanda̱roj la gente de inó̱n tiempo, ken kitekimáꞌ Dios iwá̱n má̱j má̱j miguiꞌ, kito̱katoj ka̱n to̱ktokej itajwa̱n, iwá̱n pala̱niꞌ inakayo. ");
INSERT INTO nhx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Eꞌ inakayo inó̱n yej Dios kixitij ka̱n miktoya, ayá̱ꞌ pala̱niꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Nokni̱wa̱n, iní̱n yej nimitzmati̱ltiáj: Jesús wel mitzperdona̱rowiliáj yej ankichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Iley Moisés awel te̱pale̱wiá kua̱ꞌ tikchi̱waj yej aye̱kti, eꞌ Dios te̱perdona̱rowiliá yej tikchijkej yej aye̱kti iga ticre̱dowaj ipan Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Xikchi̱waka̱n iga amo mawi̱ki ipan amejeme̱n yej kijkuilojkej profe̱tajmej, ka̱n kijtojkej ijkí̱n: ");
INSERT INTO nhx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Taꞌ xikitaka̱n amejeme̱n yej ankaja̱wilmatij itájto̱l Dios, ximomajti̱ka̱n, iwá̱n xipoliwíka̱nya; iga nej yej niDio̱s, nikchi̱wa ipan ini̱mej días, yej ayí̱ꞌ ankitaj, este ayá̱ꞌ ankicre̱do̱skej, malej iga agaj mitzpowili̱skej. ");
INSERT INTO nhx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kua̱ꞌ Pablo iwá̱n yej íwa̱n nemiáj ki̱skej ipan itio̱pamej judiyojmej, la gente kitajtanilijkej iga ipan seꞌya día kua̱ꞌ mose̱wilo makita̱tapo̱wi̱ka̱n de inó̱mpasan. ");
INSERT INTO nhx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kua̱ꞌ mojmoya̱wílo̱ꞌya tio̱pan, miaꞌ judiyojmej iwá̱n yej ayéj judiyojmej eꞌ kicre̱dojkej ken tamachtiáj judiyojmej, kitokatiajkij Pablo iwá̱n Bernabé. Iwá̱n yejemej kino̱no̱tzkej iga amo makikajte̱waka̱n iyojwi Dios yej te̱neki. ");
INSERT INTO nhx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Ipan seꞌya semana, ipan día kua̱ꞌ mose̱wilo, monechkoj nochi gente de inó̱n a̱ltepe̱ꞌ iga kikakitoj itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Eꞌ kua̱ꞌ judiyojmej kitakej komati gente nechkatokej, ki̱xitakej iwá̱n pe̱wakej kipo̱powakej Pablo iwá̱n kajajwakej. ");
INSERT INTO nhx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Iwá̱n Pablo iwá̱n Bernabé ayá̱ꞌ majmawikej iga tajtojkej; kijtojkej: —Ye̱kti katka achto amejeme̱n manimitzpowili̱ka̱n itájto̱l Dios, amejeme̱n yej anjudiyojmej; eꞌ ayá̱ꞌ ankikakisnékijoꞌ iwá̱n ayá̱ꞌ ankinekij xonoka̱n ka̱n nochipa onolo̱j wa̱n Dios. Iná̱n niawij nikta̱tapo̱wi̱tij yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Iga ijkó̱n ne̱tekimakakej toTe̱ko, kijtoj: Tej nimitztapejpen iga xikta̱wi nochi yej ayéj judiyojmej, iga xikpowili̱tij nochi yej onoꞌ ipan iní̱n ta̱jli iga mamoma̱nawi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kua̱ꞌ kikakikej yej ayéj judiyojmej pa̱kikej, pe̱wakej kijtojkej iga itájto̱l toTe̱ko pox ye̱kti. Iwá̱n kicre̱dojkej inochi̱n yej ijko̱nya onóyaya iga yejeme̱n yej yawij onotij nochipa wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Iwá̱n ijkó̱n iga itájto̱l Dios mopowaꞌ no̱ya̱n ipan inó̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Eꞌ judiyojmej tajtojkej iwá̱n sekin siwa̱tkej yej kiye̱ꞌitaj iwa̱nkiꞌ kimajmawiliáj Dios. Judiyojmej no̱ tajtojkej iwá̱n tajta̱gaꞌ yej tayaka̱ntokej yej ompa icha̱mej, kitejtekimakakej iga makitalo̱chti̱ka̱n Pablo iwá̱n Bernabé este que maki̱saka̱n ompa. ");
INSERT INTO nhx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Iwá̱n Pablo iwá̱n Bernabé kitzejtzelojkej iyikxita̱lpino̱lmej iga makitaka̱n iga ayompa kichijkej judiyojmej, iwá̱n yajkij asitoj Iconio. ");
INSERT INTO nhx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Eꞌ yej kitokaj Jesús, pox pa̱ktoyaj iwá̱n kipiayaj el Espíritu Santo. ");
INSERT INTO nhx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ipan a̱ltepe̱ꞌ Iconio, Pablo iwá̱n Bernabé senyajkij ipan itio̱pan judiyojmej iwá̱n ta̱tapowakej de Jesús, iwá̱n pox miaꞌ kicre̱dojkej. Kicre̱dojkej no̱ sekin yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Eꞌ judiyojmej yej ayá̱ꞌ kicre̱dojkej Jesús kijijlijkej yej ayéj judiyojmej iga amo makiye̱ꞌitaka̱n yej kitokaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Inó̱n iga Pablo iwá̱n Bernabé wejkajkej iga ompa onoyaj, amajmawikej iga ta̱tapojkej, iga yejeme̱n moconfia̱rojtoyaj ipan toTe̱ko. Iwá̱n toTe̱ko kipale̱wia̱yaj iga mane̱si iga te̱neki Dios, iwá̱n kimáꞌ poder iga kichi̱wayaj miaꞌ milagro. ");
INSERT INTO nhx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Eꞌ la gente yej cha̱ntitokej a̱ltepe̱ꞌ Iconio, yojyokatitoyaj; sekin kitajtowilia̱yaj judiyojmej iwá̱n sekin apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Iwá̱n judiyojmej iwá̱n yej ayéj judiyojmej motajto̱ltijkej iwá̱n yej manda̱rowaj, motajto̱ltijkej iga makajajwaka̱n iwá̱n makitemikti̱ka̱n apo̱stolejmej. ");
INSERT INTO nhx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Eꞌ kimatikej Pablo iwá̱n Bernabé; cholojkej, yajkij a̱ltepe̱mej Listra iwá̱n Derbe, yej onoꞌ ipan íta̱l Licaonia. Nentinemikej ipan a̱ltepe̱tzitzi̱n yej ómpasan najná̱ꞌ onoꞌ, ");
INSERT INTO nhx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ompa no̱ kipojtinenkej itájto̱l Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Ompa Listra kasitoj se̱ ta̱gaꞌ e̱watoꞌ, ko̱xo. Awel nejnemi iga itékiya. ");
INSERT INTO nhx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Kua̱ꞌ Pablo nemi ta̱tapowa, inó̱n ta̱gaꞌ takaktoya. Pablo kitachi̱lij iwá̱n kitaꞌ iga inó̱n ta̱gaꞌ moconfia̱roj iga wel maachitiá. ");
INSERT INTO nhx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Iwá̱n kitzajtzílijpa iga kijlij: —Ximoye̱ꞌketza. Iwá̱n ta̱gaꞌ moketzaꞌ, este tzikui̱niꞌ iwá̱n pé̱waꞌya iga nejnen. ");
INSERT INTO nhx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kua̱ꞌ kitakej yej kichij Pablo, pe̱ꞌ tzajtzikej; tajtojkej ipan itájto̱l yej de Licaonia, kijtojkej: —¡Mataj temójkeja in dio̱smej ken tajta̱gaꞌ! ¡Nija onokej iwá̱n tejeme̱n! ");
INSERT INTO nhx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Iwá̱n Bernabé kito̱ka̱wijkej dios Júpiter, iwá̱n Pablo kito̱ka̱wijkej dios Mercurio, iga yéjwaꞌ in yej tajtowa̱ya. ");
INSERT INTO nhx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Iwá̱n isacerdo̱tej Júpiter yej kipiaya itio̱pan ipansan tate̱n a̱ltepe̱ꞌ, kiwi̱guilijkej to̱rojmej iwá̱n ko̱skamej de xo̱chiꞌ. Iwá̱n sacerdote iwá̱n la gente kinekiáj makiweyimati̱lti̱ka̱n, makimijmiktilí̱ka̱mpa to̱rojmej. ");
INSERT INTO nhx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kua̱ꞌ inó̱n kimatikej apo̱stolejmej Bernabé iwá̱n Pablo, kitza̱tzaya̱nkej itzotzolmej, yajkij ka̱n nechkatokej la gente, este tajkoya̱n, iwá̱n tzajtzikej: ");
INSERT INTO nhx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—¡A̱yo̱mbrej amejeme̱n! ¿Te iga ijkó̱n nemi ankichi̱waj? Esi nejeme̱n no̱ nitajta̱gamej kensan amejeme̱n, inó̱n iga niwa̱lkej nimitzijli̱koj iga xikajte̱waka̱n iga ankichi̱waj yej ajaye̱kti iwá̱n xiktokáka̱nya inó̱n Dios yej isatoꞌ, yej kichij cielo, ta̱jli iwá̱n láma̱r iwá̱n nochi yej onoꞌ ipan iní̱n ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ikya Dios kisemáꞌ nochi gente iga manemika̱n ken yejemej kinekij, ");
INSERT INTO nhx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","malej iga nochipa te̱ne̱xtilia̱yaj a̱ꞌyéj in yéj iga te̱chi̱wilia̱yaj yej ye̱kti. Dios te̱wetzi̱ltiliá kiawa̱ꞌ iga mamochi̱wa yej tikto̱kaj. Te̱maka komati yej matikua̱ka̱n iga matipa̱kika̱n. ");
INSERT INTO nhx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Eꞌ malej apo̱stolejmej ijkó̱n kijtojkej, alí̱n poliwiá iga awel kika̱waltia̱yaj iga makimikti̱ka̱n to̱rojmej iga makiweyimati̱lti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Iwá̱n asikej sekin judiyojmej de Antioquía iwá̱n de Iconio, ino̱mej kiyo̱lyama̱nkej la gente yej ompa icha̱mej iga makitemikti̱ka̱n, iwá̱n kitewijkej Pablo. Yejemej kijtojkej anka kimiktíjkeja iwá̱n kiwawatatzojkej, kiki̱xtijkej ipan a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kua̱ꞌ yej kitokaj Jesucristo kiyawalojkej Pablo, yéj moketzaꞌ iwá̱n yajki sej ipan a̱ltepe̱ꞌ. Kua̱ꞌ tane̱siꞌ, Pablo iwá̱n Bernabé yájkija a̱ltepe̱ꞌ Derbe. ");
INSERT INTO nhx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Kua̱ꞌ kipójkeja itájto̱l Jesús ipan a̱ltepe̱ꞌ Derbe, ompa miaꞌ kicre̱dojkej. Iwá̱n yajkij sej a̱ltepe̱mej Listra, Iconio iwá̱n Antioquía. ");
INSERT INTO nhx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ompa kanima̱rojtinenkej tokni̱wa̱n yej kitokaj Jesús, kijlijtinenkej iga nochipa mamoconfia̱ro̱ka̱n pan toTe̱ko; kijlijkej iga poxsan kikno̱chi̱waskej iga wel makalakika̱n ka̱n reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Iwá̱n no̱ kita̱lkej ancia̱nojmej yej mamanda̱ro̱ka̱n sejsé̱ ka̱n monechkowaj yej kitokaj Jesucristo. Kua̱ꞌ támiꞌya ora̱dojkej iwá̱n mayuna̱rojkej, kikajtéjkeja ipan ima̱ꞌ toTe̱ko yej ípan kicre̱dojkej. ");
INSERT INTO nhx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","No̱ panojkej pan estado de Pisidia iwá̱n asikej ipan estado de Panfilia. ");
INSERT INTO nhx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Kipojkej itájto̱l Jesucristo ipan a̱ltepe̱ꞌ Perge, iwá̱n yájkija a̱ltepe̱ꞌ Atalia. ");
INSERT INTO nhx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ompa tejkajkej ipan weyi á̱ka̱l iga mokuepkej sej a̱ltepe̱ꞌ Antioquía. Ipan inó̱n a̱ltepe̱ꞌ, tokni̱mej yej kitokaj Jesucristo kiti̱tankej Pablo wa̱n Bernabé iga maya̱ka̱n wejka iga makipowatij itájto̱l Dios, iwá̱n kitajtanilijkej Dios iga makicuida̱ro̱ka̱n. Inó̱n ve̱j tamiꞌ kichijkej inó̱n tekipáno̱l, inó̱n iga mokuepkej sej. ");
INSERT INTO nhx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kua̱ꞌ Pablo wa̱n Bernabé asikej Antioquía, kinechkojkej yej kitokaj Jesucristo iwá̱n kipowilijkej nochi ken Dios kichij iwá̱n yejeme̱n, iwá̱n kén iga Dios kichij iga yej ayéj judiyojmej no̱ makicre̱do̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Iwá̱n Pablo iwá̱n Bernabé wejkajkej iga ompa onoyaj iwá̱n tokni̱wa̱n yej kitokaj Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Inó̱n tiempo asikej Antioquía sekin tajta̱gaꞌ yej wa̱lkej ipan ta̱jli de Judea. Ijkí̱n kijlijkej yej kitokaj Jesucristo: —Awel anmoma̱nawi̱skej siga ayá̱ꞌ anmocircuncida̱ro̱skej ijkó̱n ken tatekimaka iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo iwá̱n Bernabé mote̱nki̱tzkijkej iwá̱n ino̱mej yej wa̱lkej Judea. Después Pablo iwá̱n Bernabé iwá̱n sekin tokni̱wa̱n kitapejpenkej iga maya̱ka̱n Jerusalén iga matajto̱tij iwá̱n apo̱stolejmej iwá̱n yej iyancia̱nojmej ino̱mej yej kicre̱dowaj Jesucristo ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Tokni̱wa̱n yej kitokaj Jesús yej cha̱ntitokej Antioquía, kiti̱tankej; wa̱n kua̱ꞌ panojkej ipan ita̱lmej Fenicia iwá̱n Samaria kipojkej ken iga yej ayéj judiyojmej kikajtejkej ken ikya kichi̱wayaj iga kitokákeja Dios. Iwá̱n kua̱ꞌ inó̱n kikakiáj tokni̱wa̱n yej kitokaj Jesús, poxsan pa̱kikej. ");
INSERT INTO nhx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Kua̱ꞌ Pablo iwá̱n Bernabé asikej Jerusalén ki‑o̱mema̱wijkej yej kitokaj Jesús, apo̱stolejmej iwá̱n ancia̱nojmej. Pablo iwá̱n Bernabé kipojkej nochi yej Dios kichij iwá̱n yejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Eꞌ sekin fariseojmej yej no̱ kicre̱dojtokej Jesús, moketzkej iwá̱n kijtojkej: —No̱ mamocircuncida̱ro̱ka̱n yej kicre̱dowaj Jesús yej ayéj judiyojmej iwá̱n mamotekimaka iga makichi̱waka̱n ken kijtowa iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Iwá̱n monechkojkej apo̱stolejmej iwá̱n ancia̱nojmej iga tajtojkej de inó̱n. ");
INSERT INTO nhx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kua̱ꞌ wéjkaja iga ta̱tapowakej, Pedro moketzaꞌ, iwá̱n kijtoj: —Nokni̱wa̱n, amejeme̱n ankimátija ken iga Dios ikya ne̱tapejpen iga manikpowili yej ayéj judiyojmej ye̱ꞌnoti̱ciaj yej tasalva̱rowa iga no̱ makicre̱do̱ka̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Iwá̱n Dios, yej ki̱xmati nochi iya̱lmaj, tane̱xtilij iga no̱ kinekij ino̱mej gente iwá̱n kimakakej iyEspí̱ritoj kensan tejeme̱n no̱ te̱makakej. ");
INSERT INTO nhx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios ayá̱ꞌ tejéme̱nsan te̱ye̱ꞌita, no̱ yejeme̱n kiye̱ꞌitaj. Iga yejeme̱n moconfia̱rojkej ipan Jesús, kajkej ken tikita yej ayá̱ꞌ kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Iná̱n, ¿te iga ayá̱ꞌ ankitawelcre̱dowaj yej Dios kichij, iwá̱n ankitekimakaj tokni̱mej yej kitokaj Jesús iga makichi̱waka̱n yej niga tejemej awel tikchi̱waj, niga to‑ikyapatajwa̱n awel kichijkej? ");
INSERT INTO nhx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma̱jwaꞌ tejemej ticre̱dowaj iga toTe̱ko Jesús te̱ma̱nawij iga te̱poxneguiꞌ, ayéj iga tikixta̱waj; ijko̱nsan no̱ yejeme̱n moma̱nawiáj iga kicre̱dowaj. ");
INSERT INTO nhx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Iwá̱n ayagaj tajtoj. Tajtakaktikajkej kua̱ꞌ pe̱ꞌ ta̱tapowakej Bernabé iwá̱n Pablo. Kipojkej kén iga Dios kipale̱wijkej iga makichi̱waka̱n mila̱grojmej ipan ino̱mej yej ayéj judiyojmej iga mami̱xkui̱ti̱ka̱n iwá̱n makicre̱do̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kua̱ꞌ tamiꞌ ta̱tapowakej Bernabé iwá̱n Pablo, Jacobo kijtoj: —Nokni̱wa̱n, taꞌ xine̱kakika̱n: ");
INSERT INTO nhx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Pedro te̱powilij kén iga Dios achto ve̱j ki‑omemawij ino̱mej yej ayéj judiyojmej iga no̱ mamochi̱waka̱n itatki. ");
INSERT INTO nhx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iní̱n nemi mochi̱wa ijkó̱n ken kijkuilojkej profe̱tajmej. Ijkí̱n kijtowa ka̱n ijkuilijtoꞌ: ");
INSERT INTO nhx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Nej amote̱ko Dios, iwá̱n niwi̱ꞌ sej. Nikchi̱was iga marreina̱roj sej se̱ ipiltzi̱n yej ipilówa̱mpa David. ");
INSERT INTO nhx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Iga nochi mane̱te̱mo̱ka̱n, iga yej ayéj judiyojmej makite̱ne̱wi noto̱ka̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ijkó̱n kijtowa toTe̱ko, yej desde ikyay kijtoj iga mochi̱was. ");
INSERT INTO nhx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jacobo no̱ kijtoj: —Inó̱n iga nej nikijtowa iga yej ayéj judiyojmej amo matiktekimakaka̱n iga makichi̱waka̱n yej akipale̱wiáj; yejemej kikajtéjkeja yej ikya kichi̱waya iga kitókaja Dios. ");
INSERT INTO nhx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ma̱jwaꞌ matikijkuilowili̱ka̱n iga amo makikua̱ka̱n nakaꞌ yej momiktiliapa i̱dolojmej, iwá̱n amo agaj mamasi iwá̱n yej ayá̱ꞌ iwá̱n na̱miktitoꞌ, iwá̱n amo makikua̱ka̱n inakayo yo̱lka̱mej yej mokechmeká̱najpa, iwá̱n amo no̱ makikua̱ka̱n esti. ");
INSERT INTO nhx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Porque desde ikya onoꞌ ipan sejsé̱ a̱ltepe̱ꞌ yej tane̱xtiliá ken ijkuilijtoꞌ ipan iley Moisés, cada día kua̱ꞌ mose̱wilo molee̱rowa ipan itio̱pamej judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Apo̱stolejmej iwá̱n ancia̱nojmej iwá̱n nochi yej kitokaj Jesucristo kijtojkej iga mamotapejpena sekin de yejéme̱mpasan iga masenyaka̱n Antioquía iwá̱n Pablo iwá̱n Bernabé. Iwá̱n kitapejpenkej Judas, yej ito̱ka̱ꞌ no̱ Barsabás, no̱ kitapejpenkej Silas. Yejeme̱n achi má̱j tayaka̱ntokej ipan yej kitokaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Iwá̱n yejeme̱n kiwi̱gakej a̱maꞌ, ijkí̱n kijtowa: “Nejemej apo̱stolejmej, ancia̱nojmej iwá̱n amokni̱wa̱n yej no̱ kitokaj Jesús, nimitzti̱taniliáj saludos amejeme̱n anokni̱wa̱n yej ayéj anjudiyojmej, yej ancha̱ntitokej Antioquía iwá̱n yej ancha̱ntitokej ipan ita̱lmej Siria iwá̱n Cilicia. ");
INSERT INTO nhx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nikmatikej iga yájkajkiꞌ ompiga sekin de nijpamej, eꞌ ayéj nejemej nikti̱tankej. Yajkij mitzyo̱lpatatoj iga mitzijli̱toj iga ximocircuncida̱ro̱ka̱n wa̱n xikchijtoka̱n ken kijtowa iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nejeme̱n nita̱tapowakej, iwá̱n nikye̱ꞌitakej iga niktapejpenkej sekin yej kitokaj Jesús yej yawij mitzitatij, senyawij iwá̱n tokni̱mej yej nikpoxnekij, Bernabé iwá̱n Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ini̱mej tajta̱gaꞌ kisenta̱lkej iya̱lmajmej malej ka̱naj kimijti̱jnékija iga kitokaj toTe̱ko Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Inó̱n iga nimitzti̱taniliáj Judas iwá̱n Silas. Yejemej ima̱tikamej yawij mitzta̱tapo̱wi̱tij de iní̱n yej nimitzijlijkej. ");
INSERT INTO nhx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Iyespí̱ritoj Dios ne̱ne̱xtilijkej iwá̱n nejemej nikye̱ꞌitaj iga amo mamitztekimakaka̱n iga xikchi̱waka̱n nochi yej tatekimaka iley Moisés, xikchi̱wáka̱nsan iní̱n yej niawij nimitzijli̱tij: ");
INSERT INTO nhx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ayoꞌ xikua̱ka̱n nakaꞌ yej momiktiliajpa i̱dolojmej, iwá̱n amo no̱ xikua̱ka̱n esti, niga inakayo no̱ anímal yej mokechmeká̱napa, iwá̱n amo agaj mamasi iwá̱n yej ayá̱ꞌ íwa̱n na̱miktitoꞌ. Siga ankichi̱waj ken nimitzijliáj, anye̱ꞌnemiskej. Xiye̱ꞌonoka̱n.” ");
INSERT INTO nhx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Iwá̱n ino̱mej yej kitapejpenkej yajkij Antioquía, ompa kinechkojkej tokni̱mej yej kitokaj Jesucristo iwá̱n kimakakej a̱maꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Kua̱ꞌ yej kitokaj Jesús kilee̱rojkej inó̱n a̱maꞌ, poxsan yo̱lpa̱kikej iga kiyo̱lchikajkej. ");
INSERT INTO nhx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Wa̱n como Judas iwá̱n Silas no̱ profe̱tajmej, kanima̱rojkej iwá̱n kiyo̱lchikajkej yej kitokaj Jesús kua̱ꞌ kita̱tapo̱wijkej. ");
INSERT INTO nhx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kua̱ꞌ ino̱mej yej wa̱lkej Jerusalén wejkájkeja iga onokej Antioquía, yej kitokaj Jesús kinawatijkej iga maye̱ꞌya̱ka̱n sej ka̱n onokej yej kiti̱tankej. ");
INSERT INTO nhx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Eꞌ Silas kijtoj iga maká̱wi‑oꞌ ompa. ");
INSERT INTO nhx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","No̱ Pablo iwá̱n Bernabé ka̱wikej Antioquía. Yejeme̱n wa̱n komati tokni̱mej tamachtijkej itájto̱l toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Kua̱ꞌ acha̱ wejkatiꞌ iga ompa onokej, Pablo kijlij Bernabé: —Matia̱ka̱n matikpaxa̱lowili̱tij yej kitokaj Jesús no̱ya̱n ipan a̱ltepe̱mej kajka̱n tikpojkej itájto̱l toTe̱ko iga matikitaka̱n ken onokej. ");
INSERT INTO nhx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Iwá̱n Bernabé kinekiá iga mayawi no̱ Juan, yej ito̱ka̱ꞌ no̱ Marcos; ");
INSERT INTO nhx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","eꞌ Pablo ayá̱ꞌ kineꞌ iga mayawi Marcos iwa̱mej, iga Marcos ikya takajtej ipan ta̱jli de Panfilia, ayꞌya tapale̱wij iga kipowaj itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Iwá̱n awel motajto̱lkui̱lijkej iwá̱n moka̱kajtejkej. Bernabé yájkisan iwá̱n Marcos. Tejkajkej ipan weyi á̱ka̱l iga yajkij tajkóta̱l Chipre, ");
INSERT INTO nhx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","eꞌ Pablo kitapejpen Silas. Iwá̱n yej kitokaj Jesús kitajtanilijkej toTe̱ko iga maye̱ꞌya̱ka̱n iwá̱n makipale̱wi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Iwá̱n panojkej ipan ta̱jli de Siria iwá̱n Cilicia iga kanima̱rojtinenkej kajka̱n monechkowaj tokni̱wa̱n yej kitokaj Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo iwá̱n Silas asikej ipan a̱ltepe̱mej yej ito̱ka̱ꞌ Derbe iwá̱n Listra, ompa kasikej se̱ yej ito̱ka̱ꞌ Timoteo yej no̱ kitoka Jesús, ipiltzi̱n se̱ siwa̱ꞌ judía yej no̱ kitoka Jesús, eꞌ itaj irrá̱zajpa griego. ");
INSERT INTO nhx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Iwá̱n tokni̱wa̱n de Listra iwá̱n de Iconio ye̱ꞌtajtowa̱yaj de Timoteo. ");
INSERT INTO nhx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo kineꞌ iga Timoteo mayawi iwá̱n, eꞌ achto kicircuncida̱roj iga makiye̱ꞌitaka̱n judiyojmej yej de ompígapa, iga nochi kimatiáj iga itaj Timoteo irrá̱zajpa griego. ");
INSERT INTO nhx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Iwá̱n kajka̱n pano̱tia̱yaj ipan a̱ltepe̱mej, kijlia̱yaj iga makichi̱waka̱n tokni̱wa̱n kensan kijtojkej apo̱stolejmej iwá̱n ancia̱nojmej yej onokej Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iwá̱n tokni̱wa̱n yej kitokaj Jesús kimelaꞌsenta̱lijkej iya̱lmajmej ipan yéj, iwá̱n cada día má̱j komatiayaj. ");
INSERT INTO nhx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","IyEspí̱ritoj Dios akimakaltij iga mamopowa itájto̱l Dios ipan el estado de Asia. Inó̱n iga panojkej ipan estado de Frigia iwá̱n estado de Galacia. ");
INSERT INTO nhx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Iwá̱n asikej ka̱n tantoꞌ estado de Misia. Kejla̱nkej iga maya̱ka̱n estado de Bitinia, eꞌ iyEspí̱ritoj Jesús akimakaltij iga maya̱ka̱n ompiga. ");
INSERT INTO nhx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Iwá̱n sanpanojkej Misia iwá̱n asikej a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Troas ka̱n moketza a̱ka̱lmej. ");
INSERT INTO nhx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ompa tayowaka̱n Pablo kitaꞌ se̱ visión. Kitaꞌ iga ejkatoꞌ se̱ ta̱gaꞌ del estado de Macedonia, kijlij: “Xaj Macedonia iga xine̱pale̱wi̱tij.” ");
INSERT INTO nhx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kua̱ꞌ Pablo kitaꞌ inó̱n visión, nimaní̱n nimajabia̱rojkej, iga nikmatikej iga Dios nemi ne̱no̱tzaj iga ompiga manikpowatij itájto̱l Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ompa Troas nitejkajkej ipan weyi á̱ka̱l iga niajkij ipan tajkóta̱l yej ito̱ka̱ꞌ Samotracia. Iwá̱n ipan seꞌya día nasikej a̱ltepe̱ꞌ Neápolis. ");
INSERT INTO nhx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De ompa niajkij Filipos, inó̱n weyi‑a̱ltepe̱ꞌ yej onoꞌ ipan estado de Macedonia, ompa ayá̱ꞌ nipoxwejkajkej. ");
INSERT INTO nhx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Se̱ día kua̱ꞌ mose̱wilo, niki̱skej ipan weyi‑a̱ltepe̱ꞌ iwá̱n niajkij ipan a̱te̱n ka̱n nochipa ora̱do̱lo. Nimotajta̱lkej, iwá̱n nikpowilijkej itájto̱l Jesucristo siwa̱tkej yej ompa monechkojkej. ");
INSERT INTO nhx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Iwá̱n ompa onoya se̱ siwa̱ꞌ yej wa̱laj a̱ltepe̱ꞌ Tiatira yej ito̱ka̱ꞌ Lidia, yej kinamakaya a̱xokotzótzol yej este xolaktiꞌ. Inó̱n siwa̱ꞌ no̱ kiweyimati̱ltia̱ya Dios. Takaktoya, iwá̱n toTe̱ko kichij iga inó̱n siwa̱ꞌ makitajto̱lkui Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Iwá̱n mobautiza̱roj iwá̱n inochi ifami̱liaj. Después kineꞌ mania̱ka̱n icha̱n; ne̱tekiꞌijlijkej: —Siga ankitaj iga nicré̱doja toTe̱ko Jesús, xa̱ka̱n nocha̱n iwá̱n ompa xika̱wika̱n. Iwá̱n ne̱tekiꞌijlijkej iga ompa manika̱wika̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Iwá̱n se̱ día kua̱ꞌ nemi nia̱yaj ka̱n ni‑ora̱do̱tij, nimasikej iwá̱n se̱ takotzi̱n yej kipiaya espíritu yej tane̱xtilia̱ya yej mochí̱wasoꞌ. Kipiaya ite̱komej yej kikojtoyaj. Iga takotzi̱n taadivina̱rowa̱ya ite̱komej kita̱nia̱yaj komati tomi̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Inó̱n takotzi̱n ne̱tokatia̱yaj ka̱n nemi nia̱yaj iwá̱n Pablo; kijtojtia̱ya recio: —Ini̱mej tajta̱gaꞌ yej kiservi̱rowaj melaꞌDio̱s yej onoꞌ pox ajko, yejeme̱n mitzijliáj katiapa ojti xiktokaka̱n iga ximosalva̱ro̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ijkó̱n kichijtoya miaꞌ días este que Pablo kuejkuesiwiꞌ, iwá̱n kijlij inó̱n espíritu yej onoya ipan inó̱n takotzi̱n: —Nimitztekimaka ipan ito̱ka̱ꞌ Jesucristo iga xiki̱sa ipan iní̱n takotzi̱n. Iwá̱n íkua̱ꞌsan ki̱saꞌ inó̱n espíritu. ");
INSERT INTO nhx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kua̱ꞌ ite̱komej inó̱n takotzi̱n kitakej iga ayꞌya wel kitata̱nili̱skej, kiki̱tzkijkej Pablo iwá̱n Silas, iwá̱n kiwi̱gakej tajkoa̱ltepe̱ꞌ, ka̱n onoꞌ yej manda̱rowaj. ");
INSERT INTO nhx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kua̱ꞌ asíkeja iyi̱xtaj jue̱zmej, kijtojkej: —Ini̱mej judiyojmej nemi kikuejkuesowaj toge̱ntej. ");
INSERT INTO nhx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Iwá̱n tane̱xtiliáj iga mamochi̱wa ken yejemej kichi̱waj, inó̱n tejeme̱n awel tikchi̱waj iga tejemej tirroma̱nojmej. ");
INSERT INTO nhx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Iwá̱n la gente ki‑onkawijkej Pablo iwá̱n Silas. Iwá̱n yej manda̱rowaj tatekimakakej iga makiki̱xtili̱ka̱n itzotzolmej iwá̱n makimagaka̱n iga kuatako̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Kua̱ꞌ póxsanya kimagakej, kakijkej ipan cárcel. Iwá̱n yej kicuida̱rowa pre̱sojmej kijlijkej iga makiye̱ꞌcuida̱ro̱ka̱n iga amo cholo̱skej. ");
INSERT INTO nhx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kua̱ꞌ inó̱n kikáꞌ yej kicuida̱rowa pre̱sojmej, yajki kaki̱toj ka̱n má̱j ta‑ijtiꞌ ipan cárcel, kijikxi‑ilpijkej iga cadena ipan kuawiꞌ yej pox eti̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Eꞌ tajkoyówal, Pablo iwá̱n Silas ora̱dojtoyaj iwá̱n kitakui̱kilijtoyaj Dios, iwá̱n sekin pre̱sojmej yej ompa onoyaj takaktoyaj, ");
INSERT INTO nhx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","iwá̱n paré̱j we̱jmo̱li̱nako ta̱jli. Iwá̱n mojo̱li̱nkej itaketzalyomej cárcel. Iwá̱n íkua̱ꞌ tapowikej nochi kalte̱mej, iwá̱n xijxitomikej nochi cadena yej iga ijilpitoyaj pre̱sojmej. ");
INSERT INTO nhx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kua̱ꞌ isate̱waꞌ yej kicuida̱rowa pre̱sojmej, kitaꞌ iga tapójtoꞌya cárcel, iwá̱n kiki̱xtij iyespa̱daj, momiktiá̱yaya, iga yéj kijtoj anka cholójkeja pre̱sojmej. ");
INSERT INTO nhx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Eꞌ Pablo kitzajtzilij: —Amo ximomikti, nigaj nonokej nonochi̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Iwá̱n yej kicuida̱rowa̱ya pre̱sojmej kitajtan tiꞌti, iwá̱n motalojtikalakito ka̱n onokej Pablo iwá̱n Silas, kuekuechkatiajki, motankua̱ketzato ite̱nojmej. ");
INSERT INTO nhx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Iwá̱n kiki̱xtij Pablo iwá̱n Silas, iwá̱n yej kicuida̱rowa cárcel tatajtan: —¿Té̱ nikchi̱was iga manimosalva̱ro iga Dios amo mane‑ikno̱chi̱wa? ");
INSERT INTO nhx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yejemej kijtojkej: —Xicre̱do toTe̱ko Jesucristo iwá̱n timosalva̱ro̱j, tej, mosiwa̱ꞌ wa̱n mopilowa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Iwá̱n kipowilijkej itájto̱l Dios inó̱n yej kicuida̱rowa pre̱sojmej iwá̱n inochi̱n no̱ yej onokej ompa ícha̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Iwá̱n ino̱nsan yówal inó̱n yéj kicuida̱rowa pre̱sojmej kipa̱kilij ikajlo̱ꞌ Pablo iwá̱n Silas ka̱n kimagakej. Después mobautiza̱roj iwá̱n nochi yej onoꞌ icha̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Iwá̱n kiwi̱gaꞌ ícha̱n kitamakatoj. Inó̱n yej kicuida̱rowa pre̱sojmej iwá̱n inochi yej onoꞌ icha̱n pa̱kikej iga kicre̱dójkeja Dios. ");
INSERT INTO nhx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kua̱ꞌ tané̱siꞌya, yej manda̱rowaj kiti̱tankej policiyajmej iga kijli̱toj yej kicuida̱rowa pre̱sojmej iga makimajka̱waka̱n Pablo iwá̱n Silas. ");
INSERT INTO nhx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Iwá̱n yej kicuida̱rowa pre̱sojmej kijlij Pablo: —Yej manda̱rowaj ne̱tekimakakej iga manimitzmajka̱waka̱n. Iwá̱n welja anye̱ꞌyawij. ");
INSERT INTO nhx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Eꞌ Pablo kijlij policiyajmej: —Nejeme̱n niciudada̱nojmej romano. Iwá̱n iyi̱xtaj la gente ne̱yokamagakej iwá̱n neakijkej ipan cárcel kua̱ꞌ aya mojtowa siga ayompa nikchijkej. ¿Iwá̱n iná̱n kinekij mane̱majka̱waka̱n ichtákasan? ¡Ijkó̱n awel! Mawi̱tzeka̱n yejemej iga mane̱ki̱xti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Iwá̱n policiyajmej inó̱n yajkij kijli̱toj yej manda̱rowaj. Kua̱ꞌ yej manda̱rowaj kimatikej iga Pablo iwá̱n Silas no̱ ciudada̱nojmej romano, majmawikej. ");
INSERT INTO nhx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iwá̱n yej manda̱rowaj yajkij kitatoj Pablo iwá̱n Silas iga kijli̱toj iga amo makiwelkui̱li̱ka̱n iga kipre̱sojwijkej. Kijlijkej iga maki̱sáka̱nya ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Kua̱ꞌ ki̱skej ipan cárcel, yajkij cha̱n Lidia. Ompa ta̱tapojkej iwá̱n tokni̱wa̱n iga kanima̱rojkej, iwá̱n yájkija. ");
INSERT INTO nhx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo iwá̱n Silas panojkej ipan a̱ltepe̱mej yej ito̱ka̱ꞌ Anfípolis iwá̱n Apolonia. Iwá̱n asikej Tesalónica. Ompa onoya se̱ itio̱pan judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo, ken iga nochipa kichi̱waya, yajki tio̱pan iga ta̱tapowatoj iwá̱n ino̱mej gente. E̱yi semanas ijkó̱n kichijtoya cada día kua̱ꞌ mose̱wilo. ");
INSERT INTO nhx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kua̱ꞌ ta̱tapowaya, itájto̱l kitaksaltia̱ya ka̱n ijkuilijtoꞌ itájto̱l Dios, ka̱n kijtowa iga Cristo yawi kikno̱chi̱watij iwá̱n yawi mikiti iwá̱n yawi sej ojpa‑isati. Pablo kijlijkej: —Ini̱nsan Jesús yej nemi nimitzijliáj, yéjyawaꞌ in Cristo. ");
INSERT INTO nhx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Iwá̱n sekin judiyojmej kicre̱dojkej iwá̱n senemikej iwá̱n Pablo iwá̱n Silas. No̱ kicre̱dojkej miaꞌ grie̱gojmej yej kiweyimati̱ltiáj Dios. Iwá̱n no̱ kicre̱dojkej miaꞌ siwa̱tkej yej tayaka̱ntokej ipan inó̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Eꞌ judiyojmej yej akicre̱dowa̱yaj ipan Jesús ta‑i̱xitakej, iwá̱n kite̱mojkej tajta̱gaꞌ yej ayá̱ꞌ ye̱ꞌnemij yej akipiáj te̱ kichi̱waj, kinechkojkej miaꞌ gente de inó̱n a̱ltepe̱ꞌ iga kiyokachijkej iga o̱o̱yowaj iwá̱n iga takuejkuesowaj. Iwá̱n yajkij cha̱n Jasón iga makiki̱xti̱ka̱n Pablo iwá̱n Silas iga makiwi̱gaka̱n iyi̱xtaj la gente. ");
INSERT INTO nhx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Eꞌ como ayá̱ꞌ kasikej ompa, kiwawatatzojtiajkij Jasón iwá̱n sekin tokni̱mej iyi̱xtaj yej manda̱rowaj ipan inó̱n a̱ltepe̱ꞌ; ijkí̱n tzajtzikej: —Pablo wa̱n Silas tayojyo̱lxelojtinemij no̱ya̱n ipan iní̱n ta̱jli, iná̱n este nígaja no̱ asikej, ");
INSERT INTO nhx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","iwá̱n Jasón ki‑o̱me̱ma̱wij icha̱n. Nochi yejemej ayá̱ꞌ kichi̱waj ken tatekimaka torre̱y César, iga kijtowaj iga onoꞌ seꞌ rey yej ito̱ka̱ꞌ Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kua̱ꞌ iní̱n kikaguiꞌ la gente iwá̱n yej manda̱rowaj este yo̱lchichi̱yakej. ");
INSERT INTO nhx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Eꞌ Jasón iwá̱n sekin kixtajkej iga wel makimajka̱wáka̱noꞌ iwá̱n kimajkajkej. ");
INSERT INTO nhx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Iwá̱n tayowaka̱n yej kitokaj Jesús nimaní̱n kiki̱xtijkej Pablo iwá̱n Silas iga maya̱ka̱n Berea. Kua̱ꞌ asitoj ompiga yajkij itio̱pan judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ini̱mej judiyojmej poxsan te‑ijikni̱mej ayéj ken de Tesalónica, iga yo̱lpa̱kikej iga kicre̱dojkej yej kipowaꞌ Pablo, iwá̱n nochipa momachtia̱yaj ipan itájto̱l Dios iga makimatika̱n siga ijko̱nya ken kine̱xtilijkej. ");
INSERT INTO nhx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ijkó̱n iga miaꞌ judiyojmej kicre̱dojkej, iwá̱n no̱ miaꞌ tajta̱gaꞌ iwá̱n siwa̱tkej yej tayaka̱ntokej yej irrá̱zajpa griego. ");
INSERT INTO nhx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Eꞌ kua̱ꞌ judiyojmej de Tesalónica kimatikej iga Pablo no̱ nemi kipowa itájto̱l Dios ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Berea, yajkij ompiga iga kijichtakawi̱toj la gente iga amo makiye̱ꞌitaka̱n Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Eꞌ tokni̱wa̱n kiti̱tankej Pablo iga mayawi lama̱rte̱noj, mie̱j Silas iwá̱n Timoteo ka̱wíkejoꞌ Berea. ");
INSERT INTO nhx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Yej kojmakatoj Pablo kika̱watoj este ipan a̱ltepe̱ꞌ Atenas. Iwá̱n ompay mokuepkej; Pablo kijlij yej kojmakatoj iga makijli̱ka̱n Silas iwá̱n Timoteo iga sémiya ompígaya makasitij. ");
INSERT INTO nhx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mie̱j Pablo kichi̱xtoya Silas iwá̱n Timoteo ipan a̱ltepe̱ꞌ Atenas, tatatzkay iya̱lmaj iga ompa kitaꞌ poxsan i̱dolojmej. ");
INSERT INTO nhx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Inó̱n iga kita̱tapo̱wia̱yaj judiyojmej ipan itio̱pan, iwá̱n ompa no̱ kita̱tapowia̱yaj sekin yej kiweyimatiáj Dios. Iwá̱n nochipa kita̱tapowia̱ya gente yej monechkowa̱yaj plaza. ");
INSERT INTO nhx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Iwá̱n sekin yej momachtia̱yaj yej kijlia̱yaj epicúreos, iwá̱n sekin yej momachtia̱yaj yej kijlia̱yaj estoicos, pe̱waꞌ ta̱tapowakej iwá̱n Pablo. Kijtowa̱yaj: —¿Ix te̱ a̱n te‑ijli̱jneki in iní̱n ta̱gaꞌ yej pox tajtowa? Iwá̱n sekin kijtowa̱yaj: —Ne̱si ken te̱powiliá de séꞌpaya dio̱smej. Ijkó̱n kijtojkej iga Pablo kita̱tapo̱wia̱yaj itájto̱l Jesús iwá̱n kijtowa̱ya no̱ iga ojpa‑isalo. ");
INSERT INTO nhx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Iwá̱n kiwi̱gakej ka̱n kito̱ka̱wiáj Areópago, ka̱n nochipa monechkowa̱yaj sekin yej tamachtia̱yaj, iwá̱n kitajtankej Pablo: —¿Ix wel nikmatiskej te̱ iteki yej nemo̱ꞌ anne̱ne̱xtiliáj? ");
INSERT INTO nhx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Iga nemi anne̱powiliáj yej ayi̱ꞌpa nokta nikakij, iwá̱n niknekij manikmatika̱n té̱ nokta kijto̱jneki. ");
INSERT INTO nhx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Iga nochi yej icha̱n Atenas iwá̱n ti̱ltikmej yej ompa cha̱ntitoyaj poxsan kiyo̱lmakayaj iga makikakika̱n yej áyapa i̱ꞌ mokaki. ");
INSERT INTO nhx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Iwá̱n Pablo moketzaꞌ iyi̱xtaj yej monechkojkej iwá̱n kijtoj: —Amejeme̱n de Atenas, nej nikita iga poxsan ankicre̱dojtokej ipan dio̱smej. ");
INSERT INTO nhx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Kua̱ꞌ nej nipanoj iwá̱n nitacháꞌ ka̱n amejeme̱n anmonechkowaj iga ankiweyimati̱ltiáj amodio̱smej, nikasiꞌ no̱ se̱ altar ka̱n ijkuilijtoꞌ iní̱n tájto̱l: “DIOS YEJ AYÁ̱ꞌ MO‑I̱XMATI”. Pues de inó̱n Dios yej amejeme̱n ankiweyimati̱ltiáj malej iga ayá̱ꞌ anki̱xmatij, inó̱nyawaꞌ nokta nemi nimitzpowiliáj. ");
INSERT INTO nhx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Dios yej kichij iní̱n ta̱jli iwá̱n nochi yej onoꞌ ípan, yéj itatki cielo iwá̱n ta̱jli. Ayá̱ꞌ mocha̱ntiá ipan tio̱pamej yej tajta̱gaꞌ kichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Yéj akipolowa nité̱ iga matikpale̱wi̱ka̱n. Iga yejwaꞌ in yej kichi̱wa iga matonoka̱n iwá̱n wel matimijnelti̱ka̱n iwá̱n yéj te̱maka nochi yej tejemej tikpiáj. ");
INSERT INTO nhx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Ipan se̱ ta̱gaꞌ Dios kichij iga mapi̱wilo no̱ya̱n ipan iní̱n ta̱jli. Iwá̱n yéj kijtoj ke̱man se̱ nación yawi onoti iwá̱n ka̱n yawij mocha̱nti̱tij. ");
INSERT INTO nhx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Dios ijkó̱n kichij iga makite̱mo̱ka̱n malej ken tama̱ma̱te̱mojtinémijpa iga makasika̱n, malej iga Dios ayá̱ꞌ wejka onoꞌ ipan sejsé̱ de tejemej. ");
INSERT INTO nhx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Iga Dios tonokej, tinejnemij, iwá̱n tonoskej. Achi ijkó̱n kíjtoja se̱ yej de amejéme̱mpa yej wel kichi̱wa mo̱nsajtájto̱l, kijtoj: “Tejeme̱n no̱ ipilowa̱n Dios.” ");
INSERT INTO nhx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Siga tejeme̱n ipilowa̱n Dios, awel tikuiskej iga toDio̱smej tejté̱ yej chijtoꞌ de oro o de plata o de teꞌti, yej kichi̱wa ta̱gaꞌ kensan yéj kejla̱miki. ");
INSERT INTO nhx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Desde ikyay Dios ayá̱ꞌ kikno̱chij la gente ken iga kajasiá iga yejemej aya kimatiáj itájto̱l. Eꞌ iná̱n tatekimaka iga nochi gente no̱ya̱n ka̱n onolo̱ꞌ, makikajte̱waka̱n iga kichijtokej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Iga Dios kitapejpen se̱ día kua̱ꞌ yawi kijuzga̱ro̱ti inochi gente kensan iga kichijkej. Dios kitapéjpenya se̱ ta̱gaꞌ yej yawi tajuzga̱ro̱ti, inó̱n mone̱xtij kua̱ꞌ ki‑ojpa‑ixitij ka̱n miktoya. ");
INSERT INTO nhx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kua̱ꞌ kikakikej iga ojpa‑isaj yej miktokej, sekin kaja̱wilmatikej iwá̱n sekin kijtowa̱yaj: —Anka seꞌ día niawij nimitzkakitij de ini̱nsan sej. ");
INSERT INTO nhx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Iwá̱n Pablo ki̱saꞌ ka̱n nechkatoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Eꞌ sekin kitokakej Pablo iwá̱n kicre̱dojkej itájto̱l Jesús. Se̱ de yejemej ito̱ka̱ꞌ Dionisio, yéj de ino̱mej yej manda̱rowaj yej monechkojkej ipan se̱ tepe̱ꞌ yej kijliáj Areópago, iwá̱n se̱ siwa̱ꞌ yej ito̱ka̱ꞌ Dámaris, iwá̱n sekin má̱j no̱ kicre̱dojkej. ");
INSERT INTO nhx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kua̱ꞌ nochi iní̱n panoj, Pablo ki̱saꞌ Atenas, iwá̱n yajki Corinto. ");
INSERT INTO nhx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ompa kasiꞌ se̱ ta̱gaꞌ judío yej ito̱ka̱ꞌ Aquila, yej nace̱roj ipan íta̱l Ponto. Aya kipiaya días iga asikej, wa̱lkej de Italia iwá̱n isiwa̱ꞌ yej ito̱ka̱ꞌ Priscila. Ki̱skej Italia iga rey Claudio César tatekimáꞌ iga maki̱saka̱n Roma nochi judiyojmej. Iwá̱n Pablo yajki kipaxa̱lowili̱toj. ");
INSERT INTO nhx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Iwá̱n como inó̱mpasan tekipáno̱l kipiaya ken yejeme̱n iga kichi̱wayaj kajli de kuetax, inó̱n iga ompa ka̱wiꞌ iwá̱n yejemej iga sentekipanowaj. ");
INSERT INTO nhx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Iwá̱n cada día kua̱ꞌ mose̱wilo, Pablo ya̱ya itio̱pan judiyojmej. Ompa kipowaya itájto̱l toTe̱ko iga kinekiá makiyo̱lyama̱na judiyojmej iwá̱n yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kua̱ꞌ Silas iwá̱n Timoteo asikej iga wa̱lkej ipan estado de Macedonia, Pablo kikajtej seꞌ tekipáno̱l iga kipetzpowáyasan itájto̱l Dios; kijlia̱ya judiyojmej iga Jesús nokta in el Cristo yej yejemej kichi̱xtoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Eꞌ yejemej mota̱lkej a contra iwá̱n kuajkuantas kijlijkej Pablo. Iwá̱n Pablo kitzejtzeloj itzótzol iga makimatika̱n iga ayompa kichijkej iwá̱n kijtoj: —Siga ampoliwiskej iyi̱xtaj Dios, amejeme̱n amotechko; nej ayoꞌ nikmati. Á̱mansan nia nikpowili̱ti ye̱ꞌnoti̱ciaj yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pablo ki̱saꞌ tio̱pan iwá̱n yajki cha̱n se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Ticio Justo, yej icha̱n tio̱pante̱noj, yéj no̱ kiweyimati̱ltia̱ya Dios. ");
INSERT INTO nhx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Iwá̱n Crispo, yej manda̱rowa tio̱pan, iwá̱n inochi yej onoꞌ icha̱n kicre̱dojkej toTe̱ko. Iwá̱n no̱ miaꞌ de Corinto, kua̱ꞌ kikakikej itájto̱l Dios, kicre̱dojkej wa̱n mobautiza̱rojkej. ");
INSERT INTO nhx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Iwá̱n se̱ yówal toTe̱ko ijkí̱n kijlij Pablo ipan visión: —Amo ximajmawi; xa xikpowa notájto̱l iwá̱n amo xite̱nse̱wi. ");
INSERT INTO nhx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Iga nej nonoꞌ mowa̱n, iwá̱n ayagaj wel tejté̱ mitzchi̱wili̱j yej aye̱kti, ipan iní̱n weyi‑a̱ltepe̱ꞌ onoꞌ miaꞌ yej yawij ne̱cre̱do̱tij. ");
INSERT INTO nhx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Iwá̱n Pablo ompa ka̱wiꞌ Corinto se̱ xiwiꞌ iwá̱n tajko iga kipowilijtoya la gente itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Eꞌ kua̱ꞌ Galión goberna̱rowa̱ya ipan estado de Acaya, judiyojmej ki‑o̱nkawijkej Pablo. Kiwi̱gakej ka̱n tajuzga̱ro̱lo, ");
INSERT INTO nhx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","iwá̱n kijlijkej el gobernador: —Iní̱n ta̱gaꞌ kiyo̱lyama̱na la gente iga seꞌpa makiweyimati̱lti̱ka̱n Dios, ayoꞌ ken kijtowa toley. ");
INSERT INTO nhx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo tajtowa̱yay kua̱ꞌ Galión kijlij judiyojmej: —Siga kichij tejté̱ yej pox aye̱kti, ijkó̱n sí nimitztajto̱lkui̱lia̱yaj amejeme̱n yej anjudiyojmej; ");
INSERT INTO nhx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","eꞌ como iga san tajto̱lmej iwá̱n to̱ka̱mej iwá̱n de amoleymej, ómpaya amejeme̱n xikitaka̱n, nej inó̱n awel nikjuzga̱rowa. ");
INSERT INTO nhx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Iwá̱n kiki̱xtijkej ompa ka̱n tajuzga̱ro̱lo. ");
INSERT INTO nhx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wa̱n nochi grie̱gojmej kiki̱tzkijkej Sóstenes yej manda̱rowa tio̱pan iwá̱n kimagakej ómpasan iyi̱xtaj gobernador. Eꞌ Galión mochij kenkua̱ꞌ ayá̱ꞌ kitztoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo ká̱wigoꞌ miaꞌ días ompa Corinto. Después monawatijkej iwá̱n yej kitokaj Jesús iwá̱n tejkaj ipan weyi á̱ka̱l iwá̱n yajki íta̱l Siria, senyajkij iwá̱n Priscila iwá̱n Aquila. Ompa a̱ltepe̱ꞌ Cencrea mokua̱tetexoj Pablo. Ijkó̱n kichij yej kijtoj iyi̱xtaj Dios iga tejté̱ kichi̱waya. ");
INSERT INTO nhx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kua̱ꞌ asikej a̱ltepe̱ꞌ Éfeso, ómpaya ka̱wikej Priscila iwá̱n Aquila. Pablo yajki tio̱pan iwá̱n ta̱tapowaꞌ iwá̱n judiyojmej yej ompa monechkowa̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yejeme̱n kijlijkej iga maká̱wi‑oꞌ ompa, eꞌ yéj ayoꞌ kineꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Sino que monawatij iwa̱mej, kijtoj: —Nia Jerusalén, iga ompa mane̱techo ilwiꞌ; eꞌ siga Dios kineki niwi̱ꞌ sej nimitzitakij. Después tejkaj ipan weyi á̱ka̱l, yajki, ki̱saꞌ Éfeso. ");
INSERT INTO nhx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Kua̱ꞌ asiꞌ a̱ltepe̱ꞌ Cesarea, Pablo yajki Jerusalén kisaluda̱ro̱toj tokni̱wa̱n yej kitokaj Jesús, iwá̱n yájkiya a̱ltepe̱ꞌ Antioquía. ");
INSERT INTO nhx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Kua̱ꞌ acha̱ wejkaj iga ompa onoꞌ, yajki kipaxa̱lowili̱to tokni̱wa̱n yej onokej íta̱l Galacia iwá̱n yej onokej íta̱l Frigia, iwá̱n ipan sejsé̱ a̱ltepe̱ꞌ kipale̱wijkej iga má̱j mamoconfia̱ro̱ka̱n yej kitokaj Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Inó̱n tiempo asiꞌ ompa Éfeso se̱ judío yej ito̱ka̱ꞌ Apolos. Yéj ícha̱n katka ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Alejandría. Poxsan wel predica̱rowaya iwá̱n poxsan kimatiá itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yéj machtitoya ipan toTe̱ko iyojwi iwá̱n kipoxyo̱lmakaya iga taye̱ꞌne̱xtiliá itájto̱l Dios ka̱n tajtowa de Jesús, malej iga kimatiasan ken iga tabautiza̱roj Juan. ");
INSERT INTO nhx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos pe̱waꞌ iga tajtoj tio̱pan‑ijtiꞌ ken kua̱ꞌ nochi kimati; eꞌ kua̱ꞌ kikakikej Priscila iwá̱n Aquila kén iga tamachtijtoya, kino̱tzkej, iwá̱n kiwi̱gakej ka̱n ise̱ltimej iga kine̱xtilijkej yej aya kimatiá de iyojwi Dios. ");
INSERT INTO nhx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Kua̱ꞌ Apolos kineꞌ mayawi ipan estado de Acaya, tokni̱wa̱n de Éfeso yej kitokaj Jesús kichi̱wilijkej se̱ a̱maꞌ iga tokni̱wa̱n de ompiga maki‑o̱mema̱wi̱ka̱n Apolos. Kua̱ꞌ Apolos asiꞌ Acaya pe̱ꞌ tamachtij. Ijkó̱n poxsan kipale̱wijkej tokni̱wa̱n yej Dios kicho̱kilij iga makicre̱do̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Porque Apolos mote̱nki̱tzkij wa̱n judiyojmej yej akicre̱dojkej ipan Jesús, iwá̱n awel kite̱nkuepilia̱yaj. Iwá̱n iyi̱xtaj la gente Apolos kine̱xtilia̱yaj iga itájto̱l Dios kijtowa iga Jesús in el Cristo yej yejemej kichi̱xtoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mie̱j Apolos onoya Corinto, Pablo panoj ipan tepe̱yoj iwá̱n asiꞌ a̱ltepe̱ꞌ Éfeso, ompa kasiꞌ miaꞌ yej kitokaj Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Iwá̱n Pablo tatajtan: —¿Ix Dios mitzmakakej iyEspí̱rito Santo kua̱ꞌ ankicre̱dojkej ipan Jesús? Yejemej kijtojkej: —Nejeme̱n ayí̱ꞌ nikakiáj siga onoꞌ el Espíritu Santo. ");
INSERT INTO nhx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo kitajtan tokni̱wa̱n: —¿Kéntaj anmobautiza̱rojkej? Yejeme̱n kijtojkej: —Kensan tabautiza̱roj Juan el Bautista. ");
INSERT INTO nhx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo kijtoj: —Kena, Juan kibautiza̱roj yejsan kikajtejkej iga kichi̱waj yej aye̱kti, eꞌ kijlia̱yaj iga makicre̱do̱ka̱n ipan ito̱ka̱ꞌ yej wi̱ꞌoꞌ tatepotztaj, ken tikijtowaj ipan Jesús yej el Cristo. ");
INSERT INTO nhx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kua̱ꞌ inó̱n kikakikej, mobautiza̱rojkej ipan ito̱ka̱ꞌ toTe̱ko Jesús; ");
INSERT INTO nhx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","iwá̱n kua̱ꞌ Pablo kita̱lij ima̱ꞌ ipan sejsé̱ de ino̱mej, iyEspí̱ritoj Dios wa̱laj ipan yejemej, iwá̱n se̱séꞌpaya iga tajtojkej ayꞌyéj ipan itajto̱lmej, iwá̱n kijtojkej kensan Dios kitajto̱lmakakej. ");
INSERT INTO nhx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Iga inochimej, ken doce tajta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pablo ya̱yajtoya tres meses itio̱pan judiyojmej, ompa kipowaya itájto̱l Dios iwá̱n ayá̱ꞌ majmawiá. Iwá̱n kua̱ꞌ tajtowa̱ya, kiyo̱lyama̱naya la gente iga kine̱xtilia̱yaj ken iga reina̱rowa Dios. ");
INSERT INTO nhx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Eꞌ sekin moyo̱ltakua̱wilijkej iwá̱n ayá̱ꞌ kicre̱dojkej, ma̱jwaꞌ iyi̱xtaj la gente kijtojkej iga kijiyaj itájto̱l Jesucristo. Pablo kikajtej yej ma̱ltajtowaj, iwá̱n kiwi̱gaꞌ yej kitokaj Jesús ka̱n tamachtiá se̱ yej ito̱ka̱ꞌ Tiranno, iwá̱n ompa kita̱tapo̱wia̱yaj cada día. ");
INSERT INTO nhx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Iwá̱n ijkó̱n kichijtoya dos años, ijkó̱n yej cha̱ntitoyaj ipan ta̱jli de Asia kikakikej itájto̱l toTe̱ko Jesús, yej judiyojmej iwá̱n yej ayéj. ");
INSERT INTO nhx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Iwá̱n Dios kipale̱wij Pablo iga kichij mila̱grojmej. ");
INSERT INTO nhx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Malej se̱ panyi̱toj o se̱ tzótzol yej Pablo kichijchimiá, kita̱lia̱yaj ipan yej we̱titokej iwá̱n achitiayaj, iwá̱n ma̱lespi̱ritojmej ki̱sayaj. ");
INSERT INTO nhx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Eꞌ sekin judiyojmej yej nejnenka̱ꞌ yej kiki̱xtiliáj la gente ma̱lespi̱ritojmej, no̱ kiyejyekojkaj iga kite̱ne̱wiáj ito̱ka̱ꞌ toTe̱ko Jesús iga makiki̱xti̱ka̱n ma̱lespi̱ritojmej, kijtowa̱yaj: —Ipan ito̱ka̱ꞌ Jesús yej Pablo kipowa, nimitztekimakaj iga xiki̱saka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ijkó̱n kichi̱wayaj siete ipilówa̱mpa Esceva, se̱ judío yej ijé̱fejpa sacerdo̱tejmej. ");
INSERT INTO nhx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Eꞌ kua̱ꞌ kichijkej, ma̱lespí̱ritoj kijtoj: —Jesús niki̱xmati, iwá̱n no̱ nikmati a̱ꞌyéj in Pablo; eꞌ, ¿a̱ꞌyéj in amejeme̱n? ");
INSERT INTO nhx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Eꞌ inó̱n ta̱gaꞌ yej kipiaya mal espírito mopatanaltij iyakapamej, iwá̱n como yéj má̱j tajpalej, nochi kita̱nilij, iwá̱n paré̱j kimagakej iwá̱n cholojtikí̱skeja ipejpetzka̱mej iwá̱n espa̱titiájkija. ");
INSERT INTO nhx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Nochi kimatikej yej cha̱ntitokej Éfeso, judiyojmej iwá̱n yej ayéj judiyojmej iwá̱n pox momajtijkej. Ijkó̱n iga ito̱ka̱ꞌ toTe̱ko Jesús ma̱jya kiweyimati̱ltijkej. ");
INSERT INTO nhx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Iwá̱n miaꞌ yej kicre̱dowa̱yaj Jesús, wi̱tziayaj iga mote̱nxitomayaj iga kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Iwá̱n miaꞌ yej motamatiliáj kiwi̱gakej ili̱brojmej, kitati̱toj iyi̱xtajmej la gente. De ino̱mej libro ipatiyo masiꞌ ken cincuenta mil tomi̱n de plata. ");
INSERT INTO nhx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ijkó̱n iga itájto̱l toTe̱ko no̱ya̱n momatitia̱ya iwá̱n ne̱siá iga kipiá poder. ");
INSERT INTO nhx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kua̱ꞌ pánoja nochi iní̱n, Pablo kejla̱n iga yawi estado de Macedonia iwá̱n Acaya iwá̱n yawi este Jerusalén. Kua̱ꞌ pánoja no̱ya̱n ipan a̱ltepe̱mej kejla̱n no̱ iga yawi Roma. ");
INSERT INTO nhx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Iwá̱n kiti̱tan Macedonia o̱me̱n yej kipale̱wiáj, Timoteo iwá̱n Erasto, eꞌ Pablo acho̱ꞌ ka̱wiꞌ Asia. ");
INSERT INTO nhx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Inó̱n tiempo Éfeso monechko̱lo̱ꞌ iwá̱n mokuesojkej iga mopowaꞌ yej aya i̱ꞌ mopowaya de iyojwi Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Mokuesojkej itechko se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Demetrio, yej kitekipanowa̱ya plata. Iní̱n ta̱gaꞌ kichi̱wa̱ya kaltzitzi̱n de plata kensan tachaya itio̱pan se̱ diosa yej ito̱ka̱ꞌ Diana, iwá̱n poxsan tata̱nia̱yaj yej tekipanowa̱yaj iwá̱n Demetrio. ");
INSERT INTO nhx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Iwá̱n ino̱mej kinechkoj, iwá̱n sekin yej no̱ kipiáj inó̱mpasan tekipáno̱l. Demetrio kijlijkej: —Nokni̱wa̱n, amejeme̱n ankimatij iga ipan iní̱n tekipáno̱l titata̱niáj. ");
INSERT INTO nhx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Eꞌ amejeme̱n ankitaj iwá̱n ankikakij iga Pablo kijtojtinemi iga dio̱smej yej kichí̱wajpa ta̱gaꞌ ayéj dio̱smej; iwá̱n miaꞌya gente kicre̱do̱ltijkej, ayejsan nigaj Éfeso sino que casi no̱ya̱n ipan iní̱n ta̱jli de Asia. ");
INSERT INTO nhx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Inó̱n poxsan aye̱kti, wel tikpolowaj totekipáno̱l, iwá̱n itio̱pan ka̱n onoꞌ weyi dios Diana ayꞌya agaj kiweyimatis. Iná̱n nochi yej cha̱ntitokej ipan ta̱jli de Asia iwá̱n inewi de iní̱n ta̱jli kiweyimati̱ltiáj, eꞌ siga ijkó̱n ken kijtowa Pablo, nochi ke̱lka̱waskej Diana. ");
INSERT INTO nhx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Kua̱ꞌ inó̱n kikakikej yej ompa nechkatoyaj, kuesiwikej poxsan, iwá̱n tzajtzíkejpa iga kijtojkej: —¡Mamoweyimati̱lti Diana yej idio̱smej efe̱siojmej! ");
INSERT INTO nhx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Iwá̱n nochi ipan weyi‑a̱ltepe̱ꞌ ayoꞌ kimatiáj te̱ kichi̱wayaj. Kiki̱tzki̱toj Gayo iwá̱n Aristarco o̱me̱n tajta̱gaꞌ de Macedonia yej senemiáj iwá̱n Pablo. Iwá̱n kiwawatatzojtiajkij este ipan wé̱kal ka̱n motekinechko̱lo. ");
INSERT INTO nhx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo kinekiá makalaki ompa iga matajto iwá̱n la gente, eꞌ tokni̱wa̱n yej kitokaj Jesús ayá̱ꞌ kikalaktijkej. ");
INSERT INTO nhx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","No̱ sekin yej manda̱rowaj Asia yej iyami̱gojmej Pablo, tati̱tankej iga amo mayawi ka̱n chapa̱ntolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ompa ka̱n nechkatolo̱ꞌ, sekin tzajtziáj iga kijtowa̱yaj tejté̱ iwá̱n sekin tzajtziáj iga seꞌpa kijtowa̱yaj iga kuejkuesitoyaj, iwá̱n miaꞌ ayá̱ꞌ kimatiáj te íga ompa nechkatoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Eꞌ sekin yej ompa chapa̱ntoyaj kimati̱ltijkej Alejandro te̱ nemi mochi̱wa, iwá̱n yej judiyojmej kitopejkej iga kita̱lkej tatajkoya̱n. Iwá̱n Alejandro kajkoꞌ ima̱ꞌ iga ayoꞌ matzajtzitolo iga makitajtowili̱ka̱n judiyojmej iyi̱xtaj la gente. ");
INSERT INTO nhx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Eꞌ kua̱ꞌ kimatikej iga Alejandro no̱ judío, nochi tzajtzitoyaj ken dos horas. Kijtojtoyaj: —¡Mamoweyimati̱lti Diana idio̱s efe̱siojmej! ");
INSERT INTO nhx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Iwá̱n tajkuilowa̱ni yej ompa icha̱n, kua̱ꞌ kiyo̱ltá̱lija yej tzajtzitoyaj, kijtoj: —Nokni̱wa̱n de Éfeso, amejeme̱n ankimatij iga no̱ya̱n momati iga iní̱n a̱ltepe̱ꞌ kicuida̱rowa itio̱pan weyi diosa Diana iwá̱n imagen yej wa̱laj ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ayagaj wel kijtowa iga ayá̱ꞌ. Inó̱n iga ayꞌya xi‑o̱yojtoka̱n, amo xikchi̱waka̱n nité̱ siga aya ankimatij te̱ nemi mochi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Iga ini̱mej tajta̱gaꞌ yej ankiwajligakej, até̱ nemi kijtowaj yej aye̱kti, niga nemi ma̱ltajtowaj de tejeme̱n todio̱s Diana. ");
INSERT INTO nhx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Siga Demetrio iwá̱n yej íwa̱n tekipanowaj, kite̱lwi̱jneki agaj, ino̱nya iga onoꞌ jue̱zmej iwá̱n ka̱n tajuzga̱ro̱lo iwá̱n wel motajtowiliáj ite̱nojmej yejemej iga makimakaka̱n yej kinekij. ");
INSERT INTO nhx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Eꞌ siga seꞌpa yej ankitajtanij, mamochi̱wa kua̱ꞌ monechkowaj yej manda̱rowaj ipan iní̱n a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Porque iga ijkí̱n tikchi̱waj, wel te̱pantiáj iga tikuejkuesowaj la gente iga inó̱n yej mochij a̱man. Iwá̱n awel timotajtowili̱skej siga te̱tajtaniskej te íga nemi mokuejkueso̱lo. ");
INSERT INTO nhx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kua̱ꞌ tamiꞌ iní̱n kijtoj, mojmoya̱wílo̱ꞌya. ");
INSERT INTO nhx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kua̱ꞌ pachíwiꞌya iga mokuejkueso̱lo̱ꞌ, Pablo kino̱tzaꞌ yej kitokaj Jesucristo iga kino̱no̱tzkej. Iwá̱n kinajna̱paloj tokni̱wa̱n iga monawatijkej, iwá̱n yájkiya estado de Macedonia. ");
INSERT INTO nhx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Kipaxa̱lowili̱toj a̱ltepe̱mej yej onokej Macedonia iga kita̱tapo̱wijtinemiꞌ yej kitokaj Jesús iga amo makikajte̱waka̱n iyojwi Dios, iwá̱n asito ipan país de Grecia. ");
INSERT INTO nhx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ompa onoya tres meses, ayꞌya ke̱ꞌ poliwiá iga majki̱ltia̱ya pan weyi á̱ka̱l iga yawi Siria, kua̱ꞌ kimatiꞌ iga sekin judiyojmej kinekiáj makiki̱tzki̱ka̱n. Inó̱n iga ayoꞌ yajki Siria, ikxinejnen iga yajki sej Macedonia. ");
INSERT INTO nhx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Íwa̱n senyajkij ini̱mej tajta̱gaꞌ: Sópater yej icha̱n Berea, iwá̱n Aristarco iwá̱n Segundo yej icha̱mej Tesalónica, Gayo yej icha̱n Derbe, iwá̱n Timoteo iwá̱n yajkij no̱ Tíquico iwá̱n Trófimo yej cha̱ntitokej ipan íta̱l Asia. ");
INSERT INTO nhx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ini̱mej tokni̱wa̱n tayaka̱nkej iga yajkij ne̱chatoj ipan a̱ltepe̱ꞌ Troas. ");
INSERT INTO nhx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nejemej, kua̱ꞌ pánoja iyilwi kua̱ꞌ mokua pa̱n yej akipiá levadura, nimajki̱ltijkej Filipos ipan weyi á̱ka̱l. Iwá̱n este ipan cinco días nikasitoj ipan a̱ltepe̱ꞌ Troas tokni̱wa̱n yej ompí ne̱chatoj. Ompa nikajkej siete días. ");
INSERT INTO nhx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ipan achto día de la semana nimonechkojkej wa̱n tokni̱wa̱n yej kitokaj Jesús iga seka̱n nikuajkej la Santa Cena. Pablo kimachtijtoya tokni̱wa̱n. Eꞌ como kimatiá iga yawi ki̱sati mo̱stapa, inó̱n iga ta̱tapojtoya este tajkoyówal. ");
INSERT INTO nhx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ompa ajko ipan seꞌ piso ka̱n ninechkatoyaj, paré̱j taxojxo̱tatoya. ");
INSERT INTO nhx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Iwá̱n se̱ chokotzi̱n ito̱ka̱ꞌ Eutico e̱watoya ipan ventana este ipan tercer piso. Eꞌ como Pablo pox wejkaj iga ta̱tapojtoya, chokotzi̱n pox kochisnekiá iwá̱n mokochkui̱lij iwá̱n wetziꞌ. Iwá̱n kua̱ꞌ kiketzajtoj, míktoꞌya. ");
INSERT INTO nhx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Iwá̱n Pablo temoj, kina̱ꞌtechoj wa̱n kina̱paloj. Iwá̱n kijtoj: —Amo ximajmawika̱n; isatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Iwá̱n Pablo tejkaj sej ajko iwá̱n kikuiꞌ pa̱n wa̱n kita̱tajkoloj, iwá̱n kimajmáꞌ tokni̱wa̱n, iwá̱n tamachtijtoya este ijkó̱n tane̱siꞌ, iwá̱n yájkiya. ");
INSERT INTO nhx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Eꞌ inó̱n chokotzi̱n yej wetziꞌ, kiwi̱gakej ícha̱n isatiajki, iwá̱n nochi pa̱kikej. ");
INSERT INTO nhx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nejemej nitapanojkej iwá̱n niajkij ipan weyi á̱ka̱l este ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Asón iga ompa nikuite̱waskej Pablo, iga yéj kineꞌ mata̱lnejnémipa, áchtoya ijkó̱n nimojlijkej. ");
INSERT INTO nhx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Iwá̱n ompígaya Asón, nimasikej wa̱n Pablo, ómpaya tejkaj ipan weyi á̱ka̱l iwá̱n niajkij este ipan a̱ltepe̱ꞌ Mitilene. ");
INSERT INTO nhx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ompa niki̱skej, iwá̱n ipan seꞌya día nipanojkej ite̱noj tajkóta̱l yej ito̱ka̱ꞌ Quío. Iwá̱n ipan seꞌ día nasikej ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Samos, ompa ka̱n moketza a̱ka̱lmej. No̱ nimoketzkej a̱ltepe̱ꞌ Trogilio, iwá̱n ipan seꞌya día nasitoj a̱ltepe̱ꞌ Mileto. ");
INSERT INTO nhx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Ijkó̱n nikchijkej iga Pablo ayá̱ꞌ kineꞌ mawejka̱wa poxsan ipan ta̱jli yej ito̱ka̱ꞌ Asia, ayá̱ꞌ kineꞌ mayawi Éfeso iga kinekiá maguiꞌ maásiya Jerusalén iga maono ompa siga wel kua̱ꞌ mochi̱was ilwiꞌ yej kijliáj Pentecostés. ");
INSERT INTO nhx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Kua̱ꞌ asikej Mileto, Pablo tati̱tan iga mawi̱tzeka̱n yej tayaka̱ntokej yej kitokaj Jesucristo yej cha̱ntitokej Éfeso. ");
INSERT INTO nhx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Kua̱ꞌ asikej, Pablo kijtoj: —Amejeme̱n ankimatij ken iga ninemiꞌ este kua̱ꞌ achto nasiꞌ Asia. ");
INSERT INTO nhx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Nochipa nonoya amowa̱n iwá̱n nikchij ken ne̱tekimaka toTe̱ko, iwá̱n ayá̱ꞌ nimoweyimati. Ne‑ikno̱chijkej wa̱n este ne̱mikti̱jnekiáj sekin judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Eꞌ ayá̱ꞌ nikajtej iga nimitzne̱xtiliáj nochi yej mitzpale̱wiáj. Nimitzmachtijkej tajkoa̱ltepe̱ꞌ ka̱n anmiakejmej anntakaktoyaj iwá̱n no̱ amochajcha̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Nikne̱xtilia̱ya judiyojmej iwá̱n no̱ yej ayéj judiyojmej iga makikajte̱wáka̱nya iga kichi̱waj yej aye̱kti wa̱n makina̱ꞌtecho̱ka̱n Dios iwá̱n makicre̱do̱ka̱n toTe̱ko Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Iná̱n ne̱tekimaka el Espíritu Santo iga maniá Jerusalén, eꞌ nej ayá̱ꞌ nikmati te̱ yawij ne̱chi̱wili̱tij ompiga. ");
INSERT INTO nhx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Nikmátisan iga el Espíritu Santo ne‑ijliá iga ipan nochi a̱ltepe̱mej ka̱nsan nia̱ti yawij ne̱pre̱sojwi̱tij iwá̱n yawij ne‑ikno̱chi̱watij. ");
INSERT INTO nhx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Eꞌ nej nité̱ ayá̱ꞌ ne̱yo̱lmiktiá malej iga manimiki; san nikneki manikye̱ꞌtami notekipáno̱l yej toTe̱ko Jesús ne̱máꞌ. Inó̱n tekipáno̱l iga manikpowa ye̱ꞌnoti̱ciaj yej te̱ne̱xtiliá iga Dios te̱poxcho̱kiliá, iwá̱n nipa̱ki iga inó̱n nikchi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","’Iwá̱n iná̱n nikmati iga nisé̱ de amejeme̱n yej nimitzpowilijkej ken reina̱rowa Dios, nike̱man ayoꞌ anne‑itaskej. ");
INSERT INTO nhx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Inó̱n iga nikneki manimitzijli̱ka̱n iga ayéj nej notechko siga agaj ayá̱ꞌ kicre̱doj. ");
INSERT INTO nhx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Nej nochi nimitzijlijkej ken Dios kineki iga xikmatika̱n, nité̱ ayá̱ꞌ i̱ya̱ntika̱wiꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Inó̱n iga xikitaka̱n ken iga xiye̱ꞌnemika̱n. Ijko̱nsan no̱ xikitaka̱n iga maye̱ꞌnemika̱n tokni̱wa̱n yej kitokaj Jesucristo. Porque amejeme̱n el Espíritu Santo mitzta̱lkej iga xikitaka̱n tokni̱wa̱n yej toTe̱ko Jesucristo kikowaꞌ iga iyesyo. ");
INSERT INTO nhx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Pues nej nikmati iga kua̱ꞌ nimitzkajte̱wáskeja, wi̱tzeskej sekin yej kinekiskej mamitzpojpolo̱ka̱n amejeme̱n yej ankitokaj toTe̱ko. Ayompa mitzmachti̱skej iga xiki̱saka̱n pan ye̱ꞌojti, ken tikita mitzkua̱jnekij ken lo̱bojmej kikuaj borre̱gojmej. ");
INSERT INTO nhx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Iwá̱n onoskej de amejéme̱nsan yej yawij mitzmachti̱tij, eꞌ takajka̱ya̱wáskejpa ka̱nsan makitokaka̱n tokni̱wa̱n yej kitókaja Cristo. ");
INSERT INTO nhx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Inó̱n iga ximocuida̱ro̱ka̱n iwá̱n xikejla̱mikika̱n iga e̱yi años, semilwiꞌ iwá̱n senyówal este nicho̱kaya iga nimitzno̱no̱tztoyaj sejsé̱ de amejeme̱n. ");
INSERT INTO nhx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","’Iná̱n nokni̱wa̱n nimitzta̱liáj ipan ima̱ꞌ Dios iga mamitzo̱mema̱wi̱ka̱n iga yéj poxsan mitzcho̱kiliáj. Amo xike̱lka̱waka̱n itájto̱l yej te̱pale̱wiá iwá̱n te‑ijliá iga Dios poxsan te̱cho̱kiliá iwá̱n mitzmakaskej yej ye̱kti kua̱ꞌ tonoskej seka̱n wa̱n nochi tokni̱mej yej yéj kitapejpen. ");
INSERT INTO nhx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ayí̱ꞌ nikneꞌ manikui̱li agaj itomi̱n niga itzótzol. ");
INSERT INTO nhx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ma̱jwaꞌ, amejeme̱n ankimatij iga nej nitekipanoj iga wel manikpiá yej ne̱polowa iwá̱n iga yej íwa̱n nisenemiáj. ");
INSERT INTO nhx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ijkó̱n nochipa nimitzne̱xtilijkej iga se̱ matekipano. Ijkó̱n wel tikpale̱wiáj yej akipiáj nité̱, amo matike̱lka̱waka̱n itájto̱l toTe̱ko Jesús, ka̱n kijtoj: “Má̱j pa̱ki yej tamaka, que yej kimakaj.” ");
INSERT INTO nhx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Kua̱ꞌ tamiꞌ inó̱n kijtoj, Pablo motankua̱ketzaꞌ, iwá̱n sen‑ora̱dojkej iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Nochi cho̱kakej, kikechna̱palojkej, iwá̱n kipipitzojkej Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Iwá̱n poxsan mokno̱matikej iga Pablo kijtoj iga ayoꞌ má̱j kitaskej. Iwá̱n kojmakatoj este ka̱n tejkaj ipan weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kua̱ꞌ nikajtéjkeja tokni̱wa̱n yej kitokaj Jesucristo, nitejkajkej ipan weyi á̱ka̱l iwá̱n niajkij ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Cos. Ipan seꞌya día niajkij ipan seꞌya a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Rodas. Iwá̱n después nasitoj ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Pátara. ");
INSERT INTO nhx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Ompa Pátara nikasikej se̱ weyi á̱ka̱l yej yawi Fenicia, iwá̱n ípan nitejkajkej iwá̱n niájkija. ");
INSERT INTO nhx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kua̱ꞌ nemi nipanowaj nikitakej tajkóta̱l yej ito̱ka̱ꞌ Chipre, inó̱n tajkóta̱l ka̱wiꞌ noo̱pochka̱mpamej, iwá̱n niajki este Siria. Iwá̱n nitemojkej a̱ltepe̱ꞌ Tiro porque inó̱n weyi á̱ka̱l ka̱n nia̱yaj ompa kitatemowijkej. ");
INSERT INTO nhx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ompa nikasitoj tokni̱wa̱n yej kitokaj Jesucristo, iwá̱n nikajkej iwa̱mej siete días. Iwá̱n el Espíritu Santo kitajla̱ntijkej ino̱mej tokni̱wa̱n iga makijli̱ka̱n Pablo iga amo mayawi Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Eꞌ kua̱ꞌ pánoja siete días, niki̱skej ompa. Iwá̱n nochi tokni̱wa̱n iwá̱n isiwa̱mej iwá̱n ipilowa̱n, neojmakatoj este playa. Ompa nimotankua̱ketzkej iga ni‑ora̱dojkej. ");
INSERT INTO nhx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Iwá̱n nimonawatijkej este nimona̱palojkej iwá̱n nitejkájkeja ipan weyi á̱ka̱l; iwá̱n tokni̱wa̱n yájkija icha̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Niki̱skej Tiro iwá̱n nasitoj ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Tolemaida, ompa tamatiꞌ iga ninemiáj ipan weyi á̱ka̱l. Ompa niksaluda̱ro̱toj tokni̱wa̱n yej kitokaj Jesucristo, iwá̱n se̱ día ompa nika̱wikej iwa̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Ipan seꞌya día, Pablo iwá̱n yej íwa̱n nonoyaj niki̱skej wa̱n nasikej a̱ltepe̱ꞌ Cesarea. Ompa niajkij cha̱n Felipe yej kipowa ye̱ꞌnoti̱ciaj de Jesucristo, yejwaꞌ se̱ de ino̱mej siete dia̱conojmej yej kitapejpenkej apo̱stolejmej; iwá̱n nikajkej icha̱n. ");
INSERT INTO nhx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Felipe kipiaya na̱wi itakomej yej Dios kitajto̱lmakayaj. ");
INSERT INTO nhx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Iwá̱n kua̱ꞌ miaꞌya días ompa nonokej, asito se̱ profeta yej wa̱laj Judea, ito̱ka̱ꞌ Agabo, ");
INSERT INTO nhx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","wa̱laj ne̱paxa̱lowili̱koj. Iwá̱n kikuiꞌ icintoro̱n Pablo, mokxi‑ilpij iwá̱n moma‑ilpij iwá̱n kijtoj: —IyEspí̱ritoj Dios kijtowa iga Jerusalén judiyojmej ijkí̱n yawij kilpi̱tij yej itatki iní̱n cintoro̱n, iwá̱n yawij kentrega̱ro̱tij ipan ima̱ꞌ yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kua̱ꞌ inó̱n nikakikej nejemej iwá̱n ino̱mej yej ompa icha̱mej Cesarea, nikijlijkej Pablo iga ayoꞌ mayawi Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Eꞌ Pablo kijtoj: —¿Te iga ancho̱kaj?, ijkó̱n anne̱cho̱kismakaj. Nej niksentá̱lija nokta noa̱lmaj ayejsan iga mane‑ilpi̱ka̱n sino que no̱ niksemaka noa̱lmaj iga mane̱mikti̱ka̱n ompiga Jerusalén iga niktoka toTe̱ko Jesús. ");
INSERT INTO nhx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Iwá̱n como awel nikyo̱lyama̱nkej, ijkó̱n nikajtejkej iwá̱n nikijlijkej: —Mamochi̱wa ken kineki toTe̱ko. ");
INSERT INTO nhx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kua̱ꞌ nochi panoj iní̱n, nimajabia̱rojkej wa̱n niajkij Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Senyajkij nowa̱mej sekin tokni̱wa̱n de Cesarea yej kitokaj Jesús. Ya̱ya no̱ se̱ ta̱gaꞌ yej nace̱roj tajkóta̱l Chipre yej ito̱ka̱ꞌ Mnasón. Mnasón ikyay kicre̱dojtoꞌ Jesús iwá̱n ompa nikajkej icha̱n. ");
INSERT INTO nhx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Kua̱ꞌ nasikej Jerusalén, yej kitokaj Jesucristo neo̱mema̱wijkej iwá̱n poxsan pa̱kikej. ");
INSERT INTO nhx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Ipan seꞌya día niajkij wa̱n Pablo iga nikpaxa̱lowili̱toj Jacobo, ompa no̱ nechkatoyaj nochi ancia̱nojmej. ");
INSERT INTO nhx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo tasaluda̱roj iwá̱n kipowaꞌ nochi ken iga Dios kichij iga kicre̱dojkej no̱ kesiá yej ayéj judiyojmej kua̱ꞌ yéj kipowaꞌ itájto̱l Dios. ");
INSERT INTO nhx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Kua̱ꞌ kikakikej inó̱n, kiweyimati̱ltijkej Dios, iwá̱n kijlijkej Pablo: —Taꞌ xikítawaꞌ nokni̱n, nigaj onoꞌ miles yej judiyojmej yej kicre̱dójkeja ipan Jesús, iwá̱n yejemej kijtówajoꞌ iga mamochi̱wa ken tatekimaka iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ino̱mej kimati̱ltijkej iga tej tikmachtijtinemi nochi tokni̱wa̱n yej ayéj judiyojmej, tejkiꞌ tikijtowa iga ayoꞌ mamochi̱wa ken tatekimaka Moisés, iwá̱n titatekimaka iga ayoꞌ makicircuncida̱ro̱ka̱n ipilowa̱n, niga ayoꞌ makichi̱waka̱n ken tejemej tiktekichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Tej, té̱ tikijtowa? Porque la gente yawij monechko̱tij kua̱ꞌ kimatiskej iga nigaj tonoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Má̱j ye̱kti ijkí̱n xikchi̱wa ken nimitzijliáj: Onokej nigaj iwá̱n nejemej na̱wi tokni̱wa̱n yej yawij kichi̱watij ken motajto̱ltijkej wa̱n Dios. ");
INSERT INTO nhx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Xikui̱gaka̱n ini̱mej na̱wi tokni̱wa̱n, iwá̱n xikchi̱wa ken kijtowa la ley iga ximochipa̱waka̱n. Iwá̱n tej xikixta̱wa iga yejemej mamokua̱tagalo̱ka̱n. Ijkó̱n yawij kitatij iga ayéj cierto yej mitzpantiáj; kitaskej iga tej tikchi̱wa ken kijtowa iley Moisés. ");
INSERT INTO nhx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Eꞌ iga ino̱mej yej ayéj judiyojmej, yej no̱ kicre̱dojkej ipan Jesús, nejemej nikijkuilowilíjkeja iga ini̱nsan makichi̱waka̱n: Amo makikua̱ka̱n nakaꞌ yej momiktiliapa i̱dolojmej, iwá̱n amo no̱ makikua̱ka̱n esti, niga inakayo yo̱lka̱ꞌ yej mokechmeká̱napa, iwá̱n amo agaj mamote̱ka iwá̱n yej ayá̱ꞌ íwa̱n na̱miktitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Iwá̱n Pablo yajki iwá̱n ino̱mej na̱wi tajta̱gaꞌ, iwá̱n ipan seꞌ día kichijkej ken kijtowa iley Moisés iga mamochipa̱waka̱n iyi̱xtaj Dios iwá̱n kalaꞌ weyitio̱pan‑ijtiꞌ. Después yajki kijto̱to ke̱man yawi tamiti iga inó̱n kichijtoskej, iga sejsé̱ de yejemej yawi kimakati iyofre̱ndaj. ");
INSERT INTO nhx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Eꞌ kua̱ꞌ asiaya siete día, sekin judiyojmej yej wa̱lkej ipan ta̱jli de Asia kitakej iga Pablo onoꞌ weyitio̱pan iwá̱n kiyokachijkej iga makuejkuesiwika̱n nochi gente, iwá̱n ki‑onkawijkej Pablo ");
INSERT INTO nhx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","iwá̱n tzajtzikej: —¡Nokni̱wa̱n de Israel, xine̱pale̱wi̱ka̱n! Porque iní̱n ta̱gaꞌ tamachtijtinemi no̱ya̱n iga ayá̱ꞌ tiye̱ꞌnemij tejeme̱n tijudiyojmej, iga aye̱kti iley Moisés iwá̱n ayꞌ kiye̱ꞌita toweyitio̱pan. Iwá̱n ayejsan iga inó̱n, sino que iná̱n no̱ kakij weyitio̱pan‑ijtiꞌ sekin grie̱gojmej. Iga ijkó̱n kichi̱waj yej aye̱kti ka̱n moweyimati̱ltiá Dios. ");
INSERT INTO nhx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ijkó̱n kijtowa̱yaj iga kitakej senemiáj iwá̱n se̱ yej ito̱ka̱ꞌ Trófimo yej icha̱n Éfeso, yejemej kijtojkej anka senkalakkej ipan weyitio̱pan. ");
INSERT INTO nhx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Iwá̱n la gente kuejkuesiwikej, motalojkej iga kiki̱tzki̱toj Pablo. Kiwawatatzojtiki̱xtijkej weyitio̱pan‑ijtiꞌ, iwá̱n nimaní̱n kitzajtzakkej kalte̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kimiktiá̱yaja Pablo kua̱ꞌ kimati̱ltijkej comandante yej kimanda̱rowa solda̱dojmej iga nochi gente de Jerusalén kuejkuesitokej. ");
INSERT INTO nhx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Iwá̱n comandante kinechkoj isolda̱dojmej iwá̱n solda̱dojmej yej má̱j tayaka̱ntokej. Iwá̱n motalojtiajkij ka̱n monechko̱lo̱ꞌ. Kua̱ꞌ kitakej iga némiya asij solda̱dojmej, ayoꞌ má̱j kimagakej Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Iwá̱n comandante yej kimanda̱rowa solda̱dojmej kiki̱tzkij Pablo iwá̱n tatekimáꞌ iga mamo‑ilpi iga o̱me cadena. Iwá̱n tatajtan a̱ꞌyéj i̱n, iwá̱n te̱ kichij. ");
INSERT INTO nhx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Eꞌ la gente tzajtzitoyaj, iwá̱n ayá̱ꞌ sansé̱ kijtowa̱yaj, sekin kijtowayaj seꞌ, iwá̱n sekin seꞌpa kijtowa̱yaj. Iwá̱n akojasiá te̱ kijtojtoyaj la gente iga o̱yojtoyaj. Iwá̱n tatekimáꞌ iga makiwi̱gaka̱n Pablo iwé̱kal solda̱dojmej ka̱n cha̱ntitokej. ");
INSERT INTO nhx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kua̱ꞌ asitoj ka̱n iyescale̱rajyo wé̱kal, solda̱dojmej kajkoktiajkij Pablo iga amo te̱ makichi̱wili̱ka̱n iga poxsan kuesitoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Porque itepotztajmej nochi tzajtzitiwi̱tziáj. Kijtowa̱yaj: —¡Mamíkiya! ");
INSERT INTO nhx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kua̱ꞌ némiya kakiáj Pablo ipan iwé̱kal solda̱dojmej, kijlij comandante: —¿Ix wel nitajto̱j mowa̱n? Iwá̱n comandante kijtoj: —¡Mataj wel no̱ titajtowa griego! ");
INSERT INTO nhx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mataj tej ayéj inó̱n egipcio yej ikya kipe̱waltijka guerra iwá̱n kiwi̱gaꞌ ipan desierto cuatro mil yej tamiktiáj. ");
INSERT INTO nhx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo kijtoj: —Nej nijudiyoj. Nej ninace̱roj Tarso, se̱ a̱ltepe̱ꞌ yej ayéj ná̱mo̱l yej onoꞌ ipan íta̱l Cilicia. Eꞌ nimitztajtaniliá iga achi manitajto iwá̱n la gente. ");
INSERT INTO nhx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Iwá̱n comandante kijlij iga wel. Entonces Pablo moketzaꞌ ompa ka̱n onoya ipan iyescale̱rajyo wé̱kal. Iwá̱n kajkoꞌ ima̱ꞌ iga la gente ayꞌya matzajtzitoka̱n. Iwá̱n ni agaj ayoꞌ tajtoj iwá̱n Pablo tajtoj ipan hebreo, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Nokni̱wa̱n iwá̱n te̱tajwa̱n, xikakika̱n ken iga nia nimotajtowili̱ti amo‑i̱xtaj. ");
INSERT INTO nhx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kua̱ꞌ kikakikej iga nemi tajtowa ipan hebreo, ayꞌya nokta semi te̱ kijtojkej, san takaktikajkej. Iwá̱n Pablo kijtoj: ");
INSERT INTO nhx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Nejwaꞌ nijudiyoj. Ninace̱roj a̱ltepe̱ꞌ Tarso yej onoꞌ ipan íta̱l Cilicia, eꞌ nimoskaltij nigaj Jerusalén iwá̱n ne̱machtij Gamaliel. Ijkó̱n nimomachtij ken iga motoka la ley yej Dios tamáꞌ, kimáꞌ to‑ikyapatajwa̱n. Nochipa nikyo̱lmaka iga manikchi̱wa ken kineki toDio̱s, ijkó̱n kensan iná̱n amejeme̱n ankichi̱waj. ");
INSERT INTO nhx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Ikya nej nikte̱mojtinemiáj iga nikmiktia̱yaj yej kitokaj iyojwi Jesús iwá̱n nikpre̱sojwia̱yaj tajta̱gaꞌ iwá̱n siwa̱tkej. ");
INSERT INTO nhx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ije̱fej sacerdo̱tejmej iwá̱n we̱wetkej yej tayaka̱ntokej ipan topaí̱s kimelaꞌmatij iga iní̱n nikchi̱waya. Yejemej ne̱makakej a̱maꞌ iga manikui̱guili yej manda̱rowaj Damasco. Niajki ompiga iga nikte̱mo̱to yej kitokaj Jesús iga manikuajligaka̱n Jerusalén iga manikikno̱chi̱waka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","’Eꞌ kua̱ꞌ nemi nia ipan ojti iwá̱n nasitia̱yay Damasco, ken tajkodía ne̱we̱jta̱wi̱ko se̱ tiꞌti yej wa̱laj ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Iwá̱n niwetziꞌ este ta̱lpan. Iwá̱n nikaguiꞌ a̱ꞌpa ijkí̱n ne‑ijlij: “Saulo, Saulo, ¿te iga tine̱te̱mojtinemi iga tine‑ikno̱chi̱wa?” ");
INSERT INTO nhx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Iwá̱n nej niktajtan: “¿A̱ꞌyéj in tej, noTe̱ko?” Iwá̱n ne‑ijlij: “Nej niJesús de Nazaret yej nemi tine‑ikno̱chi̱wa.” ");
INSERT INTO nhx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Yej íwa̱n nisenya̱yaj kitakej inó̱n tiꞌti iwá̱n majmawikej; eꞌ ayá̱ꞌ kikakikej itájto̱l yej ne̱no̱tzaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Iwá̱n niktajtan: “¿NoTe̱ko, te̱ nikchi̱was?” Iwá̱n toTe̱ko ne‑ijlij: “Ximoketza, iwá̱n xaj Damasco. Ompiga yawij mitzijli̱tij nochi te̱ tia tikchi̱wati.” ");
INSERT INTO nhx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Eꞌ como inó̱n tiꞌti ne̱pachatilij, yej íwa̱n ninemiáj ne̱wila̱ntiajkij este Damasco. ");
INSERT INTO nhx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","’Ompa onoya se̱ ta̱gaꞌ yej ito̱ka̱ꞌ Ananías, yéj nochipa kichi̱wa ken kijtowa iley Moisés, nochi judiyojmej yej ompa icha̱mej Damasco ye̱ꞌtajtowa̱yaj iga inó̱n Ananías. ");
INSERT INTO nhx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías wa̱laj ne‑itako. Kua̱ꞌ asiꞌ ne‑ijlij: “Nokni̱n Saulo, sejya xitachá.” Iwá̱n íkua̱ꞌsan sej nitacháꞌ, iwá̱n nikítaꞌya Ananías. ");
INSERT INTO nhx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Iwá̱n ne‑ijlij: “IDio̱s to‑ikyapatajwa̱n mitztapejpen ikyay iga xikmati te̱ kichi̱wasneki iwá̱n tej, iwá̱n iga xiki̱xmati Jesús yej ayí̱ꞌ kichi̱wa yej aye̱kti iwá̱n iga xikaki ima̱tika tajtowa. ");
INSERT INTO nhx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Porque tej tia titajto̱ti de yéj iyi̱xtaj nochi gente iwá̱n tikpowas yej tikitaꞌ iwá̱n yej tikáꞌ.” ");
INSERT INTO nhx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ne‑ijlij: “¿Teoꞌ má̱j tikchá? Ximoketza iwá̱n ximobautiza̱ro, xiktajtanili toTe̱ko Jesús iga mamitze̱lka̱wili yej tikchij yej aye̱kti.” ");
INSERT INTO nhx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","’Kua̱ꞌ niájkiya Jerusalén, niajki weyitio̱pan iga ni‑ora̱do̱to, iwá̱n nikitaꞌ se̱ visión. ");
INSERT INTO nhx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nikitaꞌ toTe̱ko iwá̱n ne‑ijlij: “Xikí̱saya nimaní̱n Jerusalén, porque ayá̱ꞌ mitztajto̱lkuiskej kua̱ꞌ titajto̱j de nej.” ");
INSERT INTO nhx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Nej nikijlij: “NoTe̱ko, yejemej kimatij iga nej nia̱ya ipan nochi itio̱pamej iga nikpre̱sojwia̱yaj iwá̱n nikmagayaj yej mitzcre̱dojtokej. ");
INSERT INTO nhx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Iwá̱n kua̱ꞌ kimiktijkej Esteban yej kipowaya motájto̱l, ompa nonoya iwá̱n no̱ nikijtowa̱ya iga makimikti̱ka̱n. Iwá̱n ino̱mej yej tamiktijkej, nej nicuida̱rowilijtoyaj itzotzolmej.” ");
INSERT INTO nhx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Eꞌ toTe̱ko ne‑ijlij: “Xaja, porque nia nimitzti̱taniti wejka iga xikta̱tapo̱wi̱tij yej ayéj judiyojmej.” ");
INSERT INTO nhx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ompa tamatiꞌ iga santakaktoyaj la gente, pe̱ꞌ tzajtzikej iga kijtojkej: —¡Mamíkiya! ¡Iní̱n ta̱gaꞌ akajasi iga maono! ");
INSERT INTO nhx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ma̱jsan tzajtziáj, kitzejtzelowa̱yaj itzotzolmej iwá̱n kipata̱naltia̱yaj ta̱lpíno̱l. ");
INSERT INTO nhx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Comandante tatekimáꞌ iga Pablo makaki̱ka̱n ipan iwé̱kal solda̱dojmej, iwá̱n tatekimáꞌ iga makimagaka̱n iga wel makijto te íga nokta ijkó̱n kitzajtziliáj. ");
INSERT INTO nhx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Eꞌ kua̱ꞌ kilpitókeja in Pablo iga yáwija kimagatij, kijlij capitán yej kimanda̱rowa sekin solda̱dojmej: —¿Ix ye̱kti iga anne̱yokamagaj kua̱ꞌ aya ankimatij siga ayompa nikchij? Nej niciudadano romano. ");
INSERT INTO nhx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Kua̱ꞌ inó̱n kikaguiꞌ capitán, yajki kitato comandante, iwá̱n kijlij: —¿Te̱taj nemi tikchi̱wa? Matajkiꞌ ini̱nwaꞌ ta̱gaꞌ se̱ ciudadano romano. ");
INSERT INTO nhx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Entonces inó̱n comandante yej má̱j manda̱rowa yajki kitajtanito Pablo, kijlij: —¿Ix melá̱ꞌ iga tej ciudadano romano? Pablo kijtoj: —Kena. ");
INSERT INTO nhx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Entonces inó̱n comandante kijtoj: —Nej ne̱wi̱guilij komati tomi̱n iga manimochi̱wa ciudadano romano. Pablo kijtoj: —Eꞌ nej ijkó̱n nokta ninace̱roj iga notaj no̱ ciudadano. ");
INSERT INTO nhx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Iga inó̱n kijtoj, yej kimagayaj Pablo kikajtéjkeja iwá̱n este inó̱n comandante momajtij iga kimatiꞌ iga Pablo cuidadano romano iwá̱n iga kilpitoyaj iga cadena. ");
INSERT INTO nhx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ipan seꞌya día, comandante kinekiá makimati te íga judiyojmej kite̱lwijkej Pablo, iwá̱n kixiton ka̱n ilpitoya iga cadena, iwá̱n kinechkoj yej kimanda̱rowa sacerdo̱tejmej iwá̱n nochi judiyojmej yej manda̱rowaj. Entonces kiki̱xtij Pablo ka̱n ilpitoya, iwá̱n kiwi̱gakej ka̱n nechkatokej. ");
INSERT INTO nhx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo kitachi̱lij yej kimanda̱rowaj judiyojmej, iwá̱n kijtoj: —Nokni̱wa̱n, nej nikmati ipan noa̱lmaj iga este iná̱n, niye̱ꞌnemi iyi̱xtaj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Entonces Ananías yej kimanda̱rowa sacerdo̱tejmej tatekimáꞌ iga yej onoyaj iná̱ꞌ Pablo makite̱ntatzi̱naka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Eꞌ Pablo kijtoj: —Dios yawi mitzmagati tej. Ígasan timoweyimati iga tiye̱ꞌnemi, sie̱n ayá̱ꞌ. Siga tej ompa te̱watoꞌ iga titajuzga̱rowa kensan kijtowa la ley, ¿te iga titatekimaka iga mane̱magaka̱n?, ayá̱ꞌ ijkó̱n kijtowa la ley. ");
INSERT INTO nhx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Yej ompa onoyaj kijtojkej: —¿Iwá̱n ijkó̱n tikte̱nkuepiliá ije̱fej sacerdo̱tejmej yej kiservi̱rowa Dios? ");
INSERT INTO nhx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Iwá̱n Pablo kijtoj: —Nokni̱wa̱n, nej anikmatiá siga iní̱n in yej kimanda̱rowa sacerdo̱tejmej. Pues ijkí̱n kijtowa ka̱n ijkuilijtoꞌ: “Amo xikma̱lijli yej kimanda̱rowa moge̱ntej.” ");
INSERT INTO nhx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Entonces Pablo kitaꞌ iga ompa onoyaj saduceojmej iwá̱n sekin fariseojmej. Iwá̱n tajtoj recio: —Nokni̱wa̱n, nej no̱ nifariseo, iwá̱n notajwa̱n no̱ fariseojmej. Nemi anne̱juzga̱rowaj iga nicre̱dowa iga ojpa‑isaskej yej miktokej. ");
INSERT INTO nhx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kua̱ꞌ inó̱n kijtoj Pablo, fariseojmej iwá̱n saduceojmej pe̱ꞌ iga mokue̱kuejkuesojkej iwá̱n moyojyokatijkej. ");
INSERT INTO nhx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Porque yej saducéojpa kijtowaj iga ayꞌya ojpa‑isaskej yej mikikej. Kijtowaj iga ateyi a̱ngelejmej niga espi̱ritojmej; eꞌ yej fariseo kena kicre̱dowaj ini̱mej. ");
INSERT INTO nhx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Iwá̱n nochi tzajtzikej iga tajtajtojkej; iwá̱n sekin fariseojmej yej tamachtiáj ipan iley Moisés moketzkej iwá̱n kijtojkej: —Iní̱n ta̱gaꞌ ayá̱ꞌ nemi kichi̱wa yej aye̱kti. ¿Qué tal si se̱ espíritu o se̱ ángel kimáꞌ iga ijkó̱n matajto? Amo tia̱skej ico̱ntraj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Eꞌ como némiya má̱j kuejkuesiwilo, comandante majmawiꞌ iga wel kita̱tajkotzaya̱naj Pablo. Iwá̱n kitekimáꞌ isolda̱dojmej iga makiwi̱gaka̱n sej Pablo ipan iwé̱kal solda̱dojmej. ");
INSERT INTO nhx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Iwá̱n ino̱nsan yówal Pablo ki̱xne̱xtilij toTe̱ko iwá̱n kijlij: —Pablo, amo ximajmawi. Kensan titajtoj Jerusalén iga nej, ijko̱nsan no̱ tia titajto̱ti Roma. ");
INSERT INTO nhx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kua̱ꞌ tané̱siꞌya, sekin judiyojmej motajto̱ltijkej iga yawij kimikti̱tij Pablo. Iwá̱n kijtojkej iyi̱xtaj Dios iga ayá̱ꞌ nokta yawij takua̱tij niga koni̱skej nité̱ este que makimikti̱ka̱n Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Má̱j de cuarenta tajta̱gaꞌ yej ijkó̱n kijtojkej. ");
INSERT INTO nhx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yajkij kitatoj ije̱fejmej sacerdo̱tejmej iwá̱n yej kimanda̱rowaj judiyojmej, kijli̱toj: —Nejemej nimotajto̱ltíjkeja iwá̱n nikijtojkej iyi̱xtaj Dios iga ayá̱ꞌ nokta niawij nitakua̱tij siga aya nikmiktiáj Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Iná̱n amejeme̱n iwá̱n nochi yej anmanda̱rowaj, xikijli̱ka̱n comandante iga mo̱sta mamitzwajliguili̱ka̱n Pablo, ximopajpanti̱ka̱n iga ankimatisnekij má̱j yej kichij; iwá̱n nejemej nikchi̱xtóskeja iga niawij nikmikti̱tij ipan san‑ojti. ");
INSERT INTO nhx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Eꞌ ipiltzi̱n isiwa‑ikni̱n Pablo, kimatiꞌ iga kimikti̱jnékija Pablo. Yajki kimati̱lti̱to este ka̱n pre̱sojtitoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Entonces Pablo kino̱tzaꞌ se̱ capitán yej kimanda̱rowa solda̱dojmej iwá̱n kijlij: —Xikui̱ga iní̱n chokotzi̱n ka̱n onoꞌ comandante, porque yéj yawi kijli̱ti te̱pa iteki. ");
INSERT INTO nhx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Entonces in capitán kiwi̱gaꞌ inó̱n chokotzi̱n ka̱n onoꞌ comandante iwá̱n kijlij: —Pablo, yej onoꞌ preso, ne‑ijlij iga manimitzwajliguili iní̱n chokotzi̱n, porque te̱pa mitzijli̱jneki. ");
INSERT INTO nhx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Inó̱n comandante kiwila̱ntiajki inó̱n chokotzi̱n iga kiwi̱gaꞌ ka̱n iyokamej, iwá̱n kitajtan: —¿Te̱ tine‑ijli̱jneki? ");
INSERT INTO nhx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Inó̱n chokotzi̱n kijtoj: —Judiyojmej motajto̱ltijkej iga yawij mitztati̱tanili̱tij iga mo̱sta xikui̱ga Pablo iná̱ꞌ yej kimanda̱rowaj judiyojmej, ka̱nsankiꞌ makimati̱lti̱ka̱n te̱ nokta kichij. ");
INSERT INTO nhx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Eꞌ amo xiktajto̱lkui̱li. Porque má̱j de cuarenta tajta̱gaꞌ yej yejéme̱mpa kojchaskej. Kijtójkeja iyi̱xtaj Dios iga atakua̱skej niga koni̱skej nité̱ este que makimikti̱ka̱n Pablo, iwá̱n iná̱n kichi̱xtokej iga makimatika̱n te̱ tia tikijto̱ti tej. ");
INSERT INTO nhx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Iwá̱n comandante kijtoj iga welja yawi chokotzi̱n; eꞌ kijlij iga amo agaj makijli nité̱ yej kijtojtoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Entonces inó̱n comandante kino̱tzaꞌ o̱me yej no̱ kimanda̱rowa solda̱dojmej iga makitekimaka mamalista̱ro̱ka̱n doscientos solda̱dojmej yej nejnentia̱skej iwá̱n setenta soldado yej maya̱ka̱n ipan kawa̱yoj, iwá̱n doscientos yej makiwi̱gaka̱n ila̱nzajmej iga maya̱ka̱n a̱ltepe̱ꞌ Cesarea tayowaka̱n las nueve. ");
INSERT INTO nhx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Iwá̱n kijlijkej no̱ iga makixi̱lajti̱ka̱n se̱ kawa̱yoj ka̱n Pablo tejkatiá̱j. Iwá̱n tatekimáꞌ iga makitaka̱n iga Pablo maye̱ꞌasiti ite̱noj gobernador Félix. ");
INSERT INTO nhx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Iwá̱n inó̱n comandante kiti̱tan wa̱n yejemej se̱ a̱maꞌ: ");
INSERT INTO nhx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Annogobernado̱rmej Félix yej nimitzpoxye̱ꞌitaj, mitzsaluda̱rowa Claudio Lisias. ");
INSERT INTO nhx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Iní̱n ta̱gaꞌ kiki̱tzkijkej judiyojmej iga kimiktiá̱yaja. Iwá̱n kua̱ꞌ nikmatiꞌ iga no̱ ciudadano romano, niajki iwá̱n nosolda̱dojmej iwá̱n nikma̱nawij. ");
INSERT INTO nhx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Iwá̱n nikui̱gaꞌ ite̱noj yej kimanda̱rowaj judiyojmej iga manikmati te íga kiki̱tzkijkej. ");
INSERT INTO nhx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Iwá̱n nikmatiꞌ iga kiki̱tzkijkej iga san itechko ileymej, eꞌ akajasi iga mamomikti niga mayawi kuákalko. ");
INSERT INTO nhx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eꞌ kua̱ꞌ nikmatiꞌ iga judiyojmej motajto̱ltíjkeja iga yawij kimikti̱tij, iná̱n ompiga nimitzti̱taniliá. Iwá̱n nikijlij yej tate̱lwiáj iga makijto̱ka̱n mote̱noj te̱ kikuesowaj. Xiye̱ꞌono.” ");
INSERT INTO nhx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Iwá̱n solda̱dojmej kichijkej kensan kitekimakakej iwá̱n tayowaka̱n kiwi̱gakej Pablo, este ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Antípatris. ");
INSERT INTO nhx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ipan seꞌya día ino̱mej solda̱dojmej yej ikxinejnentiajkij ómpaya mokuepkej, yájkija sej iwé̱kal solda̱dojmej, iwá̱n yej nemiáj ipan kawa̱yoj yajkij iwá̱n Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Kua̱ꞌ asíkeja Cesarea, a̱maꞌ kimakakej el gobernador, iwá̱n ompa no̱ kika̱watoj Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Kua̱ꞌ el gobernador tamiꞌ kilee̱roj inó̱n a̱maꞌ, tatajtan ka̱n icha̱n Pablo. Kua̱ꞌ kimatiꞌ iga Pablo icha̱n estado de Cilicia, ");
INSERT INTO nhx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","kijlij: —Nimitzkakis kua̱ꞌ wi̱tzeskej yej mitzte̱lwijkej. Iwá̱n tatekimáꞌ iga makakí̱tijoꞌ kuákalko ipan ipala̱cioj Herodes. ");
INSERT INTO nhx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Kua̱ꞌ pánoja cinco días, Ananías, yej kimanda̱rowa sacerdo̱tejmej yajki Cesarea iwá̱n sekin ancia̱nojmej iwá̱n se̱ yej tatajtowiliá yej ito̱ka̱ꞌ Tértulo. Ini̱mej yajkij ite̱noj el gobernador iga kite̱lwi̱toj Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kua̱ꞌ ómpaya kiwajligakej Pablo, Tértulo pe̱waꞌ iga tate̱lwiá. Ijkí̱n kijlij Félix: —Señor gobernador, nimitzmakaj gracias, porque iga tej iná̱n nonokej tamelá̱. Iwá̱n iga tikmati ken iga titamanda̱rowa, no̱ya̱n ye̱ꞌonolo̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nochi iní̱n yej tikchi̱wa poxsan nikye̱ꞌitaj iwá̱n poxsan nimitzagradece̱rowaj tej weyi tekiwaj Félix. ");
INSERT INTO nhx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Eꞌ aniknekij má̱j manimitzatrasa̱ro̱ka̱n, nimitztajtaniliáj achi xine̱kakika̱n. ");
INSERT INTO nhx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Pues nikasikej iní̱n ta̱gaꞌ tayojyokatijtinemi no̱ya̱n ipan iní̱n ta̱jli iwá̱n kichi̱wa iga mamoyojyokati̱ka̱n judiyojmej, iwá̱n yéjwaꞌ in yej ken tzontekon de ino̱mej yej kitokaj Jesús de Nazaret, yej moto̱ka̱wiáj nazarenos. ");
INSERT INTO nhx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","No̱ kichi̱jnekiá yej pox aye̱kti iyijtiko noweyitio̱pamej de nejeme̱n, inó̱n iga niki̱tzkijkej iwá̱n niknekiáj manikjuzga̱ro̱ka̱n ken kijtowa inó̱n ley yej Moisés ne̱makakej. ");
INSERT INTO nhx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Eꞌ comandante Lisias kalaꞌ iwá̱n ne̱tekiꞌtila̱nilijkej iga ne̱kui̱lijkej, ");
INSERT INTO nhx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","kijtoj iga yej kite̱lwiáj Pablo mawi̱tzeka̱n mote̱noj. Iná̱n tej moma̱tika wel tiktajtani iga xikmati te íga nikte̱lwiáj. ");
INSERT INTO nhx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Iwá̱n judiyojmej yej ompa onoyaj kijtowa̱yaj iga ijkó̱n nokta. ");
INSERT INTO nhx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Iwá̱n el gobernador kima̱no̱tzaꞌ Pablo iga matajto, iwá̱n Pablo kijtoj: —Kena, nipa̱ki iga manimotajtowili mo‑i̱xtaj, nej nikmati iga tej desde ikyay tonoꞌ iga juez ipan iní̱n país. ");
INSERT INTO nhx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Tej moma̱tika wel titatajtani iga kipiaoꞌ doce día iga nasiꞌ Jerusalén iga nikweyimati̱lti̱ko noDio̱s. ");
INSERT INTO nhx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Iwá̱n ayagaj neasito nimokuesojtoꞌ iwá̱n agaj, niga nikuejkuesojtoya la gente, niga ipan weyitio̱pan, niga ipan itio̱pamej, niga ka̱naj ipan a̱ltepe̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ini̱mej gente awel mitzne̱xtiliáj ka̱n neasitoj nemi nikchi̱wa inó̱n yej ne̱pantiáj. ");
INSERT INTO nhx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Eꞌ kena, nikijtowa iga niktoka iyojwi Jesucristo, inó̱n yej yejemej kijtowaj iga ayompa tamachtiá. Nikservi̱rowa iDio̱s notajwa̱n iwá̱n nicre̱dowa nochi yej ijkuilijtoꞌ ipan la ley iwá̱n yej kijkuilojkej profe̱tajmej. ");
INSERT INTO nhx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Iwá̱n nikchi̱xtoꞌ, kensan ini̱mej yej ne̱pantiáj kichi̱xtokej, iga ke̱man Dios yawi ki‑ojpa‑ixiti̱tij yej miktokej, yej kichijkej yej ye̱kti iwá̱n no̱ yej kichijkej yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Inó̱n iga nikneki nochipa maniyo̱lchipaktito iyi̱xtaj Dios iwá̱n iyi̱xtaj la gente. ");
INSERT INTO nhx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","’Miaꞌ xiwiꞌ ninentinemiꞌ wejwejka, iná̱n niwa̱laj ipan nopaí̱s nikuajli̱ꞌ tomi̱n iga nikmakaj yej amotapialiáj iwá̱n nikmakako ofrenda noDio̱s. ");
INSERT INTO nhx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Inó̱n nikchijtoya kua̱ꞌ sekin judiyojmej yej icha̱mej ipan estado de Asia neasitoj weyitio̱pan‑ijtiꞌ, nemi nimochipa̱wa ken kijtowa iley Moisés, eꞌ ayá̱ꞌ nimiakejmej niga ni‑o̱o̱yojtoyaj. ");
INSERT INTO nhx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ino̱mej judiyojmej katka nigaj maonoka̱n iga mane̱te̱lwi̱ka̱n mote̱noj siga kitakej iga nemi nikchi̱wa yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Siga ayéj ijkó̱n, ini̱mej makijto̱ka̱n siga neasilijkej tejté̱ yej aye̱kti kua̱ꞌ nonoya ite̱noj yej kimanda̱rowa judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","O anka ne̱te̱lwiáj iga nikijtoj recio iyi̱xtaj yejemej: “A̱man anne̱juzga̱rowaj iga nicre̱dowa iga ojpa‑isaskej yej miktokej.” ");
INSERT INTO nhx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Kua̱ꞌ inó̱n kikáꞌ Félix, iga kipoxmati de iyojwi Jesucristo, kijtoj: —Ijko̱noꞌ maka̱wi este que maasi in comandante Lisias iga yáwi‑oꞌ ne̱powili̱ti ken kitaꞌ yej ankichijkej. ");
INSERT INTO nhx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Iwá̱n Félix kitekimáꞌ capitán iga Pablo ompa makipiaka̱n, eꞌ achi makichi̱wa ken kinekis wa̱n kua̱ꞌ asij yej kipaxa̱lowiliáj wel mapano̱ka̱n iga makiyo̱lchika̱waka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Kua̱ꞌ pánoja achi miaꞌ días, Félix iwá̱n Drusila yej isíwa̱ꞌpa yej no̱ judío, wa̱lkej ka̱n onoꞌ Pablo. Entonces Félix tati̱tan iga makino̱tzatij Pablo iwá̱n kikakikej yej kijtoj iga kén se̱ wel mamoconfia̱ro ipan Jesucristo. ");
INSERT INTO nhx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ta̱tapowaꞌ ken iga se̱ ta̱gaꞌ maye̱ꞌnemi, iwá̱n ken iga se̱ wel mamoyo̱ltakua̱wili iga amo makichi̱wa yej aye̱kti, iwá̱n ken iga Dios yawi tajuzga̱ro̱ti ke̱man. Kua̱ꞌ inó̱n kikáꞌ Félix, momajtij. Kijtoj: —Iná̱n xaja. Kua̱ꞌ até̱ nikchijtos nimitztati̱tanili̱j sej iga xiwi̱ki. ");
INSERT INTO nhx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Félix kinekiá iga Pablo makimaka tomi̱n iga wel makimajka̱wa. Inó̱n iga kino̱tzaꞌ miaꞌ ve̱j iga mata̱tapowa íwa̱n. ");
INSERT INTO nhx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kua̱ꞌ pánoja o̱me años kí̱saꞌya Félix iga gobernador iwá̱n ka̱wiꞌ Porcio Festo. Eꞌ Félix kinekiá makiye̱ꞌitan judiyojmej, inó̱n iga kikajtej preso Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo asiꞌ a̱ltepe̱ꞌ Cesarea iga móchija gobernador. Iwá̱n kua̱ꞌ pánoja e̱yi días ki̱saꞌ Cesarea iga yájkiya Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ompa yej ije̱fejmej sacerdo̱tejmej iwá̱n judiyojmej yej má̱j tayaka̱ntokej yajkij ka̱n onoya Festo iga kite̱lwitoj Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Kijlijkej iga achi matatekimaka iga Pablo makiwi̱gaka̱n Jerusalén. Ino̱mej kejla̱ntoyaj iga Pablo makimikti̱ka̱n ipan ójtisan. ");
INSERT INTO nhx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Eꞌ Festo kijtoj iga Pablo pre̱sojtitoꞌ Cesarea. Iwá̱n kijtoj iga awejka̱was ima̱tika ya̱j ompiga. ");
INSERT INTO nhx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ijkí̱n kijtoj: —Maya̱ka̱n nowa̱n yej mitzmanda̱rowaj, iwá̱n siga inó̱n ta̱gaꞌ kichij tejté̱ yej aye̱kti, ompígaya makite̱lwi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo onoya Jerusalén ken ocho o diez días iwá̱n mokuepaꞌ Cesarea. Ipan seꞌya día yajki mota̱li̱to ka̱n tajuzga̱rowa iwá̱n tatekimáꞌ iga mamokuiti Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kua̱ꞌ asiꞌ Pablo, kiyawalojkej ino̱mej judiyojmej yej wa̱lkej Jerusalén. Kijtojkej iga kichij kuajkuantas yej aye̱kti ka̱nsan makima̱wetzi̱lti̱ka̱n, eꞌ awel nokta kine̱xtijkej iga kichij tejté̱. ");
INSERT INTO nhx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pablo ijkí̱n motajtowilij: —Nej ayá̱ꞌ nemi nikchi̱wa nité̱ yej aye̱kti, niga ico̱ntraj ileymej judiyojmej, niga ico̱ntraj weyitio̱pan, niga ico̱ntraj rey César yej kigoberna̱rowa Roma. ");
INSERT INTO nhx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Eꞌ Festo kinekiá makiye̱ꞌitaka̱n judiyojmej. Entonces kitajtan Pablo: —¿Ix tia̱jneki Jerusalén iga ompiga manikita ix ijko̱nya ken nemi mitzpantiáj? ");
INSERT INTO nhx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablo kijtoj: —Nija nonoꞌ ka̱n rey César mitzta̱lij iga xitajuzga̱ro, kajasi iga nigaj mane̱juzga̱ro̱ka̱n. Tej tikmati iga judiyojmej ayá̱ꞌ nemi nikchi̱wiliá yej aye̱kti. ");
INSERT INTO nhx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Siga nikchij yej aye̱kti yej kajasi iga mane̱mikti̱ka̱n, puej mane̱mikti̱ka̱n; eꞌ siga nemi ne̱pantiajsan, ijkó̱n ayagaj wel mane̱yokawi̱ga ipan ima̱mej judiyojmej. Niktajtani iga mane̱juzga̱ro ima̱tika rey César. ");
INSERT INTO nhx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festo tajtoj iwá̱n yej tano̱no̱tzaj iga makimati te̱ kichi̱was, wa̱n kijlij Pablo: —Tiktajtan iga mamitzjuzga̱ro rey César, pues nia nimitzti̱taniti ompiga ka̱n onoꞌ yéj. ");
INSERT INTO nhx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kua̱ꞌ panoj sekin días, rey Agripa iwá̱n Berenice yej isiwa̱ꞌ yajkij Cesarea iga kipaxa̱lowili̱toj Festo. ");
INSERT INTO nhx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Como ompa onoyaj miaꞌ días, Festo kipowilij Agripa te íga Pablo onoꞌ preso, kijlij: —Nigaj onoꞌ se̱ ta̱gaꞌ yej Félix kikajtej preso. ");
INSERT INTO nhx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kua̱ꞌ nonoya Jerusalén ne‑itatoj yej kimanda̱rowaj sacerdo̱tejmej iwá̱n ancia̱nojmej yej kimanda̱rowaj judiyojmej. Ne̱tajtanilia̱yaj iga manikijto iga kajasi iga mamomikti Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nej nikijlij iga yej manda̱rowa Roma ayí̱ꞌ tatekimaka iga mamomikti agaj siga yej kite̱lwiáj aya motajtowiliá iyi̱xtaj yej tate̱lwiáj. ");
INSERT INTO nhx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Inó̱n iga kua̱ꞌ ino̱mej wa̱lkej nigaj, ayꞌya má̱j te̱ nikijtoj sino que kua̱ꞌ tane̱siꞌ niajki ka̱n nitajuzga̱rowa, iwá̱n nitatekimáꞌ iga makiwajligaka̱n inó̱n ta̱gaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Eꞌ kua̱ꞌ ómpaya onokej yej tate̱lwiáj, ayá̱ꞌ kijtojkej nité̱ ken nej nikejla̱ntoya. ");
INSERT INTO nhx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sino que kite̱lwia̱yaj iga kén iga yéj kicre̱dowa Dios, iwá̱n iga se̱ yej ito̱ka̱ꞌ Jesús yej miguiꞌ. Iwá̱n Pablo kijtowa iga iní̱n Jesús isatoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Eꞌ como nej ayꞌya nikmatiá te̱ nikchi̱waya, niktajtan Pablo siga kinekiá iga mayawi Jerusalén iga ompiga makijuzga̱ro̱ka̱n iga inó̱n yej kite̱lwiáj. ");
INSERT INTO nhx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Eꞌ yéj kitajtan iga makijuzga̱ro el rey César, iwá̱n nitatekimáꞌ iga mapre̱sojtito este kua̱ꞌ nikti̱tanis iyi̱xtaj César. ");
INSERT INTO nhx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Iwá̱n Agripa kijtoj: —Nej no̱ nikakisneki ken iga ta̱tapowa inó̱n ta̱gaꞌ. Iwá̱n Festo kijtoj: —Mo̱sta tikakis. ");
INSERT INTO nhx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Ipan seꞌya día asitoj Agripa iwá̱n Berenice iwá̱n sekin yej manda̱rowaj ipan weyi‑a̱ltepe̱ꞌ no̱ kitokatia̱yaj yej kimanda̱rowaj solda̱dojmej. Kilwichi̱wilijtiajkij este ijkó̱n kalakkej ka̱n manda̱ro̱lo. Iwá̱n Festo tatekimáꞌ iga makiwajligaka̱n Pablo. ");
INSERT INTO nhx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo kijtoj: —Rey Agripa, iwá̱n amejeme̱n yej nij amonokej, nija onoꞌ in iní̱n ta̱gaꞌ. Miaꞌ judiyojmej yej de Jerusalén iwá̱n no̱ yej de nigaj Cesarea kite̱lwijkej iwá̱n este tzajtzikej iga ne̱tajtanilijkej iga mamomikti. ");
INSERT INTO nhx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Eꞌ nej anikasilij tejté̱ yej aye̱kti yej kajasi iga mamomikti, eꞌ como yéj kitajtan iga makijuzga̱ro rey César Augusto, inó̱n iga nia nikti̱tanili̱ti yéj. ");
INSERT INTO nhx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Eꞌ como anikasi te̱ nikijkuilowiliá rey César iga anikasiliá nité̱ yej aye̱kti kichij iní̱n ta̱gaꞌ, inó̱n iga nimitzwajliguilijkej amejeme̱n. Nimitzwajliguiliá tej nokta Rey Agripa. Tej xikita siga kichij tejté̱ yej aye̱kti, ijkó̱n welja tejté̱ nikijkuilowili̱j. ");
INSERT INTO nhx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Porque akajasi iga manikti̱tani se̱ preso siga anikmati te̱ nokta kichij. ");
INSERT INTO nhx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Iwá̱n Agripa kijlij Pablo: —Wel ximotajtowili. Iwá̱n Pablo kajkoꞌ ima̱ꞌ, iwá̱n pe̱ꞌ tajtoj, kijtoj: ");
INSERT INTO nhx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Nipa̱ki iga nonoꞌ mote̱noj rey Agripa, iga wel manimotajtowili de inochi yej ne̱pantiáj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Porque tej tikmati nochi ken nochipa kichi̱waj judiyojmej iwá̱n no̱ tiki̱xmati ileymej. Inó̱n iga nimitztajtaniliá acho̱ꞌ xine̱kaki. ");
INSERT INTO nhx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","’Nochi judiyojmej ne‑i̱xmatij este kua̱ꞌ aya niyo̱lej. Kimatij ken iga ninemiꞌ ipan nóta̱l wa̱n ipan Jerusalén. ");
INSERT INTO nhx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Iwá̱n kimatij iwá̱n wel kinojma‑ijtowaj siga kinekij, iga nejwaꞌ nokta nifariseoj este iga nichokótzi̱noꞌ. Inó̱mejpa fariseojmej yej má̱j kichi̱waj ken ne̱machtiáj noleymej nejemej nijudiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Iná̱n nigaj nonoꞌ iga ne̱juzga̱rowaj iga san nikchi̱xto yej Dios kijlij no‑ikyapatajwa̱n iga yawi ki‑ojpa‑ixiti̱ti yej miktokej. ");
INSERT INTO nhx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Nonochimej de Israel, nikchi̱xtokej iga yawi mochi̱wati inó̱n yej kijtoj Dios. Inó̱n iga judiyojmej kiweyimati̱ltiáj Dios iwá̱n kichi̱waj ken yéj kineki, semilwiꞌ iwá̱n senyówal. Iná̱n gobernador Agripa, sekin judiyojmej nej ne̱te̱lwijkej iga nikchi̱xtoꞌ no̱ ipan inó̱n yej kijtoj Dios. ");
INSERT INTO nhx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Ix amejeme̱n ayá̱ꞌ ankicre̱dowaj iga Dios wel ki‑ojpa‑ixitiá yej miktokej? ");
INSERT INTO nhx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","’Nej no̱ ikya nikijtowa̱ya iga manikchi̱wa nochi yej wel iga manikikno̱chi̱waka̱n yej moconfia̱rowaj ipan Jesús de Nazaret. ");
INSERT INTO nhx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Iwá̱n ijkó̱n nikchij Jerusalén. Ije̱fejmej sacerdo̱tejmej kiye̱ꞌitakej wa̱n kijtojkej iga manikpre̱sojwi̱ka̱n yej kitokaj Jesucristo; iwá̱n kua̱ꞌ kimiktia̱yaj no̱ nikijtowa̱yaj iga mamomikti. ");
INSERT INTO nhx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Iwá̱n miaꞌ ve̱j nej nikikno̱chi̱wayaj ka̱nsan makikajte̱waka̱n iga moconfia̱rowaj ipan Jesucristo. Inó̱n nikchi̱waya no̱ya̱n ipan tio̱pamej iwá̱n poxsan nikijiyayaj iwá̱n nikte̱mowa̱yaj este ipan a̱ltepe̱mej yej onokej ipan seꞌya país. ");
INSERT INTO nhx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","’Iga inó̱n nokta nej nia̱yaj weyi‑a̱ltepe̱ꞌ Damasco. Niknentiá̱yaya a̱maꞌ ka̱n ne̱tekimakakej ije̱fejmej sacerdo̱tejmej ken manikchi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Eꞌ ipan ojti, tej tinorrey, ken tajkodía, nikitaꞌ ipan cielo ki̱saꞌ se̱ tiꞌti yej ta̱wiá ma̱jya sej que to̱nati̱ꞌ, ne̱ta̱wij nej iwá̱n yej íwa̱n nisenya̱yaj. ");
INSERT INTO nhx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Iwá̱n nisenwetzikej nonochi̱n este ta̱lpan, iwá̱n nikaguiꞌ se̱ tájto̱l, ne̱no̱tzaꞌ ipan hebreo; ne‑ijlij: “Saulo, Saulo, ¿te iga tine‑ikno̱chi̱wa? Tejsan moma̱tika nemi timo‑ikno̱chi̱wa, ken kua̱ꞌ se̱ toro kitiliksa ipu̱ntaj kuawiꞌ yej iga momajmajtiá.” ");
INSERT INTO nhx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Iwá̱n nej nikijlij: “¿A̱ꞌyéj in tej, noTe̱ko?” Iwá̱n toTe̱ko kijtoj: “Nej niJesús yej tej nemi tine‑ikno̱chi̱wa. ");
INSERT INTO nhx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Iná̱n ximoketza. Nimitzi̱xne̱xtilij iga xikchi̱wa ken nimitzijliá iwá̱n iga xiknojma‑ijto yej iná̱n tikitaꞌ iwá̱n yej niaoꞌ nimitzne̱xtili̱ti. ");
INSERT INTO nhx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Ka̱n iná̱n nimitzti̱tani xaj, nia nimitzma̱nawi̱ti ipan ima̱mej judiyojmej iwá̱n yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nimitzti̱tani ka̱n onokej yejemej iga ken kua̱ꞌ xiki̱xtapo̱ka̱n iga ayoꞌ manemika̱n ka̱n takomichka̱n sino que manemika̱n ipan ta̱wi̱lpan, iwá̱n ayoꞌ makimanda̱rojtoka̱n Tzitzimiꞌ, sino que makitokaka̱n Dios; iwá̱n iga mamoconfia̱ro̱ka̱n ipan nej iwá̱n ijkó̱n nikperdona̱rowiliáj yej kichi̱waj yej aye̱kti. Ijkó̱n onoskej ken itatki Dios.” ");
INSERT INTO nhx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","’Inó̱n iga rey Agripa, nej nikchij ken ne‑ijlij inó̱n yej nikitaꞌ yej wa̱laj ipan cielo. ");
INSERT INTO nhx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Iwá̱n pe̱waꞌ iga nikpowaꞌ itájto̱l Dios ipan a̱ltepe̱ꞌ Damasco. Después niajki Jerusalén iwá̱n no̱ya̱n ipan íta̱l Judea. Iwá̱n nikta̱tapo̱wijkej no̱ yej ayéj judiyojmej. Nej nikijlijkej iga makikajte̱waka̱n iga kichi̱waj yej aye̱kti, iwá̱n makicre̱do̱ka̱n Dios, iwá̱n makichi̱wáka̱nya yej ye̱kti iga mane̱si iga kipatákeja ivi̱dajmej. ");
INSERT INTO nhx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Inó̱n iga judiyojmej ne̱ki̱tzkijkej ipan weyitio̱pan, iwá̱n kinekiáj mane̱mikti̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Eꞌ Dios ne̱pale̱wij, iwá̱n este ina̱nsan nikta̱tapo̱wiáj la gente, yej motapialiáj iwá̱n yej ayá̱ꞌ motapialiáj. Nikpowa kensan kijtojkej profe̱tajmej iwá̱n Moisés iga yawi mochi̱wati. ");
INSERT INTO nhx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Yejeme̱n kijtojkej iga Cristo kikno̱chi̱wayaj iwá̱n kimikti̱ayaj iwá̱n yéj yej achto ojpa‑isas, iwá̱n yawi kipowati itájto̱l yej ken kua̱ꞌ te̱ta̱wiá iga wel mamosalva̱ro̱ka̱n judiyojmej iwá̱n yej ayéj judiyojmej. ");
INSERT INTO nhx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Kua̱ꞌ inó̱n kijtoj Pablo iga motajtowilij, Festo kijtoj recio: —¡Tej, Pablo, anka ayꞌya titajla̱ntoꞌ! Iga póxsanya timomachtij, inó̱n iga ayꞌya titajla̱ntoꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Eꞌ Pablo kijtoj: —Ayéj iga ayꞌya nitajla̱ntoꞌ, rey Festo; ma̱jwaꞌ nemi nikijtowa yej ayá̱ꞌ nemi nikte̱nchi̱wa wa̱n yej melaꞌcie̱rtoj. ");
INSERT INTO nhx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Nigaj onoꞌ rey Agripa, yéj kimati nochi de ini̱mej, inó̱n iga animajmawi iga nikijtowa iyi̱xtaj iga nikmati iga yéj no̱ kimati nochi, porque iní̱n ayá̱ꞌ mo‑ichtakachij. ");
INSERT INTO nhx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","In tej rey Agripa, ¿ix ticre̱dowa yej kijtojkej profe̱tajmej? Nej nikmati iga ticre̱dowa. ");
INSERT INTO nhx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa kijtoj: —Alí̱n poliwiá iga tine̱yo̱lyamana iga no̱ maniktoka Cristo. ");
INSERT INTO nhx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablo kijtoj: —Dios makijto iga alí̱n o komati, amo tejsan, sino que inochi no̱ yej nigaj ne̱kaktokej mamochi̱waka̱n ken nej, eꞌ amo ma‑ilpitoka̱n iga cadena. ");
INSERT INTO nhx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kua̱ꞌ tamiꞌ inó̱n kijtoj Pablo, el rey iwá̱n el gobernador iwá̱n Berenice, mokejketztejkej iwá̱n nochi yej ompa e̱watoyaj ");
INSERT INTO nhx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","iwá̱n yajkij iyokamej iga mota̱tapo̱wi̱toj, mosepan‑ijlijkej: —Iní̱n ta̱gaꞌ ayá̱ꞌ kichij nité̱ yej aye̱kti yej kajasi iga mamomikti niga mamopre̱sojwi. ");
INSERT INTO nhx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Iwá̱n Agripa kijlij Festo: —Iní̱n ta̱gaꞌ wel katka momajka̱waya siga ayá̱ꞌ kijtojka iga makijuzga̱ro rey César. ");
INSERT INTO nhx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kua̱ꞌ motajto̱ltíjkeja iga ne̱ti̱tanískeja Italia, Pablo iwá̱n sekin pre̱sojmej kiti̱tankej iwá̱n se̱ capitán yej ito̱ka̱ꞌ Julio yej kimanda̱rowaj sekin isolda̱dojmej rey César. ");
INSERT INTO nhx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nitejkajkej ipan weyi á̱ka̱l ka̱n moketzaj a̱ka̱lmej, inó̱n a̱ltepe̱ꞌ ito̱ka̱ꞌ Adramitio. Inó̱n weyi á̱ka̱l némiya ki̱saya iga yawi a̱te̱n Asia. Tejkaj nowa̱mej se̱ yej ito̱ka̱ꞌ Aristarco yej icha̱n Tesalónica, yej onoꞌ ipan estado de Macedonia. ");
INSERT INTO nhx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Ipan seꞌya día nasikej se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Sidón ka̱n moketza weyi a̱ka̱lmej ompa inó̱n capitán yej ito̱ka̱ꞌ Julio, kiye̱ꞌitaꞌ Pablo, kimáꞌ permiso iga makipaxa̱lowili̱ti iyami̱gojmej, iga yejemej maki‑o̱mema̱wi̱ka̱n. ");
INSERT INTO nhx_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Después niki̱skej Sidón, iwá̱n nipanojkej na̱ꞌ tajkóta̱l Chipre iga ompígapa ayá̱ꞌ niki̱xtajmakaj ejekaꞌ yej paré̱j tajpalej. ");
INSERT INTO nhx_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nipanojkej ipan láma̱r, ite̱noj a̱ltepe̱mej yej ito̱ka̱ꞌ Cilicia iwá̱n Panfilia. Iwá̱n nasitoj ipan a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Mira yej onoꞌ ipan íta̱l Licia. ");
INSERT INTO nhx_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Iwá̱n yej kimanda̱rowa solda̱dojmej kasiꞌ se̱ weyi á̱ka̱l de Alejandría yej yawi Italia. Iwá̱n ipan inó̱n ne̱tejkawi̱ltijkej. ");
INSERT INTO nhx_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Miaꞌ días noyo̱lpamej niajkij. Wa̱n nasikej Gnido eꞌ ijko̱nya í̱ꞌpasan niajkij iga poxsan ejekataj. Eꞌ como niki̱xnamikiajpa ejekaꞌ inó̱n iga nipanojkej iyi̱xtaj a̱ltepe̱ꞌ Salmón, nikyawalojkej tajkóta̱l yej ito̱ka̱ꞌ Creta. ");
INSERT INTO nhx_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Iwá̱n ijkó̱n i̱ꞌsan niajkij, nikweyaꞌkuikej a̱te̱n este que nasikej ipan se̱ a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Buenos Puertos, yej onoꞌ ite̱noj a̱ltepe̱ꞌ yej ito̱ka̱ꞌ Lasea. ");
INSERT INTO nhx_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Eꞌ como nikpolojkej miaꞌ tiempo iga i̱ꞌsan niwa̱lkej ayꞌya wel má̱j niawij ipan weyi á̱ka̱l iga asitiwi̱ꞌ invierno kua̱ꞌ poxsan ejekataj. Inó̱n iga Pablo tano̱no̱tzaꞌ, ");
INSERT INTO nhx_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ijkí̱n kijtoj: —Nokni̱wa̱n, nikita siga ma̱jsan tiawij, wel motzi̱nkuepa weyi á̱ka̱l. Poliwis weyi á̱ka̱l iwá̱n yej kiwi̱ga, iwá̱n wel no̱ tejemej ti‑a̱mikij. ");
INSERT INTO nhx_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Eꞌ capitán yej kimanda̱rowa solda̱dojmej akitajto̱lkui̱lij Pablo, má̱j kitajto̱lkui̱lij yej ite̱ko weyi á̱ka̱l iwá̱n capitán yej kinentia̱ya á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Iwá̱n ompa Buenos Puertos ka̱n moketza a̱ka̱lmej, kitakej iga awel onoskej kua̱ꞌ pox ejekataj. Iwá̱n nochi kijtojkej iga anka má̱j ye̱kti iga maki̱saka̱n ompa iwá̱n maya̱ka̱n a̱ltepe̱ꞌ Fenice ka̱n moketza weyi a̱ka̱lmej. Fenice onoꞌ ipan tajkóta̱l Creta wa̱n kipiá o̱me ka̱n wel ki̱saj a̱ka̱lmej, se̱ al noroeste iwá̱n se̱ al suroeste iwá̱n ompa wel kipano̱lti̱skej kua̱ꞌ ejekataj wa̱n sektaj. ");
INSERT INTO nhx_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Iwá̱n nemi pe̱waya se̱ to̱nalejekatzi̱n, inó̱n iga kijtojkej welja sej ojkuiáj. Ojkuikej, yajkij a̱te̱n yej onoꞌ Creta. ");
INSERT INTO nhx_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Eꞌ aya wejka yawij kua̱ꞌ tzi̱ntiꞌ se̱ ejekaꞌ yej poxsan tajpalej yej ito̱ka̱ꞌ Nordeste wa̱n kitopej á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Iwá̱n como inó̱n weyi á̱ka̱l ki̱xna̱miktiá̱yapa ejekaꞌ, ayꞌya wel má̱j niajkij, niájkijsan ken iga ejekaꞌ kitopejtiá weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nipanojkej iyi̱ka̱n se̱ tajkota̱ltzi̱n yej ito̱ka̱ꞌ Clauda. Ompa weyi á̱ka̱l ayá̱ꞌ poxsan kiwi̱tekiá ejekaꞌ. Weyi á̱ka̱l kitila̱ntiwi̱tziaya se̱ a̱ka̱ltzi̱n ka̱n se̱ wel moma̱nawiá iwá̱n yo̱liꞌ nikakijkej a̱ka̱ltzi̱n a̱ka̱lijtiꞌ iga amo maa̱wetzi a̱ka̱ltzi̱n. ");
INSERT INTO nhx_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Kua̱ꞌ nikakíjkeja in inó̱n a̱ka̱ltzi̱n, kitajko‑ilpijkej inó̱n weyi á̱ka̱l iga maréja̱l amo makitapa̱na. Iwá̱n kitemowilijkej tzotzolmej yej ajko pajpatajtia̱yaj ipan weyi á̱ka̱l iga amo poxsan makitope̱wa ejekaꞌ iga majmawíkeja iwá̱n iga amo kuaka̱witi weyi á̱ka̱l ipan xa̱lyoj yej ito̱ka̱ꞌ Sirte. Iwá̱n yajkij san ken inó̱n weyi á̱ka̱l kitopejtiajki ejekaꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ipan seꞌya día, nentóyasan ejekaꞌ yej tajpalej iwá̱n pe̱waꞌ iga kipajpata̱naltijkej ipan láma̱r yej kiwi̱gaya weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Ipan e̱yi días, nejemej nikijki̱xtilijkej inejkiyomej weyi á̱ka̱l iwá̱n nikpata̱naltijkej ipan láma̱r. ");
INSERT INTO nhx_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Miaꞌ día tamixtzaktoya anikitáyajoꞌ to̱nati̱ꞌ niga si̱talimej, iwá̱n ayoꞌ nikmatiáj siga nimoma̱nawia̱yaj iga póxsanya nentoya ejekaꞌ iwá̱n tiawa̱ꞌ. ");
INSERT INTO nhx_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Kua̱ꞌ kiwí̱gaya miaꞌ días iga ayoꞌ nitakua̱yaj, Pablo moketzaꞌ tajkoya̱n ka̱n onolo̱ꞌ, kijtoj: —Nokni̱wa̱n, maséj anne̱cre̱dojkej ken nimitzijlijkej iga amo matiki̱saka̱n Creta iga san timokno̱chi̱wakoj iwá̱n timotapolowili̱koj. ");
INSERT INTO nhx_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Iná̱n nimitzijliáj iga amo ximajmawika̱n, ayagaj yawi mikiti, weyi á̱ka̱l, kena yawi xi̱xiti̱niti. ");
INSERT INTO nhx_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Pues yowa̱n ne‑i̱xne̱xtili̱ko̱ya se̱ iyá̱ngel Dios, inó̱n Dios yej noTe̱ko yej niktoka. ");
INSERT INTO nhx_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Iwá̱n el ángel ne‑ijlij: “Amo ximajmawi Pablo, iga tia̱ti ite̱noj el rey César, iwá̱n iga tej Dios yawij kima̱nawitij no̱ ino̱mej yej mowa̱n amonokej ipan weyi á̱ka̱l.” Ijkó̱n ne‑ijlij el ángel. ");
INSERT INTO nhx_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Inó̱n iga nimitzijliáj xipa̱kika̱n, nej nimoconfia̱rowa ipan Dios iga yawi mochi̱wati ijkó̱n ken ne‑ijlij. ");
INSERT INTO nhx_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Eꞌ ejekaꞌ yawi te̱tajkalitij ipan se̱ tajkóta̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nikui̱gáyaja catorce días iga nemi niawij. Nonoyaj ipan láma̱r yej ito̱ka̱ꞌ Adriático, nijnijiga ne̱wi̱gayaj ejekaꞌ. Tajkoyówal yej tekipanowaj ipan weyi á̱ka̱l kitakej iga na̱ꞌya kiwi̱ga ta̱lte̱n. ");
INSERT INTO nhx_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kimo̱takej ipan láma̱r yej iga wel makimedi̱ro̱ka̱n iwejkatanka; kipiaya treinta y seis metros. Achi má̱j nejnenkej sej kimedi̱rojkej. Ompa sí kipiáyasan veintisiete metro. ");
INSERT INTO nhx_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Iga majmawiáj iga wel motawi̱tekitij ipan teꞌti, kimajka̱wilijkej na̱wi anclas itzi̱nkóbapa weyi á̱ka̱l iga ayoꞌ manejnemi. Iwá̱n ijkó̱n majmatoyaj, kichakej este que matane̱si. ");
INSERT INTO nhx_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Marine̱rojmej kinekiáj macholo̱ka̱n. Inó̱n iga pe̱waꞌ iga kitemowiáj a̱ka̱ltzi̱n ka̱n moma̱nawilo, kichi̱chijtoyaj ken kua̱ꞌ yawij kimajka̱watij ancla ikua̱pan weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Eꞌ Pablo kijlij capitán yej ito̱ka̱ꞌ Julio iwá̱n isolda̱dojmej: —Siga marine̱rojmej ayá̱ꞌ ka̱wiskej ipan weyi á̱ka̱l, amejeme̱n awel anmoma̱nawi̱skej. ");
INSERT INTO nhx_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Iwá̱n solda̱dojmej kitekilijkej rea̱tajmej yej iga ilpitoya a̱ka̱ltzi̱n iga mawétziya ipan a̱ꞌti. ");
INSERT INTO nhx_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Isajpa kua̱ꞌ tane̱stíwi̱ꞌoꞌ, Pablo tano̱no̱tzaꞌ iga nochi matakua̱ka̱n, kijtoj: —Kiwí̱gaya catorce días iga anemi ankochij niga ankikuaj nité̱. ");
INSERT INTO nhx_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Inó̱n iga nimitzijliáj iga xitakua̱ka̱n, iga ijkó̱n wel anmoma̱nawi̱skej. Nimitzijliáj iga nisé̱ amotzónkal yawi poliwiti. ");
INSERT INTO nhx_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kua̱ꞌ inó̱n kijtoj, Pablo kikuiꞌ se̱ pa̱n iwá̱n kimáꞌ gracias Dios iyi̱xtaj yej ompa onokej, kiposteꞌ iwá̱n pe̱ꞌ iga takuaj. ");
INSERT INTO nhx_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Iwá̱n nochi moyo̱lkuikej iwá̱n takuajkej no̱. ");
INSERT INTO nhx_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Iga nochi yej nonoyaj ipan weyi á̱ka̱l doscientos setenta y seis. ");
INSERT INTO nhx_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Kua̱ꞌ ixwíkeja, kimojmo̱takej trigo lama̱rijtiꞌ iga maajkatiá weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kua̱ꞌ tane̱siꞌ, marine̱rojmej ayá̱ꞌ ta‑i̱xta̱lijkej. Kitakej iga onoꞌ playa ka̱n xomo̱ltitoꞌ láma̱r. Iwá̱n kijtojkej siga ompa wel kinejmaꞌwi̱gayaj weyi á̱ka̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Kitekilijkej ancla irrea̱tajyo iga welya mayawi weyi á̱ka̱l, a̱nclajmej ómpaya ka̱wikej, iwá̱n kikaxa̱nilijkej re̱mojmej yej iga kite̱nkuepaltiájpa weyi á̱ka̱l. Kitejkawi̱ltilijkej weyi á̱ka̱l itzotzolyo yej yawi ikua̱pan. Ijkó̱n iga niktechojtiajkij playa. ");
INSERT INTO nhx_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Nasitoj ka̱n má̱j tajpalej iga moseka̱ntiá o̱me corriente iwá̱n weyi á̱ka̱l kuaka̱wito itzontekon ipan xa̱lyoj yej onoꞌ a̱tampa. Niga weljoꞌ mo̱li̱n. Iwá̱n yej itzi̱nkóbapa, pe̱ꞌ xi̱xiti̱niꞌ iga tajpalej maréja̱l. ");
INSERT INTO nhx_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Solda̱dojmej kimikti̱jnekiáj pre̱sojmej iga amo agaj maa̱pata̱nticholo. ");
INSERT INTO nhx_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Eꞌ yej kimanda̱rowa solda̱dojmej akineꞌ iga makimikti̱ka̱n Pablo. Inó̱n iga tatekimáꞌ iga amo makimikti̱ka̱n pre̱sojmej, ma̱jwaꞌ tatekimáꞌ iga yej wel a̱pata̱ni, yejeme̱n achto mamomo̱taka̱n a‑ijtiꞌ iga wel maasíka̱nya ipan ta̱jli. ");
INSERT INTO nhx_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Iwá̱n sekin, majki̱ltijkej ipan ta̱blajmej o ipan ita̱tajkolka weyi á̱ka̱l. Ijkó̱n nochi asikej ipan tate̱n. ");
INSERT INTO nhx_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Kua̱ꞌ nonochimej nimoma̱nawíjkeja, ni