﻿USE sofia;
DROP TABLE IF EXISTS sofia.nhwBl_vpl;
CREATE TABLE nhwBl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nhwBl_vpl WRITE;
INSERT INTO nhwBl_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Quema pejqui nochi catli onca, Toteco Dios quichijqui ilhuicactli huan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Pero tlaltipactli amo quenicatza nesiyaya, san cactoya, niyon amo tlacualtlalili. San oncayaya se hueyi tzintlayohuilotl catli quiixtzactoya nopa atl catli tlahuel huejcatla. Huan Itonal Toteco Dios nemiyaya aixco. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Huan Toteco Dios quiijto: “¡Ma onca tlahuili!” Huan oncac tlahuili. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Huan Toteco Dios quitlachili nopa tlahuili catli quichijtoya huan quiitac para cuali. Teipa quiiyocatlali nopa tlahuili ica nopa tzintlayohuilotl. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Huan Toteco Dios quitocaxti nopa tlahuili “tonaya” huan nopa tzintlayohuilotl quitocaxti “tlayohua”. Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa achtihui tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Huan Toteco Dios quiijto: “Ma onca ajacatl catli quixelos nopa atl para mocahuas iyoca.” Huan quej nopa elqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Huajca Toteco Dios quichijqui nopa ajacatl catli quixelo nopa atl para tlajco nopa atl mocajqui tlatzintla huan ne seyoc tlajco mocajqui huejcapa. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Huan campa oncac ajacatl quitocaxti “ilhuicactli”. Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa ompa tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Huan Toteco Dios quiijto: “Ma mosansejcotili nopa atl catli eltoc tlatzintla ilhuicactli para ma mopannexti catli huactoc.” Huan quej nopa elqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Huan Toteco Dios quitocaxti catli huactoc “tlali”. Huan nopa atl catli mosansejcotilijtoya quitocaxti “hueyi atl”. Huan Toteco Dios quitlachili catli quichijtoya huan quiitac para cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Huan Toteco Dios quiijto: “Ma temaca nopa tlali nochi tlamantli xihuitl catli xoxohuic huan sesen icone ma eli quen ya. Ma onca xihuitl catli temaca iyol huan cuame catli temacaj inintlajca. Huan sesen tlamantli ma quincahua iconehua catli quen ya.” Huan quej nopa elqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Huajca nopa tlali temacac nochi tlamantli xihuitl catli xoxohuic. Temacac xihuitl catli temacaj ininyol huan cuame catli temacaj inintlajca. Huan sesen ininconehua elqui quen nopa xihuitl o nopa cuahuitl catli temacac. Huan Toteco Dios quitlachili catli quichijtoya huan elqui cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa expa tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Huan Toteco Dios quiijto: “Ma onca tlahuili nepa ilhuicactli para ma tlatlanexti ipan tlaltipactli para quiiyocatlalis tonaya huan tlayohua. Huan para ma tenextilise tlaque tonal, huan tlaque xihuitl huan tlaque ipohual ipan se xihuitl onca. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Huan ma cahuanica nepa ipan ilhuicactli para tlahuilise ipan tlaltipactli.” Huan quej nopa elqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Huajca quej nopa Toteco Dios quichijqui nopa ome huejhueyi tlahuili. Quichijqui tonati catli más hueyi para tlatlanextis tonaya huan nopa metztli para tlatlanextis tlayohua. Huan Toteco Dios nojquiya quinchijchijqui sitlalime. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Huan Toteco Dios quintlali nopa tlahuilme ipan ilhuicactli para ma tlatlanextica ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Nopa hueyi tlahuili para tlahuis tonaya huan catli amo más hueyi tlahuis tlayohua para quej ni moiyocatlalise tlahuili huan tzintlayohuilotl. Huan quiyolpacti Toteco Dios nochi catli quichijtoya pampa elqui cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa najpa tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Huan Toteco Dios quiijto: “Ma temi nopa atl ica miyac tlamantli catli yoltoque. Huan ma temi nochi ilhuicactli ica miyac tlamantli totome catli patlanij.” ");
INSERT INTO nhwBl_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Huajca Toteco Dios quinchijchijqui nochi huejhueyi tlapiyalme catli itztoque ipan hueyi atl huan nochi tlamantli michime. Huan quichijqui para sesen ma quinpiyaca ininconehua quen inijuanti. Huan quinchijchijqui nochi totome huan quichijqui para ma quinpiyaca ininconehua quen inijuanti. Huan Toteco Dios quitlachili nochi catli quichijtoya huan elqui cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Huan Toteco Dios quitiochijqui sesen tlamantli catli quinchijtoya huan quinilhui: “Ximomiyaquilica huan xijtemitica nopa hueyi atl.” Huan Toteco Dios quinnahuati nopa totome: “Xijpiyaca miyac amoconehua huan xijtemitica campa hueli ipan tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa macuilpa tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Huan Toteco Dios quiijto: “Ma onca ipan tlaltipactli nochi tlamantli tlapiyalme. Ma onca tlapiyalme catli mosisiníaj huan catli maxojtzitzi huan nojquiya catli mohuahuatatzaj tlalchi.” Huan quej nopa elqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Huajca quej nopa Toteco Dios quinchijchijqui nochi tlapiyalme huan quintlachili huan nochi quiyolpacti. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Teipa Toteco Dios quiijto: “Ama ma tiquinchihuaca masehualme. Tiquinchihuase ma elica quen tojuanti huan quipiyase totlachiyalis. Huan inijuanti quipiyase tequiticayotl ica michime, huan totome, huan ica tlapiyalme catli mosisiníaj, huan ica catli maxojtzitzi huan ica nochi catli nemij ipan tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Huajca Toteco Dios quinchijqui masehualme ica itlachiyalis. Quena, quen yaya itlachiyalis Toteco Dios quinchijqui. Quinchijchijqui tlacatl huan sihuatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Huan Toteco Dios quintiochijqui huan quinilhui: “Xiquinpiyaca miyac amoconehua para inijuanti itztose campa hueli ipan nochi tlaltipactli para ma tlanahuatica. Nojquiya nimechtlalía xiquinnahuatica nochi michime, totome huan nochi catli nemij ipan tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Huan teipa Toteco Dios quinilhui nopa tlacatl huan sihuatl: “Xiquitaca, nimechmaca nochi tlamantli xihuitl catli quipiya iyol huan nochi cuahuitl catli quipiya itlajca para anquicuase. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Huan nopa tlapiyalme, totome huan nochi sequinoc tlamantli catli nemij ipan tlaltipactli niquinmaca nochi sacatl huan xihuitl catli xoxohuixtoc para inintlacualis.” Huan quej nopa elqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Huan Toteco Dios quitlachili nochi catli quichijtoya huan eltoya cuali. Huan panoc tiotlac huan panoc ijnaloc. Huan ya ni elqui nopa chicuasempa tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Huajca quej nopa Toteco Dios quitlamisencajqui nochi ilhuicactli, huan nochi tlaltipactli huan nochi catli onca nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Quema ajsic nopa chicompa tonal, ya tlantoya catli Toteco Dios quichihuayaya huan mosiyajquetzqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Huan Toteco Dios quitiochijqui nopa chicompa tonali huan quiijto para elis tlatzejtzeloltic pampa ipan nopa tonali ya tlantoya itequi huan mosiyajquetzqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Huajca quej nopa TOTECO Dios quichijqui tlaltipactli huan ilhuicactli. Nica techilhuía quenicatza TOTECO Dios quichijqui ilhuicactli huan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Achtihui amo oncayaya xihuitl niyon amo tleno panquistoya pampa TOTECO Dios ayamo quichijtoya ma huetzi atl ipan tlaltipactli. Nojquiya amo aqui itztoya para tequitis. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Pero masque TOTECO Dios amo quichijtoya ma tlaquiyahui, tlen tlaltitla tlejcoyaya apoctli huan quiatequiyaya tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Huan TOTECO Dios quicuic tlali huan quisencajqui itlacayo se tlacatl. Huan quiyacailpitzqui huan quimacac nemilistli. Huan nopa tlacatl pejqui quipiya nemilistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Teipa TOTECO Dios quitojqui se xochimili catli itoca Edén nepa imelac campa hualquisa tonati. Huan nopona quicajqui nopa tlacatl catli quisencajtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Huan TOTECO Dios quichijqui ma moscalti xochimilijtic nochi tlamantli cuame catli yejyectzitzi nesiyaya huan nochi tlamantli cuame catli temacaj cuatlajcayotl para quicuase. Huan tlatlajco nopa xochimili TOTECO Dios quitojqui se cuahuitl catli temaca itlajca huan itoca Cuahuitl Catli Temaca Nemilistli. Nojquiya quitojqui seyoc cuahuitl ica itlajca huan itoca nopa Cuahuitl Catli Temachiltía Catli Cuali huan Catli Amo Cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ipan Edén oncayaya se hueyatl catli quiatequiyaya nopa xochimili. Huan quema quisayaya, moxelohuayaya ica najcac. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Nopa achtihui amaxali tlen nopa hueyatl itoca Pisón huan ya ni catli tlayahualohuayaya campa hueli ipan nochi nopa tlali catli itoca Havila campa onca oro. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nopa oro tlen nopa tlali eliyaya senquistoc cuali. Nojquiya nopona oncayaya se tlaajhuiyacayotl catli patiyo huan piltetzitzi catli yejyectzitzi catli itoca ónice. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Huan nopa ompa amaxali tlen nopa hueyatl itoca Gihón huan tlayahualohuayaya campa hueli ipan nopa tlali catli itoca Cus. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Huan nopa expa amaxali tlen nopa hueyatl itoca Tigris huan pano iteno tlali Asiria imelac campa hualquisa tonati. Huan nopa najpa amaxali tlen nopa hueyatl itoca Eufrates. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Huajca TOTECO Dios quihuicac nopa tlacatl huan quicajqui ipan nopa xochimili catli itoca Edén para ma quimocuitlahui, ");
INSERT INTO nhwBl_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","huan TOTECO Dios quinahuati: “Huelis tijcuas itlajca tlen hueli cuahuitl ipan ni xochimili, ");
INSERT INTO nhwBl_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","pero ne cuahuitl catli itoca ‘cuahuitl catli temachiltía catli cuali huan catli amo cuali’, amo. Amo xijcualili itlajca, pampa ipan nopa tonal quema tijcuas itlajca, melahuac timiquis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Teipa TOTECO Dios quiijto: “Amo cuali para itztos iseltzi ni tlacatl. Para ma amo cuesihuis, nijchihuilis se acajya catli quinamiquis huan catli quipalehuis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Huan ica tlali TOTECO Dios quinchijtoya nochi tlapiyalme huan nochi totome. Teipa quihuiquili nopa tlacatl para ma quintocaxtlali. Huan catli nopa tlacatl quintocaxtlali, ya nopa elqui inintoca. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Huajca nopa tlacatl quintocaxtlali nochi tlamantli tlapiyalme catli maxojtzitzi, huan nochi totome huan nochi tlapiyalme catli mosisiníaj. Pero niyon se tlen nopa tlapiyalme amo quinamijqui para quipalehuis nopa tlacatl para amo cuesihuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Huajca TOTECO Dios quichijqui ma tlahuel cochi Adán. Huan quema cochtoya, quiquixtili se ielchiqui omiyo huan sempa quimotzquilti inacayo quen eltoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Huan ica nopa tlacatl ielchiqui, TOTECO Dios quisencajqui se sihuatl huan quihuicac campa nopa tlacatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Huan quema nopa tlacatl quiitac nopa sihuatl, quiijto: “¡Ama quena! Ya ni san se ica na, pampa inacayo quisqui nonacayotipa, huan iomiyo quisqui noomiyotipa. Itoca elis ‘sihuatl’, pampa TOTECO Dios nechquixtili tlen na, nitlacatl.” ");
INSERT INTO nhwBl_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Huan yeca se tlacatl quicahuas itata huan inana para mosansejcotilis ihuaya isihua huan nopa ome mochihuase san se inintlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Huan masque nopa tlacatl huan isihua xolome nemiyayaj, amo mopinahuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nopa cohuatl eliyaya catli más tlalnamiqui huan más quimatiyaya quenicatza tlacajcayahuas que nochi sequinoc tlapiyalme catli TOTECO Dios quinchijtoya. Huan se tonal nopa cohuatl quitlatzintoquili nopa sihuatl: ―¿Amo anmechilhuijtoc Dios para amo xijcuaca itlajca niyon se cuahuitl ipan ni xochimili? ");
INSERT INTO nhwBl_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Huan nopa sihuatl quinanquili: ―Huelis tijcuase itlajca tlen hueli cuahuitl, ");
INSERT INTO nhwBl_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","pero iyojtzi ne catli eltoc tlatlajco xochimili Dios techilhuijtoc amo cuali tijcuase, niyon tiquitzquise itlajca ne cuahuitl pampa sintla tijchihuase, timiquise. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Pero nopa cohuatl quiilhui nopa sihuatl: ―Amo neli. Amo anmiquise. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Cuali quimati Dios sintla anquicuase itlajca nopa cuahuitl elis quen anmechtlapolis amoixteyol huan amotlalnamiquilis huan anquimatise catli cuali huan catli amo cuali. Quej nopa anelise quen ya. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Teipa nopa sihuatl momacac cuenta para yejyectzi itlajca nopa cuahuitl huan nesiyaya cuali para quicuas. Huajca quiixtocac pampa nojquiya quinejqui quipiyas tlalnamiquilistli. Yeca quitejqui se huan quicuajqui. Huan teipa quimacac ihuehue huan ya nojquiya quicuajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Huan ipan nopa tlatoctzi elqui quen tlapojqui iniixteyol huan nochi ome momacaque cuenta para xolome itztoyaj huan mopinajque. Huajca quiijtzonque ixihuiyo nopa cuahuitl catli itoca higuera para quichihuase iniixpantzajca huan ica ya nopa motzajque. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Huan teipa ica tiotlac quema tlasesestoc, nopa tlacatl huan isihua quicajque TOTECO Dios nemiyaya xochimilijtic. Huan motlalojque motlatitoj iica nopa cuame para TOTECO Dios ma amo quinita. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Pero TOTECO Dios quinojnotzqui nopa tlacatl huan quitlatzintoquili: ―¿Canque tiitztoc? ");
INSERT INTO nhwBl_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Huan nopa tlacatl tlananquili: ―Nijcajqui para tinemiyaya xochimilijtic huan nimajmajqui pampa nixolotl. Huan yeca nimotlati. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Huajca Toteco Dios quitlatzintoquili: ―Huan ¿ajqueya mitzilhuijtoc para tixolotl? ¿Tijcuajtoc itlajca nopa cuahuitl catli nimitzilhui amo xijcua? ");
INSERT INTO nhwBl_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Huan nopa tlacatl tlananquili: ―Nopa sihuatl catli techmacac para notlahuical, yaya nechmacac se itlajca nopa cuahuitl huan yeca nijcuajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Huajca TOTECO Dios quitlatzintoquili nopa sihuatl: ―¿Para tlen tijchijqui ya ni? Huan nopa sihuatl quinanquili: ―Nopa cohuatl nechcajcayajqui huan yeca nijcuajqui itlajca nopa cuahuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Huan teipa TOTECO Dios quiilhui nopa cohuatl: ―Ica ya ni catli tijchijtoc, tielis más titlatelchihuali que nochi sequinoc tlapiyalme. Huan san timohuahuatatztinemis ipan tlali huan tlaltejpoctli tijcuas nochi monemilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nijchihuas ximocualancaitaca ta ica nopa sihuatl. Huan mocualancaitase moixhui ica ya iixhui. Iixhui mitztzonxamanis huan ta tijcotztlantzacanis. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Huan TOTECO Dios quiilhui nopa sihuatl: ―Nijchihuas xineltlaijiyohui quema ticonepiyas huan ica tlacuajcualoli titlatlacatiltis. Pero ta tijnequis mohuehue, huan yaya mitznahuatis. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Huan TOTECO Dios quiilhui nopa tlacatl: ―Pampa tijneltoquili mosihua huan tijcuajqui itlajca nopa cuahuitl catli nimitzilhui amo xijcua, tlatelchihuali elis nochi tlali por ta motlajtlacol. Huan ica miyac tequitl tijpiyas catli tijcuas nochi monemilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Nopa tlali quiixhualtis huitztli huan sahua mecatl. Huan tijcuas nopa cuali xihuitl catli moscaltis nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Huan timitonis miyac para tijpantis tlacualistli catli ica timopanoltis hasta quema timiquis huan timocuepas tlali sempa. Na nijchijqui motlacayo ica tlali, huan quema timiquis, sempa timocuepas tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Huan Adán quitocaxti isihua Eva. (Eva quinequi quiijtos “nemilistli”.) Huan Eva elqui ininnana nochi masehualme catli itztoque. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Huan TOTECO Dios quinchihuili Adán huan Eva ininyoyo ica inincuetlaxo tlapiyalme huan quinyoyonti. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Huan TOTECO Dios moilhui: “Ama ni masehualme mocueptoque quen tojuanti pampa quimatij catli cuali huan catli amo cuali. Sintla quitequise itlajca nopa Cuahuitl Catli Temaca Nemilistli, itztose para nochipa quej ni.” ");
INSERT INTO nhwBl_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Huajca TOTECO quinquixti tlen nopa xochimili catli itoca Edén. Huan quititlanqui ma tequiti ipan nopa tlali catli ica quisencajtoya itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Huan teipa quema TOTECO Dios quintojtocatoya, quintlali sequin itequihuajcahua catli inintoca querubines para itztose imelac nopa xochimili ica campa hualquisa tonati para ma quimocuitlahuica nopa xochimili. Huan TOTECO Dios nojquiya quitlali nopona se machete catli lementoya huan moyahualohuayaya campa hueli para amo aqui ma ajsi campa nopa Cuahuitl Catli Temaca Nemilistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Huan Adán cochqui ihuaya isihua, huan isihua conecuic huan quitlacatilti se oquichpil catli quitocaxti Caín. (Caín quinequi quiijtos “nijpixtoc”.) Quej nopa quitocaxti pampa Eva quiijto: “Ica itlapalehuil TOTECO nijpixtoc se tlacatl.” ");
INSERT INTO nhwBl_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Huan teipa Eva quitlacatilti seyoc oquichpil catli quitocaxtlali Abel. Huan quema nopa ome moscaltijque, Abel quinmocuitlahui borregojme, huan Caín miltequitqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Huan se tonal Caín quihualiquili TOTECO se tlacajcahualistli catli quipixcatoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Huan Abel nojquiya quihualiquili TOTECO sequin borregojme catli más tomahuaque huan catli achtihui tlacatque. Huan quinmicti huan quimacac TOTECO. Huan TOTECO quicualitac Abel ica itlacajcahualis huan quiseli. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Pero ica Caín huan itlacajcahualis amo quicualitac. Yeca Caín cualanqui miyac huan fiero tlachixtinenqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Huajca TOTECO quiilhui Caín: “¿Para tlen ticualani huan fiero titlachixtinemi? ");
INSERT INTO nhwBl_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","¿Amo tijmati sintla tijchihuas catli cuali, nimitzselis huan tipaquis? Pero sintla amo tijchihua catli cuali, mitztlanis tlajtlacoli. Nopa tlajtlacoli eltoc quen se tecuani catli mitzchiya mocalteno huan quinequi mitztlanis, pero monequi ta xijtlanis ya.” ");
INSERT INTO nhwBl_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Huan panoc se ome tonali huan Caín quinotztejqui iicni Abel huan quiilhui: ―Ma tiyaca cuatitla. Huan quema ajsitoj cuatitla, Caín quihuilanqui iicni Abel huan quimicti. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Huajca TOTECO quitlatzintoquili Caín: ―¿Canque itztoc moicni Abel? Huan Caín quinanquili: ―Amo nijmati na. Amo notequi para nijmocuitlahuis noicni. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Huan TOTECO quiilhui: ―¿Para tlen tijchijtoc ya ni? Tijmicti moicni huan ieso tijtoyajtoc ipan tlali. Huan ama eltoc quen ieso nechtlajtlanía chicahuac ma nimitztlatzacuilti. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Huajca ama, por catli tijchijtoc, nimitztelchihuas. Ayacmo huelis titequitis ipan tlali pampa tijnenpolojtoc ica ieso moicni. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Huan masque titlatojtocas, ayacmo tleno tiqueliltis. Monequi san tinentinemis campa hueli ipan tlaltipactli huan amo cana tijpiyas para timochantlalis. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Huajca Caín quinanquili TOTECO: ―Nelchicahuac ni tlatzacuiltili huan amo huelis niquijiyohuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ama techtojtoca huejca tlen ni tlali huan ayacmo huelis nimitznechcahuis ta. Nielis se ninejnenquetl campa hueli tlali huan amo huelis nimosiyajquetzas. Quej ni aqui hueli nechpantis, nechmictis. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pero TOTECO quinanquili: ―¡Amo! Sintla acajya mitzmictis, nijtlatzacuiltis chicome huelta más para nijcuepilis. Huajca TOTECO quitlalili Caín se tlanextilijcayotl para nochi quiiximatisquíaj para yaya huan amo quimictisquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Huan Caín quistejqui campa ihuaya camanaltiyaya TOTECO huan yajqui itztoti ipan se tlali itoca Nod catli mocahua imelac Edén para campa hualquisa tonati. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Huan Caín ihuaya cochqui isihua, huan yaya conecuic huan quitlacatilti se oquichpil catli itoca Enoc. Teipa Caín quichijqui se altepetl huan quitocaxti nopa altepetl Enoc quen itoca icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Huan Enoc motlacachijqui huan elqui itata Irad. Huan teipa Irad moscalti huan elqui itata Mehujael. Huan teipa Mehujael motlacachijqui huan elqui itata Metusael. Huan Metusael moscalti huan elqui itata Lamec. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Huan Lamec quinpixqui ome isihuajhua; se itoca Ada huan ne seyoc Zila. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Huan Ada quitlacatilti Jabal. Huan Jabal motlacachijqui huan elqui inintata masehualme catli mocajque ipan calme tlen yoyomitl huan quinxinajchohuayayaj huan quiniscaltiyayaj tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Huan Jabal quipixqui se iicni catli itoca Jubal. Huan Jubal moscalti huan quiyoliti tlapitzali huan nopa tlatzotzonali catli itoca arpa. Huan yaya elqui inintata masehualme catli tlatzotzonaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Huan Zila, nopa seyoc isihua Lamec, quitlacatilti se oquichpil catli itoca Tubal Caín catli elqui se teposchijquetl. Huan Tubal Caín quitejtzonqui nopa tepostli catli itoca bronce huan catli itoca hierro huan ica nopa tepostli quisencahuayaya miyac tlamantli. Huan Tubal Caín quipixqui se isihua icni catli itoca Naama. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Huan se tonal Lamec quinilhui iome sihuajhua Ada huan Zila: “Xijtlacaquilica cuali catli nimechilhuis. Nijmicti se tlacatl pampa nechcoco. Huan elqui se telpocatl catli nechmaquilijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Sintla se acajya quichihuilisquía se tlenijqui Caín, quiselisquía se tlatzacuiltilistli chicome huelta más chicahuac. Pero sintla se acajya nechcuepilisquía catli nijchijtoc na, niLamec, monequisquía quiselis se tlatzacuiltili catli amo san chicome hueltas, pero se catli elis tlahuel onpano más chicahuac.” ");
INSERT INTO nhwBl_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Huan Adán cochqui ihuaya isihua, huan isihua sempa conepixqui huan quitlacatilti seyoc oquichpil catli quitocaxti Set. (Set quinequi quiijtos “nechmacatoc”.) Quej nopa quitocaxti pampa quiijto: “Toteco Dios nechmacatoc seyoc conetl ipatlaca Abel catli Caín quimicti.” ");
INSERT INTO nhwBl_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Huan quema Set motlacachijqui, quipixqui se icone catli quitocaxti Enós. Huajca ipan nopa tonali tlacame pejque quihueyichihuaj TOTECO san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ya ni inintoca iteipan ixhuihua Adán: Quema Toteco Dios quinchijqui masehualme, quinsencajqui quen ya itlachiyalis. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Quinsencajqui tlacame huan sihuame huan ipan nopa tonal quema quinchijqui, quintiochijqui huan quintocaxti “masehualme”. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Huan quema Adán quipixqui 130 xihuitl, tlacatqui icone catli elqui quen ya huan san se inintlachiyalis huan quitocaxti Set. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Huan quema ya tlacajtoya Set, Adán noja itztoya seyoc 800 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Huan mijqui Adán quema quipixqui 930 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Huan Set quipiyayaya 105 xihuitl quema tlacatqui icone, Enós. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Teipa Set noja itztoya seyoc 807 xihuitl huan noja quinpixqui sequinoc iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Huan mijqui Set quema quipixqui 912 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Huan Enós quipiyayaya 90 xihuitl quema tlacatqui icone, Cainán. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Teipa Enós noja itztoya seyoc 815 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Huan Enós mijqui quema quipixqui 905 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Huan Cainán quipiyayaya 70 xihuitl quema tlacatqui icone, Mahalaleel. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Teipa Cainán itztoya seyoc 840 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Huan Cainán mijqui quema quipixqui 910 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Huan Mahalaleel quipiyayaya 65 xihuitl quema tlacatqui icone, Jared. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Teipa Mahalaleel itztoya seyoc 830 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Huan mijqui Mahalaleel quema quipixqui 895 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Huan Jared quipiyayaya 162 xihuitl quema tlacatqui icone, Enoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Teipa, Jared itztoya seyoc 800 xihuitl más huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Huajca nochi xihuitl catli itztoya Jared quiaxiti 962 xihuitl huan huajca mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Huan Enoc quipiyayaya 65 xihuitl quema tlacatqui icone, Matusalén. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Huan Enoc nochipa quichijqui ipaquilis Toteco Dios. Huan teipa quema Matusalén ya tlacajtoya, Enoc itztoya seyoc 300 xihuitl más huan noja quinpixqui sequinoc iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Huajca ica nochi Enoc quiaxiti 365 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Huan pampa Enoc nochipa nejnentoya quen Toteco Dios ipaquilis, se tonal polijqui pampa Toteco Dios quihuicac. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Huan Matusalén quipiyayaya 187 xihuitl quema tlacatqui icone catli quitocaxti Lamec. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Huan teipa Matusalén itztoya seyoc 782 xihuitl más huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Huajca ica nochi Matusalén quiaxiti 969 xihuitl huan huajca mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec quipiyayaya 182 xihuitl quema tlacatqui icone, ");
INSERT INTO nhwBl_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","huan quitocaxti Noé. (Noé quinequi quiijtos “techyoltlalis”.) Quej nopa quitocaxti pampa quiijto: “TOTECO quitelchijqui ni tlali, huan monequi titequitise tlahuel chicahuac para titlaeliltise, pero ni conetl techyoltlalis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Huan teipa quema Noé ya tlacajtoya, Lamec noja itztoya seyoc 595 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Huajca nochi xihuitl catli itztoya Lamec quiaxiti 777 huan huajca mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Huan Noé quipiyayaya 500 xihuitl quema tlacatque iconehua, Sem, Cam huan Jafet. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Huan masehualme pejque momiyaquilíaj ipan ni tlaltipactli huan quinpixque iniichpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Huan ipan nopa tonali sequin catli quintocaxtiyayaj “itelpocahua Toteco Dios” 6:2 Sequin masehualme catli miyac momachtijtoque Icamanal Toteco moilhuíaj para “itelpocahua Toteco Dios” camanalti tlen itequihuajcahua Toteco. Nica moilhuíaj camanalti tlen nopa itequihuajcahua catli mosisinijque ica Toteco huan quitoquilijque Amocualtlacatl, huan yeca mocuepque catli tiquintocaxtíaj ajacame. Sequinoc masehualme moilhuíaj para “itelpocahua Toteco Dios” camanalti tlen iteipan ixhuihua Set catli achtihui quitoquilijque Toteco, pero teipa miyac tlen inijuanti pejque mosihuajtíaj ica iniichpocahua masehualme catli amo quiiximatiyayaj Toteco. quinitaque para yejyectzitzi iniichpocahua masehualme ipan ni tlaltipactli. Huajca quintlapejpenijque catli quinixtocayayaj huan quincuique para ininsihuajhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Huan TOTECO quiijto: “Notonal amo quinijiyohuis masehualme huan inintlajtlacolhua para nochipa pampa masehualme san panoni. Huajca ama niquincahuilis ni masehualme ma itztoca san se 120 xihuitl.” ");
INSERT INTO nhwBl_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Huan ipan nopa tonali huan nojquiya teipa itztoyaj huejcapantique tlacame ipan tlaltipactli. Inijuanti nesque quema nopa “itelpocahua Toteco Dios” mosansejcotilijque ihuaya iniichpocahua masehualme para quinpiyase coneme ininhuaya. Huejcajya inijuanti itztoyaj huejhueyi masehualme catli nochi quiniximatiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Huan TOTECO quiitac para nelmiyac inintlaixpanolhua masehualme ipan tlaltipactli huan nochipa moilhuiyayaj catli amo cuali quichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Yeca ica tequipacholi TOTECO pejqui moyolpatla. Monejnehuili sintla cuali elqui para quinchijtoya masehualme huan nelía quiyolcoco. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Huan TOTECO quiijto: “Niquinpolihuiltis masehualme catli niquinsencajtoc ipan tlaltipactli. Nojquiya niquinmictis nochi tlapiyalme, totome huan catli mohuahuatatzaj tlalchi. Nimotequipachohua huan nimoilhuía: ¿Para tlen niquinsencajqui?” ");
INSERT INTO nhwBl_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Pero Noé quipanti catli cuali pampa TOTECO quicualitac. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ama nimechpohuilis catli panoc ica Noé. Noé eliyaya se cuali tlacatl iixpa Toteco Dios. Niyon se ipan nopa tonali amo huelqui quitelhui ica niyon se tlamantli. Yaya nejnenqui quen Toteco Dios quinequiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Huan Noé quinpixqui eyi itelpocahua. Inintoca elque Sem, Cam huan Jafet. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Huan ipan nochi tlaltipactli campa hueli oncac catli fiero iixpa Toteco Dios huan nochi masehualme san mosisiniyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Huan Toteco Dios quiitac para nelfiero eltoya, huan nochi masehualme san mocuapolojtoyaj ipan tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Huajca Toteco Dios quiilhui Noé: “Niquinpolihuiltis nochi masehualme campa hueli ipan tlaltipactli pampa nochi san mosisiníaj, yeca niquinixpolos ica nochi catli onca. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Huajca xijchihua se cuaacali ica nopa cuahuitl catli itoca resina huan calijtic xijchihuili pilcuartojtzitzi. Xijtzacua ica chapopojtli campa hueli iijtic huan ipani para ma amo calaquis atl. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Quej ni xijchihua nopa cuaacali. Xijchihua 135 metros ihuehueyaca, 22 metros huan tlajco ipatlajca huan 13 metros huan tlajco ihuejcapanca. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Xijchihua nopa cuaacali ica eyi pisos huan xijtlali se ventana nechca tlapamitl. Huan xijtlali se puerta ipan se lado. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Nijtitlanis tlahuel miyac atl catli momanas huejcapa hasta quitzonpolihuiltis nochi tlali huan nochi catli quipiyaj nemilistli campa hueli ipan tlaltipactli. Nochi catli onca ipan tlali polihuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Pero nijcahua nocamanal mohuaya para nimechmocuitlahuis ipan nopa cuaacali. Huan ta ticalaquis ipan cuaacali huan calaquise mohuaya mosihua, motelpocahua huan moyexhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nojquiya tiquinhuicas mohuaya ome tlapiyalme, se oquichtli huan se sihuatzi tlen nochi tlamantli tlapiyalme catli itztoque ipan tlaltipactli para ma noja itztoca mohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mohuaya calaquise ome tlen nochi tlamantli totome, tlapiyalme huan catli mohuahuatatzaj para ma amo miquica. ");
INSERT INTO nhwBl_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Nojquiya xijhuica mohuaya nochi tlamantli tlacualistli catli monequis anquicuase amojuanti huan nochi nopa tlapiyalme.” ");
INSERT INTO nhwBl_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Huan Noé quichijqui nochi quen Toteco Dios quiilhuijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Teipa TOTECO quiilhui Noé: “San ta tlen nochi masehualme catli ama itztoque tijchihua catli xitlahuac. Yeca xicalaqui ipan cuaacali ininhuaya mosihua huan moconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Xiquinhuica mohuaya chicome oquichme huan chicome sihuatzitzi tlen nochi tlamantli tlapiyalme catli cuali para tlacajcahualistli. Pero xijhuica san se oquichtli huan se sihuatzi tlen nopa tlapiyalme catli amo motequihuíaj para tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Nojquiya xiquinhuica chicome oquichme huan chicome sihuatzitzi tlen nochi tlamantli totome para amo polihuis ininxinajcho ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Pampa ica chicome tonali nijchihuas ma tlaquiyahui, huan tlaquiyahuis para 40 tonali huan 40 yohuali. Quej nopa niquinpolihuiltis nochi catli yoltoque catli niquinsencajtoc ipan ni tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Huan Noé quichijqui nochi quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Huan Noé quipiyayaya 600 xihuitl quema momanqui nochi nopa miyac atl para quiatzonpolihuiltis tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Huan Noé calajqui ipan cuaacali ininhuaya iconehua, isihua huan iyexhua para momanahuise tlen nopa miyac atl catli hualas. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Huajca ojome hualajque nochi nopa tlapiyalme campa Noé. Hualajque tlapiyalme catli cuali para tlacajcahualistli huan catli amo cuali para tlacajcahualistli, catli patlanij huan catli mohuahuatatzaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Ojome nochi hualajque campa Noé huan calajque ipan cuaacali. Calajque se oquichtli huan se sihuatzi tlen sesen tlamantli tlapiyali quen Toteco Dios tlanahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Huan ica chicome tonali hualajqui tlahuel miyac atl ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Quema Noé quipiyayaya 600 xihuitl, ipan nopa 17 tonali tlen nopa ompa metztli tlapojqui nochi amelme campa meyayaya nopa atl catli onca tlatzintla huan tlahuel pejqui toponi atl. Huan pejqui huetzi nelía miyac atl catli amo moquetzqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Huan para 40 tonali huan 40 yohuali huetziyaya atl ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Quena, ipan san se nopa tonal quema pejqui huetzi atl, Noé calajqui ipan cuaacali ihuaya iconehua, Sem, Cam huan Jafet. Huan ihuaya isihua huan eyi iyexhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Huan ininhuaya calajque nochi tlamantli tecuanime catli mosisiníaj, huan tlapiyalme catli maxojtzitzi, huan nochi catli mohuahuatatzaj tlalchi huan nochi tlamantli totome. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nochi tlapiyalme calajque ihuaya Noé ipan cuaacali ica ininhuical. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Calajqui se oquichtli huan se sihuatzi quen Toteco Dios quinahuatijtoya Noé. Teipa TOTECO quitzajqui ipuerta nopa cuaacali. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Huan para 40 tonali san atl hualayaya. Huan quema pejqui tlejco nopa atl, nopa cuaacali motlananqui huan pejqui aixco nemi. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Huan nopa atl noja más tlejcoc huan tlahuel huejcatla mochijqui, pero nopa cuaacali nejnentiyajqui aixco. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Huan teipa noja más tlejcotiyajqui hasta quinatzonpolihuilti nopa tepeme catli más huejcapantique ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Huan teipa quema ya quitzactoya nopa tepeme noja tlejcoc nopa atl seyoc chicueyi metros iixco nopa tepeme. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Yeca quej nopa mijque nochi catli itztoyaj ipan tlaltipactli. Mijque nochi totome, huan tecuanime catli mosisiníaj huan tlapiyalme catli maxojtzitzi. Nojquiya mijque nochi tlamantli piltlapiyaltzitzi catli mohuahuatatzaj tlalchi huan nochi masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nochi catli itztoyaj ipan tlaltipactli catli tlaijiyotilanayayaj mijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","San Noé huan nochi catli itztoyaj ipan cuaacali mocajque. Nochi sequinoc quinpolihuilti. Nochi masehualme, tlapiyalme, totome huan nochi catli mohuahuatatzaj mijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Huan nopa atl quitzonpolihuilti nochi tlaltipactli para 150 tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Huajca Toteco Dios quielnamijqui Noé ica nochi nopa tlapiyalme catli itztoyaj iijtic cuaacali. Huan Toteco Dios quichijqui ma tlaajaca ipan tlali, huan nopa atl pejqui temo. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Huan motzajque nopa amelme campa meyayaya atl tlatzintla tlaltipactli, huan motzajqui nepa ilhuicac huan ayacmo tlaquiyajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Huan nopa atl pejqui yolic temoti. Huan ica seyoc 150 tonali miyac temotoya nopa atl. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Huan quema ajsic nopa 17 tonali tlen nopa chicompa metztli, nopa cuaacali motlalito ipan se tepetl ipan nopa tepeme catli itoca Ararat. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Huan mojmostla más temotiyohuiyaya nopa atl. Huan quema ajsic nopa achtihui tonal tlen nopa majtlacpa metztli, nesqui inintzonatipa nopa tepeme catli más huejcapantique. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Huajca Noé quichixqui seyoc 40 tonali huan quitlapo nopa ventana catli quichijtoya ipan nopa cuaacali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Huan quimajcajqui se cacalotl. Huan nopa cacalotl san patlantinenqui campa hueli hasta huajqui tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Teipa nojquiya quimajcajqui se paloma para quiitasquía sintla ya huajqui nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Pero nopa paloma mocuepqui ipan cuaacali pampa amo cana quipanti para mosiyajquetzas, pampa nopa tlali noja temitoya ica atl. Huajca Noé quiquixti imax, quiitzqui nopa paloma huan quicalaqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Huajca Noé quichixqui seyoc chicueyi tonali huan sempa quititlanqui nopa paloma calteno tlen nopa cuaacali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Huan ica tiotlac quema pejtoya tzintlatlayohuiya, nopa paloma mocuepqui huan quihualicayaya ipan itenchapich imaxihuiyo se cuahuitl catli itoca olivo. Quej nopa Noé momacac cuenta para nopa tlali huactiyohuiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Huan Noé sempa quichixqui seyoc chicome tonal huan sempa quititlanqui nopa paloma, pero ama quena, nopa paloma ayacmo mocuepqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Huajca quema Noé quipiyayaya 601 xihuitl ipan nopa achtihui tonal tlen nopa achtihui metztli, tlantoya nopa atl. Huan Noé quiquixtili ipantzajca nopa cuaacali huan quiitac nochi huactinemiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Huan ipan nopa tonal 27 itequi nopa ompa metztli, ya tlami huactoya nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Huajca Toteco Dios quiilhui Noé: ");
INSERT INTO nhwBl_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Xiquisa tlen nopa cuaacali ihuaya mosihua, moconehua huan moyexhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Nojquiya xiquinquixti nochi tlapiyalme catli itztoque mohuaya. Xiquinquixti nopa totome huan nochi tlapiyalme para ma yaca huan ma quinpiyaca miyac ininconehua huan ma quitemitica ni tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Huajca Noé, huan isihua, huan iconehua huan iyexhua quisque tlen nopa cuaacali. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Nojquiya quisque nochi totome, huan nochi tlapiyalme catli mosisiníaj, huan catli maxojtzitzi huan nochi catli mohuahuatatzaj. Huan sesen tlamantli tlapiyali quisqui ica iconehua catli quitoquiliyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Teipa Noé quichijqui se tlaixpamitl para TOTECO. Huan quicuic tlen sesen tlamantli tlapiyali huan sesen tlamantli tototl catli cuali para tlacajcahualistli. Huan quinmicti huan quintlati ipan nopa tlaixpamitl para se tlacajcahualistli para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Quema TOTECO quiijnejqui ipocyo catli ajhuiyac, yaya moilhui: “Amo quema más nijtlatzacuiltis tlaltipactli por inintlajtlacolhua masehualme pampa se masehuali hasta quema tlacati san moilhuía tlen amo cuali para quichihuas. Nojquiya ayacmo quema niquinpolihuiltis nochi tlapiyalme quej nijchijqui ni huelta.” ");
INSERT INTO nhwBl_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Nochi tonali quema eltos ni tlaltipactli, Oncas toquistli huan pixquistli. Nochipa oncas tlatotonilotl huan tlasesecayotl. Oncas metztli quema tlahuaquis huan metztli quema huetzis miyac atl, Nochipa oncas tonaya huan tlayohua. Ni tlamantli amo quema tlamis quema noja eltos tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Huan Toteco Dios quitiochijqui Noé huan iconehua ica ni camanali: “Xiquinpiyaca miyac amoconehua huan xijtemitica ni tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Nochi tlapiyalme ipan tlaltipactli anmechimacasise. Anquipiyase tlanahuatili ica nochi totome ipan ajacatl, huan nochi tlapiyalme ipan tlali huan nochi catli itztoque ipan hueyi atl. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Huelis anquincuase nochi tlapiyalme pampa nimechmaca nochi catli itztoque para amotlacualis quen nojquiya nimechmacatoc nochi xihuitl catli xoxohuic. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Pero onca se tlamantli catli amo cuali para anquicuase. Amo xijcuaca nacatl ica ieso pampa inemilis se tlapiyali eltoc ipan ieso. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Amo xitemicti. Sintla se acajya quimictis se masehuali, monequi miquis. Huan sintla se tlapiyali quimictis se masehuali, monequi miquis. Quena, monequi se masehuali nechmacas cuenta tlaque quinchihuilijtoc sequinoc masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Sintla acajya quimictía se masehuali, monequi sequinoc quimictise nopa temictijquetl. Pampa Toteco Dios quichijchijtoc se masehuali quen ya itlachiyalis. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Pero amojuanti, xiquinpiyaca miyac amoconehua. Quena, ximomiyaquilica huan xijtemitica ni tlaltipactli, ica amoixhuihua huan amoteipan ixhuihua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Teipa Toteco Dios quinilhui Noé huan iconehua: ");
INSERT INTO nhwBl_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ama nijcahua nocamanal ica amojuanti huan amoteipan ixhuihua, ");
INSERT INTO nhwBl_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","huan ica nochi totome, huan nochi tlapiyalme catli itztoque ipan tlaltipactli huan ica nochi catli quisque ipan cuaacali amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Nijcahua nocamanal para ayacmo quema niquinpolihuiltis sempa nochi masehualme huan nochi tlapiyalme ica miyac atl campa hueli. Ayacmo quema oncas tlahuel miyac atl catli momanas campa hueli ipan nochi tlaltipactli para quisosolos. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ya ni elis nopa tlanextilijcayotl tlen nopa camanali catli nijchihua amohuaya huan ininhuaya nochi tlapiyalme para nochipa. Quinextis ayacmo quema oncas tlahuel miyac atl hasta quinmictis nochi masehualme huan tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nijtlalijtoc noacosamalo ipan mixtli huan eltos quen se tlanextilijcayotl tlen nopa catli nijtencahuilía ni tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Huan quema nijchihuas ma huala mixtli ipan tlaltipactli, noacosamalo monextis ipan nopa mixtli, ");
INSERT INTO nhwBl_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","huan huajca niquelnamiquis nocamanal catli nijcajqui amohuaya huan ininhuaya nochi tlamantli tlapiyalme. Ayacmo quema oncas tlahuel miyac atl campa hueli hasta quinpolos nochi tlamantli catli itztoque. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Pampa quema nopa acosamalotl monextis ipan mixtli, niquitas huan niquelnamiquis nopa camanali catli na, niamoTeco Dios, nijchijtoc para nochipa amohuaya huan ininhuaya nochi masehualme huan nochi tlapiyalme catli itztoque ipan ni tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ni acosamalotl elis nopa tlanextilijcayotl tlen nopa camanali catli nijcajtoc ininhuaya nochi masehualme huan tlapiyalme ipan tlaltipactli.” Quej nopa Toteco Dios quiilhui Noé. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Iconehua Noé catli ihuaya quisque ipan cuaacali elque Sem, Cam huan Jafet. Huan Cam elqui itata Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Tlen ni ieyi telpocahua Noé quisque nochi masehualme catli teipa momoyajque campa hueli ipan tlaltipactli para quitemitise. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Huan Noé catli momatqui miltequiti, quitojqui se xocomeca mili. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Huan teipa se tonal quiijic miyac xocomeca atl huan ihuintic. Huan huetzqui xolotl icalijtic ipan ichaj catli tlasencahuali ica yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Huan quema Cam, catli eliyaya itata Canaán, quiitac para itata huetztoya xolotl, yajqui quinpohuilito iicnihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Huajca Sem huan Jafet quicuique se yoyomitl huan quitlalijque iniajcolpa huan icanejnentiyajque para amo quiitase inintata xolotl. Huan quema calajque ipan icalijtic, tlachixtiyajque seyoc lado para amo quiitase Noé huan quitzajque Noé ica nopa yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Huan quema Noé isac huan ayacmo ihuintitoya, quimatqui catli Cam, icone teipan ejquetl, quichijtoya huan quimatqui para amo quitlepanitztoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Huajca quiijto: “¡Toteco Dios ma quitelchihua Canaán! ¡Ma elis inintequipanojca sequinoc, huan amo aqui ma quitlepanitas!” ");
INSERT INTO nhwBl_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Huan Noé nojquiya quiijto: “Ma tijhueyitlalica TOTECO catli Sem quihueyimati. Huan Canaán ma elis itequipanojca Sem.” Huan nojquiya quiijto: ");
INSERT INTO nhwBl_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","“Toteco Dios más ma quihueyili itlal Jafet. Huan iteipan ixhuihua Jafet ma itztoca ininhuaya iteipan ixhuihua Sem. Huan Canaán ma eli inintequipanojca.” ");
INSERT INTO nhwBl_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Huan quema tlanqui nopa miyac atl, Noé noja itztoya seyoc 350 xihuitl, ");
INSERT INTO nhwBl_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","huan mijqui quema quipiyayaya 950 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Sem, Cam huan Jafet eliyayaj iconehua Noé huan ya ni iniixhuihua catli quinpixque quema ya tlantoya nopa miyac atl catli momanqui ipan nochi tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Itelpocahua Jafet elque: Gomer, Magog, Madai, Javán, Tubal, Mesec huan Tiras. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Itelpocahua Gomer elque: Askenaz, Rifat huan Togarma. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Itelpocahua Javán elque: Elisa, Tarsis, Quitim huan Dodanim. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Huan iixhuihua Jafet teipa momiyaquilijque huan mocajque nechca hueyi atl ipan campa hueli tlalme campa camanaltiyayaj ica sese inincamanal. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Itelpocahua Cam elque: Cus, Mizraim, Fut huan Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Itelpocahua Cus elque: Seba, Havila, Sabta, Raama huan Sabteca. Itelpocahua Raama elque: Seba huan Dedán. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Huan Cus nojquiya elqui itata Nimrod catli quipixqui miyac chicahualistli campa hueli ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nochime quitocaxmatiyayaj Nimrod huan quimatiyayaj para ica itlapalehuil TOTECO elqui se cuali tlapejquetl. Yeca quema masehualme quihueyitlaliyayaj se tlacatl, quiijtosquíaj: “Yaya itztoc quen Nimrod, se cuali tlapejquetl ica itlapalehuil TOTECO.” ");
INSERT INTO nhwBl_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nopa achtihui altepeme catli moscaltijque ipan itlanahuatil Nimrod elqui Babel, Erec, Acad huan Calne ipan tlali Sinar. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Huan itlanahuatil Nimrod pejqui ipan tlali Sinar huan momoyajqui hasta tlali Asiria. Yaya quichijqui nopa altepeme catli itoca Nínive, Rehobot huan Cala. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Huan quichijqui Resén catli eltoya tlatlajco nopa hueyi altepetl Nínive huan Cala. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Huan Mizraim elqui inintata: Ludim, Anamim, Lehabim, Naftuhim, ");
INSERT INTO nhwBl_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusim, Caftorim huan Casluhim catli elqui ininhueyi tata nopa filisteos. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Huan Canaán elqui itata iachtihui ejca catli itoca: Sidón huan quipixqui se iteipan ejca catli itoca eliyaya Het. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Huan Canaán nojquiya itztoya ininhuejcapan tata nopa masehualme: jebuseos, amorreos, gergeseos, ");
INSERT INTO nhwBl_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveos, araceos, sineos, ");
INSERT INTO nhwBl_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeos, zemareos huan hamateos. Teipa nochi ni masehualme catli eliyayaj iteipan ixhuihua Canaán momoyajque campa hueli. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Inintlal elqui tlen tlali Sidón hasta nopa piltlaltzi catli itoca Gaza catli eltoya ipan ojtli para Gerar. Huan neca campa hualquisa tonati inintlal yajqui hasta altepetl Lasa ipan ojtli para nopa altepeme Sodoma, Gomorra, Adma huan Zeboim. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nochi ya ni elque iteipan ixhuihua Cam. Huan nica ijcuilijtoc inintoca ininfamilias, huan inincamanal catli sesen camanaltiyayaj. Huan ijcuilijtoc iniestados huan inintlal ipan catli sese itztoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Huan Sem elqui ininhueyi tata Heber huan iconehua. Sem elqui catli achtihui tlacatqui tlen inana huan teipa tlacatqui iicni Jafet. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Huan Sem quinpixqui itelpocahua catli inintoca eliyayaj: Elam, Asur, Arfaxad, Lud huan Aram. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Itelpocahua Aram elque: Uz, Hul, Geter huan Mas. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Huan Arfaxad elqui itata Sala, huan Sala elqui itata Heber. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Teipa Heber quinpixqui ome itelpocahua: Se motocaxtiyaya Peleg. (Peleg quinequi quiijtos “motlajcoitac”.) Quej nopa itoca pampa ipan nopa tonali tlaltipactli motlajcoitac. Huan iicni Peleg motocaxtiyaya Joctán. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Huan Joctán elqui itata: Almodad, Selef, Hazar Mavet, Jera, ");
INSERT INTO nhwBl_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO nhwBl_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO nhwBl_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila huan Jobab. Nochi ya ni itztoyaj iconehua Joctán. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Huan iteipan ixhuihua Joctán itztoyaj ipan nopa tlali tlatlajco Mesa huan nopa tepeme campa hualquisa tonati imelac Sefar. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Nochi ya ni elque iteipan ixhuihua Sem ica sese ininhuejhueyi familias, huan sese inincamanal, huan sese ininpiltlal huan nochi nopa tlalme ica sese inintlanahuatijca campa mocahuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Huajca ni catli nimitzpohuilijtoc eltoya inintoca itlayacanca teipan ixhuihua Noé. Huan sese inijuanti mochijqui se hueyi familia ica iniixhuihua teipa ehuani. Nojquiya nica quiijtohua nopa tlalme campa mocajque. Huan quema panotoya nopa miyac atl, nochi xinachtli tlen masehualme quisque tlen iixhuihua Noé huan campa hueli momoyajque ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ipan nopa tonali nochi masehualme catli itztoyaj ipan tlaltipactli quipixque san se inincamanal huan camanaltiyayaj san se. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Huan quema masehualme pejque momoyahuaj, miyac yajque para campa hualquisa tonati. Nepa quipantijque se tlamayamitl ipan tlali Sinar huan nopona nelía miyac masehualme mocajque huan ayacmo quinejque momoyahuase. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","4","Huan se tonal inijuanti moilhuijque se ica seyoc: “Xihualaca ma tijchihuaca se hueyi altepetl huan se torre catli ajsis hasta ilhuicac. Huan quej ni nochi techiximatise huan amo monequis timoxelose huan tiyase campa hueli ipan tlaltipactli. Ma tijchihuaca ladrillos huan ma tiquicxitica cuali ipan tlitl.” Huan quitequihuijque soquitl ladrillos huan amo tetl huan quitequihuijque chapopojtli para quitlatzquiltise huan amo soquitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Pero TOTECO temoc huan quiitaco nopa altepetl huan nopa torre catli nopa masehualme quisencahuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Huan yaya moilhui: “Nopa masehualme itztoque san sejco huan san se inincamanal. Yeca ni tlamantli catli ama quichihuaj san ipejya catli san sejco hueli quichihuase. Teipa huelis quisencahuase san catli inijuanti quinequise. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Achi más cuali titemose para tiquinpatilise inincamanal para ayacmo ma quimachilica catli mocamanalhuise.” ");
INSERT INTO nhwBl_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Huajca quej nopa TOTECO quichijqui huan yeca quiquetzqui inintequi huan ayacmo quichijque nopa altepetl. Quej nopa TOTECO quinsemanqui nopa masehualme campa hueli ipan tlaltipactli para ma momoyahuaca quen ya quinequiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Huan nopa lugar itoca elqui Babel. (Babel quinequi quiijtos “campa amo huelque momachilíaj se ica seyoc”.) Quej nopa itoca pampa nopona TOTECO quipatlac inincamanal nochi masehualme catli itztoyaj ipan ni tlaltipactli para ayacmo huelque momachilíaj. Huan tlen nopona TOTECO quinsemanqui campa hueli ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ya ni eltoc inintoca iteipan ixhuihua Sem. Tlanqui nopa miyac atl huan ome xihuitl teipa quema Sem quipiyayaya 100 xihuitl, tlacatqui ioquichpil Arfaxad. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Teipa Sem noja itztoya seyoc 500 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Huan quema Arfaxad quipixqui 35 xihuitl, tlacatqui ioquichpil Sala. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Teipa Arfaxad noja itztoya seyoc 403 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sala quipiyayaya 30 xihuitl quema tlacatqui ioquichpil Heber. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Huan teipa Sala noja itztoya seyoc 403 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heber quipiyayaya 34 xihuitl quema tlacatqui ioquichpil catli itoca Peleg. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Teipa Heber noja itztoya seyoc 430 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Huan quema Peleg quipixqui 30 xihuitl, tlacatqui ioquichpil Reu. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Huan teipa Peleg noja itztoya seyoc 209 xihuitl huan noja quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu quipiyayaya 32 xihuitl quema tlacatqui ioquichpil Serug. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Teipa Reu noja itztoya seyoc 206 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Huan quema Serug quipixqui 30 xihuitl, tlacatqui ioquichpil Nacor. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Huan teipa Serug noja itztoya seyoc 200 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nacor quipiyayaya 29 xihuitl quema tlacatqui ioquichpil Taré. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Teipa Nacor noja itztoya seyoc 119 xihuitl huan quinpixqui más iconehua, tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Huan Taré ya quipixtoya 70 xihuitl quema tlacatque ioquichpilhua Abram, Nacor huan Harán. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ama ya ni inintoca iteipan ixhuihua Taré. Taré elqui itata Abram, Nacor huan Harán. Huan teipa Harán elqui itata Lot. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Huan Harán nojquiya quinpixqui ome iichpocahua. Se itoca Isca huan ne se itoca Milca. Pero Harán mijqui quema ayamo miquiyaya itata huan quema nochi inijuanti noja mocahuayayaj para itztose nopona campa tlacatque ipan nopa altepetl itoca Ur ipan nopa tlali campa itztoyaj nopa caldeos. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Huan Abram mosihuajti ihuaya Sarai. Huan Nacor mosihuajti ihuaya imachcone, Milca, catli elqui iichpoca Harán. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Huan Sarai amo hueliyaya quinpiya coneme pampa eliyaya se tetzacatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taré itztoya ipan altepetl Ur ipan nopa tlali campa itztoyaj nopa caldeos huan quisqui para yasquía tlali Canaán. Huan Taré quinhuicac itelpoca, Abram, huan iyex, Sarai, huan iixhui, Lot, catli eliyaya itelpoca nopa mijcatzi Harán. Pero quema inijuanti ajsitoj ipan altepetl Harán, mocajque nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Huan nopona mijqui Taré quema quipiyayaya 205 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","TOTECO ya quiilhuijtoya Abram: “Xijcajtehua motlal, huan moteiximatcahua huan ichaj motata. Huan xiya hasta se tlali catli nimitznextilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Huan nimitzmacas miyac moixhuihua, huan niquinmiyaquilis moteipan ixhuihua hasta elise tlahuel miyaqui masehualme ipan inintlal. Nimitztiochihuas huan nijchihuas para campa hueli nochi ma mitziximatise. Huan tielis se tlatiochihualistli para sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Niquintiochihuas inijuanti catli mitztiochihuase. Huan inijuanti catli mitztelchihuase, niquintelchihuas. Huan niquintiochihuas nochi masehualme ipan tlaltipactli por ta.” ");
INSERT INTO nhwBl_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Huajca Abram quisqui quen TOTECO quinahuatijtoya huan quipiyayaya 75 xihuitl quema quisqui altepetl Harán para yas tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Huan quihuicac isihua Sarai huan imachcone Lot. Nojquiya Abram quihuicac nochi nopa miyac tlamantli huan tlapiyalme catli quinpiyayaya huan nochi itequipanojcahua catli hualajtoyaj ihuaya tlen altepetl Harán pampa quincojtoya para iaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Huan quema inijuanti ajsitoj tlali Canaán, Abram quipanoc nopa tlali hasta ajsitoj campa eltoc nopa hueyi ahua cuahuitl catli itoca More nechca altepetl Siquem. Ipan nopa tonali itztoyaj cananeos ipan nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Huan nopona TOTECO monexti ica Abram huan quiilhui: “Ni tlali niquinmacas moteipan ixhuihua.” Huajca Abram quichijqui se tlaixpamitl nopona para TOTECO catli monextijtoya ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Teipa yajqui itztoti campa tepeco tlatlajco altepetl Betel huan campa hualquisa tonati huan nopona quiquetzqui ichaj tlen yoyomitl. Altepetl Betel mocahuayaya ica iopochco para campa temo tonati. Huan altepetl Hai mocajqui ica inejmac para campa hualquisa tonati. Huan nopona Abram quichijqui seyoc tlaixpamitl huan quihueyichijqui TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Teipa sempa pejqui nejnemi hasta nopa tlali catli itoca Neguev. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ipan nopa tonali amo oncayaya tlacualistli ipan nopa tlali pampa amo tlaquiyajtoya. Huajca Abram yajqui para itztoti ipan tlali Egipto para se ome xihuitl, pampa nelía amo tleno oncayaya para quicuase campa itztoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Huan quema ajsitiyohuiyayaj Egipto, Abram quiilhui isihua Sarai: “Xiquita, cuali nijmati para nelía tiyejyectzi, ");
INSERT INTO nhwBl_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","huan quema nopa egiptome mitzitase, quiijtose: ‘Ni sihuatl, ya isihua ni tlacatl. Huajca ma tijmictica huan nopa sihuatl elis toaxca.’ ");
INSERT INTO nhwBl_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Yeca para ma amo tleno nopantis, xiquijtos para tinoicni. Quej nopa techselise ica yejyectzi por ta, huan amo nimiquis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Huajca quej nopa mocajque huan quema ajsitoj tlali Egipto, nopa egiptome quiitaque para Sarai eliyaya nelyejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Huan nojquiya quiitaque nopa huejhueyi tlacame catli itztoyaj ichaj nopa hueyi Tlanahuatijquetl Faraón huan quiilhuitoj nopa tlanahuatijquetl para nopa sihuatl eliyaya nelyejyectzi. Huajca Faraón quinnahuati ma quihuicaca ichaj para quicualtlalis para teipa elis isihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Huan pampa quiixtocac Sarai, Faraón quiseli Abram ica cuali. Huan Faraón quimacac Abram borregojme, huacaxme, burrojme, camellos huan tlatequipanohuani tlen tlacame huan sihuame para ma elise iaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Pero TOTECO quitlatzacuilti nopa Faraón ininhuaya nochi catli itztoyaj ipan ichaj ica cocolistli catli más fiero pampa Sarai itztoya ipan ichaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yeca nopa Faraón quinotzqui Abram iixtla huan quiajhuac. Quiilhui: “¿Para tlen techchihuilijtoc ni tlamantli? ¿Quenque amo techilhui para ni sihuatl eliyaya mosihua? ");
INSERT INTO nhwBl_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ta tiquijto para ya moicni huan yeca nimocuili para nosihua. Xiquita, nica itztoc. ¡Xijhuica huan ya xiya!” ");
INSERT INTO nhwBl_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Huajca nopa Faraón quinnahuati imasehualhua ma quicahuilica Abram ma quisa ipan nopa tlali ihuaya isihua huan ica nochi catli quipixtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Huajca Abram quisqui tlali Egipto ihuaya isihua, huan ihuaya Lot huan ica nochi catli quipixtoyaj. Huan nejnenque para norte huan sempa calajque ipan nopa tlali Canaán ipan nopa tlahuel huactoc tlali catli itoca Neguev. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Huan Abram nelía moricojchijtoya. Quipiyayaya miyac oro, plata huan tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Quema quisque Neguev, yajque ica yolic huan ajsitoj campa nopa pilaltepetzi Betel. Huan teipa ajsitoj campa mocajtoyaj achtihui, tlatlajco Betel huan Hai. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nopona eliyaya campa quichijtoya se tlaixpamitl. Huan nopona sempa quihueyichijqui TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Huan Lot catli nemiyaya ihuaya Abram nojquiya moricojchijtoya. Quipixqui san se imiyaca tlapiyalme quen itío Abram. Quinpixqui miyac borregojme, chivojme, huacaxme huan miyaqui tequipanohuani catli itztoyaj ipan miyac calme tlen yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Huan nopa tlali campa mocahuayayaj Abram huan Lot amo quinaxiliyaya para quintlamacase nochi inintlapiyalhua. Huan yeca ayacmo hueliyaya itztoque san sejco pampa nelmiyaqui itztoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Huan itequipanojcahua Abram catli quinmocuitlahuiyayaj itlapiyalhua mohuilanayayaj ininhuaya catli quinmocuitlahuiyayaj Lot itlapiyalhua. Huan ipan nopa tonali nojquiya itztoyaj cananeos huan ferezeos campa inijuanti huan eliyayaj mahuililme. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Huajca se tonal Abram quiilhui Lot: “Tojuanti tiicnime. Amo cuali para ma monajnanquilica motequipanojcahua ihuaya notequipanojcahua huan pehuas timocualanise tiome. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ma timoxeloca. Xiquita, nopona eltoc nochi ni tlali para tijtlapejpenis campa tijnequis. Sintla tijnequi tiyas nepa ica tonejmac, huajca na niyas ica toopochco. Huan sintla tiyas ica toopochco, huajca na niyas ica tonejmac.” ");
INSERT INTO nhwBl_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Huan Lot quitlajtlachili nochi nopa yejyectzi tlali tlen nopa hueyatl Jordán hasta nopa pilaltepetzi Zoar. Quiitac para quipiyayaya miyac atl huan eliyaya quen se xochimili. Nesiyaya tlahuel yejyectzi quen nopa tlali Egipto. Ya ni panoc quema TOTECO ayamo quitlamiltiyaya nopa altepeme Sodoma huan Gomorra. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Huajca Lot quitlapejpeni nochi nopa tlamayamitl nechca hueyatl Jordán huan yajqui para campa hualquisa tonati. Quej ni moxelojque Abram huan Lot. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Huajca Abram mocajqui ipan tlali Canaán huan Lot yajqui itztoti ipan nopa altepeme campa tlamaya. Huan Lot yolic quiijcuinijtiyajqui ichaj tlen yoyomitl hasta ajsito campa nopa altepetl Sodoma ");
INSERT INTO nhwBl_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","campa masehualme quipixque ininnemilis tlahuel fiero. Tlahuel tlajtlacolchihuayayaj iixpa TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Teipa quema Lot ya quistoya, TOTECO quiilhui Abram: “Abram, xitlachiya huejca ica norte huan ica sur, huan ica campa hualquisa tonati huan ica campa ontemo. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nochi ni tlali catli hueli tiquita, na nimitzmacas. Huan para nochipa elis moaxca huan iniaxca moteipan ixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Nijchihuas ma elica tlahuel miyaqui moteipan ixhuihua quen imiyaca tlaltejpoctli. Huan sintla se huelisquía quipohuasquía tlaltejpoctli, nojquiya huelis quinpohuasquía nochi moteipan ixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Huajca ximoquetza, xinejnemi huan xijtlachiliti ihuehueyaca huan ipatlajca, pampa na nimitzmacas.” ");
INSERT INTO nhwBl_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Huajca Abram quitlananqui ichaj tlen yoyomitl huan quiquetzqui hasta campa oncayaya miyac ahua cuame catli eltoya iaxca se tlacatl catli itoca Mamre nechca altepetl Hebrón. Huan nopona Abram quichijqui se tlaixpamitl para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","4","Para 12 xihuitl nopa Tlanahuatijquetl Quedorlaomer tlen tlali Elam quinfuerzajhuiyaya macuilti tlanahuatiani huan ininmasehualhua ma quitequipanoca, pero ipan nopa 13 xihuitl, nopa macuilti tlanahuatiani quinyolaxitijque huan mosisinijque. Huajca mosentilijque ipan nopa tlamayamitl Sidim nopa macuilti tlanahuatiani catli inintoca Tlanahuatijquetl Bera tlen altepetl Sodoma, Tlanahuatijquetl Birsa tlen altepetl Gomorra, Tlanahuatijquetl Sinab tlen altepetl Adma, Tlanahuatijquetl Semeber tlen altepetl Zeboim huan seyoc catli elqui tlanahuatijquetl tlen altepetl Bela catli nojquiya itoca Zoar. Sidim campa mosentilijque mocahua tlatlajco tepeme nechca campa eltoc nopa Hueyi Atl Catli Mictoc. Mosentilijque para momanahuise tlen Quedorlaomer para ayacmo monequi quitequipanose. Huan seyoc eyi tlanahuatiani mosentilijque ihuaya Quedorlaomer para quipalehuise tlahuilanas. Ni eyi elque Tlanahuatijquetl Amrafel tlen altepetl Sinar, Tlanahuatijquetl Arioc tlen altepetl Elasar huan Tlanahuatijquetl Tidal tlen altepetl Goim. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Huajca ipan nopa 14 xihuitl, Quedorlaomer huan eyi tlanahuatiani catli quipalehuiyayaj quisque huan nimantzi quintlanque nopa refaitame ipan tlali Astarot Karnaim, huan nopa zuzitame ipan tlali Ham huan nopa emitame ipan Save Quiriataim. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Huan quintojtocatiyajque nopa horeos campa nopa cuatitlamitl Seir hasta nopa tlamaya ipan tlali Parán catli eltoc nechca nopa huactoc tlali campa amo tleno eli. Nochi ni masehualme nopa Quedorlaomer quintlanqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Huan quema mocuepayayaj Quedorlaomer huan catli ihuaya itztoyaj, ajsitoj ipan tlali En Mispat catli nojquiya itoca Cades. Huan quintlanque nochi nopa amalecitame huan amorreos catli itztoyaj ipan nopa altepetl Hazezon Tamar. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Huajca nopa macuilti tlanahuatiani tlen altepeme Sodoma, Gomorra, Adma, Zeboim huan Bela o Zoar yajque ipan nopa tlamayamitl itoca Sidim huan mocualtlalijque para mohuilanase ininhuaya nopa nahui tlanahuatiani catli eliyaya Tlanahuatijquetl Quedorlaomer tlen tlali Elam, huan ihuampoyohua catli inintoca: Tlanahuatijquetl Tidal tlen altepetl Goim, Tlanahuatijquetl Amrafel tlen altepetl Sinar huan Tlanahuatijquetl Arioc tlen altepetl Elasar. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Pero nopa macuilti amo huelque tlatlanij. Huan ipan tlamayamitl Sidim oncayaya miyac ostotl ica chapopojtli. Huajca quema nopa tlanahuatiani tlen Sodoma huan Gomorra huan ininhuampoyohua quinequiyayaj cholose ipan nopa tlahuilancayotl, sequin inijuanti huetzque ipan nopa ostotl huan sequinoc cholojque campa tepeme. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Huajca tlatlanqui Quedorlaomer huan ihuampoyohua. Huan quicuique nochi tlacualistli huan tlamantli catli ipati catli oncayaya ipan altepeme Sodoma huan Gomorra huan quistejque. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Huan pampa Lot, imachcone Abram, itztoya ipan altepetl Sodoma, nojquiya quihuicaque ilpitoc ica nochi catli quipixtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Pero cholo se tlacatl huan quipohuilico Abram, nopa hebreo tlacatl quema mocahuayaya ipan iahuatitla se amorreo tlacatl catli itoca Mamre. Mamre eliyaya iicni Escol huan Aner catli nojquiya quimapalehuiyayaj Abram. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Huajca quema Abram quimatqui para imachcone Lot quihuicatoyaj ilpitoc, quinsentili 318 itequipanojcahua catli tlacajtoyaj ipan ichaj, huan momachtijtoyaj tlahuilanase huan yajque para quipantitij Quedorlaomer huan quimanahuise Lot. Huan quintepotztocaque hasta nopa pilaltepetzi catli itoca Dan. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Huan ica tlayohua Abram quinpanti huan quintlajcoitac itequipanojcahua huan quinyahualojque huan pejque quinhuilanaj quema amo quinchiyayayaj. Huan quinhuilantiyajque hasta altepetl Hoba catli mocahua ica norte tlen altepetl Damasco. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Huan Abram quintlanqui, huan quimanahui imachcone, Lot, huan nopa sequinoc tlacame huan sihuame catli quinhuicatoyaj. Huan quincuili nochi catli quiichtectoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Huan quema Abram ya quitlantoya Quedorlaomer huan catli quipalehuiyayaj, mocuepqui ipan ojtli para ichaj. Huan ipan nopa tlamayamitl tlatlajco tepeme campa itoca Save o Inintlamaya Tlanahuatiani, hualajqui quinamiquico nopa tlanahuatijquetl tlen altepetl Sodoma. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Huan nojquiya hualajqui quinamiquico Melquisedec, nopa tlanahuatijquetl tlen altepetl Salem 14:18 Salem teipa motocaxtis Jerusalén.. Yaya nojquiya eliyaya Itotajtzi Toteco Catli Más Hueyi. Huan Melquisedec quinmacac Abram huan itequipanojcahua pantzi huan xocomeca atl. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Huan quitiochijqui Abram ica ni camanali: “Abram, ma mitztiochihua Toteco Catli Más Hueyi, yaya catli quichijqui ilhuicactli huan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Quena, ma tijhueyichihuaca Toteco Catli Más Hueyi, pampa quichijqui xiquintlani mocualancaitacahua.” Huajca Abram quimacac Melquisedec se diezmo tlen nochi catli quitlantoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Teipa nopa tlanahuatijquetl tlen Sodoma quiilhui Abram: ―San techmactili nopa masehualme catli ehuaj noaltepe catli tiquinmanahuijtoc huan ximocahui nochi tlamantzitzi catli eliyaya iniaxca. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Pero Abram quinanquili: ―Niquilhuijtoc TOTECO catli quichijqui ilhuicactli huan tlaltipactli, ");
INSERT INTO nhwBl_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","para amo tleno nijselis catli eltoya amoaxca. Amo nijcuis niyon se icpatl, niyon se lazo catli ica nimotecac ilpis para amo quema huelis tiquijtos ta techricojchijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Amo tleno nijnequi para na. San tijselise catli quicuajque notequipanojcahua. Pero nopa tlacame catli yajque nohuaya, Aner, Escol huan Mamre, xiquincahuili ma quicuica catli quintocarohua. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Teipa TOTECO quinotzqui Abram ipan se tlanextili catli elqui quen se temictli huan quiilhui: “Amo ximajmahui, Abram, pampa na nimitzmocuitlahuis. Motlaxtlahuil elis nelhueyi.” ");
INSERT INTO nhwBl_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Pero Abram quinanquili: ―TOTECO, Ta Catli Más Tijpiya Tlanahuatili, san tlapic para techmacas miyac tlamantli pampa amo nijpiya se conetl para nijcahuilijtehuas. Amo techmacatoc niyon se nocone. Huan notequipanojca Eliezer catli ehua altepetl Damasco quiselis nochi catli nijpiya quema nimiquis. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Huan TOTECO quinanquili: ―Amo yaya quiselis catli tijcajtehuas. Elis se mocone catli quiselis catli tijpiyas teipa huan quipiyas ta moeso. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Huajca TOTECO quihuicac Abram calteno huan quiilhui: ―Xijtlachili ilhuicac huan xijchihua fuerza xiquinpohua nopa sitlalime. Quej nopa elis ininmiyaca moteipan ixhuihua. Itztose tlahuel miyaqui hasta amo aqui huelis quinpohuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Huajca Abram quineltocac catli TOTECO quiijto huan TOTECO quiijcuilo nepa ilhuicac para Abram itztoya xitlahuac iixpa. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Huan TOTECO quiilhui: ―Na nimoTECO. Nimitzhualicac tlen altepetl Ur campa itztoque nopa caldeos para nimitzmacas ni tlali para timoaxcatis. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Pero Abram quiilhui: ―TOTECO, ta catli más tijpiya tlanahuatili, ¿quenicatza huelis nijmatis sintla melahuac nijselis ni tlali? ");
INSERT INTO nhwBl_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Huan Toteco Dios quinanquili: ―Techhualiquili se becerra, se chivo huan se oquich borrego catli quipiyaj eyi xihuitl. Nojquiya techhualiquili se pichontzi huan se paloma. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Huajca Abram quihualiquili Toteco Dios nochi ni tlapiyalme. Quinmicti, huan quintlajtlajcoitac huan quinijixnamicti, pero nopa totome amo quintlajcoitac. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Huan tzopilome temoyayaj ipan nopa tlapiyalme catli mictoyaj, pero Abram quinmajmatiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Huan quema ya tlatlayohuatoya, Abram nelcochqui huan quimatqui para hualajqui ipan ya se tzintlayohuilotl huan tlahuel majmahuiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Huajca TOTECO quiilhui: ―Moteipan ixhuihua yase itztotij ipan seyoc tlali quen seyoc tlali ehuani. Huan masehualme catli nopona ehuaj quintequihuise chicahuac huan quinitase quen iniaxcahua huan nopona moteipan ixhuihua tlaijiyohuise para 400 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Pero teipa na nijtlatzacuiltis nopa tlali huan imasehualhua catli quintequihuise. Huan moteipan ixhuihua quisase ica miyac tlamantli catli tlahuel ipati. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Pero ta timiquis quema ya tihuehuejtitos, quema noja oncas tlasehuilistli. Mitztlalpachose quema ayamo ajsitos nopa tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Nopona ipan nopa tlali mocahuase hasta miquise moteipan ixhuihua catli achtihui calajque ipan nopa tlali. Mocahuase hasta miquise ininconehua, huan iniixhuihua huan ininconehua iniixhuihua. Huan huajca quena, nopa masehualme huan ininconehua mocuepase sempa nica ipan ni tlali. Pero para amantzi ayamo ajsi tonali para hualase pampa ayamo tlahuel fiero quichihuaj nopa amorreos catli ama itztoque nica ipan ni tlali. Huajca ayamo ajsi nopa tonali para niquintlatzacuiltis quen nijchihuas teipa ipan nopa tonali quema mocuepase moteipan ixhuihua nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Huan quema ya temotoya tonati huan nochi ya tzintlayohuatoya, nesqui quen se comitl catli quipixtoya tlilelemectli huan popocayaya. Huan nopa comitl panoc tlatlajco campa nopa tlapiyalme catli Abram quintejtectoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Huan quej nopa ipan nopa tonal, TOTECO quicajqui icamanal ihuaya Abram huan quiilhui: ―Nochi ni tlali niquinmacas moteipan ixhuihua. Quiselise nochi ni tlali tlen campa pehua ica nopa hueyi hueyatl ipan tlali Egipto ica campa temo tonati huan noja quiselise hasta nopa hueyi hueyatl catli itoca Eufrates campa hualquisa tonati. ");
INSERT INTO nhwBl_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nochi ni tlali elis iniaxca campa ama mocahuaj masehualme ceneos, cenezeos, cadmoneos, ");
INSERT INTO nhwBl_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","heteos, ferezeos, refaitame, ");
INSERT INTO nhwBl_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreos, cananeos, gergeseos huan jebuseos. Nochi elis iniaxca moteipan ixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai, isihua Abram, amo huelqui conepiya, pero quipiyayaya se itequipanojca tlen tlali Egipto catli itoca Agar. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Huajca Sarai moilhui quichihuas quen momajtoyaj quichihuaj ipan nopa tonali huan quimactilis ihuehue itequipanojca. Yeca quiilhui Abram: ―Xiquita, TOTECO amo nechcahuilijtoc ma niconepiyas, huajca xicochi ihuaya notequipanojca Agar para yaya huelis quinpiyas coneme catli elise quen na noconehua. Huan Abram quichihuili cuenta catli Sarai quiilhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Huan Sarai quinotzqui Agar, nopa egipto ejquetl, huan quimactili Abram para ihuaya ma cochi. Quema panoc ya ni, Abram ya quipixqui majtlactli xihuitl para itztos ipan tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Huan Abram quiiximatqui Agar, huan Agar conecuic. Huan quema Agar momacac cuenta para ya conepiya, mohueyimatqui huan pejqui quicualancaita Sarai. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Huajca Sarai quiilhui Abram: ―Ta motlajtlacol para nechcualancaita Agar. Na nimitzmactili para ihuaya ximoteca, pero quema quimatqui para conepiyas, mohueyimatqui. Ma TOTECO quiijto ajqueya quipiya tlajtlacoli, sintla ta o na. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Huan Abram quinanquili: ―Xiquita, Sarai, motequipanojca Agar itztoc momaco para tijtlatzacuiltis quen tiquitas cuali. Huajca Sarai pejqui quitlaijiyohuiltía Agar, huan yeca Agar cholojtejqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Pero se itequihua TOTECO quipanti Agar campa meyayaya atl ipan nopa huactoc tlali campa amo tleno eli. Itztoya ipan nopa ojtli catli yohui para Shur. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Huan itequihua TOTECO quitlatzintoquili: ―Agar, tiitequipanojca Sarai, ¿canque tihuala huan canque tiya? Huan Agar quinanquili: ―Nicholohua imaco noteco, Sarai. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Huajca itequihua TOTECO quiilhui: ―Ximocuepa campa moteco huan xijneltoquili nochi catli mitznahuatis. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Huan nojquiya itequihua TOTECO quiilhui: “Na niquinmiyaquilis moteipan ixhuihua hasta amo aqui huelis quinpohuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ya ticonecuitoc huan tijpiyas se oquichpil huan tijtocaxtis Ismael, pampa TOTECO quicajqui quema timotequipachohuayaya. (Ismael quinequi quiijtos ‘TOTECO tlacaqui’.) ");
INSERT INTO nhwBl_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Huan mocone elis se tlacatl catli mosisinía. Mohuilanas ininhuaya nochi, huan nochi quinequise quihuilanase. Huan yaya itztos ica cualantli mojmostla ica nochi iicnihua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Huan Agar quitocaxtlali TOTECO catli ihuaya mocamanalhuijtoya “yaya Toteco Dios Catli Nochi Quiita”. Quej nopa quitocaxti pampa moilhuiyaya: “Niquitztoc Toteco Dios catli nechita huan noja niitztoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Huan yeca nopa ameli catli mocahua tlatlajco Cades huan Bered ama quitocaxtijtoque Beer Lahai Roi. (Beer Lahai Roi quinequi quiijtos “Iamel Yaya Catli Itztoc Huan Catli Nechita”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Huan Agar quitlacatilti icone Abram, huan Abram quitocaxti Ismael. ");
INSERT INTO nhwBl_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Huan Abram quipiyayaya 86 xihuitl quema tlacatqui Ismael. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Huan quema Abram quipiyayaya 99 xihuitl, Toteco Catli Quipiya Nochi Chicahualistli monexti campa ya huan quiilhui: ―Na nimoTeco Catli Nijpiya Nochi Chicahualistli. Ximotemachi ipan na huan xijchihua san catli xitlahuac noixtla. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Huan na nijcahuas nocamanal mohuaya para temachtli nijchihuas para tiquinpiyas tlahuel miyac moteipan ixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Huan Abram motlancuaquetzqui huan mohuijtzonqui hasta tlalchi quema Toteco Dios quicamanalhuiyaya. Huan Toteco Dios nojquiya quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","―Nijcahua nocamanal mohuaya para ta tielis tiinintata tlahuel miyac masehualme catli itztose ipan tlahuel miyac tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Huan motoca ayacmo elis Abram. (Abram quinequi quiijtos ‘se tetaj catli nochi quitlepanitaj’.) Ama motoca elis Abraham. (Abraham quinequi quiijtos ‘inintata miyac masehualme catli itztoque ipan miyac tlalme’.) Quej nopa elis motoca pampa nimitzchihuas tiinintata miyac masehualme ipan miyac tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Quena, nijchihuas para moteipan ixhuihua ma elica nelía miyaqui. Ipan ta quisase huejhueyi tlanahuatiani catli quinnahuatise ininmasehualhua ipan miyac tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Huan na nijtlamichihuas nochi catli nijcajtoc nocamanal para nijchihuas ica ta huan moteipan ixhuihua teipa para nochipa. Ni elis se camanali tlasencahuali catli amo quema tlamis. Nochipa nielis nimoDios huan niininDios moteipan ixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Huan nochi ni tlali catli itoca Canaán campa ama tiitztoc, nimitzmacas ta huan moteipan ixhuihua. Huan elis iniaxca para nochipa, huan na nielis niininDios. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Huan Toteco Dios sempa quiilhui Abraham: ―Huan ya ni catli ta huan nochi moteipan ixhuihua monequi xijchihuaca. Monequi xijneltocaca nochi catli quiijtohua ni camanali catli nijchihua mohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Huan ya ni nopa camanali catli monequi xijchihuaca. Monequi nochi oquichpilme huan tlacame ma motequilica quen nimitzilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ma quitzontequilica iyecapa nopa cuetlaxtli ipan ininpiltlacayohua. Ya nopa itoca circuncisión. Huan ya nopa elis nopa tlanextilijcayotl tlen ni camanal tlasencahuali catli nijchihua amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Huajca ama monequi ta huan nochi tlacame catli mitztequipanohuaj, masque tijcojqui nopa tlacatl para moaxca quema ya hueyi, o quitlacatili se motequipanojca, monequi nochi motequilise. Huan nojquiya monequi anquintequilise nochi amooquichpilhua catli tlacajtiyase teipa. Xijchihuaca quema quipiyas chicueyi tonati ica tlacajtoc. Quej nopa monequis ica moteipan ixhuihua, huan ininteipan ixhuihua motequipanojcahua huan ica nochi tequipanohuani catli tiquincohuas tlen sequinoc tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nochi tlacame huan oquichpilme monequi motequilise. Huan quej nopa elis quen anquihuicase se tlanextilijcayotl tlen nocamanal ipan amonacayo huan nopa camanali catli nijchihua amohuaya huejcahuas para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Huan catli amo motequilis monequi xijquixtica para ayacmo quema itztos ininhuaya momasehualhua pampa amo quitlepanitac nopa camanali catli nijchijtoc ica amojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nojquiya Toteco Dios quiilhui Abraham: ―Huan mosihua, ayacmo elis itoca Sarai. Ama itoca elis Sara. (Sara quinequi quiijtos ‘iichpoca se tlanahuatijquetl’.) ");
INSERT INTO nhwBl_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Huan Sara nijtiochihuas huan temachtli nimitzmacas se mocone ipan ya. Huan yaya elis ininnana miyac masehualme ipan miyac tlalme, huan miyac iteipan ixhuihua elise huejhueyi tlanahuatiani. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Huan Abraham motlancuaquetzqui huan mohuijtzonqui tlalchi para quihueyichihuas Toteco Dios, pero yolhuetzcayaya pampa amo quineltocayaya. San moilhuiyaya: “¿Quenicatza huelis nijpiyas se conetl quema ya nijpiya 100 xihuitl? Huan ¿quenicatza huelis Sara conepiyas quema ya quiaxiti 90 xihuitl?” ");
INSERT INTO nhwBl_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Huajca Abraham quiilhui Toteco Dios: ―Sintla huelis, san xijcahua nooquichpil Ismael ma itztos ica motlatiochihualis. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Huan Toteco Dios quinanquili: ―¡Amo! Amo ya nopa catli nimitzilhuía. Niquijto mosihua Sara quipiyas se icone catli tijtocaxtis Isaac. Huan ihuaya ya nicompahuis nopa camanali huan ininhuaya iteipan ixhuihua para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Pero nojquiya nijcactoc catli techtlajtlanijtoc para Ismael huan quena, nijtiochihuas. Nijchihuas ma quinpiya miyac iconehua huan para ma momiyaquilica iixhuihua. Huan yaya elis inintata 12 huejhueyi tlacame. Ica ya huan iteipan ixhuihua niquinchihuas ma elica se xinach masehualme ica miyac imasehualhua huan quipiyase se hueyi tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Pero nopa camanal tlasencahuali nijchihuas ica Isaac, nopa conetl catli Sara quitlacatiltis ne se xihuitl, quen ama. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Huan quema Toteco Dios tlanqui camanalti ihuaya Abraham, quistejqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Huan nimantzi ipan nopa tonal Abraham quitzontequili iyecapa nopa cuetlaxtli ipan ipiltlacayo Ismael. Huan nojquiya quintzontequili inincuetlaxo nochi itequipanojcahua catli tlacajtoyaj ipan ichaj huan nochi tlacame catli quincojtoya. Quena, nochi tlacame catli itztoyaj ipan ichaj huan catli quitequipanohuayayaj motequilijque quen Toteco Dios tlanahuati. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Huan Abraham quipiyayaya 99 xihuitl, huan icone, Ismael, quipiyayaya 13 xihuitl quema quintzontequilijque inincuetlaxo. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Huajca ipan nopa tonal quema Toteco Dios quicamanalhui Abraham, Abraham huan icone, Ismael, motequilijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Huan nojquiya motequilijque nochi nopa itequipanojcahua, tlacame huan oquichpilme, catli itztoyaj ipan ichaj, masque tlacatque nopona o quincojtoya ipan sequinoc tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Huan TOTECO monexti campa Abraham quema itztoya ipan nopa ahuatitla campa nopa huejhueyi cuame catli iaxca Mamre. Quej ni panoc. Se tonal Abraham mosehuijtoya calteno nechca ichaj tlen yoyomitl ipan nopa hora quema más tlatotoniya. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Huan Abraham ajcotlachixqui huan quinitac eyi tlacame ajsitihualayayaj nechca ichaj. Huan quema quinitac, moquetzqui huan motlalo para quinnamiquis huan motlancuaquetzqui huan mohuijtzonqui hasta tlalchi, ");
INSERT INTO nhwBl_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","huan quiijto: ―Tatame, techchihuilica se favor, xipanoca techpaxaloca. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Huan sintla anquiitaj cuali, nitlajtlanis se quentzi atl para anmoicxipajpacase huan anmosiyajquetzase se quentzi itzintla ni cuahuitl campa tlaecahuía. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Nojquiya nimechhualiquilis se quentzi tlacualistli para xijpiyaca fuerza huan teipa sempa huelis anyase ipan amoojhui. Para na se paquilistli anhualajtoque huan nijnequi nimechtequipanos sintla antechcahuilise. Huan inijuanti quinanquilijque: ―Cualtitoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Huan Abraham calajqui ipan ichaj tlen yoyomitl huan quiilhui Sara: ―Nimantzi xijcui eyi tlatamachihuali tlen harina catli más cuali huan xijchihua pantzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Teipa Abraham motlalo campa itztoyaj itlapiyalhua huan quitlapejpeni se becerro catli nelía yejyectzi. Huan quimacac se itequipanojca, huan ya nimantzi quisencajqui se tlacualistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Huan teipa Abraham quinhualiquili mantequilla, lechi huan nopa becerro tlacacatzoli huan quinmacac ma quicuaca. Huan Abraham moquetzqui nechcatzi cuatzintla para quintequipanos quema inijuanti tlacuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Huan quema tlanque tlacuaj, nopa paxalohuani quitlatzintoquilijque Abraham: ―¿Canque itztoc mosihua Sara? Huan Abraham tlananquili: ―Itztoc nepa calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Huajca se tlen nopa tlacame quiijto: ―Ne se xihuitl quen ama sempa nimitzpaxaloqui, huan mosihua Sara ya quitlacatiltijtos icone. Huan Sara moquetztoya icalixpa, quintlacaquilijtoya catli camanaltiyayaj ihuaya Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Huan Abraham huan Sara eliyayaj huehuentzitzi, huan ya panotoya nopa xihuitl para Sara quipiyasquía se icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Huan yeca amo huelqui moijiyohui para amo huetzcas huan moilhui: “¿Quenicatza huelis nijpiyas ni paquilistli ama quema nohuehue huan na ya tihuehuentzitzi?” ");
INSERT INTO nhwBl_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pero TOTECO quiilhui Abraham: ―¿Para tlen huetzcac Sara? ¿Quenque quiijto: Quenicatza huelis nijpiyas ni paquilistli ama quema nohuehue huan na ya tihuehuentzitzi? ");
INSERT INTO nhwBl_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","¿Timoilhuía para onca se tlamantli catli na, nimoTeco Dios, amo hueli nijchihuas? Ne se xihuitl sempa nimechpaxaloqui huan Sara quipixtos icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Huan quema Sara quicajqui catli quiijto, majmajqui huan istlacatqui huan quiijto: ―Na amo nihuetzcac. Pero TOTECO quinanquili: ―Na nijmati para tihuetzcac. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Teipa nopa paxalohuani moquetzque huan pejque nejnentiyohuij ipan ojtli para altepetl Sodoma. Huan Abraham ininhuaya yajqui para quinnahuatijtehuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Huajca TOTECO moilhui: “Monequi niquilhuis Abraham catli nijchihuas, ");
INSERT INTO nhwBl_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","pampa yaya elis inintata miyaqui tlacame huan sihuame catli mochihuase se hueyi xinach masehualme catli quipiyase miyac chicahualistli. Huan niquilhuijtoc para niquintiochihuas nochi masehualme ipan nochi tlalme ipan tlaltipactli ica ya. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Na nijtlapejpenijtoc para ma quinnextilis iconehua ma quineltocaca notlamachtil huan ma quichihuaca nochi catli cuali huan catli xitlahuac. Huan na niquinchihuilis nochi catli cuali niquilhuijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Huajca TOTECO quiilhui Abraham: ―Nechyolmelajtoque para nopa masehualme ipan altepeme Sodoma huan Gomorra nelmosisiníaj. Nelfiero ininnemilis huan tlahuel miyac inintlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ama niya nepa para niquitas sintla nelía inintlajtlacol nelhueyi quen nechilhuijtoque. Huan quej nopa nijmatis. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Huan ne seyoc ome paxalohuani quisque para Sodoma, pero TOTECO mocajqui ihuaya Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Huan Abraham quinechcahui huan quitlatzintoquili: ―¿Tiquinpolos masehualme catli itztoque xitlahuaque ininhuaya catli tlajtlacolejque? ");
INSERT INTO nhwBl_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sintla itztoque 50 masehualme catli cuajcualme ipan nopa altepetl, ¿noja tijtlatzacuiltis nopa altepetl? ¿Amo tijtlapojpolhuis nopa altepetl por nopa 50 masehualme? ");
INSERT INTO nhwBl_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Amo cuali sintla tiquinmictis cuajcualme ininhuaya catli tlahuel tlajtlacolchijtoque pampa quej nopa nesi para nochi ome quipiyaj san se inintlajtlacol. ¡Amo xijchihua ya nopa! Ta, tijuez catli más tihueyi ipan nochi ni tlaltipactli, huan nijmati ta tijchihuas catli xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Huan TOTECO quinanquili: ―Sintla niquinpantis 50 masehualme catli itztoque xitlahuaque ipan nopa altepetl, huajca niquintlapojpolhuis nochi por nopa 50 masehualme catli itztoque xitlahuaque. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Pero Abraham sempa quiilhui: ―Techtlapojpolhui Toteco, sintla sempa nimitzcamanalhuía, pampa ta, tiToteco Dios, huan na san nise masehuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Pero nohueli polihuij macuili masehualme para ajsis 50 catli itztoque xitlahuaque. ¿Tiquinmictis nochi ipan nopa altepetl sintla san polihui nopa macuilme? Huan TOTECO quinanquili: ―Sintla niquinpantis 45 masehualme catli xitlahuaque, amo nijpolos nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Huan Abraham sempa quiilhui: ―Pero nohueli san itztoque 40 masehualme catli xitlahuaque. Huan TOTECO quiijto: ―Sintla itztoque 40 catli xitlahuaque, amo nijtlamiltis nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Pero Abraham sempa quiilhui: ―Nimitztlajtlanía amo xicualani nohuaya pampa nimitztlatzintoquilía miyac hueltas, pero nohueli tiquinpantis san 30 masehualme catli itztoque xitlahuaque. Huan Toteco sempa quiilhui: ―Sintla itztoque 30 masehualme catli itztoque xitlahuaque, amo nijpolos nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Huan Abraham noja quitlatzintoquili: ―Toteco, nijmati para nimitznelcuatotonía pampa nimitznojnotza quej ni, pero ¿tlaque panos sintla san 20 masehualme catli itztoque xitlahuaque tiquinpantis? Huan Toteco quiilhui: ―Sintla itztoque 20 catli xitlahuaque, amo niquinmictis catli itztoque ipan nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Huan Abraham sempa quitlatzintoquili: ―NoTeco, amo xicualani nohuaya, pero nimitztlatzintoquilis san ni huelta: ¿Tlaque tijchihuas sintla san majtlactli masehualme catli itztoque xitlahuaque tiquinpantis? Huan Toteco quiilhui: ―Sintla itztoque majtlactli masehualme catli xitlahuaque, amo nijsemanas nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Huan quema TOTECO tlanqui camanalti ihuaya Abraham, quistejqui. Huan Abraham mocuepqui ichaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Huan quema ya tlayohuayaya nopa ome itequihuajcahua TOTECO ajsitoj altepetl Sodoma. Huan Lot mosehuijtoya nechca ipuerta nopa altepetl campa tlayacanani momajtoyaj mosentilíaj. Huan quema Lot quinitac, moquetztiquisqui para quinnamiquiti huan quinseli ica yejyectzi. Huan motlancuaquetzqui huan mohuijtzonqui hasta tlalchi, ");
INSERT INTO nhwBl_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","huan quinilhui: ―Tatame, techchihuilica se favor, ximocahuaca ni tlayohua ipan nochaj. Nopona anmoicxipajpacase huan antonilise. Huan mostla cualca huelis sempa anyase ipan amoojhui. Pero quiijtojque: ―¡Amo! Tlascamati. Tojuanti san ticochise nica calteno ipan calle. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Pero Lot quinnelchihualti para ma cochica ichaj hasta quiijtojque para quena, huan yajque ichaj. Huan quema ajsitoj, Lot tlanahuati ma quinsencahuilica se cuali tlacualistli ica pantzi catli amo quipiya tlasonejcayotl. Huan nopa paxalohuani tlacuajque. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Huan teipa quema ayamo motecayayaj, nochi nopa tlacame tlen altepetl Sodoma quiyahualocoj ichaj Lot. Hualajque catli más telpocame hasta catli más huehuentzitzi, ");
INSERT INTO nhwBl_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","huan pejque quitzajtzilíaj Lot: ―¿Canque itztoque nopa tlacame catli hualajque mochaj ni tlayohua? ¡Xiquinquixti para timotecase ininhuaya! ");
INSERT INTO nhwBl_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Huajca Lot quisqui calteno para quincamanalhuis huan cuali quitzajqui nopa puerta iica 19:6 Ipan nopa tonali tlahuel monejqui se tlacatl quinmanahuis ipaxalojcahua sintla ya quinselijtoya ipan ichaj.. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Huajca Lot quinilhui nopa fiero tlacame: ―Amo, nohuampoyohua, nimechtlajtlanía amo xijchihuaca nopa tlamantli catli fiero. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Niquinpiya ome noichpocahua catli ayamo quiiximajtoque niyon se tlacatl, niquinquixtis huan nimechmacas para xijchihuaca ininhuaya catli anquinequij, pero amo tleno xiquinchihuilica ni tlacame pampa nopaxalojcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Pero quinanquilijque: ―¡Ximijcuini tiseyoc tlali ejquetl! ¿San tiajsico nica huan tijnequi technahuatis? ¡Ama timitzchihuilise más fiero que inijuanti! Huan nimantzi pejque quitemajmatíaj Lot huan monechcahuijque campa puerta para quitlahuisose. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Pero ipaxalojcahua quitlapojque cuapuerta huan nimantzi quiitzquijque Lot huan quicalaquijque calijtic. Teipa sempa quitzajque puerta. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Huan ipaxalojcahua quinchijque ma popoyotiyaca nopa tlacame catli itztoyaj calteno. Huan nochi hasta catli más telpocatl huan hasta catli más huehuentzi, mocajque popoyotzitzi. Huan cuatque quitemohuaj nopa puerta. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Huajca nopa paxalohuani quiilhuijque Lot: ―Sintla tiquinpiya más moteiximatcahua nica ipan ni altepetl, motlaca conehua, mosihua conehua, momonticahua o sequinoc moteiximatcahua, monequi xiquinquixti huan huejca xiquinhuica. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Pampa tijtlamiltise ni altepetl huan miquise nochi catli itztoque nica pampa tlahuel miyac tlajtlacoli quichijtoque. TOTECO quitlacaquilijtoc hasta ayacmo quiijiyohuía catli fiero quichihuaj nica ehuani. Huajca techtitlantoc para ma tijtlamiltica ica nochi catli nica itztoque. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Huajca Lot yajqui quinitato catli teipa elisquíaj imonticahua pampa ya quinijtlantoyaj iichpocahua huan quinilhui: ―¡Ximoisihuiltica, xiquisaca huan huejca xiyaca pampa TOTECO quitlamiltis ni altepetl! Pero imonticahua amo quineltocaque. Moilhuijque san ahuilcamanaltiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Huan quema ya tlanestihualayaya, itequihuajcahua TOTECO quiisihuiltijque Lot huan quiilhuijque: ―Nimantzi ximoisihuilti huan xiquinhuica mosihua huan ne ome moichpocahua huejca para amo anmiquise quema tijtlamiltise ni altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Huan Lot huejcahuayaya. Pero pampa TOTECO quitlasojtlac, itequihuajcahua TOTECO quimaitzquijque, huan quinitzquijque isihua huan iichpocahua huan quinquixtijque ipan nopa altepetl para quinmanahuise. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Huan quema nochi ifamilia Lot quistoyaj tlen nopa altepetl, nopa tequihuajme quinilhuijque: ―¡Ximotlaloca para amo anmiquise! Amo ximoicantlachilica, niyon amo ximoquetztiyaca campa tlamaya. Ximotlaloca hasta campa tepeco, sintla anquinequij anmomanahuise huan amo anmiquise. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Pero Lot quinilhui: ―¡Amo, tatame! ¡Nelía nimechtlajtlanía, techtlacaquilica se tlatoctzi! ");
INSERT INTO nhwBl_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nelía antechchihuilijtoque se hueyi favor huan anquimanahuijque nonemilis, pero na amo nihueli nicholos hasta campa tepeixco pampa huejca. Nopa tlatzacuiltili huelis techajsiti ipan ojtli, huan huajca, quena, timiquise. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Nechca nica onca se pilaltepetzi campa huelis ticholose. ¡Techcahuili tiyase nepa para timomanahuise pampa nelía se altepetl catli tziquitetzi! ");
INSERT INTO nhwBl_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Huajca se tlen inijuanti quiijto: ―Cualtitoc, nijchihuas catli titlajtlantoc. Amo nijtlamiltis nopa altepetl catli tiquijtohua. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Pero xiyaca, xicholojtehuaca nimantzi pampa amo tleno huelis nijchihuas hasta anajsitij nepa. Huan yeca Lot quitocaxti nopa pilaltepetzi Zoar. (Zoar quinequi quiijtos “tziquitetzi”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Huan quema ya tlanestoya cuali, Lot ya ajsitoya ipan pilaltepetzi Zoar. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Huan TOTECO quichijqui ma huetzi tlen ilhuicac ipan altepeme Sodoma huan Gomorra se tlamantli tlitl ica azufre catli tlahuel tlatla. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Huan nojquiya quintlamilti nochi sequinoc ranchos ipan nopa tlamayamitl ica nochi catli itztoyaj nopona huan ica nochi xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Pero isihua Lot catli hualayaya iica, ican tlachixqui huan itlacayo mocuepqui istatl huan mocajqui ijcatoc quen se teteyotl. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Huan hualmostla ica ijnaloc, Abraham yajqui campa mocamanalhuijtoya ihuaya TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Huan tlen nopona tlachixqui ipan altepeme Sodoma huan Gomorra huan ipan nochi nopa ranchos catli eltoya ipan nopa tlamayamitl. Huan quiitac para tlahuel tlejcoyaya poctli quen elisquía se horno. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Huajca quej nopa Toteco Dios quintlatzacuilti nopa altepeme campa Lot itztoya. Pero Toteco Dios quielnamijqui Abraham huan catli quitlajtlanijtoya huan quiijcuini Lot tlen nopa fiero tlatzacuiltilistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Teipa Lot majmajqui para mocahuas ipan pilaltepetzi Zoar huan yajqui tepeixco ihuaya iichpocahua huan nochi eyi inijuanti mocajque nepa ipan se tecacahuatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Huan se tonal nopa iichpoca catli achtihui ejquetl quiilhui nopa teipan ejquetl: ―Totata ya huehuentzi, huan amo aqui niyon se tlacatl ipan nochi ni lugar catli huelis timonamictise ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yeca ma tiquihuintica totata huan ma tiquiximatise para tiquinpiyase catli ya iconehua para amo polihuis itoca. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Huan ipan nopa tlayohua quimacaque inintata xocomeca atl catli nelcococ huan nopa achtihui ejquetl motejqui ihuaya. Pero itata amo momacac cuenta catli panoc, niyon quema motejqui, niyon quema mejqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Huan hualmostla nopa achtihui ejquetl quiilhui nopa teipan ejquetl: ―Xiquita, tlayohua nimotejqui ihuaya totata, huajca ni tlayohua nojquiya tiquihuintise para ta timotecas ihuaya. Huan quej nopa tiome tijpiyase catli ya iconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Huajca ipan nopa tlayohua sempa quimacaque inintata xocomeca atl huan nopa teipan ejquetl motejqui ihuaya. Pero Lot amo momacac cuenta sintla itztoya, niyon quema motejqui, niyon quema mejqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Quej nopa nochi ome iichpocahua conecuique tlen inintata. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Huan nopa achtihui ejquetl quipixqui se icone catli quitocaxti Moab. Quema moscalti Moab, elqui inintata nochi masehualme catli ama inintoca moabitame. ");
INSERT INTO nhwBl_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Huan nopa teipan ejquetl quipixqui icone catli quitocaxti Ben Ammi. Quema moscalti Ben Ammi yaya elqui inintata nochi masehualme catli ama inintoca amonitame. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Teipa Abraham quisqui ipan Mamre huan yajqui tlali Neguev huan mocajqui ipan altepetl Gerar catli mocahua tlajco Cades huan Shur. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Huan quema itztoya nopona, quiijtohuayaya para isihua Sara eliyaya iicni. Huajca Abimelec, nopa tlanahuatijquetl tlen Gerar, tlatitlanqui ma quicuitij Sara para teipa quichihuas isihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Pero se tlayohua Toteco Dios quinojnotzqui Abimelec ipan temictli huan quiilhui: “Abimelec, timiquis pampa nopa sihuatl catli tijcuitoc ya monamictijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Pero Abimelec ayamo quinechcahuijtoya nopa sihuatl huan quinanquili: “Toteco, ¿techmictis masque amo tleno nijchijtoc? ");
INSERT INTO nhwBl_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Yaya Abraham catli nechilhui para nopa sihuatl eliyaya iicni, huan Sara nojquiya quiijto para Abraham eliyaya itlaca icni. Huajca nochi nijchijqui ica cuali noyolo. Huan na amo tleno catli amo cuali nijchijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Huan Toteco quinanquili ipan temictli: “Na cuali nijmati para tijchijqui ica cuali moyolo huan yeca amo nimitzcahuili xijnechcahui para amo xitlajtlacolchihua noca na. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Huajca ama, xijcuepili isihua nopa tlacatl pampa yaya se tlajtol pannextijquetl huan motlatlajtis huan tlajtlanis para xiitzto. Pero sintla amo tijcuepilis, ta huan nochi catli itztoque mohuaya anmiquise.” ");
INSERT INTO nhwBl_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Huajca hualmostla, Abimelec mejqui cualca huan quinnotzqui itequipanojcahua huan quinpohuili nochi catli quitemictoya. Huan quema quicajque, nelía momajmatijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Teipa Abimelec quinotzqui Abraham huan quiilhui: ―¡Tlaque tijchijtoc! ¿Tlaque tlamantli amo cuali nimitzchihuilijtoc para techhualiquilijtoc na huan nomasehualhua ni hueyi tlajtlacoli? Techchihuilijtoc se tlamantli catli amo quinamiqui techchihuilijtosquía. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Tlaque timoilhuiyaya quema tijsencajqui ni tlamantli? ");
INSERT INTO nhwBl_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Huan Abraham quinanquili: ―Na nimoilhui para nica huelis amo aqui catli quitlepanita Toteco Dios huan nimoilhui nechmictisquíaj pampa quinequisquíaj nosihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Huan melahuac masque yaya nosihua, nojquiya noicni pampa yaya iichpoca notata, pero amo icone nonana. Yeca huelqui nimosihuajti ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Huan quema Toteco Dios nechnahuati ma nijcajtehua ichaj notata para campa hueli tiyase, niquilhui Sara sintla nechicnelía ma quiijto ipan sesen lugar campa tiajsisquíaj para na niiicni. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Huajca Tlanahuatijquetl Abimelec quicuepili Abraham isihua Sara. Nojquiya quinsentili borregojme, huacaxme, huan tlaca tequipanohuani, huan sihua tequipanohuani huan quimacac Abraham, ");
INSERT INTO nhwBl_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","huan quiilhui: ―Xijtlachiliti nochi notlal huan xijtlapejpeni campa más mitzpactis para tiitztos. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Huan Tlanahuatijquetl Abimelec quiilhui Sara: ―Nijmacatoc catli tijnotza ‘moicni’ se mil plata tomi huan quej nopa nelcuali nimitztlaxtlahuía pampa nimitzpinahualti iniixpa nochi catli itztoque mohuaya. Huan amo aqui huelis camanaltis fiero tlen ta por catli panoc. Nochi elis xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Huan Toteco Dios quichijtoya para niyon se sihuatl catli itztoya ichaj Tlanahuatijquetl Abimelec ma amo conepiya quema Sara itztoya ichaj. Huajca Abraham quitlajtlani TOTECO para ma quichicahua Abimelec huan isihua, huan nopa sequinoc isihua tequipanojcahua para sempa huelise conepiyase. Huan inijuanti mochicajque ");
INSERT INTO nhwBl_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","TOTECO quipixqui hueyi iyolo ica Sara huan quitiochijqui quen mocajtoya ihuaya Abraham para quichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Huan Sara conecuic huan quimacac Abraham se icone quema ya eliyaya nelhuehuentzi. Huan nopa oquichpil tlacatqui ipan nopa metztli catli Toteco Dios quiilhuijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Huan Abraham quitocaxtlali icone, Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Huan Abraham quitzontequili iyecapa nopa cuetlaxtli ipan ipiltlacayo quema quipiyayaya chicueyi tonali tlacajtoya quen Toteco Dios quinahuatijtoya ma quichihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Huan Abraham quipiyayaya 100 xihuitl quema tlacatqui Isaac. (Isaac quinequi quiijtos “huetzquistli”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Huajca Sara quiijto: “Toteco Dios quichijtoc ma nihuetzca, huan nochi catli quimatise para nijpixtoc se nocone huetzcase nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","¿Ajqueya quiilhuijtosquía Abraham para na nijchichitisquía icone? Pero ama nijmacatoc se icone quema ya huehuentzi.” ");
INSERT INTO nhwBl_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Huan nopa oquichpil Isaac moscalti huan teipa ipan nopa tonal quema Sara quichichijcahualti, Abraham ilhuichijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Huan Sara quiitac para Ismael catli Abraham quipixqui ica Agar nopa Egipto ejquetl, quihuihuiitayaya Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Huajca Sara yajqui quiilhuito Abraham: “¡Xijquixti nopa tequipanojquetl, Agar, ihuaya icone! Amo quinamiqui para icone ma quiselis san se ihuaya nocone Isaac quema timiquis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Huan ni tlamantli catli Sara quiijto nelía quiyolcoco Abraham pampa nopa oquichpil Ismael nojquiya eliyaya icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Pero Toteco Dios quiilhui: “Amo ximotequipacho ica nopa oquichpil huan motequipanojca. Xijchihua nochi catli Sara mitztlajtlanía pampa moteipan ixhuihua hualase ipan Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Huan nojquiya ica mocone catli nopa sihua tequipanojquetl quitlacatilti niquinmiyaquilis iteipan ixhuihua huan mochihuase seyoc xinachtli masehualme ica nelía miyac imasehualhua pampa yaya nojquiya mocone.” ");
INSERT INTO nhwBl_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Huajca hualmostla nelcualca, Abraham quicuic tlacualistli huan se cuetlaxtli temitoc ica atl huan quimamalti Agar huan quiilhui ma quisa ihuaya ioquichpil Ismael. Huan nopa sihuatl yajqui huan san nentinemiyaya ipan nopa huactoc tlali Beerseba campa amo tleno eli pampa amo quimatiyaya canque yas. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Huan quema tlanqui atl catli eltoya ipan nopa cuetlaxtli, quicajtejqui nopa oquichpil cuatzintla, ");
INSERT INTO nhwBl_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","huan yajqui mosehuito ica huejca pampa amo quinequiyaya quiitas quema miquisquía. Huan quema Agar mosehuijtoya imelac, nopa oquichpil pejqui choca chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Huan Toteco Dios quicajqui para chocayaya nopa oquichpil, huan se itequihua Toteco Dios quinojnotzqui Agar tlen ilhuicac huan quiilhui: “¿Tlaque tijpiya Agar? Amo ximajmahui pampa Toteco Dios quicactoc quen choca ne oquichpil nopona campa itztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Xiya, xijtlanana nopa oquichpil huan xijmatilana. Amo ximajmahuica. Na nijchihuas ma itzto huan iteipan ixhuihua momiyaquilise huan mochihuase se xinachtli masehualme catli nelía miyac imasehualhua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Huajca Toteco Dios quen quiixtlapo Agar para ma quiita se ameli ica atl. Huan yaya yajqui huan quitemitito nopa cuetlaxtli ica atl huan quiamacac Ismael. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Huan Toteco Dios itztoya ihuaya nopa oquichpil huan quipalehui ma moscalti ipan nopa huactoc tlali catli itoca Parán. Huan yaya elqui se cuali tlapejquetl ica cuatlamintli. Huan teipa inana quisihuajti ica se ichpocatl catli ejqui tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Nojquiya ipan nopa tonali Tlanahuatijquetl Abimelec yajqui ihuaya Ficol, nopa tlayacanquetl tlen isoldados para quicamanalhuise Abraham. Huan Tlanahuatijquetl Abimelec quiilhui Abraham: ―Nochi quiitaj para Toteco Dios mitzpalehuía ipan nochi tlamantli catli tijchihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Huajca ama xijtestigojquetza Toteco Dios para amo techhuilanas, niyon na, niyon noconehua, niyon noteipan ixhuihua. San techchihuilis catli cuali quen nimitzchihuili. Nojquiya xijchihua san se ica ni masehualme tlen ni altepetl campa ama tiitztoc quen se seyoc tlali ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Huan Abraham quinanquili: ―Cualtitoc, nijtestigojquetza Toteco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Teipa Abraham quiyolmelajqui Abimelec tlen se ameli catli itequipanojcahua Abimelec quiquixtilijtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Huan Abimelec quinanquili: ―Amo nijmati ajqueya huelqui quichijqui ya nopa. Amo tleno nijmatiyaya tlen ni tlamantli hasta amantzi pampa amo aqui techyolmelajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Huajca Abraham quincuic borregojme huan huacaxme huan quimacac Tlanahuatijquetl Abimelec para quiijtos para temachtli amo moixpanose quen quiijto nopa camanali catli quisencahuayaya ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Pero teipa Abraham quiniyocaquixti chicome sihua pilborregojtzitzi tlen iaxcahua, ");
INSERT INTO nhwBl_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","huan Abimelec quitlatzintoquili: ―¿Para tlen tiquiniyocaquixtijtoc ne chicome sihua pilborregojtzitzi? ");
INSERT INTO nhwBl_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Huan Abraham quinanquili: ―Xiquinseli ni chicome pilsihua borregojtzitzi catli nimitzmaca para ma nesis ta tijmati para na nijchijqui nopa ameli. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Huajca yeca quitocaxtijque campa itztoyaj Beerseba. (Beerseba quinequi quiijtos “ameli campa quitestigojquetzque Toteco Dios”.) Quej nopa quitocaxtijque pampa nopona nopa ome quitestigojquetzque Toteco Dios catli quichihuasquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Huan nopona ipan Beerseba, quema tlanque quichihuaj nopa camanali para amo moixpanose, Abimelec ihuaya Ficol catli quinyacanqui isoldados, mocuepque campa itztoyaj ipan nopa tlali catli nojquiya inintlal nopa filisteos. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Huan ipan Beerseba, Abraham quitojqui se cuahuitl catli itoca tamarisco. Huan nopona quihueyichijqui TOTECO, Nopa Dios Catli Nochipa Itztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Huan para miyac xihuitl Abraham mocajqui nopona ipan inintlal nopa filisteos. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Teipa panoc tonali huan Toteco Dios quiyejyeco Abraham para quiitas sintla nelía quineltoquilía. Huan Toteco Dios quiilhui: ―Abraham. Huan Abraham quinanquili: ―Quena, nica niitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Huan Toteco Dios quiilhui: ―Xijcui Isaac moiyojtzi cone catli nelía tiquicnelía huan xiya hasta nopa tlali catli itoca Moriah. Nopona techmaca quen se tlacajcahualistli ipan se tepetl catli nimitznextilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Huajca hualmostla nelcualca, Abraham mejqui huan quisiyajti iburro, huan quitzontejqui cuahuitl para ipan quitlatis tlacajcahualistli. Huan quistejqui huan yajqui ihuaya icone, Isaac, huan ome itequipanojcahua hasta nopa lugar campa Toteco Dios quiilhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Huan hualhuiptla, Abraham quihuejcaitac nopa lugar, ");
INSERT INTO nhwBl_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","huajca quinilhui itequipanojcahua: ―Ximocahuaca nica ica ni pilburrojtzi. Nooquichpil huan na tiyase achi nepa huan tijhueyichihuatij Toteco Dios huan teipa timocuepase. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Huan Abraham quicuic nopa cuahuitl para nopa tlacajcahualistli huan quitlali iajcolpa Isaac. Huan quicuic nopa cuchillo huan tlitl huan quej nopa nochi ome yajque san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Teipa Isaac quiilhui Abraham: ―¡Papá! Huan Abraham quinanquili: ―¿Tlaque tijnequi, nocone? Huan Isaac quiijto: ―Xiquita, tijpiyaj cuahuitl huan tlitl, pero ¿canque itztoc nopa pilborregojtzi para nopa tlacajcahualistli? Huan Abraham quinanquili: ");
INSERT INTO nhwBl_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","―Nocone, Toteco Dios quichihuas para ma onca se pilborregojtzi para nopa tlacajcahualistli. Huan noja nejnentiyajque san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Huan quema ajsitoj ipan nopa lugar catli Toteco Dios quiilhuijtoya, Abraham quisencajqui se tlaixpamitl huan quicualtlali nopa cuahuitl. Teipa quiilpi icone, Isaac, huan quitlali ipan tlaixpamitl iixco nopa cuahuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Huan Abraham quitlananqui nopa cuchillo para quimictis icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Huan ipan nopa tlatoctzi itequihua TOTECO quihualnojnotzqui tlen nepa ilhuicac: ―¡Abraham! ¡Abraham! Huan Abraham tlananquili: ―Nica niitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Huan itequihua Toteco Dios quiilhui: ―Amo tleno xijchihuili nopa oquichpil. Ya niquita para tiquimacasi huan tijneltoca Toteco Dios huan amo tijtlasomatqui para techmacas moiyojtzi cone. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Huan Abraham tlachixtejqui huan quiitac se borrego catli tacantoya ica icuacua ipan imacuayo se huitzcuahuitl. Huajca yajqui huan quicuito huan ya nopa quimacac Toteco Dios quen se tlacajcahualistli catli ica quipatlac icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Teipa Abraham quitocaxtlali nopa lugar: “TOTECO Catli Temacas Catli Monequi.” Huan yeca noja moijtohua hasta ama: “Ipan ni itepe TOTECO, yaya temacas catli monequi.” ");
INSERT INTO nhwBl_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Huan itequihua TOTECO quinotzqui Abraham ica ompa, ");
INSERT INTO nhwBl_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","huan quiilhui para quej ni TOTECO quiijtohua: ―Pampa tijchijtoc ni tlamantli huan amo tijtlasomatqui moiyojtzi cone, nimotestigojquetza noseli ");
INSERT INTO nhwBl_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","para nimitztiochihuas tlahuel miyac. Nijchihuas para moteipan ixhuihua ma elica onpano miyac miles tlen masehualme hasta amo aqui huelis quinpohuas. Elise quen ininmiyaca nopa sitlalime nepa ilhuicactli huan quen imiyaca xali catli onca iteno hueyi atl. Nojquiya inijuanti nochipa quintlanise inincualancaitacahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Huan niquintiochihuas nochi masehualme ipan nochi tlalme ipan tlaltipactli ica moixhui pampa techneltoquilijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Huan Abraham mocuepqui hasta nopa lugar campa mocajtoyaj itequipanojcahua, huan teipa san sejco mocuepque Beerseba. Huan Abraham mocajqui nopona para itztos. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Teipa panoc miyac tonali huan ajsico camanali para nopa sihuatl Milca nojquiya quimacatoya coneme Nacor, itlaca icni Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Huan iniachtihui ejca elqui Uz, huan teipa tlacatqui Buz. Teipa tlacatqui Kemuel catli teipa elqui itata Aram. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Huan teipa tlacatque Quesed, Hazo, Pildas, Jidlaf huan Betuel. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Huan Betuel moscalti huan elqui itata Rebeca. Ni nopa chicueyi telpocame catli Milca quimacac Nacor catli eliyaya iicni Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Huan nojquiya Nacor quinpixqui telpocame ica Reúma, itequipanojca. Ininconehua elqui Teba, Gaham, Tahas huan Maaca. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara itztoya para 127 xihuitl, ");
INSERT INTO nhwBl_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","huan mijqui ipan altepetl Quiriat Arba catli nojquiya itoca Hebrón huan mocahua ipan tlali Canaán. Huan Abraham motequipacho huan quichoquili Sara pampa mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Teipa quisqui campa huilantoya itlacayo Sara huan yajqui campa nopa heteo tlacame catli itztoyaj ipan nopa lugar huan quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","―Masque nise seyoc tlali ejquetl nica campa amojuanti, technemaquiltica se quentzi amotlal campa nijtocas nomijcatzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Huan nopa heteo tlacame quinanquilijque: ");
INSERT INTO nhwBl_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","―¡Nohuampox, techtlacaquili! Tojuanti timitzitaj para tise hueyi tlacatl catli Dios quitlapejpenijtoc. Ayacmo más ximotequipacho. Xijtlalpacho momijcatzi ipan nopa tecacahuatl catli más cuali tijpiyaj nica. Amo tleno timitztlasomatilise catli mitzmonequilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Huajca Abraham moquetzqui huan mohuijtzonqui ica tlatlepanitacayotl iniixpa nopa heteos, ");
INSERT INTO nhwBl_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","huan quinilhui: ―Sintla nelía anquiitaj cuali para nijtlalpachos nica nomijcatzi, techchihuilica se favor. Xijtlajtlanica Efrón, icone Zohar, ");
INSERT INTO nhwBl_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ma nechnemaquilti nopa tecacahuatl catli itoca Macpela catli eltoc imiltlateno. Na nijtlaxtlahuis quen quinamiqui para nopa tlali huan quej nopa elis noaxca se tecacahuatl nica para ipan nitetlalpachos. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Huan Efrón nopa heteo itztoya nopona ininhuaya. Huan Abraham camanaltiyaya chicahuac para ma quicaquica nochi ihuampoyohua huan nochi catli mosehuiyayaj nechca ipuerta nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Huan Efrón quiijto: ―¡Amo, tata! Na san tlapic nimitzmaca nopa tlali huan nopa tecacahuatl catli eltoc nopona. Iniixpa nohuampoyohua nica nimitzmaca para nopona xijtoca momijcatzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Pero Abraham mohuijtzonqui ica tlatlepanitacayotl iniixpa nopa tlacame catli nopona ehuani. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Huan quiilhui: ―¡Se favor, techtlacaquili! Nimitztlajtlanía xijseli nopa tomi para nopa tlali huan teipa nijtlalpachos nopona nomijcatzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Huajca Efrón quinanquili: ");
INSERT INTO nhwBl_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","―Techtlacaquili, tata. Nopa tlali ipati nahui kilos huan tlajco tlen plata tomi, pero nopa amo quenijqui. San xijseli huan nopona xijtlalpacho momijcatzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Huan Abraham quiitac cuali ipati catli Efrón quiijtojtoya iniixpa nopa heteo tlacame. Yeca quitamachijqui nopa tomi huan quimacac, huan nochi quimatiyayaj para xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Huan quej ni mochijqui iaxca Abraham nopa tlali catli quiyahualo nopa tecacahuatl Macpela catli mocajqui imelac campa hualquisa tonati ipan tlali Mamre ihuaya nochi cuame catli eltoya nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Nochi mochijqui iaxca Abraham iniixpa nopa heteos huan nochi catli mosehuiyayaj nechca ipuerta nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Huan Abraham quitlalpacho Sara ipan nopa tecacahuatl Macpela ipan nopa mili Mamre nechca altepetl Hebrón catli eltoc ipan tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Huajca nopa heteo tlacame quimacaque Abraham se amatlajcuiloli para nopa tlali catli quinemaquiltijque para ipan quitlalpacho Sara. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Huan Abraham ya eliyaya nelhuehuentzi, huan TOTECO quitiochijtoya ica nochi tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Huan se tonal quinotzqui itlayacanca tequipanojca catli quimocuitlahui nochi catli iaxca huan quiilhui: ―Xijtlali momax itzintla nometztomahuiya, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","huan ica ya nopa tijtestigojquetzas TOTECO, nopa Dios catli quinahuatía ilhuicac huan tlaltipactli para amo tijcahuas nocone Isaac ma mocuili se sihuatl tlen ni tlali Canaán campa tiitztoque. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Monequi xiya ipan notlal campa nihualajqui huan xijtlapejpeni se isihua campa noteiximatcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Huan itequipanojca quinanquili: ―Pero ¿tlaque nijchihuas sintla nopa sihuatl amo quinequis hualas nohuaya? ¿Tijnequi ma nijhuicas mocone ipan nopa tlali campa tiquisqui? ");
INSERT INTO nhwBl_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Huan Abraham quiijto: ―¡Amo! Amo xijhuica nocone nepa. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","TOTECO Dios catli tlanahuatía ipan ilhuicac huan catli nechquixti ichaj notata huan noteiximatcahua mitzpalehuis. Yaya catli nohuaya mocajtoc para quinmacas ni tlali noteipan ixhuihua, quititlanis itequihua ma mitzyacana para tijhualicas tlen nepa se ichpocatl para nocone. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Huan sintla nopa ichpocatl amo quinequis hualas mohuaya, huajca ta timocahuas timajcajtos tlen ni camanali, pero amo xijhuica nocone nepa. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Huajca itequipanojca Abraham quitlali imax itzintla imetzcuayo huan quitestigojquetzqui Toteco Dios para temachtli quichihuasquía catli quinequiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Teipa quitlapejpeni miyac tlamantli catli más cuali catli iteco quipiyayaya para temajmacati. Huan quincuic majtlactli camellos catli iaxca Abraham huan yajqui altepetl Nacor ipan tlali Mesopotamia. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Quema itequipanojca ajsitinemiyaya nechca nopa altepetl, ya pejtoya tzintlatlayohuiya. Huan ipan nopa hora miyac sihuame huan ichpocame hualayayaj atlacuij. Huajca quinsiyajquetzqui nopa camellos nechca se ameli, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","huan pejqui motlatlajtía ica TOTECO. Quiilhui: “TOTECO Dios, ta tiiTeco noteco, Abraham, xijchihua para ama ma quisa cuali notequi nica pampa tiquicnelía noteco Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Nimocahuas nica nechca ni ameli campa ichpocame hualahuij atlacuij. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Techcahuili para nopa ichpocatl catli niquilhuis para ma nechtemohuili ico para ma niatlis, ma nechnanquili: ‘Xiatli, huan nojquiya niquinamacas mocamellos’. Huan quej nopa nijmatis para ya nopa catli tijtlapejpenijtoc para isihua Isaac. Huan quej nopa nijmatis para tijtlasojtlatoc noteco, Abraham.” ");
INSERT INTO nhwBl_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Huan ayamo tlamiyaya motlatlajtía quema quiitac se ichpocatl quiquechpanojtihualayaya ico. Huan nopa ichpocatl itoca eliyaya Rebeca huan yaya elqui se iixhui Nacor catli elqui iicni Abraham. Nacor huan isihua, Milca, quipixque se telpoca tlacatl catli itoca Betuel catli elqui itata nopa ichpocatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Huan Rebeca eliyaya nelyejyectzi huan amo quema itztoya ihuaya se tlacatl. Huan Rebeca temotoya hasta campa eltoc ameli quitemitito ico huan ixtlejcoyaya hasta tlalpani ica atl, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","quema nopa tequipanojquetl motlalo quiajsito huan quiilhui: ―Techcahuili ma niquiji se quentzi atl ipan moco. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Huan nopa ichpocatl quinanquili: ―Xiatli, tata. Huan nimantzi quitemohui ico tlen iajcolpa huan quiamacac. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Huan quema nopa tequipanojquetl tlanqui atli, Rebeca quiijto: ―Nojquiya nijquixtis atl para mocamellos hasta tlami atlise. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Huan nimantzi atejqui campa atlij tlapiyalme. Huan motlalo miyac huelta huan temoc campa ameli atlacuiti hasta quintlamiamacac nochi nopa camellos. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Huan nopa tequipanojquetl san quisentlachiliyaya huan amo tleno quiijtohuayaya. San moilhuiyaya quenicatza TOTECO quipalehuijtoya ipan iojhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Huan quema nopa camellos tlanque atlij, nopa tlacatl quiquixti se anillo tlen oro catli quipixqui chicuase gramos ietica huan quimacac para quitlalis ipan iyacatzol. Nojquiya quimacac ome maquechcostli tlen oro catli quipixqui ietica chicuase gramos, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","huan quiilhui: ―Techilhui ajqueya motata huan sintla onca ipan mochaj campa nomasehualhua huan na huelis timocahuase. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Huan yaya tlananquili: ―Niiichpoca Betuel, yaya catli elqui icone Milca huan Nacor. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ipan tochaj onca se lugar campa timocahuas huan nojquiya onca miyac sacatl huan tlacualistli para mocamellos. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Huajca nopa tequipanojquetl motlancuaquetzqui huan quihueyichijqui TOTECO, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","huan quiijto: “Nimitzhueyichihua, TOTECO, ta catli tiiTeco noteco, Abraham. Ta titemachtli huan nelía tijtlasojtlatoc noteco huan techyacantoc ipan ojtli hasta nica campa ininchaj iteiximatcahua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Huan Rebeca motlalojtiyajqui hasta ichaj inana huan quiilhuito nochi catli quipanotoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Huan Rebeca quipiyayaya se itlaca icni catli itoca Labán. Huan Labán motlalo hasta campa ameli quitemoco nopa tlacatl, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","pampa quiitztoya nopa anillo, huan nopa maquechcostli catli iicni quihuicayaya ipan imax huan quicactoya catli panoc. Huan Labán monechcahui campa itequipanojca Abraham catli noja itztoya ihuaya icamellos nechca ameli, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","huan quiilhui: ―Xihuala nochaj, ta catli TOTECO mitztiochijtoc. ¿Para tlen tiitztoc nica huejcatzi? Nijcualtlalijtoc nochaj para ta huan nojquiya onca campa mocahuase mocamellos. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Huajca itequipanojca Abraham yajqui ihuaya. Huan nopona Labán quintlatemohuili nopa camellos huan quintlamacac. Teipa quihualicac atl huan quinmacac nopa tequipanojquetl huan nopa masehualme catli ihuaya hualayayaj para ma moicxipajpacaca. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Huan quema quintlalilijque tlacualistli para tlacuase, itequipanojca Abraham quiijto: ―Na amo nitlacuas hasta niquijtos catli monequi niquijtos. Huan Labán quiijto: ―Huajca techilhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Huan nopa tequipanojquetl quiijto: ―Na niitequipanojca Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","TOTECO miyac quitiochijtoc noteco huan quiricojchijtoc. Quimacatoc tlahuel miyac borregojme, huacaxme, camellos huan burrojme. Quimacatoc miyac tlaca tequipanohuani huan sihua tequipanohuani, huan iyoca quimacatoc tlahuel miyac oro huan plata. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Nojquiya Sara, isihua Abraham, quimacac se icone quema eliyaya neltenantzi. Huan noteco quicahuilijtehuas icone nochi catli quipiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Pero ya nechchihualti ma nijtestigojquetza Toteco Dios para amo nijcahuas para icone ma mocuili se sihuatl catli ehua ipan nopa tlali Canaán campa tiitztoque. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Nechilhui ma nihuala nica campa iteiximatcahua itata huan ma nijtemo tlen amojuanti se sihuatl para icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Huan na nijtlajtlani noteco tlaque monequi nijchihuas sintla nopa sihuatl amo quinequis hualas nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Huan ya nechnanquili: ‘Na ninentoc ipan iojhui TOTECO huan nijmati yaya quititlanis itequihua huan mitzyacanas para nochi quisas cuali ipan moojhui. Huan temachtli tijpantis se sihuatl para nocone nepa campa noteiximatcahua huan iteiximatcahua notata.’ Quej nopa nechilhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Pero nechilhui sintla noteiximatcahua amo quinequise mitzmacase nopa ichpocatl, nopona tlamis ni camanali catli tijtestigojquetztoc Toteco Dios para tijchihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Huajca ama quema niajsico campa ameli, niquilhui TOTECO Dios, yaya catli iTeco noteco, Abraham: ‘Sintla mopaquilis ta, xijchihua nochi ma quisa cuali ipan ni noojhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ama niitztoc nechca ni ameli. Huajca xijchihua para quema hualas se ichpocatl atlacuiqui huan niquilhuis: Se favor, techcahuili niquijis se quentzi atl ipan moco, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","para ma nechnanquili: Xiatli, huan nojquiya nijquixtis atl para mocamellos. Huan quej nopa nijmatis para yaya nopa ichpocatl catli tijtlapejpenijtoc para icone noteco.’ Quej nopa niquilhui TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Huan ayamo nitlamiyaya nimotlatlajtía quema niquitac Rebeca quiquechpanojtiyohuiyaya ico. Huan Rebeca temoc campa ameli para atlacuis huan niquilhui: ‘Se favor, techcahuili niquijis se quentzi atl ipan moco.’ ");
INSERT INTO nhwBl_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Huan Rebeca nimantzi quitemohui ico para ma niatli huan nechilhui: ‘Xiatli huan nojquiya nijquixtis atl para mocamellos.’ ");
INSERT INTO nhwBl_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Huan teipa nijtlatzintoquili: ‘¿Ajqueya tiiichpoca?’ Huan ya nechnanquili para yaya iichpoca Betuel catli elqui icone Nacor huan Milca. Huajca nijtlalili se anillo ipan iyacatzol huan se maquechcostli ipan imax. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Huan nimotlancuaquetzqui huan nijhueyichijqui huan nijpaquilismacac TOTECO Dios, yaya catli iTeco noteco Abraham pampa nechyacanqui ipan ojtli catli xitlahuac para nijpantis para icone se ichpocatl catli itztoc se iteiximatca noteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Huajca ama techilhuica sintla anquichihuase catli cuali huan xitlahuac ihuaya noteco huan anquicahuilise Rebeca ma yas nohuaya. Huan sintla amo, techilhuica nojquiya para nijmatis tlaque monequis nijchihuas.” ");
INSERT INTO nhwBl_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Huajca Labán huan Betuel quinanquilijque: ―Nochi ya ni huala tlen TOTECO huan tiquitaj para yaya ipaquilis. Huajca amo huelis tojuanti timitzilhuise quena o amo. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Xiquita, nica itztoc Rebeca. Huelis tijhuicas para ma eli isihua icone moteco quen TOTECO quitlalijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Huajca quema itequipanojca Abraham quicajqui ya nopa, motlancuaquetzqui iixpa TOTECO huan mohuijtzonqui hasta tlalchi para quitlascamatis. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Teipa quiquixti miyac tlamantli tlen oro, plata huan miyac yoyomitl huan quimacac Rebeca. Nojquiya itlaca icni huan inana quintlamajmacac. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Huan quema tlanqui, ya ihuaya nopa tlacame catli ihuaya yohuiyayaj tlacuajque huan tlaique huan nopona mocajque nopa yohuali. Huan hualmostla nopa tequipanojquetl quiijto: ―Techcahuilica nimantzi ma nimocuepas ichaj noteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Pero itlaca icni huan inana Rebeca quiilhuijque: ―Noja ma mocahua ni ichpocatl majtlactli tonali tohuaya huan teipa yas mohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Pero nopa tequipanojquetl quinilhui: ―Amo techtzacuilica más pampa TOTECO quichijtoc ma quisa cuali noojhui, yeca techcahuilica nimantzi ma nimocuepa ichaj noteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Huajca inijuanti quinanquilijque: ―Tijnotzase nopa ichpocatl huan tiquitase tlaque quiijtos. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Huajca quinotzque Rebeca huan quitlatzintoquilijque: ―¿Tijnequi tiyas ihuaya ni tlacatl amantzi? Huan Rebeca tlananquili: ―Quena, niyas. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Huajca quicahuilijque Rebeca ma yohui ihuaya itequipanojca Abraham huan inijuanti catli hualajtoyaj ihuaya. Huan nopa sihua tequipanojquetl catli nochipa quimocuitlahuijtoya Rebeca nojquiya yajqui ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Huan iteiximatcahua quitiochijque Rebeca quej ni: “Toicni, ¡xieli ininnana tlahuel miyac masehualme! ¡Moteipan ixhuihua nochipa ma tlatlanica, ica inincualancaitacahua!” ");
INSERT INTO nhwBl_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Huajca Rebeca ihuaya itequipanojcahua tlejcoque ipan camellos huan quitoquilijque itequipanojca Abraham. Huan quej nopa ne tequipanojquetl quicuitejqui Rebeca. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Teipa ipan tlali Canaán Isaac catli mochantijtoya ipan Neguev, mocuepayaya tlen nopa ameli catli itoca “Iamel Toteco Catli Itztoc Huan Nechita”. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Huan se tonal ica tiotlac Isaac quistoya ichaj para nejnemis huan motlatlajtis huan tlachixqui huan quinitac sequin camellos catli monechcahuiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Huan Rebeca nojquiya huejca tlachixqui huan quema quiitac Isaac, temoc tlen nopa camello, ");
INSERT INTO nhwBl_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","huan quiilhui nopa tequipanojquetl: ―¿Ajqueya ne tlacatl catli quistinemi ipan ne mili huan toixmelac huala? Huan nopa tequipanojquetl tlananquili: ―Yaya noteco. Huajca Rebeca moixtzajqui ica itzontzajcayo. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Huan quema ajsitoj, nopa tequipanojquetl quipohuili Isaac nochi catli quichijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Huan teipa Isaac quihuicac Rebeca ipan ichaj tlen yoyomitl catli achtihui elqui iaxca Sara huan quichijqui isihua. Huan Isaac quiicneli Rebeca huan quej nopa moyoltlali pampa inana mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Huan Abraham mocuili seyoc isihua catli itoca Cetura. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Huan iconehua catli quinpixqui ihuaya elque Zimram, Jocsán, Medán, Madián, Isbac huan Súa. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Huan teipa Jocsán quinpixqui itelpocahua catli inintoca Seba huan Dedán. Huan iteipan ixhuihua Dedán elque nopa asureos, letuseos huan leumeos. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Huan iconehua Madián elque Efa, Efer, Hanoc, Abida huan Elda. Nochi ya ni elque iteipan ixhuihua Cetura. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Huan Isaac quiseli nochi catli Abraham quipiyayaya quema mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Pero quema ayamo miquiyaya, quintlamajmacac iconehua catli tlacajtoyaj ica isihua tequipanojcahua huan quintitlanqui neca quentzi más para campa hualquisa tonati huan quej nopa quiniyocatlali ica icone Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Huan Abraham itztoya 175 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Huan mijqui san pampa eliyaya nelhuehuentzi huan yajqui mosansejcotilito ininhuaya ihuejcapan tatahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Huan Isaac huan Ismael, itelpocahua Abraham, quitlalpachojque ipan nopa tecacahuatl catli itoca Macpela catli mocahua más campa hualquisa tonati tlen altepetl Mamre. Nopa tecacahuatl elqui ipan itlal se heteo tlacatl itoca Efrón catli elqui icone Zohar. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Huan Abraham quincohuilijtoya nopa heteos nopa tlali para ipan quitocas isihua, Sara. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Teipa quema Abraham mijqui, Toteco Dios miyac quitiochijqui Isaac. Huan Isaac mocahuayaya nechca nopa ameli catli itoca “Iamel Yaya Catli Itztoc Huan Catli Nechita.” ");
INSERT INTO nhwBl_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Nica eltoc inintoca iconehua Ismael catli elqui icone Abraham ihuaya Agar, isihua tequipanojca Sara catli hualajqui tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya ni inintoca quen tlacajtiyajque: Nebaiot, catli elqui achtihui ejquetl, teipa Cedar, Adbeel, Mibsam, ");
INSERT INTO nhwBl_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Massa, ");
INSERT INTO nhwBl_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis huan Cedema. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Nochi ya ni inintoca nopa 12 iconehua Ismael. Sesen mochijqui tlayacanquetl ipan se hueyi familia tlen iixhuihua. Huan nica quipiya campa mochansehuijtiyajqui huan nopa pilaltepetzitzi catli mochijqui quihuicayaya sesen hueyi familia itoca. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Huan Ismael quipiyayaya 137 xihuitl quema mijqui huan mosansejcotilito ininhuaya ihuejcapan tatahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Teipa iteipan ixhuihua Ismael mosemanque campa hueli ipan nopa tlali tlen Havila hasta Shur nechca iteno tlali Egipto ipan ojtli para Asiria. Nopona iteipan ixhuihua Ismael mocajque huan nochipa mohuilanayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Amantzi nimechpohuilis catli panoc ica Isaac, icone Abraham. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaac quipiyayaya 40 xihuitl quema mosihuajti ihuaya Rebeca catli eliyaya iichpoca Betuel huan iicni Labán. Labán huan Betuel eliyayaj nopa arameos catli itztoyaj ipan tlali Aram. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Huan Rebeca amo hueliyaya conepiya huan Isaac quitlajtlani TOTECO por ya. Huan TOTECO quicajqui catli quitlajtlani huan Rebeca conecuic. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Pero quinpixqui cuateme catli mohuilanayayaj iijtico huan moilhui: “Sintla quej ni elis nonemilis, amo huelis niquijiyohuis.” Huajca yajqui quitlajtlanito TOTECO para tlen quej nopa ipantiyaya, ");
INSERT INTO nhwBl_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","huan TOTECO quinanquili: “Ome coneme itztoque ipan moijti. Huan inijuanti huan ininteipan ixhuihua mochihuase ome xinach masehualme. Huan sesen quinpiyas miyac imasehualhua huan itztose ipan ome tlalme. Ya pejtoque mohuilanaj quema ayamo tlacatij, huan para nochipa ininteipan ixhuihua nojquiya mohuilanase. Se elis más tetic que ne seyoc. Huan nopa teipan ejquetl quipiyas más tlanahuatili que nopa achtihui ejquetl.” ");
INSERT INTO nhwBl_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Huan quema ajsic nopa tonali para Rebeca conepiyas, nelía quinpixqui cuateme. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nopa achtihui ejquetl nesiyaya chichiltic huan quipixqui miyac itzoyo ipan nochi itlacayo. Huan quitocaxtijque Esaú. (Esaú quinequi quiijtos “catli quipiya miyac itzoyo”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Huan nimantzi tlacatqui ne seyoc catli quiitzquilijtoya icotztla iachtihui ejca icni ica se imax. Yeca quitocaxtijque Jacob. (Jacob quinequi quiijtos “catli tlaitzquía” o “catli tlacajcayahua”.) Huan Isaac quipiyayaya 60 xihuitl quema Rebeca conepixqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Huan nopa oquichpilme moscaltijque. Huan Esaú elqui se tlacatl catli quipactía nejnemi cuatitla huan elqui se cuali tlapejquetl. Pero Jacob eliyaya se tlacatl catli quipixqui iyolo huan quipactía mocahuas ichaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Huan Isaac más quiicneli Esaú pampa quipactiyaya quicuas catli quinmictiyaya quema tlapehuayaya, pero Rebeca quiicneli Jacob. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Huan se tonal quema Jacob quichihuayaya tlacualistli, Esaú mocuepqui tlen cuatitla nelsiyajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Huan quiilhui iicni: ―Techchihuili se favor, techmaca se quentzi nopa tlacuali chichiltic catli tijpiya nopona pampa ya niapismiqui. (Yeca Esaú nojquiya quitocaxtiyayaj Edom catli quinequi quiijtos “chichiltic”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Huan Jacob quiilhui: ―Achtihui techmaca motequiticayo pampa tiachtihui ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Huajca Esaú quiilhui: ―Tiquita ya niapismiqui huan nopa tequiticayotl catli nijpiya pampa niachtihui ejquetl amo nechpalehuis quema nimiquis. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Huajca Jacob quiilhui: ―Xijtestigojquetza Toteco Dios amantzi para noaxca. Huan Esaú quitestigojquetzqui Toteco huan quej nopa quipanoltili Jacob nopa tequiticayotl catli eliyaya iaxca pampa achtihui ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Huajca Jacob quimacac Esaú pantzi huan se tlacualistli tlen nopa etl catli siltic. Huan quema Esaú tlanqui tlacua, moquetzqui huan yajqui, niyon amo quichijqui cuenta sintla quipolojtoya itequiticayo tlen achtihui ejquetl pampa amo quipatiitayaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ipan nopa tonali oncayaya se hueyi mayantli pampa amo oncayaya tlacualistli ipan nochi nopa tlali. Quej ni nojquiya panotoya achtihuiya quema Abraham noja itztoya. Huan yeca Isaac yajqui altepetl Gerar campa tlanahuatiyaya Abimelec, inintlanahuatijca filisteos. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Nopona TOTECO monexti ica Isaac huan quiilhui: “Amo xiya tlali Egipto, ximocahua campa na nimitzilhuis ");
INSERT INTO nhwBl_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","nica ipan ni tlali. Huan na niitztos mohuaya huan nimitztiochihuas. Huan se tonal nimitzmacas ta ihuaya moteipan ixhuihua nochi ni tlalme. Quej nopa nijtlamichihuas catli nijtencahuili motata Abraham para temachtli nijchihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Huan nijchihuas ma elica nelmiyaqui moteipan ixhuihua quen sitlalime ipan ilhuicac. Huan niquinmacas nochi ni tlalme. Nojquiya niquintiochihuas nochi masehualme ipan nochi tlalme ipan tlaltipactli por moixhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Nochi ya ni nijchihuas pampa Abraham nechneltoquili huan quichijqui catli niquilhui. Quitoquili nochi catli niquilhui para monequi quichihuas. Quitoquili notlanahuatil, notlamachtil huan nochi noleyes.” ");
INSERT INTO nhwBl_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Huajca Isaac mocajqui ipan altepetl Gerar. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Huan quema nopa masehualme catli nopona ehuaj quitlatzintoquilijque quenicatza quiitayaya Rebeca, Isaac majmajqui quiijtos eliyaya isihua huan istlacatqui huan quiijto para eliyaya iicni. Isaac moilhui nopa tlacame catli nopona ehuaj quimictisquíaj huan mocuilisquíaj Rebeca pampa eliyaya nelyejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Huan quema Isaac mocajtoya nopona miyac tonali, se tonal Abimelec tlachixtoya ipan iventana huan quiitac para Isaac quinajnahuayaya isihua Rebeca. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Huajca tlatitlanqui ma quinotzatij huan quiilhui: ―Yaya mosihua, ¿amo que? Huajca, ¿para tlen tiquijto para eliyaya moicni? Huan Isaac tlananquili: ―Na nimoilhui nohueli nechmictisquíaj por ya. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Huajca Abimelec quiilhui: ―¿Para tlen techcajcayajtoc ica ni tlamantli? San se quentzi huan se catli ehua nica hueltosquía motectosquía ihuaya mosihua huan topani huetztosquía se tlatzacuiltilistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Huajca Tlanahuatijquetl Abimelec quinilhui nochi imasehualhua: ―Sintla acajya quicuatotonía ni tlacatl o isihua, quipantis miquilistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Huan ipan nopa xihuitl nopona ipan nopa tlali, Isaac tojqui huan quisentili miyac pixquistli hasta 100 hueltas catli quitoctoya pampa TOTECO quitiochijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Huan Isaac moricojchijqui. Huan nochi catli iaxca más momiyaquili hasta nelnelía mochijqui se hueyi tlacatl ica miyac chicahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Quinpixqui tlahuel miyac borregojme, chivojme, huacaxme huan tequipanohuani. Huajca nopa filisteos pejque quicualancaitaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Huan quitemitijque ica tlali nochi iamel Isaac. Ni amelme quixajtoyaj itequipanojcahua Abraham, itata Isaac, huejcajya quema noja itztoyaj ipan nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Huajca teipa Tlanahuatijquetl Abimelec quiilhui Isaac: ―Xiya seyoc lado pampa ica nochi motequipanojcahua huan motlapiyalhua nelía anmiyaqui huan anitztoque más antetique que tojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Huajca Isaac huan nochi catli itztoyaj ihuaya yajque. Huan quiquetzque ininchajchaj tlen yoyomitl ipan nopa tlamayamitl tlatlajco nopa tepeme nechca altepetl Gerar. Huan nopona mocajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Huan Isaac sempa quitlapo nochi nopa ameli catli itata quixajtoya catli filisteos quitzactoyaj quema ya mijqui. Huan sempa quitocaxti sesen ameli quen itata quintocaxtlalijtoya achtihuiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Huan se tonal itequipanojcahua Isaac quichihuayayaj se ameli ipan nopa tlamayamitl huan quipantijque campa meyayaya se yejyectzi atl. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Pero altepetl Gerar ehuani catli quinmocuitlahuiyayaj borregojme pejque monajnanquilíaj ininhuaya catli quinmocuitlahuiyayaj iborregojhua Isaac. Quinilhuiyayaj para nopa atl eliyaya iniaxca. Yeca Isaac quitocaxti nopa ameli Esek pampa ica monajnanquilijque. (Esek quinequi quiijtos “tlanajnanquilistli”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Huan teipa itequipanojcahua Isaac quitlapojque seyoc ameli, pero sempa ica mohuilanque. Huan nopa ameli quitocaxti Sitna. (Sitna quinequi quiijtos “cualancaitali”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Huajca Isaac quincajtejqui huan moiyocaquixti huejca. Nopona quixajqui seyoc ameli, pero amo aqui yajqui nepa para quihuilanas. Huajca quitocaxti Rehobot. (Rehobot quinequi quiijtos “hueyi tlali”.) Quej nopa quitocaxti pampa Isaac quiijto para ama TOTECO quitiochijtoc huan quimacatoc se hueyi tlali catli quiaxili para nochi itlapiyalhua ma moscaltica. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Huan Isaac yajqui campa itoca Beerseba, ");
INSERT INTO nhwBl_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","huan nopa tlayohua TOTECO monexti ica ya huan quiilhui: “Na niDios catli niiTeco motata, Abraham. Amo ximajmahui, na niitztoc mohuaya. Nimitztiochihuas huan niquinmiyaquilis moteipan ixhuihua, pampa niquelnamiqui catli nijtencahuili notequipanojca Abraham.” ");
INSERT INTO nhwBl_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Huajca Isaac quisencajqui se tlaixpamitl nopona huan quihueyichijqui TOTECO. Huan nopona quiquetzqui ichaj tlen yoyomitl, huan itequipanojcahua quixajque se ameli. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Se tonal Abimelec hualajqui tlen altepetl Gerar para mocamanalhuis ihuaya Isaac. Ihuaya hualayaya ihuampox Ahusat catli quitlalnamictiyaya huan Ficol catli quinnahuatiyaya isoldados. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Huan Isaac quintlatzintoquili: ―¿Para tlen anhualajque antechitaquij? Antechtojtocaque ipan amotlal pampa antechcualancaitayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Huan quiilhuijque: ―Tiquitztoque para TOTECO itztoc mohuaya, huan timoilhuíaj cuali ma tijchihuaca se camanali. Nopa camanali elis ya ni: ");
INSERT INTO nhwBl_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Xijtestigojquetza para amo quema techcocos pampa tojuanti amo quema timitzcocojtoque. Nochipa timitzchihuilijtoque catli cuali huan quema monejqui timoiyocaquixtis tlen tojuanti, timitzmacaque ica cuali quen titohuampox. Huan ama xiquita quenicatza TOTECO mitztiochijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Huajca Isaac quinchihuili se hueyi tlacualistli, huan san sejco inijuanti tlacuajque huan tlaique. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Huan hualmostla ica ijnaloc, mejque huan quitestigojquetzque Toteco para amo quema moixpanosquíaj se ica seyoc. Teipa Isaac quinnahuatijtejqui ica cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ipan nopa tonal, itequipanojcahua Isaac quiyolmelahuacoj para quipantijtoyaj atl campa tlaxahuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Huan Isaac quitocaxti nopa ameli Seba. (Seba quinequi quiijtos “campa tlatestigojquetzqui”.) Huan yeca nopa altepetl hasta ama itoca Beerseba. (Beerseba quinequi quiijtos “ameli campa tlatestigojquetzque”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Huan quema Esaú quipiyayaya 40 xihuitl mosihuajti ihuaya Judit catli eliyaya iichpoca Beeri se heteo tlacatl. Huan nojquiya Esaú mosihuajti ihuaya Basemat iichpoca seyoc heteo tlacatl catli itoca Elón. ");
INSERT INTO nhwBl_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Huan ni ome sihuame quinmacaque Isaac huan Rebeca miyac tequipacholi. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Huan Isaac eliyaya nelhuehuentzi huan ayacmo tlachiyayaya. Huan se tonal quinotzqui Esaú, icone catli achtihui ejquetl huan quiilhui: ―¡Nocone! Huan Esaú quinanquili: ―Techilhui tlaque tijnequi, papá. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Huan Isaac quiijto: ―Ya tiquita para ninelhuehuentzi huan tlen hueli tonali hueli nimiquis. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yeca nijnequi xiya cuatitla ica mocuahuitol huan cuatlamintli para xijmictiti se masatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Teipa xijsencahua se tlacualistli ajhuiyac quen na nechpactía huan xijhualica para nijcuas. Huan huajca nimitzmacas notlatiochihual iixpa Toteco quema ayamo nimiqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Pero Rebeca quitlacaquilijtoya catli Isaac quiilhuiyaya Esaú. Huan teipa quema Esaú yajqui cuatitla para quiitzquiti se masatl para itata, ");
INSERT INTO nhwBl_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca quinotzqui Jacob, iteipan ejca huan quiilhui: ―Nijcajqui para motata mocamanalhuiyaya ihuaya moicni Esaú huan quiilhuiyaya, ");
INSERT INTO nhwBl_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","para ma quiitzquiti se masatl huan quisencahuilis se tlacualistli catli ajhuiyac para quicuas. Quiijto para teipa quimacas itlatiochihual iixpa TOTECO quema ayamo miqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Huajca nocone, xijtlacaquili cuali catli nimitzilhuis: ");
INSERT INTO nhwBl_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Xiya campa itztoque totlapiyalhua huan techhualiquili ome oquich chivojme catli más cuali. Huan nijsencahuilis motata se tlacualistli ajhuiyac quen ya quipactía. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Huan teipa tijhuiquilis ma quicua, huan quej nopa mitztiochihuas iixpa Toteco quema ayamo miqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Pero Jacob quiilhui inana: ―Noicni quipiya miyac itzoyo ipan nochi itlacayo, huan na, amo. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Sintla notata nechpanitzquis, quimatis amo niEsaú. Huan moilhuis para san ica nimahuiltía, huajca nijchihuas ma nechtelchihuas huan amo nechtiochihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Pero inana quinanquili: ―Nocone, na nopani ma huetzi nopa tlatelchihuali. Ta xijchihua catli nimitzilhuía huan techhualiquili nopa oquich chivojme. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Huajca Jacob quincuito nopa oquich chivojme huan quinhuicac campa inana. Huan inana quisencajqui se tlacualistli ajhuiyac quen Isaac quipactiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Huan Rebeca quiquixti nopa yoyomitl catli más cuali catli Esaú, iachtihui cone, quiajoctoya ipan ichaj. Huan nopa yoyomitl quitlalili Jacob catli elqui iteipan cone. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Huan quinquixtili inincuetlaxo nopa chivojme ica nochi iniijhuiyo huan ica quipijqui Jacob ipan imax huan iquechtla campa amo quipiyayaya itzoyo. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Teipa quimacac nopa tlacualistli huan nopa pantzi catli quisencajtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Huajca Jacob calajqui campa itztoya itata huan quiilhui: ―¡Papá! Huan Isaac quinanquili: ―Nica niitztoc. ¿Ajqueya ta, nocone? ");
INSERT INTO nhwBl_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Huan Jacob quiilhui: ―Na niEsaú, moachtihui ejca cone. Ya nijchijtoc catli techilhui. Ximehua, ximosehui huan xijcua ni masatl catli nijmicti huan techmaca motlatiochihual. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Huajca Isaac quitlatzintoquili: ―¿Quenicatza huelqui tijpanti nelnimantzi, nocone? Huan Jacob quinanquili: ―TOTECO, moDios, nechpalehui para nijpanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Pero Isaac quiilhui: ―Ximonechcahui huan techcahuili ma nimitzijitzquis sintla nelía tinocone Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Huan Jacob monechcahui para ma quiitzqui itata. Huan Isaac quiijto: “Nijcaqui motoscac quen Jacob, pero momax eltoc quen tiEsaú.” ");
INSERT INTO nhwBl_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Huan Isaac amo quimatqui sintla eliyaya Jacob pampa imax quipiyayaya miyac itzoyo quen iicni, Esaú. Huajca quema quimacasquía itlatiochihual iixpa Toteco, ");
INSERT INTO nhwBl_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","sempa quitlatzintoquili: ―¿Nelía ta tinocone Esaú? Huan Jacob quiilhui: ―Quena, na niEsaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Huajca itata quiilhui: ―Techtequili, nocone, para nijcuas catli tijmicti, huan teipa nimitzmacas notlatiochihual. Huajca Jacob quitequili para ma tlacua itata huan nojquiya quihualiquili xocomeca atl. Huan Isaac tlacuajqui, ");
INSERT INTO nhwBl_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","huan teipa quiilhui: ―Ximonechcahui, nocone huan techtzoponi. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Huan quema Jacob monechcahui para quitzoponis, Isaac quiijnejqui iyoyo huan moilhui huelis nelía iachtihui ejca cone. Huajca quitiochijqui ica ni camanali: “Ajhuiyac catli niquijnecui tlen nocone. Mijyotía quen cuatitlamitl catli TOTECO quitiochijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Toteco Dios ma mitzmaca atl tlen ilhuicac, para tijpiyas pixquistli catli más cuali ipan motlal. Ma mitzmaca miyac trigo, huan miyac xocomeca atl. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Miyac masehualme ma mitztequipanoca. Ma motlancuaquetzaca moixpa, masehualme tlen miyac tlalme. Xiquinnahuati moicnihua. ¡Huan ma motlancuaquetzaca moixpa nochi catli monana quintlacatilti! Catli mitztelchihuase elise tlatelchihualme. Huan catli mitztiochihuase elise tlatiochihualme.” ");
INSERT INTO nhwBl_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Teipa Isaac tlanqui quitiochihua Jacob huan quema Jacob quisayaya tlen campa itata, Esaú mocuepqui tlen tlapehuato. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Huan Esaú nojquiya quisencajqui se tlacualistli ajhuiyac huan quihuiquili itata. Huan quiilhui: ―Ximoquetza, papá. Xijcua ni catli nijpehuato huan techmaca motlatiochihual iixpa Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Huajca Isaac quitlatzintoquili: ―¿Ajqueya ta? Huan ya tlananquili: ―Na niEsaú, moachtihui ejca. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Huan Isaac amo quimatiyaya tlaque quiijtos. Huan ica itoscac huihuipicayaya, quiijto: ―Huajca, ¿ajqueya nechhualiquili nopa tlacualistli catli quicuito ipan cuatitlamitl? Na nijcuajqui quema ayamo tiajsiyaya huan nijmacac nopa tlatiochihualistli, huan ya nelía elis tlatiochihuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Quema Esaú quicajqui catli itata quiijto, tzajtzic tlahuel chicahuac ica miyac tequipacholi huan teipa quiijto: ―¡Techtiochihua nojquiya, papá! ");
INSERT INTO nhwBl_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Pero Isaac quinanquili: ―Ya hualajqui moicni, huan nechcajcayajqui. Quihuicac nopa tlatiochihuali catli eliyaya para ta. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Huan Esaú quiijto: ―¡Yeca quitocaxtijque Jacob! (Jacob quinequi quiijtos ‘tlacajcayajquetl’.) ¡Ica ni mochihua ome hueltas nechcajcayajtoc! Achtihui nechquixtili notequiticayo catli nechtocaro pampa niachtihui ejquetl. Huan ama nechquixtilijtoc notlatiochihual. ¿Amo ticajoctoc seyoc tlatiochihuali para na? ");
INSERT INTO nhwBl_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Huajca Isaac quinanquili: ―Xiquita, na nijmacatoc Jacob tlanahuatili para mitznahuatis. Niquijtojtoc para iteiximatcahua elise itequipanojcahua. Niquilhuijtoc para quipiyas miyac trigo huan miyac xocomeca atl. ¿Tlaque mocahuas para huelis nimitzchihuilis, nocone? ");
INSERT INTO nhwBl_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Huan Esaú noja quiilhui: ―¿San hueli titemaca san se tlatiochihuali, papá? ¡Techtiochihua nojquiya! Huan Esaú sempa tlahuejchijqui huan chocac. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Huajca Isaac quiilhui: “Tiitztos huejca ipan tlali catli amo hueli tlaixhualtía, huan campa amo tlaquiyahuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Huan monequis timomanahuis ica momachete. Tielis tiitequipanojca moicni, pero quema ayacmo huelis tiquijiyohuis más, timoquixtis imaco.” ");
INSERT INTO nhwBl_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Huajca Esaú quicualancaitac Jacob pampa quiichtequilijtoya itlatiochihual huan pejqui moilhuía: “Ya nechca para miquis notata. Quema ya panotos nopa tequipacholi, nijmictis noicni, Jacob.” ");
INSERT INTO nhwBl_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Huan Rebeca quimatqui catli Esaú moilhuiyaya quichihuas, huajca Rebeca tlatitlanqui ma quinotzatij Jacob. Huan quema ajsico, Rebeca quiilhui: ―Xiquita, ica nopa catli tijchihuili moicni, Esaú, yaya ama quinequi mitzmictis. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Yeca, nocone, techtlacaquili; xicholo nimantzi hasta tlali Harán hasta ichaj noicni, Labán. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ximocahua nopona se ome xihuitl hasta quema ayacmo cualantos moicni. ");
INSERT INTO nhwBl_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Huan quema ya quielcajtos catli tijchihuilijtoc, nitlatitlanis ma mitzyolmelahuaca para ximocuepa. ¡Amo nijnequi niquinpolos ome noconehua ipan san se tonal! ");
INSERT INTO nhwBl_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Huan teipa Rebeca quiilhui Isaac: ―Ya nisiyajtoc por ni heteo ichpocame catli Esaú mocuilijtoc. Sintla Jacob mocuilis se ichpocatl catli ehua nica ipan tlali Canaán, más cuali ma nimiqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Huajca Isaac quinotzqui Jacob, huan quitiochijqui huan quiilhui: “Amo ximosihuajti ica se sihuatl tlen ni tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Xiya tlali Aram campa ichaj mohueyi tata Betuel huan ximosihuajti ihuaya se iichpoca motío Labán. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Toteco Catli Quipiya Nochi Chicahualistli ma mitztiochihua huan ma mitzmaca miyac moixhuihua para ipan ta ma quisaca nelmiyaqui masehualme catli itztose ipan miyac tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Toteco ma mitzmaca ta huan moteipan ixhuihua nopa tlatiochihuali catli quitencahuili Abraham. Ma anmechaxcati ni tlali campa ipan tiitztoque ama quen tiseyoc tlali ehuani pampa ya ni nopa tlali catli quitlajtolcahuili Abraham para quinmacas iteipan ixhuihua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Huajca quej nopa Isaac quititlanqui Jacob ipan tlali Aram. Huan Jacob ajsito ichaj Labán catli eliyaya icone Betuel catli ehua tlali Aram. Huan Labán eliyaya iicni Rebeca catli eliyaya inana Jacob huan Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaú quimatqui para Isaac quimacac itlatiochihual Jacob huan quititlanqui ipan tlali Aram para ma mosihuajtiti nepa. Huan quinahuatijtoya ma amo mosihuajti ica se sihuatl catli ehua tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Nojquiya quimatqui para Jacob quistoya para tlali Aram quen itata huan inana quiilhuijtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Huajca Esaú momacac cuenta para itata amo quipactiyayaj sihuame catli ehuaj tlali Canaán campa inijuanti itztoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Yeca yajqui quiitato itío, Ismael, catli nojquiya icone Abraham. Nopona mosihuajti ihuaya se iichpoca catli itoca eliyaya Mahalat huan catli eliyaya iicni Nevaiot. Huajca Mahalat mochijqui isihua Esaú ininhuaya nopa sequinoc sihuame cananeos catli ya mocuilijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Huan Jacob quistoya altepetl Beerseba huan yajqui ipan nopa ojtli catli yohui altepetl Harán. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Huan ajsic ipan se lugar huan nopona panoc nopa tlayohua pampa ya temotoya tonati. Huan quicuic se tetl huan quitequihui para itzonteto. Huan motejqui huan cochqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Huan quipixqui se temictli huan quiitayaya se escalera catli ijcatoya tlalchi huan ajsiyaya hasta ilhuicac. Huan itequihuajcahua TOTECO ipan temoyayaj huan tlejcoyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nojquiya quiitayaya para TOTECO Dios itztoya huejcapa huan quiilhuiyaya: “Na niininTeco mohueyi tata Abraham huan motata Isaac. Ta huan moteipan ixhuihua niquinmacas ni tlali campa amantzi tiitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Moteipan ixhuihua elise nelmiyaqui quen imiyaca tlaltejpoctli catli amo aqui huelis quinpohuas. Huan mosemanase campa hueli. Yase hasta sur, huan norte, huan hasta campa hualquisa tonati huan hasta campa oncalaqui. Huan niquintiochihuas nochi familias ipan tlaltipactli ica ta huan moixhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Na niitztoc mohuaya. Nimitzmocuitlahuis campa hueli campa tiyas huan nijchihuas ximocuepa ipan ni tlali. Amo nimitztlahuelcahuas. Nijchihuas nochi catli mohuaya nimocajtoc nijchihuas.” ");
INSERT INTO nhwBl_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Huan quema Jacob isac, moilhui: “Nelía TOTECO itztoc ipan ni lugar huan amo nijmatiyaya.” ");
INSERT INTO nhwBl_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Huan Jacob majmajqui miyac huan moilhui: “¡Nica neltlatzejtzeloltic! ¡Nica eltoc ichaj Toteco! ¡Ni ipuerta ilhuicac!” ");
INSERT INTO nhwBl_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Huan hualmostla Jacob mejqui cualca huan quicuic nopa tetl catli quitequihuijtoya para itzonteto. Huan quiquetzqui quen se tlanextilijcayotl para nopona campa Toteco quicamanalhui. Huan nopa tetl quitequili aceite para quiiyocatlalis para Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Huan nechca nopona eltoya se altepetl catli itoca Tlahuili, pero Jacob quipatili itoca huan quitlalili Betel. (Betel quinequi quiijtos “ichaj Toteco”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Huan nopona Jacob quitestigojquetzqui Toteco Dios tlaque quichihuasquía huan quiijto: “Toteco, sintla ta nohuaya tiitztos huan techmocuitlahuis ipan ni noojhui catli nijchihua, huan sintla techtlamacas huan techmacas catli nimoquentis, huajca na nimitztequipanos. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Huan sintla amo nimococos huan nimocuepas ica cuali ipan ichaj notata, huajca san ta, TOTECO, nimitziximatis para noTeco. ");
INSERT INTO nhwBl_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Huan nica campa nijtlalijtoc ni tetl, elis mochaj, Toteco, campa nimitztencahuilis tlacajcahualistli. Huan nochipa nimitzmactilis se diezmo tlen nochi catli techmacas.” ");
INSERT INTO nhwBl_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob sempa quiitzqui iojhui huan yajqui ipan se tlali nechca campa hualquisa tonati. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Huan nopona ipan potrero quiitac se ameli huan nechca mosentiliyayaj borregojme ipan eyi pamitl pampa nopa tlapiyalme momatque atlij ipan nopa ameli. Huan quitzactoyaj nopa ameli ica se tetl catli nelhueyi. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Huan momajtoyaj nopa tlamocuitlahuiani ma mochiyase hasta quema ya mosentilijtose nochi nopa borregojme catli sesen inijuanti iaxcahua huan san sejco quiijcuiniyayaj nopa hueyi tetl. Teipa quinamacayayaj ininborregojhua huan teipa san sejco sempa quitzacuayayaj ica nopa hueyi tetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Huajca Jacob quintlatzintoquili nopa tlamocuitlahuiani: ―¿Canque amochaj, nohuampoyohua? Huan inijuanti tlananquilijque: ―Tihualahuij altepetl Harán. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Huajca quinilhui: ―¿Anquiiximatij Labán iixhui Nacor? Huan quiilhuijque: ―Quena, tiquiximatij. Huan Jacob quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","―¿San cuali itztoc? Huan nopa tlamocuitlahuiani quiijtojque: ―Quena, itztoc cuali. Xiquita, ne huala iichpoca, Raquel, ihuaya iborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Huajca Jacob quiijto: ―Noja cualca para anquintzacuase borregojme. ¿Para tlen amo anquinamacaj huan anquinhuicaj sempa ma tlacuajcuatij? ");
INSERT INTO nhwBl_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Pero nopa tlamocuitlahuiani quiijtojque: ―Amo hueli tijchihuaj. Monequi tijchiyase ma hualaca nochi borregojme huan tlamocuitlahuiani para sentic tiquijcuinise ni tetl catli ica quitzacuaj ni ameli para tiquinamacase toborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Huan quema Jacob noja camanaltiyaya ininhuaya, ajsico Raquel ihuaya iborregojhua itata pampa eltoya itequi para quinmocuitlahuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Huan nimantzi quema Jacob quiitac Raquel, iichpoca itío Labán, ica iborregojhua, yajqui huan iseltzi quiijcuini nopa tetl catli ica quitzactoyaj nopa ameli. Huan quinamacac iborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Teipa quitlajpalo huan quitzoponi huan pejqui choca chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Huan Jacob quipohuili para yaya eliyaya icone Rebeca catli iicni Labán. Huajca Raquel motlalojtiyajqui huan quipohuilito itata. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Huan quema Labán quicajqui catli Raquel quipohuili, para Jacob eliyaya icone isihua icni, motlalojtejqui para quiseliti. Huan quinajnahuajqui, huan quitzoponi huan quihuicac ichaj. Teipa Jacob quipohuili para tlen hualajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Huan Labán quiilhui: “Melahuac ta huan na san se toeso.” Huan Jacob mocajqui ihuaya Labán se metztli. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Teipa Labán quiilhui: ―Amo hueli techtequipanos san tlapic san pampa nimoteiximatca. Techilhui quesqui tijnequi ma nimitztlaxtlahui. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Huan Labán quinpiyayaya ome iichpocahua. Nopa achtihui ejquetl itoca Lea huan nopa teipan ejquetl, Raquel. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Huan iixteyolhua Lea amo quipiyayaya miyac fuerza, pero Raquel eliyaya senquistoc yejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Huan Jacob quiixtocayaya Raquel huan huajca quinanquili: ―Nimitztequipanos chicome xihuitl sintla techmacas Raquel para elis nosihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Huajca Labán tlananquili: ―Cualtitoc, más cuali nimitzmacas ta, huan amo se catli amo niquiximati. Huajca ximocahua nohuaya huan nimitzmacas. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Huan quej nopa Jacob tequitqui chicome xihuitl para Raquel, pero ya amo quimatqui sintla nelmiyac tonali pampa tlahuel quiicneliyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Huan quema tlanqui nopa chicome xihuitl, Jacob quiilhui Labán: ―Techmaca nosihua para ma nimosihuajti ihuaya pampa ya tlanqui nopa tonali catli ica nimocajqui mohuaya para nitequitis. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Huajca Labán quinnotzqui nochi catli itztoyaj nopona para ma hualaca ipan nopa ilhuitl tlen nenamictili. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Pero ica tlayohua Labán quicuic Lea huan quihuiquili Jacob. Quej nopa quimacac Lea para elis isihua huan Jacob cochqui ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Nojquiya Labán quimacac Lea se sihua tequipanojquetl catli itoca Zilpa para ma quipalehui. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Huan quema tlanesqui, Jacob momacac cuenta para cochtoya ihuaya Lea. Huajca yajqui quiilhuito Labán: ―¿Tlaque techchihuilijtoc? ¿Amo nimitztequipano para Raquel? Huajca ¿para tlen techcajcayajtoc? ");
INSERT INTO nhwBl_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Huan Labán quiilhui: ―Nica amo timomajtoque para monamictis nopa teipan ejquetl sintla ayamo monamictía nopa achtihui ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Xicaxiti se semana ihuaya Lea, huan teipa nojquiya timitzmacase Raquel sintla timotemacas titequitis nohuaya seyoc chicome xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Huan Jacob motemacac. Huan quema tlanqui se semana inenamictilis ihuaya Lea, Labán quimactili Raquel para isihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Labán nojquiya quimacac Raquel se sihua tequipanojquetl catli itoca Bilha para ma quipalehui. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Huan Jacob mosansejcotili ihuaya Raquel huan más quiicneli que Lea, masque monequiyaya quitequipanos Labán seyoc chicome xihuitl por ya. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Huan quema TOTECO quiitac para Jacob amo quiicneliyaya Lea, quichijqui ma conepiya, pero Raquel quichijqui ma amo conepiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Huan Lea conecuic huan quipixqui se icone catli quitocaxti Rubén. (Rubén quinequi quiijtos “quiitac notequipachol”.) Quej nopa quitocaxti pampa quiijto: “TOTECO quiitac quenicatza tlahuel nimotequipachohuayaya huan nechmacatoc se conetl, yeca ama nohuehue nechnequis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Teipa Lea quipixqui seyoc icone catli quitocaxti Simeón. (Simeón quinequi quiijtos “se catli tlacaqui”.) Quej nopa quitocaxti pampa Lea quiijto: “TOTECO quicactoc para amo nechicnelía huan yeca nechmacac seyoc nocone.” ");
INSERT INTO nhwBl_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Huan seyoc huelta Lea quipixqui seyoc icone huan quitocaxti Leví. (Leví quinequi quiijtos “motlatzquilijtoc”.) Quej nopa quitocaxti pampa quiijto: “Ama nohuehue itztos más nohuaya pampa ya nijmacatoc eyi oquichpilme.” ");
INSERT INTO nhwBl_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Huan Lea quipixqui seyoc icone catli quitocaxti Judá. (Judá quinequi quiijtos “nijpaquilismacas”.) Quej nopa quitocaxti pampa quiijto: “Ni huelta, quena, nijpaquilismacas TOTECO.” Teipa ayacmo conepixqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Quema Raquel quiitac para amo hueliyaya quimaca coneme Jacob, pejqui quicualancaita iachtihui ejca icni, Lea, huan quiilhui ihuehue: ―Techmaca coneme pampa sintla amo, nimiquis. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Pero Jacob cualanqui ihuaya huan quiilhui: ―¡Amo naya niDios! Yaya TOTECO catli amo mitzcahuilía xiconepiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Huajca Raquel quiilhui ihuehue: ―Huajca xijcui notequipanojca Bilha huan ximocahua ihuaya. Huan quema yaya quinpiyas coneme, elis quen na noconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Quej ni Raquel quimacac Jacob itequipanojca, Bilha, para ma quinpiya coneme ihuaya. Huan Jacob mosansejcotili ihuaya Bilha, ");
INSERT INTO nhwBl_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","huan ya quimacac Jacob se icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Huajca Raquel quiijto: “Toteco quichijtoc catli xitlahuac para na pampa quicajqui catli nijtlajtlani huan nechmacac se nocone. Yeca ni oquichpil itoca elis Dan.” (Dan quinequi quiijtos “yaya quichijtoc catli xitlahuac para na”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Teipa Bilha, itequipanojca Raquel, quimacac Jacob seyoc icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Huajca Raquel quiijto: “Nimohuilantoc ihuaya noachtihui ejca icni huan nijtlantoc. Yeca ni oquichpil itoca elis Neftalí.” (Neftalí quinequi quiijtos “notlahuilancayo”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Quema Lea quiitac para ayacmo hueliyaya conepiya, quimacac Jacob itequipanojca, Zilpa para ma conepiya ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Huan quema Zilpa quimacac se icone Jacob, ");
INSERT INTO nhwBl_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea quiijto: “¡Se suerte! Yeca nopa oquichpil itoca elis Gad.” (Gad quinequi quiijtos “suerte”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Teipa Zilpa quimacac Jacob seyoc icone, ");
INSERT INTO nhwBl_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","huan Lea quiijto: “¡Paquilistli! Ama sihuame quiijtose para nipaqui. Yeca nopa oquichpil itoca elis Aser.” (Aser quinequi quiijtos “paquilistli”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Se tonal Rubén yajqui mila quema eliyaya trigo pixquistli huan nopona quipanti se tlamantli xihui pajtli huan quihuiquili inana, Lea. Nopa xihui pajtli itoca eliyaya mandrágoras huan nochi quiijtohuayayaj para nopa xihuitl quichihua se tlacatl más ma quiicneli isihua. Huan quema Raquel quiitac nopa cuali xihui pajtli, quiilhui Lea: ―Techchihuili se favor, techmaca se ome nopa xihui pajtli catli mocone quihualicac. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Pero Lea quiilhui: ―¿Timoilhuía se quentzi tlamantli para techcuilijtoc nohuehue, huan nojquiya tijnequi techcuilis ni cuali xihui pajtli catli nocone nechhualiquili? Huan Raquel quiijto: ―Sintla techmacas se quentzi ixihui pajyo mocone, nijcahuilis Jacob ma cochi mohuaya ni tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Huajca ica tiotlac Lea quinamiquito Jacob quema hualayaya tlen imil huan quiilhui: ―Ama ticochis nohuaya pampa nimitzpatlatoc ica se cuali xihui pajtli catli nocone nechhualiquili. Huajca nopa tlayohua Jacob cochqui ihuaya Lea. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Huan Toteco Dios quitlacaquili catli Lea quitlajtlani, huan conecuic huan quimacac Jacob imacuilpa cone. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Huajca Lea quiijto: “Ni oquichpil itoca elis Isacar.” (Isacar quinequi quiijtos “se tlaxtlahuili”.) “Quej nopa nijtocaxtis pampa Toteco Dios nechmacatoc notlaxtlahuil pampa nijmacac nohuehue notequipanojca.” ");
INSERT INTO nhwBl_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Teipa Lea conecuic huan quimacac Jacob ichicuasempa cone, ");
INSERT INTO nhwBl_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","huan quiijto: “Dios nechmacatoc se cuali nemactli. Ama nohuehue nechtlepanitas pampa ya nijmacatoc chicuaseme oquichpilme. Yeca ni oquichpil itoca elis Zabulón.” (Zabulón quinequi quiijtos “tlatlepanitacayotl”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Teipa Lea quipixqui se sihuapil catli quitocaxti Dina. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Pero Toteco Dios nojquiya quielnamijqui Raquel. Quicajqui catli quitlajtlaniyaya huan quicahuili ma conepiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Huan Raquel conecuic huan quitlacatilti se oquichpil huan quiijto: “Toteco Dios nechquixtilijtoc nopa pinahualistli para amo hueli niconepiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ma TOTECO nechcahuili nijpiyas seyoc.” Yeca quitocaxti José. (José quinequi quiijtos “seyoc”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Teipa quema Raquel quitlacatiltijtoya José, Jacob quiilhui Labán: ―Techcahuili nimocuepas ipan notlal ");
INSERT INTO nhwBl_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","ininhuaya noconehua huan nosihuajhua pampa nimitztequipanojtoc por inijuanti. Huajca ama techcahuili ma niya. Cuali tijmati quen nimitztequipanojtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Pero Labán quinanquili: ―Sintla tinohuampox, ximocahua nohuaya pampa se tlajtol pannextijquetl catli quimati tlaita para TOTECO nechilhui yaya nechtiochijtoc por ta. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","San techilhui quesqui tijnequi tijtlanis huan nimitztlaxtlahuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Huajca Jacob quiilhui: ―Cuali tijmati quenicatza nimitztequipanojtoc huan quenicatza niquinmocuitlahuijtoc motlapiyalhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Nelquentzi tijpiyayaya quema ayamo nihualayaya huan ama tijpiya tlahuel miyac. TOTECO mitztiochijtoc campa hueli niitztoya, pero ¿hasta quema nipehuas nitequitis para nofamilia? ");
INSERT INTO nhwBl_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Huan Labán quiilhui: ―¿Quesqui tijnequi ma nimitztlaxtlahuis? Huan Jacob quinanquili: ―Amo tleno techtlaxtlahui. Noja niquinmocuitlahuis moborregojhua sintla tijselis catli nimitzilhuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ma tiyaca campa moborregojhua huan ama niquiniyocaquixtis nochi chivojme huan borregojme catli cuicuiltique huan pijpintojtique. Nochi chivojme catli amo senquistoc chocoxtique huan nochi borregojme catli amo senquistoc chipahuaque elise noaxcahua. Ya nopa elis notlaxtlahuil. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Quej nopa mostla huiptla, huelis tijtlachiliqui catli nijtlantoc huan nimantzi tijmatis sintla nijchihua catli cuali mohuaya o amo. Pampa sintla ipan notlapiyalhua oncas chivojme catli chocoxtique huan borregojme catli chipahuaque, huajca tijmatis ya nopa nimitzichtequilijtoc. Huan Labán quiijto: ");
INSERT INTO nhwBl_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","―Cualtitoc, quej nopa ma eli. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Huan ipan nopa tonal Labán quiniyocaquixti nochi pilborregojtzitzi catli cuicuiltique, huan nochi chivojme catli pintojtique o catli quipixtoya quentzi chipahuac, huan quinmacac iconehua Jacob para ma quinmocuitlahuica. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Teipa iconehua quinhuicaque huejca quen eyi tonali tlen ojtli ihuejcaca tlen ichaj Jacob. Huan Jacob noja mocajqui huan quinmocuitlahui iborregojhua Labán. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Huan Jacob quitzontejqui cuamacuayotl xoxohuic tlen nopa cuame álamo, almendro huan castaño, huan iyocatzitzi quixixinqui para ma nesi cuicuiltic, chipahuac huan chocoxtic. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Teipa nopa pitzajcuahuitl quitlali campa atliyayaj nopa tlapiyalme pampa nopona momatque momamaj. Huan ya nopa quichihuayaya para ininconehua ma tlacatica cuicuiltique, majmanchadojtique huan pijpintojtique. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Huan Jacob quiniyocaquixtiyaya nopa sihua borregojme catli senquistoc chipahuaque catli eliyaya iaxcahua Labán huan amo quincahuiliyaya ioquich borregojhua Labán catli chipahuaque ma quinnechcahuica para ma quinconemacaca. San quincahuiliyaya ma quinmamaltica oquich borregojme catli yayahuique catli ya iaxcahua para ma quinpiyaca ininconehua catli cuicuiltique huan yeca ininconehua elise iaxcahua ya. Quej nopa Jacob quisencajqui catli ya itlapiyalhua iyoca tlen itlapiyalhua Labán. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Nojquiya mojmostla quema nopa tlapiyalme catli tomahuaque huan tetique momamayayaj, Jacob quitlaliyaya nopa pitzajcuahuitl catli iyocatzitzi quixixintoya campa atliyayaj para ma quiitaca. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Pero quema hualayayaj tlapiyalme catli cocoxquetique, amo quitlaliyaya nopa pitzajcuahuitl. Yeca nopa tlapiyalme catli más cocoxquetique mocajque para Labán huan catli más tomahuaque para Jacob. ");
INSERT INTO nhwBl_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Quej nopa Jacob moricojchijqui huan quinpixqui tlahuel miyac borregojme. Nojquiya quinpixqui miyac tlaca tequipanohuani huan sihua tequipanohuani huan tlahuel miyac camellos huan burrojme. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Pero Jacob quimatqui para iconehua Labán quiijtojtinemiyayaj para yaya quicuitoya nochi catli iaxca inintata, Labán huan ica ya nopa Jacob moricojchijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Nojquiya momacac cuenta para Labán ayacmo quitlachiliyaya cuali quen achtihuiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Huajca TOTECO quiilhui Jacob: “Ximocuepa itlal motatahua campa itztoque moteiximatcahua huan na niyas mohuaya.” ");
INSERT INTO nhwBl_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Huajca Jacob tlatitlanqui ma quinnotzatij Raquel huan Lea para ma hualaca ipan nopa potrero campa yaya itztoya ihuaya iborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Huan Jacob quinilhui: ―Nimomaca cuenta para amotata ayacmo nechita san se quen achtihuiya, pero noTeco Dios catli notata quitequipanohua nochipa nohuaya nemi. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Cuali anquimatij nijtequipanojtoc amotata hasta campa nihueltoc, ");
INSERT INTO nhwBl_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","huan ya nechcajcayajtoc huan nechpatilijtoc notlaxtlahuil majtlactli hueltas. Pero masque ya nopa, Toteco Dios amo quicahuilijtoc ma nechcoco. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quema Labán quiijto nechtlaxtlahuis ica tlapiyalme catli manchadojtique, nochi tlacatiyayaj manchadojtique. Huan quema quiijto nechtlaxtlahuis ica catli cuicuiltique, nochi tlacatiyayaj cuicuiltique. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Quej nopa Toteco Dios quicuili itlapiyalhua para nechmacas. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Se tonal quema nopa tlapiyalme momamayayaj, nijpixqui se temictli. Huan ipan temictli niquitac para nochi oquich chivojme catli tlamamayayaj elque cuicuiltique, manchadojtique huan pijpintojtique. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ipan nopa temictli itequihua Toteco Dios nechnojnotzqui ica notoca huan nijnanquili: ‘Nica niitztoc.’ ");
INSERT INTO nhwBl_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Huajca yaya nechilhui: ‘Xijtlachili cuali huan tiquitas para nochi oquichme catli quinconemacaj nopa sihua borregojme itztoque cuicuiltique, manchadojtique huan pijpintojtique. Quen nopa eltoc pampa niquitztoc nochi catli amo xitlahuac mitzchihuilijtoc Labán. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Na nimoTeco catli nimonexti ipan Betel campa ta tijquetzqui nopa tetl quen se tlanextilijcayotl, huan techtlajtolcahuili catli techchihuilisquía. ¡Xiisihui huan xiquisa tlen nica huan ximocuepa ipan nopa tlali campa titlacatqui!’ Quen nopa Toteco nechilhui.” ");
INSERT INTO nhwBl_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Huajca Raquel huan Lea tlananquilijque: ―Tojuanti ayacmo tleno tijpiyaj ipan ichaj totata. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Techchihua quen amo techiximati. Technemacac huan nochi catli quiseli por tojuanti ya quitlamilti. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Nelía nochi ricojyotl catli Toteco Dios quiquixtilijtoc totata eltoc toaxca huan iniaxca toconehua. Huajca xijchihua nochi catli Toteco Dios mitznahuatijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Huajca Jacob mocualtlali para mocuepas ipan tlali Canaán campa itztoya itata, Isaac. Quinilhui iconehua huan isihuajhua ma tlejcoca ipan camellos. Huan quicuic nochi catli iniaxca huan quistejque ipan ojtli. Nojquiya quinhuicac nochi tlapiyalme catli quinselijtoya por itequi ipan tlali Aram. Quej nopa quisqui para mocuepas tlali Canaán campa itztoya itata, Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Huan Labán yajtoya huejca para quinximas iborregojhua huan Raquel quiichtequili itiotzitzi para quihuicas ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nojquiya Jacob quicajcayajqui Labán nopa Aram ejquetl pampa amo quiilhui sintla quisasquía. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","San cholojtejqui ica nochi catli iaxca, huan quipanoc nopa hueyatl Eufrates huan yajqui campa nopa tepeme ipan tlali Galaad. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Eyi tonali teipa, quiilhuijque Labán para Jacob cholojtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Huajca Labán ihuaya iteiximatcahua yajqui quintepotztocatiyajqui huan ica chicome tonali quinajsitoj ipan cuatitla ipan tlali Galaad. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Pero nopa tlayohua Toteco Dios monexti ica Labán nopa tlali Aram ejquetl, ipan se temictli huan quiilhui: “Ximotlachili para amo xijnojnotza Jacob ica cualantli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Huan Jacob quiquetztoya ichaj tlen yoyomitl campa tepeme ipan tlali Galaad huan nopona Labán quiajsito. Huan nojquiya nopona Labán quiquetzqui ichaj tlen yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Huan Labán quitlatzintoquili Jacob: ―¿Tlaque tijchijtoc? ¿Para tlen techcajcayajtoc? ¡Tiquinhualicatoc nica noichpocahua quen itztosquíaj ipan se tlahuilancayotl! ");
INSERT INTO nhwBl_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Para tlen techcajcayajtoc huan ticholojtejqui huan amo tleno techilhui? Sintla nijmajtosquía, na nimitzmacajtosquía ica paquilistli, huan ica tlapitzali, huan tambores huan arpa. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Niyon amo techcahuili ma niquintzoponi noichpocahua huan noixhuihua. ¡Tijchijqui se huihuiyotl! ");
INSERT INTO nhwBl_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Na nihueltosquía nimechchihuilijtosquía catli fiero, pero tlayohua nechnojnotzqui Toteco Dios catli motata quitequipanohua huan nechilhui ma nimotlachili para amo nimitznojnotzas ica cualantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Sintla nelía tiquistoc pampa tijnequi timocuepas ichaj motata, cualtitoc. Pero ¿para tlen techichtequili notiotzitzi? ");
INSERT INTO nhwBl_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Huajca Jacob quinanquili Labán: ―Nelía nimajmajqui. Nimoilhui para nohueli techquixtilisquía moichpocahua masque amo nijnequisquía. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Pero sintla se catli nica itztoc quipiya motiotzitzi, ¡ma miqui! Toteiximatcahua nica itztoque testigos. Huajca xijtemo sintla tijhualicaj se tlamantli catli moaxca huan sintla tijpantía, xijhuica. Pero Jacob amo quimatiyaya sintla Raquel quiichtectoya nopa itiotzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Huajca Labán calajqui ipan ichaj Jacob huan ipan ininchaj nopa ome sihua tequipanohuani. Teipa calajqui ipan ichaj Lea, pero amo quinpanti itiotzitzi. Huan quema quisayaya ipan ichaj Lea para calaquis ipan ichaj Raquel, ");
INSERT INTO nhwBl_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raquel quincuic nopa tiotzitzi huan quitlali iijtic catli ica quipejpechtía icamello huan ipan mosehui. Huan Labán quintemo nochi calijtic huan amo quinpanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Huan Raquel quiilhui: ―Papá, amo xicualani sintla amo nimotlanana moixtla pampa ama nijpiya nococolis catli totequijya tisihuame. Huan Labán quintemo itiotzitzi campa hueli, pero amo quinpanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Huan Jacob cualanqui huan quiajhuac Labán ica ni camanali: ―¿Tlaque amo cuali nijchijtoc? ¿Catlique notlajtlacol catli ica miyac cualantli techtepotztocatoc? ");
INSERT INTO nhwBl_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Tijtlajtlachilijtoc nochi tlamantli catli noaxca huan ¿tlaque tijpantijtoc tlen mochaj? ¡Xijtlali nica iixpa moteiximatcahua huan noteiximatcahua para ma quiijtoca ajqueya tlen tiome quiijtohua catli melahuac! ");
INSERT INTO nhwBl_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ica nopa 20 xihuitl catli nitequitqui mohuaya, amo quema moconetlahuisojque moborregojhua, niyon mochivojhua huan amo quema nijcuajqui niyon se. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Amo quema nimitzhualiquili tlapiyalme catli quinmictiyayaj tecuanime. San na nitlaxtlahuayaya por catli polihuiyaya. Sintla tonaya o tlayohua sequinoc nechtlachtequiliyayaj, ta techinamayaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tonaya nitonalmiquiyaya huan tlayohua nisecmiquiyaya huan nimocochsosolohuayaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Quen nopa eltoya para 20 xihuitl ipan mochaj. Para sesen moichpocahua nimitztequipano chicome xihuitl huan para motlapiyalhua nitequitqui chicuasen xihuitl. Huan majtlactli hueltas techpatili notlaxtlahuil. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Sintla amo itztosquía nohuaya noTeco Dios catli iTeco nohueyi tata Abraham huan notata Isaac, nelía techtitlanisquía san nomax. Pero Toteco Dios quiitac quenicatza nitequitqui hasta tlahuel nisiyajqui. Quiitac miyac nimotequipachohuayaya huan yeca tlayohua mitzajhuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Huajca Labán quinanquili Jacob: ―Ni ichpocame noichpocahua, ni ixhuime noixhuihua. Ni tlapiyalme notlapiyalhua. Nochi catli nica tiquita noaxca. Amo tleno amo cuali huelis niquinchihuilis noichpocahua o ininconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yeca xihuala huan ma tijchihuaca se camanal sencahuali catli elis quen se testigo catli techitase tiome para ma tijchihuaca nochi catli quiijtohua. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Huajca Jacob quicuic se tetl huan quiquetzqui quen se tlanextilijcayotl, ");
INSERT INTO nhwBl_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","huan quinilhui iteiximatcahua: ―¡Xijsentilica teme! Huan nochi quisentilijque teme huan quimontonojque huan nopona tlacuajque nechca nopa temontomitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Huan Labán quitocaxti nopa lugar Jegar Sahaduta ipan ya icamanal. (Jegar Sahaduta quinequi quiijtos “testigo”.) Huan Jacob quitocaxti Galaad ipan tlen ya icamanal. (Galaad ipan icamanal Jacob quinequi quiijtos “testigo”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Huajca Labán quiilhui: ―Ni temontomitl mocahuas quen testigo catli techitas tiome para ma tijtlamichihuaca catli tiquijtojque. Huan yeca teipa motocaxti Galaad nopona, ");
INSERT INTO nhwBl_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","huan nojquiya itoca elqui Mizpa. (Mizpa quinequi quiijtos “se torre catli tlachiya”.) Pampa Labán quiijto: ―Ma TOTECO techtlachili tiome quema ayacmo huelis timoitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Huan sintla tiquincualancaitas noichpocahua o timocuilis sequinoc sihuame, masque amo niaqui para niquitas, xijmati para san yaya Toteco Dios quitlachilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Huan Labán noja quiilhui Jacob: ―Xiquita, nica nijtlalijtoc ni temontomitl catli elis se tlanextilijcayotl tlatlajco tiome. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ni teme elise testigos para niyon ta, niyon na, amo quema tijpanose ni nepamitl para timoixpanose. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Toteco Dios catli iTeco mohueyi tata, Abraham, huan nohueyi tata, Nacor, ma quiijto ajqueya tlen tojuanti quichihua catli cuali. Huajca Jacob quitestigojquetzqui Toteco catli itata, Isaac, quihueyichihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Teipa nopona quimacac tlacajcahualistli Toteco huan quinnotzqui iteiximatcahua ma tlacuaquij. Huan nochi tlacuajque huan mocajque nopa tlayohua campa nopa tepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Hualmostla ica ijnaloc, Labán mejqui, huan quintzoponi iixhuihua, huan iichpocahua huan quintiochijqui. Teipa mocuepqui para itlal. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Huan quema Jacob quisqui huan nejnemiyaya ipan ojtli, sequin itequihuajcahua Toteco Dios quinamiquicoj. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Quema Jacob quinitac, quiijto: “Nica tonilijque Toteco Dios huan itequihuajcahua.” Yeca quitocaxti nopa lugar Mahanaim. (Mahanaim quinequi quiijtos “campa ompamitl tonilijque”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Huan Jacob quintitlanqui itlayolmelajcahua imelac hasta Seir ipan tlali Edom para quiitatij iicni, Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Huan Jacob quinilhui: “Xiquilhuitij Esaú para niitequipanojca niitztoya ihuaya Labán nochi ni xihuitl, ");
INSERT INTO nhwBl_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","huan para niquinpiya huacaxme, burrojme, borregojme huan chivojme. Nojquiya niquinpiya tequipanohuani tlacame huan sihuame. Xiquilhuitij nimechtitlani annotlayolmelajcahua para anquiitase para yaya ma quimati nihuala huan ma techselis ica cuali.” ");
INSERT INTO nhwBl_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Huan quema nopa tlayolmelahuani mocuepque, quiilhuijque Jacob: ―Tiyajque tiquitatoj moicni, Esaú huan ya huala para mitzseliqui ihuaya 400 tlacame. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Huan quema Jacob quicajqui ya nopa, majmajqui miyac huan pejqui tlahuel motequipachohua. Huajca quintlajcoxelo nopa tlacame catli itztoyaj ihuaya huan san se quichijqui ica nopa borregojme, huacaxme huan camellos, ");
INSERT INTO nhwBl_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","pampa moilhui: “Sintla Esaú huala ica imiyaca huan quinhuilanas se tlajco notequipanojcahua, huajca ne seyoc tlajco huelis cholose.” ");
INSERT INTO nhwBl_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Huan pejqui motlatlajtía ica TOTECO huan quiilhui: “Toteco Dios, ta catli tiiTeco nohueyi tata Abraham huan notata Isaac. Ta techilhui ma nimocuepa campa noteiximatcahua ipan notlal huan tijchihuasquía nochi ma quisa cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Amo quinamiqui techtlasojtlas huan techchihuilis catli timocajtoc para tijchihuas. Quema niquisqui notlal huan nijpanoc ni hueyatl Jordán, san nocuatopil nijpiyayaya, huan ama niquinpiya miyaqui noconehua hasta mochihuaj ome hueyi pamitl pampa hueyi techtiochijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Toteco Dios, ama se favor, techmanahui imaco noicni, Esaú. Niquimacasi para hualas nechmictis huan quinmictiqui ni sihuame huan coneme. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Pero ta tiquijtojtoc tijchihuas para nochi ma quisa cuali huan para noteipan ixhuihua elise nelmiyaqui quen xali nepa ipan hueyi atl catli amo hueli mopohua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Huan nopa tlayohua Jacob quitlapejpeni catli quipixtoya para quitlamajmacas iicni, Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Huan quiniyocatlali 200 sihua chivojme, 20 oquich chivojme, 200 sihua borregojme, 20 oquich borregojme, ");
INSERT INTO nhwBl_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","huan 30 sihua camellos ininhuaya ininconehua. Nojquiya quiniyocatlali 40 huacaxme, 10 torojme, 20 sihua burrojme huan 10 oquich burrojme. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Teipa quinmactili itequipanojcahua huan quinxejxelo sesen tlamantli tlapiyalme huan quinilhui: ―Xitlayacanaca huan amo xiquincahuilica ma mosansejcotilica sequinoc tlamantli tlapiyalme. Se pamitl tlen se tlamantli tlapiyalme ma tlayacana, huan teipa ica quentzi ma huala seyoc pamitl ica seyoc tlamantli tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Huan Jacob quinilhui itequipanojcahua catli tlayacanayayaj: ―Quema anquipantise noicni, Esaú, huan anmechtlatzintoquilis ajqueya amoteco huan canque anyohuij huan ajqueya iaxca nopa tlapiyalme catli anquinhuicaj, ");
INSERT INTO nhwBl_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","xijnanquilica: ‘Ni se nemactli para ta, toteco Esaú. Jacob, motequipanojca, mitztitlanilía huan ya huala totepotzco.’ ");
INSERT INTO nhwBl_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Nojquiya Jacob san se quiilhui itequipanojca catli teipa hualayaya ica más tlapiyalme huan nopa sequinoc catli inintepotzco hualayayaj. Quinilhui: ―Quema anquipantise Esaú, xiquilhuica san se. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Nojquiya xiquilhuica: ‘Motequipanojca, Jacob, huala totepotzco.’ Quej nopa quichijqui Jacob pampa moilhui: “Nijyoltlalis ica catli nijtitlani ma quihuiquilica, huan teipa nechitas na huan cuali nechselis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Huajca tlayacanque nopa tequipanohuani ica nopa tlapiyalme catli quimacayaya iicni. Huan nopa tlayohua Jacob mocajqui ipan ichaj tlen yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ipan nopa tlayohua Jacob mejqui huan quincuitejqui nopa ome isihuajhua, nopa ome isihua tequipanojcahua, huan nopa 11 iconehua, huan quinchihualti ma quiixcotonaca nopa pilatentzi Jaboc. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Huan quinchihualti itequipanojcahua ma quinpanoltica nochi tlapiyalme huan tlamantli catli iaxca ipan nopa seyoc nali. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Huan Jacob mocajqui iseltzi. Huan monexti se tlacatl catli mohuilanqui ihuaya hasta tlanesqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pero quema nopa tlacatl quiitac para amo hueliyaya quitlanis, quiitzqui Jacob campa imetzomiyo tlatzquía ipan itzinpan omiyo huan quilecueni. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Huan nopa tlacatl quiilhui: ―Techmajcahua pampa ya tlanesi. Huan Jacob quiilhui: ―Sintla amo techtiochihuas, amo nimitzmajcahuas. Huan nopa tlacatl quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","―¿Tlaque motoca? Huan ya quinanquili: ―Notoca Jacob. (Jacob quinequi quiijtos “tlacajcayajquetl”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Huajca nopa tlacatl quiilhui: ―Motoca ayacmo elis Jacob. Motoca elis Israel. (Israel quinequi quiijtos “se catli mohuilana ica Toteco”.) ―Quej nopa motoca pampa timohuilantoc ihuaya Toteco Dios huan ihuaya masehualme huan titlatlantoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Huajca Jacob quiilhui: ―Techilhui tlaque motoca ta. Pero nopa tlacatl quinanquili: ―¿Quenque techtlatzintoquilía notoca? Teipa nopa tlacatl quitiochijqui Jacob. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Huan Jacob quitocaxti nopa lugar Peniel. (Peniel quinequi quiijtos “ixayac Toteco”.) Quej nopa quitocaxti pampa quiijto: “Niquixtlachilijtoc Toteco Dios huan noja niitztoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Huan Jacob quistejqui Peniel quema quisqui tonati, pero metzxocuetiyaya pampa imetztomahuiya omiyo lecuentoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yeca hasta ama iteipan ixhuihua Israel amo quicuaj ilejleto imetztomahuiya se tlapiyali pampa nopona itequihua Toteco quimaquili Jacob. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Huan quema Jacob quiitac para Esaú hualayaya imelac ica 400 tlacame, quinxejxelo nopa coneme ihuaya Lea, Raquel huan nopa ome sihua tequipanohuani. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Quintlali ma tlayacanaca nopa sihua tequipanohuani ihuaya ininconehua. Teipa quitlali Lea ihuaya iconehua huan hasta teipa quintlali Raquel huan José. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob tlayacanqui huan mohuijtzonqui hasta tlalchi chicome huelta para quitlepanitas iicni quema monechcahuiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Pero Esaú motlalo quinamiquito. Huan quicuanajnahuajqui, huan quitzoponi, huan nochi ome chocaque. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Teipa Esaú quinitac nopa sihuame huan coneme catli hualayayaj huan tlatzintocac: ―Huan ¿ajqueyajuanti ni catli hualahuij mohuaya? Huan Jacob quinanquili: ―Ni catli Toteco Dios nechmacatoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Huajca nopa sihua tequipanohuani ihuaya ininconehua monechcahuijque huan mohuijtzonque. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Teipa monechcahuijque Lea huan iconehua huan san se quichijque. Huan más teipa ajsicoj José huan Raquel huan nojquiya mohuijtzonque. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Huan Esaú quiilhui Jacob: ―¿Tlaque timoilhuía tijchihuas ica nochi nopa tlapiyalme catli niquinpantijtihualajqui? Huan Jacob quiilhui: ―Nijnequi nimitzmacas ta, noicni, para ma techselis ica cuali. Huan Esaú quiijto: ");
INSERT INTO nhwBl_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","―Amo, noicni. Na ya niquinpiya miyac. Ximocahua ica catli moaxca. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Pero Jacob quiilhui: ―Amo, xijchihua se favor, xiquinseli pampa nimitzmaca. Para na nimitzita, eltoc quen niquita ixayac Toteco pampa techselijtoc ica cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Xijseli catli nimitzhualiquilijtoc pampa Toteco Dios tlahuel nechricojchijtoc huan nochi catli tiquita, noaxcahua. Huan pampa Jacob quinelchihualti ma quiseli, Esaú quiseli. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Teipa Esaú quiijto: ―Ma ya tiyaca huan san sejco tiajsise. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Pero Jacob quiilhui: ―Noicni, ta tijmati para coneme amo quipiyaj fuerza, niyon amo quipiyaj fuerza nopa piltlapiyaltzitzi. Sintla tiquintojtocase chicahuac san se tonal, siyahuise huan nochi miquise. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Más cuali para timotlayacanaltis huan na niyas ica yolic quen nejnemij ni tlapiyalme huan coneme hasta timosansejcotilise ipan tlali Seir. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Huan Esaú quiijto: ―¡Cualtitoc! Techcahuili ma nimitzcahuilijtehua se ome tlacame catli hualahuij nohuaya. Pero Jacob quiilhui: ―¡Amo! Amo ximocuatotoni. Catli ipati eltoc para tojuanti tiome ma tiitztoca ica cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Huan nopa tonal Esaú mocuepqui Seir. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Huan Jacob yajqui altepetl Sucot huan nopona quichijqui se cali huan quinchihuili pilxajcaltzitzi itlapiyalhua. Yeca quitocaxti nopa lugar Sucot. (Sucot quinequi quiijtos “pilxajcaltzitzi”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Teipa quema Jacob hualayaya tlen tlali Aram, ajsico ica cuali ipan tlali Canaán huan quiquetzque ininyoyoncalhua nechca altepetl Siquem. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Huan teipa ica 100 plata tomi quicojqui nopa tlali tlen iteiximatcahua Hamor catli elqui itata Siquem. ");
INSERT INTO nhwBl_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Huan nopona quichijqui se tlaixpamitl huan quitocaxti El Elohe Israel. (El Elohe Israel quinequi quiijtos “tlahuel hueyi Toteco Dios catli toTeco tiisraelitame”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Huan Dina, nopa ichpocatl catli Lea quimacac Jacob, yajqui quinpaxaloto nopa ichpocame catli nopona ehuaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Pero nopona itztoya se telpocatl catli itoca Siquem. Yaya eliyaya icone Hamor, se heveo tlacatl catli quinyacanqui nopa heveos nopona. Huan Siquem quifuerzajhui Dina ma moteca ihuaya huan quipinahualti. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Pero masque ya nopa quichihuili, nopa telpocatl nelía quiixtocac huan quiicneli huan quicamanalhui Dina ica nochi iyolo para nojquiya ma quiicneli. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Huajca mocamanalhui ihuaya itata, Hamor, huan quiilhui: ―Xiya xiquijtlaniti nopa ichpocatl. Nijnequi nimosihuajtis ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Huan Jacob quimatqui para Siquem quipinahualtijtoya iichpoca, pero itelpocahua noja itztoyaj potrero ica inintlapiyalhua huan yeca amo tleno quiijto hasta ajsique. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Huan ipan nopa tonali Hamor, itata Siquem, quicamanalhuito Jacob tlen Dina. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Huan quema itelpocahua Jacob mocuepque, huan quimatque catli panotoya, nelía cualanque pampa eliyaya se hueyi pinahualistli para nochi iteiximatcahua Jacob para se tlacatl san quen hueli motecasquía ihuaya iichpoca. ¡Elqui se tlamantli catli amo quema mochijtosquía ica israelitame! ");
INSERT INTO nhwBl_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Pero Hamor hualajqui quincamanalhuico Jacob huan itelpocahua huan quinilhui: ―Nocone Siquem nelía quiicnelía amosihua icni. Se favor, xijcahuilica ma mocuili. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Nojquiya ma timohuampoxchihuase huan quej nopa timosihuajtise ihuaya amoichpocahua, huan amojuanti ihuaya toichpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ximocahuaca ipan totlal. Xijtlapejpenica nopa tlali catli más anquinequise huan nopona xiitztoca. Nica huelis antlanemacase, antlacohuase huan anmoaxcatise tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Huan nopa telpocatl Siquem nojquiya quinilhui Jacob huan iicnihua Dina: ―Nimechtlajtlanía ma tiitztoca ica yejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Techilhuica quesqui tomi huan tlamantli anquinequij para nopa ichpocatl huan nimechmacas. Para na amo tleno sintla antechtlajtlanise catli patiyo. San nijnequi xijcahuilica nopa ichpocatl ma monamicti nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Pero pampa Siquem quipinahualtijtoya Dina, itelpocahua Jacob quinejque quincajcayahuase Siquem huan itata, Hamor, ");
INSERT INTO nhwBl_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","huan huajca quinilhuijque: ―Amo hueli tijnemacase toicni ica se tlacatl catli amo motzontequilijtoc iyecapa nopa cuetlaxtli ipan itlacayo pampa ya nopa elisquía se pinahualistli para tojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","San huelis tijselise se tlacatl sintla elis quen tojuanti. Huajca achtihui nochi tlacame tlen amotlal monequi ma motzontequilica inincuetlaxo para quipiyase nopa tlanextilijcayotl catli itoca circuncisión. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Huan huajca, quena, huelis anmosihuajtise ihuaya toichpocahua huan tojuanti ihuaya amoichpocahua. Huan tiitztose tlatlajco amojuanti huan tielise san se altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Pero sintla amo anquiselíaj catli timechtlajtlaníaj huan amo anmotequilíaj nopa tlanextilijcayotl, huajca tiquistehuase huan tijhuicase tosihua icni. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Huajca Hamor huan itelpoca quicualcajque nopa camanali. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Huan nimantzi yajqui nopa telpocatl huan motzontequili icuetlaxo pampa tlahuel quiixtocayaya iichpoca Jacob. Huan Siquem elqui catli más quipixqui tlatlepanitacayotl ica itata iteiximatcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Huajca ya huan itata, Hamor, yajque ipuertajteno nopa altepetl campa nochi momatque mosentilíaj huan quinilhuijque catli nopona ehuani: ");
INSERT INTO nhwBl_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","―Ni masehualme quinequij elise tohuampoyohua. Ma mocahuaca nica tohuaya huan tlanemacase pampa onca miyac tlali para inijuanti. Huelis timosihuajtise ihuaya iniichpocahua, huan inijuanti ihuaya toichpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Pero amo mocahuase para ma tielica san se altepetl sintla nochi tojuanti catli titlacame amo timotzontequilise iyecapa cuetlaxo ipan totlacayohua quen inijuanti momajtoque quichihuaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Pero sintla quena, teipa nochi catli quipiyaj huan nochi inintlapiyalhua elise toaxca. Huajca ma tijchihuaca catli quiijtohuaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Huan nochi tlacame ipan nopa altepetl catli ya quipixtoyaj xihuitl para elise soldados quicualcajque catli quiijtojque huan motzontequilijque nopa cuetlaxtli. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Pero ica ihuiptlatica quema nopa tlacame noja xoxocoxtoyaj pampa motectoyaj, Simeón huan Leví, nopa ome itelpocahua Jacob catli eltoyaj itlaca icnihua Dina, yajque campa nopa altepetl huan ica ininmachete quinmictijque nochi nopa tlacame pampa amo quiijiyohuijque catli quichijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Quimictijque Hamor ihuaya icone, Siquem, huan quiquixtijtejque Dina ipan ichaj Siquem huan quistejque. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Huan ajsicoj nopa sequinoc itelpocahua Jacob, huan panoque campa nopa mijcatzitzi huan quinichtequilijque nochi catli quipixtoyaj ipan nopa pilaltepetzi pampa quipinahualtijtoyaj iniicni. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Quinhuicaque nochi borregojme, huacaxme, burrojme huan nochi catli oncayaya ipan nopa altepetl huan ipan mila. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Quiichtejque nochi catli oncayaya ipan calme huan quinhuicaque nochi coneme huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Huajca quema Jacob quimatqui, quinilhui Simeón huan Leví: ―Anquichijtoque ma nimocahua fiero. Ama nopa cananeos huan nopa ferezeos catli itztoque ipan ni tlali nechcualancaitase, huan mosansejcotilise, huan techhuilanase huan techmictise na huan nochi noteiximatcahua pampa amo timiyaqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Pero itelpocahua Jacob quiilhuijque: ―Pero amo hueli quichihuilise toicni quen se ahuilnenca sihuatl huan amo tleno oncas. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Teipa Toteco Dios quiilhui Jacob: “Ximoquetza huan xiya xiitztoti Betel. Nopona xijchihua se tlaixpamitl para techhueyimatis pampa nopona nimonexti ica ta quema ticholohuayaya tlen moicni, Esaú.” ");
INSERT INTO nhwBl_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Huajca Jacob quiilhui ifamilia huan nochi catli ihuaya yohuiyayaj: ―Xijquixtica nochi tiotzitzi catli anquipiyaj, huan ximaltica huan xijpatlaca amoyoyo. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Teipa xihualaca, ma tiyaca Betel pampa nepa nijsencahuas se tlaixpamitl huan tijhueyichihuase Toteco Dios catli nechpalehui quema nimotequipachohuayaya. Yaya catli nohuaya yajtoc campa hueli campa ninentinentoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Huajca quimactilijque Jacob nochi inintiotzitzi huan nochi pijpiloli ica tiotzitzi catli quihuicayayaj ipan ininnacas, huan Jacob quintlalpacho itzintla se ahuatl catli eltoya nechca altepetl Siquem. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Huan quema quisque nopona, Toteco Dios quichijqui para nochi nopa pilaltepetzitzi catli nejnechca ma quinimacasica miyac, huan yeca amo quintepotztocaque. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Huan Jacob huan nochi masehualme catli ihuaya nejnemiyayaj ajsitoj ipan Luz catli nojquiya itoca Betel ipan tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Huan nopona quisencajqui se tlaixpamitl huan quitocaxti El Betel. (El Betel quinequi quiijtos “itlaixpa Toteco Dios catli nechnamijqui nica Betel”.) Pampa quema mochololtiyaya tlen iicni, Toteco Dios monextijtoya ihuaya nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nojquiya nopona mijqui Débora, nopa sihuatl catli quimocuitlahuijtoya Rebeca. Huan quitlalpachojque itzintla se ahua cuahuitl nechca Belén. Huan Jacob quitocaxti nopa cuahuitl Alónbacut. (Alónbacut quinequi quiijtos “ahuatl campa nochi chocaque”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Nojquiya Toteco Dios ya monextijtoya sempa ica Jacob quema mocuepayaya tlen tlali Aram huan quitiochijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Huan Toteco Dios quiilhuijtoya: “Ta motoca Jacob.” (Jacob quinequi quiijtos “tlacajcayajquetl”.) “Pero ayacmo mitztocaxtise Jacob. Ama motoca elis Israel.” (Israel quinequi quiijtos “se catli moquetza ica chicahualistli iixpa Toteco”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Huan nojquiya quema Toteco Dios quipatili itoca, Toteco quiilhui: “Na nimoTeco Catli Nijpiya Nochi Chicahualistli. Nijchihuas ma xiquinpiya miyac moconehua huan moteipan ixhuihua. Huan miyac masehualme quisase ipan moteipan ixhuihua, huan mochihuase miyac altepeme ipan inintlal. Ipan moteipan ixhuihua oncas tlanahuatiani huan sesen quinnahuatis imasehualhua ipan itlal. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nopa tlali catli nijmacac Abraham huan Isaac, mohuejcapan tatahua, nojquiya nimitzmacas ta huan teipa niquinmacas moteipan ixhuihua.” ");
INSERT INTO nhwBl_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Huan Toteco Dios quistejqui ipan nopa lugar campa quicamanalhui Jacob. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Huan Jacob quicuic se tetl huan quiquetzqui quen se tlanextilijcayotl para quielnamiquis campa camanaltitoya ihuaya Toteco. Huan quitequili aceite huan xocomeca atl nopa tetl para quiiyocatlalis para Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Huan quitocaxti nopa lugar Betel. (Betel quinequi quiijtos “ichaj Toteco Dios”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Teipa Jacob huan ifamilia quistejque tlen Betel. Huan quema noja huejca itztoyaj para ajsitij altepetl Efrata, Raquel ajsic hora para conepiyas huan nelía tlaijiyohuiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Huan ipan nopa hora catli más ohui, nopa sihuatl catli quipalehuiyaya para ma conepiya quiilhui: “Amo ximajmahui pampa tijtlacatiltijtoc seyoc oquichpil.” ");
INSERT INTO nhwBl_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Pero Raquel ya miquiyaya huan quema tlantinemiyaya iijiyo, quitocaxti ioquichpil Benoni. (Benoni quinequi quiijtos “oquichpil catli tlacatqui ica tlaohuijcayotl”.) Pero teipa itata quitocaxti nopa ipiloquichpil Benjamín. (Benjamín quinequi quiijtos “oquichpil catli más quipiya tequiticayotl”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Quej nopa Raquel mijqui huan quitlalpachojque ipan ojtli para altepetl Efrata catli ama itoca Belén. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Huan Jacob quiquetzqui se tetl campa quitoctoyaj Raquel huan nopa tetl hasta ama quejipa quinextía campa quitojque. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Huan Israel, catli achtihui itoca eliyaya Jacob, quistejqui ipan ojtli huan quiquetzato ichaj tlen yoyomitl ipan seyoc lado altepetl Migdal Edar. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Huan quema Israel mocahuayaya nopona, Rubén motecato ihuaya Bilha, se itequipanojca itata. Huan itata quimatqui huan tlahuel cualanqui. Huan Israel quinpixqui 12 itelpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Nopa coneme catli quinpixqui ihuaya Lea elque: Rubén iachtihui ejca, Simeón, Leví, Judá, Isacar huan Zabulón. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Catli quinpixqui ihuaya Raquel elque: José huan Benjamín. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Huan catli quinpixqui ihuaya Bilha catli eliyaya itequipanojca Raquel elque: Dan huan Neftalí. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Huan nopa coneme catli quinpixqui ihuaya Zilpa, catli eliyaya itequipanojca Lea, elque: Gad huan Aser. Ya ni nochi ioquichpilhua Jacob catli tlacatque ipan tlali Aram. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Huan Jacob ajsito ichaj campa itztoya itata, Isaac, ipan Mamre, nopa altepetl nechca Arba o Hebrón, campa huejcajya mochantijtoyaj Abraham huan Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Huan Isaac quipiyayaya 180 xihuitl quema mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Quena, quema eliyaya nelhuehuentzi, yajqui mosansejcotilito ihuaya ihuejcapan tatahua. Huan iconehua Esaú huan Jacob quitlalpachojque. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Huan ya ni iteipan ixhuihua Esaú catli nojquiya itoca Edom. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaú mosihuajti ininhuaya sihuame catli ehuaj tlali Canaán. Isihuajhua inintoca eltoya Ada, iichpoca Elón nopa heteo tlacatl, huan Aholibama, iichpoca Aná huan iixhui Zibeón nopa heveo tlacatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Huan nojquiya mosihuajti ihuaya Basemat, iichpoca Ismael, huan isihua icni Nebaiot. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Huan Ada quimacac Esaú se icone catli itoca Elifaz. Huan Basemat quitlacatilti Reuel, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","huan Aholibama quintlacatilti Jeús, Jaalam huan Coré. Ya ni iconehua Esaú catli tlacatque quema noja itztoya ipan tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Huan Esaú quincuitejqui isihuajhua, itlaca conehua huan isihua conehua huan itequipanojcahua huan yajqui ipan seyoc tlali para moiyocaquixtis tlen iicni, Jacob. Quinhuicac ihuaya nochi itlapiyalhua huan nochi tlamantzitzi catli quisansejcotilijtoya ipan Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Nelmiyac quipiyayayaj nochi ome icnime hasta ayacmo hueliyayaj itztoque san sejco. Nopa tlali catli ipan itztoyaj amo quinaxiliyaya para quintlamacase inintlapiyalhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Yeca Esaú catli nojquiya quitocaxtiyayaj Edom yajqui itztoti campa tepeyo ipan tlali Seir. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Nica eltoc inintoca iteipan ixhuihua Esaú catli quintocaxtijque edomitame. Inijuanti itztoyaj campa tepeyo ipan nopa tlali catli itoca Seir. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Inintoca iconehua Esaú elque Elifaz huan Reuel. Elifaz elqui icone isihua, Ada, huan Reuel elqui icone isihua, Basemat. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Iconehua Elifaz elque Temán, Omar, Zefo, Gatam huan Senaz. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Elifaz quipixqui se isihua tequipanojca catli itoca Timna catli quimacac se icone catli quitocaxti Amalec. Huan iconehua Elifaz elque iixhuihua Esaú huan isihua, Ada. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Huan iconehua Reuel elque: Nahat, Zera, Sama huan Miza. Inijuanti elque iixhuihua Basemat nopa seyoc isihua Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Huan Esaú quinpixqui iconehua ica isihua catli itoca eliyaya Aholibama catli elqui iichpoca Aná huan iixhui Zibeón. Inintoca ininconehua elque: Jeús, Jaalam huan Coré. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ama nimitzilhuis nopa tlayacanani ipan iteipan ixhuihua Esaú. Ipan iconehua Elifaz, iachtihui ejca Esaú, elque: Tlayacanani Temar, Omar, Zefo, Cenaz, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam huan Amalec. Nochi ya ni elque tlayacanani ipan iteipan ixhuihua Elifaz ipan tlali Edom. Huan nochi inijuanti elque iteipan ixhuihua Ada, isihua Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Huan iconehua Reuel, icone Esaú, elque: Tlayacanani Nahat, Zera, Sama huan Miza. Inijuanti tlayacanque ipan iconehua Reuel ipan tlali Edom huan elque iixhuihua Basemat, isihua Esaú. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iconehua Esaú ica isihua Aholibama, iichpoca Aná, elque: Tlayacanani Jeús, Jaalam huan Coré. Inijuanti quinyacanque iniixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Nochi inijuanti elque nopa tlayacanani ipan iteipan ixhuihua Esaú o Edom. Huan sesen inijuanti mochijqui se hueyi familia ica miyac masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Iconehua Seir, nopa horeo tlacatl catli itztoyaj ipan nopa tlali, elque: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Disón, Ezer huan Disán. Ya ni elque tlayacanani tlen horeos catli elque iixhuihua Seir ipan tlali Edom. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Iconehua Lotán elque: Hori huan Hemam. Huan Timna elqui isihua icni Lotán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Iconehua Sobal elque: Alván, Manahat, Ebal, Sefo huan Onam. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Iconehua Zibeón elque: Aja huan Aná. Aná elqui catli quipanti campa meya atl totonic ipan nopa huactoc tlali quema quinmocuitlahuiyaya iburrojhua itata. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Iconehua Aná elque: Disón huan se isihuapil catli itoca Aholibama. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Iconehua Disón elque: Hemdán, Esbán, Itrán huan Querán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Iconehua Ezer elque: Bilhán, Zaaván huan Acán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Iconehua Disán elque: Uz huan Arán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Nopa tlayacanani tlen horeos elque: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer huan Disán. Ya ni elque inintlayacancahua nopa horeos ipan sesen pilaltepetzitzi ipan tlali Seir. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Nica quiijtohua inintoca nopa huejhueyi tlanahuatiani catli tlanahuatijque ipan tlali Edom achtihuiya quema israelitame ayamo quipiyayayaj se tlanahuatijquetl: ");
INSERT INTO nhwBl_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, icone Beor, elqui tlanahuatijquetl ipan Edom huan ialtepe itoca eliyaya Dinaba. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Quema Bela mijqui, pejqui tlanahuatía Jobab, icone Zera, catli hualayaya pilaltepetzi Bosra. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Quema Jobab mijqui, tlanahuati Husam catli hualajqui altepetl Temán. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Quema Husam mijqui, pejqui tlanahuatía Hadad, icone Bedad, catli quintlanqui nopa tlali Madián ehuani quema quinamiquicoj ipan tlali Moab. Yaya hualajqui altepetl Avit. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Quema mijqui Hadad, pejqui tlanahuatía Samla catli hualayaya Masreca. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Quema Samla mijqui, pejqui tlanahuatía Saúl catli hualayaya Rehobot, nopa pilaltepetzi catli eltoc nechca ateno. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Quema Saúl mijqui, tlanahuati Baal Hanán catli eliyaya icone Acbor. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Huan quema mijqui Baal Hanán, tlanahuati Hadad. Ialtepe Hanán itoca eliyaya Pau huan Mehetabel catli eliyaya iichpoca Matred huan iixhui Mezaab elqui isihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Nica eltoc inintoca itlayacanca teipan ixhuihua Esaú huan sesen inijuanti quiyacanque ihueyi familia huan campa sesen tlayacanque ipan nopa altepetl catli quihuicac inintoca. Inintoca eltoc: Timna, Alva, Jetet, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO nhwBl_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel huan Iram. Nochi ni tlacame tlayacanque ipan tlali Edom catli quihuicac itoca ininhuejcapan tata, Esaú. Huan sese altepetl catli iniaxcahua quihuicac itoca itlayacanca ixhui catli tlayacanqui nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob mocajqui para itztos ipan tlali Canaán campa itztoya itata quema ayamo miquiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Huan ya ni catli panoc ica Jacob 37:2 O Israel. huan iconehua. Quema José, icone Israel, eliyaya se telpocatl catli quipiyayaya 16 xihuitl, quinmocuitlahuiyaya borregojme ininhuaya itepotz icnihua catli eliyayaj ininconehua Bilha huan Zilpa, ne sequinoc isihuajhua itata. Huan teipa José quiilhuico itata nochi catli amo cuali quichihuayayaj iicnihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Huan Israel más quiicneli José que ne sequinoc itelpocahua pampa tlacatqui quema eliyaya nelhuehuentzi. Huan yeca quichihuili se iyoyo catli huehueyac huan tlahuel yejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Pero quema iicnihua quiitaque para inintata más quiicneliyaya José que inijuanti, pejque quicualancaitaj huan niyon quentzi amo quinequiyayaj quiitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Se tonal José quipixqui se temictli huan quinpohuili iicnihua, pero ya nopa quichijqui más ma quicualancaitaca. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Huan ya ni catli quinilhui: ―Xijtlacaquilica huan nimechpohuilis nopa temictli catli nijpixqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nijtemijqui para nochi tojuanti tiitztoyaj mila, tijsentiliyayaj tlamontomitl tlen trigo tzontli. Huan nimantzi catli na nijsentilijtoya motlananqui huan moquetzqui xitlahuac huan catli anquisentilijtoyaj nechyahualojque huan quen motlancuaquetzque para nechtlepanitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Huajca iicnihua quiilhuijque: ―¿Tijnequi tiquijtos para tielis tihueyi tlanahuatijquetl huan technahuatis? Huajca más quicualancaitaque por itemic huan quen quinpohuilijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Teipa José quipixqui seyoc temictli huan nojquiya quinpohuili iicnihua. Quinilhui: ―Xijtlacaquilica, nijpixqui seyoc temictli huan niquitayaya para tonati huan metztli huan 11 sitlalime nechhueyitlepanitayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Huan José nojquiya quipohuili ni temictli itata huan iicnihua; huan itata quiajhuac huan quiilhui: ―¿Tlaque tiquijtosnequi ica ni temictli catli tijpixqui? ¿Timoilhuía para monana, moicnihua huan na monequis timitzhueyitlepanitase? ");
INSERT INTO nhwBl_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Huan iicnihua quicualancaitaque, pero itata miyac moilhuiyaya tlen ni tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Se tonal iicnihua José quinhuicaque iborregojhua inintata para quitemojtiyase sacatl huan ajsitoj nechca altepetl Siquem. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Huan ipan ichaj inintata quiilhui José: ―Xiquita, moicnihua quintlacuajcualtíaj noborregojhua nechca Siquem. Nijnequi xiya xiquinitati. Huan José quinanquili: ―¡Cualtitoc! ");
INSERT INTO nhwBl_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Huajca itata quiilhui: ―Xiquitati quenicatza itztoque moicnihua huan nopa borregojme. Huan teipa xihuala techyolmelahuaqui. Huajca quen nopa, Israel quititlanqui José ma yohui campa nopa tlamayamitl nechca Hebrón. Huan quema José ajsito Siquem, ");
INSERT INTO nhwBl_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","quintemohuayaya iicnihua campa hueli. Huan quipanti se tlacatl huan quitlatzintoquili: ―¿Tlaque tijtemojtinemi? ");
INSERT INTO nhwBl_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Huan José tlananquili: ―Na niquintemojtinemi noicnihua. ¿Huelis techilhuis canque quinmocuitlahuíaj ininborregojhua? ");
INSERT INTO nhwBl_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Huan nopa tlacatl quiijto: ―Ya mijcuinijtejque nica. Nijcajqui quiijtohuaj para yohuij Dotán. Huajca José quintemojtiyajqui huan quinpanti ipan Dotán. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Huan inijuanti quihuejcaitaque, huan quema ayamo onajsiyaya, quisencajque quenicatza quimictise. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Quiijtojque: ―¡Xiquitaca ne huala catli tlatemiqui! ");
INSERT INTO nhwBl_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Xihualaca, ma tijmictica huan tijcalaquise ipan se tlen ni ostome campa achtihui eltoya atl huan tiquijtose para se tecuani quicuajqui. Huan tiquitase tlaque panos ica itemic. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Pero quema Rubén quicajqui ni tlamantli, quinejqui quimanahuis José tlen ne sequinoc iicnihua. Huajca quiijto: ―Ma amo tijmictica, ");
INSERT INTO nhwBl_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","huan tijtoyahuase estli. San ma tijmajcahuase ipan ne ostotl catli eltoc ipan ni huactoc tlali, pero amo tleno tijchihuilise. Rubén quiijto ya ni pampa quinequiyaya para teipa quimanahuisquía José huan quihuicasquía campa itata. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Pero quema José ajsito campa itztoyaj iicnihua, inijuanti quiquixtilijque iyoyo catli nelyejyectzi catli moquentijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Huan quiitzquijque huan quimajcajque ipan nopa ostotl catli amo quipiyayaya atl pampa huactoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Teipa quema mosehuijque para tlacuase, quinitaque sequin ismaelitame catli hualayayaj Galaad ica inincamellos catli quimamayayaj tlacualpajtli huan tlaajhuiyacayotl tlen bálsamo huan mirra, huan yohuiyayaj para tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Huajca Judá quinilhui iicnihua: ―¿Tlaque tijtlanise sintla tijmictise toicni huan tijtlatise imiquilis? ");
INSERT INTO nhwBl_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Más cuali ma tiquinnemaquiltica ne ismaelitame huan ma amo tijmictica pampa yaya toicni. Huan iicnihua quicualcajque catli quinilhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Huajca teipa quema nopa tlanemacani catli tlali Madián ehuani panoque nopona, iicnihua José quiquixtijque ipan ostotl huan quinnemaquiltijque ica 20 plata tomi. Huan nopa tlanemacani catli eliyaya iteipan ixhuihua Ismael quihuicaque para tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Huan teipa Rubén mocuepqui campa ameli huan amo quipanti José osto ijtic, huajca quitzayanqui iyoyo pampa neltlahuel motequipachohuayaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Teipa mocuepqui campa itztoyaj iicnihua huan quinilhui: ―¡Nopa telpocatl ayacmo aqui! ¿Tlaque huelis nijchihuas? ");
INSERT INTO nhwBl_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Huan nopa icnime quicuique iyoyo José huan quipolojque ieso se chivo catli quimictijque, ");
INSERT INTO nhwBl_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","huan quihuiquilijque inintata huan quiilhuijque: “Tijpantijque ni yoyomitl. Xiquita sintla iyoyo mocone o amo.” ");
INSERT INTO nhwBl_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Huan quema Jacob quiiximatqui, quiijto: “¡Quena, yaya nopa iyoyo nocone! Se tecuani quicocototzqui huan quicuajqui.” ");
INSERT INTO nhwBl_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Huajca Jacob quitzayanqui iyoyo huan moyoyonti ica yoyomitl tlen tequipacholi huan chocac para miyac tonali pampa mijqui icone. ");
INSERT INTO nhwBl_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Huan nochi iconehua quicajcahualtiyayaj para quiyoltlalise, pero amo huelqui moyoltlalía. Tlahuel chocayaya por icone huan quiijtohuayaya: “Nimotequipachos por nocone hasta quema nimiquis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Huan ipan tlali Egipto nopa madianitame tlacame quinemacaque José ica se tlacatl catli itoca Potifar catli quipixtoya se hueyi tequitl ihuaya nopa hueyi tlanahuatijquetl Faraón nopona. Yaya elqui tlayacanquetl tlen nopa tlacame catli quimocuitlahuiyaya inemilis Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ipan nopa tonali Judá moiyocaquixti tlen iicnihua huan yajqui itztoti ipan pilaltepetzi Adulam huan mocajqui ichaj se tlacatl catli itoca Hira. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nopona quiiximatqui iichpoca se cananeo tlacatl catli itoca Súa huan mosihuajti ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Huan conecuic huan quipixqui se icone catli quitocaxti Er. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Sempa conecuic huan quipixqui seyoc icone catli quitocaxti Onán. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Huan noja quipixqui seyoc icone catli quitocaxti Sela catli tlacatqui quema inijuanti itztoyaj ipan altepetl Quezib. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Judá quisihuajti Er, iachtihui ejca, ica se sihuatl catli itoca Tamar. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Pero TOTECO amo quipactiyaya inemilis Er pampa eliyaya nelfiero, yeca quimicti. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Huajca Judá quiilhui itelpoca Onán: ―Ximosansejcotili ihuaya icahual moicni quen mitztocarohua tijchihuas pampa tiihuejpol huan xijpiya se conetl para quiselis catli eliyaya iaxca moicni. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Pero Onán quimatiyaya sintla tlacatisquía se conetl nochi masehualme quiitasquíaj para icone iicni huan amo ya icone. Yeca quema quinechcahuiyaya ihuejpol, quitoyahuayaya ixinajcho tlalchi para ma amo conecui pampa amo quinejqui quimacas iicni catli mijqui iteipan ixhuihua quen monejqui quichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Huan TOTECO quiitac para fiero catli quichijqui Onán pampa amo quichijqui catli monejqui. Yeca Toteco nojquiya quimicti. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Huajca Judá quiilhui iyex Tamar: ―Ximocahua ticahuali huan xiitztoti ichaj motata hasta moscaltis nocone Sela. Pero amo ya nopa catli Judá moilhuiyaya. Yaya majmahuiyaya para Sela mocuilis Tamar pampa moilhui huelis miquisquía quen iicnihua mijque sintla itztos ihuaya. Huan Tamar yajqui itztoti ichaj itata quen quinahuati. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Huan panoc miyac xihuitl huan nojquiya mijqui isihua Judá catli elqui iichpoca Súa. Huan teipa quema Judá ayacmo motequipachoyaya, yajqui pilaltepetzi Timnat campa itequipanojcahua quinximayayaj iborregojhua. Nojquiya ihuaya yajqui ihuampox, Hira, catli ejqui altepetl Adulam. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Huan Tamar quimatqui para iyextaj yohuiyaya Timnat quinximati iborregojhua, ");
INSERT INTO nhwBl_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","huajca moquixtili iyoyo quen catli moquentíaj cahual sihuame huan moixtzajqui ica se yoyomitl quen quichihuaj ahuilnenca sihuame huan mosehui iteno pilaltepetzi Enaim catli eltoc ipan ojtli para Timnat. Quichijqui ya ni pampa quiitac Sela ya motlacachijtoya huan Judá amo quisihuajtijtoya ihuaya. Huajca noja ayamo quipiyayaya se conetl quen monejqui para quihuicas ieso huan itoca ihuehue catli mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Huan Judá quiitac ipan ojtli huan moilhui para eliyaya se ahuilnenca sihuatl pampa moixtzactoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Huajca quicajqui iojhui para quinechcahuis, niyon amo quimatqui para eliyaya iyex huan quiilhui: ―Techcahuili ma nimoteca mohuaya. Huan yaya quinanquili: ―¿Tlaque techmacas sintla nimotecas mohuaya? Huan Judá quinanquili: ");
INSERT INTO nhwBl_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","―Nimitztitlanilis se pilchivojtzi. Huan ya quiijto: ―Cualtitoc, pero techcahuilijtehua catli moaxca hasta techtitlanilis. Huan Judá quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","―¿Tlaque tijnequi ma nimitzcahuilijtehua? Huan Tamar quiijto: ―Techmaca mosello ihuaya imecayo huan mocuatopil catli tijpiya momaco. Huan Judá quimacac huan motejqui ihuaya, huan yaya quiconemacac. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Teipa Tamar moquixtilito catli ica moixtzactoya huan sempa motlalili iyoyo quen catli cahual sihuame moquentíaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Teipa Judá quititlanqui nopa pilchivojtzi ica ihuampox catli ejqui altepetl Adulam para quiilhuiti nopa sihuatl ma quicuepili catli iaxca. Pero ihuampox ayacmo quipanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Huajca quintlatzintoquili catli nopona ehuaj: ―¿Canque itztoc nopa ahuilnenca sihuatl catli ehua Enaim catli itztoya ojteno? Huan quinanquilijque: ―Nica amo aqui niyon se ahuilnenca sihuatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Huajca ihuampox mocuepqui campa Judá huan quiilhui: ―Amo nijpanti nopa sihuatl. Huan nopa masehualme catli nopona ehuaj nechilhuijque para amo aqui niyon se ahuilnenca sihuatl nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Huan Judá quiilhui: ―Techhuihuiitase sintla sempa tiyas tijtemoti. Nijchijqui catli niquijto huan nijtitlanqui nopa pilchivojtzi huan amo tijpanti. Huajca ma mocahui nopa sihuatl catli nijmacac. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Huan quema panotoya eyi metztli, se hualajqui campa Judá huan quiilhui: ―Huelis moyex Tamar tlacanentoc pampa quinemiltía se conetl ipan itlacayo. Huan Judá quiilhui: ―¡Xijquixtica tlen nopa altepetl huan xijtlatica! ");
INSERT INTO nhwBl_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Pero quema quiquixtiyayaj, Tamar tlatitlanqui ma quiilhuitij iyextaj: “Nechconemacac yaya catli iaxca ni tlamantli. Xiquita cuali ajqueya iaxca ni sello, ihuaya imecayo huan ni cuatopili.” ");
INSERT INTO nhwBl_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Huan Judá quiiximatqui nopa tlamantli huan quiijto: “Yaya quichijtoc catli cuali huan na, amo. Yaya quinejqui se conetl para quihuicas itoca ihuehue catli mijqui huan amo nijnamicti ihuaya nocone Sela quen monequiyaya.” Huan Judá ayacmo quema motejqui ihuaya Tamar. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Huan quema ajsic tonal para conepiyas, quinpixqui cuateme. ");
INSERT INTO nhwBl_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Huan ipan nopa tlatoctzi quema tlacatiyayaj, se tlen inijuanti quiquixti imax, huan nopa cocoxcaitaquetl quiilpi se icpatl chichiltic huan quiijto: “Ya ni quisqui achtihui.” ");
INSERT INTO nhwBl_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Pero teipa nopa pilconetzi quicalaqui imax huan iicni nelía tlacatqui achtihui. Yeca nopa cocoxcaitaquetl quitocaxti nopa conetl Fares. (Fares quinequi quiijtos “catli moojtlapojtoc”.) Quej nopa quitocaxti pampa quiijto: “Yaya moojtlapo para quisqui achtihui.” ");
INSERT INTO nhwBl_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Huan teipa tlacatqui nopa seyoc oquichpil catli quipiyayaya nopa icpatl chichiltic imaco huan quitocaxti Zara. (Zara quinequi quiijtos “chichiltic”.) ");
INSERT INTO nhwBl_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Huan nopa ismaelita tlanemacani quihuicaque José hasta tlali Egipto. Nopona quicojqui se tlacatl itoca Potifar catli quipixtoya se hueyi tequitl ica Tlanahuatijquetl Faraón. Elqui inintlayacanca nopa tlacame catli quimocuitlahuiyaya inemilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Pero TOTECO itztoya ihuaya José huan quichijqui para nochi ma quisa cuali catli José quichijqui ipan ichaj iteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Huan iteco momacac cuenta para TOTECO itztoya ihuaya José huan quitiochihuayaya huan nochi catli quichijqui quisqui cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Huan iteco quiicneli huan quitlali ma eli catli más quipalehui. Nojquiya quichijqui ma quinnahuati nochi tequipanohuani ipan ichaj huan quitlali imaco nochi catli quipixqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Huan tlen nopa tonali quema Potifar quicajqui imaco José ichaj huan nochi catli quipixqui, TOTECO pejqui más quitiochihua Potifar, huan iteiximatcahua huan nochi catli quipixqui ipan ichaj huan ipan mila. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Huan Potifar ayacmo mocuatotoniyayaya ica tleno, san para tlacuas pampa motemachi ipan José. Huan nochi eltoya imaco huan nochi quisayaya cuali. Huan José eliyaya yejyectzi huan nesiyaya se cuali telpocatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Huan quema panoc tonali, isihua iteco pejqui quiixtoca. Huan se tonal quiilhui: ―Ximoteca nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Pero José amo quinejqui huan quiilhui: ―Xiquita, mohuehue quicajtoc nomaco nochi catli quipiya huan quimati sintla nica niitztoc, amo quipiya tleno para ica mocuatotonis. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ipan ni cali amo aqui más tlayacana que na. Noteco nechmacatoc nomaco nochi para nijchihuas catli na niquitas para cuali. San ica ta amo nijpiya tlanahuatili pampa tiisihua. Huajca, ¿quenicatza huelis nitlajtlacolchihuas ica Toteco Dios huan mohuaya nijchihuas se tlamantli catli tlahuel fiero? ");
INSERT INTO nhwBl_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Huan masque nopa sihuatl mojmostla quinotzayaya José ma moteca ihuaya, José amo quichijqui, niyon amo quinechcahui campa itztoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Pero se tonal José monejqui calaquis ichaj iteco para quichihuas itequi huan amo aquiyaya niyon se más tequipanojquetl nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Huan nopa sihuatl quiitzqui ipan iyoyo huan quiilhui: ―Ximoteca nohuaya. Pero José motlalojtejqui huan quicajtejqui iyoyo ipan imax. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Huan quema nopa sihuatl momacac cuenta para quicahuilijtejqui iyoyo imaco, ");
INSERT INTO nhwBl_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tzajtzic chicahuac, huan quinnotzqui itequipanojcahua huan quinilhui: ―Xiquitaca, nopa hebreo tlacatl catli nohuehue techhualiquili san techpinahualtía. Calajqui nica para nechfuerzajhuis ma nimoteca ihuaya, pero na nitzajtzic chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Huan quema nechcajqui para nitzajtzic ica nochi nochicahualis, motlalojtejqui hasta quicajtejqui iyoyo nica. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Teipa nopa sihuatl quiajojqui José iyoyo hasta ajsico ihuehue. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Huan quipohuili quen quinpohuilijtoya nopa tequipanohuani huan quiilhui: ―Nopa hebreo catli tijcojqui huan techhualiquili calajqui ipan nocuarto huan quinequiyaya ma nimoteca ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Pero quema nitzajtzic chicahuac, motlalojtiquisqui huan quicajtejqui iyoyo nica. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Quej nopa nechchijqui motequipanojca catli tijcojqui. Huan iteco José cualanqui miyac quema quicajqui catli isihua quipohuiliyaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Huan quiitzqui José huan tlanahuati ma quicalaquica ipan tlatzactli campa mocahuayayaj nochi tlacame catli nopa hueyi tlanahuatijquetl quintzactoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Pero TOTECO noja itztoya ihuaya José huan quinextili quenicatza quiicnelía pampa quichijqui para nopa tlayacanca tetzajquetl ma quicualita. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Huan nopa tlayacanca tetzajquetl quincajqui imaco José nochi sequinoc catli tzactoque. Huan José tlanahuatiyaya nochi catli nopona mochihuayaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Huan nopa tlayacanquetl amo monequiyaya mocuatotonis ica tleno catli eltoya imaco José pampa TOTECO itztoya ihuaya huan quichihuayaya para nochi ma quisa cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Panoc miyac tonali huan yaya catli itequi para quiyecos nochi itlailis nopa tlanahuatijquetl tlen Egipto para quiitas sintla quipixqui ipajyo quichijqui catli amo quipacti iteco. Huan nojquiya tlaixpanoc itlayacanca panchijca nopa tlanahuatijquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Huajca Faraón cualanqui ininhuaya ni ome itequipanojcahua, ");
INSERT INTO nhwBl_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","huan quintitlanqui ipan tlatzactli catli eltoya ipan ichaj inintlayacanca nopa tlacame catli quimocuitlahui. Huan eltoya san sejco campa José tzactoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Huan nopa tlayacanca tetzajquetl quiilhui José ma quinmocuitlahui. Huan panoque miyac tonali ipan tlatzactli san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Huan se tlayohua yaya catli quiyeco itlailis Faraón huan ne se catli quichijqui ipantzi quipixque sesen temictli. Huan sesen temictli quiijtosnequiyaya sesen tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Huan ica ijnaloc José quinpantico moneltequipachohuayayaj, ");
INSERT INTO nhwBl_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","huan quinilhui: ―¿Quenque anmotequipachohuaj? ");
INSERT INTO nhwBl_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Huan quiilhuijque: ―Tijpixque sesen temictli huan amo tijpiyaj ajqueya techpohuilis tlaque quiijtosnequi. Huan José quinilhui: ―Yaya Toteco Dios catli temachiltía tlaque quiijtosnequi se tlamantli. Huajca techpohuilica tlaque anquitemijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Huajca nopa tlacatl catli itequi para quiyecos itlailis Faraón quiilhui: ―Ipan notemic niquitayaya se xocomeca tzontli, ");
INSERT INTO nhwBl_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","catli quipixqui eyi imacuayo. Huan nopa xocomeca cuahuitl chamanqui, huan cahuanqui ixochiyo, huan temacac itlajca. Huan teipa itlajca icsic. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Huan nijpiyayaya nomaco icaxi Faraón. Huan nijcuiyaya nopa xocomecatl itlajca huan nijpatzcayaya ipan icaxi. Teipa nijtlaliyaya imaco Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Huan José quiilhui: ―Nopa motemic quej ni quinequi quiijtos. Nopa eyi imacuayo elis eyi tonali, ");
INSERT INTO nhwBl_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","pampa ica eyi tonali Faraón mitzquixtis nica, huan mitztlalis sempa ipan motequi. Huan sempa tijmacas icaxi imaco quen achtihuiya tijchihuayaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Quema panos ya nopa, techelnamiqui huan xijchihua se favor, xijcamanalhui Faraón tlen na para ma nechquixti ipan ni tlatzactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Nechichtejque ipan nopa tlali campa itztoque hebreos. Amo quinamiqui niitztos nica pampa amo tleno catli amo cuali nijchijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Huan quema nopa tlayacanquetl tlen panchihuani quiitac catli José quiijtojtoya, quiilhui: ―Nojquiya nijpixqui se temictli huan niquitayaya para niquicpahuiyaya eyi chiquihuitl tlen pantzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Huan nopa chiquihuitl catli huejcapa quipiyayaya nochi tlamantli pantzi para Faraón, pero totome hualayayaj huan quicuayayaj catli eltoya ipan nochiqui catli niquicpahuijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Huajca José quinanquili: ―Ya ni catli motemic quinequi quiijtos; nopa eyi chiquihuitl tlen pantzi elis eyi tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Huan ica eyi tonali Faraón mitzquixtis tlen nica huan quichihuas ma mitzcuahuiyonica ipan se cuahuitl huan totome quicuase monacayo. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Huan hualhuiptla quiaxiti ixihui Faraón huan quichijqui se hueyi ilhuitl para nochi catli quihuicayayaj tequitl ipan ichaj. Huan iniixpa nochi itlanotzalhua, Faraón tlatitlanqui ma quinquixtica ipan tlatzactli yaya catli achtihuiya quiyecoyaya itlailis huan nojquiya nopa tlayacanca panchijquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Huan catli quiyecoyaya itlailis sempa quitlali ipan itequi huan sempa pejqui quimaca icaxi quen achtihuiya. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Pero ica nopa panchijquetl tlatitlanqui ma quicuahuiyonica ipan se cuahuitl quen José quiijtojtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Pero masque ya nopa panoc, nopa catli quiyeco itlailis Faraón amo quielnamijqui José. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Quema panotoya ome xihuitl, se tonal Faraón quipixqui se temictli. Quitemijqui para ijcatoya iteno nopa hueyatl Nilo, ");
INSERT INTO nhwBl_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","huan chicome huacaxme catli yejyectzitzi huan tomahuaque quisayayaj ipan nopa hueyatl huan tlacuajtinemiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Huan iniica quisque chicome huacaxme catli fierojtique huan cocoxquetique. Quisque ipan nopa hueyatl huan moquetzque iteno ininnechca nopa sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Teipa nopa huacaxme fierojtique huan cocoxquetique quincuajque nopa chicome huacaxme yejyectzitzi huan tomahuaque. Huan Faraón isac. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Teipa sempa cochqui huan quipixqui seyoc temictli. Quiitayaya chicome imacuayo trigo yejyectzitzi catli temitoya ica iyol huan moscaltiyaya ipan san se tzontli. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Huan iniica chamanqui seyoc chicome imacuayo trigo catli huactoc huan pitzantzitzi catli quitlatijtoya nopa huac ajacatl catli huala campa hualquisa tonati. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Huan nopa chicome imacuayo trigo catli huactoc quincuajque nopa chicome imacuayo catli tomahuac huan temitoc. Huan Faraón isac huan momacac cuenta para eliyaya se temictli. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Pero ica ijnaloc moneltequipachohuayaya huan tlanahuati ma hualaca nochi tetonalitani huan nochi tlalnamijca tlacame ipan tlali Egipto. Huan Faraón quinpohuili itemic, pero niyon se tlen inijuanti amo huelqui quiilhui tlaque quinequiyaya quiijtos. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Huajca nopa tlacatl catli quipixqui itequi para quiyecos itlailis Faraón quielnamijqui José huan quiilhui Faraón: ―Ama niquelnamiqui catli amo cuali nijchijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Quema ticualanqui nohuaya huan ihuaya nopa tlayacanca panchijquetl, techtitlanqui tiome ipan nopa tlatzactli ipan ichaj nopa tlayacanquetl tlen nopa tlacame catli mitzmocuitlahuíaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Huan se tlayohua nopa panchijquetl huan na, tijpixque sesen temictli. Huan sesen temictli quipixqui catli quinequiyaya quiijtos. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Huan nopona ipan nopa tlatzactli itztoya tohuaya se hebreo telpocatl catli quitequipanojtoya nopa tlayacanquetl. Huan tijpohuilijque totemic huan nopa hebreo techilhui tlaque quiijtosnequi. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Huan nochi panoc san quen techilhui. Na nimocuepqui sempa ipan notequi huan nopa seyoc quicuapilojque. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Huajca Faraón tlatitlanqui ma quinotzatij José huan nimantzi quiquixtijque tlen nopa tlatzactli. Huan José malti, huan motentzonxinqui, huan quipatlac iyoyo huan monexti iixpa Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Huan Faraón quiilhui: ―Nijpixqui se temictli huan amo aqui hueltoc quiixtoma, pero nijcactoc quema tijcaqui se temictli, hueli tiquixtoma. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Huan José quinanquili: ―Amo nihueli na, pero Toteco Dios, quena. Yaya mitznextilis tlaque quinequi quiijtos motemic. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Huan Faraón quiilhui José: ―Ipan notemic, niquitayaya para niijcatoya iteno nopa hueyatl Nilo, ");
INSERT INTO nhwBl_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","huan ipan nopa hueyatl quisque chicome huacaxme tomahuaque huan yejyectzitzi catli tlacuajtinemiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Huan iniica quisque seyoc chicome huacaxme catli fierojtique huan cocoxquetique. ¡Amo quema niquinitztoya huacaxme nelfierojtique ipan nochi tlali Egipto! ");
INSERT INTO nhwBl_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Huan ni huacaxme cocoxquetique huan fierojtique quincuajque nopa achtihui huacaxme catli tomahuaque. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Pero masque quincuajtoyaj, amo tomahuixque. Noja eliyayaj cocoxquetique quen achtihui. “Huan teipa niisac. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Teipa nijtemijqui chicome imacuayo trigo yejyectzitzi huan tomahuaque catli temitoya ica iyol huan moscaltiyayaj ipan san se tzontli. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Huan iniica moscaltiyaya seyoc chicome imacuayo catli tzocoyoltique, huan pitzantzitzi, huan huactoque ica nopa huac ajacatl catli huala campa hualquisa tonati. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Huan ni chicome imacuayo catli pitzantzitzi quincuajque nopa chicome imacuayo catli tomahuaque. Na niquinpohuili notemic nopa tlacame catli tetonalitaj, pero niyon se amo huelqui nechilhuis tlaque quiijtosnequi.” ");
INSERT INTO nhwBl_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Huajca José quiilhui Faraón: ―Nopa ome temictli catli tijpixqui, san se. Toteco Dios mitzyolmelajtoc catli yaya quichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nopa chicome huacaxme catli yejyectzitzi quinequi quiijtos chicome xihuitl. Huan san se quiijtosnequi nopa chicome imacuayo trigo catli yejyectzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Huan nopa chicome huacaxme cocoxquetique huan fierojtique catli quisque iniica nopa sequinoc, quinequi quiijtos seyoc chicome xihuitl. Huan san se quiijtosnequi nopa chicome imacuayo trigo catli amo moscalti huan catli quihuatzqui nopa huac ajacatl catli huala campa hualquisa tonati. Quinequi quiijtos chicome xihuitl quema amo tleno oncas. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ya ni panos san quen nimitzilhuijtoc pampa Toteco Dios mitznextilijtoc catli ya quichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Hualas chicome xihuitl quema oncas tlahuel miyac pixquistli ipan nochi tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Huan teipa hualas chicome xihuitl catli amo tleno oncas. Huan nopa mayantli ajsis campa hueli ipan nochi tlali Egipto hasta amo aqui quielnamiquis nopa xihuitl catli cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Elis nelhueyi nopa mayantli hasta amo nesis catli achtihuiya oncac. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ta tijpixqui nopa temictli ompa pampa Toteco Dios motlalijtoc quichihuas ni tlamantli huan quichihuas nimantzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Huajca xijtemo se tlacatl catli cuali iyolo huan catli tlalnamiqui para tlayacanas ipan ni tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Huan ya ni xijchihua, totlanahuatijca. Xijnahuati ma quintlali gobernadores campa hueli ipan nochi ni tlali para ma quiajocuise se coxtali tlen sesen macuili coxtali catli quipixcase ipan tlali Egipto ipan nochi nopa chicome xihuitl quema tlahuel tlaoncas. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Ma quisentilica nopa trigo ipan nochi altepeme ipan nopa chicome cuali xihuitl catli huala huan ma quitlalica campa ta tijnahuatis, totlanahuatijca. Huan teipa oncas tlacualistli para nochi masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Quej nopa, mocahuas ajoctoc nopa trigo ipan totlal para masehualme amo apismiquise ipan nopa chicome xihuitl quema oncas mayantli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Huajca Faraón huan itlapalehuijcahua quicualcajque catli José quiijto, ");
INSERT INTO nhwBl_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","huan Faraón quinilhui: ―¿Canque tijpantise seyoc tlacatl quen ya ni catli quipiya itonal Toteco Dios? ");
INSERT INTO nhwBl_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Huan teipa Faraón quiilhui José: ―Amo aqui catli más tlalnamiqui huan catli más quimati que ta. San ta mitzmatiltijtoc Toteco Dios nochi ni tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Huajca momaco mocahuas nochi catli noaxca huan nochi nomasehualhua quineltocase catli tiquinilhuis. San na nielis más hueyi que ta pampa na nihueyi tlanahuatijquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Xiquita, na nimitztlalía tigobernador ipan nochi ni tlali Egipto. Quema quiijto ya ni, ");
INSERT INTO nhwBl_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Faraón moquixtili ipan imax ianillo catli quipixqui nopa sello catli quinexti itequiticayo huan quitlalili imaco José. Teipa tlanahuati ma quiyoyontica ica lino yoyomitl catli nelcuali huan ma quitlalilica iquechtla se costli tlen oro. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Quichijqui nopa ompa tlanahuatijquetl huan quiilhui ma tlejco ipan iompa carro. Huan quinnahuati itequipanojcahua ma quiyacantiyaca huan chicahuac ma teyolmelahuase: “¡Ximotlancuaquetzaca! ¡Huala tlanahuatijquetl!” Quej nopa Faraón quitlali José para ma tlanahuati ipan nochi nopa tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Huan teipa Faraón quiilhui: ―Na nimitzmaca motequiticayo huan niyon se ipan nochi Egipto huelis quiolinis imacpil sintla amo tijmaca tlanahuatili. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Huan Faraón quitocaxtlali José, Zafnat Panea, huan quisihuajti ihuaya Asenat, iichpoca Potifera nopa totajtzi ipan altepetl On. Huan campa hueli ipan tlali Egipto nochi quiiximatque José. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Huan José quipiyayaya 30 xihuitl quema pejqui quitequipanohua Faraón, nopa tlanahuatijquetl ipan tlali Egipto. Teipa José quinahuatijtejqui Faraón huan pejqui yohui campa hueli ipan nochi tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Huan nopa tlali temacac miyac pixquistli ipan nopa chicome xihuitl quema tlahuel oncac, ");
INSERT INTO nhwBl_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","huan José quiajojqui miyac trigo ipan nopa altepeme. Quicajtiyajqui ipan sese altepetl nopa trigo catli quisentilijque ipan nopa pilaltepetzitzi nechca. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Huan José quisentili miyac trigo quen imiyaca xali iteno hueyi atl. Nelmiyac eliyaya nopa trigo hasta ayacmo quiijcuilo quesqui coxtali pampa amo hueliyaya quinpohuaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Huan quema ayamo pehuayaya nopa xihuitl tlen mayantli, José quinpixqui ome iconehua ihuaya isihua, Asenat. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Nopa achtihui quitocaxti Manasés. (Manasés quinequi quiijtos “niquinelcajtoc”.) Quej nopa quitocaxti pampa quiijto: “Toteco Dios quichijtoc ma niquelcahua noteiximatcahua huan nochi catli nitlaijiyohuijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Huan iompa cone quitocaxti Efraín. (Efraín quinequi quiijtos “temaca itlajca”.) Quej nopa quitocaxti pampa quiijto: “Toteco Dios quichijtoc ma niquinpiya noconehua ipan ni tlali campa nitlaijiyohuijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Huan tlanqui nopa chicome xihuitl quema tlahuel oncac pixquistli ipan tlali Egipto, ");
INSERT INTO nhwBl_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","huan pejqui nopa chicome xihuitl quema amo oncac pixquistli quen José quiijto. Huan oncac mayantli ipan nochi tlalme nechca, pero ipan tlali Egipto oncayaya tlacualistli. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Huan quema Egipto ehuani pejque mayanaj, yajque quitlajtlanitoj trigo Faraón huan Faraón quinilhui nochi egiptome: “Xiyaca xiquitatij José huan xijchihuaca catli ya anmechilhuis.” ");
INSERT INTO nhwBl_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Huan quema nopa mayantli ajsic campa hueli ipan nochi nopa tlali, José quitlapo nochi nopa huejhueyi calme campa quiajocuiyaya trigo para quinnemaquiltis nopa egiptome pampa nopa mayantli eliyaya tlahuel chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Huan masehualme catli ehuani tlen campa hueli tlalme ajsiyayaj ipan tlali Egipto para quicohuase trigo ica José pampa ipan nochi nopa tlalme, amo oncayaya tlaque quicuase. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Quema Jacob quimatqui para oncayaya trigo ipan tlali Egipto, quinilhui itelpocahua: “¿Para tlen anmochiyaj se ica seyoc para anquiitase ajqueya techpalehuis? ");
INSERT INTO nhwBl_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nechilhuijtoque para ipan tlali Egipto onca trigo. Xiyaca nepa huan xijcohuatij para noja tiitztose.” ");
INSERT INTO nhwBl_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Huajca majtlactli tlen iicnihua José yajque tlali Egipto quicohuatij trigo. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Pero Jacob amo quicahuili ma yohui Benjamín, inelicni José pampa moilhui nohueli ipantisquía se tlamantli catli fiero. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Huajca itelpocahua Israel yajque ininhuaya nochi sequinoc catli yohuiyayaj tlacohuatij pampa campa hueli ipan nochi tlali Canaán oncayaya mayantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Huan José eliyaya gobernador ipan tlali Egipto huan yaya catli quinnemaquiltiyaya trigo nochi masehualme catli ajsiyayaj tlen campa hueli tlalme. Huan quema iicnihua José monextijque iixpa, motlancuaquetzque huan mohuijtzonque tlalchi quen momatque tlatlepanitaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Huan José quiniximatqui iicnihua quema quinitac, pero quichijqui quen amo quiniximatiyaya. Quincamanalhui ica cualantli huan quinilhui: ―¿Canque anhualahuij? Huan quiilhuijque: ―Tihualahuij tlali Canaán para titlacohuaquij. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Huan masque José quiniximatqui iicnihua, inijuanti amo quiiximatque. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Huan quielnamijqui nopa temictli catli quipixqui tlen iicnihua achtihuiya huan quinilhui: ―Amo neli anhualahuij para antlacohuase. Anhualajtoque anquiitaquij quenicatza eltoc totlal huan canica huelis antechtlanise. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Huan inijuanti quinanquilijque: ―¡Amo, tata! Timotequipanojcahua tihualajtoque tijcohuaquij trigo. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nochi tojuanti tiiconehua san se tlacatl. Ticuajcualme. Amo quema tiyajtoque ipan se altepetl para tijtlachilise quenicatza hueli tijtlanise. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Huan José quiijto: ―¡Amo neli! Anhualahuij anquiitaquij quenicatza huan canica huelis antechtlanise ipan totlal. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Pero inijuanti tlananquilijque: ―Timotequipanojcahua tiitztoque 12 tiicnime ica san se tlacatl huan tiitztoque ipan tlali Canaán. Toicni teipan ejquetl mocajqui ihuaya totata huan se ayacmo aqui tohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Pero José sempa quinilhui: ―Temachtli amojuanti antlapijpiyani, ");
INSERT INTO nhwBl_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","pero ica ya ni tiquitase. Ica itequiticayo Faraón, nitlanahuatía para amo hueli anquisase nica hasta ma huala amoicni teipan ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ma yohui se tlen amojuanti para quicuiti. Nopa sequin mocahuase tzactoque. Tiquitase sintla nelía catli anquiijtojtoque. Sintla amo, huajca nijmatis melahuac antlapijpiyaj pampa anquinequij antechtlanise. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Huan José quintzajqui nochi inijuanti para eyi tonali, ");
INSERT INTO nhwBl_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","pero ica ihualhuiptlatica quinilhui: ―Na nijtlepanita Toteco Dios, huajca xijchihuaca ya ni huan nimechcahuilis anitztose. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Sintla nelía ancuajcualme, ma mocahua tzactoc san se tlen amojuanti. Huan sequinoc amojuanti xijhuicaca trigo para ma tlacuaca amofamilia. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Pero monequi techhualiquilica amoicni teipan ejquetl para tiquitase sintla anquiijtojtoque catli melahuac. Pero sintla amo, huajca anmiquise. Huan inijuanti quicualcajque, ");
INSERT INTO nhwBl_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","pero moilhuiyayaj se ica seyoc: ―Melahuac fiero tijchihuilijque toicni. Amo tijchihuilijque cuenta quema tlahuel motequipachohuayaya huan techtlajtlaniyaya ma tijtlasojtlaca. Huan yeca ama topani eltoc ni cuesoli. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Huan Rubén quinilhui: ―Na nimechilhui para amo tleno xijchihuilica, pero amo antechcajque huan ama monequi titlaxtlahuase por imiquilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Pero amo quimatiyayaj sintla José quimachiliyaya inincamanal pampa José quinnojnotzayaya ica inincamanal egiptome huan seyoc quinixtomiliyaya catli quiijtohua. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Huan José mohuejcatlali tlen iicnihua para amo huelis quiitase huan pejqui choca. Teipa moyoltlali huan mocuepqui campa itztoyaj para quincamanalhui. Huan quiiyocaquixti Simeón huan iniixpa quinnahuati itequipanojcahua ma quiilpica. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Teipa tlanahuati ma quintemitilica inincoxtalhua iicnihua huan ma quincuepilica sese inintomi ipan inincoxtal. Nojquiya tlanahuati ma quinmacaca tlacualistli para ipan ojtli. Huan itequipanojcahua quej nopa quichijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Huan quintlamamaltijque ininburrojhua huan quistejque. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Huan quema ajsitoj campa tonilisquíaj, se tlen inijuanti quitlapo icoxtal para quitlamacas iburro huan quiitac itomi eltoya icoxtal ijtic. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Huajca quinilhui iicnihua: ―¡Xiquitaca nechcuepilijque notomi! ¡Nica eltoc ipan nocoxtal! Huan nochi momajmatijque miyac, huan huihuipicayayaj huan moilhuiyayaj se ica seyoc: ―¿Tlaque techchihuilijtoc Toteco Dios? ");
INSERT INTO nhwBl_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Huan quema ajsitoj tlali Canaán, quipohuilijque inintata, Jacob, nochi catli quinpanotoya, quiilhuijque: ");
INSERT INTO nhwBl_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","―Nopa tlacatl catli tlanahuatía ipan nopa tlali technojnotzqui ica cualantli huan techilhui para san tiyajtoyaj titlapijpiyatij ipan itlal para huelis tijtlanisquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Pero tiquilhuijque para ticuali masehualme huan amo quema titlapijpixtoque. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tiquilhuijque para tieliyayaj 12 tiicnime tlen san se tlacatl, huan se ayacmo itztoc tohuaya. Nojquiya tiquilhuijque para nopa teipa ejquetl mocajtoya mohuaya ta nica ipan Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Huajca ya techilhui para monequi quiitas sintla nelía ticuajcualme. Quiijto monequi se tlen tojuanti ma mocahua nopona huan para nopa sequinoc tojuanti ma tihualaca tijhualicaca trigo para tofamilias catli mayanaj, ");
INSERT INTO nhwBl_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","pero quiijto teipa monequi tijhuiquilise toicni teipan ejquetl. Quej nopa quiijto para melahuac quimatis sintla ticuali masehualme o san titlapijpiyani. Huan quiijto para quej nopa quimajcahuas toicni huan huelis titlacohuase ipan itlal ica cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Huan quema iicnihua José quiixcuepque inincoxtal, quiitaque para ipan sese inincoxtal oncayaya ininpilbolsa ica nopa tomi catli quihuicatoyaj. Huajca inijuanti huan inintata momajmatijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Huan Jacob quinilhui: ―Antechquixtilise nochi noconehua. José ayacmo aqui tohuaya, Simeón nojquiya, huan ama antechquixtilise Benjamín. Amo tleno quisa cuali para na. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Huajca Rubén quiilhui itata: ―Xijcahua Benjamín ma yohui. Huan nijmocuitlahuis huan nimitzcuepilis. Sintla amo nimitzcuepilis, huelis tiquinmictis nochi ome noconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Pero Jacob quiilhui: ―Nocone amo yas amohuaya. Iicni ya mijqui huan san ya mocahua. Sintla ipantis catli fiero ipan ojtli, antechchihuilise ma nihuehuejmiquis ica tequipacholi. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Huan nopa mayantli más eliyaya ipan inintlal. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Huan Jacob huan iteiximatcahua quitlamicuajque nochi nopa trigo catli quicuitoj ipan tlali Egipto, huajca quinilhui itelpocahua: ―Xiyaca sempa xijcohuatij trigo. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Pero Judá quiilhui: ―Nopa tlacatl ya techilhuijtoc para amo huelis tiquitase sintla amo tijhuicase toicni teipan ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Huajca sintla tijcahuas ma yohui tohuaya Benjamín, tiyase tijcohuatij trigo. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Pero sintla amo tijcahuas ma yohui, amo tiyase pampa san tlapic. Nopa tlacatl techilhui sintla amo tijhuicaj nepa toicni teipan ejquetl, amo huelis tiquitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Huajca Israel quiijto: ―¿Quenque antechchihuilíaj catli fiero huan anquiilhuijque nopa tlacatl para anquipiyayayaj seyoc amoicni? ");
INSERT INTO nhwBl_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Huan inijuanti quiilhuijque: ―Tiquilhuijque pampa ya techtlatzintoquiliyaya miyac tlen tojuanti huan tofamilias. Techtlatzintoquili sintla noja itztoc totata, huan sintla tijpiyaj seyoc toicni. Huan san tijnanquiliyayaj catli techtlatzintoquiliyaya. ¿Quenicatza tijmatisquíaj para techilhuisquía ma tijhuiquilisquíaj toicni? ");
INSERT INTO nhwBl_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Huan Judá quiilhui Israel, itata: ―Sintla tijnequi ma tiitztoca, xijcahuili ma yohui Benjamín, huan na nijmocuitlahuis huan tiyase nimantzi. Quej nopa amo timiquise, niyon ta, niyon tojuanti, niyon toconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Huan sintla tlen hueli ipantis, na notlajtlacol. Sintla amo nimitzcuepilis, huajca nijhuicas tlajtlacoli moixpa para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Sintla amo tihuejcajtosquíaj, ya tiyajtosquíaj huan ya tihualajtosquíaj ompa. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Huajca itata quinilhui: ―Ayacmo onca seyoc tlamantli catli hueli tijchihuase, huajca ama xijchihuaca ya ni. Xijtemilica amocoxtal tlamantli catli más cuali catli temaca ni totlal para xijtlamajmacatij nopa tlacatl. Xijhuiquilica quentzi bálsamo, sayolnectli, tlaajhuiyacayotl, mirra, huan almendras huan nopa nueces catli itoca pistache catli nelía ajhuiyac. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Xijhuicaca nojquiya ome huelta imiyaca nopa tomi catli anmechcuepilijque ipan amocoxtal. Nohueli mocuapolojque. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Huan xijhuicaca amoicni Benjamín huan sempa xiquitatij nopa tlacatl. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Toteco Catli Quipiya Nochi Chicahualistli ma anmechtlasojtla. Ma anmechpalehui iixpa nopa tlacatl para ma quimajcahua nopa seyoc amoicni huan Benjamín para ma mocuepaca amohuaya. Huan ica na, sintla monequi niquinpolos noconehua, huajca quej nopa ma eli. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Huajca itelpocahua Jacob quihuicaque iniicni, Benjamín, huan tlamantli catli temajmacatij, huan ome hueltas imiyaca tomi. Teipa quistejque, moisihuiltijque yajque tlali Egipto huan monextitoj iixpa José. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Huan quema José quiitac Benjamín ininhuaya hualayaya, quiilhui itequipanojca catli más tlayacana ipan ichaj: ―Xiquinhuica ni tlacame nochaj, huan xijmicti se huacax huan xijcualtlali pampa tlacuase nohuaya tlajcotona. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Huan nopa tequipanojquetl quichijqui quen José quinahuati huan quinhuicac ichaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Pero inijuanti momajmatijque pampa quinhuicayaya ichaj José huan moilhuijque: ―Techhualicatoc nica por nopa tomi catli techcuepilijque quema achtihui tihualajque. Ama quiijtos tiquichtequilijque, huan techquixtilis totlapiyalhua huan techitzquise. Techchihualtise ma titequitica quen titequipanohuani catli quincojtoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Huajca quema ajsitoj campa calaquij ipan ichaj José, monechcahuijque campa nopa tlayacanca tequipanojquetl, ");
INSERT INTO nhwBl_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","huan quiilhuijque: ―¡Tate, techtlacaquili! Quema achtihui tihualajque tijcohuacoj trigo, ");
INSERT INTO nhwBl_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","tiquistejque ica totrigo huan tiajsitoj campa ticochisquíaj ipan ojtli. Huan tijtlapojque tocoxtalhua, huan icamaco sesen coxtali eltoya totomi sesen tojuanti. Eltoya ajsitoc totomi catli ica tijcojtoyaj nopa trigo. Huan ama tijhualicatoque para tijcuepase. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Huan iyoca tijhualicaque más tomi para tijcohuase más trigo. Pero amo tijmatij ajqueya quitlali totomi ipan tocoxtalhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Huan nopa tlayacanca tequipanojquetl quinilhui: ―Amo ximotequipachoca. Dios amoTeco huan iTeco amotata, huelis yaya quitlali nopa tomi ipan amocoxtalhua pampa na nijseli nopa tomi catli antechmacaque. Huan nopa tequipanojquetl quiquixti Simeón huan quihualicac campa itztoyaj nopa icnime. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Teipa quinhuicac san sejco hasta ichaj José. Huan quinmacac atl para ma moicxipajpacaca huan nojquiya quintlamacac ininburrojhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Huan inijuanti quicualtlalijque catli quimacasquíaj José huan quichixque para ma ajsi tlajcotona pampa quicactoyaj para tlacuasquía ininhuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Huan quema José ajsito ichaj, quimacaque catli quihuiquilijtoyaj, huan motlancuaquetzque huan mohuijtzonque hasta tlalchi para quitlepanitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Huan José quintlatzintoquili quenicatza itztoyaj huan nojquiya quinilhui: ―¿Quenicatza itztoc amotata, nopa tatatzi catli antechcamanalhuijque? ¿Noja itztoc? ");
INSERT INTO nhwBl_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Huan inijuanti quiilhuijque: ―Totata, motequipanojca, noja itztoc huan itztoc cuali. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Huan José quiixtemo Benjamín hasta quipanti. Elqui inelicni catli quitlacatilti inana. Huan José quiijto: ―¿Ya ni amoicni teipan ejquetl catli antechcamanalhuijque? Huan José quiilhui Benjamín: ―¡Ma Toteco Dios mitztiochihua, nocone! ");
INSERT INTO nhwBl_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Huan quema José quiijto ya ni, monejqui moyoltetilis para amo chocas iniixpa pampa sempa quiitac iicni. Huan nimantzi quistihuetzqui, huan calajqui ipan icuarto huan nopona tlahuel miyac chocac. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Teipa quema huelqui moyoltlali, mixami huan mocuepqui campa iicnihua itztoyaj. Teipa quinilhui itequipanojcahua: “¡Xijtecaca ne tlacualistli!” ");
INSERT INTO nhwBl_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Huan quitequilijque José itlacualis iseltzi ipan se mesa, huan iicnihua ipan seyoc. Huan ipan seyoc mesa quintequilijque nopa egiptome catli tlacuayayaj ihuaya José. Pampa tlali Egipto ehuani quinijiyayayaj hebreo masehualme huan amo tlacuayayaj ininhuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Huan José quinilhui sese iicnihua canque mosehuise. Quinsehui quen tlacajtiyajque tlen achtihui ejquetl hasta catli teipan ejquetl. Pejqui ica catli más hueyi hasta catli más tziquitetzi. Huan nopa icnime mosentlachilijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Huan quema quintequilijque nopa tlacualistli catli eltoya ipan imesa José, Benjamín quitequilijque macuili hueltas más imiyaca que catli quintequilijque ne sequinoc. Huan quej nopa san sejco tlaique huan tlacuajque. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Teipa José quiilhui itlayacanca tequipanojca: ―Xijtemiti inincoxtal ni tlacame ica nochi trigo catli hueli quihuicase huan xijtlali sese inintomi ipan icamac inincoxtal. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nojquiya xijtlali nocaxi tlen plata ipan icoxtal iniicni catli teipan ejquetl, ihuaya nopa tomi catli tlaxtlajqui para trigo. Huan nopa tequipanojquetl quichijqui quen José quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Huan quema san ontlatlanesqui, José quincahuili iicnihua ma yaca ihuaya ininburrojhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Pero ayamo huejca yajtoyaj tlen nopa altepetl quema José quiilhui itequipanojca: ―Xiya xiquintoquili nopa tlacame huan quema tiquinajsiti, xiquinilhui: ‘¿Para tlen anquicueptoque catli cuali ica catli amo cuali? ¿Quenque anquiichtectoque nopa caxitl tlen plata ");
INSERT INTO nhwBl_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","catli noteco quitequihuía para ipan atlis huan para quiitas catli panos teipa? ¡Anquichijtoque catli fiero!’ ");
INSERT INTO nhwBl_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Huan quema nopa tequipanojquetl quinajsito, quinilhui nochi ya ni. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Huan nopa icnime quiilhuijque: ―¿Para tlen techcamanalhuía quej nopa? ¡Amo quema tijchihuasquíaj nopa tlamantli! ");
INSERT INTO nhwBl_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Xiquita sempa tijhualicaque tlen tlali Canaán nopa tomi catli eltoya ipan tocoxtal. ¿Quenicatza tiquichtequise oro o plata tlen ichaj moteco? ");
INSERT INTO nhwBl_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","¡Ma miqui aqui hueli tlen tojuanti catli tijpantilis nopa caxitl huan nochi tojuanti timitztequipanose san tlapic! ");
INSERT INTO nhwBl_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Huajca nopa tequipanojquetl quiijto: ―Cualtitoc catli anquiijtohuaj, pero san yaya catli quipiya nopa caxitl techtequipanos san tlapic. Nopa sequin amo quipiyase tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Huan sesen tlen inijuanti nimantzi quitemohui icoxtal huan quitlapo. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Huan nopa tequipanojquetl quitemo ipan sesen coxtali. Pejqui ica catli achtihui ejquetl hasta nopa teipan ejquetl huan quipanti nopa caxitl ipan Benjamín icoxtal. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Huajca quitzayanque ininyoyo ica hueyi tequipacholi. Huan teipa quintlamamaltijque ininburrojhua huan mocuepque ipan nopa altepetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Huan quema Judá huan iicnihua ajsitoj ichaj José, ya noja itztoya nopona. Huan motlancuaquetzque iixpa huan mohuijtzonque tlalchi, ");
INSERT INTO nhwBl_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","huan José quinilhui: ―¿Tlaque anquichijtoque? ¿Amo anquimatij para se tlacatl quen na quimati catli quichihuaj sequinoc? ");
INSERT INTO nhwBl_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Huan Judá quiijto: ―¿Tlaque huelis timitznanquilise? ¿Quenicatza huelis tijnextise para amo tijchijtoque? Toteco Dios techpantijtoc titlajtlacolchijtoque. Huajca nica tiitztoque huan timitztequipanose san tlapic ihuaya catli quipixtoya nopa caxitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Pero José quiijto: ―Amo, amo quej nopa. San ya ne catli quipiyayaya nopa caxitl nechtequipanos san tlapic. Huan ne sequinoc amojuanti huelis anmocuepase ica cuali hasta ichaj amotata. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Huajca Judá monechcahui campa José huan quiilhui: ―Na nimitztlajtlanía, noteco, para techcahuili nimitzilhuis se tlamantli catli amo aqui quimati. Xijchihua se favor, amo xicualani nohuaya pampa tieltoc quen Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Achtihui ta techtlatzintoquili sintla tijpiyayayaj totata huan tlen seyoc totlaca icni. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Huan timitzilhuijque para tijpiyaj totata catli huehuentzi huan tijpiyaj se toicni catli neltelpocatl catli tlacatqui quema totata eliyaya nelhuehuentzi. Huan timitzilhuijque para totata quiicnelía miyac. San ya mocahua tlen inana. Nopa seyoc iicni ya mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Huajca techtlajtlani ma tijhualicaca pampa tijnequiyaya tiquiximatis. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Huan timitzilhuijque nopa telpocatl amo hueli quicajtehua itata. Sintla quicajtehuasquía, itata miquisquía. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Pero ta techilhui sintla ya amo hualayaya tohuaya, ayacmo techselisquía. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Huajca quema timocuepque campa totata, tijpohuilijque nochi catli techilhuijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Huan teipa totata techilhui ma tihualaca tijcohuaquij se quentzi trigo. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Pero tiquilhuijque para amo hueli tihualase hasta toicni teipan ejquetl hualas tohuaya. Sintla amo tohuaya huala, amo huelis timitzitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Huan totata techilhui: ‘Anquimatij nosihua nechmacac ome noconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Huan se tlen nopa ome quisqui huan nimoilhuía se tecuani quicuajqui pampa hasta ama ayacmo niquitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Sintla anquihuicaj huejca ni seyoc nocone huan sintla ipantis se tlamantli catli fiero, antechchihualtise ma nihuehuejmiqui ica tequipacholi.’ ");
INSERT INTO nhwBl_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Yeca sintla toicni amo mocuepas tohuaya, ");
INSERT INTO nhwBl_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","totata catli ya nelhuehuentzi nimantzi miquis ica tequipacholi pampa amo quiitas. Huan tijhuicase tlajtlacoli por imiquilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na niquilhui notata para ma quicahua nomaco huan nijmocuitlahuisquía. Nojquiya niquilhui para sintla amo nijcuepilis, huajca nijhuicas tlajtlacoli iixpa para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yeca nimitztlajtlanía, techcahuili ma nimocahuas nimitztequipanos na huan amo ya. Xijcahuili ma mocuepa ihuaya iicnihua. ");
INSERT INTO nhwBl_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","¿Pampa quenicatza huelis nimocuepas huan niquitas notata, sintla noicni amo yohui nohuaya? Amo nijnequi niquitas quenicatza tlaijiyohuis notata.” ");
INSERT INTO nhwBl_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Huan José ayacmo huelqui moijiyohuía para amo chocas iniixpa itequipanojcahua catli itztoyaj nopona. Huan chicahuac quinilhui: “¡Xiquisaca nochi amojuanti catli anitztoque nica!” Huajca nochi itlapalehuijcahua quisque pampa José quinequiyaya itztos iseltzi ica iicnihua quema quinilhui ajqueya ya. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Huan yaya pejqui choca chicahuac hasta nochi nopa egiptome ipan ichaj quicajque. Huan ajsic nopa camanali hasta nopa hueyi tequicali campa itztoc Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Huan José quinilhui iicnihua: ―Na niJosé. ¿Noja itztoc notata? Huan iicnihua tlahuel momajmatijque iixpa hasta amo hueliyayaj camanaltij. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Pero ya quinilhui: ―Ximonechcahuica campa na. Huan quema monechcahuijque campa ya, yaya quinilhui: ―Na niamoicni José catli antechnemacaque para ma nechhualicaca tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Amo ximotequipachoca, niyon amo ximocualanica pampa antechnemacaque. Toteco Dios nechtitlanqui achtihui ma nitlayacanas nica para amo timiquise. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ya panoc ome xihuitl ica mayantli ipan ni tlali, pero noja polihui seyoc macuili xihuitl quema amo oncas niyon quentzi pixquistli huan amo aqui huelis tlatojtocas. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Toteco Dios nechtitlanqui nica achtihui para nijmanahuis amonemilis para ma mocahuaca amoteipan ixhuihua para mochihuase tlahuel miyac masehualme ipan tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Huajca amo elqui amojuanti catli antechtitlanque nica. ¡Amo! Elqui Toteco catli nechtitlanqui, huan nechtlalijtoc niitlapalehuijca Faraón huan na catli nijconsejomaca. Yaya nechtlalijtoc ma nitlanahuati ipan ichaj huan ma nieli nigobernador ipan nochi ni tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Huajca xiyaca nimantzi campa itztoc notata huan xiquilhuica para icone, José, quiijtohua para Toteco Dios nechtlalijtoc ma nitlanahuati ipan nochi tlali Egipto. Huajca nimantzi ma huala nechitaqui. Ma amo huejcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Huelis itztos nonechca, nopona campa itoca Gosén nica ipan tlali Egipto ihuaya amojuanti, huan amoconehua, huan amoixhuihua, huan nochi amotlapiyalhua huan nochi catli anquipiyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Nica nimechmacas tlacualistli para nochi amofamilia huan nochi catli itztoque amohuaya para ma amo tleno anmechpolos. Noja oncas ni mayantli para seyoc macuili xihuitl. Sintla amo hualas, amojuanti huan nochi catli anquipiyaj tlahuel antlaijiyohuise. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Teipa José quiijto: ―Xiquitaca amojuanti huan Benjamín para nelía na niJosé. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Huajca xijpohuilica notata tlaque tequiticayotl nijpiya nica ipan Egipto huan nochi catli anquiitztoque nica. San monequi nimantzi xijhualicatij notata. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Huan José ica nochi iyolo quicuanajnahuajqui iicni Benjamín huan chocac miyac iquechpa. Huan Benjamín quicuanajnahuajtoc chocac ipan José. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Teipa José quintzoponi nochi iicnihua huan chocac quema quincuanajnahuajqui. Huan teipa iicnihua pejque quicamanalhuíaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Huan ipan ichaj Faraón quicajque para ajsicoj iicnihua José huan nelía pajque Faraón huan nochi itlapalehuijcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Huan Faraón quiilhui José: ―Xiquinilhui moicnihua ma quintlamamaltica inintlapiyalhua huan ma mocuepaca ipan tlali Canaán, ");
INSERT INTO nhwBl_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","huan ma nechhualiquilica amotata huan nochi ininteiximatcahua. Na niquinmacas nopa tlali catli más cuali ipan nochi ni tlali Egipto. Huan quicuase catli más cuali catli ni tlali temaca. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Xiquinilhui ma quihuicaca cuacarros tlen tlali Egipto para ma quinhualicaca ininsihuajhua ihuaya ininconehua huan amotata. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ma amo motequipachoca ica catli ama quipiyaj. Nochi catli cuali catli onca ipan ni tlali Egipto teipa elis iniaxca. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Huan quej nopa quichijque itelpocahua Israel. Huan José quinmacac cuacarros quen Faraón tlanahuatijtoya huan quinmacac tlacualistli para ipan ojtli. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nojquiya quinmacac yoyomitl yancuic para ma mopatlase, pero Benjamín quimacac 300 tomi tlen plata huan macuili iyoyo para mopatlas. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Huan para itata José quititlanili majtlactli burrojme tlamamajtoque ica tlamantli catli onca ipan tlali Egipto huan nojquiya quinmacac seyoc majtlactli burrojme tlamamajtoque ica trigo, pantzi huan tlacualistli para ma tlacua itata ipan ojtli. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Huan quema José quinmajcajqui iicnihua, quinilhui: ―Amo ximonajnanquilica ipan ojtli. Huan inijuanti yajque. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Huan quisque ipan tlali Egipto huan ajsitoj tlali Canaán campa itztoya inintata, Jacob. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Huan quema quipohuilijque Jacob para José noja itztoya huan yaya catli tlanahuatiyaya ipan nochi tlali Egipto, amo quimatiyaya tlaque quiijtos, niyon tlaque quichihuas pampa amo hueliyaya quineltoca. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Pero quema quipohuilijque nochi catli José quiijtojtoya huan quema quinitac nopa cuacarros catli José quintitlantoya para quinhuicase, nelía pajqui miyac. ");
INSERT INTO nhwBl_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Huan huajca quiijto: “Nelía temachtli, nocone José noja itztoc huan amo nimiquis hasta niyas niquitati.” ");
INSERT INTO nhwBl_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Huan Israel, catli nojquiya itoca eliyaya Jacob, quisqui ipan ojtli ica nochi catli quipiyayaya. Huan quema ajsito ipan Beerseba, quimacac se tlacajcahualistli Toteco Dios, yaya catli nojquiya iTeco itata, Isaac. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Huan nopa tlayohua Toteco quicamanalhui Israel ipan se temictli, huan quinotzqui ica itoca Jacob. Huan Jacob quinanquili: ―Nica niitztoc, noTeco. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Huajca Toteco Dios quiilhui: ―Na niDios nimoTeco. Na niiTeco motata. Amo ximajmahui para tiyas tlali Egipto pampa nopona nijchihuas para moteipan ixhuihua tlahuel momiyaquilise hasta mochihuase se altepetl ica tlahuel miyac masehualme ica san se inieso. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Na niyas mohuaya ipan Egipto huan teipa niquinquixtis moteipan ixhuihua nopona. Quema timiquis, motelpoca José itztos monechca. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Huan itelpocahua Jacob quitlalijque inintata, huan ininconehua huan ininsihuajhua ipan nopa cuacarros catli Faraón quintitlantoya huan yajque. Huan quej nopa Israel quistejqui tlen Beerseba. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Huan Jacob huan itelpocahua quinhuicaque inintlapiyalhua huan nochi catli quipixtoyaj ipan tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Yajque nochi iconehua huan iixhuihua; tlacame huan sihuame. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nica nimitzilhuis inintoca itelpocahua huan iteipan ixhuihua Israel o Jacob catli yajque tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Yajqui Rubén iachtihui ejca cone Jacob. Yajque iconehua Rubén: Hanoc, Falú, Hezrón huan Carmi. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Yajque Simeón huan iconehua: Jemuel, Jamín, Ohad, Jaquín, Zohar huan Saúl catli eliyaya icone se sihuatl cananea. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Yajque Leví huan iconehua: Gersón, Coat huan Merari. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yajque Judá huan iconehua: Sela, Fares huan Zara. Pero iconehua catli inintoca Er huan Onán ya mictoyaj ipan tlali Canaán. Huan iconehua Fares elque: Hezrón huan Hamul. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Yajque Isacar huan iconehua: Tola, Fúa, Job huan Simrón. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Yajque Zabulón huan iconehua catli inintoca eliyayaj: Sered, Elón huan Jahleel. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Nochi ni tlacame catli nimitzilhuijtoc nica elque iconehua Jacob ihuaya Lea huan yajque tlali Egipto ica Jacob. Huan nochi ni ininconehua tlacatque quema itztoyaj ipan tlali Aram. Nojquiya Jacob huan Lea quipixque se iniichpoca catli itoca Dina. Ininconehua huan iniixhuihua Jacob huan Lea mochijque 33. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Nojquiya yajque tlali Egipto Gad huan iconehua: Zifión, Hagui, Ezbón, Suni, Eri, Arodi huan Areli. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Yajque Aser huan iconehua: Imna, Isúa, Isúi, Bería huan ininsihua icni catli itoca Sera. Huan Bería ya quinpixqui iconehua: Heber huan Malquiel. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Catli nimitzilhuijtoc nica elque iconehua Jacob ica Zilpa huan yajque tlali Egipto ininhuaya. Zilpa elqui nopa tequipanojquetl catli Labán quimacac iichpoca, Lea, huan teipa Lea quimacac ihuehue para ma eli isihua. Huan ininconehua huan iniixhuihua Jacob ihuaya Zilpa elque 16 masehualme ica nochi. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Huan nojquiya yajque catli eltoyaj iconehua Raquel, isihua Jacob huan inintoca ininconehua elque: José huan Benjamín. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Huan ipan Egipto José quinpixqui coneme ihuaya isihua Asena. Asena elqui iichpoca Potifera, catli eliyaya se totajtzi nopona ipan altepetl On. Ininconehua elque: Manasés huan Efraín. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Huan iconehua Benjamín elque: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim huan Ard. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Catli nimitzilhuijtoc nica elque iconehua huan iixhuihua Raquel huan Jacob. Huan mochijque 14 masehualme para nochi. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Huan nojquiya yajque tlali Egipto Dan, icone Jacob, huan icone: Husim. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Huan nojquiya yajque Neftalí huan iconehua: Jahzeel, Guni, Jeser huan Silem. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Huan inijuanti elque iconehua Bilha, nopa tequipanojquetl catli Labán quimacac iichpoca, Raquel, huan teipa Raquel quimacac Jacob para ma eli isihua. Huan iconehua huan iixhuihua Jacob ica Bilha elque chicome para nochi. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Huan para nochi nopa masehualme catli yajque Egipto ihuaya Jacob catli nelía san se inieso elque 66, huan amo quinpojque inintelpocahua ininsihuajhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Huan ica nopa ome iconehua José catli tlacatque ipan Egipto mochijque 70 masehualme ipan ifamilia Jacob quema ajsitoj nopona. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Huan Jacob quititlanqui Judá ma tlayacana para quiitati José huan quimachiltis para ma quinamiquiqui ipan tlali Gosén. Huan quema Judá ajsito campa José, ");
INSERT INTO nhwBl_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","tlanahuati ma quicualtlalica icarro para yas quinamiquiti itata. Huan quema ajsito iixpa itata, quinajnahuajqui huan huejcajqui choca ipan iajcol. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Huan Israel quiilhui José: ―Ama ya huelis nimiquis pampa nelía nimitzitztoc ica noixteyol huan nimitzpanti noja tiitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Huan José quinilhui iicnihua huan nochi ifamilia itata: ―Niyas niquitati Faraón para nijyolmelahuati para ya anajsitoque. Niquilhuis para noicnihua huan iteiximatcahua notata catli itztoyaj ipan tlali Canaán ya hualajtoque para mocahuase nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Huan quinhualicatoque ininborregojhua, ininhuacaxhua huan nochi catli quipiyaj pampa inintequi eli quinmocuitlahuíaj borregojme huan quiniscaltíaj tlapiyalme. Quej nopa niquilhuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Huajca quema nopa Faraón anmechnotzas huan anmechtlatzintoquilis ipan tlaque antequitij, ");
INSERT INTO nhwBl_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","xiquilhuica para nochipa anquiniscaltijtoque borregojme, san se quen amohuejcapan tatahua. Quej nopa anmechcahuilis anmocahuase ipan tlali Gosén pampa egiptome quinijiyaj catli quinmocuitlahuíaj borregojme huan amo quinequij itztose ininhuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Huan José yajqui quiyolmelahuato Faraón huan quiilhui para itata huan iicnihua ya ajsicoj tlen tlali Canaán huan itztoyaj ipan tlali Gosén ihuaya ininborregojhua, huan ininhuacaxhua huan nochi catli quipiyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Huan quintlapejpeni macuilti iicnihua huan quinhuicac iixpa Faraón para ma quiniximatica. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Huan Faraón quintlatzintoquili: ―¿Tlaque tequitl anquichihuaj? Huan inijuanti quiilhuijque: ―Tojuanti, timotequipanojcahua, tiquinmocuitlahuíaj borregojme quen tohuejcapan tatahua quichijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Huan tihualajtoque para timocahuase ipan ni tlali pampa amo onca sacatl para toborregojhua nepa ipan tlali Canaán pampa nopa mayantli tlahuel chicahuac nopona. Se favor, totlanahuatijca, techcahuili ma timocahuaca ipan tlali Gosén. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Huan Faraón quiilhui José: ―Motata huan moicnihua hualajtoque para mocahuase nica mohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Huajca huelis quitequihuise campa más cuali ipan ni tlali Egipto. Xiquinmaca nopa tlali Gosén para nopona ma mocahuaca pampa nelcuali. Huan sintla tijmati sequin tlen inijuanti catli más quimatij nopa tequitl, huajca xiquintlali nochi notlapiyalhua ininmaco. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Teipa José quihuicac itata, Jacob, iixpa Faraón para ma quiiximati. Huan Jacob quitiochijqui Faraón, ");
INSERT INTO nhwBl_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","huan Faraón quiilhui: ―¿Quesqui xihuitl tijpiya? ");
INSERT INTO nhwBl_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Huan Jacob quinanquili: ―Nijpanotoc 130 xihuitl catli nelohui. Pero ya nopa nelquentzi pampa ayamo nicajsi nopa xihuitl catli nohuejcapan tatahua itztoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Teipa Jacob quinahuatijtejqui Faraón huan quisqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Huan José quinmacac itata huan iicnihua nopa tlalme catli más cuali ipan tlali Egipto, nopa tlali itoca Ramesés, para ma itztoca nopona quen Faraón tlanahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nojquiya José quinmacayaya tlacualistli nochi iteiximatcahua quen sese inijuanti monejqui para quitequihuise. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Huan teipa ipan niyon se tlali ayacmo oncac tlacualistli pampa nopa mayantli más motlananqui. Ipan tlali Egipto huan ipan tlali Canaán nochi tlahuajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Huan nochi tomi ipan tlali Egipto huan ipan tlali Canaán ajsico imaco José pampa quinemacayaya trigo. Huan yaya quihuicac nopa tomi tequicalco campa itztoya Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Huan quema ayacmo aqui quipixqui tomi ipan tlali Egipto huan ipan tlali Canaán, nopa egiptome yajque quiilhuitoj José: ―¡Techmaca catli tijcuase! Amo techcahuili ma tiapismiquica moixpa san pampa ya tlanqui totomi. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Huan José quinnanquili: ―Sintla ayacmo anquipiyaj tomi, huajca xiquinhualicaca amotlapiyalhua huan nimechpatilis ica trigo. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Huan nopa egiptome quinhuicaque inincahuayohua, ininborregojhua, ininchivojhua, ininhuacaxhua huan ininburrojhua, huan José quinpatili ica trigo. Quen nopa quinpanolti nochi nopa xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Huan quema panoc nopa xihuitl, inijuanti sempa yajque quiilhuitoj José: ―Ta tijmati ayacmo tijpiyaj tomi huan ama nochi totlapiyalhua amoaxcahua. Ayacmo tijpiyaj seyoc tlamantli catli huelis timitzmacase, san totlal mocahua huan totlacayohua. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pero amo techcahuili ma timiquica moixpa ica mayantli. Techcohua tojuanti ihuaya totlalhua ica trigo. Huan tijtequipanose Faraón san tlapic huan totlalhua elis iaxca, pero techmaca trigo para tiitztose huan para ni tlali ma amo nenpolihuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Huajca José quicojqui para Faraón nochi piltlaltzitzi ipan tlali Egipto pampa nochi nopa egiptome quinemacaque inintlalhua pampa amo huelque quiijiyohuíaj nopa mayantli. Quej nopa nochi nopa tlali panoc imaco Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Huan José quinchijqui nopa egiptome campa hueli ma elica tequipanohuani catli tequitique san tlapic. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Pero amo quicojqui inintlal nopa totajtzitzi pampa Faraón quinmacayaya trigo san tlapic. Huan amo monejqui quinemacase inintlalhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Teipa José quinilhui nopa egiptome: ―Ama amojuanti ihuaya amotlalhua anmocahuaj iaxca Faraón pampa nimechcojtoc para anelise iaxca ya. Nica anquipiyaj xinachtli para xijtocaca. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Pero quema anpixcase, monequi anquixelose nopa pixquistli catli oncas ica macuili partes. Se parte elis iaxca Faraón huan nopa seyoc nahui partes elise amoaxcahua para anquitocase, huan para anquicuase amojuanti huan amoconehua huan catli itztoque ipan amochajchaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Huan inijuanti tlananquilijque: ―Techmanahuijtoc para amo timiquise. Ica paquilistli tijtequipanose Faraón san tlapic. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Huajca José quichijqui nopa tlanahuatili ipan nochi tlali Egipto para ipan sesen macuili coxtali catli pixcase monequi quimacase Faraón se coxtali. Huan ni tlanahuatili noja quitoquilíaj. Pero nopa totajtzitzi amo tleno monejqui tlaxtlahuase pampa inintlalhua amo quema elqui iaxca Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Huan nopa israelitame mocajque ipan nopa piltlaltzi Gosén ipan tlali Egipto huan nopona nochi quisqui cuali para inijuanti. Huan inijuanti tlahuel momiyaquilijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Huan Jacob itztoya 17 xihuitl ipan Egipto huan quiaxiti 147 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Huan se tonal Israel quimatqui ayacmo huejcahuas para miquis, huajca tlatitlanqui ma quinotzatij José huan quiilhui: ―Se favor, xijtlali momax itzintla nometztomahuiya huan xijtestigojquetza Toteco para tijchihuas catli nimitztlajtlanis. Amo techtocas nica ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quema nimiquis huan nimosiyajquetzati ihuaya nohuejcapan tatahua, techhuica huan techtoca campa inijuanti toctoque. Huan José quiilhui: ―Quena, quej nopa nijchihuas. ");
INSERT INTO nhwBl_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Huan itata sempa quiilhui: ―¡Xijtestigojquetza Toteco Dios! Huan José quitestigojquetzqui Toteco Dios para temachtli quichihuas. Huan huajca Israel mohuijtzonqui ica itzonteco ipan icuatopil huan quihueyichijqui Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Teipa quema panotoya se quentzi tonali quiilhuijque José para itata mococohua. Huajca José yajqui quiitato huan quinhuicac iome telpocahua, Manasés huan Efraín. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Huan quema quiyolmelajque Jacob para icone, José, ajsitoya para quiitati, quichijqui fuerza huan mosehui ipan itlapech. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Huan quiilhui José: ―Toteco Catli Quipiya Nochi Chicahualistli monexti campa niitztoya nechca altepetl Luz ipan tlali Canaán huan nechtiochijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Huan nechilhui para quinmiyaquilis noconehua huan noteipan ixhuihua hasta mochihuase tlahuel miyac masehualme. Nojquiya nechilhui para noteipan ixhuihua quinmacasquía nopa tlali huan elis iniaxca para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Huajca ama huan teipa ni ome moconehua, Efraín huan Manasés, catli tlacatque nica ipan tlali Egipto quema ayamo niajsiyaya elise quen noaxcahua para quiselise san se quen Rubén huan Simeón quiselise. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Pero nopa moconehua catli tlacatise teipa elise moaxcahua ta. Huan inijuanti quiselise catli quintocaros ipan nopa tlali catli elis iniaxca Efraín huan Manasés. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Quema nimocuepayaya tlen tlali Aram, mijqui monana Raquel ipan Canaán quema tinejnemiyayaj ipan ojtli huan san quentzi polihuiyaya para tiajsitij altepetl Efrata. Huan nijtojqui nopona ipan ojtli para altepetl Efrata catli ama itoca Belén. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Huan Israel quinitac itelpocahua José huan quiijto: ―Huan ¿ni telpocame? ");
INSERT INTO nhwBl_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Huan ya quiilhui: ―Ni noconehua catli Toteco Dios nechmacatoc nica ipan tlali Egipto. Huan itata quiilhui: ―Xijchihua se favor, xiquinnechcahuilti campa na para niquinmacas notlatiochihual. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Huan Israel eliyaya nelhuehuentzi huan ayacmo cuali iixteyol, huan yeca ayacmo hueliyaya tlachiya cuali. Huan José quinnechcahuilti itelpocahua campa itata, huan Jacob quintzoponi huan quinnajnahuajqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Teipa Jacob quiilhui José: ―Ayacmo nijchiyayaya para sempa nimitzitas huan masque ya nopa, Toteco Dios nechcahuilijtoc nojquiya ma niquinita moconehua. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Huan José quinijcuini itelpocahua catli itztoyaj nechca itlancuaco itata, huan motlancuaquetzqui huan mohuijtzonqui tlalchi ica hueyi tlatlepanitacayotl iixpa itata. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Huan teipa José quinmatilanqui nopa ome itelpocahua huan quitlali Efraín ica inejmac huan Manasés ica iopoch, huan quinnechcahuilti campa itata, Israel. Quej nopa Efraín mocajqui ica iopoch Israel huan Manasés ica inejmac. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Pero quema Israel quixitlajqui imax, momanepano huan quitlali inejmac ipan itzonteco Efraín catli eliyaya teipan ejquetl, huan quitlali iopoch ipan itzonteco Manasés catli eliyaya achtihui ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Huajca Israel quintiochijqui quej ni: “Toteco Dios ma quintiochihua ni telpocame. Yaya nopa Dios catli ihuaya nejnenque notatahua Abraham huan Isaac, huan catli nechmocuitlahuijtoc nochi nonemilis. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Yaya catli quititlantoc itequihua catli nechmanahuijtinentoc ica nochi catli fiero. Yaya ma quintiochihua ni telpocame. Huan nochi masehualme ma quimatica inijuanti noaxcahua, huan iniaxcahua notatahua, Abraham huan Isaac. Ma quinpiyaca miyac ininconehua huan ma momiyaquilica ininteipan ixhuihua miyac ipan tlaltipactli.” ");
INSERT INTO nhwBl_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Pero José amo quipacti para itata quitlalijtoya inejmac ipan itzonteco Efraín huan quiitzquili imax para quiijcuinis huan quitlalis ipan itzonteco Manasés. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Quiilhui: ―¡Amo, papá! Ya ni catli achtihui ejquetl. Xijtlali monejmac ipan itzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Pero itata amo quinejqui quichihuas huan quiilhui: ―Nijmati, nocone, ya nijmati. Nojquiya iteipan ixhuihua mochihuase nelía miyac masehualme catli nochi quintlepanitase. Pero iicni teipan ejquetl elis más hueyi que ya huan iteipan ixhuihua iicni más momiyaquilise huan mochihuase miyac tlalme. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Huajca ipan nopa tonal Jacob quintiochijqui Efraín huan Manasés huan quinilhui: “Nochi sequinoc noteipan ixhuihua quitequihuise amotoca para tlatiochihuase huan quiijtose: ‘Toteco Dios ma mitzchihua hueyi quen quinchijqui Efraín huan Manasés.’ ” Quej nopa Israel quitlali para Efraín elis más hueyi huan teipa Manasés. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Teipa Israel quiilhui itelpoca, José: ―Xiquita, ya ajsitinemi nopa tonal para nimiquis, pero Toteco Dios itztos amohuaya huan quichihuas para sempa xiyaca ipan inintlal mohuejcapan tatahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Huan nimitzmacatoc ta nopa tlali catli más cuali que nopa catli niquinmacac moicnihua pampa más tihueyi. Yeca nimitzmaca catli niquinquixtili nopa amorreo masehualme ica nomachete huan nocuahuitol. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Huan Jacob quinnotzqui itelpocahua huan quinilhui: “Ximonechcahuica huan nimechilhuis catli anmechpanos teipa. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Noconehua, ximonechcahuica huan techcaquica. Na niJacob huan annoconehua. Techtlacaquilica niamotata, Israel. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ta Rubén, tinoachtihui cone. Tieliyaya tinochicahualis huan quema titlacatqui eltoya quen nopa achtihui iselca nofuerza. Tijpiyas miyac chicahualistli huan tlatlepanitacayotl. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Pero ayacmo tielis catli más tihueyi, pampa tiitztoc quen atl catli tehuahuatatza. Quej nopa eltoc pampa techpinahualti quema timotejqui ipan notlapech ihuaya notequipanojca. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeón huan Leví nelía anicnime pampa san se amonemilis. Amomachetes anquitequihuíaj san para tlahuilancayotl. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","¡Amo quema nijnequi nijcaquis amocamanal, niyon amo quema nimosentilis amohuaya! Pampa quema ancualaniyayaj, antemictijque, huan san pampa anquinejque, anquinmetzpostejque torojme. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","¡Tlatelchihualtic, quena, tlatelchihualtic amocualancayo, pampa annelfierojtique huan amo antlatlasojtlaj! ¡Nimechsemanas huan anitztose campa hueli ipan nochi tlali Israel! ");
INSERT INTO nhwBl_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Ta tiJudá, moicnihua mitzpaquilismacase. Huan tiquinitzquis mocualancaitacahua ininquechtla huan tiquintlanis. Hasta moicnihua motlancuaquetzase para mitztlepanitase. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ta tiJudá, tielis quen icone se tecuani catli mocuepa pactoc por nopa tlapiyali catli quimictijtoc. Tielis quen se león catli mopachohua huan moteca tlalchi, huan quichiya tlaque quiitzquis. Tielis quen se sihua león catli nelía quipiya fuerza. Amo aqui mitzcuesolmacas. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Amo aqui huelis quiquixtis nopa tlanahuatili catli moteipan ixhuihua quipiyase. Niyon quinquixtilis nopa tepos cuatopili catli quipiyase para ica tetlatzacuiltise. Quipiyase tequiticayotl para nochipa. Huan teipa hualas moteipan ixhui catli temacas tlasehuilistli. Yaya catli nelía iaxca nopa tepos cuatopili huan nopa tequiticayotl para tlanahuatis. Huan masehualme ipan nochi tlalme campa hueli quichihuase catli yaya quinilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Elis nelrico huan campa hueli oncas xocomeca mili catli iaxca. Quiilpis iburro ipan tlen hueli xocomeca tzontli catli quinequis, huan sintla quinequi, quiilpis ipilconeburrojtzi ipan nopa xocomeca macuayotl catli más cuali. Quipiyas miyac xocomeca atl hasta nesis quen huelis ica quichicuenis iyoyo. Quena, hasta mocahuas quipiyas iayo xocomecatl catli temacas nochi imil. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iixteyol elis más yayahuic que xocomeca atl, huan itlancochhua más chipahuac que lechi. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ta tiZabulón, moteipan ixhuihua itztose iteno hueyi atl, huan nopona ajsise miyac barcos. Motlal ajsis hasta tlali Sidón. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ta tiIsacar, moteipan ixhuihua elise tejtetique quen se tlapiyali catli quimati tlamama etic. Mosiyajquetzase campa quintzacuaj borregojme. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Quema quiitase quenicatza nelía cuali amotlal para ipan anmosiyajquetzase huan quenicatza nelía yejyectzi, huajca motlancuaquetzase huan mocuitlapantise para tlamamase. Huan niyon amo molinise moteipan ixhuihua quema quinchihuase ma tequipanoca san tlapic. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ta tiDan, ta huan moixhuihua antetlajtolsencahuase quen quinamiqui pampa anelise se hueyi familia ipan tlali Israel. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Moteipan ixhuihua elise quen se cohuatl catli itztoc ojtipa, huan quintzacanía inincotztla cahuayojme huan quintlahuisohua catli tlejcotoque ipan cahuayojme. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","¡TOTECO! Nijchiya para techmanahuis. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Ta tiGad, miyac soldados hualase huan quinhuilanase moteipan ixhuihua, pero teipa quintojtocatiyase. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ta tiAser, moteipan ixhuihua quipiyase tlacualistli catli cuali. Quena, temacase tlacualistli catli ajhuiyac quen catli quicuaj huejhueyi tlanahuatiani. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ta tiNeftalí, moteipan ixhuihua elise quen se masatl catli nemi campa quinequi huan catli quintlacatiltía yejyectzitzi pilconemasatzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Ta tiJosé, moteipan ixhuihua elise quen se cuali cuahuitl catli quitoctoque campa ameli. Temaca miyac itlajca huan imacuayohua moscaltía miyac hasta quionpano nopa tepamitl catli tilahuac. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Masehualme quincualancaitase moteipan ixhuihua, huan quinmajcahuilise cuatlamintli huan nochipa quinmacase tequipacholi. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Pero moteipan ixhuihua quiquetzase inincuahuitol xitlahuac, huan amo huihuipicase ininmax quema quitequihuise pampa elise tejtetique. Quena, tlatlanise pampa noTeco Dios, yaya catli quipiya nochi chicahualistli quinpalehuis. Yaya quinmocuitlahuis pampa yaya totlamocuitlahuijca tiisraelitame. Yaya nopa Hueyi Tetl catli techmanahuijtoc miyac huelta. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Quena, ma anmechpalehuis ininTeco mohuejcapan tatahua. Ma anmechtiochihua ta huan amoteipan ixhuihua yaya Toteco Catli Quipiya Nochi Chicahualistli. Ma quintiochihuas moteipan ixhuihua ica miyac tlatiochihualistli quen atl catli huala tlen huejcapa ipan ilhuicac, huan catli huala huejcatla ipan hueyi atl huan quichihuas ma moscaltis amomilhua. Ma quintiochihuas ta huan moteipan ixhuihua huan amosihuajhua. Ma anmechmacas miyac amoconehua catli moscaltise ica cuali. Ma tlahuel momiyaquilica amotlapiyalhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Quena, José, Toteco ma mitztiochihua, yaya catli noTeco na, nimotata. Ni tlatiochihuali momiyaquilis hasta ajsis ipan nopa tepeme catli huejcahuase para nochipa. Nochi ya ni elis nopa tlatiochihualistli catli ta tijpiyas, José, pampa Toteco mitziyocatlali tlen moicnihua para tielis tiinintlanahuatijca. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ta tiBenjamín, moteipan ixhuihua tlatlanise quen se tepechichi. Ica ijnaloc quicuase catli quimictijtoque, huan hasta tiotlac quipiyase catli mocajtoc para temajmacase.” ");
INSERT INTO nhwBl_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ya ni nopa 12 itelpocahua Israel huan nopa tlatiochihuali catli inintata quinmacac. Quinilhui catli quinamiqui para sesen quiselis pampa Toteco quinextili catli panos ica ininteipan ixhuihua sese inijuanti. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nojquiya Jacob quinmacac itelpocahua ni tlanahuatili: “San quentzi polihui para nimiquis. Techtlalpachoca ihuaya nohuejcapan tatahua ipan nopa tecacahuatl catli eltoc ipan itlal Efrón nopa heteo. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Quena, techtlalitij nopona ipan tlali Canaán ipan nopa tecacahuatl ipan nopa mila catli itoca Macpela, iixpa Mamre. Nopa catli Abraham quicohuili Efrón para ipan ma quintlalpachoca nochi iteiximatcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Nopona quintoctoque Abraham ihuaya isihua, Sara, huan Isaac huan isihua, Rebeca, huan nopona nijtlalpacho Lea. ");
INSERT INTO nhwBl_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nopa tlali huan nopa tecacahuatl catli eltoc nopona quincohuili nopa heteo tlacame.” ");
INSERT INTO nhwBl_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Huan quema Jacob tlanqui quinnahuatía itelpocahua, motejqui ipan itlapech huan mijqui. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Huajca José quinajnahuajqui itlacayo itata huan chicahuac chocac huan quitzoponi. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Teipa quinnahuati nopa itepajtijcahua ma quitlalilica tlaajhuiyacayotl catli pajyo ipan itlacayo itata para ma amo palani. Huan quej nopa quichijque. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Huan quitlalilijque nopa pajtlaajhuiyacayotl 40 tonali pampa monejqui quitlamiltise nopa tonali para amo palanis. Huan nopa egiptome quichoquilijque Israel 70 tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Teipa quema panoc nopa choquistli, José quincamanalhui itlapalehuijcahua ipan ichaj Faraón huan quinilhui: ―Se favor, xijcamanalhuica Faraón tlen na huan xiquilhuica ");
INSERT INTO nhwBl_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","para quema notata miquiyaya, nechchijqui ma nijtestigojquetza Toteco Dios para nijtlalpachosquía ipan se tecacahuatl catli iaxca tofamilia ipan tlali Canaán. Huajca xijtlajtlanica ma nechcahuili ma niya tlali Canaán nijcahuati notata. Huan quema nijtlalpachos, nimocuepas. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Huan nopa Faraón tlananquili para quena huan quiilhui José: ―Xiya xijtlalpachoti motata quen ya mitzilhui. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Huan José yajqui quitlalpachoto itata. Huan ihuaya yajque nochi nopa tlacame catli quihuicaque tequiticayotl para tlanahuatise ihuaya José. Huan nojquiya yajque catli quipixque tlanahuatili ipan ichaj Faraón huan ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Huan yajque nochi iicnihua José ininhuaya nochi iteiximatcahua itata. Ipan tlali Gosén san quincajtejque ininconehua huan inintlapiyalhua. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nojquiya yajque miyac masehualme ipan cuacarros huan ipan cahuayojme ihuaya José. Elque tlahuel miyac masehualme catli yajque. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Huan quema ajsitoj campa quiyolquixtíaj trigo ipan Atad nechca nopa hueyatl Jordán, nochi quipixque se hueyi choquistli huan ica miyac tequipacholi José quichoquili itata para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Huan quema nopa cananeos catli ejque nopona quiitaque para nelía chocayayaj campa tlayolquixtía campa itoca Atad, quiijtojque: “Tlahuel hueyi inintequipachol nopa egiptome.” Huan yeca quitocaxtijque Abel Mizraim. (Abel Mizraim quinequi quiijtos “campa nopa egiptome chocaque”.) Abel Mizraim mocahua nechca hueyatl Jordán para campa temo tonati. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Huan itelpocahua Jacob quichijque ica inintata nochi catli ya quintlajtlanijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Quihuicaque ipan tlali Canaán huan quitlalpachojque ipan nopa tecacahuatl catli eltoc ipan mila Macpela nechca Mamre catli Abraham quicohuilijtoya Efrón, nopa heteo tlacatl, para ipan quintlalpachosquíaj nochi iteiximatcahua. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Teipa quema ya quitlalpachojtoyaj inintata, José mocuepqui tlali Egipto ihuaya iicnihua huan nochi sequinoc catli ihuaya yajtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quema iicnihua José momacaque cuenta para inintata Jacob ya mictoya, moilhuijque: “Nohueli José techcualancaitas huan quinequis techcuepilis ica catli fiero tijchihuilijque huejcajya.” ");
INSERT INTO nhwBl_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Huajca tlatitlanque ma quiilhuitij: “Quema totata ayamo miquiyaya, ");
INSERT INTO nhwBl_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","technahuati ma timitzilhuica, xijchihuili se favor huan techtlapojpolhui totlajtlacol timoicnihua quema timitzchihuilijque catli fiero. Huan tojuanti nojquiya timitztlajtlaníaj techtlapojpolhui catli timitzchihuilijque. Ama tijtequipanohuaj Toteco Dios catli totata quitoquili.” Huan José chocac quema quicajqui ni tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Huan teipa ajsicoj iicnihua huan mohuijtzonque iixpa ica tlatlepanitacayotl huan quiilhuijque: ―Nica techpixtoc para timoaxcahua. Timitztequipanose san tlapic. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Pero José quinilhui: ―Amo ximajmahuica. Na amo niDios para nimechtlatzacuiltis. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Melahuac anquinequiyayaj antechchihuilise catli nelía amo cuali, pero Toteco Dios quisencajqui para ica catli fiero antechchihuilijque, yaya quichihuasquía se tlamantli catli onpano cuali. Yaya quinequiyaya quimanahuis ininnemilis miyac masehualme huan ya nopa catli ama anquiitaj pano. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Huajca amo ximajmahuica. Nimechmacas amojuanti huan amoconehua catli anquicuase. Huan José quincamanalhui ica teicnelijcayotl huan quej nopa quinyoltlali. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Huan José ihuaya nochi iteiximatcahua noja mocajque ipan tlali Egipto huan yaya amo mijqui hasta quipixqui 110 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","José itztoya hasta iconehua Efraín quinpixque iniixhuihua. Nojquiya itztoya hasta Maquir, icone Manasés, quinpixqui iconehua. Quena, iixhuihua Manasés mahuiltijque iicxitla ininhueyi tata José. ");
INSERT INTO nhwBl_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Huan se tonal José quinilhui iicnihua: “San nechpolohua quentzi para nimiquis, pero teipa Toteco Dios hualas anmechpalehuis huan anmechquixtis tlen ni tlali para anmechhuicas ipan nopa tlali catli quintencahuili Abraham, Isaac huan Jacob para quinmacas.” ");
INSERT INTO nhwBl_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Huajca José quincamanalhui iicnihua catli nojquiya itztoyaj itelpocahua Israel quen ya. Huan quinchihualti ma quitestigojquetzaca Toteco para quihuicase iomiyohua ininhuaya quema ajsis tonal para quisase tlen tlali Egipto. Quinilhui: “Quema Toteco Dios hualas huan anmechhuicas sempa ipan tlali Canaán, monequi anquihuicase noomiyohua amohuaya.” ");
INSERT INTO nhwBl_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Huajca José mijqui ipan tlali Egipto quema quipiyayaya 110 xihuitl huan itlacayo quipajtijque ica pajtlaajhuiyacayotl para amo palanisquía. Huan quitlalijque ipan se cuacajo ipan tlali Egipto.");
INSERT INTO nhwBl_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Nopa tlacatl catli itoca Israel yajqui ipan tlali Egipto ihuaya 12 itelpocahua, huan sese inijuanti nojquiya quihuicac ifamilia. Huan ya ni inintoca itelpocahua Jacob catli ihuaya yajque tlali Egipto: ");
INSERT INTO nhwBl_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubén, Simeón, Leví, Judá, ");
INSERT INTO nhwBl_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isacar, Zabulón, Benjamín, ");
INSERT INTO nhwBl_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Neftalí, Gad huan Aser. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Huan nochi iteiximatcahua Jacob catli yajque mochijque 70 masehualme. Pero seyoc itelpoca catli itoca José ya itztoya ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Huan ica miyac xihuitl mijqui José, huan iicnihua huan nochi nopa masehualme catli achtihui hualajtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Pero teipa iniixhuihua quinpixque miyac ininconehua huan motocaxtiyayaj israelitame. Huan nopa israelitame tlahuel momiyaquilijtiyajque hasta mochijque tlahuel miyaqui masehualme huan campa hueli itztoyaj ipan Gosén ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Huan teipa panoc miyac xihuitl huan pejqui tequiti se yancuic tlanahuatijquetl ipan tlali Egipto catli amo quema quiiximajtoya José. Huan nopa yancuic tlanahuatijquetl quinilhui nopa egiptome: ");
INSERT INTO nhwBl_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","“Xiquitaca, nopa israelitame mochijtoque nelmiyaqui masehualme huan más quipiyaj chicahualistli que tojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Huajca monequi tijchihuase se tlenijqui para ayacmo ma momiyaquilica, pampa sintla oncas se tlahuilancayotl, huelis mosansejcotilise ica tocualancaitacahua para techhuilanase huan teipa cholose tlen ni tlali.” ");
INSERT INTO nhwBl_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Huan yeca nopa egiptome quintlalijque tlacame catli tetique para ma quinfuerzajhuica israelitame ma tequitica tlahuel chicahuac. Quinchihualtijque ma quisencahuaca nopa altepeme Pitón huan Ramesés para nopa hueyi tlanahuatijquetl Faraón. Huan quintequihuijque nopa altepeme para ipan quiajocuise tlacualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Pero quema noja más quintlaijiyohuiltiyayaj israelitame, noja más momiyaquiliyayaj. Yeca nopa egiptome pejque más quinimacasij. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Huajca nopa egiptome tlahuel quintequihuijque nopa israelitame huan amo quintlasojtlaque. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Tlahuel amo quinpatiitayayaj. San quintequihuiyayaj chicahuac huan quintlaijiyohuiltiyayaj miyac. Quinchihualtijque ma quicualtlalica soquitl huan ma quichihuaca ladrillos huan miyac tlamantli miltequitl. Huan quema tlahuel tlaijiyohuiyayaj nopa israelitame ipan nochi ni tequitl, noja más nopa egiptome quinchihuilijque fiero. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Nojquiya nopa hueyi tlanahuatijquetl quincamanalhui Sifra huan Fúa, nopa sihuame catli quinitayayaj israelita sihuame quema conepiyayayaj huan quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","―Quema anquipalehuise se hebreo sihuatl catli conepiyas, ximomacaca cuenta tlaque tlacajtoc. Sintla tlacajtoc se sihuapil, xijcahuaca ma itzto, pero sintla se oquichpil, xijmictica. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Pero masque quej nopa quinilhui nopa tlanahuatijquetl, nopa sihuame quiimacasque Toteco Dios huan amo quichijque catli nopa tlanahuatijquetl quinnahuatijtoya. Quincajque ma itztoca nopa oquichpilme. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Huajca nopa tlanahuatijquetl tlen Egipto tlatitlanqui ma quinnotzatij nopa ome sihuame huan quintlatzintoquili: ―¿Para tlen anquincahuilíaj ma itztoca hebreo oquichpilme? ¿Para tlen amo anquinmictíaj? ");
INSERT INTO nhwBl_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Huan nopa sihuame quinanquilijque Faraón: ―Nopa hebreo sihuame amo tlatlacatiltíaj yolic quen egipto sihuame. Más cuali inintlacayohua huan nimantzi tlatlacatiltíaj quema tojuanti ayamo tionajsij para tiquinpalehuise. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Huan pampa nopa sihuame quitlepanitaque Toteco Dios, yaya quintiochijqui huan quinchijqui nojquiya ma quinpiyaca ininconehua. Huan nopa hebreos o israelitame más momiyaquilijque hasta mochijtoyaj tlahuel miyaqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Huajca Faraón quinmacac se tlanahuatili nochi imasehualhua: “Nochi hebreo oquichpilme catli tlacatise monequi xiquinmajcahuaca ipan hueyatl, pero sihuapilme xiquincahuaca ma itztoca.” ");
INSERT INTO nhwBl_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Se tonal se tlacatl catli eliyaya se iteipan ixhui nopa huejcapan tata Leví mosihuajti ihuaya se sihuatl catli nojquiya eliyaya se iteipan ixhui, pero ipan seyoc familia. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Huan isihua conecuic huan quipixqui se icone. Huan quema quiitaque para nopa oquichpil eliyaya yejyectzi, quitlatijque para eyi metztli. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Pero quema itatahua ayacmo huelque quitlatíaj más tonali, quicuique se chiquihuitl catli quichijtoya ica acatl, huan inana quitzajtzajqui ica chapopojtli para ma amo calaqui atl. Teipa quitlali nopa pilconetzi iijtic nopa chiquihuitl huan quicahuato acatzala iteno nopa hueyatl Nilo. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nojquiya quiilhui ihuelti nopa pilconetzi ma quihuejcaita para ma quimati tlaque panosquía. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Huan más tiotlac, iichpoca nopa Faraón ininhuaya itequipanojcahua temoque para maltitij ateno. Huan quema nejnemiyayaj nechca hueyatl, quiitaque nopa chiquihuitl tlatlajco acame. Huajca nopa ichpocatl quititlanqui se isihua tequipanojca ma quihualiquili nopa chiquihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Huan quitlapo nopa acachiquihuitl huan quitlachili iijtic. Huan nopona itztoya se piloquichpiltzi catli chocayaya. Huan iichpoca Faraón quitlasojtlac huan quiijto: ―Ni se piloquichpiltzi hebreo. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Huajca iicni nopa pilconetzi monechcahui campa iichpoca Faraón huan quiilhui: ―¿Tijnequi ma nijnotzati se hebreo sihuatl catli tlachichitía para ma quiiscalti ni oquichpil? Huan iichpoca Faraón tlananquili: ");
INSERT INTO nhwBl_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","―Quena, xijnotzati. Huajca iicni nopa pilconetzi yajqui quinotzato inana, ");
INSERT INTO nhwBl_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","huan iichpoca Faraón quiilhui: ―Xijhuica ni oquichpil huan techchichitili, huan na nimitztlaxtlahuis motequi. Huajca inana nopa piloquichpiltzi quihuicac huan quiiscalti. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Huan quema ya moscaltijtoya, quimactili iichpoca Faraón. Huan nopa ichpocatl quichijqui icone huan quitocaxti Moisés. (Moisés quinequi quiijtos “tlaquixtili”.) Quej nopa quitocaxti pampa quiijto: ―Na nijquixti ipan atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Se tonal quema Moisés ya motlacachijtoya, quisqui para quinpaxaloti nopa hebreos pampa quimatqui para san se estli quipixqui ininhuaya huan momacac cuenta para nelohui inintequi. Huan quiitac se tlacatl Egipto ejquetl quihuitequiyaya se tlacatl hebreo huan quitlasojtlac, pampa eliyaya san se inieso. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Huajca Moisés tlachixqui campa hueli huan quema amo aqui quiitac, quimicti nopa tlacatl Egipto ejquetl huan quitlati itlacayo ipan xali. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Huan hualmostla sempa quisqui Moisés huan quiitac para ome hebreos mohuilanayayaj, huajca quitlatzintoquili catli tlahuilanayaya: ―¿Para tlen tijmaquilía mohuampox huan san se amoeso anquipiyaj? ");
INSERT INTO nhwBl_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Huan nopa hebreo tlacatl quinanquili: ―¿Ajqueya mitztlalijtoc ta quen titlayacanquetl o tijuez ica tojuanti? ¿Huelis timoilhuía techmictis quen yalohua tijmicti nopa Egipto ejquetl? Quema Moisés quicajqui ni tlamantli, majmajqui, pampa momacac cuenta para sequin quimatiyayaj para quimictijtoya nopa tlacatl Egipto ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Huan quema Faraón quimatqui para Moisés quimictijtoya se tlacatl Egipto ejquetl, tlatitlanqui ma quitemotij para quimictis, pero Moisés cholojtejqui huan yajqui itztoti ipan tlali Madián. Huan quema ajsito nepa mosehuito nechca se ameli. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Huan nopona ipan tlali Madián itztoya se totajtzi catli itoca Reuel huan quinpixtoya chicome iichpocahua. Huan ipan nopa tonal inijuanti ajsitoyaj campa nopa ameli para quiquixtise atl huan quitemitise campa atlij tlapiyalme huan quinamacase inintata iborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pero hualajque sequinoc borrego tlamocuitlahuiani huan quintojtocaque nopa ichpocame. Huajca Moisés motlananqui, huan quinmanahui huan teipa quinamacac ininborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Huan quema nopa ichpocame mocuepque campa itztoya inintata Reuel ya quintlatzintoquili: ―¿Quenicatza ama anmocuepque nimantzi? ");
INSERT INTO nhwBl_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Huan tlananquilijque: ―Se Egipto ejquetl techmanahui ininmaco nopa sequinoc tlamocuitlahuiani. Huan teipa yaya quiquixti atl para tojuanti huan quinamacac toborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Huan inintata quintlatzintoquili: ―Huan ¿canque itztoc nopa tlacatl? ¿Para tlen anquicajtejque iseltzi? Xiyaca xijnotzati ma tlacuaqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Huan Moisés hualajqui huan mocajqui ipan ichaj Reuel. Huan teipa Reuel quimacac Moisés iichpoca catli itoca Séfora para isihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Huan teipa Séfora quipixqui icone huan Moisés quitocaxti Gersón. (Gersón quinequi quiijtos “seyoc tlali ejquetl”.) Pampa quiijto: “Ama nise seyoc tlali ejquetl ipan ni tlali catli amo niquiximati.” ");
INSERT INTO nhwBl_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Huan Moisés panoc miyac xihuitl ipan tlali Madián, huan ipan tlali Egipto mijqui nopa tlanahuatijquetl. Pero nopa israelitame noja tlahuel tlaijiyohuiyayaj huan motequipachohuayayaj pampa tequipanohuayayaj san tlapic. Huan tlatoctzitzi quitlajtlaniyayaj Toteco Dios ma quinpalehui ipan inintlaijiyohuilis. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Huan Toteco quincajqui. Quena, quinchihuili cuenta pampa amo quielcajqui catli ininca mocajtoya Abraham, Isaac huan Jacob para quinmacas iniixhuihua se tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Huajca Toteco Dios quinitac nopa israelitame huan quintlasojtlac. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Se tonal Moisés quinmocuitlahuiyaya iborregojhua imonta, Jetro 3:1 Jetro nojquiya itoca Reuel., catli eliyaya se totajtzi ipan tlali Madián. Huan Moisés quinhuicac nopa borregojme hasta ne seyoc lado nopa huactoc tlali hasta se tepetl itoca Horeb 3:1 Nopa tepetl Horeb nojquiya itoca tepetl Sinaí.. (Horeb quinequi quiijtos “nopa tepetl campa Toteco itztoc”.) ");
INSERT INTO nhwBl_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Huan nopona itequihua TOTECO monexti ipan se tlilelemectli catli tlatlayaya tlatlajco se xihuitzontli. Huan Moisés momacac cuenta para nopa xihuitzontli lemeniyaya, pero amo tlamiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Huajca moilhui: “Amo quema niquitztoc se tlamantli quej ni. Niyas niquitati para tlen amo tlamitlatla nopa xihuitzontli.” ");
INSERT INTO nhwBl_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Huan quema TOTECO quiitac para Moisés monechcahuiyaya para quitlachilis, quinojnotzqui tlatlajco tlen nopa xihuitzontli huan quiilhui: ―¡Moisés! ¡Moisés! Huan Moisés quiijto: ―Nica niitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Huajca TOTECO quiilhui: ―Amo ximonechcahui. Ximotecacquixti pampa tlatzejtzeloltic ni tlali campa timoquetza, pampa nica nojquiya niitztoc na. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Huan TOTECO nojquiya quiilhui: ―Na niininTeco mohuejcapan tatahua Abraham, Isaac huan Jacob. Huajca Moisés moixtzajqui pampa majmajqui para quitlachilis Toteco Dios, ");
INSERT INTO nhwBl_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","huan TOTECO sempa quiijto: ―Niquitztoc quenicatza tlaijiyohuíaj nomasehualhua catli itztoque ipan tlali Egipto. Nijcactoc quen chocaj pampa inintlayacancahua fiero quinchihuilíaj. Niquintlasojtla pampa tlahuel tlaijiyohuíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Yeca nitemotoc para niquinmaquixtis ininmaco nopa egiptome. Huajca niquinquixtis ipan nopa tlali huan niquinhuicas hasta se tlali catli hueyi huan cuali catli nochi temaca hasta onmocahua itlajca. Ipan nopa tlali ama itztoque nopa cananeos, heteos, amorreos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Huajca pampa nijtlacaquilijtoc quen nechtzajtzilíaj nopa israelitame, huan niquitztoc quen nopa egiptome fiero quinchihuilíaj, ");
INSERT INTO nhwBl_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ama nimitztitlanis tiquitati Faraón. Nijnequi tiyas para tiquinquixtis nopa israelitame tlen tlali Egipto pampa inijuanti nomasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Huajca Moisés quiilhui Toteco Dios: ―¿Pero ajqueya na para niyas nijcamanalhuiti Faraón huan niquinquixtiti tlen tlali Egipto nopa israelitame? ");
INSERT INTO nhwBl_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Huan Toteco Dios quinanquili: ―Na niitztos mohuaya. Huan ya ni elis se tlanextilijcayotl para huelis tijmatis temachtli para naya catli nimitztitlani. Quema ya tiquinquixtijtos nomasehualhua ipan tlali Egipto, anmocuepase nica huan nochi amojuanti antechhueyichihuase ipan ni tepetl Horeb. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Pero Moisés quinanquili: ―Pero sintla niyas huan niquinilhuis nopa israelitame para yaya catli ininTeco amohuejcapan tatahua nechtitlantoc campa amojuanti, nechtlatzintoquilise ¿quenicatza motoca? Huan huajca, ¿tlaque niquinilhuis? ");
INSERT INTO nhwBl_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Huan Toteco Dios quinanquili: ―NAYA NIITZTOC CATLI NOCHIPA NIITZTOC. Huan tiquinilhuis nopa israelitame: Yaya catli itoca YAYA CATLI NOCHIPA ITZTOC nechtitlantoc campa amojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Huan nojquiya Toteco Dios quiilhui Moisés: ―Nojquiya xiquinilhui nopa israelitame para naya catli niininTECO amohuejcapan tatahua, Abraham, Isaac huan Jacob, mitztitlantoc campa inijuanti. Xiquinilhui ya ni elis notoca para nochipa. Ya ni nochipa eliyaya notoca huan nochipa elis notoca. Ica ni notoca nechnotzase para nochipa nochi masehualme catli tlacajtiyase. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Xiya huan xiquinsentili nochi huehue tlacame ipan nopa israelitame huan xiquinilhui para na niDIOS catli niininTeco amohuejcapan tatahua, Abraham, Isaac huan Jacob, nimonexti campa ta. Huan nimitzilhui para niquinhualtlachilijtoc huan niquitztoc quenicatza fiero quinchihuilíaj ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Huan nojquiya xiquinilhui para niquintencahuilía niquinquixtis tlen nopa tlaijiyohuilistli ipan Egipto, huan niquinhuicas ipan nopa tlali campa itztoque nopa cananeos, heteos, amorreos, ferezeos, heveos huan jebuseos. Campa niquinhuicas eltoc se tlali catli nochi temaca hasta onmocahua itlajca. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Huan temachtli nopa huehue tlacame mitzneltocase. Huan teipa monequi tiyas ininhuaya para anquiitatij nopa hueyi tlanahuatijquetl tlen tlali Egipto. Huan tiquilhuis para na niDIOS catli niamoTECO anhebreo masehualme huan para na nimonexti mohuaya. Xiquilhui monequi quincahuas ma yaca israelitame ipan nopa huactoc tlali campa amo tleno eli. Xiquilhui monequi anyase eyi tonali ipan ojtli para antechmacatij tlacajcahualistli na, niamoTECO Dios. Quej nopa xiquilhuiti. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Pero na cuali nijmati para nopa tlanahuatijquetl tlen tlali Egipto amo anmechcahuas anquisase hasta nijnextilis para nelía hueyi nochicahualis. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yeca na nimomaxitlahuas huan niquincocos nopa egiptome ica miyac huejhueyi tiochicahual nextili catli nijchihuas ipan inintlal para niquinnextilis nohueyi chicahualis. Huan teipa, quena, nopa Faraón anmechcahuas para anquisase. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nojquiya nijchihuas para nopa egiptome ma quinequica anmechpalehuise huan anmechmajmacase tlamantli quema anquisase. Yeca quema anquisase, amo anyase san amomax. ");
INSERT INTO nhwBl_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Huan monequi sesen sihuatl quitlajtlanis catli icalnechca o seyoc catli ihuaya itztoc para ma quimaca yoyomitl catli cuali huan tlamantli tlen oro huan plata. Huan xiquinyoyontise amoconehua para quej nopa anquintlaquijquixtilijtehuase Egipto ehuani nochi catli quipixtoque.” ");
INSERT INTO nhwBl_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Huan Moisés tlananquili: ―¿Tlaque nijchihuas sintla nopa israelitame amo nechneltoquilise, niyon amo nechchihuilise cuenta? Huelis san quiijtose para ta, TOTECO, amo timonextijtoc nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Huajca TOTECO quiilhui Moisés: ―¿Tlaque tijpiya momaco? Huan Moisés tlananquili: ―Se cuatopili. Huan TOTECO quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","―Xijmajcahua tlalchi. Huan Moisés quimajcajqui tlalchi huan ipan nopa tlatoctzi nopa cuatopili mochijqui se cohuatl. Huan Moisés motlalojtejqui pampa quiimacasiyaya, ");
INSERT INTO nhwBl_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","pero TOTECO quiilhui: ―Xiquitzqui ipan icuitlapil. Huan Moisés quiitzqui nopa cohuatl huan mocuepqui sempa cuatopili. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Huan TOTECO quiilhui: ―Quej nopa tijchihuas iniixpa nopa israelitame para ma quineltocaca para naya catli niininTeco amohuejcapan tatahua, Abraham, Isaac huan Jacob nimonextijtoc moixpa para nimitztequimacas. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Huan TOTECO quiilhui: ―Huan ama, xijcalaqui momax moyolixco. Huan Moisés quicalaqui imax iyolixco huan quema quiquixti, quiitac para quipiyayaya nopa fiero tlacayo palanca cocolistli catli itoca lepra huan eliyaya chipahuac quen sitlal setl. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Huajca TOTECO quiilhui: ―Sempa xijcalaqui momax moyolixco. Huan Moisés quej nopa quichijqui. Huan quema sempa quiquixti imax, ya mochicajtoya huan eltoya cuali quen nochi itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Huajca TOTECO quiilhui: ―Sintla ica nopa achtihui tlanextilijcayotl, amo mitzneltoquilise, huajca mitzneltocase ica nopa catli ompa. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Pero sintla amo mitzneltocase ica ni ome tlanextili, xijquixti atl tlen nopa hueyatl huan xijtoyahua tlalchi. Huan quema nopa atl catli tijquixtis ipan hueyatl toyahuis tlalchi, mocuepas estli. Huan Moisés quiilhui TOTECO: ");
INSERT INTO nhwBl_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","―¡Ay, Toteco! Na amo hueli nitlatenquixtía cuali. Huan amo san ama o yalohua amo nihueli. Ni huejcajya. Nochipa quema nicamanalti, ohui quisa camanali ipan nonenepil, pampa nitencuatacani. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Pero TOTECO quiilhui: ―Naya niquinmacatoc inincamac masehualme. Naya nijchihua para se ma amo huelis camanaltis, o ma amo huelis tlacaquis. Nijchihua para se ma tlachiyas, o ma amo tlachiyas. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Huajca xiya huan na niitztos mohuaya quema ticamanaltis, huan nimitznextilis catli monequi tiquijtos. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Huan Moisés sempa quiijto: ―¡Ay, Toteco! Xijchihua se favor, xijtitlani seyoc huan amo na. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Huajca TOTECO cualanqui ihuaya Moisés huan quiilhui: ―¿Tiquita cualtitoc para yas mohuaya moicni Aarón catli nojquiya iixhui mohueyi tata Leví? Na nijmati para ya cuali camanalti. Huan ama huala ipan ojtli mitznamiquiqui. Yaya paquis miyac quema mitzitas. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Huajca xijcamanalhui huan xijpohuili nochi catli monequi quiijtos, huan yaya camanaltis catli tijpohuilis. Huan na niitztos amohuaya quema ancamanaltise huan nimechnextilis catli monequis anquichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ta tiquilhuis Aarón catli monequi quiijtos huan Aarón quinilhuijtiyas sequinoc catli ta tiquilhuis. Yaya camanaltis catli ta ticamanaltisquía huan mitztlepanitas quen tiitztosquía ta tiDios. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Pero xijhuica ni cuatopili ipan momax pampa ica ya ni tijchihuas tlanextilijcayotl catli huejhueyi. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Huajca Moisés mocuepqui ichaj imonta Jetro, huan quiilhui: ―Techcahua ma nimocuepa tlali Egipto campa itztoque noicnihua catli san se estli tijhuicaj. Nijnequi niquitas sintla noja itztoque. Huan Jetro tlananquili: ―Xiya ica cuali. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","TOTECO quiilhui Moisés quema noja itztoya ipan tlali Madián: ―Amo ximajmahui ximocuepa ipan tlali Egipto, pampa ya mijque nochi catli quinequiyayaj mitzmictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Huajca Moisés quincuitejqui isihua huan icone huan quinsehuilti ipan se burro huan mocuepqui tlali Egipto. Huan ipan imax quihuicayaya nopa cuatopili catli Toteco Dios quimacac. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Huan teipa TOTECO quiilhui Moisés: ―Quema tiajsiti tlali Egipto, xiquita para tijchihuas iixpa Faraón nochi nopa tlanextilijcayotl catli nimitzmacatoc chicahualistli xijchihua. Pero na nijyoltetilis para amo quincahuas ma quisaca israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Huajca tiquilhuis Faraón para na niamoTECO niquijtohua para nopa israelita masehualme niquinicnelía quen se quiicnelía icone achtihui ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Huan xiquilhui para ya niquilhuijtoc ma quincahua ma quisaca para yase nechhueyichihuatij. Pero sintla amo quincahuas ma quisaca, na nijmictis icone achtihui ejquetl. Quej nopa xiquilhuiti Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Huan quema mosiyajquetztoya Moisés huan iteiximatcahua nopa tlayohua ipan ojtli para tlali Egipto, TOTECO monexti ica Moisés, huan quinequiyaya quimictis pampa amo quichijqui quen quiijtohua tlanahuatili. Amo quipiltzontequilijtoya iyecapa nopa cuetlaxtli catli eltoc ipan ipiltlacayo ioquichpil. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Huajca isihua Moisés catli itoca Séfora quicuic se cuchillo tlen tetl huan quipiltzontequili catli monequi ipan ipiltlacayo icone huan quitoxonqui ipan iicxi Moisés huan quiilhui: “Nelía, ta tise nohuehue catli espoltic.” ");
INSERT INTO nhwBl_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Huajca TOTECO ayacmo cualanqui ica Moisés huan quicahuili ma yohui. Huan Séfora quitocaxti Moisés “nohuehue catli espoltic” pampa monejqui yaya quitzontequilis icuetlaxo icone. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nojquiya TOTECO quiilhuijtoya Aarón para ma yas ipan nopa huactoc tlali para mopantiti ihuaya Moisés. Huajca Aarón yajqui quinamiquito Moisés ipan nopa tepetl campa monextijtoya Toteco Dios. Huan nopona Aarón quitlajpalo huan quitzoponi. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Huan Moisés quipohuili Aarón nochi tlamantli catli TOTECO quiilhuijtoya ma quiijto, huan nojquiya quinextili nopa huejhueyi tlanextilijcayotl catli quinahuatijtoya ma quichihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Huajca Moisés huan Aarón ajsitoj tlali Egipto huan quinsentilijque nopa huehue israelita tlacame. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Huan Aarón quinpohuili nochi catli TOTECO quiilhuijtoya Moisés, huan quichijqui nopa tlanextilijcayotl catli TOTECO quinextilijtoya ma quichihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Huan nochi nopa tlacame quineltocaque para TOTECO quintitlantoya. Huan quema quimatque israelita masehualme para TOTECO quinchihuilijtoya cuenta huan quinitztoya quen tlaijiyohuiyayaj, motlancuaquetzque iixpa TOTECO huan quihueyichijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Teipa Moisés huan Aarón yajque quicamanalhuito nopa Faraón huan quiilhuijque: ―TOTECO Dios catli tiisraelitame tijhueyichihuaj mitzilhuía para xiquincahua imasehualhua ma yaca campa huactoc tlali para ma quiilhuichihuilitij. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pero Faraón tlananquili: ―¿Huan ajqueya ‘amoTECO’ para na ma nijneltoquili huan ma niquincahua ma yaca ne israelitame? Amo niquiximati amoTECO, huan niyon amo niquincahuas ma yaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Huajca Moisés huan Aarón quiijtojque: ―Toteco Dios catli toTeco tihebreos hualajtoc technamiquiqui huan techilhuijtoc catli monequi ma tijchihuaca. Huajca techcahua ma tiyaca eyi tonali ipan ojtli ipan nopa huactoc tlali para tijmacatij tlacajcahualistli TOTECO Dios, pampa sintla amo, nohueli timiquise ica se hueyi cocolistli o ica machete. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pero nopa tlanahuatijquetl tlen tlali Egipto quinilhui Moisés huan Aarón: ―¿Para tlen anquintequipolohuaj ni tlacame? Ma mocuepaca ipan inintequi. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Huan nojquiya nopa Faraón quinilhui: ―Ama itztoque tlahuel miyaqui israelitame ipan ni tlali, huan san anquintequipolohuaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Huajca ipan nopa tonal Faraón quinmacac se yancuic tlanahuatili nopa tlayacanani catli quinnahuatiyayaj huan quinhuijhuitequiyayaj nopa israelita tlatequipanohuani. Quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","―Ayacmo xiquinmacaca sacatl israelitame para ma quichihuaca soqui ladrillos quen mochijtihualajtoc. Ma yaca inijuanti para quisentilitij nopa sacatl catli monequi. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Pero xiquinfuerzajhuica ma temactilica san se imiyaca ladrillos quen achtihui. Niyon se ladrillo ma amo polihui. Pampa nopa israelitame tlatzcacalactoque huan yeca tlahuejchihuaj huan quiijtohuaj quinequij yase quimacatij tlacajcahualistli ininTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Huajca xiquinchihualtica ma tequitica más chicahuac nopa tlacame. Xiquintequihuica para ma amo quichihuilica cuenta ni istlacatili catli Moisés huan Aarón quinilhuíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Huajca nopa tlayacanani huan tecojme quisque huan yajque quinilhuitoj nopa israelitame: ―Nopa Faraón tlanahuatijtoc ma ayacmo timechmacaca sacatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ama monequi anyase anquitemotij. Pero monequi anquitlamichihuase san se imiyaca ladrillos quen anquichihuayayaj achtihuiya. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Huajca nopa israelitame campa hueli yajque ipan tlali Egipto quitemotoj sacatzomitl catli mocajtoya quema masehualme quitzontectoyaj sacatl, huan ya nopa quitequihuijque pampa ayacmo oncayaya sacatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","14","Huan mojmostla itlayacancahua Faraón quinisihuiltiyayaj más huan quinilhuiyayaj: ―Xijtlamichihuaca san se imiyaca amotequi ipan se tonal quen quema anmechmacayayaj sacatl. Huan nojquiya nopa Egipto tecojme quinmaquiliyayaj israelita tlayacanani huan quinilhuiyayaj: ―¿Quenicatza, niyon yalohua, niyon ama, amo anquiaxitijtoque san se imiyaca ladrillos quen achtihuiya anquichihuayayaj? ");
INSERT INTO nhwBl_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Huan nopa israelita tlayacanani yajque tlajtlanitoj tlapalehuili ica tlanahuatijquetl Faraón, huan quiilhuijque: ―¿Para tlen quej ni techchihuilía? ");
INSERT INTO nhwBl_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nopa Egipto tecojme ayacmo techmaca sacatl. Huan amo san ya nopa, nojquiya technahuatíaj ma tijchihuaca san se imiyaca soqui ladrillos, huan hasta techmaquilíaj pampa amo tihuelij. Pero inijuanti inintlajtlacol, pampa amo techmacaj sacatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Huajca Faraón quinnanquili: ―¡San antlatzihuini! ¡Quena, antlatzihuij! Huan yeca anquiijtojtinemij anyase anquimacatij tlacajcahualistli amoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Xiyaca xitequititij, huan masque ayacmo anmechmacase sacatl, monequi antemactilise san se imiyaca ladrillos. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Huan nopa tlayacanani tlen israelitame motequipachojque quema quinilhuijque para monequi ma amo temosquía imiyaca nopa soqui ladrillos quen achtihuiya quichihuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Huan quema quisque iixpa Faraón, quinpantitoj Moisés huan Aarón quinchixtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Huan nopa israelita tlayacanani quinilhuijque: ―TOTECO ma quiita catli amo cuali anquichijtoque ica tojuanti, huan ma anmechtlatzacuilti. Amojuanti amotlajtlacol para itequiticahua Faraón ma techtlachilica fiero. Eltoc quen anquitlalijtoque machete ipan ininmax para ma techmictica ica catli anquiilhuijtoque nopa tlanahuatijquetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Huajca Moisés motlatlajti huan quiilhui TOTECO: ―Toteco, ¿para tlen tiquinchihuilía catli amo cuali ni masehualme? ¿Para tlen techtitlanqui? ");
INSERT INTO nhwBl_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Hasta nopa tonal quema nihualajqui nijcamanalhuico nopa Faraón quen techilhui, yaya noja más quintlaijiyohuiltijtoc momasehualhua, huan ta amo tleno tijchijtoc para tiquinmaquixtis. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Huan TOTECO quinanquili: ―Ama tiquitas catli nijchihuas ica Faraón. Amo quincahuas nomasehualhua ma quisaca ipan ni tlali hasta quiitas ihueyitilis nochicahualis. Pero quema quiitas nochicahualis, hasta quintojtocas ma quisaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Huan noja Toteco Dios quicamanalhui Moisés huan quiilhui: ―NiamoTECO Catli Nochipa Niitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nimonexti ica Abraham, Isaac huan Jacob huan niquinmatilti quen niitztoc pampa niquinilhui notoca: NimoTeco Catli Nijpiya Nochi Chicahualistli, pero amo niquinilhui ni seyoc notoca: Na Catli Nochipa Niitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nojquiya ininhuaya nijchijqui nopa camanali para niquinmacas nopa tlali Canaán campa achtihui itztoyaj quen seyoc tlali ehuani. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Huan na nijcactoc quenicatza chocaj nopa israelitame pampa nopa egiptome quintequipanoltíaj tlahuel chicahuac huan amo niquelcajtoc catli niquintencahuilijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ama xiquinilhui nochi israelitame para na niamoTECO niquinmaquixtis tlen inintequi catli tlahuel ohui ipan ni tlali Egipto. Quena, ica na nochicahualis huan ica huejhueyi tlanextilijcayotl, niquinmanahuis. Pampa nijchihuas huejhueyi tlanextilijcayotl para niquintlatzacuiltis nopa egiptome pampa quej nopa xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Huan xiquinilhuiti na nimoaxcatis nopa israelitame huan itztose nomasehualhua. Huan na nielis niininTeco. Quej nopa quimatise para na niininTeco Dios catli niquinmocuitlahuía, huan naya catli niquinquixtis tlen nopa tequitl catli tlahuel etic ipan ni tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Huan xiquinilhuiti niquinhuicas ipan nopa cuali tlali catli niquintencahuili niquinmacas Abraham, Isaac huan Jacob. Huan niquinmacas nopa israelitame nopa tlali para elis iniaxca. Xiquinilhui na niininTECO niquijtohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Huajca Moisés quinpohuili israelitame nochi ya ni, pero amo quichihuilijque cuenta pampa motequipachohuayayaj ica inintequi catli tlahuel chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","―Xiya xiquilhuiti Faraón nopa tlanahuatijquetl ipan tlali Egipto para ma quincahua ma quisaca nopa israelitame tlen itlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Pero Moisés quinanquili TOTECO: ―Niyon nopa israelitame amo nechchihuilíaj cuenta, ¿huajca quenicatza nechchihuilis cuenta nopa Faraón? Eltoc pampa amo cuali nitlatenquixtía quema nicamanalti. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Huajca quej nopa TOTECO quincamanalhui Moisés ihuaya Aarón huan quinilhui catli monequi quinilhuise nopa israelitame huan Faraón. Huan quintequimacac ma quinquixtica israelitame ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Huan ya ni inintoca nochi inintlayacanca tatahua israelitame huan ajqueya inijuanti catli tlacatque teipa tlen sesen hueyi tata catli eliyaya itelpocahua Israel. Rubén catli elqui iachtihui ejca cone Israel huejcajya quinpixqui iconehua catli inintoca: Hanoc, Falú, Hezrón huan Carmi. Huan sesen ni tlacame quinpixqui miyac iixhuihua huan sesen mochijque se hueyi familia, pero nochi hualajque tlen Rubén huejcajya. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Huan Simeón itelpoca Israel huejcajya quinpixqui iconehua catli inintoca: Jenuel, Jamín, Ohad, Jaquín, Zohar huan Saún catli elqui icone se cananea sihuatl. Sesen ni tlacame quinpixqui miyac iixhuihua huan sesen mochijqui se hueyi familia, pero nochi hualajque tlen Simeón. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Huan Leví, catli eliyaya itelpoca Israel huejcajya, itztoya 137 xihuitl. Huan ipan inemilis quinpixqui itelpocahua catli inintoca: Gersón, Coat huan Merari. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Huan iconehua Gersón catli mochijque huejhueyi familias elque: Libni huan Simei. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Huan Coat itztoya 133 xihuitl huan iconehua elque: Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Huan iconehua Merari elque Mahli huan Musi. Nochi ya ni mochijque huejhueyi familias huan hualajque tlen ininhueyi tata Leví. Huan pejqui inintoca ica catli achtihui ejquetl huan yajtiyajque hasta catli teipan ejquetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Huan ipan iconehua Coat, Amram mosihuajti ihuaya iahui catli elqui iicni itata huan itoca eliyaya Jocabed, huan ya quintlacatilti Aarón huan Moisés. Huan Amram itztoya 137 xihuitl para nochi. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Huan Izhar quinpixqui itelpocahua catli inintoca: Coré, Nefeg huan Zicri. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Huan iconehua Uziel elque: Misael, Elzafán huan Sitri. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Huan Aarón mosihuajti ihuaya Elisabet catli eliyaya iichpoca Aminadab huan isihua icni Naasón, huan quintlacatilti Nadab, Abiú, Eleazar huan Itamar. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Huan iconehua Coré elque Asir, Elcana huan Abiasaf. Nochi ya ni mochijque huejhueyi familias huan hualajque tlen Coré. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Huan Eleazar, icone Aarón, mosihuajti ica se iichpoca Futiel huan ya quitlacatilti Finees. Nochi ni lista huajca eliyaya inintoca nopa tlacame catli quinyacanque nopa huejhueyi familias tlen ininteiximatcahua. Huan nochi hualajque tlen ininhueyi tata Leví. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Huan ni Aarón huan Moisés catli mopantía inintoca ipan ni lista eltoc san se nopa tlacame catli TOTECO quinilhui ma quinchihuaca israelitame ma motecpanaca ica pamitl huan ma quinquixtica ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Huan nojquiya elque Moisés huan Aarón catli quicamanalhuitoj Faraón, nopa tlanahuatijquetl ipan tlali Egipto para ma quimaca caquihuili quinquixtise nopa israelitame. Huan teipa elque Moisés huan Aarón catli quinyacanque nopa israelitame tlen nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Huan nopa tonal quema TOTECO quinojnotztoya Moisés ipan tlali Egipto, ");
INSERT INTO nhwBl_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","quiilhuijtoya: ―Na niDIOS. Xiquilhui Faraón nopa tlanahuatijquetl ipan tlali Egipto nochi nopa tlamantli catli nimitzilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Huan Moisés quinanquili TOTECO: ―Na amo hueli cuali nitlatenquixtía quema nicamanalti, huajca ¿quenicatza nechchihuilis cuenta nopa Faraón? ");
INSERT INTO nhwBl_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Huan huajca TOTECO quiilhui Moisés: ―Xiquita, nimitzchihuas quen tielisquía se Dios quema timoquetzas iixpa Faraón. Huan moicni Aarón elis quen motlajtol pannextijca huan yaya camanaltis por ta. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Huan monequi tiquilhuis Aarón nochi catli nimitznahuatis huan teipa yaya camanaltis ihuaya Faraón para ma quincahua ma quisaca tlen itlal nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Pero na nijchihuas para nopa Faraón ma moyoltetilis huan amo quinequis. Huan nijchihuas ipan tlali Egipto miyac tlanextilijcayotl huan tlamantli catli amo quema quiitztoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pero nopa Faraón amo anmechchihuilis cuenta. Huan na nijtlalis nomax ipan Egipto huan nijtlatzacuiltis. Huan nijchihuas miyac huejhueyi tlamantli para niquincamanalxitlahuas hasta niquinquixtis nomasehualhua catli motecpanase ica miyac huejhueyi pamitl quen soldados. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Huan quema ya nijnextijtos nochicahualis ipan tlali Egipto huan ya niquinquixtijtos nopa israelitame nopona, nopa egiptome quimatise para na catli niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Huan Moisés huan Aarón quichijque nochi quen TOTECO quinnahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Huan Moisés quipiyayaya 80 xihuitl huan Aarón 83 xihuitl quema camanaltique ihuaya Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nhwBl_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","―Quema Faraón anmechilhuis para xijchihuaca se tlanextilijcayotl, xijcui mocuatopil huan xijmajcahua tlalchi iixpa para ma mocuepa se cohuatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Huajca Moisés huan Aarón yajque quiitatoj Faraón, huan quichijque senquistoc catli TOTECO quinnahuatijtoya. Aarón quimajcajqui tlalchi icuatopil iixpa Faraón huan itlapalehuijcahua, huan nopa cuatopili mocuepqui se cohuatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Huajca Faraón quinnotzqui nopa tlalnamiquini huan tetlajchihuiani huan catli quimatque tecajcayahuaj huan sesen inijuanti nojquiya quichijque catli Aarón quichijtoya ica inintetlajchihuijcayo. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Sesen inijuanti quimajcajque inincuatopil tlalchi huan nochi cuatopilme mocuepque cohuame. Pero icuatopil Aarón quincuajqui inincuatopil nopa sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pero masque ya nopa quichijqui, Faraón moyoltetili quen TOTECO quiijtojtoya para quichihuasquía huan amo quichihuili cuenta Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Teipa TOTECO quiilhui Moisés: ―Faraón moyoltetilijtoc huan amo quincahuas ma quisaca nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Pero mostla cualca xiya xiquitati quema temos campa atl. Xijchiya iteno nopa hueyatl Nilo huan xijhuica nopa cuatopili catli mocuepqui cohuatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Huan nopona tiquilhuis Faraón para na niDios huan niamoTECO nochi anhebreo masehualme. Huan nimitztitlantoc tiquilhuis para ma quincahuas ma yaca nomasehualhua para ma nechhueyichihuatij ipan huactoc tlali, huan niquita para hasta ama, amo nechchihuilijtoc cuenta. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Huajca xiquilhui para niamoTECO niquijtohua para ama yaya quimatis para naya catli nelía niDIOS huan niininTECO nopa israelitame. Huan xiquilhui para quema tijmaquilis nopa atl ica nopa cuatopili catli tijpiya momaco, nopa atl mocuepas estli. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Huan xiquilhui para michime miquise, huan nopa hueyatl mijyotis hasta egiptome quiijiyase para quiijise tlen nopa atl. Quej nopa tiquilhuis Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nojquiya TOTECO quiilhui Moisés: ―Xiquilhui Aarón ma quicui icuatopil huan ma quixitlahua imax imelac nopa hueyame huan nopa atlajme. Ma quixitlahua imax ipan campa tlameya huan campa quitecaj atl ipan tlali Egipto, huan nochi mocuepas estli. Huan nojquiya nopa atl ipan nochi conme huan tlamantli catli quipiyaj atl ipan ininchaj mocuepas estli hasta nopa atl ipan cuacomitl huan comitl catli quichijtoque tlen tetl nojquiya mochihuas estli. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Huajca Moisés huan Aarón quichijque nochi senquistoc quen TOTECO quinnahuatijtoya. Huan quitlananqui icuatopil huan quimaquili nopa hueyatl Nilo iixpa Faraón huan itequiticahua, huan nochi atl mocuepqui estli. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Huan nochi michime mijque, huan nopa hueyame nelía mijyotiyaya hasta amo aqui hueliyaya atli. Oncayaya estli ipan nochi tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Pero nopa tlalnamiquini huan tetlajchihuiani ipan tlali Egipto quichijque san se tlamantli ica inintetlajchihuijcayo, huan huajca Faraón moyoltetili huan amo quinchihuili cuenta Moisés huan Aarón, quen TOTECO quiijtojtoya para panos. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Huan Faraón mocueptiquisqui huan yajqui icaltlanahuatil, niyon amo quichihuili cuenta ni tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Huan nochi nopa egiptome monejqui quichihuase ameli iteno hueyatl para quiquixtise atl catli cuali pampa nopa atl ipan hueyatl amo hueliyaya moiji. ");
INSERT INTO nhwBl_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Huan TOTECO quichijqui ma mocuepa estli nopa atl ipan hueyatl Nilo, huan teipa panoc chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Huan TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón huan xiquilhuiti para niamoTECO niquijtohua para ma quincahua ma yaca nomasehualhua para nechhueyichihuatij. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Pampa sintla amo quincahuas ma yaca, na tlahuel nijtlatzacuiltis nochi itlal ica temasolime. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nopa hueyatl Nilo quinyolitis tlahuel miyac temasolime. Huan nopa temasolime calaquise ipan ichaj, huan calaquise ipan itlapech campa cochi. Huan calaquise ipan ininchajchaj itlapalehuijcahua huan imasehualhua. Huan hasta calaquise campa quixacualohuaj harina huan campa panicxitíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Huan nopa temasolime huitonise ininpani, huan ininpani itequipanojcahua huan ipan nochi imasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Huan nojquiya TOTECO quiilhui Moisés: ―Teipa xiquilhui Aarón ma tlamanextis ica icuatopil ipan nopa hueyame, atlajme, huan campa mantoc atl para nopona ma quisaca temasolime huan ma quitemitica ni tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Huajca quej nopa Aarón tlamanexti ica icuatopil ipan nopa atl catli eltoya ipan tlali Egipto, huan nopona quisque temasolime catli quitemitijque nochi nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Pero nopa tetlajchihuiani nojquiya san se quichijque ica inintetlajchihuijcayo. Nojquiya quichijque ma hualaca temasolime ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Teipa Faraón tlatitlanqui ma quinotzatij Moisés ihuaya Aarón huan quinilhui: ―Xijtlajtlanica amoTECO para ma techijcuinili ni temasolime na ihuaya nomasehualhua. Huan huajca niquincahuas imasehualhua ma yaca quimacatij tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Huan Moisés quinanquili Faraón: ―Nimitzcahuas para ta techilhui nopa hora quema tijnequi ma nimotlatlajtis por ta, huan por inijuanti catli mitzpalehuíaj, huan por momasehualhua. Huan ipan nopa hora quema ta tiquijtos, nimotlatlajtis ica TOTECO para nopa temasolime ma mitztlalcahuica, huan ma quitlalcahuica amochajchaj. Huan ipan nopa hora anmechtlalcahuise huan mocahuase san ipan hueyatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Huajca nopa Faraón quiijto: ―Xijchihua mostla. Huan Moisés tlananquili: ―Quej nopa elis, huan yeca tijmatis para amo aqui itztoc quen TOTECO Dios, ");
INSERT INTO nhwBl_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","pampa nopa temasolime ayacmo itztose ipan amochajchaj. Mitztlalcahuise huan quintlalcahuise motequipanojcahua, huan momasehualhua. San mocahuase ipan nopa hueyatl Nilo. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Huajca Moisés huan Aarón quisque ipan ichaj Faraón. Huan teipa Moisés quitlajtlani TOTECO ma quinijcuini nopa temasolime catli quintitlantoya ipan Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Huan TOTECO quichijqui catli Moisés quitlajtlani, huan mijque nopa temasolime catli itztoyaj ipan calme huan calixpanme huan ipan mila. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Huan nopa masehualme quinsentiliyayaj nopa temasolime catli mictoyaj huan quinmontonojque campa hueli huan mijyotiyayaj tlahuel potehui. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Pero masque quej nopa elqui, quema Faraón quiitac para ayacmo oncac nopa tlamantli, moyoltetili huan amo quinchihuili cuenta Moisés huan Aarón, quen TOTECO quiijtojtoya para quichihuasquía. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Huajca TOTECO quiilhui Moisés: ―Xiquilhui Aarón ma quixitlahuas icuatopil huan ma quimaquili nopa tlaltejpoctli para ma mocuepaca atime. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Huajca quej nopa quichijqui. Huan Aarón quimaquili nopa tlaltejpoctli catli tlalchi ica icuatopil, huan mocuepqui atime catli quinajsic nochi masehualme huan tlapiyalme, pampa nochi tlaltejpoctli mochijque atime. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Huan inijuanti catli tetlajchihuíaj quichijque campica para quinchihuase atime ica inintetlajchihuijcayo, pero amo huelque. Huan oncac atime ipan masehualme huan ipan tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Huajca nopa tetlajchihuiani quiilhuijque Faraón: ―¡Ni tlamantli san Dios hueli quichihua! Pero Faraón moyoltetili huan amo quintlacaquili, quen TOTECO quiijtojtoya para quichihuasquía. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Huan TOTECO quiilhui Moisés: ―Mostla ximehua cualca huan xiya xijnamiquiti Faraón quema temos ateno para maltiti huan xijcamanalhui. Xiquilhui para nimoTECO niquijtohua ma quincahua ma yaca nomasehualhua para ma nechhueyichihuatij. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pampa sintla amo quincahuas ma yaca, na nijtitlanis miyac tlahuipamitl tlen pilsayoltzitzi ipan ya, ipan itequiticahua huan ipan nochi imasehualhua. Quena, temis ica pilsayoltzitzi ininchajchaj nochi Egipto ehuani, huan hasta tlalchi nojquiya temis. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Pero quema quej ni panos niquiyocaquixtis tlali Gosén campa itztoque nomasehualhua. Nopona amo oncas niyon se pilsayoltzi. Quej nopa yaya quimatis para na niamoTECO catli niitztoc ipan ni tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nijchihuas ya ni para nesis catlique nomasehualhua huan catlique amo nomasehualhua. Quej ni elis mostla. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Huan TOTECO quej nopa quichijqui. Huan hualajque nochi tlamantli sayolime ipan Faraón huan ipan ininchajchaj catli quitequipanohuayayaj. Nochi tlali Egipto temic ica sayolime. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Huajca Faraón tlanahuati ma quinotzatij Moisés huan Aarón huan quinilhui: ―Xiyaca xijmacatij tlacajcahualistli amoTeco Dios, pero amo xiquisaca tlen ni tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Huan Moisés tlananquili: ―Amo cuali tijchihuase quej nopa, pampa anEgipto ehuani anquinijiyaj nopa tlapiyalme catli tijmacaj TOTECO Dios. Huan sintla anEgipto ehuani antechitasquíaj, na cuali nijmati antechmictisquíaj ica tetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Monequi tiyase ipan huactoc tlali hasta campa hueli tiajsise ipan eyi tonali, huan nopona tijmacase tlacajcahualistli TOTECO Dios catli tijtequipanohuaj pampa quej nopa yaya technahuatía. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Huajca nopa Faraón quiijto: ―Na nimechcahuas xiyaca ipan huactoc tlali para xijmacaca itlacajcahualis amoTECO Dios, pero amo xiyaca nelhuejca. Huan xijtlajtlanica amoTECO Dios por na. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Huan Moisés tlananquili: ―Quema na niquisas nica, nijtlajtlanis TOTECO para mostla ma mitztlalcahuica nopa sayolime. Huan nojquiya quintlalcahuise catli mitzpalehuíaj huan nochi Egipto ehuani. Pero xijpiya cuidado amo techcajcayahuaca, niyon ayacmo xiquintzacuili israelitame para ma yaca quimacatij tlacajcahualistli TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Huan quema Moisés quisqui ichaj Faraón, quitlajtlani TOTECO, ma tlamica nopa sayolime, ");
INSERT INTO nhwBl_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","huan TOTECO quichijqui catli Moisés quitlajtlani. Huan nopa sayolime quitlalcahuijque Faraón, huan itlayacancahua huan nochi Egipto ehuani. ");
INSERT INTO nhwBl_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Pero Faraón sempa moyoltetili, huan amo quincahuili ma yaca nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Huajca TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón huan xiquilhuiti para na niDIOS, niininTECO hebreo masehualme, huan na niquilhuía ma quincahua nomasehualhua ma yaca nechhueyichihuatij. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Huan xiquilhui sintla amo quincahuas ma yaca huan noja quintzacuilijtos, ");
INSERT INTO nhwBl_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","huajca na niininTECO nijtlalis nomax ipan itlapiyalhua catli itztoque campa potrero, huan niquinmacas se hueyi cocolistli catli nelfiero. Nopa cocolistli quinajsis icahuayojhua, iburrojhua, icamellos, ihuacaxhua, huan iborregojhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Pero na niininTECO niquiniyocatlalis inintlapiyalhua israelitame ica catli iniaxcahua nopa Egipto ehuani, pampa amo nijcahuas ma miquis niyon se tlapiyali tlen israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nojquiya TOTECO tlayolmelajqui nopa tonal quema quichihuas pampa quiijto: ―Na nijchihuas ni tlamantli mostla. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Huan hualmostla TOTECO ya nopa quichijqui. Nochi inintlapiyalhua Egipto ehuani mijque, pero amo mijqui niyon se inintlapiyal israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Huan Faraón tlatitlanqui ma yaca quiitatij inintlapiyalhua nopa israelitame huan quipantitoj niyon se tlapiyali amo mictoya. Pero masque ya nopa elqui, Faraón moyoltetili huan amo quincahuili ma yaca nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Huajca TOTECO quinilhui Moisés huan Aarón: ―Xijcuica ome tlamojtzoli cuanextli campa quiicxitíaj pantzi huan xijmajcahua para huejcapa ipan ajacatl iixpa Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Huan nopa cuanextli mocuepas tlaltejpoctli catli más cuechtic huan mosemanas ipan nochi tlali Egipto huan quichihuas ma quisaca miyac tlaxhuisme ipan nochi masehualme huan tlapiyalme ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Huajca Moisés ihuaya Aarón quicuique cuanextli campa quiicxitíaj pantzi huan yajque quiitatoj Faraón. Nopona Moisés quimajcajqui nopa cuanextli para huejcapa, huan ya nopa quichijqui ma quisaca tlaxhuisme catli temalohuayayaj ipan nochi masehualme huan tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Huan nopa tetlajchihuiani amo huelque monextijque iixpa Moisés pampa inijuanti nojquiya quinpixque tlaxhuisme campa hueli quen nochi Egipto ehuani. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Pero TOTECO quichijqui para nopa Faraón ma moyoltetili huan ma amo quinchihuili cuenta Moisés huan Aarón, quen TOTECO quiilhuijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Huajca TOTECO quiilhui Moisés: ―Mostla ximehua cualca huan xiya xiquilhuiti Faraón para na catli niininTECO nopa hebreo masehualme huan niquijtohua ma quincahua ma yaca nomasehualhua para nechhueyichihuatij. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Pampa ni huelta nijtitlanis se tlatzacuiltili catli ajsis ipan iyolo Faraón, huan ipan ininyolo nochi catli quipalehuíaj huan nochi imasehualhua. Huan ica ya ni yaya quimatis para amo aqui seyoc Dios ipan nochi tlaltipactli, san na. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Xiquilhui Faraón para na nihueltosquía nijmictijtosquía ica se cocolistli ihuaya nochi imasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Pero xiquilhui na nijtlali ipan itequi huan nijcajtoc ma itzto hasta ama para nijnextilis nohueyi chicahualis huan para nochi masehualme ipan tlaltipactli ma quicaquica ajqueya na. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Pero masque quiitztoc nochi catli nijchijtoc iixpa, noja quintzacuilía nomasehualhua huan amo quincahua ma yaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Huajca xiquilhui para mostla ipan ni hora nijchihuas ma huetzi tesihuitl nelchicahuac quen amo quema huetztoc ipan nochi tlali Egipto hasta quema pejqui ni tlali huan hasta ama. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Huajca xiquilhui para nimantzi ma tlanahuati ma quintzacuaca inintlapiyalhua, pampa nopa tesihuitl quinmictis nochi masehualme huan nochi tlapiyalme catli amo quintzacuase calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Huan sequin itlapalehuijcahua Faraón quineltocaque catli TOTECO quiijto huan moisihuiltijque quintlalijque calijtic nochi inintlapiyalhua huan inintequipanojcahua catli quincojtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Pero itztoyaj sequin catli san quiahuilmatque icamanal TOTECO catli Moisés quinilhuijtoya, huan quincajque ipan cuatitlamitl huan amo quintzajque calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Huajca TOTECO quiilhui Moisés: ―Xijtlanana momax huan xijmanexti ilhuicac para ma huetzi tesihuitl campa hueli ipan nochi tlali Egipto. Huetzis ipan nochi masehualme huan tlapiyalme huan huetzis ipan nochi tlatoctli ipan ininmil Egipto ehuani. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Huajca Moisés quitlananqui icuatopil hasta ilhuicac huan TOTECO quititlanqui tlatomonilotl, tlapetlanilotl huan tesihuitl ipan nochi tlali Egipto. Huan nelía fiero elqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tlahuel chicahuac huetzqui nopa tesihuitl huan tlapetlaniyaya huan amo moquetzayaya. Hasta ipejya Egipto amo quema huetztoya se tesihuitl quej nopa. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Huan nopa tesihuitl quipolo nochi catli oncayaya ipan tlali Egipto. Quinmicti nochi masehualme huan tlapiyalme catli amo itztoyaj calijtic, huan quipolo nochi tlatoctli ipan mili huan nochi cuame ipan inintlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","San ipan tlali Gosén campa itztoyaj israelitame, amo huetzqui niyon se tesihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Huajca nopa Faraón tlatitlanqui ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Ama nitlajtlacolchijtoc. Catli amoTECO quichihua, ya nopa xitlahuac huan catli na huan nomasehualhua tijchihuaj, amo cuali. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Nelmiyac tlatomonilotl huan tesihuitl techajsitoc, huajca ayacmo niquintzacuilis más nopa israelitame. Xijtlajtlanica, amoTECO, por tojuanti para ma ayacmo huetzi tesihuitl, huan na niquincahuas ma yaca israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Huan Moisés quinanquili: ―Nimantzi quema niquisas tlen ni altepetl, nijtlananas nomax huan nimotlatlajtis ica TOTECO. Huan ayacmo huetzis nopa tesihuitl huan ayacmo tlatomonis, huan quej nopa tijmatis para ni tlaltipactli iaxca TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Pero na cuali nijmati para niyon ta, niyon catli mitzpalehuíaj, amo anquitlepanitaj TOTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Huan nochi nopa tlatoctli catli itoca lino huan cebada nenpolijque, pampa nopa cebada ya eltoya para xinis huan nopa lino xochiyojtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Pero nopa trigo ihuaya nopa centeno amo tleno ipantic, pampa xini teipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Huan quema Moisés quisqui campa Faraón huan campa nopa altepetl, quitlananqui imax ica TOTECO huan motlatlajti. Huan nimantzi nochi moquetzqui. Ayacmo huetzqui tesihuitl, niyon ayacmo tlaquiyajqui, huan ayacmo tlatomonqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pero quema nopa Faraón quiitac para ayacmo tlaquiyahuiyaya, niyon ayacmo huetziyaya tesihuitl, niyon ayacmo tlatomoniyaya, sempa tlajtlacolchijqui. Huan amo san ya moyoltetili, pero nojquiya san se quichijque nochi catli quipalehuiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Huan pampa moyoltetili, Faraón amo quincahuili ma yaca nopa israelitame quen TOTECO teyolmelajtoya ica Moisés para quichihuasquía. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Huan TOTECO quiilhui Moisés: ―Xiya xiquitati Faraón pampa na nijchijtoc para ya ihuaya itequiticahua ma moyoltetilica para huelis nijchihuas ni huejhueyi tlanextilijcayotl catli nijchihua iniixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Huan yeca se tonal ta huelis tiquinpohuilis moconehua huan moixhuihua nopa huejhueyi tlamantli catli nijchijqui iniixpa Egipto ehuani. Quena, niquinyoltetilijtoc para xijmatica para na niDIOS, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Huajca Moisés huan Aarón yajque quiitatoj Faraón huan quiilhuijque: ―TOTECO Dios catli tihebreo masehualme tiquiximatij mitztlajtlanía hasta quema timoechcapanos iixpa. Quiijtohua monequi xiquincahua ma yaca imasehualhua para ma quihueyichihuatij. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Quiijtohua sintla amo tijchihuas, mostla quichihuas ma hualaca chapolime ipan motlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Huan nopa chapolime quitemitise ni tlali hasta ayacmo nesis tlalchi. Quicuase catli quentzi mocahua ama tlen amotochui catli amo nenpolijqui ica tesihuitl. Huan nopa chapolime quicuase nochi cuame catli mocahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Temise ipan mochaj huan ininchajchaj motequipanojcahua huan nochi sequinoc Egipto ehuani. Ipan nochi ininnemilis, amotatahua niyon amohuejcapan tatahua catli huejcajya itztoyaj amo quema quiitztoque se tlamantli quen catli ama nijchihuas. Quema Moisés tlanqui camanalti, moicancuepqui huan quisqui tlen ichaj Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Huan itequiticahua Faraón quiilhuijque: ―¿Hasta quema ni tlacatl noja techcuesolmacas? Xiquincahua ma yaca nopa masehualme ma quihueyichihuatij ininTECO Dios. ¡Ay Tlanahuatijquetl! ¿Ayamo timomaca cuenta para totlal Egipto ya tlamisosolijtoc? ");
INSERT INTO nhwBl_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Huan Faraón tlatitlanqui sempa ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Xiyaca xijhueyichihuatij, amoTECO Dios. Pero achtihui techilhuica ajqueya inijuanti yase. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Huan Moisés tlananquili: ―Monequi nochi tiyase. Yase topilconehua hasta tohuehue masehualhua. Yase totelpocahua, toichpocahua, nochi toborregojhua huan nochi tohuacaxhua, pampa tijchihuase se hueyi ilhuitl para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pero nopa Faraón quinilhui: ―Tlanemijya nesi para amo ya nopa catli anquichihuase. ¿Anmoilhuíaj para na nimechcahuas anyase ininhuaya nochi amosihuajhua huan amoconehua huan para amoTeco yas amohuaya? ");
INSERT INTO nhwBl_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","¡Amo! ¡Amo quej nopa elis! Xiyaca san antlacame para xijhueyichihuatij amoTECO, pampa ya nopa catli anquiijtohuaj anquinequij. Huan itlapalehuijcahua quintojtocaque Moisés huan Aarón iixpa Faraón. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Huan TOTECO quiilhui Moisés: ―Xijxitlahua momax ipan tlali Egipto para ma hualaca chapolime huan ma quitemitica. Ma quicuaca nochi tlatoctli huan nochi catli mocajqui quema huetzqui tesihuitl campa hueli ipan inintlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Huan yeca Moisés quixitlajqui imax ipan tlali Egipto, huan TOTECO quichijqui ma huala se ajacatl campa hualquisa tonati huan quiilpitzqui nopa tlali se tonal huan se yohuali. Huan hualmostla nopa ajacatl ya quinhualicatoya chapolime. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Huan nopa chapolime calajque campa hueli ipan inintlal. Amo quema oncatoya imiyaca chapolime quej nopa ipan se tlali, niyon ayacmo quema oncas. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Quitemitijque nopa tlali hasta amo nesiyaya tlalchi, huan quicuajque nochi cuatlatoctli huan nochi cuatlactli catli mocajtoya ipan cuame catli momanahuijtoya quema huetzqui tesihuitl. Amo tleno catli xoxohuic mocajqui ipan nochi tlali Egipto, niyon ipan cuame, niyon ipan mila. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Huajca Faraón tlatitlanqui nimantzi ma quinnotzatij Moisés huan Aarón huan quinilhui: ―Nitlajtlacolchijtoc ica amoTECO Dios huan ica amojuanti, ");
INSERT INTO nhwBl_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","pero nimechtlajtlanía para san ni huelta techtlapojpolhuica notlajtlacol. Huan ximotlatlajtica ica amoTECO Dios por na para ma nechtlalcahui ni tlatzacuiltili catli techmictía. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Huan Moisés quisqui ichaj Faraón, huan motlatlajti ica TOTECO por ya. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Huan TOTECO quipatlac iojhui nopa ajacatl, huan mocuepqui se chicahuac ajacatl campa temo tonati huan quinhuicac nopa chapolime huan quinmajcajqui ipan Hueyi Atl catli itoca Chichiltic. Huan amo mocajqui ipan Egipto niyon se chapoli. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Pero TOTECO quichijqui para Faraón ma moyoltetili huan ma amo quincahuili ma yaca nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Huajca TOTECO quiilhui Moisés: ―Xijxitlahua momax para ilhuicac, huan ipan nochi tlali Egipto ma onca se tzintlatlayohuilotl catli nelyayahuic huan tilahuac hasta huelis tiquitzquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Huajca Moisés quitlananqui imax para ilhuicac, huan oncac se tzintlayohuilotl nelhueyi ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Para eyi tonali amo aqui hueliyaya quiita catli icalnechca huan amo aqui quisqui ipan ichaj. Pero ipan nochi ininchajchaj nopa israelitame oncayaya tlahuili. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Huajca nopa Faraón tlatitlanqui ma quinotzatij Moisés huan quiilhui: ―Xiyaca xijhueyichihuatij amoTECO, huan xiquinhuicaca nojquiya amoconehua, pero ma mocahuaca nica amoborregojhua ininhuaya amohuacaxhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Pero Moisés tlananquili: ―¡Amo tihuelise! Monequi techcahuas ma tiquinhuicaca nopa tlapiyalme para nopa tlacajcahualistli catli tijtlatise para tijmacase TOTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Huajca nojquiya totlapiyalhua yase tohuaya. Niyon se tlapiyali amo hueli tijcajtehuase pampa monequi tiquintlapejpenise sequin inijuanti catli titemacase quema tijhueyichihuase TOTECO Dios. Huan amo tijmatise tlaque tlapiyalme tiquintequihuise hasta tiajsise nepa. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Pero TOTECO quichijqui para Faraón ma moyoltetili huan amo ma quincahuili ma yaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Nojquiya Faraón quiilhui Moisés: ―Techtlalcahui huan xijpiya cuidado para ayacmo techixtlachiliqui sempa. Ipan nopa tonal quema timonextiqui noixpa, timiquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Huan Moisés tlananquili: ―Cuali catli tiquijtojtoc. Ayacmo quema nimitzitas sempa. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Huan TOTECO quiilhui Moisés: ―Noja nijhualicas seyoc tlatzacuiltili ipan Faraón huan nopa egiptome. Huan teipa amo san anmechcahuas xiyaca, pero quena, hasta anmechtojtocas. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ama xiquinilhui israelitame para monequi nochi tlacame huan sihuame ma quitlajtlanica inincalnechcahua tlamantli tlen oro huan plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Huan TOTECO quichijtoya para nopa egiptome ma quincualitaca israelitame. Huajca quinmajmacaque nopa israelitame catli quintlajtlaniyayaj. Nojquiya nopa tequitini catli quipalehuiyayaj Faraón quitlepanitayayaj Moisés huan nochi egiptome nojquiya quicualitayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Huajca Moisés quiilhui Faraón: ―TOTECO quiijtohua para tlajco yohual panos ipan nochi tlali Egipto, ");
INSERT INTO nhwBl_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","huan quinmictis nochi amoachtihui ejca conehua ipan nochi amochajchaj nochi anEgipto ehuani. Miquis moachtihui ejca ta tiFaraón catli timosehuía ipan nopa siya yejyectzi campa titlanahuatía huan hasta miquis iachtihui ejca sesen sihua tequipanojquetl catli tisi para iteco. Nojquiya miquise nochi iniachtihui ejcahua amotlapiyalhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ipan nochi tlali Egipto, masehualme ayijtise chicahuac quen amo quema quichijtoque, huan quen ayacmo quema quichihuase sempa. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Pero campa itztoque israelitame, niyon se chichi amo tlaajhuas huan amo miquis niyon se masehuali o tlapiyali. Huajca Faraón ta tijmatis para TOTECO nelía quinicnelía israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Huan hualase nechitaquij nochi ni tequitini catli mitzpalehuíaj huan motlancuaquetzase noixpa para nechilhuise chicahuac para ma tiyaca ininhuaya nochi tomasehualhua. Huan quema panos ya nopa, huajca quena, niyas. Huan Moisés quisqui iixpa nopa Faraón nelcualantoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Huan TOTECO ya quiilhuijtoya Moisés: ―Nopa Faraón amo anmechchihuilis cuenta, huan yeca quej nopa nijchihuas noja más huejhueyi tiochicahual nextili ipan Egipto para niquinnextilis nohueyi chicahualis. ");
INSERT INTO nhwBl_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Huajca masque Moisés ihuaya Aarón quichijque nochi ni huejhueyi tiochicahual nextili iixpa Faraón, TOTECO quichijtoya ma moyoltetili Faraón huan yeca amo quincahuili ma quisaca nopa israelitame tlen tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Huan ipan tlali Egipto TOTECO camanaltic ihuaya Moisés huan Aarón, huan quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Ama huan para nochipa ni metztli elis nopa achtihui metztli tlen amoxihui anisraelitame. Huan ni metztli elis catli más ipati para amojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Xiquinilhuica nochi israelitame para ama huan teipa sesen xihuitl ipan 10 itequi ni metztli, sesen amojuanti ma quicui se pilborregojtzi o se oquich chivo para ifamilia. Sese familia quicuis san para ichaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Huan sintla tziquitetzi se familia huan amo hueli quicuase nochi se pilborregojtzi, ma quitlajcoitase se pilborregojtzi ihuaya catli itztoque icalnechca huan quicuase san sejco. Monequi quinpohuase quesqui ininmiyaca nopa masehualme catli itztoque huan quesqui ininmiyaca catli sesen huelis quicuas para quimatise quenicatza ihuexca se pilborregojtzi huelise quitlamise. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Huan xiquinilhuica monequi quitlapejpenise se oquich tlapiyali catli quipiya se xihuitl, huan catli amo tleno catli amo cuali quipiya itlacayo. Huelis quitequihuise se pilborregojtzi o se chivo. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Monequi quiajocuise nopa tlapiyali catli quitlapejpenise hasta 14 itequi ni metztli. Huan ipan nopa tonal quema tiotlaquixtos, sesen familia tlen israelitame quimictise inintlapiyal. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Huan teipa quicuise ieso nopa tlapiyali huan quipolose nopa caltencuahuitl itzonatipa icuapuerta nopa cali campa quicuase inacayo. Nojquiya quipolose nopa caltencuahuitl ipan inejmac huan iopoch. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Huan ipan nopa tlayohua quicuase nopa nacatl tlacuahuatztli. Huan quicuase ica quilitl catli chichic huan pantzi catli amo quipiya tlasonejcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ma amo quicuaca nopa nacatl xoxohuic, niyon tlamolontli. Monequi anquitlihuatzase nopa tlapiyali nejmaxtic ica itzonteco, imetz huan nochi catli quipixtoc iijtico. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Huan amo tleno hueli anquicahuase para seyoc tonal. Sintla se tlamantli mocahua nopa tlayohua huan amo anquitlamicuase, monequi anquitlatise. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Quej ni antlacuase. Achtihui ximoyoyontica ica amotlaque huan ximoilpica. Ximotecactica huan xijpixtoca amocuatopil amomaco. Huan huajca, quena, xijcuaca nimantzi nopa tlapiyali, pampa ya nopa noPascua, niamoTECO, quema na nimechpanos para amo aqui tlen amojuanti miquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Pero ipan nopa tlayohua nipanos ipan nochi tlali Egipto huan niquinmictis nopa oquichpilme catli achtihui ehuani ipan sesen familia tlen egiptome huan nopa oquichtli catli achtihui tlacatqui tlen inintlapiyalhua. Huan niquintlamiltis nochi inintlaixcopincayohua nopa Egipto ehuani. Na niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","“Huan nopa estli elis quen se tlanextilijcayotl ipan calme para xijnextica campa anitztoque. Huajca quej nopa quema niquitas nopa estli, san nimechcalpanos huan amo tleno ininpantis amoconehua quema niquinmictis nopa Egipto ehuani ininconehua. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Huan ni tonal quema niquintlatzacuiltis egiptome monequi anquielnamiquise sesen xihuitl. Ipan ni tonal monequi antechchihuilise se hueyi ilhuitl na, niamoTECO. Anquichihuase ni ilhuitl para nochipa huan ni ilhuitl panos tlen tetajme hasta ininconehua. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Huan ipan nopa ilhuitl anquicuase pantzi catli amo quipiya tlasonejcayotl para chicome tonali. Huajca ipan nopa achtihui tonal monequi xijquixtica nochi tlasonejcayotl ipan amochajchaj. Sintla acajya quicuas pantzi catli quipiya tlasonejcayotl ipan nopa chicome tonali ipan nopa ilhuitl, monequi xijquixtica tlen israelitame para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ipan nopa achtihui tonal ximosentilica san sejco ipan se tlasentililistli catli tlatzejtzeloltic huan sempa ximosentilica ipan nopa chicompa tonal. Ma amo aqui tequitis ipan nopa tonal. San huelis anquisencahuase tlacualistli para nochi ma tlacuaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Quena, xijchihuaca nopa ilhuitl tlen pantzi catli amo quipiya tlasonejcayotl sesen xihuitl ipan ni tonal quema nimechquixti nochi amojuanti ipan tlali Egipto. Huajca xiilhuichihuaca ipan ni tonal para nochipa. Huan ni ilhuitl panos tlen tetajme hasta ininconehua para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Quena, sesen xihuitl ica tiotlac ipan 14 itequi nopa achtihui metztli, xipehuaca xijcuaca pantzi catli amo quipiya tlasonejcayotl huan san ya nopa xijcuaca hasta tiotlac ipan 21 itequi nopa metztli. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","“Monequi amo oncas tlasonejcayotl ipan amochajchaj para nopa chicome tonali. Pampa sintla acajya quicuas pantzi ica tlasonejcayotl, monequi anquiquixtise tlen israelitame. San se anquichihuase masque quicuas se catli ehua seyoc tlali, o se israelita catli nopona ehua. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Amo tleno xijcuaca catli quipiya tlasonejcayotl, masque campa hueli anitztoque. Monequi xijcuaca san nopa pantzi catli amo quipiya tlasonejcayotl.” Quej nopa TOTECO quiilhui Moisés huan Aarón ma quinilhuitij israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Huajca Moisés quinnotzqui nochi nopa huehue tlacame catli tlayacanayayaj ipan israelitame huan quinilhui: “Xiyaca nimantzi huan xijtlapejpenica sesen amojuanti se pilborregojtzi o se chivo para amofamilias, huan xiquinmictica para anilhuichihuase para nopa Pascua. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Xijcuica se tlaitzquili tlen nopa xihuitl itoca hisopo huan xijxolonica ipan nopa estli catli eltoc ipan huajcali. Huan xijpoloca itzonatipa huan ipan nochi inejmac huan iopoch nopa caltencuahuitl tlen amocalpuerta. Huan niyon se amojuanti amo hueli quisas calteno hasta quema tlanesis. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Huan quema TOTECO panos para quinmictis nopa egiptome, sintla quiitas nopa estli itzonatipa huan ipan nochi ome iteno se puerta, huajca san quipanos nopa cali. Quej nopa, TOTECO amo quicahuilis nopa tlasosolojquetl ma calaqui ipan amochajchaj para quinmictis amoconehua. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Monequi amojuanti ihuaya amoixhuihua, xijtlepanitaca ni tlanahuatilme para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Huan quema ya ancalactose ipan nopa cuali tlali catli TOTECO anmechmacas quen anmechtencahuilijtoc, monequi anquichihuase ni tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Huan quema amoconehua anmechtlatzintoquilise tlaque quiijtosnequi ni ilhuitl catli anquichihuaj, ");
INSERT INTO nhwBl_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","xiquinilhuica para ni tlapiyali tlen Pascua catli tijmictíaj eltoc se tlacajcahualistli para TOTECO. Techelnamiquiltía quenicatza elqui quema TOTECO quinmicti nopa egiptome, pero san quipanoc tochajchaj tiisraelitame catli nojquiya tiitztoyaj ipan tlali Egipto huan amo quimicti niyon se tlen tofamilias.” Quej nopa Moisés quinpohuili nopa israelita tlayacanani. Huan nopa tlayacanani motlancuaquetzque huan mohuijtzonque tlalchi huan quihueyichijque TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Huan teipa yajque huan quichijque catli TOTECO quinnahuatijtoya Moisés ihuaya Aarón. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Huan tlajco yohual TOTECO quinmicti sese achtihui ejquetl ipan sesen familia tlen Egipto ehuani. Quimicti iachtihui ejca Faraón catli mosehuía ipan nopa yejyectzi siya para tlanahuatis, hasta iniachtihui ejca catli itztoya ipan tlatzactli, huan nojquiya quinmicti iniachtihui conehua nochi tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Huajca nopa tlayohua mejque Faraón huan nochi itequiticahua catli quipalehuiyayaj, huan nochi sequinoc egiptome, huan campa hueli ipan nochi nopa tlali Egipto nochi chocayayaj huan tlahuejchihuayayaj. Amo oncayaya niyon se cali tlen Egipto ehuani campa amo oncayaya se mijcatzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Huajca ipan nopa tlayohua Faraón tlatitlanqui ma quinotzatij Moisés ihuaya Aarón, huan quinilhui: ―Amantzi xiquisaca. Xiyaca amojuanti ininhuaya nochi nopa israelitame. Xiquincahuaca nomasehualhua. Xiyaca xijhueyichihuatij amoTECO quen anquiijtojque. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Xiquinhuicaca nojquiya amoborregojhua huan amohuacaxhua quen anquiijtojtoyaj, huan xiyaca. Huan xijtlajtlanica, amoTECO, por na. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Huan nopa Egipto ehuani quinisihuiltijque nopa israelitame para ma quisaca tlen nopa tlali pampa moilhuiyayaj huelis nochi egiptome miquisquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Huajca nopa israelitame quicuique inintix, masque ayamo quipiyayaya tlasonejcayotl para mosonehuas. Huan quitlalijque ipan tixhuapali, huan quiquimilojque ica yoyomitl huan quitlalijque iniajcolpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Nojquiya quichijque catli Moisés quinnahuatijtoya huan quintlajtlanijque nopa egiptome yoyome huan tlamantli tlen oro huan plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Huan TOTECO quichijqui para nopa Egipto ehuani ma quincualitaca nopa israelitame huan quinmacaque nochi catli tlajtlaniyayaj, huan yeca nopa israelitame nelía quintlaquijquixtilijque egiptome. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Huan nopa israelitame quisque Ramesés huan nejnenque hasta Sucot. Huan sintla mopohuasquía san inijuanti catli ya quipixque xihuitl para tlahuilanase, mochihuayayaj nechca 600 mil, pero amo quinpojque sihuame huan coneme. Huan nochi icxinejnemiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Huan ininhuaya yajque miyaqui tlamantli masehualme catli amo israelitame huan nojquiya miyac borregojme huan huacaxme. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Huan quichijque pantzi ica nopa tixtli catli quiquixtijtoyaj. Huan nopa tixtli amo quipixqui tlasonejcayotl pampa nopa egiptome quintojtocaque huan amo quiaxilijque para quisencahuase inintlacualis. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Nopa israelitame itztoyaj ipan tlali Egipto para 430 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Huan ipan nopa tonal quema quiaxitijque nopa 430 xihuitl, nochi imasehualhua TOTECO quisque ipan nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","TOTECO quitlapejpeni nopa tlayohua huan quiiyocatlali para ya iseltzi pampa elqui ipan nopa tlayohua quema quinquixtiyayaj israelitame ipan tlali Egipto. Huajca ipan nopa tlayohua sesen xihuitl monequi nochi israelitame catli ama itztoque huan catli teipa tlacajtiyase neltlachixtose para quitlepanitase TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Huan TOTECO quinilhui Moisés huan Aarón: “Ya ni nopa tlanahuatilme para nopa Pascua Ilhuitl. Niyon se catli ehua seyoc tlali amo huelis quicuas tlen nopa tlapiyali catli anquimictijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Pero se tequipanojquetl catli anquicojtoque, quena, huelis quicuas sintla ya anquitzontequilijtoque iyecapa cuetlaxo ipan itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Pero se catli ehua seyoc tlali catli san panotinemi, o se tequipanojquetl catli anquitlaxtlahuíaj pampa amo amoaxca amo hueli quicuas tlen nopa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Monequi xijcuaca sesen tlapiyali calijtic ipan san se cali. Amo xijquixtica niyon se quentzi nopa nacatl calteno. Amo xijtlapanilica niyon se iomiyo nopa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Nochi israelita masehualme sentic monequi ilhuichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Huan sintla itztoc se seyoc tlali ejquetl amohuaya catli quinequi ilhuichihuas amohuaya para quinextis catli TOTECO quichijqui ipan Pascua, monequi ma motzontequili nopa cuetlaxtli ipan itlacayo, huan san se quichihuas ica nochi ioquichpilhua huan nochi itlaca tequipanojcahua. Teipa quena, huelis quichihuas nopa ilhuitl huan quicuas nopa nacatl quen nochi sequinoc catli tlacatque ipan amotlal quichihuaj. Pero niyon se oquichpil huan niyon se tlacatl amo huelis quicuas inacayo nopa tlapiyali sintla amo motzontequilijtoc iyecapan nopa cuetlaxtli ipan itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Se catli amo motequilijtoc quen monequi amo hueli quicuas masque tlacatqui se israelita, o tlacatqui seyoc tlali huan ama itztoc tlajco amojuanti.” ");
INSERT INTO nhwBl_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Huan nochi nopa israelitame quichijque senquistoc quen TOTECO quinahuatijtoya Moisés huan Aarón. ");
INSERT INTO nhwBl_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Huajca ipan nopa tonal TOTECO quinquixti imasehualhua tlen tlali Egipto motecpantoyaj ica miyac pamitl quen soldados. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Techiyocacahuili nochi oquichpilme catli achtihui ehuaj, pampa nochi oquichpilme catli achtihui ehuaj tlen israelitame huan nochi inioquich tlapiyalhua catli achtihui ehuaj, nochi elise noaxcahua.” ");
INSERT INTO nhwBl_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Huajca Moisés quinilhui nochi masehualme: “Xiquelnamiquica ni tonal huan xiilhuichihuaca ipan ni tonal sesen xihuitl, pampa ipan ni tonal ica hueyi chicahualistli TOTECO techquixti tlen tlali Egipto campa titequipanohuayayaj quen titlacohualme catli techcojtoyaj para tiiniaxcahua. Huan ipan ni tonal amo quema xijcuaca pantzi catli quipiya tlasonejcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ama ni tonal anquisaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Huajca sesen xihuitl ipan ni metztli monequi anquielnamiquise ni tonal. Huan teipa san se anquichihuase quema TOTECO anmechhuicatos ipan nopa cuali tlali campa itztoque nopa cananeos, heteos, amorreos, heveos huan jebuseos catli quintencahuili tohuejcapan tatahua para techmacas. Nopa tlali quipiya miyac itlajca hasta mocahua. Nopona nojquiya monequi xiilhuichihuaca ipan ni metztli. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Para chicome tonali anquicuase pantzi catli amo quipiya tlasonejcayotl, huan ipan nopa tlayacapan tonali monequi anilhuichihuase para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Para chicome tonali anquicuase pantzi catli amo quipiya tlasonejcayotl. Ma amo oncas niyon se tlamantli tlasonejcayotl ipan amochaj. Huan niyon se pantzi ica tlasonejcayotl amo oncas ipan amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Huan teipa ipan nopa tonal anquinilhuise amoconehua para ya ni tijchihuaj pampa TOTECO techchihuili nochi nopa tiochicahual nextili quema techquixti ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Huan quen anquitlalisquíaj se tlanextilijcayotl ipan amomax o ipan amocuajtol catli anmechelnamiquiltisquía se tlenijqui, ya ni anmechelnamiquiltis para monequi anquitoquilise nopa tlanahuatilme catli techmacac TOTECO para nochipa, pampa nelía elqui TOTECO catli techquixti tlen tlali Egipto ica ihueyi chicahualis. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Huan yeca monequi tiilhuichihuase sesen xihuitl ipan ni tonal quen ni tlanahuatili quiijtohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Huan teipa ajsis nopa tonal quema TOTECO anmechhuicas ipan nopa tlali campa ama itztoque nopa cananeos huan yaya anmechmactilis nopa cuali tlali quen anmechtencahuili amojuanti huan amohuejcapan tatahua para quichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Huan quema anajsise nopona, nojquiya monequi anquimacase TOTECO nochi oquichpilme catli achtihui ehuani huan nochi oquich tlapiyalme catli achtihui tlacatij pampa inijuanti nelía iaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Huelis anquicohuilise TOTECO iachtihui cone se burra para elis amoaxca sintla anquinequij. Para anquicohuilise Toteco, monequi anquimacase TOTECO se pilborregojtzi quen se tlacajcahualistli para anquimanahuise nopa pilburrojtzi. Pero sintla amo anquitemactilise se pilborregojtzi quen se tlacajcahualistli para anquipatlase ica nopa pilburrojtzi, huajca monequi anquiquechpostequise nopa pilburrojtzi. Nojquiya monequi anquicohuilise TOTECO amooquichpilhua catli achtihui ehuani ica se tlacajcahualistli catli anquitemactilise. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Huan teipa quema amoconehua anmechtlatzintoquilise tlaque quiijtosnequi ni tlamantli catli tijchihuaj, anquinilhuise para TOTECO techquixti ica hueyi chicahualistli ipan tlali Egipto campa titetequipanojtoyaj quen techcojtosquíaj para tiiniaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Huan quema nopa Faraón moyoltetili huan amo techcahuayaya ma tiquisaca, TOTECO quinmicti nopa achtihui ehuani ipan sesen familia tlen nopa Egipto ehuani. Huan nojquiya quinmicti nochi inioquich tlapiyalhua catli achtihui tlacatque. Huan yeca tijmacaj TOTECO nochi oquich tlapiyalme catli tlacatij achtihui quen se tlacajcahualistli. Nojquiya tijcohuilise TOTECO tooquichpilhua catli achtihui ehuaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Huan ni ilhuitl techelnamiquiltía tlen TOTECO quen tijpixtosquíaj se tlajcuiloli ipan tomax o ipan tocuajtol para techelnamiquiltisquía se tlenijqui. Techelnamiquiltía para TOTECO techquixti tlen tlali Egipto ica hueyi chicahualistli. Quena, quej nopa anquinilhuise.” ");
INSERT INTO nhwBl_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Huajca teipa, quena, Faraón quincajqui ma quisaca nopa israelitame, huan quisque Egipto ica tepostli para tlahuilanase. Pero Toteco Dios amo quinhuicac ipan ojtli catli pano ipan inintlal nopa filisteos, masque eliyaya se ojtli más xitlahuac. Yaya moilhui: Sintla nimantzi monequi tlahuilanase, nopa israelitame sempa quinequise mocuepase tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yeca Toteco Dios quinchihuili nopa israelitame ma temoca huan ma quimacaca se huelta campa hueli ipan nopa huactoc tlali catli yohui campa nopa Hueyi Atl Chichiltic. Huan nopa israelitame quisque motecpantoque ica miyac pamitl quen soldados huan ica tepostli quen yohuiyayaj para tlahuilanatij. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Huan Moisés nojquiya quihuicayaya iomiyohua José, pampa José quichijtoya para iixhuihua Israel ma quitestigojquetzaca Toteco para quihuicasquíaj iomiyohua. Quinilhuijtoya: “Melahuac, Toteco Dios teipa hualas anmechpalehuiqui, huan quema ya nopa panos, monequi anquihuicase noomiyohua tlen tlali Egipto.” Huajca yeca quihuicaque. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Huan nopa israelitame quistejque ipan Sucot huan yajque hasta Etam campa pehua nopa huactoc tlali, huan nopona quiquetzque ininyoyoncalhua catli tlaxinepaloli ica iniijhuiyo chivojme. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Huan ica tonaya TOTECO itztoya ininhuaya ipan se mixtli catli quinyacanayaya ipan ojtli huan ica tlayohua quinyacanayaya ica se tlilelemectli catli quintlatlanextiliyaya. Yeca inijuanti huelque nejnemij tonaya huan tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Huajca mojmostla nopa mixtli tlayacantiyajqui tonaya huan nopa tlilelemectli ica tlayohua huan amo quema quincajtejqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Xiquinilhui nopa israelitame ma mocuepaca huan ma quiquetzaca ininyoyoncalhua ipan Pi Hahirot, tlatlajco Migdol huan nopa hueyi atl. Nopona mocahuase ateno iixmelac Baal Zefón. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Quej nopa Faraón moilhuis para anmomasiltijtoque pampa anitztoque tlatlajco huactoc tlali huan hueyi atl huan amo huelis ancholose. Moilhuis amo anquimatij canica anyase huan san anmocuapolojtinemij ipan huactoc tlali. Quej nopa moilhuis. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Huan nijchihuas Faraón ma moyoltetili huan ma anmechtepotztoca. Huan huajca nijnextis nochicahualis ipan ya ininhuaya isoldados para nopa egiptome ma quimatica na niitztoc niamoTECO.” Huan nopa israelitame quichijque quen TOTECO quiijto. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Huajca quema nopa tlanahuatijquetl tlen tlali Egipto quicajqui para israelitame cholojtoyaj, yaya ininhuaya catli quipalehuiyayaj moyolcuepque, huan moilhuijque: “¿Para tlen tiquincahuilijque ma yaca nopa israelitame huan ayacmo ma techtequipanoca?” ");
INSERT INTO nhwBl_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Huan nimantzi Faraón tlanahuati para ma quicualtlalica itlahuilanca carro huan quisqui quinyacantiyajqui isoldados. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Huan iica hualajque 600 tlahuilanca carros catli más cuajcualme ihuaya nochi sequinoc tlahuilanca carros tlen Egipto, huan itlayacanca soldados itztoyaj ipan sesen carro. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Huan TOTECO quichijqui Faraón ma moyoltetili huan ma quintoquili nopa israelitame masque inijuanti ya quistoyaj ica hueyi chicahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Huan nopa egiptome ica nochi ininsoldados huan tlahuilanca carros huan cahuayojme quisque quintepotztocaque israelitame, huan quinajsitoj iteno nopa hueyi atl nechca Pi Hahirot huan iixpa Baal Zefón campa quiquetztoyaj ininyoyoncalhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Huan quema nopa israelitame momacaque cuenta para Faraón ihuaya nopa egiptome monechcahuiyayaj, tlahuel majmajque huan quitlajtlanijque TOTECO ma quinpalehui. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Huan nopa israelitame quiilhuijque Moisés: ―¿Para tlen techhualicatoc nica para ma timiquica ipan ni huactoc tlali? Sintla tijnequiyaya techmictis, oncayaya campa techtlalpachojtosquía ipan tlali Egipto. ¿Para tlen techquixti tlen nopona? ");
INSERT INTO nhwBl_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ipan Egipto timitzilhuijque para san techcahua para ma tiquintequipanoca egiptome. Más cuali elisquía noja tiquintequipanosquíaj huan amo timiquise nica ipan huactoc tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Pero Moisés quinnanquili: ―Amo ximajmahuica. San ximoquetzaca huan amo ximolinica huan xiquitaca quenicatza TOTECO anmechmaquixtis, pampa nopa egiptome catli ama anquinitaj ayacmo quema anquinitase sempa. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Niyon amo monequi antlahuilanase, TOTECO tlahuilanas por tojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Huajca TOTECO quiilhui Moisés: ―¿Para tlen san antechtlajtlaníaj tlapalehuili? ¡Xiquinnahuati nopa israelitame ma quiitzquica iniojhui! ");
INSERT INTO nhwBl_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Huan ta xijtlanana mocuatopil huan xijxitlahua momax para tijtlajcoitas nopa hueyi atl ica ome, huan huajca nopa israelitame huelis quiixcotonase ipan se ojtli huactoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Huan na nijchihuas nopa egiptome ma moyoltetilica huan ma anmechtoquilica ipan hueyi atl. Huan huajca nijnextis nochicahualis iixtla Faraón, huan isoldados, huan inintlahuilanca carros, huan inijuanti catli yohuij ipan cahuayos. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Huan quema ya nijnextijtos nochicahualis ipan Faraón, huan itlahuilanca carros, huan ipan inijuanti catli tlejcotoque ipan cahuayos, nopa egiptome quimatise para na niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Huan itequihua Toteco Dios catli itztoya ininhuaya ipan nopa mixtli catli nejnemiyaya iniixpa, mopatlac campa itztoya huan motlali iniica. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Huan yeca nopa mixtli mocajqui tlatlajco nopa soldados tlen Egipto huan nopa israelitame. Huan iica nopa mixtli nesiyaya yayahuic iniixtla nopa egiptome, pero iixpa nopa mixtli quintlahuiliyaya nopa israelitame. Huajca yeca nopa egiptome amo huelque quinajsij nopa israelitame nochi nopa tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Huan Moisés quixitlajqui imax ipan nopa hueyi atl, huan TOTECO quititlanqui se ajacatl chicahuac catli hualajqui campa hualquisa tonati huan tlaajacac nochi tlayohua huan quitlajcoitac nopa hueyi atl. Huajca quej nopa TOTECO quicuepqui nopa hueyi atl ica huactoc tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Huan nesqui ipan hueyi atl se huactoc ojtli huan ipan nopa ojtli nopa israelitame panoque tlatlajco campa motlapojtoya huan moquetztoya nopa atl tlahuel huejcapa quen eliyaya ome tepamitl, se ipan ininnejmac huan seyoc ipan iniopoch. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Huan teipa nopa tlali Egipto ehuani quintoquilijque. Quena, nochi nopa cahuayos ica icarros Faraón huan inijuanti catli yohuiyayaj ipan cahuayos calajque inintepotzco huan quintoquilijtiyajque hasta tlatlajco nopa hueyi atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Huan tlajco yohual, TOTECO catli itztoya ipan nopa hueyi mixtli huan ipan nopa tlilelemectli quinitac nopa soldados egiptome huan quinhuihuichijqui para ma amo quimatica tlaque quichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Huan quinquixtili nopa tepos yahuali ipan inincarros para ma ayacmo huelica quihuicase inincarrojhua. Huajca nopa egiptome quiijtojque: ―Ma timochololtica tlen ni israelitame, pampa DIOS, ininTECO techhuilana huan quinmanahuía. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Huan teipa quema nopa israelitame ajsitoj seyoc nali, TOTECO quiilhui Moisés: ―Xijxitlahua momax ipan nopa hueyi atl para nopa atl ma mosentili huan ma quinatzonpolihuilti nopa egiptome ipan inintlahuilanca carros ininhuaya catli tlejcotoque ipan cahuayojme. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Huan Moisés quixitlajqui imax ipan nopa hueyi atl, huan quema tlanestihualayaya, nopa atl mocuepqui campa ipa eltoya. Huan quema nopa egiptome quinejque cholose, nopa hueyi atl quinhuicac, huan quej nopa TOTECO quinisahui. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Huan quema nopa atl mocuepqui campa ipa eltoya, quinatzonpolihuilti nochi nopa soldados, carros huan cahuayojme catli calactoyaj ipan hueyi atl para quintoquilise israelitame. Niyon se tlen isoldados Faraón mocajqui yoltoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Pero nopa israelitame ya quiixcotontoyaj nopa hueyi atl ipan se ojtli huactoc tlatlajco campa moquetztoya nopa atl quen ipan ome tepamitl tlen atl, se ipan ininnejmac huan se ipan iniopoch. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Huajca nopa tonal TOTECO quinmaquixti nopa israelitame tlen nopa egiptome huan nopa israelitame quiitaque inintlacayohua nopa egiptome iteno nopa hueyi atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Huan quema nopa israelitame quiitaque nopa hueyi chicahualistli catli TOTECO quinextijtoya ica nopa egiptome, quihueyitlepanitaque, huan motemachijque ipan ya huan ipan itequipanojca Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Huajca Moisés ininhuaya nopa israelitame huicaque ni huicatl para TOTECO: “Nihuicas para TOTECO pampa tlatlanqui ica ihueyi chicahualis. Quinisahui ipan hueyi atl nopa cahuayojme ininhuaya catli ininpan tlejcotoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","TOTECO nechchijtoc ma nihuica ica paquilistli. Yaya Notemaquixtijca catli nechfuerzajmaca. Yaya Dios noTeco catli nijtlepanita, huan nijpaquilismacas. Yaya nopa Dios catli notata quihueyichijqui, huan nijhueyitlalis. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","TOTECO ya nopa tlahuilanquetl catli más quipiya chicahualistli. Quena, TOTECO, ya nopa itoca. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Quinisahui ipan hueyi atl nopa tlahuilanca carros, ininhuaya isoldados Faraón. Nopa soldados catli más cuajcualme ipan nochi tlali Egipto, misahuijque ipan hueyi atl catli itoca Chichiltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Huetzque hasta atzintla quen teme. Huan nopa atl catli huejcatla quinatzonpolihuilti. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","¡Ay, TOTECO! Tijpiya hueyi chicahualistli, huan tiquintlamilti tocualancaitacahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Huan ica mohueyi chicahualis tiquinpolo catli motlalijque moixpa. Tlejcoc mocualancayo quen se hueyi tlitl, huan quinpolihuilti. Inijuanti tlami tlatlaque quen sacatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Chicahuac tiquilpitzqui nopa hueyi atl, huan nopa atl motlajcoitac. Nopa hueyi atl motlananqui huan moquetzqui oncac, quen moquetzaj ome huejcapantique tepame. Nopa hueyi atl catli huejcatla motetictlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Tocualancaitacahua mohueyimatque huan quiijtojque: ‘Tiquintoquilise hasta tiquinajsitij, huan tiquinquixtilise nochi catli quipiyaj huan timochihuase tiricos ica catli iniaxca. Teipa tijquixtise tomachete huan tiquintzontlamiltise ica tomax.’ Quej nopa moilhuijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Pero ta, TOTECO, titlailpitzqui, huan nopa hueyi atl quintolo. Misahuijque quen tepostli ipan atl catli huejcatla. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","¡Ay TOTECO! Amo aqui seyoc Dios catli ica huelis timitzhuicalotise. Amo aqui tlatzejtzeloltic quen ta. Amo aqui quipiya mohueyi chicahualis. Catli ta tijchihua temajmatía. Huajca quinamiqui para timitzhueyichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Titenextili mochicahualis, huan quintolo nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ica moteicnelijcayo techyacanas tojuanti timomasehualhua catli techmaquixtijtoc. Ica mochicahualis techhuicas hasta mochaj catli tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Nochi tlacame ipan nochi tlalme huihuipicase quema quimatise catli tijchijtoc. Nopa filisteos majmahuise pampa quinitzquis majmajtli. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Huan nopa tlayacanani tlen soldados ipan tlali Edom, niyon amo huelis tlaijiyotilanase. Nopa tlanahuatiani tlen tlali Moab huihuipicase ica majmajtli. Huan ayacmo quipiyase chicahualistli inijuanti catli mooquichmatiyayaj ipan tlali Canaán. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Hueyi majmajtli quinajsis. Quena, quinamiqui ma majmahuica. Tocualancaitacahua ayacmo techhuilanase, san majmahuise ica mohueyi chicahualis, TOTECO, huan mocahuase quen teme. Tojuanti catli techcojtoc para timoaxcahua tijpanoque nopa atl ica temachili. Inijuanti amo tleno huelqui techchihuilise pampa ta techmanahuijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","¡Ay TOTECO! Techhuica para tiitztotij ipan motepe catli tlatzejtzeloltic, Techyacana hasta nopa tlali campa tijtlapejpeni para tiitztose, nopona ipan mochaj catli ta tijchijchijqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","TOTECO, titlanahuatis para nochipa.” ");
INSERT INTO nhwBl_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Quema itlahuilanca carros Faraón huan icahuayojhua huan catli ipan tlejcotoyaj calajque ipan hueyi atl, TOTECO quichijqui nopa hueyi atl ma quinhuica. Pero nopa israelitame quiixcotonque nopa hueyi atl ipan se ojtli huactoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Huajca nopa sihua tlajtol pannextijquetl María, ihuelti Aarón, quicuic se tepos tlatzilintli, huan nochi israelita sihuame quitoquilijque quitzilinijtiyohuiyayaj tepos tlatzilintli, huan huicayayaj, huan mijtotiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Huan María huicayaya huan quinnanquiliyaya ica ni camanali: “Xihuicaca para TOTECO, pampa tlatlanqui ica ihueyi chicahualis. Quinisahui ipan hueyi atl nopa cahuayojme, huan inijuanti catli ipan tlejcotoyaj.” ");
INSERT INTO nhwBl_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Huan Moisés quinyacanqui nopa israelitame huan quistejque tlen nopa Hueyi Atl Chichiltic, huan yajque ipan nopa huactoc tlali itoca Shur. Huan nejnenque para eyi tonali pero amo quipantiyayaj atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Huan quema quiajsique se ameli itoca Mara, amo huelque quiijique nopa atl catli oncayaya nopona pampa eliyaya chichic. Yeca nopa ameli quitocaxtijque Mara catli quinequi quiijtos “chichic”. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Huan nopa israelitame pejque cualancamanaltij ica Moisés, huan quiijtohuayayaj: “¿Tlaque huelis tiquijise?” ");
INSERT INTO nhwBl_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Huajca Moisés quitlajtlani TOTECO itlapalehuil para quimatis tlaque quichihuas, huan TOTECO quinextili se cuamacuayotl. Huan Moisés quimajcajqui nopa cuahuitl ipan atl, huan nopa atl mocuepqui se cuali atl. Huajca nopona TOTECO quincamanalhui israelitame para quinyejyecos sintla quitoquilisquíaj huan ya ni catli quintencahuili. ");
INSERT INTO nhwBl_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Quinilhui: “Sintla anquitlacaquilise catli niamoTECO Dios nimechilhuía, huan anquichihuase catli xitlahuac noixpa huan anquineltocase notlanahuatil, amo nimechtitlanilis niyon se cocolistli catli nijtitlanqui ipan nopa egiptome, pampa na niamoTECO Catli Nimechchicahua.” ");
INSERT INTO nhwBl_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Huan teipa nopa israelitame ajsitoj Elim campa oncayaya majtlactli huan ome ameli huan 70 apachi cuame, huan nopona nechca atl quiquetzque ininyoyoncalhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Huan nochi israelitame quisque Elim huan ajsique ipan nopa huactoc tlali catli itoca Sin catli mocahua tlatlajco Elim huan Sinaí. Huan ajsitoj nopona ipan 15 itequi nopa ompa metztli ipan ininxihui. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Huan nopona ipan nopa huactoc tlali, nochi pejque quintlaijilhuíaj Moisés huan Aarón. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Huan nopa masehualme quinilhuiyayaj: ―Más cuali eltosquía sintla TOTECO techcahuilijtosquía ma timiquica ipan tlali Egipto. Nepa timosehuiyayaj nechca nopa chachapali catli temitoya ica nacatl huan titlacuayayaj hasta tiixhuiyayaj, pero ama antechhualicatoque ipan ni huactoc tlali para antechapismictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Huajca TOTECO quiilhui Moisés: ―Nijchihuas para tlacualistli ma huetzi tlen ilhuicac quen quema tlaquiyahui. Huan mojmostla nopa israelitame monequi quisentilitij san catli quitequihuise ipan nopa tonal. Nijnequi niquitas ajqueya quineltocas catli niquilhuis huan ajqueya, amo. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Huan sesen semana ipan nopa chicuasempa tonal quema quisentilise imiyaca catli quihuicase ininchaj, ma quisentilica catli monequi para ome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Huan Moisés huan Aarón quinilhuijque nopa israelitame: ―Ica tiotlac anquimatise para yaya TOTECO catli anmechquixti ipan tlali Egipto, ");
INSERT INTO nhwBl_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","huan ica ijnaloc anquiitase itlatlanex, pampa quicajqui para anquitlaijilhuiyayaj. Pampa amo na huan Aarón catli antechtlaijilhuíaj ¿Tiajqueyame? Tojuanti amo titlanahuatíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Huan Moisés quiijto: ―Ica tiotlac TOTECO anmechmacas nacatl para antlacuase, huan ica ijnaloc anmechmacas pantzi hasta mocahuas, pampa quicactoc para amojuanti anquitlaijilhuijque. Amo tojuanti antechtlaijilhuijtoque. Tojuanti amo tleno topati. Pero quena, anquitlaijilhuijque TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Huan teipa Moisés quiilhui Aarón ma quinilhui nochi israelitame: ―Ximonechcahuica iixpa TOTECO, pampa ya quicactoc catli ica anquitlaijilhuijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Huan ipan nopa tlatoctzi quema Aarón quincamanalhuiyaya nopa israelitame, nochi tlachixque ica campa nopa huactoc tlali, huan itlatlanex TOTECO monexti ipan se mixtli. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","―Nijcactoc quen noca camanaltij huan nechtlaijilhuíaj ni israelitame. ‘Xiquinilhui para quema tiotlaquiyas, quicuase nacatl, huan ica ijnaloc quicuase pantzi hasta ixhuise. Quej nopa quimatise para na niDIOS, niininTECO.’ ");
INSERT INTO nhwBl_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Huan nopa tiotlac hualajque miyac totome catli inintoca codornices, huan quitemitijque campa nopa israelitame itztoyaj. Huan ica ijnaloc huetztoya ajhuachtli huan quinyahualojtoya campa mocahuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Huan teipa quema nopa ajhuachtli ya pojquejtoya, mocajqui ipan nopa tlali se tlamantli chipahuac quen ichcatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Huan nopa israelitame amo quimatiyayaj tlaque eliyaya, huajca quema quiitaque moilhuiyayaj se ica seyoc: “¿Huan ya ni tlaque?” Huan Moisés quinilhui: ―Ya ni nopa pantzi catli TOTECO anmechmacatoc para amotlacualis. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Huan ya ni nopa tlanahuatilme catli techmacatoc TOTECO: Xijsentilica sesen amojuanti catli monequi para quicuase catli itztoque ipan amochaj. Xijcuica quen ome litros para sesen masehuali ipan amofamilia ma quicuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Huan nopa israelitame quichijque quen quinilhuijtoya. Huan sequin miyac quisentilijque huan sequinoc amo más. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Huan quitamachijque ica se tlatamachihuali itoca gomer catli quicui nechca ome litros. Huan amo mocajqui catli quisentilijtoya miyac, niyon amo quipolo catli quisentilijtoya quentzi. Sesen inijuanti quipixqui san catli monequiyaya para quicuase ichampoyohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Huan teipa Moisés quinilhui: ―Amo aqui ma quicahua niyon se quentzi ni tlacualistli para hualmostla. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Pero sequin amo quichihuilijque cuenta Moisés huan quiajojque nopa tlacualistli para ne seyoc tonal. Huan hualmostla quipantijque ocuilojtoya huan mijyotiyaya. Huajca Moisés cualanqui ininhuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Huajca sesen israelita quisentiliyaya ica ijnaloc catli monequiyaya para quicuase, huan tlajcotona quema tlatotoniyayaya atiyayaya catli mocahuayaya tlalchi. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Pero ipan chicuasempa tonal quisentiliyayaj catli quicuasquíaj para ome tonali, quiijtosnequi se nahui litro para sesen masehuali. Huan nopa israelita tlayacanani yajque quipohuilitoj Moisés catli quichihuayayaj, ");
INSERT INTO nhwBl_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","huan Moisés quinilhui: ―¡Cuali! Ya nopa catli TOTECO tlanahuatijtoc, pampa mostla elis nopa tonal para ma timosiyajquetzaca. Timosiyajquetzase pampa se tonal tlatzejtzeloltic. Nopa tonal tlaiyocatlalili san para TOTECO huan amo titequitise. Huajca xijmolonica catli anquinequij huan xiquicxitica catli anquinequij ama huan xijtequihuica catli monequi ama, pero xicajocuica catli mocahuas para mostla. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Huan quen tlanahuati Moisés, quiajojque tlacualistli para hualmostla, catli elis nopa chicompa tonal. Huan hualmostla noja elqui cuali. Amo potehui, niyon amo quinpixqui ocuilime. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Huajca ipan sábado Moisés quiijto: ―Ama xijcuaca catli mocahua pampa ama ni tonal para timosiyajquetzase ica TOTECO huan amo anquipantise tlacualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mojmostla para chicuasen tonali huelis anquisentilise, pero ipan nopa chicompa tonal, timosiyajquetzase huan amo tleno oncas calteno para anquisentilise. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Pero sequin masehualme quisque ipan nopa chicompa tonal para quisentilise, pero amo tleno quipantijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Huajca TOTECO quiilhui Moisés: ―¿Hasta quema anquineltocase catli nimechnahuatía huan catli nimechmachtía? ");
INSERT INTO nhwBl_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Xiquitaca para na, niamoTECO, nimechmacatoc ni tonal para ximosiyajquetzaca. Yeca ipan nopa chicuasempa tonal nimechmacas tlacualistli para ome tonali. Huan ipan nopa chicompa tonal nochi monequi mocahuase ipan ininchajchaj huan amo ma quisaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Huajca nopa israelitame mosiyajquetzque ipan nopa chicompa tonal. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Huan quitocaxtijque “maná” nopa chipahuac pantzi catli quisentiliyayaj. (Maná quinequi quiijtos: “¿Tlaque ya ni?”) Eliyaya chipahuac quen culanto iyol, huan iajhuiyaca elqui quen pantzi catli quichijtoque ica nectli. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Huan Moisés quiijto: ―TOTECO nechmacatoc tlanahuatili ma tijtemitica ome litros ica maná huan ticajocuise para toixhuihua catli teipa tlacajtiyase ma quiitaca nopa tlacualistli catli TOTECO techmacac ipan ni huactoc tlali quema techquixti ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Huajca Moisés quiilhui Aarón para ma quicui se chiquihuitl huan ma quitema nopona ome litros tlen maná. Huan quiilhui para teipa ma quitlali iixpa TOTECO huan ma quiajocui para iniixhuihua quiitase. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Huajca Aarón quichijqui catli TOTECO quinahuati Moisés, huan teipa quitlali nopa chiquihuitl ipan icaxa TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Huan nopa israelitame quicuajque maná para 40 xihuitl hasta ajsitoj ipan tlali Canaán campa sequinoc tlatoctoyaj huan oncayaya catli quicuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Huan inijuanti quitequihuijque se tlatamachihuali itoca gomer catli elqui quen ome litros. Huan monequiyaya majtlactli gomer para elisquía se tlatamachihuali catli itoca efa catli quicuisquía quen 20 litros. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Huan nochi nopa miyaqui israelitame quisque tlen tlali Sin huan yajque ica yolic quen TOTECO quinnahuatiyaya. Huan nejnentiyajque huan quiijcuinijtiyajque ininyoyoncalhua mojmostla hasta ajsitoj campa itoca Refidim. Pero nopona amo oncayaya atl para atlise, ");
INSERT INTO nhwBl_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","huajca cualanque ica Moisés huan quiilhuijque: ―¡Techmaca atl para tiatlise! Huan Moisés quinnanquili: ―¿Para tlen ancualanij noca na? San anquicualancamacaj huan anquiyejyecohuaj TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Pero nochime amiquiyayaj huan quitlaijilhuiyayaj Moisés, huan quiilhuijque: ―¿Para tlen techchijqui ma tiquisaca ipan tlali Egipto? ¿Para tlen techhualicac nica? San techamictis ica toconehua huan totlapiyalhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Huajca Moisés quinojnotzqui TOTECO huan quiilhui: ―¿Tlaque nijchihuas ica ni masehualme? ¡San se quentzi más huan nechtejtzonase! ");
INSERT INTO nhwBl_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Huan TOTECO quinanquili: ―Xijhuica nopa cuatopili catli ica tijmaquili nopa hueyatl Nilo. Huan xiquisa huan ximotlali iniixpa ni masehualme para titlayacanas. Huan xiquinhuica mohuaya sequin nopa huehue tlacame catli quihuicaj tequitl ica israelitame, huan xiya. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Huan na nimitzchixtos campa nopa tetl nechca tepetl Horeb. Huan xijmaquili nopa tetl huan nopona quisas atl para ma atlica nochi ni israelitame. Huajca Moisés quej nopa quichijqui iniixpa nopa huehue tlacame tlen nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Huan quitocaxti nopa lugar Masah. (Masah quinequi quiijtos “campa quiyejyecojque TOTECO para ma quinmicti”.) Huan nojquiya quitocaxti Meriba. (Meriba quinequi quiijtos “tlanajnanquilistli”.) Quej nopa quitocaxti pampa nopona nopa israelitame tlanajnanquilijque huan quiyejyecojque TOTECO huan quiijtojque: “¿Itztoc TOTECO tohuaya o amo aqui?” ");
INSERT INTO nhwBl_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Huan hualajque nopa amalecitame huan pejque quinhuilanaj nopa israelitame ipan Refidim. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Huan Moisés quiilhui Josué: ―Xiquintlapejpeni tlacame huan xiquinhuilanatij nopa amalecitame. Huan mostla na nimoquetzas tlachiquiltipa ica icuatopil Toteco nomaco. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Huan Josué huan nopa tlacame quichijque catli Moisés quinnahuati, huan quinhuilanatoj nopa amalecitame. Huajca Moisés, Aarón huan Hur tlejcoque tlachiquiltipa para quintlachilise. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Huan quema Moisés quitlananayaya imax, nopa israelitame tlatlaniyayaj, pero quema quitemohuiyaya imax, tlatlaniyayaj nopa amalecitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Huan teipa Moisés macuatqui. Huajca quicuique se tetl para ipan mosehuis huan Aarón ihuaya Hur quimatlanantoyaj. Se moquetzqui ica inejmac huan se ica iopoch. Huajca san quej nopa Moisés huelqui quiijiyohui ica imax huejcapa hasta quema calajqui tonati. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Huan yeca Josué quintlamimicti nopa amalecita soldados ica imachete. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Huan TOTECO quiilhui Moisés: ―Xiquijcuilo ni camanali ipan se amatl catli huejcahuas para ma quielnamiquica nopa israelitame para nochipa, huan nojquiya xijyolmelahua Josué tlen ya ni. Na niquintlamiltis nochi nopa amalecitame ipan ni tlaltipactli huan amo aqui quinelnamiquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Huan Moisés quichijqui se tlaixpamitl catli quitocaxti: “TOTECO Itztoc Quen Se Bandera Catli Techyacana.” ");
INSERT INTO nhwBl_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Huan Moisés quiijto: “Quen se bandera tomaco, Toteco techyacana ma titlatlanica. Pampa nopa amalecita masehualme motlanantoque iixpa TOTECO, yaya quinhuilanas para nochipa.” ");
INSERT INTO nhwBl_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Huan Jetro, nopa totajtzi tlen tlali Madián catli elqui imonta Moisés, quicajqui quenicatza TOTECO quinquixtijtoya nopa israelitame tlen tlali Egipto. Nojquiya quicajqui nochi nopa yejyectzi tlamantli catli quinchihuilijtoya Moisés huan imasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Moisés quititlantoya isihua, Séfora, ma yohui ichaj quema quinmanahuiyaya nopa israelitame. Huan Jetro imonta Moisés sempa quiselijtoya iichpoca ininhuaya iome conehua. Se tlen nopa coneme itoca eliyaya Gersón. (Gersón quinequi quiijtos “seyoc tlali ejquetl”.) Quej nopa Moisés quitocaxti pampa quiijtojtoya: “Nielqui nise seyoc tlali ejquetl ipan se tlali catli amo niquiximati”. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Huan nopa seyoc icone itoca eliyaya Eliezer. (Eliezer quinequi quiijtos “Toteco Dios yaya notlapalehuijca”.) Quej nopa quitocaxti pampa quiijtojtoya: “Toteco Dios catli notata quitoquili hualajqui nechpalehuico huan nechmaquixti tlen imachete Faraón.” ");
INSERT INTO nhwBl_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Huajca se tonal quema nopa israelitame ya ajsitoyaj ipan huactoc tlali, Jetro quicuitejqui isihua huan iconehua Moisés huan yajque campa Moisés quiquetztoya ichaj tlen yoyomitl nechca itepe Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Huan Jetro tlatitlanqui ma quiyolmelahuati Moisés para ajsiyayaj. Quiilhui: ―Na niJetro, momonta. Nihualajtoc nimitzitaqui huan niquinhualica mosihua huan moconehua. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Huan Moisés quisqui quiselito imonta, huan quitlajpalo ica yejyectzi huan quitzoponi. Huan teipa quema motlajpalojque, calajque ipan se cali tlen yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Huan nopona Moisés quipohuili imonta nochi catli TOTECO quinchihuilijtoya Faraón huan nopa egiptome pampa quinicneli nopa israelitame. Huan quipohuili nochi tlamantli catli ininpantitoya ipan ojtli huan quenicatza TOTECO quinmaquixtijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Huan Jetro paquiyaya quema quicajqui quenicatza TOTECO quinpalehuijtoya nopa israelitame huan quinmaquixtijtoya tlen nopa egiptome. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Huan Jetro quiijto: ―Ma tijhueyichihuaca TOTECO catli anmechmanahuijtoc ininmaco Faraón huan nochi egiptome, huan nochi catli fiero inijuanti anmechchihuiliyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ama nimomacatoc cuenta para TOTECO yaya más hueyi tlen nochi sequinoc catli quintocaxtlalíaj dioses, pampa anmechmanahuijtoc ininmaco masehualme catli mohueyimatiyayaj huan catli fiero anmechchihuiliyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Teipa Jetro quimacac Toteco sequin tlacajcahualistli huan quitlati se tlapiyali iixpa. Huan Aarón ihuaya nochi nopa huehue tlacame tlen nopa israelitame yajque tlacuatoj ihuaya imonta Moisés iixpa Toteco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Hualmostla Moisés mosehui quen juez para quintlacaquilis nopa israelitame catli motelhuiyayaj se ica seyoc. Huan nochi nopa tonal miyac masehualme ijcatoyaj iixpa hasta nochi cuatiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Huajca quema Jetro imonta Moisés quiitac nochi nopa tequitl catli Moisés iseltzi quichihuayaya iniixpa nopa israelitame, quiilhui: ―¿Tlaque tiquinchihuilía ni masehualme? Amo cuali para san ta timosehuía para titetlajtolsencahuas huan nochi inijuanti se tonal moquetztoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Huan Moisés quinanquili imonta: ―Nochi hualahuij nechitaquij para ma nijtlajtlani Toteco Dios tlaque ipaquilis. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Huan quema mocualaníaj se ica seyoc, hualahuij nechitaquij para ma niquinilhui ajqueya quichijtoc catli melahuac. Huajca na niquinilhuía tlaque quiijtohua Toteco Dios huan tlaque itlamachtil. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Huajca Jetro, imonta Moisés, quiilhui: ―Amo cuali catli tijchihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tisiyajcamiquis huan nojquiya siyahuise nochi nopa masehualme catli hualahuij campa ta. Ni tequitl nel tetic para ta. Moseltzi amo huelis tijtlamichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Huajca ama xijcaqui huan nimitzilhuis catli monequi tijchihuas huan Toteco mitztiochihuas. Ta motequi timonextis iixpa Toteco por nochi ni masehualme huan xijtlali iixpa nopa tlamantli catli quincuesohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Nojquiya monequi xiquinmachti itlanahuatilhua huan catli yaya quiijtohua huan xiquinilhui quenicatza monequi itztose huan tlaque monequi quichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Nojquiya monequi xiquintlapejpeni tlen nochi nopa masehualme sequin tlayacanca tlacame catli temachme huan catli quitlepanitaj Toteco Dios. Xiquintlapejpeni catli amo istlacatij huan catli amo quinequij catli seyoc iaxca. Xiquintlali sequin nopa tlayacanca tlacame ma quipiyaca tlanahuatili ica mil masehualme. Huan tlatzintla sese inijuanti, xiquintlali 10 tlacame catli quipiyase tlanahuatili ica san 100 masehualme. Huan tlatzintla sesen nopa 100 masehualme, xiquintlali 2 tlacame catli quipiyase tlanahuatili ica san 50 masehualme. Huan tlatzintla sesen nopa 50 masehualme, xiquintlali 5 tlacame catli san quipiyase tlanahuatili ica 10 masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Huan inijuanti quisencahuase catli quincuesos ni masehualme ipan tlen hueli tlatoctzi. Huan san nopa tlamantli catli más huejhueyi mitzhualiquilise huan inijuanti quisencahuase nochi tlamantli catli amo ohui. Quej nopa amo elis tlahuel ohui nopa tequitl pampa anquichihuase san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Sintla Toteco mitznahuatis para techtlacaquilis, huajca huelis tiquijiyohuis motequi, huan nochi nopa masehualme paquise. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Huajca Moisés quitlacaquili imonta huan quichijqui nochi catli quiilhuijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Quintlapejpeni tlayacanca tlacame catli más temachme ipan nopa israelitame huan quinmacac sequin inijuanti tlanahuatili ica sesen mil masehualme. Huan tlatzintla tlen sesen nopa tlayacanani, quinmacac 10 tlacame tlanahuatili ica 100 masehualme. Huan tlatzintla sesen nopa tlacame, quinmacac 2 tlacame tlanahuatili ica 50 masehualme. Huan tlatzintla sesen inijuanti, quinmacac 5 tlacame tlanahuatili ica 10 masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Huan inijuanti quintlajtolsencahuayayaj masehualme ipan tlen hueli hora. Huan san nopa tlamantli catli huejhueyi quihuiquiliyayaj Moisés, pero nochi camanali catli amo más ohui quisencahuayayaj inijuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Huan teipa Moisés quinahuatijtejqui imonta, Jetro, huan yaya mocuepqui itlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Ipan nopa tonal quema quiaxiti eyi metztli para quistoyaj nopa israelitame tlen tlali Egipto, inijuanti ajsitoj ipan nopa huactoc tlali nechca tepetl Sinaí. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Huan teipa quistejque ipan Refidim huan ajsitoj campa tepetl Sinaí, huan nopona quiquetzque ininyoyoncalhua iixpa nopa tepetl ipan nopa huactoc tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Huan nopona Moisés tlejcoc ipan nopa tepetl para mopantis ihuaya Toteco Dios. Huan TOTECO quinojnotzqui Moisés tlen nopa tepetl huan quiilhui ma quinilhui nopa israelitame 19:3 Iixhuihua Jacob. ni camanali: ");
INSERT INTO nhwBl_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","―Amojuanti ya anquiitztoque catli nijchijqui ica nopa egiptome. Anquimatij nimechmocuitlahuijtoc. Quena, quen se hueyi cuajtli quinhuica iconehua ipan ieltlapal para amo tleno huelis quinajsis, quej nopa nimechhualicatoc campa na. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Huajca ama sintla anquicaquise catli nimechilhuijtoc huan anquichihuase nopa camanali catli nijpiya amohuaya, huajca anelise annotlapejpenilhua tlen nochi masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Huan anelise se altepetl ica seyoc xinachtli masehualme catli iyoca tlen nochi sequinoc. Nochi anitztose totajtzitzi huan tlatzejtzeloltique noixpa. Quej nopa TOTECO quiilhui Moisés ma quinilhui nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Huajca Moisés yajqui huan quinnotzato nopa huehue tlacame catli quipiyayayaj tlanahuatili ica nopa israelitame huan quinilhui nochi catli TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Huajca nochi nopa israelitame tlananquilijque san se: ―Nochi catli TOTECO tlanahuatijtoc, tijchihuase. Huajca Moisés yajqui quiilhuito TOTECO tlaque nopa israelitame tlananquilijtoyaj, ");
INSERT INTO nhwBl_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Huan TOTECO quiilhui: ―Xiquita, naya nimonextis amoixpa ipan se mixtli catli tilahuac para nopa masehualme ma nechcaquica quema nimitzcamanalhuis. Quej nopa motemachise mopan ta para nochipa. Huan Moisés quiilhui TOTECO tlaque quinanquilijtoyaj nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Huan TOTECO quiijto: ―Xiya xiquincualtlaliti nopa masehualme ama huan mostla, huan xiquiniyocacahua senquistoc para na. Monequi quichicuenise ininyoyo, ");
INSERT INTO nhwBl_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","huan ma mocualtlalise para huiptla, pampa huiptla nitemos na niamoTECO, huan niitztos ipan tepetl Sinaí iniixpa nochi nopa masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Huajca xijchihua se nepamitl catli quiyahualos nopa tepetl huan xiquinnahuati nopa masehualme ma amo quiixcotonaca. Huan xiquinilhui ma quipiyaca cuidado ma amo tlejcoca, niyon ma amo ajsica campa nopa nepamitl, pampa catli quiajsis nopa tepetl o nopa nepamitl temachtli monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Huan amo aqui huelis quitlalis imax ipan nopa masehuali o nopa tlapiyali catli monequi miquis, pampa monequi anquimictise ica tetl o ica cuatlamintli. Masque se masehuali o se tlapiyali, pero amo huelis anquicahuase ma itzto. Masehualme san huelise monechcahuise itzintla nopa tepetl quema quicaquise quipitzaj icuacua se oquich borrego. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Huajca Moisés temoc tlen nopa tepetl huan quincualtlali nopa masehualme para quihueyichihuase Toteco. Huan nochi quichicuenijque ininyoyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Huan Moisés quinilhui: ―Monequi anmocualtlalise para huiptla. Huan tlacame huan sihuame ma amo motecaca san sejco ipan ni tonal. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Huan ihuiptlaca quema hualmostla, pejqui tlatomoni huan tlapetlani, huan se mixtli catli nelía tilahuac motlali ipan nopa tepetl. Huan quicajque se tlapitzali catli nelía chicahuac hasta nochi nopa israelitame pejque huihuipicaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Huan Moisés quinyacanqui nochi nopa israelitame, huan inijuanti quisque campa quiquetztoyaj ininchajchaj para mopantise ihuaya Toteco Dios. Huan moquetzatoj itzintla nopa tepetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Huan nochi nopa tepetl Sinaí popocayaya pampa TOTECO temotoya ipan se tlitl ipani. Nopa poctli tlejcoyaya quen campa tlacacatzohuaj, huan nochi nopa tepetl mojmoliniyaya tlahuel chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Huan quema nopa tlapitzali tlahuel chicahuac eltiyajqui, Moisés camanaltic, huan Toteco Dios quinanquili ica itoscac catli elqui quen se tlatomonilotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Huan TOTECO temoc hasta itzonatipa nopa tepetl Sinaí huan quinotzqui Moisés ma tlejco. Huan Moisés tlejcoc, ");
INSERT INTO nhwBl_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","huan TOTECO quiilhui: ―Xitemo huan xiquinelnamiquiltiti nopa masehualme para amo ma quiixpanoca nopa nepamitl campa niquinilhuijtoc. Niyon amo ma mocuatopejtiyaca pampa quinequise nechitase para amo miquise. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hasta nojquiya nopa totajtzitzi catli quipiyaj inintequi para nechnechcahuise monequi mocualchijchihuase huan moiyocacahuase san para na para amo niquintzontlamiltis. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Huan Moisés quinanquili TOTECO: ―Nopa masehualme amo motemacase tlejcose ipan ni tepetl Sinaí, pampa ta titlanahuati ma nijtlali se nepamitl huan ma niquiyocacahua ni tepetl san para ta, huan ya nopa nijchijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Pero TOTECO quiilhui: ―Xitemo sempa huan xijcuiti Aarón. Pero amo xiquincahuili nopa totajtzitzi, niyon nopa masehualme, ma mocuatopehuaca huan ma quiixpanoca nopa nepamitl para tlejcose campa niitztoc, pampa sintla quichihuase, niquincocototzas. ");
INSERT INTO nhwBl_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Huajca Moisés temoc sempa huan quinilhuito israelitame catli TOTECO quiilhui. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Huan Toteco Dios camanaltic huan quiijto nochi ni camanali: ");
INSERT INTO nhwBl_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Na niDIOS, niamoTECO, catli nimechquixti ipan tlali Egipto campa antetequipanohuayayaj san tlapic quen anmechcojtosquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Amo xijtlepanitaca seyoc quen amoTeco, san na. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Amo xijchihuaca itlachiyalis niyon se tlamantli para anquitlepanitase. Amo xiquixcopinaca catli eltoc ipan ilhuicac, niyon catli eltoc ipan ni tlaltipactli, niyon catli onca ipan hueyatl para anquihueyichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Amo ximotlancuaquetzaca iniixpa tlaixcopincayome catli tlachijchihualme, niyon amo xiquinhueyichihuaca, pampa na niDIOS, niamoTECO, huan nimechtlasomati huan nijnequi san na techhueyimatise. Huan quema niquintlatzacuiltía tetajme catli amo quinequij nechitase, nopa tlatzacuiltili nojquiya quinajsis ininconehua, huan iniixhuihua huan ipan ininteipan ixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Pero ica catli nechicnelíaj huan catli quichihuaj notlanahuatil, niquinicnelis huan niquintlasojtlas ininconehua, huan iniixhuihua huan hasta nopa iniixhuihua quinpiyase iniixhuihua mil huelta. Quena, notlasojtlacayo quinajsis para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Amo xicahuilmatica notoca niamoTECO Dios, pampa amo quinamiqui. Temachtli nijtlatzacuiltis catli san quej hueli quitequihuía notoca. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Xiquelnamiquica sábado, nopa tonal para anmosiyajquetzase, huan xijtlepanitaca. Ma elis tlaiyocatlalili tlen nochi sequinoc tonali. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ipan chicuasen tonali xijchihuase nochi catli monequi anquichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Pero nopa chicompa tonal elis se tonal para ximosiyajquetzaca huan techhueyitlalica na niamoTECO Dios. Ipan nopa tonal amo hueli antequitise, niyon amo xijcahuilica ma tequiti amotelpoca, niyon amoichpoca, niyon amotequipanojca, niyon amosihua tequipanojca, niyon amotlapiyalhua, niyon nopa seyoc tlali ejquetl catli itztoc ipan amochaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Pampa ica chicuasen tonali TOTECO quichijqui ilhuicactli, tlaltipactli, hueyi atl huan nochi catli quipiya. Huan mosiyajquetzqui ipan nopa chicompa tonal. Yeca TOTECO quitiochijqui nopa chicompa tonal huan quiiyocatlali para ipan ma timosiyajquetzaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Xijtlepanitaca amotata huan amonana para anitztose miyac xihuitl ipan nopa tlali catli TOTECO Dios anmechmacas. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Amo xitemictica. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Amo ximomecatica. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Amo xitlachtequica. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Amo aqui xiquistlacahuica. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Amo xiquixtocaca seyoc ichaj, niyon amo xiquixtoca seyoc isihua, niyon itlaca tequipanojca, niyon isihua tequipanojca, niyon itoro catli tlapoxonía, niyon iburro. Amo xiquixtocaca niyon se tlamantli catli seyoc iaxca.” ");
INSERT INTO nhwBl_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Nochi israelitame quicajque nopa tlatomonilotl huan nopa tlapitzali. Quiitaque nopa tlapetlanilotl huan nopa tepetl catli popocayaya. Huan tlahuel majmajque, huan huihuipicaque huan mohuejcachijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Huan quiilhuijque Moisés: ―Techcamanalhui ta huan timitzneltoquilise. Pero ma amo techcamanalhui Toteco Dios, pampa huelis timiquise. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Huan Moisés quinnanquili: ―Amo ximomajmatica. Toteco Dios hualajtoc quej ni para anmechnextilis ihueyi chicahualis para xiquimacasica para nochipa huan para quej nopa amo antlajtlacolchihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Huan nochi nopa masehualme más mohuejcachijque. Huan Moisés monechcahui campa nopa mixtli catli yayahuic campa itztoya Dios. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Huan TOTECO quiilhui Moisés: “Quej ni xiquinilhui nopa israelitame: ‘Ya anquiitztoque para nimechnojnotztoc tlen ilhuicac. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Amo xijchihuaca tlamantli tlen oro, o tlen plata o ica niyon se tlamantli para anquihueyimatise. Monequi techtlepanitaca san na. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Techchihuilica se tlaixpamitl ica soquitl huan ipani antechmacase tlacajcahualistli. Nopona xiquintencahuaca nopa tlacajcahualistli catli tlatlatili huan nopa tlacajcahualistli para anquipiyase tlayoltlalili noca na, niamoTECO. Huan nopona anquintencahuase pilborregojtzitzi huan huacaxme quen amotlacajcahualis. Huan campa hueli campa na nimechchihualtis para anmoilhuise tlen na, nopona xijchihuaca se tlaixpamitl. Huan nopona na niyas huan nimechtiochihuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Sintla antechchihuilise se tlaixpamitl tlen tetl, amo xijtequica nopa tetl. Pampa sintla anquitequise ica tepostli, amo quinamiqui para elis ipan notlaixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Huan nijnequi notlaixpa ma amo quipiyas escalera campa tlacame monequi tlejcose para quiajsise. Amo nijnequi para seyoc hueli quiitas tlatzintla icuex catli tlejcosquía nopona.’ ");
INSERT INTO nhwBl_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Ya ni nopa tlanahuatilme catli tiquinmacas israelitame: ");
INSERT INTO nhwBl_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Sintla tijcohuas se tequipanojquetl hebreo para moaxca, san monequi mitztequipanos chicuasen xihuitl. Ipan nopa chicompa xihuitl, monequi tijmajcahuas para ayacmo elis moaxca. Huan amo tleno monequi mitztlaxtlahuis para quisas huan elis majcajtoc para yas campa quinequis. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Sintla ajsico iseltzi, yas iseltzi. Pero sintla ajsico ica isihua, monequi isihua yas ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Sintla iteco quimacas se sihuatl huan nopa sihuatl quinpiyas oquichpilme huan sihuapilme; nopa sihuatl huan iconehua mocahuase iaxcahua iteco huan nopa tlaca tequipanojquetl yas iseltzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Pero sintla nopa tlaca tequipanojquetl quiijtos para amo quinequi itztos majcajtoc para yas campa ya quinequis huan quiijtohua quinicnelía iteco, isihua, huan iconehua huan quinequi mocahuas ininhuaya, huajca yaya huelis mocahuas para noja elis iaxca iteco. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Huan iteco quihuicas iniixpa jueces, huan nopona quinechcahuiltise puertajteno, huan ica se hueyi tepos huitzmalotl quicoyonilis inacas. Quej nopa yaya mochihuas itequipanojca nopa iteco para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Sintla se tlacatl quinemacas iichpoca para ma tequipano san tlapic, nopa ichpocatl amo hueli mochihuas majcajtoc quen mochihuaj majcajtoque tlaca tequipanohuani. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Pero sintla iteco nopa ichpocatl amo quiixtocac huan yeca amo quichijqui isihua, masque quitlapejpeni para se tonal elisquía isihua, huajca seyoc huelis quicohuas nopa ichpocatl sempa. Pero nopa tecojtli amo huelis quinemaquiltis nopa ichpocatl ica se catli seyoc tlali ejquetl, pampa amo quichihuilijtoc cuali. Amo mosihuajti ihuaya quen quiijto quichihuas quema quicojqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Huan sintla nopa tecojtli quitlapejpeni se sihua tequipanojquetl hebreo para quimacas itelpoca para ma quichihua isihua, monequi nopa tecojtli ayacmo quiitas para se tequipanojquetl, monequi quiitas quen elisquía iichpoca. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Huan sintla nopa tecojtli quicuis se hebreo ichpoca tequipanojquetl para isihua huan teipa quicuis seyoc isihua, amo hueli quiquixtilis niyon quentzi itlacualis nopa catli achtihui. Noja monequi quitlamacas cuali, huan quiyoyontis cuali huan itztos ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Huan sintla amo quinequi quichihuilis nochi ni eyi tlamantli, nopa sihuatl huelis mochihuas majcajtoc para yas campa yaya quinequis huan amo tleno monequis tlaxtlahuas para hueli quisas. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Sintla acajya quimaquilis seyoc huan yaya miquis, monequi anquimictise nopa temictijquetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Pero sintla catli temicti amo quinequiyaya quicocos, san panoc pampa huelis quej nopa Toteco Dios quicahuili ma eli, na nimitznextilis teipa canque huelis yas nopa masehuali para momanahuiti para amo aqui quiitzquis huan quimictis. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Pero sintla nopa temictijquetl mocualanis ihuaya seyoc huan quisencahuas quenicatza huelis quicajcayahuas huan quimictis, monequi xijmictica. Masque nopa temictijquetl motlatiti tiopan calijtic huan quiitzquis notlaixpa para momanahuis, monequi tijquixtis, huan xitlanahuatis ma quimictica. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Sintla se quimaquilis inana o itata, monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Sintla se teichtequis, masque quinemacas nopa masehuali para ma tequipano, o noja quipixtos imaco quema anquipantise, monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Sintla se quitelchihuas itata o inana, monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Sintla masehualme mohuilanaj huan se quimaquilis ne se ica se tetl, o ica se imax, pero amo miquis, san huetztos ipan itlapech, nopa catli tecoco amo monequi miquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Sintla nopa cocoxquetl huelis motlananas huan huelis quisas calteno ica icuatopil, huajca san monequi tlaxtlahuas nopa tecocojquetl catli ica mopajtis huan tlaxtlahuas nochi nopa tonali tequitl catli quipolos hasta cuali mochicahuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Sintla se acajya quihuitequi itlaca o isihua tequipanojca ica se cuahuitl, huan yaya miquis pampa quicoco, monequi anquitlatzacuiltise iteco por catli quichijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Pero sintla nopa tequipanojquetl itztos para se ome tonali huan teipa miquis, amo monequi xijtlatzacuiltica iteco pampa nopa tequipanojquetl iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Sintla ome tlacame mohuilanaj huan quicocose se sihuatl catli conehue huan ica ya nopa quichihuilise ma tlacatis icone quema ayamo ajsi tonali, ya ni catli anquichihuase. Sintla amo miqui nopa conetl, huajca catli quipiya tlajtlacoli monequi tlaxtlahuas imiyaca catli quiijtos ihuehue nopa sihuatl huan nopa jueces. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Pero sintla miquis nopa conetl, monequi anquimictise catli quicoco nopa sihuatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Huan sintla se teixteyolcocos, xiquixteyolcococa catli tecoco. Sintla tetlancochtepehuas, xijtlancochtepehuaca. Sintla se quicocos ipan imax o imetz se acajya, monequi nojquiya san se anquicocose catli tecocohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Sintla se tetlatía, nojquiya xijtlatica. Huan sintla se tetzontequis, xijtetzontequica. Sintla se quitejtzonas seyoc, nojquiya xijtejtzona yaya catli tetejtzontoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Sintla se tecojtli quimaquilis itlaca o isihua tequipanojca ipan iixteyol, huan quicahuas ixpitzitic huan ayacmo huelis tlachiyas ica nopa iixteyol, monequi quicahuilis nopa tequipanojquetl ma elis majcajtoc pampa quiixteyolcoco. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Huan sintla se quitlancochtepehua itlaca o isihua tequipanojca, monequi quicahuilis nopa tequipanojquetl ma eli majcajtoc pampa quitlancochtepejqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Sintla se toro quitompojhuis se masehuali ica icuacua huan miquis, monequi anquimictise nopa toro ica tetl huan amo xijcuaca inacayo. Pero amo xijtlatzacuiltica catli iaxca nopa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Pero sintla nopa toro ya momajtoya tetompojhuía huan iteco quimati huan amo quitzacua cuali nopa toro, huan sintla teipa quimictis se acajya, monequi anquitzontepachose nopa toro huan iteco hasta miquise. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Pero sintla iteiximatcahua catli nopa toro quimicti, achi más paquise ica tomi huan amo quinequise ma miqui iteco nopa toro, monequi nopa tecojtli ma quintlaxtlahuis ica tomi catli quiijtose para quimanahuis inemilis. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Nojquiya quej ni elis sintla nopa toro quitompojhuis se sihuapil o se oquichpil. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Pero sintla nopa toro quitompojhuía se tlaca o sihua tequipanojquetl, monequi anquimictise nopa toro ica tetl, huan catli iaxca nopa tlapiyali monequi quitlaxtlahuis iteco nopa sihua o tlaca tequipanojquetl 30 plata tomi. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Sintla acajya quitlapojtehua se ameli huan amo quitzacua huan teipa iijtic huetzis se toro o se pilburrojtzi, ");
INSERT INTO nhwBl_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","huajca catli iaxca nopa ameli monequi quitlaxtlahuis quen ipati nopa toro catli quipolo. Inacayo nopa tlapiyali catli mictoc elis iaxca catli tlaxtlajqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Sintla itoro se masehuali quicocos itoro seyoc masehuali hasta miquis, huajca quinemacase nopa toro catli itztoc huan quitlajcoitase nopa tomi. Nojquiya quitlajcoitase nopa toro catli mictoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Pero sintla nopa tecojtli ya quimajtoya para nopa tlapiyali ipa tetompojhuiyaya huan amo quichihuiliyaya cuenta, monequi amo san quitlaxtlahuis tlajco. Monequi quitlaxtlahuis nochi catli ipati nopa tlapiyali catli quimicti, huan nopa toro catli mictoc elis iaxca.” ");
INSERT INTO nhwBl_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Sintla se acajya quiichtequis se toro o se borrego huan quimictis o quinemacas, monequi tlaxtlahuas macuili torojme para sesen toro, o nahui borregojme para sesen borrego. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Sintla acajya quipantis se tlachtejquetl quema calaqui techaj tlayohua para tlachtequis huan nopa caltecojtli quicocos nopa tlachtejquetl huan yaya miquis, nopa caltecojtli amo quihuicas tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Pero sintla ica tonaya quimictis se tlachtejquetl, quena, quipiyas tlajtlacoli catli temictijtoc. “Catli tlachtequi monequi quiixtlahuas catli ipati catli quiichtectoc. Huan sintla amo quipiya tomi, monequi monemacas para tequipanos huan quej nopa ma quiixtlahuas catli quiichtectoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Sintla masehualme quipantise se toro, se burro, o se borrego tlachtectli catli noja itztoc imaco nopa tlachtejquetl, monequi tlaxtlahuas ompa catli ipati. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Sintla acajya quinmajcahuas itlapiyalhua huan tlacuajcuatij temila o texocomeca mila, monequi quicuepilis nopa tlaltecojtli se tlaxtlahuili quen ipati nopa pixquistli catli más cuali quipixtoya ipan imil o ipan nopa ixocomecamil para tlaxtlahuas catli itlapiyalhua quinenpolojque. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Sintla acajya tlajchinohua huan nopa tlitl pano ipan seyoc imila, huan quitlatía nopa trigo catli quimontonojtoque, o catli ya eltoc para pixquistli o quitlatía nochi tlatoctli, yaya catli quitlati monequi tlaxtlahuas por nochi catli quitlati nopa tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Sintla se masehuali quimactilis tomi o tlamantli catli ipati se ihuampox para ma quimocuitlahuili, huan se tlachtejquetl calaquis ipan nopa cali huan quitlachtequilis, sintla quipantise, monequi nopa tlachtejquetl tlaxtlahuas ompa catli quicuitoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Pero sintla amo quipantise nopa tlachtejquetl, huajca catli quimocuitlahuía nopa tlamantli quihuicase iniixpa jueces para quiitase sintla yaya quicuitoc catli eltoya iaxca ihuampox catli ipan motemachi. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Quema se quipolos se toro, o se burro, o se borrego, o se yoyomitl, o tlen hueli tlamantli huan teipa quipantis imaco seyoc, huan sintla ne se quiijtohua para iaxca, huajca nochi ome catli quiijtohuaj para iniaxca monequi yase iniixpa jueces, huan nopa jueces quiijtose ajqueya iaxca. Huan yaya catli tecuilijtoc monequi quicuepas ompa. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Sintla acajya quimactilis seyoc ma quimocuitlahuili se burro, se toro, se borrego o seyoc tlapiyali huan nopa tlapiyali miquis, o mococos, o cholos huan amo aqui quiitac tlaque panoc, ");
INSERT INTO nhwBl_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","nopa masehuali catli quimocuitlahuiyaya monequi quitestigojquetzas TOTECO para amo tleno catli amo cuali quichijtoc ica catli quicahuilijtoyaj. Huan catli iaxca nopa tlapiyali monequi quineltoquilis icamanal ihuampox catli quitestigojquetztoc TOTECO. Huan catli tlamocuitlahuiyaya amo tleno monequi tlaxtlahuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Pero sintla iixtla quiichtequilijque nopa tlapiyali, huajca catli tlamocuitlahuiyaya monequi quitlaxtlahuis iteco nopa tlapiyali quen ipati. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Huan sintla nopa tlapiyali quicocototzqui se tecuani, ya catli quimocuitlahuiyaya monequi quinextis iomiyo nopa tlapiyali catli mijqui huan quej nopa amo monequi tlaxtlahuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Sintla acajya motlanehui se tlapiyali, huan ne tlapiyali ipantis se tlenijqui, o miquis, huan amo quiitac iteco, huajca yaya catli motlanejqui monequi tlaxtlahuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Pero sintla nopa tecojtli noja itztoc ihuaya itlapiyal quema ipantis se tlenijqui, nopa catli motlanejtoc amo monequi tlaxtlahuas. Huan sintla se motlanehui se tlapiyali huan tlaxtlahua para quitequihuis huan ipantis se tlenijqui, amo monequi tlaxtlahuas pampa ya tlaxtlajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Sintla se tlacatl quicajcayahuas se ichpocatl catli amo quiijtlantoque huan quichihualtis ihuaya cochis, monequi quitlaxtlahuis itata san se quen catli quitlaxtlahuisquía se tlacatl catli quinequisquía mosihuajtis ihuaya nopa ichpocatl. Huan quema ya quitlaxtlahuijtos itata nopa ichpocatl, huelis mosihuajtis ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Huan masque itata nopa ichpocatl amo quinequis quimactilis para ma eli isihua, nopa tlacatl monequi tlaxtlahuas imiyaca tomi catli momajtoque tetlamajmacase para se ichpocatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Amo xijcahuilica ma itzto se tetlajchihuijquetl. Monequi xijmictica. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Sintla acajya quichihuas se tlamantli ica se tlapiyali quen elisquía inamic, monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Sintla se quimacas se tlacajcahualistli se tlaixcopincayotl o seyoc tlamantli catli quiita para tecojtli, xijmictica. San na, niamoTECO, techmacaca tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Amo xijcajcayahuaca, niyon amo xijchihuilica catli fiero se seyoc tlali ejquetl, pampa amojuanti nojquiya aneltoyaj anseyoc tlali ehuani ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Amo xijtlaijiyohuiltica se sihuatl catli cahualtzi, niyon se icnotzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Pampa sintla anquinchihuilíaj catli fiero, inijuanti nechtlajtlanise ma niquinpalehui huan na nijcaquis huan niquinpalehuis. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Huan nicualanis miyac huan nimechmictis ica machete, huan amosihuajhua nojquiya mocahuase cahualtzitzi huan amoconehua icnotzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Sintla anquitlanejtise tomi se teicneltzi catli nojquiya se israelita quen amojuanti, amo ximochihuaca quen se tetlanejtijquetl. Amo xiquinamaca itlanca. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Sintla teicneltzi se masehuali catli anquitlatlanejtíaj huan monequi anmechprendajcahuilis itlaque, monequi xijcuepilica quema tiotlaquiyas, ");
INSERT INTO nhwBl_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","pampa huelis san se itlaque quipiya para moquentis quema tlaseseya. Huan san ya nopa quipiya para ica mopiquis quema cochis. Huan sintla ya tlaijiyohuis huan nechtlajtlanis ma nijpalehui, nijtlacaquilis huan nijpalehuis pampa na nitetlasojtla. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Amo xiquintlaijilhuica amotequiticahua, niyon amo xijtlaijilhuica yaya catli tlanahuatía ipan amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Amo xihuejcahuaca para antechhualiquilise nopa ofrendas catli noaxca tlen nochi amopixquis huan tlen nochi amoxocomecamil. “Monequi techtemactilica amoachtihui oquichpil. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Nojquiya monequi techmacaca iniachtihui conehua amohuacaxhua huan amoborregojhua. Huelis mocahuase chicome tonati ihuaya ininnana, pero ipan nopa chicueyi tonal techmacaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Monequi anelise notlatzejtzeloltijca masehualhua. “Amo xiquincuaca tlapiyalme catli tecuanime quinmictijtoque cuatitla. Nopa nacatl monequi xiquinmacaca chichime. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Amo xijmoyahuaca se camanali catli amo neli tlen sequinoc. Amo xijpalehuica se fiero masehuali huan xijtestigojquetzaca se tlamantli catli amo neli por ya. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Quema itztoque miyaqui catli quichihuasnequij catli amo cuali, amo ximocalaquica ininhuaya. “Quema anmochihuase antestigos para anquiijtose tlamiyacapa catli melahuac panotoc, amo xiquijtoca catli amo neli quen miyaqui masehualme quinequise xijchihuaca, pampa amo xitlahuac sintla anquichihuase quej nopa. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Niyon amo xijtestigojquetzaca ica catli amo melahuac pampa tijchicoicnelía se catli teicneltzi huan tijnequi tijpalehuis. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Sintla anquipantilise amocualancaitaca itoro o iburro catli cholojtoc, monequi xijhuiquilica. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Sintla tijpanti mocualancaitaca huan quitlananasnequi iburro catli huetztoc ica itlamamal catli etic, amo xijcajtehua hasta tijpalehuis ma quitlananas. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Xiquinchihuili nochi teicneltzitzi catli xitlahuac quema onca se cualantli. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Xijtlalcahui se catli quinequi quitelhuis seyoc ica catli amo melahuac. Amo xijcahua ma quimictica se catli amo tleno quichijtoc. Pampa na nijtlatzacuiltis nojquiya yaya catli quicahuas se acajya ma quimicti se masehuali catli xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Quema titetlajtolsencahua, amo xijseli se tlaxtlahuili ichtacatzi. Catli quiselía tlaxtlahuili ichtacatzi ayacmo huelis quiitas catli melahuac, huan amo quicahuilía ma camanalti catli quiijtohua catli xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Amo xijtlaijiyohuilti se seyoc tlali ejquetl, pampa nojquiya aneltoyaj anseyoc tlali ehuani ipan tlali Egipto. Huan anquimatij quenicatza anquimatiyayaj quema anitztoyaj ipan se tlali catli amo amoaxca. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“San chicuasen xihuitl antlatojtocase huan anpixcase ipan amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Huan quema ajsis nopa chicompa xihuitl, amo tleno xijtocaca. San xijcahuaca amotlal ma mosiyajquetza. Huan sintla moscaltis iseltzi se quentzi toctli, xiquincahuilica catli teicneltzitzi ipan amotlal ma mopixquilica para ica mopanoltise. Huan catli mocahua ma quicuaca tlapiyalme tlen cuatitla. Nojquiya quej nopa anquichihuase ica amoxocomecamil huan ica amoolivomil. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Para chicuasen tonali anquichihuase nochi catli monequi anquichihuase, pero ipan nopa chicompa tonal monequi ximosiyajquetzaca. Nojquiya ma mosiyajquetzaca amotorojhua huan amoburrojhua. Ma mosiyajquetzaca amotequipanojcahua catli anquincojtoque huan nopa seyoc tlali ehuani catli anmechpaxalohuaj. Nopa tlasiyajquetzalistli anmechpalehuis nochi amojuanti para sempa xijpiyaca fuerza. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Ximotlachilica huan xijchihuaca nochi ya ni catli nimechilhuijtoc. Amo quema xiquintestigojquetzaca inintoca tlaixcopincayome catli ne sequinoc quinhueyimatij. Niyon amo quema xijtenquixtis inintoca. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Eyi huelta ipan se xihuitl antechilhuichihuilise. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Xijchihuaca nopa ilhuitl tlen pantzi catli amo quipiya tlasonejcayotl quen nimechnahuatijtoc. Xijcuaca pantzi catli amo quipiya tlasonejcayotl chicome tonali quen nimechilhuijtoc. Anquicuase ipan metztli Abib ipan nopa tonal catli nimitzilhui, pampa ipan nopa metztli anquistejque tlali Egipto. Huan amo aqui hueli nechnechcahuis sintla amo techhualiquilis se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Nojquiya xijchihuaca nopa ilhuitl tlen ipejya pixquistli huan techhualiquilica catli achtihui anquipixcatoque catli anquitojque ipan amomil. Huan nojquiya sesen xihuitl xijchihuaca nopa ilhuitl tlen itlamiya pixquistli quema ya anquisentilijtoque nochi nopa pixquistli catli amotochui temacac. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Expa ipan se xihuitl monequi nochi antlacame ximonextica noixpa, na niamoTECO Catli Más Nijpiya Tlanahuatili. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Quema antechmacase ieso se tlapiyali para se tlacajcahualistli, amo techmacaca san sejco ihuaya pantzi catli quipiya tlasonejcayotl. Niyon amo xicajocuica ichiyajca nopa tlapiyali para antechmacase seyoc tonal. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ipan nopa achtihui tonal tlen nopa achtihui pixquistli, xijtlapejpenica catli más cuali tlen itlajca catli temaca amotlal huan techmactilica, na niamoTECO Dios. “Amo xiquicxitica se pilcone chivojtzi ipan inana ilechi quen quichihuaj tetlajchihuiani. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Xiquita, na nijtitlanis notequihua ma anmechyacana, huan ma anmechmocuitlahui ipan ojtli huan ma anmechhuica hasta nopa tlali catli nimechcualtlalilijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Xijtlacaquilica cuali catli yaya anmechilhuis huan xijneltoquilica. Amo xijhuejcamajcahuaca, pampa yaya quihuica nochi nopa tlanahuatili catli nijhuica na huan amo anmechtlapojpolhuis amotlajtlacolhua sintla anquihuejcamajcahuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Pero sintla nelía anquicaquise cuali nochi catli nimechilhuía huan anquichihuase nochi catli nimechnahuatijtoc, na nielis niinincualancaitaca amocualancaitacahua huan niquintlaijiyohuiltis catli anmechtlaijiyohuiltise. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Notequihua anmechyacanas huan anmechhuicas ipan inintlal nopa amorreos, heteos, ferezeos, cananeos, heveos huan jebuseos. Huan na niquintzontlamiltis amoixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Amo ximotlancuaquetzaca iniixpa inintlaixcopincayohua nopa masehualme, niyon amo xiquinhueyichihuaca. Amo quema xijtoquilica sequinoc fiero tlamantli catli nopa masehualme quichihuaj. Monequi xiquintzontlamiltica nochi nopa masehualme huan xijpapayatzaca nochi nopa teme catli quinhueyichihuaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","San techhueyichihuaca na, niamoTECO Dios, huan nijtiochihuas amotlacualis ihuaya amoa. “Huan nijchihuas para ma amo anmechajsi cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Amo oncas niyon se sihuatl ipan amotlal catli elis tetzacatl o catli conehuetzis. Huan nijchihuas para anitztose miyac xihuitl ipan ni tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Na nijtitlanis se hueyi majmajtli ipan nochi nopa fiero masehualme campa anajsise hasta amo quimatise tlaque quichihuase. Huan nijchihuas ma cholojtehuaca amoixpa nochi amocualancaitacahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Niquintitlanilis mecapaletzame ma tlayacanaca huan ma quintojtocaca nopa heveos, nopa cananeos, huan nopa heteos amoixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Pero amo niquintojtocas para nochi ma quisaca ipan san se xihuitl. Sintla quej nopa nijchihuasquía, polihuisquía nochi catli tlatojtoctoque, huan momiyaquilisquíaj tecuanime catli itztoque cuatitla catli huelis anmechcocose. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Pero ica yolic niquintojtocatiyas amoixpa quen nojquiya yolic anquinpixtiyase más amoconehua huan anmomiyaquilijtiyase para anmoaxcatise nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Quej ni nijquetztoc inepa amotlal: Pejtehuas amotlal ipan nopa Hueyi Atl Chichiltic huan yas hasta nopa Hueyi Atl Mediterráneo 23:31 Hueyi atl tlen nopa filisteos.. Nojquiya pejtehuas ipan huactoc tlali ica sur huan tlamis ipan nopa hueyatl Eufrates ica campa huala tonati. Na nijtlalijtoc amomaco nochi masehualme catli ehuaj ipan nopa tlali para xiquintojtocaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Amo xijchihuaca niyon se camanali ininhuaya, niyon ica inintlaixcopincayohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Amo xiquincahuilica ma mocahuaca ipan amotlal para amo anmechchihuase xitlajtlacolchihuaca ica na. Sintla anquihueyichihuase inintlaixcopincayohua, huajca nelía anmechmasiltise.” ");
INSERT INTO nhwBl_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Huan TOTECO quiilhui Moisés: ―Xitlejco campa na niitztoc, ta ihuaya Aarón, Nadab, Abiú huan nopa 70 huehue tlacame catli mohuaya quinyacanaj ni israelitame. Inijuanti ma motlancuaquetzaca ica huejca para nechhueyimatise. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","San ta, Moisés, huelis technechcahuis campa na, niamoTECO, niitztoc. Nopa sequinoc tlayacanani amo huelise nechnechcahuise, huan nopa sequinoc israelitame amo huelis tlejcose nica amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Huan Moisés yajqui quinpohuilito nopa israelitame nochi catli TOTECO quiijtojtoya huan catli tlanahuatijtoya. Huan nochi israelitame san se huelta tlananquilijque: ―Nochi catli TOTECO quiijtojtoc, tijchihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Huajca Moisés quiijcuilo nochi catli TOTECO quiilhuijtoya. Huan hualmostla cualca mejqui huan quisencajqui se tlaixpamitl itzintla nopa tepetl, huan quiquetzqui nopa tlaixpamitl ipan majtlactli huan ome teme quen imiyaca itelpocahua Israel catli ica pejqui nopa majtlactli huan ome huejhueyi familias tlen israelitame catli ama onca. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Teipa quintitlanqui sequin israelita telpocame ma quimacaca TOTECO tlacajcahualistli tlatlatili. Huan quinmictijque huan quintlatijque torojme para tlacajcahualistli para ma quipiyaca tlayoltlalili ihuaya TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Huan Moisés quicuic tlajco nopa estli, huan quitejqui ipan huajcalme huan nopa seyoc tlajco quiijtzelo ipan tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Teipa quicuic nopa amatl catli quipixtoya itlanahuatil TOTECO, o nopa camanal sencahuali catli TOTECO quichijqui ininhuaya israelitame huan catli monequi quineltocase. Huan quinpohuili nochi nopa amatl huan inijuanti quiijtojque: ―Quena, tijneltoquilise TOTECO huan tijchihuase nochi catli yaya techilhuijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Huajca Moisés quicuic nopa estli ipan huajcalme, huan quinijtzelhuili nochi israelitame, huan quiijto: ―Ya ni nopa estli catli quipehualtía nopa camanal sencahuali catli TOTECO quichijtoc amohuaya quema anmechmacac nochi ni tlanahuatili. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Huan teipa Moisés tlejcoc ipan nopa tepetl ihuaya Aarón, Nadab, Abiú huan nopa 70 huehue tlacame catli quinyacanayayaj nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Huan nopa israelita tlayacanani quiitaque Dios, ininTeco israelitame. Huan tlatzintla iicxihua quipixqui se piso azultic quen nopa yejyectzi tetl catli itoca zafiro, huan eliyaya tlahuel tzilintic quen ilhuicactli. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Huan masque nopa tlayacanca israelitame quiitaque Toteco Dios huan san sejco tlacuajque huan atlique iixpa, amo quinmicti. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Huan TOTECO quiilhui Moisés: ―Xitlejco campa niitztoc ipan ni tepetl huan ximocahua nica. Huan nimitzmacas nopa tepatlactli campa niquijcuilojtoc nopa ley huan nopa tlanahuatilme para tiquinmachtis israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Huan Moisés tlejcoc ipan itepe Toteco ica Josué itlapalehuijca. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Huan quinilhui nopa huehue tlacame: ―Techchiyaca nica hasta quema timocuepase. Nica mocahuase Aarón huan Hur amohuaya, huan sintla acajya quipiya se cualantli quema amo niaqui, ma quinilhuica inijuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Huan Moisés tlejcoc ipan nopa tepetl huan se mixtli quitzajqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Huan itlatlanex TOTECO temoc ipan tepetl Sinaí, huan nopa mixtli quitzajqui nopa tepetl para chicuasen tonali. Huan quema ajsic nopa chicompa tonal, TOTECO quinotzqui Moisés tlatlajco ipan nopa mixtli. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Huan nopa israelitame catli itztoyaj tlatzintla quiajcotlachilijque huan quiitaque itlatlanex TOTECO, huan para inijuanti elqui quen se tlilelemectli catli nochi quitlatiyaya tepeixco. ");
INSERT INTO nhwBl_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Huajca Moisés tlejcotiyajqui ipan nopa tepetl, huan calajqui ipan nopa mixtli huan nopona mocajqui para 40 tonali huan 40 yohuali. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Huan nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Xiquinilhui nopa israelitame para hueli nechmacase tlacajcahualistli sintla quinequij. Xijsentilica nochi nopa tlamantli catli sese israelita quinequi nechmacas ica nochi iyolo. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Sintla quinequij nechmacase se tlenijqui, huelis xiquinselili tlamantli tlen oro, plata huan cobre. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Nojquiya huelis xiquinselili icpatl tlen nopa tzontli catli itoca lino catli tlamalintli nelcanactzi, huan nojquiya icpatl tlen iniijhuiyo borregojme catli quipajtoque azultic, morado, o chichiltic. Nojquiya xijseli inincuitlapan ijhuiyo chivojme, ");
INSERT INTO nhwBl_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","huan inincuetlaxo pesojme huan nopa cuahuitl catli itoca acacia. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Xijseli aceite para ica quitlatise tlahuili. Xijseli tlaajhuiyacayotl para aceite catli quitequihuíaj para tlaiyocacahuase para na, huan nojquiya para ica anquisencahuase copali catli ajhuiyac. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Nojquiya huelis nechmacase teme catli pajpatiyo. Huelis nechmacase nopa tetl ónice huan sequinoc teme catli yejyectzitzi para anquitlatzquiltise ipan nopa pantzajcayotl huan nopa yolixpantzajcayotl para nopa hueyi totajtzi iyoyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Teipa techchihuilica se cali para ipan niitztos tlajco amojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Pero monequi xijsencahua nochaj ica nochi cuamesas huan tlamantzitzi senquistoc quen ni tlaixcopinali catli ama nimitznextilis. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Ma quichihuaca se caxa yejyectzi ica nopa cuahuitl catli itoca acacia. Huan nopa caxa quipiyas 1 metro 10 centímetros ihuehueyaca huan 65 centímetros ipatlajca huan ihuejcapanca. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Xijxahuaca ica senquistoc oro iijtic huan ipani. Huan xijtlatzquiltilica iixteno se corona tlen oro catli anquiyecchijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Xijchihuili nahui huejhueyi anillos tlen oro. Xijtlalica nopa anillos najcac campa iicxicuayohua, ome ipan se lado huan ome ipan ne seyoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Huan xijsencahuaca ome cuahuitl catli huehueyac huan pitzahuac para ica anquiquechpanose. Huan xijxahuaca nopa cuahuitl ica oro, ");
INSERT INTO nhwBl_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","huan ma pano se tlen nopa cuahuitl huehueyac ipan nopa ome anillos ipan sesen lado ipan inacastla nopa caxa para quej nopa huelis anquitlananase. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Huan ayacmo xijquixtilica nopa cuahuitl catli ica anquihuicase. Ma mocahua nopa cuahuitl ipan ianillos nopa caxa. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Huan quema anquitlamiltise nopa caxa, xijtlalica iijtico nopa tepatlactli ica nopa tlanahuatilme catli nimitzmacas. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Huan xijchihuaca nopa caxa itzajca tlen senquistoc oro catli quipiyas se metro 10 centímetros ihuehueyaca huan 65 centímetros ipatlajca. Nopona iixco nopa caxa timopantise huan nimechtlasojtlas quema antlajtlacolchihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Xiquinchihuaca nojquiya ome tequihuajme catli inintoca querubines catli ijcatose iixteno itzajca nopa caxa ica iniicxihua ipan itzajca. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Xiquinsencahuaca nopa ome querubines ica san se tlatectli oro catli tlatejtzontli ica itzajca nopa caxa. Se querubín moquetzas ipan se iteno huan ne se ipan seyoc iteno ica ihuehueyaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Huan nopa querubines monequi quipatlajtose inieltlapal itzonatipa nopa caxa para ma quiecahuilica. Huan moixnamictose nopa querubín tequihuajme huan tlachixtose tlatzintla ipan itzajca nopa caxa, pampa nopona nitetlasojtlas. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Quema ya tlasencahuali itzajca, xijtlalica caxa ijtic nopa tepatlactli ica nopa tlanahuatili catli nimitzmacas. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Huan nopona tlatlajco nopa querubines catli mocahuaj iixco itzontzajca nopa caxa, nimechnamiquis huan nimechtlasojtlas. Quena, nopona itzonixco nopa caxa campa mocahuas nopa tepatlactli catli quipiya nopa camanal sencahuali catli ica nimocajtoc amohuaya, nimechmatiltis nochi notlanahuatilhua catli nijpiya para anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Xijchihuaca se cuamesa ica nopa cuahuitl acacia, huan quipiyas 90 centímetros ihuehueyaca, 45 centímetros ipatlajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Xijxahuaca nopa cuamesa ica senquistoc oro. Nojquiya xijchihuilica icorona tlen oro iixteno catli anquiyecchijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Nojquiya yahualtic iixteno nopa cuamesa ma quipiya se icorona tlen chicome centímetros huan tlajco ihuejcapanca. Xijxahuaca nopa corona ica senquistoc oro catli anquiyecchijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Nojquiya xijchihuilica nahui anillos tlen senquistoc oro catli anquitlalilise ipan sese inacastla campa iicxicuayohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Monequi nopa anillos tlatzquitos itzala nopa corona nechca nopa cuamesa campa pehua iicxicuayo, huan ipan nopa anillos calaquis nopa cuahuitl huehueyac para ica anquihuicase nopa cuamesa. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Huan nopa cuahuitl huehueyac catli ica anquiquechpanose nopa cuamesa monequi xijchihuaca ica acacia cuahuitl, huan xijxahuaca ica senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Nojquiya xijsencahuaca platos, huejhueyi cucharas tlen oro, tepos huitzcucharas huan huejhueyi xarros para ipan anatecase. Huan ica antechmacase, na niamoTeco, nopa tlacajcahualistli catli anquitoyahuase noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Huan monequi mojmostla noixpa anquitlalise iixco nopa mesa nopa pantzi catli tenextilía niitztoc amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Huan nojquiya xijsencahuaca se tlahuil quetzali tlen senquistoc oro catli tlatejtejtzonali ica martillo. Quipiyas se icuayo huan chicuase imacuayohua. Huan sesen pilcaxitzitzi catli ipan tlatlatise quipiyas iyejyejca. Nesis quen se xochitl mimilijtoc huan se xochitl catli cahuantoc, huan nochi iyejyejca monequi elis san se tlatectli oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Huan ica nopa chicuase imacuayohua tlen nopa tlahuil quetzali quipiyas, eyi imacuayohua quisas se lado huan ne seyoc eyi imacuayohua quisas ne seyoc lado. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Huan ipan sese imacuayo quipiyas eyi pilcaxitzitzi catli quiyecchijtoque para nesis quen eyi ixochiyo nopa almendra. Sesen quipiyas se xochitl mimilijtoc huan se xochitl cahuantoc. Nochi chicuase imacuayo catli quisase ipan icuayo nopa tlahuil quetzali quipiyase san se nopa xochitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Huan icuayo catli eltoc tlatlajco nopa tlahuil quetzali quipiyas nahui pilcaxitzitzi ica inintlachiyalis quen ixochiyo se almendra. Sesen quipiyas se xochitl mimilijtoc huan se xochitl cahuantoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Campa quisa nopa achtihui ome imacuayohua ipan sesen lado icuayo, oncas se xochitl mimilijtoc itzala imacuayo. Huan nojquiya itzala ipan sesen lado nopa ompa huan expa imacuayohua oncas se xochitl mimilijtoc. Huajca quipiyas se xochitl mimilijtoc itzala nochi chicuase imacuayohua ipan nopa tlahuil quetzali. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ixochiyo huan imacuayohua elis tlasencahuali ica san se tlatectli tlen senquistoc oro catli tlatejtzontli ica martillo. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Huan xijsencahuilica chicome piltlahuiltzitzi catli anquitlatise para ma tlahuica ica iixmelac. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Nojquiya xijsencahuaca nopa cucharas para ica anquisehuise tlahuili ihuaya ipilplatotzitzi, huan nochi xiquinsencahuaca ica senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Monequis quen 33 kilos tlen senquistoc oro para anquisencahuase huan anquiyectlalise nopa tlahuil quetzali. ");
INSERT INTO nhwBl_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Ximotlachili para xijchihua nochi san quen na nimitznextilía amantzi nica ipan ni tepetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Xijsencahuili nopa yoyon tiopamitl majtlactli cortinas ica icpatl tlen lino tlamalintli hasta nelía canactzi, huan icpatl tlen iniijhuiyo borregojme catli quipajtoque azultic, morado huan chichiltic. Huan ma quixinepalo se catli tlahuel quimati itequi para nesis iniixcopinca nopa ilhuicac ehuani catli inintoca querubines. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Huan sesen cortina quipiyas 12 metros huan tlajco ihuehueyaca, huan ipatlajca elis ome metro. Huan nochi nopa cortinas elis san se ininhuejhuexca. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Huan xijsalo nopa macuili cortinas san sejco. Huan nojquiya xijsalo nopa sequinoc macuili cortinas san sejco. Quej nopa quisas ome cortinas catli nelía huehueyac. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Huan ipan se iteno nopa achtihui macuili cortinas catli tijsalojtoc, xijchihuili tlailpili ica iojal catli tijtenyahualos ica icpatl catli azultic. Nojquiya san se tijchihuas ipan se iteno nopa sequinoc macuili cortinas catli tijsalojtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ipan nopa achtihui tlasaloli tlen cortinas, xijchihuili 50 tlailpili huan ipan sesen xijcahua iojal. Teipa xijtenyahualos campa tijcahuili iojal ica icpatl azultic. Xijchihuili seyoc 50 ipan ne seyoc cortina catli tijsalojtoc para ma moixnamiquica nopa 50 tlailpili ipan se cortina ica catli eltoc ipan ne seyoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Huan xijsencahua 50 tepos chijcoli tlen senquistoc oro catli ica tijsojsos nopa ome cortinas catli tijsalojtoc, huan quej nopa elis san se tlamantli para itzonixco nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Huan nojquiya tijchihuas 11 cortinas ica se yoyomitl tetic catli tlaxinepaloli ica iniijhuiyo oquich chivojme para elis quen se hueyi cuetlaxtli para tijtzontzacuas nopa yejyectzi yoyomitl catli tijtlalijtoc itzonatipa nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Monequi nopa tzontzajcayotl catli eltoc quen se hueyi cuetlaxtli tlen iniijhuiyo chivojme elis 13 metros huan tlajco ihuehueyaca, huan ome metro ipatlajca. Nochi nopa 11 cortinas monequi elis san se ihuejhuexca. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Huan anquisalose macuili cortinas san sejco, huan iyoca anquisalose nopa seyoc chicuase cortinas san sejco. Huan quema anajsitij ipan nopa chicuasempa cortina, xijcuelpachoca para anquihuiyonise iixmelac nopa yoyon tiopamitl campa ticalaquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Huan nojquiya ipan iteno nopa cortinas catli eli quen se hueyi cuetlaxtli, xijchihuilica 50 tlailpili, sese ica iojal. Xijchihuilica 50 tlailpili ica iojal ipan se cortina, huan ipan ne se nojquiya san se xijchihua, 50 tlailpili sese ica iojal. Huan moixnamiquise nopa achtihui tlasaloli cortinas huan ne seyoc tlasaloli cortinas itejteno campa iojal. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Huan nojquiya xijsencahuas 50 tepos chijcoli tlen senquistoc bronce catli ica quisojsos iojal nopa 50 tlailpili ipan iteno se cortina ica iojal nopa 50 tlailpili ipan iteno seyoc cortina, huan quej nopa elis san se itzontzajca quen se hueyi cuetlaxtli. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Huan tlajco se cortina mocahuas cuapilijtos iica nopa tiopamitl huan seyoc tlajco iixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Huan nopa yoyomitl catli mocahuas cuapilijtoc oncac quitzacuas nopa tiopamitl. Tlajco metro cuapilijtos se lado huan seyoc tlajco metro catli cuapilijtos seyoc lado nopa tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Huan nojquiya tijchihuilis seyoc itzontzajca para yas itzonixco nopa itzontzajca catli eltoc quen se hueyi cuetlaxtli. Huan ya ni tijchihuas ica inincuetlaxo borregojme catli quipiyaj se xihuitl huan tijpas inincuetlaxo ica chichiltic. Huan nopa najpa itzontzajca, xijchihua ica inincuetlaxo pesojme huan quitzacuas nopa itzontzajca catli borregojme inincuetlaxo. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Huan nojquiya xijchihuaca nopa huapalme catli moquetztose xitlahuaque para mochihuase nopa caltechtli tlen nopa tiopamitl. Xiquinchihuaca nopa huapalme ica acacia cuahuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Huan nochi huapalme monequi elis nahui metro huan tlajco ihuehueyaca, huan 65 centímetros ipatlajca. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Huan sesen huapali quihuicas ome imax catli huelis calaquis ipan seyoc huapali catli moquetza inechca. Xiquinchihua nopa huapalme para nopa yoyon tiopamitl quej ni. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Xiquinsencahua 20 huapalme catli motequihuise ipan nopa caltechtli catli eltoc ica sur. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Huan xiquinsencahua 40 icuatetonyo tlen senquistoc plata, huan nopa 20 huapalme calaquise ipan nopa cuatetomitl para moquetzase xitlahuac. Sese huapali monequi quipiyas ome icuatetonyo tlatzintla para nopa ome imax. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","“Huan nopa caltechtli catli eltoc ica norte ipan nopa yoyon tiopamitl nojquiya quinpiyas 20 huapalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Huan quinpiyas 40 icuatetonyo tlen plata. Ome icuatetonyo mocahuase tlatzintla se huapali, se ipan sese imax. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Huan para iica tiopamitl campa temo tonati xiquinchihuili chicuase huapalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Nojquiya xiquinchihuili ome huapalme para yas iica tiopamitl oncac ipan icalnacastla. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Nopa huapalme catli yas icalnacastla, monequi tlatzquis ica tepos chijcoli tlatzintla huan huejcapa. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Huajca para iica oncas chicueyi huapalme huan 16 icuatetonyo tlen plata, ome icuatetonyo para sesen huapali. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Nojquiya xiquinchihuili cuaixtlapalme tlen cuahuitl acacia. Xiquinchihua macuili cuaixtlapalme para nopa huapalme ipan se caltechtli, ");
INSERT INTO nhwBl_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","huan seyoc macuili cuaixtlapali para nopa huapalme ipan seyoc caltechtli. Huan xijchihua seyoc macuili para nopa huapalme catli yas campa temo tonati, iica tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Huan nopa cuaixtlapali catli panos tlatlajco ipan ihuejcapanca nopa huapalme monequi elis san se tlatectli cuahuitl huehueyac catli ajsis se inacastla caltechtli hasta seyoc inacastla. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Huan xijxahua nopa huapalme huan nopa cuaixtlapalme ica oro, huan xijchihua nopa anillos calteno campa calaquise nopa cuaixtlapalme ica senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Huan xijquetza nopa yoyon tiopamitl senquistoc quen nimitznextili nica tepeixco. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Nojquiya xijchihua se cortina ica lino icpatl catli nelía canactzi huan icpatl catli quipajtoque azultic, morado huan chichiltic. Huan quema quixinepalohua nopa yoyomitl se yoyonchijquetl catli cuali quimati itequi, ma ipan quixinepalos notequihuajcahua na niamoTECO catli inintoca querubines. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Huan xijpatlahuas nopa cortina huan tijcuapilos ica tepos chijcolme tlen oro ipan nahui tlaquetzalme tlen cuahuitl acacia catli tlaxahuali ica oro. Huan nopa tlaquetzalme moquetzase ipan nahui cuatetomitl tlen plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Xijcuapilo nopa cortina itzala nopa tepos chijcolme. Huan iica nopa cortina xijtlali nopa caxa catli quipiya notlanahuatilhua. Huan ni cortina quiiyocatlalis nopa achtihui cuarto Campa Tlatzejtzeloltic ica nopa seyoc cuarto catli más calijtic catli itoca Campa Más Tlatzejtzeloltic catli quipiya nocaxa. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Huan ipan nopa caxa xijtlali itzajca campa nimechtlasojtlas quema antechixtzacuilise amotlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Huan ipan nopa achtihui cuarto catli más calteno quema ayamo ticajsi campa nopa cortina, xijtlali nopa cuamesa ica norte. Huan ipan san se nopa cuarto ica sur, xijtlali nopa tlahuil quetzali iixmelac nopa cuamesa. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Huan para campa ticalaquis ipan nopa achtihui cuarto ipan yoyon tiopamitl, xijchihua se cortina catli tlaxinepaloli ica lino icpatl nelcanactzi huan ihuaya icpatl catli azultic, morado huan chichiltic. Ma quichihua se yoyonchijquetl catli cuali quimati. ");
INSERT INTO nhwBl_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Huan nojquiya ni cortina xijcuapilo ica tepos chijcoli catli senquistoc oro ipan macuili tlaquetzali tlen cuahuitl acacia catli tijxahuas ica oro. Huan xijchihua macuili icuatetonyo tlen bronce catli yas itzintla nopa macuili tlaquetzalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Xijchihua se tlaixpamitl ica cuahuitl catli itoca acacia. Huan elis cuadrado ica 2 metros huan 25 centímetros ihuehueyaca huan ipatlajca, huan quipiyas 1 metro huan 25 centímetros ihuejcapanca. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Huan ipan najcac iesquinajyo xijchihuili nahui icuacua catli san se ininhuejhuexca. Xijsencahua ica san se tlatectli cuahuitl huan xijxahua ica nopa tepostli bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Nojquiya xijchihuili nochi catli quitequihuise nopona. Xijchihuili catli ipan quitemase cuanextli, huan itepos palas, huan nopa huajcali para quiselis estli, huan nopa tepos chijcoli para ica quiitzquise nopa nacatl, huan nopa tepostli para tlicoli. Huan nochi tijsencahuas ica bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Huan xijsencahuili se tlixictli tlen bronce ica ivarillas. Xijtlalili se anillo ipan sese inacastla para ica tijquixtis. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Huan xijsehui nopa tlixictli ipan nopa iteno catli tlatlajco mocahua iijtico nopa tlaixpamitl, pampa ya nopa para ipan mosehuis tlixictli itzonatipa campa oncas tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Nojquiya xijsencahua cuahuitl huehueyac para nopa tlaixpamitl para ica anquihuicase. Xijchihua ica cuahuitl acacia huan xijxahua ica bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Huan nopa cuahuitl huehueyac catli anquisencahuase, xijcalaqui sesen ome lados tlen nopa tlaixpamitl ipan nopa anillos para huelis anquihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Xijsencahua nopa tlaixpamitl ica huapalme, huan ma mocahua cacahuatic ijtic campa tlipitzase. Huan xijsencahua nochi senquistoc quen nimitznextili nica ipan ni tepetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Nojquiya tijsencahuilis catli elis quen se calixpamitl catli quiyahualos nopa yoyon tiopamitl. Huan xijchihuili se tlatzactli tlen cortinas tlen lino yoyomitl. Huan ihuehueyaca nopa lado ica sur elis 45 metros. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Huan nopa lado quipiyas 20 itlaquetzalo catli moquetzas ipan 20 inincuatetonyo tlen nopa tepostli bronce. Huan xijtatacatzos nochi nopa tlaquetzali ica plata catli quipiya se ianillo. Huan nojquiya xijchihua tepos chijcoli ica plata para ica tijtlatzquiltis nopa anillos ipan tlaquetzali ica nopa icuatetonyohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Nopa tlatzactli tlen cortinas ica norte elis san se, 45 metros ihuehueyaca. Huan xijcuapilo nopa cortinas ipan 20 tlaquetzalme catli tijtatacatzos ica plata catli quipiya se ianillo, huan moquetzas nopa tlaquetzali ipan 20 cuatetomitl. Huan nopa tepos chijcoli nojquiya xijchihua ica plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Huan nopa cortinas catli quitzacuas iica nopa yoyon tiopamitl campa huetzi tonati quipiyas 22 metros huan tlajco ihuehueyaca. Huan xijcuapilo ipan 10 tlaquetzali catli moquetzas ipan 10 cuatetomitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Huan iixmelac nopa yoyon tiopamitl campa hualquisa tonati, nojquiya tijpatlahuas cortinas catli ihuehueyaca 22 metros huan tlajco. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Huan oncas cortinas ipan sesen lado campa tlapojtoc para calaquise. Ipan se lado nopa cortinas quipiyase 7 metros huan quicuapilose ipan eyi tlaquetzali catli moquetzas ipan eyi cuatetomitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Huan ipan ne seyoc lado nojquiya nopa cortina quipiyas 7 metros huan quicuapilojtose ipan eyi tlaquetzali catli moquetzas ipan eyi cuatetomitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Huan tlatlajco, campa tlapojtoc para calaquise, xijtlali se cortina catli quipiyas 9 metros ihuehueyaca. Huan xijcuapilo nopa cortina ipan nahui tlaquetzali catli moquetzas ipan nahui cuatetomitl. Huan nopa cortinas campa ancalaquise monequi elis tlaxinepaloli ica lino icpatl catli nelía canactzi ihuaya icpatl catli azultic, morado huan chichiltic. Huan quixinepalos se catli tlahuel quimati itequi. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Huan tiquinxahuas ica plata nochi nopa tlaquetzalme ipan nopa tlatzactli tlen cortinas yahualtic tlen nopa calixpamitl. Huan xijtatacatzos sesen tlaquetzali ica se tlatectli plata catli quipiya ianillo. Nojquiya nopa tlaquetzalme quipiyas tepos chijcolme tlen plata, huan icuatetonyo tlen bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Huan nopa tlatzactli catli quitzacuas nopa calixpamitl catli quiyahualohua nopa yoyon tiopamitl quipiyas 45 metros ihuehueyaca, huan 22 metros huan tlajco ipatlajca. Huan nopa tlatzactli tlen cortinas quipiyas 2 metros huan 25 centímetros ihuejcapanca. Huan nopa cortinas xijchihua ica lino tlamalintli nelcanactzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Nochi tlamantzitzi catli quitequihuise ipan nopa tequitl tiopan calijtic huan nochi tepos chijcolme para ipan quicuapilose nopa tlamantzitzi elis tlen bronce. Huan nopa estacas para nopa yoyon tiopamitl huan nopa tlatzactli tlen cortinas monequi xijchihua ica bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Huan xiquinnahuati nopa israelitame ma quihualicaca aceite catli más cuali catli quisa quema quitisij olivas. Huan anquitequihuise para tlahuili nochipa ma tlatlatos. ");
INSERT INTO nhwBl_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Huan nopa tlahuil quetzali moquetzas ipan nopa achtihui cuarto ipan nopa yoyon tiopamitl campa timopantise. Nopa cuarto eltoc iixmelac nopa cortina catli quitzacua campa mocahua nopa caxa ipan nopa cuarto Campa Más Tlatzejtzeloltic. Huan Aarón huan itelpocahua quitlatise nopa tlahuili noixpa, na niamoTECO, sesen tiotlac huan tlatlatos hasta ica ijnaloc. Huan ni tlanahuatili monequi quichihuase israelitame huan iniixhuihua ama huan teipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Xijnotza ma huala moicni Aarón huan itelpocahua Nadab, Abiú, Eleazar huan Itamar para huelis tiquiniyocatlalis para na. Pampa niquintlapejpenijtoc ipan nochi israelitame para ma elica totajtzitzi catli nechtequipanose. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Huan xijsencahuili moicni Aarón iyoyo catli tlatzejtzeloltic para ica nechtequipanos. Huan iyoyo monequi elis nelía yejyectzi para nochi quitlepanitase pampa quej nopa quinamiqui ihueyitilis nopa hueyi tequitl catli quichihuas noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Huan nochi masehualme catli tlalnamiquij para tlasencahuase huan catli niquinmacatoc yajatili, xiquinilhui ma hualaca para quichihuaquij Aarón iyoyo catli quinextis para yaya itztoc iyoca tlen sequinoc totajtzitzi, pampa yaya elis nototajtzi para nechtequipanos. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","“Huan ya ni nopa yoyomitl catli monequi quisencahuilise Aarón para moquentis: iyolixpantzajca, ipantzajca catli amo quipiya imangas, iyoyo catli huehueyac, ipaniyoyo ica itlachijchihualo, icuatzajca huan itzinquechilpica. Ma quichihuaca ni yoyomitl para moicni Aarón huan nojquiya ma quinchihuilica ininyoyo itelpocahua para huelis nechtequipanose quen nototajtzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Huan catli quipiyaj tlalnamiquilistli quichihuase ininyoyo ica piltepos mecatzitzi tlen oro huan ica icpatl catli azultic, morado, huan chichiltic, huan quixinepalose ica lino icpatl catli tlamalintli nelía canactzi.” ");
INSERT INTO nhwBl_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Huan quichihuase nopa ixpantzajcayotl ica miyac piltlajco ilpicayotl catli tlaxinepaloli tlen oro catli nelcanactzi, huan icpatl catli azultic, morado huan chichiltic, huan ica lino icpatl tlamalintli nelcanactzi. Huan monequi quichihuase masehualme catli nelía cuali quimatij tlasencahuaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Monequi iixpantzajcayo elis ome tlatectli tlen yoyomitl catli moixnamiquis iajcolpa, huan iyolixco huan iica mocahuas se iyoyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Huan iixpantzajcayo huan itzinquechilpica monequi elis tlen san se tlaxinepaloli yoyomitl. Huan itzinquechilpica ica catli quiilpis iyoyo elis yejyectzi tlasencahuali. Xijxinepaloca nopa yoyomitl ica piltlajco ilpicayotl catli tlaxinepaloli ica oro catli canactzi, huan icpatl tlen lino catli tlamalintli nelía canactzi, huan icpatl catli quipajtoque azultic, morado huan chichiltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Huan xijcui ome piltetzitzi catli itoca ónice huan ipani xijtejtequi huan xiquijcuilo inintoca nochi itelpocahua Israel. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Chicuase inintoca xijtejtequi ipan se tetl huan chicuase ipan ne seyoc tetl. Huan xiquijcuilo inintoca quen tlacajtiyajque. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Quema quitlalise nopa tocayotl ipan nopa tetl, monequi quitejtequise quen elisquía se sello. Huajca nopa ome teme quipiyase nochi inintoca itelpocahua Israel. Huan itejteno sesen tetl xijsencahua ipiltencuayo tlen senquistoc oro catli anquiyectlalijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Huan xijtlali nopa ome tetl iajcolpa nopa ixpantzajcayotl para nopa totajtzi nochipa quihuicas inintoca iajcolpa para ma nechelnamiquiltijtinemi na, niamoTECO tlen itelpocahua Israel. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Huan xijtlatzquiltis nopa piltetzitzi ipan oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Huan xijchihua ome piltlajco ilpicayotzitzi catli tlaxinepaloli tlen oro catli nelía canactzi. Huan nopa piltlajco ilpicayotzitzi quitlatzquiltise ipan ipiltencuayohua nopa ónice teme iajcolpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Teipa ica miyac cuidado, xijchihuaca nopa yolixpantzajcayotl catli quipiyas catli anmechnextilis tlaque nopaquilis na, niamoTECO Dios. Huan xijtequihui nopa piltepos mecatzitzi tlen oro, huan lino icpatl tlamalintli nelcanactzi, huan icpatl catli quipajtoque azultic, morado huan chichiltic quen tijtequihui ipan nopa ixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Monequi tijcuelpachos para tijchihuas se bolsa catli ompamitl. Ihuehueyaca huan ipatlajca nopa bolsa elis 22 centímetros huan tlajco, pampa cuadradojtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Huan iixpa xijtlatzquiltili nahui pamitl ica piltetzitzi catli yejyectzitzi. Ipan nopa achtihui pamitl xijtlatzquiltili se piltetzi catli itoca rubí, se topacio huan se sardónice. Ya ni elis nopa achtihui pamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Nopa ipan ompa pamitl, xijtlatzquiltili se esmeralda, se zafiro huan se diamante. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Huan ipan nopa expa pamitl xijtlatzquiltili se jacinto, se ágata huan se amatista. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Huan ipan nopa najpa pamitl xijtlatzquiltili se berilo, se ónice huan se jaspe. Nochi ni piltetzitzi monequi tlatzquitose ipan ininpiltencuayotzitzi tlen oro catli mocahuas inintejteno huan anquiyecchihuase. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Huan imiyaca nopa piltetzitzi monequi elis quen imiyaca itelpocahua Israel, majtlactli huan ome. Huan sesen piltetzi quiixnextis se itelpoca Israel huan anquitejtequise ipan sesen tetl quen se pilsellojtzi catli quipiyas san se itoca se itelpoca Israel. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Huan para quitatacatzos nopa yolixpantzajcayotl ipan nopa ixpantzajcayotl, xijchihuili piltlajco ilpicayotzitzi catli tlaxinepaloli ica piltepos mecatzitzi catli canactzi huan senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Huan teipa xijchihua ome anillos tlen oro, se ipan sesen iesquinajyo ica huejcapa ipan nopa yolixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Nopa ome piltlajco ilpicayotzitzi panose ipan nopa ome anillos catli eltoc iajcoltipa nopa ixpantzajcayotl. Quej nopa xijtlatzquiltis nopa yolixpantzajcayotl ica nopa ixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Nojquiya ininyecapa nopa piltlajco ilpicayotzitzi moilpise ipan nopa anillos catli eltoc iajcoltipa nopa ixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Teipa xijchihua seyoc ome anillos tlen oro huan xiquintatacatzo nopa ome esquinas catli tlatzintla ipan nopa yolixpantzajcayotl, pero xiquintatacatzos nopa ome anillos itzala nopa yolixpantzajcayotl campa moteca ipan catli quipantzacua. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Huan teipa xijchihua seyoc ome anillos ipan nopa ixpantzajcayotl, se ipan sesen lado iijtic nechca itzinquechilpica. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Huan teipa xiquilpi nopa anillos catli tlatzintla ipan nopa yolixpantzajcayotl ipan ni anillos ipan nopa ixpantzajcayotl ica se listón azultic para nopa yolixpantzajcayotl ma motlali huan ma mocahua cuali ipan nopa ixpantzajcayotl campa itlajcoya huan amo papatlacas. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Huan yeca quema calaquis Campa Tlatzejtzeloltic Aarón nochipa huelis quihuicas inintoca itelpocahua Israel iyolixco ipan nopa iyolixpantzajcayo huan nechelnamiquiltis na, niamoTECO, tlen inijuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","“Huan iijtic nopa yolixpantzajcayotl campa ibolsa, xijtlali nopa Urim huan nopa Tumim, nopa dados tlatzejtzeloltic tlen na niamoTECO, catli anquitequihuise quema monequis anquimatise ‘quena’ nopaquilis se tlamantli, o ‘amo’. Huan Aarón quihuicas iyolixpa nopa Urim huan Tumim, nopa dados tlatzejtzeloltic tlen na niamoTECO, quema calaquis noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Huan xijchihua iyoyo huehueyac catli senquistoc azultic catli moquentis itzala nopa ixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Huan monequi xijquechtequis campa calaquis itzonteco nopa totajtzi. Huan campa quiquechtequise monequi quicuelpachose se quentzi huan quiyahualose ica icpatl para mochihuas se yejyectzi tlajtzontli tlayahualoli para amo tzayanis iquechtla. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Huan icuextejteno nopa iyoyo huehueyac monequi xijchihua se tlajtzontli yejyectzi campa xiquixcopina nopa cuatlactli granada ica icpatl azultic, morado huan chichiltic para ma quiyahualo icuexteno. Huan tlatlajco nopa granadas monequi xijcuapilojtiyas pilcampanajtzitzi tlen oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Monequi elis se pilcampanajtzi tlen oro huan teipa se granada tlajtzontli, teipa seyoc pilcampanajtzi tlen oro huan seyoc granada tlajtzontli, huan quej nopa yajtiyas ipan nochi itejteno. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Huan ya nopa moquentis Aarón quema nechtequipanos na, niamoTECO, calijtic Campa Más Tlatzejtzeloltic. Huan quema Aarón calaquis o quisas ipan nopa cuarto tzilinis nopa pilcampanajtzitzi tlen oro para amo miquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Nojquiya xijsencahua se tlatectli oro catli canactzi quen se piltepos patlactzi quen se credencial huan ipan xijtejtequi se tlajcuiloli quen campa quisencahuaj se sello huan quiijtos: TLAIYOCATLALILI PARA TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Huan xiquilpi nopa piltepos patlactzi ica se listón azultic iixpa ipan icuatzajcayo. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Huan nopa piltepos patlactzi mocahuas cuapilijtos ipan icuajtol Aarón. Huan quema nopa israelitame quiiyocatlalise tlacajcahualistli para na huan quihualicase, sintla ayamo senquistoc tlapajpactli nopa tlacajcahualistli noixpa na, niamoTECO, huajca Aarón ica nopa piltepos patlactzi huelis quihuicas inintlaixpanolhua catli quiajsitoque nopa tlacajcahualistli. Huan niquitas nopa tlacajcahualistli catli nopa israelitame nechmacase para tlatzejtzeloltic huan nijselis. Yeca Aarón monequi motlalilis nopa cuatzajcayotl ica nopa piltepos patlactzi nochipa quema calaquis tiopan calijtic noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Huan xijchihuili ipaniyoyo nopa hueyi totajtzi catli tlaxinepaloli ica icpatl tlen lino tlamalintli nelía canactzi. Huan nojquiya icuatzajcayo quichihuase ica lino, huan xijchihua itzinquechilpica huan ma quipiya itlachijchihualo catli yejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Huan nojquiya xiquinchihuili itelpocahua Aarón ininpaniyoyo, huan inintzinquechilpica ica itlachijchihualo huan inincuatzajca. Huan ica nopa ininyoyo yejyectzi, nochi masehualme quintlepanitase. Nelía quinamiqui quipiyase ininhueyitilis por nopa hueyi tequitl catli quichihuase noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","“Huajca ica nochi ni yoyomitl xiquinyoyonti moicni Aarón huan itelpocahua. Teipa xiquinajalti aceite ipan inintzonteco huan xiquiniyocatlali para na. Huan quej nopa xiquintequimaca ma nechtequipanoca quen totajtzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Huan nojquiya xiquinchihuili inintlatzintlanyoyo ica nopa cuali yoyomitl lino para ma motlalilica tlatzintla nopa sequinoc ininyoyo. Huan quintzacuas tlen inintzinquechtla hasta ininmetztomahuiya. ");
INSERT INTO nhwBl_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Huan Aarón huan itelpocahua monequi moquentise quema calaquise tiopan calijtic para nechtequipanose, o quema monechcahuise campa nopa tlaixpamitl ipan nopa cuarto Campa Tlatzejtzeloltic. Huan sintla moquentise catli nimechilhuía, amo motlajtlacoltise huan miquise. Ni tlanahuatilme elis para Aarón huan itelpocahua para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Huan ya ni catli monequi xijchihua para tiquiyocatlalis Aarón huan itelpocahua ma elica nototajtzitzi. Xijcui se becerro huan ome oquich borregojme catli nelía cuajcualme huan amo tleno amo cuali quipiyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Huan ica harina tlen trigo catli amo quipiya tlasonejcayotl, xijchihua pantzi. Huan nojquiya xijchihua tortas catli quipiya aceite. Huan xijchihua seyoc pantzi catli nesis quen tlaxcali huactoc catli tiquixajalos ica aceite. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Huan xijtema nochi ni pantzi ipan se chiquihuitl, huan techmaca na niamoTeco ipan tlaixpamitl ica nopa becerro huan nopa ome oquich borregojme. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Huan xijhualica Aarón huan itelpocahua ipan icalixpa nopa yoyon tiopamitl campa timopantise nechca campa calaquise, huan nopona xiquinpajpacas ica atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","“Huan xijcui nopa yejyectzi yoyomitl catli anquisencahuilijtoque huan xijyoyonti Aarón ica nopa ixpantzajcayotl, nopa yolixpantzajcayotl, huan ica ipaniyoyo. Huan xiquilpi ipan nopa ixpantzajcayotl ica nopa tlajco ilpicayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Huan xijtlalis ipan itzonteco nopa cuatzajcayotl. Huan ipan nopa cuatzajcayotl xijtlali nopa piltepos patlactzi tlen oro catli quiijtohua: TLAIYOCATLALILI PARA TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Huan xijcuis nopa aceite para tiquinajaltis tlacame huan tlamantli para tiquiniyocatlalis para na, niamoTECO, huan xicajalti ipan itzonteco Aarón para xiquiyocatlali para nechtequipanos na, niamoTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Huan xiquinhualica itelpocahua huan xiquinyoyonti ica nopa yoyomitl catli anquisencajque para inijuanti. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Huan xiquintlajcoilpi huan xiquintlalili inincuatzajca, huan inijuanti quiselise nopa tequitl ica nochi nopa tlanahuatili huan elise totajtzitzi noixpa para nochipa. Quej ni, huajca xiquiniyocatlali Aarón huan itelpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Xijhuica nopa becerro iixpa nopa yoyon tiopamitl, huan Aarón huan itelpocahua ma quitlalica ininmax ipan itzonteco nopa becerro. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Teipa xijmicti nopa becerro noixpa na, niamoTECO, ipan nopa calixpamitl ipuertajteno campa calaquise nopa yoyon tiopamitl campa timopantise. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Huan xijcui se quentzi ieso nopa becerro huan xijtlali ica momacpil ipan nochi nahui icuacua nopa tlaixpamitl campa quitlatise tlacajcahualistli. Huan nopa estli catli mocahuas, xijtoyahua nechca itzintla nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Teipa xijcui nochi nopa tlachiyajcayotl iijtico nopa becerro, huan catli eltoc ipan ieltapach huan ipan isosonec, huan nochi ni tlachiyajcayotl huan nojquiya isosonec xijtlati ipan nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Pero inacayo nopa becerro, ica icuetlaxo huan icuitl, xijhuica huejca, campa amo onca calme huan xijtlatiti. Huan ni becerro elis se tlacajcahualistli para tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Huan nojquiya xijcui se tlen nopa oquich borregojme, huan Aarón ihuaya itelpocahua ma quitlalica ininmax ipan itzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Huan xijmicti nopa oquich chivo huan ieso xijtzejtzelo yahualtic tlaixpamitl ipan iquespa. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Huan inacayo nopa oquich borrego, xijhuejhuelos. Huan xijpajpaca icuetlaxcol huan imetz, huan xijtencahua ipan tlaixpamitl ihuaya itzonteco huan nopa sequin catli tijhuejhuelojtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Huan xijtlatis nochi nopa oquich borrego ipan nopa tlaixpamitl. Huan ya ni elis se tlacajcahualistli tlatlatili para na, niamoTECO. Huan nelía ajhuiyac mijyotis huan nechpactis, pampa elis se tlacajcahualistli tlatlatili catli antechmacaj ica tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Teipa xijcui nopa seyoc oquich borrego, huan Aarón huan itelpocahua quitlalise ininmax ipan itzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Huan xijmicti nopa oquich borrego, huan xijcui quentzi ieso huan xijpolo itzintla ininnacas catli ininnejmac Aarón huan itelpocahua. Nojquiya xijpolo quentzi nopa estli ipan ininhueyi macpil huan ininhueyi xocpil catli ininnejmac. Huan xijtzejtzelo nopa estli yahualtic itejteno nopa tlaixpamitl Campa Quitlatise Tlacajcahualistli campa iquejquespa. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Huan xijcui quentzi nopa estli ipan tlaixpamitl huan quentzi nopa aceite catli ica titlaiyocatlalía, huan xiquijtzelo ipan Aarón huan ipan iyoyo, huan ipan itelpocahua huan ipan ininyoyo nojquiya. Huan ica ya nopa Aarón huan itelpocahua huan ininyoyo elis tlatzejtzeloltic huan tlaiyocatlalili para na, niamoTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Teipa xijquixtili ichiyajca nopa oquich borrego. Xijcui nopa tlachiyajcayotl campa icuitlapil, icuetlaxcol huan ieltapach. Huan xijcui nopa ome isosonec huan ininchiyajca, huan nopa imetz tlen inejmac, pampa ica nopa tlacajcahualistli tlen nopa oquich borrego tiquintequitlalis Aarón huan itelpocahua para nechtequipanose. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Nojquiya xijcui se pantzi tlen nopa chiquihuitl catli quipiya pantzi catli amo quipiya tlasonejcayotl catli eltoc noixtla na, niamoTECO. Huan nojquiya xijcui se torta catli quipiya aceite huan se ne seyoc pantzi catli nesi quen tlaxcali huactoc catli anquiixajalojtoque aceite. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Huan nochi ni pantzi huan ichiyajca nopa borrego, xijtlali imaco Aarón huan ininmaco itelpocahua. Huan inijuanti quihuisose noixpa, niamoTECO, pampa ya nopa elis se tlacajcahualistli catli anquihuisose noixpa para antechmacase. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Teipa xijcui tlen ininmax nochi catli quihuisojque noixpa huan xijtlali ipan nopa tlaixpamitl noixpa para se tlacajcahualistli tlatlatili. Huan nopa tlacajcahualistli mijyotis ajhuiyac huan nechpactis na niamoTECO. Ya ni elis se tlacajcahualistli tlatlatili catli antechmacaj ipan tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“Huan teipa xijcui iyolix nopa oquich borrego catli ica tijtequitlalía Aarón para nechtequipanose, huan xijhuisos noixpa, nimoTECO, huan teipa nopa iyolix elis para ta, Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Huan nochipa quema tiquiniyocatlalis tlacame para ma elica totajtzitzi, Aarón huan itelpocahua quiselise iyolix huan imetz nopa borrego catli quihuisojque noixtla para nechmacase. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Quena, ya ni elis se tlanahuatili para nochipa para xiquinmaca Aarón huan itelpocahua iyolix huan imetz se tlacajcahualistli. Amo quema ma quielcahuaca israelitame para quinmacase ni nacatl nopa totajtzitzi, masque temacaj se tlacajcahualistli para moyoltlalise nohuaya, niamoTECO, o temacaj se tlacajcahualistli para nechtlascamatilise. Ya ni quinamiqui quiselise totajtzitzi para iniaxca. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Huan nochi ni iyoyo Aarón catli tlatzejtzeloltic teipa elis para nopa itelpoca catli quitoquilis ipan itequi quen nopa hueyi totajtzi catli más quipiya tequiticayotl. Huan quej nopa, ni yoyomitl panos tlen se itelpoca hasta se iixhui, huan hasta se iixhui itelpoca. Sesen catli quiselis ni tequitl para elis hueyi totajtzi catli ama quitocarohua Aarón, nojquiya quiselis ni yoyomitl catli ihuaya yohui ni tequitl. Quiselise quema quiniyocatlalise sese ica aceite para quintequitlalise para nechtequipanose, niamoTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Huan nopa itelpoca Aarón catli quitocaros quiselis itequi teipa, monequi moquentis ni yoyomitl tlatzejtzeloltic para chicome tonali, huan teipa quena, hueli pehuas tequitis ipan nopa achtihui cuarto Campa Tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Huan xijcui inacayo nopa oquich borrego catli tijtequihuijtoc para tiquiniyocatlalis Aarón huan itelpocahua, huan xijcacatzo campa tlapajpactli noixpa niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Huan Aarón huan itelpocahua quicuase inacayo nopa oquich borrego ihuaya nopa pantzi catli eltos ipan nopa chiquihuitl ipan calixpamitl nechca campa calaquise ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Quena, san inijuanti huelis quicuase ni tlacajcahualistli catli tijtequihui quema tiquiniyocatlali para ma nechtequipanoca na, niamoTECO. Amo aqui más hueli quicuas, san inijuanti, pampa nopa nacatl huan nopa pantzi tlaiyocatlalili, huan tlatzejtzeloltic para na. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Huan sintla mocahuas quentzi pantzi o quentzi nacatl hasta hualmostla, monequi xijtlatis, ayacmo huelis quicuase pampa tlaiyocatlalili para na. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Huajca para chicome tonali tiquinchihuilijtiyas Aarón huan itelpocahua nochi catli nimitznahuatía para tiquiniyocatlali ma nechtequipanoca. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ipan sesen tonal techmaca, niamoTECO, se becerro quen se tlacajcahualistli para nechixtzacuilis inintlajtlacolhua. Nojquiya xijpajpaca nopa tlaixpamitl noixpa ica se tlacajcahualistli catli anquitencahuase ipani. Mojmostla xicalti nopa tlaixpamitl ica aceite para tiquiyocacahuas para na, niamoTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Para chicome tonali xijtencahua tlacajcahualistli huan xijpajpacas nopa tlaixpamitl para elis tlahuel tlatzejtzeloltic, huan nochi catli quiajsis nopa tlaixpamitl elis tlatzejtzeloltic, tlaiyocatlalili para na. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Huan teipa mojmostla xiquintencahua ipan nopa tlaixpamitl ome pilborregojtzitzi catli quipiyaj sese xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Xijtencahua se pilborregojtzi ica ijnaloc huan se pilborregojtzi techmaca quema oncalaqui tonati. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Huan ica nopa pilborregojtzi ica ijnaloc, xijtencahua ome litros huan tlajco harina catli más cuali tlaxacualoli ica se litro aceite catli tlatejtejtzontli tlen olivas. Huan nojquiya xijtecas ipan tlaixpamitl se litro xocomeca atl. Ya nopa se tlacajcahualistli catli quitoyahuase para nechmacase. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Huan ne seyoc pilborregojtzi techmaca, niamoTECO, ica tiotlac quema oncalqui tonati. Huan nojquiya ma nechmacaca nopa harina quen quichijque ica nopa tlacajcahualistli catli ica ijnaloc, huan ma nechmacaca xocomeca atl quen quitoyajque ipan tlaixpamitl ijnaloc. Huan ya ni elis se tlacajcahualistli para na catli antechmacase ipan tlitl huan mijyotis ajhuiyac huan nechpactis. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ya ni elis nopa ome tlacajcahualistli catli monequi anquichihuase mojmostla para ama huan teipa. Huan anquitencahuase noixpa na, niamoTECO, ni tlacajcahualistli ipan nopa tlaixpamitl campa tlatlatise ipan nopa calixpamitl nechca campa ipuerta ipan nopa yoyon tiopamitl campa timopantise. Huan nopona nimechcamanalhuis. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Quena, nopona nojquiya niquinnamiquis nopa israelitame. Huan nopa yoyon tiopamitl elis tlatzejtzeloltic pampa quipiyas notlatlanex. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Huajca niquiyocatlalis para na nopa tiopamitl campa timopantise, huan nopa tlaixpamitl campa tlatlatise. Huan niquiniyocatlalis Aarón huan itelpocahua para ma elica nototajtzitzi huan nochi elise tlatzejtzeloltique. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Huan na nimocahuas para niitztos tlatlajco israelitame huan na nielis niininTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Huan inijuanti nechiximatise para na niDIOS niininTECO catli niquinquixti ipan tlali Egipto para nimocahuas huan niitztos ininhuaya. Quena, na niDIOS, niininTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Nojquiya xijchihua se tlaixpamitl para ipan anquitlatise copali. Xijchihua ica nopa cuahuitl catli itoca acacia. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Huan ihuehueyaca iixpa monequi elis 45 centímetros huan ipatlajca nojquiya 45 centímetros para elis cuadradojtic, huan ihuejcapanca elis 90 centímetros. Huan iixco nopa tlaixpamitl huan icuacua monequi elis san se tlatectli cuahuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Huan tijxahuas ica oro ipani, huan ipan iquespa huan icuacua. Xijchihuili se icorona iixteno catli senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Nojquiya xijchihuili nahui anillos tlen oro, ome ipan sesen lado campa inacastla huan ne ome seyoc lado ipan seyoc inacastla. Huan ipan nopa anillos anquicalaquise nopa cuahuitl huehueyac para ica anquihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Huan xijsencahua nopa huehueyac cuahuitl ica nopa cuahuitl catli itoca acacia, huan xijxahua ica oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Huan ipan nopa achtihui cuarto Campa Tlatzejtzeloltic, xijtlali ni tlaixpamitl para copali. Xijquetza ni tlaixpamitl iixmelac nopa cortina catli quitzacua nopa cuarto Campa Más Tlatzejtzeloltic campa eltoc nopa caxa ica nopa tlanahuatili huan itzajca campa timopantise. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Huan sese ijnaloc quema ajsis hora para Aarón quitejtequis imecha nopa tlahuili, monequi quitlatis copali catli ajhuiyac ipan nopa tlaixpamitl para copali. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Huan nojquiya mojmostla quema tlayohuiyas huan Aarón quisencahuas nopa tlahuilme, quitlatis copali noixpa na, niamoTECO. Quej nopa oncas copali catli tlatlas noixpa mojmostla para nochipa hasta amoixhuihua quipiyase iniixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ipan nopa tlaixpamitl para copali, amo xijtlati seyoc tlamantli copali, niyon amo xiquintlali tlapiyalme para tlatlase. Amo xijtlali tlacajcahualistli tlen harina, niyon amo xijtoyahua ipani nopa tlacajcahualistli catli monequi tijtoyahuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Huan se huelta ipan se xihuitl Aarón quitlapajpacchihuas nopa tlaixpamitl para copali quema quitlalis ipan icuacua se quentzi ieso nopa tlacajcahualistli para nechixtzacuilis amotlajtlacolhua. Huan amoixhuihua huan iniixhuihua quej ni nojquiya quichihuase ipan ni tlaixpamitl para copali se huelta ipan se xihuitl. Ni tlaixpamitl para copali nelía tlatzejtzeloltic para na niamoTECO.” ");
INSERT INTO nhwBl_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Quema tijchihua se censo para tiquinpohuas nopa israelitame, sesen monequi quitlaxtlahuis TOTECO para quimanahuis inemilis. Quej nopa monequi para amo aqui miquis pampa tiquinpohua. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Quema mopohuase, sesen masehuali monequi temacas se plata tomi catli quipiya chicuase gramos ietica huan ya nopa elis se tlacajcahualistli para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Quena, nochi catli ya quiaxitijtoque 20 xihuitl, monequi moijcuilose huan monequi temacase nopa tomi. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Yaya catli rico amo tlaxtlahuas más, niyon catli teicneltzi amo tlaxtlahuas pilquentzi. Nochi nechmacase na, niamoTECO, nopa plata tomi catli quipiya chicuase gramos ietica para quimanahuise ininnemilis. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Huan tijcuis nopa tomi catli temacatose israelitame para momanahuise, huan xijtequihui ipan itequi nopa yoyon tiopamitl campa timopantise. Ica ya ni, niamoTECO nimechelnamiquis huan antechixtzacuilise amotlajtlacolhua para huelis anitztose.” ");
INSERT INTO nhwBl_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Nojquiya xijchihua se hueyi paila ica nopa tepostli bronce para ipan momajtequise totajtzitzi. Nojquiya xijchihuili ica bronce se catli ipan moquetzas nopa hueyi paila. Huan xijquetza ipan nopa calixpamitl tlatlajco nopa tlaixpamitl campa quitlatise tlacajcahualistli huan nopa cortina catli quitzacua nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Huan nopona momajtequise huan moicxipajpacase Aarón huan itelpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Huan sesen huelta quema calaquise ipan nopa yoyon tiopamitl campa timopantise, monequi momajtequise huan moicxipajpacase para amo miquise. Nojquiya quema monequis monechcahuise campa nopa tlaixpamitl para quichihuase inintequi huan quitlatise nopa tlacajcahualistli catli nechtencahuilise na, niininTECO, ");
INSERT INTO nhwBl_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","monequi momajtequise huan moicxipajpacase para ma amo miquica. Huan ni tlanahuatili monequi mocahuas para nochipa para Aarón, iixhuihua huan iniixhuihua quineltoquilise.” ");
INSERT INTO nhwBl_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Xijsentili ni tlaajhuiyacayotl catli nimitzilhuía catli más cuali: Chicuase kilos catli senquistoc mirra, eyi kilo canela, eyi kilo cálamo catli mijyotía ajhuiyac, ");
INSERT INTO nhwBl_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","chicuase kilos catli casia huan nahui litros aceite catli itoca oliva. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Huan ma quisencahua nochi ya ni se tlaajhuiyacasencajquetl catli cuali quimati itequi para ma elis nopa aceite catli tlatzejtzeloltic catli ica tlapojpohuase para tlaiyocatlalise para notequi na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Huan xijtequihui ni aceite para ticajaltis nopa yoyon tiopamitl campa timopantise, huan nopa caxa ica nopa tlanahuatili. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Nojquiya xicajalti nopa cuamesa huan nochi nopa tlamantzitzi catli motequihuis nopona, huan xicajalti nopa tlahuil quetzali ihuaya nochi catli motequihuis nopona, huan xicajalti nopa tlaixpamitl para copali. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Xicajalti nopa tlaixpamitl campa quitlatise tlacajcahualistli huan nochi tlamantli catli motequihuía nopona. Nojquiya xicajalti nopa hueyi paila tlen bronce ihuaya catli ipan moquetztoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Monequi tiquinajaltis para tiquiniyocatlalis para na huan quej nopa nochi elis tlahuel tlatzejtzeloltic, huan nochi catli quiitzquise nopa tlamantzitzi elise tlatzejtzeloltique. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Nojquiya tiquinajaltis Aarón huan itelpocahua ica aceite, huan tiquiniyocatlalis para ma elica nototajtzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Huan xiquinilhui nopa israelitame: ‘Ni aceite elis para tlaajaltise quema quiiyocatlalise tlamantli o masehualme para elise para TOTECO. Ni aceite anmotequilise para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Amo xijteca ipan catli hueli masehuali itlacayo. Huan amo aqui ma quisencahua seyoc tlaajhuiyacayotl senquistoc san se quen tlasencahuali ya ni. Ni aceite tlatzejtzeloltic, huan monequi anquiitase para se tlamantli tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Sintla se acajya quisencahuas se tlaajhuiyacayotl quej ni, o sintla se acajya quipolos se catli amo se nototajtzi, monequi anquiquixtise tlen israelitame para nochipa.’ ” ");
INSERT INTO nhwBl_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nojquiya TOTECO quicamanalhui Moisés huan quiilhui: “Xijmanelo se tlaajhuiyacayotl san se imiyaca tlachipimitl tlen aceite tlen resina, tlen istitl huan tlen gálbano catli ajhuiyac mijyotía, huan nochi xijmanelo ihuaya nopa copali catli senquistoc cuali. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Huan ica ni tlamantli ma quisencahua se copali catli senquistoc cuali. Ma quimanelo nelía cuali quen quimati quichihua se tlaajhuiyacasencajquetl catli cuali quimati itequi. Huan ni copali elis tlatzejtzeloltic san para na, niamoTeco. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Xijtijtisi cuali se quentzi ni tlamaneloli hasta nelía cuechtic mocahuas, huan xijtlali iixpa nopa caxa catli quipiya notlanahuatil ipan nopa yoyon tiopamitl campa timopantise. Huan monequi xijmatica ni tlamaneloli copali eltoc tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Amo aqui ma quisencahua seyoc copali catli senquistoc san se tlasencahuali quej ni pampa ni tlamaneloli copali tlatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Sintla se acajya quichihuas seyoc quej ni san para quiijnecuis, monequi anquimictise.” ");
INSERT INTO nhwBl_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Huajca TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Xiquita, na nijtlapejpenijtoc Bezaleel catli icone Uri huan iixhui Hur catli tlacatqui ipan nopa hueyi familia tlen iixhuihua Judá. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nijtemitijtoc Bezaleel ica noTonal. Huan nijmacatoc miyac yajatili huan tlamachilistli para huelis quichihuas nopa yoyon tiopamitl ica nochi tlamantli catli monequi. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Yaya cuali quimati quitejtzonas oro, plata huan bronce para quichihuas tlen hueli catli monequi. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Nojquiya hueli quiyectlalis piltetzitzi catli patiyo para ma cahuani huan quimati quenicatza quiquejquetzas piltetzitzi sese ipan se piltencuayotl para mocahuas yejyectzitzi. Nojquiya ya hueli quitejtequis cuahuitl huan quiyectlalis para elis quen tlen hueli tlamantli catli tiquilhuis. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Nojquiya nijtlapejpenijtoc Aholiab, icone Ahisamac ipan nopa hueyi familia tlen iixhuihua Dan, para elis itlapalehuijca. Huan nochi sequinoc catli achi más quipiyaj inintlalnamiquilis para quichihuase tlamantzitzi catli yejyectzitzi, nojquiya niquinmacatoc ininyajatil para ma quichihuaca nochi catli nimitznahuatijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Huajca inijuanti hueli quichihuase nopa yoyon tiopamitl campa timopantise, huan nopa caxa campa eltoc notlanahuatilhua, huan itzajca nopa caxa campa nimechtlasojtlas huan antechixtzacuilise amotlajtlacolhua. Nojquiya quichihuase nochi nopa tlamantzitzi catli motequihuis ipan nopa tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Quichihuase nopa cuamesa huan catli motequihuis nopona. Nojquiya quichihuase nopa tlahuil quetzali catli senquistoc oro ica nochi catli motequihuis ihuaya, huan quisencahuase nopa tlaixpamitl para copali. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Quichihuase nopa tlaixpamitl campa quitlatise tlacajcahualistli ica nochi tlamantzitzi catli motequihuis. Nojquiya quichihuase nopa hueyi paila huan catli ipan quiquetzase huan nochi catli motequihuis ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Nojquiya quixinepalose iyoyo tlatzejtzeloltic nopa totajtzi Aarón huan quichihuase ininyoyo itelpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Huan quema quichihuase nopa aceite catli ica antlaajaltise para antlaiyocatlalise para na huan quema quichihuase nopa copali catli ajhuiyac mijyotía para quitlatise ipan nopa tlaixpamitl para copali, monequi nochi mochihuas senquistoc quen nimitznahuatijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Xiquinilhui nopa israelitame para monequi ma mosiyajquetzaca ipan nopa tonal catli nimechnahuati. Pampa nopa tonal elis quen se tlanextilijcayotl para anmechelnamiquiltis amojuanti huan amoixhuihua catli amoca nimocajtoc. Huan quej nopa elis para nochipa hasta amoixhuihua teipa ehuani quipiyase iniixhuihua. Quej nopa anquimatise para na niamoTECO catli nimechchihua antlatzejtzeloltique. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Huajca monequi ma mosiyajquetzaca ipan nopa tonal catli nimechilhui para tlasiyajquetzali pampa nopa tonal tlatzejtzeloltic huan tlaiyocatlalili para na. Sintla se amo quitlepanita ni tlanahuatili, monequi anquimictise. Sintla se tequitis ipan se tonal para anmosiyajquetzase, xijmictica. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Chicuase tonali antequitise, pero ipan nopa chicompa tonal monequi anmosiyajquetzase pampa tlatzejtzeloltic huan tlaiyocatlalili para na, niamoTECO. Sintla se acajya tequitis ipan nopa tonal, monequi miquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Nochi israelitame ama huan iniixhuihua teipa ma amo tequitica ipan nopa tonali para mosiyajquetzase. Monequi quitlepanitase nopa tonali pampa quinextía nopa camanali catli nijchijtoc amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ni tlamantli elis se tlanextilijcayotl para nochipa ica anisraelitame huan na, pampa ica chicuase tonali na, niamoTECO, nijchijqui ilhuicactli huan tlaltipactli, huan ipan nopa chicompa tonal, ayacmo nitequitqui, san nimosiyajquetzqui.” ");
INSERT INTO nhwBl_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Huan quema TOTECO tlanqui camanalti ihuaya Moisés ipan nopa tepetl Sinaí, quimacac ome tepatlactli campa ijcuilijtoc itlanahuatilhua. Huan Toteco Dios quiijcuilojtoya ica ya imax. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Quema nopa israelitame quiitaque para Moisés huejcahuayaya huan amo nimantzi temoyaya tlen nopa tepetl, mosentilijque campa Aarón huan quiilhuijque: ―Techchihuili se tlaixcopincayotl para ma techyacana pampa amo tijmatij tlaque ipantitoc Moisés catli techquixti ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Huan Aarón quinilhui: ―Ma moquixtilica ininpijpilolhua amosihuajhua, amotelpocahua huan amoichpocahua; huan ma techhualiquilica nica. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Huajca nochi moquixtilijque ininpijpilolhua huan quihuiquilijque Aarón. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Huan yaya quiseli huan quiatili nopa oro, huan quema quiquixti ipan tlitl, quitejtzonqui ica se martillo huan quichijqui quen se becerro. Huajca nopa israelitame quiijtojque: ―¡Xitlacaquica anisraelitame, ya ni todios catli techquixti ipan tlali Egipto! ");
INSERT INTO nhwBl_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Huan quema Aarón quiitac quenicatza paquiyayaj nopa israelitame, quisencajqui se tlaixpamitl iixpa nopa becerro, huan teyolmelajqui: ―Mostla tijpiyase se ilhuitl para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Huan hualmostla nochi israelitame mejque cualca huan quinmictijque tlapiyalme huan quintlatijque ipan nopa tlaixpamitl, huan quimacaque tlacajcahualistli para Toteco ma moyoltlali ininhuaya. Teipa nochi mosehuijque ipan se hueyi tlacualistli huan tlacuajque huan tlaique quen amo monequi. Huan teipa nochi quichihuayayaj catli fiero quen catli quichihuaj tlen hueli masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Huajca TOTECO quiilhui Moisés: ―Xitemo amantzi tlen ni tepetl, pampa momasehualhua catli tiquinquixti tlen tlali Egipto monenpolojtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Nimantzi quicajtejque nopa tlanahuatilme catli niquinnahuati ma quitoquilica. Quiatilijque oro huan mochihuilijque se becerro huan amantzi quihueyichihuaj huan quimactilíaj tlacajcahualistli, huan quiijtohuaj: ‘Anisraelitame, ya ni amodios catli anmechquixti ipan tlali Egipto.’ ");
INSERT INTO nhwBl_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Nojquiya TOTECO quiilhui Moisés: ―Nimomacatoc cuenta quenicatza itztoque ni masehualme huan niquita para nelyoltetique. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Huajca ama techcahua, pampa nelía tlahuel nicualani ininhuaya huan niquintzontlamiltis, pero tlen ta, Moisés, niquinchihuas sequinoc masehualme catli momiyaquilise tlahuel miyac huan itztose ipan se hueyi tlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Pero Moisés chicahuac quitlajtlani iTECO Dios ma amo quichihua, quiijto: ―¡Ay TOTECO! ¿Para tlen ticualanis ica momasehualhua catli ta tiquinquixti ipan tlali Egipto ica mohueyi chicahualis? ");
INSERT INTO nhwBl_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Nopa egiptome quiijtose para ta catli tiininTeco tiquinquixti ipan tlali Egipto, pampa ya timoilhuiyaya para tiquinmictis ipan tepeme, pampa tijnequiyaya tiquinixpolihuiltis tlen ni tlaltipactli. TOTECO, amo hueli tiquincahuilise egiptome ma quiijtoca ya nopa. Yeca ayacmo xicualani. Ximoyolcuepa ica catli timoilhuijtoc tijchihuas huan amo xiquincoco momasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Xiquinelnamiqui Abraham, Isaac, huan Israel motequipanojcahua catli ta timotestigojquetzqui ica moseltzi huan tiquinilhui tiquinmiyaquilis iniixhuihua para ma elica tlahuel miyaqui hasta amo aqui huelis quinpohuas. Tiquijto itztose quen imiyaca sitlalime nepa ilhuicac. Huan nochi ni tlali tiquinmacas iniixhuihua. Huan tiquijto quiselise huan elis iniaxca para nochipa. Quena, quej nopa tiquintencahuili motequipanojcahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Huajca TOTECO moyolcuepqui ica catli moilhuijtoya quinchihuilisquía imasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Huan Moisés pejqui temo tlen nopa tepetl, huan quihualicayaya imaco nopa ome tepatlactli catli quipixtoya nopa tlanahuatilme. Huan itlanahuatilhua Toteco ijcuilijtoya iixpa huan iica nopa tepatlactli. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Yaya Toteco Dios catli quitejtejqui nopa tetl huan quichijqui nopa tepatlactli huan yaya catli ipan tlajcuilo. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Huan quema Josué quicajqui tlahuejchihuayayaj nopa israelitame nopona tlatzintla, quiilhui Moisés: ―Nijcaqui tlahuejchihuaj campa itztoque nopa masehualme quen onca se tlahuilancayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Pero Moisés quinanquili: ―Amo tlahuejchihuaj pampa tlatlantoque, niyon amo quichihuaj pampa sequinoc quintlantoque. Nijcaqui catli huicaj seyoc tlamantli huicatl. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Huan quema Moisés monechcahuiyaya campa itztoyaj nopa israelitame, quiitac nopa becerro huan quenicatza mijtotiyayaj, huan nelía cualanqui. Huan quimajcajqui itzintla tepetl nopa tepatlactli catli quihuicayaya imaco huan cuechtic mocajqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Huan quicuic nopa becerro catli quichijtoyaj huan quitlati, huan quitisqui hasta quichijqui tlatixtic. Huan nopa itlatixo quiijtzelo ipan atl, huan quinchihualti nopa israelitame ma quiijica nopa atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Huan Moisés quiilhui Aarón: ―¿Tlaque mitzchihuilijque ni masehualme para tiquinyacantoc ma quichihuaca ni tlajtlacoli nelhueyi? ");
INSERT INTO nhwBl_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Huan Aarón tlananquili: ―Amo xicualani nohuaya, tata. Ta cuali tijmati ni masehualme quinpactía quichihuase catli amo cuali. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Inijuanti nechilhuijque ma niquinchihuili se tlaixcopincayotl para ma techyacanas pampa amo tijmatque tlaque mopantic ta catli techquixti ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Huan na niquinnanquili para sintla quipiyaj tlamantli tlen oro, ma quiquixtica huan inijuanti nechmacaque. Huan nijtlali nopa oro ipan tlitl huan quisqui ni becerro. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Huan Moisés quiitac para nochi quipolojtoyaj ininpinahualis. Huan Aarón quincahuilijtoya ma quichihuaca tlen hueli catli quinequiyayaj quichihuase. Huan quiitac inincualancaitacahua quinhuetzquiliyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Huajca moquetzqui iixmelac campa calaquiyayaj ipan ipejya nopa altepetl tlen ininyoyoncalhua. Huan Moisés quiijto: ―Nochi catli itztoque ica TOTECO ma hualaca nica nohuaya. Huan nochi iixhuihua Leví mosentilijque ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Huajca Moisés quinilhui catli moiyocatlalijtoyaj ica ya: ―TOTECO Dios tlen tiisraelitame quiijtohua para sesen amojuanti monequi xijcuica amomachete, huan xipehuaca ipan nopa achtihui calme huan xipanotiyaca hasta campa ontlami nochi ni yoyoncalme. Huan xicalaquica ipan sesen yoyoncali huan xiquinmijmictijtiyaca masque amoicnihua, amohuampoyohua o amocalnechcahua pampa tlahuel fiero quichijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Huan iixhuihua Leví quichijque quen Moisés tlanahuatijtoya huan ipan nopa tonal mijque nechca eyi mil masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Huajca Moisés quinilhui: ―Ama anmoiyocatlalijque para itequi TOTECO pampa anquineltocatoque catli anmechnahuatijtoc, masque monejqui anquintzontlamiltijque amoconehua huan amoicnihua. Huajca ama TOTECO anmechtiochihuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Huan hualmostla Moisés quinilhui ne sequinoc israelitame: ―Anquichijtoque se hueyi tlajtlacoli. Ama monequi niyas huan nitlejcos campa itztoc TOTECO huan sintla nihuelis nimechixtzacuilis amotlajtlacol. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Huajca Moisés mocuepqui campa itztoya TOTECO, huan quiilhui: ―Melahuac nopa masehualme quichijtoque se hueyi tlajtlacoli huan mochihuilijque se tlaixcopincayotl tlen oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Na nimitztlajtlanía chicahuac xiquintlapojpolhui. Sintla amo, nojquiya techmicti na, huan xiquixpolo notoca ipan nopa amatlapohuali catli tiquijcuilo. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Pero TOTECO quinanquili Moisés: ―San niquixpolos itoca huan nijmictis catli noca tlajtlacolchihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Huajca xiya xiquinhuica nopa masehualme hasta campa nimitzilhui. Huan xijmati para temachtli notequihua mitzyacanas. Pero quema ajsis nopa tonali quema nitetlatzacuiltis, niquintlatzacuiltis ni masehualme por inintlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Huan TOTECO quititlanqui se tlatzacuiltijca cocolistli ipan nopa masehualme pampa quihueyichijque nopa becerro catli Aarón quichijqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Huan TOTECO quiilhui Moisés: ―Xiquisa tlen nica huan xiquinyacana nopa masehualme catli tiquinquixti tlali Egipto, huan xiquinhuica hasta nopa tlali catli niquintencahuili Abraham, Isaac huan Jacob para niquinmacas iniixhuihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Huan nijtitlanis se notequihua ma mitzyacana, huan yaya quinquixtis tlen nopa tlali nopa cananeos, amorreos, heteos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Huan anmechhuicas ipan nopa tlali catli nochi temaca hasta mocahua itlajca. Pero na amo niyas amohuaya, pampa nohueli nimechixpolihuiltis ipan ojtli, pampa tlahuel tetic amoyolo. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","5","Huan TOTECO quiilhui Moisés: ―Xiquinilhui nopa israelitame para inijuanti nelía yoltetique. Xiquinilhui sintla niitztosquía ininhuaya seyoc tlatoctzi, huelis niquintlamiixpolihuiltijtosquía. Huajca xiquinilhui ma moquixtilica nochi nopa tlayejyecchijchijcayotl tlen oro catli quihualicaj quen pactoque, huan niquitas tlaque nijchihuas ica inijuanti. Huan tlahuel miyac motequipachojque nopa israelitame quema quicajque ni camanali catli chicahuac. Huan nochi moquixtilijque ininyejyecchijchijca tlen oro huan ininyoyo catli yejyectzitzi para ma amo nesis quen pactoque, pampa ayacmo paquiyayaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Huajca ipan tepetl Horeb nopa israelitame moquixtilijque ininpijpilolhua, inincoshua, huan nochi catli ica mocualtlaliyayaj para moyecchijchihuase. Huan ayacmo quitequihuijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Huan Moisés ya momajtoya quiiyocaquetza se yoyoncali se quentzi huejca tlen catli ininyoyoncalhua nopa israelitame. Huan quitocaxti nopa yoyoncali campa timopantise ihuaya TOTECO. Huan quema acajya quinequiyaya quitlatzintoquilis TOTECO se tlenijqui para quimatis ipaquilis, yohuiyaya ipan nopa yoyoncali campa mopantis ihuaya TOTECO catli eltoya iyoca tlen ne sequinoc yoyoncalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Huan tlen hueli hora quema Moisés yohuiyaya para mopantiti ihuaya TOTECO, nochi masehualme momatque quisaj ininchajchaj huan moquetzaj ininpuertajteno huan quitlachilíaj Moisés hasta quema oncalaquiyaya ipan nopa yoyoncali. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Huan sesen huelta quema Moisés calaquiyaya ipan nopa cali, nopa mixtli hualtemoyaya huan motlaliyaya ipuertajteno quema TOTECO camanaltiyaya ihuaya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Huajca quema nopa israelitame quiitaque nopa mixtli moquetztoya ipuertajteno nopa yoyoncali, sese inijuanti motlancuaquetzayaya icalixpa huan quihueyichijqui Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Huan TOTECO quicamanalhui Moisés moixtlachiliyayaj quen se catli camanalti ihuaya ihuampox. Huan teipa Moisés mocuepayaya campa ne sequinoc yoyon calme. Pero nopa telpoca tlacatl Josué, itelpoca Nun catli quipalehuiyaya Moisés, mocahuayaya nopona ipan nopa yoyoncali campa mopantíaj ihuaya TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Huan Moisés quiilhui TOTECO: ―Xiquita, techilhuía ma niquinyacana ni israelitame hasta nopa cuali tlali, pero amo techilhuía ajqueya tijtitlanis nohuaya. Nojquiya tiquijtohua para cuali techiximati huan techcualitztoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ama nimitztlajtlanía se favor. Sintla nelía techcualitztoc, techilhui tlaque mopaquilis para nijchihuas huan quej nopa más huelis nimitziximatis. Huan na nimitzneltocas huan noja techcualitztinemis. Huan xiquelnamiqui para ni masehualme catli niquinyacana, nochi timoaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Huan TOTECO quinanquili: ―Na, niamoTECO, niyas mohuaya huan nijchihuas para ximosiyajquetza. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Huan Moisés quiijto: ―Sintla amo tohuaya tiyas, amo techchihua ma tiquisaca tlen nica. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Pampa sintla amo tohuaya tiyas, sequinoc masehualme amo quimatise para techicnelía, na huan ni momasehualhua. Sintla ta amo tohuaya tiyas, huajca san se tiitztose quen tlen hueli masehualme. Pero sintla ta tiyas tohuaya, nesis techtlapejpenijtoc huan techiyocatlalijtoc tlen nochi sequinoc masehualme ipan ni tlaltipactli. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Huan TOTECO quiilhui Moisés: ―Huajca nijchihuas catli tiquijtojtoc pampa nijmati tijchihuas catli cuali, huan ta nimitzitas para tinonelhuampox. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Huajca Moisés quiijto: ―Huajca nimitztlajtlanía, techcahuili ma nimitzitas ta ica nochi motlatlanex catli yejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Huan TOTECO quinanquili: ―Na nijchihuas ma panos moixpa nochi catli cuali tlen na. Huan quema nipanos, niquijtos catli quiijtosnequi notoca, TOTECO. Na nijtlapejpenía catlique nijtlasojtlas huan catlique ihuaya nijpiyas hueyi noyolo. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Pero noixayac amo huelis tiquitas, pampa niyon se masehuali amo huelis quiitas noixayac huan itztos. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Huajca TOTECO quiilhui: ―Nica nonechca eltoc se hueyi tetl, nopona ximoquetza ipani. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Huan na nimitztlalis campa tlacoyontoc ipan nopa hueyi tetl, huan quema nipanos huan nesis notlatlanex nimitzixtzacuas ica nomax hasta ya nipanotos. ");
INSERT INTO nhwBl_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Teipa niquijcuinis nomax, huan huelis tiquitas nocuitlapa, pero noixayac amo tiquitas. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Huan TOTECO quiilhui Moisés: ―Xijtejtequi ome tepatlactli catli san cuali ihuejhuexca quej nopa achtihui tepatlacme catli nimitzmacac. Huan ipani niquijcuilos nopa camanali catli quipixtoya nopa sequin catli tijtlatlapatzqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Nojquiya ximonemili para mostla cualca titlejcos ipan tepetl Sinaí. Xihuala ximonextiqui noixpa itzonatipa nopa tepetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ma amo aqui tlejcos mohuaya huan ma amo aqui más itztos ipan nopa tepetl. Niyon se tlapiyali amo hueli tlacuajcuajtinemis iteno nopa tepetl. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Huajca Moisés quitejtejqui nopa ome tepatlactli san se quej nopa catli achtihui. Huan hualmostla cualca mejqui, huan quicuic nopa ome tepatlactli imaco huan tlejcoc ipan tepetl Sinaí quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Huajca TOTECO temoc ipan se mixtli huan moquetzqui ihuaya Moisés, huan quiyolmelajqui tlaque quinequi quiijtos itoca, TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Huan TOTECO panoc iixpa Moisés huan quiijtojtiyajqui: ―Na niDIOS, moTECO. Na catli nitetlasojtla huan nijpiya hueyi noyolo ica masehualme. Ohui para nicualanis, pampa tlahuel niteicnelía. Huelis timotemachis ipan na pampa senquistoc nitemachtli. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Niquinnextilis tlahuel onpano miyac masehualme quenicatza niquinicnelía, pampa niquintlapojpolhuía inintlajtlacolhua quema nechhuejcamajcahuaj huan nechixpanoj. Pero sintla se acajya tlajtlacolchihua, amo niquijtohua para amo tleno quichijtoc. Nijtlatzacuiltía por itlajtlacol, huan nojquiya niquintlatzacuiltis iconehua, huan iixhuihua, huan hasta iixhuihua ininconehua por nopa catli fiero yaya quichijqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Huajca Moisés nimantzi mohuijtzonqui tlalchi, huan quihueyichijqui TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Huan Moisés quiijto: ―Toteco, sintla ama techcualitztoc, xiya tohuaya huan techyacana, pampa nelía ni masehualme yoltetique. Pero techtlapojpolhui totlaixpanolhua huan totlajtlacolhua, huan techseli para ma tielica timoaxcahua para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Huan TOTECO quinanquili: “¡Cualtitoc! Ya ni nopa camanal sencahuali catli ica nimocahuas amohuaya. Amoixpa nochi annomasehualhua nijchihuas huejhueyi tlanextilijcayotl quen catli amo quema mochijtoc ipan niyon se tlali ipan nochi ni tlaltipactli. Huan quiitase nohueyi chicahualis nochi nopa masehualme catli mohuaya itztoque. Quiitase catli na, niamoTECO, hueli nijchihua pampa temajmati nopa hueyi tlamantli catli nijchihuas ica ta. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Mitztocarohua ta ipan ni camanal sencahuali catli tijchihuaj san sejco para ta xijchihua catli nimitznahuatijtoc ama, huan na amoixpa niquinquixtijtiyas tlen amotlal nopa amorreos, cananeos, heteos, ferezeos, heveos huan jebuseos. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Pero ximomocuitlahuica para amo xijchihuaca niyon se camanali ininhuaya masehualme catli itztoque ipan nopa tlali campa ancalaquise para anitztotij. Sintla anmomatise ininhuaya, anmechtlahuisose ipan tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Pero quena, xijhuelonica nochi nopa tlaixpamitl catli iniaxca, huan xijtlamitlatlapatzaca ininteteyohua. Huan xijtzontequica nopa fiero tlaquetzalme ica nopa tlaixcopincayotl Asera catli inijuanti quinhueyichihuaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Amo quema ximotlancuaquetzaca o xijhueyichihuaca seyoc quen elisquía se dios. Na niamoTECO huan nechtocaxtíaj nopa DIOS CATLI TETLASOMATI, pampa nimechtlasomati huan nijnequi san na techhueyichihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Yeca amo xijchihuaca niyon se camanali ica nopa masehualme catli itztoque ipan nopa tlali. Huan quema inijuanti quinhueyichihuase huan quintencahuilise tlacajcahualistli inintlaixcopincayohua, huan motemacase iniixpa quen tlacanenca sihuame, nojquiya anmechnotzase para xiyaca ininhuaya. Pero nimechilhuía, amo xiyaca. Amo ximomatica ica inijuanti pampa huelis anquinhueyichihuase inintlaixcopincayohua huan anquicuase inintlacajcahualis. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Amotelpocahua amo hueli mosihuajtise ica iniichpocahua pampa nopa ichpocame quinhueyichihuase inintlaixcopincayohua catli amo neli dios huan quinchihualtise amotelpocahua nojquiya san se ma quichihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Amo quema xijchihuaca niyon se tlaixcopincayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Monequi xiilhuichihuaca ipan nopa ilhuitl tlen pantzi catli amo quipiya tlasonejcayotl. Monequi para chicome tonali anquicuase nopa pantzi catli amo quipiya tlasonejcayotl quen nimitznahuatijtoc. Xijchihuaca ni ilhuitl ipan nopa tonal catli nimitzilhui ipan metztli Abib, pampa ipan nopa metztli anquisque tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nochi catli achtihui ehua elis noaxca. Elis noaxcahua nochi iniachtihui oquich conehua amotlapiyalhua, masque amohuacaxhua, amoborregojhua o amochivojhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Pero sintla tlacatis se pilburrojtzi, huelis techcohuilise para anquitequihuise sintla antechmacase se pilborregojtzi. Pero sintla amo antechcohuilise nopa pilburrojtzi, monequi anquiquechpostequise. Nojquiya monequi antechcohuilise amoachtihui oquichpilhua ica se tlacajcahualistli. Huan amo aqui huelis hualas nechitaqui san imax. Monequi nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Xitequitica para chicuasen tonali, pero ipan nopa chicompa tonal, monequi ximosiyajquetzaca. Masque antlapoxoníaj o anpixcaj, monequi anmosiyajquetzase. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Nojquiya xiilhuichihuaca ipan nopa ilhuitl tlen ipejya pixquistli quema achtihui anpehuaj anquipixcase trigo. Nojquiya xiilhuichihuaca ipan nopa ilhuitl tlen itlamiya pixquistli quema nechca itlamiya se xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Eyi huelta ipan se xihuitl monequi nochi tlacame huan oquichpilme ma monextica noixpa, na niamoTECO, niamoDios anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Huan na niquinquixtijtiyas nopa masehualme catli amo nechiximatij ipan nopa tlali amoixpa, huan nijhueyilijtiyas amotlal. Huan quema anyase anmonextitij noixpa na, niamoTECO Dios, eyi huelta ipan se xihuitl, amo aqui huelis quiixtocas o moaxcatis amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Quema antechmacase tlacajcahualistli, amo techmacaca ica niyon se tlamantli catli quipiya tlasonejcayotl. Nojquiya amo huelis anquiajocuise hasta hualmostla niyon quentzi nopa tlacajcahualistli para Pascua. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Nopa catli achtihui tlaquis ipan amomil, huan nopa catli más cuali itlajca monequi anquihuicase ipan nochaj, na niDIOS, niamoTECO. “Amo xijtzoyonica se pilconechivojtzi ipan inana ilechi quen tetlajchihuiani quichihuaj.” ");
INSERT INTO nhwBl_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Huan TOTECO quiilhui Moisés: “Xiquijcuilo ni tlanahuatilme catli nimitzmaca, pampa ica ni tlanahuatilme nijchihuas ni camanali mohuaya huan ininhuaya nopa israelitame.” ");
INSERT INTO nhwBl_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Huan Moisés itztoya ihuaya TOTECO ipan nopa tepetl para 40 tonali huan 40 yohuali. Huan ipan nochi nopa tonali amo tlacuajqui, niyon amo atlic. Huan huajca TOTECO quiijcuilo ipan nopa tepatlacme nochi nopa majtlactli tlanahuatilme catli quintocarohua ma quichihuaca israelitame ipan nopa camanali catli TOTECO quichihuayaya ininhuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Huan Moisés temoc tlen tepetl Sinaí ica nopa ome tepatlactli catli quipixqui nopa tlanahuatilme. Huan petlaniyaya ixayac pampa camanaltitoya ihuaya Toteco Dios, pero yaya amo quimatiyaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Huan quema Aarón huan nochi nopa israelitame quiitaque ixayac Moisés petlaniyaya, tlahuel majmajque huan amo quinejque quinechcahuise. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Huajca Moisés quinnotzqui ma quinechcahuica huan Aarón ica nochi tlayacanani monechcahuicoj huan Moisés quincamanalhui. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Huan teipa monechcahuijque nochi nopa sequinoc israelitame, huan Moisés quinilhui nochi nopa tlanahuatilme catli TOTECO quimacac ipan tepetl Sinaí. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Huan quema Moisés tlanqui quincamanalhuía, moixtzajqui ica se yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Pero sesen huelta quema Moisés calaquiyaya ipan nopa tiopamitl iixpa TOTECO para mocamanalhuis ihuaya, moquixtiliyaya nopa yoyomitl catli ica moixtzacuayaya huan quej nopa mocahuayaya hasta quema quisayaya. Huan quema quisayaya para quinyolmelahuas israelitame catli TOTECO quinnahuatijtoya, ");
INSERT INTO nhwBl_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","nopa israelitame sempa quiitayayaj para petlaniyaya ixayac, huajca Moisés sempa moixtzacuayaya. Huan quej nopa mocahuayaya moixtzactoc hasta sempa oncalaquiyaya para camanaltis ihuaya Toteco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Huan Moisés quinsentili nochi israelitame huan quinilhui: “Ya ni nopa tlanahuatili catli TOTECO quiijtojtoc ma tijchihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Quiijto para huelis titequitise chicuasen tonali, pero nopa chicompa tonal elis para tojuanti se tonal tlatzejtzeloltic, huan ipan nopa tonal monequi ximosiyajquetzase para TOTECO. Sintla acajya tequitis ipan nopa tonal, monequi miquis. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Niyon amo xijtlatica se tlitl ipan amochajchaj ipan tonali para timosiyajquetzase.” ");
INSERT INTO nhwBl_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Huan Moisés quincamanalhui nochi israelitame, huan quinilhui: “Ya ni catli TOTECO tlanahuatijtoc ma tijchihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Nochi amojuanti catli anquinequij anquimacase TOTECO se tlenijqui ica amopaquilis huan ica nochi amoyolo, huelis anquimacase huan tijsentilise nopa tlamantli. Huelis anquihualicase catli anquipiyaj tlen oro, plata o bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Huelis anquihualicase icpatl tlen lino catli tlamalintli nelcanactzi. Xijhualicaca nojquiya icpatl catli tlapali azultic, morado huan chichiltic. Nojquiya xijhualicaca nopa yoyomitl catli tetic quen se cuetlaxtli catli tlaxinepaloli ica oquich chivo iijhuiyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Xijhualicaca inincuetlaxo borregojme huan pesojme catli tlapali chichiltic. Nojquiya xijhualicaca nopa cuahuitl catli itoca acacia, ");
INSERT INTO nhwBl_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","huan oliva aceite para tlahuilme. Nojquiya monequi nopa tlaajhuiyacayotl catli quimanelose ica nopa aceite para quinajaltise tlamantli huan masehualme para quiniyocatlalise para itequi TOTECO. Huan monequi quisencahuase nopa tlaajhuiyacayotl para nopa copali catli ajhuiyac mijyotía. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Nojquiya xijhualicaca nopa piltetzitzi catli yejyectzitzi catli inintoca ónice huan sequinoc piltetzitzi catli yejyectzitzi para tijtlalise ipan nopa ixpantzajcayotl huan nopa yolixpantzajcayotl para nopa hueyi totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“TOTECO tlanahuatijtoc para nochi amojuanti catli anquipiyaj tlalnamiquilistli huan yajatili para anquichihuase se cuali tequitl, xihualaca para anquichihuase nochi ni tequitl catli tlanahuatijtoc TOTECO ma tijchihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Monequi tijsencahuase nopa yoyon tiopamitl ihuaya itzontzajca, itepos chijcolhua, ihuapalhua, icuaixtlapalhua, itlaquetzalo huan itepos cuatetonyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Tijsencahuase nopa caxa ica cuahuitl huehueyac para tijhuicase huan itzajca campa Toteco techtlasojtlas huan nopa cortina catli quitzacuas. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Nojquiya tijchihuase nopa cuamesa huan cuahuitl huehueyac para tijhuicase huan nochi catli motequihuía ica nopa cuamesa, ihuaya nopa pantzi catli tenextilía para TOTECO itztoc tohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Quichihuase nopa tlahuil quetzali catli elis para tlahuili, huan nochi catli motequihuía nopona huan itlahuilhua, huan iaceite. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Quisencahuase nopa tlaixpamitl para copali huan nopa cuahuitl huehueyac catli ica quihuicase. Quisencahuase nopa aceite para titlaiyocatlalise para Toteco huan nopa tlamaneloli copali catli ajhuiyac mijyotía. Nojquiya quisencahuase icortina para tijcuahuiyonise nopa puerta campa calaquise ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Quichihuase nopa tlaixpamitl campa quitlatise tlacajcahualistli ica itlixic ica iteposixtlapalhua. Nojquiya quichihuase nopa cuahuitl huehueyac para ica tijhuicase huan nochi nopa tlamantzitzi catli motequihuis nopona. Huan quichihuase nopa hueyi paila tlen bronce ihuaya catli ipan moquetzas. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Quisencahuase nopa tlatzactli tlen cortina catli quiyahualos nopa calixpamitl. Huan nopa calixpamitl quiyahualos nochi nopa yoyon tiopamitl. Nojquiya quichihuase itlaquetzalhua nopa cortina tlatzactli, huan itepos cuatetonyo sesen nopa tlaquetzali. Nojquiya quichihuase nopa cortinas catli tijcuahuiyonise catli quitzacuas campa ancalaquise ipan calixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Quisencahuase estacas, huan mecatl para moilpis huan motetzilos nopa yoyon tiopamitl, huan nopa tlaquetzali. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Quichihuase nopa yoyomitl catli moquentise totajtzitzi catli tequitise tiopan calijtic. Quena, monequi quisencahuase nopa yoyomitl tlatzejtzeloltic para Aarón, huan nojquiya quichihuase catli moquentise itelpocahua.” ");
INSERT INTO nhwBl_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Huan nochi israelitame motlanantejque campa itztoya Moisés huan yajque ininchajchaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Huan nochi catli quimachilijque para TOTECO quinyoltacani ma quimacaca se tlenijqui huan ipan ininyolo quinequiyayaj quimacase, temacaque. Huan nopa israelitame quihuicaque nochi nopa nemactli para nopa yoyoncali campa mopantise ihuaya TOTECO, huan nochi nopa tlamantzitzi catli monequiyaya para quichihuase nopa tequitl tiopan calijtic. Nojquiya quihualicaque catli monequiyaya para iyoyo tlatzejtzeloltic nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Huan hualajque tlacame huan sihuame catli ica nochi ininyolo quinequiyayaj quimacase se tlenijqui. Huan miyaqui quihualicayayaj tlamantli tlen oro catli quitequihuijtoyaj para moyecchijchihuase. Quihualicaque pijpilolme, anillos, maquechcosme huan tlen hueli tlatectli oro. Huan nochi ni oro quitencahuilijque TOTECO quen se nemactli. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Sequinoc quihuicaque icpatl azultic, morado huan chichiltic huan lino icpatl catli tlamalintli nelcanactzi, huan nojquiya quihualicaque yoyomitl catli tetic quen se cuetlaxtli catli tlaxinepaloli ica iniijhuiyo oquich chivojme. Quihualicaque inincuetlaxo pesojme huan ininpochquiyo borregojme catli tlapali chichiltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Huan nochi catli quinequiyayaj temacase se nemactli tlen plata, o bronce, quihuicaque campa TOTECO. Huan catli quipiyayayaj nopa cuahuitl acacia catli monequi motequihuis ipan ichaj TOTECO, quihualicaque. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Huan miyaqui sihuame catli hueliyaya tlamalinaj cuali huan catli ica nochi ininyolo tequitiyayaj, quihualicaque icpatl catli tlapali azultic, morado huan chichiltic. Nojquiya quihualicaque lino icpatl catli nelcanactzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Huan sequinoc sihuame catli cuali hueliyaya tlamalinaj, quimalinque iniijhuiyo oquich chivojme huan quichijque yoyomitl catli tetic. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Huan nopa tlayacanani quihuicaque piltetzitzi catli itoca ónice huan sequinoc piltetzitzi catli pajpatiyo para quitlatzquiltise ipan nopa ixpantzajcayotl huan yolixpantzajcayotl para nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Huan nojquiya quihualicaque xihuitl catli ajhuiyac mijyotía huan aceite para tlahuili. Nojquiya quihualicaque aceite para nopa tlamaneloli catli tlaajaltise quema tlaiyocatlalise para Toteco, huan nopa copali catli ajhuiyac mijyotía. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Huan nochi israelita sihuame huan tlacame catli quimachilijque ipan ininyolo para hueli quichihuase se tlen nopa tlamantli tequitl catli TOTECO quinahuatijtoya Moisés, quichijque huan quihuicaque catli quisencajtoyaj para ma eli quen se nemactli para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Huan Moisés quinilhui nopa israelitame: “Xiquitaca para TOTECO quitlapejpenijtoc Bezaleel, icone Uri huan iixhui Hur catli tlacatqui ipan nopa hueyi familia tlen iixhuihua Judá, para elis catli tlayacanas ipan nochi ni tequitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Huan Toteco Dios quitlali Itonal ica ihueyi chicahualis ipan Bezaleel para tlayacanas. Huan Toteco quimacatoc tlalnamiquilistli huan yajatili para quimatis miyac tlamantli tequitl para huelis quisencahuas nochi catli monequi, ");
INSERT INTO nhwBl_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","huan para huelis quichihuas tlamantli yejyectzitzi ica oro, plata huan bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Cuali quimati quitequis huan quinalaxos piltetzitzi para cahuanise. Nojquiya quimacatoc para elis se cuali cuaxinquetl catli hueli quitejtequi huan quiyectlalía cuahuitl para quisencahuas catli yejyectzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Nojquiya Toteco Dios quimacac tlalnamiquilistli Bezaleel ihuaya Aholiab para ma quinmachtica sequinoc nochi catli inijuanti quimatij. Aholiab eliyaya icone Ahisamac huan tlacatqui ipan nopa hueyi familia tlen iixhuihua Dan. ");
INSERT INTO nhwBl_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Huan Toteco Dios quinmacatoc nochi ome tlahuel miyac inintlalnamiquilis para ma quichihuaca miyac tlamantli tequitl. Quimatij quenicatza quicualtlalise oro, huan quenicatza cuatequise. Quimatij quenicatza quichihuase yoyomitl yejyectzi tlajtzontli ica icpatl catli tlapali azultic, morado, huan chichiltic, tlaxinepaloli ica lino icpatl nelcanactzi. Quipiyaj yajatili para quichihuase nochi ni tequitl, huan para ma quiyolitica nochi nopa tlamantzitzi catli monequi quichihuase, huan quisencahuase sese ica itlachiyalis catli monequi. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Huajca Bezaleel huan Aholiab huan nochi sequinoc masehualme catli TOTECO quinmacatoya tlalnamiquilistli para ni tequitl, huan quipixque ipan ininyolo para tlapalehuise, monejqui tequitise huan quisencahuase nopa yoyon tiopamitl senquistoc quen TOTECO tlanahuatijtoya.” ");
INSERT INTO nhwBl_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Huajca Moisés quinnotzqui Bezaleel huan Aholiab, huan nochi masehualme catli TOTECO quinmacatoya tlalnamiquilistli huan catli motemacayayaj ica nochi ininyolo para tequitise, huan nochi hualajque. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Huan Moisés quinmactili nochi tlamantli catli nopa israelitame quihualicatoyaj catli monequi quitequihuise ipan nopa yoyon tiopamitl. Huan mojmostla nopa israelitame noja quihualicayayaj nemactli para quitequihuise. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Huajca teipa nochi inijuanti catli quisencahuayayaj tlamantli quiquetzque inintequi, ");
INSERT INTO nhwBl_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","huan quicamanalhuitoj Moisés huan quiilhuijque: “Nochi quihualicatoque tlahuel miyac tlamantli hasta conpano catli monequi para tijchihuase nochi catli TOTECO tlanahuatijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Huajca Moisés tlanahuati ma quinyolmelahuatij nochi israelitame ipan ininchajchaj para niyon se tlacatl o sihuatl ayacmo ma quisencahua seyoc tlamantli para nopa tiopamitl, niyon ayacmo ma tlahuajhualicaca. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Pampa ya quipixtoyaj tlahuel miyac catli quitequihuise huan hasta miyac mocahuayaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Huan nopa masehualme catli Toteco quinmacatoya tlalnamiquilistli para ma tequitica nopona, quichijque itzontzajca nopa tiopamitl. Quichijque ica 10 cortinas ica lino tlamalintli nelcanactzi huan tlaxinepaloli ica icpatl catli tlapali azultic, morado, huan chichiltic huan ipani nesiyaya inintlachiyalis nopa tequihuajme catli inintoca querubines. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Huan sesen nopa cortinas eliyaya 12 metros huan tlajco ihuehueyaca, huan ome metro ipatlajca. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Huan quisalojque itlamiya se cortina ica itlamiya seyoc nopa macuili cortinas para mochijqui san se cortina catli huehueyac. Huan nopa seyoc macuili cortinas nojquiya quiijtzonque para mochijqui san se cortina catli huehueyac huan nopa ome cortinas huehueyac elqui para sesen lado itzontzajca nopa tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Huan ipan se iteno sesen nopa ome huehueyac cortinas catli quimojmotzquiltijtoyaj, quichihuilijque tlailpili ica iojal campa mosojsos, huan quitenyahualojque sese iojal ica icpatl azultic. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Para nochi quichihuilijque 50 tlailpili sese ica iojal para mosojsos ipan se lado nopa ome huehueyac cortinas catli achtihui tlasaloli. Huan teipa quinchijque nopa tlailpili ipan sese para ma moixnamictica ica nopa tlailpili ipan seyoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Nojquiya quichijque 50 tepos chijcoli tlen oro para quisalos nopa 50 tlailpili ipan sesen nopa ome cortinas tlasaloli. Quej nopa quisencajque para quitzacuas huejcapa ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nojquiya quisencajque 11 cortinas tlen nopa tetic yoyomitl catli tlaxinepaloli ica iniijhuiyo oquich chivojme para quisencajque iompa tzontzajca nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Huan sesen cortina ihuehueyaca eliyaya 13 metros huan tlajco, huan ome metro ipatlajca, huan nochi 11 cortinas quipixqui san se ininhuejhuexca. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Huan quisalojque macuili cortinas san sejco huan iyoca quisalojque seyoc chicuase cortinas. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Huan iteno se lado sesen nopa ome huehueyac cortinas quichihuilijque 50 tlailpili ica iniojales campa mosojsos. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nojquiya quichihuilijque 50 tepos chijcoli tlen bronce para ipan quisalose iniojales nopa tlailpili ipan se cortina ica nopa tlailpili ipan seyoc cortina para iompa tzontzajca nopa yoyon tiopamitl elis tlasaloli san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Huan nopa expa itzontzajca quichijque ica inincuetlaxo oquich chivojme catli quipajque chichiltic, huan nopa najpa itzontzajca catli elqui más calixco quichijque ica inincuetlaxo pesojme. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Huan para icaltepanyo nopa tiopamitl quiquejquetzque nopa huapalme tlen cuahuitl acacia. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Huan sese huapali quipixqui nahui metros huan tlajco ihuehueyaca, huan 65 centímetros ipatlajca. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Sese huapali quipixqui ome tepos chijcoli para quisalos ica ne sequinoc huapalme ipan sesen lado. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Huan moquetzayayaj 20 huapalme ipan nopa caltechtli ica sur. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Huan itzintla sesen nopa huapalme calaquiyayaj ipan ome itepos cuatetonyo tlen plata para ma moquetzas cuali. Oncayaya 40 tepos cuatetomitl, ome cuatetomitl ipan sese huapali. Huan sesen huapali quipixtoya ome tepos chijcoli para quitlatzquiltis ipan itepos cuatetonyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Ipan nopa caltechtli ica norte oncayaya seyoc 20 huapalme, ");
INSERT INTO nhwBl_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","huan 20 itepos cuatetonyo. Itzintla sese huapali oncayaya ome itepos cuatetonyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Iica nopa tiopamitl ipan nopa lado campa temo tonati quipixqui chicuase huapalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Huan quitlalilijque seyoc huapali iica tiopamitl campa sese icalnacastla. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Huan quen nochi más huapalme, nopa huapalme campa inincalnacastla quipixque tepos chijcoli ica tlatzintla huan ica huejcapa para quisojsos ica nopa huapalme catli inechca. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Huajca campa temo tonati oncayaya chicueyi huapalme huan 16 tepos cuatetomitl catli ipan moquetzayayaj, ome cuatetomitl tlatzintla sesen huapali. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Quisencajque cuaixtlapali huejhuehueyac tlen cuahuitl acacia huan quitlalijque iixpa nopa huapalme ipan nopa caltechtli catli quiyahualojque nopa tiopamitl. Quichijque macuili cuaixtlapali para iixpa nopa huapalme ipan se lado nopa tiopamitl, ");
INSERT INTO nhwBl_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","huan seyoc macuili cuaixtlapali para iixpa nopa huapalme ipan ne seyoc lado, huan seyoc macuili cuaixtlapali para iixpa huapalme catli moquetzque iica nopa tiopamitl ica campa temo tonati. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Huan nopa cuaixtlapali catli panoc tlatlajco iixtlapal nopa huapalme catli moquetztoyaj pejque ica se icalnacastla tiopamitl huan ajsic hasta seyoc icalnacastla nopa tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Huan quixajque nopa huapalme ica oro, huan nopa anillos campa calaquiyayaj nopa cuaixtlapalme elqui senquistoc oro. Nojquiya quixajque ica oro nopa cuaixtlapalme catli huejhuehueyac. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Huan nopa cortina catli quitzajqui nopa cuarto catli más calijtic quichijque ica lino catli tlamalintli nelcanactzi huan tlaxinepaloli ica icpatl catli quipajtoyaj azultic, morado huan chichiltic. Huan ipan nopa tlaxinepaloli nesiyayaj ome tequihuajme catli inintoca querubines. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Huan para ipan mohuiyonis nopa cortina quichijque nahui tlaquetzali ica cuahuitl acacia huan quinxajqui ica oro. Huan ipan nopa tlaquetzali quitlalijque tepos chijcoli tlen oro. Huan sesen nopa nahui tlaquetzalme moquetzayaya ipan inincuatetonyo tlen plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Nojquiya quichijque se cortina para quitzacuase campa calaquise ipan yoyon tiopamitl. Quichijque ica lino nelcanactzi catli tlaxinepaloli ica icpatl azultic, morado, huan chichiltic huan quiijtzonque yejyectzi ica itlachijchihualo. ");
INSERT INTO nhwBl_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Huan ni cortina tlatzquitoya ipan macuili tlaquetzali ica macuili tepos chijcoli. Huan inintzonatipa nopa macuili tlaquetzali huan tepos chijcoli quixajque ica oro, huan nopa macuili icuatetonyo catli ipan moquetzqui nopa tlaquetzali quichijque ica bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Huan teipa Bezaleel quisencajqui nopa caxa ica cuahuitl acacia huan quipixqui 110 centímetros ihuehueyaca, huan 65 centímetros ipatlajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Iijtic huan ipani quixajqui ica senquistoc oro, huan yahualtic quipixtoya itejteno tlen oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Huan quichihuili nahui anillos tlen oro huan quitlalili najcac ipan inacastla. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Nojquiya quisencajqui cuahuitl huehueyac huan quixajqui ica oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Huan ipan nopa anillos quicalaqui nopa cuahuitl huehueyac para quej nopa huelis quihuicase nopa caxa. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Teipa quichijqui itzajca nopa caxa campa Toteco quintlasojtlas masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Nojquiya iixco itzajca quisencahuili ome itequihuajcahua Toteco catli inintoca querubines catli tlatejtzontli ica martillo. Huan nopa tequihuajme huan itzajca nopa caxa elqui san se tlatectli oro. Huan nopa tequihuajme moquetztoyaj ipan sese iteno itzajca. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Se itequihua Toteco moquetztoc ipan se iteno huan ne seyoc ipan seyoc iteno. Nopa querubines huan itzajca nopa caxa elqui san se tlatectli oro tlatejtzontli. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Nopa tequihuajme moixnamictoyaj huan moeltlapal tlanantoyaj quen quiecahuiliyayaj huan quitlachiliyayaj itzajca nopa caxa campa TOTECO quintlasojtlas masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Nojquiya quisencajqui nopa cuamesa ica cuahuitl acacia. Huan quipixtoya ihuehueyaca 90 centímetros, huan 45 centímetros ipatlajca, huan 65 centímetros ihuejcapanca. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Huan quixajqui ica senquistoc oro. Huan quichihuilijque nopa cuamesa se icorona tlen oro catli quitenyahualo iixco. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Nojquiya quitenyahualo iixco nopa cuamesa ica se pilhuapaltzi catli quipiya san chicome centímetros ipatlajca. Huan yahualtic quitejtequi para quichihuili iyejyejca huan quixajqui nochi ica senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Huan quichihuili nahui anillos tlen oro, huan quitlali najcac ipan inacastla nopa cuamesa campa pehua iicxihua iquespa nopa mesa. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nopa anillos eltoya huejcapa ipan iicxi nechca nopa pilhuapaltzi catli quitentzajqui nopa cuamesa. Huan quisencajqui cuahuitl huehueyac huan quicalaqui ipan nopa anillos ipan nopa cuamesa para quej nopa huelis quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Huan para quichihuas nopa cuahuitl huehueyac para ica quihuicase nopa cuamesa quitequihui cuahuitl acacia, huan quixajqui ica oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Nojquiya quisencajqui catli quitequihuise ipan cuamesa quen platome, huejhueyi cucharas, teposhuitzcucharas huan huejhueyi xarros para tlacajcahualistli catli atic. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Nojquiya quisencajqui se tlahuil quetzali catli senquistoc oro. Iicxi, icuayo, ipilcaxitzitzi, ixochiyo mimilijtoc huan cahuantoc huan nochi iyejca quisencahuili ica san se tlatectli oro catli tlatejtzonali ica martillo. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Huan quipixtoya chicuase imacuayohua; eyi imacuayohua ipan se lado, huan ne se eyi ipan seyoc lado. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ipan sese imacuayo quipixqui eyi pilcaxitzitzi catli ipan tlatlatise huan quipixqui itlachiyalis quen se almendra ixochiyo catli mimilijtoc huan se catli cahuantoc. Huan ipan nochi nopa chicuase imacuayohua quej nopa eliyaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Huan ipan icuayo nopa tlahuil quetzali quipiyayaya nahui pilcaxitzitzi, sese ica itlachiyalis se xochitl almendra, se nesiyaya se xochitl mimilijtoc huan se quen se xochitl cahuantoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Huan itzintla tlen sesen nopa chicuase imacuayohua catli tlatzquitoyaj ipan icuayo nopa tlahuil quetzali quipiyayaya se xochitl cahuantoc. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Huan nochi ixochiyohua huan imacuayohua huan icuayo eliyaya san se tlatectli oro huan tlatejtejtzontli ica martillo. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Nojquiya quichihuili chicome piltlahuiltzitzi, huan nopa cucharas catli ica quisehuijque nopa tlahuilme, huan quichihuilijque iplatohua. Huan nochi quisencajque ica senquistoc oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Huan nopa tlahuil quetzali tlen oro quipixqui 33 kilos ietica. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Nojquiya quichijqui se tlaixpamitl campa quitlatise copali huan elqui cuadradojtic, ica 45 centímetros ihuehueyaca huan ipatlajca, huan quipiyayaya icuacua ipan nochi nahui inacastla, huan nochi san eliyaya se tlatectli cuahuitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Huan quixajqui ica senquistoc oro nochi itzontzajca, huan iquespa, huan icuacua. Huan yahualtic iixco quiquetzqui se icorona tlen oro catli quiyectlali. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Huan nojquiya quichihuili nahui anillos itlaj nopa nahui iesquinajyo, huan nopona quicalaqui nopa cuahuitl huehueyac para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Huan nopa cuahuitl huehueyac quisencajqui ica cuahuitl acacia, huan quixajqui ica oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nojquiya quisencajqui nopa aceite catli tlatzejtzeloltic para tlaiyocatlalise para Toteco, huan quisencajqui nopa copali catli ajhuiyac mijyotía. Nochi quisencajqui Bezaleel, se tlaajhuiyacasencajquetl catli achi más quimatqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Huan nojquiya ica cuahuitl acacia quisencajqui se tlaixpamitl catli cuadradojtic iixco campa quitlatise tlacajcahualistli. Quipixqui 2 metros 25 centímetros ihuehueyaca huan ipatlajca. Huan ihuejcapanca eltoya 1 metro 25 centímetros. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Huan ipan najcac inacastla quisencahuili icuacua. Huan quisencajqui ica san se tlatectli cuahuitl huan quixajqui ica nopa tepostli bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Huan quisencahuili nochi catli monequi quitequihuise ipan nopa tlaixpamitl quen nopa tepos caja catli ipan quitemase cuanextli, nopa huajcalme para quiselise estli, huan nopa tepos chijcoli para ica quiitzquise nopa nacatl, huan palas para ica quiquixtise cuanextli, huan nopa tepostli para tlicoli. Huan nochi quisencajqui ica bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Huan ica bronce quisencahuili se tlixictli ica ipiltepos ixtlapalhua para iixco huelis motecas nopa tlacajcahualistli catli quitlatíaj. Huan quisehui nopa tlixictli ipan tlajco ihuejcapanca iijtico nopa tlaixpamitl campa quipixqui se itencuayo. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Huan nojquiya najcac campa inacastla quichihuili nahui anillos para ipan quicalaquise nopa cuahuitl huehueyac para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Huan quisencajqui nopa cuahuitl huehueyac ica cuahuitl acacia huan teipa quixajqui ica bronce. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Huan quicalaqui nopa huehueyac cuame ipan nopa anillos catli eltoya iquespa nopa tlaixpamitl para huelis quihuicase. Huan quichijqui nopa tlaixpamitl ica huapalme huan iijtico mocajqui cacahuatic. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Huan quichijqui ica bronce nopa hueyi paila tlen bronce para atl huan nopa catli ipan moquetza. Quichijque ica miyac tescatl tlen bronce catli sihuame quimatque quitequihuíaj, pampa sihuame catli tlatequipanojque campa ipuerta nopa yoyon tiopamitl quihualicaque inintesca huan temacaque. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Teipa Bezaleel quisencajqui se calixpamitl catli quiyahualo nochi nopa yoyon tiopamitl. Huan tzactoya nopa calixpamitl ica cortinas quen se tepamitl. Huan nopa cortinas catli quitzajqui nopa calixpamitl ica sur quipixqui 45 metros ihuehueyaca. Huan quichijqui nopa cortinas tlaxinepaloli ica icpatl tlen lino nelía canactzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Huan ica sur tlatzquitoyaj nopa cortinas ipan 20 tlaquetzalme ica 20 inincuatetonyo tlen bronce huan inintepos chijcolhua huan inianillos tlen plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Huan ica norte nopa cortinas catli mochijqui nopa tlatzactli quipixqui 45 metros ihuehueyaca, huan tlatzquitoyaj ipan 20 tlaquetzalme, huan 20 inincuatetonyo tlen bronce ica inintepos chijcolhua huan inianillos tlen plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Huan campa temo tonati nopa cortinas catli quitzajqui nopa lado quipixqui 22 metros huan tlajco ihuehueyaca, huan quipixqui 10 tlaquetzali, huan 10 cuatetomitl para ipan tlatzquise. Huan nopa tlaquetzali, huan inintepos chijcolhua huan inianillos nochi elqui tlen plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Huan ica campa hualquisa tonati nopa cortinas catli quitzajqui nopa lado quipixqui 22 metros huan tlajco. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Huan tlatlajco nopa tlatzactli campa hualquisa tonati mocajqui tlapojtoc quen puerta para calaquise ipan calixpamitl. Huan ipan se lado campa calaquise eltoya se cortina catli quipixqui 7 metros ihuehueyaca, huan eyi tlaquetzali sese ica icuatetonyo para ipan tlatzquijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Huan ipan ne se lado tlen campa calaquiyayaj nojquiya eltoya se cortina catli 7 metros ihuehueyaca, huan 3 tlaquetzali huan sesen ica icuatetonyo para ipan tlatzquijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Huan nochi nopa cortinas catli mochijqui nopa tlatzactli catli eltoya yahualtic nopa calixpamitl mochijtoya ica yoyomitl tlaxinepaloli tlen lino icpatl catli nelía canactzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Huan icuatetonyo sesen tlaquetzali eliyaya tlen bronce, huan itepos chijcolhua huan ianillos eliyaya tlen plata. Huan itzonixco sesen tlaquetzali quixajqui ica plata. Huan nochi nopa tepos barras para ipan quicuapilose nopa cortinas eliyaya tlen plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Huan campa nopa cortina catli quitzacuayaya campa calaquij ipan nopa calixpamitl elqui tlaxinepaloli ica lino icpatl catli nelcanactzi huan icpatl catli azultic, morado huan chichiltic. Eltoya itequi se catli achi más quimatqui tlaxinepalohua. Huan nopa cortina eliyaya 9 metros ihuehueyaca huan 2 metros 25 centímetros ihuejcapanca san se quej ne sequinoc cortinas catli quiyahualojque nopa calixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Huan campa calaquiyayaj quipixqui 4 tlaquetzalme, sese ica icuatetonyo tlen bronce para ipan moquetzas. Huan itepos chijcolhua huan ianillos nopa tlaquetzalme eliyaya tlen plata huan itzonixco sesen tlaquetzali nojquiya quixajqui ica plata. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Huan nochi estacas eltoya tlen nopa tepostli bronce huan quitequihui para quiilpis huan quitetzilos nopa tiopamitl. Huan nopa cortina tlatzactli quiyahualo nopa calixpamitl. Huan nopa calixpamitl quiyahualo nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Huan ya ni nopa cuenta tlen nopa yoyon tiopamitl para elis ichaj nopa caxa ica itlanahuatil TOTECO. Huan quichijque nochi quen Moisés tlanahuatijtoya. Huan Itamar, icone totajtzi Aarón, tlayacanqui para quiitztiyas sesen tequitl. Huan nopa levitame quiijcuilojque quesqui imiyaca sesen tlamantli quitequihuijtoyaj para quichihuase nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Huan Bezaleel, icone Uri huan iixhui Hur ipan nopa hueyi familia Judá, tlayacanqui para quichihuas iixcopinca sesen tlamantli senquistoc quen TOTECO quinahuati Moisés ma quisencahua. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Huan quipalehui Aholiab, icone Ahisamac, catli tlacatqui ipan nopa hueyi familia Dan. Huan Aholiab eltoya se tepos tejtzonquetl para tlayejyectlalis, huan se cuali tlaxinepalojquetl ica icpatl. Huan quimatqui quichihuas yejyectzi yoyomitl catli quipixqui itlajtzonyo ica lino icpatl catli canactzi huan icpatl catli azultic, morado huan chichiltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nochi oro catli motequihui para nochi tlamantli ipan nopa tiopamitl eltoya oro catli israelitame quimacatoyaj TOTECO. Huan ietica quipano 965 kilos quej nopa tlatamachihuali catli quitequihuijque ipan nopa tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Huan imiyaca plata catli quitequihuijque panoc 3 mil 319 kilos. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Nochi ni plata elqui catli quininanque nopa 603 mil 550 tlacame catli moijcuilojque ipan nopa censo pampa ya quiaxitijque 20 xihuitl. Sesen inijuanti temacaque macuili gramos tlen plata quema moijcuilojque. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Quitequihuijque 3 mil 300 kilos tlen plata para inincuatetonyo icaltepanyo tiopamitl huan nopa tlaquetzalme para cortinas campa calaquise. Ica ni plata quichijque icuatetonyo 100 tlaquetzalme. Elqui nechca 33 kilos tlen plata catli quitequihui ipan icuatetonyo sesen tlaquetzali. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Huan nopa plata catli mocajqui, quitequihuijque para itepos chijcolhua, ianillos, huan para itzonixco sesen nopa tlaquetzalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Huan nopa bronce catli nopa israelitame quimacaque TOTECO quipano 2 mil 336 kilos ietica. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Huan ica nopa bronce quichijque icuatetonyo nopa tlaquetzalme catli quitlaquechijque nopa cortinas campa calaquij ipan calixpamitl. Huan quichijque nopa tlaixpamitl tlen bronce para ipan quitlatise tlacajcahualistli, huan quichijqui itlixic ica ipilteposixtlapalhua tlen bronce catli ipan quitejque nopa tlapiyali para quitlatise. Huan nojquiya ica ni bronce quichijqui nochi nopa tlamantzitzi catli monequiyaya campa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Nojquiya quitequihui bronce para nopa cuatetomitl para tlaquetzalme catli quitlaquechi nopa cortinas catli quitzajqui nopa calixpamitl huan nopa cortinas campa calaquij ipan calixpamitl. Huan quitequihui bronce para iestacas para quiilpis huan quitetzilos nopa tiopamitl huan nochi nopa tlaquetzalme. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nojquiya ininyoyo nopa totajtzitzi catli quitequihuise quema tequitise tiopan calijtic quixinepalojque ica icpatl azultic, morado huan chichiltic. Huan quisencajque iyoyo Aarón catli tlatzejtzeloltic quen TOTECO quinahuatijtoya Moisés. Huan ni yoyomitl quitequihuía san quema calaqui ipan tiopamitl campa tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Nojquiya quisencajque ipantzajcayo tlaxinepaloli ica icpatl tlen oro catli azultic, morado, huan chichiltic huan lino icpatl catli nelía canactzi. Huan nochi elqui nelía cuali tlasencahuali. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Quicuique se tlatectli oro, huan quitejtzonque hasta quichijque se piltepos mecatzi catli nelía canactzi quen icpatl. Huan nopa piltepos mecatzi tlen oro quixinepalojque ihuaya lino icpatl catli canactzi huan icpatl catli azultic, morado huan chichiltic. Huan elqui itequi se catli nelía quimatqui tequiti huan nelía yejyectzi mocajqui. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Huan nopa ixpantzajcayotl elqui ome tlatectli yoyomitl. Huan nojquiya quichijqui seyoc tlatectli para iajcolpa campa moixnamiquiyaya iyolixco huan icuitlapa. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Nojquiya nopa itzinquechilpica catli yejyectzi elqui tlasencahuali ica san se nopa yoyomitl catli quitequihuijque ipan nopa ixpantzajcayotl. Nochi eltoya tlen nopa piltepos mecatzi tlen oro tlaxinepaloli ica lino icpatl nelía canactzi huan ica icpatl azultic, morado huan chichiltic. Nochi eltoya quen TOTECO quiilhui Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Huan quisencajque piltetzitzi catli yejyectzi itoca ónice huan quitlali ipan oro. Huan ipani quiijcuilojque inintoca nochi itelpocahua Israel quen se sello catli quipiya tlajcuiloli catli nesi. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Huan quitlalili iajcolpa nopa ixpantzajcayotl para ica quinelnamiquiltis TOTECO tlen itelpocahua Israel. Huan nochi quichijque quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Huan nojquiya se catli tlahuel quimatqui, quisencajqui nopa yolixpantzajcayotl quen nopa pantzajcayotl. Quixinepalo nopa icpatl tlen oro, lino icpatl ihuaya icpatl catli azultic, morado huan chichiltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Huan quicuelpacho nopa yolixpantzajcayotl huan quichijqui se bolsa catli cuadradojtic. Ihuehueyaca huan ipatlajca eltoya 22 centímetros. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Huan iyolixpa oncayaya nahui tlatilimitl tlen piltetzitzi catli yejyectzitzi. Ipan nopa achtihui pamitl quitlatzquiltilijque se piltetzi catli itoca rubí, se topacio huan se sardónice. Ya ni elqui nopa achtihui tlatilimitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Huan ipan nopa ompa tlatilimitl quitlalilijtoya se esmeralda, se zafiro huan se diamante. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Huan ipan nopa expa tlatilimitl quitlatzquiltijque se jacinto, se ágata huan se amatista. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Huan ipan nopa najpa tlatilimitl quitlatzquiltijque se berilo, se ónice huan se jaspe. Huan mocajqui nochi ni piltetzitzi tlatzquitoque ipan ininpiltencuayohua tlen oro catli mocahua inintejteno huan catli quiyecchijtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Huan imiyaca nopa piltetzitzi elqui 12 quen ininmiyaca itelpocahua Israel. Huan sese elqui quen se pilsellojtzi catli quichihua itoca se itelpoca Israel. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nojquiya quisencajque para nopa yolixpantzajcayotl ipiltlajco ilpicayotzitzi catli tlaxinepaloli tlen oro. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Huan quichihuili nopa yolixpantzajcayotl ome anillos tlen oro oncac ipan inacastla catli huejcapa huan nopona quicalaqui nopa piltlajco ilpicayotl huan quitlatzquiltili nopa yolixpantzajcayotl ica catli eltoc iajcoltipa ipan nopa ixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Huan quitlatzquiltijque oncac nopa ome piltlajco ilpicayotzitzi tlen oro catli yejyectzitzi tlaxinepaloli ipan inacas huejcapa ipan nopa yolixpantzajcayotl. Huan teipa seyoc iteno nopa piltlajco ilpicayotzitzi quitlatzquilti ipan sese anillo iajcolpa ipan nopa ixpantzajcayotl ");
INSERT INTO nhwBl_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Huan quitlalijque ni ome ipiltlajco ilpicayotzitzi tlen oro catli tlayecchihuali oncac, se ipan sesen nopa ome anillos catli eltoc iajcolpa huan ica quitlatzquiltilijque iyolixpa nopa yolixpantzajcayotl ica iajcolpa nopa ixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Huan quichijque seyoc ome anillos tlen oro catli quitlatzquiltilijque ipan sese iquespa ipan itejteno nopa yolixpantzajcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Nojquiya quichijque ome anillos tlen oro catli quitlatzquiltijque tlatzintla ipan catli elqui iajcoltipa huan teipa quisalojque seyoc iteno ihuaya itzinquechilpica. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Huan quinechicojque nopa yolixpantzajcayotl ica nopa ixpantzajcayotl huan quiilpijque ica se listón azultic para ma motlali cuali ipan nopa ixpantzajcayotl itzinquechilpica para nochipa san sejco tlatzquitose nopa yolixpantzajcayotl ica nopa ixpantzajcayotl huan amo papatlacas. Huan nochi quichijqui senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Huan nojquiya quichihuili nopa totajtzi iyoyo catli huehueyac catli mocajqui itzala nopa ixpantzajcayotl, huan quichijqui nochi ica yoyomitl azultic. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Huan quiquechtejqui campa calaquis itzonteco huan quiyahualojque campa quiquechtectoya ica se yejyectzi tlajtzontli catli tlayahualoli para ma amo tzayani. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Huan ipan itejteno iyoyo huehueyac quichihuili se tlajtzontli catli quiixcopinqui nopa cuatlactli itoca granada. Quiixcopinqui quema quixinepalo lino icpatl huan icpatl azultic, morado huan chichiltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Nojquiya quichihuilijque pilcampanajtzitzi catli senquistoc oro, huan quiilpijque tlatlajco nopa granadas. Huan quej nopa yajtiyajqui ipan nochi itejteno iyoyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Quipixqui se pilcampanajtzi huan se granada, seyoc pilcampanajtzi huan seyoc granada ipan nochi itejteno icuex iyoyo huehueyac. Huan nopa totajtzi motlalili nopa yoyomitl quema quitequipano TOTECO tiopan calijtic. Huan nochi quichijque senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Huan para Aarón huan itelpocahua quinchihuilijque inintlatzintlanyoyo ica yoyomitl tlen lino catli nelcanactzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Nojquiya quixinepalojque nopa cuatzajcayotl ica icpatl tlen lino catli nelcuali, huan quiyectlalijque nopa yoyomitl para inincuajtol ica icpatl tlen lino catli nelía cuali, huan quichijque inintlatzintlanyoyo nojquiya ica icpatl tlamalintli tlen lino huan nelía canactzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Nojquiya quisencajque inintzinquechilpicayo ica lino icpatl nelcanactzi huan icpatl catli azultic, morado huan chichiltic. Huan quichijque yejyectzi itlajtzonyo senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Nojquiya quichijqui se piltlatectzi tlen oro para quitlalis ipan icuatzajca huan ipani tlajcuilojque quen se sello catli quiijto: TLAIYOCATLALILI PARA TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Huan quiilpilijque ica se icpatl azultic huan quitlalijque iixpa nopa cuatzajcayotl senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Huan quej ni tlanqui nochi nopa tequitl catli quichihuayayaj para quisencahuase nopa yoyon tiopamitl campa mopantise ihuaya TOTECO. Huan nochi quisencajque nopa israelitame senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Huan nochi nopa tiopamitl ica nochi tlamantli catli quisencajtoya quihualiquilijque Moisés. Quihualiquilijque nopa yoyoncali catli quichijtoya ica nopa tetic yoyomitl catli tlaxinepaloli ica iniijhuiyo oquich chivojme. Quihualicaque nopa cuamesas, tepos chijcolme, huapalme, cuaixtlapalme, tlaquetzalme huan icuatetonyo. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Quihualiquilijque itzontzajca catli quichijtoyaj ica inincuetlaxo oquich borregojme catli quipajtoya chichiltic, huan itzontzajca catli quisencajtoya ica inincuetlaxo pesojme huan nojquiya nopa cortinas tlen ica quitzacuas nopa cuarto catli quipixqui nopa caxa. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Quihualicaque nopa caxa huan cuahuitl huehueyac para ica quihuicase, huan itzajca, ");
INSERT INTO nhwBl_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","huan nopa cuamesa ica nochi catli motequihuis ipani, huan nopa pantzi catli quitlalía ipan nopa mesa para tenextilis Toteco itztoc tohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Nojquiya quihualicaque nopa tlahuil quetzali tlen oro ica nochi itlahuilhua catli quitlalijtoya sesen campa monequiyaya huan nojquiya quihualicaque nochi nopa tlamantzitzi catli monequi quitequihuise ica nopa tlahuil quetzali ihuaya nopa aceite catli quitequilise para ma tlatla. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Huan quihualicaque nopa tlaixpamitl tlen oro, ihuaya nopa copali catli ajhuiyac huan nopa aceite para tlaiyocatlalise, huan nopa cortina para quicuapilose campa calaquise. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Quihualicaque nopa tlaixpamitl tlen bronce huan nochi catli nopona motequihuía. Nojquiya quihualicaque itlixicyo tlen bronce huan nopa cuahuitl huehueyac para ica quihuicase. Huan nochi quixajtoyaj ica bronce. Nojquiya quihualicaque nopa hueyi paila huan icuayo catli ipan ma momajtequica totajtzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Quihualicaque nopa cortinas catli mochihuas itzajca nopa calixpamitl, ihuaya itlaquetzalo huan itepos cuatetonyo. Nojquiya quihualicaque nopa cortinas para campa puerta campa calaquise ipan calixpamitl, huan nopa mecatl huan estacas para quiilpise huan quitetzilose sesen tlaquetzali, huan nochi tlamantli catli motequihuis tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Nojquiya quihuiquilijque Moisés para ma quiita iyejyejca ininyoyo nopa totajtzitzi catli moquentise quema calaquise para tequitise tiopan calijtic Campa Tlatzejtzeloltic. Quihualiquilijque nopa yoyomitl catli tlatzejtzeloltic para nopa hueyi totajtzi Aarón, ihuaya nopa yoyomitl para itelpocahua quema quichihuase inintequi tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Huan nopa israelitame quichijque nochi senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Huan quema Moisés quitlachili nochi catli quichijtoya, quiitac para quisencajtoyaj senquistoc quen TOTECO tlanahuatijtoya, huan quintiochijqui nochi inijuanti catli quisencajtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Xijquetza nopa yoyon tiopamitl campa timopantise ipan nopa achtihui tonal ipan nopa achtihui metztli ipan nopa yancuic xihuitl ipan amocalendario. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Huan ipan nopa yoyon tiopamitl ipan nopa cuarto más calijtic, xijtlali nopa caxa, huan xijtzacua campa calaquise ipan nopa cuarto ica nopa cortina. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Huan ipan nopa seyoc cuarto catli amo más calijtic, xijcalaqui nopa cuamesa para pantzi huan xijtlali campa monequi. Teipa xijcalaqui nopa tlahuil quetzali huan xijtlati. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Huan nojquiya ipan nopa cuarto catli amo más calijtic, xijtlali nopa tlaixpamitl tlen oro campa quitlatise copali huan nopa tlaixpamitl tlen copali mocahuas iixmelac nopa caxa catli eltoc ipan nopa cuarto más calijtic. Huan xijcuapilo seyoc cortina campa calaquise ipan nopa achtihui cuarto catli amo más calijtic huan ni cortina elis iixmelac nopa tlaixpamitl tlen oro huan quitzacuas campa calaquise ipan nopa cuarto catli amo más calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Huan ipan nopa calixpamitl, xijtlali nopa tlaixpamitl campa quitlatise tlacajcahualistli. Huan moquetzas iixmelac nopa cortina campa calaquise ipan nopa cuarto catli amo más calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Teipa tlatlajco nopa yoyon tiopamitl huan nopa tlaixpamitl, xijtlali nopa hueyi paila catli quitequilise atl para momajtequise. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Huan teipa xijquetza nopa tlatzactli tlen cortinas para xijchihua icalixpanyo yahualtic nopa yoyon tiopamitl. Huan catli campa calaquise ipan calixpamitl, xijcuapilo nopa seyoc cortina. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Huan xijcui nopa aceite catli tlaajaltise para tlaiyocatlalise para TOTECO. Huan xiquijtzelhuili nopa yoyon tiopamitl huan nochi cuamesas catli eltoc ipani. Xiquijtzelhuili nochi catli quitequihuise nopona. Huan nochi mocahuas tlatzejtzeloltic, tlaiyocatlalili para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Teipa xiquijtzelhuili nopa tlaixpamitl campa quitlatise tlacajcahualistli huan nochi catli motequihuía ihuaya. Huan quej nopa moiyocatlalijtos nopa tlaixpamitl huan elis tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nojquiya xiquijtzelhuili nopa hueyi paila campa momajtequise huan icuayo tlen bronce huan quej nopa tiquiyocatlalis huan tijchihuas tlatzejtzeloltic para na. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Huan xijhuica Aarón ihuaya itelpocahua ipan nopa calixpamitl hasta iixmelac campa calaquise ipan nopa yoyon tiopamitl campa timopantise, huan nopona ma maltica ica atl. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Huan xijyoyonti Aarón ica nopa yoyomitl tlatzejtzeloltic. Huan xicajalti ica aceite para tiquiyocatlalis para nechtequipanos quen nototajtzi catli más hueyi. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Teipa xiquinhuica itelpocahua, huan xiquinyoyonti ica nopa yoyomitl huehueyac catli anquinsencahuilijque. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Huan xiquinajalti aceite quen tijchijqui ica inintata, huan inijuanti nojquiya nechtequipanose quen totajtzitzi. Huan quema tiquinajaltis aceite, pehuas se familia tlen totajtzitzi catli amo tlamis pampa iniixhuihua elise nototajtzitzi para nochipa.” ");
INSERT INTO nhwBl_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Huan Moisés quichijqui nochi senquistoc quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Huajca ipan nopa achtihui tonal, ipan nopa achtihui metztli quema yohuiyaya para ome xihuitl quistoyaj ipan tlali Egipto, quiquetzque nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Huan quema Moisés quiquetzqui nopa yoyon tiopamitl, quiquetzqui itepos cuatetonyo, ihuapalhua, huan quicalaqui icuaixtlapalhua huejhuehueyac huan itlaquetzalhua. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Teipa quipatlajque nopa cortina para quitzontzacuase, huan nojquiya nopa seyoc itzontzajca quitlali san quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Teipa quicuic nopa ome tepatlactli catli quipixtoya itlanahuatilhua TOTECO huan quitlali ipan nopa caxa. Teipa quicalaqui nopa cuahuitl huehueyac para ica quihuicase campa monequiyaya. Huan iixco quitlali itzajca campa nopa totajtzi quinixtzacuilis inintlajtlacolhua masehualme iixpa TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Quema ya eltoya tlasencahuali nopa caxa, quicalaqui ipan nopa cuarto más tiopan calijtic, huan quicuapilo nopa cortinas para quitzacuas nopa cuarto catli quipixtoya nopa caxa san quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Teipa ica norte ipan nopa achtihui cuarto catli amo más calijtic, quitlali nopa cuamesa. Nopa cuarto eltoc iixpa nopa yejyectzi Cortina. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Huan ipan nopa cuamesa quitenqui nopa pantzi iixpa TOTECO senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Huan nojquiya ipan nopa cuarto catli amo más calijtic, ica sur quitlali nopa tlahuil quetzali iixmelac nopa cuamesa para pantzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Huan quintlati nopa tlahuilme iixpa TOTECO quen TOTECO quinahuatijtoya ma quichihua. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Huan ipan nopa cuarto nojquiya quitlali nopa tlaixpamitl tlen oro. Huan quiquetzqui iixmelac nopa cortina catli quitzacuayaya nopa cuarto catli más calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Huan ipan nopa tlaixpamitl tlen oro quitlati nopa copali catli ajhuiyac quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Nojquiya Moisés quicuapilo se cortina para quitzacuas campa calaquise ipan nopa cuarto catli amo más calijtic ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Huan ipan nopa calixpamitl iixmelac campa calaquise ipan nopa yoyon tiopamitl, quitlali nopa tlaixpamitl campa quitlatise tlacajcahualistli. Huan ipan quintlatijque tlapiyalme para tlacajcahualistli. Nojquiya quitlati tlacajcahualistli tlen harina quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Huan ipan calixpamitl tlatlajco tlen nopa yoyon tiopamitl huan tlaixpamitl campa quitlatise tlacajcahualistli, quiquetzqui nopa hueyi paila, huan quitequili atl para nopona ma moicxipajpacaca huan ma momajtequica totajtzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Huan Moisés ininhuaya Aarón huan itelpocahua nopona momajtequijque huan moicxipajpajque. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Huan sesen huelta quema inijuanti calajque ipan nopa yoyon tiopamitl o sintla quinechcahuiyaya nopa tlaixpamitl campa quitlatise tlacajcahualistli, monequiyaya mopajpacase quen TOTECO tlanahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Teipa Moisés quiquetzqui nopa tlatzactli tlen cortinas catli quitzajqui nopa calixpamitl yahualtic nopa yoyon tiopamitl huan nopa tlaixpamitl. Huan campa calaquij ipan calixpamitl, quicuapilo nopa cortina para elis quen se puerta. Huan ica ya nopa Moisés quitlamilti nopa tequitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Huan se mixtli quisentzajqui nopa yoyon tiopamitl. Huan itlatlanex TOTECO catli nelía yejyectzi quitemiti nopa tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Huan Moisés amo huelqui calaqui tiopan calijtic pampa nopa mixtli motlalijtoya nopona. Huan itlatlanex TOTECO catli tlahuel cahuaniyaya quisentzajqui nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Huan ipan nopa tonali quema nopa israelitame nentinemiyayaj campa hueli, sintla nopa mixtli quitlalcahuiyaya nopa yoyon tiopamitl, nopa israelitame quitlananayayaj nopa yoyon tiopamitl huan quitoquiliyayaj nopa mixtli. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Pero sintla nopa mixtli amo mijcuiniyaya, inijuanti nojquiya amo mijcuiniyayaj hasta quema nopa mixtli sempa mijcuinisquía. Huan huajca, quena, quema mijcuinisquía, inijuanti quitoquilisquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Huan quej nopa elqui ipan nochi iniojhui. Tonaya nopa mixtli tlen TOTECO motlaliyaya itzonatipa nopa tiopamitl huan tlayohua mocuepayaya se tlitl catli mosehui nopona huan yeca nopa israelitame hueliyayaj tlachiyase tonaya huan tlayohua.");
INSERT INTO nhwBl_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","TOTECO quinotzqui Moisés tlen nopa yoyon tiopamitl campa mopantiyayaj huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Xiquinilhuiti nopa israelitame ni tlanahuatilme. Quema anquinequise techhualiquilise se tlacajcahualistli na, niamoTECO, monequi techhualiquilise se tlen amohuacaxhua, o se tlen amoborregojhua o se tlen amochivojhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“Sintla elis se tlacajcahualistli tlatlatili tlen amohuacaxhua, huajca monequi antechmacase se becerro catli amo quipiya niyon se tlamantli catli amo cuali ipan itlacayo. Monequi anquihuicase nopa tlapiyali noixpa hasta campa ipuerta nopa yoyon tiopamitl campa timopantíaj para na, niamoTECO, nijselis. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Huan nopa masehuali catli quihualica quitlalis imax ipan itzonteco nopa tlapiyali, huan quej nopa, nopa tlapiyali elis ipatlaca nopa masehuali. Huan na nijselis nopa tlacajcahualistli huan niquitas para mijqui por nopa masehuali para quiixtzacuilis itlajtlacolhua noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Huan nopa masehuali quimictis nopa tlapiyali nopona noixpa, niamoTECO. Huan itelpocahua Aarón, nopa totajtzitzi, quiijtzelose ieso nopa tlapiyali yahualtic nopa tlaixpamitl catli eltoc nechca ipuerta nopa yoyon tiopamitl huan quej nopa nechmacase. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Huan nopa masehuali quiquixtilis icuetlaxo nopa tlapiyali catli elis para se tlacajcahualistli tlatlatili huan quihuejhuelos itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Teipa itelpocahua Aarón, nopa totajtzitzi, quitlipichise huan quitlalise miyac cuahuitl ipan nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Huan teipa itelpocahua Aarón quitlalise nochi nacatl tlahuejhueloli tlen nopa tlapiyali ihuaya itzonteco huan ichiyajca ipan nopa cuahuitl catli lementos. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Pero achtihui quipajpacase icuetlaxcol huan imetzcuayohua nopa tlapiyali huan teipa nopa totajtzitzi quitlalise icuetlaxcol huan imetzcuayohua ipan nopa tlaixpamitl para ma tlatla. Huan ni elis se tlacajcahualistli tlatlatili catli mijyotis nelía ajhuiyac noixpa huan nechyolpactis, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“Huan sintla nopa tlapiyali catli temacas para se tlacajcahualistli tlatlatili elis se borrego o se chivo, huajca monequi elis se oquichtli catli amo quipiya niyon se tlamantli catli amo cuali ipan itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Huan nopa masehuali catli quihualica nopa tlacajcahualistli moquetzas nechca iquespa nopa tlaixpamitl ipan nopa lado norte huan quimictis nopa tlapiyali noixpa, na niamoTECO. Huan itelpocahua Aarón, nopa totajtzitzi, quicuise ieso nopa tlapiyali huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Huan nopa masehuali catli temaca nopa tlacajcahualistli, quihuejhuelos, huan nopa totajtzi quicuis nopa tlapiyali itzonteco huan ichiyajca, huan quitlalise ipan tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Pero nopa masehuali catli temacas nopa tlapiyali monequi achtihui quipajpacas icuetlaxcol huan imetzcuayohua. Huan teipa quema ya quipajpactos, nopa totajtzitzi quitlatise ipan nopa tlaixpamitl. Huan elis se tlacajcahualistli tlatlatili catli mijyotis nelía ajhuiyac huan nechyolpactis, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“Pero sintla acajya quinequi nechmacas na, niamoTECO, se tototl para se tlacajcahualistli, huajca hueli temacas se paloma o se pichontzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","“Huan nopa totajtzi quihuicas nopa paloma o nopa pichontzi campa nopa tlaixpamitl huan quiquechilacatzos hasta quicotonas itzonteco huan quitlatis itzonteco ipan tlaixpamitl. Teipa quicahuilis ma quisa ieso nopa paloma ielchiquitipa nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Huan teipa nopa totajtzi quicuis iapompo huan iijhuiyo nopa piltototzi huan quinmajcahuas ielchiquitipa nopa tlaixpamitl ica campa hualquisa tonati campa eltoc nopa cuanextli. ");
INSERT INTO nhwBl_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Teipa quiitzquis ipan ieltlapalhua huan quitlajcotequis, pero amo quicotonas. Teipa nopa totajtzi temacas nopa paloma para se tlacajcahualistli huan quitlatis ipan tlitl catli eltoc ipan nopa tlaixpamitl. Huan elis se tlacajcahualistli tlatlatili catli mijyotis ajhuiyac huan nechyolpactis, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“Quema se masehuali quinequis nechmacas na, niamoTECO, se tlacajcahualistli tlen harina tlen trigo o cebada, monequi quicuechtilis iyol hasta mochihuas se harina catli nelía cuechtic. Nojquiya monequis quitequilis aceite huan copali ipan nopa harina. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Teipa quimacas se itelpoca Aarón huan nopa totajtzi quicuis se quentzi nopa harina ica imax huan quitlatis ipan nopa tlaixpamitl quen se tlanextilijcayotl para ipan nopa tlatoctzi nechmaca nochi nopa tlacajcahualistli. Huan ni elis se tlacajcahualistli tlatlatili catli mijyotis ajhuiyac noixpa na, niamoTECO, huan nechyolpactis. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Huan nochi nopa harina catli mocahuas tlen nopa tlacajcahualistli tlatlatili elis iniaxca Aarón huan itelpocahua, nopa totajtzitzi para quicuase. Huan nochi elis se tlacajcahualistli catli tlahuel tlatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“Huan sintla acajya quinequi nechmacas se tlacajcahualistli tlen harina catli tlaicxitili ipan horno, huajca monequi quicuechtilis iyol hasta mochihuas se harina catli nelía cuechtic, huan quimanelos ica aceite para quichihuas se pantzi, pero amo hueli quipiyas tlasonejcayotl. Nojquiya se masehuali hueli nechmacas pantzi catli quen se tlaxcali huan cacatztic catli amo quipiya tlasonejcayotl huan san tlaajaloli ica aceite. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","“Huan sintla nopa tlacajcahualistli tlen harina eli tlaicxitili ipan se comali, huajca nojquiya monequi elis tlachihuali ica harina catli nelía cuechtic catli amo quipiyas tlasonejcayotl huan catli tlamaneloli ica aceite. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Huan teipa monequi quihuejhuelos nopa pantzi huan ipani quitoyahuas aceite. Huan ya ni nojquiya elis se tlacajcahualistli tlen harina. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","“Huan sintla nopa tlacajcahualistli tlen harina elis se pantzi catli tlaicxitili ipan sartén, huajca nojquiya monequi elis tlachijchihuali ica harina catli nelía cuechtic huan tlamaneloli ica aceite. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Huan quema se masehuali quihualicas se tlacajcahualistli para na, niamoTECO, catli tlaicxitili ipan horno, comali o sartén, monequi quimactilis nopa totajtzi huan yaya quihuicas campa nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","“Huan nopa totajtzi quicuis san se quentzi tlen nopa tlacajcahualistli tlen harina para quitlatis para na ipan nopa tlitl ipan tlaixpamitl. Huan nopa poctli tlen nopa tlitl mijyotis ajhuiyac huan nechpactis, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Huan nochi catli mocahua tlen nopa tlacajcahualistli tlatlatili elis iniaxca nopa totajtzitzi, Aarón huan itelpocahua, para quicuase. Huan nochi elis se tlacajcahualistli tlahuel tlatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“Niyon se tlacajcahualistli tlen harina catli antechhualiquilise, amo quema huelis quipiyas tlasonejcayotl, niyon sayolnectli. Pampa amo tleno catli anquitlatise ipan tlaixpamitl para antechmacase amo hueli quipiyas tlasonejcayotl, niyon sayolnectli. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Pero quema ajsis nopa ilhuitl quema anquipixcase amomil, huelis antemacase tlacajcahualistli tlen harina catli quipiya tlasonejcayotl huan sayolnectli. Pero sintla quipiya tlasonejcayotl o sayolnectli, amo hueli anquitlatise quen se tlacajcahualistli catli ajhuiyac mijyotis noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","“Nojquiya monequi anquitlalise istatl ipan nochi tlacajcahualistli catli tlasencahuali ica harina, pampa istatl eli se tlanextilijcayotl catli anmechelnamiquiltía tlen nopa camanali catli na, ni amoTeco Dios, nijchijqui amohuaya. Huajca nochipa monequi antechmacase istatl ica amotlacajcahualis. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“Sintla anquinequij antechmacase, se tlacajcahualistli tlen nopa catli achtihui anquipixcaque ipan mili, huelis se tlamantli quen trigo o cebada iyol, monequi xijyolquixtica huan xijcacatztilica ipan tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Huan ipan nopa tlacajcahualistli xijteca aceite huan copali. Ya nopa nojquiya elis se tlacajcahualistli tlen harina. ");
INSERT INTO nhwBl_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Huan nopa totajtzitzi quicuise se quentzi tlen nopa tlacajcahualistli catli tlamaneloli ica aceite huan copali para quitlatise noixpa para nechmacase. Huan quema quichihuase ya nopa, quiixnextise para nochi nopa tlacajcahualistli eli tlatzejtzeloltic huan noaxca na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“Sintla se masehuali quinequis nechmacas na, niamoTECO, se tlacajcahualistli para ma onca tlayoltlalili nohuaya, huelis nechmacas se toro o se huacax. Pero nopa tlapiyali monequi elis tlapajpactli. Amo quipiyas niyon se tlamantli catli amo cuali ipan itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Huan nopa masehuali catli quihualicas nopa tlacajcahualistli quitlalis imax ipan nopa tlapiyali itzonteco huan quimictis nopona nechca puerta tlen nopa yoyon tiopamitl. Huan itelpocahua Aarón, nopa totajtzitzi, quicuise nopa estli huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","“Huan tlen nopa tlacajcahualistli quicuise catli nechmacase na, niamoTECO ipan tlitl. Quicuise nopa tlachiyajcayotl catli eltoc ipan iijtico, huan nopa tlachiyajcayotl tlatlajco icuetlaxcol. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Huan quicuise nopa ome isosonechua ica nochi ichiyajca, huan nopa parte catli más hueyi tlen ieltapach huan quiquixtise san sejco ica isosonechua. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Huan nochi ya ni itelpocahua Aarón, nopa totajtzitzi, quitlatise para na, niamoTECO, ipan nopa tlitl ipan tlaixpamitl. Huan elis se tlacajcahualistli catli ajhuiyac mijyotis huan nechpactis. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“Huan sintla se masehuali quinequis nechmacas tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi techmacas se chivo o se borrego. Huelis nechmacase se sihuatzi o se oquichtli. Pero monequi nopa tlapiyali elis tlapajpactli. Amo hueli techmacas niyon se tlapiyali catli quipiya se tlamantli amo cuali ipan itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Huan san se quichihuas sintla nopa tlacajcahualistli catli nechmacas elis se pilborregojtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Nopa masehuali catli temacas, quitlalis imax ipan nopa tlapiyali itzonteco, huan quimictis nopona campa ipuerta nopa yoyon tiopamitl. Teipa nopa totajtzitzi quicuise se quentzi estli huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","“Huan ipan nopa tlaixpamitl quitlalise nochi ichiyajca. Quitlalise icuitlapil catli quipiya miyac ichiyajca huan quicotonase nechca icuitlapa nopa tlapiyali. Nojquiya quitlalise nochi ichiyajca catli mopantía ipan iijtic huan tlatlajco icuetlaxcol. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Quitlatis isosonechua ica nochi ichiyajca huan nopa parte catli más hueyi tlen ieltapach catli quiquixtise san sejco ica isosonechua. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Huan nochi ni tlamantli nopa totajtzi quitlatis ipan nopa tlaixpamitl, huan ni elis se tlacajcahualistli tlen tlacualistli catli nechmacase, na niamoTECO, ipan tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“Sintla se acajya quinequi quihualicas se sihua chivo para nechmacas, ");
INSERT INTO nhwBl_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","huajca nopa masehuali quitlalis imax ipan nopa tlapiyali itzonteco, huan teipa quimictis nopona nechca ipuerta nopa yoyon tiopamitl campa timopantíaj. Huan nopa totajtzitzi quicuise se quentzi ieso nopa tlapiyali huan ica quiatzejtzelhuise yahualtic nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","“Huan quiquixtilise nopa tlapiyali nopa tlachiyajcayotl ipan iijtico, huan nochi nopa tlachiyajcayotl tlatlajco icuetlaxcol, huan quitlalise ipan nopa tlaixpamitl para nechmacase ipan tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Nojquiya quitlalise nopa ome isosonechua huan nopa tlachiyajcayotl catli eltoc ipani. Huan quitlalise nopa parte catli más hueyi tlen ieltapach catli quiquixtise ihuaya isosonechua. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Huan ya ni elis se tlacajcahualistli catli nopa totajtzi nechmacas, niamoTECO, ipan tlitl huan mijyotis ajhuiyac huan nechpactis. Nochi tlachiyajcayotl mocahua noaxca na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“Quena, ya ni elis se tlanahuatili catli monequi anquitlepanitase, amojuanti huan nochi amoixhuihua masque campa hueli anmopantíaj: Amo xijcuaca estli, niyon tlachiyajcayotl.” ");
INSERT INTO nhwBl_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Huan teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Xiquinilhui nopa israelitame ni tlanahuatilme. Sintla se tlen amojuanti tlajtlacolchihuas huan quiixpanos se notlanahuatil na, niamoTECO, huan amo quimati sintla tlaixpano, ya ni catli monequi quichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“Sintla elis nopa hueyi totajtzi catli tlajtlacolchihuas masque amo quimatiyaya, quinchihuas para nopa sequinoc masehualme nojquiya ma quihuicaca tlajtlacoli huan monequi nopa hueyi totajtzi temacas noixpa se becerro catli amo tleno quipiya catli amo cuali ipan itlacayo. Ya nopa elis se tlacajcahualistli para nopa tlajtlacoli catli ya quichijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Huan monequi nopa hueyi totajtzi quihuicas nopa tlapiyali campa ipuerta nopa yoyon tiopamitl campa timopantíaj, huan nopona quitlalis imax ipan itzonteco nopa tlapiyali huan quimictis nopona noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Huan teipa nopa hueyi totajtzi quicuis se quentzi nopa tlapiyali ieso huan quihuicas ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Huan nopa totajtzi quixolonis imacpil ipan nopa estli huan quiatzejtzelhuis chicome hueltas noixpa nopona iixmelac nopa cortina catli quitzacua nopa cuarto campa Más Tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Teipa nojquiya nopa hueyi totajtzi quiajalos estli nopa nahui icuacua nopa tlaixpamitl campa quitlatíaj copali catli mocahua yoyon tiopan calijtic noixpa. Huan nopa estli catli noja mocahua, quitoyahuas tlalchi itzintla nopa tlaixpamitl para tlacajcahualistli tlatlatili catli eltoc nechca ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Teipa quiquixtilis nochi nopa tlachiyajcayotl catli eltoc ipan iijtico nopa becerro huan nochi catli eltoc tlatlajco icuetlaxcol. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Nojquiya quiquixtis nopa ome isosonechua ihuaya ininchiyajca huan nopa parte catli más hueyi tlen ieltapach catli quiquixtis san sempa ica nopa isosonechua. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Huan nochi ni tlamantli nopa totajtzi nechmacas na, niamoTeco, ipan nopa tlaixpamitl para tlacajcahualistli tlatlatili. Quiijtosnequi quichihuas san se quen quichijqui ica nopa becerro catli techmacas quen se tlacajcahualistli para ma onca tlayoltlalili nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Pero icuetlaxo nopa becerro, huan inacayo, itzonteco, iicxihua, icuetlaxcol huan icuitl, ");
INSERT INTO nhwBl_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","quinequi quiijtos nochi catli mocahua, monequi quicahuatij ipan se lugar catli tlapajpactli noixpa huan catli mopantía huejca tlen nopa yoyon calme campa anmochijtoque. Quena, quihuicase campa concahuaj nopa cuanextli tlen nopa tlacajcahualistli catli quitlatíaj ipan tlaixpamitl. Huan nopona quitlatise ipan cuahuitl catli mocahua tlen nopa becerro catli elqui nopa tlacajcahualistli por tlajtlacoli catli nopa totajtzi quichijqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“Sintla nochi israelitame quichihuase se tlajtlacoli, o sintla quichihuase se tlamantli catli na, niamoTECO, niquinnahuatijtoc ma amo quichihuaca, masque niyon se tlen inijuanti amo momacayaya cuenta tlen nopa tlajtlacoli, nochi nopa masehualme quihuicase tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Huajca quema momacase cuenta para quichijtoque tlajtlacoli, monequi quihualicase se becerro huan nechmacase quen se tlacajcahualistli por tlajtlacoli. Nopa becerro quihualicase iixpa nopa yoyon tiopamitl, ");
INSERT INTO nhwBl_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","huan noixpa nopa huehue tlacame catli quinyacanaj israelitame quitlalise ininmax ipan nopa tlapiyali itzonteco huan nopona quimictise. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Teipa nopa hueyi totajtzi quicuis quentzi ieso nopa tlapiyali huan quihuicas ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Huan teipa quixolonis imacpil ipan nopa estli huan quiatzejtzelhuis chicome hueltas noixpa iixmelac nopa cortina. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Huan nojquiya ica nopa estli quiajalos nopa nahui icuacua nopa tlaixpamitl catli eltoc noixpa tiopan calijtic. Huan nopa estli catli noja mocahuas quitoyahuas tlalchi itzintla nopa tlaixpamitl campa temaca tlacajcahualistli tlatlatili. Nopa tlaixpamitl mocahua nechca ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Huan nojquiya quiquixtilis nopa becerro nochi ichiyajca, huan quitlatis ipan nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Huan san se quichihuas nopa totajtzi ica ni becerro catli temacaj quen quichijqui ica nopa becerro para nopa tlacajcahualistli por tlajtlacoli. Huan quej nopa quichihuas nopa totajtzi para quiixtzacuas nochi nopa tlajtlacoli catli quichijque nopa israelitame, huan niquintlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Teipa catli mocahuas tlen ni becerro nopa totajtzi quihuicas quentzi huejca tlen campa anmochijtoque. Nopona quitlatis quen niquijto quitlatisquía ne seyoc becerro. Ya ni elis se tlacajcahualistli para nochi inintlajtlacolhua nochi israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“Sintla se tlayacanquetl ipan nopa israelitame quichihuas se tlajtlacoli huan quiixpanos se notlanahuatil, niamoTECO Dios, masque amo quimatqui, huajca yaya quihuica tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Huajca quema ya quimachilijtos para quichijtoc se tlajtlacoli, nimantzi ma quihuicas se oquich chivo para nechmacas quen se tlacajcahualistli. Nopa tlapiyali monequi elis tlapajpactli. Amo quipiyas catli amo cuali ipan itlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Huan nopa masehuali quitlalis imax ipan nopa oquich chivo itzonteco huan quimictis campa quinmictíaj tlapiyalme para tlacajcahualistli tlatlatili. Huan teipa nechmactilis na, niamoTECO, huan elis se tlacajcahualistli para itlajtlacol. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Teipa nopa totajtzi ica imacpil quicuis se quentzi ieso nopa tlapiyali catli quitencajque quen se tlacajcahualistli por tlajtlacoli huan quiajalos nopa nahui icuacua nopa tlaixpamitl para tlacajcahualistli tlatlatili. Huan nochi nopa estli catli noja mocahuas quitoyahuas itzintla nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Huan nochi ichiyajca nopa oquich chivo nojquiya monequi nechmacase ipan tlitl quen quitlatíaj ichiyajca nopa tlapiyali catli se tlacajcahualistli para ma onca tlayoltlalili nohuaya, niamoTECO. Huan quema quichijtos nochi ya ni, teipa nijtlapojpolhuis nopa tlayacanquetl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“Sintla aqui hueli israelita quichihuas se tlajtlacoli, yaya quihuica tlajtlacoli masque amo quimatqui para na, niamoTECO, nitlanahuatijtoya amo aqui ma quichihua nopa tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Huan teipa quema ya quimachilijtos para quichijtoc nopa tlajtlacoli, nimantzi monequi quihuicas se chivo catli sihuatzi catli amo quipiya niyon se tlamantli catli amo cuali ipan itlacayo. Huan ya nopa elis se tlacajcahualistli para nopa tlajtlacoli catli quichijqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Huan quihuicas nopa tlapiyali campa quinmictíaj nopa tlapiyalme para tlacajcahualistli tlatlatili. Huan nopona quitlalis imax ipan nopa tlapiyali itzonteco catli elis se tlacajcahualistli por tlajtlacoli huan teipa quimictis. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Huan nopa totajtzi quicuis ica imacpil se quentzi ieso huan quiajalos ipan nopa nahui icuacua nopa tlaixpamitl para tlacajcahualistli tlatlatili. Huan nopa estli catli noja mocahuas, quitoyahuas tlalchi itzintla nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Nojquiya nopa masehuali monequi quiquixtilis nochi ichiyajca nopa tlapiyali. Quena, san se quichihuas quen quichihua ica se tlacajcahualistli para ma onca tlayoltlalili nohuaya. Huan teipa nopa totajtzi quitlalis nopa tlachiyajcayotl ipan nopa tlaixpamitl huan quitlatis. Huan elis se tlacajcahualistli catli mijyotis ajhuiyac huan nechpactis na, niamoTECO. Huan quej nopa, quichihuas nopa totajtzi para nechixtzacuilis itlajtlacol nopa masehuali. Huan nijtlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“Pero sintla nopa masehuali quinequi nechmacas se pilborregojtzi para se tlacajcahualistli por tlajtlacoli, hueli quihualicas se pilsihua borregojtzi catli amo quipiya ipan itlacayo niyon se tlamantli catli amo cuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Huan quitlalis imax ipan itzonteco nopa tlapiyali huan quimictis campa quinmictíaj nopa tlapiyalme catli quintequihuíaj para tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Huan nopa totajtzi quicuis se quentzi ieso nopa tlapiyali ica imacpil huan quiajalos ipan icuacua nopa tlaixpamitl para tlacajcahualistli tlatlatili. Huan nopa estli catli noja mocahuas quitoyahuas tlalchi itzintla nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Teipa quiquixtilis nochi ichiyajca nopa pilsihua borregojtzi. Quena, san se quichihuas quen quichijqui ica nopa pilborregojtzi catli nechtencahuilijque quen se tlacajcahualistli para ma onca tlayoltlalili nohuaya. Huan nopa totajtzi quitlatis nochi nopa tlachiyajcayotl ipan nopa tlaixpamitl huan nechmacas na, niamoTECO, ica nopa tlitl. Huan ica catli quichihua nopa totajtzi nechixtzacuilis nopa tlajtlacoli catli nopa masehuali quichijqui, huan nijtlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“Sintla se acajya quiitztoc quema panoc se tlamantli amo cuali, o quicactoc se camanali amo cuali, huan teipa tequitini quitemohuaj se testigo catli quiitztoc nopa tlamantli o quicactoc nopa camanali, huajca monequi teyolmelahuas catli nelía quiitztoc o quicactoc. Pampa sintla amo teyolmelahuas catli panoc, yaya quihuicas tlajtlacoli noixpa huan monequi nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“Nojquiya monequi quihualicas se tlacajcahualistli sintla se acajya quiitzquis se tlamantli catli amo tlapajpactli. Sintla mictoc se tlapiyali catli amo tlapajpactli para anquicuase masque teaxca o ehua cuatitla, huan se masehuali quiitzquis itlacayo, monequi nechhualiquilis se tlacajcahualistli. Nojquiya mochihuas amo tlapajpactli noixpa catli quiitzquis itlacayo se piltlapiyaltzi catli mohuahuatatza tlalchi masque catli quiitzqui amo quimatiyaya sintla quiitzqui. Pero temachtli mochijtoc amo tlapajpactli huan monequi nechhualiquilis se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“O sintla quiitzquis cuitlatl o tlen hueli atl catli quistoc ipan itlacayo se masehuali, ayacmo tlapajpactli noixpa. Huan quema momacas cuenta para quichijtoc nopa tlamantli huan quihuica tlajtlacoli noixpa, monequi quihualicas se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Sintla se acajya tlatestigojquetzas para quichihuas se tlamantli catli cuali o amo cuali, huan teipa motejtemos huan momacas cuenta para achi cuali amo camanaltitosquía, yaya quihuicas tlajtlacoli noixpa huan monequi quihualicas se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","“Sintla se acajya quichihuas catli hueli tlen ni tlamantli, huajca monequi nechnelilhuis na, niamoTECO, tlaque quichijtoc, ");
INSERT INTO nhwBl_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","huan monequi quihualicas noixpa nopa tlacajcahualistli para nopa tlajtlacoli catli quihuica. Huelis quihualicas se sihua borrego o se sihua chivo. Huan nopa totajtzi nechmacas para nechixtzacuilis itlajtlacol nopa masehuali noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“Pero sintla nopa masehuali amo quipiya miyac tomi para quicohuas se pilborregojtzi, huajca hueli nechmacas ome palomajme o ome pichones. Huan ni totome elise tlacajcahualistli para nopa tlajtlacoli catli quihuica. Nechmacas se quen se tlacajcahualistli por tlajtlacoli huan nopa seyoc nechmacas quen se tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Huan nopa totome quinhualicas campa nopa totajtzi huan yaya temacas nopa achtihui piltototzi quen se tlacajcahualistli por tlajtlacoli. Achtihui quipilquechilacatzos pero amo quicahuilis ma cotoni itzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Teipa quicuis se quentzi ieso huan ica quiatzejtzelhuis se ielchiqui nopa tlaixpamitl. Huan nopa estli catli noja mocahuas quitoyahuas tlalchi itzintla nopa tlaixpamitl. Huan ya ni elis se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Huan nopa ompa piltototzi nechmacas quen se tlacajcahualistli tlatlatili, huan quichihuas san se quen quiijtohua nopa tlanahuatili. Huajca quej nopa quichihuas nopa totajtzi para nechixtzacuilis itlajtlacol nopa masehuali noixpa. Huan na, niamoTECO, nijtlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“Huan sintla itomi se acajya noja amo quiaxilía para quincohuas ome palomajme o ome pichones, hueli quihuicas ome kilo harina para nechmacas quen se tlacajcahualistli por itlajtlacolhua. Pero amo quitlalilis aceite, niyon copali, pampa ni elis se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Huan monequi quihualicas nopa harina campa nopa totajtzi, huan nopa totajtzi quicuis se quentzi tlen nopa tlacajcahualistli quen se tlanextilijcayotl para nechmaca nochi nopa harina. Huan quitlatis ne quentzi ipan nopa tlaixpamitl quen quitlatía nochi sequinoc tlacajcahualistli para na. Ya ni elis se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Huan ica nochi ya ni nopa totajtzi quiixtzacuilis itlajtlacol catli quichijtoc nopa masehuali, huan na nijtlapojpolhuis nopa tlajtlacoli catli quichijtoc. Huan nopa harina catli noja mocahuas elis para nopa totajtzitzi inintlacualis quen nojquiya mochihua ica nochi catli mocahua quema temacaj tlacajcahualistli tlen harina.” ");
INSERT INTO nhwBl_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Sintla se masehuali quichihuas catli amo cuali, huan quisoquihuijtos tlamantzitzi catli tlatzejtzeloltique, huan amo momaca cuenta quema quichihua, teipa quema quimatis, monequi quihualicas se tlacajcahualistli pampa tlajtlacole noixpa. Huan nopa tlacajcahualistli elis se oquich chivo catli amo quipiya niyon se tlamantli catli amo cuali ipan itlacayo. Huan nopa tlapiyali monequi elis ipati quen ome plata tomi catli motequihuía ipan nopa yoyon tiopamitl o achi más. Ni elis se tlacajcahualistli para catli quihuica tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Huan nopa masehuali monequi quiixtlahuas catli ipati nopa tlamantli catli quisoquihuijtoc catli achtihui eliyaya tlatzejtzeloltic. Huan nojquiya quitlalis seyoc 20 por ciento más. Quej nopa, nopa totajtzi nechixtzacuilis itlajtlacol nopa tlacatl noixpa, huan na, niamoTECO, nijtlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Aqui hueli masehuali catli quiixpanos notlanahuatil, niamoTECO, masque amo momaca cuenta, quihuica tlajtlacoli noixpa huan monequi quiselis itlatzacuiltilis. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Huan monequi quihuicas se tlacajcahualistli campa nopa totajtzi. Huan nopa tlacajcahualistli elis se oquich borrego catli ipati quen catli ta, Moisés, tiquijtos. Huan nopa oquich borrego amo quipiyas niyon se tlamantli catli amo cuali ipan itlacayo. Huan nopa totajtzi nechmacas nopa tlacajcahualistli para nechixtzacuilis itlajtlacol nopa masehuali pampa amo quimatqui sintla quichihuayaya tlajtlacoli. Huan na, niamoTECO, nijtlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ya ni elis se tlacajcahualistli para catli quihuica tlajtlacoli pampa tlajtlacolchijtoc noixpa.” ");
INSERT INTO nhwBl_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Sintla se acajya tlajtlacolchihuas huan quicajcayahuas seyoc pampa amo quineltocac nocamanal, niamoTECO, monequi quihualicas se tlacajcahualistli. Huelis ya amo quimocuitlahui cuali catli ihuampox quicahuili imaco para quimocuitlahuis, o huelis quiichtequilijtoc, o quiquixtilijtoc se tlenijqui pampa yaya más tetic, o huelis amo tlacuepqui catli quitlanejtijque. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","O huelis se masehuali quipantis catli seyoc quipolojtoya, huan istlacatis o tlatestigojquetzas ica catli amo melahuac huan quiijtos amo quiitztoc. Nochi ya ni se tlajtlacoli. Nojquiya tlajtlacoli tlen hueli tlamantli amo cuali catli se masehuali quichihua ica tlamantzitzi catli seyoc iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Huan quema mopantis o seyoc quipantis para tlajtlacolchijtoc huan quihuica tlajtlacoli noixpa pampa quipiya catli amo iaxca, o tlatestigojquetztoc ica catli amo melahuac, huajca nimantzi monequi ma quicuepas nopa tlamantli. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Huan iyoca monequi noja temacas seyoc 20 por ciento quen elisquía se multa. Nochi temacas ipan san se tonal quema ipan nopa yoyon tiopamitl nechmacas se tlacajcahualistli para nopa tlajtlacoli catli quihuica. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Monequi nechhualiquilis se oquich borrego catli tlapajpactli huan senquistoc cuali itlacayo huan catli cuali ipati. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Huan nopa totajtzi nechmacas nopa tlapiyali huan nechixtzacuilis itlajtlacol nopa masehuali tlen na. Huan na, quena, nijtlapojpolhuis tlen hueli catli quichijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Xiquinilhuiti Aarón huan itelpocahua para quej ni eltoc tlanahuatili para se tlacajcahualistli tlatlatili. Nopa tlacajcahualistli monequi eltos ipan nopa tlitl seyohual hasta ijnaloc huan nopa tlitl mocahuas lementoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Huan hualmostla nopa totajtzi moquentis itlatzintlanyoyo tlen lino nechca itlacayo huan teipa iyoyo huehueyac tlen lino. Huan quiquixtis nopa cuanextli catli mocahua tlen nopa tlacajcahualistli huan quitlalis ipan se lado nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Teipa quiquixtis nopa iyoyo huan moquentis ne seyoc tlamantli iyoyo huan quihuicas nopa cuanextli hasta se lugar catli tlapajpactli noixpa catli mocahua huejca tlen campa anmochijtoque, huan nopona quicahuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","“Nochipa monequi lementos se tlitl ipan tlaixpamitl. Ma amo quicahuase ma sehui. Huan sese ijnaloc nopa totajtzi monequi quitlalilis cuahuitl nopa tlaixpamitl huan teipa quitlalis nopa tlapiyali para nopa tlacajcahualistli tlatlatili catli monequi mojmostla. Nojquiya nopona quitlatis nopa tlachiyajcayotl tlen nopa tlacajcahualistli catli masehualme temacaj para ma moyoltlalica nohuaya, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Quena, amo quema hueli quicahuase para sehuis nopa tlitl ipan tlaixpamitl. Monequi nochipa lementos. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Ya ni nopa tlanahuatilme para tlacajcahualistli tlen harina. Itelpocahua Aarón monequi moquetzase iixmelac nopa tlaixpamitl para nechmacase nopa tlacajcahualistli noixpa na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Se tlacajcahualistli tlen harina elis tlen se harina catli quicuechtilijtoque nelcuechtic huan quimanelojtoque ica aceite huan copali. Huan se tlen nopa totajtzitzi quicuis ica imax se quentzi tlen nopa tlacajcahualistli tlen harina huan quitlatis ipan nopa tlaixpamitl para quinextis nechtencahuilijtoc nochi noixpa. Huan mijyotis ajhuiyac noixpa na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Huan ica nopa harina catli mocahua tlen nopa tlacajcahualistli, Aarón huan itelpocahua, nopa totajtzitzi, quichihuase pantzi para quicuase, pero amo huelis quitlalilise tlasonejcayotl ipani. Huan monequi quicuase nopona campa tlatzejtzeloltic ipan nopa calixpamitl ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Ma quipiyaca cuidado ma amo quiicxitica ica tlasonejcayotl. Niquinmacatoc ni harina para elis iniaxca tlen nochi nopa tlacajcahualistli catli nechmacaj ica tlitl. Eltoc tlahuel tlatzejtzeloltic quen nojquiya tlatzejtzeloltic nopa tlapiyalme catli nechmacaj para tlacajcahualistli por tlajtlacoli huan para catli quihuica tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nochi ioquich conehua huan ioquich ixhuihua Aarón hueli quicuase catli mocahuas tlen nochi nopa tlacajcahualistli catli nechmaca ica tlitl. Huan quej ni elis tlanahuatili para iteipan ixhuihua catli oquichpilme catli tlacajtiyase ipan ifamilia Aarón teipa. Pero san inijuanti hueli quicuase pampa inijuanti tlaiyocatlalilme para na. Mochihuas tlatzejtzeloltic aqui hueli masehuali catli quiitzquis nopa pantzi catli quichijtoque ica harina catli mocajqui tlen nopa tlacajcahualistli. Nojquiya mochihuas tlatzejtzeloltic tlen hueli masehuali o tlamantli catli quitoxomas.” ");
INSERT INTO nhwBl_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Ipan nopa tonal quema Aarón o iteipan ixhuihua moiyocatlalise para ma elica totajtzitzi, sesen monequi quihualicas para na, niamoTECO, ni tlacajcahualistli. Nechmacas se tlacajcahualistli catli quipiya ome kilos tlen harina nelcuechtic. Huan tlajco tlen nopa tlacajcahualistli nechmacase ica ijnaloc huan nopa seyoc tlajco nechmacase ica tiotlac. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Nopa tlacajcahualistli monequi elis tlaicxitili ipan se comali huan cuali tlamaneloli ica aceite. Huan quema ya icsitoc, quihuejhuelos nopa pantzi catli quichijtoque ica nopa tlacajcahualistli tlen harina huan nechmacas. Huan mijyotis nelía ajhuiyac para na. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Huan san se nechmacas nopa itelpoca catli se tonal calaquis quen nopa yancuic hueyi totajtzi ipatlaca Aarón. Huan ni tlacajcahualistli elis noaxca na, niamoTECO, huan monequi quitlatise nochi nopa tlacajcahualistli para nechmacase ipan poctli pampa quej nopa nimechnahuatía. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Huajca monequi quitlatis senquistoc nochi nopa tlacajcahualistli tlen harina catli nopa totajtzi nechmacas para ya iseltzi. Niyon quentzi amo aqui hueli quicuas.” ");
INSERT INTO nhwBl_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Xiquinilhui Aarón huan itelpocahua ni tlanahuatilme para nopa tlacajcahualistli por tlajtlacoli. Ni tlacajcahualistli catli tlahuel tlatzejtzeloltic huan nopa tlapiyali monequi quimictise campa quinmictíaj tlapiyalme para tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Huan nopa nacatl catli mocahuas elis iaxca nopa totajtzi catli nechmacas nopa tlacajcahualistli por tlajtlacoli para quicuas, pero monequi quicuas campa tlatzejtzeloltic nopona ipan calixpamitl, iixpa nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Tlen hueli tlamantli o masehuali catli quitoxomas quentzi nopa nacatl mochihuas tlatzejtzeloltic, tlaiyocatlalili para nechtequipanos na. Huan sintla se quentzi tlen ieso quiajsis iyoyo, nopa masehuali monequi quichicuenis iyoyo nopona campa tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Sintla quiicxiti nopa nacatl ipan se comitl tlachijchihuali ica soquitl, monequi quitlapanas teipa. Pero sintla quiicxiti nopa nacatl ipan se tlamantli tlachijchihuali ica nopa tepostli bronce, san monequi quipajpacas ica miyac cuidado teipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“San totajtzitzi huan inioquichpilhua huelij quicuase se tlacajcahualistli por tlajtlacoli, pampa ni nopa tlacajcahualistli catli tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Pero sintla ieso nopa tlapiyali ya quihuicatoque tiopan calijtic campa nopa cuarto catli Más Tlatzejtzeloltic para quiixtzacuase inintlajtlacol masehualme, huajca amo aqui hueli quicuas inacayo. Nochi itlacayo nopa tlacajcahualistli monequi anquitlatise noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Ya ni nopa tlanahuatilme para nopa tlacajcahualistli para catli quihuica tlajtlacoli noixpa, niamoTECO. Nopa tlacajcahualistli elis tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Nopa tlapiyali catli quitencajtoque quen se tlacajcahualistli para catli quihuica tlajtlacoli, monequi quimictise ipan nopa lugar campa quinmictíaj nopa tlapiyalme catli quintequihuíaj para tlacajcahualistli tlatlatili. Huan ica ieso nopa tlapiyali quiatzejtzelhuise yahualtic nopa tlaixpamitl itzintla. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Huan nopa totajtzi nechmacas nochi ichiyajca masque catli mopantía campa tlatzquitoc icuitlapil o ipan icuetlaxcol. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Huan temacas nopa ome isosonechua ihuaya nopa tlachiyajcayotl catli mopantía ininpani. Nojquiya temacas nopa parte hueyi tlen ieltapach catli quiquixtis ihuaya isosonechua. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Teipa nopa totajtzi quitlatis nochi nopa partes ipan tlaixpamitl, huan elis se tlacajcahualistli para catli quihuica tlajtlacoli. Elis se tlacajcahualistli catli nechmacase niamoTECO ica tlitl huan mijyotis ajhuiyac noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Nochi totajtzitzi hueli quicuase nopa nacatl catli mocahua tlen se tlacajcahualistli para catli quihuica tlajtlacoli, pero monequi quicuase campa tlatzejtzeloltic pampa ni se tlacajcahualistli tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“San se tlanahuatili eltoc para nopa nacatl catli mocahua tlen nopa tlacajcahualistli por tlajtlacoli huan nojquiya para nopa tlacajcahualistli para catli quihuica tlajtlacoli. Nopa nacatl iniaxca nopa totajtzitzi catli temacase nopa tlacajcahualistli para nechixtzacuilise nopa tlajtlacoli noixpa huan inijuanti ma quicuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Pero quema se totajtzi nechmacas se tlacajcahualistli tlatlatili para se masehuali, nopa totajtzi san quiselis nopa tlapiyali icuetlaxo. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Huan nojquiya nochi tlacajcahualistli tlen harina catli tlaicxitili ipan horno, comali o sartén, elis para ma quitequihui nopa totajtzi catli nechmacas. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Pero nochi tlacajcahualistli tlen harina masque tlamaneloli ica aceite o amo, elis san se iniaxca nochi Aarón iixhuihua. Huan monequi quinmajmacase sesen inijuanti san se imiyaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Ya ni nopa tlanahuatili para nopa tlacajcahualistli para ma onca tlayoltlalili nohuaya catli masehualme temacaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Sintla eli se tlacajcahualistli para tlascamatili, monequi temacase ihuaya pantzi catli quipiya aceite, pero amo quipiyas tlasonejcayotl. Nojquiya monequi temacas ihuaya pantzi sepantic huan cacatztic catli amo quipiya tlasonejcayotl huan catli tlaajaloli ica aceite. Nojquiya monequi temacas pantzi tlen harina catli tlahuel tlatzotzoltili huan catli quihuica aceite. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Pero ica ni tlacajcahualistli para tlascamatili monequi quihualicas pantzi catli, quena, quipiya tlasonejcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Se quentzi tlen sesen tlamantli tlen ni tlacajcahualistli nopa totajtzi quitlejcoltis huejcapa huan quihuisos noixpa para nechmacas. Huan teipa ni elis iaxca nopa totajtzi catli tlapalehuía huan quiatzejtzelhuía estli tlen nopa tlapiyali ipan tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","“Huan catli quitencajqui nopa tlapiyali quen se tlacajcahualistli para ma onca tlayoltlalili nohuaya huan para nechtlascamatis monequi quicuas inacayo nopa tlapiyali ihuaya ifamilia ipan san se nopa tonali quema nechmacas. Amo tleno huelis quicahuase para seyoc tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Pero sintla se masehuali quihualicas se tlacajcahualistli para ma onca tlayoltlalili nohuaya pampa tlatestigojquetza catli quichihuas o catli amo quichihuas, o sintla quihualica san ica ipaquilis, huajca quena, nopa nacatl catli mocahuas elis iaxca catli quihualicac. Huan inijuanti quicuase nopa tonal o hasta hualmostla. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Huan sintla ipan eyi tonali noja eltos nopa nacatl, huajca monequi quitlatis nochi. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Pero sintla se masehuali quicuasquía nacatl ipan eyi tonali catli quisqui tlen se tlacajcahualistli para ma onca tlayoltlalili nohuaya catli yaya nechmacac, nopa tlacajcahualistli ayacmo elis se tlamantli catli nechpactis na. Amo nijselis nopa tlacajcahualistli huan niquitas para se tlamantli fiero noixpa huan amo nijselis yaya catli nechmacac. Huan nopa masehuali catli quicuajqui ipan eyi tonali quihuicas itlajtlacol noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“Nojquiya sintla quentzi nopa nacatl huetzis ipan se tlamantli catli amo tlapajpactli noixpa, huajca ayacmo aqui huelis quicuas. Monequi quitlatise nochi. “Pero nopa nacatl catli amo quiajsis catli amo tlapajpactli, quena, aqui hueli masehuali catli amo tlapajpactli hueli quicuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","“Huan sintla aqui hueli masehuali catli amo tlapajpactli quicuas se quentzi inacayo nopa tlapiyali catli noaxca na, niamoTECO, pampa se nechmacatoc quen se tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi xijquixtica tlen amojuanti para ayacmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“Mahuilili sintla se masehuali quitoxomas catli amo tlapajpactli, masque catli quisa ipan inintlacayohua masehualme, o se tlapiyali catli amo tlapajpactli, o tlen hueli tlamantli catli amo tlapajpactli noixpa. Catli quitoxomas catli amo tlapajpactli huan teipa quicuas quentzi nacatl tlen se tlacajcahualistli para ma onca tlayoltlalili nohuaya catli ya o seyoc nechmacatoc, monequi xijquixtica tlen amojuanti para ayacmo quema huelis itztos ica anisraelitame.” ");
INSERT INTO nhwBl_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Huan teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Xiquinilhui nopa israelitame ni tlanahuatilme. Amo aqui huelis quicuas niyon se tlamantli tlachiyajcayotl masque ininchiyajca huacaxme, borregojme o chivojme. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Pero ininchiyajca tlapiyalme catli mijque ica ininseltzi o catli quinmictijque sequinoc tecuanime, hueli xijtequihuica ininchiyajca ica tlen hueli tequitl, pero amo xijcuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","“Huan sintla aqui hueli masehuali quicuas ichiyajca se tlapiyali catli quitencajtoque quen se tlacajcahualistli para na ipan tlitl, monequi xijquixtica tlen amojuanti para ayacmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“Masque campa hueli anmochansehuíaj, amo quema xijcuaca estli. Amo xijcuaca inieso totome catli patlanij, niyon sequinoc tlamantli tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Sintla se masehuali quicuas estli, monequi xijquixtica tlen amojuanti para ayacmo quema huelis itztos ica anisraelitame.” ");
INSERT INTO nhwBl_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Xiquinilhui nopa israelitame ni tlanahuatilme. Quema se acajya quinequis nechmacas na, niamoTECO, se tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi quihualicas nopa partes catli monequi quitlatis noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Quena, monequi ya iseltzi quihualicas ica imax nopa tlachiyajcayotl ihuaya iyolixpa tlen nopa tlacajcahualistli para quitlatise noixpa. Pero achtihui nopa tlapiyali iyolixpa monequi quihuisos nopa totajtzi noixpa campa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Huan teipa iyolixpa nopa tlapiyali elis iniaxca Aarón huan itelpocahua para ma quicuaca. Pero nopa totajtzi nechmacas nochi nopa tlachiyajcayotl ipan tlitl ipan tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Nojquiya quema se nechmacas se tlacajcahualistli para ma onca tlayoltlalili nohuaya, monequi nechmacas nopa tlapiyali imetzcuayo nejmac para elis iaxca nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Quema se israelita temacas se tlacajcahualistli para ma onca tlayoltlalili nohuaya, nopa totajtzi catli nechmacas ieso huan ichiyajca nopa tlapiyali quiselis imetzcuayo nopa tlapiyali para iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Pampa na nijquixtilijtoc iyolixpa huan imetzcuayo nejmac tlen nopa tlapiyali catli quihuisohua noixpa para nechmacase, huan nijmacatoc Aarón huan itelpocahua para elis iniaxca nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Quena, ipan nopa tonal quema Aarón huan itelpocahua monextijque noixpa para mochihuase totajtzitzi, niquiniyocatlali ni partes para ma quicuaca tlen nochi tlacajcahualistli tlatlatili catli masehualme nechmacase na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Huan ipan nopa tonali quema niquintequitlali para ma elica totajtzitzi nitlanahuati para israelitame ma quinmacaca totajtzitzi ni partes pampa quintocarohua. Huan ya nopa monequi nopa totajtzitzi quiselise hasta ininteipan ixhuihua tlacajtiyase huan para nochipa.” ");
INSERT INTO nhwBl_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Huajca nica eltoc nopa tlanahuatilme para quenicatza ma tijmacaca TOTECO se tlacajcahualistli tlen harina, se tlacajcahualistli por tlajtlacoli huan se tlacajcahualistli para catli quihuica tlajtlacoli iixpa, huan se tlacajcahualistli para ma onca tlayoltlalili ihuaya. Nojquiya techilhuía catlique tlacajcahualistli monequi temacas se totajtzi para moiyocatlalis quema quiselía itequi para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Nochi ni tlanahuatilme TOTECO quimacac Moisés ipan nopa tepetl Sinaí quema nopa israelitame noja itztoyaj ipan nopa huactoc tlali, pampa nopona TOTECO techilhui para monequi ma tijhuicaca tlacajcahualistli iixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Ama xiquinhuica Aarón huan itelpocahua hasta campa ipuerta nopa yoyon tiopamitl. Huan xijhuica ininyoyo nopa totajtzitzi huan nopa aceite para tiquinaltis. Nojquiya xijhuica nopa becerro catli nechmacase quen se tlacajcahualistli por tlajtlacoli. Huan xijhuica nopa ome oquich borregojme huan nopa chiquihuitl ica pantzi catli amo quipiya tlasonejcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Huan xiquinilhui nochi nopa israelitame nojquiya ma mosentilica nopona.” ");
INSERT INTO nhwBl_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Huajca Moisés quichijqui nochi senquistoc quen TOTECO quinahuati. Huan quema mosentilijtoyaj nochi israelitame campa ipuerta nopa yoyon tiopamitl, ");
INSERT INTO nhwBl_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moisés quinilhui: “Ya ni catli TOTECO tlanahuatijtoc ma tijchihuaca.” ");
INSERT INTO nhwBl_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Huan teipa Moisés quichijqui ma monechcahuica Aarón huan itelpocahua huan quinpajpajqui ica atl. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Huan teipa quiquenti Aarón itlatzintlanyoyo catli huehueyac, huan quitlalili itzinquechilpica huan nojquiya quitlalili ipantzajca. Huan ipan nopa pantzajcayotl quitlali nopa seyoc ipantzajca catli amo quipixqui imax. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Teipa Moisés quitlalili nopa yolixpantzajcayotl catli quipixqui ibolsa huan nopona quitlalili nopa Urim huan nopa Tumim, nopa dados tlatzejtzeloltic tlen Toteco. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Huan teipa ipan itzonteco Aarón quitlalili icuatzajca catli eli quen se tzonyahuali. Huan ipan icuaixco quitlalili nopa piltepos patlactzi catli tlatzejtzeloltic huan catli tlachijchihuali ica oro catli quiixnextía para yaya nopa hueyi totajtzi. Quej nopa TOTECO quinahuati ma quitlalili Aarón. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Teipa Moisés quicuic nopa aceite catli quitequihuíaj para ica tlaiyocatlalíaj para elis iaxca Toteco, huan quipolo nochi tlamantli catli onca ipan nopa yoyon tiopamitl huan quej nopa quiniyocatlali para elise senquistoc para TOTECO iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Huan quiijtzelo nopa aceite ipan nopa tlaixpamitl chicompa hueltas para quiiyocatlalis para elis iaxca Toteco nopa tlaixpamitl huan nochi tlamantzitzi catli motequihuíaj ipan nopa yoyon tiopamitl. Nojquiya quiijtzelo ipan nopa hueyi paila huan catli ipan moquetzaj huan quej nopa quintlatzejtzelolchijqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Huan teipa nojquiya quitequili quentzi aceite ipan Aarón itzonteco para quiiyocatlalis para itequi. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Huan teipa Moisés sempa quinnotzqui ma monechcahuica Aarón itelpocahua huan quinquenti ininyoyo catli huehueyac, huan quintlalili inintzinquechilpica, huan nojquiya quintlalili inintzontzajcayohua. Huan nochi quichijqui quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Teipa quicuic nopa becerro para nopa tlacajcahualistli por tlajtlacoli, huan Aarón huan itelpocahua quitlalijque ininmax ipan itzonteco nopa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","16","Huan Moisés quimicti nopa tlapiyali huan ica imacpil quicuic se quentzi estli huan quiajalo nopa nahui icuacua nopa tlaixpamitl catli mocahuayaya campa inacastla. Huan nojquiya quiatzejtzelhui nopa tlaixpamitl para quitlatzejtzelolchihuas. Huan nopa estli catli mocajqui quitoyajqui tlalchi itzintla nopa tlaixpamitl. Teipa quicuic nopa tlachiyajcayotl catli mopantía ipan icuetlaxcol ihuaya nopa parte catli más hueyi tlen ieltapach, huan iome sosonechua ihuaya inintlachiyajcayo, huan quitencajqui iixpa TOTECO ipan tlitl ipan nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Huan nopa becerro inacayo huan icuetlaxo, huan icuetlaxcol ica icuitl, quitlatito ipan se lugar catli mocahua huejca tlen campa mochijtoyaj. Quichijqui senquistoc quen quinahuatijtoya TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Teipa quihualicac nopa oquich borrego para nopa tlacajcahualistli tlatlatili iixpa TOTECO. Huan Aarón huan itelpocahua quitlalijque ininmax ipan itzonteco nopa tlapiyali, ");
INSERT INTO nhwBl_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","huan Moisés quiquechtzontejqui huan quiatzejtzelhui yahualtic nopa tlaixpamitl ica ieso. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Teipa quihuejhuelo nopa oquich borrego. Huan nopa nacatl tlatectli ihuaya itzonteco huan ichiyajca quitlati ipan nopa tlaixpamitl para quimacas TOTECO ipan poctli. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Pero achtihui quipajpajqui icuetlaxcol huan imetzcuayo ica atl, huan teipa quitlati ipan nopa tlaixpamitl. Huan quej nopa, nochi nopa oquich borrego nejmaxtic tlatlac iixpa TOTECO. Huan nopa tlapiyali elqui se tlacajcahualistli tlatlatili catli mijyoti ajhuiyac para ya. Huan Moisés quimacac TOTECO nopa tlacajcahualistli ipan tlitl senquistoc quen quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Teipa Moisés quiixnexti nopa seyoc oquich borrego catli elqui se tlacajcahualistli para quiniyocatlalis Aarón huan itelpocahua, huan inijuanti quitlalijque ininmax ipan itzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Huan teipa Moisés quiquechtzontejqui nopa tlapiyali, huan quicuic se quentzi ieso huan quitlali Aarón ipan inacas nejmac. Huan nojquiya quitlalili ipan ihueyi xocpil catli inejmac huan ipan ihueyi macpil catli inejmac. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Teipa Moisés quinilhui itelpocahua Aarón ma monechcahuise huan nojquiya san se quitlali ipan ininnacas nejmac huan ininxocpilhua catli hueyi catli ininnejmac huan ipan ininmacpil catli hueyi catli nojquiya ininnejmac. Huan nopa estli catli mocajqui quiatzejtzelhui itzintla huan yahualtic nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Teipa quicuic nopa tlachiyajcayotl huan icuitlapil catli quipixqui ichiyajca. Nojquiya quicuic nopa tlachiyajcayotl catli mopantía ipan icuetlaxcol, ieltapach, huan nopa ome isosonechua huan imetzcuayo catli inejmac. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Huan tlen nopa chiquihuitl catli quipixqui pantzi catli amo quipixqui tlasonejcayotl catli eltoc iixpa TOTECO, Moisés quiquixti se pantzi, huan se pantzi catli tlamaneloli ica aceite, huan se pantzi catli sepantic huan cacatztic. Huan nochi ya ni quitlali ininpani nopa partes catli quisqui ipan nopa oquich borrego. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Huan nochi ni tlamantli quitlali imaco Aarón huan ipan ininmax itelpocahua para inijuanti ma quihuisoca iixpa TOTECO para quimacase. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Huan teipa sempa quicuic nopa tlamantli tlen ininmax, huan quitlati ipan nopa tlaixpamitl ihuaya nopa tlacajcahualistli tlatlatili para quimacas TOTECO. Huan ya ni, quena, elqui se tlacajcahualistli para quiniyocatlalis Aarón huan itelpocahua para inintequi tlen totajtzitzi. Huan mijyoti ajhuiyac para TOTECO. Ya ni elqui tlacajcahualistli catli quimacac TOTECO ipan tlitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Huan teipa Moisés quicuic nopa oquich borrego iyolix huan quimacac TOTECO quen se tlacajcahualistli tlahuisoli iixpa, pampa quihuiso iixpa nopona campa nopa tlaixpamitl. Huan teipa iyolix nopa tlapiyali mocajqui iaxca Moisés pampa quej nopa tlanahuati TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Teipa quicuic quentzi nopa aceite para teiyocatlalise huan quentzi nopa estli catli eltoya ipan tlaixpamitl huan ica quiatzejtzelhui iyoyo Aarón. Huan nojquiya quiatzejtzelhui ininyoyo itelpocahua Aarón. Huan quej nopa quichijqui ma elica tlaiyocatlalilme Aarón huan itelpocahua para quitequipanose TOTECO, huan nojquiya ininyoyo quiiyocatlalili para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Huan Moisés nojquiya quinilhui Aarón huan itelpocahua: “Xiquicxitica nopa nacatl ipan atl nechca ipuerta ni yoyon tiopamitl. Nopona ni calixpamitl, huan nica xijcuaca ihuaya nopa pantzi catli eltoc ipan nopa chiquihuitl catli quipiya nopa tlacajcahualistli para anmechiyocatlalise para TOTECO. Quena, xijchihuaca quen niquijtojtoc pampa nimechnahuatía para monequi amojuanti xijcuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Huan nopa nacatl huan pantzi catli noja mocahuas, monequi anquitlatise. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Huan amo hueli anquistehuase tlen ipuerta nopa yoyon tiopamitl para chicome tonali, pampa monequi chicome tonali para tlamis nochi catli monequi para nimechiyocatlalis para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Huan nochi ni tlamantli catli tijchijtoque, tijchijque pampa TOTECO quej nopa quinequiyaya ma tijchihuaca para quiixtzacuas amotlajtlacolhua iixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Huan sempa nimechnahuatía para tonaya huan tlayohua para chicome tonali monequi anmocahuase nechca ipuerta nopa yoyon tiopamitl. Quena, quej nopa TOTECO anmechnahuatijtoc para amo anmiquise.” ");
INSERT INTO nhwBl_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Huan Aarón huan itelpocahua quichijque nochi catli TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Panoc nopa chicome tonali para moiyocatlalise para TOTECO huan ipan ne chicueyi tonal Moisés quinnotzqui Aarón huan itelpocahua huan nochi nopa huehue tlacame catli tlayacanque ica israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Huan quiilhui Aarón: “Xijcui se becerro para tijmacas TOTECO quen se tlacajcahualistli por tlajtlacoli para ta. Huan nojquiya xijcui se oquich borrego para elis se tlacajcahualistli tlatlatili. Huan ni tlapiyalme monequi elise tlapajpacme. Amo quipiyase ipan inintlacayo niyon se tlamantli catli amo cuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Huan xiquinilhuica nopa israelitame ma quicuica se oquich chivo para ma quimacaca quen se tlacajcahualistli por tlajtlacoli. Huan nojquiya ma quicuica se becerro huan se pilborregojtzi catli sanoc quiaxitijtoque sesen xihuitl para quinmacase quen se tlacajcahualistli tlatlatili. Ni tlapiyalme monequi elise tlapajpacme. Amo quipiyase niyon se tlamantli catli amo cuali ipan inintlacayo. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Huan nojquiya xiquinilhui monequi quicuise se toro catli tlaxahua huan se oquich borrego para ma quimacaca quen se tlacajcahualistli para ma onca tlayoltlalili ihuaya TOTECO. Nojquiya monequi quihualicase se tlacajcahualistli tlen harina catli quicuechtilijtoque huan quichijtoque se harina huan quimanelojtoque ica aceite. Quena, nochi ya ni monequi xijchihuaca pampa ama TOTECO monextis ica amojuanti.” ");
INSERT INTO nhwBl_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Huajca nochi israelitame quihuicaque ni tlamantli catli quinnahuatijtoya Moisés campa nopa yoyon tiopamitl icalixpa. Huan nochi nopa israelitame monechcahuijque huan ijcatoyaj nopona iixpa TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Huajca Moisés quinilhui: “Quema ya anquichijtose nochi catli tlanahuatía TOTECO, monextis ihueyitilis ica amojuanti.” ");
INSERT INTO nhwBl_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Teipa Moisés quiilhui Aarón: “Ximonechcahui campa nopa tlaixpamitl huan xijmaca TOTECO nopa tlacajcahualistli por tlajtlacoli catli elis para ta motlajtlacolhua. Huan xijtencahua nopa tlacajcahualistli tlatlatili catli quiixtzacuas motlajtlacolhua iixpa. Teipa xijmaca TOTECO nopa tlacajcahualistli para quiixtzacuas inintlajtlacolhua nochi israelitame iixpa quen yaya tlanahuatijtoc.” ");
INSERT INTO nhwBl_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Huajca Aarón monechcahui campa nopa tlaixpamitl huan quimicti nopa becerro para se tlacajcahualistli por tlajtlacoli por ya itlajtlacol. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Huan itelpocahua quihualiquilijque nopa estli, huan Aarón quicuic se quentzi nopa estli ica imacpil huan quiajalo nopa nahui icuacua nopa tlaixpamitl. Huan nopa estli catli noja mocajqui quitoyajqui tlalchi itzintla nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Huan teipa quitlati nochi nopa tlapiyali ichiyajcayo, isosonechua huan nopa parte catli más hueyi tlen ieltapach. Nochi quimacac TOTECO ipan poctli quen yaya quinahuatijtoya ma quichihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Pero inacayo nopa tlapiyali huan icuetlaxo quitlati ipan se lugar huejca tlen campa timochijtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Huan teipa Aarón quimicti nopa tlapiyali catli elqui para tlacajcahualistli tlatlatili, huan itelpocahua quihuiquilijque nopa estli. Huan quiatzejtzelhui ica nopa estli yahualtic ipan nochi ielchiqui nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Huan quihuejhuelojque nopa tlapiyali huan quihuiquilijque Aarón itzonteco huan sesen tlatectli. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Teipa quipajpajqui icuetlaxcol huan imetzcuayo huan nojquiya quitencajqui ipan tlitl ipan nopa tlaixpamitl ihuaya nopa tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Teipa quihualicac nopa oquich chivo catli quihualicatoyaj nopa israelitame. Huan quimicti huan quitencajqui quen se tlacajcahualistli por tlajtlacoli para nopa israelitame inintlajtlacolhua. Nochi quichijque quen achtihui quichijqui ica nopa seyoc tlacajcahualistli por tlajtlacoli por ya. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Huan teipa quihualicac nopa tlacajcahualistli tlatlatili. Huan quitencajqui iixpa TOTECO senquistoc quen quiijto itlanahuatil. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Teipa quihualicac nopa tlacajcahualistli tlen harina. Huan quicuic se quentzi nopa harina catli quicuechtilijtoyaj tlen nopa tlacajcahualistli catli quihualicatoyaj, huan quitlati ipan nopa tlaixpamitl ihuaya nopa tlacajcahualistli tlatlatili catli quitencajque ica ijnaloc. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Teipa quiquechtzontejqui nopa toro catli quimati tlapoxonía huan nopa oquich borrego catli quimacayayaj nopa israelitame quen se tlacajcahualistli para ma onca tlayoltlalili ica TOTECO. Huan itelpocahua Aarón quihuiquilijque nopa estli, huan yaya quiatzejtzelo yahualtic huan itzintla nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Teipa quicuic nopa toro ichiyajca huan ichiyajca nopa oquich borrego. Huan quicuic nopa tlachiyajcayotl catli mopantía ipan inincuitlapil huan catli mopantía ipan inincuetlaxcol. Huan quicuic ininsosonechua huan nopa parte tlen inieltapach catli quipixqui ininchiyajca. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Huan nochi nopa partes itelpocahua quitlalijque ipan nopa tlapiyalme ininyolix para quimacase Aarón. Huan nochi nopa tlachiyajcayotl quitlati ipan nopa tlaixpamitl para quimacas TOTECO ipan poctli. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Pero ininyolix huan ininmetzcuayo catli inejmac, Aarón quitencajqui iixpa TOTECO quen se tlacajcahualistli tlahuisoli. Huan nochi Aarón quichijqui quen Moisés quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Huan Aarón quitlejcolti imax para campa itztoyaj nopa israelitame huan quintiochijqui. Huan quema ya quitencajtoya nopa tlacajcahualistli por tlajtlacoli, huan nopa tlacajcahualistli tlatlatili, huan nopa tlacajcahualistli para ma onca tlayoltlalili ica TOTECO, Aarón temoc tlen campa nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Huan Moisés huan Aarón calajque calijtic ipan nopa yoyon tiopamitl. Huan teipa quisque huan quintiochijque nopa israelitame, huan TOTECO ihueyitilis monexti iniixpa nochi nopa israelitame catli mosentilijtoyaj nopona. ");
INSERT INTO nhwBl_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Huan TOTECO quititlanqui tlitl tlen iixpa huan nimantzi quitlamitlati nochi nopa tlacajcahualistli huan nopa tlachiyajcayotl catli eltoya ipan nopa tlaixpamitl. Huan quema nopa israelitame quiitaque ya nopa, quitzajtzilijque TOTECO ica paquilistli huan motlancuaquetzque huan mohuijtzonque ica iniixayac hasta tlalchi. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Se tonal ome itelpocahua Aarón, inijuanti catli inintoca eliyaya Nadab huan Abiú, quicuique sese popochcomitl huan ipan quitlalijque tlitl catli amo tlatzejtzeloltic ihuaya copali huan quitlatijque iixpa TOTECO. Pero catli quichijque amo elqui quen TOTECO quinnahuatijtoya ma quichihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Huan TOTECO quititlanqui se tlitl huan quintlamitlati huan mijque nopona iixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Huan teipa Moisés quiilhui Aarón: ―TOTECO quinequiyaya techilhuis para quej ni panos quema quiijto: ‘Niquinnextilis para nitlatzejtzeloltic, nochi catli monechcahuíaj campa na. Huan nochi israelitame nechhueyitlalise.’ Huan Aarón amo molini. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Huan Moisés quinotzqui Misael huan Elzafán catli eliyayaj itelpocahua Uziel, itío Aarón, huan quinilhui: ―Xihualaca huan xiquinhuicaca amoteiximatcahua ininmijcatzitzi. Xiquinquixtica tlen nopa calixpamitl catli iixpa ni yoyon tiopamitl huan xiquinhuicaca huejca tlen campa timochijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Huan monechcahuijque huan quinhuicaque ininteiximatcahua ininmijcatzitzi, huan noja moquentijtoyaj ininyoyo catli huehueyac tlen totajtzitzi. Huan quinhuicaque huejca tlen campa timochijtoque quen Moisés quinnahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Teipa Moisés quincamanalhui Aarón huan nopa ome itelpocahua catli inintoca eliyaya Eleazar huan Itamar, huan quinilhui: ―Amo xichocaca niyon amo ximotequipachoca. Amo xijcahuaca amotzoncal ma nesis fiero, niyon amo xijtzayanaca amoyoyo. Pampa sintla anmotequipachose, TOTECO nojquiya anmechtzontlamiltis huan yaya nelía cualanis ihuaya nochi ni israelitame. Pero moicnihua, nochi nopa sequinoc israelitame, quena, hueli quinchoquilise Nadab huan Abiú huan hueli motequipachose por nopa tlitl catli TOTECO quititlanqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Pero amo hueli anquisase tlen nopona campa nopa yoyon tiopamitl. Sintla anquisase, anmiquise, pampa antlaiyocatlalilme para TOTECO por nopa aceite catli nimechajalti. Huan Aarón huan nopa ome itelpocahua quichijque nochi quen quinnahuati Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Teipa TOTECO quicamanalhui Aarón huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Ta huan motelpocahua amo hueli anquiijise vino o tlen hueli tlamantli tlailistli catli cococ quema ancalaquise ipan nopa yoyon tiopamitl. Sintla anquiijise, anmiquise. Ni tlanahuatili monequi anquitoquilise amojuanti huan nochi amoteipan ixhuihua catli tlacajtiyase para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Monequi anquimachilise catlique tlamantzitzi tlatzejtzeloltic para na huan catlique amo, huan catlique tlapajpactli noixpa huan catlique amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Huan monequi anquinmachtise nopa israelitame nochi notlanahuatil catli na, niamoTECO, nimechmacatoc ica Moisés.” ");
INSERT INTO nhwBl_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Teipa Moisés quincamanalhui Aarón huan nopa ome itelpocahua catli noja itztoyaj catli inintoca eliyaya Eleazar huan Itamar. Quinilhui: ―Xijcuica nopa harina catli noja mocahua tlen nopa tlacajcahualistli catli anquimacaque TOTECO ipan tlitl. Xijpiyaca cuidado para amo quipiyas tlasonejcayotl huan xijcuaca nechca ielchiqui nopa tlaixpamitl, pampa ya ni elis se tlacajcahualistli catli tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Huan monequi xijcuica huan xijcuaca nopona yoyon tiopan calijtic campa tlatzejtzeloltic. Huan nopa catli mocahua tlen nopa tlacajcahualistli tlen harina elis moaxca para motlacualis, Aarón, huan para inintlacualis motelpocahua. Quena, ni parte tlen nopa tlacajcahualistli catli anquitlatise iixpa TOTECO elis amoaxca, pampa quej nopa tlanahuatijtoc TOTECO ma nimechilhui. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Pero iyolix nopa tlapiyali catli anquihuisohuaj iixpa TOTECO huan imetzcuayo catli nojquiya anmechtocaros, hueli anquicuase ipan tlen hueli lugar catli tlapajpactli. Quena, amojuanti huan amooquichpilhua huan amosihuapilhua hueli anquicuase nopa iyolix huan imetzcuayo pampa amoaxca tlen nochi tlacajcahualistli para ma onca tlayoltlalili ica TOTECO catli israelitame temacaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Nopa israelitame monequi quihualicase imetzcuayo nopa tlapiyali catli anquitlejcoltise huan iyolix catli anquihuisose iixpa TOTECO para antemacase quema nojquiya anquitlatise nopa tlachiyajcayotl. Huan teipa nopa partes elis amoaxca. Quena, ni ome tlamantli mocahuas para ta huan para moconehua para nochipa pampa quej nopa tlanahuatijtoc TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Huan teipa Moisés tlatzintocac canque mocahua nopa oquich chivo catli quitencajque quen se tlacajcahualistli por tlajtlacoli huan quipanti para ya quitlatijtoyaj. Huan tlahuel cualanqui ihuaya Eleazar huan Itamar, nopa ome itelpocahua Aarón catli noja itztoyaj. Huan quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","―¿Para tlen amo anquicuajque nopa tlacajcahualistli por tlajtlacoli campa tlatzejtzeloltic tiopan calijtic? Pampa nelía eliyaya tlatzejtzeloltic huan TOTECO anmechmacac para anquiquixtise nopa tlajtlacoli catli israelitame quihuicaj iixpa huan para anquiixtzacuase inintlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Monectoya anquicuajtosquíaj yoyon tiopan calijtic campa tlatzejtzeloltic quen na nimechnahuatijtoya, pampa amo ya nopa tlacajcahualistli catli anquihuicaj ieso tiopan calijtic campa Más Tlatzejtzeloltic catli amo hueli anquicuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Pero Aarón quiilhui Moisés: ―Inijuanti quitencajque inintlacajcahualis para tlajtlacoli huan inintlacajcahualis tlatlatili iixpa TOTECO. Pero ica ininmiquilis ne sequinoc notelpocahua, na nimoilhui sintla tijcuasquíaj ama nopa tlacajcahualistli por tlajtlacoli, huelis amo quipactijtosquía TOTECO. Yeca amo nijcuajqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Huan quema Moisés quicajqui ya nopa, ayacmo cualanqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Huajca TOTECO sempa quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nhwBl_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Xiquinilhuica nopa israelitame para san hueli quicuase ni tlapiyalme catli ama nimechilhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Hueli quicuase catli quipiyaj iniisti maxaltic huan quicuajcuaj inintlacualis ome huelta. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Pero amo hueli anquincuase nopa camello, ");
INSERT INTO nhwBl_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","nopa cuatochi, ");
INSERT INTO nhwBl_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","huan nopa pesojtli, pampa masque ni tlapiyalme quicuajcuaj inintlacualis ome huelta, amo quipiyaj iniisti maxaltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","“Nojquiya amo hueli anquicuase nopa pitzo, pampa masque quipiya iisti maxaltic, amo quicuajcua ome huelta itlacualis, huan huajca niquita para amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","“Amo hueli anquicuase ininnacayo ni tlapiyalme niyon amo hueli anquiitzquise se itlacayo quema mictoc pampa amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“Huan tlen nochi michime huan tlapiyalme catli itztoque ipan atl, san hueli anquincuase catli quipiyaj inieltlapal huan ininpetlayo. Quena, masque anquinitzquise ipan hueyi atl o ipan se atlajtli san ni michime anquicuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Amo hueli anquincuase niyon se tlamantli catli itztoc ipan hueyi atl o ipan hueyame sintla amo quipiya ieltlapal huan ininpetlayo quen quipiyaj michime. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Nochi ni tlamantli anquiijiyase huan amo hueli anquinitzquise inintlacayo catli mictoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Huan sempa nimechilhuía ya ni: Amo xijcuaca niyon se tlamantli catli itztoc ipan atl sintla amo quipiya ieltlapal huan ipetlayo quen se michi. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“Huan nojquiya itztoque totome catli amo hueli anquincuase. Amo xijcuaca niyon se hueyi cuajtli, niyon se huactzi, niyon tzopilotl nechca atl, ");
INSERT INTO nhwBl_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","niyon se tlamantli tzopilotl, ");
INSERT INTO nhwBl_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","o niyon se tlamantli cacalotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Niyon amo xijcuaca nopa huejcapantic tototl avestruz, niyon nopa cuajtli tlen tlayohua, niyon nopa atototl catli chipahuac, o niyon se tlamantli cuajtli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Amo xijcuaca nopa tololojtli, niyon nopa cuamojmojtli catli hueyi, niyon nopa cuamojmojtli catli ijcatoc iijhuiyo ipan itzonteco, ");
INSERT INTO nhwBl_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","niyon nopa cuamojmojtli chipahuac, niyon nopa tototl yayahuic catli quincua michime, niyon nopa pelícano, niyon nopa tzopilotl catli quincua tlapiyalme catli mictoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Niyon amo xijcuaca nopa garza, niyon nopa cigüeña, niyon totome catli quipiyaj huejhueyi ininmetz, niyon tzoleme. Nochi ni tlapiyalme amo hueli anquincuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“Nojquiya monequi xiquinijiyaca nochi tlamantli sayolime catli patlanij huan quipiyaj nahui ininmetz. Amo xiquincuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Pero itztoque sequin tlamantli catli quipiyaj inieltlapal huan nahui iniicxihua catli hueli anquicuase. Sintla ipan ininmetz quipiyaj inintlancuaco catli quinpalehuíaj para huitonij, huajca quena, hueli anquincuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Hueli anquincuase nochi tlamantli pilchapoltzitzi, nochi chapolime catli huejhueyi, huan nochi chapolime catli quicuaj xihuitl huan quipiyaj inieltlapal. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Pero nochi nopa sequinoc sayolime huan chapolime catli quipiyaj nahui iniicxi, amo hueli anquincuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“Ni tlamantli quichihua para se masehuali elis amo tlapajpactli: “Sintla se masehuali quiitzquis itlacayo se tlen ni totome o sayoltzitzi catli mictoque, mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","“Huan sintla se masehuali quiitzquis itlacayo se tlen ni tlamantli tlapiyalme quema ya mictoc, monequi nimantzi quichicuenis iyoyo huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“Nojquiya anmochihuase amo antlapajpacme quema anquiitzquise itlacayo se tlapiyali catli amo senquistoc maxaltic iisti o amo quicuajcua ome huelta itlacualis. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","“Nojquiya amo huelis anquincuase tlapiyalme quen chichime catli amo quipiyaj senquistoc iniisti. Huan sintla se masehuali quiitzquis itlacayo se tlen ni tlapiyali catli mictoc mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Quena, quema se masehuali quiitzquis itlacayo se tlen ni tlapiyali catli mictoc monequi nimantzi quichicuenis iyoyo, pero noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“Huan tlen nopa tlapiyalme catli motlalohuaj tlalchi, ya ni catli amo cuali para anquincuase: sehueme, quimichime, temasolime, tusame, ");
INSERT INTO nhwBl_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","cocodrilome, axilime, topitzitzi huan tzonpetlachiquime. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","“Sintla se masehuali quiitzquis itlacayo se tlen ni tlapiyalme catli mictoc, mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“Nojquiya mocahuas amo tlapajpactli nochi tlamantli catli ipan huetzis nopa tlapiyali itlacayo. Quena, sintla nopa tlapiyali catli mictoc huetzis ipan se tlamantli cuahuitl, o se yoyomitl, o se cuetlaxtli o se coxtali, huajca nopa tlamantli mocahuas amo tlapajpactli. Monequis anquitlalise ipan atl huan mocahuas amo tlapajpactli hasta tlayohua, pero teipa elis tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“Huan sintla nopa tlapiyali huetzis ipan se tlamantli catli tlachijchihuali ica soquitl, huajca nochi tlamantzitzi catli quipixqui iijtico elise amo tlapajpactli, huan monequi anquitlapanase nopa comitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Huan sintla nopa atl catli ica quitlapajpacchihuaj catli amo tlapajpactli huetzis ipan se tlamantli tlacualistli o se tlamantli tlailistli, nopa tlamantli nojquiya mochihuas amo tlapajpactli pampa quiajsic nopa atl. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","“Sintla itlacayo se tlen ni tlapiyali catli mictoc huetzis ipan tlen hueli tlamantli horno catli tlachijchihuali ica soquitl, huajca nopa horno mocahuas amo tlapajpactli huan monequi anquisemanase. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“Huan sintla nopa tlapiyali huetzis ipan se ameli catli quipiya atl, huajca nopa atl mocahuas tlapajpactli, pero nopa masehuali catli quiquixtis nopa tlapiyali itlacayo, yaya, quena, mocahuas amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","“Huan sintla itlacayo nopa tlapiyali catli mictoc huetzis ipan xinachtli catli quicajtoyaj para quitocase ipan mila, huajca nopa xinachtli noja mochihuas tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Pero sintla itlacayo nopa tlapiyali catli mictoc huetzis ipan xinachtli catli xolontoc, huajca mocahuas amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“Huan sintla anquipiyaj se tlapiyali catli onca caquihuili para anquicuase pero nopa tlapiyali miquis ica cocolistli, huajca amo xiquitzqui itlacayo. Pampa sintla se masehuali quiitzquis itlacayo, nopa masehuali mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Huan sintla se masehuali quicuas inacayo o quihuicas itlacayo nopa tlapiyali, monequi nimantzi quichicuenis iyoyo, pero noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“Monequi xiquinijiyaca nochi tlapiyalme catli mohuahuatatzaj tlalchi huan amo hueli anquincuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","“Amo hueli anquincuase nochi tlamantli catli ica ininyolix mohuahuatatzaj tlalchi, niyon nopa cohuame catli nejnemij ica nahui iniicxi. Nojquiya amo hueli anquincuase nopa tlapiyalme catli mohuahuatatzaj tlalchi huan quipiyaj miyac iniicxihua, pampa nelía amo tlapajpacme noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Amo xijtoxoma niyon se tlen ni tlapiyalme pampa anmechchihuas amo tlapajpacme. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Na niamoTECO Dios. Nijnequi ximomocuitlahuica cuali huan xielica antlatzejtzeloltique pampa na nitlatzejtzeloltic. Huajca amo xiquitzquica niyon se ni tlapiyalme catli mohuahuatatzaj tlalchi pampa anmechchihuas amo antlapajpacme noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Na niamoTECO catli nimechquixti ipan tlali Egipto para nielis niamoTeco Dios. Huajca ama, monequi anelise antlatzejtzeloltique pampa na nitlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“Huajca nica nimechilhuijtoc nopa tlanahuatilme catli monequi anquitoquilise ica nochi totome, tlapiyalme, tlamantli catli itztoque ipan atl huan tlamantli catli mohuahuatatzaj tlalchi. ");
INSERT INTO nhwBl_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ni tlanahuatilme anmechpalehuise para anquimatise tlaque eli se tlapiyali catli tlapajpactli huan tlaque eli se tlapiyali catli amo tlapajpactli. Huan nojquiya anmechpalehuis para anquimatise tlaque tlapiyali hueli anquicuase huan tlaque tlapiyali amo hueli anquicuase.” ");
INSERT INTO nhwBl_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Huan TOTECO nojquiya quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Xiquinilhui nopa israelitame ni tlanahuatilme. Quema se sihuatl tlanemiltis huan quitlacatiltis se oquichpil, huajca nopa sihuatl mocahuas amo tlapajpactli para chicome tonali. Monequi quichihuas san se quen quichihua quema esotemo. ");
INSERT INTO nhwBl_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Huan ipan nopa chicueyi tonal, quiyecapantequilise se quentzi icuetlaxo ipan ipiltlacayo nopa piloquichpiltzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Teipa nopa piloquichpiltzi inana amo huelis quiitzquis niyon se tlamantli catli tlatzejtzeloltic para seyoc 33 tonali pampa noja quipiya esotemolistli. Niyon amo hueli calaquis tiopan calijtic hasta tlamis nopa tonali para motlapajpacchijtos. ");
INSERT INTO nhwBl_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","“Pero sintla nopa sihuatl quitlacatiltis se sihuapil, huajca mocahuas amo tlapajpactli para ome semana. Huan monequi quitlepanitas nopa tlanahuatili para quema esotemo. Huan teipa quichiyas seyoc 66 tonali para motlapajpacchihuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“Huan quema ya quitlamiltijtos nopa tonali para motlapajpacchihuas, huajca masque tlacatqui oquichpil o sihuapil, inana monequi quihuicas campa nopa totajtzi ipan ipuerta nopa yoyon tiopamitl se pilborregojtzi catli sanoc quipiya se xihuitl para quimacas quen se tlacajcahualistli tlatlatili. Nojquiya monequi quihuicas se paloma o se pichontzi para nechmacas quen se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","“Huan nopa totajtzi quintencahuas noixpa na, niamoTECO, huan nechixtzacuilis itlajtlacol nopa sihuatl noixpa. Huan quej nopa, nopa sihuatl motlapajpacchihuas tlen nopa esotemolistli. Quena, ya ni eli nopa tlanahuatili catli monequi quitoquilis quema quitlacatiltijtos se conetl masque oquichpil o sihuapil. ");
INSERT INTO nhwBl_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","“Pero sintla nopa sihuatl eli tlahuel teicneltzi huan amo quipiya tomi para nechmacas se pilborregojtzi, huajca hueli quinhuicas ome pichones o ome palomajme. Se tlen nopa ome nechmacas quen se tlacajcahualistli tlatlatili, huan nopa seyoc nechmacas quen se tlacajcahualistli por tlajtlacoli. Huan quej nopa, nopa totajtzi nechixtzacuilis itlajtlacol nopa sihuatl, huan ya mocahuas tlapajpactli noixpa.” ");
INSERT INTO nhwBl_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","TOTECO quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nhwBl_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Quema anquiitase pehua temi icuetlaxo se masehuali, o nesi para pehuas cocome, o nesi para pehuas mochihuas chipahuac icuetlaxo, huelis quinequi pehuas nopa tlacayo palanca cocolistli catli tlamahua. Huajca monequi anquihuicase nopa masehuali iixpa nopa totajtzi Aarón o iixpa se tlen itelpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Huan nopa totajtzi quitlachilis ica miyac cuidado campa monextijtoc nopa cocolistli. Huan sintla campa quipiya cocolistli, itzoyo pejtoc mocuepa chipahuac huan sintla nopa cocotl nesi para pejtoc tlatzintla icuetlaxo, huajca xijmachilica cuali para quipiya nopa tlacayo palanca cocolistli. Huan huajca nopa totajtzi monequi teyolmelahuas para amo tlapajpactli nopa masehuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“Huan sintla iyoca ipan icuetlaxo nopa masehuali quinpiya manchas catli chijchipahuac pero amo palantoc hasta más huejcatla, huan itzoyo amo mocueptoc chipahuac, monequi nopa totajtzi quitzacuas nopa masehuali iseltzi para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Huan quema quiaxitis chicome tonali, nopa totajtzi sempa quitlachilis. Huan sintla nesis para nopa cocotl amo más mohueyilijtoc ipan icuetlaxo, huajca quitzacuas para seyoc chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Huan quema sempa ajsis nopa tonali chicome, monequi sempa quitlachilis ica miyac cuidado, huan sintla quiitas para nopa cocotl amo más mohueyilía ipan icuetlaxo huan pejtoc pachihui, huajca nopa totajtzi teyolmelahuas para nopa masehuali eltoc tlapajpactli noixpa. Pampa catli quipixtoya eliyaya san tlen hueli cocotl. Huan nopa masehuali monequi quichicuenis iyoyo, huan quej nopa sempa elis tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Pero sintla nopa cocotl mohueyilis teipa quema nopa totajtzi quiijto para tlapajpactli, huajca monequi sempa hualas iixpa nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Huan sintla nopa totajtzi quiijtos para nopa cocotl mohueyilijtoc, huajca teyolmelahuas para nopa masehuali amo tlapajpactli pampa quipiya tlacayo palanca cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Quema se masehuali quinpiyas cocome ipan itlacayo, monequi quihuicase iixpa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Huan nopa totajtzi quitlachilis ica miyac cuidado, huan sintla quiitas para campa temitoc icuetlaxo pehua mocuepas chipahuac, huan itzoyo mocueptoc chipahuac, huan sintla tlanemijya nesi inacayo tlapojtoc campa temitoc, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","huajca ya nopa eli nopa tlacayo palanca cocolistli catli huejcajya quiajsitoc ipan icuetlaxo. Huan huajca nopa totajtzi monequi teyolmelahuas para nopa masehuali amo tlapajpactli. Amo monequi quitzacuas iseltzi, para más quitlachilise pampa quimati melahuac quipiya nopa cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Pero sintla nopa totajtzi quiitas para nopa mancha catli nopa masehuali quipiya ya mohueyilijtoc huan ya ajsitoc campa hueli tlen iicxihua huan hasta ipan itzonteco, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","huajca quiijtos para nopa masehuali tlapajpactli, pampa nochi ya mochijtoc chipahuac huan ya panotoc nopa palanca cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Pero sintla ipan icuetlaxo quinpiya cocome tlapojtoc catli nesi inelnacayo, huajca amo tlapajpactli, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","pampa tlapojtoc icocohua huan nesi inelnacayo huan ya ni eltoc tlacayo palanca cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“Pero sintla nopa masehuali catli quipixqui se cocotl tlapojtoc huan nesiyaya inacayo teipa quipantis para icoco mocueptoc chipahuac, huajca monequi sempa yas campa nopa totajtzi para ma quitlachilis. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Huan nopa totajtzi quitlachilis huan sintla campa cocojtoc nelía nesi chipahuac, huajca nopa totajtzi teyolmelahuas para tlapajpactli nopa masehuali catli quinpixqui cocome. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Quema icuetlaxo se masehuali quipiyas se cocotl campa temalquisayaya huan teipa mochicahuas, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","pero mocahuas temitoc huan nesis chipahuac, o nesi chichiltic huan chipahuac, huajca nopa masehuali monequi yas campa nopa totajtzi para ma quitlachili. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Huan sintla nopa totajtzi quiitas para nopa cocotl ajsi huejcatla, tlatzintla nopa cuetlaxtli, huan para itzoyo pehua para elis chipahuac, huajca monequi teyolmelahuas para nopa masehuali amo tlapajpactli, pampa quipiya nopa tlacayo palanca cocolistli catli pejqui ica se cocotl ica temali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Pero sintla nopa totajtzi quitlachilis huan amo quipantis itzoyo catli nesi chipahuac, huan sintla nopa cocotl amo eltoc huejcatla, huan san quentzi chipahuixtoc, huajca monequi quitzacuas iseltzi para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Huan sintla itlamiya nopa chicome tonali, nopa cocotl mohueyilis achi más, huajca nopa totajtzi quiijtos para nopa masehuali amo tlapajpactli pampa quipiya se cocotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Pero sintla campa nesi chipahuac san se mocahua, huan amo más mohueyilijtoc, huajca quimachilise para san mocahua lipintic icuetlaxo campa pachijqui nopa cocotl. Huan nopa totajtzi quiijtos para nopa masehuali eli tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Sintla se acajya motlatis ipan itlacayo ica tlen hueli tlamantli, huan sintla campa motlatijtoc teipa nesis chipahuac, o nesis chichiltic huan chipahuac, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","huajca nopa totajtzi quitlachilis ica miyac cuidado campa motlatijtoc nopa masehuali. Huan sintla quiitas para cocojtoc achi huejcatla hasta tlatzintla cuetlaxtli huan itzoyo ya mocueptoc chipahuac, huajca ya quipiya nopa tlacayo palanca cocolistli catli yolqui campa motlati. Huan nopa totajtzi monequi quiijtos para nopa masehuali amo tlapajpactli pampa quipiya nopa tlacayo palanca cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Pero sintla nopa totajtzi quiitas para nopa masehuali amo quipiya itzoyo chipahuac campa cocojtoc, huan amo más huejcatla, san ipan nopa cuetlaxtli huan nesi para ya pachijtiya, huajca san quitzacuas iseltzi para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Pero quema tlantos nopa chicome tonali, monequi sempa quitlachilis nopa totajtzi. Sintla quiitas para campa cocojtoya achi más mohueyilijtoc, huajca nopa totajtzi quiijtos para, quena, nopa masehuali quipiya tlacayo palanca cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Pero sintla campa cocojtoc amo más mohueyilijtoc huan nesi para ya pachijtoc quentzi, huajca nopa totajtzi quiijtos para tlapajpactli nopa masehuali noixpa. San quipiya ya nopa pampa motlati huan lipintic. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Sintla se tlacatl o se sihuatl quipiya se cocotl ipan itzonteco o ipan itentzo, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","huajca monequi yas campa nopa totajtzi para ma quitlachili. Huan sintla nopa cocotl nesis para panotoc tlatzintla nopa cuetlaxtli, huan sintla quiitas para nopona quipiya itzoyo catli nesi costic huan pitzantzi, huajca nopa totajtzi quiijtos para nopa masehuali amo tlapajpactli pampa quipiya se tlamantli cocotl catli mochijtoc nopa tlacayo palanca cocolistli ipan itzonteco o ipan itentzo. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Pero sintla nopa totajtzi quiitas para nopa cocotl amo ajsitoc tlatzintla icuetlaxo huan noja quipiya itzoyo catli yayahuic, huajca nopa totajtzi san quitzacuas nopa masehuali iseltzi para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Huan quema tlantos nopa chicome tonali, nopa totajtzi monequi sempa quitlachilis. Huan sintla quiitas para nopa cocotl amo mohueyilijtoc huan amo pejtoc quipiyas itzoyo catli nesi costic huan nesi para amo ajsitoc tlatzintla icuetlaxo nopa masehuali, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","huajca nopa totajtzi quichihualtis ma quihuatani itentzo. Pero yaya amo hueli quihuatanis campa cocojtoc. Quema tlami mohuatanis, monequi noja mocahuas tzactoc para seyoc chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Huan ipan nopa chicome tonal nopa totajtzi sempa quitlachilis. Huan sintla quiitas para nopa cocotl amo mohueyilijtoc, huan nesi para amo ajsitoc huejcatla ipan icuetlaxo, huajca nopa totajtzi quiijtos para nopa masehuali eltoc tlapajpactli. Huan teipa quema ya quichicuenijtos iyoyo, nopa masehuali mocahuas tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Pero sintla nopa cocotl mohueyilis quema ya quiijto para tlapajpactli, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","huajca nopa totajtzi monequi sempa quitlachilis. Huan ama, quena, sintla mohueyilijtoc, amo monequi quipantis itzoyo catli costic, pampa ya nesi nopa masehuali amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Pero sintla quiitas para nopa cocotl amo mohueyilía huan ya pejtoc para monextía itzoyo catli yayahuic, huajca quiijtosnequi ya pachijtoc nopa cocotl, huan tlapajpactli nopa masehuali. Huajca nopa totajtzi quiijtos para tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Huan quema se tlacatl o se sihuatl pehuas para quipiyas ipan icuetlaxo cocome catli nesi chipahuac, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","huajca nopa totajtzi quitlachilis icuetlaxo nopa masehuali ica miyac cuidado. Sintla quiitas nopa cocotl san se quentzi chipahuac, huajca amo ya nopa tlacayo palanca cocolistli. San quipiya tlen hueli cocolistli catli quiajsic ipan icuetlaxo huan tlapajpactli eli nopa tlacatl noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Sintla se masehuali tepehuis nochi itzoncal hasta ayacmo mocahuas niyon se, huajca nopa masehuali amo quipiya tlacayo palanca cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Huan sintla se masehuali tepehuis itzoncal icuaixco huan ipan icuajtol, huajca ya nojquiya tlapajpactli, amo quipiya cocolistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Pero sintla campa tepehui itzoncal eltos se cocotl catli nesis chipahuac huan chichiltic, huajca quiijtosnequi pejtoc tlacayo palanca cocolistli campa tepejtoc itzoncal. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Huajca monequi nopa totajtzi quitlachilis campa yoli nopa cocotl ipan itzonteco, o icuaixco. Sintla quiitas para nesi chipahuac huan chichiltic quen nopa tlacayo palanca cocolistli, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","huajca ya nopa quipiya huan amo tlapajpactli. Huan nopa totajtzi monequi quiijtos para nopa masehuali melahuac quipiya tlacayo palanca cocolistli ipan itzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Se masehuali catli quipiya tlacayo palanca cocolistli monequi quihuicas iyoyo tzayantoc, huan amo huelis moxilhuis. Monequi motentzacuas huan monequi tzajtzitinemis: ‘Amo nitlapajpactli. Amo nitlapajpactli.’ ");
INSERT INTO nhwBl_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Huan masque nopa cocolistli huejcahua ipan itlacayo, monequi itztos iseltzi huejca tlen campa mochijtoque ne sequinoc masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Huan sintla se iyoyo o itlaque se masehuali pojyajtoc, o quipiya se mancha monequi quitlachilis nopa totajtzi, masque eltoc catli tlachijchihuali ica lino o ica borregojme iniijhuiyo. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Masque nopa mancha eltoc ipan nopa icpatl catli ijcatoc o huilantoc ipan nopa yoyomitl, o masque nopa yoyomitl, o tlamantli catli pojyajtoc tlasencahuali ica tlapiyalme inincuetlaxo; sintla yoli se mancha, huajca xijhuicaca campa nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Huan sintla nesi quentzi xoxohuic o quentzi chichiltic nopa mancha catli yoli ipan nopa yoyomitl o nopa tlamantli catli quichijtoque ica cuetlaxtli, huajca campa nopa mancha ya pejtoc nopa tlacayo palanca cocolistli, huan monequi quihuicase iixpa nopa totajtzi para ma quitlachili. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Huan nopa totajtzi quitlachilis nopa yoyomitl, o nopa tlamantli, huan quiiyocatlalis para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Huan quema ajsis tonali chicome, nopa totajtzi sempa quitlachilis nopa mancha. Huan sintla quiitas para mohueyilijtoc ipan nopa yoyomitl o ipan nopa cuetlaxtli, huajca quiijtosnequi para eli se mancha tlen tlacayo palanca cocolistli catli nelía fiero. Huajca nopa tlamantli mocahuas amo tlapajpactli masque tlaxinepaloli ipan nopa yoyomitl, o mopantía ipan se tlamantli tlen cuetlaxtli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Huajca nopa yoyomitl catli tlachijchihuali ica lino, o ica borregojme iniijhuiyo, o nopa tlamantli tlen cuetlaxtli catli quipiya nopa mancha monequi quitlatise pampa quipiya nopa tlacayo palanca cocolistli catli nelía fiero. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Pero sintla quema tlamis chicome tonali, nopa totajtzi quitlachilis huan quiitas para nopa mancha amo más mohueyilijtoc, ");
INSERT INTO nhwBl_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","huajca quinnahuatis catli quihualicaque ma quichicuenica nopa tlamantli catli quipiya nopa mancha, huan sempa quiiyocatlalis seyoc chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","“Huan quema ya quipajpactose, nopa totajtzi quitlachilis sempa, huan sintla nesis para nopa mancha noja mocajtoc huan amo quipatlatoc itlachiyalis, huajca nopa tlamantli monequi quitlatise masque amo mohueyilijtoc más pampa quipiya nopa tlacayo palanca cocolistli. Masque nopa mancha san ajsi ipan se lado o ajsi ipan nochi ome lados, monequi xijtlatica. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Pero sintla nopa totajtzi sempa quitlachilis huan quiitas para nopa mancha ayacmo más nesi quen achtihui, huajca san quitejtequis huan quiquixtis campa monextijtoc nopa mancha ipan nopa yoyomitl, o cuetlaxtli o ipan nopa tlamantli catli tlaxinepaloli. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Pero sintla nopa mancha sempa monextis campa hueli ipan nopa yoyomitl, o ipan nopa tlamantli tlen cuetlaxtli, huajca nopa tlamantli catli quipiya mancha monequi quitlatise. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Pero sintla quema ya quichicuenijtose nopa yoyomitl o nopa tlamantli tlen cuetlaxtli ayacmo monextis nopa mancha, huajca san monequi quichicuenise seyoc huelta, huan teipa mocahuas tlapajpactli huan sempa huelis quitequihuise. ");
INSERT INTO nhwBl_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","“Huajca ya ni elqui nopa tlanahuatili para nopa tlacayo palanca cocolistli catli monextía ipan yoyomitl catli tlachijchihuali ica lino, o ica borregojme iniijhuiyo, o ica cuetlaxtli, o monextijtoc ipan sequinoc tlamantli catli tlachijchihuali ica tlapiyalme inincuetlaxo. Quena, ya ni nopa tlanahuatili catli quitequihuise para quiijtose sintla nopa tlamantli eli tlapajpactli o eli amo tlapajpactli.” ");
INSERT INTO nhwBl_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Ya ni nopa tlanahuatilme para se masehuali catli quipixtoya nopa tlacayo palanca cocolistli huan quinequi hualas campa nopa totajtzi para motlapajpacchihuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nopa totajtzi monequi yas campa mocahua nopa cocoxquetl huejca tlen campa anmochantijtoque para quitlachilis ica miyac cuidado. Sintla quiitas para ya pachijtoc campa quipixqui nopa cocotl, ");
INSERT INTO nhwBl_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","huajca tlajtlanis ma quihuiquilica ome totome catli tlapajpactli huan catli anquipiyaj caquihuili para anquicuase. Tlajtlanis ma quinhuiquilica nepa campa itztoc nopa cocoxquetl ihuaya tiocuahuitl, se icpatl catli chichiltic huan se imacuayo nopa xihuitl catli itoca hisopo. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Teipa nopa totajtzi tlanahuatis ma quiquechtzontequica se tlen nopa ome totome. Quena, monequi quiquechtzontequis ipan se comitl catli tlachijchihuali ica soquitl huan quipiya atl tlen se ameli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Huan quicuis ica nopa tiocuahuitl, huan nopa icpatl catli chichiltic huan imacuayo nopa hisopo xihuitl huan nopa seyoc piltototzi catli noja itztoc huan san sejco quinxolonis ica nopa achtihui tlapiyali ieso ipan nopa comitl catli quipiya atl catli huala tlen se ameli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Huan teipa ica nopa tlamantli catli xolontoc quiatzejtzelhuis nopa totajtzi chicome huelta nopa masehuali catli motlapajpacchihuas tlen icocolis. Huan teipa quiijtos para tlapajpactli. Huan nopa tototl catli noja itztoc quimajcahuas para ma patlantinemi campa cuatitlamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Teipa nopa masehuali catli ya motlapajpacchijtoc, monequi quichicuenis iyoyo, huan quihuatanis itzoncal. Monequi maltis huan sempa calaquis para itztos campa nochi sequinoc israelitame mochijtoque. Pero noja ayamo huelis calaquis ipan ichaj tlen yoyomitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Huan ipan nopa chicome tonal, nopa masehuali monequi sempa quitequis nochi itzoncal, itentzo huan iixtentzoyo. Teipa sempa quichicuenis iyoyo huan maltis, huan ica ya nopa, motlapajpacchihuas tlen nopa cocolistli catli quipixtoya. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Huan ipan tonali chicueyi, quincuis eyi pilborregojtzitzi catli quipiyaj sesen xihuitl huan niyon se tlamantli catli amo cuali quipiyaj ipan inintlacayo. Monequi ome oquichme huan se sihuatzi catli cuali inintlacayo. Nojquiya quicuis chicome litro harina catli nelcuechtic huan tlamaneloli ica aceite para se tlacajcahualistli tlen harina, huan ihuaya quihuicas tlajco litro aceite. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Huan nopa totajtzi catli tetlapajpacchihua, quihuicas nopa masehuali catli motlapajpacchihuas noixpa, niamoTECO. Huan ihuaya quihualicas nochi nopa tlamantzitzi catli motequihuis, huan temacas noixpa na, niamoTECO nepa campa ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Teipa nopa totajtzi quicuis se tlen nopa piloquich borregojtzitzi huan nopa tlajco litro aceite huan quitencahuas noixpa quen se tlacajcahualistli para nopa masehuali catli quihuica tlajtlacoli. Huan para nechmacas monequi quinhuisos noixpa, niamoTECO. Huan elis quen se tlacajcahualistli tlahuisoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Huan teipa nopa totajtzi quiquechtzontequis nopa pilborregojtzi nopona campa yoyon tiopan puerta campa quinmictíaj nopa tlapiyalme para tlacajcahualistli por tlajtlacoli huan para tlacajcahualistli tlatlatili. Huan nopa tlacajcahualistli por tlajtlacoli huan ni tlacajcahualistli para catli quihuica tlajtlacoli noixpa elis iaxca nopa totajtzi para tlacualistli pampa tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“Huan nopa totajtzi quicuis se quentzi ieso nopa tlapiyali catli quitencajtoc quen se tlacajcahualistli para catli quihuica tlajtlacoli noixpa huan nopa estli quiajalos ipan inacas nejmac nopa masehuali catli motlapajpacchihuas. Nojquiya quiajalos ipan imacpil catli hueyi tlen ima nejmac huan ipan ixocpil catli hueyi tlen iicxi nejmac. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","“Teipa nopa totajtzi quicuis nopa aceite huan quitecas quentzi ipan tlen ya imaopochco. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Huan teipa nopa totajtzi quixolonis imacpil tlen ima nejmac ipan nopa aceite huan ica imacpil tlaatzejtzelhuis chicome huelta noixpa na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Huan ica nopa aceite catli noja mocahuas ipan nopa totajtzi imax, quiajalos se quentzi inacas nejmac nopa masehuali catli motlapajpacchihuas. Huan nojquiya quiajalos ipan imacpil catli hueyi tlen ima nejmac huan ipan ixocpil catli hueyi tlen iicxi nejmac. Huan nojquiya quitlalis aceite ipan nopa estli tlen nopa tlacajcahualistli para catli quihuica tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Huan nopa aceite catli noja mocahuas imaco nopa totajtzi quitequihuis para quiajalos ipan itzonteco nopa masehuali catli motlapajpacchihuas huan nechixtzacuilis itlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Teipa nopa totajtzi nechmacas nopa tlacajcahualistli por tlajtlacoli para quiixtzacuas itlajtlacolhua nopa masehuali catli quitlapajpacchihua tlen nopa cocolistli catli quichijtoya amo tlapajpactli. Huan teipa quimictis nopa tlapiyali catli nechmacas quen se tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Huan nechmacas ipan tlaixpamitl nopa tlacajcahualistli tlatlatili ihuaya nopa tlacajcahualistli tlen harina. Huan ica nochi ya ni, nopa totajtzi nechixtzacuilis nopa masehuali itlajtlacolhua, huan yaya mocahuas tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Pero sintla nopa masehuali eli tlahuel teicneltzi huan amo huelis quincohuas ome pilborregojtzitzi, huajca hueli nechmacas setzi pilborregojtzi quen se tlacajcahualistli para catli quihuica tlajtlacoli, pero achtihui quihuisos noixpa, niamoTECO, para se tlacajcahualistli tlahuisoli para nechixtzacuilis itlajtlacolhua. Huan para nopa tlacajcahualistli tlen harina, san quihualicas ome kilo huan tlajco harina catli tlamaneloli ica aceite, ihuaya se tlajco litro aceite. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","“Nojquiya quinhuicas ome pichones o ome palomas quen quiitas para quiaxilía itomi. Huan se tlen nopa ome totome elis para nechmacas quen se tlacajcahualistli por tlajtlacoli, huan nopa seyoc nechmacas quen se tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Nochi ya nopa monequi quihuicas ipan nopa chicueyi tonal. Huan quimactilis nopa totajtzi nopona noixpa campa ipuerta nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Huan nopa totajtzi quicuis nopa pilborregojtzi catli nechmacas na, niamoTECO, quen se tlacajcahualistli para catli quihuica tlajtlacoli. Nojquiya quicuis nopa tlajco litro aceite, huan elis quen se tlacajcahualistli catli quihuijhuisos noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Teipa quiquechtzontequis nopa pilborregojtzi para se tlacajcahualistli para catli quihuica tlajtlacoli, huan quicuis se quentzi ieso huan quiajalos ipan inacas nejmac nopa masehuali catli quipajpaca huan quiajalos ipan imacpil catli hueyi tlen ima nejmac huan ixocpil catli hueyi tlen iicxi nejmac. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","“Teipa nopa totajtzi quicuis nopa aceite huan quitecas se quentzi ipan imax catli iopoch. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Huan teipa quixolonis imacpil tlen ima nejmac huan ica nopa aceite tlaatzejtzelhuis chicome huelta noixpa, na niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Nojquiya nopa totajtzi quicuis quentzi aceite catli ipan imax catli iopoch huan quiajalos inacas nejmac nopa masehuali catli motlapajpacchihua. Nojquiya quiajalos ipan imacpil catli hueyi tlen ima nejmac huan ipan ixocpil catli hueyi tlen iicxi nejmac. San se quiajalos campa quiajalo ieso nopa tlapiyali catli quitencajque para tlacajcahualistli para catli quihuica tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Huan nopa aceite catli noja mocahuas ipan imax nopa totajtzi, quiajalos ipan itzonteco nopa masehuali catli motlapajpacchihua. Ya nopa nechixtzacuilis itlajtlacol, na niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“Teipa nopa totajtzi nechmacas se tlen nopa palomas o nopa pichones, catli quiaxili itomi nopa masehuali para quicohuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Nechmacas se quen se tlacajcahualistli por tlajtlacoli huan nopa seyoc nechmacas quen se tlacajcahualistli tlatlatili, huan ihuaya nechmacas nopa tlacajcahualistli tlen harina. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","“Huajca ya ni elqui nopa tlanahuatilme catli monequi quitoquilis se masehuali catli ayacmo quipiya tlacayo palanca cocolistli huan amo quiaxilis para temacas se tlacajcahualistli patiyo para ica motlapajpacchihuas.” ");
INSERT INTO nhwBl_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nhwBl_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Quema ya anajsitose ipan tlali Canaán catli na nimechmacatoc para amoaxca huan na nijtlalis ipan se cali se mancha catli nesi para amo san axoloquistoc pero quipiya se hueyi cocolistli, ");
INSERT INTO nhwBl_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","huajca nopa masehuali catli iaxca nopa cali monequi yas quiitati nopa totajtzi huan quiilhuis: ‘Na niquita para ipan nochaj pejtoc mopannextía se mancha tlen nopa hueyi cocolistli.’ ");
INSERT INTO nhwBl_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“Huan quema nopa totajtzi ayamo calaqui ipan nopa cali, tlanahuatis ma quisaca nochi catli itztoque nopona huan ma quiquixtica nochi tlamantzitzi catli calijtic eltoc. Quej nopa amo quiijtos para amo tlapajpacme nochi nopa masehualme huan nopa tlamantzitzi catli nopona onca. Huan teipa quema ya quistose, nopa totajtzi calaquis huan quitlachilis nopa mancha catli mopannextijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","“Huan sintla nopa totajtzi quiitas para nopona campa coyontoc nopa tlapepecholme mopannextijtoque manchas catli nesij chichiltique o xoxohuique huan nesij para calactoque hasta huejcatla ipan tlapepecholi, ");
INSERT INTO nhwBl_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","huajca nopa totajtzi quisas huan quitzacuas nopa cali para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Huan quema ajsis nopa chicome tonal, nopa totajtzi monequi sempa hualas quitlachiliqui. Sintla quiitas para nopa mancha mohueyilijtoc ipan nopa tlapepecholi, ");
INSERT INTO nhwBl_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","huajca tlanahuatis ma quiquixtica nopa teme ipan tlapepecholi campa mopannextijtoc nopa mancha, huan monequi quimajcahuatij huejca tlen campa anmochijtoque ipan se lugar catli amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Huan nojquiya tlanahuatis ma quihuatanica nopa tlapepecholi yahualtic campa eltoya nopa mancha. Huan nochi nopa soquitl huan tlaltejpoctli quicahuatij huejca tlen campa anmochijtoque ipan se lugar catli amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Teipa nopa tlacame quicuise sequinoc teme para quitlalise ipan nopa lugar campa quiijcuinijque nopa teme catli quipiyayayaj manchas. Huan nojquiya quitlalise yancuic soquitl para quitlatzquiltise nopa tetl. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Pero sintla nopa mancha sempa mopannextis ipan nopa cali quema ya quipatlatose nopa teme, huan ya quihuatanijtose nopa tlapepecholi huan ya quitlalilijtose soquitl catli yancuic, ");
INSERT INTO nhwBl_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","huajca nopa totajtzi calaquis huan sempa quitlachilis ica miyac cuidado. Huan sintla quiitas para nopa mancha mohueyilijtoc ipan nopa tlapepecholi, huajca quiijtosnequi ya pejtoc nopa hueyi cocolistli catli más fiero ipan nopa cali. Huan nopa cali elis amo tlapajpactli huan quej nopa mocahuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Huajca monequi ma quitlamiltica nopa cali huan nochi tetl huan cuahuitl huan soquitl ma quicahuatij ipan se lugar campa amo tlapajpactli catli mocahua huejca tlen campa anmochijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Huan sintla acajya calaquis calijtic ipan nopa tonali quema nopa totajtzi tlanahuati para eltos tzactoc, huajca ya mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Huan aqui hueli catli tlacuas o motecas ipan nopa cali quema tzactoc monequi quichicuenis iyoyo. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Pero sintla quema ya quipatlatoque nopa tetl huan soquitl, amo tleno nesis quema sempa calaquis nopa totajtzi para quiitas nopa mancha, huajca quiijtos para nopa cali tlapajpactli pampa nopa hueyi cocolistli ya ixpolijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Huan quema nopa totajtzi quitlapajpacchihuas nopa cali monequi quintequihuis ome totome, tiocuahuitl, se icpatl catli chichiltic huan se imacuayo nopa cuahuitl catli itoca hisopo. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Huan quiquechtzontequis se tlen nopa ome totome ipan se huajcali catli tlachijchihuali ica soquitl catli quipiyas atl catli huala ipan se ameli. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","52","Huan nopa totajtzi quicuis nopa tiocuahuitl, nopa hisopo xihuitl imacuayo, nopa icpatl catli chichiltic huan nopa seyoc tototl catli noja itztoc, huan san sejco quinxolonis ipan nopa achtihui tototl ieso ihuaya nopa atl tlen ameli. Huan quinquixtis huan quiatzejtzelhuis chicome huelta nopa cali. Huan quej nopa quitlapajpacchihuas nopa cali. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Teipa yas huejca tlen nopa altepetl huan quimajcahuas nopa tototl catli itztoc para ma patlani ipan cuatitlamitl. Huan quej nopa ya quichijtos nochi catli monequi para nechixtzacuilis nopa tlajtlacoli catli eltoya ipan nopa cali, huan nopa cali mocahuas tlapajpactli.” ");
INSERT INTO nhwBl_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","55","Nochi ya ni eli nopa tlanahuatili para campa hueli campa quipantíaj manchas tlen nopa hueyi cocolistli masque mopannextía ipan se cali, o ipan se yoyomitl, o ipan icuetlaxo se masehuali, ");
INSERT INTO nhwBl_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","o sintla mopannextía campa samajtoc itlacayo se masehuali, o campa motlatijtoc, o campa iseli yoli se mancha. ");
INSERT INTO nhwBl_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Huan ica ni tlanahuatilme tlen cocolistli ipan tecuetlaxo o tlen hueli tlamantli, anquimatise quema amo tlapajpactli se tlamantli huan quema tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Huan TOTECO quinilhui Moisés huan Aarón: ");
INSERT INTO nhwBl_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Xiquinilhuica nopa israelitame ni tlanahuatilme. Quema se tlacatl quipiya atl catli mojmostla temo ipan itlacayo, amo tlapajpactli nopa tlacatl. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Huan masque quisenhuiquilis toyahuis o motzacuas, nopa tlacatl mocahuas amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“Nochi tlapechtli catli ipan motecas nopa tlacatl catli aquisa mochihuase amo tlapajpactique. “Huan campa mosehuis, quichihuas para nopa siya o nopa tlamantli elis amo tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","“Huan aqui hueli catli quitoxomas nopa tlapechtli, monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","“Huan sintla se masehuali mosehuis ipan nopa siya o nopa tlamantli campa ipan mosehui nopa tlacatl catli aquisa, huajca monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“Huan aqui hueli catli quitoxomas nopa tlacatl catli aquisa, monequi quichicuenis iyoyo, huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“Huan sintla nopa tlacatl catli aquisa chijchas ipan se masehuali catli tlapajpactli, huajca elis amo tlapajpactli. Monequi nopa masehuali quichicuenis iyoyo huan maltis ica atl, huan mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“Huan sintla nopa tlacatl catli atemo tlejcos ipan se cahuayo, huajca nopa cahuayojsiya mochihuas amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","“Aqui hueli catli quitoxomas o quihuicas se tlamantli catli ipan mosehuijtoc, o motectoc nopa tlacatl catli atemo, mocahuas amo tlapajpactli hasta tlayohua. “Huan nopa masehuali monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“Sintla nopa tlacatl catli atemo quiitzquis se acajya ica imax huan amo momajtequijtoc, huajca nopa tlacatl catli quiitzquili imax monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“Sintla nopa tlacatl catli atemo quiitzquis se comitl catli tlachijchihuali ica soquitl, huajca nopa comitl monequi quitlapanase. Huan sintla quinitzquis tlamantzitzi catli tlachijchihualme ica cuahuitl, huajca nopa tlamantzi san monequi quinpajpacase ica atl. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“Sintla ayacmo atemos nopa tlacatl, huan quinequis pehuas motlapajpacchihuas monequi achtihui quichiyas seyoc chicome tonali. Huan sintla quiitas ayacmo atemo, huajca quichicuenis iyoyo huan mopajpacas ica atl tlen ameli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Huan ipan tonali chicueyi quincuis ome pichones o ome palomas huan monextis iixpa TOTECO campa ipuerta nopa yoyon tiopamitl huan quinmacas nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Huan nopa totajtzi nechmacas se quen se tlacajcahualistli por tlajtlacoli. Huan ne seyoc nechmacas quen se tlacajcahualistli tlatlatili. Huan quej nopa, nopa totajtzi nechixtzacuilis itlajtlacol nopa tlacatl por nopa atemolistli catli quipixqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“Quema se tlacatl quitoyahuas ixinajcho, monequi quipajpacas nochi itlacayo ica atl, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","“Huan sintla toyahuis se quentzi ipan se yoyomitl o ipan se cuetlaxtli, huajca nopa tlamantli monequi quipajpacase ica atl huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","“Huan quema se tlacatl itztos ihuaya se sihuatl huan quitoyahuas ixinajcho, huajca nochi ome monequi mopajpacase ica atl, huan amo tlapajpactli mocahuase hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“Huan quema se sihuatl esotemos, mocahuas amo tlapajpactli para chicome tonali. “Huan catli quiitzquis nopa sihuatl, mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“Nochi tlamantli catli ipan motecas o mosehuis nopa sihuatl ipan nopa chicome tonali, mocahuas amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","“Huan aqui hueli catli quiitzquis itlapech nopa sihuatl catli esotemo, monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","23","“Huan aqui hueli catli quiitzquis nopa tlapechtli, o nopa siya, o tlen hueli tlamantli catli ipan mosehui nopa sihuatl catli esotemo monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“Sintla se tlacatl cochis ihuaya nopa sihuatl ipan nopa tonali quema esotemo huan ieso quiajsis, huajca nopa tlacatl mocahuas amo tlapajpactli para chicome tonali. Huan tlen hueli tlapechtli catli ipan motecas nopa tlacatl nojquiya mocahuas amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“Huan sintla se sihuatl noja esotemos miyac tonali quema ayacmo ipohual, o pehuas esotemos ipan se tonali quema amo ipohual, huajca amo tlapajpactli san se quen nelía ipohual. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","“Huan nochi tlapechtli huan siyas catli ipan mosehuis mocahuase amo tlapajpactli san quen amo tlapajpacme eli quema nelía ipohual para esotemos. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","“Nojquiya aqui hueli catli quiitzquis nopa tlapechtli campa motejqui, o nopa siyas campa mosehui, mocahuas amo tlapajpactli. Monequi quichicuenis iyoyo huan maltis, huan noja mocahuas amo tlapajpactli hasta tlayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“Huan quema ya tlantos esotemo, monequi quipohuas chicome tonali huan teipa mocahuas tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Huan ipan tonali chicueyi nopa sihuatl catli esotemoyaya quema amo ipohual monequi quincuis ome pichones, o ome palomas, huan quinhuicas campa nopa totajtzi huan quimactilis nechca ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Huan nopa totajtzi nechmacas se tlen nopa totome quen se tlacajcahualistli por tlajtlacoli, huan ne seyoc nechmacas quen se tlacajcahualistli tlatlatili. Huan quej nopa, nopa totajtzi nechixtzacuilis nopa esotemolistli catli nopa sihuatl quipixqui catli quichihuayaya amo tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“Monequi quej ni anquintlapajpacchihuase israelitame quema amo tlapajpacme. Pampa sintla amo motlapajpacchihuase, quichihuase amo tlapajpactli nopa yoyon tiopamitl campa na nimocahua tlatlajco inijuanti, huan quej nopa monequi miquise. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","“Huajca nochi ya ni elqui nopa tlanahuatili para se tlacatl catli atemo o catli toyahui ixinajcho huan yeca mocajqui amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Huan ni tlanahuatilme nojquiya eli para sihuame quema esotemoj quema ininpohual huan quema amo ininpohual. Nojquiya nica eltoc tlanahuatilme para tlacame catli cochij ihuaya se sihuatl catli amo tlapajpactli pampa esotemo.” ");
INSERT INTO nhwBl_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","TOTECO quicamanalhui Moisés quema ya mictoyaj nopa ome itelpocahua Aarón. Mijque pampa monechcahuijque campa itztoc TOTECO pero amo quen quinamiqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Huan TOTECO quiilhui: “Xiquilhui moicni, Aarón, amo hueli calaquis tlen hueli hora ipan nopa cuarto catli Más Tlatzejtzeloltic catli eltoc iica nopa cortina campa mocahua nopa caxa. Sintla calaquis nopona ipan se tonal quema amo onca tlanahuatili para calaquis, miquis. Pampa itzonixco itzajca nopa caxa campa nechixtzacuilis tetlajtlacolhua na noseltzi niitztos ipan nopa mixtli. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Huajca quej ni monequi mocualtlalis Aarón, quema ajsis nopa tonal sesen xihuitl quema monequi calaquis ipan nopa cuarto catli Más Tlatzejtzeloltic. Aarón monequi quihualicas se becerro para nechmacas quen se tlacajcahualistli por tlajtlacoli huan se oquich borrego para nechmacas quen se tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Achtihui monequi maltis, huan teipa monequi moquentis itlatzintlanyoyo catli huehueyac huan catli tlatzejtzeloltic, huan monequi moquentis itlatzintlanyoyo tlen lino. Teipa motlalilis itzinquechilpica, huan motlalilis icuatzajca pampa ya ni iyoyo catli tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“Huan israelitame quihuiquilise ome oquich chivojme para tlacajcahualistli por tlajtlacoli. Huan quihuiquilise se oquich borrego para elis se tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Pero achtihui monequi Aarón ma nechmaca nopa becerro para se tlacajcahualistli por tlajtlacoli catli nechixtzacuilis catli ya iseltzi itlajtlacolhua huan catli ya ifamilia inintlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Huan teipa quincuis nopa ome oquich chivojme huan quinhualicas noixpa campa ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Huan teipa quichihuas suertes ica nopa ome oquich chivojme para quiitas catli elis para na, niamoTECO, huan catli elis para quihuicas tetlajtlacolhua hasta campa itoca Azazel ipan nopa tlahuel huactoc tlali campa ayacmo quema huelis mocuepas sempa. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Huan Aarón quimictis nopa oquich chivo catli elis para na huan nechmacas quen se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Pero nopa oquich chivo catli elis para quihuicas tetlajtlacolhua huejca, quiixnextis noja yoltoc noixpa, niamoTECO. Huan teipa quitlalis tetlajtlacolhua ipan nopa chivo quen monequi para nechixtzacuilis inintlajtlacol huan teipa quititlanis para yas huejca ipan nopa huactoc tlali para quihuicas tetlajtlacolhua nopona huan ayacmo quema mocuepas sempa. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Huan quema Aarón ya quimictijtos huan ya quitencajtos nopa becerro para nechixtzacuilis itlajtlacolhua huan itlajtlacolhua iteiximatcahua, ");
INSERT INTO nhwBl_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","monequi quicuis se popochcomitl catli temitoc ica tlicoli xahuantoc catli eltoc ipan tlaixpamitl noixpa na, niamoTECO. Huan nojquiya quicuis ome tlamojtzoli copali catli tlatixtli nelía cuechtic huan catli mijyotía ajhuiyac, huan calaquis ipan nopa cuarto iica nopa cortina. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Huan nopona ipan nopa cuarto campa na, niamoTECO, niitztoc, quitlalis nopa copali ipan nopa tlitl catli quihualica ihuaya. Huan quema quitlatis nopa copali, ipocyo quichihuas se mixtli para quiixtzacuilis nopa caxa itzajca para Aarón amo quiitas huan amo miquis. Pampa ipan itzajca nopa caxa eltoc campa nijnextis tlatlasojtlacayotl para masehualme. Huan iijtic nopa caxa oncas nopa tepatlactli ica nopa camanali catli nijchihua amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Teipa quihualicas se quentzi ieso nopa becerro huan ica imacpil quiatzejtzelhuis chicome hueltas iixpa itzajca nopa caxa ica campa hualquisa tonati pampa nopona nitetlasojtla. Nojquiya tlaatzejtzelhuis ica imacpil seyoc chicome hueltas iixmelac nopa caxa. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Teipa quisas huan quimictis nopa oquich chivo catli nechmacas quen se tlacajcahualistli por tlajtlacoli para israelitame inintlajtlacolhua. Huan quihualicas quentzi ieso ipan nopa cuarto catli iica nopa cortina. Huan ica ya nopa, quiatzejtzelhuis iixco itzajca nopa caxa campa onca tlatlasojtlacayotl para masehualme huan nojquiya quiatzejtzelhuis iixpa. Quena, san se quichihuas quen quichijqui ica nopa becerro ieso. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Huan quej nopa nechixtzacuilis nopa tlajtlacoli catli israelitame quihuicaj catli quichihuilijtoc amo ma eli tlapajpactli nopa cuarto catli Más Tlatzejtzeloltic. Teipa san se quiixtzacuas nopa tlajtlacoli catli quichihuilijtoc para nopa yoyon tiopamitl amo ma eli tlapajpactli. Pampa nopa yoyon tiopamitl ica nopa cuarto catli Más Tlatzejtzeloltic mocahua tlatlajco campa mochijtoque nopa tlajtlacolchijca israelitame catli amo tlapajpacme noixpa. Yeca inintlajtlacolhua quichihua ma eli amo tlapajpactli hasta calijtic ipan nopa yoyon tiopamitl huan monequi anquitlapajpacchihuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“Huan quema Aarón panos calijtic Campa Más Tlatzejtzeloltic para quiixtzacuas itlajtlacolhua, huan ifamilia inintlajtlacolhua, huan inintlajtlacolhua israelitame, huan nochi nopa tlajtlacoli catli quichihuilijtoc nopa cuarto amo tlapajpactli, amo hueli itztos niyon se masehuali ipan nopa yoyon tiopamitl hasta ya quisas. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Huan teipa yaya monequi quisas huan yas campa nopa tlaixpamitl catli eltoc ipan calixpamitl noixpa na, niamoTECO, para quiixtzacuas nopa tlajtlacoli catli onca nopona. Huan quicuis se quentzi ieso nopa becerro huan se quentzi ieso nopa oquich chivo huan quiajalos ipan nopa nahui icuacua nopa tlaixpamitl catli eltoque ipan nahui inacastla. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Huan ica imacpil quitzejtzelos nopa estli chicome hueltas ipan nopa tlaixpamitl, huan ica ya nopa quitlapajpacchihuas israelitame inintlajtlacolhua huan mocahuase tlatzejtzeloltique. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Huan quema Aarón tlantos quitlapajpacchihuas nopa cuarto catli Más Tlatzejtzeloltic, huan nopa yoyon tiopamitl huan nopa tlaixpamitl, tlanahuatis ma quihualiquilica nopa oquich chivo catli itztoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Huan Aarón quitlalis nochi ome imax ipan itzonteco nopa oquich chivo catli itztoc huan nechpohuilis nochi inintlajtlacolhua huan inintlaixpanolhua israelitame. Huan quema quitenpojtos nochi tetlajtlacolhua, huajca nochi tetlajtlacolhua mocahuase ipan nopa tlapiyali. Huan teipa se tlacatl catli yaya quitlapejpenijtos, ma quihuicas nopa tlapiyali huan ma quicahuati huejca ipan nopa huactoc tlali huan ayacmo quema mocuepas. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Huan quema nopa tlacatl quimajcahuati nopa chivo, quihuicas nochi tetlajtlacolhua más huejca ipan se tlahuel huactoc tlali huan amo quema mocuepas. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Huan teipa quema Aarón sempa calaquis yoyon tiopan calijtic monequi moquixtilis iyoyo huehueyac catli tlachijchihuali ica lino catli moquentijtoya para calaquis nopa cuarto Campa Más Tlatzejtzeloltic huan quicahuas iyoyo nopona ipan nopa cuarto Campa Tlatzejtzeloltic tlen nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Teipa mopajpacas ica atl nopona ipan calixpamitl ipan nopa yoyon tiopamitl campa tlatzejtzeloltic, huan teipa sempa moquentis iyoyo catli huehueyac huan catli ipa quitequihuía. Huan teipa hualas huan nechmacas nopa tlacajcahualistli tlatlatili para ya huan nojquiya nopa seyoc tlacajcahualistli para israelitame para quiixtzacuas itlajtlacolhua huan israelitame inintlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Huan ichiyajca nopa tlapiyali catli quitencajqui quen se tlacajcahualistli por tlajtlacoli, quitlatis ipan nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Huan nopa tlacatl catli quitlapejpenijque para quihuicas nopa oquich chivo huan quititlanis ipan nopa tlahuel huactoc tlali campa itoca Azazel, quichihuas nopa tequitl huan teipa quichicuenis iyoyo huan mopajpacas ica atl. Huan huajca, quena, huelis calaquis sempa campa anmochijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“Huan inintlacayohua nopa becerro huan nopa oquich chivo catli elque tlacajcahualistli por tlajtlacoli huan catli inieso quihuicac Campa Más Tlatzejtzeloltic para quiixtzacuas tlajtlacoli nopona, monequi quihuicase tlahuel huejca tlen campa anmochijtoque. Nopona quintlatise ihuaya inincuetlaxo, inincuetlaxcol, inincuitl huan nochi catli elqui iniijtico. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Huan teipa nopa catli quinhuicac, monequi quichicuenis iyoyo, huan mopajpacas ica atl, huan teipa sempa hueli mocuepas campa anmochijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Huajca ya ni nopa tlanahuatilme catli monequi anquitlepanitase nochipa: Ipan majtlactli itequi nopa chicompa metztli ipan israelita calendario 16:29 Ipan septiembre o octubre ipan tocalendario tlen ama., amo anquichihuase niyon se tlamantli tequitl, pero monequi anmoechcapanose noixpa huan anmotejtemose. Ma amo tequitica israelitame, niyon seyoc tlali ehuani catli itztoque amohuaya, pampa ya ni se tlanahuatili catli monequi nochi anquitlepanitase. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ipan ni tonal nopa totajtzi quiixtzacuas amotlajtlacolhua para anmechtlapajpacchihuas huan yeca anmochihuase antlapajpacme tlen nochi amotlajtlacolhua noixpa na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ipan nopa tonali monequi anmosiyajquetzase huan anmoyoltlachilise para anmoechcapanose noixpa. Ya ni eli se tlanahuatili catli monequi anquitlepanitase para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Huan teipa quema itztos seyoc hueyi totajtzi catli quiajaltise huan quiiyocatlalise para quiixtzacuas tlajtlacoli ipatlaca inintata Aarón, nopa yancuic totajtzi moquentis nopa yoyomitl tlatzejtzeloltic catli tlachijchihuali ica lino. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Huan yaya quiixtzacuas tlajtlacoli por nopa cuarto Campa Más Tlatzejtzeloltic huan por nopa yoyon tiopamitl, huan por tlaixpamitl. Huan nojquiya quiixtzacuas itlajtlacolhua nopa totajtzitzi huan inintlajtlacolhua nochi israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Huajca xijmatica ya ni se tlanahuatili catli monequi anquitlepanitase para nochipa: Se huelta ipan se xihuitl monequi nechixtzacuilise inintlajtlacolhua israelitame.” Huan Aarón quitoquili senquistoc nochi ni tlanahuatilme catli TOTECO quimacac Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Xiquinmaca Aarón huan nochi israelitame ni tlanahuatilme. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","“Aqui hueli israelita catli quimictis se huacax, se pilborregojtzi o se oquich chivo nechca ichaj o huejca tlen campa anmochijtoque quihuicas tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Nochi tlacajcahualistli huan nochi tlapiyalme catli anquinmictise para tlacualistli monequi achtihui xiquinhualicaca campa ipuerta nopa yoyon tiopamitl para antechmacase na, niamoTECO. Sintla se masehuali quihuicas se tlapiyali ipan seyoc lado huan quimictis huan amo nechmacatoc na quen niquijto, huajca quihuica tlajtlacoli pampa quitoyajqui estli. Huan nopa tlacatl monequi anquiquixtise tlen campa amojuanti para ayacmo quema huelis itztos amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Nimechmaca ni tlanahuatili para israelitame ayacmo quema ma quimictica tlapiyalme ipan seyoc lado. Monequi ma quinhualicaca campa ipuerta nopa yoyon tiopamitl para nechmacase na, niamoTECO. Ma quimacaca nopa totajtzi huan nopona quinmictise nopa tlapiyali quen se tlacajcahualistli para ma onca tlayoltlalili nohuaya na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Huan nopa totajtzi quiijtzelos nopa estli ipan nopa tlaixpamitl catli eltoc nechca ipuerta nopa yoyon tiopamitl. Huan nopa tlachiyajcayotl quitlatis huan mijyotis ajhuiyac huan nechyolpactis na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Huan yeca israelitame ayacmo quema hueli quinmacase tlacajcahualistli nopa ajacame campa hueli. Quen se tlacanenca sihuatl catli quicajtejtoc ihuehue, nopa israelitame tlajtlacolchijtoque miyac noixpa pampa nechcajtejtoque para quintoquilise ajacame. Ni tlanahuatili para san nechca nopa yoyon tiopamitl huelis quinmictise tlapiyalme monequi xijtlepanitaca amojuanti huan amoteipan ixhuihua catli tlacajtiyase teipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Huajca xiquinilhui: Niyon se israelita o seyoc tlali ejquetl catli itztoc amohuaya hueli quimictis se tlapiyali o quitencahuas se tlacajcahualistli, ");
INSERT INTO nhwBl_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","huan amo quihualicas campa ipuerta nopa yoyon tiopamitl huan nechmacas na, niamoTECO. Aqui hueli catli quichihuas ya nopa, monequi anquiquixtise tlen campa amojuanti para ayacmo quema hueli itztos ica anisraelitame. San nopona campa ipuerta nopa yoyon tiopamitl nijtlapejpenijtoc para antechmacase tlacajcahualistli huan san nopona anquinmictise tlapiyalme. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“Nojquiya sintla se israelita o se seyoc tlali ejquetl catli itztoc amohuaya quicuas estli, huajca na tlahuel nicualanis ica nopa masehuali huan nijquixtis tlen campa amojuanti para ayacmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Pampa inemilis nopa tlapiyali mocahua ipan ieso catli quipixtoc ipan itlacayo. Huan nopa estli nimechmacatoc para anquiijtzelose ipan nopa tlaixpamitl para ica antlaxtlahuase huan anquiixtzacuase amotlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","“Huajca nimechilhuía anisraelitame: ‘Niyon se amojuanti huan niyon se seyoc tlali ejquetl catli itztoc amohuaya amo hueli quicuas estli.’ ");
INSERT INTO nhwBl_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Huan sintla israelitame o seyoc tlali ehuani tlapehuatij huan quimictise se tlamantli tlapiyali o tototl catli tlapajpactli para anquicuase, monequi nopona campa quimictise, quitoyahuase tlalchi ieso huan ipani quitemilise tlali. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Pampa ininnemilis nochi tlamantli tlapiyalme eltoc ipan inieso catli quipixtoque ipan ininnacayo. Yeca niquinilhuijtoc ma amo quicuaca estli, pampa inieso nochi totome huan tlapiyalme quihuica ininnemilis. Huajca aqui hueli catli quicuas estli, monequi anquiquixtise tlen campa amojuanti para ayacmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“Huan aqui hueli israelita o seyoc tlali ejquetl catli quicuas inacayo se tlapiyali catli mijqui ica iseltzi, o catli quimictijque sequinoc tlapiyalme, monequi quichicuenis iyoyo huan mopajpacas ica atl. Huan noja mocahuas amo tlapajpactli hasta tlayohua. Teipa quema ajsis tlayohua, mochihuas tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Pero sintla amo quichicuenis iyoyo, niyon amo mopajpacas ica atl, huajca quihuicas tlajtlacoli.” ");
INSERT INTO nhwBl_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Xiquinilhui nopa israelitame ni tlanahuatilme. “Na, niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","“Nimechilhuía amo xijchihuaca quen quichihuaj nopa masehualme catli ehuani ipan tlali Egipto campa achtihui anitztoyaj. “Niyon amo xijchihuaca quen quichihuaj nopa masehualme catli itztoque ipan nopa tlali Canaán campa nimechhuicas. Niyon amo anquitoquilise inintlanahuatilhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","5","“Monequi anquitoquilise senquistoc catli quiijtohuaj notlanahuatilhua huan anquichijtinemise nochi catli na nimechilhuía, pampa na niamoTECO Dios. Huan sintla anquineltocase huan anquichihuase senquistoc catli quiijtohuaj notlanahuatilhua, huajca anquipantise nemilistli por nopa tlanahuatilme. Na, niamoTECO, nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“Amo aqui hueli cochis ica seyoc catli iteiximatca catli san se inieso. Na niamoTECO, nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“Se ichpocatl amo hueli cochis ihuaya itata. Huan se telpocatl amo hueli cochis ihuaya inana, pampa yaya inana huan amo quinamiqui para cochis ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“Amo ximocuili se sihuatl catli achtihui itztoya ihuaya motata. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“Amo xicochi ica se moicni o motepotz icni, masque elis san iichpoca motata, o san iichpoca monana. Amo hueli ticochis ihuaya masque nopa moicni tlacatqui ipan san se cali mohuaya o tlacatqui seyoc lado. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“Amo xicochi ihuaya se moixhui masque icone moichpoca o motelpoca. Elis quen timoixpanos ica moseli, pampa se moixhui eli quen ta. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“Amo xicochi ihuaya se ichpocatl catli motepotz icni, pampa quitlacatilti motepotz nana. Yaya eli moicni huan iichpoca motata. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“Amo xicochi ihuaya moahui catli motata isihua icni, pampa quipiyaj san se inieso ihuaya motata. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“Amo xicochi ihuaya moahui catli monana isihua icni, pampa quipiyaj san se inieso ihuaya monana. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“Amo xiquixpano motío catli motata itlaca icni para ticochis ihuaya isihua, pampa eli moahui. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“Amo xicochi ihuaya moyex, pampa eli motelpoca isihua. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“Amo xicochi ihuaya isihua motlaca icni pampa quej nopa tiquixpanos motlaca icni. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“Amo xicochi ihuaya se sihuatl huan nojquiya ihuaya iichpoca. Niyon amo xicochi ihuaya se sihuatl huan teipa ihuaya se iixhui, pampa san se inieso huan niquita tlahuel fiero. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“Amo hueli timocuilis se sihuatl huan nojquiya timocuilis iicni, pampa mocualancaitase. Pero sintla mosihua miquis, huajca, quena, hueli timocuilis mohuejpol. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“Amo xicochi ihuaya se sihuatl quema esotemo. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“Amo xicochi ihuaya mohuampox isihua para amo tiquixpanos. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“Amo xijmactili niyon se mocone quen se tlacajcahualistli para nopa teteyotl catli itoca Moloc, pampa elis quen techtelchihua na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“Se tlacatl ma amo quichihua tlamantli ihuaya seyoc tlacatl quen elisquía isihua, pampa nopa se hueyi tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“Niyon se tlacatl amo hueli quichihuas tlamantli ihuaya se tlapiyali pampa nelía tlahuel fiero. Huan se sihuatl nojquiya amo hueli quichihuas tlamantli ihuaya se tlapiyali, pampa se hueyi tlajtlacoli huan amo quinamiqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“Huajca amo xijchihuaca niyon se tlamantli catli anmechcahuas amo antlapajpacme. Nopa masehualme catli itztoque ipan nopa tlali campa nimechhuicas, quichijtoque miyac tlamantli huan tlahuel mochijtoque amo tlapajpacme huan yeca niquintojtocas amoixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Quena, nochi nopa tlali mocajtoc amo tlapajpactli ica nopa miyac tlamantli, huan yeca nochi nopa masehualme catli itztoque nopona niquintlatzacuiltis huan niquintojtocas. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Pero monequi anquitlepanitase catli nimechilhuijtoc huan senquistoc anquichijtinemise notlanahuatilhua. Amo xijchihuaca niyon se tlen nopa fiero tlamantli catli inijuanti quichihuaj. Ni tlanahuatili monequi nochi anisraelitame anquitlepanitase huan nochi seyoc tlali ehuani catli itztoque campa amojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Pampa nochi ni tlamantli catli tlahuel fiero quichijtoque nopa masehualme catli itztoque ipan nopa tlali campa nimechhuicas. Yeca nopa tlali mocajtoc tlahuel amo tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Amo xijchihuaca nopa tlamantli catli amo cuali para amo nimechtojtocas quen niquintojtocac nopa masehualme catli nopona itztoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Aqui hueli catli quichihuas nopa tlamantli catli fiero monequi anquiquixtise tlen campa amojuanti para ayacmo quema huelis itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Huajca xijpiyaca miyac cuidado para xijneltocatinemica catli nimechilhuijtoc. Amo ximochihuaca amo tlapajpacme noixpa ica nopa fiero tlamantli catli quichihuayayaj nopa masehualme catli ama itztoque campa nimechhuicas. Na niamoTECO Dios.” ");
INSERT INTO nhwBl_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","“Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Xiquinilhui nochi israelitame ni tlanahuatilme. “Xiitztoca antlatzejtzeloltique pampa na, niamoTECO Dios, nitlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“Sese amojuanti monequi anquitlepanitase amotata huan amonana. “Huan monequi ximosiyajquetzaca ipan nochi nopa tonali para anmosiyajquetzase. Na, niamoTECO Dios, nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“Amo quema sempa ximotemachica ipan teteyome huan totiotzitzi. Na, niamoTECO Dios catli nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“Huan quema antechmacase se tlacajcahualistli para ma onca tlayoltlalili ica na niamoTECO, monequi antechmacase quen quinamiqui, pampa sintla amo quinamiqui, amo nimechselilis. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nopa nacatl tlen nopa tlapiyali catli antechmacase para nopa tlacajcahualistli monequi anquicuase nopa tonali quema antechmacase o hualmostla. Pero sintla mocahuas nacatl hasta ihuiptlatica, monequi anquitlatise. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Huan sintla anquicuase se quentzi hasta hualhuiptla, huajca ya nopa elis se tlajtlacoli noixpa huan na amo nimechselilis amotlacajcahualis. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Sintla aqui quicuas hasta hualhuiptla nopa tlacajcahualistli catli se nechmacas para ma oncas tlayoltlalili nohuaya, yaya quihuicas tlajtlacoli noixpa huan quiselis itlatzacuiltilis pampa quichijtoc amo tlapajpactli nopa tlacajcahualistli catli eltoya tlatzejtzeloltic para na, niamoTECO. Nopa masehuali monequi anquiquixtise tlen campa amojuanti para ayacmo quema itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“Quema ajsis nopa tonali para anpixcase ipan amomil, amo xijcuica hasta campa miltlateno, niyon amo xijtemoca catli mocajtoc, niyon amo xijpejpenaca catli tepejtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Huan san se anquichihuase ica amoxocomecamil. Amo xijtequica hasta inacastla amomil, niyon amo xijtemoca catli mocajtoc o tepejtoc. Na niamoTECO Dios catli nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“Amo xitlachtequica. Amo ximocajcayahuaca. Amo ximoistlacahuica se ica seyoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“Amo techtestigojquetzaca na quema anquiijtohuaj anquichihuase se tlamantli huan ya anquimatij amo anquichihuase. Sintla quej nopa anquichihuase, huajca anquisoquihuise notoca, na niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“Amo aqui xijtlaijiyohuiltica, niyon amo xitetlachtequilica. “Sintla se tequipanojquetl tequiti ipan mochaj, amo xijchiya hasta seyoc tonali para tijmacas itlaxtlahuil. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“Amo xijtelchihua se tlacatl catli amo hueli tlacaqui. “Niyon amo xijtlali se tlamantli campa nejnemi se popoyotzi para amo motepotlamis. Monequi techimacasica na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“Se catli tequitiquetl monequi tetlajtolsencahuas xitlahuac. Amo ma quichicoicneli catli teicneltzi, niyon catli rico o catli hueyi. Nochi monequi ma quinchihuili san se. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“Amo xiquejelnamiqui se masehuali iniixpa sequinoc ichampoyohua quema yaya amo aqui. “Amo xijtelhui se masehuali ica se tlamantli catli amo melahuac pampa tijnequi ma miqui. Na niamoTECO catli nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“Amo xijcualancaita seyoc ipan moyolo. “Quema seyoc mitzchihuilijtoc catli amo monequi, xiquilhui xitlahuac catli itlajtlacol para yaya mocualtlalis huan para amo tijhuicas tlajtlacoli nojquiya pampa amo tleno tiquilhui. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“Amo quema xijcuepili seyoc israelita catli mitzchihuilijtoc catli amo cuali, niyon amo ximonejnehuili tlatoctzitzi catli mitzchihuilijtoc para más timocualancamacas. Monequi xiquicneli seyoc quen ta moseltzi timoicnelía. Na niamoTECO catli nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“Monequi xijtlepanitaca notlanahuatilhua. “Amo xijmamalti mohuacax ica seyoc tlamantli tlapiyali. “Ipan momila amo xijtoca ome tlamantli xinachtli. “Niyon amo ximoquenti se yoyomitl catli tlachijchihuali ica lino icpatl huan ica ichcatl icpatl. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“Sintla se tlacatl tlen hueli quichihuas ihuaya se ichpoca tequipanojquetl catli ya quiijtlantoc seyoc, pero noja iaxca iteco huan ayamo itztoc majcajtoc, huajca monequi quiselis tlatzacuiltili nopa tlacatl, pero amo para miquis pampa nopa ichpocatl noja eliyaya se tequipanojquetl catli tlacohuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Huan nopa catli tlajtlacolchijqui monequi quihuicas se oquich borrego campa ipuerta nopa yoyon tiopamitl para quimacas TOTECO quen se tlacajcahualistli para catli quihuica tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Huan nopa totajtzi quiixtzacuas nopa tlacatl itlajtlacolhua catli quichijtoc ica nopa oquich borrego catli elis nopa tlacajcahualistli para nopa tlajtlacoli catli quihuica, huan na, niamoTECO, nijtlapojpolhuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“Huan quema ancalaquise ipan nopa tlali huan anquitocase nochi tlamantli cuahuitl catli temaca itlajca, nopa achtihui eyi xihuitl amo anquicuase niyon se itlajca pampa monequi anquiitase nopa cuatlajcayotl para amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Huan ipan nopa nahui xihuitl, nochi nopa cuatlajcayotl elis tlaiyocatlalili para na niamoTECO. Quena, nochi nopa cuatlajcayotl antechmactilise para antechpaquilismacase. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Pero ipan macuili xihuitl, quena, ya anhuelise anquicuase nopa cuatlajcayotl, huan sintla antechneltocase, nopa cuame noja más temacase inintlajca. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“Amo hueli anquicuase niyon se tlamantli nacatl ihuaya estli. “Nojquiya amo quema xitetonalitaca, niyon xijcahuilica seyoc anmechtonalitas. Amo xitetlajchihuica, niyon amo xijtlajtlanica seyoc ma quitlajchihui seyoc por ta. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“Amo ximoximaca campa amocuajtol, niyon amo xijhuatanica san amotentzo inacastla quen sequinoc quichihuaj para quitlepanitase inintlaixcopincayohua. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“Amo quema xijcococa amotlacayo quen inijuanti quichihuaj, niyon amo xijtequica amotlacayo quema anchocaj ica catli mictoque. Amo xiquixcopinaca tlaixcopincayome ipan amotlacayo ica tinta. Na, niamoTECO, nimechnahuatía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“Amo xijchihua para moichpoca ma moichpocapolo pampa ta tijtlacanemilti. Pampa quej nopa anquichihuase tlatelchihuali nopa tlali catli nimechmacas ica ahuilnencayotl huan tlafiero elis. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“Xijtlepanitaca nopa tonali catli nijtlalijtoc para anmosiyajquetzase. Huan xijtlepanitaca noyoyon tiopa. Na niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“Amo quema xijtemoca se catli quincamanalhuía mijcatzitzi niyon catli tetonalitaj. Niyon amo quema xijtemoca se tlamatquetl, niyon se catli mitzilhuis tlen motonal pampa anmechmahuisnenpolos noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“Ximoquetzaca quema ajsi se huehuentzi o se nanatzi, huan xijnextilica miyac tlatlepanitacayotl. Quema anquinextilíaj tlatlepanitacayotl se huehuentzi o se nanatzi, antenextilíaj para antechimacasij na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“Quema se seyoc tlali ejquetl hualas ipan amotlal para mocahuas amohuaya, amo xijchihuilica catli amo cuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Sintla se seyoc tlali ejquetl mocahuas amohuaya, monequi anquiitase quen se nopona ejquetl. Quena, monequi xiquicnelica quen anmoicnelíaj pampa nojquiya anitztoyaj seyoc tlali ehuani ipan tlali Egipto. Na, niamoTECO Dios, nimechnahuatía. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“Quema antetlajtolsencahuaj amo xitlacajcayahuaca. Xijchihuaca san catli xitlahuac. Quema anquitamachihuaj se tlali o anquitamachihuaj se tlenijqui ica ietica o ica imiyaca, monequi nochi nopa tlatamachihuali elis senquistoc xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","San xijtequihuica tlatamachihuali, teme, barras huan cualitros catli senquistoc xitlahuac para antlatamachihuase. Amo quema xitecajcayahuaca niyon pilquentzi. Na, niamoTECO Dios, catli nimechquixti ipan tlali Egipto. ");
INSERT INTO nhwBl_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“Huajca xijpiyaca cuidado para anquintlepanitase nochi notlanahuatilhua huan anquichijtinemise senquistoc nochi catli nimechnahuatía, pampa na, niamoTECO, catli nimechilhuía.” ");
INSERT INTO nhwBl_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Xiquinilhui nopa israelitame ni tlanahuatili. “Aqui hueli catli itztoc amohuaya, masque se israelita o se seyoc tlali ejquetl, sintla temacas icone quen se tlacajcahualistli para nopa teteyotl catli itoca Moloc, monequi anisraelitame anquitepachose hasta miquis. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Na ihuaya nimotlalis huan ayacmo nijcahuilis itztos pampa quimacatoc icone nopa totiotzi. Ica ya nopa quichijtoc amo tlapajpactli noyoyon tiopa huan nechpinahualtijtoc na catli nitlatzejtzeloltic, huan quipinahualtijtoc notoca. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Huan sintla israelitame ipan nopa tlali catli nimechmacas amo quichihuilise cuenta quema seyoc temaca icone ica se totiotzi huan amo quinequij quitepachose huan quimictise, ");
INSERT INTO nhwBl_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","na nojquiya nimotlalis ihuaya catli amo quichihuili cuenta huan nimotlalis ininhuaya nochi ichampoyohua. Huan niquinquixtis tlen anisraelitame para ayacmo quema huelis itztose amohuaya pampa amo quichihuili cuenta catli nopa tlacatl quichijqui. Amo san nijtlatzacuiltis yaya catli temaca icone, pero nojquiya niquintlatzacuiltis nochi masehualme catli yase quen ahuilnenca sihuame huan quihueyichihuase nopa totiotzi Moloc. Nochi niquinquixtis tlen campa amojuanti para ayacmo quema huelise itztose ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Sintla aqui hueli masehuali yas campa se catli quiijtohua quincamanalhuía mijcatzitzi o quiijtohua para tetonalita, huajca nechcajtejtoc. Itztoc quen se tlacanenca sihuatl catli momecatijtoc. Huan na ihuaya nimotlalis huan nijquixtis tlen campa amojuanti para ayacmo quema itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“Huajca ximoiyocatlalica tlen ni tlamantli huan xiitztoca antlatzejtzeloltique, pampa na niamoTECO Dios catli nimechnahuatía. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Xiquinneltocaca notlanahuatilhua huan xiquinchijtinemica, pampa na, niamoTECO, catli nimechtlatzejtzelolchihua. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“Aqui quitelchihuas inana o itata, monequi xijmictica. Quitelchijtoc inana o itata huan tlahuel quihuica tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“Sintla se tlacatl cochis ihuaya seyoc tlacatl isihua, huajca nopa tlacatl huan nopa sihuatl monequi xiquinmictica. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“Sintla se tlacatl cochis ihuaya itata isihua, huajca nopa tlacatl quiixpano itata, huan nopa ome, sihuatl huan tlacatl, monequi xiquinmictica pampa tlahuel quihuicaj tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“Huan sintla se tlacatl cochis ihuaya iyex, huajca nopa ome monequi xiquinmictica pampa tlahuel quiixpanotoque se ininteiximatca. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“Sintla se tlacatl cochis ihuaya seyoc tlacatl huan quichihuilis quen elisquía isihua, huajca nopa ome quichijtoque catli amo nijnequi niquitas huan monequi xiquinmictica. Quena, miquise pampa tlahuel quihuicaj tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“Sintla se tlacatl ihuaya itztos se ichpocatl huan nojquiya mocuilis inana nopa ichpocatl, huajca fiero. Nopa eyi monequi xiquinmictica huan xiquintlatica para anquiquixtise nopa hueyi tlajtlacoli tlen campa amojuanti. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“Sintla se tlacatl quichihuas catli amo quinamiqui ihuaya se tlapiyali, huajca nopa tlacatl huan nopa tlapiyali monequi xiquinmictica. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“Huan sintla se sihuatl quichihuas catli amo quinamiqui ihuaya se tlapiyali, huajca nopa sihuatl huan nopa tlapiyali monequi xiquinmictica. Miquise pampa tlahuel quihuicaj tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“Sintla se telpocatl cochis ihuaya se ichpocatl catli itepotzicni pampa yaya itata iichpoca o huelis inana iichpoca, huajca nopa ome monequi anquinhuicase iniixpa nochi israelitame huan xiquinquixtica tlamiyacapa tlen campa anisraelitame huan xiquinitaca para mictoque. Pampa sintla se tlacatl cochis ihuaya isihua icni eli se tlamantli catli nelía monequi tlatzacuiltilistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“Sintla se tlacatl cochis ihuaya se sihuatl ipan nopa tonali quema esotemo, huajca nopa ome monequi xiquinquixtica tlen campa amojuanti para ayacmo quema itztose ica anisraelitame, pampa nopa tlacatl quiixtlapo campa esotemo nopa sihuatl huan nopa sihuatl quinexti ieso. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“Amo xijchihua catli amo quinamiqui ihuaya moahui, niyon monana isihua icni, niyon motata isihua icni. Pampa sintla se masehuali ya nopa quichihuas ihuaya se iteiximatca catli nechca, nochi ome quihuicase tlajtlacoli huan quiselise inintlatzacuiltilis. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“Sintla se cochis ihuaya itío isihua, quiixpanotoc itío. Huan nopa ome quihuicase tlajtlacoli noixpa. Quema miquise, amo quipixtehuase niyon se inincone. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“Sintla se tlacatl quicuilis isihua itlaca icni, huajca quichihua se hueyi tlajtlacoli huan quiixpano itlaca icni huan amo quipixtehuase niyon se inincone. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“Monequi xijneltocaca huan xijchijtinemica nochi catli quiijtohua notlanahuatilhua para amo anmechisotlas nopa tlali campa nimechhuica para anitztotij. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Amo xijchihuaca quen nopa masehualme catli ama itztoque nopona ipan nopa tlali huan monequi niquintojtocas amoixpa. Quena, inijuanti quichijtinentoque nochi ni fiero tlamantli, huan yeca amo nijnequi niquinitas. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Huajca na nijcajtoc nocamanal para anmoaxcatise inintlal pampa na nimechmactilía para amoaxca. Nopa tlali elis se cuali tlali catli temacas itlajca hasta onmocahua. “Na, niamoTECO Dios, catli nimechiyocatlalijtoc tlen nochi sequinoc masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“Huan yeca monequi anquiniyocatlalise nopa tlapiyalme catli niquinita para tlapajpacme para anquincuase huan inijuanti catli amo tlapajpacme huan amo cuali para anquincuase. Amo ximochihuaca amo antlapajpacme noixpa ica niyon se tlapiyali o tototl catli niquijtojtoc amo tlapajpactli, o ica niyon se tlamantli catli mohuahuatatza tlalchi. Pampa na nimechiyocatlalijtoc tlen nopa tlamantli catli amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Monequi xiitztoca antlatzejtzeloltique noixpa, pampa na catli niamoTECO nitlatzejtzeloltic. Huan nimechiyocatlalijtoc tlen nopa sequinoc masehualme para xielica annoaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“Aqui hueli tlacatl o sihuatl catli quiijtohua quincamanalhuía inintonalhua mijcatzitzi o quicamanalhuía se catli tetonalita, monequi xijmictica ica tetl. Inijuanti quihuicase tlajtlacoli ininseltzitzi por ininmiquilis.” ");
INSERT INTO nhwBl_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Huan TOTECO quiilhui Moisés: “Xiquinilhui nopa totajtzitzi catli itelpocahua Aarón, para ma amo quiitzquica tlen hueli mijcatzi pampa quinchihuas amo tlapajpactique noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Huelis quiitzquise imijcatzi se ininteiximatca catli nelía nechca quen ininnana, inintata, inioquichpil, ininsihuapil, inintlaca icni, ");
INSERT INTO nhwBl_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","o se ininsihua icni catli noja itztoc ininmaco para quimocuitlahuise pampa ayamo monamictía. Ica inijuanti quena, hueli quiitzquise ininmijcatzitzi pampa ininteiximatcahua catli nelnechca. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pero amo hueli mochihuase amo tlapajpacme ica se mijcatzi catli san mosansejcotilijtoya ihuaya seyoc tlacatl catli se ininteiximatca quen sequinoc tlacame monequi quichihuase quema onca se mijcatzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“Nopa totajtzitzi amo hueli quinextise sintla motequipachohuaj quema miqui se masehuali. Amo quinamiqui mohuatanise inacastla inintentzo, niyon quitequise inintzoncal nechca inintzonteco, niyon amo quinamiqui quitequise inincuetlaxo quen seyoc tlali ehuani quichihuaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Monequi elise senquistoc tlatzejtzeloltique para na, niamoTeco Dios. Pampa inijuanti catli nechmacase nopa tlacajcahualistli tlatlatili huan nopa pantzi catli noaxca na, niamoTECO. Yeca monequi totajtzitzi elise tlatzejtzeloltique huan amo quiahuilmatise na notoca. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“Se totajtzi amo hueli mocuilis se sihuatl catli ahuilnentoc, niyon amo hueli mocuilis se sihuatl catli moamasosolojtoc ihuaya ihuehue, pampa se totajtzi monequi mocahuas tlatzejtzeloltic para na, niiTeco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Se totajtzi monequi mocahuas tlaiyocatlalili pampa yaya catli nechmacas nopa tlacajcahualistli noixpa na, niamoTeco Dios. Huajca ma mocahuaca tlatzejtzeloltique nopa totajtzitzi, pampa na, niamoTECO, nitlatzejtzeloltic, huan na catli nimechtlatzejtzelolchihua. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“Sintla se totajtzi iichpoca mochihuas se ahuilnenca sihuatl, moixpanotos huan quiixpanotos itata. Huan monequi anquitlatise hasta miquis. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“Huan nopa hueyi totajtzi catli ticajaltijtoque itzonteco ica nopa aceite para quinyacanas nochi sequinoc totajtzitzi, huan catli tlaiyocatlalili para moquentis nopa yoyomitl catli más tlatzejtzeloltic, amo hueli tenextilis para tlahuel motequipachohua quema quiajsis se tequipacholi. Amo hueli quicahuas itzoncal ma elis fiero, niyon amo huelis quitzayanas iyoyo quen quichihuaj sequinoc ica tequipacholi. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Huan nopa hueyi totajtzi amo hueli monechcahuis campa eltoc se mijcatzi itlacayo, masque eli inana o itata. Amo hueli mochihuas amo tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Huan quema quipiya tequitl ipan nopa yoyon tiopamitl, amo hueli quisas pampa quipiya se tequipacholi pampa quichihuas amo tlapajpactli nopa yoyon tiopamitl. Tlaajaltili nopa hueyi totajtzi para ma eli tlatzejtzeloltic huan tlaiyocatlalili san para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“Nopa hueyi totajtzi monequi mocuilis para isihua se ichpocatl catli ayamo quiiximati se tlacatl. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Amo hueli mocuilis se sihuatl catli cahuali, o catli quicajtoc ihuehue, o catli ahuilnentoc. Monequi mocuilis se ichpocatl catli nojquiya huala ipan nopa hueyi familia tlen totajtzitzi. Monequi elis se catli nelía cuali ichpocatl. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Pampa monequi se totajtzi quitlepanitas TOTECO itlanahuatil para iconehua ma elica tlapajpacme noixpa. Na niamoTECO catli nimechtlatzejtzelolchihua.” ");
INSERT INTO nhwBl_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Xiquilhui Aarón ni tlanahuatili. Ama huan teipa niyon se moixhui catli quipiyas se tlenijqui catli amo cuali ipan itlacayo amo huelis mochihuas totajtzi, niyon amo hueli monechcahuis para nechmacas nopa pantzi catli eltoc para na, niamoTeco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Pampa niyon se tlacatl catli amo ajsitoc itlacayo amo hueli monechcahuis para quichihuas nopa tequitl. Huajca sintla se tlacatl eli popoyotzi, o metzcototic, o lipintic itlacayo, o sintla quipiya miyac ixocpilhua o imacpilhua, ");
INSERT INTO nhwBl_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","o sintla quilecuenijtoc imax o iicxi, ");
INSERT INTO nhwBl_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","o sintla cuitlapanponpontic, o tlahuel amo huejcapantic, o amo cuali se iixteyol, o sahuati, o cocoti, o sintla quicocojtoc itecsis, amo hueli tequitis quen se totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Huajca masque se itztoc se iixhui nopa totajtzi Aarón, amo hueli nechmacas, niamoTECO, se tlacajcahualistli ipan tlitl sintla amo ajsitoc itlacayo. Niyon amo hueli nechmacas nopa pantzi catli noaxca na, niamoTeco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Pero, quena, ininconehua totajtzitzi catli amo ajsitoc inintlacayo hueli quicuase nopa tlacualistli catli huala tlen nopa tlacajcahualistli, masque se tlacualistli catli tlatzejtzeloltic, o catli tlahuel tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","San amo hueli calaquis para quinechcahuis nopa cortina pampa amo ajsitoc itlacayo, niyon amo hueli monechcahuis campa nopa tlaixpamitl. Melahuac amo hueli quichihuas nopa tequitl pampa quichihuas notiopa amo tlapajpactli. Na, niamoTECO, catli niquiniyocatlalijtoc nopa totajtzitzi.” ");
INSERT INTO nhwBl_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Huajca Moisés quiilhui Aarón nochi ya ni huan nojquiya quinilhui itelpocahua huan nochi nopa israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Xiquinilhui Aarón huan itelpocahua ma momocuitlahuica miyac para amo ma quichihuaca amo tlapajpactli se tlacajcahualistli catli tlatzejtzeloltic catli nechmacaj israelitame. Amo hueli quiahuilmatise notoca na amoTECO Dios huan notlacajcahualis. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Sintla se totajtzi catli amo tlapajpactli quinechcahuis se tlapiyali, o seyoc tlamantli tlacajcahualistli catli tlatzejtzeloltic catli se israelita quihualicatoc para nechmacas, huajca monequi xijquixti nopa totajtzi para ayacmo quema huelis itztos noixpa. Ni tlanahuatili elis para totajtzitzi ama huan nojquiya para moteipan ixhuihua catli mochihuase totajtzitzi teipa. Na niamoTECO nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“Aarón, niyon se tlen moixhuihua catli quipiya nopa tlacayo palanca cocolistli, o catli atemo ipan inintlacayo amo hueli quicuas nopa tlacajcahualistli catli tlatzejtzeloltic. Pero quema ya mochicajtoc huajca, quena, huelis quicuas. “Nojquiya elis amo tlapajpactli aqui hueli totajtzi catli quinechcahuis se mijcatzi, o temotos ixinajcho, ");
INSERT INTO nhwBl_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","o quiitzquis se tlapiyali catli mohuahuatatza tlalchi, o quiitzquis se tlacatl catli amo tlapajpactli. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Aqui hueli totajtzi catli amo tlapajpactli por tlen hueli tlamantli mocahuas amo tlapajpactli noixpa, huan amo hueli quicuas nopa tlacualistli tlatzejtzeloltic catli huala tlen tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Pero quema tlayohuiyas huan maltis, huajca motlapajpacchijtos. Huan huajca, quena, hueli quicuas nopa tlacajcahualistli catli tlatzejtzeloltic pampa ya nopa itlacualis. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Se totajtzi amo hueli quicuas inacayo se tlapiyali catli mijqui ica iseltzi, o catli quimictijque sequinoc tlapiyalme, pampa sintla quicuas, huajca mochihuas amo tlapajpactli noixpa. Na niamoTECO nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“Huajca xiquinilhui nopa totajtzitzi ma quitoquilica nochi ni tlanahuatili ica miyac cuidado para amo quiixpanose huan amo miquise por inintlajtlacol. Na niamoTECO catli niquintlatzejtzelolchihua. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“Niyon se tlacatl catli amo totajtzi amo huelis quicuas tlen nopa tlacajcahualistli catli tlatzejtzeloltic. “Niyon amo hueli quicuas se tlacatl catli san quipaxalohua se totajtzi, o san quipalehuía se totajtzi se ome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","“Pero sintla nopa totajtzi quicohuas se tequipanojquetl ica itomi, huajca nopa tequipanojquetl, quena, hueli quicuas nopa tlacajcahualistli catli tlatzejtzeloltic. Huan sintla nopa tequipanojquetl quinpiyas iconehua, huajca, inijuanti nojquiya huelise quicuase nopa tlacajcahualistli catli tlatzejtzeloltic catli nopa totajtzi quinmacas. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","“Huan sintla iichpoca se totajtzi monamictis ihuaya se tlacatl catli amo totajtzi, huajca nopa ichpocatl ayacmo huelis quicuas nopa tlacajcahualistli catli tlatzejtzeloltic. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Pero sintla miquis ihuehue o quicahuas ihuehue, huan amo quinpiyas iconehua, huan sempa mocuepas ipan ichaj itata catli eli se totajtzi, huajca nopa ichpocatl sempa huelis quicuas itata itlacualis quen quema eliyaya tziquitetzi. Pero se tlacatl catli amo quipiya tleno ica nopa totajtzi amo hueli quicuas nopa tlacualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“Sintla se acajya mocuapolos huan quicuas nopa tlacajcahualistli catli tlatzejtzeloltic, huajca monequi quicuepas san se imiyaca quen catli quicuajqui, huan noja quitlalis seyoc 20 por ciento. Huan quihualicas huan quimacas nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Huajca nopa totajtzitzi monequi ma quipiyase cuidado ica ajqueya inijuanti quincahuilise ma quicuaca nopa tlacajcahualistli para amo quichihuase amo tlapajpactli nopa tlacajcahualistli catli tlatzejtzeloltic catli nopa israelitame nechiyocatlalilijtoque na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Pampa sintla se quiixpanos ni tlanahuatili, quihuicas tlajtlacoli huan monequi quiselis itlatzacuiltilis. Na niamoTECO catli nijtlatzejtzelolchihua nopa tlacajcahualistli.” ");
INSERT INTO nhwBl_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Xiquilhui Aarón, huan iconehua, huan nochi sequinoc israelitame ni tlanahuatilme. Quema quinequis quimacas tlacajcahualistli aqui hueli israelita o aqui hueli seyoc tlali ejquetl catli itztoc campa amojuanti pampa tlatestigojquetztoc catli quichihuas para na, o pampa san ica ipaquilis quinequi nechmacas se tlacajcahualistli, ");
INSERT INTO nhwBl_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","huajca para nijselis monequi elis se becerro, se oquich borrego, o se oquich chivo catli senquistoc cuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Amo hueli nechmacas niyon se tlapiyali catli quipiya ipan itlacayo se tlamantli catli amo cuali, pampa amo nijselis. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“Sintla aqui quinequis nechmacas, niamoTECO, se tlacajcahualistli para ma onca tlayoltlalili nohuaya pampa tlatestigojquetztoc, o pampa san ica ipaquilis quinequi nechmacas se tlacajcahualistli, huajca monequi elis se toro, o se borrego, catli amo tleno catli amo cuali quipiya itlacayo para nijselilis. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Amo techmacaca na, niamoTECO, se tlapiyali catli amo tlachiya, o mometzpostectoc, o cotontoc imax, o cocoti, o sahuati, o quipiya seyoc tlamantli cocolistli. Se tlapiyali quej nopa amo quema xijtlalica ipan notlaixpa, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Pero sintla anquipiyaj se toro, o se pilborregojtzi catli quipiya miyac ixocpilhua o quentzi, o quipiya cototzi o huehueyac se imetz, huajca quena, huelis antechmacase quen se tlacajcahualistli catli san antechmacaj ica amopaquilis. Pero ni tlamantli tlapiyalme amo huelis antechmacase para se tlacajcahualistli quema monequi tlacajcahualistli pampa antlatestigojquetztoque catli anquichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Nojquiya san se elis ni tlanahuatili quema anajsise ipan amotlal. Para tlacajcahualistli, monequi se tlapiyali catli senquistoc cuali. Amo quema techmacaca se tlapiyali catli cocojtoc itecsis, o motejtzontoc, o quihuahuatzojtoc o quiquixtilijtoque itecsis. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Niyon amo xiquincahuilica nopa seyoc tlali ehuani ma quitencahuaca se tlacajcahualistli quej nopa para elis tlacualistli para na, niamoTeco Dios. Sintla quihualicase se tlapiyali catli amo ajsitoc itlacayo huan quinequise techmacase na, niamoTeco Dios, amo niquinselilis pampa amo tlapajpactli. Amo cuali nochi itlacayo.” ");
INSERT INTO nhwBl_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Quema tlacatis se becerro, se pilborregojtzi, o se piloquich chivojtzi monequi mocahuas ihuaya inana para chicome tonali. Pero quema quipiyas chicueyi tonali, huelis anquitequihuise para se tlacajcahualistli catli anquitlatise para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","“Ipan san se tonali amo hueli anquimictise se huacax ihuaya icone, o se sihua borrego ihuaya icone. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Quema antechmacase se tlacajcahualistli para antechtlascamatilise, monequi anquichihuase quen quinamiqui para nijselis. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Monequi anquicuase nopa tlapiyali inacayo ipan nopa tonali quema antechmacase. Amo hueli anquicahuase se quentzi para anquicuase hasta seyoc tonal. Na niamoTECO catli nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Xijtlepanitaca notlanahuatil. Quena, xijtoquilijtinemica senquistoc catli quiijtohua pampa na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","“Amo xijtequihuica notoca quen eliyaya tlen hueli tocayotl pampa nitlatzejtzeloltic. Na niiyoca. Huan monequi nochi israelitame ma nechiyocatlalica huan ma nechiximatica para niitztoc niiyoca, pampa nitlatzejtzeloltic. Huan na niamoTECO catli nimechtlatzejtzelolchihua. ");
INSERT INTO nhwBl_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Na catli nimechmaquixti ipan tlali Egipto para nielis niamoTECO huan niamoDios.” ");
INSERT INTO nhwBl_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Xiquinilhuiti nopa israelitame ni tlanahuatilme. Ya ni nopa tonali catli monequi anquiiyocacahuase para na, niamoTECO para anquichihuase ilhuitl huan techhueyimatise. Xiquintocaxtlalica tonali para tlanechicolme catli tlatzejtzeloltique. Huan ipan ni tonali nochi israelitame ma mosentilica huan ma nechhueyitlalica. Huan ni nopa tonali: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“Sesen semana para chicuase tonali antequitise, pero ipan tonali chicome, amo anquichihuase niyon se tequitl. Senquistoc anmosiyajquetzase ipan nopa chicompa tonali. Elis se tonali tlatzejtzeloltic para anmosentilise huan antechhueyichihuase. Quej ni anquichihuase ipan sesen semana. Nopa chicompa tonali elis tlatzejtzeloltic huan tlaiyocatlalili para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“Huan ya ni eli nopa tonali para anilhuichihuase huan anquipiyase se tlanechicoli tlatzejtzeloltic ipan sesen xihuitl para antechhueyichihuase na, niamoTECO: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","“Nopa ilhuitl tlen Pascua monequi xijchihuaca ipan 14 itequi nopa achtihui metztli ipan amoisraelita xihui 23:5 Quemantic ni tonal huetzis ipan itlamiya marzo huan quemantic ipan ipejya abril ipan tocalendario tlen ama., huan pehuas quema temo tonati ica tiotlac. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“Ipan ne seyoc tonal, anpehuase anquichihuase nopa ilhuitl tlen pantzi catli amo quipiya tlasonejcayotl. Para chicome tonali san hueli anquicuase pantzi catli amo quipiya tlasonejcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Ipan nopa achtihui tonali tlen nopa chicome tonali, anmosentilise ipan se tlanechicoli tlatzejtzeloltic, huan ipan nopa tonali amo anquichihuase niyon se tequitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Huan ipan nochi nopa chicome tonali monequi anquitlatise tlacajcahualistli para na. Huan ipan nopa tonal chicome nojquiya anquipiyase se tlanechicoli tlatzejtzeloltic huan amo antequitise.” ");
INSERT INTO nhwBl_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Xiquinilhui israelitame ni tlanahuatilme. Quema ya anajsitose ipan nopa tlali catli nimechmacas huan ya anquipixcatose cebada, monequi anquihuicase campa nopa totajtzi nopa achtihui tlaitzquili catli anquipixcase. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Anquihuicase ipan ne seyoc tonali quema ya panoc nopa tonal quema anmosiyajquetzque. Huan nopa totajtzi quihuisos noixpa niamoTECO, huan na nijselis quen se tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Ipan nopa tonal nojquiya antechmacase se pilborregojtzi quen se tlacajcahualistli tlatlatili. Monequi nopa pilborregojtzi quipiyas san se xihuitl huan amo quipiyas ipan itlacayo niyon se tlamantli catli amo cuali. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Huan ihuaya ni pilborregojtzi monequi antechmacase se tlacajcahualistli catli elis nahui kilos huan tlajco tlen harina catli tlamaneloli ica aceite. Monequi anquitlatise noixpa huan nelía nechpactis. Nojquiya ihuaya monequi antechmacase se litro xocomeca atl quen se tlacajcahualistli catli anquitoyahuase noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Huan quema ayamo anquihuicaj ni tlacajcahualistli, amo huelis anquicuase niyon pilquentzi nopa cebada ipan amomil. Amo hueli anquimacuise iyolo, niyon anquicacatzchihuase iyol, niyon amo hueli anquichihuase pantzi. Ya ni elis se tlanahuatili catli monequi anquitlepanitase para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“Huajca nopa achtihui tonal anmosiyajquetzase huan ne seyoc tonal anquihualicase nopa tlaitzquili yancuic huan teipa xipehuaca xijpohuaca chicome semanas. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","O huelis anquipohuase 50 tonali o chicome sábados catli ipan anmosiyajquetzaj, huan huajca anquihuicase seyoc tlacajcahualistli catli quisa tlen cebada para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Anquihualicase ome pantzi tlen amochajchaj para se tlacajcahualistli catli anquihuisose noixpa, niamoTECO. Nopa pantzi monequi anquicualtlalise ica se nahui kilos tlen harina ica tlasonejcayotl. Ya ni elis se tlacajcahualistli tlen nopa tlayacanca pixquistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Huan ica nopa pantzi nojquiya antechmacase chicome pilborregojtzitzi catli sanoc quipiyaj sese xihuitl catli amo tleno catli amo cuali quipiyaj. Nojquiya techmacaca se becerro huan ome oquich borregojme huan nochi elise tlacajcahualistli tlatlatili para na, niamoTECO. Huan nojquiya techmacaca nopa tlacajcahualistli tlen harina huan nopa tlacajcahualistli catli tlatoyahuali noixpa catli monequi techmacase ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","“Huan nojquiya antechmacase se oquich chivo para se tlacajcahualistli por tlajtlacoli, huan antechmacase ome pilborregojtzitzi quen se tlacajcahualistli para ma onca tlayoltlalili nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Huan nopa totajtzitzi quinhuisose nopa ome pilborregojtzitzi noixpa, niamoTECO. Nojquiya quihuisose nopa ome pantzi tlen nopa tlayacapan pixquistli. Nochi ni tlacajcahualistli elis tlaiyocatlalili para na, niamoTECO, huan monequi anquinmactilise nopa totajtzitzi para ma eli inintlacualis. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","“Huan ipan san se nopa tonal anteyolmelahuase para oncas se tlanechicoli catli tlatzejtzeloltic para antechhueyichihuase. Amo huelis anquichihuase niyon se tequitl ipan nopa tonali. Ya ni elis se tlanahuatili catli monequi nochi anisraelitame huan amoteipan ixhuihua anquitlepanitase para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“Huan quema anpixcase ipan amomila ipan nopa tlali, amo xipixcaca hasta campa inacastla nopa mili, niyon amo xijpejpenaca catli tepejtoc tlalchi. Ya nopa xijcahuaca para ma quipejpenaca catli teicneltzitzi huan catli seyoc tlali ehuani. Na niamoTECO Dios catli nimechilhuía.” ");
INSERT INTO nhwBl_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Xiquinilhui israelitame ni tlanahuatilme. Nopa achtihui tonal ipan nopa chicompa metztli ipan amoisraelita calendario 23:24 Quemantic ni tonal huetzi ipan itlamiya septiembre huan quemantic ipan ipejya octubre ipan tocalendario tlen ama. elis tlatzejtzeloltic. Monequi anquielnamiquise quen se tonal para anmosiyajquetzase. Pero monequi anmosentilise ipan se tlanechicoli catli tlatzejtzeloltic para antechhueyimatise. Huan anquinpitzase tlapitzalme para antenotzase ipan ni ilhuitl tlen tlapitzali. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Huan ipan nopa tonal amo tleno tlen tequitl anquichihuase, san antechmacase tlacajcahualistli ipan tlitl.” ");
INSERT INTO nhwBl_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Nojquiya TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Huan ipan nopa majtlacpa tonal ipan nopa chicompa metztli anquichihuase nopa Tonal para Quiixtzacuas Tetlajtlacolhua. Ipan ni tonal anmosentilise ipan se tlanechicoli catli tlatzejtzeloltic para antechhueyimatise. Huan monequi anmosahuase, huan anmoicnonequise por amotlajtlacolhua. Huan anquitencahuase se tlacajcahualistli ipan tlitl noixpa, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ipan nopa tonal amo anquichihuase niyon se tequitl, pampa elis nopa Tonal Para Quiixtzacuas Tetlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Aqui hueli masehuali catli amo mosahuas huan amo moicnonequis por itlajtlacolhua ipan nopa tonal, monequi xijquixtica tlen campa amojuanti para ayacmo quema itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Huan aqui hueli catli quichihuas tlen hueli tequitl ipan nopa tonal, na nijtzontlamiltis para ayacmo itztos ica anisraelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","“Quena, amo hueli anquichihuase niyon se tequitl. Ni tlanahuatili monequi anquitlepanitase amojuanti huan amoteipan ixhuihua para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Quena, ya ni elis se tonal para anmosiyajquetzase, huan monequi anmosahuase huan anmoicnonequise noixpa por amotlajtlacolhua. Ni Tonal Para Quiixtzacuas Tetlajtlacolhua pehuas ica tiotlac ipan nopa chicnajpa tonal ipan nopa metztli huan huejcahuas hasta ne seyoc tonal ica tiotlac.” ");
INSERT INTO nhwBl_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Xiquinilhui israelitame ni tlanahuatili. Ipan 15 itequi nopa chicompa metztli ipan amocalendario, anquipehualtise para anquielnamiquise nopa ilhuitl quema anquichihuase pilxajcaltzitzi. Huan anilhuichihuase noixpa, niamoTECO, para chicome tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ipan nopa achtihui tonal tlen nopa chicome tonali anmosentilise ipan se tlanechicoli catli tlatzejtzeloltic para antechhueyichihuase. Ipan nopa tonal, amo hueli anquichihuase niyon se tlamantli tequitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Huan ipan nochi nopa chicome tonali, anquitlatise tlacajcahualistli para na, niamoTECO. Huan ipan nopa chicueyi tonal anmosentilise ipan seyoc tlanechicoli catli tlatzejtzeloltic para antechhueyichihuase. Ya ni itlamiya nopa tlanechicoli tlen ni hueyi ilhuitl. Ipan nopa tonal nojquiya amo aqui hueli quichihuas niyon se tequitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“Huajca nica nimechilhuijtoc nopa tonali ipan se xihuitl catli nijtlalijtoc para anmosentilise huan anilhuichihuase para na, niamoTECO. Huan nojquiya ipan ni tonali anquintlatise miyac tlacajcahualistli para na. Nojquiya anquitencahuase tlacajcahualistli ipan tlitl para na. Antechmacase tlacajcahualistli tlatlatili, tlacajcahualistli tlen harina, huan tlacajcahualistli tlen tlapiyalme catli anquinmictijtoque huan tlacajcahualistli catli anquitoyahuase noixpa. Sesen tlacajcahualistli antechmacase ipan nopa tonali quema quinamiqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Nochi ni tlacajcahualistli elis iyoca tlen nopa tlacajcahualistli catli monequi antechmacase ipan nopa tonal para anmosiyajquetzase ipan sesen semana. Nojquiya nochi ya ni eltoc iyoca tlen nopa tlacajcahualistli catli antechmactilijtihualahuij, o nopa tlacajcahualistli catli antechmacase ica amoseltzitzi quema antlatestigojquetzase ica se tlenijqui catli anquichihuase, o se tlacajcahualistli catli anquitencahuase noixpa pampa san ipan amoyolo quisa para anquichihuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“Ipan 15 itequi nopa chicompa metztli, quema ya anpixcaque, anquielnamiquise ni ilhuitl noixpa, niamoTECO. Ni ilhuitl quema anquichihuase pilxajcaltzitzi anquichihuase para chicome tonali. Huan ipan nopa achtihui tonali huan ipan nopa chicueyi tonali, monequi anmosiyajquetzase. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ipan iachtihui tonal ni ilhuitl anquicuise imacuayo cuame catli yejyectzitzi huan catli quipiyaj inintlajca. Anquicuise imacuayo apachi cuame huan ininmacuayo cuame catli quipiyaj ininxihuiyo huan moscaltíaj campa hueyatl. Huan ica ya nopa anquichihuase pilxajcaltzitzi para ipan anitztose para chicome tonali huan anpaquise noixpa na, niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Sesen xihuitl anquichihuase ni ilhuitl para chicome tonali para na. Ya ni eli se tlanahuatili catli monequi anquitlepanitase nochi anisraelitame catli ama anitztoque huan nochi catli teipa tlacatise. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ipan nopa chicome tonali nochi anitztose ipan pilxajcaltzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ica ni ilhuitl, anquielnamiquise quema nimechquixti ipan tlali Egipto huan nimechchijqui anitztose ipan pilxajcaltzitzi. Na niamoTECO Dios catli nimechilhuía.” ");
INSERT INTO nhwBl_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Huajca Moisés quinyolmelajqui nopa israelitame tlen nochi nopa ilhuime catli TOTECO quiixquetztoya para tiquelnamiquise. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Xiquinnahuati israelitame ma quihualicaca aceite tzilintic para tlahuili ipan tiopamitl. Nopa aceite monequi hualas tlen olivas catli tlatejtejtzonali. Ica nopa cuali aceite, nopa tlahuilme amo quema sehuise. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","4","Ma quinmocuitlahui miyac nopa tlahuilme ipan nopa tlahuil quetzali catli senquistoc oro. Quena, nopa tlahuilme iixmelac nopa cortina catli quitzacua campa nocaxa monequi tlatlatose nochipa noixpa, niamoTECO. Huan elis Aarón itequi para quinpajpacas huan quintequilis aceite nopa tlahuilme ijnaloc huan tiotlac. Huan Aarón iixhuihua monequi quitlepanitase ni tlanahuatili para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","6","“Ipan sesen semana ipan nopa tonali para anmosiyajquetzase, nopa totajtzi monequi quitlalis 12 pantzi ipan nopa mesa tlen oro catli eltoc noixpa, niamoTECO. Sesen tlen nopa pantzi monequi quichihuase ica nahui kilos huan tlajco tlen harina catli tlahuel cuechtic. Huan quintecpanas ica ome tlatecpichtli. Sesen tlatecpichtli quipiyas chicuase pantzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Huan ipan sesen pamitl tlen nopa pantzi quitlalis copali catli nelía cuali. Ni copali teipa elis se tlacajcahualistli catli quitlatis ipan tlaixpamitl para nechmacas, na niamoTECO. Huan nopa pilquentzi copali catli quitlatis quinextis para nechmaca senquistoc nochi nopa pantzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Huan sesen semana ipan nopa tonali para anmosiyajquetzase, nopa totajtzi monequi quitlalis nopa pantzi noixpa para se tlanextilijcayotl tlen nopa camanali catli nijchijtoc ininhuaya nochi israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Huan nopa pantzi elis para Aarón huan iconehua ma quicuaca, pero monequi quicuase campa tlatzejtzeloltic. Quena, nopona ma quicuaca pampa nopa pantzi eltoc catli más tlatzejtzeloltic tlen nochi tlamantli tlacajcahualistli catli nechmacatoque ipan tlitl. Huan na, niamoTECO, niquinmaca ma quicuaca nopa totajtzitzi huan ininconehua para nochipa.” ");
INSERT INTO nhwBl_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Itztoya se telpocatl catli inana eliyaya se israelita sihuatl, pero itata eliyaya se tlali Egipto ejquetl. Huan se tonal nopa telpocatl mocualani ihuaya se israelita tlacatl nopona campa nochi mochijtoyaj. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Huan quema mohuilanayayaj, nopa telpocatl quitelchijqui TOTECO. Huan sequinoc quihuicaque iixpa Moisés para ma quitlajtolsencahua. Inana nopa telpocatl eliyaya Selomit catli eliyaya iichpoca Dibri huan hualayaya ipan nopa hueyi familia Dan. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Huan quitzajque nopa telpocatl huan quichixque para TOTECO ma quiilhui Moisés tlaque tlatzacuiltili monequi quiselis. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Xijquixti nopa telpocatl catli nechtelchijqui huejca tlen campa anmochijtoque. Huan ma hualaca nochi catli quicajque quema nechtelchijqui, huan ma quitlalica ininmax ipan itzonteco. Huan teipa nochi israelitame ma quimaquilica ica tetl hasta quimictise. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Huan xiquinilhui israelitame sintla acajya nechtelchihuas na, niamoTECO, o quitelchihuas notoca, nojquiya quiselis nopa tlatzacuiltili. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Quena, aqui nechtelchihuas na, niamoTECO, monequi miquis, huan monequi nochi israelitame quitejtzonase. Ni tlanahuatili elis san se para israelitame huan para seyoc tlali ehuani. Sintla se nechtelchihuas monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“Nojquiya sintla se tlacatl quimictis seyoc, nopa tlacatl catli temicti monequi nojquiya xijmictica. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","“Aqui quimictis se tlapiyali catli seyoc iaxca, monequi quicuepilis seyoc tlapiyali catli san se. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“Sintla se acajya quicocos seyoc, monequi nojquiya san se anquicocose. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Sintla se acajya quipostequilis seyoc iomiyo, huajca nojquiya monequi anquipostequilise iomiyo. O sintla se acajya quiixteyolquixtis seyoc, huajca nojquiya monequi anquiixteyolquixtise. Huan sintla se acajya tetlancochtepehuas, huajca nojquiya monequi anquitlancochtepehuase. Quena, quen se acajya quichihuilijtoc seyoc, monequi nojquiya anquichihuilise. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","“Aqui quimictis seyoc itlapiyal, monequi quicuepas seyoc tlapiyali catli san se. Pero sintla aqui quimictis seyoc masehuali, monequi nojquiya xijmictica. ");
INSERT INTO nhwBl_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“Onca san se ni tlanahuatili para nochi masehualme, masque israelitame o seyoc tlali ehuani. Na, niamoTECO Dios, catli nimechnahuatía.” ");
INSERT INTO nhwBl_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Huajca teipa Moisés quincamanalhui israelitame. Huan quihuicaque nopa telpocatl catli quitelchijtoya TOTECO hasta huejca tlen campa mochijtoyaj huan nopona nochi quimictijque ica tetl. Huajca nopa israelitame quichijque senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Quema Moisés itztoya ipan tepetl Sinaí, TOTECO quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Xiquinilhui nopa israelitame para quema ya anajsitose ipan nopa tlali catli nimechmacas, nopa tlali iseli monequi mosiyajquetzas sesen huelta quema ajsis xihuitl chicome. Huan ica ya nopa anquinextise para nopa tlali noaxca na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Para chicuase xihuitl hueli antlatojtocase ipan amomila. Nojquiya hueli anquitzontequise nopa xocomecame ininmacuayo para más temacas, huan hueli anquitequise itlajca. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Pero ipan xihuitl chicome, nopa tlali monequi mosiyajquetzas huan elis se xihuitl tlaiyocatlalili para na para antenextilise antechtlepanitaj. Amo xijtocaca niyon se xinachtli, niyon amo xijtzontequica imacuayo nopa xocomecatl para ma chamani más. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Nopa catli ixhuas ica iseli ipan amomila campa tepejtoc iyol, amo xijpixcaca, niyon xicajocuica. Huan itlajca nopa xocomecatl catli moscaltía iseli, amo xijtequilica quen ipa anquichijtoque, pampa ipan nopa xihuitl, nopa tlali san mosiyajquetzas. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Pero catli ixhuas iseli ipan mila ipan nopa xihuitl quema nopa tlali mosiyajquetzas elis tlacualistli para nochi hueli quitequihuise. San se quitequihuise catli iaxca nopa mila, o itequipanojcahua catli quincojtoc, o itequipanojcahua catli quipalehuíaj se ome tonali, o nopa seyoc tlali ehuani catli itztoque tlatlajco amojuanti. Nochi san se iniaxca elis para ma quicuaca, pero amo aqui huelis quipixcas para quiajocuis. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Nojquiya amotlapiyalhua huan nopa tlapiyalme catli itztoque ipan cuatitlamitl san se hueli quicuase catli nopona eltoc ipan mila. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“Xijpohuaca hasta tlamis chicome xihuitl chicome hueltas, o 49 xihuitl. Huan quema ya tlantos huan ajsis ne seyoc tonali, campa hueli anquipitzase icuacua se oquich borrego. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Quena, campa hueli ipan nochi nopa tlali Israel monequi anquipitzase tlapitzali quema ajsis nopa Tonali Para Quiixtzacuase Tetlajtlacolhua ipan majtlactli itequi nopa chicompa metztli ipan 50 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Pampa nopa xihuitl 50 elis tlatzejtzeloltic. Nopa xihuitl elis se xihuitl quema nochi catli tlahuicaj elise majcajtoque tlen nopa catli tlahuicaj. Nojquiya ipan nopa xihuitl monequi anquinmajcahuase nochi amoisraelita tequipanojcahua catli monemacatoque para anmechtequipanose. Quena, nochi israelita tequipanohuani mocahuase majcajtoque. Huan nochi israelitame catli quinemacaque inintlal, nopa tlali sempa mochihuas iniaxca, o iniaxca iniixhuihua. Huan sesen israelita monequi sempa yas campa quistoc ifamilia huan campa eliyaya itlal para quiselis sempa nopa tlali catli eliyaya iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Nopa xihuitl 50 elis se xihuitl quema anelise anmajcajtoque tlen nochi amotequi. Amo antlatojtocase, niyon amo anquipixcase itlajca catli ixhuac ica iseltzi, niyon itlajca nopa xocomecatl catli amo anquimocuitlahuijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Pampa nopa xihuitl elis tlatzejtzeloltic huan nochi israelitame mochihuase majcajtoque. Ipan nopa xihuitl quema anquicuase se tlamantli catli iseli ixhuac, xijcuitehuaca campa mila huan nimantzi xijcuaca, pero amo xipixcaca, niyon amo xicajocuica. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“Ipan nopa xihuitl quema anmochihuase anmajcajtoque, sesen tlen amojuanti monequi mocuepas campa itlal huan campa quisqui ifamilia. Huan masque ya quinemacatose itlal, ipan nopa tonali sempa quimactilise. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Huajca quema anquicohuilíaj o anquinemaquiltíaj seyoc israelita se tlali, amo ximocajcayahuaca. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Xijpohuaca quesqui xihuitl mocahuas hasta nopa xihuitl quema nochi mocahuas majcajtoc, huan xijtlaxtlahui quen quesqui xihuitl huelis temacas itlajca nopa tlali hasta ajsis nopa xihuitl quema mocuepas ica catli achtihui iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Huan sintla polihui miyac xihuitl para ajsis nopa 50 xihuitl quema nochi mocahuas majcajtoc, huajca más patiyo anquiixtlahuase nopa tlali para anquicohuase. Pero sintla pilquentzi xihuitl eltos para sempa mocuepas moaxca, amo más patiyo xijnemaca. Pampa nelía catli anquinemacaj eltoc imiyaca nopa pixquistli catli temacas nopa tlali hasta sempa elis moaxca ta o catli achtihui quipixqui. Quena, quej nopa elis ipati nopa tlali quema anquinemacase. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","“Huajca techimacasica na, niamoTECO Dios, huan amo xijcajcayahuaca seyoc ica se tlaxtlahuili catli amo ijqui. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Monequi xiquintlepanitaca notlanahuatilhua huan xiquintoquilijtinemica para quej nopa anitztose ica temachili ipan amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Huan sintla anquitoquilise ni tlanahuatili, nopa tlali temacas miyac itlajca, huan anmechmacas para anquicuase hasta anixhuise cuali. Huan anitztose ica paquilistli ipan nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“Pero huelis amojuanti anmoilhuise ni: ‘¿Tlaque tijcuase ipan nopa xihuitl chicome, pampa amo antechcahuilíaj para titlatojtocase, niyon tipixcase?’ ");
INSERT INTO nhwBl_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Na nijtitlanis notlatiochihualis ipan nopa xihuitl chicuase, huan yeca nopa catli anquipixcase ipan nopa xihuitl, huejcahuas para anmopanoltise hasta anpixcase sempa ipan nopa expa xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Quena, quema sempa ajsis tonali para antlatojtocase ipan xihuitl chicueyi, noja anquicuajtiyase nopa pixquistli catli anquicuique ipan xihuitl chicuase. Huan anmechaxilis para ica anmopanoltise hasta oncas nopa pixquistli ipan xihuitl chicnahui. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“Xiquelnamiquica para nopa tlali noaxca. Yeca amo hueli anquinemacase para mocahuas seyoc iaxca para nochipa. Amojuanti san anajsini huan anpaxalohuani nica, huan eltoc quen san nimechtlanejtía nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Nochipa quema anquinemacaj se tlali, nopa amatl monequi quiijtos para sempa hueli anquicohuase para amoaxca ipan tlen hueli tonal. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“Huan quema se israelita mochihuas teicneltzi huan monequis mitznemaquiltis se quentzi itlal, huajca se iteiximatca catli nelnechca hueli mitzcohuilis sempa nopa tlali catli mitznemaquiltijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","“Huan sintla nopa tlacatl amo quipiya niyon se iteiximatca catli quipalehuis, pero ya iseli quisentilis nopa tomi, huajca yaya sempa huelis quicohuas nopa tlali catli quinemacac. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Huan monequi ximoilhuica quesqui xihuitl tlen pixquistli nopa tlacojquetl quiixtlajtoc para elisquía iaxca nopa tlali hasta nopa xihuitl quema nochi elis majcajtoc. Huan quema nopa masehuali sempa quicohuas itlal, monequi quicuepilis itomi nopa masehuali para nochi nopa xihuitl catli quicojtoya para quitequihuis nopa tlali pero ama ayacmo hueli quitequihuis pampa sempa quicojqui catli quinemacac. Pero quena, catli iaxca eliyaya se tlali sempa hueli quicohuas para elis iaxca sintla quipiya nopa tomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Pero sintla amo quisentilis nopa tomi quen quinamiqui para sempa quicohuas itlal, huajca nopa tlali eltos iaxca catli quicojqui hasta ajsis nopa xihuitl quema nochi tlali mocahuas majcajtoc huan mocuepas ica catli achtihui eliyaya iaxca. Huan huajca ipan nopa xihuitl, quena, nopa tlacatl catli quinemacac nopa tlali, sempa quiselis para iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“Sintla se tlacatl quinemacas se cali ipan se altepetl catli moyahualojtoc ica tepamitl, yaya huelis quicohuas sempa sintla quinequisquía para se xihuitl huan sempa elis iaxca catli quinemacac. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Pero quema ya quiaxitijtos se xihuitl quinemacatoc, huajca ayacmo hueli quicohuas sempa nopa cali catli eltoc ipan se altepetl catli moyahualojtoc ica tepamitl. Huan mocahuas nopa tlacatl catli quicojtoc iaxca huan iniaxca iixhuihua para nochipa. Niyon nopa cali amo hueli mocuepas para elis iaxca iteco catli achtihui ipan nopa xihuitl quema nochi tlali mocahuas majcajtos. Quej nopa eltoc tlanahuatili para calme catli mopantíaj ipan se altepetl catli moyahualojtoc ica tepamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Pero calme catli mopantíaj ipan pilaltepetzitzi catli amo moyahualojtoque ica tepamitl elise quen nopa tlalme campa mila. Quiijtosnequi iteco catli quinemacac huelis quicohuas sempa ica tomi, huan sintla amo quicohuas nopa cali sempa, quema ajsis nopa xihuitl 50 elis majcajtoc huan mocuepas para elis iaxca catli achtihui. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“Pero nopa calme catli mopantíaj ipan inialtepehua iixhuihua Leví, o nopa totajtzitzi, amo san se. Masque moyahualojtoc nopa inialtepe ica tepamitl, se levita tlacatl catli quinemacas ichaj sempa huelis quicohuas ipan tlen hueli tonali. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Huan se cali catli se iixhui Leví quinemacas, nojquiya mocuepas iaxca nopa tlacatl ipan xihuitl 50 quema nochi tlali mocahuas majcajtoc. Pampa nopa levitame quiselijque ininchajchaj ipatlaca nopa tlali campa hueltosquíaj tlatojtocasquíaj. Yeca amo aqui hueli quincuilis ininchajchaj para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Huan nopa potreros catli nechca inialtepehua iixhuihua Leví amo hueli monemacase, pampa nopa piltlaltzitzi mocahuas iniaxca para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“Sintla se israelita mochihuas teicneltzi huan yas campa ta, monequi xijpalehui quen elisquía se nejnenquetl, o se seyoc tlali ejquetl, huan xijcahua ma itzto mohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Quena, techimacasica na, niamoTeco Dios, huan xijcahuilica para amoicni ma itzto amohuaya. Huan amo xitlainamaca itlanca quema anquitlanejtíaj amotomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Amo tleno xitlainamaca quema antetlanejtíaj amotomi, niyon amo xijtlanica tomi sintla anquimacase tlacualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Pampa na, niamoTeco Dios catli nimechilhuía. Na catli nimechquixti ipan tlali Egipto para nimechmactilis nopa tlali Canaán huan para nielis niamoTeco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“Sintla se moisraelita icni mocahuas nelteicneltzi huan quinequis monemacas ica ta para mitztequipanos, huajca xijcohua, pero amo xijtequihui quen elisquía se tequipanojquetl catli tijcojtoc para moaxca catli amo quipiya niyon se tequiticayotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Monequi xiquitas quen elisquía se tepaxalojquetl o se cuali tequipanojquetl catli mitzpalehuía. Huan san huelis mitztequipanos hasta ipan nopa xihuitl quema nochi mocahuas majcajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Huan ipan nopa xihuitl quema nochi mocahuas majcajtoc yaya hueli quisas ihuaya iconehua huan mocuepas campa itatahua inintlal. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Pampa anisraelitame annotequipanojcahua catli nimechquixti ipan tlali Egipto, huan amo quinamiqui anmonemacase para anelise tequipanohuani catli seyoc iaxca huan antequipanose san tlapic. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Amo quema xijnahuati se israelita o xijtequihui chicahuac. Monequi techimacasica na, niamoTeco Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“Pero sintla anquinequij anquincohuase tequipanohuani para amoaxcahua para anmechtequipanose san tlapic, huajca huelis anquincohuase tlacame huan sihuame catli ehuani ipan sequinoc tlalme huan amo israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Nojquiya hueli anquincohuase seyoc tlali ehuani ininconehua catli itztoque campa amojuanti masque ininconehua tlacatque ipan amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Huan quema anmiquise, huajca ni tequipanohuani catli amo israelitame catli anquincojtoque mocahuase iniaxcahua amoconehua, huan quintequipanose para nochipa. Pero anisraelitame amo hueli anquitequihuise seyoc israelita san tlapic o anquinahuatise chicahuac. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“Sintla se seyoc tlali ejquetl catli itztoc ipan amotlal mochihuas rico huan se israelita mochihuas teicneltzi huan quinequi monemacas ica nopa seyoc tlali ejquetl, ");
INSERT INTO nhwBl_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","huajca cualtitoc. Pero masque monemacatos, nopa israelita noja quipiya tlanahuatili para se iteiximatca quicohuas sempa para quimajcahuas. Quena, hueli quicohuas se iicni, ");
INSERT INTO nhwBl_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","se itío, o se imachicni, o aqui hueli catli iteiximatca catli nelnechca. Huan sintla ya iseli huelis quisentilis tomi para quicuepilis iteco quen quicojqui, huajca nojquiya huelis momanahuis ica iseltzi. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Monequi quichihuase cuentas ihuaya iteco para quiitas quesqui monequi tlaxtlahuas. Pehuase quipohuase tlen nopa xihuitl quema monemacac huan quipohuase hasta nopa 50 xihuitl quema nochi mocahuas majcajtoc. San tlaxtlahuas por quesqui xihuitl polihuis para ajsis nopa xihuitl quema elis majcajtoc. Quiijtosnequi quicuepilis iteco catli monequisquía quitlaxtlahuis seyoc tequipanojquetl para tequitis ipatlaca hasta nopa 50 xihuitl quema elisquía majcajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Sintla noja polihui miyac xihuitl para mocahuas majcajtoc, huajca quitlaxtlahuis iteco nechca imiyaca catli quiseli quema yaya monemacac ica ya. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Pero sintla ayacmo miyac xihuitl polihui para mocahuas majcajtoc, huajca san quiixtlahuas nopa xihuitl catli noja polihui. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Sintla nopa israelita monemacatoc ica se seyoc tlali ejquetl, yaya mocahuas ihuaya quen se tequipanojquetl catli motemacas tetequipanos para se xihuitl. Huan nopa seyoc tlali ejquetl amo hueli quinahuatis chicahuac, niyon amo hueli moaxcatis para nochipa. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“Huan sintla nopa israelita tlacatl noja ayamo momanahuijtoc huan ajsis nopa xihuitl 50, huajca mocahuas majcajtoc ipan nopa xihuitl. Huan ya ica nochi iconehua quisase majcajtoque san sejco. ");
INSERT INTO nhwBl_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Nochi anisraelitame annotequipanojcahua na. Na catli nimechquixti ipan tlali Egipto para antechtequipanose. Na niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“Amo ximochijchihuilica totiotzitzi, niyon tlaixcopincayome, niyon teteyome. Quema anajsise ipan amotlal amo xijquetzaca se tetl catli anquisencajtoque huan anquipajtoque para anquihueyichihuase, pampa na niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Monequi xiquintlepanitaca notlanahuatilhua huan ximosiyajquetzaca ipan nopa tonali quema nimechnahuatijtoc. Xijtlepanitaca noyoyon tiopa. Na niamoTECO catli nimechilhuía. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“Sintla anquinneltocase notlanahuatilhua huan anquitoquilise catli niquijtohua, ");
INSERT INTO nhwBl_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","huajca nijchihuas para ma huetzis atl ipan amotlal quema monequi tlaquiyahuis. Huan nopa tlali temacas miyac pixquistli, huan nopa cuame temacase miyac inintlajca hasta mocahuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Quena, anquipiyase miyac trigo hasta noja anquipixcatose ipan nopa tonal quema anpehuase anquitequise xocomecatl itlajca. Huan noja anquitequihuijtose nopa xocomecatl itlajca hasta nopa tonal quema sempa anquitocase trigo. Quena, anquicuase tlen nochi catli anquinequise hasta anixhuise cuali. Huan anitztose ica paquilistli ipan amotlal. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Quena, na noseltzi nimechmacas tlasehuilistli. Huan yeca quema ancochise, amo anmajmahuise. Amo oncas niyon se tlamantli catli anmechmajmatis. Nijchihuas para nochi tlapiyalme catli mosisiníaj ma ixpolihuica. Huan nopona ayacmo oncas tlahuilancayotl. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Anquintojtocase amocualancaitacahua huan anquintzontlamiltise ica amomachete. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Macuilti tlen amojuanti anquintojtocase cien amocualancaitacahua. Huan cien tlen amojuanti anquintojtocase majtlactli mil amocualancaitacahua. Huan quej nopa, nochi amocualancaitacahua anquintzontlamiltise. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Pampa na, nimechtiochihuas huan nimechmiyaquilis. Huan catli niquijtojtoc nijchihuas ica amojuanti, temachtli nijchihuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Quena, anquicuase nopa trigo catli huejcajya anquipixcaque. Huan quema ajsis tonali para anquipixcase nopa catli yancuic, monequis anquiquixtise catli anquipixcaque se xihuijtlaya para huelis anquiajocuise catli yancuic. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","“Na nimocahuas para niitztos tlatlajco tlen amojuanti huan amo quema nimechcualancaitas. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Niitztos campa amojuanti huan na nielis niamoTeco Dios huan amojuanti anelise annomasehualhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Na niamoTECO catli nimechquixti ipan tlali Egipto para ayacmo antetequipanose san tlapic. Na catli nimechquixtili nopa cuahuitl etic catli eltoya ipan amoquejquespa para antlapoxonise quen tlapiyalme, huan na nimechchijqui ximoquetzaca xitlahuac. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Pero sintla amo antechneltoquilise huan amo anquitlepanitase nochi notlanahuatilhua, ");
INSERT INTO nhwBl_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","huan san anquihuejcamajcahuase huan amo anquinequise anquicaquise catli nimechilhuijtoc, huajca amojuanti anquisosolose nopa camanali catli nijchijtoc amohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Huan huajca ya ni catli nimechchihuilis. Nimechtitlanilis se cocolistli catli anmechcocoxcamacas huan se majmajtli catli nimantzi anmechajsis, huan anquipantise cocolistli catli tlahuel tlamahua. Nojquiya nimechmacas se cocolistli tlen tlatotonilotl catli anmechpopoyochihuas. Huan amotlacayohua pehuas para nenpolihuis. Huan catli anquitocase ipan amomila, elis san tlapic, pampa amocualancaitacahua anmechichtequilise huan inijuanti quicuase. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Na nielis niamocualancaitaca, huan sequinoc amocualancaitacahua niquincahuilis ma anmechtlanica. Quena, inijuanti anmechnahuatise. Huan ancholojtehuase ica majmajtli masque amo aqui anmechtojtoca. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Huan sintla noja amo antechneltoquilise masque ya nimechtitlanilijtos nochi ya ni, huajca nimechtlatzacuiltis chicome hueltas por sese amotlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Quena, nijtlamiltis nopa chicahualistli catli ica anmohueyimatij huan nijchihuas para nopa mixtli ma ayacmo quitoyahua atl. Huan ne tlali nijchihuas ma elis quen xali. Quena, nijchihuas ma quipiyas itlachiyalis catli cafentic quen nopa tepostli bronce. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","San tlapic anmosiyahuiltise para antlatojtocase pampa nopa tlali ayacmo tlaeliltis huan nopa cuame ayacmo temacase inintlajca. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Huan sintla noja antechcualancaitase huan amo anquinequise anquitlacaquilise catli nimechilhuía, huajca nimechtlatzacuiltis chicome hueltas más chicahuac. Quena, nopa tlatzacuiltili nimechtitlanilis por amotlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Niquintitlanis tlapiyalme catli mosisiníaj para quintzontlamiltise amoconehua huan amohuacaxhua. Huan nojquiya nimechtzontlamiltis huan ayacmo anitztose anmiyaqui huan yeca ipan campa hueli ojtli ayacmo itztose israelita masehualme. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Pero sintla teipa noja ayamo anmocualtlalise, huan ayamo anquichijtinemise catli na nijnequi huan san antechcualancaitase, ");
INSERT INTO nhwBl_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","huajca nimotlalis quen niamocualancaitaca huan nimechtlatzacuiltis chicome hueltas más chicahuac para sese amotlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Huan nijchihuas para hualas se tlahuilancayotl campa amojuanti pampa anquisosolojtoque nopa camanali catli nijchijqui amohuaya. Huan sintla anmochololtise huan anmotlatitij ipan amoaltepehua ica tepamitl, huajca altepeijtic nijchihuas ma anmechajsi se cocolistli catli temictía. Huan nimantzi amocualancaitacahua anmechtlanise. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","“Huan teipa nijchihuas ma huala se mayantli huan tlahuel pilquentzi elis itlajca amomila. Majtlactli sihuame huelise quiicxitise pantzi ipan san setzi horno. Huan teipa anquipohuase nopa pantzi huan anmoxejxelhuilise para anmechaxilis miyac tonali. Huan masque anquicuase se quentzi, amo anixhuise. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Huan sintla ica ya nopa noja ayamo antechneltocase huan anquisenhuiquilise anquichijtinemise catli amo nijnequi na, ");
INSERT INTO nhwBl_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","huajca amohuaya nimotlalis na. Huan tlahuel miyac más nicualanis amohuaya huan nimechtlatzacuiltis chicome hueltas más chicahuac para sese amotlajtlacolhua. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Huan anmayanase hasta anquincuase amoconehua catli oquichpilme huan catli sihuapilme. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Huan na nijsemanas nopa tlaixpamitl campa anquinhueyichihuaj tiotzitzi campa tlachiquiltipa. Nojquiya nijsosolos amotlaixpa campa anquitlatíaj copali para amotlaixcopincayohua. Amotlacayohua catli mictoque niquintlalis ipan amotiotzitzi catli nojquiya mictoque. Huan ayacmo nijnequis nimechitas. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Nijsemanas amoaltepehua huan mocahuas quen se huactoc tlali, huan nijsosolos campa antlahueyichihuayayaj. Masque anquitlatisquíaj copali noixpa, ayacmo nijselis. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","“Nijsosolos nochi nopa tlali. Huan quema amocualancaitacahua hualase para moaxcatise, quiitase catli nijchijtoc huan quisentlachilise. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Huan amojuanti nimechtitlanis campa hueli ipan sequinoc tlalme huan nimechtojtocas ica se machete nomaco. Huan amotlal mocahuas quen se huactoc tlali, huan amoaltepehua mocahuas quen tlasoli. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Huan quema anitztose ipan inintlal amocualancaitacahua, nopa tlali catli nimechmacac mosiyajquetzas. Quena, pampa amo anquicahuiliyayaj nopa tlali ma mosiyajquetzas sesen chicome xihuitl quema anitztoyaj, nimechtojtocas huan masque eltos tlasemantoc, nopa tlali mosiyajquetzas ica paquilistli quen quinamiquiyaya mosiyajquetzas. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Huan amojuanti catli noja anitztose ipan sequinoc tlalme, nimechchihuas para tlahuel ximajmahuica ipan amoyolo hasta quema anquicaquise mojmolinía se tlasoli, ancholose pampa anmoilhuise acajya anmechsenpanohua ica machete. Quena, anmajmahuise hasta anmotlalose huan anhuetzise. Quej ni amopantis anisraelitame quema anitztose ipan amocualancaitacahua inintlal. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Hasta anmocuitiquisase se ica seyoc quema ancholose quen anmechsenpanosquíaj amocualancaitacahua ica machete, pero amo. Huan ayacmo tleno huelis anquichihuase iniixpa amocualancaitacahua pampa ayacmo anquipiyase chicahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Huan anixpolihuise nopona tlatlajco inijuanti. Quena, elis quen inintlal anmechcuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Huan amojuanti catli noja anitztose ipan nopa tlali tlen amocualancaitacahua anmotequipachojtinemise por amotlajtlacol. Quena, mojmostla anquipolojtiyase más amochicahualis ica nopa tlajtlacoli catli amojuanti huan amohuejcapan tatahua anquichijtoque. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","41","“Pero teipa anquipannextise huan antechpohuilise nochi amotlajtlacolhua, huan antechpannextilise nopa tlajtlacoli catli quichijque amohuejcapan tatahua. Quena, antechpohuilise quen amohuejcapan tatahua amo nechneltoquilijque notlanahuatil huan san quichijtinenque catli na amo nijnequi niquitas. Huan yeca niquinnextili nocualancayo huan niquinhuicac ipan inintlal inincualancaitacahua. Huan quema amojuanti anmoechcapanose huan anquiselise nopa tlatzacuiltilistli catli quinamiqui para nochi amotlajtlacolhua noixpa, ");
INSERT INTO nhwBl_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","huajca na niquelnamiquis nopa camanali catli nijchijqui ihuaya Abraham, Isaac huan Jacob huejcajya. Huan niquelnamiquis nopa tlali catli niquinmacac huan quenicatza ama mocahua tlasosolijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Pampa monequi para nopa tlali ma mosiyajquetzas huan amo aqui itztos nopona quen na niquijto quinamiqui para mosiyajquetzas. Huan anisraelitame teipa anquiselise amotlatzacuiltilis pampa amo anquitlepanitaque notlanahuatil, niyon amo anquinejque ma nimechnahuati. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","“Huan masque anquichijtoque miyac tlajtlacoli huan anitztose ipan amocualancaitacahua inintlal, na nimechelnamiquis. Amo nimechtlahuelcahuas, niyon amo nimechtzontlamiltis nochi amojuanti, niyon amo nijsosolos nopa camanali catli nijchijqui amohuaya. Na niamoTECO Dios. ");
INSERT INTO nhwBl_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Huan pampa nimechicnelía, niquelnamiquis nopa camanali catli nijchihua ininhuaya amohuejcapan tatahua quema niquinquixti ipan tlali Egipto quema nochi sequinoc tlalme ehuani san mosentlachiliyayaj. Quena, niquinquixti para nielis niininTECO Dios.” ");
INSERT INTO nhwBl_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Huajca nica eltoc nochi nopa tlanahuatilme catli TOTECO quimacac Moisés ipan nopa tepetl Sinaí para ma quinilhuis israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Xiquinilhui israelitame ni tlanahuatilme. Quema se acajya ica iseltzi quinequis nechtestigojquetzas na para moiyocacahuas para na, niamoTECO, o quiiyocacahuas se icone huan teipa quinequis momanahuis para elis majcajtoc, quej ni monequi tlaxtlahuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Para se tlacatl catli quipiya 20 xihuitl hasta catli quipiya 60 xihuitl, tlaxtlahuas 50 plata tomi catli quitequihuíaj ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Pero sintla eli se sihuatl, huajca san tlaxtlahuas 30 plata tomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Huan para se oquichpil catli quipiya macuili xihuitl hasta 20 xihuitl, tlaxtlahuase 20 plata tomi. Huan para se sihuapil catli quipiya 5 xihuitl hasta 20 xihuitl, tlaxtlahuase 10 plata tomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Pero para se piloquichpiltzi catli sanoc quipiya se metztli ica tlacatqui huan hasta catli quipiya macuili xihuitl, tlaxtlahuase macuili plata tomi. Huan sintla se pilsihuapiltzi catli quipiya se metztli hasta macuili xihuitl, tlaxtlahuase eyi plata tomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Huan para se tlacatl catli quipiya 60 xihuitl para huejcapa, tlaxtlahuas 15 plata tomi. Huan sintla eli se sihuatl catli quipiya 60 xihuitl para huejcapa, tlaxtlahuas majtlactli plata tomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Huan sintla se masehuali nelteicneltzi tlatestigojquetztoc para motemacas ica na huan teipa quinequi sempa mocohuas pero amo huelis quisentilis nopa tomi catli monequi, huajca ma quihuicaca campa nopa totajtzi. Huan nopa totajtzi quiixquetzas quesqui plata tomi monequi tlaxtlahuas nopa tlacatl teicneltzi. Quena, quiixquetzas quen quiitas para quiaxilis itlaxtlahuil nopa tlacatl catli tlatestigojquetztoc para motemactilis ica na, niamoTECO, huan quinequi sempa mocohuas para mocahuas majcajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“Pero sintla se acajya tlatestigojquetztoc para nechmacas na, niamoTECO, se tlapiyali, huajca nopa tlacatl monequi nelía nechmactilis nopa tlapiyali. Nochi nopa tlamantli catli se quiijtos para nechmacas elis tlatzejtzeloltic huan tlaiyocatlalili para na. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Huan sintla se tlatestigojquetztoc para nechmacas na, niamoTECO, se nemactli, amo hueli moyolcuepas. Huan sintla moilhuijtoc catlique tlapiyali nechmacas huan tlatestigojquetztoc para ya nopa nechmacas, huajca nopa tlapiyali ayacmo huelis quipatlas. Niyon amo hueli nechmacas seyoc catli más cuali o más fiero. Huan sintla nechmacasquía seyoc quen ipatlaca, huajca nochi nopa ome tlapiyalme mocahuase tlaiyocatlalilme para na, niamoTECO, huan amo hueli sempa quincohuas. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“Huan sintla tlatestigojquetzas para nechmacas se tlapiyali catli amo tlapajpactli para elis tlacajcahualistli para na, niamoTECO, huajca nopa tlacatl quihuicas campa nopa totajtzi nopa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Huan nopa totajtzi quitlachilis sintla cuali o amo cuali, huan catli nopa totajtzi quiixquetzas para ipati, ya nopa monequi quiixtlahuas ipan tiopamitl para sempa mocohuis nopa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Pero sintla teipa quinequis sempa quicohuas nopa tlapiyali, monequi tlaxtlahuas catli ipati quiixquetztoc nopa totajtzi huan nojquiya monequi quimiyaquilis seyoc 20 por ciento para quej nopa, nopa tlapiyali sempa elis iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","15","“Sintla acajya quiiyocatlalis ichaj para elis tlatzejtzeloltic para na, niamoTECO, huan teipa sempa quinequis mocohuis para iaxca, huajca quej ni quichihuas. Monequi ma huala nopa totajtzi ma quitlachiliqui nopa cali huan quiixquetzas quesqui ipati. Huan nopa imiyaca tomi catli nopa totajtzi quiixquetzas, huajca ya nopa elis ipati. Huan iyoca tlen nopa ipati catli quiixquetztoc nopa totajtzi, nopa tlacatl monequi quimiyaquilis seyoc 20 por ciento. Huan quema tlaxtlahuas nochi ya nopa, nopa cali sempa elis iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“Huan sintla se acajya quiiyocatlalis se quentzi tlali catli quiselijtoc tlen ihuejcapan tatahua para nechmacas para elis noaxca, niamoTECO, huajca nopa totajtzi monequi quitlachilis quenicatza ihuexca nopa tlali huan quesqui litros tlen xinachtli monequi para quitocas. Quej nopa quiixquetzas ipati. Sintla quiitas para ipan nopa pedazo monequi 220 litros tlen iyol cebada para quitocas para 50 xihuitl huajca monequi tlaxtlahuas 50 plata tomi. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Huan sintla se tlacatl quiiyocatlalis itlal ipan nopa xihuitl 50 quema nochi mocahua majcajtoc, huajca nochi catli ipati monequi tlaxtlahuas ipan tiopamitl para mocohuis sempa nopa tlali. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Pero sintla quiiyocatlalis nopa tlali quema ya panotoc nopa xihuitl quema nochi mocahuas majcajtoc, huajca nopa totajtzi quipohuas quesqui xihuitl panotoc tlen nopa xihuitl huan quiquixtilis tlen catli ipati elisquía para nejmaxtic 50 xihuitl. San monequi tlaxtlahuas para quesqui xihuitl polihui para sempa ajsis nopa xihuitl quema mocahuas majcajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","“Huan sintla nopa tlacatl catli quiiyocatlali itlal sempa quinequis quicohuas nopa tlali para iaxca, huajca monequi tlaxtlahuas catli nopa totajtzi quiixquetzas para ipati huan iyoca monequi quimiyaquilis seyoc 20 por ciento. Huan quej nopa, nopa tlali sempa elis iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pero sintla amo quicohuas nimantzi para sempa elis iaxca huan quinemaquiltis seyoc, huajca teipa ayacmo quema sempa huelis quicohuas para iaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Huan quema ajsis nopa xihuitl para nochi mocahuas majcajtoc, nopa tlali nojquiya mocahuas majcajtoc, huan elis tlaiyocacahuali para na, niamoTECO, huan teipa elis para nopa totajtzitzi iniaxca. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“Huan sintla acajya nechiyocatlalilis na, niamoTECO, se quentzi tlali catli san quicojtoc huan amo quiselijtoc tlen ihuejcapan tatahua, ");
INSERT INTO nhwBl_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","huajca nopa totajtzi quipohuas quesqui xihuitl polihui para ajsis nopa xihuitl para nochi mocahuas majcajtoc. Huan quej nopa quiixquetzas ipati. Huan nopa tlacatl catli quiiyocatlalijtoc itlal para na, niamoTECO, monequi nimantzi tlaxtlahuas ipan nopa tonal. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Huan quema ajsis nopa xihuitl para nochi mocahuas majcajtoc, nopa tlali sempa elis iaxca nopa achtihui tecojtli catli nopa tlacatl quicohuili. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“Ipan nochi tlamantli catli anquiixquetzase ipati, monequi anquitequihuise nopa tlatamachihuali para ietica nopa plata tomi catli motequihuía ipan nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“Nochi huacaxme huan borregojme catli achtihui tlacatij tlen ininnana amo hueli anquiniyocatlalise para na, niamoTECO, pampa ya eltoc noaxcahua catli achtihui tlacatij. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Pero sintla anquinequij anquiiyocatlalise se tlapiyali catli se iachtihui ejca se tlapiyali catli amo tlapajpactli para tlacajcahualistli huan yeca amo noaxca, huajca nopa tlacatl catli iaxca huelis sempa mocohuis sintla tlaxtlahuas quen quiixquetztoc nopa totajtzi para ipati nopa tlapiyali. Huan iyoca monequi quimiyaquilis seyoc 20 por ciento tlen catli ipati. Huan sintla nopa tlacatl amo quinequis quicohuas sempa nopa tlapiyali catli nechmaca, huajca nopa totajtzi quinemaquiltis nopa tlapiyali seyoc quen quiixquetztoc para ipati pampa amo cuali para tlacajcahualistli. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“Pero se masehuali, o se tlapiyali, o se tlali catli se quiselijtoc tlen ihuejcapan tatahua huan senquistoc nechmacatoc para elis noaxca, ayacmo aqui huelis quicohuas o quinemacas ica seyoc, pampa ya nopa senquistoc noaxca huan tlahuel tlatzejtzeloltic para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Sintla quiijtohua tlanahuatili para monequi miquis se masehuali, amo huelis tlaxtlahuas para momanahuis. Monequi miquis. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“Se diezmo tlen nochi catli temaca momila eltoc noaxca. Quema nopa tlali temacas iyol o nopa cuame temaca inintlajca, monequi antechmacase na, niamoTECO, se tlatamachihuali tlen sesen majtlactli tlatamachihuali. Pampa ya nopa eli noaxca huan tlatzejtzeloltic para na. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Huajca sintla acajya quinequis sempa mocohuis nopa iyol tlen imila o itlajca icuatlatochua, huajca monequi tlaxtlahuas catli ipati huan quimacas nopa totajtzi huan nojquiya monequi quimiyaquilis seyoc 20 por ciento. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“Huan ipan sesen majtlactli tlapiyalme monequi anquiquixtise se para antechmacase na, niamoTECO. Amo xiquintlapejpenica catlique tlapiyalme elise noaxcahua. Quema nopa tlapiyalme motecpanaj para calaquise ipan tlatzactli huan nopa tlamocuitlahuijquetl quinpohua sesen quema panoj itzala icuatopil, sesen huelta quema quipohuas hasta ipan majtlactli, huajca nopa tlapiyali elis noaxca na. Quena, ya nopa se diezmo huan tlatzejtzeloltic para na nopa majtlacpa tlapiyali. ");
INSERT INTO nhwBl_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Amo quenqui sintla nopa tlapiyali catli nechtocarohua elis cuali o amo cuali, amo huelis quiixpatlas. Huan sintla quipatlas, huajca nochi ome tlapiyalme, nopa catli eltoya noaxca huan nopa catli ipatlaca, nochi mocahuase tlaiyocatlalilme para na, niamoTECO. Huan amo aqui hueli sempa quicohuas para iaxca.” ");
INSERT INTO nhwBl_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Huajca ya ni nopa tlanahuatilme catli TOTECO quimacac Moisés ipan nopa tepetl Sinaí para ma quinilhuis nochi israelitame.");
INSERT INTO nhwBl_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","TOTECO quicamanalhui Moisés ipan nopa huactoc tlali Sinaí ipan nopa yoyon tiopamitl campa mopantiyayaj. Quicamanalhui ipan 15 itequi nopa ompa metztli ipan nopa israelita calendario 1:1 Quemantic huetzis ni tonal ipan abril huan quemantic ipan mayo ipan tocalendario tlen ama. quema ya panotoya se xihuitl huan se metztli para nopa israelitame quistoyaj tlen tlali Egipto. Huan ya ni catli TOTECO quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","3","―Monequi ta ihuaya Aarón xijtlananaca se censo tlen nochi israelita tlacame catli quiaxitijtoque 20 xihuitl para huejcapa huan catli hueli tlahuilanatij. Xiquijcuiloca sese itoca, huan itoca itata, huan itoca ihuejcapan tata, huan xiquinpohuaca quesqui itztoque. Huan quema ya anquinpojtose nochi, xiquintecpanaca ipan huejhueyi pamitl quen soldados para tlahuilanase. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Nojquiya anmechpalehuis se iteipan ixhui nochi nopa 12 huejcapan tatame catli huejcajya itztoyaj. Sesen motlapalehuijca elis catli más tlayacana ipan iteiximatcahua ipan ihueyi familia. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","15","Ya ni inintoca nopa tlayacanani catli anmechpalehuis tlen sesen hueyi familia: Familia, Tlayacanquetl Rubén, Elisur, icone Sedeur Simeón, Selumiel, icone Zurisadai Judá, Naasón, icone Aminadab Isacar, Natanael, icone Zuar Zabulón, Eliab, icone Helón Efraín, icone José, Elisama, icone Amiud Manasés, icone José, Gamaliel, icone Pedasur Benjamín, Abidán, icone Gedeoni Dan, Ahiezer, icone Amisadai Aser, Pagiel, icone Ocrán Gad, Eliasaf, icone Deuel Neftalí, Ahira, icone Enán ");
INSERT INTO nhwBl_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ya ni elque inintoca nopa tlayacanani catli tlapejpenilme para tlayacanase ipan sesen hueyi familia. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Huan Moisés huan Aarón ininhuaya ni tlayacanani catli TOTECO quintocaxtlalijtoya, ");
INSERT INTO nhwBl_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","quinnotzque nochi israelitame ma mosentilica ipan nopa tonal quema TOTECO quicamanalhui Moisés. Huan pejque quinijcuilohuaj nochi tlacame catli ya quiaxitijtoyaj 20 xihuitl ica huejcapa. Huan sesen quiijcuilojque ajqueya eliyaya ihuejcapan tata huan ajqueya itata. Moijcuilojque sesentzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Huajca nopona ipan nopa huactoc tlali catli itoca Sinaí quinpojque nochi ni tlacame quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Huan quema Moisés, Aarón huan nopa 12 tlayacanani tlen israelitame ya tlantoya inintequi, ya ni quesqui tlacame quipojque catli quipixque 20 xihuitl para huejcapa catli huelque yohuij tlahuilanatij: Familia, Quesqui Rubén, iachtihui ejca Israel, 46,500 Simeón, 59,300 Gad, 45,650 Judá, 74,600 Isacar, 54,400 Zabulón, 57,400 Efraín, icone José, 40,500 Manasés, icone José, 32,200 Benjamín, 35,400 Dan, 62,700 Aser, 41,500 Neftalí, 53,400 ");
INSERT INTO nhwBl_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Huajca ya ni techilhui catli quipantijque Moisés huan Aarón huan nopa 12 tlayacanani catli tlayacanayayaj ipan sese ifamilia tlen iteipan ixhuihua Israel. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Quinpojque nopa israelita tlacame catli quiaxitijtoyaj 20 xihuitl ica huejcapa huan catli huelque yohuij para tlahuilanatij. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Huan quipantijque para ica nochi itztoyaj 603 mil 550 tlaca israelitame catli huelque tlahuilanatij. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Pero amo quinpojtoyaj tlacame ipan nopa hueyi familia tlen iteipan ixhuihua Leví, ");
INSERT INTO nhwBl_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","pampa TOTECO quiilhuijtoya Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Quema tijtlananas se censo tlen nochi israelitame catli hueli tlahuilanatij, amo xiquinpohua nopa levitame, inijuanti catli hualajque ipan nopa huejcapan tata Leví. Amo xiquintlali san sejco ihuaya ne sequinoc israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Pero xiquintequimaca nochi levita tlacame ma quimocuitlahuica noyoyon tiopa catli quipiya nopa caxa, huan nochi catli eltoc ipani, huan nochi tlamantzitzi catli nopona calijtic quitequihuíaj. Quema anyase hasta seyoc lado, elis levitame inintequi para quihuicase nopa yoyon tiopamitl campa na nimocahua amohuaya huan nojquiya quihuicase nochi catli quipiyaj. Nojquiya levitame ma quiquetzaca ininyoyoncalhua nechca nochaj para ma quiyahualoca. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Huan quema monequi quihuicase nopa yoyon tiopamitl, inijuanti catli quicocopitzase. Huan quema anajsise campa anquiquetzase amoyoyoncalhua, inijuanti catli sempa quicualchijchihuase nopa Tiopamitl quen eltoya. Pero sintla se tlacatl catli amo se iteipan ixhui Leví quinechcahuis nopa yoyon tiopamitl campa na nimocahua amohuaya, monequi anquimictise. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Huan monequi nochi masehualme ipan sesen hueyi familia tlen israelitame quipiyase campa quiquetzase ininyoyoncalhua san sejco, ica se pamitl nopona campa quintocarohua iteipan ixhuihua ininhueyi familia. Huan sesen huejcapan tata quipiyase ininbandera para quinextis canque mocahua ininpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Pero nochi nopa levitame quiquetzase ininyoyoncalhua yahualtic tlen nopa yoyon tiopamitl campa nimocahua amohuaya huan catli quipiya catli amohuaya nimocajtoc pampa inintequi levitame quimocuitlahuise nopa tiopamitl. Quimocuitlahuise para aqui hueli masehuali amo huelis monechcahuis huan amo nicualanis ica anisraelitame.” ");
INSERT INTO nhwBl_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Huajca nopa israelitame quichijque senquistoc nochi catli TOTECO quinahuati Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nojquiya TOTECO quiilhui Moisés huan Aarón ni tlanahuatilme: ");
INSERT INTO nhwBl_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Nochi israelitame monequi quiquetzase ininyoyoncalhua para huejca quiitase nopa yoyon tiopamitl campa timopantíaj. Huan sesen mocahuas nechca ibandera ihuejcapan tata huan mocahuas nechca ihueyi bandera nopa tlahuilanca pamitl catli quitocarohua. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","“Nopa tlacame tlen nopa huejhueyi familias tlen Judá, Isacar huan Zabulón quiquetzase ininyoyoncalhua huan ininbandera ica campa hualquisa tonati tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlahuilanatij: Familia, Tlayacanquetl, Quesqui Judá, Naasón, icone Aminadab, 74,600 Isacar, Natanael, icone Zuaranca, 54,400 Zabulón, Eliab, icone Helón, 57,400 ");
INSERT INTO nhwBl_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Huajca ipan nopa tlahuilanca pamitl tlen Judá elis tlacame tlen hualahuij ipan ni eyi huejhueyi familias huan san sejco ajsique 186,400 tlacame catli huelque tlahuilanase. Huan ni tlahuilanca pamitl tlayacantiyas quema anisraelitame anquistehuase para anmochihuase ipan seyoc lugar. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","15","“Nopa tlacame tlen nopa huejhueyi familias tlen Rubén, Simeón huan Gad quiquetzase ininyoyoncalhua huan ininbandera ica sur tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlahuilanatij: Familia, Tlayacanquetl, Quesqui Rubén, Elisur, icone Sedeur, 46,500 Simeón, Selumiel, icone Zurisadai, 59,300 Gad, Eliasaf, icone Reuel, 45,650 ");
INSERT INTO nhwBl_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Huajca ipan nopa tlahuilanca pamitl Rubén elis tlacame catli hualahuij ipan ni eyi huejhueyi familias huan san sejco ajsique 151,450 tlacame catli huelque tlahuilanase. Huan ni tlahuilanca pamitl motecpanase iica nopa tlahuilanca pamitl Judá quema anquistehuase para anmochihuase ipan seyoc lugar. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“Huan teipa motecpanase nopa levitame catli quihuicase noyoyon tiopa, niamoTECO quema anquisase para seyoc lado. Huan quisase tlatlajco ipan nochi huejhueyi familias san quen mocahuaj tlatlajco ininyoyoncalhua. Quej nopa quisase campa monequi sesen itzintla ibandera. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","23","“Nopa tlacame tlen nopa huejhueyi familias tlen Efraín, Manasés huan Benjamín quiquetzase ininyoyoncalhua huan ininbandera ica campa temo tonati tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlahuilanatij: Familia, Tlayacanquetl, Quesqui Efraín, Elisama, icone Amiud, 40,500 Manasés, Gamaliel, icone Pedasur, 32,200 Benjamín, Abidán, icone Gedeoni, 35,400 ");
INSERT INTO nhwBl_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Huajca ipan nopa itlahuilanca pamitl Efraín elis tlacame catli hualahuij ipan ni eyi huejhueyi familias huan san sejco mochihuase 108,100. Huan ni tlahuilanca pamitl motecpanase iica nopa levitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","30","“Nopa tlacame tlen nopa huejhueyi familias tlen Dan, Aser huan Neftalí quiquetzase ininyoyoncalhua huan ininbandera ica norte tlen nopa yoyon tiopamitl. Huan nica eltoc inintoca sesen hueyi familia, inintlayacanca huan quesqui tlacame huelque yohuij tlahuilanatij: Familia, Tlayacanquetl, Quesqui Dan, Ahiezer, icone Amisadai, 62,700 Aser, Pagiel, icone Ocrán, 41,500 Neftalí, Ahira, icone Enán, 53,400 ");
INSERT INTO nhwBl_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Huajca ipan nopa tlahuilanca pamitl tlen Dan elis nopa soldados tlen ni eyi huejhueyi familias huan san sejco ajsique 157,600 tlacame catli huelque tlahuilanase. Huan ni tlahuilanca pamitl motecpanase iica ibandera hasta teipa huan nejnemise iica nopa tlahuilanca pamitl Efraín.” ");
INSERT INTO nhwBl_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Huajca quema quinpojtoyaj nochi israelita tlacame catli huelque tlahuilanatij ipan nochi huejhueyi familias ajsique 603,550 tlacame. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pero amo quintlalijque san sejco nopa levitame pampa TOTECO quinahuatijtoya Moisés ma amo quinpohuaj ica catli tlahuilanase. ");
INSERT INTO nhwBl_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Huajca nopa israelitame quichijque nochi senquistoc quen TOTECO quinahuatijtoya Moisés. Huan sesen hueyi familia quiquetzque ininchaj tlen yoyomitl iica ibandera campa quinilhuijtoyaj. Huan quema quistejque, motecpantiyajque huan nejnenque sesen hueyi familia senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ya ni techpohuilía tlen iteiximatcahua Moisés huan iicni Aarón ipan nopa tonali quema TOTECO quicamanalhui Moisés ipan nopa tepetl Sinaí. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Inintoca iconehua Aarón eliyaya: Nadab catli achtihui ejquetl, Abiú, Eleazar, huan Itamar. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Nochi inijuanti quinajalti ica aceite huan quiniyocacajqui ma elica totajtzitzi para ma tequitica tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Pero Nadab huan Abiú mijque iixpa TOTECO nepa ipan nopa huactoc tlali Sinaí pampa amo quitoquilijque icamanal TOTECO huan quitequihuijque se tlitl catli amo tlatzejtzeloltic. Huan catli mijque ayamo quinpiyayaya ininconehua, yeca san mocajqui Eleazar huan Itamar para quipalehuise inintata Aarón ipan itequi quen totajtzi ipan inejnemilis. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Xiquinnotza ma hualaca nochi iteipan ixhuihua Leví huan xijchihua para ma monextica iixpa Aarón para quitequipanose. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Huan inijuanti quitequipanose Aarón huan quintequipanose nochi israelitame pampa quichihuase miyac piltequitzitzi catli tiquinilhuis ma quichihuaca ipan nopa achtihui cuartos ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Quimocuitlahuise nopa cuamesas huan nochi tlamantzitzi catli eltoc ipan nopa yoyon tiopamitl campa timopantíaj. Huan quichihuase nochi catli nimechnahuatijtoc anisraelitame xijchihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Huajca xiquinmaca Aarón huan itelpocahua nochi nopa levitame. Quena, nochi tlacame ipan nopa hueyi familia Leví quinpalehuise. Huan levitame mocahuase iyoca tlen nochi ne sequinoc israelitame para melahuac ma elica iaxcahua Aarón huan iniaxcahua itelpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Pero san Aarón huan itelpocahua xiquintequimaca para ma elica totajtzitzi, huan ne sequinoc levitame, amo. Sintla seyoc catli amo totajtzi quichihuas itequi se totajtzi huan monechcahuis campa más tiopan calijtic, monequi xijmictica.” ");
INSERT INTO nhwBl_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Huan sempa TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ya nimechilhuijtoc para monequi techmacaca nochi amoachtihui ejcahua, pampa quen nopa nechtocarohua para noaxcahua. Pero para amo monequi antechmacatiyase amoachtihui ejcahua, ininpatlaca niquinselis nochi levitame para ma elica noaxcahua ininpatlaca nochi sequinoc israelitame, ");
INSERT INTO nhwBl_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","pampa na noaxcahua nochi catli achtihui tlacatij. Quema nijchijqui para ma miquica nochi catli achtihui ehuani tlen nochi tlali Egipto, nimocuili nochi coneme catli achtihui ehuani tlen nochi anisraelitame, huan nojquiya nochi tlapiyalme catli achtihui tlacatise, huan yeca nochi noaxcahua. Na niamoTECO.” ");
INSERT INTO nhwBl_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Huan TOTECO quinojnotzqui Moisés sempa ipan huactoc tlali Sinaí huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Xiquinpohua nochi levitame ipan sesen cali, huan iyoca xiquinpohua ajqueyame hualajque ipan sese itelpoca nopa huejcapan tata Leví. Xiquinpohua nochi oquichpilme catli ya quiaxitijque se metztli para huejcapa.” ");
INSERT INTO nhwBl_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Huan Moisés quinpojqui senquistoc quen quinahuatijtoya TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Huan nopa huejcapan tata Leví quinpixqui eyi itelpocahua: Gersón, Coat huan Merari. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Huan Gersón quinpixqui ome itelpocahua: Libni huan Simei. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Huan Coat quinpixqui nahui itelpocahua: Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Huan Merari quinpixqui ome itelpocahua: Mahli huan Musi. Huajca nica nimitzilhuijtoc ajqueya itztoyaj nopa tlayacanani ipan nopa familias tlen iteipan ixhuihua nopa huejcapan tata Leví huan ama tiquintocaxtía nochi levitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Huajca iixhuihua Gersón mochijque ome huejhueyi familias catli quisqui tlen itelpocahua, Libni huan Simei. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Huan ama nochi inintlaca ixhuihua catli quipiyayayaj se metztli para huejcapa mochijque 7 mil 500. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Huan TOTECO quinnahuati iixhuihua Gersón ma quiquetzaca ininyoyoncalhua nechca nopa yoyon tiopamitl ica campa huetzi tonati. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Huan Eliasaf, icone Lael, elqui nopa tlayacanquetl tlen iixhuihua Gersón. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Huan inijuanti quipixque inintequi para quimocuitlahuise nopa tiopamitl huan nochi yoyomitl catli quipixqui. Quimocuitlahuijque itzajca, icortinas, ");
INSERT INTO nhwBl_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","huan nopa icortinas catli mochihua nopa tlatzactli catli quiyahualohua nopa tlaixpamitl huan tiopamitl, huan nopa cortinas catli quicuapilohuaj campa calaquise, huan nochi mecatl catli quitequihuía tiopamitl. Ya nopa eliyaya inintequi iixhuihua Gersón. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Huan iixhuihua Coat mochijque nopa nahui huejhueyi familias catli quisque tlen itelpocahua, Amram, Izhar, Hebrón huan Uziel. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Huan ama nochi inintlaca ixhuihua catli quipiyaj se metztli para huejcapa mochijque 8 mil 600. Huan iixhuihua Coat tequitiyayaj tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Huan TOTECO quinnahuati iixhuihua Coat ma quiquetzase ininyoyoncalhua nechca tiopamitl ica sur. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Huan Elizafán, icone Uziel, elqui nopa tlayacanquetl tlen iixhuihua Coat. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Huan inijuanti quipixque tlanahuatili para quimocuitlahuise nopa caxa, nopa cuamesa para pantzi, nopa tlahuil quetzali, nopa tlaixpamitl para copali, nopa tlaixpamitl para Tlacajcahualistli Tlatlatili, huan nochi tepostli catli quitequihuijque tiopan calijtic. Nojquiya inintequi para quimocuitlahuise nopa cortina yejyectzi catli quitzajqui campa Tlahuel Tlatzejtzeloltic. Nojquiya inintequi para quicualtlalise nochi ni tlamantli sintla monequiyaya se quentzi tequitl. Ya nopa eliyaya inintequi iixhuihua Coat. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Huan Eleazar, icone nopa totajtzi Aarón, eliyaya nopa tlayacanquetl catli más hueyi ipan nochi levitame. Yaya catli quintequimacayaya nopa tlacame catli tlapalehuiyayaj tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Huan iixhuihua Merari mochijque nopa ome huejhueyi familias catli quisque tlen itelpocahua Mahli huan Musi. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Huan ama nochi inintlaca ixhuihua catli quipiyaj, se metztli para huejcapa mochijque 6 mil 200. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Huan TOTECO quinnahuati quiquetzase ininyoyoncalhua nechca tiopamitl ica norte. Huan Zuriel, icone Abihail, elqui nopa tlayacanquetl tlen iixhuihua Merari. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Huan inijuanti quipixque inintequi para quimocuitlahuise nopa huapalme ica catli quichijque caltechtli, nopa cuaixtlapalme, nopa tlaquetzalme, huan inintepos cuatetonyo, huan nochi tlamantzitzi catli quitequihuía. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Nojquiya quimocuitlahuijque nopa tlaquetzalme para nopa calixpamitl catli quiyahualohuayaya nopa tiopamitl ihuaya nopa tepos cuatetomitl para tlaquetzalme, ihuaya iniestacas huan ininmecayohua. Ya nopa elqui inintequi iixhuihua Merari. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Huan TOTECO quinnahuati Moisés, Aarón huan ininconehua ma quiquetzaca ininyoyoncalhua nechca tiopamitl ica campa hualquisa tonati. Huan quipixque inintequi para quinmocuitlahuilise nochi nopa yoyon tiopamitl campa TOTECO mopantiyaya ica nopa israelitame. Huan sintla catli hueli tlacatl quinechcahuisquía nopa yoyon tiopamitl, monequi quimictise. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Huan nochi nopa levita tlacame catli Moisés huan Aarón quinpojque catli quipiyayayaj se metztli para huejcapa ajsique 22 mil oquichpilme huan tlacame. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Teipa TOTECO quiilhui Moisés: “Xiquinpohua nochi achtihui ehuani oquichpilme huan tlacame ipan israelitame catli quipiyaj se metztli para huejcapa, huan xiquinijcuilo ica inintoca. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Nochi levitame elise noaxcahua para nechtequipanose na, niamoTECO. Huan yeca ayacmo nimoaxcatis iniachtihui conehua nochi israelitame. Huan inintlapiyalhua levitame nimoaxcatis, huan yeca ayacmo elis noaxca iniachtihui cone sesen sihua tlapiyali catli iniaxca sequinoc israelitame catli amo levitame.” ");
INSERT INTO nhwBl_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Huajca Moisés quinpojqui nochi israelitame catli achtihui ehuani catli oquichpilme o tlacame senquistoc quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Huan nochi oquich israelitame catli quiaxitijtoyaj se metztli quinijcuilojque huan mochijque 22 mil 273 por nochi. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Techmaca nochi levitame para nechtequipanose ininpatlaca amooquichpilhua catli achtihui ehuani, huan techmaca inintlapiyalhua nopa levitame quen ininpatlaca inioquich tlapiyalhua catli achtihui ehuaj tlen nochi israelitame. Quena, nochi levitame elise noaxcahua para ma nechtequipanoca na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pero nopa achtihui ehuani oquichpilme huan tlacame tlen nochi israelitame quionpano ica 273 imiyaca nopa oquichpilme huan tlacame catli itztoyaj levitame. Huajca por nopa 273 achtihui ehuani israelitame, amo aqui se oquichpil o tlaca levita para ica nijpatlas huan monequi antechcohuilise. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Huajca para sesen nopa 273, monequi techmacaca 5 plata tomi catli quipiya 11 gramos ietica quen nopa tlatamachihuali catli quitequihuíaj ipan tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Huan xiquinmactili nopa tomi Aarón ihuaya iconehua para antechcohuilise nopa 273 achtihui ehuani ipan israelitame catli mocajque.” ");
INSERT INTO nhwBl_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Huajca Moisés quiseli nopa tomi tlen nopa masehualme quitlaxtlahuiyayaj por nopa achtihui ehuani israelitame catli mocajque. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Huan para nochi quiseli 1 mil 365 plata tomi ica ietica quen nopa tlatamachihuali catli quitequihuijque ipan tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Huan teipa Moisés quinmactili Aarón huan itelpocahua nopa tomi senquistoc quen TOTECO quinahuatijtoya. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Teipa TOTECO quinnojnotzqui Moisés huan Aarón huan quinilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Xijtlananaca se censo tlen nochi nopa levitame catli nojquiya itztoque iteipan ixhuihua Coat. Xiquijcuiloca ajqueyame hualajque ipan sesen nopa huejhueyi tetajme catli eliyayaj itelpocahua nopa huejcapan tata Coat. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Ama xiquinpohuaca nochi tlacame catli quipiyaj 30 hasta 50 xihuitl huan catli huelise tequitise ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Huan ya ni nopa tequitl catli quichihuase iteipan ixhuihua Coat ica nopa tlamantli tlatzejtzeloltic tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quema monequi anquiijcuinise nopa yoyon tiopamitl para anyase seyoc lugar, Aarón ihuaya iixhuihua calaquise achtihui huan quiquixtilise nopa cortina catli quitzacua ipan puerta campa calaquij campa nopa caxa catli quipiya catli amohuaya nimocajqui, niamoTECO, huan quipajpatlahuase nopa cortina ipan nopa caxa. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Huan ipani nopa cortina quiixtzacuase huan quimimilose ica inincuetlaxo pesojme. Huan iixco quipatlahuilise nopa patiyo yoyomitl catli azultic huan sempa quicalaquise nopa cuahuitl huehueyac ipan ianillos para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Teipa ipan nopa cuamesa campa mocahua nopa pantzi monequi xijpajpatlahuase se yoyomitl azultic. Huan ipan nopa yoyomitl quitlalise nochi platome, cucharas, caxime huan nopa tazajme catli quitequihuíaj quema quitoyahuaj se tlacajcahualistli tlatoyahuali. Huan nojquiya nopa pantzi catli nochipa eltos nopona. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Huan iixco nochi nopa tlamantli quipatlahuase nopa patiyo yoyomitl catli chichiltic. Huan teipa quipiquise ica inincuetlaxo pesojme huan teipa sempa quicalaquise nopa cuahuitl huehueyac catli ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Teipa quicuise seyoc nopa patiyo yoyomitl catli azultic huan quipatlahuase ipan nopa tlahuil quetzali ica itlahuilhua, nopa tepostli para quiitzquise tlicoli, iplatos, huan nochi ixarro para aceite catli nopona quitequihuíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Huan nochi nopa tlamantli ihuaya nopa tlahuil quetzali quimimilose ica inincuetlaxo pesojme. Huan teipa sempa quicalaquise nopa cuahuitl huehueyac para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Teipa quipatlahuase seyoc patiyo yoyomitl azultic ipan nopa tlaixpamitl tlen oro para copali. Teipa quipiquise ica inincuetlaxo pesojme huan sempa quicalaquise nopa huejhueyi cuahuitl para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Huan nochi tlamantzitzi catli motequihuía tiopan calijtic quisentilise huan quitlalise ipan seyoc patiyo yoyomitl azultic. Teipa quiquimilose ica inincuetlaxo pesojme huan sempa quicalaquise nopa huehueyac cuahuitl para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Teipa monequi quiquixtise nochi nopa cuanextli tlen nopa tlaixpamitl campa quitlatíaj tlacajcahualistli. Huan ipan quipatlahuase seyoc patiyo yoyomitl morado. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Huan iixco quitlalise nochi tlen motequihuía ipan tlaixpamitl. Quitlalise itepos caja campa quitemaj cuanextli, iteposchijcolhua para quiitzquise nacatl, ipalas, huan nopa huajcali para quiselis estli, huan nochi sequinoc teposme catli nopona motequihuíaj. Huan teipa quipiquise ica inincuetlaxo pesojme huan sempa quicalaquise nopa huehueyac cuahuitl para ica quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Huan quema Aarón huan itelpocahua ya tlantose para quipijpiquise nochi nopa tlamantli catli tlatzejtzeloltic catli eltoya tiopan calijtic, huajca quena, hueli quicuiquij iixhuihua Coat para quihuicase ipan ojtli hasta campa anajsise. Pero iteipan ixhuihua Coat amo hueli quiitzquise nopa tlamantli tlatzejtzeloltic, pampa miquise. Huajca nochi ni tlamantli inintequi iteipan ixhuihua Coat para quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Huan Eleazar itelpoca nopa totajtzi Aarón quipiyas imaco nopa aceite para tlahuilme, nopa copali catli ajhuiyac mijyotía, nopa tlacajcahualistli tlen harina catli monequi mojmostla, huan nopa aceite catli tlatzejtzeloltic para tlaiyocatlalise para na, niamoTECO. Nelía mocahua imaco Eleazar para quimocuitlahuis nochi nopa yoyon tiopamitl campa nimocahua amohuaya ica nochi cuamesas huan tlamantzitzi catli onca tiopan calijtic huan nochi catli mochijtoc nopona.” ");
INSERT INTO nhwBl_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Huan TOTECO quinilhui Moisés ihuaya Aarón: ");
INSERT INTO nhwBl_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Amo xijcahuilica para iteipan ixhuihua Coat ma quichihuaca tlamantli tequitl catli amo quipiyaj tlanahuatili quichihuase huan quej nopa miquise. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Para amo tlantiyase iixhuihua Coat ipan levitame, quej ni anquichihuase. Aarón huan itelpocahua ma itztoca tiopan calijtic ininhuaya huan ma quinilhuica sesen iixhuihua Coat catli monequi quichihuase huan catli monequi quihuicase para amo quinechcahuise catli tlatzejtzeloltic huan miquise. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Huan sintla amo aqui itelpocahua Aarón tiopan calijtic, amo ma calaquica coatitame niyon se tlatoctzi, pampa huelis quiitase se tlamantli catli tlatzejtzeloltic, huan sintla quiitase se tlenijqui, miquise.” ");
INSERT INTO nhwBl_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Teipa sempa TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Xijtlanana nojquiya se censo tlen nochi nopa levitame catli iixhuihua Gersón catli itztoya huejcajya. Xiquijcuilo ajqueyame hualajque ipan sesen nopa huejhueyi tetajme catli eliyayaj Gersón itelpocahua huejcajya. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Xiquinpohuaca nochi tlacame catli quipiyaj 30 hasta 50 xihuitl catli huelise calaquise ipan notequi, niamoTECO, ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Huan ya ni elis inintequi iixhuihua Gersón quema tequipanose tiopan calijtic huan quema quihuicase tlamamali. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Quihuicase nopa cortinas ica catli quichijque nopa cuartos ipan tiopa, huan nopa inincuetlaxo pesojme catli ica quitzactoque, huan nopa cortinas catli ica quitzacuaj campa ancalaquij tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Nojquiya quihuicase nopa cortinas ipan nopa tlatzactli iteno calixpamitl, ihuaya nopa cortina catli quitzacua campa ancalaquij campa calixpamitl catli quiyahualohua nopa tiopamitl huan nopa tlaixpamitl. Huan quihuicase nochi mecatl huan teposme catli motequihuíaj ipan nopa cortinas. Huajca inintequi iixhuihua Gersón para quihuicase ni tlamantzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Huan Aarón ihuaya itelpocahua quinilhuise iixhuihua Gersón sesen tequitl catli monequi quichihuase huan catli quihuicase. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Pero elis Itamar, itelpoca nopa totajtzi Aarón, catli achi más quinnahuatis iixhuihua Gersón ipan inintequi. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Xiquinpohua nojquiya nochi levitame catli elij iixhuihua Merari tlen huejcajya ica sese itelpocahua, pampa nochi ome mochijtoque huejhueyi tetajme. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Xiquinpohua nochi iniixhuihua catli quipiyaj 30 hasta 50 xihuitl huan hueli calaquise tequipanose tiopan calijtic. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Iixhuihua Merari quihuicase nopa tiopamitl ihuapalyohua, icuaixtlapalhua, itlaquetzalhua huan itepos cuatetonyo. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Nojquiya quihuicase nopa tlaquetzalme ipan calixpamitl huan inintepos cuatetonyo, huan inintepos estacas, huan ininmecayohua huan nochi nopa tlamantzitzi catli quitequihuíaj. Huan Itamar monequi quinotzas sesen tlacatl ica itoca huan quiilhuis tlaque quihuicas quema anmijcuinise. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Huajca ya ni eli inintequi iixhuihua Merari huan monequi quinnahuatis Itamar, icone nopa totajtzi Aarón.” ");
INSERT INTO nhwBl_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Huajca Moisés huan Aarón huan nochi nopa tlayacanani tlen nopa israelitame quinpojque iixhuihua Coat. Huan quiniyocatlali ipan nahui familias quen quisque tlen inahui telpocahua Coat huejcajya. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Quinpojque catli quipixque 30 hasta 50 xihuitl huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Huan iixhuihua Coat ajsique 2 mil 750. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ya ni elque nochi iixhuihua Coat catli hueliyaya tlapalehuise ipan nopa yoyon tiopamitl. Huan Moisés huan Aarón quinpojque huan quinijcuilojque senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Huan nojquiya quinpojque iixhuihua Gersón. Huan quiniyocatlali ipan ome familias quen quisque tlen sese iome telpocahua Gersón huejcajya. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Quinpojque catli quipixque 30 hasta 50 xihuitl, ");
INSERT INTO nhwBl_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamitl huan ajsique 2 mil 630. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Huajca ya ni elque nochi iixhuihua Gersón catli hueliyaya tlapalehuise ipan nopa yoyon tiopamitl campa timopantíaj. Huan Moisés huan Aarón quinpojque huan quinijcuilojque senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Huan nojquiya quinpojque iixhuihua Merari. Huan quiniyocatlali ipan ome familias quen quisque ipan sese iome telpocahua Merari huejcajya. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Quinpojque catli quipixque 30 hasta 50 xihuitl huan quinijcuilojque para quitequipanose TOTECO ipan nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Huan iixhuihua Merari ajsique 3 mil 200. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Huajca ya ni elque nochi iixhuihua Merari catli hueliyaya tlapalehuise ipan nopa yoyon tiopamitl. Huan Moisés huan Aarón quinpojque senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Huan Moisés huan Aarón quichijque se suma tlen nochi levitame catli itztoyaj ipan nopa tonal. Huan quiijcuilojque catli quisque ipan Coat, Gersón huan Merari catli elque ieyi telpocahua Leví catli huejcajya. Huan quiijcuilojque catli quisque tlen sese ininchicueyi telpocahua. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Huan nopa tlacame catli quipixque 30 hasta 50 xihuitl huan huelque tlapalehuise ipan tiopamitl huan tlamamase, ");
INSERT INTO nhwBl_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ajsique 8 mil 580. ");
INSERT INTO nhwBl_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Huajca ya ni elque nochi iteipan ixhuihua Leví catli huelque tlapalehuise ipan tiopamitl. Huan senquistoc quen TOTECO quinahuatijtoya Moisés, quinpojque nochi catli quichihuase tequitl o catli quihuicase tlamantzitzi. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Teipa TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Xiquinnahuati nochi israelitame para ma quinquixtica tlen ininchajchaj nochi catli palani ininnacayo ica lepra, huan nojquiya catli atemoj ipan inintlacayo ihuaya nochi catli amo tlapajpacme pampa quiitzquijque se mijcatzi. Huan xiquintojtoca huejca tlen amoaltepe tlen yoyoncalme. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Xiquinquixtica tlacame huan nojquiya sihuame catli mopantíaj ica ni cocolistli, huan ma yaca itztotij huejca tlen amochajchaj para amo quichihuase amo tlapajpactli campa amoyoyoncalhua pampa nopona tlatlajco amojuanti, nimocahua na catli nitlatzejtzeloltic.” ");
INSERT INTO nhwBl_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Huajca nopa israelitame quineltocaque nochi catli TOTECO quinahuatijtoya Moisés huan quinquixtijque nochi catli quen nopa mococohuayayaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Huan TOTECO quinojnotzqui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Xiquinilhui nochi israelitame para quema se tlacatl o se sihuatl quiixpano seyoc masehuali, na niquijtohua para quihuica tlajtlacoli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Huan monequi nopa tlacatl o nopa sihuatl nechnelilhuis noixpa catli quichijtoc huan teipa yas quitlaxtlahuis ne se catli quichihuilijtoc fiero. Huan quicuepilis nochi catli quinenpolojtoc huan nojquiya quimiyaquilis 20 por ciento más huan amo quen quicuitoya. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Huan sintla nopa tlacatl catli quitlachtequilijtoya o tlen hueli quichihuilijtoya ya mictoc huan amo aqui niyon se iteiximatca para quicuepilis, huajca nopa tomi catli quitlahuiquilía elis para Toteco huan para quitequihuis se totajtzi. Huan nojquiya monequi quimacas nopa totajtzi nopa oquich borrego catli monequi. Huan nopa totajtzi nechtencahuilis para nechixtzacuilis nopa tlajtlacoli catli quichijtoc nopa tlacatl. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“Nochi nemactli catli israelitame nechhualiquilíaj na, niamoTECO, elis iaxca nopa totajtzi. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Nochi tlamantli tlacualistli huan tlapalehuili tlen ininmil catli quimacase TOTECO, mocahuas iaxca nopa totajtzi.” ");
INSERT INTO nhwBl_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Huan TOTECO quinojnotzqui Moisés huan quiilhui ma quinmaca israelitame ni tlanahuatilme: ");
INSERT INTO nhwBl_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Sintla isihua se tlacatl quiixpanos ihuehue huan mocahuas ica seyoc tlacatl, ");
INSERT INTO nhwBl_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","pero amo aqui quiitas para huelis quitelhuis ica itlajtlacol, ya ni catli quichihuas. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Sintla ihuehue, quena, quitlasomati isihua huan moilhuía para tlajtlacolchijtoc, o huelis ihuehue quitlasomati isihua huan amo tleno quichijtoc, quen ni anquisencahuase. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Nopa tlacatl monequi quihuicas isihua iixpa totajtzi ica se tlacajcahualistli tlen ome kilos harina tlen cebada, huan nechtencahuilis para na, niamoTECO. Pero amo quimanelos nopa harina ica aceite, niyon amo quitequilis nopa copali tlaajhuiyacayotl, pampa ya nopa elis se tlacajcahualistli para quimatis catli temachtli sintla moilhuía huelis tlajtlacolchijtoc isihua. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Huan nopa totajtzi quihualicas nopa sihuatl para ma monechcahui huan moquetzas noixpa, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Huan nopa totajtzi quicuis se achi atl catli tlaiyocatlalili para na huan quitlalis ipan se xarro tlen soquitl, huan quimanelos ica se achi tlaltejpoctli tlen tlalchi tlen nopa yoyon tiopamitl campa nimocahua. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Huan teipa nopa totajtzi quichihuas para nopa sihuatl ma moquetza noixpa, niamoTECO, huan quitojtomas itzoncal. Huan nopa totajtzi quitlalis imaco nopa sihuatl ne tlacajcahualistli tlen harina pampa ihuehue moilhuía tlajtlacolchijtoc. Huan nopa totajtzi moquetzas iixpa nopa sihuatl huan quipixtos imaco nopa xarro ica nopa atl catli chichic huan catli quimaca se tlatelchihuali, o se tlatzacuiltilistli catli tlajtlacolchijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Huajca nopa totajtzi quichihuas para nopa sihuatl ma nechtestigojquetzas, niamoTECO, sintla amo tlajtlacolchijtoc. Huan teipa nopa totajtzi quiilhuis: ‘Sintla amo timocajtoc ica seyoc tlacatl quema ya tijpixqui mohuehue, niyon amo tleno catli amo cuali tijchijtoc ica seyoc tlacatl, huajca amo tleno ma mitzpanti quema tiquijis ni atl catli chichic catli quihualica tlatelchihualistli ipan catli tlajtlacolchijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Pero sintla timochijtoc amo titlapajpactli huan titlaixpanotoc quema ya tijpixqui mohuehue huan timocajtoc ica seyoc tlacatl, ");
INSERT INTO nhwBl_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","huajca TOTECO ma mitztelchihuas huan ma mitztlatzacuiltis para nochi ma quiitaca. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Huan quema tiquijis ni atl catli chichic, quichihuas ma palanis mometztomahuiya huan ma samahuiya moijti huan amo huelis tiquinpiyas coneme.’ Huan nopa sihuatl quiijtos: ‘Quej nopa ma eli.’ ");
INSERT INTO nhwBl_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“Huajca nopa totajtzi quiijcuilos ni tlatelchihualistli ipan se cuetlax amatl ica tinta huan teipa quiixpolos nopa tinta huan nopa camanali ica nopa atl catli chichic. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Teipa quichihuas para nopa sihuatl ma quiiji nopa atl catli temaca se tlatelchihualistli ipan catli tlajtlacolchijtoc. Huan nopa atl calaquis iijtico huan quichihuas chichic iijtic sintla quipiya tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Huan teipa nopa totajtzi quiselis tlen imaco nopa sihuatl nopa tlacajcahualistli tlen harina, huan quihuisos iixpa TOTECO huan quihuicas campa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Huan quicuis se tlamojtzoli tlen nopa tlacajcahualistli tlen cebada huan quitlatis ipan nopa tlaixpamitl quen eliyaya nochi nopa tlacajcahualistli. “Huan teipa quema nopa totajtzi quichijtos nochi ni tlamantli, quimacas nopa atl ma quiiji. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Huan sintla mochijtoc amo tlapajpactli huan quiixpanotoc ihuehue, nopa atl catli quihualica tlatelchihualistli calaquis iijtico huan quichihuas para isihuayo ma temi huan imetztomahuiya ma palani. Huan nochi imasehualhua quiitase nopa sihuatl para tlatelchihuali. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Pero sintla nopa sihuatl amo quipiya tlajtlacoli, amo tleno oncas huan cuali huelis conepiyas. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Huajca ya ni eli nopa tlanahuatili quema se quitlasomati isihua pampa mochijtoc amo tlapajpactli huan quiixpanotoc ihuehue quema ya monamictijtoya ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","O ya ni nojquiya para quema se tlacatl moilhuía para quiixpanotoc huan quitlasomati, huan quinequi quimatis catli temachtli. Ihuehue quiixpantis isihua noixpa, niamoTECO, huan nopa totajtzi quichihuilis senquistoc quen quiijtohua ni tlanahuatili. ");
INSERT INTO nhwBl_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Huan amo elis itlajtlacol ihuehue sintla quiajsis ni tlatelchihualistli, pampa eli ya itlajtlacol. Huan monequi quiijiyohuis nochi tlatzacuiltilistli.” ");
INSERT INTO nhwBl_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Huan sempa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Xiquinilhui nochi israelitame para quema se sihuatl o se tlacatl catli quinequi noca mocahuas, na niamoTECO, para elis se nazareo huan moiyocatlalis para senquistoc elis noaxca, huan amo quen sequinoc sihuame o tlacame, ");
INSERT INTO nhwBl_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","huajca nopa masehuali amo hueli quiijis xocomeca atl o niyon se tlaili nelcococ. Niyon amo hueli quiijis catli quixocoltijtoque, niyon vinagre catli quichijtoque ica xocomeca atl, o catli cococ. Nojquiya amo huelis quicuas xocomecatl itlajca, niyon itlajca catli ya huactoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ipan nochi nopa tonali quema noca mocajtoc para moiyocacahuas quen se nazareo, amo tleno quicuas catli huala ipan xocomecatl itlajca, niyon ixinajcho, niyon ipetlayo. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Ipan nochi nopa tonali quema moiyocacajtoc para na, amo hueli moximas. Yaya elis tlatzejtzeloltic huan tlaiyocatlalili para na, niamoTECO, huan quicahuas ma moscalti huehueyac itzoncal hasta ma quitlamiltis nochi nopa tonali huan nopa tlamantli catli nechilhuijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Huan ipan nochi nopa tonali quema moiyocatlalijtoc para na, amo hueli monechcahuis campa se mijcatzi, pampa mochihuas amo tlapajpactli noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Masque miquis itata, inana, o se isihuaicni, o se itlacaicni, ma amo monechcahuis para mochihuas amo tlapajpactli pampa moiyocatlali para na, niamoTeco Dios, huan quipiyas itzoncal huehueyac catli quiixnextía catli noca mocajtoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Huan nochi tonali catli huejcahuas catli noca mocajtoc, monequi mocahuas tlatzejtzeloltic noixpa. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“Huan sintla nimantzi san huetzis mictoc se acajya catli moquetza ihuaya, huajca, quena, quichihuilis amo tlapajpactli noixpa, masque amo quinequiyaya mochihuas amo tlapajpactli. Huajca quema ajsis chicome tonali para mochijtoc amo tlapajpactli, quipiya para quitequis nochi itzoncal pampa itzoncal huehueyac quinextiyaya para tlaiyocatlali para na. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Huan ipan ne chicueyi tonali, quinhualicas ome pilpichontzitzi, o ome pilpalomajtzitzi, huan quimacas nopa totajtzi campa ipuerta nopa yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Huan nopa totajtzi nechtencahuilis nopa piltototzi quen se tlacajcahualistli por tlajtlacoli, huan ne seyoc nechtencahuilis quen se tlacajcahualistli tlatlatili. Huan ica ya ni nechixtzacuilis itlajtlacol pampa itztoya nechca se mijcatzi. Huan nojquiya ipan nopa tonal sempa moiyocatlalis noca na, niamoTECO, huan sempa pehuas quicahuas ma moscalti itzoncal. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Nopa tonali catli ya panotoc quema achtihui moiyocatlalijtoya noca na, quiixpolo. Sempa monequi motemacas noca na para elis nazareo nochi tonali quen quichijqui achtihui. Huan monequi quihualicas se piloquich borregojtzi catli san quipiya se xihuitl para nechtencahuilis quen se tlacajcahualistli pampa quihuica tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Huan quema ya tlamis nochi nopa tonali catli motemacac para elis nazareo, ya ni nopa tlanahuatili catli sesen monequi quitoquilis. Monequi hualas huan nechhualiquilis se tlacajcahualistli campa ipuerta nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Nechtencahuilis se piloquich borregojtzi catli san quipiya se xihuitl huan catli amo tleno quipiya huan elis se tlacajcahualistli tlatlatili. Huan nojquiya nechmacas se pilsihua borregojtzi catli san quipiya se xihuitl huan amo tleno quipiya huan nopa elis se tlacajcahualistli por tlajtlacoli. Nojquiya nechtencahuilis se oquich borrego catli amo tleno quipiya huan elis para se tlacajcahualistli para nimoyoltlalis ihuaya. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Nojquiya ihuaya, techmacaca nopa tlacajcahualistli tlen harina huan catli tlatoyahuali catli monequi nechmacase ihuaya. Huan monequi nopa tlacajcahualistli tlen harina elis se chiquihuitl temitoc ica pantzi catli amo quipiya tlasonejcayotl. Quipiyas tortas catli quichijtoque ica cuali harina maneltic ica aceite, huan nojquiya quipiyas pantzi catli cacatztic catli quixacualojtoque ica aceite. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“Huan nopa totajtzi quitencahuas nochi ya ni noixpa ihuaya nopa tlacajcahualistli por tlajtlacoli huan nopa tlacajcahualistli tlatlatili catli ne nazareo quihualicac. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Huan nechmacas nopa oquich borrego huan nopa chiquihuitl ica pantzi catli amo quipiya tlasonejcayotl, huan elis se tlacajcahualistli para tlayoltlalili nohuaya. Huan nopa totajtzi nojquiya nechmacas nopa tlacajcahualistli tlen harina huan catli tlatoyahuali catli ihuaya yohui. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Huan nopona campa ipuerta nopa yoyon tiopamitl campa timopantíaj, nopa nazareo monequi quiximas nochi itzoncal catli quinextiyaya catli noca mocajtoya, huan quicuis nochi nopa tzoncali huan quitlalis ipan nopa tlitl catli eltoc itzala nopa tlacajcahualistli para tlayoltlalili nohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“Huan teipa quema cuali motzoncaltectos ne nazareo, nopa totajtzi quicuis iajcol nopa oquich borrego catli molontoya hasta cuali icsitoc, huan quitlalis imaco ne nazareo ihuaya se pantzi ica tlatzopelcayotl huan se pantzi catli cacatztic catli eltoc ipan nopa chiquihuitl huan catli amo quipiya tlasonejcayotl. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Huan teipa nopa totajtzi quicuis huan quihuisos nopa tlacajcahualistli noixpa, niamoTECO, para ma eli se tlacajcahualistli tlahuisoli. Huan nochi nopa tlacajcahualistli mochihuas tlatzejtzeloltic huan elis iaxca nopa totajtzi, ica nopa pantzi ihuaya ielchiqui huan iajcol nacayo nopa borrego catli tlahuisoli. Huan teipa quema nopa totajtzi tlamis nechtencahuilía nochi noixpa, ya catli eliyaya nazareo huelis quiijis xocomeca atl pampa ya tlanqui catli noca mocajqui, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“Huajca ya ni elqui nopa tlanahuatili para se nazareo, huan anmechilhuía tlaque tlacajcahualistli monequi antechtencahuilise quema se quitlamichihuas catli noca mocajtoc para quichihuas. Nojquiya monequi quihualicas nochi sequinoc tlacajcahualistli catli nechilhui nechmactilis quema moiyocatlali huan mochijqui nazareo.” ");
INSERT INTO nhwBl_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Teipa TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Xiquilhui Aarón ininhuaya iconehua para ma quintiochihuaca israelitame ica ni camanali. Ma quiijtoca: ");
INSERT INTO nhwBl_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘Ma TOTECO mitztiochihua huan ma mitzmocuitlahui. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ma cahuani ixayac TOTECO ica paquilistli quema moilhuía tlen ta. Ma quipiya hueyi iyolo mohuaya. ");
INSERT INTO nhwBl_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ma TOTECO mitznextili itlaicnelijcayo huan ma mitzmaca itlasehuilis ipan moyolo.’ ");
INSERT INTO nhwBl_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ica ni camanali, Aarón huan iconehua nechnotzase ma niquintiochihua israelitame huan, quena, na niquintiochihuas para nochi quimatise inijuanti noaxcahua.” ");
INSERT INTO nhwBl_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Huan ipan nopa tonali quema Moisés quitlamisencajtoya nopa yoyon tiopamitl campa TOTECO mocahuasquía ininhuaya, quiatzejtzelhui ica aceite sesen tlamantli catli mocajqui calijtic, huan quiiyocatlali para TOTECO. Nojquiya quiatzejtzelhui ica aceite nopa tlaixpamitl huan nochi catli motequihuía nopona. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Teipa yajque nopa tlayacanca israelitame ipan sesen hueyi familia catli tlapalehuijtoyaj para quitlananque nopa censo. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Huan quitlalitoj iixpa TOTECO nochi catli quinequiyayaj quimactilise. Huan sesen nopa tlayacanani quihualicac se hueyi toro. Huan sese ome tlayacanani quihualicaque se cuacarro. Huajca ica nochi nopa nemactli catli quihualicaque elqui chicuase cuacarros catli tzactoque, huan 12 huejhueyi torojme catli quimatij tlatilanase huan quimacaque TOTECO iteno ipuerta nopa yoyon tiopamitl campa mocahua TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Huan TOTECO quiilhui Moisés: ");
INSERT INTO nhwBl_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Xiquinselili nopa cuacarros huan nopa huejhueyi torojme catli quimatij tlatilanaj, huan xiquinmaca nopa levitame para ma quintequihuica ipan nochi nopa tequitl catli monequi para quihuicase catli eltoc ipan nopa yoyon tiopamitl campa timopantíaj. Xijmaca sesen levita nopa tlamantzitzi catli monequi quitequihuis ipan itequi catli quitocarohua quichihuas.” ");
INSERT INTO nhwBl_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Huajca Moisés quinseli nopa cuacarros huan nopa huejhueyi torojme huan quinmajmacac nopa levitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Iixhuihua Gersón quinmacac ome cuacarros huan nahui huejhueyi torojme para quitequihuise ipan inintequi. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Huan iixhuihua Merari quinmacac nahui cuacarros huan chicueyi huejhueyi torojme para quitequihuise ipan inintequi ica imaco Itamar, icone nopa totajtzi Aarón. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Pero iixhuihua Coat amo quinmacac niyon se cuacarro huan niyon se toro, pampa monejqui quihuicase iniajcolpa nopa tlamantli tlatzejtzeloltique catli mocajqui ininmaco para quimocuitlahuise. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Huan nojquiya quema ajsic tonal para quiiyocatlalise nopa tlaixpamitl para TOTECO huan quitlatzejtzelolchihuase, sesen nopa tlayacanani tlen nochi huejhueyi familias quihuicaque se nemactli huan quitlalijque iixpa nopa tlaixpamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Huan TOTECO quiilhui Moisés: “Mojmostla ipan sesen tonal quema anquitlatzejtzelolchihuaj nopa tlaixpamitl, xijcahua san se tlayacanquetl ma nechtemactili catli quihualicac.” ");
INSERT INTO nhwBl_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Huajca ipan nopa achtihui tonali, quitemactili inemac Naasón, icone Aminadab, ipan nopa hueyi familia Judá. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Huan inemac eliyaya se hueyi plato ixpelentic tlen plata huan ietica eliyaya se kilo huan tlajco, ihuaya se hueyi taza tlen plata ica ietica quen tlajco kilo ipan itlatamachihual nopa yoyon tiopamitl. Huan nopa plato huan nopa hueyi taza quihualicac temitoc ica harina catli achi más cuali maneltic ica aceite para se tlacajcahualistli tlen harina. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Nojquiya quihualicac se cuchara catli senquistoc oro ica 110 gramos ietica, huan temitoya ica copali. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Huan quihualicac se becerro, se oquich borrego huan se piloquich borregojtzi catli san quipiya se xihuitl para elise se tlacajcahualistli tlatlatili. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Nojquiya quihualicac se oquich chivo para se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Huan para se tlacajcahualistli para ma onca tlayoltlalili ihuaya TOTECO, quinhualicac ome huejhueyi torojme catli quimatij tlatilanaj, macuili oquich borregojme, macuili oquich chivojme huan macuili piloquich borregojtzitzi catli san quipiyaj se xihuitl. Nochi ya ni elqui nopa nemactli catli Naasón, icone Aminadab, quihualicac. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Ipan ome tonali quihuicac inemac Natanael, icone Zuar, catli eliyaya tlayacanquetl ipan nopa hueyi familia Isacar. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","23","Huan inemac catli quitemactili elqui senquistoc san se quen catli temacac Naasón. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Ipan eyi tonali quihuicac se nemactli Eliab, icone Helón, catli eliyaya tlayacanquetl ipan nopa hueyi familia Zabulón. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","29","Huan quitemactili inemac catli elqui senquistoc san se quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Ipan nahui tonali quihuicac se nemactli Elisur, icone Sedeur, catli eliyaya tlayacanquetl ipan nopa hueyi familia Rubén. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","35","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ipan macuili tonali quihuicac se nemactli Selumiel, icone Zurisadai, catli eliyaya tlayacanquetl ipan nopa hueyi familia Simeón. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","41","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ipan chicuasen tonali quihuicac se nemactli Eliasaf, icone Reuel, catli eliyaya tlayacanquetl ipan nopa hueyi familia Gad. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","47","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Ipan chicome tonali quihuicac se nemactli Elisama, icone Amiud, catli eliyaya tlayacanquetl ipan nopa hueyi familia Efraín. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","53","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Ipan chicueyi tonali quihuicac se nemactli Gamaliel, icone Pedasur, catli eliyaya tlayacanquetl ipan nopa hueyi familia Manasés. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","59","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Ipan chicnahui tonali quihuicac se nemactli Abidán, icone Gedeoni, catli eliyaya tlayacanquetl ipan nopa hueyi familia Benjamín. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","65","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Ipan majtlactli tonali quihuicac se nemactli Ahiezer, icone Amisadai, catli eliyaya tlayacanquetl ipan nopa hueyi familia Dan. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","71","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Ipan majtlactli huan se tonali quihuicac se nemactli Pagiel, icone Ocrán, catli eliyaya tlayacanquetl ipan nopa hueyi familia Aser. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","77","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Ipan majtlactli huan ome tonali quihuicac se nemactli Ahira, icone Enán, catli eliyaya tlayacanquetl ipan nopa hueyi familia Neftalí. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","83","Huan quitemactili nojquiya san se inemac quen ne sequinoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Nochi ya ni elqui nopa nemactli catli nopa tlayacanani tlen israelitame quitemactilijque para quiiyocatlalise nopa tlaixpamitl para TOTECO huan quitlatzejtzelolchihuase. Ica nochi elqui 12 huejhueyi platos catli ixpelentique tlen plata, 12 huajcali tlen plata, huan 12 huejhueyi cucharas tlen oro. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Huan sesen plato quipixqui se kilo huan tlajco ietica, huan sesen huajcali tlen plata quipixqui tlajco kilo ietica. Ica nochi nopa tlamantli tlen plata quipixqui nechca 26 kilos ietica ipan itlatamachihual nopa yoyon tiopamitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Nojquiya oncayaya 12 cucharas tlen oro temitoya ica copali catli quipixqui 110 gramos ietica ipan itlatamachihual nopa yoyon tiopamitl. Nopa oro tlen nochi nopa cucharas quipixqui se kilo huan 320 gramos ietica. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Huan nopa tlapiyalme para tlacajcahualistli tlatlatili elque ica nochi 12 becerros, 12 oquich borregojme, 12 piloquich borregojtzitzi catli san quipiyaj se xihuitl ihuaya nopa 12 tlacajcahualistli tlen harina catli monequiyaya ininhuaya, huan 12 oquich chivojme para quinmacase quen tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Huan nochi nopa tlapiyalme catli quihualicaque para tlacajcahualistli para tlayoltlalili elqui ica nochi 24 becerros, 60 oquich borregojme, 60 oquich chivojme huan 60 piloquich borregojtzitzi catli san quipixque se xihuitl. Nochi ya ni elqui catli quimactilijque TOTECO quema quiiyocacahuayayaj huan quitlatzejtzelolchihuayayaj nopa tlaixpamitl para TOTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Huan quema Moisés calajqui ipan nopa yoyon tiopamitl campa mopantiyaya ihuaya Toteco Dios para quicamanalhuis, quicajqui itoscac. Huan caquistic itoscac quisayaya tlen tlatlajco nopa ome tequihuajme catli inintoca querubines catli moquetztoyaj iixco itzajca icaxa. Huajca nopona Toteco Dios quicamanalhui Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Xiquilhui Aarón quema quintlalis nochi tlahuilme, ma quichihua para ma tlahui ica iixmelac tlen nopa tlahuil quetzali.” ");
INSERT INTO nhwBl_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Huan quichijqui Aarón nochi catli TOTECO quinahuatijtoya Moisés, huan quinsencajqui nochi tlahuilme para ma tlahui ica iixmelac. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Huan nopa tlahuil quetzali quichijchijtoyaj ica senquistoc oro catli quitejtejtzontoyaj san ica martillo. Iicxi hasta iyecapa campa quichihuilijtoyaj ixochiyo, nochi quichijque san ica martillo. Nochi iyejyejca nopa tlahuil quetzali elqui senquistoc quen TOTECO quinextilijtoya Moisés ma quichihua. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Huan TOTECO quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Xiquinquixti nochi iteipan ixhuihua Leví tlen ne sequinoc israelitame huan xiquintlapajpacchihua noixpa para nechtequipanose. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ya ni catli tijchihuas: xiquinatzejtzelhuis ica atl catli tetlapajpacchihua noixpa. Teipa moximase huan mohuatanise hasta moquixtilise nochi tzoncali ipan inintlacayo. Teipa maltise, huan cuali quichicuenise ininyoyo, huan quej nopa elise tlapajpacme para nechtequipanose. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Teipa ma quihualicaca se becerro huan nopa tlacajcahualistli tlen harina catli ihuaya yohui. Ya nopa elis cuali harina maneltic ica aceite. Huan nojquiya quihuicase seyoc becerro para se tlacajcahualistli por tlajtlacoli. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ta tijchihuas para nopa levitame ma monechcahuica ipuertajteno ni yoyon tiopamitl campa timopantíaj huan nochi israelitame nojquiya nopona ma mosentilica. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Teipa xijchihua para nopa levitame ma moixnextica noixpa huan nopa sequinoc israelitame ma quintlalilica ininmax ipan inintzonteco. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Huan Aarón quihuisos imax noixpa, niamoTECO, quen nechmaca se tlacajcahualistli tlahuisoli, huan quej nopa nechtemactilis nochi levitame quen se hueyi tlacajcahualistli catli nochi israelitame nechmacaj na, niamoTECO. Huan ica ya nopa quiniyocatlalis nochi levitame para nechtequipanose. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Teipa nochi levitame quitlalise ininmax ipan inintzonteco nopa becerros. Teipa nechtencahuilise se becerro quen se tlacajcahualistli por tlajtlacoli huan seyoc becerro nechmactilise quen se tlacajcahualistli tlatlatili para na, niamoTECO, para nechixtzacuilise inintlajtlacolhua nochi levitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Huan teipa xiquintlali nochi nopa levitame para ma moquetzaca iniixpa Aarón huan itelpocahua, huan nochi techmacas quen se tlacajcahualistli tlahuisoli para na, niamoTECO. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Huan quej ni tiquiniyocatlalis nopa levitame tlen nochi sequinoc israelitame, huan nochi levitame elise noaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Huan quema ya anquintlapajpacchijtoque nopa levitame huan anquinnextijtoque noixpa quen se tlacajcahualistli tlahuisoli, inijuanti hueli calaquise para nechtequipanose ipan ni yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","“Pampa nochi levitame senquistoc noaxcahua huan amo quen sequinoc israelitame, pampa nimocuili nochi levitame ininpatlaca nochi ininconehua israelitame catli achtihui ehuani catli monequiyaya nechmactilisquíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Pampa nelía noaxcahua nochi catli achtihui tlacatij tlen israelitame, masque ininconehua o inintlapiyalhua, nochi catli achtihui tlacatij noaxcahua. Pampa huejcajya quema niquinmijmicti nochi coneme catli achtihui ejque ipan tlali Egipto, niquiniyocatlali para noaxcahua nochi coneme catli achtihui ehuani tlen israelitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Pero ama quen ininpatlaca nopa achtihui ehuani tlen nochi israelita coneme, nimoaxcatijtoc nochi levitame para noaxcahua. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Huan ama niquinmaca nochi levitame tlen nochi sequinoc israelitame para ma elica se nemactli para Aarón huan itelpocahua para quinpalehuise quichihuase nopa tequitl tlatzejtzeloltic ipan ni yoyon tiopamitl campa timopantíaj. Huan nopa levitame tequitise ininpatlaca sequinoc israelitame. Huan nechtencahuilise inintlacajcahualis nopa sequinoc israelitame para quiixtzacuase inintlajtlacolhua noixpa na, niamoTECO. Huan quej ni, catli hueli israelita amo calaquis ipan ni yoyon tiopamitl para tlapalehuis para amo quinajsis israelitame se hueyi cocolistli catli ica miquise.” ");
INSERT INTO nhwBl_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Huajca Moisés, Aarón huan nochi israelitame quichijque ica nopa levitame nochi catli TOTECO quinahuatijtoya Moisés ma quichihuaca. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Huan nochi levitame motlapajpacchijque huan quichicuenijque ininyoyo, huan Aarón quinpannexti iixpa TOTECO quen se tlacajcahualistli tlahuisoli. Huan Aarón nojquiya quitencajqui iixpa se tlacajcahualistli para quinixtzacuilis inintlajtlacolhua para ma elica tlapajpacme iixpa. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Huajca quema tlanqui nochi ni tlamantli catli mochijqui, nopa levitame pejque calaquij para quichihuase nochi inintequi ipan nopa yoyon tiopamitl campa timopantíaj ihuaya TOTECO, huan tequitique inintempa Aarón huan itelpocahua. Huan nochi quichijque senquistoc quen TOTECO quinahuatijtoya Moisés ma quinchihuili nopa levitame. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","TOTECO nojquiya quicamanalhui Moisés huan quiilhui: ");
INSERT INTO nhwBl_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Nochi levitame quema quiaxitijtose 25 xihuitl, monequi quipehualtise para nechtequipanose ipan ni yoyon tiopamitl campa timopantíaj. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Huan quisase ipan nopa tequitl quema quiaxitise 50 xihuitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Teipa quema ya quiaxitijtose nopa xihuitl para mosiyajquetzase, huelis quinpalehuise ininhuampoyohua ica tequitl catli amo ohui, pero nopa tequitl catli ohui ayacmo ma quichihuaca. Quej nopa anquintequimacase levitame.” ");
INSERT INTO nhwBl_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Quema TOTECO quicamanalhui Moisés huan quiilhui nochi ni camanali ya tlantoya se xihuitl para quistejque tlen tlali Egipto huan calaquiyaya ipan nopa achtihui metztli ipan xihuitl ome. Huan ipan nopa tonali nopa israelitame itztoyaj ipan nopa huactoc tlali Sinaí huan nojquiya TOTECO quiilhui ni camanali: ");
INSERT INTO nhwBl_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Sesen xihuitl monequi nochi israelitame quinextise nopa ilhuitl catli itoca Pascua ipan nopa tonal catli nimechnahuatijtoc. ");
INSERT INTO nhwBl_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Quema ya tiotlaquixtos ipan 14 itequi ni metztli catli achtihui ipan toxihui, anquitoquilise nopa tlanahuatili quen ijcuilijtoc. Senquistoc quen nimechnextilijtoc para anquichihuase, ya nopa anquichihuase.” ");
INSERT INTO nhwBl_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Huajca Moisés quinnahuati nopa israelitame ma quinextica nopa Pascua Ilhuitl. ");
INSERT INTO nhwBl_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Huan nopona ipan nopa huactoc tlali catli itoca Sinaí quema tiotlaquixtoya ipan 14 itequi nopa achtihui metztli ipan nopa xihuitl, inijuanti ilhuichijque senquistoc quen TOTECO quinahuatijtoya Moisés. ");
INSERT INTO nhwBl_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Pero itztoyaj sequin tlacame catli mochijtoyaj amo tlapajpacme iixpa TOTECO pampa quiitzquijtoyaj se mijcatzi, huan yeca amo huelque quichihuase nopa Pascua Ilhuitl ipan nopa tonali. Huajca yajque quiitatoj Moisés ihuaya Aarón ipan nopa tonali, ");
INSERT INTO nhwBl_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","huan quinilhuijque: ―Masque tiquitzquitoque se mijcatzi, huan timochijtoque amo titlapajp