﻿USE sofia;
DROP TABLE IF EXISTS sofia.nhr_vpl;
CREATE TABLE nhr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nhr_vpl WRITE;
INSERT INTO nhr_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Tcgãyas Jeso Krestem dis qhàòs di sa, Dafitem ka tsgõose-coa ba, Abrahamam ka tsgõose-coa ba. ");
INSERT INTO nhr_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahama ba kò Isakam ka xõò me e, me Isaka ba Jakobem ka xõò me e, me Jakobe ba Jutam ka xõò me e, káíkhoe ga xu hẽé naka qõese ga xu hẽéthẽé di ba. ");
INSERT INTO nhr_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Me kò Juta ba Perese ba hẽé naka Sera ba hẽéthẽé tsara ka xõò me e (gatsara ka xõò sa kò Tamara si i). Me Perese ba Heseronem ka xõò me e, me Heserone ba Ramem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","me Rame ba Aminadabem ka xõò me e, me Aminadabe ba Nasonem ka xõò me e, me Nasone ba Salemonem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","me kò Salemone ba Boasem ka xõò me e (gam ka xõò sa kò Rahabe si i), me kò Boase ba Obetem ka xõò me e (gam ka xõò sa kò Rute si i), me Obete ba Jesem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","me Jese ba x'aigam Dafitem ka xõò me e. Dafite ba kò Solomonem ka xõò me e (xõò sa kò Uriam ka kò séèèas khóè si i). ");
INSERT INTO nhr_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Me kò Solomone ba Rehoboamem ka xõò me e, Me Rehoboame ba Abiam ka xõò me e, me Abia ba Asam ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","me Asa ba Jehosafatem ka xõò me e, me Jehosafate ba Joramem ka xõò me e, me Jorame ba Usiam ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","me Usia ba Jotamem ka xõò me e, me Jotame ba Ahasem ka xõò me e, me Ahase ba Hesekiam ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","me Hesekia ba Manasem ka xõò me e, me Manase ba Amosem ka xõò me e, me Amose ba Josiam ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","me kò Josia, Jekonia ba hẽé naka qõese ga xu hẽéthẽé ka xõò me e, ncẽe khóè ne kò tcg'òóè a ko Babilone koe úúè ka. ");
INSERT INTO nhr_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Eẽs séèa tcg'òóku a Babilone koe chùia úúkus qãá q'oo koem kò Jekonia ba Salatiele ba ábà, me Salatiele ba Serobabelem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","me Serobabele ba Abiutem ka xõò me e, me Abiute ba Eliakimem ka xõò me e, me Eliakime ba Asorem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","me Asore ba Satokem ka xõò me e, me Satoke ba Akimem ka xõò me e, me Akime ba Eliutem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","me Eliute ba Eleasarem ka xõò me e, me Eleasare ba Matanem ka xõò me e, me Matane ba Jakobem ka xõò me e, ");
INSERT INTO nhr_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","me kò Jakobe ba Josefam ka xõò me e, ncẽe kò Marias dim khóè ba ii ba, ncẽe Jesom ka xõò kò ii sa, ncẽe ko Kreste ta ma tciiè ba. ");
INSERT INTO nhr_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nxãaska zi kò wèé zi qhàò zi Abrahamam koe guu a síí Dafitem koe tcãà zi 14 zi i, zi kò Dafitem koe guu a síí séèa tcg'òóku a Babilone koe chùia úúkus dim x'aèm koe tcãà ka zi 14 zi qhàò zi i, zi kò séèa tcg'òóku a Babilone koe úúkus dim x'aèm koe guu, a síí Krestem di x'aèan koe tcãà ka zi kò 14 zi qhàò zi i. ");
INSERT INTO nhr_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ncẽe zi gúù zi kò Jeso Krestem ko ábàè ka kúrúse. Gam ka xõòs Maria sa kò Josefam ka séèkuan tòóa mááèa hãa. Igaba ẽe khara qanega xg'ae ta ga hãa kas kò bóòè a Tcom-tcomsam Tc'ẽem ka ncãàn úúkaguèa. ");
INSERT INTO nhr_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gas dim khóèm Josefa ba kò tchànom khóè me e, a kò tc'ẽe tama nxàea tcg'òóan gaan di i, sau-cgaekagu sim gha khama, a ba a kò tcáóa ba q'oo koe bìrísea hãa, cg'uri-cg'uri si tamasem gha q'aa cgoa si sa. ");
INSERT INTO nhr_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Qanegam hãa a ko ncẽe zi gúù zi ka tc'ẽe-tc'ẽese kam ko moengelem X'aigam Nqarim di ba sõokuris q'oo koe qhúí cgae me, a bìrí me a máá: “Josefaè, Dafitem ka tsgõose-coaè, táá Maria sa séè bèe guu, nakas tsaris khóè sa kúrú. Eẽ gas ka qóḿmèa nea Tcom-tcomsam Tc'ẽem koe guua ke. ");
INSERT INTO nhr_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Si gha kg'áòm cóá ba ábà, tsi gha cg'õèa ba Jeso ta ma tcii, Gam di ne khóè nem gha gane di chìbian koe kgoara khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Wèéan ncẽea kò kúrúse, nxãasegas gha X'aigam Nqarim porofitim koe guu a kg'uia hãa sa tseegukaguè ka, ncẽe kò máá: ");
INSERT INTO nhr_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Dxàe-coas qanega xóé cgoaè tama sa gha ncãàn úú, a sa a gha kg'áòm Cóá ba ábà, Me gha Emanuele ta ma tciiè,” tam méé, ncẽe sa ko máá, ‘Nqari ba hãa cgoa taa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Me Josefa ba tc'oman koe tẽe, a ba a ẽem kò ma X'aigam dim moengele ba ma x'áè mea khama ma kúrú. A ba a síí Maria sa gam dis khóès iise séè. ");
INSERT INTO nhr_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Igabam kò táá xóé cgoa si, si nxãakg'aiga síí kg'áòm cóá ba ábà. Me cg'õèa ba Jeso ta ma tcii. ");
INSERT INTO nhr_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesom Betelehema koe ábàèa hãa, Jutea di i, x'aigam Herotem di x'aèan ka, ka xu kò tco̱nò q'ãa-kg'ao xu cáḿs ko tcg'oa xòè koe guu a Jerusalema koe hàà, ");
INSERT INTO nhr_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","a hàà tẽè a máá: “Gaam ẽe ábàèam x'aigam Juta ne di ba ndaa? Gaam dim tco̱nò ba xae ncãa cáḿs ko tcg'oa xòè za bóò, xae hààraa hãa, hàà xae gha dqo̱m̀ Me ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Eẽm ko x'aigam Herote ba ncẽes gúùs ka kóḿ kam kò tcg'áì-tcao, naka wèém x'áém Jerusalema di ba hẽéthẽé e, gam cgoa. ");
INSERT INTO nhr_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Me wèé xu kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu khóè ne di xu hẽéthẽé tciia xg'ae, a tẽè xu nda koe méém ga nqòòkaguèam Kreste ba ábàè sa. ");
INSERT INTO nhr_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xu bìrí me a máá: “Betelehema koe e, Jutea di i. Ncẽea porofitim kò ma góá hãa ga a khama: ");
INSERT INTO nhr_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Tsáá Betelehema tseè, Juta dim nqõóm koe hãa tsi, cg'áré tama tsia x'aiga xu Juta di xu koe. Tsáá koem gha tc'ãà-cookg'ai ba guu a tcg'oa khama, ncẽe gha Tiri ne khóè ne Iseraele di ne kòre ba,’ témé,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nxãaskam kò Herote ba tco̱nò q'ãa-kg'ao xu kàa ka tciia tcg'òó, a ba a qãèse tẽèa kg'ónò xu dùútsa x'aè kam tco̱nò ba bóòsea sa. ");
INSERT INTO nhr_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A ba a Betelehema koe tsééa úú xu a máá: “Qõò naka síí Cóám ka qãèse kóḿ, naka ẽe xao kòo hòò Me ne kg'uian tsééa máá te, nakar gha nxãasega tíí igaba síí dqo̱m̀ Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eẽ xu ko x'aiga ba kóḿa xg'ara ka xu kò xgoaba a qõò. Me gaa x'aè kaga tco̱nòm ẽe xu kò cáḿs ko tcg'oa xòè za bóòa ba tc'ãà-cookg'ai xu, a ba a nxãakg'aiga síí Cóám hãa qgáì tc'amkg'ai koe téé. ");
INSERT INTO nhr_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tco̱nò ba xu ko bóò ka xu kò kaisase qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nquum q'oo koe xu kò tcãà, a Cóá ba bóò xõòs Marias cgoa, a xu a qám̀se a dqo̱m̀ Me, a x'aian di cãan gaxu di xgobekg'am, a gautan di zi gúù zi hẽé, qãè hm̀m̀ xg'ãò tshãán hẽé naka tcgáùse di tshãán hẽéthẽé di zi aba zi tcg'òó a máà Me. ");
INSERT INTO nhr_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sõokuris q'oo koe xu ko q'ãakaguèa, táá méé xu Herotem koe ka̱bise sa khama xu kò tãám dàò ba séè a gaxu dim nqõóm koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Eẽ xu qõòa hãa kam kò moengelem X'aigam Nqarim di ba sõokuris q'oo koe Josefam koe x'áíse, a máá: “Tẽe, naka Cóá ba hẽé naka xõò sa hẽéthẽé séè, naka Egepeto koe ts'ãà naka qgóé! Gaa koe méé tsi hãa nakar nxãakg'aiga síí bìrí tsi kúrú tsi gha sa. Kúrúse i gha me gha Herote ba Cóá ba qaa, cg'õo Mem gha ka ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Me ẽem ntcùúm ka tẽe, a ba a Cóá ba hẽé naka xõò sa hẽéthẽé séè, a Egepeto koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Gaa koem kò hãa, me nxãakg'aiga síí Herote ba x'óó. Ncẽe sa kò kúrúse, nxãasegas gha X'aigam Nqarim porofitim koe guu a kg'uia hãa sa tseegukaguè ka, ncẽe ko máá: “Egepeto koer Cóám Tiri ba tciia tcg'òóa hãa,” témé ba. ");
INSERT INTO nhr_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eẽm ko Herote bóòa q'ãa, tco̱nò q'ãa-kg'ao xu kam qàe-qaeèa hãa sa, kam kò nxãaska kaisase xgóà, a ba a ncõo-kg'ao xu tsééa tcg'òó, síí xu gha wèé xu cóá xu ẽe cám̀ kuri xu, kana gaxu ka nqãaka hàna kurian úúa xu, Betelehema ba hẽé naka gam qàe koe hàna xu qgáì xu wèé xu koe hẽéthẽé hàna xu cg'õo ka. Ncẽe sam kò kúrú, tco̱nò q'ãa-kg'ao xu hàà bìrí mea hãas domka, ẽe xu kò bìrí meam x'aèm koe guu a. ");
INSERT INTO nhr_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ka i kò nxãaska porofitim Jeremiam ka kò kg'uièa sa tseegukaguè, ncẽe kò máá: ");
INSERT INTO nhr_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Dòm̀ ba kò Rama koe kóḿse, kg'ae sa hẽé naka thõò-tcaoase kg'ae sa hẽéthẽé di ba. Ragele sa ko gas di cóán kg'ae cgae, a kò qgài-qgai-tcáókuan xguì, kaàra i hãa khama,” témé ba. ");
INSERT INTO nhr_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herotem ko x'óó qãá q'oo koem kò moengelem X'aigam Nqarim di ba Josefam koe sõokuris q'oo koe x'áíse, Egepeto koe, ");
INSERT INTO nhr_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","a ba a máá: “Tẽe naka tsia Cóá ba hẽé naka xõò sa hẽéthẽé séè, naka tsia Iseraele dim nqõóm koe qõò, ẽe kò Cóám di kg'õèan qaa nea x'óóa hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Me tẽe, a Cóá ba hẽé naka xõò sa hẽéthẽé séè, a ba a Iseraele dim nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Igaba ẽem ko Josefa kóḿ Arekelose ba Jutea dim nqõó ba tc'ãà-cookg'aia sa, gam ka xõòm Herotem téé-q'oo koe, kam kò gaa koe síían bèe. Sõokuris koem ko q'ãakaguèa, khamam kò Galilea dim xòèm koe qõò, ");
INSERT INTO nhr_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","a síí Nasareta ta ko ma tciièm x'áé-dxoom koe x'ãè, ẽe porofiti xu ka kg'uièa hãas gha nxãasega tseegukaguè ka, ncẽe kò máá: “Nasareta dim khóè ba, tam gha ma tciiè,” témé sa. ");
INSERT INTO nhr_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eẽ xu cáḿ xu kam kò Johanem tcguù-tcguu-kg'ao ba hàà, a ba a hàà tchàa-xgóós Jutea dis q'oo koe Nqarim di zi kg'ui zi xgaa-xgaa a máá: ");
INSERT INTO nhr_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Tcóóse tu gatu di chìbian koe, nqarikg'ai di x'aia nea cúù u ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ncẽem Johane ba porofitim Isaiam kò gam ka kg'uia hãam ga me e, a ko máá: “C'ẽem dòm̀ ba ko tchàa-xgóós koe guu a q'au a ko máá: ‘X'aigam Nqari ba tu dàò ba kg'ónòa máá, naka Gam di dàòan tchàno-tchanoa máá Me,’” témé ba. ");
INSERT INTO nhr_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johane ba kò nqabè c'õò cgoa kúrúèa qgáían ha̱na, a khòo dim bàne ba kháóa ba koe qáéa. Gam di tc'õoa nea kò tcòm̀an hẽé naka qãáka di dènean hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ne kò khóè ne Jerusalema hẽé naka wèé Jutea hẽé naka wèém xg'aeku-coam Jorotane qàe dim koe hẽéthẽé guu a síí cgae me, ");
INSERT INTO nhr_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","a ne a gane di chìbian nxàe, a Jorotane dim tshàam koe tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Igaba ẽem ko káí xu Farasai xu hẽé naka Saduke xu hẽéthẽé bóò, xu tcguù-tcguukuan domka gam koe hààraa, kam kò bìrí xu a máá: “Gaxao cg'aoan di xao cóá xaoè! Dìín ka xaoa q'ãa-q'ãaèa hãa a ko hààko xgóàn Nqarim di bèe? ");
INSERT INTO nhr_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nxãaska méé xao chìbian koe xao tcóósea hãa sa gha x'áí tc'áróan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Táá méé xao bìríse naka máá, ‘Abrahama ba xae úúa, sixae ka tsgõose ba,’ témé guu. Bìrí xao or ko a ko máá: Nqari ba qarian úúa, ncẽe zi nxõ̱á zim gha séè a Abrahama ba tsgõo-coan kúrúa máá di i ke. ");
INSERT INTO nhr_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bòó sa nxãakamaga hìi zi di to̱bean kg'ónòa tòóa mááèa, si gha wèés hìis ẽe qãè tc'áróan kúrú tama sa xg'aoa tcg'òó, a c'eean q'oo koe xaoa tcãàè. ");
INSERT INTO nhr_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Tíí ra ko tshàan cgoa tcguù-tcguu tu u, chìbian koe tu gha tcóóse ka, igaba Gaam ẽe ko tíí qãá q'oo koe hàà ba tíí ka qari Me e, ncẽe Gam di zi nxàbo zi qgóóan gar tc'ãò tama ba. Gabá gha Tcom-tcomsam Tc'ẽem cgoa hẽé naka c'eem cgoa hẽéthẽé tcguù-tcguu tu u. ");
INSERT INTO nhr_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Mabere tsoroa nem ko dqòrò cgoam hìi ba tshàua ba koe hãa, Me gha maberea nem ko dqòròs qgáìs koe dqòròa xgãá a, a gha Gam di maberean Gam dis nxàés koe xg'ae-xg'ae, igabam gha ts'irì tamam c'eem koe tsoroan dàò,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Me kò Jeso ba Galilea koe guu, a Jorotane koe hàà, hààm gha Johanem ka tcguù-tcguuè ka. ");
INSERT INTO nhr_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Igabam kò Johane ba xgáè-kg'am Me, a máá: “Tsáá kar gha tcguù-tcguuè sa ko qaase, ka Tsi gáé ko Tsáá tíí koe hàà?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Me Jeso ba xo̱a me a máá: “Guu u ncẽeska, kg'anoa i máá tsama, ncẽeta tsam gha hẽé sa ke. Ncẽem dàòm ka tsam gha ko wèé zi gúù zi tchàno zi kúrú, Nqarim ka ko qaaè zi,” témé. Me dtcòm̀ Me. ");
INSERT INTO nhr_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eẽm kò Jeso ba tcguù-tcguuèa xg'ara kam kò kúúga tshàam koe tcg'oa, i kò gaa x'aè kaga nqarikg'aian xgobekg'amse, Me Nqarim dim Tc'ẽe ba bóò, Me tcíbís khama ii a ko Gam koe xõa. ");
INSERT INTO nhr_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Me gaa x'aè kaga dòm̀ ba nqarikg'ai koe guu a máá: “Ncẽe ba Tirim Cóám ncàm̀a Raa Me e, Gam kar ko kaisase qãè-tcao,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Me nxãaska Jeso ba Tc'ẽem ka séè a qãáka úúè, síím gha dxãwam ka kúrúa bóòè ka. ");
INSERT INTO nhr_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eẽm ko 40 cáḿan hẽé naka 40 ntcùúan hẽéthẽé tc'õoan carasea hãa kam kò gaa koe guus ka xàbàa. ");
INSERT INTO nhr_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Me kò kúrúa bóò-kg'ao ba hàà cgae Me, a bìrí Me a máá: “Nqarim di Tsi Cóá Tsi kò ii ne, ncẽe nxõ̱án bìrí naka i péréan kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Me Jeso ba xo̱a a máá: “Góásea i hãa a ko máá: ‘Khóè ba péréan ka cúí kg'õèkaguè tite, igaba wèém kg'uim ka a, ẽe ko Nqarim di kg'áḿan koe guu a tcg'oa ba,’ téméèa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kam ko nxãaska dxãwa ba tcom-tcomsam x'áé-dxoom Jerusalema dim koe úú Me, a ba a kaisase tc'amaka hàna qgáìan tempelem tco̱be dim koe síí tòó Me, ");
INSERT INTO nhr_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a bìrí Me a máá: “Nqarim di Tsi Cóá Tsi kò ii ne, nqãaka xaoa xòóse. Góásea i hãa ke a ko máá: ‘Gam di xu moengele xum gha Tsáá ka x'áèan máà, xu gha gaxu di tshàuan cgoa ghùi Tsi, táá Tsi gha nxãasega nqàrèa Tsi nxõ̱án koe xg'áḿa tòó ka,’” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Me Jeso ba bìrí me a máá: “Gaicara i góásea hãa a ko máá: ‘Táá méé tsi tsarim X'aigam Nqari ba kúrúa bóò guu,’” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Gaicaram kò dxãwa ba séè a kaisase kaiam xàbìm koe úú Me, a ba a wèé x'aian nqõómkg'ai di hẽé, naka gaan di ka̱rean hẽéthẽé x'áí Me. ");
INSERT INTO nhr_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A ba a bìrí Me a máá: “Wèéan ncẽe gar gha máà Tsi, góḿankg'ai koe Tsi kòo cg'áé a ko dqo̱m̀ te ne,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Me Jeso ba nxãaska bìrí me a máá: “Tíí koe tcg'oa, satanaè! Góásea i hãa a ko máá: ‘X'aigam Nqari ba tsi gha dqo̱m̀, a Gam cúí ba kúrúa máá,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Me nxãaska dxãwa ba guu Me. Ka i ko gaa x'aè kaga moengelean hàà, a hàà hùi Me. ");
INSERT INTO nhr_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Eẽm ko Jeso ba Johane ba qáéèa hãa sa kóḿ, kam kò Galilea koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasareta koem kò tcg'oa, a Kaperenaume koe síí x'ãè, ncẽe ko tshàam qàe koe hànam qgáì ba, Sebulone ba hẽé naka Nafetali ba hẽéthẽé tsara dim nqõóm koe, ");
INSERT INTO nhr_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ẽe porofitim Isaiam ka kò kg'uièas gha nxãasega tseegukaguè ka, ncẽe kòo máá: ");
INSERT INTO nhr_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sebulonem dim nqõó ba hẽé naka Nafetalim dim nqõó ba hẽéthẽé tsara tshàam koe ko qõòm dàòm koe hãa, Jorotanem qàe koe, Galilea koe, nqõóm tãá zi qhàò zi di ba; ");
INSERT INTO nhr_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","khóè ne ncẽe gaa koe ntcùúan q'oo koe x'ãèa hãa nea kaiam x'áà ba hòòa. X'ooan dim nqõóm ntcùúm q'oo koe hãa ne koe i x'áàn hààraa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Eẽm x'aèm koem kò Jeso ba guu a tshoa-tshoa a xgaa-xgaa a máá: “Tcóóse tu gatu di chìbian koe, nqarikg'ai di x'aia nea cúù u ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Eẽm Jeso ba Galilea dim tshàam qàe koe xóé a ko qõò kam kò khóè qõeku tsara bóò, Simonem ncẽe kòo Petere ta ma tciiè ba hẽé naka Anterea ba hẽéthẽé e, tsara c'uisí sa tshàan q'oo koe tcãà, x'aù qgóó-kg'ao tsara a kò ii khama. ");
INSERT INTO nhr_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","A ba a bìrí tsara a a máá: “Xùri Te tsao, kúrú tsao or gha tsao khóè ne qgóó-kg'ao tsao ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tsara kúúga gatsara di c'uisían guu, a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Gaa koem guu a ko qõò kam kò khóè qõeku tsara c'ẽe tsara bóò, Sebetem ka cóásem Jakobo ba hẽé naka qõesem Johane ba hẽéthẽé e, tsara gatsara ka xõòm Sebetem cgoa dxòrom q'oo koe hãa, xu ko gaxu di c'uisían kg'ónò, Me Jeso ba tcii tsara a. ");
INSERT INTO nhr_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ka tsara kò kúúga dxòro ba hẽé naka gatsara ka xõò ba hẽéthẽé guu, a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Me Jeso ba wèém Galileam koe qõòa te, a gane di còrè-nquuan koe xgaa-xgaa, a ko x'aian di qãè tchõàn ka khóè ne bìrí, a ko wèé tcììan koe hẽé naka wèé thõòan koe hẽéthẽé qãèkagu ne. ");
INSERT INTO nhr_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Gaam di tchõà ne kò wèém Siriam koe tsa̱i-tsa̱ise, ne kò Gaam koe wèé ne ẽe ko tãáka zi tcìì zi tsàa ne óá, naka thõòkase tsàara hãa ne hẽé naka dxãwa tc'ẽean ka tcãàèa ne hẽé, naka x'óóa qae ko ne hẽé naka nqo̱ara ne hẽéthẽé e, Me kúrú ne ne qãè. ");
INSERT INTO nhr_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Zi kò káí zi xg'ae zi Galilea koe hẽé naka Dekapolise koe hẽé naka Jerusalema koe hẽé naka Jutea koe hẽé naka c'ẽe xòè Jorotane di koe hẽéthẽé guu a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Eẽm ko Jeso ba xg'ae zi bóò kam kò xàbìm koe qaò, a síí gaa koe ntcõó, xu Gam di xu xgaa-xgaase-kg'ao xu hàà cgae Me. ");
INSERT INTO nhr_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Me tshoa-tshoa a xgaa-xgaa xu a máá: ");
INSERT INTO nhr_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Ts'ee-ts'eekg'aièa nea gane ẽe tc'ẽem koe dxàua hãa igaba Nqari ba dtcãasea hãa ne, nqarikg'ai di x'aia nea gane di i khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ts'ee-ts'eekg'aièa nea gane ẽe ko kg'ae ne, qgài-qgai tcáóè ne gha khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ts'ee-ts'eekg'aièa nea gane ẽe ko cg'áré-cg'arese ne, nqõó ba ne gha q'õò khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ts'ee-ts'eekg'aièa nea gane ẽe tchànoan xàbà máána hãa ne, a cáḿa máá ana ne, xg'ãàkaguè ne gha khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ts'ee-ts'eekg'aièa nea ẽe thõò-xama-máákuan úúa ne, Nqarim ka ne gha thõò-xama mááè khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ts'ee-ts'eekg'aièa nea gane ẽe q'ano-tcáó ne, Nqari ba ne gha bóò khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ts'ee-ts'eekg'aièa nea gane ẽe ko tòókuan kúrú ne, Nqarim di ne cóá ne ta ne gha ma tciiè khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ts'ee-ts'eekg'aièa nea gane ẽe ko tchànoan domka xgàraè ne, nqarikg'ai di x'aia nea gane di i khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ts'ee-ts'eekg'aièa tua, ncẽè khóèan kòo nco̱i tu u, a ko xgàra tu u ne, a ko Tíí domka wèé zi gúù zi cg'ãè zi tshúù-ntcõase gatu ka nxàe ne. ");
INSERT INTO nhr_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Qãè-tcao méé tu naka tua cgabà-cgaban-tcao, gatu di surutan nqarikg'ai dia kaia hãa ke, gatà iim dàòm kaga ne kò porofiti xu xgàra ncẽe kò gatu cookg'ai koe ga hàna xu khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gatua nqõómkg'ai di tu ta̱be tu u. Igaba i kò ta̱bean di tsa̱u-q'ooan kaà cgae e, ne i gha gaicara ntama kúrúè a tsa̱u? Cúí gúù ga i qãèa máánaa hãa tite, kg'ama tchàa koe aaguè a khóèan ka náàès cúí si i. ");
INSERT INTO nhr_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gatua nqõóm di tu x'áà tu u. X'áé-dxoom xàbìm tc'amkg'ai koe hàna ba cuiskaga chóm̀mèa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Cúí khóè ga gataga lampi sa x'áà-x'aa naka q'ores ka nqãaka tòó sia hãa tite, igaba i gha téé-q'ooa sa koe tòó si, si gha wèé ne ẽe nquum q'oo koe hàna ne x'áàn máà. ");
INSERT INTO nhr_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gatu di x'áàn méé i gatà iim dàòm ka khóè ne cookg'ai koe x'áà, naka ne gha nxãasega gatu di qãè tsééan bóò, naka nea gatu dim Xõòm nqarikg'ai koe hàna ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Táá tu tc'ẽea máá, hààr ko x'áèan ko méé sa kana porofiti xu ko méé sa kaàkagu, ta tc'ẽe guu. Hààra Raa, hààr gha táá kaàkagu si ka, igabar ko hàà tseegukagu si. ");
INSERT INTO nhr_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tseegua ner ko bìrí tu u a ko máá: Nqarikg'aian hẽé naka nqõókg'aian hẽéthẽéa gha kaà, igabam cúím góám cg'árém ga ba kana góá-hìim ka góáèa gúùan ga igaba x'áèan koe guu a kaà tite, i gha nxãakg'aiga síí wèé gúùan kúrúse. ");
INSERT INTO nhr_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Khama nxãaska, dìím wèém ẽe gha ncẽe x'áè-kg'áḿan ka cg'áré ba kaàkagu ba, a ba a ncẽes gúù sa kúrúan khóè ne xgaa-xgaa ba, nxãa ba gha nqarikg'ai di x'aian koe cg'áré ba ta ma tciiè. Igaba ẽe ko x'áè-kg'áḿan kúrú, a ba a ko xgaa-xgaa a ba, nxãa ba gha nqarikg'ai di x'aian koe kaia ba ta ma tciiè. ");
INSERT INTO nhr_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Bìrí tu ur ko a ko máá: Gatu di tchànoan kòo x'áè xgaa-xgaa-kg'ao xu dian hẽé naka Farasai xu dian hẽéthẽé nqáé tama ne tu cuiskaga nqarikg'ai di x'aian koe tcãà tite. ");
INSERT INTO nhr_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kóḿa tu hãa, ne kò ncìí kuri di ne khóè ne bìríè a ko máá: ‘Táá cg'õo guu.’ ‘Wèém ẽe gha cg'õo ba gha xgàrakuan tééa máá,’ téméè. ");
INSERT INTO nhr_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Igabar ko Tíía bìrí tu u a ko máá: Dìím wèém ẽe qõesem koe xgóà hãa ba gha xgàrakuan tééa máá. Gataga dìím wèém ẽe ko qõese ba bìrí a máá: ‘Káà hùi tsi gúù tsi i,’ témé ba gha x'áèan di xu kaia xu cookg'ai koe xo̱ara mááse. Igaba dìím wèém ẽe ko máá: ‘Tsáá káà tc'ẽe tsi gúù tsi,’ témé ba chõò tamas c'ees dxãwam dis ka tééa mááèa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Khama nxãaska, ẽe tsi kò tsaris aba sa altaram koe úú ne, a tsi a ko gaa koe tc'ẽe-tc'ẽese tsáá qõe ba c'ẽes gúù sa tsáá cgoa úúa sa ne, ");
INSERT INTO nhr_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","méé tsi tsari aban gaa koe guu, altaram cookg'ai koe. Naka tsia kg'aia qõò naka síí tsáá qõem cgoa tòókuan kúrú, naka nxãwa hàà tsari aban úú. ");
INSERT INTO nhr_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Qháésega méé tsi ẽe ko chìbi-chibi tsim cgoa kóḿku, ẽe tsi kòo xgàrakuan dis qhàìs koe síí cgoa me ne. Nxãa tama kò ii nem gha xgàra-kg'aom tshàu q'oo koe tcãà tsi, me gha xgàra-kg'ao ba qáé-kg'aom tshàu q'oo koe tcãà tsi, tsi gha qáé-nquus koe tcãàè. ");
INSERT INTO nhr_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tseegua ner ko bìrí tsi a ko máá: cuiskaga tsi gaa koe tcg'oara hãa tite, a gha nxãakg'aiga síí ẽe qaùa hãam mari-coa ba suruta. ");
INSERT INTO nhr_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kóḿa tu hãa i kòo ncẽeta mééè a ko máá: ‘Táá cg'áràn kúrú guu,’ téméè. ");
INSERT INTO nhr_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Igabar ko Tíí bìrí tu u a ko máá: wèém khóèm ẽe ko dxàe-khoe sa bóò, a ba a ko ncóó si ba, ncãa nxãakamaga cg'áràn kúrú cgoa si tcáóa ba koe. ");
INSERT INTO nhr_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A ncẽè kg'áò xòè dim tcgáím tsarim kòo chìbian kúrúkagu tsi ne méé tsi nxo̱bea tcg'òó naka aagu me. Qãè e, c'ẽe xòèa tsi gha aaguè sa ke, wèé tc'áróa tsi chõò tamas c'ees dxãwam dis koe xaoa tcãàèan ka. ");
INSERT INTO nhr_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Gataga ncẽè kg'áòm x'õàm tsarim kòo chìbian kúrúkagu tsi ne méé tsi q'ãea tcg'òó naka aagu me. Qãè e c'ẽe xòèa tsi gha aaguè sa, wèé tc'áróa tsi gha chõò tamas c'ees dxãwam dis koe tcãàèan ka ke. ");
INSERT INTO nhr_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gataga i kò ncẽeta mééè a ko máá: ‘Dìím wèém ẽe ko gam dis khóès cgoa q'aa ba méém tcgãya sa góá máá si, q'aa cgoa siam hãa di sa,’ ta mééè. ");
INSERT INTO nhr_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Igabar ko Tíí bìrí tu u a ko máá: Wèém khóèm ẽe ko gam dis khóè sa aagu ba, cg'árà nes kúrúa domka tamase, ba ko cg'árà-kg'ao sa kúrú si, me ko dìím wèém ẽe ko aaguèas khóè sa séè ba cg'áràn kúrú, tar ko méé. ");
INSERT INTO nhr_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gataga tu kóḿa hãa, ne kò ncìí kuri di ne khóè ne bìríè a ko máá: ‘Táá tshúù-ntcõan cgoa gaìse guu, igaba méé tsi tsari gaìsean X'aigam Nqarim cookg'ai koe tseegukagu,’ téméè. ");
INSERT INTO nhr_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Igabar ko Tíí bìrí tu u a ko máá: Táá gaìse guu, nqarikg'ai cgoa ga igaba, Nqarim dis ntcõó-q'oos x'aian di si i ke, ");
INSERT INTO nhr_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kana nqõómkg'ai cgoa ga igaba, Gam di nqàrèa nem ko tòó qgáì i ke, kana Jerusaleman cgoa ga igaba, kaiam X'aigam dim x'áé-dxoo me e ke. ");
INSERT INTO nhr_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Gataga méé tsi táá tcúúa tsi cgoa gaìse guu, cuiskaga tsi cúím c'õòm tsarim ga ba kúrú nakam q'úú kana ntcùúa hãa tite ke. ");
INSERT INTO nhr_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kg'amaga méés gatu dis ‘Eè’ sa ‘Eè’ sa ii, nakas gatu dis ‘Eẽ ẽe’ sa ‘Eẽ ẽe’ sa ii. A ncẽè c'ẽes gúù sa tsi kò ncẽe zi kg'ui zi koe càùa mááse nes gha nxãa sa dxãwam koe guua. ");
INSERT INTO nhr_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kóḿa tu hãa i kòo ncẽeta mééè a ko máá: ‘Tcgáí ba méém tcgáím c'ẽem domka tcg'òóè, nakam xõ̱ó ba xõ̱óm domka tcg'òóè,’ ta mééè. ");
INSERT INTO nhr_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Igabar ko Tíí bìrí tu u a ko máá: Táá cg'ãè tc'ẽem khóè ba ka̱bia máá guu, igaba dìím wèém ẽe ko kg'áò xòè di góóa tsi koe xg'áḿ tsi ba, nxãa ba c'ẽem góó xòè ba máà thẽé nakam xg'áḿ. ");
INSERT INTO nhr_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","A ncẽè khóèm kò xgàrakuan dis qhàìs koe úú tsi, a tsari subu marian di qgáían séè kg'oana ne, máà me gataga thẽé tsari kaisa marian di qgáía ne. ");
INSERT INTO nhr_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Dìím wèém ẽe gha ko chùi tsi, cúím kilomitara ba tsi gha gam di zi gúù zi xgàm a qõò ba, nxãam cgoa méé tsi cám̀ kilomitaran qõò. ");
INSERT INTO nhr_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Máà ẽe ko dtcàrà tsi ba, naka ẽe cgóbè cgae tsi kg'oana ba táá q'aumana guu. ");
INSERT INTO nhr_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kóḿa tu hãa i kòo ncẽeta mééè a ko máá: ‘Tsáá ka c'ẽe ba méé tsi ncàm̀, naka tsia tsarim cg'õo-kg'ao ba hòre,’ téméè. ");
INSERT INTO nhr_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Igabar ko Tíía bìrí tu u a ko máá: Gatu di cg'õo-kg'aoan méé tu ncàm̀, naka còrèa máá ẽe ko xgàra tu u ne, ");
INSERT INTO nhr_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","naka tua gha nxãasega gatu ka Xõòm nqarikg'ai koe hànam di tu cóá tu ii. Gam dis cáḿ sam ko kúrú si ẽe cg'ãè ne hẽé naka ẽe qãè ne hẽéthẽé qaò cgae, a ba a ko túúan ẽe tchàno ne koe hẽé naka ẽe kàma ne koe hẽéthẽé tsééa úú. ");
INSERT INTO nhr_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eẽ ncàm̀ tua hãa ne tu kò ncàm̀a hãa, ne ia gha dùútsa surutan ka̱bisea máá tu u? Mari xg'ae-xg'ae-kg'ao xu igaba xu ko thẽé gataga hẽé khama. ");
INSERT INTO nhr_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","A ncẽè gatu di qõean cúí ga tu kòo tsgám̀kagu, ne tu ko dùús cgáé sa kúrú? A tãá zi qhàò zi di ne igaba ne gáé thẽé gataga hẽé tama? ");
INSERT INTO nhr_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nxãaska méé tu tchàno ii, ncẽem ma gatu ka Xõòm nqarikg'ai koe hàna ba ma tchàno Me e khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Q'ãa méé tu naka tua gatu di zi tséé zi tchàno zi táá khóè ne cookg'ai koe kúrú guu, naka táá khóè ne x'áí zi guu. Gatà tu kò hẽé ne tu surutan hòò tite, gatu ka Xõòm nqarikg'ai koe hànam koe. ");
INSERT INTO nhr_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“A c'ẽem dtcàrà-kg'ao ba tu kò c'ẽes gúù sa máà kg'oana ne méé tu còrè-nquuan hẽé naka x'áéan xg'aeku koe hẽéthẽé táá torompitan cgoa nxàe ana téé guu, qãè khóèan khama ko ma kúrúse xu khóè xu ko hẽé khama, nxãasega xu gha c'ẽe khóèan ka dqo̱m̀mè ka. Tseegua ner ko bìrí tu u a ko máá: Gaxu di surutan xu khóè ne koe cg'oèase hòòa. ");
INSERT INTO nhr_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Igaba tsáá ẽe tsi kòo c'ẽem dtcàrà-kg'ao ba c'ẽes gúù sa máà ne, táá hẽé nas dxàes x'õàs tsari sa q'ãa, kg'áòm x'õàm tsarim ko kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Naka i gha nxãasega gúùan tsi tcg'òó q'oo chóm̀sea hãa, Me gha Saòm ncẽe ko chóm̀sea zi gúù zi bóò ba gha suruta tsi. ");
INSERT INTO nhr_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Naka gatà còrè tu kò ne méé tu táá qãè khóèan khama ko ma kúrúse xu khóè xu khama ii guu, còrè-nquuan q'oo koe hẽé naka x'áéan xg'aeku koe hẽéthẽé ko nqàrè ka téé a còrèan ncàm̀a xu, nxãasega ne gha wèé ne khóè ne bóò xu ka. Tseegukar ko bìrí tu u a ko máá: Gaxu di surutan xu khóè ne koe cg'oèase hòòa. ");
INSERT INTO nhr_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Igaba tsáá ẽe tsi kò còrè ne méé tsi tsarim nquum q'oo koe tcãà, naka nquu-kg'áḿ ba tcẽekg'am, naka tsia Saò ba còrè, ncẽe hòòse tama ba. Nakam gha nxãasega Saò ba suruta tsi, ncẽe ko chóm̀sea zi gúù zi bóò ba. ");
INSERT INTO nhr_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Naka gatà còrè tu kòo ne, táá qaase tama zi kg'ui zi káí zi tséékagu guu, tãá zi qhàò zi di ne ko hẽé khama, káí zi kg'ui zi ẽe ne ko kg'ui zi ka ne gha komsanaè, ta ne tc'ẽea khama. ");
INSERT INTO nhr_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Táá gane khama ii guu. Gatu ka Xõò ba tu ko dtcàràs cookg'ai koem gatu koe ko tcào sa nxãakamaga q'ana hãa ke. ");
INSERT INTO nhr_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ke méé tu ncẽeta ma còrè na máá: Sita ka Xõò Tseè nqarikg'ai koe hàna Tseè, cg'õèa Tsi méé i dqo̱m̀mè, ");
INSERT INTO nhr_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tsari x'aian méé i hàà. Tsáá ko tc'ẽe sa méés nqõómkg'ai koe kúrúè nqarikg'ai koes ko ma kúrúè khama. ");
INSERT INTO nhr_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sita dis tc'õos wèé cáḿ di sa ncẽe cáḿ ka máà ta a. ");
INSERT INTO nhr_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Naka qgóóa máá ta a chìbia ta, sita ma c'ẽe ne gane di chìbian ma qgóóa máána hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Táá kúrúa bóòkuan koe tcéèa úú ta a guu, igaba dxãwam dim dàòm koe tcg'òó ta a. X'aian hẽé, naka qarian hẽé, naka x'áàn hẽéthẽéa chõò tamase Tsari i ke. Amen. ");
INSERT INTO nhr_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Khóè ne tu kò gane di chìbian qgóóa máá nem gha gataga gatu ka Xõòm nqarikg'ai di ba gatu di chìbian koe qgóóa máá tu u khama. ");
INSERT INTO nhr_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Igaba ncẽè khóèan tu kò gaan di chìbian qgóóa máá tama, nem gatu ka Xõò ba thẽé cuiskaga chìbia tu qgóóa máá tu ua hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Gataga thẽé, ẽe tu kò tc'õoan carase ne méé tu táá cg'ãè-cg'ãe kg'áí guu, qãè khóèan khama ko ma kúrúse xu khama ma, ncẽe cg'ãè-cg'ãe kg'áí ko xu, c'ẽe ne xu gha nxãasega x'áí, tc'õoa ne xu ko carase sa ka xu. Tseegua ner ko bìrí tu u a ko máá: Gaxu di surutan xu khóè ne koe cg'oèase hòòa. ");
INSERT INTO nhr_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Igaba ẽe tsi kò tc'õoan carase ne méé tsi xg'aà kg'áí naka nxúìan tcgáùse. ");
INSERT INTO nhr_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Naka i gha nxãasega tsari tc'õoan carasean táá c'ẽe ne ka bóòè guu, igaba tsarim Xõòm ka, ncẽe hòòse tama ba. Me gha Saòm ncẽe chóm̀sea zi gúù zi ko bóò ba suruta tsi. ");
INSERT INTO nhr_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Táá méé tu nqõómkg'ai koe qguùan tòóa mááse guu, ncẽe tcg'ãàn hẽé naka ncàbàn hẽéthẽé ko tc'õó o koe, ncẽe ts'ãà-kg'aoan ko khõá a tcãà a ts'ãà a koe. ");
INSERT INTO nhr_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Igaba méé tu gatu di qguùan nqarikg'ai koe tòóa mááse, ncẽe tcg'ãàn hẽé naka ncàbàn hẽéthẽé tc'õó o tite koe, kana ts'ãà-kg'aoan ga khõá naka tcãà na ts'ãà tite koe. ");
INSERT INTO nhr_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Eẽ tsari qguùan hãa koe i gha gataga thẽé tsari tcáóan hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Tcgáí ba tc'áróm dim x'áà me e. Ncẽè tcgáía tsi kò qãè ii, nem tsarim tc'áróm wèé ba x'áàn ka cg'oèa. ");
INSERT INTO nhr_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Igaba ncẽè tcgáía tsi kò tshúù ii, nem tc'áróm tsari ba dcùú-qoman ka cg'oè cgaeèa. A ncẽè tsari x'áàn kò dcùú-qom sa ii ne, i gáé gha nta noose dcùú-qoman kaia! ");
INSERT INTO nhr_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Cám̀ x'aigan gha tsééa máám khóè ba káà me e. C'ẽe bam gha hòre, a c'ẽe ba ncàm̀ khama, kanam gha c'ẽem koe dtcãàse, a c'ẽe ba ntcoe khama. Cuiskaga tu Nqari ba hẽé naka qguùan dim nqárì ba hẽéthẽé tsara cúí x'aè ka tsééa máána hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Gaa domkar ko bìrí tu u, a ko máá: Táá gatu di kg'õèan ka káíse tc'ẽe-tc'ẽese guu, dùú tu gha tc'õó kana kg'áà sa, kana tc'áróa tu ka igaba, dùú tu gha hã̱a sa. Kg'õè sa gáé tc'õoan ka cgáé tama, me tc'áró ba qgáían ka cgáé tama? ");
INSERT INTO nhr_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bóò nqarikg'ai di tsa̱rá ne: xhárà tama i hãa, a tcuù tama, a gataga tòóa mááse tama, gabàm ko qanega gatu ka Xõòm nqarikg'ai di ba xárò o. Ka gatu gáé gaan ka cgáé tama? ");
INSERT INTO nhr_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gatu ka c'ẽem dìí ba gha gáé káíse tc'ẽe-tc'ẽesean ka, kg'õèa ba di cáḿan koe cáḿ ba càù? ");
INSERT INTO nhr_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“A tu a ko dùús domka qgáían ka káíse tc'ẽe-tc'ẽese? Bóò, nta i qãáka di x'aan ii sa, nta i ko ma tso̱m sa. Tséé tama i hãa, a gataga qgáían qgãéa mááse tama. ");
INSERT INTO nhr_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Igabar ko bìrí tu u a ko máá: x'aigam Solomonem gabà kò gam di x'aian wèé koe ga ncẽe zi x'aa zi ka c'ẽea zi khama ma táá hã̱a. ");
INSERT INTO nhr_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ncẽè Nqarim kòo qãáka di dcãan, ncẽe ko ncẽe cáḿ ka hãa, a q'uu ka c'eean q'oo koe xaoa tcãàè, nxãan ncẽeta ma hã̱akagu, nem gha tseegukaga cgáése gatua hã̱akagu tu u, oo, gatu ncẽe cg'áré dtcòm̀an úúa tuè! ");
INSERT INTO nhr_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Gaa domka méé tu táá káíse tc'ẽe-tc'ẽese guu naka máá: ‘Dùú sa ta gha tc'õó?’ témé, kana máá: ‘Dùú sa ta gha kg'áà?’ témé, kana máá: ‘Dùú sa ta gha hã̱a?’ témé guu. ");
INSERT INTO nhr_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tãá zi qhàò zi di nea ko wèé gúùan ncẽe ga qaa, Me gatu ka Xõòm nqarikg'ai di ba ncẽe gúùan tu ko tcào sa q'ana hãa ke. ");
INSERT INTO nhr_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Igabaga méé tu kg'áíka X'aigam Nqarim di x'aian hẽé naka Gam di tchànoan hẽéthẽé qaa, naka tua gha ncẽe zi gúù zi wèéa zi ga thẽé máàè. ");
INSERT INTO nhr_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ke tu táá q'uu dim cáḿ ka káíse tc'ẽe-tc'ẽese guu, q'uu dim cáḿ ba gha cúía tc'ẽe-tc'ẽese gam ka ke. Wèém cáḿ ba gam di xháéan tc'ãòa. ");
INSERT INTO nhr_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Táá c'ẽem khóè ba xgàra guu, naka tua gha nxãasega táá xgàraè guu. ");
INSERT INTO nhr_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gaam dàòm cúím ẽe tu ko c'ẽe ne bóò a xgàram cgoaga tu gha Nqarim ka bóò a xgàraè ke, si gha tc'ãò-tc'ãos ẽe tu ko c'ẽe ne koe tséékagu sa gatu koe tséékaguè. ");
INSERT INTO nhr_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Dùús domka tsi ko tsáá ka c'ẽem tcgáí q'oo koe hãam tcg'óbé ba hòòa máá, igaba tsi tsáá tcgáí q'oo koe hãam hìi-dxoo ba hòò tama? ");
INSERT INTO nhr_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nta tsi gha tsáá ka c'ẽe ba bìrí a máá: ‘Tíí tcáràè, hàà nakar tcgáí q'ooa tsi koe tcg'óbé ba tcg'òó,’ témé, ncẽe tsáá tcgáí q'oo koe hãam hìi-dxoo ba tsi hòò tama koe. ");
INSERT INTO nhr_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tsáá qãè khóèan khama ko ma kúrúse tseè! Kg'áíka tcgáí q'ooa tsi koe hànam hìi-dxoo ba tcg'òó, naka nxãwa qãèse bóò naka tsáá ka c'ẽem tcgáí q'oo koe hàna tcg'óbéan tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Táá ẽe tcom-tcomsa ii sa ha̱ghuan máà guu, naka gataga táá gatu di tca̱àko nxõ̱án xgùuan cookg'ai koe aagu guu. Gatà tu kò hẽé ne i gha nqàrèan gaan di ka náà tcãà a, a i a gha ka̱bise a tòà q'aa tu u. ");
INSERT INTO nhr_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Dtcàrà tu, máàè tu gha ke, qaa tu, hòò tu gha ke, nquu-kg'áḿ ba tu xg'áḿ-xg'am, xgobekg'ama tu gha mááè ke. ");
INSERT INTO nhr_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Dìím wèém ẽe ko dtcàrà ba ko máàè, me ko wèém ẽe ko qaa ba hòò, me gha wèém ẽe ko nquu-kg'áḿ ba xg'áḿ-xg'am ba xgobekg'ama mááè khama. ");
INSERT INTO nhr_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kana ndakam khóè ba gha gam dim cóám kòo péréan dtcàrà me ne, péréan téé-q'oo koe nxõ̱án máà me? ");
INSERT INTO nhr_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kana ẽem kòo x'aù ba dtcàrà me ne, cg'ao ba máà me? ");
INSERT INTO nhr_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","A ncẽè gatu ncẽe cg'ãè tc'ẽe ii tu kò qãè aban gatu di cóán máà q'ana hãa, ne ba gha nxãaska gatu ka Xõòm ncẽe nqarikg'ai koe hãa ba ẽe ko dtcàrà Me ne nta noose nqáéa hãase qãè aban máà! ");
INSERT INTO nhr_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gaa domkar ko bìrí tu u a ko máá: wèé zi gúù zi ẽe tu ko tc'ẽe khóè ne méé ne gatu koe kúrú zi, nxãa zi méé tu gane koe thẽé kúrú. Ncẽe sa x'áèan ka hẽé naka porofitian ka hẽéthẽé ko nxàeès ga si i khama. ");
INSERT INTO nhr_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Xgáḿ-xgam naka nquu-kg'áḿ koe tcãà. Cg'ãèan koe ko úúm kg'áḿ ba tchàà me e, me gaa koe ko qõòm dàò ba thamka me e ke, ne gaa koe ko tcãà ne káí ne e. ");
INSERT INTO nhr_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Igaba bóò, kg'õèan dis heke-kg'áḿ sa cg'áré si i, me gaa koe ko qõòm dàò ba qóḿ me e, ne ẽe ko hòò me ne cg'orò ne e. ");
INSERT INTO nhr_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Tshúù-ntcõan di xu porofiti xu méé tu q'ãa! Gatu koe xu ko ghùuan di khòoan hã̱a a hàà, igabaga xu q'ooa xu koe xaùko xu ncuutshaa xu u. ");
INSERT INTO nhr_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Gaxu di tc'áróan ka tu gha bóòa q'ãa xu. Khóèa ne gáé ko kuri dxàman úúa zi hìi-coa zi koe kg'oman tcuù, kana ia ko dxàmga zi hìi-coa zi koe faian tcuù? ");
INSERT INTO nhr_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gatagas ko ma wèés hìis qãè sa qãè tc'áróan kúrú, igabas ko tshúùs hìi sa tshúù tc'áróan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Qãès hìi sa cuiskaga tshúù tc'áróan kúrúa hãa tite, kanas gataga tshúùs hìi sa cuiskaga qãè tc'áróan kúrúa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Wèés hìis ẽe tc'áróan qãè kúrú tama sa ko xg'aoa tcg'òóè, a c'eean q'oo koe tcãàè. ");
INSERT INTO nhr_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Gaa domka tu gha gaxu di tc'áróan ka q'ãa xu. ");
INSERT INTO nhr_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Wèém khóèm ẽe ko bìrí Te a máá: ‘X'aigaè, X'aigaè,’ témé ba nqarikg'ai di x'aian koe tcãà tite, igaba ẽe ko Tirim Abom nqarikg'ai koe hànam ko tc'ẽe sa kúrúm cúím ga ba gha tcãà. ");
INSERT INTO nhr_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Káí ne gha ẽem cáḿ còo dim ka bìrí Te a máá: ‘X'aigaè, X'aigaè, a gatá tama taa ncẽe kòo Tsarim cg'õèm cgoa porofita ta, a Tsarim cg'õèm cgoa dxãwa tc'ẽean xhàiagu ta, a gam cgoa káí zi gúù zi are-aresa zi kúrú ta?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ra gha nxãaska tchànose bìrí ne a máá: ‘Ncìísegar c'úù tua, gatu cg'ãè gúù kúrú-kg'ao tu, ke tu Tíí koe tcg'oa!’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Dìím wèém ẽe ko Tiri kg'uian ncẽe kóḿ, a i ko méé sa kúrú ba gha tc'ẽegam khóèm khama ii, ncẽe ko gam dim nquu ba qãès tshoa-tshoase-q'oos koe tshào ba. ");
INSERT INTO nhr_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","I túúan hàà, i tshàan cg'oè a tòè, i tc'ãán tc'ãá a i a ẽem nquu ba xàbù, igabagam kò táá cg'áé, qãès tshoa-tshoase-q'oos koem kò tshàoa tòóèa khama. ");
INSERT INTO nhr_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Igaba dìím wèém ẽe ko Tiri kg'uian kóḿ, igaba kúrú u tama ba gha káà tc'ẽem khóèm khama ii, ncẽe ko gam dim nquu ba góḿankg'ai koe tshàoa tòó ba, qãès tshoa-tshoase-q'oos cgoa tamase. ");
INSERT INTO nhr_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","I túúan hàà, i tshàan cg'oè a tòè, i tc'ãán tc'ãá, a i a ẽem nquu ba tcãò, me cg'áé, a kaias gúùs khama ma cg'áé ba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Eẽm ko Jeso ba ncẽe zi gúù zi nxàea xg'ara ka zi ko xg'ae zi Gam di xgaa-xgaa-q'ooan ka area hãa. ");
INSERT INTO nhr_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Qarian úúam khóèm khamam kòo ma xgaa-xgaa ne khama, gane di xu x'áè xgaa-xgaa-kg'ao xu khama tamase. ");
INSERT INTO nhr_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Eẽm kò Jeso ba xàbìm koe guu a ko xõa ka zi kò káí zi xg'ae zi khóè ne di zi xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Me gaa x'aè kaga lepero dis tcìì sa tsàaram khóè ba hàà cgae Me, a hàà cookg'aia ba koe qgom-tsi-quri, a máá: “X'aigaè, tc'ẽe Tsi kòo ne Tsi ga kúrú ter q'ano,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Me tchoanà tshàu, a qgóó me, a máá: “Gatàr ko ma tc'ẽe, ke q'ano!” témé. Kas kò gam dis tcììs lepero di sa kúúga kaà cgae me. ");
INSERT INTO nhr_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Me Jeso ba bìrí me a máá: “Q'ãa, naka táá cúí khóè ga c'ẽe gúù ga bìrí guu. Igaba méé tsi qõò naka síí peresitim koe x'áíse, naka ẽem Moshe x'áèa hãas aba sa tcg'òó, x'áís iise khóè ne koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Eẽm ko Jeso ba Kaperenaume koe síí tcãà kam kò ncõo-kg'ao xu dim tc'ãà-cookg'ai ba hàà cgae Me, a hàà hùikuan dtcàrà cgae Me a máá: ");
INSERT INTO nhr_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“X'aigaè, tirim qãà ba x'áéa te koe xõe, a nqo̱ara hãa, a ba a kaisa thõòan koe hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Me bìrí me a máá: “Síír gha a kúrú mem qãè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Me ncõo-kg'ao xu dim tc'ãà-cookg'ai ba xo̱a a máá: “X'aigaè, dìí cgáér tama ra a, nquua te tco̱be dòm̀ q'oo koe Tsi ga tcãà ra. Ke kg'amaga kg'ui ba tcg'òó nakam gha tirim qãà ba kg'õè. ");
INSERT INTO nhr_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Tíí igabar kaia xu dòm̀ q'oo koe hànar khóè ra a, xu gataga ncõo-kg'ao xu tíí dòm̀ q'oo koe hàna ke. Ra ko ncẽe ba bìrí a máá: ‘Qõò,’ témé, me qõò, ra c'ẽe ba bìrí a máá: ‘Hàà,’ témé, me hàà. Ra tirim qãà ba bìrí a máá: ‘Ncẽe sa kúrú,’ témé, me kúrú si,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Eẽm ko Jeso ba ẽe sa kóḿ kam kò kaisase are, a ba a ẽe kòo xùri Me ne bìrí a máá: “Tseegua ner ko bìrí tu u: Qanegar cúí khóè ga Iseraele koe hòò ta ga hãa ncẽeta ma kaias dtcòm̀ sa úúa hãa a. ");
INSERT INTO nhr_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bìrí tu ur ko, káí ne gha cáḿs ko tcg'oa xòè koe hẽé naka cáḿs ko tcheè xòè koe hẽéthẽé guu a hàà, a ne a hàà Abrahama ba hẽé naka Isaka ba hẽé naka Jakobe ba hẽéthẽé xu cgoa ntcõó a tc'õó, nqarikg'ai di x'aian koe. ");
INSERT INTO nhr_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Igaba ne gha gane ẽe x'aian di ne tchàa koe xaoa tcg'òóè, dcùú-qoms q'oo koe, ncẽe kg'aean hẽé naka gãò xõ̱óan hẽéthẽé gha hãa koe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Me nxãaska Jeso ba ncõo-kg'ao xu dim tc'ãà-cookg'ai ba bìrí a máá: “Eẽ tsi ma dtcòm̀a hãa khamaga méé i tsáá koe ii, ke qõò,” témé. Me kò gam dim qãà ba gaa x'aèan ẽe kaga qãè. ");
INSERT INTO nhr_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Eẽm ko Jeso ba Peterem dim nquum koe tcãà kam kò Peterem ka c'uìse sa bóò, si cgùrukagu si kos tcììs ka qgóóèa, a xóé-xõe. ");
INSERT INTO nhr_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Me kò tshàua sa qgóó, i tcììan guu si, si tẽe a sa a tshoa-tshoa a tsééa máá Me. ");
INSERT INTO nhr_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Eẽm dqòam ka ne kò káí ne khóè ne dxãwa tc'ẽean úúa hãa ne Gam koe óá. Me kg'uim cgoa dxãwa tc'ẽean xhàiagu, a ba a wèé ne ẽe kò tsàa ne kúrú ne kg'õè. ");
INSERT INTO nhr_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ncẽe sa kò kúrúse, nxãasegas gha ẽem ko porofitim Isaia ba nxàea sa tseegukaguè ka, ncẽe ko máá: “Gatá di thõòa nem séèa, a ba a tcììa ta xgàm a qõò cgoaa,” témé sa. ");
INSERT INTO nhr_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Eẽm ko Jeso ba khóè ne dis xg'ae sa qàea ba koe bóò, kam kò x'áèan tcg'òó, tchoaba méé xu c'ẽem xòèm tshàam dim koe di i. ");
INSERT INTO nhr_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Me nxãaska x'áè xgaa-xgaa-kg'ao ba hàà cgae Me, a hàà bìrí Me a máá: “Xgaa-xgaa-kg'aoè, ẽe Tsi ko síí qgáì wèé koer gha xùri Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Me Jeso ba xo̱a me a máá: “Círía ne gaan di ha̱éan úúa, i tsa̱rán gaan di nquuan úúa, igabagam Khóèm dim Cóá ba tòó tcúúm gha qgáì úú tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Me c'ẽem xgaa-xgaase-kg'ao ba bìrí Me a máá: “X'aigaè, kg'aia qãà te nakar síí tirim xõò ba kg'ónò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Igabam kò Jeso ba bìrí me a máá: “Xùri Te, naka ẽe x'óóa hãa ne guu naka ne gane dian ẽe x'óóa hãa kg'ónò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Eẽm ko dxòrom q'oo koe tcãà ka xu kò Gam di xu xgaa-xgaase-kg'ao xu xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Me kò kúúga kaiam tc'ãá ba tshàam tc'amkg'ai koe tẽe, me dxòro ba tshàam di qhonèan ka xàbùa tcg'òóè, igabam kò Jeso ba x'óm̀a hãa. ");
INSERT INTO nhr_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xu síí ghùi Me a máá: “X'aigaè, hùi xae e! Tom̀ xae ko ke!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Me bìrí xu a máá: “Dùús domka xao ko ma q'aea, gaxao ncẽe cg'áré dtcòm̀an úúa hãa xaoè?” témé. Kam ko nxãaska tẽe a ba a tc'ãá ba hẽé naka tshàa ba hẽéthẽé dqàè, si kaisas nqoo sa xóé. ");
INSERT INTO nhr_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Xu ẽe kò hãa cgoa Mea xu are, a tẽèku a máá: “Dùútsa khóè ba gáé ncẽe ba? Tc'ãán ga hẽé naka tshàan ga hẽéthẽé ka ko komsanaè ba!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Eẽm ko c'ẽem xòèm tshàam dim koe síí, Gadarene dim xg'aekum di ba, kam ko cám̀ tsara khóè tsara dxãwa tc'ẽean úúa tsara cgoa xg'ae, tc'ám̀ zi koe kò guua hãa tsara. Kaisase bèe-beesa kò ii tsara, i kò cúí khóè ga gaam dàò ba séè naka nqáé tite. ");
INSERT INTO nhr_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Gaa x'aè kaga tsara kò q'au a máá: “Dùú sa Tsi ko tc'ẽe sitsam koe, Nqarim di Tsi Cóá Tseè? A hààra Tsia, hàà Tsi gha xgàra tsam m ka, nxárá tòóèam x'aèm cookg'ai koe?” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Zi kò káí zi xgùu zi gaxu ka cg'árése nqúù ka hãa a ko dxòó. ");
INSERT INTO nhr_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","I kò gatsara di dxãwa tc'ẽean Jeso ba dtcàrà a máá: “Ncẽè hàà Tsi kò ko xhàiagu ta a ne méé Tsi xgùuan dis xg'aes koe tsééa úú ta a,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Me bìrí i a máá: “Qõò!” témé. I tcg'oa, a i a síí xgùuan koe tcãà. Si wèés xg'aes xgùuan di sa kari-karisea xõa a síí tshàan q'oo koe x'óó. ");
INSERT INTO nhr_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Xu ẽe kòo xgùuan kòre xu khóè xu bèe a qgóé, a x'áé-dxoom koe síí, a síí wèéan ga nxàe, ẽe kò dxãwa tc'ẽean úúa tsara khóè tsara koe kúrúsean ga hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kam kò wèém x'áé-dxoo ba tcg'oa, a síí Jesom cgoa xg'ae. Eẽ ne ko bóò Me, ka ne kò dtcàrà Me, gane dim nqõóm koem gha tcg'oa sa. ");
INSERT INTO nhr_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nxãaskam kò Jeso ba dxòrom q'oo koe tcãà, a tchoaba a ba a Gam dim x'áé-dxoom koe síí. ");
INSERT INTO nhr_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ka xu kò gaa x'aè kaga c'ẽe xu khóè xu khóèm nqo̱ara hãa ba Gam koe óága, gam dim tcoàm koe xòó mea hãase. Eẽm ko Jeso ba gaxu di dtcòm̀an bóò kam kò ẽe nqo̱ara hãa ba bìrí a máá: “Tòón tcáó, Tiri tsi cóá tseè, chìbia tsi tsi qgóóa mááèa hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ka xu ko c'ẽe xu x'áè xgaa-xgaa-kg'ao xu tcáóa xu q'oo koe máá: “Ncẽem khóè ba ko Nqari ba cóè!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Igabam ko Jeso ba bóòa q'ãa ẽe xu tc'ẽea hãa sa a máá: “Dùús domka xao ko cg'ãè zi gúù zi tcáóa xao q'oo koe tc'ẽea máá? ");
INSERT INTO nhr_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ndaka nea thamkaà? ‘Chìbia tsi tsi qgóóa mááèa,’ témé saa kana máá: ‘Tẽe naka qõò,’ témé saa?” tam ma tẽè xu. ");
INSERT INTO nhr_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","“Igabagar gha x'áí xao o, xao gha nxãasega q'ãa, Khóèm dim Cóá ba nqõómkg'ai koe qarian úúa hãa sa, khóèa nem gha gaan di chìbian qgóóa máá di i,” témé. Nxãaskam kò ẽe nqo̱ara kò hãa ba bìrí a máá: “Tẽe naka tsarim tcoà ba séè naka x'áé koe dìbi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Me tẽe a ba a x'áéa ba koe dìbi. ");
INSERT INTO nhr_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eẽ zi ko khóè ne di zi xg'ae zi ncẽes gúù sa bóò, ka ne kò q'áòs ka tcãàè, a ne a Nqari ba dqo̱m̀, ncẽe kò ẽeta ii qarian khóèan máà ba. ");
INSERT INTO nhr_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Eẽm ko Jeso ba gaa koe guu kam kò Mataio ta ko ma tciièm mari xg'ae-xg'ae-kg'ao ba bóò, me marian ko séèa xg'ae-xg'aeèm nquum koe ntcõóa-ntcõe. Me bìrí me a máá: “Xùri Te,” témé. Me tẽe a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","I kúrúse Me Jeso ba Mataiom x'áé koe síí hãa a ko tc'õó. Ka i ko káí mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé hàà, a hàà Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé cgoa ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Eẽ xu ko Farasai xu ẽes gúù sa bóò ka xu kò Gam di xu xgaa-xgaase-kg'ao xu tẽè a máá: “Dùús domka ba ko gaxao dim Xgaa-xgaa-kg'ao ba mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé cgoa tc'õóa máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ncẽes gúù sam ko kóḿ kam kò Jeso ba máá: “Eẽ tsàa tama ne khóè nea naakan qaa tama, igaba ẽe ko tsàa ne ko qaa a. ");
INSERT INTO nhr_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ke xao qõò naka síí xgaa-xgaase, ncẽem kg'ui ba ko dùú sa méé sa: ‘Thõò-xama-máákua ner ko khóè ne xg'aeku koe tc'ẽe, dàòa-máákuan ka tamase,’ ta ko méé ba. Tchàno ne khóè ner gha hàà tcii kar hàà tama, igabar hààraa, hààr gha chìbi-kg'ao ne tcii ka khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nxãaska xu kò Johanem di xu xgaa-xgaase-kg'ao xu síí cgae Me a síí tẽè Me a máá: “Dùús domka xae ko sixae hẽé naka Farasai xu hẽéthẽé xae káíse tc'õoan carase, igaba xu Tsari xu xgaa-xgaase-kg'ao xu tc'õoan carase tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Me Jeso ba xo̱a xu a máá: “Séè-kg'aom kò gam di ne cg'áè-kg'ao ne cgoa hãa ne nea gha dùús domka kg'ae? Igabam gha x'aè ba hàà, séè-kg'aom gha gane koe guu a séèa tcg'òóè ba, ne gha nxãaska tc'õoan carase. ");
INSERT INTO nhr_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Dìím ga ba cuiskaga qgáí cg'anà ba ka̱bam qgáím cgoa nqàba hãa tite, ẽes nqàba sa gha ẽem qgáím koe tòàra tcg'oa, si gha tòà sa càùse khama. ");
INSERT INTO nhr_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Gataga i khóèan cuiskaga ka̱ba gõéan ncìí zi khòo dtcòbè zi gõéan di zi q'oo koe gõéan qg'oea hãa tite. A ncẽè gatà i kò ko hẽé ne zi gha khòo dtcòbè zi qgaìse, i gõéan ntcã̱a, zi dtcòbè zi tòàra q'aase. Igaba i ko ka̱ba gõéan ka̱ba zi khòo zi koe qg'oeè, i wèéan qãè qgáì koe tòóè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Eẽm qanega hãa a ko ncẽes gúù sa gane cgoa nxàe kam kò kúúga c'ẽem tc'ãà-cookg'ai ba hàà, a hàà cookg'aia ba koe qám̀se, a máá: “Tiris cóá sa ncãa sencgaga x'óó. Ke hàà naka hàà Tsari tshàuan tòó cgae si, nakas kg'õè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Me Jeso ba tẽe a qõò cgoa me, xu Gam di xu xgaa-xgaase-kg'ao xu xùri tsara a. ");
INSERT INTO nhr_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kas ko 12 kurian kò úúa hãa, a ko xòm̀ x'aèse nxoean hòòs khóè sa qãáa ba koe guu a hàà, a hàà Gam dim qgáím di xgáḿ-kg'aman qgóó. ");
INSERT INTO nhr_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Gaas kas kò bìríse a máá: “Gam dim qgáí bar kò qgóó ne cúígar gha qãè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Me Jeso ba ka̱bise a bóò si, a máá: “Tòón tcáó, Tiri si cóá seè, sari dtcòm̀a nea qãèkagu sia ke,” témé. Si khóè sa gaa x'aèan ẽe kaga qãè. ");
INSERT INTO nhr_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Eẽm ko Jeso ba tc'ãà-cookg'aim dim nquum koe tcãà, a ko fulutu cii-kg'ao xu hẽé naka tcẽé-tcẽe kò kos xg'ae sa hẽéthẽé bóò, ");
INSERT INTO nhr_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","kam kò máá: “Qõò tu, cóá sa x'óó tama, igabagas kg'ama x'óm̀a hãa ke,” témé. Igabaga ne kò kg'ãè Me. ");
INSERT INTO nhr_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Igaba ẽes kò xg'ae sa tchàa koe tcg'òóèa xg'ara kam kò q'oo koe tcãà, a ba a cóá sa tshàua sa koe séè, si tẽe. ");
INSERT INTO nhr_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ncẽe tchõà ne kò wèém xg'aekum ẽem koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Eẽm Jeso ba ẽe koe guu a ko qõò ka tsara ko káà tcgáí tsara khóè tsara xùri Me, a q'au a ko máá: “Thõò-xama máá tsam m, Dafitem ka Tsgõose-coa Tseè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Eẽm ko nquum q'oo koe tcãà ka tsara ko gaa tsara káà tcgáí tsara khóè tsara hàà cgae Me, Me tẽè tsara a, a máá: “Dtcòm̀ tsao ko qaria ner úúa sa, ncẽe gúùa ner gha kúrú di i?” témé. Tsara xo̱a Me a máá: “Eè, X'aigaè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Me nxãaska tcgáía tsara qgóó, a ba a máá: “Gatsao di dtcòm̀an khamaga méé i ma kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","I gatsara di tcgáían xgobekg'amse. Me Jeso ba qarika dqàè tsara a, a máá: “Bóò méé tsao naka i táá cúí khóè ga ncẽes gúù sa q'ãa guu!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Igabaga tsara kò qõò, a síí Gam di tchõàn wèém xg'aekum ẽem koe xàà. ");
INSERT INTO nhr_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Eẽ tsara kòo qõò kam kò dxãwa tc'ẽean ka tcãàèa a kg'ui tamam khóè ba Jesom koe óágaè. ");
INSERT INTO nhr_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Eẽ i ko gaa dxãwa tc'ẽean xhàiaguè kam kò gaam khóèm ẽe kò kg'ui tama ba kg'ui. Zi kò xg'ae zi area, a zi a máá: “Ncẽeta iis gúù sa qanega Iseraele koe kúrúse tama!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Igaba xu kò Farasai xu máá: “Dxãwa tc'ẽean dim tc'ãà-cookg'aim cgoam ko dxãwa tc'ẽean xhàiagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Me kò Jeso ba wèé xu x'áé-dxoo xu koe hẽé naka x'áé-coa xu koe hẽéthẽé qõòa te, a ba a gane di còrè-nquuan koe xgaa-xgaa, a kò x'aian di qãè tchõàn khóè ne xgaa-xgaa, a ba a kò wèés tcìì sa hẽé naka wèés thõò sa hẽéthẽé tsoò. ");
INSERT INTO nhr_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Eẽm ko xg'ae zi bóò kam kò thõò-xama máá zi, ntcãa-ntcãaè ne kòo, a ne a kò káà hùi ne e khama, kòre-kg'ao ba úú tama zi ghùu zi khama ma. ");
INSERT INTO nhr_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Me nxãaska Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Tcuùè gha gúùa ne káí i, igaba i tséé-kg'aoan cg'orò o. ");
INSERT INTO nhr_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ke xao tcuùs dim X'aiga ba dtcàrà, nakam tséé-kg'aoan tsééa óá naka i hàà tcuù,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Me kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu 12 xu Gaam koe tciia óá, a ba a dxãwa tc'ẽean xhàiagu di qarian máà xu, naka wèé zi tcìì-kg'áḿ zi hẽé naka wèé zi thõò-kg'áḿ zi hẽéthẽé qãèkaguan di i. ");
INSERT INTO nhr_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ncẽea kò cg'õèan x'áè úú-kg'ao xu 12 xu di ga a. Tc'ãà di ba kò Simonem ncẽe kò Petere ta ma tciiè me e, naka gam ka qõesem Anterea ba hẽé, naka Sebetem ka cóásem Jakobo ba hẽé, naka gam ka qõesem Johane ba hẽé, ");
INSERT INTO nhr_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipi ba hẽé naka Baretolomaio ba hẽé, Tomase ba hẽé naka Mataiom mari xg'ae-xg'ae-kg'ao ba hẽé, Alefaiom ka cóásem Jakobo ba hẽé naka Tadaio ba hẽé, ");
INSERT INTO nhr_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simonem ncẽe kò tòókuan x'ãà máá ba hẽé naka Jutasem Isekariote ba hẽéthẽé e, ncẽe kò khóè ne tshàu q'oo koe tcãà Me ba. ");
INSERT INTO nhr_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nxãa xu 12 xum kò Jeso ba ncẽe x'áè-kg'áḿan cgoa tsééa tcg'òó, a máá: “Táá tãá zi qhàò zi di qgáìan koe síí guu, naka táá x'áé-dxooan Samaria ne di ka c'ẽean koe ga tcãà guu. ");
INSERT INTO nhr_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Igaba méé xao Iseraele di ne khóè ne koe qõò, ncẽe aagusea ghùuan khama ii ne. ");
INSERT INTO nhr_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Naka xaoa ẽe xao xóé a ko qõò ka, ncẽe kg'uian xgaa-xgaa naka máá: ‘Nqarikg'ai di x'aia nea cúù u!’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Eẽ ko tsàa ne kg'õèkagu, ẽe x'óóa ne ghùi, gane ẽe lepero dis tcììs di ne q'ano-q'ano, dxãwa tc'ẽean xhàiagu. Surutakaguè tamase xao máàèa hãa, ke xao kg'ama c'ẽe ne surutakagu tamase thẽé máà. ");
INSERT INTO nhr_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Táá xao c'ẽe mari x'õà ga qòè guu. ");
INSERT INTO nhr_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gaxao dis qõòs koe méé xao táá dtcòbèan ga, kana cám̀ tsara qgáí tsara igaba, kana nxàboan ga igaba, kana dqàbian ga igaba séè guu. Tséé-kg'ao ba gam di tc'õoan ka kg'anoèa hãa ke. ");
INSERT INTO nhr_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Wèém x'áé-dxoo ba kana x'áém ẽe xao ko tcãàm koe méé xao khóèan kg'ano-kg'anosa qaa, naka gaan di x'áéan koe hãa naka nxãakg'aiga síí gaa koe tcg'oa. ");
INSERT INTO nhr_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eẽ xao kòo x'áém koe tcãà ne méé xao tsgám̀kagu me. ");
INSERT INTO nhr_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","A ncẽè x'áém kò kg'ano-kg'anosa ba ii, ne méé i gaxao di tòókuan gaam koe hãa, igaba ncẽè gatàm kò ii tama ne méé i gaxao di tòókuan ka̱bise cgae xao o. ");
INSERT INTO nhr_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","A ncẽè c'ẽe khóè ga kò qãèse hààkagu xao o tama, kana gaxao di kg'uian komsana tama, ne méé xao gaam x'áém koe kana x'áé-dxoom koe tcg'oa naka xaoa nqàrèa xao di tsharàn qãè-qãe. ");
INSERT INTO nhr_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tseeguan kagar ko bìrí xao o a ko máá: xgàrakuan dim cáḿ kam gha gam x'áé-dxoo ba Sodoma hẽé naka Gomora hẽéthẽé ka kaisa xgàrakuan hòò. ");
INSERT INTO nhr_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Bóò, Tíí ra ko ghùu zi khama ma ncuutshaan xg'aeku koe tsééa úú xao o. Gaa domka méé xao nxãaska tc'ẽega ii cg'aoan khama ma, naka xaoa tcíbí zi khama ma tc'aua hãa. ");
INSERT INTO nhr_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Igabaga méé xao khóè ne koe kòrese, qáé xao o ne gha a qhàìs cookg'ai koe úú xao o, a gha gane di còrè-nquuan koe xg'áḿ xao o ke. ");
INSERT INTO nhr_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xao gha Tíí domka c'ẽe xu tc'ãà-cookg'ai xu koe hẽé naka x'aiga xu koe hẽéthẽé tcéèa úúè, a gha gaxu cookg'ai koe hẽé naka tãá zi qhàò zi di ne cookg'ai koe hẽéthẽé Tíí ka nxàea tseegukagu. ");
INSERT INTO nhr_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Igaba ẽe ne kò ko gaxu tshàu q'oo koe tcãà xao o ne méé xao táá káíse tc'ẽe-tc'ẽese guu, dùú sa xao gha kg'ui sa, kana nta xao gha ma nxàe si sa, ẽe xao gha kg'ui sa xao gha ẽem x'aèm ka máàè ke. ");
INSERT INTO nhr_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Gaxao tama xao gha ko kg'ui khama, igaba gaxao ka Xõòm dim Tc'ẽe Me e gha ii, ẽe gha ko gaxao koe kg'ui ba. ");
INSERT INTO nhr_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Khóè ba gha qõese ba x'oos koe tcãà, me xõò ba gam dim cóám ka gataga hẽé, i gha cóán gaan di xõòan ntcoe, a gha cg'õo o. ");
INSERT INTO nhr_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Xao gha Tiri cg'õèan domka wèé khóèan ka hòreè. Igaba gaam ẽe gha qarika téé a chõò-q'oos koe síí ba gha kgoaraè. ");
INSERT INTO nhr_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Eẽ c'ẽem x'áém koe xao kò ko xgàraè ne méé xao c'ẽem za bèea síí. Tseegua ner ko bìrí xao o a ko máá: X'áé-dxoo xu Iseraele di xu koe qõoatean cgoa xao xg'ara tite, Me gha nxãakg'aiga síí Khóèm dim Cóá ba hàà. ");
INSERT INTO nhr_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Xgaa-xgaase-kg'ao ba gam dim xgaa-xgaa-kg'aom ka tc'amaka hãa tama, kana qãà ba gam ka q'õòsem ka tc'amaka hãa tama. ");
INSERT INTO nhr_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tc'ãòa i hãa, xgaa-xgaase-kg'aom ga gaam dim xgaa-xgaa-kg'aom khama ii sa, me qãà ba gaam ka q'õòsem khama ii. X'áém dim tcúúm kò ko Belesebule ta ma tciiè ne, ne gha gaam x'áém di ne nxãaska ntama cg'ãèse tciiè! ");
INSERT INTO nhr_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ke táá q'áò ne guu. Wèés gúùs ẽe chóm̀sea hãa sa gha xgòre-kg'aiè, si gha wèés tchõàs chóm̀sea sa nxàese ke. ");
INSERT INTO nhr_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Eẽr ko ntcùúan q'oo koe bìrí xao o gúùan méé xao x'áàn q'oo koe nxàe. Naka ẽe xao kóḿ si ko c'am̀a hãase nxàeè sa méé xao nquuan tco̱be koe kgoarasea hãase nxàe. ");
INSERT INTO nhr_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Táá méé xao khóè ne ẽe ko tc'áró ba cg'õo, igaba tc'ẽe ba ne gha cg'õo di qarian úú tama ne q'áò guu. Igaba méé xao Nqarim ẽe tc'áró ba hẽé naka tc'ẽe ba hẽéthẽé gha chõò tamas c'ees dxãwam dis koe kaàkagu di qarian úúa hãa ba q'áò. ");
INSERT INTO nhr_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","A nxã̱e tsa̱rá sara gáé cúím mari-coam cgoa x'ámáè tama? Igabas cúís ga sa gatu ka Xõòm tc'ẽe tamase, góḿan koe tcheèa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","I gataga wèé c'õòan tcúúa tu di ga nxáráèa. ");
INSERT INTO nhr_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ke táá q'áò guu. Káí zi nxã̱e tsa̱rá zi ka tu kaisase cgáé tu u ke. ");
INSERT INTO nhr_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Khama wèém khóèm ẽe ko khóè ne cookg'ai koe Tíí ka nxàese bar gha Tíí igaba Tirim Xõòm nqarikg'ai koe hãam cookg'ai koe nxàea tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Igaba dìím wèém ẽe ko khóè ne cookg'ai koe xo̱ase Te bar gha Tíí igaba Tirim Xõòm nqarikg'ai koe hãam cookg'ai koe xo̱aseè. ");
INSERT INTO nhr_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Táá tc'ẽea máá, nqõómkg'ai koer ko hàà tòókuan óá, ta tc'ẽea guu. Hààr tòókuan óá tama, igaba ntcàu me e. ");
INSERT INTO nhr_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Hààra Raa, hààr gha khóè ba ka̱bi ka, me gam ka xõòm cgoa táá kóḿku, si cóá sa gas ka xõòs cgoa táá kóḿku, si c'uìse-coa sa c'uìses cgoa táá kóḿku ka. ");
INSERT INTO nhr_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","I gha khóèm di cg'õo-kg'aoan gam dim x'áém di ne khóè ne ii. ");
INSERT INTO nhr_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Wèém ẽe xõò ba kana xõò sa kaisase Tíí ka ncàm̀a ba kg'ano Te tama. Me wèém ẽe gam dim cóá ba kana cóá sa kaisase Tíí ka ncàm̀a ba kg'ano Te tama. ");
INSERT INTO nhr_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Me dìím wèém ẽe gam dim xgàu ba séè naka xùri Te tama ba kg'ano Te tama. ");
INSERT INTO nhr_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Dìím wèém ẽe ko gam dis kg'õè sa qarika qaa ba gha aaguse cgaeè si, me gha dìím wèém ẽe ko Tíí domka gam dis kg'õès ka aaguse cgaeè ba gha hòò si. ");
INSERT INTO nhr_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Wèém ẽe ko qãèse hààkagu xao o ba ko Tíí ga Ra qãèse hààkagu, Me ko dìím wèém ẽe ko qãèse hààkagu Te ba qãèse hààkagu ẽe tsééa óága Tea ba. ");
INSERT INTO nhr_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dìím wèém ẽe ko porofiti ba qãèse hààkagu, porofiti me e domka ba gha porofitian ko máàè surutan hòò. Me gha dìím wèém ẽe ko tchànom khóè ba qãèse hààkagu, tchànom khóè me e domka ba tchànom khóèm ko máàè surutan hòò. ");
INSERT INTO nhr_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tseeguan kagar ko gataga bìrí xao o a ko máá: Dìím wèém ẽe ko qgàisa tshàan dis kubis igaba ncẽe ne cg'áré ne ka c'ẽe ba máà, Tirim xgaa-xgaase-kg'ao me e domka ba gha tseeguan kaga gam di surutan hòò.” ");
INSERT INTO nhr_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Eẽm ko Jeso ba Gam di xu xgaa-xgaase-kg'ao xu 12 xu x'áèa xg'ara, kam kò ẽe koe guu a qõò, síím gha Galilea di xu x'áé xu koe khóè ne xgaa-xgaa, a Nqarim di kg'uian bìrí ne ka. ");
INSERT INTO nhr_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Me Johane qáé-nquus koe hànase Krestem ko kúrú zi tséé zi ka kóḿ, a ba a kg'uian gam di tsara xgaa-xgaase-kg'ao tsara cgoa tsééa úú, ");
INSERT INTO nhr_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","síí méé tsara tẽè Me naka máá: “A Tsáá ga Tsia ncẽe ga ko koma hàà Tsi kana méé xae c'ẽem khóè ba nqòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Me kò Jeso ba xo̱a tsara, a máá: “Qõò naka síí Johane ba bìrí ẽe tsao ko kóḿ a ko bóò sa: ");
INSERT INTO nhr_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ncẽe káà tcgáí ne ko bóò, ne ko ẽe kò qõò tama ne qõò, ne kò lepero dis tcììs di ne qãèkaguè, ne ko ẽe kóḿ tama ne kóḿ, ne ẽe kò x'óóa hãa ne ghùiè, ne ko ẽe dxàua hãa ne qãè tchõàn xgaa-xgaaè. ");
INSERT INTO nhr_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ts'ee-ts'eekg'aièa baa khóèm ẽe gam di dtcòm̀an Tíí koe tcgàba tite ba ncẽe khóèm ko kuri ma nxõ̱ás koe ma tcgàba a cg'áé khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Eẽ tsara ko qõò kam kò Jeso ba tshoa-tshoa a xg'ae zi cgoa kg'ui Johanem ka a máá: “Tchàa-xgóós koe tu kò ko qõò ka tu kò síí dùú sa bóò? Tc'ãán ka ko ntcãa-ntcãaèm tc'áà baa kò ii? Eẽ-ẽe. ");
INSERT INTO nhr_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nxãas tamas kò ii ne tu kò ko síí dùú sa bóò? Khóèm xaam qgáí ba ha̱na baa? Eẽ-ẽe, khóè ne ẽe xaa qgáían ko hã̱a nea x'aigan di nquuan koe hãa. ");
INSERT INTO nhr_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kháé dùú sa tu kò nxãaska síí ko bóò? A porofiti baa? Eè, bìrí tu ur ko, porofitim ka tc'amaka hãa me e. ");
INSERT INTO nhr_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ncẽe ba gaam ka i góáèa hãam ga me e, a ko máá: ‘Bóò, Tirim tchõà xàà-kg'ao bar gha Tsáá cookg'ai koe tsééa úú, ncẽe gha síí Tsarim dàò ba kg'ónòa máá Tsi ba,’ ta mééèa ba. ");
INSERT INTO nhr_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tseegukar ko bìrí tu u, a ko máá: Eẽ khóè zi ka ábàèa hãa xu ka x'áísea hãa ba káà me e, Johanem tcguù-tcguu-kg'aom kam kaia hãa sa. Igaba gam ẽe nqarikg'ai di x'aian koe cg'áré ii ba gam ka kaia hãam ga me e. ");
INSERT INTO nhr_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Johanem tcguù-tcguu-kg'aom di cáḿan koe guu a ncẽem x'aèm koe hààs koe i kò nqarikg'ai di x'aian qarian cgoa qgóókua, ne ko qaris di ne khóè ne qarian cgoa séè e. ");
INSERT INTO nhr_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Porofiti xu wèé xu hẽé naka Moshem di x'áèan hẽéthẽéa kò ko porofita khama, me síí nxãakg'aiga Johane hàà. ");
INSERT INTO nhr_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","A ncẽes gúù sa tu kò dtcòm̀ kg'oana ne, gam Johane ba Elijam ga me e, ncẽe Nqarim kò nqòòkagu tua ba hààm gha sa. ");
INSERT INTO nhr_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eẽ tceean úúa hãa ba méém kóḿ. ");
INSERT INTO nhr_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Igaba Ra gha kháé ncẽem x'aèm dis qhàò sa dùús cgoa nxárá xg'ae? Kg'amaga i cg'áré cóán khama ii, ncẽe gúùan ko x'ámáguè qgáì koe hãa a ko tciiku u, a ko máá: ");
INSERT INTO nhr_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Fulutuan ta kò ciia máá tu u, tu kò táá ntcãà, ta kò gataga x'ooan di ciian nxáè, tu kò táá kg'ae,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johanem ko hàà kam kò tc'õó tama kana kg'áà tama, ne kò máá: ‘Dxãwa tc'ẽea nem úúa,’ témé khama. ");
INSERT INTO nhr_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Igabam kò Khóèm dim Cóá ba hàà, a ko tc'õó a ba a ko kg'áà, ne kò máá: ‘Bóò, tc'õó-kg'aom ncẽe ba, a kg'áà-kg'aom gõéan di ba, mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé dim tcárà ba,’ ta méé. Igaba i ko q'ãan di tc'ẽean gaan di kúrúse-kg'áḿan ka tchàno o sa x'áíse.” ");
INSERT INTO nhr_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Me Jeso ba nxãaska tshoa-tshoa a ba a x'áé-dxoo xu, ncẽe káí-kg'aise zi Gam di zi x'áí zi are-aresa zi gaxu koe kúrúsea xu dqàè, táá xu kò gaxu di chìbian koe tcóóse khama, a ba a máá: ");
INSERT INTO nhr_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Haò, cg'ãè i gha ii tsáá ka Korasineè! Cg'ãè i gha ii tsáá ka Betesaidaè! Are-aresa zi x'áí zi ncẽe ko gatsao koe kúrúsea zi kò Ture hẽé naka Sitone hẽéthẽé koe kúrúsea hãa ne ne ga kò ncìíse gane di chìbian koe tcóósea, a saka di qgáían hã̱a, a tháúan tcgáùsea. ");
INSERT INTO nhr_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Igabar ko bìrí tsao o a ko máá: ‘Xgàrakuan dim cáḿ ka tsara gha Turea tsara Sitonea tsara subu xgàrakuan hòò gatsao dian ka,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A ncẽe tsáá ka, Kaperenaume tseè! Ncẽè x'áí zi are-aresa zi tsáá koe kúrúsea zi kò Sodomam koe kúrúsea nem ga ko ncẽeska qanega hàna. Gaa domka tsi gha kaisase nqãaka xòóè, x'óóa ne khóè ne dim qgáìm koe, nqarikg'ai koe tsi gha ghùi a úúè, ta tsi tc'ẽea igaba. ");
INSERT INTO nhr_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Igabar kò bìrí tsi a ko máá: Xgàrakuan dim cáḿ kam gha Sodoma ba subu xgàrakuan hòò tsarian ka, témé,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Eẽm x'aèm kam kò Jeso ba nxàe a máá: “Dqo̱m̀ Tsir ko, Aboè, X'aiga Tsi, nqarikg'ai hẽé naka nqõómkg'ai hẽéthẽé di Tsi, ncẽe zi gúù zi Tsi kò tc'ẽega ne hẽé naka xgaa-xgaasea hãa ne hẽéthẽé chóm̀-kg'aia hãa, a Tsi a kò ẽe cg'áré ne xgaa-xgaase tama ne x'áí zia hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Eè, Aboè, ncẽea Tsi kò ma ncàm̀a hãa ga a khama. ");
INSERT INTO nhr_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Wèé zi gúù zi Ra Tirim Abom ka máàèa, i cúí khóè ga Cóá ba c'úùa, Xõòm oose, i cúí khóè ga Xõò ba c'úùa hãa, Cóásem oose, naka wèém ẽe Cóám ka nxárá tcg'òóèa ba hẽéthẽé e, gaam koem gha Cóá ba Xõò ba x'áí ka ba. ");
INSERT INTO nhr_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Hàà tu Tíí koe gatu wèé tu ẽe xhõea a ko tààè tu, sãakagu tu ur gha ke. ");
INSERT INTO nhr_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Séè tu Tiris joko sa naka gatu ka xgàm, naka tua Tíí koe xgaa-xgaase. Tíí Ra kgàea hãa a ko cg'áré-cg'arese, a Ra a tcáóa Te koe tc'aua, tu gha nxãaska sãa-q'ooan hòò gatu di i. ");
INSERT INTO nhr_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Tiris joko sa xhóà-xhóà si i, si xgàms Tiri sa subu si i khama.” ");
INSERT INTO nhr_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Eẽm x'aèm kam kò Jeso ba maberean dim xháràm q'oo koe ko Sabata dim cáḿ ka qõò. Gam di xu xgaa-xgaase-kg'ao xu kò xàbà hãa ka xu kò nxãaska tshoa-tshoa a maberean tc'áró khõá a tc'õó. ");
INSERT INTO nhr_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Igaba ẽe xu ko Farasai xu ẽe sa bóò, ka xu kò bìrí Me a máá: “Bóò! Tsari xu xgaa-xgaase-kg'ao xu ko Sabata dim cáḿ ka x'áèan koe kgoara mááè tama sa kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Igabam kò Jeso ba bìrí xu a máá: “Qanega xao gáé nxárá ta ga hãa Dafitem xg'ao kúrú sa, gabá hẽé naka gam ka c'ẽea xu hẽéthẽé kò xàbà hãa ka? ");
INSERT INTO nhr_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Nqarim dim nquum koem kò ma tcãà, a ba a gam ka c'ẽea xu cgoa ts'ee-ts'eekg'aièa péréan tc'õó, ncẽe peresiti xu ka cúí ko tc'õóè e, gabá hẽé naka ẽem kò hãa cgoa xu hẽéthẽé kò tc'õóan gaan di kgoara mááè tama a. ");
INSERT INTO nhr_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kana xaoa qanega Moshem di x'áèan koe nxárá ta ga hãa, Sabata dim cáḿ ka xu kò peresiti xu tempelem q'oo koe Sabata dim cáḿ ba táá tcom, igaba xu kò táá chìbi-chibiè sa. ");
INSERT INTO nhr_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bìrí xao or ko a ko máá: C'ẽes gúùs tempelem ka kaia sa ncẽe koe hàna, témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Nqarim di kg'uia ne ko máá: ‘Thõò-xama-máákua ner ko qaa, dàòa-máákuan ka tamase,’ témé. Ncẽè tseegukaga xao kò q'ana ncẽes gúùs ko nxàe sa ne xao ga kò khóè ne ncẽe chìbi úú tama ne, chìbi-chibi naka xgàra tama. ");
INSERT INTO nhr_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Khóèm dim Cóá ba Sabata dim cáḿ dim X'aiga Me e khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Eẽm qgáìm koem kò guu a gane dim còrè-nquum koe síí tcãà. ");
INSERT INTO nhr_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gaa x'aè kagam kò nqo̱ara tshàua hãam khóè ba gaa koe hàna. C'ẽe xu khóè xu kò hàna a xu a ko dàòan qaa, Jeso ba xu gha chìbi-chibi di i, khama xu kò tẽè Me, a máá: “A x'áèan koe i kgoaraèa Sabata dim cáḿ ka khóèan qãèkagua ne?” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Me bìrí xu a máá: “Kháé ncẽè gaxao ka c'ẽem kò cúís ghùu sa úúa, si Sabata dim cáḿ ka ha̱ém q'oo koe cg'áéa tcãà ne, a cuiskaga baa qgóó si naka tcg'òó sia hãa tite? ");
INSERT INTO nhr_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nta noose ba khóè ba ghùuan koe cgáé baa! Gaa domka i x'áèan koe kgoaraèa Sabata dim cáḿ ka qãèan kúrúa ne,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A ba a nxãaska gaam khóè ba bìrí a máá: “Tchoanà tshàua tsi,” témé. Me khóè ba tchoanà a, i tshàua ba ka̱bise a qãèa xg'ara a c'ẽean khamaga ii. ");
INSERT INTO nhr_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Igaba xu kò Farasai xu tcg'oa, a xu a kàan qaa, ntama xu gha ma Jeso ba cg'õo di i. ");
INSERT INTO nhr_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eẽm ko Jeso ba bóòa q'ãa kàa nem ko kúrúa mááè sa kagam kò ẽem hànam qgáì ba tcg'oara guu. Zi káí zi xg'ae zi xùri Me, Me wèéa ne kg'õèkagu. ");
INSERT INTO nhr_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","A ba a q'ãa-q'ãa ne, táá ne gha c'ẽe ne bìrí, dìí Me e sa ka. ");
INSERT INTO nhr_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ncẽes gúù sam kò kúrú, porofitim Isaiam kò kg'uia gúùan gha nxãasega hàà tseegukaguè ka, ncẽem kòo máá: ");
INSERT INTO nhr_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Bóò, Ncẽea tirim Qãàm ga Me e, nxárár tcg'òóa hãa ba, ncẽer ncàm̀a ba, ncẽe Gam kar ko qãè-tcao ba. Tirim Tc'ẽe bar gha Gam koe tòó, Me gha tchànoan ka nqõóm di zi qhàò zi bìrí. ");
INSERT INTO nhr_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Khóèan cgoam mẽékua hãa tite kana q'aua hãa tite, i cúí khóè ga dòm̀a ba dàòan q'oo koe kóḿa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Na̱iseam tc'áà bam khõá tite, a ba a x'óó kg'oanam lampi dqùi ba ts'íría hãa tite, a ba a gha tchànoan tcg'òó tcúúkagu. ");
INSERT INTO nhr_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Gam dim cg'õèm koe zi gha nqõóm di zi qhàò zi gazi di nqòòan tòó,” témé ka. ");
INSERT INTO nhr_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nxãaska ne kò khóè ne dxãwa tc'ẽean ka tcãàèam khóè ba Gam koe óá, ncẽe kò bóò tama a kg'ui tama ba, Me kò Jeso ba qãèkagu me, me kg'ui a bóò. ");
INSERT INTO nhr_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Zi kò wèé zi xg'ae zi area, a zi a máá: “A ncẽe ba Dafitem ka Tsgõose-coam gabàa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Igaba ẽe xu ko Farasai xu ncẽes gúù sa kóḿ ka xu kò máá: “Ncẽem khóè ba ko Belesebulem ncẽe dxãwa tc'ẽean dim tc'ãà-cookg'aim di qarian cgoa cúí ga dxãwa tc'ẽean xhàiagu!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Igabam kò Jeso ba gaxu di tc'ẽean q'ana khamam kò bìrí xu a máá: “Wèés x'ais ẽe q'aara hãa sa gha kaà, i gha x'áé-dxooan kana nquuan ẽe q'aa-q'aasea hãa a, táá gaicara hãa. ");
INSERT INTO nhr_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","A ncẽè satanam kò satana ba xhàiagu, nem gaam igaba q'aara. Ntama i gha kháé nxãaska gam di x'aian hãa? ");
INSERT INTO nhr_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A ncẽè tíí kòo Belesebulem di qarian cgoa dxãwa tc'ẽean xhàiagu, ne ia ko gaxao di khóèan dìím cgoa xhàiagu u? Gaa domkaga ne gha gaxao di ne khóè ne chìbi-chibi xao o a ẽe xao ko kg'ui sa tseegu tama sa x'áí xao o. ");
INSERT INTO nhr_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Igaba ncẽè Tíí kò ko dxãwa tc'ẽean Nqarim dim Tc'ẽem cgoa xhàiagu, nes ko nxãa sa Nqarim di x'aia ne gatu koe hààraa sa x'áí. ");
INSERT INTO nhr_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ka ba gha khóè ba ntama ma qarim khóèm dim nquum koe tcãà, a gam di zi gúù zi ts'ãà, kg'aia méém ẽem khóèm qari ba qáéa ntcòo. Nxãaska cúígam gha nquua ba q'oo koe tcãà a gam di zi gúù zi ts'ãà. ");
INSERT INTO nhr_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Gaam ẽem Tíí cgoa hãa tama ba q'aumana Tea, me gaam ẽem Tíí cgoa xg'ae-xg'ae tama ba ko tsa̱i-tsa̱i. ");
INSERT INTO nhr_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Khama Ra ko bìrí tu u a ko máá: Khóè ne gha wèés chìbi sa hẽé naka wèés cg'ãès gúùs Nqarim ka ne ko kg'uis ka hẽéthẽé qgóóa mááè, igaba ne cuiskaga cg'ãès gúùs Tc'ẽem ka ne ko kg'uis ka qgóóa mááè tite. ");
INSERT INTO nhr_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Me wèém khóèm ẽe ko Khóèm dim Cóám ka cg'ãèse kg'ui ba gha qgóóa mááè, igaba wèém khóèm ẽe gha Tcom-tcomsam Tc'ẽem ka cg'ãèse kg'ui ba qgóóa mááè tite, ncẽem x'aèm koe igaba kana hààkom x'aèm koe ga igaba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Qãès hìi sa tsi kò úúa ne tsi gha qãè tc'áróan hòò, a tshúùs hìi sa úúa ne gha tshúù tc'áróan hòò. Hìi sa ko gas di tc'áróan ka xám̀a q'ãaè khama. ");
INSERT INTO nhr_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Cg'aoan di tu cóá tuè, ncẽè cg'ãè cau tu kò ii ne tu gha ntama qãè zi gúù zi nxàe? Dùús wèés ẽe tcáós koe cg'oèa hãa sas ko kg'áḿ sa nxàea tcg'òó ka. ");
INSERT INTO nhr_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Qãèm khóè ba ko gam di qãèan koe guu a qãè zi gúù zi tcg'òó, me ko cg'ãè caum khóè ba gam di cg'ãè cauan koe guu a cg'ãè zi gúù zi tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Igabar ko bìrí tu u a ko máá: Xgàrakuan dim cáḿ ka ne gha khóè ne cg'ãèm kg'uim wèém ẽe ne kò kg'uia hãam ka xo̱ara mááse. ");
INSERT INTO nhr_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tsari kg'uian ka tsi gha tchàno iise bóòè, a tsi a gha tsari kg'uian ka chìbi-chibi a xgàraè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Xu kò nxãaska c'ẽe xu x'áè xgaa-xgaa-kg'ao xu hẽé naka Farasai xu hẽéthẽé xu bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, are-aresas x'áí sa xae Tsáá koe bóò kg'oana,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Igabam kò xo̱a xu a máá: “Qhàòs ncẽe cg'ãè cau a cg'árà di sa ko are-aresas x'áí sa qaa. Igabas cúís x'áís ga sa x'áíèa hãa tite, porofitim Jonam dis x'áís cúís oose. ");
INSERT INTO nhr_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Eẽm xg'ao ma Jona ma nqoana cáḿan hẽé naka nqoana ntcùúan hẽéthẽé kaiam x'aùm ncãà q'oo koe hãa khamagam gha gataga Khóèm dim Cóá ba nqoana cáḿan hẽé naka nqoana ntcùúan hẽéthẽé nqõóm ka nqãaka hãa. ");
INSERT INTO nhr_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Xgàrakuan dim cáḿ ka xu gha khóè xu Ninefe di xu tẽe a téé, a gha ncẽes qhàò sa chìbi-chibi. Jonam di xgaa-xgaan koe xu kò guu a gaxu di chìbian koe tcóóse khama. Me ncẽeska Jonam ka kaia ba ncẽe koe hàna. ");
INSERT INTO nhr_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","X'aigas Sheba di sa gha xgàrakuan dim cáḿ ka tẽe a téé, a ncẽes qhàò sa chìbi-chibi, nqõóm chõò-q'oo koes kò guu a ko hàà Solomonem di tc'ẽegan komsana khama. Igaba bóò, Solomonem ka kaia ba ncẽeska ncẽe koe hàna. ");
INSERT INTO nhr_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Eẽ i ko dxãwa tc'ẽean khóèm koe tcg'oa, ne i ko c'óòa qgáìan koe qõò, a síí sãa i gha qgáìan qaa, a ncẽè hòò o tama i kò hãa ne ");
INSERT INTO nhr_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i ko nxãaska bìríse a máá: ‘Tirim nquum ẽer guua hãam koer gha ka̱bise,’ témé, a ẽe i kò hàà nquu ba bóò me káà gúù ii, a xgàia q'ano-q'anoèa, a qãèse kg'ónòèa, ");
INSERT INTO nhr_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ne i ko nxãaska qõò a síí 7 tc'ẽean séè ncẽe gaan nqáéase cg'ãè tc'ẽe e a hàà cgoa, i hàà tcãà a ia a gaa koe x'ãè. Si ẽem khóèm dis téé-q'oo sa hàà kaisase cg'ãè kg'aiaka dis ka. Ncẽeta ga i gha qhàòs ncẽe cg'ãè caus ka ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eẽm Jeso ba qanega hãa a ko xg'aes cgoa kg'ui, ka ne kò xõò sa hẽé naka qõese ga xu hẽéthẽé ne tchàa za hàà téé, a ko dtcàrà kg'ui cgoa Me ne gha sa. ");
INSERT INTO nhr_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","C'ẽem khóè ba kò bìrí Me a máá: “Bóò, saò sa hẽé naka Tsáá qõe ga xu hẽéthẽéa tchàa za tẽe, a ko dtcàrà kg'ui cgoa Tsi ne gha sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Igabam kò xo̱a me a máá: “Dìí sa tiris xõò sa, i dìín Tíí qõea?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","A ba a Gam di ne xgaa-xgaase-kg'ao ne nxáá a máá: “Bóò, ncẽea Tiris xõòs ga si i, a Tíí qõe ga ne ne e. ");
INSERT INTO nhr_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wèém khóèm ẽe ko Tirim Xõòm nqarikg'ai koe hànam ko tc'ẽe sa kúrú ba Tíí qõem ga me e, a Tíí qões ga si i, a gataga Tiris xõòs ga si i khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Eẽm cáḿ kagam kò Jeso ba nquum q'oo koe tcg'oa, a ba a síí tshàam-kg'áḿ koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Káí ne khóè ne kò hàà cgae Me, khamam nxãaska dxòrom q'oo koe tcãà a gaa koe ntcõó, si wèés xg'ae sa tshàam-kg'áḿ koe téé. ");
INSERT INTO nhr_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kam ko káí zi gúù zi sere-sere zi cgoa bìrí ne a máá: “Bóò, c'ẽe x'aè kam kò xhárà-kg'ao ba qõò a síí xhárà. ");
INSERT INTO nhr_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","A ẽem kò xhárà ka i kò c'ẽe cgùrian dàòm qàe koe tcheè, zi tsa̱rá zi hàà tc'õó o. ");
INSERT INTO nhr_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","I c'ẽe cgùrian nxõ̱á-kg'ai di qgáìan koe tcheè, ncẽe káí góḿan kò káà a koe. I kò kúúga qháése tso̱m, góḿa ne kò kaisa tama khama. ");
INSERT INTO nhr_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Igaba ẽes ko cáḿ sa qaò ka i kò gaa tso̱man dào. A i a kò to̱be ga i kò úú tama khama nqa̱i. ");
INSERT INTO nhr_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","I c'ẽe cgùrian dxàman hàna qgáì koe tcheè, i dxàman kai, a chúú-chuu u. ");
INSERT INTO nhr_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","I c'ẽe cgùrian qãè góḿan koe tcheè, a i a tc'õoan kúrú, i c'ẽean 100 q'oro kúrúse, i c'ẽean 60 q'oro kúrúse, i c'ẽean 30 q'oro kúrúse. ");
INSERT INTO nhr_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Eẽ tceean úúa hãa ba méém kóḿ,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Xu kò nxãaska xgaa-xgaase-kg'ao xu hàà, a tẽè Me a máá: “Dùús domka Tsi ko sere-sere zi cgoa kg'ui cgoa ne?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Me xo̱a xu a máá: “Gaxaoa máàèa, chóm̀sea zi kàa zi nqarikg'ai di x'aian di zi xao gha q'ãa sa, igaba ne gane máàè e tama. ");
INSERT INTO nhr_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wèém khóèm ẽe úúa hãa ba gha káían máàè, a ba a gha kaian úú khama. Igaba wèém ẽe gúù úú tama ba, ẽem úúa hãa gúù-coan gam gha séè cgaeè. ");
INSERT INTO nhr_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gaa gúù domkagar ko sere-sere zi cgoa kg'ui cgoa ne, bóòan kaga ne bóò tama, a ne a kóḿan kaga kóḿ tama, a kóḿa q'ãa ga hẽé tama khama. ");
INSERT INTO nhr_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","“Gatà iis gúùs ka i kò Isaiam di porofitan gane koe tseegukaguè, ncẽem kò Nqari ba máá: ‘Kóḿ tu gha, igaba tu kóḿa q'ãa tite, a tu a gha bóò, igaba tu bóòa q'ãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ncẽe ne khóè ne di tcáóa nea c'óòa hãa, i ko gane di tceean tshúù-xamse kóḿ, ne tcgáía ne tcẽekg'ama khama, nxãasega ne gha táá tcgáía ne cgoa bóò, a táá tceea ne cgoa kóḿ, a táá tcáóa ne cgoa kóḿa q'ãa, a ne a táá Tíí koe ka̱bise, Ra qãèkagu ne ka,’ ta ko méé e. ");
INSERT INTO nhr_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Igaba i gaxao di tcgáían ts'ee-ts'eekg'aièa, bóò i ko khama, naka tceea xao ga hẽéthẽéa ts'ee-ts'eekg'aièa, kóḿ i ko khama. ");
INSERT INTO nhr_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tseegukar ko bìrí xao o a ko máá: Káí porofitian hẽé naka tchàno khóèan hẽéthẽéa kò bóò kg'oana, ẽe xao ko gaxao bóò sa, igaba i kò táá bóò si, a kò kóḿ kg'oana ẽe xao ko gaxao kóḿ sa, igaba i kò táá kóḿ si. ");
INSERT INTO nhr_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Ke xao nxãaska komsana xhárà-kg'aom dis sere-sere sa. ");
INSERT INTO nhr_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Gane ẽe x'aian dim kg'ui ba ko kóḿ, igaba kóḿa q'ãa me tama nea dàòm qàe koe xháràèa cgùrian khama ii ne ne e. Gaam cg'ãèm ncẽe dxãwa ii ba ko hàà a hàà gane tcáó koe xháràèa sa ntcàua tcg'òó ne. ");
INSERT INTO nhr_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","A ncẽe nxõ̱án hàna qgáì koe xháràèa nea: ẽe kg'ui ba ko kóḿ ne ko kúúga qãè-tcaoan cgoa hààkagu me ne e, ");
INSERT INTO nhr_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","igaba ne káà to̱be ne e, a ko xòm̀ x'aè séè a hãa. A ẽe i ko kg'uim domka xháéa ne kana xgàrakuan hàà nem ko qháésega cg'áé. ");
INSERT INTO nhr_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Cgùrian ẽe dxàman koe tcheèa nea kg'ui ba kóḿam khóè me e, igaba tc'ẽe-tc'ẽese zi ncẽes kg'õès di zi hẽé, naka qguù sa ncàm̀an hẽéthẽéa kò kg'ui ba xgáè-kg'am, me táá tc'áróan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Igaba ẽe qãè góḿan koe xháràèa cgùria nea, kg'ui ba ko kóḿ a kóḿa q'ãa mem ga me e. Tc'áróa nem ko kúrú, 100 q'oro, kana 60 q'oro, kana 30 q'oro ẽe ko xháràèa cgùrian ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jeso ba ko gaicara c'ẽes sere-sere sa bìrí ne a máá: “Nqarikg'ai di x'aia nea khóèm gam dim xháràm koe qãè cgùrian xháràm khama ii. ");
INSERT INTO nhr_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Igaba ẽe i wèé khóèan x'óm̀a hãa kam kò gam dim cg'õo-kg'ao ba hàà, a hàà gam di maberean xg'aeku koe tc'ẽese tama tso̱man xhárà, a ba a qõò. ");
INSERT INTO nhr_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","“Eẽ i ko maberean kai, a ko tc'áróan kúrú ka i ko tc'ẽese tama tso̱man qhúí thẽé. ");
INSERT INTO nhr_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xu qãà xu xháràm koe ko tséé xu hàà q'õò mea ba bìrí a máá: ‘X'aigaè, a tsarim xháràm koe tsi gáé kò qãè cgùrian xhárà hãa tama? Kháé tc'ẽese tama tso̱ma nea nxãaska nda guua?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Me xo̱a xu a máá: ‘Tiri cg'õo-kg'aoa nea ncẽe gúùan kúrúa,’ témé. Xu qãà xu tẽè me a máá: ‘Kháé tsi ko tc'ẽe, síí méé xae tshõé e sa?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Me xo̱a a máá: ‘Eẽ-ẽe, tc'ẽese tama tso̱man xao kòo tshõé ne xao gha maberean di to̱bean cgoa xg'ae-xg'ae a q'óè e. ");
INSERT INTO nhr_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ke guu u naka i xg'ae naka kai, naka i nxãakg'aiga síí khõá di x'aèan hàà. Eẽ x'aè kar gha khõá-kg'ao xu bìrí a máá: ‘Tc'ẽese tama tso̱man méé xao kg'aia tshõe naka qáé xg'ae, naka i síí dàòè, naka xao nxãaska maberean khõá naka tòóa mááse nquum tirim koe óága,’ témé,’” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","C'ẽes sere-sere sam kò gaicara bìrí ne a máá: “Nqarikg'ai di x'aia nea mosetara dis hìis dim cgùrim khama ii, ncẽe khóèm kò séè a gam dim xháràm koe xhárà ba. ");
INSERT INTO nhr_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Wèé xu cgùri xu kam cg'áré me e, igaba ẽem kò tso̱m nem wèé hìian xháràm di ka kaiam ga me e, a ba a ko hìi sa kúrú, i gha nqarikg'ai di tsa̱rán hàà gas di nxã̱an koe nquuan kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Gatagam kò c'ẽes sere-sere sa bìrí ne a máá: “Nqarikg'ai di x'ai ne péré gãé-gãean khama ii, ncẽes ko dxàes khóè sa séè a káí péréan cgoa xg'ae-xg'ae e, i wèés pérés koe tséé, si gãe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jeso ba kò wèé gúùan ncẽe ga sere-serean cgoa xg'ae zi bìrí. Táám kò cúí gúù ga gazi cgoa kg'ui, sere-serean tséékagu tamase. ");
INSERT INTO nhr_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ncẽe gúùa nem kò kúrú, porofitim kg'uia gúùan gha hàà nxãasega tseegukaguè ka, ncẽem kòo máá: “Sere-sere zi cgoar gha kg'áḿa Te xgobekg'am, a gha nqõóm dis tshoa-tshoas koe guu a chóm̀sea zi gúù zi bìrí ne,” témé ka. ");
INSERT INTO nhr_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jeso ba kò nxãaska xg'ae zi guu a ba a nquum q'oo koe tcãà. Xu Gam di xu xgaa-xgaase-kg'ao xu hàà cgae Me a máá: “Bìría tchàno-tchano xae e xháràm koe tc'ẽese tama tso̱man dis sere-seres ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Me xo̱a xu a máá: “Gaam ẽem qãè cgùrian xhárà baa Khóèm dim Cóá Me e, ");
INSERT INTO nhr_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","me xhárà ba nqõó me e, i qãè cgùrian khóè ne e nqarikg'ai di x'aian di ne, i tc'ẽese tama tso̱man nxãaska khóè ne e ẽe cg'ãèm di ne ncẽe dxãwa ii ba. ");
INSERT INTO nhr_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Me cg'õo-kg'aom ẽe xhárà ana ba dxãwa me e, i khõán di x'aèan kurian chõò-q'oo o, xu khõá-kg'ao xu moengele xu u. ");
INSERT INTO nhr_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ncẽe ẽe i ko ma tc'ẽese tama tso̱man q'óèa tcg'òóè a ko ma dàòè khamaga i gha kurian chõò-q'oo koe ii: ");
INSERT INTO nhr_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Khóèm dim Cóá ba gha Gam di xu moengele xu tsééa tcg'òó, xu gha wèé gúùan ẽe ko khóèan chìbian kúrúkaguan hẽé naka cg'ãèan ko kúrú khóèan hẽéthẽé Gam di x'aian koe q'óèa tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","A xu a gha c'eean dim ha̱ém q'oo koe xaoa tcãà ne, ncẽe kg'aean hẽé naka gãò xõ̱óan hẽéthẽé gha hàna koe. ");
INSERT INTO nhr_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nxãaska ne gha ẽe tchàno ne gane ka Xõòm di x'aian koe cáḿs khama ma x'áà. Gaam ẽe tceean úúa ba méém kóḿ.” ");
INSERT INTO nhr_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nqarikg'ai di x'aia nea qguùs xháràm koe chóm̀mèas khama ii, khóèm ko hòò nem ko gaicara chóm̀ sa, a ba a gam di qãè-tcaoan ka qõò a síí wèéan ẽem úúa ga x'ámágu, a ba a ẽem xhárà ba hàà x'ámá. ");
INSERT INTO nhr_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Gataga i gaicara nqarikg'ai di x'aian x'ámá-kg'aom khama ii, ncẽe tca̱àko zi nxõ̱á zi ko qaa ba, ncẽe kaisa marian ko tc'oà zi. ");
INSERT INTO nhr_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","A ẽem kò c'ẽes tca̱àkos nxõ̱ás kaisase káí marian ko tc'óà sa hòò, nem ko qõò a síí wèé gúùan ẽem úúa x'ámágu, a ba a hàà x'ámá si. ");
INSERT INTO nhr_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Gaicara i nqarikg'ai di x'aian c'uisís khama ii, ncẽe ko tshàan q'oo koe tcãàè sa, a wèé x'aù qhàòan qgóó. ");
INSERT INTO nhr_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A ẽe cg'oèas kò hãa ne xu ko x'aù qgóó-kg'ao xu tchàa koe tshàam-kg'áḿ koe tceea úú si, a xu a síí ntcõó a qãè x'aùan sáà tcãà gàba xu koe, a ẽe qãè taman aagu. ");
INSERT INTO nhr_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ncẽeta ga i gha hàà ii kurian chõò-q'oo koe. Moengele xu gha hàà a ẽe tchàno tama ne ẽe tchàno ne xg'aeku koe tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","A xu a gha c'eean dim ha̱ém q'oo koe xaoa tcãà ne, ncẽe kg'aean hẽé naka gãò xõ̱óan hẽéthẽé gha hàna koe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Me Jeso tẽè xu a máá: “Ncãa xao wèé gúùan ncẽe kóḿa q'ãa?” témé. Xu xo̱a Me a máá: “Eè” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Me bìrí xu a máá: “Gaa domkam wèém x'áè xgaa-xgaa-kg'ao ba, ncẽe nqarikg'aian di x'aian ka qãèse xgaa-xgaaèa ba, nquum ka q'õòsem khama ii, ncẽe ko gam di zi qguù zi ka̱ba zi hẽé naka ncìí zi hẽéthẽé gam dim nquum tòóa mááse dim koe tcg'òó, a gam di ne khóè ne máà ba. ");
INSERT INTO nhr_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Eẽm ko Jeso ba ncẽe zi sere-sere zi cgoa xg'ara, kam kò gaam qgáì ba tcg'oara guu. ");
INSERT INTO nhr_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Gam dim x'áé-dxoom koem ko hàà kam ko tshoa-tshoa a gane dim còrè-nquum koe khóè ne xgaa-xgaa, ne khóè ne kaisase are a máá: “Ncẽem khóè ba ncẽe tc'ẽean hẽé naka are-aresa zi qari zi hẽéthẽé nda hòòa? ");
INSERT INTO nhr_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","A ncẽe ba gáé hìi xom-kg'aom dim cóám tama baa? A gam ka xõòs di cg'õèa ne gáé Maria tama? A gataga gaam ka qõesea xu gáé Jakoboa xu, Josefaa xu, Simonea xu, Jutasea xu tama xua? ");
INSERT INTO nhr_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","A gam ka qõese ga zi wèé zia gáé gatá cgoa hãa tama? Kháé ba nxãaska ncẽem khóè ba ncẽe zi gúù zi wèé zi nda séèa?” ta ne ma tẽè. ");
INSERT INTO nhr_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ne bóòa xguì Me. Igabam kò Jeso ba bìrí ne a máá: “Porofiti ba wèé za ga tcommèam khóè me e, gam dim x'áé-dxoom koe hẽé naka gam di x'áéan koe hẽéthẽé cúí oose,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A ba a kò gaa koe táá káí zi are-aresa zi tséé zi kúrú, gane di dtcòm̀an úú tama domka. ");
INSERT INTO nhr_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Eẽm x'aèm kam kò x'aigam Galilea dim Herote ba Jesom ka kóḿ. ");
INSERT INTO nhr_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","A ba a gam di ne qãà ne bìrí a máá: “Ncẽe ba Johanem tcguù-tcguu-kg'ao me e. X'ooan koem tẽea! Gaa domka i ko ncẽe qarian are-aresa zi tséé zi di gam koe kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herote ba kò Johane ba qgóó a qáé, a qáé-nquus koe tcãà mea khama, Herotiases gam ka káíkhoem Filipim dis khóès domka. ");
INSERT INTO nhr_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Johane ba kò bìrí mea a máá: “X'áèan koe tsi kgoara mááè tama, séè si tsi ga kò hãa sa,” tam mééa khama. ");
INSERT INTO nhr_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Gaa domkam kò Herote ba cg'õo me kg'oana hãa, igabam kò khóè ne q'áò, Johane ba ne kòo porofitim iise séè khama. ");
INSERT INTO nhr_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Igaba Herotem di ábà x'aèan di cáḿan kas kò Herotiases ka cóáse sa ntcãà máá ne, a sa a Herote ba kaisase qãè-tcaokagu. ");
INSERT INTO nhr_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Me gaìses cgoa nqòòkagu si, dùús wèés ẽes ko dtcàrà sam gha máà si sa. ");
INSERT INTO nhr_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Xõòs kas kò qg'áìèa xg'ara khamas kò máá: “Johanem tcguù-tcguu-kg'aom dis tcúú sa gàbas q'oo koe máà te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Me x'aiga ba kaisase tshúù-tcao, igabam kò gaìsean ẽem kò kúrúa hãa hẽé naka cg'áè-khoe ne hẽéthẽé domka x'áè sa tcg'òó, máàè sis gha sa. ");
INSERT INTO nhr_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A ba a ncõo-kg'ao ba qáé-nquus koe tsééa úú, síím gha Johanem dis tcúú sa q'ãe ka. ");
INSERT INTO nhr_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Si kò gam dis tcúú sa gàbas koe óáè a hàà dxàe-coa sa máàè, si kò séè a xõòs koe úú si. ");
INSERT INTO nhr_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Xu gam di xu xgaa-xgaase-kg'ao xu hàà a hàà tc'áróa ba séè a síí kg'ónò. A xu a qõò a síí Jeso ba bìrí i. ");
INSERT INTO nhr_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Eẽm ko Jeso ba ncẽe sa kóḿ kam kò dxòrom cgoa tcg'oa a nqoo-nqoosam qgáìm koe qõò a síí cúíse hãa. Igaba ẽes ko xg'ae sa ncẽes gúù sa kóḿ ka ne ko x'áé-dxoo xu koe guu a nqàrè cgoa xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Eẽm ko Jeso ba tcg'oa kam kò kaias xg'ae sa bóò si ko xùri Me, Me thõò-xama máá ne a ba a gane di tcìì-khoean kg'õèkagu. ");
INSERT INTO nhr_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Dqòara i ko qõò ka xu kò xgaa-xgaase-kg'ao xu hàà cgae Me a máá: “Ncẽe ba cúía hãam qgáì me e, i ncãa gataga dqòa, ke khóè ne qõòa q'aakagu naka ne x'áéa ne koe dìbi, naka síí tc'õoan x'ámá mááse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Me Jeso ba xo̱a xu a máá: “Qaase tama ia qõò ne gha sa, gaxao c'ẽe gúùan máà ne naka ne tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xu bìrí Me a máá: “5 xu péré xu cúí xu xae úúa, naka cám̀ x'aù tsara hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Me máá: “Ncẽe koe óága a, Tíí koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","A ba a khóè ne bìrí ne dcãan-kg'ai koe ntcõó, Me 5 xu péré xu hẽé, naka cám̀ x'aù tsara hẽéthẽé séè, a nqarikg'ai koe ghùi-kg'ai, a ts'ee-ts'eekg'ai i, a péréan khõá q'aa. A ba a xgaa-xgaase-kg'ao xu máà, xu xgaa-xgaase-kg'ao xu khóè ne máà a. ");
INSERT INTO nhr_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ne kò wèéa ne ga tc'õó a ne a xg'ãà, xu xgaa-xgaase-kg'ao xu ẽe ncãa tc'õóa qaùèan ka 12 xu q'ore xu tcãà, xu cg'oè. ");
INSERT INTO nhr_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Eẽ kò tc'õóa hãa xu di xg'ae-q'ooa ne kò 5,000 khama noo xu khóè xu u, khóè zi hẽé naka cóán hẽéthẽé ko nxárá tcãàè tama ne. ");
INSERT INTO nhr_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Me nxãaska Jeso ba qháése xgaa-xgaase-kg'ao xu chùi, xu dxòrom q'oo koe tcãà, a c'ẽem xòèm tshàam dim koe Gam ka tc'ãà a qõò, Gam qanega qaù a ko khóè ne di zi xg'ae zi qõòa q'aakagu ka. ");
INSERT INTO nhr_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eẽm ko xg'ae zi qõòa q'aakagua xg'ara kam kò cúíse xàbìm koe q'ábà qaò, síím gha còrè ka. Eẽ i ko dqòa kam kò gaa koe cúíse hãa. ");
INSERT INTO nhr_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Igabam kò dxòro ba tshàan nqáè koe hãa, nqõóm ka nqúù ka, a ko tshàan di qhonèan ka ntcãa-ntcãaè, tc'ãá ba xu kò q'óá-kg'ama khama. ");
INSERT INTO nhr_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Me Jeso ba q'uu-kg'ai-q'oo ka hàà cgae xu, tshàam tc'amkg'ai koe náà qõò a. ");
INSERT INTO nhr_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Igaba ẽe xu ko xgaa-xgaase-kg'ao xu bóò Mem ko tshàam tc'amkg'ai koe náà qõò ka xu kò kaisase q'ae, a máá: “Dca̱usoma me e!” témé, a xu a q'áòan ka q'au. ");
INSERT INTO nhr_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Igabam kò Jeso ba qháése kg'ui cgoa xu a máá: “Tíí Ra a ke xao tòón tcáó! Táá q'áò guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Me Petere xo̱a Me a máá: “X'aiga Tsi Nqari Tseè, Tsáá ga Tsi kò ii ne, bìrí te nakar tshàam tc'amkg'ai koe síí cgae Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Me máá: “Hàà,” témé. Me kò nxãaska Petere ba dxòrom koe xõa, a ba a tshàam tc'amkg'ai koe qõò a Jesom koe síí. ");
INSERT INTO nhr_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Igaba ẽem ko tc'ãá ba bóò kam kò q'áò, a ba a tshoa-tshoa a tshàan ka tóm̀mè, kam ko q'au a máá: “X'aigaè, hùi te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Me Jeso ba tshàua ba qháése tchoanà a qgóó me, a bìrí me a máá: “Tsáá ncẽe cg'áré dtcòm̀an di tsi, dùús domka tsi kò káíse tc'ẽe-tc'ẽesea máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Eẽ tsara ko dxòrom koe q'ábà kam kò gam tc'ãá ba téé. ");
INSERT INTO nhr_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Xu nxãaska ẽe kò dxòrom koe hàna xu dqo̱m̀ Me a máá: “Tseeguan kaga Tsi Nqarim di Tsi Cóá Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eẽ xu ko tshàa ba tchoaba ka xu kò Genesarete dim nqõóm koe hàà. ");
INSERT INTO nhr_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Eẽm nqõóm di xu khóè xu ko Jeso ba bóòa q'ãa ka ne kò kg'uian tsééa úú gaam nqõó ba nxa̱ma-nxa̱ma hãa xu nqõó xu koe, ne wèé ne khóè ne gane di tcìì-khoean Gam koe óága, ");
INSERT INTO nhr_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","a ne a dtcàrà Me, kg'amaga ne gha Gam dim qgáím xgáḿ-kg'am qgóó sa. Ne kò wèéa ne ẽe ko qgóó Me ne kg'õèkaguè. ");
INSERT INTO nhr_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Xu nxãaska Farasai xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé Jerusalema koe guu a Jeso ba hàà cgae, a hàà tẽè Me a máá: ");
INSERT INTO nhr_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Dùús domka xu ko Tsari xu xgaa-xgaase-kg'ao xu ncìí kuri di cauan kaia ne khóè ne di ntcoea máá? Eẽ xu ko tc'õós cookg'ai koe xu xg'aà tshàu tama ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Me Jeso ba xo̱a xu a máá: “Dùús domka xao ko gaxao igaba gaxao di cauan tc'ãà-tc'ãa a Nqarim di x'áèan ntcoea máá? ");
INSERT INTO nhr_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nqari ba ko máá: ‘Tcom méé tsi saò ba hẽé naka saò sa hẽéthẽé e,’ a ko gataga máá: ‘Wèém ẽe ko xõòm ka kana xõòs ka cg'ãèse kg'ui ba gha cg'õoè,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Igaba xao ko gaxao máá: ‘Khóèm kò ko xõò ba kana xõò sa bìrí a máá: ‘Eẽr ga ko hùi cgoa tsia sa, nxãa sa Nqari bar nqòòkagua hãas máàku si i khamar ko hùia tsi ka tààè,’ témé ");
INSERT INTO nhr_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ne i qaase tama xõò bam gha tcom sa,’ ta xao mééa, a xao a ncẽem dàòm ka gaxao di cauan cgoa Nqarim dim kg'ui ba káà-hùikagua hãa. ");
INSERT INTO nhr_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gaxao qãè khóèan khama ko ma kúrúse xaoè, tseegusem kò ko Isaia porofita gaxao ka, ncẽem kò ko Nqarim kg'uia hãa sa nxàe ka a ko máá: ");
INSERT INTO nhr_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ncẽe ne khóè ne ko kg'áḿa ne cgoa tcom Te, igabaga i gane di tcáóan Tíí koe nqúù u, ");
INSERT INTO nhr_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","a ne a ko káà hùise dqo̱m̀ Te. Gane di zi xgaa-xgaa zia x'áè-kg'áḿ zi khóè ne di zi i khama,’ témé ka,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A ba a khóè ne Gam koe tciia óá a bìrí ne a máá: “Komsana naka tua kóḿa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Eẽ ko kg'áḿs koe tcãà sa khóè ba cg'uri-cg'uri tama, igaba ẽe ko khóèm kg'áḿ koe tcg'oa sa ko khóè ba cg'uri-cg'uris ga si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xu nxãaska xgaa-xgaase-kg'ao xu hàà cgae Me a bìrí Me a máá: “A q'ana Tsia, Farasai xua kò xg'aìa hãa sa, ncẽes gúù sa xu kò kóḿ ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Me xo̱a xu a máá: “Wèém hìim Tirim Xõòm nqarikg'ai dim xhárà tama ba gha q'óèa tcg'òóè to̱bea ba cgoa. ");
INSERT INTO nhr_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Guu xu! Káà-tcgáí xu tcéè-tcuì-kg'ao xu u, káà-tcgáí ne khóè ne di xu ke. Káà-tcgáím khóèm kò c'ẽem khóèm káà-tcgáí ba tcéè-tcuì ne tsara gha wèéa tsara ga ha̱ém q'oo koe cg'áéa tcãà,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Me Petere xo̱a Me a máá: “Ncẽes sere-seres ka bìría tchàno-tchano xae e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A ba a máá: “Qanega xao gáé kóḿa q'ãa tama? ");
INSERT INTO nhr_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Bóò tama xao gáé hãa, dùús wèés ẽe ko kg'áḿs koe tcãà sa ko ncãàs koe qõò, a sa a síí tc'áróm koe tcg'oa sa? ");
INSERT INTO nhr_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Igaba ẽe kg'áḿs koe guu a tcg'oara hãa sa tcáós koe guua, si ko nxãa sa khóè ba cg'uri-cg'uri. ");
INSERT INTO nhr_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tcáós koe i ko cg'ãè tc'ẽean guu a tcg'oa khama, cg'õokuan hẽé, cg'áràn hẽé, xóé cgoakuan hẽé, ts'ãàn hẽé, tshúù-ntcõakagukuan hẽé, naka cóèkuan hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ncẽea gazi gúù zi khóè ba ko cg'uri-cg'uri zi zi i, igaba cg'uriga tshàuan cgoa tc'õó sa khóè ba cg'uri-cg'uri tama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Eẽm qgáìm koem ko Jeso ba guu kam kò Ture hẽé naka Sitone hẽéthẽé dim nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kas kò gaa x'aè kaga Kanana dis khóès gaam xg'aekum di sa hàà cgae Me, a sa a q'au a máá: “X'aiga Tsi Nqari Tseè, Dafitem ka tsgõose-coa Tseè, thõò-xama máá te, tiris cóá sa ko kaisase dxãwa tc'ẽean ka xgáèè ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Me Jeso ba táá c'ẽem kg'uim ga ba xo̱a si. Xu Gam di xu xgaa-xgaase-kg'ao xu hàà dtcàrà Me, a máá: “Bìrí si nakas qõò, q'auas ko xùri xae e ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Me xo̱a a máá: “Iseraele di ne khóè ne ncẽe ho̱àra ghùuan khama ii ne koe cúíga Ra tsééa óáèa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Si khóè sa hàà, a cookg'aia ba koe qúrùa sa cgoa qo̱m̀ a máá: “X'aigaè, hùi te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Me xo̱a si a máá: “Qãè tama ia cóán di péréan gha séè a ha̱ghuan xaoa mááè sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Si máá: “Eè X'aigaè, igaba i ko ha̱ghuan igaba qàmà-coa zi péréan di zi q'õòsean di tafolean koe ko guu a tcheè zi tc'õó na,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Me nxãaska Jeso ba xo̱a si a máá: “Khóè seè, kaisa dtcòm̀an si úúa! Eẽ si ko ma tc'ẽe khamaga ma méé i kúrúse,” témé. Si kò gas dis cóá sa gaam x'aèm ẽem kaga qãè. ");
INSERT INTO nhr_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Me Jeso ba ẽe koe guu a Galilea dim tshàam qàe koe síí, a ba a xàbì ba q'ábà qaò a síí ntcõó gaa koe. ");
INSERT INTO nhr_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Zi káí zi xg'ae zi hàà cgae Me a óá ts'íìko ne hẽé naka káà tcgáí ne hẽé, naka nqo̱ara ne hẽé naka kg'ui tama ne hẽé naka káí ne c'ẽe ne hẽéthẽé e, a ne a hàà nqàrè-kg'ama ba koe xòo ne, Me qãèkagu ne. ");
INSERT INTO nhr_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ne khóè ne are, ẽe ne ko kg'ui tama ne khóè ne bóò ne ko kg'ui ka, naka ẽe nqo̱ara hãa ne hẽé ne ko qãè ka, naka ẽe ts'íìko ne hẽé ne ko qõò ka, naka ẽe káà tcgáí ne ko bóò ka hẽéthẽé e. Ka ne ko Iseraele dim Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Me Jeso ba Gam di xu xgaa-xgaase-kg'ao xu tciia óá a máá: “Ncẽe ne khóè ner ko thõò-xama máá, ncẽeska ne nqoana cáḿan Tíí cgoa hãa khama, a tc'õó ne gha gúù ga úú tama, Ra xàbà ne hãase dìbikagua ne tc'ẽe tama, hẽé ne gha a dàòan q'oo koe qgaè-kg'ai a cg'áé khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Xu Gam di xu xgaa-xgaase-kg'ao xu xo̱a Me a máá: “Ncẽem tchàa-xgóóm koe xae gha ndaa koe tc'ãòa péréan hòò, a ncẽeta noos xg'ae sa tc'õókagu?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Me Jeso ba tẽè xu a máá: “Nta noo péréan xao úúa?” témé. Xu máá: “7 péréan hẽé naka cg'orò x'aù-coan hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Me xg'ae sa bìrí si góḿan-kg'ai koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Me gaxu péré xu 7 xu hẽé naka x'aùan hẽéthẽé séè, a ba a Nqari ba qãè-tcaoa máá xg'ara, a khõá q'aa a, a xgaa-xgaase-kg'ao xu máà a, xu xgaa-xgaase-kg'ao xu khóè ne máà a. ");
INSERT INTO nhr_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ne wèéa ne ga tc'õó a ne a xg'ãà, gaa koe guus ka xu kò xgaa-xgaase-kg'ao xu ẽe kò qaùan ka 7 zi q'ore zi tcana cg'oè-cg'oe. ");
INSERT INTO nhr_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Khóè ne ẽe kò tc'õó nea kò 4,000 ne e, khóè zi hẽé naka cóán hẽéthẽé kò nxárá tcãàè tama ne. ");
INSERT INTO nhr_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Me kò khóè ne dìbikagu, a ba a dxòrom koe tcãà a Magatane dim nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xu kò Farasai xu hẽé naka Saduke xu hẽéthẽé xu hàà cgae Me, a qgóó Me xu gha qgáìan xu kòo qaa khama dtcàrà Me, are-aresas x'áís nqarikg'ai di sam gha x'áí xu sa. ");
INSERT INTO nhr_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Me xo̱a xu a máá: “Dqòara i kò hãa ne tu ko máá: ‘Nqarikg'ai ne nco̱à a, khamam gha q'uu dim cáḿ ba qãè me e,’ témé, ");
INSERT INTO nhr_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","a ncẽe ntcùúkg'ai cgoa kò ii ne tu ko máá: ‘Nqarikg'ai ne nco̱à a, a ntcùú u, khama i gha ncẽe cáḿ ka tuu-c'õòan hàna,’ témé. Nqarikg'ai di bóòse-q'ooan nxàea ka̱bian tu q'ana hãa, ka tu gáé cuiskaga ncẽem x'aèm ka ko kúrúse zi x'áí zi kgoana naka nxàea ka̱bia hãa tite? ");
INSERT INTO nhr_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Qhàòs ncẽe cg'ãè cau, a cg'árà di sa ko are-aresas x'áí sa qaa. Igabas cúís x'áís ga sa x'áíèa hãa tite, Jonam dis x'áís cúís oose,” tam Jeso ba méé. A ba a nxãaska guu ne a qõò. ");
INSERT INTO nhr_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Eẽ xu ko xgaa-xgaase-kg'ao xu tshàa ba tchoaba ka xu kò péréan séè c'urùa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Me Jeso ba bìrí xu a máá: “Q'ãa méé xao, naka xaoa kòresea hãa Farasai xu hẽé naka Saduke xu hẽéthẽé di péré gãé-gãean koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xu nxãaska kg'ui cgoaku a máá: “Ncãa xae táá péréan cgoa hàà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Igabam kò Jeso ba Gaxu di kg'uian q'ana hãase bìrí xu a máá: “Gaxao ncẽe cg'áré dtcòm̀an úúa xaoè, dùús domka xao ko péréan xao úú tamas ka kg'ui cgoakua máá? ");
INSERT INTO nhr_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Qanega xao gáé bóòa q'ãa tama? A tc'ẽe-tc'ẽese tama xaoa 5 xu péré xu ncẽe Ra kò 5,000 ne khóè ne khõá q'aa máá xu, naka nta noo q'ore zi xao kò tcana cg'oè-cg'oe sa? ");
INSERT INTO nhr_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kana xaoa tc'ẽe-tc'ẽese tama 7 xu péré xu ka, 4,000 ne khóè ne koe, naka nta noo zi q'ore zi xao ko tcana cg'oè-cg'oe sa? ");
INSERT INTO nhr_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Dùúska xao bóòa q'ãa tama, péréan kar kg'ui cgoa xao o tama sa? Igaba méé xao Farasai xu hẽé naka Saduke xu hẽéthẽé di péré gãé-gãean koe kòresea,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Xu nxãaska kóḿa q'ãa, péré gãé-gãean koe méé xu kòrese sam nxàe tama sa, igaba Farasai xu hẽé naka Saduke xu hẽéthẽé di xgaa-xgaan koe e sa. ");
INSERT INTO nhr_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Eẽm ko Jeso ba Kaesarea Filipi ta ko ma tciièm nqõóm koe hàà kam kò Gam di xu xgaa-xgaase-kg'ao xu tẽè a máá: “Khóèm dim Cóám ka ne ko khóè ne máá dìí Me e, témé?” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xu xo̱a a máá: “C'ẽe ne ko máá: Johane Tsi tcguù-tcguu-kg'ao Tsi i,” témé, ne ko c'ẽe ne máá: “Elija Tsi i,” témé, ne ko c'ẽe ne qanega máá: “Jeremia Tsi i kana porofiti xu ka c'ẽe Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Me máá: “Kháé xao ko gaxao nta méé, dìí Raa, ta xao ko méé?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Me Simone Petere ba xo̱a Me a máá: “Tsáá Tsia nqòòkaguèa Tsi Kreste Tsi i, kg'õèam Nqarim di Tsi Cóá Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Me Jeso ba xo̱a me a máá: “Ts'ee-ts'eekg'aièa tsia tsáá Simone tsi, Jonam di tsi cóá tsi, ncẽe sa tsi khóèan ka x'áíè tama, igaba tirim Xõòm nqarikg'ai koe hànam ka a khama. ");
INSERT INTO nhr_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ra ko Tíí bìrí tsi a ko máá, Petere tsi i, témé, ra gha Tiris kereke sa ncẽes nxõ̱ás tc'amkg'ai koe tshào, i dxãwam di qarian ga tàà si tite. ");
INSERT INTO nhr_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Xgobekg'aman nqarikg'ai di x'aian dir gha máà tsi, si gha wèés gúùs ẽe tsi ko nqõómkg'ai koe qáé sa nqarikg'ai koe qáéèa hãa, si gha wèés gúùs ẽe tsi ko nqõómkg'ai koe kgoara sa nqarikg'ai koe kgoaraèa hãa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A ba a nxãaska Gam di xu xgaa-xgaase-kg'ao xu qarika x'áè a máá, táá méé xu cúí khóè ga bìrí Kreste Me e sa, témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jeso ba kò ẽem x'aèm koe guu a Gam di xu xgaa-xgaase-kg'ao xu tshoa-tshoa a x'áí, Jerusalema koe méém qõò sa, naka síí kaia xu hẽé, naka kaia xu peresiti xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu ka hẽéthẽé thõò-thõoè sa, naka baa cg'õoè, naka baa nqoana dim cáḿ ka x'ooan koe ghùiè. ");
INSERT INTO nhr_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Me Petere ba séèa tcg'òó Me, a tshoa-tshoa a dqàè Me a máá: “Cuiskaga a, X'aigaè, ncẽes gúù sa cuiskaga Tsáá koe kúrúse tite!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Igabam kò Jeso ba ka̱bise a Petere ba bìrí a máá: “Tíí koe tcg'oa, satanaè, Tiri tsi qa̱e-kg'ao tsi i, Nqarim di zi gúù zi koe tsi tc'ẽea tsi tcãà tama ke, igaba tsi khóèan di zi gúù zi koe tcãà tc'ẽea,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Me nxãaska Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Ncẽè c'ẽem khóèm kò xùri Te kg'oana ne méém bóòa xguìse naka baa gam dim xgàu hìi ba dcẽé naka xùri Te. ");
INSERT INTO nhr_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Dìím wèém ẽe gaam dis kg'õè sa qgóóa qari kg'oana bas gha aaguse cgae, igaba dìím wèém ẽe ko Tíí domka gaam dis kg'õès ka aaguse cgaeè, ba gha hòò si khama. ");
INSERT INTO nhr_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dùús ka ba gha khóè ba kháé ka̱bisea mááè, ncẽè wèém nqõó bam kòo hòò, a ba a gaam dis kg'õès ka aaguse cgaeè ne, kana ba gha khóè ba gaam di kg'õèan téé-q'oo koe dùútsa gúù sa tcg'òó a máà? ");
INSERT INTO nhr_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Xõòm dim x'áàm koe hànasem gha Khóèm dim Cóá ba Gam di xu moengele xu cgoa hàà khama, a ba a gha wèém khóè ba ẽem kúrúa hãa zi tséé zi koe guu a suruta. ");
INSERT INTO nhr_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tseegua ner ko bìrí tu u: Ncẽe koe téé-tẽe ne ka c'ẽea ne x'ooan xám̀a hãa tite, Khóèm dim Cóá ba ne bóò, Me Gam di x'aian koe hãase hàà tama cookg'ai koe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","6 cáḿan qãá q'oo koem kò Jeso ba Petere ba hẽé, naka Jakobo ba hẽé, naka gam ka qõesem Johane ba hẽéthẽé xu séè, a kaiam xàbì ba q'ábà qaò cgoa xu, xu gaa koe síí cúía hãa. ");
INSERT INTO nhr_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Gaxu cookg'ai koe i kò bóòse-q'ooa ba ka̱bise a tãá, i kg'áía ba cáḿs khama ma tca̱à, i Gam di qgáían x'áàm khama ma q'úú. ");
INSERT INTO nhr_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ka tsara kò gaa x'aè kaga Moshe ba hẽé naka Elija ba hẽéthẽé tsara gaxu ka bóòè, a ko Jesom cgoa kg'ui. ");
INSERT INTO nhr_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Me Petere ba Jeso ba bìrí a máá: “X'aigaè, qãès gúù si i ncẽe koe xae hãa sa. Ncẽè tc'ẽe Tsi kòo ne, ra gha nqoana nquu xu ncẽe koe tshào, me gha c'ẽe ba Tsari ii, me c'ẽe ba Moshem di, me gha c'ẽe ba Elijam di,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Eẽm qanega hãa a ko kg'ui kas kò kúúga x'áàkos túú-c'õò sa qàbia tcãà xu. Me kò gaa x'aè kaga kg'ui ba túú-c'õòs q'oo koe tcg'oa a máá: “Ncẽe ba Tirim Cóá Me e, ncàm̀a Raa ba, Gaam kar kaisase qãè-tcaoa hãa. Komsana Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eẽ xu ko xgaa-xgaase-kg'ao xu ncẽes gúù sa kóḿ ka xu kò kg'áía xu cgoa góḿankg'ai koe cg'áé, a xu a kaisase q'ae. ");
INSERT INTO nhr_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Igabam kò Jeso ba hàà a qgóó xu a máá: “Tẽea xao téé, naka táá q'áò guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eẽ xu ko ghùi-kg'ai ka xu kò táá cúí khóè ga hòò, Jesom cúím oose. ");
INSERT INTO nhr_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eẽ xu ko xàbìm koe xõa kam kò Jeso ba x'áè xu a máá: “Táá cúí khóè ga ẽe xao bóòa hãa sa bìrí guu, nakam nxãakg'aiga Khóèm dim Cóá ba x'ooan koe síí tẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Xu xgaa-xgaase-kg'ao xu tẽè Me a máá: “Dùús domka xu ko nxãaska x'áè xgaa-xgaa-kg'ao xu máá, Elija ba méém kg'aia hàà, téméa máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Me Jeso ba xo̱a xu a máá: “Tseeguan kagam gha Elija ba hàà, a hàà wèé zi gúù zi kg'ónò, ");
INSERT INTO nhr_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","igabar ko bìrí xao o a ko máá: Elija ba ncìísega hààraa, igabaga ne kò bóòa q'ãa me tama, a kò wèé zi gúù zi tc'ẽe ne kò ko zi kúrú cgae me. Gaam dàòm cúím kagam ko Khóèm dim Cóá ba hàà tshàu q'ooa ne koe xgàraè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Xu nxãaska xgaa-xgaase-kg'ao xu kóḿa q'ãa, Johanem tcguù-tcguu-kg'aom kam ko kg'ui sa. ");
INSERT INTO nhr_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eẽ xu ko xg'aes koe hàà, kam kò c'ẽem khóè ba Jesom koe hàà, a ba a hàà cookg'aia ba koe qo̱m̀, ");
INSERT INTO nhr_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","a máá: “X'aigaè, thõò-xama máá tirim cóá ba, x'óóa qae dis tcìì sam úúa, a ko kaisase xgàrase, a ko káí-kg'aise c'eean hẽé naka tshàan hẽéthẽé q'oo koe cg'áéa tcãà ke. ");
INSERT INTO nhr_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ra Tsari xu xgaa-xgaase-kg'ao xu koe óága mea, igaba xu kò kg'õèkagua ba ka tààè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Me Jeso ba xo̱a me a máá: “Oo, tsóágase dtcòm̀ úú tamas qhàò sa gáé ncẽe sa, a cg'ãè tc'ẽe sa! Nta noo x'aèa ne Ra gha gatu cgoa hãa! Nta noose Ra gha qáò-tcaoa máá tu u! Ncẽe koe óá me, Tíí koe!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Me Jeso ba dxãwa tc'ẽean dqàè, i gam cóám koe tcg'oa, me gam x'aèm koe ga guu a qãè. ");
INSERT INTO nhr_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nxãaska xu kò xgaa-xgaase-kg'ao xu Jeso ba dxùukg'ai koe séèa tcg'òó, a tẽè Me a máá: “Dùús domka xae kò tààè, a táá xhàiagu u?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Me xo̱a xu a máá: “Cg'áré dtcòm̀an xao úúa hãa domka a. Tseeguan kar ko bìrí xao o, a ko máá: Dtcòm̀an xao kò úúa mosetara dis hìis dim tc'ubim khama noo o, ne xao gha ncẽem xàbì ba bìrí a máá: ‘Ncẽe koe tcg'oa naka ẽe síí hãa koe síí,’ témé, nem gha tcg'oa. Cúí gúù ga tàà xaoa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Igaba i ncẽeta iian tcg'oa tama, igaba còrèan hẽé naka tc'õoan carasean ka hẽéthẽé cúíga i ko kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Eẽ xu ko Galilea koe hààraa xg'ae kam kò Jeso ba bìrí xu a máá: “Khóèm dim Cóá ba gha hàà khóè ne tshàu q'oo koe tcãàè, ");
INSERT INTO nhr_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ne gha cg'õo Me, Me gha nqoana dim cáḿ ka x'óóan koe ghùiè,” témé. Xu kò xgaa-xgaase-kg'ao xu kaisase tshúù-tcao. ");
INSERT INTO nhr_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Eẽ xu ko Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé xu Kaperenaume koe tcãà ka xu kò tempelem di xu mari xg'ae-xg'ae-kg'ao xu Peterem koe hàà a tẽè me a máá: “Gaxao dim xgaa-xgaa-kg'ao ba gáé tempelem di marian tcg'òó tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Me xo̱a a máá: “Eè, tcg'òó om ko,” témé. Eẽm ko Petere nquum q'oo koe tcãà, kam kò Jeso ba tc'ãà a kg'ui cgoa me a máá: “Nta tsi ko ma tc'ẽe, Simoneè? Dìín koe xu ko nqõóan di xu x'aiga xu marian séè? X'áé-kg'ao ne koea kana c'ẽe ne koea?” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Me Petere xo̱a a máá: “C'ẽe ne koe e,” témé. Me Jeso ba bìrí me a máá: “Nxãaska ne x'áé-kg'ao ne kgoarasea. ");
INSERT INTO nhr_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gatà i ii igaba méé xae táá ghã̱a xu guu, ke tshàam koe qõò naka x'aù qgóó cgoa dim dqùi ba síí tcãà, naka tc'ãà dim x'aùm qgóó tsi ko ba séè, naka kg'áḿa ba kgóà, kaiam mari ba tsi gha hòò ke. Séè me naka síí mari xg'ae-xg'ae-kg'ao xu máà me, Tíí hẽé naka tsáá hẽéthẽé tsam di suruta iise,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Eẽm x'aèm ka xu kò xgaa-xgaase-kg'ao xu Jesom koe hàà a tẽè Me a máá: “Dìína nqarikg'ai di x'aian koe kaia?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Me cg'árém cóá ba Gam koe tciia óá, a hàà xg'aekua xu koe tòó me, ");
INSERT INTO nhr_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","a máá: “Tseegua ner ko bìrí xao o: Ka̱bise xao kò a cóán khama ii tama, ne xao cuiskaga nqarikg'ai di x'aian koe tcãà tite. ");
INSERT INTO nhr_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gaa domkagam gha wèém ẽe ko ncẽem cóám khama ma cg'áré-cg'arese ba nqarikg'ai di x'aian koe kaia ba ii. ");
INSERT INTO nhr_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dìím wèém ẽe ko ncẽeta iim cóá ba Tiri cg'õèan koe qãèse hààkagu ba ko Tíí tc'áróga qãèse hààkagu. ");
INSERT INTO nhr_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Igabaga dìím wèém ẽe ko ncẽe ne cg'áré ne ncẽe ko Tíí koe dtcòm̀ ne ka c'ẽe ba chìbian kúrúkagum ka i gha qãè ii, gáí cgoa dis nxõ̱ás kaias kòo qg'áóa ba koe qáéa tòóè, me tshàam ka nqãaka xaoa tcãàè, a tóm̀mè ne. ");
INSERT INTO nhr_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Haò, cg'ãè i gha ii nqõóm koe, gúù zi ncẽe ko khóèan chìbian kúrúkagu zi ka! Eẽta ii zi gúù zi méé zi hàà, igabaga haò, cg'ãè i gha ii, khóèm ẽe zi ko gaa zi gúù zi gam koe guu a hààm ka. ");
INSERT INTO nhr_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ncẽè tsarim tshàu ba kana tsarim nqàrèm kò ko chìbi kúrúkagu tsi ne méé tsi q'ãea tcg'òó naka aagu me. Qãèa i gha máá tsi, nqo̱ara hãase kana ts'íìkose tsi gha kg'õèan koe tcãà ne, cám̀ tshàu kana cám̀ nqàrèse chõò tama c'eean koe xaoa tcãàèan ka khama. ");
INSERT INTO nhr_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“A ncẽè tsarim tcgáím kò ko chìbian kúrúkagu tsi ne, ho̱bea tcg'òó naka aagu me. Qãè i gha máá tsia, káà tcgáíse tsi gha kg'õèan koe tcãà sa, cám̀ tcgáí úúase chõò tamas c'ees dxãwam dis koe xaoa tcãàèan ka ke. ");
INSERT INTO nhr_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Q'ana méé tu hãa naka táá ncẽe ne cg'áré ne ka c'ẽea ne ga cg'ãa-cg'ana iise bóò guu. Bìrí tu ur ko a ko máá: gane di xu moengele xu nqarikg'ai koe hãa xu ko Abom nqarikg'ai koe hàna ba wèé x'aè ka bóò ke. ");
INSERT INTO nhr_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Khóèm dim Cóá ba hààraa, hààm gha ho̱àra ne kgoara ka. ");
INSERT INTO nhr_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nta tu ko ma tc'ẽe? Ncẽè khóèm kò 100 zi ghùu zi úúa, si gazi xg'aeku koe cúí sa ho̱à, ne ba cuiskaga ẽe zi 99 zi xàbìan koe guu naka ẽe ho̱àra hãa sa síí qaa tite? ");
INSERT INTO nhr_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","A ncẽè hòò sim kòo ne, tseegua ner ko bìrí tu u a ko máá: Kaisasem gha gaas ẽes cúís domka qãè-tcao, ho̱à ta ga hãa zi 99 zi nqáéa hãase. ");
INSERT INTO nhr_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gatà iim dàòm cúím kam gatu dim Xõòm nqarikg'ai koe hàna ba tc'ẽe tama, ẽe cg'áré ne ka i gha cúía ne ga kaàkaguè sa. ");
INSERT INTO nhr_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ncẽè tsáá qõem kò chìbian kúrú cgae tsia ne méé tsi síí cgae me, naka dqàè me cám̀ tsao ii koe, a ncẽè komsana tsim kò ko ne tsi ncãa tsáá qõe ba gaicara hòòa mááse. ");
INSERT INTO nhr_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Igabam kò komsana tsi tama ne méé tsi cúí kana cám̀ khóèan cgoa síí cgae me. Ncẽes gúù sa tsi kò kúrú ne tsi ko Nqarim di zi Tcgãya zi ko nxàe sa kúrú ncẽe ko máá: ‘Cám̀ kana nqoana khóèan kò c'ẽes gúù sa nxàea tseegukagu ne i gha wèé khóèan ga tseeguan bóòa hãa,’ témé sa. ");
INSERT INTO nhr_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","A ncẽè komsana ne tamam kò hãa ne méé tsi kerekes dis xg'aes di ne koe síí naka bìrí ne. A ncẽè kerekes di ne nem kò komsana tama ne méé tsi tãám nqõóm dim khóèm khama ma qgóó me, kana mari xg'ae-xg'ae-kg'aom khama ma. ");
INSERT INTO nhr_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tseegua ner ko bìrí tu u a ko máá: Dùús wèés ẽe tu gha nqõómkg'ai koe qáé sa gha nqarikg'ai koe qáéèa hãa. Si gha gatà dùús wèés ẽe tu gha nqõómkg'ai koe kgoara sa nqarikg'ai koe kgoaraèa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Gaicara Ra ko tseeguan bìrí tu u a ko máá: A ncẽè gatu ka cám̀ tsara kò nqõómkg'ai koe c'ẽes gúùs dtcàrà koe dtcòm̀kua ne, ne tsara gha Abom nqarikg'ai koe hànam ka kúrú mááè si. ");
INSERT INTO nhr_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Nda koe ga igaba cám̀ kana nqoana khóèan kòo tirim cg'õèm cgoa xg'aea hãa, ner gaa koe gane xg'aeku koe hàna,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Me nxãaska Petere ba Jesom koe hàà a tẽè Me a máá: “X'aigaè, nta noo q'oro ba gha tíí qõe ba chìbian kúrú cgae te, ra chìbia ba qgóóa máá me, 7 q'oroa gáé?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Me Jeso ba xo̱a me a máá: “Bìrí tsir ko: 7 q'oro ka tamase, igaba 70 zi 7 zi i. ");
INSERT INTO nhr_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Gaa domka i nqarikg'ai di x'aian x'aigam cgoa ko nxárá xg'aeè, ẽe ko gam di ne qãà ne cgoa xg'ae a ntcõó a ẽe ne cgóbè cgae mea zi gúù zi nxàe cgoa ne ba. ");
INSERT INTO nhr_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eẽm ko tshoa-tshoa a ko gatà hẽé kagam kò khóèm 10 cãan marian di kò cgóbè cgae mea ba gam koe óáè. ");
INSERT INTO nhr_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Surutaa ba kam kò ko tààè khamam kò x'aiga ba x'áè sa tcg'òó, gabá hẽé naka gam dis khóè sa hẽé naka cóáa khara hẽé naka wèé gúùan ẽem úúa hãa hẽéthẽé méé i x'ámáguè, nakam suruta ka̱biè sa. ");
INSERT INTO nhr_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Me qãà ba cookg'aia ba koe qo̱m̀, a còrè me a máá: ‘X'aigaè, qáò-tcaoa máá te, wèé gúùa ner gha suruta ka̱bi ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Me ẽem qãàm dim x'aiga ba thõò-xama máá me, a kgoara me, a chìbia ba qgóóa máá me. ");
INSERT INTO nhr_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Igabaga ẽem ko gaam qãà ba tcg'oa, kam kò c'ẽem qãàm cg'áré mari-coan kò cgóbè cgae mea ba hòò. A ntcàù me, a tshoa-tshoa a chúú-chuu me, a máá: ‘Cgóbè cgae tea tsias gúù sa suruta ka̱bi,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Me gam ka c'ẽe ba qo̱m̀ a dtcàrà me a máá: ‘Qáò-tcaoa máá te, surutar gha ka̱bi tsi ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gabagam ko xguì, a ba a qõò a síí kúrú me khóè ba qáé-nquus koe tcãàè, a nxãakg'aiga síí suruta ka̱bi me. ");
INSERT INTO nhr_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Eẽ xu ko c'ẽe xu qãà xu ẽe kúrúsea sa bóò ka xu kò kaisase tshúù-tcao, a xu a síí gaxu dim x'aiga ba bìrí wèé zi gúù zi ẽe kúrúsea zi. ");
INSERT INTO nhr_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Me nxãaska x'aiga ba qãà ba tciia tcãà a máá: ‘Tsáá qãà tsi cg'ãè cau tsi, wèé chìbia tsi ẽe gar kò qgóóa máá tsia, dtcàrà tea tsi kò hãa domka. ");
INSERT INTO nhr_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Qaase tama i gáé kò hãa, thõò-xama-máákuan tsi ga tsáá ka c'ẽem koe úú sa, ncẽer kò ma thõò-xama máá tsia khamaga ma?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Me xgóàm hãa khama gam ka q'õòse ba síí qáé-nquus koe tcãà me, me kaisase thõò-thõoè, a síí nxãakg'aiga suruta ka̱bi wèéan ẽem kò cgóbèa a. ");
INSERT INTO nhr_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Ncẽea tirim Xõòm nqarikg'ai dim gha thẽé gatu koe kúrús ga si i, ncẽè gatu ka c'ẽem wèém kò gam ka qõese ba wèé tcáóa ba cgoa qgóóa máá tama ne,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Eẽm ko Jeso ba ncẽe zi gúù zi kg'uia xg'ara kam kò Galilea koe guu a Jutea koe qõò Jorotane di c'ẽe xòèan za. ");
INSERT INTO nhr_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zi kò kaia zi xg'ae zi xùri Me, Me gaa koe ga kúrú ne ne qãè. ");
INSERT INTO nhr_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xu c'ẽe xu Farasai xu hàà cgae Me, qáé Me xu gha qgáìan xu kòo qaa khama a máá: “A x'áèan koe ia kgoaraèa, khóèm gha gam dis khóè sa aagu sa c'ẽes gúùs domka?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Me xo̱a a máá: “Nxárá ta ga xao gáé hãa, tshoa-tshoas koem Kúrú-kg'ao ba khóè ba hẽé naka khóè sa hẽéthẽé kúrúa hãa sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A ba a máá: “Gaa domkagam gha khóè ba gam ka xõò ba hẽé naka xõò sa hẽéthẽé khara guu a ba a gha gam dis khóès koe tc'àmàse, khara gha cúím cgàa ba ii. ");
INSERT INTO nhr_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Gaa domka khara cuiskaga cám̀ tite, igabaga khara gha cúím cgàa ba ii. Gaa domka méés táá Nqarim ka xg'ae-xg'aeèa sa khóèm ka q'aa-q'aaè guu. ");
INSERT INTO nhr_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xu tẽè Me a máá: “Kháé dùús domka ba kò ko Moshe nxãaska x'áèan tcg'òóa máá, khóèm ga gam dis khóè sa q'ara khara hãa dis tcgãya sa máà, a aagu si di i?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Me xo̱a xu a máá: “Gaxao di qari tcúúan domkam kò Moshe ba kgoara máá xao o, gaxao di zi khóè zi xao gha aagu sa. Igabaga i kò tshoa-tshoas koe gatà ii tama. ");
INSERT INTO nhr_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Igabar ko bìrí xao o a ko máá: Dìím wèém ẽe ko gam dis khóè sa aagu, cg'árà di gúù ka tamase, a ko c'ẽes khóè sa séè ba ko cg'áràn kúrú,” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xu xgaa-xgaase-kg'ao xu bìrí Me a máá: “A ncẽè séèkus kò ncẽeta ii ne i qãè e khóè khara gha táá séèku sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Me xo̱a xu a máá: “Wèé khóèan ga cuiskaga ncẽe kg'uian kóḿa q'ãa tite, igaba ẽe máàè ea ne cúí ne ne e. ");
INSERT INTO nhr_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Khóè xua hàna khama, cóán ábà tite xu: c'ẽe xua gatà ma ábàèa, xu c'ẽe xu khóèan ka gatà ma kúrúèa, xu c'ẽe xu gaxu ka kúrúse ana, nqarikg'ai di x'aian domka. Eẽ ga kóḿa q'ãa ba méém kóḿa q'ãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nxãaska ne kò cóán Gam koe óá, tshàua bam gha tòó cgae, a còrèa máá a ka. Xu kò xgaa-xgaase-kg'ao xu khóè ne dqàè. ");
INSERT INTO nhr_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Igabam kò Jeso ba máá: “Cóán guu naka i Tíí koe hàà. Táá xgáè-kg'am m guu! Nqarikg'ai di x'aia nea gatà ii ne di i ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A ba a tshàua ba gane koe tòó, a gaa koe guus ka tcg'oa a qõò. ");
INSERT INTO nhr_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kam kò gaa x'aè kaga c'ẽem khóè ba Jesom koe hàà a ba a tẽè Me a máá: “Xgaa-xgaa-kg'ao Tseè, dùútsa gúùs qãè sa ra gha kúrú a nxãasega chõò tamas kg'õè sa hòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Me bìrí me a máá: “Dùúska tsi ko qãèan ka tẽè Tea máá? Cúím khóèm cúím ga ba qãè Me e. Igaba tsi kò kg'õèan koe tcãà kg'oana ne méé tsi x'áè-kg'áḿan qgóóa qari,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Me tẽè Me a máá: “Ndaka nea?” témé. Me Jeso ba xo̱a a máá: “Táá méé tsi cg'õo guu, táá méé tsi cg'árà kúrú guu, táá méé tsi ts'ãà guu, táá méé tsi tshúù-ntcõan nxàe guu. ");
INSERT INTO nhr_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Saò ba hẽé naka saò sa hẽéthẽé méé tsi tcom. Tsáá ka c'ẽe ba ncàm̀, ẽe tsi ma ncàm̀sea khamaga ma,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Me gam qárí-kg'ao ba máá: “Wèé x'áè-kg'áḿan ncẽe gar qgóóa qaria, dùú sa ra qanega tcàoa hãa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Me Jeso ba xo̱a me a máá: “Ncẽè wèé za ga tsi kò tchàno kg'oana ne qõò naka tsia síí wèé zi gúù zi ẽe tsi úúa hãa zi x'ámágu naka tsia ẽe dxàua ne khóè ne máà, nxãaska tsi gha nqarikg'ai koe qguùan úúa. Naka nxãaska hàà xùri Te,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Eẽm ko gaam qárí-kg'ao ba ncẽe sa kóḿ kam kò tshúù-tcaoase qõò, káí zi gúù zim kò úúa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Me Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Tseegua ner ko bìrí xao o: Qguùam khóèm gha nqarikg'ai di x'aian koe tcãà sa kaisase qari si i. ");
INSERT INTO nhr_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A ra a ko gaia máá: Kamelean gha dqààm di kòm̀-coan koe nqurì sa thamka si i, qguùam khóèm gha Nqarim di x'aian koe tcãàs ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eẽ xu ko xgaa-xgaase-kg'ao xu ncẽe sa kóḿ ka xu kò kaisase are a xu a tẽè a máá: “Kháé ba gha nxãaska dìí ba kgoaraè?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Me Jeso ba bóò xu a máá: “Khóèa ne ko tààè, igabam Nqari ba tààè tama, wèé gúùa ne Nqarim koe subu u khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Me Petere nxãaska xo̱a Me a máá: “Bóò! Sixaea wèé gúùan ga guua, a ko xùri Tsi. Dùú sa gha ka̱bisea máá xae e?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Me Jeso ba bìrí xu a máá: “Tseegukar ko bìrí xao o: ka̱bam nqõóm koe, ncẽe Khóèm dim Cóám ko x'aian dis ntcõó-q'oos x'áàn dis koe hàà ntcõó, ne xao gha gaxao ẽe ko xùri Tea hãa xao thẽé x'aian di zi ntcõó-q'oo zi 12 zi koe síí ntcõó, a xao a gha 12 zi qhàò zi Iseraele di zi bóò a xgàra. ");
INSERT INTO nhr_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Igaba dìím wèém ẽe Tiri cg'õèan domka x'áéa ba guua ba, kana qõese ga xu, kana qõese ga zi, kana xõòm ga ba, kana xõòs ga sa, kana cóán ga, kana xháràn ga, nxãa ba gha 100 q'oro ncẽe zi gúù zi máàè, a ba a gha chõò tamas kg'õè sa q'õò. ");
INSERT INTO nhr_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Igabaga ne gha káí ne ẽe tc'ãà di ne kháóka di ne ii, ne gha ẽe kháóka di ne tc'ãà di ne ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nqarikg'ai di x'aia nea xhárà ba q'õòam khóèm khama ii khama, ncẽe ko ntcùúkg'ai cgoa tcg'oa a qõò, a síí khóè xu gam dim kg'om xháràm koe gha tséé xu qaa ba. ");
INSERT INTO nhr_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","A ba a dtcòm̀ku cgoa xu, cáḿan di maria nem gha ko suruta xu sa, a ba a gam dim kg'om xháràm koe tsééa tcãà xu. ");
INSERT INTO nhr_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A ba a 9 di x'aè ka tcg'oa, a qõò a síí c'ẽe xu bóò xu x'ámágu dis qgáìs koe téé-tẽe, cúí gúù ga kúrú tamase. ");
INSERT INTO nhr_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Me bìrí xu a máá: “Gaxao igaba méé xao thẽé tirim kg'om xháràm koe síí tséé. Eẽ tchàno ii sar gha suruta xao o ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Xu qõò. Me gaicara koaba ka hẽé naka dqòa tcgaì ka hẽéthẽé tcg'oa a qõò, a síí gatà iis gúùs ga sa kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Me dqòa ka tcg'oa a qõò, a gaicara c'ẽe xu bóò xu tẽe. Me tẽè xu a máá: “Dùús domka xaoa koabam wèé ba gúù kúrú tamase ncẽe koe téé-tẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Xu xo̱a me a máá: “Cúí khóè ga tsééan máà xae e tama domka a,” témé. Me máá: “Gaxao igaba méé xao tirim kg'om xháràm koe síí tséé,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cáḿs ko tcãà kam kò kg'om xháràm ka q'õòse ba tc'ãà-cookg'aim gaxu di ba bìrí a máá: “Tséé-kg'ao xu tcii naka suruta xu. Kháóka hààraa xu cgoa tshoa-tshoa naka tc'ãà di xu koe síí chõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xu tséé-kg'ao xu ẽe kò dqòa ka tsééan tshoa-tshoa xu hàà a xu a wèéa xu cáḿ dim mari ba gàbakaguè. ");
INSERT INTO nhr_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Igaba ẽe kò tsééan tc'ãà a tshoa-tshoa xu ko hàà surutaè ka xu kò tc'ẽea máá, kaisa maria ne xu gha surutaè, ta tc'ẽea. Igaba xu kò gaxu igaba wèéa xu ga cáḿ dim mari ba gàbakaguè. ");
INSERT INTO nhr_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Eẽ xu ko gàbakaguè e ka xu kò tshoa-tshoa a xháràm ka q'õòsem cgoa mẽéku, ");
INSERT INTO nhr_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","a máá: “Khóè xu ncẽe kò kháóka tshoa-tshoa xua cúím aoara ba tsééa, igaba tsi kúrú xua xu sixae khama noo, ncẽe tsééan di qóḿan hẽé naka cáḿs ka dàoku sa hẽéthẽé xám̀a hãa xae,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Me xháràm ka q'õòse ba gaxu ka c'ẽe ba xo̱a a máá: “Khóè tseè, kàa tsi tama ra hãa, ka tsam gáé ncãa dtcòm̀ku tama cáḿan dim marim ka? ");
INSERT INTO nhr_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Séè tsari maria ne naka qõò. Kháóka tsééan tshoa-tshoa hãam tséé-kg'ao bar tsáá khama ma suruta kg'oana ke. ");
INSERT INTO nhr_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kgoarasea tama ra gáé hãa, tc'ẽer kos gúù sar gha tiri marian cgoa kúrú sa? Kana ba ko tsarim tcgáí ba tiri qãè tcáóan domka nxã̱è te?” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ncẽem dàòm ka ne gha tc'ãà di ne kháóka di ne ii, ne gha kháóka di ne tc'ãà di ne ii. ");
INSERT INTO nhr_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Eẽm kòo Jeso ba Jerusalema koe qõò kam kò Gam di xu xgaa-xgaase-kg'ao xu 12 xu cúía séèa tcg'òó, a dàò q'oo koe bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Bóò, Jerusalema koe xae ko qõò, Me gha Khóèm dim Cóá ba kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé tshàu q'oo koe tcãàè. Xu gha x'óós koe chìbi-chibi Me. ");
INSERT INTO nhr_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","A xu a gha tãá zi qhàò zi di xu khóè xu tshàu q'oo koe tcãà Me, nxãasega xu gha nco̱i Me, a qoa Me, a xgàu Me ka. Igabam gha nqoana dim cáḿ ka x'ooan koe ghùiè. ");
INSERT INTO nhr_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Si kò nxãaska Sebetem di tsara cóá tsara ka xõò sa gas di tsara cóá tsara cgoa Gam koe hàà, a sa a qo̱m̀, a c'ẽes gúù sa dtcàrà Me. ");
INSERT INTO nhr_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Me Jeso ba gas ka máá: “Dùú sa si ko dtcàrà?” témé. Si xo̱a Me a máá: “Nxàe, tiri tsara cóá tsara gha Tsari x'aian koe Tsáá qàe koe ntcõó sa, me c'ẽe ba kg'áò xòèa Tsi koe ntcõó, me c'ẽe ba dxàe xòèa Tsi koe ntcõó,” tas méé. ");
INSERT INTO nhr_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Me Jeso ba xo̱a a máá: “Dùú sa tu ko dtcàrà sa tu q'ãa tama. A Tiris kubis kg'áàr kos koe tsao ga kg'áà?” ta méé. Tsara máá: “Kg'áà tsam ga,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Me bìrí tsara a máá: “Kubis Tiris koe tsao gha kg'áà. Igaba ncẽe kg'áò xòèa Te koe hẽé naka dxàe xòèa Te koe hẽéthẽé ntcõóan ka, nxãa nea Tíí ka kúrúè tama, igaba i gane ẽe Abom ka kg'ónò mááè ea ne di i,” ta méé. ");
INSERT INTO nhr_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eẽ xu ko 10 xu ncẽe sa kóḿ ka xu kò ẽe tsara khóè qõeku tsara kaisase xgóà cgae. ");
INSERT INTO nhr_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Igabam Jeso ba Gam koe tciia óá xu a máá: “Q'ana xao hãa, tãá zi qhàò zi di xu x'aiga xu ko gane koe gaxu di qarian x'áí sa, xu ko gane di xu kaia xu gane koe gaxu di qarian tséékagu. ");
INSERT INTO nhr_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Táá méé i gaxao koe gatà ii guu. Igaba dìím wèém ẽe gha ko gaxao koe kai kg'oana ba, méém gaxao dim tséé-kg'ao ba ii. ");
INSERT INTO nhr_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Naka méém wèém ẽe gaxao xg'aeku koe tc'ãà kg'oana ba gaxao dim qãà ba ii, ");
INSERT INTO nhr_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ncẽem ma Khóèm dim Cóá ba ma hàà khóè ne ka tsééa mááè tama khama. Igabam hààraa, hààm gha khóè ne tsééa máá ka, a gha hàà kg'õèa ba máà, káí ne khóè nem gha suruta máá, ne kgoaraè ka. ");
INSERT INTO nhr_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eẽ xu ko Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé Jeriko koe tcg'oa kas kò kaias xg'ae sa xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka tsara kò gaa x'aè kaga cám̀ khóè tsara káà tcgáí tsara dàòm dxùukg'ai koe ntcõe. Eẽ tsara ko kóḿ Jesom ko nqáé sa ka tsara kò q'au a máá: “X'aiga Tsi Nqari Tseè, Dafitem ka tsgõose-coa Tseè, thõò-xama máá tsam m!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Igabas kò xg'ae sa dqàè tsara a, a máá, nqoo méé tsara, témé, tsara kaisase q'au a máá: “X'aiga Tsi Nqari Tseè, Dafitem ka cóáse Tseè, thõò-xama máá tsam m!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Me kò Jeso ba téé a tcii tsara a, a ba a máá: “Dùú sar gha kúrúa máá tsao o sa tsao ko tc'ẽe?” ta ma tẽè. ");
INSERT INTO nhr_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tsara bìrí Me a máá: “X'aigaè, tcgáía tsam méé i xgobekg'amse sa tsam ko tc'ẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Me Jeso ba thõò-xama máá tsara am ko khama tcgáía tsara qgóó, tsara kúúga bóò, a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Eẽ ne ko Jerusalema koe cúù, a ko Betefage koe hàà, Olife dim xàbìm koe, kam kò Jeso ba cám̀ xgaa-xgaase-kg'ao tsara tsééa tcg'òó, ");
INSERT INTO nhr_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a bìrí tsara a, a máá: “Qõò tsao gatsao cgoa q'óá-kg'amkuam x'áém koe, gaa koe tsao gha donghi sa hòò, si qáésea tẽe, donghi-coam cgoa. Kgoara naka Tíí koe óá si. ");
INSERT INTO nhr_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A ncẽè c'ẽem khóèm kò c'ẽe gúù bìrí tsao o, ne méé tsao bìrí me naka máá: ‘X'aiga ba ko qaa khara a,’ témé, nxãaskam gha kúúga guu khara a,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ncẽes gúù sa kò kúrúse, porofitim ka kò kg'uièa hãas kg'uis gha nxãasega tseegukaguè ka, ncẽe kò máá: ");
INSERT INTO nhr_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Cóás Sione di sa bìrí naka máá: ‘Bóò, sarim X'aiga ba ko cg'áré-cg'aresease hàà cgae si, a ba a donghi sa qábìa hãa, donghi-coam cgoa hàna sa, donghis dim cóá ba,’” ta mééè sa. ");
INSERT INTO nhr_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tsara xgaa-xgaase-kg'ao tsara qõò, a síí Jesom ko ma x'áè tsara a khama ma kúrú, ");
INSERT INTO nhr_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","a síí donghi sa óá, donghi-coam cgoa, a tsara a gatsara di qgáían gam koe tcee, Me gaa koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Si káís xg'ae sa dàòm q'oo koe gane di qgáían khárà, ne c'ẽe ne hìian di nxã̱an xg'ao a ne a dàòm q'oo koe khárà. ");
INSERT INTO nhr_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Si kò xg'aes ẽe kò cookg'aia ba koe hẽé naka kháóa ba koe hẽéthẽé hãa sa q'au a máá: “Hosana, Dafitem ka tsgõose-coa ba! Ts'ee-ts'eekg'aièa baa, Gaam ẽe ko X'aigam Nqarim di cg'õèan cgoa hàà ba! Hosana, ẽe kaisase tc'amaka hàna ba!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Eẽm ko Jeso ba Jerusalema koe tcãà kam kò wèém x'áé-dxoo ba nqàrè ka téé a máá: “Ncẽe ba dìí baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Zi xg'ae zi xo̱a a máá: “Ncẽe ba Jeso Me e, porofitim Galilea dim xg'aekum Nasareta dim koe guua hãa ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Me Jeso ba tempelem koe tcãà, a ba a wèé ne ẽe kòo tempelem q'oo koe x'ámá, a ko x'ámágu ne xhàiagu, a ba a kò khóè ne ncẽe tãá nqõó di marian ko séè a gaan téé-q'oo koe tempelem di marian khóè ne máà ne di tafolean xùbu, naka gane ẽe ko tcíbían x'ámágu ne di ntcõó-q'ooan hẽéthẽé e, ");
INSERT INTO nhr_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","a ba a bìrí ne a máá: “Góásea i hãa a ko máá: ‘Tirim nquu ba méém còrèan dim nquu ba ta ma tciiè,’ igaba tu gatu ts'ãà-kg'ao ne dim nquu ba kúrú mea,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ne káà tcgáí ne hẽé naka nqo̱ara ne hẽéthẽé tempelem koe hàà cgae Me, Me kúrú ne ne qãè. ");
INSERT INTO nhr_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Igaba ẽe xu ko kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé ko are-aresa zi gúù zi kúrúm ko zi bóò, i ko cóán tempelem koe q'au a ko máá: “Hosana, Dafitem ka tsgõose-coam koe,” témé ka xu kò xgóà, ");
INSERT INTO nhr_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","a xu a Gam ka máá: “A kóḿ Tsi ko ncẽe cóán ko méés gúù sa?” témé. Me Jeso ba xo̱a a máá: “Eè, qanega xao gáé nxárá naka kóḿ ta ga hãa Nqarim di zi Tcgãya zi koe góásea sa, ncẽe ko máá: ‘Cóán hẽé naka comko cóá-coan hẽéthẽé di kg'áḿan koer dqo̱m̀an kg'ónò máásea hãa,’ ta méé sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A ba a guu xu a x'áé-dxoom ka tchàa koe tcg'oa a Betania koe síí, a gaa koe síí x'óm̀. ");
INSERT INTO nhr_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kaisa ntcùúkg'ai cgoa, ẽem ko x'áé-dxoom koe ka̱bise kam kò xàbàa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Faia dis hìi sam ko dàòm qàe koe bóò kam kò síí cgae si, a síí cúí gúù ga táá hòò cgae si, igaba to̱aran cúí ga a. Kam kò gaas ka máá: “Chõò tamase méé i cúí tc'õo ga sáá koe gaia táá tcg'oa guu!” témé. Si kò faia dis hìi sa gaa x'aè kaga nqa̱i. ");
INSERT INTO nhr_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eẽ xu ko xgaa-xgaase-kg'ao xu bóò si ka xu kò are, a máá: “Nta sa ko ma faia dis hìi sa kúúga nqa̱i?” ta ma tẽè. ");
INSERT INTO nhr_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Me Jeso ba xo̱a xu a máá: “Tseegukagar ko bìrí xao o: Dtcòm̀an xao kò úúa hãa, a káíse tc'ẽe-tc'ẽese tama, ne xao cuiskaga faia dis hìis koe kúrúseas gúùs cúí sa kúrúa hãa tite, igaba ẽe xao kòo ncẽem xàbì ba bìrí a máá: ‘Séèa ghùiè naka síí tshàam q'oo koe ncemea tcãàè’ témé, ne i gha gatà ii. ");
INSERT INTO nhr_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","A ncẽè dtcòm̀an xao kò úúa hãa ne xao gha dùús wèés ẽe xao ko còrèan cgoa dtcàrà sa hòò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesom ko tempelem koe tcãà ka xu kò kaia xu peresiti xu hẽé naka khóè ne di xu kaia xu hẽéthẽé hàà cgae Me, ẽem hãa a ko xgaa-xgaa ka, a xu a máá: “Dùútsa qaris cgoa Tsi ko ncẽe zi gúù zi kúrú, i gataga dìín ncẽe qarian máà Tsia hãa ncẽe gúù zi kúrú di i?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Me Jeso ba xo̱a xu a máá: “Tíí igabar gha cúís gúù sa tẽè xao o thẽé, a ncẽè xo̱a ba xao kò máà Te, ner gha Tíí igaba bìrí xao o dùútsa qaris cgoar ko ncẽe zi gúù zi kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Tcguù-tcguukuan Johanem dia kò ndaa guua, nqarikg'ai koea kana khóèan koea?” témé. Xu xóé a tẽèku a máá: “‘Nqarikg'ai koe e,’ ta xae kò ko méé nem gha tẽè xae e a máá: ‘Dùús domka xaoa kò kháé nxãaska gam koe dtcòm̀ tama?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Igaba ncẽè: ‘Khóèan koe e,’ ta xae kò ko méé ne xae ko khóèan bèe. Wèé ne khóè ne ko Johane ba porofitim iise bóò khama,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Xu Jeso ba xo̱a a máá: “C'úùa xae hãa,” témé. Me bìrí xu a máá: “Nxãaskar Tíí igaba cuiskaga bìrí xaoa hãa tite dùútsa qaris cgoar ko ncẽe zi gúù zi kúrú sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nta xao ko ma tc'ẽe? C'ẽem khóè ba kò cám̀ cóá tsara úúa. A ba kò tc'ãà dim cóám koe síí, a bìrí me a máá: ‘Tiri cóáè, qõò naka síí ncẽe cáḿ ka kg'om xháràm koe tséé,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Me xo̱a me a máá: ‘Cuiskaga a,’ témé, igabam kò kháóka tc'ẽea ka̱bi, a ba a qõò. ");
INSERT INTO nhr_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Me khóè ba cám̀ dim cóám koe síí, a gataga gam ka méé, me xo̱a a máá: ‘Qõòr gha àboè,’ témé, igabam táá qõò. ");
INSERT INTO nhr_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Gatsara ka ndaka ba kòo xõòm ko tc'ẽe sa kúrú?” tam Jeso ba ma tẽè. Xu máá: “Tc'ãà di me e,” témé. Me Jeso ba bìrí xu a máá: “Tseegukar ko bìrí xao o: Mari xg'ae-xg'ae-kg'aoan hẽé naka cg'árà-kg'ao zi hẽéthẽéa gha Nqarim di x'aian koe gaxao ka tc'ãà a tcãà. ");
INSERT INTO nhr_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Johane ba kò gaxao koe tchànom dàòm cgoa hàà, xao kò táá gam koe dtcòm̀, igaba i kò mari xg'ae-xg'ae-kg'aoan hẽé naka cg'árà-kg'ao zi hẽéthẽé gam koe dtcòm̀. Gataga xao kò ncẽes gúù sa bóò, igaba xao kò táá kháóka tc'ẽea ka̱bi a gam koe dtcòm̀,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","A ba a máá: “C'ẽes sere-sere sa kóḿ. C'ẽem x'ãè-kg'ao ba kò hàna, ncẽe kò kg'om xhárà ba xháràa ba, a ba a kò xhàro ba gaam koe kúrúa nxa̱ma-nxa̱ma, a ba a gõéan ko kúrúèm qgáì ba hẽé naka qáòm nquu ba hẽéthẽé gaa koe tshào, a ba a xhárà-kg'ao xu cgóbè me, a c'ẽem nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Eẽm ko tc'õoan ko kúrúsem x'aè ba cúù kam kò gam di qãàn tsééa úú, xhárà-kg'ao xu koe, síí xu gha gam di tc'õoan séè ka. ");
INSERT INTO nhr_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Xu kò xhárà-kg'ao xu gam di qãàn séè, a c'ẽe ba xg'áḿ, a c'ẽe ba cg'õo, a xu a c'ẽe ba nxõ̱án cgoa xgàrùbe. ");
INSERT INTO nhr_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","“Gaicaram kò c'ẽe qãàn tsééa úú, kg'aiakan nqáéa hãa a, xu síí gataga hẽé e. ");
INSERT INTO nhr_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Kháókam kò gam dim cóá ba tsééa úú cgae xu, a máá: ‘Tirim cóá ba xu gha tcom a qgóóse,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Igaba ẽe xu ko xhárà-kg'ao xu cóá ba bóò ka xu kò bìríku a máá: ‘Ncẽe ba gúù zi ka q'õòsem ga me e, ncẽe gha ko hàà xhárà ba q'õò ba, ke hàà naka xae cg'õo me naka gam di x'aian séè,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Xu kò séè, a kg'om xháràm ka tchàa koe xaoa tcg'òó me, a cg'õo me. ");
INSERT INTO nhr_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Kháé nxãaska, ẽem kòo kg'om xháràm ka q'õòse ba hàà, ne ba gha ẽe xu xhárà-kg'ao xu xháràm di xu dùú sa kúrú?” tam ma Jeso ba tẽè. ");
INSERT INTO nhr_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Xu bìrí Me a máá: “Eẽ xu cg'ãè kúrú-kg'ao xum gha cg'ãèm dàòm cgoa kaàkagu, a ba a gha c'ẽe xu xhárà-kg'ao xu kg'om xhárà ba máà, xu qgóóa máá me, ncẽe gha gam di xòèan tc'õoan di máà me xu, tc'áróan ko kúrúse x'aèan kòo hàà ne xu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Me Jeso ba gaxu ka máá: “Qanega xao gáé Nqarim di zi Tcgãya zi koe nxárá tama, ncẽe ko máá: ‘Nxõ̱ás ẽe tshào-kg'ao xu ka bóòa xguìèa hãa sa, kaisase cgáés nxõ̱á sa kúrúa hãa. Ncẽea X'aigam Nqarim ma kúrúa hãa a, si ncẽe sa tcgáí-q'ooa ta koe t'õè si i,’ témé zi? ");
INSERT INTO nhr_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Gaa domkar ko bìrí xao o, a ko máá: X'aian Nqarim dia gha gaxao koe séèa tcg'òóè, a ia a gha qhàòs ẽe ko qãè tc'áróan kúrú sa máàè. ");
INSERT INTO nhr_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Gaam ẽe ko ncẽes nxõ̱ás koe cg'áé ba gha khoana tòm̀-tomse, igaba ẽes kòo c'ẽe khóèan koe cg'áé nes gha tòm̀-tom m,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Eẽ xu ko kaia xu peresiti xu hẽé naka Farasai xu hẽéthẽé Gaam di zi sere-sere zi kóḿ ka xu kò q'ana hãa gaxu kam ko kg'ui sa. ");
INSERT INTO nhr_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Qáé Me kg'oana xu kò hãa, igaba xu kòo khóè ne dis xg'ae sa bèe, porofitim iise ne kòo séè Me khama. ");
INSERT INTO nhr_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Me Jeso ba gaicara gane cgoa sere-sere zi cgoa kg'ui, a máá: ");
INSERT INTO nhr_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Nqarikg'ai di x'aia nea x'aigam ncẽe ko gam dim cóá ba séèkuan dis kõ̱è sa kúrúa máám cgoa nxárá xg'aeèa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Me nxãaska gam di qãàn tsééa úú ẽe ko séèkuan dis kõ̱ès koe tciièa hãa ne koe, síí ne gha bìrí ne ne hàà ka. Igaba ne kò hààn xguì. ");
INSERT INTO nhr_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Me gaicara c'ẽe qãàn tsééa úú a máá: ‘Bìrí ẽe kò tciièa hãa ne naka máá: ‘Bóò, kg'ónòar xg'ara hãa tc'õoan kõ̱ès di i, tiri xu ghòè xu hẽé naka tiri ghòè-coan tsáúa hãa hẽéthẽéa cg'õoèa hãa, i wèé gúùan kg'ónòa xg'araèa hãa, ke séèkuan dis kõ̱ès koe hàà,’ ’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Igaba ne kò tc'irì-tc'irise, a ne a qõò, Me c'ẽe ba gam dim xháràm koe qõò, me c'ẽe ba gam di tsééan koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne c'ẽe ne wèéa ne ga gam di qãàn qgóó, a xgàra a, a ne a cg'õo o. ");
INSERT INTO nhr_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Me x'aiga ba xgóà, a ba a gam di ncõo-kg'aoan tsééa úú, a ẽe ne cg'õo-kg'ao ne cg'õo, a gane di x'áé-dxooan dàò. ");
INSERT INTO nhr_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“A ba a nxãaska gam di qãàn bìrí a máá: ‘Séèkuan dis kõ̱è sa kg'ónòa xg'araèa hãa, igaba ẽer kò tciia hãa nea tciiku sa kg'ano tama. ");
INSERT INTO nhr_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ke ncẽeska x'áé-dxoom xg'aeku di dàòan ko nxãa koe qõò, naka séèkuan dis kõ̱ès koe tciia óá khóèan wèé ẽe xao gha hòò o,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","I kò ẽe qãàn x'áéan xg'aeku di dàòan koe qõò, a i a wèéan ẽe xu kòo xg'ae cgoan xg'ae-xg'ae, tshúùan ga hẽé naka qãèan ga hẽéthẽé e, me séèkuan dis kõ̱ès dim nquu ba cg'áè-kg'aoan ka cg'oè. ");
INSERT INTO nhr_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Igabam ẽem ko x'aiga ba tcãà, cg'áè-kg'aoa nem gha bóò ka, kam kò gaa koe séèkuan dis kõ̱ès di qgáían hã̱a tamam khóè ba bóò. ");
INSERT INTO nhr_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","A ba a bìrí me a máá: ‘Tíí tcáràè, nta tsi ma ncẽe koe tcana, séèkuan dis kõ̱ès di qgáían úú tamase?’ témé. Me khóè ba káàn kg'ui. ");
INSERT INTO nhr_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kam ko nxãaska x'aiga ba qãà xu bìrí a máá: ‘Qáé me tshàua ba koe hẽé naka nqàrèa ba koe hẽéthẽé e, naka tchàa koe xaoa tcg'òó me, dcùú-qoms q'oo koe, ncẽe gaa koe i gha kg'aean hẽé naka gãò xõ̱óan hẽéthẽé hãa koe,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Káí nea kò tciièa, igaba ne kò cg'orò ne nxárá tcg'òóèa hãa khama.” ");
INSERT INTO nhr_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xu nxãaska Farasai xu tcg'oa, a síí kàa zi xg'ae-xg'ae, nta xu gha ma kg'uian cgoa qgóó Me sa. ");
INSERT INTO nhr_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A xu a nxãaska gaxu di xu xgaa-xgaase-kg'ao xu hẽé naka Herotem di xu xùri-kg'ao xu hẽéthẽé Gam koe tsééa úú, xu síí máá: “Xgaa-xgaa-kg'ao Tseè, q'ana xae hãa tseegu di Tsi khóè Tsi i sa, a ko Nqarim dim dàò ba xgaa-xgaa sa, a c'ẽe khóè cgoa ga tchõà úú tama, khóèan di téé-q'ooan Tsi nqábé tama khama. ");
INSERT INTO nhr_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ke ncẽeska bìrí xae e, dùú sa tsi ko tc'ẽe sa: A tchànoa, Roma ne dim x'aigam Kaesara ba méém surutaè sa kana méém táá surutaè saa?” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Igabam kò Jeso ba gaxu dis kàas cg'ãè sa q'ana hãase máá: “Dùús domka xao ko kúrúa bóò Te, gaxao qãè qgóóse ko igabaga cg'ãè cau xaoè? ");
INSERT INTO nhr_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","X'aigam ko suruta cgoaèm mari ba x'áí Te,” témé. Xu gaam mari ba máà Me. ");
INSERT INTO nhr_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Me Jeso ba x'áí xu me a tẽè xu a máá: “Dìín dis tcúú sa ncẽe sa, naka gatàa dìín di cg'õèa ncẽe e?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Xu xo̱a a máá: “Kaesaram di si i,” témé. Me nxãaska bìrí xu a máá: “Eẽ Kaesaram di ii sa nxãaska Kaesara ba máà, naka ẽe Nqarim di ii sa Nqari ba máà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Eẽ xu ko ncẽe sa kóḿ ka xu kò area, khama xu kò guu Me a qõò. ");
INSERT INTO nhr_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gaam cáḿ ẽem kaga xu kò Saduke xu hàà, ncẽe x'ooan koe tẽes hàna sa dtcòm̀ tama xu, a xu a hàà tẽè Me, ");
INSERT INTO nhr_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","a máá: “Xgaa-xgaa-kg'ao Tseè, Moshe ba kò máá: ‘Khóèm kò x'óó, cóá úú tamase, ne méém qõese ba ẽes khóès káà kg'áò-khoe sa séè naka káíkhoe ba cóán ábà máá,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Nxãaska xu kò 7 xu khóè qõeku xu hàna, gatá cgoa kò x'ãèa xu. Tc'ãà di ba kò séèa hãa, a ba a cóá úú tamase x'óó, a kò qõese ba khóè sa qaùa máá. ");
INSERT INTO nhr_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Me kò cám̀ di ba gataga hẽé, nqoana di ba hẽéthẽé e, Me nxãakg'ai ga síí 7 di ba tcãà. ");
INSERT INTO nhr_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Si wèéa xu qãá q'oo koe khóès ga sa x'óó. ");
INSERT INTO nhr_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ka sa gha nxãaska x'ooan koe i kò tẽeèm cáḿ ka ndakam di saa, ẽe xu 7 xu ka? Wèéa xu kò úú sia hãa ka,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Me Jeso ba xo̱a xu a máá: “Tsa̱a xao hãa, Nqarim di zi Tcgãya zi ko méé sa hẽé naka Nqarim di qarian hẽéthẽé xao c'úùa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Eẽ ne ko khóè ne x'ooan koe tẽe ne i gha séèkuan káà ii khama, ne gataga séèkuan kgoara mááè tama, igaba ne gha nqarikg'ai di moengelean khama ii. ");
INSERT INTO nhr_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","X'ooan koe ghùiès ka: A nxárá ta ga xao gáé hãa, Nqarim gatu koe nxàea hãa sa? Ncẽem kò máá: ");
INSERT INTO nhr_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Tíí Ra Nqarim Abrahamam di Ra a, a Nqarim Isakam di Ra a, a Nqarim Jakobem di Ra a,’ témé ka. X'óóa ne dim Nqarim tama Me e, igabagam kg'õèa hãa ne di Me e,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Eẽ zi ko xg'ae zi kóḿ Me, ka zi kò Gam di xgaa-xgaan ka arekaguè. ");
INSERT INTO nhr_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Eẽ xu ko Farasai xu kóḿ, Saduke xum kò tcẽekg'am kg'áḿ sa, ka xu kò xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me gaxu ka c'ẽe ba, ncẽe x'áè q'ãa-kg'ao kò ii ba, qáé Mem gha qgáì nem ko qaa khama tẽè Me a máá: ");
INSERT INTO nhr_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Xgaa-xgaa-kg'ao Tseè, x'áèan q'oo koe ba ndakam x'áè-kg'áḿ ba kaia?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Me bìrí me a máá: “‘X'aigam tsarim Nqari ba méé tsi wèé tcáóa tsi cgoa hẽé, naka wèé kg'õèa tsi cgoa hẽé naka wèé tc'ẽea tsi cgoa hẽéthẽé ncàm̀.’ ");
INSERT INTO nhr_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","“Ncẽea tc'ãà di a kaiam x'áè-kg'áḿ ga me e. ");
INSERT INTO nhr_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Me cám̀ di ba ko gam cgoa qõòa mááku a ko máá: ‘Tsáá ka c'ẽe ba ncàm̀, ẽe tsi ma ncàm̀sea khamaga ma,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","“Ncẽe tsara x'áè-kg'áḿ tsara koe i wèé x'áèan ga hẽé naka porofiti xu ka góáèas ga sa hẽéthẽé qgóó xg'aeèa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Eẽ xu ko Farasai xu xg'aea hãa kam kò Jeso ba tẽè xu ");
INSERT INTO nhr_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","a máá: “Krestem ka xao ko ntama ma tc'ẽe? Dìín dim tsgõo-coa baa?” témé. Xu bìrí Me a máá: “Dafitem ka tsgõose-coa Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Me bìrí xu a máá: “Gatà i ko ii ne, ne ba kò kháé nxãaska Dafite ba dùús domka Tcom-tcomsam Tc'ẽem ka kg'uikaguè a ‘X'aiga ba’ ta ma ma tcii Me, ncẽem kòo máá: ");
INSERT INTO nhr_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘X'aigam Nqari ba kò Tirim X'aiga ba bìrí a máá: ‘Kg'áò xòèa Te dim x'õàm koe méé tsi ntcõó, nakar gha nxãakg'aiga síí tsari cg'õo-kg'aoan nqàrè-kg'ama tsi ka nqãaka tòó,’ témé ka. ");
INSERT INTO nhr_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“A ncẽè Dafitem kòo ‘X'aiga ba’ ta ma ma tcii Me ne ba gha nxãaska ntama ma gam dim tsgõo-coa ba ii?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","I kò cúí khóè ga táá kgoana a Jeso ba xo̱a, i kò ẽem cáḿ koe guu a khóè ne bèe a táá gaicara c'ẽe tẽè ga tẽè Me. ");
INSERT INTO nhr_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Me nxãaska Jeso ba xg'ae zi hẽé naka xgaa-xgaase-kg'ao xu hẽéthẽé bìrí a máá: ");
INSERT INTO nhr_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“X'áè xgaa-xgaa-kg'ao xu hẽé naka Farasai xu hẽéthẽéa Moshem dis téé-q'oos koe hãa. ");
INSERT INTO nhr_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ke méé tu wèé zi gúù zi ẽe xu ko bìrí tu u zi kúrú naka qgóóa qari zi. Igaba ẽe xu ko kúrú zi táá kúrú guu, ẽe xu ko xgaa-xgaa sa xu kúrú tama ke. ");
INSERT INTO nhr_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kaia zi xgàm zi qóḿ zi xu ko qáé a khóèan nxa̱ra koe tòó, igaba xu gaxu tshàua xu ka ghùi a nxònokagu zia hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Wèé zi gúù zi kúrú xu ko zi, xu ko khóèan gha bóò zi ka kúrú zi: gaxu di zi tcãà tcúú zi hẽé naka horo q'óḿ zi hẽéthẽé, còrè di kg'uian góásea hãa zi xu ko tchàa-tchaa, a xu a gaxu di qgáían di x'õàn qáò-qao. ");
INSERT INTO nhr_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tcomkuan di zi qgáì zi xu ncàm̀a hãa, naka dòàn xõe koe hẽéthẽé e, a xu a gataga còrè-nquuan koe kaia zi ntcõó-q'oo zi ncàm̀a hãa thẽé, ");
INSERT INTO nhr_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","naka x'ámágu di zi qgáì zi koe tsgám̀kaguku sa hẽéthẽé e, naka gataga khóè ne ka ‘xgaa-xgaa-kg'aoè’ ta ma tciikuan hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Igaba méé tu táá ‘xgaa-xgaa-kg'aoè’ ta ma tciiè guu, cúím Khóè ba gatu dim Xgaa-xgaa-kg'ao Me e, tu wèéa tu ga qõekua hãa ke. ");
INSERT INTO nhr_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Naka tua nqõómkg'ai koe táá cúí khóè ga ‘àboè’ ta ma tcii guu, cúím Khóè ba gatu dim Xõò Me e ke, ncẽe nqarikg'ai koe hàna ba. ");
INSERT INTO nhr_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Táá méé tu gataga ‘tc'ãà-cookg'aiè’ ta ma tciiè guu, cúím Khóè ba gatu dim Tc'ãà-cookg'ai Me e ke, Kreste ba. ");
INSERT INTO nhr_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gatu xg'aeku koe kaia hãa ba méém gatu dim qãà ba kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Wèém ẽe ko kaikaguse ba gha cg'áré-cg'areè, me gha wèém ẽe ko cg'áré-cg'arese ba kaikaguè. ");
INSERT INTO nhr_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Igaba haò, cg'ãè i gha ii gaxao ka, x'áè xgaa-xgaa-kg'ao xao hẽé naka Farasai xao hẽéthẽé e, gaxao ncẽe qãè khóèan khama ko ma kúrúse xao! Nqarikg'ai di x'aian xao ko khóè ne cookg'ai koe tcẽekg'am khama. A gaxao igaba táá tcãà, a xao a gataga ẽe tcãà kg'oana ne guu naka ne tcãà tama khama. ");
INSERT INTO nhr_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Haò, cg'ãè i gha ii gaxao ka, x'áè xgaa-xgaa-kg'ao xao hẽé naka Farasai xao hẽéthẽé e, gaxao ncẽe qãè khóèan khama ko ma kúrúse xao! Nqõó ba hẽé naka tshàa ba hẽéthẽé xao ko qõòa nxa̱ma-nxa̱ma, khóèm c'ẽes qhàòs di ba xao gha séèa mááse me hàà gaxao dis xg'aes koe tcãà ka! A ncẽè gatàm kò ko hẽé, ne xao ko kúrú mem kg'ano, chõò tamas c'ees dxãwam dis koe síía ne, cám̀ q'oro nqáé xaoa hãase. ");
INSERT INTO nhr_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Haò, cg'ãè i gha ii, gaxao tc'ãà-cookg'ai xao káà tcgáí xao ka, ncẽe ko máá: ‘Khóèm kò tempelem cgoa gaìse ne i káà hùi i, igabam kò tempelem di gautan cgoa gaìse ne méém gaas gaìse sa tséékagu,’ ta ko méé xao. ");
INSERT INTO nhr_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gaxao káà tc'ẽe xaoè, a káà tcgáí xaoè! Dùú sa cgáé saa? Gautaa, kana tempele baa, ncẽe q'ooa ba koem úúa hãa gautan ko kúrú, i Nqarim cookg'ai koe q'ano iise bóòè ba? ");
INSERT INTO nhr_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xao ko gataga máá: ‘Khóèm kò altaram cgoa gaìse ne, i káà hùi i, igabam kò ko Nqarim ko tcg'òóa mááès abas cgoa gaìse ne, ncẽe altaram koe hàna sa, ne méém gaas gaìse sa tséékagu,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gaxao káà tcgáí xaoè! Dùú sa cgáé saa? Nqarim ko tcg'òóa mááès aba saa, kana altara baa, ncẽe aba sa ko kúrú si Nqarim cookg'ai koe q'ano iise bóòè ba? ");
INSERT INTO nhr_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Gaa domkam, gaam ẽe ko altaram cgoa gaìse ba, gam cgoa hẽé naka wèés gúùs ẽe gam tc'amkg'ai koe hànas cgoa hẽéthẽé ko gaìse. ");
INSERT INTO nhr_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Gatà iim dàòm kam kò ẽe ko tempelem cgoa gaìse ba gaam cgoa hẽé, naka Gaam ẽe q'ooa ba koe x'ãèa hãam Nqarim cgoa hẽéthẽé gaìse. ");
INSERT INTO nhr_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Me ko gaam ẽe ko nqarikg'aian cgoa gaìse ba Nqarim dis ntcõó-q'oos cgoa hẽé, naka Gaam ẽe gaas koe ntcõem cgoa hẽéthẽé gaìse. ");
INSERT INTO nhr_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Haò, cg'ãè i gha ii gaxao ka, x'áè xgaa-xgaa-kg'ao xaoè naka gaxao Farasai xao ka hẽéthẽé e, qãè khóèan khama ko ma kúrúse xao! Nqari ba xao ko tc'õoan ko xg'ãò-xg'ão zi gúù zi koe cúís tshàu-q'oos dian tcg'òó a máà. Igaba xao kaisase cgáé zi gúù zi x'áèan di zi xguìa hãa khama: ncẽe qãèse qgóókuan hẽé, thõò-xama-mááku sa hẽé naka tcom-tcomsa sa hẽéthẽé zi. Qaase i ko, ncẽe zi gúù zi cgáé zi xao ga kò kúrúa hãa sa, igabaga c'ẽe zi c'urù tamase. ");
INSERT INTO nhr_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gaxao tc'ãà-cookg'ai xao káà tcgáí xaoè. Dcène ba xao ko ẽe xao ko kg'áà gúùan q'oo koe tcg'òó, igaba xao ko kamele sa tóm̀! ");
INSERT INTO nhr_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Haò, cg'ãè i gha ii, gaxao x'áè xgaa-xgaa-kg'ao xao hẽé naka Farasai xao hẽéthẽé ka, qãè khóèan khama ko ma kúrúse xao! Kubi sa hẽé naka gàba sa hẽéthẽé ka xao ko qãáa sara xg'aà, igaba sara q'ooa sara koe chìikuan hẽé naka cẽèan hẽéthẽé ka cg'oèa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Tsáá káà tcgáí tsi Farasai tseè! Kg'áíka q'ano-q'ano kubis q'oo naka gàba sa hẽéthẽé e, naka i gha nxãasega qãáa sara q'ano ii. ");
INSERT INTO nhr_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Haò, cg'ãè i gha ii gaxao ka, x'áè xgaa-xgaa-kg'ao xaoè naka gaxao Farasai xao ka hẽéthẽé e, qãè khóèan khama ko ma kúrúse xao! Xg'aàèa a q'úú zi tc'ám̀ zi khama xao ii, ncẽe tchàa za tsi kò ko bóò zi ne t'õè ii zi, igaba q'ooa zi koe x'óóa hãa khóèan di c'õán hẽé, naka wèé cg'uri qhàòan hẽéthẽé ka cg'oèa hãa zi. ");
INSERT INTO nhr_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gataga xao ii a khóè ne koe tchàa za tchàno khóèan di bóòse-q'ooan úúa, igaba xao q'ooa xao koe cg'ãè cauan ka hẽé naka cg'urian ka hẽéthẽé cg'oèa hãa. ");
INSERT INTO nhr_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Haò, cg'ãè i gha ii gaxao ka, x'áè xgaa-xgaa-kg'ao xaoè naka gaxao Farasai xao ka hẽéthẽé e, naka qãè qgóóse ko igaba cg'ãè cau xao hẽéthẽé e! Porofiti xu di zi tc'ám̀ zi koe xao ko dqo̱m̀ cgoaè xu gha zi gúù zi tshàoa tòó, a xao a ko ẽe kò tchàno ii ne di tc'ám̀an t'õè-t'õe. ");
INSERT INTO nhr_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","A xao a ko máá: ‘Sixae ka tsgõosea xu di x'aèan ka xae kò xg'ao kg'õèa hãa ne, xae ga xg'ao porofiti xu di c'áòan ntcã̱água hãa tama,’ ta ko méé xao. ");
INSERT INTO nhr_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ncẽeta mééan ka xao ko nxàea tseegukagua mááse, ẽe xg'ao porofitian cg'õo ne di xao tsgõo-coa xao o sa. ");
INSERT INTO nhr_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ke méé xao ncẽeska gaxao ka tsgõose ga xu di chìbian xg'ara-xg'ara. ");
INSERT INTO nhr_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gaxao cg'ao xaoè! A dcàùan di xao cóá xaoè! Nta xao gha ma chõò tamas c'ees dxãwam dis koe xgàrakuan bèe? ");
INSERT INTO nhr_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Q'ãa méé xao: porofiti xu hẽé, naka tc'ẽega xu khóè xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽér ko tsééa úú sa. Xao gha c'ẽe-kg'áía xu cg'õo, a gha c'ẽe xu xgàu, a gha c'ẽe xu gaxao di còrè-nquuan koe xg'áḿ, a xao a gha wèé xu x'áé-dxoo xu koe xgàra. ");
INSERT INTO nhr_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ncẽes gúù sa gha kúrúse, nxãasega xao gha xgàraè ka, káà chìbi ne khóè ne di c'áòan xao góḿan koe ntcã̱àgua khama. Ncẽes ntcã̱àgu c'áòku sa kò tchànom khóèm Abelem koe guu a tshoa-tshoa, a síí Sakariam, Barakiam dim cóám koe tcãà, ncẽe xao xg'ao tempele ba hẽé naka altara ba hẽéthẽé xg'aeku koe cg'õoa ba. ");
INSERT INTO nhr_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tseegukar ko bìrí xao o a ko máá: Wèéan ncẽea gha ncẽem x'aèm di ne khóè ne koe hàà kúrúse, témé. ");
INSERT INTO nhr_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Oo! Jerusalemaè, Jerusalemaè, tsáá ncẽe ko porofitian cg'õo tsi, a ko ẽe tsáá koe tsééèa hãa xu nxõ̱án cgoa cg'õo tsi. Nta noose ra kò tc'ẽea hãa, tsari khóèa ner gha xg'ae-xg'ae sa, ghòròs ko ma cóáa sa tcgàmàa sa dòm̀ q'oo koe ma xg'ae-xg'ae khama, igaba tu kò tc'ẽe e tama. ");
INSERT INTO nhr_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Q'ãa méé xao, gaxao dim tempele ba xao gha cg'ãa-cg'anasea hãase guua mááè sa. ");
INSERT INTO nhr_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bìrí xao or ko, cuiskaga xao gaicara bóò Te tite, a xao a gha nxãakg'aiga máá: ‘Gaam ẽe ko X'aigam Nqarim dim cg'õèm cgoa hàà ba ts'ee-ts'eekg'aièa,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jeso ba kò tempelem koe guu a tcg'oa a ba a qõò, xu Gam di xu xgaa-xgaase-kg'ao xu hàà cgae Me, hàà xu gha gaa nquuan tempelem di x'áí Me ka. ");
INSERT INTO nhr_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Me xo̱a xu a máá: “Wèéan ncẽe ga xao ko bóò na? Tseegukar ko bìrí xao o: Cuiskagas ncẽe koe cúís nxõ̱ás ga sa c'ẽes tc'amkg'ai koe guuèa hãa tite, wèéa zi ga gha xòóa qàrìè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Eẽm Jeso ba Olife dim xàbìm koe ntcõóa-ntcõe, ka xu kò xgaa-xgaase-kg'ao xu cúíaga hàà cgae Me, a máá: “Bìrí xae e, n-cáḿa i gha ncẽe gúùan kúrúse sa, i gha gataga Tsari hàà-q'ooan hẽé naka nqõóm di chõò-q'ooan hẽéthẽé dùús ka x'áíè sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Me Jeso ba xo̱a xu a máá: “Q'ãa xao naka i táá cúí khóè ga ho̱àkagu xao o guu. ");
INSERT INTO nhr_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Káí ne gha Tirim cg'õèm cgoa hàà, a máá: ‘Tíí ra Kreste ra a,’ témé, a ne a gha káí ne ho̱àkagu ke. ");
INSERT INTO nhr_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tu gha ncõoan hẽé naka ncõoan di zi nxàe zi ka hẽéthẽé kóḿ, igaba bóò naka tu táá q'aekaguè guu. Gatà ii zi gúù zi méé zi kúrúse ke, igaba i qanega chõò-q'ooan hàà ta ga hãa. ");
INSERT INTO nhr_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nqõóm di zi qhàò zi gha c'ẽe zi qhàò zi cgoa x'ãàku, i gha x'aian x'aian cgoa x'ãàku, i xàbàn hãa, i nqõóan di cgùruan káí zi qgáì zi koe hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Wèé zi ncẽe zia ábàn di thõòan di zi tshoa-tshoase-q'oo zi khamaga xám̀. ");
INSERT INTO nhr_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ne gha nxãaska xgàrakuan koe tcãà tu u, a cg'õo tu u. Tu gha Tiri cg'õèan domka nqõóm di zi qhàò zi wèé zi ka hòreè. ");
INSERT INTO nhr_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nxãaska ne gha káí ne gane di dtcòm̀an aagu, a gha qáékuan koe tcãàku, a ne a gha gane ka c'ẽea ne hòre. ");
INSERT INTO nhr_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","I gha tshúù-ntcõan di porofitian káí x'áíse, a káí ne khóè ne ho̱àkagu. ");
INSERT INTO nhr_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cg'ãèan di càùse-q'ooan domka i gha káí khóèan di ncàm̀kuan qgài, ");
INSERT INTO nhr_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","igaba gaam ẽe ko qarika téé a chõò-q'oos koe síí ba gha kgoaraè. ");
INSERT INTO nhr_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","I gha Nqarim di x'aian di qãè tchõàn wèém nqõóm koe xgaa-xgaaè, x'áís iise nqõóm di zi qhàò zi wèé zi koe, si gha nxãaska chõò-q'oo sa hàà. ");
INSERT INTO nhr_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Eẽ tu ko q'áò-q'aosas gúù sa bóò, ncẽe ko tcom-tcomsam qgáì ba kúrú me xãòm khama ii sa, si gaa koe téé-tẽe. Porofitim Danielem kò tcom-tcomsam qgáìm koe hãase gaas ka kg'ui sa (ẽe ko nxárá ba méém kóḿa q'ãa). ");
INSERT INTO nhr_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ne méé ne nxãaska ẽe Jutea koe hàna ne xàbìan koe qgóéa síí, ");
INSERT INTO nhr_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","nakam ẽe nquuan tco̱be koe hàna ba táá xõa na síí ẽe nquuan q'oo koe hãa sa séè guu, ");
INSERT INTO nhr_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","nakam ẽe xháràn koe hàna ba táá ka̱bise naka síí gam di qgáían séè guu. ");
INSERT INTO nhr_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Haò, cg'ãè i gha ii, ẽe zi cáḿ zi ka ẽe ncãà zi koe cóán úúa zi khóè zi ka hẽé naka ẽe gha ko comkagu zi ka hẽéthẽé e! ");
INSERT INTO nhr_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Còrè naka i gha gatu di qgóéan táá sao di x'aè ka hãa guu kana Sabata dim cáḿ ka. ");
INSERT INTO nhr_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nxãaska i gha kaia xgàrakuan hãa ke, ncẽe nqõóm dis tshoa-tshoases koe guu a qanega hãa tama a, ncẽes noose ga, a i a gaicara hãa tite e. ");
INSERT INTO nhr_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","A ncẽè ẽe xu cáḿ xu kò xòm̀-xommè ta ga hãa ne, i cúí khóè ga kgoaraèa hãa tite, igaba xu gha ẽe nxárá tcg'òóèa hãa ne domka ẽe xu cáḿ xu xòm̀-xommè. ");
INSERT INTO nhr_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“A ncẽè ẽem x'aèm kam kò c'ẽem khóè ba bìrí tu u a ko máá: ‘Bóò, ncẽe ga Me e Kreste ba,’ kana máá: ‘Eẽ gam síí hãa,’ témé ne, méé tu táá dtcòm̀ m guu. ");
INSERT INTO nhr_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tshúù-ntcõan di xu Kreste xu hẽé naka tshúù-ntcõan di xu porofiti xu hẽéthẽéa gha x'áíse, a kaia zi x'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé kúrú ke, ẽe nxárá tcg'òóèa ne xu gha ho̱àkagu ka, kgoanase i kòo ne. ");
INSERT INTO nhr_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Bóò, x'aèan cookg'ai koer kò bìrí tu ua. ");
INSERT INTO nhr_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“A ncẽè gatu ka ne kòo máá: ‘Bóò, tchàa-xgóóm koem hãa,’ témé ne méé tu táá tcg'oa naka qõò guu. A ncẽè gaicara ne kòo máá: ‘Bóò, nquum q'oo koem hàna,’ témé ne méé tu táá dtcòm̀ guu. ");
INSERT INTO nhr_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Cáḿs ko tcg'oa xòè koe i ko ma túú-tebean guu a cáḿs ko tcãà xòè koe ma síí bóòse khama i gha ma Khóèm dim Cóám di hàà-q'ooan ii. ");
INSERT INTO nhr_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eẽ x'óóa hãam tc'áróm hãa qgáì koe i gha kg'ãean xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Eẽ xu cáḿ xu di xgàrakuan qãá q'oo koes gha kúúga cáḿ sa ntcùú-ntcuuè, Me nxoe ba x'áà tite, i gha tco̱nòan nqarikg'ai koe guu a tcheè, i gha nqarikg'ai di qarian ntcãa-ntcãaè. ");
INSERT INTO nhr_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Eẽm x'aèm kas gha Khóèm dim Cóám dis x'áí sa nqarikg'ai koe x'áíse, zi gha wèé zi qhàò zi nqõómkg'ai di zi kg'ae, a zi a gha Khóèm dim Cóá ba bóò, Me nqarikg'ai di túú-c'õòan koe guu a ko hàà, qarian hẽé naka kaia x'áàn hẽéthẽé cgoa. ");
INSERT INTO nhr_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Me gha Gam di xu moengele xu kaiam q'aum torompitam dim cgoa tsééa tcg'òó, xu gha Gam nxárá tcg'òóa hãa ne wèé xòèan ẽe tc'ãán ko guu za xg'ae-xg'ae, nqarikg'ai dim chõò-q'oom c'ẽem koe guu a síí c'ẽem koe tééan koe. ");
INSERT INTO nhr_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Ke tu ncẽes gúùs faia dis hìis koe kúrúsea hãas koe xgaa-xgaase: ẽe i ko gas di nxã̱àn tshoa-tshoa a ko tso̱m, i ko to̱ara sa tso̱m, ne tu q'ana hãa qhóóa ne tcana hãa sa. ");
INSERT INTO nhr_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gataga ẽe tu kòo ncẽe zi gúù zi wèé zi bóò ne tu q'ana hãa cúù Me e sa, a nquu-kg'áḿan koe hãa. ");
INSERT INTO nhr_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tseegukar ko bìrí tu u a ko máá: Ncẽes qhàò sa kaà tite, i gha nxãakg'aiga síí ncẽe gúùan wèé ga kúrúse. ");
INSERT INTO nhr_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nqarikg'aian hẽé naka nqõókg'aian hẽéthẽéa gha chõò, igaba i Tiri kg'uian chõò tite. ");
INSERT INTO nhr_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Igabaga i cúí khóè ga ẽem cáḿ ba kana ẽem x'aè ba q'ãa tama, moengele xu nqarikg'ai di xu ga igaba kana Cóám ga igaba, Xõòm cúím ka oose. ");
INSERT INTO nhr_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nowam di x'aèan ka i kò ii khama i gha Khóèm dim Cóám di hàà-q'ooan ii khama. ");
INSERT INTO nhr_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Eẽ xu cáḿ xu ka kaiam tshàam hàà tama cookg'ai koe ne kòo tc'õó a ko kg'áà, a ko séèku, a ko séèkuan bìríku, me nxãakg'aiga síí Nowam ko arakam koe tcãàm cáḿ ba hàà, ");
INSERT INTO nhr_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","igaba ne kò cúí gúù ga c'úùa dùús ko hàà kúrúse sa, me nxãakg'aiga kaiam tshàa ba hàà, a hàà tchùua tcg'òó ne. Gatà i gha Khóèm dim Cóám di hàà-q'ooan ii. ");
INSERT INTO nhr_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Cám̀ tsara khóè tsara gha xháràm koe hãa. C'ẽe ba gha séèè, me gha c'ẽe ba guuè. ");
INSERT INTO nhr_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Cám̀ sara khóè sara gha hãa a ko ha̱kg'um koe maberean táó. C'ẽe sa gha séèè, si gha c'ẽe sa guuè. ");
INSERT INTO nhr_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Gaa domka méé tu kòresea hãa, dùútsa cáḿ kam gha gatu dim X'aigam Nqari ba hàà sa tu c'úùa hãa ke. ");
INSERT INTO nhr_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Igaba méé tu ncẽe sa q'ana hãa: Ncẽè nquu ba kàoa hãam khóèm kò q'ana, dùútsa x'aè kam ko ts'ãà-kg'ao ba ntcùú ka hàà sa, nem ga kò ẽem x'aèm ka kòrea hãa, a táá kúrú me gam dim nquu ba khõáè. ");
INSERT INTO nhr_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gaa domka méé tu gatu igaba wèé x'aè ka kg'ónòsea. Khóèm dim Cóá ba ko ẽe tsi q'ãa tamam x'aèm ka hàà ke. ");
INSERT INTO nhr_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kháé dìí ba nxãaska tcom-tcomsa a tc'ẽegam qãà baa? Ncẽe gam ka q'õòsem ko nquua ba di qarian máà ba, me qãè x'aè ka gaxu di tc'õoan máà xu ba? ");
INSERT INTO nhr_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ts'ee-ts'eekg'aièa baa ẽem qãà ba, ncẽe gam ka q'õòsem ko hàà nem ko hàà sao-xg'ae me ko gatà hẽé ba. ");
INSERT INTO nhr_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tseegukar ko bìrí tu u a ko máá; wèé zi gúù zi ẽem úúa hãa zi di qaria nem gha gam koe tòó. ");
INSERT INTO nhr_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Igaba ẽem qãàm cg'ãèm kò ko tcáóa ba koe bìríse a ko máá: ‘Tíí q'õò ba ão me e,’ témé, ");
INSERT INTO nhr_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","a ba a tshoa-tshoa a qãà ne gam ka c'ẽe ne xg'áḿ, a ko tc'õó a ko kg'áà-kg'aoan cgoa kg'áà, ");
INSERT INTO nhr_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nem gha ẽem qãàm ka q'õòse ba tcom tamam hãam cáḿ ka hàà, c'úùam hãa x'aè ka, ");
INSERT INTO nhr_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","a ba a gha hàà xgàra me, a qãè qgóóse ko igaba cg'ãè cau khóèan cgoa xg'ae-xg'ae me, ncẽe gaa koe i gha kg'aean hẽé naka gãò xõ̱óan hẽéthẽé hãa koe.” ");
INSERT INTO nhr_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Gaa x'aè ka i gha nqarikg'ai di x'aian 10 zi dxàe-coa zi cgoa nxárá xg'aeè. Gazi di lampian zi kò séè a zi a síí séèkom khóè ba qãà, xg'ae cgoa me zi gha ka. ");
INSERT INTO nhr_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gazi ka 5 zia kò káà tc'ẽe ii, zi 5 zi tc'ẽega ii. ");
INSERT INTO nhr_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Káà tc'ẽe zi kò lampia zi séè, gabà zi ko táá nxúìan séèa mááse. ");
INSERT INTO nhr_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Zi tc'ẽega zi lampian séè a zi a nxúìan gàban koe séèa mááse. ");
INSERT INTO nhr_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Me séè-kg'ao ba táá qháése hàà, ka zi ko wèéa zi ga x'óm̀, x'óm̀a zi ko cg'áé khama. ");
INSERT INTO nhr_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ntcùú nqáè kam kò q'au ba tcg'oa a máá: ‘Bóò, séè-kg'aom ga me e síí ko hàà ba, ke tcg'oa naka hàà xg'ae cgoa me!’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ka zi ko wèé zi dxàe-coa zi tẽe a lampia zi kg'ónò. ");
INSERT INTO nhr_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Zi káà tc'ẽe zi tc'ẽega zi bìrí a máá: ‘Au se e nxúìa ne gasao di nxúìan koe, gase di lampia nea ko ts'irì ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Zi tc'ẽega zi xo̱a a máá: ‘Cuiskaga i wèéa se ga tc'ãò tite. Ke qõò sao ẽe ko x'ámágu u ne koe naka saoa síí x'ámá mááse e,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Igaba ẽe zi dàò q'oo koe hãa, síí zi gha gaa nxúìan x'ámá, kam kò séè-kg'ao ba hàà. Zi dxàe-coa zi ẽe ko kg'ónòsea zi kõ̱ès séèkuan dis koe gam cgoa tcãà, me nquu-kg'áḿ ba tcẽekg'ammè. ");
INSERT INTO nhr_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Gam x'aè-coam qãá q'oo koe zi gha c'ẽe zi dxàe-coa zi gataga hàà, a hàà máá: ‘X'aigaè, x'aigaè, xgobekg'ama máá se e,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Igabam kò xo̱a a máá: ‘Tseegua ner ko bìrí sao o: C'úù saoa ra hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Gaa domka méé tu kòresea, cáḿ ba hẽé naka x'aè ba hẽéthẽé tu c'úùa hãa ke,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Gaicara i gha nqarikg'ai di x'aian c'ẽem nqõóm koe xóé a ko qõòm khóèm khama ii, gam di xu qãà xu ko tcii a ba a gam di zi gúù zi gaxu tshàu q'oo koe tcãà ba. ");
INSERT INTO nhr_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","A cúí ba 5 xu cãa xu marian di xu máà, a c'ẽe ba cám̀ cãan máà, a c'ẽe ba cúím cãa ba máà. Wèém khóè bam kò gam di qarian di tc'ãò-tc'ãoan cgoa máà. A ba a tshoa-tshoa a dàòa ba koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Me 5 xu cãa xu marian di xu máàèam khóè ba kúúga qõò a ba a síí tséékagu u, a gaicara c'ẽe xu cãa xu 5 xu kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Me gataga ẽe kò cám̀ cãa tsara máàèa ba c'ẽe tsara kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Igabam kò cúím cãam mari di ba máàèa ba qõò a síí góḿankg'ai koe ha̱é ba tshào, a gam ka q'õòsem dim cãa ba kã̱é. ");
INSERT INTO nhr_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Qáòm x'aèm qãá q'oo koem kò ẽe xu qãà xu ka q'õòse ba ka̱bise a hàà cgae xu, a gaa marian xu ma tséékagua sa hàà nxàe cgoa xu. ");
INSERT INTO nhr_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Me khóèm ẽe kò 5 xu cãa xu máàèa ba cúù-cuuse a 5 xu cãa xu c'ẽe xu úú, a ba a máá: ‘Tíí q'õòè, 5 xu cãa xu tsi kò máà tea hãa. Bóò, 5 xu cãa xu c'ẽe xur kúrúa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Me gam ka q'õòse ba bìrí me a máá: ‘Qãèse tsi kúrúa, tsáá qãè a tcom-tcomsa tsi qãà tsi. Cg'áré gúùan koe tsi kò tcom-tcomsa ii, ra gha káí zi gúù zi di qarian máà tsi. Tcãà naka tsia tsáá q'õòr cgoa qãè-tcao,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Me gataga cám̀ cãa tsara ko máàèa ba cúù-cuuse a ba a máá: ‘Tíí q'õòè, cám̀ tsara cãa tsara tsi kò máà tea. Bóò, c'ẽe tsara cãa tsarar kúrúa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Me gam ka q'õòse ba bìrí me a máá: ‘Qãèse tsi kúrúa, tsáá qãè a tcom-tcomsa tsi qãà tsi. Cg'áré gúùan koe tsi kò tcom-tcomsa ii, ra gha káí zi gúù zi di qarian máà tsi. Tcãà naka tsia tsáá q'õòr cgoa qãè-tcao,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Gatagam kò cúím cãa ba kò máàèa ba hàà a máá: ‘Tíí q'õòè, q'ana ra hãa tsi kàa tsi khóè tsi i, a tsi a ko xhárà tama tsi hãa koe ga tcuù, a ko qanega tsi cgùrian tsa̱i-tsa̱i tama koe ga sáà sa. ");
INSERT INTO nhr_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ra kò nxãaska q'áò tsi, a ra a qõò a síí tsarim cãa ba góḿan q'oo koe kã̱é. Bóò, ncẽe ga ia tsari gúùa ne,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Me gam ka q'õòse ba xo̱a me a máá: ‘Tsáá cg'ãè cau a kg'amka tsi qãà tsi! Q'ana tsia, xhárà tama ra hãa koe ga ra ko tcuù sa, a ra a ko qanega ra cgùrian tsa̱i-tsa̱i tama koe ga sáà sa. ");
INSERT INTO nhr_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Khama tsi ga kò marian ko tòóè koe marian tiri úúa, ne i ga kò ncẽeska càùsea, ra ka̱bise a hàà séè e, càùsea i hãase. ");
INSERT INTO nhr_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Ke xao gam koe cãa ba séèa ka̱bi, naka ẽe 10 xu cãa xu úúa hãa ba máà me. ");
INSERT INTO nhr_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Wèém khóèm ẽe c'ẽe gúùan úúa ba gha máàè, a ba a gha káían úú, igabaga ẽe cúí gúù ga úú tama ba gha ẽem úúa hãa gúù-coan ga séè cgaeè khama. ");
INSERT INTO nhr_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Naka xaoa ẽe káà tséém qãà ba tchàa za dcùú-qoms q'oo koe xaoa tcãà. Ncẽe gaa za i gha kg'aean hẽé naka gãò xõ̱óan hẽéthẽé hãa koe,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Khóèm dim Cóám kò Gaam dim x'áàm koe hãase hàà naka wèé xu moengele xu Gaam di xu cgoa hẽéthẽé e, nem gha Gaam di x'áàn dis ntcõó-q'oos koe hàà ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Zi gha nqõóm di zi qhàò zi wèé zi Gaam cookg'ai koe xg'ae-xg'aeè, Me gha hàà c'ẽe zi koe q'aa-q'aa zi, ẽem ko ma kòre-kg'ao ba ma ghùuan pirian koe ma q'aa-q'aa khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ghùua nem gha Gam dim x'õàm kg'áòm xòè za tòó, a ba a pirian dxàes x'õàs xòè za tòó. ");
INSERT INTO nhr_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Me gha X'aiga ba nxãaska kg'áòm x'õàm xòè di ne bìrí a máá: ‘Hàà gatu ẽe Abom ka ts'ee-ts'eekg'aièa tu, x'aian di ntcõó-q'ooan xáè, ncẽe tu kò nqõóm tshoa-tshoasea koe guu a kg'ónòa máàèa a. ");
INSERT INTO nhr_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Xàbàr kò hãa, tu tc'õoan máà ter tc'õó, ra kò cáḿa hãa tu c'ẽe gúùan máà ter kg'áà, ra kò tãá za guuar khóè ra ii, tu x'áéa tu koe qãèse qgóó te, ");
INSERT INTO nhr_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","qg'aè-cgaear kò hãa tu hã̱akagu te, ra kòo tsàa tu q'õé te, ra kòo qáé-nquus koe hàna tu hàà kabi te khama,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Gaa x'aè ka ne gha ẽe tchàno ne xo̱a Me a máá: ‘X'aigaè, n-cáḿa ta kò bóò Tsia Tsi xàbàa hãa, ta tc'õókagu Tsia, Tsi cáḿa hãa ta c'ẽe gúù au Tsi, Tsi kg'áàa hãa? ");
INSERT INTO nhr_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ta kò n-cáḿa bóò Tsi, Tsi tãá za guua Tsi khóè Tsia, ta x'áéa ta koe qãèse qgóó Tsia, ta n-cáḿa bóò Tsi, Tsi qg'aè-cgaea, ta hã̱akagu Tsia? ");
INSERT INTO nhr_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ta kò n-cáḿá bóò Tsi, Tsi ko tsàa, kana qáé-nquus koe tcãàèa, ta síí kabi Tsia?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Me gha X'aiga ba xo̱a ne a máá: ‘Tseegua ner ko bìrí tu u: Wèés gúùs ẽe tu Tíí ka c'ẽe ne ncẽe ne cg'áré ne ka cúía ne koe ga kúrúa sa, tu Tíí ga ra kúrúa máánaa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Me gha nxãaska ẽe dxàes x'õàs xòè di ne bìrí a máá: ‘Tcg'oa cgae Te tu, gatu ẽe chõò tama c'eean koe cgúísea hãa tu, dxãwa ba hẽé naka Gam di xu moengele xu hẽéthẽé kg'ónòa mááèa ba. ");
INSERT INTO nhr_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Xàbàr kò hãa, tu táá gúù máà ter tc'õó, ra ko cáḿaa, tu táá gúù máà ter kg'áà, ");
INSERT INTO nhr_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","tãá za guuar khóè ra a kò ii, tu táá x'áéa tu koe qãèse qgóó Te, qg'aè-cgaear kò hãa, tu táá hã̱akagu Te, ra kòo tsàa, a qáé-nquus koe hàna, tu táá kabi Te khama,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Nxãaska ne gha gane igaba gataga xo̱a a máá: ‘X'aigaè, n-cáḿa ta bóò Tsi Tsi xàbàa, a cáḿaa, a tãá za guua Tsi khóè Tsia, a qg'aè-cgaea, a kòo tsàa, a qáé-nquus koe hàna, ta táá hùi Tsia?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Me gha nxãaska xo̱a ne a máá: ‘Tseegukar ko bìrí tu u: Wèés gúùs ẽe tu ncẽe ne cg'áré ne ka cúía ne kúrúa máá tama sa, nxãa sa tu Tíí ga ra kúrúa máá tama thẽé,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ne gha nxãaska chõò tamas xgàrakus koe qõò, ne gha ẽe tchàno ne chõò tamas kg'õès koe qõò,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Eẽm ko Jeso ba gaa zi kg'ui zi kg'uia xg'ara kam kò Gaam di xu xgaa-xgaase-kg'ao xu bìrí a máá: ");
INSERT INTO nhr_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Q'ana xao hãa, Paseka dis kõ̱è sa cám̀ cáḿan qãá q'oo koe hãa sa, Me gha Khóèm dim Cóá ba khóè ne tshàu q'oo koe tcãàè, nxãasegam gha xgàuè ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Xu kò nxãaska kaia xu peresiti xu hẽé, naka khóè ne di xu kaia xu hẽéthẽé kaiam peresitim Kaifase ta ko ma tciièm dis qhàìs koe xg'ae, ");
INSERT INTO nhr_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","a xu a Jeso ba xu gha qgóó a cg'õo di kàan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Igaba xu ko máá: “Kõ̱ès di x'aè ka tamase, nxãaskas gha kaias xg'ore sa khóè ne xg'aeku koe hãa khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Eẽm ko Jeso ba Betania koe hãa, Simonem ncẽe xg'ao lepero dis tcìì sa tsàara hãam dim nquum koe ");
INSERT INTO nhr_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","kas kò khóè sa hàà cgae Me, kaisa marian ka x'ámáèa tshãán qgóó a, alabasetere di nxõ̱án cgoa kúrúèam ts'oo-c'õà-coam koe hàna a, a sa a ntcõó a ba a kò tc'õó koe hàà ntcã̱á tcúú Me. ");
INSERT INTO nhr_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eẽ xu ko Gam di xu xgaa-xgaase-kg'ao xu ncẽe sa bóò ka xu kò xgóà a máá: “Dùús ka sa ko ncẽeta ma ma kõ̱è cgoa a? ");
INSERT INTO nhr_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ncẽe tshãá nea ga kò káí marian cgoa x'ámáguèa, i ga kò gaan di marian dxàua ne khóè ne máàèa hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Igabam kò Jeso ba ncẽe sa q'ana hãase bìrí xu a máá: “Dùús ka xao ko khóè sa xgáèa máá? T'õès tséé sas Tíí koe kúrúa hãa ka. ");
INSERT INTO nhr_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dxàua ne khóè ne cgoa xao gha wèé x'aè ka hãa, igaba xao wèé x'aè ka Tíí cgoa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ncẽes ncãa ko ncẽe tshãán cgoa ntcã̱á tc'áró Te kas ncãa ko kg'ónòa máá Te kg'ónòkuan Tiri i. ");
INSERT INTO nhr_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tseegukar ko bìrí xao o a ko máá: Wèém nqõóm ẽe i ko ncẽe qãè tchõàn xgaa-xgaaèm koe i gha ẽes kúrúa hãa gúùan nxàeè, tc'ẽe-tc'ẽeseès gha ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Me kò nxãaska 12 xu ka c'ẽe ba ncẽe Jutase Isekariote ta ko ma tciiè ba, kaia xu peresiti xu koe síí, ");
INSERT INTO nhr_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","a ba a máá: “Dùú sa xao máà te kg'oana, ncẽè gaxao tshàu q'oo koer kò tcãà Me ne?” témé. Ka xu kò 30 marian seleferan di kg'ónò máá me. ");
INSERT INTO nhr_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Me gaam x'aèm kaga Jutase tshoa-tshoa a qaa, ntamam gha ma gaxu tshàu q'oo koe tcãà Me sa. ");
INSERT INTO nhr_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tc'ãá dim cáḿ péré gãé-gãe úú tamas pérés di kõ̱èan dim ka xu kò xgaa-xgaase-kg'ao xu Jesom koe hàà a máá: “Nda koe xae gha kg'ónòa máá Tsi, naka Tsi síí gaa koe Paseka di tc'õoan tc'õó sa Tsi ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Me xo̱a a máá: “Qõò naka x'áé-dxoom koe síí, c'ẽem khóèm koe naka bìrí me naka máá: ‘Xgaa-xgaa-kg'ao ba ko máá: ‘Tsarim nquum koer gha Tiri xu xgaa-xgaase-kg'ao xu cgoa Paseka di ghùu-coan kg'oo,’ témé,’” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Xu xgaa-xgaase-kg'ao xu ẽem ma Jeso ba bìrí xua hãa khama ma kúrú, a Paseka di tc'õoan kg'ónò. ");
INSERT INTO nhr_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Eẽ i ko dqòa kam kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu 12 xu cgoa qa̱ò. ");
INSERT INTO nhr_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eẽ xu hãa a ko tc'õó kam ko máá: “Tseegukar ko bìrí xao o, gaxao ka c'ẽe ba gha khóè ne tshàu q'oo koe tcãà Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xu kò kaisase tshúù-tcao, a xu a wèéa xu tshoa-tshoa a cúí mana cúí tẽè Me a máá: “A tíí tama raa, X'aigaè?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Me Jeso ba xo̱a a máá: “Eẽ Tíí cgoa tshàua ba gàbas q'oo koe tcana hãa ba gha khóè ne tshàu q'oo koe tcãà Te. ");
INSERT INTO nhr_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Eẽ i ma Khóèm dim Cóám ka ma góásea khamaga i gha ii. Igaba haò, cg'ãè i gha ii, ẽe ko Khóèm dim Cóá ba khóè ne tshàu q'oo koe tcãàm ka! Qãèa i ga kò máá mea hãa, táám ga kò ábàèa hãa sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Me Jutasem ẽe ko hàà khóè ne tshàu q'oo koe tcãà Me ba máá: “A tíí tama raa, xgaa-xgaa-kg'ao Tseè?” témé. Me Jeso ba xo̱a me a máá: “Ncãa tsi nxàese,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eẽ xu hãa a ko tc'õó kam kò Jeso ba péré sa séè, a ba a ts'ee-ts'eekg'ai si, a khõá q'aa si, a xgaa-xgaase-kg'ao xu máà si, a ba a máá: “Séè naka xaoa tc'õó, ncẽea cgàaa Te ga a ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A ba a kubi sa séè a ts'ee-ts'eekg'ai si a máà xu si a máá: “Wèéa xao ga méé xao gaas koe kg'áà. ");
INSERT INTO nhr_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ncẽea c'áòa Te ga a ke qáé-xg'aes di i, ncẽe gha ntcã̱águè e, káí ne khóè ne gha chìbia ne qgóóa mááè ka. ");
INSERT INTO nhr_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Bìrí xao or ko, ncẽe kg'om dis hìis di gõéan ncẽer ncẽem cáḿ koe guu a kg'áà tite, me gha nxãakg'aiga síí cáḿ ẽer gha gaxao cgoa Abom di x'aian koe ka̱base kg'áà a ba hàà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Eẽ xu ko cii ba nxáèa xg'ara ka xu kò tcg'oa a Olife dim xàbìm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Me nxãaska Jeso ba bìrí xu a máá: “Ncẽem ntcùúm ka xao gha gaxao wèéa xao khuùagu Te, góásea i hãa a ko máá: ‘Kòre-kg'ao bar gha xg'áḿ, si gha ghùuan dis xg'ae sa qgóéa q'aa,’ téméè khama. ");
INSERT INTO nhr_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Igaba ẽer ko x'ooan koe ghùièa xg'ara ner gha tc'ãà-cookg'ai xao o a Galilea koe qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Me Petere ba nxàe a máá: “Eẽta xu ga ko ma wèéa xu khuùagu Tsi igabar tíí cuiskaga khuùagu Tsi tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Me Jeso ba xo̱a me a máá: “Tseegukar ko bìrí tsi: Ncẽem ntcùúm ka, qanegam ghòrò ba kg'ae tamas cookg'ai koe tsi gha senè nqoana q'oro xo̱ase Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Me Petere ba xo̱a Me a máá: “Tsáá cgoar ga ko x'óó igabagar cuiskaga xo̱ase Tsia hãa tite,” témé. Xu kò wèé xu xgaa-xgaase-kg'ao xu gatà méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Kam kò nxãaska Jeso ba Gam di xu xgaa-xgaase-kg'ao xu cgoa Getesemane ta ko ma tciièm qgáìm koe qõò, a ba a síí gaa koe bìrí xu a máá: “Ncẽe koe xao ntcõó, ẽe síí hãa koer ko síí còrè ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A ba a Petere ba hẽé naka Sebetem di tsara cóá tsara hẽéthẽé séè, kam kò tshoa-tshoa a tshúù-tcao a kaisase thõò-xám̀. ");
INSERT INTO nhr_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A ba a bìrí xu a máá: “Tcáóa Tea x'oos q'oo koe tshúù-tcaoan ka cg'oèa hãa. Ncẽe koe xao qaù, naka Tíí cgoa kókòa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Cg'árésem ko còoka qõò kam kò kg'áía ba cgoa góḿankg'ai koe cg'áé a ba a còrè a máá: “Aboè, kgoanase i kòo ne, kúrú nakas ncẽes kubis xgàrakuan di sa Tíí koe tcg'òóè. Igaba Tsari tc'ẽean ka, Tíí ko tc'ẽes ka tamase,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Kam kò xgaa-xgaase-kg'ao xu koe ka̱bise a hàà sao-xg'ae xu xu x'óm̀a. Me Petere ba bìrí a máá: “A tààè xao koáé, x'aè-coa ba Tíí cgoa hãa a kókòa hãan ka? ");
INSERT INTO nhr_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kókòa hãa naka còrè, naka xaoa nxãasega táá kúrúa bóòkuan koe tcãà guu. Tc'ẽe ba kúrú kg'oana hãa, igabam tc'áró ba kg'amka me e ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cám̀ di sam kò gaicara ka̱bise a síí còrè, a máá: “Tiri Aboè! Ncẽè kgoanase i kòo ne méés cgóm̀na ncẽes kubi sa Tíí koe séèa tcg'òóè, nakar táá nxãasega gaas q'oo koe kg'áà. Igaba ncẽè kgoanase tama i kò hãa ne méés nxãaska Tsáá ko tc'ẽe sa kúrúse,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eẽm ko gaia ka̱bise a hàà kam kò sao-xg'ae xu xu x'óm̀a hãa, nqã̱éa xu kò hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Me gaicara guu xu a qõò a síí nqoana di sa còrè, a cúís gúùs ga sa gaicara méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","A ba a nxãaska xgaa-xgaase-kg'ao xu koe ka̱bise a máá: “A qanega xao x'óm̀a, a ko sãa? Bóò, x'aè ba hààra, Me ko Khóèm dim Cóá ba hàà chìbi-kg'ao ne tshàu q'oo koe tcãàè. ");
INSERT INTO nhr_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tẽe xao, naka xae qõò! Bóò, khóè ne tshàu-q'oo koe tcãà Team khóè ba cúùse hàna ke!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Eẽm qanega hãa a ko kg'ui kam kò Jutasem ncẽe 12 xu ka c'ẽe ba hàà, xu kò káí xu khóè xu dis xg'ae sa gam cgoa hàà, ntcàuan hẽé naka dxòman hẽéthẽé kò qgóóa hãa xu, a kaia xu peresiti xu hẽé naka khóè ne di xu kaia xu koe hẽéthẽé guua hãa. ");
INSERT INTO nhr_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Me kò nxãaska ẽe kò khóè ne tshàu q'oo koe tcãà Me ba x'áí sa máà xua hãa a ko máá: “Eẽr gha ko x'obè ba Gaam ga Me e, ke xao qgóó Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Me Jutase tchànose Jesom koe síí a máá: “Tsgám̀mo, Xgaa-xgaa-kg'ao Tseè!” témé. A x'obè Me. ");
INSERT INTO nhr_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Me Jeso ba gam ka máá: “Tiri Tsi ncàm̀-khoe tseè, dùú sa tsi hààra máána?” témé. Xu kò nxãaska cúù-cuuse a Jeso ba qgóó a séè Me. ");
INSERT INTO nhr_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Me kò kúúga Jesom cgoa kò hãa xu 12 xu ka c'ẽe ba tchoanà tshàu, a gam dim ntcàu ba tsgúùa tcg'òó, a kaiam peresitim dim qãàm dim tcee ba xg'aoa qhòm. ");
INSERT INTO nhr_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Me kò nxãaska Jeso ba gam ka máá: “Ka̱bi tsarim ntcàu ba téé-q'ooa ba koe, wèém ẽe ko ntcàuan séè ba gha ntcàuan cgoa kaàkaguè ke. ");
INSERT INTO nhr_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kana tsi c'úùa qari ner úúa sa tirim Abo bar ga tcii cgoa a, Me ncẽeskaga 12 sa nqáéa zi xg'ae zi tcám̀-tcám̀ zi moengele xu di zi tsééa óá máá Te sa? ");
INSERT INTO nhr_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ncẽes gúù sar kò ko kúrú ne zi gha Nqarim di zi Tcgãya zi ntama nxàea tseegukaguè, ncẽe zi ko máá, ncẽeta méé i ga kò ma kúrúse, témé ka?” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Eẽm x'aèm kam kò Jeso ba khóè xu dis xg'ae sa bìrí a máá: “Ts'ãà-kg'ao ba tsãá hààraa khama xao gáé ntcàuan hẽé naka dxòman hẽéthẽé cgoa hààraa, hàà xao gha qgóó Te ka? Wèé cáḿ kar tempelem q'oo koe hãa a ko xgaa-xgaa, igaba xao gaa koe síí táá qgóó Te. ");
INSERT INTO nhr_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Igaba wèéan ncẽea kúrúsea, nxãasega zi gha Tcgãya zi porofiti xu di zi tseegukaguè ka,” ta méé. Ka xu kò nxãaska wèé xu xgaa-xgaase-kg'ao xu tcg'oara guu Me a bèe a qgóé. ");
INSERT INTO nhr_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Xu ẽe kò Jeso ba qgóóa xu kaiam peresitim Kaifasem koe úú Me, x'áè xgaa-xgaa-kg'ao xu hẽé naka kaia xu hẽéthẽé kò xg'aea koe. ");
INSERT INTO nhr_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Me Petere ba kháóka téé a xùri Me, a kaiam peresitim dis qgáìs koe síí. A ba a síí q'oo koe tcãà a kòre-kg'ao xu cgoa síí ntcõó, chõò-q'ooa nem gha bóò ka. ");
INSERT INTO nhr_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Xu kaia xu peresiti xu di xu hẽé, naka wèés xg'aes x'áèan di xu kaia xu di sa hẽéthẽé tshúù-ntcõan dim dàò ba qaa Jeso ba xu gha chìbi-chibi cgoa ba, cg'õo Me xu gha ka. ");
INSERT INTO nhr_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Eẽta i kò ma káí tshúù-ntcõan di chìbi-chibi-kg'aoan hààraa xg'aea igaba xu kò táá cúím dàòm ga ba hòò. Igaba tsara kò kháóka cám̀ tsara hàà, ");
INSERT INTO nhr_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","a tsara a máá: “Ncẽem khóè ba kò máá, qari nem úúa Nqarim dis tempele sam ga ko̱bea q'aa, a nqoana cáḿan q'oo koe gaicara tshào si di i, témé,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Me nxãaska kaiam peresiti ba tẽe a Jeso ba tẽè a máá: “C'ẽe gúù ga Tsi gáé xo̱a tama? Ncẽe ne khóè ne ko Tsáá ka nxàe sa gáé dùú saà?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Igabam kò Jeso ba kg'ama nqoo. Me kaiam peresiti ba bìrí Me a máá: “Kg'õèam Nqarim cookg'ai koe méé Tsi tseeguan bìrí xae e, Kreste Tsi ii sa, Nqarim di Tsi Cóá Tsi?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Me Jeso ba xo̱a me a máá: “Eẽ tsi ko méé khamaga i ii. Igabar ko bìrí xao o, ncẽe koe guus ka xao gha Khóèm dim Cóá ba bóò, Me ẽe qari iim dim kg'áòm x'õàm xòè za ntcõóa-ntcõe, a ba a gha nqarikg'ai dis túú-c'õòs cgoa hàà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Me nxãaska kaiam peresiti ba gam dim qgáí ba tòà q'aa a máá: “Ncãam nxàe e, cóèkua nem kg'uia! Dùú sa xae ko qanega tseegukagu-kg'aoan qaara máá? Bóò, ncãa xao ncẽeska Gam di cóèkuan kóḿa mááse. ");
INSERT INTO nhr_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ka xao ko ntama ma tc'ẽe?” témé. Xu xo̱a a máá: “X'oo sam kg'anoa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Xu nxãaska kg'áḿ tshàran cgoa tcg'ae kg'áí Me, a xu a tshàua xu cgoa xg'áḿ Me. Xu c'ẽea xu x'ábú Me a máá: ");
INSERT INTO nhr_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Porofita naka bìrí xae e, Kreste Tseè! Dìína xg'áḿ Tsia sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Me kò Petere ba tchàa koe ntcõóa-ntcõe, xhàros koe, si kò dxàe-coas qãà di sa hàà cgae me a máá: “Tsáá igaba tsi kò Jesom Galilea dim cgoa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Igabam kò wèéa ne cookg'ai koe xo̱ase a máá: “Eẽ si ko nxàes gúùs sar c'úùa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Si kò ẽem ko heke-kg'áḿs koe tcg'oa a ko síí, ka c'ẽes qãà sa gaa koe bóò me, a gaa koe hãa ne khóè ne bìrí a máá: “Ncẽem khóè ba kò Jesom Nasareta dim cgoa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Me kò gaicara gaìses cgoa xo̱ase, a máá: “Eẽm khóè bar c'úùa!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","X'aè-coam qãá q'oo koe ne ko ẽe kò téé-tẽe ne Peterem koe hàà a gam ka máá: “Tseeguan kaga tsi Gam ka c'ẽe tsi i, tsari kg'ui-q'ooa ne ko x'áí i khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Me kò nxãaska tshoa-tshoa a cgúíse a gaìse a máá: “Khóèm ẽe bar c'úùa hãa!” témé. Me kò kúúga ghòrò ba kg'ae. ");
INSERT INTO nhr_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Me Petere ba Jesom kò bìrí mea hãa kg'uian tc'ẽe-tc'ẽese ncẽem kòo máá: “Ghòròm qanega kg'ae tama cookg'ai koe tsi gha nqoana q'oro xo̱ase Te,” témé e. Me kò tchàa koe tcg'oa a síí thõòkase kg'ae. ");
INSERT INTO nhr_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Eẽ i ko q'uu ka xu kò kaia xu peresiti xu di xu wèé xu hẽé naka kaia xu khóè ne di xu hẽéthẽé xu nxàea xg'ae a dtcòm̀ku Jeso ba xu gha cg'õo sa. ");
INSERT INTO nhr_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Qáé Me xu kò a tc'ãà-cookg'aim Pilatom koe úú Me, a xu a tshàua ba q'oo koe tcãà Me. ");
INSERT INTO nhr_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Eẽm ko Jutasem ncẽe kò Jeso ba x'ámágu ba ko bóò Jesom ko ma x'oo sa xgàra mááè sa kam kò tc'ẽea ka̱bi a ba a 30 marian seleferean di i kaia xu peresiti xu hẽé naka khóè ne di xu kaia xu koe hẽéthẽé ka̱bi, ");
INSERT INTO nhr_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","a máá: “Chìbi ner kúrúa, khóèm káà chìbim di c'áòa ner ntcã̱água khama,” témé. Xu xo̱a me a máá: “Kháé sa ko nxãa sa sixae koe dùú sa méé? Tsáá tsi gha nxãan bóòa mááse ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Me Jutase marian tempelem q'oo koe xaoa guu, a ba a tcg'oa a síí qáé a tceese. ");
INSERT INTO nhr_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Xu kaia xu peresiti xu gaa marian sáà xg'ae, a xu a máá: “Kgoara i mááè tama, ncẽe marian gha tempelem di marian q'oo koe tcãàè sa, khóèm tcúú di mari i khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ka xu ko dtcòm̀ku a gaa marian cgoa “Gàba zi dim kúrú-kg'aom dim xhárà ba” x'ámá, gaa koe xu gha tãá za guua ne khóè ne kg'ónò ka. ");
INSERT INTO nhr_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Gaa domkam kò gaam xhárà ba “C'áòan dim xhárà ba” ta ma tciiè, ncẽes noosega. ");
INSERT INTO nhr_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nxãaskas kò porofitim Jeremiam kò kg'uia sa tseegukaguè ncẽem kòo máá: “Gaa 30 marian selefera di ne kò séè, ncẽe Iseraele di ne khóè ne kò x'ámá cgoa mea a, ");
INSERT INTO nhr_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","a ne a ‘Gàba zi dim kúrú-kg'aom dim xhárà ba’ x'ámá, ẽem kò ma X'aigam Nqari ba ma x'áèa hãa khamaga ma,” téméa sa. ");
INSERT INTO nhr_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jeso ba kò nqõóm dim kaiam cookg'ai koe hàà téé, me tẽè Me a máá: “A Tsáá ga Tsia Juta ne di Tsi X'aiga Tsi i ta ko méé Tsi?” témé. Me Jeso ba xo̱a a máá: “Eẽ tsi ko méé khamaga i ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Igaba ẽem ko kaia xu peresiti xu ka hẽé naka khóè ne di xu kaia xu hẽéthẽé ka chìbi-chibiè, kam kò táá xo̱a. ");
INSERT INTO nhr_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Me nxãaska Pilato ba tẽè Me a máá: “Ncẽeta noo zi kg'ui zi chìbi-chibi cgoa Tsi xu ko zi Tsi kóḿ tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Igabam kò Jeso ba gazi kg'ui zi ka cúía zi ga táá xo̱a, me Pilato kaisase are. ");
INSERT INTO nhr_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Cau me e kò ii nqõóm dim kaiam koe, Paseka di x'aèan ka khóè ne kò nxárá tcg'òóa mááse hãam khóèm qáéèa kò hãa ba kgoara sa. ");
INSERT INTO nhr_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Gaa x'aè ka ne kò q'ãaseam chìbi-kg'ao ba úúa, Jeso Barabase ta kòo ma tciiè ba. ");
INSERT INTO nhr_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nxãaska ẽe ne ko khóè ne xg'ae kam kò Pilato bìrí ne a máá: “Dìí ba ra gha kgoara máá tu u sa tu ko tc'ẽe? Jesom Barabase baa, kana Jesom ncẽe Kreste ta ko ma tciiè baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tc'ãà-cookg'ai xua kò chìikuan domka Jeso ba tshàu q'ooa ba koe tcana hãa sam kò q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eẽm qanega ntcõó-q'oos xgàrakuan dis koe hãa kas kò gam dis khóè sa kg'uian gam koe tsééa úú a máá: “Tcg'òó tshàua tsi ẽem khóèm tchànom koe, ntcùúm ncẽem kar ncãa kaisase tshúùs sõokuri sa gam ka sõokuri, a ncãa táá qãèse x'óm̀ ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ka xu ko kaia xu peresiti xu hẽé naka khóè ne di xu kaia xu hẽéthẽé khóè ne qg'áì, Barabase ba méé ne dtcàrà mááse sa, naka nea Jeso ba cg'õo. ");
INSERT INTO nhr_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Me nqõóm dim kaia ba xo̱a ne a máá: “Khóè tsara ncẽe tsara ka ndaka ba ra gha kgoara máá tu u sa tu ko tc'ẽe?” témé. Ne máá: “Barabase me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Me Pilato ba bìrí ne a máá: “Kháé ra gha nta hẽé Jesom ncẽe Kreste ta ko ma tciièm ka?” témé. Ne wèé ne máá: “Xgàuè méém!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Me máá: “Dùús domka? Dùútsa gúùs cg'ãè sa ba kúrúa hãa?” Ne kaisase q'au a máá: “Xgàuè méém!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eẽm ko Pilato bóò, cúí gúù kúrúm gha ga káà a sa, si ko tshúù sa tẽe, kam ko tshàan séè a khóè ne cookg'ai koe xg'aà tshàu, a máá: “Ncẽem khóèm di c'áòan koer chìbi úú tama, ke tu gatu kúrú naka bóòa mááse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ne wèé ne khóè ne xo̱a a máá: “Gam di c'áòan ta gha sita hã̱a, sita di cóán cgoa!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Me nxãaska Barabase ba kgoara máá ne, a ẽem ko Jeso ba xg'áḿmèa xg'ara kam kò ncõo-kg'ao xu tshàu q'oo koe tcãà Me, síím gha xgàuè ka. ");
INSERT INTO nhr_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nxãaska xu kò nqõóm dim tc'ãà-cookg'aim di xu ncõo-kg'ao xu Jeso ba séè a nquum koe úú, a xu a wèés xg'aes ncõo-kg'ao xu di sa Gam cookg'ai koe xg'ae-xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","A xu a kò qgáía ba nxõ̱o cgae Me, a nco̱àm qgáí ba hã̱akagu Me. ");
INSERT INTO nhr_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A xu a dxàman cgoa kúrúèas cábá sa kabea xg'ae a cábákagu Me, a kg'áò xòè di tshàua ba koe tc'áà ba qgóókagu Me, a xu a cookg'aia ba koe qo̱m̀, a nco̱i Me, a máá: “Tsgám̀mo, Juta ne di Tsi x'aiga Tseè!” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A xu a kg'áḿ tsharàn cgoa tcg'ae Me, a tc'áà dim hìi ba séè a xg'áḿ tcúú Me. ");
INSERT INTO nhr_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eẽ xu ko gatà ma nco̱i Mea xg'ara ka xu kò qgáí ba nxõ̱o cgae Me, a Gam di qgáían hã̱akagu Me, a xu a nxãaska séè a úú Me, síí xu gha xgàu Me ka. ");
INSERT INTO nhr_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eẽ xu ko tcg'oa ka xu kò Kurene koe guuam khóèm Simone ta ko ma tciièm cgoa xg'ae, a xu a chùi Me xgàu sam gha dcẽé ka. ");
INSERT INTO nhr_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","A xu a Gologota ta ko ma tciièm qgáìm koe síí, ncẽe sa ko máá: ‘Tcúú-c'õás dim qgáì ba,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Gaa koe xu ko hàà ka xu kò Jeso ba tga̱bian cgoa xg'ae-xg'aeèa qgarìan máà, kg'áà am gha ka, igaba ẽem ko xám̀ m kam kò xguì i. ");
INSERT INTO nhr_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Xu xgàu Me, a xu a cgúúan ntcòo a qgáía ba q'aa-q'aaku. ");
INSERT INTO nhr_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","A xu a gaa koe ntcõó a kòre Me. ");
INSERT INTO nhr_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","A xu a tcúúa ba koe Gam di chìbian ka ko kg'uis tcgãya sa tòó, ncẽe kò máá: “NCẼEA JESO ME E, JUTA NE DIM X'AIGA BA,” témé sa. ");
INSERT INTO nhr_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A xu a nxãaska cám̀ ts'ãà-kg'ao tsara Gaam cgoa xgàu, me c'ẽe ba Gam dim kg'áòm x'õàm xòè za téé, me c'ẽe ba dxàe xòèa ba za téé. ");
INSERT INTO nhr_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ne ẽe kò ko gaa koe nqáé ne cg'ãèse kg'ui cgoa Me, a nxã̱a-nxa̱nan tcúú ");
INSERT INTO nhr_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","a ko máá: “Tsáá ncẽe ga ko koma tempele ba ko̱bea q'aa, a nqoana cáḿan qãá q'oo koe tshào me Tsi Tsia, Nqarim di Tsi Cóá Tsi kò ii ne xgàus koe xõa naka kgoarase,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Gataga xu kò ma kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽé naka khóè ne di xu kaia xu hẽéthẽé xu ma nco̱i Me, a ko máá: ");
INSERT INTO nhr_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“C'ẽe nem kgoara hãa, igabagam ko kgoarasean ka tààè. Iseraele ne dim X'aiga Me e, ke méém ncẽeska xgàus koe xõa, nxãaska ta gha Gam koe dtcòm̀ ke. ");
INSERT INTO nhr_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nqarim koem kò tcoma hãa. Ncẽè Nqarim kò ko tc'ẽe Me ne méém ncẽeska kgoara Me. ‘Tíí ra Nqarim dir Cóá Ra a,’ tam ko méé ke,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Tsara kò ẽe kò Gaam cgoa xgàuèa tsara ts'ãà-kg'ao tsara thẽé gataga ma cóè Me. ");
INSERT INTO nhr_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Koaba di x'aèan 12 di koes kò guu a wèém nqõóm koe ntcùú sa xóé a síí dqòa di x'aèan nqoana di koe téé. ");
INSERT INTO nhr_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Me kò Jeso ba nqoana di x'aèan ka kaiam dòm̀ cgoa q'au a máá: “Eli, Eli, lama sabakatani?” témé. Ncẽe sa ko máá: “Tiri Nqariè, Tiri Nqariè, dùús domka Tsi aagu Tea?” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ne ẽe kò gaa koe téé-tẽe ne ka c'ẽe ne kóḿ Me a máá: “Ncẽem khóè ba ko Elija ba tcii,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Me kò gane ka c'ẽe ba kúúga qgóé, a x'úrúan séè, a síí gaa x'úrúan koe tsa̱u tshàan ntcã̱á, a tc'áàm koe qhàea tòó, a hàà máà Me kg'áàm gha ka. ");
INSERT INTO nhr_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ne c'ẽe ne máá: “Qãà, naka ta bóò Elija ba gha hàà kgoara Me sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Me kò Jeso ba gaicara kaiam dòm̀ cgoa q'au, a ba a còo di sa sónòa tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ka bóò, còrè-nquum dim qgáí ba kò cám̀ xòè tsara cgoa tòàra q'aase, tc'amaka guu a síí nqãaka téé, me kò nqõó ba cgùru, i nxõ̱án q'aa, ");
INSERT INTO nhr_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","zi tc'ám̀ zi xgobekg'amse, i tc'áróan ncẽe kò x'óóa hãa ne káí ne tcom-tcomsa ne di i x'ooan koe ghùiè. ");
INSERT INTO nhr_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ne kò Jesom x'ooan koe ghùièa qãá q'oo koe tc'ám̀ zi koe tcg'oa, a ne a tcom-tcomsam x'áé-dxoom koe tcãà, a káí ne khóè ne koe x'áíse. ");
INSERT INTO nhr_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eẽm ko ncõo-kg'ao xu dim kaia ba hẽé naka gam cgoa kòo hãa a ko Jeso ba kòre xu nqõóm di cgùruan bóò naka ẽe ko kúrúse zi hẽéthẽé e, ka xu kò q'áòs ka tcãàèa, a máá: “Tseegukagam kò ncẽem khóè ba Nqarim dim Cóá Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Gataga zi kò káí zi khóè zi ẽe koe hàna, a nqúù ka téé a ko bóò. Ncẽe kò Galilea koe guu a Jeso ba còò a hààraa zi, hàà zi gha hùi Me ka. ");
INSERT INTO nhr_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gazi xg'aeku koes kò Maria Magatalena sa hãa, naka Jakoboa tsara Josefaa tsara ka xõòs Maria sa hẽé, naka Sebetem ka cóásea tsara ka xõò sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Eẽ i ko dqòa kam kò qguùam khóèm Arimatea di ba hàà. Cg'õèa ba kò Josefa a, me kò Jesom dim xgaa-xgaase-kg'ao me e. ");
INSERT INTO nhr_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilatom koem kò síí, a síí Jesom dim tc'áró ba dtcàrà, me Pilato x'áèan tcg'òó máàè mem gha di i. ");
INSERT INTO nhr_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Me Josefa ba tc'áró ba séè, a q'úúm qgáím q'anom cgoa tcáḿ Me. ");
INSERT INTO nhr_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A ba a Gam dis tc'ám̀s ka̱bas koe tcãà Me, ncẽe nxõ̱ám koem kò tshàoa sa. A ba a kaiam nxõ̱á ba tc'ám̀s-kg'áḿ koe ghànèa úú, a qõò. ");
INSERT INTO nhr_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sara kò Maria Magatalena sa hẽé naka Marias c'ẽe sa hẽéthẽé sara tc'ám̀ sa q'óá-kg'amase ntcõóa-ntcõe. ");
INSERT INTO nhr_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xùrikom cáḿ ka, Sabata dim cáḿ ko kg'ónòsea mááèm cáḿ qãá q'oo koe, xu kò kaia xu peresiti xu hẽé naka Farasai xu hẽéthẽé xu Pilatom cookg'ai koe xg'ae, ");
INSERT INTO nhr_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","a xu a máá: “Kaia tseè, ncẽem kàa-kg'aom kò qanega kg'õèa hãa kam kò ko méé sa xae ko tc'ẽe-tc'ẽese, ncẽem kòo máá: ‘Nqoana dim cáḿ kar gha x'ooan koe tẽe,’ témé sa, ");
INSERT INTO nhr_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ke x'áèan tcg'òó nakas tc'ám̀ sa qarika kòreè nakam nxãakg'aiga síí nqoana dim cáḿ ba tcãà, naka xu nxãasega Gam di xu xgaa-xgaase-kg'ao xu táá síí Gam dim tc'áró ba ts'ãà guu, naka xua khóè ne bìrí naka máá: ‘X'ooan koem tẽea,’ témé guu. Ncẽes tshúù-ntcõas kháóka ka di sa gha tc'ãà dis ka kaisase cg'ãè sa ii ke,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Me Pilato xo̱a xu a máá: “Kòre-kg'aoan xao gha úúa, ke qõò naka síí tc'ám̀ sa kòre ẽe xao ma q'ana khama ma,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xu qõò, a síí tc'ám̀ sa kòre, a tc'àmà-tcẽekg'am si, a xu a gaa koe kòre-kg'aoan tòó. ");
INSERT INTO nhr_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabata dim cáḿ qãá q'oo koe, tc'ãà dim cáḿ di ntcùúkg'ai cgoa kas kò Maria Magatalena sa hẽé naka c'ẽes Maria sa hẽéthẽé sara qõò a síí ko tc'ám̀ sa bóò. ");
INSERT INTO nhr_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kas kò kúúga kaias cgùrus nqõóm di sa kúrúse, Nqarim dim moengele ba kò nqarikg'ai koe guu a ko xõa khama, a tc'ám̀s koe síí, a ba a síí nxõ̱á sa ghànèa dìbi, a gaas koe q'ábà ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Gam di bóòse-q'ooa ne kò túú-tebem dian khama ii, i kò gam di qgáían tsõ̱àn khama ma gõya-gõyase q'úú u. ");
INSERT INTO nhr_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Xu kò kòre-kg'ao xu káíse q'áò me, a cgùru, a xu a x'óóa khóèan khama ma xgàruku. ");
INSERT INTO nhr_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Igabam kò moengele ba khóè sara bìrí a máá: “Táá sao q'áò guu, Jesom ncẽe kò xgàuèa hãa ba sao ko qaa sar q'ana ke. ");
INSERT INTO nhr_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ncẽe koem káà Me e, ghùièam hãa, ẽem kò mééa khama. Ke sao hàà naka xòóèam kò hãa qgáìan bóò. ");
INSERT INTO nhr_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Naka saoa ncẽeska qháése qõò naka síí Gam di xu xgaa-xgaase-kg'ao xu bìrí, x'ooan koem ghùièa hãa sa, a ncẽeska gaxao ka tc'ãà a ko Galilea koe qõò. Gaa koe xao gha sao-xg'ae Me, témé. Bóò, táá sao c'urù guu bìrí saoar hãa sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Sara kò q'áòan hẽé naka kaisa qãè-tcaoan hẽéthẽé cgoa tc'ám̀s koe guu a qháése tcg'oa, a qàrò a síí Gam di xu xgaa-xgaase-kg'ao xu bìrí. ");
INSERT INTO nhr_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Me Jeso ba gaa x'aè kaga xg'ae cgoa sara a, a máá: “Tsgám̀ saoò!” témé. Sara hàà cgae Me, a nqàrèa ba qgóó, a sara a dqo̱m̀ Me. ");
INSERT INTO nhr_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Me nxãaska Jeso ba máá: “Táá q'áò guu, qõò naka síí Tíí qõe ga xu bìrí naka xu Galilea koe qõò, gaa koe xu gha sao-xg'ae Te ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Eẽ sara khóè sara dàò q'oo koe hãa ka xu kò gaa x'aè kaga kòre-kg'ao xu ka c'ẽea xu x'áé-dxoom koe síí, a xu a síí wèé zi gúù zi ẽe kò kúrúsea hãa zi kaia xu peresiti xu koe xàà. ");
INSERT INTO nhr_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xu kò kaia xu peresiti xu khóè ne di xu kaia xu cgoa xg'ae, a qg'áìku, a xu a ncõo-kg'ao xu káí marian máà, ");
INSERT INTO nhr_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","a bìrí xu a máá: “‘Gam di xu xgaa-xgaase-kg'ao xu ncãa ntcùú ka hàà, a hàà ts'ãà Me, ẽe xae ncãa x'óm̀a hãa ka,’ ta méé xao méé. ");
INSERT INTO nhr_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ncẽes xààs kò ko tc'ãà-cookg'aim ka kóḿè ne xae gha bìría tchàno-tchano me, a xae a gha qóḿan koe tcg'òó xao o ke,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Xu ncõo-kg'ao xu marian séè a xu a ẽe xu kò ma x'áèèa khama ma kúrú. Si kò ncẽes tchõà sa Juta ne koe tsa̱i-tsa̱iè, ncẽes noosega. ");
INSERT INTO nhr_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Xu 11 xu xgaa-xgaase-kg'ao xu Galilea koe síí, ẽem kò Jeso ba bìrí xuam xàbìm koe. ");
INSERT INTO nhr_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Eẽ xu ko bóò Me ka xu kò dqo̱m̀ Me, igaba xu kò c'ẽe-kg'áía xu káíse tc'ẽe-tc'ẽese. ");
INSERT INTO nhr_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Me Jeso ba hàà cgae xu a bìrí xu a máá: “Wèé qaria ner nqarikg'ai koe hẽé naka nqõómkg'ai koe hẽéthẽé máàèa hãa, ");
INSERT INTO nhr_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ke xao qõò naka síí nqõóm di zi qhàò zi wèé zi kúrú, naka zi Tiri xgaa-xgaase-kg'aoan kúrú, naka xaoa Xõò ba hẽé, naka Cóá ba hẽé, naka Tcom-tcomsam Tc'ẽe ba hẽéthẽé xu di cg'õèan cgoa tcguù-tcguu ne, ");
INSERT INTO nhr_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","naka xgaa-xgaa ne naka ne wèé zi gúù zi ẽer x'áè xaoa hãa zi qgóóa qari. Q'ãa méé xao: Tíí ra gha wèé cáḿan ka gaxao cgoa hãa, i gha nxãakg'aiga síí kurian di chõò-q'oo tcãà sa ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jeso Krestem di qãè tchõàn dis tshoa-tshoase sa, Nqarim dim Cóá ba. ");
INSERT INTO nhr_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ncẽe i ma porofitim Isaiam dis Tcgãyas koe ma góásea hãa khama, a ko máá: “Bóò, Tirim tchõà xàà-kg'ao bar gha Tsáá cookg'ai koe tsééa úú, ncẽe gha síí Tsarim dàò ba kg'ónòa máá Tsi ba. ");
INSERT INTO nhr_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Tchàa-xgóós koe ko q'au a ko máá: ‘X'aigam Nqari ba tu dàò ba kg'ónòa máá, naka Gam di dàòan tchàno-tchanoa máá Me,’ témém dòm̀ ba.” ");
INSERT INTO nhr_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Me ko nxãaska Johanem tcguù-tcguu-kg'ao ba tchàa-xgóós koe hàà, a khóè ne tcguù-tcguu, a ba a chìbia ne koe ne gha tcóóse a tcguù-tcguuès ka xgaa-xgaa ne, nxãasega ne gha gane di chìbian qgóóa mááè ka. ");
INSERT INTO nhr_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Me kò wèém nqõóm Jutea di ba hẽé, naka wèé ne khóè ne Jerusalema di ne hẽéthẽé síí cgae me, a ne a gane di chìbian nxàe, a Jorotane dim tshàam koe tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johane ba kò nqabè c'õò cgoa kúrúèa qgáían ha̱na, a khòo dim bàne ba kháóa ba koe qáéa, a kòo tcòm̀an hẽé naka qãáka di dènean hẽéthẽé tc'õó. ");
INSERT INTO nhr_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A ba a ko Nqarim di kg'uian xgaa-xgaa a ko máá: “Tíí qãá q'oo koem ko Gaam ẽe tíí ka qari ba hàà, ncẽe qarian ka nqáé tea hãa ba, ncẽe qám̀se a nxàbo tca̱ia ba kgoara gar tc'ãò tama ba. ");
INSERT INTO nhr_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Tshàan cgoar tcguù-tcguu tua hãa, igabam gha Gabá Tcom-tcomsam Tc'ẽem cgoa tcguù-tcguu tu u,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eẽ xu cáḿ xu kam kò Jeso ba Galilea di Nasareta koe guu, a ba a kò Jorotane dim tshàam koe hàà Johanem ka tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Eẽm ko Jeso ba tshàan q'oo koe tcg'oa kam ko nqarikg'aian bóò i xgobekg'amse, Me Tcom-tcomsam Tc'ẽe ba tcíbís khama ii a ko xõa cgae Me. ");
INSERT INTO nhr_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Me kò dòm̀ ba nqarikg'ai koe guu a máá: “Tsáá Tsia Tiri Tsi Cóá Tsi ncàm̀a Raa Tsi i, Tsáá koe Ra ko qãè-tcao,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tc'ẽe ba kò kúúga séè a qãáka úú Me. ");
INSERT INTO nhr_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Me kò 40 cáḿan qãáka hãa, a ko satanam ka kúrúa bóòè. A ba a kò gataga qãáka di kg'oo-coan cgoa hãa, i kò moengelean hàà hùi Me. ");
INSERT INTO nhr_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Eẽm ko Johane ba qáé-nquus koe tcãàèa xg'ara kam kò Jeso ba Galilea koe síí, a Nqarim di qãè tchõàn síí xgaa-xgaa, ");
INSERT INTO nhr_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","a máá: “X'aè ba hààraa, i Nqarim di x'aian cúù u, ke tu gatu di chìbian koe tcóóse naka qãè tchõàn koe dtcòm̀,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Eẽm kòo Jeso ba Galilea dim tshàam qàe koe nqáé, kam ko Simone ba hẽé naka Simonem ka qõesem Anterea ba hẽéthẽé tsara bóò, tsara ko c'uisí sa tshàan q'oo koe xaoa tcãà; x'aù qgóó-kg'ao tsara a kò ii khama. ");
INSERT INTO nhr_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Me Jeso ba bìrí tsara a a máá: “Xùri Te tsao, kúrú tsao or gha tsao khóè ne qgóó-kg'ao tsao ii ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tsara kúúga gatsara di c'uisían guu a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Eẽm ko cg'árése còoka qõò kam ko Sebetem ka cóásem Jakobo ba hẽé naka qõesem Johane ba hẽéthẽé tsara bóò, tsara dxòrom q'oo koe hãa a ko gatsara di c'uisían kg'ónò. ");
INSERT INTO nhr_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Me kò kúúga tcii tsara a, tsara kò gatsara ka xõòm Sebete ba hẽé naka gam koe ko tséé xu khóè xu hẽéthẽé dxòrom q'oo koe qaù, a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xu kò Kaperenaume koe síí. Me kò kúúga Sabata dim cáḿ ka Jeso ba còrè-nquum koe tcãà, a xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ne kò Gam di xgaa-xgaa-q'ooan ka area hãa. Qarian úúam khóèm khamam kòo ma xgaa-xgaa ne khama, gane di xu x'áè xgaa-xgaa-kg'ao xu khama tamase. ");
INSERT INTO nhr_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gaam x'aèm ẽem kam kò gane dim còrè-nquum q'oo koe c'ẽem khóè ba hãa, cg'ãè tc'ẽean kò úúa ba, me kò q'au a máá: ");
INSERT INTO nhr_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jeso Tsi Nasareta di Tseè, dùú sa Tsi ko gatá cgoa tc'ẽe? Hàà Tsi ko kaàkagu ta a? Q'ana raa dìí Tsi i sa - Nqarim di Tsi Tcom-tcomsa Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Igabam kò Jeso ba cg'ãè tc'ẽean dqàè a máá: “Nqoo, naka tcg'oa cgae me!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","I kò cg'ãè tc'ẽean khóè ba qarika ntcãa-ntcãa, a kaisam q'aum cgoa tcg'oa cgae me. ");
INSERT INTO nhr_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ne kò wèé ne khóè ne area hãa, a ne a kò tẽèku a máá: “Dùútsa gúù saa ncẽe sa? Ka̱bas xgaa-xgaa saa - qarian úúa hãasem ko cg'ãè tc'ẽean ga dqàè i komsana Me ka!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I kò kúúga nxàea ba wèém xg'aekum Galilea dim koe qháésega tsa̱i-tsa̱ise. ");
INSERT INTO nhr_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Eẽm ko còrè-nquum koe tcg'oa kam kò Simonea tsara Anterea tsara x'áé koe síí tcãà, Jakoboa tsara Johanea tsara cgoa. ");
INSERT INTO nhr_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Si kò Simonem ka c'uìse sa cgùrukagu si kos tcììs ka qgóóèa, xu kò Jeso ba gaa x'aè kaga gas ka bìrí. ");
INSERT INTO nhr_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Me kò hàà, a hàà tshàua sa koe séè a ghùi si. Si tcìì sa guu si, si tshoa-tshoa a tsééa máá ne. ");
INSERT INTO nhr_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eẽm dqòam ka, cáḿs ko tcãà ka ne kò wèé khóèan tsàako Gam koe óá, dxãwa tc'ẽean úúa hãan ga hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ne kò wèém x'áé-dxoom di ne khóè ne nquu-kg'áḿ koe xg'aea hãa. ");
INSERT INTO nhr_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Me kò Jeso ba káí ne ẽe ko tãáka zi tcìì zi tsàara hãa ne kg'õèkagu, a kò gataga káí dxãwa tc'ẽean xhàia tcg'òó cgae ne, a kò táá dxãwa tc'ẽean kgoara máá i kg'ui, q'ãa Mea i kò hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kaisa ntcùúkg'ai cgoa, qanega i ntcùú u kam kò Jeso ba tẽe a c'ẽem qgáìm nqooa hãam koe qõò, a ba a síí gaa koe còrè. ");
INSERT INTO nhr_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Xu kò Simone ba hẽé naka gam cgoa kò hãa xu khóè xu hẽéthẽé xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","A xu a ẽe xu ko hòò Me ka bìrí Me a máá: “Wèém khóè ba ko qaa Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Me bìrí xu a máá: “Hààn xae cúùse hãa xu x'áé-coa xu koe qõò, nakar gha nxãasega gaa koe thẽé síí xgaa-xgaa; gaan domkagar hààraa hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Me kò wèém Galileam koe qõòa te, a gane di xu còrè-nquu xu koe Nqarim di kg'uian xgaa-xgaa, a dxãwa tc'ẽean xhàiagu. ");
INSERT INTO nhr_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Me kò lepero dis tcìì sa tsàaram khóè ba hàà cgae Me, a hàà qgom-tsi-quri a còrè Me a máá: “Tc'ẽe Tsi kòo ne, Tsi ga kúrú ter q'ano,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Me kò Jeso ba thõò-xama máá me, a tchoanà tshàu a qgóó me, a bìrí me a máá: “Gatàr ko ma tc'ẽe, ke q'ano,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kas kò tcììs lepero di sa kúúga kaà cgae me, me q'ano. ");
INSERT INTO nhr_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Me kò Jeso ba qarika x'áè me, a ba a tcg'òó mem qõò, ");
INSERT INTO nhr_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","a bìrí me a máá: “Q'ãa, naka táá cúí khóè ga c'ẽe gúù ga bìrí guu! Igaba méé tsi qõò naka síí peresitim koe x'áíse, naka tsia tsari q'ano-q'anosean domka síí dàòa-mááku zi tcg'òó, ncẽem kò Moshe x'áèa hãa zi, x'áís iise khóè ne koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Igabam kò gaam khóè ba tcg'oa a qõòa te a ba a tshoa-tshoa a wèé za ga nxàe e. Me kò gaas gúùs domka Jeso ba tààè, x'áéan q'oo koem gha kgoarasea hãase qõòa tean ka, igabagam ko nqoo-nqoosa zi qgáì zi koe hãa. Ne kòo khóè ne qanega wèé za guu a hàà cgae Me. ");
INSERT INTO nhr_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Cg'orò xu cáḿ xu qãá q'oo koem kò Jeso ba gaicara Kaperenaume koe síí, ne kò khóè ne x'áé koem hàna hãa sa kóḿ. ");
INSERT INTO nhr_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ka ne kò káí ne khóè ne gaa koe xg'aea, i kò kòm̀ ga káà a, nquu-kg'áḿ koe ga igaba, Me kò Nqarim dim kg'ui ba xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka xu kò 4 xu khóè xu hàà, khóèm nqo̱ara kò hãa ba ko qgóóa mááku a óágara xu. ");
INSERT INTO nhr_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Eẽ xu ko Gam koe úúa ba ka tààè, khóè ne di káí-q'ooan ka, ka xu kò nxãaska ẽem kò Jeso ba hànam qgáìm di tchànoan cgoa nquum tco̱be chúrù, a xu a ẽem khóèm nqo̱ara kò hãam kò xòóèam tcoà ba qám̀. ");
INSERT INTO nhr_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Eẽm ko Jeso ba gaxu di dtcòm̀an bóò kam kò nqo̱ara hãam khóè ba bìrí a máá: “Tiri cóáè, chìbia tsi tsi qgóó mááèa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Xu kò x'áè xgaa-xgaa-kg'ao xu gaa koe ntcõóa-ntcõe, a ko tcáóa xu q'oo koe tc'ẽe a ko máá: ");
INSERT INTO nhr_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Dùúska ba koáé ncẽem khóè ba ncẽeta mééa máá? Nqari bam ko cóè! Dìí ba ga khóèan chìbian gaan di qgóóa máá, Nqarim cúí Me e ka?” ta tc'ẽe. ");
INSERT INTO nhr_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Me kò Jeso ba qháése gatà xu ma tcáóa xu koe tc'ẽea hãa sa bóò, a ba a tẽè xu a máá: “Dùús domka xao ko ẽe zi gúù zi tcáóa xao q'oo koe tc'ẽea máá? ");
INSERT INTO nhr_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ndaka nea thamkaà? Khóèm nqo̱ara hãa ba bìrí a máá: ‘Chìbia tsi tsi qgóó mááèa,’ témé, kana máá: ‘Tẽe naka tsarim tcoà ba séè naka tsia qõò,’ témé saa? ");
INSERT INTO nhr_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Igabar gha x'áí xao o, xao gha nxãasega q'ãa, Khóèm dim Cóá ba nqõókg'ai koe qarian úúa hãa sa, khóèa nem gha chìbian qgóóa máá di i,” témé. A ba a nqo̱ara hãam khóè ba bìrí a máá: ");
INSERT INTO nhr_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Bìrí tsir ko a ko máá: tẽe naka tsarim tcoà ba séè naka x'áéa tsi koe dìbi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Me kúúga qháése tẽe a ba a gam dim tcoà ba séè, a wèé ne khóè ne cookg'ai koe tcg'oa, ne wèé ne khóè ne are, a ne a Nqari ba dqo̱m̀ a máá: “Ncẽeta iis gúù sa ta qanega bóò ta ga hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Me Jeso ba gaicara tshàam qàe koe síí, ne kò káí ne khóè ne hàà cgae Me, Me tshoa-tshoa a xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Eẽm ko gaa koe guu kam kò Lefi ba bóò, Alefaiom dim cóá ba, me marian ko séèa xg'ae-xg'aeèm nquum koe ntcõóa-ntcõe. Me bìrí me a máá: “Xùri Te,” témé. Me tẽe a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Eẽm Jeso ba hãa a ko Lefim dim nquum koe tc'õó, ka i kò káí mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé tc'õó cgoa Me, Gabá hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé cgoa; káí ne khóè nea kòo xùri Me khama. ");
INSERT INTO nhr_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Eẽ xu kò x'áè xgaa-xgaa-kg'ao xu Farasai di xu bóò Me mari xg'ae-xg'ae-kg'ao xu hẽé naka chìbi-kg'aoan hẽéthẽé cgoa ko tc'õó, ka xu kò Gam di xu xgaa-xgaase-kg'ao xu tẽè a máá: “Dùús domka ba ko mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé cgoa tc'õóa máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Eẽm ko Jeso ba ncẽe sa kóḿ kam kò máá: “Eẽ tsàa tama ne khóè nea naakan qaa tama, igaba ẽe ko tsàa ne ko qaa a. Tchàno ne khóè ner gha hàà tcii kar hàà tama, igabar hààraa, hààr gha chìbi-kg'ao ne tcii ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nxãaska xu kò Johanem di xu xgaa-xgaase-kg'ao xu hẽé naka Farasai xu di xu hẽéthẽé tc'õoan carase. Ne kò c'ẽe ne khóè ne Jeso ba síí cgae a tẽè Me a máá: “Dùús domka xu ko Johanem di xu xgaa-xgaase-kg'ao xu hẽé naka Farasai xu di xu xgaa-xgaase-kg'ao xu hẽéthẽé tc'õoan carasea máá, igaba xu Tsari xu xgaa-xgaase-kg'ao xu tc'õoan carase tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Me Jeso ba xo̱a ne a máá: “Séè-kg'aom kò gam di ne cg'áè-kg'ao ne cgoa hãa ne nea gha ntama tc'õoan carase? Eẽm séè-kg'aom ko qanega gane cgoa hãa x'aè ka ne cuiskaga tc'õoan carasea hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Igabam gha x'aè ba hàà, ẽem gha ko séè-kg'ao ba gane koe séèa tcg'òóè ba; gaam cáḿ ka ne gha nxãaska tc'õoan carase. ");
INSERT INTO nhr_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Cúí khóè ga káà a, ka̱bam qgáí ba gha ncìím cgoa nqàba a; gatà i kòo hẽé nem gha ka̱bam qgáí ba ncìím koe tòàra tcg'oa, si gha tòà sa càùse. ");
INSERT INTO nhr_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Gataga i khóèan káà a, ka̱ba gõéan gha ncìí zi khòo dtcòbè zi koe qg'oe e. A ncẽè gatà i kòo hẽé ne i gha gõéan dtcòbè zi tòà, i gha gõéan ntcã̱a, zi dtcòbè zi tòàra q'aase. Igaba méé i ka̱ba gõéan ka̱ba zi khòo dtcòbè zi koe qg'oeè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","C'ẽem cáḿ Sabata dim kam kò Jeso ba ko mabere di xu xhárà xu xg'aeku koe qõò, xu Gam di xu xgaa-xgaase-kg'ao xu tshoa-tshoa a ko maberean di tcúúan tcuù. ");
INSERT INTO nhr_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Xu Farasai xu bìrí Me a máá: “Bóò, dùúska xu ko Sabata dim cáḿ ka x'áèan koe kgoara mááè tama sa kúrúa máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Me bìrí xu a máá: “Qanega xao gáé nxárá ta ga hãa Dafitem xg'ao kúrús ka? Eẽ xu kò gabá hẽé naka gam ka c'ẽea xu hẽéthẽé xàbà hãa a kòo c'ẽe gúùan tcào ka xu kò kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nqarim dim nquum koem kò ma tcãà sa, Abitarem kò kaiam peresiti ba ii x'aè ka, a ba a gam ka c'ẽea xu cgoa ts'ee-ts'eekg'aièa péréan tc'õó, ncẽe peresiti xu ka cúí ko tc'õóè e, ncẽe gabá hẽé naka ẽe hãa cgoa mea xu hẽéthẽé kò tc'õóan gaan di kgoara mááè tama a,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A bìrí xu a máá: “Sabata dim cáḿ ba khóèan kúrúa máàèa, i khóèan Sabata dim cáḿ ba kúrú máàè tama. ");
INSERT INTO nhr_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Khamam Khóèm dim Cóá ba Sabata dim cáḿ koe ga igaba X'aiga Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Me kò gaicara còrè-nquum koe síí tcãà. Me kò nqo̱ara tshàua hãam khóè ba gaa koe hãa. ");
INSERT INTO nhr_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Xu kò Farasai xu xaèa kg'ónò Me, a bóò Sabata dim cáḿ kam gha gaam khóèm ẽe nqo̱ara tshàua hãa ba qãèkagu sa, nxãasega xu gha chìbi-chibi Me ka. ");
INSERT INTO nhr_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Me kò ẽe nqo̱ara tshàua hãam khóè ba bìrí a máá: “Tẽe naka tsia síí khóè ne cookg'ai koe téé,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Me kò bìrí xu a máá: “Sabata dim cáḿ ka sa kháé ndaka sa kgoaraèa: qãèan kúrú saa kana cg'ãèan kúrú saa, khóè ba kg'õèkagu saa kana cg'õo me saa?” témé. Igaba xu kò kg'ama nqoo. ");
INSERT INTO nhr_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Me kò xgóàse bóò ne, a ba a gane di qari tcúúan ka thõò-tcaoa hãase khóè ba bìrí a máá: “Tchoanà tshàua tsi,” témé. Me kò khóè ba tshàua ba tchoanà, i tshàua ba ka̱bise a qãè. ");
INSERT INTO nhr_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xu kò Farasai xu tcg'oa, a xu a x'aigam Herotem di xu tséé-kg'ao xu cgoa xg'ae a qg'áìku, nta xu gha ma Jeso ba cg'õo sa. ");
INSERT INTO nhr_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Jeso ba kò Gam di xu xgaa-xgaase-kg'ao xu cgoa tshàam koe síí, ne kò káí ne khóè ne Galilea koe guu a xùri Me. Eẽ ne ko wèé zi ẽem kòo kúrú zi kóḿ, ka ne ko káí ne khóè ne Jutea koe hẽé, naka Jerusalema koe hẽé, naka Itumea koe hẽé, naka Jorotane ka ncìí za hẽé, naka Ture koe hẽé naka Sitone koe hẽéthẽé guu a hàà cgae Me. ");
INSERT INTO nhr_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Me Gam di xu xgaa-xgaase-kg'ao xu bìrí xu dxòro ba kg'ónòa máá Me, khóè ne dis xg'aes domka, táá ne gha nxãasega qãea cg'õo Me ka. ");
INSERT INTO nhr_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Káí ne khóè nem kò kg'õèkagua hãa, khama ne kòo ẽe kò tcììa hãa ne dqùria síí, síí ne gha qgóó Me ka. ");
INSERT INTO nhr_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Eẽ ne kòo cg'ãè tc'ẽean ka tcãà cgaeèa ne bóò Me ne ne ko cg'áé a q'au a máá: “Nqarim di Tsi Cóá Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Me kaisase dxãwa tc'ẽean dqàè, táá i gha c'ẽe ne bìrí dìím ii sa ka. ");
INSERT INTO nhr_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Me Jeso ba xàbì ba q'ábà qaò, a ba a Gam ko tc'ẽe xu tcii, xu Gam koe hàà. ");
INSERT INTO nhr_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Me 12 xu nxárá tcg'òó a x'áè úú-kg'ao xu ta ma tcii xu, Gam cgoa xu gha hãa ka, a xu a tsééè a Nqarim di kg'uian qõòkagu, ");
INSERT INTO nhr_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","a dxãwa tc'ẽean xu gha xhàiagu di qarian máàè. ");
INSERT INTO nhr_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ncẽe xua kò: Simonem ncẽem kò Petere ta ma tcii ba hẽé, ");
INSERT INTO nhr_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebetem ka cóásem Jakobo ba hẽé, naka Jakobom ka qõesem Johane ba hẽé (ncẽem kò Boaneregese dis cg'õè sa máà tsara; ncẽes cg'õè sa kòo máá: ‘Túú tebean di tsara cóá tsara a,’ témé), ");
INSERT INTO nhr_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Anterea ba hẽé, naka Filipi ba hẽé, naka Baretolomaio ba hẽé, naka Mataio ba hẽé, naka Tomase ba hẽé, naka Alefaiom ka cóásem Jakobo ba hẽé, naka Tadaio ba hẽé, naka Simonem (ncẽe kò tòókuan x'ãà máá ba) hẽé, ");
INSERT INTO nhr_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","naka Jutase Isekariotem (ncẽe kò khóè ne tshàu q'oo koe tcãà Me ba) hẽéthẽé xu u. ");
INSERT INTO nhr_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Me nxãaska Jeso ba dìbi a síí nquum q'oo koe tcãà. Ne gaicara káí ne khóè ne xg'ae, xu Gabá hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé péréan tc'õó ka tààè. ");
INSERT INTO nhr_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Eẽ ne ko Gam x'áé di ne ncẽe sa kóḿ, ka ne ko síí tceea tcg'òó Me, tc'ẽea ba nxana hãa, ta ne kò tc'ẽea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Xu kò x'áè xgaa-xgaa-kg'ao xu Jerusalema koe kò guua hãa xu hàà máá: “Belesebulem kam hãa cgaeèa, a ko dxãwa tc'ẽean dim x'aigam cgoa dxãwa tc'ẽean xhàiagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Me Jeso ba tcii ne, a sere-sere zi cgoa kg'ui cgoa ne, a máá: “Ntama ba ga ma satana ba c'ẽem satana ba xhàiagu? ");
INSERT INTO nhr_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","X'aian kò q'aa-q'aasea hãa ne i cuiskaga ẽe x'aian hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","X'áém kò gataga q'aara hãa nem cuiskaga ẽem x'áé ba hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","A ncẽè satanam kò cúía ntcoeku cgoase a q'aara hãa nem cuiskaga tééa hãa tite, igabam ko chõò-q'oos koe síí. ");
INSERT INTO nhr_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Igabam c'ẽem khóè ba cuiskaga qarim khóèm dim nquum koe tcãà, naka gam di zi gúù zi ts'ãà hãa tite, kg'aia méém ẽem khóèm qari ba qáéa ntcòo. Nxãaska cúígam gha nquua ba q'oo koe tcãà a gam di zi gúù zi ts'ãà. ");
INSERT INTO nhr_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tseegukar ko bìrí tu u: Khóè ne gha wèé chìbia ne koe hẽé naka wèé cg'ãè kg'uian kg'áḿ q'ooa ne koe ko tcg'oa koe hẽéthẽé qgóóa mááè. ");
INSERT INTO nhr_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Igaba ẽe ko Tcom-tcomsam Tc'ẽem ka cg'ãèse kg'ui nea chõò tamase qgóóa-máákuan hòò tite, igaba ne chõò tamase chìbiga ne e,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Cg'ãè tc'ẽea nem úúa,” ta ne mééa domkam Jeso ba ncẽeta mééa. ");
INSERT INTO nhr_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesom ka xõò sa hẽé naka qõese ga xu hẽéthẽéa kò hàà, a hàà tchàa koe téé, a c'ẽem khóè ba tséé, me síí Jeso ba tcii. ");
INSERT INTO nhr_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ne kò káí ne khóè ne ntcõóa nxa̱ma-nxa̱ma Mea hãa khama ne máá: “Bóò, saò sa hẽé naka Tsáá qõe ga xu hẽéthẽéa tchàa za tẽe a ko dtcàrà kg'ui cgoa Tsi ne gha sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Me xo̱a ne a máá: “Tiris xõò sa dìí saa, xu Tíí qõe ga xu dìí ga xua?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Me ẽe kò ntcõóa nxa̱ma-nxa̱ma Mea ne ntcáà, a ba a máá: “Ncẽea Tiris xõòs ga si i, a Tíí qõe ga xu xu u. ");
INSERT INTO nhr_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wèém khóèm ẽe ko Tirim Nqarim nqarikg'ai koe hànam ko tc'ẽe sa kúrú ba Tíí qõem ga me e, a Tíí qões ga si i, a gataga Tiris xõòs ga si i,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Me gaicara tshoa-tshoa a tshàam qàe koe xgaa-xgaa. Si kò kaias xg'ae sa qàea ba koe hãa, Me dxòrom q'oo koe tcãà a tshàam qàe koe síí ntcõó, si kò wèés xg'ae sa tshàam-kg'áḿ koe góḿankg'ai koe téé-tẽe. ");
INSERT INTO nhr_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Me káí zi gúù zi xgaa-xgaa ne sere-sere zi cgoa, a ba a Gam di xgaa-xgaan koe máá: ");
INSERT INTO nhr_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Komsana méé tu. Xhárà-kg'ao ba kò qõò a síí xhárà. ");
INSERT INTO nhr_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Eẽm ko xhárà ka i kò c'ẽe cgùrian dàòm qàe koe tcheè, zi tsa̱rá zi hàà tc'õó o. ");
INSERT INTO nhr_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","I c'ẽe cgùrian nxõ̱á-kg'ai di qgáìan koe tcheè, ncẽe káí góḿan kò káà a koe. I kò kúúga qháése tso̱m, góḿa ne kò kaisa tama khama. ");
INSERT INTO nhr_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Eẽs ko cáḿ sa qaò ka i ko gaa tso̱man dào, a i a kò to̱be ga i kò úú tama khama nqa̱i. ");
INSERT INTO nhr_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","I c'ẽe cgùrian dxàman hàna qgáì koe tcheè, i dxàman kai, a chúú-chuu u, i táá tc'õoan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","I c'ẽe cgùrian qãè góḿan koe tcheè, a i a tc'õoan kúrú, ẽe i ko qhúí a ko kai ka i c'ẽean 30 khama noo, i c'ẽean 60 khama noo, i c'ẽean 100 khama noo tc'õoan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Me Jeso ba máá: “Eẽ tceean úúa hãa ba méém kóḿ,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Eẽm cúía hãa ka xu kò 12 xu xgaa-xgaase-kg'ao xu hẽé naka c'ẽe ne ẽe kò gaa koe hãa ne hẽéthẽé sere-sere zi ka tẽè Me. ");
INSERT INTO nhr_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Me kò bìrí ne a máá: “Gatua máàèa, chóm̀sea zi kàa zi Nqarim di x'aian di zi tu gha q'ãa sa. Igaba gane ẽe tchàa za hãa ne koe i ko wèé gúùan ga sere-sere zi cgoa nxárá xg'aeè. ");
INSERT INTO nhr_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nxãasega ‘ne gha wèé x'aèan kaga bóò igaba ne bóòa q'ãa tite ka. A ne a gha wèé x'aèan kaga kóḿ igaba ne kóḿa q'ãa tite, Nqarim koe ne ko ka̱bise a qgóóa mááè ne cúí ga a gha ii.’” ");
INSERT INTO nhr_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Me bìrí ne a máá: “Ncẽes sere-sere sa tu gáé kóḿa q'ãa tama? Kháé tu gha nxãaska c'ẽe zi sere-sere zi ntama kóḿa q'ãa? ");
INSERT INTO nhr_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Xhárà-kg'ao ba ko kg'ui ba xhárà. ");
INSERT INTO nhr_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","C'ẽè ne khóè nea dàòm qàe koe kò tcheèa hãa cgùrian khama ii, ncẽe kg'uim xháràèa koe. Eẽ ne ko kóḿ me kagam ko kúúga satana ba hàà, a hàà kg'uim ẽe gane koe xháràèa hãa ba séèa tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ne c'ẽe ne khóè ne nxõ̱án hàna qgáì koe kò tcheèa hãa cgùrian khama ii. Nxãa nea ncẽe kg'ui ba ne ko kóḿ ne ko kúúga qãè-tcaoan cgoa hààkagu me ne e, ");
INSERT INTO nhr_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","igaba ne káà to̱be ne e khama ne ko xòm̀ x'aè séè a hãa, a ne a ẽe i ko kg'uim domka xháéa ne kana xgàrakuan hàà ne ne ko qháésega cg'áé. ");
INSERT INTO nhr_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“C'ẽe ne khóè nea ẽe dxàman koe tcheèa hãa cgùrian khama ii. Gane ẽe kg'ui ba kóḿa ne ne e, ");
INSERT INTO nhr_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","igaba kg'õès di zi xháé zi hẽé, naka qguù sa ncàm̀an hẽé, naka c'ẽe zi gúù zi ncóóan hẽéthẽéa kò tcãà cgae ne, a kg'ui ba chúú-chuu, me táá tc'áróan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“C'ẽea ne qãè góḿan koe kò xháràèa cgùrian khama ii. Nxãa ne ko kg'ui ba kóḿ a ne a ko dtcòm̀a mááse me, a ne a ko tc'áróan kúrú, i c'ẽean 30, i c'ẽean 60, i c'ẽean 100 ne ne e.” ");
INSERT INTO nhr_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Me bìrí ne a máá: “Dìína ga x'áà-x'aa-kg'ai cgoa dis gúù sa gàbas cgoa xoaba-kg'ai, kana kgàrom dòm̀ q'oo koe tòó? Tseeguan kagas gha téé-q'ooa sa koe tòóè! ");
INSERT INTO nhr_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wèés gúùs ẽe chóm̀sea hãa sa gha x'áíse, si gha ẽe qàbi-kg'aièa hãa sa, xgòre-kg'aiè khama. ");
INSERT INTO nhr_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Khóèm ẽe tceean úúa hãa ba méém kóḿ,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Me bìrí ne a máá: “Qãèse tu komsana! Eẽ tsi tcg'òóa hãas tc'ãò-tc'ão sa gaas máàè tsi ghas ga si i, a tsi a gha gataga càùa mááè si. ");
INSERT INTO nhr_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Wèém khóèm ẽe úúa hãa ba gha káían mááè. Me gha ẽe gúù úú tama ba, ẽem úúa hãa gúù-coan ga séè cgaeè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","A ba a máá: “Nqarim di x'aia nea ncẽeta ii: ‘Khóèm góḿan koe cgùri ba xhárà hãam khama i ii, ");
INSERT INTO nhr_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ncẽe ko ntcùú ka x'óm̀ a ko koaba ka tẽe, me cgùri ba ko cúíaga kai, gam c'úùa hãase. ");
INSERT INTO nhr_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Góḿ ba kò cúíga kg'ama tc'õoan kúrú: kg'aiam ko tso̱m a qhúí, a ba a kai, a x'õàn kúrú, i x'õàn tc'áróan kúrú. ");
INSERT INTO nhr_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Eẽ i ko tc'õoan x'ãé kaga i ko tcuùè, tcuù di x'aè ne hààraa khama,’” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A ba a máá: “Nqarim di x'aia nea gha dùús cgoa nxárá xg'aeè, kana dùútsa sere-seres cgoa ia gha nxárá xg'aeè? ");
INSERT INTO nhr_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Mosetara dis hìis dim cgùrim khama i ii. Ncẽè cgùrian kò ko góḿan koe xháràè nem wèé cgùrian nqõómkg'ai di kaga cg'áré me e. ");
INSERT INTO nhr_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Igaba ẽem kò xháràè nem ko tso̱m, a kaias hìis xhárà di sa kúrú, a kaia nxã̱an kúrú, i gha nqarikg'ai di tsa̱rán hàà gas di sóm̀an koe nquuan kúrú,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeso ba kò káí zi sere-sere zi tséékagu, a kg'ui ba bìrí ne tc'ãò-tc'ãos ẽe gane ko kóḿa q'ãas cgoa. ");
INSERT INTO nhr_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Táám kò cúí gúù ga gane cgoa kg'ui, sere-serean tséékagu tamase, igabam ko Gam di xu xgaa-xgaase-kg'ao xu cgoam kò cúía hãa ka wèés gúù sa qãèse bìrí xu. ");
INSERT INTO nhr_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Me gaam cáḿ ẽem dim dqòam ka bìrí xu a máá: “Hàà naka xae c'ẽem xòèm tshàam dim za tchoaba,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Xu kò khóè ne gaa koe qaù, a xu a ẽem kò hãam dxòrom q'oo koe tcãà, zi kò gataga thẽé c'ẽe zi dxòro zi gaa koe hàna. ");
INSERT INTO nhr_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Me kò kaiam tc'ãá ba tẽe, i tshàam di qhonèan qùbise a dxòrom q'oo koe tcãà, me dxòro ba cg'oè ka hẽé. ");
INSERT INTO nhr_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Igabam kò Jeso ba dxòrom kháó koe hàna, a tcgábí ba dcãa a x'óm̀a xõe. Xu ghùi Me, a máá: “Xgaa-xgaa-kg'ao Tseè, tom̀ xae ko igaba i gáé Tsáá koe gúù méé tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Me tẽe a ba a tc'ãá ba dqàè a tshàa ba bìrí a máá: “Nqoo naka kgàe!” témé. Me tc'ãá ba téé, si kò kaisas nqoo sa xóé. ");
INSERT INTO nhr_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Me tẽè xu a máá: “Dùús domka xao ma q'aea? Dtcòm̀an xao gáé úú tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Xu kaisase q'áò, a xu a tẽèku a máá: “Dùútsa khóè ba gáé ncẽe ba? Tc'ãán ga hẽé naka tshàan ga hẽéthẽé ka ko komsanaè ba?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xu tshàa-dxoom ka c'ẽe xòèa ba za tchoaba, Gerase ne dim nqõóm xòè koe. ");
INSERT INTO nhr_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Eẽm ko Jeso ba dxòrom koe tcg'oa, kam ko cg'ãè tc'ẽean kò úúa hãam khóèm cgoa xg'ae, tc'ám̀ zi xòè koe kò guua hãa ba. ");
INSERT INTO nhr_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tc'ám̀ zi koe kò x'ãèa hãa ba, ncẽe khóè ne kò qáéa ba ka tààèa hãa ba, qano di xu tau xu cgoa ga igaba. ");
INSERT INTO nhr_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Káí-kg'aisem kò ko tshàua ba koe hẽé naka nqàrèa ba koe hẽéthẽé qano cgoa qáéa ntcòoè, igabam kò ko qhòm m, a ba a nqàrè di qanoan khõà q'aa. Cúí khóè ga kò káà a ncèè me i ga di qarian kò úúa hãa a. ");
INSERT INTO nhr_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ntcùú ba hẽé naka koaba ba hẽéthẽém kò ko tc'ám̀ zi hẽé naka xàbì xu koe hẽéthẽé q'aua te, a ko nxõ̱án cgoa thõò-thõose. ");
INSERT INTO nhr_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eẽm ko Jeso ba nqúù ga ii a ko bóò, kam kò qgóéa síí, a síí cookg'aia ba koe qo̱m̀, ");
INSERT INTO nhr_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","a kaisase q'au a máá: “Jesoè, kaisase tc'ámáka hànam Nqarim di Tsi Cóá Tseè, dùú sa Tsi ko tíí cgoa tc'ẽe? Nqarim cgoa ra ko gaìse Tsi a ko máá, táá xgàra te guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Me Jeso ba bìrí me a máá: “Ncẽem khóèm koe tcg'oa, tsáá cg'ãè tc'ẽe tseè!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Me nxãaska Jeso ba tẽè me a máá: “Cg'õèa tsi dìía?” témé. Me máá: “Cg'õèa te Milione e, káí xae e khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Me kaisase Jeso ba dtcàrà, táám gha ẽem qgáìm koe xhàiagu xu ka. ");
INSERT INTO nhr_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Káí zi xgùu zia kò xàbìm dxùukg'ai koe hãa a ko dxòó. ");
INSERT INTO nhr_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ka i ko dxãwa tc'ẽean Jeso ba dtcàrà a máá: “Xgùuan dis xg'aes koe tsééa úú ta a, kgoara máá ta a naka ta gaan koe tcãà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Me cg'ãè tc'ẽean kgoara máá i tcg'oa, a i a síí xgùuan koe tcãà, i ẽe xgùuan ncẽe kò 2,000 khama noo o, kari-karisea xõa a síí tshàam koe tcãà a tom̀. ");
INSERT INTO nhr_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Eẽ kòo xgùuan kòre xu khóè xua kò bèe a qgóé a síí x'áé-dxooan koe hẽé naka x'áé-coa xu koe hẽéthẽé xàà a. Ne kò khóè ne ẽe kúrúsea hãa sa hàà bóò. ");
INSERT INTO nhr_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Eẽ ne ko Jesom koe hàà ka ne kò ẽe kò dxãwa tc'ẽean úúa hãam khóè ba bóò, me gaa koe ntcõóa-ntcõe, a qgáían ha̱na, i tc'ẽea ba qãè e, ka ne kò q'áò. ");
INSERT INTO nhr_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Gane ẽe kò ẽe kúrúsea hãa sa bóò ne kò dxãwa tc'ẽean kò úúam khóèm koe hẽé naka xgùuan koe hẽéthẽé kúrúsea hãa sa khóè ne bìrí. ");
INSERT INTO nhr_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ne tshoa-tshoa a Jeso ba dtcàrà, gane dim nqõóm koem gha tcg'oa sa. ");
INSERT INTO nhr_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Eẽm ko Jeso ba dxòrom koe tcãà kam kò ẽe kò dxãwa tc'ẽean ka tcãàèa hãam khóè ba Gam cgoam gha qõò sa dtcàrà Me. ");
INSERT INTO nhr_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Igabam kò Jeso ba táá kgoara máá me Gam cgoa qõòa ne, a bìrí me a máá: “Dìbi x'áéa tsi koe, tsari ne khóè ne koe, naka tsia síí X'aigam nta noose kúrú máá tsia hãa sa hẽé naka nta noosem thõò-xama máá tsia hãa sa hẽéthẽé ka bìrí ne,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Me kò khóè ba wèé xu x'áé-dxoo xu ẽe kò Dekapolise koe hãa xu koe qõòa te a Jesom gam koe kúrúa hãa zi gúù zi kaisa zi ka tshoa-tshoa a khóè ne bìrí, ne wèé ne khóè ne are. ");
INSERT INTO nhr_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Eẽm ko Jeso ba dxòrom cgoa tshàam ka ncìí za ka xòèa ba koe tchoaba, ka ne kò káí ne khóè ne Gam koe xg'ae, Me kò tshàam dxùukg'ai koe téé-tẽe. ");
INSERT INTO nhr_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Me kò c'ẽem khóèm, còrè-nquum di xu tc'ãà-cookg'ai xu ka c'ẽe ba hàà, Jairo ta kò ko ma tciiè ba, a ba a ẽem ko Jeso ba bóò ka nqàrè-kg'ama ba koe cg'áé. ");
INSERT INTO nhr_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A kaisase dtcàrà Me a máá: “Tiris cóás cg'áré sa x'oos qàe koe hãa, ke cgóm̀na hàà naka Tsia tshàua Tsi tòó cgae si nakas gha nxãasega qãè naka kg'õè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Me tẽe a qõò cgoa me, ne káí ne khóè ne xùri Me, a ne a nco̱rú Me. ");
INSERT INTO nhr_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Si kò thẽé c'ẽes khóès 12 kurian kò úúa hãa a ko xòm̀ x'aèse nxoean hòò sa hãa, ");
INSERT INTO nhr_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ncẽe kò káí kurian séè a ko naakan koe tsoòse sa, a kò wèé gúùan ẽes úúa hãa ga tséékagu, qãèkaguses gha ka, igabagas kò táá qãè, i kò gaas di tcììan càùse. ");
INSERT INTO nhr_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Eẽs ko Jesom ka kóḿ, kas kò káí ne khóè ne xg'aeku koe guu a hàà Jesom kháó koe tcãà, a sa a ẽem kò ha̱nam qgáím di xgáḿ-kg'aman qgóó. ");
INSERT INTO nhr_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Gas kas kò bìríse a máá: “Ncẽè Gam dim qgáí bar kòo qgóó ne cúígar gha qãè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Si Gam dim qgáí ba qgóó, i kò gaa x'aè kaga gas di tcììan kaà, si cgáé-q'ooa sa koe xám̀ ncãas gas di tcììan koe tsoòè sa. ");
INSERT INTO nhr_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Me Jeso ba qarian ncãa tcg'oa cgae Me sa qháésega xam̀a q'ãa. A ba a ka̱bise khóè ne koe a máá: “Dìí na ncãa qgáía Te qgóó?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Xu Gam di xu xgaa-xgaase-kg'ao xu xo̱a Me a máá: “Khóè ne ma xg'ae cgae Tsia hãa sa Tsi ko bóò, igaba Tsi ko tẽè dìín qgóó Tsia hãa sa!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Me Jeso ba ntcáà, dìín ẽes gúù sa kúrúa hãa sam gha bóò ka. ");
INSERT INTO nhr_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Si nxãaska khóè sa ẽe kúrúse cgae sia hãa sa bóòa q'ãa, a sa a hàà nqàrè-kg'ama ba koe cg'áé q'áòan cgoa, a wèé tseeguan bìrí Me. ");
INSERT INTO nhr_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Me bìrí si a máá: “Tiri si cóá seè, sari dtcòm̀a nea qãèkagu sia, ke tòókuan cgoa qõò naka sia sari xháéan koe tcg'oa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Eẽm qanega hãa a ko khóè ne cgoa kg'ui, ka ne kò c'ẽe ne Jairom ncẽe kò còrè-nquum dim tc'ãà-cookg'aim dim nquum koe kò guua hãa ne hàà, a ne a máá: “Tsáá xuù sa ncãa x'óó, ka tsia ko dùús domka xgaa-xgaa-kg'ao ba qanega xhõe-xhõea máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Igabam kò Jeso ba táá nqábé kg'uian ẽe kòo kg'uiè e, a ba a còrè-nquum dim tc'ãà-cookg'ai ba bìrí a máá: “Táá q'áò guu, kg'amaga méé tsi dtcòm̀,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A ba a kò táá c'ẽe khóè ga kgoara máá i xùri Me, Petere ba hẽé naka Jakobo ba hẽé naka Johanem Jakobom ka qõese ba hẽéthẽé xu ka oose. ");
INSERT INTO nhr_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Eẽ xu ko còrè-nquum dim tc'ãà-cookg'aim dim nquum koe síí tcãà, kam ko Jeso ba bóò zi gúù zi qãè tama, ne ko khóè ne q'aua kg'aeku a ko xo̱ò. ");
INSERT INTO nhr_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Me tcãà a síí bìrí ne a máá: “Dùús domka zia gúù zi qãè tama, tu ko kg'aeku, a ko xo̱ò? Cóá sa x'óó tama a x'óm̀a hãa ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Igaba ne kò kg'ãè Me. Me wèéa ne ga tcg'òó, a ba a cóás ka xõò ba hẽé, naka xõò sa hẽé naka ẽe kò Gam cgoa hãa xu xgaa-xgaase-kg'ao xu nqoana xu hẽéthẽé séè a cóás kò hãa koe tcãà cgoa ne. ");
INSERT INTO nhr_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Me tshàua sa koe qgóó si, a bìrí si a máá: “Talita kumi!” témé. Ncẽe sa ko máá: ‘Cóá seè, tẽe tar ko sáá ka méé,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Si gaa x'aè kaga cóá sa tẽe a sa a qõòa te (12 kuri si i kò ii). Eẽs ko ncẽe sa kúrúse ka ne kò kaisase are. ");
INSERT INTO nhr_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Me Jeso ba qarika q'ãa-q'ãa ne, táá ne gha cúí khóè ga ncẽes gúùs ka q'ãakagu sa. A ba a bìrí ne a máá: “C'ẽe gúù máà si nakas tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jeso ba kò ẽem qgáì ba tcg'oaragu, a Gam dim x'áé-dxoom koe síí, xu kò Gam di xu xgaa-xgaase-kg'ao xu xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Me kò Sabata dim cáḿ ka tshoa-tshoa a còrè-nquum koe xgaa-xgaa. Ne kò káí ne ẽe kò kóḿ Me ne kaisase are a máá: “Ncẽem khóè ba wèé zi ncẽe zi nda hòòa? Dùútsa tc'ẽe saa ncẽe Gam máàèa sa, ncẽem ko kaia tsééan are-aresa ga kúrú sa? ");
INSERT INTO nhr_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kháé ncẽe ba gáé xom-kg'aom tama baa, Marias ka cóáse ba, Jakobo ba hẽé, Josefa ba hẽé, Jutase ba hẽé, naka Simone ba hẽéthẽé xu ka káímkhoe ba. Gam ka qõesea zi gáé gatá cgoa ncẽe koe hãa tama?” ta ne méé. A ne a bóòa xguì Me. ");
INSERT INTO nhr_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Me Jeso ba bìrí ne a máá: “Porofiti ba wèé za ga tcommèam khóè me e, gam dim x'áé-dxoom koe hẽé naka gam di x'áéan koe hẽéthẽé cúí oose,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A ba a kò gaa koe táá are-aresa zi tséé zi kúrú, igabam kò kg'ama cg'orò ne khóè ne tsàà ko ne koe cúíga tshàua ba tòó, a kg'õèkagu ne. ");
INSERT INTO nhr_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaisasem kò area hãa, gane di dtcòm̀an úú tama domka. A ba a kò x'áé-coa xu koe qõòa te a xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Me kò Jeso ba 12 xu xgaa-xgaase-kg'ao xu Gam koe tciia óá, a ba a tshoa-tshoa a cám̀-cám̀ tsééa tcg'òó xu, a cg'ãè tc'ẽean xhàiagu di qarian máà xu. ");
INSERT INTO nhr_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","A ba a x'áè xu a máá: “Táá méé xao cúí gúù dàò q'oo di ga séèa mááse guu, igaba méé xao dqàbi hìim cúím gabá séè, naka táá péré kana dtcòbè ga séè guu, naka táá cúí mari ga qòè guu. ");
INSERT INTO nhr_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Igaba méé xao nxàbo, naka xaoa táá c'ẽe qgáí ga séèa mááse guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gatagam kò thẽé bìrí xu a máá: “Eẽ xao ko tcãàm x'áém koe xao kòo qãèse hààkaguè, ne méé xao gaa koe x'ãè, naka xaoa nxãakg'aiga síí ẽem qgáì ba tcg'oara guu. ");
INSERT INTO nhr_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","A ncẽè c'ẽe qgáì gaa kò qãèse hààkagu xao o tama, ne khóè ne komsana xao o tama, ne méé xao ẽem qgáìm koe nqàrèa xao di tsharàn qãè-qãe, naka xaoa tcg'oaragu me, nxãasegas gha ẽe sa ẽe ne khóè ne koe x'áí sa ii ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xu tcg'oa a xu a síí Nqarim dim kg'ui ba xgaa-xgaa, khóè ne méé ne gane di chìbian koe tcóóse di ba. ");
INSERT INTO nhr_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A xu a káí dxãwa tc'ẽean khóè ne koe xhàiagu, a káí ne khóè ne tsàako ne nxúìan cgoa tcgáù, a xu a qãèkagu ne. ");
INSERT INTO nhr_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Me x'aigam Herote ba Jesom ka kóḿ, cg'õèa ba kò q'ãasea hãa khama. C'ẽe ne khóè nea kòo máá: “Johanem tcguù-tcguu-kg'ao Me e. X'ooan koem tẽea! Gaa domka i ko ncẽe qarian are-aresa zi tséé zi di gam koe kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Igaba ne kò c'ẽe ne máá: “Elija Me e,” témé, ne ko c'ẽe ne máá: “Porofiti Me e, c'ẽe xu porofiti xu ncìí x'aè di xu khamaga ma,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Igaba ẽem ko Herote ncẽe sa kóḿ kam kò máá: “Johanem, ncẽer kò q'ãe tcúúa hãa ba, x'ooan koe tẽèa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herote ba kò gam ka káíkhoem Filipim dis khóès Herotiase sa séèa hãa. Me kò Johane ba Herote ba bìría hãa a máá: “X'áèan koe tsi kgoara mááè tama, tsáá kíím dis khóè sa tsi ga kò séèa hãa sa,” témé. Khamam kò Herote ba c'ẽe khóèan tsééa úú, síí i gha Johane ba qgóó, a qáé, a qáé-nquus koe tcãà ka. ");
INSERT INTO nhr_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herotiase sa kò Johane ba hòrea hãa, a kò cg'õo me kg'oana, igabagas kòo tààè. ");
INSERT INTO nhr_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herote ba kò Johane ba q'áòa hãa, a kò nqáó-nqao mea hãa, tchàno a tcom-tcomsam khóè me e sam kò q'ana hãa khama. Eẽm kòo Johane ba kóḿ nem kò qãèse hãa tama, igabam kò komsana ba ncàm̀a hãa. ");
INSERT INTO nhr_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Igabas kò qãèm x'aè ba hòò, me kò Herote ba ábà cáḿa ba ka gam di xu tc'ãà-cookg'ai xu kaia xu hẽé, naka ncõo-kg'ao xu di xu kaia xu hẽé, naka Galilea koe kò tc'ãà-cookg'aia xu khóè xu hẽéthẽé kõ̱è sa kúrúa máá. ");
INSERT INTO nhr_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Eẽs ko Herotiases ka cóáse sa tcãà a ko Herote ba hẽé naka kõ̱ès di xu cg'áè-khoe xu hẽéthẽé xu ko ntcãà máá kas ko Herote ba kaisase qãè-tcaokagu. Me x'aigam Herote ba cóá sa bìrí a máá: “Wèés gúùs ẽe si ga dtcàrà te sa dtcàrà te, máà si sir gha ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A ba a gaìses cgoa nqòòkagu si a máá: “Dùús wèés ẽe si gha dtcàrà te sar gha máà si, tiri x'aian di xòèan c'ẽea ga ii igaba,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Si xõòs koe síí a máá: “Dùú sa ra gha dtcàrà?” témé. Si xõò sa máá: “Johanem tcguù-tcguu-kg'aom dis tcúú sa dtcàrà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Si kò x'aigam koe kúúga ka̱bise a máá: “Johanem tcguù-tcguu-kg'aom dis tcúú sar ko gàbas q'oo koes tòóèa hãase dtcàrà,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Me x'aiga ba kaisase tshúù-tcao, igabam kò gaìsean ẽem kò kúrúa hãa hẽé naka cg'áè-khoe ne hẽéthẽé domkam kò gam dim kg'ui ba ntcoean tc'ẽe tama. ");
INSERT INTO nhr_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","A ba a kò cg'õo-kg'ao ba qháése x'áèan cgoa tsééa úú, síím gha Johanem dis tcúú sa óága ka. Me kò qõò a síí Johanem dis tcúú sa q'ãe, qáé-nquus koe. ");
INSERT INTO nhr_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A ba a gaas tcúú sa gàbas koe tòó a óá, a hàà gaas dxàe-coa sa máà si, si kò cóá sa séè a xõò sa máà si. ");
INSERT INTO nhr_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eẽ xu ko gam di xu xgaa-xgaase-kg'ao xu ẽe sa kóḿ, ka xu kò hàà tc'áróa ba séè, a síí tc'ám̀s koe kg'ónò o. ");
INSERT INTO nhr_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xu kò x'áè úú-kg'ao xu Jesom koe ka̱bise, a hàà wèé zi gúù zi ẽe xu kò kúrú zi hẽé naka ẽe xu xgaa-xgaa hãa zi ka hẽéthẽé bìrí Me. ");
INSERT INTO nhr_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Igaba i kòo nxãaska káí khóèan hààku a ko qõòku, xu kò Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé táá tc'õó di x'aèan ga úú khamam kò bìrí xu a máá: “Hàà xao naka xae nqoo-nqoosam qgáìm koe qõò naka xaea síí cúía hãa naka xao gha nxãasega sãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xu dxòrom cgoa qõò a xu a cúíaga nqoo-nqoosam qgáìm koe síí hãa. ");
INSERT INTO nhr_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ne káí ne khóè ne bóò xu, xu ko tcg'oa, ne dìí ga xu u sa bóòa q'ãa. Ka ne ko x'áé-dxoo xu koe guu a tshàam dxùukg'ai séè, a tc'ãà a nqàrèa ne ka gaa za qgóéa síí, a síí còoka hãa a qãà xu. ");
INSERT INTO nhr_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Eẽm ko Jeso ba dxòrom koe xõa kam ko kaias xg'ae sa bóò, a ba a thõò-xama máá ne, kòre-kg'ao ba úú tama zi ghùu zi khama ne kò ii khama. Me nxãaska tshoa-tshoa a káí zi gúù zi ka xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Eẽs ko cáḿ sa dqòara qõò ka xu ko Gam di xu xgaa-xgaase-kg'ao xu hàà cgae Me, a máá: “Ncẽem qgáì ba cúía hãam qgáì me e, i ncãa gataga dqòa, ");
INSERT INTO nhr_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ke khóè ne qõòa q'aakagu naka ne nxãasega cúùse nxa̱ma-nxa̱ma hãa xu x'áé xu koe hẽé naka x'áé-coa xu koe hẽéthẽé síí c'ẽe gúùan x'ámá mááse naka tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Igabam kò xo̱a xu a máá: “Gaxao c'ẽe gúùan máà ne naka ne tc'õó,” témé. Xu bìrí Me a máá: “Kháé méé xae síí káí marian 200 xu qano mari xu tséékagu naka pérén x'ámá máá ne naka ne tc'õó?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Me máá: “Nta noo pérén xao úúa? Qõò naka síí bóò,” témé. Xu síí bóò a máá: “5 xu péré xu hẽé naka cám̀ x'aù tsara hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Me Jeso ba bìrí xu xu wèé ne khóè ne xg'ae-coa zi cgoa ntcõókagu, tsã̱a dcãan kg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ne xg'ae-coa zi 100 ne khóè ne di zi hẽé, naka 50 ne khóè ne di zi hẽéthẽé cgoa ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Me ẽe xu 5 xu péré xu hẽé naka x'aù tsara hẽéthẽé séè, a nqarikg'ai koe ghùi-kg'ai, a ts'ee-ts'eekg'ai i, a péréan khõá q'aa. A ba a xgaa-xgaase-kg'ao xu máà a, nxãasega xu gha khóè ne sama a ka. Me gataga x'aù tsara wèé ne khóè ne q'aa-q'aaa máá. ");
INSERT INTO nhr_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ne kò wèéa ne ga tc'õó a ne a xg'ãà, ");
INSERT INTO nhr_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","xu xgaa-xgaase-kg'ao xu ẽe ncãa tc'õóa qaùèan ka 12 xu q'ore xu péré-qàmàn hẽé naka x'aù-qàmàn hẽéthẽé di xu tcãà, xu cg'oè. ");
INSERT INTO nhr_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Eẽ kò péréan tc'õó xu di xg'ae-q'ooa ne kò 5,000 khama noo xu khóè xu u. ");
INSERT INTO nhr_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Me Jeso ba qháése Gam di xu xgaa-xgaase-kg'ao xu chùi, xu dxòrom q'oo koe tcãà, Gam ka xu gha tc'ãà a Betesaida koe qõò ka, Gam qanega qaù a ko khóè ne qõòa q'aakagu ka. ");
INSERT INTO nhr_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eẽm ko x'áè nea xg'ara kam ko xàbì ba q'ábà qaò a síí còrè. ");
INSERT INTO nhr_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Eẽs ko cáḿ sa dqòa kam kò dxòro ba tshàam nqáè koe hàna, Me kò Gabá góḿankg'ai koe cúíse hàna. ");
INSERT INTO nhr_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Dxòro ba xu kò ko xháé-xháésase qõòkagu sam kò bóò, tc'ãá ba xu kò q'óá-kg'ama khama, kam kò q'uu-kg'ai-q'oo ka hàà cgae xu, tshàam tc'amkg'ai koe náà qõò a, qàea xu koem kò hãa a ko nqáé xu, ");
INSERT INTO nhr_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","igaba ẽe xu kò bóò Me, Me tshàam tc'amkg'ai koe xóé a ko náà qõò, ka xu kò tc'ẽea máá dca̱usoma Me e, ta tc'ẽea hãa, a xu a kaisase q'au. ");
INSERT INTO nhr_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wèéa xu ga kò bóò Me khama, a xu a kaisase q'aea. Me gaa x'aè kaga kg'ui cgoa xu a máá: “Tíí Ra a, ke xao tòón tcáó! Táá q'áò guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Eẽm ko dxòrom koe gaxu cgoa q'ábà kam kò tc'ãá ba téé. Xu kò kaisase area. ");
INSERT INTO nhr_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pérén kaga xu kò q'ãa tama, i tcáóa xu ga qari-qarièa khama. ");
INSERT INTO nhr_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eẽ xu ko tshàa ba tchoaba ka xu kò Genesarete dim nqõóm koe hàà, a xu a gaa koe gaxu dim dxòro ba tòó. ");
INSERT INTO nhr_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eẽ xu ko gaxu dim dxòrom koe tcg'oa, ka ne ko khóè ne kúúga Jeso ba bóòa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A ne a wèé x'áéan koe qgóéa te, a tshoa-tshoa a tcìì-khoean gaan di tcoàn koe xòóa hãase séèa úú, ẽe ne ko kóḿ i ko máá hànam hãa téméè qgáì koe. ");
INSERT INTO nhr_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Me ẽem ko nqõó-coa zi koe hẽé, naka x'áé xu koe hẽé naka nqõóm di c'ẽe xòèan koe hẽéthẽé tcãà ka tsàako khóèan Gam koe séè a úúè, a síí gúù zi ko x'ámáguè qgáì koe xòóè, a dtcàrà Me, kg'amaga ne gha Gam dim qgáím xgáḿ-kg'am qgóó sa, ne kò wèéa ne ẽe ko qgóó Me ne kg'õèkaguè. ");
INSERT INTO nhr_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Xu Farasai xu hẽé naka Jerusalema koe kò guua hãa xu x'áè xgaa-xgaa-kg'ao xu c'ẽe xu hẽéthẽé Jesom koe hààra xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ka xu ko c'ẽe xu xgaa-xgaase-kg'ao xu bóò, xu ko cg'uriga tshàuan cgoa tc'õó, xg'aà tshàu tamase. ");
INSERT INTO nhr_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Farasai xu hẽé naka wèé ne Juta ne hẽéthẽéa kò ncìí cauan tsgõosea ne di koe ga guu a xg'aà tshàu tama ne hãas cookg'ai koe tc'õó tama. ");
INSERT INTO nhr_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Eẽ ne kò x'ámágu dis qgáìs koe guua hãa ne ne tshàua ne xg'aà tamas cookg'ai koe tc'õó tama. Gataga ne kò káí cauan c'ẽe úúa hãa, kubian hẽé naka suuan hẽé naka tc'õó cgoa di zi gàba zi hẽé naka tcoà xu hẽéthẽé xg'aà di i.) ");
INSERT INTO nhr_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Xu nxãaska Farasai xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé Jeso ba tẽè a máá: “Dùús domka xu Tsari xu xgaa-xgaase-kg'ao xu gatá ka tsgõosea ne di cauan khama ma kg'õè tama, a ko cg'uriga tshàua xu cgoa péréan tc'õó?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Me Jeso ba xo̱a xu a máá: “Eẽm kò ko Isaia ba porofita kam kòo tseegukaga gaxao qãè khóèan khama ko ma kúrúse xao ka porofita, ncẽe i ma góásea hãa khama a ko máá: ‘Ncẽe ne khóè ne ko kg'áḿa ne cgoa dqo̱m̀ Te, igaba i tcáóa ne Tíí koe nqúù u. ");
INSERT INTO nhr_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Káà hùise ne ko dqo̱m̀ Te, a ko khóè ne di x'áèan xgaa-xgaa,’ témé khama. ");
INSERT INTO nhr_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Nqarim di x'áè-kg'áḿan xao kúrú tama a xao a khóèan di cauan qgóóa qaria hãa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A ba a bìrí xu a máá: “Nqarim di x'áè-kg'áḿan xao gha máàa xguì sa xao q'ana hãa, nxãasega xao gha gaxao di cauan di x'áèan qgóóa qari ka. ");
INSERT INTO nhr_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moshe ba kò ncẽeta mééa a máá: ‘Saò ba hẽé naka saò sa hẽéthẽé tcom,’ a ba a kò gaia máá: ‘Dìím wèém ẽe ko xõòm ka kana xõòs ka cg'ãèse kg'ui ba méém cg'õoè,’ témé, ");
INSERT INTO nhr_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","igaba ncẽè khóèm kò ko xõòm ka kana xõòs ka máá: ‘Eẽr ga ko hùi cgoa tsia sa, nxãa sa Nqari bar nqòòkagua hãas máàku si i khamar ko hùia tsi ka tààè,’ témé ne xao ko ncẽe sa dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Gaa koe guus ka xao guu me nakam xõò ba hẽé naka xõò sa hẽéthẽé c'ẽe gúù ga kúrúa máá tama. ");
INSERT INTO nhr_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gaxao di cauan ncẽe xao kúrúa máásea hãa koe xao guu a Nqarim dim kg'ui ba káà-hùikagua hãa. A xao a kò ẽeta iim dàòm ka káí zi gúù zi kúrú,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","A ba a khóè ne Gam koe gaicara tciia óá, a bìrí ne a máá: “Komsana Te tu wèéa tu ga, naka tua kóḿa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Khóèm ka tchàa koe hãa, a ko gam koe tcãà sa khóè ba cg'uri-cg'uri tama, igaba ẽe ko khóèm koe guu a tcg'oa sa ko khóè ba cg'uri-cg'uris ga si i. ");
INSERT INTO nhr_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Dìím wèém ẽe tceean úúa hãa ba méém kóḿ,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eẽm ko Jeso ba khóè ne koe guu a ko nquum q'oo koe tcãà, ka xu ko Gam di xu xgaa-xgaase-kg'ao xu ẽes sere-seres ka tẽè Me. ");
INSERT INTO nhr_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Me bìrí xu a máá: “Qanega xao gáé kóḿa q'ãa tama? Bóò tama xao gáé hãa? Dùús wèés ẽe ko khóèm koe tchàa za guu a tcãà sa cg'uri-cg'uri me tite, ");
INSERT INTO nhr_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","tcáóa ba koes tcãà tama, a ko ncãàa ba koe tcãà, a gatà ma nqáé khama,” témé. (Ncẽeta mééan kam kòo Jeso ba wèé tc'õoa nea ts'ee-ts'eekg'aièa sa nxàe.) ");
INSERT INTO nhr_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Me máá: “Eẽ khóèm tcáó koe ko guu a tcg'oa sa, gaas khóè ba ko cg'uri-cg'uris ga si i. ");
INSERT INTO nhr_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Igaba i ko q'oo koe, tcáós koe guu a cg'ãè tc'ẽean hẽé, xóé cgoakuan hẽé, ts'ãàn hẽé, cg'õokuan hẽé, ");
INSERT INTO nhr_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","cg'áràn hẽé, cg'ãè zi cau zi hẽé, kàa sa hẽé, cẽèan hẽé, qgóóse tama sa hẽé, cg'ãè tcgáí cgoa bóòku sa hẽé, zàróku sa hẽé, tc'amaka bóòse sa hẽé, naka cg'ãè tcáó sa hẽéthẽé tcg'oa khama. ");
INSERT INTO nhr_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Wèé zi cg'ãè zi ncẽe zia kò q'oo koe guu a tcg'oa a zi a ko khóè ba cg'uri-cg'uri,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Me Jeso ba gaa koem kò guu a tcg'oa ne Ture dim nqõóm koe síí. A gaa koem ko síí ka c'ẽem nquum koe tcãà, a ba a kò tc'ẽe tama c'ẽe khóè gha gaa koem hãa sa q'ãa sa, igabam gha ma xàì sa kò káà si i. ");
INSERT INTO nhr_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kas ko kúúga khóès gas dis cóás kò cg'ãè tc'ẽean ka tcãàèa hãa sa Jesom ka kóḿ, a sa a hàà a nqàrè-kg'ama ba koe cg'áé. ");
INSERT INTO nhr_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Khóès ẽe sa kò Gerika si i, a sa a kò Sirofonike dim nqõóm koe ábàèa hãa. A sa a kò Jeso ba dtcàrà, dxãwa tc'ẽea nem gha cóás koe tcg'òó sa. ");
INSERT INTO nhr_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Me Jeso ba xo̱a si a máá: “Hààn ta kg'aia cóán tc'õókagu, qãè tama i hãa cóán di péréan gha séè a ha̱ghuan xaoa mááè sa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Igabas kò khóè sa xo̱a Me a máá: “Eè, X'aigaè, ẽe tafolean ka nqãaka hàna hãa ha̱ghuan ga ko cóán di péré qàmàn tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Me Jeso ba bìrí si a máá: “Eẽm xo̱am domka si gha qõò, saris cóás koe i dxãwa tc'ẽean tcg'oara hãa khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Si x'áéa sa koe dìbi a sa a síí sao-xg'ae, si cóáse sa tcoàm koe xõe i dxãwa tc'ẽean tcg'oa cgae sia. ");
INSERT INTO nhr_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Me Jeso ba Ture dim nqõóm koe gaicara guu a xgoaba a ba a síí Sitone dim nqõó ba gãá a tshàam Galilea dim koe síí, Dekapolise dim xg'aekum koe. ");
INSERT INTO nhr_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ne kò khóèm ncẽe kò q'omase tcee dòm̀a a kg'ui tama ba Gam koe úú, a ne a dtcàrà Me, síím gha tshàua ba gaam khóèm koe tòó sa. ");
INSERT INTO nhr_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Me Jeso ba khóè ne xg'aeku koe cúía tciia tcg'òó me, a ba a síí gaam khóèm di tcee dòm̀an koe tshàua ba tcãà a ba a tcg'ae a gaam khóèm di ta̱man qgóó. ");
INSERT INTO nhr_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Me Jeso ba nqarikg'ai koe ghùi-kg'ai a ba a kaisase sónò, a bìrí me a máá: “Efata!” témé (ncẽeta i kò mééè ne i ko máá: “Xgobekg'amse,” téméè). ");
INSERT INTO nhr_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I khóèm di tcee dòm̀an xgobekg'amse, i ta̱ma ba ga gataga kgoarase, me qãèse kg'ui. ");
INSERT INTO nhr_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Me Jeso ba khóè ne x'áè, táá ne gha cúí khóè ga bìrí i ka. Igabaga ne kò ẽem ko ma kúrú u khama noose Gam ka kg'ui. ");
INSERT INTO nhr_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ne kò khóè ne kaisase are a máá: “Wèé zi gúù zim qãèse kúrúa hãa, kg'ui taman gam kg'uikagua hãa, a ẽe kóḿ taman ga kóḿkagua hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Eẽ xu cáḿ xu koes kò gaicara kaias xg'aes khóè ne di sa xg'aea, ka ne kò tc'õó ne gha gúù úú tama, Me Jeso ba Gam di xu xgaa-xgaase-kg'ao xu tciia óá, a bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ncẽe ne khóè ner ko thõò-xama máá, ncẽeska ne nqoana cáḿan Tíí cgoa hãa khama, a tc'õó ne gha gúù ga úú tama. ");
INSERT INTO nhr_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ncẽè x'áéa ne koer kòo xàbà ne hãase dìbikagu ne, ne ne gha dàòan q'oo koe qgaè-kg'ai a cg'áé; c'ẽe-kg'áía nea nqúù ka guua hãa khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Xu Gam di xu xgaa-xgaase-kg'ao xu xo̱a Me a máá: “Ncẽem tchàa-xgóóm koe nea gha ncẽe ne khóè ne ntama ma péréan xg'ãà?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Me tẽè xu a máá: “Nta noo péréan xao úúa?” témé. Xu máá: “7 xu péré xu u,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Me Jeso ba xg'ae sa bìrí si góḿan-kg'ai koe ntcõó, Me gaxu péré xu 7 xu séè, a ba a Nqari ba qãè-tcaoa máá xg'ara a khõá q'aa xu, a Gam di xu xgaa-xgaase-kg'ao xu máà xu, nxãasega xu gha khóè ne máà a ka. ");
INSERT INTO nhr_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xu kò gataga thẽé cg'orò x'aù-coan úúa, Me kò gataga Nqari ba qãè-tcaoa máá, a ba a Gam di xu xgaa-xgaase-kg'ao xu máà xu, xu khóè ne máà xu. ");
INSERT INTO nhr_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ne kò tc'õó a ne a xg'ãà, xu kò xgaa-xgaase-kg'ao xu ẽe kò qaùan ka 7 zi q'ore zi tcana cg'oè-cg'oe. ");
INSERT INTO nhr_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Gane ẽe kò tc'õóa hãa nea kò 4,000 khama noo. Me kò qõòa q'aakagu ne, ");
INSERT INTO nhr_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","a ba a gaa x'aè kaga dxòrom q'oo koe tcãà, Gam di xu xgaa-xgaase-kg'ao xu cgoa, a Dalamenuta dim xg'aekum koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farasai xu kò Jeso ba hàà cgae, a tshoa-tshoa a ntcoeku cgoa Me, a xu a qgóó Me xu gha qgáìan qaa ka are-aresas x'áís nqarikg'ai di sa qaa cgae Me. ");
INSERT INTO nhr_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Me nxãaska kaisase sónò a kg'ui a máá: “Dùús domka sa ko ncẽes qhàò sa are-aresas x'áí sa qaa? Tseegukar ko bìrí tu u a ko máá: Cuiskagas ncẽes qhàò sa cúís x'áís ga sa x'áíèa hãa tite!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Me guu xu a dxòrom q'oo koe tcãà, a xgoaba a tshàa ba ba̱ra, a tshàam di c'ẽe xòèan za qõò. ");
INSERT INTO nhr_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Xu kò xgaa-xgaase-kg'ao xu péréan séè c'urùa hãa, a cúím péré ba dxòrom q'oo koe úúa hãa. ");
INSERT INTO nhr_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Me Jeso ba q'ãa-q'ãa xu a máá: “Q'ãa méé xao, naka kòresea hãa Farasai xu hẽé naka Herotem di péré gãé-gãean hẽéthẽé koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Xu nxãaska kg'ui cgoaku a máá: “Péré cgoa xae hàà tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Me Jeso ba tc'ẽea xu q'oo koe hàna sa q'ana hãase bìrí xu a máá: “Dùús domka xao ko péréan xao úú tamas ka kg'ui cgoakua máá? Qanega xao gáé bóòa q'ãa tama kana kóḿa q'ãa tama? Tcáóa xao gáé tsóágase x'óó-x'ooèa? ");
INSERT INTO nhr_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tcgáían xao úúa hãa ka xao gáé bóò tama, a tceean úúa hãa ka xao gáé kóḿ tama? Tc'ẽe-tc'ẽese tama xaoa? ");
INSERT INTO nhr_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eẽr kò ko 5 xu péré xu 5,000 ne khóè ne khõá q'aa máá, ka xaoa kò ẽe kò qaùa hãa péréan ka nta noo zi q'ore zi tcana cg'oè-cg'oe?” témé. Xu xo̱a Me a máá: “12 zi q'ore zi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Me gaia máá: “7 xu péré xu 4,000 ne khóè ner ko khõá q'aa máá xu, ka xaoa kò ẽe kò qaùa hãa péréan ka nta noo zi q'ore zi tcana cg'oè-cg'oe?” témé. Xu xo̱a Me a máá: “7 zi q'ore zi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Me tẽè xu a máá: “Kháé xaoa qanega kóḿa q'ãa tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ka xu kò Betesaida koe síí. Ne c'ẽe ne khóè ne káà tcgáím khóè ba Gam koe óága, a ne a dtcàrà Me, tshàua bam gha tòó cgae me ka. ");
INSERT INTO nhr_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Me kò Jeso ba káà tcgáím khóè ba x'õàa ba koe séè, a x'áém ka tchàa za tcg'oa cgoa me. A ba a ẽem ko tcg'ae tcgáí mea xg'ara, ka tshàua ba tòó cgae me, a tẽè me a máá: “C'ẽe gúù ga tsi ko bóò?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Me ghùi-kg'ai a ba a máá: “Eè, khóèa ner ko bóò, igaba i hìi zi khama ii a ko qõòa te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Me Jeso ba gaicara gaam tcgáí koe tshàua ba tòó, me qãèse bóò, i tcgáía ba qãè, me wèés gúù sa qãèse bóò. ");
INSERT INTO nhr_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Me x'áéa ba koe tsééa úú me a máá: “Táá x'áém q'oo koe tcãà guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeso ba kò Gam di xu xgaa-xgaase-kg'ao xu cgoa Kaesaream Filipim dim qgáìm qàe koe hàna hãa xu x'áé-coa xu koe tcg'oa a síí. Eẽ xu dàò q'oo koe hãa kam ko Gam di xu xgaa-xgaase-kg'ao xu tẽè a máá: “Khóè nea ko máá, dìí Raa témé?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xu xo̱a Me a máá: “‘Johane Tsi tcguù-tcguu-kg'ao Tsi i,’ ta ne ko méé, ne ko c'ẽe ne máá: ‘Elija Tsi i,’ témé, ne ko c'ẽe ne máá: ‘Porofiti xu ka c'ẽe Tsi i,’ témé,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Me gaicara tẽè xu a máá: “Kháé gaxaoa ko máá, dìí Raa?” témé. Me Petere xo̱a Me a máá: “Tsáá Tsia Kreste Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Me Jeso ba qarika x'áè xu, táá xu gha cúí khóè ga Gam ka bìrí sa. ");
INSERT INTO nhr_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Me nxãaska tshoa-tshoa a xgaa-xgaa, Khóèm dim Cóá ba gha káí zi gúù zi koe xgàrase sa, a gha khóè ne di xu kaia xu hẽé, kaia xu peresiti xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu ka hẽéthẽé bóòa xguìè, a gha cg'õoè, a ba a gha nqoana cáḿan qãá q'oo koe x'ooan koe tẽe sa, tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ncẽe sam kò kgoarasease kg'ui, me Petere séèa tcg'òó Me a tshoa-tshoa a dqàè Me. ");
INSERT INTO nhr_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Igabam kò Jeso ba ẽem ko ntcẽè a ko Gam di xu xgaa-xgaase-kg'ao xu bóò ka Petere ba dqàè a máá: “Tíí koe tcg'oa, satanaè! Nqarim di zi gúù zi koe tsi tc'ẽea tsi tcãà tama, igaba tsi khóèan di zi gúù zi koe tcãà tc'ẽea ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Kam ko kaias xg'aes khóè ne di sa hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé Gam koe tciia óá, a bìrí ne a máá: “Ncẽè c'ẽem khóèm kò xùri Te kg'oana ne méém bóòa xguìse naka baa gam dim xgàu ba dcẽé naka xùri Te. ");
INSERT INTO nhr_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dìím wèém ẽe gam dis kg'õè sa qgóóa qari kg'oana hãa bas gha aaguse cgae, igaba dìím wèém ẽe ko Tíí hẽé naka qãè tchõàn hẽéthẽé domka gam dis kg'õès ka aaguse cgaeè, ba gha hòò si khama. ");
INSERT INTO nhr_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dùúska ba gha khóè ba kháé ka̱bisea mááè, ncẽè wèém nqõó bam kòo hòò, a ba a gam dis kg'õès ka aaguse cgaeè ne? ");
INSERT INTO nhr_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kana ba gha khóè ba gam dis kg'õès téé-q'oo koe dùútsa gúù sa tcg'òó a máà? ");
INSERT INTO nhr_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Dìím wèém ẽe ko Tíí hẽé naka Tiri kg'uian hẽéthẽé sau-cgaese ba, ncẽes qhàòs cg'áràn hẽé naka cg'ãèan hẽéthẽé dis koe, ba gha thẽé Khóèm dim Cóám ka sau-cgaeseè, ẽem gha ko tcom-tcomsa xu moengele xu cgoa, Xõòm di x'áàn koe hãase hàà ne,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Me bìrí xu a máá: “Tseegua ner ko bìrí xao o: Ncẽe koe téé-tẽe ne ka c'ẽea nea x'ooan xám̀a hãa tite, Nqarim di x'aia ne ne bóò, i qarian cgoa hàà tamas cookg'ai koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jeso ba kò 6 cáḿan qãá q'oo koe Petere ba hẽé naka Jakobo ba hẽé naka Johane ba hẽéthẽé xu séè a gaxu cúí xu cgoa kaiam xàbì ba q'ábà qaò; i kò gaa koe ga cookg'aia xu koe bóòse-q'ooa ba ka̱bise a tãá. ");
INSERT INTO nhr_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gam di qgáía ne kò ka̱bise a tca̱àkose q'úú, ncẽe cúí khóè ga nqõómkg'ai koe qgáían xg'aà naka i q'úúa hãa titem q'úú ba. ");
INSERT INTO nhr_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ka tsara kò kúúga Elija ba hẽé naka Moshe ba hẽéthẽé tsara gaa koe bóòse, a ko Jesom cgoa kg'ui. ");
INSERT INTO nhr_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Me Petere ba Jeso ba bìrí a máá: “X'aigaè, qãès gúù si i ncẽe xae ncẽe koe hãa sa. Ke hàà naka xae nqoana nquu-coa xu ncẽe koe kúrú, nakam c'ẽe ba Tsari, nakam c'ẽe ba Moshem di, nakam c'ẽe ba Elijam di,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","C'úùam kò hãa dùú sam gha kg'ui sa, kaisase xu kò q'aea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Si kò túú-c'õò sa qàbia tcãà xu, me kò kg'ui ba túú-c'õòs q'oo koe guu a tcg'oa a máá: “Ncẽe ba Tirim Cóá Me e, ncàm̀a Raa ba, komsana Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Eẽ xu ko qháése ntcẽè ka xu kò cúí khóè ga táá bóò, a Jesom cúím Gabá bóò. ");
INSERT INTO nhr_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eẽ xu ko xàbìm koe xõa kam kò x'áè xu, táá xu gha ncãa xu ko bóòs gúù sa cúí khóè ga bìrí sa, qaneam Khóèm dim Cóá ba síí x'ooan koe tẽe tamas còokg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Xu gaam kg'ui ba tcáóa xu koe tòóa mááse, a gaxu ka tẽèku: x'ooan koe tẽes ko dùú sa nxàe sa. ");
INSERT INTO nhr_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Xu nxãaska tẽè Me a máá: “Dùús domka xu ko x'áè xgaa-xgaa-kg'ao xu máá: ‘Elija ba méém kg'aia hàà’?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Me Jeso ba bìrí xu a máá: “Elija ba ko kg'aia hàà wèé zi gúù zi kg'ónò; ka i dùús domka góáèa hãa, Khóèm dim Cóá ba méém xgàrase, naka baà khóè ne ka xguìè, ta ma ma? ");
INSERT INTO nhr_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Igabagar ko Elijam hààraa hãa sa bìrí xao o, ne kò wèés gúùs ẽe ne kò tc'ẽea hãa sa kúrú cgae me, ẽe i kò ma gaam ka ma góásea hãa khamaga ma,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eẽ xu ko xgaa-xgaase-kg'ao xu koe hàà, ka xu ko kaias xg'ae sa bóò si nxa̱ma-nxa̱ma xua hãa, xu x'áè xgaa-xgaa-kg'ao xu hãa a ko ntcoeku cgoa xu. ");
INSERT INTO nhr_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Si kò kúúga wèés xg'ae sa Jeso ba bóò, a sa a kaisase are, a qàròa síí cgae Me a síí tsgám̀ Me. ");
INSERT INTO nhr_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Me kò tẽè xu a máá: “Dùú sa xao ko ntcoeku cgoa ne?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Me xg'aes koe kò hãam khóèm c'ẽe ba xo̱a Me a máá: “Xgaa-xgaa-kg'ao Tseè, tirim cóá bar Tsáá koe óágaraa, kg'uikagu me tamam dxãwa tc'ẽe bam úúa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wèé x'aèan ẽe i ko qaru cgae me ka i ko qáú me, me kg'áḿ-q'ooa ba koe xùbúan tcg'òó, a xõ̱óa ba gãò, a xgàruku. Ra ncãa Tsari xu xgaa-xgaase-kg'ao xu dtcàrà, xhàia xu gha guu u ka, igaba xu ko tààè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Me Jeso ba xo̱a ne a máá: “Oo, tsóágase dtcòm̀ úú tamas qhàò sa gáé ncẽe sa! Nta noo x'aèa ne Ra gha gatu cgoa hãa? Nta noose Ra gha qáò-tcaoa máá tu u? Oá me Tíí koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne ko cóá ba Gam koe óá. Eẽ i ko gaa dxãwa tc'ẽean Jeso ba bóò kaga i kò cóá ba qarika ntcãa-ntcãa, me góḿankg'ai koe cg'áé a dìbi-dibise, i kg'áḿ-q'ooa ba koe xùbúan tcg'oa. ");
INSERT INTO nhr_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Me Jeso ba cóám ka xõò ba tẽè a máá: “Nta noo x'aèan ba úúa a ko ncẽeta hẽé?” témé. Me cóám ka xõò ba máá: “Cg'áré-q'ooa ba koe ga i guu a tshoa-tshoa mea hãa. ");
INSERT INTO nhr_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Káí-kg'aise ẽe i kò ko tshoa-tshoa me ne i ko c'eean q'oo koe xaoa tcãà me naka tshàan q'oo koe hẽéthẽé e, cg'õo me i gha ka, igaba ncẽè c'ẽe gúù tsi ga kòo kúrú ne méé tsi thõò-xama máá ta a naka hùi ta a!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Me Jeso ba bìrí me a máá: “A ncẽè dtcòm̀a tsi kò hãa ne i wèé gúùan ga thamka a,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kúúgam ko cóám ka xõò ba q'au a máá: “Dtcòm̀ ra ko, ke tiris káà dtcòm̀s koe hùi te!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eẽm ko Jeso ba xg'ae sa bóò si ko qàròa síí cgae Me, kam ko cg'ãè tc'ẽean dqàè a máá: “Tsáá tc'ẽe tsi nqóbó a q'omasen tcee dòm̀a tseè, dqàè tsir ko a ko máá, tcg'oa cgae me naka táá gaia gam koe tcãà guu!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka i ko dxãwa tc'ẽean q'au, a ẽe i ko kaisase qgaè-qgae-kg'ai mea xg'ara ka tcg'oaragu me. Me kò cóá ba x'óóam khóèm khama ii, ne káí ne khóè ne tc'ẽea máá, x'óóam hãa, ta tc'ẽea. ");
INSERT INTO nhr_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Me Jeso ba tshàua ba koe qgóó a ghùi me, me tẽe a nqàrè ka téé. ");
INSERT INTO nhr_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eẽm ko nquum q'oo koe tcãà, ka xu kò Gam di xu xgaa-xgaase-kg'ao xu dxùukg'ai koe tẽè Me a máá: “Dùús domka xaea kò tààè, a xhàiagu u tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Me Jeso ba xo̱a xu a máá: “Ncẽeta iia nea c'ẽe gúù kaga tcg'òóèa hãa tite, igaba còrèan ka cúíga a,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Eẽm qgáìm koe xu kò tcg'oa a Galilea dim nqõó ba tchoaba. Jeso ba kò c'ẽe khóèan ga gha hàna xu hãa qgáìan q'ãa sa tc'ẽe tama, ");
INSERT INTO nhr_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Gam di xu xgaa-xgaase-kg'ao xum kòo xgaa-xgaa khama, a ko bìrí xu a máá: “Khóèm dim Cóá ba gha hàà khóè ne tshàu q'oo koe tcãàè, ne gha cg'õo Me, Me gha ẽem cg'õoèa ka nqoana cáḿan qãá q'oo koe tẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Igaba xu kò ẽem ko méé sa táá kóḿa q'ãa, a xu a kòo gataga thẽé tẽèa ba q'áò. ");
INSERT INTO nhr_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xu kò Kaperenaume dim nqõóm koe síí. Me ẽe xu nquum q'oo koe hãa ka tẽè xu a máá: “Dùú sa xao ncãa ko dàòm q'oo koe ntcoekua máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Igaba xu kò nqoo, ncãa xu dàòm q'oo koe kg'ui cgoaku dìína kaia hãas ka khama. ");
INSERT INTO nhr_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Me ntcõó a ba a 12 xu tciia xg'ae a bìrí xu a máá: “Ncẽè c'ẽem khóèm kò tc'ãà di ba ii kg'oana hãa, ne méém wèé ne ka kháóka ka dis téé-q'oos di ba ii, naka qãà ba ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A ba a cg'árém cóá ba séè a xg'aekua xu koe tòó, a séè a tchàma me, a bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Dìím wèém ẽe ko ncẽeta iim cóá ba Tiri cg'õèan koe qãèse hààkagu ba ko Tíí tc'áróga qãèse hààkagu; me dìím wèém ẽe ko Tíía qãèse hààkagu Te ba, Tíía qãèse hààkagu Te tama, igabam ko Gam ẽe tséé Tea hãa ba qãèse hààkagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Me Johane ba bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, c'ẽem khóè ba xae kò bóò, me ko Tsari cg'õèan cgoa dxãwa tc'ẽean xhàiagu, xae kò sixae ka c'ẽem tama me e domka gatà hẽéan cara me,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Igabam kò Jeso ba máá: “Táá cara me guu. C'ẽem khóèm ẽe ko Tíí cg'õè cgoa kaias tséé sa kúrú ba qháése ka̱bise naka Tíí ka cg'ãèse kg'uia hãa tite ke, ");
INSERT INTO nhr_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ẽe gaxae cgoa ntcoeku tama ba gaxae xòè koe hàna khama. ");
INSERT INTO nhr_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tseeguan kagar ko bìrí xao o a ko máá: Dìím wèém ẽe ko Tiri cg'õèan domka qgàisa tshàan dis kubi sa máà xao o, Krestem di xao o domka ba gha tseeguan kaga Gam di surutan hòò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Dìím wèém ẽe ko ncẽe ne cg'áré ne ncẽe ko Tíí koe dtcòm̀ ne ka c'ẽe ba chìbian kúrúkagum ka i gha qãè ii, gáí cgoa dis nxõ̱ás kaias kòo qg'áóa ba koe qáéa tòóè, me kaiam tshàam q'oo koe xaoa tcãàè ne. ");
INSERT INTO nhr_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“A ncẽè tsarim tshàum kòo chìbi kúrúkagu tsi ne, q'ãea tcg'òó me. Qãèa i máá tsia, nqo̱ara tshàu tsi gha a kg'õès koe tcãà sa, cám̀ x'õà tsi gha a chõò tamas c'ees dxãwam dis q'oo koe tcãàn ka ke. ");
INSERT INTO nhr_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","“A ncẽè nqàrèa tsi kò ko chìbian kúrúkagu tsi ne, q'ãea tcg'òó o. Qãèa i gha máá tsia, cúí c'õá tsi gha a kg'õès koe tcãà sa, cám̀ c'õá a chõò tamas c'ees dxãwam dis q'oo koe tcãàn ka ke. ");
INSERT INTO nhr_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“A ncẽè tsarim tcgáím kò ko chìbian kúrúkagu tsi ne, ho̱bèa tcg'òó me. Cúí tcgáí a Nqarim di x'aian koe tcãà sa qãè si i, cám̀ tcgáí a chõò tamas c'ees dxãwam dis q'oo koe tcãàn ka ke, ");
INSERT INTO nhr_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ncẽe gaa koe hàna ne di nxa̱ian x'óó tama koe, c'eem ts'irì tamam koe. ");
INSERT INTO nhr_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Wèém khóè ba gha c'eean cgoa tsa̱ubereè, si gha wèés dàòa-mááku sa ta̱bean cgoa tsa̱ubereè. ");
INSERT INTO nhr_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ta̱bea ne qãè e, igaba gaan di tsa̱u-q'ooan kòo káà, ne i gha gaicara ntama ma kúrúè a tsa̱u? Gatu xg'aeku koe méé tu ta̱bean khama ii, naka tua tòókuan úúa hãase c'ẽe ne cgoa x'ãè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Me kò Jeso ba gaa koem ko guu ka Jutea dim xg'aekum koe síí, a Jorotane dim tshàa ba tchòaba, zi kò khóè ne di zi xg'ae zi gaicara xg'ae cgoa Me, Me caua ba a kò ii khama gaicara xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xu kò Farasai xu hàà cgae Me, a xu a kúrúa xu kòo bóò Me khama tẽè Me a máá: “A x'áèan koe ia kgoaraèa khóèm gha gam dis khóè sa aagu sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Me Jeso ba tẽèm cgoa xo̱a xu a máá: “Moshe ba kò ntama ma x'áè xao o?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xu máá: “Moshe ba xg'ao khóè ba kgoara máá aagukuan dis tcgãya sam gha góá, a gam dis khóè sa aagu sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Me Jeso ba bìrí xu a máá: “Gaxao di qari tcúúan domkam kò Moshe ba ncẽem x'áè ba góá máá xao o. ");
INSERT INTO nhr_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Igabam xg'ao Nqari ba nqõóm ko tshoa-tshoase koe ga guu a khóè ba hẽé naka khóè sa hẽéthẽé kúrúa. ");
INSERT INTO nhr_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Gaa domkagam gha khóè ba xõò ba hẽé naka xõò sa hẽéthẽé khara guu, a ba a gha gam dis khóès koe tc'àmàse, ");
INSERT INTO nhr_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","khara gha nxãaska ẽe khara cám̀ khara cúím tc'áró ba kúrú, a gaicara cám̀ ii tite, igaba khara gha cúím tc'áró ba ii. ");
INSERT INTO nhr_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Gaa domka méés ẽem Nqari ba xg'ae-xg'aeèa hãa sa táá cúí khóè kaga q'aa-q'aaè guu,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Eẽ xu Gam cgoa nquum q'oo koe hãa ka xu ko xgaa-xgaase-kg'ao xu gaicara ncẽes gúùs ka Jeso ba tẽè. ");
INSERT INTO nhr_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Me kò bìrí xu a máá: “Dìím wèém ẽe ko gam dis khóè sa aagu, a ko c'ẽes khóè sa séè ba ko cg'áràn kúrú, ");
INSERT INTO nhr_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","a ncẽè gaas igabas kòo gas dim khóè ba aagu, a ko c'ẽem khóè ba séè nes ko cg'áràn kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ne kò khóè ne cóán Gam koe óá, tshàua bam gha tòó cgae e ka, xu kò Gam di xu xgaa-xgaase-kg'ao xu dqàè ne. ");
INSERT INTO nhr_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Igaba ẽem ko Jeso ba ẽe sa bóò kam kò kaisase xgóà, a bìrí xu a máá: “Cóán guu naka i Tíí koe hàà. Táá xgáè-kg'am m guu, Nqarim di x'aia nea gatà ii ne di i ke. ");
INSERT INTO nhr_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tseegua ner ko bìrí tu u a ko máá: Dìím wèém ẽe Nqarim di x'aian, cóán ko ma séè e khama ma séè e tama ba cuiskaga gaan koe tcana hãa tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","A ba a nxãaska gaa cóán séè a tchàma, a tshàua ba tòó cgae e, a ts'ee-ts'eekg'ai i. ");
INSERT INTO nhr_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Eẽm ko Jeso ba xgoaba a ko dàòa ba koe qõò, kam kò khóè ba qàròa síí cgae Me, a síí cookg'aia ba koe qhòm tsi qúrùa ntcõó, a tẽè Me a máá: “Qãè Tsi xgaa-xgaa-kg'ao Tseè, nta ra gha hẽé a nxãasega chõò tamas kg'õè sa hòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Me Jeso ba bìrí me a máá: “Dùúska tsi ko qãè tsi khóè Tseè ta ma tcii Tea máá? Cúí khóè qãè ga káà a, igaba Nqarim cúí Me e. ");
INSERT INTO nhr_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","X'áèan tsi q'ana hãa: Táá cg'õo guu, táá cg'áràn kúrú guu, táá ts'ãà guu, táá tshúù-ntcõan nxàe guu, táá kàan cgoa gúùan séèa mááse guu, saò ba hẽé naka saò sa hẽéthẽé tcom, ta ko méé e,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Me bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, ncẽe zi gúù zir ncìísega tshoa-tshoa a cóár ii koe ga ko kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Me kò Jeso ba ẽem ko bóò me ka ncàm̀ me, a bìrí me a máá: “Cúís gúù sa tsi ko tcào. Qõò naka tsia síí wèés gúùs ẽe tsi úúa hãa sa x'ámágu, naka tsia ẽe dxàua hãa ne khóè ne máà, naka tsia gha nxãasega nqarikg'ai koe qguù sa úúa hãa, naka hàà xùri Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Me kò ncẽes gúùs ka tshúù-tcaokaguè, a kò tshúù-tcaoa hãase qõò, káí zi gúù zim kò q'õòa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Me kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu ntcáà a ba a máá: “Tsóágase i gáé gha qaria, gane ẽe qguùa hãa ne khóè ne gha Nqarim di x'aian koe tcãà sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Xu kò Gam di xu xgaa-xgaase-kg'ao xu Gam di kg'uian ka kaisase area. Igabam kò Jeso ba gaia bìrí xu a máá: “Cóá xaoè, tsóágase i gáé qaria Nqarim di x'aian koe tcãà sa. ");
INSERT INTO nhr_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kameles ga dqààm tcgáí di kòm̀an koe tcãà sa thamka si i, qguùam khóèm gha Nqarim di x'aian koe tcãàs ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Xgaa-xgaase-kg'ao xu kò kaisase are, a xu a tẽè Me a máá: “Kháé ba gha nxãaska dìí ba kgoaraè?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Me Jeso ba bóò xu a máá: “Khóèa ne ko tààè, igabam Nqari ba tààè tama, wèé gúùa ne Nqarim koe subu u khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Me nxãaska Petere ba tshoa-tshoa a bìrí Me a máá: “Bóò, wèé gúùan ga xae guua hãa a ko xùri Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Me Jeso ba máá: “Tseegua ner ko bìrí xao o a ko máá: Wèém khóèm ẽe gha Tíí hẽé naka Tiri qãè tchõàn hẽéthẽé domka x'áéa ba guu, kana káíkhoea ba, kana qõea ba, kana xõò sa, kana xõò ba, kana cóáa ba, kana xháràa ba ga igaba, ");
INSERT INTO nhr_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nxãa ba gha 100 q'oro noose hòò o: x'áéan ga hẽé, naka káíkhoea ba ga hẽé, naka qõea ba ga hẽé, naka dxàe xõòa ba ga hẽé, naka cóáa ba ga hẽé, naka xháràn ga hẽé, naka xgàrakuan ga hẽéthẽé e, ncẽeta hãa x'aèan kaga, a gataga hààko x'aèan ka chõò tamas kg'õè sa hòò. ");
INSERT INTO nhr_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Igaba ẽe káí ne còoka hàna nea gha kháóka di ne ii, ne gha ẽe kháóka hãa ne còoka di ne ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Xu kò dàòm q'oo koe hãa a ko Jerusalema koe qõò, Me Jeso ba tc'ãà-cookg'ai xua, xu kò xgaa-xgaase-kg'ao xu kaisase area hãa, ne kò ẽe ko xùri Me ne q'aea hãa. Me kò gaicara 12 xu xgaa-xgaase-kg'ao xu séèa tcg'òó, a tshoa-tshoa a dùútsa gúùs gha hàà kúrúse cgae Me sa bìrí xu ");
INSERT INTO nhr_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","a máá: “Bóò, Jerusalema koe xae ko qõò, Me gha Khóèm dim Cóá ba kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé tshàu q'oo koe tcãàè. Xu gha x'oos koe chìbi-chibi Me, a gha tãá zi qhàò zi di ne tshàu q'oo koe tcãà Me, ");
INSERT INTO nhr_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","a nco̱i Me, a kg'áḿ tsharàn cgoa tcg'ae cgae Me, a qoa Me, a cg'õo Me. Igabam gha nqoana dim cáḿ ka x'ooan koe tẽe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tsara kò nxãaska Jakobo ba hẽé naka Johane ba hẽéthẽé tsara síí cgae Me, ncẽe kò Sebetem ka cóáse ii tsara, a bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, wèés gúùs ẽe tsam ko Tsáá koe tc'óà sa méé Tsi kúrúa máá tsam m sa tsam ko tc'ẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Me bìrí tsara a a máá: “Dùú sa ra gha kúrúa máá tsao o sa tsao ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tsara máá: “Kúrúa Tsi gha máá tsam sa ncẽe si i: Tsari x'áàn koe méé Tsi kgoara máá tsam m nakam c'ẽe ba Tsarim x'õàm kg'áòm xòè za ntcõó nakam c'ẽe ba dxàes x'õàs xòè za ntcõó,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Igabam kò Jeso ba bìrí tsara a a máá: “Dùú sa tsao ko dtcàrà sa tsao c'úùa hãa! Kgoana tsaoa gha a kubis Tíí ko kg'áà q'oos koe kg'áà kana tsaoa gha ncẽer tcguù-tcguuèa hãas tcguù-tcguuku cgoa tcguù-tcguuè?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tsara máá: “Kgoana tsam gha a gatá hẽé,” témé. Me Jeso ba bìrí tsara a, a máá: “Kubis ẽer ko kg'áà q'oos koe tsao gha kg'áà, a tcguù-tcguukus ẽer gha ko tcguù-tcguuès cgoa tcguù-tcguuè, ");
INSERT INTO nhr_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","igabaga ncẽe kg'áò x'õàa Te xòè za ntcõó sa hẽé, naka dxàe x'õàa Te xòè za ntcõó sa hẽéthẽér Tíí kgoara máá tama, igaba i nxãan ẽe i kg'ónòa mááèa hãa ne di i,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Eẽ xu ko c'ẽe xu 10 xu xgaa-xgaase-kg'ao xu ncẽe sa kóḿ ka xu ko tshoa-tshoa a kaisase Jakoboa tsara Johanea tsara xgóà cgae. ");
INSERT INTO nhr_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Me Jeso ba Gam koe tciia óá xu a bìrí xu a máá: “Q'ana xao hãa, ẽe tãá zi qhàò zi koe koma x'aiga ii xu ko gaxu di qarian gane koe tséékagu sa, xu ko gane di xu tc'ãà-cookg'ai xu gaxu di qarian gane koe x'áí sa. ");
INSERT INTO nhr_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Igaba méé i gaxao koe táá gatà ii guu, igaba ẽe ga gaxao ka kaia hãa ba méém gaxao dim tséé-kg'ao ba ii, ");
INSERT INTO nhr_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","nakam dìím wèém ẽe gha gaxao ka tc'ãà-tc'ãase ba wèém khóèm dim qãà ba ii. ");
INSERT INTO nhr_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Khóèm dim Cóá ba hààraa, hààm gha tsééa mááè ka tamase, igabam hààraa, hààm gha khóè ne tsééa máá ka khama, a ba a hààraa, kg'õèa bam gha hàà khóè ne máà ka, káí ne khóè ne di chìbia nem gha x'ámá tcg'òó di iise,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Xu kò Jeriko koe hàà. Eẽm ko Jeso ba Jeriko koe tcg'oa, Gam di xu xgaa-xgaase-kg'ao xu cgoa hẽé naka káí ne khóè ne cgoa hẽéthẽé e, kam ko káà tcgáím dtcàrà-kg'aom Baretimaiom, Timaiom ka cóáse ba dàòm qàe koe ntcõóa-ntcõe. ");
INSERT INTO nhr_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eẽm ko kóḿ Jesom Nasareta di Me e sa kam ko tshoa-tshoa a q'au a máá: “Jesoè, Dafitem ka tsgõose-coa Tseè, thõò-xama máá te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ne káí ne dqàè me a máá, nqoo méém témé, igabam ko kaisase q'au a máá: “Dafitem ka cóáse Tseè, thõò-xama máá te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Me Jeso ba téé a ba a máá: “Tcii me,” témé. Ne ẽe káà tcgáím khóè ba tcii, a bìrí me a máá: “Tòón tcáó naka tsia tẽe, tcii tsim ko ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Me gaam khóè ba gam dim ko̱à ba ncemeagu, a ba a nxàìa tẽe a Jesom koe síí. ");
INSERT INTO nhr_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Me Jeso ba tẽè me a máá: “Dùú sar gha kúrúa máá tsi sa tsi ko tc'ẽe?” témé. Me káà tcgáím khóè ba bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, bóòr gha sar ko tc'ẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Me Jeso ba bìrí me a máá: “Qõò, tsari dtcòm̀a nea qãèkagu tsia hãa ke,” témé. Me kò kúúga bóò, a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eẽ ne ko Jerusalema koe hẽé naka Betefage koe hẽé naka Betania koe hẽéthẽé cúù, Olife dim xàbìm koe, kam kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu ka cám̀ tsara tsééa tcg'òó, ");
INSERT INTO nhr_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a bìrí tsara a, a máá: “Gatsao cgoa q'óá-kg'amkua hãam x'áém koe tsao qõò. Eẽ tsao ko tcãà ne tsao gha qanega cúí khóè kaga qábìè ta ga hãam donghi-coa ba hòò me qáésea tẽe; kgoara naka Tíí koe óága me. ");
INSERT INTO nhr_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A ncẽè c'ẽe khóè kòo tẽè tsao o, dùúska tsao ko ncẽeta hẽé sa ne méé tsao bìrí i naka máá: ‘X'aiga ba ko qaa me, a ba a gha kúúga ka̱bi me,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tsara qõò a síí donghi-coa ba sao-xg'ae, me xhàrom-kg'áḿ ka tchàa koe qáéa tòóèa, tsara kgoara me. ");
INSERT INTO nhr_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ne kò c'ẽe ne khóè ne gaa koe kò téé-tẽe ne tẽè tsara a, a máá: “Dùú sa tsao ko kúrú, a ko donghi-coa ba kgoara máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Tsara kò ẽem ko ma Jeso ba ma bìrí tsara a khamaga ma bìrí ne, ne guu tsara a, tsara qõò. ");
INSERT INTO nhr_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A tsara a donghi-coa ba Jesom koe óá, a tsara a kò gatsara di qgáían gam koe tcee, Me qábì me. ");
INSERT INTO nhr_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ne kò káí ne khóè ne gane di qgáían dàòm q'oo koe khárà, ne c'ẽe ne hìian di nxã̱án khõá a khárà. ");
INSERT INTO nhr_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Eẽ kòo cookg'aia ba koe qõò ne hẽé naka kháóa ba koe kòo xùri Me ne hẽéthẽéa kò q'au a máá: “Hosana! Ts'ee-ts'eekg'aiè méém ẽe ko X'aigam Nqarim di cg'õèan cgoa hàà ba. ");
INSERT INTO nhr_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ts'ee-ts'eekg'aiè méé i x'aian gatá ka xõòm Dafitem di i, ncẽe kò hàà a, Hosana, ẽe kaisase tc'amaka hàna ba!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Me kò Jerusalema koe tcãà, a tempelem koe síí, a ẽem kò caate a wèé zi gúù zi bóò ka, nxãakamaga i kò dqòara hãa khamam Gam di xu 12 xu cgoa xgoaba a Betania koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Q'uu dim cáḿ ka, ẽe xu Betania koe guua hãa kam kò xàbàa hãa. ");
INSERT INTO nhr_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Khamam kò nqúù ka hãa a faia dis hìi sa bóò, si to̱àràn úúa, kam ko síí cgae si, síím gha c'ẽe gúù ga hòò cgae si ka. Eẽm ko hàà cgae si kam kò cúí gúù ga táá hòò, igaba to̱aran cúí ga a, faia di zi hìi zi gha tc'õoan kúrúm x'aèm tama me e kò ii khama. ");
INSERT INTO nhr_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Kam kò gaas ka máá: “Táá méé i cúí khóè ga gaicara chõò tamase, sáá koe tc'õoan tc'õó guu,” témé. Xu kò Gam di xu xgaa-xgaase-kg'ao xu kóḿ Me. ");
INSERT INTO nhr_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Xu ko Jerusalema koe hàà tcãà, Me kò Jeso ba tempelem q'oo koe tcãà a tshoa-tshoa a khóè ne ẽe hãa a ko x'ámágu ne hẽé naka ẽe ko hàà x'ámá ne hẽéthẽé xhàiagu, a ba a marin ko xg'áḿa q'aa ne di tafolean hẽé naka ntcõó-q'ooan ẽe ko tcíbían x'ámágu ne di hẽéthẽé xùbuku cgoa. ");
INSERT INTO nhr_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A kò cúí khóè ga táá kgoara máá i c'ẽe gúù cgoa ga tempelem q'oo koe nqáé. ");
INSERT INTO nhr_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Me kò khóè ne xgaa-xgaa, a bìrí ne a máá: “Góáse tama i gáé hãa naka máá: ‘Tirim nquu ba gha wèé zi qhàò zi dim còrè-nquu ba ta ma tciiè’ téméè tama? Igaba tu gatu ts'ãà-kg'ao ne di x'ãè-q'ooan kúrú mea!” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Xu kò kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé gaas gúù sa kóḿ, ka xu kò cg'õo Me xu gham dàò ba qaa; bèe Me xu kò ko khama, wèés xg'aes khóè ne di sa kò Gam di xgaa-xgaan ka area hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Eẽ i ko dqòa ka xu kò Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé x'áé-dxoom koe tcg'oa. ");
INSERT INTO nhr_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eẽ xu ko ntcùúkg'ai cgoa nqáé ka xu ko faia dis hìis qàe koe nqáé, a bóò si si to̱bea sa cgoa ga c'óòa hãa. ");
INSERT INTO nhr_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petere ba kò tc'ẽe-tc'ẽese a bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, bóò! Faia dis hìis ncẽe Tsi ncãa ko cgúí sa ncãa nqa̱i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Me Jeso ba xo̱a xu a máá: “Nqarim koe méé xao dtcòm̀an úú. ");
INSERT INTO nhr_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tseegukagar ko bìrí xao o: Dìím wèém ẽe ko ncẽem nxõ̱á xàbì ba bìrí a máá: ‘Tẽe naka tshàam q'oo koe xaoa tcãàè,’ témé, a tcáóa ba q'oo koe káíse tc'ẽe-tc'ẽese tama, igaba ko dtcòm̀, ẽem nxàea hãas gha kúrúse sa, nxãam ka i gha hàà kúrúse. ");
INSERT INTO nhr_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Gaa domkar ko bìrí xao o a ko máá: Dùús wèés ẽe xao ko còrèan cgoa dtcàràs ka méé xao nxãakamaga xao mááè sia hãa sa dtcòm̀, nxãaskas gha gaxao koe kúrúse. ");
INSERT INTO nhr_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Gataga méé xao wèé x'aèan ẽe xao téé ko còrè ka qgóóa mááku, c'ẽe gúù xao kò gaxao ka c'ẽean cgoa úúa hãa ne, nakam gha nxãasega gaxao ka Xõòm ncẽe nqarikg'ai koe hãa ba chìbia xao qgóóa máá xao o. ");
INSERT INTO nhr_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Igaba ncẽè qgóóa mááku tama xao kò hãa nem cuiskaga gaxao ka Xõòm nqarikg'ai koe hãa ba chìbia xao qgóóa máá xaoa hãa tite,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xu gaicara Jerusalema koe hàà. Eẽm ko Jeso ba tempelem q'oo koe tcãà, ka xu kò kaia xu peresiti xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu hẽé, naka khóè ne di xu kaia xu hẽéthẽé hàà cgae Me. ");
INSERT INTO nhr_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","A tẽè Me a máá: “Ndaka qari cgoa Tsi ko ncẽe zi gúù zi kúrú kana ia dìín qarian máà Tsia hãa Tsi ko ncẽe zi gúù zi kúrú?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Me Jeso ba xo̱a xu a máá: “Cúís gúù sar gha tẽè xao o. Xo̱a Te méé xao, nakar gha nxãasega bìrí xao o, ndaka qarian cgoar ko ncẽe zi gúù zi kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Johanem dis tcguù-tcguukus ka bìrí Te: nqarikg'ai koe sa kò guua hãa, kana sa kò khóèan koe guua hãa? Xo̱a Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xu kò gaxu ka c'ẽea xu cgoa xóé a tẽèku a máá: “‘Nqarikg'ai koe e,’ ta xae kò ko méé, nem gha nxãaska tẽè xae e a máá: ‘Kháé xao nxãaska dùús domka dtcòm̀ me tama?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Igaba xae gha máá: ‘Khóèan koe e,’ témé - Khóè ne xu kò ko bèe, Johane ba tseegu dim porofiti me e sa ne kò wèé ne khóè ne q'ana hãa khama.” ");
INSERT INTO nhr_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Xu kò nxãaska Jeso ba xo̱a a máá: “C'úùa xae hãa,” témé. Me kò Jeso ba xo̱a xu a máá: “Tíí igabar bìrí xao o tite, ndaka qarian cgoar ko ncẽe zi gúù zi kúrú sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Me kò tshoa-tshoa a sere-sere zi cgoa kg'ui cgoa ne a máá: “C'ẽem khóè ba kò kg'om xhárà ba xháràa, a ba a kò xhàro ba gaam koe kúrúa nxa̱ma-nxa̱ma, a ba a gõéan ko kúrúèm ha̱é ba hẽé naka tc'amaka qáòm nquu ba hẽéthẽé gaa koe tshào. A ba a c'ẽe xu xhárà-kg'ao xu cgóbè me, a c'ẽem nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Eẽm ko tcuùan dim x'aè ba hàà kam ko qãà ba xhárà-kg'ao xu koe tsééa úú, nxãasegam gha síí kg'om xháràm di tc'õoan c'ẽe séè cgae xu ka. ");
INSERT INTO nhr_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Xu kò séè a xg'áḿ me, a káà gúùse tsééa ka̱bi me. ");
INSERT INTO nhr_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Me gaia c'ẽem qãà ba tsééa úú cgae xu, xu síí tcúúa ba koe thõò-thõo me, a sau-saugase qgóó me. ");
INSERT INTO nhr_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Me kò c'ẽe ba tsééa úú, xu nxãa ba cg'õo. A xu a c'ẽe xu káí xu kaga gataga hẽé, c'ẽe xu xu kò xg'áḿ, a c'ẽe xu cg'õo. ");
INSERT INTO nhr_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Cúím cóám kaisasem kò ncàm̀a hãa bam kò úúa, a ba a kò gaam gabá tsééa úú cgae xu, a bìríse a máá: ‘Tirim cóá ba xu gha tcom a qgóóse,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Igaba xu kò ẽe xu xhárà-kg'ao xu bìríku a máá: ‘Ncẽe ba gúù zi ka q'õòsem ga me e, ke hààn xae cg'õo me, naka zi gha gúù zi gaxae di ii,’ témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Xu kò séè a cg'õo me, a kg'om xháràm ka tchàa koe xaoa tcg'òó me,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Me nxãaska Jeso ba tẽè xu a máá: “Kháé ba gha nxãaska kg'om xháràm ka q'õòse ba hàà dùú sa kúrú?” témé, a ba a máá: “Eẽ xu xhárà-kg'ao xum gha hàà cg'õo, a ba a gha xhárà ba c'ẽe xu xhárà-kg'ao xu máà. ");
INSERT INTO nhr_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Qanega xao gáé ncẽes Tcgãyas Nqarim di sa nxárá tama, ncẽe ko máá: ‘Nxõ̱ás ẽe kò tshào-kg'ao xu ka bóòa xguìèa hãa sa, kaisase cgáés nxõ̱á sa kúrúa hãa. ");
INSERT INTO nhr_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ncẽea X'aigam Nqarim ma kúrúa hãa ga a, si ncẽe sa tcgáí-q'ooa ta koe t'õè si i,’” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka xu ko qáé Me kg'oana, igaba xu kò xg'ae sa bèe, ẽes sere-seres kam kòo gaxua nxàe xu sa xu kò q'ana hãa khama, xu kò guu Me a qõò. ");
INSERT INTO nhr_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ka xu ko nxãaska kháóka c'ẽe xu Farasai xu hẽé naka c'ẽe xu Herotem di xu xùri-kg'ao xu hẽéthẽé Gam koe tsééa úú, nxãasega xu gha síí kg'uim ko zi gúù zi cgoa qgóó Me ka. ");
INSERT INTO nhr_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xu hàà a bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, q'ana xae hãa tseegu di Tsi khóè Tsi i sa, a c'ẽe khóè cgoa ga tchõà úú tama, khóèan di téé-q'ooan Tsi nqábé tama khama. Igaba Tsi ko Nqarim dim kg'ui ba tseeguse xgaa-xgaa. Ka i gáé kgoara mááèa hãa Roma ne dim x'aigam Kaesara ba méém surutaè sa, kana méém táá surutaè saa? Suruta méé ta kana méé ta táá suruta saà?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Igabam kò Jeso ba gaxu dis kàa sa q'ana hãase bìrí xu a máá: “Dùús domka xao ko kúrúa bóò Tea máá? C'ẽem qano mari ba xao máà Te nakar bóò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xu mari ba máà Me, Me bìrí xu a máá: “Dìín dis tcúú sa ncẽe sa, naka gatàa dìín cg'õèa ncẽe e?” témé. Xu máá: “Kaesaram di si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Me Jeso ba bìrí xu a máá: “Eẽ Kaesaram di ii sa Kaesara ba máà, naka ẽe Nqarim di ii sa Nqari ba máà,” témé. Xu kò kaisase are Me. ");
INSERT INTO nhr_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xu kò Saduke xu, ncẽe kò ko máá, x'ooan koe tẽe sa káà si i, témé xu hàà cgae Me, a hàà tẽè Me, a máá: ");
INSERT INTO nhr_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Xgaa-xgaa-kg'ao Tseè, Moshe ba xg'ao x'áèan koe góá a máá, ncẽè khóèm kò káà cóáse khóè sa x'óóa guu, ne méém gam ka qõese ba ẽes dxàe-ntcõa sa séè, naka baà gam ka káímkhoe ba cóán ábà máá. ");
INSERT INTO nhr_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Xu kò 7 xu khóè qõeku xu hàna. Me kò kg'áíaka di ba khóè sa séè a cóán úú tamase x'óó. ");
INSERT INTO nhr_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Me kò cám̀ di ba gaas dxàe-ntcõa sa séè, a gataga cóán úú tamase x'óó. I kò nqoana dim ka gataga cúí ga thẽé ii. ");
INSERT INTO nhr_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Xu kò wèéa xu ẽe 7 xu ga cóá úú tamase x'óó. Si kò khóès ga sa thẽé kháóka x'óó. ");
INSERT INTO nhr_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Eẽ i ko x'ooan koe tẽeè ka sa gha gaxu ka ndakam di saà? Ncẽe wèéa xu 7 xu xg'ao séè sia hãa ka?” ta xu ma tẽè Me. ");
INSERT INTO nhr_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Me Jeso ba xo̱a xu a máá: “Dùús domka xao tsa̱a hãa? Nqarim di zi Tcgãya zi ko méé sa hẽé naka Nqarim di qarian hẽéthẽé xao c'úùa hãa domkaa? ");
INSERT INTO nhr_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Eẽ ne ko khóè ne x'ooan koe tẽe ka ne séèa hãa tite, a ne a séèkuan kgoara mááèa hãa tite, igaba ne gha nqarikg'ai di moengelean khama ii. ");
INSERT INTO nhr_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A ẽe x'óóa hãa ne ko x'ooan koe ghùiès ka xao gáé qanega Moshem dis Tcgãyas koe nxárá ta ga hãa, hìis di tchõàn dim xg'aekum koem kò Nqari ba nta gam ka méé sa a máá: ‘Tíí Ra Abrahamam dir Nqari Ra a, a Isakam dir Nqari Ra a, a Jakobem dir Nqari Ra a,’ tam mééa koe? ");
INSERT INTO nhr_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eẽ x'óóa hãa ne dim Nqarim tama Me e, igabagam ẽe kg'õèa hãa ne di Me e; khama xao kaisase tsa̱a hãa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Me kò c'ẽem x'áè xgaa-xgaa-kg'ao ba hàà, a kóḿ xu xu hãa a ko ntcoeku. Me ẽem ko Jeso ba qãèm xo̱a ba máà xua hãa sa bóòa q'ãa ka tẽè Me a máá: “Ndakam x'áè-kg'áḿ ba wèé xu ka tc'ãà di baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Me Jeso ba xo̱a me a máá: “Wèé xu x'áè-kg'áḿ xu ka tc'ãà di ba ncẽe me e: ‘Oo, Iseraeleè, komsana, gatá dim X'aigam Nqari ba, X'aigam Nqari ba cúí Me e, ");
INSERT INTO nhr_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","naka tsia gha X'aigam tsarim Nqari ba wèé tcáóa tsi cgoa hẽé, wèé kg'õèa tsi cgoa hẽé, wèé tc'ẽea tsi cgoa hẽé, naka wèé qaria tsi cgoa hẽéthẽé ncàm̀,’ témé, ");
INSERT INTO nhr_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Me ko cám̀ di ba máá: ‘Eẽ tsi ma ncàm̀sea hãa khamaga ma méé tsi tsáá ka c'ẽe ba ncàm̀,’ témé. C'ẽe x'áè-kg'áḿ ga káà a ncẽem x'áè-kg'áḿ ka kaia a,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Me kò x'áè xgaa-xgaa-kg'ao ba bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, tseegu Tsi ko, c'ẽean ga káà a, igaba gaam cúí Me e, ");
INSERT INTO nhr_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","gataga i cgáé e, Nqari ba tsi ga wèé tcáóa tsi cgoa hẽé, naka wèé kóḿa q'ãa tsi cgoa hẽé, naka wèé qaria tsi cgoa hẽéthẽé ncàm̀ sa, naka ẽe tsi ma ncàm̀sea hãa khamaga ma tsáá ka c'ẽe ba ncàm̀an hẽéthẽé e. A wèé zi dàòa-mááku zi hẽé naka qhàea-mááku zi ka hẽéthẽé cgáé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Eẽm ko Jeso ba bóò, tc'ẽegasem ncãa xo̱a sa kam kò bìrí me a máá: “Nqarim di x'aian ka tsi nqúù tama,” témé. I kò gaa koe guus ka khóèan bèe, c'ẽe tẽè ga i gha tẽè Me sa. ");
INSERT INTO nhr_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Eẽm Jeso ba tempelem q'oo koe hãa a ko xgaa-xgaa kam kò tẽè ne a máá: “Nta hẽés ka xu ko x'áè xgaa-xgaa-kg'ao xu máá, Kreste ba Dafitem ka Tsgõose-coa Me e, témé? ");
INSERT INTO nhr_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dafitem tc'áró-tc'aroa kò Tcom-tcomsam Tc'ẽem ka kg'uikaguè, a máá: ‘X'aiga ba ko Tirim X'aiga ba bìrí a máá: ‘Kg'áò x'õàa Te xòè za ntcõó nakar nxãakg'aiga síí Tsari cg'õo-kg'aoan nqàrè-kg'ama Tsi koe tòó,’ témé.’ ");
INSERT INTO nhr_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dafitem ga ba ko ‘X'aiga’ ta ma tcii Me, ka ba gha nxãaska ntama gam ka Tsgõose-coa ba ii?” témé. Si kò kaias xg'ae sa qãè-tcaoan cgoa komsana Me. ");
INSERT INTO nhr_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Eẽm ko xgaa-xgaa kam kò Jeso ba máá: “X'áè xgaa-xgaa-kg'ao xu koe méé tu q'õésea hãa, ncẽe ko qáò qgáí-dxooan hã̱a, a x'ámágu di zi qgáì zi koe tsgám̀kagukuan qaa xu, ");
INSERT INTO nhr_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","a ko kaia zi ntcõó-q'oo zi còrè-nquu xu koe qaa xu, naka tcom-tcomsa zi ntcõó-q'oo zi hẽéthẽé e kõ̱èan di zi qgáì zi koe. ");
INSERT INTO nhr_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ncẽe ko dxàe-ntcõa zi di nquuan tc'õóa xgãá, a ko x'áíse xu gha ka qáòse còrè xu. Eẽta ii khóèa ne gha kaisase thõòkase xgàraè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Me kò Jeso ba aban ko tòóèm qgáì ba q'óá-kg'ama hãase ntcõó, a ntcõó a ko xg'aes ko ma gaas di marian tempelean di ma tcãà sa bóò. Ne kòo káí ne khóè ne qguùa hãa ne káí marian tcãà. ");
INSERT INTO nhr_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Si kò dxàua hãas dxàe-ntcõa sa hàà cám̀ qano mari tsara ncemea tcãà, xg'ae-q'ooa tsara kòo thebe dim mari ba kúrú tsara. ");
INSERT INTO nhr_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Me kò Gam di xu xgaa-xgaase-kg'ao xu Gam koe tciia óá, a bìrí xu a máá: “Tseegua ner ko bìrí xao o: Ncẽes dxàe-ntcõas dxàua hãa sa ncãa wèé ne khóè ne nqáéa hãase aban ko tòóèm qgáìm koe marian tcana. ");
INSERT INTO nhr_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wèé ne khóè nea kò gane di qguùan koe guu a tcg'òó, igabas kò gaa sa gas di dxàuan koe guu a wèéan ẽes kò úúa hãa ga tcg'òó khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eẽm ko Jeso ba tempelem koe guu a tcg'oa, kam ko Gam di xu xgaa-xgaase-kg'ao xu ka c'ẽe ba bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, tsóágase t'õè xu nxõ̱á xu hẽé naka nquu xu hẽéthẽéa gáé ncẽe e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Me Jeso ba bìrí me a máá: “Ncẽe xu nquu xu kaia xu tsi ko bóò? Cuiskagas ncẽe koe cúís nxõ̱ás ga sa c'ẽes tc'amkg'ai koe guuèa hãa tite, wèéa zi ga gha xòóa qàrìè,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Me ẽem kò qanega Olife dim xàbìm tc'amkg'ai koe q'ábà ntcõe, a tempele ba q'óá-kg'ama hãa, ka xu ko Petere ba hẽé, Jakobo ba hẽé, Johane ba hẽé naka Anterea ba hẽéthẽé xu dxùukg'ai koe tẽè Me a máá: ");
INSERT INTO nhr_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bìrí xae e, n-cáḿa i gha ncẽe gúùan kúrúse sa, naka gataga ncẽe gúùan wèé ga gha hàà kúrúse dis x'áís gha dùú sa ii sa thẽé?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Me Jeso ba tshoa-tshoa a kg'ui cgoa xu a máá: “Q'ãa xao, naka i táá cúí khóè ga ho̱àkagu xao o guu. ");
INSERT INTO nhr_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Káí ne gha Tíí cg'õè ka hàà a gha máá, ganea Tíí ga Ra a, témé, a ne a gha káí khóèan ho̱àkagu. ");
INSERT INTO nhr_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Naka ẽe tu kòo ncõoan hẽé naka gaan di nxàean hẽéthẽé kóḿ ne méé tu táá q'ae guu. Ncẽe gúùa ne gha kúrúse, igaba i qanega chõò-q'ooan hàà tama ke. ");
INSERT INTO nhr_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nqõóm di zi qhàò zi gha c'ẽe zi qhàò zi cgoa x'ãàku, i gha x'aian x'aian cgoa x'ãàku. Me gha nqõó ba gataga cgùru tãáka zi qgáì zi koe, xàbà ne gha nqõómkg'ai koe tcãà. Zi gha ncẽe zi gúù zi ábàn di thõòan di zi tshoa-tshoase-q'oo zi khamaga xám̀. ");
INSERT INTO nhr_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Igabaga méé tu gatu q'õése, séèè tu gha a qhàìs cookg'ai koe úúè, a tu a gha síí còrè-nquuan koe qoaè, a gha Tíí domka tc'ãà còo-kg'ao xu hẽé naka x'aiga xu hẽéthẽé cookg'ai koe tòóè. Gatà hẽéan ka tu gha Tíí ka nxàea tseegukagu. ");
INSERT INTO nhr_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Kg'aia méé i qãè tchõàn nqõóm di zi qhàò zi wèé zi koe xgaa-xgaaè. ");
INSERT INTO nhr_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Naka ẽe xu kòo séè a ko qhàìs cookg'ai koe úú tu u ne, táá ẽe tu ga kg'ui kg'oana hãas gúùs ka q'áò guu, igaba tu wèés gúùs ẽe tu gha ẽem x'aèm ka máàè sa kg'ui. Gatu tama tu u ẽe gha ko kg'ui tu ke, igaba Tcom-tcomsam Tc'ẽe Me e gha ii. ");
INSERT INTO nhr_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Khóè ba gha qõese ba x'oos koe tcãà, me gha xõò ba gam dim cóám ka gataga hẽé, i gha cóán gaan di xõòan ntcoe, a gha cg'õo o. ");
INSERT INTO nhr_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tu gha Tiri cg'õèan domka wèé khóèan ka hòreè. Igaba gaam ẽe gha qarika téé a chõò-q'oos koe síí ba gha kgoaraè. ");
INSERT INTO nhr_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Igaba ẽe tu ko q'áò-q'aosas gúù sa bóò si ẽes ga kò téé tama qgáì koe tẽe (ẽe ko nxárá ba méém kóḿa q'ãa!), ne méé ne nxãaska ẽe Jutea koe hàna ne xàbìan koe qgóéa síí, ");
INSERT INTO nhr_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","nakam ẽe nquuan tco̱be koe hãa ba táá xõa, naka gam dim nquum q'oo koe tcãà guu, naka síí gaa koe hãa sa séè, ");
INSERT INTO nhr_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","nakam ẽe xháràn koe hãa ba táá ka̱bise naka síí gam di qgáían séè guu. ");
INSERT INTO nhr_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Haò, cg'ãè i gha ii, ẽe zi cáḿ zi ka ẽe ncãàa zi koe cóán úúa zi khóè zi ka hẽé naka ẽe gha ko comkagu zi ka hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ke tu còrè naka i gha táá saò di x'aè ka kúrúse guu. ");
INSERT INTO nhr_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Eẽ xu cáḿ xu ka i gha gatà ii xgàrakuan hãa, ncẽe nqõóm dis tshoa-tshoases koe guu a qanega hãa tama a, ncẽem kò Nqari ba kúrú ba, ncẽes noose ga, a i a gaicara hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","A ncẽè X'aigam Nqarim kò ẽe xu cáḿ xu xòm̀-xom ta ga hãa, ne i cúí khóè ga kgoaraèa hãa tite. Igaba ẽe nxárá tcg'òóèa hãa ne domkam kò ẽe xu cáḿ xu xòm̀-xom. ");
INSERT INTO nhr_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“A ncẽè ẽem x'aèm kam kò c'ẽem khóè ba bìrí tu u a ko máá: ‘Bóò, ncẽe ga Me e Kreste ba,’ kana ko máá: ‘Bóò, ẽe gam síí hãa,’ témé ne méé tu táá dtcòm̀ m guu. ");
INSERT INTO nhr_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tshúù-ntcõan di xu Kreste xu hẽé naka tshúù-ntcõan di xu porofiti xu hẽéthẽéa gha x'áíse, a gha x'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé kúrú, ẽe nxárá tcg'òóèa ne xu gha ho̱àkagu ka, kgoanase i kòo ne. ");
INSERT INTO nhr_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ke méé tu gatu q'õésea hãa, x'aèan cookg'ai koer kò bìrí tu ua hãa ke. ");
INSERT INTO nhr_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Igabagas gha ẽe xu cáḿ xu di xgàrakuan qãá q'oo koe ‘cáḿ sa ntcùú-ntcuuè, me nxoe ba x'áà tite, ");
INSERT INTO nhr_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tco̱nò zi gha nqarikg'ai koe guu a tcheè, i gha nqarikg'aian di qarian ntcãa-ntcãaè.’ ");
INSERT INTO nhr_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ne gha ẽe x'aè ka Khóèm dim Cóá ba bóò, Me túú-c'õòan q'oo koe guu a ko hàà, kaia qarian hẽé naka x'áàn hẽéthẽé cgoa. ");
INSERT INTO nhr_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Me gha nxãaska moengele xu tsééa tcg'òó, a ba a gha Gam di ne ẽe nxárá tcg'òóèa hãa ne wèé xòèan ẽe tc'ãán ko guu za xg'ae-xg'ae, a ba a gha nqõóm di chõò-q'ooan koe guu a síí nqarikg'ai di chõò-q'ooan ko chõò koe guu a Nqarim di ne ẽe nxárá tcg'òóèa hãa ne xg'ae-xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Ke tu faia dis hìis koe xgaa-xgaase: Eẽ i ko gas di nxã̱àn tshoa-tshoa a ko tso̱m, i ko to̱ara sa tso̱m, ne tu q'ana hãa qhóóa ne tcana hãa sa. ");
INSERT INTO nhr_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gataga ẽe tu kòo ncẽe zi gúù zi bóò zi ko kúrúse, ne tu q'ana hãa cúù me e sa, a nquu-kg'áḿan koe hãa sa. ");
INSERT INTO nhr_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tseegukar ko bìrí tu u a ko máá: Ncẽes qhàò sa kaà tite, ncẽe gúùan wèé ga kúrúse tamas cookg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nqarikg'aian hẽé naka nqõókg'aian hẽéthẽéa gha chõò, igaba i Tiri kg'uian chõò tite. ");
INSERT INTO nhr_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Igabaga i cúí khóè ga ẽem cáḿ ba, kana ẽem x'aèm gabá q'ãa tama, moengele xu nqarikg'ai koe hàna xua ga igaba, kana Cóásem ga igaba, Xõòm cúím ka oose. ");
INSERT INTO nhr_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Q'õésea méé tu hãa, naka kókòa hãa, c'úùa tu hãa n-cámám gha ẽem x'aè ba hàà sa ke. ");
INSERT INTO nhr_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Khóèm x'áéa ba koe ko guu a tãám nqõóm koe dàram khama i gha ii: gam dim nquu ba ko guu a qãà xu qarian máà ba, a wèém khóè ba gam di tsééan máà, a ba a nquu-kg'áḿ ba ko kòre ba x'áè, q'õé mem gha sa. ");
INSERT INTO nhr_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Gaa domka méé tu kòresea hãa, n-cámám ko nquum ka q'õòse ba hàà sa tu c'úùa hãa ke, dqòa kaa, kana ntcùú nqáé kaa, kana ghòròan ko kg'ae x'aè kaa, kana ntcùúkg'ai cgoaa. ");
INSERT INTO nhr_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","A ncẽè qháésem kòo hàà ne méém táá hàà sao-xg'ae tu u, naka tu x'óm̀a hãa guu. ");
INSERT INTO nhr_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ncẽer ko bìrí xao o sar ko wèéa tu ga bìrí a ko máá: ‘Q'õése méé tu!’ témé.” ");
INSERT INTO nhr_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","I kò ncẽeska cám̀ cáḿan qaùa hãa Pasekan hẽé naka péré gãé-gãe úú tamas pérés dis kõ̱è sa hẽéthẽé gha kúrúès cookg'ai koe, xu kò kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé kàan qaa, Jeso ba xu gha qgóó a cg'õo di i, ");
INSERT INTO nhr_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","a xu a kò máá: “Kõ̱ès di x'aè ka tamase, nxãaskas gha kaias xg'ore sa khóè ne xg'aeku koe hãa khama,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeso ba kò Betania koe hãa, Simonem ncẽe kò lepero dis tcìì sa úúa hãam dim nquum koe. Eẽm gaa koe hãa a ntcõó a ko tc'õó koes kò khóès alabasetere di nxõ̱án cgoa kúrúèam ts'óó-c'õám koe kò qãè hm̀m xg'ãòm tshãám, kaisa marian di ba qgóóa hãa sa hàà, a hàà alabasetere di nxõ̱án cgoa kúrúèam ts'óó-c'õá ba óè, a Jesom tcúú koe ntcã̱á. ");
INSERT INTO nhr_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ne kò c'ẽe ne khóè ne ẽe kò gaa koe hãa ne xgóà a máá: “Dùús domka ba koáé ncẽem tshãá ba ncẽeta ma kõ̱è cgoaèa máá? ");
INSERT INTO nhr_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ncẽe tshãá nea ga kò x'ámáguèa, kurim di marian di tc'ãò-tc'ãoan cgoa, i ga kò gaan di marian dxàua ne khóè ne máàèa hãa,” ta ne méé. A ne a kaisase mẽé si. ");
INSERT INTO nhr_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Igabam kò Jeso ba máá: “Guu si tu, dùús ka tu ko xgáè sia máá? T'õès tséé sas Tíí koe kúrúa hãa. ");
INSERT INTO nhr_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dxàua ne khóè ne cgoa tu wèé x'aè ka hãa, a tu a gha ẽe tu ko tc'ẽe x'aè ka qãè zi gúù zi kúrúa máá a, igaba tu wèé x'aè ka Tíí cgoa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Eẽs ga kò kúrúa sas kúrúa hãa. Kg'ónòè tamar hãas cookg'ai koes tc'áróa Te tshãán cgoa ntcã̱á hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tseegukar ko bìrí tu a ko máá: Wèém nqõóm ẽe i ko ncẽe qãè tchõàn xgaa-xgaaèm koe, i gha ẽes kúrúa hãa gúùan nxàeè, tc'ẽe-tc'ẽeseès gha ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Me kò nxãaska Jutase Isekariote ba, 12 xu ka c'ẽe ba, kaia xu peresiti xu koe síí, nxãasegam gha síí Jeso ba tshàu q'ooa xu koe tcãà ka. ");
INSERT INTO nhr_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eẽ xu ko ẽe sa kóḿ ka xu ko kaisase qãè-tcao, a bìrí me mari xu gha máà me sa. Me nxãaska qãèm x'aè ba qaa, Jeso bam gha tshàu q'ooa xu koe tcãà di ba. ");
INSERT INTO nhr_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tc'ãà dim cáḿ péré gãé-gãe úú tamas pérés di kõ̱èan dim ka, ẽe xu ko ghùu-coam Paseka di ba cg'õo, ka xu ko Gam di xu xgaa-xgaase-kg'ao xu bìrí Me a máá: “Nda koe xae gha kg'ónòa máá Tsi, naka Tsi síí gaa koe Paseka di tc'õoan tc'õó sa Tsi ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Me Gam di xu xgaa-xgaase-kg'ao xu koe cám̀ tsara tsééa tcg'òó a bìrí tsara a, a máá: “Qõò naka x'áé-dxoom koe síí, c'ẽem khóèm tshàa gàba ba qgóóa hãa ba tsao gha xg'ae cgoa. Xùri me, ");
INSERT INTO nhr_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","naka ẽem kòo nquum ka q'õòse ba tcãà ne bìrí me naka máá: ‘Xgaa-xgaa-kg'ao ba ko máá, cg'áè-nquum Tiri xu xgaa-xgaase-kg'ao xu cgoar gha hàà Paseka di tc'õoan tc'õó ba nda hãa sa?’ témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Me gha tc'amaka hãam nquum kaia, a wèé zi gúù zi tc'ẽeseko zi úúa hãam, nxãakamaga kg'ónòa xg'araèa ba x'áí tsao o, gaa koe tsao kg'ónòa máá xae e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Tsara kò xgaa-xgaase-kg'ao tsara tcg'oa a x'áé-dxoom koe qõò, a síí ẽem kò ma bìrí tsara a hãa khamaga ma sao-xg'ae i ii, tsara ko Pasekan kg'ónòa máá Me. ");
INSERT INTO nhr_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Eẽ i ko dqòa kam kò 12 xu cgoa hàà. ");
INSERT INTO nhr_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eẽ xu hãa a ko tc'õó kam ko Jeso ba máá: “Tseegukar ko bìrí xao o, gaxao ka c'ẽe ba gha khóè ne tshàu q'oo koe tcãà Te, ncẽe koe hãa a ko Tíí cgoa tc'õó ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xu tshoa-tshoa a tshúù-tcaoa, a wèéa xu cúí mana cúí tẽè Me a máá: “A tíí tama raa?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Me xo̱a xu a máá: “Eẽ gaxao 12 xao ka c'ẽe me e, ncẽe ko Tíí cgoa gàbas koe péréan tcguù-tcguu ba. ");
INSERT INTO nhr_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Eẽ i ma Khóèm dim Cóám ka ma góásea khamaga i gha ii, igaba haò, cg'ãè i gha ii, ẽe ko Khóèm dim Cóá ba khóè ne tshàu q'oo koe tcãàm ka! Qãèa i ga kò máá mea hãa, táám ga kò ábàèa hãa sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eẽ xu hãa a ko tc'õó, kam ko Jeso ba péré sa séè, a ts'ee-ts'eekg'ai si, a khõá q'aa si, a máà xu si, a ba a máá: “Séè, ncẽea Tirim cgàa me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A ba a kubi sa séè, a ts'ee-ts'eekg'ai si, a máà xu si, xu wèé xu ga gaas q'oo koe kg'áà. ");
INSERT INTO nhr_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Me bìrí xu a máá: “Ncẽe nea Tiri c'áò o, qáé-xg'aes di i, ncẽe ko káí ne khóè ne di iise ntcã̱águè e. ");
INSERT INTO nhr_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tseegua ner ko bìrí xao a ko máá: Cuiskaga Ra gaicara kg'om dis hìis di gõéan kg'áàa hãa tite, me gha nxãakg'aiga síí ẽem cáḿ Nqarim di x'aian di ba tcãà, gaicara Ra gha ka̱base kg'áà a di ba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Eẽ xu ko cii ba nxáèa xg'ara, ka xu ko tcg'oa a Olife dim xàbìm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Me Jeso ba bìrí xu a máá: “Wèéa xao ga gha khuùagu Te, góásea i hãa a ko máá: ‘Kòre-kg'ao bar gha xg'áḿ, si gha ghùuan dis xg'ae sa qgóéa q'aa,’ téméè khama. ");
INSERT INTO nhr_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Igaba ẽer ko x'ooan koe ghùièa xg'ara ner gha tc'ãà-cookg'ai xao o, a Galilea koe qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Me Petere ba bìrí Me a máá: “Eẽta xu ga ko ma wèéa xu ga khuùagu Tsi, igabar tíí cuiskaga gatà hẽé tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Me Jeso ba bìrí me a máá: “Tseegukar ko bìrí tsi: Ncẽem ntcùúm ka, qanegam ghòrò ba cám̀ q'oro kg'ae tamas cookg'ai koe tsi gha nqoana q'oro xo̱ase Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Igabam kò Petere tcana hãa tcáó cgoa kg'ui a máá: “Tsáá cgoar ga ko x'óó igabagar cuiskaga xo̱ase Tsia hãa tite,” témé. Xu kò wèé xu gatà méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xu Getesemane ta ko ma tciièm qgáìm koe qõò. Eẽ xu ko gaa koe síí kam ko Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Ncẽe koe xao ntcõó, nakar nxãakg'aiga síí xg'ara còrèan cgoa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kam ko Petere ba hẽé, naka Jakobo ba hẽé, naka Johane ba hẽéthẽé xu séè, si kò tshoa-tshoa a kaisas tshúù-tcao sa hẽé nakas nxùrù-tcao sa hẽéthẽé tcãà Me. ");
INSERT INTO nhr_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Me bìrí xu a máá: “Tc'ẽea Tea kaisase thõòan xám̀a hãa, x'óór ga khama noose. Ncẽe koe xao qaù naka q'õé,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Me cg'árése còoka síí a góḿankg'ai koe cg'áé, a ba a còrè, ncẽè kgoanase i kò nem ga ẽem x'aè ba nqáé Me sa, ");
INSERT INTO nhr_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","a ba a máá: “Aboè, Tiri Tsi Xõò Tseè, wèé zi gúù zia Tsáá koe tàà tama, ncẽes kubis xgàrasean di sa Tíí koe séèa tcg'òó. Igaba Tsari tc'ẽean ka, Tíí ko tc'ẽes ka tamase,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","A ba a ka̱bise a síí cgae xu, a síí sao-xg'ae xu xu x'óm̀a hãa, Me Petere ba bìrí a máá: “Simoneè, x'óm̀a tsi gáé hãa? Táá tsi gáé ga kò kg'ama cúím aoaram ga ba kókòa ntcõó a q'õé? ");
INSERT INTO nhr_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Q'õésea méé xao hãa naka còrè, naka xaoa gha nxãasega táá kúrúa bóòkuan koe tcãà guu. Tc'ẽe ba kúrú kg'oana hãa, igabam tc'áró ba kg'amka me e ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Me gaicara ka̱bise a qõò, a síí ẽem ncãa ko ma còrè khamaga ma còrè. ");
INSERT INTO nhr_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eẽm ko gaicara ka̱bise a ko hàà kam kò sao-xg'ae xu xu x'óm̀a hãa, tcgáía xu kò ntcàma hãa khama. Xu kò táá q'ãa nta xu gha ma xo̱a Me sa. ");
INSERT INTO nhr_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Me gaicara nqoana dis ka hàà, a máá: “Qanega xao gáé x'óm̀a hãa, a ko sãa? Ncãa i tc'ãò ncẽeska, x'aè ba ncãa hàà. Bóò, Khóèm dim Cóá ba ko hàà chìbi-kg'ao ne tshàu q'oo koe tcãàè. ");
INSERT INTO nhr_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tẽe xao, naka xae qõò. Eẽ khóè ne tshàu q'oo koe tcãà Team khóè ba cúùse hàna ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Eẽm Jeso ba qanega hãa a ko kg'ui kam ko kúúga Jutase ba hàà, 12 xu ka c'ẽe ba, a káí xu khóè xu cgoa hãa, ntcàuan hẽé naka dxòman hẽéthẽé kò qgóóa hãa xu, a kaia xu peresiti xu koe hẽé, naka x'áè xgaa-xgaa-kg'ao xu koe hẽé naka khóè ne di xu kaia xu koe hẽéthẽé guua hãa xu. ");
INSERT INTO nhr_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Me kò nxãaska ẽe kò khóè ne tshàu q'oo koe tcãà Me ba x'áí sa máà xua hãa a ko máá: “Eẽr gha ko x'obè ba Gaam ga Me e, ke xao qgóó Me naka xaoa q'õé Mea hãase úúa tcg'òó Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Me Jutase ẽem ko hàà ka gaa x'aè kaga Jesom koe síí a máá: “Xgaa-xgaa-kg'ao Tseè,” témé. A x'obè Me. ");
INSERT INTO nhr_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Xu khóè xu Jeso ba séè a qgóó Me. ");
INSERT INTO nhr_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Igabam kò ẽe kò cúùse tẽe xu ka c'ẽe ba gam dim ntcàu ba tsgúùa tcg'òó, a kaiam peresitim dim qãàm dim tcee ba xg'aoa qhòm. ");
INSERT INTO nhr_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Me Jeso ba bìrí xu a máá: “Ts'ãà-kg'ao ba tsãá hààraa khama xao gáé ntcàuan hẽé naka dxòman hẽéthẽé cgoa hààraa, hàà xao gha qgóó Te ka? ");
INSERT INTO nhr_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wèé cáḿ kar kò tempelem koe gaxao cgoa hãa a ko xgaa-xgaa, igaba xao kò gaa koe síí táá qgóó Te. Igaba méés Nqarim di zi Tcgãya zi koe góásea hãa sa nxàea tseegukaguès gúù si i,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Xu kò nxãaska wèé xu xgaa-xgaase-kg'ao xu tcg'oara guu Me a bèe a qgóé. ");
INSERT INTO nhr_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Me c'ẽem qárí-kg'ao-coa ba xùri Me, gúù ga kò hã̱a tama, a kò q'úúm qgáím cgoa tcáḿsea hãa ba, xu ntcàù me ka hẽé, igabam tshàu q'ooa xu koe nxàia tcg'oa, ");
INSERT INTO nhr_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a qgáí ba tshàu q'ooa xu koe qaù, a ba a hã̱a tamase qgóé. ");
INSERT INTO nhr_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ka xu kò Jeso ba kaiam peresitim koe úú. Xu kò nxãaska wèé xu kaia xu peresiti xu hẽé, naka khóè ne di xu kaia xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xu hààra xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Me Petere ba kháóka téé a còò Me, a síí nxãakg'aiga kaiam peresitim dim xhàrom q'oo koe tcãà, a ba a síí kòre-kg'ao xu cgoa c'ees-kg'áḿ koe ntcõó a kùru-kuruse. ");
INSERT INTO nhr_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xu kò kaia xu peresiti xu hẽé naka wèé xu tc'ãà-cookg'ai xu hẽéthẽé Jeso ba xu gha chìbi-chibi a cg'õom dàò ba qaa, igaba xu kò táá hòò kòm̀ Me. ");
INSERT INTO nhr_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Káí xu khóè xu kò ko Gam ka tshúù-ntcõan nxàea tseegukagu khama, igaba zi kò ẽe xu ko nxàe zi gúù zi táá qõòa mááku. ");
INSERT INTO nhr_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tsara c'ẽe tsara tẽea-téé a tshúù-ntcõan Gam ka nxàe a máá: ");
INSERT INTO nhr_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Sitsama kò kóḿ Mea Me ko máá: ‘Tíí Ra gha ncẽem tempelem khóèan tshàu ka tshàoèa ba ko̱bea q'aa, a ra a gha nqoana cáḿan qãá q'oo koe tãá ba tshào, khóèan tshàu ka tshàoè tama ba,’ témé,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Igabagas kò ẽe tsara ko nxàea tcg'òó sa táá qõòa mááku. ");
INSERT INTO nhr_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Me kaiam peresiti ba hàà a gaxu xg'aeku koe téé, a Jeso ba tẽè a máá: “C'ẽe gúù ga Tsi gáé xo̱a tama? Ncẽe tsara khóè tsara ko Tsáá ka nxàe sa gáé dùú saà?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Igabam kò nqoo a táá cúím tẽèm ga ba xo̱a. Me gaicara kaiam peresiti ba tẽè Me a máá: “Kreste Tsi Tsia, Gam ncẽe ts'ee-ts'eekg'aièa hãam di Tsi Cóá Tsi?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Me Jeso ba máá: “Tíí ga Ra a. Khóèm dim Cóá ba tu gha bóò, Me Gaam ẽe wèé qarian úúa hãam dim kg'áòm x'õàm xòè za ntcõóa-ntcõe, a ko nqarikg'ai di túú-c'õòan cgoa xõa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Me kaiam peresiti ba qgáía ba tòàra q'aa a máá: “Dùú di nxàea tseegukagu-kg'ao xae gáé ko qanega qaa? ");
INSERT INTO nhr_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ncãa xao kóḿ kaisas cóèkus ncẽe sa! Gaxaoa ko ntama ma tc'ẽe?” témé. Xu wèéa xu ga xgàra Me a máá, x'oos kam kg'anoèa, témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Xu c'ẽea xu tshoa-tshoa a tcg'ae cgae Me, a qáé tcgáí Me, a xu a xg'áḿku cgoa Me, a bìrí Me a máá: “Porofita naka bìrí xae e ndaka kg'áía xae ncãa xg'áḿ Tsi sa,” témé. Xu kòre-kg'ao xu séè a xg'áḿku cgoa Me. ");
INSERT INTO nhr_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Eẽm kò Petere ba nqãaka qanega xhàrom koe hãa kas kò kaiam peresitim di zi qãà zi ka c'ẽe sa hàà cgae me, ");
INSERT INTO nhr_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","a ẽes ko Petere ba bóò me hãa a ko kùru-kuruse, kas kò qãèse bóò me a máá: “Tsáá igaba tsi kò thẽé Nasareta dim Jesom cgoa hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Igabam kò xo̱ase e a máá: “C'úùar hãa, a ra a kóḿa q'ãa tama, dùús ka si ko kg'ui sa,” témé. A ba a xhàros-kg'áḿ koe síí tcg'oa, me ghòrò ba kg'ae. ");
INSERT INTO nhr_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Si kò qãà sa gaa koe bóò me, a tshoa-tshoa a gaicara ẽe kò gaa koe téé-tẽe ne khóè ne bìrí a máá: “Ncẽem khóè ba gaxu ka c'ẽem ga me e!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Igabam kò gaicara xo̱ase e. X'aè-coam qãá q'oo koe ne ko ẽe kò téé-tẽe ne Petere ba bìrí a máá: “Tseeguan kaga tsi gaxu ka c'ẽe tsi i, Galilea di tsi khóè tsi i thẽé khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Me kò tshoa-tshoa a cgúíse a gaìse a máá: “Khóèm ncẽe bar c'úùa hãa, ncẽe tu ko Gam ka kg'ui ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Me kò kúúga ghòrò ba cám̀ di sa kg'ae. Me Petere ba Jesom kò bìrí mea hãa kg'uian tc'ẽe-tc'ẽese, ncẽem kò máá: “Ghòròm qanega cám̀ q'oro kg'ae tamas cookg'ai koe tsi gha nqoana q'oro xo̱ase Te,” témé e. Kagam ko qhuìa óè a kg'ae. ");
INSERT INTO nhr_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kaisa ntcùúkg'ai cgoa xu kò kaia xu peresiti xu hẽé, naka khóè ne di xu kaia xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu hẽé, naka wèé xu tc'ãà-cookg'ai xu hẽéthẽé kg'uia xg'ae. A xu a Jeso ba qáé, a chùia tcg'òó a Pilatom koe úú Me. ");
INSERT INTO nhr_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Me Pilato ba tẽè Me a máá: “A Tsáá ga Tsia Juta ne di Tsi X'aiga Tsi?” témé. Me xo̱a me a máá: “Eẽ tsi ko méé khamaga i ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Xu kò kaia xu peresiti xu káí zi gúù zi koe chìbi-chibi Me. ");
INSERT INTO nhr_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Me Pilato ba gaicara tẽè Me a máá: “Kháé Tsi c'ẽe xo̱a ga úú tama? Bóò, nta noo zi chìbi zi ka xu ko chìbi-chibi Tsi sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Igabam kò Jeso ba táá cúí xo̱a ga kúrú, me Pilato ba are. ");
INSERT INTO nhr_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Me kò Pilato ba wèés kõ̱ès koe c'ẽem khóèm qáé-nquum koe tcãàèa ba kgoara, ncẽe khóè ne kò ko dtcàrà mááse ba. ");
INSERT INTO nhr_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Eẽ x'aè kam kò Barabase ta ko ma tciièm khóè ba qáé-nquum koe hãa, ncẽe kò xg'ae sa kúrúa hãa a ko khóè ne cg'õo xu khóè xu cgoa kò xg'ae a qáéèa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ne khóè ne hààraa xg'aeku a ne a tshoa-tshoa a Pilato ba dtcàrà ẽem ko kg'aiga ma kúrúa máá ne khama méém ma kúrúa máá ne sa. ");
INSERT INTO nhr_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Me Pilato ba xo̱a ne a máá: “Juta ne dim X'aiga bar gha kgoara máá tu u sa tu ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kaia xu peresiti xu kò tauan xu úú cgoa Mea hãa domka gam koe óága Mea hãa sam kò q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Igaba xu kò kaia xu peresiti xu khóè ne qg'áì, Barabase ba méé ne dtcàrà mááse naka nea nxãa ba kgoara mááè sa. ");
INSERT INTO nhr_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Me kò Pilato ba gaicara tẽè ne a máá: “Kháé ra gha Juta ne dim X'aiga Me e ta tu ko méém ka dùú sa kúrú sa tu ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ne q'au a máá: “Xgàu Me!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Me Pilato ba tẽè ne a máá: “Dùútsa gúùs cg'ãè sa ba kúrúa hãa?” témé. Igaba ne kò kaisase q'au a máá: “Xgàu Me!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Me kò Pilato ba khóè ne qãè-tcaokagu kg'oana hãa khamam kò Barabase ba kgoara máá ne. A ba a Jeso ba qoara xg'ara a tcg'òó Me, síím gha xgàuè ka. ");
INSERT INTO nhr_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xu kò ncõo-kg'ao xu Jeso ba x'aigam dim nquum q'oo koe tcãà (Peretoriume ta ko ma tciiè ba), a xu a wèés xg'aes ncõo-kg'ao xu di sa tciia xg'ae. ");
INSERT INTO nhr_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","A xu a nco̱àm qgáí ba hã̱akagu Me, a dxàman cgoa kúrúèas cábá sa kabea xg'ae a cábákagu Me, ");
INSERT INTO nhr_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","a xu a tshoa-tshoa a tsgám̀ Me a máá: “Tcgáío, Juta ne di Tsi X'aiga Tseè!” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A xu a kò tcúúa ba koe tc'áà dim hìim cgoa xg'áḿ Me, a tcg'ae Me, a xu a qhòm tsi qurù a nco̱ia ba ka dqo̱m̀ Me. ");
INSERT INTO nhr_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eẽ xu ko gatà ma nco̱i Mea xg'ara ka xu kò nco̱àm qgáí ba nxõ̱o cgae Me, a nxãaska séè a úú Me, síí xu gha xgàu Me ka. ");
INSERT INTO nhr_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Eẽ xu xóé a ko qõò ka xu kò c'ẽem khóèm Simone ta ko ma tciièm, Kurene dim, Alekesantere tsara Rufasea tsara ka xõòm cgoa xg'ae, me xháràm koe guu a ko x'áé-dxoom koe qõò, ka xu kò chùi mem Gam dis xgàu sa dcẽé. ");
INSERT INTO nhr_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xu kò Jeso ba Gologota ta ko ma tciièm qgáìm koe úú (ncẽe sa ko máá: ‘Tcúú c'õás dim qgáì ba,’ témé), ");
INSERT INTO nhr_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","a xu a mira ta ko ma tciièm tsóòm cgoa tcg'ome-xg'aeèa gõéan máà Me kg'áàm gha ka, igabam kò táá séè e. ");
INSERT INTO nhr_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Xu kò xgàu Me, a xu a Gam di qgáían cgúúan ntcòó a q'aa-q'aaku. ");
INSERT INTO nhr_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Eẽ xu ko xgàu Me ka i kò 9 di x'aè e, ntcùúkg'ai cgoa di i. ");
INSERT INTO nhr_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Eẽm kò chìbi-chibi cgoaèa hãas tcgãya sa kò ‘JUTA NE DIM X'AIGA BA’ ta ma góásea hãa. ");
INSERT INTO nhr_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xu kò cám̀ tsara ts'ãà-kg'ao tsara Gam cgoa xgàu, c'ẽe ba xu kò kg'áò xòèa ba za xgàua hãa, a c'ẽe ba dxàe xòèa ba za xgàua hãa. ");
INSERT INTO nhr_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ne ẽe kò ko dàòm cgoa nqáé ne khóè ne cóè Me, a ne a nxa̱a-nxa̱na tcúú a máá: “Eheè, Tsáá koma ko tempele ba ko̱be, a nqoana cáḿan q'oo koe tshào me Tsi Tsia, ");
INSERT INTO nhr_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kgoarase naka Tsia xgàu hìis koe xõa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gataga xu kò ma kaia xu peresiti xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xu ma nco̱i Me thẽé, a máá: “C'ẽe ne khóè nem kgoara hãa, igabam ko kgoarasean ka tààè. ");
INSERT INTO nhr_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ncẽem Kreste ba, ncẽe Iseraele dim x'aiga ba méém xgàu hìis koe xõa, naka ta gha nxãasega bóò naka dtcòm̀,” ta xu méé. Tsara ẽe kò Gam cgoa xgàuèa tsara gataga thẽé nco̱i Me. ");
INSERT INTO nhr_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Koaba di x'aèan 12 di ko tcãà kas kò ntcùú sa wèém nqõóm koe xóé, a síí dqòa di x'aèan nqoana di koe téé. ");
INSERT INTO nhr_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Me kò Jeso ba nqoana dim x'aèm ka kaiam dòm̀ cgoa q'au a máá: “Eloi, Eloi, lama sabakatani?” témé. Ncẽe sa ko máá: “Tiri Nqariè, Tiri Nqariè, dùús domka Tsi aagu Tea?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ne ẽe kò gaa koe téé-tẽe ne ka c'ẽe ne kóḿ Me a máá: “Kóḿ, ncẽe ba ko Elija ba tcii,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Me kò c'ẽe ba qgóé, a síí x'úrúan koe tsa̱u tshàan ntcã̱á, a tc'áàm koe qhàea tòó, a hàà máà Me, kg'áàm gha ka, a máá: “Qãà naka ta bóò Elija ba gha hàà xòó Me sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Me kò Jeso ba kaiam dòm̀ cgoa q'au, a ba a còo di sa sónòa tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Me kò tempelem dim qgáí ba cám̀ xòè tsara cgoa tòàra q'aase, a tc'amaka guu a síí nqãaka téé. ");
INSERT INTO nhr_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Eẽm ko ncõo-kg'ao xu dim kaiam ncẽe kò Jesom cookg'ai koe téé-tẽe ba, Jesom ma còo di sa sónòa tcg'òóa hãa sa bóò, kam kò máá: “Tseegukagam kò ncẽem khóè ba Nqarim dim Cóá Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Gataga zi kò c'ẽe zi khóè zi nqúù ka téé a ko bóò. Gazi xg'aeku koes kò Maria Magatalena sa hãa, naka Jakobom cg'áré ba hẽé naka Josefa ba hẽéthẽé tsara ka xõòs Maria sa hẽé, naka Salome sa hẽéthẽé zi. ");
INSERT INTO nhr_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eẽm kò Jeso ba qanega Galilea koe hàna ka kòo còò Me, a ko hùi Me zi khóè zi i kò ii. Káí zi khóè zi ẽe kò Jerusalema koe síí cgoa Mea hãa zi kò thẽé hàna. ");
INSERT INTO nhr_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Eẽ i ko dqòa, kg'ónòsean dim cáḿ me e kò ii khama, Sabata cookg'ai di ba, ");
INSERT INTO nhr_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","kam kò Josefam Arimatea di ba hàà, tcommèa kò hãam khóè me e kò ii, kaia xu dis xg'aes di ba, ncẽe gam tc'áró ga kò thẽé Nqarim di x'aian qãà hãa ba. A ba a kò kgoarasea hãase Pilatom koe síí, a síí Jesom dim tc'áró ba dtcàrà. ");
INSERT INTO nhr_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jesom nxãakamaga x'óóa hãa sam ko Pilato kóḿ kam kò are. A ncõo-kg'ao xu dim kaia ba tcii, a tẽè me Jesom ncãa ncìíse x'óó sa. ");
INSERT INTO nhr_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Eẽm ko ncõo-kg'ao xu dim kaiam koe kóḿ gatà i ii sa, kam ko Josefa ba tc'áró ba máà. ");
INSERT INTO nhr_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Me Josefa ba q'úúm qgáí ba x'ámá, a tc'áró ba xòó a gaam qgáím cgoa tcáḿ, a ba a síí qarim nxõ̱ám koe tshàoèa hãas tc'ám̀s koe xòó Me. A nxõ̱á-dxoo sa gaas tc'ám̀s kg'áḿ koe ghànèa tcẽekg'am cgoa. ");
INSERT INTO nhr_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Sara kò Maria Magatalena sa hẽé naka Marias Josefam ka xõò sa hẽéthẽé sara Jesom dim tc'áróm xòóèa hãa qgáìan bóò. ");
INSERT INTO nhr_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Eẽm ko Sabata dim cáḿ ba nqáé ka zi kò Maria Magatalena sa hẽé, naka Marias Jakobom ka xõò sa hẽé, naka Salome sa hẽéthẽé zi tshãán x'ámá, síí zi gha tcgáù Me ka. ");
INSERT INTO nhr_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Tc'ãà dim cáḿ bekem dim di kaisa ntcùúkg'ai cgoa zi kò cáḿs tcg'oara hãa ka xgoaba a tc'ám̀s koe qõò. ");
INSERT INTO nhr_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","A ko tẽèku a ko máá: “Dìí na gha nxõ̱á sa tc'ám̀s-kg'áḿ koe ghànèa tcg'òóa máá se e?” témé. ");
INSERT INTO nhr_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Igaba ẽe zi ko ghùi-kg'ai ka zi kò nxõ̱á sa bóò si téé-q'ooa sa koe ghànèa tcg'òóèa hãa, kaisases ko kaia khama. ");
INSERT INTO nhr_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Zi kò nxãaska ẽe zi ko tc'ám̀s koe tcãà ka q'úúm qgáí ba ha̱nam qárí-kg'ao ba bóò me kg'áò xòè koe ntcõóa-ntcõe, ka zi kò area. ");
INSERT INTO nhr_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Me bìrí zi a máá: “Táá sao q'áò guu, Jesom Nasareta di ba sao ko qaa, ncẽe kò xgàuèa hãa ba. Ghùièam hãa, a ncẽe koe káà Me e; bóò, ncẽea xòóèam kò hãa qgáìan ga a. ");
INSERT INTO nhr_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Igabaga méé sao qõò, naka síí Gam di xu xgaa-xgaase-kg'ao xu bìrí - naka Petere ba hẽéthẽé e - naka máá, gaxao kam gha tc'ãà a Galilea koe qõò. Gaa koe xao gha sao-xg'ae Me, ẽem ma bìrí xaoa hãa khamaga ma, témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Zi kò Jesom dis tc'ám̀s koe tcg'oa a zi a qgóé, cgùruan hẽé naka q'áòan hẽéthẽéa kò tcãà cgae zia khama, zi kò c'ẽe khóè ga táá cúí gúù ga bìrí, q'áò zi kòo khama. ");
INSERT INTO nhr_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Eẽm ko tc'ãà dim cáḿ bekem dim ka Jeso ba x'ooan koe ntcùúkg'ai cgoa tẽe kam kò Maria Magatalenas koe tc'ãà a x'áíse, ncẽem kò gaas koe 7 dxãwa tc'ẽean xhàiagua hãa sa. ");
INSERT INTO nhr_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Si kò qõò a sa a síí ẽem kò ko hẽé cgoa ne bìrí, ẽe ne hãa a tshúù-tcaoa hãa, a ko kg'ae ka. ");
INSERT INTO nhr_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Igaba ẽe ne ko kg'õèam hãa, a ba a Maria Magatalenas ka bóòèa hãa sa kóḿ, ka ne kò táá dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ncẽes gúùs qãá q'oo koem kò Jeso ba tãám dàòm ka gane ka c'ẽe tsara koe x'áíse, ẽe tsara xóé a ko c'ẽem qgáìm koe qõò ka. ");
INSERT INTO nhr_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Tsara ka̱bise a tsara a síí c'ẽe ne koe xàà a, igabaga ne kò táá dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Me gaa koe guus ka Jeso ba 11 xu koe x'áíse, ẽe xu hãa a ko tc'õó ka, a ba a gaxu di dtcòm̀ taman ka hẽé, naka gaxu di qari tcáóan ka hẽéthẽé dqàè xu, ẽem x'ooan koe tẽea hãa ka bóò Mea hãa ne xu kò táá dtcòm̀ khama. ");
INSERT INTO nhr_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","A ba a bìrí xu a máá: “Wèém nqõóm ncẽe ba xao qõò, naka xaoa wèé ne khóè ne Nqarim di qãè tchõàn ka xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Dìím wèém ẽe ko dtcòm̀ a ko tcguù-tcguuè ba gha kgoaraè, igaba dìím wèém ẽe dtcòm̀ tama ba gha xgàraè. ");
INSERT INTO nhr_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Zi gha ncẽe zi x'áí zi gane ẽe dtcòm̀a hãa ne koe tséé: dxãwa tc'ẽean ne ne gha Tiri cg'õèan cgoa xhàiagu, a ne a gha ka̱ba xu ta̱m xu cgoa kg'ui. ");
INSERT INTO nhr_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tshàua ne cgoa ne gha cg'aoan qgóóa ghùi, a ne a gha ẽe ne dqãèan kg'áà hãa igabaga i cuiskaga thõò-thõo nea hãa tite. A ne a gha tsàako ne khóè ne koe gane di tshàuan tòó, ne gha qãè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Me kò nxãaska X'aigam Jeso ba ẽem ko kg'ui cgoa xua xg'ara, ka séèa ghùi a nqarikg'ai koe qaòkaguè, a ba a síí Nqarim dim kg'áòm x'õàm xòè koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Xu nxãaska xgaa-xgaase-kg'ao xu tcg'oa a síí Nqarim dim kg'ui ba wèém nqõóm koe xgaa-xgaa. Me kò X'aiga ba gaxu cgoa tsééa xg'ae, a kò Gam dim kg'ui ba x'áí zi cgoa tseegukagu. Amen. ");
INSERT INTO nhr_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Káí ne khóè nea xg'ao xg'aekua ta koe xg'ao ko kúrúse zi gúù zi bóò a góá. ");
INSERT INTO nhr_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Khóè ne ncẽe tshoa-tshoas ka kò gane tcgáí ka ncẽe zi gúù zi bóòa ne, a ne a kò hàà Nqarim dim kg'uim di ne xgaa-xgaa-kg'ao ne ii nea ncẽe zi gúù zi máà taa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tíí igabar kò wèé zi gúù zi tshoa-tshoas koe qãèse tẽèa xám̀, i ncẽeska qãèa máá tea, ẽe zi ma kúrúsea xùrikua hãas kar ga góá máá tsi sa, tsáá Teofila tsi tcom-tcomsa tsi, ");
INSERT INTO nhr_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nxãasega tsi gha wèé tseeguan ncẽe tsi xgaa-xgaaèa ka q'ãa ka. ");
INSERT INTO nhr_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","I kúrúse Herotem xg'ao x'aigam Jutea di ba ii x'aè ka, me kò Sakaria ta ko ma tciièm peresiti ba hàna, Abiam dis xg'aes di xu peresiti xu di ba. Gam dis khóès Elisabete sa kò kaiam peresitim Aronem dis qhàò si i. ");
INSERT INTO nhr_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakaria khara Elisabetea khara kò Nqarim cookg'ai koe tchàno khara khóè khara a, a wèé x'áè-kg'áḿan X'aigam Nqarim di ko kúrú, a chìbi úú tama. ");
INSERT INTO nhr_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabete sa kò ábà tamas khóè si i khama khara kò káà cóá khara a. A kò gataga wèéa khara ga gàeasea hãa. ");
INSERT INTO nhr_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","I kúrúse me x'aè ba hàà Sakariam dis xg'aes di xu gha tempelem koe síí tséé di ba, me kò Sakaria ba síí peresitim di tsééan Nqarim cookg'ai koe kúrú. ");
INSERT INTO nhr_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Peresiti xu di cauan ka xu xg'ao ko cúím khóè ba nxárá tcg'òó, tempelem q'oo koe gha tcãà a qãè hm̀m̀ xg'ãò gúùan Nqari ba dàòa máá ba. Gaam cáḿ kam kò Sakaria ba nxárá tcg'òóè. ");
INSERT INTO nhr_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Eẽm tempelem q'oo koe hãa a ko qãè hm̀m̀ xg'ãò gúùan Nqari ba dàòa máá ka ne kò wèé ne khóè ne tempelem ka tchàa koe hãa a ko còrè. ");
INSERT INTO nhr_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Me moengelem Nqarim di ba qhúí-kg'ai me, a ba a kg'áòm x'õàm xòè za téé, ẽem gabá hãa a ko ẽes qãè hm̀m̀ xg'ãòs gúù sa altaram koe Nqari ba dàòa máá koe. ");
INSERT INTO nhr_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eẽm ko Sakaria ba moengele ba bóò kam kò q'ae a q'áòs ka tcãàè. ");
INSERT INTO nhr_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Me moengele ba bìrí me a máá: “Táá q'áò guu, Sakariaè. Còrèa tsi komsanaèa, si gha tsaris khóès Elisabete sa cóá ba ábà, tsi gha Johane ta ma tcii me ke. ");
INSERT INTO nhr_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","A tsi a gha kaisase qãè-tcao, i gha gataga káí khóèan gaam di ábà x'aèan ka qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","X'aigam Nqarim cookg'ai koem gha tcom-tcomsam khóè ba ii, ke méém táá qgarì kana dùútsa tshàam xgóàm ga ba kg'áà guu. Eẽ ábà x'aèa ba koe gam gha guu a Tcom-tcomsam Tc'ẽem ka cg'oèa, ");
INSERT INTO nhr_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","a ba a gha káí ne khóè ne Iseraele di ne X'aigam gane dim Nqarim koe ka̱bi. ");
INSERT INTO nhr_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Elijam di tc'ẽean hẽé naka qarian hẽéthẽé cgoam gha Nqarim cookg'ai koe kg'õè, a xõòga xu di tcáóan cóán koe ka̱bi, a ẽe komsana tama ne di tcáóan ka̱bi tchàno ne khóè ne di tc'ẽean koe, a khóè ne X'aigam Nqari ba kg'ónòa máá,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Me Sakaria ba moengele ba tẽè a máá: “Nta ra gha ma q'ãa ncẽe zi gúù zi gha kúrúse sa? Gàeasea raa, si tiris khóès igaba gàeasea hãa ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Me moengele ba xo̱a me a máá: “Tíí ra Gabariele ra a, a ra a Nqarim cookg'ai koe tẽe. Gaam ga ba tséé tea, hààr gha kg'ui cgoa tsi, a qãè zi tchõà zi ncẽe zi óágara máá tsi ka. ");
INSERT INTO nhr_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Bóò, dtcòm̀ tama tsia domka tsi gha ncẽe koe guus ka nqooa hãa, a kg'ui tite, me gha nxãakg'aiga síí x'aè ba hàà ncẽe zi gúù zi gha hàà kúrúse ba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nxãaska i ko káí khóèan tchàa koe téé-tẽe a ko Sakaria ba qãà, a area hãa, dùús domkam tempelem q'oo koe ncẽeta noose ãoa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Eẽm ko tcg'oa kam kò gane cgoa kg'uian ka tààè, ne kò bóòa q'ãa tempelem q'oo koem kò x'áí sa bóòa hãa sa. Me kò nqoo-nqoosase nxàem ko sa tshàua ba cgoa x'áí ne. ");
INSERT INTO nhr_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A ba a kò ẽe xu cáḿ xu kam ko tempelem koe tsééa xg'ara ka x'áéa ba koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ncẽe zi gúù zi qãá q'oo koes kò gam dis khóès Elisabete sa ncãàn úú, a sa a 5 nxoean séè a nquum q'oo koe cúía hãa, khóè ne gha táá bóò si ka. Si bìríse a máá: ");
INSERT INTO nhr_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“X'aigam Nqari ba ncẽes gúù sa kúrúa máá tea hãa, a ba a ncẽem x'aèm ka Gam di thõò-xama-máákuan tíí koe x'áía, a ba a khóè ne koe tiri sau-cgaean cóá ner úú tama di koe tcg'òó tea hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Me kò moengelem Gabariele ba 6 dim nxoem ka Galilea dim x'áé-dxoom Nasareta dim koe Nqarim ka tsééa úúè, ");
INSERT INTO nhr_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dxàe-coas koe, ncẽe kò Josefa ta ko ma tciièm qárí-kg'aom ka séèkuan tòóa mááèa hãa sa. Josefa ba kò Dafitem dis qhàòs dim khóè me e, i gaas dxàe-coas di cg'õèan kò Maria a. ");
INSERT INTO nhr_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Moengelem ko Marias koe hàà kam kò hàà tsgám̀kagu si a máá: “X'aigam Nqari ba cgóm̀ sia a sáá cgoa hàna,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Si Maria sa ẽem ko gatà méé ka kaisas q'áòs ka tcãàè, a sa a kò tẽèse dùús domkam ko gatà ma tsgám̀kagu si sa. ");
INSERT INTO nhr_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Me moengele ba bìrí si a máá: “Táá q'áò guu, Mariaè, Nqarim koe si cgóm̀kuan hòòa hãa ke. ");
INSERT INTO nhr_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bóò, ncãà si gha úú, a kg'áòm cóá ba ábà, a si a gha Jeso ta ma tcii Me. ");
INSERT INTO nhr_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tcom-tcomsam khóè Me e gha ii, a ba a gha tc'amaka hãam Nqarim dim Cóá ba iise tciiè, Me gha X'aigam Nqari ba x'aian dis ntcõó-q'oo sa máà Me, Gam ka xõò-dxoom Dafitem khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jakobem dis qhàòs koem gha chõò tamase x'aiga ii, si Gam dis x'ai sa cuiskaga chõò tite,” tam moengele ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Si Maria sa moengele ba bìrí a máá: “Nta i gha ii, qane cgoar kg'áò-khoe cgoa xóé tama ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Me moengele ba xo̱a si a máá: “Tcom-tcomsam Tc'ẽe ba gha sáá koe hàà, kaisase Tc'amaka hànam di qaria nea gha qàbi si, Me gha gaa domka Gaam ẽe gha ko ábàè ba tcom-tcomsa ii, a ba a gha Nqarim dim Cóá ba ta ma tciiè. ");
INSERT INTO nhr_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bóò kg'ama, ncẽe Elisabetes koe kúrúsea sa. Wèé khóèa ne kò q'ana hãa cóás úú tite sa, a sa a ábà tamas khóè si i sa, igaba ncẽes gàeasea hãa kas kg'áòm cóá ba qóḿa hãa, i nxoea sa ncẽeska 6 i. ");
INSERT INTO nhr_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Cúí gúù ga káà a, Nqarim ka kúrúè tite e khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Si Maria sa xo̱a me a máá: “Ncãa ga ra a, X'aigam Nqarim dir qãà ra. Eẽ tsi ko méé khamaga méé i tíí koe ii,” tas méé. Me moengele ba guu si a qõò. ");
INSERT INTO nhr_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gaa x'aè kas kò Maria xgoaba a sa a qháése c'ẽem x'áé-dxoom xàbìan dim koe síí, Juta ne di ba. ");
INSERT INTO nhr_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A sa a Sakariam x'áé koe tcãà a Elisabete sa tsgám̀kagu. ");
INSERT INTO nhr_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Eẽs ko Elisabete sa kóḿs ko Maria tsgám̀ sia ts'oo kam ko cóá ba ncãàa sa q'oo koe ko̱ri, si Tcom-tcomsam Tc'ẽem ka cg'oè cgaeè, ");
INSERT INTO nhr_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","a sa a tc'amaka kg'ui a máá: “Wèé zi khóè zi cookg'ai koe si sáá ts'ee-ts'eekg'aièa. Me gataga sarim cóá ba thẽé ts'ee-ts'eekg'aièa. ");
INSERT INTO nhr_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Dùútsa gúùs kaia sa ko ncẽe cáḿ ka tíí koe kúrúse, ncẽe tirim X'aigam Nqarim ka xõòs ko tíí koe hàà ka? ");
INSERT INTO nhr_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Eẽr ko kóḿ si ko ma tsgám̀ tea ts'oo sa kam ko gaa x'aè kaga cóá ba ncãàa te q'oo koe qãè-tcaoan ka ko̱ri khama. ");
INSERT INTO nhr_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ncẽem X'aigam Nqari ba sáá cgoa kg'uia hãa zi gúù zi wèé zi gha kúrúse sa si dtcòm̀a hãa, khama si ts'ee-ts'eekg'aièa,” tas méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Si Maria sa máá: “X'aigam Nqari bar ko wèé tcáóa te cgoa kaikagu, ");
INSERT INTO nhr_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","i tc'ẽea te Nqarim Kgoara-kg'aom Tirim koe qãè-tcaoan ka cg'oèa hãa, ");
INSERT INTO nhr_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Gam dis qãàs di nqãaka hãa nem bóòa hãa khama. Bóò, ncẽe koe guus ka zi gha wèé zi qhàò zi nxàe ts'ee-ts'eekg'aièar hãa sa. ");
INSERT INTO nhr_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Qarian úúa hãa ba kaisa zi gúù zi kúrúa máá tea hãa khama, i cg'õèa ba tcom-tcomsa a. ");
INSERT INTO nhr_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Gam di thõò-xama-máákua nem ko ẽe ko q'áò Me ne koe x'áí ẽe zi ko ma qhàò zi hàà khama. ");
INSERT INTO nhr_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nqari ba tshàua ba cgoa cgáé zi gúù zi kúrúa, a ba a ẽe tc'ẽega ne e, ta tcáóa ne q'oo koe tc'ẽea hãa ne khóè ne tsa̱i-tsa̱ia q'ara hãa. ");
INSERT INTO nhr_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kaia x'aiga nem gaan di ntcõó-q'ooan x'aian di koe guu a xòoa hãa, a ẽe nqãaka hàna khóèan ghùia hãa. ");
INSERT INTO nhr_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Xàbàa khóèa nem xg'ãàkagua hãa qãè zi gúù zi cgoa, a ba a ẽe qguùa hãa khóèan káà gúù tshàu-q'oose tcg'òóa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Gam dim qãàm Iseraele bam hùia, thõò-xama-máákuan Gam dim ko tc'ẽe-tc'ẽese khama. ");
INSERT INTO nhr_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ncẽem ma gatá ka xõòga ne nqòòkagua hãa khama, Abrahamam ka hẽé naka qhàòa ba ka hẽéthẽé e, chõò tamase,” tas Maria méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Si kò Maria sa nqoana khama noo nxoean Elisabetes cgoa síí hãa, a sa a nxãwa ka̱bise a x'áéa sa koe dìbi. ");
INSERT INTO nhr_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Me kò Elisabetes gha ábàm x'aè ba hàà, si kò kg'áòm cóá ba ábà. ");
INSERT INTO nhr_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ne kò cúùse x'ãèa ne khóè ne hẽé naka gas di qhàòan hẽéthẽé kóḿ X'aigam Nqarim ma kaisase thõò-xama máá sia hãa sa, a ne a kò gas cgoa qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","A ne a 8 cáḿa nem cóá ba úúa ka hàà, hàà ne gha q'ãe nqãa-qgai khòo me ka, a ne a Sakaria ta ma tcii me kg'oana, xõòm cg'õè cgoa. ");
INSERT INTO nhr_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Si gam ka xõò sa xo̱a a máá: “Eẽ ẽe, Johane tam gha ma tciiè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ne khóè ne bìrí si a máá: “Eẽta xam̀s cg'õès kò qhàòa si di ne koe káà si i ná,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ne tshàua ne cgoa sere-sere a xõò ba tẽè, ntam ko cóám di cg'õèan ka méé sa. ");
INSERT INTO nhr_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Me góám gha gúùan tca̱ba dtcàrà, a góá a máá: “Cg'õèa ba Johane e,” témé. Ne wèéa ne are. ");
INSERT INTO nhr_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Me kò gaa x'aè kaga Sakaria gaicara tshoa-tshoa a kg'ui, a Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ne kò ẽem qgáìm di ne khóè ne wèé ne q'áòs ka tcãàè, ne kò Jutea di xu xàbì xu wèé xu di ne khóè ne ncẽe ko kúrúse zi gúù zi wèé zi ka kg'ui. ");
INSERT INTO nhr_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ne kò wèé ne ẽe kò kóḿ ne are a tẽèse a máá: “Dùútsa cóá ba gáé ncẽe ba?” témé. X'aigam Nqarim dim tshàu ba kò hãa cgoa mea khama. ");
INSERT INTO nhr_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Me kò cóám ka xõòm Sakaria ba Tcom-tcomsam Tc'ẽem ka cg'oè cgaeè, a ba a porofita a máá: ");
INSERT INTO nhr_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dqo̱m̀mè méém X'aigam Nqarim Iseraele di ba, Gam di ne khóè ne koem hààraa a ba a ko hàà kgoara ne ke. ");
INSERT INTO nhr_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kgoarakuan dim nxãà bam tc'amaka ghùia máá ta a hãa. Gam dim qãàm Dafitem di ne qhàò ne koe. ");
INSERT INTO nhr_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ncẽem ko ma ncìísega Gam di xu porofiti xu tcom-tcomsa xu koe ma kg'uia hãa khama, ");
INSERT INTO nhr_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","a ba a ko máá, hààm gha gatá di ne cg'õo-kg'ao ne koe hẽé naka wèé ne ẽe hòre taa ne di tshàu-q'ooan koe hẽéthẽé kgoara ta a. ");
INSERT INTO nhr_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ncẽem dàòm kam ko Nqari ba gatá di xõòan koe thõò-xama-máákuan x'áí, ncẽem kò nqòòkagu nea hãa a, naka Gam dis qáé-xg'aes tcom-tcomsa sa tc'ẽe-tc'ẽesean hẽéthẽé e, ");
INSERT INTO nhr_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","gaìses ncẽem gatá ka xõòm Abrahamam koe gaìsea sa, ");
INSERT INTO nhr_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","gatá di ne cg'õo-kg'ao ne koem gha tcg'òó ta a ka, ta gha nxãasega q'áò tamase hẽé, tcom-tcomsase hẽé naka tchànose hẽéthẽé cookg'aia ba koe tsééa máá Me, wèé kg'õèa ta q'oo koe. ");
INSERT INTO nhr_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Tsáá tiri tsi cóá tsi, X'aigam Nqarim ncẽem tc'amaka hànam di tsi porofiti tsi iise tsi gha tciiè, Nqarim cookg'ai koe tsi gha qõò, a tsi a gha hààm gha xu dàò xu kg'ónòa máá Me. ");
INSERT INTO nhr_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gam di ne khóè ne tsi gha bìrí nta ne gha ma q'ãan di tc'ẽean di kgoarasean hòò sa, gane di chìbian di qgóóa-máákuan koe guu a. ");
INSERT INTO nhr_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Gatá dim Nqari ba ko tcáóa ba q'oo koe thõòan xám̀, gaa domkam gha cáḿs ko tcg'oa xòè koe guuam x'áàm ncẽe tc'amaka guuam cgoa x'áà-x'aa ta a. ");
INSERT INTO nhr_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wèém khóèm ẽe ntcùús q'oo koe hẽé naka x'ooan di sóm̀an koe hẽéthẽé hànam koem gha x'áà ba óága, a ba a gha dàòa ta tchàno-tchano tòókuan dim dàòm koe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Me kò cóá ba kai a tc'ẽean koe qari, a ba a kò tchàa-xgóós koe hàna, me síí hààm gha Iseraele di ne khóè ne cookg'ai koe x'áísem x'aè ba hàà. ");
INSERT INTO nhr_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Eẽm x'aèm kam xg'ao Roma dim x'aigam Agusetosi ba x'áèan tcg'òó, wèém nqõóm di ne khóè ne gha nxáráè di i. ");
INSERT INTO nhr_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ncẽes nxárákus kg'áíka di sa xg'ao Kurinem kò Siria koe x'aiga ii x'aè ka kúrúse. ");
INSERT INTO nhr_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Me kò wèém khóè ba nxãaska gam dim x'áé-dxoom koe síí góáse. ");
INSERT INTO nhr_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Me Josefa thẽé Nasareta dim x'áé-dxoom Galilea dim koe guu a síí Jutea dim x'áé-dxoom koe tcãà, Betelehema ta ko ma tciiè ba, x'aigam Dafitem ábàèa koe, Dafitem dim qhàò me e kò ii khama. ");
INSERT INTO nhr_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Gaa koem kò síí Marias cgoa góáse, ncẽem kò séèkuan tòóa máána hãa sa, si kò gataga qóḿ ii. ");
INSERT INTO nhr_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Qanega khara Betelehema koe hãa kam kò cóá bas gha ábà dim x'aè ba hàà. ");
INSERT INTO nhr_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Si kò qgáé-kg'ai dim cóám gas di ba ábà, a sa a qgáían cgoa tcáḿ Me, a dxòrom q'oo koe xòó Me, cg'áè-nquum koe i kò x'óm̀-q'ooan káà a khama. ");
INSERT INTO nhr_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Xu kò c'ẽe xu ghùu kòre-kg'ao xu qãáka hãa a tééa q'uu a ko ghùu zi kòre. ");
INSERT INTO nhr_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Me kúúga moengelem X'aigam di ba hàà qàea xu koe téé, me X'aigam dim x'áà ba x'áà-x'aa xu, xu kò kaisase q'áò. ");
INSERT INTO nhr_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Me kò moengele ba bìrí xu a máá: “Táá q'áò guu! Bóò, qãè tchõà ner ko óága máá xao o, ncẽe gha hàà wèé khóèan kaisa qãè-tcaoan máà a ke. ");
INSERT INTO nhr_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ncẽem cáḿ ka tu Dafitem dim x'áé-dxoom koe Kgoara-kg'ao ba ábà mááèa - X'aigam Kreste ba! ");
INSERT INTO nhr_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Si gha ncẽes gúù sa gaxao koe x'áí sa ii: cóá-coam qgáían ka tcáḿ a dxòrom q'oo koe xòóèa ba xao gha hòò,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Si kò kúúga moengele xu dis xg'aes nqarikg'ai di sa qhúí a gaam moengelem cgoa hàna hãase Nqari ba dqo̱m̀, a máá: ");
INSERT INTO nhr_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Dqo̱m̀kuan méé i kaisase tc'amaka hànam Nqarim koe hãa, naka tòókuan hẽéthẽé e nqõómkg'ai koe, khóè ne ẽem ncàm̀a hãa ne koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Eẽ xu ko moengele xu guu xu a ko nqarikg'ai koe ka̱bise, ka xu kò kòre-kg'ao xu bìríku a máá: “Hààn xae Betelehema koe qõò naka síí ncẽes gúùs kúrúsea sa bóò, ncẽe X'aigam Nqarim bìrí xaea hãa sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A xu a qháése xgoaba a qõò, a síí Maria khara Josefa khara hẽé naka Cóá-coa ba hẽéthẽé hòò, Me dxòrom q'oo koe xõe. ");
INSERT INTO nhr_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Eẽ xu ko kòre-kg'ao xu hòò ne ka xu kò ncãa i Cóám ka mééè sa bìrí khara a. ");
INSERT INTO nhr_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne kò wèé ne ẽe kòre-kg'ao xu ko bìrí ne sa ko kóḿ ne are. ");
INSERT INTO nhr_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Si Maria sa wèé zi gúù zi ncẽe zi tcáóa sa koe tòó, a sa a gazi ka kaisase tc'ẽe. ");
INSERT INTO nhr_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Xu ghùu kòre-kg'ao xu ka̱bise, a xu a Nqari ba dqo̱m̀ a koa Me, wèé zi gúù zi ẽe xu kò kóḿa zi ka hẽé naka ẽe xu kò bóòa zi ka hẽéthẽé e; ẽe xu kò ma bìríèa khama i kò ii. ");
INSERT INTO nhr_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","8 cáḿan qãá q'oo koem kò Cóá ba q'ãe nqãa-qgai khòoè, a ba a Jeso ta ma tciiè, qóḿmè tamam hãa cookg'ai koem kò moengelem ka máàèa hãas cg'õè sa. ");
INSERT INTO nhr_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Eẽm ko x'aè ba hàà Josefa khara Maria khara méé khara peresitim ka q'ano-q'anoè di ba, ncẽe Moshem di x'áèan kòo méé khama, ka khara kò Cóá ba Jerusalema koe úú, a síí X'aigam Nqarim cookg'ai koe tòó Me. ");
INSERT INTO nhr_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Eẽ i kò ma X'aigam Nqarim di x'áèan koe ma góásea khama, a ko máá: “Wèém cóám kg'áòm tc'ãà a ábàèa ba méém X'aigam Nqarim di tsééan tòóa mááè,” téméè khama. ");
INSERT INTO nhr_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Gataga khara kò dàòa-mááku sa X'aigam Nqari ba kúrúa máá, ẽem kò ma X'aigam Nqari ba x'áèa khama a ko máá: “Cám̀ tcíbí sara kana cám̀ tcíbí-coa sara ga igaba,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gaa x'aè kagam kò Jerusalema koe Simone ta ko ma tciièm khóè ba x'ãèa. Tchàno, a Nqari-tcáóa hãam khóè me e kò ii, Nqarim gha Iseraele ne qgài-qgai tcáó dim x'aè ba kò tééa máána hãa ba, me kò Tcom-tcomsam Tc'ẽe ba gam koe hãa, ");
INSERT INTO nhr_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","me kò Tcom-tcomsam Tc'ẽem ka x'áíèa hãa, X'aigam Nqarim dim Kreste bam bóò tamas cookg'ai koem x'óóa hãa tite sa. ");
INSERT INTO nhr_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Tcom-tcomsam Tc'ẽem kam kò tempelem koe óágaè. Khara kò Jesom ka xõò ga khara thẽé gakhara dim Cóám Jeso ba tempelem koe óá, hàà khara gha x'áèan ko méé sa kúrúa máá Me ka, ");
INSERT INTO nhr_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","me kò Simone ba gaam Cóám Jeso ba séè a x'õàa ba koe tchàma a ba a Nqari ba dqo̱m̀, a máá: ");
INSERT INTO nhr_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tíí Q'õòè, ẽe Tsi ma bìrí tea khama Tsi gha ncẽeska Tsarir qãà ra tòókuan cgoa dàò ba xgobekg'ama máá. ");
INSERT INTO nhr_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Tiri tcgáía nea Tsari kgoarakuan bóòa hãa khama, ");
INSERT INTO nhr_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ncẽe Tsi wèé zi qhàò zi tcgáí q'oo koe kg'ónòa a, ");
INSERT INTO nhr_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","tãá zi qhàò zi gha xgobekg'am tc'ẽem x'áà Me e gha ii, a ba a gha Tsaris qhàòs Iseraele di sa x'áàkagu,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Khara kò Cóám ka xõòga khara Simonem ko Cóám ka méé gúùan are. ");
INSERT INTO nhr_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Me kò Simone ba ts'ee-ts'eekg'ai ne, a ba a Marias Cóám ka xõò sa bìrí a máá: “Bóò, Nqari ba ncẽem Cóá ba qaara máásea, káí ne khóè nem gha kúrú ne cg'áé, a ba a gha káí ne khóè ne Iseraele koe tẽekagu ka. X'áí Me e gha ii ntcoeku cgoaè gha ba, ");
INSERT INTO nhr_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","nxãasega zi gha káí ne khóè ne di zi tc'ẽe zi tcg'oa a x'áíse ka, me gha ntcàu ba qhàe tcáó si,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Si kò gataga Anna ta ko ma tciiès porofiti sa hànaa, Fanulem ka cóáse sa, Asere dis qhàòs di ba. Kaisases kò gàeasea hãa, ncẽe ko ẽes ko séèèa xg'ara ka 7 kurian gas dim khóèm cgoa x'ãèa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","A sa a kò dxàe-ntcõa sa kúrú, a nxãakg'aiga síí 84 kuri, a kò wèé x'aè ka tempelem koe hàna, a ko ntcùú ba hẽé naka koaba ba hẽéthẽé Nqari ba dqo̱m̀, tc'õoan carasean hẽé naka còrèan hẽéthẽé cgoa. ");
INSERT INTO nhr_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gaam x'aèm ẽem kagas kò hàà cgae ne, a hàà Nqari ba qãè-tcaoa máá, a sa a wèéa ne ẽe kò Nqarim gha Jerusalema ba kgoara sa qãà hãa ne Cóám ka kg'ui cgoa. ");
INSERT INTO nhr_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Eẽ khara ko wèé zi gúù zi X'aigam Nqarim kò x'áèa hãa zi kúrúa xg'ara ka khara ko Galilea koe ka̱bise, gakhara dim x'áé-dxoom Nasaretam koe. ");
INSERT INTO nhr_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Eẽm ko Cóá ba kai kam kò qari, a tc'ẽega, i Nqarim di cgóm̀kuan Gam cgoa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Wèém kurim q'oo koe khara kò ko Jesom ka xõò ga khara Jerusalema koe qõò, Paseka dis kõ̱ès koe. ");
INSERT INTO nhr_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Eẽm Jeso ba 12 kurian úúa ka ne kò gaicara qõò a gaas kõ̱ès koe síí, khóè ne kò ko wèé x'aè ka hẽé khama. ");
INSERT INTO nhr_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eẽs ko kõ̱è sa xg'ara ka khara kò x'áéa khara koe ka̱bise, igabam kò Jeso ba Jerusalema koe qaù, khara kò Gam ka xõò ga khara ncẽes gúù sa c'úùa. ");
INSERT INTO nhr_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Khóè ne xg'aeku koem kò hàna, ta khara kò tc'ẽea, khama khara kò tc'ãà dim cáḿ ba qõò, a khara a gakhara di qhàòan hẽé naka khóè ne ẽe khara kò q'ana ne hẽéthẽé koe qaa Me. ");
INSERT INTO nhr_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Táá khara kò hòò Me khama khara kò Jerusalema koe ka̱bise a síí qaa Me. ");
INSERT INTO nhr_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Nqoana cáḿan qãá q'oo koe khara kò tempelem q'oo koe hòò Me, Me xgaa-xgaa-kg'ao xu xg'aeku koe ntcõe, a ntcõó a ko komsana xu, a ko tẽè-kg'áḿ zi tẽè xu. ");
INSERT INTO nhr_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Xu kò wèé xu ẽe kò kóḿ Me xu Gam di kóḿa q'ãan hẽé naka xo̱a-kg'áḿa ba ka hẽéthẽé arekaguè. ");
INSERT INTO nhr_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Gam ka xõòga khara ko bóò Me ka khara kò kaisase are, si Gam ka xõò sa máá: “Tiri Tsi Cóá Tseè, dùús domka Tsi kò ncẽeta hẽéa máá? Bóò, saò ba hẽé naka tíí hẽéthẽé khama ncãa ko thõò-tcaoase qaa Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Me xo̱a khara a, a máá: “Dùús domka khaoa kò ko qaa Te? C'úùa khaoa kò hãa, Abom Tirim Xõòm di zi gúù zi koe méér ga hãa sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Khara kò dùú sam ko méé sa táá koma q'ãa. ");
INSERT INTO nhr_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Me Nasareta koe ka̱bise cgoa khara a, komsana khara am kò ko. Si kò Gam ka xõò sa ncẽes gúù sa tcáóa sa q'oo koe tòó. ");
INSERT INTO nhr_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","I ko Jesom di tc'ẽean hẽé naka qaria ba hẽéthẽé kai a càùse, i kò Nqari ba hẽé naka khóè ne hẽéthẽé di tòókuan càùse cgae Me. ");
INSERT INTO nhr_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","15 dim kuri me e kò ii Roma ne dim x'aigam Kaesaram Tiberiam kò wèém nqõó ba tc'ãà-cookg'aia hãa ka, me kò Pontiose Pilato ba Jutea dim x'aiga ba ii, me Herote ba Galilea dim nqõó ba tc'ãà-cookg'aia, me káíkhoem Filipi ba Iturea ba hẽé naka Terakoniti ba hẽéthẽé di tsara nqõó tsara tc'ãà-cookg'aia, me Lisania ba Abelenem dim nqõó ba tc'ãà-cookg'aia. ");
INSERT INTO nhr_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gaa x'aè ka tsara kò Anase ba hẽé naka Kaifase ba hẽéthẽé tsara kò kaia tsara peresiti tsara ii. Kam kò Nqarim dim kg'ui ba Sakariam dim cóám Johanem koe hàà, tchàa-xgóóm koem hãase. ");
INSERT INTO nhr_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Me Jorotane dim tshàa ba nxa̱ma-nxa̱ma xu nqõó xu wèé xu koe qõòate, a ba a chìbia ne koe ne gha tcóóse a tcguù-tcguuès ka xgaa-xgaa ne, nxãasega ne gha gane di chìbian qgóóa mááè ka, ");
INSERT INTO nhr_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ẽe i ma porofitim Isaiam dis Tcgãyas koe ma góásea hãa khama a ko máá: “C'ẽem dòm̀ ba ko tchàa-xgóós koe guu a q'au a ko máá: ‘X'aigam Nqari ba tu dàò ba kg'ónòa máá, naka Gam di dàòan tchàno-tchanoa máá Me. ");
INSERT INTO nhr_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Wèé qgáìan ẽe qàm gha cg'oè-cg'oeè, i gha wèé xàbìan hẽé naka nxõ̱á xàbìan hẽéthẽé nqãaka qám̀mè, i gha kàma dàòan tchàno-tchanoè, i gha xgárá dàòan tcgàriè. ");
INSERT INTO nhr_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ne gha wèé ne khóè ne Nqarim di kgoarakuan hòò a bóò,’” témé ba. ");
INSERT INTO nhr_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Me kò Johane ba tcguù-tcguukuan domka gam koe hààraa zi xg'ae zi bìrí a máá: “Gatu cg'aoan di tu cóá tuè, dìín ka tua q'ãà-q'ãàèa hãa a ko hààko xgóàn Nqarim di bèe? ");
INSERT INTO nhr_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nxãaska méé tu chìbian koe tu tcóósea hãa sa gha x'áí tc'áróan kúrú, naka tua táá tshoa-tshoa naka bìríse naka máá: ‘Abrahama ba ta úúa hãa, sita ka tsgõose ba,’ témé guu. Bìrí tu ur ko a ko máá: Nqari ba tààè tama ncẽe zi nxõ̱á zi séè a Abrahama ba tsgõo-coan kúrúa máán ka ke. ");
INSERT INTO nhr_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Si gataga bòó sa nxãakamaga hìi zi di to̱bean kg'ónòa tòóa mááèa, si gha wèés hìis ẽe qãè tc'áróan kúrú tama sa xg'aoa tcg'òó a c'eean q'oo koe xaoa tcãàè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ne xg'ae zi di ne khóè ne tẽè me a máá: “Kháé nxãata i kò ii ne ta gha dùú sa kúrú?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Me xo̱a ne a máá: “Dìím wèém ẽe cám̀ qgáían úúa hãa ba méém ẽe cúís ga sa úú tama ba c'ẽe sa máà, nakam dìím wèém ẽe tc'õoan úúa hãa ba gataga thẽé hẽé,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xu c'ẽe xu mari xg'ae-xg'ae-kg'ao xu hàà, tcguù-tcguuè xu gha ka. A tẽè me a máá: “Xgaa-xgaa-kg'ao tseè, dùú sa xae gha sixae kúrú?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Me xo̱a xu a máá: “Táá méé xao qaaseko marian nqáéa hãan séè cgae ne guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xu gataga ncõo-kg'ao xu hàà a tẽè me a máá: “Kháé nxãaska sixae ka, dùú sa méé xae kúrú?” témé. Me Johane xo̱a xu a máá: “Táá cúí khóè koe ga qari cgoa marian séè guu, naka táá khóèan gaan di tama chìbian hã̱akagu guu. Naka xaoa gaxao di surutan qãè-tcaoa máá,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Khóè ne kò nqòòa hãase qãà a ne a ko wèéa ne ga tcáóa ne q'oo koe tẽèse a ko máá, Johane ba gha c'ẽedaoka Krestem ga me e, ta tc'ẽea. ");
INSERT INTO nhr_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Me Johane wèéa ne ga xo̱a a máá: “Tíí ra ko tshàan cgoa tcguù-tcguu tu u, igabam ko Gaam ẽe tíí ka qari ba hàà, ncẽe Gam di nxàbo tca̱ian kgoara ner kg'ano tama ba. Gaa ba gha hàà Tcom-tcomsam Tc'ẽem cgoa hẽé naka c'eem cgoa hẽéthẽé tcguù-tcguu tu u. ");
INSERT INTO nhr_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Mabere tsoroan ko dqòrò cgoaèm hìi ba tshàua ba koe hãa, Me gha maberean ko dqòròès qgáìs koe wèé maberean ga dqòrò, a gha Gam di maberean Gam dis nxàés koe xg'ae-xg'ae, igabam gha tsoroan ts'irì tamam c'eem koe dàò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Johane ba kò káí zi dàò zi tãáka zi cgoa khóè ne koe qãè tchõàn óá. ");
INSERT INTO nhr_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Igabam kò Herotem tc'ãa-cookg'ai ba tãás gúù sa kúrú a gam di chìbian càù, Johane ba qáé-nquus koe tcãàn ka. Johane ba kò chìbi-chibi mea, Herotiases gam ka káíkhoem dis khóès cgoam kò xóéa hãa, a ba a kò gataga káí zi gúù zi cg'ãè zi kúrúa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Khóè ne wèé ne ko tcguù-tcguuè kam kò Jeso ba thẽé tcguù-tcguuè. Eẽm hãa a ko còrè ka i kò nqarikg'aian xgobekg'amse, ");
INSERT INTO nhr_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Me kò Tcom-tcomsam Tc'ẽe ba tcíbís khama ii a xõa cgae Me. Me kg'ui ba nqarikg'ai koe guu a tcg'oa, a máá: “Tiri Tsi Cóá Tsi ncàm̀a Ra hãa Tsi i. Tsáá koe Ra ko qãè-tcao,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Eẽm ko Jeso ba Gam dis tséé sa tshoa-tshoa kam kò 30 kuri Me e, ncẽe khóè ne kò ko máá, Josefam ka cóáse Me e, témé ba, Josefam Elim ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elim Matatem ka cóáse ba, Matatem Lefim ka cóáse ba, Lefim Melekim ka cóáse ba, Melekim Janaim ka cóáse ba, Janaim Josefam ka cóáse ba. ");
INSERT INTO nhr_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josefam Matatisim ka cóáse ba, Matatisim Amosem ka cóáse ba, Amosem Naumem ka cóáse ba, Naumem Eselim ka cóáse ba, Eselim Nagaim ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaim Matam ka cóáse ba, Matam Matatisim ka cóáse ba, Matatisim Seminem ka cóáse ba, Seminem Josekim ka cóáse ba, Josekim Jodam ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodam Joanam ka cóáse ba, Joanam Resam ka cóáse ba, Resam Serobabelem ka cóáse ba, Serobabelem Salatielem ka cóáse ba, Salatielem Nerim ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerim Melekim ka cóáse ba, Melekim Adim ka cóáse ba, Adim Kosam ka cóáse ba, Kosam Elemadam ka cóáse ba, Elemadam Erem ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erem Joshuam ka cóáse ba, Joshuam Elieserem ka cóáse ba, Elieserem Jorim ka cóáse ba, Jorim Matatem ka cóáse ba, Matatem Lefim ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lefim Simonem ka cóáse ba, Simonem Jutam ka cóáse ba, Jutam Josefam ka cóáse ba, Josefam Jonam ka cóáse ba, Jonam Eliakim ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim Meleam ka cóáse ba, Meleam Menam ka cóáse ba, Menam Matatem ka cóáse ba, Matatem Natanem ka cóáse ba, Natanem Dafitem ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dafitem Jesem ka cóáse ba, Jesem Obetem ka cóáse ba, Obetem Boasem ka cóáse ba, Boasem Salemonem ka cóáse ba, Salemonem Nasonem ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonem Aminadabem ka cóáse ba, Aminadabem Ademinem ka cóáse ba, Ademinem Arenim ka cóáse ba, Arenim Heseronem ka cóáse ba, Heseronem Peresem ka cóáse ba, Peresem Jutam ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jutam Jakobem ka cóáse ba, Jakobem Isakam ka cóáse ba, Isakam Abrahamam ka cóáse ba, Abrahamam Teram ka cóáse ba, Teram Nahorem ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahorem Serugem ka cóáse ba, Serugem Regum ka cóáse ba, Regum Pelegem ka cóáse ba, Pelegem Eberem ka cóáse ba, Eberem Selam ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selam Kainanem ka cóáse ba, Kainanem Arefekesatem ka cóáse ba, Arefekesatem Shem ka cóáse ba, Shem Nowam ka cóáse ba, Nowam Lamekem ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekem Methuselam ka cóáse ba, Methuselam Enokem ka cóáse ba, Enokem Jaretem ka cóáse ba, Jaretem Mahalalem ka cóáse ba, Mahalalem Kainanem ka cóáse ba, ");
INSERT INTO nhr_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kainanem Enosem ka cóáse ba, Enosem Setem ka cóáse ba, Setem Adam ka cóáse ba, Adam Nqarim ka cóáse ba. ");
INSERT INTO nhr_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jeso ba kò Tcom-tcomsam Tc'ẽem ka cg'oè cgaeèa, a ba a kò Jorotane dim tshàam koe guu a ka̱bise. A ba a kò Tcom-tcomsam Tc'ẽem ka séè a qãáka úúè. ");
INSERT INTO nhr_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Gaa koem kò dxãwa ba 40 cáḿan Jeso ba kúrúa bóò. Jeso ba kò ẽe xu cáḿ xu ka táá cúí gúù ga tc'õó, khamam kò gaa koe guus ka xàbàa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Me dxãwa ba bìrí Me a máá: “Nqarim di Tsi Cóá Tsi kò ii ne, nxõ̱ás ncẽe sa bìrí nakas péréan kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Me Jeso ba xo̱a me a máá: “Góásea i hãa a ko máá: ‘Khóèa nea péréan ka cúí kg'õè tama,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Me kò dxãwa ba séè a kaisase tc'amaka hãam qgáìm koe úú Me, a ba a kò ẽem x'aèm ka wèé x'aian nqõómkg'ai di hẽé naka gaan di ka̱rean hẽéthẽé x'áí Me. ");
INSERT INTO nhr_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","A ba a bìrí Me a máá: “Ncẽe gúùan di qarian wèé hẽé naka x'aian di x'áàn hẽéthẽé ra gha máà Tsi, máàè ana raa, a ra a ko tc'ẽer kom khóè ba máà a khama. ");
INSERT INTO nhr_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","A ncẽè cookg'aia te koe Tsi ko dqo̱m̀ ne i gha wèéan ncẽe ga Tsari ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Me Jeso ba xo̱a me a máá: “Góásea i hãa a ko máá: ‘X'aigam Nqarim tsari ba dqo̱m̀, naka Gaam cúí ba tsééa máá,’ téméè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Me kò dxãwa ba Jerusalema koe séè a úú Me, a ba a kaisase tc'amaka hàna qgáìan tempelem tco̱be di koe síí tòó Me, a bìrí Me a máá: “Nqarim di Tsi Cóá Tsi kò ii ne, ncẽe koe guu naka nqãaka xaoa xòóse. ");
INSERT INTO nhr_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Góásea i hãa ke a ko máá: ‘Gam di xu moengele xum gha x'áèan máà, xu gha kòre Tsi,’ téméè khama. ");
INSERT INTO nhr_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gataga i góásea a ko máá: ‘Tshàua xu cgoa xu gha qgóóa ghùi tsi, táá tsi gha nxãasega nqàrèa tsi nxõ̱án koe xg'áḿa tòó ka,’ téméè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Me Jeso ba xo̱a me a máá: “Góásea i hãa a ko máá: ‘Táá méé tsi X'aigam tsarim Nqari ba kúrúa bóò guu,’ téméè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eẽm ko dxãwa ba gam di kúrúa bóòkuan wèé cgoa xg'ara kam kò gaa koe guu Me a qãèm x'aè ba qãà. ");
INSERT INTO nhr_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Me kò Jeso ba Tcom-tcomsam Tc'ẽem di qarian ka Galilea koe ka̱bise, i nxàea ba wèém xg'aekum koe tsa̱i-tsa̱ise. ");
INSERT INTO nhr_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Me kò gane di còrè-nquuan koe xgaa-xgaa, i wèé khóèan dqo̱m̀ Me. ");
INSERT INTO nhr_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Me kò Nasareta koe qõò, ncẽem xg'ao kaikaguè koe. A kg'aigam ko hẽé khama Sabata dim cáḿ ka còrè-nquum koe síí. Nqarim dis Tcgãya sam gha nxárá kam kò tẽe, ");
INSERT INTO nhr_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","a ba a porofitim Isaiam dis Tcgãya sa máàè, a xgobekg'am si, a ba a ncẽeta i ma góáèa qgáìan koe síí: ");
INSERT INTO nhr_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“X'AIGAM Nqarim dim Tcom-tcomsam Tc'ẽe ba Tíí koe hàna, nxárám tcg'òó a nxúìan ntcã̱á tcúú Tea hãa khama, ẽe dxàua ne koer gha qãè tchõàn óága ka. Tsééam óá Tea, ẽe qáéèa ner gha hàà bìrí, kgoaraè ne gha sa, a ẽe bóò tama ne, xgobekg'am tcgáíè ne gha sa, a Ra a gha ẽe nqãaka hàna ne hàà kgoara sa ka, ");
INSERT INTO nhr_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","a Ra a gha khóè ne bìrí, x'aè ba hààra sa, X'aigam Nqarim gha Gam di ne khóè ne Gam di cgóm̀kuan x'áí di ba,” tam ma nxárá. ");
INSERT INTO nhr_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jeso ba kò tcgãya sa tcẽekg'am, a ba a qãàm koe úúa ka̱bi si, a ntcõó. I kò còrè-nquum koe ko hãa ne khóè ne wèé ne di tcgáían Gam koe qãesea tẽe. ");
INSERT INTO nhr_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Me tshoa-tshoa a bìrí ne a máá: “Ncẽe cáḿ kas ncãa ncẽes qgáìs Nqarim dis Tcgãyas di sa tseegukaguè, ncẽe tu ncãa ma kóḿ i ko ma nxáráè khamaga ma,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ne kò wèé ne khóè ne Gam ka qãèse kg'ui, a ne a kò ka̱re kg'uian ncẽe kg'áḿa ba koe ko tcg'oa ka arekaguè, a ne a máá: “A ncẽe ba gáé Josefam dim Cóám tama baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Me Jeso ba bìrí ne a máá: “Tseeguan kaga tu gha ncẽes sere-sere sa nxàea máá Te a máá: ‘Naaka Tseè, Tsáá ka qãèkaguse! Ncẽe ta ko kóḿ Tsi Kaperenaume koe kúrúa zi gúù zi ncẽe nqõóa Tsi koe kúrú,’” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","A ba a bìrí ne a máá: “Tseegua ner ko bìrí tu u a ko máá: Porofiti ba x'áéa ba koe dtcòm̀mè tamam khóè me e. ");
INSERT INTO nhr_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","“Tseeguan kar ko bìrí tu u: Elijam di x'aèan ka, ẽe i ko nqarikg'aian nqoana kurian hẽé naka 6 nxoean hẽéthẽé tcẽekg'amsea kas kò thõòs xàbà sa nqõómkg'ai koe hãa, zi kò káí zi dxàe-ntcõa zi Iseraele koe hàna, ");
INSERT INTO nhr_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","igabam kò Elija ba c'ẽe zi koe ga tsééa úúè tama, a kò Sarefata dim qgáì-coam koe hànas dxàe-ntcõas koe tsééa úúèa, Sitone dim nqõóm koe. ");
INSERT INTO nhr_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ne kò porofitim Elisham di x'aè ka káí ne lepero dis tcìì sa kò tsàara hãa ne Iseraele koe hàna, igaba ne kò táá cúía ne ga q'ano-q'anoè, Namanem ncẽe Siria dim cúím ga me e kò ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ncẽes gúù sa ne ko kóḿ ka ne kò wèé ne khóè ne còrè-nquum koe kò hàna ne kaisase xgóà. ");
INSERT INTO nhr_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nxàìa ne kò tẽe a ne a x'áé-dxoom xg'aeku koe xàbùa tcg'òó Me, a xàbìm gane dim x'áé-dxoom tshàoèam tc'amkg'ai koe tceea úú Me, gaa koe ne gha síí guu a xaoa xòó Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Igabam kò Jeso ba kg'ama xg'aekua ne koe nqáé a qõò. ");
INSERT INTO nhr_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A ba a nxãaska Kaperenaume koe síí, Galilea dim x'áé-dxoom koe, a ba a kòo Sabata dim cáḿ ka khóè ne xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne kò Gam di xgaa-xgaa-q'ooan ka area hãa, Gam dim kg'ui ba kò qarian úúa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Me kò còrè-nquum koe dxãwa tc'ẽean úúam khóè ba hãa, a kò kaisam dòm̀ cgoa q'au a máá: ");
INSERT INTO nhr_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ha̱aà! Jeso Tsi Nasareta di Tseè, dùú sa Tsi ko gatá cgoa tc'ẽe? Hàà Tsi ko kaàkagu ta a? Q'ana raa dìí Tsi i sa, Nqarim di Tsi Tcom-tcomsa Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Igabam kò Jeso ba dxãwa tc'ẽean dqàè a máá: “Nqoo, naka tcg'oa cgae me!” témé. I kò dxãwa tc'ẽean khóè ba qarika ntcãa-ntcãa a khóè ne xg'aeku koe xaoa xòó me, a i a thõò-thõo me tamase tcg'oa cgae me. ");
INSERT INTO nhr_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ne kò wèé ne khóè ne area hãa, a ne a c'ẽe ne bìrí a máá: “Dùútsa gúù saa ncẽe sa? Qarian úúa hãasem ko dxãwa tc'ẽean ga dqàè i tcg'oa ka!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","I kò kúúga nxàea ba ẽem xg'aekum koe hàna xu qgáì xu wèé xu koe qháése qõò. ");
INSERT INTO nhr_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Me kò Jeso ba gaam còrè-nquum koe tcg'oa, a síí Simonem dim nquum koe tcãà. Si kò Simonem ka c'uìse sa cgùrukagu si kos tcììs kaias ka qgóóèa, ne Jeso ba gas ka bìrí. ");
INSERT INTO nhr_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Me Jeso ba gas koe qám̀se, a ba a ẽes tcìì sa dqàè, si guu si, si kò kúúga tẽe a sa a tshoa-tshoa a tsééa máá ne. ");
INSERT INTO nhr_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eẽs ko cáḿ sa tcãà ka ne kò wèé ne khóè ne gane di tcìì-khoean tãáka zi tcìì zi ko tsàaraa hãa a Jesom koe óá. Me kò wèém khóèm koe tshàua ba tòó, a kg'õèkagu me. ");
INSERT INTO nhr_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","I kò gataga dxãwa tc'ẽean káí ne khóè ne koe guu a q'aua tcg'oa, a ko máá: “Tsáá Tsia Nqarim di Tsi Cóá Tsi i!” témé. Igabam kò dqàè e, a táá kgoara máá a i kg'ui, q'ana i ko hãa Kreste Me e sa khama. ");
INSERT INTO nhr_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Eẽ i ko q'uu kam kò Jeso ba c'ẽem qgáìm nqooako hãam koe qõò. Ne kò káí ne khóè ne qaa Me. Eẽ ne ko hàà sao-xg'ae Me ka ne ko xgáèa tòó Me, táám gha qõòa guu ne ka. ");
INSERT INTO nhr_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Igabam kò bìrí ne a máá: “Qãè tchõàn Nqarim di x'aian di méér c'ẽe xu x'áé-dxoo xu koe thẽé xgaa-xgaa, gaan domkagar tsééa óáèa hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A ba a kò Jutea ne di xu còrè-nquu xu koe xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","C'ẽem cáḿ ka ne kò khóè ne Jeso ba Genesarete dim tshàam-kg'áḿ koe nxa̱ma-nxa̱maa a ko Nqarim dim kg'ui ba komsana. Jesom gaa koe téé-tẽe ");
INSERT INTO nhr_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","kam kò cám̀ dxòro tsara bóò, tsara tshàam dxùukg'ai koe téé-tẽe, x'aù qgóó-kg'ao xu ka xoana guuèa hãa tsara, ncẽe kò síí hãa a ko gaxu di c'uisían xg'aà xu. ");
INSERT INTO nhr_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Me Jeso ba c'ẽem dxòrom Simonem di kò iim koe tcãà, a ba a dtcàrà me, dxòro bam gha cg'árése tshàan q'oo koe ghànèa tcãà sa. Me kò gaam q'oo koe ntcõó a khóè ne xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eẽm ko kg'uia xg'ara kam kò Simone ba bìrí a máá: “Tshàam nqáè koe ncẽem dxòro ba úú, naka xaoa gaxao di c'uisían tcãà naka x'aùan qgóó,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Me Simone xo̱a a máá: “X'aigaè, ncãa xae wèém ntcùú ba qarika tséé, a xae a táá cúí gúù ga qgóó. Igabaga ncãaga Tsi ko ncẽeta méé khamar gha c'uisían tcãà,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gatà xu kò hẽé a xu a káí x'aùan qgóó, i gaxu di c'uisían tòà gha khama ii. ");
INSERT INTO nhr_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ka xu ko c'ẽem dxòrom koe kò hàna xu x'aù qgóó-kg'ao xu dtcàrà, hàà xu gha hùi xu ka. Xu hàà a ẽe tsara dxòro tsara wèéa tsara ga cg'oè-cg'oe, tsara tshoa-tshoa a tom̀ gha khama ma kúrúse. ");
INSERT INTO nhr_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eẽm ko Simone Petere ncẽe sa bóò kam kò Jesom nqàrè-kg'am koe qáúse, a máá: “X'aigaè, tcg'oara guu te, chìbi-kg'aor khóè ra a ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Gabá hẽé naka wèé xu ẽe kò gam cgoa hàna xu hẽéthẽéa kò kaisas ares ka tcãàèa khama, x'aùan ẽe xu kò qgóóa hãa ka. ");
INSERT INTO nhr_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebetem ka cóásea tsara, Jakoboa tsara Johanea tsara kò gataga area hãa thẽé, ncẽe kòo Simonem cgoa tsééa xg'ae tsara. Me Jeso ba Simone ba bìrí a máá: “Táá q'áò guu; ncẽem cáḿ koe tsi gha guu a tshoa-tshoa a khóè ne di tsi qgóó-kg'ao tsi i ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Xu kò ẽe xu ko gaxu di dxòroan tshàam-kg'áḿ koe tòó, kaga wèé zi gúù zi guu, a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Eẽm Jeso ba c'ẽem x'áé-dxoom koe hàna kam kò lepero dis tcìì sa tsàaraa hãam khóè ba hàà. Eẽm ko Jeso ba bóò kam kò kg'áía ba cgoa góḿankg'ai koe cg'áé a còrè Me a máá: “X'aigaè, tc'ẽe Tsi kòo ne Tsi ga kúrú ter q'ano,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Me Jeso ba tchoanà tshàu, a ba a khóè ba qgóó, a máá: “Gatà Ra ko ma tc'ẽe, ke q'ano!” témé. Kas ko lepero dis tcìì sa kúúga kaà cgae me. ");
INSERT INTO nhr_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Me kò Jeso ba qarika x'áè me a máá: “Táá méé tsi cúí khóè ga síí chóà máá guu, igaba méé tsi qõò naka tsia tsari q'ano-q'anosean domka síí peresitim koe x'áíse, naka dàòa-mááku sa x'áís iise tcg'òó, ẽem ma Moshe x'áèa hãa khamaga ma,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Igabas kò Jesom dis tchõà sa kaisase tsa̱i-tsa̱ise, zi khóè ne di zi xg'ae zi káí zi hààku, hàà zi gha komsana Me a zi a thẽé gazi di tcììan koe qãèkaguè ka. ");
INSERT INTO nhr_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Me Jeso ba tcg'oara guu ne, a nqooa hãa xu qgáì xu koe qõò, a síí gaa koe còrè. ");
INSERT INTO nhr_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","C'ẽe cáḿ kam hãa a ko xgaa-xgaa ka xu kò Farasai xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xu gaa koe ntcõe, ncẽe kò wèé xu x'áé xu Galilea di xu koe hẽé naka Jutea di xu koe hẽé naka Jerusalema di xu koe hẽéthẽé guua hãa xu. I kò X'aigam di qarian Gam cgoa hãa, gaan cgoam gha khóè ne qãèkagu ka. ");
INSERT INTO nhr_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bóò, ka xu kò c'ẽe xu khóè xu kúúga khóèm nqo̱ara hãa ba óága, gam dim tcoàm koe xòó mea hãase, a xu a kò dàò ba qaa, tcãà me xu gha a síí cookg'aia ba koe xòó me ba. ");
INSERT INTO nhr_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Igaba ẽe xu ko bóò, khóè ne di káí-q'ooan ka xu ko xháé, nta xu gha ma nquum q'oo koe ma tcãà me sa, ka xu kò nquum tco̱be koe chúrù a tcãà, a xu a nquum nqáè koe gam dim tcoàm cgoa xòó me, Jesom cookg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eẽm ko Jeso ba gaxu di dtcòm̀an bóò kam kò máá: “Khóè tseè, tsari chìbian tsi qgóóa mááèa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ka xu ko x'áè xgaa-xgaa-kg'ao xu hẽé naka Farasai xu hẽéthẽé tshoa-tshoa a tẽèse a máá: “Dìí ba gáé ncẽe ba, ncẽe Nqari ba ko cóè khama ko ma kg'ui ba? Nqarim cúí ba khóèan gaan di chìbian qgóóa máá di qarin úúa hãa ka, c'ẽe khóè ka oose!” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeso ba ko tc'ẽea xu hãa sa q'ana hãa khamam kò tẽè xu a máá: “Dùús domka xao ko ma tcáóa xao q'oo koe ma tc'ẽea ẽe e? ");
INSERT INTO nhr_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ndaka nea thamkaà? ‘Chìbia tsi tsi qgóóa mááèa,’ témé nea kana máá: ‘Tẽe naka qõò,’ témé nea?” tam ma tẽè xu. ");
INSERT INTO nhr_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","A ba a máá: “Igaba méé xao q'ãa, Khóèm dim Cóá ba nqõómkg'ai koe qarian úúa sa, khóèa nem gha gaan di chìbian qgóóa máá di i,” témé, kam kò ẽe nqo̱ara kò hãa ba bìrí a máá: “Bìrí tsir ko a ko máá, tẽe naka tsarim tcoà ba séè naka x'áéa tsi koe dìbi,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Gaa x'aè kagam kò gane cookg'ai koe tẽe, a ba a ẽem kò gam tc'amkg'ai koe xõem tcoà ba séè, a x'áéa ba koe Nqari ba dqo̱m̀a máásea dìbi. ");
INSERT INTO nhr_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Si are sa wèéa ne ga tcãà, ne Nqari ba dqo̱m̀, a ne a q'áòs ka tcãàè, a máá: “Are-aresa zi gúù zi ta ncẽem cáḿ ka bóòa hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ncẽe zi gúù zi qãá q'oo koem kò Jeso ba tcg'oa, a mari xg'ae-xg'ae-kg'aom c'ẽem Lefi ta ko ma tciiè ba bóò, me marian ko séèa xg'ae-xg'aeèm nquum koe ntcõóa-ntcõe. Me bìrí me a máá: “Xùri Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Me kò Lefi ba wèé gúùan guu a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","A ba a x'áéa ba koe síí Jeso ba kaias kõ̱è sa kúrúa máá. Si kò kaias xg'aes mari xg'ae-xg'ae-kg'ao xu di sa hẽé, naka c'ẽe xu hẽéthẽé di sa gam cgoa tc'õó. ");
INSERT INTO nhr_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Xu kò Farasai xu hẽé naka gaxu di xu x'áè xgaa-xgaa-kg'ao xu hẽéthẽé Gam di xu xgaa-xgaase-kg'ao xu cgoa mẽéku a máá: “Dùús domka xao ko mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé cgoa tc'õó a kg'áà máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Me Jeso ba xo̱a xu a máá: “Eẽ tsàa tama khóèa ne naakan qaa tama, igaba ẽe ko tsàa ne ko qaa a. ");
INSERT INTO nhr_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tchàno ne khóè ner gha hàà tcii kar hàà tama, igabar hààraa, hààr gha chìbi-kg'ao ne tcii ne tcóóse ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Xu kò bìrí Me a máá: “Johanem di xu xgaa-xgaase-kg'ao xu ko káíse tc'õoan carase a ko còrè, khamaga xu ko Farasai di xu xgaa-xgaase-kg'ao xu hẽé; igaba xu ko Tsari xu wèé x'aè ka tc'õó a ko kg'áà,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Me Jeso ba xo̱a xu a máá: “A séè-kg'aom di cg'áè-kg'aoan xao ga tc'õoan cara, qanegam gane cgoa hãa koe? Cuiskaga a! ");
INSERT INTO nhr_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Igabam gha x'aè ba hàà, séè-kg'aom gha gane koe guu a séèa tcg'òóè ba; ne gha ẽe xu cáḿ xu ka tc'õoan carase,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A ba a gataga ncẽes sere-sere sa bìrí ne a máá: “Cúí khóè ga káà a, ka̱bam qgáí ba gha tòà, a ncìím qgáím koe qgãéa ntcòo me e. Gatà i kò hẽé nem gha ka̱bam qgáí ba tòà, me gataga ka̱bam qgáí ba ncìím cgoa qõòa mááku tite. ");
INSERT INTO nhr_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Gataga i khóèan káà a, ka̱ba gõéan gha ncìí zi khòo dtcòbè zi koe qg'oe e. A ncẽè gatà i kò hẽé ne i gha ka̱ba gõéan dtcòbè zi tòà, a i a gha ntcã̱a, zi gha dtcòbè zi tòàra q'aase. ");
INSERT INTO nhr_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Igaba méé i ka̱ba gõéan ka̱ba zi khòo dtcòbè zi koe qg'oeè. ");
INSERT INTO nhr_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Me gataga cuiskaga c'ẽem khóè ba ncìí gõéan kg'áà xg'ara naka ka̱ban tc'ẽea hãa tite; ‘Ncìía nea qãè e,’ tam gha méé khama,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","C'ẽem Sabatam kam kò Jeso ba maberean dim xháràm koe xóé a ko qõò, ka xu kò Gam di xu xgaa-xgaase-kg'ao xu gaan di tc'áróan khõá, a ko tshàu q'ooa xu koe ncóbéa tc'õó. ");
INSERT INTO nhr_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Igaba xu kò c'ẽe xu Farasai xu bìrí Me a máá: “Dùús domka xao ko Sabata dim cáḿ ka x'áèan koe kgoara mááè tama sa kúrúa máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Me Jeso ba xo̱a xu a máá: “Qanega xao gáé nxárá ta ga hãa x'aigam Dafitem xg'ao kúrú sa, gabá hẽé naka gam ka c'ẽea xu hẽéthẽé kò xàbà hãa ka? ");
INSERT INTO nhr_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Nqarim dim nquum koem kò tcãà, a ba a ts'ee-ts'eekg'aièa péréan séè, ncẽe peresiti xu ka cúí ko tc'õóè e, a tc'õó a ba a gam ka c'ẽea xu au,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A ba a bìrí xu a máá: “Khóèm dim Cóá ba Sabata dim X'aiga Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","I kúrúse Me c'ẽem cáḿ Sabata dim ka còrè-nquum koe síí tcãà, a xgaa-xgaa. Me kò kg'áò xòè di tshàua ba nqo̱ara hãam khóè ba gaa koe hãa. ");
INSERT INTO nhr_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Xu kò Farasai xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xu xaèa kg'ónò Me, Sabata dim cáḿ kam gha qãèkagu sa xu kò bóò kg'oana khama, nxãasega xu gha chìbi-chibi Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Igabam ko Jeso ba ẽe xu tc'ẽea hãa zi wèé zi q'ana khamam kò nqo̱ara tshàua hãam khóè ba bìrí a máá: “Tẽe naka tsia wèé ne khóè ne ncẽe koe hãa ne cookg'ai koe téé,” témé. Me tẽe a síí gaa koe téé. ");
INSERT INTO nhr_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Me Jeso ba bìrí xu a máá: “Tẽè xao or ko a ko máá: Sabata dim cáḿ ka sa kháé ndaka sa kgoaraèa: qãèan kúrú saa kana cg'ãèan kúrú saa, khóè ba kg'õèkagu saa kana cg'õo me saa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A ba a wèéa ne ga bóò a gaam khóè ba bìrí a máá: “Tshàua tsi tchoanà,” témé. Me gatà hẽé, i tshàua ba ka̱bise a qãè. ");
INSERT INTO nhr_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Igaba xu kò kaisase xgóà a xu a tshoa-tshoa a nxàe cgoaku, dùú sa xu gha Jeso ba kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gaa xu cáḿ xu kam kò Jeso ba xàbìm koe síí, a ko síí còrè, a wèém ntcùú ba hãa a Nqari ba còrè. ");
INSERT INTO nhr_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eẽ i ko q'uu kam kò Gam di xu xgaa-xgaase-kg'ao xu Gam koe tciia xg'ae, a ba a 12 xu nxárá tcg'òó, a x'áè úú-kg'ao xu ta ma tcii xu: ");
INSERT INTO nhr_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simonem ncẽe kòo Petere ta ma tciiè ba hẽé, naka gam ka qõesem Anterea ba hẽé, naka Jakobo ba hẽé, naka Johane ba hẽé, naka Filipi ba hẽé, naka Baretolomaio ba hẽé, ");
INSERT INTO nhr_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","naka Mataio ba hẽé, naka Tomase ba hẽé naka Alefaiom ka cóásem Jakobo ba hẽé, naka Simonem ncẽe kò tòókuan x'ãà máá ta ko ma tciiè ba hẽé, ");
INSERT INTO nhr_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","naka Jutasem Jakobom ka cóáse ba hẽé, naka Jutasem Isekariotem ncẽe kò khóè ne tshàu q'oo koe tcãà Mea ba hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Me kò xàbìm koe xõa cgoa xu a síí nqáḿan koe téé. Si ko gaa koe kaias xg'aes Gam di xu xgaa-xgaase-kg'ao xu di sa hẽé, naka khóè ne di sa hẽéthẽé hàna, wèém nqõóm Jutea di ba hẽé, naka Jerusalema di ba hẽé naka tshàam qàe di tsara x'áé-dxoo tsara Ture ba hẽé naka Sitone ba hẽéthẽé tsara koe guua ne khóè ne di sa. ");
INSERT INTO nhr_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Hàà ne gha komsana Me ka kò hààraa ne, a gataga thẽé tcììa ne koe kg'õèkaguè ka. Ne kò ẽe cg'ãè tc'ẽean ka kòo xgáèè ne thẽé qãèkaguè. ");
INSERT INTO nhr_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Wèé ne khóè nea kò qgóó Me ne gha sa tc'ẽe, qaria ne kò Gam koe guu a ko wèéa ne ẽe kòo qgóó Me ne qãèkaguè khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Xgaa-xgaase-kg'aoa nem téé a ko ntcáà koem kò máá: “Ts'ee-ts'eekg'aièa tua gatu ẽe dxàua hãa tu, Nqarim di x'aia nea gatu di i khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ts'ee-ts'eekg'aièa tua gatu ẽe ncẽeska ko xàbàn ka cg'õoè tu, xg'ãàkaguè tu gha khama. Ts'ee-ts'eekg'aièa tua gatu ẽe ko kg'ae tu, kg'ãè tu gha khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ts'ee-ts'eekg'aièa tua, ncẽè khóèan kò hòre tua hãa ne, a ko gaan xg'aeku koe xhàiagu tu u ne, a ko cóè tu u ne, i ko Khóèm dim Cóám domka cg'õèa tu cg'ãès gúùs khama ma aaguè ne. ");
INSERT INTO nhr_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Eẽm cáḿ ka qãè-tcao, naka tua nxàì-nxaise qãè-tcaoan ka, gatu di surutan nqarikg'ai dia kaia hãa ke. Gaxu ka xõò ga xu xg'ao ma porofiti xu ma qgóóa hãa ga a ke. ");
INSERT INTO nhr_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Igaba haò, cg'ãè i gha ii gatu ncẽe qguùa hãa tu ka, nxãakamaga tu gatu di qgài-qgai-tcáókuan hòòa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Haò, cg'ãè i gha ii gatu ncẽeska qãèse xg'ãà tu ka, xàbàn ka tu gha cg'õoè khama. Haò, cg'ãè i gha ii gatu ncẽeska ko kg'ãè tu ka, tshúù-tcao tu gha a kg'ae khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Haò, cg'ãè i gha ii gatu ncẽe wèé khóèan ga ko qãèse kg'ui gatu ka tu, ẽea gane ka xõò ga xu xg'ao ma tshúù-ntcõa di xu porofiti xu ma qgóóa hãa ga a khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Igabar ko bìrí tu u gatu kóḿ Te ko tu a ko máá: Gatu di cg'õo-kg'aoan méé tu ncàm̀, naka qãèan kúrúa máá ẽe hòre tua ne. ");
INSERT INTO nhr_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ts'ee-ts'eekg'ai ẽe ko cgúí tu u ne, naka ẽe ko xgàra tu u ne còrèa máá. ");
INSERT INTO nhr_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ncẽè c'ẽem khóèm kò kg'áò xòè di góóa tsi x'ábú ne, nxãa ba c'ẽem góó ba máà thẽé nakam x'ábú. A ncẽè c'ẽem khóèm kòo tc'amaka tsi ha̱na qgáían nxõ̱o cgae tsi, ne táá c'ẽean nxõ̱o cgaea tsi cara me guu. ");
INSERT INTO nhr_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Máà dìím wèém ẽe ko dtcàrà tsi ba, naka khóèm kò q'õòa tsi hãas gúù sa séè cgae tsia hãa ne táá séèa ka̱bi si guu. ");
INSERT INTO nhr_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Eẽ tu ko tc'ẽe, khóè ne méé ne gatu koe kúrú, nxãa zi méé tu thẽé gane koe kúrú. ");
INSERT INTO nhr_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Eẽ ncàm̀ tua hãa ne tu kò ncàm̀a hãa ne sa gha dùú sa ka̱bisea máá tu u? Ncẽe chìbi-kg'ao ne ne ko thẽé gatà hẽé a ko ẽe ncàm̀ nea hãa ne thẽé ncàm̀ ka. ");
INSERT INTO nhr_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","A ncẽè ẽe ko qãèan kúrúa máá tu u ne tu kòo qãèan kúrúa máá, ne sa gha dùú sa ka̱bisea máá tu u? Ncẽe chìbi-kg'ao ne ne ko thẽé gataga hẽé ka. ");
INSERT INTO nhr_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A ncẽè nxãakamaga tu q'ana hãa suruta tu u gha ne tu kòo cgóbè, ne ba gha Nqari ba gaan domka qãè-tcaoa máá tu u? Ncẽe chìbi-kg'ao ne ne ko thẽé gane ka c'ẽe ne chìbi-kg'ao ne cgóbè, nxãasega ne gha surutaè domka ka. ");
INSERT INTO nhr_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Igaba méé tu gatu di cg'õo-kg'aoan ncàm̀, naka tua qãèan kúrú máá a, naka cgóbè e, surutakuan qaa tamase. Nxãaska i gha gatu di surutan kaisa ii, tu gha gataga Kaisase Tc'amaka hãam di tu cóá tu ii, ẽe qãè-tcaoa máákuan úú tama ne hẽé naka ẽe cg'ãè cau ne hẽéthẽé koem qãè Me e khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Thõò-xama-mááku di méé tu ii, ncẽem ma gatu ka Xõò ba ma thõò-xama-mááku di ii khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Táá xgàra guu naka tua gha nxãasega táá xgàraè. Gataga táá chìbi-chibi naka xgàra guu, naka tua gha nxãasega táá chìbi-chibi naka xgàraè. Qgóóa máá, naka tua gha nxãasega chìbia tu qgóóa mááè. ");
INSERT INTO nhr_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Máà naka tua gha nxãasega Nqarim ka máàè. Qãès tc'ãò-tc'ãos, qãea ntcòoèa, a khõò-khõoèa sa, a cg'oè a ko ntcã̱a sa gha cookg'aia tsi koe tòóè. Eẽ tsi ko tcg'òós tc'ãò-tc'ão sa gha ẽe tsi gha hòòs tc'ãò-tc'ãos ga si i ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Gatagam kò thẽé sere-sere sa bìrí xu a máá: “A káà tcgáím khóè ba ga c'ẽem khóèm káà tcgáí ba tcéè tcuì? A wèéa tsara ga ha̱ém q'oo koe cg'áéa tcãà tite? ");
INSERT INTO nhr_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xgaa-xgaase-kg'ao ba gam dim xgaa-xgaa-kg'aom ka tc'amaka hãa tama, igaba wèém ẽe qãèse xgaa-xgaasea xg'ara ba gha gam dim xgaa-xgaa-kg'aom khama ii. ");
INSERT INTO nhr_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Dùús domka tsi ko tsáá ka c'ẽem tcgáí q'oo koe hãam tcg'óbé ba hòòa máá, igaba tsi tsáá tcgáí q'oo koe hãam hìi-dxoo ba hòò tama? ");
INSERT INTO nhr_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nta tsi gha ma tsáá ka c'ẽe ba bìrí a máá: ‘Tíí tcáràè, hàà nakar tcgáí q'ooa tsi koe tcg'óbé ba tcg'òó,’ témé, ncẽe tsáá tcgáí q'oo koe hãam hìi-dxoo ba tsi hòò tama koe. Tsáá qãè khóèan khama ko ma kúrúse tseè! Kg'áíka tcgáí q'ooa tsi koe hànam hìi-dxoo ba tcg'òó, naka tsia qãèse bóò naka nxãwa tsáá ka c'ẽem tcgáí q'oo koe hàna tcg'óbéan tcg'òó,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","A ba a máá: “Qãès hìi sa cuiskaga tshúù tc'áróan kúrúa hãa tite, si gataga tshúùs hìi sa qãè tc'áróan kúrúa hãa tite khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Wèés hìi sa tc'áróa sa ka q'ãaèa khama. Dxàman úúa zi hìi-coa zi koe i faia di tc'áróan tcuùè tama, kana i xg'óà di zi hìi zi koe kg'oman tcuùè tama khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Qãèm khóè ba ko gam di tcáóan di qãèan koe guu a qãè zi gúù zi tcg'òó, me ko cg'ãè caum khóè ba gam di cg'ãè cauan koe guu a cg'ãè zi gúù zi tcg'òó. Kg'áḿ sa ko tcáós koe cg'oèa a ko ntcã̱a zi gúù zi nxàe khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","A ba a máá: “Dùús domka tu ko ‘X'aigaè, X'aigaè,’ ta ma tcii Te, igaba tu bìrí tu ur ko sa kúrú tama? ");
INSERT INTO nhr_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","“Dìím wèém ẽe ko Tíí koe hàà, a Tiri kg'uian kóḿ, a i ko méé sa kúrú bar gha x'áí tu u ntam ii sa. ");
INSERT INTO nhr_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Khóèm ncẽe gam dim nquu ba ko tshoa-tshoa a tshàom khamam ii, ncẽe ko kaisase nqãaka tshào, a tshoa-tshoa sa nxõ̱án koe tshào ba. A ẽe i ko tòèko tshàan hàà, a ko hàà ẽem nquu ba tcãò igabam ko̱ri tite ba, qãèsem tshàoèa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","“Igaba dìím wèém ẽe ko Tiri kg'uian kóḿ, igaba kúrú u tama baà khóèm ncẽe ko gam dim nquu ba tshoa-tshoa úú tamase góḿankg'ai koe tshàom khama ii; tòèko tshàan kò gaam nquu ba tcãò ne kò gaa x'aè kaga cg'áé ba - si kò ẽem nquum dis cg'áé sa cg'ãè ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Eẽm ko Jeso ba wèé zi gúù zi ncẽe zi khóè ne cgoa kg'uia xg'ara kam kò Kaperenaume koe síí tcãà. ");
INSERT INTO nhr_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gaa koem kò ncõo-kg'ao xu dim kaiam dim qãàm kaisasem kò ncàm̀a hãa ba hàna, a ba a kòo x'oos qàe koe tsàa. ");
INSERT INTO nhr_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Eẽm ko Jesom ka kóḿ kam kò kaia xu Juta di xu Gam koe tsééa úú, xu síí dtcàrà Me hààm gha gam dim qãà ba kg'õèkagu ka. ");
INSERT INTO nhr_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Xu kò Jesom koe síí a síí qarika còrè Me a máá: “Ncẽem khóè ba tsari hùikuan ka kg'anoèa. ");
INSERT INTO nhr_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Gaxae di ne khóè nem ncàm̀a, a ba a gataga còrè-nquu ba tshàoa máá taa khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Me Jeso ba qõò cgoa xu. Eẽ xu qanega gaam khóèm dim nquum koe cúù tama kam kò ncõo-kg'ao xu dim kaia ba tcáràsea xu tsééa tcg'òóa máá Me, síí xu gha bìrí Me a máá: “X'aigaè, táá xhõe-xhõese guu, dìí cgáér tama ra a ke, nquua te tco̱be dòm̀ q'oo koe Tsi ga tcãà ra. ");
INSERT INTO nhr_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Cgáéser bóòse tama, gaa domkaga ra kò táá tíía hàà a hùikuan dtcàrà Tsi, ke kg'amaga kg'ui ba tcg'òó nakam gha tirim qãà ba qãè. ");
INSERT INTO nhr_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Tíí igabar kaia xu dòm̀-q'oo koe hànar khóè ra a, xu gataga ncõo-kg'ao xu tíí dòm̀-q'oo koe hàna ke. Ra ko ncẽe ba bìrí a máá: ‘Qõò,’ témé, me qõò, ra c'ẽe ba bìrí a máá: ‘Hàà,’ témé, me hàà. Ra tirim qãà ba bìrí a máá: ‘Ncẽe sa kúrú,’ témé, me kúrú si ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eẽm ko Jeso ba ncẽe sa kóḿ kam kò kaisase are, a ba a ka̱bise cgae ẽe kò xùri Mes xg'ae sa a máá: “Bìrí tu ur ko a ko máá: Qanegar cúí khóè ga Iseraele koe hòò ta ga hãa, ncẽeta ma kaias dtcòm̀ sa úúa hãa a,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Xu tchõà xàà-kg'ao xu gaxu dim kaiam dim nquum koe ka̱bise, a síí qãà ba sao-xg'ae me qãè me e. ");
INSERT INTO nhr_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Gaa koe guus kam kò Jeso ba x'áé-dxoom Naine ta ko ma tciièm koe síí, xu Gam di xu xgaa-xgaase-kg'ao xu hẽé naka khóè ne dis xg'aes kaia sa hẽéthẽé xùri Me. ");
INSERT INTO nhr_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Eẽm ko heke-kg'áḿs x'áé-dxoom dis koe cúù kam kò kúúga x'óóam cóá ba tchàa koe tcg'oa cgoaè, síím gha kg'ónòè ka. C'ẽes khóès dim cóám cúí me e kò ii, ncẽe kò dxàe-ntcõa ii sa. Si kò kaias xg'aes x'áé-dxoom di ne khóè ne di sa gas cgoa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eẽm ko X'aigam Jeso ba bóò si kam kò kaisase thõò-xama máá si, a ba a bìrí si a máá: “Táá kg'ae guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Me còoka nqáé a síí káá ba qgóó, xu kò khóè xu ẽe kò káá ba qgóóa xu téé. Me kg'ui a máá: “Cóá tseè, tẽe, tar ko tsáá ka méé,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Me kò x'óóam cóá ba tẽe a ntcõó, a ba a tshoa-tshoa a kg'ui, Me Jeso ba síí xõò sa máà me. ");
INSERT INTO nhr_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Si kò q'áò sa wèéa ne ga tcãà, ne Nqari ba dqo̱m̀ a máá: “Kaiam porofiti ba hàà cgae taa,” témé, a ne a máá: “Nqari ba hààraa a ko hàà Gam di ne khóè ne kabi!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Si ncẽes tchõàs Jesom di sa wèém Juteam koe tsa̱i-tsa̱ise naka wèé xu qgáì xu nxa̱ma-nxa̱ma mea hãa xu koe hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johanem di xu xgaa-xgaase-kg'ao xu kò ncẽe zi gúù zi wèé zi ka bìrí me. Me gam di xu xgaa-xgaase-kg'ao xu ka cám̀ tsara tcii, ");
INSERT INTO nhr_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","a X'aigam Jesom koe tsééa úú tsara a, a máá: “A Tsáá ga Tsia ncẽe ga koma hàà Tsi, kana méé xae c'ẽem khóè ba nqòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eẽ tsara ko ncẽe tsara khóè tsara Jesom koe síí ka tsara kò máá: “Johanem tcguù-tcguu-kg'ao ba Tsáá koe tséé tsama, a ba a ko máá, hàà méé tsam tẽè Tsi, Tsáá ga Tsia sa ncẽe ga koma hàà Tsi, kana méé xae c'ẽem khóè ba nqòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Gaa x'aè ẽe kam kò Jeso ba káí ne khóè ne gane di tcììan koe hẽé naka cg'ãè tc'ẽean koe hẽéthẽé qãèkagu, a ba a khóè ne ẽe káà tcgáí ne kúrú ne bóò. ");
INSERT INTO nhr_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Me kò xo̱a tsara a, a máá: “Qõò naka síí Johane ba bìrí ẽe tsao ko kóḿ a ko bóò sa: ‘Ncẽe káà tcgáí ne ko bóò, ne ko ẽe kò qõò tama ne qõò, ne kò lepero dis tcììs di ne qãèkaguè, ne ẽe kóḿ tama ne ko kóḿ, ne ẽe kò x'óóa hãa ne ghùiè, i kò qãè tchõàn ẽe dxàua hãa ne xgaa-xgaaè. ");
INSERT INTO nhr_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ts'ee-ts'eekg'aièa baa khóèm ẽe gam di dtcòm̀an Tíí koe tcgàba hãa tite ba,’” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Eẽ tsara ko Johanem di tsara tchõà xàà-kg'ao tsara qõò kam ko Jeso ba tshoa-tshoa a xg'ae zi bìrí Johanem ka a máá: “Tchàa-xgóós koe tu kò ko qõò ka tu kò síí dùú sa bóò? Tc'ãán ka ko ntcãa-ntcãaèm tc'áà baa kò ii? ");
INSERT INTO nhr_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nxãas tamas kò ii ne tua kòo síí dùú sa bóò? Khóèm xaam qgáí ba ha̱na baa? Eẽ-ẽe, khóè ne ẽe káí mari qgáían ko hã̱a, a ka̱rese x'ãèa hãa nea x'aigan di nquuan koe hãa. ");
INSERT INTO nhr_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kháé dùú sa tu kò nxãaska síí ko bóò? A porofiti baa? Eè, bìrí tu ur ko, porofitim ka tc'amaka hãa me e. ");
INSERT INTO nhr_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ncẽe ba gam ka i góáèa hãam ga me e, a ko máá: ‘Bóò, Tirim tséé-kg'ao bar gha Tsáá cookg'ai koe tsééa úú, ncẽe gha Tsarim dàò ba kg'ónòa máá Tsi ba,’ ta mééèa ba. ");
INSERT INTO nhr_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Bìrí tu ur ko a ko máá: Eẽ khóè zi ka ábàèa ne ka Johanem ka kaia hãa ba káà me e, igaba gaam ẽe Nqarim di x'aian koe cg'áré ii ba gam ka kaia hãam ga me e.” ");
INSERT INTO nhr_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Ne kò wèé ne khóè ne komsana me, xu kò gataga mari xg'ae-xg'ae-kg'ao xu Nqarim di tchànoan dqo̱m̀, ne kò Johanem ka tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Igabaga xu kò Farasai xu hẽé naka x'áè q'ãa-kg'ao xu hẽéthẽé xu Nqarim tc'ẽea máá xua hãa sa xguì, a táá Johanem ka tcguù-tcguuè.) ");
INSERT INTO nhr_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Kháé Ra gha nxãaska ncẽem x'aèm di ne khóè ne dùús cgoa nxárá xg'ae? Dùús khama ne ii? ");
INSERT INTO nhr_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cg'áré cóán khama ne ii, ncẽe gúùan ko x'ámáguè qgáì koe hãa a ko tciiku u, a ko máá: ‘Fulutuan ta kò ciia máá tu u, tu kò táá ntcãà; ta kò gataga x'ooan di ciian nxáè, tu kò táá kg'ae,’ témé e. ");
INSERT INTO nhr_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Johanem tcguù-tcguu-kg'ao ba kò hàà, a péré tc'õó tama, a gõé kg'áà tama, igabaga tu kò máá: ‘Dxãwa tc'ẽea nem úúa hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Igabam kò Khóèm dim Cóá ba hàà, a ko tc'õó a ba a ko kg'áà, tu kò máá: ‘Bóò, tc'õó-kg'aom ncẽe ba, a kg'áà-kg'aom gõéan di ba, mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé dim tcárà ba,’ ta méé. ");
INSERT INTO nhr_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Igaba i ko q'ãan di tc'ẽean gaan di cóán wèé koe guu a tchàno o sa x'áíse,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","C'ẽem Farasai ba kò Jeso ba dtcàrà, síím gha tc'õó cgoa me ka. Me kò Jeso ba nquum q'oo koe síí tcãà, a ba a ntcõó a tc'õó. ");
INSERT INTO nhr_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Si kò gaam x'áé-dxoom koe c'ẽes khóès chìbi-kg'ao sa hàna. Eẽs ko kóḿ, Jeso ba Farasaim x'áé koe hãa a ko tc'õó sa, kas kò alabasetere di nxõ̱án cgoa kúrúèam ts'óó-c'õám koe hãa qãè hm̀m̀ xg'ãò tshãán cgoa síí, ");
INSERT INTO nhr_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","a sa a Jesom nqàrè-kg'am koe hàà téé, a kg'ae, a tshoa-tshoa a tcgáí-tshàra sa cgoa nqàrèa ba cg'ãà-cg'ãa, a sa a c'õòa sa cgoa tchùu u, a x'obè nqàrè Me, a sa a tshãán cgoa ntcã̱á nqàrè Me. ");
INSERT INTO nhr_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eẽm ko Farasaim ncẽe kò tcii Mea ba ncẽes gúù sa bóò kam ko bìríse a máá: “Ncẽem khóèm kò tseegukaga porofiti ba ii nem ga kò q'ana hãa ncẽe ko qgóó Me sa dùútsa khóè si i sa, chìbi-kg'ao si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Me kò Jeso ba bìrí me a máá: “Simoneè, c'ẽes gúù sar chóà cgoa tsi kg'oana,” témé. Me máá: “Xgaa-xgaa-kg'aoè, bìrí te si,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Me máá: “C'ẽe x'aè ka tsara kò cám̀ khóè tsara hàna, marian kò c'ẽem khóèm koe cgòbèa tsara. C'ẽe ba kò 500 khama noo marian qano di cgóbèa, me c'ẽe ba 50 khama nooan cgóbèa. ");
INSERT INTO nhr_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cúí gúù ga tsara kò úú tama, suruta ka̱bi cgoa me tsara gha a, khamam kò wèéa tsara ga qgóóa máá. Ke ncẽeska bìrí Te, ndaka ba gha kaisase gatsara ka ncàm̀ me sa?” tam ma tẽè me. ");
INSERT INTO nhr_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Me Simone xo̱a a máá: “Bóòr ko ka ẽe kaisa marian cgóbèa me e,” témé. Me Jeso ba máá: “Qãèse tsi bóòa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","A ba a nxãaska khóès koe ka̱bise a Simone ba bìrí a máá: “Ncẽes khóè sa tsia ko bóò? Tsarim nquum koer ncãa hàà, igabaga tsi ncãa xg'aà nqàrèr ko tshàan táá máà Te, igabagas ncãa tcgáí-tshàraa sa cgoa nqàrèa Te cg'ãà-cg'ãa, a c'õòa sa cgoa tchùu u. ");
INSERT INTO nhr_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ncãa tsi táá x'obè Te, igabas ncãar hààm x'aèm koe guu a nqàrèa Te x'obèan chõòkagu tama. ");
INSERT INTO nhr_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ncãa tsi táá tcúúa Te ga nxúìan cgoa tcgáù, igabagas ncãa qãè hm̀m̀ xg'ãò tshãán ka nqàrèa Te tcgáù. ");
INSERT INTO nhr_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Gaa domkar ko bìrí tsi, gas di káí chìbian kas qgóóa mááèa. Kaisa ncàm̀kua nes x'áía hãa khama. Igabaga ẽe cg'áré chìbian ka qgóóa máàèa ba ko cg'áré ncàm̀kuan x'áí,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Me kò nxãaska Jeso ba bìrí si a máá: “Sari chìbian koe si qgóóa mááèa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Xu kò cg'áè-kg'ao xu tshoa-tshoa a tẽèse a máá: “Dìí ba gáé ncẽe ba, ncẽe ko khóèan chìbian gaan di qgóóa máá ba?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Igabagam ko Jeso ba khóè sa bìrí a máá: “Sari dtcòm̀a nea kgoara sia, ke tòókuan cgoa qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ncẽe zi gúù zi qãá q'oo koem kò Jeso ba x'áé-dxoo xu koe hẽé naka x'áé-coa xu koe hẽéthẽé qõòa te, a ko Nqarim di x'aian di qãè tchõàn khóè ne xgaa-xgaa. Xu kò 12 xu xgaa-xgaase-kg'ao xu Gam di xu hãa cgoa Mea, ");
INSERT INTO nhr_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","naka gataga c'ẽe zi khóè zi hẽéthẽé e, ncẽe kò cg'ãè tc'ẽean koe hẽé naka tcììan koe hẽéthẽé kg'õèkaguè zi. Ncẽe zia kò Marias Magatalena ta ko ma tciiè sa hẽé, ncẽe i kò 7 dxãwa tc'ẽean gas koe tcg'òóèa sa, ");
INSERT INTO nhr_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","naka Herotem dim nquu kòre-kg'aom Gusam dis khóès Joana sa hẽé, naka Susana sa hẽé, naka c'ẽe zi khóè zi káí zi, ncẽe kò ko gazi di gúùan cgoa hùi xu zi hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ne kò khóè ne tãáka xu x'áé-dxoo xu koe guu a Jesom koe hàà. Eẽs ko kaias xg'ae sa xg'ae kam kò Jeso ba sere-seres ka kg'ui a máá: ");
INSERT INTO nhr_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“C'ẽe x'aè kam xg'ao xhárà-kg'ao ba qõò a síí xhárà. A ẽem ko xhárà ka i c'ẽe cgùrian dàòm qàe koe tcheè, a i a nqàrèan cgoa náà tcãàè, zi tsa̱rá zi hàà tc'õó o. ");
INSERT INTO nhr_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","I c'ẽean tcheè nxõ̱á-kg'ai di qgáìan koe. Eẽ i ko qhúí ka i ko dào, tchàua ne ko káà a khama. ");
INSERT INTO nhr_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","I c'ẽe cgùrian dxàman hàna qgáì koe tcheè, i dxàman kai, a chúú-chuu u. ");
INSERT INTO nhr_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","I c'ẽe cgùrian qãè góḿan koe tcheè, a káí tc'õoan 100 kúrú,” tam méé. Eẽm ko ncẽe zi gúù zi kg'uia xg'ara kam kò máá: “Eẽ tceean úúa hãa ba méém kóḿ,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Xu Gam di xu xgaa-xgaase-kg'ao xu tẽè Me, dùú sas ko ncẽes sere-sere sa nxàe sa. ");
INSERT INTO nhr_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Me máá: “Gaxaoa máàèa, chóm̀sea zi kàa zi Nqarim di x'aian di zi xao gha q'ãa sa, igabar ko c'ẽe ne khóè ne cgoa sere-sere zi cgoa kg'ui: ‘nxãasega ne gha bóò, a táá bóòa q'ãa ka, a nxãasega kóḿ a táá kóḿa q'ãa ka.’ ");
INSERT INTO nhr_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Si ncẽe sa xhárà-kg'aom dis sere-seres ko nxàes ga si i: Cgùri nea Nqarim dim kg'ui me e. ");
INSERT INTO nhr_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dàòm q'oo di nea ẽe kg'ui ba ko kóḿ ne ne e, igabam ko dxãwa ba hàà a kg'ui ba tcáóa ne koe séèa tcg'òó, nxãasega ne gha táá dtcòm̀ a kgoaraè ka. ");
INSERT INTO nhr_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Eẽ nxõ̱án koe kò xháràè nea gane ẽe kg'ui ba ne ko kóḿ, ne ko kúúga qãè-tcaoan cgoa hààkagu me ne ne e, igaba ne káà to̱be ne e, a ko cg'orò x'aè-coan q'oo koe dtcòm̀. A ko kúrúa bóòkuan di x'aèan ka qháésega cg'áé. ");
INSERT INTO nhr_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Eẽ dxàman za tcheèa nea, gane ẽe kóḿa ne ne e, igaba gane di kg'õèan q'oo koe ne ko tc'ẽe-tc'ẽese zi hẽé, qguùan hẽé naka kg'õèan di ka̱rean hẽéthẽé ka chúú-chuuè, a ne a kai tama. ");
INSERT INTO nhr_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Eẽ qãè góḿan koe tcheèa nea, gane ẽe kg'ui ba kóḿa, a qãè zi tcáó zi cgoa qgóóa qari mea ne ne e, a ne a ko qáò tcáó cgoa me, a nxãakg'aiga síí tc'áróan kúrú,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","A ba a máá: “X'áà-x'aa-kg'ai cgoa dis gúù sa ga dàò a gàbas cgoa xoaba-kg'ai si, kana kgàrom dòm̀ q'oo koe tcãà si ba káà me e, igabam gha téé-q'ooa sa koe tòó si, ẽe ko tcãà ne gha nxãasega x'áàn hòò ka. ");
INSERT INTO nhr_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dùús wèés ẽe chóm̀sea sa gha tchàa koe tcg'òóè, si gha dùús wèés qàbi-kg'aièa hãa sa q'ãaè, a sa a gha x'áàn koe óágaè khama. ");
INSERT INTO nhr_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ke méé tu nxãaska q'ãa, nta tu ko ma komsana sa. Wèém khóèm ẽe gúù úúa hãa ba gha káían máàè, igaba wèém ẽe gúù úú tama ba gha ẽem úúa hãa gúù-coan ga séè cgaeè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesom ka xõò sa hẽé naka qõese ga xu hẽéthẽéa kò hàà cgae Me, igaba ne kò khóèan di káí-q'ooan ka tààè, a táá Gam koe cúù. ");
INSERT INTO nhr_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Me kò bìríè a máá: “Saò sa hẽé naka Tsáá qõe ga xu hẽéthẽéa tchàa za tẽe, a bóò Tsi kg'oana,” téméè. ");
INSERT INTO nhr_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Igabam kò xo̱a a máá: “Tiris xõò sa hẽé naka Tíí qõe ga xu hẽéthẽéa Nqarim di kg'uian ko kóḿ a ko kúrú u ne khóè ne e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","C'ẽem cáḿ kam kò Gam di xu xgaa-xgaase-kg'ao xu cgoa dxòrom q'oo koe tcãà a bìrí xu a máá: “Hààn xae c'ẽem xòèm tshàam dim koe qõò,” témé, xu xgoaba. ");
INSERT INTO nhr_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eẽ xu xóé a ko qõò kam kò x'óm̀. Me kúúga kaiam tc'ãá ba tshàam tc'amkg'ai koe xgoaba, me dxòro ba tshàan ka cg'oè, xu kaias cg'ãès koe hãa. ");
INSERT INTO nhr_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xu xgaa-xgaase-kg'ao xu síí ghùi Me a máá: “X'aigaè, X'aigaè, tom̀ xae ko!” témé. Me tẽe a tc'ãá ba hẽé naka tshàam di tcẽe-tcẽean hẽéthẽé dqàè, i téé, si kò kaisas nqoo sa xóé. ");
INSERT INTO nhr_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Me tẽè xu a máá: “Gaxao di dtcòm̀a nea ndaa?” témé. Igaba xu kò q'áò, a area khama xu kò tẽèku a máá: “Dùútsa khóè ba gáé ncẽe ba? Tc'ãán ga hẽé naka tshàan ga hẽéthẽé ko kg'ui cgoa i komsana Me ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xu tshàam tc'amkg'ai koe qõò a síí Gerase ne dim nqõóm koe tcãà, Galilea dim cgoa q'óá-kg'amkua hãa ba. ");
INSERT INTO nhr_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Eẽm ko Jeso ba dxòrom koe xõa a ko gaam nqõóm koe tcãà kam kò c'ẽem khóèm x'áé-dxoom koe guua hãam cgoa xg'ae. Gaam khóè ba kò dxãwa tc'ẽean úúa, a kò qgáí hã̱a tamase qáò x'aèan hãa, a nquuan koe ga x'ãè tama, a tc'ám̀an koe cúí ga ko x'ãèa te. ");
INSERT INTO nhr_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eẽm ko Jeso ba bóò kam kò kaisase q'au a ba a cookg'aia ba koe cg'áé, a kaiam dòm̀ cgoa máá: “Dùú sa Tsi ko tíí koe qaa, Jesoè, Nqarim tc'amaka hãam di Tsi Cóá Tseè? Dtcàrà Tsir ko, táá xgàra te guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jeso ba kò dxãwa tc'ẽean bìrí i ẽem khóèm koe tcg'oa, gaa domkam kò khóè ba gatà méé. Káí q'oro i kò qgóó mea, me kò q'óḿa ba koe hẽé naka nqàrèa ba koe hẽéthẽé táùan cgoa qáéèa, a kòreèa, igabam xg'ao gaa táùan qhòma tcg'òó, a kò dxãwa tc'ẽean ka séèa tcg'òó a qãáka úúèa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Me Jeso ba tẽè me a máá: “Cg'õèa tsi dìía?” témé. Me xo̱a Me a máá: “Milone ra a,” témé. Káí dxãwa tc'ẽe nea kò tcãà mea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","I kò qarika dtcàrà Me, táám gha x'áèan tcg'òó, i chõò-q'oo úú tamam ha̱ém koe tcãà sa. ");
INSERT INTO nhr_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Zi kò káí zi xgùu zi xàbìm dxùukg'ai koe hãa a ko dxòó. Ka i kò dxãwa tc'ẽean Jeso ba dtcàrà, xgùu zi koe i gha tcãà sa, Me kgoara máá a. ");
INSERT INTO nhr_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","I khóèm koe dxãwa tc'ẽean tcg'oa a i a síí xgùuan koe tcãà, zi xgùu zi xàbìm tc'amkg'ai koe guu a kari-karisea xõa a zi a tshàam koe cg'áéa tcãà, a tom̀. ");
INSERT INTO nhr_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Eẽ xu ko xgùuan ko kòre xu khóè xu ẽe kúrúsea hãa sa bóò ka xu kò bèe a qgóé, a síí x'áé-dxoom koe hẽé naka xháràn koe hẽéthẽé xàà a. ");
INSERT INTO nhr_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ne kò khóè ne tcg'oa a síí ẽe kúrúsea hãa sa bóò. Eẽ ne ko Jesom koe hàà ka ne kò dxãwa tc'ẽean kò úúa hãam khóè ba sao-xg'ae, me Jesom nqàrè-kg'am koe ntcõe, a qgáían ha̱na, i tc'ẽea ba qãè e, ne kò q'áò. ");
INSERT INTO nhr_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Gane ẽe kò ẽe kúrúsea hãa sa bóò nea kò chóà a, ntam kò ma ẽe dxãwa tc'ẽean ka tcãàèam khóè ba ma qãèkaguè sa. ");
INSERT INTO nhr_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ne wèé ne khóè ne Gerase dim xg'aekum di ne dtcàrà Me, gane koem gha tcg'oa sa, kaisa q'áòa nea kò tcãà nea hãa khama. Me kò dxòrom koe tcãà a ba a ka̱bise, ");
INSERT INTO nhr_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","kam ko ẽe kò dxãwa tc'ẽean ka tcg'oa cgaeèam khóè ba dtcàrà Me, Gam cgoam gha qõò sa. Igabam kò Jeso ba tsééa ka̱bi me a máá: ");
INSERT INTO nhr_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ka̱bise x'áéa tsi koe naka síí nxàe, nta noosem Nqari ba kúrúa máá tsia hãa sa,” témé. Me khóè ba ka̱bise a síí wèém x'áé-dxoom koe qõòa te a khóè ne bìrí, Jesom nta noose kúrúa máá mea hãa sa. ");
INSERT INTO nhr_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Eẽm ko Jeso ba Galilea dim nqõóm koe ka̱bise kas ko khóè ne dis xg'ae sa qãèse hààkagu Me, wèé ne ne kò qãà Mea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kam kò gaa x'aè kaga c'ẽem khóèm Jairo ta ko ma tciièm ncẽe kò còrè-nquum dim tc'ãà-cookg'ai ii ba gaa koe hàà, a hàà Jesom nqàrè-kg'am koe cg'áé, a còrè Me, gam dim x'áém koem gha síí cgoa me sa. ");
INSERT INTO nhr_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cúís cóá sam kò úúa hãa, ncẽe kò 12 kuri ii sa, si kò x'oos qàe koe hãa khama. Eẽm ko Jeso ba gaa koe qõò ka i kò káí khóèan nco̱rú Me. ");
INSERT INTO nhr_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Gane xg'aeku koes kò 12 kurian kò úúa a ko xòm̀ x'aèse nxoean hòòs khóè sa hàna, a sa a kò wèé gúùan ẽes kòo kg'õè cgoa, naakan koe xgãá hãa qãèkaguès gha ka, igabas kò táá cúían kaga qãèkaguèa. ");
INSERT INTO nhr_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Si Jesom qãá koe guu a hàà, a hàà Gam dim qgáím c'am qgóó, i ko c'áòan kúúga téé. ");
INSERT INTO nhr_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Me Jeso ba tẽè a máá: “Dìína qgóó tea?” témé. Eẽ ne ko wèé ne xo̱ase kam ko Petere ba máá: “Aboè, khóè nea káí ne e, a nxa̱ma-nxa̱ma Tsia, a ko tcãò Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Igabam kò Jeso ba máá: “C'ẽe khóèa nea qgóó Tea, xám̀ Ra ko i kò qaria Te tcg'oa cgae Te khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Eẽs ko khóè sa bóò, xàì tamas kò hãa sa kas ko cgùrukose hàà, a sa a hàà Jesom nqàrè-kg'am koe cg'áé, a wèé ne khóè ne cookg'ai koe bìrí Me, dùús domkas qgóó Mea hãa sa, naka si kò ma kúúga qãèkaguè sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Me bìrí si a máá: “Tiri si cóá seè, sari dtcòm̀a nea qãèkagu sia, ke tòókuan cgoa qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Qanegam Jeso ba téé a ko kg'ui kam kò c'ẽem khóè ba hàà, còrè-nquum dim tc'ãà-cookg'aim dim nquum koe guua ba, a bìrí me a máá: “Tsáá xuù sa ncãa x'óó, ke táá xgaa-xgaa-kg'ao ba xhõe-xhõe guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Igabam kò Jeso ba ẽe sam ko kóḿ ka Jairo ba bìrí a máá: “Táá q'áò guu, kg'amaga méé tsi dtcòm̀, qãès gha ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eẽm ko Jairom dim x'áém koe tcãà kam kò táá c'ẽe khóè ga guu i Gam cgoa nquum q'oo koe tcãà, Petere ba hẽé naka Johane ba hẽé naka Jakobo ba hẽé, naka cóás ka xõò ba hẽé naka xõò sa hẽéthẽé cúí ga a kò ii. ");
INSERT INTO nhr_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ne kò wèé ne khóè ne kg'ae, a ko cóá sa kg'ae cgae, Me Jeso ba máá: “Táá tu kg'ae guu, x'óó tamas hãa a sa a x'óm̀a hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ne kò wèéa ne kg'ãè Me, x'óóas hãa sa ne kò q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Igabam ko Jeso ba x'õàa sa koe qgóó si, a máá: “Tiri si cóá seè, tẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","I kg'õèa sa ka̱bise, si kúúga tẽe, Me Jeso ba máá, c'ẽe gúù méés máàè naka tc'õó, témé. ");
INSERT INTO nhr_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Khara kò gas ka xõò ga khara kaisase are. Me bìrí khara a, táá méé khara cúí khóè ga dùús kúrúsea sa bìrí guu sa. ");
INSERT INTO nhr_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Me kò Jeso ba 12 xu tciia xg'ae a ba a qarian máà xu, wèé dxãwa tc'ẽean xu gha xhàiagu, a wèé tcììan thẽé tsoò di i. ");
INSERT INTO nhr_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","A ba a tsééa tcg'òó xu, síí xu gha Nqarim di x'aian ka xgaa-xgaa, a xu a tsàako ne khóè ne kg'õèkagu ka. ");
INSERT INTO nhr_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A ba a bìrí xu a máá: “Táá méé xao qõò xao ko ka cúí gúù ga séè guu, dqàbi hìim ga igaba, dtcòbè ga igaba, péré ga igaba, mari ga igaba, kana cám̀ di qgáían ga igabaga. ");
INSERT INTO nhr_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Eẽ xao ko tcãàm nquu ba, ndakam ga igaba, gaam koe méé xao hãa naka nxãakg'aiga síí ẽem x'áé-dxoom koe tcg'oa. ");
INSERT INTO nhr_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","A ncẽè khóèan kò qãèse hààkagu xao o tama ne méé xao nqàrèa xao di tsharàn qãè-qãe, ẽe xao ko gaam x'áé-dxoom koe tcg'oa ne, nakas gha nxãasega gane koe x'áí sa ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xu xgaa-xgaase-kg'ao xu xgoaba a wèé xu x'áé xu koe qõòa te, a xu a ko qãè tchõàn xgaa-xgaa a ko wèé za ga khóèan kg'õèkagu. ");
INSERT INTO nhr_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Eẽm ko Galilea dim x'aigam Herote ba wèé zi gúù zi kúrúse ko zi ka kóḿ kam kò táá q'ãa. C'ẽe ne khóè nea kòo máá, Johanem tcguù-tcguu-kg'ao ba x'ooan koe tẽea, témé khama, ");
INSERT INTO nhr_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ne ko c'ẽe ne máá, Elija ba hòòsea, témé, ne ko c'ẽe ne máá, c'ẽe xu porofiti xu ncìí x'aè di xu ka c'ẽe ba x'ooan koe tẽea, témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Me Herote máá: “Johane bar kò q'ãe tcúúa hãa, ka ncẽe zi gúù zi gam kar ko kóḿ ba dìí baà?” témé. A ba a kò bóò mem gha sa tc'ẽe. ");
INSERT INTO nhr_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","X'áè úú-kg'ao xu kò ka̱bise a hàà wèé zi gúù zi ẽe xu kò kúrú zi ka bìrí Me. Me séè xu, xu Gam cgoa cúía síí hãa Betesaida ta ko ma tciièm x'áé-dxoom koe. ");
INSERT INTO nhr_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ncẽes gúù sa ne ko kóḿ kas kò xg'ae sa xùri Me, Me qãèse hààkagu ne, a ba a Nqarim di x'aian ka kg'ui cgoa ne, a ẽe kò ko kg'õèkagukuan qaa ne qãèkagu. ");
INSERT INTO nhr_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nxãaskas cáḿ sa tshoa-tshoa a ko dqòara qõò ka xu kò 12 xu xgaa-xgaase-kg'ao xu Gam koe hàà a máá: “Khóè ne qõòa q'aakagu, naka ne nxãasega nxa̱ma-nxa̱ma hãa xu x'áé xu koe hẽé naka xhárà xu koe hẽéthẽé síí, naka nea síí x'óm̀-q'ooan hẽé naka tc'õoan hẽéthẽé qaara mááse, cúía hãam qgáìm koe ta hãa ke” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Igabam kò bìrí xu a máá: “Gaxao c'ẽe gúùan máà ne naka ne tc'õó,” témé. Xu máá: “5 xu péré xu cúí xu xae úúa naka cám̀ x'aù tsara hẽéthẽé e, kana méé xae síí khóè ne wèé ne tc'õoan x'ámá máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","5,000 khama noo xu khóè xu kò ẽe koe hàna domka. Me kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Khóè ne bìrí naka ne wèés xg'aes koe 50 khama noose ntcõó,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Xu gataga hẽé, i wèé khóèan ntcõó. ");
INSERT INTO nhr_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Me Jeso ba 5 xu péré xu hẽé naka cám̀ x'aù tsara hẽéthẽé séè, a ba a nqarikg'ai koe ghùi-kg'ai, a ts'ee-ts'eekg'ai i, a péréan khõá q'aa, a xgaa-xgaase-kg'ao xu máà a, xu khóè ne q'aa-q'aa máá a. ");
INSERT INTO nhr_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ne kò wèéa ne ga tc'õó, a ne a xg'ãà, xu ẽe kò qaùan xg'ae-xg'ae a 12 xu q'ore xu tcãà, xu cg'oè. ");
INSERT INTO nhr_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Eẽm cúíse hãa a ko còrè ka xu xgaa-xgaase-kg'ao xu síí cgae Me. Me tẽè xu a máá: “Dìí Raà, ta zi ko xg'ae zi méé?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xu xo̱a Me a máá: “C'ẽe ne ko máá, Johane Tsi tcguù-tcguu-kg'ao Tsi i, témé, ne ko c'ẽe ne máá, Elija Tsi i, témé, ne ko c'ẽe ne qanega máá, ncìí kuri di Tsi porofiti Tsi i x'ooan koe tẽea Tsi, témé,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Me tẽè xu a máá: “Kháé xaoa ko gaxao máá, dìí Raa, témé?” Me Petere xo̱a a máá: “Ncẽe kò nqòòkaguèa hãa Tsi Kreste Tsi Nqarim di Tsi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Me Jeso ba qarika x'áè xu, táá xu gha ncẽes gúù sa cúí khóè ga bìrí sa. ");
INSERT INTO nhr_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A ba a máá: “Khóèm dim Cóá ba gha káí zi gúù zi koe xgàrase, a gha khóè ne di xu kaia xu hẽé, kaia xu peresiti xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu ka hẽéthẽé bóòa xguìè, a gha cg'õoè, a ba a gha nqoana dim cáḿ ka x'ooan koe tẽe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nxãaskam kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Ncẽè c'ẽem khóèm kò xùri Te kg'oana ne méém bóòa xguìse naka baa gam dim xgàu hìi ba dcẽé, naka xùri Te. ");
INSERT INTO nhr_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Dìím wèém ẽe gam dis kg'õè sa qgóóa qaria hãa bas gha aaguse cgae, igaba wèém ẽe ko Tíí domka gam dis kg'õès ka aaguse cgaeè ba gha hòò si khama. ");
INSERT INTO nhr_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dùús ka ba gha khóè ba ka̱bisea mááè, ncẽè wèém nqõó bam kòo hòò, a ba a gam dis kg'õès ka aaguse cgaeè ne, kana ba gha khóè ba dùútsa gúù sa gam di kg'õèan téé-q'oo koe tcg'òó a máà? ");
INSERT INTO nhr_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Dìím wèém ẽe ko Tíí hẽé naka Tiri kg'uian hẽéthẽé sau-cgaese ba gha thẽé Khóèm dim Cóám ka sau-cgaeseè, ẽem gha ko Gam di x'áàn koe hẽé naka Xõòm di x'áàn koe hẽé naka tcom-tcomsa xu moengele xu di x'áàn koe hẽéthẽé hãase ko hàà ne. ");
INSERT INTO nhr_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Igabar ko tseeguan bìrí tu u: Ncẽe koe téé-tẽe ne ka c'ẽea ne x'ooan xám̀a hãa tite, Nqarim di x'aia ne ne ko bóò i hàà tama cookg'ai koe,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Eẽm ko Jeso ba ncẽe zi gúù zi nxàea xg'ara kam kò 8 khama noo cáḿan qãá q'oo koe Peterea xu, Johanea xu, Jakoboa xu séè, a ba a xàbìm koe qõò cgoa xu a síí còrè. ");
INSERT INTO nhr_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eẽm hãa a ko còrè ka i kò kg'áía ba ka̱bise a tãá, i Gam di qgáían ka̱bise a tca̱àkose q'úú. ");
INSERT INTO nhr_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ka tsara ko kúúga cám̀ tsara khóè tsara kg'ui cgoa Me, Moshe ba hẽé naka Elija ba hẽéthẽé tsara, ");
INSERT INTO nhr_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ncẽe kò nqarikg'ai di x'áàn koe qhúí tsara, a ko Jesom cgoa kg'ui, a ko Gam di x'ooan hààko ka kg'ui, kháóa cgae ga ko Jerusalema koe kúrúse e. ");
INSERT INTO nhr_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Xu kò Petere ba hẽé naka gam ka c'ẽea tsara hẽéthẽé xu qarika x'óm̀a cg'áé. Eẽ xu ko kókò ka xu kò Gam dim x'áà ba bóò, naka gaa tsara khóè tsara hẽéthẽé e, ẽe ko Gam cgoa tẽe tsara. ");
INSERT INTO nhr_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eẽ tsara ko khóè tsara Jeso ba guu a ko qõò kam kò Petere ba bìrí Me a máá: “X'aigaè, tsóágase i gáé qãèa, ncẽe koe xae ga hãa sa! Nqoana xu nquu-coa xu xae gha tshào, me c'ẽe ba Tsari, me c'ẽe ba Moshem di, me c'ẽe ba Elijam di,” tam méé. (C'úùam ko hãa dùú sam ko kg'ui sa.) ");
INSERT INTO nhr_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Qanegam hãa a ko kg'ui kas kò túú-c'õò sa qàbia tcãà xu, a sa a gas di sóm̀an cgoa qàbi xu. Eẽ xu ko xgaa-xgaase-kg'ao xu túú-c'õòs koe tcãà ka xu kò q'áò. ");
INSERT INTO nhr_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Me kò kg'ui ba túú-c'õòs koe guu a máá: “Ncẽe ba Tirim Cóá Me e, nxárár tcg'òóa ba, ke komsana Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Eẽm ko kg'ui ba xg'ara kam kò Jeso ba cúíse hãa. Xu kò xgaa-xgaase-kg'ao xu ncẽes gúùs cgoa nqoo, a xu a gaa xu cáḿ xu ka táá cúí khóè ga bìrí dùú sa xu bóòa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Xùrikom cáḿ kam ko Jeso ba hẽé naka xgaa-xgaase-kg'ao xu hẽéthẽé xàbìm koe guu a ka̱bise, si kaias xg'ae sa Jesom cgoa xg'ae. ");
INSERT INTO nhr_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kam kò gaa x'aè kaga c'ẽem khóè ba ẽes xg'aes q'oo koe q'au a máá: “Xgaa-xgaa-kg'ao Tseè, dtcàrà Tsir ko Tsi tirim cóá ba bóò, nooam cóám ga me e khama. ");
INSERT INTO nhr_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Dxãwa tc'ẽean kòo tcãà cgae me ne i ko kúúga q'aukagu me, a qgaè-kg'aikagu me, a kg'áḿa ba koe xùbúan tcg'òókagu me, a ko khõá tòm̀-tom me, a qháése guu me tama. ");
INSERT INTO nhr_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ra kò Tsari xu xgaa-xgaase-kg'ao xu dtcàrà, xhàia xu gha guu u ka, igaba xu kò tààè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Me Jeso ba xo̱a a máá: “Oo, tsóágase dtcòm̀ úú tamas qhàò sa gáé ncẽe sa! Nta noo x'aèa ne Ra gha gaxao cgoa hãa a qáò-tcaoa máá tu u? Tsarim cóá ba ncẽe koe óá!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Cóám ko hàà koe ga i ko dxãwa tc'ẽean góḿankg'ai koe xàbùa qáú me, a i a qgaè-qgae-kg'ai me. Kam ko nxãaska Jeso ba dxãwa tc'ẽean dqàè, a cóá ba qãèkagu, a ba a xõò ba máà me. ");
INSERT INTO nhr_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ne kò wèé ne khóè ne Nqarim di kaian ka area. Eẽ ne wèéa ne qanega ẽem Jeso ba kúrúa zi gúù zi wèé zi ka area kam kò Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: ");
INSERT INTO nhr_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Qãèse dxãà tcee ncẽer ko bìrí xao o kg'uia ne: Khóèm dim Cóá ba gha hàà khóè ne tshàu q'oo koe tcãàè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Igaba xu kò ẽem ko méé sa táá kóḿa q'ãa, gaxu koe i kò chóm̀sea, táá xu gha kóḿa q'ãa a ka khama. A xu a kò ẽe kg'uia ne ko dùú sa méé sa tẽèan bèe. ");
INSERT INTO nhr_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Si kò gaxu xg'aeku koe ntcoeku sa tẽe, dìína gaxu xg'aeku koe kaia hãa di sa. ");
INSERT INTO nhr_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Igabam kò Jeso ba tcáóa xu q'oo koe xu tc'ẽea hãa sa q'anaa, khamam kò cg'árém cóá ba séè, a Gam qàe koe tòó, ");
INSERT INTO nhr_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","a ba a bìrí xu a máá: “Dìím wèém ẽe ko ncẽem cóá ba Tiri cg'õèan koe qãèse hààkagu ba ko Tíí tc'áró ga qãèse hààkagu. Me ko dìím wèém ẽe ko Tíía qãèse hààkagu Te ba ẽe tséé Tea ba qãèse hààkagu. Eẽ gaxao koe kaisase cg'áré ba gaxao ka kaiam ga me e khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Me Johane xo̱a a máá: “Kaia Tseè, c'ẽem khóè ba xae kò bóò me ko Tsari cg'õèan cgoa dxãwa tc'ẽean xhàiagu, xae kò sixae ka c'ẽem tama me e domka gatà hẽéan cara me,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Igabam kò Jeso ba gam ka máá: “Táá cara me guu, ẽe gaxao cgoa ntcoeku tama ba gaxao xòè koe hàna ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Eẽm ko Jeso ba nqarikg'ai koe séè a úúèm x'aèm ko cúù kam kò bìríse a Jerusalema koe qõò. ");
INSERT INTO nhr_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","A ba a tséé-kg'ao xu tc'ãà a tsééa tcg'òó. Xu Samaria ne dim x'áé-coam koe síí tcãà, gúù zi xu gha kg'ónòa máá Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Igaba ne kò gaa koe hãa ne khóè ne táá qãèse hààkagu Me, Jerusalema koem kò úú-kg'aia khama. ");
INSERT INTO nhr_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Eẽ tsara ko xgaa-xgaase-kg'ao tsara Jakoboa tsara Johanea tsara ncẽes gúù sa bóò ka tsara ko máá: “X'aigaè, nqarikg'ai koe guuam c'ee ba tsam gha tcii, me hàà cg'õo ne sa Tsi ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Me Jeso ba ntcẽè a dqàè tsara a. ");
INSERT INTO nhr_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Xu kò Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé xu c'ẽem x'áém koe qõò. ");
INSERT INTO nhr_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eẽ xu dàòm q'oo koe hãa a ko qõò kam ko c'ẽem khóè ba bìrí Me a máá: “Eẽ Tsi ko síí qgáì wèé koer gha xùri Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Me Jeso ba xo̱a me a máá: “Círí nea gaan di ha̱éan úúa, i tsa̱rán gaan di nquuan úúa, igabagam Khóèm dim Cóá ba tòó tcúúm gha qgáì úú tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Me kò Jeso ba c'ẽem khóè ba bìrí a máá: “Xùri te,” témé. Igabam ko gaam khóè ba máá: “X'aigaè, kg'aia qãà te nakar síí tirim xõò ba kg'ónò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Me Jeso ba bìrí me a máá: “Eẽ x'óóa hãa ne guu naka ne gane dian ẽe x'óóa hãa kg'ónò, igaba tsáá qõò naka tsia síí Nqarim di x'aian ka xgaa-xgaa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Me kò c'ẽem khóè ba gataga máá: “Xùri Tsir gha, X'aigaè, igaba qãà te nakar kg'aia síí x'áéa te di ne khóè ne x'áè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Me Jeso ba xo̱a me a máá: “Eẽm tshoa-tshoa a ko xhárà koe gha ka̱bise a kháóka bóòm khóè ba Nqarim di x'aian kg'ano tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ncẽe zi gúù zi qãá q'oo koem kò X'aigam Nqari ba 72 xu khóè xu nxárá tcg'òó, a ba a cám̀-cám̀se tsééa tcg'òó xu, tc'ãà xu gha a ẽem ko hàà Gabá qõò xu x'áé-dxoo xu koe hẽé naka qgáì zi koe hẽéthẽé qõò ka. ");
INSERT INTO nhr_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A ba a bìrí xu a máá: “Tcuùè gha gúùa ne káí i, igaba i tséé-kg'aoan cg'orò o. Ke xao Nqarim ncẽe tcuùs dim X'aiga ba dtcàrà nakam tséé-kg'aoan tsééa óá naka i hàà tcuù. ");
INSERT INTO nhr_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Qõò xao. Igaba bóò, Tíí Ra ko ghùu-coan khama ma ncuutshaan xg'aeku koe tsééa úú xao o sa. ");
INSERT INTO nhr_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Táá méé xao qgóá ga kana dtcòbèan ga kana nxàboan ga igaba séè guu, naka táá cúí khóè ga dàòan q'oo koe tsgám̀ guu. ");
INSERT INTO nhr_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Nquum ẽe xao ga ko gaam q'oo koe tcãà ba, ndakam ga igaba, méé xao kg'aia máá: ‘Tòókuan méé i ncẽem nquum cgoa hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tòókuan dim khóèm kò gaam nquum q'oo koe x'ãèa ne i gha gaxao di tòókuan gam cgoa hãa. Eẽta i kò ii tama ne i gha gaxao di tòókuan ka̱bise cgae xao o. ");
INSERT INTO nhr_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Eẽm nquum koe méé xao hãa, naka xaoa wèés tc'õos ẽe ne ko máà xao o sa tc'õó naka kg'áà, tséé-kg'ao ba gam di tsééan di surutan ka kg'anoèa hãa ke. Táá méé xao nquu xu koe kg'ama qõòa te guu. ");
INSERT INTO nhr_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“X'áé-dxoom ẽe xao ga ko tcãàm koe, ndakam ga igaba, ne ko qãèse séè xao o ne méé xao ẽe ko cookg'aia xao koe tòóès wèé sa kg'ama tc'õó. ");
INSERT INTO nhr_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tsàako ne méé xao kg'õèkagu, naka xaoa khóè ne bìrí naka máá: ‘Nqarim di x'aia nea cúù cgae tua,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Igaba x'áé-dxoom wèém ẽe xao ko tcãàm koe ne kò khóè ne qãèse séè xao o tama ne méé xao x'áéan xg'aeku koe tcãà naka máá: ");
INSERT INTO nhr_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gatu dim x'áé-dxoom di tsharà a ncẽe nqàrèa xae koe hãa a, xae ko qãè-qãe cgae tu u, igaba méé tu q'ana, Nqarim di x'aia nea cúù cgae tua sa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Bìrí xao or ko, xgàrakuan dim cáḿ kam gha ncẽem x'áé-dxoo ba Sodomam ka kaisa xgàrakuan hòò. ");
INSERT INTO nhr_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Cg'ãè i gha ii tsáá ka Korasineè! Cg'ãè i gha ii tsáá ka Betesaidaè! Are-aresa zi x'áí zi ncẽe ko gatu koe kúrúèa zi kò Ture hẽé naka Sitone hẽéthẽé koe kúrúèa hãa ne ne ga kò ncìíse gane di chìbian koe tcóósea, a saka di qgáían hã̱a, a tháúan tcgáùsea hãa. ");
INSERT INTO nhr_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Igabar ko bìrí tu u a ko máá: Xgàrakuan dim cáḿ ka i gha Ture hẽé naka Sitone hẽéthẽé gatu ka subuse xgàraè, témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“A ncẽe tsáá ka, Kaperenaume tseè, nqarikg'ai koe tsi gha ghùi a úúè, ta tsi gáé tc'ẽea? Nqãaka tsi gha xòóè, x'óóa ne khóè ne dim qgáìm koe. ");
INSERT INTO nhr_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Me Jeso ba nxãaska Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Wèém ẽe ko gaxaoa komsana xao o ba ko Tíía komsana Te, me ko gataga ẽe ko xguì xao o ba Tíí ga Ra xguì. Me ko ẽe ko Tíía xguì Te ba ẽe tsééa óága Tea ba xguì,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xu gaxu khóè xu 72 xu qãè-tcaoase ka̱bise a máá: “X'aigaè, dxãwa tc'ẽean igaba i ko komsana xae e, Tsari cg'õèan cgoa xae kò ko dqàè e ne,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Me xo̱a xu a máá: “Satana bar kò bóòa me kò túú-tebem khama ma nqarikg'ai koe guu a ko tcheè. ");
INSERT INTO nhr_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Bóò, qaria ner máà xaoa, cg'aoan hẽé naka xg'árìan hẽéthẽé xao gha náà cgoa di i. A Ra a gataga qarian máà xaoa hãa, dxãwam gaxao dim cg'õo-kg'aom di qarian wèé xao gha tàà cgoa a. I cuiskaga cúí gúù ga thõò-thõo xaoa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cg'ãè tc'ẽean ko komsana xao o domka méé xao táá qãè-tcao guu, igaba méé xao gaxao di cg'õèa nea nqarikg'ai koe góáèa domka qãè-tcao,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Eẽm x'aèm kam kò Jeso ba Tcom-tcomsam Tc'ẽem di qãè-tcaoan ka cg'oè cgaeèa, a máá: “Dqo̱m̀ Tsir ko, Aboè, X'aiga Tsi nqarikg'ai hẽé naka nqõómkg'ai hẽéthẽé di Tsi, ncẽe zi gúù zi Tsi kò tc'ẽega ne hẽé naka xgaa-xgaasea hãa ne hẽéthẽé chóm̀-kg'aia hãa, a Tsi a kò cg'áré ne cóá ne x'áí zia hãa khama. Eè, Aboè, ncẽea Tsi kò ma ncàm̀a hãa ga a khama. ");
INSERT INTO nhr_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Wèé zi gúù zi Ra Tirim Abom ka máàèa, i cúí khóè ga Cóám dìí ii sa c'úùa hãa, Xõòm oose, kana i cúí khóè ga Xõòm dìí ii sa c'úùa hãa, Cóásem oose, naka wèém ẽe Cóám ka nxárá tcg'òóèa ba hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Me Jeso ba Gam di xu xgaa-xgaase-kg'ao xu koe ka̱bise a dxùukg'ai za bìrí xu a máá: “Ts'ee-ts'eekg'aièa ia tcgáían ẽe ko gaxao ko bóò zi gúù zi bóò o, ");
INSERT INTO nhr_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","bìrí xao or ko khama, káí porofitian hẽé naka x'aiga xu hẽéthẽéa kò bóò kg'oana ẽe xao ko gaxao bóò sa, igaba i kò táá bóò si; a kò kóḿ kg'oana ẽe xao ko gaxao kóḿ sa, igaba i kò táá kóḿ si,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Me kò gaa x'aè kaga c'ẽem x'áè q'ãa-kg'ao ba tẽe a Jeso bam kúrúa bóò kg'oana khama máá: “Xgaa-xgaa-kg'ao Tseè, dùú sa ra gha kúrú a chõò tamas kg'õè sa hòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Me Jeso ba tẽè me a máá: “Dùú sa Moshem di x'áèan koe góáèa? Nta tsi ko ma kóḿa q'ãa a?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Me gaam khóè ba xo̱a Me a máá: “X'aigam tsarim Nqari ba méé tsi wèé tcáóa tsi cgoa hẽé, naka wèé kg'õèa tsi cgoa hẽé, naka wèé qaria tsi cgoa hẽé, naka wèé tc'ẽea tsi cgoa hẽéthẽé ncàm̀, naka tsia gataga thẽé ẽe tsi ma ncàm̀sea hãa khamaga ma tsáá ka c'ẽe ba ncàm̀,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Me bìrí me a máá: “Qãèse tsi xo̱ara hãa. Kúrú ncẽe gúùa ne naka tsia gha kg'õèan hòò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Igabam kò gabá tchànom iise bóòè kg'oana khamam kò Jeso ba tẽè a máá: “Kháé tíí ka c'ẽe ba dìí ba?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Me Jeso ba xo̱a me a máá: “C'ẽem khóè ba kò Jerusalema koe guu a ko Jeriko koe qõò, a ba a kò ts'ãà-kg'ao xu cgoa qõòa xg'ae, xu qgáía ba xhùu me, a xg'áḿa cg'õos q'oo koe xg'áḿ me, a xu a guu me a qõò. ");
INSERT INTO nhr_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“I kò kúrúse me c'ẽem peresiti ba c'úùase ko gaam dàòm cgoa hàà. Eẽm ko gaam khóè ba bóò kam kò nxãa a c'ẽe xòèan dàòm di séè a nqáé. ");
INSERT INTO nhr_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","“Me kò gatà thẽé tempelem koe ko hùim khóè ba gaam qgáìm koe hàà, a ẽem ko gaam khóè ba bóò ka gaam caum cúím cgoaga nxãa a c'ẽem xòèm dàòm di ba séè a nqáé. ");
INSERT INTO nhr_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Igabam kò Samaria dim khóèm c'ẽe ba gaam dàòm ga ba séè a ko qõò, a gaam khóè ba hàà sao-xg'ae. A ẽem ko bóò me ka thõò-xama máá me, ");
INSERT INTO nhr_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","a ba a síí cgae me a gaa zi chìbi zi nxúìan hẽé naka gõéan hẽéthẽé ka ntcã̱á cgae a tcáḿ zi, a ba a gam dim donghim koe qábìkagu me, a cg'áè-nquum koe úú me, a ba a síí gaa koe q'õé me. ");
INSERT INTO nhr_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","“Eẽ i ko q'uu kam kò qano mari tsara tcg'òó a cg'áè-nquu-kg'ao ba máà, a máá: ‘Q'õé me, kháóar ko síí ka̱bise ner gha wèé gúùan ẽe tsi tsééa máá mea koe hàà suruta tsi ke,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Me Jeso ba tẽè me a máá: “Ts'ãà-kg'ao xu ka xg'áḿmèam khóè ba kò hàà cgae xu khóè xu nqoana xu ka tsi ko ntama ma tc'ẽe? Gam ka c'ẽem iise séè mea ba ndaka baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Me máá: “Eẽ thõò-xama máá mea me e,” témé. Kam ko Jeso ba bìrí me a máá: “Qõò naka tsia síí gatà hẽé thẽé,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽéa ko dàòm koe hàna a ko qõò kam kò c'ẽem x'áé-coam koe hàà, si kò Mareta ta ko ma tciiès khóè sa gas dim nquum koe qãèse hààkagu Me. ");
INSERT INTO nhr_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mareta sa kò qõe sa úúa Maria ta ko ma tciiè sa. Si kò Maria X'aigam Jesom nqàrè-kg'am koe ntcõóa-ntcõe, a ko Gam di zi xgaa-xgaa zi komsana. ");
INSERT INTO nhr_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Igabagas kò Mareta sa káí tsééan ka xáèèa, khamas kò Jesom koe hàà a máá: “X'aigaè, tíí qões ka Tsi gáé c'ẽe gúù méé ta ga hãa? Guu tes ko ra ko cúísega tsééa máá tu u ka. Bìrí si nakas hàà hùi te,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Me X'aigam Nqari ba xo̱a si a máá: “Maretaè, Maretaè, káí zi gúù zi ka si ko tc'ẽe-tc'ẽese a ko xhõe-xhõese, ");
INSERT INTO nhr_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","igabas ko cúís gúù sa qaase, si Maria sa qãès gúù sa nxárá tcg'òóa máásea hãa, si ncẽes gúù sa gas koe séèa ka̱biè tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","C'ẽem cáḿ kam kò Jeso ba c'ẽem qgáìm koe hãa a ko còrè. Eẽm ko còrèa xg'ara kam kò Gam di xu xgaa-xgaase-kg'ao xu ka c'ẽe ba bìrí Me a máá: “X'aigaè, xgaa-xgaa xae e còrèa ne, ẽem ko ma gataga Johane gam di xu xgaa-xgaase-kg'ao xu ma xgaa-xgaa a khamaga ma,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Me Jeso ba bìrí xu a máá: “Còrè xao kò ne méé xao máá: ‘Sita ka Xõò Tseè, Tsari cg'õèan méé i dqo̱m̀mè. Tsari x'aian méé i hàà. ");
INSERT INTO nhr_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sita dis tc'õos wèé cáḿ di sa wèé cáḿ ka máà ta a. ");
INSERT INTO nhr_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Naka qgóóa máá ta a chìbia ta, sita igaba ta ko wèém ẽe sita koe chìbian kúrúa hãa ba qgóóa máá ke. Naka Tsia táá kúrúa bóòkuan koe tcéèa úú ta a guu,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Me gaa koe guus ka Jeso ba bìrí xu a máá: “C'ẽem-kg'áḿ kam gaxao ka c'ẽe ba tcárà ba úúa, a ba a ntcùú nqáè ka síí cgae me, a bìrí me a máá: ‘Tíí tcáràè, nqoana xu péré xu cgóbè te, ");
INSERT INTO nhr_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","tíí tcáràm dàò koe hàna ba ncãa hàà cgae te, ra cúí gúù ga úú tama máà mer gham tc'õó o ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Me nxãaska ẽe nquum q'oo koe hàna ba xo̱a a máá: ‘Táá xhõekagu te guu, nquu-kg'áḿ ba tcẽekg'amsea, ra x'óm̀a cóáa te cgoa, khama ra cuiskaga tẽe naka máà tsi xua hãa tite ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bìrí xao or ko, tẽem gha a tcg'òó xu, gam dim tcárà me e domka. Nxãa tama ko ii nem gha tẽe a ẽem dtcàràèa hãa sa kúrú, gam dim tcárà ba kò saucgae tamase téé-kg'am me a dtcàrà me si khama. ");
INSERT INTO nhr_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ra ko bìrí tu u a ko máá: Dtcàrà tu, máàè tu gha ke, qaa tu, hòò tu gha ke, nquu-kg'áḿ ba tu xg'áḿ-xg'am, xgobekg'ama tu gha mááè ke. ");
INSERT INTO nhr_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Dìím wèém ẽe ko dtcàrà ba ko máàè, me ko wèém ẽe ko qaa ba hòò, me gha wèém ẽe ko nquu-kg'áḿ ba xg'áḿ-xg'am ba xgobekg'ama mááè khama. ");
INSERT INTO nhr_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ndakam xõò ba gha gam dim cóám kòo x'aù ba dtcàrà me ne, x'aùm téé-q'oo koe cg'ao ba máà me? ");
INSERT INTO nhr_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kana xg'árì ba máà me, tc'ubi bam kò dtcàrà me koe? Káà me e. ");
INSERT INTO nhr_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","A ncẽè gatu ncẽe cg'ãè tc'ẽe ii tu kò qãè aban gatu di cóán máà q'ana hãa ne ba gha nxãaska gatá ka Xõòm nqarikg'ai di ba ẽe ko dtcàrà Me ne nta noose nqáéa hãase Tcom-tcomsam Tc'ẽe ba máà?” tam ma tẽè. ");
INSERT INTO nhr_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jeso ba kò nqóbóm khóèm koe dxãwa tc'ẽean xhàiagu. Eẽ i ko dxãwa tc'ẽean tcg'oa kam kò gaam khóèm ẽe kò kg'ui tama ba kg'ui, zi xg'ae zi gaa koe kò hàna zi kaisase are. ");
INSERT INTO nhr_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Igaba ne kò c'ẽe ne máá: “Dxãwa tc'ẽean dim x'aigam Belesebulem di qarian cgoam ko dxãwa tc'ẽean xhàiagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne c'ẽe ne qgóó Me ne gha qgáìan qaa ka dtcàrà Me, are-aresas x'áís nqarikg'ai di sam gha x'áí ne sa. ");
INSERT INTO nhr_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jeso ba kò gane di tc'ẽean q'ana khamam kò bìrí ne a máá: “Eẽ q'aara hãas x'ais wèé sa gha kaà, me ẽe q'aa-q'aasea hãam x'áé ba gaicara hãa tite. ");
INSERT INTO nhr_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A ncẽè satanam kò gaam ka q'aara hãa ne i gha kháé nxãaska ntama x'aian hãa? Ncẽè gatu ko máá, Belesebule ba qarian máà Tea ra ko dxãwa tc'ẽean gaan cgoa xhàiagu, témé ne. ");
INSERT INTO nhr_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","A ncẽè Tíí kòo Belesebulem di qarian cgoa dxãwa tc'ẽean xhàiagu, ne ia ko gatu di khóèan dìím cgoa xhàiagu u? Gaa domkaga ne gha gaxao di ne khóè ne x'áí, ẽe xao ko kg'ui sa tseegu tama sa. ");
INSERT INTO nhr_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Igaba ncẽè Tíí kò ko dxãwa tc'ẽean Nqarim dim tshàum cgoa xhàiagu, nes ko nxãa sa x'áí, Nqarim di x'aia nea gatu koe hààraa sa. ");
INSERT INTO nhr_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ncẽè qarim khóèm ncõo gàba zi úúam kò ko gam dim nquu ba kòre ne i ko gam di gúùan qãè qgáì koe hãa. ");
INSERT INTO nhr_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Igaba qarian ka tàà meam káí zi ncõo gàba zi dim kò ko hàà a ko x'ãà me nem ko tàà me, a gam di zi ncõo gàba zi ẽem kò dtcãàsea hãa zi xhùu me, a ba a ẽem ko séè cgae mea zi gúù zi q'aa-q'aa. ");
INSERT INTO nhr_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Eẽ Tíí cgoa hãa tama ba, Tíí cgoa tééa q'aumanakua, me gataga ẽem Tíí cgoa xg'ae-xg'ae tama ba ko tsa̱i-tsa̱ia q'aa. ");
INSERT INTO nhr_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Eẽ i ko dxãwa tc'ẽean khóèm koe tcg'oa ne i ko c'óòa qgáìan koe qõò, a sãa i gha qgáìan qaa, a ncẽè hòò o tama i kò hãa ne i ko nxãaska bìríse a máá: ‘Tirim nquum ẽer guua hãam koer gha ka̱bise,’ témé, ");
INSERT INTO nhr_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","a ẽe i kò hàà nquu ba bóò me káà gúù ii, a xgàia q'ano-q'anoèa, a qãèse kg'ónòèa, ");
INSERT INTO nhr_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ne i ko nxãaska qõò a síí 7 tc'ẽean séè a hàà cgoa, gaan nqáéase cg'ãè e, i hàà tcãà a i a gaa koe x'ãè. Si ẽem khóèm dis téé-q'oo sa hàà kaisase cg'ãè kg'aiaka dis ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Eẽm ko Jeso ba ncẽeta mééa xg'ara kas ko khóè sa xg'aes q'oo koe guu a q'aua kg'ui a Jeso ba bìrí a máá: “Ts'ee-ts'eekg'aièa saa khóès ẽe ábà Tsia sa, naka bíìan ẽe Tsi coma hãa hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Me Jeso ba xo̱a si a máá: “Tseegukaga, igaba ẽe Nqarim di kg'uian ko kóḿ a ko ẽe i ko méé khama hẽé nea kaisase ts'ee-ts'eekg'aièa ne ne e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eẽ zi ko khóè ne di zi xg'ae zi càùse kam ko Jeso ba tshoa-tshoa a máá: “Ncẽes qhàò sa cg'ãè cau si i, a ko are-aresas x'áí sa qaa. Igabas cúís x'áís ga sa x'áíèa hãa tite, Jonam dis x'áís cúís oose. ");
INSERT INTO nhr_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Eẽm xg'ao ma Jona ma Ninefe di ne khóè ne koe ma x'áí sa ii, khamagam gha ma khóèm dim Cóá ba ma ncẽes qhàòs koe x'áí sa ii khama. ");
INSERT INTO nhr_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","X'aigas Sheba di sa gha xgàrakuan dim cáḿ ka ncẽes qhàòs di khóèan cgoa tẽe a téé, a gha chìbi-chibi a xgàra si, nqõóm chõò-q'oo koes kò guu a ko hàà Solomonem di tc'ẽegan komsana khama. Igaba bóò, Solomonem ka kaia hãa ba ncẽeska ncẽe koe hàna. ");
INSERT INTO nhr_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Xgàrakuan dim cáḿ ka xu gha khóè xu Ninefe di xu tẽe a téé, a gha ncẽes qhàò sa chìbi-chibi a xgàra. Jonam di xgaa-xgaan koe xu kò guu a gaxu di chìbian koe tcóóse khama. Me ncẽeska Jonam ka kaia hãa ba ncẽe koe hàna,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A ba a máá: “X'áà-x'aa-kg'ai cgoa dis gúù sa ga dàò a gàbas cgoa xoaba-kg'ai si ba káà me e, kana gàbas ka nqãaka tòó si ba, igabam gha téé-q'ooa sa koe tòó si, ne gha nxãasega ẽe ko nquum q'oo koe tcãà ne x'áàn hòò. ");
INSERT INTO nhr_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tsarim tcgáí ba tsarim tc'áróm dim x'áà me e. Tsarim tcgáím kò qãè e, nem wèém tc'áróm tsari ba x'áàn ka cg'oèa. ");
INSERT INTO nhr_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Gaa domka méé tsi bóò naka i tsáá koe hàna x'áàn táá ntcùú sa ii guu. ");
INSERT INTO nhr_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Khama nxãaska ncẽè wèé cgáé-q'ooa tsi kò x'áàn ka cg'oè cgaea, i cúí xòèa tsi ga ntcùús q'oo koe hãa tama, nem wèém cgáé-q'oo ba x'áàn úúa, ncẽes ko ma x'áà-x'aa-kg'ai cgoa dis gúù sa ma tsáá koe ma kaisase ma x'áà khamaga ma,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Eẽm ko Jeso ba kg'uia xg'ara kam ko c'ẽem Farasai ba dtcàrà Me, síím gha tc'õó cgoa me ka. Me kò Jeso ba tcãà a síí tafolem koe ntcõó cgoa me, tc'õó cgoa mem gha ka. ");
INSERT INTO nhr_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Igaba ẽem ko Farasai ba bóòa q'ãa, Jesom ko xg'aà tshàu tamase tc'õó sa kam kò are. ");
INSERT INTO nhr_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Me X'aigam Jeso ba bìrí me a máá: “Gaxao Farasai xao ko kubi zi hẽé naka gàba zi hẽéthẽé zi ka qãá zi xg'aà, igabaga xao q'ooa xao koe xhùuku sa hẽé naka cg'ãè cauan hẽéthẽé ka cg'oè cgaeèa. ");
INSERT INTO nhr_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gaxao káà tc'ẽe xaoè, ẽe qãá sa kúrúa ba gáé gam q'ooa sa thẽé kúrúa hãam tama baà? ");
INSERT INTO nhr_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Igaba dùús wèés gàbas q'oo koe hàna sa ẽe dxàua ne khóè ne máà, naka xaoa gha nxãasega tchàa za hẽé naka q'oo za hẽéthẽé q'ano ii. ");
INSERT INTO nhr_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Haò, cg'ãè i gha ii gaxao Farasai xao ka! Nqari ba xao ko tc'õoan ko xg'ãò-xg'ão zi gúù zi koe cúís tshàu-q'oos dian tcg'òó a máà khama, wèé zi tc'õo-kg'áḿ zi xháràn di zi koe hẽéthẽé e. Igabaga xao ko Gam di qãèse qgóókuan hẽé naka ncàm̀kuan hẽéthẽé nxorè. Qaase i ko, ncẽe sara gúù sara cgáé sara xao ga kò kúrúa hãa sa, igaba méé xao táá c'ẽe zi nxorè guu. ");
INSERT INTO nhr_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Haò, cg'ãè i gha ii gaxao Farasai xao koe! Còrè-nquuan koe xao kaia zi ntcõó-q'oo zi ncàm̀a hãa, naka x'ámágu di zi qgáì zi koe tsgám̀ku sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Haò, cg'ãè i gha ii gaxao koe, x'áíse tama zi tc'ám̀ zi khama xao ii, ncẽe khóèan ko kg'ama tc'amkg'aia zi koe, bóòa q'ãa zi tamase gãá zi,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Me kò x'áè q'ãa-kg'aom c'ẽe ba xo̱a Me a máá: “Xgaa-xgaa-kg'ao Tseè, ẽeta Tsi kòo méé ne Tsi ko sixae igaba cóè xae e thẽé,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Me Jeso ba xo̱a me a máá: “Gaxao x'áè q'ãa-kg'ao xao igaba: Haò, cg'ãè i gha ii gaxao koe, qóḿse xao ko khóèan qóḿ gúùan dcẽékagu, igaba xao gaxao cúím tshàum gaxao dim kaga qgóó o tama. ");
INSERT INTO nhr_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Haò, cg'ãè i gha ii gatu koe. Porofiti xu di zi tc'ám̀ zi koe tu kò dqo̱m̀ cgoaè xu gha zi gúù zi tshàoa tòó, ncẽe gatu ka tsgõose ga xu ka cg'õoèa xu. ");
INSERT INTO nhr_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ncẽes gúù sa xao ko nxàea tseegukagu, gaxao ka tsgõose ga xu kúrúa hãa tsééa ne. Porofiti xu xu kò cg'õo khama, xao kò gaxu di tc'ám̀an tshào. ");
INSERT INTO nhr_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ncẽes gúùs domkam kò Nqari ba Gam di tc'ẽegan koe máá: “Porofiti xu hẽé naka x'áè úú-kg'ao xu hẽéthẽér gha gane koe tsééa úú, ne gha c'ẽe-kg'áía xu cg'õo, a c'ẽea xu xgàra. ");
INSERT INTO nhr_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Gaa domkas gha ncẽes qhàò sa nqõóm tshoa-tshoasea koe guu a ntcã̱àguèa c'áòan wèé xu porofiti xu di xo̱ara máá, ");
INSERT INTO nhr_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abelem di c'áòan koe guu a síí Sakariam dian koe tcãà. Sakariam ncẽe kò altara ba hẽé naka còrè-nquu ba hẽéthẽé xg'aeku koe cg'õoè ba. Eè, bìrí tu ur ko, qhàòs ncẽe sa gha wèéan ncẽe ga xo̱ara máá. ");
INSERT INTO nhr_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Haò, cg'ãè i gha ii gaxao x'áè q'ãa-kg'ao xao koe, q'ãan di tc'ẽean dim xgobekg'am ba xao séèa máásea. Gaxaoa kò gaxao ka táá tcãà, a xao a kò ẽe ko tcãà ne xgáè-kg'am,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Eẽm ko Jeso ba ẽem qgáìm koe tcg'oa a ko qõò ka xu kò x'áè xgaa-xgaa-kg'ao xu hẽé naka Farasai xu hẽéthẽé xu tshoa-tshoa a xgáèa tòó Me, a káí zi tẽè-kg'áḿ zi qaa tcáó Me ko zi tẽè Me, ");
INSERT INTO nhr_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nxãasegam gha tshúù gúùan kg'ui xu chìbi-chibi Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gaa koes kò kaias xg'aes tcám̀-tcám̀s khóè ne di sa xg'aea hãa, ne kò xáèkua hãa i kòm̀ ga káà a, kam kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu cgoa tc'ãà a tshoa-tshoa a máá: “Farasai xu di péré gãé-gãean koe méé xao q'õésea hãa, ncẽe qãè khóèan khama ko ma kúrúse igaba cg'ãè cau xu. ");
INSERT INTO nhr_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wèés gúùs ẽe chóm̀sea hãa sa gha xgòre-kg'aiè, si gha wèés tchõàs ẽe chóm̀sea hãa sa q'ãase. ");
INSERT INTO nhr_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Eẽ xao ko ntcùúan q'oo koe kg'ui sa gha x'áàn q'oo koe kóḿse, si gha gataga ẽe xao kòo nquuan q'oo koe c'am̀ sa thẽé nquuan tco̱be koe nxàese. ");
INSERT INTO nhr_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Tíí ka c'ẽea tuè, bìrí tu ur ko, a ko máá: Táá khóè ne ẽe ko tc'áró ba cg'õo, a ne a gaa koe guus ka kúrú ne gha gúù úú tama ne q'áò guu. ");
INSERT INTO nhr_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Igabar gha bìrí tu u dìí ba méé tu q'áò sa: Nqarim ẽem kòo cg'õoa xg'ara ne ko chõò tamas c'ees dxãwam dis koe xaoa úú di qarian úúa hãa ba méé tu q'áò. Eè, bìrí tu ur ko, q'áò Me méé tu! ");
INSERT INTO nhr_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A 5 tsa̱rá zia gáé mari-coa tsara cgoa x'ámáguè tama? Igabas cúís ga sa Nqarim ka c'urùèa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","I gataga wèé c'õòan tcúúa tu di ga nxáráèa. Ke táá q'áò guu, káí zi tsa̱rá zi ka tu kaisase cgáé tu u ke. ");
INSERT INTO nhr_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Bìrí tu ur ko a ko máá: Dìím wèém ẽe gha khóè ne cookg'ai koe Tíí ka nxàese bam gha Khóèm dim Cóá ba thẽé Nqarim di xu moengele xu cookg'ai koe nxàea tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Igaba dìím wèém ẽe gha khóè ne cookg'ai koe xo̱ase Te ba gha Nqarim di xu moengele xu cookg'ai koe xo̱aseè. ");
INSERT INTO nhr_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Me gha wèém khóèm ẽe ko Khóèm dim Cóám ka cg'ãèse kg'ui ba qgóóa mááè, igaba ẽe gha Tcom-tcomsam Tc'ẽem ka cg'ãè kg'uian kg'ui ba cuiskaga qgóóa mááèa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Igaba ẽe ne kòo còrè-nquu xu koe hẽé naka x'áèan di xu kaia xu koe hẽé naka tc'ãà-cookg'ai xu koe hẽéthẽé xo̱ara máásean ka tcãà tu u, ne méé tu táá káíse tc'ẽe-tc'ẽese guu, dùú sa tu gha nxàe sa, kana nta tu gha ma nxàe e sa, ncẽem x'aèm kòo hàà ne tu gha nxàe tu gha sa máàè ke, ");
INSERT INTO nhr_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Tcom-tcomsam Tc'ẽe ba gha ẽem x'aèm ka xgaa-xgaa tu u, dùú sa méé tu nxàe sa ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","C'ẽem khóè ba kò ẽes xg'aes q'oo koe guu a Jeso ba bìrí a máá: “Xgaa-xgaa-kg'ao Tseè, tíí kíím cgoa kg'ui nakam sitsam ka xõòm x'óóa guua zi gúù zi tíí cgoa q'aa-q'aaku,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Igabam kò Jeso ba xo̱a me a máá: “Khóè tseè, dìí na qarian máà Tea, gúùa ner gha q'aa-q'aa tsao o di i?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Me Jeso ba bìrí ne a máá: “Bóò naka tua chìikuan koe q'õése, khóèm dis kg'õè sa gúù zi káí zi ẽem kàoa hãa zi koe hãa tama ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","A ba a ncẽes sere-sere sa bìrí ne a máá: “C'ẽem khóèm qguùa kò hãa ba xg'ao hàna, gam dim xháràm kòo káí tc'õoan kúrú ba. ");
INSERT INTO nhr_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Me tcáóa ba koe tẽèse a máá: ‘Dùú ra gha kúrú? C'ẽe qgáì gar úú tama ka, tiri tc'õoa ner gha tòóa mááse e,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kam ko máá: ‘Ncẽea ra gha hẽé ga a: Tòóa máásean di xu nquu xu tiri xur gha ko̱be a ra a kaia xu tshào, a tiri mabere cãan hẽé naka tiri zi gúù zi c'ẽe zi hẽéthẽé gaa koe tòó. ");
INSERT INTO nhr_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ra gha nxãaska bìríse a máá: ‘Qãè zi gúù zi wèé zi ẽer ko qaa zir úúa hãa, káí kurian gha kg'õèkagu te zi. A ra a gha kg'õè sa thamkase séè, a gha tc'õó a kg'áà, a ra a qãè-tcaoa mááse,’ ’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Igabagam ko Nqari ba bìrí me a máá: ‘Tsáá khóè tsi káà tc'ẽe tseè, ncẽem ntcùúm ka tsi gha kg'õèa tsi séè cgaeè, ka zia gha nxãaska ẽe tsi kúrúa máásea hãa zi gúù zi dìín di ii?’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ncẽea i gha ii ga a, dìím wèém ẽe ko x'aia ba tòóa mááse ba Nqarim cookg'ai koe qguù tama,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Me Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Gaa domkar ko bìrí xao o, a ko máá: Táá gaxao di kg'õèan ka káíse tc'ẽe-tc'ẽese guu, dùú xao gha tc'õó kana dùú xao gha cgáé-q'ooa xao koe hã̱a sa. Kg'õè sa tc'õoan ka cgáé si i, me tc'áró ba qgáían ka cgáé me e ke. ");
INSERT INTO nhr_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Kg'õè sa tc'õoan ka kaisase cgáé si i, me cgáé-q'oo ba qgáían ka kaisase cgáé me e. ");
INSERT INTO nhr_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ho̱aran bóò, xhárà tama i hãa, a tcuù tama, a tc'õoan i gha tòóa mááse nquuan úú tama, gabàm ko Nqari ba xárò o. Tu gatu tsa̱rán ka kaisase cgáé tu u. ");
INSERT INTO nhr_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","A gatu ka c'ẽem dìí ba gha kg'õèa ba di cáḿan koe káíse tc'ẽe-tc'ẽesean ka cáḿ ba càù? ");
INSERT INTO nhr_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ncẽes gúùs cg'árés kúrú kaga tu ko tààè, ka tu koáé nxãaska dùúska c'ẽe zi ka káíse tc'ẽe-tc'ẽesea máá? ");
INSERT INTO nhr_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Bóò, nta zi qãáka di zi x'aa zi ii sa, zi ko ma tso̱m sa; tséé tama zi hãa, a zi a gataga qgáían qgãéa mááse tama. Igabar ko bìrí tu u, x'aigam Solomonem ga ba kò gam di x'aian wèé koe ga ncẽe zi x'aa zi ka c'ẽea zi khama ma hã̱a tama. ");
INSERT INTO nhr_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","A ncẽè Nqarim kòo qãáka di dcãan ncẽe ko ncẽe cáḿ ka hãa, a q'uu ka c'eean q'oo koe xaoa tcãàè, nxãan ncẽeta ma hã̱akagu, nem gha tseegukaga cgáése gatua hã̱akagu tu u, oo, gatu ncẽe cg'áré dtcòm̀an úúa tuè? ");
INSERT INTO nhr_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ke tu táá dùú sa tu gha tc'õó kana kg'áà sa qaa guu, naka káíse tc'ẽe-tc'ẽese guu. ");
INSERT INTO nhr_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tãá zi qhàò zi di nea ko wèé gúùan ncẽe ga qaa, Me gatu ka Xõòm ga ba ncẽe gúùan tu ko qaa sa q'ana hãa. ");
INSERT INTO nhr_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Igabaga méé tu kg'aika X'aigam Nqarim di x'aian qaa, naka tua gha ncẽe zi gúù zi wèé zi thẽé máàè. ");
INSERT INTO nhr_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ghùu-coa tuè, táá tu q'áò guu, qãè-tcaokagu i ko gatu ka Xõò ba, Me gha ntcõó-q'ooan máà tu u ke. ");
INSERT INTO nhr_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Eẽ tu úúa hãa zi tu x'ámágu, naka tua gazi di marian dxàua ne khóè ne máà. Cg'ãa-cg'anase tama qgóán tu kúrúa mááse, naka nqarikg'ai di qguùan ncẽe kaà tite cgoa, cúí ts'ãà-kg'ao kaga cúù-cuuse cgaeè tite e kana tcg'ãàn kaga tc'õóè tite e. ");
INSERT INTO nhr_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Eẽ tsari qguùan hãa koe i gha gataga thẽé tsari tcáóan hãa khama. ");
INSERT INTO nhr_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Tséé sa méé tu kg'ónòsea máána hãa, naka i gatu di x'áà-x'aa-kg'ai cgoa di gúùan ko ka̱ru. ");
INSERT INTO nhr_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Gane ka q'õòse ba qãà hãa ne tséé-kg'ao ne khama ma, séèkuan dis kõ̱ès koe kò qõòa hãa ba. Eẽm ko hàà a ko nquu-kg'áḿ ba xg'áḿ-xg'am, ne gha kúúga xgobekg'ama máá me ne. ");
INSERT INTO nhr_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Eẽ xu qãà xu, ncẽe gaxu ka q'õòsem ko hàà a hàà sao-xg'ae xu kókòa hãa xu ka i gha kaisase cgáé ii. Tseegukar ko bìrí tu u: Tsééam gha máá xu sam kg'ónòsea máána hãa, a gha tafolem koe ntcòo xu, a tsééa máá xu. ");
INSERT INTO nhr_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eẽ gaxu ka q'õòsem kòo ntcùú ka hàà kana ntcùú nqáè ka igaba gha kókòa hãa xu qãà xua ts'ee-ts'eekg'aièa. ");
INSERT INTO nhr_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Igaba méé xao ncẽe sa q'ana hãa: Ncẽè nquu ba kàoa hãam khóèm kò q'ana hãa ts'ãà-kg'aom ko dùútsa x'aè ka tcãà sa, nem ga kò táá gam dim nquu ba guu me khõaèa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ke méé tu gatu igaba kg'ónòsea hãa, Khóèm dim Cóá ba gha tcom tama tu hãam cáḿ ka hàà cgae tu u ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petere ba kò máá: “X'aigaè, ncẽes sere-seres ncẽe Tsi ko nxàe sa koáé sixae cgoa kg'ui, kana saa ko wèém khóèm cgoa kg'ui?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Me X'aigam Jeso ba xo̱a me a máá: “Kháé dìí ba nxãaska tcom-tcomsa a tc'ẽegam qãà baa? Ncẽe gam ka q'õòsem gha nquua ba di qarian máà ba, me qãè x'aè ka gaxu di tc'õoan máà xu ba. ");
INSERT INTO nhr_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ts'ee-ts'eekg'aièa baa ẽem qãà ba, ncẽe gam ka q'õòsem ko hàà nem ko hàà sao-xg'ae me ko gatà hẽé ba. ");
INSERT INTO nhr_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tseegukar ko bìrí tu u a ko máá: wèé zi gúù zi ẽem úúa hãa zi di qaria nem gha gam koe tòó. ");
INSERT INTO nhr_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Igabaga ncẽè ẽem qãàm ko tcáóa ba q'oo koe bìríse a máá: ‘Tíí q'õò ba ãoa hãa a qháése hàà tite,’ témé, a ba a tshoa-tshoa a c'ẽe ne qãà ne xg'áḿku cgoa, a tc'õó a kg'áà a tshoa-tshoa a nqàre, ");
INSERT INTO nhr_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nem gha ẽem qãàm ka q'õòse ba tcom tamam hãam cáḿ ka hàà, c'úùam hãa x'aè ka, a ba a gha hàà xgàra me, a ẽe tcom-tcomsa tama ne cgoa xg'ae-xg'ae me. ");
INSERT INTO nhr_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Qãàm ẽe gam ka q'õòsem ko qaa sa q'ana hãa, igaba kg'ónòse naka kúrú si tama ba gha káí tsa̱man xg'áḿmè. ");
INSERT INTO nhr_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Igaba ẽem kúrúa hãas domkam ko xgàraè sa c'úùa hãam qãà ba gha cg'orò tsa̱man xg'áḿmè. Wèém ẽe káían máàèam koe i gha káían qaaè, ẽe kaisase káían máàèam koe i gha gataga kaisase káían qaaè. ");
INSERT INTO nhr_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nqõómkg'ai koer gha hàà c'eean óá kar hààra, a kò gataga káíse ncàm̀aa, nxãakamaga i ga kò ka̱rukaguèa sa! ");
INSERT INTO nhr_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tcguù-tcguuku sa hàna tcguù-tcguuèr gha ko sa, gaas kar qgóóèa si gha nxãakg'aiga síí xg'ara. ");
INSERT INTO nhr_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nqõómkg'ai koer ko hàà tòókuan óá, ta tu gáé tc'ẽea? Bìrí tu ur ko: nxãas tama si i, igabar ko q'aa-q'aase sa óága. ");
INSERT INTO nhr_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ncẽe koe guus ka ne gha 5 ne khóè ne cúím x'áém di ne q'aa-q'aaè, ne gha nqoana ne cám̀an cgoa táá kóḿku, i cám̀an táá nqoanan cgoa kóḿku. ");
INSERT INTO nhr_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Q'aa-q'aaè ne gha, me xõò ba cóám cgoa táá kóḿku, me cóá ba xõòm cgoa táá kóḿku, si xõò sa cóás cgoa táá kóḿku, si cóá sa gaas ka xõòs cgoa táá kóḿku, si c'uì sa c'uìse-coas cgoa táá kóḿku, si c'uìse-coa sa c'uìses cgoa táá kóḿku,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","A ba a xg'ae zi bìrí a máá: “Túú-c'õò sa tu kò bóò si ko cáḿs ko tcãà xòè za guu a ko qaò ne tu ko kúúga máá: ‘Tuu i ko sene,’ témé, i gataga ii. ");
INSERT INTO nhr_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Dtcẽè xòè za guuam tc'ãá ba tu kòo bóò ne, tu ko máá: ‘Sene i gha kaisase kùrusa a,’ témé, i gataga ii. ");
INSERT INTO nhr_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gatu khóè tu qãè khóèan khama ko ma kúrúse tuè! Nqõómkg'ai hẽé naka nqarikg'ai hẽéthẽé koe gha kúrúse zi gúù zi nxàe tu q'ana hãa, igaba tu dùús domka x'aèan di zi x'áí zi nxàean c'úùa hãa? ");
INSERT INTO nhr_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Dùús domka tu cúíaga bóòa tcg'òóa mááse tama qãè gúùan kúrúè gha a? ");
INSERT INTO nhr_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eẽ ko chìbi-chibi tsim cgoa, méé tsi wèé qaria tsi kúrú naka tsao xg'aen ntcõó naka ẽes chìbi sa nxàe nakas qanega tsao dàòm q'oo koe hãa a xgàrakuan dis qhàìs koe síí ta ga hãase chõò. Nxãa tama kò ii nem gha xgàra-kg'aom tshàu q'oo koe tcãà tsi, me gha xgàra-kg'ao ba qáé-kg'aom tshàu q'oo koe tcãà tsi, tsi gha qáé-nquus koe tcãàè. ");
INSERT INTO nhr_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Bìrí tsir ko a ko máá: Cuiskaga tsi gaa koe tcg'oara hãa tite, a gha nxãakg'aiga síí ẽe qaùa hãam mari-coa ba suruta,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gaa x'aè ka ne kò c'ẽe ne khóè ne gaa koe hàna, ncẽe kò Jeso ba Galilea di ne khóè ne ka bìrí ne, ncẽem kò Pilato cg'õoa hãa ne, ẽe ne kò ko dàòa-mááku zi kúrú x'aè ka. ");
INSERT INTO nhr_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Me Jeso ba xo̱a ne a máá: “Gatu ko bóò ka nea kò ncẽe ne Galilea ne, wèé ne Galilea ne c'ẽe ne ka tshúù ne chìbi-kg'ao nea, ncẽeta ne kò ma xgàrase ka? ");
INSERT INTO nhr_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bìrí tu ur ko, gatà i ii tama, igaba tu kò gatu di chìbian koe tcóóse tama ne tu gha wèéa tu ga gataga ma kaàkaguè. ");
INSERT INTO nhr_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kana tua ko ntama ma tc'ẽe 18 ne khóè ne ncẽe kò Siloame koe qáòm nxõ̱á nquum ka cg'áé cgaeè ne ka, a cg'õoè ne, gatu ko bóò ka nea kò wèé khóèan ẽe Jerusalema koe x'ãèa hãa ka chìbiga nea? ");
INSERT INTO nhr_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bìrí tu ur ko, gatà i ii tama, igaba tu kò gatu di chìbian koe tcóóse tama ne tu gha wèéa tu ga gataga ma kaàkaguè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jeso ba kò nxãaska ncẽes sere-seres ka bìrí ne a máá: “Khóè ba kò hàna a ba a faia dis hìi sa úúa, gam dim kg'om xháràm q'oo koe kò xháràèa sa. Gaa koem kò síí ko tc'áróa sa qaa, igabam ko táá cúían ga hòò. ");
INSERT INTO nhr_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Me nxãaska khóèm gam dim xhárà ba ko kòre ba bìrí a máá: ‘Bóò, nqoana xu kuri xu ra úúa a ko ncẽe koe hàà a ko hàà ncẽes hìis faia dis di tc'áróan qaa, igabagar cúían ga hòò tama. Ke xg'aoa tcg'òó si! Kg'amagas téé a ko góḿan tséékagu ke!’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Igabam kò khóè ba xo̱a a máá: ‘Tíí q'õòè, guu si gaicara cúím kuri ba nakar tshào qaò si naka c'aruan máà si. ");
INSERT INTO nhr_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ncẽeko hààm kurim kas kò tc'áró kúrú ne i gha qãè e, igabagas kò kúrú u tama ne tsi gha nxãaska xg'aoa tcg'òó si,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabata dim cáḿ kam kò Jeso ba hãa a ko c'ẽem còrè-nquum koe xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Igabagas ko gaa koe khóè sa hàna, 18 kurian ko dxãwa tc'ẽean ka nqo̱arakaguèa hãa sa, a sa a kò qhúùsea, a cg'árés kaga tchoanàse tama. ");
INSERT INTO nhr_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Eẽm ko Jeso ba bóò si kam kò Gam koe tciia óá si a máá: “Khóè seè, tcììa si koe si kgoaraèa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A ba tshàua ba tòó cgae si, si gaa x'aè kaga tchoanàse a sa a Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesom ko Sabata di cáḿ ka kg'õèkagus gúùs domkam kò còrè-nquum dim tc'ãà-cookg'ai ba xgóà, a ba a khóè ne bìrí a máá: “6 cáḿa ne hàna khóèan ga tséé e, ke méé ne gaa cáḿan ka hàà naka nea hàà kg'õèkaguse, Sabata dim cáḿ ka tamase,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Me kò X'aigam Jeso ba xo̱a me a máá: “Gatu qãè khóèan khama ko ma kúrúse tuè, a gatu ka c'ẽem ga ba gáé cuiskaga Sabata dim cáḿ ka gam dis ghòè sa kana donghim igabaga xgàris koe kgoara hãa naka chùia úú me naka síí kg'áàkagu mea hãa tite? ");
INSERT INTO nhr_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ka sa gáé ga ncẽes khóès Abrahamam ka cóáses, ncẽe kò ncẽeta noo kurian 18 séè a satanam ka qáéèa hãa sa, Sabata dim cáḿ ka táá kgoaraè ẽe kò qáé sia hãas gúùs koe?” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Eẽm ko ncẽes gúù sa nxàe ka i kò Gam di ntcoe-kg'aoan saucgae, igabas kò wèés xg'aes ẽe sa wèé zi gúù zi cgáé zi ẽem kúrúa hãa zi qãè-tcaoa máá. ");
INSERT INTO nhr_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Me Jeso ba tẽè ne a máá: “Nqarim di x'aia nea nta ii? Dùús cgoa Ra gha nxárá xg'ae e? ");
INSERT INTO nhr_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Mosetara dis hìis dim cgùrim khama i ii, ncẽem kò khóè ba séè a gam dim xháràm koe xhárà ba. Me tso̱m a ba a hìi sa kúrú, i kò nqarikg'ai di tsa̱rán hàà gaas hìis di nxã̱an koe nquuan kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Me gaicara tẽè a máá: “Dùús cgoa Ra gha Nqarim di x'aian nxárá xg'ae? ");
INSERT INTO nhr_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Péré gãé-gãean khama i ii, ncẽes ko dxàes khóè sa séè a káí péréan cgoa xg'ae-xg'ae e, i wèés pérés koe tséé, si gãe e,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Eẽm kò Jeso ba Jerusalema koe qõò kam kò x'áé-dxoo xu hẽé naka x'áé-coa xu koe hẽéthẽé tcãà, a ba a ẽem ko ma qõò khama ma xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","C'ẽem khóè ba kò tẽè Me a máá: “X'aigaè, a cg'orò ne khóè ne cúí ne ko hàà kgoaraè?” témé. Me bìrí ne a máá: ");
INSERT INTO nhr_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Wèé qaria tsi ga tséékagu naka tsia xgam-xgam nquu-kg'áḿ koe tcãà. Bìrí tu ur ko a ko máá: káí nea gha tcãà ne gha sa tc'ẽe igaba ne gha tààè. ");
INSERT INTO nhr_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eẽm ko nquu-kg'ao ba tẽe a ko nquu-kg'áḿ ba tcẽekg'am x'aè ka tu gha tchàa za hãa, a tu a gha tshoa-tshoa a nquu-kg'áḿ ba xg'áḿ-xg'am, a kg'aea mááse a máá: ‘X'aigaè, nquu-kg'áḿ ba xgobekg'ama máá ta a,’ témé, igabam gha xo̱a tu u a máá: ‘C'úù tua raa ke tu tíí koe tcg'oa, gatu cg'ãè kúrú-kg'ao tuè!’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tu gha tshoa-tshoa a máá: ‘Tsáá cgoa ta kò ko tc'õó a ko kg'áà, tsi kò ko gatá di x'áéan koe ga thẽé xgaa-xgaa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Igabagam gha xo̱a a máá: ‘C'úù tua ra hãa, a guua tu hãa qgáì ga c'úùa, ke tu tíí koe tcg'oa, gatu wèé tu cg'ãè kúrú-kg'ao tuè,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abrahama ba hẽé, Isaka ba hẽé, naka Jakobe ba hẽé, naka wèé porofitian Nqarim di x'aian koe hàna hẽéthẽé tu kò ko bóò nes gha kg'ae sa hẽé nakas gãò xõ̱ó sa hẽéthẽé hãa, igabaga tu gha gatu tchàa za xaoa tcg'òóèa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Igaba ne gha khóè ne cáḿs ko tcg'oa xòè koe guu, ne c'ẽe ne cáḿs ko tcheè xòè koe guu, ne c'ẽe ne c'ẽe xòèan nqõóm di koe guu, a hàà x'aian Nqarim di koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Igabaga méé tu q'ãa, c'ẽe ne ẽe kháóka kò hãa nea gha tc'ãà di ne ii, ne gha c'ẽe ne ẽe tc'ãà di kò ii ne kháóka di ne ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Eẽm x'aèm ka xu kò c'ẽe xu Farasai xu Jeso ba hàà cgae, a bìrí Me a máá: “Ncẽem qgáì ba tcg'oara guu naka Tsia c'ẽe za qõò, Herote ba cg'õo Tsi kg'oana ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Me Jeso ba xo̱a xu a máá: “Qõò naka síí ẽem círí ba bìrí naka máá: ‘Dxãwa tc'ẽea ner ko xhàiagu, a Ra a ko khóè ne ncẽem cáḿ ka hẽé naka q'uu dim cáḿ ka hẽéthẽé qãèkagu, a Ra a gha Tiri tsééan nqoana dim cáḿ ka xg'ara-xg'ara,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gatà i ii igaba méér dàòa te koe hãa ncẽem cáḿ ka hẽé, q'uu dim cáḿ ka hẽé, naka q'uu dim cáḿ qãá q'oo dim cáḿ ka hẽéthẽé e. Porofitim ga Jerusalema ka tchàa za cg'õoè sa qãè tama khama. ");
INSERT INTO nhr_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Oo! Jerusalemaè, Jerusalemaè. Tsáá porofitian ko cg'õo tsi, a ẽe tsáá koe i kò tsééa óáèa hãa ne ko nxõ̱án cgoa xao o tsi. Nta noose ra kò tc'ẽea hãa, tsari cóá ner ga cúí koe xg'ae-xg'aea hãa sa, ẽes ko ma ghòrò sa tcgàmà sa dòm̀ q'oo koe ma gas di ghòrò-coan ma xg'ae-xg'ae khama. Igabaga tu ko tc'ẽe e tama. ");
INSERT INTO nhr_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Q'ãa méé tu, Nqari ba gha Gam dim nquu ba guua máá tu u sa. Bìrí tu ur ko, gaicara tu bóò Tea hãa tite a tu a gha nxãakg'aiga máá: ‘Eẽ ko X'aigam dim cg'õèm cgoa hàà ba ts'ee-ts'eekg'aièa hãa,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","C'ẽem cáḿ Sabata dim kam kò Jeso ba Farasai xu dim tc'ãà-cookg'aim x'áé koe hàna, a ko tc'õó, ka ne kò khóè ne qãèse bóò Me. ");
INSERT INTO nhr_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Me kò kúúga x'õàa ba hẽé naka c'õáa ba hẽéthẽé kò gãéa hãam khóè ba Jesom koe hàà. ");
INSERT INTO nhr_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Me kò Jeso ba x'áè q'ãa-kg'ao xu hẽé naka Farasai xu hẽéthẽé tẽè a máá: “Sabata dim cáḿ ka khóèan qãèkagua nea x'áèan ka kgoaraèa kana ia kgoaraè tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Igaba xu kò táá cúí gúù ga nxàe. Me kò Jeso ba khóè ba séè, a qãèkagu, a guu mem qõò. ");
INSERT INTO nhr_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kam ko bìrí xu a máá: “Ncẽè gaxao ka c'ẽem kò cóá ba úúa kana ghòè ba, me Sabata dim cáḿ ka tsàùm q'oo koe cg'áéa tcãà, ne ba síí tcg'òó mea hãa tite?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Igaba xu kò ncẽes gúùs ka táá kgoana a xo̱a Me. ");
INSERT INTO nhr_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Eẽm ko Jeso ba bóòa q'ãa, cg'áè-kg'ao ne ko ma kaia zi ntcõó-q'oo zi koe ma ntcõó sa, kam kò ncẽes sere-sere sa bìrí ne a máá: ");
INSERT INTO nhr_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Eẽ tsi kò c'ẽem khóèm ka séèkuan dis kõ̱ès koe tciièa hãa ne táá kaia zi ntcõó-q'oo zi koe ntcõó guu, c'ẽedaokam gha c'ẽem khóèm tsáá ka kaisase tcom-tcomsa ba thẽé tciièa hãa ke. ");
INSERT INTO nhr_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gatà i kò ii nem gha ẽe tcii tsaoa hãa ba hàà, a bìrí tsi a máá: ‘Ncẽem khóè ba tsaris ntcõó-q'oo sa máà,’ témé, tsi gha saucgae, a gha nxãaska tshoa-tshoa a cg'árés ntcõó-q'oos koe síí ntcõó. ");
INSERT INTO nhr_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Igaba ẽe tsi kò tciièa hãa ne, cg'árés ntcõó-q'oos koe ntcõó, nakam gha nxãasega ẽe tcii tsia hãam kò ko hàà ne bìrí tsi naka máá: ‘Tíí tcáràè, còoka hànas ntcõó-q'oos koe ntcõó,’ témé, naka tsi gha nxãasega cg'áè-kg'ao ne tsáá ka c'ẽe ne cookg'ai koe tcom-tcomsakaguè. ");
INSERT INTO nhr_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Wèém ẽe ko kaikaguse ba gha cg'áré-cg'areè, me gha ẽe ko cg'áré-cg'arese ba kaikaguè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Me Jeso ba nxãaska ẽe kò tcii mea hãam khóè ba bìrí a máá: “Eẽ tsi kò dòàs koaba, kana dqòa di tc'õoan di sa ko kúrú, ne méé tsi táá tsáá tcárà ne, kana tsáá qõe ga ne, kana tsari ne qhàò ne, kana tsáá ka c'ẽea ne ẽe qguùa ne igaba tcii guu. Gatà tsi kò ko hẽé ne, ne gha gane igaba thẽé dòàn kúrú a gha tciia úú tsi, a síí ẽe tsi kúrúa máá nea hãa sa suruta ka̱bi tsi ke. ");
INSERT INTO nhr_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Igaba ncẽè dòà sa tsi kò kúrúa hãa ne méé tsi dxàua ne khóè ne hẽé, nqo̱ara ne hẽé, ts'íìko ne hẽé naka káà tcgáí ne hẽéthẽé tciia óá, ");
INSERT INTO nhr_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","naka tsia gha nxãasega ts'eekg'ai ii, c'ẽe gúù gaan cgoa ne gha suruta ka̱bi tsi ne úú tama khama, a tsi a gha tchàno ne khóè ne ko x'ooan koe ghùiè x'aè ka suruta ka̱biè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Eẽ kò Gam cgoa ntcõe xu ka c'ẽem ko ncẽes gúù sa kóḿ kam kò Jeso ba bìrí a máá: “Ts'eekg'ai me e gha ii, ẽe gha ko dòàs Nqarim di x'aian dis koe tc'õó ba!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Me Jeso ba xo̱a me a máá: “C'ẽem khóè ba kò hãa, kaias dòà sa kò kúrú, a káí ne khóè ne tciia óá ba. ");
INSERT INTO nhr_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","“Eẽs dòàs di x'aè kam ko gam dim qãà ba tsééa úú, síím gha ẽe kò tciièa hãa ne bìrí a máá: ‘Wèé zi gúù zia kg'ónòèa hãa ke tu hàà,’ témé ka. ");
INSERT INTO nhr_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Igabaga ne ko wèéa ne ga cúíta méé a tshoa-tshoa a c'ẽe zi tséé zi ka ne ma qgóóa tòóèa sa nxàe. Tc'ãà di ba kò máá: ‘Ncãar xhárà ba x'ámá, qõò méér naka síí bóò mes gúù si i, ke cgóm̀na kg'aika qãà te,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Me c'ẽe ba máá: ‘Ncãar 5 xu ghòè xu jokoan di xu x'ámá, a ncẽer ii ka ko síí kúrúa bóò xu, ke cgóm̀na kg'aika qãà te,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","C'ẽem igabam kò máá: ‘Khóè sar ka̱basega séèa hãa, khamar síí tite,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Me qãà ba ka̱bise a hàà ncẽe zi gúù zi gam ka q'õòsem koe xàà. Me kò x'áé-kg'ao ba xgóà, a gam dim qãà ba bìrí a máá: ‘Qháé naka tsia x'áé xu koe hẽé, naka x'áé tcúú xu koe hẽéthẽé síí, naka tsia síí ẽe dxàua ne hẽé, ẽe nqo̱ara ne hẽé, ẽe káà tcgáí ne hẽé, naka ts'íìko ne hẽéthẽé, séè naka ncẽe koe óá,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Me gaa koe guus ka qãà ba máá: ‘Tíí q'õòè, ẽe tsi nxàea hãa sa kúrúsea, igabaga i qanega ntcõó-q'ooan hàna,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Me nxãaska qãàm ka q'õòse ba bìrí me a máá: ‘Dàò xu koe hẽé naka x'áéan xg'aeku di xu dàò-coa xu koe hẽéthẽé qõò naka tsia kúrú ne naka ne hàà, nakam gha nxãasega tirim nquu ba cg'oè. ");
INSERT INTO nhr_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bìrí tu ur ko, ẽe kò tciièa hãa xu khóè xu ka cúím ga ba tiris dòàs di tc'õoan xám̀a hãa tite!’ témé,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Zi kò kaia zi xg'ae zi Jesom cgoa qõò. Me ka̱bise a bìrí ne a máá: ");
INSERT INTO nhr_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ncẽè c'ẽem khóèm kò Tíí koe hàà kg'oana, igabam kò xõò ba, kana xõò sa, kana gam dis khóè sa, kana gam di cóá ne, kana káíkhoea ba, kana qõea ba ga igaba hòre tama, kana gam di kg'õèan igaba hòre tama nem cuiskaga Tirim xgaa-xgaase-kg'ao ba ii tite. ");
INSERT INTO nhr_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Dìím wèém ẽe gam dim xgàu hìi ba dcẽé naka xùri Te tama ba Tirim xgaa-xgaase-kg'ao ba ii tite. ");
INSERT INTO nhr_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“C'ẽedaokam gaxao ka c'ẽe ba qáòm nquu ba tshào kg'oana, ka ba gáé kg'aika ntcõó naka tc'ẽe-tc'ẽesea hãa tite, nta noo marian ko qaase sa, gaas tséé sam ga xg'ara-xg'ara cgoa a? ");
INSERT INTO nhr_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eẽm ko tshoa-tshoa sa kúrú, a kò xg'ara-xg'ara sa ka tààè, nem gha wèém khóèm ẽe ko bóò me ba kg'ãè me khama, ");
INSERT INTO nhr_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a kg'ui a máá: ‘Ncẽem khóè ba tshoa-tshoa a ko tshào, igabam xg'ara-xg'aran ka tààèa hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“A ncẽè c'ẽem x'aigam kò 10,000 xu ncõo-kg'ao xu úúa hãa, a ko síí c'ẽem x'aigam 20,000 xu ncõo-kg'ao xu úúa hãam cgoa x'ãàku, ne ba gáé kg'aika ntcõó naka tc'ẽe naka bóò tama, tc'ãòa hãa qaria nem úúa hãa sa, síím ga c'ẽem x'aiga ba x'ãà cgoa a? ");
INSERT INTO nhr_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","A ncẽè gatàm kò hẽé tama, nem gha tchõà xàà-kg'ao xu tsééa úú, c'ẽem qanega nqúù ii koe, xu síí tòókuan dtcàrà. ");
INSERT INTO nhr_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Gatà iim dàòm kam, dìím wèém ẽe gatu xg'aeku koe hãa ba, a gam di zi gúù zi wèé zi ẽem úúa hãa zi aagu tama ba Tirim xgaa-xgaase-kg'ao ba ii tite. ");
INSERT INTO nhr_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ta̱bea ne qãè e, igaba i kò ta̱bean gaan di tsa̱u-q'ooan ka kaà cgaeè, ne i gha gaicara ntama ma kúrúè a tsa̱u? ");
INSERT INTO nhr_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Góḿan koe ga hẽé naka cg'urian ẽe tcheèguèa koe ga hẽéthẽé i káà tséé e, a ko khóèan ka tchàa za aaguè. Eẽ tceean úúa hãa ba méém kóḿ,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","C'ẽem cáḿ ka i kò wèé mari xg'ae-xg'ae-kg'aoan hẽé naka chìbi-kg'aoan hẽéthẽé Jesom koe cúù-cuuse, hàà ne gha komsana Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Xu Farasai xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé tshoa-tshoa a kg'uia mááse a máá: “Ncẽem khóè ba ko chìbi-kg'ao ne qãèse hààkagu, a ko gane cgoa tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Me nxãaska Jeso ba ncẽes sere-sere sa bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“C'ẽem-kg'áḿ kam gatu ka c'ẽe ba 100 zi ghùu zi úúa, si gazi xg'aeku koe cúí sa ho̱à, ne ba cuiskaga ẽe zi 99 zi qãáka guu, naka ẽe ho̱àra hãa sa síí qaa, naka ba nxãakg'aiga síí hòò si tite? ");
INSERT INTO nhr_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A ẽem kòo hòò si, nem gha kaisase qãè-tcao a ba a gha nxa̱ra ba koe dcẽé si. ");
INSERT INTO nhr_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Eẽm ko x'áé koe hàà nem gha gam ka tcáràse ga xu xg'ae-xg'ae gam di qhàòan cgoa, a bìrí ne a máá: ‘Tiris ghùus ncẽe ko ho̱àra hãa sar hòòa ke tu tíí cgoa qãè-tcao,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Bìrí tu ur ko a ko máá: gatà iim dàòm cúím ka i gha nqarikg'ai koe qãè-tcaoan hãa, cúím chìbi-kg'aom ẽe ko chìbian koe tcóósem domka, 99 ne khóè ne ẽe tchàno ne e ta ko mééè ne ka, ncẽe chìbian koe tcóóse qaa tama ne. ");
INSERT INTO nhr_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Kanas kò c'ẽem-kg'áḿ ka khóès 10 qano mari xu úúa hãa sa, c'ẽem ka aaguse cgaeè, ne sa gáé ga táá x'áà-x'aa-kg'ai cgoa dis gúù sa dàò, naka nquu ba xgài q'oo, naka qãèse ẽem mari ba qaa, naka nxãakg'aiga síí hòò me tite? ");
INSERT INTO nhr_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eẽs kò hòò me nes gha gas di tcáràn hẽé naka gas di qhàòan hẽéthẽé tciia xg'ae, a máá: ‘Marim ẽe kò aagusea hãa bar hòòa hãa ke tu tíí cgoa qãè-tcao,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Bìrí tu ur ko a ko máá: gatà iim dàòm cúím ka i gha Nqarim di xu moengele xu cookg'ai koe qãè-tcaoan hãa, cúím chìbi-kg'aom ẽe gha gam di chìbian koe tcóósem domka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Me Jeso ba nxãaska máá: “Khóèm cám̀ cóá tsara kò úúa hãa ba kò hãa. ");
INSERT INTO nhr_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Me cg'áré ba xõò ba bìrí a máá: ‘Aboè, tsari zi gúù zi q'aa-q'aa máá tsam m, naka tiri gha ii zi máà te,’ témé. Me kò gam di gúùan gam di tsara cóá tsara q'aa-q'aa máá. ");
INSERT INTO nhr_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Me cg'áré ba cg'orò xu cáḿ xu qãá q'oo koe gam di zi gúù zi wèé zi x'ámágu, a ba a marian séè, a x'áéa ba guu, a nqúùm nqõóm koe qõò, a síí gaa koe gam di marian x'ãè a cg'ãè zi gúù zi koe xgãá. ");
INSERT INTO nhr_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eẽm ko gam di zi gúù zi wèé zi tséékagua xg'ara kas kò gaam nqõóm koe qhóó sa tcãà, me tshoa-tshoa a ẽem cóá ba qóḿ cgoa qgóóku. ");
INSERT INTO nhr_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Kam ko c'ẽem khóèm gaam nqõóm dim koe síí a síí tsééan dtcàrà, me nxãa ba gam dim xháràm koe tsééa úú me, síím gha xgùuan kòre ka. ");
INSERT INTO nhr_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Me kò káíse tc'ẽea hãa, xgùuan di tc'õoan cgoam ga kg'õèkaguse sa, i kò táá cúí khóè ga c'ẽe gúù tc'õó di ga máà me. ");
INSERT INTO nhr_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Me ẽem ko ẽe sa bóòa q'ãa ka bìríse a máá: ‘Nta noo tséé-kg'aoan àbom dia káí tc'õoan úúa, ra ko tíí ncẽe koe xàbàn ka cg'õoè. ");
INSERT INTO nhr_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Xgoabar gha a àbom koe síí, a ra a gha síí bìrí me a máá: ‘Aboè, nqarikg'aian hẽé naka tsáá cookg'ai koe hẽéthẽé ra chìbian kúrúa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tsarir cóá ra a tar ga ma tciiè sar kg'ano tama; ke tsari xu tséé-kg'ao xu khama ma qgóó te,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","A ba a xgoaba, a xõòm koe qõò. “Eẽm qanega nqúù ii kam kò xõò ba bóò me, a thõò-xama máá me, a qàròa síí cgae me, a síí xgábé me, a x'obè me. ");
INSERT INTO nhr_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Me cóáse ba bìrí me a máá: ‘Aboè, nqarikg'aian hẽé naka tsáá cookg'ai koe hẽéthẽé ra chìbian kúrúa hãa. Tsarim cóá ba tar gha ma tciiè sar kg'ano tama,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Me xõò ba gam di xu qãà xu bìrí a máá: ‘Qháése xao t'õèm qgáí ba óá, na hàà hã̱akagu me, naka xaoa tcãà tshàu sa tcãà tshàu me, naka xaoa nxàbokagu me. ");
INSERT INTO nhr_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Naka xaoa síí tsauam ghòè-coa ba séè na cg'õo, naka ta kg'oo na dòà sa kúrú. ");
INSERT INTO nhr_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ncẽem cóám tiri ba kò x'óóa hãa, igabam ncẽeska kg'õèa hãa; ho̱àram kò hãa igabam hòòsea hãa ke,’ tam méé. Ne tshoa-tshoa a dòà sa kúrú. ");
INSERT INTO nhr_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Gaa x'aè kam kò gam ka cóásem kaia ba xhárà-kg'ai za hãa. Síím ka̱bise a x'áéan qàe koe hãa kam ko khóè ne kóḿ ne ko nxáè a ko ntcãà. ");
INSERT INTO nhr_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kam kò c'ẽem qãà ba tcii a tẽè, dùús ko kúrúse sa. ");
INSERT INTO nhr_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Me nxãa ba xo̱a me a máá: ‘Tsáá qõe ba ka̱bisea hãa, me saò ba qãèsem ka̱bisea hãas gúùs domka tsauam ghòè-coa ba qhàea hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Me káímkhoe ba kaisase xgóà a ba a nquum q'oo koe tcãàn xguì. “Me kò xõò ba tcg'oa a hàà dàna me. ");
INSERT INTO nhr_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Me xo̱a me a máá: ‘Bóò, káí kurian ncẽeta noor qãàm khama ma tsééa máá tsia hãa, a qanega tsari x'áè-kg'áḿan ntcoe ta ga hãa. Igaba tsi qanega piri-coas ga sa máà te, nakar gha nxãasega tíí tcárà ne cgoa dòà sa kúrú ta ga hãa. ");
INSERT INTO nhr_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Igaba ẽem ko ncẽem cóám tsari ba ka̱bise, ncẽe kò tsari zi gúù zi cg'áràn koe kõ̱è cgoa ba, ka tsi kò tsauam ghòè-coa ba cg'õoa máá me,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Me xõò ba bìrí me a máá: ‘Tiri cóáè, tsáá tsi wèé x'aè ka tíí cgoa hãa, i tiri gúùan wèé ga tsari i. ");
INSERT INTO nhr_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gaa domka méé ta kõ̱è naka qãè-tcao, tsáá qõem ncẽe ba kò x'óóa hãa, igabam ncẽeska kg'õèa hãa; ho̱àram kò hãa, igabam hòòsea hãa domka,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeso ba kò Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “C'ẽem khóè ba kò hãa qguùa ba, a ba a kò nquu kòre-kg'ao ba úúa hãa, ncẽe gam di zi gúù zi kò ko kòre ba. I ko xààn hààra hãa, gaam nquu kòre-kg'ao ba ko gam di zi gúù zim ko ma tc'ẽe khama ma tséékagu sa. ");
INSERT INTO nhr_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Me nxãaska gam ka q'õòse ba tciia tcãà me a máá: ‘Dùú sa ncẽer ko tsáá ka kóḿ sa? Tsari tséé-q'ooan dis tcgãya sa máà te, gaicara tsi cuiskaga nquu kòre-kg'ao ba kúrúa hãa tite ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Me nquu kòre-kg'ao ba bìríse a máá: ‘Dùú sa ra gha kúrú, ncẽe tíí q'õòm ko tsééa te xhùu cgae te ka? Tshào cgoar gha qarian tc'ãòa hãar úú tama, a ra a ko gataga dtcàràn ka cgóm̀gase sau-cgaekaguè. ");
INSERT INTO nhr_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ncẽeskar q'ana hãa dùú sar gha kúrú sa, nxãasega ne gha khóè ne x'áéa ne koe qãèse hààkagu te ka, ncẽe koer ko tsééan koe tcg'òóè ne,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kam ko wèé ne khóè ne ẽe kò gam ka q'õòse ba chìbian kúrú cgaea ne cúí cúí tcii, a tc'ãà di ba bìrí a máá: ‘Tíí q'õòm koe tsi nta noo chìbian úúa?’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Me xo̱a me a máá: ‘100 xu gàba xu olife dis hìis di nxúìan di xu u,’ témé. Me máá: ‘Tsaris tcgãya sa séè naka qháése ntcõó naka 50 xu góá tòó,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Me nxãaska cám̀ di ba bìrí a máá: ‘Kháé tsáá ka, nta noo chìbian tsi úúa?’ témé. Me máá: ‘100 xu cãa xu maberean di xu u,’ témé. Me bìrí me a máá: ‘Tsaris tcgãya sa séè naka 80 xu góá tòó,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Me kò gam ka q'õòse ba gam dim nquu kòre-kg'aom tcom-tcomsa tama ba dqo̱m̀, tc'ẽegasem tsééa hãa khama. Ncẽem kámám di ne khóè nea gane ka c'ẽea ne cgoa tsééan koe x'áàn di ne cóá ne ka kaisase tc'ẽega ne e khama. ");
INSERT INTO nhr_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Tíí ra ko bìrí tu u a ko máá: Nqõómkg'ai di x'aian cgoa tcáràn kúrú, naka tua gha nxãasega ẽe i kò x'aian kaà ne, chõò tamam x'áém koe qãèse hààkaguè. ");
INSERT INTO nhr_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Dìím wèém ẽe cg'áré gúùan koe tcommèa hãa ba gha thẽé kaian koe ga tcommè. Dìím wèém ẽe cg'áréan koe tcommè tama ba gha thẽé ẽe kaian koe ga táá tcommè. ");
INSERT INTO nhr_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kháé nxãaska ncẽè nqõóm di zi qguù zi qgóó koe tu kò tcom-tcomsa tama, ne tua gha ntama ma tseeguan di qguùan qgóó koe tcommè? ");
INSERT INTO nhr_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Khama ncẽè c'ẽem khóèm di zi gúù zi ka tu kò tcom-tcomsa tama ne, tu gha nxãaska gatu di zi dìín ka máàè? ");
INSERT INTO nhr_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Cám̀ x'aigan gha tsééa máám qãà ba káà me e. C'ẽe bam gha hòre, a c'ẽe ba ncàm̀ khama, kanam gha c'ẽem koe dtcãàse, a c'ẽe ba ntcoe khama. Cuiskaga tu Nqari ba hẽé naka x'aian dim nqárì ba hẽéthẽé tsara cúí x'aè ka tsééa máána hãa tite,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Eẽ xu ko Farasai xu, ncẽe marian ncàm̀a hãa xu wèé gúùan ncẽe kóḿ, ka xu kò kg'ãèa nco̱i Me. ");
INSERT INTO nhr_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Igabam kò Jeso ba bìrí xu a máá: “Khóè ne cookg'ai koe xao ko tchàno iise bóòse, igabagam Nqari ba tcáóa xao q'ana hãa. Eẽ ko khóèm ka cgáé iise bóòè sam ko Nqari ba tcgáí-q'ooa ba koe cg'ãa-cg'ana iise bóò khama. ");
INSERT INTO nhr_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“X'áèan hẽé naka porofiti xu hẽéthẽéa kò hãa i nxãakg'aiga síí Johanem di x'aèan tcãà, i kò gaa koe guus ka nxãaska Nqarim di x'aian di qãè tchõàn xgaa-xgaaè, i kò wèé khóèan ghùi tcáó a tcana máá a. ");
INSERT INTO nhr_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Nqarikg'aian hẽé naka nqõómkg'ai hẽéthẽéa gha kaà sa thamka si i, igaba cg'áré xòè-coan x'áèan di ga kaà sa thamka tama. ");
INSERT INTO nhr_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Wèém khóèm ẽe ko gam dis khóè sa aagu, a c'ẽes khóè sa séè ba ko cg'áràn kúrú, me gataga ẽe aaguèa hãas khóè sa ko séèm khóè ba thẽé ko cg'áràn kúrú,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","A ba a máá: “C'ẽem khóèm qguùa hãam, káí marian ko tc'óàm qgáím nco̱à ba ha̱na hãa ba kò hàna, a kòo wèé x'aè ka dòàs q'oo koe kg'õè. ");
INSERT INTO nhr_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Me kò gataga c'ẽem khóèm Lasaro ta ko ma tciièm dxàua hãa ba hãa, ncẽe kòo gam dis xhàros-kg'áḿ koe káíse xóé ba, a kò cgáé-q'ooa ba koe káí chìbian úúa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A kò káíse ncóóa hãa ẽem khóèm qguùa hãam dim tafolem koe ko guu a tcheè tc'õoan cgoam gha kg'õèkaguse sa. Gataga i kòo ha̱ghuan igabaga hàà a hàà gam di zi chìbi zi tshãà. ");
INSERT INTO nhr_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Me x'aè ba hàà me ẽem dtcàrà-kg'aom dxàua kò hãa ba x'óó, xu moengele xu séè a síí Abrahamam qàe koe ntcòó me, me ẽe kò qguùa hãa ba thẽé x'óó, a síí kg'ónòè. ");
INSERT INTO nhr_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Igabam kò x'óóa ne khóè ne dim qgáìm xgàrakuan dim koe kaisas thõòs koe hãase, ghùi-kg'ai a Abrahama ba bóò, me nqúù ii, me Lasaro ba qàea ba koe ntcõe, ");
INSERT INTO nhr_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","kam ko q'au a máá: ‘Abrahama, àboè, thõò-xama máá te, naka tsia Lasaro ba tsééa óá, nakam gha hàà nxãasega tshàu c'ama ba tshàan q'oo koe tcãà naka ta̱ma te qgài-qgai, kaisas thõòs koer hãa ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Me kò Abrahama ba xo̱a me a máá: ‘Tiri cóáè, tc'ẽe-tc'ẽese, kg'õèa tsi q'oo koe tsi kò tsáá qãè gúùan máàèa, me kò Lasaro ba tshúù zi gúù zi máàè, igabam ko ncẽeska qgài-qgai tcáóè, tsi ko tsáá thõòan xám̀kaguè. ");
INSERT INTO nhr_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Me gataga, wèé zi gúù zi ncẽe zi oose, sitsam hẽé naka tsáá hẽéthẽé xae xg'aeku koe kaiam qàm ba kúrúèa hãa, q'oòè tite ba, nxãasega ne gha ncẽe koe guu a ẽe koe síí kg'oana ne hẽé naka ẽe koe guu a q'oase hàà kg'oana ne hẽéthẽé tààè ka,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Me máá: ‘Aboè, nxãaskar ko dtcàrà tsi, tirim xõòm dim nquum koe tsi gha Lasaro ba tsééa úú sa, ");
INSERT INTO nhr_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nakam síí tíí qõe ga xu 5 xu gaa koe hãa xu q'ãa-q'ãa, naka xu gha nxãasega táá gataga thẽé ncẽer hànam qgáìm xgàrakuan dim koe hàà guu,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Me kò Abrahama ba xo̱a me a máá: ‘Tsáá qõe ga xua Moshe ba hẽé naka porofiti xu hẽéthẽé di zi Tcgãya zi úúa, ke méé xu komsana zi,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Me máá: ‘Nxãan tama a, àbo tsi Abrahama tseè, igaba ncẽè c'ẽem khóèm kò x'ooan koe guu a síí cgae xu, ne xu gha gaxu di chìbian koe tcóóse,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Me Abrahama ba bìrí me a máá: ‘Moshe ba hẽé naka porofiti xu hẽéthẽé xu kò komsana tama, ne xu cuiskaga khóèm ẽe x'ooan koe tẽeam ko méés ga sa dtcòm̀a hãa tite,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeso ba kò Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Eẽ ko khóèan chìbian kúrúkagu gúùan méé i hãas gúù si i, igaba i gáé tsóágase ẽe ko gaa cg'ãè-kg'ooan kúrú ba cg'ãèa máána hãa! ");
INSERT INTO nhr_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Gam ka i gha qãè e, gáí cgoa dis nxõ̱ás kaias kòo qg'áóa ba koe qáéa tòóè, me kaiam tshàam q'oo koe xaoa tcãàè ne, guuè naka ncẽe ne cg'áré ne ka c'ẽe ba chìbian kúrúkagu tamase. ");
INSERT INTO nhr_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ke méé tu kòresea hãa. “Tsáá qõem kòo chìbian kúrú, ne méé tsi dqàè me, naka ẽem kòo chìbi bóòse ne qgóóa máá me. ");
INSERT INTO nhr_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eẽm kòo cáḿ q'oo koe 7 q'oro chìbian kúrú cgae tsi, a ba a 7 q'oro ka̱bise a hàà cgae tsi, a hàà chìbi bóòse ne méé tsi qgóóa máá me,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Xu x'áè úú-kg'ao xu X'aigam Jeso ba bìrí a máá: “Sixae di dtcòm̀an kaikagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Me X'aiga ba xo̱a xu a máá: “Dtcòm̀an xao kò úúa hãa, mosetara dis hìis dim tc'ubim khama noo o, ne xao ga ncẽes hìis kaias faia di sa bìrí a máá: ‘To̱bea si cgoa q'óè naka síí tshàam q'oo koe xháràse,’ témé, nes ga komsana xao o. ");
INSERT INTO nhr_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“C'ẽedaokam gaxao ka c'ẽe ba xháràko máá me kana ghùuan ko kòrea máá mem qãà ba úúa, ne ba gha ẽem qãáka guua hãa ne bìrí a máá: ‘Qháé naka hàà ntcõón tsam tc'õó?’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kana ba cuiskaga bìrí me naka máá: ‘Dqòa di tc'õoan tsãàgua máá te, naka tsia ẽer hãa a ko tc'õó a ko kg'áà x'aè ka kg'ónòse naka qãà te, ẽer kòo xg'ara ne tsi gha tsáá igaba thẽé tc'õó a kg'áà ke,’ téméa hãa tite? ");
INSERT INTO nhr_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Gam dim qãà ba ba gha qãè-tcaoa máá, ẽem kò bìrí me sam kúrúa hãa domka? Cuiskaga a! ");
INSERT INTO nhr_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Gaxao ka igaba i gha thẽé gatà ii: wèés gúùs ẽe xao kúrú si xao gha ka máàèa hãa sa xao kò kúrúa xg'ara ne xao gha máá: ‘Cg'ãa-cg'ana di xae qãà xae e, sixae ga kò kúrúa hãa tsééan cúí ga xae kúrúa hãa khama,’ témé,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Eẽm dàòm koe hãa a ko Jerusalema koe qõò, kam kò Jeso ba Samaria hẽé naka Galilea hẽéthẽé xg'aeku koe ko nqáé. ");
INSERT INTO nhr_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Eẽm ko c'ẽem x'áé-coam koe tcãà, ka xu kò 10 xu khóè xu lepero dis tcìì sa kò tsàara hãa xu xg'ae cgoa Me. A xu a kò nqúù ka téé ");
INSERT INTO nhr_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","a q'au a máá: “Jesoè, X'aigaè, thõò-xama máá xae e!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Eẽm ko bóò xu kam kò bìrí xu a máá: “Qõò xao peresiti xu koe naka xu síí bóò xao o,” témé. Eẽ xu ko qõò ka xu kò q'ano-q'anoè. ");
INSERT INTO nhr_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Eẽm ko gaxu ka c'ẽe ba bóòse a qãèkaguèa kam kò ka̱bise a q'aua Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Góḿankg'ai koem kò qám̀se Jesom nqàrè-kg'am koe, a ba a qãè-tcaoa máá Me. Ncẽem khóè ba kò Samaria dim khóè me e. ");
INSERT INTO nhr_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Me kò Jeso ba tẽèm cgoa xo̱a a máá: “10 xu khóè xu gáé kò qãèkaguè tama, xu c'ẽe xu 9 xu ndaa? ");
INSERT INTO nhr_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dùús domka ba ncẽem khóèm tãá za guuam cúí ba hàà ko Nqari ba dqo̱m̀?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A ba a bìrí me a máá: “Tẽe naka tsia qõò, tsari dtcòm̀a nea kg'õèkagu tsia hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Eẽ xu ko Farasai xu tẽè Me, n-cáḿa i ko Nqarim di x'aian hàà sa, kam ko xo̱a xu a máá: “Nqarim di x'aia nea qãèse ko bóòèkose hààs gúùs tama si i, ");
INSERT INTO nhr_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","kana i cuiskaga khóèan máá: ‘Bóò, ncãa ga ia,’ kana: ‘Eẽ ga ia,’ téméa hãa tite, Nqarim di x'aia nea gatu xg'aeku koe hãa khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","A ba a Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “X'aè ba ko hàà, hàà xao gha Khóèm dim Cóám di xu cáḿ xu ka c'ẽe ba bóòan xgónè ba, igaba xao cuiskaga bóò mea hãa tite. ");
INSERT INTO nhr_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Bìrí xao o ne gha a máá: ‘Eẽ síí hãa koe bóò!’ kana ‘Ncẽe koe bóò!’ témé, igaba táá qõò kana xùri ne guu. ");
INSERT INTO nhr_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Eẽm ko ma túú-tebe ba x'áà, a ko c'ẽem xòèm koe guu a síí c'ẽem xòèm koe nqarikg'aian x'áà-x'aa khama i gha ma Khóèm dim Cóám ka ii, Gam dim cáḿ ka. ");
INSERT INTO nhr_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Igaba méém kg'aia káí zi gúù zi koe xgàrase, naka baa ncẽes qhàòs ka bóòa xguìè. ");
INSERT INTO nhr_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Ncẽe i kò Nowam di cáḿan ka ii khamaga i gha Khóèm dim Cóám di cáḿan ka ii. ");
INSERT INTO nhr_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Khóè ne kòo tc'õó, a kòo kg'áà, a kòo séèku, a kòo séèkuan bìríku, me nxãakg'aiga Nowam ko arakam koe tcãàm cáḿ ba síí hàà, me kò tshàa-dxoo ba hàà, a hàà wèé ne ne kaàkagu. ");
INSERT INTO nhr_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lotem di cáḿan cgoa i ko cúí ii, khóè ne kòo tc'õó, a kòo kg'áà, a kòo x'ámá, a kòo x'ámágu, a kòo xhárà, a kòo tshào. ");
INSERT INTO nhr_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Igabaga ẽem ko Lote ba Sodoma koe guu a qõòm cáḿ kam kòo c'ee ba hẽé naka dàokom nxúì ba hẽéthẽé nqarikg'ai koe guu a hàà wèéa ne ga kaàkagu. ");
INSERT INTO nhr_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ncẽeta cgáéga i gha ii, Khóèm dim Cóám ko hàà x'áísem cáḿ ka. ");
INSERT INTO nhr_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Gaam ẽe nquuan tco̱be koe hãa, i gam di gúùan nquuan q'oo koe hãa ba méém táá xõa naka síí séè e guu; gataga méém xháràn koe hãa ba táá ka̱bise guu. ");
INSERT INTO nhr_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotem dis khóè sa tc'ẽe-tc'ẽese. ");
INSERT INTO nhr_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dìím wèém ẽe ko gam dis kg'õè sa qgóóa qari bas gha aaguse cgae, igaba dìím wèém ẽe ko Tíí domka gam dis kg'õès ka aaguse cgaeè ba gha qgóóa qari si. ");
INSERT INTO nhr_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Bìrí tu ur ko a ko máá: Eẽm ntcùúm ka i gha cám̀ khóèan cúím tcoàm koe x'óm̀a hãa, me gha cúí ba séèè, me cúí ba guuè. ");
INSERT INTO nhr_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cám̀ khóè sara gha xg'ae a ko maberean táó, si gha c'ẽe sa séèè, si c'ẽe sa guuè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Xu kò xgaa-xgaase-kg'ao xu tẽè Me a máá: “Nda koe, X'aigaè?” témé. Me xo̱a xu a máá: “Eẽ x'óóa hãam tc'áróm hãa qgáì koe i gha kg'ãéan xg'ae,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeso ba kò Gam di xu xgaa-xgaase-kg'ao xu c'ẽes sere-seres ka bìrí, wèé x'aè ka méé xu còrè, naka táá xhõen-tcáó di sa, ");
INSERT INTO nhr_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","a ba a máá: “C'ẽem x'áé-dxoom koem kò bóòa-tcg'òó-kg'ao ba hãa, Nqari ba kò q'áò tama ba, a khóè ga tchõà úú cgoa tama. ");
INSERT INTO nhr_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Si kò gataga dxàe-ntcõa sa ẽem x'áé-dxoom koe hãa, wèé x'aè ka kò ko hàà cgae me, a ko máá: ‘Tchànose bóòa tcg'òó naka tiri cg'õo-kg'aoan x'áí tchàno ra ii sa,’ témé sa. ");
INSERT INTO nhr_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Me kò gaam bóòa-tcg'òó-kg'ao ba x'aè ba xguì, igabam kò kháóka bìríse a máá: ‘Nqari bar q'áò tama, a ra a khóèan cgoa ga tchõà úú tama, ");
INSERT INTO nhr_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","igabas ko ncẽes dxàe-ntcõa sa xhõé-xhõe te domkar gha kg'uia máá si. Gatàr kò hẽé tama nes gha wèé x'aè ka qõòa máá te ka xhõe-xhõe te khama,’ témé,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kam kò X'aiga ba máá: “Tchàno úú tamam xgàra-kg'aom ko méé sa kóḿ. ");
INSERT INTO nhr_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kháé ba gáé Nqari ba cuiskaga Gam di ne khóè ne ẽem nxárá tcg'òóa hãa ne tchànoan máàna hãa tite, ncẽe ko ntcùú ba hẽé naka koaba ba hẽéthẽé Gam koe kg'ae ne? Kana ba gha hùia ne ka nqúù tcáó ii? ");
INSERT INTO nhr_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bìrí tu ur ko a ko máá: qháésem gha tchànoan máà ne, témé. Gatà i ga ii igaba ba gha Khóèm dim Cóá ba ẽem kòo nqõómkg'ai koe hàà ne hàà ẽe dtcòm̀a hãa ne hòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jeso ba kò gataga thẽé ncẽes sere-sere sa khóè ne ncẽe gane cúí ne tcomsea hãa, a c'ẽe khóèan ntcoea hãa ne bìrí, ");
INSERT INTO nhr_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","a ba a máá: “Cám̀ khóè tsara kò còrè-nquum koe qõò a ko síí còrè, c'ẽe ba kò Farasai me e, me c'ẽe ba mari xg'ae-xg'ae-kg'ao me e. ");
INSERT INTO nhr_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Farasai ba kò tẽe a còrèa mááse a máá: ‘Nqariè, qãè-tcaoar ko máá Tsi, c'ẽe ne khóè ne khamar ii tama khama, ts'ãà-kg'ao ne, cg'ãè cau ne, cg'árà-kg'ao ne, kana ncẽem mari xg'ae-xg'ae-kg'aom khamaga igaba, ");
INSERT INTO nhr_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","a ra a ko cám̀ q'oro bekem ka tc'õoan carase, a ko wèéan ẽer ko hòò koe cúís tshàu-q'oos dian tcg'òó a máà,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Igabam kò mari xg'ae-xg'ae-kg'ao ba nqúù ka téé, a ba a táá nqarikg'ai koe ga ghùi-kg'ai, a dxùua ba xg'áḿ a máá: ‘Nqariè, tíí chìbi-kg'ao ra thõò-xama máá,’ témé.” ");
INSERT INTO nhr_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Me Jeso ba bìrí ne a máá: “Bìrí tu ur ko, ncẽem khóè ba kò Nqarim cookg'ai koe tchàno iise bóòèa hãase x'áéa ba koe dìbi, c'ẽem oose; wèém khóèm ẽe ko kaikaguse ba gha cg'áré-cg'areè khama, igaba gaam ẽe ko cg'áré-cg'arese ba gha kaikaguè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","C'ẽe ne khóè nea kòo cóán Gam koe óá, nxãasegam gha hàà tshàua ba tòó cgae e ka. Eẽ xu ko xgaa-xgaase-kg'ao xu ncẽe sa bóò, ka xu kò dqàè ne. ");
INSERT INTO nhr_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Igabam kò Jeso ba cóán Gam koe tciia óá a máá: “Cóán guu naka i Tíí koe hàà. Táá xgáè-kg'am m guu! Nqarim di x'aia nea gatà ii ne di i ke. ");
INSERT INTO nhr_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tseegua ner ko bìrí tu u: Dìím wèém ẽe Nqarim di x'aian cóám ko ma séè e khama ma séè e tama ba cuiskaga gaan koe tcana hãa tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Me kò c'ẽem tc'ãà-cookg'ai ba Jeso ba tẽè a máá: “Qãè Tsi xgaa-xgaa-kg'ao Tseè, dùú sa ra gha kúrú a chõò tamas kg'õè sa hòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Me Jeso ba máá: “Dùúska tsi ko ‘Qãè Tseè’ ta ma tcii Tea máá? Cúí khóè ga qãè tama igaba Nqarim cúí Me e ka. ");
INSERT INTO nhr_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","X'áèan tsi q'ana: ‘Táá cg'áràn kúrú guu, táá cg'õo guu, táá ts'ãà guu, táá tshúù-ntcõan nxàe guu. Saò ba hẽé naka saò sa hẽéthẽé tcom,’ ta ko méé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Me xo̱a a máá: “Cg'áré-q'ooa te koe gar guu a ko ncẽe x'áèan wèé ga komsana,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eẽm ko Jeso ba ncẽes gúù sa kóḿ kam kò bìrí me a máá: “Cúís gúùs qanega tsi tcàoa sa ncẽe si i: X'ámágu wèés gúùs ẽe tsi úúa hãa sa naka tsia ẽe dxàua hãa ne khóè ne marian sama, naka tsia nqarikg'ai koe x'aian úú, naka tsia hàà xùri Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Igaba ẽem ko ncẽe sa kóḿ kam kò kaisase tshúù-tcao, kaisase qguùam khóè me e kò ii khama. ");
INSERT INTO nhr_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Me kò Jeso ba bóò me, a máá: “Tsóágase i gáé qaria, ẽe káí mari a qguùa hãa ne gha Nqarim di x'aian koe tcãà sa. ");
INSERT INTO nhr_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Thamka a kameles gha dqààm tcgáí dim kòm̀ koe tcg'oa sa, qguùam khóèm gha Nqarim di x'aian koe tcãàn ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ne kò ẽe ko kóḿ m ne tẽè a máá: “Kháé ba gha nxãaska dìí ba kgoaraè?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Me Jeso ba xo̱a a máá: “Gúù zi ncẽe khóè ne ko tàà zia Nqari ba tàà tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Me Petere ba máá: “Bóò, sixaea x'áéa xae guu a ko xùri Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Me Jeso ba bìrí xu a máá: “Tseegua ner ko bìrí xao o: Khóèm ẽe Nqarim di x'aian domka x'áéa ba, kana gam dis khóè sa, kana qõea ba, kana gam ka xõòga ne, kana cóáa ba guua hãa ba káà me e, ");
INSERT INTO nhr_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ncẽe gha ncẽem x'aèm ka káían máàè tamase kg'ama tcg'oa ba, naka hààkos kg'õès chõò tamas koe hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeso ba kò 12 xu xgaa-xgaase-kg'ao xu cúía séèa tcg'òó a bìrí xu a máá: “Bóò! Jerusalema koe xae ko qõò, si gha wèés gúùs ẽe porofiti xu ka Khóèm dim Cóám ka góáèa hãa sa tseegukaguè. ");
INSERT INTO nhr_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tãá zi qhàò zi tshàu q'oo koem gha tcãàè, ne gha nco̱i Me, a cóè Me, a tcg'ae cgae Me, ");
INSERT INTO nhr_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","a qoa Me, a cg'õo Me, Me gha nqoana dim cáḿ ka x'ooan koe tẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Igaba xu kò xgaa-xgaase-kg'ao xu táá cúí gúù ga kóḿa q'ãa, ncẽe zi kg'ui zi ko nxàe sa kò gaxu koe chóm̀sea hãa khama, xu kò c'úùa hãa dùútsa gúùs kam ko kg'ui sa. ");
INSERT INTO nhr_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Eẽm ko Jeso ba Jeriko sao-xg'ae kam kò káà tcgáím khóè ba dàòm dxùukg'ai koe ntcõóa-ntcõe a ko dtcàrà. ");
INSERT INTO nhr_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Eẽm ko xg'ae sa kóḿ si ko nqáé kam ko tẽè, dùús ko kúrúse sa. ");
INSERT INTO nhr_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ne bìrí me a máá: “Jesom Nasareta di ba ko nqáé,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Me q'au a máá: “Jesoè, Dafitem ka tsgõose-coa Tseè, thõò-xama máá te,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ne kò khóè ne ẽe ko còoka hãa ne dqàè me a máá, nqoo méém, témé, igabam kò kaisase q'au a máá: “Dafitem ka tsgõose-coa Tseè, thõò-xama máá te,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Me kò Jeso ba téé, a ba a x'áèan tcg'òó, káà tcgáím khóèm gha Gam koe óágaè sa. Eẽm ko Gam koe cúù kam ko Jeso ba tẽè me a máá: ");
INSERT INTO nhr_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Dùú sar gha kúrúa máá tsi sa tsi ko tc'ẽe?” témé, me máá: “X'aigaè, bóòr gha sar ko tc'ẽe,” ta ma xo̱a. ");
INSERT INTO nhr_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Me Jeso ba bìrí me a máá: “Xgobekg'amsen tcgáí, tsari dtcòm̀a nea qãèkagu tsia hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Me kò kúúga bóò, a ba a xùri Me, a Nqari ba dqo̱m̀. Ne kò wèé ne khóè ne ncẽes gúù sa ne ko bóò ka Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Me kò Jeso ba Jeriko koe tcãà, a ba a ko nqáé. ");
INSERT INTO nhr_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Gaa x'aè kagam kò c'ẽem khóèm Sakaio ta kò ma tciiè ba hãa; kaiam mari xg'ae-xg'ae-kg'ao me e kò ii, a ko gataga qguùa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Bóò kg'oanam kò hãa Jeso ba dìí Me e sa, igabam kò kaisase xòm̀ me e khama táá bóò Me, khóè nea kò káí ne e khama. ");
INSERT INTO nhr_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kam ko còoka qàròa síí, a ba a síí faia dis hìi sa q'ábà, nxãasegam gha Jeso ba bóò ka, gaa xòè koe méém hàà nqáé khama. ");
INSERT INTO nhr_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eẽm ko Jeso ba gaam qgáìm koe hàà kam ko ghùi-kg'ai a bìrí me a máá: “Sakaioè, qháése xõa, tsarim nquum koe méér ncẽem cáḿ ka hãas gúù si i ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Me kò qháése xõa, a qãè-tcaoase Jeso ba qãèse hààkagu. ");
INSERT INTO nhr_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wèé ne khóè ne ko ncẽes gúù sa bóò ka ne ko kg'ui a máá: “Kaiam chìbi-kg'aom dim dàra-kg'ao bam kúrúa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Igabam kò Sakaio ba tẽe a X'aiga ba bìrí a máá: “Bóò, X'aigaè; tiri zi gúù zi di c'ẽe xòèa ner ko dxàua ne khóè ne máà, a ncẽè c'ẽe khóèa ner kò kàaraa hãa ner gha gaan di zi gúù zi 4 q'oro suruta ka̱bi,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Me kò Jeso ba bìrí me a máá: “Ncẽem cáḿ ka i kgoarasean ncẽem nquum koe hãa, ncẽem khóèm igabam thẽé Abrahamam ka cóáse me e khama. ");
INSERT INTO nhr_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Khóèm dim Cóá ba hààraa, hààm gha ẽe aagusea hãa ne qaa a kgoara ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Khóè ne hãa a ko ncẽe zi gúù zi komsana kam kò Jeso ba sere-seres ncẽe sa bìrí ne. Jerusalema qàe koem kò hãa khama ne kò khóè ne tc'ẽea máá, Nqarim di x'aia nea gha kúúga x'áíse, ta tc'ẽea. ");
INSERT INTO nhr_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Gaa domkam kò máá: “C'ẽem khóèm x'aigan x'áé di ba kò nqúùm nqõóm koe qõò, síím gha x'aiga ba kúrúè, a x'aiga iise ka̱bise ka. ");
INSERT INTO nhr_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Qõòm ko cookg'ai koem kò 10 qãà xu gam di xu tcii, a wèém khóè ba qano dim marim gautan di ba máà, a bìrí xu a máá: ‘Tseekagu ncẽe maria ne naka i káí nakar nxãakg'aiga síí ka̱bise na hàà,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Igabaga ne kò gam nqõóm di ne khóè ne hòre mea hãa, khama ne kò khóèan tsééa tcg'òó i còò me a síí máá: ‘Ncẽem khóèm gha sita dim x'aiga ba ii sa ta tc'ẽe tama,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Me kò gaam khóè ba síí x'aiga ba kúrúè a ba a x'áéan koe ka̱bise. Kam kò x'áèan tsééa tcg'òó, qãà xu ẽem kò marian máàna hãa xum gha tciia mááè di i, nxãasegam gha q'ãa, marian cgoa xu ma tsééa i ma càùsea hãa sa ka. ");
INSERT INTO nhr_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Me kò kg'aika di ba tc'ãà a hàà, a hàà máá: ‘X'aigaè, tsarim mari ba 10 xu mari xu cgoa càùsea hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Me bìrí me a máá: ‘Qãèse tsi kúrúa, qãè tsi qãà tseè, cg'áré gúùan koe tsi tcom-tcomsa tsi qãà tsi i domkar gha 10 xu x'áé-dxoo xu máà tsi tsi tc'ãà-cookg'ai,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Me kò cám̀ di ba hàà a ba a máá: ‘X'aigaè, cúím marim ẽe tsi kò máà tea ba 5 mari xu cgoa càùsea hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Me bìrí me a máá: ‘Tsáá tsia gha 5 xu x'áé-dxoo xu tc'ãà-cookg'ai,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Me kò c'ẽem qãà ba hàà a máá: ‘X'aigaè, bóò, ncãa ga me e tsarim marim qano di ba; lapim koer kò tcáḿ a chóm̀a tòó mea, ");
INSERT INTO nhr_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","xgóà tsi khóè tsi i khama, ra kò ko bèe tsi domka. Eẽ tsi tòó tama sa tsi ko séè, a tsi a ko xhárà tama tsia koe ga tcuù,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Me kò bìrí me a máá: ‘Tsari kg'uian cgoar gha xgàra tsi, tsáá cg'ãè cau tsi qãà tsi. Q'ana tsi kò hãa xgóàr khóè ra a, a ko ẽer tòó tama sa séè, a ra a ko ẽer xhárà tama koe ga tcuù sa, ");
INSERT INTO nhr_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ka tsi kò kháé nxãaska dùús domka tiri marian síí marian ko tòóè qgáì koe tcãà tama? Nakar gha ẽer ko ka̱bise ka hàà càùsea i hãa koe séè e?’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Me kò nxãaska ẽe cúùse tẽe ne bìrí a máá: ‘Mari ba séè cgae me, naka ẽe 10 xu mari xu úúa hãa ba máà me,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ka ne ko bìrí me a máá: ‘X'aigaè, 10 xu mari xum nxãakamaga úúa!’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Me kò xo̱a ne a máá: ‘Bìrí tu ur ko, wèém khóèm ẽe úúa hãa ba gha káían máàè, igaba gaam ẽe cúí gúù ga úú tamam ka i gha ẽem úúa hãa gúù-coan ga séèè. ");
INSERT INTO nhr_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Igaba ncẽeska tiri ne cg'õo-kg'ao ne ẽe kò tc'ẽe tama gane dim x'aiga bar gha ii sa ne ncẽe koe óága, naka cookg'aia te koe cg'õo ne,’ tam méé.” ");
INSERT INTO nhr_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jesom ko ncẽe zi gúù zi kg'uia xg'ara kam ko tc'ãà-cookg'ai xu, a Jerusalema koe qõò. ");
INSERT INTO nhr_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eẽm ko Betefage hẽé naka Betania hẽéthẽé koe cúù, Olife ta ko ma tciièm xàbìm koe, kam kò Jeso ba cám̀ tsara xgaa-xgaase-kg'ao tsara tsééa tcg'òó a máá: ");
INSERT INTO nhr_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Qõò tsao gatsao cgoa q'óá-kg'amkuam x'áém koe. Eẽ tsao ko gaa koe tcãà ne tsao gha donghi-coa ba bóò, me gaa koe qáésea tẽe, ncẽe cúí khóè ga qanega qábì tama ba. Kgoara naka Tíí koe óá me. ");
INSERT INTO nhr_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A ncẽè c'ẽe khóè kòo tẽè tsao o, dùúska tsao ko kgoara me sa ne méé tsao bìrí i naka máá: ‘X'aiga ba ko qaa me,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Eẽ kò tsééèa hãa tsara kò qõò a síí ẽem kò ma bìrí tsara hãa khamaga ma sao-xg'ae me. ");
INSERT INTO nhr_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eẽ tsara hãa a ko donghi-coa ba kgoara ka ne kò gam ka q'õòse ga ne tẽè tsara a, a máá: “Dùús domka tsao ko ẽem donghi-coa ba kgoara máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tsara xo̱a a máá: “X'aiga ba ko qaa me,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","A tsara a Jesom koe óá me, a gatsara di qgáían donghi-coam koe tcee, Me Jeso ba qábì. ");
INSERT INTO nhr_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eẽm ko qábì a ko qõò ka ne kò khóè ne qgáía ne dàòm q'oo koe khárà. ");
INSERT INTO nhr_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eẽm ko dàòm ko nqãaka xõam qgáìm koe cúù, Olife dim xàbìm koe kas ko wèés xg'aes xgaa-xgaase-kg'ao ne di sa qãè-tcaoase tshoa-tshoa a kaiam dòm̀ cgoa Nqari ba dqo̱m̀, are-aresa zi x'áí zi wèé zi ẽe ne bóòa hãa zi domka. ");
INSERT INTO nhr_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","A ne a máá: “Ts'ee-ts'eekg'aièa baa, X'aigam ẽe ko X'aigam Nqarim di cg'õèan cgoa hàà ba. Tòókuan méé i nqarikg'ai koe hãa naka i x'áàn kaisase tc'amaka hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Xu kò c'ẽe xu Farasai xu xg'aes koe kò hãa xu Jeso ba bìrí a máá: “Xgaa-xgaa-kg'ao Tseè, Tsari ne xgaa-xgaase-kg'ao ne dqàè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Me Jeso ba xo̱a xu a máá: “Bìrí xao or ko: ncẽè nqoo ne kòo, ne zi gha nxõ̱á zi tshoa-tshoa a q'au,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Eẽm ko Jerusalema dim x'áé-dxoom koe cúù a ko bóò me, kam kò kg'ae-kg'ai me ");
INSERT INTO nhr_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a máá: “Tsóágaser gáé ko tc'ẽe, tòókuan ko óá zi gúù zi tsi gha ncẽe cáḿ ka q'ana hãa sa! Igaba zi ncẽeska tcgáí-q'ooa tsi koe chóm̀sea hãa. ");
INSERT INTO nhr_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cáḿ ba gha hàà cgae tsi, tsari ne cg'õo-kg'ao ne gha xhàro ba kúrúa nxa̱ma-nxa̱ma tsi ba, a xg'aekua ne koe tcãà tsi, wèé xòèa tsi koe guu a. ");
INSERT INTO nhr_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Góḿankg'ai koe ne gha xàbùa qáú tsi, tsáá hẽé naka cóáa tsi hẽéthẽé e. A ne a tsáá koe cúís nxõ̱ás ga sa c'ẽes tc'amkg'ai koe guua hãa tite, táá tsi kò Nqarim ko hàà cgae tsim x'aè ba bóòa tcg'òó khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kam ko tempelem q'oo koe tcãà, a ba a ẽe ko x'ámágu ne tshoa-tshoa a tchàa za xhàia tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","A ba a bìrí ne a máá: “Góásea i hãa a ko máá: ‘Tirim nquu ba gha còrèan dim nquu ba ii,’ téméè, igaba tu gatu ts'ãà-kg'ao ne di x'ãè-q'ooan kúrú mea,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Wèé cáḿ kam kòo Jeso ba tempelem koe xgaa-xgaa. Xu kò kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽé, naka tc'ãà-cookg'ai-kg'ao xu khóè ne di xu hẽéthẽé cg'õo Me kg'oana. ");
INSERT INTO nhr_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Igaba xu kò cúím dàòm cg'õo cgoa Me xu gham ga ba hòò tama, wèé ne khóè nea kò Gam di kg'uian qarika komsana khama. ");
INSERT INTO nhr_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","C'ẽe cáḿ kam kò Jeso ba tempelem koe hàna a ko xgaa-xgaa, a ko qãè tchõàn chóà máá ne, ka xu kò kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽé naka khóè ne di xu kaia xu hẽéthẽé hàà cgae Me. ");
INSERT INTO nhr_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","A xu a bìrí Me a máá: “Bìrí xae e, dùútsa qari cgoa Tsi ko ncẽe zi gúù zi kúrú sa, kana dìí na ncẽe qarian máà Tsia hãa ncẽe zi gúù zi kúrú di i sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Me Jeso ba xo̱a xu a máá: “Tíí igabar gha tẽè xao o. Ke bìrí Te, ");
INSERT INTO nhr_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Johanem dis tcguù-tcguuku sa kò nqarikg'ai koe guua kana khóèan koea?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ka xu ko tshoa-tshoa a chóà mááku a máá: “‘Nqarikg'ai koe e,’ ta xae kòo méé nem gha máá: ‘Dùúska xao kháé nxãaska dtcòm̀ me tama?’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Igaba xae kò ko máá: ‘Khóèan koe e,’ témé ne ne gha wèé ne khóè ne nxõ̱án cgoa xg'áḿa cg'õo xae e, Johane ba kò porofiti me e sa ne kò tcoma hãa khama,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ka xu ko xo̱a a máá: “C'úùa xae hãa nda koe i guua sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Me Jeso ba bìrí xu a máá: “Tíí igabar nxãaska bìrí xao o tite, dùútsa qaris cgoar ko ncẽe zi gúù zi kúrú sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Me kò tshoa-tshoa a ncẽes sere-sere sa khóè ne bìrí a máá: “C'ẽem khóè ba kò kg'om xhárà ba xháràa, a ba a c'ẽe xu xhárà-kg'ao xu cgóbè me, a c'ẽem nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","“Eẽm ko x'aè ba hàà kam kò xhárà-kg'ao xu koe qãà ba tsééa úú, nxãasega xu gha kg'om xháràm di tc'õoan c'ẽe máà me ka. Igaba xu kò xhárà-kg'ao xu xg'áḿ me, a káà gúùse tsééa ka̱bi me. ");
INSERT INTO nhr_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Me gaia c'ẽem qãà ba tsééa úú cgae xu, xu síí xg'áḿ me, a sau-saugase qgóó me, a xu a káà gúùse tsééa ka̱bi me. ");
INSERT INTO nhr_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Kam ko nqoana dim qãà ba tsééa úú. Xu nxãa ba thõò-thõo, a xu a tchàa za xaoa tcg'òó me. ");
INSERT INTO nhr_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Kam kò kg'om xháràm ka q'õòse ba máá: ‘Dùú sa ra gha kúrú? Tirim cóám ncàm̀a ra hãa bar gha tsééa úú, c'ẽedaoka xu gha tcom me khama,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Igaba ẽe xu ko xhárà-kg'ao xu bóò me ka xu ko bìríku a máá: ‘Ncẽe ba xháràm ka q'õòsem ka cóáse me e! Ke hààn xae cg'õo me, naka zi gha nxãasega gúù zi sixae di ii,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Xu kò kg'om xháràm ka tchàa koe xaoa tcg'òó me, a cg'õo me. “Kháé ba gha nxãaska xháràm ka q'õòse ba dùú sa kúrú xu? ");
INSERT INTO nhr_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Hààm gha a ba a ẽe xu khóè xu cg'õo, a ba a kg'om xhárà ba c'ẽe xu xhárà-kg'ao xu máà,” tam Jeso ba méé. Khóè ne ko ncẽes gúù sa kóḿ, ka ne kò máá: “Táá méés ncẽes gúù sa kúrúse guu!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Igabam kò Jeso ba bóò ne a máá: “Kháé nxãaska ncẽe Nqarim dis Tcgãyas koe góásea hãa sa ko dùú sa nxàe, ncẽe ko máá: ‘Nxõ̱ás ncẽe tshào-kg'ao xu ka bóòa xguìèa hãa sa ncẽeska ka̱bise a cgáés nxõ̱á sa kúrúa hãa,’ témé sa? ");
INSERT INTO nhr_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Wèém khóèm ẽe gha gaas nxõ̱ás koe cg'áé ba gha khoana tòm̀-tomse, igaba ẽes kòo c'ẽe khóèan koe cg'áé nes gha tòm̀-tom m,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xu kò x'áè xgaa-xgaa-kg'ao xu hẽé naka kaia xu peresiti xu hẽéthẽé xu gaa x'aè kaga Jeso ba qáé kg'oana, ẽes sere-seres kam kòo gaxua nxàe xu sa xu kò q'ana hãa khama, igabaga xu kò ko khóè ne bèe. ");
INSERT INTO nhr_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","A kòo dàòan qaa, qgóó cgoa Me xu gha a, a xu a kò khóè xu dtcòm̀-kg'aoan khama ko ma qgóóse xu Gam koe tsééa úú, síí xu gha Jeso ba ẽem kg'uia hãa kg'uian cgoa qgóó ka, nxãasega xu gha x'áé-dxoom dim kaiam koe séè a úú Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Xu Jeso ba tẽè a máá: “Xgaa-xgaa-kg'ao Tseè, q'ana xae hãa, tseeguse Tsi ko xgaa-xgaa a ko tseegu sa kg'ui sa, a Tsi a khóèan tãákase qgóó tama, igabaga Tsi ko tseeguse Nqarim dim dàò ba xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Bìrí xae e, Roma ne dim x'aigam Kaesara ba méé xae suruta saa, kana méé xae táá suruta me?” ta xu ma tẽè Me. ");
INSERT INTO nhr_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Me Jeso ba gaxu dis kàa sa bóòa q'ana hãase bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“X'aigam ko suruta cgoaèm qano mari ba x'áí Te. Dìín dis tcúú sa ncẽe sa, naka gatàa dìín di cg'õèa ncẽe e?” témé. Xu máá: “Kaesaram di si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Me bìrí xu a máá: “Nxãaska xao ẽe Kaesaram di ii sa Kaesara ba máà, naka ẽe Nqarim di ii sa Nqari ba máà,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Xu kò khóè ne cookg'ai koe xu gha ma ẽem ko méé gúùan ka qgóóa ba ka tààè, igaba xu kò Gam di xo̱an ka arekaguè a nqoo. ");
INSERT INTO nhr_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","C'ẽe ne Saduke ne, khóèan x'ooan koe tẽe tamas koe dtcòm̀a hãa, nea ko Jesom koe hàà, a hàà tẽè Me a máá: ");
INSERT INTO nhr_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Xgaa-xgaa-kg'ao Tseè, Moshe ba ko x'áèan ncẽe góá máá ta a a ko máá: ẽem ko khóè ba káà cóáse dxàese sa guu a x'óó, ne méém ẽem khóèm ka qõese ba gaas dxàe-ntcõa sa séè naka káímkhoem ẽe x'óóa hãa ba cóán ábà máá. ");
INSERT INTO nhr_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nxãaska xu kò 7 xu khóè qõeku xu hãa. Kaia ba kò séèa hãa a ba a cóá úú tamase x'óó. ");
INSERT INTO nhr_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Me cám̀ di ba gaas khóè sa séè, a x'óó thẽé, ");
INSERT INTO nhr_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","me nqoana di ba séè si, xu kò wèéa xu ga cúí ta ga ma táá cóán ábà, a xu a x'óó. ");
INSERT INTO nhr_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Si ko thẽé khóès ga sa x'óó. ");
INSERT INTO nhr_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ka sa gha nxãaska x'ooan koe ne ko tẽe ne ndakam di sa ii? Wèéa xu 7 xu kò séè sia hãa ka. ");
INSERT INTO nhr_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Me Jeso ba xo̱a xu a máá: “Khóè xu ncẽem x'aèm di xua ko séè, a séèkuan máàèa. ");
INSERT INTO nhr_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Igaba khóè ne ncẽe hààkom x'aèm koe gha kg'õè ne hẽé, naka x'ooan koe gha tẽe ne hẽéthẽéa séèku tite, a séèkuan koe tcãà tite. ");
INSERT INTO nhr_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Gaicara ne x'óó tite khama, moengelean cgoa ne cúíta noo, a ne a Nqarim di ne cóá ne e khama, a x'ooan koe tẽea ne cóá ne e khama. ");
INSERT INTO nhr_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Igaba x'óóan koe i ko khóèan ghùiè sam kò Moshem ga ba x'áía hãa, ẽem kò c'eean dis xg'aekus koe X'AIGAM Nqarim Abrahamam di ba hẽé, naka Isakam di ba hẽé, naka Jakobem di ba hẽéthẽé tcii me koe. ");
INSERT INTO nhr_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Eẽ x'óóa hãa ne dim Nqarim tama Me e, igabam ẽe kg'õèa hãa ne di Me e, wèéa ne ga ko Gam koe kg'õè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Xu kò c'ẽe xu x'áè xgaa-xgaa-kg'ao xu xo̱a a máá: “Xgaa-xgaa-kg'ao Tseè, qãèse Tsi xo̱ara hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Khóè nea kò bèe, c'ẽe tẽè ga ne gha tẽè Me sa khama. ");
INSERT INTO nhr_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Me Jeso ba tẽè ne a máá: “Dùúska ne ko khóè ne máá, Kreste ba Dafitem dim Tsgõose-coa Me e, témé? ");
INSERT INTO nhr_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dafite ba ko Pesalema zi dis Tcgãyas koe bìrí me a máá: ‘X'aiga ba ko Tirim X'aiga ba bìrí a máá: ‘Kg'áò xòèa Te za ntcõó, ");
INSERT INTO nhr_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","nakar nxãakg'aiga síí Tsari cg'õo-kg'aoan kúrú naka i nqàrè-kg'ama Tsi koe ntcõó,’ témé.’ ");
INSERT INTO nhr_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dafite ba ko X'aiga ta ma tcii Me, ka ba kháé nxãaska ntama ma Gam dim tsgõose-coa ba ii?” tam ma tẽè ne. ");
INSERT INTO nhr_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wèé ne khóè ne ko komsana Me koem ko Jeso ba Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: ");
INSERT INTO nhr_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“X'áè xgaa-xgaa-kg'ao xu koe méé xao q'õésea hãa, ncẽe ko qáò qgáí-dxooan hã̱a a caatean ncàm̀aa hãa xu, a x'ámágu di zi qgáì zi koe tsgám̀kuan hẽé naka kaia zi ntcõó-q'oo zi còrè-nquu xu koe hàna zi ncàm̀a hãa xu, naka cgáé zi ntcõó-q'oo zi hẽéthẽé e kõ̱èan di qgáìan koe. ");
INSERT INTO nhr_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ncẽe ko dxàe-ntcõa zi di nquuan kaàkagu xu, a ko qáòse còrèan ka x'áíse tu u xu. Gaxu di xgàraè-q'ooa ne gha kaisase cg'ãè ii,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jeso ba kò ghùi-kg'ai a tempelem koe qguùa ne khóè ne bóò ne ko aban dis gàbas koe aban tòó. ");
INSERT INTO nhr_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kam kò kaisase dxàua hãas dxàe-ntcõa sa bóò si hàà cám̀ qano mari tsara tòó. ");
INSERT INTO nhr_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Kam ko máá: “Tseegua ner ko bìrí tu u: Ncẽes dxàe-ntcõas dxàua hãa sa wèé ne khóè ne nqáéa hãase marian tcana. ");
INSERT INTO nhr_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wèé ne khóè nea kò gane di qguùan koe guu a gane di aban tcg'òó, igabas kò gaa sa gas di dxàuan koe guu a wèéan ẽes úúa hãa ga tcg'òó khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Eẽ xu c'ẽe xu xgaa-xgaase-kg'ao xu hãa a ko tempelem ka kg'ui, a ko me ma t'õè nxõ̱án ka hẽé naka khóè ne koe guua hãa zi aba zi, Nqari ba ne tcg'òóa máána hãa zi ka hẽéthẽé ma t'õè-t'õeèa hãa sa nxàe, kam ko Jeso ba máá: ");
INSERT INTO nhr_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gúù zi ncẽe tu ko ncẽe koe bóò zi ka: x'aè ba gha hàà, cúís nxõ̱ás ga sa c'ẽes tc'amkg'ai koe guuèa hãa tite ba, wèéa zi ga gha xòóa qàrìè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Xu xgaa-xgaase-kg'ao xu tẽè Me a máá: “Xgaa-xgaa-kg'ao Tseè, n-cáḿa zia gha ncẽe zi gúù zi kúrúse? Si gha thẽé x'áís gúù zi ncẽe zi ko hàà kúrúse di sa nta ii?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Me xo̱a a máá: “Q'õésea méé tu hãa, naka tua táá ho̱àkaguè guu, káí ne gha Tíí cg'õè cgoa hàà ke, a gha khóè ne bìrí a máá: ‘Tíí ra Krester ga ra a,’ témé, a ne a gha máá: ‘X'aèa nea cúù u,’ témé, igaba méé tu táá komsana ne guu. ");
INSERT INTO nhr_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Igaba ẽe tu kò ko ncõoan hẽé naka kóḿku taman hẽéthẽé ko kóḿ ne méé tu táá q'ae guu. Ncẽe zi gúù zi méé zi kg'aika kúrúses gúù si i ke, igaba i chõò-q'ooan kúúga hàà tite,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Me gaicara bìrí xu a máá: “Nqõóm di zi qhàò zi gha c'ẽe zi qhàò zi cgoa x'ãàku, i gha x'aian x'aian cgoa x'ãàku. ");
INSERT INTO nhr_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kaisasem gha nqõó ba cgùru, i gha kaisa xàbàn hẽé naka tcììan hẽéthẽé káí xu nqõó xu koe hãa, q'áò-q'áòsa zi gúù zi hẽé naka kaia zi x'áí zi are-aresa zi hẽéthẽéa gha nqarikg'ai koe guu a kúrúse. ");
INSERT INTO nhr_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Igaba ncẽe zi gúù zi wèé zi cookg'ai koe, ne gha tshàua ne cgoa qgóó tu u, a gha xgàra tu u, a gha còrè-nquuan koe úú tu u qhàìan koe, a ne a gha qáé-nquuan koe tcãà tu u, tu gha x'aigan hẽé, naka tc'ãà-cookg'ai xu koe hẽéthẽé úúè, i gha wèéan ncẽe ga Tiri cg'õèan domka kúrúse. ");
INSERT INTO nhr_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ncẽe ba gha x'aè ba ii ncẽe gatu gha Nqarim di kg'uian nxàea tseegukagu di ba. ");
INSERT INTO nhr_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Igaba méé tu x'aèan cookg'ai koe ga tc'ẽea ka̱bi naka gha nxãasega táá káíse tc'ẽe-tc'ẽese guu nta tu gha ma xo̱ara mááse sa. ");
INSERT INTO nhr_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kg'uian hẽé naka tc'ẽean hẽéthẽér gha máà tu u khama, i gha wèé cg'õo-kg'aoan gatu di táá qarian hòò a xguì kana ntcoe tu u. ");
INSERT INTO nhr_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Gatu di ne khóè ne, ncẽe gatu di qõe ii ne hẽé, naka gatu di ne qhàò ne hẽé, naka gatu di ne tcárà ne hẽéthẽéa gha qáé tu u, a gha gatu ka c'ẽea tu x'ooan koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tu gha Tiri cg'õèan domka wèé khóèan ka hòreè. ");
INSERT INTO nhr_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Igabam cúím c'õòm tcúúa tu dim ga ba kaà tite. ");
INSERT INTO nhr_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Gatu di qarika tééan ka tu gha kg'õèan hòò. ");
INSERT INTO nhr_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Eẽ tu kòo Jerusalema ba bóò, me ncõo-kg'aoan ka nxa̱ma-nxa̱maèa, ne méé tu q'ãa, gam di x'aèan kaàkaguèm koa cúù u sa. ");
INSERT INTO nhr_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ke méé ne ẽe Jutea koe hàna ne xàbìan koe qgóéa síí, naka ne ẽe Jerusalema koe hàna ne tcg'oa naka nea táá hẽé naka ne ẽe x'áé-coa xu koe hàna ne Jerusalemam koe tcãà guu. ");
INSERT INTO nhr_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ncẽe ba gha xgàrakus dim x'aè me e, wèés gúùs ẽe Nqarim di zi Tcgãya zi koe góásea hãas gha tseegukaguè ba. ");
INSERT INTO nhr_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Haò, cg'ãè i gha ii, ẽe zi cáḿ zi ka ẽe ncãà zi koe cóán úúa zi khóè zi ka hẽé naka ẽe gha ko comkagu zi ka hẽéthẽé e. Kaias thõò-tcao sa hẽé naka Nqarim di xgóàn hẽéthẽéa gha ncẽe ne khóè ne koe nqõómkg'ai koe hãa. ");
INSERT INTO nhr_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ntcàum cgoa ne gha cg'õoè, a ne a gha qáé-nquuan di ne khóè ne iise séèè, a wèé zi qhàò zi koe úúè, Jerusalema ba gha tãá zi qhàò zi ka náà c'ãa-c'anaè, i gha nxãakg'aiga síí x'aèan tãá zi qhàò zi di xg'ara. ");
INSERT INTO nhr_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“X'áí zi tãá zia gha cáḿs koe hẽé naka nxoem koe hẽé, naka tco̱nòan koe hẽéthẽé kúrúse. Zi gha kaiam tshàam di ts'oo-q'ooan hẽé naka qhonèan hẽéthẽé ka nqõómkg'ai di zi qhàò zi qóḿ ba hẽé naka arean hẽéthẽé ka tcãà cgaeè. ");
INSERT INTO nhr_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Khóè nea gha q'aean hẽé naka tc'ẽea ne ko máá zi gúù zi ka hẽéthẽé x'óóa qae, nqõómkg'ai koe ko hàà kúrúse zi gúù zi domka, nqarikg'aian di qaria ne gha ko hàà ntcãa-ntcãaè khama. ");
INSERT INTO nhr_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Eẽm x'aèm ka ne gha Khóèm dim Cóá ba bóò Me túú-c'õòs q'oo koe guu a ko qarian hẽé naka kaia x'áàn hẽéthẽé cgoa hàà. ");
INSERT INTO nhr_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ncẽe zi gúù zi ko hàà tshoa-tshoa a ko kúrúse ne, tẽea-téé naka ghùi-kg'ai, gatu di kgoarasea nea cúù u ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Me kò Jeso ba ncẽes sere-sere sa bìrí xu a máá: “Faia dis hìi sa hẽé naka c'ẽe zi hìi zi wèé zi hẽéthẽé bóò. ");
INSERT INTO nhr_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Eẽ i ko gazi di to̱aran tso̱m, ne tu ko bóòa mááse a q'ãa qhóóa ne tcana hãa sa. ");
INSERT INTO nhr_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gataga ẽe xao kòo ncẽe zi gúù zi bóò zi ko kúrúse ne xao q'ana hãa, Nqarim di x'aia ne cúù u sa. ");
INSERT INTO nhr_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Tseegukar ko bìrí tu u a ko máá: Ncẽes qhàò sa kaà tite, i gha nxãakg'aiga síí ncẽe gúùan wèé ga kúrúse. ");
INSERT INTO nhr_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nqarikg'aian hẽé naka nqõókg'aian hẽéthẽéa gha chõò, igaba i Tiri kg'uian chõò tite. ");
INSERT INTO nhr_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Q'õése méé tu, naka i tcáóa tu táá ka̱rean nqõóm di ka tààè guu, kana qgarìan nqàre ka igaba, kana kg'õèan di zi tc'ẽe-tc'ẽese-kg'áḿ zi ka igaba, tcom tama tu hãa koem gha ẽem cáḿ ba hàà cgae tu u ke, ");
INSERT INTO nhr_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","a gha wèé ne khóè ne, ncẽe wèém nqõómkg'ai koe x'ãèa hãa ne koe ntcóm̀mèa ne hãa khama ma hàà cgae. ");
INSERT INTO nhr_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Wèé x'aè ka méé tu kókòa hãa, naka tua còrèa mááse, naka tua gha nxãasega qarian úúa hãa wèé gúùan ẽe gha ko hàà kúrúse koe tu gha nxana mááse di i, naka tua gha nxãasega Khóèm dim Cóám cookg'ai koe hàà téé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Wèém koaba bam kòo Jeso ba tempelem koe xgaa-xgaa, a kòo wèé dqòa ka Olife dim xàbìm koe síí hãa. ");
INSERT INTO nhr_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","I kòo wèé khóèan ntcùúkg'ai cgoa tempelem koe hàà cgae Me, a hàà komsana Me. ");
INSERT INTO nhr_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Paseka ta ko ma tciièm x'aèm, péré gãé-gãe úú tamas pérés dis kõ̱ès di ba kò cúù me e, ");
INSERT INTO nhr_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","xu kò kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xu kàan qaa, xu ga ma cg'õo Me di i, khóè ne xu kòo q'áò khama. ");
INSERT INTO nhr_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Kam ko nxãaska satana ba Jutase Isekariote ta ko ma tciièm, 12 xu xgaa-xgaase-kg'ao xu ka c'ẽem koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Me Jutase ba tẽe a ba a síí kaia xu peresiti xu hẽé naka, tempele ba ko kòre xu x'aiga xu hẽéthẽé cgoa chóà xg'ae, Jeso bam ga ntama ma tshàu q'ooa xu koe tcãàs ka. ");
INSERT INTO nhr_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xu kò qãè-tcao a xu a marin xu gha máà me sa dtcòm̀ku. ");
INSERT INTO nhr_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Me kò Jutase gaxu cgoa dtcòm̀ku, a ba a tshoa-tshoa a qãèm x'aè ba qaa, khóè ne c'úùasem gha Jeso ba gaxu tshàu q'oo koe tcãà di ba. ");
INSERT INTO nhr_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Me kò péré gãé-gãe úú tamas pérés di kõ̱èan dim cáḿ ba hàà, Paseka dim ghùu-coam ko cg'õoèm x'aè ba. ");
INSERT INTO nhr_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Me nxãaska Jeso ba Petere ba hẽé naka Johane ba hẽéthẽé tsara tsééa úú ncẽe x'áè-kg'áḿan cgoa a máá: “Qõò naka síí Paseka di tc'õoan kg'ónòa máá xae e naka xae nxãasega tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tsara tẽè Me a máá: “Nda koe xae gha kg'ónòa máá Tsi i sa Tsi ko tc'ẽe?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Me xo̱a tsara a, a máá: “Bóò, ẽe tsao ko x'áé-dxoom koe tcãà ne tsao gha c'ẽem khóèm tshàa gàba ba qgóóa hãam cgoa xg'ae. Xùri me tsao naka ẽem ko tcãàm nquum koe síí tcãà. ");
INSERT INTO nhr_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Naka nquum ka q'õòse ba bìrí naka máá: ‘Xgaa-xgaa-kg'ao ba ko máá, cg'áè-nquum Tiri xu xgaa-xgaase-kg'ao xu cgoar gha hàà Paseka di tc'õoan tc'õó ba nda hãa?’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nakam gha tc'amaka hãam nquum kaia, a wèé zi gúù zi tc'ẽese ko zi úúa hãam, nxãakamaga kg'ónòa xg'araèa ba x'áí tsao o, tsao gha gaa koe hãas wèé sa kg'ónò,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tsara kò qõò, a síí ẽem kò ma bìrí tsara a hãa khamaga ma sao-xg'ae i ii, tsara kò Pasekan kg'ónòa máá Me. ");
INSERT INTO nhr_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eẽm ko x'aè ba hàà kam kò Jeso ba x'áè úú-kg'ao xu cgoa qa̱òa. ");
INSERT INTO nhr_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A ba a bìrí xu a máá: “Kaisaser kò tc'ẽea hãa, ncẽes Pasekas di tc'õoa ner gha gaxao cgoa tc'õó sa, qanega Ra xgàraè tamas cookg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bìrí xao or ko, cuiskaga Ra tc'õó si tite, si gha nxãakg'aiga síí ẽes tc'õos ko nxàe sa Nqarim di x'aian koe tseegukaguè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","A ba a kubi ba séè a Nqari ba qãè-tcao máá, a ba a máá: “Séè xao naka xaoa kg'áà. ");
INSERT INTO nhr_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bìrí xao or ko, Nqarim di x'aian hàà tamas cookg'ai koer cuiskaga kg'om dis hìis di gõéan ncẽe kg'áà hãa tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kam ko péré qàmà sa séè, a ba a Nqari ba qãè-tcaoa máá, a khõá q'aa si, a máà xu si, a ba a máá: “Ncẽea cgàaa Te ga a, gatu ko máàè e. Ncẽes gúù sa tu kúrú naka tc'ẽe-tc'ẽese Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gaam dàòm cúím kam kò tc'õoan qãá q'oo koe kubi sa máà xu, a máá: “Ncẽes kubi sa Nqarim dis qáé-xg'aes ka̱ba si i, c'áòa Te koe, ncẽe gatu ntcã̱água mááèa hãa a. ");
INSERT INTO nhr_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Igaba méé xao q'ãa, gaam ẽe ko khóè ne tshàu q'oo koe tcãà Te ba ncẽe koe Tíí cgoa ntcõóa-ntcõe sa. ");
INSERT INTO nhr_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Eẽ i ma Khóèm dim Cóám ka mééèa hãa khamaga i gha ii, igaba haò, cg'ãè i gha ii ẽe ko khóè ne tshàu q'oo koe tcãà Mem ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Xu tshoa-tshoa a gaxu xg'aeku koe tẽèku, dìí ba gha ẽeta iis gúù sa kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Si kò kaias kg'ui sa gaxu xg'aeku koe tẽe, dìím kaia hãa di sa. ");
INSERT INTO nhr_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Me Jeso ba bìrí xu a máá: “X'aiga xu tãá zi qhàò zi di xu ko tc'ãà-cookg'ai ne, xu ko ẽe qarian úúa hãa xu khóè xu qãè xu ta ma tciiè. ");
INSERT INTO nhr_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Igaba méé i gaxao ka táá gatà ii guu. Eẽ gaxao wèé xao ka kaia hãa ba méém cg'áré ba ii, nakam ẽe ko tc'ãà-cookg'ai xao o ba qãà ba ii. ");
INSERT INTO nhr_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ka ba ndaka ba gatsara xg'aeku koe kaia: ẽe ntcõó a ko tc'õó baa, kana qãà baa? Tseeguan kaga, ẽe ntcõó a ko tc'õo me e. Igabar Tíía gaxao xg'aeku koe qãàm khama ma hãa. ");
INSERT INTO nhr_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Igaba xao kò gaxao wèé zi kúrúa bóòku zi Tiri zi koe Tíí cgoa hãa. ");
INSERT INTO nhr_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ncẽem ma Abo ba ma qarian tc'ãà-cookg'ai di máà Tea hãa, khamagar gha ma qarian máà xao o. ");
INSERT INTO nhr_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Tiri x'aian koer ko Tíí ntcõó a tc'õóm qgáìm koe xao gha nxãasega Tíí cgoa ntcõó a tc'õó, a kg'áà, a xao a gha x'aian dis ntcõó-q'oos koe ntcõó, a gha 12 zi qhàò zi Iseraele di zi bóò a xgàra ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","A ba a máá: “Simoneè, Simoneè, q'ãa méé tsi, satana ba dtcàrà mááse xaoa hãa, séèam gha mááse xao o ka, q'aa-q'aa xaom gha ka, ẽe i ko maberean ma dqòròè i gaan di tsoroan gaan cgoa ma q'aa-q'aaè khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Igabar còrèa máá tsia Simoneè, táá i gha tsari dtcòm̀an kaà ka. Nxãasega tsi gha, ẽe tsi kòo Tíí koe ka̱bisem x'aèm ka tsáá ka c'ẽe ne qari-qari ka,” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Me Petere ba xo̱a Me a máá: “X'aigaè, Tsáá cgoa qáé-nquus koe síían ga hẽé, naka x'óóan ga hẽéthẽér kg'ónòsea máána hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Me Jeso ba bìrí me a máá: “Petereè, bìrí tsir ko, ncẽem cáḿ kam ghòrò ba kg'aea hãa tite, tsi gha nxãakg'aiga síí nqoana q'oro xo̱ase Te, c'úù Tea tsi hãa sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Me nxãaska Jeso ba Gam di xu xgaa-xgaase-kg'ao xu tẽè a máá: “Eẽr xg'ao káà qgóáse hẽé, naka káà dtcòbèse hẽé, naka káà nxàbose hẽéthẽé, tsééa úú xaoa hãa ka xaoa xg'ao dùú cúí ga tcào?” témé. Xu máá: “C'ẽe gúù tama a,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Me Jeso ba bìrí xu a máá: “Igaba Ra ko ncẽeska bìrí xao o a ko máá: Dìím wèém ẽe qgóá sa hẽé naka dtcòbè sa hẽéthẽé úúa hãa ba méém séè sara a, nakam ẽe ntcàu ba úú tama ba gam di qgáían x'ámágu, naka c'ẽe ba x'ámá. ");
INSERT INTO nhr_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bìrí xao or ko khama a ko máá: Ncẽe Tíí ka Nqarim di zi Tcgãya zi koe góáèa a ko máá: ‘Ts'ãà-kg'ao ne ka c'ẽem khama ne kò ma qgóó Mea,’ témé sa méés tseegukaguè. Si gha ncẽes gúù sa hàà Tíí koe tseegu, i gha ncẽe gúùan qháése kúrúse,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Xu xgaa-xgaase-kg'ao xu máá: “Bóò, cám̀ ntcàuan xae úúa, X'aigaè!” témé. Me xo̱a xu a máá: “Qãè e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Me Jeso ba ẽem x'áé-dxoom koe guu a tcg'oa, a ba a Olife dim xàbìm koe qõò ẽem ko kg'aiga hẽé khama, xu xgaa-xgaase-kg'ao xu xùri Me. ");
INSERT INTO nhr_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eẽm ko gaam qgáìm koe tcãà kam ko bìrí xu a máá: “Còrè xao naka xao nxãasega táá kúrúa bóòkuan koe tcãà guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Me gaa koe guu a tcg'oa a ba a gaxu ka cg'árése nqúù ka síí hãa, nxõ̱ás ga xaoè a síí tcheè khama noo di nqúù-q'ooa koe, a ba a síí gaa koe qhòm tsi quri a còrè, ");
INSERT INTO nhr_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","a máá: “Aboè, tc'ẽe Tsi kò ko ne, ncẽes kubis xgàrakuan di sa Tíí koe séèa tcg'òó. Igaba Tsari tc'ẽean ka, Tíí ko tc'ẽes ka tamase,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Me moengelem nqarikg'ai koe guua ba Gam koe x'áíse, a qari-qari Me. ");
INSERT INTO nhr_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Me kò kaias q'áòs arekagu me kos koe hàna, khamam kò kaisase qarika còrè. I kò Gam di khùbuan c'áòan khama ma góḿankg'ai koe ntcã̱a. ");
INSERT INTO nhr_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eẽm Gam di còrèan koe guu a ko tẽe kam kò Gam di xu xgaa-xgaase-kg'ao xu koe ka̱bise, a ba a sao-xg'ae xu xu tshúù-tcaoa hãase x'óm̀a. ");
INSERT INTO nhr_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Me bìrí xu a máá: “Dùús domka xao x'óm̀a hãa? Tẽe xao naka xaoa còrè, naka xaoa gha nxãasega táá kúrúa bóòkuan koe tcãà guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Eẽm Jeso ba qanega hãa a ko kg'ui kas kò kúúga xg'ae sa hàà, me kò Jutase ta ko ma tciièm khóèm 12 xu ka c'ẽe ba tc'ãà-cookg'ai sia, a ko Jeso ba q'óá, x'obè Mem gha ka. ");
INSERT INTO nhr_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Igabam kò Jeso ba gam ka máá: “Jutaseè, a Khóèm dim Cóá ba tsi gáé ko khóè ne tshàu q'oo koe tcãà x'obèkus cgoa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eẽ xu ko Gam cgoa kò hãa xu dùús ko kúrúse sa bóòa q'ãa, ka xu kò máá: “X'aigaè, sixae di ntcàuan xae gha tséékagu?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Me kò gaxu ka c'ẽe ba kaiam peresitim dim qãàm dim tceem kg'áò xòè di ba xg'aoa qhòm. ");
INSERT INTO nhr_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Me Jeso ba máá: “Eẽ tsi kúrúa hãa sa tc'ãòa,” témé, a khóèm dim tcee ba qgóó, a qãèkagu me. ");
INSERT INTO nhr_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Me kò nxãaska Jeso ba kaia xu peresiti xu hẽé, naka tc'ãà-cookg'ai xu tempelem di xu hẽé, naka khóè ne di xu kaia xu hẽéthẽé, ẽe kò Gam koe hààraa hãa xu bìrí a máá: “Ts'ãà-kg'ao ba tsãá hààraa khama xao gáé ntcàuan hẽé naka dxòman hẽéthẽé cgoa hààraa? ");
INSERT INTO nhr_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Wèé cáḿ kar kò tempelem q'oo koe gaxao cgoa hãa, igaba xao kò gaa koe táá síí qgóó Te. Igabam ncẽe ba gaxao dim x'aè me e, naka ntcùús di qarian di ba hẽéthẽé e,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jeso ba xu kò qgóó, a xu a séè a kaiam peresitim dim nquum koe úú Me. Me kò Petere kháóka téé a còò xu. ");
INSERT INTO nhr_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Eẽ xu xhàrom nqáè koe c'ee sa dxùu a ntcõóa-ntcõe, kam kò Petere gaxu xg'aeku koe ntcõe. ");
INSERT INTO nhr_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Si kò c'ẽes qãà sa bóò me me c'ees x'áà koe ntcõe, si qãèse bóò me, a sa a máá: “Ncẽem khóè ba kò thẽé Gam cgoa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Igabam kò Petere xo̱ase a máá: “Khóè seè, c'úù Mea raa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","X'aè-coam qãá q'oo koem kò c'ẽem khóè ba thẽé bóò me a máá: “Tsáá igaba tsi thẽé gaxu ka c'ẽe tsi i,” témé. Igabam kò Petere máá: “Khóè tseè, tíí tama ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Qáòm x'aè-coam qãá q'oo koem kò gaicara c'ẽem khóè ba kaisa tcoman úúa hãase kg'ui a máá: “Tseeguan kagam kò thẽé ncẽem khóè ba Gam cgoa hãa, Galilea dim khóè me e khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Me Petere xo̱a a máá: “Khóè tseè, c'úùa ra hãa dùús ka tsi ko kg'ui sa!” témé. Me kò kúúga ẽem qanega hãa a ko kg'ui ka ghòrò ba kg'ae. ");
INSERT INTO nhr_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Me kò X'aiga ba ka̱bise a Petere ba bóò. Me Petere ba X'aigam di kg'uian tc'ẽe-tc'ẽese, ncẽem kò máá: “Ncẽe cáḿ kam ghòrò ba qanega kg'ae tama cookg'ai koe tsi gha sene nqoana q'oro xo̱ase Te,” témé e. ");
INSERT INTO nhr_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Me kò Petere tchàa koe tcg'oa, a síí thõòkase kg'ae. ");
INSERT INTO nhr_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Xu kò ẽe kò Jeso ba qgóóa xu khóè xu nco̱i Me, a xu a xg'áḿ Me, ");
INSERT INTO nhr_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","a xu a qáé tcgáí Me, a tẽè Me a máá: “Porofita naka bìrí xae e, dìína ko xg'áḿ Tsi sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","A káí zi gúù zi c'ẽe zi cóèkuan di zi Gam ka nxàe. ");
INSERT INTO nhr_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Eẽ i ko q'uu ka xu kò khóè ne di xu kaia xu hẽé, naka kaia xu peresiti xu hẽé, naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xg'ae, a Jeso ba séè a cookg'aia xu koe úú. ");
INSERT INTO nhr_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Xu síí máá: “Kreste Tsi kò ii ne méé Tsi bìrí xae e,” témé. Me xo̱a a máá: “Ncẽè bìrí xaor kò ko ne xao dtcòm̀ tite. ");
INSERT INTO nhr_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","A gataga ncẽè tẽè xaor kò ko ne xao xo̱a Te tite. ");
INSERT INTO nhr_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Igabagam gha ncẽe koe guus ka Khóèm dim Cóá ba Nqarim dim x'õàm kg'áòm xòè za síí ntcõó, ncẽe qariga ba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Xu wèéa xu ga máá: “Kháé Tsi gáé nxãaska Nqarim di Tsi Cóá Tsia?” témé. Me xo̱a xu a máá: “Gaxaoa ko máá, Gar ga Ra a, témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Xu máá: “Dùútsa gúùs tseeguan gha x'áí sa xae ko qanega qaa? Gam kg'áḿ koe ga xae guu a kóḿ ana ka!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Si nxãaska wèés xg'ae sa tẽe, a sa a Jeso ba Pilatom cookg'ai koe úú. ");
INSERT INTO nhr_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Xu kò gaa koe tshoa-tshoa a chìbi-chibi Me, a xu a máá: “Ncẽem khóè ba xae sao-xg'aea, me ko sixae di ne khóè ne tãám dàòm koe tceea úú, a ko khóè ne xgáè-kg'am, táá ne gha Roma dim x'aigam Kaesaram di marian suruta ka, a ba a ko máá, gabá Kreste Me e, a X'aiga Me e, témé,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Me Pilato ba tẽè Me a máá: “A tsáá ga tsia Juta ne di tsi x'aiga tsi?” témé. Me xo̱a me a máá: “Eẽ tsi ko méé khamaga i ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Me Pilato kaia xu peresiti xu hẽé naka kaias xg'aes khóè ne dis gaa koe kò hàna hãa sa hẽéthẽé bìrí a máá: “Khóèm ncẽem koer cúí chìbi ga hòò tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Igaba xu kò Gam ka qarika nxàe a máá: “Wèém Juteam koem ko khóè ne xgaa-xgaa, a ko khóè ne tcg'ome tcúú, Galilea koem tshoa-tshoaa, a ba a ncẽe koe hàà tcana hãa,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Eẽm ko Pilato ncẽe sa kóḿ, kam kò tẽè gaam Khóè ba Galilea dis qhàòs di Me e sa. ");
INSERT INTO nhr_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","A ba a ẽem ko bóòa q'ãa, Herotem dim nqõóm di x'áèan dòm̀ q'oo koem hãa sa, kam ko Herotem koe úú Me, ncẽe kò ẽe x'aè ka Jerusalema koe hãa ba. ");
INSERT INTO nhr_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eẽm ko Herote ba Jeso ba bóò kam kò kaisase qãè-tcao, ncìísem kò bóòa ba tc'ẽea hãa khama, a ba a kò Gam ka kóḿa hãa, a kò nqòòan úúa hãa, are-aresa zi x'áí zim gha kúrú me bóò di i. ");
INSERT INTO nhr_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Me Herote káí zi tẽè-kg'áḿ zi tẽè Me, igabam kò Jeso ba táá xo̱a me. ");
INSERT INTO nhr_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Xu kò kaia xu peresiti xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé xu qarika chìbi-chibi Me. ");
INSERT INTO nhr_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herote ba hẽé naka gam di xu ncõo-kg'ao xu hẽéthẽéa kò ntcoe Me, a nco̱i Me, a t'õèm qgáí ba hã̱akagu Me, a Pilatom koe gaia tsééa ka̱bi Me. ");
INSERT INTO nhr_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Gaam cáḿ ẽem ka tsara kò Herotea tsara Pilatoa tsara kg'aiga tsara kò hòrekua hãa igaba tcáràku. ");
INSERT INTO nhr_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato ba kò kaia xu peresiti xu hẽé, naka tc'ãà-cookg'ai xu hẽé, naka khóè ne hẽéthẽé tciia xg'ae, ");
INSERT INTO nhr_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a bìrí ne a máá: “Ncẽem Khóè ba tu kò tíí koe óá, tãám dàòm koe ko xg'ae sa tceea úúm khóèm khama ma, igaba bóò, cookg'aia tu koer ncãa tẽèa xam̀ Me, a ra a ncãa ncẽem Khóèm koe cúí chìbi ga táá hòò, ẽe tu kò chìbi-chibi Mea hãa zi gúù zi koe. ");
INSERT INTO nhr_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herotem igabam cúí chìbi ga hòò cgae Me ta ga hãa, gaa domkam kò gatá koe tsééa ka̱bi Me, ncẽe tu ko ma bóò khamaga ma, cúí gúù tshúù kúrúam hãa ga káà a, gaan domka ta ga cg'õo Me e. ");
INSERT INTO nhr_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gaa domkar gha kg'ama tsa̱man cgoa xg'áḿ Me, a ra a gha kgoara Me, Me qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Kõ̱ès domka méém ga kòo c'ẽem khóè ba kgoara máá nes gúù si i. ");
INSERT INTO nhr_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Si kò wèés xg'ae sa q'au a máá: “Cg'õo Me, naka Barabase ba kgoara máá ta a,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabase ba kò ncõoan x'áé-dxoom koe kúrúsea ka hẽé, naka khóè ne cg'õoan domka hẽéthẽé qáé-nquus koe tcãàèa. ");
INSERT INTO nhr_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Me kò Pilato ba Jeso ba kgoara kg'oana hãa, khamam kò gaia kg'ui cgoa ne. ");
INSERT INTO nhr_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Igaba ne kò kaisase q'au a máá: “Xgàu Me! Xgàu Me!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Me nqoana dis ka gaia máá: “Kháé ba gáé dùútsa cg'ãè sa kúrúa hãa? Cúí gúù gar hòò tama x'oo sam gha xgàra mááè di i ka. Ra gha xg'áḿ Me, a kgoara Mem qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Igaba ne kò qanega kaisase q'au Jesom gha xgàuès ka, i kò gane di q'au-q'ooan tàà. ");
INSERT INTO nhr_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Me kò Pilato ba nxàe, ẽe ne tc'ẽea hãa sa gha kúrúè sa: ");
INSERT INTO nhr_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","gaam khóèm ẽe gane kò tc'ẽea hãa kgoaraèm gha sa bam kò kgoara, ncẽe kò ncõoan x'áé-dxoom koe kúrúsea ka hẽé, naka khóè ne cg'õoan domka hẽéthẽé qáé-nquus koe tcãàèa hãa ba, a ba a Jeso ba ncõo-kg'ao xu tshàu q'oo koe tcãà, nxãasega xu gha ẽe ne kò khóè ne ma tc'ẽea hãa khama ma kúrú Me ka. ");
INSERT INTO nhr_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eẽ xu ko ncõo-kg'ao xu Jeso ba úú ka xu kò Kurene dim khóèm cgoa xg'ae, Simone ta ko ma tciiè ba, me qãáka guua hãa, xu kò xgàu sa dcẽékagu me, me Jesom qãá koe téé a xùri Me. ");
INSERT INTO nhr_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Si kò kaias xg'aes khóè ne di sa còò Me, zi kò gaas xg'aes q'oo koe c'ẽe zi khóè zi hàna, tshúù-tcaoase kò ko kg'ae cgae Me zi. ");
INSERT INTO nhr_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Me kò Jeso ba gazi koe ka̱bise a máá: “Jerusalema di sao khóè saoè! Táá sao Tíía kg'ae cgae Te guu, igaba sao gasao hẽé naka cóáa sao hẽéthẽé kg'ae cgae. ");
INSERT INTO nhr_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","X'aè ba gha hàà khama, khóè ne gha máá: ‘Tsóágase zi gáé khóè zi ncẽe cóán úú tama zi ts'ee-ts'eekg'aièa hãa, naka tchòoan ncẽe cóán úú tama hẽé, naka bíìan ncẽe qanega comkagu tama hẽéthẽé e,’ témé ba. ");
INSERT INTO nhr_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nxãaska ne gha tshoa-tshoa a xàbìan ka máá: ‘Cg'áé cgae ta a,’ témé, a nxõ̱án ka máá: ‘Qàbia tcãà ta a,’ témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ncẽè hìian tsã̱á ii koe ne kòo ncẽe zi gúù zi kúrú ne, ne gha ẽe i xgóòa hãa koe dùú sa kúrú?” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tsara kò cám̀ tsara khóè tsara c'ẽe tsara chìbi-kg'ao tsara a, tsara kò gatsara igaba úúè, síí tsara gha Jesom cgoa cg'õoè ka. ");
INSERT INTO nhr_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","‘Tcúú-c'õá’ ta ko ma tciièm qgáìm koe xu ko hàà ka xu kò gaa koe Jeso ba xgàu, gaa tsara chìbi-kg'ao tsara cgoa, c'ẽe ba kò kg'áò xòèa ba za xgàuè, me c'ẽe ba dxàe xòèa ba za xgàuè. ");
INSERT INTO nhr_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Me kò Jeso ba máá: “Aboè, qgóóa máá ne, c'úùa ne hãa dùú sa ne ko kúrú sa ke,” témé. Gam di qgáía ne xu kò cgúúan ntcòo ka q'aa-q'aaku. ");
INSERT INTO nhr_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ne kò khóè ne téé a ko xaè, ẽe xu kòo tc'ãà-cookg'ai xu zàro Me ka, a ko máá: “C'ẽe nem kò kgoara hãa, ke méém kgoarase, ncẽe nxárá tcg'òóèa hãam Krestem Nqarim dim Cóám kò ii ne,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xu kò ncõo-kg'ao xu thẽé nco̱i Me, a kò tsa̱u tshàan cgoa hàà a hàà kg'áàkagu Me, ");
INSERT INTO nhr_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","a máá: “Juta ne di Tsi X'aiga Tsi kò ii ne, Tsáá ka kgoarase,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Gam tc'amkg'ai koe i ko ncẽeta ma góásea hãa: ‘NCẼEA JUTA NE DIM X'AIGA ME E,’ ta ma ma. ");
INSERT INTO nhr_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Khóè tsara ẽe kò Gam cgoa xgàuèa hãa tsara ka c'ẽe ba kò dcàro Me a máá: “Kreste Tsi tama Tsia gáé? Tsáá ka kgoaraseò, naka kgoara tsam m thẽé!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Me c'ẽe ba xo̱a me a dqàè me a máá: “Nqarim igaba tsi gáé q'áò Me tama? Tsáá igaba tsi gatà iis xgàrakus koe hàna! ");
INSERT INTO nhr_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Gatsama ko tchànose xgàraè, gatsam kúrúa hãas tséés di surutan tsam hòòa khama, igabagam Gabá cúí gúù kàma ga kúrú ta ga hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A ba a máá: “Jesoè, tc'ẽe-tc'ẽese te, Tsari x'aian koe Tsi kòo tcãà ne,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Me Jeso ba bìrí me a máá: “Tseegua ner ko bìrí tsi: Ncẽe cáḿ ka tsi gha sene Tíí cgoa paradaisi koe hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Koaba di x'aèan 12 di i kò ii, si kò wèém nqõóm koe ntcùú sa xóé, a síí dqòa di x'aèan nqoana di koe téé. ");
INSERT INTO nhr_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Eẽ i ko cáḿs di x'áàn kaà kam kò tempelem koe tceeèam qgáí ba tòàra q'aase cám̀ qàmà tsara cgoa. ");
INSERT INTO nhr_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Me kò Jeso ba kaiam dòm̀ cgoa q'au a máá: “Aboè! Tiri tc'ẽea ner ko tshàu q'ooa Tsi koe tcãà,” témé. A ba a ncẽe sam ko kg'uia xg'ara ka còo di sa sónòa tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eẽm ko ncõo-kg'ao xu dim kaia ba ẽe kúrúsea sa bóò, kam kò Nqari ba dqo̱m̀ a máá: “Tseegukagam kò ncẽem khóè ba tchànom khóè Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Wèé ne khóè ne ẽe kò gaa koe xg'aea hãa, a ko xaè ne kò ẽe zi gúù zi bóò zi ko kúrúse ka ne kò tshúù-tcaoa hãase dìbi. ");
INSERT INTO nhr_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Wèé ne ẽe kò q'ãa Mea ne hẽé, naka Galilea koe guu a còò Mea hãa zi khóè zi hẽéthẽé kò nqúù ka téé a ko bóò Me. ");
INSERT INTO nhr_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Kam kò gaa x'aè kaga c'ẽem khóèm Josefa ta ko ma tciiè ba hàna, Juta ne dim x'áé-dxoom Arimateam koe kò guua ba. Qãèm khóèm, tchàno me e kò ii, Nqarim di x'aian di hàà-q'ooan kò qãà hãa ba, tc'ãà-cookg'ai xu ka c'ẽe me e kò ii, igabam kò táá c'ẽe xu di tc'ẽean cgoa dtcòm̀ku. ");
INSERT INTO nhr_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatom koem kò síí, a Jesom dim tc'áró ba dtcàrà. ");
INSERT INTO nhr_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Me gaam tc'áró ba xòó, a q'úúm qgáím cgoa tcáḿ, a ba a tshàoèa hãam nxõ̱ám dis tc'ám̀s koe síí tcãà Me, ncẽe c'ẽe khóè ga kò qanega gas koe kg'ónòè tama sa. ");
INSERT INTO nhr_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Me kò ẽem cáḿ ba kg'ónòsean dim cáḿ me e, Sabata dim cáḿ ba kò ko tshoa-tshoase khama. ");
INSERT INTO nhr_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Zi kò khóè zi ẽe kò Jesom cgoa Galilea koe guua hãa zi Josefam cgoa qõò, a zi a síí Jesom dis tc'ám̀ sa bóò, a síí Jesom dim tc'áróm ma xòóèa hãa sa bóò thẽé. ");
INSERT INTO nhr_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ka zi ko x'áéa zi koe ka̱bise, a zi a síí Jesom dim tc'áró ba qãè-hm̀m̀ xg'ãò tshãán kg'ónòa máá. Sabata dim cáḿ ka zi kò sãa, ẽe i ko ma x'áèèa hãa khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tc'ãà dim cáḿ bekem dim di ntcùúkg'ai cgoa zi kò ẽe zi kúrúa hãa tshãán séè a tc'ám̀s koe qõò. ");
INSERT INTO nhr_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","A zi a kò nxõ̱á sa bóò si tc'ám̀s-kg'áḿ koe ghànèa tcg'òóèa. ");
INSERT INTO nhr_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Igaba ẽe zi ko tcãà ka zi kò X'aigam Jesom dim tc'áró ba táá hòò. ");
INSERT INTO nhr_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Eẽ zi qanega ncẽes gúùs ka area hãa, ka tsara kò cám̀ khóè tsara qáò qgáían x'áàko ha̱na tsara qàea zi koe téé. ");
INSERT INTO nhr_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Zi kò q'áòan ka górò a góḿankg'ai koe qám̀-kg'ai. Tsara kò khóè tsara gazi ka máá: “Dùús domka sao ko kg'õèa hãam khóè ba x'óóa hãa ne di qgáìan koe qaa? ");
INSERT INTO nhr_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ncẽe koem káà Me e, igabagam tẽea hãa. Eẽm kò qanega Galilea koe hãa kam kò bìrí tu u sa tc'ẽe-tc'ẽese, ncẽem kò máá, ");
INSERT INTO nhr_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Khóèm dim Cóá ba méém cg'ãè ne khóè ne tshàu q'oo koe tcãàè, naka baa xgàuè, naka nqoana dim cáḿ ka x'ooan koe tẽe, ta mééa hãa ka,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ka zi kò Gam di kg'uian tc'ẽe-tc'ẽese, ");
INSERT INTO nhr_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","a zi a tc'ám̀s koe zi guu a ko ka̱bise ka síí wèé gúùan ncẽe ga Gam di xu xgaa-xgaase-kg'ao xu 11 xu hẽé, naka wèé ne c'ẽe ne hẽéthẽé bìrí. ");
INSERT INTO nhr_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria Magatalena sa hẽé, naka Joana sa hẽé, naka Marias Jakobom ka xõò sa hẽé, naka c'ẽe zi khóè zi hẽéthẽéa kò x'áè úú-kg'ao xu ncẽe gúùan bìrí, ");
INSERT INTO nhr_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","igaba xu kò ncẽe zi khóè zi táá dtcòm̀, gazi di kg'uia ne kò gaxu koe huwan khama xam̀ khama. ");
INSERT INTO nhr_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Igabam kò Petere ba tẽe a tc'ám̀s koe qgóéa síí, qám̀sem ko a ko bóò kam kò q'úú qgáí cgoa kúrúèa ko̱àn ẽem kò tcáḿ cgoaèa cúí ga bóò i cúía hãa, me kò ncẽe kúrúsea hãas gúùs ka area hãase x'áé koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gaam cáḿ cúím kaga tsara kò cám̀ xgaa-xgaase-kg'ao tsara xóé ko Emause ta ko ma tciièm x'áém koe qõò, Jerusalema koe tsi kò guu a ko gaa koe síí, ne 11 kilomitara khama noo qáò-q'ooan úúa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eẽ tsara xóé ko qõò ka tsara kòo wèé zi gúù zi ẽe kúrúsea hãa zi ka chóà. ");
INSERT INTO nhr_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eẽ tsara xóé ko chóàa qõò, kam kò Jeso ba cúù-cuuse cgae tsara a, a hàà xu xg'ae a qõò, ");
INSERT INTO nhr_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","igaba tsara kò qgóó tcgáíèa hãa, khama tsara kò táá bóòa q'ãa Me. ");
INSERT INTO nhr_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Me tẽè tsara a, a máá: “Dùú sa tsao xóé ko chóàa qõò?” témé. Ka tsara ko ncóó a téé, a tshúù-tcaoa hãa khama ii. ");
INSERT INTO nhr_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Me kò gatsara ka c'ẽem Kelopase ba xo̱a Me a máá: “A Tsáá cúí Tsi Tsia gáé Jerusalema koe cg'áè-kg'ao Tsia, ncẽe zi cáḿ zi ka gaa koe kúrúsea hãa zi gúù zi Tsi c'úùa hãa ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Me tẽè tsara a, a máá: “Dùútsa gúù zi?” témé. Tsara xo̱a Me a máá: “Jesom Nasareta dim ka, ncẽe kò porofiti ii ba, a kò tsééan koe hẽé, naka kg'uian koe hẽéthẽé kaisa qarian úúa hãa, Nqari ba hẽé naka wèé khóèan hẽéthẽé cookg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kaia xu peresiti xu hẽé, naka gatá di xu tc'ãà-cookg'ai xu hẽéthẽéa kò qgóó Me, a x'ooan koe xgàra Me, a xgàu Me. ");
INSERT INTO nhr_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Igaba ta kò tc'ẽea máá, Gaam hàà gha Iseraele ne kgoaram ga Me e, ta tc'ẽea hãa! Ncẽe zi gúù zi wèé zi oose, ncẽea nqoana dim cáḿ ga me e, zi ncẽe zi gúù zi kúrúsea hãa. ");
INSERT INTO nhr_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Zi kò c'ẽe zi khóè zi gatá dis xg'aes di zi arekagu ta a, kaisa ntcùúkg'ai cgoa zi kò tc'ám̀s koe síí, ");
INSERT INTO nhr_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","igaba zi kò tc'áróa ba síí táá hòò, a kò hàà bìrí ta a, moengele tsara zi bóòa hãa sa, ncẽe kò bìrí zi a máá, Jeso ba kg'õèa hãa, témé tsara. ");
INSERT INTO nhr_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ne kò gatá cgoa kò hãa ne c'ẽe ne tc'ám̀s koe síí, a síí bóò si ẽe zi kò khóè zi mééa hãa khamaga ii, igaba ne kò Gabáa táá hòò Me,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Me kò gatsara ka máá: “Tsóágase káà tc'ẽe tsao khóè tsao gáé, a tsao a porofitian ka nxàeèa gúùan dtcòm̀ ka qóḿ tcáó tsao o! ");
INSERT INTO nhr_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Krestem gha ncẽe zi gúù zi koe xgàrase, a ba a Gam di x'áàn koe tcãà sa gáé kò qaase tama?” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","A ba a Moshem dis Tcgãyas koe hẽé naka wèé xu porofiti xu di zi Tcgãya zi koe hẽéthẽé guu a tshoa-tshoa, a qãèse bìrí tsara a, wèé zi Tcgãya zi Nqarim di zi koe ko Gam ka kúrúse sa. ");
INSERT INTO nhr_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eẽ xu ko ncãa xu ko síím x'áém koe cúù, kam kò Jeso ba còoka ko nqáé khama ma kúrúse, ");
INSERT INTO nhr_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","igaba tsara kò qarika dtcàrà Me a máá: “Hãa cgoa tsam m, ncẽeska i dqòa kg'oana, me cáḿ ba nqáéa hãa ke,” témé. Me kò síí cgae tsara a, xu síí xg'ae a hãa. ");
INSERT INTO nhr_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eẽ xu tafolem koe ntcõe, kam kò péréan séè, a ts'ee-ts'eekg'ai i, a ba a khõá a máà tsara a. ");
INSERT INTO nhr_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","I kò tcgáía tsara xgobekg'amse, tsara bóòa q'ãa Me. Me nxãaska tcgáí-q'ooa tsara koe kaà. ");
INSERT INTO nhr_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tsara kò tẽèku a máá: “Tcáóa tsam gáé kò nxùrù tama, ẽem kòo dàòm q'oo koe kg'ui cgoa tsam m, a kòo Nqarim di zi Tcgãya zi ka q'ãa-q'ãa tsam m ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A tsara a kò gaa x'aè kaga tẽe, a Jerusalema koe ka̱bise. Gaa koe tsara ko síí ka tsara kò xgaa-xgaase-kg'ao xu 11 xu hẽé, naka ẽe kò hãa cgoa xua ne hẽéthẽé sao-xg'ae, ne xg'aea hãa, ");
INSERT INTO nhr_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","a ne a ko máá: “Tseeguan kagam X'aiga ba tẽea, a ba a Simonem ka bóòèa hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tsara kò dùú sa kò dàòm q'oo koe kúrúse cgae tsara a sa chóà máá ne, naka tsara kò ma Jeso ba ẽem kò péréan khõá máá tsara a qãá q'oo koe ma bóòa q'ãa sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Eẽ ne qanega hãa a ko ncẽes gúùs ka kg'ui kam kò X'aigam Jeso ba hàà xg'aekua ne koe téé, a ba a bìrí ne a máá: “Tòókuan méé i gatu cgoa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ne kò kaisase q'aea hãa, a ne a area hãa, a tc'ẽea máá, dca̱u-soma ba ne bóòa hãa, ta tc'ẽea. ");
INSERT INTO nhr_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Igabam kò bìrí ne a máá: “Dùús domka tu q'aea hãa? Dùús domka tu ko ncẽeta ma ma tẽèsea máá? ");
INSERT INTO nhr_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tshàua Te hẽé, naka nqàrèa Te hẽéthẽé bóò, naka tua Tíí ga Ra ii sa bóò: Qgóóa xám̀ Te, naka bóò, dca̱u-soma nea cgàa kana c'õá ga úú tama, ncẽe tu kò bóò Ra Tíí úúa hãa a,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eẽm ko ncẽe sa mééa xg'ara kam kò tshàua ba hẽé naka nqàrèa ba hẽéthẽé x'áí ne. ");
INSERT INTO nhr_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Eẽ ne qanega dtcòm̀ tama, qãè-tcaoan hẽé naka arean hẽéthẽé domka, kam ko tẽè ne a máá: “C'ẽe gúù tc'õóè gha tu úúa hãa?” témé. ");
INSERT INTO nhr_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ka ne ko x'ãèa kò hãam x'aù qàmà ba máà Me. ");
INSERT INTO nhr_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Me bóò Me ne ko koe ga séè a tc'õó me. ");
INSERT INTO nhr_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A ba a nxãaska bìrí ne a máá: “Ncẽea bìrí tuar kò hãa kg'uian Tiri ga a, ẽer kò gatu cgoa qanega hãa ka. Wèé gúùan ẽe Moshem di x'áè-kg'áḿan koe hẽé, naka Porofiti xu di góán koe hẽé, naka Pesalema zi koe hẽéthẽé Tíí ka góásea hãa méé i tseegukaguè,” témé. ");
INSERT INTO nhr_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A ba a kò gane di tc'ẽean xgobekg'am, Nqarim di zi Tcgãya zi ko dùú sa méé sa ne gha kóḿa q'ãa ka. ");
INSERT INTO nhr_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A ba a bìrí xu a máá: “Ncẽeta i ma góásea hãa: Kreste ba gha xgàrase, a ba a gha nqoana dim cáḿ ka x'ooan koe tẽe, ");
INSERT INTO nhr_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ke méé zi nqõóm di zi qhàò zi wèé zi, Jerusalema koe guu naka tshoa-tshoa naka zia Nqarim dim cg'õèm koe xgaa-xgaaè, chìbian koe méé ne tcóóse, nxãasega ne gha gane di chìbian qgóóa mááè ka. ");
INSERT INTO nhr_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Gatua ncẽe zi gúù zi di tu nxàea tseegukagu-kg'ao tu u. ");
INSERT INTO nhr_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ra gha Tíí, Tirim Abom nqòòkagu tua hãa sa tsééa máá tu u, igabaga méé tu ncẽem x'áé-dxoom Jerusalemam koe hãa, naka tua gha nxãakg'aiga síí tc'amaka guua hãa qarian hã̱akaguè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kam kò tchàa za úúa tcg'òó ne, Betania khama noose nqúù ka. A ba a x'õàa ba ghùi a ts'ee-ts'eekg'ai ne. ");
INSERT INTO nhr_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eẽm hãa a ko ts'ee-ts'eekg'ai ne, kam kò gane koe séèa tcg'òóè, a ba a nqarikg'ai koe qaòkaguè. ");
INSERT INTO nhr_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ka ne ko dqo̱m̀ Me, a kaisa qãè-tcaoan cgoa Jerusalema koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","A ne a wèé x'aè ka tempelem koe hãa, a ko Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tshoa-tshoases koem kò Kg'ui ba hàna, Me kò Kg'ui ba Nqarim cgoa hàna, Me kò Kg'ui ba Nqari Me e. ");
INSERT INTO nhr_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nqarim cgoam kò tshoa-tshoases koe hàna. ");
INSERT INTO nhr_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Wèés gúù sa kò Gam koe guu a kúrúè, i Gam oose cúí gúù ga kúrúè tama, ẽe kúrúsea a. ");
INSERT INTO nhr_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Gam koe i kò kg'õèan hãa, i kò kg'õèan khóè ne di x'áà a. ");
INSERT INTO nhr_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","I ko x'áàn ntcùúan q'oo koe x'áà, i ntcùúan tàà a hãa tama. ");
INSERT INTO nhr_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nqarim ka kò tsééa tcg'òóèa hãam khóè ba kò hàna, cg'õèa ba kò Johane ii. ");
INSERT INTO nhr_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","X'áàn kam gha hàà nxàea tseegukagu kam kò hààraa, nxãasega ne gha wèé ne khóè ne gam koe guu a dtcòm̀ ka. ");
INSERT INTO nhr_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","X'áàm tama me e kò ii, igabam kò hààraa, nxãasegam gha hàà x'áàn ka nxàea tseegukagu ka. ");
INSERT INTO nhr_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tseegu dim X'áàm, ncẽe ko wèém khóè ba x'áà-x'aa ba kò nqõómkg'ai koe hàà. ");
INSERT INTO nhr_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nqõómkg'ai koem kò hãa, me kò nqõó ba Gam koe guu a kúrúè, igabam nqõó ba c'úù Mea. ");
INSERT INTO nhr_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Gam x'áé koem kò hàà, ne kò Gam x'áé di ne táá qãèse hààkagu Me. ");
INSERT INTO nhr_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Igabam kò wèé ne ẽe kò qãèse hààkagu Me ne, gane ncẽe ko Gam di cg'õèan koe dtcòm̀ ne, nxãa nem kò qarian máà, Nqarim di ne cóá ne ne gha ii ka. ");
INSERT INTO nhr_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ncẽe ta ma q'ana hãa i ko ma cóán ábàè sa khama ne ma ábàè tama, cgàam ma ncàm̀a hãa khama tamase, kana khóèm ma ncàm̀a hãa khama tamase, igaba ne Nqarim koe guu a ábàèa. ");
INSERT INTO nhr_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Me kò Kg'ui ba cgàa ba kúrú, a ba a gatá koe x'ãè, cgóm̀kuan hẽé naka tseeguan hẽéthẽé ka cg'oèa hãase. Ta kaia x'áàn Gam di bóòa hãa, kaia x'áàn ncẽe Xõòm koe guu a cúíse ábàèam Cóám di i. ");
INSERT INTO nhr_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johane ba kò Gam ka nxàea tseegukagu, a ba a q'au a máá: “Ncẽe ba kò Gam ga Me e, ncẽer kòo máá: ‘Gaam ẽe qãáa te koe ko hàà ba téé-q'ooan ka nqáé tea, tíí qanega hàà tamas cookg'ai koem kò hàna khama,’ témé ba.” ");
INSERT INTO nhr_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gam di cg'oèa hãase hãan koe ta wèéa ta ga guu a chõò tama cgóm̀kuan hòòa. ");
INSERT INTO nhr_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","X'áè ba kò Moshem koe guu a tcg'òóèa hãa khama, i cgóm̀kuan hẽé naka tseeguan hẽéthẽé Jeso Krestem koe guua. ");
INSERT INTO nhr_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Cúí khóè ga Nqari ba qanega bóò tama. Igabagam cúíse ábàèam Cóám ncẽe Nqari ii ba, a Xõòm dxùu koe ntcõóa-ntcõe ba, nxãa ba Nqari ba q'ãakagu ta a hãa. ");
INSERT INTO nhr_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Jerusalema di xu Juta xu kò peresiti xu hẽé naka tempelem koe ko hùi xu khóè xu hẽéthẽé Johanem koe tsééa úú, síí xu gha dìím ii sa tẽè me ka. Me kò Johane ba tseeguan nxàe, a táá xo̱ase e, igabam tseeguan nxàe a máá: “Tíí ra Krester tama ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xu tẽè me a máá: “Kháé tsi gáé nxãaska dìí tsia? Elija tsia?” témé. Me máá: “Gaar tama ra a,” témé. Xu máá: “Kháé tsi gáé gaa tsi porofiti tsi tsia, Nqarim kò nxàea tsi?” témé. Me xo̱a a máá: “Eẽ ẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ka xu ko nxãaska tẽè me a máá: “Kháé tsia nxãaska dìí tsia? Bìrí xae e naka xae ẽe tsééa óá xaea hãa ne koe xo̱an úú. Dìí tsia, ta tsi ga méé?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Me máá: “Tíí ra tchàa-xgóós q'oo koe ko q'aur dòm̀ ra a, a ko máá: ‘X'aigam Nqarim dim dàò ba tchàno-tchanoa máá Me,’ ẽem porofitim Isaiam ma mééa hãa khama,” témé ra. ");
INSERT INTO nhr_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","(Xu kò ncẽe xu khóè xu Farasai xu ka tsééa tcg'òóèa hãa.) ");
INSERT INTO nhr_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ka xu ko tẽè me a máá: “Ncẽe Kreste tsi tama tsi kò ii, a Elija tsi tama tsi ii, a tsi a gataga gaa tsi porofiti tsi Nqarim kò nxàea tsi tama tsi ii, ne tsia ko dùús domka nxãaska khóè ne tcguù-tcguua máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Me Johane ba xo̱a xu a máá: “Tíí ra ko tshàan cgoa tcguù-tcguu, igaba xao gaxao ẽe xg'aekua xao koe téé-tẽe ba c'úùa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Gaam ẽe tíí qãá koe ko hàà ba, ncẽe Gam di nxàbo tca̱ian kgoara gar tc'ãò tama ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ncẽe zi gúù zia kò Betania koe kúrúse, Jorotane ka ncìí za, ncẽe Johanem kòo tcguù-tcguu koe. ");
INSERT INTO nhr_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Me Johane ba xùrikom cáḿ ka Jeso ba bóò Me ko hàà, me máá: “Ghùu-coam Nqarim di ba tu bóò, ncẽe ko hàà nqõóm di chìbian xgàm a qõò cgoa ba! ");
INSERT INTO nhr_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Gaam ga Me e ncẽer kòo Gam ka kg'ui a ko máá: ‘Qãáa te koem ko Khóè ba hàà, ncẽe téé-q'ooan ka nqáé tea ba, tíí kò qanega hàà tamas cookg'ai koem kò hàna hãa khama,’ témé ba. ");
INSERT INTO nhr_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Tíí igabar kò dìím ii sa c'úùa hãa. Igabar kòo tshàan cgoa tcguù-tcguu, nxãasegam gha Iseraele ne koe x'áíè ka,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Me kò Johane ba ncẽes gúù sa nxàea tseegukagu a máá: “Tc'ẽe bar kò bóò Me nqarikg'ai koe guu a tcíbís khama ii a ko xõa cgae Me, a ba a kò hàà Gam koe x'ãè. ");
INSERT INTO nhr_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tíí igabar kò dìím ii sa c'úùa hãa. Igabam kò ẽe kò tséé tea hãa, hààr gha tshàan cgoa tcguù-tcguu ka ba, bìrí te a máá: ‘Eẽ tsi gha Tc'ẽe ba bóò Me ko Gam koe xõa, a Gam koe hãa ba, nxãa ba Gaam Tcom-tcomsam Tc'ẽem cgoa gha tcguù-tcguum ga Me e,’ témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ra bóòa hãa, a ra a ko nxàea tseegukagu Nqarim dim Cóám ga Me e sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Xùrikom cáḿ kam kò Johane gaicara gam di tsara xgaa-xgaase-kg'ao tsara cgoa téé-tẽe. ");
INSERT INTO nhr_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Eẽm ko Johane ba Jeso ba bóò Me ko qõò kam kò máá: “Ghùu-coam Nqarim di ba bóò!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eẽ tsara ko xgaa-xgaase-kg'ao tsara ncẽe sa kóḿ, ka tsara kò Jeso ba xùri. ");
INSERT INTO nhr_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Me Jeso ba ka̱bise a ntcẽè a bóò tsara a, tsara ko xùri Me, Me tẽè tsara a, a máá: “Dùú sa tsao ko qaa?” témé. Tsara xo̱a Me a máá: “Nda Tsi x'ãèa, Rabiè?” témé. (Ncẽem kg'ui ba ko ‘Xgaa-xgaa-kg'ao Tseè’ témé, kg'uiam kò ka̱biè ne). ");
INSERT INTO nhr_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Me bìrí tsara a, a máá: “Hàà naka tsaoa bóò,” témé. Ka tsara ko qõò cgoa Me a síí ẽem kò x'ãèa hãa qgáìan bóò, a tsara a wèém cáḿ ẽe ba Gam cgoa dxãà. 4 di x'aè e kò ii dqòa di i. ");
INSERT INTO nhr_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Eẽ tsara khóè tsara ncẽe kò Johane ba kóḿ a Jeso ba xùri tsara ka c'ẽe ba kò Anterea me e, Simonem Peterem ka qõese ba. ");
INSERT INTO nhr_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tc'ãà dis gúùs Anteream kò kúrús kam kò káíkhoem Simone ba qaa, a bìrí me a máá: “Mesia ba tsam hòòa,” témé (ncẽem kg'ui ba ko ‘Kreste ba’ témé, kg'uiam kò ka̱biè ne). ");
INSERT INTO nhr_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Kam kò Anterea ba qõesem Simone ba Jesom koe óága, Me Jeso ba bóò me a máá: “Simone tsi Johanem di tsi cóá tsi i, igaba tsi gha ncẽeska Kefase ta ma tciiè,” témé (ncẽes cg'õè sa Petere si i Gerika dis kg'uis ka a ko ‘Nxõ̱á sa’ nxàe). ");
INSERT INTO nhr_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Xùrikom cáḿ kam kò Jeso ba Galilea koe qõò sa bìríse. A ba a kò Filipim cgoa xg'ae, a bìrí me a máá: “Xùri Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipi ba kò Betesaida koe guua, Anterea ba hẽé naka Petere ba hẽéthẽé tsara guua hãam x'áé ba. ");
INSERT INTO nhr_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipi ba ko Nataniele ba sao-xg'ae a bìrí a máá: “Gaam Khóèm ẽe xu kò ko Moshe ba hẽé naka porofiti xu hẽéthẽé Gam ka góáa hãa ba tsam hòòa hãa! Jesom Nasareta di ba, Josefam ka Cóáse ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Me Nataniele ba tẽè me a máá: “Nasareta koe i ga qãè gúùan guu a tcg'oa?” témé, kam kò Filipi xo̱a me a máá: “Hàà naka tsam síí tsi bóò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eẽm ko Jeso ba Nataniele ba bóò me ko hàà kam kò gam ka nxàe a máá: “Iseraelem tc'áró-tc'aro ga a ncẽe e, cúí tshúù-ntcõa ga úú tama ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Me Nataniele ba bìrí Me a máá: “Nta Tsi ma q'ãa tea hãa?” témé. Me Jeso ba xo̱a me a máá: “Qanega tsi kò faia dis hìis dòm̀ q'oo koe ntcõóa-ntcõe, me Filipi tcii tsi tamas cookg'ai koer kò bóò tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Me Nataniele xo̱a a máá: “Rabiè, Tsáá Tsi Nqarim di Tsi Cóá Tsi i, Tsáá Tsi X'aiga Tsi i Iseraele di Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Me Jeso ba xo̱a me a máá: “Ncãar bìrí tsi a máá: ‘Faia dis hìis dòm̀ q'oo koe tsi ntcõóa-ntcõe koer hòò tsia,’ témé domka tsi ko dtcòm̀, igabaga tsi gha ncẽe zi gúù zi nqáéa hãa zi bóò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","A ba a máá: “Tseegukar ko tseeguan bìrí xao o, a ko máá: Nqarikg'ai xao gha bóò i xgobekg'amsea hãa, i ko Nqarim di moengelean Khóèm dim Cóám koe q'ábà xõa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Nqoana dim cáḿ kas kò séèkuan dis kõ̱è sa Kana dim x'áém koe kúrúse, ncẽe kò Galilea koe hàna ba. Si kò Jesom ka xõò sa gaa koe hàna. ");
INSERT INTO nhr_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Me kò Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé gaas kõ̱ès séèkuan di sa tciia mááèa. ");
INSERT INTO nhr_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Eẽ i ko gõéan tcào kas kò Jesom ka xõò sa bìrí Me a máá: “Gõéan ne úú tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Me Jeso ba bìrí si a máá: “Khóè seè, kháé méér dùú sa kúrú? Tirim x'aè ba qanega hàà ta ga hãa ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Si Jesom ka xõò sa tséé-kg'ao xu bìrí a máá: “Eẽm ko bìrí xao os gúùs wèé sa méé xao kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gaa koe xu kò nxõ̱án cgoa kúrúèa xu káná xu 6 xu tshàan di xu téé-tẽe, a xu a kò gaa koe tòóèa hãa Juta ne dis cau si i kò ii khama, xg'aàse di tshàan tòóa mááse sa. Me kò wèém káná ba 100 litara khama noo tshàan úúa. ");
INSERT INTO nhr_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Me Jeso ba bìrí xu a máá: “Káná xu tshàan cgoa cg'oè-cg'oe,” témé. Xu cg'oè-cg'oe xu, xu cg'oè a síí kg'áḿa xu koe téé. ");
INSERT INTO nhr_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Me bìrí xu a máá: “Ncẽeska xao xo̱be naka xaoa kõ̱ès dim tc'ãà-cookg'aim koe úú,” témé. Xu xo̱be e a xu a síí máà me e. ");
INSERT INTO nhr_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Eẽm ko kõ̱ès dim tc'ãà-cookg'ai ba tshàan ncẽe gõéan koe ka̱bièa xám̀, ncẽem kò nda i guua hãa sa c'úùa a, (igaba xu kò tséé-kg'ao xu ncẽe kò tshàan xàia hãa xu q'ana hãa nda i guua sa), kam kò séè-kg'ao ba tcii, ");
INSERT INTO nhr_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","a bìrí me a máá: “Wèé ne khóè ne ko kuri ka̱re gõéan kg'aia tcg'òó a khóè ne máà. Eẽ ne ko khóè ne kg'áà xg'ara, ne i ko nxãaska nxãwa ẽe ka̱re taman tcg'òóè. Igaba tsi tsáá ka̱re gõéan ncẽem x'aè ba tòóa máána hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ncẽe sa kò kg'aikas x'áís ga si i, Jesom ko Kana dim x'áém koe kúrú sa, ncẽe Galilea di ba. Gam di x'áà nem kò x'áí, xu kò Gam di xu xgaa-xgaase-kg'ao xu Gam koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ncẽe zi gúù zi qãá q'oo koem kò Jeso ba Kaperenaume koe síí, Gabá hẽé naka xõò sa hẽé, naka qõese ga xu hẽé, naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé e, ne kò gaa koe cg'orò cáḿan hãa. ");
INSERT INTO nhr_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Si kò Paseka dis kõ̱ès Juta ne di sa cúù si i, Me kò Jeso ba Jerusalema koe qõò. ");
INSERT INTO nhr_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Eẽm ko tempelem koe tcãà kam kò khóè ne bóò ne ko ghòèan hẽé, naka ghùuan hẽé naka tcíbían hẽéthẽé x'ámágu, ne c'ẽe ne tafolean koe ntcõóa-ntcõe a ko tãá nqõó di marian xg'áḿa q'aa. ");
INSERT INTO nhr_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Me kò dqùian cgoa tsa̱m ba kúrú, a ba a wèéa ne ga tempelem koe xhàiagu, ghùuan ga hẽé naka ghòèan ga hẽéthẽé cgoa, a ba a ghànèa qáú marian ko xg'áḿa q'aa ne di ntcõó-q'ooa ne, a ba a gane di qano marian tsa̱i-tsa̱ia q'aa. ");
INSERT INTO nhr_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","A ba a ẽe kò tcíbían x'ámágu ne bìrí a máá: “Eẽ zi gúù zi tu ncẽe koe tcg'òó. Abom dim nquu ba tu táá x'ámágu-nquu ba kúrú guu!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ka xu ko Gam di xu xgaa-xgaase-kg'ao xu tc'ẽe-tc'ẽese ẽe ko góáèa hãa sa, ncẽe kòo máá: “Tsarim nquum di ncóóa ne ko cg'õo te,” témé sa. ");
INSERT INTO nhr_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Xu kò Juta xu xo̱a Me a máá: “Ndakas x'áí sa Tsi gha x'áí ta a, ncẽe zi gúù zi di qarian Tsi úúa hãa di sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Me Jeso ba xo̱a xu a máá: “Ncẽem tempele ba tu ko̱bè, nakar nqoana cáḿan q'oo koe tshàoa ghùi me,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ka xu kò Juta xu máá: “Tempelem ncẽe kò 46 kurian séè a tshàoè ba Tsi gha Tsáá nqoana cáḿan q'oo koe ghùi dèe?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Igabam kòo Jeso ba tc'áróa ba dim tempele ba nxàe. ");
INSERT INTO nhr_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eẽm ko x'ooan koe ghùièa xg'ara ka xu kò Gam di xu xgaa-xgaase-kg'ao xu ẽem xg'ao mééa hãa sa tc'ẽe-tc'ẽese. A xu a Nqarim di zi Tcgãya zi hẽé naka Jesom kò kg'uia hãa kg'uian hẽéthẽé dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Eẽm ko Jeso ba Jerusalema koe hàna, Paseka dis kõ̱ès dim x'aèm ka, ka ne kò káí ne khóè ne x'áí zi ẽem kò kúrú zi bóò, a ne a Gam dim cg'õèm koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Igabam ko Jeso ba táá tcom ne, wèé ne khóè nem q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Gataga i kò Gam koe qaase tama, c'ẽem khóèm gha c'ẽe khóèan ka nxàea tseegukagu sa. Gabá kò Gam ka q'ana hãa khóèm koe hàna sa khama. ");
INSERT INTO nhr_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Me kò c'ẽem khóèm Farasai xu dim Nikodemase ta ko ma tciiè ba hàna, Juta ne dim tc'ãà-cookg'ai ba. ");
INSERT INTO nhr_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jesom koem kò ntcùú ka hàà, a hàà bìrí Me a máá: “Rabiè, Nqarim koe guua Tsi xgaa-xgaa-kg'ao Tsi i sa ta q'ana hãa; cúí khóè ga Tsáá ko kúrú zi x'áí zi kúrúa hãa tite, Nqarim kò gaan cgoa hãa tama ne khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Me Jeso ba xo̱a me a máá: “Tseegukar ko tseeguan bìrí tsi, a ko máá: Khóèm kò ka̱base ábàè tama nem cuiskaga Nqarim di x'aian bóòa hãa tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Me Nikodemase ba bìrí Me a máá: “Khóè ba ga kháé ntama ma gàeseam hãa koe ábàè? Xõòs di ncãàn koe ba ko kháé gaicara tcãà, a nxãwa ábàè?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Me Jeso ba xo̱a me a máá: “Tseegukar ko tseeguan bìrí tsi, a ko máá: Khóèm kò tshàan hẽé naka Tc'ẽe ba hẽéthẽé ka ábàè tama, nem cuiskaga Nqarim di x'aian koe tcana hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Eẽ cgàam ka ábàèa sa cgàa si i, si ẽe Tc'ẽem ka ábàèa sa Tc'ẽe si i. ");
INSERT INTO nhr_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Táá méé tsi bìrí tsir kòo a ko máá: ‘Ka̱base méé tu ábàè,’ témé ne are guu. ");
INSERT INTO nhr_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Tc'ãá ba ko gam ko tc'ẽe xòè za tc'ãá, tsi ko gam di ts'oo-q'ooan kóḿ, igaba tsi cuiskaga ẽem guua hãa kana ẽem ko qõò qgáìan q'ãa tite. Me wèém khóèm ẽe Tc'ẽem ka ábàè ba gatà ii,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Me Nikodemase ba xo̱a Me a máá: “Ntama zi gha ma ncẽe zi gúù zi kúrúse?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Me Jeso ba xo̱a me a máá: “Tsáá tsia Iseraele di tsi xgaa-xgaa-kg'ao tsi i, igaba tsia ncẽe zi gúù zi ka q'ãa tama? ");
INSERT INTO nhr_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tseegukar ko tseeguan bìrí tsi, a ko máá: Sita q'ana hãa zi gúù zi ka ta ko kg'ui, a ta a ko ẽe ta bóòa hãa zi ka nxàea tseegukagu, igaba tu gatu ẽe ta ko gaas ka nxàea tseegukagu sa dtcòm̀ tama. ");
INSERT INTO nhr_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nqõóm di zi gúù zi kar ko kg'ui cgoa tu u igaba tu dtcòm̀ tama, ka tua gha ntama ma dtcòm̀, ncẽè nqarikg'ai di zi gúù zi kar kòo kg'ui cgoa tu u ne? ");
INSERT INTO nhr_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Cúí khóè ga qanega nqarikg'ai koe qaò ta ga hãa, ẽe nqarikg'ai koe guu a xoana hãam oose, Khóèm dim Cóá ba, ncẽe nqarikg'ai koe hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Eẽm kò ma Moshe tchàa-xgóós koe cg'ao ba ma ghùi khamaga ma méém Khóèm dim Cóá ba ma ghùiè, ");
INSERT INTO nhr_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","nakam gha nxãasega wèém khóèm ẽe ko Gam koe dtcòm̀ ba chõò tamas kg'õè sa úú. ");
INSERT INTO nhr_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Nqari ba nqõó ba ncẽeta noose ncàm̀a hãa domkam kò Gam dim Cóám cúíse ábàèa hãa ba tcg'òóa hãa khama, nxãasegam gha dìím wèém ẽe ko Gam koe dtcòm̀ ba táá kaàkaguè, igabam gha chõò tamas kg'õè sa úú ka. ");
INSERT INTO nhr_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nqari ba kò Gam dim Cóám gha hàà nqõó ba xgàra ka tsééa óá Me tama, igabam kò hààm gha nqõó ba kgoara ka tsééa óá Mea hãa. ");
INSERT INTO nhr_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eẽ ko Gam koe dtcòm̀ ba xgàraè tite, igaba gaam ẽe Gam koe dtcòm̀ tama ba nxãakamaga xgàraèa hãa, Nqarim dim Cóám, ncẽe cúíse ábàèa hãam koem kò táá dtcòm̀ khama. ");
INSERT INTO nhr_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ncẽea xgàrakus ko ma tséé ga a: X'áà ba kò nqõómkg'ai koe hààraa, igabaga i kò khóèan ntcùúan ncàm̀a hãa x'áàn ka, gaan di zi tséé zia kò cg'ãè zi i domka. ");
INSERT INTO nhr_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wèém khóèm ẽe ko cg'ãèan kúrú ba x'áàn hòrea, a x'áàn koe hàà tite khama, nxãasega i gha gam di cg'ãè tsééan táá x'áíse ka. ");
INSERT INTO nhr_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Igaba dìím wèém ẽe ko tseeguan kúrú ba ko x'áàn koe hàà, nxãasega i gha gam di tsééan qãèse bóòse ka, Nqarim ko ma tc'ẽe khamam ma kúrúa hãa sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ncẽe zi gúù zi qãá q'oo koe xu kò Jeso ba hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé xu Jutea dim nqõóm koe qõò. Gaa koem kò síí gaxu cgoa ão, a ba a khóè ne tcguù-tcguu. ");
INSERT INTO nhr_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Me kò thẽé Johane ba Ainone koe khóè ne tcguù-tcguu, ncẽe kò Salime dim x'áém ka cúùse hãam x'áé ba, gaa koe i kò tshàan káí i khama, ne kòo khóè ne gaa koe qõòa tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Johane ba kò qanega qáé-nquus koe tcãàè ta ga hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Xu kò Johanem di xu xgaa-xgaase-kg'ao xu c'ẽem Jutam cgoa q'ano-q'anosean dis ntcoeku sa ghùi. ");
INSERT INTO nhr_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ka xu kò Johanem koe síí, a bìrí me a máá: “Xgaa-xgaa-kg'ao tseè, ẽe kò tsáá cgoa Jorotane ka ncìí za hànam Khóè ba, ẽe tsi kò Gam ka nxàea tseegukagua hãa ba ko ncẽeska khóè ne tcguù-tcguu, i ko wèé khóèan Gam koe síí,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Me Johane ba xo̱a xu a máá: “Khóè ba cuiskaga cúí gúù ga q'õòa hãa tite, nqarikg'ai koem kò guu naka máàè e tama ne. ");
INSERT INTO nhr_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Gaxao igaba xao ga tíí ka nxàea tseegukagu ẽer kòo máá: ‘Tíí ra Krester tama ra a, igaba ra Gam ko hààs cookg'ai koe tsééa tcg'òóèa hãa,’ témé ka. ");
INSERT INTO nhr_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Eẽ séè-kg'aos cgoa hàna ba séè-kg'ao me e, me séè-kg'aom dim tcáràm ẽe téé a ko komsana me ba ko kaisase séè-kg'aom dim dòm̀ ba qãè-tcaoa máá. Gaa domka i ncẽeska tiri qãè-tcaoan cg'oèa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Gam di cgáéan méé i kaisase càùse, naka i tiri cg'áré-cg'árésean kaisase nqãaka síí,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Eẽ tc'amaka guua ba wèé ne ka tc'amaka hàna. Eẽ nqõómkg'ai koe guua ba nqõómkg'ai di me e a ko nqõómkg'ai di zi gúù zi ka kg'ui. Eẽ nqarikg'ai koe guua hãa ba wèé ne tc'amkg'ai koe hàna. ");
INSERT INTO nhr_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Eẽm bóòa hãa, a kóḿa hãa gúùa nem ko nxàea tseegukagu, igaba i cúí khóè ga Gam ko nxàea tseegukagu sa dtcòm̀ tama. ");
INSERT INTO nhr_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Khóèm ẽe ko Gam ko nxàea tseegukagu sa dtcòm̀ ba ko Nqari ba tseegu di Me e sa nxàea tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Eẽm Nqari ba tsééa tcg'òóa hãa ba ko Nqarim di kg'uian kg'ui khama, tc'ãò-tc'ão sa nqáéa hãasem ko Nqari ba Tc'ẽe ba máà Me khama. ");
INSERT INTO nhr_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Xõò ba Gam dim Cóá ba ncàm̀a hãa, a wèé zi gúù zi Gam tshàu q'oo koe tcana hãa. ");
INSERT INTO nhr_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Dìím wèém ẽe ko Cóám koe dtcòm̀ ba chõò tamas kg'õè sa úúa hãa, igaba ẽe ko Cóá ba xguì ba cuiskaga kg'õèan hòò tite, i gha Nqarim di xgóàn gaam koe hãa. ");
INSERT INTO nhr_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Jeso ba kò káí xgaa-xgaase-kg'aoan kúrú, a ba a Johane ba nqáéa hãase káí ne khóè ne tcguù-tcguu. Xu kò Farasai xu ncẽe sa kóḿ. (Igabam ko Jeso ba tcguù-tcguu tama, xu kòo Gam di xu xgaa-xgaase-kg'ao xu ko tcguù-tcguu.) Eẽm ko Jeso ba ẽe kò nxàeè sa kóḿ, kam kò Jutea koe guu a ba a gaicara Galilea koe ka̱bise kg'oana. ");
INSERT INTO nhr_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria dim nqõóm koe méém tcana tcg'oas gúù si i kò ii. ");
INSERT INTO nhr_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Me Samaria koe hànam x'áé-coam Sikare ta ko ma tciièm koe síí tcãà, c'ẽem xháràm Jakobem kò cóásem Josefa ba máà hãam koe. ");
INSERT INTO nhr_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Me kò Jakobem dim tsàù ba gaa koe hãa. Me kò Jeso ba qáòs qõòs koem guua hãa khama xhõea hãa, khamam kò gaam tsàùm qàe koe síí ntcõóa-ntcõe, koaba nqáè e kò ii. ");
INSERT INTO nhr_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Si ko Samaria dis khóè sa gaa koe hàà, tshàa nes gha hàà xài ka, Me Jeso ba bìrí si a máá: “Tshàan au Ter kg'áà,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Xu kò Gam di xu xgaa-xgaase-kg'ao xu x'áém koe tcana hãa, síí xu gha tc'õoan x'ámá ka.) ");
INSERT INTO nhr_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Si Samaria dis khóè sa bìrí Me a máá: “Tsáá Tsi Juta Tsi i, ra tíí Samaria dir khóè ra a. Ka Tsia ga nxãaska ntama ma tshàan dtcàrà te?” témé. Juta ne hẽé naka Samaria ne hẽéthẽéa ko xg'ae qgáìa káà a khama. ");
INSERT INTO nhr_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Me Jeso ba xo̱a si a máá: “Nqarim dis máàku sa si kò q'ana hãa ne, a Dìím ko dtcàrà si sa q'ana hãa, ne si ga ko sáá dtcàrà Mea hãa, Me ga kò kg'õèan di tshàan máà sia hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Si khóè sa bìrí Me a máá: “X'aigaè, xài cgoa Tsi ga gàba Tsi úú tama, me tsàù ba nqúù q'ane me e. Ka Tsia ko nxãaska gaa kg'õèan di tshàan nda hòò? ");
INSERT INTO nhr_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A Tsáá Tsia gatá ka xõòm Jakobem ka kaia hãa, ncẽe kò tsàù ba máà ta ba, i kò gabá hẽé, naka gam ka cóáse ga xu hẽé, naka gam di kg'oo-coan hẽéthẽé gam koe kg'áà ba?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Me Jeso ba xo̱a si a máá: “Wèém khóèm ncẽe tshàan ko kg'áà ba gha gaicara cáḿ. ");
INSERT INTO nhr_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Igaba dìím wèém ẽe gha tshàan ẽer gha máà me kg'áà ba gaicara chõò tamase cáḿa hãa tite. Igaba wèém ẽer gha ko ncẽe tshàan máàm koe i gha chõò tamas kg'õès di tshàan di tsgórèan kúrúse,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Si khóè sa bìrí Me a máá: “X'aigaè, ncẽe tshàan máà te, nakar gha nxãasega táá gaicara cáḿ guu, naka ra nxãasega ncẽe koe hàà xàian ka táá ncẽeta noom dàò ba qõò guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Me Jeso ba bìrí si a máá: “Qõò naka sia síí sarim khóè ba tcii na ka̱bise na hàà,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Si khóè sa xo̱a Me a máá: “Khóè bar úú tama,” témé. Me Jeso ba bìrí si a máá: “Tseegu si ko, ẽe si ko máá, khóè ba si úú tama, témé ka. ");
INSERT INTO nhr_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","5 xu khóè xu si kò úúa hãa, igaba si ncẽeska úúam khóè ba sarim tama me e. Eẽ si ko nxàe gúùa nea tseegu u,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Si khóè sa bìrí Me a máá: “X'aigaè, Tsáá Tsia porofiti Tsi i sar ko bóò. ");
INSERT INTO nhr_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Gatá ka xõò ga xua kòo ncẽem xàbìm koe còrè, igaba tu ko gatu máá, Jerusalema ba gaam qgáìm gaa koe méé ta còrèm ga me e, témé,” tas méé. ");
INSERT INTO nhr_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Me Jeso ba bìrí si a máá: “Khóè seè, dtcòm̀ ẽer ko méés gúù sa: X'aè ba ko hàà ncẽem xàbìm koe kana Jerusalema koe ga igaba tu Abo ba còrèa hãa tite ba ke. ");
INSERT INTO nhr_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Gatu Samaria tua kò c'úùa tu hãa gúùan còrè, ta ko sita Juta ta q'ana ta hãa sa còrè, kgoarasea nea Juta ne koe guua hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Igabam ko x'aè ba hàà, a nxãakamaga hààraa, ncẽe tseeguan di dqo̱m̀-kg'aoan gha Tc'ẽem koe hẽé naka tseeguan koe hẽéthẽé Abo ba dqo̱m̀ ba. Abo ba ko gatà ii ne dqo̱m̀-kg'ao ne qaa khama. ");
INSERT INTO nhr_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nqari ba Tc'ẽe Me e, ke méé ne Gam di ne dqo̱m̀-kg'ao ne Tc'ẽe ba hẽé naka tseeguan koe hẽéthẽé dqo̱m̀ Me,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Si khóè sa bìrí Me a máá: “Mesiam Kreste ta ko ma tciiè ba ko hàà sar q'ana hãa. Eẽm ko hàà nem gha hàà wèé zi gúù zi ka bìrí ta a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Me Jeso ba xo̱a si a máá: “Tíí ncẽe ko sáá cgoa kg'ui Ra gar ga Ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Xu gaa x'aè kaga Gam di xu xgaa-xgaase-kg'ao xu ka̱bise. Eẽ xu ko hàà ka xu kò sao-xg'ae Me Me hãa a ko khóès cgoa kg'ui xu are. Igaba i ko táá cúía xu ga tẽè a máá: “Dùú sa Tsi ko qaa?” kana “Dùús domka Tsia ko gas cgoa kg'ui?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Kas ko gas dim gàbam xài cgoa di ba guu, a sa a x'áé-dxoom koe ka̱bise a síí khóè ne bìrí a máá: ");
INSERT INTO nhr_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Hàà naka síí wèé zi gúù zi ẽer kúrúa hãa zi ka bìrí tea hãam Khóè ba bóò. A Gaam Krestem ga ba ga ii?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ne x'áé-dxoom koe guu a ne a Gam koe síí. ");
INSERT INTO nhr_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Xu gaa x'aè kaga Gam di xu xgaa-xgaase-kg'ao xu Gam cgoa kg'ui a máá: “Xgaa-xgaa-kg'aoè, tc'õó,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Me bìrí xu a máá: “Tc'õó Ra gha tc'õoa ner Tíí úúa hãa, gaxao ka c'úùèa hãa a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Xu xgaa-xgaase-kg'ao xu xóé a bìríku a máá: “Ncãa i gáé c'ẽe khóèan tc'õoan óága máá Me?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Me Jeso ba bìrí xu a máá: “Tiri tc'õoa nea Gaam ẽe tséé Tea hãam ko tc'ẽe sa kúrú si i, naka Gam dis tséé sa xg'ara-xg'ara sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ncẽeta tu gáé gatu méé tama: ‘4 nxoea nea qaùa hãa, me ko nxãwa x'aèm tc'õoan méé i khõáè di ba hàà,’ témé tama? Bóò, bìrí xao or ko, ghùi-kg'ai xao naka bóò xháràn ma x'ãéa hãa, a i a khõáè i gha sa tééa máána hãa. ");
INSERT INTO nhr_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Eẽ ko tc'õoan khõá ba ko surutaè, a ba a ko chõò tamas kg'õès di tc'áróan sáà-xg'ae, tsara gha nxãasega ẽe ko xhárà ba hẽé naka ẽe kò khõá ba hẽéthẽé tsara xg'ae a qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ncẽem kg'ui ba tseegu me e khama, ncẽe ko máá: ‘C'ẽe ba ko xhárà, me ko c'ẽe ba khõá!’ témé ba. ");
INSERT INTO nhr_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Tséé xaoa Ra hãa, síí xao gha ẽe xao tséé tama koe khõá ka. C'ẽe nea gaa koe tsééa hãa, xao ko gaxao gane di tsééan koe tcuù,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ne kò káí ne Samaria ne ẽem x'áé-dxoom di ne Gam koe dtcòm̀, kg'uim khóès kò nxàea tseegukagua hãam domka, ncẽe kòo máá: “Wèé zi gúù zi ẽer kúrúa hãa zi kam bìrí tea hãa,” témé ba. ");
INSERT INTO nhr_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eẽ ne ko Samaria ne Gam koe hàà, ka ne kò dtcàrà Me gane cgoam gha hãa sa, Me cám̀ cáḿan hãa cgoa ne. ");
INSERT INTO nhr_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ne kò Gam di kg'uian domka kaisase káí ne dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","A ne a khóè sa bìrí a máá: “Ncẽeska ta ẽe si nxàea hãa gúùan domka cúí dtcòm̀ tama, igaba ta ncãa kóḿa mááse Me, a ta a ncẽem khóè ba nqõóm dim Kgoara-kg'ao Me e sa ncẽeska q'ana hãa,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Eẽ tsara cáḿ tsara qãá q'oo koem kò gaa koe tcg'oa a Galilea koe qõò. ");
INSERT INTO nhr_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(Jeso ba kò Gam ka nxàea tseegukagua hãa, porofiti ba gam dim x'áém koe dtcòm̀mè tamam khóè me e sa khama.) ");
INSERT INTO nhr_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Eẽm ko Galilea koe tcãà, ka ne kò Galilea di ne khóè ne qãèse hààkagu Me. Wèé zi gúù zi ẽem kò Jerusalema koe kõ̱ès dim cáḿ ka kúrúa hãa zi ne kò bóòa hãa khama, gane igaba ne ko gaas kõ̱ès koe hààraa khama. ");
INSERT INTO nhr_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Gaiam kò Kana dim x'áém koe síí Galilea di i, ncẽe gaa koem kò tshàan kúrú i gõé ii koe. Me kò Kaperenaume koe c'ẽem tc'ãà-cookg'ai ba hãa, ncẽe gam dim cóám kòo tsàa ba. ");
INSERT INTO nhr_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eẽm ko Jeso ba Jutea koe guu a Galilea koe hààraa hãa sa kóḿ, kam kò Gam koe síí a dtcàrà Me, hààm gha gam dim cóá ba kg'õèkagu ka, ncẽe ko x'oos qàe koe hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Me Jeso ba bìrí me a máá: “X'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé tu kò bóò tama ne tu cuiskaga dtcòm̀ tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Me x'aiga-coa ba bìrí Me a máá: “X'aigaè, cóám tirim x'óó tamas cookg'ai koe hàà,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Me Jeso ba xo̱a me a máá: “Tsarim cóá ba gha kg'õè ke qõò,” témé. Me khóè ba ẽem Jeso ba bìrí mea kg'uian dtcòm̀, a ba a qõò. ");
INSERT INTO nhr_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Qanegam dàòm q'oo koe hãa a ko qõò, ka xu kò gam di xu qãà xu qãè tchõàn gam dim cóá ba kg'õèa hãa di cgoa hàà xg'ae cgoa me. ");
INSERT INTO nhr_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Me dùútsa x'aèm kam kò cóá ba qãè sa tẽè xu, xu bìrí me a máá: “Ncẽe ncãa nqáém cáḿ ka i ncãa tcììan guu me, koaba di x'aè ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Me kò cóám ka xõò ba nxãaska q'ana hãa gaam x'aèm ẽem ka gam kò Jeso ba bìrí mea hãa a máá: “Tsarim cóá ba gha kg'õè,” témé sa. Ka ne kò gabá hẽé naka gam dim nquum di ne wèé ne hẽéthẽé dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ncẽea kò cám̀ dis x'áís ga si i, Jesom kò Jutea koe guu a Galilea koe hàà kam kò kúrúa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ncẽe zi gúù zi qãá q'oo koem kò Jeso ba Jerusalema koe qõò, c'ẽes kõ̱ès Juta ne di sa kò gaa koe hàna khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nxãaskas kò Jerusalema koe heke-kg'áḿ sa hàna, ncẽe kò ‘Ghùuan dis Heke-kg'áḿ sa’ ta ma tciiè sa. Me kò ncẽes heke-kg'áḿs qàe koe tèbe ba hãa, Hebera dis kg'uis ka ko ‘Betesata’ ta ma tciiè ba, 5 zi xàò-xao zi kò úúa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Gaa zi xàò-xao zi koe ne kò káí ne khóè ne tsàako ne hãa, káà tcgáí ne hẽé naka qõò tama ne hẽé naka nqo̱ara ne hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Nxãaskam kò c'ẽem khóè ba gaa koe hàna, 38 kurian kòo úú a kò tsàa ba. ");
INSERT INTO nhr_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eẽm ko Jeso ba bóò me, me gaa koe xóé-xõe, kam kò ncìísem tsàara hãa sa bóòa q'ãa, a tẽè me a máá: “A qãè kg'oana tsia?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Me ẽem tcìì-khoe ba xo̱a me a máá: “X'aigaè, cúí khóè gar úú tama ẽem kòo tshàa ba ko̱bi-ko̱bise ne gha gaam koe tcãà te e. Eẽr kò tcãà kg'oana ne i ko c'ẽe khóèan tíí ka tc'ãà a tcãà,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Me Jeso ba bìrí me a máá: “Tẽe naka tsarim tcoà ba séè naka tsia qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Me gaam khóè ba kúúga qãè. A ba a gam dim tcoà ba séè, a qõò. Eẽm cáḿ ba kò Sabata dim cáḿ me e. ");
INSERT INTO nhr_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ka xu kò Juta xu ẽe ko qãèkaguèam khóè ba bìrí a máá: “Sabata dim cáḿ me e khama tsi tsarim tcoà ba tsi ga séè sa kgoara mááè tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Me xo̱a xu a máá: “Khóèm ẽe qãèkagu tea ba ncãa bìrí te a máá: ‘Tsarim tcoà ba séè naka tsia qõò,’ témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ka xu kò tẽè me a máá: “Dìí ba ẽem khóè ba ncẽe ko máá, tcoà ba méé tsi séè naka qõò, témé ba?” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Igabam kò ẽe qãèkaguèam khóè ba c'úùa hãa dìí Me e kò ii sa, Jeso ba kò qõòa hãa, ne kò gataga gaam qgáìm koe kò hãa ne khóè ne káí ne e thẽé khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Eẽ zi gúù zi qãá q'oo koem kò Jeso ba tempelem koe sao-xg'ae me, a bìrí me a máá: “Bóò, ncẽeska tsi qãè tsi i. Táá méé tsi gaicara chìbian kúrú guu, nxãasega i gha kaisase cg'ãè gúùan táá kúrúse cgae tsi ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Me gaam khóè ba tcg'oa, a síí Juta xu bìrí, Jeso Me e kò ii, ncẽe kò qãèkagu mea hãa ba sa. ");
INSERT INTO nhr_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ka xu kò gaas kaga Juta xu tshoa-tshoa a Jeso ba xgàra, Sabata dim cáḿ kam kò ncẽe zi tséé zi kúrúa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Me Jeso ba bìrí ne a máá: “Tirim Abo ba ko wèé x'aè ka tséé, ncẽeskaga igaba, Ra ko Tíí igaba thẽé tséé,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Gaa domkaga ne kò Juta ne cg'õo Me ne gham dàò ba kaisase tcg'aì-tcaoa hãase qaa, Sabata dim cáḿ di x'áèan cúím kò khõá tama, igabam kò thẽé máá, Nqari ba Gam ka Xõòm tc'áró-tc'aro Me e, ta mééa, a kòo Nqarim cgoa tc'ãò-tc'ãose. ");
INSERT INTO nhr_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Me Jeso ba xo̱a ne a máá: “Tseegukar ko tseeguan bìrí tu u, a ko máá: Cuiskagam Cóá ba c'ẽe gúù cúí ga kúrúa hãa tite, igabam gha ẽem ko Xõò ba bóò Me ko kúrús cúí sa kúrú. Wèés ẽem ko Xõò ba kúrú sam ko Cóá ba gataga thẽé kúrú khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Xõò ba Cóá ba ncàm̀a hãa, a ko wèé zi ẽem ko kúrú zi x'áí Me. A ba a gha ncẽe zi tséé zi ka kaia hãa zi tséé zi x'áí Me, nxãasega tu gha are ka. ");
INSERT INTO nhr_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Eẽm ko Xõò ba ẽe x'óóa hãa ne ghùi a kg'õèkagu khamagam gha ma Cóá ba ẽem ncàm̀a hãa ne kg'õèkagu. ");
INSERT INTO nhr_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Abo ba cúí khóè ga xgàra tama, igabam Cóáse ba wèé qarian xgàran di máàna hãa, ");
INSERT INTO nhr_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","nxãasega ne gha wèéa ne ga Cóá ba tcom ka, ẽe ne ma Xõò ba tcoma hãa khamaga ma. Eẽ Cóá ba tcom tama nea Xõòm ẽe tséé Mea hãa ba tcom tama. ");
INSERT INTO nhr_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tseegukar ko tseeguan bìrí tu u, a ko máá: Eẽ ko Tiri kg'uian komsana, a ko Gaam ẽe tséé Tea hãam koe dtcòm̀, ba chõò tamas kg'õè sa úúa hãa, a xgàrakuan koe tcãà tite, igabam x'ooan koe tcg'oara hãa, a kg'õèan koe tcana hãa. ");
INSERT INTO nhr_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tseegukar ko tseeguan bìrí tu u, a ko máá: X'aè ba ko hàà, a nxãakamaga hààra xg'araa, ẽe x'óóa hãa ne gha Nqarim dim Cóám dim dòm̀ ba kóḿ ba, ne gha gane ẽe ko kóḿ Me ne kg'õè. ");
INSERT INTO nhr_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Eẽm ma Xõò ba ma Gam ka kg'õèan úúa hãa khamagam gataga thẽé Cóáse ba qarian máàna hãa, Gam kam gha kg'õèan úú di i. ");
INSERT INTO nhr_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","A ba a Cóá ba xgàram gha di qarian máàna hãa, Khóèm dim Cóá Me e khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Táá méé tu ncẽes gúùs ka arekaguè guu, x'aè ba ko hàà wèé ne ẽe tc'ám̀ zi koe hàna ne gha Gam dim dòm̀ ba kóḿ ba ke, ");
INSERT INTO nhr_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","a ne a gha gane di zi tc'ám̀ zi koe tcg'oa: ẽe kò qãèan kúrúa hãa ne gha tẽe a kg'õè, ne gha ẽe kò cg'ãèan kúrúa hãa ne tẽe a xgàraè. ");
INSERT INTO nhr_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Tíí ra cúí gúù ga cúía kúrúa hãa tite. Eẽr ko ma Abom koe ma kóḿ khamar ko ma xgàra, i Tiri xgàra-q'ooan tchàno o, Tíí ko tc'ẽe sar qaa tama, igabar ko ẽe tséé Tea hãam ko tc'ẽe sa kúrú khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Tíí kar kòo nxàea tseegukagua mááse nes Tiris nxàea tseegukagu sa cuiskaga tseegu di sa ii tite. ");
INSERT INTO nhr_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","C'ẽe ba hàna ẽe ko Tíí ka nxàea tseegukagu ba, Ra q'ana hãa ẽem gha ko Tíí ka nxàea tseegukagus kg'ui sa tseegu di si i sa. ");
INSERT INTO nhr_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Johanem koe tu kò khóèan tsééa úú, me kò síí tseeguan nxàea tseegukagu. ");
INSERT INTO nhr_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Khóèan di nxàea tseegukagua ner ko dtcòm̀s tama si i, igabar ko ncẽe zi gúù zi kg'ui, kgoaraè tu gha ka. ");
INSERT INTO nhr_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johane ba kò x'áà-x'aa-kg'ai cgoa dis gúùs ka̱ruko a ko x'áàs khama ii, tu kò x'aè-coam ka tu gha gam di x'áàn koe qãè-tcao sa tc'ẽe. ");
INSERT INTO nhr_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Nxàea tseegukagu sar úúa, ncẽe Johanem dis kaga kaia hãa sa. Ncẽe zi tséé zim Abo ba máà Tea hãa, xg'ara-xg'ara zir gha ka, gazi ncẽer ko kúrú zi ko Tíí ka nxàea tseegukagu khama, Abom tséé Tea hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Abom ncẽe tséé Tea hãa ba Tíí ka nxàea tseegukagua hãa. Tu gatu qanega dòm̀a ba kóḿ ta ga hãa, kana kg'áía ba igabaga tu bóò ta ga hãa. ");
INSERT INTO nhr_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Gam di kg'uian igaba i gatu koe hãa tama, ẽem tsééa hãa ba tu dtcòm̀ tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nqarim di zi Tcgãya zi tu ko kaisase bóò q'oo, gatua tc'ẽea máá, gazi koe tu gha chõò tamas kg'õè sa hòò, ta tc'ẽea khama. Igabaga zi ko ẽe zi Tcgãya zi Tíí ka nxàea tseegukagu. ");
INSERT INTO nhr_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Igabaga tu ko Tíí koe hààn xguì, hàà tu gha kg'õèan hòò ka. ");
INSERT INTO nhr_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Dqo̱m̀kua ner khóèan koe qaa tama. ");
INSERT INTO nhr_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Igabar q'ana hãa nta ii tu khóè tu u sa, Nqarim di ncàm̀kuan tcáóa tu q'oo koe úú tama tu. ");
INSERT INTO nhr_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Abom dim cg'õèm cgoar hààraa, igaba tu kò táá séèa mááse Te. Igabaga ncẽè c'ẽem khóèm kòo gam di cg'õèan cgoa hàà ne tu ko séèa mááse me. ");
INSERT INTO nhr_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nta tu gha ma dtcòm̀, ncẽè gatu ka c'ẽea ne koe cúíga tu kòo dqo̱m̀an qaara mááse, a tu a Nqarim cúím koe guua hãa dqo̱m̀an qaa tama ne? ");
INSERT INTO nhr_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Igaba méé tu táá tc'ẽea máá, Nqarim cookg'ai koer gha Tíí chìbi-chibi tu u, ta tc'ẽea guu. Gatua gha chìbi-chibi tu um khóè ba Moshe me e, gatu di nqòòan tu gam koe tòóa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ncẽè Moshe ba tu kò dtcòm̀a hãa, ne tu ga kò Tíí thẽé dtcòm̀ Tea hãa, Tíí kam góáa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Igaba ncẽè gam góáa hãa zi tu kò dtcòm̀ tama, ne tua gha nxãaska Tíí ko méé zi ntama dtcòm̀?” tam Jeso ba méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ncẽe zi gúù zi qãá q'oo koem kò Jeso ba Galilea dim tshàam ka c'ẽe xòèa ba za tchoaba, ncẽe Tiberia di ta kòo ma tciiè e. ");
INSERT INTO nhr_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Si kò kaias xg'aes khóè ne di sa xùri Me, ẽe kòo tsàa ne khóè ne koem kò kúrú zi x'áí zi ne kò bóò khama. ");
INSERT INTO nhr_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Me Jeso ba xàbìm di c'ẽe xòèa ba za q'ábà qaò, a síí Gam di xu xgaa-xgaase-kg'ao xu cgoa gaa koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Si kò Juta ne dis kõ̱ès Paseka di sa cúù si i. ");
INSERT INTO nhr_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Eẽm ko Jeso ba ghùi-kg'ai a ko kaias xg'aes khóè ne di sa bóò si ko Gam koe hàà, kam kò Filipi ba bìrí a máá: “Nda xae gha síí péréan x'ámá, ncẽe ne khóè ne gha hàà tc'õó o?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Ncẽetam ko ma kúrúa bóòa ba domka tẽè me, tc'ẽea ba koem kò nxãakamaga q'ana hãa dùú sam gha kúrú sa khama.) ");
INSERT INTO nhr_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Me Filipi ba xo̱a Me a máá: “Khóèm ko 8 nxoean q'oo koe gàbakaguè maria ne cuiskaga tc'ãò tite, ncẽeta noo ne khóè ne tc'õókagua ne!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Me Gam di xu xgaa-xgaase-kg'ao xu ka c'ẽem Anteream ncẽe Simonem Peterem ka káímkhoe ba kg'ui a máá: ");
INSERT INTO nhr_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“C'ẽem cóá ba ncẽe koe hãa, 5 xu péré xu hẽé naka cám̀ x'aù tsara hẽéthẽé qgóóa hãa ba, ka sa ncẽe sa dùú cgáé saa ncẽeta noo ne khóè ne koe?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Me Jeso ba máá: “Khóè ne xao bìrí naka ne ntcõó,” témé. Káí dcãa nea kò ẽem qgáìm koe hãa khama. Ne kò wèé ne khóè ne ntcõó, 5,000 khama noo xu khóè xu u kò ii. ");
INSERT INTO nhr_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Me Jeso ba nxãaska péré xu séè, a ba a Nqari ba qãè-tcaoa máá, a khóè ne ẽe koe kò ntcõóa-ntcõe ne máà xu, ne kò ẽe ne ko ma tc'ẽe khama ma tc'õó. A ba a kò x'aùan ka thẽé gataga hẽé. ");
INSERT INTO nhr_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eẽ ne ko wèé ne tc'õóa xg'ara a ko xg'ãà, kam kò Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Sáà xg'ae péré qàmàn ẽe qaùa hãa a, naka i gha nxãasega táá cúí gúù ga nco̱iè guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xu kò ẽe khóè ne ka kò tc'õóa qaùè péréan ka 12 xu q'ore xu péré qàmàn di xu tcãà, xu cg'oè, ẽe xu péré xu 5 xu koe guu a. ");
INSERT INTO nhr_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eẽ ne ko khóè ne x'áís ẽem kò Jeso ba kúrúa hãa sa bóò, ka ne ko tshoa-tshoa a máá: “Tseegukagam Gaam porofitim ga Me e nqõóm koe ga ko hàà ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Me kò Jeso ba, hàà ne ko kgãà ka séè a x'aiga ba kúrú Me sa nxãakamaga q'ana hãa, khamam kò tcg'oaragu ne a xàbìm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Eẽ i ko dqòa ka xu kò Gam di xu xgaa-xgaase-kg'ao xu tshàam koe qõò, ");
INSERT INTO nhr_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","a xu a síí dxòrom koe tcãà a tshàa ba tchoaba a Kaperenaume koe qõò. Ntcùú u kò ii, Me kò Jeso ba qanega hàà cgae xu ta ga hãa. ");
INSERT INTO nhr_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tshàa ne kò ko̱bi-ko̱bise, kaiam tc'ãá ba kòo tc'ãá khama. ");
INSERT INTO nhr_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Eẽ xu ko 5 kana 6 di qáò-q'ooan khama noo kilomitaran qõò, ka xu kò Jeso ba bóò Me tshàam tc'amkg'ai koe ko náà qõò, a ko dxòrom koe cúù, ka xu kò q'ae. ");
INSERT INTO nhr_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Igabam kò bìrí xu a máá: “Tíí Ra a. Ke xao táá q'áò guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ka xu kò dxòrom koem gha gaxu cgoa hãa sa qãè-tcaoa máána hãa, igabam kò dxòro ba ẽe xu kòo qõòm nqõóm koe kúúga síí tcãà, a síí góḿankg'ai koe téé. ");
INSERT INTO nhr_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Xùrikom cáḿ kas kò khóè ne dis xg'aes ẽe kò tshàam ka ncìí za hãa sa cúím dxòro ba hãa sa bóò, Me Jeso ba qanega Gam di xu xgaa-xgaase-kg'ao xu cgoa gaam koe tcãà ta ga hãa, igaba xu kò xgaa-xgaase-kg'ao xu cuiaga qõòa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nxãaska xu kò c'ẽe xu dxòro xu Tiberia koe guua hãa xu, ẽem kò X'aiga ba péréan qãè-tcaoa máá xg'ara si xg'ae sa ntcõó a ko tc'õó qgáì qàe ka cúùse hàà. ");
INSERT INTO nhr_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eẽs ko khóè ne dis xg'ae sa Jesom káà ii, xu Gam di xu xgaa-xgaase-kg'ao xu thẽé káà xu u sa bóòa q'ãa, ka ne kò dxòro xu koe tcãà a ne a Kaperenaume koe qõò, a síí Jeso ba qaa. ");
INSERT INTO nhr_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Eẽ ne ko tshàam ka ncìí za síí sao-xg'ae Me ka ne kò tẽè Me a máá: “Xgaa-xgaa-kg'ao Tseè, ncẽe koe Tsi n-cáḿa hààraa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Me Jeso ba xo̱a ne a máá: “Tseegukar ko tseeguan bìrí tu u, a ko máá: X'áí zi tu bóòa hãa domka tu qaa Te tama, igabaga tu péréan tc'õó a xg'ãà hãa domka a. ");
INSERT INTO nhr_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Táá méé tu kaàko tc'õoan tséé-kg'am guu, igaba méé tu chõò tamas kg'õès koe gha hãa tc'õoan tséé-kg'am, Khóèm dim Cóám gha máà tu u. Nqarim Abo ba Gam koe x'áí sa tòóa hãa Gaam dim cóám ii di sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ka ne ko nxãaska tẽè Me a máá: “Dùú sa ta gha kúrú, a nxãasega Nqarim ko tc'ẽe sa kúrú?” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Me Jeso ba xo̱a ne a máá: “Nqarim ko tc'ẽe sa ncẽe si i: Gaam ẽem tsééa hãam koe tu gha dtcòm̀ si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ka ne kò nxãaska xo̱a Me a máá: “Dùútsa x'áí sa Tsi gha Tsáá kháé kúrú, ta nxãasega bóò a Tsáá koe dtcòm̀? Dùú sa Tsi gha kúrú? ");
INSERT INTO nhr_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gatá ka xõò ga nea ko tchàa-xgóós koe Mana ta ko ma tciiè péréan tc'õó. Ncẽe i ma góásea a ko máá: ‘Nqarikg'ai koe guua hãa péré nem kò máà ne ne tc'õó,’ témé khamaga ma,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Me Jeso ba bìrí ne a máá: “Tseegukar ko tseeguan bìrí tu u, a ko máá: Moshem tama me e kò ii, ẽe nqarikg'ai koe guua hãa péréan máà tu ua ba, igaba Abo Me e kò ii, ẽe tseegu di péréan nqarikg'ai koe guua hãa máà tu ua ba. ");
INSERT INTO nhr_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nqarim di péréa ne Gaam ẽe nqarikg'ai koe guu a xoana hãam ga Me e khama, nqõó ba kg'õèan máàna hãa ba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ne bìrí Me a máá: “X'aigaè, ẽe péréan wèé cáḿ ka máà ta a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Me Jeso ba bìrí ne a máá: “Tíí Ra kg'õèan dir Péré Ra a. Dìím wèém ẽe ko Tíí koe hàà ba cuiskaga xàbà hãa tite, me dìím wèém ẽe ko Tíí koe dtcòm̀ ba cuiskaga gaicara cáḿa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Igaba ẽer ma bìrí tua khama: bóò Tea tu hãa igaba tu qanega dtcòm̀ tama. ");
INSERT INTO nhr_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wèém khóèm ẽem Abo ba máà Tea hãa ba gha Tíí koe hàà, Ra dìím wèém ẽe gha ko Tíí koe hàà ba tchàa koe aagua hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nqarikg'ai koer guu a xoana hãa, hààr gha Tíí ko tc'ẽe sa kúrú ka tamase, igaba ẽe tséé Tea hãam ko tc'ẽe sar gha hàà kúrú ka khama. ");
INSERT INTO nhr_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ncẽea Gaam ẽe tséé Tea hãam ko tc'ẽes ga si i: wèé ne khóè ne ẽem máà Tea hãa ne ka méém táá cúím ga ba aaguse guu, igaba méém còo dim cáḿ ka ghùiè. ");
INSERT INTO nhr_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ncẽea Abom ko ma tc'ẽe ga a khama: Wèém ẽe ko Cóá ba bóò, a ko Gam koe dtcòm̀ ba gha chõò tamas kg'õè sa úú. Ra gha nxãaska Tíí còo dim cáḿ ka x'ooan koe ghùi me,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ne kò Juta ne tshoa-tshoa a Gam ka kg'ui-kg'uise, ncẽetam kò méé a máá: “Tíí Ra nqarikg'ai koe guu a xoana hãar Péré Ra a,” ta mééa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","A ne a máá: “Ncẽe ba gáé Jesom tama baa, Josefam ka Cóáse ba, ncẽe xõò ba hẽé naka xõò sa hẽéthẽé khara ta q'ana hãa ba? Ntama ba gha ncẽeska máá: ‘Nqarikg'ai koer guu a xoana hãa,’ témé?” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Me Jeso ba xo̱a ne a máá: “Táá tu gatu ka kg'ui-kg'uise guu. ");
INSERT INTO nhr_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Cúí khóè ga cuiskaga Tíí koe hàà tite, Abom ncẽe tsééa óá Tea hãam kòo Tíí koe tsééa úú u ne cúí ga a, Ra gha còo dim cáḿ ka x'ooan koe ghùi ne. ");
INSERT INTO nhr_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Góásea i hãa porofiti xu di zi Tcgãya zi koe, a ko máá: ‘Wèéa nea gha Nqarim ka xgaa-xgaaè,’ témé. Me gha dìím wèém ẽe ko Abom koe komsana a ko Gam koe xgaa-xgaase ba Tíí koe hàà. ");
INSERT INTO nhr_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Cúí khóè ga Nqari ba bóò ta ga hãa, Gaam ẽe Nqarim koe guua hãam Cúím oose. Gaam Cúí ba Abo ba bóòa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tseegukar ko tseeguan bìrí tu u, a ko máá: Gaam ẽe ko dtcòm̀ ba chõò tamas kg'õè sa úúa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Tíí Ra kg'õèan dir Péré Ra a. ");
INSERT INTO nhr_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gatu ka tsgõose ga xua kò tchàa-xgóós koe Mana ta ko ma tciiè péréan tc'õó, a kò x'óó. ");
INSERT INTO nhr_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Igaba nqarikg'ai koe guua hãa Péréan ga ncẽe e, ncẽe khóèan ga tc'õó, a táá x'óó o. ");
INSERT INTO nhr_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Tíí Ra kg'õèan dir Péré Ra a nqarikg'ai koe guua hãa Ra. Ncẽè c'ẽem khóèm kòo ncẽe Péréan tc'õó nem gha chõò tamase kg'õè. I ncẽe Péréan Tiri cgàa a, ncẽer gha nqõóm di kg'õèan di iise tcg'òó o. ");
INSERT INTO nhr_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ne kò Juta ne xgóàse kg'ui cgoaku a máá: “Ntama ba gha ncẽem khóè ba cgàaa ba máà ta a ta tc'õó?” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Me Jeso ba bìrí ne a máá: “Tseeguan kar ko tseeguan bìrí tu u, a ko máá: Khóèm dim Cóám di cgàan tu kò tc'õó tama, a tu a c'áòa ba kg'áà tama ne tu gatu koe kg'õèan úú tama. ");
INSERT INTO nhr_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dìím wèém ẽe gha Tiri cgàan tc'õó, a Tiri c'áòan kg'áà ba chõò tamas kg'õè sa úúa hãa, Ra gha còo dim cáḿ ka x'ooan koe ghùi me. ");
INSERT INTO nhr_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tirim cgàa baa tseegu dim tc'õo me e, i Tiri c'áòan tseegu di kg'áà gúù u khama. ");
INSERT INTO nhr_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Dìím wèém ẽe ko Tiri cgàan tc'õó a ko Tiri c'áòan kg'áà ba gha Tíí koe hãa, Ra gha Tíí gam koe hãa. ");
INSERT INTO nhr_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Eẽm ma kg'õèa hãam Abo ba ma tsééa óá Tea hãa, Ra Abom domka kg'õèa hãa, khamagam gha ma ẽe ko Tíía tc'õó Te ba Tíí domka kg'õè. ");
INSERT INTO nhr_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ncẽea nqarikg'ai koe guu a xoana hãa Péréan ga a. Gatu ka tsgõose ga xua Mana ta ko ma tciiè péréan tc'õó, a x'óóa hãa, igabagam gha ẽe gha ncẽe Péréan tc'õó ba chõò tamase kg'õè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ncẽe zi gúù zim kò ẽem kò Kaperenaume dim còrè-nquum koe hãa a ko xgaa-xgaa ka kg'ui. ");
INSERT INTO nhr_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Káí xu xgaa-xgaase-kg'ao xu Jesom di xu kò kóḿ Me, ka xu ko máá: “Ncẽe kg'uia nea qóḿ m. Dìína gha kóḿa q'ãa a?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Me kò Jeso ba Gam ka q'ana hãa, Gam di xu xgaa-xgaase-kg'ao xu kò gaan ka kg'ui-kg'uise sa, khamam kò tẽè xu a máá: “Ncẽes gúù sa gáé ko tshúù-tshuu tcáó xao o? ");
INSERT INTO nhr_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kháé xaoa gha nta méé, ncẽè Khóèm dim Cóá ba xao kòo bóò Me ko ẽem ko kg'aia hãa koe qaò ne? ");
INSERT INTO nhr_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tc'ẽe ba ko kg'õèan máàm ga Me e, me cgàa ba cúí hùi ga úú tama. Eẽr kò kg'ui cgoa tu u kg'uia nea kg'õèan ko máàm tc'ẽem koe guua hãa. ");
INSERT INTO nhr_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Igaba ne gatu ka c'ẽe ne hàna ncẽe dtcòm̀ tama ne,” tam méé. (Dìína dtcòm̀ tama, i gha dìín khóè ne tshàu q'oo koe tcãà Me sam kò Jeso ba tshoa-tshoases koe ga guu a q'ana hãa khama.) ");
INSERT INTO nhr_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Me gaia kg'ui a máá: “Gaa domkar kò bìrí tua hãa a ko máá: Cúí khóè ga Tíí koe hàà tite, ncẽè Abom kò kgoara máá a tama ne, témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Eẽm x'aèm koe guu ka ne kò káí ne xgaa-xgaase-kg'ao ne Gam di ne kháóka tòóa dìbise a táá xùri Me. ");
INSERT INTO nhr_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Me Jeso ba 12 xu tẽè a máá: “Gaxao igaba xaoa qõò kg'oana?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Me Simone Petere ba xo̱a Me a máá: “X'aigaè, dìín koe xae gha qõò? Tsáá Tsia chõò tama kg'õèan di kg'uian úúa hãa ka! ");
INSERT INTO nhr_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Dtcòm̀ xae ko, a xae a q'ana hãa Tsáá Tsia Nqarim di Tsi i sa, ncẽe Tcom-tcomsa Tsi,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Me Jeso ba xo̱a a máá: “Tíí ga Ra gáé kò gaxao 12 xao nxárá tcg'òóa mááse tama? Igabam gaxao ka c'ẽe ba dxãwa me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Jutasem, Simonem Isekariotem ka cóáse bam kòo nxàe, Jutase ba kò xgaa-xgaase-kg'ao xu ka c'ẽe me e, igabam kò khóè ne tshàu q'oo koe hàà tcãà Me khama.) ");
INSERT INTO nhr_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Eẽ zi gúù zi qãá q'oo koem kò Jeso ba Galilea koe qõòa te, Juta ne di xu kaia xu kò cg'õo Me kg'oana hãa khamam kò Jutea koem gha qõòa te sa tc'ẽe tama. ");
INSERT INTO nhr_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Me kò x'aèm Juta ne di zi xháì zi tshào dis kõ̱ès di ba cúù me e, ");
INSERT INTO nhr_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","xu kò Jesom ka qõese ga xu bìrí Me a máá: “Ncẽe koe méé Tsi tcg'oa naka Tsia Jutea koe qõò, naka ne Tsari ne xgaa-xgaase-kg'ao ne síí nxãasega kúrú Tsi ko zi gúù zi bóò. ");
INSERT INTO nhr_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Cúí khóè ga káà a gaan di zi gúù zi gha xàìa hãase kúrú u, q'ãaè i gha sa i ko tc'ẽe ne. Gaa domka méé Tsi nqõóm koe x'áíse!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Xu kò Gam ka qõese ga xu igaba Gam koe dtcòm̀ tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Me Jeso ba bìrí xu a máá: “Tirim x'aèm qãè ba qanega hàà ta ga hãa, igaba i gaxao ka wèé x'aèan ga qãèa máá xaoa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nqõó ba cuiskaga gaxaoa hòre xao o tite, igabam Tíía hòre Tea, cg'ãè zi tséé zi ẽem ko kúrú zir ko nxàea tseegukagu khama. ");
INSERT INTO nhr_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Qõò xao kõ̱ès koe gaxao ka. Tíí kam x'aè ba qanega hàà ta ga hãa khamar síí tite ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ncẽetam ko méé kam kò Galilea koe qaù. ");
INSERT INTO nhr_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Eẽ xu ko qõese ga xu kõ̱ès koe qõò, kam kò Gam igaba thẽé xgoaba a qõò, khóè ne ka hòòè tamase igaba xàìa hãase. ");
INSERT INTO nhr_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Xu kò Juta xu kõ̱ès koe qaa Me a tẽè a máá: “Gaam Khóè ba nda?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eẽ zi xg'ae zi khóè ne di zi koe i kò Gam ka káí kg'ui-kg'uisean hãa. Ne kò c'ẽe ne máá: “Qãèm khóè Me e,” témé, ne ko c'ẽe ne máá: “Eẽ ẽe, khóè nem ko ho̱àkagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Igaba i kò cúí khóè ga kgoarasease Gam ka kg'ui tama, Juta xu ne kòo bèe khama. ");
INSERT INTO nhr_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Me kò Jeso ba kõ̱ès nqáè koe tempelem koe tcãà, a xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ka xu kò Juta xu kaisase are a xu a tẽè a máá: “Ncẽem khóè ba ncẽe xgaa-xgaan ntama ma hòòa, ncẽe qanegam xgaa-xgaaè e tama ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Me Jeso ba xo̱a xu a máá: “Tiri xgaa-xgaa nea Tiri tama. Igaba i Gaam ẽe tséé Tea hãam koe guua. ");
INSERT INTO nhr_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ncẽè c'ẽem khóèm kòo Nqarim ko tc'ẽe sa kúrú kg'oana hãa, nem gha bóòa tcg'òó, Tiri xgaa-xgaan Nqarim koe guua hãa, kana Ra ko Tíí ka kg'ui sa. ");
INSERT INTO nhr_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Gaam ẽe ko cúíaga gam ka kg'ui ba ko dqo̱m̀kuan qaara mááse. Igaba gaam ẽe tséé mea hãam di dqo̱m̀kuan ko qaa ba tseegu di me e, i gam koe cúí cg'ãè ga káà a. ");
INSERT INTO nhr_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moshe ba gáé x'áè-kg'áḿan máà tu u ta ga hãa? Gataga i ii, igaba i cúía tu ga x'áè-kg'áḿan ko méé sa kúrú tama! Dùús domka tu ko cg'õo Te tu gha sa tc'ẽe?” tam ma tẽè ne. ");
INSERT INTO nhr_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Si xg'ae sa xo̱a Me a máá: “Dxãwa tc'ẽean Tsi úúa hãa! Dìí na cg'õo Tsi kg'oana?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Me Jeso ba xo̱a ne a máá: “Cúís tséés are-aresa sar kò kúrú, tu kò wèéa tu ga are. ");
INSERT INTO nhr_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moshe ba kò x'áè-kg'áḿan gatu di xu cóá xu tu gha q'ãe nqãa-qgai khòo di máà tua hãa, tu ko Sabata dim cáḿ ka gatu di cóán q'ãe nqãa-qgai khòo (ẽe x'áèa nea kò Moshem koe guu tama, a kò khóè xuku xu koe guua hãa igaba), ");
INSERT INTO nhr_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","nxãasega tu gha Moshem di x'áè-kg'áḿan komsana ka. Kháé nxãaska ncẽè cóám kò ko Sabata dim cáḿ ka q'ãe nqãa-qgai khòoè, Moshem di x'áè-kg'áḿan gha táá ntcoeè ka, ne tu ko dùús domka xgóà cgae Tea máá, ncẽè Sabata dim cáḿ kar kò khóèm dim tc'áróm wèé ba qãèkagu ne? ");
INSERT INTO nhr_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Táá tu tcgáían di bóò-q'ooan cgoa bóòa tcg'òó guu, igaba méé tu bóòa tcg'òó qãè bóòa tcg'òóan cgoa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gaa domka ne kò c'ẽe ne khóè ne Jerusalema di ne tshoa-tshoa a tẽè a máá: “A gaam khóèm tama baa ncẽe cg'õoa ba ko qaaè ba? ");
INSERT INTO nhr_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bóò tu, ncẽe gam ko kgoarasease kg'ui, igaba ne cúí gúù ga Gam ka kg'ui tama. A tseeguan kaga xu tc'ãà-cookg'ai xu ncẽem khóèm Kreste Me ii sa q'ana hãa? ");
INSERT INTO nhr_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ncẽem khóèm guua hãa qgáìan ta q'ana hãa. Igaba Krestem ko hààm x'aèm ka i gha cúí khóè ga c'úùa hãa guuam hãa qgáì,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kam kò nxãaska Jeso ba tc'amaka kg'ui, ẽem tempelem koe hãa a ko xgaa-xgaa ka a máá: “Tíí tu q'ãa Tea hãa, a tu a thẽé ẽer guua hãa qgáìan q'ana hãa. Tíí kar óágase tama, igabam ẽe tsééa óá Tea hãa ba tseegu di Me e, ncẽe tu gatu c'úùa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Tíí ra q'ãa Mea hãa. Gam koe gar guua hãa, Me tsééa óá Tea hãa khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Qgóó Me kg'oana xu kò hãa. Igaba i kò cúí khóè ga táá gaan di tshàuan tòó cgae Me, Gam dim x'aè ba kò qanega hàà tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Igaba ne kò ẽes xg'aes koe káí ne khóè ne Gam koe dtcòm̀ a ne a máá: “Krestem kò ko hàà ne ba gha hàà ncẽem khóèm kúrúa hãa zi x'áí zi nqáéa hãa zi kúrú? Ka ncẽe ba gáé Gaam Krestem tama baa?,” ta ne ma tẽèku. ");
INSERT INTO nhr_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasai xu kò khóè ne ko ma Gam ka ma kg'ui-kg'uise sa kóḿ, ka xu ko kaia xu peresiti xu hẽé naka Farasai xu hẽéthẽé tempelem di xu kòre-kg'ao xu tsééa úú, síí xu gha qgóó Me ka. ");
INSERT INTO nhr_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Me Jeso ba nxãaska máá: “Gatu cgoar gha qanega xòm̀ x'aè-coa ba hãa, a Ra a gha Gaam ẽe tséé Tea hãam koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Qaa Te tu gha, igaba tu hòò Te tite, a tu a ẽer hãa qgáì koe cuiskaga hàà tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Xu nxãaska Juta xu tẽèku a máá: “Ncẽem khóè ba gha nda koe qõò, xae gha táá hòò Me? Gatá di ne khóè ne tsa̱i-tsa̱isea hãa ne Gerika ne koe ba gha qõò, a síí Gerika ne xgaa-xgaa? ");
INSERT INTO nhr_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Dùú sa ba ko méé ncẽem ko máá: ‘Qaa Te tu gha, igaba tu hòò Te tite,’ a ko máá: ‘Hàna Ra gha hãa qgáì koe tu cuiskaga hàà tite,’ témé ka?” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Còo dim cáḿ kõ̱ès dim kaiam kam kò Jeso ba tc'amaka kg'uia ghùi a máá: “Ncẽè c'ẽem khóèm kò cáḿa hãa ne méém Tíí koe hàà naka kg'áà. ");
INSERT INTO nhr_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Eẽ ko Tíí koe dtcòm̀ ba, ‘Kg'õèan di tshàan di tsgórèa ne gha ncãàa ba koe guu a ntcã̱a,’ ẽe zi ma Nqarim di zi Tcgãya zi ma nxàea khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Eẽm kòo Jeso ba ncẽe gúùan nxàe kam kòo Tc'ẽem ka kg'ui, ẽe ko Gam koe dtcòm̀ ne gha hòò Me ka. Tc'ẽe ba ne ko qanega máàè tama, Jeso ba kò qanega x'áàkaguè tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gam di kg'uian ko kóḿse ka ne kò c'ẽe ne khóè ne máá: “Tseegukagam ncẽem khóè ba Porofiti Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ne kò c'ẽe ne máá: “Kreste Me e,” témé. Igaba ne kò c'ẽe ne tẽè a máá: “Haò! Ntama ba gha ma Kreste ba Galilea koe guu? ");
INSERT INTO nhr_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Nqarim di zi Tcgãya zi gáé máá: ‘Dafitem dis qhàòs koem Kreste ba guua hãa’ témé tama, Betelehema koe, Dafitem kò x'ãèa hãam x'áé ba?” ta xu ma tẽè. ");
INSERT INTO nhr_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Si kò Jesom domka kaias q'aa-q'aase sa khóè ne xg'aeku koe hãa. ");
INSERT INTO nhr_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","C'ẽe nea kò qgóó Me kg'oana hãa. Igaba i kò táá cúí khóè ga gaan di tshàuan tòó cgae Me. ");
INSERT INTO nhr_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ka xu kò tempelem di xu kòre-kg'ao xu ncẽe ko tsééèa hãa xu kaia xu peresiti xu koe hẽé naka Farasai xu koe hẽéthẽé ka̱bise. Xu nxãa xu tẽè xu a máá: “Dùús domka xaoa kò óá Me tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xu kòre-kg'ao xu xo̱a a máá: “Cúí khóè ga Gam khama kg'ui ta ga hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ka xu kò Farasai xu xo̱a xu a máá: “Gaxao igaba ba gáé qàe-qae xaoa hãa? ");
INSERT INTO nhr_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tc'ãà-cookg'ai xu ka c'ẽe baa, kana Farasai xu ka c'ẽem ga ba gáé Gam koe dtcòm̀aa? ");
INSERT INTO nhr_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Igaba ncẽe ne khóè ne, ncẽe x'áè-kg'áḿan c'úùa hãa nea cgúíèa!” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodemasem ncẽe kò Jesom koe kg'aia síía ba, gaxu ka c'ẽe kò ii ba, nxãa ba kò bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Gaxae dim x'áè-kg'áḿ ba koáé kuri khóèan xgàra, dùú sa i ko gaan koe kúrú sa kg'aia kóḿ tamase?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Xu xo̱a me a máá: “Tsáá igaba tsi gáé Galilea di tsia? Tcgãya zi koe qaara tcg'òó naka bóò, porofitian Galilea koe guu tama sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Me kò wèém khóè ba x'áéa ba koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kam ko Jeso ba Olife dim xàbìm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Me kò ntcùúkg'ai cgoa gaicara tempelem koe síí, i kò wèé khóèan ga síí cgae Me, Me ntcõó a xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Xu kò x'áè xgaa-xgaa-kg'ao xu hẽé naka Farasai xu hẽéthẽé khóès hãa a ko cg'áràn kúrú koe qgóóèa sa óá. A xu a hàà khóè ne cookg'ai koe tòó si. ");
INSERT INTO nhr_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","A xu a bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, khóès ncẽe sa cg'árà nes hãa a ko kúrú koe qgóóèa. ");
INSERT INTO nhr_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Igabam kò Moshe x'áèan máà ta a, ncẽeta ii zi khóè zi méé zi nxõ̱án cgoa xg'áḿa cg'õoè di i, ka Tsi ko Tsáá nta méé?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ncẽem kg'ui ba xu kò ko kg'ui, qáé Me xu gha qgáìan xu kò ko qaa khama, a xu a ko chìbi-chibi Me xu gha zi dàò-kg'áḿ zi qaa. Kam ko Jeso ba qám̀se, a tshàua ba cgoa góḿankg'ai koe góá. ");
INSERT INTO nhr_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Qanega xu hãa a ko tẽè Me kam ko tẽe a bìrí xu a máá: “Ncẽè c'ẽem khóèm káà chìbi iim kò gaxao xg'aeku koe hãa, ne méém tc'ãà naka nxõ̱á sa séè naka xao si,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","A ba a gaicara qám̀se a góḿankg'ai koe góá. ");
INSERT INTO nhr_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ncẽe sa xu ko kóḿ ka xu kò kaia xu koe guu a tshoa-tshoa a cúímana-cúí tcg'oara qõò. Me Jesom cúím ga ba síí qaù, naka gaas khóè sa hẽéthẽé e, si qanega gaa koe téé-tẽe. ");
INSERT INTO nhr_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Me Jeso tẽe a ba a tẽè si a máá: “Khóè seè, nda xua? Ncãa i gáé cúí khóè ga táá chìbi bóò si?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Si máá: “Ncãa i táá cúí khóè ga chìbi bóò te, X'aigaè,” témé. Me Jeso ba máá: “Nxãaskar Tíí igaba cúí gúù kaga chìbi bóò si tama, ke qõò, naka sia ncẽe koe guus ka táá gaicara chìbi kúrú guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Me Jeso ba gaicara khóè ne cgoa kg'ui a máá: “Tíí Ra nqõóm dir X'áà Ra a. Dìím wèém ẽe gha xùri Te ba ntcùúan q'oo koe qõòa hãa tite, igabam gha kg'õèan di x'áàn úúa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Xu kò Farasai xu bìrí Me a máá: “Tsáá ka Tsi ko nxàea tseegukagu, khamas Tsáá ko Tsáá ka nxàea tseegukagu sa tchàno tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Me Jeso ba xo̱a xu a máá: “Tíí kar kò nxàea tseegukagu igabagas tiris nxàea tseegukagu sa tchàno si i, ẽer guua hãa qgáìa ner q'ana hãa, a Ra a gataga ẽer ko qõò qgáìan q'ana hãa. Igabaga xao gaxao ẽer guua hãa qgáìan hẽé, naka Ra ko qõò qgáìan hẽéthẽé c'úùa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Gaxaoa ko tc'áró ba xgàra, Tíí Ra cúí khóè ga xgàra tama. ");
INSERT INTO nhr_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Igaba ncẽè xgàrar kò ne i xgàra-q'ooa Te tchàno o, Tíí Ra Tíí ka cúíse xgàra tama khama, igaba Ra Abom ncẽe tsééa óá Tea hãam cgoa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Gaxao di x'áèan koe i góásea hãa a ko máá: ‘Cám̀ khóèan dis nxàea tseegukagu sa cgáé si i,’ téméè. ");
INSERT INTO nhr_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Gaas ẽe Tíí ka tseegu ii sar kò Tíía nxàea tseegukagu. Me ko gataga thẽé Abom ncẽe tsééa óá Tea hãa ba Tíí ka nxàea tseegukagu,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xu nxãaska tẽè Me a máá: “Saò ba nda?” témé. Me Jeso ba xo̱a xu a máá: “C'úù Te xao hãa, a xao a Abom ga ba c'úùa hãa, a ncẽè q'ãa Tea xao kò hãa ne xao ga ko thẽé Abom ga ba q'ana hãa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jeso ba kò ncẽe kg'uian tempelem q'oo koem hãase kg'ui, aban ko tòóèm qgáìm qàe koe. Igaba i kò táá cúí khóè ga qgóó Me, Gam dim x'aè ba kò qanega hàà tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Me kò Jeso ba gaicara bìrí xu a máá: “Qõò Ra ko, xao gha qaa Te, a xao a gha gaxao di zi chìbi zi q'oo koe ga x'óó. Tíí ko qõò koe xao cuiskaga síí tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Xu nxãaska Juta xu tẽèku a máá: “Cg'õose ba gha? Ncẽem ko máá: ‘Tíí ko qõò koe xao cuiskaga síí tite’ témé ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Me bìrí xu a máá: “Gaxaoa nqãaka di xao o, Ra Tíí tc'amaka di Ra a; ncẽem nqõóm di xao o, Ra Tíí ncẽem nqõóm di tama. ");
INSERT INTO nhr_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Gaa domkar kò bìrí xao o, a ko máá: ‘Gaxao di chìbian koe ga xao gha x'óó,’ témé. Ncẽè Tíí Ra gaar ga Ra a tar ko méé sa xao ko dtcòm̀ tama, ne xao gha tseeguan kaga gaxao di chìbian koe x'óó,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xu bìrí Me a máá: “Kháé Tsi Tsáá dìí Tsia?” témé. Me Jeso ba bìrí xu a máá: “Ncẽer kò ma tshoa-tshoas koe guu a bìrí xao o khama cúí ga Ra ko méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Káí zi gúù zi Ra úúa hãa bóòa Ra ga tcg'òó a gaxao ka nxàe zi, igaba Gaam ẽe tsééa óá Tea ba tseegu di Me e, Ra ko ẽer kò Gam koe kóḿ sa nqõó ba bìrí,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Xõòm kam kò ko kg'ui cgoa xu sa xu kò kóḿa q'ãa tama. ");
INSERT INTO nhr_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kam ko nxãaska Jeso ba bìrí xu a máá: “Eẽ xao ko Khóèm dim Cóá ba tc'amaka ghùia xg'ara, ne xao gha nxãwa q'ãa Gaar ga Ra a sa, a Tíí ka cúíse gúù zi kúrú tama, igaba Ra ko Abom ma xgaa-xgaa Tea hãa khama ma kg'ui. ");
INSERT INTO nhr_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Me Gaam ẽe tséé Tea hãa ba Tíí cgoa hãa, a cúíse guu Te ta ga hãa, wèé x'aè kar ko ẽe ko qãè-tcaokagu Me sa kúrú khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ncẽe gúùa nem ko nxàe ka i ko káí khóèan Gam koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Me Jeso ba nxãaska Gam koe ko dtcòm̀a ne Juta ne bìrí a máá: “Tirim kg'ui ba tu kò ko komsana a ko qgóó qari me, ne tu gha tseegukaga Tiri tu xgaa-xgaase-kg'ao tu ii. ");
INSERT INTO nhr_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","A tu a gha nxãaska tseeguan q'ãa, i gha tseeguan kgoara tu u,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ne xo̱a Me a máá: “Abrahamam di ta cóá ta a, a ta a qanega c'ẽe khóè di qãà kúrú ta ga hãa, ka Tsi nta méé-q'ooa, ncẽe Tsi ko máá, kgoarasea ta gha hãa, témé ka?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Me Jeso ba xo̱a ne a máá: “Tseegukar ko tseeguan bìrí tu u, a ko máá: Dìím wèém ẽe ko chìbian kúrú ba chìbian dim qãà me e. ");
INSERT INTO nhr_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Me qãà ba chõò tamase x'áé koe hẽé tama, igabam ko cóá ba chõò tamase x'áé koe hẽé. ");
INSERT INTO nhr_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gaa domkaga tu gha, ẽem ko Cóá ba kgoara tu u, ne tseeguan kaga kgoarasea hãa. ");
INSERT INTO nhr_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abrahamam di tu cóá tu u sar q'ana hãa, igaba tu cg'õo Te kg'oana hãa, Tirim kg'ui ba tcáóa tu q'oo koe x'ãè-q'ooan úú tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","“Tirim Xõòm koer bóòa hãa zi gúù zi kar ko kg'ui, tu ko gatu, gatu ka xõòga xu koe tu kóḿa hãa zi kúrú,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ne xo̱a Me a máá: “Gatá ka xõò ba Abrahama me e,” témé. Me Jeso ba bìrí ne a máá: “Ncẽe Abrahamam di tu cóá tu kò ii ne tu ga ko Abrahamam ko kúrú zi kúrú. ");
INSERT INTO nhr_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Igaba tu ncẽeska cg'õo Te kg'oana, Tíí ncẽe Nqarim koer kóḿa tseeguan kò bìrí tu ur khóè Ra. Abrahama ba kò ẽeta ii gúù kúrú tama. ");
INSERT INTO nhr_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Gatu ka xõò ga xu kòo kúrú zi gúù zi tu ko kúrú,” tam méé. Ne bìrí Me a máá: “Sita cg'áràn di ta cóá ta tama ta a; sita dim Xõòm cúím úúa ta hãa ba Nqari Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Me Jeso ba bìrí ne a máá: “Ncẽè Nqarim kò gatu ka Xõò ba ii, ne tu ga kò ncàm̀ Tea hãa, Nqarim koe Ra guu a hààraa khama. Tiri qarian kar ncẽe koe hàà tama, igabam Gabá tsééa óá Tea hãa. ");
INSERT INTO nhr_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dùús domka tua ẽer ko kg'ui sa kóḿa q'ãa tama? Eẽr ko kg'uis kóḿ ka tu ko tààè domka a. ");
INSERT INTO nhr_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Gatua gatu ka xõòm dxãwam di tu cóá tu u, a tu a gatu ka xõòm ko tc'ẽe zi gúù zi kúrú kg'oana. Tshoa-tshoases kagam kò cg'õo-kg'ao me e, a ba a tseeguan cgoa tchõà úú tama, tseegua nem úú tama khama. Ncẽe tshúù-ntcõan ábà cgoaèa hãa khamam ko ma kg'ui ii ba. Tshúù-ntcõa-kg'ao me e, a tshúù-ntcõan ka xõò me e khama. ");
INSERT INTO nhr_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Igabar ko Tíí tseeguan nxàe, domka tu Tíí koe dtcòm̀ tama. ");
INSERT INTO nhr_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ndaka kg'áía tu ga chìbiga Ra a sa x'áí? Ncẽè tseegua ner kò ko nxàe, ne tu kháé nxãaska dùús domka dtcòm̀ Te tama? ");
INSERT INTO nhr_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Gaam ẽe Nqarim di ba ko Nqarim di kg'uian komsana, igaba tu gatu Nqarim di tama, gaa domkaga tu komsana a tama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Xu Juta xu xo̱a Me a máá: “Tseegu tama xae gáé kò hãa ncẽe xae kòo máá: ‘Samaria di Tsi i, a Tsi a dxãwa tc'ẽean úúa hãa,’ témé ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Me Jeso ba xo̱a a máá: “Dxãwa tc'ẽea ner úú tama, igabaga Ra Abo ba tcoma hãa, xao ko gaxao Tíí ntcoe Te. ");
INSERT INTO nhr_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Tíí Ra Tíí ka dqo̱m̀kuan qaara mááse tama, igabagam qaa a ko ba hàna, ncẽe gha xgàra ba. ");
INSERT INTO nhr_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tseegukar ko tseeguan bìrí tu u, a ko máá: Dìím wèém ẽe gha Tirim kg'ui ba qgóóa qari ba chõò tamase x'óóa hãa tite, témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Xu kò Juta xu nxãaska bìrí Me a máá: “Dxãwa tc'ẽean Tsi úúa hãa sa xae ncẽeska q'ana hãa. Abrahama ba x'óóa, xu porofiti xu thẽé x'óóa hãa, igabaga Tsi ko Tsáá máá, dìím wèém ẽe ko Tsari kg'uian qgóóa qari ba chõò tamase x'óóan xám̀ tite, témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Gaxae ka xõòm Abrahamam ka Tsi Tsáá kaia? X'óóam hãa, xu gataga thẽé porofiti xu x'óóa hãa. Ka Tsi gáé Tsáá tc'ẽea máá, dìí cgáé Tsi ii, ta tc'ẽea?” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Me Jeso ba xo̱a xu a máá: “Ncẽè Tíí kòo dqo̱m̀se, ne i Tiri dqo̱m̀sean káà hùi i. Tíí ko dqo̱m̀ Te ba Abo Me e, ncẽe gaxao ko máá, gatu dim Nqari Me e, témé ba. ");
INSERT INTO nhr_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Igabaga xao c'úù Mea, Ra Tíí q'ãa Mea. Ncẽè c'úù Mea Ra hãa tar kòo méé ner nxãaska tshúù-ntcõa-kg'ao Ra a, gaxao khamaga ma. Igabaga Ra q'ãa Mea, a Ra a ko kg'uia ba qgóóa qari. ");
INSERT INTO nhr_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Gaxao ka xõòm Abrahama ba kò Tirim cáḿ bam ko hàà bóò khama qãè-tcaoa hãa, a kò bóò me a qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Xu nxãaska Juta xu bìrí Me a máá: “Qanega Tsi 50 kuri ga úú tama, igaba Tsi Abrahama ba bóòa hãa dèe?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Me Jeso ba xo̱a xu a máá: “Tseegukar ko tseeguan bìrí xao o, a ko máá: Abrahamam ko ábàès cookg'ai koe, Ra hàna,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ka xu ko nxõ̱án sáà, xao Me xu gha ka, igabam ko Jeso ba tempelem q'oo koe ts'ana tcg'oa a qõò. ");
INSERT INTO nhr_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Eẽm Jeso ba xóé a ko qõò kam kò káà tcgáíse ábàèa hãam khóèm cgoa xg'ae. ");
INSERT INTO nhr_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ka xu kò Gam di xu xgaa-xgaase-kg'ao xu tẽè Me a máá: “Xgaa-xgaa-kg'ao Tseè, dìín chìbi domka ba káà tcgáíse ábàèa? Gaam chìbia kana xõòa ba dia, ncẽe kúrú mem káà tcgáíse ábàèa hãa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Me Jeso ba xo̱a xu a máá: “Ncẽem khóèm chìbi tama a, gataga xõòa ba di chìbi tama a, igabagas ncẽe sa kúrúse cgae mea hãa, nxãasega i gha Nqarim di qarian bóòè a ko gam koe tséé ka. ");
INSERT INTO nhr_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Qanega i koaba di x'aè e, ka méé xae ncẽe tsééa óá Tea hãam di tsééan kúrú, ntcùúa nea ko hàà ke, ncẽe cúí khóè ga tséé tite e. ");
INSERT INTO nhr_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eẽr qanega nqõóm koe hãa x'aè kar nqõóm dir X'áà Ra a,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ncẽe zi gúù zim ko kg'uia xg'ara kam kò góḿankg'ai koe tcg'ae, a kg'áḿ-tsharà ba cgoa tco̱àn kúrú a gaa tco̱àn khóèm tcgáí koe tcgáù, ");
INSERT INTO nhr_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","a ba a gaam khóè ba bìrí a máá: “Qõò, naka tsia síí Siloame dim tèbem koe xg'aà-kg'ai,” témé. (Ncẽem kg'uim Siloame di ba ko máá ‘Tsééa úúèa’ témé.) Me ko qõò a síí xg'aà-kg'ai, a ba a ka̱bisem ko ka ko bóò. ");
INSERT INTO nhr_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","X'áé qàea ba di ne khóè ne hẽé, naka kg'áíga kò ko bóò me, me ko dtcàrà ne hẽéthẽéa kò tẽèse a máá: “Ncẽea gáé gaam khóèm xg'ao ko káíse ntcõóa te a ko dtcàràm tama baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","C'ẽe ne kò máá: “Gaam ga me e,” témé, ne ko c'ẽe ne máá: “Eẽ ẽe, kg'ama tsara tc'ẽèkua hãa,” témé. Me kò gaam khóè ba máá: “Tíí ga ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ne tẽè me a máá: “Kháé i nxãaska tcgáía tsi ntama ma xgobekg'ammèa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Me xo̱a ne a máá: “Jeso ta ko ma tciièm Khóè ba kò tco̱àn kúrú a tcgáía te tcgáù, a bìrí te a máá, síí méér Siloame dim tèbem koe xg'aà-kg'ai, témé, ra síí xg'aà-kg'ai, a gaa koe ga bóò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ne tẽè me a máá: “Gaam khóè ba nda?” témé. Me xo̱a ne a máá: “C'úùa ra hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ka ne ko gaam khóèm ẽe kò káà tcgáíse ábàèa hãa ba séè a Farasai xu koe úú. ");
INSERT INTO nhr_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nxãaskam kò, gaam cáḿ ẽem kò Jeso ba tco̱àn kúrú, a khóè ba xgobekg'am tcgáí ba Sabata di me e. ");
INSERT INTO nhr_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ka xu ko Farasai xu khóè ba tẽè, ntama i ma qõòa hãa me ko bóò sa. Me xo̱a xu a máá: “Tco̱à nem kò tcgáía te koe tcgáù, ra síí xg'aà-kg'ai, a kò gaa koe ga guu a bóò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Xu kò c'ẽe xu Farasai xu máá: “Ncẽem Khóè ba Nqarim koe guu tama, Sabata dim cáḿ bam qgóóa qari tama khama,” témé. Xu c'ẽe xu máá: “Ntama ba ga ma chìbi-kg'ao ba ncẽeta ii zi x'áí zi kúrú?” témé. Xu kò tc'ẽe-kg'áḿ zi koe q'aara hãa. ");
INSERT INTO nhr_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ka xu ko ka̱bise a gaicara ẽe kò káà tcgáí ii ba bìrí a máá: “Xgobekg'am tcgáí tsia baa ka tsi ko tsáá Gam ka nta méé?” témé. Me xo̱a xu a máá: “Porofiti Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Xu kò Juta xu qanega dtcòm̀ tama, káà tcgáí me e kò ii, a ba a kúrúè a ko ncẽeska bóò sa, khama xu khóèan tséé i síí xõò ga khara tcii. ");
INSERT INTO nhr_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","A hàà tẽè khara a, a máá: “Ncẽea gakhao dim cóám ga baa, ncẽe kò koma káà tcgáíse ábàèa hãa ba? Kháé nxãaska i ntama ma qõòa hãa me ko ncẽeska bóò?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Khara xõò ga khara xo̱a xu a máá: “Sikham dim cóá me e sa kham q'ana hãa, a kham a gataga q'ana hãa, káà tcgáísem ábàèa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Igaba kham gakham ntama i ma qõòa hãa me ko ncẽeska bóò sa c'úùa hãa, naka dìín xgobekg'am tcgáí mea hãas ga sa hẽéthẽé e. Ke xao gaxao tẽèa mááse me, kuria ba tc'ãòa hãa, me gha xo̱ara mááse xao o ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Khara kò xõò ga khara ncẽeta ma xo̱a, Juta xu khara kòo bèe khama. Nxãakamaga xu kò kg'uia xg'ara hãa, ncẽè c'ẽem khóèm kò nxàea tseegukagu Jeso ba Kreste Me e sa, ne i gha gaa khóèan còrè-nquum koe xhàiaguè sa khama. ");
INSERT INTO nhr_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gaa domka khara kò ko xõò ga khara máá: “Kuria ba tc'ãòa hãa, ke méé xu tẽè me,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Xu cám̀ dis ka gaam khóèm ẽe kò káà tcgáí ii ba tcii, a xu a bìrí me a máá: “Nqari ba dqo̱m̀ tseeguan kg'ui ka, ncẽem Khóè ba chìbi-kg'ao Me e sa xae q'ana hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Me xo̱a xu a máá: “Chìbi-kg'ao ba ga ii kana ba ga chìbi-kg'ao tama sar tíí c'úùa hãa. Cúís gúùs tíí q'ana hãa saà: káà tcgáí ra a kò ii, igaba ra ko ncẽeska bóò si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xu tẽè me a máá: “Dùú sa ba kò kúrú cgae tsi? Ntama ba kò ma tcgáía tsi xgobekg'am?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Me xo̱a xu a máá: “Ncãar nxãakamaga bìrí xao o, xao ncãa táá kóḿ te, ka xaoa ko dùús domka gaicara kóḿan gaan di qaa? Kana xaoa Gam di xu xgaa-xgaase-kg'ao xu kúrúse kg'oana thẽé?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Xu xhóré me a máá: “Tsáá tsia Gam di tsi xgaa-xgaase-kg'ao tsi i! Sixaea Moshem di xae xgaa-xgaase-kg'ao xae e. ");
INSERT INTO nhr_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nqarim xg'ao Moshem cgoa kg'ui sa xae q'ana hãa, igaba ncẽem Khóèm ka xae ndam guua sa c'úùa hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Me khóè ba xo̱a xu a máá: “Cg'ãèse i are-aresa a, Me guua hãa qgáìan ga xao c'úùa hãa, igabagam xgobekg'am tcgáí tea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nqari ba chìbi-kg'ao ne komsana tama sa ta q'ana hãa: igaba ncẽè c'ẽem khóèm kòo Nqari ba dqo̱m̀, a ko Gam ncàm̀a hãa sa kúrú, nem ko Nqari ba komsana me. ");
INSERT INTO nhr_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Xg'aom kò ntcõó a nqõó ba tshoa-tshoase ne ta qanega kóḿ naka i máá, dìím ga ba khóèm káà tcgáíse ábàèa ba xgobekg'am tcgáía hãa téméè ta ga hãa. ");
INSERT INTO nhr_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ncẽem Khóèm kò Nqarim koe guu tama nem ga kò cúí gúù ga kúrú tama!” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Xu gaa kg'uian ncẽe tc'amkg'ai koe xo̱a me a máá: “Chìbian q'oo koe tsi ábàèa, ka tsi tsáá dùú sa xgaa-xgaa xae e kg'oana?” témé. A xu a tchàa koe xhàiagu me. ");
INSERT INTO nhr_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jeso ba kò gaam khóè ba xu xhàiagua hãa sa kóḿ, ẽem ko hòò me kam kò tẽè me a máá: “Khóèm dim Cóám koe tsia ko dtcòm̀?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Me gaam khóè ba tẽè Me a máá: “Kháé dìí baa, X'aigaè? Bìrí te Me nakar gha nxãasega Gam koe dtcòm̀!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Me Jeso ba máá: “Ncẽe tsi ko bóò, Me ko tsáá cgoa kg'ui ba, Gaam ga Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kam kò khóè ba máá: “Dtcòm̀r ko, X'aigaè,” témé, a cookg'aia ba koe cg'áé a dqo̱m̀ Me. ");
INSERT INTO nhr_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Me Jeso ba máá: “Xgàrar gha domkar ncẽem nqõóm koe hààraa, nxãasega ne gha ẽe káà tcgáí ne bóò, ne ẽe ko bóò ne káàn tcgáí ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Xu c'ẽe xu Farasai xu ẽem kòo ncẽe gúùan nxàe ka kò hãa cgoa mea xu kóḿ, a xu a tẽè Me a máá: “Dùú dèe? Sixae igaba xae thẽé káà tcgáí xaea dèe?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Me Jeso ba bìrí xu a máá: “Káà tcgáí xao kò ii ne xao ga ko ncẽeska chìbi úú tama. Igaba xao tcgáíga xao o sa bìrísea hãa, khama i gha gaxao di chìbian gataga ma hãa cgoa xao o. ");
INSERT INTO nhr_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Tseegukar ko tseeguan bìrí tu u, a ko máá: Khóèm ẽe ghùu zi dis xgàris-kg'áḿ koe tcãà tama a ko nqurì si, kana c'ẽem dàòm ka q'ooa sa koe tcãà ba ts'ãà-kg'ao me e, a cg'ãè kúrú-kg'ao me e. ");
INSERT INTO nhr_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Igaba gaam ẽe ko xgàris-kg'áḿ koe tcãà ba ghùu zi dim kòre-kg'ao me e. ");
INSERT INTO nhr_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Xgàris-kg'áḿ ko xgobekg'am ba ko gaam ghùu kòre-kg'ao ba xgobekg'ama máá, zi ghùu zi kg'ui-q'ooa ba kóḿ, me gam di zi ghùu zi cg'õèa zi ka tcii, a tc'ãà-cookg'ai zi. ");
INSERT INTO nhr_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eẽm kò gam di zi wèéa zi tcg'òóa xg'ara nem ko tc'ãà-cookg'ai zi, zi ghùu zi xùri me, kg'ui-q'ooa ba zi q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Igaba zi cuiskaga tãám khóè ba xùri tite, a gha bèe me a qgóé, tãá khóèan di kg'ui-q'ooan zi c'úùa hãa khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jeso ba kò ncẽes sere-sere sa gaxu koe tséékagu, igaba xu kò ẽem ko bìrí xu sa táá kóḿa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kam ko nxãaska Jeso ba gaicara máá: “Tseegukar ko tseeguan bìrí xao o, a ko máá: Tíí Ra ghùu zi dir Xgàri-kg'áḿ Ra a. ");
INSERT INTO nhr_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wèé xu ẽe kò Tíí ka tc'ãà a hàà xua ts'ãà-kg'ao xu u, a cg'ãè kúrú-kg'ao xu u, igaba zi kò ghùu zi táá komsana xu. ");
INSERT INTO nhr_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Tíí Ra Xgàri-kg'áḿ Ra a. Dìím wèém ẽe ko Tíí koe tcãà ba gha kgoaraè, a ba a gha tcãà a tcg'oa a gha dxòó-q'ooan hòò. ");
INSERT INTO nhr_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ts'ãà-kg'ao ba kg'amaga hàà tama, a ts'ãà sa hẽé naka cg'õo sa hẽé naka ko̱be sa hẽéthẽé cúíga hààraa máána. Ra Tíí hààraa, nxãasega ne gha kg'õèan úú ka, a gataga kaisase úú u ka. ");
INSERT INTO nhr_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Tíí ra qãèr ghùu Kòre-kg'ao Ra a. Me ko qãèm Kòre-kg'ao ba gam di kg'õèan ghùu zi tcg'òóa máá. ");
INSERT INTO nhr_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Gaam ẽe ghùu zi kòre dis tséés koe tcãàèa ba ghùu kòre-kg'aom tama me e, a ba a ghùu zi ka q'õòsem tama me e, ẽem ko ncuutshaan bóò i ko hàà nem ko ghùu zi guu a qgóé, me ncuutshaa ba hàà ntcàu zi a tsa̱i-tsa̱ia q'aa zi khama. ");
INSERT INTO nhr_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ghùu zi kòre di tsééan máàèam khóè ba ko guu zi a qgóé. Kg'amagam máàèa hãa tséé e, khamam tchõà úú cgoa zi tama. ");
INSERT INTO nhr_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Tíí ra qãèr Kòre-kg'ao Ra a, a Ra a Tiri zi ghùu zi q'ana, zi Tiri zi ghùu zi q'ãa Tea, ");
INSERT INTO nhr_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ncẽem ma Abo ba ma q'ãa Tea, Ra gataga Tíí ma q'ãa Mea khamaga ma. Ra ko Tiri kg'õèan ghùu zi tcg'òóa máá. ");
INSERT INTO nhr_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","C'ẽe zi ghùu zir úúa hãa, ncẽem xgàrim-q'oo di tama zi. Gataga méér óága zi thẽés gúù si i, naka zi hàà kg'ui-q'ooa Te kóḿ naka zia ncẽe zi ghùu zi cgoa xg'ae naka cúí zi ghùu zi dis xg'ae sa kúrú, cúím kòre-kg'aom di zi. ");
INSERT INTO nhr_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ncẽes gúùs kam Abo ba ncàm̀ Tea, Tiri kg'õèa ner ghùu zi tcg'òóa máána hãa khama, nxãasegar gha gaicara séèa ka̱bi i ka. ");
INSERT INTO nhr_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Khóèm Tíí koe gha kg'õèa Te séèa ka̱bi ba káà me e, igaba Ra ko Tíí ka tcg'òó o. Qari ner úúa hãa tcg'òó or gha di i, a Ra a qarian úúa hãa gaicara Ra gha séèa ka̱bi i di i. Ncẽem x'áè-kg'áḿ bar Abom koe hòòa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Eẽ xu ko Juta xu ncẽe kg'uian kóḿ ka xu kò tc'ẽe-kg'áḿ zi koe gaicara q'aa. ");
INSERT INTO nhr_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Káí-kg'áía ne kò máá: “Dxãwa tc'ẽea nem úúa, a temea, ka ba ko dùús domka kóḿmè?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Igaba ne kò c'ẽe ne máá: “Ncẽe zi gúù zi ga táá dxãwa tc'ẽean ka tcãàèam khóèm ka mééè. Dxãwa ba káà tcgáím khóè bam ga xgobekg'am tcgáí di qarian úúa hãa ii?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Me x'aè ba tcãà, si tempelem ko ka̱ba-ka̱baè dis kõ̱è sa xóé Jerusalema dim x'áém koe. Sao di x'aè e kò ii. ");
INSERT INTO nhr_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Me kò Jeso ba tempelem koe hãa a ko caate, Solomonem dis xàò-xao sa ta ko ma tciiès xào-xaos koe. ");
INSERT INTO nhr_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ka ne ko Juta ne Gam koe hààraa xg'ae, a nxa̱ma-nxa̱ma Me a máá: “Nta noo x'aèan Tsi ko hàà séè a ghùia tòó ta a? Ncẽè Kreste Tsi kò ii ncẽem Nqari ba nqòòkagu taa hãa Tsi ne kg'ama kgoarasease bìrí ta a,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Me Jeso ba xo̱a ne a máá: “Bìrí tu ur kò, igabaga tu kò táá dtcòm̀. Tséé zi ncẽer ko Abom cg'õè cgoa kúrú zia ko Tíí ka nxàea tseegukagu, ");
INSERT INTO nhr_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","igaba tu dtcòm̀ tama, Tiri tu ghùu tu tama tu u khama. ");
INSERT INTO nhr_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tiri zi ghùu zia ko kg'ui-q'ooa Te kóḿ, Ra q'ãa zia, zi ko xùri Te. ");
INSERT INTO nhr_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Chõò tama kg'õèa ner ko máà zi, zi chõò tamase kaà tite, i cúí khóè ga tshàu q'ooa Te koe séèa tcg'òó zi tite. ");
INSERT INTO nhr_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Abom ncẽe máà Te zia hãa ba wèé gúùan kaga kaia, i cúí khóè ga Abom tshàu q'oo koe séèa tcg'òó zia hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Tíí hẽé naka Abo ba hẽéthẽé Tsama cúí Tsam m,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ka ne ko Juta ne gaicara nxõ̱á zi sáà, xao Me ne gha ka, ");
INSERT INTO nhr_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","igabam kò Jeso ba xo̱a ne a máá: “Káí zi tséé zi qãè zi Ra x'áí tua, Abom koe guua hãa zi. Ka tua ko gazi xg'aeku koe ndakas domka nxõ̱án cgoa xao Te?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ne Juta ne xo̱a Me a máá: “C'ẽes tséés qãès domka ta xao Tsi tama, igaba Tsi ko Nqari ba cóè domka a, kg'ama Tsi khóè Tsi i, igaba Tsi ko Nqari Tsi ii khama ma séèse domka a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Me Jeso ba xo̱a ne a máá: “Gatu di X'áèan koe i gáé ncẽeta ma góásea naka máá: ‘Gatu kar ko máá: nqárì tu u,’ témé tama? ");
INSERT INTO nhr_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Eẽ Nqarim di zi Tcgãya zi koe ko méése sa chõò tamase tseegu si i sa ta q'ana hãa. Me kò Nqari ba gane ẽe Gam dim kg'ui ba kò máàèa hãa ne nqárì ta ma tcii. Ncẽè Nqarim kò ko gaa ne khóè ne ẽe ne nqárì ta ma tcii, ");
INSERT INTO nhr_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ne tua nxãaska gatu dìí tua ncẽe ko máá, Nqari bar ko cóè témé tu, Nqarim dir Cóá Ra a tar ko méé domka, Tíí ncẽe Abom nxárá tcg'òó, a nqõómkg'ai koe tsééa óá Ra! ");
INSERT INTO nhr_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ncẽè Abom di zi tséé zir kò kúrú tama ne méé tu nxãaska táá Tíí koe dtcòm̀ guu. ");
INSERT INTO nhr_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Igaba ncẽè kúrú zir kòo, igaba tu kò Tíí koe dtcòm̀ tama ne méé tu nxãaska ẽer ko kúrú zi tséé zi koe dtcòm̀, naka tua gha nxãasega q'ãa naka kóḿa q'ãa, Abom Tíí koe hãa, Ra Tíía Gam koe hãa sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ne gaicara qgóó Me ne gha sa tc'ẽe, Me tcg'oaragu ne. ");
INSERT INTO nhr_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Me nxãaska Jeso ba Jorotanem ka ncìí za ka xòèa ba koe ka̱bise, Johanem kò ko kg'aika khóè ne tcguù-tcguum qgáìm koe, a ba a síí gaa koe hãa. ");
INSERT INTO nhr_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ne káí ne khóè ne Gam koe síí a ne a máá: “Johane ba xg'ao táá c'ẽes x'áís ga sa kúrú, igabam xg'ao ncẽem Khóèm ka bìrí ta a zi gúù zi wèé zia tseegu zi i,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ne kò ẽem qgáìm koe káí ne khóè ne Jesom koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nxãaskam kò c'ẽem khóèm Lasaro ta ko ma tciiè ba ko tsàa, Betania koe guua ba, Maria sa hẽé naka gas ka káíkhoes Mareta sa hẽéthẽé sara dim x'áé-coa ba. ");
INSERT INTO nhr_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ncẽes Maria sa gaas ncẽe kò X'aigam Nqari ba tshãá di nxúìan cgoa tcgáù nqàrèa hãas ga si i, a c'õòa sa cgoa tchùu u, ncẽe káímkhoem Lasarom kòo tsàa sa. ");
INSERT INTO nhr_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ka sara kò nxãaska khóè qõeku sara Jesom koe kg'uian tsééa úú, a máá: “X'aigaè, ẽe Tsi ncàm̀a hãa ba ko tsàa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eẽm ko ncẽe sa kóḿ, kam kò Jeso ba máá: “Ncẽes tcìì sa cuiskaga cg'õo mea hãa tite, igabas Nqari ba dqo̱m̀ di si i, nxãasegam gha Nqarim dim Cóá ba dqo̱m̀mè ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Me kò Jeso ba Mareta sa hẽé naka qõese sa hẽé naka Lasaro ba hẽéthẽé ncàm̀a. ");
INSERT INTO nhr_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Khama ẽem ko Lasaro ba ko tsàa sa kóḿ, kam kò cám̀ cáḿ tsara hãa ẽem ko hãam qgáìm koe. ");
INSERT INTO nhr_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","A ba a nxãaska Gam di xu xgaa-xgaase-kg'ao xu bìrí a máá: “Hàà naka xae Jutea koe gaicara ka̱bise,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xu xgaa-xgaase-kg'ao xu bìrí Me a máá: “Xgaa-xgaa-kg'ao Tseè, Juta ne ncãaga nxõ̱án cgoa xao Tsi kg'oana, igaba Tsia ko gaicara gaa koe ga ka̱bise?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Me Jeso ba xo̱a a máá: “Cáḿ ba gáé 12 aoaran úú tama? Koaba ka ko qõòm khóè ba cuiskaga cg'áéa hãa tite, ncẽem nqõóm di x'áà nem ko bóò khama. ");
INSERT INTO nhr_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Igaba ncẽè khóèm kò ko ntcùúan q'oo koe qõò nem ko cg'áé, x'áà nem úú tama khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ncẽetam ko mééa xg'ara kam kò bìrí xu a máá: “Gaxae ka c'ẽem Lasaro ba x'óm̀a hãa, Ra ko gaa koe síí tc'oman koe ghùi me,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xu xgaa-xgaase-kg'ao xu bìrí Me a máá: “X'aigaè, x'óm̀am kò hãa nem gha qãè,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Me kò Jeso ba x'óóam hãa sa nxàe, igaba xu kò Gam di xu xgaa-xgaase-kg'ao xu tc'ẽea máá, tc'oman ncẽe tseegu di Gam ko nxàe, ta tc'ẽea. ");
INSERT INTO nhr_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kam kò nxãaska Jeso ba tchànose bìrí xu a máá: “Lasaro ba x'óóa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ra gaxao domka qãè-tcaoa, káà ra a kò ii khama, nxãasega xao gha dtcòm̀ ka. Igaba hàà naka xae síí cgae me,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Kam kò Tomase ncẽe kò Didimo ta ma tciiè ba; ncẽes cg'õè sa ko máá: ‘Hoo-hore’ témé ba gam ka c'ẽe xu xgaa-xgaase-kg'ao xu bìrí a máá: “Hààn xae thẽé qõò, naka xae nxãasega síí x'óó cgoa Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Eẽm ko Jeso ba hàà kam ko hàà sao-xg'ae, me Lasaro ba nxãakamaga 4 cáḿan tc'ám̀s q'oo koe úúa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","(Nxãaska i kò Jerusalema koe guu a Betania koe síían 3 kilomitara khama noo. ");
INSERT INTO nhr_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ne kò káí ne Juta ne hààraa, hàà ne gha Mareta sa hẽé naka Maria sa hẽéthẽé sara qgài-qgai tcáó ka, gasara ka káíkhoem di x'ooan koe.) ");
INSERT INTO nhr_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eẽs ko Mareta sa Jesom ko hàà sa kóḿ kas kò tcg'oa a síí xg'ae cgoa Me, si kò Maria sa nquum q'oo koe hãa. ");
INSERT INTO nhr_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Si kò Mareta sa Jeso ba bìrí a máá: “X'aigaè, thuu Tsi kò ncẽe koe hãa nem ga kò tíí kíí ba x'óóa hãa tama. ");
INSERT INTO nhr_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ra ncẽeskaga igaba q'anaa, wèés gúùs ẽe Tsi ko Nqarim koe dtcàrà sam gha Nqari ba máà Tsi sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Me Jeso ba bìrí si a máá: “Sáá kíí ba gha x'ooan koe tẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Si Mareta sa xo̱a Me a máá: “Q'ana ra hãa me gha x'ooan koe tẽe, còo dim cáḿ x'ooan koe i ko tẽeèm ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Me Jeso ba bìrí si a máá: “Tíí Ra x'ooan koe Tẽe Ra a, a Ra a Kg'õè Ra a. Gaam ẽe ko x'óó igaba ko Tíí koe dtcòm̀ ba gha kg'õè, ");
INSERT INTO nhr_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","me dìím wèém ẽe kg'õèa hãa a ko Tíí koe dtcòm̀ ba cuiskaga x'óó tite. Ncẽe sa sia ko dtcòm̀?” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Si bìrí Me a máá: “Eè, X'aigaè, dtcòm̀ ra ko Kreste Tsi i sa, Nqarim di Tsi Cóá Tsi, ncẽe kòo nqõómkg'ai koe hàà Tsi,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ncẽe zi gúù zis ko nxàea xg'ara kas kò qõò a síí qõeses Maria sa dxùukg'ai koe tciia tcg'òó a bìrí si a máá: “Xgaa-xgaa-kg'ao ba ncãa hàà, a ko tcii si,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Eẽs ko ncẽe sa kóḿ kas kò qháése tẽe a síí cgae Me. ");
INSERT INTO nhr_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Nxãaskam kò Jeso ba qanega x'áé-coam koe tcãà ta ga hãa, igabam kò Maretas ncãa xg'ae cgoa Me koe ga qanega tẽe. ");
INSERT INTO nhr_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Eẽ kò Marias cgoa nquu q'oo koe hãa a ko qgài-qgai tcáó si ne Juta ne ko bóò, si ma qháése tẽe a tcg'oara hãa sa, ka ne kò còò si, tc'ám̀s koes ko síí hãa a kg'ae, ta ne kò tc'ẽea khama. ");
INSERT INTO nhr_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Eẽs ko Maria sa Jesom hãas qgáìs koe síí, a ko bóò Me kas kò nqàrè-kg'ama ba koe cg'áé a máá: “X'aigaè, thuu Tsi kò ncẽe koe hãa nem ga kò tíí kíí ba x'óóa hãa tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Eẽm ko Jeso ba bóò sis ko kg'ae, naka ẽe kò xùri si a hààraa ne Juta ne hẽéthẽé ko kg'ae, kam kò kaisase xg'aì, i tcáóa ba nxùrù. ");
INSERT INTO nhr_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Me tẽè ne a máá: “Nda koe tu xòó mea?” témé. Ne bìrí Me a máá: “X'aigaè, hàà naka bóò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Me Jeso ba kg'ae. ");
INSERT INTO nhr_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ne kò nxãaska Juta ne máá: “Bóò, nta noosem ncàm̀ mea sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Igaba ne kò c'ẽea ne máá: “Ncẽem khóèm ncẽe thuu káà tcgáím khóè ba xgobekg'am tcgáía hãa ba gáé kò táá ncẽem khóè ba kúrú me x'óóa hãa tite?” ta ma tẽèku. ");
INSERT INTO nhr_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Me kò Jeso ba gaicara kaisase xg'aìa hãase tc'ám̀s koe síí. Xòam q'oo koes kò hãa, si nxõ̱á sa kg'áḿa ba koe tòóèa. ");
INSERT INTO nhr_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Me Jeso ba máá: “Nxõ̱á sa tcg'òó,” témé. Si ẽe kò x'óóa hãam khóèm ka qõeses Mareta sa bìrí Me a máá: “X'aigaè, ncẽem x'aèm kam hm̀m̀sam xg'ãò ba hãa, 4 cáḿa nem úúa a kg'ónòèa hãa khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Kam kò Jeso ba bìrí si a máá: “Bìrí si ta ga Ra gáé hãa, dtcòm̀ si kòo ne si gha Nqarim di x'áàn hòò sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ka ne ko nxõ̱á sa tcg'òó. Me Jeso ba tc'amaka ghùi-kg'ai a máá: “Aboè, qãè-tcaoa Ra ko máá Tsi, kóḿ Tea Tsi hãa domka. ");
INSERT INTO nhr_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Q'ana Ra hãa wèé x'aè ka Tsi ko kóḿ Te sa, igabar ko ncẽe tẽe ne khóè ne domka ncẽe sa nxàe, nxãasega ne gha dtcòm̀, Tsáá Tsia tsééa óá Tea hãa sa ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ncẽetam ko mééa xg'ara kam kò tc'amaka hãam dòm̀ cgoa q'au a máá: “Lasaroè, tchàa koe tcg'oa!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Me x'óóa kò hãam khóè ba tcg'oa, tshàua ba hẽé naka nqàrèa ba hẽéthẽéa kò lapian cgoa tcáḿmèa, i kg'áía ba c'ẽem qgáím cgoa tcáḿmèa. Me Jeso ba bìrí ne a máá: “Kgoara tcg'òó cgae me qgáía ne nakam qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nxãaska ne kò káí ne Juta ne ncẽe kò Maria sa dàra hãa ne, a kò Jesom kò kúrúa hãa zi gúù zi bóòa ne, Gam koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Igaba ne kò c'ẽe ne Farasai xu koe síí a bìrí xu Jesom dùú sa kúrúa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ka xu kò nxãaska kaia xu peresiti xu hẽé naka Farasai xu hẽéthẽé xg'ae sa tcii a tẽèku a máá: “Dùú sa xae gha kúrú? Ncẽem Khóè ba ko káí zi x'áí zi kúrú ka. ");
INSERT INTO nhr_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Guu Me xae kò Me ko ncẽe zi gúù zi qanega kúrú, ne i gha wèé khóèan Gam koe dtcòm̀, ne gha Roma ne nxãaska hàà sixae dim nqõó ba hẽé naka khóè ne hẽéthẽé xhùu cgae xae e,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Igaba gaxu ka c'ẽem Kaifase ta ko ma tciiè ba, ncẽe kò ẽem kurim ka kaiam peresiti ii ba kò kg'ui a máá: “Cúí gúù ga xao c'úùa hãa! ");
INSERT INTO nhr_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Bóòa xao gáé q'ãa tama, cúím khóè ba guu me wèé ne khóè ne x'óóa máá sa qãè si i, wèés qhàò sa guu si kaàkaguèan ka sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ncẽe sam kò gam koe guuase nxàe tama, igabam kò ẽem kurim ka kaiam peresiti me e khama porofita, Jeso ba gha ko Juta dis qhàò sa x'óóa máá sa, ");
INSERT INTO nhr_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","naka ẽes qhàòs cúís tama sa, igaba gataga Nqarim di ne cóá ne ncẽe tsa̱i-tsa̱isea xõe ne hẽéthẽé e, xg'ae-xg'ae nem gha, ne cúís gúù sa ii ka. ");
INSERT INTO nhr_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Xu kò nxãaska ẽem cáḿ koe ga guu a qg'áìku, cg'õo Me xu gha ka. ");
INSERT INTO nhr_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Me kò Jeso ba nxãaska táá kgoarasease Juta ne xg'aeku koe caate. Igabam kò gaa koe tcg'oa a tchàa-xgóós qàe koe hãam qgáìm koe qõò, Eferaime ta ko ma tciiè ba, a síí gaa koe Gam di xu xgaa-xgaase-kg'ao xu cgoa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juta ne dis Pasekas dim x'aè ba kò cúù me e, ne kò Pasekas cookg'ai koe káí ne nqõóm koe guu a Jerusalema koe qõò, síí ne gha q'ano-q'anoè ka. ");
INSERT INTO nhr_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ne kò Jeso ba qaa, a ne a ko ẽe ne tempelem q'oo koe hãa ka tẽèku, a ko máá: “Dùú sa tu ko tc'ẽe? Cuiskaga ba gáé kõ̱ès koe hàà tite?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Igaba xu kò kaia xu peresiti xu hẽé naka Farasai xu hẽéthẽé x'áèan tcg'òóa hãa, ncẽè c'ẽem khóèm kò ndam hãa sa q'ana hãa ne méém q'ãa-q'ãa xu sa, nxãasega xu gha qgóó Me ka. ");
INSERT INTO nhr_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","6 cáḿan Paseka dim cáḿ cookg'ai di kam kò Jeso ba Betania koe qõò, Lasarom kò x'ãèa hãa koe, ncẽem kò x'ooan koe ghùia hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Me kò Jeso ba gaa koe dqòa di tc'õoan máàè. Si kò Mareta sa nxa̱à máá xu, me kò Lasaro ba ẽe ko Jesom cgoa tc'õó xu ka c'ẽe me e. ");
INSERT INTO nhr_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Kas kò nxãaska Maria sa nareta cgoa cúí kúrúèa tshãán dim ts'óó-c'õám kaia ba séè, ncẽe kaisa marian cgoa ko x'ámáèm tshãá ba, a Jesom nqàrè koe ntcã̱á, a sa a c'õòa sa cgoa tchùu nqàrè Me. Me kò nquu ba ẽem tshãám di xg'ãóan ka cg'oè. ");
INSERT INTO nhr_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Igabagam kò Gam di xu xgaa-xgaase-kg'ao xu ka c'ẽem Jutase Isekariote ba, (ncẽe gha hàà khóè ne tshàu q'oo koe tcãà Me ba) máá: ");
INSERT INTO nhr_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Dùús domka ba kò ncẽem tshãá ba x'ámáguè tama, kurim di marian cgoa, naka i maria ba dxàua ne khóè ne máàè?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ncẽes gúù sam kò dxàua ne khóè nem ncàm̀a hãa domka nxàe tama, igaba ts'ãà-kg'ao me e domka a. A kò mari dtcòbè sam qgóóa hãa khama, q'oo koe marian séèa mááse kg'oana. ");
INSERT INTO nhr_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Me Jeso ba xo̱a a máá: “Guu si tu, Tiri kg'ónò cáḿa nes tòóa máá mea ke. ");
INSERT INTO nhr_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Dxàua ne khóè ne cgoa tu wèé x'aè ka hãa, igaba tu wèé x'aè ka Tíí cgoa hãa tite,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eẽs ko kaias xg'aes Juta ne di sa Jeso ba hàna sa kóḿ, ka ne kò gaa koe síí, Jesom domka cúí tamase, igaba ne gha kúúa hàà Lasaro ba bóò ka hẽéthẽé e, ncẽem kò x'ooan koe ghùia hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Nxãaska xu kò kaia xu peresiti xu qg'áìku, Lasarom ga ba xu gha thẽé cg'õo sa. ");
INSERT INTO nhr_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Gaam domka ne kò ko káí ne Juta ne Jesom koe síí, a ne a ko Gam koe dtcòm̀ khama. ");
INSERT INTO nhr_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Q'uu dim cáḿ ka ne kò káí ne khóè ne ẽe kò kõ̱ès koe hààraa ne kóḿ, Jeso ba ko Jerusalema koe hàà sa. ");
INSERT INTO nhr_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ka ne kò mokolane dis hìis di to̱àràn séè a tcg'oa, a síí xg'ae cgoa Me, a ne a q'au a máá: “Hosana! Ts'ee-ts'eekg'aièa baa, Gam ẽe ko X'aigam Nqarim di cg'õèan cgoa hàà ba, ncẽe Iseraele dim X'aiga ba!” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Me kò Jeso ba donghi-coa ba hòò a ba a qábì me, ncẽe i ko ma góá tòóèa khamaga ma a ko máá: ");
INSERT INTO nhr_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Táá q'áò guu, Sione di si cóá seè; bóò, sarim X'aiga ba ko hàà, donghi-coam koe qábìa ntcõó a ke,” téméè khama. ");
INSERT INTO nhr_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Xu kò Gam di xu xgaa-xgaase-kg'ao xu tc'ãà dis ka ncẽe zi gúù zi kóḿa q'ãa tama. Igaba ẽem ko Jeso ba x'áàkaguè ka cúíga xu kò bóòa q'ãa, ncẽe zi gúù zi Nqarim dis Tcgãyas koe góáèa hãa zi ko Gam ka kg'ui, a zi a Gam koe kúrúèa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Eẽm ko Lasaro ba tc'ám̀s koe tciia tcg'òó, a ko x'ooan koe ghùi me ka kò hãa cgoa Meas xg'ae sa kò Gam ka nxàea tseegukagu. ");
INSERT INTO nhr_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ncẽes x'áí sam kúrúa hãa sa ne kò kóḿ, domka ne kò káí ne khóè ne síí xg'ae cgoa Me. ");
INSERT INTO nhr_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ka xu kò Farasai xu nxãaska bìríku a máá: “Bóò tama xao gáé hãa, cúí gúù kúrú xae gha ga káà a sa? Bóò, wèém nqõó ba ko xùri Me!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nxãaska xu kò ẽe kò qõò a síí ko Jerusalema dis kõ̱ès koe còrè ne xg'aeku koe c'ẽe xu Gerika xu hàna. ");
INSERT INTO nhr_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ka xu kò Filipim koe hàà, ncẽe ko Betesaida dim x'áém Galilea dim koe guua ba, a dtcàrà me a máá: “Aboè, Jeso ba xae bóò kg'oana,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Me kò Filipi ba síí Anterea ba bìrí, tsara kò Anterea ba hẽé naka Filipi ba hẽéthẽé tsara síí Jeso ba bìrí. ");
INSERT INTO nhr_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Me Jeso ba xo̱a tsara a, a máá: “X'aè ba hààraa, Khóèm dim Cóám gha x'áàkaguè ba. ");
INSERT INTO nhr_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tseegua ner ko bìrí xao o, a ko máá: Mabere cgùrim kòo góḿankg'ai koe tcheè, a x'óó tama, nem cúím cgùri me e. Igaba ẽem kòo x'óó nem ko káí cgùrian kúrú. ");
INSERT INTO nhr_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Khóèm ẽe gam dis kg'õè sa ncàm̀a hãa bas gha aaguse cgae, igaba khóèm ẽe gam dis kg'õè sa ncẽem nqõóm koe hòrea hãa ba gha chõò tamase hòò si. ");
INSERT INTO nhr_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Dìím wèém ẽe ko tsééa máá Te ba méém xùri Te, ẽer hàna koem gha Tirim tséé-kg'ao ba thẽé hãa, Me gha Abo ba ẽe ko tsééa máá Te ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ncẽeskas tiris tcáó sa tshúù qgáì koe hãa, ka Ra gha nta méé? ‘Aboè, ncẽem x'aèm koe kgoara Te,’ ta ra gha méé? Eẽ-ẽe, ncẽes gúùs domka ga Ra ncẽem x'aèm koe hààraa. ");
INSERT INTO nhr_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Aboè, cg'õèa Tsi x'áàkagu!” tam méé. Kam kò dòm̀ ba nqarikg'ai koe guu a máá: “Ncãar x'áàkagu u, a Ra a gha gaia x'áàkagu u,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Gaa koe hànas xg'aes ko kóḿ kas kò máá, túúm ts'oo-q'oo o, témé. Ne ko c'ẽe ne máá: “Moengele ba ncãa kò kg'ui cgoa Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Me Jeso ba xo̱a ne a máá: “Ncẽem dòm̀ ba gatu domka hààraa, Tíí domka tamase. ");
INSERT INTO nhr_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ncẽe ba ncẽeska ncẽem nqõóm gha xgàraè dim x'aè me e, me gha ncẽeska x'aiga-coam ncẽem nqõóm di ba xhàiaguè. ");
INSERT INTO nhr_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ra gha Tíí, nqõómkg'ai koer kòo ghùiè ne wèé khóèan Tíí koe tcéèa óá,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ncẽe sam kò ko nxàe, hààm ko x'óós x'oo-kg'áḿ sam gha x'áí ka. ");
INSERT INTO nhr_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Si xg'ae sa xo̱a Me a máá: “X'áèan koe ta kóḿa hãa i ko máá, Kreste ba gha chõò tamase hãa, téméè, ka Tsi gáé ko Tsáá nta hẽés ka máá: ‘Khóèm dim Cóá ba gha ghùiè,’ témé? Khóèm dim Cóám ncẽe ba dìí baa?” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Kam kò Jeso ba bìrí ne a máá: “X'áà ne gha cg'áré x'aè-coan gatu xg'aeku koe hãa. Ke tu qõòa te, qanega tu x'áàn úúa hãa x'aè ka, naka i gha nxãasega táá ntcùúan tcãà cgae tu u. Khóèm ẽe ko ntcùúan q'oo koe qõò ba c'úùa hãa nda koem ko qõò sa ke. ");
INSERT INTO nhr_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Eẽ tu qanega x'áàn úúa hãa x'aè ka méé tu gatu di tcoman x'áàn koe tòó, naka tua gha nxãasega x'áàn di tu cóá tu ii,” tam méé. Eẽm ko Jeso ba kg'ui cgoa nea xg'ara kam kò tcg'oa a qõò a síí xàì-kg'ai ne. ");
INSERT INTO nhr_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jeso ba kò káí zi x'áí zi tcgáí-q'ooa ne koe kúrú, igaba ne kò qanega Gam koe dtcòm̀ tama. ");
INSERT INTO nhr_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Si kò ncẽe sa kúrúse, nxãasega i gha porofitim Isaiam di kg'uian nxàea tseegukaguè ka, ncẽe ko máá: “X'aigaè, dìí na gatá di kg'uian ncẽe ta nxàea hãa koe dtcòm̀aa? Me gataga X'aigam dim x'õà ba dìín x'áíèa hãa?” témé e. ");
INSERT INTO nhr_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ncẽes gúùs domkaga ne kò dtcòm̀an ka tààè. Isaia ba kò gaicara máá: ");
INSERT INTO nhr_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Gane di tcgáía nem kaàkagua hãa, a tcáóa ne x'óó-x'ooa hãa, nxãasega ne gha táá gane di tcgáían cgoa bóò ka, a ne a gane di tcáóan cgoa táá kóḿa q'ãa ka, a ne a Tíí koe táá ka̱bise, Ra Tíí qãèkagu ne ka,” tam Nqari ba mééa khama. ");
INSERT INTO nhr_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaia ba kò ncẽe zi gúù zi kg'ui, Jesom di x'áà nem kò hòòa hãa, a ko Gam ka kg'ui khama. ");
INSERT INTO nhr_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gatà i ii igaba xu kò káí xu tc'ãà-cookg'ai xu Gam koe dtcòm̀. Igaba xu kò Farasai xu domka gaxu di dtcòm̀an táá x'áí, nxãasega xu gha táá còrè-nquum koe xhàiaguè ka. ");
INSERT INTO nhr_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Khóè ne di dqo̱m̀kuan xu kaisase ncàm̀a hãa Nqarim dian ka khama. ");
INSERT INTO nhr_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kam kò Jeso ba q'aua kg'ui a máá: “Khóèm kò ko Tíí koe dtcòm̀ nem Tíí koe cúí dtcòm̀ tama, igabam ko thẽé ẽe tsééa óá Team koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Eẽm kòo bóò Te, nem ko Gaam ẽe tséé Tea hãa ba bóò. ");
INSERT INTO nhr_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nqõóm koer X'áà iise hààraa, nxãasega i gha táá cúí khóè ẽe ko Tíí koe dtcòm̀ ga ntcùú q'oo koe hãa ka. ");
INSERT INTO nhr_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ncẽè khóèm kòo Tiri kg'uian kóḿ, igabam kò qgóóa qari i tama, ne Ra Tíí xgàra tama. Nqõó ba hàà xgàra di ser hàà tama, igaba Ra nqõó bar gha hàà kgoara ka hààraa khama. ");
INSERT INTO nhr_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Gam ẽe ko xguì Te, a kg'uia Te kóḿ tama ba xgàra me ko ba úúa: ẽer kg'uia hãa kg'uia ne gha còo dim cáḿ ka xgàra me. ");
INSERT INTO nhr_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tíí ka Ra kg'uia mááse tama, igabam Abom ncẽe tséé Tea hãa ba x'áè Tea, dùú sar gha kg'ui a nxàe sa. ");
INSERT INTO nhr_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ra q'ana hãa Gam di x'áè-kg'áḿa nea chõò tamas kg'õè si i sa. Gaa domkas wèés gúùs ẽer ko nxàe sa, Ra ko ẽem ma Abo ba ma bìrí Te sia hãa khama ko ma nxàe si,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Paseka dis kõ̱ès cookg'ai i kò ii. Me kò Jeso ba q'ana hãa, x'aè ba hààraa, ncẽem nqõó bam gha tcg'oaragu a Abom koe qõò di ba sa. Gam di ne khóè ne nqõóm koe hãa nem kò ncàm̀a hãa, khamam kò cg'oèasem ncàm̀ nea sa x'áí ne. ");
INSERT INTO nhr_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Dqòa di tc'õoa ne kò kúrúè, me dxãwa ba nxãakamaga Jutasem Isekariotem tcáó koe tcana, Simonem ka cóáse ba, Jeso bam gha khóèan tshàu q'oo koe tcãà ka. ");
INSERT INTO nhr_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jeso ba kò q'ana, Abo ba wèé zi gúù zi Gam di qarian koe tòóa hãa sa, Me Nqarim koe guua hãa, a ba a ko Nqarim koe ga ka̱bise sa. ");
INSERT INTO nhr_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kam kò nxãaska tc'õoan ko tc'õóè qgáì koe tẽe, a ba a tc'amakam ha̱na qgáían nxõ̱o, a tchùuse cgoa dim qgáí ba tcáḿ kháó. ");
INSERT INTO nhr_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A gaa koe guus ka, xg'aàse cgoa dis gàbas koe tshàan ntcã̱a, a Gam di xu xgaa-xgaase-kg'ao xu tshoa-tshoa a xg'aà nqàrè, a tcáḿ kháóam kò hãam qgáím tchùuse cgoa dim cgoa tchùu nqàrè xu. ");
INSERT INTO nhr_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A ba a Simonem Peterem koe hàà, me Petere ba bìrí Me a máá: “X'aigaè, hàà Tsia gáé ko Tsáá nqàrèa te xg'aà?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Me Jeso ba xo̱a me a máá: “Ncẽer ko kúrú sa tsi cuiskaga ncẽeskaga bóòa q'ãa tite, igaba tsi gha nxãwa kháóka bóòa q'ãa si,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Kam kò Petere máá: “Cuiskaga Tsi nqàrèa te xg'aàra hãa tite,” témé. Me Jeso ba xo̱a me a máá: “Ncẽè xg'aà nqàrè tsi tamar kò hãa ne tsi Tíí koe hãa tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Me Simone Petere ba máá: “Kháé nxãaska, X'aigaè, nqàrèa te cúí tamase, igaba tshàua te hẽé naka tcúúa te ga hẽéthẽé xg'áàò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Me Jeso ba xo̱a a máá: “Khóèm ẽe ncãa xg'aàse ba ko nqàrèa ba cúíga xg'aàn tc'ẽe, wèé tc'áróa ba ga q'ano o khama. Xao gaxao q'ano xao o, wèéa xaoa q'ano tama igaba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Q'anam kò hãa dìí ba ko hàà khóè ne tshàu q'oo koe tcãà Me sa khama, gaa domkagam kòo máá: “Wèéa xao ga q'ano tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Eẽm ko nqàrèa xu xg'aà cgoa xg'ara kam kò Gam di zi qgáí zi hã̱a a ntcõó-q'ooa ba koe ka̱bise, a ba a tẽè xu a máá: “A bóòa xao ko q'ãa, ncẽer ncãa kúrú cgae xao o sa? ");
INSERT INTO nhr_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","‘Xgaa-xgaa-kg'ao Tseè,’ ta xao ko ma tcii Te, a ko máá: ‘X'aiga Tseè,’ témé, tseeguse, gaar ga Ra a domka. ");
INSERT INTO nhr_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ra Tíí gaxao dir X'aiga, a Xgaa-xgaa-kg'ao Ra ncãa nqàrèa xao xg'aà, ke méé xao gaxao igaba thẽé gaxao ka c'ẽea xu di nqàrèan xg'aà. ");
INSERT INTO nhr_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Sere-sere sar kúrúa máá xaoa, ke méé xao gaxao igaba ẽer ma kúrúa hãa khamaga ma thẽé kúrú. ");
INSERT INTO nhr_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tseegua ner ko bìrí xao o, a ko máá: Gam ka q'õòsem ka kaia hãam qãà ba káà me e, me gataga ẽe tsééèa hãa ba ẽe tséé meam ka kai tama. ");
INSERT INTO nhr_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ncẽeska xao ncẽe zi gúù zi q'ana hãa, khama xao gha kúrú zi xao kòo ne ts'ee-ts'eekg'aiè. ");
INSERT INTO nhr_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Wèéa xao gar nxàe tama, ẽer nxárá tcg'òóa hãa xur q'ana hãa. Igabas ko ncẽe sa Nqarim dis Tcgãyas koe góásea hãa sa nxàea tseegukagu, ncẽe ko máá: ‘Gaam ẽe ko tíí cgoa péréan tc'õó ba tirim cg'õo-kg'ao ba kúrúa hãa,’ témé sa. ");
INSERT INTO nhr_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ra ko kúrúse tama ias cookg'ai koe ncẽeska bìrí xao o, nxãasega xao gha ẽe i kòo kúrúse ne, Tíí ga Ra a sa dtcòm̀ ka. ");
INSERT INTO nhr_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tseegu ner ko bìrí xao o, a ko máá: Wèém ẽe ko ẽer tsééa úúa hãa ba qãèse hààkagu ba ko Tíí ga Ra qãèse hààkagu, me ko dìím wèém ẽe ko Tíía qãèse hààkagu Te ba ẽe tsééa óága Tea ba qãèse hààkagu,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ncẽetam ko Jeso ba mééa xg'ara ka i kò tcáóa ba tshúù qgáì koe hãa, Me kò nxàea tseegukagu a máá: “Tseegukar ko bìrí xao o a ko máá: Gaxao ka c'ẽe ba gha khóè ne tshàu q'oo koe tcãà Te, témé,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Gam di xu xgaa-xgaase-kg'ao xu ko téé a bóòku, gaxu ka ndaka bam ko nxàe sa c'úùa hãase. ");
INSERT INTO nhr_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Me kò gaxu ka c'ẽem ncẽe kò Jesom ka kaisase ncàm̀mèa hãam xgaa-xgaase-kg'ao ba Gam koe ghãasea ntcõe. ");
INSERT INTO nhr_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Me kò Simone Petere ba gaam xgaa-xgaase-kg'ao ba tcgáía ba cgoa qãè a bìrí me a máá, ndaka bam ko nxàe sa tẽè Me, témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Me Jesom koe ntcõóa ghãase, a tẽè Me a máá: “X'aigaè, dìí baa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Me Jeso ba xo̱a me a máá: “Gaam ẽer ko ncẽes péré qàmà sa máà me e, ẽer kò gàbas q'oo koe tcguù-tcguu sia xg'ara ne,” témé. Eẽm ko gaas péré qàmà sa tcguù-tcguua xg'ara, kam kò Jutase Isekariote ba máà si, Simonem ka cóáse ba. ");
INSERT INTO nhr_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Eẽm ko Jutase ba péré qàmà sa séè kagam ko satana ba tcãà cgae me. Me Jeso ba bìrí me a máá: “Kúrú kg'oana tsi hãas gúù sa qháése kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Igaba tc'õóè ko qgáì koe i kò cúí khóè ga táá q'ãa, dùús domkam ko Jeso ba ẽeta méé sa. ");
INSERT INTO nhr_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jutase ba kò mari dtcòbè sa úúa hãa khama xu kò c'ẽe xu tc'ẽea máá, Jeso ba ko bìrí me, kõ̱ès koe ko tc'ẽese zi gúù zim gha x'ámá sa, kana c'ẽe gúù-coa nem gha ẽe dxàua hãa ne máà sa, ta tc'ẽea. ");
INSERT INTO nhr_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Eẽm ko Jutase ba péréan séèa xg'ara kam kò kúúga tcg'oa. I kò ntcùú u. ");
INSERT INTO nhr_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Eẽm ko qõò, kam kò Jeso ba máá: “Ncẽeskam ko Khóèm dim Cóá ba x'áàkaguè, Me ko Nqari ba Gam koe x'áàkaguè. ");
INSERT INTO nhr_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ncẽè Nqarim kò ko Gam koe x'áàkaguè, nem gha Nqari ba nxãaska thẽé Cóá ba Gam koe x'áàkagu, a ba a gha cúí q'oro x'áàkagu Me. ");
INSERT INTO nhr_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Cóá xaoè, xòm̀ x'aèa ner gha hãa cgoa xao o. Qaa Te xao gha. Eẽr kò ma Juta ne ma bìría khamaga Ra ko ma ncẽeska bìrí xao o a ko máá: Eẽr ko qõò koe xao cuiskaga síía hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ra ko ka̱bam x'áè-kg'áḿ ba máà xao o, a ko máá: Gaxao ka c'ẽe ne ncàm̀. Ncẽer ma ncàm̀ xaoa hãa khama méé xao ma gaxao ka c'ẽea ne thẽé ncàm̀. ");
INSERT INTO nhr_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ncẽes gúùs ka i gha wèé khóèan q'ãa, Tiri xao xgaa-xgaase-kg'ao xao o sa, gaxao ka c'ẽean xao kò ncàm̀a hãa ne,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Me Simonem Petere ba bìrí Me a máá: “X'aigaè, nda koe Tsi ko qõò?” témé. Me Jeso ba xo̱a me a máá: “Ncẽer ko qõò koe tsi cuiskaga kgoana naka xùri Tea hãa tite, igaba tsi gha kháóka nxãwa xùri Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Me Petere ba Gam ka máá: “X'aigaè, dùús domka ra gáé ga ncẽeskaga xùri Tsi tama? Tsáá domkar gha kg'õèa te tcg'òó,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Me Jeso ba xo̱a me a máá: “Tíí domka tsia gha kg'õèa tsi tcg'òó? Tseegukar ko tseeguan bìrí tsi a ko máá: Ghòrò ba kg'aea hãa tite, tsi gha nqoana q'oro xo̱ase Te,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Táá méé i tcáóa tu nxùrù qgáì koe hãa guu. Nqarim koe hẽé naka Tíí koe hẽéthẽé tcoman úú. ");
INSERT INTO nhr_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Abom dim nquum q'oo koe i káí x'ãè-q'ooan hàna; ncẽè gatà i kò ii tama ner ga kò q'ãa-q'ãa tua hãa, síír ko x'ãè-q'ooan kg'ónòa máá tu u sa. ");
INSERT INTO nhr_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ncẽè qõòr kòo a ko síí x'ãè-q'ooan kg'ónòa máá tu u, ner gha ka̱bise a hàà séèa mááse tu u, nxãasega tu gha gatu igaba thẽé síí Tíí hàna qgáì koe hãa ka. ");
INSERT INTO nhr_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tu gataga qõòr kom qgáìm di dàòan q'ana hãa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Me Tomase ba bìrí Me a máá: “X'aigaè, qõò Tsi kom qgáì ba xae c'úùa, ka xae ga ntama ma gaa qgáì dim dàò ba q'ãa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Me Jeso ba xo̱a me a máá: “Tíí Ra Dàò Ra a, a Tseegu Ra a, a Ra a Kg'õè Ra a. Tíí ka oose ko Abom koe síím khóèm cúím ga ba káà me e. ");
INSERT INTO nhr_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ncẽè q'ãa Tea xao kò hãa ne xao ga kò thẽé Abo ba q'ana hãa. Igaba xao ncẽeska q'ãa Mea, a bóò Mea hãa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Me Filipi bìrí Me a máá: “X'aigaè, Abo ba x'áí xae e, nxãaska xae gha qãè xae e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Me Jeso ba bìrí me a máá: “Ncẽetar ma qáò x'aèan gaxao cgoa hãa igaba Tsi ko c'úù Te, Filipiè? Dìím wèém ẽe bóò Tea hãa ba Abo ba bóòa hãa. Nta tsi gha máá: ‘Abo ba x'áí xae e,’ témé? ");
INSERT INTO nhr_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A dtcòm̀ tama tsia Abom koer hãa, Me Abo ba Tíí koe hãa sa? Kg'uian ncẽer ko gaxao cgoa kg'ui nea Tíí koe guu nakar kg'ui i tama, igaba Abom ncẽe Tíí koe x'ãèa hãa ba ko tsééa ba kúrú. ");
INSERT INTO nhr_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Dtcòm̀ méé xao, Abom koer hãa, Me Gabá Tíí koe hãa sa. Ncẽè gatà i kò ii tama ne méé xao nxãaska dtcòm̀ are-aresa zi tséé zi ẽer ko kúrú zi domka. ");
INSERT INTO nhr_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tseegua ner ko bìrí xao o, a ko máá: Dìím wèém ẽe ko Tíí koe dtcòm̀ ba gha ẽer ko Tíí kúrú sa kúrú, a ba a gha ncẽe tsééan ka kaia hãa tsééan kúrú, Tíí Ra ko Abom koe qõò khama. ");
INSERT INTO nhr_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","A Ra a gha dùús wèés ẽe xao ko Tíí cg'õè koe dtcàrà sa kúrú, nxãasegam gha Abo ba Cóám koe guu a dqo̱m̀mè ka. ");
INSERT INTO nhr_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ncẽè c'ẽes gúù sa xao kòo Tíí cg'õè koe dtcàrà ner gha kúrú si. ");
INSERT INTO nhr_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ncẽè ncàm̀ Tea xao kò hãa ne xao gha x'áè-kg'áḿa Te qgóóa qari. ");
INSERT INTO nhr_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ra gha Abo ba dtcàrà Me gha c'ẽem Hùi-kg'ao ba tsééa úúa máá xao o, gaxao cgoa gha chõò tamase hãa ba. ");
INSERT INTO nhr_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ncẽe ba tseeguan dim Tc'ẽe Me e. Nqõó ba cuiskaga hòò Me tite, bóò Meam hãa tite, a ba a c'úù Mea khama. Igaba xao gaxao q'ãa Mea, gaxao cgoam x'ãèa, a ba a gha gaxao koe hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Cuiskagar khãadoma-coa khama ma guu xaoa hãa tite, a gha ka̱bise a hàà cgae xao o. ");
INSERT INTO nhr_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xòm̀ x'aè q'oo koem nqõó ba gaicara hòò Tea hãa tite, igaba xao gha gaxao hòò Te, kg'õèa Ra hãa domka, xao gha gaxao igabaga kg'õè khama. ");
INSERT INTO nhr_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gaam cáḿ ka xao gha q'ãa, Tíí Ra Abom koe hãa, xao gaxao Tíí koe hãa, Ra Tíí gaxao koe hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Dìím wèém ẽe x'áè-kg'áḿa Te úúa, a qgóóa qari ana ba gaam ncàm̀ Tea hãam ga me e. Gaam ẽe ncàm̀ Tea hãa ba gha Abom ka ncàm̀mè, Ra gha Tíí igaba thẽé ncàm̀ me a gha gaam koe x'áíse,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Me Jutase (ncẽe Isekariote tama ba) bìrí Me a máá: “X'aigaè, dùús domka Tsia gha x'áíse xae e, nqõó ba x'áíse tamase?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Me Jeso ba xo̱a a máá: “Ncẽè khóèm kò ncàm̀ Tea hãa nem gha kg'uia Te qgóóa qari, Me gha Abo ba ncàm̀ me, Tsam gha hàà cgae me, a Tsam a gha Sitsam di x'ãè-q'ooan gaam koe kúrú. ");
INSERT INTO nhr_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Gaam ẽe ncàm̀ Te tama ba kg'uia Te qgóóa qari tama; i gataga kg'uian ẽe xao ko kóḿ, Tíí koe guu tama, igaba i ncẽe tsééa óá Team Abom koe guua. ");
INSERT INTO nhr_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ncẽe gúùa ner bìrí xaoa hãa, ẽer kò qanega gaxao cgoa hãa ka. ");
INSERT INTO nhr_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Igaba Hùi-kg'aom ncẽe Tcom-tcomsam Tc'ẽe ii ba, ncẽem gha Abo ba Tiri cg'õèan cgoa tsééa óá ba, nxãa ba gha wèé gúùan ga xgaa-xgaa xao o, a ba a gha wèé gúùan ẽer bìrí xaoa hãa tc'ẽe-tc'ẽesekagu xao o. ");
INSERT INTO nhr_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Tòókuan cgoar ko guu xao o, Tiri tòókua ner ko máà xao o. Nqõóm ko ma máà xao o khamar ma máà xao o tama. Táá méé i tcáóa xao nxùrù qgáì koe hãa guu, kana méé xao táá q'áò guu. ");
INSERT INTO nhr_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kóḿ tea xao kò hãa Ra ko bìrí xao o a ko máá: ‘Qõò Ra ko, a Ra a gha ka̱bise a hàà cgae xao o,’ témé. Ncẽè ncàm̀ Tea xao kò hãa ne xao ga kò Abom koer ko qõò khama qãè-tcaoa, Abo ba Tíí ka kaia hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ra ncãa ncẽeska bìrí xao o, qanega i kúrúse tama cookg'ai koe, nxãasega xao gha ẽe i kòo kúrúse ne dtcòm̀ ka. ");
INSERT INTO nhr_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Gaicarar qáòse kg'ui cgoa xaoa hãa tite, ncẽem nqõóm dim x'aiga ba ko hàà khama. Cúí qari gam Tíí koe úú tama, ");
INSERT INTO nhr_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","igaba méém nqõó ba q'ãa, Abo ba Ra ncàm̀a hãa, a ko Abom ma x'áè Tea hãa khama ma tséé sa. “Tẽe xao ncẽeska, naka hààn xae qõò,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","A ba a máá: “Tíí Ra tseegu dir Kg'om Ra a, Me Tirim Xõò ba Xhárà-kg'ao Me e. ");
INSERT INTO nhr_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tíí koe hãam nxã̱am wèém ẽe tc'áróan kúrú tama bam ko q'ãea tcg'òó, a ba a ko wèém nxã̱am ẽe ko tc'áróan kúrú ba dcàò, nxãasegam gha q'ano a káí tc'áróan kúrú ka. ");
INSERT INTO nhr_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nxãakamaga tu ncẽer kò kg'ui cgoa tu um kg'uim ka q'anokaguèa. ");
INSERT INTO nhr_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Tíí koe tu hãa nakar Tíí gatu koe hãa. Cúím nxã̱am ga ba cúíam kò hãa ne tc'áróan kúrúa hãa tite, kg'om dis hìis koem kò hãa ne cúí ga a, gatu igaba tu gatà hẽéa tite, Tíí koe tu kò hãa ne cúí ga a. ");
INSERT INTO nhr_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Tíí Ra Kg'om Ra a, tu gatu nxã̱a tu u. Gaam ẽe Tíí koe hãa, Ra Tíí gam koe hãa ba, gam káí tc'áróan ko kúrúm ga me e, Tíí ka oose tu cúí gúù ga kúrúa hãa tite khama. ");
INSERT INTO nhr_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ncẽè khóèm kò Tíí koe hãa tama, nem ko nxã̱am khama ma xaoaguè, a ba a xgóó; ẽeta ii nxã̱a ne ko sáà xg'ae, a c'eean q'oo koe síí xaoa tcãà, a dàòè. ");
INSERT INTO nhr_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ncẽè Tíí koe tu kò hãa, i Tiri kg'uian gatu koe hãa ne tu gha ẽe tu ko tc'ẽes wèé sa dtcàrà, a tu a gha kúrúa mááè si. ");
INSERT INTO nhr_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Si ko ncẽe sa Tirim Xõò ba x'áàkagu: káí tc'áróan tu gha kúrú, a tu a gha gatà iim dàòm ka Tiri tu xgaa-xgaase-kg'ao tu ii. ");
INSERT INTO nhr_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ncẽem ma Abo ba ncàm̀ Tea hãa khamagar ma ncàm̀ tu ua hãa. Ke méé tu ncẽeska Tiri ncàm̀kuan koe hãa. ");
INSERT INTO nhr_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ncẽè Tiri x'áèan tu kò qgóóa qaria, ne tu gha Tiri ncàm̀kuan koe hãa, ncẽer ma Tirim Xõòm di x'áèan ma qgóóa qaria, a Gam di ncàm̀kuan koe ma hãa khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ncẽe gúùa ner bìrí tua hãa, nxãasega i gha Tiri qãè-tcaoan gatu koe hãa ka, naka gatu di qãè-tcaoan gha cg'oè ka hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Tirim x'áè-kg'áḿ ba ncẽe me e: ncàm̀ gatu ka c'ẽea ne, ẽer ma ncàm̀ tua hãa khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cúí khóè ga ncẽes ncàm̀s ka kaia hãas ncàm̀ sa úúa hãa tama, ncẽe khóèm ko ẽem ncàm̀a hãa ne khóè ne gam di kg'õèan tcg'òóa máá sa. ");
INSERT INTO nhr_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Tu gatu ẽer ko x'áè tu u sa tu kòo kúrú ne Tiri tu ncàm̀-khoe tu u. ");
INSERT INTO nhr_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cuiskagar gaicara qãà ta ma tcii tua hãa tite, qãà ba gam ka q'õòsem ko dùú sa kúrú sa c'úùa hãa khama. Ncẽes gúùs téé-q'oo koe Ra ko ncàm̀-khoe tu ta ma tcii tu u, wèés gúùs ẽer Tirim Xõòm koe xgaa-xgaasea hãa sar q'ãakagu tua hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Gatua nxárá tcg'òó Te ta ga hãa, igabar Tíí nxárá tcg'òó tua hãa, a Ra a qõò tu gha a síí tc'áróan kúrú ka nxárá tcg'òó tua, tc'áróan ncẽe gha qáò x'aèan hãa a, nxãasegam gha Abo ba wèés gúùs ẽe tu gha ko Tíí cg'õè koe dtcàrà sa máà tu u ka. ");
INSERT INTO nhr_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ncẽea Ra ko ma x'áè tu u ga a, a ko máá, gatu ka c'ẽe ne ncàm̀, témé. ");
INSERT INTO nhr_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ncẽè nqõóm kò hòre tua hãa ne méé tu q'ãa, gatuam hòre tua hãa cookg'ai koem kò Tíía hòre Tea hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ncẽè nqõóm di tu kò ii nem ga kò nqõó ba gam di tu iise ncàm̀ tua hãa; igaba tu nqõóm di tu tama tu u, Ra kò nqõóm koe guu a nxárá tcg'òó tu u, gaa domkam ko nqõó ba hòre tu u. ");
INSERT INTO nhr_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ncẽer kòo kg'ui cgoa tu u kg'uian méé tu tc'ẽe-tc'ẽese, a ko máá: ‘Qãà ba gam ka q'õòsem ka tc'amaka hãa tama,’ témé sa. Ncẽè xgàra Te ne kòo ne, ne gha gataga thẽé xgàra tu u. A ncẽè Tiri xgaa-xgaa ne ne kòo qgóóa qari ne ne gha gataga thẽé gatu dian igabaga qgóóa qari i. ");
INSERT INTO nhr_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Igaba ne gha wèé gúùan ncẽe ga Tiri cg'õèan domka kúrú cgae tu u, Gaam ẽe tsééa óá Tea hãa ba ne c'úùa hãa domka. ");
INSERT INTO nhr_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ncẽè thuur kò hàà kg'ui cgoa ne tama ne, ne ga kò chìbian úú tama. Igaba ne ncẽeska gane di chìbian koe ne gha qgóóa mááèm dàò ba úú tama. ");
INSERT INTO nhr_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Gaam ẽe hòre Tea ba gataga Tirim Abo ba hòrea. ");
INSERT INTO nhr_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ncẽè c'ẽe khóè ga qanega kúrú tama sar kò gane koe kúrú ta ga hãa, ne ne ga kò chìbi úú tama. Igaba ne ncẽe zi x'áí zi bóòa hãa, a ne a Tíí ga Ra hẽé naka Tirim Xõòm ga ba hẽéthẽé Tsam hòrea. ");
INSERT INTO nhr_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Igabas ko ncẽe sa x'áèan koe góásea hãa sa nxàea tseegukagu, ncẽe ko máá: ‘Hòrea ne máá tea hãas gúù sa káà si i,’ témé sa. ");
INSERT INTO nhr_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Igaba ẽem kòo Hùi-kg'ao ba hàà, ncẽer gha Abom koe guu a gatu koe tsééa úú ba, tseeguan dim Tc'ẽe ba, ncẽe ko Abom koe guu a tcg'oa ba, nem gha Gabá Tíí ka nxàea tseegukagu. ");
INSERT INTO nhr_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Gatu igaba tu gha Tíí ka hàà nxàea tseegukagu, Tíí cgoa tu kò tshoa-tshoases koe ga guu a hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ncẽe gúùan wèér bìrí xaoa hãa, nxãasega xao gha táá gaxao di dtcòm̀an aagu ka. ");
INSERT INTO nhr_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Còrè-nquuan koe ne gha xhàiagu xao o, me gha gataga x'aè ba hàà, wèém khóèm ẽe ko cg'õo xao om gha tc'ẽea máá, Nqari bam ko tsééa máá, ta tc'ẽea ba. ");
INSERT INTO nhr_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ncẽe zi gúù zi ne gha kúrú cgae tu u, Abo ba kana Tíí ga Ra ne c'úùa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Igabar ncẽe gúùan bìrí xaoa hãa, nxãasega xao gha ẽem kòo gaan dim x'aè ba hàà ne tc'ẽe-tc'ẽese, gaan kar q'ãa-q'ãa xaoa hãa sa ka. “A ra a kò ncẽe zi gúù zi tshoa-tshoas koe táá bìrí xao o, gaxao cgoar kò hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Igabar ko ncẽeska Gam ẽe tséé óá Team koe qõò, igaba i gaxao ka cúía xao ga tẽè Te naka máá: ‘Nda koe Tsi ko qõò?’ témé tama. ");
INSERT INTO nhr_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Igaba ncẽe gúùa ner nxàea hãa domka xao tshúù-tcaoan ka cg'oè cgaeèa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gatà i ii igabar ko tseeguan bìrí xao o: Gaxaoa i qãèa máá xaoa hãa qõòr gha sa. Ncẽè qõò tamar kò hãa nem Hùi-kg'ao ba hàà cgae xaoa hãa tite khama. Igaba ẽe qõòr kòo ner gha gaxao koe tsééa úú Me. ");
INSERT INTO nhr_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Eẽm kòo hàà nem gha hàà nqõó ba xgaa-xgaa a chìbi-chibi; chìbian domka hẽé, naka tchànoan domka hẽé, naka xgàrakuan domka hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Chìbian kam gha xgaa-xgaa, Tíí koe ne dtcòm̀ tama khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tchànoan kam gha xgaa-xgaa, Tirim Xõòm koer ko qõò, xao gaicara hòò Te tite khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Xgàra-kg'aman kam gha xgaa-xgaa, ncẽem nqõóm dim x'aiga ba nxãakamaga xgàraèa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Qanegar káí zi gúù zi úúa, gaxao cgoar gha nxàe zi, igaba xao ncẽeska kgoana zia hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Igaba ẽem kòo tseeguan dim Tc'ẽe ba hàà, nem gha wèé tseeguan koe úú xao o. Cuiskagam Gam koe guua zi ka kg'uia hãa tite, igabam gha ẽem ko kóḿs ka cúí kg'ui, a ba a gha hààko zi gúù zi ka bìrí xao o. ");
INSERT INTO nhr_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","X'áàkagu Tem gha, ẽe Tiri ii sam gha séè, a ba a bìrí xao o si khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Wèéan ẽe Abom úúa hãa nea Tiri i. Gaa domkar ko máá: Eẽ Tiri ii sam gha Tc'ẽe ba séè, a ba a bìrí xao o si, témé. ");
INSERT INTO nhr_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“X'aè-coa ba xao hòò Tea hãa tite, a xao a gha gaicara x'aè-coam qãá q'oo koe hòò Te,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Xu kò Gam di xu xgaa-xgaase-kg'ao xu c'ẽe xu tẽèku a máá: “Dùú sa ba ko nxàe, ncẽem ko máá: ‘X'aè-coa ba xao hòò Tea hãa tite, a xao a gha gaicara x'aè-coam qãá q'oo koe hòò Te,’ témé ka, a ko gataga máá: ‘Tirim Xõòm koer ko qõò domka a,’ témé?” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Xu hãa a tẽèse a ko máá: “Dùú sa ba koáé nxàe: ‘X'aè-coam q'oo koe,’ tam kòo méé ne? Dùú sam ko nxàe sa xae kóḿa q'ãa tama,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Me kò Jeso ba bóòa q'ãa, ncẽes gúùs ka xu tẽè Me kg'oana hãa sa, khamam kò nxãaska bìrí xu a máá: “Ntar ko méé sa xao koáé tẽèku, ncẽer ko máá: ‘X'aè-coam q'oo koe xao hòò Tea hãa tite, a xao a gha gaicara x'aè-coam qãá q'oo koe hòò Te,’ témé ka? ");
INSERT INTO nhr_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tseegua ner ko bìrí xao o, a ko máá: Kg'ae xao gha, a gha thõò-tcaoase kg'ae, igabam gha nqõó ba qãè-tcaoa hãa. Thõò-tcaoa xao gha hãa, igaba i gha gaxao di thõò-tcaoan ka̱bise a qãè-tcao sa ii. ");
INSERT INTO nhr_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Eẽ khóès kòo cóán ábà di thõò koe hãa nes tshúù-tcaoa hãa, gas dim x'aè ba hààraa khama. Igaba ẽes ko cóán ábà xg'ara nes gaicara thõòan tc'ẽe-tc'ẽese tama, qãè-tcaoan ẽe cóá nea nqõómkg'ai koe ábàèa hãa di domka. ");
INSERT INTO nhr_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Khama xao gaxao ncẽeska tshúù-tcaoan úúa hãa, igabar gha gaicara hàà bóò xao o, xao gha qãè-tcao, i cúí khóè ga gaxao di qãè-tcaoan séè cgae xaoa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Eẽm cáḿ ka xao cuiskaga cúí gúù ga dtcàrà Tea hãa tite. Tseegukar ko tseeguan bìrí xao o, a ko máá: Wèés gúùs ẽe xao ko Tíí cg'õè cgoa Abom koe dtcàrà sam gha máà xao o. ");
INSERT INTO nhr_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ncẽeska igaba xao qanega cúí gúù ga Tíí cg'õè cgoa dtcàrà tama. Dtcàrà, máàè xao gha ke, naka xaoa gha nxãasega qãè-tcaoan ka cg'oè. ");
INSERT INTO nhr_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Ncẽe gúùa ner kò sere-sere zi cgoa bìrí xao o, igabam ko x'aè ba hàà, gaxao cgoar gaia sere-sere zi cgoa kg'uia hãa tite ba, igabar gha hàà kgoarasea hãase Tirim Xõòm ka bìrí xao o. ");
INSERT INTO nhr_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Eẽm cáḿ ka xao gha Tíí cg'õè koe dtcàrà. Gaxao téé-q'oo koer gha Abo ba hàà dtcàrà, tar méé tama. ");
INSERT INTO nhr_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Abo ba Gam ka ncàm̀ xaoa hãa, ncàm̀ Tea xao hãa domka, a xao a Nqarim koer guua sa dtcòm̀a hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Abom koer guu a nqõóm koe hààraa. A Ra a ko gaicara nqõó ba guu, a Abom koe ka̱bise,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Xu kò nxãaska Gam di xu xgaa-xgaase-kg'ao xu máá: “Bóò, ncẽeska Tsi ko kgoarasea hãase kg'ui, a Tsi a cúís sere-seres ga sa tséékagu tama. ");
INSERT INTO nhr_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ncẽeska xae ko bóò wèé gúùan Tsi q'ana hãa sa, a Tsi a gataga c'ẽe khóè ga gha tẽè Tsi sa qaa tama. Ncẽes gúùs domka xae ko dtcòm̀ Nqarim koe Tsi guua hãa sa,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Me Jeso ba xo̱a xu a máá: “Ncẽeska xaoa ko dtcòm̀? ");
INSERT INTO nhr_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bóò, x'aè ba ko hàà, a ba a hààraa xg'ara, ẽe xao gha wèéa xao ga x'áéa xao koe guu a tsa̱i-tsa̱ise ba, a xao a gha cúíse qaù Te. Igabar cúíse hãa tama, Tirim Xõò ba Tíí cgoa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Ncẽe gúùa ner bìrí xaoa hãa, nxãasega xao gha Tíí koe tòókuan úú ka. Ncẽem nqõóm koe xao gha qóḿan cgoa qgóóku. Igaba méé xao tòón tcáó! Nqõó bar tààa hãa ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Eẽm ko Jeso ba ncẽe sa kg'uia xg'ara kam ko nqarikg'ai koe ghùi-kg'ai a máá: “Aboè, x'aè ba hààraa. Tsarim Cóá ba x'áàkagu, nakam gha nxãasega Tsarim Cóá ba x'áàkagu Tsi, ");
INSERT INTO nhr_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","wèé ne khóè ne tc'amkg'ai koe Tsi qarian máà Mea hãa ke, nxãasegam gha chõò tamas kg'õè sa wèé ne ẽe Tsi máà Mea hãa ne máà ka. ");
INSERT INTO nhr_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Si chõò tamas kg'õè sa ncẽe si i: q'ãa Tsi ne gha, Tsáá Tsia cúísega tseegu di Tsi Nqari Tsi i sa, naka Jeso Krestem ncẽe Tsi tsééa óága hãa ba q'ãa sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nqõómkg'ai koer x'áàkagu Tsia hãa, ẽe Tsi kò máà Tea hãa tsééan kúrúa xg'ara-xg'ara ka. ");
INSERT INTO nhr_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ke ncẽeska, Aboè, hàna Tsia koe x'áàn máà Te, ncẽe nqõóm tshoa-tshoase tama cookg'ai koer kò Tsáá cgoa úúa hãa a. ");
INSERT INTO nhr_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Eẽ Tsi kò nqõómkg'ai koe guu a máà Te xu khóè xu koer kò Tsari cg'õèan q'ãakagu. Tsari xu u kò ii, Tsi kò máà Te xu, xu kò Tsarim kg'ui ba qgóóa qaria. ");
INSERT INTO nhr_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ncẽeska xu q'ana, ẽe Tsi máà Tea hãa gúùan wèéa Tsáá koe guua hãa sa. ");
INSERT INTO nhr_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Eẽ Tsi kò máà Tea kg'uia ner máà xua hãa khama, xu kò cám̀ tshàua máá a. A xu a kò tseeguan kaga q'ãa, Tsáá koer guua hãa sa, a kò Tsáá Tsia tséé Tea hãa sa dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nqõó bar còrèa máá tama, a ko gaxu ẽe Tsi máà Tea hãa xu còrèa máá, Tsari xu u khama. ");
INSERT INTO nhr_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Wèés ẽer úúa hãa sa Tsari si i, si wèés ẽe Tsi úúa sa Tiri si i. Ra gaxu koe guu a x'áàkaguèa. ");
INSERT INTO nhr_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nqõómkg'ai koe Ra gaia hãa tite, igaba xu gaxu qanega nqõómkg'ai koe hãa, Ra ko Tíí sencgaga Tsáá koe síí. Tcom-tcomsa Tsi Abo Tseè, Tsarim cg'õèm di qarian cgoa xgáèa máá xu - cg'õèm ncẽe Tsi máà Tea ba, naka xu gha nxãasega cúí ii, ncẽe Tsam ma cúí ii khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Eẽr kò gaxu cgoa hãa kar kòo xgáèa máá xu, a ẽe Tsi kò máà Tea hãam cg'õèm cgoa kòre xu. Cúía xu ga kò táá aaguse, gaam ẽe kò kaàkaguèm gha sa tééa máána hãam cúím oose, Nqarim dis Tcgãyas gha nxãasega nxàea tseegukaguè ka. ");
INSERT INTO nhr_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Igabar ko ncẽeska Tsáá koe síí, a Ra a ko ncẽe zi gúù zi kg'ui, nqõómkg'ai koer qanega hãase, nxãasega xu gha Tiri qãè-tcaoan ka cg'oèa hãa ka. ");
INSERT INTO nhr_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Tsarim kg'ui bar máà xua, me nqõó ba hòre xua, nqõóm di xu tama xu u khama, ncẽer Tíí ma nqõóm di tama khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tiri còrèa ne máá, nqõóm koe méé Tsi séèa tcg'òó xu, témé tama, igaba méé Tsi ẽe cg'ãè iim koe xgáèa máá xu si i. ");
INSERT INTO nhr_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Nqõóm di xu tama xu u, ncẽer Tíí ma nqõóm di tama khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tcom-tcomsakagu xu tseeguan cgoa, Tsarim kg'ui ba tseeguan di me e ke. ");
INSERT INTO nhr_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Eẽ Tsi ma nqõómkg'ai koe ma tsééa óá Tea hãa khamagar ma nqõómkg'ai koe tsééa úú xua hãa. ");
INSERT INTO nhr_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Gaxu domkar ko tcom-tcomsakaguse, nxãasega xu gha gaxu igaba thẽé tseeguan koe tcom-tcomsakaguè ka. ");
INSERT INTO nhr_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Gaxu cúí xur còrèa máá tama. Eẽ gha gaxu di kg'uian koe guu a Tíí koe dtcòm̀ ner ko gataga thẽé còrèa máá, ");
INSERT INTO nhr_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","wèéa ne ga gha cúí ii sa, ẽe Tsi ma Tsáá Aboè Tíí koe hãa, Ra ma Tíí Tsáá koe hãa khamaga ma. Gane igaba méé ne thẽé Gatsam koe hãa, nakam gha nxãasega nqõó ba Tsáá Tsia tséé óá Tea hãa sa dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Eẽ Tsi máà Tea hãa x'áà ner máà nea, nxãasega ne gha cúí ii ka, ncẽe Tsam ma Gatsam ma cúí ii khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Tíí Ra gane koe hãa, Tsi Tsáá Tíí koe hãa, nxãasega ne gha cg'oèase cúí ii ka, me gha nxãasega nqõó ba q'ãa, Tsáá Tsia tsééa óá Tea hãa sa ka, a Tsi a ncàm̀ nea, ẽe Tsi ma ncàm̀ Tea hãa khamaga ma ka. ");
INSERT INTO nhr_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Aboè, ẽe Tsi máà Tea hãa ne gha Tíí cgoa ncẽer hãa koe hãa sar ko tc'ẽe, nxãasega ne gha Tiri x'áàn bóò, ncẽe Tsi máà Tea hãa a, nqõóm tshoa-tshoase tama cookg'ai koe Tsi kò guu a ncàm̀ Tea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Abo Tsi tchàno Tseè, ẽetam ga ma nqõó ba c'úù Tsia igaba Ra Tíí q'ãa Tsia, ne q'ana hãa Tsáá Tsia tsééa óá Tea sa. ");
INSERT INTO nhr_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Cg'õèa Tsir q'ãakagu nea, a Ra a gha kúrú i q'ãaè, nxãasega i gha ncàm̀kuan ncẽe Tsi kò ncàm̀ Tea hãa gane koe hãa ka, Ra gha gataga thẽé Tíí ga Ra gane koe hãa ka,” tam ma còrè. ");
INSERT INTO nhr_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Eẽm ko Jeso ba còrèa xg'ara, kam kò Gam di xu xgaa-xgaase-kg'ao xu cgoa xgoaba, a Kiterone dim dòm̀ ba tchoaba. C'ẽem xòèm koem kò Olife di zi hìi zi dim xhárà ba hãa. Xu kò Gabá hẽé naka Gam di xu xgaa-xgaase-kg'ao xu hẽéthẽé xu gaa koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nxãaskam kò Jutasem, ncẽe kò khóè ne tshàu q'oo koe tcãà Me ba gaam qgáì ba q'anaa, Jeso ba kò gaa koe káí-kg'aise Gam di xu xgaa-xgaase-kg'ao xu cgoa xg'ae khama. ");
INSERT INTO nhr_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Me kò nxãaska Jutase ncõo-kg'ao xu dis xg'ae sa hẽé naka kaia xu peresiti xu ka c'ẽea xu hẽé naka Farasai xu hẽéthẽé cgoa gaa koe síí. X'áà zi xu kò qgóóa, lampian hẽé naka ncõo gàban hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Me kò Jeso ba wèéan ẽe gha hàà kúrúse cgae Me sa q'ana hãase tcg'oa a tẽè xu a máá: “Dìí ba xao ko qaa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Xu xo̱a Me a máá: “Jesom Nasareta di Me e,” témé. Me Jeso ba máá: “Tíí ga Ra a,” témé. (Me kò Jutasem, khóè ne tshàu q'oo koe tcãàku-kg'ao ba gaxu cgoa téé-tẽe.) ");
INSERT INTO nhr_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Eẽm ko Jeso ba máá: “Tíí ga Ra a,” témé, ka xu kò tééa dìbi, a xu a góḿankg'ai koe cg'áé. ");
INSERT INTO nhr_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Me kò gaicara tẽè xu a máá: “Dìí ba xao ko qaa?” témé. Xu máá: “Jesom Nasareta di Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Me Jeso ba xo̱a xu a máá: “Ncãar bìrí xao o, ncẽe ga Ra a sa. A ncẽè Tíí xao kòo qaa Te ne méé xao nxãaska ncẽe xu khóè xu guu naka xu qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ncẽe sa kò kúrúse, kg'uian ẽem kg'uia hãa gha nxãasega tseegukaguè ka, ncẽe kòo máá: “Eẽ Tsi kò máà Te xu kar c'ẽem ga ba qanega aagu tama,” témé sa. ");
INSERT INTO nhr_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Me kò nxãaska Simonem Petere ba ntcàu bam úúa hãa khama tsgúùa tcg'òó me, a kaiam peresitim dim qãà ba gáò, a kg'áò xòè dim tcee ba xg'aoa tcg'òó. (Qãàm di cg'õèa ne kò Malekose e.) ");
INSERT INTO nhr_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kam kò nxãaska Jeso ba Petere ba bìrí a máá: “Ka̱bi tsarim ntcàu ba naka qòè! Cuiskaga Ra gáé ga Abom máà Tea hãas kubis xgàrasean dis koe kg'áà hãa tite?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Si kò nxãaska ncõo-kg'ao xu dis xg'ae sa hẽé, naka gaas dim tc'ãà-cookg'ai ba hẽé, naka Juta di xu tc'ãà-cookg'ai xu hẽéthẽé Jeso ba qgóó, a qáé, ");
INSERT INTO nhr_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","a xu a kg'aia Anasem koe úú Me, ncẽe kò Kaifasem ka c'uìse ii ba, ncẽe kò ẽem kurim ka kaiam peresiti ba ii ba. ");
INSERT INTO nhr_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifase ba gaam khóèm Juta xu kò tc'ẽe sa máàm ga me e, a máá: “Qãè e gha ii, ncẽè c'ẽem khóèm kòo khóè ne x'óóa máá ne,” témé ba. ");
INSERT INTO nhr_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simonem Petere ba hẽé naka c'ẽem xgaa-xgaase-kg'ao ba hẽéthẽéa kò Jeso ba xùri. Ncẽem xgaa-xgaase-kg'ao ba kò kaiam peresitim ka q'ãaèa, khamam kò Jesom cgoa kaiam peresitim x'áé koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Igabam kò Petere ba tchàa koe téé, xhàrom-kg'áḿ koe. Kam ko c'ẽem xgaa-xgaase-kg'aom ncẽe kò kaiam peresitim ka q'ãaèa ba ka̱bise a tcg'oa, a dxàe-coas ẽe kò xhàrom-kg'áḿ koe hãas cgoa kg'ui, a Petere ba q'oo koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Si kò qãàs ẽe kò xhàrom-kg'áḿ koe tẽe sa Petere ba bìrí a máá: “A tsáá tsia gáé ncẽem khóèm di xu xgaa-xgaase-kg'ao xu ka c'ẽe tsi tama tsia?” témé. Me xo̱a a máá: “Gaar tama ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Qgàisa a kò ii, xu kò qãà xu hẽé naka tempelem di xu kòre-kg'ao xu hẽéthẽé xu ẽe xu kò dxùua hãas c'ees koe téé-tẽe, a ko x'oò-x'oose. Petere ba kò gataga thẽé gaxu cgoa téé-tẽe, a ko x'oò-x'oose. ");
INSERT INTO nhr_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Me kò nxãaska kaiam peresiti ba Jeso ba tẽè, Gam di xu xgaa-xgaase-kg'ao xu ka hẽé naka Gam di xgaa-xgaan ka hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Me Jeso ba xo̱a me a máá: “Xgobekg'amseaser kò wèém nqõóm cgoa kg'ui, a Ra a kò ko wèé x'aè ka còrè-nquuan koe hẽé, naka tempelem koe hẽéthẽé xgaa-xgaa, ncẽe wèé Jutan ko xg'ae koe. Cúí gúù gar kò táá xàìase nxàe. ");
INSERT INTO nhr_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kháé tsia ko dùús domka tẽè Te? Tẽè ẽe kò kóḿ Tea hãa ne, tseeguan kaga ne q'ana dùú sar nxàea hãa sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Eẽm ko Jeso ba ncẽe gúùan kg'uia xg'ara kam kò c'ẽem kòre-kg'aom, cúùse kò tẽe ba Jeso ba x'ábú, a máá: “Ncẽea Tsi ga ko ma kaiam peresiti ba ma xo̱a gaa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Me Jeso ba xo̱a me a máá: “Ncẽè c'ẽe gúùan cg'ãè Ra kò kg'uia hãa ne méé tsi nxàea tseegukagu, dùú sa cg'ãè si i sa. Igaba ncẽè tchànoser kò kg'uia hãa ne tsi ko dùús domka x'ábú góó Tea máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Me nxãaska Anase ba kaiam peresitim Kaifasem koe tsééa úú Me, qanegam qáéèa hãase. ");
INSERT INTO nhr_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Eẽm Simonem Petere ba hãa a ko kùru-kuruse kam kò tẽèè a máá: “Tsáá tsia gáé Gam di xu xgaa-xgaase-kg'ao xu ka c'ẽe tsi tama tsia?” témé. Me xo̱ase a máá: “Gaar tama ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Me kò c'ẽem qãàm kaiam peresitim di ba, ncẽe Peterem kò xg'aoa tcg'òó tceeam khóèm dim qhàò ba tẽè me a máá: “Gaam cgoa ra gáé kò Olife dim xháràm q'oo koe bóò tsi tama?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Me gaicara Petere xo̱ase e, me kò kúúga ghòrò ba tshoa-tshoa a kg'ae. ");
INSERT INTO nhr_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Xu kò Juta xu Jeso ba Kaifasem dim nquum koe guu a, Roma ne dim tc'ãà-cookg'aim dim nquum koe úú. Gaa x'aèan ẽe ka i kò kaisa ntcùúkg'ai cgoa a. Xu kò Juta xu táá xu gha cg'uriga domka nquum q'oo koe táá tcãà, nxãasega xu gha Paseka di tc'õoan tc'õó ka. ");
INSERT INTO nhr_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Khamam kò Pilato ba tcg'oa a síí cgae xu, a tẽè xu a máá: “Dùútsa chìbi sa xao ko ncẽem Khóè ba tcee?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Xu xo̱a me a máá: “Chìbi kúrú-kg'ao tamam kò ii ne xae ga kò tsáá koe óá Me tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Me Pilato nxãaska bìrí xu a máá: “Séèa xao mááse Me, naka xaoa síí gaxao di x'áèan cgoa xgàra Me,” témé. Xu Juta xu xguì a bìrí me a máá: “Igaba xae c'ẽem khóè ba xae gha x'ooan koe xgàra di qari úú tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ncẽe sa kò kúrúse, ẽem kò Jeso ba kg'uia hãa, nta iis x'oo sam gha hàà x'óó di kg'uian gha hàà nxãasega tseegukaguè ka. ");
INSERT INTO nhr_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Me kò nxãaska Pilato ba ka̱bise a nquum q'oo koe tcãà, a Jeso ba tcii, a tẽè Me a máá: “A Tsáá ga Tsia Juta ne di Tsi x'aiga Tsi?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Me Jeso ba xo̱a a máá: “Tsáá ka tsi ko ma cuiaga tẽè Tea, kana c'ẽe khóèa Tíí ka tsáá cgoa kg'uia hãa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Me Pilato xo̱a a máá: “Kháé tíí ga ra gáé Juta raa? Tsari ne khóè ne hẽé naka Tsari xu kaia xu peresiti xu hẽéthẽéa tíí tshàu q'oo koe tcãà Tsia. Ka Tsia dùú sa kúrúa hãa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Me Jeso ba xo̱a a máá: “Tiri x'aia nea ncẽem nqõóm di tama. Ncẽè gatà i kò ii, ne xu ga kò Tiri xu tséé-kg'ao xu ncõo sa x'ãà hãa, nxãasegar gha táá Juta ne tshàu q'oo koe tcãàè di sa. Igaba i ncẽeska Tiri x'aian ncẽem nqõóm di tama a,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Me Pilato nxãaska tẽè Me a máá: “Kháé Tsia x'aiga Tsia?” témé. Me Jeso ba xo̱a a máá: “X'aiga Ra a, ta tsi ko méé. Gaas gúùs domkaga Ra ábàèa, a Ra a ncẽes gúùs domkaga nqõómkg'ai koe hààraa, hààr gha nxãasega tseeguan nxàea tseegukagu ka. Wèé khóèan ẽe tseeguan dia ko kg'uia Te komsana,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Me Pilato ba bìrí Me a máá: “Tseegua nea dùúa?” témé. Ncẽes gúù sam ko mééa xg'ara kam kòo tchàa koe tcg'oa, a gaicara Juta xu koe síí, a bìrí xu a máá: “Cúí chìbi gar hòò cgae Me tama gaan kam gha chìbi-chibiè e. ");
INSERT INTO nhr_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Igaba i gatu di cau u, Paseka di x'aè ka méér c'ẽem chìbi-kg'ao ba kgoara máá tu u sa. Ka tu ko tc'ẽe, Juta ne dim X'aiga ba méér kgoara máá tu u sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Xu q'au a xo̱a me a máá: “Eẽ-ẽe, Gam ka tamase, Barabase ba máà ta a,” témé. Barabase ba kò ts'ãà-kg'ao me e. ");
INSERT INTO nhr_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nxãaskam kò Pilato ba Jeso ba séè a úú, Me síí qoaè. ");
INSERT INTO nhr_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Xu kò ncõo-kg'ao xu dxàman cgoa kúrúèas cábá sa kabea xg'ae a cábákagu Me, a xu a nco̱àm qgáí ba hã̱akagu Me, ");
INSERT INTO nhr_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","a téé a qõòa máá Me a ko máá: “Tcgáíò, Juta ne di Tsi X'aiga Tseè!” témé. A xu a tshàua xu cgoa x'ábú góó Me. ");
INSERT INTO nhr_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Me kò Pilato ba gaicara tcg'oa a Juta xu bìrí a máá: “Bóò, tcg'òó ra ko a gaxao koe óá Me, nxãasega xao gha q'ãa, tíí ra cúí chìbi ga hòò cgae Me tama sa ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Eẽm ko Jeso ba tcg'oa, dxàman dis cábá sa cábá hãase, a nco̱àm qgáí ba ha̱na, kam ko Pilato bìrí xu a máá: “Bóò! Ncẽe ga Me e khóè ba!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Eẽ xu ko kaia xu peresiti xu hẽé naka tempelem di xu kòre-kg'ao xu hẽéthẽé ko bóò Me, ka xu kò q'au a máá: “Xgàu Me! Xgàu Me!” témé. Igabam kò Pilato xo̱a xu a máá: “Gaxao séè naka síí xgàu Me, tíí ra cúí chìbi ga hòò cgae Me tama ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Xu Juta xu xo̱a a máá: “X'áèan ta úúa; gaa x'áèan ẽe ka méém x'óós gúù si i, Nqarim dim Cóá Me e tam ko méé khama,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Eẽm ko Pilato ncẽes gúù sa kóḿ kam kò kaisase q'áò, ");
INSERT INTO nhr_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","a ba a ka̱bise a gaicara nquum q'oo koe tcãà, a Jeso ba tẽè a máá: “Nda koe Tsi guua?” témé. Igabam kò Jeso ba táá cúí xo̱a ga kúrú. ");
INSERT INTO nhr_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Me Pilato ba tẽè Me a máá: “Tíí cgoa kg'uian Tsi tc'ẽe tama? C'úùa Tsia, qaria ner úúa, kgoara Tsir gha di i kana xgàu Tsi di i sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Me Jeso ba xo̱a a máá: “Cúí qari ga tsi Tíí koe úú tama, ncẽè nqarikg'ai koe tsi kò guu naka máàè e tama ne. Gaa domkam gaam ẽe tshàu q'ooa tsi koe tcãà Tea ba chìbiga me e, kaias chìbi sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Gaa koe guus kam kò Pilato ba Jeso bam gha kgoara cgoa dàòan qaa, igaba xu kò Juta xu q'au a ko máá: “Eẽ tsi kòo ncẽem khóè ba kgoara ne tsi Roma ne dim x'aigam Kaesaram ka tcáràse tsi tama tsi i. Wèém khóèm ẽe ko máá, x'aiga Me e, témé ba ko Kaesaram cgoa ntcoeku,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Eẽm ko Pilato ncẽe kg'uian kóḿ kam kò Jeso ba tchàa koe tcg'òó, a ba a xgàra-kg'aom dis ntcõó-q'oos koe síí ntcõó, ‘Nxõ̱án dim nqáḿ ba’ ta ko ma tciièm qgáìm koe (Hebera dis kg'uis ka ko Gabata ta ma tciiè ba). ");
INSERT INTO nhr_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Paseka dim cáḿ ba kg'ónòsea máá dim cáḿ me e kò ii, i kò koaba di x'aè e. Kam kò Pilato ba Juta ne bìrí a máá: “Bóò, ncẽe ga Me e gatu dim X'aiga ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Igaba xu kò q'au a máá: “Tcg'òó Me! Tcg'òó Me! Xgàu Me!” témé. Me Pilato tẽè xu a máá: “Kháé méér gaxao dim X'aiga ba xgàu dèe?” témé. Xu kaia xu peresiti xu xo̱a a máá: “X'aiga ta úú tama, Kaesaram oose,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Me kò nxãaska Pilato máà xu Me, nxãasegam gha xgàuè ka. Xu kò nxãaska ncõo-kg'ao xu Jeso ba séè, ");
INSERT INTO nhr_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Me Gam dis xgàu sa dcẽé a tcg'oa, a ‘Tcúú c'õá’ ta ko ma tciiès qgáìs koe síí (ncẽè ko Hebera dis kg'uis ka ko ‘Gologota’ ta ma tciiè sa). ");
INSERT INTO nhr_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Gaa koe xu kò xgàu Me, naka c'ẽe tsara khóè tsara hẽéthẽé e Gam cgoa, cúí ba c'ẽe xòèa ba za, me c'ẽe ba c'ẽe xòèa ba za, Me Jeso ba nqáè koe téé. ");
INSERT INTO nhr_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Me kò Pilato x'áí sa góá hãa, a xgàus koe qáéa tòó sia; ncẽetas kòo ma nxáráse: “NASARETA DIM JESO BA, JUTA NE DIM X'AIGA BA,” ta ma ma. ");
INSERT INTO nhr_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ne kò káí ne Juta ne ncẽes x'áí sa nxárá, ẽem kò Jeso ba xgàuèam qgáì ba kò x'áé-dxoom ka cúù me e khama. Si kò x'áí sa Hebera dis kg'uis ka hẽé, Latini dis ka hẽé naka Gerika dis ka hẽéthẽé góáèa. ");
INSERT INTO nhr_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Xu kò nxãaska kaia xu peresiti xu Juta ne di xu Pilato ba bìrí a máá: “Táá góá naka máá: ‘Juta ne dim X'aiga ba,’ témé guu, igaba máá: ‘Ncẽem khóè ba kòo máá, Juta ne dim X'aiga Me e,’ témé,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Me Pilato xo̱a a máá: “Eẽr góá hãa sar góá hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Eẽ xu ko ncõo-kg'ao xu Jeso ba xgàu ka xu kò qgáía ba séè, a 4 zi dtcõò zi cgoa q'aa-q'aa a, si dtcõò sa khóèm di sa ii, me q'oo koe ko hã̱aèm qgáím cúí ba qaù. Ncẽem qgáí ba kò qgãé-dàò úú tama, a cúí xòè koe tc'amaka guu a nqãaka xõas koe qgãéèa. ");
INSERT INTO nhr_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Xu kò bìríku a máá: “Hààn xae táá tòà me guu, igaba hàà naka xae cgúúan ntcòo naka bóò dìína gha séè me sa,” témé. Ncẽe sa kò kúrúse, ẽe Nqarim dis Tcgãyas koe góáèas gha nxãasega nxàea tseegukaguè ka, ncẽe kòo máá: “Qgáía Te xu kò q'aa-q'aaku, a Tiri qgáían domka cgúúan ntcòo,” témé sa. Ncẽea ncõo-kg'ao xu kò hẽé ga a. ");
INSERT INTO nhr_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesom dis xgàus qàe koes kò xõò sa tẽe, naka Gam ka xõòs ka qõese sa hẽé, Marias ncẽe Kelopasem dis khóè sa, naka Maria Magatalena sa hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Eẽm ko Jeso ba xõò sa ẽe koe bóò, naka xgaa-xgaase-kg'aom ẽem kò ncàm̀a hãa ba hẽéthẽé e me qàea sa koe tẽe, kam kò xõò sa bìrí a máá: “Khóè seè, sarim cóám ga me e ncẽe ba!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A ba a xgaa-xgaase-kg'ao ba bìrí a máá: “Bóò, saòs ga si i ncẽe sa,” témé. Me kò xgaa-xgaase-kg'ao ba ẽem x'aèm koe guu a séè a x'áéa ba koe úú si. ");
INSERT INTO nhr_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wèé gúùa nea xg'ara hãa sa q'ana hãasem kò Jeso ba ncẽes gúùs qãá q'oo koe máá: “Cáḿa raa!” témé. Ncẽes gúù sa kò kúrúse, Nqarim di zi Tcgãya zi gha nxãasega nxàea tseegukaguè ka. ");
INSERT INTO nhr_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Si kò tsa̱u tshàan ka cg'oèa hãas gàba sa hãa, khama xu kò tsa̱u tshàan ka cg'oèa hãas x'úrú sa tcììka-tcamkuan dim hìim koe tòó, a ghùi a kg'áḿa ba koe úú. ");
INSERT INTO nhr_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Eẽm ko Jeso ba tsa̱u tshàan kg'áà xg'ara kam kò máá: “Xg'ara-xg'araèa ia!” témé. A ba a tcúúa ba qám̀, a sónòa tcg'òó. ");
INSERT INTO nhr_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kg'ónòsean dim cáḿ me e kò ii, me kò q'uu dim cáḿ ba cgáém cáḿ Sabata di me e. Ne kò Juta ne Sabata dim cáḿ ka i gha tc'áróan xgàuan koe tceesea téé sa tc'ẽe tama, khama ne kò Pilato ba dtcàrà c'õán gha khõáè, i tc'áróan xòóè sa. ");
INSERT INTO nhr_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xu kò nxãaska ncõo-kg'ao xu hàà, a hàà tc'ãà dim khóèm di c'õán khõá, ncẽe kò Jesom cgoa xgàuèa ba, naka c'ẽem dian hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Igaba ẽe xu ko Jesom koe hàà, ka xu kò sao-xg'ae Mem nxãakamaga x'óóa hãa, xu kò táá c'õáa ba khõá. ");
INSERT INTO nhr_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Igabam kò ncõo-kg'ao xu ka c'ẽe ba Jeso ba kg'áó-xgàom cgoa gáò dxàbè, i kúúga qháése c'áòan hẽé naka tshàan hẽéthẽé gaa koe guu a ntcã̱a. ");
INSERT INTO nhr_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Khóèm ẽe kò bóò o ba kò nxàea tseegukagu u, si gam dis nxàea tseegukagu sa tseegu si i. Me q'anaa, tseegu sam ko nxàe sa, a ba a ko nxàea tcg'òó o, gatu igaba tu gha thẽé nxãasega dtcòm̀ ka.) ");
INSERT INTO nhr_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ncẽe zi gúù zia kò kúrúse, ẽe Nqarim dis Tcgãyas koe góáèas gha nxãasega nxàea tseegukaguè ka, ncẽe kòo máá: “C'õáa ba ka cúían ga khõáè tite,” ta méé sa. ");
INSERT INTO nhr_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Si ko c'ẽes Tcgãyas Nqarim di sa gataga máá: “Bóò xu gha gaam ẽe xu gáòa hãa ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ncẽe zi gúù zi qãá q'oo koem kò Josefam Arimatea di ba, ncẽe kò Jesom di xgaa-xgaase-kg'ao ii ba, Jesom dim tc'áró ba xàìa hãase Pilatom koe dtcàrà, Juta nem kòo q'áò khama. Me kò Pilato ba kgoara máá me me. Me hàà a Gam dim tc'áró ba séè. ");
INSERT INTO nhr_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemasem ncẽe kò kg'aia Jeso ba ntcùú ka dàraa hãa ba kò hãa cgoa mea. Nikodemase ba kò tshãán hẽé, naka tcgáùse di nxúìan hẽéthẽé óá, 30 qóḿ-q'ooan khama noo o. ");
INSERT INTO nhr_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jesom dim tc'áró ba tsara kò séè, a tsara a tshãán cgoa xg'ae-xg'ae a q'úú qgáí cgoa kúrúèa ko̱àn cgoa tcáḿ me. Ncẽe sa kò caus Juta ne ko ma kg'aiga kg'ónòkus ga si i. ");
INSERT INTO nhr_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Eẽm kò Jeso ba xgàuèa hãam qgáìm koem kò xhárà ba hãa, me kò ka̱bam ha̱ém tc'ám̀s di ba xháràm q'oo koe hãa, ncẽe cúí khóè ga qanega gam koe kg'ónòè tama ba. ");
INSERT INTO nhr_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juta ne dim cáḿ kg'ónòsean di me e kò ii, si kò tc'ám̀ sa cúù si i, khama ne kò Jeso ba gas koe ga kg'ónò. ");
INSERT INTO nhr_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tc'ãà dim cáḿ bekem dim di ntcùúkg'ai cgoa, qanega i ntcùú u koes kò Maria Magatalena sa tc'ám̀s koe hàà, a hàà nxõ̱á sa bóò si tc'ám̀s-kg'áḿ koe ghànèa tcg'òóèa. ");
INSERT INTO nhr_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Si ko Simonem Peterem koe hẽé naka c'ẽem xgaa-xgaase-kg'aom koe hẽéthẽé qgóéa síí, ncẽe kò Jesom ka ncàm̀mèa ba, a síí bìrí tsara a a máá: “X'aiga ba xu tc'ám̀s koe séèa tcg'òóa hãa, ta c'úùa hãa nda koe xu úú Mea hãa sa!” tas méé. ");
INSERT INTO nhr_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Me kò nxãaska Petere gaam xgaa-xgaase-kg'aom cgoa xgoaba, tsara tc'ám̀s koe qõò. ");
INSERT INTO nhr_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Wèéa tsara ga kòo qàrò, igabam kò gaam xgaa-xgaase-kg'ao ba Petere ba qgóéa guu, a tc'ám̀s koe tc'ãà a síí. ");
INSERT INTO nhr_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Téém ko a qám̀se a xhõo a bóò kam kò q'úú qgáí cgoa kúrúèa ko̱àn cúí ga bóò i gaa koe hãa, igabam kò táá q'oo koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Me kò nxãaska Simonem Petere ba kháóka xùri me a hàà, a hàà tc'ám̀s koe tcãà; a q'úú qgáìan cgoa kúrúèa ko̱àn bóò i gaa koe xõe, ");
INSERT INTO nhr_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","naka kg'ónò cgoa dim qgáím ncẽe kò Jesom tcúú koe hãa ba hẽéthẽé e. Qgáí ba kò ko̱àn cgoa hãa tama a kò cúíaga qabesea ntcõe. ");
INSERT INTO nhr_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Me kò nxãaska gaam xgaa-xgaase-kg'aom, ẽe kò tc'ám̀s koe tc'ãà a síí ba, q'oo koe tcãà thẽé, a bóò, a dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Qanega tsara kò Nqarim dis Tcgãya sa kóḿa q'ãa tama, Jeso ba méém x'ooan koe tẽès gúù si i ta kòo méé sa. ");
INSERT INTO nhr_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsara kò nxãaska xgaa-xgaase-kg'ao tsara x'áé koe ka̱bise a dìbi. ");
INSERT INTO nhr_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Igabas kò Maria sa tc'ám̀s ka tchàa koe téé a ko kg'ae. Eẽs hãa a ko qanega kg'ae kas kò qám̀se a tc'ám̀s q'oo koe xhõo a bóò, ");
INSERT INTO nhr_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","a sa a cám̀ moengele tsara q'úúse ha̱na tsara bóò, tsara Jesom dim tc'áróm kò xõe koe ntcõóa-ntcõe, c'ẽe ba kò tcúúa ba kò hãa koe ntcõe, me c'ẽe ba nqàrèa ba kò hãa koe ntcõóa-ntcõe. ");
INSERT INTO nhr_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tsara tẽè si a máá: “Khóè seè, dùús domka si ko kg'ae?” témé. Si máá: “Tirim X'aiga ba xu tcg'òóa hãa, ra c'úùa hãa nda xu úú Mea sa!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ncẽetas ko méé kas kò ka̱bise a Jeso ba bóò Me tééa-tẽe, igabas kò Jeso Me e sa táá bóòa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Me Jeso ba bìrí si a máá: “Khóè seè, dùús domka si ko kg'ae? Dìí ba si ko qaa?” témé. Xhárà-kg'ao Me e, tas kò tc'ẽea hãa khamas kò bìrí Me a máá: “Aboè, ncẽè tsáá ga tsi kò séè Mea hãa ne bìrí te nda koe tsi xòó Mea hãa sa, nakar séè Me,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Me Jeso ba bìrí si a máá: “Mariaè!” témé. Si tééa ka̱bise a q'óá-kg'ai Me, a Hebera dis kg'uis ka máá: “Raboni!” témé. (Ncẽe sa ko máá: ‘Xgaa-xgaa-kg'ao Tseè,’ témé.) ");
INSERT INTO nhr_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Me Jeso ba bìrí si a máá: “Táá qgóó Te guu, qanega Ra Abom koe ka̱bise ta ga hãa ke. Igaba méé si Tíí qõe ga xu koe qõò naka síí bìrí xu naka máá: ‘Ka̱biser ko Tirim Abom koe, gaxao dim Abo ba; a Tirim Nqari ba, gaxao dim Nqari ba,’” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Si kò Maria Magatalena sa xgaa-xgaase-kg'ao xu koe qõò a síí bìrí xu a máá: “X'aiga bar bóòa hãa!” témé. A sa a bìrí xu ncẽe zi gúù zim bìrí sia sa. ");
INSERT INTO nhr_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tc'ãà dim cáḿ bekem dim di dqòan ka xu kò xgaa-xgaase-kg'ao xu xg'aea hãa, i kò Juta ne di bèean ka nquu-kg'áḿan qarika tcẽekg'ammèa. Kam kò Jeso ba hàà xg'aekua xu koe téé a ba a bìrí xu a máá: “Tòókuan méé i gaxao cgoa hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Eẽm ko ncẽe sa mééa xg'ara kam kò tshàua ba hẽé naka xòèa ba hẽéthẽé x'áí xu. Eẽ xu kò xgaa-xgaase-kg'ao xu X'aiga ba bóò ka xu kò qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Me gaicara Jeso ba bìrí xu a máá: “Tòókuan méé i gaxao cgoa hãa! Ncẽem ma Abo ba ma tsééa óá Tea khamaga Ra ko ma tsééa úú xao o ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Eẽtam ko mééa xg'ara kam kò dqòm̀a tcãà cgae xu u, a máá: “Tcom-tcomsam Tc'ẽe bar ko máà xao o. ");
INSERT INTO nhr_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ncẽè c'ẽe khóèan xao kòo gaan di chìbian qgóóa máá ne i qgóóa mááèa, a ncẽè qgóóa máá a tama xao kò hãa, ne i qgóóa mááè tite,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nxãaskam kò Tomasem (ncẽe Didimo ta kòo ma tciièm) 12 xu ka c'ẽe ba gaxu cgoa hãa tama, ẽem kò Jeso hààraa ka. ");
INSERT INTO nhr_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Khama xu kò c'ẽe xu xgaa-xgaase-kg'ao xu bìrí me a máá: “Ncãa xae X'aiga ba bóò!” témé. Igabam kò bìrí xu a máá: “Cgabìan di xg'ama ner kòo tshàua ba koe bóò tama, a tshàua te gaa xg'aman koe tcãà tama, naka tshàua te xòèa ba koe tcãà tama ner cuiskaga dtcòm̀a hãa tite,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Bekem qãá q'oo koe xu kò Gam di xu xgaa-xgaase-kg'ao xu nquum koe gaicara xg'aea hãa, me kò Tomase ba hãa cgoa xua. Nquu-kg'áḿ ne kò tcẽekg'amsea hãa, igabam kò Jeso ba gaxu xg'aeku koe hàà téé, a máá: “Tòókuan méé i gaxao cgoa hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","A nxãaska Tomase ba bìrí a máá: “Tshàua tsi ncẽe koe tcãà, naka tsia tshàua Te bóò. Tchoanà tshàua tsi naka xòèa Te koe tcãà a. Káíse tc'ẽe-tc'ẽesean cgoa q'aa naka dtcòm̀,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Me Tomase xo̱a Me a máá: “Tiri Tsi X'aiga Tseè, a tiri Tsi Nqari Tseè!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Me nxãaska Jeso ba bìrí me a máá: “Ncẽe tsi ncãa bóò Te ka tsia ko dtcòm̀? Eẽ bóò tama igaba ko dtcòm̀ nea ts'ee-ts'eekg'aièa!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeso ba kò Gam di xu xgaa-xgaase-kg'ao xu cookg'ai koe káí zi x'áí zi c'ẽe zi kúrú, ncẽes tcgãyas koe góáse tama zi, ");
INSERT INTO nhr_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","igaba i ncẽean góáèa hãa, nxãasega tu gha dtcòm̀, Jeso ba Krestem Nqarim dim Cóá Me e sa ka, a tu a gha dtcòm̀an ka Gam dim cg'õèm koe kg'õèan úú ka. ");
INSERT INTO nhr_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ncẽe zi gúù zi qãá q'oo koem kò Jeso ba gaicara Gam di xu xgaa-xgaase-kg'ao xu koe x'áíse, Tiberia dim tshàam koe. Ncẽetam ma x'áísea. ");
INSERT INTO nhr_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simonem Petere ba hẽé, naka Tomase ba hẽé (ncẽe kò Didimo ta ma tciiè ba), naka Nataniele ba hẽé, ncẽe kò Kana koe guua ba, Galilea di i, naka Sebetem di tsara cóá tsara hẽé, naka xgaa-xgaase-kg'ao tsara c'ẽe tsara hẽéthẽé xua kò xg'aea hãa. ");
INSERT INTO nhr_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simonem Petere ba kò c'ẽe xu bìrí a máá: “Qõòr ko a síí x'aùan qgóó,” témé. Xu máá: “Qõò cgoa tsi xae gha,” témé. Xu tcg'oa a xu a síí dxòrom koe q'ábà, igaba xu kò ẽem ntcùúm ka táá cúí gúù ga qgóó. ");
INSERT INTO nhr_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kaisa ntcùúkg'ai cgoam kò Jeso ba tshàam-kg'áḿ koe téé-tẽe, igaba xu kò xgaa-xgaase-kg'ao xu táá Jeso Me e sa bóòa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Me Jeso ba tcii xu a máá: “Cóá xaoè, cúí x'aù ga xao gáé hòò tama?” témé. Xu xo̱a Me a máá: “Eẽ-ẽe!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Me bìrí xu a máá: “Gaxao dis c'uisí sa kg'áò xòèan dxòrom di koe xaoa tcãà, c'ẽe gúù xao gha hòò ke,” témé. Xu xaoa tcãà si, a xu a dxòrom q'oo koe tcéèa tcãà sa ka tààè, x'aùan di káí-q'ooan ka. ");
INSERT INTO nhr_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Me kò nxãaska xgaa-xgaase-kg'aom ẽe Jesom kò ncàm̀a hãa ba Petere ba bìrí a máá: “X'aiga Me e!” témé. Eẽm ko Simonem Petere ba kóḿ X'aiga Me e sa kam kò gam di qgáían hã̱a (tséé sam kò nxõ̱òa máá ana hãa khama), a ba a tshàan q'oo koe nxàìa tcãà. ");
INSERT INTO nhr_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Igaba xu kò c'ẽe xu xgaa-xgaase-kg'ao xu dxòrom cgoa tshàam tsa̱m-tsáó koe síí, x'aùan ka cg'oèa hãas c'uisí sa tcéè a. Nqõómkg'ai ka xu kò nqúù tama, 100 khama noo zi náà-q'oo zi cúí zi kò qaùa hãa. ");
INSERT INTO nhr_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Eẽ xu ko nqõómkg'ai koe hàà ka xu kò gaa koe bóò si c'ee sa dxùúsea hãa, a x'aùan úúa hãa naka péréan hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Me kò Jeso ba bìrí xu a máá: “C'ẽe x'aùan ẽe xao ncãa qgóó xao óá,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Me kò Simone Petere ba q'ábà, a c'uisís x'aùan ka kò cg'oèa sa tcéèa tcg'òó, 153 i kò ii. Káí i kò ii igabas kò c'uisí sa táá tòà. ");
INSERT INTO nhr_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Me Jeso ba bìrí xu a máá: “Hàà xao naka hàà tc'õó,” témé. Nxãaska i kò xgaa-xgaase-kg'aoan kgoarase tama, tẽè Me i gha a máá: “Dìí Tsia?” témé ka. X'aiga Me e sa xu kò q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Me Jeso ba hàà, a hàà péréan séè, a máà xu. A ba a gataga hẽé x'aùan ka. ");
INSERT INTO nhr_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ncẽea kò nqoana dim x'aèm ga me e, ncẽem kò Jeso ba Gam di xu xgaa-xgaase-kg'ao xu koe x'áíse ba, ẽem kò x'ooan koe ghùièa ka. ");
INSERT INTO nhr_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Eẽ xu ko tc'õóa xg'ara kam kò Jeso ba Simonem Petere ba bìrí a máá: “Simoneè, Johanem di tsi cóá tseè, ncẽe xu khóè xu ka tsia ncàm̀ Tea?” témé. Me bìrí Me a máá: “Eè, X'aigaè, ncàm̀ Tsia raa sa Tsi q'ana,” témé. Me Jeso ba bìrí me a máá: “Tiri ghùu-coan dxòókagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Me kò gaicara Jeso ba bìrí me a máá: “Simoneè, Johanem di tsi cóá tseè, ncàm̀ Tea tsia?” témé. Me bìrí Me a máá: “Eè, X'aigaè, ncàm̀ Tsia raa sa Tsi q'ana,” témé. Me Jeso ba máá: “Tiri ghùuan kòre,” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nqoana dis kam kò Jeso ba bìrí me a máá: “Simoneè, Johanem di tsi cóá tseè, ncàm̀ Tea tsia?” témé. Petere ba kò tshúù-tcao, Jeso ba kò nqoana q'oro tẽè me a máá: “Ncàm̀ Tea tsia?” témé khama, kam kò máá: “X'aigaè, wèé zi gúù zi Tsi q'ana; ncàm̀ Tsia raa sa Tsi q'ana!” témé. Me Jeso ba máá: “Tiri ghùuan dxòókagu. ");
INSERT INTO nhr_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tseegukar ko tseeguan bìrí tsi a ko máá: Eẽ tsi xg'ao cg'áré ii ka tsi xg'ao ko hã̱akaguse, a ko kg'ama tẽe a qõò ẽe tsi ko tc'ẽe koe. Igaba ncẽe tsi kaia hãa ka tsi gha tshàua tsi tchoanà, me gha c'ẽem khóè ba hã̱akagu tsi, a ba a ẽe tsi tc'ẽe tama koe úú tsi,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Ncẽeta mééan kam kò Jeso ba Peterem gha hàà x'óóm dàò ba nxàe, a ba a Nqari ba x'áàkagu.) Kam kò nxãaska bìrí me a máá: “Xùri Te!” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petere ba kò ntcẽè, a c'ẽem xgaa-xgaase-kg'aom Jesom kò ncàm̀a hãa ba qãáa ba koe bóò, me ko xùri tsara a. (Ncẽe ba gam ẽe kò dqòa di tc'õoan koe, Jesom koe ghãase ntcõem ga me e, ncẽe kò tẽè Me a ko máá: “X'aigaè, dìína ko hàà khóè ne tshàu q'oo koe tcãà Tsi?” témé ba.) ");
INSERT INTO nhr_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Eẽm ko Petere bóò me, kam kò Jeso ba tẽè a máá: “X'aigaè, kháé gam ka ntamaà?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Me Jeso ba xo̱a me a máá: “Kg'õèasem gha hãa, Ra nxãakg'aiga síí ka̱bise sar kòo tc'ẽe ne i ko nxãan tsáá koe dùú sa nxàe? Tsáá méé tsi xùri Te,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Si kò ncẽes tchõà sa khóè qõeku xu koe qòàrase, ncẽem xgaa-xgaase-kg'ao ba x'óó tite di sa. Igabam kò Jeso ba máá, x'óóm tite, témé tama, kg'amam kòo máá: “Kg'õèasem gha hãa, Ra nxãakg'aiga síí ka̱bise sar kòo tc'ẽe ne i ko nxãan tsáá koe dùú sa nxàe?” témé. ");
INSERT INTO nhr_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ncẽem xgaa-xgaase-kg'ao ba gam ncẽe zi gúù zi kò nxàea tseegukaguam ga me e, a kò góá zi ba. Ta q'ana hãa gam dis nxàea tseegukagu sa tseegu si i sa. ");
INSERT INTO nhr_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jeso ba kò gataga thẽé c'ẽe zi gúù zi káí zi kúrú. Ncẽè wèéa zi ga kò cúí-cúí góáèa hãa nem ga kò, bóòr ko ka, nqõóm ga ba kgoana naka wèé zi tcgãya zi ncẽe zi qgóó tama, ẽe ga kò góáèa hãa zi. ");
INSERT INTO nhr_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilaè, tc'ãà dis tcgãyas tiris q'oo koer kò wèé zi gúù zi ncẽem kò ko Jeso ba tshoa-tshoa a kúrú a xgaa-xgaa zi ka góáa hãa. ");
INSERT INTO nhr_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Me nxãakg'aiga nqarikg'ai koem ko séè a úúèm cáḿ ba síí tcãà, ẽem kòo Tcom-tcomsam Tc'ẽem di qarian ka ẽem nxárá tcg'òóa hãa xu x'áè úú-kg'ao xu x'áèan máà ka. ");
INSERT INTO nhr_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","A ba a kò ẽem ko xgàrasea xg'ara ka, gaxu koe káí zi dàò zi cgoa x'áíse, kg'õèam hãa sa. 40 cáḿa nem kò x'áíse xu, a ko Nqarim di x'aian di zi gúù zi ka kg'ui cgoa xu. ");
INSERT INTO nhr_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","A kò ẽem hãa a ko tc'õó cgoa xu ka ncẽe x'áèan máà xu a máá: “Táá méé xao Jerusalema koe tcg'oa guu, igaba méé xao kg'aia Abom nqòòkagua hãa sa qãà, ncẽe xao Tíí koe kóḿa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Johane ba kòo tshàan cgoa tcguù-tcguu, igaba tu gha gatu cg'orò cáḿan qãá q'oo koe hàà Tcom-tcomsam Tc'ẽem cgoa tcguù-tcguuè,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Khama ẽe xu ko xg'ae cgoa Me ka xu kò tẽè Me a máá: “X'aigaè, ncẽem x'aèm ka Tsia gáé ga táá Iseraele ne gane di x'aian ka̱bia máá?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Me Jeso ba bìrí xu a máá: “Ncẽem Abo ba Gam di qarian ka tòóa x'aèan hẽé naka cáḿan hẽéthẽé xao gha q'ãa sa gaxao di tama. ");
INSERT INTO nhr_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Igaba ẽem ko Tcom-tcomsam Tc'ẽe ba hàà cgae xao o ka xao gha qarian hòò, a xao a gha Tiri xao nxàea tseegukagu-kg'ao xao ii: Jerusalema koe hẽé, naka wèém xg'aekum Jutea dim koe hẽé, naka Samaria dim xg'aekum koe hẽé, naka nqõóm chõò-q'oo koe ga hẽéthẽé e,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ncẽetam ko mééa xg'ara kam kò téé a xu a ko bóò Me koe ga séè a nqarikg'ai koe qaòkaguè, si túú-c'õò sa tcgáí-q'ooa xu koe ga qàbia tcãà Me. ");
INSERT INTO nhr_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eẽ xu nqarikg'ai koe tcgáía xu qãea tòóa, ẽem ko ma qõò khama ma, ka tsara ko kúúga q'úúse ha̱na tsara khóè tsara hàà qàea xu koe téé, ");
INSERT INTO nhr_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a tsara a máá: “Galilea di xao khóè xaoè, dùús domka xao ncẽe koe téé-tẽe a téé a ko nqarikg'ai koe bóò? Jesom ncẽe gaxao koe séè a nqarikg'ai koe úúèa hãa ba gha gaam dàòm ncẽe xao bóò Mem ko qõòm cgoa ga ka̱bise a hàà,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ka xu ko nxãaska x'áè úú-kg'ao xu Olife ta ko ma tciièm xàbìm koe guu a Jerusalema koe ka̱bise. Xàbìm ncẽe ba kò Jerusalema ka cúù me e, Sabata dim cáḿ ka tsi ko kgoara mááè a síí cgae me khama noo qáò-q'ooa ne. ");
INSERT INTO nhr_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Eẽ xu ko Jerusalema koe tcãà ka xu kò tc'amaka hãam nquum koe síí, ncẽe xu kò gaa koe cg'orò cáḿan hãa ba: Petere ba hẽé, naka Johane ba hẽé, naka Jakobo ba hẽé, naka Anterea ba hẽé, naka Filipi ba hẽé, naka Tomase ba hẽé, naka Baretolomaio ba hẽé, naka Mataio ba hẽé, naka Jakobom Alefaiom ka cóáse ba hẽé, naka Simonem ncẽe kòo tòókuan x'ãà máá ba hẽé, naka Jutasem Jakobom ka cóáse ba hẽéthẽé xu u kò ii. ");
INSERT INTO nhr_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Wèéa xu ncẽe xua kò khóè zi hẽé, naka Marias Jesom ka xõò sa hẽé, naka Gam ka qõese ga xu hẽéthẽé cgoa xg'ae a tcãà tcáó a cúím tc'ẽem cgoa còrè. ");
INSERT INTO nhr_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Si kò khóè ne dis xg'ae sa 120 khama noo. Me kò ẽe xu cáḿ xu ka Petere ba tẽe a qõese ga xu xg'aeku koe téé a ba a máá: ");
INSERT INTO nhr_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Tíí qõe ga xaoè, ncẽes gúùs Nqarim dis Tcgãyas koe góásea hãa sa méés tseegukaguè, ncẽem kòo Tcom-tcomsam Tc'ẽe ba Dafitem kg'áḿ koe guu a Jutasem ka kg'ui sa, gaam ncẽe Jeso ba kò hàà qgóó xu khóè xu dim tc'ãà-cookg'ai kò ii ba. ");
INSERT INTO nhr_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jutase ba kò sixae ka c'ẽe me e, a kò sixae cgoam gha cúís tséé sa kúrú ka nxárá tcg'òóèa hãa. ");
INSERT INTO nhr_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Eẽm ko Jutase cg'ãè cauan kúrú kam kò ẽem kò suruta cgoaè marian cgoa xhárà ba x'ámá. Ncẽem kò gaam koe cg'áé a x'óó, a q'arase nqáè, i wèé q'oo gúùa ba tcg'oa ba. ");
INSERT INTO nhr_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ne kò wèé ne khóè ne ẽe kò Jerusalema koe x'ãèa hãa ne gaas gúù sa q'ãa, me gaa domkaga gaam xhárà ba gane dis kg'uis ka kò Akele-dama ta ma tciiè. Ncẽe sa ko máá, ‘Xháràm c'áòan di ba,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pesalema zi dis Tcgãyas koe i góásea hãa khama a ko máá: ‘Gam di x'áéan méé i nqoo-nqoosam qgáì ba ii, naka i táá cúí khóè ga gaa koe x'ãè guu,’ téméè, a i a ko gaicara máá: ‘C'ẽem khóè ba méém gam di téé-q'ooan máàè,’ téméè. ");
INSERT INTO nhr_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Gaa domkagam kò c'ẽem khóè ba qaase, ncẽe kò sixae cgoa wèé x'aè ka hãa, ẽem kò ko X'aigam Jeso ba qõòa te cgoa xae e ka ba, ");
INSERT INTO nhr_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Johanem di tcguù-tcguukuan dim x'aèm koe guu a tshoa-tshoa, a síí Jesom kò sixae koe guu a séè a nqarikg'ai koe úúèm x'aèm koe tcãàn koe. Ncẽe xu khóè xu ka c'ẽe ba méém sixae cgoa hàà nxàea tseegukagu-kg'ao ba ii, Jesom x'ooan koe tẽea hãa di ba,” tam Petere méé. ");
INSERT INTO nhr_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xu kò cám̀ khóè tsara nxárá tcg'òó, Josefam ncẽe kòo Barenabase ta ma tciiè ba, ncẽe kò Juseto dis cg'õès ka q'ãaèa hãa ba hẽé, naka Matiase ba hẽéthẽé tsara. ");
INSERT INTO nhr_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ne kò nxãaska còrè a máá: “X'aigaè, ncẽe wèé khóèan di tcáóan q'ana hãa Tseè, x'áí ta a xg'aekua tsara koe Tsi ndaka ba nxárá tcg'òóa máásea hãa sa, ");
INSERT INTO nhr_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","nakam ncẽe tsééan koe tcãà, x'áè úú-kg'ao di i, ncẽem kò Jutase aagua a, a ba a ẽem ko qaam qgáìm koe qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","A ne a kò cgúúan xg'áḿ, i cgúúan Matiase ba nxáá, me 11 xu x'áè úú-kg'ao xu koe tcãàè. ");
INSERT INTO nhr_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Eẽm ko Pentekoste dim cáḿ ba hàà, ka ne kò wèéa ne ga cúím qgáìm koe xg'aea hãa. ");
INSERT INTO nhr_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Me kò kúúga tcẽé-tcẽe ba nqarikg'ai koe guu a tc'irìa ne hãa koe hàà, kaiam tc'ãám di ts'oo-q'ooan khama xam̀ ba, a hàà ẽe ne ko hãam nquum koe cg'oè. ");
INSERT INTO nhr_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","I kò c'eean di ta̱man khama ii gúùan hòòse, a tsa̱i-tsa̱ia q'aase, a gane koe ntcõó. ");
INSERT INTO nhr_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ne wèéa ne ga Tcom-tcomsam Tc'ẽem ka cg'oè cgaeè, a ne a tshoa-tshoa a tãáka zi ta̱m zi kg'ui, ẽem kò Tc'ẽe ba ma máà nea khama. ");
INSERT INTO nhr_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nxãaska ne kò Nqari-tcáóa ne Juta ne Jerusalema koe x'ãèa hãa, wèé zi qhàò zi nqarikg'ai ka nqãaka hãa zi di ne. ");
INSERT INTO nhr_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eẽ ne ko ncẽes tcẽé-tcẽe sa kóḿ, ka ne kò káí ne khóè ne hààra xg'ae, wèém khóè ba ne kò kóḿ me ko gam di ta̱man kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ne kò are, a xháé, a ne a máá: “Kháé ncẽe ko kg'ui ne khóè ne wèé ne gáé Galilea di ne tama nea? ");
INSERT INTO nhr_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ka ta koáé dùús domka kháé kóḿ ne ne ko sita dis kg'ui sa kg'ui, ncẽe ta ábà cgoaèa hãa sa? ");
INSERT INTO nhr_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Paretia ta hẽé, naka Mede ta hẽé, naka Elame ta hẽé, naka Mesopotamia koe x'ãèa hãa ta hẽé, naka Jutea di ta hẽé, naka Kapatokia di ta hẽé, naka Ponto di ta hẽé, naka Asia di ta hẽé, ");
INSERT INTO nhr_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","naka Ferugia di ta hẽé, naka Pamfilia di ta hẽé, naka Egepeto di ta hẽé, naka Libia di c'ẽe xòè di ta hẽé, Kurene ta ko ma tciièm x'áém qàe koe hàna a, Roma koe guua ta cg'áè-kg'ao ta hẽé, ");
INSERT INTO nhr_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Juta ta hẽé, naka Juta khama kúrúsea ta hẽé, naka Kereta ta hẽé, naka Arabia ta hẽéthẽé e - wèéa ta ga ko kóḿ ne ne ko are-aresa tsééan Nqarim di sita di ta̱man cgoa kg'ui,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ne kò wèéa ne ga kaisase are a q'ãa tama khama ne kò tẽèku a máá: “Dùú sa ko nxàes gúù sa gáé ncẽe sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Igaba ne kò c'ẽe ne nco̱i ne a máá: “Káí gõéa ne ne kg'áà hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Igabam kò Petere 11 xu cgoa téé-tẽe, a ba a khóè ne cgoa kaisase tc'amaka kg'ui a máá: “Gaxao khóè xao Jutea di xao hẽé, naka gatu wèé tu ncẽe Jerusalema koe x'ãèa tu hẽéthẽé méé tu komsana te, nakar bìrí tu u, ncẽes gúùs ko dùú sa nxàe sa. ");
INSERT INTO nhr_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ncẽe ne khóè nea nqàre tama, ẽe tu ma tc'ẽea khama, qanega i 9 di x'aè e ntcùúkg'ai cgoa di i khama. ");
INSERT INTO nhr_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Igabas ko ncẽes gúù sa porofitim Joelem ka nxàeèas ga si i, ncẽem kò Nqari ba máá: ");
INSERT INTO nhr_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Còo di xu cáḿ xu kar gha Tíí Nqari Ra wèém khóèm koe Tirim Tc'ẽe ba ntcã̱a. Xu gha gatu di xu cóá xu hẽé naka cóá zi hẽéthẽé porofita, xu gha gatu di xu qárí-kg'ao xu x'áí zi bóò, xu gha gatu di xu xõòkhoe xu gataga sõokuri zi sõokuri. ");
INSERT INTO nhr_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Tiri qãàn koe ga igaba, kg'áòan hẽé naka dxàean hẽéthẽé koer gha ẽe xu cáḿ xu ka Tirim Tc'ẽe ba ntcã̱a, ne gha porofita. ");
INSERT INTO nhr_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Are-aresa zi gúù zir gha tc'amaka x'áí, nqarikg'ai koe, a Ra a gha are-aresa zi x'áí zi nqãaka x'áí, nqõómkg'ai koe, c'áòan hẽé naka c'eean hẽé naka ts'énèan hẽéthẽé di zi. ");
INSERT INTO nhr_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Cáḿ sa gha ntcùú sa kúrú, me gha nxoe ba c'áòan khama ii, Nqarim dim cáḿ hàà tamas cookg'ai koe, ncẽe kaia hãa a ko x'áàm cáḿ ba. ");
INSERT INTO nhr_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Me gha wèém ẽe ko X'aigam Nqarim dim cg'õè ba tcii ba kgoaraè,’ tam Joele mééa. ");
INSERT INTO nhr_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Gaxao khóè xao Iseraele di xaoè, ncẽe kg'uian xao komsana: Jesom Nasareta di ba kò Khóèm Nqarim ka xao nxárá tcg'òóa mááèa hãa Me e; qarian di zi tséé zi hẽé, naka are-aresa zi x'áí zi hẽéthẽém kò Nqari ba Jesom koe guu a gaxao xg'aeku koe kúrú, ncẽe xao ma q'ana khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nqari ba kò nxãakamaga kàa sa úúa hãa, a ba a bóòa tcg'òóa hãase kò Jeso ba tshàu q'ooa xao koe tcãà, xao kò cg'õo Me, cg'ãè cau xu khóè xu máà xu xgàus koe tceea ba ka. ");
INSERT INTO nhr_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Igabam kò Nqari ba x'ooan koe ghùi Me, a ba a x'ooan di thõòan koe kgoara Me, x'ooa nea qgóó Me i gha di qarian úú tama khama. ");
INSERT INTO nhr_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Me kò Dafite ba Gam ka kg'ui a máá: ‘X'aigam Nqari bar kò wèé x'aè ka cookg'aia te koe bóò. Tirim x'õàm kg'áòm xòè zam hàna khamar cuiskaga ntcãà-ntcãaèa hãa tite. ");
INSERT INTO nhr_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Gaa domka i tcáóa te qãè-tcaoa; i ta̱ma te thẽé qãè-tcaoa, me gha tirim tc'áróm ga ba thẽé gataga nqòòan koe kg'õè. ");
INSERT INTO nhr_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Cuiskaga Tsi tc'ẽea te x'óóa ne khóè ne dim qgáìm koe aagua hãa tite, kana Tsi gataga cuiskaga Tsarim Tcom-tcomsa ba guu nakam ts'óóa hãa tite khama. ");
INSERT INTO nhr_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kg'õèan koe ko úú te dàòan Tsi x'áí tea hãa; a Tsi a gha hàna Tsi ko hãa ne qãè-tcaoan ka cg'oè-cg'oe te,’ tam Dafite ba mééa. ");
INSERT INTO nhr_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Tíí kíí ga xaoè, kgoarasea hãaser gha gaxae ka tsgõosem Dafitem ka bìrí xao o, x'óóam hãa a kg'ónòèa hãa sa, si gam dis tc'ám̀ sa ncẽe cáḿ ka igaba qanega gatá xg'aeku koe hãa. ");
INSERT INTO nhr_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Porofiti me e kò ii, a q'ana hãa Nqarim ma nqòòkagu mea hãa sa, a máá, gam di x'aian dis ntcõó-q'oos koem gha gam dim qhàò ba ntcòó, téméa sa. ");
INSERT INTO nhr_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Còokam kò bóòa hãa, a kò gaa domka Krestem di x'ooan koe tẽean ka kg'ui, a máá, Kreste ba kò x'óóa ne khóè ne dim qgáìm koe táá aaguè, i kò gataga cgàaa ba táá ts'óó, témé. ");
INSERT INTO nhr_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ncẽem Jeso bam kò Nqari ba x'ooan koe ghùia hãa, ta sita wèéa ta ga gaan di ta nxàea tseegukagu-kg'ao ta a. ");
INSERT INTO nhr_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Eẽm ko Jeso ba tc'amaka dis ntcõó-q'oos Nqarim dim x'õàm kg'áò xòè dim dis koe ghùi a úúè, kam kò nqòòkaguèam Tcom-tcomsam Tc'ẽe ba Xõòm koe hòò, a ba a kò wèés gúùs ncẽe tu ko bóò a ko kóḿ sa ntcã̱a xòó. ");
INSERT INTO nhr_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Dafite ba kò nqarikg'ai koe qaò tama khama, igabam kò máá: ‘X'aiga ba kò Tirim X'aiga ba bìrí a máá: ‘Kg'áò x'õàa Te xòè koe ntcõó, ");
INSERT INTO nhr_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","nakar gha nxãakg'aiga síí Tsari cg'õo-kg'aoan kúrú naka i nqàrèa Tsi ka nqãaka hãa,’ ’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Gaa domka méé ne wèé ne Iseraele ne ncẽe sa qãèse q'ãa: ncẽe tu kò xgàum Jeso bam Nqari ba X'aiga ba hẽé naka Kreste ba hẽéthẽé kúrúa,” tam Petere méé. ");
INSERT INTO nhr_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Eẽ ne ko khóè ne ncẽe sa kóḿ ka i kò tcáóa ne qhòmse, ne Petere ba hẽé naka c'ẽe xu x'áè úú-kg'ao xu hẽéthẽé bìrí a máá: “Sita ka qõese ga xaoè, nta ta gha hẽé?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Me Petere xo̱a a máá: “Tcóóse gatu di chìbian koe naka tua wèéa tu ga Jeso Krestem dim cg'õèm koe tcguù-tcguuè, nxãasega i gha gatu di chìbian qgóóa mááè ke. A tu a gha Tcom-tcomsam Tc'ẽe ba abas khama hòò. ");
INSERT INTO nhr_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nqòòkaguku sa gatu hẽé, naka gatu di cóán hẽé, naka wèéan ẽe nqúù ka hàna hẽéthẽé di si i khama, wèé ne ẽem gha X'aigam gatá dim Nqari ba tcii ne,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","A ba a káí kg'uian cgoa nxàea tseegukagu, a ntcàm ne a máá: “Kgoarase ncẽes qhàòs cg'ãè caus koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne kò gane ẽe kò gam di kg'uian dtcòm̀ ne tcguù-tcguuè, ne kò 3,000 ne ẽem cáḿ ka càùse. ");
INSERT INTO nhr_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Wèé x'aè ka ne kò x'áè úú-kg'ao xu di xgaa-xgaan koe máàse, a kò xg'ae a cúís gúù sa kúrú, a ne e péréan tc'õó, a còrè. ");
INSERT INTO nhr_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ne kò wèé ne khóè ne q'áòs ka tcãàè, zi kò káí zi gúù zi are-aresa zi hẽé naka x'áí zi hẽéthẽé x'áè úú-kg'ao xu ka kúrúè. ");
INSERT INTO nhr_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ne kò wèé ne dtcòm̀-kg'ao ne xg'aea hãa, a cúís gúù sa xg'aea máána hãa. ");
INSERT INTO nhr_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","A ne a wèé zi gúù zi ẽe ne q'õòa hãa zi x'ámágu, a ne a q'aa-q'aaku, ẽem ma wèém khóè ba ma tcàoa hãa khama ma. ");
INSERT INTO nhr_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","A ne a kò wèé cáḿ ka tempelem koe xg'ae, a kò x'áé xu ma xùrikua khama péréan tc'õó; qãè-tcaoa hãa a auku di tcáóan úúa hãase ne kò tc'õó. ");
INSERT INTO nhr_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Nqari ba ne kòo dqo̱m̀, a ne a kò wèé khóèan ka ncàm̀mèa hãa. Me kò Nqari ba wèé cáḿ ka gane di nxáráse-q'ooan càù ẽe kò kgoaraèa hãa ne cgoa. ");
INSERT INTO nhr_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","C'ẽem cáḿ ka tsara kò Petere ba hẽé naka Johane ba hẽéthẽé tsara còrè di x'aè ka tempelem koe qõò, nqoana di x'aè ka. ");
INSERT INTO nhr_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Me kò ábà nqa̱is koe ga guu a nqo̱ara hãam khóè ba ‘T'õè’ ta ko ma tciièm tempelem-kg'áḿ koe hàna. Wèé cáḿ kam kò gaa koe séè a úúè a síí tòóè a ko ẽe ko tcãà ne khóè ne máàku zi dtcàrà ba. ");
INSERT INTO nhr_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eẽm ko Peterea tsara Johanea tsara bóò tsara ko tempelem-kg'áḿ koe tcãà kam kò máàku sa dtcàrà tsara a. ");
INSERT INTO nhr_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tsara téé a tcgáí-q'ooa ba koe bóò me, ka tsara ko Petere tsara bìrí me a máá: “Bóò tsam m,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Me khóè ba qãèse bóò tsara a, au me tsara gha di tcoman úúa hãase. ");
INSERT INTO nhr_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Igabam kò Petere ba máá: “Selefera ga hẽé naka gauta ga hẽéthẽér úú tama, igabar gha ẽer úúa hãa sa máà tsi: Jeso Krestem Nasareta dim cg'õè ka tẽe naka tsia qõòa te!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","A ba a kg'áòm x'õàm gam dim cgoa qgóóa ghùi me, i khóèm di nqàrèan hẽé naka nqõáa ba hẽéthẽé kúúga q'am̀. ");
INSERT INTO nhr_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Me nxàìa tẽe a nqàrèa ba ka téé a tshoa-tshoa a qõòa te, a ba a gatsara cgoa tempelem q'oo koe tcãà; qõòam ko téé a nxàì a Nqari ba dqo̱m̀. ");
INSERT INTO nhr_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eẽ ne ko wèé ne khóè ne bóò me, me ko qõò a ko Nqari ba dqo̱m̀, ");
INSERT INTO nhr_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ka ne ko bóòa q'ãa me, me gaam khóèm ncẽe kòo káíse tempelem ‘T'õè kg'áḿ’ ta ko ma tciièm koe ko ntcõó a ko dtcàràm ga me e sa, ka ne ko kaisas ares ka tcãàè, dùús kúrúse cgae mea hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Gaam khóèm qanega Peterea tsara Johanea tsara cgoa tc'àmà-tc'amasea hãa ka ne kò khóè ne qàròa síí cgae xu, xào-xaos Solomonem di sa ta ko ma tciiès qgáìs koe, kaisas ares ka tcãàèase. ");
INSERT INTO nhr_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Eẽm ko Petere ncẽe sa bóò, kam ko bìrí ne a máá: “Khóè xao Iseraele di xaoè, dùús domka sa ko ncẽe sa arekagu xao o? Dùús domka xao ko ma bóò tsam maà? Sitsam di qarian hẽé kana sitsam di Nqari-tcáóan hẽéthẽé domka tsam kúrú mem ko qõò, ta xao tc'ẽea? ");
INSERT INTO nhr_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Nqarim Abrahamam di ba, a Isakam di ba, a Jakobem di ba, Nqarim gaxae ka xõò ga xu di ba, nxãa ba Gam dim Qãàm Jeso ba x'áàkagua. Tcg'òó Me xao kò, síím gha cg'õoè ka, a xao a kò Pilatom cookg'ai koe c'úùse Me, ncẽe kò qõòm gha ka kgoara Mea hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","A xao a kò Tcom-tcomsa a Tchàno ii ba c'úùse, a dtcàrà mááse cg'õo-kg'aom gha kgoaraè sa. ");
INSERT INTO nhr_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","X'aigam kg'õèan di ba xao kò cg'õo, igabam kò Nqari ba x'ooan koe ghùi Me. Ncẽes gúùs di xae nxàea tseegukagu-kg'ao xae e. ");
INSERT INTO nhr_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Dtcòm̀s ka i kò Jesom di cg'õèan ncẽem khóèm, ncẽe tu ko bóò a q'ana ba, qarian máàna hãa. I Jesom koe guua dtcòm̀an ncẽem khóè ba gatu wèé tu cookg'ai koe kg'õèkagua. ");
INSERT INTO nhr_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ncẽeska, tíí kíí gatuè, q'ana ra hãa, c'úùa tu kò hãa domka tu ncẽes gúù sa kúrúa hãa sa, gatu di xu tc'ãà-cookg'ai xu kò hẽéa khama. ");
INSERT INTO nhr_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Nqari ba wèé xu porofiti xu kg'áḿ koe guu a kg'aiga nxàea hãa a ko máá, Gam dim Kreste ba gha xgàraè, témé. A ba a kò ncẽe kg'uian ncẽem dàòm ka tseegukagua. ");
INSERT INTO nhr_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Gaa domka méé tu gatu di chìbian koe tcóóse, naka Nqarim koe ka̱bise, naka i gha nxãasega chìbia tu tchùua tcg'òóè, ");
INSERT INTO nhr_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","nxãasega i gha ka̱ba-ka̱ban tc'ẽe di x'aèan X'aigam koe guu a hàà ka, a ba a gha Jeso ba tsééa óá, Kreste ii ba, ncẽem nxãakamaga nxárá tcg'òóa máá tua hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nqarikg'ai koe méém hãa, me gha nxãakg'aiga síí x'aè ba hàà, Nqarim gha wèé zi gúù zi kúrúa ka̱bi di ba, ẽem ko ncìísega Gam di xu porofiti xu tcom-tcomsa xu kg'áḿ koe guu a kg'uia hãa sa ba. ");
INSERT INTO nhr_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moshe ba kò kg'ui a máá: ‘X'aigam gatu dim Nqari ba gha gatu di ne khóè ne xg'aeku koe guu a tíí khama iim porofiti ba tsééa óá máá tu u. Ke méé tu wèés gúùs ẽem gha ko bìrí tu u sa komsana. ");
INSERT INTO nhr_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Dìím wèém ẽe porofiti ba komsana tama ba gha gam di ne khóè ne xg'aeku koe q'ãea tcg'òóè,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Xu kò ncìísega wèé xu porofiti xu ncẽe xu cáḿ xu ka kg'uia hãa: Samuele ba hẽé naka ẽe kháóka hààraa xu hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Gatua porofiti xu hẽé naka Nqarim kò gatu ka xõò ga xu cgoa kúrúa hãas qáé-xg'ae sa hẽéthẽé di tu cóá tu u. Ncẽem kò Abrahamam cgoa kúrúa hãa sa, a bìrí me a máá: ‘Wèé zi qhàò zi nqõómkg'ai di zia gha tsaris qhàòs domka ts'ee-ts'eekg'aiè,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eẽm ko Nqari ba Gam dim Qãàm Jeso ba ghùi, kam kò kg'aia gatu koe tséé úú Me, síím gha ts'ee-ts'eekg'ai tu u ka, wèéa tu gam gha gatu di zi dàò zi cg'ãè zi koe tcg'òó ka,” tam Petere méé. ");
INSERT INTO nhr_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Eẽ tsara Peterea tsara Johanea tsara hãa a ko khóè ne cgoa kg'ui, ka xu kò peresiti xu hẽé naka tempelem di xu kòre-kg'ao xu ka kaia hãa ba hẽé, naka Saduke xu hẽéthẽé xu hàà cgae tsara a, ");
INSERT INTO nhr_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","xg'aìa xu kò hãa, ẽe tsara x'áè úú-kg'ao tsara kòo khóè ne xgaa-xgaa, a kòo Jesom x'ooan koe tẽeas ka khóè ne xgaa-xgaa khama. ");
INSERT INTO nhr_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Dqòa a kò ii khama xu kò qgóó a qáé-nquus koe tcãà tsara a, me nxãakg'aiga síí xùrikom cáḿ ba hàà. ");
INSERT INTO nhr_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Igaba ẽe kò Nqarim dim kg'ui ba kóḿ ne koe ne kò káí ne dtcòm̀, i kò khóè xu di nxáráse-q'ooan 5,000 khama noo. ");
INSERT INTO nhr_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Xùrikom cáḿ ka xu ko tc'ãà-cookg'ai xu hẽé naka khóè ne di xu kaia xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé Jerusalema koe xg'ae. ");
INSERT INTO nhr_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Me kò Anase kaiam peresiti ba hàna, Kaifase ba hẽé, naka Johane ba hẽé, naka Alekesantere ba hẽé, naka wèé xu khóè xu kaiam peresitim x'áé di xu hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xu Peterea tsara Johanea tsara xg'aekua xu koe tòó, a tshoa-tshoa a tẽè tsara a, a máá: “Dùútsa qarim ka kana cg'õèm cgoa tsaoa kò ncẽeta hẽéa?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Me kò nxãaska Petere ba Tcom-tcomsam Tc'ẽem ka cg'oè cgaea hãase bìrí xu a máá: “Gaxao khóè ne di xao tc'ãà-cookg'ai xao hẽé naka kaia xao hẽéthẽé xaoè! ");
INSERT INTO nhr_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ncẽem cáḿ ka tsam kò ko nqo̱ara hãam khóè ba kúrúse cgaeas gúùs ncẽes qãès ka ko tẽèè, ntamam ma qãèkaguèa hãa sa ne ");
INSERT INTO nhr_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","méés nxãaska ncẽes gúù sa gaxao hẽé naka wèé ne khóè ne Iseraele di ne hẽéthẽé koe q'ãase, Jeso Krestem Nasareta dim di cg'õèan cgoa a, ncẽe xao kò xgàua hãa ba, ncẽem kò Nqari ba x'ooan koe ghùia hãa ba, Gam domkam ncẽem khóè ba cookg'aia xao koe qãè a téé-tẽe. ");
INSERT INTO nhr_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ncẽea gaxao ‘tshào-kg'ao xao ka xguìèa hãam nxõ̱ám ga Me e, ncẽe cgáés nxõ̱á sa kúrúa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","I kgoarakuan c'ẽe khóè koe ga káà a, me gataga c'ẽem khóèm ga ba nqarikg'ai ka nqãaka káà me e, ncẽe Nqarim ka khóèan xg'aeku koe máàèa hãa ba. Gam dis cg'õès koe méé ta guu naka kgoaraè,’” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Eẽ xu ko Peterea tsara Johanea tsara di kgoarasean bóò, a xgaa-xgaase tama tsara hãa sa bóò, a kg'amaga khóè tsara a sa, ka xu ko are, a xu a bóòa q'ãa, Jesom cgoa tsara kò hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Eẽ xu ko tc'ãa-cookg'ai xu gataga khóèm ẽe qãèkaguèa hãa ba bóò me gatsara cgoa tẽe, ka xu kò kg'ui xu gha gúù ga úú tama. ");
INSERT INTO nhr_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","A xu a x'áè a máá, Peterea xu méé xu xg'aes koe tcg'oa. Ka xu kò tshoa-tshoa a xu a kg'uia xg'ae, ");
INSERT INTO nhr_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","a máá: “Nta xae gha ma ncẽe tsara khóè tsara kúrú? Wèém khóèm Jerusalema koe x'ãèa hãa ba q'ana hãa, are-aresas x'áí sa tsara kúrúa hãa sa, xae gaxae igaba cuiskaga ntcoea hãa tite sa ka. ");
INSERT INTO nhr_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Igaba ncẽes gúùs gha khóè ne koe táá còoka tsa̱i-tsa̱isea qõò domka méé xae ncẽe tsara khóè tsara dqàè naka tsara táá cúí khóè cgoa ncẽes cg'õès ka kg'ui guu,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ka xu kò nxãaska gaia q'oo koe tciia tcãà tsara a, a x'áè tsara a, táá méé tsara gaia Jesom di cg'õèan ka kg'ui sa, kana gaan ka xgaa-xgaa sa. ");
INSERT INTO nhr_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Igabaga tsara kò Peterea tsara Johanea tsara xo̱a xu a máá: “Gaxao ka bóòa mááse, Nqarim tcgáí q'oo koe i tchàno o sa, gaxao méé xao kaisase komsanaè sa, Nqarim ka oose? ");
INSERT INTO nhr_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Sitsama ko tààè, ncẽe tsam bóòa a kóḿa hãa zi gúù zi tsam ga nqoo cgoan ka ke,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Eẽ xu ko dqàè tsara xg'ara ka xu kò guu tsara a tsara qõò, xu gha ma xgàra tsara a sa kò káà si i khama, wèé ne khóè nea kò ẽe kò kúrúsea hãas gúùs ka Nqari ba dqo̱m̀ khama. ");
INSERT INTO nhr_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Are-aresam dàòm ka qãèkaguèam khóèm di kuria ne kò 40 sa nqáéa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Eẽ tsara ko guuè ka tsara kò gatsara ka c'ẽe ne koe ka̱bise a síí xààa máá ne, kaia xu peresiti xu hẽé naka khóè ne di xu kaia xu hẽéthẽéa ko gatsara ka nta mééa sa. ");
INSERT INTO nhr_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eẽ ne ko ncẽe gúùan kóḿ kaga ne kò wèéa ne ga cúí koe tchàa-tchaa dòm̀, a Nqari ba còrè a máá: “X'aiga Tsi Nqari Tseè, nqarikg'ai hẽé, naka nqõókg'ai hẽé, naka tshàa ba hẽé, naka wèé zi gúù zi gaa koe hàna zi hẽéthẽé kúrúa hãa Tseè. ");
INSERT INTO nhr_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ncẽe ko gatá ka xõòm Dafitem Tsarim qãàm kg'áḿ koe guu a, Tcom-tcomsam Tc'ẽem koe guu a kg'ui a máá: ‘Tãá zi qhàò zia dùús domka xgóà hãa, ne ko khóè ne káà hùi zi kàa zi kúrú? ");
INSERT INTO nhr_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nqõómkg'ai di xu x'aiga xu téé-q'ooa xu séèa hãa, x'ãà xu gha ka, xu tc'ãà-cookg'ai xu xg'aea hãa, X'aigam Nqari ba hẽé naka Gam ka ntcã̱a tcúúèa ba hẽéthẽé cgoa xu gha x'ãàku ka,’ tam Dafite méé. ");
INSERT INTO nhr_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Tseeguan kaga xu kò ncẽem x'áé-dxoom koe Herote ba hẽé naka Pontiose Pilato ba hẽé, tãá zi qhàò zi di ne hẽé naka Iseraele di ne hẽéthẽé nea xg'aea hãa a ko Tsarim tcom-tcomsam Tséé-kg'aom Jesom cgoa x'ãàku, ncẽe Tsi ntcã̱á tcúúa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","A ne a ẽe Tsi kò Tsari qarian koe hẽé naka Tsari tc'ẽean koe hẽéthẽé bóòa tcg'òóa hãa sa kúrú, ncẽe gha hàà kúrúse sa. ");
INSERT INTO nhr_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ke ncẽeska X'aiga Tsi Nqari Tseè, gane di q'aekagukuan koe tòón tcgáí, naka Tsia Tsari ta qãà ta di tcáóan ghùi-ghui, naka ta Tsarim kg'ui ba kgoarasea hãase xóé naka kg'ui, ");
INSERT INTO nhr_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","naka Tsi Tsari x'õàn tchoanà xòó naka i qãèkagu, naka zi gataga x'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé kúrúè, Tsarim tcom-tcomsam Tséé-kg'aom Jesom cg'õè koe,” ta ne ma còrè. ");
INSERT INTO nhr_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Eẽ ne ko còrèa xg'ara kagam ko ẽe ne kò hãam qgáì ba cgùru, ne wèéa ne ga Tcom-tcomsam Tc'ẽem ka cg'oè cgaeè, a Nqarim dim kg'ui ba kgoarasea hãase xóé a kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Wèé ne dtcòm̀-kg'ao nea kò tcáóa ne hẽé naka tc'ẽea ne hẽéthẽé koe cúí ne e. Cúím ga ba kò gam q'õòa hãa gúùan cúía kàoa mááse tama, igaba ne kòo ẽe ne q'õòa hãa gúùan wèéa ne ga q'aa-q'aaku. ");
INSERT INTO nhr_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Xu kò x'áè úú-kg'ao xu X'aigam Jeso ba x'ooan koe tẽea hãa di tchõàn kaisa qarika nxàea tseegukagu; i kò kaisa cgóm̀kuan gane wèéa ne koe ga hãa, ");
INSERT INTO nhr_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","c'ẽe gúù ko tcào khóèa kò gane xg'aeku koe káà a khama. Wèém khóèm ẽe xháràn úúa kana nquuan úúa hãa ba kò x'ámágu u, a ẽe ne ko x'ámágu u ka ne hòòa hãa marian ko úú, ");
INSERT INTO nhr_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","a ne a kò x'áè úú-kg'ao xu di nqàrè-kg'aman koe hàà tòó o khama, me kò wèém khóè ba ẽem ma tcàoa hãa khamaga ma samaè e. ");
INSERT INTO nhr_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","37","Me kò Josefa ba gataga q'õòam kò hãam xhárà ba x'ámágua, a kò marian cgoa hàà, a hàà x'áè úú-kg'ao xu nqàrè-kg'am koe tòó o. Lefi dis qhàòs di me e kò ii, a Kupero koe guua hãa, a ba a kò x'áè úú-kg'ao xu ka Barenabase ta ma tciiè, ncẽe ko máá: ‘Ghùi-ghui-tcáókuan dim cóá ba,’ téméè ba. ");
INSERT INTO nhr_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Igabam kò c'ẽem khóè ba hàna a kòo Ananiase ta ma tciiè. A ba a kò dxàeses Safiras cgoa hàna, a c'ẽe gúùan gakhara di x'ámágua hãa. ");
INSERT INTO nhr_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","A ba a kò c'ẽe marian séè a tòóa mááse, gam dis khóès q'ana hãase, a c'ẽe xòèan síí x'áè úú-kg'ao xu nqàrè-kg'am koe tòó. ");
INSERT INTO nhr_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Me Petere ba máá: “Ananiaseè, dùús domka tsi ko satana ba guu me tcáóa tsi cg'oè-cg'oe, tsi kò Tcom-tcomsam Tc'ẽe ba tshúù-ntcõaa máá, a tsi a kò c'ẽe marian xháràm di séè a tòóa mááse? ");
INSERT INTO nhr_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","X'ámágu me tama tsi hãa cookg'ai koe ba kò tsari tama? Eẽm ko x'ámáguè ka ia kò gataga marian tsari tama? Dùús domka tsi ko nxãaska kháé ncẽes gúù sa tcáóa tsi koe tcãà? Tíía tsi qàe-qae tea hãa tama, igaba tsi Nqari ba qàe-qaea hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Eẽm ko Ananiase ncẽe zi kg'ui zi kóḿ kam kò cg'áé a x'óó. Ne kò wèé ne gaas gúù sa kóḿa hãa ne kaias q'áòs ka tcãàè. ");
INSERT INTO nhr_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Xu qárí-kg'ao xu hàà tc'áróa ba séè a tcáḿ a tcg'òó, a síí kg'ónò o. ");
INSERT INTO nhr_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Si kò nqoana khama noo aoaran qãá q'oo koe gam ka dxàe sa tcãà, dùú sa kúrúsea hãa sa c'úùa hãase. ");
INSERT INTO nhr_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Me Petere ba tẽè si a máá: “Bìrí te, gaam marim xhárà ba khao x'ámágu cgoam ga me e sa?” témé, si máá: “Eè, gaam marim ga me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Me Petere ba tẽè si a máá: “Nta khao gha ma dtcòm̀ku a X'aigam Nqarim dim Tc'ẽe ba kúrúa bóò? Q'ãa méé si: khóè xu sarim khóè ba kò síí kg'ónò xu di dàòa nea nquum-kg'áḿ koe hàna, xu gha sáá séè a tcg'òó si thẽé,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Kas ko gaa x'aè kaga qháésega nqàrè-kg'ama ba koe cg'áé a x'óó, xu qárí-kg'ao xu tcãà, a sao-xg'ae sis x'óóa hãa, xu séè a tcg'òó a síí dxàesem qàe koe kg'ónò si. ");
INSERT INTO nhr_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Si kò wèés xg'aes dtcòm̀-kg'ao ne dis koe hẽé naka ẽe kò ncẽe gúùan kóḿ ne koe hẽéthẽé kaisas q'áò sa xóé. ");
INSERT INTO nhr_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Xu x'áè úú-kg'ao xu káí zi x'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé khóè ne xg'aeku koe kúrú. Ne kò wèé ne dtcòm̀-kg'ao ne wèé x'aè ka Solomonem dis xào-xaos koe xg'aea hãa. ");
INSERT INTO nhr_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ne kò c'ẽe ne khóè ne ẽes xg'aes koe tcãàn bèe, igaba ne kò khóè ne tcom nea hãase qgóó ne. ");
INSERT INTO nhr_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Eẽta i ii igaba ne kò káí ne dtcòm̀-kg'ao ne Nqarim koe càùse, káí xu khóè xu hẽé naka káí zi khóè zi hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ka ne kò tcìì-khoe ne tchàa koe tcg'òó, a síí gane di tcoàn cgoa dàòan qàe koe xòóè, nxãasega ne gha ẽem kòo Petere gaa koe nqáé ne sóm̀a ba ga sóm̀-som ne ka. ");
INSERT INTO nhr_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalema ba nxa̱ma-nxa̱maa hãa zi nqõó zi koe ne kò khóè ne guu a xg'aeku, a ẽe tcììa hãa ne óága, naka dxãwa tc'ẽean ka ko xgáèè ne hẽéthẽé e, ne wèéa ne ga hàà kg'õèkaguè. ");
INSERT INTO nhr_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Igabam kò kaiam peresiti ba hẽé naka wèé xu gam cgoa kò hãa xu hẽé naka Saduke xu dis xg'aes di xu hẽéthẽé tauan ka tcãàè, ");
INSERT INTO nhr_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","a xu a kò x'áè úú-kg'ao xu qgóó a qáé a síí x'áé-dxoom dis qáé-nquus koe tcãà xu. ");
INSERT INTO nhr_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Me ntcùú ka X'aigam Nqarim dim moengele ba qáé-nquum-kg'áḿ xgobekg'am, a tcg'òó xu, a bìrí xu a máá: ");
INSERT INTO nhr_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Qõò xao naka síí tempelem koe téé, naka khóè ne cgoa kg'ui wèé kg'uian ncẽe ka̱ba kg'õèan di i,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Eẽ xu ko kóḿ ka xu kò qõò a q'uu i ko ka síí tempelem koe tcãà, a xgaa-xgaa. Me kò kaiam peresiti ba hẽé naka ẽem kò hãa cgoa xu hẽéthẽé ko hàà, ka xu kò tc'ãà-cookg'ai xu hẽé naka Iseraele di xu kaia xu dis xg'ae sa hẽéthẽé tciia xg'ae, a xu a qáé-nquus koe c'ẽe xu tsééa úú, síí xu gha x'áè úú-kg'ao xu tciia óá ka. ");
INSERT INTO nhr_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eẽ ko tsééèa xu ncõo-kg'ao xu ko qáé-nquum koe síí ka xu kò síí táá sao-xg'ae xu, ka xu ko ka̱bise a síí xàà a, a máá: ");
INSERT INTO nhr_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ncãa xae qáé-nquu ba bóò me qarika tcẽekg'ammèa, xu kòre-kg'ao xu wèé xu heke-kg'áḿ zi koe téé-tẽe, igaba ẽe xae ko heke-kg'áḿ zi xgobekg'am ka i kò cúí khóè ga q'oo koe káà a,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Eẽ xu ko tc'ãà-cookg'aim tempelem di xu kòre-kg'ao xu di ba hẽé naka kaia xu peresiti xu hẽéthẽé xu ncẽe gúùan kóḿ, ka xu kò are, dùútsa gúùs ko kúrúse sa. ");
INSERT INTO nhr_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Me kò c'ẽem khóè ba hàà bìrí xu a máá: “Bóò, gaxao thuu qáé-nquum koe tcana hãa xu khóè xua tempelem koe téé-tẽe a ko khóè ne xgaa-xgaa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Me nxãaska tc'ãà-cookg'ai ba gam di xu kòre-kg'ao xu cgoa qõò, a síí séè a óága xu, chùi xu tamase, nxõ̱án cgoa xu gha khóè ne ka xaoè sa xu kòo bèe khama. ");
INSERT INTO nhr_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Xu ko óága xu a kaia xu dis xg'aes cookg'ai koe úú xu. Me kò kaiam peresiti ba tẽè xu, ");
INSERT INTO nhr_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","a máá: “Qarika xae kò x'áè xaoa a máá, táá xao ẽes cg'õès ka xgaa-xgaa guu témé, igaba bóò, Jerusalema ba xao gaxao di xgaa-xgaan ka cg'oè-cg'oea hãa, ncẽem khóèm di chìbian xao gaxae koe óá kg'oana,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Igabam kò Petere hẽé naka c'ẽe xu x'áè úú-kg'ao xu hẽéthẽé xo̱a a máá: “Nqari ba méé ta khóèan ka kaisase qám̀sea máá. ");
INSERT INTO nhr_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gaxae ka xõòa xu dim Nqari ba Jeso ba x'ooan koe ghùia hãa, ncẽe xao kò xgàus koe tceea ba ka cg'õo ba. ");
INSERT INTO nhr_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nqari ba Gam dim x'õàm kaiam xòè koe ghùi Mea, Tc'ãa-cookg'ai a Kgoara-kg'ao bam gha ii ka, a ba a gha Iseraele ne kúrú ne chìbian koe tcóóse, a chìbia ne qgóóa mááè ka. ");
INSERT INTO nhr_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Sixaea ẽe zi gúù zi di xae nxàea tseegukagu-kg'ao xae e, sixae hẽé nakam Tcom-tcomsam Tc'ẽe ba hẽéthẽé e, ncẽem kò Nqari ba ẽe qám̀sea hãa ne máàa ba,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Eẽ xu ko ncẽe sa kóḿ ka xu kò kaisase xgóà a cg'õo xu kg'oana. ");
INSERT INTO nhr_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Igabam kò c'ẽem Farasaim Gamaliele ta ko ma tciiè ba xg'aes koe tẽea téé, ncẽe kò wèé khóèan ka tcommèam x'áè xgaa-xgaa-kg'ao ii ba. X'áèa nem kò tcg'òó, x'áè úú-kg'ao xu méé xu xòm̀ x'aè tchàa koe tcg'òóè di i, ");
INSERT INTO nhr_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","a ẽe q'oo koe hàna xu bìrí a máá: “Gaxao Iseraele di xao khóè xaoè, ẽe xao ko hàà ncẽe xu khóè xu koe kúrús gúùs ka méé xao q'ãa tc'ẽea hãase kúrú. ");
INSERT INTO nhr_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ncẽe xu cáḿ xu cookg'ai koem kò Tutase ba tẽe, a ba a máá khóè cgáé me e témé, xu kò 400 khama noo xu khóè xu xùri me. Igabam kò cg'õoè, i kò wèéan ẽe ko xùri me tsa̱i-tsa̱ise, a kaà. ");
INSERT INTO nhr_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Eẽm khóèm qãá q'oo koem kò Jutasem Galilea di ba tẽe, khóè ne ko nxáráè x'aèan ka, a kò káí ne khóè ne ka xùriè. Me gaam igaba kaà, i kò wèéan ẽe kòo xùri me ga tsa̱i-tsa̱ia q'aase. ");
INSERT INTO nhr_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Khamar ko ncẽeska bìrí xao o a ko máá: ncẽe xu khóè xu koe méé xao tcg'òóse, guu xu méé xao. Ncẽè gaxu dis tséés kana gaxu dis kàas kò khóè ne di sa ii, nes gha kaàkaguè ke. ");
INSERT INTO nhr_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Igaba ncẽè Nqarim dis kò ii ne xao cuiskaga ko̱be sia hãa tite. Nqarim cgoa ga xao gha ko x'ãàku,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Xu kò gam cgoa dtcòm̀ku, a x'áè úú-kg'ao xu tcii, a hàà xg'áḿ qãá xu, a dqàè xu, táá méé xu Jesom di cg'õèan ka gaicara kg'ui guu sa, a guu xu xu qõò. ");
INSERT INTO nhr_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xu kò qãè-tcaoa hãase xg'aes koe guu a tcg'oa, Jesom di cg'õèan domka xgàraèa ne kò kg'ano xua hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","A xu a kò wèé cáḿan ẽe ka tempelem q'oo koe hẽé naka khóè ne x'áé koe hẽéthẽé xgaa-xgaan cgoa chõò tama, a ko xgaa-xgaa Jeso ba nqòòkaguèa hãam Kreste Me e sa. ");
INSERT INTO nhr_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Eẽ xu cáḿ xu ka ne ko xgaa-xgaase-kg'ao ne càùse a káí, ka ne ko Gerika di ne Juta ne mẽéku Hebera di ne Juta ne cgoa, wèé cáḿan tc'õoan ko gàbaè x'aè ka zi kò Gerika di zi dxàe-ntcõa zi qãèse máàè tama khama. ");
INSERT INTO nhr_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Xu 12 xu x'áè úú-kg'ao xu wèé ne xgaa-xgaase-kg'ao ne tciia xg'ae a máá: “Qãèa i máá xae e tite, Nqarim dim kg'uim di tsééan guu a síí tc'õoan gàbakagu ne. ");
INSERT INTO nhr_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Gaxae ka qõese ga tuè, gatu xg'aeku koe 7 xu khóè xu nxárá tcg'òó, q'ana tu hãa xu Tcom-tcomsam Tc'ẽem ka cg'oèa a tc'ẽega xu, naka xae ncẽe tsééan máà xu. ");
INSERT INTO nhr_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Igaba xae gha sixae còrèan hẽé naka Nqarim dim kg'ui ba hẽéthẽé dis tséé sa tcãà tcáóa máá,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Me kg'uim ncẽe ba wèés xg'ae sa qãè-tcaokagu. Ne Stefane ba nxárá tcg'òó, khóèm ncẽe kò dtcòm̀an ka hẽé naka Tcom-tcomsam Tc'ẽem ka hẽéthẽé cg'oèa ba; naka Filipi ba hẽé, naka Perokoro ba hẽé, naka Nikanore ba hẽé, naka Timone ba hẽé, naka Paremenase ba hẽé, naka Nikolao ba hẽéthẽé xu, ncẽe kò Antioke koe kò guua hãa a Juta dis dtcòm̀s koe máàsea hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ne kò ncẽe xu khóè xu x'áè úú-kg'ao xu cookg'ai koe tòó, ncẽe kò còrè a tshàua xu tòó cgae xu xu. ");
INSERT INTO nhr_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Me kò Nqarim dim kg'ui ba tsa̱i-tsa̱ise. Ne xgaa-xgaase-kg'ao ne Jerusalema di ne qháése càùse a kaisase káí, si gataga thẽé peresiti xu dis xg'aes kaia sa dtcòm̀an koe máàse. ");
INSERT INTO nhr_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefane ba ko Nqarim di cgóm̀kuan hẽé naka qarian hẽéthẽé ka cg'oè cgaeèam khóè me e, a kò are-aresa zi gúù zi hẽé naka kaia zi x'áí zi hẽéthẽé khóè ne xg'aeku koe kúrú. ");
INSERT INTO nhr_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Igaba xu kò c'ẽe xu khóè xu ncẽe kò còrè-nquum qãàn di tsééan koe guu a kgoaraèa xu khóè xu di ba ta ko ma tciièm di xu, ncẽe kò Juta xu Kurene hẽé naka Alekesanteria hẽéthẽé di ii xu hẽé, naka c'ẽe xu Kilikia hẽé naka Asia hẽéthẽé di xu Stefanem cgoa ntcoeku. ");
INSERT INTO nhr_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Igaba xu kò gam di tc'ẽean hẽé naka Tcom-tcomsam Tc'ẽem ẽem kò ko Gam di hùian ka kg'uim cgoa hẽéthẽé tc'ãòku tama. ");
INSERT INTO nhr_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nxãaska xu ko c'ẽe xu khóè xu qg'áì, xu Stefanem ka máá: “Ncẽem khóè ba xae kóḿa hãa me ko Moshem di x'áèan hẽé naka Nqarim ka hẽéthẽé cg'ãèse kg'ui,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Xu kò nxãaska khóè ne hẽé naka kaia xu hẽé naka x'áè xgaa-xgaa-kg'ao xu hẽéthẽé ko̱bi-ko̱bi. Ne qgóó me a ne a kaia xu dis xg'aes cookg'ai koe úú me. ");
INSERT INTO nhr_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","A xu a tshúù-ntcõan di tééa-máá-kg'aoan qg'áì i máá: “Ncẽem khóè ba ncẽem tcom-tcomsam tempelem ka hẽé naka x'áèan ka hẽéthẽé tshúùse kg'uian cgoa chõò tama. ");
INSERT INTO nhr_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kóḿ mea xae hãa me ko máá: ‘Ncẽem Jesom Nasareta di ba gha ncẽes qgáì sa ko̱be, a ba a gha Moshem máà xaea hãa cauan qg'urì,’ témé khama,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Xu kò kaia xu wèé xu ẽe kò xg'aes q'oo koe ntcõe xu tcgáía xu Stefanem koe qãea tòó, a kg'áía ba bóò i moengelem dian khama ii. ");
INSERT INTO nhr_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Me nxãaska kaiam peresiti ba tẽè me a máá: “Kháé zi ncẽe zi chìbi-chibiku zi tseegu zia?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Me Stefane xo̱a a máá: “Tíí kíí ga xao, àbo ga xaoè, komsana te! X'áàn dim Nqari ba kò gatá ka xõòm Abrahamam koe hòòse, qanegam kò Mesopotamia koe hãa ka, qanegam Harane koe x'ãè tamas cookg'ai koe, ");
INSERT INTO nhr_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","a bìrí me a máá: ‘Tcg'oa tsarim nqõóm koe hẽé naka tsari ne qhàò ne koe hẽéthẽé, naka tsia x'áí tsir gham nqõóm koe qõò,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Me nxãaska Kaletea ne dim nqõóm koe tcg'oa a ba a Harane dim x'áé-dxoom koe síí x'ãè. Me Nqari ba xõòm dis x'oos qãá q'oo koe gaa koe tcg'òó me, a ncẽe tu ncẽeska x'ãèa hãam nqõóm koe tsééa óá me. ");
INSERT INTO nhr_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Me kò nqõóm di c'ẽe xòèan ga táá máà me, a cúím nqàrèm ga bam gha tòó qgáì ga táá máà me, igabam kò nqòòkagu me, gabá hẽé naka qãáa ba dis qhàòs ga sa hẽéthẽém gha ẽem nqõó ba máà ne q'õò sa, Abrahama ba kò cóá úú tama igaba. ");
INSERT INTO nhr_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Me kò Nqari ba gam ka ncẽeta méé a máá: ‘Tsaris qhàò sa gha gane di tamam nqõóm koe c'úùsea hãa, a gha qãà kúrúè, a gha 400 khama noo kurian táá qãèse qgóóè. ");
INSERT INTO nhr_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Igabar gha ẽe ne ko tsééa máás qhàò sa xgàra, ne gha ẽe zi gúù zi qãá q'oo koe tcg'oa, a hàà ncẽes qgáìs koe dqo̱m̀ Te,’ tam Nqari ba méé. ");
INSERT INTO nhr_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","A ba a kò q'ãe nqãa-qgai khòokus dis qáé-xg'ae sa máà me. Me kò Abrahama ba Isaka ba ábà, a ba a kò 8 dim cáḿ ka q'ãe nqãa-qgai khòo me; me kò Isaka ba Jakobe ba ábà, me kò Jakobe ba 12 xu cóá xu ábà, ncẽe tc'ãà di xu tsgõo xu gatá di xu. ");
INSERT INTO nhr_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Xu kò gatá ka tsgõose ga xu, gaxu ka qõesem Josefam cgoa tauan úú, a xu a kò Egepeto koe qãàse x'ámágu me. Igabam kò Nqari ba hãa cgoa mea, ");
INSERT INTO nhr_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","a kò gam di zi xháé zi wèé zi koe kgoara me, a Egepeto dim x'aigam Farom cookg'ai koe cgóm̀kuan hẽé naka q'ãan di tc'ẽean hẽéthẽé máà me, me kò Faro ba Egepeto koe hẽé naka wèém x'áém gam dim koe hẽéthẽé tc'ãà-cookg'ai ba kúrú me. ");
INSERT INTO nhr_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Si kò nxãaska wèém nqõóm Egepeto dim koe hẽé naka Kanana dim koe hẽéthẽé xàbà sa tcãà, a kaisa thõòan óága, xu kò gatá ka xõò ga xu táá tc'õoan hòò. ");
INSERT INTO nhr_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Eẽm ko Jakobe ba kóḿ i ko máá, Egepeto koe i maberean hãa, téméè kam kò gatá ka xõò ga xu tc'ãà dis dàras gaxu dis koe tsééa úú. ");
INSERT INTO nhr_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Me kò Josefa ba cám̀ dis dàras gaxu dis ka káíkhoe ga xu q'ãàkaguse, si kò Josefam dis qhàò sa Farom koe q'ãase. ");
INSERT INTO nhr_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ncẽes gúùs qãá q'oo koem kò Josefa ba khóèan tsééa hãa, i síí gam ka xõòm Jakobe ba hẽé naka gam di qhàòan wèé ga hẽéthẽé tcii. Wèéa ne ga kò 75 ne e. ");
INSERT INTO nhr_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Me kò nxãaska Jakobe ba Egepeto koe síí, ncẽe xu kò gabá hẽé naka gatá ka xõò ga xu hẽéthẽé síí x'óó koe. ");
INSERT INTO nhr_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Gaxu di tc'áróa ne kò ka̱bi a Shekeme koe úúè, a síí ncẽem xg'ao Abrahama ba Hamorem di xu cóá xu koe marian tc'ãòa cgoa x'ámás tc'ám̀s koe xòóè. ");
INSERT INTO nhr_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Eẽm ko Nqarim xg'ao Abrahama ba nqòòkagua hãam x'aè ba cúù, ka ne kò khóè ne Egepeto koe káí a càùsea. ");
INSERT INTO nhr_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Me kò c'ẽem x'aiga ba nxãakg'aiga síí Egepeto koe tc'ãà-cookg'ai, ncẽe kò Josefa ba c'úùa hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","A ba a kòo gatá di ne khóè ne cgoa cg'ãèm dàòm ka tséé, a ko gatá ka xõò ga xu chùi, xu cóá-coan tchàa koe tcg'òó, nxãasega i gha cg'õoè ka. ");
INSERT INTO nhr_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Me kò ẽem x'aèm ka Moshe ba ábàè, a ba a kò Nqarim cookg'ai koe kaisase t'õè me e. A kò xõòm dim nquum koe nqoana nxoean kòreè. ");
INSERT INTO nhr_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Eẽm síí tchàa za tòóèa kas kò Farom ka cóáse sa séè a gas dim cóám khama ma kaikagua mááse me. ");
INSERT INTO nhr_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Me kò Moshe ba Egepeto ne di q'ãan di tc'ẽean wèé ga xgaa-xgaaè, a ba a kò kg'uian hẽé naka tsééan hẽéthẽé koe qari me e. ");
INSERT INTO nhr_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Eẽm Moshe 40 kuri ii kam kò bìríse, gam ka c'ẽe ne Iseraele nem gha dàra sa. ");
INSERT INTO nhr_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Me kò gam ka c'ẽe ba bóò me ko Egepetom ka ghã̱aè a ko xg'áḿmè, kam ko ẽe ko ghã̱aè ba hùi, a ncèèa máá me, a Egepeto ba xg'áḿ. ");
INSERT INTO nhr_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Me Moshe tc'ẽea máá, gam di ne khóè ne gha bóòa q'ãa Nqari ba kò tséékagu me a ko kgoara ne sa, ta tc'ẽea, igaba ne kò táá bóòa q'ãa. ");
INSERT INTO nhr_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Me q'uu dim cáḿ ka Moshe x'ãàku ko tsara Iseraele tsara koe hàà. Kúrúm ko a xg'aekua tsara koe tòókuan óá kg'oana, khamam ko máá: ‘Khóè tsaoè, qõekua tsaoa! Dùús domka tsao ko thõò-thõoku?’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Igabam kò khóèm ẽe kò c'ẽe ba ghã̱a ba Moshe ba dxùukg'ai za xàbùa tcg'òó a máá: ‘Dìína sitsam koe tc'ãà-cookg'ai a xgàra-kg'ao ba kúrú tsia? ");
INSERT INTO nhr_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","A cg'õo te kg'oana tsia, ncẽe tsi ncãa ma ncãaka cáḿ ka Egepeto ba ma cg'õo khama ma?’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eẽm ko Moshe ba ncẽe sa kóḿ kam kò Midiane dim nqõóm koe qgóéa síí, ncẽem kò gaa koe síí x'ãè koe, gaam nqõóm dim khóèm tamam iise, a ba a kò gaa koe cám̀ cóá tsara ábà. ");
INSERT INTO nhr_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Eẽ i ko 40 kurian nqáéa xg'ara kam kò Sinai dim xàbìm koe moengele ba qãáka hãas hìis ka̱rukos koe hòòse cgae me. ");
INSERT INTO nhr_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Eẽm ko Moshe ba ẽes gúù sa bóò kam kò ares ka tcãàè, a cúù-cuuse, qãèsem gha síí bóò ka, kam kò X'aigam Nqarim dim dòm̀ ba kóḿse a ko máá: ");
INSERT INTO nhr_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Tíí Ra Nqarir saò ga xu di Ra a, Nqarir Abrahama ba hẽé naka Isaka ba hẽé naka Jakobe ba hẽéthẽé di Ra,’ témé. Me Moshe q'áòan ka cg'oè cgaeè a gaa zam gha bóò sa bèe. ");
INSERT INTO nhr_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Me X'aigam Nqari ba bìrí me a máá: ‘Nqàrèa tsi koe nxàboan tcg'òó, ẽe tsi téé-tẽem qgáì ba tcom-tcomsam nqáḿ me e ke. ");
INSERT INTO nhr_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Tseeguan kagar Tiri ne khóè ne Egepeto koe hàna ne di xháé-q'ooan bóòa, gane di sónò ntcòóse-q'ooa ner kóḿa hãa, a Ra a hààra hãa, hààr gha kgoara ne ka, ke ncẽeska hàà nakar Egepeto koe tsééa úú tsi,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ncẽe ba gaam Moshem ga me e, ncẽe ne kò xguìa hãa a máá: ‘Dìína tc'ãà-cookg'ai a xgàra-kg'ao ba kúrú tsia?’ témé ba. Nqari ba kò ncẽe ba tsééa hãa, tc'ãà-cookg'ai a kgoara-kg'ao bam gha kúrú ka, moengelem ncẽe kò ka̱rukos hìis koe x'áíse mea hãam di hùian ka. ");
INSERT INTO nhr_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Me kò Egepeto koe guu a séèa tcg'òó ne. Gaa koem kò are-aresa zi gúù zi hẽé naka x'áí zi hẽéthẽé kúrú, naka Nco̱àm Tshàam koe hẽé, naka tchàa-xgóós koe hẽéthẽé e, 40 kuria ne. ");
INSERT INTO nhr_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Ncẽea gaam Moshem ga me e, ncẽe kò Iseraele di ne khóè ne bìrí a máá: ‘Nqari ba gha gatu di ne khóè ne xg'aeku koe guu a tíí khama iim Porofiti ba tsééa óá máá tu u,’ témé ba. ");
INSERT INTO nhr_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Gaam ga me e ncẽe kò tchàa-xgóós koe Iseraele di ne khóè ne dis xg'aes q'oo koe gaam moengelem cgoa hãa ba, ncẽe kò Sinai dim xàbìm koe gam cgoa hẽé naka gatá ka xõò ga xu hẽéthẽé cgoa kg'ui ba. Me kò kg'õèa hãa kg'uian Nqarim di hòò, nxãasegam gha hàà gatá koe óága a ka ba. ");
INSERT INTO nhr_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Igaba ne kò gatá ka xõò ga ne komsanaa ba xguì. A ne a dxùukg'ai za xàbùa tcg'òó me, a ne a kò tcáóa ne q'oo koe Egepeto koe úú-kg'ai, ");
INSERT INTO nhr_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","a ne a Arone ba bìrí a máá: ‘Nqárìan kúrúa máá ta a, cookg'aia ta koe gha qõò o. Moshem ncẽe kò Egepeto dim nqõóm koe séèa tcg'òó ta am koes dùú sa kúrúsea sa ta c'úùa hãa ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Gaa x'aèan ẽe kaga ne kò ghòè-coam dis iis koe nqárì ba kúrúa mááse, a ne a dàòa-mááku zi óágaa máá me, a gane di tshàuan kúrúas gúùs dis kõ̱è sa kúrú. ");
INSERT INTO nhr_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Igabam kò Nqari ba q'aumana ne, a ba a guu ne ne nqarikg'ai di zi tco̱nò zi qám̀sea máá, ncẽe i ma porofiti xu dis Tcgãyas koe ma góáèa hãa a ko máá: ‘Iseraele di tu khóè tuè, 40 kurian ncẽe tu kò tchàa-xgóós koe hãa ka tua gáé kò dàòa-mááku zi hẽé naka qhàea-mááku zi hẽéthẽé Tíí kúrúa máá Tea? ");
INSERT INTO nhr_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Igaba tu kò wèé zi qgáì zi ẽe tu ko qõò zi koe Molokem dim còrè-nquu ba hẽé, naka gatu dim nqárìm Rafanem dim tco̱nò ba hẽéthẽé tsara dqo̱m̀, xommèa nqárìan tu gatu kúrúa máásea, dqo̱m̀ m tu gha ka. Gaa domkar gha tòèkagu tu u, a Babilonem ka ncìí za úú tu u,’ témé khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Gatá ka xõò ga xu kò tchàa-xgóós koe xgàuèkom còrè-nquu ba úúa, ncẽe Nqarim kò khóè ne cgoa kg'ui koe. Nqarim kò Moshe ba ma x'áía, a x'áè mea hãa khama kò ma kúrúèa ba. ");
INSERT INTO nhr_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Xu gatá ka xõò ga xu gaam còrè-nquu ba máàèa, a xu a séè a ncẽem nqõóm koe óá me, Joshuam kò tc'ãà-cookg'ai xua ka. Xu kò nqõó ba séè, Me Nqari ba gaam nqõóm koe kò x'ãèa zi qhàò zi gaxu cookg'ai koe xhàiagu. Gaam xgàuèkom còrè-nquu ba kò hàna, i síí nxãakg'aiga Dafitem di x'aèan ga tcãà, ");
INSERT INTO nhr_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ncẽe kò Nqarim tcgáí-q'oo koe cgóm̀kuan hòò ba. A ba a kò Nqari ba dtcàrà, còrè-nquu bam gha Jakobem dim Nqari ba tshàoa máá sa, ");
INSERT INTO nhr_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","me kò Solomone ba nquu ba tshàoa máá Me. ");
INSERT INTO nhr_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Igabam kò kaisase tc'amaka hànam Nqari ba khóè tshàu ka kúrúèa hãa nquuan koe x'ãè tama, porofitim ko ma kg'ui khama, ");
INSERT INTO nhr_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","a ko máá: ‘Nqarikg'ai ne Tiri x'aian dis ntcõó-q'oo si i, me nqõó ba nqàrèa Ter ko tòó qgáì i. Nta iim nquu ba tu gha tshàoa máá Te? Kana sãa-q'ooa Te di qgáìa nea ndakaa? ");
INSERT INTO nhr_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Wèé zi gúù zi ncẽe zia gáé Tiri tshàuan ka kúrúè tama?’ tam X'aigam Nqari ba méé. ");
INSERT INTO nhr_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Gaxao khóè xao qari-tcúú xaoè, ncẽe tcáóa xao hẽé, naka tceea xao hẽéthẽé koe q'ãe nqãa-qgai khòoè ta ga hãa xaoè! Gaxao ka xõò ga xu khamaga xao ii: wèé x'aè ka xao ko Tcom-tcomsam Tc'ẽem cgoa x'ãàku! ");
INSERT INTO nhr_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gaxao ka xõò ga xu kò wèé xu porofiti xu xgàraa hãa, a xu a kò ncẽe xu porofiti xu, ncẽe kò x'aè cookg'ai koe tchànom Khóèm di hàà-q'ooan nxàea hãa xu cg'õo, Jesom ncẽe xao gaxao ncẽeska x'ámágua, a Gam di xao cg'õo-kg'ao xao ii ba. ");
INSERT INTO nhr_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Gaxao ncẽe kò moengele xu ka xao kò máàèa hãa x'áèan kò cám̀ tshàua máá, igaba kò táá komsana a xao,” tam Stefane méé. ");
INSERT INTO nhr_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ncẽe zi gúù zi xu ko kóḿ ka xu kaisase tcg'aìn tcáó a xu a dqùrì cgae me. ");
INSERT INTO nhr_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Igabam kò Stefane ba Tcom-tcomsam Tc'ẽem ka cg'oè cgaeèa hãase nqarikg'ai koe ghùi-kg'ai, a ba a Nqarim dim x'áà ba bóò, naka Jeso ba hẽéthẽé e, Me Nqarim dim kg'áòm x'õàm xòè za téé-tẽe. ");
INSERT INTO nhr_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kam ko máá: “Bóò, nqarikg'ai nea xgobekg'amsea ra ko bóò, Me Khóèm dim Cóá ba Nqarim dim kg'áòm x'õàm xòè za téé-tẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Xu kò khóè xu ncẽes gúùs ka tceea xu tcẽekg'am, a xu a kaisase q'au a qàròa síí cgae me, ");
INSERT INTO nhr_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","a xu a x'áé-dxoom qãá koe tceea tcg'òó a úú me, a gaa koe síí nxõ̱án ka xgàrùbe me. Nxàea tseegukagu-kg'ao xu kò gaxu di qgáían Saulo ta ko ma tciièm qárí-kg'aom nqàrè-kg'am koe tòó. ");
INSERT INTO nhr_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Eẽ xu hãa a ko Stefane ba nxõ̱á zi cgoa xgàrùbe kam kò Nqari ba tcii a máá: “X'aiga Tsi Jeso Tseè, tirim tc'ẽe ba séè,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kam ko qhòm tsi qurù a ba a kaiam dòm̀ cgoa q'au a máá: “X'aigaè, ncẽe ne ko tíí koe kúrús gúùs koe táá chìbi bóò ne guu,” témé. Eẽm ko gatà mééa xg'ara kam kò x'óó. ");
INSERT INTO nhr_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Me kò Saulo ba Stefanem di cg'õokuan dtcòm̀a máána hãa. Filipia xu Peterea xu di tsééa ne, Jutea hẽé naka Samaria hẽéthẽé koe (8–12) Eẽm cáḿ kas kò Jerusalema dis kerekes koe kaias xgàraku sa tshoa-tshoase, ka ne kò wèéa ne ga Jutea hẽé naka Samaria hẽéthẽé di tsara nqõó tsara koe tsa̱i-tsa̱ise, xu x'áè úú-kg'ao xu cúí xu qaù. ");
INSERT INTO nhr_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ne kò Nqari-tcáóa ne khóè ne Stefane ba kg'ónò, a kò kaisase kg'ae cgae me. ");
INSERT INTO nhr_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Igabam ko Saulo tshoa-tshoa a nquu xu koe tcana te a kereke sa dxàùa q'aa, a khóè xu hẽé naka khóè zi hẽéthẽé tcéèa tcg'òó a síí qáé-nquuan koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ne kò gane ẽe kò tsa̱i-tsa̱isea hãa ne, wèé qgáìan ẽe ne ko síí koe qãè tchõàn xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Me kò Filipi Samaria dim x'áé-dxoom koe síí, a gaa koe síí nqòòkaguèa hãam Krestem ka xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Eẽ zi ko xg'ae zi khóè ne di zi Filipi ba kóḿ a ko kúrúm ko zi x'áí zi are-aresa zi bóò, ka zi ko wèéa zi ga cúù-cuuse a qãèse kóḿ me. ");
INSERT INTO nhr_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Dxãwa tc'ẽea ne kò káí ne khóè ne koe kaiam q'aum cgoa q'aua tcg'oa khama, ne kò gataga káí ne khóè ne x'óó xòèa kò hãa ne hẽé naka nqo̱ara kò hãa ne hẽéthẽé qãèkaguè. ");
INSERT INTO nhr_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Si kò ẽem x'áé-dxoom koe kaias qãè-tcao sa xóé. ");
INSERT INTO nhr_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Igabam kò c'ẽem khóèm Simone ta ko ma tciiè ba gaam x'áé-dxoom koe hàna, tsóò-kg'ao kò ii ba, a kò Samaria di ne khóè ne arekagu. A ba a kòo gabá cgáém khóè me e sa koase. ");
INSERT INTO nhr_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ne kò wèé ne khóè ne, ẽe nqãaka hãas téé-q'oos di ne hẽé naka tc'amaka hãas téé-q'oos di ne hẽéthẽé qãèse komsana me, a ne a ko q'aua kg'ui a ko máá: “Ncẽem khóè ba Nqarim di qarian úúa, ncẽe kaia qari ka q'ãasea a,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Gam koe ne ko qãèse komsana, tc'ãòa kuri nem ko séè a ko gam di tsoò-kg'áḿan kàan di cgoa arekagu ne khama. ");
INSERT INTO nhr_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Igaba ẽe ne ko Filipi ba dtcòm̀, ẽem kòo Nqarim di x'aian hẽé, naka Jeso Krestem di cg'õèan hẽéthẽé di qãè tchõàn xgaa-xgaa ka, ka ne kò wèéa ne ga tcguù-tcguuè, kg'áò-khoean ga hẽé naka dxàe-khoean ga hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simonem igabam ko thẽé dtcòm̀, a ba a kò ẽem ko tcguù-tcguuèa xg'ara ka Filipi ba wèé qgáìan ẽem ko qõò koe xùri. A ba a kò ẽem ko are-aresa zi x'áí zi hẽé naka kaia qarian kúrúse ko hẽéthẽé bóò ka kaisase are. ");
INSERT INTO nhr_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eẽ xu ko x'áè úú-kg'ao xu Jerusalema koe hàna xu kóḿ, Samaria di ne khóè nea Nqarim dim kg'ui ba dtcòm̀a hãa sa, ka xu kò Petere ba hẽé naka Johane ba hẽéthẽé tsara tsééa úú cgae ne. ");
INSERT INTO nhr_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ncẽe kò ẽe tsara ko síí ka còrèa máá ne tsara, nxãasega ne gha Tcom-tcomsam Tc'ẽe ba hòò ka. ");
INSERT INTO nhr_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tcom-tcomsam Tc'ẽe ba kò qanega cúía ne koe ga hàà tcãà ta ga hãa khama, ne ko kg'amaga X'aigam Jesom dim cg'õè koe tcguù-tcguuèa. ");
INSERT INTO nhr_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ka tsara kò nxãaska tshàua tsara tòó cgae ne, ne Tcom-tcomsam Tc'ẽe ba hòò. ");
INSERT INTO nhr_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Eẽm ko Simone, Tcom-tcomsam Tc'ẽem ko x'áè úú-kg'ao tsara di tshàuan tòó cgaekus ka máàkuè sa bóò, kam kò marian tcg'òó a máà tsara a, ẽe qaria nem gha x'ámá ka, ");
INSERT INTO nhr_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","a máá: “Eẽ qarian tsao thẽé máà te naka i gha nxãasega wèé khóèan ẽe ra ko tshàua te tòó cgae e Tcom-tcomsam Tc'ẽe ba hòò,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Me Petere xo̱a me a máá: “Maria tsi méé i tsáá cgoa kaà, Nqarim dis máàkus ka tsi tc'ẽea máá, marian cgoa tsi gha x'ámá si, ta tc'ẽea ke! ");
INSERT INTO nhr_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","C'ẽe xòè-coa ga tsi ncẽes tséés koe úú tama, i tcáóa tsi Nqarim cookg'ai koe tchàno tama khama. ");
INSERT INTO nhr_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Gaa domka méé tsi tsari chìbian koe tcóóse naka tsia tsari tsééan cg'ãè tcg'oaragu, naka X'aigam koe còrè, nakam gha ẽeta ii tc'ẽean tcáóa tsi q'oo koe tsi úúa domka qgóóa máá tsi. ");
INSERT INTO nhr_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Cg'ãèan ka tsi cg'oè cgaeèa, a chìbian ka qgóóèa sar ko bóò khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Me Simone xo̱a a máá: “Nxãaska tsao gatsao X'aigam Nqari ba còrèa máá te, naka i gha nxãasega táá ncẽe tsao ko méé cgae te gúùan kúrúse cgae te,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Eẽ tsara ko X'aigam Nqarim dim kg'ui ba nxàea tseegukagu, a ko xgaa-xgaaa xg'ara, ka tsara ko Peterea tsara Johanea tsara Jerusalema koe ka̱bise, a dàòm q'oo koe tsara hãase qãè tchõàn káí xu x'áé-coa xu Samaria di xu koe xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Me nxãaska moengelem X'aigam di ba Filipi ba bìrí a máá: “Tẽe naka koaba nqáè ka qõò, dàòm ncẽe Jerusalema koe guu a ko Gaasa koe qõòm cgoa, ncẽe tchàa-xgóós di ba,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Me xgoaba a qõò, a gaa x'aè kaga dàòm q'oo koe Etiopia dim khóèm cgoa xg'ae, ábà tama kò hãa ba, kaiam mari qgóó-kg'aom Kandakes di ba, x'aigas Etiopia ne di sa. Ncẽem khóè ba kò Jerusalema koe hààraa, a ko hàà Nqari ba còrè. ");
INSERT INTO nhr_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Me kò ẽem xóé a ko gam dis karas q'oo koe hãase dìbia qõò ka porofitim Isaiam dis Tcgãya sa ko nxárá qõò. ");
INSERT INTO nhr_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Me Tcom-tcomsam Tc'ẽe ba Filipi ba bìrí a máá: “Qõò ẽe síí hãas karas koe naka síí qàea sa koe xóén qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Me nxãaska Filipi qàròa síí karas koe, a ba a kóḿ me ko khóè ba porofitim Isaiam koe ko nxárá. Me Filipi tẽè me a máá: “Kóḿa tsi ko q'ãa dùú sa tsi ko nxárá sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Me xo̱a me a máá: “Nta ra gha ma q'ãa, c'ẽe khóè kò qãèse bìrí tchàno-tchano te e tama ne?” témé. A ba a Filipi ba dtcàrà, q'ábàm gha a hàà qàea ba koe ntcõó sa. ");
INSERT INTO nhr_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Eẽm khóè ba kòo ncẽem tceem Nqarim dis Tcgãyas dim koe nxárá, ncẽe kò ncẽeta ma góáèa a ko máá: “Ghùu-coam khamam kò ma cg'õoku dis qgáìs koe chùia úúè, a ba a kò nqoo-nqoosase ko dqòmmèm ghùu-coam khama ma táá xgobekg'am kg'áḿ. ");
INSERT INTO nhr_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Sau-cgaekaguèm gha kam kò táá qãèse qgóóè. Dìí na gha gam dis qhàòs hààkos cgoa kg'ui? Ncẽe nqõómkg'ai koem kg'õèa ba séè cgaeèa ka,” ta i ma góáèa koe. ");
INSERT INTO nhr_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Me ábà tama kò hãam khóè ba Filipi ba tẽè a máá: “Bìrí te, cgóm̀na, dìín ka ba gáé ko porofiti ba kg'ui, gabá ko nxàese kana ba ko c'ẽe khóè ka kg'ui?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Me Filipi tshoa-tshoa a kg'ui, a ba a gaam tceem ẽem cgoa ga tshoa-tshoa a xgaa-xgaa me qãè tchõàn Jesom di ka. ");
INSERT INTO nhr_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eẽ tsara xóé a ko dàòm q'oo koe qõò, ka tsara ko tshàan kò hãam qgáìm koe hàà, kam ko ábà tamam khóè ba máá: “Bóò, tshàan ga ncẽe e. Ka dùúa ko tàà ra tcguù-tcguuè tite?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Me bìrí me a máá: “Ncẽè wèé tcáóa tsi cgoa tsi kòo dtcòm̀ ne i kgoarasea,” témé. Me xo̱a me a máá: “Dtcòm̀ ra ko Jeso Kreste ba Nqarim dim Cóá Me e sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Me x'áèan tcg'òó me kara qáé-kg'ao ba téé. Tsara wèéa tsara ga tshàan q'oo koe tcãà, Filipi ba hẽé naka ábà tamam khóè ba hẽéthẽé e, me Filipi tcguù-tcguu me. ");
INSERT INTO nhr_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eẽ tsara ko tshàan q'oo koe tcg'oas kagam ko kúúga X'aigam Nqarim dim Tcom-tcomsam Tc'ẽe ba Filipi ba séèa tcg'òó, me ábà tamam khóè ba táá gaicara hòò me, igabagam ko kg'ama qõò qãè-tcaoase. ");
INSERT INTO nhr_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Igabam kò Filipi Asetote koe síí hòòse a ko gaa koe caate, a ba a ko wèé xu x'áé xu koe qãè tchõàn xgaa-xgaa, a ba a nxãakg'aiga Kaesarea koe síí tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Eẽ x'aè kam kò Saulo qanega tcg'aì-tcaoa, a X'aigam Nqarim di ne xgaa-xgaase-kg'ao ne cg'õo kg'oana, khamam kò kaiam peresitim koe síí, ");
INSERT INTO nhr_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","a síí dtcàrà me, Damaseko koe hàna xu còrè-nquu xum gha tcgãya zi góá máá sa, ncẽe gha qarian máà me zi, me ẽem kòo Nqarim dim dàòm di ne khóè ne síí hòò ne qáé ne a Jerusalema koe úú ne sa - kg'áò khóèa ga ii kana dxàea ga ii igaba. ");
INSERT INTO nhr_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eẽm gam dis qõòs-q'oo koe hànasem ko Damaseko koe cúù, kam ko kúúga x'áà ba dxùukg'aia ba koe nqarikg'ai koe guu a x'áà. ");
INSERT INTO nhr_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Me cg'áé góḿankg'ai koe, kam ko dòm̀ ba kóḿ me ko máá: ‘Sauloè, Sauloè, dùús domka tsi ko xgàra Tea máá?’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Me Saulo máá: “Dìí Tsia, X'aigaè?” témé. Me xo̱a me a máá: “Tíí Ra a Jeso Ra, ncẽe tsi ko xgàra Ra. ");
INSERT INTO nhr_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ke ncẽeska tẽe naka tsia x'áé-dxoom q'oo koe tcãà, gaa koe tsi gha síí bìríè dùú sa tsi gha kúrú sa ke,” tam ma xo̱a me. ");
INSERT INTO nhr_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Xu kò khóè xu ẽe kò Saulom cgoa hãa xu kg'ama téé káà kg'uise, dòm̀ ba xu kò kóḿ, igabaga xu kò táá cúí khóè ga hòò khama. ");
INSERT INTO nhr_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Me Saulo ba góḿankg'ai koe tẽe, igaba ẽem ko xgobekg'am tcgáí kam kò cúí gúù ga bóò tama. Ka xu ko qgóó me tshàua ba ka, a Damaseko koe úú me. ");
INSERT INTO nhr_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Me kò nqoana cáḿan séè, a táá bóò, a ba a táá c'ẽe gúù ga tc'õó kana kg'áà. ");
INSERT INTO nhr_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Me kò Damaseko koe xgaa-xgaase-kg'aom Ananiase ta ko ma tciiè ba hàna. Me kò X'aigam Nqari ba gam koe x'áíse, a tcii me a máá: “Ananiaseè!” témé. Me xo̱a Me a máá: “Eè, X'aigaè, ncãa ga ra a,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Me X'aiga ba bìrí me a máá: “Jutasem x'áé koe ncẽem tchànom cgoa qõò, naka khóèm Tareso koe guua hãam Saulo ta ko ma tciiè ba tẽè me, hãa a ba a ko còrè ke. ");
INSERT INTO nhr_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","X'áís koem khóèm Ananiase ta ko ma tciiè ba x'áíèa hãa, me tcãà a ko tshàua ba tòó cgae me, tcgáía ba gha bóò ka ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Me kò Ananiase xo̱a Me a máá: “X'aigaè, káí ne khóè ne koer kóḿa hãa ẽem khóèm ka, ntamam kò ma Tsari ne khóè ne tcom-tcomsa ne Jerusalema koe hàna ne koe cg'ãèan kúrú sa. ");
INSERT INTO nhr_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Me ncẽeska ncẽe koe kaia xu peresiti xu di qarian úúa, hààm gha qgóó ẽe ko Tsari cg'õèan tcii ne ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Igabagam kò X'aigam Nqari ba Ananiase ba bìrí a máá: “Ncẽem khóè bar nxárá tcg'òóa máásea hãa a ko hàà tséékagu me, me tãá zi qhàò zi di ne hẽé, naka x'aiga xu hẽé, naka Iseraele di ne khóè ne cookg'ai koe hẽéthẽé cg'õèa Te úúa te. ");
INSERT INTO nhr_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ra gha x'áí me, Tiri cg'õèan domkam gha nta noose xgàrase sa. Ke qõò!” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nxãaskam ko Ananiase qõò a síí nquum q'oo koe tcãà. A ba a Saulom koe tshàua ba tòó a máá: “Sauloè, tíí qõeè, X'aigam Jesom ncẽe kò dàòm q'oo koe tsi hãase ko tsáá koe x'áíse ba tsééa óá tea, nxãasega tsi gha gaicara bóò, a tsi a gha gataga Tcom-tcomsam Tc'ẽem ka cg'oè-cg'oeè ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","I kò kúúga tsoro khama ii gúùan tcgáía ba koe q'õàse, me Saulo gaicara bóò, a ba a tẽe a tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Eẽm ko tc'õóa xg'ara, kam ko gaicara qarian hòò. Saulo ba kò cg'orò cáḿan séè a ba a xgaa-xgaase-kg'ao xu Damaseko koe hàna xu cgoa hàna. ");
INSERT INTO nhr_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","A ba a kò kúúga còrè-nquu xu koe xgaa-xgaa, Jesom Nqarim dim Cóám ii sa. ");
INSERT INTO nhr_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ne kò wèé ne ẽe ko kóḿ me ne are, a ne a tẽè a máá: “Gaam khóèm tama ba gáé ncẽe ba, ncẽe kò Jerusalema koe tshúù sa óágara hãa ba, gane ẽe kòo ncẽem cg'õè ba tcii ne koe? Ncẽe kò ncẽe koe hààra ba, hààm gha khóè ne qáé, a kaia xu peresiti xu cookg'ai koe úú ne ka ba?” ta ne ma tẽèku. ");
INSERT INTO nhr_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Igabagam kò Saulo càùse qarian koe, a Damaseko koe x'ãèa ne Juta ne arekagu, qãèsem kò x'áí ne, Jeso ba nqòòkaguèam Krestem ga Me e sa khama. ");
INSERT INTO nhr_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Káí cáḿan qãá q'oo koe ne kò Juta ne qg'áìku a cg'õo me kg'oana. ");
INSERT INTO nhr_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Igabagam kò Saulo ẽe ne kò kúrú kg'oana hãa sa q'ãakaguè. Ne kò x'áé-dxoom di heke-kg'áḿan ntcùú ba hẽé naka koaba ba hẽéthẽé q'õé, cg'õo me ne gha ka. ");
INSERT INTO nhr_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Igabaga ne kò gam di ne xgaa-xgaase-kg'ao ne ntcùú ka ts'ãàkagu me gàbas koe tcãà me a x'áé-dxoom dim xhàrom tc'amkg'ai koe guu a xhoròkagua ba ka. ");
INSERT INTO nhr_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Eẽm ko Jerusalema koe síí kam ko xgaa-xgaase-kg'ao xu cgoa xg'ae kg'oana, igabaga xu kò wèé xu ga bèe me, a xu a kò xgaa-xgaase-kg'ao me e sa tcom tama. ");
INSERT INTO nhr_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Igabagam kò Barenabase séè a x'áè úú-kg'ao xu koe úú me, a Saulom ntama ma X'aiga ba dàòm q'oo koe bóòa hãas ka bìrí xu, naka X'aigam kò ma kg'ui cgoa me sa hẽéthẽé e. Gatagam kò Damaseko koem kò Saulo ma kgoarasease Jesom cg'õè ka ma xgaa-xgaa sa bìrí xu. ");
INSERT INTO nhr_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nxãaskam ko Saulo hãa cgoa xu, a ba a qõòa te Jerusalema koe, a kgoarasea xóé a X'aigam cg'õè ka kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Juta ne Gerika sa ko kg'ui ne cgoam kò kg'ui a ntcoeku, igabaga ne kò cg'õo me kg'oana. ");
INSERT INTO nhr_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Eẽ ne ko gam di ne khóè ne ncẽes gúù sa bóòa q'ãa ka ne ko séè a Kaesarea koe úú me, a Tareso koe tsééa úú me. ");
INSERT INTO nhr_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Si ko wèés kerekes Jutea di sa hẽé, naka Galilea di sa hẽé, naka Samaria di sa hẽéthẽé tòókuan úúa hãa, a sa a kò qari-qariè, a kò Nqari ba q'áòa hãa, a kò Tcom-tcomsam Tc'ẽem ka ntcàm qaoè, a sa a ko càùse. ");
INSERT INTO nhr_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Eẽm kòo Petere wèé xu xòè xu nqõóm di xu koe qõòa te kam kò Lita dim nqõóm koe ko hàna ne dtcòm̀-kg'ao ne dàra. ");
INSERT INTO nhr_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Gaa koem kò khóèm Enease ta ko ma tciiè ba xg'ae cgoa, nqo̱ara kò hãa ba, 8 kurian kò kgàrom koe xõe ba. ");
INSERT INTO nhr_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Me Petere ba bìrí me a máá: “Eneaseè, Jeso Kreste ba ko qãèkagu tsi, ke tẽe naka tsarim kgàro ba kg'ónò,” témé. Me kúúga tẽe. ");
INSERT INTO nhr_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ne kò wèé ne khóè ne ẽe kò Lita hẽé naka Sarone hẽéthẽé koe x'ãèa hãa ne bóò me, a ne a kò X'aigam Nqarim koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Si kò Jopa koe c'ẽes xgaa-xgaase-kg'ao sa hàna, Tabita ta kò ma tciiè sa. Gerika di cg'õèa sa kò Dorekase ii sa, ncẽe kg'uia tsi kòo ka̱bi i ne tsi ga ‘Tca̱í’ ta ma tcii sa. Ncẽe kò wèé x'aè ka qãè tsééan kúrú a ko dxàua ne khóè ne hùi sa. ");
INSERT INTO nhr_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Gaam x'aèm ẽem kas kò tsàa a sa a x'óó, i kò tc'áróa sa xg'aàè a tc'amaka kò hànam nquum-q'oo koe tòóè. ");
INSERT INTO nhr_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lita dim nqõó ba kò Jopa dim ka cúù me e, khama ne kò ẽe ne ko xgaa-xgaase-kg'ao ne Peterem Lita koe hàna sa kóḿ, ka ne ko cám̀ khóè tsara gam koe tsééa úú, tsara síí dtcàrà me a máá: “Cgóm̀na táá ão guu naka sita koe hàà,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Me kò Petere xgoaba a qõò cgoa tsara a, a ba a ẽem ko gaa koe síí ka tc'amaka hànam nquum-q'oo koe úúè. Wèé zi dxàe-ntcõa zia kò Peterem qàe koe hàà téé a kg'ae, a zi a hã̱aèko xu qgáí xu hẽé naka c'ẽe qgáían hẽéthẽé x'áí me, Dorekases kò gazi cgoa qanega hãa x'aè kas kò qgãea hãa a. ");
INSERT INTO nhr_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Me Petere wèéa ne ga tchàa koe xhàiagu, a ba a qúrùa ba ka ntcõó a còrè. Eẽm ko x'óóas khóès dim tc'áróm koe ka̱bise kam ko máá: “Tabitaè, tẽe!” témé, si tcgáía sa xgobekg'am, a Petere ba bóò a sa a tẽe a ntcõó. ");
INSERT INTO nhr_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Me kò tshàua sa ka séè si a ba a nqàrèa sa ka téékagu si. A ba a dtcòm̀-kg'ao ne hẽé naka dxàe-ntcõa zi hẽéthẽé tciia xg'ae, a kg'õèas hãase x'áí ne si. ");
INSERT INTO nhr_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Si kò ncẽes gúù sa wèém Jopam koe q'ãase, ne káí ne X'aigam Nqarim koe dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Me kò Petere ba Jopa koe, khòo tséé-kg'aom Simone ta ko ma tciièm cgoa tc'ãòa cáḿan séè. ");
INSERT INTO nhr_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kaesarea koem kò khóè ba hàna Koniliase ta kò ma tciiè ba, tc'ãà-cookg'ai me e kò ii, ncõo-kg'ao xu ncẽe kòo Italea ta ko ma tciiè xu di ba. ");
INSERT INTO nhr_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Gabá hẽé naka wèé ne khóè ne x'áéa ba di ne hẽéthẽéa kò Nqari-tcáóa ne khóè ne e, a kò Nqari ba q'áò. Khóè nem kò káí aban máà, a ba a kòo wèé x'aè ka Nqari ba còrè. ");
INSERT INTO nhr_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Me kò c'ẽem koabam ka, nqoana di zi x'aè zi ka, x'áí sa bóò ncẽe gaas koem kò qãèse moengelem Nqarim di ba bóò sa, me ko tcãà, a ko bìrí me a máá: “Koniliaseè,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Me gam koe qãea tòón tcgáí a bóò me, a q'áòs ka tcãàè a máá: “Dùú saà, X'aiga Tseè?” témé. Me xo̱a a máá: “Tsari còrèan hẽé naka tsari aban hẽéthẽéa tc'ẽe-tc'ẽeses iise Nqarim koe tc'amaka qaòa hãa, ");
INSERT INTO nhr_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","ke ncẽeska khóè xu Jopa koe tsééa úú, naka xu síí Simonem ncẽe ko Petere ta ma tciiè ba óá; ");
INSERT INTO nhr_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","c'ẽem Simonem x'áé koem dàra hãa, khòo tséé-kg'ao ba, ncẽe gam dim nquum tshàa-dxoom qàe koe hàna ba ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Eẽm ko moengelem ẽe kò kg'ui cgoa me ba qõò kam kò gam di xu qãà xu ẽe kò tsééa máá me xu koe guu a cám̀ qãà tsara tcii, naka Nqari-tcáóam ncõo-kg'ao ba hẽéthẽé e, ");
INSERT INTO nhr_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","a ba a wèés gúùs ẽe kúrúsea hãa sa bìrí xu, a Jopa koe tsééa úú xu. ");
INSERT INTO nhr_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Xùrikom cáḿ di koaba ka, ẽe xu gaxu dis qõòs koe hãa, a x'áé-dxoom koe cúù xu u, kam ko Petere nquum tco̱be koe q'ábà a síí gaa koe còrè. ");
INSERT INTO nhr_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Si kò xàbà sa tcãà me, me c'ẽe gúù tc'õóm gha tc'ẽe. Eẽ i hãa a ko tsãaguè kam ko sõokuris khama xam̀s gúùs ka tcãàè, ");
INSERT INTO nhr_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","kam ko nqarikg'aian bóò i ko xgobekg'amse, me c'ẽem gúùm qáòm qgáím khama ii ba, gaa koe guu a ko nqãaka xõa, a ko 4 c'ama ba cgoa góḿankg'ai koe xòóè. ");
INSERT INTO nhr_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Gam koe i kò wèé kg'oo-coa-qhàòan hẽé, naka ncãà-kg'aman cgoa ko caate kg'oo-coan hẽé, naka tsa̱rán hẽéthẽé hàna. ");
INSERT INTO nhr_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Me nxãaska dòm̀ ba kóḿ me ko máá: “Tẽe Petereè; cg'õo naka kg'oo,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Igabam kò Petere ba máá: “Eẽ-ẽe X'aigaè, qanegar cg'uriga gúùan tc'õó ta ga hãa kana tc'õokuan kg'ano tama gúùan gar tc'õó ta ga hãa thẽé,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Me kò dòm̀ ba cám̀ dis ka gaicara bìrí me a máá: “Eẽ Nqarim q'ano iise kúrúas ka táá máá, q'ano tama saa, témé guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ncẽe sa kò nqoana q'oro kúrúse, me gúù ba nqarikg'ai koe qháésega séèa ka̱biè. ");
INSERT INTO nhr_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Eẽm Petere qanega hãa a ko are, ẽem ncãa ko bóòs x'áí sa ko dùú sa nxàe sa, ka xu ko kúúga Koniliasem ka tsééèa xu khóè xu hàà heke-kg'áḿs koe téé, Simonem dim nquum ka xu kò tẽèa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Q'au xu kò a tẽè, Simonem ncẽe Petere ta ko ma tciiè ba ẽe koe x'ãèa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Eẽm Petere hãa a ko ẽes x'áís ka tc'ẽe, kam ko Tcom-tcomsam Tc'ẽe ba bìrí me a máá: “Bóò, nqoana xu khóè xu hãa a ko qaa tsi. ");
INSERT INTO nhr_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ke tẽe naka xõa, naka tsia qõò cgoa xu, c'ẽe gúù tc'ẽe-tc'ẽese tamase, Tíí ra tséé xua hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Me Petere xõa a khóè xu koe síí a ba a máá: “Bóò, tíí ga ra a, qaa xao ko ra, dùú sa xao ko qaara máá te?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Xu xo̱a me a máá: “Koniliasem ka xae tsééa óáèa, ncõo-kg'ao xu dim tc'ãà-cookg'ai ba, tchànom khóèm, Nqari ba ko q'áò ba, ncẽe gam ka i ko qãèse kg'uiè ba, wèés qhàòs Juta ne dis ka. Tcom-tcomsam moengelem kam kò q'ãakaguè, tsáá koem gha khóèan tsééa úú, tsi síí tciiè, a gam dim nquum koe hàà, me hàà kóḿ nta tsi ko méé sa ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Me Petere tciia tcãà xu, a x'óm̀-q'ooan máà xu. Q'uu dim cáḿ kam kò tẽe a gaxu cgoa qõò, xu kò c'ẽe xu dtcòm̀-kg'ao xu Jopa di xu qõò cgoa me thẽé. ");
INSERT INTO nhr_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Xùrikom cáḿ ka xu ko Kaesarea koe tcãà, Koniliase ba kò qãà nea, a gam di qhàòan tciia xg'aea, naka ncàm̀am hãa a tòóku cgoa khóèan hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Eẽm ko Petere tcãà kam kò Koniliasem cgoa xg'ae, me nqàrè-kg'ama ba koe cg'áé, a dqo̱m̀ me. ");
INSERT INTO nhr_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Me Petere ghùi me a máá: “Táá ẽeta hẽé guu, khóè ra a, a tsáá khamaga ii ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Eẽm ko kg'ui cgoa me, kam kò tcãà a káí ne khóè ne bóò ne hààra xg'aea. ");
INSERT INTO nhr_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Me bìrí ne a máá: “Gatu igaba tu gatu ka qãèse q'ana hãa, x'áèa nea kgoara máá tama, Juta ba gha c'ẽe zi qhàò zi di ne cgoa xg'ae kana dàra ne sa. Igabam Nqari ba x'áí tea, táá méér cúí khóè ga q'ano tama ia kana kg'amaga di i ta ma tcii guu sa, ");
INSERT INTO nhr_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","khama ẽer ko khóèan tsééa mááèa kar kò xguì tamase kg'ama hàà. Khamar ko ncẽeska tẽè, dùú sar tciia mááèa sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Me Koniliase ba xo̱a a máá: “4 cáḿan ncẽe nqáéa koe, ncẽe x'aèan nqoana di kaga, ra kò hãa a ko tirim nquum koe còrè, kam kò kúúga tca̱à qgáíkom khóè ba cookg'aia te koe hàà téé, ");
INSERT INTO nhr_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","a máá: ‘Koniliaseè, tsari còrèa ne komsanaèa, i tsari aban Nqarim cookg'ai koe tc'ẽe-tc'ẽeseèa. ");
INSERT INTO nhr_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ke nxãaska Jopa koe c'ẽe khóèan tsééa úú naka i Simone ba síí dtcàrà, ncẽe ko Petere ta ma tciiè ba. Simonem khòo tséé-kg'aom x'áé koem hàna, ncẽe tshàa-dxoom qàe koe x'ãèa ba,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ra kò nxãaskaga kúúga khóèan tsáá koe tsééa úú, tsi qãèse hẽé a hààraa. Ta ncẽeska wèéa ta ga ncẽe koe hàna Nqarim cookg'ai koe, a ko hàà komsana wèéan ẽe X'aigam Nqarim x'áè tsia, tsi ko hàà kg'ui i,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Me kò nxãaska Petere tshoa-tshoa a kg'ui cgoa ne a máá: “Tseeguan kagar ko ncẽeska bóòa q'ãa, Nqari ba khóèan tãákase qgóó tama sa, ");
INSERT INTO nhr_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","igaba wèés qhàòs koe, wèém ẽe ko q'áò Me, a ko ẽe tchàno ii sa kúrú bam ko Gam koe qãèse hààkagu. ");
INSERT INTO nhr_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Q'ana tu hãa, Iseraele di ne khóè ne koem kò kg'uian tsééa úúa hãa sa, Jeso Krestem koe guua tòókuan di qãè tchõà nem kòo xgaa-xgaa, ncẽe X'aigam Nqari ba wèéa ne di Me e di i. ");
INSERT INTO nhr_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Eẽ tchõà nea kò Galilea koe tshoa-tshoase a síí Jutea koe tsa̱i-tsa̱ise sa tu q'ana, tcguù-tcguukus ncẽe Johanem kò nxàes koe guu a, ");
INSERT INTO nhr_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ntam ko ma Nqari ba ma Jesom Nasareta di ba ma Tcom-tcomsam Tc'ẽe ba hẽé naka qarian hẽéthẽé cgoa ntcã̱á tcúú sa, ntam ko ma qõòa te a qãèan kúrú sa, naka ẽe wèéa ne ẽe kò dxãwam ka qgóóèa hãa ne khóè ne wèé nem ko ma kg'õèkaguan ka, Nqari ba ko Gam cgoa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ta wèéa ta ga ẽem kúrúa hãas koe nxàea tseegukagu-kg'ao ta a, Juta ne dim nqõóm koe hẽé naka Jerusalema koe hẽéthẽé e. Cg'õo Me ne kò, xgàus koe tceea ba ka, ");
INSERT INTO nhr_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","igabam kò Nqari ba nqoana dim cáḿ ka ghùi Me, a kúrú Mem x'áíse, ");
INSERT INTO nhr_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","wèé khóèan koe tamase, igaba sixae koe ncẽe Nqarim ka ko nxárá tcg'òóèa xae, nxàea tseegukagu-kg'ao xae gha ii ka, ncẽe ko tc'õó, a kg'áà cgoa Me xae, x'ooan koem tẽeas qãá q'oo koe. ");
INSERT INTO nhr_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Me kò x'áè xae e, khóè ne xae gha xgaa-xgaa ka, a Gam ga Me e sa x'áí, Nqarim ka nxárá tcg'òóèa ba, a ba a gha ẽe kg'õèa ne hẽé naka x'óóa ne hẽéthẽé dim Xgàra-kg'ao ba ii ba ka. ");
INSERT INTO nhr_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Wèé xu porofiti xu kò Gam ka nxàea tseegukagu, wèém ẽe ko Gam di cg'õèan koe dtcòm̀ ba gha qgóóa-máákuan chìbian di hòò sa,” tam Petere ba méé. ");
INSERT INTO nhr_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Eẽm Petere qanega hãa a ko kg'ui kam kò Tcom-tcomsam Tc'ẽe ba wèéa ne ẽe kò kg'ui ba komsana ne koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ne kò Juta di ne dtcòm̀-kg'ao ne, ncẽe ko Peterem cgoa hààraa ne kaisas ares ka tcãàè, Tcom-tcomsam Tc'ẽe ba kò abas iise tãá zi qhàò zi di ne koe igabaga thẽé tcãà khama. ");
INSERT INTO nhr_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ne kò kóḿ ne ne ko tãáka xu ta̱m xu cgoa kg'ui, a ko Nqari ba kaikagu khama. Nxãaskam ko Petere máá: ");
INSERT INTO nhr_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“A c'ẽe ba hàna tshàan gha xguì ba, ncẽe ne khóè ne gha táá tcguù-tcguuè ka, ncẽe Tcom-tcomsam Tc'ẽe ba hòòa ne, sita khama?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Me x'áè, khóè ne gha Jeso Krestem dim cg'õèm cgoa tcguù-tcguuè sa. Ne kò dtcàrà me, cáḿ-coa nem gha x'ãè cgoa ne sa. ");
INSERT INTO nhr_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Xu kò x'áè úú-kg'ao xu hẽé naka c'ẽe xu dtcòm̀-kg'ao xu Jutea di xu hẽéthẽé kóḿ, tãá zi qhàò zia gataga thẽé Nqarim di kg'uian dtcòm̀a hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Xu kò nxãaska ẽem ko Petere Jerusalema koe síí ka q'ãe nqãa-qgai khòoèa xu dtcòm̀-kg'ao xu chìbi-chibi me, ");
INSERT INTO nhr_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","a xu a máá: “Q'ãe nqãa-qgai khòoè tama xu khóè xu di nquuan koe tsi tcana, a tsi a gaxu cgoa síí tc'õóa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Me Petere ba tshoa-tshoa a wèé gúùan ma qõòa sa chóà máá xu, a máá: ");
INSERT INTO nhr_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Jopa dim x'áé-dxoom koer kò hàna a ko còrè, kar ko sõokuris q'oo koe bóòkaguè, kaiam qgáím khama iim gúù ba, me nqarikg'ai koe guu a ko xõa ẽer hàna koe, 4 c'ama ba cgoa ko xòóè ba. ");
INSERT INTO nhr_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ra kò qãèse ntcáà me, kar kò kg'oo-coan bóò, x'áéan dian hẽé naka qãáka dian hẽé, naka ncãà-kg'aman cgoa ko caate kg'oo-coan hẽé, naka tsa̱rán hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ra kò dòm̀ ba kóḿ Me ko bìrí te a ko máá: ‘Petereè, tẽe naka cg'õo naka kg'oo,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ra kò xo̱a a máá: ‘Eẽ ẽe X'aigaè, q'ano tama zi hẽé kana tc'õókuan kg'ano tama zi hẽéthẽéa qanega tíí kg'áḿ-q'oo koe tcãà ta ga hãa,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Me kò dòm̀ ba gaia cám̀ di sa nqarikg'ai koe guu a kg'ui a máá: ‘Eẽ Nqarim q'anos iise kúrúas ka táá máá q'ano tama sa témé guu,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ncẽe sa kò nqoana q'oro kúrúse, si wèés gúù sa gaia séèa ghùiè a nqarikg'ai koe ka̱biè. ");
INSERT INTO nhr_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Eẽ x'aè kaga xu kò nqoana xu khóè xu hànar kò hãam nquum koe hàà téé, Kaesarea koe guu a tíí koe tsééèa xu. ");
INSERT INTO nhr_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Me kò Tcom-tcomsam Tc'ẽe ba bìrí te a máá, táá méér tãákase khóèan qgóó guu naka qõò cgoa xu, témé. Xu kò ncẽe xu dtcòm̀-kg'ao xu 6 xu gataga tíí cgoa qõò, xae síí khóèm dim nquum koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Me kò Koniliase ba bìrí xae e, moengele bam ma gam dim nquum-q'oo koe bóòa sa, naka gaam moengelem kò ma x'áè me a máá: ‘Khóèan Jopa koe tsééa úú naka i Simone ba tcii, Petere ta ko ma tciiè ba. ");
INSERT INTO nhr_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kg'uia nem gha óágara máá tsi, ncẽe gha tsáá hẽé naka wèés x'áés tsari sa hẽéthẽé kgoara a ke,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Eẽr ko tshoa-tshoa a ko kg'ui cgoa ne kagam ko Tcom-tcomsam Tc'ẽe ba tcãà cgae ne, ncẽem kò ma kg'aia gatá koe ma tcana khamaga ma. ");
INSERT INTO nhr_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ra nxãaskaga X'aigam Jeso ba nta mééa sa tc'ẽe-tc'ẽese, ncẽem kò máá: ‘Johane ba tshàan cgoa tcguù-tcguua, igaba tu gha gatu Tcom-tcomsam Tc'ẽem cgoa tcguù-tcguuèa,’ témé sa. ");
INSERT INTO nhr_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ncẽè Nqarim kò gatáa cúís aba sa máà ta a, ncẽem kò máà ta as khama ii sa, gatá ncẽe X'aigam Jeso Krestem koe ko dtcòm̀ ta, ne ra tíí nxãaska dìí raà, Nqarim cgoa ga ntcoeku ra?” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Xu ẽe xu ko ncẽe gúùan kóḿ ka táá cúí gúù ga kg'ui, a Nqari ba dqo̱m̀ a máá: “Cèè, Nqari ba gáé gatà thẽé tãá zi qhàò zi gha gane di chìbian koe tcóóse a zi a kg'õèan hòò sa kgoara máána hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stefanem kò cg'õoès qãá q'oo koe ne kò dtcòm̀-kg'ao ne tsa̱i-tsa̱ise, xgàraè ne kòo khama, ka ne kò nqúù ka qõò, Finikia koe hẽé, Kupero koe hẽé naka Antioke koe hẽéthẽé e, a ko Juta ne cúí ne Nqarim di kg'uian bìrí. ");
INSERT INTO nhr_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Igaba i ko c'ẽea xu hàna, khóè xu Kupero di xu hẽé naka Kurene di xu hẽéthẽé e, ẽe xu ko Antioke koe hàà ka xu ko gataga thẽé Gerika ne cgoa kg'ui, a ko X'aigam Jesom di qãè tchõàn xgaa-xgaa ne. ");
INSERT INTO nhr_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Me kò X'aigam Nqarim dim tshàu ba gaxu cgoa hãa, ne kò káí ne khóè ne dtcòm̀, a X'aigam Nqarim koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I kò tchõàn ncẽe Jerusalema koe hànas kerekes koe síí kóḿse, xu Barenabase ba Antioke koe tsééa úú. ");
INSERT INTO nhr_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Eẽm ko hàà a ko hàà cgóm̀kuan Nqarim di bóò, kam ko qãè-tcao, a ba a wèéa ne ga korè, X'aigam Nqarim koe ne gha tseeguse hãa sa, tòón-tcaoase. ");
INSERT INTO nhr_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barenabase ba kò qãèm khóè me e khama, Tcom-tcomsam Tc'ẽem ka kò cg'oè cgaeèa ba, kaisa dtcòm̀an kò úúa ba, ne kò káí ne khóè ne X'aigam Nqarim koe óágaè. ");
INSERT INTO nhr_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Me Barenabase ba Tareso koe qõò, a síí Saulo ba qaa. ");
INSERT INTO nhr_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","A ba a ẽem ko hòò me kaga Antioke koe úú me. Tsara kò Barenabasea tsara Sauloa tsara nxãaska wèém kuri ba hẽé a kerekes di ne khóè ne cgoa xg'ae, a káí ne xgaa-xgaa. Ne kò Nqarim di ne xgaa-xgaase-kg'ao ne Antioke koe tc'ãà a dtcòm̀-kg'ao ne ta ma tciiè. ");
INSERT INTO nhr_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Eẽ x'aè ka xu kò c'ẽe xu porofiti xu Jerusalema koe guu, a xu a ko Antioke koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Me gaxu ka c'ẽem porofitim Agabose ta ko ma tciiè ba tẽe, a ba a Tcom-tcomsam Tc'ẽem ka cg'oè cgaeèase bìrí ne, kaisas xàbà sa gha wèém nqõó ba xõa cgae sa. Si kò ncẽe sa kúrúse Kelaodiam ko Roma koe tc'ãà-cookg'aia x'aè ka. ");
INSERT INTO nhr_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ne xgaa-xgaase-kg'ao ne wèé ne dtcòm̀ku, gane di kg'õè-q'ooan khama ne gha ma gane ka qõesea ne hùi sa, ncẽe Jutea koe hàna ne. ");
INSERT INTO nhr_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ncẽe sa ne kò kúrú, a Barenabasea tsara Sauloa tsara cgoa aban gane di kaia xu koe tsééa úú. ");
INSERT INTO nhr_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Gaa x'aè kam kò x'aigam Herote ba tshoa-tshoa a kerekes di xu c'ẽe xu xgàra. ");
INSERT INTO nhr_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A ba a x'áèan tcg'òó, me kò Jakobom, Johanem ka káímkhoe ba, ntcàum cgoa cg'õoè. ");
INSERT INTO nhr_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Eẽm ko bóò, si ncẽe sa Juta ne tcgáí q'oo koe qãè si i, kam kò còoka qõò, a x'áèan tcg'òó, me Petere ba thẽé qáéè. Cáḿ xu ẽe xua kò péré gãé-gãe úú tamas pérés ko tc'õóè xu cáḿ xu u. ");
INSERT INTO nhr_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Eẽm ko qgóó mea xg'ara kam ko qáé-nquum koe tcãà me, me 4 zi xg'ae zi ncõo-kg'ao xu di zi ka kòreè. Me kò Herote bìríse, Paseka dis kõ̱ès qãá q'oo koem gha khóè ne cookg'ai koe óá me sa. ");
INSERT INTO nhr_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Me kò Petere ba gataga ma qáé-nquum koe kòreè. Igabas kò kereke sa Nqarim cookg'ai koe qarika còrèan kúrúa máá me. ");
INSERT INTO nhr_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Eẽm gha Herote khóè ne koe tcg'òó a úú mem cáḿ dim ntcùúm cookg'ai koem kò Petere cám̀ tsara ncõo-kg'ao tsara xg'aeku koe x'óm̀a, a ba a cám̀ tsara táù tsara cgoa qáéèa, kòre-kg'ao xu ko nquum-kg'áḿ koe hãa, a xu a kò qáé-nquu ba kòre. ");
INSERT INTO nhr_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Igabam kò kúúga moengelem X'aigam Nqarim di ba gam koe hàà téé, me qáé-nquum q'oo koe x'áà ba x'áà. Me Petere ba nxa̱raa ba koe ntcãa-ntcãa, a ghùi me, a máá: “Tẽe qháése,” témé. I táùan q'óḿa ba koe guu a kgoarase. ");
INSERT INTO nhr_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Me moengele ba bìrí me a máá: “Kg'ónòse naka tsia nxàboa tsi nxàbo,” témé. Me gatà hẽé. Me bìrí me a máá: “Hã̱a tsarim qgáí ba naka tsia xùri te,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Me Petere xùri me, a tcg'oa cgoa me. Ncẽe moengelem ka ko kúrúè sa tseegu si i sam kò c'úùa hãa, sõokuris q'oo koem kòo x'áí sa bóò, tam ko tc'ẽea khama. ");
INSERT INTO nhr_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Eẽ tsara ko tc'ãà di kòre-kg'aoan nqáé, a ko cám̀ dian nqáé ka tsara ko síí qano dis heke-kg'áḿs koe tcãà, heke-kg'áḿs x'áé-dxoom koe i ko tcg'oa a sííè sa. Igabas ko kg'ama cuiaga xgobekg'amsea máá tsara a. Tsara tchàa koe tcg'oa, a tsara a c'ẽem dàòm cgoa tcg'oa, me moengele ba kúúga guu me. ");
INSERT INTO nhr_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Eẽm ko Petere síí cuiaga bóòa q'ãa kam ko máá: “Ncẽeskar tseegukaga q'ana hãa, Nqarim Gam dim moengele ba tsééa óágara hãa sa, hààm gha Herotem tshàu-q'oo koe kgoara te ka, naka wèés gúùs Juta ne kò nqòò cgae teas koe hẽéthẽé e,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Eẽm ko ẽes gúù sa tc'ẽea xg'ara kam ko Marias dim nquum koe síí, Johanem ka xõò sa, Mareko ta ko ma tciiè ba. Káí ne khóè nea kò gaa koe xg'aea, a ko còrè. ");
INSERT INTO nhr_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nquu-kg'áḿ bam kò xg'áḿ-xg'am kas ko c'ẽes qãàs, Roda ta ko ma tciiè sa síí komsana. ");
INSERT INTO nhr_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Eẽs ko Peterem dim dòm̀ ba kóḿa q'ãa kagas ko táá síí xgobekg'ama máá me, a qãè-tcaoan domka qàròa tcãà q'oo koe, a sa a síí Peterem nquu-kg'áḿ koe tẽe sa nxàe. ");
INSERT INTO nhr_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ne bìrí si a máá: “Teme si ko,” témé, si gataga cúíga ma bìrí ne, gaan ga a sa. Ne máá: “Gam dim moengele me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Me Petere hãa a nquu-kg'áḿ ba xg'áḿ-xg'am. Xgobekg'am ne kò, a bóò me a kaisase are. ");
INSERT INTO nhr_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Me kò tshàua ba cgoa x'áí ne, nqoo ne gha ka, me chóà máá ne X'aigam Nqarim ma qáé-nquum q'oo koe tcg'òó mea sa. Me bìrí ne a máá: “Ncẽes gúù sa méé tu Jakobo ba bìrí, tíí qõe ga ne hẽéthẽé e,” témé. Kam ko tcg'oa, a tãá qgáì koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Eẽ i ko q'uu kas ko kaias xháé sa ncõo-kg'ao xu koe tcãà, Peterem kas dùú sa kúrúsea di sa. ");
INSERT INTO nhr_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Me Herote qaa a táá hòò me, kam ko kòre-kg'ao xu xgóàse tẽè, a cg'õoè xu gha di x'áèan tcg'òó. A ba a Jutea koe tcg'oa a Kaesarea koe síí, a síí gaa koe ão. ");
INSERT INTO nhr_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herote ba kò Turea tsara Sitonea tsara di ne khóè ne cgoa mẽéku. Gane di tsara nqõó tsara kò Herotem kò tc'ãà-cookg'aiam qgáìm koe guu a gane di tc'õoan hòò. Kas ko xg'aes gane di sa Belasetom koe síí, tcom-tcomsam qãàm x'aigam Herotem di ba, a síí tòókuan dtcàrà. ");
INSERT INTO nhr_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eẽ kò nxárá tòóèam cáḿ kam ko Herote x'aian di qgáían hã̱a, a síí x'aian dis ntcõó-q'oos koe ntcõó, a khóè ne cgoa kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ne kò khóè ne qãè-tcaoan ka q'au a máá: “Ncẽea Nqarim dim dòm̀ me e, khóèm dim tama me e!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herote ba kò Nqari ba táá dqo̱m̀a máá, khamam kò Nqarim dim moengele ba qháése xg'áḿ me, me nxa̱ian ka kg'ooè, a x'óó. ");
INSERT INTO nhr_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Me kò Nqarim dim kg'ui ba càùse a káí. ");
INSERT INTO nhr_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barenabasea tsara Sauloa tsara kò tsééa tsara kúrúa xg'ara ka tsara ko Jerusalema koe ka̱bise, Johane ba tsara ko séè, Mareko ta ko ma tciiè ba. ");
INSERT INTO nhr_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioke koe hànas kerekes q'oo koe xu ko porofiti xu hẽé, naka xgaa-xgaa-kg'ao xu hẽéthẽé xu hàna: Barenabase ba hẽé, naka Simonem ncẽe ko Nigere ta kò ma tciiè ba hẽé (ncẽe kg'uia i ko ka̱biè ne i ko máá, ntcùúm khóè ba téméè ba), naka Lukiom Kurene di ba hẽé, naka Manaenem ncẽe kò tc'ãà-cookg'aim Herotem cgoa xg'ae a kaikaguèa ba hẽé, naka Saulo ba hẽéthẽé xu u kò ii. ");
INSERT INTO nhr_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Hãa a xu a kò X'aiga ba dqo̱m̀ a ko tc'õoan carase, kam ko Tcom-tcomsam Tc'ẽe ba bìrí xu a máá: “Nxárá tcg'òóa máá Te Barenabasea tsara Sauloa tsara, naka tsara tsééan tciia Ra máá tsara síí kúrú,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Eẽ xu ko tc'õoan carase a ko còrèa xg'aras kaga xu ko tshàua xu gatsara koe tòó a tsééa tcg'òó tsara a. ");
INSERT INTO nhr_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Gatsara ẽe kò Tcom-tcomsam Tc'ẽem ka tsééa tcg'òóèa tsara ko Selukia koe qõò, a tsara a gaa koe síí skepe sa q'ábà a tshàam ka nxa̱ma-nxa̱maèam nqõó-coam Kupero dim koe qõò. ");
INSERT INTO nhr_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Tsara Salamise koe síí a gaa koe Nqarim dim kg'ui ba Juta ne di còrè-nquuan koe xgaa-xgaa. Me Johane ba gatsara cgoa hãa gatsara dim hùi-kg'aom iise. ");
INSERT INTO nhr_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Tshàam ka nxa̱ma-nxa̱maèam nqõóm wèém ẽe ba tsara kò caate, a tsara a nxãakg'aiga Pafose dim x'áém koe síí tcãà, a gaa koe Juta dim tsóò-kg'aom cgoa xg'ae, ncẽe kò gataga thẽé tshúù-ntcõa dim porofiti ii ba, Bare-Jeso ta kò ma tciiè ba. ");
INSERT INTO nhr_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Me kò tc'ãà-cookg'aim Seregio Paulom cgoa ko hãa, tc'ẽega kò iim khóè me e. Me Barenabasea tsara Sauloa tsara tcii, Nqarim dim kg'ui bam kò kóḿ kg'oana khama. ");
INSERT INTO nhr_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Igabam ko tsóò-kg'aom Bare-Jeso, Elemase ta ko ma Gerikas ka ma tciiè ba ntcoe tsara a, a ba a gataga tc'ãà-cookg'ai bam gha dtcòm̀an koe tcg'òó sa tc'ẽe. ");
INSERT INTO nhr_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Me nxãaska Saulom, ncẽe kò gataga Paulo ta ma tciiè ba, Tcom-tcomsam Tc'ẽem ka ko cg'oè cgaeèa ba qãea tòón tcgáí Elemasem koe a máá: ");
INSERT INTO nhr_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Tsáá dxãwam di tsi cóá tseè, wèé zi gúù zi tchàno zi di tsi cg'õo-kg'ao tseè! Wèé kàan x'ooan hẽé naka xhùukuan hẽéthẽé di ka cg'oè cgaea tseè, cuiskaga tsi gáé X'aigam Nqarim di dàòan ncẽe tchàno guua hãa tite kàma-kama a tamase? ");
INSERT INTO nhr_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","“Ncẽeska bóò, X'aigam Nqarim dim tshàu ba tsáá cgoa tééa q'aara. Káà tcgáí tsi gha, a gha gataga qáòm x'aè ba séè a táá cáḿs di x'áàn hòò a bóò,” tam méé. Me kúúga qháésega nqa̱ra-nqa̱u sa hẽé naka ntcùú sa hẽéthẽé ka cg'áé-kg'aiè, me qõòa nxa̱ma-nxa̱ma a qgóó-hìi me gha khóèan qaa. ");
INSERT INTO nhr_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Eẽm tc'ãà-cookg'aim ko dùús kúrúsea sa bóò kagam kò dtcòm̀, xgaa-xgaan ẽe X'aigam Nqarim dia ko kaisas are sa tcãà mea khama. ");
INSERT INTO nhr_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pafose koem kò Paulo ba gam ka c'ẽea tsara cgoa skepe sa q'ábà, a Perega koe síí, Pamfilia di i. Me kò Johane síí gaa koe q'aa cgoa tsara a, a Jerusalema koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Perega koe guus ka tsara kò Antioke Pisidia koe hàna koe síí. Ka tsara ko Sabata dim cáḿ ka còrè-nquum q'oo koe tcãà, a tsara a ntcõó. ");
INSERT INTO nhr_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","X'áèan hẽé naka porofiti xu hẽéthẽé di zi tcgãya zi ko nxáráèa xg'ara, ka xu kò còrè-nquum di xu tc'ãà-cookg'ai xu khóèan tsééa úú, i síí dtcàrà tsara a, a máá: “Gaxae ka káíkhoea tsaoè, ghùi-tcáókuan dim kg'ui ba tsao kò úúa, ncẽe khóè ne tsao gaam cgoa x'áè kg'oana ba, ne tsao khóè ne bìrí me,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Me Paulo ba tẽem ko ka, x'õàa ba cgoa nqookagu ne a máá: “Iseraele di tu khóè tuè, naka gatu c'ẽe zi qhàò zi di tu hẽéthẽé e, gatu ncẽe Nqari ba ko q'áò tu, komsana te méé tu! ");
INSERT INTO nhr_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nqarim, Iseraele di ne khóè ne di ba kò gaxae ka xõò ga xu nxárá tcg'òóa máásea, a ko khóè ne di kg'õèan qãèse qõòkagu, Egepeto koe ne ko x'ãèa ka, a ba a ko kaisa qarian cgoa gaam nqõóm koe séèa tcg'òó ne, ");
INSERT INTO nhr_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","a ba a kò 40 khama noo kurian tchàa-xgóós koe gane di kg'óòan qáò-tcaoa máá. ");
INSERT INTO nhr_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","A ba a kò Kanana koe ẽem ko 7 zi qhàò zi cg'õoa xgãá kam ko khóè ne nqõóan gane di máà, q'õò o ne gha ka. ");
INSERT INTO nhr_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“Wèé zi gúù zi ncẽe zia ko 450 khama noo kurian séè. Me kò ncẽe zi gúù zi qãá q'oo koe Nqari ba x'aigan máà ne, i kò nxãakg'aiga porofitim Samuelem di x'aèan síí tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Ne kò khóè ne nxãaska x'aiga ba dtcàrà, Me Nqari ba Saulo ba máà ne, Kishem ncẽe Benjamenem dis qhàòs di ko iim ka cóáse ba, me 40 kurian tc'ãà-cookg'ai ne. ");
INSERT INTO nhr_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saulo bam ko x'aigan koe tcg'òós qãá q'oo koem kò Nqari ba Dafite ba x'aiga ba tòó. A gam ka nxàea tseegukagu a máá: ‘Dafitem Jesem ka cóáse bar hòòa, tcáó-c'õáa te dim khóè me e, tíí ko tc'ẽes gúùs wèé sam gha kúrú,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Ncẽem khóèm dis qhàòs koem kò Nqari ba guu a Kgoara-kg'aom Jeso ba Iseraele ne koe tsééa óá, ncẽem kò ma nqòòkagua khama. ");
INSERT INTO nhr_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesom hàà tamas cookg'ai koem kò Johane ba chìbian koe tcóósean di tcguù-tcguukuan ka wèé ne khóè ne Iseraele di ne xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Eẽm ko Johane tsééa ba cgoa xg'ara qõò kam kò tẽè a máá: ‘Tíí ra dìí ra, ta tu tc'ẽea? Eẽ tu nqòòkaguèar tama ra a, igaba bóò, C'ẽe ba ko qãáa te koe hàà, ncẽe nxàbo tca̱ia ba kgoara gar kg'ano tama ba,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Tíí kíí ga xaoè, a Abrahamam ka cóáse ga xaoè, naka gatu ncẽe ko Nqari ba q'áò tu, qhàò zi di tuè, kg'uian ncẽe kgoarasean dia gatá koe tsééa óágaèa. ");
INSERT INTO nhr_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalema koe x'ãèa hãa ne khóè ne hẽé naka gane di xu tc'ãà-cookg'ai xu hẽéthẽéa kò Jeso ba bóòa q'ãa tama kana kóḿa q'ãa tama. Igaba ne kò chìbi-chibi a xgàra Me, a ne a ko ncẽem dàòm ka porofiti xu di kg'uian tseegukagu, ncẽe wèé cáḿan Sabata di ka ko nxáráè e. ");
INSERT INTO nhr_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Táá xu kò q'ãa, dùútsa dàòm ka xu gha chìbi-chibi a cg'õo Me sa, igaba xu kò Pilato ba dtcàrà, cg'õo Mem gha sa. ");
INSERT INTO nhr_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eẽ xu ko Gam ka ko góásea gúùan wèé tseegukagua xg'ara ka xu ko xgàus tc'amkg'ai koe xòo Me, a tc'ám̀s koe tcãà Me. ");
INSERT INTO nhr_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Igabam kò Nqari ba x'ooan koe ghùi Me. ");
INSERT INTO nhr_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Me kò gataga káí cáḿan ga bóòè ẽe kò ko Gam cgoa Galilea koe guu a ko Jerusalema koe qõò ne ka. Ncẽes noose ga ne gatá di ne khóè ne koe Gam di ne nxàea tseegukagu-kg'ao ne e. ");
INSERT INTO nhr_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Tsam ncẽe koe hààraa, hàà tsam gha qãè tchõàn xgaa-xgaa tu u ka. Nqòòkagukus Nqarim gatá ka xõò ga xu máàna hãa ");
INSERT INTO nhr_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","sam ncẽeska tseegukagua gatá ka, gaxu di ta cóá ta, Jeso ba x'ooan koe ghùian ka. Ncẽe i gataga ma cám̀ dim pesalemam koe ma góásea khama a ko máá: ‘Tsáá Tsia Tiri Tsi Cóá Tsi i; Ra ncẽem cáḿ koe guu a Tsarir Xõò Ra a,’ téméè khama. ");
INSERT INTO nhr_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nqari ba x'ooan koe ghùi Mea, táám gha gaia ts'óó ka, di tseeguan di kg'uian ga ncẽe e Baebeles koe ncẽe ko máá: ‘Tcom-tcomsa a tseegu di ts'ee-ts'eekg'aikua ner gha máà tu u, ncẽe Dafite bar kò gaan ka nqòòkagua a,’ témé e. ");
INSERT INTO nhr_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","I gataga c'ẽe koe ncẽeta ma góásea a ko máá: ‘Cuiskaga tsi tcom-tcomsam Qãàm tsari ba guu, nakam ts'óóa hãa tite,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dafite ba kò gam di x'aèan ka Nqarim ko tc'ẽea sa kúrú, a ba a kò x'óó, a ba a gam ka xõò ga xu cgoa kg'ónòè, i tc'áróa ba ts'óó. ");
INSERT INTO nhr_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Igaba Gaam ẽe Nqarim ka kò x'ooan koe ghùièam di tc'áróa ne kò táá ts'óó. ");
INSERT INTO nhr_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Gaa domka méé xao q'ãa, tíí kíí ga xaoè, qgóóa-máákuan chìbian dia ncẽem Khóèm Jesom koe hàna sa. Ncẽe tchõà nea gaan xgaa-xgaa xao o tsam ko ga a. Moshem di x'áèan qgóóa qari ka tu kò táá tchàno tu iise bóòè, ");
INSERT INTO nhr_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","igabam ko wèém ẽe ko Jesom koe dtcòm̀ ba Gaam domka tchànom iise bóòè. ");
INSERT INTO nhr_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ke méé tu q'õése, nakas táá porofiti xu nxàeas gúù sa kúrúse cgae tu u guu, ncẽe ko máá: ");
INSERT INTO nhr_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Bóò, gatu ntcoe-kg'ao tu, are méé tu naka tua x'óóa xgãáse, hààr gha gatu di xu cáḿ xu ka c'ẽes gúù sa kúrú, c'ẽe ne khóè ne kòo gaas ka bìrí tu u ne tu dtcòm̀ tite sa,’” tam Paulo ba méé. ");
INSERT INTO nhr_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Tsara kò Pauloa tsara Barenabasea tsara còrè-nquum koe guu a ko qõò, ka ne kò khóè ne dtcàrà tsara a, ka̱bise tsara gha a hààkom Sabatam ka gaicara xgaa-xgaa ne sa. ");
INSERT INTO nhr_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Eẽs ko xg'ae sa qõòa q'aa ka ne kò káí ne Juta ne hẽé, naka Nqari-tcáóa ne khóè ne ncẽe Juta di cauan koe dtcòm̀a ne hẽéthẽé, Pauloa tsara Barenabasea tsara xùri, ncẽe ko síí kg'ui cgoa ne, a korè ne, Nqarim di cgóm̀kuan koe méé ne kg'ama gataga cúí ma hãa sa tsara. ");
INSERT INTO nhr_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Xùrikom cáḿ Sabata dim ka ne ko wèé ne khóè ne x'áé-dxoom ẽem di ne hàà ne gha X'aigam Nqarim dim kg'ui ba kóḿ ka qõòa xg'ae ne kò cg'orò ne táá síí. ");
INSERT INTO nhr_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Eẽ ne ko Juta ne xg'ae zi khóè ne di zi bóò, ka ne ko chìi di tc'ẽean ka cg'oè cgaeè, a ne a Paulo ba nco̱i, a ẽem ko kg'ui zi gúù zi ka ntcoeku cgoa me. ");
INSERT INTO nhr_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Tsara nxãaska Pauloa tsara Barenabasea tsara kgoarasease xo̱a xu a máá: “Kg'aia méé tsam ga kò Nqarim dim kg'ui ba gatua bìrí tu us gúù si i. Igabaga tu xguì Mea, a gataga x'áía hãa, chõò tama kg'õèan tu kg'ano tama sa, khama tsam gha ncẽeska tãá zi qhàò zi di ne koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ncẽea X'aigam Nqarim ma x'áè tsama hãa ga a khama a máá: ‘Tãá zi qhàò zi dim x'áà bar kúrú tu ua hãa, nxãasega tu gha Tiri kgoarasean nqõóm chõò-q'oo koe úú ka,’ témé,” ta tsara méé. ");
INSERT INTO nhr_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tãá zi qhàò zi di ne ko ncẽe gúùan kóḿ ka ne ko qãè-tcao, a ne a X'aigam Nqarim dim kg'ui ba dqo̱m̀. Ne kò wèé ne ẽe kò nxárá tcg'òóèa ne chõò tama kg'õèan ne gha hòò ka dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Me kò X'aigam Nqarim dim kg'ui ba wèém nqõóm ẽem koe tsa̱i-tsa̱ise. ");
INSERT INTO nhr_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Igaba ne kò Juta ne tcom-tcomsa zi khóè zi dtcòm̀a hãa zi hẽé, naka x'áé-dxoom di xu tc'ãà-cookg'ai xu hẽéthẽé ntcàma ghùi, a khóè ne kúrú, ne Pauloa tsara Barenabasea tsara cgáé-q'oo koe téé, a ne a gane dim nqõóm koe xhàiagu tsara a. ");
INSERT INTO nhr_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Tsara nxãaska gaa koe ga nqàrè tc'amkg'aia tsara di tsharàn qãè-qãe, a tsara a Ikonio dim nqõóm koe qõò. ");
INSERT INTO nhr_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Gatà i ko ii igaba ne kò xgaa-xgaase-kg'ao ne qãè-tcaoan ka cg'oè cgaeè, Tcom-tcomsam Tc'ẽem ka hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kg'aiga tsara ko hẽé khama tsara ko Pauloa tsara Barenabasea tsara Ikonio koe síí còrè-nquum Juta ne dim koe tcãà. Gaa koe tsara kò qarika kg'ui, ne gaa koe káí ne khóè ne Juta di ne hẽé naka Gerika di ne hẽéthẽé dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Igaba ne kò Juta ne ẽe kò dtcòm̀an xguì ne tãá zi qhàò zi di ne kúrú ne cg'ãè tc'ẽean ka tcãàè, a ne a kò táá dtcòm̀-kg'ao ne cgoa kóḿku. ");
INSERT INTO nhr_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tsara kò Pauloa tsara Barenabasea tsara gaa koe tc'ãòa x'aèan séè a hãa, a tsara a X'aigam Nqarim dim kg'ui ba kgoarasea xóé a kg'ui, Me Nqari ba x'áí Gam di cgóm̀kuan dim kg'ui ba tseegu me ii sa, qarian máà tsara ka, x'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé tsara gha kúrú di i. ");
INSERT INTO nhr_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ne kò khóè ne x'áé-dxoom di ne q'aa-q'aaè. C'ẽe nea kò Juta ne cgoa kóḿkua, ne c'ẽe ne x'áè úú-kg'ao tsara cgoa kóḿkua. ");
INSERT INTO nhr_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Qhàò zi di ne hẽé, naka Juta ne hẽé, naka gane di xu tc'ãà-cookg'ai xu hẽéthẽé ne kò qg'áìkua máá tsara a, xgáè tsara ne gha, a nxõ̱án cgoa xao tsara a ka. ");
INSERT INTO nhr_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Igaba tsara kò gaas kàa sa bóòa q'ãa, a Lukonia di tsara x'áé-dxoo tsara koe bèe a qgóéa síí, Lusetera hẽé naka Derebe hẽéthẽé di tsara x'áé-dxoo tsara koe, naka gatsara x'áé tsara nxa̱ma-nxa̱maa hãa xu x'áé xu koe hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","A tsara a kò gaa koe qãè tchõàn xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lusetera koem kò nqàrèa ba koe kò nqo̱ara hãam khóè ba hàna, kg'aiga kò gataga ma ábàèa ba, a xg'aom ko ntcõó a ábàè ne qõò tama ba. ");
INSERT INTO nhr_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Paulo bam kò komsana ẽem ko ma xgaa-xgaa khama. Me kò Paulo ba qãea tòón tcgáí gam koe, a bóò me me dtcòm̀an úúa hãa kg'õèkagu me gha a. ");
INSERT INTO nhr_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Kam ko q'aua kg'ui cgoa me a máá: “Tẽe naka nqàrè ka téé tchànose!” témé. Me kò gaa x'aè kaga khóè ba tc'ãò ta ma tẽe a tshoa-tshoa a qõò. ");
INSERT INTO nhr_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Eẽ ne ko khóè ne Paulom ncãa kúrús gúù sa bóò ka ne ko Lukonia dis kg'uis cgoa q'au a máá: “Nqárìa ne ncãa xõa-kg'ai ta a, khóèan dis iis koe,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","A ne a kò Barenabase ba Zese ta ma tcii nqárìm tc'amaka ka ba, a Paulo ba Heremese ta ma tcii, kg'ui-kg'ao me e kò ii khama. ");
INSERT INTO nhr_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Me kò peresitim Zesem di ba, ncẽe gam dim tempelem kò x'áé-dxoom cookg'ai koe hãa ba, ghòèan hẽé naka x'aa zi hẽéthẽé óá, heke-kg'áḿs x'áé-dxoom dis koe, gabá hẽé naka khóè ne hẽéthẽéa ko dàòa-mááku zi x'áè úú-kg'ao tsara kúrúa máá kg'oana khama. ");
INSERT INTO nhr_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Igaba ẽe tsara x'áè úú-kg'ao tsara Barenabasea tsara Pauloa tsara kò ncẽes gúùs ka kóḿ ka tsara ko qgáía tsara tòà q'aa, a khóè ne koe qgóéa síí, a tsara a q'au a máá: ");
INSERT INTO nhr_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Khóè tuè, dùúska tu ko hẽéa? Gatsam igaba tsam khóè tsam m gatu khamaga ma ka, qãè tchõàn tsam ko óágara máá tu u, cg'ãa-cg'ana zi gúù zi ncẽe zi méé tu guu, naka kg'õèa hãam Nqarim koe ka̱bise, ncẽe nqarikg'ai hẽé naka nqõókg'ai hẽé naka tshàa ba hẽé naka wèé zi gaan koe hàna zi hẽéthẽé kúrúa ba. ");
INSERT INTO nhr_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ncẽe nqáéa x'aè kam kò wèé zi qhàò zi guu, zi dàòa zi ẽe zi ko ma tc'ẽe khama ma qõò. ");
INSERT INTO nhr_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Gatà i ii igabam kò nxàea tseegukagu, hàna baa sa, qãè zi gúù zi kúrúan ka, a ba a nqarikg'ai koe guu a túúan máà tu u, naka tc'õoan ko tcuùè x'aèan hẽéthẽé e, a ba a kò tcáóa tu tc'õoan cgoa xg'ãàkagu, a qãè-tcaokagu tu u,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ncẽeta xám̀ kg'uian tsara ko kg'ui igaba i kò qaria máá tsara a, xgáè-kg'am ne tsara ga sa, dàòa-máákuan kúrúa máá tsara an koe. ");
INSERT INTO nhr_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Nxãaska ne ko c'ẽe ne Juta ne Antioke koe hẽé naka Ikonio koe hẽéthẽé guua ne xg'ae sa kg'uia tàà a máá, Pauloa tsara tshúù tsara a, témé. Ne kò Paulo ba nxõ̱án cgoa xg'áḿ, a ne a x'áé-dxoom ka tchàa za tcéèa tcg'òó me, x'óóa baa, ta ne kò tc'ẽea khama. ");
INSERT INTO nhr_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Igaba ẽe xu ko xgaa-xgaase-kg'ao xu ko qàea ba koe nxa̱ma-nxa̱ma me kagam ko tẽe, a ba a x'áé-dxoom koe ka̱bise. Xùrikom cáḿ kam ko gabá hẽé naka Barenabase ba hẽéthẽé tsara Derebe koe qõò. ");
INSERT INTO nhr_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","A tsara a gaam x'áé-dxoom koe qãè tchõàn xgaa-xgaa, a káí xgaa-xgaase-kg'aoan hòò. Nxãaska tsara ko Lusetera koe hẽé naka Ikonio koe hẽé naka Antioke koe hẽéthẽé ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","A tsara a síí xgaa-xgaase-kg'aoan qari-qari, a ntcàm ne, dtcòm̀an koe ne gha qgóóa qari ka. Tsara bìrí ne a máá: “Káí xgàrakuan koe méé ta hãa naka nxãatama Nqarim di x'aian koe tcãà,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ne kò kaia xu wèés kerekes koe nxárá tcg'òóa mááse. A ne a còrè a tc'õoan carase a ne a Nqarim cookg'ai koe tòó xu, ncẽe Gam koe xu dtcòm̀a hãa ba. ");
INSERT INTO nhr_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Eẽ tsara ko Pisidia tchoaba ka tsara ko Pamfilia koe hàà, ");
INSERT INTO nhr_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","a ko Perega koe Nqarim dim kg'ui ba xgaa-xgaa, ka tsara ko Atalia koe xõa. ");
INSERT INTO nhr_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A tsara a kò gaa koe guu a skepes cgoa Antioke koe síí, ncẽe khóè ne kò gaa koe còrèa máá tsara a koe a ne a kò Nqarim di cgóm̀kuan di qarian dòm̀ q'oo koe tsééa úú tsara a, tséés ẽe tsara kò ncẽeska xg'ara-xg'ara hãas koe. ");
INSERT INTO nhr_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Gaa koe tsara ko tcãà ka tsara ko kereke sa xg'ae-xg'ae, a tsara a wèé gúù ẽem Nqari ba kúrú cgoa tsaraà nxàe, naka Nqarim ma tãá zi qhàò zi di ne heke-kg'áḿs dtcòm̀an di sa kgoara máána hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Gaa koe tsara kò xgaa-xgaase-kg'ao ne cgoa qáòm x'aè ba séè a hãa. ");
INSERT INTO nhr_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Xu kò c'ẽe xu khóè xu Jutea koe guu a Antioke koe dtcòm̀-kg'ao ne síí xgaa-xgaa, a kò máá: “Moshem di x'áè-kg'áḿan ka xao ko q'ãe nqãa-qgai khòoè tama ne xao cuiskaga kgoaraè tite,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ncẽe sa kò Paulo ba hẽé naka Barenabase ba hẽéthẽé tsara kúrú tsara ntcoeku cgoa xu, a qarika tẽèku cgoa xu. Tsara kò Paulo ba hẽé naka Barenabase ba hẽéthẽé tsara, c'ẽe xu dtcòm̀-kg'ao xu cgoa nxárá tcg'òóè, Jerusalema koe xu gha qõò ka, a x'áè úú-kg'ao xu hẽé naka kaia xu koe hẽéthẽé síí ncẽes tẽès ka kg'ui ka. ");
INSERT INTO nhr_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Si kò kereke sa tsééa tcg'òó xu, xu ko Finikia koe hẽé naka Samaria koe hẽéthẽé tcãà, a xu a nxàe, nta ne ma tãá zi qhàò zi di ne Nqarim koe ka̱bisea hãa sa. Ncẽe tchõà nea kò wèé ne dtcòm̀-kg'ao ne kúrú ne kaisase qãè-tcao. ");
INSERT INTO nhr_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Eẽ xu ko Jerusalema koe tcãà ka xu kò kereke sa hẽé naka x'áè úú-kg'ao xu hẽé naka kaia xu ka hẽéthẽé qãèse hààkaguè. A tsara a kò ẽem Nqari ba gatsara koe kúrúa hãa zi gúù zi wèé zi nxàe. ");
INSERT INTO nhr_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Igaba ne kò c'ẽe ne dtcòm̀-kg'ao ne ncẽe kò Farasai xu dis xg'aes koe hãa ne tẽea-téé a máá: “Nqõóm di zi qhàò zi di ne méé ne q'ãe nqãa-qgai khòoè, naka nea bìríè Moshem di x'áè-kg'áḿan méé ne qgóóa qari sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Xu kò x'áè úú-kg'ao xu hẽé naka kaia xu hẽéthẽé xu ncẽes tchõà sa xg'aea máá a nxàe. ");
INSERT INTO nhr_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Me kò Petere kaias nxàes qãá q'oo koe tẽea-téé a bìrí xu a máá: “Tíí ka c'ẽe xaoè, q'ana xao hãa me kò kg'aiaka x'aè ka Nqari ba gatu xg'aeku koe nxárá tcg'òó sa kúrúa hãa, tíí kg'áḿ koe ne gha tãá zi qhàò zi di ne guu a qãè tchõàn kóḿ sa, a ne a dtcòm̀ ka. ");
INSERT INTO nhr_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Nqarim ncẽe khóèm dis tcáó sa q'ana ba ko x'áí ne, qãèsem ko hààkagu ne sa, Tcom-tcomsam Tc'ẽe ba máà ne ka, ncẽem kò sixae ka hẽé khama. ");
INSERT INTO nhr_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Sita hẽé naka gane hẽéthẽé xg'aeku koem kò cúí q'aa-q'oo ga táá kúrú, gane di tcáóa nem kò dtcòm̀an cgoa q'ano-q'ano khama. ");
INSERT INTO nhr_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Dùús domka xao ko Nqari ba kúrúa bóòa máá? Dùús domka xao ko xgaa-xgaase-kg'ao ne qg'áó koe jokoan xòó, ncẽe gaxae kana gaxae ka xõò ga xu xu kò gaan dcẽé ka tààè e? ");
INSERT INTO nhr_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Igaba xae ko tseeguan kaga dtcòm̀, cgóm̀kuan X'aigam Jesom di ka ta gha gane khamaga ma kgoaraè sa,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Xu wèé xu khóè xu nqoo, a Barenabasea tsara Pauloa tsara komsana, tsara ko ma x'áí zi hẽé naka are-aresa zi gúù zi hẽéthẽé ma nxàe sa, ẽem kò Nqari ba tãá zi qhàò zi di ne koe gatsara ka kúrúa zi. ");
INSERT INTO nhr_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Eẽ tsara ko kg'uia xg'ara kam ko Jakobo xo̱a a máá: “Tíí ka c'ẽe xaoè, komsana te xao: ");
INSERT INTO nhr_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simone ba ko nxàe, me ma Nqari ba ma tãá zi qhàò zi di ne ma kg'aia dàra hãa sa, gaa zi koem gha cg'õèa ba domka khóè ne nxárá tcg'òóa mááse ka. ");
INSERT INTO nhr_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kg'uian porofiti xu di igabaga i ko ncẽes gúùs cgoa dtcòm̀ku, ncẽe i ma ncẽeta ma góáèa koe, ncẽem ko Nqari ba máá: ");
INSERT INTO nhr_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ncẽe zi gúù zi qãá q'oo koer gha ka̱bise, a Ra a gha Dafitem dim nquu ba ka̱base tshào, ncẽe cg'áéa ba. Eẽ cg'áéa hãa xòèa ba Ra gha gaia tshàoa ghùi, a gha kúrú me me tchànose téé, ");
INSERT INTO nhr_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","nxãasega ne gha ẽe qaùa ne khóè ne X'aigam Nqari ba qaa ka, naka wèé ne tãá zi qhàò zi di ne hẽéthẽé e, ncẽe cg'õèa Te ka ko tciiè ne. ");
INSERT INTO nhr_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Nqarim ko ma kg'ui i, ncẽe ko ncìísega ncẽe zi gúù zi nxàea tcg'òó zi q'ãaèa ba,’ tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Gaa domkaga ra bóòa tcg'òóa, a ko còo dis ka ko máá: Ncẽè tãá zi qhàò zi di ne kò Nqarim koe ka̱bise ne méé ta táá xgáè ne guu. ");
INSERT INTO nhr_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Igaba méé xae góá máá ne, naka ne táá kúrú mááseèa nqárìan máàèa hãa zi gúù zi tc'õó guu, naka nea gataga táá cg'áràn kúrú guu, naka nea táá chúú-chuuèa kg'oo-coan di kg'òóan kg'oo guu, naka nea táá c'áòan tc'õó guu. ");
INSERT INTO nhr_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ncìísega i ko Moshem di x'áèan x'áé-dxoo xu koe xgaa-xgaaè, ncẽe i ko ma còrè-nquuan koe wèé Sabatan ka nxáráè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ka xu ko nxãaska x'áè úú-kg'ao xu hẽé, naka kaia xu hẽé, naka wèés kereke sa hẽéthẽé bóò i qãè e, cám̀ khóè tsara ne gha xg'aes koe guu a nxárá tcg'òó, a Paulo ba hẽé naka Barenabase ba hẽéthẽé tsara cgoa Antioke koe tsééa úú sa. Jutasem ncẽe kò Baresabase ta ma tciiè ba hẽé naka Silase ba hẽéthẽé tsara kò nxárá tcg'òóè, ncẽe kò dtcòm̀-kg'ao ne ka kaisase tcommèa hãa tsara. ");
INSERT INTO nhr_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ka xu ko tcgãyas ncẽeta ma góásea hãa sa gatsara cgoa tsééa úú, ncẽe ko máá: “Gaxae x'áè úú-kg'ao xae hẽé naka kaia xae hẽéthẽéa ko, gataga gatu ka káíkhoe ga xae ko tsgám̀kagu tu u, gatu dtcòm̀-kg'ao tu tãá zi qhàò zi di tu, Antioke koe hẽé, Siria koe hẽé, naka Kilikia koe hẽéthẽé hàna tu, a xae a ko máá: ");
INSERT INTO nhr_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Gaxae ka c'ẽea xua gaxae dis xg'aes koe tcg'oara hãa sa xae kóḿa hãa, a xu a kg'uian cgoa tcg'ome tcúú tua, a tshúù-tshuu tc'ẽe tua sa, gaxae x'áèan máà xu tama koe. ");
INSERT INTO nhr_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Gaa domka xae xg'ae a dtcòm̀kua, a cám̀ tsara khóè tsara nxárá tcg'òóa, a gatu koe tsééa úúa hãa, gaxae di tsara ncàm̀-khoe tsara Barenabasea tsara Pauloa tsara cgoa tsara gha qõò ka, ");
INSERT INTO nhr_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","khóè tsara ncẽe kò gatá dim X'aigam Jeso Krestem domka gatsara di kg'õèan cg'oè-cg'oegam qgáìm koe tcana hãa tsara. ");
INSERT INTO nhr_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Gaa domka xae ko Jutase ba hẽé naka Silase ba hẽéthẽé tsara gatu koe tsééa úú, síí tsara gha ncẽe koe xae góáa hãas gúù sa kg'áḿa tsara ka chóà máá tu u ka. ");
INSERT INTO nhr_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tcom-tcomsam Tc'ẽe ba hẽé naka gaxae hẽéthẽéa kò bóò i qãèa máá xaea hãa, táá méé xae cúí gúù qóḿ ga xgàmkagu tu u guu sa, ncẽe zi gúù zi gatu koe ko qaase zi ka oose, ncẽe ko xùri zi: ");
INSERT INTO nhr_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","táá méé tu kúrú mááseèa nqárìan ko máàè tc'õoan tc'õó guu, naka tua c'áòan tc'õó guu, naka tua táá chúú-chuu a cg'õoè kg'oo-coan kg'oo guu. Naka tua gataga táá cg'áràn kúrú guu. Ncẽe x'áè-kg'áḿan tu kò ko xùri ne tu gha ko qãèse hẽé. Qãèse tu hãa.” ");
INSERT INTO nhr_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Eẽ xu ko tsééa tcg'òóè ka xu kò Antioke koe síí tcãà, a xu a kò gaa koe khóè ne xg'ae-xg'ae, a tcgãya sa máà ne. ");
INSERT INTO nhr_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Eẽ ne ko nxárá si ka ne kò ghùi-ghui-tcáókuan di kg'uian qãè-tcaoa máá. ");
INSERT INTO nhr_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ka tsara kò Jutasea tsara Silasea tsara, porofiti tsara a kò ii khama qáò x'aèan séè a dtcòm̀-kg'ao ne cgoa kg'ui, a ghùi-ghui tcáó ne, a qari-qari ne. ");
INSERT INTO nhr_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Eẽ tsara kò gaa koe x'aèan séèa hãa, ka tsara kò dtcòm̀-kg'ao ne ka tòókuan cgoa tsééa ka̱biè, a tsara a kò gane ẽe kò tsééa úú tsara hãa ne koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Igaba i ko Silase ba qãèa máá gaa koem gha qaù sa. ");
INSERT INTO nhr_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Igaba tsara ko Pauloa tsara Barenabasea tsara Antioke koe qaù, ncẽe gatsara hẽé naka káí ne khóè ne c'ẽe ne hẽéthẽé kò X'aigam Nqarim di qãè tchõàn xgaa-xgaa koe. ");
INSERT INTO nhr_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Cg'orò cáḿan qãá q'oo koem kò Paulo Barenabase ba bìrí a máá: “Hààn tsam ka̱bise naka tsama síí wèé xu x'áé-dxoo xu koe gatsam ka c'ẽe ne kabi, ncẽe tsam kò X'aigam dim kg'ui ba xgaa-xgaa hãa xu, naka bóò nta ne ma hãa sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Me kò Barenabase tc'ẽe, Johanem ncẽe Mareko ta kò ma tciièm cgoa tsara ga qõò sa. ");
INSERT INTO nhr_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Igabam kò Paulo tc'ẽe a bóò, i qãèa máá tsara tama gatsara cgoam gha qõò sa, Pamfilia koem kò q'aa cgoa tsara a, a kò táá còoka tsééa qõò cgoa tsara a khama. ");
INSERT INTO nhr_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Kas kò kaisas ntcoekus tshúù sa tẽe, tsara kò gaa koe ga q'aa. Me Barenabase ba Mareko ba séè, a ba a Kupero koe skepes cgoa qõò. ");
INSERT INTO nhr_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Me Paulo Silase ba nxárá tcg'òóa mááse, a ba a xgoaba, ne kò dtcòm̀-kg'ao ne còrèa máá tsara a, Nqarim di cgóm̀kuan gha hãa cgoa tsara a ka, ");
INSERT INTO nhr_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","tsara kò Siria hẽé naka Kilikia koe hẽéthẽé tcana nqáé a kò gaa koe kereke zi qari-qari. ");
INSERT INTO nhr_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Me kò Paulo gataga Derebe koe qõò, a síí Lusetera koe tcãà. Gaa koem kò c'ẽem xgaa-xgaase-kg'aom Timoteo ta kòo ma tciiè ba x'ãèa, ncẽe xõòs kò Juta dis qhàòs di ii, a dtcòm̀-kg'ao sa ii, me xõò ba Gerika dis qhàòs di ii ba. ");
INSERT INTO nhr_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Dtcòm̀-kg'ao ne Lusetera hẽé naka Ikonio hẽéthẽé di nea kò ko qãè zi gúù zi gam ka kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Me kò Paulo ba tc'ẽe, Timoteom gha xùri me sa, khamam kò séè me a q'ãe nqãa-qgai khòo me, Juta ne ẽe zi nqõó zi koe hàna ne domka, xõò ba Gerika me e sa ne kò wèéa ne ga q'ana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Eẽ xu ko ma x'áé-dxoo xu koe ma qõòa te khama xu kò ma x'áè úú-kg'ao xu hẽé naka kaia xu Jerusalema koe hàna xu hẽéthẽé xu kúrúa hãa x'áèan bìrí ne, a xu a qarika méé ne qgóó o sa bìrí ne. ");
INSERT INTO nhr_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Zi kò kereke zi dtcòm̀an koe qari-qariè, a wèé cáḿ ka càùse. ");
INSERT INTO nhr_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Xu Ferugia hẽé naka Galatia hẽéthẽé di xu xg'aeku xu koe qõò, Asia dim xg'aekum koe xu ga kg'ui ba xgaa-xgaa sam kò Tcom-tcomsam Tc'ẽe ba cara xua hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Eẽ xu ko Misia dim xg'aekum koe cúù, ka xu kò Bitunia dim xg'aekum koe xu gha tcãà sa x'ãà máá, igabam kò Jesom dim Tc'ẽe ba táá kgoara máá xu. ");
INSERT INTO nhr_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Khama xu kò Misia dim xg'aekum koe tcana nqáé, a Teroa dim x'áé-dxoom koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Eẽm ntcùúm kam kò Paulo Maketonia dim khóèm dis x'áí sa bóòkaguè, me téé-tẽe a ko dtcàrà me a ko máá: “Tchoaba naka Maketonia koe hàà hùi ta a,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Eẽm ko Paulo ẽes x'áí sa bóòa xg'ara ka xae kò qháése Maketonia koe xae gha síí sa kg'ónòsea máá, gaa koe xae gha qãè tchõàn síí xgaa-xgaa ne sam kò Nqari ba tciia máá xaea hãa sa xae kò bóòa tcg'òóa khama. ");
INSERT INTO nhr_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Teroa koe xae ko skepes cgoa guu ka xae kò tchànose Samoterake koe qõò, a xùrikom cáḿ ka Neapolise koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Gaa koe xae kò guu a Filipi koe síí tcãà, kaiam x'áé-dxoom Maketonia dim xg'aekum di ba, Roma dim nqõóm di qarian dòm̀ q'oo koe hãa ba. Eẽm x'áé-dxoom koe xae kò cg'orò cáḿ-coan séè. ");
INSERT INTO nhr_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sabata dim cáḿ ka xae kò x'áé-dxoom dis heke-kg'áḿs koe tcg'oa, a tshàam koe síí, còrè di qgáìa ne ko gaa koe hàna, ta xae kò tc'ẽea khama. Khóè zi ẽe kò gaa koe xg'aea hãa zi cgoa xae kò ntcõó a kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Gazi ka c'ẽe sa kò Lidia si i, Tiatira dim x'áé-dxoom di sa, Nqari ba kòo còrè sa, ncẽe kò ko nco̱à a tca̱àko qgáían t'õè x'ámágu sa. Paulom ko kg'ui zi gúù zis kò qarika komsana, Nqari ba kò xgobekg'am tcáó sia hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Eẽ ne ko gasá hẽé naka gas dim x'áé-q'oom di ne hẽéthẽé tcguù-tcguuè, kas ko x'áéa sa koe tciia úú xae e, a máá: “Ncẽè X'aigam Nqarim koe dtcòm̀ar khóèr ii sa xao kò bóòa hãa ne méé xao nxãaska x'áéa te koe hàà, naka tíí cgoa hãa,” témé. A kò qarika dtcàrà xae e, xae síí cgae si. ");
INSERT INTO nhr_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","C'ẽem cáḿ ka, ẽe xae xóé a ko còrè dim qgáìm koe qõò ka xae kò qãàs cgoa xg'ae, ncẽe kò tc'ẽean úúa sa, hààko zi gúù zi gha nxàe di i sa, ncẽe kò ko hààko kúrúse zi gúù zi nxàean ka gas ka q'õòse ga ne káí marian kúrúa máá sa. ");
INSERT INTO nhr_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ncẽes cóá sa kò Pauloa xae q'aua xùri, a ko máá: “Ncẽe xu khóè xua kaisase tc'amaka hãam Nqarim di xu qãà xu u, ncẽe ko kgoarase tu gha di dàòan ka bìrí tu u xu,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Káí cáḿa nes kò séè a ncẽes gúù sa kúrú, me Paulo xg'aì a ba a ka̱bise a dxãwa tc'ẽe ba bìrí a máá: “Jeso Krestem cg'õè kar ko bìrí tsi, a ko máá, gas koe méé tsi tcg'oa,” témé. Me dxãwa tc'ẽe ba gaa x'aè kaga tcg'oa cgae si. ");
INSERT INTO nhr_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Eẽ xu ko q'õòsea xu bóòa q'ãa, gaicara xu marian hòò tite sa, ka xu ko Pauloa tsara Silasea tsara qgóó a x'ámágu dis qgáìs koe úú, tc'ãà-cookg'ai xu koe. ");
INSERT INTO nhr_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Eẽ xu ko Roma di xu kaia xu cookg'ai koe síí cgoa tsara a ka xu kò máá: “Ncẽe tsara khóè tsara Juta tsara a, a ko x'áé-dxoom koe ncõoan kúrú, ");
INSERT INTO nhr_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","a tsara a ko gataga tãá cauan khóè ne xgaa-xgaa, Roma di ta khóè ta di x'áèan koe tc'ẽese tama a, ta dtcòm̀ m tama,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Si kò xg'aes khóè ne di sa thẽé qaru cgae tsara a, xu kò Roma di xu kaia xu qgáían méé tsara tcg'òó cgaeè naka qoaè sa x'áè. ");
INSERT INTO nhr_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Eẽ tsara ko thõòkase xg'áḿmèa xg'ara ka tsara kò qáé-nquum koe tcãàè, me kò kòre-kg'ao ba qãèse méém kòre tsara a sa x'áèè. ");
INSERT INTO nhr_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eẽm kò máàèa hãa x'áèa nem kò tséékagu, a ba a kò q'oo koe hànam qáé-nquu-coam q'oo koe tcãà tsara a, a hìi-tcúrían koe nqàrèa tsara qáéa ntcòo. ");
INSERT INTO nhr_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ntcùú nqáè ka tsara ko Pauloa tsara Silasea tsara còrè, a Nqari ba ciian nxáèa máá, xu kò c'ẽe xu khóè xu qáéèa kò hãa xu kóḿ tsara a. ");
INSERT INTO nhr_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Si kò kúúga kaias cgùrus nqõóm di sa kúrúse, si kò qáé-nquum ko tc'amkg'aia sa koe tshàoèa hãas tshoa-tshoase-q'oo sa ko̱ri, i kúúga wèé qáé-nquuan di kg'áḿan xgobekg'amse, i wèém khóèm di táùan kgoarase. ");
INSERT INTO nhr_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Eẽm ko qáé-nquum dim kòre-kg'ao ba tẽe kam kò bóò i qáé-nquum di kg'áḿan xgobekg'amsea hãa, kam ko ntcàu ba tsgúùa tcg'òó a cg'õose ka hẽé, khóè xua qgóéa hãa, tam kò tc'ẽea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Igabam kò Paulo ba kaisase q'au a máá: “Táá tshúù gúù kúrú cgaese guu, wèéa xae ga ncẽe koe hàna ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Me qáé-nquum dim khóè ba x'áà-x'aa-kg'ai cgoa dis gúù sa dtcàrà a qháése tcãà, si kò cgùru sa tcãà me, me kò Pauloa tsara Silasea tsara nqàrè-kg'am koe cg'áé. ");
INSERT INTO nhr_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","A ba a tchàa koe tcg'òó tsara a, a tẽè tsara a, a máá: “Khóè tsaoè, dùú sa ra gha kúrú a nxãasega Nqarim di kgoarakuan hòò?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Tsara xo̱a me a máá: “X'aigam Jesom koe dtcòm̀, tsáá hẽé naka x'áéa tsi di ne hẽéthẽé tu, nxãaska tu gha kgoaraè ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ka tsara kò X'aigam Nqarim dim kg'ui ba gabá hẽé, naka wèé ne ẽe kò gam x'áé koe hàna ne hẽéthẽé bìrí. ");
INSERT INTO nhr_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Eẽm ntcùúm kagam kò qáé-nquum dim kòre-kg'ao ba séè tsara a, a síí gatsara di chìbian xg'aà-kg'am, ne kò gaa x'aè kaga gabá hẽé naka gam dis x'áé-q'oos di ne hẽéthẽé tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","A ba a gam dim nquum koe úú tsara a, a tc'õoan máà tsara a. Gabá hẽé naka gam dis x'áé-q'oos di ne hẽéthẽéa kò qãè-tcaoan ka cg'oè cgaeè, ncẽeska ne Nqarim koe dtcòm̀a hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Xùrikom cáḿ ka ntcùúkg'ai cgoa di x'aè ka xu kò Roma di xu kaia xu x'áèan pirisean cgoa tsééa úú ncẽe kò máá: “Eẽ tsara khóè tsara kgoara naka tsara qõò,” témé e. ");
INSERT INTO nhr_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Me qáé-nquum dim kòre-kg'ao ba gaa kg'uian Paulo ba bìrí a máá: “Kaia xu ncãa kgoaraè méé tsao di x'áèan tcg'òó, ke tsao ncẽeska tòókuan cgoa tcg'oa naka qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Igabam kò Paulo bìrí xu a máá: “Khóè ne cookg'ai koe ne kò xg'áḿ tsam m, qãèse tẽèa cgáé-cgae naka chìbi-chibi tsam m tamasega, Roma di tsam khóè tsam m igaba, a kò qáé-nquum koe tcãà tsam m, ka xua ko ncẽeska ts'ãà ka tcg'òó tsam m sa tc'ẽe? Cuiskaga a! Gaxu méé xu hàà naka hàà gaxu ka tcg'òó tsam m,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Pirise xua kò Roma di xu kaia xu ncẽe kg'uian bìrí. Eẽ xu ko Roma di tsara khóè tsara ii sa kóḿ ka xu kò q'áò, ");
INSERT INTO nhr_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","a xu a hàà qgóóa-máákuan dtcàrà, a tcg'òó tsara a, a dtcàrà tsara a, x'áé-dxoom koe tsara gha tcg'oa sa. ");
INSERT INTO nhr_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Tsara ẽe tsara ko qáé-nquum koe guu ka Lidia sa dàra, ka tsara kò gaa koe dtcòm̀-kg'ao ne cgoa xg'ae, a tsara a ghùi-ghui tcáó ne ko kg'uian máà ne, a xgoaba. ");
INSERT INTO nhr_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Eẽ tsara ko Pauloa tsara Silasea tsara Amfipolise hẽé naka Apolonia hẽéthẽé tchoaba ka tsara kò síí Juta ne dim còrè-nquum Tesalonika koe hàna hãam koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Me Paulo caua ba a kò ii khama síí còrè-nquum q'oo koe tcãà, a nqoana xu cáḿ xu Sabata di xu séè a qarika khóè ne cgoa kg'ui, Nqarim di zi Tcgãya zi koe guu a. ");
INSERT INTO nhr_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","A ba a ka̱bi, a bìría kg'ónò ne, qaase i ko Krestem ncẽe nqòòkaguèa ba méém xgàrase naka ba x'ooan koe tẽe sa. Bìrí nem kò a máá: “Jesom ncẽer ko bìrí tu u ba, Gaam Krestem ga Me e,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Ne kò c'ẽe ne Juta ne ncẽe kò ncẽe gúùan kóḿ ne kaisase nxùrù-tcáóa máá Pauloa tsara Silasea tsara xùria ne. Kaias xg'aes Nqari ba ko còrè ne Gerika ne di sa hẽé, naka káí zi khóè zi tc'amaka hàna téé-q'ooan di zi hẽéthẽé e kò ii. ");
INSERT INTO nhr_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Igaba ne kò c'ẽe ne Juta ne tau di ne e khama ne kò c'ẽe ne khóè ne dàòan qàe koe x'ãèa hãa ne cg'ãè cau ne xg'ae-xg'ae a tshúùan ghùi. Jasonem dim x'áé ba ne kò qaru cgae, síí ne gha Pauloa tsara Silasea tsara qaara tcg'òó a khóè ne cookg'ai koe úú tsara a ka. ");
INSERT INTO nhr_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Igaba ẽe ne kò táá hòò tsara a ka ne kò Jasone ba hẽé naka c'ẽe ne dtcòm̀-kg'ao ne hẽéthẽé tcéèa tcg'òó, a x'áé-dxoom di xu tc'ãà-cookg'ai xu koe úú ne, a q'au a máá: “Khóè tsara ncẽe kò ko nqõó ba tshúù-tshuu tsara ncẽeska ncẽe koe hàna, ");
INSERT INTO nhr_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","me Jasone ba x'áéa ba koe tciia tcãà tsaraa hãa. Xu ko wèéa xu ga Roma ne dim x'aigam Kaesaram di x'áè-kg'áḿan xguì, a kò máá: ‘C'ẽem X'aigam Jeso ta ko ma tciiè ba hãa,’” témé. ");
INSERT INTO nhr_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Eẽ ne ko khóè ne hẽé naka tc'ãà-cookg'ai xu hẽéthẽé ncẽes gúù sa kóḿ ka ne kò kaisase xg'aì. ");
INSERT INTO nhr_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Xu kaia xu Jasone ba hẽé naka c'ẽe ne hẽéthẽé surutakagu, a guu ne ne qõò. ");
INSERT INTO nhr_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Eẽm ntcùúm kaga ne kò kúúga dtcòm̀-kg'ao ne, Pauloa tsara Silasea tsara Berea koe tsééa úú. Eẽ tsara ko síí ka tsara kò Juta ne dim còrè-nquum koe tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea di ne khóè ne ko qãè ne khóè ne e Tesalonika di ne khóè ne ka t'õè-tcáó ne, khama ne kò kg'ui ba wèé tcáóa ne ka séèa mááse, a ne a kò Nqarim di zi Tcgãya zi wèé cáḿ ka nxárá, Paulom kg'uia hãas tseegu ii sa ne kò bóò kg'oana hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ne kò káí ne dtcòm̀, káí zi khóè zi tcom-tcomsa zi Gerika di zi hẽé naka káí xu khóè xu Gerika di xu hẽéthẽéa kò dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Igabaga ẽe ne ko Juta ne Tesalonika koe hàna ne Paulom ko Nqarim dim kg'ui ba Berea koe xgaa-xgaa sa kóḿ, ka ne kò gaa koe síí, a síí ncõoan ghùi. ");
INSERT INTO nhr_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ne nxãaska dtcòm̀-kg'ao ne Paulo ba tshàa-dxoom qàe koe qháése tsééa úú, igaba tsara kò Silasea tsara Timoteo tsara Berea koe qaù. ");
INSERT INTO nhr_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Eẽ kò Paulo ba úúa tòó xu khóè xua kò Atene noose qõò cgoa me, a síí Berea koe ka̱bise, Silasea tsara Timoteoa tsara méé tsara qháése síí cgae me di x'áè-kg'áḿan cgoa. ");
INSERT INTO nhr_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Eẽm kò Paulo qanega Atene koe Silasea tsara Timoteoa tsara qãà hãa, kam kò ẽem ko x'áé-dxoom koe i kúrúa mááseèa hãa nqárìan cg'oèa hãa sa bóò ka kaisase tshúù-tcao. ");
INSERT INTO nhr_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","A ba a kò ko wèé cáḿ ka còrè-nquum koe Juta ne hẽé, qhàò zi di ne ncẽe Nqari ba kò ko còrè ne hẽé, naka khóè ne ncẽe kò ko wèé cáḿ ka gúù zi ko x'ámáguèm qgáìm koe nqáé ne hẽéthẽé cgoa qarika kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Xu kò gataga thẽé c'ẽe xu Epikuria hẽé naka Setoike hẽéthẽé di sara dtcòm̀ sara di xu q'ãa-kg'ao xu ntcoeku cgoa me. C'ẽe xua kò ko máá: “Dùús tc'amkg'ai koe ba gáé ko ncẽem khóè ba kg'ui?” témé. Xu c'ẽe xu xo̱a a máá: “Kúrúa mááseèa nqárìan kam ko kg'ui khama i xám̀,” témé. Paulo ba kò ko Jesom ka hẽé naka x'ooan koe tẽes ka hẽéthẽé xgaa-xgaa domka xu kò ko ncẽeta méé khama. ");
INSERT INTO nhr_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ne nxãaska tc'ãà-cookg'ai xu dis xg'aes Areopago ta ko ma tciiès cookg'ai koe séè a úú me, a máá: “Q'ãa kg'oana ta hãa, dùútsa xgaa-xgaas ka̱bas ka tsi ko kg'ui sa. ");
INSERT INTO nhr_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","C'ẽe zi gúù zi ẽe ta ko kóḿ tsi tsi ko nxàe zia gatá koe are-aresa zi i, ta dùú zi ko nxàe sa q'ãa kg'oana,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Wèé ne x'ãè-kg'ao ne Atene di ne hẽé naka tãá xu nqõó xu koe guua ne khóè ne, ncẽe kò gaa koe x'ãèa hãa ne hẽéthẽéa kò ko tc'ẽe, gane di x'aèan ne gha ka̱base ne ko nxàe a ko kóḿ zi gúù zi koe nqáékagu sa. ");
INSERT INTO nhr_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Me kò nxãaska Paulo ba Areopagom dis xg'aes nqáè koe tẽe a téé a máá: “Gaxao khóè xao Atene di xao koer ko wèé zi dàò-kg'áḿ zi koe bóò, dtcòm̀an xao úúa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Eẽr kòo caate gatu dim x'áé-dxoom koe kar kò ẽe tu ko còrè zi qgáì zi bóò kar kò altaram ncẽeta ma góásea hãa ba bóò: ‘NQARIM C'ÚÙSEA HÃAM DI BA,’ ta ko mééè ba. Tu kò dìím ii sa tu c'úùa hãa igaba còrè Me, ra ko ncẽeska Gam kar ga bìrí tu u sa tc'ẽe. ");
INSERT INTO nhr_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Nqarim ga Me e, ncẽe nqõómkg'ai hẽé naka wèé zi gúù zi gaam koe hãa zi hẽéthẽé kúrúa hãa ba. X'aigam nqarikg'ai hẽé naka nqõómkg'ai hẽéthẽé di ba, khóèan tshàu ka kúrúèam tempelem koe x'ãè tama ba, ");
INSERT INTO nhr_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","kana c'ẽe gúù ko qaa khóè khama ma khóèan tshàu ka kúrúa mááè tama ba, Gabá ko wèé khóèan ga kg'õèan hẽé naka sónòan hẽé naka wèés gúù sa hẽéthẽé máà khama. ");
INSERT INTO nhr_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Cúím khóèm koem guu a nqõóm di zi qhàò zi wèé zi kúrúa hãa, wèém nqõóm koe zi gha x'ãè ka, Me x'aèan hẽé naka hàà zi ko x'ãè qgáìan hẽéthẽé q'aa-q'aa máá zia hãa. ");
INSERT INTO nhr_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Nqari ba ne gha nqòòan úúa hãase qaa ka, a gha c'ẽedaoka ẽe ne ko qaa Me ka hòò Me. Gatàm ma gatá wèé ta ka nqúù tama igaba. ");
INSERT INTO nhr_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ncẽe ta ko c'ẽea ta méé khama a ko máá: ‘Gam koe ta kg'õèa, a ko qõòa te, a hàna hãa.’ Ncẽe ne ko gatu di ne dqo̱m̀-kg'ao ne méé a ko máá, ‘Gatá igaba ta thẽé Gam di ta cóá ta a,’ témé khama. ");
INSERT INTO nhr_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Ncẽe ta Nqarim di ta cóá ta ii, ka méé ta táá tc'ẽea máá, Nqari ba khóèan tshàu ka kúrúèa hãa, kana t'õè nxõ̱án tca̱àko hẽé naka seleferan hẽéthẽé cgoa kúrúèa hãa, ta tc'ẽea guu. ");
INSERT INTO nhr_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Nqari ba xg'ao ko khóè ne di tc'irì-tc'irisean bóòa guu, igabagam ko ncẽeska wèé zi qgáì zi koe khóèan bìrí, kúrúa mááseèa hãa nqárìan méé ne tcg'oaragu, naka gane di chìbian koe tcóóse sa. ");
INSERT INTO nhr_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Cáḿ bam tòóa hãa, Gam kam gha nqõó ba bóò q'oo a Gam nxárá tcg'òóa hãam Khóèm cgoa xgàra me ba khama. Ncẽe sa tseegu si i sam wèé ne khóè ne x'áía hãa, x'ooan koe ghùia ba ka. ");
INSERT INTO nhr_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Eẽ ne ko Paulo ba kóḿ me ko x'ooan koe ghùiès ka kg'ui, ka ne kò c'ẽe-kg'áía ne tsa̱ruan kúrú u, igaba ne kò c'ẽe ne máá: “Gaicara tsi gha ncẽes gúùs ka kg'ui sa ta ko tc'ẽe,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Me nxãaska Paulo gane xg'aeku koe tcg'oa. ");
INSERT INTO nhr_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Igaba xu kò c'ẽe xu khóè xu hàà cgae me, a xu a dtcòm̀. Gaxu cgoam kò Dionisio, Areopagom x'áé di ba, xg'aes dim tc'ãà-cookg'ai ba hẽé naka c'ẽes khóès Damarise ta ko ma tciiè sa hẽé, naka c'ẽe ne hẽéthẽé hàna. ");
INSERT INTO nhr_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Ncẽe zi gúù zi qãá q'oo koem kò Paulo ba Atene koe guu a ba a Korinta koe qõò, ");
INSERT INTO nhr_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","a ba a kò gaa koe Akilam cgoa xg'ae, ncẽe kò Juta dis qhàòs di ii ba, Ponto koe kò ábàèa ba, me kò gam dis khóès Perisilas cgoa Italea koe guu a ka̱basega hààraa, Kelaodiase ba kò wèé ne Juta ne ẽe Roma koe hãa ne méé ne tcg'oa di x'áèan tcg'òóa hãa khama. Me kò Paulo gaa koe síí xg'ae cgoa khara a, ");
INSERT INTO nhr_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","a ba a kò síí hãa cgoa khara a, a tséé cgoa khara a, gakhara khamam kò ko ma xgàuèko nquu-coan kúrú khama. ");
INSERT INTO nhr_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Wèé cáḿan Sabata di kam kò ko còrè-nquuan koe khóè ne cgoa qarika kg'ui, a ba a kò ko Juta ne hẽé naka Gerika ne hẽéthẽé tchàno dàòan x'áí. ");
INSERT INTO nhr_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Eẽ tsara ko Silasea tsara Timoteoa tsara Maketonia koe síí tcãà kam kò Paulo qãè tchõàn xgaa-xgaa koe tcãàn tcáó, a kò Juta ne Jesom ka nxàea tseegukagua máá, nqòòkaguèam Krestem ga Me e sa. ");
INSERT INTO nhr_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Igaba ẽe ne kò Juta ne Paulo ba ntcoe, a ne a ko cg'ãèse gam ka kg'ui, kam kò qgáía ba di tsharàn qãè-qãe, a ba a bìrí ne a máá: “Gatu tcúú koe i cúíaga c'áòan cg'oèa hãa, tíí ra tchàno ra a. Ncẽe koe guus kar ko tãá zi qhàò zi di ne koe qõò,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Me Paulo ba còrè-nquum koe guu, a ba a c'ẽem khóèm Titio Juseto ta ko ma tciièm dim nquum ncẽe kò qàea ba koe hãam koe síí tcãà, ncẽe kò ko Nqari ba còrè ba. ");
INSERT INTO nhr_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ne kò còrè-nquum dim tc'ãà-cookg'aim Kerisepo ba gam x'áé-q'oo di ne hẽéthẽé cgoa X'aigam koe dtcòm̀. Ne kò káí ne c'ẽe ne Korinta koe kò x'ãèa hãa ne ncẽe qãè tchõàn kóḿ, a ne a kò dtcòm̀, a tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","C'ẽem ntcùúm kam kò Paulo X'aigam ka bóòkaguè, Me X'aiga ba kg'ui cgoa me, a ba a máá: “Táá bèe guu, igaba méé tsi kg'ama kg'ui naka táá nqoo guu, ");
INSERT INTO nhr_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Tíí ra tsáá cgoa hãa, i cúí khóè ga gaan di tshàuan tòó cgae tsia hãa tite, ncẽem x'áé-dxoom koer káí ne khóè ne úúa hãa ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Me kò nxãaska Paulo gaa koe kuri ba hẽé naka 6 nxoean hẽéthẽé hãa, a khóè ne Nqarim dim kg'ui ba xgaa-xgaa. ");
INSERT INTO nhr_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Igabaga ẽem ko Galio Akaia dim tc'ãà-cookg'ai ba tòóè ka ne kò Juta ne Paulo ba xg'aea máá a qaru cgae, a ne a qhàìs koe úú me, síím gha chìbi-chibiè ka, ");
INSERT INTO nhr_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","a ne a kò máá: “Ncẽem khóè ba ko khóè ne qg'áì, a ko máá, Nqari ba méé ne còrè, témé, sita di x'áèan koe qaase tamas gúù sa,” ta ne méé. ");
INSERT INTO nhr_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Igaba ẽem Paulo ba kg'ui kg'oana hãa kam ko Galio ba Juta ne bìrí a máá: “Ncẽè gatu Juta tu kò cg'ãè gúùan kúrú dis chìbi sa kana xgóàs chìbi sa kúrúa hãa, ner ga kò komsana tua hãa. ");
INSERT INTO nhr_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Igaba tséékaguèa xu kg'ui xu hẽé, naka cg'õèan hẽé naka gatu di x'áè-kg'áḿan hẽéthẽé di zi tẽè zi i, ke tu gatu bóòa mááse tu ga ma kg'ónò zi sa. Cuiskagar tíí gaa zi di dàòan bóòa tcg'òóa máá tu u tite ke,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","A ba a nxãaska qhàìs koe xhàiagu ne. ");
INSERT INTO nhr_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ne kò wèéa ne còrè-nquum dim tc'ãà-cookg'aim Sosetenese ba qaru cgae. A ne a qhàìs cookg'ai koe xg'áḿ me. Igabam kò Galio ba táá cg'árés kaga nqábé ne. ");
INSERT INTO nhr_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulo ba ko Korinta koe tc'ãòa x'aè-coan dtcòm̀-kg'ao ne cgoa x'ãè, a ba a nxãaska Perisila khara Akila khara cgoa xgoaba a skepes cgoa Siria koe qõò. Eẽm ko Kenkerea koe síís cookg'ai koem kò tcúúa ba dqòm, gaìseam kò hãas gaìses domka. ");
INSERT INTO nhr_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ne Efeso koe síí tcãà, ncẽe gaa koem kò Paulo síí Peresila khara Akila khara qaù koe. A ba a gabá síí còrè-nquum koe tcãà, a ba a síí Juta ne cgoa qarika kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Eẽ ne ko khóè ne dtcàrà me, cg'árésem gha hãa cgoa ne sa, kam kò xguì. ");
INSERT INTO nhr_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Igabaga ẽem ko xgoaba kam kò x'áè ne a máá: “Ncẽè Nqarim kò ncàm̀a hãa ner gha ka̱bise cgae tu u,” témé. A ba a nxãaska Efeso dim x'áé-dxoom koe skepes cgoa qõò. ");
INSERT INTO nhr_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Eẽm ko Kaesarea dim x'áé-dxoom koe síí skepes cgoa tcãà, kam ko gaa koe guus ka kerekes Jerusalema koe hànas koe síí tcãà, a khóè ne tsgám̀kagu a ba a nxãaska Antioke dim x'áé-dxoom koe ka̱bise. ");
INSERT INTO nhr_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Gaa koem kò x'aè-coa séè a hãa, a ba a nxãaska wèém xg'aekum Galatia dim koe hẽé naka Ferugia dim di xu x'áé xu koe hẽéthẽé tcana te, a ko wèé ne xgaa-xgaase-kg'ao ne qari-qari. ");
INSERT INTO nhr_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Me c'ẽem Jutam Apolose ta ko ma tciiè ba, Efeso dim x'áé-dxoom koe hàà, ncẽe kò Alekesanteria dim x'áé-dxoom koe ábàèa ba. Qãèse ko kg'uim khóè me e kò ii, Nqarim di zi Tcgãya zi kò qãèse q'ana ba. ");
INSERT INTO nhr_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Gatagam kò Nqarim dim dàò ba qãèse xgaa-xgaaèa, a ko kgoara-tcaoase kg'ui, a ko Jesom ka tseeguse xgaa-xgaa, Johanem di tcguù-tcguukuan ka cúím kò q'ana igaba. ");
INSERT INTO nhr_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Tshoa-tshoam kò a còrè-nquum q'oo koe kgoarasease kg'ui. Eẽ khara ko Perisila khara Akila khara kg'uia ba kóḿ kaga khara ko x'áéa khara koe séè a úú me, a síí Nqarim dim dàòm ka qãèse cg'oèase bìrí me. ");
INSERT INTO nhr_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Me nxãaska Apolose Akaia dim xg'aekum koem gha qõò sa bìríse, ne kò dtcòm̀-kg'ao ne Efeso koe hàna ne hùi me, a tcgãya sa dtcòm̀-kg'ao ne Akaia koe hàna ne góá máá, a kò dtcàrà ne, qãèse ne gha hààkagu me sa. Eẽm ko síí gaa koe tcãà kam kò gane ẽe kò Nqarim di cgóm̀kuan domka dtcòm̀-kg'ao ii ne kaisase hùi. ");
INSERT INTO nhr_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Wèém khóèm cookg'ai koem kòo Juta ne cgoa ntcoeku khama, a Nqarim di zi Tcgãya zi cgoa x'áí, Jeso ba nqòòkaguèam Krestem ga Me e sa. ");
INSERT INTO nhr_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Eẽm kò qanega Apolose Korinta koe hãa, kam kò Paulo nqõóm nqáè koe tchoaba a nqáé, a ba a Efeso koe síí tcãà. Gaa koem kò c'ẽe xu xgaa-xgaase-kg'ao xu cgoa xg'ae. ");
INSERT INTO nhr_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Kam ko tẽè xu a máá: “Xg'ao xao ko dtcòm̀ ka xaoa xg'ao Tcom-tcomsam Tc'ẽe ba hòò?” témé. Xu xo̱a me a máá: “Qanega xae Tcom-tcomsam Tc'ẽem ka kóḿ ta ga hãa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Me tẽè xu a máá: “Kháé nxãaska xaoa dùútsa tcguù-tcguukus ka tcguù-tcguuèa?” témé. Xu xo̱a me a máá: “Johanem dis tcguù-tcguuku si i,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Me Paulo máá: “Johanem dis tcguù-tcguuku sa chìbian koe tcóóse a Nqarim koe ka̱bisean di si i. Khóè nem kò bìrí, Gaam ẽe ko gam qãá q'oo koe hààm koe ne gha dtcòm̀ sa, ncẽe Jeso ba,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ncẽe sa xu kò kóḿ ka xu kò X'aigam Jesom di cg'õèan koe tcguù-tcguuè. ");
INSERT INTO nhr_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Eẽm ko Paulo gaxu koe tshàua ba tòó kam kò Tcom-tcomsam Tc'ẽe ba tcãà cgae xu, xu tãáka ta̱man ka kg'ui, a xu a porofita. ");
INSERT INTO nhr_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Wèéa xu kò 12 xu khóè xu u. ");
INSERT INTO nhr_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Me kò Paulo ba còrè-nquum q'oo koe tcãà, a gaa koe nqoana nxoean Nqarim di x'aian ka kgoarasease kg'ui, a ko tẽèku a ko xo̱aku cgoa ne. ");
INSERT INTO nhr_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Igaba ne ko c'ẽea ne kóḿan xguì, a ne a táá dtcòm̀, a ne a ko khóè ne cookg'ai koe Nqarim dim dàòm ka cg'ãèse kg'ui. Me kò Paulo ba nxãaska guu ne, a ba a xgaa-xgaase-kg'ao xu séè, a wèém cáḿ ba Turano dim xgaa-xgaa-nquum koe qarika kg'ui. ");
INSERT INTO nhr_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ncẽe sa kò cám̀ kurian séè, nxãasega ne gha wèé ne Asia dim nqõóm koe kò x'ãèa hãa ne Juta ne hẽé naka Gerika ne hẽéthẽé X'aigam Nqarim dim kg'ui ba kóḿ ka. ");
INSERT INTO nhr_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Me kò Nqari ba Paulom di tshàuan cgoa are-aresa zi x'áí zi kúrú, ");
INSERT INTO nhr_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","i kò ẽem kò khùbuan tchùu cgoa qgáían hẽé naka tc'amakam ko hã̱a qgáían hẽéthẽé tsàako ne khóè ne koe séè a úúè, i tcììan guu ne, i dxãwa tc'ẽean tcg'oaragu ne. ");
INSERT INTO nhr_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Xu kò nxãaska c'ẽe xu Juta xu, ncẽe kòo nqõó ba nxa̱ma-nxa̱ma a ko caate xu, gane ẽe kò dxãwa tc'ẽean ka cg'oè cgaeèa ne koe tshoa-tshoa a dxãwa tc'ẽean tcg'òó, X'aigam Jeso Krestem dim cg'õè ba tciian ka, a xu a kò máá: “Jesom cg'õè kar ko x'áè tsi, ncẽe Paulom kò Gam ka xgaa-xgaa ba, a ko máá, tcg'oa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juta ne dim kaiam peresitim Sekefam di xu cóá xu 7 xua kò ncẽes gúù sa kúrú. ");
INSERT INTO nhr_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Igabam kò dxãwa tc'ẽe ba xo̱a xu a máá: “Jeso bar q'ana, a ra a Paulom ka q'ana, ka xaoa gaxao dìí ga xaoa?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Me kò dxãwa tc'ẽean úúam khóè ba nxàì cgae xu, a ba a wèéa xu ga tàà. Xg'áḿ xum kò a thõò-thõo xu, xu kò nquum koe guu a hã̱a tamase qgóéa tcg'oa. ");
INSERT INTO nhr_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ne kò wèé ne Juta ne hẽé naka Efeso koe x'ãèa ne Gerika ne hẽéthẽé ne ncẽe gúùan q'ãa. Wèéa ne ga kò q'áòs ka tcãàè, i kò X'aigam Jesom di cg'õèan kaikaguè. ");
INSERT INTO nhr_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ne kò káí ne dtcòm̀, a ne a hàà gane di zi tséé zi ẽe ne kò kúrú zi cg'ãè zi nxàe. ");
INSERT INTO nhr_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Káí ne ẽe kòo tsoòan ka xgaa-xgaase nea kò gane di zi tcgãya zi óága, a ne a síí wèé khóèan cookg'ai koe dàò zi. Gaa zi tcgãya zi di mari ne kòo nxárá xg'ae ne i 50,000 xu qano mari xu selefera di xu khama noo. ");
INSERT INTO nhr_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Me kò ncẽem dàòm ka X'aigam dim kg'ui ba kaisase càùse a kaisa qarian úú. ");
INSERT INTO nhr_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ncẽe zi gúù zi ko kúrúsea xg'ara kam kò Paulo bìríse, Maketonia hẽé naka Akaia hẽéthẽé koem gha nqáé a Jerusalema koe qõò sa, a máá: “Gaa koer ko síí hẽéa xg'ara ne méér Roma koe síí dàra,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Me kò cám̀ tsara hùi-kg'ao tsara gam di tsara, Timoteo ba hẽé naka Eraseto ba hẽéthẽé tsara Maketonia koe tsééa úú. A ba a gabá x'aè-coa ba Asia dim nqõóm koe qaù. ");
INSERT INTO nhr_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Gaam x'aèm ẽem kas kò kaias ncõo sa Nqarim dim dàòm ka tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Me kò c'ẽem khóèm Demeterio ta kò ma tciiè ba hàna, seleferan di gúùan kòo kúrú ba, tempelem c'ẽes nqárìs Aretamese dis di sere-serean ko seleferan cgoa kúrú ba, i kòo gam di tsééan káí marian óága gam cgoa kò kúrú xu tséé-kg'ao xu koe. ");
INSERT INTO nhr_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kam ko gaa xu tséé-kg'ao xu hẽé naka c'ẽe xu gatà iise ko tséé xu hẽéthẽé tciia xg'ae, a ba a máá: “Khóè xaoè, q'ana xaoa, ncẽes tséés koe xae qguù sa úúa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ncẽeska xao bóò a kóḿa hãa, ncẽem khóèm Paulo ba káí khóèan qg'áìa hãa sa, Efeso dim x'áé-dxoom koe cúí tamase, igaba wèém nqõóm Asia dim koe ga hẽéthẽé e, a ba a ko tshàu cgoa kúrúèa nqárìa ne nqárì tama a, témé, a tc'ãòa hãa khóèan séèa ka̱bia hãa. ");
INSERT INTO nhr_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Cg'ãès gúù sa gha hàà kúrúse, sixae dis tséés qãè sa cg'ãa-cg'ana di iise cúí bóòè tite, igabam gha thẽé tempelem kaias nqárìs Aretameses di ba kg'amaga káà hùise hãa, i gha gataga thẽé gas di dqo̱m̀mèan, nqõó xu Asia di xu koe hẽé naka wèém nqõóm koe hẽéthẽé kaàkaguè!” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Eẽ ne ko ncẽes gúù sa kóḿ ka ne kò kaisase xgóà, a ne a tshoa-tshoa a q'au a máá: “Kaia saa Aretameses Efeso di sa!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Me kò kúúga wèém x'áé-dxoo ba kaias tcẽé-tcẽes ka tcãàè. Ne khóè ne kõ̱èan dim qgáìm koe xg'ae a qàròa tcãà, a ne a kò Paulom cgoa ko qõòa te tsara khóè tsara, Maketonia di tsara, Gaio ba hẽé naka Arisetareko ba hẽéthẽé tsara, kõ̱èan dim qgáìm koe tcéèa tcãà. ");
INSERT INTO nhr_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulo ba kò xg'aes koe tcãà kg'oana, igabaga xu kò xgaa-xgaase-kg'ao xu xgáè-kg'am me. ");
INSERT INTO nhr_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","C'ẽe xu tc'ãà-cookg'ai xu Asia dim nqõóm di xu, ncẽe kò gam di ncàm̀-khoe ii xua kò thẽé kg'uian tsééa úú, kõ̱èan dim qgáìm koe méém táá síí di i. ");
INSERT INTO nhr_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Si kò xg'ae sa dùús ko kúrú sa q'ãa tama. C'ẽe nea kò cúís gúùs ka q'au, ne ko c'ẽe ne c'ẽes ka q'au. Ne kò káí-kg'aise khóè ne dùús domka ne ko ẽe koe xg'aea hãa sa q'ãa tama. ");
INSERT INTO nhr_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Juta ne kò Alekesantere ba xg'aes q'oo koe xàbùa tcãà, ne c'ẽe ne xg'aes di ne dùú sam gha kúrú sa bìrí me. Me kò xo̱ara mááse kg'oana kam kò tshàua ba cgoa dtcàrà, nqoo ne gha sa. ");
INSERT INTO nhr_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Igabaga ne kò Juta me e sa bóòa q'ãa, ka ne ko cám̀ aoaran wèéa ne ga cúí koe ntcoon-kg'áḿ a q'au, a máá: “Aretameses Efeso di sa kaia hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Igabam kò x'áé-dxoom dim góá-kg'ao ba xg'ae sa nqookagu, a ba a máá: “Efeso di tu khóè tuè, wèém khóè ba q'ana hãa, Efeso dim x'áé-dxoo ba kaia hãas Aretameses dim tempelem dim kòre-kg'ao me e sa, naka nqarikg'ai koe guu a cg'áéa hãas sere-sere sa hẽéthẽé e! ");
INSERT INTO nhr_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ncẽe zi gúù zia ntcoeè tama, gaa domka méé tu nqooa hãas gúù si i, naka táá c'ẽe gúù ga qháése kúrú guu. ");
INSERT INTO nhr_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ncẽe xu khóè xu ncẽe tu ncẽe koe óágara xua ts'ãà tama, a xu a gataga gatá dis nqárì sa cóè tama. ");
INSERT INTO nhr_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Khama ncẽè Demeterio ba hẽé naka gam di xu tséé-kg'ao xu hẽéthẽé ko c'ẽem khóèm cgoa ncõoan úúa hãa ne, xu x'aiga-coa xu hàna, i qhàìan xgobekg'amsea. Guu xu naka xu gaa koe síí chìbi-chibiku. ");
INSERT INTO nhr_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Igabaga ncẽè xao kò c'ẽe gúù úúa hãa, ncẽe xao còoka úú kg'oana hãa a, ne xao gha kaia xu dis xg'aes cookg'ai koe nxàe e. ");
INSERT INTO nhr_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Ncẽe i ma ncẽe cáḿ ka ii khama, ta gha ncẽe kúrúseas gúùs ka kaias cg'ãès q'oo koe hãa. Xo̱ara mááse ga káà a, gaan cgoa ta ga ncẽes tcẽé-tcẽe sa ncèèa mááse e khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ncẽetam ko mééa xg'ara kam kò xg'ae sa qõòa q'aakagu. ");
INSERT INTO nhr_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Eẽs ko tcẽé-tcẽe sa chõò kam ko Paulo xgaa-xgaase-kg'aoan tciia xg'ae, a ba a ghùi-ghui tcáó ne, a x'áè ne, a ba a tcg'oa a Maketonia koe qõò. ");
INSERT INTO nhr_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Eẽ xu qgáì xum ko tchoaba, a kò khóè ne káí kg'uian cgoa ghùi-ghui tcáó, a ba a síí Akaia koe tcãà, ");
INSERT INTO nhr_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","a gaa koe síí nqoana nxoean x'ãè. Siria koem kò qõò kg'oana kam kò bóòa q'ãa, Juta xu qg'áìkua máá mea hãa sa, khamam kò Maketonia koem gha ka̱bise dis tc'ẽe sa kúrú. ");
INSERT INTO nhr_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Gam cgoa kò hãa xu khóè xua kò Sopaterem Pirom ka cóásem ncẽe Berea koe guua ba hẽé, naka Tesalonika koe kò guua tsara Arisetarekoa tsara Sekumadua tsara hẽé, naka Gaiom Derebe koe ko guua ba hẽé, naka Timoteo ba hẽé, naka Asia dim nqõóm koe ko guua tsara Tigikoa tsara Terofimoa tsara hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ncẽe xu khóè xu kò sixae cookg'ai koe qõò, a síí Teroa koe qãà xae e. ");
INSERT INTO nhr_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Igaba xae kò sixae skepes cgoa Filipi koe guu a qõò, péré gãé-gãe úú tamas pérés ko tc'õóès kõ̱ès qãá q'oo koe. A xae a 5 cáḿan qãá q'oo koe Teroa koe síí cgae xu, a xae a kò síí gaa koe 7 cáḿan hãa. ");
INSERT INTO nhr_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Tc'ãà dim cáḿ bekem dim ka xae kò hààra xg'ae a xae a péréan tc'õó. Paulo ba kò khóè ne cgoa qarika kg'ui, i nxãakg'aiga síí ntcùú nqáèan tcãà, xùrikom cáḿ kam gha qõò sam kò dtcãasea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Eẽ ta kò xg'aea hãam nquum tc'amaka hãam koe i kò káí lampian hàna hãa. ");
INSERT INTO nhr_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Me kò qárí-kg'ao-coam Etiko ta ko ma tciiè ba fensteres koe ntcõe, ncẽe kò Paulom kò ko qáòse kg'ui ka ko kaisase x'óm̀a cg'áé ba. Tc'oms ko tàà me kam kò nqoana dim nquum koe guu a góḿankg'ai koe cg'áé, a síím ko ghùiè ka x'óóa. ");
INSERT INTO nhr_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Me kò Paulo ba xõa, a ba a qárí-kg'ao-coam tc'amkg'ai koe ncemea xòose, a ba a x'õàa ba ka xgábé me, a máá: “Táá q'ae guu, kg'õèam hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","A ba a gaicara tc'amaka hãam nquum koe qaò, a síí péréan tc'õó. Kg'ui cgoa nem ko i nxãakg'aiga síí cáḿan tcg'oa, me xgoaba. ");
INSERT INTO nhr_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ne kò khóè ne qárí-kg'ao-coa ba kg'õèam hãase x'áéan koe séè a úú, a ne a kò kaisase qgài-qgai tcáóè. ");
INSERT INTO nhr_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Xae xgoaba a skepes q'oo koe tcãà a xae a Asose koe qõò, ncẽe gaa koe xae kò Paulo ba síí skepes cgoa séè kg'oana koe. Ncẽetam kò ma kg'ónòsea, nqàrè cgoam kò ko gaa za síí khama. ");
INSERT INTO nhr_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Eẽm ko Asose koe síí xg'ae cgoa xae e ka xae ko séè me, a xae a skepes cgoa Mitilene koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Q'uu dim cáḿ ka xae kò skepes cgoa qõò, a Kiose koe síí tcãà. Eẽm cáḿ qãá q'oo koe xae kò tchoaba a síí Samose koe tcãà, a q'uu dim cáḿ ka Mileto koe síí. ");
INSERT INTO nhr_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Me Paulo Efeso koem gha nqáé a qõò sa bìríse, nxãasegam gha táá Asia dim nqõóm koe síí qáò x'aèan hãa ka. Pentekoste dim cáḿ cookg'ai kam gha síí Jerusalema koe tcãà sam kò qháéa máána hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileto koem ko guu kam kò Paulo ba Efeso koe khóèan tsééa úú, síí i gha kerekes di xu kaia xu tciia máá me ka. ");
INSERT INTO nhr_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Eẽ xu ko gam koe hàà kam ko bìrí xu a máá: “Q'ana xaoa, ntar kò ko ma kg'õè sa, wèé x'aèan ncẽer kò gaxao cgoa hàna ka, tc'ãà dim cáḿ Asia dim nqõóm koer ko hààm koe guu a. ");
INSERT INTO nhr_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Juta ne kò kúrúa bóò te, a ne a kàa zi ka qarika xgáè te, igabar X'aigam Nqari ba cg'áré-cg'aresean cgoa hẽé naka tcgáí tshàran cgoa hẽéthẽé kúrúa máána hãa. ");
INSERT INTO nhr_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Q'ana xao hãa, c'ẽe gúù gatuar ga hùi cgoa tuar kò táá gatu koe chóm̀ sa, igabar kò wèé ne khóè ne cookg'ai koe hẽé naka x'áéa tu koe ga hẽéthẽé gaan ka xgaa-xgaa tu u. ");
INSERT INTO nhr_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Juta ne hẽé naka Gerika ne hẽéthẽér qarika bìría hãa, gane di chìbian koe ne gha tcóóse a Nqarim koe ka̱bise a gatá dim X'aigam Jesom koe dtcòm̀ sa. ");
INSERT INTO nhr_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Igaba bóò, ncẽeskar ko Jerusalema koe qõò Tcom-tcomsam Tc'ẽem ka chùiè a, gaa koe gha síí kúrúse cgae te sar c'úùa hãase. ");
INSERT INTO nhr_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Wèém x'áé-dxoom ẽer kò tcãàm koem kò Tcom-tcomsam Tc'ẽe ba qarika bìrí te, qáé-nquuan koe hẽé naka qóḿ cgoa qgóókuan hẽéthẽéa tééa máá tea hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Gatà i ii igabar kò táá tiris kg'õè sa cgáés iise séèa mááse. Nooase cgáéa máá teas gúù sa X'aigam Jesom máà tea hãa tsééan xg'ara-xg'ara si i khama. Wèé qaria te cgoar ko gaan koe tséé, qàrò-kg'aom kõ̱ès koe ko qàròm khama ma. Ncẽes tséé sa ko khóè ne qarika qãè tchõàn Nqarim di cgóm̀kuan di ka bìrían di si i. ");
INSERT INTO nhr_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Q'ana ra hãa, xao gaicara kg'áía te hòò naka bóòa hãa tite sa, gaxao ncẽe wèéa xao xg'aeku koer kòo qõòa te a ko x'aian nqarikg'ai di ka xgaa-xgaa xao. ");
INSERT INTO nhr_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Gaa domkar ko ncẽem cáḿ ka bìría cgáé-cgae xao o, ncẽè c'ẽe-kg'áía tu kò ko aaguse ne i tíí chìbi tama a gha ii sa. ");
INSERT INTO nhr_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Wèés Nqarim ko tc'ẽe sar bìrí tua, c'ẽe gúù gar chóm̀-kg'ai tu u tama. ");
INSERT INTO nhr_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Q'õésea méé xao hãa, naka xaoa wèés xg'aes ghùuan di sa thẽé q'õé. Tcom-tcomsam Tc'ẽe ba kòre-kg'ao iise gaxaoa tòó xaoa hãa, kerekes Nqarim di sa xao gha kòre ka, ncẽe Gam di c'áòan kam x'ámáa sa. ");
INSERT INTO nhr_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Q'ana ra hãa, qõòar hãa koe i gha bèe-beesa ncuutshaan xg'aekua tu koe hàà tcãà sa, ncẽe cuiskaga ghùuan bóòa guua hãa tite e. ");
INSERT INTO nhr_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Gatu xg'aeku koe ga igaba xu gha kàma zi gúù zi ko kg'ui xu khóè xu guu a tcg'oa, a xu a gha xgaa-xgaase-kg'ao ne tseeguan dim dàòm koe tcg'òó, xùri xu ne gha ka. ");
INSERT INTO nhr_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ke méé tu kókòa hãa! Naka tua tc'ẽe-tc'ẽese, nqoana kurian ncẽe nqáéa hãa kar ko koaba ba hẽé naka ntcùú ba hẽéthẽé wèéa tu ga tcgáí-tshàran cgoa tchàno-tchano sa. ");
INSERT INTO nhr_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ncẽeskar ko Nqarim tshàu q'oo koe tcãà tu u. Gam dim kg'uim cgóm̀kuan di ba méé tu tc'ẽe-tc'ẽese. Ncẽe ba qarian úúa, tshàoam gha ghùi tu u di i, a gha gataga ts'ee-ts'eekg'aikuan máà tu u, wèé ne ẽe Nqari ba máàsea hãa nem ko ma máà khama. ");
INSERT INTO nhr_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","C'ẽem khóèm di selefera, kana gauta, kana qgáían gar ncóó ta ga hãa. ");
INSERT INTO nhr_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Gaxao igaba xao q'ana hãa, tiri tshàuan ncẽea ko ẽer tcàoa hãa gúùan máà te sa, naka tíí ka c'ẽea xu tcàoa hãa gúùan hẽéthẽé e. ");
INSERT INTO nhr_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Wèé zi gúù zi ẽer kúrúa hãa zi koer x'áí xaoa, ncẽeta ma tsééan ka méé ta ẽe kg'amka ne hùi sa, naka ta gataga X'aigam Jesom di kg'uian tc'ẽe-tc'ẽese, ncẽem kòo máá: ‘C'ẽem khóè ba c'ẽes gúù sa tcg'òó a máà nea kaisase ts'ee-ts'eekg'aièa, tchoanà tshàu a séèan ka,’ témé sa,” tam Paulo méé. ");
INSERT INTO nhr_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ncẽetam ko mééa xg'ara kam kò wèéa xu cgoa ga qhòm tsi qurù a còrè. ");
INSERT INTO nhr_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Xu wèéa xu ga kaisase kg'ae, a xu a Paulo ba xgábé, a x'obè me. ");
INSERT INTO nhr_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Me kò ma x'áè xua sa kò kaisase tshúù-tcaokagu xu, ncẽe cuiskaga xu gaicara kg'áía ba hòò naka bóòa hãa tite sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Eẽ xae ko gaxu cgoa q'aa, ka xae kò skepes cgoa qõò, a xae a tchàno a Kose koe síí, a xùrikom cáḿ ka Rotese koe síí tcãà, a gaa koe guus ka Patara koe qõò. ");
INSERT INTO nhr_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Xae Finikia koe ko qõòs skepe sa sao-xg'ae, a gaas koe tcãà, a qõò. ");
INSERT INTO nhr_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Eẽ xae ko tshàan ka nxa̱ma-nxa̱maèa hãam nqõó-coam Kupero di ba hòò, ka xae kò dxàe xòè za ntcòo me, a Siria koe qõò, a Ture koe síí tcãà, gaa koes kòo skepe sa ẽes nqàòa hãa zi gúù zi xòo khama. ");
INSERT INTO nhr_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Gaa koe xae kò xgaa-xgaase-kg'ao xu hòò, a xae a kò 7 cáḿan gaxu cgoa hãa. Tcom-tcomsam Tc'ẽem di qarian ka xu kò Paulo ba bìrí, táá méém Jerusalema koe nqáé sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Igaba ẽe i ko gaxae di cáḿan xg'ara ka xae kò xgoaba, a dàòa xae koe qõò. Ne kò wèéa ne ga, khóè zi hẽé naka cóán ga hẽéthẽé, úúa tòó xae e. Ta nxãakg'aiga x'áé-dxoom ka tchàa koe síí, a ẽe ta ko tshàam-kg'áḿ koe síí ka ta kò qúrùa ta cgoa qo̱m̀, a còrè. ");
INSERT INTO nhr_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Xae kò nxãaska x'áè ne a skepes koe tcãà, ne gane x'áéan koe ka̱bise a dìbi. ");
INSERT INTO nhr_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Eẽ xae ko Ture koe guuam dàòm cgoa xg'ara, ka xae kò Petolemaia koe tcãà, a xae a kò sixae ka c'ẽea ne tsgám̀kagu, a gane cgoa cúím cáḿ ba hãa. ");
INSERT INTO nhr_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","A xae a q'uu dim cáḿ ka xgoaba, a Kaesarea koe hàà, a xae a Filipim dim nquum koe síí tcãà, qãè tchõàn dim kg'ui-kg'ao ba, 7 xu hùi-kg'ao xu Jerusalema koe kò nxárá tcg'òóèa xu ka c'ẽe ba, a gam cgoa hãa. ");
INSERT INTO nhr_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Qanega séèè ta ga hãa zi cóá zi 4 zim kò úúa hãa, ncẽe kòo porofita zi. ");
INSERT INTO nhr_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Eẽ xae gaa koe cáḿ-coa xu hãa, kam kò Agabose ta ko ma tciièm porofiti ba Jutea koe guu a hàà. ");
INSERT INTO nhr_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Sixae koem ko hàà kam kò Paulom dim bàne ba séè a nqàrèa ba hẽé naka q'óḿa ba hẽéthẽé qáé, a máá: “Ncẽea Tcom-tcomsam Tc'ẽem ko méé ga a: Ncẽem bànem dim khóèm gha ma Jerusalema di ne Juta ne ka ma qáéè ga a, a ne a tãá zi qhàò zi di ne tshàu q'oo koe tcãà me,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Eẽ xae ko sixae hẽé naka ẽe koe kò hàna ne khóè ne hẽéthẽé ncẽes gúù sa kóḿ, ka ta kò Paulo ba dtcàrà, táám gha Jerusalema koe qõò sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Igabam kò Paulo xo̱a ta a, a máá: “Dùú sa tu ko kúrú ncẽe tu ko kg'ae a ko thõò-thõo tcáó te ka? Qáé-nquum koe tcãàèan cúí ra kg'ónòsea máá tama, igaba ra X'aigam Jesom di cg'õèan domka Jerusalema koe x'óóan ga thẽé kg'ónòsea máána,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Eẽ ta ko bóò, kg'uia ta tàà mea hãa tite sa, ka ta kò guu me, a máá: “X'aigam Nqarim ko tc'ẽe sa méés kúrúse,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Eẽ xu cáḿ xu qãá q'oo koe xae kò Jerusalema koe abagu, a qõò. ");
INSERT INTO nhr_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Xu kò c'ẽe xu xgaa-xgaase-kg'ao xu Kaesarea di xu qõò cgoa xae e, a kò Menaso ta ko ma tciièm khóèm Kupero dim x'áé koe úú xae e, kg'aiakam xgaa-xgaase-kg'ao ba, ncẽe xae gha síí x'ãè cgoa ba. ");
INSERT INTO nhr_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Eẽ xae ko Jerusalema koe hàà ka ne kò dtcòm̀-kg'ao ne qãèse-hààkagu xae e. ");
INSERT INTO nhr_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Xùrikom cáḿ kam kò Paulo ba sixae cgoa Jakobom koe qõò, xu kò wèé xu kaia xu hànaa. ");
INSERT INTO nhr_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Eẽm ko tsgám̀kagu xua xg'ara kam kò wèés gúùs ẽem Nqari ba gam di tsééan koe guu a qhàò zi di ne koe kúrúa hãa sa cúí cúí qãèse bìrí xu. ");
INSERT INTO nhr_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Eẽs gúù sa xu ko kóḿa xg'ara ka xu kò Nqari ba dqo̱m̀. A xu a nxãaska bìrí me a máá: “Bóò tsi ko, sixae ka qõese tseè, nta noo tcám̀-tcám̀a nea Juta ne xg'aeku koe dtcòm̀a hãa sa, a ne a wèéa ne ga Moshem di x'áèan qgóóa qaria hãa. ");
INSERT INTO nhr_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tsáá ka ne bìríèa hãa, wèé ne Juta ne ẽe tãá zi qhàò zi di ne xg'aeku koe hãa ne tsi ko xgaa-xgaa, Moshem di x'áèan ne gha ntcoe sa, a ko bìrí ne, táá ne gha gane di cóán q'ãe nqãa-qgai khòo, kana Jutan di cauan xùri sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Kháé sa gha nxãaska dùú sa kúrúè? Tseegukaga ne gha kóḿ, hààraa tsi hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ke ncẽe xae ko bìrí tsis gúù sa kúrú. Gaìsea hãa xu khóè xu 4 xua ncẽe koe hàna. ");
INSERT INTO nhr_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ke gaxu cgoa tempelem koe qõò, naka q'ano-q'anosean dis xg'aàku sa gaxu cgoa tcana máá. Suruta máá xu naka xu gha nxãasega tcúúa xu dqòm. Nxãaska ne gha wèé ne khóè ne q'ãa, wèé gúùan ẽe tsáá ka ko nxàeè nea tseegu tama sa, igaba tsi ko Nqarim di x'áèan qgóóa qari sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Igaba tãá zi qhàò zi di ne ncẽe dtcòm̀a hãa ne: xae tcgãya sa góá máána hãa, sixae ma bóòa hãa sa, a máá, táá méé ne kúrú mááseèa nqárìan ko máàè tc'õoan tc'õó guu, naka nea c'áòan tc'õó guu, naka nea táá chúú-chuu a cg'õoè kg'oo-coan kg'oo guu, naka nea cg'áràn kúrú guu, ta ko méé sa,” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Me kò Paulo ba gaa xu khóè xu séè, a ba a xùrikom cáḿ ka gaxu cgoa xg'ae a q'ano-q'anosean dis xg'aàku sa tcana máá. A ba a tempelem koe tcãà, a nxàe, n-cáḿa i gha gaa q'ano-q'anosean di cáḿan chõò sa, a gataga nxàe, gaxu di dàòa-máákuan gha n-cáḿa kúrúè sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Eẽ i 7 cáḿan nqáéa hãa ka xu kò c'ẽe xu Juta xu Asia koe guua xu tempelem koe bóò me; a xu a kò wèé xu khóè xu qg'áì, xu tshàua xu cgoa qgóó me, ");
INSERT INTO nhr_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","a q'au a máá: “Iseraele di xao khóè xaoè, hùi xae e! Ncãa ga me e khóèm wèé khóèan ko wèé qgáìan koe xgaa-xgaa ba, gatá di ne khóè ne hẽé, x'áè-kg'áḿan ga hẽé, naka ncẽem qgáìm kaga hẽéthẽé ko tshúù gúùan kg'ui ba, a Gerikan gataga tempelem koe óágara hãa, a gatà hẽés ka ncẽem qgáìm tcom-tcomsa ba cg'ãè-cg'ãea hãa!” témé. ");
INSERT INTO nhr_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ncẽeta xu kò méé, Terofimom Efeso di ba xu kò Paulom cgoa x'áé-dxoom koe bóòa hãa khama, a xu a kò tc'ẽea máá, Paulo ba tempelem koe tcãà mea, ta tc'ẽea hãa. ");
INSERT INTO nhr_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Me kò wèém x'áé-dxoo ba xháés ka tcãàè, ne khóè ne wèé ne qgóéa xg'ae a tempelem q'oo koe Paulo ba qgóó a tceea tcg'òó, i kò tempelem di nquu-kg'áḿan kúúga tcẽekg'ammè. ");
INSERT INTO nhr_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paulo ba ne kò cg'õo kg'oana kam ko Roma di xu ncõo-kg'ao xu dim kaia ba bìríè, Jerusalemam wèé ba tshúù qgáì koe hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kam ko cúí q'oro ncõo-kg'ao xu hẽé naka ncõo-kg'ao di xu tc'ãà-cookg'ai xu hẽéthẽé séè, a khóè ne koe qgóéa tcãà. Eẽ ne ko khóè ne ncõo-kg'ao xu cgoa bóò me ka ne kò Paulom xg'áḿ guu. ");
INSERT INTO nhr_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Me kò nxãaska ncõo-kg'ao xu dim kaia ba gaa koe síí a Paulo ba qgóó a qáé me, a x'áè, cám̀ táùan cgoa méém qáéè sa. A ba a tẽè, dìím ii sa, a gataga dùú sa kúrúa hãa sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ne kò xg'aes koe c'ẽe ne cúís gúù sa q'au, ne c'ẽe ne tãá sa q'au. Are sa kò hàna khamam kò ncõo-kg'ao xu dim kaia ba táá q'ãa, dùús ko kúrúse sa, a kò gam di xu ncõo-kg'ao xu x'áè, Paulo ba xu gha séè a ncõo-kg'ao xu dim x'áém koe úú sa. ");
INSERT INTO nhr_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Eẽ xu ko q'ábà qaò dim qgáìm koe síí kam kò Paulo ba ncõo-kg'ao xu ka qgóóa ghùiè, khóè ne di xgóàn ka. ");
INSERT INTO nhr_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Wèéa ne kò xùri me, a kò q'au a ko máá: “Cg'õo me,” témé khama. ");
INSERT INTO nhr_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Eẽ xu ncõo-kg'ao xu gaxu dim x'áém koe tcãà me kg'oana, kam ko Paulo ncõo-kg'ao xu dim kaia ba tẽè a máá: “C'ẽes gúù sa ra gáé ga kg'ui cgoa tsi?” témé. Me máá: “Gerika sa tsi koáé cèè kg'ui? ");
INSERT INTO nhr_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kháé tsi nxãaska Egepeto tsi tama tsia, ncẽe kò nqáéa x'aèan ka tshúù sa ghùia tsi, a 4,000 xu cg'õo-kg'ao xu qãáka úúa tsi?” tam ma tẽè me. ");
INSERT INTO nhr_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Me Paulo xo̱a a máá: “Tíí ra Juta ra a, Tareso Kilikia di koe ábàèa ra, cgáém x'áé-dxoom dir x'ãè-kg'ao ra. Cgóm̀na guu te nakar khóè ne cgoa kg'ui,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Me kgoara máá me, me Paulo q'ábà ko qaòè qgáì koe tẽèse tshàua ba cgoa khóè xu x'áí, nqoo xu gha ka. Eẽ xu ko qháì ta ma nqoo kam ko Paulo Hebera sa kg'ui cgoa xu, a máá: ");
INSERT INTO nhr_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Tíí kíí ga xao, àbo ga xaoè, ncẽeska xao tiris tééa mááse sa komsana, ncẽer ko ncẽeska gaxao cookg'ai koe nxàe sa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Eẽ xu ko kóḿ me ko Hebera dis kg'ui sa kg'ui cgoa xu ka xu kò kaisase nqoo. Me nxãaska Paulo ba máá: ");
INSERT INTO nhr_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Tíí ra Juta ra a, Tareso Kilikia di koe ábàèa ra, a ra a ncẽem x'áé-dxoom koe kaikaguèa, a ra a kò x'áèan àbo ga xu di ka Gamalielem di nqàrè-kg'aman koe qarika xgaa-xgaaè, a kò Nqari ba qarika tsééa máá, gaxao wèé xao ncẽe cáḿ ka ii khama. ");
INSERT INTO nhr_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Xùri-kg'ao ne ncẽem dàòm Jesom di ner kò x'ooan koe xgàra, kg'áò-khoean hẽé naka dxàe-khoean hẽéthẽér kòo qáé, a ra a kòo qáé-nquuan koe tcãà a, ");
INSERT INTO nhr_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ncẽem ga ma kaiam peresiti ba hẽé naka kaia xu dis xg'ae sa hẽéthẽé ma nxàea tseegukagua máá tea hãa khama ma. Tcgãya zi Damaseko di xu Juta xu góá mááèa hãa zir kò séè, a ra a Damaseko koe úú, a ra a gaa koe síí khóè ne qáé, a séè a Jerusalema koe óá ne, nxãasega ne gha xgàraè ka. ");
INSERT INTO nhr_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Eẽr ko koaba di x'aè ka Damaseko qàe koe hàà, kam ko kúúga kaisase tca̱àkom x'áà ba nqarikg'ai koe guu a x'áà-x'aa te, ");
INSERT INTO nhr_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","kar ko góḿankg'ai koe cg'áé, a ra a kg'ui ba kóḿ me ko bìrí te a máá: ‘Sauloè! Sauloè! Dùús domka tsi ko xgàra Te?’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ra tẽè Me a máá: ‘Dìí Tsia X'aigaè?’ témé. Me xo̱a te a máá: ‘Tíí Ra Jeso Ra a, Nasareta di Ra, ncẽe tsi ko tsáá xgàra Ra,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Xu kò tíí cgoa kò hãa xu khóè xu x'áà ba bóò, igaba xu ko táá Gaam ẽe kò tíí cgoa kg'uim di kg'ui-q'ooan kóḿ. ");
INSERT INTO nhr_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Ra tẽè Me a máá: ‘X'aigaè, dùú ra gha kúrú?’ témé. Me X'aigam Nqari ba bìrí te a máá: ‘Tẽe, naka tsia Damaseko koe qõò, gaa koe tsi gha síí bìríè wèé zi gúù zi Tíí x'áè tsia hãa zi, kúrú tsi gha zi,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Xu tíí cgoa kò hãa xu khóè xu qgóó hìi a Damaseko koe úú te, x'áàm di tca̱à-q'ooa nea ko cg'õo tcgáí tea hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Me kò Ananiase ta ko ma tciièm khóè ba hàà bóò te. Nqari-tcáóam khóèm x'áèan ko komsana me e kò ii, a ba a kò wèé ne Juta ne gaa koe x'ãèa ne ka kaisase tcommèa. ");
INSERT INTO nhr_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Me dxùukg'aia te koe téé a ba a máá: ‘Tíí qõe tsi Saulo tseè, bóò gaicara!’ témé. Ra kò gaam x'aèm ẽem kaga bóò me. ");
INSERT INTO nhr_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Kam ko nxãaska máá: ‘Nqarim gatá ka xõò ga xu di ba nxárá tcg'òó tsia hãa, x'áèa ba tsi gha q'ãa ka, a tsi a tchànom Khóèm Jeso ba bóò ka, a Gam kg'áḿ koe guuam kg'ui ba kóḿ ka. ");
INSERT INTO nhr_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Eẽ tsi bóò a kóḿa hãa zi koe tsi gha Gam dim nxàea tseegukagu-kg'ao ba ii ka, wèé khóèan koe. ");
INSERT INTO nhr_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ka ncẽeska tsi ko dùú sa qãà? Tẽe naka tsia tcguù-tcguuè naka i chìbia tsi xg'aàra tcg'òóè, tcii cg'õè Me kose,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Eẽr ko Jerusalema koe ka̱bise, a ra a ko tempelem koe còrè, kar ko c'ẽes sõokuris ka tcãàè. ");
INSERT INTO nhr_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","A ra a X'aigam Nqari ba bóò Me ko tíí cgoa kg'ui a ko máá: ‘Qháé, naka ncẽeskaga Jerusalema koe tcg'oa, cuiskaga ne Tíí ka nxàea tseegukaguan tsari dtcòm̀a hãa tite ke,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ra kò xo̱a a máá: ‘X'aigaè, ncẽe xu khóè xua q'ana, wèém còrè-nquum koer kò ko tcãà a ko ẽe ko Tsáá koe dtcòm̀a ne qáé, a ra a ko xg'áḿ ne sa. ");
INSERT INTO nhr_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Eẽ i ko Tsarim nxàea tseegukagu-kg'aom Stefanem di c'áòan ntcã̱aguè, kar ko tíí ga ra gaa koe tééa-tẽe a ra a ko gaxu cgoa dtcòm̀ku, a kò ẽe ko cg'õo me xu di qgáían kòre,’ témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Me nxãaska X'aiga ba bìrí te a máá: ‘Qõò, nqúù kar gha tsééa úú tsi, tãá zi qhàò zi di ne koe ke,’ témé,” tam Paulo méé. ");
INSERT INTO nhr_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Xu kò khóè xu Paulo ba komsana, me nxãakg'aiga qõò a síí ncẽeta méé. Xu kaisase q'au a máá: “Ncẽeta iim khóè ba méém nqõómkg'ai koe tcg'òóè, qãè tama ia, kg'õèm gha sa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Eẽ xu ko q'au, a ko qgáía xu xaoa q'aa, a ko góḿan dõea kã̱é tc'amaka, ");
INSERT INTO nhr_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","kam ko tc'amaka hànas téé-q'oos dim tc'ãà-cookg'aim ncõo-kg'ao xu di ba x'áè, me Paulo síí ncõo-kg'ao xu dim x'áém koe tcãàè, a ba a xg'áḿmèkose tẽèè. Tc'amaka hànas téé-q'oos dim tc'ãà-cookg'ai ba kò q'ãa kg'oana, dùús domka xu ko khóè xu ẽeta ma q'au cgae me sa khama. ");
INSERT INTO nhr_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Eẽ xu ko qáéa xòó me, síí xu gha xg'áḿ me ka, kam kò Paulo ncõo-kg'ao xu dim tc'ãà-cookg'aim ẽe kò qàea ba koe tẽem ncẽe nqãaka hànas téé-q'oos dim ka máá: “A x'áèa ne kgoara hãa, Roma dim khóèm gha xg'áḿmè sa, ncẽe kg'ui zi cgoa kò táá tẽèè a nxãata ma chìbi-chibiè ba?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nqãaka hànas téé-q'oos dim tc'ãà-cookg'aim ko ncẽes gúù sa kóḿ kam ko tc'amaka hànas téé-q'oos dim tc'ãà-cookg'aim koe síí xàà si, a máá: “Nta tsi gha hẽé? Ncẽem khóè ba Roma dim khóè me e ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Me tc'amaka hànas téé-q'oos dim tc'ãà-cookg'ai ba Paulom koe síí, a tẽè me a máá: “Bìrí te, Roma di tsi khóè tsi ii sa?” témé. Me máá: “Eè, gaar ga ra a,” tam ma xo̱a. ");
INSERT INTO nhr_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Me nxãaska tc'amaka hànas téé-q'oos dim tc'ãà-cookg'ai ba máá: “Tíí ra kaisa surutan surutaa, nxãasegar gha Roma dim x'ãè-kg'ao ba kúrú ka,” témé. Me Paulo ba xo̱a a máá: “Igabar tíí nqõóm dir x'ãè-kg'aor iise ábàèa,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Xu ẽe kò tẽè me kg'oana hãa xu qháése guu me. Me tc'amaka hànas téé-q'oos dim tc'ãà-cookg'ai ba q'ae, ẽem ko bóòa q'ãa, Paulo ba Roma dim khóèm me e, igabam táùan cgoa qáé mea sa ka. ");
INSERT INTO nhr_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ncõo-kg'ao xu dim kaia ba kò qãèse q'ãa kg'oana, dùús kam ko Paulo ba Juta ne ka chìbi-chibiè sa, khamam kò q'uu dim cáḿ ka kgoara me, a ba a x'áèan tcg'òó, kaia xu peresiti xu hẽé naka kaia xu dis xg'ae sa hẽéthẽé xu méé xu xg'ae sa. Me kò nxãaska Paulo ba cookg'aia xu koe óága. ");
INSERT INTO nhr_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Me Paulo ba kaia xu dis xg'ae sam qãèse téé a ko tcgáí-q'ooa sa koe bóò koe máá: “Tíí kíí ga xaoè, Nqarim cookg'ai koer q'anos tcáós cgoa tchànos kg'õè sa kg'õèa hãa ncẽes koosega,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Kam ko nxãaska kaiam peresitim Ananiase ba ẽe kò Paulom qàe koe téé-tẽe xu bìrí a máá, xg'áḿ kg'áḿ me méé xu, témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Me nxãaska Paulo bìrí me a máá: “Nqari ba gha xg'áḿ tsi, tsáá ẽe q'úúse xg'aàèam nquum cgáé-q'oo khama ii tseè! Eẽ koe tsi ntcõe a ko chìbia te bóò x'áèan ma ii khama, igaba tsi ko tsáá ga tsi x'áèan ntcoe, thõò-thõoè méé ra, ta mééan ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Eẽ kò Paulom qàe koe téé-tẽe xu kò bìrí me a máá: “Kaiam peresitim Nqarim di ba tsi koáé cgúí?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Me Paulo ba xo̱a xu a máá: “Tíí kíí ga xaoè, kaiam peresiti me e sar kò bóòa q'ãa tama; góásea i hãa a ko máá: ‘Táá tc'ãà-cookg'aim tsari ne khóè ne dim ka cg'ãè gúù kg'ui guu!’ téméè khama,” tam méé. ");
INSERT INTO nhr_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Me kò nxãaska Paulo ba, c'ẽea xu Saduke e, xu c'ẽea xu Farasai e sam kò q'ana hãa khama xg'aes cookg'ai koe q'aua tcg'òó a máá: “Tíí kíí ga xaoè, tíí ra Farasai ra a, Farasai khara ka cóáse ra a. Tẽèkus q'oo koer hãa, x'óóa ne gha x'ooan koe tẽe di nqòòa ner úúa hãa khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Eẽm ko ncẽeta mééa xg'ara kas ko Saduke xu hẽé naka Farasai xu hẽéthẽé xg'aeku koe mẽéku sa tẽe, si xg'ae sa q'aa-q'aase. ");
INSERT INTO nhr_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Saduke xu kòo máá, x'ooan koe tẽe sa káà si i, i moengelean ga káà a, me tc'ẽe ba thẽé káà me e, témé khama. Igaba xu kòo Farasai xu ncẽe gúùan wèé ga hàna sa dtcòm̀. ");
INSERT INTO nhr_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Si kò kaisas tcẽé-tcẽe sa tẽe, xu c'ẽe xu x'áè xgaa-xgaa-kg'ao xu ncẽe kòo Farasai di ii xu tẽe a kaisase ntcoeku a máá: “Ncẽem khóèm ka xae cúí gúù tshúù ga hòò tama. Kháé dùú sa gha ii, ncẽè c'ẽedaokam kò tc'ẽe ba kana moengele ba kg'ui cgoa mea ne?” ta xu méé. ");
INSERT INTO nhr_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Si xg'ae sa kaisase mẽéku, me tc'amaka hànas téé-q'oos dim ncõo-kg'ao ba q'áò, Paulo ba xu gha séè a tòà q'aas gúùs ka, khamam ncõo-kg'ao xu bìrí, xõa xu gha a síí qarika séèa tcg'òó me, a ncõo-kg'ao xu dim x'áém koe úú me ka. ");
INSERT INTO nhr_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Xùrikom ntcùúm kam ko X'aigam Nqari ba Paulom qàe koe hàà téé a máá: “Tòón tcáó! Ncẽe tsi kò Tíí ka ma Jerusalema koe nxàea tseegukagua khama méé tsi gataga ma thẽé Roma koe nxàea tseegukagu,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Q'uu i ko ka xu ko Juta xu tcúú qáé, a xu a kaias gaìses cgoa gaìse, cuiskaga xu tc'õó kana kg'áà tite di sa, Paulo ba xu cg'õo tamas cookg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ncẽes gaìse sa kò kúrúa hãa xu khóè xua kò 40 sa nqáéa hãa. ");
INSERT INTO nhr_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kaia xu peresiti xu hẽé naka khóè ne di xu kaia xu hẽéthẽé koe xu kò síí a máá: “Gaìsea xae hãa kaias gaìses cgoa, cúí gúù ga xae xám̀ tite sa, Paulo ba xae cg'õo tamas cookg'ai koe. ");
INSERT INTO nhr_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ke méé xao ncẽeska gaxao hẽé naka kaia xu dis xg'aes di xu hẽéthẽé ncõo-kg'ao xu dim kaia ba bìrí nakam máà xao o me, gam ka xao qãèse q'ãa kg'oana khama ma kúrúse ná. Sixaea ncẽe koem hàà tamas cookg'ai koe cg'õoa ba kg'ónòsea máána hãa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Igaba ẽem ko Paulom ka qõeses dim cóá ba gaas kàa sa kóḿ, kagam ko síí Paulo ba bìrí si, ncõo-kg'ao xu dim x'áém q'oo koe. ");
INSERT INTO nhr_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Me nxãaska Paulo ba c'ẽem tc'ãà-cookg'aim nqãaka hànas téé-q'oos di ba tcii, a bìrí me a máá: “Ncẽem qárí-kg'ao ba séè naka tc'amaka hànas téé-q'oos dim tc'ãà-cookg'aim koe úú, c'ẽes gúù sam úúa hãa bìrí mem gha sa ke,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Me nxãaska séè me, a ba a tc'amaka hànas téé-q'oos dim tc'ãà-cookg'aim koe úú me. A ba a máá: “Paulom qáéèa ba tséé tea, ncẽem qárí-kg'ao bar gha tsáá koe óá ka, c'ẽe gúùm úúa, bìrí tsi kg'oanam hãa a khama,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Me tc'amaka hànas téé-q'oos dim tc'ãà-cookg'ai ba qárí-kg'ao ba séè, a dxùukg'aia ba za tcéèa nqáékagu me, a tẽè me a máá: “Dùú sa tsi úúa hãa, bìrí te kg'oana tsi hãa sa?” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Me máá: “Juta xu kg'uia xg'aea hãa, dtcàrà tsi xu gha, tsi q'uu ka Paulo ba kaia xu dis xg'aes cookg'ai koe óága ka, gam ka xu qãèse tẽèa kg'ónò kg'oana khama xu kò hẽé. ");
INSERT INTO nhr_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Igaba táá nqábé xu guu, 40 sa nqáéas xg'aes khóè xu di sa qa̱e mea hãa ke. Gaìsea xu hãa, tc'õó a xu a kg'áà tite sa, cg'õo me tama xu hãas cookg'ai koe ke. Kg'ónòsea xu hãa ncẽeska, a qãà hãa nxàe tsi ghas cúí sa, gaxu dis dtcàràs koe. ");
INSERT INTO nhr_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Me tc'amaka hànas téé-q'oos dim tc'ãà-cookg'ai ba qárí-kg'ao ba bìrí me qõò, a q'ãa-q'ãa me, a ba a máá: “Táá cúí khóè ga ncẽe gúùan ncẽe tsi tíí koe xààa hãa bìrí guu,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Me nxãaska c'ẽe tsara nqãaka hàna téé-q'ooan di tsara tc'ãà-cookg'ai tsara tcii, a bìrí tsara a, a máá: “Kg'ónòse tsao naka 200 xu ncõo-kg'ao xu séè, 70 xu bìi qábì-kg'ao xu hẽé naka 200 xu kg'áó xaose xu hẽéthẽé e, naka xao Kaesarea koe ncẽem ntcùúm ka 9 di x'aè ka qõò, ");
INSERT INTO nhr_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Paulo ba bìian qgóóa máá, nakam nxãasega tc'ãà-cookg'aim Felikisem koe qãèse úúè,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","A ba a kò tcgãya sa ncẽeta ma góá: ");
INSERT INTO nhr_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Tíí ra Kelodiase Lisiase ra a, “Tc'ãà-cookg'aim Felikisem tcom-tcomsa bar ko góá máá: “Tsgám̀kua ne! ");
INSERT INTO nhr_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Khóèm ncẽer kò tcgãyas cgoa tséé úú ba Juta xu ka qgóóèa, xu kò cg'õo me kg'oana, igabar kò tiri xu ncõo-kg'ao xu cgoa hàà, a hàà hùi me, Roma dim khóè me e sar kò kóḿa hãa khama. ");
INSERT INTO nhr_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Q'ãa kg'oana ra kò hãa, dùús domka xu ko chìbi-chibi me sa, khamar ko nxãaska gaxu dis xg'aes kaias koe óá me. ");
INSERT INTO nhr_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ra kò bóò, chìbi-chibi mes gaxu di sa kò gaxu di x'áèan di ii sa, igaba i ko cg'õoèm gha kana qáéèm gha di chìbia ba kg'anoa hãa di chìbian káà a. ");
INSERT INTO nhr_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Eẽr ko ẽem khóèm koe gha hàà kúrúses kàa sa q'ãakaguè, kar ko cúí q'oro tsáá koe tsééa úú me. A ra a gataga ẽe ko chìbi bóò me xu thẽé x'áèan máà, chìbian ẽe xu úú cgoa mea xu gha tsáá koe úú ka,” témé. ");
INSERT INTO nhr_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Xu kò nxãaska ncõo-kg'ao xu gaxu di zi x'áè-kg'áḿ zi komsana, a xu a Paulo ba séè a ntcùú 