﻿USE sofia;
DROP TABLE IF EXISTS sofia.nhgNT_vpl;
CREATE TABLE nhgNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nhgNT_vpl WRITE;
INSERT INTO nhgNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nönca tlapoale de tiebiebetcöhua de Jesucristo, öque iloac iconie David, hua iconie Abraham. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham oyeya tajtle de Isaac, hua Isaac oyeya tajtle de Jacob, hua Jacob oyeya tajtle de Judá hua noche icnihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Hua Judá oyeya tajtle de Fares hua Zara, hua innöntzi de yejua yaja Tamar. Hua Fares oyeya tajtle de Esrom, hua Esrom oyeya tajtle de Aram. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Hua Aram oyeya tajtle de Aminadab, hua Aminadab oyeya tajtle de Naasón, hua Naasón oyeya tajtle de Salmón. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Hua Salmón oyeya tajtle de Booz, hua inöntzi Booz yaja Rahab. Hua Booz oyeya tajtle de Obed, hua inöntzi Obed yaja Rut. Hua Obed oyeya tajtle de Isaí. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Hua Isaí oyeya tajtle de inu rey David. Hua David oyeya tajtle de Salomón, hua inöntzi Salomón yaja öque oyeya isohua de Urías. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Hua Salomón oyeya tajtle de Roboam, hua Roboam oyeya tajtle de Abías, hua Abías oyeya tajtle de Asa. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Hua Asa oyeya tajtle de Josafat, hua Josafat oyeya tajtle de Joram, hua Joram oyeya tajtle de Uzías. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Hua Uzías oyeya tajtle de Jotam, hua Jotam oyeya tajtle de Acaz, hua Acaz oyeya tajtle de Ezequías. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hua Ezequías oyeya tajtle de Manasés, hua Manasés oyeya tajtle de Amón, hua Amón oyeya tajtle de Josías. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Hua Josías oyeya tajtle de Jeconías hua icnihua, cuöc uyajque inu israelitas de priesos ompa Babilonia. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Hua sötiepa de cuöc uyajque ca Babilonia, Jeconías omochi tajtle de Salatiel, hua Salatiel oyeya tajtle de Zorobabel. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Hua Zorobabel oyeya tajtle de Abiud, hua Abiud oyeya tajtle de Eliaquim, hua Eliaquim oyeya tajtle de Azor. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Hua Azor oyeya tajtle de Sadoc, hua Sadoc oyeya tajtle de Aquim, hua Aquim oyeya tajtle de Eliud. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Hua Eliud oyeya tajtle de Eleazar, hua Eleazar oyeya tajtle de Matán, hua Matán oyeya tajtle de Jacob. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Hua Jacob oyeya tajtle de Josie, öque uya inömec María öque tietlöcatele Jesús, öque tietucöyutejque Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ejqueu cate catorce generaciones desde Abraham hasta David, hua nuyejque cate catorce generaciones desde David hasta cuöc uyajque ca Babilonia, hua nuyejque cate catorce generaciones desde cuöc uyajque ca Babilonia hasta cuöc otlöcatihuac Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ejqueyi uya quiene ca otlöcatihuac Jesucristo. Oyeya sente sisehuantu itucö María öque sötiepa uyesquea tienönajtzi. Yaja hua Josie ye omocomprometierojque para monömectisque. Pero antes de mosietelisque, María omoutztlöle por medio de Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Hua Josie, öque uyesquea inömec, yectec tlöcatl oyeya, hua amo oquenequeya quepejpinöjtis. Por inu oquepensöro quecajcöhuas sa ichtacajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Hua cuöc yaja quepensörojtaya ini nönca sösantle, ohuöla sente öngel tli cualtitlanque Tlöcatzintle. Inu öngel moniexte ipa icochtiemequeles Josie, hua oquelfe: ―Josie, öque teca teiconie David, amo xomomajte para tecönas María mosohua. Pues inu peltzintle tli quetlöcatelis, de Espíritu Sönto icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hua quetlöcatelis peltzintle oquechtle, hua tectucöyutis Jesús, ipampa yaja quemöquextis ipuieblo de itlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Noche ini nönca opasöre para ma mochihua tli oquejtojque Tlöcatzintle por icamacopa tlayulepante: ");
INSERT INTO nhgNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Xequejtacö, que sisehuantu moutztlölis, hua quetlöcatelis sente peltzintle oquechtle, hua yejua quecuitisque Emanuel, que quejtusneque: Deus iloac ca tejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuöc otlachix Josie de ipa icocheles, oquechi san quiene ca oquenahuate inu öngel de Tlöcatzintle. Oquesele isohua María, ");
INSERT INTO nhgNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","pero amo itlac omotiecac hasta senamo oquetlöcatele peltzintle hua oquecuite Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Otlöcatihuac Jesús ipa puieblo de Belén ipan tlöle de Judea cuöc oyeya rey yaja Herodes. Hua ohuölajque seque tlajmatque noso magos desde ca cöne quisa tunale hasta por inu ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Hua oquejtojque: ―¿Cöne icaca inu peltzintle tli otlöcat para iyes rey de joriojte? Pues isitlal otequejtaque desde ca ompa ca cöne quisa tunale, hua otehuölajque otecmabesutico. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hua cuöc oquecac ini nönca inu rey Herodes, omotequepacho lalebes, hua noche giente de Jerusalén nuyejque motequepachojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hua oquensentlöle noche jefes de teopexcötzetzi ca tiehua tlamachtiöneme tli quemachtiöya teotlajtule ca inu puieblo. Hua oquentlajtlane cöne noso tlöcates inu Cristo öque Deus oquixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Hua yejua oquelfejque: ―Tlöcates ipa puieblo de Belén ca necö ipan tlöle de Judea. Pues ejqueu tlajcuelulpanca por inu tlayulepante: ");
INSERT INTO nhgNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Taja, Belén de inu tlöle de Judea, amo lalebes tetzitzequetzi tecaca intzölö tlötlajtoönejme de Judá; pues de taja quisas sente tlayecönque, tli quemixutis hua quentlacualtis nopuieblo Israel. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yecuöquenu Herodes sa ichtajcajtzi oquemennutz inu magos, hua oquentlajtlane exactamente quiejquech tunalte quepeaya desde que onies inu sitlale. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Sötiepa oquentitla ca Belén, hua oquemelfe: ―Xeyöcö ompa, hua xetlajtlanecö ca nobeyo por inu peltzintle. Hua sötiepa de cuöc ye nenqueniextejque, xeniechmachestique, para nuyejque naja neyös necmabesutiti. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Hua yejua, cuöc oquecajque inu rey, uyajque. Hua necö inu sitlale tli oquejtaque cöneca quisa tunale, oquenyecöntöya hasta cuöc aseto, hua omoquetz icpac cöne oyeya peltzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Hua cuöc oquejtaque sitlale, oquepexque lalebes bieye pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Hua ocalajque ipan chöntle, hua oquejtaque peltzintle ca inöntzi María. Hua omotlancuöquetzque, hua oquemabesutejque. Hua ocönque de inricojyu, hua oquemacaque tietlöocolelestle de oro, hua copale, hua pajtle pateyo que itucö mirra. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Hua Deus oquennahuatejque ipa incochtiemequeles ma ayecmo yöcö ca itlac Herodes. Entunses uyajque para ca inchö ca pa ocsente ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Hua cuöc uyajque yejua, ohuöla sente öngel de Tlöcatzintle hua omoniexte ipa icochtiemequeles Josie. Oquelfe: ―Xemiehua, hua xecöna peltzintle ca tiehua inöntzi, hua xecholo pa Egipto. Hua ompa xeya hasta senamo naja temetzelfis. Pues inu Herodes quetiemus peltzintle para quemectis. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Hua cuöc yaja otlachix, ucö peltzintle ca tiehua inöntzi ca yohuale, hua uyajque ca Egipto. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hua ompa oyejyeya hasta senamo omec Herodes. Ini nönca opasöre para ma mochihua tli oquejtojque Tlöcatzintle por icamacopa tlayulepante, cuöc oquejto: “Nectzajtzele noConie ma quisa de Egipto”. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Yecuöquenu Herodes omomacac cuienta de que inu magos omoburlörojque de yaja. Entunses ocualö lalebes, hua otlatitla ma quenmejmecticö noche pelantzetzi oquechte tli cate ipa Belén hua noche puieblos tli ca ompa cate. Otlamandöro ma quenmejmecticö tli quepeaya desde ume xebetl para ca tlatzintla, según quiene oquemat de quiejquech tiempo quepeaya de que inu magos oquejtaque inu sitlale. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ejqueu omochihuaco tli oquejto tlayulepante Jeremías: ");
INSERT INTO nhgNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ocaquestec sente tosquetl ipan Ramá, meyac chuquelestle hua tzajtzelestle. Yaja Raquel quenchuqueliöya ipelhua, hua amo quenequeya moyulölis, ipampa ye omejmejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Cache cuöc ye omec Herodes, ohuöla sente öngel de Tlöcatzintle, hua omoniexte ipa icochtiemequeles Josie ompa Egipto. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Oquelfe: ―Xemiehua, hua xecöna peltzintle ca tiehua inöntzi, hua xebeya ipan tlöle de Israel. Pos ye omejmejque niecate tli quetepotztocaya peltzintle para quemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yecuöquenu yaja omie, hua ucö peltzintle ca tiehua inöntzi, hua ohuölajque ca ipan tlöle de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Hua cuöc oquecac que Arquelao tlajtojcötejteca ipa Judea itlacopa Herodes itajtzi, omomajte iyös ompa. Hua ocsajpa Deus quenahuatejque ipa icochtiemequeles, para ma beya ca estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ejqueu uya, hua onemeto ipa sente puieblo itucö Nazaret. Noche inu opasöre para ma mochihua tli oquejtojque tlayulepantejque, pues oquejtojque que Cristo tietucöyutisque nazareno. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Hua ipa inu niecate tunalte ohuöla Xohuö Bautista (quejtusneque Tlacuötiequiöne). Hualtlanunutztöya ipa inu pörtes de Judea cöne nionöque chönte. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Cualejtojtöya: ―Xomoyulcuepacö, ipampa ye aseco tunalte para Deus tlamandörurus nemotlac. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pues de ini nönca Xohuö Deus otlajtlajtuluc por icamacopa inu tlayulepante Isaías, cuöc oquejto: Caquestec tlajtule de yeca tli tzajtzeya ompa cöne nionöque chönte, hua quejtoöya: “Xecyejyectlölicö tieojfe Tlöcatzintle. Xecmejmelöhuacö tieojfe, pues ye miero axihuaqui”. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Quepeaya Xohuö itlaquie de itojmeyo de camello, hua motlajcoilpejtaya ca sente cuetlaxpöxajtle. Hua itlacual oyeya yaja chapolte hua nectle de cormiena tli onca ca caltienco. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Hua quisaya ca yaja noche giente de inu ciudad de Jerusalén hua de noche tlöle de Judea, hua de noche inu locör tli ica itech inu ötlactle de Jordán. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Hua cuöc moyulcuitiöya de intlajtlacul, entunses quencuötiequiöya Xohuö ipa inu ötlactle de Jordán. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hua cuöc oquemejtac yaja meyactie de fariseos ca tiehua saduceos tli ohuölöya para mocuötiequisque, quemelfiöya: ―¡Tlöcaxenöchcuhuöme! ¿Öque onemiechmachte nencholusque de ipa inu cualönelestle de Deus tli huölös nemopa? ");
INSERT INTO nhgNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xecchihuacö noso sösantle tli conbenierebe quechihuas öque de melöhuac ye omoyulcuec. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Hua amo xecpensörojtacö nemojtecopa que yaja Abraham icaca nemotajtzi hua que por inu nencate cuale. Pues naja nemiechelfea que Deus cuale quenchihualtisque ini nöncate teme ma mochihuacö ipelhua Abraham. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Öxö, pues Deus ye miero quenpojpolusque tli amo quechihua tlin cuale. Icaca quiename tlö sente öcha ye intzintlanca cuajme; hua noche cuabetl tli amo quetiemaca ifruto cuale, motzinteques hua motlajcales ijtec tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","’Naja por nopörte nemiechcuötiequea ca ötzintle ipampa nemoyulcuepa. Pero ocsie tlöcatl biloatz sötiepa de naja, öque cache quepealo meyac checöhualestle que naja. Naja amo necmeresieroa nion para necbicas tiecacua. Yejuatzi nemiechcuötiequisque ca Espíritu Sönto hua ica tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yejuatzi iloac quiename sente tlöcatl tli ye miero piehuas para quetzetzelus trigo. Hua quebicas inu trigo tli chepöhuac para ma iye ijtec bescomatl, pero inu itlasolyo quexutlaltisque ijtec inu tletzintle tli ayec siebe. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yecuöquenu ohualiloac Jesús de ipa Galilea para cöne icaca Xohuö itlac inu ötlactle de Jordán. Ohualiloac para ma tiecuötieque Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Cache Xohuö amo quenequeya. Quejtoöya: ―Naja cache cuale necnesesitöroa ma xeniechmocuötiequele tejuatzi. ¿Tlica noso cache tejuatzi noca tomobica? ");
INSERT INTO nhgNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero Jesús onöhuatihuac hua oquelfejque: ―Xejcöhua öxö ma tecchihuacö ini nönca, pues ejqueu conbenierebe ma tecchihuacö noche lo que tli icaca yectec. Yecuöquenu Xohuö omoconformöro hua otiecuötieque. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hua Jesús, sötiepa de cuöc necuötiequiluc, sa nima oquixoac de ijtec ötzintle. Entunses omotlapo elfecac tiepa yejuatzi, hua oquejtaque tieEspíritu de Deus que hualtemoöya quieme sente palumax tiepa yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Hua ocaquestec sente tlajtule ipa elfecac. Quejtoöya: ―Yaja ini nönca noConie, öque nectlasojtla. Ica yaja necpea meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yecuöquenu Espíritu Sönto tiebicaluc Jesús ca ompa cöne nionöque chönte para ompa tieyulmajmötocas inu Diöblo. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Hua cuöc amo otlacualuc cuarenta tunale hua cuarenta yohuale, sötiepa oteosebihuac. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Hua cuöc oaseto inu tieyulmajmötocane, otieyelfe: ―Tlö teca teiconie Deus, xequejto ma ini nöncate teme ma mocuepacö pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Cache yejuatzi onöhuatihuac, oquelfejque: ―Tlajcuelulpanca: Amo sa ca pöntzi cuale nemes sente tlöcatl, cache quenesesitöroa de noche tlajtule tli quisa tiecamacopantzinco Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Yecuöquenu Diöblo otiepanulte ipa inu ciudad de Deus, que yaja Jerusalén, hua tietlejcabe hasta icuayuluc teopantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Hua otieyelfe: ―Tlö tecaca teiconie Deus, xomocajcöhua hasta tlölpa. Pues ejqueyi tlajcuelulpanca: Cualentitlanesque tieöngeles por mopampa, hua metzajcoquesque ca inmöhua, para que ejqueu mocxehua amo moteputlamesque ica teme. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesús oquelfejque: ―Pues nuyejque tlajcuelulpanca: “Amo xetietantiöro Tlöcatzintle moDeus para abier tlö cuale quechihuasque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ocsajpa Diöblo tiebicac hasta icpac sente tepietl bieye, hua tieyejtete noche reinos hua naciones de tlöltecpactle, hua noche incualniexteles. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Hua otieyelfe: ―Noche ini nönca temetzmacas tlö nixpa tomotlancuöquetzas hua teniechmabesutis. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yecuöquenu Jesús oquelfejque: ―Xebeya, Satanás, ipampa tlajcuelulpanca: Yejuatzi Tlöcatzintle moDeus tetiemabesutis, hua sa yejuatzi tetietequepanus. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yecuöquenu Diöblo tiecöjtie. Entunses oaseco öngeles hua tietequepanoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sötiepa Jesús oquecajque que Xohuö ye oquetzajtzajque ipan cörsel. Entunses Jesús onecuepaluc ca inu tlöle de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Hua oquixoac de Nazaret, hua onemoaco ipa sente puieblo itucö Capernaum, que icaca itienco ötiescatl, cöne ica itlamejyo de inu tlöle de Zabulón hua de Neftalí. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ejqueu opasöre para ma mochihua tli oquejto inu tlayulepante Isaías. Pues oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Inu tlöle de Zabulón, hua inu tlöle de Neftalí, ojtle tli pano itienco ötiescatl, ca nie löro de Jordán, tlöle de Galilea cöne chajchönte meyactie tli amo cate de topuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Noche inu giente tli yejyehuataya ca tlajtlayohuaquelestle pa inyulo oquejtaque bieye tlaniextelestle, hua tli yejyehuataya ipa inu locör de tlayohuaquelestle de mequelestle, tlöbile oquentlaniextele. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Desde cuöquenu opiehualuc Jesús para tlanunutzalus, hua quejtuloöya: ―Xomoyulcuepacö, ipampa ye ajaseco tunalte para Deus tlamandörurus nemotlac. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Hua nejnemoatenemeya Jesús itlac ötiescatl de Galilea. Oquemejtaque unte icnijte: Semu, öque nuyejque mocuitea Piero, hua Andrés icni. Quetlajcaleya tarröya ijtec ötiescatl, pues yejua oyejyeya pescadurte. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Hua oquemelfejque: ―Xeniechtocacö, hua nemiechchihualtis nenyesque nenpescadurte de tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Yejua sa nima oquecöjtiejque intarröya, hua tietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Hua cuöc opanoac de ompa oquemejtaque oc unte icnijte: yaja Jacobo, iconie Zebedeo, ca tiehua icni itucö Xohuö. Yejua oyejyeya ipan börco ca tiehua intajtzi, hua quenyejyectlöliöya intarröyajua ye otlajtlatzcotu. Hua yejuatzi quennutzque. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Hua sa nima quecöjtiejque inu börco ca tiehua intajtzi, hua tietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Hua biloatenemeya por noche inu tlöle de Galilea, hua otlamachtiloöya ipan inteopancuconehua de yejua. Tlanunutzaloöya de inu cuale tlamachestelestle de quiene Deus tlamandöruro. Hua otlapajtilutöya de noche cocolestle hua de noche tiecoco tli quepeaya giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Hua caquesteya tieyectieniehuales ipa noche inu tlöle de Siria. Hua giente tiehualequelejque noche tlin cocolesyojque, tli quepejpeaya de noche sösantle cocolestle, hua tli quepejpeaya demunios, hua tli lucojte hua tli cojcultzetzi. Hua yejuatzi oquenpajtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hua otietocaya meyac giente de inu tlölte de Galilea hua de Decápolis hua de inu ciudad de Jerusalén, hua de inu tlöle de Judea, hua de ca nie löro de inu ötlactle de Jordán. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Hua cuöc oquejtaque inu meyac giente, otlejcoac ipan tepietl, hua ompa netlöliluc. Hua omopachojque tietlac tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Hua yejuatzi oquetlapojque tiecamac hua quenmachtejque. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Cuale imicnupel tli momachelea porubejte ipa inyulo, pos yejua quepejpea pörte cöne Deus tlamandöruro ipa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Cuale imicnupel tlin chojchuca, pos yejua moyulölisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Cuale imicnupel tli modominöroa cuale hua amo papasolte, pues yejua mohuöxcatisque inu tlöle tli Deus queprometierojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Cuale imicnupel tli lalebes queneque yesque yecteque, quiename cuöc öque teosebe hua ömeque. Pues yejua ixbesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Cuale imicnupel tli tlaicnuyejta, pos Deus quemicnuejtasque yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Cuale imicnupel tli chepöjtecate ipa inyulo, pos yejua tieijtasque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Cuale imicnupel tli quechihua siebelestle entre tli moponieroa, pos yejua mocuitisque tiepelhua de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Cuale imicnupel niecate tli ocseque quentepotztoca porque yejua cate yecteque, pos yejua quepeasque pörte cöne Deus tlamandöruro ipa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Cuale nemocnupel cuöc giente nemiechpöpöca, hua nemiechtepotztoca, hua cuöc nemoca tlajtoa de noche tlin amo cuale ca istlacatlajtule, hua ejqueu nemiechchibelea porque nenniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xepajpöquecö hua xecpeacö meyac pöquelestle, ipampa inu premio tli nenqueselisque ompa elfecac cache bieye iyes. Pues ejqueu nuyejque quentepotztocaque inu tlayulepantejque tli cachto ohuölajque que nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’Nemejua nencate quiename nenestatl para tlöltecpactle. Hua tlö yestatl mocuepas öbielec, ¿tli ica mopoyelis? Ayecmo serbirebes para niontle, tlöcamo sö para motlajcalis ca queyöhuac ma ipa moquejquetzacö giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’Nemejua nencate quiename nentlöbile de tlöltecpactle, quiename sente ciudad tli icaca ipa sente tepietl hua abele mojyönas. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nuyejque ica melöhuac que amo moxutlaltea sente cantil para öque quetlölis itzintla sente almu. Cache öque quetlölea ipa sente canteliero, hua ejqueu quentlaniextelea noche tli cate ipan chöntle. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pues ejqueu ma tlaniexte nemotlöbil imixtla noche giente, para ma quejtacö tlin cuale nemotlachihual, hua ma tiemabesuticö nemoTajtzi öque elfecac iloac. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","’Amo xecpensörucö que naja nehuöla para necxexetunis inu ley de Moisés nimpor lo que oquejcuelojque inu tlayulepantejque. Amo onehuöla para netlaxexetunico, cache onehuöla para nejcumpliruco. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pues nemiechelfea, que de melöhuac hasta senamo tlames elfecac hua tlöltecpactle, nion sente lietra, por mös tzitzequetzi oyene, amo polebes de ipa inu ley, tlöcamo mochihuas noche sösantle tli ompa tlajcuelulpanca. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Por inu tlö canajyeca amo queneltocas sente mandamiento de inu ley, por mös tzitzequetzi oyene, hua tlö ejqueu quenmachtis ocseque giente para amo queneltocasque, inu tlöcatl lalebes tzitzequetzi iyes ompa cöne Deus tlamandöruro. Cache tlö canajyeca quechihuas hua tlamachtis inu mandamiento, yaja momajtas bieye ompa cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pues nemiechelfea que tlö quejtus nemoyectlachihual amo iyes cache cuale que lo que tli quechihua inu fariseos hua tlamachtiöneme de teotlajtule, amo nencalaquesque ompa cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’Ye nenquemajmate que omojto ca tobiebetcöhua: “Amo xetlamecte”, hua: “Tlö canajyeca tlamectea ica en peligro de que quecuntenörusque tlajtoönejme de ipuieblo”. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Cache naja nemiechelfea, que tlö canajyeca cualönes ica icni, ica en peligro de que quecuntenörusque tlötlajtoönejme del puieblo. Hua öque quelfis icni: “Raka” (quejtusneque Tunto), ica en peligro para quecuntenörusque inu tlajtoönejme del cubierno. Hua öque quelfis icni: “Taja sie tiro tetunto”, ica en peligro de que iyös ipa tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Por inu, cuöc tejcualecas bentle ipa ajtöl, hua ompa tequelnömeques que mocni quepea canajyetla ca taja, ");
INSERT INTO nhgNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pues ompa xejcöjtiehua bentle ixpa ajtöl, hua xebeya ca mocni, hua cachto xomotlapojpolficö. Entunses sötiepa xehuöla hua xejcuetlabilte inu bentle. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Mientras teya pa ojtle ca moenemigo sa nima xecnunutza hua xomotlöle de acuierdo ca yaja; amo cana mochihuas que moenemigo metzmöctis ica tlajtoöne, hua tlajtoöne metzmöctis ica cörseliero hua metzcalaquis ijtec cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Melöhuac temetzelfea, que amo tequisas de ompa hasta senamo tectlaxtlöhuas hasta inu sölúltimo quinto de tli tectietlabiquelea. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’Nenquemate que omojto: “Amo tecalaques ca isohua ocsente”. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Cache naja nemiechelfea, que tlö canajyeca sa quejta sente sohuatl para quixeliebis, pues ipa iyulo ye tlajtlacojteca ca inu nieca sohuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ca inu, tlö quejtus mixtelolo de ca momöyecmö metzchihualtea tetlajtlacus, xejcopina, hua xectlajcale de taja. Pos cache metznömeque ma polebe sie pörte de mocuierpo, hua majcamo que noche mocuierpo quetlajcalesque ijtec tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hua tlö quejtus momöyecmö metzchihualtea tetlajtlacus, xectejteque, hua xectlajcale de taja. Cache metznömeque ma polebe sie pörte de mocuierpo, hua majcamo que noche mocuierpo quetlajcalesque ijtec tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Nuyejque omojto: “Öque quecajcöhuas isohua, ma quemaca ömatl de necajcöhualestle”. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Cache naja nemiechelfea, que tlö canajyeca quecajcöhua isohua hua amo quechihua porque isohua otlajtlaco ca ocsente tlöcatl, cache quechihua por ocseque sösantle, yaja quechihualtea que isohua tlajtlacus. Hua öque mosohuajtis ca inu sohuatl tli inömec quecajcö, yaja tlajtlacoa porque inu sohuatl ye quepea inömec, mös amo quepexteca. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Nuyejque nenquemate que omojto ca tobiebetcöhua: “Amo xequejto ¡Cabelele paltzinco! ica istlacatelestle”, hua: “Cuöc tetieprometierfis Deus canajyetla, xejcumpliro”. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Cache naja nequejtoa: Ayec canajquiema amo xequejtucö “¡Cabelele paltzinco!” Nimpor amo xetlajurörucö por elfecac, ipampa ica quiename tietrono de Deus, hua tlö ejqueu nenquechihuasque ica iguöl quiename tlö nenquejtoöne “¡Cabelele paltzinco!” ");
INSERT INTO nhgNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nimpor amo xetlajurörucö por tlöltecpactle, ipampa yaja ica quiename cöne quesiebilo tieicxehua. Nimpor amo xetlajurörucö por Jerusalén, pues yaja ica tieciudad de inu Rey bieye, que yejuatzi iloac Deus. Tlö nentlajurörusque por nöncate sösantle ica iguöl quieme tlö nenquejtoöne “¡Cabelele paltzinco!”, noso “¡Por Deus!” ");
INSERT INTO nhgNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nuyejque amo xetlajuröro por motzonteco ipampa abele tecchihuas sente motzo ma iye istöc hua ocsente capotztec. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Cache cuale ma ejqueyi iye nemotlajtul: que cuöc nenquejtoa “Quiema”, ma iye quiema, hua cuöc nenquejtoa “Amo”, pos ma iye amo. Pos amo cuale ica öque quesölultis tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’Ye nenquemate que omojto ejqueyi: “Tlö canajyeca quixcopina ocsente, xequixcopinacö yaja nuyejque, hua tlö quetlancochcopina, xectlancochcopinacö yaja nuyejque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Cache naja nemiechelfea: Amo xejcuajnömequecö tlö canajyeca queneque nemiechchibelis tlin amo cuale. Cache tlö quejtus metzmaca ipa moxöyac de momöyecmö, xomocuepa para ma metzmaca nuyejque de ocsie löro. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Hua tlö canajyeca queneque metzbicas ca tlajtoönejme para metzcuejcuelis mocamixa, xecmaca nuyejque mosaröpe. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tlö canajyeca queneques metzchihualtis para tetlamömajtös sie kilómetro ca yaja, pos xebeya ume kilómetro ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Öque metztlajtlanelis canajyetla, xecmaca, hua öque queneques motlacuis canajyetla de taja, amo xectzacuele. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Ye nenquemate que omojto: “Xectlasojtla motlöcaicni, hua xectlajyelejta moenemigo”. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Cache naja nemiechelfea: Xequentlasojtlacö nemoenemigos, hua xomotlajtlötlajticö por niecate tli nemiechtepotztoca. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Pues ejqueu nieses que melöhuac nencate nentiepelhua de nemoTajtzi öque iloac elfecac. Pues yejuatzi quechihualo ma quisa tunale impa tlin amo cualteque hua tlin cualteque, hua ma queyabe impa tli yecteque hua tli amo yecteque. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pues tlö nenquentlasojtlasque sa öque nemiechtlasojtla, ¿tli tlaxtlöbile nenquepeasque ompa elfecac? ¿Amo nuyejque ejqueu quechihua inu tlanechecojque hua ocseque amo cualteque? ");
INSERT INTO nhgNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Hua tlö nenquentlajpaloa sa tlin nemocnihua, ¿tli nenquechihua que ocseque amo quechihua? Pues hasta giente que amo joriojte nuyejque quechihua ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xeyecö, noso, nemejua nenyejcualteque, quiename nemoTajtzi öque iloac elfecac yejcualtec iloac. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Xecpeacö cueröro cuöc nenquechihuasque tlin cuale amo xecchihuacö imixtla giente para que yejua nemiechejtasque. Pues tlö ejqueu nenquechihua amo nenqueselisque inu premio tli quetiemacasque nemoTajtzi öque elfecac iloac. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","’Por ejiemplo, cuöc canajyetla nentietlöocolisque amo xecchihuacö para ma machea lalebes. Pues ejqueu quechihua inu giente de ume inxöyac. Pues yejua quisa ipa teopanme hua ipan plösas hua quenejneque ma quemejtacö innochtie, para que ejqueu quenyectieniehuasque. Melöhuac nemiechelfea, ye quepea intlaxtlöbil. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Cache taja, cuöc canajyetla tetietlöocolea, majcamo quemate nionöque mösque oyene moamigo lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ejqueu motietlöocoleles iyes sa ichtacajtzi, hua moTajtzi Deus öque cuale quejtalo mös tectiemaca sa ichtacajtzi, yejuatzi metzcuepelisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’Hua cuöc nemotlajtlötlajtea, amo xecchihuacö quieme inu niecate que quepea ume inxöyac. Pues yejua quecualejta moquetzasque ipan teopanme noso ipa esquinas de cayajunte, hua ompa motlajtlötlajtea, para ma quemejtacö noche giente. Melöhuac nemiechelfea, que ye quepea intlaxtlöbil. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Cache taja, cuöc tomotlajtlötlajtis, xecalaque sa mosiel ipa mocalejtec, hua xectzacua pobielta, hua xomotlajtlötlajte tiecatzinco moTajtzi öque abele öque tieyejtas. Pues moTajtzi quejtalo lo que tli sa ichtacajtzi, hua yejuatzi metzcuepelisque por lo que tli tecchihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Hua cuöc tomotlajtlötlajtis, amo seme xequejtojta sö ye yaja sösantle hasta que ayecmo quejtusneque niontle. Pos ejqueu quechihua inu giente tli quentoca ocseque deuste. Pues yejua quepensöroa que beles ipampa lalebes tlajtlajtoa indeus cuale quencaques. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Amo xomochihuacö, noso, quiename yejua. Pues nemoTajtzi quematihuateca tli sösantle nemiechpoloa, antes de que nentietlajtlanelisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nemejua, noso, xomotlajtlötlajticö ejqueyi: ToTajtzi öque elfecac tomobetzteca, ma innochtie ma queyectieniehuacö motucöyutzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ma aseque inu tunale cuöc tomotlamandörfis. Ma mochihua tli motlanequelestzi necö ipan tlöltecpactle, quieme nuyejque mochihua ompa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Xetiechmomaquele öxö totlacual de ini nönca tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Hua xetiechmoperdonörfe de lo que tli temetzmotlabiquelelea, quiename tejua nuyejque ye tequenperdonörojque quiejquech tiechtlabiquelea. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Hua amo xetiechmocöbele ma tiechyulmajmötoca Amo Cuale Tlöcatl, cache xetiechmomöquextele de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Pues tlö nenquenperdonörfisque giente de noche tli nemiechchibelea, nemejua nuyejque nemiechperdonörusque nemoTajtzi öque elfecac iloac. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Cache tlö quejtus amo nenquenperdonörusque giente, nuyejque nemejua nemoTajtzi amo nemiechperdonörusque de lo que tli amo cuale nenquechihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Hua cuöc nentlajyubea, amo xeyecö quieme inu giente de ume inxöyac, tli niese quieme sana mocojcocoa cuöc tlajyubea. Pos yejua quepatla inxöyac para niesesque imixtla giente nele melöhuac tlajyubea. Melöhuac nemiechelfea, que ye quepea intlaxtlöbil. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Cache taja, cuöc tetlajyubis, xomoyejyecpachoasfe hua xecpajpöca moxöyac. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Pues ejqueu giente amo momacasque cuienta tlö tetlajyubea, tlöcamo sa nemacus cuienta moTajtzi sa ichtacajtzi. Hua yejuatzi moTajtzi öque quejtalo tli sa ichtacajtzi, yejuatzi metzcuepelisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Amo xectlamachtlölicö nemoricojyu necö ipan tlöltecpactle, cöne tlacuacualoa hua tepostlöloa, hua ichtejque calaque para tlachtequesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Cache cuale nemoricojyu ma iye sösantle de elfecac, cöne nimpor amo tlacuacualoa nimpor tepostlöloa, hua cöne ichtejque abele calaquesque para tlachtequesque. Ompa elfecac xectlamachtlölicö nemoricojyu. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pues cöne iyes nemoricojyu, ompa queneques iyes nemoyulo nuyejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Tlöbile de tocuierpo yaja toixtelolo. Ejqueu, tlö toixtelolo amo mococoa, noche tocuierpo quepeas tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Cache tlö toixtelolo amo cuale ica, noche tocuierpo quepeas tlajtlayohuaquelestle. Hua tlö ejqueu inu tli uyesquea tlöbile para tocuierpo mocuepa tlajtlayohuaquelestle, lalebes petzotec icaca inu tlayohuaquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Nionöque abele quentequepanus umeme itiecohua. Pues quetlajyelejtas sente hua quetlasojtlas ocsente, o noso mopachus itlac sente hua quedespresiörus ocsente. Abele nentietequepanusque Deus mientras nuyejque nenquetequepanoa ricojyutl. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Hua ca inu nemiechelfea: Amo xomotequepachucö por nemonemeles, por tli nenquecuösque, noso tli nenconisque. Nimpor amo xomotequepachucö por quiene nenquetlaquentisque nemocuierpo. Pues ye nenquepea nemonemeles, hua yaja inu melöhuac cache balierebe que tlacuale. Hua ye nenquepea nemocuierpo, que melöhuac cache balierebe que tlaquentle. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xequemejtacö tutume tli patlöne ipa yejyecatl. Yejua amo tlajtlatuca, nimpor amo pejpexca, nimpor amo tli quetejtiema ipa inbesco. Hua nemoTajtzi öque elfecac iloac yejuatzi quentlacualtilo. ¿Beles nenquejtusque que amo cache nenbajbalierebe nemejua que yejua? ");
INSERT INTO nhgNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Hua nionöque de nemejua, por mös motequepachus lalebes, abele mobepöhuas nion tlajco mietro por yaja mismo. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Hua por inu tlaquentle, ¿tli para nemotequepachoa? Xequejtacö cuale quiene mobepöhua xucheme de ca caltienco. Amo tejtequete nimpor amo quechejchihua tlaquentle. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Cache nemiechelfea que nimpor Salomón ca noche icualniexteles ayec omotlaquente quiename sente de inu niecate xucheme. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Hua tlö quejtus xebetl que öxö icaca, hua para mustla ye motlajcale ijtec tletzintle, Deus quetlaquentilo ejqueu, ¿tlica noso nenquepensöroa que abele quechihuasque por nemejua? Pues cache ca meyac arrasu nemiechtlaquentisque nemejua, tlöca que nemiechpoloa neltoquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amo xomotequepachucö noso, hua amo xequejtucö: “¿Tli tejcuösque?” noso “¿Tli teconisque?” noso “¿Tli töquisque?” ");
INSERT INTO nhgNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pues giente que amo tieixomate Deus quetiemoa ini nönca sösantle. Pero nemoTajtzi öque elfecac iloac ye quematihuateca de que nemiechpoloa noche ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pero cachto xectiemucö ma Deus tlamandörucö hua ma mochihua tli yectec tli yejuatzi quenequihua. Entunses nuyejque nemiechmacasque noche ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","’Por inu, amo xomotequepachucö de lo que tli mustla huölös, pues mustla metztocörus tomotequepachus de inu sösantle. Cöra tunale quebicas itequepachul, hua amo quenesesitöroa cache meyac. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Amo xetlaestlocucö, para que ejqueu amo nemiechestlocusque. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ipampa ejqueu quieme nemejua nentlaestlocoa, ejqueu mismo nemiechestlocusque. Hua san quiene nequentemachibelea ocseque giente, ejqueu mismo nemiechtemachibelisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Hua cuöc tequemestlocoa ocseque, icaca quiename tlö tequejtelea sente tlasolconetzi ijtec ixtelolo de mocni, pero amo tomojtelea que taja mismo tecpea sente cuabetl bieye ijtec mixtelolo. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Quiene noso tequelfis mocni: “Xomocöhua ma temetzquextele inu tlasole tli tecpea ijtec mixtelolo”, mientras tecpea cuabetl ijtec mixtelolo taja? ");
INSERT INTO nhgNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Sa ume moxöyac! Xejquexte cachto inu cuabetl de ijtec mixtelolo taja para que ejqueu cuale ye tequejtas para cuale tejquextis inu tlasole de ijtec ixtelolo de mocni. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Inu sösantle tli yectec amo xequenmacacö checheme, hua lo que tli balierebe lalebes amo xequensemanelicö petzome. Majcamo iye que ipa moquejquetzasque hua cana de repiente mocuepasque nemopa hua nemiechcocototzasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Xetlajtlanecö, hua nemiechmacasque. Xectiemucö, hua nenqueniextisque. Xetzajtzecö, hua nemiechtlaijtlapolfisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pues noche nieca öque tlajtlane, queselea; hua öque quetiemoa, queniextea; hua öque tzajtze, quetlaijtlapolfea. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Pos nionöque de nemejua, tlö quejtus iconie quetlajtlanelis pöntzi, amo quemacas sente tietetu. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Hua tlö cana iconie tlajtlanes meche, amo quemacas sente cuhuötl. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Entunses tlö nemejua, mös amo nencate nencualteque, pero nenquemate nenquetiemacasque lo que tlin cuale ca nemopelhua, pues cache ca meyac arrasu ejqueu quechihuasque nemoTajtzi öque elfecac iloac, hua quetiemacasque noche sösantle tlin cuale cuöc yeca tietlajtlanelea. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Por inu, noche sösantle tli nenqueneque ma nemiechchibelicö giente ca nemejua, ejqueu nuyejque xequenchibelicö yejua. Pues tlö nenquechihuasque ini nönca, nenquecumplirusque noche tli nemiechelfea inu ley hua inu tlayulepantejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’Xecalaquecö ca pa inu trönca tli pitzutec. Pos tlapojque trönca, hua patlöhuac ojtle tli tiebica ipa ixniempolebelestle, hua meyactie giente calaque ipa inu ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero lalebes pitzutec trönca, hua pipetzatzi ojtle tli tiebica ipa nemelestle, hua amo meyactie queniextea. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Xomomalficö de giente tli huölösque quiename tlayulepantejque pero amo de melöhuac cate. Yejua cate quiename tlö sente coyutl moquentiöne de calnielo, hua calaquene intzölö calnielojte. Ca pane niese que calnielo icaca, cache de melöhuac ica tiecuöne. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Inca intlachihual nenquemixomatesque inu giente. ¿Beles noso cuale öque queteques capole itech bechöche? Noso ¿cuale öque queteques icox itech sacajpule? ");
INSERT INTO nhgNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ejqueu pues, noche tlin cuale cuabetl quetiemaca tlin cuale ifruto; cache tlin amo cuale cuabetl amo cuale ifruto quetiemaca. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Abele tlin cuale cuabetl quetiemacas tlin amo cuale ifruto, nimpor tlin amo cuale cuabetl abele quetiemacas tlin cuale fruto. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Noche cuabetl tli quemochihualtea amo cuale ifruto, ica para quetequesque hua quetlajcalesque ijtec tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ejqueu pues, por infrutos nenquemixomatesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Meyac giente niechelfea: “Tlöcatzintle, Tlöcatzintle”, pero amo innochtie calaquesque cöne Deus tlamandöruro ompa elfecac. Sa calaquesque tli quechihua tietlanequeles de noTajtzi öque iloac elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Meyactie niechelfisque ipa inu nieca tunale: “Tlöcatzintle, Tlöcatzintle, ¿amo tomolnömequitea que tejua tetlayulepantejque motucöyupantzinco, hua motucöyupantzinco tequenquextejque demunios, hua motucöyupantzinco tecchijque meyac tietzöbetl?” ");
INSERT INTO nhgNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Cuöquenu naja nequemelfis: “Ayec nemiechixomat. Xomoxelucö de naja, nemejua tli nenquechihua tlin amo cuale”. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Por inu, tlö canajyeca quecaque nönca notlajtul, hua quechihua, cuale mocomparörus quiename sente tlöcatl tli cuale oquepensöro. Yaja oquequetz ical ipa tepetlatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hua ohuöla queyabetl, hua oyejcoc ötzintle, hua otlalpitz yejyecatl, hua oquecuajnömejque inu nieca cale. Pero amo obetz, ipampa oijcataya ipa tepetlatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero tlö canajyeca quecaques nönca notlajtul, hua amo quechihuas, nejcomparörus quiename sente tlöcatl tunto, que oquequetz ical ipa xöle. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hua ohuöla queyabetl, hua oyejcoc ötzintle, hua otlalpitz yejyecatl, hua oquemagac checöhuac inu cale. Hua obetz cale, hua omochi bieye tlaxexetochelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Hua sötiepa, cuöc Jesús oquesencöjque ini tlajtule, noche giente quetietzöbejtaya de quiene tlamachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Pues quenmachtiloöya quiename öque quepea autoridad, hua amo quiename quenmachtiöya inu tlamachtiöneme de teotlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Cuöc hualtemoac de ipan tepietl, tiehualtocaya meyac giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Hua necö sente tlöcatl sa söhuayo ohuöla, hua tiemabesutiöya. Oquejto: ―Tlöcatzintle, mach tomonequitis, cuale teniechmopajtelis. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Hua omösohualuc Jesús, hua oquemötocaque. Oquejtojque: ―Necneque; xepajte. Hua sa nima icocoles opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yecuöquenu Jesús oquelfejque: ―Xequejta, amo öque xequelfe tli metzpasöro. Cache xebeya, xomotieijtete ica teopexque. Hua xetlacuetlabilte inu bentle tli otlanahuate Moisés, para ma quematecö yejua lo que tli omochi ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Hua ocalacoac Jesús ipa inu puieblo de Capernaum. Cuöquenu ohuöla tietlac sente capetö, hua tietlajtlötlajte, ");
INSERT INTO nhgNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","hua otieyelfe: ―Tlöcatzintle, notlatequepano betzteca ompa nochö cojcultzi, ca lalebes checöhuac tietunie. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Hua Jesús oquelfejque: ―Naja neyös hua necpajtis. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Hua onöhuat inu capetö, hua oquejto: ―Tlöcatzintle, amo necmeresieroa para tomocalaquis ipa nochö. Cache sa xomojtalfe sente tlajtule, hua notlatequepano pajtes. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Pues naja nuyejque necpea que nequenneltocas tli cache quepea autoridad que naja. Hua nuyejque nequenpea soltörojte tli niechneltoca naja. Hua tlö nequelfea sente: “Xebeya niepa”, yaja iya. Hua tlö nequelfea ocsente: “Xehuöla”, yaja yebitz. Hua tlö nequelfea notlatequepano: “Xecchihua ini”, pues yaja quechihua. Ejqueu necasojcömate que tejuatzi tomopilea checöhualestle para tomopajtelis notlatequepano ca sente tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Hua cuöc Jesús oquecajque ini nönca, oquetietzöbejque. Hua oquemelfejque quiejquech tietocaya: ―Melöhuac nemiechelfea, que nimpor inca giente de Israel amo onecniexte tönto lalebes meyac neltoquelestle quiename quepea ini nönca tlöcatl, mös amo de Israel icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hua nemiechelfea que huölösque meyac giente de cöneca quisa tunale hua de cöneca calaque tunale. Yejua motlölisque itlac Abraham, hua Isaac, hua Jacob, ompa elfecac cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero meyactie de nemejua tli nenjoriojte, tli nemiechtocörusquea para nenquepeasque pörte ca ompa, nemiechtlajcalesque ca queyöhuac ipa tlajtlayohuaquelestle. Ompa nenchojchucasque hua nemotlantesesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yecuöquenu oquelfejque inu capetö: ―Xebeya, hua san quiene ca tomoneltocac ma ejqueu mochihua. Hua itlatequepano opajtec ipa inu ura. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Hua obiloac Jesús ipa ichö Piero. Ompa oquejtaque imontiesyo Piero betztaya ipa tlapechtle ca totunealestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Hua oquemötocaque imö, hua totunealestle oquecö. Hua yaja omie hua tietlamacaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Hua cuöc omochi ca ye yohuac, quenhualecaque tietlac meyactie tli quepeaya demunios. Hua oquenquextejque inu demunios sa ca sente tlajtule, hua oquenpajtejque innochtie tli mocojcocoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ejqueu omochi lo que tli omojto por icamacopa tlayulepante Isaías, cuöc oquejto: Sie yejuatzi oquemönele tococoles, hua oquebicaque totuniejcöyu. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Hua cuöc oquejtaque Jesús que meyac giente tieyehualojtaya, otlanahuatiluc ma panucö ca icuetlapa ötiescatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Hua oaseco sente tlamachtiöne de teotlajtule, hua otieyelfe: ―Maestro, temetzmotoquelis cöne beletes tomobicas. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Hua Jesús oquelfejque: ―Coyume quenpea inustuhua, hua tutume tli patlöne ipa yejyecatl quepea intepasol; cache naja, öque onochi netlöcatl, amo necpea cöne necsiebis notzonteco. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Hua ocsente de tiemachtejcöhua otieyelfe: ―Tlöcatzintle, xeniechmocöbele ma nebeya cachto, ma nectlölpachute notöta. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hua Jesús oquelfejque: ―Xeniechtoca; xequencajcöhua que mimejque ma quentlölpachucö inmimejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Hua cuöc yejuatzi ocalacoac ijtec börco, tiemachtejcöhua nuyejque ocalajque. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yecuöquenu omochi sente bieye öyejyecatl ipa ötiescatl, que inu börco cöso motlapachoöya ca ötzintle. Cache yejuatzi cochihuaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Hua omopachojque tiemachtejcöhua, hua otieixetejque. Otieyelfejque: ―¡Tlöcatzintle, xetiechmomöquextele, pues temequesque! ");
INSERT INTO nhgNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Hua yejuatzi oquemelfejque: ―¿Tlica nemomajtea? Lalebes nemiechpoloa neltoquelestle. Yecuöquenu neyehualuc, hua quemajajuaque yejyecatl ca tiehua ötzintle. Hua sa nima omoquetzque complietamiente. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Hua inu tlöca oquetietzöbejque. Oquejtojque: ―¿Tli tlöcatl iloac ini nöiloac? Pues hasta yejyecatl hua ötzintle tieneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Hua cuöc yejuatzi onaxihuato ca nie löro intzölö giente de puieblo de Gadara, tienömequeco unte tlöca tli quepejpeaya demunios. Inu tlöca hualquistiejque de ijtec mejcöcoyocme. Petzoteque oyejyeya lalebes, que hasta nionöque abele panuya ipa inu nieca ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Cuöc yejua tieijtaque Jesús, otzajtzeque, hua oquejtojque: ―¿Tli tecpea tejua ca taja, öque teca teiconie Deus? ¿Otehuöla necö para tetiechmacas tiecoco antes ases ura? ");
INSERT INTO nhgNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Hua tepetzi bejca de yejua oyejyeya meyactie petzome tlajtlacuajtenemeya. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Entunses inu demunios otietlajtlötlajtejque, otieyelfejque: ―Tlö tetiechquextis, xetiechcöhua ma tecalaquecö imijtecopa inu meyactie petzome. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Hua oquemelfejque: ―Xeyöcö noso. Hua yejua oquistiejque de imijtec tlöca, hua uyajque inca petzome. Hua ye ompau innochtie inu niecate petzome omomiemeröjque omotietepexebito ijtec ötiescatl. Hua innochtie omejmejque ijtec ötzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Hua inu giente tli quentlajtlacualtejtenemeya petzome ochucholojtiejque. Cuöc oaseto ipa puieblo, oquepujque noche sösantle hua tli omochi inca inu tlöca tli quepeaya demunios. ");
INSERT INTO nhgNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Yecuöquenu, noche tlöca de inu puieblo otienömequeco Jesús, hua cuöc otieijtaque, tietlajtlötlajtejque ma quixoa de intlöl. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yecuöquenu ocalacoac ijtec börco. Opanoac hasta ocsie löro de inu ötiescatl, hua ohualiloac ipa tiepuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yecuöquenu seque tlöca otiecualequelejque sente biebelatzi, hualbetztöya ipa tlapechtle. Hua Jesús nemacuc cuienta quiene moneltocaya yejua. Entunses oquelfejque inu cojcultzi: ―Xemanimöro, noconie; motlajtlacul ye omoperdonöro. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Yecuöquenu, seque de inu tlamachtiöneme de teotlajtule oquejtojque imijtecopa: “Ini nönca checuatlajtoa encuntra de Deus”. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pos Jesús nemacuc cuienta de lo que tli yejua quepensöroöya, hua oquemelfejque: ―¿Tlica nenquepensöroa amo cuale ipa nemoyulo? ");
INSERT INTO nhgNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Pues ¿cötlaja cache tequeyo, nequelfis: “Ye omoperdonöro motlajtlacul”, noso nequelfis: “Xemiehua, hua xenejneme”? ");
INSERT INTO nhgNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pos öxö nenquematesque que naja öque onochi netlöcatl necpea deriecho necö ipan tlöltecpactle para necperdonörus tlajtlacule. Entunses oquelfejque inu biebelatzi: ―Xemiehua. Xecöna motlapech, hua xebeya pa mochö. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Entunses inu biebelatzi omoquetz hua uya ipa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Hua inu giente, cuöc oquejtaque, omomajtejque, hua tiechamöjque Deus, porque yejuatzi oquetiemacaque inu checöhualestle ca tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Hua cuöc Jesús quixoac de ompa, oquejtaque sente tlöcatl tlanecheco oyehuataya ipa sente miesa cöne caresibiroöya tomi. Ini nönca tlöcatl itucö oyeya Mateo. Hua Jesús oquelfejque: ―Xeniechtoca. Hua yaja omajcoc, hua tietocac. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Hua omochi que cuöc yejuatzi yehualutaya itlac miesa ipan chöntle, nuyejque meyactie tlanechecojque ca tiehua giente tlajtlaculteque nuyejque ohuölajque omotlölico itlac miesa ca Jesús hua ca tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Hua inu fariseos oquejtaque ini nönca, hua oquemelfejque tiemachtejcöhua: ―¿Tlica tlacua nemomaestro inca tlanechecojque hua ocseque tlajtlaculteque? ");
INSERT INTO nhgNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Hua cuöc oquecajque Jesús, oquemelfejque: ―Öque amo mocojcocoa amo quenesesitöroa mierco, tlöcamo sa öque mococoa, yaja quenesesitöroa. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xeyöcö noso, hua xectzecucö tlin quejtusneque teotlajtule cuöc quejtoa: “Icnuejtelestle necneque, hua amo bentle”. Pues naja amo nehuöla nequennutzaco tli cate yecteque ma huölöcö ca naja, tlöcamo nequennutzaco tlin tlajtlaculteque. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yecuöquenu imachtejcöhua de Xohuö Bautista ohuölajque tiecatzinco, hua oquejtojque: ―¿Tlica tejua hua inu fariseos tetlajyubea meyacpa, pero momachtejcötzetzihua amo tlajyubea? ");
INSERT INTO nhgNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Hua Jesús oquemelfejque: ―¿Beles cuale chojchucasque tli nejnieneme ipa nesohuajtiluyo, mientras montle intlanca? Pos amo. Pero huölösque tunalte cuöc montle ayecmo oncöyes. Cuöquenu tlajyubisque. Cuöc naja ayecmo oncö neyes, tlajyubisque nomachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sente tzotzomajtle tli ye soltec amo öque quetlamanelea ica tzotzomajtle yancuec. Pos tlö ejqueu quechihuas, inu tzotzomajtle yancuec mocototzus hua quetzomunis inu soltec, hua cache bieye iyes tzomunelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nimpor amo motlölea vino yancuec ijtec puxajme de cuetlaxtle tli ye solteque. Pues tlö ejqueu, puxajme tzojtzomunesque, hua vino nunuquebes, hua niempolebesque puxajme. Cache vino yancuec motlölea ijtec puxajme yancueque, hua ca inu vino hua puxajme innehua momalfea. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Hua mientras oquemelfilutaya ini nönca sösantle, oaseco sente tlajtoöne, hua tiemabesutiöya. Otieyelfe: ―Nochpuch quiemach omec. Pero xehualmobica hua xomotlölele momötzi ipa hua yaja nemes. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Hua onequetzaluc Jesús, hua oquetocaque, ca tiehua tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hua oyeya sente sohuatl tli ye mococoöya majtlactle huan ume xebetl ica itlapalyeso. Inu sohuatl omopacho ca tiecuetlapa, oquemötocac itienco de tietlaquie. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pues quejtoöya ijtecopa: “Tlö sa necmötocas tietlaquie, nepajtes”. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Cache Jesús onecuepaluc, hua cuöc oquejtaque, oquejtojque: ―Xemanimöro, nochpuch. Por tomoneltocac ye tepajtec. Hua sa nima pajtec inu sohuatl ipa inu nieca ura. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Hua cuöc oaxihuato Jesús pa ichö de nieca tlajtoöne, oquemejtaque tlin tlajtlapitztaya, hua giente lalebes cuejcueyuneya. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Hua yejuatzi oquemelfejque: ―Xomocaltechucö. Inin sisehuantu amo omec, tlöcamo cochteca. Pero yejua moburlörojque de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Hua cuöc noche giente oquemenquextejque ca queyöhuac, ocalacoac cöne oyeya sisehuantu. Ocajcojque ca imö, hua omie inu sisehuantu. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Hua ini nönca sösantle omacheac ipa noche inu nieca tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Hua cuöc oquixoac Jesús de ompa, otietocaque unte ixcocoxcötzetzi. Tzajtzajtzetöya hua quejtoöya: ―Xomotlöocoltejtzino por tejua, iConie David. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Hua cuöc yejuatzi onaxihuato ipan chöntle, ohuölajque tietlac inu ixcocoxcötzetzi. Hua Jesús oquemelfejque: ―¿Nemoneltoca que cuale necchihuas ini nönca? Yejua oquejtojque: ―Quiema, Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Entunses oquenmötocaque ipa imixtelolo, hua oquejtojque: ―San quiene ca nemoneltocaque, ejqueu ma mochihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Hua imixtelolojua ye cuale otlachixque. Hua Jesús oquennahuatejque ca checöhuac tlajtule, oquemelfejque: ―Xecpeacö cueröro de que majcamo öque quemate. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Cache yejua, cuöc oquisque, otlamachestejque ipa noche tlöle de lo que tli impa omochi. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Hua cuöc oquisque yejua, giente otiehualequelejque sente mumorojtzi, tli quepeaya demunio. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Hua oquequextelejque inu diöblo, hua ca inu otlajtlajto mumorojtzi. Hua giente oquetietzöbejque. Quejtoöya: ―Ayec omojtac ini nönca sösantle necö ipa Israel. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Cache inu fariseos quejtoöya: ―Por ichecöhuales de inu tlajtoöne de demunios quenquextea demunios. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Hua Jesús biloatenemeya ipa noche ciudades hua puieblos. Otlamachtilutenemeya ipan inteopancuconehua de yejua. Tlanunutzaloöya de inu cuale tlamachestelestle de quiene Deus tlamandörurus. Tlapajtiloöya de noche cocolestle tli oyeya ipan puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hua cuöc oquemejtaque giente netlöocoltiluc por yejua, ipampa cuajcuasemantaya hua bejbetztaya quieme cana cuöc calnielojte amo quepea calnielojpexque. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yecuöquenu oquemelfejque tiemachtejcöhua: ―Inu meyac giente cate quiename sente tlamochihualestle tli bieye ica. Pero tejua tli tepejpexca sa quiesquete tecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Xetietlajtlötlajtelicö, noso, öque tiehuöxca inu tlatuctle, para ma quenhualtitlanecö cache meyactie tequetque para pexcasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yecuöquenu oquennutzque majtlactle huan ume de tiemachtejcöhua, hua oquenmacaque checöhualestle para ma cuale quenquexticö moxicoöneme, hua para cuale quepajtisque noche cocolestle hua noche tietunie. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Hua intojtucöyo de inu majtlactle huan ume tietlateotitlanhua yejua ini nöncate: cachto Semu, öque nuyejque mocuitea Piero, hua icni itucö Andrés; ca tiehua Jacobo, iconie Zebedeo, hua icni itucö Xohuö; ");
INSERT INTO nhgNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","hua Felipe, hua Bartolomé, hua Tumös, hua Mateo inu tlanecheco, Jacobo iconie Alfeo, hua Tadeo, ");
INSERT INTO nhgNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","hua Semu öque oyeya de inu partido cananista, hua Judas Iscariote, öque sötiepa tietiemöcte Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yejuani majtlactle huan ume oquentitlanque Jesús, hua oquennahuatejque, oquemelfejque: ―Amo xeyöcö ca cöne chajchönte inu giente tli amo joriojte, nimpor amo xecalaquecö ipa inpuieblos de samaritanos. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Cache xeyöcö inca togiente de Israel, tli cate quiename calnielojte tli ixniempolejtecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Hua cuöc nenyösque, xetlanunutztöcö, xequejtucö: “Ye aseco tunalte para Deus tlamandörurus nemotlac”. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xequenpajticö cocoxcötzetzi. Xequenyulebiticö tli omejmejque. Xequenpajticö tli sa söhuayojque cate. Xequenquexticö demunios. Nenqueselejque inu checöhualestle sin que amo nenquetlaxtlöjque niontle; xectequetilticö sin que nenquecubrörusque niontle. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Amo xomopealticö niontle tomi ijtec nemopuxa, ");
INSERT INTO nhgNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","nimpor amo xomopealticö sente morröl para pa ojtle, nimpor ume tlaquentle, nion sapötoste, nimpor cuajfortu. Pues tequetque quepea deriecho de que quetlamacasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Hua cuöc nencalaquesque ipa sente ciudad noso puieblo xectiemucö öque ica de confiönsa, hua ompa xeyecö ipa ichö hasta cuöc nenquisasque de inu locör. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Hua cuöc nencalaquesque ipa inu chöntle, xecbendesirucö. Xequejtucö: “Ma yecsiebelestle iye ca nemejua”. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Hua tlö inu giente quemeresieroa, inu bendeseyu de yecsiebelestle tli nenquemacaque ma mocöhua ipan chöntle. Cache tlö amo quemeresieroa, ma ayecmo mocöhua inu bendeseyu de yecsiebelestle ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Hua tlö canajyeca amo nemiechselis, nimpor amo queneques quecaques nemotlajtul, xequisacö de ipa inu nieca chöntle o noso puieblo, hua xectzetzelucö noche tlöle de ipa nemocxehua quiename sieñas de que inu giente amo yecteque cate. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Melöhuac nemiechelfea, que ipa inu tunale cuöc Deus tlajuscörurus, cache petzotec iyes para inu nieca puieblo que para inu puieblos de Sodoma hua Gomorra tli lalebes tlajtlaculteque oyejyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Xequejtacö cuale, que nemiechtitlane quieme cana nencalnielojte intzölö coyume tiecuöneme. Por inu, xeyecö xelistos quiename cohuöme, pero amo xepapasolebecö quiename palumax amo papasol. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pero xecpeacö cueröro, porque giente nemiechtiemöctisque inca tlötlajtoönejme. Ipa inteupancuconehua nemiechbitequesque ca cuabetl. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Hasta imixpa cubernadurte hua reyes nemiechbicasque por nopampa. Ejqueu nentlatestificörusque imixtla de tlajtoönejme hua giente tli amo joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero cuöc nemiechtiemöctisque, amo xomotequepachucö por quiene nentlajtlajtusque noso tli nenquejtusque. Pos ipa inu nieca ura Deus nemiechmacasque tlajtule tli nenquejtusque. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pues amo nenyesque nemejua tli nentlajtlajtusque, tlöcamo yejuatzi tieEspíritu de nemoTajtzi tlajtlajtulus nemocamacopa de nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ipa inu niecate tunalte, icni quetiemöctis icni ma meque, hua tajtle quetiemöctis iconie. Inpelhua quencuajnömequesque intötajua, hua quenmejmectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Hua nemiechtlajyelejtasque noche giente por nopampa. Pero öque quexicus hasta cuöc tlames, yaja inu momöquextis. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Cache cuöc nemiechtepotztocasque ipa sente puieblo, xecholucö ipa ocsente puieblo. Pues melöhuac nemiechelfea, que amo nenasetibe ipa noche puieblos de Israel, cuöc nehuölös naja, öque onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","’Sente machtejque amo cache bieye ica que imaestro, nimpor tlatequepano amo cache bieye que itieco. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pues inu machtejque ma iye confurme tlö giente quechibelisque quiename quechibelejque imaestro, hua tlatequepano ma iye confurme tlö quetratörusque quiename itieco. Tlö naja, öque neca quiename netajtle de chöntle oniechcuitejque neBeelzebú noso Moxicojcötlöcatl, ¿tli amo nemiechcuitisque nemejua tli nencate de nochö? ");
INSERT INTO nhgNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Por inu, amo xequenmabelicö inu giente, porque amo onca niontle mojyönteca, que amo moniextis. Hua abele mojyöntas niontle, pues noche quepea que macheas. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Lo que tli nemiechelfea ipa tlajtlayohuaquelestle, xequejtucö pan tunale. Hua tli nenquecaque sa ichtacajtzi xetlanunutzacö cöne cuale caquestes noche. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Hua amo xequenmabelicö niecate tli cuale quemectea nemocuierpo, pero nemoölma abele quemectisque. Cache xetiemabelicö öque cuale queniempolusque nemoölma hua nemocuierpo ijtec tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Amo monamaca unte tutucucone por sente centöbo? Hua mösque ejqueu, ayec betze nion sente tutuconetzi sin tietlanequeles nemoTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hua nemejua, Deus quematihua hasta itlapoal de nemotzo. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Por inu, amo xomomajticö; pos nemejua cache nenbajbalierebe que meyactie tutume. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ejqueu noso, tlö canajyeca niechtieniehuas hua tlajtus cuale de naja imixtla giente, naja nuyejque nectieniehuas, hua netlajtus cuale de yaja tieixpa noTajtzi öque iloac elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero tlö canajyeca niechnegörus imixpa giente, naja nuyejque necnegörus tieixpa noTajtzi öque iloac elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Amo xecpensörucö que naja onehuöla para ma ayecmo uye peleitos ipan tlöltecpactle. Amo onehuöla para nectiemacas siebelestle, cache mochihuas guierra porque nehuöla. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pues porque naja onehuöla tlöcatl iyes encuntra de itajtzi, hua ichpuchtle iyes encuntra de inöntzi, hua sohuamontle iyes encuntra de imono. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Hua ienemigos tlöcatl yesque mismo ifamiliares. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Öque quetlasojtla itajtzi hua inöntzi cache que naja, amo quemeresieroa iyes de naja; hua öque quetlasojtla itielpuch noso ichpuch cache que naja, amo quemeresieroa iyes de naja. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Hua öque amo niechtoca mös quepeas que quesufrirus quiename öque quesufriroa ipa sente corujtzi, amo quemeresieroa iyes de naja. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Öque queneques quemöquextis inemeles, quepolus; pero öque quepolus inemeles por nopampa, queniextis. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Öque nemiechselea nemejua, nuyejque naja niechselea. Hua öque niechselea naja nuyejque tieselea yejuatzi öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Öque queselea sente tlayulepante ipampa ica tlayulepante, queselis inu premio tli quetocöroa öque queselea sente tlayulepante. Hua öque queselea sente tlöcatl yectec ipampa ica yectec, yaja queselis inu premio tli quetocöroa öque queselea sente tlöcatl yectec. ");
INSERT INTO nhgNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Hua tlö canajyeca quetlöocolis sente de ini nöncate tzequetzetzi mösque sa sie xölo ötzintle itztec, porque ica nomachtejque, melöhuac nemiechelfea, que seguramente quepeas ipremio. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Hua ejqueu Jesús ye nesencöhualuc de que quennahuatejque inu majtlactle huan ume tiemachtejcöhua. Entunses obiloac de ompa otlamachtiluto hua otlanunutzaluto ipa inu puieblos de ca ompa. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Hua Xohuö Bautista otzajtzactaya ipan cörsel. Hua cuöc yaja oquemat de tli sösantle quechihualoöya Cristo, quementitla seque de imachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","para ma tietlajtlanecö Cristo: ―¿Tejuatzi tomobetzteca inu nieiloac öque hualiloasquea, o noso tetiemöcheasque ocsietzi? ");
INSERT INTO nhgNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Hua onöhuatihuac Jesús, oquemelfejque: ―Xeyöcö, hua xecmachesticö Xohuö noche sösantle tli nenquecactecate hua nenquetztecate: ");
INSERT INTO nhgNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","quiene ixcocoxcötzetzi ye tlajtlachea, cucuxojtzetzi nejneme, tli sa söhuayojque pajpajte, tzatzatzetzi ye tlajtlacaque, mimejque yojyulebe, hua porubejte quecaque cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Hua cuale icnupel öque amo quepoloa ineltoqueles por nopampa. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Hua cuöc yejua uyajque, opiehualuc Jesús quennunutzaloöya giente de Xohuö. Oquejtojque: ―¿Tli nenquejtato ompa cöne nionöque chönte? ¿Beles oyeya sente ohuatl que ca nobeyo cuoliniöya yejyecatl? Amo. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Cache cuöc nenquisque para nenquejtato, ¿tli nenquejtato? ¿Beles sente tlöcatl tli motlaquentiöya ca tlin cuale tzotzomajtle? Amo. Xequejtacö, que niecate tli möquea tli cuajcuale tlaquentle, ipa inchö reyes cajcate. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Cache ¿tlica nenquisque? ¿Nenquejtato sente tlayulepante? Quiema, hua nemiechelfea que cache que sente tlayulepante icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pues yaja ini nönca Xohuö de öque tlajcuelulpanca: “Xequejtacö, naja nectitlane notlatitlantle mixpa, ma quemejmelöhua moojfe mixpa”. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Melöhuac nemiechelfea, que entre innochtie tlöca ayec otlöcat ocsente ma cache bieye momajta que Xohuö Bautista. Cache öque lalebes tzitzequetzi ica cöne Deus tlamandöruro desde elfecac, cache bieye ica que Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Hua desde cuöc ohuöla Xohuö Bautista hasta öxö, giente queneque ca fuiersa calaquesque ompa cöne Deus tlamandöruro. Hua tli cache pobiercojte calactecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pues noche inu tlayulepantejque hua inu ley de Moisés tlajtoöya hasta que ohuöla Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Hua tlö nenqueneque nenqueselisque, yaja ini nönca icaca Elías, tli huölösquea. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Öque quepea itlacaqueles, ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’Pero ¿ca tli nejcomparörus giente de nönca tiempo? Cate quiename cuöc pelalacme yejyehuatecate ipan plöza para majöbeltisque, hua quentzajtzelea incompanierojua, ");
INSERT INTO nhgNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","hua quemelfea: “Amo nemajöbeltea cuale. Pos tejua tontlapitzque ca tlapitzale para ma xomojtuticö, pero amo nemojtutejque. Otechojchuquescuicaque, pero amo nenquenejque nenchojchucasque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pues ohuöla Xohuö, hua tlajyubiöya hua amo coniya. Hua nönca giente quejtoa: “Quepea demunio”. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sötiepa onehuöla naja öque onochi netlöcatl, que netlacua hua necone. Hua nönca giente quejtoa: “Xequejtacö necö sente tlöcatl lalebes tlacuöne hua tlöhuönque, que lalebes cuale mobica ca tlanechecojque hua ocseque tlöca tlajtlaculteque”. Pero cuale öque momacas cuienta que toconchijque lo que tli tlajmatque por quejtas totlachihual. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yecuöquenu opiehualuc para quentlajtlacaquitisque inu puieblos cöne yejuatzi oquechijque meyac tietzöbetl. Quemajajuaque ipampa amo omoyulcuepaya. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―¡Porube de taja, pueblo de Corazín! ¡Porube de taja, pueblo de Betsaida! Ipampa tlö pa inu ciudades de Tiro hua Sidón omochihuane ini nönca tietzöbetlachihualestle tli omochi ca nemejua, ye icsa omoyulcuepane. Ye motlaquentiöne de luto hua de tlaconextle para ma quedemoströrucö que ye moyulcuejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Por inu nemiechelfea, que ipa inu tunale cuöc Deus tlajuscörurus, cache petzotec iyes para nemejua que para inu ciudades de Tiro hua Sidón. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Hua taja, puieblo de Capernaum, ¿beles tecpensöroa temajcoques hasta elfecac? Pues tetemus hasta mectlöncale. Ipampa tlö pa inu ciudad de Sodoma omochihuane ini tietzöbetlachihuale tli omochi ca taja, mocöhuane hasta öxö. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Por inu nemiechelfea, que ipa inu tunale cuöc Deus tlajuscörurus, cache petzotec iyes para taja que para inu tlöle de Sodoma. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ipa inu nieca tiempo, Jesús oquejtojque: ―Temetzmomabesutelea, noTajtzi, Tlöcatzintle de elfecac hua de tlöltecpactle, pues tejuatzi otomojyönele ini nönca sösantle de tli tlajmatque hua casojcömateneme, hua otequenmoniextelele tli cate quiename pelantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pues ejqueu, noTajtzi, tomocualejtele. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","’Noche sösantle ye niechmöctejque noTajtzi. Hua amo öque quixomate tieConietzi, tlöcamo sa yejuatzi Tajtle. Nuyejque amo öque tieixomate Tajtle, tlöcamo sa tieConietzi, hua öque tieConietzi queneques tieniextelis. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","’Xehuölöcö ca naja nemonochtie quiejquech nentejtequete lalebes hua tli nentlajtlamömajtecate, hua naja nemiechchihualtis nemosiebisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xecbicacö noyuco nemopa nemejua, hua xectzecucö de naja, que neyulsiejque hua amo mochamöhuane noyulo. Ejqueu nenquepeasque siebelestle para nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pues noyuco tli nemiechtlölelea amo yetic, hua amo yetic notlamömales. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ipa inu nieca tiempo omochi que Jesús biloatöya ipan söbro ca cöne onca tlatuctle. Joriojte quepeaya costumbre de mosiebiöya ipan söbro. Tiemachtejcöhua Jesús tejteosebeya, hua cualcopintöya hua cualcuajcuajtöya meyöhuatl de trigo. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Hua cuöc oquejtaque inu fariseos, tieyelfejque: ―Xequejta necö momachtejcöhua quechijtebitze lo que tli amo conbenierebe ma öque quechihua pan söbro. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero yejuatzi oquemelfejque: ―¿Ayec nenquetlajtultejque tli oquechi David ca tiehua tli oyejyeya ca yaja, cuöc teosejtaya? ");
INSERT INTO nhgNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pues yaja ocalac ipa tieteupa Deus, hua oquecua inu pöntzi tli oyeya de bentle, tli amo conbenierebeya ma quecua yaja nimpor tli oyejyeya ca yaja, tlöcamo sa yejua teopexcötzetzi cuale quecuösque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O noso ¿ayec nenquetlajtultejque lo que tli quejtoa inu ley de Moisés? Pues ipan söbro cuöc tosiebea inu teopexcötzetzi tequete ipan teopantle. Ejqueu yejua amo mosiebea ipan söbro hua amo öque quentlajtlacultea. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pos nemiechelfea öxö que oncönca canajyetla tli cache importönte ica que inu teopantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pero nemejua amo nencasojcömate tli quejtusneque teotlajtule cuöc quejtoa: “Icnuejtelestle necneque hua amo bentle”. Pues tlö nencasojcömatene, amo nenquentlajtlacultiöne ini nöncate tlöca, pues amo cate tlajtlaculteque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pues naja öque onochi netlöcatl necpea deriecho para nequennahuatis giente de tli sösantle conbenierebe ma quechihuacö pan söbron tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Hua cuöc obiloac de ompa, calacoac ipa inteupancone. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Hua ompa oyeya sente tlöcatl tli quepeaya sente imö ye uhuöc. Hua inu fariseos tietlajtlanejque: ―¿Conbenierebe öque tlapajtis ipan söbron tunale cuöc tosiebea? Ejqueu oquejtojque porque quetiemoöya maniera para tietieyelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Hua yejuatzi oquemelfejque: ―Tlö canajyeca de nemejua quepea sente icalnielo, hua tlö cana betzes ijtec sente puso ipan söbro, ¿quie beles amo cases hua quequextis? Pos quienamo quechihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Entunses cache ca meyac arrasu ma tequenpaliebicö giente, pues sente tlöcatl cache balierebe lalebes que sente calnielo. Ejqueu noso, conbenierebe ma mochihua tlin cuale ipan söbron tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yecuöquenu oquelfejque inu nieca tlöcatl: ―Xecmelaso momö. Hua yaja oquemelaso, hua opajtec, omoyectlöle quiename ocsente. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pero cuöc oquisque inu fariseos, omotlajtulmacaque para quiene tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús nemacuc cuienta de tli quepejpensöroöya yejua, hua nexeluluc de ompa. Hua meyac giente tietocaque, hua quenpajtiloöya innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hua yejuatzi quennahuatiloöya majcamo quejtucö öquenu oquenpajte. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ejqueu opasöre para ma mochihua tli omojto por icamacopa tlayulepante Isaías, cuöc oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Xequejtacö necö notlatequepano, öque naja nequixpejpe. Yaja nectlasojtla, hua ica yaja pajpöque noyulo. Nectlölis noEspíritu ipa yaja, hua quenmachestis giente de noche naciones de quiene netlajuscörus. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Amo chöchalönes, nimpor amo tzajtzes, hua cuöc tlajtlajtus ijtec cale, itlajtul amo caquestes hasta pan cayaju. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Quentratörus ca cuale tlin amo checacteque, quiename sente tlöcatl tli amo queposteques ohuatl mös amo checöjteca, hua amo quesiebis miecha mös sa popucateca. Ejqueu quechihuasque hasta senamo quechihuas para ma mochihua ipa noche tlöltecpactle lo que tli yectec. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hua giente de noche naciones quepeasque nemöchealestle itucöyupa. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Yecuöquenu tiecualequelejque sente tlöcatl tli quepeaya demunio, ixcocoxque hua mumorojtzi. Hua yejuatzi oquepajtejque, hua inu tli oyeya ixcocoxque hua mumorojtzi ye cuale otlajtlajto hua ye tlacheaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Hua noche giente oquetietzöbejque, hua quejejtoöya: ―¿Beles yaja ini nönca iconie David öque iyes torey? ");
INSERT INTO nhgNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Cache cuöc oquecajque fariseos, oquejtojque: ―Ini nönca sa quenquextea demunios ca ichecöhuales Beelzebú, tlajtoöne de demunios. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero yejuatzi quematiloöya tli yejua quepejpensöroöya, hua oquenmelfejque: ―Tlö giente de sente nación seme momejmectejtasque entre yejua mismo, pues moxexetunis inu nación. Hua tlö giente de sente puieblo o noso de sente chöntle seme momacatasque, pues nima pojpolebes inu puieblo noso chöntle. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Hua tlö cana Satanás quetojtoca Satanás, mopeleörojteca cuntra yaja mismo. ¿Quiene noso bejcöbes itlajtojcöteles? Pues abele bejcöbes. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Hua tlö naja por ichecöhuales Beelzebú nequenquextea demunios, ¿beles nenquejtusque que nemomachtejcöhua nuyejque quenquextea por Beelzebú? Ejqueu yejua mismo nemiechpinöbea de lo que tli nenquejtoa. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero tlö por tieEspíritu de Deus naja nequenquextea demunios, quejtusneque que de melöhuac Deus piehualuteca tlamandöruro nemotzölö. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pues ¿quiene cuale öque calaques ipa ichö de sente tlöcatl chejchecactec hua cuale quetlaquejquextelis de tli ihuöxca, tlö amo cachto öque quejilpis inu tlöcatl checactec? Pues tlö ye quejilpe ye cuale öque quetlaquejquextelis noche tli quepea ipa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Öque amo ica ca naja encuntra de naja ica; hua öque amo niechpaliebea para nejcuejcuis quechayöjteca. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Hua por inu nemiechelfea que Deus quenperdonörfisque giente de noche tlajtlacule hua checuatlajtule tli quechihua noso quejtoa. Cache inu checuatlajtule de öque tiepöpöcas Espíritu Sönto amo queperdonörfisque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tlö canajyeca tlajtus encuntra de naja öque onochi netlöcatl, cuale moperdonörus. Pero tlö tlajtus tieca Espíritu Sönto, abele moperdonörus, nimpor öxö pa ini nönca tlöltecpactle nimpor sötiepa cuöc ye opanuc tlöltecpactle, abele moperdonörus. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Tlö ica cuale sente cuabetl, entunses ifruto nuyejque ica cuale. Noso tlö sente cuabetl amo cuale ica, entunses nuyejque ifruto amo cuale iyes. Pues por ifruto mixomate sente cuabetl. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Tlöcaxenöchcuhuöme! ¿Quiene cuale nenquejtusque de lo que tlin cuale, tlö nemejua amo nencualteque nencate? Pos lo que tli öque quejtoa ca icamac quisa de lo que tli quetiemitea iyulo. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sente tlöcatl cualtec quemalfea de lo que tlin cuale ipa iyulo, hua cuöc tlajtlajtoa quequextea inu sösantle tlin cuale. Pero sente tlöcatl amo cualtec quemalfea sösantle tli amo cuale ipa iyulo, hua cuöc tlajtlajtoa quequextea de inu sösantle tli amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Hua nemiechelfis ini nönca, que ipa inun tunale cuöc Deus tlajuscörurus, giente quetiemacasque cuienta de cara sente tlajtule tli oquejtojque. Hasta de inu tlajtulme tli amo quepexque cueröro quiene ca oquejtojque, de inu quetiemacasque cuienta. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porque por motlajtulhua nieses tlö teca teyectec, noso por motlajtulhua nieses tlö amo teyectec, hua metzcuntenörusque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Yecuöquenu onöhuatque seque de inu tlamachtiöneme de teotlajtule hua seque fariseos. Oquejtojque: ―Maestro, tecneque tequejtasque de tejuatzi sente tietzöbetlachihuale quiename sieñas de que lo que tli tomojtalfea ica melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Hua yejuatzi onöhuatihuac, hua oquemelfejque: ―Nemejua nengiente amo nencualteque nencate hua sie tiro amo nenqueneque nentietocasque Deus. Hua öxö nenqueneque ma nemiechmaca sente sieñas. Pero amo nemiechmacas nion sente sieñas de tietzöbetl tlöcamo sa inu sieñas de inu tlayulepante Jonás. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pues quieme oyeya Jonás ijtecopa inu bieye meche yeye tunale hua yeye yohuale, ejqueu naja öque onochi netlöcatl neyes ijtec tlöle yeye tunale hua yeye yohuale. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Inu tlöca de inu ciudad de Nínive majcoquesque ca nemejua ipa inu nieca tunale cuöc Deus tlajuscörurus, hua nemiechpinöbisque. Pues yejua omoyulcuejque cuöc oquennunutz Jonás. Hua xequejtacö necö oncönca sente cache bieye que Jonás ipa ini nönca locör, pero nemejua amo nenqueneque nemoyulcuepasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Inu reina de tlöle del sur majcoques ca nemejua ipa inun tunale cuöc Deus tlajuscörurus, hua nemiechpinöbis. Pues yaja ohuöla desde lalebes ca bejca para quecaques imachesteles de Salomón. Hua xequejtacö, necö oncönca sente cache bieye que Salomón ipa ini nönca locör, pero nemejua amo nenqueneque nenquecaquesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Cuöc moxicoöne ye oquis de ijtecopa tlöcatl, nejnenteneme ipa tlölhuöjque. Quetiemojteneme cöne mosiebis, hua amo queniextea. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Yecuöquenu quejtoa: “Nocuepas ocsajpa nochö de cöne onehualquis”. Hua cuöc yebitz, cualniextea tlayejteca, hua tlachpöntle hua tlayecchejchijtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Yecuöquenu iya, hua quenbicatz ca yaja oc checume moxicoöneme cache petzoteque que yaja. Cajcalaque, hua ompa mochöntea. Hua sötiepa mochihua cache lalebes petzotec para inu nieca tlöcatl que cuöc cachto oyeya. Ejqueu nuyejque nemiechpasörus nemejua, pues sie tiro amo nencualteque nencate. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Hua mientras yejuatzi tlajtlajtulutaya inca giente, necö tienönajtzi ca tiehua tieicnihua queyöhuac oyejyeya. Quenequeya tienunutzasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Hua yeca otieyelfe: ―Xomojtele monönajtzi ca tiehua mocnijtzetzihua cate ca queyöhuac; quenejneque metzmonunuchelisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Hua oquenönquelejque yejuatzi öque tieyelfiöya inu, oquelfejque: ―¿Öquenu nonöna hua öquemeju nocnihua? ");
INSERT INTO nhgNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yecuöquenu oquenmajpelfejque tiemachtejcöhua. Oquejtojque: ―Xequejtacö necö nonöna ca tiehua nocnihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pos noche öque quechihuas tli tietlanequeles noTajtzi öque iloac elfecac, yaja inu icaca nocni oquechtle, noso nocni sohuatl, noso nonöna. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hua ipa inu nieca tunale, oquixoac Jesús de ipan chöntle, hua onetlöliluc itlac ötiescatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Hua omopachojque lalebes meyac giente. Por inu yejuatzi ocalacoac ijtec börco hua onetlöliluc. Hua noche giente oyejyeya tlatienco. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Hua oquennunutzque meyac sösantle ica cuientos. Oquejtojque: ―Xejcaquecö cuale. Sente tlöcatl oquis otlatucato. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Quecuasema xenöchtle. Hua omochi cuöc tlatucato, que seque xenöchtle obetz itienco ojtle; hua ohuölajque tutume, hua oquecuajque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Hua ocseque obetz ipa locör cöne lalebes tecamac, cöne amo quepeaya meyac tlöle. Oquis sa nima, pues tlöle amo teröhuac oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero cuöc oquis tunale, opeli hua uhuöc, pues amo monelhuayute. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hua ocseque obetz ipa betztle; hua betztle omobepö, hua quepötzmecte tlatuctle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Hua seque obetz ipa tlin cuale tlöle, hua ini nönca otlamochihualte. Seque oasec hasta sie sientos töntos, seque hasta sesenta, hua seque hasta treinta töntos. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Öque quepea itlacaqueles, ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Entunses omopachojque tiemachtejcöhua, hua tieyelfejque: ―¿Tlica tequenmonunuchelea ica cuientos? ");
INSERT INTO nhgNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Hua yejuatzi onöhuatihuac, hua oquemelfejque: ―Nemejua nemiechtocöroa nenquematesque inu secrietos de quiene ca Deus tlamandörurus desde elfecac. Pero yejua amo quentocöroa quematesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pos tiel öque quepea, quemacasque, hua quepeas cache meyac. Pero öque amo bel quepea, quequextelisque hasta inu tepetzi tli oc quepea. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ipampaju nequennunutza ca cuientos, ipampa mös tlachea cuale, pero amo quejta, hua mös tlacaque, pero amo queyejcaque, nimpor amo casojcömate. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Hua ejqueu mochihua inca yejua lo que tli queyulepantejque Isaías, cuöc oquejto: Ca nemotlacaqueles nentlacaquesque, pero amo nencasojcömatesque, hua ca nemoixtelolojua nenquejtasque, pero amo nenquixomatesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Pues inyulo de ini nönca puieblo ye omotepitzo, hua amo yectlacaque itlacaqueles, hua omotlapachojque inmixtelolojua para amo quejtasque ca inmixtelolo, nimpor amo tlacaquesque ca intlacaqueles, nimpor amo casojcömatesque ca inyulo, nimpor amo moyulcuepasque para que ejqueu naja amo nequenpajtis. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero cuale nemocnupel nemejua, ipampa nenquejta ca nemixtelolojua, hua nentlajtlacaque ca nemotlacaqueles. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pues melöhuac tli nemiechelfea, que meyactie tlayulepantejque hua yecteque de pa nieca tiempo quenejnequeya quejtasque tli nenquejta, pero abele quejtaque; hua quenejnequeya quecaquesque tli nenquecaque, pero abele oquecajque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Xejcaquecö nemejua noso tli quejtusneque inu cuiento de tlöcatl tli tlatucato. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Cuöc canajyeca quecaque tlajtule de quiene Deus tlamandörurus, hua amo casojcömate, entunses yebitz inu Amo Cuale Tlöcatl, hua cajcoctebetze tli omotucac ipa iyulo. Yaja ini nönca quiename xenöchtle tli omotucac itienco ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Hua inu xenöchtle tli omotucac cöne tecamac, yaja ini nönca öque quecaque tlajtule, hua nima queselea ca meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero mochihua quieme cana inu tlajtule amo monelhuayutea de melöhuac ipa iyulo. Pues ipa yebitz tiecoco noso cox giente quetepotztoca por ipampa teotlajtule, hua nima modesanimöroa. Sa quiesque tiempo quexicoa. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Öxö, inu xenöchtle tli omotucac itzölö betztle, pues yaja inu icaca öque quecaque tlajtule, pero quetequepachoa sösantle de ini nönca tlöltecpactle, hua mixcajcayöhua ca tomi. Hua ini nöncate sösantle quieme quepötzmectea teotlajtule ipa iyulo. Yaja ica teotlajtule amo quepea resultödo ica yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Cache inu xenöchtle tli omotucac ipan tlin cuale tlöle, ini nönca yaja öque quecaque hua casojcömate inu teotlajtule. Hua yaja quechihua de noche tlin cuale tlachihuale, quieme cana tlö sente xenöchtle quetiemacasquea ca sie sientos töntos, hua ocsente ca sesenta hua ocsente ca treinta töntos. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Hua ocsente cuiento oquenpubelejque. Oquemelfejque: ―Cuöc Deus tlamandöruro ica ejqueyi: ica quiename sente tlöcatl tli quetucac tlin cuale xenöchtle ipa itlöl. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero cuöc ocochtaya tlöca, ohuöla ienemigo, hua oquetucac xebetl itzölö trigo hua uya. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Hua cuöc trigo omobepö hua oquetlöle imeyöhua, yecuöquenu onies nuyejque inu xebetl. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Hua ohuölajque tlatequepanojque de inu nieca chöne, hua oquelfejque: “Tlöcatzintle, ¿amo tomotuquele cuale xenöchtle ipa motlöltzi? ¿De cöne, noso, quepea xebetl?” ");
INSERT INTO nhgNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Hua yaja oquemelfe: “Sente tlöcatl enemigo oquechi ini nönca”. Hua itlatequepanojua oquelfejque: “¿Tomonequitea noso ma teyöcö hua ma tejcojcopinacö?” ");
INSERT INTO nhgNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Hua yaja oquejto: “Amo, pues tlö nenquecopinasque xebetl, nuyejque ihua nenquecopinasque trigo. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cache cuale xejcöhuacö ma mobepöhuacö innehua hasta senamo cuöc moteques. Hua cuöc ye moteques naja nequemelfis inu tlatejque: Xejcuejcuecö cachto yaja xebetl, hua xequejilpicö hua xecxutlalticö. Sötiepa xejcuejcuecö trigo hua xecualecacö para nectiemas ijtec nobesco”. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ocsente cuiento oquenpubelejque. Oquemelfejque: ―Cuöc Deus tlamandöruro desde elfecac icaca quiename ixenöch mostöza, que sente tlöcatl ocasec hua oquetucac ipa itlöl. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ini nönca mostöza de melöhuac yaja icaca cache tzitzequetzi que noche sösantle xenöchtle, cache cuöc ye mobepöhua, yaja icaca cache bieye de noche sösantle queletl, hua mochihua quiename sente cuabetl. Hasta bitze tutume tli patlöne ipa yejyecatl hua ompa quetlölea intepasol ipa imömöyo. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ocsente cuiento oquemelfejque: ―Cuöc Deus tlamandöruro desde elfecac, icaca quiename levadura de pöntzi, que ucö sente sohuatl, hua quenelulte ca yeye tlatemachihuale de harina, hua noche oquesunie. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Noche ini nönca sösantle Jesús oquennunutzaloöya giente por medio de cuientos. Sin cuientos cöso amo tli quennunutzaloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ejqueu omochi lo que tli omojto por icamacopa tlayulepante, cuöc oquejto: Nectlapus nocamac para necpoas cuientos. Nequejtus sösantle tli mojyöntaya desde cuöc omochejchi tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yecuöquenu Jesús oquencöjtiejque giente, hua ocalacoac ipan chöntle. Hua omopachojque tietlac tiemachtejcöhua. Otieyelfejque: ―Xetiechmoesplicörfele inu cuiento de xebetl tli omotucac itzölö tlatuctle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Hua yejuatzi onöhuatihuac. Oquejtojque: ―Naja, öque onochi netlöcatl, naja necaca inu tlöcatl tli quetuca inu cuale xenöchtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Hua inu tlöle yaja noche tlöltecpactle. Hua inu tlin cuale xenöchtle yejua giente tli quepeasque pörte cöne Deus tlamandöruro. Hua inu xebetl yejua giente tli queneltoca Amo Cuale Tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Hua inu enemigo öque quetucac xebetl, yaja Diöblo. Hua inu tiempo cuöc tlatequesque, yaja iyes cuöc itlamejyo tlöltecpactle. Hua inu tlatejque, yejua öngeles. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hua ejqueu quieme cuöc quecuejcueque inu xebetl hua quexutlaltejque ijtec tletzintle, ejqueu mochihuas cuöc tlames ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Naja öque onochi netlöcatl necualentitlanes noöngeles. Yejua quenpejpenasque de ipa notlajtojcöyo noche niecate tli quenchihualtea giente para majcamo moneltocacö, hua noche ocseque tli amo cuale quechijtecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Hua quentlajcalesque ijtec tlecale cöne xutlateca. Ompa chojchucasque hua motlantesesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yecuöquenu tli yecteque tlaniextisque quiename tunale ompa cöne tlamandöruro inTajtzi. Öque quepea itlacaqueles, ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Cuöc Deus tlamandöruro, icaca quiename sente tesoro tli mojyöntaya ipan tlöle. Hua sente tlöcatl oqueniexte, hua entunses oquejyö ocsajpa. Hua ca meyac pöquelestle unya, hua quenamacac noche tli quepeaya, hua oquecu inu nieca tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Ocsajpa, cuöc Deus tlamandöruro icaca ejqueyi: icaca quiename sente tlöcatl puchtiecatl tli quetiemoöya tlin cuajcuale perlas. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hua yaja oqueniexte sente perla tli lalebes balierebeya. Entunses yaja uya hua oquenamacac noche tli quepeaya, hua oquecu. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Ocsajpa, quiene Deus tlamandöruro icaca quiename sente tarröya, que quetlajcalque ijtec lamör, hua oquemasec de noche sösantle mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Hua cuöc ye otie, oquequextejque ca tlatienco. Hua omotlölejque, hua oquemaseque tlin cuajcuale hua oquentlölejque ijtec incheque. Hua tlin amo cuajcuale oquenchayöjque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ejqueu iyes cuöc tlames tlöltecpactle. Quisasque öngeles hua quennencuaxelusque tlin amo cualteque de intzölö tli yecteque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Hua quentlajcalesque ijtec tlecale cöne xutlateca. Ompa chojchucasque hua motlantesesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Quemelfiloöya Jesús: ―¿Ye nencasojcömatque ini nönca sösantle? Yejua onöhuatque: ―Quiema, Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Hua yejuatzi oquemelfejque: ―Por inu noche tlamachtiöne de inu ley de Moisés tli nuyejque ye oquetzeco quiene Deus tlamandöruro, yaja icaca quiename sente chöne, que quequextea de itesoro sösantle tli yancuec hua nuyejque tli soltec. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Hua omochi que cuöc oquesencöjque Jesús ini nöncate cuientos, obiloac de ompa. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hua ohualiloac pa tiepuieblo. Hua quenmachtiloöya giente ipan teopanconetzi. Hua ca inu yejua quetietzöbejtaya, hua quejtoöya: ―¿De cöne quepea ini nönca ini machestelestle, hua ini nönca checöhualestle para quechihuas tietzöbetl? ");
INSERT INTO nhgNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Amo yaja ini nönca iconie calpintiero? ¿Amo itucö inöntzi María, hua icnihua Jacobo hua Josie, hua Semu, hua Judas? ");
INSERT INTO nhgNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hua icnihua sohuame, ¿amo oncö cate totlac? ¿De cöne, noso, quepea ini nönca ini sösantle? ");
INSERT INTO nhgNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Hua por inu amo quecualejtaya giente. Cache Jesús oquemelfejque: ―Ca nobeyo giente queyequejta sente tlayulepante, pero ipa ipuieblo hua ipa ichö amo öque ipa quejta. ");
INSERT INTO nhgNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Hua ompa amo oquechijque meyac tietzöbetl, ipampa amo moneltocaya yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ipa inu niecate tunalte Herodes inu tetrarca noso rey oquecac tiechamöhuales de Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Hua oquemelfe itlatequepanojua: ―Ini nönca yaja Xohuö Bautista. Yaja ye oyule de intzölö mimejque, hua por inu quechihua bieye tlachihualestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pues Herodes ye icsa otlanahuate para ma casecö Xohuö, hua ma quejilpicö ca carienajte, ma quetzacuacö ipan cörsel. Pos ejqueu oquechi Herodes porque yaja mismo Herodes oquesohuacuejcuele icni Felipe. Inu sohuatl itucö oyeya Herodías. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Hua Xohuö quelfiöya Herodes: ―Amo cuale tecpextas inu sohuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hua Herodes quemectisquea Xohuö, pero quemabeliöya puieblo ipampa puieblo quejtoöya que Xohuö oyeya sente tlayulepante de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero oquechijque yelfetl ipa icumpleaños de Herodes, hua ichpuch Herodías omojtute innepantla giente. Hua oquecualejtac Herodes. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ca inu oqueprometierfe hua oquejurörfe nele quemacas noche tli yaja tlajtlanes. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Hua inu sisehuantu oquetlajtlanele lo que tli oquelfe inöntzi. Oquejto: ―Xeniechmomaquele necö ipa sente plöto itzonteco de Xohuö Bautista. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hua cuöc oquecac omotequepacho lalebes inu rey. Pero ipampa ye oquejuröro para quemacas hua oquecajque innochtie tli tlajtlacuajtaya ca yaja, otlanahuate ma quemacacö. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Hua otlatitla, hua oquequechtejque Xohuö ipan cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hua oquehualecaque itzonteco ipan plöto, hua oquemacaque inu sisehuantu. Hua yaja oquebiquele inöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yecuöquenu imachtejcöhua de Xohuö oaseco. Ocajcojque icuierpo, hua oquetlölpachuto. Hua uyajque, hua tiepubelejque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Hua cuöc oquecajque Jesús, onenencuaxeluluc de ompa ipa sente börco, hua obiloac ipa sente locör cöne nionöque chönteya. Pero giente oquematque, hua meyactie giente de inu puieblos tietocaque sa icxepa. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Hua ohualiloac Jesús, oquemejtaque inu meyac giente. Hua tietlöocoltejque, hua oquenpajtejque tli de yejua mocojcocoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Hua cuöc ye yohuac, omopachojque tiemachtejcöhua tietlac. Otieyelfejque: ―Amoyetla chöntle ca necö, hua ye yohuac tecate. Xequenmotitlanele giente noso, para ma yöcö pa puieblos ma mocubicö tlacuale. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Hua Jesús oquemelfejque: ―Amo quepea tli ipampa yösque. Xequentlamacacö nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Hua yejua oquejtojque: ―Amo tli tecpejpea necö tlöcamo sa möcuile pöntzi hua unte mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Hua yejuatzi oquemelfejque: ―Xeniechhualequelicö necö. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Hua yejuatzi quennahuatejque giente ma motietiecacö ipa sacatl. Entunses ocönque inu möcuile pöntzi hua inu unte mimechte. Ajcopatlachealuc ca elfecac, oqueteochijque tlacuale, hua quecocototzque. Entunses oquenmacaque inu pöntzi ca tiemachtejcöhua, hua tiemachtejcöhua quenxiexelfejque giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pos otlacuajque innochtie hasta cöne ijixbeque. Hua oquepejpenque majtlactle huan ume chequejme tietieme de lo que tli omocö de inu cojcotoctec. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Hua tli otlacuajque oyejyeya quiename möcuile mil tlöca, sin mopoasque sohuame nimpor pelantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nima Jesús oquenchihualtejque ma calaquecö tiemachtejcöhua ijtec börco, hua ma yöcö cachto que yejuatzi ca nepa löro de ötiescatl, mientras yejuatzi quentitlaniloöya giente para ma yöcö. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hua cuöc ye innochtie oquentitlanque, yejuatzi otlejcoac ipa tepietl netlötlajtiluto. Hua cuöc cache ye yohuac, yejuatzi turavea iloaya ompa tiesiel. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Hua mientras, inu börco oyeya bejca de itienco ötiescatl. Hua ötzintle ipa huölöya ipampa bel yejyecataya cuntra yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Hua ca ise quieme entre yeye hua checuasie ura, Jesús ohualiloac intlac, hualnejnemoataya ipa ötiescatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Hua cuöc tieijtaque tiemachtejcöhua quiene hualnejnemoatöya icpac ötiescatl, omomajtejque. Oquejtojque: ―Icaca sente mejque. Hua majcötzajtzeque. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Cache nima Jesús oquennutzque, oquemelfejque: ―Xomoyulölicö; naja necaca. Amo xomomajticö. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yecuöquenu otienönquele Piero, hua oquejto: ―Tlöcatzintle, tlö tejuatzi tomobetzteca, xomotlanahuatele ma nuyejque naja ma neya ca tejuatzi hua ma nenejnemete ipa ötzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Hua yejuatzi oquejtojque: ―Xehuöla. Hua cuöc otemuc de ipa börco, onejnemeya ipa ötzintle hua tienömequeto Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Cache cuöc oquejtac checöhuac yejyecatl, omomajte, hua opie opötzcalactöya. Entunses otzajtzec, oquejto: ―Tlöcatzintle, xeniechmomöquextele. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hua sa nima Jesús omösohualuc, oquequitzquejque, hua oquelfejque: ―Oh tlöcatl amo moneltocane, ¿tlica amo tomoneltocac? ");
INSERT INTO nhgNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Hua cuöc yejuatzi ca Piero ocajcalacoac ijtec börco, omoquetz yejyecatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yecuöquenu tli oyejyeya ipa börco ohuölajque hua tiemabesutejque. Oquejtojque: ―De melöhuac tejuatzi tomobetzteca tetieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Cuöc ye opanuque ca nepa löro, huajualiloac ipan tlöle de Genesaret. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Hua tieixomatque inu niecate tlöca de ipa inu nieca puieblo. Entunses otlatitlanque ca nobeyo de ipa inu nieca tlöle, hua oquenhualecaque tieca yejuatzi noche cocoxcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Hua tietlajtlötlajtiöya ma quemötocacö sa siquiera itienco tietlaquie. Hua noche tli oquemötocaya, opajteya. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yecuöquenu ohuölajque seque fariseos hua tlamachtiöneme de teotlajtule de ipa Jerusalén. Otieyelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Tlica momachtejcöhua amo quemalfea inu costumbres de tobiebetcöhua? Pues amo momöpajpöca cuöc tlacua. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Hua yejuatzi onöhuatihuac, oquemelfejque: ―¿Tlica nuyejque nemejua sa nenquepanabea tiemandamiento de Deus ipampa nemocostumbres? ");
INSERT INTO nhgNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pues Deus oquejtojque: “Pa xequejta motajtzi hua monöntzi”. Nuyejque oquejtojque: “Öque checuatlajtus encuntra de itajtzi hua inöntzi, ma meque sin remedio”. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero nemejua nenquejtoa: “Cuale öque quelfis itajtzi noso inöntzi: Ayojcuele yetla temetzmotlöocolelis porque ye netietlöocole Deus”. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Entunses nemejua nenquejtoa que inu tlöcatl ayecmo quepeas obligación para ipa quejtas hua quepaliebis itajtzi. Ejqueu nenquejtlacoa tietlajtultzi Deus por nemocostumbres. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Sa ume nemoxöyac! Cuale otlanunutz de nemejua inu tlayulepante Isaías, cuöc oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ini nönca puieblo sa ca itlajtul niechmabesutea, cache inyulo icaca bejca de naja. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Pero san tlapic niechmabesutea, pues tlajtlamachtea sa inmandamientos de tlöca quiename tlö oyene lo que tli tiechmachtilo Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Hua quennutzque noche giente ca tietlac. Oquemelfejque: ―Xejcaquecö, hua xecasojcömatecö. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Lo que tli calaque ca pa icamac tlöcatl, inu amo tlamajmöhua. Pero lo que tli quisa de ijtec icamac tlöcatl, yaja inu quemajmöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yecuöquenu omopachojque tiemachtejcöhua. Otieyelfejque: ―¿Tomomachitea que fariseos cuöc oquecajque ini nönca tlajtule ocuajcualönque? ");
INSERT INTO nhgNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Cache yejuatzi onöhuatihuac, oquejtojque: ―Noche plönta tli amo oqueplantörojque noTajtzi öque elfecac iloac, mocojcopinas. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xequencöhuacö: cate quiename ixcocoxcötzetzi tli quenejneque quenyecönasque ocseque ixcocoxcötzetzi. Pos tlö sente ixcocoxque queyecönas ocsente ixcocoxque, innehua betzesque ijtec coyoctle. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Yecuöquenu onöhuat Piero, otieyelfe: ―Xetiechmoesplicörfele inu cuiento. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Hua Jesús oquejtojque: ―¿Nuyejque nemejua ayemo nencasojcömate? ");
INSERT INTO nhgNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Amo nencasojcömate que noche tli calaque ijtec icamac tlöcatl iya ipa ijte, hua quisa ca icuetlapa? ");
INSERT INTO nhgNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Cache tli quisa ipa icamac yebitz de ijtec iyulo, hua yaja inu quemajmöhua tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pos itech yulojtle quisa inu amo cuale pensamientos, öque tlamectea, öque tlaumepea, öque mopöctea ca ocsente tli amo isohua noso amo inömec, öque tlachteque, öque istlacatlajtoa, öque checuatlajtoa. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Noche ini nönca sösantle quemajmöhua tlöcatl. Pero tlö quejtus tlacuös sin momöpajpöcas, inu amo quemajmöhua tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Hua cuöc oquixoac Jesús de ompa, obiloac ipa tlölte tli cate itlac puieblo de Tiro hua puieblo de Sidón. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Hua necö sente sohuatl cananea, que hualquis de ipa inu nieca tlöle, tzajtzeya. Quejtoöya: ―Tlöcatzintle, iConie David, xomopile icnuejtelestle de naja. Nochpuch lalebes quepea tiecoco de sente demunio. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Cache yejuatzi amo quenönqueliloöya nion sente tlajtule. Entunses omopachojque tiemachtejcöhua, hua tietlötlajtejque, tieyelfejque: ―Xomonahuatele para ma beya, pues lalebes tzajtzeteneme tocuetlapa. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Hua yejuatzi onöhuatihuac, oquejtojque: ―Amo niechtitlanque Deus para nequenpaliebis ocseque giente, tlöcamo sa inu giente de Israel, que cajcate quiename calnielojte tli ixniempolejtecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Yecuöquenu ohuöla sohuatl hua tiemabesute. Oquejto: ―Tlöcatzintle, xeniechmopaliebele. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Hua onöhuatihuac yejuatzi, oquejtojque: ―Amo conbenierebe nemiechmacas nemejua lo que tli quentocöroa joriojte. Pos tlöjcu uyesquea quiename tlö öque cönane pöntzi de pelantzetzi hua quentlajcaleliöne checheme. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Cache yaja oquejto: ―Melöhuac, Tlöcatzintle; pues nuyejque checheme quecua perösojcucone tli betze itzintla miesa cöne tlajtlacua intiecohua. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yecuöquenu onöhuatihuac Jesús, oquejtojque: ―Oh sohuatl, lalebes bieye moneltoqueles. Ma mochihua san quiene ca taja tecneque. Hua opajtec ichpuch ipa nieca ura. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Hua cuöc biloac Jesús de ompa, ohualiloac itlac ötiescatl de Galilea. Hua otlejcoac ipa tepietl. Ompa onetlöliluc. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Hua ohuölajque tieca meyactie tlöca, que ompa quenbicaya cucuxojtzetzi, ixcocoxcötzetzi, poteme, mömöncojtzetzi, hua ocseque meyactie cocoxcötzetzi. Hua oquentlölejque tieicxetla Jesús, hua yejuatzi oquenpajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Hua ca inu quetietzöbejtaya noche giente, cuöc oquejtaque tlajtlajtoa poteme, mömöncojtzetzi ya opajpajteque, cucuxojtzetzi ye nejneme, hua ixcocoxcötzetzi tlajtlachea. Hua giente tiemabesutiöya Deus öque iloac Deus de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Hua Jesús oquennutzque tiemachtejcöhua. Oquemelfejque: ―Niechtlöocoltea nöncate giente por que ye quepea yeye tunale que notlac cate hua amo quepea tli quecuösque. Hua amo necneque nequentitlanes ma yöcö sin tlacuösque, majcamo cana iye que abele cöhuantörusque ipa ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Entunses tiemachtejcöhua otieyelfejque: ―¿Quiene tecpeasque tejua meyac pöntzi necö cöne nionöque chönte, para tequenmexbiltisque tönto lalebes meyac giente? ");
INSERT INTO nhgNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Hua Jesús oquemelfejque: ―¿Quiejquech pöntzi nenquepea? Hua yejua oquejtojque: ―Checume, hua nönöjtetzi mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Hua oquennahuatque tlöca ma motlölicö tlölpa. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Entunses ocönque inu checume pöntzi hua mimechte, hua tietlasojcömatelejque Deus. Entunses oquencojcototzque pöntzi hua mimechte hua oquenmacaque tiemachtejcöhua. Hua tiemachtejcöhua quenmacaque inca tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Hua otlacuajque innochtie, hua oijixbeque. Hua ocajcojque tli cojcotoctec omocö checume pescunchequejme tietieme. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Hua tli otlacuajque oyejyeya nöbe mil tlöca, sin mopoasque sohuame hua pelantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yecuöquenu oquentitlanque noche giente ma yöcö. Hua ocalacoac ijtec börco, hua ohualiloac ipan tlöle itucö Magadan. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yecuöquenu oaseco inu fariseos ca tiehua saduceos para tieprobörusque. Tietlajtlanelejque sente tietzöbetlachihuale quiename sieñas de que Deus tiepaliebiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Cache yejuatzi onöhuatihuac, oquemelfejque: ―Cuöc ye ca ye yohuac tunale, nenquejtoa: “Öxö cuale tiempo huölös ipampa tlachichiliebe”. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Hua ca ise nenquejtoa: “Öxö öyejyecas ipampa tlachichiliebe elfecac hua mextieme”. Cuale nenquemate nequixnenebelisque tli onca ixpa elfecac, pero abele nencasojcömate inu sösantle tli cate quiename sieñas de lo que tli mochihuas ipa ini nönca tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nemejua nencate nengiente amo nencualteque, hua sie tiro amo nenqueneque nentietocasque Deus. Hua öxö nenqueneque ma nemiechmaca sente sieñas. Pero amo nemiechmacas nion sente sieñas de tietzöbetl tlöcamo solamiente inu sieñas de Jonás tlayulepante. Hua oquencöjtiejque, hua obiloac. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Hua cuöc ohuölajque tiemachtejcöhua hasta pa inu löro ötiescatl, oquelcöjque de quehualecasque pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Hua Jesús oquemelfejque: ―Xequejtacö. Xomotlachilicö de inu levadura de fariseos hua de saduceos. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yejua molfejtaya, oquejtoöya: ―Yejuatzi quejtulo ejqueu ipampa amo otecualecaque pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ocasojcömatque Jesús, hua oquejtojque: ―¿Tlica nemolfea nemotzölö de que amo nenquepea pöntzi? Lalebes nemiechpoloa neltoquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Quie ayemo nencasojcömate, nimpor amo nenquelnömeque de inu möcuile pöntzi tli omoxiexelojque intzölö möcuile mil tlöca, hua quiejquech chequejme nencajcojque? ");
INSERT INTO nhgNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nimpor amo nenquelnömeque de inu checume pöntzi tli omoxiexelojque intzölö nöbe mil, hua quiejquech pescunchequejme nencajcojque? ");
INSERT INTO nhgNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Quiene noso ayemo nencasojcömate? Pues amo nemiechonelfe ipampa pöntzi. Pero xomotlachilicö de inu levadura de fariseos hua de saduceos. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Entunses ocasojcömatque quiene amo oquemelfiloöya ma motlachilicö de levadura de pöntzi, tlöcamo cache ma motlachilicö de inenseñönsas de fariseos hua de saduceos. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Hua cuöc ohualiloac Jesús ca tlöle itlac puieblo itucö Cesarea de Filipo, oquentlajtlanejque tiemachtejcöhua. Oquemelfejque: ―¿Öquenu quejtoa giente que necaca naja öque onochi netlöcatl? ");
INSERT INTO nhgNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Hua yejua oquejtojque: ―Pos seque quejejtoa que Xohuö Bautista, hua seque que nele inu tlayulepante Elías, hua ocseque que nele Jeremías, noso beles ocsente tlayulepante de tli pa nieca tiempo tlajtlajtoöya de pörte de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Hua yejuatzi oquemelfejque: ―Hua nemejua, ¿öquenu nenquejtoa tlö naja necaca? ");
INSERT INTO nhgNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Hua onöhuat Semu Piero, oquejto: ―Tejuatzi tomobetzteca teCristo, öque Deus metzmixpejpenelejque. Tejuatzi tetieConietzi de Deus, öque nemoa. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Entunses onöhuatihuac Jesús, oquelfejque: ―Cuale mocnupel, Semu, iconie Jonás. Pos amo yeca tlöcatl metzmacheste ini sösantle, cache metzmachestejque noTajtzi öque iloac elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Cache naja nuyejque temetzelfea, que taja tecaca tePiero (quejtusneque Tietetu). Hua ipa ini nönca tietebiebentzi necchejchihuas noiglesia de innochtie creyentes. Hua noche ichecöhuales de inu mectlöncale abele quexexicus. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hua taja temetzenmacas yöbejte de elfecac cöne Deus tlamandöruro. Hua noche tli tectzacuelis ipa ini nönca tlöltecpactle iyes lo que tli motzacuelea ompa elfecac, hua noche tli tectlöcayejtas ipan tlöltecpactle iyes lo que tli motlöcayejta ompa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yecuöquenu oquennahuatejque tiemachtejcöhua majcamo öque quelficö tlö yejuatzi iloac inu Cristo öque Deus tieixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde ipa inu niecate tunalte Jesús piehualuc quenmachestiloöya tiemachtejcöhua nele tieconbenieroöya ma biloa ca Jerusalén, hua ma quesufrirucö meyac sösantle tli tiechibelisquea biebentzetzi hua jefes de teopexcötzetzi hua tlamachtiöneme de teotlajtule. Nuyejque tieconbenieroöya ma tiemecticö, hua ma yulebihua ipa yeye tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Entunses Piero tieasec hua tieajajuac, otieyelfe: ―Tlöcatzintle, majcamo metzmopasörfe ini nönca. Ayec ejqueu mopantzinco betzes ini sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero yejuatzi onecuepaluc. Oquelfejque Piero: ―Xebeya de naja, Satanás. Taja tecaca para naja quiename sente tietetu cöne noteputlames. Pues taja amo tomofijöroa de sösantle tli de Deus tlöcamo sa tli de tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yecuöquenu Jesús oquemelfejque tiemachtejcöhua: ―Tlö canajyeca queneques niechtocas, majcamo quechihua lo que tli sa yaja queneque, tlöcamo ma niechtoca mös quepeas que quesufrirus quiename öque quesufriroa ipa sente corujtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pos öque beletes queneques quemalfis inemeles, quixniempolus. Hua öque beletes quetiemacas inemeles nopampa, queniextis. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pos ¿tli para serbirebes tlö sente tlöcatl quetlönes noche tlöltecpactle pero quixniempolus inemeles? ¿Noso tli quemacas sente tlöcatl para ocsajpa quepeas inemeles? ");
INSERT INTO nhgNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pues naja que onochi netlöcatl nehuölös ipa tietlaniexteles de noTajtzi inca noöngeles, hua entunses nequentlaxtlöbelis cara sesen tlöcatl san quiene ca itlachihual. ");
INSERT INTO nhgNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Melöhuac nemiechelfea, que seque de tli oncö nencate amo nenmejmequesque hasta senamo nenquejtasque quiene naja que onochi netlöcatl nehuölös para netlamandörus. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sötiepa de checuasien tunale, Jesús oquemaxihuato Piero ca tiehua Jacobo hua Xohuö icni Jacobo. Oquenbicaque nencua ipa sente tepietl bejcapa. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ompa necuepaluc ocsie imixtla. Hua tzotzotlacaya tiexöyac quiename tunale, hua tietlaquie omochi istöc quiename tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hua moniextejtequisque Moisés ca Elías, hua yejua tlajtlajtoöya ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Yecuöquenu Piero otieyelfe Jesús: ―Tlöcatzintle, cuale que oncö tecate. Tlö tomonequitea, naja nequenchejchihuas necö yete cuajtlapame: sente para tejuatzi, hua sente para Moisés, hua ocsente para Elías. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hua cuöc yaja oc tlajtlajtojtaya, necö sente mextle de tlöbile oquentlapacho. Hua necö sente tlajtule ijtec mextle oquejto: ―Yaja ini nönca notlasojcöConie. Itech ini nönca nepöcteca. Yaja xejcaquecö. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Hua tiemachtejcöhua, cuöc oquecajque ini nönca, omopiechojtequisque, hua omomajtejque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Hua cuöc Jesús axihuato intlac, oquenmötocaque, hua oquejtojque: ―Xemiehuacö, hua amo xomomajticö. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Hua cuöc yejua otlachixque, nionöque amo oquejtaque, tlöcamo sa Jesús tiesiel. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Hua cuöc ye hualtemoöya de ipa tepietl, oquennahuatejque Jesús, oquemelfejque: ―Amo öque xequelicö ini tli nenquejtaque, hasta senamo naja que onochi netlöcatl neyulebes de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yecuöquenu tiemachtejcöhua tietlajtlanejque, otieyelfejque: ―¿Tlica quejtoa inu tlamachtiöneme de teotlajtule que conbenierebe cachto ma huöla Elías? ");
INSERT INTO nhgNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Hua onöhuatihuac Jesús, oquemelfejque: ―Tiel melöhuac, Elías huölös hua queyectlölis noche sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero nemiechelfea que Elías ye onhuöla, pero amo oquixomatque. Hua oquechibelejque noche tli yejua oquenejque. Ejqueu nuyejque naja que onochi netlöcatl niechchibelisque meyac sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yecuöquenu tiemachtejcöhua ocasojcömatque que oquennunutzaloöya de Xohuö Bautista. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Hua cuöc oajaxihuato intlac giente, ohuöla sente tlöcatl omotlancuöquetz tieixpa. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Oquejto: ―Tlöcatzintle, xomopile icnuejtelestle de noconie. Pos quepea mimequelestle, hua lalebes mococoa. Quiemaneyo betze ipa tletzintle, noso ijtec ötzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Onequemejtete momachtejcötzetzihua, pero abele oquepajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Hua onöhuatihuac Jesús, oquejtojque: ―¡Ay! ¡Nentlöca que amo nemoneltoca hua amo nenquepensöroa lo que tli melöhuac! ¿Pos hasta quiema nemotlac neyes? ¿Hasta cöne necpeas necxicojtas ca nemejua? Xecualecacö necö. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Hua Jesús ocajajuaque inu demunio, hua oquis de inu pelalactle. Hua opajtec pelalactle desde inu tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yecuöquenu omopachojque tiemachtejcöhua tietlac Jesús nencua. Tieyelfejque: ―¿Tlica tejua abele toconquextelejque? ");
INSERT INTO nhgNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Hua Jesús oquemelfejque: ―Ipampa nemiechpoloa neltoquelestle. Pues melöhuac nemiechelfea, que tlö nenquepeasquiöne nemoneltoqueles quiename ixenöchyo mostöza, nenquelfisquiöya ini nönca tepietl: “Xomopacho de necö hasta niepa”, hua mopachus. Hua amo oyes niontle tli abele nenquechihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(This verse does not appear in the printed copy) ");
INSERT INTO nhgNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Hua cuöc mosentlöliöya ipan Galilea, Jesús oquemelfejque: ―Naja öque onochi netlöcatl niechtiemöctisque inmöpa tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Niechmectisque. Pero ipa yeye tunale neyulebes. Hua yejua motequepachojque lalebes por inu. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Hua cuöc ajaxihuato ipa Capernaum, ohuölajque ica Piero tli quenechecoöya inu contribuseyu de teopantle. Oquejtojque: ―¿Nemomaestro amo quetlaxtlöhuas inu contribuseyu? ");
INSERT INTO nhgNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Hua yaja oquejto: ―Quienamo quetlaxtlöhuasque. Hua cuöc ocalac yaja calejtec, Jesús oquelfejque cachto. Oquejtojque: ―¿Quiene metzparesieroa, Semu? Inu reyes de tlöltecpactle, ¿de öque quenechecoa inu impuestos hua tlanechecule? ¿De inpejpelhua, noso de ocseque giente? ");
INSERT INTO nhgNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piero otieyelfe: ―Pos de ocseque giente. Jesús oquelfejque: ―Entunses quejtusneque que inpejpelhua amo tli quepea que quetlaxtlöhuasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero mösque amo tecpejpea que tectlaxtlöhuasque, amo necneque nequencualöntis inu giente. Por inu xebeya ipa ötiescatl, hua xectlajcale moanzuelo ijtec ötzintle para tecases meche. Hua tli meche tejquextis cachto, xecase hua xejcamatlapo. Hua tecniextelis sente moneda. Xectiemaca para tectlaxtlöhuas contribuseyu por naja hua por taja. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ipa inu nieca tiempo omopachojque tiemachtejcöhua tietlac Jesús. Otieyelfejque: ―¿Öquenu noso cache bieye momajtas cöne Deus tlamandöruro? ");
INSERT INTO nhgNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yecuöquenu Jesús oquenutzque sente peltzintle, hua oquetlölejque innepantla de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Oquejtojque: ―Melöhuac nemiechelfea, que tlö amo nemoyulcuepasque para nemochihuasque quieme nenpelantzetzi, amo nencalaquesque ompa cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ejqueu, öque mopichaquis para iyes quieme ini nönca peltzintle, yaja bieye momajtas cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Hua tlö canajyeca queselis sente peltzintle quieme ini notucöyupa, naja niechselea. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pero tlö canajyeca quechihualtis sente de ini nöncate pelantzetzi tli moneltoca ca naja ma betze ipa tlajtlacule, cache cuale uyene para inu tlöcatl ma quilpelicö sente tietetu de molino ipa icucutla, hua ma quepötzcalaquicö ijtec lamör. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Porube de tlöltecpactle! Pues seme giente quenchihualtisque ocseque giente ma betzecö ipan tlajtlacule. Pues abele iyes de ocsie maniera; seme giente ejqueu quechihuasque. Pero ¡porube de inu nieca tlöcatl öque quechihualtea ma betze ocsente ipa tlajtlacule! ");
INSERT INTO nhgNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Hua tlö quejtus momö noso mocxe metzchihualtis tebetzes ipan tlajtlacule, pos xectejteque hua xectlajcale de taja. Cache cuale tecpeas nemelestle mös tecucoxojtzi noso temöcotoctec, hua amo ca unte momöhua hua unte mocxehua ma metztlajcale Deus ijtec tletzintle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tlö mixtelolo metzchihualtis tebetzes ipan tlajtlacule, xejcopina hua xectlajcale de taja. Cache cuale tecpeas nemelestle mös sa sente mixtelolo tecpeas, hua amo ca unte mixtelolojua ma metztlajcalecö Deus ijtec tlecale cöne xutla tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Xecpeacö cueröro majcamo cana nenquedespresiörusque sente de ini nöncate tzequetzetzi. Pues nemiechelfea que oncate öngeles tli quemixutea. Hua inu öngeles ompa elfecac seme tieyetztecate tiexöyac de noTajtzi öque iloac elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(This verse does not appear in the printed copy) ");
INSERT INTO nhgNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Quiene nemiechparesieroa? Tlö sente tlöcatl quepea sie sientos de calnielojte, hua tlö quepolus sente de yejua, ¿amo quencöjtiehuas inu ocseque noventa y nueve calnielojte, hua quetiemuti ca pan tepieme inu sente tli opole? ");
INSERT INTO nhgNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Hua tlö quejtus queniextis, melöhuac nemiechelfea que cache quepea pöquelestle de inu nieca, que de inu ocseque noventa y nueve tli amo opolejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ejqueu mismo nemoTajtzi öque elfecac iloac amo quenequihua ma ixniempolebe nion sente de ini nöncate tzequetzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Hua tlö quejtus mocni tlajtlacus encuntra de taja, xebeya ca yaja. Xequelfe tli tlajtlacule oconchi, sa nemosiel taja ca yaja. Tlö ometzcac, ye otectlö porque ocsajpa iyes cuale entre taja hua mocni. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Cache tlö amo metzcaque, xequemase sente noso unte ocseque para que yösque moca quenunutzasque mocni. Ejqueu unte noso yete testigos cuale tlatestificörusque de noche tli mojtus. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Hua tlö amo quencaques nimpor yejua, xequemelfe innochtie creyentes cuöc mosentlölea. Hua tlö amo tlacaques cuöc quenunutza inu grupo de creyentes, xectratörucö quiename sente que amo moneltoca noso quiename sente tlanecheco. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Melöhuac nemiechelfea que noche tli nenquetzacuelisque ipan tlöltecpactle iyes lo que tli motzacuelea ompa elfecac. Hua noche tli nenquetlöcayejtasque ipan tlöltecpactle iyes lo que tli nuyejque motlöcayejta ompa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ocsajpa nemiechelfea, que tlö quejtus unte de nemejua necö ipan tlöltecpactle nenyesque de acuierdo para nentlajtlanesque canajyetla, noTajtzi öque elfecac iloac quechihuasque por nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ipampa cönen cate unte noso yete tli mosentlölejtecate notucöyupa, ompa neca ca innepantla de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yecuöquenu Piero omopacho tietlac yejuatzi. Otieyelfe: ―Tlöcatzintle, ¿quiejquechpa necperdonörus nocni cuöc tlajtlacus encuntra de naja? ¿Hasta checumejpa? ");
INSERT INTO nhgNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesús oquelfejque: ―Amo temetzelfea que hasta checumejpa, cache hasta setenta veces checumejpa. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Ejqueu, quiene Deus tlamandöruro icaca quiename sente rey, que yaja oquenec quechihuas cuientas ca itlatequepanojua. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Hua cuöc opie ica inu tlapoalestle, oquehualequelejque sente itlatequepano tli quetiebiquelejtaya mil millones de tomi. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Pero abele quetlaxtlöbeliöya, hua itieco otlatitla ma quenamacacö, ca tiehua isohua hua ipelhua hua noche tli quepeaya, para ma quetlaxtlöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Yecuöquenu inu nieca tlatequepano omotlancuöquetz, hua quetlajtlötlajtiöya. Oquejto: “Xomochile ca paciencia, hua naja temetzmotlaxtlöbelelis noche”. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Inu tlöcatzintle quetlöocolte inu nieca itlatequepano. Oquecajcö hua oqueperdonöro. Oquetlapojpolfele itietlabiqueles. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Hua cuöc oquis inu nieca tlatequepano, oqueniextito sente itlöcaicni, que quebiquelejtaya quiesquete piesos. Hua ocasec, hua quepötzmectiöya. Oquejto: “Xeniechtlaxtlöbele tli teniechbiquelea”. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yecuöquenu itlöcaicni omotlancuöquetz hua quetlötlajtiöya, oquejto: “Xomochile ca paciencia, hua naja temetzmotlaxtlöbelelis noche”. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Cache yaja amo oquenec, tlöcamo uya hua oquecalaquito ijtec cörsel ma ompa yeta hasta senamo quetlaxtlöhuas tli quetiebiquelejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Hua cuöc itlöcaicnihua tli nuyejque quetequepanoöya inu rey oquejtaque tli mochihuaya, omotequepachojque lalebes. Hua ohuölajque, quelfico intieco noche tli omochi. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Yecuöquenu itieco oquetlatitla para ma huöla inu tlatequepano. Oquelfe: “¡Taja tetlatequepano que sie tiro amo tecualtec! Noche inu nieca tli teniechbequelejtaya temetztlapojpolfele hua otemetzperdonörfe ipampa teniechtlötlajte. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Tlica amo nuyejque ejqueu taja amo metztlöocolte motlöcaicni, quieme nuyejque naja teniechtlöocolte?” ");
INSERT INTO nhgNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hua ocualö lalebes itieco, hua oquetiemöcte ca tli quetiemaca tietunie tiecoco, hasta senamo ma quetlaxtlöhua noche tli quetiebiqueliöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ejqueu nuyejque noTajtzi öque elfecac iloac quechihuasque ca nemejua, tlö amo nenquenperdonörusque nemocnihua ca noche sentetl nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Hua omochi que sötiepa de que Jesús oquetlamejque ini nöncate tlajtulte, oquixoac de inu estado de Galilea, hua ohualiloac itlac estado de Judea, pa ocsie löro de ötlactle Jordán. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Hua otietocaque meyactie giente. Hua oquenpajtejque ompa. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yecuöquenu seque fariseos omopachojque tietlac para tieprobörusque. Hua tietlajtlanejque: ―¿Conbenierebe que sente tlöcatl ma quecajcöhua isohua ipampa canajyetla sösantle? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Hua yejuatzi onöhuatihuac, oquejtojque: ―¿Ayec nenquetlajtultejque que yejuatzi öque oquenchejchijque desde ca opie, oquechtle hua sohuatl oquenchejchijque? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Hua oquejtojque: “Por inu, tlöcatl quecöjtiehuas itajtzi hua inöntzi, hua mosietelis ca isohua. Hua yejua umeme mochihuasque sa sie cuierpo”. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ejqueu noso ayecmo cate ume, tlöcamo sa sie cuierpo. Por inu, lo que tli Deus oquesietelejque, majcamo quenencuajtele tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Otieyelfejque: ―¿Tlica, noso, Moisés otlanahuate ma öque quemaca sente öcta de divorcio hua ma quecajcöhua? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Hua oquemelfejque: ―Ipampa nenyultepitzteque lalebes, por inu Moisés onemiechcö nenquencajcöhuasque nemososohuahua. Pero cuöc opie tlöltecpactle amo ejqueu oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hua naja nemiechelfea que öque beletes quecajcöhuas isohua, hua mosohuajtis ca ocsente sohuatl, ye tlaumepea hua tlajtlacoa. Mös tlö cana sohuatl otlajtlaco ca ocsie tlöcatl, entunses cuale quecajcöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tieyelfejque tiemachtejcöhua: ―Tlö ejqueu icaca para sente tlöcatl ica isohua, cache cuale öque amo mosohuajtis. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Hua yejuatzi oquemelfejque: ―Amo innochtie cuale queselisque ini nönca tlajtule, tlöcamo sa inu niecate öque Deus quenmacasque beletelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Oncate capunteque que otlajtlöcatque ejqueu, que desde cuöc oyejyeya imijtecopa innajnönhua ejqueu cate que abele mosohuajtisque. Nuyejque oncate capunteque, que giente oquenchijque capunteque, hua oncate seque que quiename omochijque capunteque yejua mismos, hua amo mosohuajtea para que ejqueu cache cuale tequetesque para ma isejcö ma tlamandörucö Deus. Öque cuale queselis ini tlajtule, ma quesele. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yecuöquenu tiehualequeliöya pelantzetzi, para ma quentlölicö tiemöhua impa yejua, hua ma netlajtlötlajtilo por yejua. Pero tiemachtejcöhua quemajajuaya giente tli quenhualecaya inpelhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús oquejtojque: ―Xequencöhuacö pelantzetzi, hua amo xequentzacuelicö para ma huölöcö notlac. Pos giente tli cate quiename nochimeji pelantzetzi quepeasque pörte cöne Deus tlamandöruro desde elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Hua oquentlölejque tiemöhua impa. Sötiepa obiloac de ompa. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Hua necö, sente tlöcatl omopacho hua otieyelfe: ―Maestro, ¿tli sösantle cuajcuale necchihuas para necpeas nemelestle nochepa? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Hua yejuatzi oquelfejque: ―¿Tlica teniechtlajtlanea de lo que tlin cuale? Iloac sente öque iloac cuale. Pero tlö taja tecneque tecpeas nemelestle, xecneltoca inu mandamientos. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Otieyelfe: ―¿Cötlejuanu? Hua Jesús oquelfejque: ―“Amo tetlamectis”. “Amo tecalaques ca isohua ocsente”. “Amo tetlachteques”. “Amo tiecamac tetieajaques”. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","“Pa tequemejtas motajtzi hua monöntzi”. Hua, “Tectlasojtlas motlöcaicni quieme taja tomotlasojtla”. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Oquejto inu tielpuchtle: ―Noche ini nönca necchijtebitz. ¿Tli ocseque niechpoloa? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Oquelfejque Jesús: ―Tlö tecneque teyes intiero tecualtec, xebeya, xecnamaca noche tli tecpea, hua xequenmaca tli porubejte. Ejqueu tecpeas ricojyutl ompa elfecac. Entunses xehuöla, xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero cuöc inu tielpuchtle oquecac ini nönca tlajtule, yaja uya. Motequepachoöya porque quepeaya meyac tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Hua Jesús oquemelfejque tiemachtejcöhua: ―De melöhuac nemiechelfea, que para sente rico icaca tequeyo lalebes para calaques cöne Deus tlamandöruro desde elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ocsajpa nemiechelfis, que cache isejco panus sente camello ijtec ixtelolo de sente öcuxa, que sente rico calaques cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Hua cuöc oquecajque tiemachtejcöhua, pos quetietzöbejque bel lalebes. Oquejtojque: ―Tlöjcu, ¿öquenu noso cuale momöquextis? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Entunses Jesús quemetztalutaya. Oquemelfejque: ―Para tlöca abele mochihuas ini nönca. Cache para Deus noche sösantle cuale mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Entunses Piero otieyelfe: ―Xomojtele, tejua otejcöjque noche, hua otemetzmotoquelejque. ¿Tli noso tecpeasque? ");
INSERT INTO nhgNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Hua Jesús oquemelfejque: ―De melöhuac nemiechelfea, que cuöc noche moyancuelis, cuöc naja öque onochi netlöcatl notlölis ipa notrono de tlaniextelestle, nemejua nuyejque tli nenniechtocaque nemotlölisque ipa majtlactle huan ume tronos. Hua nenquenjuscörusque inu majtlactle huan ume grupos de giente de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Hua öque beletes cualcöjtiehuas calte noso icnihua oquechte noso icnihua sohuame noso itajtzi noso inöntzi noso ipelhua noso itlölhua, por ipampa notucöyo, quepeas sie sientos töntos, hua nuyejque mohuöxcatis de nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero meyactie yesque sölúltimo tli öxö cate cachto, hua yesque cachto tli öxö cate sölúltimo. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","’Porque quiene Deus tlamandöruro desde elfecac icaca quiename sente tlöcatl chöne, que oquis ca cualcö quensentlölito tequetque para tequetesque ipa ihuierta de uvas. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hua oquemelfe tequetque que quentlaxtlöbis sie denario tomi por tunale. Entunses oquentitla ipan huierta. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Hua quieme ca pan checnöbe ura oquis, hua oquemejtac ocseque oijcataya pan plöza hua amo tli axtaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Hua oquemelfe: “Xeyöcö nuyejque nemejua xetequetete ipa notlöl, hua nemiechtlaxtlöbis lo que tli conbenierebe”. Hua yejua uyajque. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Hua oquis ocsajpa quieme ca pan tlajca hua quieme ca pa yeye, hua ocsajpa ejqueu oquechi. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Hua cuöc oquis quieme ca pa möcuile ura, oquenniexte ocseque amo tli axtaya. Oquemelfe: “¿Tlica oncö nencate noche semelfetl hua amo tli naxtecate?” ");
INSERT INTO nhgNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Oquenönquelejque: “Ipampa amo öque tiechtlalfe ma tetequetecö”. Oquemelfe: “Xeyöcö nuyejque nemejua ipa nohuierta, hua nemiechtlaxtlöbis lo que tli conbenierebe”. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Hua cuöc ye omochi ca ye yohuac, inu señor öque ihuöxca inu nieca huierta oquelfe inu calpexque: “Xequentzajtzele inu tequetque hua xequentlaxtlöbe tli intunal. Xepiehua desde tli onhuölajque sötiepa hasta tli cachto onhuölajque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hua cuöc onhuölajque tli ocalajque ipa möcuile ura, oquenmacac siesen denario. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Hua cuöc huölajque tli ocalajque cachto, yejua quepensöroöya que quenmacas cache. Pero yejua oquenmacac nuyejque siesen denario. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Hua cuöc motlaxtlöbejque, ica tlajtoöya inu chöne. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Quejtoöya: “Nöncate sötiepa onhuölajque otejtequetque sa sie ura. Hua taja tequentratöroa iguöl quiename tejua, mös tejua noche tequetl toconchijque hua noche tunale topa otunac”. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hua yaja onöhuat, oquelfe sente de yejua: “Amigo, amo temetzchibelejteca tli amo cuale. ¿Amo melöhuac que totlölejque de acuierdo para naja temetztlaxtlöbis sie denario? ");
INSERT INTO nhgNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xecöna noso ini nönca sie denario, pues mohuöxca, hua xebeya. Naja necneque necmacas sie denario ca ini nönca tli sötiepa onhuöla, quiename taja temetzmacac. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Quie beles amo necpea deriecho para necchihuas tli naja necneque ca tli nohuöxca? Noso ¿beles taja tomoxicoa, ipampa naja necuale tlöcatl para ca ocseque?” ");
INSERT INTO nhgNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","’Ejqueu tli öxö cate sölúltimo yesque cachto, hua tli cate cachto yesque sölúltimo. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Hua otlejcoac Jesús ca pa ojtle para biloas ca inu ciudad de Jerusalén. Oquenbicaque nencua inu majtlactle huan ume tiemachtejcöhua. Oquemelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Xequejtacö. Tetlejcotebe ca pa Jerusalén. Hua naja öque onochi netlöcatl niechtiemöctisque ca jefes de teopexcötzetzi hua inca tlamachtiöneme de teotlajtule. Entunses yejua niechcuntenörusque ma nemeque. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Niechtiemöctisque ca tli amo de topuieblo para moburlörusque de naja hua niechbitequesque, hua niechcoruspelusque. Cache ipa yeye tunale Deus niechyulebitisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Yecuöquenu ohuöla tietlac innöntzi de ipelhua Zebedeo inca ipelhua. Tiemabesutiöya, hua tietlajtlaneliöya sente favur. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Hua yejuatzi oquelfejque: ―¿Tli tecneque? Yaja otieyelfe: ―Xomotlanahuatele por favur ma motlölicö ini nöncate nopelhua, sente ca momöyecontzi hua ocsente ca momöarrabiescontzi, cuöc tejuatzi tomotlamandörfis. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Entunses Jesús onöhuatihuac, hua oquejtojque: ―Amo nenquemate tli nentlajtlane. ¿Cuale nenconisque de inu bölso de tietunie tli naja isejco neconis? Hua yejua tieyelfejque: ―Cuale tecchihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Hua yejuatzi oquemelfejque: ―Melöhuac nobölso de tietunie nenconisque. Pero para nemotlölisque sente ca nomöyecmö hua ocsente ca nomöarrabis, abele nemiechmacas. Cache icaca para yejua tli quemixpejpenque noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Cuöc inu majtlactle oquecajque inu, ocuajcualönque inca inu unte icnijte. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesús oquennutzque hua oquemelfejque: ―Ye nenquemate que inu tlötlajtoönejme de giente de ocseque naciones ca fuiersa quensujetöroa tlöca. Tli motztecate cache bejbeye intzölö, pos ca checöhualestle quenmandöroa giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Cache nemotzölö nemejua amo ejqueu iyes; tlöcamo öque queneques cache bieye momajtas nemotzölö, ma mosujetöro para nemiechtequepanus. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Öque beletes de nemejua queneques iyes cache importönte, iyes nemotlatequepano. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Pues ejqueu mismo naja que onochi netlöcatl amo onehuöla para ma giente ma niechtequepanucö, tlöcamo para nequentequepanus giente. Nehuöla para nectiemacas nonemeles para ejqueu nectlaxtlöhuas inpatie de meyactie, para que ejqueu quepeasque libertad. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yecuöquenu oquejquixoac de inu puieblo de Jericó. Hua tietocaya meyac giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Hua necö unte ixcocoxcötzetzi yejyehuataya itienco ojtle. Hua cuöc oconcajque nele Jesús opanoöya, tzajtzajtzeya. Oquejtojque: ―Tlöcatzintle, iConie David, ma temetzmoyulcocolficö. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Hua inu giente quemajajuaya nele ma quetzacuacö incamac. Pero yejua cache tzajtzajtzeya, quejejtoöya: ―Tlöcatzintle, iConie David, ma temetzmoyulcocolficö. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yecuöquenu onequetzaluc Jesús, hua oquennutzque. Oquejtojque: ―Pos ¿tli nenqueneque ma nemiechchibele? ");
INSERT INTO nhgNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Hua yejua otieyelfejque: ―Tlöcatzintle, ma cuale tetlacheacö. ");
INSERT INTO nhgNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Entunses Jesús tietlöocoltejque, hua oquenmötocaque imixtelolojua. Hua sa nima otlachixque, hua otietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Huajualbiloac ipa Betfagé, itlac tepietl de los Olivos, amo bejca de inu ciudad de Jerusalén. Entunses Jesús oquentitlanque unte de tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Oquemelfejque: ―Xeyöcö ipa inu puieblo tli niepaca. Sa nima nenqueniextisque sente purolama ilpetas, hua sente purojconetzi ca yaja. Xequentojtomacö, hua xeniechenhualequelicö. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tlö canajyeca canajyetla nemiechelfis, xequejtucö que Tlöcatzintle quennesesitöruro. Entunses sa nima cualentitlanes. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Hua noche ini nönca sösantle omochi para ma mochihua tli omojto por inu tlayulepante cuöc oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xequelfe inu giente de Sión, noso Jerusalén: “Xequejtacö necö, que nemoRey biloatz nemoca. Yulsiejque, yehualutebitz ipa sente purolama, hua ipa sente yulcöconetzi, iconie puro”. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Hua tiemachtejcöhua uyajque hua oquechijque san quiene ca Jesús oquemelfejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hua oquehualecaque purolama hua purojconetzi, hua oquetlölejque intlaquie impa. Hua yejuatzi onetlöliluc impa. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hua cöso innochtie giente quesoaya intlaquie ipa ojtle. Hua ocseque quetequeya imömöyo cuajme, hua quesoaya ipa ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Hua inu giente tli oyöya adelönte, hua tli hualtlatocatöya, tzajtzajtzetöya, quejejtoöya: ―¡Osana! ¡Hualiloac iConie David! ¡Ma tetieteochihuacö öque biloatz tietucöyupa Tlöcatzintle! Mojtoa ompa elfecac: “¡Osana!” ");
INSERT INTO nhgNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Hua cuöc ocalacoac ipa ciudad de Jerusalén, noche puieblo cuejcueyuneya. Oquejtoöya: ―¿Öquenu icaca ini nönca? ");
INSERT INTO nhgNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Hua giente quejtoöya: ―Ini nöiloac yejuatzi Jesús tlayulepante de puieblo de Nazaret pa estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Hua ocalacoac Jesús ipan teopantle. Oquenquextejque ca queyöhuac noche quiejquech tlajtlanamacaya hua motlajtlacubiöya ipan teopantle. Quencuajxelfelejque inmiesa de tli quepatlataya tomi, ca tiehua siyetajte de tli quennajnamacataya palumaxte. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Hua oquemelfejque: ―Tlajcuelulpanca: “Nocal mocuitis cale de netlötlajtelestle”. Cache nemejua nenquechijtecate tiecaltzi Deus quieme cana ustutl de ichtejcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Yecuöquenu ohuölajque tieca yejuatzi ixcocoxcötzetzi ca tiehua cucuxojtzetzi ipan teopantle. Hua yejuatzi oquenpajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero inu jefes de teopexcötzetzi ca tiehua tlamachtiöneme de teotlajtule ocuajcualönque cuöc oquejtaque inu tlachihualestle tli quechihualoöya, hua quiene pelalacme tzajtzajtzeya ipan teopantle hua quejtoöya: ―¡Osana iConie David! ");
INSERT INTO nhgNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Hua yejua otieyelfejque: ―¿Tejcaque taja tli quejejtojtecate ini nöncate? Hua Jesús oquemelfejque: ―Quiema nejcaque. ¿Ayec nenquetlajtultejque ipan teotlajtule nöncate tlajtulme? “De incamacopa de pelantzetzi hua de tli chejchiche tomoyecniextele mochamöhualestzi”. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yecuöquenu oquencöjtiejque. Oquixoac de inu ciudad hua obiloac ca pa Betania, hua ompa nesiebiluc. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Hua pa mustlateca ca ise ocsajpa ohualiloac ipa ciudad, hua oteosebihuaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hua oquejtaque sente icox cuabetl sa ompa itlac ojtle. Ohualiloac itlac, pero amo tli oqueniextejque itech, tlöcamo sa ixejyo. Hua oquelfejque: ―Ma nochepa ayec quisa de taja fruto. Hua nima uhuöc inu icoxcuabetl. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Hua cuöc oquejtaque tiemachtejcöhua, oquetietzöbejque. Oquejtoöya: ―¿Quiene uhuöc sa nima inu icoxcuabetl? ");
INSERT INTO nhgNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Hua onöhuatihuac Jesús hua oquemelfejque: ―Melöhuac nemiechelfea que tlö nenquepeasque neltoquelestle, hua amo nemoyulcuiecuectasque, nenquechihuasque sösantle cache bejbeye que ini nönca de icoxcuabetl. Hasta tlö ini nönca tepietl nenquelfisque: “Xomojcuene hua xomotlajcale ijtec lamör”, pues mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Hua noche tli nentlajtlanesque ica netlajtlötlajtelestle, ca neltoquelestle, nenqueselisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hua cuöc ohualiloac ipan teopantle, tlamachtilutaya. Hua ohuölajque tietlac inu jefes de teopexcötzetzi ca tiehua biebentzetzi de inu nieca puieblo. Oquejtojque: ―¿Ca tli beletelestle tecchihua ini nönca sösantle? Noso ¿öquenu metzmacac ini nönca beletelestle? ");
INSERT INTO nhgNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Hua onöhuatihuac Jesús, oquemelfejque: ―Naja nuyejque nemiechtlajtlanes sente pregunta. Tlö nenniechelfisque, nuyejque naja nemiechelfis ca tli beletelestle necchihua ini nönca. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Xohuö Bautista tlacuötiequiöya. ¿Öquenu cualtitlanque ma tlacuötieque? ¿Beles Deus, noso beles tlöca? Yecuöquenu yejua omonenebelejque, hua molfejque: ―Tlö tequejtusque que Deus, tiechelfis: “¿Tlica noso amo nemoneltocaque ca yaja?” ");
INSERT INTO nhgNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Hua tlö tequejtusque que tlöca, pos tequenmabelea inu meyac giente, ipampa innochtie quepensöroa que Xohuö oyeya tlayulepante tli tlajtlajtoöya de pörte de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Entunses onöhuatque. Tieyelfejque Jesús: ―Amo tecmate. Hua yejuatzi oquemelfejque: ―Nuyejque naja amo nemiechelfis öque niechmacac beletelestle para ma necchihua ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","’Pero ¿quiene nemiechparesieroa ini nönca cuiento? Que sente tlöcatl quepeaya unte ipelhua. Hua omopacho itlac sente, oquelfe: “Ixo, xebeya öxö xetequetete ipa nohuierta”. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Hua yaja onöhuat, oquejto: “Amo necneque”. Cache sötiepa omoyulcuec hua uya. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Nuyejque tajtle omopacho itlac ocsente, oquelfe nuyejque ejqueu. Hua onöhuat yaja, oquejto: “Naja neyös, Tlöcatzintle”. Pero amo uya. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Bieno pues, ¿öquenu de innehua oquechi itlanequeles itajtzi? Oquejtojque teopexcötzetzi hua biebentzetzi: ―Yaja cachto. Oquemelfejque Jesús: ―Melöhuac nemiechelfea que inu tlanechecojque hua cacherilajte cachto de nemejua calaquesque ca cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pos ohuöla Xohuö nemoca hua otlanunutz de inu ojtle de yectelestle, hua amo nemoneltocaque ca yaja. Pero inu tlanechecojque hua cacherilajte omoneltocaque. Hua nemejua, mös nenquejtaque inu, pero amo nemoyulcuejque sötiepa para nemoneltocasque ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Xejcaquecö ocsente cuiento. Oyeya sente tlöcatl chöne. Yaja oquetucac sente huierta de uvas temecatl. Quesiercajte ica cuajme. Oquechejchi sente tönque cöne quepötzcas uvas. Quechejchi sente cale bejcapa. Quentlaniejte tejtequetque hua yaja uya ca bejca. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Cuöc ye oaseco tunalte para tlamochihualtis, ocualentitla itlatequepanojua inca inu tequetque para ma quemacacö inu fruta tli quetocöroöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero inu tejtequetque oquemaseque inu itlatequepanojua. Sente oquebitejque, hua ocsente oquemectejque, hua ocsente oquetecaltejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ocsajpa oquenhualentitla ocseque tlatequepanojque, cache meyactie que tli cachto ohuölajque. Pero quentratörojque iguöl. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Hua cache sötiepa ocualtitla iconie. Oquejto: “Beles pa quejtasque noconie”. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero tequetque, cuöc oquejtaque iconie, omolfejque sie yejua: “Yaja ini nönca öque mohuöxcatis de ini nönca huierta. Xehuölöcö, ma tecmecticö. Entunses tejua tecasesque tli yaja mohuöxcatisquea”. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ocaseque. Oquequextejque ca queyöhuac de inu huierta, hua oquemectejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","’Cuöc huölös niecaju tlöcatl öque ihuöxca inu huierta, ¿tli noso quenchibelis inu niecate tejtequetque? ");
INSERT INTO nhgNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Otieyelfejque: ―Quenpojpoluqui sin remedio inu tlöca sie tiro amo cualteque, hua inu huierta quentlaniejtis ocseque tejtequetque, tli quemacasque fruto cuöc conbenierebes. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Oquemelfejque Jesús: ―¿Ayec nenquetlajtultejque ini nönca ipa teotlajtule? Inu tietetu tli calchihuaneme oquetlabielcöjque, yaja mismo öxö omochihuaco esquiniero principal. Yejuatzi Tlöcatzintle oquechijque ini nönca, hua tejua tectietzömate. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Por inu nemiechelfea que ayecmo nemiechtocörus nenyesque cöne Deus tlamandöruro, cache quentocörus giente de ocsente tlöle, tli quetiemacasque quiename fruto lo que tli Deus quenequihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Hua cuöc inu jefes de teopexcötzetzi hua inu fariseos oquecajque ini cuientos, ocasojcömatque que tlajtlajtuloöya de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Hua quetiemoöya maniera para tieasesque, pero quenmabeliöya giente, ipampa giente quepensöroöya que Jesús iloaya sente tlayulepante de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús ocsajpa oquennunutzque ica cuientos. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Quiene Deus tlamandöruro icaca ejqueyi: ica quiename sente rey, que oquechi nesohuajtiluyo para iconie. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Oquentitla itlatequepanojua para ma quennutzate tli oquentlalfejque ipa inu nieca nesohuajtiluyo. Cache yejua amo oquenejque huölösque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ocsajpa oquentitla ocseque itlatequepanojua. Oquejto: “Xequemelficö ejqueyi tli tlatlalfilte: Xequejtacö que tlacuale ye icaca. Nocucobejua hua noyulcöhua tlin tojtomöjque ye onequenmecte, hua noche ye ica listo. Xehuölöcö noso ipa nesohuajtiluyo”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero yejua tlatlalfilte amo oquechijque cöso, cache quechijque tli yejua quenejnejque. Sente onya ipa imil, hua ocsente ipa inegocio. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hua ocseque oquemaseque itlatequepanojua de inu rey, hua quentratörojque san petzotec, hua hasta oquenmejmectejque seque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Hua inu rey ocualö lalebes. Oquentitla isoltörojua, hua oquentlamejque inu niecate mequestierojte, hua oquenxutlaltelejque inpuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Entunses inu rey oquemelfe itlatequepanojua: “Ye icaca listo nesohuajtiluyo, cache tli tlatlalfilte amo quemeresierojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Xeyöcö noso ca cöne quisa ojme, hua xequennutzacö innochtie tli nenquenniextisque ma huölöcö ipa ini nönca nesohuajtiluyo”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Hua itlatequepanojua oquisque ca pa ojtle. Oquensentlölejque noche quiejquech oquenniextejque, ca tiehua petzoteque hua cualteque. Hua inu cale otie ca tlatlalfilte de nesohuajtiluyo. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Hua ocalac rey para quemejtas tli tlatlalfilte, hua oquejtac sente tlöcatl sin tlaquentle cuale de nesohuajtiluyo. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Hua oquelfe: “Amigo, ¿quiene otecnec tecalaques necö sin que amo otomotlaquente ca motlaquie cuale de nesohuajtiluyo?” Cache yaja abele tli oquenönquele. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Entunses rey oquemelfe tli tlatequepanoöya: “Xequilpicö ini nönca tlöcatl pa imöhua hua ipa icxehua. Xecasecö, hua xectlajcalecö ca queyöhuac ipa tlajtlayohuaquelestle. Ompa giente chojchucasque hua motlantesesque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","’Pues meyactie quennutzalo Deus, pero sa quiesquete quemixpejpenalo. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Entunses uyajque fariseos, hua omotlajtulmacaque de quiene tiechihualtisque ma quejtulo canajyetla tli itech cuale tietieyelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Hua tietitlanelejque inmachtejcöhua ca tiehua herodianos tli quetocaya rey Herodes. Yejua oquejtojque: ―Maestro, tecmajtecate que tejuatzi tomobetzteca temelactec hua lalebes tomocualejtelea tlin melöhuac, hua que tetiechmojtetelea de tlin melöhuac de ojtle de Deus, hua que amo tomotlachilejtzinoa de nionöque. Porque tlöca amo metzmoimportörfelea. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Xetiechmolfele noso, ¿tli tomopensörfea? ¿Beles conbenierebe tecmacasque inu emperador César tocontribuseyo, noso amo? ");
INSERT INTO nhgNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Cache Jesús nemacaloöya cuienta de quiene quepensöroöya tli amo cuale. Oquemelfejque: ―¿Tlica nenniechproböroa naja? Pos sa ume nemoxöyac. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xeniechejteticö inu tomi de contribuseyu. Hua yejua otieyejtetejque sie denario tomi. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Oquemelfejque: ―¿Öqueniji ixöyac, hua öquenu ihuöxca ini tlajcuelule? ");
INSERT INTO nhgNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Otieyelfejque: ―De César. Hua oquemelfejque: ―Entunses xecmacacö César tli quetocöroa Cesár, hua xetiemacacö Deus tli tietocöroa Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Hua cuöc oquecajque ini nönca, oquetietzöbejque. Hua tiecöjtiejque, hua uyajque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ipa inu nieca tunale ohuölajque tietlac inu saduceos, hua quejejtojque nele mimejque amo yulebesque. Yejua tietlajtlanejque, ");
INSERT INTO nhgNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","oquejtojque: ―Maestro, Moisés oquejto que: “Tlö meque sente tlöcatl hua amo quepea ipelhua, icni mosohuajtis ca isohua de inu tlöcatl para quentlöcatelelis ipelhua de icni”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bieno pues, oyejyeya totzölö tejua checumeme icnijte tlöca. Inu cachtojyiebe omosohuajte, hua sötiepa omec, hua amo oquepex ipelhua. Así es que oquecöbelejtie isohua para icni. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Hua icni omosohuajte ca yaja, hua nuyejque ejqueu mismo ipa omochi. Hua nuyejque iguöl oquepasöro ocsente icni, hasta senamo noche inu checumeme impa omochi iguöl. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Hua sötiepa de que omejmejque innochtie nuyejque omec sohuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Entunses cuöc yulebesque mimejque, ¿cötlaja de inu checumeme iyes isohua ini nönca sohuatl? Pues innochtie checumeme oquepexque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pero onöhuatihuac Jesús, oquemelfejque: ―Nemixcajcayöhua, porque amo nenquemate tli tlajcuelulpanca hua tli tiechecöhuales Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ipampa cuöc yulebesque mimejque nimpor amo mososohuajtisque nimpor amo monajnömectisque, tlöcamo yesque quiename inu öngeles ompa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero de que tlö onca yulebelestle de mimejque, ¿ayec nenquetlajtultejque tli nemiechelfilo Deus? Pues oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Naja necaca neDeus de Abraham, hua neDeus de Isaac, hua neDeus de Jacob”. Deus amo iloac Deus de mimejque, tlöcamo de tli yulejtecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Hua cuöc inu giente oquecajque, quetietzöbejtaya inu tlamachtelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pero inu fariseos, cuöc oquecajque quiene oquentzacuele incamac inu saduceos, omosentlölejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Hua sente de yejua, tlajmatque de inu ley de Moisés, tietlajtlane sie pregunta para tieprobörus: ");
INSERT INTO nhgNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Maestro, ¿cötlaja mandamiento de inu ley icaca cache bieye? ");
INSERT INTO nhgNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Hua Jesús oquelfejque: ―“Tetietlasojtlas Tlöcatzintle moDeus ca noche sentetl moyulo, hua ca noche sentetl moölma, hua ica noche mopensamientos”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yaja ini nönca mandamiento icaca cachto hua cache bieye. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Hua inu segundo icaca quiename ini nönca: “Tectlasojtlas motlöcaicni quiename taja mismo tomotlasojtla”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Noche tli tlajcuelulpanca ipa inu ley hua inu ömame de tlayulepantejque mase itech ini nöncate ume mandamientos. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hua mientras mosentlöliöya inu fariseos, Jesús oquentlajtlanejque, ");
INSERT INTO nhgNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","oquemelfejque: ―¿Tli nenquepensöroa de inu Cristo öque Deus oquixpejpenque? ¿De öque iconie? Otieyelfejque: ―De David. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yejuatzi oquemelfejque: ―¿Quiene noso David ca Espíritu Sönto quecuitea “noTlöcatzintle”? Pues quejtoa: ");
INSERT INTO nhgNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tlöcatzintle tiemolfeliluc notlöcatzintle: “Xomotlöle ca nomöyecömpa hasta senamo ma nequemumiyöro moenemigos hasta itzintla mocxehua”. ");
INSERT INTO nhgNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ejqueu noso David oquecuite “noTlöcatzintle”. ¿Quiene noso icaca iconie? ");
INSERT INTO nhgNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hua nionöque abele tienönqueliöya ca canajyetla tlajtule. Hua desde entunses nionöque ayecmo matrebiero para tietlajtlanis canajyetla sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yecuöquenu Jesús oquennutzque inu giente ca tiehua tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Oquejtojque: ―Inu tlamachtiöneme de teotlajtule hua fariseos motlölea para nemiechmachtisque quiene otlamachte Moisés. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ejqueu, noche tli nemiechelfisque nenquechihuasque xecmalficö hua xecchihuacö. Pero amo xecchihuacö san quiene ca yejua quechihua. Pos yejua quejtoa, pero amo quechihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Melöhuac, yejua quejilpea tlamömale lalebes yetic, hua quetlölea impa tlöca; cache yejua nimpor ca inmajpel amo queneque cajcoquesque inu tlamömale. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Cache noche intlachihual quechihua para ma quemejtacö giente. Pues quechihua bejbeye inu filacterías cöne quebica sie pörte de teotlajtule ipa imixcuöte hua inmö, hua quesosohua tlatientle de intlaquie. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Seme quenejneque motlölisque ipa tli cache cuale locör cöne tlajtlacua, hua quenejneque tlaixpa yesque ipan teopancucone. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Quepea gusto ma giente quenyectlajpalucö ipan plösa, hua quenejneque ma giente ma quemelficö “totiemachtejcötzi”. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Cache nemejua, majcamo xomocuiticö “totiemachtejcötzi”, ipampa sasie nemomachtejque nenquepea, hua noche nemejua nencate nenicnijte. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Hua nionöque ipan tlöltecpactle amo xejcuiticö “totajtzi”, ipampa sasie nemoTajtzi, ininöiloac elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Nimpor amo xomocuiticö “tomaestro”, ipampa sasie nemomaestro icaca, yaja Cristo öque Deus quixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Öque cache bieye iyes entre nemejua, ma iye nemotlatequepano. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ipampa öque mochajchamöhuas, quepichaquesque; hua öque mopichaques, quepeas chamöhualestle. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’Cache ¡porube de nemejua, tlamachtiöneme de ley hua fariseos, que sa ume nemoxöyac! Pues nenquetzacua pobielta para majcamo öque calaque ompa elfecac cöne Deus tlamandöruro. Hua nion nemejua amo nencalaque, nimpor amo nenquencöhua ma calaquecö niecate tli quenectecate calaquesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","(This verse does not appear in the printed copy) ");
INSERT INTO nhgNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’¡Porube de nemejua, tlamachtiöneme hua fariseos, que sa ume nemoxöyac! Pos nenqueyehualoa noche lamör hua noche tlöltecpactle para nenqueniextisque sa sente tlöcatl tli nemiechtocas. Hua cuöc ye nenqueniextejque, nenquechihualtea ma iye cache lalebes petzotec que nion nemejua. Hua nemonochtie nenyösque tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’¡Porube de nemejua! ¡Nencate nentlajtlayecönque pero nenixcocoxcötzetzi nencate! Nenquejtoa que tlö canajyeca tlajuröroa por teopantle amo tli quejtusneque, pero que tlö tlajurörus por inu oro tli ica pan teupa, quepea que quecumplirus. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Lalebes nentuntojte hua nenixcocoxcötzetzi! Pues ¿cötlaja cache impörtönte ica? ¿Yaja oro tli onca ipa teopantle, o noso yaja teopantle que quechihualtea inu oro ma iye mabestec? ");
INSERT INTO nhgNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Hua nenquejtoa que tlö canajyeca tlajurörus por inu ajtöl, amo tli quejtusneque; cache tlö tlajurörus por inu bentle tli ipanca ajtöl, quepea que quecumplirus. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Nenixcocoxcötzetzi lalebes! Pues ¿cötlaja cache importönte? ¿Yaja bentle, o noso yaja ajtöl que yaja quechihualtea bentle ma iye mabestec? ");
INSERT INTO nhgNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pos öque tlajuröroa por inu ajtöl, quejurörojteca por yaja ajtöl, hua por noche tli ipanca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Hua öque beletes tlajurörus por teopantle, tlajurörojteca por yaja teopantle hua nuyejque por Deus öque chöntihua ijtec. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Hua öque tlajuröroa por elfecac, tlajurörojteca por tietrono de Deus, hua por yejuatzi öque yehualuteca ipa. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’¡Porube de nemejua, tlamachtiöneme de ley hua fariseos, que sa ume nemoxöyac! Pues hasta nenquenejnechecoa ca meyac cueröro inu majtlactle pörte tli nenquetiemacasque de nemoalfabieno hua eneldo hua cominos. Pero onca ocseque sösantle tli nemiechmandöroa inu ley tli cache importönte ica, que yaja ma xecchihuacö tlin melactec, hua ma xequemicnuejtacö giente, hua ma xomoneltocacö. Hua inu sösantle nenquecöhua sin que amo nenquechihua. Pues ica cuale ma xecchihuacö inu sösantle tli nenquechijtecate, pero cache lalebes conbenierebe xecchihuacö inu sösantle tli cache importönte. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nencate nentlajtlayecönque tli nenixcocoxcötzetzi. Pues ca meyac cueröro quiename nenquetzetzeloa tli nencojcone para tlö quejtus amo de repiente amo quebicas sente söyulconetzi, ¡hua mientras hasta nenquetolutecate sente camello! ");
INSERT INTO nhgNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’¡Porube de nemejua, tlamachtiöneme hua fariseos, que sa ume nemoxöyac! Pues nenquechepöhua tli ca queyöhuajca de xoctle noso casfiela para ma niese cuöcualtzi. Pero de ca tlaijtec tienteca de sösantle petzoyutl. Pues nentlachteque hua amo nenquecontrolöroa nemotlaeliebeles, hua inu sösantle icaca quiename petzoyutl ijtec sente xoctle cuöcualtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo ixcocoxque, xecchepöhua cachto tli ca tlaijtec de inu xoctle. Pues ejqueu nuyejque tli ca queyöhuac cuale mochepöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’¡Porube de nemejua, tlamachtiöneme hua fariseos, que sa ume nemoxöyac! Pues nencate quiename mejcöcoyocme yequistoque, que de ca pane melöhuac nejniese cualtzetzi, cache de ca tlaijtec tientecate de memeteme de mimejque hua de noche petzoyutl. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ejqueu nencate nuyejque nemejua. De ca queyöhuac, de melöhuac nennejniese nenyecteque imixtla tlöca, pero de ca tlaijtec nenqepea ume nemoxöyac hua nenquepea meyac tlajtlacule. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’¡Porube de nemejua, tlamachtiöneme hua fariseos, que sa ume nemoxöyac! Pues nenquechejchihua mejcöcoyocme cualtzetzi para inu tlayulepantejque, hua nenqueyejyejcualtlölea inmejcöcoyocua de tli yecteque. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Hua nenquejtoa: “Tlö teyesquiöya ipa inun tunalte de tobiebetcöhua, amo tequenpaliebisquiöne cuöc quenmectejque inu tlayulepantejque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ejqueu mismo sie nemejua nentlatestificöroa encuntra de nemejua mismo, pos nenquejtoa que nencate neninpelhua de inu niecate tli quenmejmectejque tlayulepantejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Nemejua nuyejque nenquecumplirusque lo que tli quenpoloöya nemobiebetcöhua de intlachihuales amo cuale! ");
INSERT INTO nhgNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Cuhuöme! ¡Tlöcaxenöchchcuhuöme! Abele nenmöquisasque pues cuöc Deus nemiechjuscörusque nenyösque miero tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ca inu, xequejtacö, que naja nequentitlane ca nemejua tlayulepantejque, hua tlajmatque, hua tlamachtiöneme. Seque de yejua nenquenmejmectisque hua nenquencoruspelusque, hua seque de yejua nenquenbitequesque ipa nemoteopancucone, hua nenquentepotztocasque, hua cuöc quisasque de sente puieblo nenquentepotztocasque hasta ipa ocsente puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ejqueu nenyesque nentlajtlaculteque de inmequeles de innochtie yecteque tli omejmejque ipan tlöltecpactle, desde imequeles de inu tlöcatl yectec Abel, hasta imequeles de Zacarías, iconie Berequías, öque nenquemectejque entre teopantle hua ajtöl. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","De melöhuac nemiechelfea que noche inu tlajtlacule huölös nemopa nemejua tli öxö nennentecate. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’¡Ay, Jerusalén, Jerusalén, que tequenmejmectea tlayulepantejque hua tequentecaltea tli Deus quentitlanque ca taja! ¡Meyacpa onecnec nequensentlölis tli neme mojtec, quiename sente piyolama quensentlölea ipelhua itzintla iajfetz, cache ayec onenquenejque! ");
INSERT INTO nhgNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Xequejtacö, que Deus ayecmo chöntihuas nemotzölö, cache nemiechcöhualutiehuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Pues nemiechelfea que desde öxö ayecmo nenniechejtasque hasta senamo nenquejtusque: “Ma tetieteochihuacö öque biloatz tietucöyupa Tlöcatzintle”. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Hua oquixoac Jesús de ipan teopantle hua obiloac. Hua omopachojque tiemachtejcöhua, hua tieijtetejque inu calme hua tepönme de teopantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Hua onöhuatihuac yejuatzi, oquemelfejque: ―¿Nenquejta noche ini nönca? De melöhuac nemiechelfea, que amo mocöhuas tietetu ipa tietetu, tlöcamo noche yecxexetunes. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hua yejuatzi onetlöliluc ipa inu nieca tepietl de los Olivos. Omopachojque tietlac tiemachtejcöhua cuöc tiesiel. Otieyelfejque: ―Xetiechmolfele, ¿quiema mochihuas ini nönca sösantle? ¿Tli sieñas oyes cuöc tehualmobicas, hua cuöc tlames tlöltecpactle? ");
INSERT INTO nhgNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Onöhuatihuac Jesús, hua oquemelfejque: ―Xomotlachilicö majcamo öque nemiechcajcayöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pues huölösque meyactie notucöyupa. Quejtusque: “Naja necaca neCristo”. Pos quencajcayöhuasque meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Hua nenquecaquesque de guierras, hua tlapubelis de que oyes guierra. Xequejtacö noso majcamo xomotequepachucö, porque ejqueu quepea que mochihuas. Pero ayemo tlames tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pos majcoques nación cuntra nación, hua igiente de sente rey cuntra igiente de ocsente rey, hua oyes öpestle, hua tlaolines ca nobeyo. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ca ini nönca sösantle piehuas tiecoco tietunie. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Yecuöquenu giente nemiechtiemöctisque ipa tietunie tiecoco, hua nemiechmejmectisque. Hua giente de noche naciones nemiechtlajyelejtasque por nopampa. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yecuöquenu meyactie betzesque ipa tlajtlacule hua ayecmo moneltocasque. Motejtiemöctisque entre yejua, hua motlötlajyelejtasque entre yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Hua huölösque meyactie tli quejtusque que cate tlayulepantejque de Deus mös amo melöhuac, hua quencajcayöhuasque meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Hua momeyaquelis tlajtlacule, hua por inu meyactie ayecmo motlasojtlasque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero öque quexicus hasta ca cöne tlames, yaja inu momöquextis. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hua ini nönca cuale tlamachestelestle de quiene Deus tlamandöruro monunutzas ipa noche tlöltecpactle, hua giente de noche naciones quecaquesque. Yecuöquenu tlames tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’Ejqueu noso nenquejtasque inu tli san petzotec tlaxexetotzas hua moquetzas ipa löcor yectec. Inu tlayulepante Daniel otlajtlajto de inu tli san petzotec. ―Öque quetlajtultea ömatl ma casojcömate.― ");
INSERT INTO nhgNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Cuöquenuju quiejquech yesque ipa Judea ma cholucö hasta ipa tepieme. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Öque iyes icpac cale majcamo temo para quequextiti canajyetla de tli quepea pa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Öque iyes ca caltienco majcamo mocuepa ca ichö para cönati ipelesol. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Ay, porubejte quiejquech tli uutzte hua tli tlajtlabepöjtecate ipa inu niecate tunalte! ");
INSERT INTO nhgNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xomotlajtlötlajticö, noso, que majcamo xecpeacö que nenchojcholusque ipa mietztle cuöc cache siehua nimpor ipan söbron tunale cuöc tosiebea. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pues entunses iyes meyac tietunie, tli ayec omochi desde ca opie tlöltecpactle hasta öxö, nimpor ayecmo quiema mochihuas ocsajpa. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Tlö quejtus inu tiempo amo mochihuane tzitzequetzi, nion sente tlöcatl amo momöquextisquiöne. Pero por impampa yejua tli Deus quemixpejpenque, inu nieca tiempo mochihuas tzitzequetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Cuöquenuju, tlö quejtus canajyeca nemiechelfis: “Xequejtacö, nönca Cristo”, o noso: “Necö oncönca”, amo xomoneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pos majcoquesque Cristos hua tlayulepantejque tli amo de melöhuac. Quechihuasque meyactie sieñas hua tietzöbeme bejbeye, que hasta cöso quencajcayöhuasque giente tli Deus quemixpejpenque tlö cuale quencajcayöhuasquiöne. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xequejtacö, ye nemiechelfea antes de que mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ejqueu, tlö cana nemiechelfisque: “Xequejtacö, Cristo iloac ca ompa cöne nionöque chönte”, amo xequisacö. Tlö nemiechelfea: “Xequejtacö necö iloac ijtec cuörto de nönca cale”, amo xomoneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pues quieme cuöc tlapetlöne ca cöneca quisa tunale hua onniestebetze hasta cöneca calaque tunale, ejqueu nuyejque cuale mojtas ca nobeyo cuöc nehuölös naja öque onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Cöne beletes iyes cuierpo mejque ompa mosentlölisque tzopilume. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Hua nima sötiepa de ini nönca tiecoco tietunie tli oyes ipa inu niecate tunalte, tunale tlajtlayöhuas, hua mietztle ayecmo mietztunas. Sitlalte betzesque de elfecac, hua inu sösantle checöhuac de elfecac muolinisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yecuöquenu nieses sente sieñas: naja öque onochi netlöcatl nenieses ipa elfecac. Entunses chojchucasque giente de noche tribus hua naciones, hua niechejtasque cuöc naja öque onochi netlöcatl nehuölös ipa mextle de elfecac, ca checöhualestle hua meyac tlaniextelestle de coluria. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Hua necualentitlanes noöngeles ca sente bieye tlapitzalestle, hua quensentlölisque noche giente tli naja nequemixpejpe, de ca nobeyo desde cöne ipiejyo elfecac hua tlöltecpactle hasta cöne itlamejyo. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Itech icox cuabetl xectzecucö sente ejiemplo. Cuöc ye selea imömöyo, hua ye itzmoline, nenquemate que ye asequi xupantla. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ejqueu nuyejque nemejua, cuöc nenquejtasque noche ini nönca sösantle, xecmatecö que ye aseco tiempo hua que ye nemotlanca. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Melöhuac nemiechelfea, amo mequesque innochtie giente tli öxö nentecate hasta senamo mochihuas ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Elfecac hua tlöltecpactle tlamesque, cache notlajtul amo tlames. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Cache de inu nieca tunale hua inu ura nionöque amo quemate. Amo quemajmate öngeles de elfecac, nimpor amo quemate tieConietzi, tlöcamo solamiente quematihua Tajtle. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hua quieme oyeya pan tunalte de Noé, ejqueu iyes cuöc nehuölös naja que onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pues ipa inu tunalte antes de inu ötiemelestle, giente tlajtlacuajtaya hua cojconitaya. Mososohuajtejtaya hua monajnömectejtaya. Ejqueu oquechijtaya hasta ipa inun tunale cuöc ocalac Noé ijtec inu börcobiebe itucö örca. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Hua amo omomacaque cuienta hasta senamo ohuöla ötzintle hua oquenbicac innochtie. Ejqueu mismo iyes cuöc nehuölös naja que onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Cuöquenu yesque unte tlöca ipan caltientle. Sente quebicasque sa de repiente, hua ocsente quecöjtiehuasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Unte sohuame testasque ipa sente molino. Sente quebicasque, hua ocsente quecöjtiehuasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Xetlachixtacö noso, porque amo nenquemate tlin tunale hualiloas nemoTlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero xecmatecö ini nönca, que tlö chöne quematene tlin ura ca yohuale huölös ichtejque, tlaixutejtasquea, hua amo quecöhuasquea ma calaque ichtejque ipa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hua por inu, nuyejque nemejua xeyecö listos, porque naja que onochi netlöcatl nehuölös cuöc nemejua amo nenquepensörusque. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’¿Öquenu noso ica tlatequepano tlajmatque hua de confiönsa, que itieco quencargörfe ichö para ma quentlacualte noche giente ipa ura? ");
INSERT INTO nhgNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Cuale icnupel inu nieca tlatequepano, tlö itieco cuöc huölös queniextiqui quechijteca ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Melöhuac nemiechelfea, itieco quetlölis ma tlamandöro ipa noche tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero beles inu nieca tlatequepano amo cualtec iyes, hua quejtus ipa iyulo: “Notieco bejcöbe para huölös”. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Beles piehuas quenmaltratörus ocseque tlatequepanojque, hua tlatlacuös hua conis ca tlöhuöncötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Huölös itieco de inu nieca tlatequepano ipan tunale cuöc yaja amo quechea, hua tlin ura amo quemate. ");
INSERT INTO nhgNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Yecuöquenu quetlajcoteques, hua quetlölis inca tli ume inxöyac. Ompa chojchucasque hua motlantesesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Quiene Deus tlamandörurus ejqueyi iyes. Iyes quiename majtlactle sehuantotu ipa sente nesohuajtiluyo, que cara sente quepeaya sente tlöbile. Yejua oquisque para quenömequeto montle. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hua möcuiltie de yejua oyejyeya tuntojte, hua möcuiltie tlajmatque. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Tli oyejyeya tuntojte ocönque intlöbil, pero amo oquecueque asiete. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero tli tlajmatque oquecueque asiete ijtec potieyacucone nuyejque ca intlöbil. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Hua omochi que obejcö montle, hua ocojcochtaque innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Hua quieme ca tlajco yohuac ocaquestec tzajtzelestle: “¡Xequejtacö biloatz montle! ¡Xequisacö xetienömequete!” ");
INSERT INTO nhgNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Yecuöquenu innochtie inu niecate sehuantotu omiejque, hua oquenxutlaltejque intlöbil. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Hua inu tuntojte oquemelfejque tli tlajmatque: “Xetiechmacacö de nemoasiete, ipampa totlöbil ye sesiebe”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Cache tli tlajmatque onöhuatque, oquejtojque: “Amo nemiechmacasque, amo cana de repiente tiechpolus tejua hua nemejua nuyejque. Xeyöcö cöne monamaca, hua xomocubicö asiete”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Hua mientras yejua uyajque oquecoato, ohuöla montle. Hua tli ye oyejyeya listas ocalajque ca yaja ipa nesohuajtiluyo. Hua omotzac pobielta. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Hua sötiepa ohuölajque nuyejque inu ocseque sehuantotu. Oquejtojque: “Tlöcatzintle, Tlöcatzintle, xetiechmotlaijtlapolfele”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Cache onöhuat yaja, oquejto: “Melöhuac nemiechelfea, amo nemiechixomate”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","’Por inu, nemejua xetlachixtacö, ipampa amo nenquemate tlin tunale hua tlin ura nehuölös. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Pues icaca quiename sente tlöcatl que uya ipa ocsente tlöle. Hua oquennutz itlatequepanojua, hua oquenmötejtie tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Hua sente oquemacac cincuenta mil pieso, hua ocsente oquemacac veinte mil pieso, hua ocsente oquemacac diez mil pieso. Oquenmacac san quiene ca yejua beleteya para quechihuasque negocio. Hua oquis ipa ibiöje. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Hua sa nima öque oqueselec cincuenta mil pieso uya, hua oquetlatlöniltelito, hua oquentlönele impa ocseque cincuenta mil pieso. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hua ejqueu nuyejque öque queselec veinte mil, oquetlö nuyejque yaja ocseque veinte mil. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Cache öque oqueselec sa diez mil, uya hua otlatatacac ipan tlöle, hua ompa oquejyö inu tomi de itieco. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Hua sötiepa de meyac tiempo, ohuöla intieco de inu niecate tlatequepanojque. Oquennutz, hua oquechi cuienta ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hua cuöc oaseco öque oquesele cincuenta mil pieso, oquehualecac ocseque cincuenta mil pieso. Oquejto: “Tlöcatzintle, cincuenta mil pieso teniechmomöctele. Xomojtele necö ocseque cincuenta mil pieso onectlö ica yejua”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hua itieco oquelfe: “Cuale otecchi. Taja teca tecuale tlatequepano hua teca de confiönsa. Teniechmoströrfe que teca de confiönsa ca tli sa nönöjtetzi; öxö temetztlölis para ma xetlamandöro ipa meyac sösantle. Öxö xecpea inu pöquelestle de motieco”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hua cuöc oaseco nuyejque öque ocasec veinte mil pieso, oquejto: “Tlöcatzintle, veinte mil pieso teniechmomöctele. Xomojtele necö ocseque veinte mil pieso onectlö ica yejua”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Itieco oquelfe: “Cuale otecchi. Taja teca tecuale tlatequepano hua teca de confiönsa. Teniechmoströrfe que teca de confiönsa ca tli sa nönöjtetzi. Öxö temetztlölis para ma xetlamandöro ipa meyac sösantle. Öxö xecpea inu pöquelestle de motieco”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Hua cuöc oaseco nuyejque öque queselec sa diez mil pieso, oquejto: “Tlöcatzintle, temetzmixomachele que tejuatzi tomobetzteca tetlöcatl que amo temetzmotlöocoltelea, hua que tomocuejcuelea tli amo tomotlapexquele, hua tomotlapexquelea cöne amo tomotlatuquele. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ejqueu onomajte, hua oneya, hua onequejyö inu diez mil pieso ijtec tlöle. Öxö necönca tli mohuöxcatzi”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pero onöhuat itieco, oquelfe: “Amo cuale moyulo hua tetlatzejque lalebes. Amo tecuale tlatequepano. Tecmajtaya que nejcuejcue cöne amo nepexcac hua que nepexca cöne amo onetlatucac. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Por inu conbenierebeya siquiera tectiemacas notomi inca giente ipa bönco. Pues ejqueu cuöc onehuöla naja, necönane tli nohuöxca siquiera ca tli ye otequet”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Hua oquemelfe itlatequepanojua: “Xejcuejcuelicö noso inu diez mil pieso, hua xecmacacö öque quepea cien mil pieso. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ipampa öque quepea, quemacasque, hua quepeas cache lalebes meyac. Cache öque amo quepea, quecuejcuelisque hasta inu tepetzi tli oc quepea. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Hua inu tli amo cuale tlatequepano, xectlajcalicö ca queyöhuac pa tlajtlayohuaquelestle. Ompa chojchucasque hua motlantesesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Hua cuöc naja que onochi netlöcatl nehuölös ca notlaniexteles, ca tiehua noche öngeles, yecuöquenu notlölis ipa notrono. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Hua nixtla mosentlölisque noche naciones hua nequennencuaxelus de intzölö de yejua, quieme calnielojpexque quennencuaxeloa calnielojte ca quieme hua chibojte ca ocsie löro. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Hua calnielojte quentlölis ca möyecömpa, hua chibojte ca rabiescopa. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yecuöquenu inu rey quemelfis tli yesque ca möyecömpa: “Xehuölöcö, nemejua tli nemiechteochihualo noTajtzi. Xomohuöxcaticö ini nönca reino tli ye moyecchijteca para nemejua desde cuöc omochejchi tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ipampa cuöc naja neteosebeya, nenniechtlamacaque. Cuöc noömequeya, nenniechötliltejque. Amo necpeaya cöne neyes, hua nenniechcalutejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Niechpoloöya notlaquie, hua nenniechtlaquentejque. Nococoöya, hua nenniechtlajpaluto. Oneyeya ipan cörsel, hua nenniechejtato”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yecuöquenu inu yecteque nöhuatesque, quejtusque: “Tlöcatzintle, ¿quiema temetzmojtelejque tomoteosebitiöya, hua temetzmotlamaquelejque? O noso ¿quiema tomoömequitejtenemeya hua temetzmoötliltelejque? ");
INSERT INTO nhgNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Hua ¿quiema amo tomopeliöya cöne tomobetztasquea, hua temetzmocalutelejque? O noso ¿quiema metzmopolfiöya motlaquientzi. hua temetzmotlaquentelejque? ");
INSERT INTO nhgNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","O noso ¿quiema tomococojtzinoöya, o noso tomobetztaya ipan cörsel, hua otemetzmojtelito?” ");
INSERT INTO nhgNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Hua nöhuates rey, hua quemelfis: “Melöhuac nemiechelfea que cuöc nenquechibelejque ejqueu sente de ini nöncate nocnihua, mös tzitzequetzi, naja nenniechchibelejque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Yecuöquenu quemelfis nuyejque tli yesque ca irabiescopa: “Xomonencuaxelucö de naja, tlabejbicalteme. Xeyöcö ijtec tletzintle tli xutlateca nochepa tli tlachejchijtle para Diöblo hua para iöngeles. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ipampa cuöc neteosebeya, amo nenniechtlamacaque. Cuöc noömequeya, amo nenniechötliltejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Amo necpeaya cöne neyas, pero amo nenniechcalutejque. Oniechpoloöya notlaquie, pero amo nenniechtlaquentejque. Onococoöya, hua neyeya ipan cörsel, hua amo nenniechtlajpaluto”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yecuöquenu yejua quenönquelisque, quejtusque: “Tlöcatzintle, ¿quiema temetzmojtelejque temoöpesmequitejtenemeya, noso tomoömequitejtenemeya, noso amo tomopiliöya cöne tomobetztasquea, noso metzmopolfiöya motlaquientzi, noso tomococojtzino, noso tomobetztaya ipan cörsel, hua amo temetzmotequepanelfejque?”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yecuöquenu quennönquelis, quejtus: “Melöhuac nemiechelfea que cuöc amo nenquechijque ca sente de ini nöncate tzequetzetzi, naja amo nenniechchibelejque”. ");
INSERT INTO nhgNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Hua inu niecate yösque para mocastecörusque nochepa, hua tli yecteque calaquesque cöne nemesque nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Hua omochi que cuöc otlamoac Jesús de noche ini nöncate tlajtulme, oquemelfejque tiemachtejcöhua: ");
INSERT INTO nhgNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ye nenquemate que sötiepa de ume tunale mochihua pöscua yelfetl, hua naja tli onochi netlöcatl niechtiemöctisque para ma niechcoruspelucö. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Yecuöquenu jefes de teopexcötzetzi hua biebentzetzi de inu puieblo omosentlölejque ipan pötio de palacio de tlajtojcöteopexque, öque itucö Caifás. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Hua omotlajtulmacaque para tieasesque Jesús ca möñas hua tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Hua quejtoöya: ―Amo tecasesque Jesús ipa yelfetl, para majcamo chöchalönecö giente. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Hua Jesús iloaya ipa puieblo de Betania ipa ichö Semu öque sa söhuayo oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ohuöla tietlac sente sohuatl. Quehualecaya sente potixajconetzi de alabastro tli quepeaya pajtle ajfeyoc tli lalebes pateyo. Oquemejmelo pajtle ipa tietzonteco yejuatzi mientras tlacualutaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cuöc oquejtaque tiemachtejcöhua, ocuajcualönque. Oquejtojque: ―¿Tli para niempolebe ini nönca? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Pues cuale monamacasquea ica pateyo, hua cuale moxiexeloöne ca tli porubejte. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero Jesús nemacuc cuienta de tli quejtojque, hua oquemelfejque: ―¿Tlica nenquepasoloa ini nönca sohuatl? Ara ca cuale tli niechchibelico. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nochepa nenquenpea tli porubejte nemotzölö, cache naja amo nochepa nenniechpeasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Hua tlö quetlölele inu pajtle ajfeyoc ipa nocuierpo, pos oquechi para cuöc notlölpachus. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Melöhuac nemiechelfea, que cöne beletes tlanunutzasque de ini nönca cuale tlamachestelestle ipa noche tlöltecpactle, nuyejque ini nönca lo que tli oquechi ini sohuatl mojtus, para que giente quelnömequesque de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Entunses sente de inu majtlactle huan ume tiemachtejcöhua, que itucö Judas Iscariote, uya inca jefes de teopexcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Hua oquemelfe: ―¿Tli nenqueneque nenniechmacasque, hua naja nectiemacas ca nemejua? Hua yejua quepesörfejque treinta monedas de plöta. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Hua desde cuöquenu quetiemoöya quiene ca tieantrecöruti. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Hua ipa primiero tunale de yelfetl de pöntzi sin levadura, ohuölajque tiemachtejcöhua tieca Jesús. Otieyelfejque: ―¿Cöne tomonequitea ma tetlapreparörucö para tomocualtis inu tlacuale de pöscua? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Hua oquejtojque: ―Xeyöcö ipa puieblo ica sente tlöcatl tli ompa nenqueniextisque, hua xequelficö: “Maestro quejtulo: Ye aseco noura. Ipa mochö necchihuas inu pöscua yelfetl ca tiehua nomachtejcöhua”. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Hua tiemachtejcöhua oquechijque quiene Jesús oquennahuatejque, hua otlapreparörojque para pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hua cuöc ye oyeya ca ye yohuac, yehualutaya itlac miesa inca inu majtlactle huan ume tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Hua cuöc ye tlajtlacualutaya, oquejtojque: ―Melöhuac nemiechelfea que sente de nemejua niechantrecöruti. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yecuöquenu yejua ocaseque meyac tequepachule, hua opiejque tieyelfiöya cara sesen tlöcatl: ―¿Beles naja, Tlöcatzintle? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yejuatzi onöhuatihuac, oquemelfejque: ―Öque quecalaquis imö ca naja ijtec nocasfiela, yaja inu niechantrecörus. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Naja que onochi netlöcatl nemeques, san quiene ca tlajcuelulpanca de naja. Pero, ¡porube de inu tlöcatl tli niechantrecörus naja que onochi netlöcatl! Cache cuale uyesquea para yaja ma ayec tlöcatene. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yecuöquenu onöhuat Judas, öque tieantrecörusquea. Oquejto: ―¿Beles naja, noTiemachtejcötzi? Oquelfejque: ―Taja ye tequejto. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mientras tlajtlacualutaya, ocönque Jesús inu pöntzi hua oqueteochijque. Oquecojcotunque, hua oquenmacaque tiemachtejcöhua. Hua oquejtojque: ―Xecönacö, xejcuöcö. Nönca pöntzi ica nocuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Yecuöquenu ocönque sente bölso, hua tietlasojcömacheliluc. Oquenmacaque, oquejtojque: ―Xeconicö de ini nönca nemonochtie. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Pues yaja ini *icaca noyeso. Nectiemaca para ma mochihua sente acuierdo entre Deus hua tlöca. Nocuierpo yesquisas impampa meyactie tlöca para ma moperdonöro intlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero nemiechelfea, que desde öxö ayecmo neconis iöyo de uvas hasta ipa inu nieca tunale cuöc ca tiehua nemejua neconis inu vino yancuec tli onca cöne tlamandöruruteca noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hua ocuejcuicoac sente cuicatelestle, hua oquejquixoatie bejbiloac ipa tepietl de los Olivos. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yecuöquenu oquemelfejque Jesús: ―Noche nemejua nenbetzesque ipa tlajtlacule por nopampa ipa ini nönca yöhuale. Pos tlajcuelulpanca: Necmectis calnielojpexque, hua inu calnielojte tli quemixutea mocuasemanasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero sötiepa cuöc naja neyulebes, neyös delönte de nemejua hasta pa estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Yecuöquenu onöhuat Piero, otieyelfe: ―Mös cana noche ocseque betzesque ipa tlajtlacule por mopampantzinco, pero naja ayec nebetzes. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Oquelfejque Jesús: ―Melöhuac temetzelfea que ipa nönca yohuale, antes tzajtzes canteliex, taja yexpa tequejtus que amo teniechixomate. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Otieyelfe Piero: ―Mösque quejtus nemeques ca tejuatzi, pero amo temetzmonegörfis. Hua innochtie tiemachtejcöhua nuyejque oquejtoöya ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yecuöquenu hualiloac Jesús ca tiehua tiemachtejcöhua ipa locör itucö Getsemaní. Hua oquemelfejque: ―Xomotlölicö necö, mientras naja ma nebeya notlajtlötlajtite niepa. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Hua oquenbicaque Piero, ca tiehua inu unte ipelhua Zebedeo. Opiehualuc netequepachuluc, hua lalebes quiene oquechi tieyulo. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Yecuöquenu oquemelfejque: ―Lalebes meyac tequepachule quepea noölma, hasta sana nemequesneque. Xomocöhuacö necö, hua xetlachixtacö ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Entunses obiloac cache adelönte. Onepechtiecaluc hasta tlölpa, hua onetlajtlötlajtiluc. Oquejtojque: ―NoTajtzi, tlö quejtus cuale mochihuas, majcamo necpea que neconis ini nönca bolso de tietunie. Cache majcamo mochihua quiename naja necneque, tlöcamo quiename tejuatzi tomonequitea. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hua ohualbiloac intlac tiemachtejcöhua, hua oquenniextiluco cojcochtaya. Quelfejque Piero: ―¿Quie abele nentlachixtaque ca naja nion sie ura? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xetlachixtacö hua xomotlötlajticö, para amo nemiechyulmötocas Amo Cuale Tlöcatl. Melöhuac toyulo cuejcuesebe, cache tonacayo débil icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ocsajpa biloac, ca ujpa, hua onetlötlajtiluc. Oquejtojque: ―NoTajtzi, tlö abele iyös nönca tietunie sin que naja nepanus por yaja, pues ma mochihua tli motlanequelestzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Cuöc ohualiloac ocsajpa, oquenniextiluco cojcochtecate, porque lalebes cojcochesnequeya. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Hua oquencöjtiejque hua biloac ocsajpa onetlötlajtiluto ca yexpa. Ocsajpa oquejtojque mismo tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yecuöquenu ohualiloac intlac tiemachtejcöhua, hua oquemelfejque: ―Bieno. Pues a öxö xecojcochecö, hua xomosiebicö. Xequejtacö ye aseteca ura. Naja que onochi netlöcatl öxö niechantrecörusque inmöpa tlajtlaculteque tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Xemiehuacö hua teyabe. Ye ompabitz öque niechantrecörus. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Hua cuöc yejuatzi oc tlajtlajtulutaya, ye aseco Judas, sente de inu majtlactle huan ume tiemachtejcöhua. Ohuöla, hua ca yaja ohuölajque meyac tlöca ca espödas hua ca cuabetl. Huölajque porque jefes de teopexcötzetzi hua biebentzetzi de puieblo cualentitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Antes que Judas tieantrecörus, quemelfe inu tlöca de sente sieñas. Oquejto: ―Öque naja necpetzus, yaja inu icaca. Xecasecö. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Hua omopacho tietlac Jesús. Oquejto: ―Ma cuale xomobetzta, noTiemachtejcötzi. Hua otiepetzo. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Hua Jesús oquelfejque: ―Amigo, ¿tli para tebitz? ¿Para tecchihuas ini nönca? Yecuöquenu omopachojque, hua tieaseque Jesús, hua tiebicaque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero sente de tli oyejyeya tieca Jesús omösu hua oquequexte iespöda. Conmacac sente itlatequepano de tlajtojcöteopexque. Pos quetejtequele inacas. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yecuöquenu Jesús oquelfejque: ―Xejcuepa moespöda ipa ifunda. Pos tli case espöda para momagasque, ca espöda mejmequesque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Quie beles amo tomomaca cuienta que mös niechquitzquejtecate nönca giente cuale notlötlajtis tieca noTajtzi, hua yejuatzi niechmacasque cache de majtlactle huan ume ejércitos de öngeles para ma niechpaliebicö? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tlö ejqueu necchihuane, ¿quiene noso mochihuasquea lo que tli tlajcuelulpanca ipan teotlajtule, que ejqueyi quepea que mochihuas? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Entunses Jesús oquemelfejque giente: ―¿Nenhualiejque ca espödas hua ca cuabetl quieme cana cuntra sente ichtejque para nenniechasesque? Cara tunale notlöliöya nemiechmachtiöya ipan teopantle. Pos amo nenniechaseque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero noche ini mochijteca para ma mochihua tli inu tlayulepantejque oquejcuelojque ipa teotlajtule. Yecuöquenu noche tiemachtejcöhua tiecöjtiejque. Ochucholojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Hua inu giente tli tieaseque Jesús tiebicaque itlac tlajtojcöteopexque itucö Caifás. Pa ichö mosentlölejque tlamachtiöneme de teotlajtule hua biebentzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Cache Piero tietocaya bejcateca hasta cöne pötio de ichö de tlajtojcöteopexque. Hua ocalac ca tlaijtec, hua ompa omotlöle ca yejua de guardia, para quejtas quiene ca tlames inu asunto. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hua inu jefes de teopexcötzetzi, ca tiehua noche inu junta, quetiemoöya maniera de tietieyelfisque Jesús mös iyes por istlacatlajtule, hua ejqueu tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero amo yetla queniextiöya, mös meyactie hualaseya hua istacatlajtoöya. Pero sötiepa ohuölajque unte tlöca ");
INSERT INTO nhgNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","que oquejtojque: ―Ini nönca tlöcatl oquejto: “Cuale necxexetunis tieteupa Deus, hua ipa yeye tunale ocsajpa necajcoques”. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Entunses omoquetztequis tlajtojcöteopexque. Otieyelfe: ―Pos ¿amo yetla tenöhuates? ¿Tlin inu noso quemelöjcöpujtecate de taja? ");
INSERT INTO nhgNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero Jesús sa quetzacualoöya tiecamac. Tlajtojcöteopexque otieyelfe: ―Naja temetznahuatea tietucöyupantzinco Deus öque nemoa, xetiechelfe tlö taja tecaca teCristo, tieConie Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús oquelfejque: ―Ica melöhuac tli tequejto. Hua öxö nemiechelfea, que sötiepa de öxö nenquejtasque que naja öque onochi netlöcatl neyehuatas ca tiemöyecmö de Deus öque quepealo checöhualestle. Naja que onochi netlöcatl nehuölös de elfecac ipa mextle. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yecuöquenu tlajtojcöteopexque oquetzotzomotz itzotzomajua. Oquejto: ―Ye ochecuatlajto cuntra Deus. ¿Tli para cache tecneque öque tiechmelöjcöpubelis? Öxö necö ye onenquecajque quiene checuatlajtoa cuntra Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tlin nenquejtoa? Hua onöhuatque yejua, oquejtojque: ―Quemeresieroa ma meque. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yecuöquenu ochejchaque ipa tiexöyac, hua tiemacaque checöhuac, hua ocseque tiecamatlajtlatzcuepuniöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Quejejtoöya: ―Xetiechyulepante, ya que taja teCristo. Xetiechelfe öquenu ometzmacac. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hua Piero oyeya ca queyöhuac pan pötio. Hua omopacho itlac sente sohuatl tlatequepano. Oquejto: ―Taja nuyejque oteyeya ca Jesús inu galileo. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero yaja oquenegöro imixtla innochtie. Oquejto: ―Amo necmate tli tequejtoa. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Hua cuöc yaja oquis ca ipan pobielta, ocsente sohuatl oquejtac, hua oquemelfe tli ompa oyejyeya: ―Ini nönca tlöcatl oyeya itlac Jesús de puieblo de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Hua ocsajpa oquenegöro ca juramento. Oquejto: ―Amo nequixomate inu tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hua oc tepetzi sötiepa oaseco tli ca niepa oyejyeya, hua oquelfejque Piero: ―De melöhuac taja nuyejque tecaca de yejua, ipampa hasta ipa motlajtul teniese. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yecuöquenu opie yaja motlabejbicalteya ica sie yaja. Oquejtoöya: ―¡Paltzinco! Amo nequixomate inu tlöcatl. Hua sa nima otzajtzec canteliex. ");
INSERT INTO nhgNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Entunses Piero oquelnömec inu tlajtule de Jesús, que oquelfejque: “Antes tzajtzes canteliex yexpa tequejtus que amo teniechixomate”. Hua oquis ca queyöhuac, hua ochucac lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Hua cuöc ye ca ise cualco, noche jefes de teopexcötzetzi, ca tiehua biebentzetzi de puieblo, quetzontejque entre yejua quiene tiechibelisque Jesús para cuale tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Hua otieijilpejque hua otiebicaque otieantrecöruto ica Pilöto, öque oyeya cubernadur. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yecuöquenu Judas, öque ye tieantrecöro Jesús ca tieenemigos, oquejtac que ye tiecuntenörojque. Omoyulcuec de lo que tli oquechi, hua oquecuepato inu treinta monedas de plöta inca jefes de teopexcötzetzi hua biebentzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Oquejto: ―Naja ye onetlajtlaco onetieantrecöro para mecoas öque amo tlajtlacultec iloac. Cache yejua oquejtojque: ―¿Tli tiechtequepachoa tejua? Metztocöroa taja tequejtas. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Hua oquetlölmutlac inu tomi hasta ijtec teopantle, hua oquis de ompau. Hua uya omocucupötzmectito. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hua inu jefes de teopexcötzetzi ocönque inu tomi. Oquejtojque: ―Amo cuale tectlölisque ini tomi itzölö tomi de nönca teopantle, ipampa ica ipati de iyeso de sente tlöcatl tli meques. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Hua cuöc ye omotlajtulmacaque, oquecujque ca inu tomi sente tlöle de casfielajtiero, para ompa motlölpachusque inmimejcöhua de estranjieros. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ipampaju omocuite inu nieca tlöle, Tlöle de Yestle. Hua ejqueu mocuitea hasta ipa ini nönca tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ejqueu omochi lo que tli omojto por icamacopa tlayulepante Jeremías, cuöc oquejto: “Hua ocaseque inu treinta monedas de plöta, ipati de inu tlöcatl tli seque de inu israelitas quetlölejque inu precio. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Hua oquetiemacaque inu tomi para oquecujque tlöle de casfielajtiero, san quiene oniechmandöro Tlöcatzintle”. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Hua Jesús iloaya ixtla cubernadur. Hua cubernadur tietlajtlane, otieyelfe: ―¿Taja terey de joriojte? Hua Jesús oquelfejque: ―Ica melöhuac tli tequejtojteca. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Hua cuöc jefes de teopexcötzetzi hua biebentzetzi tietieyelfiöya, amo nöhuatihuaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Yecuöquenu Pilöto otieyelfe: ―¿Amo tejcaque que meyac sösantle quejtoa encuntra de taja? ");
INSERT INTO nhgNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús amo quenönquelejque nion sie tlajtule. Así es que inu cubernadur quetietzöbejtaya lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Hua ipa inun tunale de yelfetl, inu cubernadur quepeaya costumbre de que quecajcöhuaya sente prieso tli yejua quenequeya mocajcöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Hua cuöquenu ompa quepeaya sente prieso tzactaya lalebes motieniehuaya. Itucö oyeya Jesús Barrabás. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Hua cuöc ye mosentlölejque meyac giente, oquemelfe Pilöto: ―¿Öquenu nenqueneque ma nejcajcöhua ca nemejua? ¿Yaja *Jesús Barrabás, o noso yaja Jesús öque giente quecuitea Cristo? ");
INSERT INTO nhgNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pos yaja quemateya que por envidia tieantrecörojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Hua cuöc yaja oyehuataya ipa imiesa de tlajtojcötelestle, isohua oquetlatitlanele sente mensöje. Oquelfe: “Amo xomopile tli tomojtelis ca inu tlöcatl yectec. Porque öxö meyac tiecoco nopa omochi ipa nocochtiemequeles por tiepampa yejuatzi”. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Cache inu jefes de teopexcötzetzi ca tiehua biebentzetzi oquentlajtulmacaque giente para ma tlajtlanecö yaja Barrabás, hua ma tiemecticö Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yecuöquenu onöhuat cubernadur, oquemelfe: ―¿Cötlaja de innehua nenqueneque ma nejcajcöhua? Hua yejua oquejtojque: ―Yaja Barrabás. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilöto oquemelfe: ―¿Tli noso necchibelis inu Jesús öque giente quecuitea Cristo? Oquelfejque innochtie: ―Ma mocoruspelo. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Hua yaja oquejto: ―¿Tlica? ¿Tli mal oquechi? Cache yejua cache tzajtzajtzeya lalebes. Quejejtoöya: ―¡Ma mocoruspelo! ");
INSERT INTO nhgNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Hua cuöc oquejtac Pilöto que abele tli quechihuaya, antes cache yejua chöchalöneya, oquecuec ötzintle hua omomöpajpöc imixtla de inu giente. Oquejto: ―Amo tli tlajtlacule necpea naja de imequeles de ini nönca tlöcatl. Nemejua nemiechtocörus nenquejtasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Hua onöhuat noche puieblo, oquejtojque: ―Inu tlajtlacule por imequeles ma topa betze, hua impa topejpelhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yecuöquenu oquencajcöbele yaja Barrabás. Hua oquemandörojque ma tiebitequecö Jesús, hua otieantrecöro para ma tiecoruspelucö. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Yecuöquenu soltörojte de cubernadur otiebicaque Jesús ipa pretorio noso palacio. Omosentlölejque ca yejuatzi innochtie soltörojte. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Hua tiexipetzojque, hua tietlölelejque sente tlaquentle chichiltec, quiename möquea reyes. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Quechejchijque sente coruna de betztle, oquetlölejque ipa tietzonteco. Sente uhuatl otiemöpiqueltejque ipa tiemöyecmö, quiename inu tlacutl tli cusöroa reyes cuöc tlamandöroa. Tieixtla motlancuöquetzaya. Tieca bejbiebetzcaya, quejejtoöya: ―¡Xeneme, Rey de joriojte! ");
INSERT INTO nhgNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Hua ochejchaque tiepa, hua ocaseque inu uhuatl, hua ica tiemacaya ipa tietzonteco. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Hua sötiepa de cuöc ye tieca opajpöjque, tiequextelejque inu tlaquentle. Entunses tietlaquentejque ca tietzotzomajua. Yecuöquenu tiebicaque para tiecoruspelutibe. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Hua cuöc oquisque, oquenömejque sente tlöcatl de inu nación que itucö Cirene, hua itucöyu de inu tlöcatl oyeya Semu. Yaja inu nieca oquechihualtejque ma quebica tiecorujtzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Hua oaseto ipa sente locör que itucö Gólgota. Quejtusneque Locör de Mejcötzontecomatl. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tiemacaque vino tli quenelultejque ca ichecheca ma conihua. Cache cuöc oquematque, amo oconihuac. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Hua sötiepa de cuöc ye tiecoruspelojque, oquexiexelojque tietlaquie, hua queriförojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Hua ompa omotlölejque tieixutejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Hua oquetlölejque ipan corujtzi ipa tiecuötecpac ini nönca tlajtule oquejtojtaya tli ipampa tiecoruspelojque: “YAJA INI NÖNCA JESÚS INU REY DE JORIOJTE”. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Hua quencoruspelojque nuyejque tiehua yejuatzi unte ichtejque, sente ca möyecömpa, hua ocsente ca rabiescopa. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Hua tli pajpanutöya, tiechecuaelfiöya. Mocuajcuayecachoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tieyelfiöya: ―¡Taja! Taja tequejto que tecxexetunis teopantle, hua ipa yeye tunale ocsajpa tecajcoques. Abier xomomöquexte sie taja. Tlö tecaca tetieConietzi Deus, xetemo de ipan corujtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pos ejqueu nuyejque inu jefes de teopexcötzetzi tieca opajpöjque. Molfiöya ca tiehua tlamachtiöneme de teotlajtule hua fariseos ca tiehua biebentzetzi, quejejtoöya: ");
INSERT INTO nhgNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ocseque quenmöquexte, pero sie yaja abele momöquextea. Nele yaja icaca Rey de Israel. Pues ma temo öxö de ipan corujtzi, hua toneltocasque ica yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nele moneltoca ca Deus. Deus ma quemöquexticö öxö tlö quetlasojtlalo. Pues yaja oquejto: “Naja necaca netieConie Deus”. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nuyejque ejqueu tlimach tieyelfiöya inu ichtejque tli cojcoruspelcataya ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hua desde ca pan tlajca otlayohuac ipa noche tlöltecpactle hasta senamo quemacac yeye ura. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Quieme ca pa yeye ura, otzajtzihuac Jesús checöhuac. Oquejtojque: ―Elí, Elí, ¿lama sabactani? ―Quejtusneque: NoTeotzi, noTeotzi, ¿tlica tomoxelojtzino de naja? ");
INSERT INTO nhgNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cuöc oquecajque seque tli ompa ijcataya, quejtoöya: ―Ini nönca tlöcatl quenutza inu tlayulepante Elías. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Hua sa nima omomerö sente de yejua. Ucö sente sunectle hua oquepaltele ica pinögre. Oquetlöle ipa sente öcatl tiemacac ma conihua. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Hua inu ocseque quejtoöya: ―Xejcajcöhua, ma tequejtacö abier tlö yebitz Elías quemöquextiqui. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero Jesús ocsajpa tzajtzihuac checöhuac hua omecoac. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hua necö inu cortina de teopantle otzomu. Opie desde tlacpac hasta ca tlölpa. Hua ontlaole, hua teme otlajtlapönque. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Omotlapojque mejcöcoyocme, hua meyactie mimejque tli yecteque omiejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Hua sötiepa de cuöc ye oyulebihuac Jesús oquisque de ijtec mejcöcoyocme. Ohuölajque ipa inu ciudad yectec, que yaja Jerusalén. Ompa oquemejtaque meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Inu capetö, hua tli oyejyeya ca yaja tieixutejtaya Jesús, cuöc oquejtaque tlaolinelestle, hua noche sösantle tli omochi, omomajtejque lalebes. Oquejtojque: ―De melöhuac ini nönca tlöcatl iloaya tieConie Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hua ompa oyejyeya meyactie sohuame tlajtlachixtaya bejcateca. Ini nöncate otiehualtocaque Jesús desde estado de Galilea, tiehualtequepanojtöya. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Intzölö oyeya yaja María de puieblo de Magdala, hua María innöntzi de Jacobo hua Josie, ca tiehua innöntzi de ipelhua Zebedeo. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Hua cuöc ye omochi ca ye yohuac, ohuöla sente tlöcatl rico de puieblo de Arimatea, itucö Josie. Ini nönca nuyejque oyeya de tiemachtejcöhua de Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ocalac itlac Pilöto quetlajtlanito tiecuierpo Jesús. Entunses Pilöto otlamandöro ma quemacacö inu cuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Hua Josie ucö inu cuierpo, oquequemelo ica sente tzotzomajtle de lino chepöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Hua quepeaya sente mejcöustutl yancuec, tli omotatac itech sente tepetlatl. Ompa oquetlöle tiecuierpo Jesús. Oquememelo sente bieye tietetu hua ica quetlapacho inu ustutl. Entunses yaja uya. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Hua ompa oyeya María de puieblo de Magdala, ca tiehua ocsente María. Ompa oyejyehuataya ixtla mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Hua ipa mustlateca iyes tunale sötiepa de cuöc mopreparöroöya para mosiebisque ipan söbro. Omosentlölejque jefes de teopexcötzetzi ca tiehua fariseos ica Pilöto. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Oquelfejque Pilöto: ―Señor, otequelnömejque que inu nieca tlacajcayöhuane oquejto, cuöc yaja oc nemeya: “Sötiepa de yeye tunale neyulebes”. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Xomotlamandörfe, noso, ma mixute inu mejcöustutl hasta ipa yeye tunale, majcamo cana iye que huölösque imachtejcöhua, hua quechtequesque, hua quelfisque puieblo: “Ye oyule de intzölö mimejque”. Pos tlöjcu sötiepa cache amo cuale istlacatlajtule iyes que cuöc ca opie. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Hua Pilöto oquemelfe: ―Xecpeacö guardias. Xeyöcö hua xequixuticö quiename nemejua nenquemate. ");
INSERT INTO nhgNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pues yejua uyajque ipa inu mejcöustutl, hua quetzajtzajque hua queseyörojque, hua oquencöjtiejque guardias. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hua opanuc inu yohuale de söbro, hua ye miero tlanieseya para inu primiero tunale de semöna. Ca ise cualcö ohuöla María de puieblo de Magdala, ca tiehua inu ocsente María, oquejtaco inu mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Hua sa trepiente ontlaole lalebes checöhuac. Pues sente öngel de Tlöcatzintle hualtemuc de elfecac hua oquecuec inu tietetu, hua omotlöle ipa. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nieseya ixöyac quiename cuöc tlapetlöne, hua itlaquie oyeya istöc quiename tesebetl. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Inu tlajpexque lalebes oquemajcöejtaque, hua omocöjque quiename mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Hua inu öngel oquemelfe sohuame: ―Amo xomomajticö, pues naja necmajteca que nentietiemoa Jesús, öque tiecoruspelojque. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Amo oncö iloac necö; pues ye oyulebihuac, quieme oquejtojque. Xehuölöcö, xequejtacö necö locör cöne betzihuataya. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Entunses xeyöcö sa nima, xequemelficö tiemachtejcöhua que ye oyulebihuac de intzölö mimejque. Hua yejuatzi biloas cachto que nemejua pa Galilea. Ompa nentieyejtasque. Xomofijörucö cuale de lo que tli onemiechelfe. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Hua yejua onyajque de ompa mejcöcoyoctle. Momajtiöya pero nuyejque pajpöqueya lalebes. Omomiemeröjque oquenmachestito tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Hua necö Jesús oquennömequihuato. Oquejtojque: ―Ma cuale xeyecö. Hua yejua omopachojque hua tienöhuajtejque ipa tieicxehua, hua tieteochijque. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yecuöquenu Jesús oquemelfejque: ―Amo xomomajticö. Xeyöcö, xequenmachesticö nocnihua, para ma yöcö ipan Galilea. Ompa niechejtasque. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hua cuöc uyajque yejua, necö seque de inu tlajpexque tli quexutiöya mejcöustutl ohuölajque ipa ciudad, hua oquenmachestejque jefes de teopexcötzetzi de noche sösantle tli omochi. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hua yejua omosentlölejque ca tiehua biebentzetzi, hua omotlajtulmacaque. Entunses oquenmacaque meyac tomi inu soltörojte. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Oquejtojque: ―Xequejtucö nemejua ejqueyi: “Imachtejcöhua ohuölajque ca yohuale, hua oquechtejque mientras tejua tecojcochtaya”. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Hua tlö ini quemates cubernadur, tejua tecyulsiebisque, para ejqueu amo nemiechpasörus niontle. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ca inu, yejua ocönque inu tomi, hua oquechijque san quiene ca oquentlajtulmacaque. Ejqueu ini nönca tlajtule omacheac intzölö joriojte, hua hasta öxö oc turavea quepoa ini cuiento. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pero inu majtlactle huansie tiemachtejcöhua uyajque ca Galilea, ipa inu nieca tepietl cöne Jesús oquennahuatejque. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Hua ompa otieijtaque. Entunses tieteochijque. Pero seque amo bel moneltocaya. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hua onaxihuato Jesús, oquennunutzque. Oquejtojque: ―Noche checöhualestle ye oniechmacaque ompa elfecac hua ipan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Por inu, xeyöcö, hua xequemixtlamachticö giente de noche naciones para ma yecö nomachtejcöhua. Xequencuötiequicö tietucöyupa Tajtle, hua de tieConietzi, hua de Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Xequenmachticö ma quechihuacö noche sösantle tli ye onetlanahuate. Hua naja necaca ca nemejua nochepan tunalte. Hasta ipan tunale cuöc tlames tlöltecpactle naja neyes ca nemejua.");
INSERT INTO nhgNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ejqueyi opie cuale tlamachestelestle de Jesucristo, tieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pos tlajcuelulpanca ipan ömatl tli oquejcuelo inu tlayulepante Isaías: Xequejta. Naja nectitlanes notlatitlantle ma cachto beya que taja para ma quixmana moojfe. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Caquestec tlajtule de yeca tli tzajtzec ompa cöne nionöque chönte, hua quejtoöya: “Xecyejyectlölicö tieojfe Tlöcatzintle. Xecmelöhuacö tieojfe, pues ye miero axihuaqui”. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xohuö tlacuötiequiöya ipa locör cöne nionöque chönteya. Tlanunutzaya nele tlö giente moyulcuepasque para ma Deus ma quentlapojpolfelicö intlajtlacul yaja cuale quencuötiequis. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Noche tlöca de estado de Judea hua noche de ciudad de Jerusalén quisaya ca itlac yaja. Mocuötiequiöya ca yaja ipan ötlactle itucö Jordán. Moyulcuitiöya ca Deus de intlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pos Xohuö motlaquentiöya ca tzotzomajtle de itojmeyo camello, hua ca sente cuetlaxpöxajtle ca motlajcoilpiöya. Quecuöya chapolte hua nectle de cormienajte de caltienco. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tlanunutzaya hua quejtoöya: ―Biloatz ocsie tlöcatl sötiepa de naja öque cache quepealo meyac checöhualestle que naja. Amo necmeresieroa nion para nopiechus para netiequextelis tiecacua. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Naja de melöhuac onemiechcuötieque ca ötzintle, pero yejuatzi nemiechcuötiequisque ca Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Omochi ipa niecate tunalte que Jesús hualiloac de puieblo itucö Nazaret de estado de Galilea, hua Xohuö tiecuötieque ipa ötlactle Jordán. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Cuöc oquixoac de ötzintle, sa nima oquejtaque quiene ca hualmotlapo elfecac, hua quiene ca otemoac Espíritu de Deus quiename palumax tiepa yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Pos ohuöla sente tlajtule de elfecac: ―Taja tenotlasojcöConie. Ica taja necpea meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nima Espíritu de Deus tiechihualtiluc ma biloa ipa locör cöne nionöque chönteya. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ompa iloaya cuarenta días ipa inu locör, hua tieyulmajmötocaya Satanás. Pos ompa iloaya inca yulcöme tiecuöneme, hua öngeles tietequepanoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cuöc ye oquetzajtzajque Xohuö, Jesús hualiloac ipa estado de Galilea. Hualtlanunutzalutöya de cuale tlamachestelestle tli tiechelfea de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Oquejtojque: ―Ye aseco tunalte para Deus tlamandörurus nemotlac. Xomoyulcuepacö hua xomoneltocacö ica cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nejnemoöya Jesús itlac ötiescatl de Galilea. Oquejtaque Semu hua icni itucö Andrés quetlajcaleya tarröya ijtec ötzintle, pos yejua oyejyeya pescadurte. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Pos oquemelfejque Jesús: ―Xeniechtocacö hua nemiechchihualtis nenyesque nenpescadurte de tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pos sa nima quecöjtiejque intarröya hua tietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Opanoac tepetzi cache ca niepa. Oquejtaque Jacobo, iconie de Zebedeo, hua Xohuö, icni de Jacobo. Nuyejque yejua oyejyeya ipa börco queyejyectlöliöya intarröya ye tlajtlatzcotu. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pos nima quennutzque. Entunses yejua cualcöjtiejque intajtzi Zebedeo ipa börco ca tiehua tequetque hua tietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ocajcalacoac ipa puieblo de Capernaum. Cuöquenu yejuatzi ocalacoac ipa teopanconetzi ipan söbron tunale cuöc mosiebea joriojte. Ompa tlamachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pos giente quetietzöbejtaya quiene ca tlamachtiloöya porque quenmachtiloöya ca checöhualestle hua amo quiename yejua tlamachtiöneme de teotlajtule tlamachtiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pero oyeya ipa teopanconetzi sente tlöcatl tli ijtecopa quepeaya moxicoöne. Ini nönca otzajtzec. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Oquejto: ―¡Ay! ¿Tli tecpea ca tejua, Jesús de puieblo de Nazaret? ¿Ye tehuöla tetiechxexetunico? Necmate öquenu taja; taja tetietlöcayectec de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero Jesús cajajuaque. Oquelfejque: ―Xectzacua mocamac hua xequisa de ijtecopa yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Pos inu moxicoöne quechihualte tlöcatl ma mimeque. Otzajtzec checöhuac, hua oquis de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pos innochtie quetietzöbejque. Motlajtlaniöya sente ca ocsente. Quejtoöya: ―¿Tlininiji? Pos ica sente yancuec tlamachtelestle tli quepea meyac checöhualestle. Pos hasta moxicoöneme yaja quennahuatea hua yejua queneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Sa nima ca nobeyo quecajque giente ipa noche estado de Galilea lo que tli oquechijque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Oquejquixoac de ipan teopanconetzi. Obejbiloac ca inchö Semu hua Andrés. Ajaxihuato ca tiehua Jacobo hua Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pos imontiesyo Semu betztotaya. Quepeaya totunealestle. Pos nima yejua tienunutzque de imontiesyo. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Entunses axihuato yejuatzi. Ocönque ca imö hua cajcojque. Pos ayecmo quepeaya totunealestle, hua tieintlamacaya. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ye ixtlayohua oyeya. Hua san tequetl ocalac tunale, quenhualecaque tietlac noche tli mocojcocoöya, hua tli quepejpeaya demunios. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pos noche puieblo mosentlölejque ipan queyöhuatientle. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yejuatzi quenpajtejque meyactie tli mocojcocoöya de sösantle cocolestle. Quenquextejque meyactie demunios. Amo quencöjque demunios ma quejtucö canajyetla porque ye tieixomatque. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lalebes cualco ca ise oneyehualuc, oc tlajtlayohua. Oquixoac hua obiloac ipan locör cöne nionöque chönteya. Ompa netlötlajtiluc. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Cuöquenu tietiemojtenemeya Semu, ca noche tli oyejyeya ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cuöc tieniextejque, otieyelfe: ―Noche giente metzmotiemolejteneme. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pos quemelfejque: ―Cache cuale teyabe ca niecate puieblos para nuyejque ompa netlanunutzas. Ipampaji nehuöla. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Entunses hualtlanunutzalutöya ipa teopancucone de noche estado de Galilea, hua cualenquextilutöya demunios. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Sente tlöcatl sa söhuayo ohuöla tietlac Jesús, tietlötlajtico. Motlancuöquetz hua otieyelfe: ―Mach tomonequitis cuale teniechmopajtelis. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pos tieyulcoco Jesús. Omösohualuc hua quemötocaque. Oquelfejque: ―Necneque. Xepajte. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Cuöc oquejtojque inu, pos inu cocolestle de söhuame sa nima oquecö hua yaja opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yecuöquenu quenahuatejque ca meyac checöhualestle, hua nima quelfejque ma beya. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Oquelfejque: ―Xequejta. Amo öque tli xequelfe, tlöcamo xebeya xomotieijtete ica teopexque. Ye techepöhuac. Xejcuetlabilte lo que tli Moisés otlanahuate, para ma quematecö yejua lo que tli omochi ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero yaja oquis hua opie tlapoa lalebes. Ca nobeyo quepoaya noche tli omochi. Pos yaja ica Jesús abele calacoaya ixmantete ipa puieblo tlöcamo iloaya ipa inu locör cöne nionöque chönteya. Pero giente de ca nobeyo huölöya tieca. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pa quiejquech tunalte Jesús ocalacoac ocsajpa ipa puieblo de Capernaum. Omacheac nele iloaya ipan chöntle. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pos nima mosentlölejque meyactie, hasta ayecmo ajaqueya nimpor ipa queyöhuatientle. Quennunutzaloöya de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yecuöquenu nöbe tlöca ohuölajque tiecatzinco. Quehualecaque sente tlöcatl cojcultec. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pos como yejua abele aseya tietlac por meyactie tlöca, quecuötlapojque cale cöne yejuatzi iloaya. Cuöc quetlapojque, quetemobejque cuajtlapechtle ca tiehua cojcultzi tli ipa hualbetztöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús nemacuc cuienta quiene moneltocaya inu tlöca. Oquelfejque cojcultzi: ―Xequejta, Ixo, motlajtlaculyo temetzperdonörfea. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ompa yejyehuataya seque tlamachtiöneme de teotlajtule. Quepensöroöya ipa inyulo: ");
INSERT INTO nhgNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Tlica tlajtlajtoa nönca tlöcatl ejqueyi? Checuatlajtojteca encuntra de Deus. Abele öque cuale tieperdonörfis tlajtlacule tlöcamo sa yejuatzi Deus”. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pos sa nima oquematque Jesús ipa tieyulo quiene yejua quenenebeliöya ejqueu imijtecopa. Oquenmelfejque: ―¿Tlica nenquepensöroa tlimach ipa nemoyulo? ");
INSERT INTO nhgNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cötlaja cache tequeyo, nequelfis cojcultzi: “Temetzperdonörfea motlajtlaculyo”, noso nequelfis: “Xemiehua. Xecöna mocuajtlapech hua xenejneme”? ");
INSERT INTO nhgNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pos öxö nenquematesque que naja que onochi netlöcatl necpea deriecho necö ipan tlöltecpactle para netieperdonörfis tlajtlacule. Oquelfejque cojcultzi: ");
INSERT INTO nhgNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Taja temetzelfea, xemiehua. Xecöna mocuajtlapech hua xebeya pa mochö. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Entunses omoquetz. Sa nima ucö icuajtlapech hua oquistie imixtla innochtie. Pos ca inu noche giente oquetietzöbejque hua tiechamöjque Deus. Quejtojque: ―Ayec tequejtaque niontle quieme ini. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ocsajpa obiloac ca itlac ötiescatl. Noche tlöca ohuölöya ca tietlac, hua quenmachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cuöc obiloac de ompau, oquejtaque Leví, öque oyeya iconie de Alfeo. Leví yehuataya cöne yaja caresibirojtaya tomi. Pos yaja tlanecheco oyeya. Jesús quelfejque: ―Xeniechtoca. Pos moquetztie hua tietocac. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Omochi ini nönca. Cuöc Jesús tlacualutaya ichö Leví, meyactie giente tli tlanechecojque hua tlajtlaculteque nuyejque ompa tlacuajtaya ca Jesús hua tiemachtejcöhua. Pos meyactie tietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ompa oyejyeya seque tlamachtiöneme de teotlajtule tli oyeya de inu grupo de joriojte itucö fariseos. Yejua tieijtaque Jesús que tlacualutaya inca giente tli tlanechecojque hua tlajtlaculteque. Entunses yejua oquemelfejque tiemachtejcöhua: ―¿Tlininiji? Jesús tlacua intzölö nöncate giente tli tlanechecojque hua tlajtlaculteque. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Cuöc quecajque Jesús quemelfejque: ―Öque amo mocojcocoa amo quenesesitöroa mierco, tlöcamo öque mococoa, yaja inu quenesesitöroa. Amo nehuöla nequennutzaco tli cate yecteque tlöcamo tlin tlajtlaculteque. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Imachtejcöhua de Xohuö hua inu fariseos tlajtlajyubiöya. Ohuölajque seque giente hua tieyelfejque Jesús: ―¿Tlica imachtejcöhua de Xohuö hua inmachtejcöhua fariseos tlajtlajyubea, pero momachtejcöhua amo tlajtlajyubea? ");
INSERT INTO nhgNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús quemelfejque: ―¿Beles cuale tlajyubisque tlin nejnieneme ipa nesohuajtiluyo, cuöc montle intlanca? Pos mientras ompa cate itlac montle, abele tlajyubisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero huölösque tunalte cuöc montle ayecmo oncöyes. Cuöquenuju tunalte tlajyubisque. Cuöc naja ayecmo oncö neyes, cuöquenuju tlajyubisque nomachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sente tzotzomajtle tli ye soltec amo öque quetlajtlamanelea ca tzotzomajtle yancuec. Porque tlö ejqueu, pos inu tzotzomajtle yancuec amo queyectlölea, cache mocototzoa hua quetzomunea inu tli soltec, hua cache iyes bieye tzomunelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nimpor nionöque amo quetlölea vino yancuec ijtec puxajme de cuetlaxtle tli ye solteque. Porque tlö ejqueu, pos inu vino quetzomunis inu cuetlaxtle. Niempolebes vino ca tiehua puxajme. Cache vino yancuec motlölea ijtec puxajme yancueque. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa sente söbron tunale opanoac Jesús cöne tlatuctle. Tiemachtejcöhua hualnejnentöya cualcopintöya meyöhuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yecuöquenu fariseos otieyelfejque: ―Xequejta. ¿Tlica ejqueu quechihua tli amo conbenierebe öque quechihuas ipan söbron tunale? ");
INSERT INTO nhgNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero yejuatzi oquemelfejque: ―¿Ayec nenquetlajtultejque tli oquechi David ca tiehua yejua tli oyejyeya ca yaja cuöc ipa monectaya hua tejteosejtaya? ");
INSERT INTO nhgNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Pos yaja ocalac ipa tieteupa Deus cuöc Abiatar oyeya tlajtojcöteopexque. Pos David oquecua pöntzi tli oyeya de bentle, tli amo conbenierebe öque ma quecua tlöcamo sa yejua teopexcötzetzi. Hua amo sa inu oquechi. Pos oquenmacac noche quiejquech ohuölöya ica yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nuyejque Jesús oquemelfejque: ―Deus oquechejchijque inu söbron tunale cuöc tosiebea para bien de tlöca, hua amo quenchejchijque tlöca para bien de inu tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yaja ica, naja que onochi netlöcatl necpea deriecho para nequennahuatis giente hasta de tli sösantle conbenierebe ma quechihuacö pan söbron tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ocsajpa Jesús calacoac ijtec teopanconetzi. Ompa oyeya sente tlöcatl tli quepeaya sente imö huöjque. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pues yejua tieyetztaya abier tlö beles tlapajtilus ipan söbron tunale. Pos quenequeya tietieyelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yecuöquenu yejuatzi oquelfejque inu tlöcatl tli quepeaya imö huöjque: ―Xomoquetza nepantla. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Entunses quemelfejque yejua: ―¿Conbenierebe öque quechihuas tlin cuale noso öque quechihuas tlin amo cuale ipa söbron tunalte? ¿Conbenierebe öque quemöquextis nemelestle, noso tlamectis? Pero yejua quetzacuaya incamac. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Entunses quemejtaloöya ca tlabiele. Pos tieyulcoco por lalebes yultepitzteque yejua. Oquelfejque inu tlöcatl: ―Xecmelaso momö. Pues oquemelaso hua imö opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Cuöquenuju oquisque fariseos hua nima motlajtulmacaque inca herodianos cuntra yejuatzi para quiene tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Cache Jesús nexeluluc de yejua hua obiloac ca itlac ötiescatl ca tiemachtejcöhua. Tietocaque meyactie de estado de Galilea. Pos de estado de Judea, ");
INSERT INTO nhgNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","de ciudad de Jerusalén, de estado de Idumea, de ca nepa icuetlapa ötlactle Jordán, hua de itlac puieblos de Tiro hua Sidón, lalebes meyactien tlöca oquecajque tli bieye tlachihualestle quechihualoöya. Entunses ohuölajque tieca. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Hua mopachojque meyactie tlöca, hasta que yejuatzi quemelfejque tiemachtejcöhua ma ompaye sente börco para ipa cuale tlejcoas para majcamo tiepötzucö. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pos quenpajtiloöya meyactie. Yaja ica tiepötzoöya noche tli mocojcocoöya porque quenequeya tiemajmötocasque para que ejqueu pajtesque. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Cuöc moxicoöneme tieijtaque, mopechtiecaya tieixpa hua tzajtzajtzeya. Quejtoöya: ―Taja teca teiConie Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero yejuatzi quemajajualoöya lalebes que majcamo quejtucö öquenu iloac yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sötiepa otlejcoac ipan tepietl. Quennutzque quiejquech yejuatzi oquenejque. Ohuölajque tietlac. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Entunses quemixpejpenque majtlactle huan ume tlöca para ma yecö tieca hua para quentitlanesque ma tlanunutzacö. Hua quencuitejque tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Quemixpejpenque para ma quepeacö checöhualestle para quenquextisque moxicoöneme. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ejqueu noso quemixpejpenque inu majtlactle huan ume. Hua yaja Semu yejuatzi quecuitejque Piero. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nuyejque quemixpejpenque Jacobo iconie Zebedeo hua Xohuö icni de Jacobo. Quencuitejque Boanerges, que quejtusneque giente tli tlajtlajtoa checöhuac quiename cuöc tlatecuine. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Quemixpejpenque Andrés, Felipe, Bartolomé, Mateo, Tumös, Jacobo iconie de Alfeo, Tadeo, Semu de inu partido de cananistas, ");
INSERT INTO nhgNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","hua Judas Iscariote, öque nuyejque tieantrecöro. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Axihuato ipan chöntle. Ocsajpa mosentlölejque meyactie tlöca, hasta nimpor abele tlajtlacualoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Cuöc oquematque tiefamiliares Jesús que ompa iloaya, onyajque para tieasetibe. Pos quejtoöya: ―Ye lucojtec icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero tlamachtiöneme de teotlajtule ohuölajque de ciudad de Jerusalén. Quejtoöya nele Jesús quepealoöya inu demunio itucö Beelzebú. Nele quenquextiloöya ocseque demunios ca ichecöhuales inu tlajtoöne de demunios. Yaja ica. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Entunses Jesús quennutzque. Quenmelfiloöya ica cuientos: ―¿Quiene cuale Satanás sa ye yaja motojtocas? ");
INSERT INTO nhgNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tlö quejtus giente de sente nación seme momejmectisque entre yejua mismo, pos polebesque inu giente de inu nación. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tlö giente de sente chöntle seme momacasque, pos nima pojpolebes inu chöntle. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tlö Satanás moponierojteca cuntra yaja mismo hua mopeleörojteca ca sie yaja, pos abele tli ayes, tlöcamo sie yaja mopojpolus. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Nionöque abele calaques ichö sente tlöcatl chejchecactec para quequextelis tli ihuöxca tlö amo cachto quejilpis inu tlöcatl chejchecactec. Yecuöquenu quetlaquejquextelis ipa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Melöhuac nemiechelfea que Deus quenperdonörfisque tlöca noche tlajtlacule hua noche checuatlajtule tli cusöroa para checuatlajtoa. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero öque tiechecuayelfis hua tiepöpöcas Espíritu Sönto, inun quiema Deus ayec queperdonörusque, porque quepea tlajtlacule tli mocöhuas nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ejqueu quemelfejque porque yejua quejtoöya nele quepealo moxicoöne. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Sötiepa tienönajtzi hua tieicnihua ohuölajque. Cuöc oyejyeya queyöhuac, tlatitlanque ma tienutzacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pos giente yejyehuataya tieyehualojtaya yejuatzi. Tieyelfejque: ―Monönajtzi hua mocnijtzetzihua metzmotiemolea queyöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Entunses yejuatzi onöhuatihuac, quemelfejque: ―¿Öquemeju nonöna hua nocnihua? ");
INSERT INTO nhgNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Pos otlachealuc impa yejua tli ompa yejyehuataya tieyehualojtaya. Oquemelfejque: ―Xequejtacö. Nemejua nennonöna hua nennocnihua. ");
INSERT INTO nhgNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Porque öque beletes quechihuas tietlanequeles Deus, yaja inu icaca nocni oquechtle, noso nocni sohuatl, noso nonöna. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ocsajpa opiehualuc quenmachtiloöya itlac ötiescatl. Tieca mosentlölejque lalebes meyac giente. Por inu ocalacoac ijtec sente börco. Onetlöliluc ijtec börco ipa ötiescatl. Entunses noche giente oyejyeya ipan tlöle itienco ötiescatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Meyac sösantle oquenmachtiloöya ca cuientos. Cuöc quenmachtiloöya quemelfiloöya ejqueyi: ");
INSERT INTO nhgNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Xejcaquecö cuale. Sente tlöcatl oquis tlatucato. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Quecuasema xenöchtle. Hua omochi cuöc tlatucato, seque obetz itienco ojtle. Tutume ohuölajque hua quecuajque. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ocseque obetz cöne lalebes tecamac, cöne amo quepeaya meyac tlöle. Nima oquis, pos tlöle amo teröhuac oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero cuöc oquis tunale, opeli hua uhuöc, pues amo monelhuayute. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ocseque obetz ipa betztle. Betztle omobepö hua quepötzmecte tlatuctle. Por inu amo tlamochihualte. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero ocseque obetz ipa cuale tlöle. Pos tlamochihualte. Mobejcapano hua omobepö. Seque meyöhuatl oquebicac ca treinta, ocseque ca sesenta, ocseque ca sie sientos töntos. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Entunses quemelfejque: ―Öque quepea itlacaqueles para tlacaques, ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Sötiepa oijiloaya tieinsiel yejuatzi hua inu majtlactle huan ume ca tiehua quiesquete ocseque. Entunses yejua tietlajtlaniöya tli quejtusneque inu cuientos tli quenpubeliloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yejuatzi quemelfejque: ―Nemejua nemiechtocöroa nencasojcömatesque inu secrietos de quiene ca Deus tlamandörurus. Pero ca giente tli amo cate de nemejua, mojtoa noche sösantle ca cuientos. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ejqueu mös yectlajtlacheasque, pero majcamo yetla quixomatecö. Mös tlayejcaquesque, pero majcamo yetla casojcömatecö. Ejqueu amo moyulcuepasque para ejqueu Deus amo quenperdonörfisque intlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Oquemelfejque: ―¿Amo nenquemate tli quejtusneque ini nönca cuiento? ¿Quiene noso nencasojcömatesque noche cuientos? ");
INSERT INTO nhgNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Öque tlatuca icaca quieme tlö öque quetuca tlajtule de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Inu xenöchtle tli obetz itienco ojtle icaca quieme cana giente tli ipa inyulo ye omotucac teotlajtule. Pero cuöc ye quecajque, nima yebitz Satanás. Quejcuenea inu tlajtule tli omotucac ipa inyulo. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Öxö nuyejque inu xenöchtle tli omotucac intzölö teme icaca quieme cana giente tli quecajque teotlajtule hua nima queselejque ca meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero mochihua quieme cana inu tlajtule amo monelhuayute de melöhuac ipa inyulo. Pos impa yebitz tiecoco noso cox giente quentepotztoca por ipampa teotlajtule, hua nima modesanimöroa. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Öxö inu xenöchtle tli omotucac intzölö betztle nele icaca quieme cana yejua tli quecajque teotlajtule, ");
INSERT INTO nhgNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero quentequepachoa sösantle ipa nönca tlöltecpactle. Mixcajcayöhua ca tomi hua quixeliebea meyac sösantle. Pos tönto hua tönto tlaixeliebea hasta quieme cana ye oquepötzmectejque teotlajtule ipa inyulo. Yaja ica teotlajtule amo quepea resultado inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Cache inu xenöchtle tli omotucac ipa cuale tlöle icaca quieme cana yejua tli quecajque teotlajtule. Cöna hua quechihua noche tlin cuale tlachihuale, quieme cana tlö sente xenöchtle quetiemacasquea treinta, hua ocsente quetiemacasquea sesenta, hua ocsente quetiemacasquea sie sientos töntos. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nuyejque quemelfejque: ―Pos lalebes tunto öque quetlölis sente cantil itzintla almu noso itzintla tlapechtle. Tejua tectlölea sente cantil ipa canteliero cöne tlöbejtös. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Pos noche tli mojyönteca sötiepa nieses, hua noche tli sa ichtacajtzi icaca sötiepa macheas. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tlö canajyeca quepea itlacaqueles para tlacaques ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nuyejque quemelfejque: ―Xecpeacö cueröro de lo que tli nenquecaque. Pos san quiene nenquentemachibelea ocseque giente, ejqueu nuyejque nemiechtemachibelisque, hua hasta cache meyac nemiechmacasque. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tiel öque tli quepea, quemacasque cache meyac. Pero öque amo bel quepea, quequextelisque hasta inu tepetzi tli oc quepea. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nuyejque oquejtuloöya: ―Cuöc Deus tlamandöruro icaca quieme cana sente tlöcatl cuöc quetuca xenöchtle. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Inu tlöcatl coche ca yohuale. Miehua ca tunale. Pos tlatuctle quisa hua mobepöhua pero yaja amo quemate quiene. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sie yaja tlöle quetlamochihualtea. Cachto ixejyo. Yecuöquenu imeyöhuayo, hua sötiepa itech imeyöhuayo quisa ixenöchyo. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Entunses cuöc ye ochecö, sa nima queteque ca yusno, porque ye ura para moteques. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nuyejque oquejtojque: ―¿Ca tli tejcomparörusque quiename cuöc tlamandöruro Deus? Noso ¿tli cuiento cuale tecönasque para tequejtusque que ejqueu tlamandöruro? ");
INSERT INTO nhgNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Cuale tequejtusque que Deus tlamandöruro quiename cuöc mobepöhua ixenöch mostöza. Cuöc inu mostöza motuca, cache tzitzequetzi icaca que noche sösantle xenöchtle tli onca ipa tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero cuöc ye omotucac, mobepöhua hua mochihua cache bieye que noche sösantle queletl. Lalebes momömöyutea hua tutume tli patlöne ipa yejyecatl quetlölea intepasol ipa isumbra. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pos ca meyac cuientos quieme ini yejuatzi quennunutzaloöya de teotlajtule san quiene ca yejua cuale quecajque. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sin cuientos amo quennunutzaloöya. Cache tiemachtejcöhua, cuöc sa insiel oijiloaya, yejuatzi quenpanquexteliloöya noche sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Inu mismo tunale cuöc ixtlayohua oyeya quemelfejque: ―Ma tepanucö ca niepa. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Quencöjtiejque inu giente, pos tiemachtejcöhua tiebicaque ipa börco san quiene ca iloaya. Ompa nuyejque oyejyeya ocseque börcos. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pero omochi sente yejyecatl bel checöhuac. Ötzintle majcoteopancueya ipa börco, hasta ye tiemeya börco. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pos yejuatzi iloaya icuetlapa ijtec börco. Cochihuataya ipa sente tlacpale. Entunses tieixetejque hua tieyelfejque: ―Maestro, ¿amo metzmoimportörfea tlö necö temejmequesque? ");
INSERT INTO nhgNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yecuöquenu neyehualuc, hua cajajuaque öyejyecatl. Quelfejque ötiescatl: ―Sa xeyeta. Xomosiebe. Cuöquenuju öyejyecatl omoquetz por complieto hua sa tlacacta. ");
INSERT INTO nhgNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Entunses quemelfejque yejua: ―¿Tlica tönto lalebes nemomajtejque? ¿Tlica ayemo nemoneltoca? ");
INSERT INTO nhgNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Hua yejua majcömejque lalebes. Omolfiöya sie yejua: ―¿Öqueniji noso? Pos hasta yejyecatl hua ötzintle tieneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Onajaxihuato ca nie löro de ötiescatl intzölö giente de puieblo de Gerasa. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Cuöc Jesús oquixoac de ijtec börco, nima sente tlöcatl tli quepeaya moxicoöne ohuölie de mejcöustutl tienömequeco. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ini tlöcatl chönteya cöne motuca mimejque. Pero nionöque abele quelpiöya nion ca cariena. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pos meyacpa quejilpiöya ca carienajte pa icxehua hua pa imöhua. Pero yaja quenxexetune inu carienajte pa imöhua hua quencojcotunaya inu carienajte pa icxehua. Pos nionöque abele quequitzquiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Seme yohualen tunale tzajtzetenemeya ipa tepieme hua tzajtzetenemeya cöne motuca mimejque. Sie yaja mococojtenemeya ca teme. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Entunses cuöc tieyejtac Jesús bejcateca, omomerö. Motlancuöquetzato tieixtla. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Tzajtzec checöhuac hua oquejto: ―¿Tli tomopilea ca naja, Jesús, tieConietzi Deus bieyetzintle? Temetzmotlötlajtelea tieixtlantzinco Deus, amo xeniechmotlajcalele ipa tiecoco tietunie. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ejqueu oquejto porque ye quelfejque Jesús: ―Xequisa de ini tlöcatl, taja temoxicoöne. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Entunses quetlajtlanque: ―¿Quiene tomotucö? Tienönquele: ―Pos nenotucö Trupa, porque temeyactie tecate. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yecuöquenu tietlötlajtiöya lalebes meyac majcamo quetitlanecö ca queyöhuac de inu nieca locör. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ompa oyejyeya itech nieca tepietl meyactie petzome tlajtlacuajtenemeya. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Entunses inu moxicoöneme tietlötlajtejque: ―Xetiechmotitlane inca petzome ma tecalaquecö inmijtecopa. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pos sa nima quencöjque yejuatzi. Entunses quistiejque moxicoöneme. Calaqueto imijtec petzome. Cuöquenuju momiemeröjtiejque noche petzome quiename ume mil. Motietepexebito hasta ijtec ötiescatl, hua ompa öijyumejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Inu tlöca tli quentlajtlacualtejtenemeya petzome ochucholojtiejque. Tlamachestito ipa puieblo hua ca caltienco. Pos quistiejque giente para quejtaque tlininu nieca tli omochi. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Hua ohuölajque tieca Jesús. Quejtaque yehuataya inu tlöcatl tli antes quecocoöya demunios. Pos yaja cachto quepeaya inu trupa de moxicoöneme, pero öxö ye cuale. Ye möquejtaya itzotzomajua hua ayecmo lucojteya. Pos yejua giente momajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Entunses yejua tli miero quejtaque lo que opasöre quenpubelejque lo que tli ipa omochi inu tlöcatl tli quepeaya demunios hua tli impa omochi petzome. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Yecuöquenu opiejque tietlötlajtejque Jesús ma biloa de intlac. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuöc calacoac yejuatzi ijtec börco, inu tlöcatl tli oquepex demunios tietlötlajtiöya ma seme iye tietlac. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Cache Jesús amo quecöjque, tlöcamo quelfejque: ―Xebeya pa mochö inca motlöcaicnihua, hua xequenpubele tli bieye tlachihualestle oquechijque Tlöcatzintle ca taja, hua quiene ca oquepexque icnuejtelestle ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Melöhuac uya hua tlanunutz ipa inu estado de Decápolis tli bieye tlachihualestle oquechijque Jesús ica yaja. Pos noche giente quetietzöbiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Cuöc Jesús panoac ocsajpa ca nepa löro omosentlölejque meyactie tieca. Ompa iloaya itienco ötiescatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Entunses ohuöla sente tlayecönque de teopanconetzi itucö Jairo. Hua cuöc tieyejtac Jesús, mopechtiecac tieicxetla. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tietlötlajtiöya lalebes. Oquejto: ―Nochpuchconie ye mecteca. Xehualmobica hua xomotlölele momötzetzihua ipa yaja para ma pajte, hua ma neme. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pos biloac ca yaja, hua tietocaque meyac giente. Tiepötzoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Sente sohuatl ye mococoöya majtlactle huan ume xebetl ica itlapalyeso. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lalebes obejcö mococoöya inmöpa miercojte. Quecastöro noche tli quepeaya hua amo opejtec, tlöcamo cache tlanabeya. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Cuöc inu sohuatl oquecac lo que tli giente quejtoöya de Jesús, aseto ca tiecuetlapa intzölö giente. Quemötocac tietlaquie Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pos quejtoöya ijtecopa: “Tlö necmötocas mös sa tietlaque, nepajtes”. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Hua sa nima itlapalyeso omoquetz hua quemachele ipa icuierpo que ye opajtec de inu nieca tiecoco. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pos nima Jesús quemachelejque tieijtecopa que cusörojque checöhualestle. Onecuepaluc intzölö giente hua quemelfejque: ―¿Öquenu conmötocac notlaquie? ");
INSERT INTO nhgNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Tieyelfejque tiemachtejcöhua: ―Pos ¿quie amo tomojtelea meyac giente metzmopötzelfea, hua turavea tomojtalfea: “¿Öquenu niechonmötocac?” ");
INSERT INTO nhgNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero yejuatzi tlachealoöya ca nobeyo para quejtasque inu sohuatl tli tiemötocac. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yecuöquenu inu sohuatl omajcömec hua bebeyocac, porque oquemat ijtecopa tli omochi. Entunses ohuöla hua mopechtiecac tieixpa yejuatzi. Tiemelöjcöpubele noche. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Yejuatzi oquelfejque: ―Nochpuch, por tomoneltocac ye tepajtec. Xebeya ca pöquelestle, hua xepajte de mococoles. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mientras yejuatzi oc tlajtlajtulutaya, ohuölajque seque giente tli cate pa ichö de tlayecönque de teopanconetzi. Quelfejque tlayecönque: ―Pos moconietzi ye omec. ¿Tli para cache tetiemotequemaquelea nöiloac maestro? ");
INSERT INTO nhgNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero cuöc Jesús quecajque lo que oquejtojque, quelfejque tlayecönque de teopanconetzi: ―Amo xomomajte. Sa xomoneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Entunses yejuatzi amo quecöjque yeca ma tietoca tlöcamo sa Piero hua Jacobo hua Xohuö, icni de Jacobo. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Obiloac ichö de tlayecönque de teopanconetzi. Quejtaque quiene ca cuejcueyuneya giente, quiene ca chojchucaya hua ara ca chuquestlajtoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yecuöquenu ocalacoac hua oquemelfejque: ―¿Tlica nencuejcueyune hua nenchojchuca? Pos ini sisehuantu amo omec tlöcamo coche. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Cache moburlörojque de yejuatzi. Pero yejuatzi quenquextejque ca queyöhuac innochtie. Ocönque itajtzi de sisehuantu hua inöntzi hua tli oyejyeya tiehua hua ocajcalacoac cöne oyeya sisehuantu. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Caseque imö sisehuantu. Oquelfejque: ―Talita, cumi ―quejtusneque: Sisehuantu, taja temetzelfea, xemiehua. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pos sa nima sisehuantu omie, hua nejnemeya. Quepeaya majtlactle huan ume xebetl. Pos nima quetietzöbejque bel lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero yejuatzi quennahuatejque checöhuac nele majcamo öque quemate de ini nönca, hua quemelfejque ma quetlamacacö sisehuantu. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Oquixoac Jesús de ompa hua hualiloac ca tiepuieblo. Tiehualtocaque tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ipan söbro, opiehualuc quenmachtiloöya ipa teopanconetzi. Meyactie quetietzöbejque cuöc tiecaqueya. Quejtojque: ―¿De cöne quetzeco nönca tlöcatl nocheji sösantle? ¿Hua tlininiji tlamatcöyutl tli yeca oquemacac? ¿Tli quejtusneque nöncate tietzöbeme tli quechihua ca imö? ");
INSERT INTO nhgNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Amo yaja ini calpintiero, iconie María, hua icni de Jacobo, de Josie, de Judas, hua de Semu? ¿Amo oncöncate ca tejua icnihua sohuame? Pos por inu amo quecualejtaya giente. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero Jesús quemelfejque: ―Ca nobeyo giente queyequejta sente tlayulepante, cache amo öque pa quejta miero ipa ipuieblo hua intzölö ifamiliares hua tli cate pa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pues yejuatzi abele oquechijque canajyetla tietzöbetl ompa. Sa quentlölejque tiemöhua impa quiesquete cocoxcötzetzi hua quenpajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Quetietzöbejtaloöya quiene yejua amo moneltocaya. Nejnemoatenemeya ipa noche puieblos tli ompa sierca oyejyeya, hua tlamachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sötiepa quennutzque innochtie majtlactle huan ume tiemachtejcöhua. Opiehualuc quentitlanihuaya ca ojume. Quenmacaque checöhualestle para quenquextisque moxicoöneme. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Pero quemelfejque majcamo tli quebicacö para pa ojtle, tlöcamo sa cuajfortu. Nimpor ijtacatl, nimpor morröl, nimpor tomi ijtec cinturón, ");
INSERT INTO nhgNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tlöcamo ma sa mocacticö, hua majcamo quebicacö unte tlaquieme. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Entunses quemelfiloöya: ―Cöne beletes nencalaquesque ipa sente chöntle, ompa xomocöhuacö hasta senamo nenquisasque de inu locör. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pues tlö giente de sente puieblo amo nemiechselisque nimpor amo nemiechcaquesque, xequisacö de ompa hua xectzetzelucö noche tlöle de nemocxehua. Yaja inu xecchihuacö para quematesque que amo cuale tli quechihua yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Entunses cuöc oquisque, tlanunutzaya que ma moyulcuepacö tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Quenquextiöya meyactie demunios. Quemajalöbeliöya asiete impa meyactie cocoxcötzetzi hua quenpajtiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Oquemat rey Herodes de ini sösantle. Pos giente tlapoaya de Jesús ca nobeyo. Pos seque quejtoöya: ―Pos ini tlöcatl icaca Xohuö Bautista que ye oyule de intzölö mimejque. Por inu quechihua bieye tlachihualestle yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero ocseque quejtoöya: ―Elías icaca. Ocseque quejtoöya: ―Yaja sente tlayulepante, noso icaca quiename sente de inu tlayulepantejque de ca ye niepa. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Cuöc oquecac rey Herodes inu, oquejto: ―Ini nönca yaja Xohuö öque naja nejquechtejtec. Ye oyule de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pues sie yaja rey Herodes otlatitla para ma casecö Xohuö hua ma quetzajtzacuacö ca cariena ipa cörsel. Pos ejqueu oquechi Herodes porque yaja mismo Herodes oquesohuacuejcuele icni Felipe. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Hua Xohuö quelfiöya rey Herodes: ―Amo cuale tecpextas isohua mocni. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pero inu sohuatl Herodías quetlajyelejtac Xohuö hua quenequeya quemectis. Cache abele quechihuaya, ");
INSERT INTO nhgNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","porque rey Herodes quemabeliöya Xohuö. Quemajtaya que Xohuö oyeya sente tlöcatl yulmelactec hua yectec, hua por inu Herodes oquepex cueröro majcamo yetla pasörebe ca yaja. Hua cuöc quecaqueya tli yaja quejtoöya, amo oquemat tli quechihuas. Pero de todos modos quecaqueya ca meyac gönas. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aseco sente cuale tunale. Ca sente yelfetl de icumpleaños, Herodes quentlötlacualtiöya itlötlajtoönejua ca tiehua coronielte hua tli cache bejfeye momajtaya ipa estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Pos ompa pa yelfetl ocalac ichpuch Herodías hua omojtute. Quecualejtac rey Herodes ca tiehua tli tlatlalfilte. Entunses rey oquelfe sisehuantu: ―Xeniechtlajtlanele tli taja tecneques, hua naja temetzmacas. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pos rey oquejto hua quejuröro lalebes: ―Paltzinco, noche tli taja teniechtlajtlanelis, temetzmacas hasta tlajcopa noche tli necpea necö cöne netlamandöroa. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Oquistie sisehuantu. Quelfito inöntzi: ―¿Tli netlajtlanes? Hua yaja oquelfe: ―Itzonteco Xohuö Bautista. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Yecuöquenu yaja sa nima ocalac itlac rey hua quetlajtlane. Oquejto: ―Naja necneque teniechmomaquelis ahorita ipa sente plöto itzonteco Xohuö Bautista. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pos rey motequepacho lalebes. Pero por oquejto paltzinco, hua por quecajque yejua tli tlacuöya ca yaja, amo oquenec quejtus que amo. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pos nima oquetitla sente guardia, hua oquenahuate ma quehualeca itzonteco Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pos guardia quequechtejtequeto ompa cöne tzactaya Xohuö. Quehualecac itzonteco ipa plöto, hua quemacac sisehuantu, hua sisehuantu quemacac inöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Entunses cuöc quematque imachtejcöhua, ohuölajque cajcoqueco icuierpo. Quetlölejque ijtec mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Entunses tietlateotitlanhua de Jesús mosentlölejque tieca. Tiepubelejque noche tli oquechijque, hua tli otlamachtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Yejuatzi quemelfejque: ―Ma teyöcö nencua ipa locör cöne nionöque chönte, ma xomosiebicö tepetzi. Pos meyactie giente oyöya hua huölöya, hasta nimpor amo quepejpealoöya locör para tlajtlacualus. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Obejbiloac tieinsiel ipa börco. Ajaxihuato hasta ipa locör cöne nionöque chönte. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero meyactie tieinmejtaque bejbiloac hua ocajasojcömatque cöne bejbiloasquiöya. Entunses meyactie sa icxepa onyajque de ipa nochemeju puieblos hasta para ca ompa. Aseto cachto que yejuantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Oquixoac Jesús de ijtec börco, hua quenmejtaque inu meyac giente. Tieyulcocojque porque oyejyeya quiename calnielojte cuöc amo quepea calnielojpexque. Entunses opiehualuc quenmachtiloöya meyac sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Cuöc ye miero tlajtlayohuas, tiemachtejcöhua mopachojque tietlac. Oquejtojque: ―Amo öque chönte ca necö, hua ye yohuac tecate. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xequenmotitlane giente ma yöcö ipan caltiencalme hua ca pan puieblos para ma mocojcubicö tli quecuösque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yecuöquenu onöhuatihuac yejuatzi. Oquemelfejque: ―Xequentlamacacö nemejua. Tieyelfejque: ―¿Teyösque tejcoatibe pöntzi ca ume sientos denarios tomi, hua sa ca inu tequentlamacasque? Pos abele. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yejuatzi quemelfejque: ―¿Quiejquech pöntzi nenquepea? Xeyöcö xequejtate. Entunses cuöc quematque quejtojque: ―Möcuile pöntzi hua unte mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Quentitlanque quemelfisque giente ma motlamachtlölicö ca grupos tlölpa ipan sacatl xoxoctec. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Omotlölejque ca grupos de sese sientos hua de tlötlajco sientos. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Entunses yejuatzi ocönque inu möcuile pöntzi hua inu unte mimechte. Ajcopatlachealuc ca elfecac, queteochijque inu pöntzi, hua quecocototzque. Entunses quenmacaque tiemachtejcöhua para ma quentlamacacö giente. Nuyejque quenxiexelfejque inu unte mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pos otlacuajque innochtie hasta cöne ijixbeque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cajcojque majtlactle huan ume chequejme tietieme de pöntzi cojcotoctec hua mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yejua tli quecuajque inu pöntzi oyejyeya quieme möcuile mil tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nima quenchihualtejque tiemachtejcöhua ma tlejcucö ipa börco hua ma yöcö cachto que yejuatzi para ca puieblo de Betsaida ca nepa löro, mientras yejuatzi quentitlanque giente ma yöcö. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Cuöc ye oquendespedirojque, obiloac ipa tepietl netlötlajtiluto. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cuöc ye otlayohuac, inu börco ye oyöya inepantla ötiescatl. Yejuatzi necöhualuc tiesiel ipa tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Quemejtaque quiene ca tiemachtejcöhua moöpröroöya para ma möbelöna börco ijtec ötzintle porque bel yejyecaya cuntra yejua. Ca ise quieme entre yeye hua checuasie ura, hualiloac intlac. Hualnejnemoatöya ipa ötiescatl, hua quenequihuaya quenpanultisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero cuöc tieijtaque yejua quiene nejnemoaya icpac ötiescatl, quejtojque que beles yaja sente mejque, hua majcötzajtzeque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pos innochtie tieijtaque hua majcömejque. Pero nima quennutzque hua quemelfejque: ―Xomoyulölicö. Naja necaca; amo xomomajticö. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Entunses otlejcoac inca yejua ipa börco. Ye omoquetz yejyecatl. Pos yejua bel lalebes quetietzöbejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Melöhuac ayemo casojcömateya tli quejtusneque lo que tli Jesús oquechijque ca inu pöntzi, porque oc yultepitzteque oyejyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Cuöc ye opanoac ca nepa löro, huajhualiloac ipa locör de Genesaret. Ajaxihuaco itienco ötiescatl itech tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Entunses quejquixoac de ijtec börco hua sa nima giente tieixomatque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Momiemeröjque ca nobeyo pa inu locör. Opiejque quenbecaya de ca nobeyo cocoxcötzetzi ipa incuajtlapech ca cöne quemateya nele ompa iloaya. ");
INSERT INTO nhgNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pos cöne beletes calacoaya Jesús, tlö pan puieblos tzequetzetzi, tlö pan puieblos bejbeye, tlö ca caltienco, giente quentlöliöya cocoxcötzetzi pan cayaju. Tietlötlajtiöya nele ma quencöhuacö quemötocasque mös sa itienco tietlaquie. Entunses noche tli quemötocaya opajpajteque. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Tieca Jesús mosentlölejque fariseos hua seque tlamachtiöneme de teotlajtule tli huölajque de ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Pos yejua quejtaque que seque de tiemachtejcöhua Jesús tlacuöya sin quechepöhuaya inmöhuö. Es decir, amo momöpajpöcaya. Por inu quentlajtlacultejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Pos inu fariseos hua noche joriojte quechihua ca meyac cueröro inu costumbre de biebentzetzi. Tlö amo momöyecpajpöca lalebes, amo tlajtlacua. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Cuöc hualmocuepa de plöza, tlö amo majöltea, amo tlajtlacua. Pos meyac ocseque sösantle onca tli ocaseque para quechihuasque. Por ejiemplo, quenpajpöca bölsojte hua xölojte hua xocme de cobre hua tlapechme.) ");
INSERT INTO nhgNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tietlajtlanejque noso fariseos hua tlamachtiöneme de teotlajtule: ―¿Tlica noso amo quechihua momachtejcöhua inu costumbres de biebentzetzi tlöcamo tlacua sin momöpajpöca? ");
INSERT INTO nhgNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Onöhuatihuac yejuatzi, quemelfejque: ―Ara ca melöhuac tli oquejto Isaías de nemejua sa ume nemoxöyac. Pos tlajcuelulpanca cöne Deus quejtulo: Ini nönca giente quejtoa que pa niechejta, pero ca inyulo amo niechtlasojtla. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pos san tlapic yejua niechmabesutea. Pos quemachtea mandamientos de tlöca quieme tlö oyene tlamachtelestle de naja. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Pos nemejua ye nenquecöjque mandamientos de Deus hua nemajase itech costumbres de tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nuyejque Jesús quemelfiloöya: ―Para cuale nenquechihuasque inu costumbres de nemejua, bel melöhuac nenquecaltechojtebitze mandamiento de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pos Moisés oquejto: “Pa xequejta motajtzi hua monöntzi”. Nuyejque oquejto: “Öque quechecuayejtus itajtzi noso inöntzi, ma meque sin remedio”. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero nemejua nenquejtoa: “Sente tlöcatl cuale quelfis itajtzi noso inöntzi: Ayojcocuele yetla temetzmotlöocolelis porque ye Corbán”. (Corbán quejtusneque, ye netietlöocole Deus.) ");
INSERT INTO nhgNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Hua ca inu ayecmo nenquecöhua ma öque quepaliebe itajtzi noso inöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Pos nenquejtlacoa tietlajtultzi Deus por nenquechihua inu costumbres de nemejua tli nenquetlölejtebitze. Hua meyac ocseque sösantle nenquechihua quiename ini. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Quennutzque noche giente ca tietlac. Quemelfejque: ―Xeniechcaquecö nemonochtie hua xecasojcömatecö. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Sente tlöcatl amo momöhuas por lo que tli quecuös noso por lo que tli conis, tlöcamo tli quisa de ijtec tlöcatl, yaja inu quemöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesús nexeluluc de niecate giente hua calacoac pan cale. Tiemachtejcöhua tietlajtlanejque tli quejtusneque inu cuiento. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Quemelfejque: ―¿Nuyejque nemejua ejqueu nencate que amo nencasojcömate? ¿Amo nenquemate que noche lo que tli quecuös sente tlöcatl calaques ijtecopa hua abele quemajmöhuas? ");
INSERT INTO nhgNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pues amo calaque ipa iyulo tlöcamo ipa ijte, hua quisa ca icuetlapa. Ca inu Jesús tlamachestejque que noche sösantle tli mocuöne ica chepactec para cuale öque quecuös. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hua oquejtojque: ―Noche tli quisa de ijtec sente tlöcatl yaja inu quemöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porque de imijtecopa tlöca, de ipa inyulo, quisa amo cuale pensamientos, öque mopöctea ca ocsente tli amo isohua noso tli amo inömec, öque tlachteque, öque tlamectea, ");
INSERT INTO nhgNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","öque mopöctea ca isohua ocsente, öque moricotlölisneque, san petzotec tlachihuale, öque tlacajcayöhua, öque amo pinöjque, öque moxicoöne, öque checuatlajtoa, öque mochajchamöhua, öque amo tlarespetöroa. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Noche ini nönca sösantle tli amo cuale, quisa de ijtec tlöcatl, hua yaja ini quemöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ohuöliehualuc de ompa. Obiloac ca itlac puieblo de Tiro. Ocalacoac pa sente cale hua amo oquenejque ma yeca quemate. Pero abele neijyönaluc. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Isisehuanconie sente sohuatl quepeaya moxicoöne. Pos inu sohuatl oquecac de yejuatzi hua nima ohuöla tietlac. Mopechtiecaco tieicxetla. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Inu sohuatl oyeya griega hua chajchönteya ipa inu nación de Sirofenicia. Tietlötlajtiöya ma quequextelicö demunio ichpuch. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús quelfiloöya: ―Xequencöhua ma cachto tlacuöcö pelantzetzi que yejua joriojte. Porque amo conbenierebe ma tequenquextelicö pöntzi de pelantzetzi hua ma nemiechtlajcalelicö nemejua tli nencate quiename nenchecheme. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Onöhuat sohuatl, tieyelfe: ―Tlöcatzintle, pos nuyejque checheme tli cate itzintla miesa quecua perösojcucone tli pelantzetzi quemöcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yecuöquenu yejuatzi quelfejque: ―Ipampa ini nönca lo que tli otequejto, xebeya. Demunio ye oquis de mochpuch. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Entunses cuöc aseto ca ichö queniextito que moxicoöne ye oquis, hua iconie betztotaya pa tlapechtle. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ocsajpa Jesús oquixoac de itlac puieblo de Tiro. Opanoac ca puieblo de Sidón. Hualiloac itlac ötiescatl de Galilea, intzölö puieblos de estado de Decápolis. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tiehualequelejque sente tlöcatl tli tzatzatzi hua niempote. Tietlötlajtejque nele ma ipa quetlölicö tiemö. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Entunses quenencuaxelojque de intzölö giente ca sie löro isiel. Quecalaquejque tiemajpelhua ijtec inacashua de yaja. Cuöc ochejchaluc, quemötoquelejque inenepil. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ajcopatlachealuc ca elfecac, hua yelsesebihuac. Oquelfejque: ―¡Efata!―tli quejtusneque: ¡Ma motlapo! ");
INSERT INTO nhgNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pos sa nima omotlapo inacas hua inenepil moyectlöle. Ye tlajtlajtoa cuale. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Quennahuatejque giente majcamo öque tli quelficö. Pero entre mös quennahuatiloöya, cache hua cache tlamachestiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Pos ara ca quetietzöbejtaya. Quejtoöya: ―Lalebes cuale noche tli quechihualo. Hasta tzatzatzetzi quenchihualtilo ma tlacaquecö, hua niempoteme ma tlajtlajtucö. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ipa inu niecate tunalte mosentlölejque ocsajpa lalebes meyac giente pero amo quepeaya tli quecuösque. Jesús quennutzque tiemachtejcöhua hua quemelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Niechtlöocoltea nöncate giente porque ye quepea yeye tunale que notlac cate, hua amo quepea tli quecuösque. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tlö nequentitlanes ma yöcö ca inchö sin tlacuösque, amo cöhuantörusque pa ojtle. Pos seque ohuölajque de bejca. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tienönquelejque tiemachtejcöhua: ―¿De cöne noso cuale öque quentlacualtis nönca giente necö ipa ini nönca locör cöne nionöque chönte? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Quentlajtlanejque: ―¿Quiejquech pöntzi nenquepea? Yejua oquejtojque: ―Checume. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Yecuöquenu quennahuatejque noche giente ma motlölicö tlölpa. Ocönque inu checume pöntzi, hua cuöc tietlasojcömatelejque Deus, quencocototzque. Quenmacaque tiemachtejcöhua ma quentlamacacö giente. Pos quentlamacaque innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nuyejque quepeaya seque mimechte. Cuöc ye quenteochijque Jesús, quennahuatejque ma quenmacacö inu mimechte nuyejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pos tlacuajque hua ijixfeque. De tli cojcotoctec omocö cajcojque checume pescunchequejme. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Quiejquech giente tli tlacuajque oyejyeya quieme nöbe mil. Entunses Jesús quentitlanque giente ma yöcö. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nima ocalacoac ijtec börco ca tiehua tiemachtejcöhua. Hualbiloac ipa sente locör itucö Dalmanuta. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Entunses ohuölajque fariseos hua opiejque tieixcomaca. Tietlajtlanelejque ma quechihuacö sente tietzöbetlachihuale quiename sieñas de que Deus tiepaliebiloöya. Pos quenejque tieprobörusque. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yejuatzi yelsesebihuac ipa tieyulo, hua oquejtojque: ―¿Tlica nentlajtlane sieña? Melöhuac nemiechelfea, amo nemiechmacas nion sente sieña. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Pos ca inu quencöjtiejque, hua ocsajpa ocalacoac ijtec börco. Obiloac ca niepa löro. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tiemachtejcöhua oquelcöjque cönasque pöntzi. Quepeaya sa sente pöntzi ijtec börco. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Quennahuatejque Jesús. Quemelfejque: ―Xequejtacö, xomotlachilicö de levadura de fariseos hua de levadura de Herodes. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yejua molfejtaya: ―Yejuatzi quejtulo ejqueu porque amo tecualecaque pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ocasojcömatque Jesús, hua quemelfejque: ―¿Tlica nemolfea de que amo nenquepea pöntzi? ¿Ayemo nenquemate, nimpor amo nencasojcömate? ¿Quie nencate nenyultepitzteque? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pos nenquepea nemixtelolo, ¿quie amo nentlachea? Nenquepea nemotlacaqueles, ¿quie amo nentlacaque? ¿Nimpor amo nentlalnömeque? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cuöc onejcocototz inu möcuile pöntzi para möcuile mil gientes, ¿quiejquech chequejme nencajcojque de pöntzi cojcotoctec? Tieyelfejque: ―Majtlactle huan ume. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","―Hua cuöc onejcocototz checume pöntzi para nöbe mil, ¿quiejquech pescunchequejme tietieme nencajcojque de pöntzi cojcotoctec? Quejtojque: ―Checume. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Entunses quemelfejque: ―¿Quiene noso amo nencasojcömate? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nima hualiloac pa puieblo de Betsaida. Tiehualequelejque sente ixcocoxque. Tietlötlajtejque ma quemötocacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yecuöquenu ocönque imö ixcocoxque. Quequextejque ca caltienco. Ochejchaluc ijtec ixtelolojua hua oquetlölejque tiemö ipa ixtelolojua ixcocoxque. Entunses quetlajtlanque: ―¿Ye tetlachea cache tepetzi? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Pos yaja tlachixteca. Oquejto: ―Nequemejta tlöca sana cuajme. Pero nequemejta nejneme. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yecuöquenu quetlölejque tiemö ocsajpa ipa ixtelolojua. Quechibelejque ma yectlachea. Yeca. Ye moyectlöle. Pos oquemejtac sösantle ixmantete mös bejca. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Entunses quetitlanque ma beya ca ichö. Oquelfejque: ―Nion amo xecalaque pa puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Obiloac Jesús ca tiemachtejcöhua ipa puieblos amo bejca de sente puieblo itucö Cesarea de Filipo. Pa ojtle quentlajtlaniloöya tiemachtejcöhua, quemelfiloöya: ―¿Öquenu quejtoa giente que naja necaca? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Hua yejua tienönquelejque, quejtojque: ―Pos seque quejtoa Xohuö Bautista. Ocseque quejtoa que nele Elías, noso yeca ocsente tlayulepante. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Entunses quentlajtlanque: ―Hua nemejua, ¿öquenu nenquejtoa tlö naja necaca? Onöhuat Piero, tieyelfejque: ―Tejuatzi tomobetzteca teCristo öque Deus metzmixpejpenelejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero yejuatzi quennahuatejque majcamo tli quepubelicö nionöque de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Opiehualuc quenmachtiloöya que moneque ma yejuatzi öque nechihualuc tlöcatl ma quesufrirucö meyac sösantle, hua ma tietlajyelejtacö biebentzetzi hua jefes de teopexcötzetzi hua tlamachtiöneme de teotlajtule, hua ma tiemecticö, hua ma yulebecö ipa yeye tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ixmantete quemelfiloöya noche ini tlajtule. Entunses Piero tieasec hua tieajajuac. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Cache Jesús necuepaluc, hua quemetztalutaya tiemachtejcöhua. Cajajuaque Piero. Oquejtojque: ―Xebeya de naja, Satanás, porque amo tomofijöroa de sösantle tli de Deus, tlöcamo sa tli de tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Cuöc quennutzque giente ca tiehua tiemachtejcöhua, quemelfejque: ―Tlö canajyeca queneques niechtocas, majcamo quechihua lo que tli sie yaja queneque, tlöcamo ma iye listo para quesufrirus quiename öque quesufriroa ipa sente corujtzi, hua ma niechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pos öque beletes queneques quemalfis inemeles, quixniempolus. Hua öque beletes quetiemacas inemeles nopampa hua ipampa cuale tlamachestelestle, quemalfis. ");
INSERT INTO nhgNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pos ¿tli proviecho quepeas sente tlöcatl mös quetlönes noche tlöltecpactle, tlö quixniempolus inemeles? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Tli noso quemacas sente tlöcatl para ocsajpa quepeas inemeles? ");
INSERT INTO nhgNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Beles sente tlöcatl pinöhuas ca naja hua ca notlajtul intzölö nöncate giente tli sie tiro amo queneque tietocasque Deus hua lalebes tlajtlaculteque. Pos tlöjcu naja que onochi netlöcatl nepinöhuas nuyejque ca inu tlöcatl cuöc nehuölös ca tlaniextelestle de noTajtzi ca tiehua öngeles tli yecteque. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nuyejque quemelfejque: ―Melöhuac naja nemiechelfea que seque de tli oncö nenijijcatecate amo mejmequesque hasta senamo quejtasque quiene Deus tlamandörurus ca meyac checöhualestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sötiepa de checuasien tunale Jesús quemaxihuato Piero ca tiehua Jacobo hua Xohuö. Quenbicaque nencua insiel ipa sente tepietl bejcapa. Ompa necuepaluc ocsie imixtla. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Pos tietlaquie opie tzotzotlaca bel lalebes istöc, quieme nionöque sente tlöcatl pan tlöltecpac abele quepöcas ejqueu bel istöc. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Entunses inca yejua moniextejtequisque Elías hua Moisés. Tlajtlajtoöya ca Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Yecuöquenu Piero tieyelfe Jesús: ―ToTiemachtejcötzi, cuale que oncö tecate. Ma tequenchejchihuacö yete cuajtlapame. Sente para tejuatzi, hua sente para Moisés, hua ocsente pare Elías. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pos amo quemateya tli quejtus, porque yejua lalebes momajtejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Entunses ohuöla sente mextle hua oquentlapachojtequis. Sente tlajtule de ijtec mextle quejtoöya: ―Yaja ini nönca notlasojcöConie. Yaja xejcaquecö. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Sa de repiente cuöc tlajtlachixque, ayecmo öque quejtaque, tlöcamo sa Jesús tiesiel ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cuöc ye hualtemoaya de ipa tepietl, Jesús quennahuatejque checöhuac que majcamo yeca quelficö de tli oquejtaque tlöcamo hasta senamo yejuatzi que nechihualuc tlöcatl yulebesque de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Entunses yejua quemalfejque ipa inyulo inu nieca tlajtule, pero molfiöya nele tli quejtusneque öque yulebes de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tietlajtlanejque, oquejtojque: ―¿Tlininuju quejtoa tlamachtiöneme de teotlajtule, nele moneque ma huöla Elías cachto? ");
INSERT INTO nhgNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yejuatzi quemelfejque: ―Tiel melöhuac, huölös Elías cachto hua queyectlölis noche sösantle. Öxö tlö ejqueu, ¿quiene tlajcuelulpanca de naja que onochi netlöcatl, que necsufrirus meyac sösantle hua giente amo pa niechejtasque? ");
INSERT INTO nhgNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero nemiechelfea que Elías ye ohuöla. Pero giente ye quechibelejque noche tli oquenejque san quiene ca tlajcuelulpanca de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Onajaxihuato cöne oyejyeya ocseque tiemachtejcöhua. Quejejtaloöya que meyac tlöca tlamach cate ca yejua hua que tlamachtiöneme de teotlajtule mixcomacataya ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Cuöc giente tieijtaque, nima quetietzöbejque. Tienömequeto yejuatzi hua tietlajpalojque. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Quentlajtlanejque: ―¿Tlininu nemixcomacataya entre nemejua? ");
INSERT INTO nhgNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Yecuöquenu sente de inu giente tienönquele: ―Maestro, temetzhualmiquelele noconie. Quepea sente espíritu de moxicoöne tli quechihualtea ma iye niempote. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Inu moxicoöne cöne beletes case, quetlajcale. Camapuposune hua motlantese. Pos ye cuahuöcte. Nocomenelfe momachtejcötzetzihua ma quequextelicö. Cache abele conchijque. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yecuöquenu quennönquelejque yejuatzi, oquejtojque: ―¡Ay! ¡Nentlöca que amo nemoneltoca! ¿Hasta quiema neyes ca nemejua? ¿Hasta cöne necpeas necxicojtas ca nemejua? Xeniechhualequelicö. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Entunses tiehualequelejque. San tequetl inu espíritu de moxicoöne otieyejtac Jesús quechihualte pelalactle ma checöhuac mimeque. Motlajcale, momemelo, hua camapoposocac. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús quetlajtlanejque itajtzi: ―¿Quiejquech xebetl quepea quechihua ejqueyi? Yaja oquejto: ―Pos desde peltzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Quiemaneyo quetlajcale ijtec tletzintle, hua ijtec ötzintle, para quemectis. Pero tlö cuale tetiechmopaliebelis, ma temetzmoyulcocolficö tejua. Xetiechmopaliebele. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús quelfejque: ―Taja tequejtoa que tlö cuale. Pos noche cuale mochihuas para öque moneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nima itajtzi de pelalactle otzajtzec, oquejto: ―Noneltoca. Xeniechmopaliebele ma noneltoca de melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cuöc Jesús oquejtaque quiene giente motlamachtlöliöya, cajajuac moxicoöne. Oquelfejque: ―Taja temoxicoöne tli tecchihualte ini pelalactle niempote hua tzatzatzi. Öxö naja temetznahuatea: Xequisa de yaja, hua ayecmo quiema xecalaque ijtecopa. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yecuöquenu inu moxicoöne otzajtzec. Quechihualte ma checöhuac mimeque pelalactle, hua oquis. Entunses pelalactle omocö quieme cuöc ye mejque. Hua meyac giente quejtoöya: ―Pos ye omec. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús ocönque ca imö hua cajcojque. Yaja entunses omoquetz. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Cuöc Jesús ocalacoac ipa cale, tiemachtejcöhua tietlajtlanejque cuöc tiesiel: ―¿Tlica tejua abele toconquextelejque? ");
INSERT INTO nhgNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Quemelfejque: ―Amo onca maniera para quisas töl quiename ini tlöcamo sa ca öque motlötlajtis. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hua oquejquixoac de ompa, hua onejnemoatenemeya ipa Galilea. Pero Jesús amo quenequihuaya ma canajyeca quemate. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Quenmachtiloöya tiemachtejcöhua. Oquemelfiloöya: ―Naja que onochi netlöcatl niechtiemöctisque inmöpa tlöca. Niechmectisque. Pero cuöc ye niechmectejque, neyulebes pa yeye tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero yejua amo casojcömatque ini nönca tlajtule. Tiemabeliöya hua amo tietlajtlanejque cache. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Onajaxihuato ipa puieblo de Capernaum. Hua cuöc yejuatzi iloaya pan chöntle, quentlajtlanejque: ―¿Tli nencualejtojtöya pa ojtle? ");
INSERT INTO nhgNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero yejua tlacactajque porque pa ojtle yejua hualmixcomacatöya nele öquenu de yejua cache bieye momajtas. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Entunses netlöliluc. Quennutzque innochtie majtlactle huan ume, hua quemelfejque: ―Tlö canajyeca queneque mobieyemajtas, ma iye cache tzitzequetzi de nemonochtie hua ma iye tlatequepano de nemonochtie. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Yecuöquenu ocaseque sente peltzintle, hua quetlölejque nepantla de yejua. Entunses quenöpaluc. Quemelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Öque queselis notucöyupa sente de ini nöncate pelantzetzi quieme ini, nuyejque niechselea naja. Öque niechselea naja, amo sa naja niechselea, tlöcamo nuyejque tieselea yejuatzi öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yecuöquenu onöhuat Xohuö. Oquejto: ―Maestro, otequejtaque sente tlöcatl motucöyupantzinco quenquextiöya demunios. Pos tectzacuelejque porque amo tiechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero Jesús oquejtojque: ―Amo xectzacuelicö, porque abele öque quechihuas sente tietzöbetlachihuale notucöyupa hua al mismo tiempo quejtus tli amo cuale de naja. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pues öque amo icaca cuntra tejua ca tejua icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Öque beletes nemiechmacas sie bölso ötzintle notucöyupa porque nencate de Cristo, melöhuac nemiechelfea que amo quepolus ipremio tli quetlönes. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Tlö canajyeca quechihualtis sente de ini nöncate pelantzetzi tli moneltoca ca naja ma betze ipa tlajtlacule, cache cuale iyesquiöya para yaja tlö quelpelisque sente tietetu de molino ipa icucutla inu tlöcatl hua quetlajcalesque ijtec lamör. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tlö quejtus momö metzchihualtis tebetzes pa tlajtlacule, pos xectejteque. Cache cuale para taja tecpeas nemelestle mös temöcotoctec hua amo ca noche unte momöhua tecalaques ijtec tlecale cöne ayec siebes tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Tlö mocxe metzchihualtis tebetzes pa tlajtlacule, xectejteque. Cache cuale para taja tecpeas nemelestle mös tecxecotoctec hua amo ca noche unte mocxehua ma metztlajcalecö Deus ijtec tlecale. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Tlö mixtelolo metzchihualtis tebetzes pa tlajtlacule, xejcopina. Cache cuale para taja tecalaques ca sa sente mixtelolo cöne Deus tlamandöruro, hua amo ca noche unte mixtelolojua ma metztlajcalicö Deus ijtec tlecale, ");
INSERT INTO nhgNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","cöne inocuil amo meque hua tletzintle amo siebe. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Pos noche giente mobielelisque ica tletzintle, quiename tlacuale mobielelea ca istatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Istatl icaca cuale. Pero tlö istatl quepoloa ipöyecyo, ¿tli ica nenquebielelisque? Ma iye nemoyulo cualtec quieme istatl icaca poyec, hua xomoyulsiebejtacö sente ca ocsente. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Huöliehualutie de ompa. Hualiloac ca itlac estado de Judea hua ca ocsie löro de ötlactle Jordán. Ocsajpa mosentlölejque giente tieca. Ocsajpa quenmachtiloöya quieme seme quechihualoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ohuölajque seque fariseos tieca. Tietlajtlanejque tlö quejtus conbenierebe que sente tlöcatl ma quecajcöhua isohua. Pos tieproböroöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pero yejuatzi onöhuatihuac, quemelfejque: ―¿Tli nemiechnahuate Moisés? ");
INSERT INTO nhgNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yejua quejtojque: ―Moisés tiechcajcö ma mojcuelo öcta de divorcio para tocajcöhuasque. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Onöhuatihuac Jesús, quemelfejque: ―Pos lalebes nenyultepitzteque. Yaja ica Moisés nemiechejcuelfe inu mandamiento. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero desde ca opie nönca tlöltecpactle, “Deus quenchejchijque oquechtle hua sohuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ipampaju tlöcatl quencöjtiehuas itajtzi hua inöntzi, hua mosietelis ca isohua. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Hua yejua umeme mochihuasque sa sie cuierpo”. Ejqueu noso ayecmo cate ume tlöcamo sa sie cuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Por inu, lo que tli Deus quesietelejque, majcamo quenencuajtele tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ompa calejtec, tiemachtejcöhua tietlajtlanejque ocsajpa de inu. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Yejuatzi quemelfejque: ―Öque beletes quecajcöhua isohua hua mosohuajtea ca ocsente, ye tlaumepea hua tlajtlacoa cuntra isohua. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tlö sohuatl quecajcöhua inömec hua monömectea ca ocsente, nuyejque tlaumepea hua tlajtlacoa. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Entunses seque giente tiehualequeliöya pelantzetzi para ma quenmötocacö. Pero tiemachtejcöhua quemajajuaya. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Cuöc Jesús nemacuc cuienta ocualönoac. Quemelfejque: ―Xequencöhuacö pelantzetzi ma huölöcö notlac, hua amo xequentzacuelicö. Porque Deus tlamandöruro inca giente tli cate quiename nochemeji pelantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Melöhuac nemiechelfea, que öque beletes amo tiecöhuas Deus ma tlamandörucö ipa iyulo quiename sente peltzintle tiecöhua, inu tlöcatl amo calaques cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yecuöquenu quennöpalojque. Quentlölejque tiemöhua impa yejua para quenteochijque. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Cuöc quixoac pa ojtle, hualmomerö sente tlöcatl. Motlancuöquetzaco tieixtla. Tietlajtlane: ―Maestro, lalebes tecuale tetlöcatl. ¿Tli nayes para necpeas nemelestle nochepa? ");
INSERT INTO nhgNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesús quelfejque: ―¿Tlica teniechelfea necuale netlöcatl? Amo onca sente cualtec tlöcamo sa sietzi, yejuatzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Inu mandamientos taja ye tecmate: “Amo xetlamecte”. “Amo xecalaque ca isohua ocsente”. “Amo xetlachteque”. “Amo tiecamac xetieajaque”. “Amo tli xomotejtechte”. “Pa xequejta motajtzi hua monöntzi”. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Entunses inu tlöcatl otieyelfe: ―Maestro, noche inu necchijtebitz desde cuöc netzitzequetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús quetztalutaya, hua quetlasojtlaluc. Oquelfejque: ―Sa sente cosa metzpoloa. Xebeya, xecnamaca noche tli tecpea, hua xequenmaca tli porubejte. Ejqueu tecpeas ricojyutl ompa elfecac. Entunses xehuöla xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cache yaja ocasec tequepachule por lo que tli oquejtojque hua uya. Motequepachoöya porque quepeaya meyac tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yecuöquenu Jesús otlachealuc ca nobeyo hua quemelfejque tiemachtejcöhua: ―Bel lalebes tequeyo para calaquesque tlin ricojte cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pos tiemachtejcöhua quetietzöbejque por lo que tli oquejtojque. Pero Jesús onöhuatihuac, ocsajpa oquemelfejque: ―Xequejtacö, nopelhua. Bel lalebes tequeyo öque calaques cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cache isejco panus sente camello ijtec ixtelolo de sente öcuxa que sente rico calaques cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pos yejua quetietzöbejtaque bel lalebes. Molfejque: ―¿Öquenu noso cuale momöquextis tlö ejqueu? ");
INSERT INTO nhgNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Entunses Jesús quemetztalutaya. Oquejtojque: ―Para tlöca abele, pero para Deus cuale mochihuas. Pos noche sösantle cuale quechihuasque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Entunses opie Piero tieyelfea: ―Xomojtele. Tejua otejcöjque noche sösantle hua ye temetzmotoquelejteneme. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Onöhuatihuac Jesús, oquejtoque: ―Melöhuac nemiechelfea: Öque cualcöjtiehuas ichö noso icnihua oquechte noso icnihua sohuame noso inöntzi noso itajtzi noso ipelhua noso itlölhua por nopampa naja hua por ipampa cuale tlamachestelestle, ");
INSERT INTO nhgNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ipa ini nönca tiempo quepeas sie sientos töntos de calte hua de icnihua oquechte, hua de icnihua sohuame hua de nönönte hua de ipejpelhua hua de tlölte, hua nuyejque giente quetepotztocasque. Hua ipa inu tiempo tli huölös quepeas nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero meyactie tli öxö cachto cate, sölúltimo yesque; hua tli sölúltimo cate, cachto yesque. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Bejbiloaya ipa ojtle tli tlejco ca ciudad de Jerusalén, hua Jesús quenyecönalutöya yejua. Quetietzöbejtaya hua quiejquech tietocaya majcömejque. Cuöc quenbicaque innochtie majtlactle huan ume nencua, opiehualuc quennunutzaloöya de noche tli tiepa mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","―Xequejtacö ―oquemelfejque―. Tetlejcotebe ca Jerusalén. Pos naja que onochi netlöcatl niechtiemöctisque ca jefes de teopexcötzetzi hua inca tlamachtiöneme de teotlajtule. Entunses yejua niechcuntenörusque ma nemeque. Niechtiemöctisque inca tli amo de topuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Yecuöquenu moburlörusque de naja hua niechchejchasque. Niechbitequesque hua niechmectisque. Cache sötiepa de yeye tunale ocsajpa neyulebes. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Entunses Jacobo ca Xohuö, ipelhua de Zebedeo, mopachojque tietlac. Tieyelfejque: ―Maestro, tejua tecneque xetiechmochibelele tli tejua tetlajtlanesque. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yejuatzi quemelfejque: ―¿Tli nenqueneque ma nemiechchibele? ");
INSERT INTO nhgNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yejua tieyelfejque: ―Pos xetiechmocöbele ma totlölicö ipa motlaniextelestzi, sente ca momöyecömpantzinco hua ocsente ca morabiescopantzinco. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yecuöquenu Jesús quemelfejque: ―Amo nenquemate tli nentlajtlane. ¿Cuale nenconisque de inu bölso de tietunie de tli naja neconis? ¿Noso cuale nemocuötiequisque ca inu tiecoco tli ica naja nocuötiequis? ");
INSERT INTO nhgNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yejua quejtojque: ―Cuale tecchihuasque. Pero Jesús quemelfejque: ―Tiel, de inu bölso de tietunie que naja neconis, nuyejque nenconisque nemejua, hua inu tiecoco tli ica nocuötiequis naja, ca inu nemocuötiequisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero para nemotlölisque sente ca nomöyecömpa hua ocsente ca norabiescopa, abele nemiechmacas. Cache icaca para yejua tli Deus quemixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Cuöc inu majtlactle oquecajque, opiejque cuajcualönque ca Jacobo hua Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jesús oquennutzque, hua quemelfejque: ―Ye nenquemate que niecate tli momajtecate tlötlajtoönejme de giente de ocseque naciones ca fuiersa quensujetöroa tlöca. Tli motztecate cache bejbeye intzölö, pos ca checöhualestle quenmandöroa giente. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero amo ejqueu ica nemotzölö nemejua, tlöcamo öque queneques cache bieye momajtas nemotzölö ma mosujetöro para nemiechtequepanus. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Öque beletes de nemejua queneques iyes cache importönte, ma iye quiename tlatequepano de nemonochtie. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pos nion naja que onochi netlöcatl amo nehuöla para ma giente ma niechtequepanucö naja, tlöcamo para nequentequepanus giente. Nehuöla para nectiemacas nonemeles para ejqueu nectlaxtlöhuas intlajtlacul de meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Entunses huajhualiloac ca puieblo de Jericó. Hua cuöc oquixoac Jesús de Jericó ca tiehua tiemachtejcöhua hua meyac giente, sente motlaijtlane ixcocoxque itucö Bartimeo yehuataya itienco ojtle. Inu Bartimeo oyeya iconie de Timeo. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Oconcac nele Jesús de puieblo de Nazaret niebiloatz. Bartimeo opie otzajtzec, hua quejtoöya: ―Jesús, iConie David, ma temetzmoyulcocolfe. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pos meyactie cajajuaya nele ma quetzacua icamac. Pero yaja cache tzajtzeya lalebes: ―IConie David, ma temetzmoyulcocolfe. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yecuöquenu Jesús onequetzaluc, hua oquejtojque: ―Xecnutzacö ma huöla. Yecuöquenu giente quenutzato ixcocoxque. Quelfejque: ―Xepajpöque. Xomoquetza porque metznutzalo. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yecuöquenu yaja quetlajcaltie ipelesol hua moquetztequis. Ohuöla tieca Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús onöhuatihuac, oquelfejque: ―¿Pos tli tecneque ma temetzchibele? Ixcocoxque otieyelfe: ―NoTiemachtejcötzi, ma netlachea. ");
INSERT INTO nhgNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Entunses Jesús quelfejque: ―Xebeya. Por tomoneltocac ye tepajtec. Pos sa nima ye tlacheaya. Entunses yaja tietocaya Jesús ca pa ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Huajhualiloac ipan puieblos de Betfagé hua Betania, itech tepietl de los Olivos, amo bejca de inu ciudad de Jerusalén. Jesús quentitlanque unte de tiemachtejcöhua, ");
INSERT INTO nhgNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","oquemelfejque: ―Xeyöcö ipa inu puieblo tli niepaca. San tequetl nencalaquesque, nenqueniextisque sente purojconetzi ilpetas. Ayemo öque ipa tlejco. Xectojtomacö hua xecualecacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tlö canajyeca nemiechelfis: “¿Tlica ejqueu nenquechihua?” xequelficö que: “Tlöcatzintle quenesesitöruro hua nima cualtitlanesque ocsajpa”. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Onyajque hua conniextejque purojconetzi ilpeteca queyöhuatiempa cöne posteque ojtle. Quetojtonque. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Entunses seque de tli ompa oyejyeya quemelfejque: ―¿Tli nemajaye nemejua nenquetojtontecate purojconetzi? ");
INSERT INTO nhgNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yecuöquenu yejua quemelfejque lo que tli Jesús quennahuatihuac ma quejtucö, hua ca inu concöjque ma quebicacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Yecuöquenu conhualecaque purojconetzi tieca Jesús. Ipa comentlölejque intlaquie hua yejuatzi ipa otlejcoac. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nuyejque meyactie quesoaya intlaquie pa ojtle. Ocseque quetejque imömöyö cuajme ca caltienco hua quesoaya pa ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tli oyöya adelönte hua tli hualtlatocatöya tzajtzajtzetöya: ―¡Osana! ¡Ma tetieteochihuacö öque biloatz tietucöyupa Tlöcatzintle! ");
INSERT INTO nhgNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Ma tetieteochihuacö öque hualtlamandörurus itucöyupa totajtzi David! Mojtoa ompa elfecac: “¡Osana!” ");
INSERT INTO nhgNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ocalacoac Jesús ipa Jerusalén ipan teopantle. Otlachealuc ca nobeyo ipa noche sösantle, hua obiloac ca Betania ca tiehua inu majtlactle huan ume. Pos lalebes ye yohuac oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pa mustlateca oquixoac de puieblo de Betania. Teosebihuaya Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Oquejtaque bejcateca sente icox cuabetl tli quepeaya ixejyo. Quejtaluto tlö quepeaya icox. Pero cuöc nepachuluc itlac, amo tli oqueniextejque tlöcamo sa ixejyo, porque ayemo tiempo para quepeas icox. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yecuöquenu Jesús oquelfejque icox cuabetl: ―Majcayec nionöque quecua fruto de taja. Tiemachtejcöhua oquecajque tli oquejtojque. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yecuöquenu huajhualiloac ca ciudad de Jerusalén. Yejuatzi ocalacoac ipan teopantle. Opiehualuc quenquextilo ca queyöhuac quiejquech tlajtlanamacaya hua quiejquech motlajtlacubiöya ipa teopantle. Quencuajxelfelejque inmiesa de tli quepatlataya tomi ca tiehua sietas de tli quennajnamacataya palumaxte. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amo quecöhualoöya ma canajyeca quebica xoctle ijtec teupa. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Quenmachtiloöya. Quenmelfiloöya: ―¿Amo melöhuac que tlajcuelulpanca ejqueyi? “Nocal mocuitis cale de netlötlajtelestle cöne motlajtlötlajtisque giente de noche naciones”. Pero nemejua nenconchijque tiecaltzi Deus quieme cana ustutl de ichtejcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Oquecajque noche jefes de teopexcötzetzi ca tlamachtiöneme de teotlajtule, hua quetiemoöya maniera para tiemectisque. Pos tiemabeliöya porque noche giente quetietzöbejtaya quiene ca tlamachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero cöra tunale cuöc ixtlayohua oyeya, yejuatzi hua tiemachtejcöhua oquejquixoac de inu ciudad. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cuöc opanuque ca ise, oquejtaque icox cuabetl ye uhuöc desde itech inelhuayo. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Yecuöquenu Piero quelnömec hua tieyelfejque Jesús: ―Maestro, xomojtele icox cuabetl tli tomotlabejbicaltele ye uhuöc. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Onöhuatihuac Jesús, oquemelfejque: ―Xomoneltocacö ca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Melöhuac nemiechelfea, que öque beletes quelfis ini nönca tepietl: “Xomojcuene hua xomotlajcale ijtec lamör”, hua amo moyulcuiecuectas tlöcamo moneltocas que mochihuas tli quejtoa, entunses de melöhuac inu mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Por inu nemiechelfea, cuöc nemotlötlajtisque, noche tli nentietlajtlanisque Deus, xomoneltocacö que ye nenqueselejque, hua ejqueu nenquepeasque. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Cuöc nemotlötlajtea, xomoperdonörucö tlö canajyetla nenquepea ca canajyeca, para nuyejque nemoTajtzi öque iloac elfecac nemiechperdonörfisque noche tli amo cuale nenquechihua. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Entunses huajhualiloac ocsajpa ca ciudad de Jerusalén. Cuöc nejnemoatenemeya ijtec teupa, ohuölajque tietlac jefes de teopexcötzetzi ca tiehua tlamachtiöneme de teotlajtule hua biebentzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tieyelfejque: ―¿Ca tli beletelestle tecchihua ini nönca sösantle? ¿Öquenu metzmacac beletelestle para tecchihuas ini nönca sösantle? ");
INSERT INTO nhgNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesús oquejtojque: ―Naja nemiechtlajtlanis sente pregunta. Xeniechnönquelicö, hua sötiepa nemiechelfis öque oniechmacac ini beletelestle para necchihuas nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Xohuö Bautista tlacuötiequiöya. ¿Beles Deus cualtitlanque ma tlacuötieque, noso tlöca cualtitlanque ma tlacuötieque? Xeniechnönquelicö. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yecuöquenu yejua monenebelejque. Molfejque: ―Tlö tequejtusque que Deus, yaja quejtus: “¿Tlica noso amo nemoneltocaque ca yaja?” ");
INSERT INTO nhgNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Pero tlö tequejtusquiöne que tlöca; pero abele tequejtusque. Pues yejua quenmabeliöya giente, porque giente quepensöroöya que Xohuö de melöhuac oyeya tlayulepante de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Entunses nöhuatque, tieyelfejque Jesús: ―Amo tecmate. Yecuöquenu Jesús oquemelfejque: ―Naja nuyejque amo nemiechelfis öque niechmacac beletelestle para ma necchihua ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Entunses opiehualuc Jesús quennunutzaloöya ca cuientos. Oquejtojque: ―Sente tlöcatl quetucac huierta de uvas temecatl. Quesiercajte ca cuajme. Quechejchi sente tönque cöne quepötzcas uvas. Quechejchi sente cale bejcapa. Quentlaniejte tejtequetque, hua yaja uya ca bejca. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","’Pos ca tiempo cualtitla sente itlatequepano inca inu tequetque para ma quemacacö de inu fruto de inu huierta. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero yejua ocaseque, quebitejque, hua quetitlanque sin niontle. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ocsajpa quehualentitlanele ocsente tlatequepano. Pero yaja quecocojque pa itzonteco hua quetratörojque san petzotec. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ocsajpa quehualentitlanele ocsente, pero inu nieca quemectejque. Ocseque meyactie quehualentitlanele. Pero inu tequetque quenbitejque seque hua ocseque quenmejmectejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Inu tlöcatl öque ihuöxca tlöle oquepex sa sente itlasojcöconie. Pos ca sölúltimo nuyejque cualtitla iconie ca inu tequetque. Oquejto: “Beles pa quejtasque noconie”. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero inu tequetque omolfejque: “Yaja ini öque mohuöxcatis de ini nönca huierta. Xehuölöcö, ma tecmecticö. Entunses tli yaja mohuöxcatisquea tohuöxca iyes”. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ocaseque hua quemectejque. Quequextejque icuierpo ca queyöhuac de inu huerta. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","’¿Tli noso ayes inu tlöcatl öque ihuöxca inu huierta? Pos huölös quenpojpoluqui niecate tequetque, hua inu huierta quenxiexelfis ocseque. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Quie amo quiema nenquetlajtultejque ini teotlajtule? Inu tietetu tli calchihuaneme quetlabielcöjque, ");
INSERT INTO nhgNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","yaja mismo omochihuaco esquiniero principal. Yejuatzi Tlöcatzintle oquechijque ini nönca, hua tejua tectietzöbea. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Entunses inu joriojte quetiemoöya maniera para tieasesque Jesús, porque yejua casojcömateya que ca nieca cuiento tlajtlajtuloöya de yejua. Pero yejua quenmabeliöya giente. Yaja ica tiecöjtiejque hua onyajque. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yejua quentitlanque tietlac seque fariseos ca tiehua herodianos tli quetocaya rey Herodes, para abier tlö quejtusque canajyetla tli itech cuale tietieyelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ohuölajque hua tieyelfejque: ―Maestro, tejua tecmate que tejuatzi tomobetzteca temelactec, hua lalebes tomocualejtelea tlin melöhuac, hua amo tomotlachilejtzinoa de nionöque. Porque tlöca amo metzmoimportörfea tlö rico tlö porube tlö quiene, tlöcamo de melöhuac tequenmojtetelea ojtle de Deus. ¿Beles conbenierebe tecmacasque inu emperador César tocontribuseyo noso amo? ¿Tecmacasque noso amo tecmacasque? ");
INSERT INTO nhgNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pos yejuatzi casojcömatihuataya quiene yejua quepeaya ume inxöyac. Quemelfejque: ―¿Tlica nenniechproböroa naja? Xeniechhualequelicö denario tomi ma nequejta. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yejua tiehualequelejque. Yejuatzi quemelfejque: ―¿Öqueniji ixöyac, hua öquenu ihuöxca tlajcuelule? Yejua tieyelfejque: ―De César. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Onöhuatihuac Jesús, quemelfejque: ―Xecmacacö César tli quetocöroa César, hua xetiemacacö Deus tli tietocöroa Deus. Pos quetietzöbejque quiene onöhuatihuac. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Entunses ohuölajque tietlac seque saduceos, öque yejua quejejtoa nele mimejque amo yulebesque. Yejua tietlajtlanejque, tieyelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Maestro, Moisés otiechejcuelfe nele tlö icni de sente tlöcatl omec quecöjtie isohua pero amo quencöjtie ipelhua, nele icni ma case isohua para quentlöcatelelis ipelhua de icni. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bieno. Oyejyeya checume icnijte. Inu cachtojyebe oquepex isohua. Pero cuöc omec amo quencöjtie pelantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ocsente icni oquepex isohua. Nuyejque omec. Nimpor nieca amo quencöjtie pelantzetzi. Entunses inu tercero icni nuyejque ejqueu ipa omochi. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pos noche checumeme amo quencöjtiejque pelantzetzi. Hua sötiepa de que innochtie omejmejque, inu sohuatl nuyejque omequeco. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Cuöc mochihuas yulebelestle hua yulebesque mimejque, ¿cötlaja de yejua iyes isohua ini nönca sohuatl? Pos innochtie checumeme quepexque inu sohuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Entunses Jesús quemelfejque: ―Sa por ini nönca nemixcajcayöhua, por que amo nenquemate tli tlajcuelulpanca hua tli tiechecöhuales Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pos cuöc yulebesque de intzölö mimejque nimpor amo mososohuajtisque nimpor amo monömectisque, tlöcamo yesque quieme inu öngeles tli cate elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero mimejque quiema yulebesque. ¿Amo nenquetlajtultea lo que tli oquejcuelo Moisés cöne tlajtoa de inu tebetztle? Quejtoa quiene Deus quenunutzque yaja, hua oquelfejque: “Naja necaca neDeus de Abraham, hua neDeus de Isaac, hua neDeus de Jacob”. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yejuatzi amo iloac Deus de mimejque tlöcamo iloac Deus de tli yulejtecate. Nemejua lalebes nemixcajcayöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Entunses omopacho sente de inu tlamachtiöneme de teotlajtule. Yaja oquecac quiene mixcomacataya ca Jesús. Oquemat que yejuatzi quennönquelejque cuale. Entunses tietlajtlane: ―¿Cötlaja mandamiento cache bieye icaca de noche? ");
INSERT INTO nhgNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesús quenönquelejque: ―Mandamiento tli cache bieye yaja ini: “Xejcaque, Israel. Yejuatzi Tlöcatzintle toDeus sa sietzi iloac. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tetietlasojtlas Tlöcatzintle moDeus ca noche sentetl moyulo, ca noche sentetl moölma, ca noche mopensamientos, hua ca noche mochecöhuales”. Cache bieye ini nönca mandamiento que noche ocseque. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hua inu segundo yaja ini nönca: “Tectlasojtlas motlöcaicni quiename taja tomotlasojtla”. Amo onca ocsente mandamiento ma cache bieye iye. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Entunses inu tlamachtiöne de teotlajtule tieyelfe: ―Lalebes cuale, Maestro. Tehualmojtalfe tlin melöhuac, nele sa sietzi toDeus, hua amo onca ocsente cache de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nele tetietlasojtlasque ca noche sentetl toyulo, ca noche topensamientos, hua ca noche tochecöhuales, hua tectlasojtlasque totlöcaicni quiename tejua mismo totlasojtla. Cache cuale öque quechihuas ini que tlö quejtus quetlölis bentle tli xutla ca tiehua cuetlabiltelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús quecajque quiene ca tienönquele lalebes cuale. Quelfejque: ―Amo bejca tecaca de tecalaques cöne Deus tlamandöruro. Yecuöquenu nionöque ayecmo matrebieroöya para tietlajtlanes cache. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús tlamachtiloöya teupa. Quejtuloöya: ―¿Quiene quejtoa tlamachtiöneme de teotlajtule nele Cristo, öque Deus quixpejqenque, icaca iconie David? ");
INSERT INTO nhgNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Pos David otlajtlajto por Espíritu Sönto, hua oquejto: Tlöcatzintle tiemolfeliluc noTlöcatzintle: “Xomotlöle ca nomöyecömpa hasta senamo ma nequemumiyöro moenemigos hasta itzintla mocxehua”. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Tlö quejtus mismo David quecuitea Cristo Tlöcatzintle, ¿quiene noso iyes iconie? Hua inu giente tiecaqueya ca meyac gönas. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Quemelfiloöya cuöc tlamachtiloöya: ―Xecpeacö cueröro de tlamachtiöneme de teotlajtule, porque yejua mochajchamöhua yajtenemesque ca bejfeye intlaquie. Quepea gusto ma giente ma quenyectlajpalucö ipa plösa. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Seme quetiemoa tlaixpa yesque ipa teopancucone, hua cöne tlajtlacua quetiemoa tli cache cuajcuale locör. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Motejtechtea inchajchö de icnusohuame. Hua para nieses que lalebes cualteque cate, motlötlajtea lalebes meyac tiempo. Pero impa ini nöncate huölös cache bieye incastigo. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yehualutaya Jesús itlac caxu cöne quetiemaya tomi para bentle. Quejtaloöya quiene noche tlöca quetlöliöya tomi ijtec caxu. Meyactie tli ricojte quetiemaya meyac. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ohuöla sente icnusohuatl porube. Contlöle ume tomi tzequetzetzi, tli sa balierebeya sie quinto. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yecuöquenu Jesús quennutzque tiemachtejcöhua. Quemelfejque: ―Melöhuac nemiechelfea, que ini nönca icnusohuatl tli porube oquetlöle cache meyac que noche ocseque tli oquetienque ijtec caxu. ");
INSERT INTO nhgNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pos noche yejua quetlölejque sa tli subra, pero ini icnusohuatl mös lalebes porube oquetlöle noche tli quepeaya, hua yaja amo tli mocöbe tli quecuös. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Cuöc oquixoac Jesús de teupa, tieyelfe sente de tiemachtejcöhua: ―Maestro, xomojtele cualtzetzi teme, hua cualtzetzi calme. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús onöhuatihuac, oquelfejque: ―¿Tequemejta nöncate calme ca bejbeye? Amo mocöhuas necö tietetu ipa tietetu, tlöcamo noche yecxexetunes. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Netlöliluc ipa tepietl de los Olivos ixtla teupa. Cuöc tieinsiel tietlajtlanejque Piero hua Jacobo ca Xohuö hua Andrés: ");
INSERT INTO nhgNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xetiechmolfele, ¿quiema mochihuas ini nönca sösantle? ¿Tli sieña oyes cuöc noche ini sösantle miero mochihuati? ");
INSERT INTO nhgNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús opiehualuc quemelfiloöya: ―Xomotlachilicö majcamo yeca nemiechcajcayöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Huölösque meyactie notucöyupa. Quejtusque: “Naja neCristo”. Pos quencajcayöhuasque meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Pero cuöc nenquecaquesque de guierras noso cuöc tlapubelea que oyes guierra, majcamo xomotequepachucö, porque ejqueu quepea que mochihuas. Pero ayemo tlames tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pos majcoques nación cuntra nación, hua igiente de sente rey cuntra igiente de ocsente rey. Tlaolines ca nobeyo hua giente öpesmequesque. Ca nönca sösantle piehuas tiecoco tietunie. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Pero xomotlachilicö sie nemejua, porque nemiechtiemöctisque inca tlötlajtoönejme. Pa teopancucone nemiechbitequesque. Hasta imixtla cubernadurte hua imixtla reyes nemiechbicasque nopampa. Hua ejqueu nentlatesteficörusque inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero antes de inu moneque que inu cuale tlamachestelestle ma monunutza ca giente de noche naciones. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pero cuöc nemiechbicasque para nemiechtiemacasque, amo xomotequepachucö por tli nenquejtusque nimpor tli nenquepensörusque. Pos sa lo que tli Deus nemiechmacasque ipa inu nieca ura, inu xequejtucö. Porque amo nemejua nentlajtlajtusque, tlöcamo yejuatzi Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pa inu niecate tunalte, icni quetiemöctis icni ma meque. Tajtle quetiemöctis iconie. Inpejpelhua quencuajnömequesque intötajua hua quenmejmectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nemiechtlajyelejtasque noche giente por nopampa. Pero öque quexicus hasta cöne tlames, yaja inu momöquextis. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’Pos nenquejtasque inu tli san petzotec tlaxexetotzas, hua moquetzas ipa locör cöne amo conbenierebe ma iye. ―Öque quetlajtultea ömatl, ma casojcömate―. Cuöquenuju quiejquech yesque ipa Judea ma cholucö hasta ipa tepieme. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Öque iyes icpac cale majcamo temo nimpor majcamo calaque icalejtec para quequextiti canajyetla. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Öque iyes ca caltienco majcamo mocuepa ca ichö para cönati ipelesol. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Ay, porubejte quiejquech tli uutzte hua tli tlajtlabepöjtecate ipa inu niecate tunalte! ");
INSERT INTO nhgNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xomotlajtlötlajticö noso para amo nenchölusque ipa mietztle cuöc cache siehua. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porque ipa inu niecate tunalte iyes tietunie tli ayec omochi desde opie noche sösantle tli Deus oquechejchijque hasta öxö. Nimpor ayecmo mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Tlö quejtus Tlöcatzintle amo quechihualoöne inu tiempo ma iye tzitzequetzi, nion sente tlöcatl amo momöquextisquiöne. Pero por impampa yejua tlaixpejpeme, öquemeju Deus quemixpejpenque, yejuatzi oquechijque ma iye tzitzequetzi inu tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Yecuöquenu, tlö quejtus canajyeca nemiechelfis: “Xequejtacö, nöiloac Cristo”, noso “Xequejtacö, ca niepa iloac”, amo xomoneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pos majcoquesque Cristos hua tlayulepantejque tli amo de melöhuac. Quechihuasque meyac sieñas hua tietzöbeme para hasta quencajcayöhuasque giente tli Deus quemixpejpenque, tlö cuale quencajcayöhuasquiöne. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero nemejua xomotlachilicö. Ye nemiechelfea noche antes de que mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Pero ipa niecate tunalte sötiepa de inu tiempo de tiecoco tietunie, tunale tlajtlayohuas hua mietztle ayecmo mietztunas. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sitlalte betzesque de elfecac, hua inu sösantle checöjque tli oncate ipa elfecac moulinisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Yecuöquenu giente quejtasque cuöc naja que onochi netlöcatl nehuölös ipa mextle ca meyac checöhualestle hua tlaniextelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yecuöquenu necualentitlanes noöngeles, hua quiejquech tlöca nequemixpejpe nequensentlölis de ca nobeyo desde cöne tlame tlöltecpactle hasta cöne tlame elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Itech icox cuabetl xectzecucö sente ejiemplo. Cuöc ye selea imömöyo hua ye quisa ixejyo, nenquemate que ye asequi xupantla. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ejqueu nuyejque nemejua, cuöc nenquejtasque que ye mochijteca ini nönca sösantle, xecmatecö que ye aseco tiempo hua que ye nemotlanca. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Melöhuac nemiechelfea, amo mequesque innochtie giente tli öxö nentecate hasta senamo mochihuas ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Elfecac hua tlöltecpactle tlamesque, cache notlajtul amo tlames. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Pero de inu nieca tunale hua de inu nieca ura nionöque amo quemate, nimpor öngeles tli cate elfecac nimpor tieConietzi, tlöcamo sa Tajtle. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Xomotlachilicö noso, hua xetlachixtöcö, porque amo nenquemate quiema asequi inu tunale. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pos inu tunale icaca quieme cana sente tlöcatl tli uya bejca. Quecöjtie ichö. Quenmacatie tli ayesque itlatequepanojua. Pos quenmacatie cöra sesen tlöcatl iteque, hua queyöhuatientlajpexque quenahuatejtie nele ma tlachixta. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xetlachixtacö noso, porque amo nenquemate quiema huölös chöne de inu cale, tlö quejtus cuöc ixtlayohua cox ca tlajco yohuac cox cuöc tzajtzes canteliex noso cox ca ise. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Xetlachixtacö para majcamo nemiechase nencojcochtecate cuöc sa de repiente huölös. ");
INSERT INTO nhgNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pos lo que tli nemiechelfea nemejua, nequemelfea innochtie giente: Xetlachixtacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sötiepa de ume tunale omochi pöscua hua yelfetl de pöntzi tli amo quebica levadura. Jefes de teopexcötzetzi ca tiehua tlamachtiöneme de teotlajtule quetiemoöya quiene cuale tieasesque ca möñas hua tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Quejtoöya: ―Amo tecasesque ipa yelfetl, para majcamo cana cuejcueyunecö giente. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Hua iloaya yejuatzi ipa puieblo de Betania ipa ichö Semu öque sa söhuayo. Ompa tlacualutaya cuöc ohuöla sente sohuatl. Quehualecaya sente potixajconetzi de alabastro tli quepeaya pajtle ajfeyoc de nochaja nardo, pateyo lalebes. Quetlajtlapö inu potixajconetzi de alabastro hua noche oquemejmelo ipa tietzonteco. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Hua seque cuajcualönque. Quejtojque entre yejua: ―¿Tli para oniempole ini nönca pajtle de nardo? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ini nönca cuale monamacane ca más de yeye sientos denarios tomi hua cuale moxiexeloöne ca tli porubejte. Opiejque cajajuaya inu sohuatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús oquejtojque: ―Xejcajcöhuacö. ¿Tlica nenquepasoloa? Ara ca cuale tli niechhualchibele. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nochepa nenquenpea porubejte nemotzölö. Cuöc nenquenequesque, cuale nenquechihuasque tlin cuale inca yejua. Cache naja amo nochepa nenniechpeasque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nönca sohuatl oquechi tli yaja opodiere. Yaja ye quetlölele nocuierpo inu pajtle ajfeyoc de nardo para cuöc notlölpachus. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Melöhuac nemiechelfea, que cöne beletes tlanunutzasque de ini nönca cuale tlamachestelestle ipa noche tlöltecpactle, nuyejque ini nönca lo que tli oquechi ini sohuatl mojtus para quelnömequesque giente de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Entunses Judas Iscariote, sente de inu majtlactle huan ume tiemachtejcöhua, uya intlac jefes de teopexcötzetzi, porque oquenec tietiemacas Jesús inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cuöc yejua oquecajque, oquepexque pöquelestle. Queprometierojque quemacasque mieleyo. Pos Judas quetiemoöya quiene cuale tietiemacati. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ipa primiero tunale de yelfetl de pöntzi sin levadura, cuöc quenmejmectiöya calnielojcucone para bentle de pöscua, tiemachtejcöhua tieyelfejque: ―¿Cöne tomonequitea ma tetlapreparörucö para ma xomotlacualte inu tlacuale de pöscua yelfetl? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yejuatzi quentitlanque unte de tiemachtejcöhua. Quemelfejque: ―Xeyöcö ipa puieblo hua nemiechnömeques sente tlöcatl tli quebica sente öcumetl ca ötzintle. Xectocacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hua cöne calaques, xequelficö inu chöne: “Maestro quejtulo: ¿Cönenca cale cöne nejcuös inu tlacuale de pöscua yelfetl ca nomachtejcöhua?” ");
INSERT INTO nhgNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Pos yaja mismo nemiechejtetis sente bieye cuörto icpac cale que oyes listo hua tli quepeas noche tli tecnesesitörusque. Ompa xetlamömanacö para tejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Entunses uyajque tiemachtejcöhua hua ocajcalajque ipa puieblo. Oqueniextejque san quiene ca quemelfejque. Hua ompa otlamömanque para pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cuöc ye yohuac oyeya, hualiloac ca inu majtlactle huan ume tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yehualutaya itlac miesa hua mientras tlajtlacualutaya, oquejtojque Jesús: ―Melöhuac nemiechelfea, que sente de nemejua öque tlacua ca naja niechantrecöruti. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yecuöquenu yejua ocaseque tequepachule hua tieyelfiöya cara sesen tlöcatl: ―¿Beles naja? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Hua yejuatzi quemelfejque: ―Icaca sente de nemejua nenmajtlactle huan ume. Icaca yaja öque noca tlapaloa ijtec nocasfiela. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pues naja que onochi netlöcatl nemeques san quiene ca tlajcuelulpanca de naja. Pero ¡porube de inu tlöcatl tli niechantrecörus naja que onochi netlöcatl! Cache cuale uyesquea para yaja ma ayec tlöcatene. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mientras tlajtlacualutaya, Jesús ocönque pöntzi, hua queteochijque. Quecojcotunque hua quenmacaque. Oquejtojque: ―Xecönacö. Nönca pöntzi ica nocuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Yecuöquenu ocönque sente bölso hua tietlasojcömacheliluc. Oquenmacaque. Entunses oconique innochtie de inu bölso. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Oquemelfejque: ―Yaja ini *ica noyeso. Necmaca para ma mochihua sente acuierdo entre Deus hua tlöca. Nocuierpo yesquisas por impampa meyactie giente. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Melöhuac nemiechelfea que ayecmo quiema neconis iöyo de uvas hasta ipa inu nieca tunale cuöc neconis inu vino yancuec tli onca cöne tlamandöruruteca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hua ocuejcuicoac sente cuicatelestle, hua oquejquixoatie, bejbiloac ipa tepietl de los Olivos. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Hua quemelfejque Jesús: ―Noche nemejua nenbetzesque ipa tlajtlacule nopampa. Pos tlajcuelulpanca: Nejcocus calnielojpexque hua calnielojte mocuasemanasque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Cache sötiepa cuöc neyulebes, neyös delante de nemejua hasta pa estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yecuöquenu Piero tieyelfe: ―Mös noche ocseque betzesque, cache naja amo. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Hua quelfejque Jesús: ―Melöhuac temetzelfea, que öxö mismo ipa ini nönca yohuale, antes tzajtzes canteliex ujpa, taja tequejtus yexpa que amo teniechixomate. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Cache yaja oquesequiro lalebes tlajtlajtoöya: ―Mös cana nemeques ca tejuatzi, pero amo temetzmonegörfis. Innochtie ejqueu nuyejque quejtoöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pos ohuajhualbiloac ipa locör itucö Getsemaní. Quemelfejque tiemachtejcöhua: ―Xomotlölicö necö, mientras naja notlötlajtiti. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hua quenbicaque Piero, Jacobo, hua Xohuö. Opiehualuc netequepachuloöya lalebes, hua lalebes quiene oquechi tieyulo. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Quemelfejque: ―Lalebes meyac tequepachule quepea noölma, hasta sana nemequesneque. Xomocheacö necö hua xetlachixtacö. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Entunses obiloac cache adelönte. Netlancuöquetzaluc ipan tlöle, hua netlötlajtiluc mach tlö cuale, majcamo tiepa mochihua pa nieca ura lo que tli mochihuati. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Quejtuloöya: ―Abba, noTajtzi, para tejuatzi noche sösantle cuale mochihuas. Xomojcuenele nönca bölso de tietunie majcamo niechtocöro. Pero majcamo mochihua tli naja necneque tlöcamo tli tejuatzi tomonequitea. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Hua hualiloac hua quenniextiluco cojcochtecate. Quelfejque Piero: ―Semu, ¿tecochteca? ¿Abele tetlachixtas nion sie ura? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xetlachixtacö hua xomotlötlajticö, para majcamo nemiechyulmajmötoca Amo Cuale Tlöcatl. Melöhuac toyulo cuejcuesebe, cache tonacayo débil icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hua obiloac ocsajpa. Netlötlajtiluc, hua ocsajpa oquejtojque mismo tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Cuöc ocsajpa hualiloac, quenniextiluco cojcochtecate porque lalebes cojcochesnequeya. Pos amo quemateya quiene tienönquelisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Hualiloac ca yexpa. Quemelfejque: ―Bieno. Xecojcochecö hua xomosiebicö. Basta ca inu. Ye aseco ura. Xequejtacö. Pos naja que onochi netlöcatl öxö niechtiemöctisque inmöpa tlajtlaculteque tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Xemiehuacö. Teyabe. Öque niechtiemöctis ye ompabitz. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cuöc yejuatzi oc tlajtlajtulutaya, nima ohuöla Judas, sente de inu majtlactle huan ume tiemachtejcöhua de Jesús. Ca Judas ohuölajque meyac giente ca espödas hua cuabetl. Huölajque porque jefes de teopexcötzetzi hua tlamachtiöneme de teotlajtule hua biebentzetzi cualentitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Antes que Judas tietiemöcte Jesús, quemelfe inu tlöca de sente sieñas. Oquejto: ―Öque necpetzus, yaja inu icaca. Xecasecö hua xecbicacö sin fölta. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pos yaja ohuöla, nima omopacho tietlac. Tieyelfejque: ―NoTiemachtejcötzi. Hua tiepetzo. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yecuöquenu yejua tieaseque hua tiebicaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero sente de tli ompa ijcataya quequexte iespöda. Conmacac itlatequepano de tlajtojcöteopexque. Pos quetejtequele inacas. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Onöhuatihuac Jesús, quemelfejque: ―¿Nenhualiejque ca espödas hua ca cuabetl quieme cana cuntra sente ichtejque para nenniechasesque? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Cöra tunale neyeya nemotlac netlamachtiöya ipan teopantle. Pos amo nenniechaseque. Pero ejqueyi moneque para ma mochihua tli tlajcuelulpanca ipa teotlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Entunses tiecöjtiejque noche tiemachtejcöhua. Chucholojque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero sente peltuntle tietocaya. Motlaquentejtöya sa ca sente bieye tatapajtle. Pos yejua caseque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero yaja quencöbelejtie tatapajtle. Cholojtie xipetztec. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Entunses tiebicaque Jesús itlac tlajtojcöteopexque. Mosentlölejque ca yaja noche jefes de teopexcötzetzi ca tiehua biebentzetzi hua tlamachtiöneme de teotlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pos Piero tietocaya bejcateca hasta ocalac ipa pötio de ichö de tlajtojcöteopexque. Ompa Piero yehuataya ca yejua de guardia. Mototunejtaya itlac tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hua inu jefes de teopexcötzetzi ca tiehua noche inu junta quetiemoöya arasu cuntra Jesús para tiemectisque. Pero amo yetla queniextiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Porque meyactie quejtoöya istlacatlajtule cuntra yejuatzi pero imistlacatlajtul amo oyeya de acuierdo. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Entunses majcojque seque. Yejua istlacatque cuntra yejuatzi. Quejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Tejua otejcajque cuöc oquejto: “Pos naja necxexetunes ini nönca teopantle tli tlöca conchejchijque, hua ipa yeye tunale necajcoques ocsente tli amo yeca tlöcatl oquechejchi”. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero nimpor ejqueu amo oyeya de acuierdo tli quejtojque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yecuöquenu tlajtojcöteopexque omoquetz nepantla. Tietlajtlane Jesús, otieyelfe: ―Pos ¿amo yetla tenöhuates? ¿Tlininu noso quemelöjcöpujtecate de taja? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero yejuatzi quetzacualoöya tiecamac, hua amo tli quejtuloöya. Tlajtojcöteopexque ocsajpa tietlajtlane, otieyelfe: ―¿Taja tecaca teCristo, tetieConietzi Deus Bendito? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús quelfejque: ―Naja necaca. Nenquejtasque que naja tli onochi netlöcatl neyehuatas ca tiemöyecmö de Deus öque quepealo checöhualestle. Naja que onochi netlöcatl nehuölös de elfecac ica mextle. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Entunses tlajtojcöteopexque quetzotzomotz itlaquie. Oquejto: ―¿Tli para cache tecneque öque tiechmelöjcöpubelis? ");
INSERT INTO nhgNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ye nenquecajque quiene checuatlajtoa cuntra Deus. ¿Tli nenquejtoa? Pos innochtie quenejque ma mecoa. Quejtojque que quemeresieruroöya mecoas. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yecuöquenu seque opiejque chejchejcha tiepa. Tieixtlapachojque hua tiemacaque checöhuac. Tieyelfiöya: ―¡Xetlayulepante! Hua tietiemacaque ca inu guardia, hua yejua tiecamatlatzcuepuniöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Cuöc Piero oyeya tlölpa pa pötio, ohuöla sente sohuatl itlatequepano de tlajtojcöteopexque. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Cuöc oquejtac Piero mototunejtaya, quetztaya hua oquejto: ―Taja nuyejque oteyeya ca inu Jesús de puieblo de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero yaja oquenegöro, oquejto: ―Amo nequixomate nimpor amo necmate tli tequejtoa. Oquis ca queyöhuac cöne queyöhuatientle. Yecuöquenu otzajtzec canteliex. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Inu sohuatl tli tlatequepanoöya oquejtac Piero ocsajpa. Opie quemelfiöya tli ompa oyejyeya: ―Ini nönca de yejua icaca. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero yaja ocsajpa oquejto que amo tieixomatiöya. Tepetzi bejcöjpa, quiejquech ompa oyejyeya quelfejque Piero: ―Melöhuac taja tecaca de yejua porque taja tecaca tegalileo. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Entunses yaja opie motlabejbicaltiöya sie yaja. Oquejtoöya: ―¡Paltzinco! Amo nequixomate ini nönca tlöcatl de öque nemejua nentlajtoa. ");
INSERT INTO nhgNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hua sa nima otzajtzec canteliex ca ujpa. Entunses Piero omolnömec de inu tlajtule, quiene quelfejque Jesús: “Antes tzajtzes canteliex ujpa, tequejtus yexpa que amo teniechixomate”. Oquelnömec, hua opie ochucaya. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Cualco ca ise, inu jefes de teopexcötzetzi ca biebentzetzi hua tlamachtiöneme de teotlajtule hua noche inu junta quetzontejque tli quechihuasque. Tieilpejque Jesús hua tiebicaque tietiemacato ica Pilöto. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilöto tietlajtlane: ―¿Taja terey de joriojte? Onöhuatihuac yejuatzi, quelfejque: ―Ica melöhuac tli tequejtojteca. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pos jefes de teopexcötzetzi tietieyelfiöya de tlimach. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ocsajpa tietlajtlane Pilöto. Otieyelfe: ―¿Amo tli tenöhuates? Xequejta de meyac sösantle metztieyelfejtecate. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús ayecmo nöhuatihuac. Así es que Pilöto quetietzöbejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Öxö, miero pan yelfetl, seme quecajcöhuaya sente prieso tli quetlajtlaneya yejua. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Oyeya sente itucö Barrabás, tzactaya ca noche ocseque tli tlamejmectejque cuöc omajcojque cuntra cubierno. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huölajque meyactie tlöca. Opiejque quelfea Pilöto nele ma quenchibele inu favur tli quepeaya costumbre quenchibelejtebitz. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilöto onöhuat, quemelfe: ―¿Nenqueneque ma nejcajcöhua ca nemejua ini Rey de joriojte? ");
INSERT INTO nhgNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Porque yaja quemateya que por envidia tietiemacaque jefes de teopexcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero jefes de teopexcötzetzi quemelfejque noche giente nele cache cuale ma quecajcöhuacö yaja Barrabás. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Entunses onöhuat Pilöto ocsajpa. Quemelfe: ―¿Tli noso nenqueneque necchibelis nönca tlöcatl tli nenquecuitea Rey de joriojte? ");
INSERT INTO nhgNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pos yejua ocsajpa tzajtzajtzeque: ―¡Xomocoruspelfe! ");
INSERT INTO nhgNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilöto quemelfiöya: ―¿Tlica? ¿Tli mal oquechi? Pero yejua cache tzajtzajtzeya lalebes: ―¡Xomocoruspelfe! ");
INSERT INTO nhgNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Yecuöquenu Pilöto, para quencontentörus giente, quencajcöbele Barrabás. Cuöc ye quemandörojque ma tiebitequecö Jesús, tietiemacac para ma tiecoruspelucö. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Entunses soltörojte tiebicaque ca tlaijtec pa pötio itucö pretorio. Mosentlölejque noche inu grupo de soltörojte. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tietlaquentejque Jesús ca sente tzotzomajtle morörojtec quiename möquea reyes. Quechejchijque sente coruna de betztle, hua tietlölelejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nima opiejque tietlajpaloöya: ―¡Xeneme, Rey de joriojte! ");
INSERT INTO nhgNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Tiemacaque ipa tietzonteco ca sente uhuatl. Chejchaya tiepa. Motlancuöquetzque para tiemabesutiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Cuöc ye tieca opajpöjque, tiequextelejque tzotzomajtle morörojtec. Entunses tietlaquentejque ca tietzotzomajua. Yecuöquenu tiequextejque para tiecoruspelutibe. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ompa panuya sente tlöcatl itucö Semu, tli oyeya de sente nación itucö Cirene. Pos yaja Semu, itajtzi de Alejandro hua Rufo, huölöya de caltienco. Pos quechihualtejque ma quebica tiecorujtzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tiebicaque pa locör itucö Gólgota. Quejtusneque Locör de Mejcötzontecomatl. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tiemacasquiöya vino tli quenelultejque ica mirra ajfeyoc. Pero yejuatzi amo conihuac. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Hua tiecoruspelojque, hua quexiexelojque tietlaquie. Queriförojque, abier tli quebica cara sente. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Oyeya quieme pa checnöbe ura cuöc tiecoruspelojque. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Hua quejcuelojque tli ipampa tiecoruspelojque. Quejcuelojque ejqueyi: “REY DE JORIOJTE”. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Quencoruspelojque nuyejque tiehua unte ichtejque, sente ca tiemöyecmö, hua ocsente ca rabiescopa. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Hua tli pajpanutöya tiechecuayelfiöya. Mocuajcuöyecachoöya. Tieyelfiöya: ―¡Ja! ¡Taja! Taja otequejto que tecxexetunis teopantle hua pa yeye tunale tecajcoques. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Abier xomomöquexte sie taja, hua xetemo de ipan corujtzi. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pos ejqueu nuyejque jefes de teopexcötzetzi tieca opajpöjque. Molfiöya sie yejua ca tiehua tlamachtiöneme de teotlajtule: ―Ocseque quenmöquexte, pero sie yaja abele momöquextea. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Inu Cristo, Rey de Israel, ma temo öxö de ipan corujtzi para tequejtasque. Entunses toneltocasque. Nuyejque inu unte tli coruspelcataya ca yejuatzi tlimach tieyelfiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Miero pan tlajca otlayohuac ipa noche tlöltecpactle hasta senamo quemacac yeye ura. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pa yeye ura, tzajtzihuac Jesús checöhuac: ―Eloi, Eloi, ¿lama sabactani? ―Quejtusneque: NoTeotzi, noTeotzi, ¿tlica tomoxelojtzino de naja? ");
INSERT INTO nhgNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Cuöc quecajque seque tli ompa oyejyeya, quejtoöya: ―Xejcaquecö. Quetzajtzelea inu tlayulepante Elías. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Omomerö sente. Quetlöle sente estropöjo ipa sente öcatl hua quepaltele ca pinögre. Tiemacac ma conihua. Oquejto: ―Xomocöbelicö. Tequejtasque abier tlö yebitz Elías para quetemubiqui. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero Jesús tzajtzihuac checöhuac hua omecoac. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yecuöquenu inu cortina de teopantle otzomu. Opie de tlacpac para ca tlölpa. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Inu capetö tli oyeya tieixpa yejuatzi, cuöc oquejtac quiene omecoac, oquejto: ―Melöhuac ini nönca tlöcatl oyeya tieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nuyejque ompa oyejyeya sohuame tlajtlachixtaya bejcateca. Intzölö oyeya Salomé hua María de puieblo de Magdala ca tiehua María inöntzi de Jacobo tzitzequetzi hua de Josie. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ini nöncate tietocatenemeya cuöc Jesús iloaya ipa estado de Galilea. Tietequepanoöya. Nuyejque ompa oyejyeya ocseque meyactie tli tietlamachtocaya cuöc otlejcoac ca Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ye ixtlayohua oyeya. Mopreparöroöya joriojte para mustlateca mosiebisque. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ohuöla sente tlöcatl itucö Josie tli oyeya de puieblo de Arimatea. Yaja oyeya cualtien tlöcatl, hua miembro de inu grupo de tlötlajtoönejme de joriojte itucö Sinedrio. Josie nuyejque quemöchixtaya ma hualtlamandörucö Deus. Sin pinöhualestle ocalac itlac Pilöto. Quetlajtlaneto tiecuierpo Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pos Pilöto quetietzöbejtac cuöc oquemat que ye omecoac Jesús. Entunses Pilöto oquenutz capetö de soltörojte. Quetlajtlane tlö melöhuac ye yecsa omecoac. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Cuöc quemacheste capetö nele ye omecoac, quetiemacac tiecuierpo ica Josie. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pos Josie ye oquecu sente tzotzomajtle de lino yancuec. Quetemobe tiecuierpo Jesús. Quequemelo ca inu tzotzomajtle. Quetlöle ijtec sente mejcöustutl tli ye omotatac itech tepetlatl. Quememelo sente tietetu hua ica quetlapacho inu ustutl. ");
INSERT INTO nhgNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María de puieblo de Magdala hua María inöntzi de Josie oquejtaque cöne tietlölejque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Opanuc tunale que mosiebejque joriojte. Salomé hua María de puieblo de Magdala hua María inöntzi Jacobo oquecujque pajtzetzi tli ajfeyoc para tietlölelitibe. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Cuöc ye oquis tunale ca ise cualco pa primiero tunale de semöna, onyajque cöne mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Pero entre yejua molfejque: ―¿Öquenu tiechcuepelis tietetu de ipan coyoctle de mejcöustutl? ");
INSERT INTO nhgNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cuöc otlachixque, quejtaque tietetu ye mocuectaya. Pos lalebes bieye oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Cuöc ocalajque yejua ijtec mejcöustutl, quejtaque sente peltuntle yehuataya ca möyecöntle. Motlaquentejtaya ca sente tzotzomajtle istöc. Pos yejua momajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero yaja quemelfe: ―Amo xomomajticö. Nentietiemoa Jesús de puieblo de Nazaret, öque tiecoruspelojque. Ye oyulebihuac. Amo oncö iloac necö. Xequejtacö necö locör cöne tietiecaque. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Xeyöcö xequemelficö tiemachtejcöhua ca tiehua Piero que biloas cachto de nemejua pa Galilea. Ompa nentieyejtasque quieme nemiechelfejque. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Yejua chucholojtiejque de ipa mejcöustutl porque bebeyocaya hua majcömequeya. Nionöque amo tli quepoaya porque momajtiöya. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús ye oyulebihuac ca ise cualco pa primiero tunale de semöna. Neniextiluc cachto ca María de puieblo de Magdala. Jesús antes quequextelejque checume demunios de María. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yaja uya quenmachestito noche tli oyejyeya tieca. Pos yejua quepeaya meyac tequepachule, hua chojchucataya. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cuöc quecajque yejua nele nemoöya hua nele yaja tieyejtac, amo moneltocaque.  ");
INSERT INTO nhgNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pero sötiepa de ini nönca, Jesús neniextiluc de ocsie forma ca oc unte de yejua. Onyöya pa ojtle. Nejnentöya ca caltienco. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Entunses yejua ohualiejque quenmachestejque inu ocseque. Pero nimpor ca yejua amo moneltocaque.  ");
INSERT INTO nhgNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ca sölúltimo neniextiluc ca noche majtlactle huansie cuöc yejua tlacuajtaya. Quemajajuaque porque amo moneltocaque hua porque yultepitzteque. Pos amo moneltocaque cuöc yejua tli tieijtaque quejtojque que yulebihuateca. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Quemelfejque: ―Xeyöcö ipa noche tlöltecpactle hua xequennunutzacö noche giente de cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Öque moneltocas hua mocuötiequis, momöquextis, pero öque amo moneltocas Deus quecuntenörusque. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ini nönca sieñas quechihuasque yejua tli moneltocasque: Notucöyupa quenquextisque demunios. Tlajtlajtusque ca ocsesen tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Casesque cuhuöme. Tlö conisque canajyetla tiemecte, amo tli quenchibelis. Impa cocoxcötzetzi quentlölisque inmöhua hua pajpajtesque.  ");
INSERT INTO nhgNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cuöc Tlöcatzintle Jesús ye quennunutzaluc, otlejcoac elfecac. Netlöliluc ca tiemöyecmö de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tiemachtejcöhua oquisque. Tlanunutztenemeya ca nobeyo, hua Tlöcatzintle tequetihuaya ca yejua. Cafirmöruroöya inu tlajtule tli quenunutzaya por medio de sieñas de tietzöbetl.");
INSERT INTO nhgNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Meyactie tlöca ye oquenejque quejcuelusque sente tlapubelestle de noche inu sösantle que entre totzölö omochi. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Inu tlateotitlanme oquejtaque inu sösantle ca imixtelolojua desde ca opie. Omochijque tlatequepanojque de Deus para tlanunutzasque inu nieca tlajtule, hua otiechpubelejque tejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Hua naja onectiemo hua onecmat exactamente quiene omochi noche inu sösantle desde cuöc opie. Por inu onejcualejtac temetzmojcuelfelis ini nönca ömatl para tejuatzi, Teófilo, öque innochtie metzmoyectieniebelea. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ejqueu cuale tomojtelis tlin melöhuac de noche inu sösantle de tli ye ometzmomachtelejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Cuöc Herodes oyeya rey de tlöle de joriojte, oyeya sente teopexque itucö Zacarías. Yaja oyeya de inu grupo de teopexcötzetzi de Abías. Isohua de Zacarías itucö Elisabet. Yaja nuyejque oyeya de ixenöchpelhua de inu primiero teopexque Aarón. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Hua innehua oyejyeya yecteque para ca Deus, hua quechihuaya noche tli quemarcöroa inu mandamientos de Tlöcatzintle sin que quefaltörojque niontle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amo quenpeaya inpelhua, ipampa Elizabet oyeya machura, hua innehua ye oyejyeya biebentzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Hua omochi que quetocöro inu grupo de Abías tequepanusque tieixpa Deus. Hua quiene quepeaya costumbre, queriförojque abier öque quetocörus quechihuas tli tequetl de teopexque. Hua Zacarías quetocöro calaques para quexutlaltiti cupale ipa tieteupa Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Hua meyac giente de puieblo oyejyeya queyöhuac omotlajtlötlajtejtaya ipa inu ura cuöc quexutlaltea cupale. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Hua omoniexte sente öngel de Tlöcatzintle ica Zacarías. Oijcataya ca imöyecmö ajtöl cöne motlölea cupale. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Hua oquetietzöbe Zacarías cuöc oquejtac, hua omomajte. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero inu öngel oquelfe: ―Zacarías, amo xomomajte, ipampa motlajtlötlajteles ye oquecajque Deus. Mosohua Elisabet quemixebes sente moconie, hua tectucöyutis Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hua tepajpöques hua tecpeas pöquelestle, hua meyactie pajpöquesque cuöc yaja tlöcates. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Porque yaja bieye iyes para ca Deus. Amo conis vino nimpor sidra. Tientas iyulo ca Espíritu Sönto desde cuöc iyes ijtecopa inöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hua meyactie de inu giente de Israel quenyulcuepas para ma tietocacö Tlöcatzintle inDeus de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pues yaja tlayecöntös delönte de yejuatzi Tlöcatzintle. Huölös ca checöhualestle san quiene inu tlayulepante Elías. Quenyulcuepas inyulo de tötajte para yesque cuale ca inpejpelhua, hua tli amo tlaneltocaneme quenyulcuepas para ma quematecö inu machestelestle de tli yecteque. Ejqueu quenpreparörus giente para cuöc hualiloas Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Hua Zacarías oquelfe öngel: ―¿Tli sösantle teniechejtetis para necmates que ica melöhuac ini nönca? Pues naja ye nebiebentzi, hua nosohua nuyejque ye lamatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Hua onöhuat öngel, oquejto: ―Naja necaca neGabriel, öque seme neijcateca tieixpantzinco Deus. Yejuatzi niechhualtitlanque ma temetznunutzaqui, hua ma temetzmacaqui ini cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Öxö, noso, taja teyes temumorojtzi, hua abele tetlajtlajtus hasta tli ipan tunale mochihuas ini nönca. Ejqueu mochihuas ipampa amo tomoneltocac ica notlajtul. Pero lo que tli onequejto mochihuati ipa tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mientras, noche tlöca quemöchixtaya Zacarías, hua quetietzöbejque de que Zacarías tönto obejcö ipan teopantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Hua cuöc yaja oquis, abele quennunutzaya. Hua ocasojcömatque que Deus oquejtetejque canajyetla ipan teopantle. Yaja quennunutzaya sa ca sieñas de imöhua, hua omocö mumorojtzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Hua omochi que cuöc ye oquetlame tunalte de iteque, uya ca ichö. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Hua sötiepa de inu niecate tunalte omoutztlöle isohua Elisabet. Hua omojyö möcuile mietztle. Oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","―Ejqueyi oquechijque Tlöcatzintle ca naja. Pues ipa nöncate tunalte oniechejtaque, hua niechonchibelejque ma ayecmo nepinöhua por que amo necpeaya nopelhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Hua ipan checuasie mietztle, oquetitlanque Deus inu öngel Gabriel ipa sente puieblo de estado de Galilea, que itucö Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ompa oyeya sente sisehuantu tli omocomprometiero para monömectis ca sente tlöcatl itucö Josie. Josie oyeya de ixenöchpelhua de David. Hua inu nieca sisehuantu itucö María. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Hua inu öngel ocalac icalejtec cöne yaja oyeya. Oquelfe: ―Ma cuale xeye. Deus metzpaliebilo lalebes, hua yejuatzi iloac ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cache yaja amo oquemat quiene quepensörus, hua oquepensöro tli tlajpalulestle icaca ini nönca. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Inu öngel oquelfe: ―María, amo xomomajte, ipampa Deus metzmacalo meyac tiefavur. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Xequejta que tecpeas peltzintle mojtec, hua tecmixebes sente moconie, hua tejcuitis Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Lalebes bieye iloas, hua necuitilus tieConietzi de yejuatzi öque lalebes bieyetzintle iloac. Hua Tlöcatzintle Deus tiemacasque para tlareinörurus quiename otlareinöro David, que ica de tiebiebetcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Tlamandörurus ipa giente de Jacob nochepa, hua tiereinödo amo quepeas tlamelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","María oquelfe öngel: ―¿Quiene iyes ini nönca? Pues naja ayemo nequixomate tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Onöhuat öngel, oquelfe: ―Espíritu Sönto hualiloas mopa, hua tiechecöhuales de öque lalebes bieyetzintle iloac mopa huölös. Por inu nuyejque inu peltzintle yectec tli tlöcates motucöyutis tieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Hua xequejta, Elisabet quiene tequejta yaja nuyejque ye omoutztlöle ca sente iconie mös ye lamatzi; hua ye quepea checuasie mietztle de que moutztlöle mös giente quejtoöya que yaja machura. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pues Deus cuöc quejtulo canajyetla quepealo beletelestle para quechihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Yecuöquenu María oquejto: ―Nö neca naja que necaca netietlatequepano de Tlöcatzintle. Ma mochihua ca naja san quiene ca tomojtalfe. Hua öngel uya de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ipa inu niecate tunalte omoquetztie María hua uya ca meyac cuesebelestle ipa sente puieblo de tlöle de Judá que oyeya innepantla tepieme. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ocalac ipa ichö Zacarías, hua oquetlajpalo inu Elisabet. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Hua omochi que cuöc oquecac Elisabet tlajpalulestle de María, inu peltzintle otzecui ijtecopa, hua iyulo Elisabet otie de Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Hua otzajtzec checöhuac, hua oquejto: ―Deus metzteochihualo cache que noche ocseque sohuame, hua queteochihualo inu peltzintle tli mojtejca. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tlica noso nopa omochi ini nönca, que tienönajtzi de noTlöcatzintle onhuöla notlac? ");
INSERT INTO nhgNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pos cuöc onejcac motlajpalules, inu peltzintle otzecui nojtecopa ca meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Hua cuale mocnupel taja öque tomoneltocac, ipampa ca taja mochihuas noche sösantle tli ometzelfejque Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Yecuöquenu María oquejto: Noölma tiebieyelea Tlöcatzintle, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","hua noyulo oquepex pöquelestle tiecatzinco Deus notiemöquextejcötzi, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ipampa oniechicnuejtaque naja, mös sa neca netietlatequepano. Pues desde öxö, noche giente tli yesque ipan tlöltecpactle quejtusque que cuale nocnupel. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pos oniechchibelejque bieye sösantle yejuatzi öque quepealo checöhualestle, hua yectec icaca tietucöyutzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hua tieicnuejteles icaca ica giente de noche tiempos, ca innochtie tli tiemabelea. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Oquecuajpetzojque tiemö para oquechijque bieye sösantle. Oquencuasemanque tli mochajchamöhua ipa inyulo. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Oquenquextejque tlajtoönejme para ayecmo tlamandörusque, hua oquemajcojque tli porubejte. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tli tejteosejtaya oquentlamacaque de meyac tlin cuale, hua tli ricojte oquemelfejque ma yöcö, hua amo quenmacaque niontle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Oquenpaliebejque ixenöchpelhua de tietlatequepano Israel, oquelnömejque de Israel ca icnuejtelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ejqueu oquechijque quiename oquemelfejque totötajua, quieme oqueprometierfejque Abraham hua ipejpelhua para nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Hua omocö María ca Elisabet quieme yeye mietztle. Sötiepa ohuöla pa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Hua oasec tunale para mixebes Elisabet. Oquemixe iconie. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hua tli itlac chajchönteya hua igiente oquecajque que Deus quepilejque meyac icnuejtelestle, hua opajpöjque ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hua omochi que pan checuieye tunale ohuölajque para quenacayutequesque inu peltzintle. Hua quecuitiöya quieme itajtzi, Zacarías. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yecuöquenu onöhuat inöntzi, oquejto: ―Amo, cache itucöyes Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Hua oquelfejque: ―¿Tli ipampa? Amo öque de mogiente mocuitea ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Hua oquenutzque itajtzi peltzintle ca sieñas de inmöhua, quiene queneque quecuitis. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Hua yaja otlajtla ömatl, hua oquejcuelo ejqueyi: “Itucö Xohuö”. Innochtie quetietzöbejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hua sa nima opajtec icamac hua inenepil Zacarías. Ye cuale otlajtlajto, hua otieteochi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ohuöla majcömabelestle impa innochtie tli ompa chajchönteya intlac yejua. Hua ipa noche tepieme de estado de Judea omacheac de noche ini nönca sösantle tli opasöre. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Hua noche quiejquech quecaqueya quemalfiöya ipa inyulo, hua quejejtoöya: ―¿Öquenu iyes inu peltzintle? Pues Tlöcatzintle iloaya ca yaja hua ejqueu quepaliebiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Hua Zacarías itajtzi Xohuö iyulo otie de Espíritu Sönto. Otlayulepante, hua oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ma tetieteochihuacö Tlöcatzintle Deus de Israel, que ohualiloac ca tiepuieblo, hua oquemöquextejque, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","hua ocajcojque sente tiemöquextiöne para tejua, de ixenöchpelhua de David tietlatequepano. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pues ejqueu oquejtojque por incamacopa de tietlayulepanhua yecteque tli oquepujque tietlajtultzi desde ca opie tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Tiechmacaque nemöquextelestle de toenemigos, hua de innochtie tli tiechtlajyelejta. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ejqueu quepeasque icnuejtelestle ca totötajua, hua quelnömequesque de inu acuierdo yectec tli oquechijque, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","hua de inu promiesa tli oquejurörojque ca Abraham totöta. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Pues oqueprometierojque tiechmacasque ini nönca: que temöquisasque de inmöpa de toenemigos, hua tetietequepanusque sin mabelestle, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ca yectelestle hua nemelestle yectec para ca yejuatzi, mientras teneme. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Hua taja, peltzintle, teyes tetlayulepante de öque lalebes bieyetzintle iloac. Pues taja teyös delönte de Tlöcatzintle, para tecyejyectlöliti tieojfe. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tequemixtlamachtiti giente de tiepuieblo quiene momöquextisque, para ejqueu toDeus quenperdonörfisque de intlajtlacul, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","porque yejuatzi quemicnuejtalo. Por inu, desde ompa tlacpac hualiloas quiename cuöc quisa tunale, ");
INSERT INTO nhgNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","hua quenmacasque tlöbile tlin neme ipan tlajtlayohuaquelestle hua ipa locör de mequelestle, hua tiechyecönasque para tocxehua ma nejnemecö ipa ojtle de yecsiebelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Hua inu peltzintle mobepöhuaya, hua caseya checöhualestle ipa iyulo. Hua omocö cöne nionöque chönteya hasta inu tunale cuöc Deus oquetitlanque itlac giente de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hua omochi ipa inu niecate tunalte que inu emperador Augusto César otlamandöro que noche giente de tlöltecpactle ma mocensörucö. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ini nönca primiero censo omochi cuöc Cirenio oyeya cubernadur ipan tlöle de Siria. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Hua oyöya innochtie para mocensörusque. Cara sesen tlöcatl onya ipan puieblo cöne onemeya ibiebetcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Hua oquis Josie de ipa inu estado de Galilea, hua de inu puieblo de Nazaret. Onya ca ipa estado de Judea, ca ipa ipuieblo de David, que itucö Belén. Pues yaja oyeya de ixenöchpelhua David. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ompa onya para mocensörus ca tiehua María, öque omocomprometiero para monömectis ca yaja. Hua María ye utztle oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hua omochi que cuöc yejua ye oyejyeya ompa, oasec tunale para mixebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Hua oquemixe itieyecapaconie, hua oquequemelo ica tzintatapajme, hua oquetietiecac ijtec sente cöxa tli quepeaya sacatl para ompa tlacua yulcöme. Pues amo oyeya locör para yejua ipa inu nieca mersu. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hua oyejyeya calnielojpexque ipa inu nieca tlöle. Yejua oyejyeya ca caltienco hua quemixutiöya incalnielojua ca yohuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Hua sente öngel tli cualtitlanque Tlöcatzintle ohuöla impa yejua, hua tietlaniexteles Tlöcatzintle oquenyehualo ica itlapetlöneles. Hua omomajtejque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Cache öngel oquemelfe: ―Amo xomomajticö, porque nemiechpubelea cuale tlamachestelestle tli quenmacas meyac pöquelestle ca noche tiegiente de Deus: ");
INSERT INTO nhgNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","que öxö ye otlöcatihuac, ipa ipuieblo de David, sente tiemöquextiöne öque yejuatzi iloac Cristo öque Deus tieixpejpenque, hua iloac Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Hua ejqueyi nenquematesque cuöc ye nentieniextejque: pos nenqueniextisque peltzintle que quemelejtas ca tzintatapajme. Betztotas ijtec cöxa tli quepea sacatl para ompa tlajtlacua yulcöme. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Hua sa de repiente oniesque ica öngel lalebes bel meyactie de tieöngeles Deus. Tiechamöhuaya, hua quejejtoöya: ");
INSERT INTO nhgNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Deus ma quepeacö yectieniebelestle ompa tlacpac, hua ipan tlöltecpactle ma uye yulsiebelestle inca innochtie tli quencualejtalo Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Hua omochi que cuöc öngeles ye uyajque ca elfecac, calnielojpexque omolfejque entre yejua: ―Ma teyöcö hasta Belén. Ma tequejtacö inin tli omochi, tli Tlöcatzintle ye otiechmachestejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Hua ocuejcuesejque, hua oquenniextico inu María, ca Josie, hua peltzintle obetztaya ijtec cöxa cöne tlajtlacua yulcöme. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Hua cuöc oquejtaque, oquepujque noche tli öngel oquemelfe de inu peltzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Hua noche tli oquecajque oquetietzöbejque inu sösantle tli quenpubeliöya calnielojpexque. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Cache María quemalfiöya ini nönca sösantle ipa iyulo, hua seme quepensöroöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Hua omocuejque inu calnielojpexque. Tiemabesutejtöya hua tieyectieniehuatöya Deus por ipampa noche inu sösantle tli oquecajque hua oquejtaque, san quiene ca oquemelfe öngel. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hua cuöc opanuc checuieye tunale para quenacayutequesque inu peltzintle, oquetlölelejque itucöyu Jesús. Pues ejqueu oquecuite öngel antes que mochejchihuas ipa ijte María. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Cache cuöc opanuque tunalte para omochepöjque, san quiene ca quejtoa inu ley de Moisés, oquehalecaque peltzintle ipa inu ciudad de Jerusalén para quetieyejtetisque tieca Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(Pues ejqueyi tlajcuelulpanca ipa inu ley tli quemacaque Tlöcatzintle: “Noche peltzintle tli primiero tlöcate de inöna, tlö ica oquechtle modedicörus para iyes de Tlöcatzintle”.) ");
INSERT INTO nhgNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ejqueu noso onyajque para quetiemacasque inu bentle quiene quemarcöroa inu ley tli quemacaque Tlöcatzintle, cöne quejtoa: “Ma mobentlölicö unte cucutetzetzi noso unte palumaxte”. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hua ompa oyeya sente tlöcatl ipa Jerusalén, que itucö oyeya Simeón. Ini nönca tlöcatl oyeya yecnemelestec hua seme tieteochihuaya Deus. Quecheaya ma mochihua inu sösantle tli quenyulölis giente de Israel. Hua Espíritu Sönto hualiloöya ipa yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Hua Espíritu Sönto ye oquemachestejque que amo meques hasta senamo tieyejtas inu Cristo öque tieixpejpenque Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Hua Espíritu Sönto oquechihualtejque ma huöla ipan teopantle. Hua itötajua peltzintle Jesús oquecalaquejque peltzintle ipan teopantle, para quechibelisque por yaja san quiene ica costumbre de inu ley. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Yecuöquenu yaja Simeón oquenöpalo peltzintle. Tieteochibele Deus, hua oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Öxön quiema ma nebeya naja que neca motlatequepanojtzi, notiecojtzi. Ma nemeque ca siebelestle ipa noyulo, san quiene ca teniechmolfele. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Porque noixtelolojua ye oquejtaque motiemöquextelestzi tli tetiechmomaquelis, ");
INSERT INTO nhgNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","que ye otomopreparörfe para quejtasque noche puieblos, ");
INSERT INTO nhgNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","tlöbile para ma quentlaniextele giente de ocseque puieblos, hua tlaniextelestle de mopuieblojtzi de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Itöta ca inöna peltzintle quetietzöbejque de noche ini sösantle tli mojtoöya de yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Hua Simeón oquenbendeseyumacac, hua oquelfe María inöntzi peltzintle: ―Xequejta necö, que ini nönca peltzintle oquetlölejque Deus para que por medio de yaja meyactie giente de Israel tli quepea checöhualestle quepolusque, hua meyactie tli quenpoloa casesque. Iyes quiename sente sieñas para yejua, hua meyactie quetlabielcöhuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hua melöhuac, iyes quiename tlö sente espöda motlölaquis ijtec moölma de taja. Ejqueu ixniesesque pensamientos tli mojyönteca ipa inyulo de meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hua ompa oyeya nuyejque sente sohuatl tlayulepante itucö Ana. Itajtzi itucö Fanuel. Oyeya de inu grupo de israelitas tli oyejyeya de itlöcaxenöchyo de Aser. Ini nönca sohuatl ye oyeya lalebes ye lamatzi. Pues cuöc sisehuantu omonömecte, hua one ica inömec checume xebetl, ");
INSERT INTO nhgNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","hua öxö ye quepeaya ochenta y cuatro años de que oyeya icnusohuatl. Yaja seme mocöhuaya ipan teopantle. Tieteochijtaya Deus yohualen tunale. Tlajyubiöya hua motlajtlötlajtiöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ini sohuatl ohuöla ipa inu nieca ura, hua tietlasojcömat Deus. Quennunutzaya de inu peltzintle ca noche giente tli quemöcheaya ma momöquexte inu ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Hua cuöc oquechijque noche sösantle tli quejtoa inu ley tli quemacaque Tlöcatzintle, omocuejque ca Galilea, ca ipan inpuieblo de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Hua peltzintle mobepöhuaya, hua caseya checöhualestle. Momeyaqueliöya ca tlamatelestle, hua tiefavur Deus oyeya ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hua itötajua oyöya cara xebetl ipa Jerusalén ipa inu yelfetl de pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hua cuöc ye quepeaya majtlactle huan ume xebetl, otlejcojque yejua ca ipa Jerusalén san quiene ca quepeaya costumbre ipa inun tunale de yelfetl. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Cuöc ye otlan tunalte, omocuejque yejua. Pero omocö inu pelalajconetzi ipa Jerusalén, sin quematesque itötajua. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Yejua quepensöroöya que beles oyeya inca ocseque giente tli oyöya ca yejua. Ejqueu onejnenque noche semelfetl. Hua ca ye yohuac quetiemoöya intzölö igiente hua intzölö tli quemixomateya. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Cuöc amo oqueniextejque, omocuejque ca Jerusalén oquetiemuto. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Hua opasöre que hasta pa yeye tunale oqueniextejque ipan teopantle. Yehuataya innepantla tlajmatque. Oquencactaya hua oquentlajtlanejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hua noche giente tli quecaqueya quetietzöbejtaya de quiene quemateya hua quiene onöhuateya. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Cuöc oquejtaque itötajua oquetietzöbejque. Oquelfe inöntzi: ―Noconie, ¿tlica otetiechchibele ejqueyi? Xequejta motajtzi hua naja otemetztiemojtenemeya ca meyac tequepachule. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yaja oquemelfe: ―¿Tlica nenniechmotiemolejque? ¿Amo nemomachitea que niechconbenieroa ma neya ipa tietequeyotzi de noTajtzi? ");
INSERT INTO nhgNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero yejua amo ocasojcömatque inu tlajtule tli yaja oquemelfe. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Hua ohuöla ca yejua, hua oaseco ipa Nazaret, hua omosujetöro ca yejua. Noche ini nönca sösantle tli omochi, inöntzi quemalfiöya ipa iyulo. ");
INSERT INTO nhgNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Hua Jesús cache mochihuaya tlajmatque, cache mobepöhuaya, hua Deus hua giente cache quecualejtaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ye quepeaya caxtule xebetl que tlagobernöro inu emperador Tiberio César. Oyeya cubernadur de estado de Judea yaja Poncio Pilöto. Herodes oyeya Tetrarca, noso rey de estado de Galilea, hua icni Felipe oyeya Tetrarca de inu tlöle de Iturea hua de Traconite, hua Lisanias oyeya Tetrarca de tlöle de Abilinia. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Oyeya tlajtojcöteopexque yaja Anás ca tiehua Caifás. Ipa inu tiempo Tlöcatzintle oquemacaque tietlajtul ca Xohuö, iconie Zacarías, ompa cöne nionöque chönteya. Oquetitlanque para ma tlanunutza de inu tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaja ohuöla ipa inu tlöle itlac inu ötlactle de Jordán. Hualtlanunutztöya que giente ma moyulcuepacö para ma Deus ma quenperdonörficö intlajtlacul. Hua tlöjcu, ma mocuötiequicö. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pues ejqueu tlajcuelulpanca ipa ömatl de inu tlayulepante Isaías, que quejtoa: Caquestec tlajtule de yeca tli tzajtze ompa cöne nionöque chönte, hua quejtoa: “Xecyejyectlölicö tieojfe Tlöcatzintle. Xecmelöhuacö tieojfe, pos ye miero axihuaqui”. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Noche xopochco majcoques, hua noche tepieme moparejörusque, hua tli ojme nejnecuelteque momejmelöhuasque, hua tli ojme petzoteque mixmanasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Hua noche giente quejtasque quiene Deus quenmöquextisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hua Xohuö quemelfiöya giente tli quisaya para mocuötiequisque ca yaja: ―¡Tlöcaxenöchcuhuöme! ¿Öquenu onemiechmachte nencholusque de ipa inu cualönelestle de Deus tli huölös nemopa? ");
INSERT INTO nhgNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xecchihuacö noso sösantle tli conbenierebe quechihuas öque de melöhuac ye omoyulcuec. Hua amo xequejtojtacö nemojtecopa que yaja Abraham icaca nemotajtzi hua que por inu nencate cuale. Pues naja nemiechelfea que Deus cuale quenchihualtisque ini nöncate teme ma mochihuacö ipelhua Abraham. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Öxö nuyejque pues Deus ye miero quenpojpolusque tli amo quechihua tlin cuale. Icaca quiename tlö öcha ye intzintlanca cuajme. Hua noche cuabetl tli amo quetiemaca ifruto cuale motzinteques hua motlajcales ijtec tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hua inu tlöca quetlajtlaniöya, hua quelfiöya: ―¿Tli noso tecchihuasque? ");
INSERT INTO nhgNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hua yaja onöhuat, hua oquemelfe: ―Öque quepea unte tlaquentle, ma quemaca öque amo quepea, hua öque quepea tli quecuös nuyejque ma quechihua ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nuyejque ohuölajque tlanechecojque para mocuötiequisque, hua oquelfejque: ―Maestro, ¿tli tecchihuasque tejua? ");
INSERT INTO nhgNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Hua yaja oquejto: ―Amo cache meyac xecnechecucö tlöcamo sa tli quemarcöroa ley. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Hua quetlajtlaniöya soltörojte, oquejtojque: ―Hua tejua, ¿tli tecchihuasque? Hua yaja oquemelfe: ―Amo xecmaltratörucö nionöque, hua amo öque xejcuejcuelicö lo que tli amo nenquepea deriecho para nenquecuejcuelisque. Xomoconformörucö ca lo que tli nenquetlöntecate. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Noche giente quechixtaya hua quepensörojtaya ipa inyulo de Xohuö, tlö beles yaja icaca inu Cristo tli Deus quixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Onöhuat Xohuö, oquemelfe innochtie: ―Naja, por nopörte, nemiechcuötiequea ca ötzintle. Pero sötiepa de naja biloatz ocsie tlöcatl, öque cache quepealo meyac checöhualestle que naja. Naja amo necmeresieroa nion para nopiechus para netiequextelis tiecacua. Yejuatzi nemiechcuötiequesque ca Espíritu Sönto hua ica tletzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yejuatzi iloac quiename sente tlöcatl tli ye miero piehuas para quetzetzelus hua quechepöhuas trigo. Hua quebicasque inu trigo tli chepöhuac ijtec ibesco. Pero inu itlasolyo quexutlaltisque ijtec inu tletzintle tli ayec siebe. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hua Xohuö quenmachestiöya giente ocseque meyac sösantle, hua quennunutz de cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Hua yaja ocajajuac Herodes inu Tetrarca noso rey ipampa omosohuajte ca Herodías, isohua icni Felipe. Nuyejque ocajajuac ipampa oquechi meyac ocseque sösantle tli amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hua ca inu Herodes oconchi ocsente sösantle cache turavea amo cuale, que oquetzajtzac Xohuö ipan cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hua cachto de cuöc oquetzajtzac, omochi que cuöc noche giente mocuötiequiöya, nuyejque Jesús onecuötiequiluc. Hua onetlajtlötlajtiluc. Hua elfecac omotlapo, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","hua Espíritu Sönto ohualiloac tiepa yejuatzi ca furma quieme palumax. Hua ocaquestec sente tlajtule de elfecac, tli quejtoöya: ―Taja tenotlasojcöconie. Motech taja necpea meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cuöquenuju Jesús quepealoöya treinta xebetl. Entunses opiehualuc tlanunutzaloöya. Giente quejtoöya que yejuatzi iloaya iconie Josie, öque oyeya iconie Elí, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","öque oyeya iconie de Matat, öque oyeya iconie de Leví, öque oyeya iconie de Melqui, öque oyeya iconie de Jana, öque oyeya iconie de Josie, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","öque oyeya iconie de Matatías, öque oyeya iconie de Amós, öque oyeya iconie de Nahum, öque oyeya iconie de Esli, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","öque oyeya iconie de Nagai, öque oyeya iconie de Maat, öque oyeya iconie de Matatías, öque oyeya iconie de Semei, öque oyeya iconie de Josie, öque oyeya iconie de Judá, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","öque oyeya iconie de Joana, öque oyeya iconie de Resa, öque oyeya iconie de Zorobabel, öque oyeya iconie de Salatiel, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","öque oyeya iconie de Neri, öque oyeya iconie de Melqui, öque oyeya iconie de Adi, öque oyeya iconie de Cosam, öque oyeya iconie de Elmodam, öque oyeya iconie de Er, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","öque oyeya iconie de Josué, öque oyeya iconie de Eliezer, öque oyeya iconie de Jorim, öque oyeya iconie de Matat, öque oyeya iconie de Leví, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","öque oyeya iconie de Simeón, öque oyeya iconie de Judá, öque oyeya iconie de Josie, öque oyeya iconie de Jonán, öque oyeya iconie de Eliaquim, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","öque oyeya iconie de Melea, öque oyeya iconie de Mainán, öque oyeya iconie de Matata, öque oyeya iconie de Natán, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","öque oyeya iconie de David, öque oyeya iconie de Isaí, öque oyeya iconie de Obed, öque oyeya iconie de Booz, öque oyeya iconie de Salmón, öque oyeya iconie de Naasón, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","öque oyeya iconie de Aminadab, öque oyeya iconie de Admi, öque oyeya iconie de Arni, öque oyeya iconie de Esrom, öque oyeya iconie de Fares, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","öque oyeya iconie de Judá, öque oyeya iconie de Jacob, öque oyeya iconie de Isaac, öque oyeya iconie de Abraham, öque oyeya iconie de Taré, öque oyeya iconie de Nacor, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","öque oyeya iconie de Serug, öque oyeya iconie de Ragau, öque oyeya iconie de Peleg, öque oyeya iconie de Heber, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","öque oyeya iconie de Sala, öque oyeya iconie de Cainán, öque oyeya iconie de Arfaxad, öque oyeya iconie de Sem, öque oyeya iconie de Noé, öque oyeya iconie de Lamec, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","öque oyeya iconie de Matusalén, öque oyeya iconie de Enoc, öque oyeya iconie de Jared, öque oyeya iconie de Mahalaleel, ");
INSERT INTO nhgNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","öque oyeya iconie de Cainán, öque oyeya iconie de Enós, öque oyeya iconie de Set, öque oyeya iconie de Adán, öque oyeya tieconie de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Hua tieyulo Jesús otie ca Espíritu Sönto. Nehualnecuepaluc de ipan Jordán, hua Espíritu Sönto tiebicaluc ca ompa cöne nionöque chönte. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ompa iloaya cuarenta días, hua tieyulmajmötocaya Diöblo. Cuöc ye opanuc inun tunalte oteosebihuac. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Hua Diöblo otieyelfe: ―Tlö teca teiconie Deus, xequelfe ini nönca tietetu ma mocuepa pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Hua Jesús oquenönquelejque, oquelfejque: ―Tlajcuelulpanca: “Amo sa ca pöntzi cuale nemes sente tlöcatl”. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Hua Diöblo otiebicac tlacpac, hua otieyejtete noche reinos hua naciones de tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Hua Diöblo otieyelfe: ―Taja temetzmacas noche ini nönca checöhualestle, hua icualniexteles de noche nöncate naciones. Pos naja oniechmöctejque, hua öque naja necneque, cuale necmacas. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ejqueu, tlö taja teniechmabesutis nixpa, noche ini nönca mohuöxca iyes. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Hua onöhuatihuac Jesús, oquelfejque: ―Tlajcuelulpanca: Yejuatzi Tlöcatzintle moDeus tetiemabesutis, hua sa yejuatzi tetietequepanus. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Hua otiebicac ipa ciudad de Jerusalén, hua otietlejcabe icuayuluc teopantle. Hua otieyelfe: ―Tlö tecaca teiconie Deus, xomocajcöhua para tebetzes desde necö hasta tlölpa. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Pues tlajcuelulpanca ejqueyi: Quenhualentitlanesque tieöngeles por mopampa, ma metzixuticö. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Hua: Metzajcoquesque ca inmöhua, para que ejqueu mocxehua amo moteputlamesque ca teme. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Hua onöhuatihuac Jesús, oquelfejque: ―Pan tlajtule icaca: “Amo xetietantiöro Tlöcatzintle moDeus para abier tlö cuale quechihuasque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Hua cuöc Diöblo ayecmo quemateya quiene cache tieyulmajmötocas, uya de tietlac por sie röto. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Hua Jesús ohualiloac ca estado de Galilea ca checöhualestle de tieEspíritu de Deus. Hua omacheac de yejuatzi ipa noche tlöle tli ica ca ompa. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hua tlamachtiloöya ipan inteopancuconehua, hua innochtie tieyectieniehuaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Hua ohualiloac ipa puieblo de Nazaret, cöne yejuatzi onebepöhualuc. Ipan söbro ocalacoac pa teopanconetzi, quiene quepealoöya costumbre. Onequetzaluc para quetlajtultisque ömatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Otiemacaque yaja ömatl de inu tlayulepante Isaías. Oquexetunque inu ömatl tli ilacatzejtaya, hua oqueniextejque cöne tlajcuelulpanca ejqueyi: ");
INSERT INTO nhgNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","TieEspíritu Tlöcatzintle iloac ipa noyulo. Ejqueu niechixpejpenque para ma netlanunutza de cuale tlamachestelestle ca tli porubejte. Niechhualtitlanque para netlamachestis de que priesoste cuale quisasque de incörsel, hua ixcocoxcötzetzi ye cuale tlacheasque, hua tli omolastimörojque ye cuale yesque libres. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Niechhualtitlanque para netlanunutzas de ini xebetl tlacualejtale de Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hua cuöc ye oquetlajtultejque nöncate tlajtulte, oquequemelojque inu ömatl. Oquemacaque teotlatequepano, hua onetlöliluc. Hua innochtie tli oyejyeya ipa inu teopanconetzi tieyetztaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Hua opiehualuc quemelfiloöya: ―Öxö ye omochihuaco ini nönca teotlajtule tli nenquecajque. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Hua innochtie tietieniehuaya, hua quetietzöbejtaya inu tlajtule cuajcualtec tli quejtuloöya. Hua quejejtoöya: ―¿Amo yaja ini nönca iconie de Josie? ");
INSERT INTO nhgNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Hua yejuatzi oquemelfejque: ―Seguramente ye nenniechelfisque ini nönca tlajtule: “Mierco, xomopajte sie taja”. Hua nenniechelfisque ma necchihua noche sösantle tli onenquecajque que onecchi ipa Capernaum, ma necchihua necö ipa nopuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nuyejque oquejtojque: ―Melöhuac nemiechelfea, que nionöque tlayulepante amo queresibiroa giente de ipuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Melöhuac nemiechelfea, que meyactie icnusohuame oyejyeya ipa Israel ipa inun tunalte de Elías, cuöc elfecac omotzac para amo onqueya yeye xebetl hua checuasie mietztle, hua oyeya meyac öpestle ipa noche tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Cache Deus amo quetitlanque inu tlayulepante Elías ma beya itlac nionöque de yejua, tlöcamo itlac sente icnusohuatl estranjiera tli nemeya pan puieblo de Sarepta itlac ciudad de Sidón. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hua cuöc nemeya inu tlayulepante Eliseo oyejyeya meyactie tlöca sa söhuayojque ipa Israel. Cache nionöque de yejua opajtec, tlöcamo sa inu estranjiero Naamán, öque oyeya de inu nación de Siria. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Hua cuöc oquecajque ini nönca sösantle, noche tli oyejyeya ipan teopanconetzi ocuajcualönque. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Omoquiequetzque, hua otiequextejque ca queyöhuac de inu puieblo. Hua otiebicaque hasta icuötecpac tepietl cöne oyeya inu puieblo para tietepexebisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Cache yejuatzi opanoac intzölö de yejua hua obiloac. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Hua ohualiloac ipa Capernaum, ocsente puieblo de inu estado de Galilea. Hua quenmachtiloöya ipan tunale cuöc mosiebea joriojte, que yaja söbro. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pos giente tietietzöbeya quiene ca tlamachtiloöya, ipampa tlajtlajtuloöya ca meyac checöhualestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pero oyeya ipan teopanconetzi sente tlöcatl que quepeaya sente espíritu de moxicoöne. Ini nönca otzajtzec checöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Oquejto: ―¡Ay! ¿Tli tecpea ca tejua, Jesús de Nazaret? ¿Ye tehuöla otetiechxexetunico? Necmate öquenu taja: taja tetietlöcayectec de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero Jesús ocajajuaque, oquelfejque: ―Xectzacua mocamac, hua xequisa de yaja. Yecuöquenu inu demunio oquechihualte tlöcatl ma betze tlanepantla. Entunses oquis de yaja, hua amo tli quechibele. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Hua quetietzöbejque innochtie, hua monunutzaya entre yejua sie tlöcatl ca ocsie tlöcatl. Quejejtoöya: ―¿Tli tlajtule icaca ini nönca? Pues quennahuatea moxicoöneme ca checöhualestle hua ca beletelestle, hua yejua quisa. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Hua inu tli oquechijque yejuatzi omacheac ca nobeyo ipa noche pörtes de inu nieca tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Hua onequetzaluc Jesús, oquixoac de ipan teopanconetzi. Ocalacoac ipa ichö Semu. Imontiesyo Semu quepeaya checöhuac totunealestle, hua giente tietlötlajtejque por yaja para ma quepajticö. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yejuatzi onepiechuluc cöneca yaja oyeya. Cajajuaque inu totunealestle, hua totunealestle oquecö. Entunses yaja sa nima omie hua tieintlamacaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Hua cuöc ye calaques tunale, noche quiejquech quepejpeaya cocoxcötzetzi de meyac sösantle cocolestle quenhualecaya tieca. Yejuatzi quetlöliloöya tiemöhua ipa cara sente cocoxque de yejua, hua quenpajtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Hua oquisaya nuyejque demunios tli meyac giente quepeaya imijtec. Tzajtzajtzeya, quejejtoöya: ―Taja tecaca teiconie Deus. Pero quemajajualoöya, hua amo quencöhualoöya ma tlajtlajtucö, pues yejua quemajtaya que yejuatzi iloac inu Cristo tli Deus tieixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Hua cuöc ye oyeya ca tunale oquixoac hua obiloac ipan locör cöne nionöque chönteya. Hua meyac giente tietiemoöya, hua ohuölajque hasta tietlac. Pues amo quenequeya ma nenencuaxelulo de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Cache yejuatzi oquemelfejque: ―Necpea que netlanunutzas de ini cuale tlamachestelestle de quiene tlamandöruro Deus nuyejque ca ocseque puieblos. Pues ipampaji onehuöla. ");
INSERT INTO nhgNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Hua hualtlanunutzalutöya ipa noche teopancucone de inu tlöle de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Hua omochi que yejuatzi oiloaya itlac ötiescatl de Genesaret. Meyac giente mosentlöliöya para quecaquesque tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hua oquejtaque unte börcoscucone que oyejyeya tlatienco de ötiescatl. Inu tlajtlamajque ye oquisque hua quepöcaya intarröya. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Hua ocalacoac ipa sente de ini nöncate börcos que oyeya ihuöxca Semu. Oquetlajtlanelejque ma quepacho cache tepetzi ca tlaijtec de ötiescatl. Onetlöliluc, hua quenmachtiloöya giente desde ipa börco. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Hua cuöc ayecmo tlajtlajtuloöya, oquelfejque Semu: ―Xebeya cache ca cöne bejcatla ötzintle, hua ompa xectlajcale nemotarröya para nenquemasesque mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Hua onöhuat Semu, otieyelfe: ―NoTlöcatzi, ye otetequetque noche seyohual, hua amo tli tecaseque. Pero siendo que tejuatzi teniechmolfelea, pos nectlajcales notarröya. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Hua cuöc inu pescadurte oquechijque ejqueu, oquemaseque lalebes meyactie mimechte, que intarröya tzomuneya de tönto ara meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Hua oquenchibelejque sieñas ca inmöhua para ma huölöcö incompanierojua tli oyejyeya ipa ocsente börco, hua ma quenpaliebicö. Hua ohuölajque, hua oquentiemitejque innehua börcos, hua hasta quenequeya öpötzcalaquesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Hua cuöc Semu Piero oquejtac ini nönca, omotlancuöquetz tieicxetla Jesús. Oquejto: ―Xomoxelojtzino de naja, Tlöcatzintle, ipampa naja necaca netlajtlacultec. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pues ipa ohuöla majcömabelestle, hua impa noche quiejquech oyejyeya ca yaja, ipampa lalebes meyactie mimechte oquemaseque. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ca yaja oyejyeya Jacobo hua Xohuö, ipelhua Zebedeo. Ini nöncate oyejyeya icompanierojua de Semu. Hua Jesús oquelfejque Semu: ―Amo xomomajte; desde öxö teyes tetlajtlamajque de gientes, para ma momöquexticö. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Hua cuöc yejua oquisque ipan tlöle oquecöjtiejque noche tli quepejpeaya, hua otietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Hua omochi que cuöc iloaya ipa sente puieblo, ohuöla sente tlöcatl sa söhuayo, lalebes cocoxque. Ini nönca, cuöc otieyejtac Jesús, omotlancuöquetz tieicxetla. Otietlötlajte, oquejto: ―Tlöcatzintle, mach tomonequitis, cuale teniechmopajtelis. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Hua yejuatzi omomösohualte hua oquemötocaque. Oquejtojque: ―Necneque; xepajte. Hua sa nima icocoles oquecö. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Hua yejuatzi oquenahuatejque que majcamo öque quepubele. Cache cuale oquejtojque: ―Xebeya xomotieijtetite ica teopexque. Xejcuetlabilte bentle san quiene ca Moisés otlanahuate para teyes techepöhuac para cuale tecalaques pan teopantle. Ejqueu ma quematecö yejua lo que tli omochi ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero cache lalebes caquesteya tietlatieniehuales. Hua mosentlöliöya meyac tlöca para tlacaquesque hua para mopajtisque de incocoles. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Cache yejuatzi nenencuaxeluloöya ca cöne nionöque chönteya para netlajtlötlajtilus. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Hua omochi sie tunale que yejuatzi otlamachtilutaya. Hua ompa oyejyeya seque fariseos ca tiehua seque maestros de inu ley de Moisés. Yejua ohuölajque de ipa noche puieblos de inu estado de Galilea, de estado de Judea, hua de ciudad de Jerusalén. Hua Jesús quepealoöya checöhualestle de Tlöcatzintle para quenpajtisque giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hua necö ohuölajque seque tlöca que quehualecaya ipa sente tlapechtle sente tlöcatl cojcultzi. Quetiemoöya quiene cuale quecalaquesque hua quetlölisque tieixtla yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Cuöc amo oqueniextejque quiene quecalaquisque ipampa lalebes meyac giente, oquetlejcabejque icpac cale. Oquetlapojque tiejas, hua ca ompa oquetemobejque ipa itlapech tlanepantla, ca tieixpa Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Cuöc yejuatzi oquejtaque quiene yejua moneltocaya, oquelfejque: ―Tlöcatl, motlajtlacul ye temetzperdonörfe. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Inu tlamachtiöneme de teotlajtule hua fariseos opiejque tlajtlajtojtaya entre yejua. Oquejtojque: ―¿Öqueniji que checuatlajtoa encuntra de Deus? ¡Abele öque cuale tieperdonörfis tlajtlacule tlöcamo sa Deus! ");
INSERT INTO nhgNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús oquixomatque inpensamientos de yejua. Onöhuatihuac hua oquemelfejque: ―¿Tli nenquepensöroa ipa nemoyulo? ");
INSERT INTO nhgNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cötlaja cache tequeyo, nequelfis cojcultzi: “Ye temetzperdonörfe motlajtlacul”, o noso nequelfis: “Xemiehua hua xenejneme”? ");
INSERT INTO nhgNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pos öxö nenquematesque que naja que onochi netlöcatl necpea deriecho necö ipan tlöltecpactle para necperdonörus tlajtlacule. Quelfejque cojcultzi: ―Taja temetzelfea: Xemiehua. Xecöna motlapech, hua xebeya pa mochö. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hua sa nima omoquetz imixtla yejua. Oconö tli ipa obetztöya, hua uya ca ichö, tiechamöjtöya Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Hua quetietzöbejque innochtie, hua tiechamöjque Deus, hua omomajtejque. Oquejtojque: ―Otequejtaque sösantle tietzöbetl öxö. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Hua sötiepa de ini nönca sösantle oquixoac, hua oquejtaque sente tlanecheco itucö Leví. Oyehuataya cöne yaja caresibirojtaya tomi. Hua Jesús oquelfejque: ―Xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pos oquecö noche sösantle, omoquetztie, hua otietocac. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Oquechi Leví meyac tlacuale ompa ichö. Hua lalebes meyactie tlanechecojque hua ocseque giente ompa oyejyeya ipa miesa ca yejuantzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Hua inu fariseos hua tlamachtiöneme de teotlajtule moquejörojque ca tiemachtejcöhua. Quejtoöya: ―¿Tlica nentlajtlacua hua nencojcone inca tlanechecojque hua ocseque tlajtlaculteque? ");
INSERT INTO nhgNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Onöhuatihuac Jesús, oquemelfejque: ―Öque amo mocojcocoa amo quenesesitöroa mierco, tlöcamo sa öque mococoa, yaja quenesesitöroa. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Amo onehuöla onequennutzaco tli yecteque, cache nequennutzaco tlin tlajtlaculteque para ma moyulcuepacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Hua otieyelfejque: ―Imachtejcöhua de Xohuö tlajyubea meyacpa hua quechihua netlajtlötlajtelestle, hua ejqueu nuyejque quechihua inmachtejcöhua de fariseos. Pero momachtejcöhua tlajtlacua hua tlajtlayi. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús quemelfejque: ―¿Cuale nenquenchihualtisque tli nejnieneme ipa nesohuajtiluyo ma tlajyubicö, cuöc montle intlanca? Pos amo. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero huölösque tunalte cuöc montle ayecmo oncöyes. Cuöquenuju tunalte tlajyubisque. Ejqueu cuöc naja ayecmo oncö neyes, tlajyubisque nomachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Hua nuyejque quemelfiloöya sente ejiemplo: ―Nionöque amo quetzomunea sente tzotzomajtle yancuec para quetlamanelis ipa sente tzotzomajtle soltec. Pues tlö ejqueu, ye otzomu inu tzotzomajtle tlin cuale, hua inu pieröso yancuec amo cuale mocöhua ca tzotzomajtle soltec. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Nuyejque nionöque amo quetlölea vino yancuec ijtec puxajme de cuetlaxtle tli ye solteque. Pues tlö ejqueu, inu vino yancuec quetzomunis inu cuetlaxtle. Nunuquebes vino hua puxajme niempolebisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Cache cuale vino yancuec quepea que motlölis ijtec puxajme yancueque. ");
INSERT INTO nhgNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Hua nionöque öque cone vino tli ye soltec, ayecmo queneque conis tli yancuec. Pos quejtoa: “Tli soltec lalebes cuale icaca”. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Hua omochi ipan söbron tunale, cuöc quepeaya costumbre de mosiebiöya joriojte, que opanoac yejuatzi cöneca tlatuctle. Tiemachtejcöhua cualcopintöya meyöhuatl. Quexacualoöya ca inmöhua, hua entunses quecuöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Pero seque fariseos oquemelfejque: ―¿Tlica nenquechihua tli amo conbenierebe ma mochihua ipan söbron tunale? ");
INSERT INTO nhgNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Hua onöhuatihuac Jesús, oquemelfejque: ―¿Ayec nenquetlajtultejque ini nönca, tli oquechi David ca tiehua tli oyejyeya ca yaja, cuöc oteosejtaya? ");
INSERT INTO nhgNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Pos yaja ocalac ipa tieteupa Deus, hua ucö inu pöntzi tli oyeya de bentle, hua oquecua, hua oquenmacac tli ca yaja oyejyeya. Ejqueu oquechi mös amo conbenierebe öque ma quecua tlöcamo sa yejua teopexcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Hua quemelfiloöya: ―Naja que onochi netlöcatl necpea deriecho para nequennahuatis giente de tli sösantle conbenierebe ma quechihuacö pan söbron tunale cuöc tosiebea. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Hua omochi nuyejque ipa ocsente söbron tunale, que yejuatzi calacoac ijtec teopanconetzi hua tlamachtiloöya. Ompa oyeya sente tlöcatl tli quepeaya imöyecmö huajque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Hua tieyetztaya inu tlamachtiöneme de ley hua fariseos, abier tlö beles tlapajtilus ipan söbron tunale. Pos quenequeya tietieyelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Cache yejuatzi quematiloöya tli quepensöroöya yejua. Oquelfejque inu tlöcatl öque quepeaya imö huajque: ―Xomoquetza hua xehuöla tlanepantla. Hua yaja omoquetz hua ohuöla. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Entunses Jesús oquemelfejque: ―Nemiechtlajtlanes ini nönca: ¿Conbenierebe öque quechihuas tlin cuale, noso öque quechihuas tlin amo cuale ipan tunale cuöc tosiebea? ¿Conbenierebe öque quemöquextis inemeles ocsente, noso queniempolus? ");
INSERT INTO nhgNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hua quemetztalutaya innochtie. Entunses oquelfejque inu tlöcatl: ―Xecmelaso momö. Hua yaja ejqueu oquechi, hua imö opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hua yejua cache lalebes otlajtlabielmejque. Hua monojnunutzaya yejua de tli tiechibelisque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hua omochi ipa inu niecate tunalte, que biloac ipan tepietl netlajtlötlajtiluto. Noche seyohual opanoac netlajtlötlajtilutaya tieca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Hua cuöc ye omochi ca tunale, oquennutzque tiemachtejcöhua, hua oquemixpejpenque majtlactle huan ume de yejua. Ini nöncate nuyejque oquencuitejque tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Hua yejua ini nöncate: yaja Semu öque Jesús oquecuitejque Piero, hua Andrés icni, Jacobo ca tiehua Xohuö, Felipe hua Bartolomé, ");
INSERT INTO nhgNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tumös, Jacobo iconie Alfeo hua Semu öque mocuitiöya Celador, ");
INSERT INTO nhgNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas iconie Jacobo, hua Judas Iscariote, öque nuyejque tieantrecöro. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Hua obiloac ca yejua, hua onequetzaluc cöne tlölmanale. Meyactie tiemachtejcöhua, hua lalebes meyac giente de noche estado de Judea hua de ciudad de Jerusalén, hua de inu tlölte itech lamör itlac puieblos de Tiro hua Sidón, noche ini nöncate ohuölajque para tiecaqueco, hua para mopajtisque de noche incocoles. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Nuyejque noche tli quepeaya tiecoco por moxicoöneme opajteque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Hua noche giente quenequeya siquiera tiemötocasque. Pos quisaya de tietech yejuatzi checöhualestle tli quenpajtiöya innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Hua ajcopatlachealuc, hua oquemejtaque tiemachtejcöhua. Entunses oquejtojque: ―Cuale nemocnupel nemejua tli nenporubejte, pues nenquepea pörte cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’Cuale nemocnupel tlin öxö nentejteosebe, porque nenixbesque. ’Cuale nemocnupel tli öxö nenchojchuca, porque sötiepa nenbiebetzcasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Cuale nemocnupel iyes cuöc noche tlöca nemiechtlajyelejtasque hua cuöc nemiechtojtocasque para ayecmo tli quepeasque ca nemejua, hua cuöc nemiechpöpöcasque, hua quetlajyelejtasque hasta nemotucöyo, hua ejqueu quechihuasque ipampa nenniechtoca naja öque onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Xepajpöquecö ipa inu nieca tunale, hua lalebes xecpeacö meyac pöquelestle; pues cache bieye iyes inu premio tli nenqueselisque. Pos ejqueu nuyejque inbiebetcöhua de inu giente quenchibelejque inu tlayulepantejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Cache ¡porube de nemejua tli nenricojte! Pues ye nenqueselejque nemopajpöqueles. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’¡Porube de nemejua tlin nenijixbetecate! Pues nemejua nenteosebesque. ’¡Porube de nemejua tlin öxö nenbiebetzca! Pues nemejua nenchojchucasque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’¡Porube de nemejua cuöc noche giente nemiechyectieniehuasque! Pues ejqueu inbiebetcöhua quenyectieniehuaya inu tlayulepantejque istlacateque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Cache nemiechelfea nemonochtie tli nenquecaque: Xequentlasojtlacö nemoenemigos. Xequenchibelicö tlin cuale quiejquech nemiechtlajyelejta. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xequenteochihuacö quiejquech nemiechtlabejbicaltea. Hua xomotlajtlötlajticö por öque nemiechchibelea tli amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tlö quejtus canajyeca metzmacas ipa moxöyac de momöyecmö, xejcöhua nuyejque ma metzmaca de ocsie löro. Öque metzcuejcuelis mosaröpe xejcöhua ma quebica nuyejque mocamixa. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Öque metztlajtlanelis canajyetla, xecmaca. Hua öque cönas tli mohuöxca, ayecmo xetlajtlane. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Hua quiene nenqueneque ma nemiechchibelicö giente, ejqueu nuyejque xequenchibelicö nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Tlö nenquentlasojtla sa öque nemiechtlasojtla, ¿tli cualejtelestle nenquepea? Pues nuyejque tlin tlajtlaculteque quentlasojtla öque quentlasojtla. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Hua tlö nenquenchibelea tlin cuale öque nemiechchibelea tlin cuale, ¿tlin cualejtelestle nenquepea? Pues tlajtlaculteque nuyejque ejqueu quechihua. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Hua tlö nenquentlatlaniejtea sa inu niecate de öque nenquechea que nemiechmacasque ocsajpa, ¿tlin cualejtelestle nenquepea? Pues tlin tlajtlaculteque nuyejque quentlatlaniejtea ocseque tlajtlaculteque, cuöc quemate ocsajpa cönasque iguöl tönto. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Xequentlasojtlacö, noso, nemoenemigos, hua xequenchibelicö tlin cuale ca innochtie. Hua xetietlaniejticö, hua amo xeccheacö ma nemiechcuepelicö canajyetla de tli nenquetietlaniejtea. Ejqueu nenquepeasque bieye nemopremio, hua ejqueu nieses que melöhuac nencate nentiepelhua de öque bieyetzintle lalebes iloac. Pues yejuatzi iloac cualtec hasta ca quiejquech amo tlatlasojcömate hua quiejquech amo cualteque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xomotlöocolticö noso de giente, quieme nuyejque toTajtzi netlöocoltilo. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","’Amo xetlaestlocucö, pues ejqueu amo nemiechestlöcusque. Amo xequencuntenörucö ocseque, hua amo nemiechcuntenörusque Deus. Xetlaperdonörucö, hua nemiechperdonörusque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xectiemacacö, hua nemiechmacasque. Xectiemacacö meyac, hua quetzintelaquisque hua queyectiemitisque almu cuöc nemiechmöpiqueltisque. Pues san quiene nenquentemachibelea ocseque giente, ejqueu nuyejque nemiechtemachibelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Hua quemelfiloöya sente ejiemplo. Oquejtojque: ―Sente ixcocoxque ¿cuale queyecönas ocsente ixcocoxque? Pues amo. Pues innehua betzesque ijtec coyoctle. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sente machtejque amo cache bieye momajtas que imaestro. Pero cuöc ye omomachte intiero cuale, entunses iyes quiename imaestro. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Hua taja ¿tlica tequejtelea tlasolconetzi ijtec ixtelolo mocni, hua amo tomojtelea cuabetl bieye tli taja mismo tecpea ijtec mixtelolo? ");
INSERT INTO nhgNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Quiene noso tequelfis mocni: “Nocni, xomocöhua ma temetzquextele inu tlasole tli tecpea ijtec mixtelolo”, mientras taja amo tequejta inu cuabetl ijtec mixtelolo? ¡Sa ume moxöyac! Xejquexte cachto inu cuabetl de ijtec mixtelolo taja, para que ejqueu cuale ye tequejtas hua cuale tejquextelis inu tlasole tli ijtejca ixtelolo mocni. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Pues amo onca sente cuabetl cuale tli quetiemaca ifruto hua ma iye palönque. Nimpor sente cuabetl tli amo cuale abele quetiemacas ifruto cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pues cöra sente cuabetl mixomate por ifruto. Pues amo mocuejcue icox de itech betztle, nimpor amo mocuejcue capole de itech bechöche. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sente tlöcatl cualtec quemalfea lo que tlin cuale ipa iyulo, hua cuöc tlajtlajtoa quequextea inu sösantle tlin cuale de ipa iyulo. Hua sente tlöcatl amo cualtec quemalfea sösantle tlin amo cuale ipa iyulo, hua cuöc tlajtlajtoa quequextea de inu sösantle tli amo cuale. Ipampa lo que tli öque quejtoa ca icamac quisa de inu meyac sösantle tli quetiemitea iyulo. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Tlica nenniechcuitea, “Tlöcatzintle, Tlöcatzintle”, pero amo nenquechihua lo que tli nemiechelfea? ");
INSERT INTO nhgNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Noche nieca öque yebitz noca, hua niechcaque notlajtul, hua quechihua, naja nemiechelfea quiename öquenu icaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Icaca quiename sente tlöcatl tli oquechejchi sente cale. Otlatatac bejcatla, hua oquetlöle cimiento itech tepetlatl. Hua oyejcoc ötzintle, hua inu ötzintle oquemagac checöhuac inu nieca cale, cache abele nimpor cuoline, porque omochejchi cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Cache öque quecaque tlajtule hua amo quechihua, icaca quiename sente tlöcatl öque oquechejchi cale ipan tlöle, hua amo oquetlölele icimiento. Ini nönca oquemagac checöhuac ötzintle, hua sa nima obetz. Hua omochi bieye tlaniempolebelestle de inu nieca cale. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Hua cuöc oquetlamejque noche nöncate tlajtulme hua ye oquecac noche puieblo, ocalacoac ipa inu puieblo de Capernaum. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hua ompa mococoöya hua ye oyeya para meques itlatequepano de sente capetö. Hua inu capetö lalebes quetlasojtlaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hua cuöc oquecac de Jesús, oquentitla tieca yejuatzi seque biebentzetzi de joriojte, ma tietlötlajticö ma hualbiloa hua ma quepajticö itlatequepano. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Hua cuöc ohuölajque yejua tietlac Jesús, tietlötlajtejque lalebes. Otieyelfejque: ―Ini nönca tlöcatl quemeresieroa ma xomopaliebele ejqueu, ");
INSERT INTO nhgNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pues yaja quetlasojtla tonación, hua yaja hasta otiechchejchibele sente teopanconetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Hua Jesús obiloac ca yejua. Cache cuöc ye onaxihuataya para ca ichö, oquementitla capetö ca yejuatzi seque iamigos. Otieyelfejque: ―Tlöcatzintle, amo xomopasolojtzino para tehualmobicas, pues amo necmeresieroa para tomocalaquis ipa nochö. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pues por inu nimpor amo necpensöro nehuölös mocatzinco. Cache sa xomojtalfe inun tlajtule, hua notlatequepano pajtes. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pues naja nuyejque necpea que nosujetörus para nequenneltocas tli cache quepea autoridad que naja. Hua nuyejque nequenpea soltörojte tli niechneltoca. Hua tlö nequelfea sente: “Xebeya niepa”, yaja iya. Hua tlö nequelfea ocsente: “Xehuöla”, yaja yebitz. Hua tlö nequelfea notlatequepano: “Xecchihua ini”, pues yaja quechihua. Ejqueu necasojcömate que tejuatzi tomopilea checöhualestle para tomopajtelis notlatequepano ca sente tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Cuöc oquecajque Jesús ini nönca sösantle, oquetietzöbejque de inu capetö. Onecuepaluc, hua oquemelfejque giente tli tietocaya: ―Nemiechelfea que nimpor inca giente de Israel amo onecniexte tönto lalebes meyac neltoquelestle quiename quepea ini nönca tlöcatl, mös amo de Israel icaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Hua cuöc omocuejque ca ipan chöntle tli quenhualentitla, oqueniextito inu tlatequepano ye pajtec. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Hua omochi sötiepa que yejuatzi obiloac ipa sente puieblo itucö Naín. Oyöya ca yejuatzi tiemachtejcöhua hua meyactie ocseque giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Hua cuöc axihuato itlac entröda de inu puieblo, ye ompa quequextejtöya sente mejque. Hua inöntzi mejque oyeya icnusohuatl, hua sa inu isente conie quepeaya. Oyejyeya ca yaja meyac giente de inu nieca puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Hua cuöc Tlöcatzintle oquejtaque inu sohuatl, otietlöocolte por yaja. Oquelfejque: ―Amo xechuca. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Hua onepachuluc, oquemötocaque cuajcöxa. Tli oquebicaya omoquetzque. Hua oquelfejque mejque: ―Pelalactle, naja temetzelfea, xemiehua. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Yecuöquenu omie öque ye oyeya mejque, hua opie otlajtlajto. Hua Jesús oquemöctejque inöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Hua innochtie omomajtejque, hua tiechamoöya Deus. Quejejtoöya: ―Sente tlayulepante lalebes bieye iloac entre tejua. Nuyejque quejtojque: ―Deus ohualiloac para quenpaliebisque tiegiente. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Hua omacheac de ini nönca ipa noche tlöle itlac Naín, hua ipa noche tlöle de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Hua imachtejcöhua de Xohuö oquelfejque de noche ini nönca sösantle. Hua oquennutz Xohuö unte de imachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Oquentitla tieca Tlöcatzintle. Oquemelfe ma tietlajtlanite: “¿Tejuatzi tomobetzteca inu nieiloac öque hualiloasquea, o noso tetiecheasque ocsietzi?” ");
INSERT INTO nhgNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Hua cuöc inu tlöca ohuölajque tietlac Jesús, otieyelfejque: ―Xohuö Bautista tiechhualtitlanque mocatzinco. Otiechelfejque ma temetzmotlajtlanelicö ejqueyi: “¿Tejuatzi tomobetzteca inu nieiloac öque hualiloasquea, o noso tetiecheasque ocsietzi?” ");
INSERT INTO nhgNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Mientras yejua ompa oyejyeya, Jesús oquenpajtejque meyac giente tli quepeaya cocolestle, noso tiecoco, noso moxicoöneme. Hua meyactie ixcocoxcötzetzi oquenpajtejque para ontlachixque. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Entunses onöhuatihuac Jesús, oquemelfejque: ―Xeyöcö hua xecmachesticö Xohuö de tli sösantle nenquejtaque hua nenquecajque, quiene ixcocoxcötzetzi tlajtlachea, cucuxojtzetzi ye nejneme, tli sa söhuayojque pajpajte, tzatzatzetzi tlajtlacaque, mimejque yojyulebe, hua porubetzetzi quecaque cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Hua cuale icnupel öque amo quepoloa ineltoqueles por nopampa. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Hua cuöc ye uyajque inu mensajieros de Xohuö, Jesús opiehualuc quennunutzaloöya giente acerca de Xohuö. Oquejtojque: ―¿Tli nenquejtato ompa cöne nionöque chönte? ¿Beles oyeya sente ohuatl que ca nobeyo cuoliniöya yejyecatl? Amo. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Cache, ¿tli nenquisque nenquejtato? ¿Beles sente tlöcatl tli motlaquentiöya ca tlin cuale tlaquentle? Amo. Xequejtacö, que niecate tli motlaquentea ca tlin cuöcualtzi intlaquie, hua neme ca noche tlin quenmaca pöquelestle, yejua ipa ichö de sente rey neme. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cache ¿tli nenquisque nenquejtato? ¿Beles sente tlayulepante? Quiema, hua nemiechelfea que cache que sente tlayulepante icaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Pues yaja ini nönca Xohuö de öque tlajcuelulpanca: Necö nectitlane notlatitlantle mixpa, ma quemejmelöhua moojfe mixpa. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nemiechelfea que entre innochtie tlöca, ayec otlöcat ocsente ma cache bieye momajta que Xohuö. Cache öque lalebes tzitzequetzi cöne Deus tlamandöruro cache bieye ica que Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Hua noche giente hua tli tlanechecojque, cuöc oquecajque itlanunutzales de Xohuö, oquejtojque que de melöhuac iloac yectec Deus, hua omocuötiequejque ca inu tlacuötiequelestle de Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Cache inu fariseos ca tiehua tlajmatque de inu ley de Moisés amo oquenejque lo que tli Deus quenequihuaya para yejua, pues amo omocuötiequejque ca Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","’Entunses ¿ca tli nejcomparörus nönca giente de nönca tiempo? ¿Öque sabele cate? ");
INSERT INTO nhgNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cajcate quiename pelalacme tli motlajtlölea ipa plösa para majöbeltisque, hua motzajtzajtzelea seque ca ocseque. Quejejtoa: “Amo nemajöbeltea cuale. Pos tejua tontlapitzque ca tlapitzale para ma xomojtuticö, pero amo nemojtutejque. Otechuquescuejcuicaque, pero amo nenquenejque nenchojchucaque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pues ye ohuöla Xohuö Bautista, que tlajyubiöya, hua amo coniya vino, hua nenquejtoa: “Quepea demunio”. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Onehuöla naja öque onochi netlöcatl, que netlacua hua necone, hua nenquejtoa: “Xequejtacö necö sente tlöcatl lalebes tlacuöne hua tlöhuönque, hua lalebes cuale mobica ca tlanechecojque hua ocseque tlöca tlajtlaculteque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero noche giente tli tlajmatque momacasque cuienta que toconchijque tlin tlajmatque. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Hua sente de inu fariseos oquenec ma tlacualute Jesús ca yaja. Hua ocalacoac ipa ichö de inu fariseo, hua onetlöliluc para tlacualus. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hua oyeya ipa inu puieblo sente sohuatl tli oyeya tlajtlacultec lalebes. Cuöc yaja ocasojcömat nele ye tlacualoöya pa ichö de inu nieca fariseo, oquehualecac sente potixajconetzi de alabastro tli quepeaya pajtle ajfeyoc. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Hua omoquetz ca tiecuetlapa ca tieicxetla, hua ochucac lalebes. Otieicxepaltele ca ixöyu, hua tiepojpoöya ca itzo. Quenpetzoöya tieicxehua hua ipa quetlöliöya inu pajtle ajfeyoc. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Hua cuöc oquejtac ini nönca inu fariseo öque tietlalfe, oquejto ijtecopa: “Ini nönca tlöcatl, tlö melöhuac oyene sente tlayulepante, quematesquiöne öquenu quemajmötoca hua tli clase de sohuatl icaca, pues icaca tlajtlacultec”. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Entunses onöhuatihuac Jesús, oquelfejque: ―Semu, necpea tlimach para temetzelfis. Hua yaja oquejto: ―Xomojtalfe, Maestro. Jesús oquelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","―Unte tlöca quetietlabiquelejtaya ca sente tlöcatl que tietlacueltea tomi. Sente quetiebiquelejtaya quinientos pesos, hua inu ocsente sa cincuenta. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Hua amo quepejpeaya tli ica quecuepelisque. Entunses inu tlöcatl oquenperdonörfe innehua. ¿Öquenu de innehua noso quetlasojtlas cache? ");
INSERT INTO nhgNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Hua onöhuat Semu, oquejto: ―Necnenebelea que öque queperdonörfe cache meyac. Hua yejuatzi oquelfejque: ―Melöhuac otequejtac cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Hua onecuepaluc ica sohuatl. Oquelfejque Semu: ―¿Tequejta ini nönca sohuatl? Naja onecalac ipa mochö, hua amo teniechmacac ötzintle para nocxehua. Cache ini nönca ocajfeche nocxehua ica ixöyu, hua oquenpojpu ca itzo. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nimpor amo oteniechmacac petzule, cache ini nönca, desde cuöc onecalac, quesequiroa quepetzojteca nocxehua. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amo teniechajalöbele ipa notzonteco nion ca oleo, cache ini nönca ocajalöbele nocxehua ca pajtle ajfeyoc. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hua por inu temetzelfea que cuale tequejta que ye omoperdonöro inu meyac tlajtlacule tli oquechi, pues niechtlasojtla lalebes. Cache öque amo bel meyac itlajtlacul tli omoperdonöro, amo bel tietlasojtlane. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Hua oquelfejque sohuatl: ―Ye omoperdonöro motlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Hua inu giente tli ompa tlacuöya ca yejuatzi opiejque quejtoa imijtecopa: “¿Öquenu ini nönca tlöcatl que nuyejque tieperdonörfea tlajtlacule?” ");
INSERT INTO nhgNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús oquelfejque sohuatl: ―Por tomoneltocac ye otomomöquexte. Xebeya ca cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Hua sötiepa de inu, yejuatzi biloatenemeya ipa ciudades hua puieblos. Tlanunutzalutenemeya hua quemelfiloöya giente de inu cuale tlamachestelestle de quiene Deus tlamandöruro. Hua inu majtlactle huan ume tiemachtejcöhua oyöya ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Hua seque sohuame tli opajteque de moxicoöneme hua de sösantle cocolestle nuyejque oyöya tieinca, hua tieinpaliebiöya ca lo que tli quepejpeaya. Entre yejua oyeya María tli mocuitiöya Magdalena porque oyeya de puieblo de Magdala. Pos checume demunios oquisque de ijtec María. Nuyejque oyeya Xohuana, öque oyeya isohua de Chuza, inu maortumo de inu rey Herodes. Nuyejque oyeya Susana, hua ocseque meyactie sohuame. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Hua omosentlölejque meyac giente. Ohuölajque de ipa noche puieblos tietlac yejuatzi. Entunses otlajtlajtuluc por medio de sente cuiento. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Sente tlöcatl oquis oquetucato xenöchtle. Hua cuöc quecuasemanaya hua tlatucataya, seque obetz ipa ojtle. Giente ipa moquetzque hua tutume tli patlöne ipa yejyecatl oquecuajque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ocseque obetz icpac teme. Cuöc oquis, sa nima uhuöc, ipampa amo quepeaya cuechöhualutl. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Hua ocseque obetz itzölö betztle. Omobepö tlatuctle ca tiehua betztle, hua betztle oquepötzmecte. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Hua ocseque obetz ipan cuale tlöle. Omobepö, hua tlamochihualte hasta sie sientos töntos. Hua cuöc oquejtojque ini nönca sösantle oquejtojque checöhuac: ―Öque quepea itlacaqueles para tlacaques ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Hua tiemachtejcöhua otietlajtlaneliöya tli quejtusneque inu cuiento. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hua yejuatzi oquejtojque: ―Nemejua nemiechtocöroa nenquematesque inu secrietos de quiene ca tlamandörurus Deus. Pero inu ocseque sa nequenmachtea ca cuientos para mös tlacheasque amo quejtasque, hua mös quecaquesque amo casojcömatesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Yaja ini nönca tli quejtusneque inu cuiento. Inu xenöchtle yaja tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Hua tli obetz itienco ojtle, yejua cate giente tli quecaque teotlajtule, hua yebitz Diöblo, hua quejcuenea tlajtule de ipa inyulo, para majcamo moneltocacö hua majcamo momöquexticö. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Hua tli obetz ipan teme, yejua cate giente tli ye oquecajque, hua cöna tlajtule ca pöquelestle. Pero pasörebe que tlajtule amo monelhuayutea imijtec. Pues por sie röto monejneltoca, pero cuöc impa yebitz tequepachule, ayecmo quesequiroa. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Hua xenöchtle tli obetz itzölö betztle, yejua cate giente tli oquecajque, cache cuöc uyajque, motequepachoa por ocseque sösantle, hua quetiemoa ricojyutl hua sösantle cualtzetzi de tli onca ipa nönca nemelestle, hua inu sösantle quieme cana quepötzmectea tlajtule. Por inu amo mobepöhua cuale inu xenöchtle, hua tlajtule amo quepea iresultödo cuale inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Cache tli obetz ipan cuale tlöle, yejua cate giente tli quepea tlin cuale inyulo hua melactec. Yejua, cuöc quecaque tlajtule, quemalfea, hua quesequiroa quechijtecate de noche tlin cuale tlachihuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","’Cuöc canajyeca quexutlaltea sente cantil amo quetlapachoa ca sente cumetl, o noso amo quetlölea itzintla tlapechtle. Cache quetlölea ipa canteliero, para ejqueu innochtie tli calaque ijtec cale ma quejtacö tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pos noche tli mojyönteca nieses sötiepa. Hua noche tli sa ichtacajtzi sötiepa ixnieses hua macheas. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Xecpeacö cueröro noso quiene nenquecaque. Pos tiel öque quepea, quemacasque cache meyac. Pero öque amo bel quepea, inu nieca quequextelisque hasta inu tepetzi tli quepensöroa que oc quepea. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tienönajtzi hua tieicnihua ohuölajque tieca Jesús hua abele onaseya hasta tietlac ipampa lalebes meyac giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Hua giente otieyelfejque: ―Monönajtzi ca tiehua mocnijtzetzihua cate ca queyöhuac. Quenejneque metzmojtelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Hua yejuatzi oquennönquelejque, oquemelfejque: ―Nonöna hua nocnihua yejua niecate tli quecaque tietlajtultzi Deus, hua quechihua tli quemelfea. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Hua omochi que sie tunale ocalacoac ijtec sente börco yejuatzi ca tiehua tiemachtejcöhua. Oquemelfejque: ―Ma tepanucö ca nie löro de ötiescatl. Hua obejbiloac. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cache mientras bejbiloaya, yejuatzi ocochihuatöya. Hua ohuölajtequis sente yejyecatl checöhuac ipa inu nieca ötiescatl. Hua inbörco otiemeya de ötzintle, hua ye miero pötzcalaqueya. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Hua omopachojque tiemachtejcöhua hua otieixetejque. Otieyelfejque: ―¡ToTlöcatzi, toTlöcatzi, temequesque! Yecuöquenu niehualuc. Cajajuaque öyejyecatl ca tiehua ötzintle tli majcoqueya ca tlabiele. Hua omoquetz por complieto hua tlacacta. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Hua oquemelfejque: ―¿Tlica amo nemoneltocaque? Hua yejua omajcömejque, hua oquetietzöbejque. Omolfiöya sie yejua: ―¿Öqueniji, noso? Pos hasta yejyecatl hua ötzintle quennahuatilo, hua tieneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Hua onajaxihuato intzölö giente de puieblo de Gerasa. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Hua cuöc ye oquixoac de börco hua ohualiloac ca ipan tlöle, sente tlöcatl de inu puieblo que quepeaya demunios ohualie tienömequeco. Ye quepeaya meyac tiempo amo tli möquiöya, nimpor amo chönteya ijtec cale, cache chönteya ipa camposönto. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Ini nönca, cuöc otieyejtac Jesús, otzajtzec checöhuac hua omopechtiecato tieixtla. Oquejto ca checöhuac tlajtule: ―¿Tli tomopilea ca naja, Jesús, tieConietzi Deus bieyetzintle? Temetzmotlötlajtelea amo xeniechmococolfe ica tiecoco tietunie. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pues yejuatzi ye quenahuatilutaya ma quisa moxicoöne de inu tlöcatl. Pues ye meyacpa quepasöroöya inu tlöcatl que moxicoöne quequitzquiöya. Giente quetzajtzacuaya hua quejilpiöya ca carienajte ipa icxehua hua imöhua. Pero yaja quecocotunaya tli ica quejilpiöya, hua inu demunio quechihualtiöya ma beya ca cöne nionöque chönteya. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Hua Jesús oquetlajtlanejque: ―¿Quiene tomotucö? Yaja oquejto: ―Nocuitea Trupa. Pues meyactie demunios ocalajque ijtecopa yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hua inu demunios tietlötlajtiöya majcamo quentitlanecö ipa inu tlatecoyöbelespa bejcatla. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hua ompa oyeya meyactie petzome tlajtlacuajtenemeya ipa inu nieca tepietl. Entunses inu moxicoöneme tietlötlajtejque ma quencöhuacö ma calaquecö imijtecopa de petzome. Yejuatzi oquencöjque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Entunses inu demunios quistiejque de ijtecopa tlöcatl hua ocalaqueto imijtecopa petzome. Cuöquenuju omomiemeröjque noche petzome motietepexebito hasta ijtec ötiescatl, hua ompa oöijyumejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Inu tlöca tli quentlajtlacualtejtenemeya petzome, cuöc oquejtaque tli omochi, ochucholojtiejque. Tlamachestito ipa puieblo hua ca caltienco. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pues oquisque giente oquejtato tli omochi. Hua ohuölajque tieca Jesús. Oqueniextito inu tlöcatl de öque itech oquisque demunios, que ye möquejtaya itzotzomajua, hua ayecmo lucojtec. Yehuataya tieicxetla Jesús. Pos yejua giente omomajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Entunses yejua tli miero quejtaque lo que opasöre oquepujque, quiene pajtec inu nieca. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yecuöquenu noche inu niecate giente de puieblo de Gerasa hua de ocseque tlölte tli ca ompa itech, otietlötlajtejque ma biloa de ompa, ipampa lalebes momajtiöya. Hua yejuatzi ocalacoac ipa börco para onecuepaluc. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hua inu nieca tlöcatl, de öque ijtec oquisque demunios, otietlötlajte ma seme iye tietlac. Cache Jesús oquetitlanque ma beya. Oquelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Xomocuepa ca mochö, hua xecpoa noche tli bieye tlachihualestle oquechijque Deus ca taja. Hua yaja uya, otlanunutztöya ipa noche inu puieblo de tli bieye tlachihualestle oquechijque Jesús ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Cuöc Jesús onehualnecuepaluc, otieselejque giente ca pöquelestle, pues innochtie tiechixtaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Yecuöquenu ohuöla sente tlöcatl itucö Jairo, tlayecönque de teopanconetzi. Yaja omopechtiecac tieicxetla Jesús. Tietlötlajtiöya ma biloa pa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pos yaja quepeaya sa sente ichpuch, tli quepeaya quieme majtlactle huan ume xebetl. Ini nönca ye omectaya. Hua cuöc yejuatzi biloaya ca ichö de Jairo, tiepötzoöya giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hua sente sohuatl ye mococoöya majtlactle huan ume xebetl de itlapalyeso. Ye oquecastöro noche itomi inca miercojte, hua nionöque abele oquepajte. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Yaja oaseto ca tiecuetlapa Jesús hua oquemötocac itienco de tietlaquie. Hua nima omoquetz itlapalyeso. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesús oquejtojque: ―¿Öquenu yaja oniechmötocac? Innochtie oquejtojque que yejua amo tiemötocaque. Entunses oquejto Piero: ―NoTlöcatzi, noche ini meyac giente metzmopötzelfea. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Hua Jesús oquejtojque: ―Yeca oniechmötocac. Pos onecmachele que oquis checöhualestle de notech para onetlapajte. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yecuöquenu, inu sohuatl omomacac cuienta que abele mojyönas. Omopacho mös bebeyocaya lalebes, hua omopechtiecac tieicxetla. Hua oquepu imixtla noche giente tli ipampa otiemötocac, porque mococoöya, hua quiene sa nima opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yejuatzi oquelfejque: ―Nochpuch, por que tomoneltocac ye tepajtec. Xebeya ca cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Mientras yejuatzi oc tlajtlajtulutaya, ohuöla sente tlöcatl desde ichö de inu tlayecönque de teopanconetzi. Oquejto: ―Pos mochpuchtzi ye omec. Ayecmo xetiemotequemaquele nöiloac maestro. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero Jesús oquecajque, hua oquenönquele: ―Amo xomomajte. Sa xomoneltoca, hua pajtes. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Hua cuöc axihuato ipa ichö, amo öque oquecöjque ma calaque tiehua tlöcamo sa yaja Piero, ca Jacobo, hua Xohuö, ca tiehua itajtzi hua inöntzi de inu sisehuantu. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Hua chojchucaya innochtie giente, hua chuquestlajtoöya porque omec sisehuantu. Hua yejuatzi oquejtojque: ―Amo xechucacö. Pos amo omec, tlöcamo sa cochteca. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Cache moburlörojque de yejuatzi, pues oquemajtaya yejua que ye omec. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero yejuatzi caseque imö sisehuantu, hua oquenutzque. Oquejtojque: ―Sisehuantu, xemiehua. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Hua inemeles omocuec, hua sa nima omie. Hua yejuatzi otlanahuatejque ma quetlamacacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pos itötajua quetietzöbejque. Pero yejuatzi quennahuatejque majcamo öque quemachesticö de tli omochi. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Hua yejuatzi oquennutzque inu majtlactle huan ume tiemachtejcöhua ma mosentlölicö. Oquenmacaque checöhualestle hua beletelestle para quenquextisque noche demunios, hua para quepajtisque cocolestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hua oquentitlanque ma tlanunutzacö de quiene tlamandöruro Deus, hua ma quenpajticö tlin cocoxcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Hua oquemelfejque: ―Amo tli xecbicacö para pa ojtle, nimpor cuajfortu, nimpor morröl, nimpor tlaxcale, nimpor tomi, nimpor amo xecbicacö unte tlaquieme. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Hua ipa tli beletes chöntle nencalaquesque, ompa xomocöhuacö hasta que de ompa nenquisasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Pero tlö seque giente amo nemiechselisque, cuöc nenquisasque de inu nieca puieblo xectzetzelucö noche tlöle de nemocxehua. Yaja inu xecchihuacö para quematesque que amo cuale tli oquechijque yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Hua yejua onyajque, hua yajyajtenemeya ipa noche puieblos. Tlamachestejtöya de inu cuale tlamachestelestle, hua tlapajtejtöya ca nobeyo. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hua Herodes inu tetrarca noso rey oquemat de noche ini sösantle tli omochi. Hua yaja amo quemateya tli quejtus, ipampa quejejtoöya seque que Xohuö ye oyule de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hua ocseque quejejtoöya que inu tlayulepante Elías ye onhuöla ocsajpa, hua ocseque quejejtoöya beles yeca ocsente tlayulepante de ca ye niepa ye oyule. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hua oquejto Herodes: ―Pos Xohuö naja onejquechtec. ¿Öquenu noso iyes ini nönca tlöcatl, de öque nejcaque tönto meyac sösantle? Hua quetiemoöya maniera quiene tieyejtas Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Hua omocuejque tietlateotitlanhua. Tiepubelejque noche tli oquechijque. Hua yejuatzi obiloac ca tiehua yejua sa nencua ca ipa tlöle itlac inu puieblo itucö Betsaida. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero inu giente omomacaque cuienta de cöne obiloac, hua otietocaque. Hua yejuatzi oquenselejque. Quennunutzque de quiene Deus tlamandöruro, hua quenpajtiloöya tlin quenesesitöroöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Mientras otlameya tunale. Inu majtlactle huan ume tiemachtejcöhua omopachojque tietlac. Otieyelfejque: ―Xequenmotitlane giente ma yöcö pa puieblos hua pa rönchos hua ca ompa ma mocaluticö hua ma tlacuöcö. Pues amo öque chönte necö cöne tecate. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Hua oquemelfejque: ―Nemejua xequentlamacacö. Oquejtojque yejua: ―Amo tecpea tlöcamo möcuile pöntzi hua unte mimechte. Hua abele tejcoatibe tejua tlacuale para noche ini nöncate tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pos oyeya quieme möcuile mil tlöca. Yecuöquenu oquemelfejque tiemachtejcöhua: ―Xequemelficö ma motlajtlamachtlölicö ca grupos de tlötlajco sientos. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Hua ejqueu oquechijque, oquenchihualtejque ma motlölicö innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Entunses ocönque inu möcuile pöntzi hua inu unte mimechte. Ajcopatlachealuc ca elfecac. Oqueteochijque tlacuale hua oquecocototzque. Entunses oquenmacaque tiemachtejcöhua para ma quentlacualticö giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Hua otlacuajque innochtie, hua ijixbeque. Hua ocajcojque majtlactle huan ume chequejme de tli omocö cojcotoctec. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Hua sötiepa yejuatzi iloaya tiesiel netlötlajtilutaya. Tietlac oyejyeya tiemachtejcöhua. Hua oquentlajtlanejque, oquemelfejque: ―¿Öquenu quejtoa giente que naja necaca? ");
INSERT INTO nhgNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Hua yejua onöhuatque, oquejtojque: ―Pos seque quejejtoa que Xohuö Bautista. Ocseque quejejtoa nele inu tlayulepante Elías. Hua ocseque quejejtoa que beles yeca ocsente tlayulepante de ca ye niepa ye oyule. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Hua oquemelfejque: ―Hua nemejua, ¿öquenu nenquejtoa que naja necaca? Yecuöquenu onöhuat Semu Piero, oquejto: ―Tejuatzi tomobetzteca teCristo, öque metzmixpejpenelejque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Cache yejuatzi oquennahuatejque hua oquenmandörojque majcamo öque quelficö ini nönca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Oquejtojque: ―Conbenierebe que naja öque onochi netlöcatl ma necsufriro meyac sösantle, hua ma niechtlajyelejtacö biebentzetzi hua jefes de teopexcötzetzi, hua tlamachtiöneme de teotlajtule. Niechmectisque hua ipa yeye tunale neyulebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hua quemelfiloöya innochtie: ―Tlö canajyeca queneques niechtocas majcamo quechihua lo que tli sie yaja queneque. Cache ma iye listo para quesufrirus cöra tunale quiename öque quesufriroa ipa sente corujtzi, hua ma niechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pos öque beletes queneques quemalfis inemeles, quixniempolus. Hua öque beletes quetiemacas inemeles nopampa, quemalfis. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pues ¿tli para serbirebes tlö sente tlöcatl quetlönes noche tlöltecpactle, pero polebes o noso ixniempolebes yaja mismo? ");
INSERT INTO nhgNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tlö sente tlöcatl pinöhuas de naja hua notlajtul, nuyejque naja que onochi netlöcatl nepinöhuas de inu tlöcatl cuöc nehuölös ca notlaniexteles hua ca tietlaniexteles de noTajtzi hua de öngeles tli yecteque. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Hua melöhuac nemiechelfea, que seque de tli oncö nencate amo mequesque hasta senamo quejtasque quiene tlamandörurus Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Hua quiename checuieye tunale sötiepa de que oquejtojque ini nönca tlajtule, ejqueyi omochi. Oquenbicaque Piero hua Xohuö hua Jacobo, hua otlejcoac ipa tepietl para netlajtlötlajtiluto. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Hua mientras netlajtlötlajtilutaya, tiexöyac omocuec ocsie, hua tietzotzomajua omochijque istöque hua tzotzotlaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hua unte tlöca tlajtlajtoöya tieca. Yejua oyeya Moisés hua Elías. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Omoniextejque ca tlaniextelestle. Tlajtlajtuloöya de quiene yejuatzi ye miero mecoas ipa inu ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Hua Piero hua icompanierojua lalebes cojcochesnequeya. Pero cuöc otlachixque, oquejtaque tietlaniexteles, hua quemejtaque inu unte tlöca tli oyejyeya tieca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Hua omochi que cuöc inu tlöca ye omoxeloöya de yejuatzi, Piero otieyelfe Jesús: ―NoTlöcatzi, cuale que oncö tecate. Ma tequenchejchihuacö yete cuajtlapame: sente para tejuatzi, hua sente para Moisés, hua ocsente para Elías. Pos yaja amo quemateya tli quejtojtaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hua cuöc yaja quejtojtaya ini nönca, ohuöla sente mextle hua oquentlapacho. Yejua omomajtejque cuöc ocalajque ijtec mextle. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ohuöla sente tlajtule de ijtec mextle. Quejtoöya: ―Yaja ini nönca noConie, öque naja nequixpejpe. Yaja xejcaquecö. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Hua cuöc opanuc inu nieca tlajtule, Jesús sa tiesiel otieijtaque. Hua yejua amo tli oquejtojque. Hua ipa inu niecate tunalte nionöque amo tli oquepubelejque de tli yejua oquejtaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hua omochi ipa mustlateca, cuöc ye hualtejtemoac de ipa inu nieca tepietl, que meyac giente tienömequeto. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yecuöquenu otzajtzec sente tlöcatl de tli ompa oyöya. Oquejto: ―Maestro, temetzmotlötlajtelea xomojtele noconie. Pos sa yaja necpea. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Hua xtele sente moxicoöne case, hua sa trepiente tzajtzetequisa. Hua moxicoöne quechihualtea ma checöhuac mimeque hua ma camapoposune. Hua amo quecöhua nima hasta que ye lalebes quecocojtiehua. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Hua nequentlötlajte momachtejcötzetzihua ma quequexticö hua abele oquechijque. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Hua onöhuatihuac Jesús, oquejtojque: ―¡Ay! ¡Nentlöca que amo nemoneltoca hua amo nenquepensöroa lo que tli melöhuac! ¿Hasta quiema nemotlac neyes, hua necpeas que necxicojtas ca nemejua? Xejcualeca moconie necö. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Hua cuöc yaja mopachoöya, inu demunio oquechihualte pelalactle ma betze hua ma checöhuac mimeque. Cache Jesús ocajajuaque inu moxicoöne, hua quepajtejque inu pelalactle. Oquetiemöcte ca itajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Hua innochtie oquetietzöbejque de quiene bieye lalebes iloac Deus. Pero mientras innochtie oquetietzöbejtaya de noche sösantle tli oquechijque yejuatzi, oquemelfejque tiemachtejcöhua: ");
INSERT INTO nhgNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Xejcaquecö cuale para nenquelnömectasque tli nemiechelfis: que naja que onochi netlöcatl niechtiemöctisque inmöpa tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cache yejua amo casojcömateya ini nönca tlajtule, pues Deus amo quenmachestejque para que ejqueu abele ocasojcömatque. Hua quenmajtiöya tietlajtlanesque Jesús de ini nönca tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yecuöquenu yejua motlötlajtlaniöya öque de yejua cache bieye momajtas. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Cache Jesús oquematque quiene ca monenebeliöya ipa inyulo. Entunses ocaseque sente peltzintle, hua oquetlölejque tietlac. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Oquemelfejque: ―Öque queselis notucöyupa ini nönca peltzintle nuyejque naja niechselea. Öque niechselea naja nuyejque tieselea yejuatzi öque niechhualtitlanque. Pos öque mochihuas cache tzitzequetzi nemotzölö nemejua, yaja inu nieca bieye momajtas. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yecuöquenu onöhuat Xohuö, oquejto: ―ToTlöcatzi, otequejtaque sente tlöcatl motucöyupantzinco quenquextiöya demunios. Pues inu nieca tlöcatl amo tiechtoca, hua por inu otequelfejque ma ayecmo quesequiro. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús oquelfejque: ―Amo xecchihuacö ejqueu. Pues öque amo icaca cuntra nemejua, ca nemejua icaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Hua omochi que oaseco tiempo para ye miero tlejcoas tlacpac tieca Deus. Hua yejuatzi cache quenelchijque para biloas ipa ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Hua oquentitlanque seque mensajieros ma yöcö delönte de yejuatzi. Yejua uyajque hua ocalajque ipa sente puieblo de estado de Samaria, para ompa queyejyectlölisque locör para yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero giente de inu puieblo amo tieselejque, ipampa quemateya que yejuatzi biloaya ca Jerusalén, hua giente de Samaria amo quencualejta joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hua tiemachtejcöhua Jacobo hua Xohuö, cuöc oquejtaque, oquejtojque: ―Tlöcatzintle, ¿tomonequitea ma tetlanahuaticö ma betze tletzintle de elfecac para ma quenpojpolo? ");
INSERT INTO nhgNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yecuöquenu onecuectzinuc yejuatzi, hua oquemajajuaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Hua obejbiloac ipa ocsente puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Hua omochi que cuöc obejbiloac yejuantzetzi, sente tlöcatl otieyelfe: ―Naja temetzmotoquelis ca cöne beletes tomobicas. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Hua Jesús oquelfejque: ―Coyume quenpea inustuhua, hua tutume tli patlöne ipa yejyecatl quepea intepasol. Cache naja, öque onochi netlöcatl, amo necpea cöne necsiebis notzönteco. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Hua oquelfejque ocsente: ―Xeniechtoca. Pero yaja oquejto: ―Tlöcatzintle, xeniechmocöbele ma nebeya cachto ma nectlölpachute notöta. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Hua Jesús oquelfejque: ―Xequencajcöhua que mimejque ma quentlölpachucö inmimejcöhua. Taja xebeya, xetlanunutza de quiene tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Hua ocsente tlöcatl oquejto: ―Temetzmotoquelis, Tlöcatzintle, cache ma cachto nequennahuatite tli cate pa nochö. ");
INSERT INTO nhgNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero Jesús oquelfejque: ―Öque queneque mocuepas ica quiename sente tlöcatl que quetlölea imö ipa iaröro hua sötiepa tlachea ca icuetlapa. Amo conbenierebe ma quepea pörte inu tlöcatl cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Hua sötiepa de ini nönca sösantle, Tlöcatzintle Jesús oquemixpejpenque ocseque setenta y dos tlöca. Ini nöncate oquentitlanque ca ojunte ipa noche puieblos hua noche locör cöne yejuatzi hualiloasquea. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hua quemelfiloöya: ―Inu meyac giente cate quiename sente tlamochihualestle tli bieye ica, pero tejua tli tepejpexca sa quiesquete tecate. Xetietlajtlötlajticö noso öque tiehuöxca tlatuctle ma quenhualentitlanecö cache meyactie tequetque para pexcasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xeyöcö. Xequejtacö cuale que nemiechtitlane quieme cana nencalnielojcucone intzölö de coyume tiecuöneme. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xecbicacö tomi, nimpor sente morröl, nimpor sapötoste. Hua nionöque amo xectlajpalucö ca pa ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Hua ipa tli beletes chöntle nencalaquesque, cachto xequejtucö: “Ma yecsiebelestle iye ca nemejua de ini nönca chöntle”. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Hua tlö ompayes sente tlöcatl tli quemeresieroa yecsiebelestle, inu bendeseyu de yecsiebelestle tli nenquemacaque mocöhuas ipa yaja. Hua tlö quejtus amo quemeresieroa, nemobendeseyu de yecsiebelestle amo mocöhuas ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hua ompa xomocaluticö ipa inu nieca chöntle. Xejcuöcö hua xeconicö tli sösantle nemiechmacasque. Pos tequetque quepea deriecho de que motlaxtlöbis. Amo xomopatlacö de chöntle para nemocalutisque ipa ocsente chöntle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Hua ipa tli beletes puieblo nencalaquesque, tlö nemiechselea, xejcuöcö tli sösantle nemiechmacasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Xequenpajticö tli cocoxcötzetzi ompa yesque, hua xequemelficö: “Ye oaseco tunalte para Deus tlamandörurus ca nemejua”. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Cache ipa tli beletes puieblo nencalaquesque, tlö amo nemiechselea, xequisacö ca ipa cayajunte. Xequejtucö: ");
INSERT INTO nhgNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Ini tlöle de nemopuieblo tli omotzeco ipa tocxe tectzetzeloa porque nenquechijque tli amo cuale. Pero xecmatecö ini nönca, que ye miero tlamandörurus Deus”. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hua nemiechelfea que ipa inu nieca sölúltimo tunale, cache petzotec iyes para inu puieblo que para inu ciudad de Sodoma que lalebes tlajtlacultec oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’¡Porube de taja, puieblo de Corazín! ¡Porube de taja, puieblo de Betsaida! Ipampa tlö pa inu ciudades de Tiro hua Sidón omochihuane tietzöbetlachihualestle tli omochi ca nemejua, ye yecsa omoyulcuepane. Yejyehuatasquiöne ica intlaquie de luto hua ca tlaconextle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Por inu, cuöc Deus tlajuscörurus, cache petzotec iyes para nemejua que para inu ciudades de Tiro hua Sidón. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Hua taja, puieblo de Capernaum, ¿beles tecpensöroa temajcoques hasta elfecac? Pues amo, cache metztemobisque hasta mectlöncale. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Öque nemiechcaque nemejua, naja nuyejque niechcaque. Öque nemiechtlajyelejta nemejua, naja nuyejque niechtlajyelejta. Hua öque niechtlajyelejta naja, tietlajyelejta nuyejque öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Entunses onyajque inu *setenta y dos tlöca. Hua hualmocuejque ca meyac pöquelestle. Oquejtojque: ―Tlöcatzintle, hasta demunios mosujetöroa ca tejua cuöc tequennahuatea motucöyupantzinco. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Hua yejuatzi oquemelfejque: ―Naja nequejtaya cuöc inu Satanás obetz de elfecac quiename betze tlapetlönelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hua xequejtacö, nemiechmaca checöhualestle para nemoquejquetzasque impa cuhuöme hua impa culume, hua ipa noche ichecöhuales de inu enemigo que yaja Diöblo. Hua niontle de inu sösantle abele nemiechcocus. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Cache amo xepajpöquecö sa ipampa inu moxicoöneme mosujetöroa nemoca, cache xepajpöquecö ipampa nemotucöyu ye tlajcuelulpanca ompa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ipa inu nieca ura Jesús pajpocoac ca Espíritu Sönto. Oquejtojque: ―Naja temetzmomabesutelea, noTajtzi, Tlöcatzintle de elfecac hua de tlöltecpactle, pues tejuatzi otomojyönele ini nönca sösantle de tlin tlajmatque hua cajasojcömateneme hua otequenmoniextelele tli cate quiename pelantzetzi. Pues ejqueu, noTajtzi, otomocualejtele. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","’Noche sösantle ye niechmöctejque noTajtzi. Hua amo öque quemate öquenu tieConietzi tlöcamo sa yejuatzi Tajtle. Nuyejque amo öque quemate öquenu Tajtle, tlöcamo sa tieConietzi quemate öquenu Tajtle iloac, hua nuyejque quemates inu tlöcatl öque tieConietzi Deus queneques tieniextis ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Hua onecuepaluc ocsajpa sa ca belejua tiemachtejcöhua. Oquejtojque: ―Cuale nemocnupel ipampa nemoixtelolojua quetztecate ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pues nemiechelfea que meyactie tlayulepantejque hua reyes de pa nieca tiempo quenejnequeya quejtasque tli nenquejta, pero abele quejtaque; hua quenejnequeya quecaquesque tli nenquecaque, pero abele oquecajque. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Hua necö, sente tlajmatque de inu ley de Moisés omoquetz. Quenequeya tieprobörus. Otieyelfe: ―Maestro, ¿tlin sösantle necchihuas para necpeas nemelestle nochepa? ");
INSERT INTO nhgNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Hua yejuatzi oquelfejque: ―¿Tli tlajcuelulpanca ipa inu ley? ¿Quiene tectlajtultea? ");
INSERT INTO nhgNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Hua yaja onöhuat, oquejto: ―“Tetietlasojtlas Tlöcatzintle moDeus ca noche sentetl moyulo, hua ca noche sentetl moölma, hua ca noche mochecöhuales, hua ca noche mopensamientos”. Hua “Motlöcaicni tectlasojtlas quiename taja mismo tomotlasojtla”. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Hua Jesús oquelfejque: ―Cuale otenöhuat. Xecchihua inu, hua tenemes. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Cache yaja quenequeya ma quejtucö Jesús que yaja quechihuaya cuale. Por inu, otieyelfe Jesús: ―¿Öquenu icaca notlöcaicni? ");
INSERT INTO nhgNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Hua onöhuatihuac Jesús, oquejtojque: ―Sente tlöcatl oquis de ipan ciudad de Jerusalén. Temoöya ipan ojtle pa ciudad de Jericó. Ocaseque ichtejque, hua quecuejcuelejque noche itzotzomajua hua noche tli quepeaya. Quetebejbitejque, hua hasta quemejcötiecaque, hua uyajque. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Hua omochi que ohuöla sente teopexque ipa inu ojtle. Hua cuöc oquejtac, sa oquepanabe pa ocsie löro de ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hua ejqueu sente de inu levitas tli tlatequepanoa ipan teopantle nuyejque oaseto ipa inu nieca locör. Hua inu levita oquejtac tlöcatl, pero nuyejque sa oquepanabe pa ocsie löro. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Cache sente tlöcatl de Samaria ca ompa oyöya. Hua cuöc ohuöla itlac hua oquejtac, oqueyulcoco. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hua omopacho itlac. Oquequemelo cöne quecocoa. Oquetlölele asiete hua vino para ma pajte. Oquetlejcabe ipa iyulcö, hua oquebicac ipa mersu, hua oquixute yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Hua ipa mustlateca cuöc ye iyös, oquequexte ume monedas, hua oquemacac chöne. Hua oquelfe: “Xeniechmixutelele, hua noche tli ocseque tomocastörfis por yaja, naja cuöc nocuepas temetzmotlaxtlöbelelis”. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","’¿Öquenu, noso, de ini nöncate yeteme ca tequejta icaca itlöcaicni de inu nieca öque obetz inmöpa inu ichtejque? ");
INSERT INTO nhgNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Hua inu tlajmatque oquejto: ―Öque oquepile icnuejtelestle. Yecuöquenu Jesús oquelfejque: ―Xebeya, hua xecchihua ejqueu nuyejque taja. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Hua cuöc obejbiloac, ocalacoato ipa sente puieblo. Hua sente sohuatl itucö Marta otiecalute. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yaja quepeaya sente icni itucö María. Inu María omotlöle tieicxetla Jesús. Queyejcaqueya tli yejuatzi quejtuloöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Cache Marta motequepachoöya por quechihuaya meyac sösantle tequetl para quechihuas tlacuale. Hua omopacho, hua oquejto: ―Tlöcatzintle, ¿amo temetzmimportörfea que nocni sa nosiel niechcajcöhua ma netlatequepano? Xomolfele noso ma niechpaliebe. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Tlöcatzintle onöhuatihuac, oquelfejque: ―Marta, Marta, lalebes tomotequepachoa hua tomopasoloa por meyac sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Cache sa sente sösantle inu monesesitöroa. Hua María oquixpejpe inu tlin cache cuale. Hua amo öque quecuejcuelis. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Hua omochi que yejuatzi netlajtlötlajtilutaya ipa sente locör. Cuöc nesencöhualuc, sente de tiemachtejcöhua otieyelfe: ―Tlöcatzintle, xetiechmomachtele quiene ca totlajtlötlajtisque. Pos ejqueu nuyejque Xohuö oquenmachte imachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Hua Jesús oquemelfejque: ―Cuöc nemotlajtlötlajtisque, xequejtucö ejqueyi: ToTajtzi, ma innochtie ma queyectieniehuacö motucöyutzi. Ma aseque inu tunale cuöc tomotlamandörfis. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xetiechmomaquele cöra tunale totlacual de inu tunale. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Hua xetiechmoperdonörfe totlajtlacul, pues nuyejque tejua tequenperdonöroa innochtie quiejquech tiechtlajtlabiquelea. Hua amo xetiechmocöbele ma tiechyulmajmötoca Amo Cuale Tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Oquemelfejque nuyejque: ―Beles canajyeca de nemejua quepeas sente amigo, hua iyös ica yaja quieme ca tlajco yohuac. Quelfis: “Amigo, xeniechtlacuilte yete pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Pos sente noamigo ohuöla de ca pa ojtle noca naja, hua amo necpea tli necmacas ma quecua”. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Hua beles yaja nöhuates desde tlaijtec, hua quejtus: “Amo xeniechpasolo. Pos pobielta ye tzacteca, hua nopelhua cate ca naja ipa tlapechtle. Abele nemiehuas para temetzmacas”. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nemiechelfea, que mös cana amo miehuas para quemacas porque cate amigos, pero ipampa iamigo quesequiroa quetlajtlanelejteca, miehuas hua quemacas quiejquech pöntzi quenesesitöroa. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hua naja nemiechelfea: Xetlajtlanecö, hua nemiechmacasque. Xectiemucö, hua nenqueniextisque. Xetzajtzecö, hua nemiechtlaijtlapolfisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ipampa noche nieca öque tlajtlane queselea, hua öque quetiemoa queniextea, hua öque tzajtze, quetlaijtlapolfea. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Amo onca nionöque tajtle de nemejua que tlö iconie quetlajtlanes sente meche, amo quemacas sente cuhuötl en locör de meche. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O noso tlö quetlajtlanis sente tutoltetl, amo quemacas culutl. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Entunses tlö nemejua, mös amo nencualteque, pero nenquemate nenquetiemacasque lo que tlin cuale ca nemopelhua, pues cache ca meyac arrasu ejqueu quechihuasque nemoTajtzi ompa elfecac. Pos quetiemacasque tieEspíritu Sönto ca öque tietlajtlanelis. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Hua yejuatzi quequextiloöya sente demunio tli quechihuaya ma tlöcatl iye mumorojtzi. Hua omochi que cuöc oquis inu demunio, inu mumorojtzi otlajtlajto, hua inu giente quetietzöbejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Cache seque de yejua quejtoöya: ―Quenquextea demunios ca ichecöhuales Beelzebú, tlajtoöne de demunios. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Hua ocseque, para tieprobörusque, tietlajtlaniöya ma quechihuacö sente sieñas de elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Cache yejuatzi quematiloöya tli yejua quepejpensöroöya, hua oquemelfejque: ―Tlö giente de sente nación seme momejmectisque entre yejua mismos, hua tlö giente de sente chöntle seme momagasque ca giente de ocsente chöntle, pues moxexetunis inu nación. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Hua tlö quejtus Satanás mopeleörojteca cuntra sie yaja, ¿quiene bejcöbes itlajtojcöteles? Pues ejqueu quechijteca tlö ica melöhuac lo que tli nenquejtoa nemejua, que nele ca ichecöhuales Beelzebú nequenquextea inu demunios. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Hua tlö naja por ichecöhuales Beelzebú nequenquextea demunios, ¿beles nenquejtusque que nemomachtejcöhua nuyejque quenquextea por Beelzebú? Ejqueu yejua mismo nemiechpinöbea de lo que tli nenquejtoa. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Cache tlö por tiechecöhuales Deus naja nequenquextea demunios, quejtusneque que de melöhuac Deus piehualuteca tlamandöruro nemotzölö. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Cuöc sente tlöcatl checactec quixutea ichö ca itepos pa imö, amo tli quepasöroa noche tli quepea. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Cache tlö huölös ocsente tlöcatl cache checactec que yaja, quexexicus, hua quequextelis noche iteposhua ica tli tlacuajtlamajtaya. Entunses tiexexelfea noche tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Öque amo ica ca naja, encuntra de naja ica. Hua öque amo niechpaliebea para nejcuejcuis, quechayöjteca. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Cuöc moxicoöne ye oquis de ijtecopa tlöcatl, nejnenteneme ipa tlölhuöjque, quetiemojteneme cöne mosiebis. Cuöc amo queniextea, quejtoa: “Nocuepas ca nochö de cöne onehualquis”. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Hua cuöc yebitz, cualniextea tlachpöntle hua tlajtlayecchejchijtle. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Yecuöquenu iya, hua quenbicatz oc checume moxicoöneme cache petzoteque que yaja. Cajcalaque ijtec tlöcatl hua ompa mochöntea. Hua sötiepa mochihua cache lalebes petzotec para inu nieca tlöcatl que cuöc cachto oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hua omochi que cuöc oquejtojque ini nönca sösantle, sente sohuatl de tli ompa tlamachyeya otzajtzec, otieyelfe: ―Cuale icnupel inu sohuatl tli metzmotlöcatelele, öque ipa ichichehual otomochichite. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hua yejuatzi oquejtojque: ―Amo ejqueu, cache cuale imicnupel niecate tli quecaque tietlajtultzi Deus hua quechihua tli quemelfea. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Hua cache omotlamachtlöliöya giente tietlac. Entunses opiehualuc quejtuloöya: ―Giente de nönca tiempo sie tiro amo cualteque cate. Hua öxö nenqueneque ma nemiechmaca sente sieñas. Pero amo nemiechmacas nion sente sieñas, tlöcamo sa inu sieñas de Jonás tlayulepante. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pos quiename Jonás omochi sente sieñas para inu giente de ciudad de Nínive, ejqueu nuyejque naja öque onochi netlöcatl neyes nesieñas para nemejua de ini nönca tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Inu reina de tlöle de Sur majcoques ca nemejua tli öxö nennejneme ipa inun tunale cuöc Deus tlajuscörurus, hua nemiechpinöbis. Pues yaja ohuöla desde lalebes ca bejca para quecaques imachesteles Salomón. Hua xequejtacö, que necö oncönca sente tlöcatl cache bieye que Salomón ipa ini nönca locör, pero nemejua amo nenqueneque nenquecaquesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Inu tlöca de inu ciudad de Nínive majcoquesque ca nemejua ipa inun tunale cuöc Deus tlajuscörurus, hua nemiechpinöbisque. Pues yejua omoyulcuejque cuöc oquennunutz Jonás. Hua xequejtacö que necö oncönca sente tlöcatl cache bieye que Jonás ipa ini nönca locör, pero nemejua amo nenqueneque nemoyulcuepasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","’Cuöc canajyeca quexutlaltea sente cantil, amo quetlölea ijtec sente coyoctle nimpor itzintla sente almu. Cache quetlölea ipa canteliero, para que ejqueu innochtie tli calaque ijtec cale ma quejtacö tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tlöbile de mocuierpo yaja moixtelolo. Cuöc moixtelolo amo mococoa, nuyejque noche mocuierpo quepea tlöbile; cache cuöc amo cuale ica, nuyejque mocuierpo quepeas tlajtlayohuaquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Xecpea cueröro noso, majcamo mocuepa tlajtlayohuaquelestle inu tli uyesquea tlöbile para mocuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Entunses tlö noche mocuierpo quepea tlöbile, hua amo quepea niontle tlayohuaquelestle, entunses noche tiemes de tlöbile, quieme cuöc sente cantil tlaniextea lalebes hua metzmaca tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Mientras tlajtlajtuloöya, tietlötlajte sente fariseo nele ma tlacualo ca yaja. Hua ocalacoac Jesús ipa ichö, hua onetlöliluc ipa miesa. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Hua inu fariseo oquetietzöbejtac cuöc otieyejtac que amo onepajpöco antes de de tlacualus. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Hua Tlöcatzintle oquelfejque: ―Öxö nemejua nenfariseos nenquechepöhua sa tli ca pane de xoctle noso casfiela, pero nenquecöhua petzöyutl tlaijtec. Pues nemojtecopa nentientecate de ichtejcöyutl hua noche tli amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Nentuntojte! Deus, öque oquechejchijque tli ca paneca, ¿amo nuyejque oquechejchijque tli de tlaijtejca? ");
INSERT INTO nhgNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Xetietlöocolicö de lo que tlin cuale nenquepea nemojtecopa, hua noche iyes chepactec para nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’¡Porubejte de nemejua, fariseos! Pues nenquenejnechecoa ca meyac cueröro inu majtlactle pörte de nemoalfabieno, hua de iluta hua de noche queletl. Cache inu de que ma xecchihuacö tlin melactec hua ma xetietlasojtlacö Deus, pues sa nenquepanabea. Pues ica cuale ma xecchihuacö inu sösantle tli nenquechijtecate, pero cache lalebes conbenierebe xecchihuacö inu sösantle tli cache importönte. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’¡Porubejte de nemejua, fariseos! Pues seme nenqueneque tlaixpa nenyesque ipa teopancucone hua nenquepea gusto ma nemiechyectlajpalucö giente ipa plöza. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’¡Porubejte de nemejua! Pues nencate quieme mejcöcoyocme tli amo nejniese, hua tlöca tli yajteneme icpac amo quemate que tlaijtec onca petzoyutl tli quenmajmöhuas. Ejqueu giente amo quemate que cuale momajmöhuasque ca tlajtlacule por yesque ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Hua onöhuat sente de inu tlajtlamatque de ley de Moisés. Otieyelfe: ―Maestro, cuöc tomojtalfea ini nönca nuyejque tetiechmopejpinöjtelea tejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Hua yejuatzi oquejtojque: ―¡Porubejte de nemejua nuyejque, nentlajmatque de inu ley! Pues nenquemelfea giente ma quechihuacö meyac sösantle tli cate quiename sente tlamömale tli abele öque quebicas. Cache nemejua nimpor ca nemomajpel amo nenquemötoca inu tlamömale. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’¡Porubejte de nemejua! Pues nemejua nenquechejchihua mejcöcoyocme de inu tlayulepantejque, pos nemobiebetcöhua oquenmejmectejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ejqueu sie nemejua nenquejtoa tli opasöre hua nenquetlöcayejta intlachihual de nemotötajua. Pues yejua oquenmejmectejque tlayulepantejque, hua nemejua nenquechejchihua inmejcöcoyocua. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Por inu, tiemachesteles Deus oquejto ejqueyi: “Nequentitlanes inca yejua tlayulepantejque hua tlateotitlanme; hua quenmejmectisque seque hua quentepotztocasque ocseque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ejqueu nemejua tli öxö nennentecate nenyesque nentlajtlaculteque de inmequeles de noche inu tlayulepantejque tli oquenmectejque desde cuöc omochejchi tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Desde imequeles de Abel, hasta imequeles Zacarías, öque omec entre ajtöl hua teopantle, seguramente nemiechelfea que Deus nemiechtlajtlacultisque por inmequeles nemejua tli öxö nennentecate. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’¡Porubejte de nemejua, nentlajmatque de inu ley! Pues onenquenquextelejque de giente inu yöbe tli quetlapoa pobielta para öque calaques ipa machestelestle. Pos sie nemejua amo nemochijque nentlajmatque hua tli quenequeya mochihuasque tlajmatque amo onenquencöjque. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Hua cuöc Jesús quixoac de ompa, inu tlamachtiöneme hua fariseos opiejque motlamachtlölea lalebes tiepa, hua tiechihualtiöya ma tlajtlajtulo de meyac sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Quenequeya casesque canajyetla tlajtule tli quejtusque para ejqueu cuale tietieyelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mientras, omosentlölejque miles de giente, tönto lalebes meyactie que mocxepajpötzoöya sie yejua. Opiehualuc ca cachto quemelfiloöya tiemachtejcöhua: ―Xomotlachilicö de inu levadura de fariseos, que yaja inu ume inxöyac. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ipampa amo onca niontle mojyönteca, que amo moniextis; hua abele mojyöntas niontle, pues noche tiene que macheas. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Por inu, noche sösantle tli onenquejtojque ipan tlajtlayohuaquelestle, ipan tlaniextle mocaques. Tli nenquejtojque sa ichtecajtzi ijtec cale mopoas cöne cuale caquestes noche. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’Hua nemiechelfea, noamigos, que amo xequenmabelicö tli cuale quemectea nemocuierpo, hua sötiepa ayecmo yetla onca tli cuale nemiechchibelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero nemiechejtetis öque nentiemabelisque: xetiemabelicö inu nieiloac öque sötiepa de que quemectilo, quepealo checöhualestle para quetlajcalesque ijtec tlecale. Quiema, nemiechelfea, yejuatzi xetiemabelicö. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Amo monamaca möcuiltie tutume por ume tomi? Pues Deus amo quelcöhualo nion sente de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hua nemejua, Deus quematihua hasta itlapoal de nemotzo. Amo xomomajticö noso, pos nemejua cache nenbajbalierebe que meyactie tutume. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Hua nemiechelfea que tlö canajyeca niechtieniehuas hua tlajtus cuale de naja imixtla giente, nuyejque naja que onochi netlöcatl nectieniehuas hua netlajtus cuale de yaja imixpa tieöngeles de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero tlö canajyeca quejtus imixpa giente que amo niechixomate, nuyejque naja nequejtus imixpa tieöngeles Deus que amo nequixomate. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Noche nieca tli tlajtoa encuntra de naja öque onochi netlöcatl, cuale moperdonörus. Cache öque tiechecuayelfis hua tiepöpöcas Espíritu Sönto, Deus amo queperdonörusque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Hua cuöc nemiechhualecasque ipan teopancucone hua inca tlötlajtoönejme hua autoridades, amo xomotequepachucö por tli noso quiene nenquennönquelisque noso tli nenquejtusque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pues yejuatzi Espíritu Sönto nemiechejtetisque ipa inu nieca ura tli conbenierebe ma xequejtucö. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Hua otieyelfe sente de inu giente: ―Maestro, xomolfele nocni ma quexelo ca naja lo que tli tiechcöbelejtiejque totöta cuöc omecoac. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Cache yejuatzi oquelfejque: ―Tlöcatl, ¿öquenu oniechtlöle para ma netlajuscöro noso ma netlaxiexelo entre nemejua? ");
INSERT INTO nhgNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Hua oquemelfejque giente: ―Xomotlachilicö hua xecpeacö cueröro amo nemoxicusque sösantle. Pues inemeles tlöcatl amo icaca por tlö quepea meyac tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Hua oquemelfejque sente cuiento. Oquejtojque: ―Oyeya sente tlöcatl rico. Hua sie xebetl itlölhua tlamochihualtejque meyac lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hua yaja quepensöroöya ijtecopa, quejtoöya: “¿Tli nayes? Pues amo necpea cöne nectlölis noche tli necpexcac”. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Hua oquejto: “Ini nönca necchihuas: Nequenxexetunis nobescomajua, hua cache bejbeye nequenchejchihuas, hua ompa necsentlölis noche tli necpexcac hua tli nohuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Hua nequelfis noölma: Ölma, meyac tli mohuöxca ye tlamachtlölejteca para meyac xebetl. Xomosiebe noso, xetlacua, xetlai, xepajpöque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Deus oquelfejque: “¡Tunto! Ipa ini nönca yohuale taja temeques. Hua noche tli otectlötlöle, ¿para öque iyes?” ");
INSERT INTO nhgNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","’Ejqueu icaca öque quetlamachtlölea ricojyutl para yaja mismo, pero amo tli quepea de tli ricojyutl quecualejtalo Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Hua yejuatzi oquemelfejque tiemachtejcöhua: ―Por inu nemiechelfea: Amo xomotequepachucö por nemonemeles, por tli nenquecuösque. Nimpor amo xomotequepachucö por quiene nenquetlaquentisque nemocuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pos ye nenquepea nemonemeles, hua yaja inu cache balierebe que tlacuale. Hua ye nenquepea nemocuierpo, que cache balierebe que tlaquentle. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xequemejtacö cöcölume. Yejua amo tlajtlatuca, nimpor amo pejpexca, nimpor amo quepea inbesco nimpor ocsie locör cöne quetlölisque tlacuale. Hua Deus quentlacualtilo. Hua nemejua cache nenbajbalierebe lalebes que inu yulcöme. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Hua nionöque de nemejua, por mös motequepachus lalebes, abele mobepöhuas nion tlajco mietro por yaja mismo. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Entunses tlö abele nenquechihua nion lo que tli cache tzitzequetzi, ¿tli para nemotequepachoa por inu ocseque sösantle? ");
INSERT INTO nhgNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Xequejtacö cuale quiene mobepöhua xucheme. Amo tejtequete, nimpor amo quechejchihua tlaquentle. Cache nemiechelfea, que nimpor Salomón ca noche icualniexteles ayec omotlaquente quiename sente de inu niecate xucheme. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Hua tlö quejtus xebetl que öxö icaca caltienco, hua para mustla ye motlajcale ijtec tletzintle, Deus quetlaquentilo ejqueu, pos cache ca meyac arrasu nemiechtlaquentisque nemejua, tlöca que nemiechpoloa neltoquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Nemejua, noso, amo sa xectiemucö tli nenquecuösque noso tli nenconisque, nimpor amo xomopreocupörucö. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pues giente de ocseque naciones de tlöltecpactle quetiemoa ini nönca sösantle. Pero nemoTajtzi quematihuateca de que nemiechpoloa ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pero primiero xectiemucö ma tlamandörucö yejuatzi, hua noche ini nönca sösantle nuyejque nemiechmacasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’Amo xomomajticö, nocalnielojcuconehua, pues nemoTajtzi quenequihua nemiechmacasque para nentlamandörusque nuyejque cöne yejuatzi tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xecnamacacö tli nenquepejpea, hua xectietlöocolicö. Xomocubicö ejqueu puxajme tli ayec bejbiebejte, tietieme ca sösantle ricojyutl ompa elfecac que ayec polebe. Pos ca ompa ichtejque amo onase, hua amo tlacuacualoa. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Pues cöne iyes nemoricojyu, ompa queneques iyes nemoyulo nuyejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","’Xomomöcheacö cuale, quiename giente tli motlaquentea para nima quisasque, hua incantilhua xoxutlatecate. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ejqueu xeyecö quiename tlöca tli quemöchixtecate cuöc intieco mocuepas de ipa nesohuajtiluyo, para cuöc huölös hua tzajtzes, sa nima quetlaijtlapolfisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Cuale imicnupel inu niecate tlatequepanojque, quiejquech cuöc intieco huölös, ma quenniexte tlachixtecate. Melöhuac nemiechelfea que intieco motlajcoilpis para tlatequepanus hua quenchihualtis ma motlölicö ipa miesa, hua yaja mismo huölös para quentequepanus. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hua mös huölös hasta tlajco yohuac noso hasta ca ise cualco, hua quenniextisque ejqueu quemöchixtecate, cuale imicnupel inu niecate tlatequepanojque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pero ini nönca xecmajtacö, que tlö chöne quematesquea tlin ura huölös ichtejque, amo quecöhuasquea ma calaque ichtejque ipa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nemejua nuyejque noso, xeyecö xelistos, porque naja que onochi netlöcatl nehuölös cuöc nemejua amo nenquepensöroa. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piero otieyelfe: ―Tlöcatzintle, ¿tomojtalfea ini nönca cuiento sa para tejua, noso nuyejque para innochtie? ");
INSERT INTO nhgNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hua oquejtojque Tlöcatzintle: ―¿Öquenu noso ica encargödo tlajmatque hua de confiönsa que itieco quencargörfe ichö, para ma quenmaca noche giente ipa ura intlacual tli quentocöroa? ");
INSERT INTO nhgNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cuale icnupel inu nieca tlatequepano, tlö itieco cuöc huölös, queniextiqui quechijteca ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","De melöhuac nemiechelfea, que itieco quetlölis ma tlamandöro ipa noche tli ihuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero beles inu nieca tlatequepano quejtus ipa iyulo: “Notieco oc bejcöbes para huölös”. Beles piehuas quenmaltratörus inu ocseque tlatequepanojque hua tlatequepanojque sohuame, hua tlacuös hua conis hua tlöhuönas. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Huölös itieco de inu nieca tlatequepano ipan tunale cuöc yaja amo quechea, hua tlin ura amo quemate. Yecuöquenu quetlajcoteques hua quetlölis inca tli amo moneltocaneme. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hua tlö sente tlatequepano ocasojcömat tli quenequeya itieco pero amo omochi listo para cuöc huölös nimpor amo oquechi lo que tli quenequeya, yaja quebitequesque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero tlö amo oquemat tli quenequeya itieco, mös oquechi sösantle tli quemeresieroa ma quebitequecö, pero amo lalebes quebitequesque. Ipampa öque lalebes meyac oquemajmacaque, lalebes meyac quepeas que quecuepas. Hua öque quencargörfejque meyac, cache meyac quetlajtlanelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Quiename tletzintle onejcalaquico ipan tlöltecpactle, tli quenxutlaltis tieenemigos Deus hua quenchepöhuas tiegiente. Hua ayecmo yetla necneque tlö ye xutlateca. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Cache necpea que nocuötiequis ca sente necuötiequelestle de tiecoco. ¡Hua necpea meyac tequepachule hua cuejcuesebelestle hasta senamo ma mochihua! ");
INSERT INTO nhgNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amo xecpensörucö que naja onehuöla para necchihuas ma ayecmo uye peleitos ipan tlöltecpactle. Amo, cache nemiechelfea que giente mopeleörusque porque nehuöla. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pues desde öxö möcuiltie ipa sente chöntle mopeleörusque. Yeteme yesque encuntra de unteme, hua unteme encuntra de yeteme. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tajtle mopeleörus encuntra de iconie, hua iconie encuntra de itajtzi. Nöntle mopeleörus encuntra de ichpuch, hua ichpuch encuntra de inöntzi. Mönontle mopeleörus encuntra de isohuamo, hua isohuamo encuntra de imöno. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Hua quemelfiloöya giente nuyejque: ―Cuöc nenquejta mextle quisa cöneca calaque tunale, nima nenquejtoa: “Huölös queyabetl”. Hua ejqueu pasörebe. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Hua cuöc tlalpitza yejyecatl de ca tlatzintla, nenquejtoa: “Tunas lalebes”. Hua ejqueu mochihua. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Sa ume nemoxöyac! Nenquemate nenquestlocusque tli onca ixpa tlöltecpactle hua ixpa elfecac. ¿Tlica abele nenquestlocoa tli mochihuas ipa ini nönca tiempo? ");
INSERT INTO nhgNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","’Hua ¿tlica amo nenquestlocoa para nemejua mismos para nenquematesque tlin yectec hua melactec? ");
INSERT INTO nhgNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pos cuöc teya ixtla juez ica öque metztieyelfis, mientras oc teya pa ojtle xecpea cueröro por tequisas de inu lío, majcamo cana metzbica ca tlajtoöne, hua tlajtoöne metztiemöctis ica tlajpexque, hua inu tlajpexque metzcalaquis ijtec cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Temetzelfea que amo tequisas de ompa hasta senamo tectlaxtlöhuas inu sölúltimo sentöo tli tectlabiquelea. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hua ipa inu nieca tiempo ompa onhuölajque seque que tiepubelejtaya tli impa omochi inu giente de estado de Galilea, öque Pilöto oquenmecte cuöc tlabentlöliöya, hua inyeso oquenelulte ca iyeso de inu yulcöme de bentle. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Hua onöhuatihuac Jesús, oquemelfejque: ―¿Beles nenquepensöroa que inu niecate galileos cache tlajtlaculteque oyeya que innochtie ocseque galileos, hua que por inu ejqueu impa omochi? ");
INSERT INTO nhgNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nemiechelfea que amo, cache tlö amo nemoyulcuepa, nemonochtie ejqueu nenmejmequesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Nenquelnömeque niecate giente öque impa obetz inu cale bejcapa ompa ipa Siloé, hua oquenmejmecte? ¿Beles nenquepensöroa que yejua otlajtlacojque encuntra de Deus cache que innochtie ocseque tlöca tli neme ipa inu ciudad de Jerusalén? ");
INSERT INTO nhgNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nemiechelfea que amo, cache tlö amo nemoyulcuepasque, nemonochtie nenmejmequesque ejqueu mismo. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hua oquejtojque ini nönca cuiento: ―Sente tlöcatl quepeaya sente icox cuabetl tuctaya ipa ihuierta de uvas. Oquetiemolico ifruto tli quetiemacasquea inu nieca icox cuabetl, pero amo oqueniexte. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Hua oquelfe inu jardiniero: “Ye necpea yeye xebetl que necualtiemolea fruto itech ini nönca icox cuabetl, hua amo necniextea. Xecteque noso. ¿Tli para oc quecupörojtas tlöle?” ");
INSERT INTO nhgNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yecuöquenu onöhuat inu jardiniero, oquelfe: “Tlöcatzintle, xomocöbele oc sie ini nönca xebetl, hasta senamo ma nectataca, hua ma nectlölele majöra. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Hua tlö quetiemacas ifruto, pos cuale. Hua tlö amo, entunses quiema tomotequelis”. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Hua tlamachtiloöya ipa teopanconetzi ipan söbron tunale, cuöc quepea costumbre mosejsiebea joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Hua ompa oyeya sente sohuatl que ye quepeaya caxtule hua yeye xebetl de que quecocoaya sente moxicoöne. Yaja motojtopochoöya, hua abele moquetzaya deriecho. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Cuöc Jesús oquejtaque, oquenutzque hua oquelfejque: ―Sohuatl, ayecmo metzilpea mococoles. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hua oquentlölejque tiemöhua ipa yaja, hua nima omoyebetequetz hua tiechamoöya Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hua inu tlayecönque de teopanconetzi ocualö ipampa Jesús otlapajtiluc ipan söbron tunale. Por inu oquemelfe giente tli ompa tlamachyeya: ―Checuasien tunalte cate cöne conbenierebe ma tetequetecö. Ipa inu niecate tunalte, noso, xehuölöcö hua xepajtecö, pero amo ipan söbro. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero Tlöcatzintle quenönqueliluc, oquejtojque: ―¡Sa ume nemoxöyac! Nemonochtie ipan söbron tunale nenquetojtoma nemocucobe noso nemopuro de cöne tlacua, hua nenquebica ma ötle. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hua ini nönca ichpuch Abraham ye quepea caxtule hua yeye xebetl oquelpetaya inu Satanás. ¿Beles nenquejtusque que amo conbenierebe que ipan söbron tunale ma motojtoma de inu cocolestle tli quelpetaya? ");
INSERT INTO nhgNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hua cuöc oquejtojque ini nönca sösantle, pejpinöhuaya innochtie tli oyejyeya encuntra de yejuatzi. Cache noche ocseque giente mopöquelesmacaya de noche sösantle lalebes cuale tli quechihualoöya yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Por inu yejuatzi oquejtojque: ―¿Tli sabele icaca quiename cuöc tlamandöruro Deus? ¿Ca tli nejcomparörus? ");
INSERT INTO nhgNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Icaca quiename ixenöch mostöza, que sente tlöcatl ocasec, oquetlajcal ipa ihuierta. Omobepö, hua omochi quiename sente cuabetl, hua tutume tli patlöne ipa yejyecatl oquetlölejque intepasol ipa imömöyo. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Hua ocsajpa oquejtojque: ―¿Ca tli nejcomparörus quiename cuöc tlamandöruro Deus? ");
INSERT INTO nhgNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Icaca quiename levadura de pöntzi, que ucö sente sohuatl, hua quenelulte ca yeye tlatemachihuale de harina, hua noche oquesunie. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hua biloaya ipa noche ciudades hua puieblos otlamachtilutöya, hua biloaya ca pa ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hua sente tlöcatl otieyelfe: ―Tlöcatzintle, ¿sa quiesquete momöquextisque? Hua yejuatzi oquemelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Xecuesebicö por nencalaquesque ca ipa pobielta tli sa pitzutec. Porque nemiechelfea que meyactie quenequesque calaquesque, pero abele quechihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Iyes ejqueyi, quiename sente chöne tli miehuas hua quetzacuas pobielta. Entunses nemoquetzasque ca queyöhuac, hua nenpiehuasque nentzajtzesque ipa pobielta. Nenquejtusque: “Tlöcatzintle, Tlöcatzintle, xetiechmotlaijtlapolfele”. Inu chöne nöhuates, nemiechelfis: “Amo nemiechixomate de cöne nencate”. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Yecuöquenu nenpiehuasque nenquejtusque: “Mixpantzinco otetlacuajque hua otötlique, hua otomotlamachtele pa cayajunte de topuieblo”. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hua seguramente nemiechelfis: “Amo nemiechixomate de cöne nencate. Xomoxelucö de naja nemonochtie, pues sa nenquechihua tli amo cuale”. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","’Ompa nenchojchucasque hua nemotlantesesque, cuöc nenquejtasque inu Abraham, hua Isaac, hua Jacob, hua innochtie tlayulepantejque de pa nieca tiempo. Yejua yesque cöne tlamandöruro Deus, hua nemejua nemiechtlajcalesque ca queyöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Hua huölösque giente de cöneca quisa tunale hua de cöne calaque tunale, de ca tlacpac hua de ca tlatzintla. Yejua motlölisque cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Hua xequejtacö, que seque tli öxö sölúltimo cajcate, cachto yesque. Hua seque tli öxö cachto cate sölúltimo yesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ipa sie yaja tunale ohuölajque seque fariseos. Otieyelfejque: ―Xequisa, hua xebeya de necö, pues inu rey Herodes queneque metzmectis. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Hua oquemelfejque: ―Xeyöcö, hua xequelficö inu nieca coyuconetzi: “Xequejta necö, que nequenquextea demunios hua netlapajtea öxö hua mustla, hua hasta ipa yeye tunale netlames. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero necpea que necsequirus noojfe öxö, hua mustla, hua bictla. Pues abele iyes que meques sente tlayulepante ipa ocsie pörte, tlöcamo noche tlayulepantejque quepejpea que mequesque ipa Jerusalén”. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’¡Ay, Jerusalén, Jerusalén, que tequenmejmectea tlayulepantejque hua tequentecaltea tli Deus quentitlanihua ca taja! ¡Meyacpa onecnec nequensentlölis tli chajchönte mopa, quieme sente piyolama quensentlölea ipeyocuconehua itzintla iajfetz! Cache taja ayec otecnec. ");
INSERT INTO nhgNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xequejtacö que Deus ayecmo chöntihuas nemotzölö, cache nemiechcöjtiehuasque. Hua nemiechelfea que ayecmo nenniechejtasque, hasta senamo huölös tunale cuöc nenquejtusque: “Ma tetieteochihuacö öque biloatz tietucöyupa Tlöcatzintle”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Hua omochi que ocalacoac ipa ichö de sente tlayecönque de inu fariseos ipa sie söbro. Ocualuto tlacuale. Hua yejua tieyetztaya abier tli quechihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Hua ompa sente tlöcatl ijtesunectec tieixtla oyeya de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Hua onöhuatihuac Jesús, oquemelfejque inu tlajmatque de inu ley de Moisés hua inu fariseos: ―¿Conbenierebe öque tlapajtis ipan söbron tunale cuöc tosiebea? ");
INSERT INTO nhgNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Hua yejua amo onöhuatque. Yecuöquenu yejuatzi oquepajtejque tlöcatl, hua oquetitlanque ma beya. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Hua oquemelfejque: ―¿Öquenu de nemejua tli quepea sente iconie noso sente cucobe, tlö cana betzes ijtec sente öpuso, amo sa nima quequextis mös ipan söbro? ");
INSERT INTO nhgNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pero yejua abele tienönqueliöya cuöc quejtuloöya ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Hua yejuatzi ye nemacaloöya cuienta de quiene tli tlatlalfilte quenequea mosentlölisque ipa tli cache cuale locör itlac miesa. Oquemelfejque sente ejiemplo. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Cuöc canajyeca metztlalfis ipa sente nesohuajtiluyo, amo xomotlöle ipa tli cache cuale locör, amo cana de repiente iye que nuyejque quetlalfis yeca ocsente cache cuale que taja. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Hua yaja tli nemiechtlalfe nemejua nemonehua huölös hua metzelfis: “Xecmaca inu locör ini nönca”. Cuöquenuju ye tepinöhuas hua teyös hasta inu locör tli cache amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Cache cuale xecchihua ejqueyi: cuöc yeca metztlalfis, xebeya hua xomotlöle ipa locör tli cache amo cuale ica. Entunses huölös öque metzontlalfe. Metzelfis: “Amigo, xehualmobica necö pa locör cache cuale”. Entunses innochtie tli ompa tlajtlacua metzyectieniehuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ipampa noche öque mochajchamöhuas, quepichaquisque; pero öque mopichaquis, quechamöhuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Hua oquelfejque nuyejque inu tlöcatl öque tietlalfe: ―Cuöc tecchejchihua sente tlacuale ca pan tlajca noso ca ye yohuac, amo xequentlalfe moamigos, nimpor mocnihua, nimpor mogiente, nimpor tli ricojte motlac chajchönte. Pues tlö ejqueu beles de repiente yejua nuyejque metztlalfisque, hua metzcuepelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Cache cuöc tecchejchihua tlacuale, xequennutza tli porubejte, tli möcotocteque, tli cuxojtzetzi, tli ixcocoxcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Entunses cuale mocnupel iyes, ipampa yejua amo quepea ca tli metzcuepelisque, hua ejqueu Deus metzcuepelisque cuöc yulebesque yecteque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Sente de tli ompa yehuataya ca yejuatzi itlac miesa, cuöc oquecac ini nönca, oquejto: ―Cuale icnupel öque tlacuös cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pero yejuatzi oquelfejque: ―Sente tlöcatl oquechi sente bieye tlacuale, hua oquentlalfe meyactie. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hua cuöc ye oaseco ura para tlacuale oquetitla itlatequepano ma quemelfe inu tlatlalfilte: “Xehuölöcö, que ye tlacajca para tetlacuösque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero innochtie opiejque motietiequextelea. Inu primiero oquelfe: “Onejcu sie perözo tlöle. Necpea que nequejtati. Temetzmotlötlajtelea xeniechmomöquextele ca ompa”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ocsente oquejto: “Onejcu möcuile yuntajte de cucobejque, hua nequennenebeliti. Temetzmotlötlajtelea xeniechmomöquextele ca ompa”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Hua ocsente oquejto: “Quiemach nosohuajte, hua por inu abele neyös”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Hua cuöc omocuec inu tlatequepano, oquemacheste itieco de ini nönca sösantle. Yecuöquenu ocualö inu nieca chöne. Oquelfe itlatequepano: “Xebeya sa nima ca pa cayajunte hua ojme de ini puieblo, hua xequencalaque necö tli porubejte, tli möcotocteque, hua ixcocoxcötzetzi, hua cuxojtzetzi”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Hua ejqueu oquechi tlatequepano. Entunses oquejto: “Tlöcatzintle, ye omochi tli teniechmonahuatele, hua oc turavea onca locör”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Hua oquelfe itieco inu itlatequepano: “Xebeya ipa ojme hua ipan colölte, hua xequennelchibele ma calaquecö, para ma tieme nochö. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Pues nemiechelfea que nionöque de inu niecate tlöca tli onequentlalfe, amo quecuösque notlacual”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Hua meyac giente oyöya tieca. Hua onecuepaluc, hua oquemelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Tlö canajyeca yebitz noca, ma quetlajyelejta itajtzi, hua inöntzi, hua isohua, hua ipelhua, hua icnihua oquechte, hua icnihua sohuame, hua hasta nuyejque inemeles de yaja mismo ma quetlajyelejta. Pues tlö amo, abele iyes nomachtejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Hua öque beletes amo iyes listo para quesufrirus quiename öque quesufriroa ipa sente corujtzi, hua amo huölös ca naja, abele iyes nomachtejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pues tlö canajyeca de nemejua queneque cajcoques sente cale bejcapa, cachto motlölea hua quepoa quiejquech quecastörus, abier tlö quepea para quesencöhuas, ");
INSERT INTO nhgNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","majcamo de repiente iye que, sötiepa de que ye oquetlöle cimiento, abele quetlamis. Pues tlöjcu noche quiejquech quejtasque piehuasque quepinöbisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Quejtusque: “Ini nönca tlöcatl oquepiehualte quechejchihua cale, hua abele oquesencö”. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Noso tlö sente rey iyös momagati ica ocsente rey, cachto motlölea para quenenebelea tlö cuale quisas yaja encuntra de inu nieca tlö yaja sa quepea majtlactle mil soltörojte hua inu nieca quebicatz sempoale mil. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Pos tlö abele, cuöc inu nieca oc bejcanca, quentitlane irepresentöntes para carreglörusque quiene amo momagasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ejqueu noso, öque beletes de nemejua amo quecöhua noche sösantle tli quepea, abele iyes nomachtejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Ejqueu yestatl icaca cuale. Cache tlö yestatl mocuepas öbielec, ¿tli ica öque quepoyelis? ");
INSERT INTO nhgNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Amo serbirebe nimpor para tlöle, nimpor para majöra. Por inu motlajcalea ca queyöhuac. Öque quepea itlacaqueles para tlacaques, ma tlacaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Hua mopachoöya tieca noche tli tlanechecojque hua ocseque tlajtlaculteque para tiecaquesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Hua moquejöroöya inu fariseos ca tiehua tlamachtiöneme de teotlajtule. Quejtoöya: ―Ini nönca tlöcatl quenselea tli tlajtlaculteque, hua ca yejua tlacua. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Hua yejuatzi oquemelfejque ini nönca cuiento. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Tlö canajyeca de nemejua quepea sie sientos calnielojte, hua quepoloa sente de yejua, quencöhua inu noventa y nueve ipa munte, hua iya quetiemuti tli opole, hasta senamo queniextea. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Hua cuöc ye oqueniexte, quetlölea ipa iquechcochtla, hua pajpöque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Hua cuöc yebitz ipa ichö, quensentlölea noche iamigos hua tli icaltech chajchönte. Quemelfea: “Xepajpöquecö ca naja, ipampa onecniexte ini calnielo tli onecpolo”. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nemiechelfea, que ejqueu iyes meyac pöquelestle ompa elfecac por sente tlajtlacultec tli omoyulcuec, hua amo tönto por noventa y nueve tlöca yecteque tli amo quenejnesesitöroa moyulcuepasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’O noso tlö sente sohuatl quepea majtlactle monedas, tlö quepolus sente moneda, pues quexutlaltea icantil hua queyequechpöna cale. Quetiemoa ca cuesebelestle hasta senamo queniextea. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hua cuöc ye oqueniexte, quensentlölea iamigos hua tli icaltech chajchönte. Quemelfea: “Xepajpöquecö ca naja, ipampa ye onecniexte inu moneda tli onecpolo”. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nemiechelfea que ejqueu mismo onca pöquelestle imixtla tieöngeles Deus, por sente tlajtlacultec tli moyulcuepa. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Hua oquejtojque: ―Sente tlöcatl quepeaya unte ipelhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hua inu pelalactle tli sötiepa jiebe oquelfe itajtzi: “Tata, xeniechmomaquele tli niechtocörus de tli mohuöxcatzi”. Entunses inu tajtle oquenxiexelfe ipelhua noche tli quepeaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Hua sötiepa de quiesquete tunalte, inu pelalactle tli sötiepa jiebe oquesentlöle noche tli ihuöxca, hua uya bejca ipa ocsie tlöle. Ompa oqueniempolo noche tli ihuöxca, pos oquecastöro sin quepensöro. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Hua cuöc ye noche ye oquemalcastöro, ohuöla sente bieye öpestle ipa nieca tlöle, hua opie ye quepoloöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Entunses uya hua otequet ca sente tlöcatl de inu nieca tlöle. Inu tlöcatl oquetitla ipa ihacienda para ma quentlacuajcualte petzome. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Hua inu pelalactle quenequeya quecuös ixocoteyo puchucuabetl tli quecuöya inu petzome, pero nionöque amo quemacaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pero sötiepa ye oqueyecpensöro. Oquejto: “Onca meyactie tequetque tiechö tli quepea meyac tli quecuösque, hua naja necö nöpesmecteca. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Noquetztiehuas, hua neyös tietlac notöta. Netieyelfis: Taja, ye onetlajtlaco encuntra de Deus öque iloac elfecac, hua nuyejque encuntra de tejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ayecmo necmeresieroa neyes nemoconietzi. Xeniechmotratörfe quieme sente de inu motequetcötzetzihua”. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hua ca inu omie inu pelalactle, hua ohuöla itlac itajtzi. ’Pero mientras oc oyeya bejca, itajtzi oquejtac, hua oqueyulcoco. Hua omomerö, omopechtiecac iquechcochtla, hua oquepetzo. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Entunses inu pelalactle oquelfe: “Tata, ye onetlajtlaco encuntra de Deus öque iloac elfecac, hua nuyejque encuntra de tejuatzi. Ayecmo necmeresieroa para neyes nemoconietzi”. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Cache itajtzi oquemelfe itlatequepanojua: “Xejquexticö tlin cache cuale tlaquentle, hua xecöquicö. Xectlölelicö öniyo ipa imajpel, hua zapötoste ipa icxehua. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Hua xecualecacö sente pesiero tomöhuac, hua xecmecticö. Ma tetlacuöcö, hua ma tepajpöquecö, ");
INSERT INTO nhgNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ipampa ini nönca noconie ye mejque oyeya, hua ocsajpa yulejteca; oixniempolejtenemeya, hua onieseco”. Hua opiejque opajpöjque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Hua inu iconie tli cachto jiebe oyeya caltienco. Cuöc ohuöla, oaseco itlac cale, hua oquencac tlajtlapitzaya hua tlajtlatzotzonaya hua mojojtutiöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Hua oquenutz sente de inu tlatequepanojque. Oquetlajtlane tlininuju oyeya inu nieca. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hua yaja oquelfe: “Mocni ye oaseco, hua motajtzi ye oquemectejque inu pesiero tli cache tomöhuac, ipampa mocni ohuöla ica cuale”. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Yecuöquenu yaja ocualö, hua amo quenequeya calaques. Yecuöquenu oquis itajtzi, hua quetlötlajtiöya ma calaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Cache yaja onöhuat, oquelfe itajtzi: “Xomojtele meyac xebetl temetzmotequepanelfea, hua seme temetzmoneltoquelea noche tli teniechmomandörfea. Pero ayec teniechmomaquele nion sente chibojconetzi para nopöquelesmacas inca noamigos. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Cache cuöc ohuöla ini nönca moconietzi, tli oquepojpolo tli mohuöxcatzi inca cachirilajte, para yaja otomomectele inu pesiero tli cache tomöhuac”. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Oquelfe itajtzi: “Ixo, taja seme notlac tecaca, hua noche tli nohuöxca icaca mohuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero conbenierebe ma tepajpöquecö hua ma tecchihuacö yelfetl, ipampa ini nönca mocni ye mejque oyeya, hua ye yulejteca; oixniempolejtenemeya, hua onieseco”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Hua oquemelfejque nuyejque tiemachtejcöhua: ―Oyeya sente tlöcatl rico tli quepeaya sente maortumo encargödo de ichö. Hua ocseque quetieyelfejque inu maortumo ixtla ipatrón. Quejtoöya que sa queniempoloöya tli ihuöxca ipatrón. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Hua ipatrón oquenutz. Oquelfe: “¿Tlininiji nejcaque de taja? Xeniechmaca cuienta de noche tli otecchi cuöc teyeya encargödo. Pues ayecmo teyes teencargödo de nochö”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Yecuöquenu inu maortumo oquejto ipa iyulo: “¿Tli necchihuas? Pues nopatrón niechquextelea ini tequetl. Amo nechecactec para netequeteti de peyu. Hua tlö notlajtlaijtlanes, pos niechmaca pinöhualestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Naja necmate tli necchihuas, para cuöc niechquextis de noteque, ocseque giente niechönasque ipa inchö”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Hua oquentzajtzele quiejquech quetlabiquelejtaya ipatrón. Oquelfe inu cachto: “¿Quiejquech tecbiquelea nopatrón?” ");
INSERT INTO nhgNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Hua yaja oquejto: “Sie sientos butejte de asiete”. Hua oquelfe: “Xecöna morecibo, hua xomotlöle sa nima, hua xequejcuelo que sa tlajco sientos tecbiquelea”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sötiepa oquelfe ocsente: “Hua taja, ¿quiejquech tectiebiquelea?” Hua yaja oquejto: “Sie sientos bultos de trigo”. Hua oquelfe inu maortumo: “Xecase nönca morecibo, hua xequejcuelo que sa ochenta bultos tecbiquelea”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Hua ipatrón oquechamö inu maortumo mös quecajcayö. Oquechamö ipampa oqueyecpensöro cuöc oquechi inu nieca. Pues giente de nönca tlöltecpactle canajquiema cache cate listos de quiene motratöroa ca ocseque tlöltecpactlöca que giente tli quetiemoa tlaniextle de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Hua naja nemiechelfea: Xomochihuacö amigos de giente ca ini ricojyutl tli amo yectec, para que cuöc ini ricojyutl ayecmo cuale nemiechpaliebis, inu amigos nemiechselisque ipan chönme tli mocöhuasque nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Öque ica de confiönsa cuöc öque quencargörfea sa tzitzequetzi, nuyejque iyes de confiönsa cuöc iyes encargödo de meyac. Hua öque amo cuale quechihua cuöc quencargörfea tli sa tzitzequetzi, nuyejque quechihuas tli amo cuale cuöc iyes encargödo de meyac. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Porque tlö amo nencate de confiönsa ca ini ricojyutl amo yectec, amo öque nemiechencargörfis inu tlin melöhuac ricojyutl. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Hua tlö amo nencate de confiönsa ca lo que tli ihuöxca ocsente, amo öque nemiechmacas tli nemohuöxca. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nionöque tlatequepano abele quetequepanus umeme itiecohua. Pues quetlajyelejtas sente hua quetlasojtlas ocsente, o noso mopachus itlac sente hua quedespresiörus ocsente. Abele nentietequepanusque Deus mientras nuyejque nenquetequepanoa ricojyutl. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Hua inu fariseos nuyejque oquecaqueya ini nönca sösantle. Yejua lalebes quetlasojtlaya tomi. Hua yejua ica biebetzcaya tli quejtuloöya yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hua yejuatzi oquemelfejque: ―Nemejua nencate giente tli sie nemejua nemochihua nenyecteque imixtla giente. Cache Deus quixomatihua nemoyulo. Pues tlin tlöca quepensöroa lalebes cuale, yaja inu Deus quetlajyelejtalo. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Inu tiempo de inu ley hua de inu tlayulepantejque oyeya hasta cuöc ohuöla Xohuö. Desde cuöquenu monunutza de quiene Deus tlamandöruro. Hua öque queneques cuale calaques cöne tlamandöruro tlö ica pobierco. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero mös beles cuale panus elfecac hua tlöltecpactle, pero abele moniencuepas nion sente lietra de tli tlajcuelulpanca ipa inu ley. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Tlö canajyeca quecajcöhua isohua, hua mosohuajtea ica ocsente, yaja tlaumepea hua tlajtlacoa. Hua öque mosohuajtea ica inu sohuatl tli inömec oquecajcö, yaja tlajtlacoa porque inu sohuatl quepea inömec, mös amo quepexteca. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Oyeya sente tlöcatl rico, que motlaquentiöya de cuale tzotzomajtle morörojtec hua de tzotzomajtle de lino ara ca cuale. Cöra tunale quechihuaya tlacuale lalebes cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Oyeya nuyejque sente motlajtlaijtlane itucö Lázaro. Ini nönca obetztaya ipa iqueyöhuatie de inu rico. Quepeaya meyac söhuame. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Hua quenequeya quecuös mös sa lo que tli betzeya itzintla miesa de inu rico. Hasta huölöya checheme hua quepajpajlfiöya isöhuahua. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Hua omochi que omec inu motlajtlaijtlane, hua oquebicaque öngeles para iyes itlac Abraham. Omec nuyejque inu rico, hua oquetlölpachojque. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hua ompa ijtec mectlöncale oajcopatlachix, cuöc oyeya ipa tietunie. Hua oquejtac Abraham bejcateca, hua inu Lázaro itlac. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Yecuöquenu yaja otzajtzec. Oquejto: “Notajtzi Abraham, ma temetzmoyulcocolfe naja. Xomotitlanele inu Lázaro ma quepaltelite imajpel ijtec ötzintle, hua ma quetztelique nonenepil, ipampa necpea meyac tiecoco ijtec ini nönca tletzintle”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Hua oquelfe inu Abraham: “Ixo, xequelnömeque que otecpex meyac sösantle tlin cuale mientras tenemeya, hua Lázaro nuyejque oquepex tiecoco. Pero öxö yaja moyulölea necö, hua taja tecpea inu tiecoco. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Hua amo sa inu, pero onca sente tlabejcatlalestle entre tejua hua nemejua. Ejqueu tli quenequesque panusque ca nemejua abele, nimpor de ca ompa para ca necö abele öque panus”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Hua oquejto: “Temetzmotlötlajtelea noso, notajtzi, que xomotitlane ma beya ica ichö notöta. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pues necpea möcuiltie nocnihua. Ompa ma quennunutza yejua, para majcamo huölöcö nuyejque ipa ini nönca tiecoco”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Hua Abraham oquelfe: “Inu ömatl de Moisés hua de tlayulepantejque ompa quepea. Ma quecaquecö”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Yecuöquenu yaja oquejto: “Amo, notajtzi Abraham, cache tlö yeca iyös ca yejua de tli mimejque, moyulcuepasque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Cache Abraham oquelfe: “Tlö amo quecaque tli oquejtojque inu Moisés hua inu tlayulepantejque, nuyejque amo moneltocasque mös yulebes sente de intzölö mimejque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Hua oquemelfejque tiemachtejcöhua: ―Seme quepea que iyes que giente quenchihualtisque que ocseque giente betzesque ipa tlajtlacule. Pero ¡porube de inu nieca tlöcatl tli ejqueu quechihuas! ");
INSERT INTO nhgNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Cache cuale uyesquea para inu tlöcatl tlö quejilpelisquiöne sente tietetu de molino ipa icucutla hua ejqueu quetlajcalesquiöne ijtec lamör, hua ejqueu majcamo quechihualte sente de ini nöncate pelantzetzi ma betze ipa tlajtlacule. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Xecpeacö cueröro por nemejua mismo. Tlö tlajtlacus mocni ca taja, xequelfe. Hua tlö moyulcuepa, xecperdonöro. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tlö tlajtlacoa ca taja checumejpa ipa sente tunale hua checumejpa mocuepa ca taja hua quejtoa: “Noyulcuepa, xeniechperdonöro”, pos xecperdonöro. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Hua inu tlateotitlanme tieyelfejque Tlöcatzintle: ―Xetiechmopaliebele ma cache toneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yecuöquenu Tlöcatzintle oquejtojque: ―Tlö nenquepeasquiöya nemoneltoqueles quiename sente ixenöchyo mostöza, nenquelfisquiöya ini nönca cuabetl: “Xomocopina, hua xomotucate ijtec lamör”, hua nemiechneltocasquea. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Tlö canajyeca de nemejua quepea sente tlatequepano esclavo que tequete ca yunta noso quemixutea calnielojte, cuöc yaja hualmocuepa de ca caltienco amo nenquelfisque sa nima: “Xecalaque, xomotlöle, xetlacua”. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Cache cuale nenquelfisque: “Xectlöle tli nejcuös, hua xecololo momöngas hua xeniechtlatiequele hasta senamo ma netlacua hua ma netlaye”. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Beles nenquetlasojcömatelea inu esclavo ipampa oquechi tli onenquemandörojque? Pos de mölas amo. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Sa ejqueu nuyejque nemejua, cuöc nenquechihuasque noche tli Deus nemiechmandörojque, xequejtucö: “Amo cualteque tetlatequepanojque tecate tejua. Pues amo otecchijque cache de lo que tli conbenierebeya tecchihuasquea”. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Hua omochi que mientras yejuatzi biloaya ica ciudad de Jerusalén, panoaya tlanepantla de inu estados de Samaria hua Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Hua cuöc ocalacoac ipa sente puieblo, ohuölajque tienömequeco majtlactien tlöca sa söhuayojque. Yejua omoquetzque bejcateca, ");
INSERT INTO nhgNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","hua otzatzeque. Oquejtojque: ―Jesús, toTlöcatzi, ma temetzmoyulcocolficö tejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Hua cuöc yejuatzi oquemejtaque, oquemelfejque: ―Xeyöcö, xomotieijteticö inca teopexcötzetzi. Hua omochi que cuöc uyajque yejua, opajteque. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yecuöquenu sente de yejua, cuöc omojtac ye opajtec, omocuec, hua tiechamööya Deus ca checöhuac tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hua omopechtiecac tieicxetla yejuatzi hua tietlasojcömachele. Hua ini nönca oyeya de estado de Samaria. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Hua onöhuatihuac Jesús, oquelfejque: ―¿Amo nencate nenmajtlactie tli nenpajteque? Hua inu checnöbe, ¿cöne cate? ");
INSERT INTO nhgNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Amo oyeya öque mocuepas para tietlasojcömachelis Deus tlöcamo sa yaja ini nönca estranjiero? ");
INSERT INTO nhgNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Hua oquelfejque: ―Xemiehua hua xebeya. Por tomoneltocac ye tepajtec. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Hua tietlajtlanejque inu fariseos, nele quiema huölös tunale cuöc Deus tlamandörurus. Oquennönquelejque, oquemelfejque: ―Giente amo quejtasque cuöc Deus piehualus tlamandörurus. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nimpor amo quejtusque: “Xequejtacö necö”, o noso “Xequejtacö niepa”. Pues Deus tlamandöruro nemotzölö nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hua oquemelfejque tiemachtejcöhua: ―Huölös tiempo cuöc nenquenequesque ma huöla tunale cuöc naja öque onochi netlöcatl neyes ca nemejua. Pero amo nima huölös inu tunale. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Hua giente nemiechelfisque: “Xequejtacö necö”, o noso “Xequejtacö niepa”. Amo xeyöcö para nenquejtasque, nimpor amo xequentocacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ipampa iyes quiename sente tlapetlönelestle, que cuöc tlapetlöne ipa sie pörte de elfecac, tlaniese hasta ocsie pörte elfecac. Ejqueu nuyejque cuale niechejtasque ca nobeyo naja que onochi netlöcatl ipa inu nieca tunale cuöc nehuölös. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero primiero conbenierebe ma necsufriro meyac sösantle, hua niechtlajyelejtasque ini nönca giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Hua quiene omochi ipa inun tunalte de Noé, ejqueu nuyejque iyes ipa inun tunalte cuöc nehuölös naja que onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Giente tlajtlacuöya, cojconiya, mosohuajtiöya hua monajnömectiöya. Ejqueu quechihuaya hasta pa inun tunale cuöc ocalac Noé ijtec inu börcobiebe itucö örca. Hua ohuöla ötzintle, hua oquenpojpolo innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ejqueu nuyejque quieme ipa inun tunalte de Lot, giente tlajtlacuöya, cojconiya, tlajtlatucaya, motlacubiöya, tlanajnamacaya, hua quechejchihuaya calte. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Cache ipa inun tunale cuöc Lot oquis de inu ciudad de Sodoma, oqueya de elfecac tletzintle hua azufre, hua oquenpojpolo innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ejqueu mismo mochihuas inun tunale cuöc notieijtetis naja que onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ipa inun tunale, öque iyes icpac cale, hua tli ihuöxca icaca calejtec, majcamo temo para quequextiti. Hua ejqueu mismo öque icaca ca caltienco majcamo mocuepa pa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xetlalnömequecö tli oquepasöro isohua Lot. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Öque beletes queneques quemöquextis inemeles, quixniempolus. Hua öque beletes moconformörus para queniempolus, quemalfis. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hua nemiechelfea que ipa inu nieca yohuale yesque unte ipa sente tlapechtle. Sente quebicasque sa de repiente, hua ocsente quecöjtiehuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Unte sohuame testasque innehua. Sente quebicasque sa de repiente, hua ocsente quecöjtiehuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Hua yejua onöhuatque, otieyelfejque: ―Tlöcatzintle, ¿cöne mochihuas ini nönca? Hua yejuatzi oquemelfejque: ―Cöne iyes cuierpo mejque, ca ompa mosentlölisque tzopilume. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Hua oquemelfejque sente cuiento para quemejtetisque que queconbenieroa öque ma seme motlajtlötlajtejta, hua majcamo quecöhua itlötlajteles. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Oquejtojque: ―Oyeya sente tlajtoöne ipa sente puieblo. Yaja amo tiemabeliöya Deus, nimpor amo pa quemejtaya tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nuyejque oyeya ipa nieca puieblo sente icnusohuatl. Yaja huölöya ica inu tlajtoöne, hua quejtoöya: “Xomoarreglörfe nopeleito tli necpea ica noenemigo hua xomocastecörfe por tli oquechi”. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pero por quiesque tiempo yaja amo oquenec. Cache sötiepa de meyac tunale oquejto ipa iyulo: “Mös amo netiemabelea Deus, nimpor amo pa nequemejta tlöca, ");
INSERT INTO nhgNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero ini nönca icnusohuatl seme niechpasolojteneme. Hua por inu necarreglörus ipeleito, para ma ayecmo niechpasoluque”. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Hua oquejtojque Tlöcatzintle: ―Xejcaquecö tli quejtoa inu tlajtoöne amo yectec. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Pues tlö yaja carreglöro inu peleito, cache ca meyac arrasu Deus quencastecörusque inenemigos de tiegiente tli quemixpejpenque, tli tietzajtzelea yohualen tunale. Pos amo bejcöbihuas para quencastecörusque. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nemiechelfea que sa nima quechihuasque. Cache cuöc naja que onochi netlöcatl nehuölös, ¿beles nequenniextiqui giente tli moneltoca necö ipan tlöltecpactle, noso beles amo? ");
INSERT INTO nhgNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Hua oquemelfejque ocsente cuiento ca seque tli quepeaya confiönsa de que yejua oyeya yecteque lalebes, hua quendespresiöroöya noche ocseque. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Unte tlöca otlejcoque ompa teupa omotlajtlötlajtito. Sente oyeya fariseo, inu ocsente oyeya tlanecheco. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Inu fariseo ijcataya hua motlajtlötlajtejtaya ca sie yaja. Oquejto ejqueyi: “Deus, temetzmotlasojcömachelelea que amo necaca quiename ocseque tlöca. Pos yejua cate ichtejque, amo cualteque, tlaumepeaneme. Nuyejque amo neca quiename ini nönca tlanecheco. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Netlajyubea ujpa por semöna, hua nectiemaca inu majtlactle pörte de noche tli necpea”. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Cache inu tlanecheco bejcateca oyeya. Amo quenequeya nimpor ajcopatlacheas ca elfecac, tlöcamo omomacaya ipa ipiecho ipampa pinöhuaya lalebes. Quejtoöya: “Deus, xeniechmojtele ca cuale, pos naja netlajtlacultec necaca”. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nemiechelfea que ini nönca tlanecheco uya ca ichö ye yectec tieixpa Deus, pero inu fariseo amo. Pues noche öque mochajchamöhuas, quepichaquisque. Cache öque mopichaquis, quechamöhuasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hua giente nuyejque tiehualequeliöya inpelancuconehua para ma quenmötocacö. Pero cuöc oquejtaque tiemachtejcöhua, quemajajuaya giente tli quenhualecaya inpelhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús oquennutzque, hua oquemelfejque: ―Xequencöhuacö pelantzetzi ma huölöcö notlac, hua amo xequentzacuelicö. Porque giente tli cate quiename nochemeji pelantzetzi quepea pörte cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Melöhuac nemiechelfea, que öque beletes amo tiecöhuas Deus ma tlamandörucö ipa iyulo quiename sente peltzintle tiecöhua, inu tlöcatl amo calaques cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Hua otietlajtlane sente tlayecönque, otieyelfe: ―Maestro, lalebes tecuale tetlöcatl. ¿Tli nayes para necpeas nemelestle nochepa? ");
INSERT INTO nhgNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús quelfejque: ―¿Tlica teniechelfea necuale netlöcatl? Amo onca sente cualtec tlöcamo sa sietzi, yejuatzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Inu mandamientos ye tecmate: “Amo xecalaque ca isohua ocsente”. “Amo xetlamecte”. “Amo xetlachteque”. “Amo tiecamac xetieajaque”. “Pa xequemejta motajtzi hua monöntzi”. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Entunses inu tlöcatl oquejto: ―Noche inu sa onecchijtebitz desde netzitzequetzi hasta öxö. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cuöc Jesús oquecajque ini nönca, oquelfejque: ―Sa sente cosa oc metzpoloa. Xecnamaca noche tli tecpea, hua xequenxiexelfe tli porubejte. Ejqueu tecpeas ricojyutl ompa elfecac. Entunses xehuöla, xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cache yaja omotequepacho lalebes cuöc oquecac ini nönca sösantle, ipampa oyeya rico lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Hua cuöc oquejtaque Jesús, nuyejque netequepachuluc. Oquejtojque: ―Bel lalebes tequeyo para calaquesque tlin ricojte cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cache isejco calaques sente camello por ixtelolo de sente öcuxa, que sente rico calaques cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hua tli oquecajque oquejtojque: ―¿Öquenu noso cuale momöquextis tlö ejqueu? ");
INSERT INTO nhgNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hua yejuatzi oquemelfejque: ―Lo que tli abele para tlöca, cuale quechihuasque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Entunses Piero oquejto: ―Xomojtele tejua otejcöjque tlin tohuöxca, hua temetzmotoquelejteneme. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Hua yejuatzi oquejtojque: ―Melöhuac nemiechelfea, öque tli cualcöjtiehuas ichö, noso isohua, noso icnihua, noso itötajua, noso ipelhua, por queneques ma tlamandöro Deus, ");
INSERT INTO nhgNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ipa nönca tiempo yaja queselis cache meyac töntos. Hua ipa inu tiempo tli huölös quepeas nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Hua yejuatzi oquenbicaque inu majtlactle huan ume nencua. Oquemelfejque: ―Xequejtacö que teyabe ca ciudad de Jerusalén. Hua mochihuas noche sösantle tli oquejcuelojque inu tlayulepantejque acerca de naja que onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pues niechtiemöctisque inca tli amo de topuieblo. Yejua moburlörusque de naja, hua niechtratörusque san petzotec, hua niechchejchasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Hua sötiepa niechbitequesque, hua niechmectisque. Cache ipa yeye tunale neyulebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero yejua niontle amo casojcömateya de ini nönca sösantle. Pos ini nönca tlajtule amo cantendierojque, hua amo casojcömateya tli quejtuloöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Hua omochi que cuöc onepachulutöya itech ciudad de Jericó, sente ixcocoxque oyehuataya ipa ojtle motlajtlaijtlanejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ini nönca cuöc oquecac quiene panuya tlöca, otlajtla tlininu oyeya inu nieca. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hua oquelfejque que nele panoöya ca ompa Jesús de puieblo de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Yecuöquenu otzajtzec, oquejto: ―Jesús, iConie David, ma temetzmoyulcocolfe. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Hua tli tlayecönaya cajajuaya nele ma quetzacua icamac. Pero yaja cache lalebes tzajtzeya: ―IConie David, ma temetzmoyulcocolfe. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yecuöquenu onequetzaluc Jesús, hua otlanahuatiluc ma quehualecacö. Cuöc yaja oaseto, oquetlajtlanejque: ");
INSERT INTO nhgNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Pos ¿tli tecneque ma temetzchibele? Hua yaja oquejto: ―Tlöcatzintle, ma netlachea. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Entunses Jesús oquelfejque: ―Xetlachea. Por tomoneltocac ye tepajtec. ");
INSERT INTO nhgNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hua sa nima otlajtlachix, hua tietocaya tiechamöjtöya Deus. Hua noche giente cuöc oquejtaque otieyectieniejque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Hua ocalacoac hua panoaya por inu ciudad de Jericó. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ompa oyeya sente tlöcatl itucö Zaqueo, öque oyeya tlayecönque de inu tlanechecojque, hua oyeya rico. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Hua quenequeya tieyejtas Jesús öquenu beles iloaya. Pero abele otieyejtac ipampa lalebes meyac giente, hua ipampa yaja oyeya chapörro. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Entunses omomerö cache adelönte, hua otlejcoc ipa sente cuabetl de sicómoro para tieyejtas, pos ca ompa panoas. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Cuöc Jesús onaxihuaco ipa nieca locör, oquejtaque, hua oquelfejque: ―Zaqueo, xecuesebe xetemo, ipampa öxö necpea que nosiebis ipa mochö. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Yecuöquenu yaja otemo isejcö, hua otieselejque ipa ichö ca meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Hua cuöc oquejtaque ini nönca, innochtie tieca tlajtoöya Jesús. Quejejtoöya: ―Yaja inu Jesús ocalac para mosiebis pa ichö de sente tlöcatl tlajtlacultec. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yecuöquenu Zaqueo omoquetz, hua otieyelfe Tlöcatzintle: ―Xomojtele, Tlöcatzintle, tlajcopa de tli nohuöxca nequenmacas tli porubejte. Hua tlö canajyetla nequechtequele canajyeca, nejcuepelea ca nöjpa. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Hua Jesús oquelfejque: ―Öxö ye omomöquextejque giente ipa ini nönca chöntle. Pues nönca Zaqueo melöhuac nuyejque icaca iconie Abraham hua moneltoca quiename Abraham. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pues naja öque onochi netlöcatl onehuöla onectiemuco hua onecmöquextico tli oixniempolejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mientras oquecaqueya yejua ini nönca sösantle, Jesús oquejtojque ocsente cuiento. Oquejtojque ipampa ye itlac oyeya de ciudad de Jerusalén, hua ipampa yejua quepensöroöya que nele sa nima Deus piehualusquea tlamandörurus pan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Por inu oquejtojque: ―Sente tlöcatl hacendödo uya ipa ocsente tlöle bejca, para ompa mochihuas rey, hua sötiepa mocuepas. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Antes de que onya oquennutz majtlactie itlatequepanojua, hua oquenmacac diez mil piesos ca cara sesen tlöcatl. Oquemelfe: “Xectlönelicö mientras nebitz”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cache giente de inu nieca tlöle quetlajyelejtaya, hua oquetitlanque inrepresentöntes ma quetocacö, ma quejtucö: “Amo tecneque ini nönca ma iye rey topa tejua”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","’Hua omochi que hualmocuec yaja. Ye oyeya rey. Otlatitla ma huölöcö inu tlatequepanojque öque oquenmacac inu tomi, para quemates tli oquetlönelejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Hua ohuöla inu cachto, hua oquejto: “Tlöcatzintle, ca motomintzi onectlö oc majtlactle töntos”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Hua yaja oquelfe: “Cuale otecchi. Taja teca tecuale tetlatequepano. Ye onequejtac que teca de confiönsa ca tli sa tzitzequetzi. Por inu öxö xetlamandöro ipa majtlactie ciudades”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Hua ohuöla inu segundo, hua oquejto: “Ca motomintzi, Tlöcatzintle, onectlö oc möcuile töntos”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Hua nuyejque oquelfe itieco: “Taja nuyejque xetlamandöro ipa möcuiltie ciudades”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Hua ohuöla ocsente, hua oquejto: “Tlöcatzintle, nönca motomintzi. Nequejyöntaya ijtec sente tzotzomajtle. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pos otemetzmomabelele tejuatzi, ipampa melöhuac techecöhuac tomobetzteca, que temönelea tli amo otomotlölele, hua tomopexquelea tli amo otomotuquele”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Yecuöquenu yaja oquelfe: “Amo cuale moyulo hua amo tecuale tetlatequepano. Ca lo que tli taja mismo tequejto temetzcuntenöroa. Tecmajtaya que naja necaca nechecöhuac netlöcatl, que necöna tli amo onectlöle, hua que necpexca tli amo onectucac. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Tlica noso amo siquiera amo otectiemacac notomi ipa bönco? Ejqueu cuöc nehuölösquiöya necönasquea siquiera ca tli otequet”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hua oquemelfe tli ompa oyejyeya: “Xejcuejcuelicö inu tomi hua xecmacacö öque oquetlö majtlactle töntos”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Hua yejua oquelfejque: “Tlöcatzintle, ye quepea majtlactle töntos”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Pos naja nemiechelfea que öque quepea, quemacasque cache meyac. Cache öque amo bel quepea, quequextelisque hasta inu tepetzi tli oc quepea. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero inu niecate noenemigos tli amo queneque ma neye rey impa, xequenhualecacö necö, hua xequenmecticö nixtla naja”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Hua cuöc ye oquejtojque ini nönca, quesequiruroöya tlayecönalutöya giente para ca inu ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Hua omochi que ohualiloac itlac puieblos de Betfagé hua Betania, itech inu nieca munte itucö Tepietl de los Olivos. Ompa oquentitlanque unte de tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Oquemelfejque: ―Xeyöcö ipa inu puieblo niepaca. Cuöc nencalaquesque ompa, nenqueniextisque sente purojconetzi elpetas. Ayemo öque ipa tlejco. Xectojtomacö, hua xecualecacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tlö canajyeca nemiechtlajtlanis: “¿Tlica nenquetojtoma?” ejqueyi nenquenönquelisque: “Tlöcatzintle quenesesitöruro”. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Hua uyajque tli oquentitlanque, hua oqueniextejque quiene oquemelfejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hua cuöc oquetojtontaya inu purojconetzi, itiecohua de inu purojconetzi oquemelfejque: ―¿Tlica nenquetojtoma inu purojconetzi? ");
INSERT INTO nhgNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Hua yejua oquejtojque: ―Tlöcatzintle quenesesitöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Yecuöquenu oquehualecaque tieca Jesús. Hua oquetlötlölejque intlaquie ipa inu purojconetzi, hua ipa tietlejcabejque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Hua cuöc ye biloaya yejuatzi, quesoaya intlaquie ipa ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Hua ye axihuato itlac inu ciudad, cöne mopeloa ojtle itlac inu Tepietl de los Olivos. Noche inu meyactie tiemachtejcöhua ca meyac pöquelestle opiejque tiechamoöya Deus ca checöhuac tlajtule por noche tli tietzöbetl oquejtaque yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Oquejtoöya: ―¡Ma tetieteochihuacö tietucöyupa Tlöcatzintle nöiloac rey öque biloatz! ¡Ma uye yecsiebelestle ompa elfecac, hua yectieniebelestle ompa tlacpac! ");
INSERT INTO nhgNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yecuöquenu seque de inu fariseos de tli ompa tlamachyöya otieyelfejque: ―Maestro, xequenmajajfele inu momachtejcötzetzihua. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yejuatzi onöhuatihuac, oquemelfejque: ―Nemiechelfea que tlö ini nöncate quetzacuasque incamac, teme tzajtzajtzesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Hua cuöc ye itlac onaxihuato oquejtaque inu ciudad, hua chucoac ipampa yaja. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Oquejtojque: ―¡Ay, Jerusalén! ¡Ojalá tequixomatesquiöne ipa ini nönca tunale tli sösantle metzhualequelisquea siebelestle! Cache öxö inu sösantle mojyönteca para amo tequejtas. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pues huölösque tunalte mopa, que inu moenemigos metzyehualusque quieme ca tepöntle, hua metztlölelisque quiename cierca, hua ca nobeyo metzyehualusque para amo tequisas. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Hua metztlajcalesque ipan tlöle, ca noche tli mojtec neme. Hua amo quecöhuasque mopa sente tietetu icpac ocsente tietetu. Ini nönca mopa mochihuas ipampa amo otequixomat inin tunale cuöc onehuöla ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Hua ocalacoac ipa teopantle, hua opiehualuc quenquextilo ca queyöhuac quiejquech tlajtlanamacaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Quemelfiloöya: ―Tlajcuelulpanca que: “Nocal iyes cale de netlötlajtelestle”. Pero nemejua ye onenconchijque tiecaltzi Deus quieme cana ustutl de ichtejcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Hua cöra tunale tlamachtiloöya ipa teopantle. Pero inu jefes de teopexcötzetzi, ca tlamachtiöneme de teotlajtule hua tli tlötlayecönque de inu giente, yejua quenequeya tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero amo queniextejque quiene ca quechihuasque. Pues noche giente oquecactaya tli quejtuloöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Hua omochi ipa sie tunale, cuöc yejuatzi quenmachtilutaya giente ipan teopantle hua tlanunutzaloöya de cuale tlamachestelestle, oaseto jefes de teopexcötzetzi ca inu tlamachtiöneme de teotlajtule hua biebentzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Hua otieyelfejque: ―Xetiechelfe, ¿ca tli beletelestle tecchihua ini nönca sösantle? Noso ¿öquenu ometzmacac ini nönca beletelestle? ");
INSERT INTO nhgNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Onöhuatihuac, hua oquemelfejque: ―Naja nuyejque nemiechtlajtlanes sente pregunta. Xeniechelficö nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Xohuö Bautista tlacuötiequiöya. ¿Beles Deus cualtitlanque ma tlacuötieque, noso tlöca cualtitlanque ma tlacuötieque? ");
INSERT INTO nhgNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yecuöquenu yejua quepensörojque. Molfejque: ―Tlö tequejtusque que Deus, yaja quejtus: “¿Tlica noso amo nemoneltocaque ca yaja?” ");
INSERT INTO nhgNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero tlö tequejtusque que tlöca, noche ini giente tiechtecaltisque, ipampa yejua quepensöroa que Xohuö oyeya tlayulepante de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Entunses onöhuatque que amo quemate öquenu cualtitla. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yecuöquenu Jesús oquemelfejque: ―Nuyejque naja amo nemiechelfis öquenu niechmacac beletelestle para ma necchihua ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hua piehualuc quemelfiloöya giente ini nönca cuiento: ―Sente tlöcatl oquetucac sente huierta de uvas temecatl. Quentlaniejte tejtequetque, hua yaja uya ca bejca hua amo omocuec ca ompa por meyac tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pos ca tiempo, ocualtitla sente itlatequepano inca inu tequetque, para yejua ma quemacacö de inu fruto de inu huierta. Pero inu tequetque oquebitejque, hua oquetitlanque sin niontle. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Hua turavea cualtitla ocsente tlatequepano. Pero yaja nuyejque oquebitejque hua oquetratörojque san petzotec, hua oquetitlanque sin niontle. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Hua oc turavea cualtitla ca yete tlatequepano, hua inu nieca nuyejque oquecocojque hua oquetojtocaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Yecuöquenu inu tlöcatl öque ihuöxca huierta oquejto: “¿Tli noso necchihuas? Nectitlanes notlasojcöconie. Beles pa quejtasque yaja”. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Cache inu tequetque, cuöc oquejtaque, oquepensörojque entre yejua. Molfiöya: “Yaja ini öque mohuöxcatis de ini nönca huierta. Ma tecmecticö para que tli yaja mohuöxcatisquea tohuöxca iyes”. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Hua oquequextejque ca queyöhuac de inu huierta, hua oquemectejque. ¿Tli noso quenchibelis inu tlöcatl öque ihuöxca inu huierta? ");
INSERT INTO nhgNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pos huölös quenpojpoluqui inu niecate tequetque. Hua inu huierta quentlaniejtis ocseque. Hua cuöc oquecajque inu giente, oquejtojque: ―Majcamo ejqueu mochihua. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Cache yejuatzi oquemejtaloöya, hua oquemelfejque: ―¿Tli noso icaca ini nönca tli tlajcuelulpanca? Inu tietetu tli calchihuaneme quetlabielcöjque, yaja mismo omochihuaco esquiniero principal. Pos cöne tlajtlajtoa de inu tietetu, tlajtlajtoa de Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Öque beletes betzes ipa inu tietetu, motlajcocotunas. Cache tlö canajyeca ipa yaja betzes inu tietetu, quepajpötlas. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Hua inu jefes de teopexcötzetzi ca tiehua inu tlamachtiöneme de teotlajtule quetiemoöya maniera quiene tieasesque ipa inu nieca ura, porque yejua casojcömateya que ca nieca cuiento tlajtlajtuloöya de yejua. Pero amo tieaseque ipampa quenmabeliöya giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Hua seme tieyetztaya yejuatzi abier tli quechihuasque. Quenhualentitlaneto seque giente sa ichtacajtzi. Yejua quechihuaco quiename cana yecteque oyejyeya, para ejqueu quecaquesque tlö cana yejuatzi quejtusque canajyetla tli itech cuale tietieyelfisque. Entunses cuale tietiemöctisque ica inu cubernadur para ma tiejuscöro hua ma tiecastecöro. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ini nöncate giente otietlajtlanejque, oquejtojque: ―Maestro, tecmajtecate que tomojtalfea hua tomotlamachtelea lo que tli melöhuac, hua que nionöque tlöcatl amo metzmoimportörfea tlö rico tlö porube tlö quiene, tlöcamo de melöhuac tequenmojtetelea giente ojtle de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Beles conbenierebe tecmacasque inu emperador César tocontribuseyu, noso amo? ");
INSERT INTO nhgNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pos yejuatzi casojcömatque quiene mañusos oyejyeya. Oquemelfejque: ");
INSERT INTO nhgNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","―Xeniechejteticö denario tomi. ¿Öqueniji ixöyac quepea, hua öquenu ihuöxca inu tlajcuelule? Yejua oquejtojque: ―De César. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yecuöquenu oquemelfejque: ―Pos xecmacacö César tli quetocöroa César, hua xetiemacacö Deus tli tietocöroa Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Hua abele tli oquejtojque amo cuale de tietlajtultzi ixtla inu puieblo. Quetietzöbejque quiene ca quennönquelejque, hua oquetzajque incamac. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Entunses ohuölajque tietlac seque de inu saduceos, öque quejejtoa nele mimejque amo yulebesque. Yejua tietlajtlanejque, ");
INSERT INTO nhgNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","tieyelfejque: ―Maestro, Moisés otiechejcuelfe que tlö icni de sente tlöcatl meque, tli quepeaya isohua, pero amo quepeaya ipelhua, que nele icni ma case isohua para quentlöcatelelis ipelhua de icni. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Oyeya, noso, checume icnijte. Inu cachto jiebe oquepex isohua, pero omec sin quepeas ipelhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hua icni omosohuajte ca yaja, hua nuyejque ejqueu ipa omochi. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Hua ocsente icni ocasec, hua ejqueu mismo noche checumeme, hua innochtie omejmejque sin que amo quencöjtiejque inpelhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Sötiepa inu sohuatl nuyejque omequeco. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Entunses, cuöc yulebesque mimejque, ¿cötlaja de yejua iyes isohua ini nönca sohuatl? Pos innochtie checumeme oquepexque quiename insohua. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yecuöquenu Jesús oquemelfejque: ―Tlöltecpactlöca mosojsohuajtea hua monajnömectea. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero niecate öque quemeresieroa para asetibe ipa inu nieca tlöltecpactle yancuec hua para yulebesque de intzölö mimejque, yejua nimpor amo mosojsohuajtea, nimpor amo monajnömectea. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Pos ayojcuele mejmequesque, pos ye cate iguöl quiename öngeles, hua cate tiepelhua Deus, pos ye onyojyulejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero que tiel mimejque yulebesque, Moisés mismo otlamachte cöne tlajtoa de tebetztle. Pos tiecuitea Tlöcatzintle Deus de Abraham, Deus de Isaac, hua Deus de Jacob. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bieno pues, yejuatzi amo iloac Deus de mimejque, tlöcamo Deus de tli yulejtecate. Pos noche nentecate para ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Hua tienönquelejque seque tlamachtiöneme de teotlajtule. Oquejtojque: ―Maestro, cuale tli otomojtalfe. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pos ayecmo öque matreviro para tietlajtlanes canajyetla. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Hua yejuatzi oquemelfejque: ―¿Quiene mojtoa que nele inu Cristo öque Deus quixpejpenque icaca iconie de David? ");
INSERT INTO nhgNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pos sie yaja David quejtoa ipa inu libro de Salmos: Tlöcatzintle tiemolfeliluc notlöcatzintle: “Xomotlöle ca nomöyecömpa, ");
INSERT INTO nhgNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta senamo ma nequentiemöcte moenemigos momötla”. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ejqueu noso David quecuitea Cristo “Tlöcatzintle”. ¿Quiene noso icaca iconie? ");
INSERT INTO nhgNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hua mientras oquecaqueya noche puieblo, oquemelfejque tiemachtejcöhua: ");
INSERT INTO nhgNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Xecpeacö cueröro de inu tlamachtiöneme de teotlajtule. Pos yejua mochajchamöhua yajtenemesque ca bejbeye intlaquie. Quecualejta lalebes ma giente quenyectlajpalucö ipa plösa. Seme quetiemoa tlaixpa yesque ipa teopancucone, hua cöne tlajtlacua quetiemoa tli cache cuajcuale locör. ");
INSERT INTO nhgNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Motejtechtea inchajchö de icnusohuame. Hua para nieses que lalebes cualteque cate motlötlajtea lalebes meyac tiempo. Pero impa ini nöncate huölös cache bieye incastigo. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Hua otlachealuc, hua oquemejtaque tli ricojte quiene quetlöliöya intomi para bentle ijtec caxu. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Hua nuyejque oquejtaque sente icnusohuatl porube, que quetlöliöya unte tomi istöque. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Hua oquejtojque: ―Ica melöhuac tli nemiechelfea, que ini nönca icnusohuatl oquetlöle cache meyac que innochtie ocseque. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pos innochtie ini nöncate sa de tli subra oquetlölejque para bentle. Cache ini icnusohuatl mös porube oquetlöle noche, hua amo tli mocöbe tli quecuös. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Hua seque tlajtoöya de inu teopantle, que lalebes cuale tlachejchijtle ca cualtzetzi teme hua sösantle bentle. Yejuatzi oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ini nönca sösantle tli nenquejta, huölösque tunalte que amo mocöhuas tietetu icpac ocsente tietetu, tlöcamo noche yecxexetunes. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Hua otietlajtlanejque, otieyelfejque: ―Maestro, ¿quiema noso mochihuas ini nönca sösantle? ¿Tli sieñas oyes cuöc ini nönca sösantle miero mochihuati? ");
INSERT INTO nhgNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yejuatzi oquejtojque: ―Xomotlachilicö majcamo öque nemiechcajcayöhua. Pues huölösque meyactie notucöyupa. Quejtusque: “Naja neCristo”, hua “Tiempo ye tlanteca”. Amo xequentocacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Cache cuöc nenquecaquesque de guerras hua que momagatecate lalebes, amo xomomajticö, porque ini nönca sösantle quepea que mochihuas cachto. Pero amo sa nima tlames tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yecuöquenu oquemelfejque: ―Majcoques nación cuntra nación, igiente de sente rey encuntra de igiente de ocsente rey. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tlaolines lalebes checöhuac ipa meyactie tlölte, hua ca nobeyo giente öpesmequesque hua iyes bieye cocolestle. Hua niesesque sösantle tiemajte hua sieñas bejbeye ipa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero cachto de que mochihuas ini nönca sösantle, giente nemiechasesque, hua nemiechtepotztocasque, hua nemiechtiemacasque ipan teopancucone hua ipan cörseles, hua nemiechbicasque imixpa reyes hua imixpa cubernadurte ipampa nenquebica notucöyo. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ejqueu cuale nenquemelfisque de lo que tli nemoneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Xecdesedirucö öxö ipa nemoyulo que amo tli nenquepensörojtasque cachto de quiene nennöhuatesque. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porque naja nemiechmacas tlajtule hua machestelestle que nemoenemigos abele quexexicusque noso abele nemiechtlötlajtulcuepelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Cache hasta nemotötajua nemiechtiemöctisque, hua nemocnihua, hua nemogientes, hua nemoamigos. Seque de nemejua nemiechmejmectisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nemiechtlajyelejtasque noche giente por nopampa. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Cache nion sente tzontle de ipa nemotzonteco amo ixniempolebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Por xecxicojtacö xecmöquexticö nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Pos nenquejtasque ini Jerusalén ye oqueyehualojque meyactie soltörojte. Xecmajtacö cuöquenu que ye miero tlaxexetotzas. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Cuöquenuju quiejquech yesque ipan Judea, ma cholucö hasta ipa tepieme. Quiejquech yesque ipa inu tlöle ma yöcö, hua tli yesque ipa ocsente tlöle majcamo huölöcö ca Judea. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ipampa ipa inu niecate tunalte Deus quencastecörusque giente por lo que tli amo cuale tiechibelejque, para ma mochihua noche sösantle tli tlajcuelulpanca. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Porubejte quiejquech tli uutzte, hua tli tlajtlabepöjtecate ipa inu niecate tunalte! Pues mochihuas sösantle petzotec ipa tlöltecpactle, hua tiecualöneles Deus betzes impa ini giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Quenmejmectisque ca espöda, hua meyactie quenbicasque quiename priesoste ipa ocseque tlölte. Hua nönca ciudad de Jerusalén ipa moquetzasque giente de ocseque naciones hasta senamo ma tlame inu tiempo cuöc inu niecate giente tlamandörusque. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Yecuöquenu yesque sieñas ipan tunale, hua ipa mietztle, hua ipa sitlalte. Ipan tlöltecpactle giente quepeasque tiecoco hua amo quematesque tli quechihuasque ipampa lamör moulinea lalebes hua tlatecuinea. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Sa modesmayörusque giente ipampa majcömequesque de que meyac sösantle ye miero mochihuasque ipa tlöltecpactle. Pos inu sösantle checöhuac de elfecac moulinis. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yecuöquenu quejtasque cuöc naja que onochi netlöcatl nehuölös ipa sente mextle ca checöhualestle hua meyac tlaniextelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Hua cuöc ini nönca piehuas mochihuas, xeajcopatlacheacö, xecajcoquecö nemotzonteco, ipampa nemomöquexteles ye miero aseteca. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Hua oquemelfejque sente ejiemplo: ―Xequejtacö inu icox cuabetl hua noche ocseque cuajme. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cuöc ye itzmoline, nenquejta hua nemomaca cuienta que ye asequi xupantla. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ejqueu nuyejque, cuöc nenquejtasque nemejua que ye mochijteca ini nönca sösantle, xecmatecö que ye miero piehualus tlamandörurus Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Melöhuac nemiechelfea, que amo mequesque innochtie tli öxö nentecate hasta senamo mochihuas noche sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Elfecac hua tlöltecpactle panusque, cache notlajtul amo panus. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Xomojtacö sie nemejua, majcamo iye que cana pa nemoyulo nenquepensörusque sa de borrachera hua tlöhuöncölestle, hua de sösantle de ini nönca nemelestle de tli öque motequepachus. Pos ejqueu huölös nemopa inu nieca tunale sa isejco quiename sente trömpa sa isejco case yulcötl. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pos ejqueu huölös impa noche tli nentecate ipa noche tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Seme xetlachixtacö noso. Xomotlajtlötlajtejtacö para ma xecpeacö checöhualestle para nemöquisasque cuöc noche ini nönca sösantle huölös, hua nenniesesque nixtla naja que onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Hua cöra tunale tlamachtiloöya ipa teopantle. Ca yohuale quixoaya hua nesiebiloöya ipa munte tli itucö Tepietl de los Olivos. ");
INSERT INTO nhgNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Hua noche giente ohuölöya ca ise cualcö, para tiecaquesque ipa teopantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Hua ye miero aseya inu tunale de yelfetl de pöntzi sin levadura, que itucö Pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jefes de teopexcötzetzi ca tiehua tlamachtiöneme de teotlajtule quetiemoöya quiene tiemectisque. Pero quetraböjomatque porque quenmabeliöya inu giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hua ocalac inu Satanás ijtecopa Judas, öque mocuitiöya Iscariote. Yaja oyeya sente de inu majtlactle huan ume tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Hua uya otlajtlajtuto inca jefes de teopexcötzetzi hua inca capetönte. Tlajtlajtoöya de quiene tietiemöctis Jesús inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yejua opajpöjque, hua queprometierfejque nele quemacasque mieleyu. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yaja oquejto que cuale, hua quetiemoöya quiene tietiemöctiti ca yejua sin que ompa yesque giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Hua oaseco inu tunale de yelfetl de pöntzi sin levadura. Ipa inun tunale ijtaya para quemectisque inu calnielojconetzi para bentle de pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yejuatzi oquetitlanque inu Piero ca tiehua Xohuö. Oquejtojque: ―Xeyöcö, xetlapreparörucö para tejcuösque tlacuale de pöscua yelfetl. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yejua otieyelfejque: ―¿Cöne tomonequitea ma tetlapreparörucö? ");
INSERT INTO nhgNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yejuatzi oquemelfejque: ―Xequejtacö que cuöc nencalaquesque ipan ciudad, nemiechnömeques sente tlöcatl tli quebica sente öcumetl ca ötzintle. Xectocacö hasta ipa inu chöntle cöne calaques. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ompa xequelficö inu chöne: “ToMaestro metzelfilo: ¿Cönenca cale cöne nejcuös tlacuale de pöscua yelfetl ca nomachtejcöhua?” ");
INSERT INTO nhgNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Pos yaja nemiechejtetis sente bieye cuörto icpac cale que quepeas noche tli tecnesesitörusque. Ompa xetlamömanacö. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Uyajque noso, hua oqueniextejque san quiene ca oquemelfejque. Hua ompa otlamömanque para pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Cuöc ye oaseco ura onetlöliluc ipa miesa, hua ca yejuatzi tietlateotitlanhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Hua oquemelfejque: ―Bel lalebes onecnec nejcuös ini tlacuale de pöscua ca nemejua antes de que necsufrirus. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pos nemiechelfea que amo nejcuös ocsajpa hasta senamo nejcuös inu melöhuac tlacuale de pöscua ompa cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ocönque sente bölso, hua otiemotlasojcömacheliluc. Entunses oquejtojque: ―Xecönacö ini nönca, hua xomoxiexelfelicö entre nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pues nemiechelfea, que ayecmo quiema neconis ocsajpa ini iöyo de uvas hasta senamo huölös tiempo cuöc Deus tlamandörurus. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Hua ocönque pöntzi, hua tiemotlasojcömacheliluc. Entunses oquecojcotunque, hua oquenmacaque. Oquejtojque: ―Yaja ini nönca ica nocuierpo que nemopampa nectiemaca. Xecchihuacö ini nönca para nenniechelnömectasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ejqueu mismo oquechijque ca inu bölso, sötiepa de cuöc ye otlajtlacualuc. Oquejtojque: ―Ini nönca bölso de vino *ica inu yancuec acuierdo tli mochihuas por noyeso, que nemopampa nunuquebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Pero xequejtacö que öque niechantrecörus ica ca naja ipa miesa. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Melöhuac naja que onochi netlöcatl nemeques, pues Deus ejqueu oquetzontejque. Pero ¡porube de inu nieca tlöcatl öque niechantrecörus! ");
INSERT INTO nhgNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Yecuöquenu yejua opiejque motlajtlaneya sie yejua öque de yejua beles quechihuas ini nönca. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Hua omochi peleito intzölö yejua por öque de yejua momajtaya cache bieye. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yejuatzi oquemelfejque: ―Inu reyes de giente de ocseque naciones motiecojtea de yejua. Hua inu giente quepea que quencuitisque “toPaliebiöneme” inu niecate tli ca checöhualestle quenmandöroa. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Cache nemejua majcamo ejqueu xecchihuacö, tlöcamo öque cache bieye momajteca nemotzölö nemejua, ma mochihua quiename inu cache peltuntle. Hua öque icaca quiename tlayecönque, ma iye quiename tlatequepano. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pos ¿öque cache bieye momajteca, öque motlölea ipa miesa, noso öque tlatequepanoa? ¿Amo yaja öque motlölea ipa miesa? Hua naja necaca ca nemejua quiename öque tlatequepanoa. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’Cache nemejua nencate tli seme nenquesequirojtaya ca naja ipa noche tli onecsufriro. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Naja nemiechmaca para nentlamandörusque, quieme noTajtzi niechmacaque naja ma netlamandöro. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nemejua nentlacuösque hua nentlaisque ipa nomiesa ompa cöne netlamandörus. Nemotlölisque ipa tronos para nenquenjuscörusque inu majtlactle huan ume grupos de giente de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","’Semu, Semu, xequejta que inu Satanás onemiechtlajtla para nemiechtzetzelus quiename öque quetzetzeloa trigo, abier tlö nenbetzesque ipa tlajtlacule. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero naja nontlajtlötlajte por taja ma moneltoqueles majcamo metzpolo. Taja, cuöc tomocuepas, xequencuajpetzo nöncate mocnihua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Hua yaja oquejto: ―Tlöcatzintle, ye neca nelisto para neyös ca tejuatzi mös ipan cörsel noso hasta ipa mequelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Hua yejuatzi oquejtojque: ―Piero, temetzelfea que öxö ayemo tzajtzes canteliex cuöc ye yexpa otecnegörus que amo teniechixomate. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Hua oquemelfejque: ―Cuöc onemiechtitla sin puxajtle, sin morröl, sin sapötoste, ¿nemiechpolo canajyetla? Hua yejua oquejtojque: ―Amoyetla. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Hua oquemelfejque: ―Pos öxö, öque quepea puxajtle, ma cöna, hua nuyejque morröl. Hua öque amo quepea espöda ma quenamaca ipelesol hua ma quecoa. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pos nemiechelfea que quepea que mochihuas nopa inu nieca tli tlajcuelulpanca: “Hua inca tli tlajtlaculteque omopu”. Pues tli tlajcuelulpanca de naja quepea que mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yecuöquenu yejua oquejtojque: ―Tlöcatzintle, xomojtele necö unte espödas. Hua yejuatzi oquemelfejque: ―Sa ca inu ye cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Hua oquixoac. Quiename quepealoöya costumbre, obiloac ipa inu Tepietl de los Olivos. Hua tiemachtejcöhua nuyejque tietocaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hua cuöc ye onaxihuato ipa inu nieca locör, oquemelfejque: ―Xomotlajtlötlajticö para amo nemiechyulmötocas Amo Cuale Tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Hua yejuatzi onenencuaxeluluc de yejua quieme cöne onase sente tietetu cuöc öque tlamutla. Ompa onetlancuöquetzaluc hua onetlajtlötlajtiluc. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Oquejtojque: ―NoTajtzi, tlö tomonequitea, xomojcuenele nönca bölso de tietunie majcamo niechtocöro. Cache majcamo mochihua tli notlanequeles, tlöcamo tli motlanequelestzi tejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hua omoniexte tieca sente öngel de elfecac tiechecöhualesmacaco. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hua tlasufriruroöya lalebes, hua cache netlajtlötlajtiloöya. Oquis tieitunal quiename yestle hua quechepinejque hasta tlölpa. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Hua neajcoquihuac de ipa netlajtlötlajtelestle, hua ohualiloac intlac tiemachtejcöhua. Oquenniextiluco cojcochtaya porque moyulcocoöya lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Oquemelfejque: ―¿Tlica nencojcoche? Xemiehuacö, hua xomotlajtlötlajticö para amo nemiechyulmötocas Amo Cuale Tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Cuöc yejuatzi oc tlajtlajtulutaya, necö ohuölajque meyac giente. Hua öque itucö Judas, sente de inu majtlactle huan ume tiemachtejcöhua, quenyecöntöya. Hua omopacho tietlac Jesús para tiepetzus. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero Jesús oquelfejque: ―Judas, ¿ica petzulestle teniechantrecöroa naja que onochi netlöcatl? ");
INSERT INTO nhgNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Hua cuöc oquejtaque tli oyejyeya ca yejuatzi tli mochihuati, otieyelfejque: ―Tlöcatzintle, ¿ma tomagacö ca toespödas? ");
INSERT INTO nhgNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Hua sente de yejua conmacac itlatequepano de tlajtojcöteopexque. Pos quetejtequele inacas tli ca imöyecmö. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero onöhuatihuac Jesús, oquejtojque: ―Xejcöhuacö hasta necö. Hua oquemötocaque inacas de inu tlatequepano, hua opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Hua ompa huölöya para tieasesque Jesús inu jefes de teopexcötzetzi hua capetönte de inu guardia de teopantle, ca tiehua biebentzetzi. Hua Jesús oquemelfejque: ―¿Nenhualiejque ca espödas hua ca cuabetl quiename cana cuntra sente ichtejque? ");
INSERT INTO nhgNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mös neyeya cara tunale nemotlac ipan teopantle, pero amo onenniechaseque. Pero öxö yaja ini nönca nemoura, hua iura de ichecöhuales de inu moxicoöne tli ica pa tlajtlayohuaquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Hua tieaseque hua tiebicaque hasta ipa ichö tlajtojcöteopexque. Pero Piero tietocaya bejcateca. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Hua giente oquetlölejque tletzintle ipa pötio. Omotlölejque innochtie queyehualojque tletzintle. Entunses omotlöle nuyejque Piero intzölö yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Hua sente sohuatl tlatequepano oquejtac quiene yehuataya itlac tletzintle. Oquetejtieyejtac yaja, hua oquejto: ―Ini nönca nuyejque ca yaja oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero yaja oquenegöro. Oquejto: ―Sohuatl, amo nequixomate. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hua oc tepetzi sötiepa, oquejtac ocsente, hua oquejto: ―Taja nuyejque teca de yejua. Pero Piero oquejto: ―Tlöcatl, naja amo. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Hua sötiepa de quieme sie ura ocsente quejtoöya ca confiönsa: ―Melöhuac ini nönca tlöcatl nuyejque oyeya ca yaja, pues icaca de inu estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Hua Piero oquejto: ―Tlöcatl, amo necmate tli tequejtoa. Hua nima cuöc yaja oc tlajtlajtojtaya, inu canteliex otzajtzec. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yecuöquenu Tlöcatzintle onecuepaluc, hua oquejtaque Piero. Entunses Piero oquelnömec de inu tietlajtul Tlöcatzintle, quiene oquelfejque: “Antes tzajtzes canteliex, tequejtus yexpa que amo teniechixomate”. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Entunses oquis ca queyöhuac hua ochucac lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Hua inu tlöca tli tiepeaya Jesús moburlöroöya de yejuatzi hua tiebitequeya. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Hua tietlapachelfiöya tiexöyac. Entunses tietlajtlaniöya, tieyelfiöya: ―Xetiechyulepante, xetiechelfe öquenu ometzmacac. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hua tieyelfiöya meyac ocseque sösantle, hua tiepöpöcaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Hua cuöc ye omochi ca tunale, omosentlölejque biebentzetzi de puieblo ca tiehua jefes de teopexcötzetzi hua tlamachtiöneme de teotlajtule. Tiebicaque ipa injunta. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Oquejtojque: ―Tlö tecaca teCristo xetiechelfe. Pero yejuatzi oquemelfejque: ―Tlö nemiechelfis, amo nemoneltocasque. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Hua tlö naja nemiechtlajtlanis, amo nenniechnönquelisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Cache desde öxö naja que onochi netlöcatl neyehuatas ca tiemöyecmö Deus öque lalebes quepealo checöhualestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Hua oquejtojque innochtie: ―Entunses ¿taja teca tetieConietzi Deus? Quemelfejque: ―Nemejua nenquejtoa pos naja necaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Yecuöquenu yejua oquejtojque: ―¿Tli para cache tecneque öque tiechmelöjcöpubelis de tli oquejto ini tlöcatl? Pos sie tiejua ye otejcajque tli yaja mismo oquejto. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yecuöquenu omajcojque innochtie yejua, hua otiebicaque ica Pilöto. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Hua opiejque tietieyelfiöya. Oquejtojque: ―Ini nönca tlöcatl otecniextejque que quixniempolojteneme tonación. Amo quecöhua ma tecmacacö tocontrebuseyu ca César. Quejtoa nele yaja icaca Cristo, inu rey. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilöto otietlajtlane, oquejto: ―¿Taja terey de joriojte? Onöhuatihuac yejuatzi, oquejtojque: ―Icaca quiename taja tequejto. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Hua Pilöto oquemelfe inu jefes de teopexcötzetzi, hua inu giente tli tlamachyeya: ―Niontle tlajtlacule amo necniextea ica ini nönca tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Cache yejua quenelchibeliöya. Quejejtoöya: ―Quechihua chöchalönalestle pa puieblo, hua tlamachtea ipa noche tlöle de joriojte. Oquepiehualte desde Galilea hasta necö. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuöc oquecac Pilöto, otlajtla tlö inu tlöcatl oyeya de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Hua cuöc ocasojcömat que Jesús iloaya de inu tlöle tli ihuöxca inu Herodes, otietitla ica Herodes. Pos Herodes nuyejque ompa oyeya ipa Jerusalén ipa inu niecate tunalte. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hua Herodes, cuöc otieyejtac Jesús, opajpöc lalebes. Pos quepeaya meyac tiempo que quenequeya tieyejtas, ipampa oquecac tlimach de yejuatzi, hua quenequeya quejtas quiene ca quechihualo canajyetla tietzöbetl. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hua tietlajtlaniöya ca meyac tlajtule, cache yejuatzi amo tli nöhuatiloöya niontle. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hua ompa ijcataya inu jefes de teopexcötzetzi ca tiehua tlamachtiöneme de teotlajtule tietieyelfejtaya ica meyac nelchibelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hua Herodes ca tiehua isoltörojua möbeltiöya ca yejuatzi hua moburlörojque tieca. Tietlaquentejque ca tzotzomajtle lalebes cuöcualtzi quiename tli möquea reyes. Entunses Herodes ocsajpa otietitla ica Pilöto. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hua omochijque amigos Pilöto hua Herodes ipa inu niecaju tunale. Pos antes amo cuale mobicaya. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yecuöquenu Pilöto oquensentlöle inu jefes de teopexcötzetzi hua tlötlayecönque hua noche inu giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Oquemelfe: ―Nenniechtieijtetico ini nönca por tlöcatl que ixniempolojteneme puieblo. Xequejtacö que naja ye onequestloco nemixtla nemejua, hua amo necniexte niontle tlajtlacule ipa ini nönca tlöcatl de inu sösantle de tli nemejua ica nenquetieyelfea. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hua nimpor Herodes; pos yaja oquetitla necö ocsajpa. Hua xequejtacö que amo quechijteca niontle canajyetla sösantle para ma meque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ejqueu nejcastecörus hua nejcajcöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Cache innochtie giente tzajtzajtzeque juntos, oquejtojque: ―¡Ma meque ini nönca! hua: ―¡Xetiechmocajcöbelele inu Barrabás! ");
INSERT INTO nhgNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Yaja Barrabás oyeya sente prieso tli oquetzajtzajque ipan cörsel ipampa omajcoc cuntra cubierno ipa inu nieca ciudad, hua oyeya tlamectiöne. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Hua ocsajpa oquennunutz Pilöto, pos quenequeya tiecajcöhuas Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Cache yejua otzajtzajtzeque, oquejtojque: ―¡Xomocoruspelfe, xomocoruspelfe! ");
INSERT INTO nhgNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Hua yaja oquemelfe ocsajpa ca yexpa: ―¿Tlica? ¿Tli mal oquechi ini nönca? Niontle fölta tli quemeresieroa mequelestle amo necniexte ica yaja. Por inu sa nejcastecörus noso, hua nejcajcöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero yejua cache quenelchibeliöya tzajtzajtzeya, hua tlajtlaniöya ma tiecoruspelo. Hua intzajtzajtzeles quexexicojque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilöto oquejuscöro que ma mochihua tli yejua quetlajtlanque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Hua oquencajcöbele inu nieca tli oquetzajtzajque ipampa omajcoc cuntra cubierno hua porque oyeya tlamectiöne. Pos yejua ejqueu oquetlajtlanque. Pero Jesús otietiemöcte para ma tiechibelicö lo que tli quenejnequeya. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Hua otiebicaque ca queyöhuac. Ocaseque sente tlöcatl itucö Semu, de inu nación de Cirene, öque huölöya de ipa caltientle. Oquetlölejque ipa yaja inu corujtzi para ma quebica tiecuetlapa Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Hua tietocaya lalebes meyac giente de puieblo, hua meyactie sohuame. Tiechuqueliöya ca meyac chuquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Cache Jesús necuepaluc inca yejua, hua oquemelfejque: ―Sohuame de Jerusalén, amo xeniechchuquelicö naja, cache xechucacö por sie nemejua, hua por nemopejpelhua. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pues xequejtacö que huölösque tunalte que nenquejtusque: “Cuale imicnupel tli machurajte, hua tli ayec oquentlöcatelejque pelantzetzi, hua ayec quenchichetejque inpelhua”. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Yecuöquenu giente quemelfisque tepieme: “Topa xebetzecö”, hua quemelfisque muntes: “Xetiechtlapachucö”. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pues tlö giente quechihua sösantle ejqueyi petzotec ca naja, pues cache petzotec sösantle quechihuasque ca nemejua. Tlö quexutlaltea sente cuabetl tli xoxoctec, cache ca meyac arrasu quenxutlaltisque cuajme tli ye huöjque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Hua quenbicaya tieca yejuatzi oc unte tlöca ichtejque, para quenmejmectisque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Hua cuöc oaseco ipa sente locör itucö Mejcötzontecomatl, ompa tiecoruspelojque, ca tiehua inu ichtejque, sente ca tiemöyecmö, hua ocsente ca tiemöarrabis. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Hua Jesús oquejtojque: ―NoTajtzi, xequenmoperdonörfe, pues amo quemate tli quechijtecate. Hua quexiexelojque tietlaquie, hua queriförojque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hua meyac giente otlachixtaya. Nuyejque inu tlötlajtoönejme opajpöqueya tieca. Oquejtojque: ―Ocseque oquenmöquexte; ma momöquexte sie yaja, tlö yaja ini nönca tieCristo de Deus, öque yejuatzi quixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Nuyejque moburlöroöya de yejuatzi inu soltörojte. Tietlac mopachojque tieitejque penögre. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Quejtoöya: ―Tlö quejtus taja tecaca terey de joriojte, xomomöquexte sie taja. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hua oyeya icpac tiecorujtzi sente tucöyutl tlajcuelule ejqueyi: YAJA INI NÖNCA ICACA REY DE JORIOJTE. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Hua sente de inu ichtejque tli tömpelcataya tietlabejbicaltiöya. Quejtoöya: ―¿Amo taja tecaca teCristo? Xomomöquexte noso sie taja ca tiehua tejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Hua onöhuat inu ocsente, hua ocajajuac. Oquelfe: ―¿Nimpor amo tetiemabelea Deus, mös nuyejque taja metzcuntenörojque? ");
INSERT INTO nhgNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Hua tejua, melöhuac conbenierebe ma topa mochihua ini nönca, pues sa tecselejtecate totlaxtlöbil tli tecmeresieroa por tli otecchijque. Cache ini nöiloac amo tli oquechijque tli amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Hua otieyelfe: ―Jesús, xeniechmolnömequite cuöc tehualmobicas tomotlamandörfiqui. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yejuatzi oquelfejque: ―Melöhuac tli temetzelfea, que öxö teyes ca naja ipan Paraíso. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hua ye oyeya quieme ye pan tlajca. Omochi tlajtlayohuaquelestle ipa noche inu tlöle hasta ipa yeye ura, ");
INSERT INTO nhgNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","pues opole tunale. Hua inu cortina de ipa teopantle otzomu ca tlatlajco. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yecuöquenu Jesús otzajtzihuac ca checöhuac tlajtule, oquejtojque: ―NoTajtzi, temetzmotiemöctelea noyulo. Hua cuöc oquejtojque ini nönca, omecoac. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cuöc inu capetö oquejtac tli omochi, otiechamöhuaya Deus, hua oquejto: ―Melöhuac ini nönca oyeya yectec tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Hua noche inu giente tli onhuölajque oquejtaco ini nönca sösantle, cuöc oquejtaque tli omochi, omocuejque ica yulcocolestle. Momacataya ipa inpiecho. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Cache noche tli tieixomateya, hua inu sohuame tli otietocaque desde inu estado de Galilea, oyejyeya bejca oquejetztaya noche ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hua oyeya sente tlöcatl itucö Josie. Yaja oyeya miembro de inu grupo de tlötlajtoönejme de joriojte que itucö Sinedrio. Yaja oyeya cualtientlöcatl hua yectec. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Amo oyeya de acuierdo ca lo que tli quejtojque hua quechijque icompanierojua. Yaja oyeya de Arimatea, sente puieblo de joriojte, hua lalebes quenequeya ma tlamandörucö Deus. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Hua yaja omopacho itlac Pilöto quetlajtlaneto tiecuierpo Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hua oquetemobe. Oquequemelo ica sente telmajtle de lino, hua oquetlölito ijtec sente mejcöustutl tli tlapojtaya ipa sente tepetlatl. Ayemo öque quetlöliöya ompa. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Hua ye oyeya tunale de que öque mopreparörus, pues mustlateca iyes söbron tunale cuöc joriojte mosiebea. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hua inu sohuame tli ca yejuatzi ohuölajque desde pa estado de Galilea, oquetocaque Josie nuyejque, hua oquejtaque mejcöustutl, hua quiene oquetlölejque tiecuierpo Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hua omocuejque. Oquechejchijque especias hua pajtle tli ijnecueste. Hua mosiebejque ipan söbro san quiene ca momandöroöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ipa inun primiero tunale de semöna, cualcö, antes quisas tunale, ohuölajque inu sohuame cöne mejcöustutl. Quehualecaya inu pajtle ijnecueste tli yejua ye oquechejchijque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Hua oqueniextejque inu tietetu ye tlacaltechule oyeya de ipa pobielta de mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Hua ocalajque, pero amo oqueniextejque tiecuierpo de Tlöcatzintle Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hua omochi que cuöc yejua amo quemateya tli quepensörusque de ini nönca, sie trepiente omoquetzque intlac yejua unte tlöca ca intlaquie tzotzotlaca. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Hua yejua sohuame omomajtejque, hua omopiechojque. Hua tlöca oquemelfejque sohuame: ―¿Tlica nentietiemoa intzölö mimejque öque nemoa? ");
INSERT INTO nhgNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Amo oncö iloac necö, cache ye oyulebihuac. Xequelnömequecö de tli onemiechnunutzque cuöc oc iloaya ipan Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Pues oquejtojque que yejuatzi öque nechihualuc tlöcatl tieconbenieroöya ma tietiemöcticö inmöpa tlöca tlajtlaculteque, hua ma tiecoruspelucö, hua ma yulebihua ipa yeye tunale. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yecuöquenu yejua oquelnömejque de tietlajtul. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Hua omocuejque desde ipa mejcöustutl. Oquemelfejque de noche ini nönca sösantle ca inu majtlactle huansie tiemachtejcöhua, ca tiehua ocseque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Hua oyejyeya María Magdalena hua Juana, ca tiehua María inöntzi Jacobo. Hua tli ocseque tli oyejyeya ca yejua oquejtojque ini nönca inca tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Cache yejua quepensöroöya quieme cana lucojyutl inu tlajtule de yejua, hua amo oquenneltocaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Cache omajcoctequis Piero, hua omomerö hasta ipa mejcöustutl. Hua omocototztlöle para otlachix ca tlaijtec. Oquejtac sa yaja tzotzomajme ompa oyeya. Hua uya pa ichö. Pos quetietzöbejtaya tli omochi. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hua omochi ipa inun tunale que unte de yejua oyöya ipa sente puieblo que itucö Emaús, tli oyeya quiename once kilómetros de inu ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Otlajtlajtojtöya de noche ini sösantle tli omochi. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hua omochi que cuöc yejua otlajtlajtojtöya hua omonunutztöya, sie yejuatzi Jesús onepachuluc hua nejnemoöya ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero yejua amo tieixomatque, pos Deus amo quencöjque ma tieixomatecö. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Hua oquemelfejque: ―¿Tli sösantle nemonunutztecate nemejua mientras nennejnentebitze? Hua yejua sa ijcataya, niese motequepachoöya. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Onöhuat sente, öque itucö oyeya Cleofas. Otieyelfe: ―Pos noche giente quemate tli omochi ipa nöncate tunalte, mös cate estranjieros. ¿Taja amo tecmate? ");
INSERT INTO nhgNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yejuatzi oquemelfejque: ―¿Tli sösantle? Hua yejua otieyelfejque: ―Pos de Jesús de puieblo de Nazaret. Pos yejuatzi iloaya sente tlayulepante. Ca checöhualestle tlajtuloöya hua quechihualoöya sösantle bejbeye tieixpa Deus hua imixpa noche giente. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Hua inu jefes de toteopexcötzetzihua ca tiehua totlötlajtoönejua otietiemöctejque para tiecuntenörojque ma mecoa. Hua tiecoruspelojque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Cache tejua teccheaya que yejuatzi iloaya öque quenmöquextilusquea giente de Israel. Hua amo sa inu, pos öxö ye ica yeye tunale que ini nönca omochi. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Mös öxö seque sohuame de tejua otiechmajcömectejque. Pos yejua antes tlanieses uyajque cöne mejcöustutl, ");
INSERT INTO nhgNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","hua amo oqueniextejque tiecuierpo. Entunses ohuölajque hua oquejtojque nele oquejtaque öngeles, tli oquejtojque nele nemoa. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Hua uyajque seque de tejua ipa mejcöustutl, hua oqueniextejque quieme sohuame oquejtojque. Cache yejuatzi amo tieijtaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yecuöquenu yejuatzi oquemelfejque: ―¡Nentuntojte, hua nenyultepitzteque para que amo nemoneltoca de noche tli oquejtojque inu tlayulepantejque tli oquepojque tietlajtultzi Deus! ");
INSERT INTO nhgNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Pos conbenierebeya ma Cristo öque Deus quixpejpenque ma ipa mochihua ini nönca sösantle, hua ma calaque ipa tlaniextelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Hua oquepiehualtejque desde tli oquejcuelo Moisés, hua de noche tli oquejcuelojque inu tlayulepantejque, hua quenpanquexteliloöya de noche tli tlajcuelulpanca inu sösantle tli tlajtoöya de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Oajaxihuato ipa inu puieblo cöne yejua oyöya. Yejuatzi oquechijque quieme tlö quesequirusque biloas. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Cache yejua tiequetzque hua otieyelfejque: ―Xomocöhua ca tejua, ipampa ye yohuac, hua ye tlanteca tunale. Entunses ocalacoac para necöhualus ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hua omochi que cuöc onetlöliluc ca yejua para tlajtlacualus, ocönque pöntzi. Oqueteochijque, hua oquecocototzque, hua oquenmacaque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Yecuöquenu quiename omotlapo imixtelolo de yejua, pos ye otieixomatque. Cache yejuatzi opolebihuac de imixtla de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hua molfiöya: ―¿Tequelnömeque quiene tojtecopa pöqueya toyulo mientras tiechnunutzaloöya ipa ojtle, cuöc tiechesplicörfiloöya inu teotlajtule? ");
INSERT INTO nhgNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Hua omiejque ipa inu ura, hua omocuejque ica ciudad de Jerusalén. Ompa oquenniextejque inu majtlactle huansie tiemachtejcöhua. Pos ye omosentlölejque, hua ocseque nuyejque oyejyeya ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Yejua quejtoöya: ―Ica melöhuac que ye oyulebihuac Tlöcatzintle. Pos ye oneniextiluc ica Semu. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yecuöquenu inu unteme quepoaya de tli impa omochi pa ojtle, hua quiene tieixomatque cuöc oquecocototzque pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Hua mientras yejua quepoaya ini nönca sösantle, yejuatzi mismo onequetzaluc tlanepantla de yejua, hua oquemelfejque: ―Xomoyulsiebicö nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero yejua omomajtejque hua majmajcötlachixque. Oquepensörojque que beles quejtaya itunal mejque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yejuatzi oquemelfejque: ―¿Tlica nemomajtea? ¿Tlica ejqueu nenquepensöroa ipa nemoyulo? ");
INSERT INTO nhgNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xequejtacö nomöhua hua nocxehua, que sie naja necaca. Xeniechmötocacö, hua xequejtacö, que sente espíritu noso itunal mejque amo quepea nacatl hua memetetl, quieme nenquejta que naja necpea. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hua cuöc oquejtojque ini nönca, oquemejtetejque tiemöhua hua tieicxehua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Hua yejua cöso ayemo moneltocaya, por quemachelejque tönto meyac pajpöquelestle. Pos quetietzöbejtaque. Yejuatzi oquemelfejque: ―¿Nenquepea canajyetla tli mocuös? ");
INSERT INTO nhgNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yecuöquenu yejua otiemacaque sie peröso meche tli ye obecsec. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Hua yejuatzi ocönque hua ocualuc imixtla yejua. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Hua yejuatzi oquemelfejque: ―Yaja ini nönca tlajtule onemiechelfe cuöc oc neyeya ca nemejua, que quepeaya que mochihuas noche sösantle tli tlajcuelulpancate de naja ipa inu ley de Moisés, hua ipa inu ömame tli oquejcuelojque tlayulepantejque, hua ipa inu ömatl de Salmos. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Yecuöquenu oquentlapolfejque inasojcömateles para ma casojcömatecö lo que tli tlajcuelulpanca. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Oquemelfejque: ―Ejqueu tlajcuelulpanca, que inu Cristo öque Deus quixpejpenque quepeaya que quesufrirus tiecoco, hua que yulebes de intzölö mimejque ipa yeye tunale. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nuyejque quepea que monunutzas tietlajtul ca giente de noche naciones de tlöltecpactle, que ma moyulcuepacö para motlapojpolfis intlajtlacul. Ma piehua monunutzas desde Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Hua nemejua nencate nentestigos de ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Xequejtacö que naja necualtitlanes nemopa lo que tli oqueprometierojque noTajtzi. Xomocöhuacö necö noso, ipa ini nönca ciudad hasta senamo nemopa huölös inu checöhualestle tli yebitz de tlacpac. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Hua oquenquextejque ca queyöhuac de inu ciudad hasta que oyejyeya itlac puieblo de Betania. Entunses oquemajcoque tiemöhua hua oquenteochijque. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hua omochi que mientras oquenteochihualoöya, obiloac de yejua, hua otlejcoac ca elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Hua yejua tiemabesutiöya. Sötiepa omocuejque ica Jerusalén ca meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Seme mocöhuaya ipan teopantle, hua tieteochihuaya Deus.");
INSERT INTO nhgNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cuöc noche opie ye iloaya Tlajtule, hua yejuatzi Tlajtule iloaya ca Deus, hua yejuatzi Tlajtule iloaya Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yejuatzi oiloaya ca Deus desde cuöc opie noche sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Yejuatzi quechejchijque noche sösantle; hua sin yejuatzi amo omochihuane niontle de lo que tli omochejchi. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tieca yejuatzi oyeya nemelestle, hua ini nönca nemelestle oyeya tlöbile para tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Hua tlöbile tlaniextea ipa tlajtlayohuaquelestle; cache tlajtlayohuaquelestle abele oquexexico tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ohuöla sente tlöcatl que Deus ocualtitlanque. Itucö oyeya Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ini nönca ohuöla para iyes testigo para ma tlatestificöro de inu tlöbile, para que por itlajtul ma moneltocacö innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Yaja amo oyeya inu tlöbile, tlöcamo ohuöla para ma tlatestificöro de inu tlöbile. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Yejuatzi öque iloac tlöbile tli melöhuac, öque quentlaniextelilo noche tlöca, ohualiloaya ipa ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ipa tlöltecpactle oiloaya, hua yejuatzi oquechejchijque tlöltecpactle; pero tlöltecpactlöca amo tieixomatque. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ohualiloac ipa tli tiehuöxca, pero tli tiehuöxcahua amo tieselejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Cache innochtie öque tieselejque quenmacaque beletelestle para ma mochihuacö tiepelhua de Deus, quejtusneque noche tli moneltoca tietucöyupantzinco. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pos otlöcatque quiename tiepelhua. Ini intlöcateles amo oyeya de yestle, nimpor amo omochi por itlaeliebeles de tonacayo, nimpor porque tlöcatl oquenec, cache Deus oquenchihualtejque ma tlajtlöcatecö. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Hua yejuatzi Tlajtule nechihualuc tlöcatl, hua totzölö nemoac, hua otequejtaque tiecualniexteles. Hua tiecualniexteles oyeya quieme sa de sente Conietzi de Deus tieTajtzi. Tiechbiquelitz tiemeyac favur Deus hua lo que tlin melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Xohuö tlatestificöro de yejuatzi. Tzajtzec checöhuac hua oquejto: ―Yejuatzi nöiloac de öque nequejtoöya naja cuöc nequejto: “Öque biloatz sötiepa de naja, cache bieyetzintle iloac que naja; ipampa nemoaya cachto de naja”. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pos de noche tli quepealo otecselejque tejua tonochtie, hua tiechmacalo favur hua oc cache meyac favur. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Pos Moisés otiechmacac iley; cache tecpea favur hua tlin melöhuac por medio de Jesucristo. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Deus ayec yeca tieyejtac. TiesenteConietzi, öque iloac Deus, öque tieTajtzi lalebes tietlasojtlalo, yejuatzi otiechniextelejque tieTajtzi ca tejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yaja ini nönca lo que tli oquepu Xohuö. Joriojte de ciudad de Jerusalén oquentitlanque teopexcötzetzi hua levitas tli tequeteya ca yejua. Oquentitlanque para ma quetlajtlanicö Xohuö: ―¿Öquenu tecaca taja? ");
INSERT INTO nhgNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Hua yaja amo quenegöro, cache oquejto: ―Amo naja neCristo. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Hua oquetlajtlanejque: ―¿Tli noso? ¿Taja tecaca teElías? Oquejto: ―Amo necaca. ―¿Taja tecaca inu tlayulepante tli huölös? Onöhuat: ―Amo. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yecuöquenu oquelfejque: ―¿Öquenu noso taja? Xetiechelfe para tequenmelfisque öque tiechhualtitlanque. ¿Tli tequejtoa taja de taja mismo? ");
INSERT INTO nhgNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Oquejto: ―Naja necaca tli netzajtze ipa locör cöne nionöque chönte hua nequejtoa: “Xecmejmelöhuacö tieojfe Tlöcatzintle”. Pos ejqueu oquejto inu tlayulepante Isaías que naja necchihuasquea. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Hua yejua fariseos oquentitlanque ini nöncate tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Hua oquetlajtlanejque: ―¿Tlica noso tetlacuötiequea tlö amo taja tecaca teCristo, nimpor teElías, nimpor tetlayulepante tli huölös? ");
INSERT INTO nhgNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Hua Xohuö oquennönquele, oquejto: ―Naja netlacuötiequea ca ötzintle; cache nemonepantla de nemejua ye iloac öque nemejua amo nentieixomate. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yejuatzi iloac öque biloatz sötiepa de naja. Naja amo necmeresieroa nion para netiequextelis tiecacua. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ini nönca sösantle omochi itlac inu puieblo de Betania, ca nepa löro de ötlactle Jordán, cöne Xohuö tlacuötiequiöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ipa mustlateca Xohuö tieyejtac Jesús que hualiloöya ca itlac, hua oquejto: ―Xetieyejtacö tiecalnielojtzi Deus, öque quecuetlabiltisque para quequextisque tlajtlacule de tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ini nöiloac de öque onequejto: “Sötiepa de naja biloatz sie tlöcatl que cache bieyetzintle iloac que naja, pos nemoaya cachto de naja”. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Hua naja ayemo netieixomateya. Pero para ma tieixomatecö giente de Israel, ipampaju nehualtlacuötiequiöya ca ötzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Hua Xohuö nuyejque oquejto: ―Onetieyejtac Espíritu Sönto hualtemoac de elfecac quiename palumax hua onesiebiluc tiepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Hua naja ayemo netieixomateya, cache öque niechhualtitlanque ma netlacuötieque ca ötzintle, yejuatzi niechelfejque: “Ipa öque tetieyejtas temoas Espíritu Sönto hua ipa yejuatzi nesiebilus, yejuatzi tlacuötiequilus ca Espíritu Sönto”. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hua naja onetieyejtac, hua ye netlatestificörojteca que yejuatzi iloac tieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ipa mustlateca ocsajpa ijcataya Xohuö ca unte de imachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Hua cuöc tieyejtac Jesús que ca ompa nejnemoaya, oquejto: ―Xetieyejtacö tiecalnielojtzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Hua inu unte oquecajque lo que tli oquejto hua otietocaque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Hua cuöc nemacuc bielta Jesús hua oquenmejtaque quiene tietocaya, oquenmelfejque: ―¿Tli nenquetiemoa? Hua yejua oquejtojque: ―Rabbí―quejtusneque Maestro―. ¿Cöne tomochöntelea? ");
INSERT INTO nhgNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Oquenmelfejque: ―Xehuölöcö hua nenquejtasque. Ohuölajque entunses hua oquejtaque cöne chöntihuaya, hua omocöjque tieca inu tunale. Pues ye oyeya quieme pa nöbe ura ca ye yohuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés, icni Semu Piero, oyeya sente de inu niecate unteme tli oquecajque tli oquejto Xohuö hua otietocaque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ini nönca nima oqueniexte Semu icni, hua oquelfe: ―Ye otetieniextejque Mesías―quejtusneque Cristo noso Tlaixpejpentle de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Hua oquehualecac tieca Jesús. Hua cuöc oquejtaque Jesús, oquelfejque: ―Taja tecaca teSemu, iconie Xohuö. Taja motucöyu iyes Cefas ―quejtusneque Piero, noso Tietetu. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Hua pa mustlateca oquenejque biloas ca estado de Galilea. Oqueniextejque Felipe. Jesús oquelfejque: ―Xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pos Felipe oyeya de inu puieblo de Betsaida, cöne chajchönteya Andrés hua Piero. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Felipe oqueniextito Natanael, hua oquelfe: ―Otetieniextejque inu tlöcatl de öque oquejcuelo Moisés ipa iley hua de öque oquejcuelojque inu tlayulepantejque. Yejuatzi Jesús iconie Josie, de inu puieblo de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Hua oquelfe Natanael: ―¿Cuale quisas de Nazaret canajyetla tlin cuale? Oquenönquele Felipe: ―Xehuöla hua xequejtaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Hua Jesús oquejtaque Natanael que ohuölöya tietlac, hua oquejtojque de yaja: ―Xequejtacö, de melöhuac yaja ini nönca ica sente israelita que amo tlacajcayöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Otieyelfe Natanael: ―¿De cöne teniechmixomachele? Onöhuatihuac Jesús, hua oquelfejque: ―Antes que Felipe metznutzato, cuöc oteyeya itzintla icox cuabetl, temetzejtac. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Onöhuat Natanael, hua oquejto: ―NoTiemachtejcötzi, tejuatzi tetieConietzi Deus; tejuatzi terey de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Onöhuatihuac Jesús hua oquelfejque: ―Ipampa otemetzelfe que otemetzejtac itzintla icox cuabetl, ¿por inu tomoneltoca? Cache bejfeye sösantle tequejtas que ini. ");
INSERT INTO nhgNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Hua nuyejque oquelfejque: ―Melöhuac, melöhuac nemiechelfea: Nenquejtasque elfecac tlapojtas, hua nopa naja que onochi netlöcatl tlejcusque hua temusque tieöngeles Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Hua pa yeye tunale omochi nesohuajtiluyo ipa puieblo de Caná de estado de Galilea. Ompa oyeya tienönajtzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Nuyejque tietlalfejque Jesús ipa nesohuajtiluyo ca tiehua tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Hua cuöc otla vino, tienönajtzi de Jesús tieyelfe: ―Amo quepejpea vino. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Oquelfejque Jesús: ―¿Tli necpea ca tejuatzi, sohuatl? Ayemo yebitz noura. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Tienönajtzi oquemelfe tli tlaserbiroöya: ―Xecchihuacö noche tli yaja nemiechelfis. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Hua ompa oyejyeya checuasie öcume de teme, ipampa joriojte ipa inreligión quepeaya costumbre de quepajpöcasque cöso noche sösantle. Aqueya ijtec cara sente öcumetl möcuile noso checuasie butejte. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Oquemelfejque Jesús: ―Xequentiemiticö ini nöncate öcume ca ötzintle. Oquentiemitejque hasta que otienque. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hua yejuatzi oquemelfejque: ―Öxö xejquexticö, hua xecbicacö ca yaja tli encargödo de nönca yelfetl. Hua oquebicaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hua cuöc encargödo oquebelmat ötzintle tli ye omocuec vino, amo quemateya de cöne ohuöla, mös yejua tli tlaserbiroöya tli quequextejque ötzintle quimateya de cöne ohuöla. Yaja encargödo quetzajtzele montle. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Oquelfe: ―Noche tlöca quetlölea cachto tlin cuale vino, hua cuöc giente ye oijixfeque, yecuöquenu quetlölea tli amo bel cuale; cache taja tecmalfejteca tlin cuale vino hasta öxö. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ca ini tlachihualestle Jesús oquepiehualtejque ipa Caná de Galilea. Oquechijque tietzöbetl hua öquenmejtetejque tiechecöhuales. Hua tiemachtejcöhua omoneltocaque tieca. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Sötiepa de ini nönca yejuatzi obiloac ca Capernaum, ca tiehua tienönajtzi, hua tieicnihua, hua tiemachtejcöhua. Hua oijiloaya ompa quiesquete tunalte. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Hua ye miero mochihuas pöscua de joriojte. Hua obiloac Jesús ca Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hua oquenniextiluto ipan teopantle giente tli quennamacataya cucobejque, hua calnielojte, hua palumaxte, hua giente tli quepatlataya tomi yejyehuataya. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yejuatzi oquechejchijque sente checute ca lösojcucone, hua quentojtocaque de ipan teopantle ca tiehua incalnielojua hua incucobejua. Quensemanelejque intomi de tli tlajtlapatlataya, hua quencuiecuejque inmiesajua. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Hua inu giente tli quenajnamacataya palumaxte, oquenmelfejque: ―Xequejcuenicö de necö ini nöncate, hua amo xecchihuacö tiechöntzi noTajtzi quieme tlö oyene mercödo. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Yecuöquenu oquelnömejque tiemachtejcöhua que tlajcuelulpa oyeya: “Bel lalebes nechohuates por mochöntzi”. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Hua joriojte onöhuatque, hua otieyelfejque: ―¿Tli tietzöbetl tetiechejtetis quiename sieñas, siendo que tecchijteca ini sösantle? ");
INSERT INTO nhgNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Hua onöhuatihuac Jesús, oquenmelfejque: ―Xecxetunicö ini nönca teopantle hua pa yeye tunale ocsajpa necchejchihuas. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Cuöquenu oquejtojque joriojte: ―Ipa cuarenta y seis años omochejchi ini nönca teopantle. Hua taja ¿ipa yeye tunale tecchejchihuas? ");
INSERT INTO nhgNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Cache yejuatzi oquejtojque de inu teopantle que yaja tiecuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Hua ca inu, cuöc oyulebihuac de intzölö mimejque, tiemachtejcöhua oquelnömejque cuöc quejtojque ini nönca. Entunses omoneltocaque de lo que tli tlajcuelulpanca, hua omoneltocaque ica ini tlajtule tli Jesús oquejtojque. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Hua cuöc iloaya ipa Jerusalén ipa yelfetl de pöscua, meyactie omoneltocaque tietucöyupa ipampa oquejtaque sieñas de tietzöbetl tli quechihualoöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Cache yejuatzi Jesús amo quenpililoöya confiönsa de yejua, ipampa yejuatzi quemixomatiloöya innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Hua amo quenesesitöruroöya ma canajyeca tiepubele de tlöca, ipampa yejuatzi quematihuataya tli onca pa inyulo tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Hua oyeya sente tlöcatl fariseo itucö Nicodemo, tlajtoöne de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ini nönca ohuöla ca yohuale tieca Jesús hua otieyelfe: ―ToTiemachtejcötzi, tecmate que tejuatzi tehualmobicac de Deus para tomobetztas tomaestro. Pues abele öque quechihuas ini nönca sieñas de tietzöbetl tli tejuatzi tomochibelea, tlö amo iloasquea Deus ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Onöhuatihuac Jesús, hua oquelfejque: ―Melöhuac, melöhuac temetzelfea: Öque amo tlöcates ocsajpa, abele quejtas cöne Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tieyelfe Nicodemo: ―¿Quiene cuale tlöcates sente tlöcatl tli ye biebentzi? ¿Beles cuale calaques ocsajpa ijtecopa inöntzi, hua tlöcates? ");
INSERT INTO nhgNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nöhuatihuac Jesús: ―Melöhuac, melöhuac temetzelfea: Öque amo tlöcates de ötzintle hua de tie Espíritu de Deus, abele calaques cöne tlamandöruro Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lo que tli tlöcate de nacatl, nacatl ica; hua tli de *Espíritu de Deus tlöcate, *espíritu icaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo xectietzöbe que temetzelfe que nenquepea nentlöcatesque ocsajpa. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","*Yejyecatl de cöne beletes tlalpitza, hua tejcaque quiene ca isoloca ijcueyoca; cache nimpor amo tecmate de cöne yebitz, nimpor cöne iya. Ejqueu icaca öque tlöcate de *tieEspíritu de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Onöhuat Nicodemo, hua otieyelfe: ―¿Quiene cuale mochihuas ini? ");
INSERT INTO nhgNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Onöhuatihuac Jesús, hua oquelfejque: ―¿Taja tetlamachtiöne de Israel, hua amo tecasojcömate ini? ");
INSERT INTO nhgNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Melöhuac, melöhuac temetzelfea: Tli tecmate, inu tequejtoa, hua tli ye otequejtaque, inu tecpoa; hua amo nenqueselea totlajtul. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ye nemiechelfe sösantle de tlöltecpactle, hua amo nemoneltoca. ¿Quiene noso nemoneltocasque tlö nemiechelfis tlin de elfecac? ");
INSERT INTO nhgNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hua ayec yeca otlejcoc elfecac, tlöcamo naja que onehualtemuc de elfecac, naja öque onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hua quieme Moisés ocajcoc inu cuhuötl ipan locör cöne nionöque chönteya, para quenpajtis giente, ejqueu ijteca ma niechajcoquecö naja öque onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ejqueu mochihuas para que innochtie tli moneltocasque ma quepeacö nemelestle nochepa notech naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pos Deus lalebes quentlasojtlaque tlöltecpactlöca, hua por inu tiemacuc tiesente Conietzi, para que noche tli moneltoca ca yejuatzi, majcamo ixniempolebecö, tlöcamo ma quepeacö nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pues tieConietzi Deus amo tiehualtitlanuc ipan tlöltecpactle para ma quencuntenörucö tlöltecpactlöca, tlöcamo cache para tlöltecpactlöca ma momöquexticö por medio de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Öque moneltoca tieca yejuatzi, amo quecuntenöruro Deus; cache öque amo moneltoca, ye quecuntenorojque ipampa amo omoneltocac tietucoyupa tiesenteConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hua Deus quencuntenörusque por ini nönca: porque tlöbile que yaja machestlestle de Deus ohuöla ipan tlöltecpactle. Hua tlöltecpactlöca cache oquecualejtaque tlajtlayohuaquelestle que tlöbile. Cache quecualejtaque tlajlayohuaquelestle ipampa intlachihual amo cuale oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pos noche öque quechihua tli amo cuale, quetlajyelejta tlöbile hua amo yebitz ipa tlöbile, para majcamo niese que amo cuale itlachihual. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Cache öque quechihua tlin melöhuac yebitz pan tlöbile, para ma yecniese itlachihual que de melöhuac quechihua quieme Deus quenequihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sötiepa de ini nönca sösantle, obiloac Jesús ca tiemachtejcöhua ipa tlöle de Judea; hua ompa iloaya ca yejua, hua tlacuötiequiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Hua nuyejque Xohuö tlacuötiequiöya ipa inu puieblo de Enón itlac Salim, pos ompa oyeya meyac ötzintle. Hua ohuölöya giente, hua mocuötiequiöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pues cuöquenuju Xohuö ayemo tzajtzactaya ipan cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Hua omochi que imachtejcöhua de Xohuö mojolfejque ca sente joreyo de quiene öque mochepöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Hua ohuölajque ca Xohuö hua oquelfejque: ―ToTiemachtejcötzi, xomojtele öque iloaya mocatzinco ca nepa icuetlapa Jordán, hua de öque tomojtalfe, yejuatzi tlacuötiequilo hua meyactie bitze tieca. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Onöhuat Xohuö, hua oquejto: ―Abele sente tlöcatl queselis canajyetla, tlö amo quemacalo Deus de elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nemejua mismos cuale nenquemajmate tli onequejto: “Naja amo necaca neCristo öque Deus quixpejpenque, tlöcamo Deus oniechhualtitlanque cachto de yejuatzi”. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Öque mosohuajtea ca sisehuantu, yaja montle. Pero iamigo de montle, öque itlac icaca hua quetiencaque, quepea bieye pöquelestle ipampa quetiencaque montle. Ejqueu noso, öxö lalebes nepajpöque naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ijteca que yejuatzi cache bieyetzintle iloas, hua naja ayecmo neyes nebieye. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Öque de tlacpac biloatz, cache bieyetzintle iloac de innochtie. Öque icaca de tlöltecpactle de tlöltecpactle pertenesierebe, hua sösantle de tlöltecpactle quejtoa. Öque biloatz de elfecac cache bieyetzintle iloac de innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Hua lo que tli quejtaque hua lo que tli quecajque, yaja inu quejtulo. Hua cöso nionöque amo queselea lo que tli quejtulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Öque queselea lo que tli quejtulo, icaca testigo de que Deus iloac melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pos öque Deus tiehualtitlanuc, tlajtule de Deus quejtulo. Pos Deus tiemacalo tieEspíritu amo sa tepetzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Tajtle tietlasojtlalo tieConietzi, hua noche sösantle tietiemöcteliluc ipa tiemöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Öque moneltoca ca tieConietzi, quepea nemelestle nochepa. Cache öque amo tieneltoca tieConietzi, amo quepeas nemelestle, tlöcamo tiecualöneles Deus icaca ipa yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Inu fariseos oquecajque que Jesús quemeyaqueliloöya cache meyactie tiemachtejcöhua que Xohuö, hua cache meyactie quencuötiequeliloöya. Mös amo quencuötiequeliloöya Jesús, tlöcamo tiemachtejcöhua quencuötiequiöya. Cuöc Jesús oquematque de tli tlajtoöya inu fariseos, ");
INSERT INTO nhgNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","oquixoac de estado de Judea, hua obiloac ocsajpa ca estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Hua tieconbenieroöya para panoas ca estado de Samaria. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Entunses ohualiloac ipa sente puieblo de Samaria itucö Sicar, itlac inu peröso de tlöle tli Jacob oquemacac iconie Josie. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Hua ompa oyeya öpuso de Jacob. Jesús ye oseyabihuac ipampa ojtle, hua por inu onetlöliluc itienco öpuso. Hua ye oyeya quieme ca pan tlajca. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ohuöla sente sohuatl de Samaria para quequextis ötzintle. Hua Jesús oquelfejque: ―Xeniechmaca ma nötle. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pos tiemachtejcöhua ye onyajque ipan puieblo oquecoato tli quecuösque. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Hua inu sohuatl samaritana otieyelfe: ―Pues tejuatzi tejoreyo tomobetzteca. ¿Quiene noso teniechmotlajtlanelelea naja tli temitis? Pues naja necaca nesohuatl nesamaritana. Oquejto ejqueu ipampa joriojte amo moneque ca samaritanos. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Onöhuatihuac Jesús hua oquelfejque: ―Tlö tequixomatesquea tietlöocoles Deus, hua tecmatesquea oquenuju metzelfea: “Xeniechmaca ma nötle”, taja tetlajtlanesquiöya de yaja, hua yaja metzmacasquiöya ötzintle tli quetiemaca nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Sohuatl otieyelfe: ―Señor, amo tomopilea tli ica tomoquextelis, hua öpuso bejcatla. ¿De cöne, noso, tomopilea inu ötzintle tli quetiemaca nemelestle? ");
INSERT INTO nhgNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Cache tebieye tomomajtzinojteca que totöta Jacob? Pues yaja inu öque tiechmacac ini nönca öpuso, hua de itech oötlic yaja mismo, hua ipeljua, hua iyulcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Onöhuatihuac Jesús hua oquelfejque: ―Öque conis de ini nönca ötzintle, ocsajpa ömeques; ");
INSERT INTO nhgNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","cache öque conis ötzintle tli naja necmacas, ayecmo quiema ömeques. Cache ötzintle tli naja necmacas iyes ijtecopa yaja quieme sente ömieyale de ötzintle tli quistas para quetiemacas nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Entunses sohuatl otieyelfe: ―Señor, xeniechmomaquele inu ötzintle, para ma ayecmo nömeque, nimpor ma ayecmo nehuöla hasta necö nejquextiqui de ijtec puso. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesús oquelfejque: ―Xebeya, xecnutzate monömec hua xehuöla necö. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Onöhuat sohuatl, hua oquejto: ―Amo necpea nonömec. Quelfejque Jesús: ―Melöhuac tli tecualejto que amo tecpea monömec. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pues möcuiltie monömecua ye otequempex, hua tli öxö tecpexteca amo monömec. Ini nönca tli tecualejto icaca melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Otieyelfe sohuatl: ―Señor, niese ca nequejta tomobetzteca tetlayulepante. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Tobiebetcöhua tieteochihuaya Deus ipa nönca tepietl, hua nemejuantzetzi nemojtalfea nele ijteca que ipa Jerusalén öque tieteochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Oquelfejque Jesús: ―Sohuatl, xeniechneltoca, que yebitz ura, cuöc nimpor ipa ini tepietl, nimpor ipa Jerusalén amo nentieteochihuasque toTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Nemejua nentieteochihua öque amo nentieixomate; tejua tetieteochihua öque tetieixomate. Pues nemöquextelestle yebitz por joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cache yebitz ura, hua öxö ye oncönca, cuöc yejua tli tlateochihua de melöhuac tieteochihuasque toTajtzi ipa inyulo hua de melöhuac. Pues toTajtzi nuyejque quentiemulo giente ejqueu ma tieteochihuacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Deus iloac Espíritu, hua quiejquech tieteochihua conbenierebe ma tieteochihuacö *ipa inyulo hua de melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Otieyelfe sohuatl: ―Necmate nele Mesías huölös, öque mocuitis Cristo öque Deus quexpejpenque. Cuöc yaja huölös tiechpanquextelis noche sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Oquelfejque Jesús: ―Naja neca neCristo, naja tli nonunutzteca ca taja. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yecuöquenu ohuölajque tiemachtejcöhua, hua quetietzöbejque ipampa tlajtlajtulutaya ca sohuatl. Cache nionöque amo oquejto: “¿Tli tomotiemolea?” noso “¿Tlica tomonunujtzinoa ca inu sohuatl?” ");
INSERT INTO nhgNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yecuöquenu sohuatl oquecöjtie icu, hua uya ca pa puieblo, hua oquenmelfito niecate giente: ");
INSERT INTO nhgNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xehualmobicacö, xomojtelicö sente tlöcatl oniechelfejque noche tli onecchi. Amo machea cox beles yejuatzi iloac Cristo öque Deus quixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Yecuöquenu hualquistiejque de ipa inu puieblo, hua ohuölajque tietlac. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Mientras necö tiemachtejcöhua tietlötlajtiöya, tieyelfejque: ―ToTiemachtejcötzi, xomotlacualte. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Hua yejuatzi oquenmelfejque: ―Naja necpea sente tlacuale tli nejcua, tli nemejua amo nenquemate. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yecuöquenu tiemachtejcöhua entre yejua molfiöya: ―¿Quie beles canajyeca tiehualequele tlacuale? ");
INSERT INTO nhgNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Oquenmelfejque Jesús: ―Yaja ini notlacual: que ma necchihua tli tietlanequeles öque niechhualtitlanque, hua ma nictlame inu tequetl tli niechmacaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","¿Amo nenquejtoa nemejua nele oc polebe nöbe mietztle para cuöc öque tlacosechörus? Xequejtacö. Nemiechelfea nemejua: Xetlacheacö cuale ca caltienco que tlatuctle ye otlachecö para öque cuale quecuejcuis. Pos giente cate quiename tlatuctle hua tejua cuale tequenhualecasque para ma yecö tieca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Hua öque quecuejcuis ini cosecha quepeas itlaxtlöbil, hua quesentlölis para quepeas nemelestle nochepa. Hua ejqueu öque tlatuca hua öque tlacosechöroa ma pajpöquecö sa secne. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Pos necö tequejta que ica melöhuac quiene mojtoa: “Sente icaca öque tlatuca hua ocsente öque tlacosechöroa”. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naja onemiechtitla nentlacosechörusque cöne nemejua amo netejtequetque. Ocseque tejtequetque hua nemejua nenquepiejque para nentequetesque ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hua meyactie samaritanos de inu nieca puieblo omoneltocaque tieca yejuatzi ipampa itlajtul sohuatl, quiene oquenpubele: “Oniechelfejque noche tli onecchi”. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Entunses cuöc ohuölajque samaritanos tietlac tietlötlajtejque ma necöhualo ca yejua. Onecöhualuc ompa ume tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Hua meyactie ocseque omoneltocaque tieca por tietlajtul de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Hua oquelfiöya sohuatl: ―Ayecmo sa ca motlajtul toneltoca, tlöcamo sie tejua ye otetiecajque, hua ye tecmate que de melöhuac ini nöiloac tlamöquextiöne de tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Hua sötiepa de inu ume tunale, oquixoac de ompa, hua biloac ca estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pos sie yejuatzi Jesús oquejtojque que sente tlayulepante ipa ipuieblo amo öque ipa quejta. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Hua cuöc oaxihuaco pan Galilea, inu giente de Galilea tieselejque, ipampa oquejtaque noche sösantle tli oquechijque ipa ciudad de Jerusalén ipa inu tunale de yelfetl. Pues yejua nuyejque ompa oyejyeya ipa yelfetl. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ohualiloac ocsajpa ipa Caná de Galilea, cöne inu ötzintle oquecuejque vino. Hua oyeya ipa inu puieblo de Capernaum sente tlatequepano de rey. Iconie mococoöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ini nönca, cuöc oquecac que Jesús hualiloac de Judea para Galilea, ohuöla tietlac, hua tietlötlajtiöya ma biloa ichö, hua ma quepajticö iconie, ipampa ye oyeya para meques. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yecuöquenu oquelfejque Jesús: ―Nemejua de porsi amo nenqueneque nemoneltocasque tlö amo nenquejta sieñas de tietzöbetl hua bieye tlachihualestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Itlatequepano rey oquejto: ―Tlöcatzintle, xemaxetite nochö antes meques noconie. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Hua oquelfejque Jesús: ―Xebeya, moconie neme. Hua inu nieca tlöcatl omoneltocac ica tietlajtul tli Jesús oquelfejque, hua uya. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cuöc yaja ohualiehuaya itlatequepanojua oquenömequeto, hua quemachestejque que iconie neme. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Yecuöquenu yaja oquentlajtlane tlin ura opie omoyectlöle. Entunses oquelfejque: ―Iyöla pa sie ura oquecö totunealestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Yecuöquenu yaja ocasojcömat que omochi ipa nieca ura cuöc Jesús oquelfejque: “Moconie neme”. Omoneltocac yaja hua tli oyejyeya pa ichö nuyejque omoneltocaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ejqueu por segunda vez Jesús oquechijque sente sieñas de tietzöbetl, sötiepa de que ohualiloac de Judea ca pa Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Sötiepa de ini nönca sösantle, omochihuaya yelfetl de joriojte. Hua biloac Jesús ca ciudad de Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Hua pan Jerusalén cöne pobielta de calnielojte onca sente öpila tli mocuitea Betzata ca hebreo. Ini nönca quepea möcuile corredurte. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Ipa ini nöncate corredurte bejbetztotaya meyactie cocoxcötzetzi, ixcocoxcötzetzi, cucuxojtzetzi, hua cuajcuöhuöjque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Hua ompa oyeya sente tlöcatl tli ye quepeaya treinta y ocho años mococoöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Cuöc Jesús oquejtaque ini nönca betzteca, hua oquematque que ye quepeaya meyac xebetl mococoa, quetlajtlanejque: ―¿Tecneque tepajtes? ");
INSERT INTO nhgNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tienönquele cocoxque: ―Señor, amo onca sie tlöcatl ma niechcalaque ijtec öpila cuöc ötzintle moyöbe; cache mientras naja nebitz para necalaques ocsente antes que naseti ye otemuc. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Oquelfejque Jesús: ―Xemiehua, xecöna mopetl hua xenejneme. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Hua sa nima inu nieca tlöcatl opajtec, hua ucö ipetl, hua onejne. Hua oyeya söbro inu tunale, hua joriojte quepeaya costumbre que mosiebiöya pan söbro. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Yecuöquenu joriojte quelfiöya inu nieca öque opajtec: ―Söbro tecate. Amo mopermitiroa tecbicas mopetl. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Oquennönquele: ―Öque oniechpajte, sie yaja oniechelfe: “Xecöna mopetl hua xenejneme”. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yecuöquenu quetlajtlanejque: ―¿Öquenu inu tlöcatl tli ometzelfe: “Xecöna mopetl hua xenejneme”? ");
INSERT INTO nhgNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Hua yaja tli opajtec amo quemateya öquenu iloaya; pues Jesús onenencuaxeluluc ipampa meyactie giente oyejyeya ipa inu nieca locör. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Sötiepa Jesús oquenömejque ipa teopantle hua oquelfejque: ―Xequejta, ye otepajtec. Ayecmo xetlajtlaco, para majcamo metzase canajyetla cache petzotec. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Inu tlöcatl uya, hua oquenmacheste joriojte que yejuatzi Jesús öque quepajtejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pos inu joriojte tietepotztocaya Jesús, ipampa quechihualoöya ini nönca sösantle ipa söbro. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Hua Jesús oquennonquelejque: ―NoTajtzi hasta öxö oc tequetihua, hua naja nuyejque netequete. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yecuöquenu, noso, quenequeya joriojte tiemectisque, ipampa amo pa quejtaloöya inu tunale cuöc yejua mosiebiöya, hua cache quenequeya tiemectisque ipampa yejuatzi quejtojque que Deus iloac tieTajtzi, hua ejqueu onechihualoöya iguöl que Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yecuöquenu onöhuatihuac Jesús, hua oquenmelfejque: ―Melöhuac, melöhuac nemiechelfea: Naja, öque neca netieConietzi Tajtle, abele tli necchihuas sa naja mismo, tlöcamo necchihuas lo que tli nequejta que quechihualuteca noTajtzi. Pues noche tli yejuatzi quechihualo, inu nuyejque necchihua naja san quiene ca yejuatzi quechihualo. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Pues noTajtzi niechtlasojtlalo naja que neca netieConietzi, hua niechejtetilo noche sösantle tli yejuatzi quechihualo. Hua cache bejfeye tlachihualesme que ini nöncate niechejtetisque, para que ejqueu nemejua nenquetietzöbejtasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Porque noTajtzi quenyulebitilo mimejque, hua quenmacalo nemelestle, hua ejqueu nuyejque naja öque neca netieConietzi nectiemacas nemelestle ca öquenu necneques necmacas. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pos noTajtzi amo öque quejuscöruro, cache naja niechmacaque checöhualestle para ma nequenjuscöro noche tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ejqueu innochtie ma tieyectieniehuacö tieConietzi, san quiene tieyectieniehua noTajtzi. Öque amo niechyectieniehua naja, nuyejque amo tieyectieniehua noTajtzi öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Melöhuac, melöhuac nemiechelfea: Öque quecaque notlajtul, hua moneltoca ca yejuatzi öque niechhualtitlanque, quepea nemelestle nochepa. Hua amo öque quecuntenörus, cache ye oquis de ipa mequelestle hua ye quepea nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","’Melöhuac, melöhuac nemiechelfea: Huölös ura hua öxö oncönca, cuöc mimejque quecaquesque notlajtul de naja öque neca netieConietzi Deus. Hua innochtie tli quecaque, yejua nemesque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ejqueu quiename noTajtzi de porsi quepealo nemelestle, ejqueu nuyejque niechmacaque para que naja nuyejque de porsi necpeas nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Hua nuyejque niechmacaque checöhualestle para netlajuscörus ipampa onochi netlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo xectietzöbejtacö de ini nönca, pues huölös ura cuöc noche tli cate ijtec mejcöcoyocme quecaquesque notlajtul, ");
INSERT INTO nhgNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hua quisasque de ijtec mejcöcoyocme. Niecate tli oquechijque tlin cuale yulebesque hua quisasque para nemesque. Cache tli oquechijque tli amo cuale, yulebesque hua quisasque para mocuntenörusque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Abele necchihuas niontle sa naja mismo. Quiene nejcaque, ejqueu netlajuscöroa. Hua netlajuscöroa quiene conbenierebe ipampa amo nectiemoa necchihuas tli notlanequeles de naja, tlocamo ma necchihua tietlanequeles de öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Tlö naja netlajtusquiöne de naja mismo pues beles amo melöhuac uyesquea notlajtul. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Iloac ocsente tli tlajtulo de naja; hua necmate que tietlajtul tli quejtulo de naja icaca melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Nemejua nenquentitlanque tlöca ca Xohuö, hua yaja quenpubele tli melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Cache inu tlajtule tli naja necselea amo yaja itlajtul de sente tlöcatl. Pero nequejtoa ini nöncate sösantle para que ejqueu ma xomomöquexticö. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Xohuö oyeya quieme tlöbile tli xutlaya hua tlöbiöya. Hua nemejua nenquecualejtaque para nenpajpöjque sie röto ipa itlöbil. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Cache naja necpea sente testigo tli cache bieye que Xohuö. Pos inu tlachihualestle tli noTajtzi niechmacaque ma necchihua, pos sie yaja tlachihualestle tli necchihua tlajtoa de naja. Quejtoa que noTajtzi niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hua yejuatzi noTajtzi öque niechhualtitlanque, yejuatzi tlajtuluteca de naja. Hua nimpor ayec nentietiencajque nemejua nimpor ayec nentieijtaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nimpor amo nenquepea tietlajtultzi ipa nemoyulo; pues nemejua amo nemoneltoca noca naja öque yejuatzi niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nentlatiemoa ipa teotlajtule, ipampa nenquepensöroa que itech teotlajtule nenquepea nemelestle nochepa; hua amo nemomaca cuienta que inu teotlajtule tlajtoa de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Hua amo nenqueneque nenhuölösque notlac para nenquepeasque nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Chamöhualestle tli yebitz de tlöca amo necselea. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Cache naja nemiechixomate, que amo nenquepea tietlasojteles Deus ipa nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naja onehuöla de pörte de noTajtzi, hua amo nenniechselea. Tlö ocsente huölösquea de pörte de sie yaja, yaja inu nenqueselisquea nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Quiene noso cuale nemoneltocasque, tlö nenqueselea chamöhualestle tli nemomaca sente ca ocsente, hua amo nenquetiemoa chamöhualestle tli quetiemaca öque sa yejuatzi Deus iloac? ");
INSERT INTO nhgNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo xecpensörucö que naja nemiechtieyelfis tieixpa noTajtzi. Onca sente öque nemiechtieyelfea. Yaja Moisés, öque itech nenquepea confiönsa. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pos tlö nemejua nemoneltocane ica Moisés de melöhuac, nenniechneltocasquiöne naja; ipampa yaja otlajcuelo de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Hua tlö amo nemoneltoca ica tli yaja oquejcuelo, ¿quiene nemoneltocasque de tli naja nemiechelfea? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cuöc opanuc ini nönca sösantle, obiloac Jesús ca ocsie löro ötiescatl bieye de Galilea itucö Tiberias. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Hua tietocaya meyac giente ipampa quejtaya tietzöbeme tli yejuatzi quechihualoöya inca cocoxcotzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Hua otlejcoac Jesús ipa sente tepietl, hua netlöliluc ompa inca tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Hua ye miero asetaya tunale para pöscua, yaja yelfetl de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Hua cuöc Jesús oquejtaque que ohuölöya tieca lalebes meyactie, oquelfejque Felipe: ―¿Cöne tejcoasque pöntzi para ma tlacuöcö ini nöncate? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Cache ini nönca quejtuloöya para queprobörusque. Pos yejuatzi ye quematihuataya tli quechihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Felipe otieyelfe: ―Ume cientos denarios tomi de pöntzi amo axelis, para cara sesen tlöcatl quecuös tepetzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Otieyelfe sente tiemachtejque, yaja Andrés, icni Semu Piero: ");
INSERT INTO nhgNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Oncönca necö sente pelalactle quepea möcuile pöntzi de ceböda hua unte mimechte. Pero ini tlacuale para meyac giente amo axelis. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yecuöquenu Jesús oquejtojque: ―Xequenchihualticö giente ma motlölicö. Hua oyeya meyac xebetl niepa, hua omotlölejque quieme möcuile mil tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yecuöquenu ocönque Jesús inu niecaju pöntzi, hua cuöc ye tietlasojcömatelejque Deus, quenxiexelfejque giente tli ye motlölejtaya. Hua ejqueu nuyejque oquechijque ca mimechte, hua giente otlacuajque hasta cöne yejua ayecmo quenequeya. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Hua cuöc yejua ye oijixbeque Jesús oquenmelfejque tiemachtejcöhua: ―Xecuejcuecö tli ococotocac, majcamo tli niempolebe. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Entunses oquepejpenque, hua oquentiemitejque majtlactle huan ume chequejme ica pöntzi cojcotoctec de inu möcuile pöntzi de ceböda, tli oquixbecöjque cuöc ye otlacuajque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Yecuöquenu niecate tlöca, cuöc quejtaque inu nieca tietzöbetl tli Jesús oquechijque, quejtojque: ―Ini nönca de melöhuac icaca inu tlayulepante öque huölösquea ipa nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Cuöc casojcömatque Jesús que quenequeya huölösque para tieasesque, hua tiechihualtisque para iloas rey, ocsajpa obiloac ca ipa tepietl, yejuatzi tiesiel. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Hua cuöc ye yohuac, tiemachtejcöhua hualtemuque ca itlac ötiescatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Hua ocalajque ijtec börco hua iyösquiöya ca ocsie löro ötiescatl hasta ca pa puieblo de Capernaum. Hua ye tlajtlayohua oyeya, hua Jesús ayemo ohualiloaya inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hua majcoqueya ötzintle ipampa lalebes tlalpitzaya yejyecatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Hua cuöc ye onejnemeya börco quieme checuasie noso checume kilómetros, tieijtaque Jesús quiene hualnejnemoatöya ipa ötzintle, hua hualnepachulutöya itlac börco. Hua yejua omajcömejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Cache yejuatzi oquemelfejque: ―Naja necaca: amo xomomajticö. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yecuöquenu yejua oquenejque ma calacoa ipan börco. Hua sa nima oaseto börco ipan tlöle cöne yejua oyöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pa mustlateca inu giente tli oyejyeya ca nepa löro de inu ötiescatl oquejtaque que amo ompa oyejyeya ocseque börcöcucone, tlöcamo sa sente, hua nele Jesús amo calacoac ca tiemachtejcöhua ijtec börcö, tlöcamo sa tiemachtejcöhua onyajque insiesiel. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Cache ocseque börcös de puieblo de Tiberias ohuölajque cierca de inu locör cöne oquecuajque pöntzi sötiepa de cuöc Tlöcatzintle quemacaque tlasojcömatelestle ca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Entunses cuöc giente oquejtaque que Jesús amo ompa iloaya, nimpor tiemachtejcöhua, ocalajque yejua ijtec börcöcucone, hua onyajque ca Capernaum tiehualtiemojtöya Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Hua cuöc tieniextejque ca nepa löro de ötiescatl, tieyelfejque: ―ToTiemachtejcötzi, ¿quiema temaxitico necö? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Oquennönquelejque Jesús, hua oquejtojque: ―Melöhuac, melöhuac nemiechelfea, que tlö nenniechtiemoa, amo ica porque nenquejtaque inu tietzöbetl, tlöcamo ipampa nenquecuajque pöntzi hua nenyequijixbeque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amo xetequetecö por tlacuale tli sa tlame, cache xetequetecö por inu tlacuale tli ayec tlame hua tli quetiemaca nemelestle nochepa. Yaja naja öque onochi netlöcatl nemiechmacas de ini nönca tlacuale, pues noTajtzin Deus quecualejtalo ma necchihua inu. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Hua tieyelfejque: ―¿Tli tayesque para tecchihuasque inu tequetl tli Deus quecualejtalo? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Onöhuatihuac Jesús, hua oquemelfejque: ―Yaja ini nönca tequetl tli quecualejtalo Deus, que ma xomoneltocacö ca naja öque yejuatzi niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yecuöquenu tieyelfejque: ―¿Tli sösantle tomochibelis noso tli sieña de tietzöbetl tomochibelis para tequejtasque hua toneltocasque mocatzinco? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Tobiebetcöhua quecuajque inu pöntzi itucö maná ompa ipan locör cöne nionöque chönteya. Pues ejqueu tlajcuelulpanca: “Pöntzi de elfecac quenmacaque ma quecuöcö”. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Hua Jesús oquemelfejque: ―Melöhuac, melöhuac nemiechelfea: Amo Moisés nemiechmacac inu belaja pöntzi de elfecac cache noTajtzi nemiechmacalo inu belaja pöntzi de elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pos inu pöntzi de Deus, icaca tli hualtemuc de elfecac hua quennemitea tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Hua tieyelfejque: ―Tlöcatzintle, seme xetiechmomaquele ini nönca pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Hua Jesús oquemelfejque: ―Naja necaca neinu pöntzi tli quetiemaca nemelestle. Öque noca yebitz, ayec teosebes; hua öque noca moneltoca ayec ömeques. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Cache ye onemiechelfe, que mös ye nenniechejtaque, pero amo nemoneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Noche quiejquech niechmacalo noTajtzi huölösque notlac; hua öque beletes noca yebitz, ayec nectojtocas ca queyöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ipampa amo onehualtemuc de elfecac para necchihuas notlanequeles de naja, tlöcamo para necchihuas tietlanequeles de yejuatzi öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Hua yaja ini tietlanequeles de öque niechhualtitlanque, que de noche tli niechmacaque majcamo necpolo nion sente, tlöcamo cache ma nequenyulebite ipa inu sölúltimo tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pos yaja ini nönca tietlanequeles noTajtzi, que tlö canajyeca niechejtas naja que neca netieConietzi hua moneltocas ca naja, ma quepea inemeles nochepa. Hua naja necyulebitis ipan sölúltimo tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Cuöquenu joriojte moquejörojque hua otlajtojque tiecuntra de yejuatzi ipampa yejuatzi quejtojque: “Naja nepöntzi tli hualtemuc de elfecac”. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Hua yejua oquejtojque: ―¿Amo yaja ini nönca Jesús iconie Josie hua itajtzi hua inöntzi tejua tequemixomate? ¿Quiene noso quejtoa ini nönca: “Naja onehualtemuc de elfecac”? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Hua Jesús onöhuatihuac, hua oquemelfejque: ―Amo xetlajtucö ejqueu entre nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nionöque abele huölös noca naja, tlö amo queyulnutzasque noTajtzi öque niechhualtitlanque. Hua naja necyulebitis ipa sölúltimo tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Tlajcuelulpanca ipa libro de tlayulepantejque: “Hua noche inu giente Deus quenmachtisque”. Noche giente tli tiecaque noTajtzi hua quetzecoa de tli quenmachtilo, yejuanu bitze noca. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Amo quejtusneque que canajyeca tieyejtac noTajtzi, cache solamiente naja tli nebitz de Deus, naja quiema netieyejtac noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Melöhuac, melöhuac nemiechelfea: Öque moneltoca quepea nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Naja necaca nepöntzi tli quetiemaca nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nemobiebetcöhua oquecuajque inu maná ipan locör cöne nionöque chönte, pero sötiepa omejmejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Cache ini belaja pöntzi tli ohualtemuc de elfecac, tlö canajyeca quecuös de ini nönca pöntzi, amo meques. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Naja nepöntzi tli quetiemaca nemelestle que nehualtemuc de elfecac. Tlö canajyeca quecuös de ini nönca pöntzi, nemes nochepa. Hua pöntzi tli naja necmacas, yaja nonacayo, yaja ini nönca nectiemacas para ma quepeacö nemelestle tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Yecuöquenu joriojte mocöcamapanabiöya sente ca ocsente, hua oquejtojque: ―Ini nönca tlöcatl, ¿quiene noso tiechmacas inacayo ma tejcuöcö? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Por inu Jesús oquemelfejque: ―Melöhuac, melöhuac nemiechelfea: Tlö amo nenquecuösque nonacayo de naja que onochi netlöcatl, hua tlö amo nenconisque noyeso, amo nenquepea nemelestle ipa nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Öque quecua nonacayo hua cone noyeso, quepea nemelestle nochepa, hua naja necyulebitis ipa sölúltimo tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pues nonacayo ica melöhuac tlacuale, hua noyeso melöhuac ötlile. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Öque quecua nonacayo hua cone noyeso seme noca iyes, hua naja neyes ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","San quiene niechhualtitlanque noTajtzi öque nemoateca, hua naja neneme tiepampa noTajtzi, ejqueu nuyejque öque niechcua, yaja nuyejque nemes nopampa. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Yaja ini nönca belaja pöntzi tli hualtemuc de elfecac, que amo ica quiename inu maná tli oquecuajque nemobiebetcöhua hua omejmejque. Pues öque quecuös ini nönca belaja pöntzi nemes nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Noche ini nönca sösantle oquejtojque cuöc quenmachtiloöya giente ipan teopanconetzi ompa Capernaum. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Yecuöquenu meyactie de tiemachtejcöhua cuöc oquecajque ini nönca, oquejtojque: ―Lalebes checöjque cate ini nöncate tlajtulte. ¿Öquenu cuale queselis? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pero Jesús quematihuaya ipa tieyulo que tiemachtejcöhua moquejöroöya por tietlajtul, hua oquemelfejque: ―¿Quie beles ini nönca nemiechcualöntea? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Tli noso nenquepensörusque, tlö nenniechejtasque naja tli onochi netlöcatl netlejcus elfecac cöne cachto neyeya? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Solamiente yejuatzi Espíritu cuale quetiemacalo nemelestle; pues tonacayo amo tli proviecho quetiemaca. Notlajtulhua tli nemiechelfea yejua cate espirituales hua quetiemaca nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Cache oncate seque de nemejua tli amo nemoneltoca. Pues Jesús desde ca opie quematihuaya öquemeju amo moneltocaya hua öquenu tieantrecörusquea. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Hua oquejtojque: ―Ipampaju onemiechelfe que nionöque abele huölös ca naja, tlö amo quemacasque noTajtzi para ma iye ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Cuöc oquejtojque inu, meyactie de tiemachtejcöhua omocuejque, hua ayecmo yajtenemeya tieca. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yecuöquenu oquemelfejque Jesús inu majtlactle huan ume tiemachtejcöhua: ―¿Nemejua nenqueneque nuyejque nenyösque? ");
INSERT INTO nhgNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Otienönquele Semu Piero: ―Tlöcatzintle, tlö temetzmocöbelisque, ¿öque ica teyösque? Tejuatzi tomopilea tlajtule tli tiechmaca nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Hua tejua toneltocatebitze hua ye tecmate que tejuatzi tomobetzteca tetietlöcatl yectec de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Hua Jesús oquenönquelejque: ―Naja nemiechixpejpe nenmajtlactle huan ume, hua sente de nemejua ica diöblo. ");
INSERT INTO nhgNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Pues inu oquejtojque de Judas, iconie de Semu Iscariote. Ipampa Judas tieantrecörusquea, hua yaja oyeya sente de inu majtlactle huan ume. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sötiepa de ini nönca sösantle biloatenemeya Jesús ipa estado de Galilea. Pos amo quenequihuaya biloatenemes ipa estado de Judea, ipampa joriojte quenequeya tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Hua ye asetaya yelfetl de joriojte, inu yelfetl de cuajtlapame. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Hua otieyelfejque tieicnihua: ―Xebeya de necö, hua xebeya ipa Judea, para momachtejcöhua ma quejtacö tli tlachihuale tecchihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porque cuöc öque queneque ma giente quixomatecö yaja amo quechihua sösantle ichtecajtzi. Tlö melöhuac tecchihua ini nönca sösantle xecchihua inmixtla noche giente. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ejqueu tlajtoöya tieicnihua Cristo, ipampa yejua amo moneltocaya tieca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Por inu Jesús oquemelfejque: ―Noura para necchihuas ayemo hualase; cache para nemejua amo nemiechimportöroa quiema nenquechihuasque canajyetla. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Abele tlöltecpactlöca nemiechtlajyelejtasque nemejua. Pero naja niechtlajyelejta, ipampa naja netlatestificöroa de yejua, que intlachihual amo cuale icaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nemejua xeyöcö ipa ini nönca yelfetl. Naja amo neya ipa ini nönca yelfetl, ipampa ayemo hualase noura, ");
INSERT INTO nhgNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Hua cuöc oquemelfejque ini, necöhualuc ipan Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Cache cuöc ye uyajque tieicnihua ipa yelfetl, yecuöquenu nuyejque yejuatzi obiloac, amo ixmantete, tlöcamo quieme sa ichtecajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hua tietiemoöya joriojte ipa inu nieca yelfetl, hua quejtoöya: ―¿Cöne icaca inu nieca? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hua chajchalöneya giente por yejuatzi, pues seque quejtoöya: ―Cuale tlöcatl icaca. Hua ocseque quejtoöya: ―Amo, cache quencajcayöhua giente. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Cache nionöque amo tlajtlajtoöya ixmantete de yejuatzi, ipampa quenmabeliöya joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Hua cuöc tlajco yelfetl oyeya obiloac Jesús ipa inu teopantle bieye, hua tlamachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Hua quetietzöbejtaya joriojte. Quejtoöya: ―¿Quiene quemate ömatl ini nönca tlöcatl, hua ayec omomachte? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Oquennönquelejque Jesús, hua oquejtojque: ―Notlamachteles amo de naja icaca, tlöcamo de öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tlö canajyeca queneques quechihuas tietlanequeles Deus, quemates de tlö notlamachteles yebitz de Deus noso tlö naja netlajtlajtoa sa por nopörte de naja mismo. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Öque tlajtlatoa por pörte de yaja mismo, yaja quetiemoa ipropio chamöhuales; cache öque quetiemoa tiechamöhuales de yejuatzi öque oquehualtitlanque, ini nönca icaca melöhuac, hua ica intiero yectec. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisés nemiechmacac inu ley pero nionöque de nemejua amo quechihua cöso de inu ley. ¿Tli ipampa nenqueneque nenniechmectisque? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Onöhuatque giente, hua oquejtojque: ―Demuño tecpea. ¿Öquenu queneque metzmectis? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesús onöhuatihuac, hua oquemelfejque: ―Sente tlachihuale onecchi, hua nemonochtie nenquetietzöbejtaque por inu. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Melöhuac, Moisés nemiechelfe ma xomonacayutequecö (mös amo opie ca Moisés, tlöcamo cachto tobiebetcöhua omonacayutejque). Hua ipan söbro cuöc nele öque mosiebis, nemejua nenquenacayutejteque sente peltzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ejqueu nenquenacayuteque tlöcatl ipan söbro, porque nenqueneque nenquecumplirusque inu ley de Moisés, ¿tlica noso nencuajcualöne nemejua ca naja ipampa onecpajte sente tlöcatl ipan söbro para ma iye intiero cuale icuierpo? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amo xetlajuscörucö sa lo que tli pane niese, cache xetlajuscörucö ca yectelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yecuöquenu quejtoöya seque tli oyeya de ciudad de Jerusalén: ―¿Amo yaja ini nönca öque quetiemojtecate para quemectisque? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Hua xequejtacö tlajtlajtojteca ixmantete hua amo tli quelfea. ¿Quie beles tlötlajtoönejme ye ocasojcömatque de melöhuac, tlö yaja ini icaca Cristo öque Deus oquixpejpenque? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Cache ini tlöcatl, tecmate de cöne icaca; hua cuöc huölös Cristo öque Deus oquixpejpenque nionöque amo quemates de cöne yebitz. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yecuöquenu tzajtzihuaya Jesús cuöc tlamachtiloöya ipa teopantle bieye. Quejtuloöya: ―Naja nenniechixomate, hua nenquemate de cöne neca. Hua amo onehuöla por nopörte de naja mismo. Cache niechhualtitlanque öque melöhuac iloac, hua yejuatzi amo nentieixomate nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Naja netieixomate, ipampa de yejuatzi neca hua yejuatzi niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Por inu quenequeya tieasesque. Pero nionöque amo omöya tiepa, ipampa ayemo aseya tieura. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hua meyactie de inu giente omoneltocaque tieca hua quejtoöya: ―Tlö huölösquiöne ocsente que uyesquiöne Cristo, abele quechihuasquea cache bejbeye tietzöbeme, que tli quechihualo ini nönca tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Hua inu fariseos oquecajque quiene giente tlajtlajtoöya de yejuatzi; hua jefes de teopexcötzetzi hua fariseos oquentitlanque policías ma tieasecö. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Hua Jesús oquejtojque: ―Sa oc tepetzi oncö nemotlac neyes, hua sötiepa neyös tietlac öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nenniechtiemusque, hua amo nenniechniextisque. Hua cöne naja neyes, nemejua abele nenyösque. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yecuöquenu joriojte oquejtojque sente ca ocsente: ―¿Cöne iyös ini nönca para amo tecniextisque? ¿Beles iyös intzölö inu ocseque tli uyajque intzölö griegos, para quenmachtis griegos? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tli quejtusneque inu tlajtule tli oquejto: “Nenniechtiemusque, hua amo nenniechniextisque. Hua cöne naja neyes, nemejua abele nenyösque”? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Cache pa sölúltimo tunale, inu bieye tunale de yelfetl, Jesús onequetzaluc hua tzajtzihuac. Oquejtojque: ―Tlö canajyeca ömeque, ma huöla ca naja hua ma ötle. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Öque moneltoca ca naja, ipa mochihuas quieme quejtoa teotlajtule, que de ijtecopa quisasque quieme ötlacme de ötzintle tli quetiemaca nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Ini nönca oquejtojque de tieEspíritu de Deus, pues innochtie tli moneltocaque tieca Jesús tieselisquea tieEspíritu Deus. Pues ayemo hualiloöya Espíritu ipampa Jesús ayemo oqueselejque tietlaniexteles.) ");
INSERT INTO nhgNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yecuöquenu seque de inu meyactie giente tli oquecajque ini nönca tlajtule, quejtoöya: ―De melöhuac ini nönca ica inu tlayulepante tli huölösquea. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ocseque quejtoöya: ―Yaja ini nönca icaca Cristo öque Deus oquixpejpenque. Ocseque quejtoöya: ―Pos amo. ¿De Galilea huölös Cristo? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Amo quejtoa teotlajtule nele Cristo huölös de itech ixenöchpelhua rey David, hua de ipa Belén, de inu puieblo cöne nemeya David? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hua ca inu mocöcamapanabiöya giente tiepampa yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Seque de yejua quenequeya tieasesque; cache nionöque amo omöya tiepa yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Hua inu policías ohuölajque intlac jefes de teopexcötzetzi hua inca fariseos. Hua yejua oquenmelfejque: ―¿Tlica amo nenquehualecaque? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Policías onöhuatque: ―Ayec otlajtlajto ocsente tlöcatl quiename ini nönca tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yecuöquenu fariseos onöhuatque: ―¿Nuyejque nemejua nemiechcajcayö? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Beles nenquepensöroa que ye omoneltocaque ca yaja seque de tejua tli tetlötlayecönque hua tefariseos? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Cache ini nöncate giente que amo quemate inu ley hua moneltoca ca inu tlöcatl, yejua cate malditos. ");
INSERT INTO nhgNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Hua Nicodemo, öque antes uya tietlac Jesús, oyeya intzölo, pues yaja oyeya sente de inu fariseos. Yaja oquemelfe: ");
INSERT INTO nhgNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―¿Beles quejtoa toley que ica cuale ma tecjuscörucö sente tlöcatl, tlö amo cachto tejcaquesque tli quejtus inu tlöcatl, hua tecasojcömatesque tli yaja oquechi? ");
INSERT INTO nhgNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Onöhuatque hua oquelfejque: ―¿Beles taja nuyejque teca de Galilea para tetlajtlajtus de inu maniera? Xectlatiemole teotlajtule hua xequejta que de Galilea ayec yebitz sente tlayulepante.  ");
INSERT INTO nhgNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Hua onyajque innochtie ca inchajchö. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Hua Jesús obiloac ipa tepietl itucö los Olivos. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Hua ca ise cualcö ohualbiloac ipa teopantle bieye, hua meyac tlöca ohuölajque tietlac. Hua ompa onetlöliluc oquenmachtiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yecuöquenu tlamachtiöneme de teotlajtule hua fariseos tiehualequelejque sente sohuatl tli tlajtlaculchijtaya ca tlöcatl; hua oquetlölejque tlanepantla. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Otieyelfejque Jesús: ―Maestro, ini nönca sohuatl otecaseque miero cuöc tlajtlaculchijteca ca inu tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Hua ipa toley Moisés otiechnahuate ma tectecalticö öque quechihua ini nönca. Tejuatzi noso ¿tli tomojtalfea? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Cache ini nönca tieyelfiöya para tietanteörusque, para cuale tietieyelfisque. Cache Jesús onepiechuluc tlölpa, tlajcueluloöya ipan tlöle ica tiemajpel. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Hua cuöc yejua quenelchihuaya tietlajtlaniöya, onequetzaluc, hua oquemelfejque: ―Öque de nemejua amo quepea tlajtlacule, ma case tietetu hua ma quemuchele yaja cachto. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Hua ocsajpa onepiechuluc, hua tlajcueluloöya ipa tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Hua yejua cuöc oquecajque, opiejque oquequistajque ca sie sente; opiejque desde tli cache biebentzetzi hasta ca tli cache pelalacme. Hua onecöhualuc tieinsiel Jesús, hua sohuatl tli oyeya tlanepantla. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Hua cuöc nequetzaluc Jesús, oquelfejque: ―Sohuatl, ¿cöne cate niecate giente? ¿Nionöque amo metzcuntenöro? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Hua yaja oquejto: ―Nionöque, Tlöcatzintle. Yecuöquenu Jesús oquelfejque: ―Nimpor naja amo temetzcuntenöroa. Xebeya, hua desde öxö ayecmo xetlajtlaco. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Hua oquennunutzque Jesús pa ocsente tunale, hua oquejtojque: ―Naja necaca netlöbile de tlöltecpactlöca. Öque niechtoca, ayec nejnemes ipa tlayohuaquelestle, cache quepeas tlöbile tli quetiemaca nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yecuöquenu fariseos otieyelfejque: ―Taja tetlatestificöroa de taja mismo; lo que tli taja tequejtoa amo melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Onöhuatihuac Jesús, hua oquemelfejque: ―Mös naja netlatestificöroa de naja mismo, pero lo que tli nequejtoa icaca melöhuac, ipampa necmate de cöne onehuöla hua cöne neya. Cache nemejua amo nenquemate de cöne nebitz, nimpor cöne neya. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Nemejua nentlajuscöroa san quiene ca pane niese; cache naja amo öque necjuscöroa. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero tlö naja netlajuscörus, netlajuscörus quiene melöhuac ica. Ipampa amo necaca nosiel, tlöcamo tecate sa secne naja hua noTajtzi öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Hua ipa nemoley tlajcuelulpanca que cuöc ume tlöca tlatestificöroa intlamelöjcöpoales icaca melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Naja neca sente tli netlatestificöroa de naja mismo, hua yejuatzi noTajtzi öque niechhualtitlanque nuyejque tlatestificöruro de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Hua tieyelfejque: ―¿Cöne icaca motajtzi? Onöhuatihuac Jesús: ―Amo nenniechixomate naja, nimpor noTajtzi amo nentieixomate. Tlö nenniechixomatesquea naja, nuyejque noTajtzi nentieixomatesquea. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ini nönca tlajtule oquejtojque Jesús cuöc tlamachtiloöya ipa teopantle bieye ipa inu nieca locör cöne giente oquetlöliöya tomi. Hua amo öque otieasec, ipampa ayemo aseya tieura. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Hua ocsajpa oquemelfejque Jesús: ―Naja neyös, hua nenniechtiemusque, cache ipa nemotlajtlacul nenmejmequesque. Cöne naja neya, nemejua abele nenyösque. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Por inu quejtoöya joriojte: ―¿Beles momectis yaja? Pues quejtoa: “Cöne naja neya, nemejua abele nenyösque”. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Hua quemelfiloöya: ―Nemejua nencate de tlölpa; naja necaca de tlacpac. Nemejua nencate de ini nönca tlöltecpactle; naja amo neca de ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Por inu onemiechelfe que nenmejmequesque ipa nemotlajtlacul; ipampa tlö amo nemoneltocasque que naja necaca, nemejua ipa nemotlajtlacul nenmejmequesque. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Entunses tieyelfejque: ―¿Taja öquenu teca? Ejqueu noso Jesús oquemelfejque: ―Naja neca san quiene ca ye onemiechelfe desde cuöc onepie. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Meyac sösantle necpea para nemiechelfis de nemejua mismo hua necpea que nemiechjuscörus. Pos yejuatzi öque niechhualtitlanque iloac melöhuac, hua lo que tli naja onejcac de yejuatzi yaja inu nequenpubelea tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Cache yejua joriojte amo casojcömatque que yejuatzi quennunutzaloöya de tieTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Entunses oquemelfejque Jesús: ―Cuöc niechajcoquesque naja, öque onochi netlöcatl, yecuöquenu nencasojcömatesque que *naja necaca. Hua amo yetla necchihua por nopörte de naja mismo; cache lo que tli noTajtzi niechmachtilo, yaja inu nequejtoa. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Hua yejuatzi öque niechhualtitlanque noca iloac. Amo sa nosiel niechcöhualo, ipampa lo que tli yejuatzi quecualejtalo yaja inu seme necchihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Hua cuöc Jesús quejtuloöya ini nönca sösantle, meyactie omoneltocaque tieca. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Hua inu joriojte tli moneltocaque tieca Jesús quemelfiloöya ejqueyi: ―Tlö nemejua nenquesequirojtasque ipa notlajtul, nenyesque de melöhuac nomachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Hua nenquixomatesque tli melöhuac, hua inu tli melöhuac nemiechlibrörus para ayecmo nenyesque nenesclavos. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tienönquelejque: ―Teipeljua de Abraham tecate tejua, hua ayec tecate teiesclavos de nionöque canajyeca. ¿Quiene noso tomojtalfea tejuatzi que tochihuasque telibres? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesús quennönquelejque: ―Melöhuac, melöhuac nemiechelfea, que noche tli tlajtlacoa mochihua esclavo de tlajtlacule. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Hua sente esclavo amo mocöhuas ipan chöntle nochepa, pero iconie de chöne mocöhuas nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hua ejqueu, tlö tieConietzi Deus nemiechlibrörus, nenlibres nenyesque de melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Necmate que nemejua nencate nenipeljua de Abraham, cache nenqueneque nenniechmectisque, ipampa notlajtul amo quepea locör ipa nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naja nequejtoa lo que tli onequejtac tietlac noTajtzi; hua nemejua por nemopörte nenquechihua lo que tli onenquecajque de itlac nemotöta. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Onöhuatque hua otieyelfejque: ―Totajtzi icaca yaja Abraham. Oquemelfejque Jesús: ―Tlö nenyejyene de melöhuac nenipeljua Abraham, itlachihual Abraham nenquechihuasquea. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Cache öxö nenqueneque nenniechmectisque naja tli onemiechpubele tlin melöhuac, tli onejcac de Deus. Amo ejqueu oquechi Abraham. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nemejua nenquechihua itlachihual de ocsente nemotöta. Yecuöquenu tieyelfejque: ―Tejua amo teichtecaconieme; tejua sa sie Tajtli tetiepea, yejuatzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yecuöquenu Jesús oquemelfejque: ―Tlö nemotajtzi iloasquiöne Deus, melöhuac nenniechtlasojtlasquiöne; pues naja de Deus onehualquis, hua onehuöla. Hua amo onehuöla por nopörte de naja mismo, cache yejuatzi niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Tlica amo nencasojcömate tli nequejtoa? Ipampa abele nenqueyejcaque notlajtul. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Nemejua inu Diöblo icaca nemotöta, hua lo que tli queliebea nemotöta yaja inu nenqueneque nenquechihuasque. Yaja omochi mequestiero desde ca opie, hua amo quechijtebitz tlin melöhuac, ipampa amo onca tlin melöhuac ica yaja. Istlacatlajtoa, porque ejqueu ica de porsi. Pues yaja icaca istlacatque, hua tajtle de niecate tli istlacatlajtoa. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Pero naja nequejtoa tlin melöhuac, hua por inu amo nemoneltoca ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Öquenu de nemejua queniextis tlajtlacule notech? Entunses tlö nequejtoa tlin melöhuac, ¿tlica noso amo nemoneltoca ca naja? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Öque ica de Deus, tietlajtultzi Deus quecaque. Por inu amo nenquecaque nemejua, ipampa amo nencate de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yecuöquenu onöhuatque joriojte, hua otieyelfejque: ―¿Amo tiel tequejtoa tejua, que taja tecaca tesamaritano hua tecpea demunio? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Onöhuatihuac Jesús: ―Naja amo necpea demunio, tlöcamo pa netieyejta noTajtzi. Hua nemejua amo pa nenniechejta. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Amo nectiemoa quiene necpeas chamöhualestle. Onca öque niechtiemolilo chamöhualestle, hua yejuatzi iloac öque tlajuscöruro. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Melöhuac, melöhuac nemiechelfea, öque queneltoca notlajtul, ayec meques. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yecuöquenu joriojte tieyelfejque: ―Öxö melöhuac ye tecmate que taja tecpea demunio. Abraham omec hua nuyejque omejmejque tlayulepantejque, hua taja tequejtoa: “Öque queneltoca notlajtul, ayec meques”. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Cache tebieye tomomajteca que totöta Abraham, öque nuyejque omec? Hua inu tlayulepantejque omejmejque. ¿Öquenu tecpensöroa que taja tecaca? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Onöhuatihuac Jesús: ―Tlö naja nochamöhuas naja mismo, nochamöhuales amo balierebe. Cache öque niechchamöhualo yejuatzi noTajtzi, öque nemejua nenquejtoa que nele iloac nemoDeus. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Hua amo nentieixomate. Cache naja netieixomate. Hua tlö nequejtusquiöne que amo netieixomate, neyene quieme nemejua neistlacatene. Pero netieixomate hua necneltoca tietlajtultzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abraham nemotajtzi opajpöc cuöc oquepensöro de que naja nehuölös. Hua oquejtac tunale cuöc nehuöla hua oquepex meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ejqueu noso otieyelfejque joriojte: ―Nimpor ayemo tecpea cincuenta años, hua ¿beles ye otequejtac Abraham? ");
INSERT INTO nhgNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Oquemelfejque Jesús: ―Melöhuac, melöhuac nemiechelfea: Antes que tlöcatene Abraham *naja ye necaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yecuöquenu joriojte ocönque teme para tietecaltisque Jesús, porque quejtuloöya que iloac Deus. Cache onejyönaluc, hua oquixoac de ipan teopantle. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Hua cuöc opanoac Jesús ca sie locör, oquejtaque sente tlöcatl que oyeya ixcocoxque desde cuöc otlöcat. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Hua tiemachtejcöhua tietlajtlanejque, oquejtojque: ―ToTiemachtejcötzi, ¿öquenu otlajtlaco, ini nönca noso yejua itötajua, para otlöcat ixcocoxque? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Onöhuatihuac Jesús: ―Nimpor ini amo otlajtlaco, nimpor itötajua. Cache omochi ini para ma moniexte tietlachihual Deus itech yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Combenierebe ma tecchihuacö tli tietlachihual de yejuatzi öque niechhualtitlanque, mientras oc tlaniese. Ompabitz yohuale, cuöc nionöque abele tli ayes. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mientras oncö neca ipa ini tlöltecpactle, netlöbile necaca para ca tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cuöc oquejtojque ini, ochejchaluc tlölpa. Oquechejchijque soquetl ca tiechejchal, hua oquetlölelejque ipa ixtelolojua inu ixcocoxque. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Hua oquelfejque: ―Xebeya, xomoxömite ijtec xabie de Siloé. ―Siloé quejtusneque, Tlatitlantle. Yecuöquenu uya inu ixcocoxque, hua omoxöme, hua cuöc hualmocuec ye hualtlajtlachixtöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yecuöquenu tli icaltech chajchönteya, hua tli ca ye niepa oquejtaque quiene motlajtlaijtlaniöya, quejtoöya: ―¿Amo yaja ini öque motlajtlaijtlaniöya? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Seque quejtoöya: ―Yaja icaca. Hua ocseque: ―Amo. Sabele yaja. Yaja quejtoöya: ―Naja necaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Hua oquelfejque: ―Entunses ¿quiene otetlachix? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Onöhuat yaja hua oquejto: ―Inu tlöcatl öque tietucö Jesús, oquechejchijque soquetl, hua oquetlölejque ipa nixtelolojua, hua oniechelfejque: “Xebeya ipa Siloé, hua xomoxöme”. Hua oneya, hua onoxöme, hua onecasec notlacheales. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yecuöquenu oquelfejque: ―¿Cöne ica inu nieca? Yaja oquejto: ―Amo necmate. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Oquebicaque intlac fariseos inu tlöcatl tli ca ye niepa oyeya ixcocoxque. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Hua oyeya ipa söbro cuöc Jesús oquechejchijque soquetl, hua oquetlachealtejque. Pues joriojte seme mosiebea ipa söbro. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Oquetlajtlanejque nuyejque fariseos quiene ocasec itlacheales. Hua yaja oquemelfe: ―Oniechtlölelejque soquetl ipa nixtelolojua, hua onoxöme, hua ye netlachea. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yecuöquenu seque de inu fariseos oquejtojque: ―Ini nönca Jesús amo de Deus, ipampa amo quemalfea söbro. Cache ocseque quejtoöya: ―Pero sente tlöcatl tlajtlacultec ¿quiene cuale quechihuas tietzöbetl quiename ini? Hua amo oyejyeya de acuierdo yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ocsajpa oquelfejque inu ixcocoxque: ―¿Taja, tli tequejtoa de inu nieca öque metztlachealte? Yaja oquejto: ―Pues iloac tlayulepante. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Cache joriojte amo moneltocaya de yaja, quiene oyeya ixcocoxque, hua quiene ocasec itlacheales, hasta senamo oquennutzque itötajua ");
INSERT INTO nhgNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","hua oquentlajtlanejque, oquemelfejque: ―¿Yaja ini nönca nemoconie, öque nemejua nenquejtoa otlöcat ixcocoxque? ¿Quiene, noso, ye tlachea öxö? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Onöhuatque itötajua hua oquejtojque: ―Tejua tecmate yaja ini nönca toconie, hua quiema otlöcat ixcocoxque. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Cache quiene öxö ye tlachea, amo tecmate; noso öquenu oquetlachealte, tejua amo tecmate. Yaja ye tlöcatl icaca; xomotlajtlanelicö yaja ma quejto. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ini nönca oquejtojque itötajua, ipampa quenmabeliöya joriojte. Pues joriojte ye omotlölejque de acuierdo que tlö canajyeca quejtus que Jesús iloac Cristo öque Deus tieixpejpenque, ma quisa para que ayecmo ma calaque ipan teopanme hua ma ayecmo quepea pörte ca icompanierojua. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Por inu oquejtojque itötajua: “Ye tlöcatl icaca; xomotlajtlanelicö yaja”. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Hua ca inu, ocsajpa oquenutzque inu tlöcatl tli ixcocoxque oyeya. Oquelfejque: ―Sa Deus xetiemochamöbele. Pues tejua tecmate que nieca tlöcatl icaca tlajtlacultec lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Yecuöquenu yaja onöhuat, hua oquejto: ―Tlö lalebes tlajtlacultec, amo necmate. Pos sa ini necmate, que naja neyeya neixcocoxque, hua öxö ye netlachea. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Hua ocsajpa oquelfejque: ―¿Tli metzchibele? ¿Quiene metztlachealte? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Oquennönquele: ―Ye onemiechmolfele, hua amo nemocaquitea. ¿Tlica ocsajpa nemonequitea ma nemiechmolfele? ¿Nemonequitea nuyejque nemejuantzetzi nemobetztasque nentiemachtejcöhua de yejuatzi? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Hua ocajajuaque, hua oquejtojque: ―Taja tecaca temachtejque de yaja; cache tejua teimachtejcöhua de Moisés tecate. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tejua tecmate que oquenunutzque Deus Moisés; cache ini nönca amo tecmate de cöne icaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Onöhuat inu nieca tlöcatl, hua oquemelfe: ―Melöhuac, naja nectietzöbejta ipampa nemejuantzetzi amo nemomachitea de cöne iloac ini nönca tlöcatl, hua yejuatzi oniechtlachealtejque naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Hua tecmate que Deus amo quencaquihua tlin tlajtlaculteque. Cache tlö canajyeca tiemabelea Deus, hua quechihua tli tietlanequeles, inun quiema quecaquihua yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde cuöc opie tlöltecpactle ayec omocac que canajyeca oquetlachealte sente tlöcatl tli otlöcat ixcocoxque. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tlö ini nönca tlöcatl amo iloasquiöne de Deus, abele tli ayihuasquea. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Oquenönquelejque, hua oquelfejque: ―Ipan tlajtlacule de atiro otetlöcat, ¿hua taja tetiechmachtis tejua? Yecuöquenu oquetojtocaque para ayecmo quiema iyös ipa teopanme. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Oquecajque Jesús quiene oquetojtocaque; hua oqueniextejque. Oquelfejque: ―¿Tomoneltoca taja tieca öque omochi tlöcatl? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Hua onöhuat yaja, oquejto: ―Pos ¿öquenu yejuatzi, Tlöcatzintle, para noneltocas ca yejuatzi? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Oquelfejque Jesús: ―Taja ye otequejtac, pues naja öque netlajtlajtojteca ca taja, naja necaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Hua yaja oquejto: ―Noneltoca, noTlöcatzintle. Hua tieteochi. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Hua oquejtojque Jesús: ―Naja para netlajuscörus onehuöla ipa ini tlöltecpactle: para que niecate tli amo tlajtlachea, ma tlacheacö; hua tlin tlajtlachea ma ixcocoxcöteacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Hua seque de inu fariseos tli oyejyeya ca yejuatzi oquecajque ini nönca, hua otieyelfejque: ―¿Belis tequejtus que tejua nuyejque tecate teixcocoxcötzetzi? ");
INSERT INTO nhgNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Oquenmelfejque Jesús: ―Tlö melöhuac nenixcocoxcötzetzi nenyene ipa nemoyulo, amo nenquepeasquiöne tlajtlacule. Cache öxö ica quiename nenquejtoa, pos nentlajtlachea. Pos por inu nemopanca nemotlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Melöhuac, melöhuac nemiechelfea: Öque amo calaque ca pan trönca de corröl de calnielojte tlöcamo mocalactea ca ocsie löro, ini nönca tlachteque hua de porsi ichtejque icaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Cache öque calaque ca pa trönca, yaja ini ica calnielojpexque de inu calnielojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tlajpexque quetlaijtlapolfea para calaques calnielojpexque, hua calnielojte quetiencaque. Hua icalnielojua quentzajtzelea quiene ca intojtucö hua quenquextea. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hua cuöc ye oquenquexte ca queyöhuac noche tli ihuöxca, yaja quenyecöna hua calnielojte quetoca, ipampa calnielojte quixomate calnielojpexque cuöc yaja tzajtze. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero öque amo quixomate yejua amo quetoca, cache chucholoa cuöc tzajtze, ipampa amo quejixomate. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yaja ini nönca ejiemplo oquepujque Jesús. Cache yejua amo casojcömatque tlica ejqueu oquemelfiloöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ejqueu noso Jesús ocsajpa oquemelfejque: ―Melöhuac, melöhuac nemiechelfea: Naja necaca netrönca de calnielojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Noche tli cachto de naja ohuölajque, ichtejque cate; cache calnielojte amo oquentiencajque. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Naja netrönca. Öque por naja calaques, momöquextis; calaques hua quisas hua queniextis tlacuale. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ichtejque amo yebitz tlöcamo para tlachteques hua para tlamectis hua tlaniempolus. Naja onehuöla para ma quepeacö nemelestle, inu nemelestle tli bel lalebes cuale ica. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naja necuale necalnielojpexque. Sente cuale calnielojpexque quetiemaca inemeles por impampa calnielojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Cache öque sa tequetque, tli amo icaca calnielojpexque, hua amo ihuöxcahua inu calnielojte, cuöc yaja quejta yebitz coyutl, quencajcöhua calnielojte, hua choloa. Hua coyutl quemajase hua quencuaxieloa calnielojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ejqueu choloa tequetque ipampa sa tequetque icaca, hua amo de melöhuac quentlachilea calnielojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Naja necuale necalnielojpexque. Hua nequemixomate nocalnielojua, hua tli nohuöxcahua niechixomate. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","NoTajtzi niechixomatihua, hua ejqueu nuyejque naja netieixomate noTajtzi. Hua nectiemaca nonemeles por impampa nocalnielojua. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nuyejque nequenpea ocseque calnielojte tli amo cate ipa ini nönca colöl. Niecate nuyejque niechconbenieroa nequenhualecas, hua niechtiencaquesque notlajtul. Hua noche nocalnielojua yesque sa secne ca sa sente calnielojpexque. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Por inu niechtlasojtlalo noTajtzi, ipampa naja nectiemaca nonemeles, para ocsajpa necönas. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amo öque niechcuejcuelea, cache naja mismo nectiemaca. Necpea beletelestle para nectiemacas, hua necpea beletelestle para ocsajpa necönas. Ejqueu oniechmandörojque noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Hua ocsajpa omocöcamapanabejque joriojte ipampa ini nönca tlajtule. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Hua meyactie de yejua quejtoöya: ―Quepea demunio, hua lulucojtzi icaca. ¿Tli para nenquecaque? ");
INSERT INTO nhgNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Quejtoöya ocseque: ―Ini nönca tlajtule amo yaja de öque quepea demunio. ¿A poco cuale demunio quetlachealtis sente ixcocoxque? ");
INSERT INTO nhgNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Hua pa inu tiempo omochi yelfetl de oquededicörojque teopantle bieye ipa ciudad de Jerusalén. Hua oyeya tlaquiscötla cuöc lalebes siehua. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Hua Jesús onejnemoatenemeya pan teopantle cöne corredur de Salomón. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Hua tieyehualojque joriojte, hua tieyelfejque: ―¿Hasta quiema tecneque tetiechtlapolultejtas? Tlö taja teCristo öque Deus oquixpejpenque, xetiechelfe ixmantete. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Oquennönquelejque Jesús: ―Ye onemiechelfe hua amo nemoneltoca. Ini tlachihualestle tli naja necchihua tietucöyupa noTajtzi, yaja tlachihuale tlatestificöroa de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Cache nemejua amo nemoneltoca, ipampa amo nencate de nocalnielojua. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nocalnielojua niechtiencaque, hua naja nequemixomate, hua niechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Hua naja nequenmaca nemelestle nochepa. Hua ayec ixniempolebesque, hua nionöque amo niechenquextelis de nomötla. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NoTajtzi Deus niechmacaque nocalnielojua. Yejuatzi cache checöhuac iloac que nionöque, hua nionöque abele quenquextelis de tiemöpa noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Naja hua noTajtzi sasie tecate. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yecuöquenu ocsajpa joriojte ocönque teme para tietecaltisque. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Oquennönquelejque Jesús: ―Meyac tlachihuale ye onemiechejtete de noTajtzi. ¿Ipampa cötlaja tlachihuale de ini nöncate nenniechtecaltea? ");
INSERT INTO nhgNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Tienönquelejque joriojte: ―Ipampa tlin cuale tlachihuale amo temetztecaltisque, tlöcamo ipampa techecuatlajtoa. Pues taja tecaca tetlöcatl hua tomochihua quieme tlö teDeus. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Oquennönquelejque Jesús: ―¿Beles amo nenquelnömeque de que tlajcuelulpanca ejqueyi ipa nemoömatl de ley: “Naja onequejto, nendeuste nencate”? ");
INSERT INTO nhgNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pues oquencuitejque deuste yejua niecate öque inca ohuöla tlajtule de Deus. (Hua teotlajtule abele öque quexexetunis.) ");
INSERT INTO nhgNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Tlica noso nenquejtoa nemejua que naja sa nechecuatlajtoa? Pos ejqueu nenquejtoa sampor naja onequejto que netieConietzi Deus necaca. Pues noTajtzi niechixpejpenque hua niechhualtitlanque ipan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Tlö amo necchihua tietlachihuales noTajtzi, amo xeniechneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Cache tlö necchihua, mös naja amo nenniechneltoca, xomoneltocacö ica tlachihualestle para que ejqueu nenquematesque hua nemomacasque cuienta que noTajtzi noca iloac hua naja neca tieca noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Hua ocsajpa quenejnequeya tieasesque. Cache yejuatzi obiloac de inmöcopa. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Hua ocsajpa obiloac ca nie löro de ötlactle de Jordán, ipa inu nieca locör cöne cachto tlacuötiequiöya Xohuö; hua ompa necöhualuc. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hua meyactie ohuölajque tieca. Hua quejtoöya: ―Xohuö melöhuac amo tli tietzöbetl oquechi. Cache noche tli oquejto Xohuö de ini nönca tlöcatl icaca melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Hua ompa meyactie omoneltocaque ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mococoöya sente tlöcatl itucö Lázaro, tli nemeya ipa puieblo de Betania, cöne nuyejque nejnemeya icnijte María hua Marta. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Pues ini María yaja öque tieajalöbele Tlöcatzintle ica pajtle ajfeyoc, hua oquepojpu tieicxehua ca itzo. Pos mococoöya icni itucö Lázaro.) ");
INSERT INTO nhgNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Icnihua tietlatitlanelejque Jesús, hua tieyelfejque: ―Tlöcatzintle, xomojtele, öque lalebes tomotlasojtelea mococoa. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Hua cuöc oquecajque Jesús, oquejtojque: ―Ini nönca cocolestle amo ica para ma meque, cache icaca para ma niese tietlachihuales Deus, para ejqueu Deus ma niechmacacö chamöhualestle naja que neca netieConietzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Hua Jesús quentlasojtlaloöya Marta, hua icni sohuatl, hua Lázaro. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Hua cuöc quecajque que mococoöya Lázaro, necöhualuc oc ume tunale ca ompa cöne oiloaya. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Entunses sötiepa de ini nönca oquemelfejque tiemachtejcöhua: ―Teyabe ocsajpa pan estado de Judea. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Tieyelfejque tiemachtejcöhua: ―ToTiemachtejcötzi, joriojte quiemach quenejnequeya metzmotecaltelisque, ¿hua ocsajpa tomobicas ompa? ");
INSERT INTO nhgNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Nöhuatihuac Jesús: ―¿Amo quepea tunale majtlactle huan ume ura? Öque nejnemes ca tunale amo moteputlamis, ipampa quejta tlöbile de ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Cache öque nejneme ca yohuale, moteputlamea, ipampa amo onca tlöbile. Oc turavea ica ca tunale para naja; amoyetla niechpasörus. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Cuöc oquejtojque ini, sötiepa oquenmelfejque: ―Toamigo Lázaro ye coche, cache neyös para nequexetiti de icocheles. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Entunses tiemachtejcöhua tieyelfejque: ―Tlöcatzintle, tlö quejtus coche, beles pajtes. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Cache ini quejtuloöya Jesús de imequeles. Hua yejua quepensörojque beles tlajtlajtuloöya de icocheles. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yecuöquenu Jesús oquemelfejque ixmantete: ―Lázaro ye omec. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Hua necpea pöquelestle nemopampa porque ejqueu nemoneltocasque, porque naja amo ompa neyeya. Pero ma teyöcö itlac. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yecuöquenu Tumös, öque mocuitea Dídimo noso Cuhuötzi, oquemelfe ocseque machtejque: ―Teyabe nuyejque tejua para temejmequesque ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Entunses cuöc ohualiloac Jesús, oqueniextiluco que ye nöbe tunale quepea ijtec mejcöcoyoctle. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Öxö, Betania oyeya itlac Jerusalén, quieme yeye kilómetros ca bejca. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Hua meyactie joriojte ohuölajque intlac Marta hua María, para quenyulölisque ipampa imicni que ye omec. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Entunses Marta cuöc oquecac que Jesús hualiloöya, oquis para tienömequeto, cache María ompa omocö pa chöntle yehuataya. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Hua Marta otieyelfe Jesús: ―Tlöcatzintle, tlö oncö tomobetztane, nocni amo omequene. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Cache necmate nuyejque que oc turavea noche tli tomotlajtlanis ca Deus, Deus metzmomaquelilus. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Oquelfejque Jesús: ―Yulebes mocni ocsajpa. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta otieyelfe: ―Naja necmate que yulebes cuöc innochtie yulebesque ipa inu sölúltimo tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Oquelfejque Jesús: ―Naja neyulebelestle hua nenemelestle. Öque moneltoca ca naja, mös ye omec, nemes. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Hua noche öque neme hua moneltoca ca naja, ayec meques. ¿Tomoneltoca de ini? ");
INSERT INTO nhgNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Otieyelfe: ―Quiema, Tlöcatzintle. Naja noneltocateca que tejuatzi teCristo tetieConietzi Deus, que tehualmobicac ipa ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Hua cuöc ye oquejto inu, uya, hua oquenutzato icni María sa ichtecajtzi, hua oquelfe: ―Tomaestro oncö iloac hua metznutzalo. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Yaja cuöc oquecac, omoquetztequis sa nima hua uya tietlac. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Pos ayemo hualiloaya Jesús ca pa puieblo, cache oc iloaya ca queyöhuac cöne Marta tienömequeto.) ");
INSERT INTO nhgNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Entunses inu joriojte tli oyejyeya ca María ipa chöntle, hua queyulöliöya, cuöc oquejtaque quiene omoquetztequis hua oquistie, quetocaque. Pos oquepensörojque que iya chucati ompa cöne mejcöcoyoctle. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Cache María, cuöc onasec cöne iloaya Jesús hua otieyejtac, omotlancuöquetz tieixtla, hua otieyelfe: ―Tlöcatzintle, tlö oncö tomobetztane amo omequene nocni. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yecuöquenu Jesús, cuöc oquejtaque chucataya ca tiehua joriojte tli huölöya ca yaja, ocualönoac ipa tieyulo hua netequepachuluc. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Hua oquejtojque: ―¿Cöne nenquetlölejque? Otieyelfejque: ―Tlöcatzintle, xehualmobica hua xomojtelique. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Hua ochucoac Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yecuöquenu oquejtojque joriojte: ―Xomojtelicö quiene lalebes quetlasöjtlaloöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Hua seque de yejua oquejtojque: ―Ini nönca öque oquetlachealtejque ixcocoxque, ¿quie abele quechihualusquiöya majcamo meque ini nönca? ");
INSERT INTO nhgNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Hua Jesús lalebes neyulcoculuc ocsajpa, hua ohualiloac ipa mejcöcoyoctle. Ini nönca oyeya sente ustutl tli quepeaya sente tietetu ipa. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Oquejtojque Jesús: ―Xequejcuenicö tietetu. Marta, icni de öque omec, otieyelfe: ―Tlöcatzintle, ye ijyöc, ipampa ye quepea nöbe tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesús oquelfejque: ―¿Amo ye otemetzelfe, que tlö tomoneltocas, tequejtas quiene lalebes bieye iloac Deus? ");
INSERT INTO nhgNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Yecuöquenu oquejcuenejque tietetu. Hua Jesús oajcopatlachealuc hua oquejtojque: ―NoTajtzi, temetzmotlasojcömatelea ipampa teniechmocaquite. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Naja necmate que seme teniechmocaquitea; cache ipampa nöncate giente tli niechyehualojtecate onequejto, para ma moneltocacö que tejuatzi teniechhualmotitlanele. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Hua cuöc oquejtojque ini nönca, oquetzajtzelejque checöhuac: ―Lázaro, xequisa ca queyöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hua öque oyeya mejque, oquis, hualijilpetöya pa imöhua hua pa icxehua ica tatapajtle; hua ixöyac hualquemelejtöya ica sente tzotzomajtle. Oquemelfejque Jesús: ―Xectojtomacö hua xejcöhuacö ma beya. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yecuöquenu meyactie joriojte tli ohuölajque ca María, hua oquejtaque inu sösantle tli quechijque Jesús, omoneltocaque tieca. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Cache seque joriojte onyajque intlac fariseos, hua oquemelfejque de lo que tli Jesús oquechijque. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Yecuöquenu jefes de teopexcötzetzi hua fariseos omosentlölejque, hua oquejtojque: ―¿Tli tecchihuasque? Pos ini nönca tlöcatl meyac tietzöbeme quechihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Tlö tejcöhuasque ejqueu, noche giente moneltocasque ca yaja. Entunses huölösque romanos, hua tiechejcuenelisque tonación hua ini löcor yectec. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Hua Caifás, sente de yejua tlayecönque de teopexcötzetzi, oyeya tlajtocöteopexque ipa inu nieca xebetl. Yaja oquemelfe: ―Nemejua amo tli nenquemate ");
INSERT INTO nhgNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","nimpor amo nenquenenebelea. Pos cache nemiechconbenieroa que sente tlöcatl ma meque hua amo noche puieblo, para majcamo noche nönca giente ixniempolebe. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Cache ini nönca oquejto amo por ipörte yaja mismo; tlöcamo ipampa yaja oyeya tlajtojcöteopexque ipa inu nieca xebetl, por inu otlayulepante quiene Jesús mecoasquea por intequepa inu giente. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Hua amo sa por impampa inu nieca giente de joriojte, tlöcamo nuyejque mecoasquea para quensietelisque tiepelhua Deus tli ca nobeyo cate pan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ejqueu noso desde pa inu nieca tunale inu teopexcötzetzi hua fariseos quetiemoöya maniera quiene tiemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Hua ipampaju Jesús ayecmo biloatenemeya ixmantete intzölö joriojte. Cache oquixoac de ompa hua biloac pa sente tlöle ca itienco cöne nionöque chönte, ipa sente puieblo itucö Efraín. Hua ompa iloaya ca tiehua tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pos inu pöscua de joriojte ye sierca oyeya. Hua meyactie otlejcoque de inu nieca tlöle ca inu ciudad de Jerusalén antes ases pöscua, para mochepöhuasque para que ejqueu cuale quecuösque de inu tlacuale de pöscua. ");
INSERT INTO nhgNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Hua tietiemoöya Jesús, hua monunutzaya ipa teopantle bieye, quejejtoöya: ―¿Tli nenquejtoa? ¿Beles amo huölös ipa ini nönca yelfetl? ");
INSERT INTO nhgNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Hua jefes de teopexcötzetzi hua fariseos otlanahuatejque tlö canajyeca quemate cöne iloac ma quejto, pues quenejnequeya tieasesque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Entunses checuasie tunale antes de pöscua Jesús obiloac ipa inu puieblo de Betania, cöne oyeya Lázaro öque oqueyulebitejque de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Hua quechejchijque sente tlacuale. Hua Marta tlaxiexeloöya, hua Lázaro nuyejque yehuataya ca ocseque itlac miesa tietlac yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Yecuöquenu María ucö tlajco kilo pajtle ajfeyoc de nochaja nardo lalebes pateyo. Hua tieajalöbele Jesús pa tieicxehua hua tiepojpubele tieicxehua ca itzo. Noche cuale oijnecuestejtaya de inu pajtle ajfeyoc. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hua sente de tiemachtejcöhua, Judas Iscariote öque tieantrecörus, ejqueyi oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Tlica amo omonamacac ini nönca pajtle por tres cientos denarios tomi hua öque quentlöocoliöne porubejte? ");
INSERT INTO nhgNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Pos ejqueu oquejto, amo ipampa quentlachiliöya tli porubejte, tlöcamo ipampa oyeya ichtejque hua oyeya tesoriero de inu machtejque, hua quechtequeya de inu tomi tli quebicatenemeya. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yecuöquenu Jesús oquejtojque: ―Xejcajcöhua. Pues quechihua ini nönca para nieca tunale cuöc niechtlölpachusque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Pues tli porubejte seme nenquenpeasque nemotzölö, cache naja amo nochepa nenniechpeasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Entunses meyactie tlöca de joriojte quematque que yejuatzi ompa iloaya. Hua ohuölajque amo sampor tiepampa Jesús, tlöcamo nuyejque para quejtasque Lázaro, öque queyulebitejque de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Hua jefes de teopexcötzetzi motlölejque de acuierdo para nuyejque quemectisque Lázaro. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pues meyactie de joriojte oyöya hua moneltocaya tieca Jesús ipampa yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pa mustlateca, meyac tlöca tli ohuölajque ipa yelfetl oquecajque que Jesús hualiloöya ca Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Entunses ocönque imömöyo suyötl, hua tienömequeto, hua tzajtzajtzetöya: ―¡Osana! Tonochtie ma tetieyectieniehuacö öque biloatz tietucöyupantzinco Tlöcatzintle, yejuatzi öque iloac Rey de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Hua oqueniextejque Jesús sente purojconetzi, hua ipa otlejcoac. Omochi quiene tlajcuelulpanca: ");
INSERT INTO nhgNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Amo xomomajticö, giente de Sión noso Jerusalén. Xequejtacö nemoRey biloatz. Yehualutebitz ipa sente purojconetzi, iconie purolama. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ini nönca sösantle amo casojcömatque tiemachtejcöhua ca opie; cache cuöc Jesús ye oqueselejque tietlaniexteles, entunses oquelnömejque quiene tlajcuelulpa oyeya de yejuatzi, hua quiene yejua oquechijque ini nönca sösantle para yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Hua meyactie tlöca ompa oyejyeya tli oquejtaque cuöc quenutzque Lázaro de ijtec mejcöcoyoctle hua queyulebitejque de intzölö mimejque. Yejua quepoaya de inu sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Por inu nuyejque ohuölajque meyac giente tienömequeco, ipampa oquecajque que yejuatzi oquechijque ini nönca tietzöbetl. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Cache fariseos omolfejque sente ca ocsente: ―Xequejtacö quiene amo tetlaxexicoa. Xequejtacö. Pos noche tlöltecpactlöca quetoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hua oyeya seque griegos tli quepeaya costumbre tlejcusque ipa Jerusalén para tieteochihuasque Deus ipa yelfetl. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hua ini nöncate omopachojque itlac Felipe, öque oyeya de Betsaida de estado de Galilea. Oquetlajtlanejque hua oquelfejque: ―Señor, tecneque tetieyejtasque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ohuöla Felipe hua oquelfico Andrés. Yecuöquenu Andrés ohuöla ca tiehua Felipe hua yejua tieyelfejque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yecuöquenu Jesús oquennönquelejque, oquemelfejque: ―Ye asec ura cuöc naja tli onochi netlöcatl necselis chamöhualestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Melöhuac, melöhuac nemiechelfea: Tlö sente trigo amo quechayöhua ipan tlöle para meques hua motucas, pos mocöhua isiel. Cache tlö meque, lalebes mochihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Öque quetlasojtla inemeles, quepolus. Hua öque quetlajyelejta inemeles ipa ini nönca tlöltecpactle, amo quepolus, tlöcamo quepeas nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tlö yeca niechtequepanoa, ma niechtoca. Hua cöne naja neyes, nuyejque ompa iyes notlatequepano. Tlö canajyeca niechtequepanoa, noTajtzi quechamöhuasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Öxö notequepachoa ipa noyulo. ¿Hua tli nequejtus? Beles nequejtus: “NoTajtzi, xeniechmocaltechelfe de ipa ini nönca ura”. Pero abele nequejtus inu, pues para inu onehuöla pa ini nönca ura. Cache cuale ma nequejto: ");
INSERT INTO nhgNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","“NoTajtzi, xomochamöbele motucöyutzi”. Yecuöquenu ohuöla sente tlajtule de elfecac tli oquejto: ―Ye onecchamö hua ocsajpa necchamöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Hua tlöca tli ompa oyejyeya hua tli oquecajque, quejtoöya que otlatlatzcuepo. Ocseque quejtoöya: ―Öngel tienunutza. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Onöhuatihuac Jesús, hua oquejtojque: ―Amo ohuöla ini nönca tlajtule nopampa, tlöcamo nemopampa nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Öxö Deus quecuntenörusque ini nönca tlöltecpactle. Öxö tlajtoöne de ini nönca tlöltecpactle Deus quetojtocasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Hua naja, cuöc niechajcoquesque de ipa ini nönca tlöltecpactle, noche giente nequenhualecas para ma yecö ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hua ini nönca quejtuloöya para ma casojcömatecö de tli mequelestle mecoas. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Entunses tienönquelejque tlöca: ―Pos tejua otejcajque que inu ley quejtoa que Cristo öque Deus quixpejpenque mocöhuas nochepa. ¿Quiene noso tequejtoa taja nele ijteca que öque omochi tlöcatl cajcoquesque para ma meque? ¿Öquenu ini nönca öque omochi tlöcatl? ");
INSERT INTO nhgNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yecuöquenu Jesús oquemelfejque: ―Sa oc tepetzi iyes tlöbile nemotzölö. Xenejnemecö mientras oc nenquepea tlöbile, para majcamo nemiechnöhualase tlajtlayohuaquelestle. Pues öque yajteneme ipan tlajtlayohuaquelestle amo quemate cöne iya. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mientras nenquepea tlöbile, xomoneltocacö ica tlöbile, para nemochihuasque nentiepeljua de yejuatzi öque iloac tlöbile. Ini nönca sösantle oquejtojque Jesús, hua obiloac, hua nejyönaluto de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mösque quechijque meyac tietzobeme imixtla yejua amo moneltocaya tieca. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ini nönca omochi para ma mocumpliro inu tlajtule tli oquejto inu tlayulepante Isaías: Tlöcatzintle, nionöque amo moneltocac de totlajtul, hua nionöque amo oquejtac tiechecöhuales Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Por inu abele omoneltocaque. Pos ocsajpa oquejto Isaías: ");
INSERT INTO nhgNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Quixcocoxcötelejque imixtelolojua de yejua, hua quenyultepitzojque para majcamo tlacheacö ca imixtelolojua hua majcamo casojcömatecö ca inyulo para amo moyulcuepasque hua naja amo nequenpajtis. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ini nönca sösantle oquejto Isaías ipampa oquejtac quiene lalebes bieye iloac Cristo hua otlajtlajto de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Hua meyactie hasta de tlötlayecönque omoneltocaque ca yejuatzi, cache ipampa quenmabeliöya fariseos amo ixmantete quejtoöya, para majcamo quentojtocacö para ayecmo calaquesque ipa teopanme. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Pues cache quenequeya inu chamöhualestle tli yebitz de tlöca hua amo inu chamöhualestle tli yebitz de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pero Jesús otzajtzihuac hua oquejtojque: ―Öque moneltoca ca naja, amo moneltoca sa ca naja, tlöcamo ca öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Hua öque niechejta naja tieyejta öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Naja onehuöla quieme netlöbile pa ini nönca tlöltecpactle para que noche öque noca moneltoca, majcamo mocöhua pa tlajtlayohuaquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Hua öque quecaques notlajtul hua amo quechihua cöso, naja amo necjuscöroa, ipampa amo nehuöla nequenjuscöruco tlöltecpactlöca, cache nequenmöquextico tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Öque niechtlajyelejta, hua amo quesele notlajtul, onca tli quejuscöroa. Tlajtule tli naja nequejtoa, yaja inu quejuscörus ipa inu sölúltimo tunale. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pues naja amo netlajtlajto sa por nopörte naja, cache noTajtzi öque niechhualtitlanque, yejuatzi niechmandörojque de tli netlanunutzas hua de tli nequejtus. ");
INSERT INTO nhgNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Hua necmate que lo que tli yejuatzi tlamandöruro quetiemaca nemelestle nochepa. Por inu, cuöc naja netlajtlajtoa es que nequejtoa san quiene ca noTajtzi niechelfejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Öyeya antes de cuöc mochihuas inu yelfetl de pöscua. Ye quematihuaya Jesús que tieura ye oaseco para biloas de ipa ini nönca tlöltecpactle para ca tiecatzinco tieTajtzi. Quentlasojtlaloöya inu giente tli tiehuöxcahua tli oyejyeya pan tlöltecpactle. Hua ejqueu quentlasojtlaque tönto lalebes que oquenejque mecoaco por yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Hua ye asec ura para tlacuösque, hua Diöblo ye oquetlöle ipa iyulo Judas, iconie Semu Iscariote, para ma tieantrecöro. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Hua Jesús quematihuataya que tieTajtzi tiemöctelejque noche sösantle, hua que hualquixoac de Deus, hua ye miero biloas tieca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ca inu, onequetzaluc de cöne tlacualoöya hua oquequextejque tietlaquie. Hua ocönque sente babiero, hua netlajcoilpiluc. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Yecuöquenu oquetiecaque ötzintle ijtec ajpöstle, hua quepiehualtejque quemecxepajpöcaloöya hua quenhuötzque inmecxehua ca inu babiero tli ica netlajcoilpiluc. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Entunses ohualbiloac itlac Semu Piero. Hua yaja otieyelfe: ―Tlöcatzintle, ¿tejuatzi teniechmoyecxepajpöquelis? ");
INSERT INTO nhgNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Onöhuatihuac Jesús hua oquelfejque: ―Tli naja necchihua, taja amo tecmate öxö; cache tecasojcömates sötiepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Otieyelfe Piero: ―Amo quiema teniechmoyecxepajpöquelis. Onöhuatihuac Jesús: ―Tlö amo temetzecxepajpöcas, amo tecpeas pörte ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Otieyelfe Semu Piero: ―Tlöcatzintle, majcamo sa nocxehua, tlocamo nuyejque nomöhua hua notzonteco. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Oquelfejque Jesús: ―Öque ye omajölte, ayecmo quenesesitöroa mopajpöcas, tlöcamo ma sa quepajpöca icxehua, hua ye noche chepöhuac ica. Hua nemejua ye nenchepöjque nencate, mös amo nemonochtie. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Pues yejuatzi quematihuaya öque tieantrecörusquea, hua por inu oquejtojque: “Amo nenchepöjque nemonochtie”. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ejqueu, sötiepa de cuöc oquemecxepajpöjque, oneöquiluc tietlaquie hua ocsajpa netlöliluc itlac miesa, hua oquemelfejque: ―¿Nenquemate tlininu nemiechonchibele? ");
INSERT INTO nhgNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nemejua nenniechcuitea Maestro hua Tlöcatzintle. Hua cuale tli nenquejtoa, ipampa tiel melöhuac ejqueu necaca. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Entunses tlö naja nenemoTlöcatzintle hua nenemoMaestro necaca hua nemiechecxepajpöc, conbenierebe que nemejua nuyejque ma xomoyecxepajpocacö sie tlöcatl ca ocsie tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ipampa ini nönca nemiechejtetejtiehua ejiemplo, para que quiename naja onecchi ca nemejua, nemejua nuyejque ejqueu xecchihuacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Melöhuac, melöhuac nemiechelfea: Sente esclavo amo cache bieye ica que itieco, nimpor sente tlatitlantle amo cache bieye que öque cualtitla. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Tlö nenquemate ini nönca sösantle, cuale nenyesque tlö nenquechijtasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Amo nequejtoa ini de nemonochtie; naja necmate oquemeju nequemixpejpe. Cache ini nönca pasorebes para ma mochihua tli tlajcuelulpanca: “Oque quecua de nopöntzi, yaja ye omocuec cuntra de naja”. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Desde öxö nequejtoa antes de cuöc mochihuas, para que cuöc mochihuas, nemoneltocasque que naja neca. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Melöhuac, melöhuac nemiechelfea: Öque queselis öque naja nectitlanes, naja niechselea, hua öque naja niechselea, tieselea öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Cuöc Jesús ye oquejtojque ini nönca, onetequepachuluc ipa tieyulo, hua oquejtojque ixmantete: ―Melöhuac, melöhuac nemiechelfea, sente de nemejua niechantrecörus. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yecuöquenu tiemachtejcöhua sa mojojtaya entre yejua, pues öquenu de yejua iyes. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Hua sente de inu tiemachtejcöhua, öque Jesús quetlasojtlaloöya, obetztaya ipa tiepiecho Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Hua Semu Piero oquenutz ini nönca hua oquelfe ma tlajtlane öquenu noso iyes de öque yejuatzi tlajtlajtulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Por inu yaja omonacascatiecac ipa tiepiecho Jesús, hua otieyelfe: ―NoTlöcatzintle, ¿öquenuju? ");
INSERT INTO nhgNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Entunses onöhuatihuac Jesús: ―Yaja inu nieca öque naja necmacas pöntzi tli necpolactis. Yecuöquenu quepolactejque pöntzi hua oquemacaque Judas, iconie Semu Iscariote. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Hua sötiepa de inu sencamatl, Satanás ocalac ipa iyulo. Yecuöquenu Jesús oquelfejque: ―Tli taja tecchihuas, pues isejco xecchijtebetze. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Cache nionöque de tli oyejyeya ipa miesa amo casojcomatque tli ipampa quejtojque ini nönca. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Pues seque quepensöroöya que beles oquejtojque ipampa Judás oyeya tesoriero, hua beles yaja ica Jesús quelfiloöya: “Xejcoate tli tiechpoloa para yelfetl”, noso beles ma quenmaca yetla öque porubejte. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Hua cuöc yaja oquecua inu sencamatl, sa nima oquistie. Ye oyeya ca yohuale cuöquenuju. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yecuöquenu cuöc yaja oquistie, oquejtojque Jesús: ―Öxö ye necselis chamöhualestle naja tli onochi netlöcatl, hua Deus nuyejque quepeasque chamöhualestle por naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Pos tlö Deus quepeasque chamöhualestle por naja, entunses yejuatzi mismo nuyejque niechmacasque chamöhualestle, hua sa nima niechmacasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nopeljua, sa oc tepetzi nemotlac neyes. Nenniechtiemusque. Pero quieme ye onequemelfe joriojte, öxö ejqueu nemiechelfea nemejua, que cöne naja neya, nemejua abele nenyösque. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sente yancuec mandamiento naja nemiechmaca, que yaja ini nönca: Xomotlajtlasojtlacö entre nemejua. Quiene naja nemiechtlasojtla, nuyejque nemejua xomotlasojtlacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ejqueu noche giente nemiechixomatesque que nemejua nencate nennomachtejcöhua, tlö nemotlajtlasojtlasque sente ca ocsente. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Otieyelfe Semu Piero: ―Tlöcatzintle, ¿cöne tomobicas? Onöhuatihuac Jesús: ―Cöne naja neya, abele teniechtocas öxö, cache sötiepa teniechtocas. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Otieyelfe Piero: ―Tlöcatzintle, ¿tlica abele temetzmotoquelis öxö? Nonemeles nectiemacas mopampantzinco. ");
INSERT INTO nhgNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Oquenönquelejque Jesús: ―¿Monemeles tectiemacas nopampa? Melöhuac, melöhuac temetzelfea, que ye yexpa tequejtus que amo teniechixomate antes de que tzatzes canteliex. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","’Ma ayecmo xomoyultequepachucö. Xecsequirojtacö xomoneltocacö ca Deus; xecsequirojtacö xomoneltocacö nuyejque ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ipa tiechö noTajtzi meyactie calme oncate, hua tlö cana amo ejqueu oyene ye nemiechantesipöroöne. Pues neya necyejyectlöliti locör para nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Hua tlö neya hua necyejyectlöliti locör para nemejua, nehuölös ocsajpa, hua naja nemiechönaqui, para que cöne naja neyes, nemejua nuyejque ompa nenyesque. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Hua cöne naja neyös nemejua nenquemate ojtle. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Otieyelfe Tumös: ―Tlöcatzintle, amo tecmate cöne tomobica, ¿quiene noso tecmatesque ojtle? ");
INSERT INTO nhgNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Oquelfejque Jesús: ―Naja neojtle hua nemelöhuac hua nenemelestle. Abele öque huölös tietlac noTajtzi, tlöcamo por naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tlö ye nenniechixomate naja, nuyejque nentieixomatesque noTajtzi. Pos desde öxö ye nentieixomatejtecate, hua ye onentieijtaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Otieyelfe Felipe: ―Tlöcatzintle, xetiechmojtetele moTajtzi hua sa ca inu basta para tejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesús oquelfejque: ―Ye onebejcö lalebes ca nemejua, hua ¿beles ayemo teniechixomate, Felipe? Öque ye niechejtac naja, nuyejque ye otieyejtac noTajtzi. ¿Quiene noso teniechelfea taja: “¿Xetiechmojtetele moTajtzi?” ");
INSERT INTO nhgNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Beles amo tomoneltoca cuöc nequejtoa que naja necaca tieca noTajtzi, hua noTajtzi iloac ca naja? Inu tlajtulme tli nemiechnunutza naja, amo nemiechnunutza por nopörte de naja; cache noTajtzi öque seme iloac ca naja, yejuatzi quechihualo tietlachihual. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xeniechneltocacö que naja necaca tieca noTajtzi hua noTajtzi iloac ca naja. Cache tlö amo nemoneltocasque sampor naja nequejtoa, xomoneltocacö ipampa inu mismo tlachihuale tli necchihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","’Melöhuac, melöhuac nemiechelfea, que inu tlachihuale tli naja necchihua nuyejque quechihuas öque noca moneltoca. Hua cache bieye tlachihuale quechihuas que ini, ipampa naja neyös ca noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Hua noche sösantle tli nentlajtlanesque notucöyupa, inu necchihuas, para ejqueu noTajtzi queselisque chamöhualestle por medio de naja tli netieConietzi neca. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tlö yetla nenniechtlajtlanesque notucöyupa naja mismo necchihuas. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Tlö nenniechtlasojtla, nenquechihuasque lo que tli nemiechmandöroa. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Hua naja netietlötlajtis noTajtzi hua nemiechmacasque ocsente Tlapaliebiöne, para ma iloa ca nemejua nochepa, ");
INSERT INTO nhgNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","yejuatzi Espíritu tli melöhuac. Hua tlöltecpactlöca abele tieselea, ipampa amo tieyejta, nimpor amo tieixomate. Cache nemejua nentieixomate, ipampa biloateneme nemoca hua ipa nemoyulo iloac. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","’Amo nemiechcöhuas nenicnutzetzi; nehuölös ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sa oc tepetzi, hua tlöltecpactlöca ayecmo niechejtasque; cache nemejua nenniechejtasque. Porque naja neneme, por inu nemejua nuyejque nennemesque. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ipa inu nieca tunale nemejua nenquematesque que naja neca tieca noTajtzi, hua nemejua nencate ca naja, hua naja ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Öque quepea nomandamiento, hua quechihua, yaja inu tlöcatl niechtlasojtla. Hua öque niechtlasojtla, quetlasojtlasque noTajtzi, hua naja nectlasojtlas hua noniextis ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Otieyelfe Judas, amo yaja Iscariote: ―Tlöcatzintle, ¿tlica tomoniextejtzinus ca tejua, hua amo ca tlöltecpactlöca? ");
INSERT INTO nhgNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Onöhuatihuac Jesús, hua oquelfejque: ―Tlö canajyeca niechtlasojtla, entunses quechihuas tli naja nequejtoa. Hua noTajtzi quetlasojtlasque, hua tehuölösque ica yaja, hua tochöntisque ica yaja. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Öque amo niechtlasojtla, amo quechihua cöso de notlajtul. Ini tlajtule tli nenquecajque amo nohuöxca, pues tiehuöxca noTajtzi öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ini nönca sösantle ye onemiechnunutz mientras oc turavea neca nemotlac. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Cache Tlapaliebiöne, yejuatzi Espíritu Sönto öque noTajtzi tiehualtitlanesque notucöyupa, yejuatzi nemiechmachtisque noche sösantle. Hua nemiechtlalnömectisque noche sösantle tli naja ye onemiechelfe. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Yulsiebelestle nemiechcöbelejtiehua. Naja mismo nemiechyulsiebea. Amo nemiechyulsiebea naja san quiene ca tlayulsiebea tlöltecpactlöca. Majcamo xomoyultequepachucö nimpor majcamo xomomajticö. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ye onenquecajque que naja mismo ye onemiechelfe: “Neya ocsie löro, hua nehuölös ocsajpa ca nemejua”. Tlö nenniechtlasojtlane de melöhuac, nenquepeasquiöne pöquelestle de que naja neya tieca noTajtzi. Pues noTajtzi cache bieye iloac que naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Öxö noso ye onemiechelfe antes de cuöc mochihuas, para que cuöc mochihuati nemoneltocasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ayecmo meyac tiempo netlajtlajtus ca nemejua, ipampa ompabitz tlajtoöne de nönca tlöltecpactle. Hua yaja amo tli quepea ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Cache pasörebes ini nönca para ma quemajtacö tlöltecpactlöca que netietlasojtla noTajtzi hua que san quiene ca noTajtzi niechhualtitlanque ma necchihua, ejqueu necchijtebitz. Xomoquetzacö. Teyabe de necö. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Naja necaca neuvastemecatl tli melöhuac, hua noTajtzi queixutilo. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cöra sente nomömöyo tli notech ica hua amo tlamochihualtea, quecaltechusque. Hua cöra sente tli tlamochihualtea, quetejtequelisque imömöyocuconehua para ma tlamochihualte cache. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nemejua ye nenchepacteque nencate por inu tlajtule tli naja ye onemiechnunutz. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xeyetacö notech naja hua naja neyes ca nemejua. San quiene ca sente mömöyutl abele tlamochihualtis sie yaja, tlö amo iyes itech temecatl, ejqueu nuyejque nemejua abele tli nequechihuasque tlö amo nenyetasque notech naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Naja netemecatl, nemejua nennomömöyo. Öque yetas notech naja hua naja ca yaja, yaja ini tlamochihualtis lalebes. Pues sin naja abele tli nenquechihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tlö canajyeca amo yetas notech naja Deus quetlajcalesque ca queyöhuac quiename sente amo cuale mömöyutl, hua huöques. Hua quenpejpenasque inu mömöyume amo cualteque hua quentlajcalesque ijtec tletzintle, hua xutlasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Tlö nenyetasque notech hua notlajtul yetas ca nemejua, xetlajtlanecö noche tli nenquenequesque, hua ejqueu mochihuas ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Cuöc nemejua nenqueneltoca notlajtul hua ixmantete niese que nencate nennomachtejcöhua, entunses quepealo chamöhualestle noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","San quiene ca noTajtzi niechtlasojtlalo, nuyejque naja ejqueu nemiechtlasojtlac. Xeyetacö ipa notlasöjteles. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tlö nenquechihuasque tli nemiechmandöroa, nenyetasque ipa notlasojteles. Pos ejqueu naja nuyejque necchihua tli niechmandörojque de noTajtzi hua neyeteca ipa tietlasojteles. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Yaja ini nönca sösantle ye onemiechelfe, para que nopajpöqueles ma iye ca nemejua, hua nemopajpöqueles ma momeyaquele. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","’Yaja ini tli nemiechmandöroa: Xomotlajtlasojtlacö quieme naja nemiechtlasojtla. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Abele öque quepeas cache bieye tlasojtelestle de que öque quetiemacas inemeles por impampa iamigos. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nemejua nencate nennoamigos, tlö nenquechihua noche sösantle tli naja nemiechmandöroa. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ayecmo nemiechcuitis nennoesclavos, ipampa sente esclavo amo quemate tli quechihua itieco. Cache nemiechcuitea nennoamigos, ipampa noche sösantle tli onejcac de noTajtzi, ye onemiechmacheste. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Nemejua amo nenniechixpejpenque naja, tlöcamo naja nemiechixpejpe nemejua; hua onemiechtlöle para nenquechihuasque tli nemiechelfe. Hua nemotlachihuales mocöhuas nochepa. Ejqueu noche lo que tli nentietlajtlanelisque noTajtzi notucöyupa, yejuatzi nemiechmacasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yaja ini nemiechmandöroa: Xomotlajtlasojtlacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Tlö tlöltecpactlöca nemiechtlajyelejta, xecmajtacö que niechtlajyelejtaque naja cachto de nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Tlö nenyene de tlöltecpactlöca, tlöltecpactlöca nemiechtlasojtlasquiöne porque quentlasojtla tli de yejua cate. Cache ipampa amo nencate de tlöltecpactlöca, tlöcamo naja nemiechixpejpe de intzölö tlöltecpactlöca, ipampaju tlöltecpactlöca nemiechtlajyelejta. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xequelnömequecö ini tlajtule tli onemiechelfe. Sente esclavo amo ica cache bieye que itieco. Tlö naja niechtepotztocaque nuyejque nemejua nemiechtepotztocasque. Tlö amo oquechijque tlöltecpactlöca lo que tli onequejto naja, nuyejque amo quechihuasque tli nenquejtusque nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Cache noche ini nönca sösantle nemiechchibelisque ipampa nenquebica notucöyu, pues amo tieixomate öque niechhualtitlanque. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Tlö amo nehuölöne, nimpor amo nequennunutzane, amo quepeasquiöne tlajtlacule, cache öxö amo quepea tli ipampa quejtusque que amo tlajtlaculteque. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Öque niechtlajyelejta, nuyejque tietlajyelejta noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tlö intzölö yejua amo necchihuane tlachihuale tli ocseque amo oquechijque, amo quepeasquiöne tlajtlacule. Cache öxö ye otiechejtaque hua otiechtlajyelejtaque naja ca tiehua noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ini nönca pasöre para ma mochihua inu tlajtule tli tlajcuelulpanca pa inu libro de ley tli yejua quetoca: “Sin arasu niechtlajyelejtaque”. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Cache hualiloas Tlapaliebiöne, yejuatzi Espíritu tli melöhuac, hua yejuatzi biloatz de noTajtzi. Naja netiehualtitlanes ca nemejua de ompa tietlac noTajtzi. Hua cuöc hualiloas tlatestificörurus de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Hua nemejua nuyejque xetlatestificörucö, ipampa notlac neyejyeya desde ca opie. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","’Ini nönca sösantle ye onemiechelfe para majcamo xejcöhuacö nemoneltoqueles. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Giente nemiechtojtocasque de ipan teopame. Hasta yebitz ura que noche quiejquech nemiechmectisque quepensörusque que ca inu tietequepanojtecate Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hua ini nönca sösantle quechihuasque ipampa amo tieixomatque noTajtzi nimpor naja amo niechixomatque. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cache ini nönca sösantle ye onemiechelfe para que cuöc nieca ura huölös, nenquelnömequesque de lo que tli naja onemiechelfe. ’Cache ini nönca sösantle amo onemiechelfe ca opie, ipampa naja neyeya ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Cache öxö neya tieca öque niechhualtitlanque. Hua nionöque de nemejua niechtlajtlanea: “¿Cöne tomobica?” ");
INSERT INTO nhgNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Cache ipampa onemiechelfe ini nönca sösantle, tequepachule ocalac ipa nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero naja nemiechpubelis tli melöhuac, que cache cuale iyes para nemejua por que naja neyös. Ipampa tlö naja amo neyös Tlapaliebiöne amo hualiloas nemoca. Cache tlö neyös, netiehualtitlanes ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Hua cuöc ye ohualiloac quenchihualtisque ma moyulnunutzacö tlöltecpactlöca de intlajtlacul, hua de yectelestle hua de inu condenación. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Moyulnunutzasque de tlajtlacule ipampa amo monejneltoca ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Hua moyulnunutzasque de yectelestle, ipampa neya tieca noTajtzi, hua ayecmo nenniechejtasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Hua moyulnunutzasque de condenación ipampa Deus ye öquecuntenörojque tlajtoöne de ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Oc necpea meyac sösantle tli nemiechpubelis, cache ayebele nenquexicusque öxö. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Cache cuöc ye ohualiloac Espíritu tli melöhuac, yejuatzi nemiechyecönasque ipa noche tli melöhuac. Pues amo tlajtlajtulus por tiepörte de yejuatzi mismo, tlöcamo noche tli quecaquesque yaja inu quejtusque. Hua nemiechmachestisque de meyac sösantle tli sötiepa mochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hua yejuatzi niechchamöhuasque naja porque nemiechmachestisque meyac sösantle de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Noche inu sösantle tli de noTajtzi nuyejque de naja ica. Por inu onequejto que nemiechmachestisque sösantle de naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Sa oc tepetzi hua ayecmo nenniechejtasque; hua oc tepetzi hua ye ocsajpa nenniechejtasque. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yecuöquenu omolfejque seque de tiemachtejcöhua: ―¿Tlininiji tli tiechelfilo: “Sa oc tepetzi hua amo nenniechejtasque; hua ocsajpa sa oc tepetzi hua nenniechejtasque”, hua: “Naja neyös tieca noTajtzi”? ");
INSERT INTO nhgNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Pos oquejtojque: ―¿Tlininiji quejtulo: “Sa oc tepetzi”? Amo tecasojcömate tli quejtulo. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Hua ocasojcömatque Jesús que quenequeya tietlajtlanesque, hua oquemelfejque: ―¿Nentlajtlane nemotzölö de ini nönca tli onequejto: “Sa oc tepetzi hua amo nenniechejtasque, ocsajpa oc tepetzi hua nenniechejtasque”? ");
INSERT INTO nhgNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Melöhuac, melöhuac nemiechelfea: Nemejua nenchucasque hua nemotlöocoltisque, hua tlöltecpactlöca pajpöquesque. Nemejua nenquepeasque tequepachule, cache nemotequepachul mocuepas pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sente sohuatl cuöc mixebe, quecocoa icuierpo, ipampa oasico iura. Cache sötiepa de cuöc ye oquetlocatilte peltzintle ayecmo quelnömeque tietunie, tlöcamo quepea pöquelestle ipampa otlöcat sente peltzintle ipan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pos nuyejque nemejua öxö nenquepea tequepachule. Cache ocsajpa nemiechejtas, hua nemoyulo pajpöques, hua amo öque nemiechcuejcuelis nemopajpöqueles. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Hua ipa inu nieca tunale amo nenniechtlajtlanisque niontle. Melöhuac, melöhuac, nemiechelfea: NoTajtzi nemiechmacasque noche tli nentietlajtlanelisque notucöyupa. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta öxö amo tli nentlajtlantecate notucöyupa. Xetlajtlanecö noso, hua nenquepeasque para que nemopajpöqueles ma momeyaquele. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Ini nönca sösantle onemiechnunutz ca tlajtule tli amo nencasojcömate. Yebitz ura cuöc ayecmo nemiechnunutzas ca tlajtule tli amo nencasojcömate, cache ixmantete nemiechmachestis de noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ipa inu nieca tunale nentlajtlanesque notucöyupa. Hua amo nemiechelfea que netietlötlajtis noTajtzi nemopampa. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pues sie yejuatzi noTajtzi nemiechtlasojtlalo, porque nemejua nenniechtlasojtlaque, hua nemoneltocaque que naja onehuölie de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Onehuölie de tietlac noTajtzi hua onaseco ipa nönca tlöltecpactle. Öxö ye nejcöjtiehuas nönca tlöltecpactle hua ocsajpa neyös tieca noTajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Oquejtojque tiemachtejcöhua: ―Xomojtele, öxö tetiechmonunuchelea ixmantete, hua amo ca tlajtule tli amo tecasojcömate. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Öxö tecmate que tejuatzi tomomachitea noche sösantle, hua amo tomonesesitörfea ma canajyeca metzmotlajtlanele pues ye tomomachitea tlin inu queneque tlajtlanes. Por inu toneltoca que tejuatzi melöhuac tehualmoquextejtie de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Oquennönquelejque Jesús: ―¿Öxö nemoneltoca? ");
INSERT INTO nhgNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Xequejtacö, que yebitz ura, hua ye oasico, cuöc nemiechnencuaxelusque, cara sente ipa iojfe, hua nenniechcöjtiehuasque nosiel. Cache amo nosiel neca, porque noTajtzi notlac iloac. ");
INSERT INTO nhgNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ini nönca sösantle ye onemiechelfe para noca nenquepeasque yulsiebelestle. Ipan tlöltecpactle nenquepeasque tequepachule, cache xecpeacö confiönsa, porque naja ye onecxexico tlöltecpactle hua itlachihual. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ini nönca sösantle oquejtojque Jesús. Hua ajcopatlachealuc ca elfecac hua oquejtojque: ―NoTajtzi, ye oaseco ura. Xeniechmomaquele chamöhualestle naja tli neca nemoConietzi, para nuyejque ejqueu naja temetzmochamöbelis tejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pos ye teniechmomaquele noche checöhualestle para ca noche giente para que innochtie quiejquech teniechmomaquele ma nequenmaca nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hua nemelestle nochepa ica que ma metzmixomachelicö que sa tejuatzi teDeus tomobetzteca de melöhuac hua ma niechixomatecö naja neJesucristo öque tejuatzi oteniechhualmotitlane. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Naja ye temetzmacac chamöhualestle ipa tlöltecpactle. Ye onectlame motequeyojtzi tli teniechmomaquele ma necchihua. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Öxö noso, noTajtzi, xeniechmomaquele chamöhualestle tejuatzi mismo, inu nieca chamöhualestle tli necpeaya motlactzinco cachto de cuöc oyeya tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Inu niecate tlöca tli teniechmomaquele de intzölö tlöltecpactlöca ye onequemelfe ixmantete de quiene tomobetzteca tejuatzi. Mohuöxcatzetzihua oyejyeya, hua teniechenmomaquele, hua yejua oqueneltocaque motlajtultzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Öxö quemajtecate que noche sösantle tli teniechmomaquele yebitz de tejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pues inu tlajtule tli teniechmomaquele, onequenmacac. Hua yejua oqueselejque, hua oquematque que de melöhuac onehuölquis de tejuatzi. Hua omoneltocaque que tejuatzi teniechhualmotitlane. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Naja notlajtlötlajtea por yejua. Amo notlajtlötlajtea por tlöltecpactlöca, tlöcamo por niecate tli teniechenmomaquele, ipampa mohuöxcatzetzihua cate. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Hua noche sösantle tli nohuöxca, mohuöxcatzi, hua tli mohuöxcatzi, nohuöxca. Hua naja necpea chamöhualestle por medio de yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Hua ayecmo neyes ipan tlöltecpactle, cache ini nöncate mocöhuasque ipan tlöltecpactle hua naja neya mocatzinco. NoTajtzi yectec, xequenmomalfele para ma quesequirucö ca tejuatzi, quiename teniechmojtetele que tejuatzi tomobetzteca. Xequenmomalfele para ma yecö sasie, quieme nuyejque tejua sasie tecate. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Cuöc naja neyeya inca yejua, naja nequenmalfiöya para ma quesequirucö ca tejuatzi, quiename teniechmojtetele que tejuatzi tomobetzteca. Naja onequenmalfe hua nionöque de yejua amo oixniempole, tlöcamo solamiente nieca tli de porsi iya ipa ixniempolebelestle para ma mochihua tli tlajcuelulpanca. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Cache öxö neya mocatzinco. Hua nequejtoa ini nönca sösantle ipan tlöltecpactle, para ma quepeacö nopajpöqueles hua ma momeyaquele inca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Naja ye onequenmacac motlajtultzi, hua tlöltecpactlöca ye quentlajyelejta, ipampa amo cate de tlöltecpactlöca quieme naja nuyejque amo neca de tlöltecpactlöca. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amo notlajtlötlajtea para tequenmoquextelis de ipa ini nönca tlöltecpactle, tlöcamo para tequenmomalfelis de noche tlin amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Amo cate de ini nönca tlöltecpactle, quieme naja nuyejque amo neca de tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xequenmonencuaxelfe por medio de lo que tli melöhuac para ma yecö yecteque. Motlajtultzi, yaja inu icaca melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Quieme tejuatzi teniechhualmotitlane ipa tlöltecpactle, ejqueu nuyejque nequentitla ipan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Hua por impampa yejua naja mismo nonencuaxeloa para necchihuas ini tequetl, para nuyejque yejua ma monencuaxelucö hua ma yecö yecteque por medio de lo que tli melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Cache amo notlajtlötlajtea sa para ini nöncate nomachtejcöhua, tlöcamo nuyejque para quiejquech moneltocasque noca por intlajtul de nomachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Notlajtlötlajtea para que innochtie ma yecö sasie, san quiene ca tejuatzi, noTajtzi, tomobetzteca ca naja hua naja ca tejuatzi, ejqueu nuyejque yejua ma yecö ca tejua. Hua ejqueu tlöltecpactlöca ma moneltocacö que tejuatzi teniechhualmotitlane. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Hua inu tlaniextelestle tli teniechmomaquele nuyejque naja onequenmacac, para ma yecö sasie quieme tejua tecate nuyejque sasie. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naja ma neye ca yejua, hua tejuatzi ca naja, para ma yecö yejua sasie de melöhuac. Ejqueu tlöltecpactlöca ma momacö cuienta que tejuatzi teniechhualmotitlane hua que tequenmotlasojtelea yejua quieme nuyejque teniechmotlasojtelea. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","NoTajtzi, necneque que niecate tli teniechenmomaquele nuyejque ma yecö ca naja cöne naja neyes, para ma quejtacö notlaniexteles tli teniechmomaquele porque teniechmotlasojtele desde antes que omochejchi ini nönca tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","NoTajtzi yectec, tlöltecpactlöca amo metzmixomachelejque, cache naja temetzmixomachele, hua ini nöncate ye oquematque que tejuatzi teniechhualmotitlane. ");
INSERT INTO nhgNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Hua naja nequemelfe ixmantete de quiene tomobetzteca tejuatzi, hua nequemelfis cache. Ejqueu inu tlasojtelestle tli ica teniechmotlasojtele ma iye ipa inyulo, hua naja ma neye ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cuöc Jesús ye oquejtojque ini nönca sösantle, biloac ca tiemachtejcöhua ca ocsie löro öpöntle itucö Cedrón, cöne oyeya sente locör cuajcamac. Ipa inu locör calacoac Jesús ca tiehua tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Hua Judas, öque tieantrecörusquea inca tieenemigos, quixomateya inu nieca locör. Pos meyacpa Jesús nesentlöliloöya ompa ca tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas, noso, quemönato soltörojte ca tiehua policías de tlötlayecönque de teopexcotzetzi hua de fariseos. Hua oaseto ompa ica tlobilte, hua tlobilecutl, hua teposme. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Cache Jesús, ipampa quematiloöya noche inu sösantle tli tiepa huölös, oquixoac ca cöne yejua oyejyeya hua oquemelfejque: ―¿Öquenu nenquetiemoa? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Otieyelfejque: ―Jesús de puieblo de Nazaret. Oquemelfejque Jesús: ―Naja neca. (Hua nuyejque ompa oyeya ca yejua Judas, öque tietiemöctiöya ca yejua.) ");
INSERT INTO nhgNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hua cuöc oquemelfejque: “Naja necaca”, otzinquisque hua obejbiebetzeto ipan tlöle. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ocsajpa oquentlajtlanejque: ―¿Öquenu nenquetiemoa? Hua yejua oquejtojque: ―Jesús de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Onöhuatihuac Jesús: ―Ye onemiechelfe que naja neca. Tlö quejtus naja nenniechtiemoa, xequencöhuaco ini nöncate ma yöcö. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ejqueu oquejtojque Jesús para ma mochihua inu tlajtule tli oquejtojque: “Öque teniechenmomaquele, nion sente de yejua amo necpolo”. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Yecuöquenu Semu Piero, öque quepeaya sente espöda, oquequexte, hua oquemacac iesclavo de tlajtojcöteopexque, hua oquetequele inacas tli ca imöyecmö. Hua inu esclavo mocuitiöya Malco. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yecuöquenu Jesús oquelfejque Piero: ―Xejcalaque moespöda ijtec icuetlaxyo. Inu bölso de tiecoco tli oniechmacaque noTajtzi necpea que neconis. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Yecuöquenu soltörojte hua coroniel, hua guardia de joriojte, tieaseque Jesús hua tieijilpejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hua cachto tiebicaque itlac Anás, pues yaja oyeya imönta de Caifás, öque oyeya tlajtojcöteopexque ipa inu nieca xebetl. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Hua yaja ini Caifás öque oquentlajtulmacac joriojte nele conbenierebe ma meque sente tlöcatl por intequepa puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Hua Semu Piero hua ocsente de tiemachtejcöhua tietocaque Jesús. Hua tlajtojcöteopexque quixomateya inu ocsente machtejque, hua yaja ocalac ca Jesús ipa ipötio de tlajtojcöteopexque. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Cache Piero omocö ca queyöhuac ipa trönca. Hua oquis inu ocsente machtejque öquenu tlajtojcöteopexque quixomateya. Hua inu machtejque oquenunutz sohuatl tlajpexque hua oquecalaque Piero. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yecuöquenu inu sohuatl öque quexutiöya trönca oquelfe Piero: ―¿Beles nuyejque taja tecaca sente de imachtejcöhua de ini nönca tlöcatl? Oquejto yaja: ―Naja amo. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hua ompa ijijcataya policías hua esclavos. Ye oquechejchijque tletzintle de tecole, ipampa lalebes siehua, hua yejua omotojtotunejtaya. Hua nuyejque ijcataya Piero inca yejua omototunejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Entunses inu tlajtojcöteopexque tietlajtlane Jesús de tiemachtejcöhua hua de tietlamachteles. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesús oquelfejque: ―Naja ixmantete onequennunutz ca noche giente. Naja seme onequenmachtiöya ipa teopancucone hua ipa teopantle bieye cöne mosentlolea noche joriojte, hua amo tli onequejto sa ichtecajtzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Tli ipampa teniechtlajtlanea naja? Xequentlajtlane yejua tli oquecajque de lo que tli onequennunutz; yejuanu quemate tli naja onequejto. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Hua cuöc yejuatzi oquejtojque ini, sente policía tli ompa ijcataya, tiecamatetlatzcuepune Jesús, hua oquejto: ―¿Ejqueu tecnönquelea tlajtojcöteopexque? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nöhuatihuac Jesús: ―Tlö onequejto tli amo cuale, xecmelöjcopoa de tli amo cuale onequejto. Hua tlö cuale tli nequejtoa, ¿tli ipampa teniechmaca? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Entunses Anás tietitla ica Caifás tlajtojcöteopexque. Ilpihuatöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ompa ijcataya Semu Piero omototunejtaya. Hua inu giente oquelfejque: ―¿Beles taja nuyejque tecaca sente imachtejque? Yaja oquenegöro, hua oquejto: ―Pues naja amo. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Sente esclavo de tlajtojcöteopexque oyeya de ifamilia de öquenuju Piero oquenacastejtec. Yaja oquelfe Piero: ―¿Amo temetzejtac naja ica Jesús mismo ompa cöne cuajcamac? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Hua Piero ocsajpa quenegöro. Hua nima otzajtzec canteliex. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Entunses tiebicaque Jesús de itlac Caifás ca pa inu palacio noso Pretorio cöne chönteya inu cubernadur que itucö Pilöto. Hua cualco oyeya. Hua yejua amo ocalajque ipa Pretorio para majcamo mopetzonelucö porque quenequeya yesque chepöjque para cuale quecuösque inu tlacuale de pöscua. Pues tlö joriojte calaque ipa inchö de tli amo joriojte, quejtoa yejua que ye omopetzonelojque. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yecuöquenu oquis Pilöto ca queyöhuac intlac, hua oquejto: ―¿De tli nenquetieyelfejtecate ini nönca tlöcatl? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Onöhuatque hua oquelfejque: ―Tlö ini nönca amo quechihuasquiöya tli amo cuale, amo temetzmomöctelisquiöne. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yecuöquenu oquejto Pilöto: ―Xecbicacö nemejua hua xecjuscörucö por nemoley. Hua joriojte oquelfejque: ―Mocubiernojtzi amo tiechpermitiroa yeca tecmectisque. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ejqueu oquejtojque para ma mochihua tietlajtultzi Jesús tli oquejtojque cuöc quenmacheste de tli mequelestle mecoas. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Entunses Pilöto ocsajpa ocalac ipa Pretorio hua otienutz Jesús. Otieyelfe: ―¿Taja tecaca terey de joriojte? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Onöhuatihuac Jesús: ―¿Tequejtoa ini nönca sampor tequejtoa noso yeca ometznunutz de naja? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilöto tienönquele. ―¿Beles nejoreyo naja? Amo, cache motlöcaicnihua, hua jefes de teopexcötzetzi metzmöctejque nomöpa. ¿Tli otecchi? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nöhuatihuac Jesús: ―Noreino amo icaca de nönca tlöltecpactle. Tlö neyene nerey de sente reino ipa ini nönca tlöltecpactle notlatequepanojua momagasquiöne para majcamo niechtiemöcticö inca joriojte. Al contrörio, noreino amo de necö. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Yecuöquenu tieyelfe Pilöto: ―¿Tlöjcu taja tecaca terey? Onöhuatihuac Jesús: ―Naja necaca nerey quieme taja tequejto. Pos para ini naja onetlöcat, hua onehuöla ipa nönca tlöltecpactle para ini, para ma necmelöjcopoa de lo que tlin melöhuac. Noche öque moneltoca ica tli melöhuac niechtiencaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Otieyelfe Pilöto: ―¿Hua tlin inu yaja lo que tli ica melöhuac? Hua cuöc oquejto ini nönca, oquis ocsajpa inca joriojte, hua oquemelfe: ―Naja amo nequejtelea niontle tlajtlacule. ");
INSERT INTO nhgNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Cache nemejua nenquepea costumbre, nele naja nemiechcajcöbeles sente tlöcatl ma quisa de ipan cörsel ipan pöscua. ¿Nenqueneque noso ma nejcajcöhua ini nönca Rey de joriojte? ");
INSERT INTO nhgNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Yecuöquenu innochtie otzajtzajtzeque ocsajpa, oquejtojque: ―Ini nönca amo xomocajcöbele, tlöcamo xomocajcöbele yaja Barrabás. Pos Barrabás oyeya ichtejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Entunses Pilöto tlanahuate ma tiemönelicö Jesús, hua ma tiebejbitequecö. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Hua soltörojte queyejyectienque sente coruna de betztle, hua tietlölelejque ipa tietzonteco hua tietlaquentejque ca tatapajtle mororojtec quiename möquea reyes. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Hua ohuölöya ca yejuatzi hua oquejtoöya: ―¡Ma neme Rey de joriojte! Hua tiecamatetlajtlatzcuepuniöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yecuöquenu Pilöto oquis ocsajpa, hua oquemelfe joriojte: ―Xequejtacö, necö necbicatz ca queyöhuac para nenquejtasque que naja amo tli tlajtlacule necniextelea. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Entunses oquixoac Jesús ca queyöhuac. Quebicaloöya inu coruna de betztle hua tietlaquie mororojtec. Hua oquemelfe Pilöto: ―Xequejtacö, nönca tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Hua cuöc tieijtaque jefes de teopexcötzetzi hua policías, otzajtzajtzeque: ―Xomocoruspelfe, xomocoruspelfe. Oquemelfe Pilöto: ―Xecönaco nemejua hua xejcoruspelucö, ipampa naja amo tli necniextelea tlajtlacule. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Oquenönquelejque joriojte: ―Tejua tecpea sente ley hua san quiene ca quejtoa inu ley ijteca ma meque ini nönca, ipampa quejtoa nele iloac tieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Hua cuöc Pilöto oquecac ini nönca tlajtule, omomajte cache. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hua ocalac ocsajpa ipa Pretorio hua otieyelfe Jesús: ―¿De cöne taja teca? Cache Jesús amo oquenönquelejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Yecuöquenu tieyelfe Pilöto: ―¿Naja amo teniechnönquelea? ¿Amo tecmate que naja necpea checöhualestle para temetzcajcöhuas, hua nuyejque necpea checöhualestle para temetzcoruspelus? ");
INSERT INTO nhgNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Onöhuatihuac Jesús: ―Niontle checöhualestle amo tecpeane ca naja, tlö amo metzmacasquiöya de tlacpac. Por inu öque niechmöcte ca taja cache bieye tlajtlacule quepea. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Desde cuöquenu quenequeya Pilöto tiecajcöhuas, cache joriojte tzajtzajtzeya, hua quejtoöya: ―Tlö ini nönca tomocajcöbelis, amo tomobetzteca teamigo de César. Öque beletes quejtoa que ica rey, ica enemigo de inu belaja rey César. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Entunses Pilöto cuöc oquecac ini nönca tlajtule, tiebicac Jesús ca queyöhuac hua omotlöle ipa sieta de tlajtoöne ipa inu löcor tli quecuitea Tepejpechtle, hua ca hebreo Gabata. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Hua ye oyeya viernes de inu semöna de pöscua hua quieme pan tlajca. Hua oquemelfe joriojte: ―Xequejtacö nemorey. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Cache yejua otzajtzajtzeque: ―Xomoquextele, xomoquextele. Xomocoruspelfe. Oquemelfe Pilöto: ―¿Nemorey nejcoruspelus? Onöhuatque jefes de teopexcötzetzi: ―Amo tecpea rey tlöcamo sa yaja César. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Entunses Pilöto tietiemöcte inca yejua para ma tiecoruspelucö. Hua otieaseque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Hua yejuatzi oquixoac, oquebicaloöya tiecorujtzi. Biloac hasta inu locör tli mocuitea Calaviera noso Locör de Mejcötzontecomatl, hua mocuitea ca hebreo Gólgota. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hua ompa tiecoruspelojque. Hua tieca quencoruspelojque unte ocseque, ca sie löro sente hua ca ocsie löro ocsente hua yejuatzi nepantla. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Hua oquejcuelo nuyejque Pilöto sente tucöyutl hua oquetlöle icpac corujtzi. Hua tlajcuelule ejqueyi oyeya: JESÚS DE PUIEBLO DE NAZARET, REY DE JORIOJTE. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Hua meyactie joriojte oquetlajtultejque ini nönca tucöyutl. Pues cöne tiecoruspelojque Jesús amo bejca oyeya de inu ciudad. Hua tlajcuelulpa oyeya ca hebreo, hua ca latín, hua ca griego. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Hua jefes de teopexcötzetzi de joriojte oquelfejque Pilöto: ―Amo xomojcuelfe, “Rey de Joriojte”, tlöcamo xomojcuelfe que yaja oquejto que ica Rey de Joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Onöhuat Pilöto: ―Tli onequejcuelo, ye onequejcuelo. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Hua cuöc soltörojte ye tiecoruspelojque Jesús, ocönque tietzotzomajua, hua oquechijque nobe pörtes, para cara siesente soltöro sente pörte. Hua nuyejque tietlaquie ocönque. Cache tietlaquie amo tlajtzöntle oyeya, tlöcamo noche intiero oyeya desde tlacpac. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Entunses omolfejque sente ca ocsente: ―Majcamo tectzomunicö, tlöcamo ma tecriförucö, abier öquenu quetlöne. Ejqueu oquechijque para ma mochihua tli tlajcuelulpanca cöne quejtoa: Quexiexelojque intzölö yejua notzotzomajua, hua queriförojque notlaquie. Hua soltörojte ejqueu oquechijque. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Hua itlac tiecorujtzi de Jesús ijijcataya tienönajtzi hua icni sohuatl de tienönajtzi, ca tiehua María, isohua Cleofas, hua nuyejque María de puieblo de Magdala. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Entunses Jesús oquejtaque tienönajtzi, hua inu tiemachtejque öque lalebes quetlasojtlaloöya, ompa ijcataya. Cuöquenu quelfejque tienönajtzi: ―Sohuatl, xomojtele niecaju moconietzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Entunses oquelfejque tiemachtejque: ―Xequejta niecaju monöntzi. Hua desde nieca ura inu tiemachtejque oquebicac tienöntzi ca ichö. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Sötiepa de ini nönca, cuöc Jesús oquematque que noche sösantle ye omochi, para ma mochihua tli tlajcuelulpanca, oquejtojque: ―Naja nömeque. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Hua ompa oyeya sente xoctle tientaya de pinögre. Entunses giente oquetiemitejque sente sunectle ca pinögre, hua queyehualuchtelejque sente tlacutl de hisopo, hua oquepachojque itlac tiecamac. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Hua cuöc Jesús ye oconihuac pinögre oquejtojque: ―Ye omosencö noche. Hua oquepiechojque tietzonteco, omecoac. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Hua oyeya viernes de inu semöna. Inu joriojte amo quenejnequeya ma mocöhuacö mimejque ipa coruscuajme ipa söbro, ipampa inu söbro bieye tunale de yelfetl oyeya. Por inu oquelfejque Pilöto ma quenpojpostequelicö imecxehua de niecate tli coruspelcataya para ma mejmequecö nima, hua ejqueu ma quemejcuenicö de ompa. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Hua ohuölajque soltörojte, hua oquenpojpostequelico imecxehua de inu unteme ocseque tli quencoruspelojque ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Cache ohuölajque tieca Jesús, hua tieijtaque quiene ye omecoac. Entunses ayecmo tiepojpostejquelejque tieicxehua. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Cache sente de inu soltörojte tietecoyöbele tiemesecuelnacastla ca ilönsa, hua sa nima oquis yestle hua ötzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Hua öquenu oquejtac yaja quepujteca. Hua ica melöhuac lo que tli quepoa. Hua yaja quemate que quejtojteca tli melöhuac. Ejqueu quechihua para que nemejua nuyejque ma xomoneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Pos ini nönca sösantle omochi para ma mochihua tli tlajculelulpanca: “Amo quepostequesque nion sente de tiememetehua”. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Hua nuyejque ocsente tlajcuelule quejtoa: “Tieijtasque öque tietecoyöjque”. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Sötiepa de ini nönca sösantle, Josie de Arimatea, öque oyeya tiemachtejque de Jesús, mös sa ichtecajtzi ipampa quenmabeliöya joriojte, yaja oquetlötlajte Pilöto para quejcuenis tiecuierpo Jesús. Hua Pilöto oquecö ma quejcuene. Yecuöquenu ohuöla hua oquejcuene tiecuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Hua ohuöla nuyejque Nicodemo, öque tli cachto ohuöla tieca Jesús ca yohuale. Yaja oquehualecac quieme cincuenta kilos de pajtle tli mocuitea mirra hua aloes para quequemelusque tiecuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Entunses oquebicaque tiecuierpo Jesús, hua oquequemelojque ca tzotzomajtle ca tiehua inu pajme san quiene ca quepea costumbre joriojte ca motojtuca. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hua ca ompa cöne tiecoruspelojque oyeya sente locör cuajcamac hua ijtec cuajcamac oyeya sente mejcöustutl yancuec cöne ayemo öque motuca. ");
INSERT INTO nhgNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ompa noso quetlölejque tiecuierpo Jesús, porque oyeya viernes de inu semöna de pöscua de joriojte, hua inu nieca mejcöustutl sa nima ompa oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pos ipa primiero tunale de semöna, María Magdalena ohuöla itlac mejcöustutl ca ise cuöc oc tlajtlayohua oyeya. Hua oquejtac que inu tietetu ye omojcuene de itech pobielta de inu mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yecuöquenu otzecuintie, hua ohuöla ica Semu Piero, hua ca inu ocsente de tiemachtejcöhua öque quetlasojtlaloöya Jesús. Hua oquemelfe: ―Ye quebicaque tiecuierpo Tlöcatzintle de ijtec mejcöustutl, hua amo tecmate cöne quetlölejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Hua oquistiejque Piero hua inu ocsente machtejque, hua uyajque cöne oyeya mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Hua omomiemerojque innehua. Hua inu ocsente tiemachtejque cache omomero que Piero hua oaseto cachto itlac mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Hua otlachix hua oquejtac tatapajme ompa betztaya. Cache amo ocalac. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Entunses oaseto Semu Piero nuyejque, öque quetocaya, hua ocalac ijtec mejcöustutl hua oquejtac tatapajme betztaya. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Hua inu cuötzotzomajtle tli oyeya ipa tietzönteco amo betztaya ica ocseque tzotzomajme tlöcamo tejcuextaya ipa locör nencua. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Yecuöquenu ocalac inu ocsente machtejque nuyejque, öque ohuöla cachto itlac mejcöustutl. Hua oquejtac hua omoneltocac. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pos ayemo quemateya tli tlajcuelulpa oyeya, que quepeaya que mochihuasquea ejqueu ma yulebihua de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Hua omocuejque tiemachtejcöhua ca inchajchö. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pos María oyeya ca queyöhuac chucataya itlac mejcöustutl. Entunses cuöc ochucataya otlachix ijtec mejcöustutl. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hua oquemejtac unte öngeles motlajtlaquentejtaya ica tzotzomajtle istöc. Oyejyehuataya sente cöne ca oyeya tiecuötzoncuöc hua ocsente cöne ca oyeya tieicxetla, cöne oquetlölejque tiecuierpo Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Hua oquelfejque: ―Sohuatl, ¿tlica techuca? Oquemelfe: ―Ipampa ye tiebicaque noTlöcatzintle hua amo necmate cöne tietlölito. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Hua cuöc oquejto ini nönca, omocuec ca icuetlapa, hua tieyejtac Jesús ijcatihuataya. Cache amo quemateya tlö yejuatzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesús oquelfejque: ―Sohuatl, ¿tlica techuca? ¿Öquenu tectiemoa? Yaja oquepensöro beles yaja tlajpexque. Otieyelfe: ―Señor, tlö tejuatzi tetiemobiquele, xeniechmolfele cöne tetiemotlölelito, hua naja netiebicas. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesús oquelfejque: ―María. Omocuec yaja, hua otieyelfe ca hebreo: ―¡Rabboni! ―Quejtusneque, NoTiemachtejcötzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesús oquelfejque: ―Amo xeniechquejquitzque, ipampa ayemo netlejco tieca noTajtzi. Cache xebeya intlac nocnihua hua xequemelfe: “Netlejcus tieca noTajtzi öque nuyejque iloac nemoTajtzi, tieca noDeus öque nuyejque iloac nemoDeus”. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Uya María Magdalena quenpubelito tiemachtejcöhua que otieyejtac Tlöcatzintle, hua que yejuatzi oquelfejque ini nönca sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hua cuöc ye yohuac oyeya ipa inu nieca tunale, inu primiero tunale de semöna, tzötzactaya cöne tiemachtejcöhua omosentlölejque. Pos oquentzajtzajque pobieltajte ipampa quenmabeliöya joriojte. Yecuöquenu ohualiloac Jesús, hua nepantla de yejua onequetzaluc. Hua oquemelfejque: ―Xomoyulsiebicö. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Hua cuöc oquejtojque ini nönca, oquemejtetejque tiemöhua hua tiemesecuelnacastla. Hua tiemachtejcöhua opajpöjque cuöc tieijtaque Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yecuöquenu Jesús oquemelfejque ocsajpa: ―Xomoyulsiebicö. Ejqueu quiene ca oniechhualtitlanque noTajtzi, ejqueu nuyejque nemiechtitlane naja. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Hua cuöc oquejtojque ini nönca, oquemelpitzque hua oquenmelfejque: ―Xetieselicö Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Öque beletes tlöca nenquentlapojpolfisque intlajtlacul, ye tlapojpolfele icaca. Hua tlö nenquejtusque que intlajtlacul de seque ma impa mocöhua, ye impa mocöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Cache Tumös, sente de inu majtlactle huan ume, öque nuyejque mocuitea Dídimo (quejtusneque Cuhuötzi), yaja amo ompa oyeya ca yejua cuöc Jesús ohualiloac. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Entunses oquelfiöya ocseque tiemachtejcöhua: ―Tetieijtaque Tlöcatzintle. Cache yaja oquemelfe: ―Tlö amo nequejtas tiemöhua hua nejcalaquis nomajpel ijtec cöne cojcoyunteca de calöböste hua nejcalaquis nomö ijtec tiemesecuel, amo noneltocas de porsi. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Sötiepa de checuieye tunale tiemachtejcöhua oyejyeya ocsajpa tlaijtec, hua ca yejua oyeya Tumös. Ohualiloac Jesús, mös tzötzactaya pobieltajte, hua innepantla onequetzaluc. Hua oquemelfejque: ―Xomoyulsiebicö. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Sa nima oquelfejque Tumös: ―Xejcualeca momajpel necö hua xequemejta nomöhua. Hua xecbetlötzo momö, hua xejcalaque ijtec nomesecuel. Hua amo xeye ejqueu que amo tomoneltocane tlöcamo xomoneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tumös onöhuat hua otieyelfe: ―NoTlöcatzintle hua noDeus. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesús oquelfejque: ―Tomoneltocac, Tumös, ipampa teniechejtac. Cuale inmicnupel noche niecate tli moneltoca mös amo niechejtaque. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hua nuyejque oquechijque Jesús meyac ocseque sösantle de tietzöbetl imixtla tiemachtejcöhua. Cache amo nequemejcuelo ipa ini nönca ömatl. ");
INSERT INTO nhgNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Noche tli quepea nönca ömatl onequejcuelo para ma xomoneltocacö que Jesús iloac Cristo, öque Deus tieixpejpenque, hua que iloac tieConietzi Deus. Pues tlö nemoneltoca nenquepeasque nemelestle tietucöyupantzinco. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Sötiepa de ini nönca sösantle oneniextiluc Jesús ocsajpa inca tiemachtejcöhua ipa inu ötiescatl de Tiberias. Hua ejqueyi opasöre. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sa secne oyejyeya Semu Piero, hua Tumös, öque mocuitea Dídimo (quejtusneque Cuhuötzi), hua Natanael, öque oyeya de Caná de Galilea, hua ipeljua Zebedeo, hua oc unte de tiemachtejcöhua. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Oquemelfe Semu Piero: ―Neya netlajtlamöti. Oquelfejque: ―Teyabe tejua nuyejque ca taja. Uyajque hua tlejcoque ipa sente börco, hua pa inu yohuale amo tli ocaseque. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Hua cuöc ye tlaniestaya Jesús onequetzaluc itienco ötiescatl. Cache tiemachtejcöhua amo quemateya tlö yejuatzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Entunses Jesús oquemelfejque: ―Pelantotu, amo nenquepea tli nenquecuösque ¿motiel? Tienönquelejque: ―Amo. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Hua yejuatzi oquemelfejque: ―Xectlajcalecö tarröya ca imöyecömpa börco, hua nenqueniextisque. Yecuöquenu oquetlajcalque ca ompa, hua öxö abele quequextiöya, ipampa lalebes meyactie mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Yecuöquenu inu nieca tiemachtejque öque quetlasojtlaloöya Jesús oquelfe Piero: ―Yejuatzi Tlöcatzintle iloac. Entunses Semu Piero, cuöc oquecac que yejuatzi Tlöcatzintle, omotlajcoilpe ca itzotzomajua, pues ye oquequexte itlaquie. Hua omotlajcal ijtec ötzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Cache ocseque tiemachtejcöhua ohuölajque pa börco (pues amo bejca oyejyeya de itiencö ötiescatl tlöcamo quieme sie sientos mietros), hua quehualecaya tarröya ca mimechte. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Hua cuöc ohuölajque cöne tlölhuöjque, oquejtaque que ompaca tletzintle de tecole, hua sente meche icpac, hua pöntzi. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Oquemelfejque Jesús: ―Xejcualecacö mimechte tli quiemach nenquemaseque. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Entunses otlejcoc Semu Piero ipa börco, hua oquehualecac tarröya ca ipa tlölhuöjque. Hualtientöya ca meyactie mimechte bejbeye. Oquepex ciento cincuenta y tres. Hua mös meyactie oyejyeya amo otzomu tarröya. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Oquemelfejque Jesús: ―Xehuölöcö, xetlacuöcö. Hua nionöque de tiemachtejcöhua amo quenequeya tietlajtlanesque: ―¿Öquenu tejuatzi? Pues quemajtaya que bel yejuatzi Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ohualiloac Jesús hua ocönque pöntzi hua oquenmajmacaque, hua meche nuyejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ca ini nönca ye oyeya yexpa neniextiloöya Jesús inca tiemachtejcöhua sötiepa de cuöc oyulebihuac de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Hua cuöc ye otlacuajque, Jesús oquelfejque Semu Piero: ―Semu, iconie Xohuö, ¿teniechtlasojtla cache que ini nöncate? Otieyelfe: ―Quiema, noTlöcatzintle. Tejuatzi tomomachitea que temetzmonequitea. Oquelfejque: ―Xequentlacualte nocalnielojcuconehua. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ca ujpa ocsajpa oquelfejque: ―Semu, iconie Xohuö, ¿teniechtlasojtla? Otieyelfe: ―Quienamo, noTlöcatzintle. Tejuatzi tomomachitea que temetzmonequitea. Oquelfejque: ―Xequenmixute nocalnielojua. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ca yexpa oquelfejque: ―Semu, iconie Xohuö, ¿teniechneque? Omotequepacho Piero ipampa oquelfejque öxö ca yexpa: “¿Teniechneque?” Hua otieyelfe: ―NoTlöcatzintle, tejuatzi tomomachitea noche sösantle. Tejuatzi tomomachitea que temetzmonequitea. Oquelfejque Jesús: ―Xequentlacualte nocalnielojua. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Melöhuac, melöhuac temetzelfea: Cuöc cache tepelalactle oteyeya, sie taja tomotlaquentiöya, hua teyöya cöne tecnequeya. Cache cuöc ye tebiebentzi, temösohuas para yeca ocsente metztlaquentis, hua metzbicas cöne taja amo tecneques. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Hua ini nönca oquelfejque para quemachestisque ica tli mequelestle mequesquea para que ejqueu quepeasque chamöhualestle Deus. Hua cuöc ye oquejtojque ini, oquelfejque: ―Xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nuyejque tlatocatöya nieca tiemachtejque öque quetlasojtlaloöya Jesús, öque nuyejque omonacascatiecac ipa tiepiecho cuöc otlacualuc, hua tietlajtlane Tlöcatzintle: “¿Öquenu metzmantrecörfis?” Öxö cuöc omocuec Piero, oquejtac nieca tlatocatöya. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Hua cuöc oquejtac ini nönca, otieyelfe Jesús: ―Tlöcatzintle, ¿hua ini tlöcatl, tli quepasörus? ");
INSERT INTO nhgNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Oquelfejque Jesús: ―Tlö quejtus que naja necneques ma yaja mocöhua hasta senamo naja nehuölös, ¿taja tli tecpea tequejtas ca inu? Pues taja xeniechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Entunses ini nönca tlajtule oquis intzölö tocnihua, nele ini nönca tiemachtejque amo meques. Cache Jesús amo oquelfejque que amo meques, tlöcamo oquejtojque: “Tlö quejtus que naja necneques ma yaja mocöhua hasta senamo naja nehuölös, ¿taja tli tecpea tequejtas ca inu?” ");
INSERT INTO nhgNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yaja ini nönca tiemachtejque ica öque quepujteca de ini nönca sösantle, hua oquejcuelo ini nönca sösantle. Hua tecmajtecate que lo que tli quepoa icaca melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Hua onca nuyejque ocseque meyac sösantle tli oquechijque Jesús, que tlö mojcuelusquiöya sente por sente, necnenebelea beles nimpor ipa noche tlöltecpactle amo aquesquiöya inu ömame tli mojcuelusquiöya.");
INSERT INTO nhgNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Temetzmojcuelfele antes, Teófilo. Temetzmolfele noche tli Jesús oquechijque hua otlamachtejque. Ejqueu oquechijque desde que oquepiehualtejque tieteque. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Oquesequirojque hasta cuöc Deus otiebicaque elfecac. Antes de que obiloac ca elfecac Jesús oquemixpejpenque inu majtlactle huan ume tietlateotitlanhua. Espíritu Sönto tiepaliebiluc Jesús para oquenmacaque mandamientos. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Sötiepa de que omecoac Jesús, oneniextiluc intzölö yejua. Oneniextiluc meyac veces ipa cuarenta días. Ca meyac sösantle tli oquechijque quemejtetejque perfectamente que yulebihuateca. Oquennunutzaloöya de quiene Deus tlamandöruro. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Mientras onecöhualuc ca yejua oquenmandörojque nele majcamo yöcö de Jerusalén. Oquejtojque: ―Xeccheacö ma mochihua lo que tli toTajtzin Deus oqueprometierojque. Ye onemiechelfe de inu. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Tiel Xohuö otlacuötieque ca ötzintle, cache pa quiesquete tunalte nemocuötiequisque ca Espíritu Sönto cuöc yejuatzi calacoas ipa nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Cuöc ye omosentlölejque tlateotitlanme, otietlajtlanejque Jesús: ―Tlöcatzintle, ¿öxö tomotlölelis tonación Israel ocsajpa para tlamandörus? ");
INSERT INTO nhgNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pos oquemelfejque: ―Amo nemiechtocöroa nenquematesque quiema mochihuas canajyetla quieme inu. ToTajtzin Deus oquemalfejque inu para que sa yejuatzi quejtusque hasta quiema Israel tlamandörus ocsajpa. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Cuöc calaquesque Espíritu Sönto pa nemoyulo nemejua, nencasesque checöhualestle. Nenquisasque quieme nentestigos de naja amo sa pa ciudad de Jerusalén tlöcamo ipa noche estado de Judea hua estado de Samaria hua hasta cache bejca locör pan tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Cuöquenuju Jesús opiehualuc neajcoquiluc ca elfecac mientras yejua tieyetztaya. Por fin ayecmo otieijtaque porque opolebihuac ijtec mextle. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Mientras Jesús biloaya, yejua ajcopatlajtlachixtaya. Sa de repiente intlac omoquetzaco unte öngeles ca intlaquie istöc. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Oquemelfejque: ―Señores de estado de Galilea, ¿tlica nentlajtlachixtecate ca elfecac? Deus tieönaluc Jesús de entre nemotzölö hua otiebicaque hasta elfecac. Pos quieme onentieijtaque obiloac elfecac, ejqueu mismo sie yejuatzi Jesús hualiloas ocsajpa. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Yecuöquenu tietlateotitlanhua uyajque de ipa nieca tepietl tli itucö Tepietl de Olivos. Inu tepietl mocöhua itech Jerusalén, quieme sie kilómetro ca bejca. Omocuejque ca Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Cuöc ocalajque pa Jerusalén, otlejcuque ipa sente calejtec icpac cale. Ompa mocalutiöya Piero, Xohuö, Jacobo, Andrés, Felipe, Tumös, Bartolomé, Mateo, Jacobo iconie Alfeo, Semu el Celador, hua Judas iconie de Jacobo. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Yejua ompa oyejyeya ca tiehua seque sohuame hua María tienönajtzi Jesús hua tieicnihua Jesús. Nochemejua seme ca sa sie tlanequelestle motlajtlötlajtiöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Cuöquenuju Piero omoquetz intzölö inu hermanos tlö quieme ciento veinte ca meyactie. Oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","―Nocnihua, David oquejcuelo lo que tli Espíritu Sönto oquejtojque de Judas. Hua inu teotlajtule quepeaya ma mochihuate. Pos Judas oquenyecö tli tieaseque Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Totzölö oyeya Judas hua quepeaya ipörte de nönca tequetl de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pos inu Judas oquecu sente tlöle. Oquetlaxtlö ca inu tomi tli oquemacaque por itlajtlacul. Ixtlajpach betzeto. Oijtepetzi hua noche tli ijtecajca ocuaxiele. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Oquematque noche tli chajchönte pa Jerusalén hua oquecuitejque nieca tlöle Acéldama, que ca intlajtul de yejua quejtusneque Tlöle de Yestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","―Pos tlajcuelulpanca ipa libro de Salmos: Ma quisa de ipa ichö, hua majcamo öque ompa chönte. Nuyejque quejtoa pa Salmos: Ma yeca ocsente case inu tequetl tli yaja oquepeaya. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Conbenierebe, noso, ma mixpejpena sente tlöcatl de intzölö nöncate tlöca. Ma mixpejpena sente tlöcatl tli seme totlac icaca desde cuöc Tlöcatzintle Jesús biloatenemeya totzölö. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ma mixpejpena sente de yejua tli seme totlac icaca desde cuöc Xohuö tiecuötieque Jesús hasta öxö cuöc Deus tieönaluc de totzölö para ca elfecac. Conbenierebe que yaja san quiene ca oquejtac noche inu sösantle ma iye testigo ca tejua de quiene ca oyulebihuac Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pos yejua oquenquetzque unteme. Sente yaja Josie Barsabás, öque nuyejque mocuitiöya Justo. Hua ca ume yaja Matías. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Entunses omotlajtlötlajtejque ejqueyi: ―Tlöcatzintle, tejuatzi tequemixomachelea toyulo de tonochtie. Xetiechmojtetele öquenu ye otemixpejpenele de nöncate unteme. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ye otemixpejpenele sente para ma quechihua nönca motequeyojtzi de que iyes tlateotitlantle. Pos Judas ye oquecöjtie para iyös pa inu locör tli quetocöro. ");
INSERT INTO nhgNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Entunses oqueriforojque abier öque quetocörus. Pos oquetocöro yaja Matías. Así es que yaja omopu inca inu majtlactle huan sie tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Cuöc oaseco inu yelfetl de Pentecostés, noche inu creyentes oyejyeya sa secne ipa sie locör. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Sa de repiente ocaquestec checöhuac sente ruido tli ohuöla de elfecac. Bel checöhuac ocaquestec ompa calejtec cöne yejua oyejyehuataya. Ocaquestec quiename sente yejyecatl cuöc checöhuac tlalpitza. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Inca yejua omoniexte sana imöönalo tletzintle. Pos inu sana imöönalo tletzintle omocuöxielo hua omotlölito ipa cara sesen tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Hua inyulo de innochtie otie de Espíritu Sönto. Entunses yejua opiejque tlajtlajtoa ca ocsesen idiomas tli Espíritu Sönto oquenmacaque ma quejtucö. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pa inu yelfetl joriojte tli lalebes moneltocaneme ohuölajque hasta pa ciudad de Jerusalén. Ohualiejque de ipa noche ocseque naciones. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Cuöc yejua oquecajque inu ruido, sa nima omosentlölejque meyactie. Oquetietzöbejque porque oquecaqueya que inu creyentes otlajtlajtoöya ca idiomas de cara sesen tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Pos yejua sö otlacactaque hua oquetietzöbejtajque. Oquejtojque: ―¿Pos quie amo yejua de estado de Galilea tli tlajtlajtojtecate? ");
INSERT INTO nhgNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Quiene, noso, tequencaque tejua que tlajtlajtoa ca belaja toidioma de cara sesen tlöcatl quieme tejua tetlajtlajtoa desde cuöc otetlajtlöcatque? ");
INSERT INTO nhgNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Pos oncöncate giente de meyac naciones. Oncate de Partia, de Media, de Elam, de Mesopotamia, hua tli chajchönte ipa Judea, hua ipa Capadocia, ipa Ponto hua ipa Asia. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Cate de Frigia hua Panfilia, de Egipto hua de noche pörtes de Africa ca nepa löro de inu puieblo de Cirene. Nuyejque oncate de Roma tli oncö chajchönte. Seque de yejua cate joriojte hua ocseque mös amo joriojte ye ocalajque ipa toreligión. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Oncate nuyejque giente de tlöle de Creta hua de Arabia. Pos tonochtie tequenyejcaque que tlajtlajtoa ipa totlajtul quieme tejua tetlajtlajtoa. Tiechpubelea de quiene ca Deus oquechijque tietzöbetl tlachihuale. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pos innochtie oquetietzöbejtaya. Amo oquematque quiene oquepensörojque. Omolfejque: ―¿Tli quejtusneque ini tli mochijteca? ");
INSERT INTO nhgNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Cache ocseque omoburlörojque. Oquejtojque: ―Pos nöncate ye otlöhuönque ca meyac vino tli tzopielec. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Yecuöquenu Piero omoquetz ca tiehua inu majtlactle huansie tlateotitlanme. Oquejto: ―Señores nenjoriojte hua tli nennejneme pa Jerusalén. Xecyejcaquecö tli nequejtus hua xecmajtacö nönca. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ini nöncate tlöca amo bejbentetecate quieme nemejua nenquenenebelea. Pos quiemach tecate pa checnöbe ura ca ise. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nönca mochijteca lo que tli Deus oquejtojque por icamacopa de inu tlayulepante Joel ca ye niepa: ");
INSERT INTO nhgNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Quejtulo Deus: “Ejqueyi mochihuas ipa niecate sölúltimo tunalte. NoEspíritu nequenmacas noche tlöca. Nemotielpuchhua hua nemoichpuchhua tlayulepantisque de tietlajtultzi Deus. Nuyejque tlacocheyejtasque tli de nemejua ayemo biebentzetzi, hua tlacochtiemequesque tli biebentzetzi de entre nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Melöhuac. Ipa niecate tunalte noEspíritu nequenmacas inu tlöca hua sohuame tli niechtequepanusque, hua yejua tlayulepantisque de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Giente quetietzöbejtasque lo que tli necchihuas ompa elfecac, hua pan tlöltecpactle necchihuas sieñas ca yestle hua ca tletzintle hua ca puctle. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tunale ayecmo quetiemacas itlaniexteles, hua mietztle chichiliebes quiename yestle antes que tecalaquesque pa inun tunale de Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Inun tunale bieye iyes, hua tlatieniehuale. Hua mochihuas que momöquextisque innochtie tli tietlajtlanelisque nemöquextelestle tietucöyupantzinco Tlöcatzintle”. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","’Señores de tonación Israel, xejcaquecö de lo que tli nequejtus. Jesús oiloaya de puieblo de Nazaret. Deus otieixpejpenque. Ye nenqueyecmate inu porque Jesús oquepexque meyac checöhualestle nemotzölö para oquechijque tietzöbeme hua sieñas hua bieye tlachihualestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ini nöiloac Jesús Deus otietiemöctejque ca nemejua, porque ejqueu Deus oquetzontejque antes hua oquematque que quechihualusquiöya ejqueu. Hua inmöcopa giente petzoteque nentiecoruspelojque Jesús hua ejqueu onentiemectejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Deus otieyulebitiluc Jesús hua otiequextiluc de ipa mequelestle. Pos abele necöhualus ipa mequelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David otlajtlajto de Cristo hua oquejto: Seme biloateneme Tlöcatzintle ca naja. Amo niechtlajcales tequepachule porque yejuatzi iloac ca nomöyecömpa para niechpaliebilo. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Por inu noyulo opajpöc, hua ca nocamac onequejto de ini nönca nopajpöqueles. Nuyejque naja necpea meyac confiönsa hua nemöchealestle que nocuierpo yulebes. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Porque tejuatzi amo tomocöbelis noölma ma seme mocöhua ipa mectlöncale, nimpor amo tomocöbelis nocuierpo ma palöne, porque naja nemoConietzi hua neyectec. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Oteniechmojtetele ojtle tli nectocas para necpeas nemelestle nochepa. Teniechmomaquelis pöquelestle porque seme temetzmotztelejtas. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","’Señores, nemiechelfis claramente que totajtzi David omec hua omotlöltucac. Hasta öxö oncönca imejcöcoyoc. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pos David oyeya tlayulepante hua quepoaya tietlajtultzi Deus. Oquemat que lo que tli Deus oquejtojque que quechihuasque para David, Deus quecumplirusque de melöhuac. Pos Deus oquejtojque ca juramento que yejuatzi quixpejpenasque sente de ipelhua para tlamandörus quieme rey itequepa David. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Inu ocasojcömat David ca ye niepa. Oquejto noso de quiene Cristo yulebihuas, pos oquejto que Deus amo quecöhuasque tieölma ipa mectlöncale meyac tiempo. Nimpor amo palönes tiecuierpo. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pos inu Cristo iloac bel yejuatzi Jesús. Deus otieyulebitiluc hua tejua tecate tetestigos de inu. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Así es que Deus otiemacuc beletelestle para netlölilus ca tiemöyecöntzi. Yecuöquenu toTajtzi Deus otiemacuc Jesús tieEspíritu Sönto quiename ca ye niepa tieprometierfejque. Öxö Jesús tiehualtitlanuc Espíritu Sönto öque quechihualuteca nönca tli nemejua nenquejta hua nenquecaque. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pos amo yaja David que otlejcuc ca elfecac. Tlöcamo David oquejto ejqueyi: Tlöcatzintle otieyelfe noTlöcatzi: “Xomotlöle ca nomöyecömpa ");
INSERT INTO nhgNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta senamo ma nequemumiyöro moenemigos hasta itzintla mocxehua”. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","’Nemejua onentiecoruspelojque Jesús. Pero xecyecmajtacö nemonochtie de Israel, que Deus ye otiemacuc miero yejuatzi Jesús beletelestle para que iloac Tlöcatzintle, hua iloac Cristo, öque Deus tieixpejpenque para iloas tlamöquextiöne. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Cuöc inu giente oquecajque inu, lalebes omoyulcocojque. Oquemelfejque Piero hua ocseque tlateotitlanme: ―Tocnihua, ¿tli noso tecchihuasque? ");
INSERT INTO nhgNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pos Piero oquemelfe: ―Xomoyulcuepacö hua xomocuötiequicö tietucöyupantzinco Jesucristo cara sesen tlöcatl de nemejua. Ejqueu Deus nemiechperdonörfisque nemotlajtlacul hua nemiechtlöocolisque tieEspíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Pos cuale nenqueselisque lo que tli Deus queprometierojque nemejua ca tiehua nemopelhua hua nochemejua tli bejca cate, innochtie quiejquech Deus quennutzasque. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pos ca meyac ocseque tlajtule Piero oquennunutz hua quentlalfiöya. Oquejto: ―Xomomöquexticö de intzölö nöncate tlöca yulpetzoteque. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Entunses omocuötiequejque noche giente tli oquenparesiero inu tlajtule. Pa niecaju tunale omaxiltejque ca yejua oc yeye mil tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Inu creyentes oquesequirojque momachtejque ca inu tlateotitlanme. Oquepeaya gusto yesque intzölö imicnihua. Sa secne otlacuöya hua motlajtlötlajtiöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Noche giente tiemabelejque Deus. Hua Deus oquenpaliebejque tietlateotitlanhua para que yejua oquechijque meyactie sieñas hua tietzöbeme. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Noche quiejquech omoneltocaya, sa secne oyejyeya. Tli oquepejpeaya oquexiexelojque ca ocseque imicnihua. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Oquenajnamacaya noche intlölhua hua lo que tli oquepeaya. Entunses oquenxiexelfiöya innochtie san quiejquech oquenchibeliöya fölta. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Innochtie ca sentetl inyulo omosentlölejque mumustla ipan teopantle bieye. Otlacuöya chöntle por chöntle ca meyac pöquelestle hua yulsiebelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Otieyectieniejque Deus, hua noche giente oquentlöcayejtaque yejua. Cara tunale omomeyaquelejque quiejquech Deus quenmöquextisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Piero hua Xohuö otlejcoque ca teupa bieye quieme ca pa yeye ura ca ye yohuac ipa ura de oración. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Seque giente seme quehualecaya sente tlöcatl tli cucuxojtzi desde que otlöcat. Mumustla oquetlöliöya ompa pa teopantle bieye itech queyöhuatientle tli mocuitea la Hermosa. Oquetlöliöya ompau para motlaijtlanis ca tli cöcalactaya teupa. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cuöc inu tlöcatl oquemejtac Piero hua Xohuö que ye calaquesque pan teopantle, omotlaijtlane ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piero hua Xohuö oquetejteijtaque. Entunses oquejto Piero: ―Xetiechejta. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Yecuöquenu yaja quemetztaya. Quechixtaya ma canajyetla quemacacö. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Piero oquejto: ―Amo necpea plöta nimpor oro, pero lo que tli necpea temetzmaca. Tietucöyupantzinco Jesucristo de Nazaret xenejneme. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Yecuöquenu Piero ocasec ca imöyecmö hua oquequetz. Sa nima omoyectlölejque icxehua hua icöcayolhua. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Yecuöquenu omoquetztie. Omoquetz hua onejne. Ocalac ca yejua ipan teopantle. Ompa onejnemeya hua ajcotzecuineya. Otieyectieniehuaya Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Noche giente oquejtaque que yaja nejnemeya hua otieyectieniehuaya Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Oquixomatque inu tlöcatl que oyeya yaja öque motlaijtlanejtaya ompa teupa itech inu queyöhuatientle itucö la Hermosa. Pos oquetietzöbejque lalebes por lo que tli omochi ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inu tli oyeya cucuxojtzi moquejquitzquejtaya intech Piero hua Xohuö. Noche giente mosentlöliöya intlac yejua ipa corredur itucö Corredur de Salomón. Lalebes quetietzöbiöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Cuöc Piero oquejtac que giente mosentlöliöya, oquemelfe: ―Señores de tonación Israel, ¿tlica nenquetietzöbea ini nönca? ¿Tlica nentiechetztecate tejua quieme tlö ca tobeleteles de tejua otecpajtejque nönca cucuxojtzi para ma nejneme? Noso ¿tlica nentiechetztecate quieme tlö por teyecteque otecpajtejque? ");
INSERT INTO nhgNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham tieteochihuaya Deus. Nuyejque Isaac hua Jacob hua noche totötajua tieteochihuaya. Yejuatzi miero Deus de totötajua iloac öque quepajtejque nönca cucuxojtzi. Oquepajtejque para tiechajchamöhualuc Jesús öque iloac tieTlatequepano. Pos nemejua nentietiemöctejque Jesús ca Pilöto hua nenquejtojque que amo nentienequeya cuöc Pilöto oquenec tiecajcöhuas. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Pos nemejua nenquejtojque que amo nentienequeya Jesús öque yectec hua yulmelactec, cache nentlajtlanque ca Pilöto ma quecajcöhua sente mequestiero ma quisa ca nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Pos nentiemectejque miero yejuatzi öque tiechnemitilo. Bel yejuatzi Jesús Deus tieyulebitiluc de intzölö mimejque, hua tejua tecate tetestigos de inu. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ini nönca tlöcatl oyeya cucuxojtzi. Nemejua nenquejta hua nenquixomate. Pos Deus oquepajtejque yaja, porque tejua toneltoca tietucöyupantzinco Jesús. Pos tiel por toneltoca tieca Jesús, yejuatzi queyecpajtejque nönca tlöcatl nemixpa nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Hua öxö, nocnihua, naja necmate que nentiemectejque Jesús porque amo nenquemajmatque tli nenquechihuaya. Nuyejque tlötlajtoönejme de nemejua amo quematque tli oquechijque. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ca ye niepa Deus oquemelfejque por incamacopa tlayulepantejque que tiepa tieCristo huölösquiöya tiecoco tietunie. Hua öxö pa nönca tiempo de tejua Deus oquecumplirojque tli antes oquejtojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Así es que xomoyulcuepacö hua xomocuepacö ca Deus para ma nemiechperdonörucö nemotlajtlacul. Yecuöquenu Deus cualtitlanesque tiempos de yulpöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Entunses Deus ocsajpa tiehualtitlanesque Cristo öque yejuatzi otieixpejpenque, es decir, tiehualtitlanesque yejuatzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pos onca nesesidad que Jesús ompa iloas elfecac hasta senamo asequi tiempo cuöc noche sösantle ye ocarreglörojque Deus. Yejuatzi otlajtlajtojque de inu tiempo desde ca ye niepa por incamacopa tlayulepantejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pos Moisés oquemelfe totötajua: “Quieme Tlöcatzintle toDeus oniechtitlanque naja, nuyejque tiehualtitlanesque ocsente tlayulepante. Tieixpejpenasque de entre nemotzölö. Nenquecaquesque noche tli nemiechelfisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Öque beletes tli amo quechihuas cöso de inu tlayulepante, Deus quepojpolusque de intzölö tiepelhua”. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","’Noche tlayulepantejque desde Samuel para ca necö, otiechyulepantejque de nönca tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nemejua nencate nenimpelhua de inu niecate tlayulepantejque. Nemiechtocöroa inu acuierdo tli Deus oquechijque ca totötajua. Deus oquelfejque Abraham: “Por medio de mopelhua nequenteochihuas giente de noche naciones”. ");
INSERT INTO nhgNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Deus tieyulebitiluc *tieTlatequepano. Tiehualtitlanque ca nemejua cachto para que tieConietzi ma nemiechbendeseyumacacö. Oquechijque ejqueu para ma quisa cara sesen tlöcatl de ipa itlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piero hua Xohuö oc tlajtlajtojtaya ca giente cuöc ajaseto teopexcötzetzi. Jefe de guardia de teopantle bieye hua inu grupo de joriojte itucö saduceos nuyejque ajaseto ompa. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Innochtie ocuajcualöneya porque Piero hua Xohuö quenmachtejtaya giente. Oquejtojque Piero hua Xohuö que yulebesque giente de intzölö mimejque porque Jesús oyulebihuac. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Entunses oquemaseque Piero hua Xohuö hua oquentzajtzajque para ma ompa yecö hasta pa mustlateca. Pos ye yohuac oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero meyactie de tli oquecajque tietlajtultzi Deus omoneltocaque. Tlö mopoasque sa tlöca, quieme cinco mil ye moneltocaya. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pa mustlateca tlajtoönejme hua biebentzetzi de joriojte hua tlamachtiöneme de teotlajtule omosentlölejque pa Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nuyejque omosentlöle ca yejua tlajtojcöteopexque Anás, nuyejque Caifás, Xohuö hua Alejandro hua noche yejua quiene quemejta tlajtojcöteopexcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Quenhualecaque Piero hua Xohuö ca intzölö yejua hua quentlajtlanejque: ―¿Ca tli beletelestle, noso itucöyupa de öquenu nenquepajtejque inu tlöcatl cucuxojtzi? ");
INSERT INTO nhgNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Yecuöquenu Piero oquemelfe ca checöhualestle de Espíritu Sönto: ―Señores nentlötlajtoönejme. Señores nenbiebentzetzi, xomocaquiticö. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Öxö ye nentiechmotlajtlanelejque de nönca tlöcatl cucuxojtzi que ye opajtec. Nemotlajtlanea quiene noso opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nemejuantzetzi nentiemocoruspelfejque Jesucristo de puieblo de Nazaret, pero Deus tieyulebitiluc de intzölö mimejque. Xomomachitejtacö nemonochtientzetzi. Nuyejque ma quemajtacö noche tlöca de Israel. Pos nönca tlöcatl tli oncönca nemotzölöntzinco ye opajtec tietucöyupantzinco Jesucristo de Nazaret. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Así es que nemejuantzetzi nemobetztecate quiename nenölbañilte. Jesús iloac quiename sente cuale tietetu. Inu tietetu tlin cuale nemejuantzetzi nemotlajcalelejque. Hua öxö inu tietetu ye hualmochi esquiniero de tepöntle. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Pos nionöque ocsente cuale tiechmöquextis, porque amo onca ocsente tlöcatl tli Deus tiechmacaque para itech ma tomöquexticö. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Teopexcötzetzi oquejtaque que Piero hua Xohuö quepeaya meyac balur. Oquematque que amo bel tlaestudiörojque tlöcamo cate quieme cualquiera. Pos quetietzöbejque. Cuöquenuju omomacaque cuienta que nele oyejyeya ca Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Quetztaya que niecaju tlöcatl tli opajtec ijcataya ca Piero hua Xohuö. Por causa de inu tlöcatl tli opajtec abele tli oquejtojque cuntra Piero hua Xohuö. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Entunses yejua quennahatejque Piero hua Xohuö nele ma quisacö tepetzi de ipa inu junta. Cuöquenuju molfiöya entre yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Oquejtojque: ―¿Tli tequenchibelisque nöncate tlöca? Melöhuac, sente tietzöbetl bieye ye oquechijque. Noche giente tli cate pa Jerusalén ye oquejtaque. Abele tequijyönasque. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Sin embargo, para amo cache mosoas ini tlajtule ca ocseque giente, ma tequenmajmajcömecticö Piero hua Xohuö para ma ayecmo tlanunutzacö de Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Entunses ocsajpa quentzajtzelejque Piero hua Xohuö ma calaquecö. Quennahuatejque nele majcamo tlajtlajtucö nimpor majcamo tlamachesticö de Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Yecuöquenu Piero hua Xohuö onöhuatque: ―Xomonenebelejtzinucö tlö conbenierebe para ca Deus ma tetlaneltocacö ca nemejuantzetzi noso cache cuale ma tetieneltocacö Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pero de todos modos abele tectzacuasque tocamac de lo que tli otequejtaque hua de lo que tli otejcajque. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Entunses inu tlötlajtoönejme quenmajmajcömectejque Piero hua Xohuö hua quencajcöjque ma yöcö. Abele queniextejque de tli maniera quencastecörusque. Pos quenmabeliöya giente porque giente tiechajchamöjque Deus por tli yejua quechijque. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Niecaju tlöcatl tli opajtec oquepex cache de cuarenta años cuöc opajtec. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Cuöc ye oquencajcöjque Piero hua Xohuö, yejua ohuölajque intlac incompanieros. Quenpubelejque noche lo que tli jefes de teopexcötzetzi hua biebentzetzi de joriojte oquemelfejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Cuöc oquecajque inu, innochtie omotlajtlötlajtejque ca Deus. Oquejtojque: ―ToTiecojtzi Deus, tejuatzi tomochejchibele elfecac, tlöltecpactle, hua lamör, hua noche tli quepea. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Por medio de Espíritu Sönto icamacopa de totöta David motlatequepanojtzi tomojtalfe ejqueyi: ¿Tlica otlabielchöchalönque giente? ¿Tlica quenenebelejtaya tlimach tli yejua abele quechihuasquea? ");
INSERT INTO nhgNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Omosentlölejque reyes de noche tlöltecpactle. Nuyejque tlötlajtoönejme omochijque quieme sasie tlöcatl cuntra Deus hua cuntra Cristo öque yejuatzi tieixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","’Pos melöhuac Herodes hua Poncio Pilöto mosentlölejque pa nönca Jerusalén ca nieca giente tli amo joriojte hua ca togiente de Israel. Omosentlölejque cuntra Jesús moTlatequepanojtzi yectec öque tetiemixpejpenele. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Oquechijque lo que tli ca ye niepa tomotzontequele que tomochibelis porque tomonequite ma ejqueu mochihua. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Hua öxö, Tlöcatzintle, xomojtele quiene queneque tiechmajmajcömectisque. Xequenmopaliebele motlatequepanojcötzetzihua ma tlajtlajtucö de motlajtultzi ca meyac balur. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Xomotequetelejta para ma pajtecö giente. Ma mochihua sieñas hua tietzobeme tietucöyupantzinco Jesús *moTlatequepanojtzi yectec. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cuöc ye omotlajtlötlajtejque omouline cale cöne yejua otlamachyejyeya, quiename cuöc otlöoli. Innochtie ocaseque checöhualestle de Espíritu Sönto. Entunses otlanunutzque de tietlajtultzi Deus ca meyac balur. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nochemeju tli omoneltocaque sasie quemachelejque hua sasie quepensörojque. Nionöque amo oquejto que lo que tli quepeaya sa yaja ihuöxca tlöcamo quejtoöya que oyeya inhuöxca innochtie. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Tlateotitlanme oquesequirojque tlanunutzque quiene ca Tlöcatzintle Jesús oyulebihuac. Quepexque meyac beletelestle hua Deus quenpaliebejque lalebes. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Amo omocö nionöque majcamo quepea de lo que tli quechibeliöya fölta. Noche tli quepeaya intlöl noso incalhua quennamacaque hua quehualecaque inu tomi. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Inu tomi quemacaque tlateotitlanme, hua yejua quenxiexelfejque nochemeju tli quenchibeliöya fölta. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Por ejiemplo, oyeya intzölö yejua sente levita joreyo itucö Josie. Tlateotitlanme quecuitejque inu tlöcatl Bernabé, tli quejtusneque sente tlöcatl tli tlayulölea. Otlöcat pa sente tlöltojpole ipa lamör que itucö Chipre. ");
INSERT INTO nhgNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Bernabé oquenamacac sente itlöl tli yaja quepeaya. Quehualecac inu tomi hua oquemacac tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sente tlöcatl itucö Ananías ca isohua Safira nuyejque oquenamacaque intlöl. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananías oquejyö seque tomi hua seque oquetiemacato. Oquenmacato tlateotitlanme inu pörte de tomi quieme tlö oyene noche. Nuyejque isohua oquemat. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Oquejto Piero: ―Ananías, ¿tlica Satanás oquetlöle ipa moyulo para tistlacates ca Espíritu Sönto? ¿Tlica otequejyö seque tomi de quiejquech ca otecnamacac motlöl? ");
INSERT INTO nhgNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mientras tecpeaya motlöl, ¿amo mohuöxca oyeya? ¿Hua cuöc otecnamacac, ¿amo mohuöxca inu tomi? ¿Tlica otecpensöro tecchihuas ejqueu? Amo otistlacat sa ca tlöca tlöcamo otistlacat miero ca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Cuöc Ananías oquecac lo que tli Piero oquejto, ombetzeto hua omec. Pos omajcömejque noche tli oquematque de inu. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Entunses omoquetztiejque pelantotu hua oquetejcuexque icuierpo de inu tlöcatl. Quequextejque hua oquetlölpachuto. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Opanuc quieme yeye ura. Ocalac isohua. Amo oquemat tli oquepasöro inömec. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Yecuöquenu Piero oquelfe: ―Xeniechelfe. ¿Nenquenamacaque nemotlöl por ini tönto? Yaja oquejto: ―Pos por inu tönto. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Entunses Piero oquelfe: ―¿Tlica nemotlölejque de acuierdo para ejqueu nentieprobörojque Espíritu Sönto? Xequejta. Ompa bitze tli quetlölpachuto monömec. Öxö metzbicasque nuyejque taja. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sa nima obetzeto icxetla Piero hua omec. Cuöc ocalajque inu pelantotu oqueniextito que ye omec sohuatl. Oquequextejque. Quetlölpachuto itlac inömec. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Tiemabelejque Deus noche inu grupo de creyentes hua noche ocseque tli oquecajque de inu. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Inu tlateotitlanme oquechijque meyactie sieñas hua tietzöbeme intzölö giente. Noche creyentes ca sentetl inyulo mosentlöliöya ipan Corredur de Salomón. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ocseque giente amo quenequeya mosietelisque ca inu creyentes pero nuyejque quenyectieniehuaya creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Noche tlöca hua sohuame tli omoneltocaque tieca Jesús memeyaqueliöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pos giente quenquextiöya cocoxcötzetzi ca pa ojtle. Quentlöliöya ipa tlapechme hua ipa petlame para cuöc panus Piero siquiera ma pano itunal impa seque de yejua para ma pajtecö. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nuyejque mosentlölejtöya meyac giente de puieblos tli cache cierca cate de Jerusalén. Quenhualecaya cocoxcötzetzi hua quiejquech quenpasoloöya moxicoöneme. Nochemejua opajteque. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Entunses omajcojque tlajtojcöteopexque hua noche icompanierojua de inu grupo de joriojte itucö saduceos, pos lalebes ochöhuatque. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Oquemaseque tlateotitlanme hua quentzajtzajque pan cörsel del puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero ca yohuale tieöngel Deus oquentlapolfe pobieltajte de cörsel hua oquenquexte tlateotitlanme. Oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","―Xeyöcö. Xecalaquecö ipa teopantle. Xequemelficö giente noche sösantle de nönca yancuec nemelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Oquecajque tli oquejto. Entunses ocalajque ipa teopantle cuöc ye otlanies. Ompa tlamachtejtaya. Tlajtojcöteopexque hua tli oyejyeya ca yaja oquechijque junta. Oquesentlölejque inu grupo de tlöca tli cache bejfeye momajtaya hua noche biebentzetzi de Israel ipa inu junta. Cuöquenuju otlatitlanque ipa cörsel para ma quenhualecacö tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero cuöc ompa oaseto guardias ipan cörsel amo oquenniextejque. Entunses omocuejque hua otlanahuatejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Oquejtojque: ―Pos otecniextejque cörsel yectzacteca hua tli tlaixutea ompa ijcatecate itlac pobielta. Cuöc tetlaijtlapojque amo öque tecniextejque ca tlaijtec. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Inu tlajtojcöteopexque hua inu jefe de guardia de teopantle hua teopexcötzetzi oquecajque tli oquejtojque guardias. Quetietzöbejque. Quejtojque: ―¿Tli beles pasörebes ca noche ini nönca? ");
INSERT INTO nhgNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Cuöquenuju oaseto sente tli quenmachestito: ―Xomojtelicö. Inu tlöca tli nenquenmotzajtzacuelejque ipan cörsel ompa cate teupa ahorita quenmachtejtecate giente. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Entunses jefe de guardia uya ca igiente. Oquenhualecaque tlateotitlanme sa ca cuale porque omomajtejque que beles giente quentecaltisquiöya yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Cuöc yejua ye quenhualecaque tlateotitlanme, quenpresentörojque pa junta. Inu tlajtojcöteopexque oquemelfe tlateotitlanme, oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tejua nemiechnahuatejque ca checöhuac tlajtule para ayecmo xetlamachticö itucöyupa nieca tlöcatl Jesús. Hua öxö noche lo que tli nemejua nentlamachtea ye oquecajque noche giente ipa Jerusalén. Pos nenqueneque nentiechtlajtlajcultisque tejua nele otecmectejque inu tlöcatl Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Onöhuatque Piero hua ocseque tlateotitlanme: ―Tejua tecpea que tetieneltocasque Deus antes que tequenneltocasque tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yejuatzi Deus de totötajua tieyulebitiluc Jesús öque nemejuantzetzi onentiemomectelejque cuöc onentiemotömpelfejque ipan corujtzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Deus otiebieyetlöliluc Jesús cuöc otieyelfejque ma netlölilo ca tiemöyecömpa para iloas Tlajtoöne hua Tlamöquextiöne. Ejqueu Deus oquechijque para ma moyulcuepacö giente de Israel para que Jesús quenperdonörfisque intlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pos tejua tecate tetestigos de noche ini. Nuyejque Espíritu Sönto iloac testigo. Deus otiechmacaque Espíritu Sönto tonochtie tli tetieneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Pos tli oyejyeya pa junta lalebes ocuajcualönque cuöc oquecajque inu. Oquenejnejque quenmejmectisquea tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero Gamaliel omoquetz. Gamaliel oyeya de inu grupo de joriojte itucö fariseos. Nuyejque oyeya tlamachtiöne hua maestro de inu ley de Moisés. Noche giente oquerespetöroöya yaja. Pos Gamaliel otlanahuate nele ma tepetzi quenquexticö ca queyöhuac niecate tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Entunses oquejto: ―Señores de tonación Israel, xomopilicö cueröro de lo que tli nemochibelisque ca nöncate tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Xomolnömequiticö que amo quepea bejca tunale que omajcoc Teudas. Omobieyechi. Pos quieme nöbe cientos tlöca quetocaya. Por fin quemectejque hua noche tli quetocaya ochucholojque. Pos amo yetla oquechijque. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sötiepa de Teudas omajcoc Judas de estado de Galilea. Omajcoc miero cuöc omochi censo de giente, hua meyactie oquetocaque. Pero yaja nuyejque omec, hua nochemeju tli quetocaya ochucholojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Hua öxö nemiechmolfelea, xequenmocöbelicö nöncate tlöca. Amo tli xequenmochibelelicö. Tlö quejtus que intlamachteles icaca de tlöca pos seguramente pojpolebeti. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero tlö intlamachteles icaca de Deus, abele nemoxexetunelisque tlöcamo nemochibelisque mal porque nentiemixnömequelisque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Pos oquenparesiero lo que tli oquejto. Oquentzajtzelejque inu tlateotitlanme hua oquenbejbitejque. Oquemelfejque ca checöhuac tlajtule nele majcamo tlanunutzacö de Jesús. Entunses oquencajcöjque. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Tlateotitlanme uyajque de ipa inu junta ca meyac pöquelestle. Opajpöjque porque Deus oquenmacaque locör para oquesufrirojque tiecoco por tiepampa Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pos yejua amo oquetzajque incamac tlöcamo mumustla otlamachtejque. Otlanunutzque ipan teopantle bieye hua chöntle por chöntle que Jesús iloac inu Cristo öque Deus tieixpejpenque. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pa nieca tiempo cuöc momeyaqueliöya creyentes seque tli tlajtlajtoöya ca griego opiejque omoquejörojque. Omoquejörojque cuntra joriojte tli tlajtlajtoöya ca hebreo. Oquejtojque que mumustla cuöc quentlacualtea giente, amo oquentlacualtejque cuale imicnusosohuöhua. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Entunses inu majtlactle huan ume tlateotitlanme oquensentlölejque creyentes. Oquemelfejque: ―Amo conbenierebe que tejua tejcöhuasque tietlajtultzi Deus para tequentlacualtisque tocnihua. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Hua öxö, tocnihua, xequemixpejpenacö checume tlöca de entre nemejua tli quepejpea innemeles melactec. Xequemixpejpenacö tli tlajmatque hua tli cache nejniese que yejuatzi Espíritu tlamandöruro ipa inyulo. Entunses tequencargörfisque yejua para ma quentlacualticö tocnihua. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ejqueu tecsequirusque tejua totlajtlötlajtejtasque hua tetlamachtejtasque de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pos oquenparesiero lo que tli oquejtojque tlateotitlanme. Oquixpejpenque Esteban porque lalebes moneltocaya hua omacheac que Espíritu Sönto tlamandörurutebitz ipa iyulo. Nuyejque oquemixpejpenque Felipe, Prócoro, Nicanor, Timón, Parmenas hua Nicolös. Pos inu Nicolös oyeya de puieblo de Antioquía. Mös amo joreyo pero ye ocalac ipa religión de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Oquebicaque nöncate checume intlac tlateotitlanme. Omotlajtlötlajtejque tlateotitlanme hua impa inu checume oquentlölejque inmöhua. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Tietlajtultzi Deus ohualmosu cache hua cache. Inu creyentes tli oyejyeya ompa Jerusalén omomeyaquelejque bel meyac. Meyactie teopexcötzetzi moneltocaque tieca Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Deus oquemacaque Esteban bieye tiefavur, pos quemacaque beletelestle para quechihuas sieñas hua tietzöbeme bejbeye intzölö giente. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Omajcojque giente de sente teopantle itucö Teopantle de los Libertados. Yejua oyejyeya de puieblos de Cirene hua Alejandría hua de tlöle de Cilicia hua Asia. Inu giente omixcomacaque ca Esteban. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Cache abele oquexexicojque Esteban porque Espíritu Sönto oquepaliebejque tlajtlajtus hua oquemacaque machestelestle quiene ca quennönquelis. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Entunses oquentlajtulmacaque seque giente ma ejistlacatecö. Inu tlöca oquejtojque: ―Tejua otejcajque Esteban que checuatlajto cuntra Moisés hua cuntra Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Pos ejqueu ocuolinejque giente hua biebentzetzi de joriojte hua tlamachtiöneme de teotlajtule. Ipa Esteban omomeröjque hua ocaseque. Oquebicaque ipa junta. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Oquentlölejque seque istlacatque tli quejtojque: ―Ini nönca tlöcatl amo quequetza icamac para quejtojtas checuayutl cuntra ini nönca locör sönto hua cuntra inu ley. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Pos otejcajque que oquejto que inu Jesús de Nazaret quexetunis ini locör hua quepatlas noche costumbres tli Moisés tiechcöbelejtie. ");
INSERT INTO nhgNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Entunses noche tli ompa oyejyeya pa junta oquetztaya Esteban. Oquejtaque que ixöyac oyeya quiename ixöyac de sente öngel. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Entunses tlajtojcöteopexque oquejto: ―¿Ejqueu icaca? ");
INSERT INTO nhgNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Esteban oquejto: ―Señores tli nennocnihua hua nentötajme de Israel, xeniechmocaquiticö. Deus öque lalebes quepealo tlaniextelestle ca ye niepa otlajtlajtuluc ca totajtzi Abraham. Neniextiluc ca yaja cuöc oc chönteya pa tlöle de Mesopotamia antes que uya para mochöntito pa puieblo de Harán. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Deus oquelfejque: “Xequisa de ipa motlöl. Xequencöhua moparientes. Xebeya hasta nieca tlöle tli temetzejtetis”. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Entunses Abraham oquis de inu tlöle de Caldea. Uya para chönte hasta puieblo de Harán. Pa quiesque tiempo itajtzi omec. Entunses Deus oquehualecaque Abraham hasta pa nönca totlöl cöne nemejuantzetzi nemochajchöntelea öxö. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Deus amo oquemacaque Abraham niontle de nönca tlöle. Nion tepetzi siquiera para cuale quejtus que de melöhuac ihuöxca. Pero melöhuac oqueprometierfejque Abraham que quemacasque nönca tlöle para ihuöxca iyes. Oqueprometierfejque nuyejque que sötiepa de que ye omec, nönca tlöle mocöhuas para ipelhua. Cuöc oqueprometierfejque ini nönca, nimpor ayemo quepeaya Abraham nion sente iconie. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Deus oquejtojque que ipejpelhua Abraham chajchöntesque ipa ocsente nación. Chajchöntesque ipa sente tlöle tli amo inhuöxca. Ompa yesque esclavos de niecate gientes porque yejua tlamandörusque impa. Niecate gientes quenmaltratörusque ipejpelhua Abraham por cuatro cientos años. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nuyejque oquelfejque ejqueyi: “Nejcuntenörus inu nación tli tlamandörus ipa mopelhua hua quenpeas quieme esclavos. Sötiepa mopelhua quisasque de ompa hua niechtequepanusque naja ipa nönca locör”. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Deus oquechijque sente acuierdo ca Abraham hua oquemacaque Abraham tocostumbre de nacayutlatequelestle, para ma quechihua Abraham quieme sieñas de que quepeaya sente acuierdo ca Deus. Por inu cuöc otlöcat iconie itucö Isaac, Abraham oquenacayutec. Cuöquenuju Isaac quepeaya quiemach checume tunale. Ejqueu nuyejque oquechi Isaac ca iconie itucö Jacob, hua Jacob ca ipejpelhua. Pos ipejpelhua Jacob oyejyeya tötajte de noche doce tribus noso grupos de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Niecate totötajua, es decir, ipejpelhua Jacob, omoxicojque de imicni itucö Josie. Oquenamacaque Josie ca ocseque giente ma quebicacö ca nación de Egipto. Pero Deus iloaya ca Josie. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Oquequextejque de ipa noche tiecoco tietunie. Deus oquemacaque Josie machestelestle hua oquepaliebejque para oquepex favur ca Faraón, rey de Egipto. Inu rey Faraón oquetlöle Josie para cubernadur de Egipto hua nuyejque para cubernadur de ical de inu rey. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Entunses omochi öpestle hua meyac tiecoco tietunie ompa pa Egipto hua pa tlöle de Canaán. Pos totötajua amo oquepexque tli quecuösque. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero cuöc oquemat Jacob que giente quepeaya tli quecuösque ompa pa Egipto, oquentitla ipelhua noso totötajua ca ompa. Ejqueu ca sajpa oquentitla. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ca ujpa Josie oquixomatque icnihua. Hua ca inu Faraón oquemat de tli giente oyeya Josie. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Entunses Josie otlatitla ma quehualecacö itajtzi Jacob ca noche igiente. Nele igiente oyejyeya setenta y cinco ca meyactie cuöquenuju. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","De inu maniera Jacob omochöntito pa Egipto. Ompa omec. Nuyejque totötajua ompa omejmejque. Oquenbicaque incuierpo hasta puieblo de Siquem. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Oquentlölpachojque incuierpo ijtec imejcöcoyoc de Abraham. Abraham omocube inu mejcöcoyoctle de ipelhua Hamor ompa pa Siquem. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","’Cuöc ye miero mochihuasquea lo que tli Deus oqueprometierfejque Abraham, tonación de Israel ompa pa Egipto momeyaqueliöya cache hua cache. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Pero sötiepa ocalac ocsente rey ompa pa Egipto hua inu rey amo quixomat Josie. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inu rey oquencajcayö totötajua. Inu giente de Egipto quenmaltratörojque porque san tequetl que otlajtlöcatque inpelhua, inu rey oquenchihualte ma quecajcöhuacö inpelhua ca sie löro insiel para ma mejmequecö. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Cuöquenuju otlöcat Moisés. Hua oyeya lalebes cuöcualtzi peltzintle. Por yeye mietztle itötajua oquebepöjque pa inchö. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero por fin oquepexque para quecajcöhuasque ca sie löro. Cuöquenuju ichpuch de inu rey Faraón oqueniextito hua oquebepö Moisés quieme tlö iconie. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ejqueu omomachte Moisés de noche lo que tli oquematque niecate gientes de Egipto. Lalebes tlajmatque oyeya Moisés para tlajtlajtus hua para tequetes. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Cuöc quepeaya cöso cuarenta años oquepensöro quentlajpalus igiente de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ompa oquejtac que sente egipcio oquemaltratörojtaya sente tlöcatl de Israel. Moisés omoquetzato ihua inu israelita hua oquepaliebe. Pos Moisés oquemecte inu egipcio. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moisés oquemecte porque oquepensöro que icnihua de Israel ye ocasojcömatque que Deus cusörusque Moisés para quenmöquextis de ipa Egipto. Pero la cosa es que israelitas amo ocasojcömatque ejqueu. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ipa mustlateca Moisés quenniextito unte israelitas tli momacataya. Oquenec quenyulsiebis. Oquemelfe: “Señores, nemejua nenicnijte nencate. ¿Tli para nemomacatecate?” ");
INSERT INTO nhgNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Entunses niecaju tli cachto oquemacac inu ocsente oquemöpie Moisés. Oquelfe: “¿Öquenu metztlöle taja para tetlajtoöne noso tejuez topa tejua? ");
INSERT INTO nhgNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tecneque taja teniechmectis nuyejque quieme otecmecte inu egipcio iyöla?” ");
INSERT INTO nhgNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Cuöc Moisés oquecac inu, ocholo. Uya ca pan tlöle de Madián. Ompa chönteya quiename sente nejnenque, hua ompa oquepex unte ipelhua. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Sie tunale cuöc ye opanuc cuarenta años, Moisés oyeya cöne nionöque chönte. Oyeya itlac sente tepietl itucö Sinaí. Xutlataya sente tebetztle ompau, hua ijtec inu tletzintle ohualneniextiluc sente öngel. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés oquetietzöbe cuöc oquetztequis noche inu. Pos omopacho itlac para cache cuale quejtas. Cuöquenuju oquecac que Tlöcatzintle oquelfejque ejqueyi: ");
INSERT INTO nhgNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Naja neDeus, öque motötajua niechteochijque. Naja neca neDeus de Abraham, hua de Isaac, hua de Jacob”. Entunses Moisés obebeyocac por lalebes omajcömec. Ayecmo oquenec quejtas inu tebetztle. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Entunses Deus oquelfejque: “Xequenquexte mocacua porque taja nixtla tecaca hua naja neyectec necaca. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naja nequetztebitz tiecoco tietunie tli mochihua pa nogiente ompa pa Egipto. Nejcactebitz quiene ca yejua yejyelsesebe. Onehuöla noso para nequenquextis de ipa inu tiecoco. Xequejta. Öxö temetztitlanes ompa pa Egipto”. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","’Pos totötajua amo quetlöcayejtaque Moisés, cache oquelfejque: “¿Öquenu metztlöle quieme tetlajtoöne noso tejuez?” Pero Deus oquetitlanque miero yaja Moisés quieme tlajtoöne hua tlamöquextiöne. Oquetitlanque cuöc neniextiluc inu öngel ica Moisés itech inu tebetztle tli xutlataya. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Pos miero yaja Moisés oquenquexte totötajua de ipa Egipto. Miero yaja Moisés oquechi sieñas hua tietzöbeme pa inu tlöle de Egipto hua ipa Lamör Chichiltec hua nuyejque por cuarenta años pa inu bieye locör cöne nionöque chönte. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Pos sie yaja Moisés oquemelfe niecate israelitas: “Quieme Deus oniechhualtitlanque naja ca nemejua, ejqueu Deus tiehualtitlanesque ca nemejua ocsente tlayulepante tli tlajtlajtusque de tiepörte. Inu tlayulepante Deus tieixpejpenasque de nemotzölö nemejua. Xetieyejcaquecö”. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Cuöc otlajtlamachyejyeya israelitas pa nieca locör cöne nionöque chönte, miero yaja Moisés otlajtlajto ca inu öngel tli quennunutzaya pa nieca tepietl de Sinaí, hua tli nuyejque otlajtlajto ca totötajua. Miero yaja Moisés ucö tlajtule tli quetiemaca nemelestle. Ucö inu tlajtule para tiechelfis tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Pero totötajua amo oquenejque queneltocasque Moisés, tlöcamo quetlajyelejtaque. Ipa inyulo oquenejque mocuepasque ca Egipto. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Entunses oquelfejque Aarón: “Tejua tecneque tomochejchibelis deuste para ma tiechyecönacö. Pos inu nieca Moisés otiechquexte de ipa Egipto cache tejua amo tecmate tli opasöre ca yaja”. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Entunses oquechejchijque sente pesiero. Quenmejmectejque yulcöme para oquebentlölelejque inu ixniehualo. Oquenpöquelesmacac lo que tli oquechejchijque ca inmöhua. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Entunses Deus onenencuaxeluluc de yejua. Oquencöjque ma quenteochihuacö sitlalte de elfecac. Pos ejqueu tlajcuelulpanca pa libros de inu tlayulepantejque cöne Deus oquejtojque: O giente de Israel, nenyajtenemeya por cuarenta años pa nieca locör cöne nionöque chönte. ¿Beles onenquemejmectejque yulcöme para onenniechtlölelejque naja bentle cuöquenuju? ");
INSERT INTO nhgNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pos amo. Ca rabies onenquechijque. Onenquebicaque ca nemejua inu teocale de nemodeus Moloc. Onenquebicaque inu sitlale de nemodeus Renfán. Inu nemoixniehualojua onenquechejchijque nemejua para onenquenteochijque. Por inu naja nemiechquextis de ipa nemotlöl para nemiechbicas cache bejca que inu nieca nación de Babilonia. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","’Pa nieca locör cöne nionöque chönte totötajua quebejbicatenemeya inu teocale cöne oquemalfejque teme tli intech oejcuelojtaya inu mandamientos de Deus. Inu teocale Moisés oquechejchi confurme inu plan tli Deus oquejtetejque cuöc oquelfejque ma quechejchihua. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Inu teocale hualpanutöya de seque tlöca ca ocseque hasta totötajua ohuölajque ca tiehua Josué. Oquehualecaque inu teocale pa nönca tlöle. Pos totötajua oquencuejcuelejque nönca tlöle ocseque naciones porque Deus oquenpaliebiluc oquenquextejque inu gientes para tiechmacasque tejua nönca tlöle. Así es que totötajua oquepexque inu teocale hasta ipa tiempo de David. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Pos David oquepex favur ca Deus. Oquenec quechihuas sente teopantle bieye para ipelhua Jacob. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero amo yaja David oquechejchi, tlöcamo Salomón oquechejchi inu teopantle bieye para Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pos Salomón oquechejchi inu teopantle mös Deus amo nemoa miero pa teopanme tli tejua tecchejchihua ca tomö. Icamacopa sente tlayulepante Deus oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Elfecac icaca notrono, hua pan tlöltecpactle nequentlölea nocxehua. ¿Cötlaja cale noso nenniechchejchibelisque? ¿Cöne noso cuale nechöntes hua nosiebis? ");
INSERT INTO nhgNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Quie amo onecchejchi noche inu ca nomö? ");
INSERT INTO nhgNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Oquejto Esteban: ―Nemejua siempre nenyultepitzteque. Nenquepea nemoyulo quieme tlö amo nenyene nengiente de Deus. Amo nenquepea inu nacayutlatequelestle tli ipa öque iyulo. Amo nenqueneque nenquecaquesque tli Deus nemiechelfilo. Seme nentiecuajnömeque Espíritu Sönto. Nemotötajua ejqueu quechijtebitze, hua ejqueu nuyejque nenquechihua nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Cuale nenquetieniehuasque mös sente tlayulepante tli amo quetepotztocaque nemotötajua? Pos nemotötajua quenmejmectejque niecate tlayulepantejque tli ca ye niepa oquejtojque que sie tunale axihuaqui yejuatzi öque yectec. Pos quiemach onaxihuaco hua nemejua onentiemöctejque ca ocseque tlöca hua nentiemectejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Nemejua nencönque inu ley de Deus tli onemiechnahuatejque öngeles, pero amo nenquechihua tli quejtoa. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Cuöc inu giente oquecajque inu, lalebes ocuajcualönque cuntra Esteban, hua hasta motlajtlantesque. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero iyulo Esteban otie de Espíritu Sönto. Cuöc oajcopatlachix ca elfecac, oquejtac tietlaniexteles Deus. Otieyejtac Jesús ijcatihuateca ca tiemöyecömpa Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Entunses oquejto: ―Nequejta elfecac tlapojteca. Xequejtacö, netieyejta Jesús öque nechihualuc tlöcatl ijcatihuateca ca tiemöyecömpa Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero inu giente oquetlapachojque intlacaqueles para amo oquecajque hua bel checöhuac otzajtzajtzeque. Omomeröjque ipa Esteban. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Oquequextejque Esteban de ipa puieblo hua oquetecaltejque. Tli oquetecaltejque hua tlatestificörojque cuntra yaja oquetlölejque intzotzomajua icxetla sente peltuntle itucö Saulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mientras quetecaltea, Esteban omotlajtlötlajte. Oquejto: ―Tlöcatzintle Jesús, xomönele noölma. ");
INSERT INTO nhgNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Cuöquenuju motlancuöquetz hua oquejto checöhuac: ―Tlöcatzintle, amo xomotlölele ipa cuienta nönca tlajtlacule tli quechijtecate. Cuöc ye oquejto inu, omec. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo oquecualejtac que oquemectejque Esteban. Ipa inu tunale giente quentepotztocaque inu grupo de creyentes tli oyejyeya pa Jerusalén. Inu creyentes moxiexelojque ca estado de Judea hua ca estado de Samaria. Solamiente tlateotitlanme amo moxiexelojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Tlöca tli moneltocaneme quetlölpachuto icuierpo de Esteban. Ochucaque lalebes por yaja. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo oquesequiro quentepotztocac creyentes. Calaqueto chöntle por chöntle. Quentlölochpönaya tlöca hua sohuame. Oquentzajtzac ipan cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Inu creyentes tli moxiexelojque quennunutzque giente ca nobeyo de inu tlajtule de cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Entunses Felipe uya hasta sente puieblo de estado de Samaria. Oquennunutz giente de yejuatzi öque iloac Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Mosentlölejque meyac giente. Oquecajque ca meyac gönas lo que tli oquejto Felipe. Quejtaque inu sieñas de tietzöbetl tli oquechi Felipe. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Opajteque meyactie giente tli imijtecopa quepeaya moxicoöneme. Pos moxicoöneme otzajtzeque lalebes hua oquisque de imijtecopa yejua. Opajteque meyactie tli incuierpo cuajcuajpetzajque hua meyactie cojcultzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Así es que pa inu puieblo lalebes pajpöqueya giente. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero ompa oyeya sente tlöcatl itucö Semu. Quechihuaya sösantle de magia pa nieca puieblo. Por inu lalebes quetietzöbejtaya inu giente de estado de Samaria. Lalebes bieye omomat ca inu giente. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nochemeju giente, desde giente humilde hasta tli bejbeye, oqueneltocaque inu Semu. Oquejtojque: ―Deus oquemacaque tiebeleteles tli bieye ca nönca tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Pos oquechibelejque cöso inu Semu porque por meyac tiempo oquehualencajcayöjtöya ca sösantle de magia. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero cuöc oquecajque inu cuale tlamachestelestle tli Felipe oquennunutz pos monejneltocaque. Felipe quemelfe quiene ca Deus tlamandöruro hua quemelfe de Jesucristo. Omocuötiequejque tlöca hua sohuame. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sie yaja Semu moneltocac hua omocuötieque. Opie yajtenemeya ca Felipe. Oquetietzöbejtac Semu porque Felipe quechihuaya tlachihuale de sieñas hua tietzöbetl bejbeye. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pa Jerusalén oyejyeya tlateotitlanme. Quecajque que giente de estado de Samaria oqueselejque tietlajtultzi Deus. Entunses quentitlanque Piero hua Xohuö hasta ompau. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Piero hua Xohuö ajaseto ompa. Motlajtlötlajtejque que pa inyulo de inu creyentes ma axihuaque Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Pos ayemo hualaxihuaya pa iyulo de nionöque, tlöcamo sa omocuötiequejque tietucöyupantzinco Tlöcatzintle Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Entunses Piero hua Xohuö oquentlölejque inmöhua impa yejua hua ca inu ocalacoac Espíritu Sönto ipa inyulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Semu oquejtac que cuöc tlateotitlanme oquentlölejque inmöhua impa inu creyentes ocalacoac Espíritu ipa inyulo. Semu quencuetlabilte tlateotitlanme tomi. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Oquejto: ―Xeniechmomaquelicö naja nuyejque inu beletelestle para que cuöc naja nequentlölis nomöhua ipa canajyeca ma calacoa Espíritu Sönto pa iyulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Entunses Piero oquelfe: ―Ma pojpolebe motomi ca tiehua taja porque taja tecpensöroa que lo que tli Deus tiechmacalo mocoa ca tomi. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Taja amo tecpea pörte nimpor deriecho para tecalaques pa nönca tequetl de Deus porque moyulo amo melactec tieixtla Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Xomoyulcuepa noso de motlajtlacul hua xomotlajtlötlajte ca Deus abier tlö metzperdonörfisque tli tecpensöroa pa moyulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Pos temetzejta taja lalebes teyulchechec. Quieme cuöc öque tzajtzacteca pa cörsel abele quisa, ejqueu abele tequisa taja de ipa motlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Entunses Semu onöhuat: ―Xomotlajtlötlajtejtzinucö por naja majcamo tli niechpasöro de lo que tli nenniechmolfelejtecate. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ompa pa inu puieblo Piero hua Xohuö tlamelöjcöpujque de tietlajtultzi Tlöcatzintle hua quennunutzque giente. Sötiepa de inu, tlanunutzque de cuale tlamachestelestle ipa meyac puieblos de estado de Samaria. Entunses omocuejque ca Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sente öngel de Deus oquelfe Felipe: ―Xebeya ca tlatzintla. Xectoca ojtle tli iya de Jerusalén para ca puieblo de Gaza. Inu ojtle pano pa sente locör cöne nionöque chönte. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Entunses uya. Ipa oaseto sente tlöcatl de sente tlöle itucö Etiopía. Inu tlöcatl oyeya sente tlajtoöne hua tesoriero de Etiopía cöne Candace oyeya reina. Inu tlöcatl hualiehuaya de Jerusalén cöne tieteochihuato Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Öxö mocuectaya para ca ichö. Yajtebitz ipa icörrojconie de unte caretotu tli queteröntöya caböyojte. Inu tlöcatl cualtlajtultejtöya libro tli oquejcuelo inu tlayulepante Isaías. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Entunses Espíritu Sönto oquelfejque Felipe: ―Xomopachute itlac hua xectocate inu carrojconetzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Hua Felipe omomerö para omopachuto. Entunses oquecac que inu tlöcatl quetlajtultejtaya inu libro de Isaías. Quetlajtlane: ―¿Tecasojcömate tli tectlajtultea? ");
INSERT INTO nhgNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Inu tlöcatl oquejto: ―¿Quiene necasojcömates tlö amo necpea öque niechesplicörus? Entunses oquenec ma Felipe ma tlejco hua ma motlöle itlac yaja. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Inu tlöcatl de Etiopía quetlajtultejtaya teotlajtule cöne quejtoa: Quiename öque quebica sente calnielo para quemectis ejqueu giente quebicaya sente tlöcatl para quemectisque. Quieme sente calnielo amo tzajtze cuöc öque quepejpe itojmeyo, ejqueu nuyejque amo tli oquejto inu tlöcatl cuöc oquemectejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Oquetratörojque quiename sente tlöcatl amo cualtec. Quemectejque sin arasu. ¿Quiene ca quenpeas ipelhua tlö antes que quenpeas ye oquemectejque? ");
INSERT INTO nhgNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Inu tlajtoöne de Etiopía quetlajtlane Felipe: ―Xeniechelfe, por favur. ¿De öquenu quejtoa ini nönca? ¿Tlajtlajtoa inu tlayulepante Isaías de sie yaja noso de ocsente? ");
INSERT INTO nhgNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Entunses itech inu pörte de teotlajtule Felipe opie oquenunutz inu tlöcatl de cuale tlamachestelestle de Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Pos monunutztebe pa ojtle hasta oaseto pa sie locör cöne oyeya ötzintle. Oquejto inu tlöcatl de Etiopía: ―Oncönca ötzintle. ¿Abele naja nocuötiequis? ");
INSERT INTO nhgNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Oquenahuate itlatequepano ma quequetza carrojconetzi. Entunses inu tlöcatl de Etiopía hua Felipe otemuque hua uyajque innehua cöne ötzintle. Felipe oquecuötieque inu tlöcatl de Etiopía. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cuöc oquisque de ijtec ötzintle, tieEspíritu Tlöcatzintle sa de repiente quecuenejtequisque Felipe de ompau. Inu tlajtoöne ayecmo oquejtac Felipe tlöcamo quetocac iojfe ca meyac pöquelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe onies pa puieblo de Azoto. Desde ompau puieblo por puieblo tlanunutztenemeya de cuale tlamachestelestle hasta oaseto ipa puieblo de Cesarea. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Turavea Saulo lalebes checöhuac cualöneya cuntra inu creyentes tli tietocaya Tlocatzintle. Hasta quenequisquea ye oquenpojpolo. Yaja ica uya oquejtato tlajtojcöteopexque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Oquetlajtlanele ma quemaca ömatl para iyös pa teopame de sente ciudad itucö Damasco. Oquenec quemases noche tlöca ca tiehua sohuame tli tietocaya tieojfe Deus. Quenhualecasquea ca Jerusalén quieme priesoste. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Oyöya Saulo pa ojtle. Amo bejca oyeya de inu ciudad de Damasco cuöc sa de repiente otlaniextejtequis ipa yaja sente tlaniextle de elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Cuöquenu ombetzeto. Entunses oquecac öquenu quelfiöya: ―Saulo, Saulo. ¿Tlica teniechtepotztocateneme? ");
INSERT INTO nhgNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Entunses Saulo otlajtla: ―¿Öquenu tejuatzi? Yejuatzi oquelfejque: ―Pos naja neJesús. Taja miero teniechtepotztocateneme naja cuöc tequentepotztoca tli niechtoca. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Xemiehua hua xebeya pa puieblo. Ompa metzelfisque tli tecchihuas. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Niecate tlöca icompanierojua Saulo omajmajcömejque lalebes porque oquecajque öquenu tlajtlajtoa pero amo öque oquejtaque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sa nima Saulo omajcoc de cöne betztaya. Cuöc oquentlapo ixtelolojua abele otlachix. Entunses icompanierojua caseque ca imö hua quebicaque pa inu ciudad de Damasco. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ompa oyeya yeye tunale sin abele tlacheas. Amo tli oconic nimpor amo otlacua. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ompa pa Damasco chönteya sente creyente itucö Ananías. Tlöcatzintle netieyejtetiluc ca yaja hua oquelfejque: ―Ananías. Hua Ananías onöhuat: ―Nö neca, noTlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Entunses Tlöcatzintle oquelfejque: ―Xebeya sa nima hasta pa inu cayaju itucö Melactec. Ompa pa ichö de sente tlöcatl itucö Judas xetlajtlane por sente tlöcatl itucö Saulo. Yaja icaca de puieblo de Tarso. Motlajtlötlajtejteca. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Pos quiename ipa cochtiemequelestle metzetzteca taja, Ananías, que taja tecalaque ipa ichö hua tequentlölea momöhua ipa yaja para ma tlachea ocsajpa. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Entunses Ananías oquejto: ―Tlöcatzintle, meyactie ye oniechpubelejque de inu tlöcatl Saulo. Nele quenchibele tlimach tlin yecteque tli nejneme pa Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Hua öxö onhuöla ca necö para tiechases tonochtie tli temetzmotlötlajtelelea. Pos inu jefes de teopexcötzetzi oquemacaque beletelestle para tiechbicas quieme tepriesoste. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero Tlöcatzintle oquelfejque: ―Xebeya, porque onequixpejpe inu tlöcatl Saulo. Tlanunutzas de naja ca giente de ocseque naciones hua ca reyes. Nuyejque quennunutzas giente de Israel. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Naja necmachestis inu Saulo quiene ca quepea quesufrirus por causa de naja. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Entunses Ananías uya ipan chöntle cöne Saulo oyeya. Ocalac hua quentlöle imöhua ipa Saulo. Oquejto: ―Nocni Saulo, Tlöcatzintle Jesús oneniextiluc ca taja pa ojtle cöne tehuölöya. Yejuatzi oniechhualtitlanque para cuale tetlacheas ocsajpa, hua para ma tieme moyulo ca Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Cuöquenuju quiename tlö obetz de itech ixtelolojua canajyetla sana imiemieleyo meche. Entunses ye cuale otlachix ocsajpa. Saulo omoquetz hua mocuötieque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Sötiepa otlacua hua ocasec fuiersa ocsajpa. Entunses ompa omocö quiesquete tunale ca niecate creyentes tli chajchönteya pa Damasco. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sa nima opie Saulo otlanunutz pa teopancucone. Quemelfe giente que Cristo iloac tieConietzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Innochtie tli quecactaya quetietzöbejtaya lalebes. Quejtojque: ―¿Amo yaja nönca tlöcatl tli pa Jerusalén oquenpojpolo tli motlajtlötlajtea ca inu Jesús? ¿Amo ipampaji nuyejque ohuöla necö para quenbicas priesoste hasta Jerusalén hua ompa quentiemöctis ca jefes de teopexcötzetzi? ");
INSERT INTO nhgNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero Saulo tlanunutzaya cache ca meyac balur. Oquencamatzac inu joriojte tli chajchönteya pa Damasco. Ca tietlajtultzi Deus oquemejtete que Jesús iloac Cristo öque Deus otieixpejpenque para tlamöquextiöne. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Cuöc ye opanuc meyac tiempo, joriojte ocarreglörojque para quemectisque Saulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero Saulo oquemat de inu. Yohualen tunale joriojte quechixtaya Saulo ca calquisyo para quemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Cache imachtejcöhua quecalaquejque Saulo ijtec sente pescunchequebetl. Quetemubejque ca yohuale desde sente bentöna pa inu tepöntle tli queyehualojtaya inu ciudad de Damasco. De inu maniera ocholo Saulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Cuöc Saulo oaseto pa Jerusalén oquenec mosentlölis ca inu creyentes. Innochtie omajcömejque porque oquepensörojque que Saulo amo de melöhuac creyente oyeya. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Sin embargo, Bernabé oquebicac Saulo oquepresentöruto ca tlateotitlanme. Oquenpubele quiene ca Saulo otieyejtac Tlöcatzintle cuöc oyöya ca Damasco hua quiene ca yejuatzi quenunutzque. Oquenpubele quiene ca Saulo oquepex meyac balur para otlanunutz de Jesús ompa pa Damasco. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Saulo omocö pa Jerusalén. Yajtenemeya ca inu tlateotitlanme. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Oquepex meyac balur para otlanunutz de Tlöcatzintle. Monunutztaya hua mixcomacataya ca joriojte tli tlajtlajtoöya ca griego. Inu joriojte oquetiemojque maniera para quemectisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Cuöc inu hermanos oquematque de inu, oquebicaque Saulo hasta puieblo de Cesarea. De ompau oquetitlanque ma beya hasta ipuieblo de Tarso. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Pa inu tiempo giente ayecmo oquenpasolojque inu creyentes ipa estados de Judea hua de Galilea hua de Samaria. Yecuöquenu inu creyentes ocaseque fuiersa hua mobepöhuaya, porque tiemabeliöya Deus. Espíritu Sönto oquenpaliebejque. Hua ca inu omomeyaquelejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Cuöc Piero quentlajpalojtenemeya yecteque, nuyejque uya quemejtato tli chönteya pa sente puieblo itucö Lida. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ompa oqueniextito sente tlöcatl itucö Eneas. Ye ocuajcuapitza icuierpo. Pos betztaya checuieye xebetl ipa ipetl. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piero oquelfe: ―Eneas, Jesucristo metzpajtilo. Xemiehua hua xejquemelo mopetl. Sa nima omie. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Innochtie tli chönteya pa puieblo de Lida hua pa puieblo de Sarón oquejtaque que opajtec Eneas. Pos omoneltocaque ca Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pa niecaju tiempo oyeya pa puieblo de Jope sente sohuatl creyente itucö Tabita. Ca griego mocuitiöya Dorcas, quejtusneque sohuamasötl. Inu sohuatl seme quechihuaya tlin cuale hua quenpaliebiöya tlin porubejte. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Entunses pa niecate tunalte Dorcas omococo hua omec. Cuöc ye ocajöltejque icuierpo, oquetlölejque pa sente calejtec icpac cale. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Inu puieblo de Jope amo bejca de Lida cöne Piero oyeya. Cuöc inu creyentes oquematque que Piero oyeya pa Lida, oquentitlanque unte tlöca ma quetlalfite Piero: ―Xehualmobica ca tejua hasta Jope. Amo xomobejcöbite para sa nima teyösque. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Entunses Piero uya ca yejua. Cuöc Piero oaseto, quebicaque pa inu calejtec icpac cale cöne oyeya icuierpo de Dorcas. Noche icnusohuame mopachojque itlac Piero. Oquechojchuqueliöya Dorcas. Oquejtetejque Piero investidos hua intzojtzomajua tli Dorcas quechibeliöya cuöc turavea onemeya. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Cache Piero oquenquexte innochtie de inu calejtec. Omotlancuöquetz hua omotlajtlötlajte. Yecuöquenu omocuec cöne icuierpo Dorcas yutaya. Oquelfe Dorcas: ―Tabita, xemiehua. Entunses yaja omixtlapo. Cuöc oquejtac Piero, omotlöle. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piero ocasec ca imö hua oquequetz. Yecuöquenu oquennutz inu icnusohuame hua ocseque yecteque. Oquenpresentörfe Dorcas ye yulejteca. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ini nönca omacheac ipa noche puieblo de Jope. Meyactie omoneltocaque ca Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Entunses Piero omocö ompa pa Jope meyac tiempo. Omocö pa ichö de sente curtidor itucö Semu. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Oyeya ipa puieblo de Cesarea sente tlöcatl itucö Cornelio. Cornelio oyeya capetö de sie sientos soltörojte. Oyeya de inu grupo de soltörojte tli mocuitiöya Trupa Italiana. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelio ca tiehua isohua hua ipelhua tiemabeliöya Deus hua tieteochihuaya. Nuyejque oquetiemacac meyac tomi para quenpaliebe joriojte. Seme tietlajtlötlajteliöya Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Sente tunale quieme ca pa yeye ura ca ye yohuac Cornelio oquecochejtac. Oquejtac ixmantete sente öngel de Deus tli ocalac icalejtec. Öngel oquejto: ―Cornelio. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Pos Cornelio quetejtieyetztaya öngel hua majcömectaya lalebes. Oquejto: ―¿Tlica, Señor? Entunses inu öngel oquelfe: ―Deus ye metzcaquihua porque tomotlajtlötlajte ca yejuatzi. Nemacalo cuienta quiene ca tequenpaliebea tlin porubejte. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Xequentitlane seque tlöca ma yöcö pa puieblo de Jope para quenutzatibe Semu, öque nuyejque mocuitea Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mocalutea pa ichö ocsente Semu. Inu ocsente Semu curtidor icaca. Quepea ichö itech lamör. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Cuöc ye uya inu öngel, Cornelio quentzajtzele unte ipeyuhua hua sente soltöro lalebes moneltocane de tli quetequepanoöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Oquenpubele noche tli omochi ca yaja. Sötiepa oquentitla ca Jope. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pa mustlateca inu tlöca oyajtöya ipa inu ojtle. Quieme ca pan tlajca oyöya cierca de Jope. Cuöquenuju Piero otlejcoc icpac cale para motlajtlötlajtis. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Lalebes oteose hua oquenec tlacuös. Mientras tli chönejque tlajtlacualchihua, Piero quiename tlö omimec. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Oquejtac tlininuju quiename sente bieye tatapajtle que oquis de ompa elfecac. Otemuc hasta pan tlöle. Ilpetaya ca nöjcö löro. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Noche clases de yulcöme tli quepea nöbe imecxehua huölöya ijtec inu tatapajtle. Nuyejque quepeaya yulcöme quiename cuhuöme hua tutume. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Entunses Piero oquecac canajyeca tlajtlajtoa. Oquejto öquenuju: ―Xemiehua Piero. Xetlamecte hua xetlacua. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero Piero onöhuat: ―Abele, Señor. Ayec nejcua canajyetla tli amo cuale noso amo chepöhuac para nejcuös confurme tocostumbre. Así es que abele. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ca ujpa Piero oquecac ocsajpa öquenu tlajtlajtoa: ―Deus quejtulo que ye cate cuajcuale hua chepöjque para tequencuös. Amo xequejto taja que amo mocuöne lo que tli Deus quejtulo que ye ica chepöhuac para cuale tejcuös. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pos ejqueu omochi yexpa. Hua sötiepa inu tlininuju quieme tatapajtle nima uya ocsajpa ca elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piero lalebes oquetietzöbe. Cuöquenuju inu tlöca tli quehualentitla Cornelio hualtlajtlantöya cöne ichö Semu. Miero cuöc quepensörojtaya Piero tli quejtusneque lo que tli oquejtac, oaseco inu tlöca ipan queyöhuatientle. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cuöc oaseto, otlajtlanque tlö omocalute ipa inu chöntle sente tlöcatl itucö Semu, öque onuyejque mocuitiöya Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Mientras Piero quepensörojtaya de lo que tli oquejtac, Espíritu Sönto oquelfejque: ―Yete tlöca metztiemoa. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Xemiehua hua xetemo. Xebeya ca yejua hua majcamo quiene quechihua moyulo, porque naja necualentitla. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Entunses Piero otemuc ca cöne oyejyeya inu tlöca que Cornelio cualentitla. Oquemelfe: ―Nele nenniechtiemuco naja. ¿Tli nenqueneque? ");
INSERT INTO nhgNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Yejua onöhuatque ejqueyi: ―Otiechhualtitlanque sente capetö tietucö Cornelio. Lalebes cuale tlöcatl iloac hua tiemabelilo Deus. Noche joriojte tieyectieniehua. Sente öngel de Deus otieyelfe nele ma tlatitlanihua para metzmonucheliqui tejuatzi. Nele tomobicas ca tiechö para que yejuatzi metzmocaquitisque lo que tli tomopilea tetiemolfelis. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Entunses Piero quentlalfejque ma calaquecö. Omocöjque ca Piero inu yohuale. Pa mustlateca Piero uya ca yejua. Nuyejque uyajque ca yejua ocseque hermanos tli chönteya pa Jope. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pa ocsente tunale aseto pa Cesarea cöne quenchixtaya Cornelio. Nuyejque ompa oyejyeya ifamiliares hua iamigos Cornelio, pues oquentlalfe. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Cuöc Piero oaseto pa ichö Cornelio hua ye calaquesquea, Cornelio oquis hua motlancuöquetz ixtla Piero para queteochihuas. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero Piero ocajcoc. Oquelfe: ―Xomoquetza. Naja nuyejque necaca netlöcatl iguöl quieme taja. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piero monunutztaya ca Cornelio hua ocalac. Oquenniextito meyactie tli omosentlölejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Entunses Piero oquemelfe: ―Nemejua nenquemate que para sente joreyo ireligión amo quecöhua ma mosentlöle ca sente tli amo joreyo. Pero Deus oniechmachestejque nele quenequihua majcamo nequejto que canajyeca amo chepöhuac para amo nosentlölis ca yaja. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Porieso, san tequetl que oniechnutzque tlöca, onehuöla hua amo tli onequejto. Hua öxö necneque necmates noso tli ipampa nenniechnutzque. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Entunses Cornelio onöhuat: ―Quiemach quepea nöbe tunale cuöc ca imani quieme ca pa yeye ura ca ye yohuac notlajtlötlajtiöya necö nocalejtec. Sa de repiente omoquetztequis nixtla quiename sente tlöcatl ca itlaquie hasta tzotzotlaca. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Oniechelfe: “Cornelio, Deus ye metzcajque porque tomotlajtlötlajte ca yejuatzi. Quelnömequihua quiene ca tequenpaliebe tli porubejte. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Xequentitlane seque tlöca ma yöcö pa puieblo de Jope para ma huöla Semu öque nuyejque mocuitea Piero. Mocalutea pa ichö de ocsente Semu. Inu ocsente Semu icaca curtidor hua chönte itienco lamör”. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Hua ca inu sa nima temetztlatitlanele. Pos lalebes cuale que otehuöla. Öxö oncö tecate tonochtie tieixtla Deus. Pos tejua tecneque tejcaquesque noche lo que tli Tlöcatzintle metzmacaque para tetiechelfis. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Entunses Piero opie tlajtlajtoa. Oquejto: ―Öxö necasojcömate que de melöhuac Deus amo cache quetlöcaejtalo sente tlöcatl que ocsente. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Tlöcamo ipa noche naciones Deus quenselilo noche quiejquech tiemabelea hua quechihua tlin cuale. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Deus tiechmacaque tietlajtultzi ca tejua tli cate de ini nación de Israel. Tiechmacaque inu cuale tlamachestelestle tli tiechelfea que cuale tecpeasque siebelestle ca yejuatzi por medio de Jesucristo. Yejuatziji Jesús iloac Tlöcatzintle, que tlamandöruro ipa tonochtie. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Nemejua ye nenquemate de lo que tli omojto pa tlöle de joriojte, primieramiente pa estado de Galilea. Cuöquenuju Xohuö Bautista ye tlanunutzaya hua ye otlacuötiequiöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nenquemate quiene ca Deus otiemacuc Jesús de Nazaret beletelestle de Espíritu Sönto. Nenquemate quiene ca Jesús quechihualutenemeya tlin cuale. Oquenpajtejque innochtie tli inu diöblo oquenchihualtiöya ma quesufrirucö. Jesús oquechijque noche inu porque Deus otiepaliebejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Tejua tecate tetestigos de noche lo que tli oquechijque Jesús ipa estado de Judea hua ipa ciudad de Jerusalén. Sötiepa giente otiemectejque. Otiecoruspelojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero Deus otieyulebitiluc pa yeye tunale. Oyeya tietlanequeles Deus para neniextiluc Jesús ca tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Amo neniextiluc ca noche giente tlöcamo ca tejua, porque ca ye niepa Deus tiechixpejpenque para teyesque tetestigos. Tejua tetlacuajque hua tötlique ca Jesús sötiepa de que ye oyulebihuac de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesús tiechtitlanque para tetlanunutzasque intzölö giente hua para tequenmelöjcöpubelisque que Deus tieixpejpenque Jesús para quenjuscörusque noche tli turavea neme hua nuyejque tli ye omejmejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nuyejque ca ye niepa noche tlayulepantejque otlajtlajtojque de Jesús. Oquejtojque que noche tli tiecatzinco moneltoca moperdonörusque de intlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Turavea tlajtlajtojtaya Piero cuöc Espíritu Sönto ocalacoac ipa inyulo de innochtie tli quecactaya inu tlajtule de Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Inu joriojte tli nuyejque moneltocaque ca Jesús hua tli ohuölajque ca Piero oquetietzöbejque que Deus quenmacaque tieEspíritu Sönto ca tli amo joriojte para ma calacoa ipa inyulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Inu joriojte oquecajque inu ocseque que tlajtlajtojtaya ca ocsesen idiomas que amo quematque hua tiechajchamöjque Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Entunses Piero oquejto: ―¿Quiene ca öque quejtus que nöncate abele mocuötiequisque? Pos ye ocalacoac Espíritu Sönto ipa inyulo nuyejque quieme ocalacoac pa toyulo tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Entunses Piero otlanahuate ma mocuötiequicö tietucöyupantzinco Jesucristo. Entunses oquetlalfejque Piero ma mocöhua turavea ocseque tunale. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Tlateotitlanme hua ocseque hermanos tli oyejyeya pa estado de Judea oquecajque que giente tli amo joriojte nuyejque omoneltocaque ca tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Cuöc Piero omocuec ca Jerusalén, seque joriojte tli omoneltocaque ca Jesús ocajajuaque Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Oquejtojque: ―¿Tlica tequentlajpaluto giente tli amo joriojte hua otetlacua ca yejua? ");
INSERT INTO nhgNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Entunses Piero oquenpubele noche lo que tli omochi desde ca opie. Oquejto: ");
INSERT INTO nhgNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","―Naja oneyeya pa puieblo de Jope. Notlajtlötlajtejtaya, hua quiename onemimec, hua onequejtac tlininuju quieme sente tatapajtle bieye. Inu tatapajtle hualtemuc de elfecac. Ilpetaya ca nöjcö löro. Ohualasec hasta notlac. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Nectejteyejtac lalebes cuale para nequejtas tli oyeya ijtec inu tatapajtle. Nequemejtac yulcöme de nöbe imecxehua hua tli tiecuöneme, cuhuöme hua tutume. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Onejcac öque oniechelfe: “Xemiehua, Piero. Xetlamecte hua xetlacua”. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Pero naja onenöhuat: “Abele, Señor. Ayec canajquiema nejcua canajyetla tli amo chepöhuac noso tli amo mocuöne confurme tocostumbre. Así es que abele”. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ca ujpa onejcac öquenu tlajtlajtoa desde elfecac. Oniechelfe: “Deus quejtulo que ye cate cuajcuale hua chepöjque para cuale tequencuös. Amo xequejto que amo mocuöne lo que tli Deus quejtulo que ye ica chepöhuac para cuale tejcuös”. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ejqueu omochi yexpa, hua entunses noche inu sösantle tli nequejtac uya ocsajpa elfecac. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Miero cuöquenuju oaseto yete tlöca ompa pa inu cale cöne oteyeya. Sente tlöcatl oquentitla desde Cesarea para oniechtiemuto naja. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Espíritu Sönto oniechelfejque nele ma nebeya ca yejua hua majcamo noportöro de ocsie maniera ca yejua. Uyajque ca naja nuyejque nöncate checuasieme tocnihua. Tonochtie otecalajque ipa ichö de inu tlöcatl pa Cesarea. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Inu tlöcatl otiechpuebele quiene oquejtac sente öngel tli ocalac pa ichö. Oquelfe öngel: “Xequentitlane seque tlöca ma yöcö pa puieblo de Jope para quenutzatibe Semu öque nuyejque mocuitea Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Yaja metzelfis quiene ca taja hua innochtie tli cate mochö nemomöquextisque de nemotlajtlacul”. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Quiemach onepie nequennunutz cuöc Espíritu Sönto ocalacoac ipa inyulo iguöl quieme antes ocalacoac ipa toyulo tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Entunses onequelnömec lo que tli oquejtojque Tlöcatzintle: “Xohuö otlacuötieque ca ötzintle, pero nemejua nemocuötiequisque ca Espíritu Sönto”. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pos Deus quenmacaque Espíritu Sönto ma calacoa ipa inyulo quieme otiechmacaque tejua por toneltocaque ca Tlöcatzintle Jesucristo. ¿Öquenu noso necaca naja para ma netietzacuele Deus? ");
INSERT INTO nhgNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Entunses cuöc inu creyentes tli oyejyeya pa Jerusalén oquecajque inu, amoyetla cache oquejtojque, tlöcamo sa tieyectieniejque Deus. Oquejtojque: ―Tlöjcu Deus oquenejque que tli amo joriojte nuyejque ma moyulcuepacö para quepejpeasque nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Cuöc giente oquemectejque Esteban, opiejque quentepotztocaque ocseque creyentes nuyejque. Inu creyentes omoxiexelojque. Seque uyajque hasta pa nación de Fenicia, seque pa nación de Chipre, hua seque hasta pa puieblo de Antioquía. Pa niecate locör inu creyentes quennunutzque sa joriojte de cuale tlamachestelestle. Amo quennunutzque ocseque tli amo joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Seque creyentes de inu nación de Chipre hua de puieblo de Cirene de ocsente nación oaseto ompa pa Antioquía. Oquennunutzque giente tli tlajtlajtoöya ca griego de cuale tlamachestelestle de Tlöcatzintle Jesucristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tlöcatzintle quenmacaque beletelestle para tlanunutzasque cuale, hua meyactie moneltocaque hua mocuejque ca Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Cuöc inu grupo de creyentes pa Jerusalén oquecajque inu, oquetitlanque Bernabé hasta Antioquía. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cuöc oaseto ompa, Bernabé oquejtac quiene ca Deus quenmacaque tiefavur, hua opajpöc lalebes. Oquentlajtulmacac inu creyentes ma quesequirucö ca sentetl inyulo hua ma seme tietocacö Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Pos Bernabé oyeya sente cuale tlöcatl, hua iyulo tientaya de Espíritu Sönto, hua seme moneltocaya ca Deus. Ejqueu noso, meyactie omotlölejque de pörte de Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Sötiepa Bernabé uya ca puieblo de Tarso. Quetiemuto Saulo. Cuöc oqueniexte, oquebicac hasta puieblo de Antioquía. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Bernabé hua Saulo sie xejtejque ompa intzölö inu creyentes. Quenmachtiöya meyactie. Giente quencuitejque inu creyentes “cristianos”. Así es que omocuitejque “cristianos” cachto ipa puieblo de Antioquía. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pa niecaju tiempo seque tlayulepantejque tli quennunutzaya giente de tietlajtultzi Deus uyajque desde Jerusalén para ca Antioquía. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Sente de yejua itucö Agabo. Omoquetz intzölö creyentes. Espíritu Sönto oquepaliebejque para quemates quejtus que mochihuas ca nobeyo sente bieye öpestle. Pos ejqueu omochi pa inu tiempo cuöc Claudio oyeya emperador. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Entunses inu creyentes de Antioquía quetzontejque quetitlanesque seque tomi ca hermanos tli chönteya pa estado de Judea. Cara sesen tlöcatl ma quetiemaca lo que tli podierebeya. ");
INSERT INTO nhgNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ejqueu oquechijque. Oquetitlanque inu tomi ma quebicacö ca biebentzetzi tli quentlachiliöya creyentes ompa pa Judea, para ma quenxiexelfelicö hermanos. Oquetitlanque inu tomi tli omonecheco ca Bernabé hua Saulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pa niecaju tiempo inu rey Herodes opie quentepotztoca seque creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Oquemecte Jacobo icni Xohuö ca espöda. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Cuöc oquejtac que oquenparesiero joriojte, pos nuyejque ocasec Piero. Ejqueu oquechi rey Herodes miero pa yelfetl de pöntzi tli amo quebica levadura. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Cuöc Herodes ocasec Piero, oquetzajtzac ipan cörsel. Oquentlöle nöbe grupos de soltörojte ma quixuticö. Cara grupo quepeaya nönöbe soltörojte. Herodes oquepensöro que san tequetl panus pöscua quequextisquea Piero para quepresentörus ca giente. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Así es que soltörojte quixutiöya Piero pa cörsel. Cache inu creyentes oquesequirojque motlajtlötlajtiöya ca Deus ca meyac tlanequelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Inu yohuale antes que Herodes quequextisquea Piero para quepresentörus ca giente, Piero cochtaya entre unte soltörojte. Ilpetaya ca unte carienajte. Ocseque soltörojte oyejyeya ca queyöhuac itech pobielta. Tlajpeaya pa cörsel. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Sa de repiente sente öngel de Deus oniestequis hua otlaniestequis pa cörsel. Inu öngel oquetepine Piero pa isieyecatetla. Oquexete hua oquelfe: ―Xemiejtiehua. Entunses inu carienajte obetzque de ipa imöhua Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Inu öngel oquelfe: ―Xomotlajcoilpe hua xomocacte. Cuöc Piero omotlajcoilpe hua omocacte, inu öngel oquelfe: ―Xomöque ocseque motatapa hua xeniechtocate. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Cuöc Piero oquistie, oquetocac inu öngel. Amo quemateya que de melöhuac mochijtaya lo que tli inu öngel quechihuaya, tlöcamo oquepensöro que a lo mejur inu öngel sa omotieijtete ca yaja quieme cana cochtiemequelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Oquepanabejque inu primiero guardia hua inu ocsente guardia. Oajaseto itlac inu pobielta de tepostle tli quisa pa cayaju de inu ciudad. Sa isiel omotlapo. Pos inu öngel hua Piero oquisque. Cuöc ye onejnenque sie cuadra, inu öngel sa nima oquecöjtie Piero sa isiel. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Entunses Piero omoteteiscale hua oquejto: ―Öxö necmate por seguro que es de melöhuac. Deus ocualtitlanque tieöngel para niechmöquextis de imöpa rey Herodes hua para niechmöquextis de lo que tli joriojte oquepensörojque niechchibelisquea. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Cuöc Piero omomacac cuienta que de melöhuac oquis de ipa cörsel, uya ca ichö María inöntzi de Xohuö, öque nuyejque mocuitiöya Mörcos. Ompa pa ichö María meyactie ye omosentlölejque hua motlajtlötlajtejtaya. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Cuöc Piero oquetzotzo pobielta pa cayaju, sente sisehuantu itucö Rode oquis de icalejtec hasta pa pötio. Oquejtato abier öquenu quetzotzona pobielta. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pero cuöc oquixomat que yaja Piero öque tzajtze pa pobielta, opajpöc tönto que amo oquetlaijtlapolfe, tlöcamo omocuec ca icalejtec para tlanahuatito que Piero ompaca pa pobielta. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Entunses oquelfejque sisehuantu Rode: ―Taja ye telucojte. Cache yaja ipa hua ipa oquejto que melöhuac hua que melöhuac. Pero yejua oquejtojque: ―Amo yaja. Beles cana iöngel. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pero Piero oquesequiro quetzotzontaya pobielta. Por fin otlaijtlapojque. Oquejtaque Piero hua oquetietzöbejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero Piero ca imö oquechibele sieña nele ma sa yetacö. Entunses Piero oquenpubele quiene ca Deus oquequextejque de ipa cörsel. Oquemelfejtie Piero: ―Xequemelficö Jacobo hua noche ocseque tocnihua de lo que tli omochi. Entunses Piero oquistie de ompa hua uya ca ocsie löro. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Cuöc otlanies, lalebes omopasolojque inu soltörojte porque amo ocasojcömatque tli beles omochi ca Piero. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Rey Herodes otlatitla ma quetiemucö Piero pero amo oqueniextejque. Entunses Herodes oquentlajtlane inu soltörojte de inu asunto, pero abele oquemacaque arrasu. Yecuöquenu otlatitla ma quenmejmecticö inu soltörojte. Sötiepa Herodes oquis de estado de Judea para ca puieblo de Cesarea. Omochöntito ompa. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Rey Herodes cualöntaya inca giente de puieblos de Tiro hua de Sidón ipa ocsente nación. Inu giente sa secne omopresentörojque pa palacio de inu rey. Sente tlöcatl itucö Blasto oyeya sente tlajtoöne para inu rey. Yejua de Tiro hua Sidón oquechijque Blasto amigo de yejua. Oquenejque ma quenpaliebe queyulsiebisque inu rey porque de yaja queresibirojtaya meyac tlacuale de ipa tlöle de inu rey. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Entunses Herodes oquetzontec que pa töl tunale quetratörus inu asunto ca yejua. Cuöc oaseco inu tunale omöque Herodes itzotzomajua de rey. Motlölito ipa itrono imixtla meyac giente. Cuöquenuju oquennunutz. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Pos giente otzajtzajtzeque lalebes. Oquejtojque: ―¡Tlajtlajtuluteca sente Deus! ¡Nöiloac tlöcatl amo sa tlöcatl iloac, tlöcamo sente Deus! ");
INSERT INTO nhgNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pa inu momento sente öngel de Deus oquechihualte Herodes ma mococo porque amo otiechamöjque Deus, tlöcamo oquencö giente ma quechamöhuacö sie yaja. Pos meyactie ocuelte oquecuajque icuierpo de inu rey hua ocueloac hasta cöne omec. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Cache hua cache meyac giente oquecactaya tietlajtultzi Deus hua ca nobeyo inu creyentes oquennunutzque giente de tietlajtultzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Cuöc Bernabé hua Saulo oquetlamejque inteque ipa Jerusalén, omocuejque. Oquebicaque Xohuö öque nuyejque mocuitiöya Mörcos. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Intzölö inu grupo de creyentes pa Antioquía oyejyeya seque tlayulepantejque hua seque tli tlamachtiöneme. Por ejemplo, Bernabé, Semu öque mocuitiöya Negro, Lucio de puieblo de Cirene, Saulo, hua Manaén, öque omobepö sa secni ca Herodes tli sötiepa oyeya tetrarca noso rey de estado de Galilea. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Sie tunale inu creyentes tlajyubejtaya hua mosentlölejque para tieteochihuasque Deus. Cuöquenuju Espíritu Sönto oquemelfejque: ―Xeniechnencuaxelfelicö Bernabé hua Saulo para tequetl tli nequixpejpe para yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Entunses cuöc otlajyubejque hua ye omotlajtlötlajtejque, quentlölejque inmöhua impa Bernabé hua Saulo hua quentitlanque ma yöcö. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ejqueu noso Espíritu Sönto quentitlanque Bernabé hua Saulo. Uyajque ca puieblo de Seleucia, hua desde ompa uyajque pa börco hasta pa tlöltojpole de Chipre. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Cuöc oaseto ompa, oaseto miero pa puieblo de Salamina. Opiejque tlanunutzque de tietlajtultzi Deus pa inu teopancucone cöne joriojte mosentlöliöya. Bernabé hua Saulo quebicaque Xohuö para ma quenpaliebe. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Opanuque ipa noche tlöle de Chipre hasta oaseto pa puieblo de Pafos. Ompau oquenömejque sente joreyo itucö Barjesús. Inu Barjesús quechihuaya sösantle de magia hua quencajcayö giente. Oquejto que yaja icaca sente tlayulepante de Deus, pero amo melöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Inu Barjesús oyeya itlac inu cubernadur itucö Sergio Paulo. Inu cubernadur cuale casojcömateya sösantle. Tlatitla ma quentzajtzelicö Bernabé hua Saulo porque oquenec quecaques tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Barjesús mocuitiöya nuyejque Elimas. Elimas quejtusneque öque quechihua sösantle de magia. Elimas omoponiero cuntra Bernabé hua Saulo. Oquetratöro quechihualtis cubernadur majcamo moneltoca. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pero iyulo de Saulo, öque nuyejque mocuitiöya Pöblo, tientaya de Espíritu Sönto. Entunses Pöblo quetejtieyejtac Elimas. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Oquelfe: ―¡Taja tetlacajcayöhuane! ¡Teyultepitztec! ¡Tecchihua lo que tli queneque yaja Diöblo! ¡Seme tecaca en cuntra de tlin cuale! Tieojfe Tlöcatzintle melactec ica, pero taja tequenmachtea giente lo que tli amo melöhuac para majcamo calaquecö ipa tieojfe Deus. ¿Ayec tejcöhuas tequenmachtis ejqueu? ");
INSERT INTO nhgNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Öxö Tlöcatzintle metzcastecörusque. Tixcocoxcöteas hua abele tetlacheas por sie tiempo. Sa nima yaja omocö pa tlayohuaquelestle hua pa tlanextecumelestle. Pos oquetiemo canajyeca ma quebica ca imö porque abele tlachea. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Cuöc inu cubernadur oquejtac lo que tli omochi, omoneltocac. Quetietzöbejtac quiene ca Pöblo hua Bernabé tlamachtiöya de sösantle de Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pöblo hua icompanierojua uyajque pa börco desde puieblo de Pafos para ca puieblo de Perge tli mocöhua pa tlöle itucö Panfilia. Xohuö oquencöjtie hua omocuec ca Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pöblo hua Bernabé oquisque de Perge para ca inu puieblo de Antioquía tli ica itlac tlöle de Pisidia. Pan söbro, cuöc joriojte mosiebea, ocalajque pa teopanconetzi. Omotlölito. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Entunses canajyeca oquetlajtulte tietlajtultzi Deus ipa ömame de inu ley de Deus hua ipa ömame tli oquejcuelojque inu tlayulepantejque. Yecuöquenu tlayecönque de inu teopanconetzi oquetitlanque sente tlöcatl ma quemelfite Pöblo hua Bernabé ejqueyi: ―Tlö quejtus nemejua nenquepea canajyetla consiejo para giente cuale nenquejtusque ahorita. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Entunses Pöblo omoquetz. Oquenchibele giente sieña ca imö ma sa yetacö. Oquejto: ―Señores de tonación Israel, hua nemejua tli nentiemabelea Deus, xejcaquecö noso. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Deus de tonación Israel oquemixpejpenque totötajua. Oquensentlölejque para yesque sente bieye nación. Inu omochi cuöc turavea oyejyeya pa nieca nación de Egipto. Entunses quenquextejque de ompau ca meyac beletelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Por cuarenta años Deus quexicojque quiene ca quechihuaya pa inu locör cöne nionöque chönte. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Deus quenpojpolojque giente de ipa checume naciones tli chönteya pa tlöle de Canaán. Noche intlöl de yejua Deus quenmacaque totötajua. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Inu omochi sobre cuatro cientos cincuenta años. Nuyejque por meyac xebetl Deus quentlölelejque tlötlajtoönejme que mocuitiöya jueces, hasta tiempo de inu tlayulepante Samuel. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Totötajua oquenejque quepeasque sente rey. Entunses Deus quenmacaque Saúl quieme rey por cuarenta años. Saúl oyeya iconie Cis hua oyeya de inu grupo de Israelitas itucö Benjamín. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sötiepa Deus ayecmo quecöjque Saúl ma iye rey tlöcamo quetlölejque David quieme rey. Deus quecualejtaque David. Oquejtojque ejqueye: “Ye onecniexte ini nönca David iconie Isaí. Yaja icaca sente cuale tlöcatl tli nejcualejta lalebes. Icaca seguro que yaja quechihuas noche tli naja necneque”. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","’Jesús iloac iConie David. Entunses confurme lo que tli Deus oquejtojque ca ye niepa que quechihualusquea, yejuatzi tietitlanuc Jesús para tiechmöquextisque tejua teisraelitas. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Antes Jesús ohualiloac, Xohuö Bautista otlanunutz intzölö noche giente de Israel. Oquemelfe nele ma moyulcuepacö de intlajtlacul hua ma mocuötiequecö. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tepetzi antes que Xohuö Bautista omec, oquejto: “¿Öquenu nenquepensöroa que naja necaca? Pos naja amo necaca öque nenquepensöroa necaca. Pero sötiepa de naja hualiloas ocsie tlöcatl, öque nimpor amo necmeresieroa para nequenquextis tiecacua”. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","’Nocnihua, tli nencate nenipelhua de Abraham, hua nuyejque nencate tli nencate totzölö tli nentiemabelea Deus, xecmatecö que Deus quenequihua que tonochtie ma tejcaquecö nönca tlajtule tli tiechelfea quiene ca tomöquextisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Pa teopanme giente quentlajtultea ömame de tlayulepantejque. Ejqueu quechihua cara semöna pan söbro, cuöc tosiebea tli tejoriojte. Sin embargo, giente tli chönteya pa Jerusalén, ca tiehua intlajtoönejua, amo casojcömatque tli quejejtoa inu ömame, nimpor amo tieixomatque Jesús. Cache yejua mismos oquecumplirojque lo que tli ca ye niepa oquejtojque inu tlayulepantejque. Oquecumplirojque cuöc inu tlötlajtoönejme tiecuntenörojque Jesús para ma mecoa. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Mös amo oqueniextejque niontle arasu para ma tiemecticö, de todos modos yejua quetlajtlanejque Pilöto ma tiecoruspelo Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pos ejqueu oquecumplirojque noche lo que tli tlajcuelulpa oyeya de yejuatzi ipa teotlajtule que tiepa mochihuasquea. Yecuöquenu oquetemubejque tiecuierpo de ipa corujtzi hua quetlölejque ijtec mejcöcoyoctle. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Cache Deus tieyulebitiluc Jesús de intzölö mimejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Hua seque tlöca onyajque ca Jesús de ipa estado de Galilea para ca Jerusalén. Inu omochi antes que Jesús omecoac. Sötiepa de que oyulebihuac, inu tlöca tieijtaque Jesús por meyac tunalte. Öxö yejua cate quiename testigos de inu sösantle, hua tlajtlanunutzteneme intzölö giente de topuieblo de joriojte. Quennunutza de yejuatzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","’Así es que tejua nemiechmachestejtecate de nönca cuale tlamachestelestle, que Deus ye oquecumplirojque lo que tli yejuatzi quenprometierfejque totötajua que quechihualusquea. Tejua tecate teinpelhua de totötajua. Por inu lo que tli Deus quenprometierfejque totötajua, ye quecumplirojque ca tejua. Quecumplirojque cuöc tieyulebitiluc Jesús. Ca ye niepa Deus oquejtojque que sie tunale tieyulebitilus Jesús cuöc oquejtojque ejqueyi ipa Salmo dos: Taja tenoConie; öxö temetzchihualte para ma xeye tenoConie. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Hua de que tieyulebitiluc Jesús para majcamo palöne tiecuierpo, Deus oquejtojque ejqueyi: Seguramente nemiechmacas nemejua noche inu bendiciones lo que tli onequelfe David que necmacas yaja. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ejqueu quejtulo ipa ocsente Salmo: Tejuatzi amo tomocöbelis tiecuierpo de tlöcatl yectec ma palöne. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David omec cuöc ye oquentequepolo igiente quieme Deus oquenejque. Pos giente oquetlölejque icuierpo ijtec mejcöcoyoctle cöne oyejyeya incuierpos de itötajua. La mera verdad es que ompa icuierpo de David nuyejque opalö. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pero tiecuierpo Jesús amo opalö porque Deus tieyulebitiluc Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Xecmajtacö noso, nocnihua, que tejua nemiechmachestejtecate que solamiente Jesús cuale nemiechtlapojpolfisque nemotlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Noche tli moneltoca ca Jesús, Deus quenselilo quiename yecteque, hua amo quelnömequihua de intlajtlacul. Pos inu abele mochihuas por öque mocuajpetzus para nemes confurme inu ley de Moisés. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Xecpeacö cueröro noso, majcamo mochihua ca nemejua lo que tli oquejcuelojque inu tlayulepantejque. Oquejtojque ejqueyi: ");
INSERT INTO nhgNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Xequejtacö nemejua tli nemoburlöroa. Nenquetietzöbejtasque hua nemixniempolusque. ¿Tlica? Porque naja necchihuas ca nemejua canajyetla tönto bieye que nimpor amo nemoneltocasque mös öque nemiechpubelis lo que tli necchihuas. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Sötiepa de que Pöblo oquejto inu, yaja ca Bernabé oquisque de ipa inu teopanconetzi. Hua inu giente quentlajtlanque ma quennunutzacö ocsajpa de Jesús pa ocsie söbro. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Cuöc giente omoxiexelojque de ipa inu teopanconetzi, meyactie joriojte quentocaya Pöblo hua Bernabé. Nuyejque quentocaya meyactie tli amo joriojte pero que ye ocalajque pa inu religión de joriojte. Pöblo hua Bernabé quentlajtulmacaya innochtie que ma quesequirucö ca sentetl inyulo ipa tiefavur Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pa checume tunale cöso noche giente de inu puieblo omosentlölejque para quecaquesque tietlajtultzi Tlöcatzintle. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Cuöc inu joriojte oquejtaque tönto giente, lalebes omoxicojque. Opiejque tlajtlajtoa en cuntra de lo que tli quejtoöya Pöblo. Checuatlajtojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Entunses Pöblo hua Bernabé otlajtlajtojque ca meyac balur. Quemelfejque joriojte: ―Tejua tecpeaya que cachto nemiechnunutzque nemejua nenjoriojte de tietlajtultzi Deus. Hua öxö amo nenqueneque nenqueselisque tietlajtultzi Deus. Ejqueu nenquedemoströroa que amo nenquemeresieroa nenquepeasque nemelestle nochepa. Ejqueu noso öxö tequennunutzatibe giente tli amo joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ejqueu tecchihuasque porque Tlöcatzintle ejqueu otiechmandörojque cuöc oquejtojque: Naja temetzixpejpe para teyes quiename sente tlöbile para tequentlöbis giente tli amo joriojte. Temetzixpejpe para tequenmacas nemöquextelestle ca giente de ca nobeyo pa tlöltecpactle. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Cuöc giente tli amo joriojte oquecajque inu, lalebes quenpöquelesmacac. Opiejque quejtoa que tietlajtultzi Tlöcatzintle lalebes cuale icaca. Omoneltocaque innochtie tli oquemixpejpenque Deus para quepeasque nemelestle nochepa. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Hua ca inu, giente de ca nobeyo pa niecaju tlöle oquecajque de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pero inu joriojte tlajtlajtojque ca seque sohuame tli seme quecumpliroa ca inreligión hua tli cache bejbeye momajtaya pa puieblo. Nuyejque tlajtlajtojque ca tlötlajtoönejme de puieblo. De inu maniera ocajcojque giente ma quentepotztocacö Pöblo hua Bernabé. Oquentojtocaque de pa inpuieblo hua de pa inu puieblos tli cache cierca oyejyeya. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Entunses Pöblo hua Bernabé oquetzetzelojque tlölcuiechtle de ipa imecxehua para quemejtetejque inu giente que amo queselejque tietlajtultzi Deus. Uyajque hasta pa puieblo de Iconio. ");
INSERT INTO nhgNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero tli tietocaya Cristo inyulo tientaya de pöquelestle hua de Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pa puieblo de Iconio Pöblo hua Bernabé insiepa ocalajque pa inu teopanconetzi de joriojte. Otlanunutzque ca meyac beletelestle, de manieras que meyactie joriojte hua tli amo joriojte moneltocaque. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Pero inu joriojte tli amo tlaneltocaque cajcojque giente tli amo joriojte. Quenchihualtejque ma quepensörucö mal de inu creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ejqueu noso Pöblo hua Bernabé omocöjque ompa meyac tiempo. Otlajtlajtojque ca meyac balur, pos oquepexque meyac confiönsa ca Tlöcatzintle. Hua yejuatzi quenchihualtejque giente ma casojcömatecö que Pöblo hua Bernabé quennunutztaya de tietlajtultzi tli quejtoa quiene ca öque quepeas tiefavur de Deus. Pos Tlöcatzintle quenmacaque beletelestle para oquechijque tlachihuale de sieñas hua tietzöbeme. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pero seque giente de inu puieblo omoquetzque ihua joriojte hua seque omoquetzque ihua inu tlateotitlanme Pöblo hua Bernabé. Pos amo quenparesiero innochtie iguöl. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Entunses joriojte hua tli amo joriojte omotlölejque de acuierdo ca tlötlajtoönejme para quenchicuaelfisque hua quentecaltisque Pöblo hua Bernabé. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Pero cuöc Pöblo hua Bernabé oquematque de inu, ocholojque hasta inu puieblos pa tlöle de Licaonia intucö Listra hua Derbe hua ca ocseque puieblos ca ompau. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ompa nuyejque quennunutzque giente de cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pa puieblo de Listra oyeya sente tlöcatl tli abele nejneme. Sa yehuataya porque oyeya cucuxojtzi desde que otlöcat hua ayec onejne. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Inu cucuxojtzi quecactaya lo que tli oquejto Pöblo. Pöblo quetejtieyejtac inu tlöcatl hua oquemat que inu cucuxojtzi moneltocaya hua por inu cuale pajtes. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Entunses Pöblo oquelfe checöhuac: ―Xomoyejquetza pa mocxehua. Pos yaja omoquetztequis hua opie nejneme. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Cuöc giente oquejtaque lo que tli oquechi Pöblo, opiejque tzajtzajtze ca inidioma tli tlajtlajtoöya ipa inestado de Licaonia. Oquejtojque: ―Ini tlöca ijiloac deuste. Ye onecuejcuepaluc quiename tlöca hua ye ohualtejtemoac totzölö. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Oquejtojque que Bernabé oyeya sente deus itucö Júpiter hua que Pöblo oyeya sente deus itucö Mercurio, porque yaja Pöblo öque tlajtlajtoöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Giente de inu puieblo quepeaya sente teopantle ca calquisyo cöne queteochihuaya indeus Júpiter. Inu teopexque de inu teopantle de Júpiter quenhualecac turojte tli inquechtla quehualecaya xuchetlatoscatl. Pos giente ca tiehua inu teopexque oquenejque quemectisquea inu turojte quieme bentle para Pöblo hua Bernabé. Ejqueu oquenejque quenteochihuasquea yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Pero cuöc inu tlateotitlanme Bernabé hua Pöblo ocasojcömatque lo que tli quechihuasquea, opiejque quetzutzomunejque intzotzomajua hua ocalactequisque intzölö giente. Otzajtzajtzeque. Oquejtojque: ");
INSERT INTO nhgNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","―Señores, ¿tlica nenquechihua ejqueu? Tejua tecate tetlöca iguöl quieme nemejua. Pos otehuölajque miero para nemiechelfisque de cuale tlamachestelestle para nenquecöhuasque noche ini nönca tli nenquechihua, porque amo serbirebe. Cache cuale xetietocacö yejuatziju Deus tli nemoa. Yejuatzi iloac öque oquechejchijque elfecac, tlöltecpactle hua lamör hua nuyejque noche tli quepejpea. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ca ye niepa Deus oquencöjque noche grupos de giente ma quechihuacö confurme lo que tli yejua oquenejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pero yejuatzi quenchibelejque noche giente tlin cuale. Hua ca inu quemejtetejque öquentzi yejuatzi. Pos yejuatzi tiechcajcöhualo queyabetl. Quechihualtilo tlöle ma quetiemaca cuale cosiechas. Yejuatzi tiechmacalo noche tli tiechpoloa para ejqueu tecpeasque tli tejcuösque hua toyulo pajpöques. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Mös oquejtojque ejqueu, oquencostöro Pöblo hua Bernabé meyac traböjo para quentzacuelejque giente, pos oc turavea oquenejque quenmectisquea inu turojte quieme bentle para ejqueu quenteochihuasquea. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pero sötiepa seque joriojte de puieblos de Antioquía hua de Iconio oaseto intzölö giente pa puieblo de Listra. Quentlötlabielmectejque inu giente para que yejua oquetecaltejque Pöblo. Entunses oquepensörojque que ye oquemectejque Pöblo hua quetlölochpöntöya hasta ca calquisyo de inu puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero cuöc inu creyentes mosentlölejque itlac Pöblo, yaja omie hua ocalac ocsajpa pa puieblo. Pa mustlateca Pöblo ca tiehua Bernabé oquisque de ompau para ca puieblo de Derbe. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ompa pa puieblo de Derbe oquennunutzque giente de inu cuale tlamachestelestle. Meyac giente opiejque tietocaya Jesús. Entunses omocuejque ca puieblos de Listra hua Iconio hua Antioquía. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Pa inu puieblos Pöblo hua Bernabé oquenyulchecöjque tli tietocaya Jesús. Quentlajtulmacaque ma quesequirucö ca noche sentetl inyulo ipa lo que tli ye moneltocaque. Quemelfejque que para öque aseti tietlac Deus cöne yejuatzi tlamandöruro onca nesesidad que öque quesufrirus meyac sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nuyejque Pöblo hua Bernabé quixpejpenque biebentzetzi de cara grupo de creyentes para que inu biebentzetzi ma quentlachilicö ocseque creyentes. Innochtie otlajyubejtaya hua omotlajtlötlajtejque. Yecuöquenu oquejtojque: ―Ma Deus nemiechixutilo porque ye nemoneltoca ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Sötiepa Pöblo hua Bernabé opanuque pa tlöle de Pisidia hua oaseto hasta pa tlöle de Panfilia. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Oquennunutzque giente de tietlajtultzi Deus pa puieblo de Perge. Sötiepa uyajque hasta puieblo de Atalia. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ompa otlejcoque pa sente börco. Uyajque hasta pan puieblo de Antioquía. Pöblo hua Bernabé antes oquisque de Antioquía cuöc primiero opiejque inbiöje. Pa inu tunale cuöc Pöblo hua Bernabé oquisque, inu creyentes omotlajtlötlajtejque que ma Deus quemixutilo hua ma quenmacalo tiefavur pa inu tequetl. Hua öxö ye omocuejque Pöblo hua Bernabé porque ye oquetlamejque inu tequetl. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Cuöc oaseto ompa pa Antioquía oquensentlölejque noche creyentes. Oquenpubelejque noche tli Deus oquechijque por yejua. Quenpubelejque quiene ca Deus oquenmacaque locör ca giente nuyejque tli amo joriojte ma moneltocacö ca Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pöblo hua Bernabé omocöjque meyac tiempo ompa intzölö creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pa inu tiempo seque tlöca oquisque de ipa estado de Judea hua uyajque pa puieblo de Antioquía. Opiejque quenmachtea inu hermanos ompau. Oquejtojque: ―Onca nesesidad ma xomonacayutequecö confurme inu costumbre tli oquetlöle yaja Moisés. Pos tlö amo ejqueu nenquechihuasque, abele nemomöquextisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pöblo hua Bernabé omixcomacaque ca yejua checöhuac. Entunses por fin inu creyentes oquemixpejpenque Pöblo hua Bernabé hua ocseque hermanos para yösque ca Jerusalén. Quetratörusque ini nönca asunto ca tlateotitlanme hua ca biebentzetzi tli quentlachilea inu creyentes pa Jerusalén. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Inu creyentes de Antioquía oquentitlanque ma yöcö. Ipa ojtle opanuque pa tlöle de Fenicia hua pa estado de Samaria. Cöne beletes ca uyajque otlapujtöya quiene ca giente tli amo joriojte oquecöjque de tli moneltocaya para tietocaya Deus. Pos noche hermanos opajpöjque lalebes cuöc oquecajque inu. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Cuöc Pöblo hua Bernabé oaseto pa Jerusalén, noche inu creyentes hua tlateotitlanme hua biebentzetzi oquenselejque ca meyac pöquelestle. Pöblo hua Bernabé oquenpubelejque noche lo que tli Deus oquechijque ca yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero omoquetzque seque de inu grupo de joriojte itucö fariseos. Yejua ye omoneltocaque tieca Jesús. Oquejtojque: ―Onca nesesidad ma tli amo joriojte ma monacayutequecö. Onca nesesidad nuyejque ma tequenchihualticö yejua ma quechihuacö confurme lo que tli quejtoa inu ley de Moisés. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Entunses omosentlölejque tlateotitlanme hua biebentzetzi tli quentlachiliöya creyentes. Omosentlölejque para questudiörusque inu asunto. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Sötiepa que yejua ye omonunutzque meyac tiempo, Piero omoquetz hua oquemelfe: ―Hermanos, nenquemate que pa tunalte tli topa ohualpanuc Deus oniechixpejpenque naja de entre nemejua para onequennunutzato giente tli amo joriojte. Pos ejqueu oquenejque ma yejua quecaquecö inu tlajtule de cuale tlamachestelestle hua ma moneltocacö. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Deus quematihuateca toyulo de tonochtie, hua yejuatzi otiechejtetejque quiene oquenselejque inu giente tli amo joriojte. Oquenmacaque Espíritu Sönto ma calacoa ipa inyulo iguöl quieme otiechmacaque tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Así es que Deus amo sa tejua otiechselejque tlöcamo nuyejque yejua. Yejua nuyejque oquenchepöjque inyulo de tlajtlacule porque monejneltocaque. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Hua öxö, ¿tlica noso nentiecualöntea Deus? Pos nenquenmömaltejtecate inu creyentes tli amo joriojte meyac sösantle. Nimpor totötajua abele oquecumplirojque noche inu, nimpor abele tejcumpliroa tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Pos amo ejqueu xecchihuacö por ini nönca arrasu. Tecpea confiönsa que Tlöcatzintle Jesucristo tiechmöquextisque solamiente por tiefavur, hua ejqueu mismo quenmöquextisque tli amo joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Entunses noche tli tlamachyejyeya ompa sa otlacactajque. Oquentiencajque Pöblo hua Bernabé porque Pöblo hua Bernabé oquenpubelejque de inu sieñas hua tietzöbeme tli Deus oquenpaliebejque para oquechijque intzölö giente tli amo joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Cuöc ye oquenpubelejque de inu, Jacobo oquejto: ―Hermanos, xeniechcaquecö. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón Piero otiechpubele quiene ca Deus oquechijque cuöc ca primera vez oquemixpejpenque seque giente de intzölö tli amo joriojte para tiehuöxcahua yesque. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Lo que tli oquejto Simeón icaca de acuierdo ca lo que tli oquejcuelojque niecate tlayulepantejque. Pos tlajcuelulpanca ejqueyi: ");
INSERT INTO nhgNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Sötiepa de ini nönca tiempo, nehuölös ocsajpa. Ocsajpa necyectlölis inu teopantle tli oquechejchijque David, tli ye oxexetu. Ocsajpa necajcoques tli ye obetz, hua ocsajpa necchejchihuas. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ejqueu necchihuas para que noche ocseque giente tietiemusque Tlöcatzintle, hua innochtie tli amo joriojte quenequesque niechtocasque, porque nohuöxcahua yesque. Ejqueu quejtulo Tlöcatzintle, oque quechihualo noche ini nönca sösantle ");
INSERT INTO nhgNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","tli omacheac desde yecsa tiempo. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","’Bieno, naja nequejtoa ejqueyi. Inu giente tli amo joriojte hua tli quecöhua de tli primiero moneltocaya para tietocasque Deus majcamo tequenpasolucö tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sa tequemejcuelfisque ejqueyi, que majcamo öque quecua niontle tlacuale tli giente quebentlölelea ixniehualojme. Majcamo öque mopöcte ca sente sohuatl noso sente tlöcatl que amo yaja incompaniero. Majcamo öque quecua nacatl de sente yulcötl tli ocucupötzmec. Nuyejque majcamo öque quecua yestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ma ejqueu tequemejcuelficö porque ejqueu quejtoa inu ley de Moisés, hua desde ca ye niepa oncate giente ipa cara puieblo tli tlanunutztebitze de inu ley de Moisés. Pos quentlajtultelea inu ley pa teopancucone cara semöna pan söbro. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Entunses inu tlateotitlanme hua inu biebentzetzi ca tiehua innochtie creyentes oquenparesiero cuale para quemixpejpenque seque de yejua. Quemixpejpenque para ma yöcö ca Pöblo hua Bernabé hasta pa puieblo de Antioquía. Entunses oquemixpejpenque Judas Barsabás hua Silas. Inu hermanos quenpeaya Judas hua Silas entre tli cache bieye momajtaya intzölö yejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Entunses inu hermanos oquentitlanque inu tlöca ma quebicacö sente cörta tli quejtoöya ejqueyi: “Tonochtie nemiechtlajpaloa nemejua nentocnihua tli amo nenjoriojte. Nemiechtlajpaloa nemonochtie tli nenchönte pa Antioquía hua pa tlöle de Siria hua pa tlöle de Cilicia. Tejua tetlateotitlanme hua tebiebentzetzi tli tequentlachilea tocnihua necö. Tejua tecate tecnijte de nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Tejua ye tecmate que seque onyajque de necö ca nemotlac sin que tejua otequentitlanque. Yejua onemiechpasolojque ca lo que tli oquejtojque. Hua öxö amo nenquemate tli nenquepensörusque ipa nemoyulo. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Porieso otonunutzque sobre inu. Tonochtie oteyejyeya de acuierdo hua otiechparesiero cuale para otequemixpejpenque seque tlöca de totzölö. Otecnejque ma quemöcompaniörucö totlasojcöicnihua Pöblo hua Bernabé para nemiechtlajpalutibe nemejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pöblo hua Bernabé yajyajteneme ipa meyac peligro hua cajcate dispuestos para mejmequesque tiepampa toTlöcatzintle Jesucristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Así es que nemiechtitlanelejtecate Judas hua Silas. Yejua nemiechpubelisque de noche ini nönca asunto. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Espíritu Sönto otieparesiero hua tejua nuyejque otiechparesiero cuale ma tecchihuacö ejqueyi. Tejua amo nemiechmömaltisque canajyetla ocsente para nenquechihuasque tlöcamo sa nönca. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Amo xejcuöcö sösantle tli giente oquetlölejque quieme bentle para ixniehualojme. Nuyejque amo xejcuöcö yestle. Amo xejcuöcö nacatl de sente yulcötl tli ocucupötzmec. Majcamo öque mopöcte ca canajyeca sente sohuatl noso tlöcatl que amo yaja icompaniero. Tlö ejqueu nenquechihuasque, lalebes cuale nenquechihuasque entunses. Noche ma iye cuale ca nemejua”. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Así es que inu creyentes oquentitlanque Judas hua Silas ca Pöblo hua Bernabé. Uyajque hasta pa Antioquía. Ompa oquensentlölejque noche creyentes hua oquenmacaque inu cörta. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Inu creyentes oquetlajtultejque. Lalebes oquenpöquelesmacac inu cörta por inu consiejo tli quebicaya. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas hua Silas oquennunutztenemeya giente de tietlajtultzi Deus, pues yejua nuyejque oyejyeya tlayulepantejque. Oquencuajpetzojque inu creyentes hua lalebes oquenyulchecöjque tieca Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Judas hua Silas oyejyeya ompa quiesque tunalte. Cuöquenuju oquepensörojque que ye mocuepasque ca hermanos tli ocualentitlanque. Entunses inu creyentes oquemelfejque ma yöcö ca cuale. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pero Pöblo hua Bernabé omocöjque pa Antioquía. Yejua ca tiehua meyactie ocseque hermanos oquesequirojque quenmachtea giente hua oquesequirojque tlanunutza de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Cuöc ye opanuc seque tunalte, Pöblo oquelfe Bernabé: ―Ma teyöcö ocsajpa para ma tequentlajpalucö tocnihua ipa noche inu puieblos cöne otetlanunutzque de tietlajtultzi Deus abier quiene cajcate. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé oquenec quebicas Xohuö öque nuyejque mocuitiöya Mörcos. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pero Pöblo oquepensöro que amo cuale quebicasque porque antes Xohuö oquencöjtie pa Panfilia, hua amo oquesequiro ca yejua pa inu tequetl. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Omixcomacataya tönto hua tönto hasta que omoxiexelojque. Bernabé oquebicac Mörcos hua innehua otlejcoque ipa börco para yösque hasta Chipre. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Entunses Pöblo oquenec ma beya Silas ca yaja. Inu creyentes omotlajtlötlajtejque que ma Deus quemixutele hua ma quenmacacö tiefavur. Ca inu Pöblo hua Silas uyajque. ");
INSERT INTO nhgNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ejqueu Pöblo opanuc hasta pa tlöle de Siria hua pa tlöle de Cilicia. Oquenyulchecö noche grupos de creyentes pa noche locör cöne opanuc. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Hua aseto pa puieblos de Derbe hua Listra. Ompa oquenömejque sente creyente itucö Timoteo. Timoteo oyeya iconie de sente sohuatl joreyo tli omoneltocac ca Cristo. Itajtzi oyeya griego. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Inu hermanos tli chajchönteya pa Listra hua pa Iconio oquejtojque que Timoteo lalebes cuale tlöcatl. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pöblo oquenec ma beya Timoteo ca yaja. Entunses Pöblo oquenacayutec Timoteo, porque joriojte pa niecate puieblos cöne yösque oquematque que itajtzi Timoteo oyeya griego. Pöblo amo oquenec ma quejtucö inu joriojte que Timoteo amo quecumpliroa ca inu costumbre de nacayutlatequelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pa puieblos cöne Pöblo, Silas hua Timoteo opanuque, oquennunutzque noche creyentes. Oquemelfejque lo que tli tlateotitlanme hua biebentzetzi pa Jerusalén oquetzontejque ma quechihuacö creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Así es que ipa noche locör noche grupos de creyentes ocaseque cache hua cache meyac neltoquelestle, hua cara tunale omomeyaquelejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Espíritu Sönto amo quencöjque Pöblo hua Silas ma yöcö para tlanunutzasque pa inu tlöle de Asia. Por inu, opanuque pa tlöle de Frigia hua pa tlöle de Galacia. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ajaseto cöne monetechojtecate inu tlöle de Misia hua inu tlöle de Bitinia. Oquepensörojque calaquesque pa inu tlöle de Bitinia, pero Espíritu Sönto, öque Jesús tiehualtitlanuc, amo oquencöjque ma calaquecö ompau. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Entunses opanuque pa Misia sa itienco. Ajaseto itech lamör pa sente puieblo itucö Troas. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ompau Pöblo oquejtac quiename sente cochtiemequelestle ca yohuale. Oquejtac sente tlöcatl de tlöle de Macedonia. Inu tlöcatl omotlötlajte ca Pöblo, hua oquejto: “Xepano ca nö löro ca ipan tlöle de Macedonia. Xetiechpaliebique”. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Cuöc Pöblo ye oquejtac hua otlachix, entunses otectiemojque sente börco para teyösque ca Macedonia. Otecpexque por seguro que Deus otiechnutzaloöya ma tequennunutzacö inu giente de inu cuale tlamachestelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Entunses otetlejcoque pa börco pa puieblo de Troas. Oteyajque deriecho para inu tlöltojpole ijtec lamör que itucö Samotracia. Pa mustlateca otaseto pa puieblo de Neápolis noso Pueblo Nuevo. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","De ompau oteyajque hasta inu puieblo itucö Filipos. Filipos oyeya sente puieblo de inu romanos. Cache bieye omomajtaya intzölö ocseque puieblos de inu pörte de Macedonia. Ompa oteyejyeya seque tunalte. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sie semöna pan söbro otequisque de ipa puieblo. Oteyajque itlac sente ötlactle porque otecpensörojque que ompau oyes sente locör cöne giente quepeaya costumbre motlajtlötlajtiöya. Cuöc otaseto, seque sohuame ye ompa oyejyeya. Entunses ototlölejque ompau hua otequennunutzque. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Sente de inu sohuame itucö Lidia. Oyeya de sente puieblo itucö Tiatira. Lidia quenamacaya cuajcuale tzotzomajtle tli morörojtec. Nuyejque tieteochihuaya Deus. Lidia oquecac lo que tli tequejtojtaya. Hua Deus oqueyulomajmötocaque para ma quechihua cöso de lo que tli Pöblo quejtoöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Mocuötieque yaja hua noche tli chajchönteya ipa ichö. Sötiepa de inu Lidia otiechtlalfe. Oquejto: ―Tlö nemopensörfea que naja de melöhuac noneltoca tieca Tlöcatzintle, xehualmobicacö xomocalutejtzinucö pa nochö. Pos otiechnelchibele ma tocöhuacö pa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Sie tunale oteyöya para inu locör cöne totlajtlötlajtiöya. Otecnömejque sente sisehuantu tli quepeaya sente moxicoöne. Inu moxicoöne cuale quejtoöya tli pasörebes antes que mochihuas. Itiecojua de yaja oquetlönque meyac tomi porque inu sisehuantu cuale quemelfea giente tli pasörebes ca yejua mustla bictla. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Inu sisehuantu opie tiechtoca Pöblo hua tejua. Oquejto checöhuac: ―Nöncate tlöca tietequepanoa Deus tli lalebes bieyetzintle. Yejua nemiechnunutza quiene ca nemomöquextisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ejqueu oquechi por meyac tunalte. Por fin Pöblo oquesentiro hua omocuectequis. Oquelfe inu moxicoöne: ―Tietucöyupantzinco Jesucristo temetznahuatea: Xequisa de ijtecopa inu sisehuantu. Pos sa nima inu moxicoöne oquis. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pero itiecojua de inu sisehuantu oquejtaque que ayecmo oquepexque maniera quiene ca quetlönisque tomi por medio de inu sisehuantu. Entunses oquemaseque Pöblo hua Silas. Oquenbicaque ca tlötlajtoönejme ca tlaijtec pa plösa. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Quenpresentörojque ca inu tlötlajtoönejme. Oquejtojque: ―Nöncate tlöca cate joriojte. Chöchalöne pa topuieblo. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Quenmachtea giente de costumbres tli tejua abele tecselisque nimpor amo conbenierebe tecchihuasque porque tejua teromanos tecate. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Entunses inu giente omajcojque cuntra Pöblo hua Silas. Inu tlötlajtoönejme otlanahuatejque ma quenquextelicö intzotzomajua para ma quenbitequecö ca tlacutl. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Cuöc ye oquenbitejque meyac, tlötlajtoönejme oquencalaquejque pa cörsel. Oquelfejque inu cörseliero ma quemixute ca meyac cueröro. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Cuöc oquecac inu cörseliero quiene ca oquenahuatejque, oquencalaque Pöblo hua Silas ipa inu calejtec cache ca tlaijtec pa cörsel. Ompa oquencöjtie ca imecxehua tzecajtaya entre unte bepalte. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Quieme ca tlajco yohuac Pöblo hua Silas motlajtlötlajtiöya hua tiecuicatiöya Deus. Hua inu ocseque priesoste quencactaya. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Sa de repiente otlöole lalebes checöhuac hasta que oquetzetzelo inu cimientos de cörsel. Pa inu momento noche pobieltajte omotlapojque. Noche carienajte omotojtonque de ipa priesoste. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Yecuöquenu inu cörseliero otlachix. Oquejtac que noche pobieltajte tlapojtaya. Ca inu oquequexte iespöda para momectisquea porque oquepensöro que inu priesoste ye ochucholojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pero Pöblo oquetzajtzele: ―Amo xomomecte. Nö tecate tonochtie. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Entunses inu cörseliero otlajtla por sente tlöbile. Ocalactequis. Omotlajcal imicxetla Pöblo hua Silas. Pos omajcöbebeyocaya. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Entunses corseliero oquenbicac Pöblo hua Silas ca queyöhuac. Oquentlajtlane: ―Señores, ¿tli necchihuas para nomöquextis? ");
INSERT INTO nhgNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yejua oquejtojque: ―Xomoneltoca ca Tlöcatzintle Jesús hua tomomöquextis taja ca noche tli cajcate pa mochö. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Entunses Pöblo hua Silas oquenunutzque yaja de tietlajtultzi Tlöcatzintle ca tiehua noche tli oyejyeya ipa ichö. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Mös turavea ca yohuale oyeya, inu cörseliero oquenpöcac heridas de Pöblo hua de Silas. Entunses inu cörseliero ca noche isohua hua ipelhua sa nima mocuötiequejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sötiepa inu cöseliero oquenbicac Pöblo hua Silas ca ichö. Ompa oquentlamacac. Yaja ca noche tli oyejyeya pa ichö opajpöjque porque ye omoneltocaque ca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Ca ise inu tlötlajtoönejme cualentitlanque policías. Oquelfejque inu cörseliero: ―Xequencajcöhua inu niecate tlöca ma quisacö. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Entunses inu cörseliero oquelfe Pöblo: ―Ye oniechnahuatejque inu tlötlajtoönejme nele ma nemiechcajcöhua. Xehuölöcö noso, hua xeyöcö ca cuale. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pero Pöblo oquemelfe inu policías: ―Tejua tecate teciudadanos romanos. Tlötlajtoönejme otiechbitejque imixtla giente. Otiechbitejque mös amo yetla oqueniextejque cuntra tejua para otiechbitejque. Sötiepa otiechcalaquejque ijtec cörsel. Hua öxö ¿beles tiechcajcöhuasque sa ichtecajtzi? Majcamo ejqueu. Ma huölöcö yejua mismo para tiechquextisque. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Inu policías oquemelfito tlötlajtoönejme de noche inu. Pos inu tlötlajtoönejme omajcömejque cuöc oquematque que Pöblo hua Silas oyejyeya ciudadanos romanos. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Entunses uyajque hua oquentlajtlanejque Pöblo hua Silas ma quenperdonörucö lo que tli oquenchibelejque. Sa nima oquenquextejque de ipa cörsel. Oquentlötlajtejque ma quisacö de inu puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Entunses Pöblo hua Silas oquisque de ipa cörsel hua uyajque ca ichö de Lidia. Cuöc ye oquemejtaque hermanos hua oquentlajtulmacaque, entunses uyajque. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pöblo hua Silas opanuque pa puieblos de Anfípolis hua Apolonia. Sötiepa ajaseto pa puieblo de Tesalónica. Ompa oyeya sente teopanconetzi de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Confurme inu costumbre tli quepeaya, Pöblo uya pa inu teopanconetzi. Por yeye semöna pa cara söbro tlajtlajtoöya ca yejua. Ocasec tietlajtultzi Deus ");
INSERT INTO nhgNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","para oquemelfe que inu Cristo öque Deus otieixpejpenque oquepexque que quesufrirusque hua que mecoas hua que yulebihuas. Pöblo oquejto: ―Naja nemiechnunutza de Jesús. Bel yejuatzi Jesús iloac Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Entunses seque de yejua omoneltocaque hua mosietelejque ca Pöblo hua Silas. Ompa oyejyeya griegos tli tieteochihuaya Deus. Omoneltocaque meyactie de inu griegos nuyejque hua meyactie sohuame tli cache bejbeye momajtaya pa puieblo. Yejua nuyejque mosietelejque ca Pöblo hua Silas. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pero inu joriojte tli amo moneltocaque ochöhuatque lalebes. Oquensentlölejque seque tlöca tli tlatzejque hua yulpetzoteque. Ca yejua ocajcojque giente hua chöchalönque pa puieblo. Otlatiemuto pa ichö de Jasón. Quentiemoöya Pöblo hua Silas. Oquenejque quenquextisquea para quenbicasquea pa junta. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Cuöc amo oquenniextejque ompa, oquenbicaque ca fuiersa Jasón hua ocseque hermanos. Oquenbicaque ca intlac tlötlajtoönejme de inu puieblo. Oquejtojque: ―Nöncate tlöca quenpasolojteneme giente ca nobeyo ipa noche tlöltecpactle. Hua öxö ye ohuölajque ca necö. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Nönca Jasón ye oquencalute pa ichö. Yejua quechihua cuntra inu leyes de torey César. Quejejtoa que onca ocsente rey que yaja Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Cuöc giente hua tlötlajtoönejme oquecajque inu, omotequepachojque. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jasón hua inu ocseque creyentes oquenmacaque fiönsa de tomi hua ca inu oquencöjque ma yöcö. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Sa nima inu hermanos oquenchihualtejque Pöblo hua Silas ma quisacö inu yohuale para ca pan puieblo de Berea. Cuöc Pöblo hua Silas ajaseto pa Berea, uyajque miero pa teopanconetzi de joriojte. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Inu joriojte de Berea cache cuale giente oyejyeya que inu joriojte de Tesalónica. Oquecajque tietlajtultzi Deus ca meyac gönas. Mumustla oquetiemojque ipa teotlajtule para abier tlö oyeya ejqueu quiene Pöblo hua Silas oquemelfejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hua ca inu meyactie joriojte omoneltocaque. Nuyejque entre inu griegos omoneltocaque meyactie sohuame tli bejbeye omomajtaya pa inu puieblo, hua omoneltocaque meyactie tlöca. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pero cuöc inu joriojte de Tesalónica oquematque que Pöblo oyeya pa Berea hua quennunutztaya giente de tietlajtultzi Deus, entunses yejua uyajque pa Berea. Oquentlötlabielmectejque giente hua giente chöchalönque. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Cuöquenuju inu hermanos sa nima oquetitlanque Pöblo ma beya hasta itech lamör. Pero Silas hua Timoteo omocöjque pa Berea. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Inu tlöca tli uyajque ca Pöblo oquebicaque hasta pa puieblo de Atenas. Entunses yejua omocuejque ca Berea. Oquemelfejque Silas hua Timoteo lo que tli Pöblo oquejto, que ma Silas hua Timoteo ma yöcö sa nima para ipa asesque Pöblo pa Atenas. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Mientras que Pöblo quenchixtaya Silas hua Timoteo pa Atenas, omotlöocolte porque oquemejtac meyactie ixniehualojme pa inu puieblo. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Yaja ica pa inu teopanconetzi Pöblo tlajtlajtoöya ca joriojte hua ca giente tli tieteochihuaya Deus. Nuyejque mumustla tlajtlajtoöya ca giente tli quennömejque pa plösa. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ompa oyejyeya seque tlöca tli questudiörojque libros de giente tli mocuitejque epicureos hua ocseque tli questudiörojque libros de giente tli mocuitejque estoicos. Seque oquejtojque: ―¿Tlininu tiechelfisneque nönca tlöcatl tli tönto tlajtlajtoa? Ocseque oquejtojque: ―Niese que quechihua propaganda para ocseque deuste. Ejqueu oquejtojque porque Pöblo oquennunutz de Jesús hua de Yulebelestle. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Entunses inu giente oquebicaque Pöblo ipa sente locör itucö Areópago cöne seme quepeaya juntas. Yejua oquetlajtlanejque Pöblo: ―¿Cuale tetiechelfis claramente tli quejtusneque ini yancuec tlamachtelestle tli tecualecac? ");
INSERT INTO nhgNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Pos tetiechelfea tlimach tli amo tecasojcömate hua tecneque tecmatesque tli quejtusneque noche ini. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ejqueu oquejtojque porque noche giente de Atenas hua nuyejque noche giente tli amo de ompa oyeya pero ochajchöntejque ompa, amo quemimportöroa ocsente canajyetla tlöcamo sa queneque quejtusque hua quecaquesque noche tli yancuec. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Entunses Pöblo omoquetz intzölö yejua pa inu locör de Areópago. Oquejto: ―Señores de Atenas. Ca nobeyo nequejta que nemejua lalebes nenreligiosos nencate. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Naja netlachixtenemeya noche sösantle tli nencusöroa para nenquenteochihuasque noche nemodeushua. Onecniextito sente ajtöl cöne quejtoa ejqueyi: “Nönca ajtöl icaca para inu Deus tli amo tetieixomate”. Bieno, yejuatziju Deus öque nemejua nentieteochihua sin que amo nentieixomate, naja ahorita nemiechnunutzas. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","’Yejuatziju Deus oquechejchijque tlöltecpactle hua elfecac ca tiehua noche sösantle tli quepejpea. Por inu tiehuöxcaju noche elfecac hua tlöltecpactle. Así es que yejuatzi amo nemoa ipa teopame noso ipa ocsente locör tli tejua tequenchejchihua ca tomö. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Nuyejque tejua tli tetlöca abele tli tecchihuasque para yejuatzi, pos yejuatzi amo tli quenesesitöruro. Cache cuale yejuatzi tiechnemitilo tonochtie. Tiechchihualtilo tijyutea hua tiechmacalo noche sösantle. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","’Deus oquechijque sente tlöcatl. Itech inu tlöcatl Deus oquenchijque noche grupos de giente tli cate pa noche naciones, para ma nemecö ca nobeyo pa tlöltecpactle. Yejuatzi oquetzontejque tli tiempo nemesque inu grupos de tlöca hua quentlölejque inu grupos de tlöca ipa locör cöne yesque. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Oquechijque ejqueu para que giente ma tietiemucö yejuatzi ca inu esperanza de que cuale mopachusque tietlac hua ejqueu tieixomatesque yejuatzi. Pos de melöhuac Deus amo bejca iloac de cara sente de tejua. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tejua teneme por yejuatzi hua tojulinea hua oncö tecate por yejuatzi. Pos seque poetas de nemejua oquejtojque: “Tejua tecate tetiepelhua Deus”. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Entunses tlö tejua tecate tetiepelhua Deus, majcamo tecpensörucö que Deus iloac quiename sente ixniehualo de canajyetla tli öque quechejchihua de oro noso de plöta noso de tietetu. Tlöca quechejchihua cualtzetzi noche inu ixniehualojme sa quiene ca yejua quenenebelea, pero amo ejqueu iloac Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ca ye niepa amo casojcömatque tlöca lo que tli oquechijque cuntra Deus. Por inu Deus oquechijque quiename tlö amo yetla tlajtlacoöne. Cache öxö Deus quennahuatilo tlöca ipa noche locör que ma moyulcuepacö de intlajtlacul. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ejqueu Deus quenequihua ma toyulcuepacö porque quexelojque sente tunale para pa inu tunale ma quenjuscörucö noche giente de tlöltecpactle. Otieixpejpenque sente tlöcatl para que pa inun tunale inu tlöcatl quenjuscörusque giente san quiene ca conbenierebe. Pos Deus tieyulebitiluc inu tlöcatl de intzölö mimejque hua de inu maniera otiechejtetejque que tieixpejpenque para quechihuasque inu tequetl. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Cuöc inu griegos oquecajque que Jesús oyulebihuac de intzölö mimejque, seque omoburlörojque de inu. Ocseque oquejtojque: ―Cache cuale tejcaquesque pa ocsente tunale lo que tli taja tetiechnunutzteca. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ejqueu noso Pöblo oquis de ipa inu junta. ");
INSERT INTO nhgNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pero seque giente oquetocaque Pöblo hua omoneltocaque. Sente de yejua itucö Dionisio. Dionisio oyeya sente de yejua tli seme oyeya pa junta pa inu locör de Areópago. Nuyejque intzölö yejua oyeya sente sohuatl itucö Dámaris tli omoneltocac. Ocseque nuyejque omoneltocaque. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Sötiepa de inu, Pöblo oquis de Atenas hua uya hasta puieblo de Corinto. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ompa oquenömec sente joreyo itucö Aquila. Inu tlöcatl oyeya de sente tlöle itucö Ponto. Aquila hua isohua Priscila quiemach ohualiejque de inu nación de Italia porque inu emperador Claudio otlanahuate que noche joriojte ma quisacö de Roma, inu capital de Italia. Hua öxö ompa pa Corinto Pöblo oquentlajpalo pa inchö. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pöblo oquepex inu mismo tequetl tli yejua oquepexque. Por inu omocalute pa inchö hua ompa tequeteya. Pos yejua quechejchihuaya möntajcalte para quenamacasque. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Cara söbro Pöblo oyöya pa teopanconetzi. Ompa tlajtlajtoöya ca joriojte hua ca giente tli amo joriojte. Pöblo oquenec ma moneltocacö tieca Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Silas hua Timoteo ohualiejque de inu tlöle de Macedonia hua oaseto pa Corinto. Cuöquenuju Pöblo ye quennunutztaya giente de tietlajtultzi Deus mumustla. Oquemelfe joriojte que inu Cristo tli yejua quechixtaya ye ohualiloac. Oquemelfe claramente que Jesús iloac Cristo. Cristo quejtusneque Tlaixpejpentle de Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Pero inu joriojte opiejque omoponierojque hua ochecuatlajtojque. Entunses Pöblo oquetzetzelo itlaquie quieme sieñas de que amo oqueselejque tietlajtultzi Deus. Oquemelfe: ―Nemejua nenixniempolebesque pero nenquepea tlajtlacule nemejua mismo porque amo nenqueneque nemoneltocasque. Naja amo necpea tlajtlacule porque ye onemiechnunutz de Jesucristo. Desde öxö para ca adelönte naja neyös ca giente tli amo joriojte para nequennunutzas de yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pöblo oquis de inu teopanconetzi hua uya ca ichö de sente tlöcatl itucö Tito Justo. Inu tlöcatl tieteochihuaya Deus, hua chönteya itlac inu teopanconetzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Sente tlöcatl itucö Crispo oyeya tlayecönque de inu teopanconetzi. Omoneltocac tieca Tlöcatzintle ca noche isohua hua ipelhua. Nuyejque meyac giente de Corinto tli amo oyöya pa inu teopanconetzi oquecajque tietlajtultzi Deus. Omoneltocaque hua omocuötiequejque. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sente yohuale Pöblo oquejtac quiename ipa cochtiemequelestle que Deus oquelfejque: ―Amo xomomajte. Xecsequiro tetlanunutzas. Amo xejquetza mocamac. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Naja temetzixutejteneme. Amo öque nejcöhuas ma metzase para metzcocus. Pos oc meyactie giente pa ini puieblo moneltocasque ca naja. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pöblo omocö pa Corinto sie xebetl huan tlajco. Quenmachtiöya giente de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pa inu tiempo Galión oyeya cubernadur de inu tlöle de Acaya. Entunses joriojte omajcojque cuntra Pöblo. Oquebicaque ca itlac cubernadur Galión. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Oquelfejque cubernadur: ―Ini nönca tlöcatl quenmachtejteneme giente ma tieteochihuacö Deus de sie maniera tli amo icaca confurme toley. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pöblo tlajtlajtusquea pero Galión oquemelfe joriojte: ―Xequejtacö nenjoriojte. Amo xeniechpasolucö. Tlö nönca tlöcatl otlachtequene noso otlamectiöne noso canajyetla ejqueu, quienamo nemiechcaquesquea. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pero amo ejqueu icaca. Nemejua nencualöne por lo que tli quemachtea nönca tlöcatl hua por asuntos de tlajtulme hua tucöyume hua por inu ley tli nenquepea. Xecarreglörucö nemejua mismos. Naja quieme necubernadur amo necneque necalaques ipa ini nöncate asuntos. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Yecuöquenu ca fuiersa oquenquexte inu joriojte ca queyöhuac. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Entunses innochtie ocaseque Sóstenes öque tlayecönque pa inu teopanconetzi. Oquebitejque miero ompa ixtla inu cubernadur. Pero niontle de inu amo oquetlöocolte inu cubernadur Galión. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pöblo omocö pa Corinto meyac tiempo turavea. Sie tunale sötiepa oquennahuate hermanos que ye iya. Entunses Pöblo otlejcoc pa sente börco para iyös ca inu nación de Siria. Nuyejque Priscila hua Aquila uyajque ca Pöblo. Pa puieblo de Cencrea Pöblo omocuöpejpec hasta itzintech itzo quieme sieña de que oquepex sente compromiso ca Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Cuöc ajaseto pa puieblo de Efeso, Pöblo oquencöjtie Priscila hua Aquila. Ocalac ipa inu teopanconetzi hua tlajtlajtoöya ca joriojte tli ompa mosentlöliöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yejua oquetlalfejque Pöblo ma mocöhua cache meyac tiempo ca yejua pero amo oquenec. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Entunses Pöblo oquennahuate inu joriojte que ye iya. Oquejto: ―Mach Deus quenequesque nocuepas ocsajpa nemiechejtaqui. Entunses Pöblo otlejcoc pa börco hua oquistie de Efeso. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Pöblo opanuc pa puieblo de Cesarea. Yecuöquenu uya ca Jerusalén. Oquentlajpaluto inu creyentes tli omosentlöliöya ompa. Sötiepa omocuec ca Antioquía. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pöblo oyeya pa Antioquía quiesque tiempo. Yecuöquenu oquis ocsajpa. Oyöya primiero ipa tlöle de Galacia hua entunses ipa tlöle de Frigia. Cöne oyöya oquenyulchecöjtöya noche creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Sente joreyo itucö Apolos oaseto pa puieblo de Efeso. Oyeya de ciudad itucö Alejandría. Quepeaya maniera cuöcualtzi para tlanunutzas. Oquixomat tietlajtultzi Deus lalebes cuale. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Oqueyequixomat tieojfe Deus hua tlanunutzaya ca meyac gönas. Tlajtlajtoöya hua tlamachtiöya de Jesús perfectamente bien mös sa quemateya quiene ca öque mocuötiequis quieme Xohuö Bautista tlacuötiequiöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos opie tlajtlajtoa ca meyac balur pa inu teopanconetzi. Cuöc Priscila hua Aquila oquecajque Apolos, omonunutzque ca yaja. Oquemachtejque ocseque sösantle de tieojfe Deus tli Apolos quepoloöya. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Cuöc Apolos oquenec iyös ca pa tlöle de Acaya, inu hermanos de Efeso oqueyulchecöjque ma beya. Oquentlajcuelfejque creyentes de Acaya ma queselicö Apolos ca meyac confiönsa. Inu creyentes Deus oquenchibelejque bieye favur porque yejuatzi quenpaliebejque ma moneltocacö. Cuöc Apolos oaseto pa tlöle de Acaya, oquenpaliebe inu creyentes lalebes meyac. ");
INSERT INTO nhgNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Oquenpaliebe meyac porque cuöc omosentlölejque oquemejtete quiene ca joriojte motlapolultiöya. Pos inu joriojte amo quepeaya tli quejtusque. Joriojte quepeaya esperanza que sie tunale Deus tiehualtitlanesque inu Cristo öque yejuatzi tieixpejpenque. Apolos ocasec tietlajtultzi Deus hua oquemejtetejque giente que yejuatzi Jesús iloac Cristo. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Mientras que Apolos oyeya pa Corinto, Pöblo ocasec ojtle tli oyöya ca tlacpac. Oaseto pa Efeso cöne oquennömec seque creyentes. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Oquentlajtlane: ―¿Onentieresibirojque Espíritu Sönto ipa nemoyulo cuöc nemoneltocaque? Oquenönquelejque: ―Pos nimpor ayemo tejcaque tlö onca Espíritu Sönto. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Entunses Pöblo oquentlajtlane: ―¿Quiene ca nemocuötiequejque? Oquenönquelejque: ―Otocuötiequejque quieme Xohuö Bautista otlacuötieque. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pöblo oquemelfe: ―Xohuö tlacuötiequiöya quieme sieñas de que giente ye omoyulcuejque. Nuyejque Xohuö oquemelfe giente ma moneltocacö ca yejuatzi tli hualiloas sötiepa de Xohuö, es decir, ca yejuatzi Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Cuöc yejua oquecajque lo que tli Pöblo oquejto, omocuötiequejque tietucöyupantzinco Tlöcatzintle Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Cuöc Pöblo oquentlöle imöhua impa yejua, ocalacoac Espíritu Sönto ipa inyulo. Cuöquenuju yejua otlajtlajtojque ca ocsesen idiomas tli amo quemateya, hua otlayulepantejque de tietlajtultzi Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Oyejyeya quieme majtlactle huan ume tlöca por noche. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Por yeye mietztle Pöblo oyöya pa inu teopanconetzi. Tlajtlajtoöya ca meyac balur. Seme quennunutztaya giente hua quemelfejtaya quiene ca Deus tlamandörurus, para ma moneltocacö ca yejuatzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Pero seque omoyultepitzojque hua amo oquenejque tlaneltocaque ca tietlajtultzi Deus. Imixtla noche giente ochecuatlajtojque cuntra tieojfe Deus. Entunses Pöblo omoxelo de yejua. Oquenbicac inu creyentes pa sente esfiela cöne nuyejque tlamachtiöya sente tlöcatl itucö Tiranno. Pöblo monunutztaya mumustla ca yejua pa inu esfiela. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Ejqueu oquechi por ume xebetl. Porieso noche giente tli oyejyeya pa inu tlöle de Asia oquecajque tietlajtultzi Deus. Noche joriojte hua noche giente tli amo joriojte oquecajque. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Deus oquemacaque Pöblo beletelestle para oquechi tietzöbeme bejbeye. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Tönto lalebes bieye tlachihuale quechihuaya Pöblo que hasta panitojme hua babierojte oquentlölejque giente itech icuierpo. Yecuöquenu oquenbicaque ca intlac cocoxcötzetzi. Hua ca inu opajteque inu cocoxcötzetzi de incocoleshua hua moxicoöneme oquisque de imijtecopa. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ompa pa Efeso oyejyeya seque joriojte tli sa tiepa quequistenemeya. Yejua oquejtojque nele quepeaya beletelestle para quechihualtisque moxicoöneme ma quisacö de imijtecopa giente. Oquenejque cusörusque tietucöyutzi Tlöcatzintle Jesús para quenquextisque inu moxicoöneme de imijtecopa giente. Por inu cara sesen tlöcatl de yejua oquemelfe moxicoöneme: ―Pos Pöblo tlanunutza de Jesús. Hua öxö naja nemiechnahuatea tietucöyupantzinco sie yejuatzi Jesús, xequisacö. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ejqueu oquechijque inu checumeme ipelhua de sente joreyo itucö Esceva. Esceva oyeya sente jefe de teopexcötzetzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Pero cuöc inu checumeme tlöca oquejtojque ejqueu, sente moxicoöne oquennönquele. Oquejto: ―Nequixomate Jesús hua necmate öquenu Pöblo. Pero nemejua, ¿öquenu nencate? ");
INSERT INTO nhgNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Hua ca inu, inu tlöcatl tli quepeaya inu moxicoöne ijtecopa omomerö impa inu tlöca. Oquemasec innochtie ca meyac fuiersa. Oquencoco tönto hua tönto que hasta ochucholojque de ichö xipetzteque hua ca meyac heridas. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Noche joriojte pa Efeso hua noche tli amo joriojte oquematque de inu hua lalebes omomajtejque. Pos giente otiechamöjque Tlöcatzintle Jesús. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nuyejque meyactie de tli ye omoneltocaque ajaseto ompa. Omoyulcuitejque hua oquejtojque ixmantete lo que tli antes oquechijque tli amo cuale. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Meyactie tli antes oquechihuaya sösantle chichyutl oquenhualecaque inömahua. Oquenxutlaltejque imixtla noche giente. Oquechijque cuienta para abier quiejquech obaliere noche inu ömame. Obaliere quieme cincuenta mil piesas de plöta. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Así es que Deus ocusörojque tietlajtultzi ca meyac beletelestle ca giente. Cache meyac giente hua cache meyac giente oquecajque tietlajtultzi. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Sötiepa de que omochi noche inu, Pöblo omocuajpetzo para oquentlajpaluto noche locör pa tlöle de Macedonia hua pa tlöle de Acaya. Oquenec quesequirus hasta Jerusalén. Oquejto: ―Cuöc ye ompa neyes quiesque tunalte pa Jerusalén, entunses necpea neyös nuyejque ca Roma. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Timoteo hua Erasto seme quepaliebiöya Pöblo. Yaja oquentitla inu unteme ma yöcö hasta pan tlöle de Macedonia. Mientras que uyajque yejua, Pöblo omocö turavea pa tlöle de Asia quiesque tunalte. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pa nieca tiempo lalebes ochöchalönque giente porque amo oquecualejtaque quecaquesque tli Pöblo oquejto de tieojfe Deus. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sente tlöcatl itucö Demetrio oyeya platiero. Ca plöta quenchihuaya teopancucone tzequetzetzi de sente deus itucö Diana. Inu tlöca tli otequetque ca Demetrio oquentlönque cuale tomi. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrio oquensentlöle noche inu tequetque hua ocseque tli oquechijque tequetl quiename inu. Oquemelfe: ―Señores, nemejua nenquemate que tejua lalebes cuale teneme por ini nönca tequetl tli tecpea. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pero ye onenquejtaque inu Pöblo. Ye onenquecajque quiene ca yaja tlanunutzteneme. Quejtoa que inu ixniehualojme tli tlöca quechejchihua amo deuste cate. Por inu meyactie giente öxö quechihua cöso de yaja. Amo sa giente de Efeso tlöcamo nuyejque giente pa cöso noche tlöle de Asia. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Sie tiro amo cuale inu. Quepea riesco que ayecmo tecpeasque ini nönca tequetl. Hua amo sa inu, tlöcamo nuyejque giente ayecmo pa tlacheasque inu teopantle de Diana öque todeus bieyetzintle. Giente de noche tlöle de Asia hua tlöca ca nobeyo ahorita tieteochihua Diana. Pero quepea riesco que ayecmo tieteochihuasque. ");
INSERT INTO nhgNT_vpl VALUES ("AC19_28","