﻿USE sofia;
DROP TABLE IF EXISTS sofia.nheNT_vpl;
CREATE TABLE nheNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES nheNT_vpl WRITE;
INSERT INTO nheNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni amatl quipiya inintoca ihuejcapan tatahua Jesucristo. Yajaya se iteipa ixhui David huan se iteipa ixhui Abraham. ");
INSERT INTO nheNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tlen itztoya huejcajquiya quipixqui se icone tlen quitocaxti Isaac. Huan Isaac quipixqui se icone tlen quitocaxti Jacob. Huan Jacob quinpixqui majtlactli huan ome iconehua huan se tlen nopa majtlactli huan ome elqui itoca Judá. ");
INSERT INTO nheNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá huan nopa sihuatl Tamar quinpixque ome ininconehua huan quintocaxtijque Fares huan Zara. Huan Fares quipixqui se icone tlen quitocaxti Esrom. Esrom quipixqui se icone tlen quitocaxti Aram. ");
INSERT INTO nheNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram quipixqui se icone tlen quitocaxti Aminadab. Huan Aminadab quipixqui se icone tlen quitocaxti Naasón. Naasón quipixqui se icone tlen quitocaxti Salmón. ");
INSERT INTO nheNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Huan Salmón huan isihua Rahab quipixque se inincone tlen quitocaxtijque Booz. Booz huan isihua Rut quipixque se inincone tlen quitocaxtijque Obed. Obed quipixqui se icone tlen quitocaxti Isaí. ");
INSERT INTO nheNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Huan Isaí quipixqui se icone tlen quitocaxti David tlen moscalti huan elqui nopa hueyi tlanahuatijquetl. Huan nopa hueyi tlanahuatijquetl David quipixqui se icone tlen quitocaxti Salomón. Huan inana Salomón eliyaya tlen achtohui elqui isihua Urías. ");
INSERT INTO nheNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Huan Salomón quipixqui se icone tlen quitocaxti Roboam. Roboam quipixqui se icone tlen quitocaxti Abías. Huan Abías quipixqui se icone tlen quitocaxti Asa. ");
INSERT INTO nheNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa quipixqui se icone tlen quitocaxti Josafat. Huan Josafat quipixqui se icone tlen quitocaxti Joram. Joram quipixqui se icone tlen quitocaxti Uzías. ");
INSERT INTO nheNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Huan Uzías quipixqui se icone tlen quitocaxti Jotam. Jotam quipixqui se icone tlen quitocaxti Acaz. Acaz quipixqui se icone tlen quitocaxti Ezequías. ");
INSERT INTO nheNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Huan Ezequías quipixqui se icone tlen quitocaxti Manasés. Manasés quipixqui se icone tlen quitocaxti Amón. Amón quipixqui se icone tlen quitocaxti Josías. ");
INSERT INTO nheNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Huan Josías quipixqui se icone tlen quitocaxti Jeconías huan nojquiya quinpixqui más iconehua. Josías huan iconehua itztoyaj ipan nopa tonali quema hualajque tlali Babilonia ehuani huan quinhuicaque nechca nochi israelitame ilpitoque para ma quintequipanotij ipan inintlal. ");
INSERT INTO nheNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Huan teipa nepa ipan tlali Babilonia Jeconías quipixqui se icone tlen quitocaxti Salatiel. Huan Salatiel quipixqui se icone tlen quitocaxti Zorobabel. ");
INSERT INTO nheNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Huan Zorobabel quipixqui se icone tlen quitocaxti Abiud. Abiud quipixqui se icone tlen quitocaxti Eliaquim. Eliaquim quipixqui se icone tlen quitocaxti Azor. ");
INSERT INTO nheNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Huan Azor quipixqui se icone tlen quitocaxti Sadoc. Sadoc quipixqui se icone tlen quitocaxti Aquim. Aquim quipixqui se icone tlen quitocaxti Eliud. ");
INSERT INTO nheNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Huan Eliud quipixqui se icone tlen quitocaxti Eleazar. Eleazar quipixqui se icone tlen quitocaxti Matán. Matán quipixqui se icone tlen quitocaxti Jacob. ");
INSERT INTO nheNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Huan Jacob quipixqui se icone tlen quitocaxti José tlen moscalti huan mosihuajti ihuaya María. Huan María elqui inana Jesús. Huan Jesús elqui nopa Cristo tlen Toteco Dios quititlanqui ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Huajca majtlactli huan nahui huejhueyi tatame quinpixque ininconehua tlen quema Abraham itztoya ipan tlaltepactli hasta quema Tlanahuatijquetl David itztoya. Huan seyoc majtlactli huan nahui huejhueyi tatame quinpixque ininconehua tlen quema David itztoya ipan tlaltepactli hasta quinhuicaque nechca nochi israelitame ipan tlali Babilonia. Huan seyoc majtlactli huan nahui huejhueyi tatame quinpixque ininconehua tlen quema quinhuicaque israelitame ipan tlali Babilonia hasta quema tlacatqui Cristo tlen Toteco Dios quititlanqui ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Quej ni panoc quema tlacatqui Jesucristo. Inana Jesús quitocaxtiyayaj María huan ya quiijtlantoya José huan quisencajtoyaj ipan amatl para mocuilis queja momatque quichihuaj. Huan ipan nopa xihuitl quema polihuiyaya para mosejcotilise, José quimatqui para María ya tlanemiltiyaya, pero elqui ichicahualis Itonal Toteco tlen quichijqui ma conepiya. ");
INSERT INTO nheNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Huan José, tlen ya eltoya ihuehue María ipan amatl, eliyaya se tlacatl xitlahuac huan ax quinequiyaya quipinahualtis iniixtla tlacame. Huajca moilhui más cuali moamaxolehuas ihuaya María ixtacatzi para mocahuase. ");
INSERT INTO nheNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huan quema José moilhuiyaya tlen quichihuasquía, quiitac ipan se temictli se ielhuicac ejca Toteco quiilhui: “Xitlacaqui José, ta tiiteipa ixhui David tlen huejcajquiya itztoya. Amo ximajmahui para timocuilis María, mosihua, pampa nopa conetl tlen quinemiltía, pejqui ica ichicahualis Itonal Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Huan María quitlacatiltis se oquichpil huan tijtocaxtis: ‘Jesús’ tlen quiijtosnequi Temaquixtijquetl pampa quinmaquixtis itlacajhua tlen inintlajtlacolhua.” ");
INSERT INTO nheNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Huajca nochi ya ni panoc para ma tlami tlen Toteco Dios techilhui ica itiocamanalojca huejcajquiya para teipa panos. Yajaya techilhui: ");
INSERT INTO nheNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Xiquita se cuali ichpocatl tlen ax quema itztoya ihuaya se tlacatl elis conehue, huan quitlacatiltis se oquichpil huan quitocaxtis: Emanuel. Emanuel quiijtosnequi: ‘Toteco itztoc tohuaya.’ ” ");
INSERT INTO nheNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Huajca quema José isac, quichijqui senquistoc tlen ielhuicac ejca Toteco quiilhuijtoya. Quicuito María queja isihua, ");
INSERT INTO nheNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","pero José ax quinechcahui hasta tlacatqui icone. Huan María quitlacatilti iachtohui ejca cone, se piloquichpiltzi. Huan José quitocaxti Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Huan Jesús tlacatqui ipan altepetl Belén ipan estado Judea ipan nopa tonali quema Tlanahuatijquetl Herodes quipixqui tlanahuatili ipan nopa tlali. Huan ipan nopa tonali ajsicoj ipan altepetl Jerusalén sequin tlalnamijca tlacame tlen momachtijque sitlalime huan hualajque tlen campa quisa tonati. ");
INSERT INTO nheNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Huan quema ajsicoj, tlatzintocaque: ―¿Canque itztoc yajaya tlen tlacatqui para elis inintlanahuatijca israelitame? Hasta nepa campa quisa tonati, tiquitztoque isitlal tlen pejqui tlahuía quema tlacatqui. Huan tihualajtoque tijhueyimatise. ");
INSERT INTO nheNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Huan quema Tlanahuatijquetl Herodes quicajqui tlen nopa tlacame quiijtohuayayaj, momajmati. Huan nojquiya momajmatijque nochi tlacame tlen altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Huajca Herodes quinsentili nochi tlayacanca totajtzitzi, huan tlamachtiani tlen itlanahuatil Moisés, huan quintlajtlani canque tlacatisquía nopa Cristo tlen ijcuilijtoc para Toteco Dios quititlanisquía ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Huan yajuanti quinanquilijque: ―Cristo tlacatis ipan altepetl Belén nica ipan estado Judea pampa queja nopa quiijcuilo itiocamanalojca Toteco huejcajquiya campa quiijtohua: ");
INSERT INTO nheNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Yonque nopa pilaltepetzi Belén ax hueyi queja sequinoc altepetini ipan tlali Judá, nopano tlacatis se hueyi tlanahuatijquetl. Yajaya quinyacanas noisraelita tlacajhua.’ Quej nopa quiijcuilo nopa tiocamanalojquetl. ");
INSERT INTO nheNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Huajca Herodes ixtacatzi quinnotzqui nopa tlacame tlen momachtijque sitlalime. Huan quintlajtlani miyac ipan tlachque tonal pejqui nesi nopa yancuic sitlali. ");
INSERT INTO nheNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Teipa Herodes quintitlanqui ma yaca ipan pilaltepetzi Belén huan quinilhui: ―Xiyaca Belén, xijtemotij nopa piloquichpiltzi. Huan quema inquipantise, xinechilhuiquij canque itztoc para na nojquiya niyas nijhueyichihuati. ");
INSERT INTO nheNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Teipa quema nopa tlacame quicactoya itlajtol Tlanahuatijquetl Herodes, quistejque Jerusalén. Huan nimantzi sampa quiitaque nopa sitlali tlen achtohuiya quiitztoyaj nepa campa quisa tonati, huan nopa sitlali quinyacantiyajqui hasta moquetzato itzonpac nopa cali campa itztoya nopa piloquichpiltzi. ");
INSERT INTO nheNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Huan quiitaque para moquetzqui nopa sitlali huan nelía pajque. ");
INSERT INTO nheNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Huajca calaquitoj ipan nopa cali huan quiitaque nopa piloquichpiltzi ihuaya inana tlen itoca María. Huan motlancuaquetzque huan moixtlapachojque iixtla huan quihueyitlalijque nopa conetl. Huan quitlapojque tlen nelpajpatiyo quihuiquiliyayaj. Huan quimacaque oro, cuali copali huan se tlaajhuiyacayotl tlen itoca mirra tlen tlahuel patiyo. ");
INSERT INTO nheNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Huan Toteco Dios quinyolmelajqui nopa tlacame ipan temictli para ma amo mocuepaca para quiilhuitij Tlanahuatijquetl Herodes canque itztoc nopa piloquichpiltzi. Huajca yajuanti yajque ipan seyoc ojtli huan mocuepque inintlal. ");
INSERT INTO nheNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Quema ya quistoyaj nopa tlacame tlen momachtijque sitlalime, se ielhuicac ejca Toteco monexti iixtla José ipan temictli huan quiilhui: “Ximehua huan xijhuica nopa piloquichpiltzi ihuaya inana huan xicholoca huejca hasta tlali Egipto. Ximocahuaca nepa hasta nimitzilhuis pampa nopa Tlanahuatijquetl Herodes quitemohua nopa piloquichpiltzi para quimictis.” ");
INSERT INTO nheNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Huajca José mejqui huan ipan nopa tlayohua quihuicac nopa piloquichpiltzi ihuaya inana huan cholojtejque tlajco yohual para yase Egipto. ");
INSERT INTO nheNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Huan yajuanti mocajque nepa hasta mijqui Tlanahuatijquetl Herodes. Toteco quinilhuijtoya ma yaca tlali Egipto para ma tlamis tlen itiocamanalojca Toteco quiijto huejcajquiya campa quiijto: “Na nijnotzas Nocone ma quisas tlali Egipto.” ");
INSERT INTO nheNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Teipa Tlanahuatijquetl Herodes momacac cuenta para nopa tlacame tlen momachtijque sitlalime san quicajcayajtoyaj pampa ax mocuepque para quiyolmelahuase campa itztoya nopa conetl. Huajca nelía cualanqui. Huan quintitlanqui soldados ma yaca altepetl Belén huan pilaltepetzitzi nejnechca para ma quinmictica nochi piloquichpiltzitzi tlen aya quipiyayayaj ome xihuitl. Ya ni quichijqui pampa quinequiyaya quimictis Jesús, pampa nopa tlacame quiilhuijtoyaj aya quipiyayaya ome xihuitl para nestoya nopa yancuic sitlali. ");
INSERT INTO nheNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Huajca nochi ipan Belén mocuesojque. Quej nopa panoc senquistoc queja quiijcuilo nopa tiocamanalojquetl Jeremías huejcajquiya, huan quej ni quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Nepa ipan altepetl Ramá o Belén nochi quicaquise tlen chocase huan tlahuejchihuase. Israelita tename chocase pampa quinmictilise ininconehua. Huan axaca huelis quinyoltlalis pampa ya mictose.” ");
INSERT INTO nheNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Teipa mijqui Tlanahuatijquetl Herodes ipan tlali Israel. Huan ipan tlali Egipto campa José itztoya, quiitac ipan temictli se ielhuicac ejca Toteco tlen quiilhui: ");
INSERT INTO nheNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ximehua, huan xijhuica nopa piloquichpiltzi ihuaya inana huan ximocuepaca tlali Israel pampa ya mijque yajuanti tlen quinequiyayaj quimictise.” ");
INSERT INTO nheNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Huajca José mejqui, huan quihuicac Jesús ihuaya inana huan sampa mocuepque tlali Israel. ");
INSERT INTO nheNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero José quicajqui para ipan estado Judea tlanahuatiyaya Herodes Arquelao, icone Herodes, huajca majmajqui ajsiti nepa. Huan Toteco Dios quiilhui ipan temictli para ma yaca estado Galilea, huajca yajque nepa. ");
INSERT INTO nheNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Huan ajsitoj ipan se altepetl tlen itoca Nazaret ipan estado Galilea huan nepa mocajque. Quej ni tlanqui tlen nopa tiocamanalohuani huejcajquiya quiijtojque tlen Cristo: “Tlacame quinotzase se Nazaret ejquetl.” ");
INSERT INTO nheNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ipan nopa tonali Juan tlen tecuaaltiyaya ajsico ipan nopa huactoc tlali campa ax tleno eli nepa ipan estado Judea. Huan pejqui tecamahuía, ");
INSERT INTO nheNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","huan quinilhuiyaya tlacame: “Ximoyolpatlaca huan xijcahuaca tlen ax cuali inquichihuaj para huelis incalaquise campa tlanahuatía Toteco tlen itztoc ipan elhuicac, pampa yajaya inmechnechcahuía ama huan inmechnotza xicalaquica.” ");
INSERT INTO nheNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan eliyaya nopa tlacatl tlen tiocamanalojquetl Isaías huejcajquiya quiijcuilo hualasquía. Isaías quiijcuilo ya ni: “Tlacame quicaquise se tlen camatis chicahuac ipan nopa huactoc tlali campa ax tleno eli. Huan quiijtos: ‘Xijcualtlalica imoyolo pampa hualas Tohueyiteco. Xijxitlahuaca imonemilis queja inquisencahuaj ojtli para hualas se hueyi tequihuejquetl.’ ” ");
INSERT INTO nheNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan moquentiyaya iyoyo tlen tlachijchihuali ica itzoncal camello huan quipiyayaya itzinquechilpica tlen cuetlaxtli. Huan quincuayaya pilchapoltzitzi huan nectli tlen quipantiyaya campa nentinemiyaya campa ax onca caltini. ");
INSERT INTO nheNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Huan yohuiyayaj campa Juan miyac tlacame tlen quisayayaj altepetl Jerusalén huan sequinoc altepetini ipan estado Judea huan miyac tlen ehuayayaj nechca atemitl Jordán. ");
INSERT INTO nheNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Huan nochi quipohuiliyayaj Toteco Dios inintlajtlacolhua, huan huajca Juan quincuaaltiyaya ipan atemitl Jordán. ");
INSERT INTO nheNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Huan quema Juan quinitac para nojquiya ajsiyayaj miyac fariseos huan saduceos tlen quinequiyayaj mocuaaltise, quinilhui: “Initztoque queja incohuame. ¿Ajqueya inmechilhuijtoc para Toteco Dios ax inmechtlatzacuiltis teipa intla inmocuaaltise? Ax queja nopa. ");
INSERT INTO nheNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nimechilhuía monequi inquichihuase tlen cuali para nempa ma nesi para inmoyolcueptoque huan inquicajtejtoque imoojhui tlen fiero. ");
INSERT INTO nheNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Amo ximoilhuica para incuajcualme pampa initztoque initeipa ixhuihua Abraham tlen huejcajquiya itztoya. Nimechilhuía Toteco huelis quichihuas ni tetini tlen eltoc nica para ma mocuepaca iteipa ixhuihua Abraham intla yajaya quinequis. ");
INSERT INTO nheNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Imojuanti initztoque queja cuatini tlen ax tlaquij, huajca ximomocuitlahuica pampa Toteco ya quicualtlalijtoc ihacha para inmechtzontequis huan inmechtlatis queja ineltosquíaj cuatini. ");
INSERT INTO nheNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Quena, nelía niquincuaaltía ica atl nochi tlen ya moyolcueptoque huan quicajtejtoque tlajtlacoli. Pero teipa seyoc hualas tlen más quipiya tlanahuatili que na. Na ax nicaxilía para nielis itlatequipanojca, niyon para nijquixtilis itecac. Yajaya quinmacas sequin tlacame Itonal Toteco huan sequinoc quintlatzacuiltis ica tlitl. ");
INSERT INTO nheNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Yajaya huala mocualtlalijtoc para quiniyocatlalis tlacame queja se quichihua quema quitequihuía itlaajcapehuilol para quiyejyectis trigo. Huan tlacame tlen itztoque queja nopa trigo tlen cuali, quinajcocuis. Huan tlen itztoque queja itlasolo nopa trigo, quintlatis ica se tlitl tlen ax quema sehuis.” ");
INSERT INTO nheNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Teipa Jesús quisqui ipan estado Galilea huan ajsico atemitl Jordán campa itztoya Juan para ma quicuaalti. ");
INSERT INTO nheNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero Juan ax quinequiyaya quicuaaltis Jesús huan quiilhui: ―Más quinamiqui ta tinechcuaaltisquía, huajca ¿para tlen tijnequi ma nimitzcuaalti? ");
INSERT INTO nheNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Huan Jesús quiilhui: ―Para amantzi, xinechcuaalti na pampa monequi tijchihuase nochi tlen xitlahuac senquistoc queja Toteco Dios quinequi. Huajca Juan quicaquili itlajtol huan quicuaalti. ");
INSERT INTO nheNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Huan quema Jesús ya mocuaaltijtoya huan quisayaya ipan atl, nimantzi tlapojqui elhuicactli huan quiitac Itonal Toteco hualtemoyaya queja se paloma huan ajsic ipan ya. ");
INSERT INTO nheNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Huan Toteco Dios camatqui tlen elhuicac huan quiijto: “Ya ni Nocone tlen niquicnelía. Nipaqui miyac ica tlen quichihua.” ");
INSERT INTO nheNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Teipa Itonal Toteco quihuicac Jesús hasta nopa huactoc tlali campa ax tleno eli para Axcualtlacatl ma quiyoltilana Jesús para ma tlajtlacolchihua. ");
INSERT INTO nheNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Huan Jesús mosajqui cuarenta tonali, huan teipa nelía mayanayaya. ");
INSERT INTO nheNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Huan ajsico Axcualtlacatl huan quiilhui Jesús: ―Intla nelía tiIcone Dios, huajca xijnahuati ni tetl ma mocuepa pantzi. ");
INSERT INTO nheNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Huan Jesús quinanquili: ―Ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Ax san pantzi monequi para itztose tlacame. Nojquiya monequi tijneltoquilijtiyase nochi Itlajtol Toteco.’ ");
INSERT INTO nheNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Huajca Axcualtlacatl quihuicac Jesús hasta altepetl Jerusalén, ialtepe Toteco Dios, huan quiquetzqui itzonatipa nopa hueyi tiopamitl, ");
INSERT INTO nheNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","huan quiilhui: ―Intla nelía tiIcone Dios, huajca xihuitoni hasta tlatzintla pampa ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Toteco Dios quintitlanis ielhuicac ejcahua para ma mitzmocuitlahuica, huan yajuanti mitzmatzacuilise para ax timoicxicocos ica niyon se tetl.’ ");
INSERT INTO nheNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Huan Jesús quiilhui: ―Nojquiya ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Amo xijyejyeco Toteco Dios san para tiquitas tlachque quichihuas.’ ");
INSERT INTO nheNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Teipa Axcualtlacatl quihuicac Jesús ipan se huejcapantic tepetl huan quinextili nochi tlacame tlen iniaxca nochi tlanahuatiani ipan nochi tlaltini ipan tlaltepactli huan nochi ininricojyo. ");
INSERT INTO nheNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Huan quiilhui: ―Nochi ya ni nimitzmacas intla timotlancuaquetzas huan tinechhueyichihuas. ");
INSERT INTO nheNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Huajca Jesús quiilhui Axcualtlacatl: ―Xinechtlalcahui Axcualtlacatl. Pampa ijcuilijtoc ipan Itlajtol Toteco: ‘San Toteco Dios xijhueyichihua huan san ya xijtlepanita.’ ");
INSERT INTO nheNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Huajca quisqui Axcualtlacatl huan quicajtejqui Jesús. Huan elhuicac ehuani hualajque huan quipalehuicoj. ");
INSERT INTO nheNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Teipa quema Jesús quicajqui para Juan itztoya ipan tlatzactli, quisqui tlen estado Judea huan mocuepqui altepetl Nazaret ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Huan teipa quisqui altepetl Nazaret huan yajqui para itztoti ipan altepetl Capernaum tlen mocahua nechca nopa hueyi atl campa monamiqui estado Zabulón ihuaya estado Neftalí. ");
INSERT INTO nheNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Quichijqui ya ni para ma tlami tlen Toteco quiilhuijtoya itiocamanalojca Isaías huejcajquiya huan ya ni tlen quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Nopa tlaltini Zabulón huan Neftalí mopantíaj iteno hueyi atl ipan nopa seyoc nali atemitl Jordán ipan estado Galilea. Nepa mocahuaj tlacame tlen ax israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pero nochi nopa tlacame tlen itztoyaj ipan tzintlayohuilotl, ama quiitztoque se hueyi tlahuili. Itztoyaj queja mictoque, pero ama cahuantoc se hueyi tlahuili para quintlahuilis inintlalnamiquilis.” ");
INSERT INTO nheNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Huajca ipan nopa tonali Jesús pejqui tlacamanalohua huan quinilhui tlacame: “Ximoyolpatlaca huan xijcahuaca tlen ax cuali inquichihuaj intla inquinequij incalaquise campa tlanahuatía Toteco tlen itztoc elhuicac, pampa yajaya inmechnechcahuía ama.” ");
INSERT INTO nheNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Huan Jesús nejnemiyaya iteno nopa hueyi atl tlen itoca Galilea huan quinitac ome icnime. Se itoca eliyaya Simón, pero nochi quitocaxtiyayaj Pedro. Huan ne se iicni itoca eliyaya Andrés. Yajuanti quimajcahuayayaj matlatl atitla pampa eliyayaj michtlajtlamani. ");
INSERT INTO nheNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Huan Jesús quinilhui: ―Xinechtoquilica. Ama inmichtlajtlamani, pero seyoc tequitl nimechmacas. Nimechnextilis quejatza intlajtlamase tlen tlacame para ma nechtoquilica. ");
INSERT INTO nheNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Huan yajuanti nimantzi quicajtejque ininmatla huan quitoquilijque. ");
INSERT INTO nheNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Teipa Jesús nejnenqui achi más huan quinitac seyoc ome icnime, se tlen itoca eliyaya Jacobo huan ne se itoca eliyaya Juan. Itztoyaj ipan se cuacanahua ihuaya inintata, Zebedeo, quitlatlamaniyayaj ininmatla. Huan Jesús nojquiya quinnotzqui ma yaca ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Huan nimantzi quicajtejque nopa cuacanahua huan inintata huan quitoquilijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Huan Jesús panotinemiyaya campa hueli ipan nochi estado Galilea huan tlamachtijtinemiyaya ipan nopa israelita tiopantini ipan sesen altepetl. Huan tlacamanalojtinemiyaya nopa cuali tlajtoli tlen quejatza eltos quema Toteco tlanahuatis. Huan Jesús quinchicahuayaya tlen mococohuayayaj ica tlen hueli cocolistli. ");
INSERT INTO nheNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Huajca campa hueli ipan nochi tlali Siria nochi tlacame quicajque tlen Jesús, huan quinhualicaque campa ya nochi tlen quipixtoyaj tlacuajcualocayotl huan miyac tlamantli cocolistli. Nojquiya quinhualicaque tlen tlaijiyohuiyayaj pampa quinpixque iajacahua Axcualtlacatl, huan tlen huetziyayaj ica ajaca cocolistli huan tlen huajhuapahuiyayaj. Huan nochi Jesús quinchicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huan quitoquiliyayaj tlahuel miyac tlacame tlen hualajque tlen estado Galilea, huan tlen tlali Decápolis, huan tlen altepetl Jerusalén, huan tlen estado Judea huan sequin tlen hualajque seyoc nali atemitl Jordán. ");
INSERT INTO nheNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Huan Jesús quiitac ya ajsicoj miyac tlacame huan huajca tlejcoc quentzi ipan se tepetl huan mosehui. Huan tojuanti tiimomachtijcahua timonechcahuijque campa itztoya ininhuaya nopa tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Huan Jesús pejqui tlamachtía huan quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Xipaquica imojuanti tlen inmoicnonequij iixtla Toteco, huan inquimatij inteicneltzitzi ipampa imotlajtlacolhua. Toteco tlen itztoc ipan elhuicac inmechcahuilis xicalaquica campa yajaya tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Xipaquica imojuanti tlen inmocuesohuaj, pampa Toteco inmechyoltlalis. ");
INSERT INTO nheNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Xipaquica imojuanti tlen ax inmohueyimatij iniixtla sequinoc. Toteco inmechaxcatis nochi tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Xipaquica imojuanti tlen ica nochi imoyolo inquitemohuaj quejatza inquichihuase tlen xitlahuac. Initztoque queja tlacame tlen mayanaj huan amiquij para itztose cuali, huan Toteco inmechixhuitis para melahuac inhuelise inquichihuase tlen xitlahuac. ");
INSERT INTO nheNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Xipaquica imojuanti tlen intetlasojtlaj huan intepalehuíaj, pampa Toteco nojquiya inmechtlasojtlas huan inmechpalehuis. ");
INSERT INTO nheNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Xipaquica imojuanti tlen inyoltlapajpactique, pampa inquiitase Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Xipaquica imojuanti tlen inquiyoltlalíaj cualantli, pampa Toteco inmechtocaxtis iniconehua. ");
INSERT INTO nheNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Xipaquica intla sequinoc inmechtlaijiyohuiltíaj pampa inquichihuaj tlen xitlahuac, pampa Toteco tlen itztoc elhuicac inmechcahuilis incalaquise ipan itlanahuatilis. ");
INSERT INTO nheNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Xipaquica quema sequinoc inmechpinajtíaj huan inmechtlaijiyohuiltíaj huan inmechistlacahuíaj pampa innechneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Quena, xipaquica huan amo ximocuesoca pampa Toteco hueyi inmechtlaxtlahuis nepa elhuicac. Quej nopa tlacame nojquiya quintlatzacuiltijque itiocamanalojcahua Toteco huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Istatl quipalehuía nacatl para ma ax nenpolihui. Imojuanti nojquiya inhuelij inquinpalehuise tlacame para ma ax tlajtlacolchihuaca pampa initztoque queja istatl ipan ni tlaltepactli. Pero intla istatl ayoc poyec, huajca ax tleno ipati. Huan axaca huelis quipoyeltisoc sampa. Niyon ayoc huelis tijtequihuise. San monequi tijtepehuase huan huajca ipan moquejquetzase tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Imojuanti initztoque itlahuil ni tlaltepactli pampa inquintlahuilíaj tlacame. Initztoque queja se altepetl tlen mosehuía ipan se tepetl huan tlahuía para nochi hueli quiitase. ");
INSERT INTO nheNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Axaca quitlatía se tlahuili huan quitlalía cajon tzala, pero quitlalía ipan se tlahuil quetzali para ma tlahuis nochi ipan calijtic. ");
INSERT INTO nheNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Quej nopa xijcahuaca ma cahuani imotlahuil iniixtla tlacame huan quiitase tlen cuali inquichihuaj huan quihueyichihuase imoTata tlen itztoc ipan elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Amo ximoilhuica nihualajtoc para niquiniyocacahuas itlanahuatil Moisés huan tlen quiijcuilojtoque itiocamanalojcahua Toteco. ¡Axtle! Nihualajtoc para nijtlamichihuas nochi tlen quiijtohuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Melahuac nimechilhuía hasta tlamis elhuicactli huan tlaltepactli axaca quixolehuas yon se letra, yon se punto tlen ijcuilijtoc ipan nopa tlanahuatili. Nochi panos queja quiijtohua nepa. ");
INSERT INTO nheNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Intla se tlacatl ax quitlepanita se tlen itlanahuatilhua Moisés huan quinmachtis sequinoc ma ax quitlepanitaca, yonque nopa tlanahuatili ax hueyi, nopa tlacatl elis pilsiltzi quema Toteco tlen itztoc elhuicac tlanahuatis. Quema tlanahuatis Toteco, elise huejhueyi nopa tlacame tlen quineltocaj itlanahuatilhua huan quinnextilíaj sequinoc ma quitlepanitaca nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pampa nimechilhuía, intla inquinequij incalaquise campa tlanahuatía Toteco tlen itztoc ipan elhuicac, monequi más xijchihuaca tlen xitlahuac que quichihuaj nopa fariseos huan nopa tlamachtiani tlen itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Inquicactoque para itlanahuatil Moisés quinmachtiyaya tlacame huejcajquiya para ma ax temictica. Huan ajqueya quimictis se tlacatl yas iniixtla tequitini para quitlajtolsencahuase huan quitlatzacuiltise. ");
INSERT INTO nheNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero na nimechilhuía, intla se tlacatl cualanis ica iicni, tequitini quitlajtolsencahuase. Huan intla se tlacatl quitelchihuas iicni, nopa tlasentilistli tlen tequitini tlen más quipiyaj tlanahuatili mosentilis para quitlajtolsencahuas huan quitlatzacuiltis. Huan ajqueya quitocaxtis seyoc ica tlajtoli tlen fiero, quihuicas tlajtlacoli para yas ipan tlitl nepa mictla. ");
INSERT INTO nheNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Huajca intla timoquetza campa itlaixpa para tijmacas Toteco se tlacajcahualistli huan ipan nopa tlalochtli tiquilnamiquis para moicni cualani mohuaya, huajca amo xijmaca nopa tlacajcahualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Xijcahua motlacajcahualis ipan tlaixpamitl huan xiya achtohui para ta huan moicni ma ximotlapojpolhuica huan ximoyoltlalica ica tlen panoc. Huan huajca, quena, ximocuepa para tijmacas Toteco nopa tlacajcahualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Huan intla se mocualancaitaca quinequi mitzteilhuis ica tlen ax cuali tijchihuilijtoc, huajca ximosencahua ihuaya nimantzi quema noja itztoc ipan ojtli para mitzteilhuis. Ma ax mitzhuicas iixtla tequihuejquetl, pampa nopa tequihuejquetl mitztemactilis ica policías huan yajuanti mitztzacuase. ");
INSERT INTO nheNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Melahuac nimitzilhuía, ax tiquisas ipan tlatzactli hasta titlaxtlahuas senquistoc nochi tlen nopa tequihuejquetl quiijtos xitlaxtlahua. ");
INSERT INTO nheNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Inquicactoque para itlanahuatil Moisés quiijtohua para amo ximomecatica. ");
INSERT INTO nheNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero na nimechilhuía, intla se tlacatl quiita se sihuatl huan ipan itlalnamiquilis quinequi tlen hueli quichihuas ihuaya, ya momecatijqui ihuaya ipan iyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Huajca intla se moixtiyol quinequi quitlachilis tlajtlacoli, xijquixti huan xijmajcahua, yonque eliyaya moixtiyol tlen más cuali. Pampa más cuali para tijpolos se pilquentzi motlacayo, huan ax tiyas nepa mictla ica nochi motlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Huan intla moma tlen monejmatl mitzchihuilía xitlajtlacolchihua, huajca más cuali xijtzontequi huan xijmajcahua, pampa más cuali para tijpolos san se pilquentzi motlacayo huan ax tiyas nepa mictla ica nochi motlacayo yamajtic. ");
INSERT INTO nheNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Nojquiya itlanahuatil Moisés quiijtohua para ajqueya quinequi quicahuas isihua, monequi ma quimaca se amatl tlen quiijtohua para ayoc iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero na nimechilhuía, intla se tlacatl quicahuas isihua tlen ax momecatijtoc ica seyoc, yajaya quichihuilía nopa sihuatl ma momecatis quema monamictis. Huan nojquiya yajaya tlen teipa mosihuajtis ihuaya nopa sihuatl, momecatis. ");
INSERT INTO nheNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Inquicactoque para itlanahuatil Moisés quiijtohua intla se quitestigojquetzas Toteco quema quitlajtolcahua se tlamantli, huajca monequi quichihuas tlen quiijtojtoc. ");
INSERT INTO nheNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero na nimechilhuía, amo xitlatestigojquetzaca. Amo xijtestigojquetzaca elhuicactli pampa elhuicactli eltoc campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Amo xijtestigojquetzaca tlaltepactli pampa iicxitla Toteco tlen nojquiya yajaya quinahuatía. Amo xijtestigojquetzaca altepetl Jerusalén, pampa Jerusalén ialtepe Toteco nopa Hueyi Tlanahuatijquetl. ");
INSERT INTO nheNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Niyon amo xijtestigojquetzaca imotzonteco pampa ax inquinahuatíaj imotzonteco. Ax hueli inquichipahuilíaj niyon se imotzoncal, huan intla ya chipahuac, ax hueli inquiyayahuilíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Quema incamatij, xiquijtoca xitlahuac intla hueli inquichihuaj se tlamantli. Xiquijtoca xitlahuac ‘quena, nijchihuas’ o ‘ax nijchihuas’, pero intla intlatestigojquetzaj, ax cuali inquichihuaj, huan quej ni Axcualtlacatl quinequi xijchihuaca. ");
INSERT INTO nheNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Inquicactoque para itlanahuatil Moisés quiijtohua intla se acajya mitzixtiyolcocos, huajca xiquixtiyolcoco. Huan intla se acajya mitztlancochtepehuas, huajca xijtlancochtepehua nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero na nimechilhuía, amo ximomacuepaca ica tlen inmechchihuilía tlen ax cuali. Intla se mitzixtlatzinis ipan mocampa tlen monejmatl, huajca xijnextili seyoc mocampa para nepa nojquiya ma mitzixtlatzini. ");
INSERT INTO nheNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Intla tijtlahuiquilía tomi se acajya huan yajaya mitzhuicas iixtla tequihuejquetl huan monequi tijmacas mocamisa para tlen titlahuica, xijmaca nojquiya mochamarra. ");
INSERT INTO nheNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Intla se soldado mitznahuatis xijhuica itlamamal para se kilómetro, xijhuiquili ome kilómetros ipan iojhui. ");
INSERT INTO nheNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Intla se mitztlajtlanis se tlamantli, xijmaca. Intla se quinequi xijtlanejti se tlamantli, xijtlanejti. ");
INSERT INTO nheNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Inquicactoque itlanahuatil Moisés huejcajquiya quiijto xiquinicnelica imohuampoyohua huan xiquincocolica imocualancaitacahua. ");
INSERT INTO nheNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero na nimechilhuía, xiquinicnelica imocualancaitacahua huan xijtlajtlanica Toteco ma quintiochihua tlen inmechtlaijiyohuiltíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Huan queja nopa, nochi quimatise para melahuac initztoque iconehua Toteco imoTata tlen itztoc elhuicac. Pampa yajaya quichihua tonati ma tlahui ipan tlen ax cuajcualme huan ipan tlen cuajcualme. Huan yajaya quichihua ma huetzi atl ipan ininmil tlen itztoque xitlahuaque iixtla huan ipan ininmil tlen ax itztoque xitlahuaque iixtla. ");
INSERT INTO nheNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pampa intla san inquinicnelíaj tlacame tlen inmechicnelíaj, ax tleno tlen cuali inquichijtoque para Toteco inmechtlaxtlahuis teipa. Hasta nopa tlacame tlen tlainamaj impuesto huan tlahuel tlacajcayahuaj nojquiya ya nopa quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Huan intla san inquintlajpalohuaj imohuampoyohua, ax tleno tlen cuali inquichijtoque. Tlacame tlen ax quiixmatij Toteco nojquiya ya nopa quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pero monequi xiitztoca senquistoc cuali ipan nochi tlen inquichihuaj queja imoTata tlen itztoc ipan elhuicac itztoc senquistoc cuali. ");
INSERT INTO nheNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ximotlachilica para ax inquichihuase tlamantli tlen cuali san para tlacame ma inmechitaca. Intla inquichihuaj tlen cuali para inmohueyimatise iniixtla sequinoc, huajca Toteco imoTata tlen itztoc nepa elhuicac ax inmechtlaxtlahuis. ");
INSERT INTO nheNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Huajca quema inquinpalehuíaj tlen teicneltzitzi, amo xijnequica para sequinoc ma quimatica. Amo xitlapitzaca queja tlacame tlen quinextía ome ininxayac quichihuaj ipan tiopamitl huan callejtipa. Yajuanti quinequij sequinoc ma quinitaca ica tlen cuali quichihuaj para ma quinhueyimatica. Intla tlacame quinhueyimatise, san ya nopa quiselise pampa Toteco ax quintlaxtlahuis más. ");
INSERT INTO nheNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Quema inquinmacaj se tlenijqui tlen teicneltzitzi, ma ax quimati niyon se tlacatl quesqui inquinmacaque. Niyon moarraves ma ax quimati tlachque temaca moma nejmatl. ");
INSERT INTO nheNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Huajca quema inquimacaj se tlamantli se tlen teicneltzi, xijmacaca ixtacatzi, huan Toteco imoTata tlen quiita nochi tlen ixtacatzi, yajaya inmechtlaxtlahuis tlamiyacapa. ");
INSERT INTO nheNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Huan quema inmomaijtohuaj ica Toteco, amo xijchihuaca queja tlacame tlen ome ininxayac quichihuaj. Yajuanti quinpactía moquetzase tiopan calijtic o callejtipa huan nepa momaijtohuaj ica Toteco san para sequinoc ma quinitaca. Intla tlacame quinhueyimatise, san ya nopa quiselise pampa Toteco ax quintlaxtlahuis. ");
INSERT INTO nheNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero imojuanti quema inmomaijtohuaj ica Toteco Dios, xiyaca campa más calijtic huan xijtzacuaca cuapuerta huan Toteco imoTata tlen itztoc nepa calijtic imohuaya quiitas huan inmechtlaxtlahuis tlamiyacapa. ");
INSERT INTO nheNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Huan quema inmomaijtohuaj ica Toteco Dios, amo xijchihuaca queja tlacame tlen ax quiixmatij Toteco. Yajuanti san quiompahuíaj miyac huelta se tlajtoli tlen quitzontecomajtoque pampa moilhuíaj intla huejcahuase camatise, Toteco quincaquis. ");
INSERT INTO nheNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Huajca amo xijchihuaca queja yajuanti, pampa imoTata ya quimati tlachque inmechpolohua hasta quema aya inquitlajtlaníaj. ");
INSERT INTO nheNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Huajca quema inmomaijtose ipan Toteco, xiquilhuica quej ni: ‘Toteco Totata tlen tiitztoc nepa elhuicac. Nochi tlacame ma quihueyichihuaca motoca . ");
INSERT INTO nheNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Xihuala, xitlanahuatiqui nica. Ma quichihuaca mopaquilis nochi ipan ni tlaltepactli queja mochijtoc nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Xitechmaca nopa tlacualistli tlen monequi mojmostla. ");
INSERT INTO nheNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Xitechtlapojpolhui totlajtlacolhua, queja tojuanti nojquiya tiquintlapojpolhuíaj tlen techixpanoj. ");
INSERT INTO nheNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Axaca xijcahuili ma techyoltilana ma titlajtlacolchihuase. Xitechmanahui tlen yajaya tlen ax cuali. Pampa ta moselti tijpiya tlanahuatili para nochi tijnahuatis. San ta tijpiya nopa chicahualistli tlen más hueyi. Huan san ta tijpiya motlatlanex huan queja nopa elis para nochipa. San ya nopa.’ ");
INSERT INTO nheNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pampa intla inquintlapojpolhuise tlacame tlen inmechixpanotoque, huajca imoTata tlen itztoc nepa elhuicac inmechtlapojpolhuis imotlaixpanolhua nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero intla ax inquintlapojpolhuíaj tlacame tlen inmechixpanoj, huajca imoTata ax inmechtlapojpolhuis imotlaixpanolhua. ");
INSERT INTO nheNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Quema inmosahuaj, amo xijcahuilica ma nesi intla inmosahuaj queja tlacame tlen ome ininxayac quichihuaj. Yajuanti quinequij ma nesi fiero ininxayac queja tlaijiyohuíaj miyac para tlacame ma momacaca cuenta para mosahuaj. Intla tlacame quinhueyimatij, san ya nopa quiselise pampa Toteco ax quintlaxtlahuis. ");
INSERT INTO nheNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Huajca imojuanti quema inmosahuase, ximoxilhuica cuali huan ximixamica. ");
INSERT INTO nheNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Quej nopa tlacame ax momacase cuenta intla inmosahuaj, pero Toteco imoTata tlen quimati nochi tlen eltoc ixtacatzi tlen sesen imojuanti, yajaya quimatis inmosahuaj huan yajaya inmechtlaxtlahuis. ");
INSERT INTO nheNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Amo xicajcocuica miyac tomi o miyac tlamantli tlen ipati nica ipan ni tlaltepactli pampa huelis cualos, o pojyahuis o moxixas. O huelis calaquise tlaxtequini huan quiixtequise. ");
INSERT INTO nheNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más cuali xicajcocuica tlen nelía ipati nepa elhuicac para inmechchiyas tlen cuajcualtzi nepa. Nepa ax cualos, ax pojyahuis, ax moxixas, niyon ax aquise tlaxtequini para tlaxtequise. ");
INSERT INTO nheNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pampa intla inquimatise tlen nelía ipati inmechchiya nepa elhuicac, huajca ipan imoyolo inquinequise initztose nepa. ");
INSERT INTO nheNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Toixtiyol eltoc queja se tlahuili ipan totlacayo huan intla cuali toixtiyol, nochi totlacayo quipiya tlahuili huan tijmatij tlen cuali para tijchihuase. ");
INSERT INTO nheNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero intla ax cuali toixtiyol, nochi totlacayo eltos ipan tzintlayohuilotl. Pero intla timoilhuíaj tijpiyaj tlahuili ipan toyolo, pero nelía tlen tiquitaj para tlahuili, eltoc tzintlayohuilotl; nelía melahuac achi más tiitztoque ipan tzintlayohuilotl pampa niyon quentzi ax tijmatij tlen cuali. ");
INSERT INTO nheNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Axaca huelis quintequipanos ome itecojhua, pampa quicocolis se huan quiicnelis ne se. Huan ica se elis temachtli, pero ne seyoc quitlahuelcahuas. Ihuical eli, ax hueli inquitequipanose Toteco intla inquicahuilíaj ma inmechyoltilana tomi. ");
INSERT INTO nheNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Yeca nimechilhuía, amo ximocuesoca tlen imonemilis huan intla oncas tlen ica inpanose huan tlen inquicuase huan tlen inquiise. Amo ximoilhuica tlen imotlacayo huan intla oncas ica tlen inmoyoyontise. Toteco inmechmacatoc yolistli huan ya nopa tlen achi más ipati; huan yajaya nojquiya inmechmacas tlacualistli. Yajaya inmechmacatoc imotlacayo huan ya nopa tlen achi más ipati; huan yajaya nojquiya inmechmacas tlen ica inmoyoyontise. ");
INSERT INTO nheNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xiquintlachilica totome tlen patlantinemij. Yajuanti ax momiltíaj, huan ax pixcaj, niyon ax quiajcocuij inintlacualis. Pero imoTata tlen itztoc nepa elhuicac quintlamaca. Huan Toteco nojquiya inmechtlamacas pampa más inmopati iixtla que totome. ");
INSERT INTO nheNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","San tlapic para inmocuesose. Intla inmocuesose pampa ax inhuejcapantique, ¿huelis inmoscaltise seyoc ome mistitl pampa inmocuesojtoque? Ax inhuelij. ");
INSERT INTO nheNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Huan ¿para tlen inmocuesohuaj ica tlen inmoyoyontise? Xijtlachilica xochitl tlen moscaltíaj campa hueli. Ax tequitij, niyon ax tlajtzomaj. ");
INSERT INTO nheNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero nimechilhuía, nopa hueyi Tlanahuatijquetl Salomón ica nochi ihueyitilis ax quema quipixqui iyejyejca queja nopa xochitl. ");
INSERT INTO nheNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Quena, nochi xochitl Toteco quinmacatoc ininyejca yonque cahuantoque san se tlalochtli ama huan hualmostla pilinise. Huajca miyac más inmechyoyontis imojuanti, yonque ohui inquineltocase para inmechmacas tlen inmechpolohua. ");
INSERT INTO nheNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Huajca amo ximocuesoca. Amo xiquijtoca: ‘¿Tlachque tijcuase? o ¿tlachque tiquise? o ¿ica tlachque timoyoyontise?’ ");
INSERT INTO nheNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pampa quej ni moilhuíaj nopa tlacame tlen ax quiixmatij Toteco, pero imoTata tlen itztoc nepa elhuicac, ya quimati monequi nochi ni tlamantli para ica inpanose. ");
INSERT INTO nheNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Achtohui xijtemoca para incalaquise ipan itlanahuatilis Toteco huan para inquipiyase se yolistli tlen xitlahuac iixtla. Huan yajaya inmechmacas nojquiya nochi ni tlamantli tlen monequi. ");
INSERT INTO nheNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Huajca amo ximocuesoca tlen huelis panos mostla. Pampa mojmostla tijpantijtiyohuij cuesoli. Mojmostla achi cuali san timoilhuise tlen nopa cuesoli tlen nopa tonal quihualicac. ");
INSERT INTO nheNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Amo xiquintlajtolsencahuaca sequinoc, huan sequinoc ax inmechtlajtolsencahuase. ");
INSERT INTO nheNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pampa sequinoc nojquiya inmechtequitlachilise ica san se nopa tlayejyecoli queja inquitequihuíaj para inquintequitlachilise. ");
INSERT INTO nheNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Para tlen inquiitaj nochi piltlajtlacoltzitzi tlen quichihua imoicni huan ax inmomacaj cuenta para achi más miyac tlajtlacoli inquichihuaj? Eltoc queja tiquita se piltejtzi ipan iixtiyol moicni, pero ax timomaca cuenta para ta tijpiya hasta se cuatetomitl moixtiyol ijtic. ");
INSERT INTO nheNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Quejatza huelis tiquilhuis moicni: ‘Xinechcahuili nimitzquixtilis nopa piltejtzi tlen calactoc ipan moixtiyol’, quema ta tijpiya se cuatetomitl moixtiyol ijtic? ");
INSERT INTO nheNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tijpiya ome moxayac. Achtohui ximoquixtili nopa cuatetomitl, huan queja nopa titlachiyas cuali para tijquixtilis nopa piltejtzi tlen quipiya moicni iixtiyol ijtic. ");
INSERT INTO nheNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Amo xiquinmaca ax cuajcualme tlen tlatzejtzeloltic pampa queja chichime inmechtlanquechise. Niyon amo xiquinmaca tlen tlahuel patiyo tlacame tlen itztoque queja pitzome, pampa san ipan moquejquetzase. ");
INSERT INTO nheNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Xijtlajtlanica Toteco tlen inmechpolohua huan yajaya inmechmacas. Xijtemoca para inquiixmatise Toteco huan inquipantise. Xijnotzaca Toteco huan yajaya inmechcaltlapos. ");
INSERT INTO nheNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pampa nochi tlen quitlajtlaníaj se tlenijqui, quiselíaj. Huan nochi tlen quitemohuaj para quiixmatise Toteco, quipantíaj. Huan nochi tlen quinotzase Toteco, yajaya quincaltlapos huan quinchihuilis tlen quitlajtlanijque. ");
INSERT INTO nheNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Ica imojuanti intetatme, intla imocone inmechtlajtlanis se pantzi para quicuas, ax inquimacase se tetl. ");
INSERT INTO nheNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Huan intla imocone inmechtlajtlanis se michi para quicuas, ax inquimacasquíaj se cohuatl, ");
INSERT INTO nheNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","pampa yonque intlajtlacolchihuani inquimatij inquinmacase imoconehua tlen cuali. Huajca achi más Toteco imoTata tlen itztoc elhuicac quimati quinmacas tlen cuali tlen quitlajtlanise. ");
INSERT INTO nheNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Huajca xiquinchihuilica sequinoc, ihuical queja inquinequij sequinoc ma inmechchihuilica. Pampa quej ni inquichihuase nochi tlen itlanahuatilhua Moisés huan itiocamanalojcahua Toteco technahuatijque ma tijchihuaca. ");
INSERT INTO nheNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Xicalaqui ipan nopa puerta pitzactzi huan xinejnemi ipan nopa ojtli tlen xitlahuac, pampa nopa ojtli huan nopa puerta tlen patlahuac yohui mictla huan miyac calaquij nepa. ");
INSERT INTO nheNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero pitzactzi nopa puerta huan pitzactzi nopa ojtli tlen yohui elhuicac campa onca yolistli para nochipa huan ax miyac quipantíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Xitlachixtoca pampa ajsise tlacajcayahuani tlen quiijtose para itiocamanalojcahua Toteco, pero ax neli. Nesise queja cuajcualme, pero axtle. Itztoque queja tepechichime tlen moyoyontíaj queja borregojme. ");
INSERT INTO nheNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Queja se tlacatl quiixmati se cuahuitl ipampa itlajca, inquinixmatise ajqueya yajuanti intla inquitlachilise tlen quichihuase. Inquimatij se tejtzonquilitl ax hueli temaca xocomecatl. Se sahuamecatl ax temaca se tlamantli tlen cuali para tijcuase. ");
INSERT INTO nheNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quena, nochi cuali cuatini quipiyaj inintlajca tlen cuali. Huan se cuahuitl tlen ax cuali temaca tlen ax cuali, tlen axaca huelis quitequihuis. ");
INSERT INTO nheNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Se cuali cuahuitl ax hueli temaca seyoc tlamantli itlajca tlen ax cuali, niyon se cuahuitl tlen ax cuali ax hueli temaca seyoc tlamantli itlajca tlen cuali. ");
INSERT INTO nheNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Huan nochi cuatini tlen ax temacaj se itlajca tlen cuali para quitequihuise, quintzontequij tlacame huan quintlatíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Huajca inquinixmatise nopa tlacajcayahuani ica tlen quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Miyac tlacame nechnotzaj: ‘Tohueyiteco’, pero ax nochi yajuanti calaquise campa Toteco tlen itztoc elhuicac tlanahuatía. San yase tlen nelía quichihuaj ipaquilis noTata tlen itztoc elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Quema ajsis nopa tonal para Toteco tetlajtolsencahuas, miyac tlacame nechilhuise: ‘Tohueyiteco, ipan motoca tiquinilhuijque tlacame motlajtol huan tlachque hualasquía teipa, huan ica motoca tiquinquixtijque iajacahua Axcualtlacatl tlen calactoyaj ipan tlacame, huan ica motoca tijchijtoque miyac chicahualnescayotl.’ ");
INSERT INTO nheNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Huan na niquinilhuis: ‘Xiyaca. Ax quema nimechixmatqui. San tlen ax cuali inquichijque.’ ");
INSERT INTO nheNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nochi tlen quicaquij notlajtol huan quichihuaj tlen niquijtohua itztoque queja ni tlalnamijca tlacatl. Yajaya pejqui quichihua ichaj huan quiquetzqui ipan tetl huan quitlamilti. ");
INSERT INTO nheNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Huan pejqui huetzi atl huan tlatemic, huan se ajacatl chicahuac quiilpitztiquisaco, pero ax tleno ipantic ichaj pampa quiquetzqui ipan tetl. ");
INSERT INTO nheNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero nochi imojuanti tlen inquicaquij notlajtol huan ax inquichihuaj tlen nimechilhuía, initztoque queja ni huihui tlacatl. Yajaya nojquiya quichijqui ichaj, pero quiquetzqui ipan xali. ");
INSERT INTO nheNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Teipa huetzqui atl chicahuac huan tlatemic. Huan chicahuac quiilpitztiquisaco ajacatl, huan huetzqui ichaj huan nochi xolejqui.” ");
INSERT INTO nheNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Quema Jesús tlanqui quinmachtía nopa miyac tlacame, yajuanti quisentlachiliyayaj ica itlamachtil, ");
INSERT INTO nheNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","pampa yajaya quinmachtiyaya queja se tlen quipiya tlanahuatili. Ax quinmachtiyaya queja nopa tlamachtiani tlen itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Teipa Jesús temoc tlen nopa tepetl huan miyac tlacame quitoquilijque. ");
INSERT INTO nheNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huan hualajqui campa ya se tlacatl tlen tlacayo palaniyaya ica nopa cocolistli tlen itoca eliyaya lepra. Yajaya motlancuaquetzqui iixtla Jesús huan quiilhui: ―Tohueyiteco, intla tijnequi, tihueli tinechchicahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Huan Jesús quitlali ima ipani huan quiilhui: ―Quena, nijnequi. Ximochicahua amantzi. Huan nimantzi mochicajqui nopa tlacatl tlen tlacayo palaniyaya. ");
INSERT INTO nheNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Huan Jesús quiilhui: ―Axaca xiquilhui. Pero xiya ximonextiti ica nopa totajtzi huan xijmaca Toteco nopa tlacajcahualistli tlen itlanahuatil Moisés techilhui ma quimacaca tlen ayoc quipiyaj inintlacayo palantoc para quej ni nochi quimatise ya timochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Teipa Jesús ajsito altepetl Capernaum, huan ajsico campa ya se capitán romano tlen quinyacanayaya soldados. Huan quitlajtlani Jesús se favor, ");
INSERT INTO nheNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","quiijto: ―Tate, notequipanojca huetztoc huan huajhuapahuixtoc ima huan imetz huan tlahuel tlaijiyohuía. ");
INSERT INTO nheNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Huan Jesús quiilhui: ―Niyas huan nijchicahuati. ");
INSERT INTO nheNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pero nopa capitán tlen soldados quiilhui: ―Tate, ax monequi tiyas pampa ax nihueyi queja ta huan ax quinamiqui ticalaquis nochaj. San xiquijto se tlajtoli para ma mochicahua notequipanojca huan yajaya mochicahuas, pampa ta tijpiya tlanahuatili. ");
INSERT INTO nheNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nojquiya nijpiya notecohua tlen quipiyaj tlanahuatili ica na huan nijchihua inintlajtol. Huan na nojquiya niininteco sequinoc. Huan intla niquilhuis se notequipanojca: ‘Xiya’, yajaya yas, huan intla niquilhuis: ‘Xihuala’, yajaya hualas. Intla niquilhuis notequipanojca: ‘Xijchihua ya ni’, yajaya quichihuas. Ta nojquiya tlen tiquijtohua, mochihua. ");
INSERT INTO nheNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Quema Jesús quicajqui tlen quiijto nopa capitán, quisentlachili, huan quinilhui nopa tlacame tlen quitoquiliyayaj: ―Melahuac nimechilhuía, ax nijpantijtoc niyon se israelita tlacatl tlen nelía temachtli nechneltoca tlen nihueli nijchihua queja ni sejcoyoc ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Huan nimechilhuía miyac tlacame tlen ax israelitame queja ya hualase tlen miyac tlaltini campa quisa tonati huan campa oncalaqui tonati huan calaquise campa tlanahuatía Toteco tlen itztoc elhuicac. Nepa yajuanti tlacuase ininhuaya nopa huejhueyi israelitame: Abraham, Isaac huan Jacob. ");
INSERT INTO nheNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Huan miyac israelitame tlen Toteco quinequiyaya ma calaquica ipan itlanahuatilis, yase campa tzintlayohuilotl pampa ax quinejque calaquise. Quena, Toteco quinmajcahuas hasta nepa campa tlacame chocaj huan tlanhuehuechocaj pampa tlahuel tlaijiyohuíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Huajca Jesús quiilhui nopa capitán tlen soldados: ―Xiya mochaj. Ya nijchijqui nopa tlen tijneltocayaya nijchihuas. Huan ipan nopa tlalochtli quema Jesús quiijto ni tlajtoli, mochicajqui itequipanojca nopa capitán. ");
INSERT INTO nheNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Teipa Jesús yajqui ichaj Pedro huan imona huetztoya ipan itlapech pampa totoniyayaya. ");
INSERT INTO nheNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Huan Jesús quimaitzqui huan nimantzi caxanqui nopa tlatotonilotl. Huan yajaya moquetzqui huan pejqui quintlamaca. ");
INSERT INTO nheNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Huan quema tlayohuatinemiyaya, ajsicoj campa Jesús tlen quinhualicayayaj miyac cocoyani ica iajacahua Axcualtlacatl. Huan Jesús san camatqui huan quinquixtili ica itlajtol. Huan yajaya quinchicajqui nochi tlen mococohuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Quema Jesús quinchicajqui cocoyani, quitlamichihuayaya tlen nopa tiocamanalojquetl Isaías huejcajquiya quiijto: “Yajaya ica iselti quihuicac tococolis huan nochi totlacuajcualocayo.” ");
INSERT INTO nheNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Teipa quema Jesús quinitac para itztoyaj miyac tlacame tlen quitetzopayayaj, techilhui tiimomachtijcahua ma tijhuicaca ipan cuacanahua huan tiquixcotonase nopa hueyi atl para seyoc nali. ");
INSERT INTO nheNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Huan nepa ajsico campa Jesús se tlamachtijquetl tlen itlanahuatil Moisés huan quiilhui: ―Tlamachtijquetl, nijnequi niyas mohuaya campa hueli tiyas. ");
INSERT INTO nheNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Huan Jesús quiilhui: ―Cayochime quipiyaj ininchaj huan totome quipiyaj inintepasol, pero na tlen niMocuepqui Tlacatl ax cana nijpiya campa nimotzontecas. ");
INSERT INTO nheNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Huan seyoc itlatoquilijca quiilhui: ―Tate, xinechcahuili ma nimocahua nochaj para nijtlalpachos notata quema miquis, huan teipa nimitztoquilis. ");
INSERT INTO nheNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Huan Jesús quiilhui: ―Xinechtoquili nimantzi, huan xiquincahuili tlacame tlen mictoque iixtla Toteco ma quintlalpachoca ininmijcapoyohua. ");
INSERT INTO nheNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Huajca Jesús tlejcoc sampa ipan cuacanahua huan tiimomachtijcahua tiyajque ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Huan quema ya tiitztoyaj tlatlajco hueyi atl, pejqui tlaajaca chicahuac huan nopa atl tlahuel calaquiyaya ipan cuacanahua, pero Jesús cochtoya. ");
INSERT INTO nheNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Huajca tojuanti tiquixititoj huan tiquilhuijque: ―Tohueyiteco, xitechmanahui pampa ya timisahuíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Huajca Jesús techilhui: ―¿Para tlen inmajmahuij? Tlahuel pilquentzi innechneltocaj. Huan yajaya mejqui huan quitlacahualti nopa ajacatl huan nopa hueyi atl huan ayoc mojmolinijque. ");
INSERT INTO nheNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Huan tiimomachtijcahua tijsentlachilijque huan timoilhuijque se ica seyoc: ―Ni Jesús, ¿ajqueya nelía yaja? Yajaya quipiya tlanahuatili hasta ica ajacatl huan hueyi atl. ");
INSERT INTO nheNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Huan teipa tiajsitoj nepa seyoc nali hueyi atl ipan se tlali tlen itoca Gadara. Huan hualajque ome tlacame tlen quinpixtoyaj iajacahua Axcualtlacatl huan quinamiquicoj Jesús. Quisayayaj ipan tlacacahuaya campa quintlaliyayaj mijcatzitzi ipan campo santo pampa nepa mocahuayayaj. Huan nelía mosisiniyayaj huan temajmatiyayaj tlahuel hasta axaca huelqui panoj ipan nopa ojtli. ");
INSERT INTO nheNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Huan nopa tlacame chicahuac quiilhuijque: ―Jesús, ta tiIcone Dios. ¿Tihualajtoc nica campa tojuanti para titechtlaijiyohuiltis quema noja polihui tonali? ");
INSERT INTO nheNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Huan ica huejca itztoyaj miyac pitzome tlen tlacame quinhualicaque ma tlacuajtinemica. ");
INSERT INTO nheNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Huan iajacahua Axcualtlacatl tlen itztoyaj ipan nopa tlacame pejque quitlajtlaníaj Jesús: ―Intla tijnequi ma tiquistehuaca ipan ni tlacame, xitechcahuili ma ticalaquica ipan nopa miyac pitzome. ");
INSERT INTO nheNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Huan Jesús quinilhui iajacahua Axcualtlacatl: ―Xiyaca. Huajca nopa ajacame quisque huan calajque ipan inintlacayo nopa pitzome. Huan nochi nopa pitzome motlalojtejque huan motepexihuijque tepeixco huan huetzque ipan hueyi atl huan misahuijque. ");
INSERT INTO nheNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Huan nopa tlacame tlen quinmocuitlahuiyayaj nopa pitzome motlalojtejque hasta altepetl huan teyolmelajque nochi tlen panoc ica nopa tlacame tlen quinpiyayaya iajacahua Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Huan nochi altepetl ehuani hualajque campa Jesús huan quema quiitaque, quitlajtlanijque ma quisa tlen inintlal. ");
INSERT INTO nheNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Huajca Jesús sampa tlejcoc ipan cuacanahua tohuaya huan tipanoque hasta seyoc nali campa ialtepe. ");
INSERT INTO nheNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Huan ajsicoj sequin tlacame tlen quihualicayayaj campa Jesús se tlacatl ipan itlapech huan yajaya huajhuapahuixtoc. Huan Jesús quiitac para nopa tlacame quineltocayayaj para huelis quichicahuas, huajca quiilhui nopa cocoxquetl: ―Nohuampo, xipaqui. Nimitztlapojpolhuijtoc motlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Huajca sequin nopa tlamachtiani tlen itlanahuatil Moisés moilhuijque Jesús quichijqui se hueyi tlajtlacoli pampa camati queja yajaya elisquía Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Huan Jesús quimatqui tlachque moilhuiyayaj, yeca quinilhui: ―¿Para tlen inmoilhuíaj ipan imoyolo para nijchijtoc tlen ax cuali? ");
INSERT INTO nheNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","San se ax ohui elis para na, yonque niquilhuis ni cocoxquetl: ‘Nimitztlapojpolhuía motlajtlacolhua’, o niquilhuis: ‘Ximehua huan xinejnemi’, pampa nima mochihuas tlen niquijtohua. ");
INSERT INTO nheNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pero pampa nijnequi xijmatica na tlen niMocuepqui Tlacatl nijpiya tlanahuatili ipan tlaltepactli para nitetlapojpolhuis tlajtlacoli, huajca nimechnextilis para panos tlen hueli niquijtohua. Huajca Jesús quiilhui nopa cocoxquetl: ―Ximehua, xijtlalana motlapech huan xiya mochaj. ");
INSERT INTO nheNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Huan nopa cocoxquetl mejqui huan yajqui ichaj. ");
INSERT INTO nheNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Huan nochi quisentlachilijque quema quiitaque tlen panoc, huan quihueyichijque Toteco Dios pampa quimacac Jesús nopa chicahualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Teipa Jesús quisqui nepa huan panoc tequicalco campa na, niMateo, niitztoya. Nimosehuijtoya ipan tequicali huan nitlainamayaya impuesto. Huan Jesús nechilhui: ―Xihuala, xinechtoquili. Huan nimoquetzqui huan niyajqui ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús huan tojuanti tiimomachtijcahua titlacuayayaj nepa nochaj. Huan hualajque miyac tlacame tlen tlainanque impuesto huan tlacame tlen miyac tlajtlacoli quichijtoyaj. Huan mosehuicoj huan tlacuajque ihuaya Jesús huan tiimomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Huan nopa fariseos quiitaque huan techtlajtlanijque tiimomachtijcahua: ―¿Para tlen imotlamachtijca tlacua ininhuaya tlainamani tlen mojmostla tlacajcayahuaj huan ininhuaya tlacame tlen miyac tlajtlacoli quichihuaj? ");
INSERT INTO nheNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Huan Jesús quincajqui huan quinilhui: ―Se tetica tlacatl ax quinequi se tepajtijquetl, pero se cocoxquetl, quena. ");
INSERT INTO nheNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ximomachtica tlachque quiijtosnequi ni tlajtoli tlen ijcuilijtoc ipan Itlajtol Toteco: ‘Ax nijnequi xinechmacaca tlapiyalime para tlacajcahualistli. Nijnequi xitetlasojtlaca.’ Ax nihualajtoc para niquinnotzas tlacame tlen moilhuíaj ya itztoque xitlahuaque iixtla Toteco. Nihualajtoc para niquinnotzas ma moyolpatlaca tlen quimatij quipiyaj inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Huan se tonal hualajque imomachtijcahua Juan campa Jesús huan quitlajtlanijque: ―¿Para tlen momomachtijcahua ax mosahuaj, pero nopa fariseos huan tojuanti tlen tijtoquilíaj Juan miyac huelta timosahuaj? ");
INSERT INTO nheNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Huan Jesús quinilhui: ―¿Quejatza huelise mosahuase huan mocuesose ihuampoyohua se mosihuajtijquetl quema tlacuaj ihuaya ipan se nenamictili huan nopa mosihuajtijquetl itztoc ininhuaya? Ihuical eli ax hueli mosahuaj nomomachtijcahua quema na niitztoc ininhuaya. Pero ajsis hora quema nocualancaitacahua nechhuicase, huan huajca, quena, mosahuase nomomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Axaca quitlatlamanía se yoyomitl tlen sosoltic ica se yoyomitl tlen yancuic . Pampa tlen yancuic motzojtzocoyolos huan nimantzi tzayanis ne yoyomitl tlen sosoltic huan achi más fiero elis. ");
INSERT INTO nheNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nojquiya axaca quiteca xocomeca atl tlen yancuic ipan bolsas tlen cuetlaxtli sosoltic, pampa quema nopa yancuic xocomeca atl xocoyas, mohueyilis, huan tzayanis nopa cuetlaxtli sosoltic. Huan nopa tlacatl quinenpolos nopa xocomeca atl huan nopa cuetlaxtli. Yeca nopa xocomeca atl tlen yancuic monequi quitecas ipan cuetlaxtli tlen yancuic huan queja nopa ax quinenpolos yon nopa xocomeca atl, yon nopa cuetlaxtli.” ");
INSERT INTO nheNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Quema Jesús tlanqui quinilhuía tlacame ni tlajtoli, ajsico se tequihuejquetl tlen nopa israelita tiopamitl. Yajaya motlancuaquetzqui iixtla Jesús huan quiilhui: ―Amantzi onmijqui nosihuapil, pero intla tiyas tijtlaliliti moma, moyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Huan Jesús moquetzqui huan yajqui ihuaya nopa tlacatl, huan tiimomachtijcahua nojquiya tiyajque ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Huan ipan ojtli tijpantijque se sihuatl tlen mojmostla esotemoyaya para majtlactli huan ome xihuitl. Huan nopa sihuatl monechcahuico iica Jesús huan quitoxonqui iyoyo itenhuaxo. ");
INSERT INTO nheNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pampa yajaya moilhuiyaya intla san huelis quitoxomas iyoyo, mochicahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huajca Jesús moicanitac huan quiilhui: ―Nane, xipaqui. Pampa tinechneltoca, ya timochicajtoc. Huan nopa sihuatl mochicajqui ipan nopa tlalochtli. ");
INSERT INTO nheNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Teipa Jesús ajsito ichaj nopa tlayacanquetl huan quinitac tlapitzani tlen quichihuayayaj mijcahuicatl huan nojquiya quinitac miyac tlacame tlen tlahuejchihuayayaj ipampa nopa mijcatzi. ");
INSERT INTO nheNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Huan Jesús quinilhui: ―Xiquisaca, pampa ni sihuapil ax mictoc, san cochtoc. Huan yajuanti pejque quihuetzquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Pero Jesús quinquixti huan teipa calajqui campa quitectoyaj nopa sihuapil. Huan quimaitzqui nopa sihuapil huan nimantzi yajaya mejqui. ");
INSERT INTO nheNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Huan campa hueli ipan nopa tlali nochi quicajque tlen panoc. ");
INSERT INTO nheNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Teipa Jesús quisqui tlen nepa huan quitoquilijque ome tlacame tlen popoyotzitzi huan quitzajtzilijtiyohuiyayaj: ―Xitechtlasojtla, ta tiiteipa ixhui David tlen huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Huan Jesús calajqui ipan se cali, huan nopa popoyotzitzi nojquiya calajque huan Jesús quintlajtlani: ―¿Innechneltocaj para nihueli nimechchicahuas? Huan yajuanti quiilhuijque: ―Quena, Tohueyiteco. ");
INSERT INTO nheNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Huajca quintlalili ima ipan iniixtiyolhua huan quinilhui: ―Pampa innechneltocatoque para nihueli nimechchicahuas, huajca ya inmochicajtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Huan elqui queja tlapojque iniixtiyolhua huan nimantzi huelque tlachiyaj. Huan Jesús quinnahuati chicahuac, quinilhui: ―Axaca xiquilhuica tlen nimechchihuilijtoc. ");
INSERT INTO nheNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero nopa tlacame quisque huan pejque quinilhuijtinemij nochi tlacame tlen Jesús quinchihuili. ");
INSERT INTO nheNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Quema ya quistoyaj nopa tlacame tlen achtohui eliyayaj popoyotzitzi, ajsicoj tlacame tlen quihualicayayaj campa Jesús se nonotzi tlen quipixtoya se iajacayo Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Huan Jesús quiquixtili iajacayo Axcualtlacatl, huan nopa tlacatl pejqui camati. Huajca nopa miyac tlacame quisentlachilijque huan quiijtojque: ―Ax quema tiquitztoque se tlacatl tlen hueli quichihua tlamantli queja ni ipan nochi totlal Israel. ");
INSERT INTO nheNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero nopa fariseos quiijtojque: ―Yajaya quinquixtilía ajacame ica itlapalehuil Axcualtlacatl tlen quinyacana nochi ajacame. ");
INSERT INTO nheNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Huan Jesús tlamachtitinenqui ipan sesen israelita tiopamitl campa hueli ipan nochi altepetini huan pilaltepetzitzi. Quinilhuiyaya tlacame nopa cuali tlajtoli tlen quejatza huelis calaquise campa tlanahuatía Toteco. Huan quinchicahuayaya tlacame tlen quipixtoyaj nochi tlamantli cocolistli huan tlacuajcualocayotl. ");
INSERT INTO nheNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Huan quema quinitac nochi nopa miyac tlacame tlen hualajtoyaj campa ya para ma quinpalehui, quintlasojtlac pampa nelía miyac cuesoli quipixtoyaj hasta moilhuijque ayoc tleno ininpati. Itztoyaj queja borregojme tlen ax quipixque inintlamocuitlahuijca. ");
INSERT INTO nheNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Huajca Jesús techilhui tiimomachtijcahua: ―Itztoque miyac tlacame tlen quichiyaj para quicaquise notlajtol, pero san ax miyaqui tlacame para yase quinilhuitij. Eltoc queja onca se hueyi pixquistli pero san itztoque se ome tlatequipanohuani para quisentilise. ");
INSERT INTO nheNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Huajca xijtlajtlanica Toteco ma quintitlani más tlatequipanohuani ma teilhuica itlajtol pampa nopa pixquistli iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús technotzqui ma timosentilica timajtlacme huan ome tiimomachtijcahua tlen techtlapejpenijtoya. Huan techmacac tlanahuatili tiquinquixtilise iajacahua Axcualtlacatl huan tiquinchicahuase tlacame tlen mococohuaj huan tlen quinajsiyayaj nochi tlamantli cocolistli huan tlacuajcualocayotl. ");
INSERT INTO nheNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nica eltoc totoca timajtlactli huan ome tiimomachtijcahua. Yajaya tlen achtohui: Simón tlen nojquiya quitocaxtiyayaj Pedro, huan iicni tlen itoca Andrés, teipa Jacobo huan iicni, Juan, tlen itztoyaj itelpocahua Zebedeo. ");
INSERT INTO nheNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Teipa Felipe, Bartolomé, Tomás huan na niMateo tlen achtohui nitlainanqui impuesto. Teipa Jacobo, itelpoca Alfeo. Teipa Judas , iicni Jacobo, ");
INSERT INTO nheNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","teipa Simón tlen moiyocanequiyaya ica partido cananista, huan teipa Judas Iscariote tlen teipa quitemactili Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Huan quema Jesús itztoya para techtitlanis timajtlacme huan ome tiimomachtijcahua, techilhui: “Amo xiyaca campa itztoque tlacame tlen ax israelitame huan amo xicalaquica ipan niyon se altepetl ipan estado Samaria. ");
INSERT INTO nheNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","San xiyaca campa israelitame pampa yajuanti itztoque queja borregojme tlen mocuapolojtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Xiquinyolmelahuatij para quinnechcahuía itlanahuatilis Toteco tlen itztoc ipan elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nojquiya xiquinchicahuaca cocoyani huan tlacame tlen tlacayo palanij ica nopa cocolistli tlen itoca lepra. Huan xiquinyolitica tlen mictoque. Xiquinquixtica iajacahua Axcualtlacatl tlen calactoque ipan tlacame. San tlapic nimechmaca ni chicahualistli, huajca ax quema xitlainamaca quema intepalehuise. ");
INSERT INTO nheNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Amo xijhuicaca tomi campa inyase, niyon tlen oro, niyon tlen plata, niyon tlen cobre. ");
INSERT INTO nheNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Amo xijhuicaca se yoyon coxtali, niyon yoyomitl tlen ica inmopatlase. Amo xijhuicaca sequinoc tecactli, niyon amo xijhuicaca cuatopili, pampa initlatequipanojcahua Toteco huan quinamiqui para tlacame inmechmacase tlen ica inpanose. ");
INSERT INTO nheNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Huan quema inajsitij ipan se altepetl o ipan se rancho, xitlajtlanica intla itztoc se cuali tlacatl nepa huan xiquitaca intla huelis inmocahuase ihuaya. Huan nepa ximocahuaca hasta inquisase ipan nopa altepetl. ");
INSERT INTO nheNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Huan quema incalaquise ipan se cali, xiquijtoca: ‘Ma Toteco inmechtiochihua tlen initztoque nica.’ ");
INSERT INTO nheNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Huan intla cuajcualme itztoque ipan nopa cali, huajca Toteco quintiochihuas. Huan intla ax cuajcualme, Toteco ax quintiochihuas. Huan nopa tlatiochihuali mocahuas ipan imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Intla tlacame ax inmechselise huan ax quipajcaquise imotlajtol, huajca xiquisaca ipan nopa cali o nopa altepetl, huan ximotecactzejtzeloca para ma tepehui nopa tlalpotectli. Huan ya nopa elis se tlanextili para tlacame tlen nopa altepetl quiselise se hueyi tlatzacuiltili. ");
INSERT INTO nheNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Melahuac nimechilhuía, quema Toteco quintlajtolxitlahuas, nopa tlacame tlen ax quiselíaj notlajtol, tlaijiyohuise más miyac que nopa tlacame tlen itztoyaj ipan altepetini Sodoma huan Gomorra huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nimechtitlani campa tlacame tlen ax cuajcualme. Huan queja mahuilili para borregojme mopantise ininhuaya tepechichime, nojquiya elis mahuilili para imojuanti. Huajca ximochihuaca intlalnamiquini queja cohuame, pero xiitztoca queja palomas tlen ax tleno quichihuaj tlen ax cuali. ");
INSERT INTO nheNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ximomocuitlahuica ica tlen inmechchihuilise tlacame pampa inmechhuicase iniixtla tlasentilistli tlen tequitini huan inmechhuitequise ipan israelita tiopantini. ");
INSERT INTO nheNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Huan hasta inmechhuicase iniixtla gobernadores huan huejhueyi tlanahuatiani pampa innechneltoquilíaj. Huan queja nopa huelis inquinyolmelahuase tlen na iniixtla tlacame tlen israelitame huan iniixtla tlen ax israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huan quema inmechhuicase para inmechtzacuase, amo ximocuesoca tlachque inquiijtose para inmomanahuise, pampa ipan nopa tlalochtli Toteco Dios inmechmacas nopa tlajtoli tlen monequi inquiijtose. ");
INSERT INTO nheNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ax imojuanti tlen incamatise nepa, pero elis Itonal Toteco tlen camatis ipan imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ipan nopa tonali tlacame tlen ax nechneltocaj quintemactilise ma quinmictica hasta iniicnihua tlen nechneltocaj. Sequinoc tlen ax nechneltocaj quintemactilise ma quinmictica hasta ininconehua tlen nechneltocaj. Huan sequin telpocame huan ichpocame tlen ax nechneltocaj quintemactilise ma quinmictica hasta inintatahua pampa nechneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nochi tlacame inmechcocolise pampa innechneltocaj, pero Toteco quinmanahuis nochi tlen quiijiyohuise hasta itlamiya ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Huan quema tlacame inmechtlaijiyohuiltise ipan se altepetl, ximotlaloca hasta seyoc altepetl. Melahuac nimechilhuía, ax intlamicamanalose Itlajtol Toteco ipan nochi altepetini ipan tlali Israel hasta quema na tlen niMocuepqui Tlacatl nimocuepas. ");
INSERT INTO nheNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Se momachtijquetl ax quiselía tlen más cuali que itlamachtijca. Huan se tlatequipanojquetl ax quipantía tlen más cuali que quipantía iteco. ");
INSERT INTO nheNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Initztoque innomomachtijcahua huan innotlatequipanojcahua, huajca quinamiqui para imopantis queja na nopantis. Tlacame nechtocaxtijtoque niAxcualtlacatl huan na queja nopa caltecojtli, huajca más ax cuali inmechchihuilise imojuanti tlen initztoque queja innoconehua. ");
INSERT INTO nheNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Amo xiquinimacasica tlacame pampa nochi tlen inmechchihuilise ixtacatzi monextis teipa. Huan tlen motlatijtoc ama, teipa nochi quimatise. ");
INSERT INTO nheNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ni tlajtoli tlen ama nimechilhuía iyoca quema tlayohua, xitlayolmelahuaca campa hueli quema tonaya. Tlen nimechixtacacamahuía ama, monequi chicahuac xitlayolmelahuaca tlen inintzonpac caltini para nochi ma quicaquica. ");
INSERT INTO nheNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amo xiquinimacasica tlacame tlen quinequij inmechmictise, pampa san huelise quimictise imotlacayo huan ax tleno huelis quichihuilise imoalma. Monequi xiquimacasica san Toteco Dios pampa yajaya quipiya chicahualistli para quixolehuas imoalma huan imotlacayo nepa mictla. ");
INSERT INTO nheNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Yonque pilquentzi ininpati piltototzitzi nica ipan tlaltepactli huan quinnamacaj ome para se centavo, yajuanti ipatij miyac iixtla Toteco hasta niyon se ax miqui intla Toteco ax quicahuilía. ");
INSERT INTO nheNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Pero ica imojuanti miyac más Toteco inmechmocuitlahuía hasta quimati quesqui imotzoncal inquipiyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Huajca amo ximomajmatica. Miyac más imopati iixtla Toteco que miyac totome. ");
INSERT INTO nheNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Intla se tlacatl nechneltoca huan teyolmelahua para nechneltoca, na nojquiya niquilhuis noTata nepa elhuicac para yajaya noaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero ajqueya teyolmelahua para ax nechneltoca, huajca na nojquiya niquilhuis noTata nepa elhuicac para yajaya ax noaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Amo ximoilhuica nihualajtoc para oncas tlasehuilistli ipan ni tlaltepactli. ¡Ax neli! Eltoc queja nihualajtoc ica machete. ");
INSERT INTO nheNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nihualajtoc para niquinxejxelos tlacame. Nopampa na tlacame moiyocatlalise tlen inintata, huan ichpocame moiyocatlalise tlen ininnana. Huan yeyojme moiyocatlalise tlen iniyejnahua. ");
INSERT INTO nheNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Huan se tlacatl tlen nechneltoca huelis quinpiyas icualancaitacahua tlen ichampoyohua. ");
INSERT INTO nheNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Intla se quiicnelía inana o itata más que na nechicnelía, huajca ax quinamiqui para elis noaxca. Intla se quiicnelía isihuapil o ioquichpil más que na, huajca ax quinamiqui para elis noaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Monequi se tlacatl tlen nechtoquilis mocualtlalijtos para miquis para na queja se tlen quihuica icuamapel para ipan miquis. Huan tlen ax queja nopa nechtoquilijtiyas, ax quinamiqui elis noaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Yajaya tlen quinequi quimanahuis iyolis para ax miquis nopampa na, quipolos ialma. Pero yajaya tlen miquis nopampa na huan quipolos iyolis nica ipan tlaltepactli, quipantis yolistli para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tlacame tlen inmechselise, nojquiya nechselíaj. Huan tlen nechselía, quiselía noTata tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Huan intla se tlacatl quipalehuis se tiocamanalojquetl pampa yajaya quitequipanohua Toteco, yajaya quiselis tlaxtlahuili queja Toteco quimacas nopa tiocamanalojquetl. Huan intla se tlacatl quipalehuis se cuali tlacatl, san pampa quimachilía yajaya se cuali tlacatl, teipa quiselis itlaxtlahuil queja Toteco quimacas nopa cuali tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Intla se tlacatl san mitzmacas san se taza tlen sesec atl para tiquis pampa tinomomachtijca, huan yonque ax tihueyi iniixtla tlacame queja sequinoc nomomachtijcahua, nimitzilhuía Toteco quitlaxtlahuis.” ");
INSERT INTO nheNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quema Jesús tlanqui techmachtía timajtlacme huan ome tiimomachtijcahua huan techtlamiilhui tlen tijchihuasquíaj, tiyajque ipan totequi. Huan yajaya quisqui nepa huan yajqui tlamachtito huan tlacamanaloto itlajtol ipan altepetini tlen nechca. ");
INSERT INTO nheNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Huan quema Juan tlen tecuaalti itztoya ipan tlatzactli huan quicajqui tlen Cristo quichihuayaya, quintitlanqui imomachtijcahua ma quicamahuitij. ");
INSERT INTO nheNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Huajca imomachtijcahua Juan quitlajtlanijque Jesús: ―¿Ta tiCristo tlen Toteco techilhuijtoc hualasquía o monequi noja timochiyase para ma huala? ");
INSERT INTO nheNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Huan Jesús quinnanquili: “Xiyaca, xijyolmelahuatij Juan tlen inquicactoque huan inquiitztoque. ");
INSERT INTO nheNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xiquilhuitij para ica nochicahualis, tlacame tlen popoyotzitzi, ama tlachiyaj. Huan metzcuachotzitzi, ya cuali nejnemij. Huan tlacame tlen tlacayo palantoyaj ica lepra, mochicajtoquejya. Tlen nacastapaltzitzi, ama tlacaquij. Huan tlen mictoyaj, moyolcuitoquejya. Huan tlen más teicneltzitzi quicaquij nopa cuali tlajtoli tlen Toteco pampa niquincamahuía. ");
INSERT INTO nheNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Huan nojquiya xiquilhuitij para Toteco quitiochihuas tlen quimachilis ajqueya naja huan nechtoquilis.” ");
INSERT INTO nheNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Huan teipa quema ya quistoyaj imomachtijcahua Juan, Jesús pejqui quincamahuía tlen Juan itequi nopa miyac tlacame tlen quiyahualojtoyaj. Quiijto: “Quema achtohuiya inyajque ipan tlali huactoc campa ax tleno eli para inquiitatij Juan, ¿tlachque inmoilhuiyayaj inquiitasquíaj? ¿Inmoilhuiyayaj inquiitasquíaj se tlacatl tlen yamanic queja se pilacatzi tlen moojolinía quema tlaajaca? ¡Ax ya nopa! ");
INSERT INTO nheNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Niyon ax inmoilhuiyayaj inquiitasquíaj se tlacatl tlen moyoyontijtoc ica se yoyomitl tlen nelcuali. Ya inquimatij tlen moquentíaj yoyomitl tlen nelcuali itztoque ipan ininchajchaj tlanahuatiani. Nimechilhuis para tlen inyajque. ");
INSERT INTO nheNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Inyajque ipan nopa tlali huactoc campa Juan itztoya pampa inquimatiyayaj yajaya se itiocamanalojca Toteco. Quena, nimechilhuía Juan se tiocamanalojquetl. Yajaya nopa tiocamanalojquetl tlen más hueyi. ");
INSERT INTO nheNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ipan Itlajtol Toteco camati tlen Juan campa ijcuilijtoc: ‘Xiquita, nijtitlanis notlayolmelajca ma mitzyacanas. Yajaya quicualtlalis ininyolo tlacame para ma mitzselise.’ ");
INSERT INTO nheNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Melahuac nimechilhuía, axaca seyoc tlen tlacajtoc ipan ni tlaltepactli tlen más hueyi iixtla Toteco que Juan tlen tecuaaltía. Pero nopa tlacatl tlen itztoc más pilsiltzi ipan itlanahuatilis Toteco tlen itztoc ipan elhuicac, yajaya elis más hueyi que Juan. ");
INSERT INTO nheNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Tlen nopa tonali quema nejnemiyaya Juan tlen tecuaaltiyaya huan hasta ama, miyac quinequij tlatehuise tlen quejatza tlanahuatis Toteco tlen itztoc ipan elhuicac, pampa Toteco quisencajtoc quejatza tlanahuatis, pero ax queja yajuanti quinequij. Huan yeca quinequij ica fuerza quichihuase ma eli seyoc tlamantli tlanahuatili. ");
INSERT INTO nheNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Nochi itiocamanalojcahua Toteco tlen hualajque achtohui quema aya ajsiyaya Juan, tecamahuiyayaj tlen teipa panosquía ipan ni tonali. ");
INSERT INTO nheNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Quiijtojque hualasquía se Elías, huan intla inquinequij inquimatise, yajuanti camatiyayaj tlen Juan, pampa Juan yajaya Elías. ");
INSERT INTO nheNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Inquipiyaj imonacas, huajca xijcaquica tlen nimechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Quejatza huelis nimechilhuis intlacame tlen ama initztoque quejatza initztoque? Initztoque queja coneme tlen mosehuíaj tianquis huan quinnotzaj sequinoc coneme ma mahuilticaj ininhuaya huan nopa sequinoc ax quinneltoquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Huajca nopa coneme cualanij huan quiijtohuaj: ‘Titlapitzque para ximijtotica, pero ax inmijtotijque. Tihuicaque se huicatl tlen cuesoli queja mictoya se acajya, pero ax inchocaque.’ ");
INSERT INTO nheNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Queja nopa coneme, imojuanti ax inpaquij intla ax nochi pano queja inquichiyaj ma pano. Pampa hualajqui Juan huan mosajqui huan ax quiic xocomeca atl huan inquiijtojque quipixtoya se iajaca Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Huan na tlen niMocuepqui Tlacatl nihualajtoc, huan nijcua huan niqui tlen onca; huan inquiijtojque nineltlacuajquetl huan nineltlaiquetl. Inquiijtojtoque ninejnemi ininhuaya tlacajcayahuani tlen tlainamaj impuesto huan ininhuaya tlacame tlen miyac tlajtlacoli quichijtoque. Pero intla Toteco nechmacatoc cuali notlalnamiquilis, teipa tlanempa nesis para nijchihua tlen xitlahuac.” ");
INSERT INTO nheNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Teipa Jesús pejqui quiijtohua para ax cuali tlen quichijque tlacame ipan altepetini campa quichijtoya miyac chicahualnescayotl iniixtla, pampa yajuanti ax moyolcuepque. ");
INSERT INTO nheNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Quiijto: “Inteicneltique tlen inehuaj altepetl Corazín pampa Toteco inmechtlatzacuiltis. Inteicneltique tlen inehuaj Betsaida, pampa ax innechneltocaque quema nijchijqui huejhueyi chicahualnescayotl imoixtla. Intla tlacame tlen huejcajquiya itztoyaj ipan altepetini Tiro huan Sidón quiitztosquíaj nochi nopa chicahualnescayotl tlen nijchijqui imoixtla, moyolcueptosquíaj nimantzi huan nochi tlacame quimajtosquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Huan nojquiya nimechilhuía, ipan nopa tonal quema Toteco tetlajtolsencahuas, más chicahuac inmechtlatzacuiltis imojuanti tlen inquicactoque notlajtol huan ax inquinejque inmoyolpatlase, que quintlatzacuiltis nopa ax cuajcualme tlen itztoyaj ipan Tiro huan Sidón huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Imojuanti tlen inehuaj altepetl Capernaum, inmohueyimatij huan inmoilhuíaj inmotlalanase hasta elhuicac, pero axtle. Intemose hasta mictla pampa ax inmoyolcueptoque. Intla Sodoma ehuani tlen huejcajquiya quiitztosquíaj nopa chicahualnescayotl tlen inquiitztoque, moyolcueptosquíaj huan noja mocahuasquía inialtepe hasta ama. ");
INSERT INTO nheNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Huan ipan nopa tonal quema Toteco tetlajtolsencahuas, más inmechtlatzacuiltis inCapernaum ehuani que quintlatzacuiltis nopa ax cuajcualme tlen huejcajquiya itztoyaj ipan Sodoma.” ");
INSERT INTO nheNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Huan ipan nopa tonal nojquiya Jesús quicamahui Itata, Toteco Dios, huan quiilhui: “Papá, ta tiToteco Dios tlen titlanahuatía ipan elhuicac huan ipan tlaltepactli. Nimitzhueyimati pampa tijtlatijtoc ni tlamantli para ma ax quimachilica tlacame tlen moilhuíaj tlalnamiquini huan miyac quimachilíaj. Huan ama tiquinnextilijtoc tlacame tlen itztoque queja coneme huan ax mohueyimatij. ");
INSERT INTO nheNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Quena, queja nopa tijchijtoc pampa queja nopa elqui mopaquilis.” ");
INSERT INTO nheNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Huan Jesús quinilhui nopa tlacame: “NoTata nechmacatoc tlanahuatili ipan nochi tlamantli. Axaca cuali nechyolixmati, san Toteco noTata, quena, yajaya cuali nechyolixmati. Huan axaca quiyolixmati Toteco noTata, san na, quena, cuali nijyolixmati. Huan nojquiya quiyolixmatise nopa tlacame tlen nijnequi para niquinnextilis ajqueya ya. ");
INSERT INTO nheNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Xihualaca campa na nochi imojuanti tlen intlaxicohuaj huan intlamamalhuicaj etic, huan na nimechquixtilis imotlamamal para ximosehuica huan ximosiyajcahuaca. ");
INSERT INTO nheNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xinechcahuilica ma nieli niimoTeco huan xinemica nohuaya. Ximomachtica tlen na pampa na nijpiya noyolo. Ax nimohueyimati huan ica na inquipantise tlen quitemohua imoalma para ma mosehuis huan mosiyajcahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ax ohui nopa tequitl tlen nimechmacas. Eltoc queja se tlamamali tlen ax etic.” ");
INSERT INTO nheNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ipan nopa tonali, ipan se sábado quema tiisraelitame timosehuíaj, Jesús panoyaya ipan se mili tlen quipixqui toctli tlen trigo. Huan tiimomachtijcahua timayanayayaj huan tijquechcocototzque quentzi trigo huan tijcuajque. ");
INSERT INTO nheNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Huan nopa fariseos techitaque huan quiilhuijque Jesús: ―Xiquita tlen quichihuaj momachtijcahua. Yajuanti tequitij, pampa quipixcaj trigo huan ama sábado. Huan itlanahuatil Moisés technahuatíaj tiisraelitame ma ax titequitica ipan ni tonal. ");
INSERT INTO nheNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Huajca Jesús quinilhui: ―Huelis ax inquipojtoque tlen David huan ihuampoyohua quichijque quema tlahuel mayanayayaj huan ax elqui se tlajtlacoli. ");
INSERT INTO nheNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Calajque ipan ichaj Toteco huan quicuajque nopa pantzi tlen totajtzitzi quitlalilíaj iixtla Toteco. Huan itlanahuatilhua Moisés ax quicahuili para David, niyon tlen itztoyaj ihuaya ma quicuaca, pampa quiijto san totajtzitzi huelis quicuase nopa pantzi. ");
INSERT INTO nheNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Nojquiya huelis ax inquipojtoque ipan itlanahuatilhua Moisés campa quiijto para nopa totajtzitzi monequi quiixpanose nopa tlanahuatili para ma ax tequitica ipan sábado, pampa monequi tequitise ipan tiopamitl huan ya nopa ax elqui tlajtlacoli. ");
INSERT INTO nheNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Huan nimechilhuía na niitztoc más nihueyi iixtla Toteco que nopa tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Huelis ax inquimachilíaj Itlajtol Toteco campa quiijtohua: ‘Nijnequi xiquintlasojtlaca tlacame, ax nijnequi san xinechmacaca tlapiyalime para tlacajcahualistli.’ Intla inquimachilijtosquíaj, inquintlasojtlatosquíaj nomomachtijcahua tlen mayanaj, huan ax inquinteilhuijtosquíaj pampa ax tleno ax cuali quichijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Na tlen niMocuepqui Tlacatl nijpiya tlanahuatili para niquinilhuis tlacame tlachque huelis quichihuase ipan sábado, ni tonal para ma timosehuica tiisraelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesús quistejqui nepa huan yajqui inintiopa. ");
INSERT INTO nheNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Huan nepa itztoya se tlacatl tlen mahuactoya. Huan nopa fariseos quitemohuayayaj tlen ica quiteilhuisquíaj Jesús, huajca quitlajtlanijque: ―¿Techcahuilíaj itlanahuatil Moisés para tijchicahuas se tlacatl ama ipan ni tonal para tiisraelitame timosehuise? ");
INSERT INTO nheNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Huan Jesús quinilhui: ―Intla se tlen imojuanti quipiyasquía se borrego tlen huetzisquía ipan ostotl ipan sábado, ni tonal para timosehuise, ¿ax tijquixtisquía? ");
INSERT INTO nheNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Se tlacatl ipati más que se borrego. Huajca quena, quinamiqui para tijchihuase tlen cuali ipan ni tonal para timosehuise. ");
INSERT INTO nheNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Huajca Jesús quiilhui nopa tlacatl tlen mahuactoya: ―Xijxitlahua moma. Huan yajaya quixitlajqui huan mocualtili queja nopa seyoc ima. ");
INSERT INTO nheNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Huajca nopa fariseos quisque nepa huan mocamahuijque san sejco quejatza quichihuase para quimictise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús quimatiyaya tlen nopa tlacame quisencahuayayaj quichihuase, huajca quisqui nepa. Huan quitoquiliyayaj miyac tlacame, huan quinchicajqui nochi tlen mococohuaj nepa. ");
INSERT INTO nheNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero quinilhui ma ax quinilhuise sequinoc ajqueya ya. ");
INSERT INTO nheNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ica nochi ni tlamantli tlen Jesús quichijqui tlanqui nopa tlajtoli tlen Toteco quiijto huejcajquiya huan tlen tiocamanalojquetl Isaías quiijcuilo. Quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Xijtlachili ni notequipanojca tlen nijtlapejpenijtoc. Niquicnelía miyac, yajaya quichihua tlen tlahuel nechpactía. Na nijtlalis Notonal ipan ya, huan yajaya quinilhuis tlacame tlen ax israelitame tlen nopa tonal quema Toteco tetlajtolsencahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Yajaya ax tlatehuis, niyon ax tzajtzis. Ax tlahuejchihuas tlamiyacapa ipan calle. ");
INSERT INTO nheNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Quipiyas iyolo ica tlen ax quipiyaj chicahualistli, huan quinpalehuis tlen ax quimatij tlen quichihuase. Quena, yajaya iselti tlanahuatiqui nica huan quichihuas ma tlatlani tlen xitlahuac. ");
INSERT INTO nheNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Huan ipan ya , nochi tlaltepac ehuani mochiyase para ma quinmaquixti.” ");
INSERT INTO nheNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Teipa quihualicaque campa Jesús se tlacatl tlen quipixtoya iajacayo Axcualtlacatl ipan itlacayo. Huan nopa ajacatl quichijtoya para ax hueli tlachiyas huan ax hueli camatis. Huan Jesús quichicajqui huan yajaya huelqui camati huan huelqui tlachiya. ");
INSERT INTO nheNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Huan nochi nopa miyac tlacame quisentlachilijque quema quiitaque tlen Jesús quichijqui huan moilhuiyayaj se ica seyoc: “¿Huelis yajaya iteipa ixhui Tlanahuatijquetl David tlen Toteco techilhui techtitlanilisquía?” ");
INSERT INTO nheNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Huan nopa fariseos quicajque tlen yajuanti quiijtohuayayaj huan quiijtojque: “Ni Jesús quinquixtía ajacame ica ichicahualis Axcualtlacatl tlen quinyacana nochi ajacame.” ");
INSERT INTO nheNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero Jesús quimatiyaya nochi tlen nopa tlacame moilhuiyayaj, huan huajca quinilhui: “Intla se tlanahuatijquetl ipan se tlali quinpiya itlacajhua tlen moxelohuaj huan tlajco motehuíaj ica seyoc tlajco, tlamis ichicahualis nopa tlali. Nojquiya intla se altepetl o se familia ipan ininchaj motehuise, ax huejcahuase nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ihuical elisquía intla nopa Axcualtlacatl nechmacasquía fuerza para niquinquixtilisquía tlen ya iajacahua ipan tlacame, motlajcoxelosquía huan ax huejcahuasquía itequihuejcayo ica iajacahua. ");
INSERT INTO nheNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Inquiijtojque niquinquixtía iajacahua ica itlapalehuil Axcualtlacatl , pero yajuanti tlen inmechtoquilíaj nojquiya quinquixtíaj iajacahua Axcualtlacatl tlen calactoque ipan tlacame. ¿Huelis inmoilhuíaj nopa Axcualtlacatl quinpalehuía nojquiya? ¡Ax melahuac! Hasta imotlatoquilijcahua inmechilhuise para inmocuapolojtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero ximoilhuica. Intla na niquinquixtía iajacahua Axcualtlacatl ica ichicahualis Itonal Toteco, huajca ximomacaca cuenta para ajsicoya imohuaya Toteco tlen huelis tlanahuatis ipan imoyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ximoilhuica, axaca huelis calaquis ichaj se tlacatl tlen tetixtoc queja Axcualtlacatl huan quiquixtilis tlen iaxca intla achtohui ax quitlanis huan quiilpis. Huajca quena, huelis quiquixtilis tlen quipiya queja na niquinquixtilía tlen iaxcahua Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Se tlacatl tlen ax itztoc nohuaya, itztoc nocualancaitaca. Tlen ax nechpalehuía para niquinnotzas tlacame campa na, quinsemana tlen hualahuij nohuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Nimechilhuía, Toteco hueli quintlapojpolhuía tlacame nochi tlajtlacoli tlen quichihuaj huan nochi tlajtoli tlen ax cuali quiijtohuaj, pero intla se quimahuispolos Itonal Toteco, Toteco ax quema quitlapojpolhuis. ");
INSERT INTO nheNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Huajca intla se camatis tlen hueli tlen na tlen niMocuepqui Tlacatl, Toteco huelis quitlapojpolhuis, pero intla quimahuispolos Itonal Toteco, Toteco ax quitlapojpolhuis ipan ni tonali, niyon ipan nopa tonali tlen hualas. ");
INSERT INTO nheNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Tlacame quiixmatij se cuali cuahuitl pampa temaca itlajca tlen cuali. Monequi inquiijtose cuali se cuahuitl pampa cuali itlajca o xiquijtoca ax cuali se cuahuitl pampa ax cuali itlajca. ");
INSERT INTO nheNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Imojuanti initztoque queja incohuame, huajca ¿quejatza hueli inquiijtose tlen cuali? Pampa se tlacatl camati tlen eltoc ipan iyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Se cuali tlacatl quiijtohua tlen cuali pampa cuali iyolo, pero fiero tlacame quiijtohuaj tlen fiero tlajtoli pampa fiero ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Huan nimechilhuía, quema Toteco tetlajtolsencahuas, yajaya nojquiya quintlatzacuiltis tlacame ipampa nochi fiero tlajtoli tlen quiijtojque. ");
INSERT INTO nheNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Quena, intla inquiijtojque tlen cuali ama, Toteco inmechilhuis ax inquihuicaj tlajtlacoli. Pero intla inquiijtojque tlen fiero ama, Toteco inmechtlatzacuiltis.” ");
INSERT INTO nheNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Teipa sequin fariseos huan tlamachtiani tlen itlanahuatil Moisés quitlajtlanijque Jesús: ―Tlamachtijquetl, tojuanti tijnequij xijchihua se tlanescayotl para technextilis nelía tijpiya chicahualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Huan Jesús quinnanquili: ―Imojuanti tlen initztoque ama, nelía infiero tlacame huan inquicajtejtoque Toteco. San imojuanti innechtlajtlaníaj más tlanescayotl para innechneltocase. Pero ax nimechmacas seyoc tlanescayotl. San nopa tlanescayotl tlen tiocamanalojquetl Jonás elis se tlanescayotl para imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pampa queja Jonás itztoya eyi tonali huan eyi yohuali iijtico nopa hueyi tlapiyali ipan hueyi atl, na nojquiya tlen niMocuepqui Tlacatl, niitztos ipan tlalcoyoctli para eyi tonali huan eyi yohuali. ");
INSERT INTO nheNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ipan nopa tonal quema Toteco tetlajtolsencahuas, nopa tlacame tlen huejcajquiya itztoyaj ipan altepetl Nínive moquetzase huan inmechteilhuise. Pampa nopa Nínive ehuani moyolcuepque quema Jonás quinilhuito itlajtol Toteco, pero xiquitaca, na niitztoc más hueyi que Jonás huan ax inquinequij innechneltocase. ");
INSERT INTO nheNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Nojquiya ipan nopa tonal quema Toteco tetlajtolsencahuas, nopa hueyi sihua tlanahuatijquetl tlen Sur moquetzas huan inmechteilhuis tlen initztoque ama. Pampa nopa sihua tlanahuatijquetl hualajqui huejca para quicaquis itlajtol Salomón pampa quimatqui tlahuel tlalnamiqui. Huan na niitztoc más hueyi que Salomón, pero ax inquinequij innechtlacaquilise. ");
INSERT INTO nheNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Quema se iajacayo Axcualtlacatl quisa ipan se tlacatl, nopa ajacatl nemi campa tlahuactoc huan campa hueli quitemojtinemi campa mosehuis, huan intla ax tleno quipantía, ");
INSERT INTO nheNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","huajca quiijtohua: ‘Nimocuepas ipan nopa tlacatl tlen nijcajtejqui.’ Huan mocuepas huan quipantis axaca itztoc ipan iyolo nopa tlacatl. Nepa cactoc. Eltoc queja se cali tlen tlachpantli huan tlen quipiya nochi tlacualtlalili. ");
INSERT INTO nheNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Huajca nopa ajacatl yas huan quinhualicas ihuaya sequinoc chicome ajacame tlen achi más fierojtique que ya. Huan nopa tlacatl elis más fiero teipa ica chicome ajacame que eltoya achtohuiya ica san setzi. Quej nopa nojquiya elis ica imojuanti tlen ama initztoque, teipa initztose más fierojtique que ama.” ");
INSERT INTO nheNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Quema Jesús quincamahuiyaya nopa tlacame, hualajque inana huan iicnihua huan moquetzacoj calteno. Quinequiyayaj quicamahuise. ");
INSERT INTO nheNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Huajca se tlacatl quiilhui Jesús: ―Monana huan moicnihua itztoque calteno huan quinequij mitzcamahuise. ");
INSERT INTO nheNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero Jesús quinanquili: ―¿Ajqueya nonana?, huan ¿ajqueya noicnihua? ");
INSERT INTO nheNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Huan Jesús techmanexti tiimomachtijcahua huan quiilhui nopa tlacatl: ―Xiquita, ni tlacame tlen itztoque nica niquinita queja nonana huan queja noicnihua. ");
INSERT INTO nheNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pampa tlen quichihua ipaquilis noTata tlen itztoc elhuicac, yajaya noicni huan nonana. ");
INSERT INTO nheNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Teipa ipan nopa tonal, Jesús quisqui ipan nopa cali campa itztoya huan mosehuito nechca hueyi atl. ");
INSERT INTO nheNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huan mosentilijque miyac tlacame nepa campa itztoya. Huajca Jesús tlejcoc ipan se cuacanahua tlen eltoya ateno huan mosehui, huan nopa miyac tlacame moquetztoyaj xalixco. ");
INSERT INTO nheNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Huan quinmachti miyac tlamantli ica huicalotl huan huicaltili, quinilhui: “Se tlacatl yajqui quiijtzeloto trigo. ");
INSERT INTO nheNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Huan quema quiijtzelohuayaya, sequin xinachtli huetzqui ojtipa huan hualajque totome huan quicuacoj. ");
INSERT INTO nheNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sequinoc xinachtli huetzqui teijtic campa ax oncayaya miyac tlali huan nimantzi ixhuac pampa ax huejcatla nopa tlali. ");
INSERT INTO nheNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero quisqui tonati, huan quitlati, huan nimantzi huajqui pampa ax huelqui motlatzquili inelhuayo. ");
INSERT INTO nheNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Huan sequinoc xinachtli huetzqui huitzijtic huan moscalti, pero nopa huitztli quiijiyomicti nopa toctli. ");
INSERT INTO nheNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Huan sequinoc xinachtli huetzqui ipan cuali tlali huan moscalti huan temacac itlajca. Sequin toctli tlen trigo temacac cien xinachtli huan sequinoc toctli temacac sesenta xinachtli, huan sequinoc temacac treinta xinachtli. ");
INSERT INTO nheNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Nochi imojuanti inquipiyaj imonacas, huajca xijcaquica tlen nimechilhuía.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Huan tiimomachtijcahua Jesús timonechcahuicoj huan tijtlajtlanijque: “¿Para tlen tiquincamahuía tlacame ica huicaltili tlen ohui quimachilise?” ");
INSERT INTO nheNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Huan Jesús technanquili: “Inmechcahuilijtoc imojuanti xijmachilica quejatza tlanahuatis Toteco tlen itztoc ipan elhuicac. Pero achtohui axaca quimatiyaya, huan ama yajaya noja ax quincahuilía para ne sequinoc ma quimatica. ");
INSERT INTO nheNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pampa yajaya tlen quimachilía notlajtol, Toteco quipalehuis para quimachilis más huan yajaya cuali quimatis. Pero yajaya tlen ax quichihuilía cuenta notlajtol, Toteco quiquixtilis nopa pilquentzi tlen quicactoc. ");
INSERT INTO nheNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Yeca niquincamahuía ica huicaltili para yonque ni tlacame quiitaj tlen nijchihua, elis queja ax tleno quiitaj. Huan yonque quicaquij notlajtol, elis queja ax tleno quicaquij huan ax tleno quimachilíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ica yajuanti tlami nopa tlajtoli tlen nopa tiocamanalojquetl Isaías huejcajquiya quiijcuilo, campa quiijtohua: ‘Intlacactinemij, pero ax tleno inquimachilíaj. Huan intlachixtinemij, pero ax inmomacaj cuenta tlachque inquiitaj. ");
INSERT INTO nheNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Quej ni eltoc pampa ni tlacame yoltetique. Ax quicualcaquij notlajtol. Huan ixcochtoque para ax tleno quiitase. Yeca ax quinequij quimachilise notlajtol ipan ininyolo, huan ax quinequij moyolpatlase huan nechneltoquilise, para niquinchicahuas tlen inintlajtlacolhua.’ ");
INSERT INTO nheNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Pero innomomachtijcahua, Toteco inmechtiochijtoc pampa inquimachilijtoque tlen inquiitaj huan tlen inquicaquij. ");
INSERT INTO nheNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Melahuac nimechilhuía, miyac itiocamanalojcahua Toteco huan cuajcuali tlacame huejcajquiya quinequiyayaj quiitase tlen ama inquiitaj, huan quinequiyayaj quicaquise tlen ama inquicaquij, pero ax huelque. ");
INSERT INTO nheNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Xijtlacaquilica tlachque quiijtosnequi nopa huicaltili tlen nopa tlacatl tlen quiijtzeloto xinachtli. ");
INSERT INTO nheNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Sequin tlacame itztoque queja nopa xinachtli tlen huetzqui ojtipa. Yajuanti quicaquij quejatza Toteco tlanahuatía huan ax quimachilíaj, huajca Axcualtlacatl huala huan quinquixtilía nopa quentzi tlamachtili tlen calajtoc ipan ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui temajcajya. Yajuanti quicaquij itlajtol Toteco huan nimantzi quiselíaj ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero ax temachme. Itztoque queja se xinachtli tlen ax motlatzquilía inelhuayo. Huajca quema huala tlaohuijcayotl o sequinoc quintlatzacuiltíaj pampa quineltocaj itlajtol Toteco, nimantzi quicajtehuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui huitzijtic. Yajuanti quicaquij itlajtol Toteco, pero más mocuatotoníaj ica miyac tlamantli ipan ni tlaltepactli. Quinequij quipiyase miyac tomi, yeca nopa tlamantli tlen quinequij quiijiyomictíaj itlajtol Toteco huan ax quipiyaj itlajca. Nopa tlacame ax nelnelía quinequij quitequipanose Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui ipan cuali tlali. Yajuanti quicaquij itlajtol Toteco huan quimachilíaj. Yajuanti, quena, temacaj inintlajca. Sequin nopa tlacame itztoque queja nopa xinachtli tlen temacac cien hueltas imiyaca nopa xinachtli tlen quitoctoyaj, huan sequinoc queja tlen temacac sesenta hueltas imiyaca, huan sequinoc queja tlen temacac treinta hueltas imiyaca nopa xinachtli tlen quitoctoyaj.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesús quinilhui seyoc huicaltili huan quiijto: “Quema Toteco tlen itztoc ipan elhuicac tlanahuatis ipan ni tlaltepactli, elis queja imil ni tlacatl tlen nimechilhuis. Se tlacatl quitojqui trigo tlen cuali ipan imil. ");
INSERT INTO nheNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero quema cochtoya, hualajqui icualancaitaca huan quitojqui seyoc tlamantli xinachtli tlen nesqui nojquiya queja trigo, pero ax tleno ipati itlajca. Huan icualancaitaca quitoctejqui huan yajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Teipa nopa trigo tlen cuali ixhuac huan temacac itlajca, huan nojquiya nesqui para oncayaya sequinoc toctzontli tlen ax cuali. ");
INSERT INTO nheNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Huan itequipanojcahua yajque quicamahuitoj ininteco, quiilhuijque: ‘Toteco, tijtojque cuali xinachtli ipan momil. Huajca ¿para tlen nojquiya quipiya nopa tlen ax cuali?’ ");
INSERT INTO nheNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Huan ininteco quinilhui: ‘Se nocualancaitaca quitojqui tlen ax cuali.’ “Huan quitlajtlanijque: ‘¿Tijnequi ma tijmacuica nopa tlen ax cuali?’ ");
INSERT INTO nheNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Huan ininteco quinilhui: ‘Axtle, pampa huelis inquimacuise ihuaya notrigo. ");
INSERT INTO nheNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xijcahuilica nochi ome ma moscaltica san sejco hasta ajsis pixquistli. Huan huajca niquinilhuis tlen pixcase para achtohui ma quisentilise tlen ax cuali huan quiilpise huan quitlatise. Huan teipa nopa cuali trigo quipixcase huan quitemase ipan nocuacal.’ ” ");
INSERT INTO nheNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Teipa Jesús quinilhui seyoc huicaltili, quiijto: “Quema Toteco tlen itztoc elhuicac tlanahuatis ipan tlaltepactli momiyaquilise tlacame ipan itlanahuatilis queja ni. Eltos queja se pilxinachtzi tlen mostaza tlen se tlacatl quitocato ipan imil. ");
INSERT INTO nheNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nopa xinachtli mostaza eltoc tlen más pilsiltzi tlen nochi sequinoc xinachtli, pero quema moscaltía, eli más hueyi tlen sequinoc tzontli huan mochihua se cuahuitl campa totome hueli quichihuaj inintepasol ipan imacuayo.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Huan Jesús quinilhui seyoc huicaltili: “Momiyaquilise tlacame tlen quicahuilíaj Toteco tlen itztoc elhuicac ma quinnahuatis. Elis queja momiyaquilía eyi tlayejyecoli harina quema se sihuatl quitlalilía tlasonejcayotl. Teipa mosonehua huan quichihua tlahuel miyac pantzi.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nochi ni tlamantli Jesús tlamachti ica huicaltili, pampa nochipa quema quincamahuiyaya tlacame, quinilhuiyaya huicaltili. ");
INSERT INTO nheNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Huan quichijqui ya ni para ma tlami tlen nopa tiocamanalojquetl huejcajquiya quiijcuilo campa quiijtohua: “Niquincamahuis tlacame ica huicaltili. Niquinilhuis tlamantli tlen axaca quimatiyaya hasta quema pejqui tlaltepactli.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Teipa Jesús quincajtejqui nopa miyac tlacame huan yajqui ichaj, huan tiimomachtijcahua tiquilhuijque: “Xitechilhui tlachque quiijtosnequi nopa huicaltili tlen nopa ax cuali xinachtli tlen icualancaitaca quitojqui ipan imil.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Huan Jesús technanquili: “Yajaya tlen quitojqui nopa cuali xinachtli ipan imil, eltoc na tlen niMocuepqui Tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nopa mili quinequi quiijtos ni tlaltepactli. Nopa cuali xinachtli quiijtosnequi tlacame tlen iaxcahua Toteco. Nopa xinachtli tlen ax cuali quiijtosnequi tlacame tlen iaxcahua Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Huan nopa icualancaitaca tlen quitojqui nopa xinachtli tlen ax cuali, yajaya Axcualtlacatl. Nopa pixquistli quiijtosnequi quema tlamis tlaltepactli. Huan nopa pixcani quiijtosnequi elhuicac ehuani. ");
INSERT INTO nheNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Huan quema quisentilise nopa tzontli tlen ax cuali huan quitlatise, technextilía tlen panos quema tlamis ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Quema tlamis ni tlaltepactli, na tlen niMocuepqui Tlacatl niquintitlanis noelhuicac ejcahua ma yaca campa hueli ipan notlanahuatilis, huan quinquixtise nochi tlacame tlen quichihuaj sequinoc ma tlajtlacolchihuaca huan nochi tlen quichihuaj tlen ax cuali. ");
INSERT INTO nheNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Huan noelhuicac ejcahua quinmajcahuase ipan tlitl nopa ax cuajcualme huan nepa chocase huan tlanhuehuechocase pampa tlahuel tlaijiyohuise. ");
INSERT INTO nheNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pero nochi nopa tlacame tlen itztoque xitlahuaque iixtla Toteco Totata tlahuise queja tonati nepa campa Toteco tlanahuatía. Inquipiyaj imonacas, huajca xijtlacaquilica tlen nimechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Nelcuali eltoc quema Toteco tlen itztoc elhuicac tlanahuatis. Huan quema tlacame quimachilíaj para nelía cuali nopano, quichihuase queja se tlacatl tlen quipantía miyac tomi ipan se mili. Huan quema quipanti, nimantzi sampa quitlalpacho. Teipa ica paquilistli yajqui huan quinamacac nochi tlen quipixtoya huan quicojqui nopa mili. ");
INSERT INTO nheNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Quena, nelía tlahuel ipati tlen quipantijtoc se tlen quinequi calaquis campa tlanahuatía Toteco tlen itztoc elhuicac. Nopa tlacatl itztoc queja se tlanamacaquetl tlen quitemohua nopa perla tlen más patiyo para moaxcatis. ");
INSERT INTO nheNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huan quema quipantis nopa perla tlen tlahuel miyac ipati, yohui huan quinamaca nochi tlen quipixtoc para teipa quicohuas. ");
INSERT INTO nheNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Yonque tlacame quicahuaj ma quinnahuati Toteco tlen itztoc elhuicac, noja itztose nica ica ax cuajcualme. Ihuical eli queja michtlajtlamani tlen quimajcahuaj ininmatla ipan hueyi atl, huan quinitzquíaj nochi tlamantli michime. ");
INSERT INTO nheNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Huan quema cuali temitojca ininmatla, quitlalíaj xalixco huan mosehuíaj huan nopa cuali michime pehuaj quintemaj ipan chiquihuitl huan tlen ax cuali quintepehuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quej ni nojquiya elis quema tlamis tlaltepactli. Ielhuicac ejcahua Toteco hualase huan quinquixtise nopa ax cuajcualme tlen itztoque ininhuaya tlen itztoque xitlahuaque iixtla Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huan nopa ax cuajcualme quinmajcahuase campa tlitl huan nepa chocase huan tlanhuehuechocase pampa tlahuel tlaijiyohuise.” ");
INSERT INTO nheNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Huan Jesús techtlajtlani: ―¿Inquimachilijque nochi tlen nimechilhuijtoc? Huan tiquilhuijque: ―Quena. ");
INSERT INTO nheNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Huan Jesús techilhui: ―Nochi tlamachtiani tlen itlanahuatil Moisés tlen mochihuase imomachtijcahua Toteco huan quicahuilise ma quinnahuati ipan ininyolis quichihuase queja se tetat tlen quinajcocui sequin tlamantli tlen sosoltic huan sequin tlen yancuic tlen ipati para quitequihuis teipa. Nopa tlamachtiani quiquixtise para quitequihuise ipan inintlamachtil sequin tlamachtili sosoltic tlen ipa quimatiyayaj huan sequin tlen yancuic tlen quicactoque. ");
INSERT INTO nheNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Huan quema Jesús tlanqui quinilhuía ni huicaltili, quisqui tlen nepa, ");
INSERT INTO nheNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","huan yajqui ialtepe. Nepa pejqui tlamachtía ipan israelita tiopantini campa hueli. Huan tlacame tlen quicajque itlajtol quisentlachiliyayaj huan motlajtlaniyayaj: ―¿Ajqueya quimaca Jesús ni tlalnamiquilistli para tlamachtía queja ni huan para hueli quichihua ni huejhueyi chicahualnescayotl? ");
INSERT INTO nheNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yajaya san icone se cuaxinquetl. Inana itoca María huan itlaca icnihua inintoca Jacobo, José, Simón huan Judas. ");
INSERT INTO nheNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Huan nochi isihua icnihua itztoque nica tohuaya. Huajca ¿canque momachti Jesús nochi ni tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huajca yeca nopa tlacame quicocolijque. Pero Jesús quinilhui: ―Ichampoyohua se tiocamanalojquetl huan tlacame tlen san sejco ehuani ihuaya, ax quema quiselíaj, pero sejcoyoc ehuani, quena. ");
INSERT INTO nheNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huajca Jesús ax quichijqui miyac chicahualnescayotl nepa pampa tlacame tlen ejque ipan ialtepe ax quineltocayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ipan nopa tonali Tlanahuatijquetl Herodes Ántipas tlen quinahuatiyaya estado Galilea quicajqui para Jesús quichihuayaya miyac chicahualnescayotl. ");
INSERT INTO nheNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Huan quinilhui itequipanojcahua: “Ni tlacatl Jesús, yajaya Juan tlen tecuaaltiyaya. Nijmicti, pero ama moyolcuitoc huan yeca quipiya chicahualistli para quichihuas huejhueyi chicahualnescayotl.” ");
INSERT INTO nheNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Quej ni mijqui Juan. Quipiyayaya tonali quema Tlanahuatijquetl Herodes mocuilijtoya se sihuatl tlen itoca Herodías tlen achtohui eliyaya isihua Herodes Felipe I, iicni Herodes. Pero hualajqui Juan tlen tecuaaltiyaya huan quiilhui para ax cuali itztoc ihuaya ihuejpol, huajca Tlanahuatijquetl Herodes quiitzqui Juan, quiilpi huan quitzajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Huan Herodes quinequiyaya quimictis pero quinimacasiyaya nopa miyac tlacame tlen quiitayayaj Juan para se tiocamanalojquetl. ");
INSERT INTO nheNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero quema quiaxiti ixihui Tlanahuatijquetl Herodes, ilhuichijqui huan itepotz ichpoca mijtotico iixtla ya huan itlanotzalhua. Yajaya eliyaya iichpoca Herodías tlen ama isihua. Huan Tlanahuatijquetl Herodes nelía quipacti queja mijtoti. ");
INSERT INTO nheNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Huajca Tlanahuatijquetl Herodes quitencahuili quimacasquía nopa ichpocatl tlen hueli tlamantli tlen quitlajtlanisquía. ");
INSERT INTO nheNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Huan inana nopa ichpocatl, yajaya tlen itocayaya Herodías, ya quiilhuijtoya iichpoca tlachque ma tlajtlani. Huajca nopa ichpocatl quiilhui nopa tlanahuatijquetl: ―Xinechmaca amantzi ipan se hueyi plato itzonteco Juan tlen tecuaaltiyaya. ");
INSERT INTO nheNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Huan yonque mocueso nopa tlanahuatijquetl, tlanahuati ma quimacaca pampa quitencahuilijtoya quimacas tlen quitlajtlanisquía iniixtla itlanotzalhua tlen tlacuayayaj ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Huajca tlatitlanqui ma quiquechtzontequiti Juan ipan tlatzactli. ");
INSERT INTO nheNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huan quihualicaque itzonteco ipan se hueyi plato huan quimacaque nopa ichpocatl. Huan nopa ichpocatl quimactili inana. ");
INSERT INTO nheNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Huan hualajque imomachtijcahua Juan huan quihuicaque itlacayo huan quitlalpachotoj. Teipa yajque quiyolmelahuatoj Jesús para mijqui Juan tlen tecuaaltiyaya. ");
INSERT INTO nheNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Huan quema Jesús quicajqui para ya mijqui Juan, quisqui nepa campa itztoya, huan yajqui iselti ipan cuacanahua hasta sejcoyoc campa tlatzitzica. Huan nopa miyac tlacame quicajque canque yohuiyaya. Huan quisque inialtepehua huan quitoquilijque icxinejnemiyayaj. Huan quimacaque se huelta campa nopa hueyi atl hasta campa Jesús ajsiti ipan icuacanahua. ");
INSERT INTO nheNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Huan quema Jesús temoc ipan cuacanahua, quinitac nopa miyac tlacame huan quintlasojtlac. Huan quinchicajqui nopa cocoyani tlen quinhualiquiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huan quema pejqui tlayohua, tiimomachtijcahua tiajsicoj huan tiquilhuijque: ―Tlayohuaya huan nica ax onca caltini. Huajca xiquintitlani ni tlacame ma yaca, pampa monequi quicohuatij tlen quicuase campa pilaltepetzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero Jesús techilhui: ―Ax monequi yase. Imojuanti xiquintlamacaca. ");
INSERT INTO nheNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Huan tiimomachtijcahua tiquilhuijque: ―Tojuanti san tijpiyaj nica macuili pantzi huan ome michime. ");
INSERT INTO nheNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Huan Jesús techilhui: ―Xinechhualiquilica tlen inquipiyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Huan Jesús quinilhui nochi nopa tlacame ma mosehuica sacapetlaixco. Huan quiitzqui nopa macuili pantzi huan nopa ome michime, huan ajcoitac elhuicac, huan quitlascamatqui Toteco. Teipa quitlajcotlapanqui nopa pantzi huan techmacac tojuanti tiimomachtijcahua huan tiquinmajmacaque nopa miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Huan nochi yajuanti tlacuajque huan cuali ixhuique. Huan teipa tijsentilijque nopa panpayaxtli huan michpayaxtli tlen mocajqui, huan tijtemitijque majtlactli huan ome chiquihuitl. ");
INSERT INTO nheNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Huan itztoyaj nepa nechca macuili mil san tlacame tlen tlacuajque huan ax tiquinpojque quesqui sihuame huan coneme. ");
INSERT INTO nheNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Huan nimantzi Jesús techilhui tiimomachtijcahua ma ticalaquica ipan cuacanahua huan ma titlayacanaca hasta seyoc nali. Huan yajaya mocajqui para quinnahuatijtehuas nopa miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Huan Jesús quinnahuatijtejqui huan tlejcoc iselti ipan se tepetl para momaijtos. Huan quema tlayohuaya, itztoya nepa iselti. ");
INSERT INTO nheNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Huan tocuacanahua tlen ipan tiyohuiyayaj nejnentoya hasta tlajco ipan hueyi atl quema pejqui tlaajaca chicahuac. Huan pejqui quicuatopehua tocuacanahua, huan nopa atl techhuicayaya huan ayoc huelqui tiyohuij para seyoc nali. ");
INSERT INTO nheNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Huan quema tlanestihualayaya, Jesús monechcahuico campa tojuanti nejnentihualayaya aixco. ");
INSERT INTO nheNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Huan tiimomachtijcahua tiquitaque nejnemiyaya aixco, huan timomajmatijque huan titzajtzique: ―Huala se animajtzi. Huan nelía timomajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero Jesús nimantzi technojnotzqui huan techilhui: ―Ximosemacaca. Na niJesús. Amo ximomajmatica. ");
INSERT INTO nheNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Huan Pedro quiilhui Jesús: ―NoTeco, intla nelía ta, huajca xijchihua ma ninejnemi aixco hasta campa tiitztoc. ");
INSERT INTO nheNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Huan Jesús quiilhui: ―Xihuala. Huan Pedro quisqui ipan cuacanahua huan nejnenqui aixco para ajsis campa Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero quema quicajqui nopa ajacatl tlen hualayaya chicahuac, nelía momajmati huan pejqui atzonpolihui, huan tzajtzic: ―NoTeco xinechmanahui. ");
INSERT INTO nheNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Huan nimantzi Jesús quimaitzqui huan quiilhui: ―¿Para tlen timomajmati? ¿Para tlen pilquentzi tinechneltoca? ");
INSERT INTO nheNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Huan quema Jesús ihuaya Pedro tlejcoque ipan tocuacanahua, nopa ajacatl moquetzqui. ");
INSERT INTO nheNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Huan tiimomachtijcahua tijhueyichijque huan tiquilhuijque: ―Nelía ta tiIcone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Huan teipa quema Jesús huan tiimomachtijcahua tiquixcotonque nopa hueyi atl, tiajsitoj tlali Genesaret. ");
INSERT INTO nheNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Huan nopa tlacame nepa quiixmatque Jesús huan campa hueli tlayolmelahuatoj ipan inintlal para ya ajsito. Huajca tlacame quinhualicaque campa ya nochi tlen mococohuayayaj para ma quinchicahua. ");
INSERT INTO nheNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Huan nopa cocoyani quitlajtlaniyayaj Jesús ma quincahuili quitoxomase iyoyo. Huan nochi tlen quitoxomayayaj iyoyo, mochicahuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Huan teipa ajsicoj campa Jesús sequin fariseos huan tlamachtiani tlen itlanahuatil Moisés tlen hualajtoyaj Jerusalén. Yajuanti quiilhuijque: ");
INSERT INTO nheNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Para tlen momachtijcahua tlaixpanoj? Quicajtoque nopa tlamachtilistli tlen tohuejcapan tatahua techmacaque ica quejatza monequi timomajtequise. Ax momajtequíaj miyac hueltas queja monequi quema tlacuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Huajca Jesús nojquiya quintlajtlani se tlamantli: ―Huan imojuanti ¿para tlen intlaixpanoj huan inquicajtehuaj itlanahuatil Toteco san para inquitoquilise imotlalnamiquilis? ");
INSERT INTO nheNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Toteco quiijto: ‘Xiquintlepanitaca imotatahua huan imonanahua.’ Huan nojquiya quiijto: ‘Ma miqui ajqueya quitlaijilhuía inana o itata.’ ");
INSERT INTO nheNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Pero inquinmachtíaj tlacame ma ax quintlepanitaca ininnanahua huan inintatahua. Inquinmachtíaj ma quinilhuica para ax hueli quinpalehuise ica inintechmonequi pampa ya quimacatoque Toteco nochi tlen quipiyaj. Huajca inquicahuaj ni tlanahuatili tlen Toteco temacac para inquitoquilise imotlalnamiquilis. ");
INSERT INTO nheNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ome imoxayac. Nelía melahuac tlen nopa tiocamanalojquetl Isaías quiijcuilo huejcajquiya tlen Toteco quiijtojtoya tlen imojuanti: ");
INSERT INTO nheNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ni tlacame quiijtohuaj nechtlepanitaj, pero ax neli, pampa ipan ininyolo ax nechilnamiquij. ");
INSERT INTO nheNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ax tleno quichihuaj quema nechhueyitlepanitaj, pampa tlamachtíaj san inintlajtol tlacame queja eltosquía notlajtol.’ ");
INSERT INTO nheNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Huajca Jesús quinnotzqui nopa miyac tlacame ma monechcahuica huan quinilhui: ―Xijcaquica cuali tlen nimechilhuía huan xijmachilica notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tlen se tlacatl quicua ax hueli quichihuas ax tlapajpactic iixtla Toteco, pero quema quiijtohua tlajtoli tlen ax cuali, quena, itlajtol quiijtlacohua iyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Huan tojuanti tiimomachtijcahua Jesús timonechcahuicoj huan tijtlajtlanijque: ―¿Ta tijmati nopa fariseos cualanque ica tlen tiquijto amantzi? ");
INSERT INTO nheNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Huan Jesús technanquili huan techilhui: ―Nochi tzontli tlen Toteco ax quitoctoc, yajaya quimacuis ica nochi inelhuayo pampa ax iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xiquincahuaca nopa fariseos. Itztoque queja popoyotzitzi. Huan tlacame tlen quintoquilíaj nojquiya itztoque popoyotzitzi. Huan intla se popoyotzi quiyacana seyoc popoyotzi, nochi ome huetzise tlacoyo ijtic. ");
INSERT INTO nheNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Huan Pedro quiilhui Jesús: ―Xitechixtomili nopa huicaltili. ");
INSERT INTO nheNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Huan Jesús quiilhui: ―¿Niyon imojuanti, ax inquimachilíaj? ");
INSERT INTO nheNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nochi tlen quicua se tlacatl san pano ipan iijti huan teipa quisa ipan itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero quema se quiijtohua se tlajtoli fiero, huajca quisas ipan iyolo huan nopa, quena, quichihua ax tlapajpajtic nopa tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pampa nochi tlalnamiquilistli tlen ax cuali quisa ipan ininyolo tlacame. Quema se tlacatl temictía, o momecatía, o sihuanemi, o tlaxtequi, o istlacati, o tetlaijilhuía, huajca quisa ipan iyolo. ");
INSERT INTO nheNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Huan ya nopa, quena, quichihua ax tlapajpactic. Pero intla se tlacuas huan ax momajtequi queja quiijto nopa tlanahuatili, axtle. ");
INSERT INTO nheNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Teipa Jesús quisqui nepa huan yajqui ipan nopa tlali nechca altepetini Tiro huan Sidón. ");
INSERT INTO nheNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Huan monechcahuico campa ya se sihuatl tlen ax israelita. Yajaya se tlali Canaán ejquetl. Huan quiilhui: ―Toteco, ta tiiteipa ixhui David, xinechtlasojtla. Noichpoca quipiya se iajacayo Axcualtlacatl tlen quitlaijiyohuiltía miyac. Se favor xijtlasojtla huan xijchicahuati. ");
INSERT INTO nheNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Huan Jesús ax tleno quiilhui nopa sihuatl. Huan tiimomachtijcahua tiajsicoj campa ya huan tiquilhuijque: ―Xiquilhui ne sihuatl para ma yohuiya huan ma ayoc techtzajtzilijtihuala. ");
INSERT INTO nheNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Huajca Jesús quiilhui nopa sihuatl: ―Toteco nechtitlantoc ma niquinpalehui israelitame pampa itztoque queja borregojme tlen mocuapolojtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Huan nopa sihuatl quinechcahuico huan motlancuaquetzqui iixtla huan quiilhui: ―Toteco, xinechpalehui. ");
INSERT INTO nheNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Huan Jesús quiilhui: ―Intla nimitzpalehuis achtohui huan ta ax tiisraelita, elis queja se tlen quinquixtilía inintlacualis teconehua para quinmacas chichime. ");
INSERT INTO nheNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Huan nopa sihuatl quinanquili: ―Quena, Toteco, pero chichime quicuaj nopa panpayaxtli tlen tepehui mesatzala quema tlacuaj inintecohua. ");
INSERT INTO nheNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Huajca Jesús quiilhui: ―Nane, pampa miyac timotemachijtoc ipan na, ya mochicajtoc moichpoca queja tijnequiyaya. Huan iichpoca nimantzi mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Huan Jesús quisqui nepa, huan sampa yajqui campa se tepetl nechca hueyi atl Galilea huan tlejcoc ipani huan mosehui. ");
INSERT INTO nheNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Huan quinechcahuicoj nelmiyac tlacame tlen quinhualiquiliyayaj tlen metzcuachotique, popoyotzitzi, metzcototique, nonotzitzi, huan tlen quipixque sequinoc cocolistli. Huan quintejque nochi nopa cocoyani iicxitla Jesús huan yajaya nochi quinchicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Huajca nopa tlacame quisentlachilijque quema quinitaque tlen nonotzitzi camatiyayaj huan tlacaquiyayaj. Huan tlen metzcuachotique, cuali nejnemiyayaj. Huan tlen metzcototique, nejmaxtijca ininmetz. Huan tlen popoyotzitzi, ya tlachiyayayaj. Huan yeca nochi quihueyimatque Toteco tlen tiisraelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Huan Jesús technotzqui tiimomachtijcahua huan techilhui: ―Niquintlasojtla ni miyac tlacame pampa ya mocajtoque nohuaya eyi tonali huan ax tleno quipiya para quicuase. Ax nijnequi niquintitlanis ma yaca ininchajchaj, pampa tlahuel mayanaj huan huelis tlapolose ipan ojtli. ");
INSERT INTO nheNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Huan tiimomachtijcahua tiquilhuijque: ―¿Canque tijpantise imiyaca pantzi tlen monequi para nochi ni tlacame nica ipan ni huactoc tlali pampa yajuanti nelía miyaqui? ");
INSERT INTO nheNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Huan Jesús techtlajtlani: ―¿Quesqui pantzi inquipiyaj? Huan tijnanquilijque: ―Chicome pantzi huan se quesqui pilmichtzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Huan Jesús quinilhui nopa tlacame ma mosehuica tlalchi. ");
INSERT INTO nheNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Teipa quiitzqui nopa chicome pantzi huan nopa pilmichtzitzi huan quitlascamatqui Itata. Huan quitlajcotlapanqui huan pejqui techmajmaca tiimomachtijcahua para ma tiquinmajmacaca nopa tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Huan nochi tlacuajque huan cuali ixhuique. Huan tiimomachtijcahua tijsentilijque nopa panpayaxtli tlen mocajqui huan tijtemitijque chicome chiquihuitl. ");
INSERT INTO nheNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Huan tlacuajque nahui mil tlacame, pero ax tiquinpojque nopa sihuame huan coneme. ");
INSERT INTO nheNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Huajca Jesús quinnahuatijtejqui nopa miyac tlacame, huan tlejcoc ipan nopa cuacanahua ipan hueyi atl huan yajqui tlali Magdala. ");
INSERT INTO nheNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Huan hualajque nopa fariseos huan nopa saduceos para quimasiltise Jesús ica inintlajtol. Huan quitlajtlanijque Jesús ma quichihua se tlanescayotl tlen elhuicac para quinnextilis intla quipiya ichicahualis Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero Jesús quinilhui: “Quema temo tonati inquiijtohuaj para mostla cuali tonas pampa tlachichiltic nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Huan intla ica ijnaloc nesi hasta yayahuic tlamixtentoc, inquiijtohuaj para ama huetzis atl chicahuac. ¡Ome imoxayac! Inquimatij tlachque quiijtosnequi nopa mixtli tlen elhuicac, pero ax inquimachilíaj tlachque quiijtosnequi nochi tlen inquiitztoque pano ipan ni tonali. ");
INSERT INTO nheNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Imojuanti tlen ama initztoque nelía infiero tlacame huan inquicajtejtoque Toteco. San imojuanti innechtlajtlaníaj ma nijchihua se tlanescayotl para innechneltocase. Pero ax nimechmacas seyoc tlanescayotl. San nopa tlen panoc ica Jonás eltoc queja se tlanescayotl para imojuanti.” Huan Jesús quincajtejqui huan yajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Huan teipa quema Jesús huan tiimomachtijcahua tiajsitoyajya nepa seyoc nali hueyi atl, tiimomachtijcahua timomacaque cuenta para tiquilcajtoyaj tijhualicase pantzi para tijcuase. ");
INSERT INTO nheNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Huan Jesús techilhui: ―Ximotlachilica para amo xijselica inintlasonejcayo fariseos huan saduceos. ");
INSERT INTO nheNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Huan tiimomachtijcahua timoilhuijque se ica seyoc: ―Techilhuía ya ni pampa tiquilcajque tijhualicase pantzi para tijcuase. ");
INSERT INTO nheNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Huan Jesús quimatiyaya tlachque tiquijtohuayayaj huan huajca techilhui: ―¿Para tlen inmocuesohuaj pampa ax inquihualicaque pantzi? Imojuanti san pilquentzi innechneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Noja aya inquimachilíaj nochicahualis? ¿Ax inquiilnamiquij tlen panoc quema niquintlamacac macuili mil tlacame ica macuili pantzi? ¿Ax inquiilnamiquij quesqui chiquihuitl tlacualistli mocajqui quema ya tlacuajtoyaj? ");
INSERT INTO nheNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ax inquiilnamiquij quesqui chiquihuitl tlacualistli mocajqui quema sampa niquintlamacac nahui mil tlacame ica chicome pantzi? ");
INSERT INTO nheNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Quejatza huelis inmoilhuíaj para nimocuesohua pampa inquiilcajque pantzi? Nimechilhuiyaya ximotlachilica para amo xijselica inintlasonejcayo fariseos huan saduceos. ");
INSERT INTO nheNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Huajca tiimomachtijcahua tijmachilijque para Jesús ax techcamahuiyaya tlen tlasonejcayotl para pantzi. ¡Axtle! Yajaya techilhuiyaya ma timotlachilica para ax tijselise inintlamachtil nopa fariseos huan nopa saduceos. ");
INSERT INTO nheNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Teipa Jesús ajsito nechca altepetl Cesarea de Filipo. Huan yajaya techtlajtlani tiimomachtijcahua: ―Quema tlacame camatij tlen na tlen niMocuepqui Tlacatl, ¿ajqueya quiijtohuaj para na? ");
INSERT INTO nheNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Huan tiquilhuijque: ―Sequin quiijtohuaj ta tiJuan tlen tecuaaltiyaya. Sequin quiijtohuaj ta tiElías. Huan sequinoc quiijtohuaj ta tiJeremías o seyoc itiocamanalojca Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Huan Jesús techtlajtlani: ―¿Huan imojuanti? ¿Ajqueya inquiijtohuaj para na? ");
INSERT INTO nheNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Huan Simón Pedro quinanquili: ―Ta tiCristo tlen Toteco techilhui techtitlanilisquía. Ta tiIcone Toteco Dios, yajaya tlen nelía itztoc. ");
INSERT INTO nheNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Huan Jesús quiilhui: ―Toteco mitztiochijtoc Pedro, tiicone Jonás, pampa ax elqui se tlacatl tlen mitznextili ajqueya na, pero elqui noTata tlen itztoc ipan elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Huan nojquiya nimitzilhuía ta, tiPedro, tlen quiijtosnequi se tipiltetzi. Huan ipan ni hueyi tepatlactli nijquetzas notiopa. Huan nochi chicahualistli ipan mictla ax quema huelis quitlanis. ");
INSERT INTO nheNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nimitzmacas tlanahuatili para tijtlapos campa tlanahuatía Toteco tlen itztoc elhuicac, pampa tiquinpohuilis tlacame quejatza huelis calaquise nepa. Huan nochi tlen tiquilpis nica ipan tlaltepactli, moilpis nepa ipan elhuicac. Huan tlen tijtojtomas ipan tlaltepactli, nojquiya motojtomas nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Huan Jesús chicahuac techilhui tiimomachtijcahua ma axaca tiquilhuica para yajaya elqui nopa Cristo tlen Toteco techtitlanilijtoya. ");
INSERT INTO nheNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Huan elqui ipan nopa tlalochtli quema Jesús pejqui techilhuía tiimomachtijcahua para monequi yas Jerusalén. Huan nepa quitlaijiyohuiltisquíaj miyac nopa huehue tlacame tlen israelitame, huan nopa tlayacanca totajtzitzi huan tlamachtiani tlen itlanahuatil Moisés. Quiijto para quimictise huan teipa ica eyi tonali, moyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Huan Pedro quihuicac iyoca huan quitlacahualti, quiilhui: ―Ma Toteco Dios mitzpalehui, noTeco, para ni tlaijiyohuilistli ma ax mitzajsi. ");
INSERT INTO nheNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero Jesús mocueptiquisqui huan quiilhui Pedro: ―Xinechtlalcahui, Axcualtlacatl. Tijnequi tinechtzacuilis para ma ax nijchihua ipaquilis Toteco. Ax timoilhuía tlen Toteco Dios moilhuía, san timoilhuía queja tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Huajca Jesús techilhui tiimomachtijcahua: ―Intla se tlacatl quinequi nechtoquilis, ma quitlahuelcahua tlen yajaya quinequi. Huan ma quitlalanas icuamapel huan nechtoquilis mocualtlalijtos para miquis nopampa na. ");
INSERT INTO nheNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pampa tlen quinequi momanahuis para ax miquis ipampa nechixmati, quipolos ialma. Pero tlen nechtoquilis yonque monequi miquis nopampa na, quipantis yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ax quipalehuis se tlacatl yonque moaxcatisquía nochi ni tlaltepactli intla quipolos ialma. Pampa ax onca tleno tlen se huelis tlaxtlahuas para quimanahuis ialma quema quipolojtos nepa mictla. ");
INSERT INTO nheNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pampa na tlen niMocuepqui Tlacatl nihualasoc ica itlatlanex noTata Dios. Huan noelhuicac ejcahua hualase nohuaya para niquintlaxtlahuis nochi tlacame queja quinamiqui ica tlen quichijtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nelía nimechilhuía, sequin imojuanti tlen inmoquetzaj nica, ax inmiquise hasta inquiitase quejatza na tlen niMocuepqui Tlacatl nimonextis quema nihualas para nitlanahuatis. ");
INSERT INTO nheNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Huan quema panotoya chicuase tonali, Jesús quihuicac Pedro huan Jacobo ihuaya iicni, Juan, huan tlejcoque ininseltitzi ipan se huejcapantic tepetl. ");
INSERT INTO nheNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Huan nepa Jesús quipatlac itlachiyalis iniixtla. Huan ixayac cahuanqui queja tonati huan iyoyo mocuepqui chipahuac queja tlahuili. ");
INSERT INTO nheNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Huan nimantzi monextijque Moisés huan Elías huan pejque quicamahuíaj Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Huajca Pedro quiilhui Jesús: ―NoTeco, nelía cuali para tiitztoque nica. Intla tijnequi, tijchihuase eyi pilxajcaltzitzi. Se para ta, seyoc para Moisés huan seyoc para Elías. ");
INSERT INTO nheNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Huan quema Pedro noja quicamahuiyaya Jesús, temoc se mixtli tlen tlahuiyaya huan quintzajqui. Huan camatqui Toteco Dios ipan nopa mixtli huan quiijto: “Ya ni Nocone tlen niquicnelía. Nijpiya miyac paquilistli ica tlen quichihua. Xijtlacaquilica tlen yajaya quiijtohua.” ");
INSERT INTO nheNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Huan quema imomachtijcahua quicajque ni tlajtoli, moixtlapachojque huan nelía momajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Huan Jesús quinnechcahuico huan quinpanitzqui sesen yajuanti huan quinilhui: ―Ximoquetzaca huan amo ximajmahuica. ");
INSERT INTO nheNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Huan quema yajuanti ajcotlachixque, axaca más quiitaque, san Jesús iselti. ");
INSERT INTO nheNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Huan quema temoyayaj tlen tepetl, Jesús quinnahuati: ―Axaca xiquilhuica tlen inquiitztoque hasta na tlen niMocuepqui Tlacatl niquincajtehuas tlen mictoque huan nimoyolcuis sampa. ");
INSERT INTO nheNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Huan imomachtijcahua Jesús quitlajtlanijque: ―¿Para tlen nopa tlamachtiani tlen itlanahuatil Moisés quiijtohuaj para achtohuiya monequi hualas Elías huan teipa hualas nopa Cristo? ");
INSERT INTO nheNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Huan Jesús quinilhui: ―Nelía Elías huala achtohui para tlacualtlaliqui nochi tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero nimechilhuía, Elías ya hualajqui huan tlacame ax quiixmatque huan san tlen hueli quichihuilijque. Huan ihuical elis ica na tlen niMocuepqui Tlacatl nojquiya nitlaijiyohuis ininmaco. ");
INSERT INTO nheNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Huajca imomachtijcahua quimachilijque para Jesús quincamahuiyaya tlen Juan tlen tecuaaltiyaya para yajaya eltoya Elías. ");
INSERT INTO nheNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Huan yajuanti sampa ajsicoj campa itztoyaj nopa miyac tlacame. Huan hualajqui se tlacatl, huan motlancuaquetzqui iixtla Jesús huan quiilhui: ");
INSERT INTO nheNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Tate, xijtlasojtla nocone huan xijchicahua pampa tlapolohua huan tlaijiyohuía miyac. Quemantzi huetzi tlixijco huan quemantzi huetzi atitla. ");
INSERT INTO nheNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niquinhualiquili momomachtijcahua pero ax huelque quichicahuaj. ");
INSERT INTO nheNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Huan Jesús quinilhui nopa tlacame tlen moquetztoyaj nopano: ―¡Ay intlacame tlen ama initztoque, ax innechneltocaj! ¿Tlachque nijchihuas imohuaya? Ax xitlahuac imotlalnamiquilis. ¿Quesqui tonali monequi nimocahuas imohuaya? ¿Quesqui tonali monequi nimechijiyohuis? Huan Jesús quiilhui nopa tlacatl: ―Xinechhualiquili mocone. ");
INSERT INTO nheNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Huan Jesús quinahuati ma quisa iajacayo Axcualtlacatl tlen calactoya ipan itlacayo huan yajaya quisqui. Huan nopa oquichpil nimantzi mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Huajca tiimomachtijcahua iyoca tijcamahuitoj Jesús huan tijtlajtlanijque: ―¿Para tlen ax tihuelque tijchihuaj ma quisa nopa ajacatl? ");
INSERT INTO nheNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Huan Jesús techilhui: ―Ax inhuelque pampa noja pilquentzi innechneltocaj. Nelía nimechilhuía, intla imotlaneltoquilis moscaltisquía queja quichihua se ipilxinacho mostaza, huelis inquinahuatise ni tepetl: ‘Ximoijcueni huan xiya nepa’ huan nopa tepetl moijcuenis huan mochihuas imotlajtol. Intla cuali intlaneltocase, huelis inquichihuase nochi. ");
INSERT INTO nheNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ni tlamantli ajacame ax quisase intla ax timosahuase huan timomaijtose ipan Toteco para ma quisaca. ");
INSERT INTO nheNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Huan quema tiajsitoyaj ipan tlali Galilea, Jesús techilhui tiimomachtijcahua: ―Nechtemactilise na tlen niMocuepqui Tlacatl ininmaco tlacame, ");
INSERT INTO nheNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","huan nechmictise, pero ica eyi tonali nimoyolcuis. Huan tiimomachtijcahua nelía timocuesojque. ");
INSERT INTO nheNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Teipa Jesús huan tiimomachtijcahua tiajsicoj altepetl Capernaum. Huan hualajque campa Pedro itztoya nopa tlacame tlen quisentiliyayaj nopa tomi tlen tlainamaj para tiopamitl huan quitlajtlanijque: ―¿Motlamachtijca tlaxtlahua nopa tomi tlen tlainamaj para tiopamitl o axtle? ");
INSERT INTO nheNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Huan Pedro quinnanquili: ―Quena, tlaxtlahua. Teipa Pedro yajqui quiitato Jesús campa itztoya ipan se cali. Huan quema Pedro noja aya tleno quiilhuiyaya, Jesús quitlajtlani: ―¿Quejatza tiquita, Pedro? Quema tlanahuatiani ipan ni tlaltepactli tlainamaj impuesto, ¿ajqueya quininamaj? ¿Quininamaj ininconehua o sejcoyoc ehuani? ");
INSERT INTO nheNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Huan Pedro quinanquili: ―Quininamaj sejcoyoc ehuani. Huan Jesús quiilhui: ―Huajca ax monequi para tojuanti tlen tiiconehua nopa tlanahuatijquetl ma titlaxtlahuaca. ");
INSERT INTO nheNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero para ax titecualancamacase, nojquiya titlaxtlahuase. Xiya nepa campa hueyi atl huan xijmajcahua se tepos huijcoli para michime. Xijtlalana nopa michi tlen achtohui tijmasiltis, huan ipan icamac tijpantis se tomi tlen quiaxilis para titlaxtlahuase tlen tlainamaj para tiopamitl. Huajca xijhuica huan xitlaxtlahuati para na huan para ta. ");
INSERT INTO nheNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ipan nopa tonal tiimomachtijcahua tijtlajtlanijque Jesús: ―¿Ajqueya itztos más hueyi campa tlanahuatis Toteco tlen itztoc elhuicac? ");
INSERT INTO nheNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Huajca Jesús quinotzqui se conetl huan quiquetzqui tlatlajco tojuanti, ");
INSERT INTO nheNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","huan techilhui: ―Nelía nimechilhuía intla ax inmoyolpatlase huan inmochihuase queja coneme, ax huelis incalaquise campa Toteco tlen itztoc elhuicac tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pampa nepa campa Toteco tlen itztoc elhuicac tlanahuatía elis más hueyi ajqueya moicnonequis queja se conetl. ");
INSERT INTO nheNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Huan ajqueya quiselía se conetl ipan notoca , nechselía nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Huan Toteco tlahuel quitlatzacuiltis tlen quichihuas se conetl ma ayoc nechneltoca. Más cuali elisquía quema aya quichihua nopa hueyi tlajtlacoli, intla moilpilisquía se metlatl ipan iquechcuayo huan ma moisahuiti ipan hueyi atl. ");
INSERT INTO nheNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Nelía teicneltique tlacame pampa onca miyac tlamantli tlen quinyoltilana ma tlajtlacolchihuaca huan tlacame tlajtlacolchihuaj mojmostla. Pero teicneltic se tlacatl tlen quichihuilía seyoc ma tlajtlacolchihua pampa Toteco quitlatzacuiltis. ");
INSERT INTO nheNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Intla moma o moicxi mitzchihuilía xitlajtlacolchihua, huajca xijtzontequi huan xijmajcahua. Pampa más cuali para ticalaquis nepa campa onca yolistli ica san setzi moma o san setzi moicxi, huan ax mitzmajcahuase nepa mictla ica motlacayo yamajtic. Pampa nepa mictla ax quema sehuis nopa tlitl. ");
INSERT INTO nheNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Huan intla moixtiyol quinequi quitlachilis tlajtlacoli, más cuali xijquixti huan xijmajcahua. Pampa achi más cuali ticalaquis nepa campa onca yolistli ica san setzi moixtiyol huan ax mitzmajcahuase ica nochi ome moixtiyol ipan tlitl nepa mictla. ");
INSERT INTO nheNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Xijpiyaca cuidado para amo xiquiniyocacahuaca ni coneme pampa inielhuicac ejcahua tlen quinmocuitlahuíaj, mojmostla quiixtlachilíaj noTata nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Pampa na tlen niMocuepqui Tlacatl nihualajtoc para niquinmaquixtis tlen mocuapolojtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Quejatza inquiitaj? ¿Tlachque quichihuasquía se tlacatl intla quinpixtoya cien borregojme huan se mocuapolosquía? ¿Ax inmoilhuíaj para quincahuasquía nopa noventa y nueve cuali tzactoque huan yas ipan tepetl quitemoti nopa tlen mocuapolojtoc? ");
INSERT INTO nheNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Huan intla quipantis, paquis más ica nopa borrego tlen mocuapolojtoya que ica nopa noventa y nueve tlen ax mocuapolojtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nojquiya san se ica imoTata tlen itztoc nepa elhuicac. Yajaya ax quinequi ma mocuapolo niyon se tlen ni coneme. ");
INSERT INTO nheNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Intla se moicni ipan Toteco mitzixpano, xiya huan iyoca xiquilhui tlen mitzchihuilijtoc para san ta huan ya inquimatise. Intla mitzcaquis huajca sampa elis queja moicni. ");
INSERT INTO nheNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero intla ax mitzchihuilis cuenta, xiquinhuica se o ome mohuaya queja testigos para tijcamahuis para ma quimachili tlen mitzchihuilijtoc. Pampa ijcuilijtoc para temachtli quema ome o eyi testigos tlayolmelahuaj san se tlajtoli para quejatza panoc se tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Huan intla moicni ax quinchihuilía cuenta nopa tlacame tlen tiquinhuicac mohuaya, huajca xiquinpohuili nochi nopa tiopamitl tlen tlaneltocani tlen moicni mitzchihuilijtoc. Huan intla nopa tlaneltocani quiitaj para xitlahuac tlen tiquijtohua pero nopa moicni ax quintlacaquilis, huajca xiquitaca queja se tlen ax quiixmati Toteco huan se tlen fiero iyolis queja se tlen tlainama impuesto. ");
INSERT INTO nheNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Pampa nelía nimechilhuía, nochi tlen inquiilpise nica ipan tlaltepactli, moilpis nepa ipan elhuicac. Huan tlen inquitojtomase ipan tlaltepactli nojquiya motojtomas nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Huan nojquiya nimechilhuía ya ni, intla ome tlen imojuanti ipan tlaltepactli inmocahuaj ica san se tlajtoli para inquitlajtlanise Toteco se tlamantli, huajca yajaya noTata tlen itztoc nepa elhuicac inmechmacas. ");
INSERT INTO nheNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pampa campa mosentilíaj tlacame ipan notoca , yonque san mosentilíaj ome o eyi, na niitztoc ininhuaya.” ");
INSERT INTO nheNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Huajca Pedro monechcahuico campa Jesús huan quitlajtlani: ―NoTeco, ¿hasta quesqui hueltas monequi nijtlapojpolhuis noicni tlen ajachica nechchihuilía tlen ax cuali? ¿Monequi nijtlapojpolhuis hasta chicome huelta? ");
INSERT INTO nheNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Huan Jesús quiilhui: ―Amo san xijtlapojpolhui chicompa huelta. Monequi tijtlapojpolhuijtinemis hasta chicompa setenta hueltas. ");
INSERT INTO nheNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Quena, monequi tijtlapojpolhuijtinemis pampa Toteco tlen itztoc elhuicac huan tlen tlanahuatis eltoc queja ni tlanahuatijquetl ipan ni huicaltili. Se tonal se tlanahuatijquetl quinequiyaya quincuentajchihuas itlatequipanojcahua tlen quitlahuiquiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Huan quema pejqui, quihualiquilijque campa ya se itlatequipanojca tlen quitlahuiquiliyaya majtlactli mil bolsas tlen tomi. ");
INSERT INTO nheNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Huan nopa tlacatl ax tleno quipiyayaya para quicuepilis. Huajca nopa tlanahuatijquetl tlanahuati ma quinamacaca nopa tlacatl ihuaya isihua huan iconehua huan nochi tlen iaxca, huan ica nopa tomi tlaxtlahuasquía se quentzi tlen quitlahuiquiliyaya. ");
INSERT INTO nheNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Huan quema itlatequipanojca quicajqui, moixtlapacho iixtla nopa tlanahuatijquetl huan ica nochi iyolo quitlajtlani: ‘Xinechchiya huan nimitztlaxtlahuis nochi tlen nimitztlahuiquilía.’ ");
INSERT INTO nheNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Huan nopa tlanahuatijquetl quitlasojtlac huan quitlapojpolhui nochi itlahuiquilis para ax tleno monequi tlaxtlahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Teipa nopa tlatequipanojquetl yajqui huan quipantito se tlen tlatequipanohuayaya ihuaya huan quitlahuiquiliyaya pilquentzi tomi. Huan quiquechpatzcato hasta ayoc hueliyaya mijmijyotis huan quiilhui: ‘Xinechtlaxtlahui amantzi.’ ");
INSERT INTO nheNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Huan ihuampo motlancuaquetzqui iixtla huan ica nochi iyolo quiilhui: ‘Xinechchiya huan nimitztlaxtlahuis nochi.’ ");
INSERT INTO nheNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Pero nopa tlatequipanojquetl ax quinejqui quichiyas. Huajca quihuicac ihuampo ipan tlatzactli huan quitzajqui hasta nochi quitlamitlaxtlahuisquía. ");
INSERT INTO nheNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Huan sequinoc itlatequipanojcahua nopa tlanahuatijquetl quiitaque nopa tlacatl tlen ininteco quitlapojpolhuilijtoya itlahuiquilis huan quiitaque tlen quichihuilijtoya ihuampo tlen pilquentzi quitlahuiquiliyaya. Huajca tlahuel mocuesojque huan yajque quiilhuitoj nopa tlanahuatijquetl tlen panoc. ");
INSERT INTO nheNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Huajca nopa tlanahuatijquetl quinotzqui nopa itlatequipanojca huan quiilhui: ‘Ta tifiero tlacatl. Na nijtlapojpolhui motlahuiquilis huan nochi tlen tinechtlahuiquiliyaya pampa ica nochi moyolo tinechtlajtlani. ");
INSERT INTO nheNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Huajca ¿para tlen ax tijtlasojtlac mohuampo tlen nechtequipanohua mohuaya queja na nimitztlasojtlac?’ ");
INSERT INTO nheNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huajca iteco cualanqui huan quinmactili ininmaco tlacame tlen quitlaijiyohuiltisquíaj hasta tlaxtlahuasquía nochi tlen tlahuicayaya achtohuiya. ");
INSERT INTO nheNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Huan nojquiya queja nopa quichihuas noTata tlen itztoc nepa elhuicac intla imojuanti ica nochi imoyolo ax inquintlapojpolhuise sesen imoicni tlen inmechchihuilíaj tlen ax cuali.” ");
INSERT INTO nheNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Huan quema Jesús tlanqui quinilhuía nopa tlacame ni tlajtoli, quisqui estado Galilea huan yajqui estado Judea nechca nopa nali atentli Jordán campa temo tonati. ");
INSERT INTO nheNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Huan quitoquilijque miyac tlacame huan quinchicajqui nochi tlen mococohuayayaj nopano. ");
INSERT INTO nheNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Huan hualajque sequin fariseos campa Jesús para quicajcayahuase para ma quiijtos tlen ax cuali. Huan yajuanti quitlajtlanijque: ―¿Nopa tlanahuatili quicahuilía se tlacatl ma quicahuas isihua ica tlen hueli tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Huan Jesús quinnanquili: ―¿Ax inquipojtoque tlen ijcuilijtoc ipan Itlajtol Toteco campa achtohui Toteco tlasencajqui? Quiijtohua: ‘Yajaya quichijqui tlacatl huan sihuatl’ para ma itztoca san sejco. ");
INSERT INTO nheNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Huan nojquiya quiijtohua: ‘Yeca se tlacatl quicahuas itata huan inana huan mosejcotilis ihuaya isihua huan nopa ome itztose queja san se inintlacayo.’ ");
INSERT INTO nheNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Huajca ayoc itztose queja ome. Ama nopa ome mochihuase queja san se inintlacayo. Toteco quinsejcotilía se tlacatl ihuaya isihua; huajca ma axaca quiniyocatlalis. ");
INSERT INTO nheNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Huan nopa fariseos quitlajtlanijque: ―Huajca ¿para tlen Moisés huejcajquiya quiijto se tlacatl ma quimaca isihua se amatlajcuiloli campa quiijtos para nopa sihuatl ayoc iaxca huan queja nopa quicahuas? ");
INSERT INTO nheNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Huan Jesús quinnanquili: ―Pampa inyoltetique, Moisés inmechcahuili intlacame para inquicahuase imosihua ica se amatl, pero Toteco ax queja nopa quisencajqui ma eli ipan ipejya. ");
INSERT INTO nheNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Huan nimechyolmelahua intla se tlacatl quipiya isihua tlen ax quiixpanotoc ica seyoc tlacatl huan nopa tlacatl quicahuas huan mosejcotilis ica seyoc, huajca nopa tlacatl momecatía. Huan intla se tlacatl mosejcotilis ica nopa sihuatl tlen ihuehue quicajtejtoc, huajca nopa tlacatl nojquiya momecatía. ");
INSERT INTO nheNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Huan tojuanti tiimomachtijcahua tiquilhuijque: ―Intla queja nopa monequi para se tlacatl mocahuas ihuaya isihua, huajca más cuali ma ax mosihuajti se tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Huan Jesús quinilhui: ―Ax nochi hueli quipiyaj nopa yajatili para mocahuase ininseltitzi. San hueli quichihuaj tlen Toteco quinmacatoc nopa chicahualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sequin tlacame tlen quema tlacatque quimatque para ax quema huelis quipiyase ininsihua. Sequinoc ax huelis quipiyase ininsihua pampa sequinoc quincaparojtoque. Huan itztoque sequinoc tlacame tlen ax quipiyaj ininsihua pampa ipan ininyolo quimatij queja nopa achi más huelis tequitise ipan itlanahuatilis Toteco tlen itztoc elhuicac. Huajca intla se tlacatl quimachilía para huelis mocahuas iselti, ma mocahua iselti. ");
INSERT INTO nheNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Teipa tlacame quinhualicaque ininconehua campa Jesús para ma quitlali ima huan ma momaijtos. Huan tiimomachtijcahua tiquinajhuaque. ");
INSERT INTO nheNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero Jesús techilhui: ―Xiquincahuaca nopa coneme ma hualaca campa na huan amo xiquintzacuilica. Pampa Toteco tlen itztoc nepa elhuicac quinnahuatis tlacame tlen nechselíaj queja ni coneme. ");
INSERT INTO nheNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Huajca Jesús quitlali ima ipan nopa coneme huan quintiochijqui. Teipa quisqui huan yajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huan hualajqui se tlacatl campa Jesús huan quitlajtlani: ―Cuali titlamachtijquetl, ¿tlachque tlen cuali monequi nijchihuas para Toteco nechmacas yolistli yancuic para nochipa? ");
INSERT INTO nheNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Huan Jesús quiilhui: ―¿Para tlen tinechnotzqui nicuali? ¿Ta tijmachilía para axaca cuali, san Dios? Intla tijnequi Toteco ma mitzmaca yolistli yancuic para nochipa, huajca xiquinneltoquili itlanahuatil. ");
INSERT INTO nheNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Huan nopa tlacatl quitlajtlani: ―¿Tlachque itlanahuatilhua Toteco niquintoquilis? Huan Jesús quiilhui: ―Amo xitemicti, amo ximomecati, amo xitlaxtequi, amo xijtestigojquetza tlen ax melahuac tlen seyoc tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Xiquintlepanita motata huan monana. Huan xiquinicneli sequinoc queja timoicnelía. ");
INSERT INTO nheNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Huan nopa telpoca tlacatl quiilhui: ―Nochi ya ni nijtoquilijtihualajtoc hasta quema niconetzi nieltoya. ¿Tlachque polihui para nijchihuas? ");
INSERT INTO nheNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Huan Jesús quiilhui: ―Intla tijnequi tijchihuas senquistoc tlen Toteco quinequi, xiya huan xijnamacati nochi tlen tijpiya huan xiquinmaca nopa tomi tlen teicneltzitzi. Quej nopa tijpiyas tlen ipati para moaxca nepa elhuicac. Teipa xihuala huan xinechtoquili. ");
INSERT INTO nheNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Pero quema nopa telpoca tlacatl quicajqui tlen Jesús quiilhui, mocueso huan quistejqui pampa nelía tlapijpixtoya. ");
INSERT INTO nheNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Huan Jesús techilhui tiimomachtijcahua: ―Nelía nimechilhuía, nelía ohui para tominpiyani calaquise campa tlanahuatis Toteco tlen itztoc elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sampa nimechilhuía, huelis ax ohui para se hueyi tlapiyali queja se camello panos ipan iixtiyol se huitzmalotl, pero ohui para calaquis se tlacatl tlen tominpiya campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Quema tiimomachtijcahua tijcajque ni tlajtoli, tlahuel timosentlachilijque huan tiquilhuijque: ―Huajca ¿ajqueya huelis momaquixtis tlen itlajtlacolhua? ");
INSERT INTO nheNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Huan Jesús techtlachili huan techilhui: ―Tlacame ax huelis momaquixtise ininseltitzitzi, pero Toteco huelis. Yajaya nochi hueli quichihua. ");
INSERT INTO nheNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Huajca Pedro quiilhui Jesús: ―Xiquita, tojuanti tijcajtejtoque nochi tlen tijpixtoyaj para timitztoquilise. Huajca ¿tlachque tijpiyase? ");
INSERT INTO nheNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Huan Jesús techilhui: ―Nelía nimechilhuía quema ajsis nopa tonal quema Toteco quiyancuilis nochi tlaltepactli huan quema na tlen niMocuepqui Tlacatl nimosehuis ipan nosiya tlen yejyectzi para nitlanahuatis ica nochi nohueyitilis, imojuanti tlen innechtoquilijtoque inmosehuise ipan majtlactli huan ome siyas tlen yejyectzitzi. Huan inquintlajtolsencahuase nopa majtlactli huan ome huejhueyi familias tlen tlacame tlen hualajque tlen itelpocahua Israel. ");
INSERT INTO nheNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Huan nochi tlen quicajtejtoc ichaj, o itlaca icnihua, o isihua icnihua, o inana, o itata, o iconehua, o imil, o isihua pampa nechneltoquilíaj , quipantis cien huelta tlen quicajtejtoc huan nojquiya Toteco quimacas yolistli tlen yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero miyac tlacame tlen nochi quintlepanitaj ama, ayoc aca quintlepanitas ipan nopa tonal. Huan miyac tlen axaca quintlepanita ama, nochi quitlepanitase ipan nopa tonal. ");
INSERT INTO nheNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Quema Toteco tlen itztoc elhuicac tlanahuatis, yajaya tetlaxtlahuis. Yajaya itztoc queja ni tetat tlen quipixtoya miyac tlali huan se tonal quisqui ijnaltzi huan quintemoto tlatequipanohuani ma quitequipanoca ipan ixocomecamil. ");
INSERT INTO nheNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Huan quinilhui quintlaxtlahuisquía tlen ipati se tonal tequitl. Huajca yajuanti quitequipanotoj ipan ixocomecamil. ");
INSERT INTO nheNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Huan nechca las nueve ica ijnaloc, nopa tecojtli yajqui tianquis huan quinitac sequinoc tlacame tlen ax tequitiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Huajca quinilhui: ‘¿Ax inquinequij innechpalehuise ama ipan noxocomecamil? Xihualaca huan nimechtlaxtlahuis tlen quinamiqui.’ Huajca yajuanti nojquiya yajque. ");
INSERT INTO nheNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Huan nopa tlacatl sampa yajqui tianquis tlajco tona huan sampa quinpanti sequinoc para ma quipalehuica. Huan sampa yajqui tianquis nechca las tres huan quinpanti sequinoc, huan nojquiya quintitlanqui ma quitequipanotij imila. ");
INSERT INTO nheNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Quema se quentzi polihuiyaya para las cinco, sampa yajqui huan quinpanti sequinoc tlen ax tequitiyayaj huan quinilhui: ‘¿Para tlen san inmoquetztoque nica huan san inquipolohuaj tonali?’ ");
INSERT INTO nheNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Huan quiilhuijque: ‘Pampa axaca techtlanehui ma tijpalehuica.’ “Huajca quinilhui: ‘Xinechpalehuiquij nojquiya ipan noxocomecamil, huan nimechtlaxtlahuis queja quinamiqui.’ ");
INSERT INTO nheNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Huan ica tlayohua, nopa tlacatl quinotzqui itlayacanca huan quiilhui: ‘Xiquinnotza nopa tlatequipanohuani huan xiquintlaxtlahui. Achtohui xiquintlaxtlahui tlen más tiotlac ajsicoj, huan hasta teipa xiquintlaxtlahui tlen hualajque ijnaltzi.’ ");
INSERT INTO nheNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Huan quema yajuanti tlen tequiticoj a las cinco monechcahuicoj, quintlaxtlahui queja ipati senquistoc se tonal tequitl. ");
INSERT INTO nheNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Huan queja nopa quintlaxtlahuijtiyajqui hasta ajsic campa nopa tlen ajsicoj ijnaltzi, huan nopa tlacame moilhuiyayaj para ininteco quintlaxtlahuisquía quentzi más, pero nojquiya quinmacac tlen se tonal tlaxtlahuili. ");
INSERT INTO nheNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Huan quema ya quiselijtoyaj inintomi, mocualanijque ihuaya ininteco. ");
INSERT INTO nheNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Huan quiilhuijque: ‘Ni tlacame tlen teipa hualajque san tequitique se hora huan quitlanque ihuical queja tojuanti tlen titequitique chicahuac se tonal huan quema chicahuac tonayaya.’ ");
INSERT INTO nheNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Pero ininteco quinilhui: ‘Nohuampoyohua, ax nimechcajcayajtoc. Nimechilhui nimechtlaxtlahuisquía tlen ipati se tonal tequitl huan queja nopa nimechtlaxtlahui. ");
INSERT INTO nheNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Xijcuica ni imotomi huan ya xiyaca. Na nijnequi niquintlaxtlahuis ni tlacame tlen hualajque tiotlac ihuical queja imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Ax nijpiya tlanahuatili nijchihuas tlen nijnequi ica notomi? Huelis san inmoxicohuaj ica yajuanti pampa nelía cuali niquintlaxtlahui.’ ");
INSERT INTO nheNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Quej nopa ica tlacame tlen ama tlayacanaj, teipa elise tlen mocahuase tlatepotzco. Huan tlen hasta tlatepotzco mocahuaj ama, teipa elise tlen tlayacanase, pampa Toteco quinnotzas miyac tlacame, pero san sequin quintlapejpenis para iaxcahua.” ");
INSERT INTO nheNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Teipa Jesús tlejcotiyohuiyaya para altepetl Jerusalén, huan ipan ojtli techhuicac timajtlacme huan ome tiimomachtijcahua iyoca huan techilhui: ");
INSERT INTO nheNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Xiquitaca. Amantzi tiyohuij altepetl Jerusalén huan nepa nechtemactilise na tlen niMocuepqui Tlacatl ica nopa tlayacanca totajtzitzi huan ica nopa tlamachtiani tlen itlanahuatil Moisés. Huan yajuanti quiijtose para ma nimiqui. ");
INSERT INTO nheNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Huan nechtemactilise ininmaco sejcoyoc ehuani. Huan yajuanti nechhuihuiitase, huan nechcuartajhuise huan nechcuamapeloltise. Pero ipan eyi tonali nimoyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Huan ininnana Juan huan Jacobo monechcahuico campa Jesús ininhuaya nopa ome itelpocahua. Ni telpocame eliyayaj iconehua Zebedeo. Huan ininnana motlancuaquetzqui iixtla Jesús para quitlajtlanilis se favor. ");
INSERT INTO nheNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Huan Jesús quiilhui: ―¿Tlachque tijnequi? Huan nopa sihuatl quiilhui: ―Xitlanahuati para ni ome notelpocahua para ma mosehuica, se ipan monejmatl huan seyoc ipan moarraves quema titlanahuatis. ");
INSERT INTO nheNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huan Jesús quinilhui: ―Ax inquimatij tlachque innechtlajtlaníaj. Huan Jesús quintlajtlani itelpocahua: ―¿Inquimachilíaj para inhuelise intlaijiyohuise queja na nitlaijiyohuis ica se ome tonali? Huan quinanquilijque: ―Quena, tihuelise. ");
INSERT INTO nheNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Huan Jesús quinilhui: ―Nelía tlen inquiijtohuaj, miyac intlaijiyohuise queja na nitlaijiyohuis, pero ax notequi para niquijtos ajqueya mosehuis ipan nonejmatl huan ipan noarraves. NoTata, quena, yajaya quimati ajqueya mosehuis nopano. ");
INSERT INTO nheNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Huan timajtlacme tiimomachtijcahua tijcajque tlen quiijtojque huan ticualanque ininhuaya nopa ome icnime. ");
INSERT INTO nheNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Huajca Jesús technotzqui nochi ma timonechcahuica campa ya itztoya huan techilhui: ―Inquimatij para tlanahuatiani ipan ni tlaltepactli nelía tlanahuatíaj chicahuac. Huan huejhueyi tlacame quinequij inintlacajhua nimantzi ma quinneltoquilica inintlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero ax queja nopa elis para imojuanti inmochihuase inhuejhueyi. ");
INSERT INTO nheNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Intla se tlen imojuanti quinequi mohueyichihuas, monequi elis inintequipanojca nochi sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Xijchihuaca queja na tlen niMocuepqui Tlacatl. Ax nihualajtoc para niquinnahuatis tlacame ma nechtequipanoca. ¡Axtle! Nihualajtoc para niquintequipanos tlacame, huan para nimotemactilis huan nimiquis para nitlaxtlahuas tlen monequi para niquintojtomas miyac tlacame para huelis yase majcajtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Huan quema Jesús quisayaya altepetl Jericó, miyac tlacame quitoquilijtiyohuiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Huan mosehuiyayaj ojteno ome tlacame tlen popoyotzitzi huan quicajque para panoyaya Jesús. Huan huajca pejque quiijtohuaj chicahuac: ―¡Toteco, tiiteipa ixhui David, xitechtlasojtla! ");
INSERT INTO nheNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Huan nopa miyac tlacame chicahuac quintlacahualtiyayaj para ma ayoc tlahuejchihuaca. Pero nopa popoyotzitzi achi más tzajtziyayaj: ―¡Toteco, tiiteipa ixhui David, xitechtlasojtla! ");
INSERT INTO nheNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Huan Jesús moquetzqui huan quinilhui: ―¿Tlachque inquinequij ma nimechchihuili? ");
INSERT INTO nheNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Huan quiilhuijque: ―Toteco, tijnequij titlachiyase. ");
INSERT INTO nheNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Huan Jesús quintlasojtlac huan quitlali ima ipan iniixtiyolhua huan nimantzi tlachixtejque huan yajuanti quitoquilijque ipan ojtli. ");
INSERT INTO nheNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Huan Jesús huan nochi tojuanti tlen tinejnemiyayaj ihuaya timonechcahuiyayaj altepetl Jerusalén. Huan tiajsitoj ipan se pilaltepetzi tlen itoca Betfagé, nechca nopa tepetl tlen itoca Olivos. Huan Jesús quinnotzqui ome imomachtijcahua para quintitlanis ipan se rancho nechca. ");
INSERT INTO nheNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Huan quinilhui: ―Xiyaca ipan ne altepetl tlen mocahua toixmelac. Nepa inquipantise se burra ilpitoc ihuaya icone. Xiquintojtomaca huan xinechhualiquilica. ");
INSERT INTO nheNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Huan intla se tlacatl inmechtlajtlanis tlachque inquichihuaj, xiquilhuica: ‘Toteco quinequi quintequihuis para se tlalochtli huan nimantzi mitzcuepilis.’ ");
INSERT INTO nheNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Quichijqui ni para ma pano tlen huejcajquiya quiijcuilo nopa tiocamanalojquetl para panos teipa. Yajaya huejcajquiya quiijtojtoya: ");
INSERT INTO nheNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Xiquinilhui altepetl Jerusalén ehuani ni tlajtoli: ‘Xiquitaca, hualahua imotlanahuatijca. Yajaya ax mohueyimati. Mosehuijtihualas ipan se pilburrojtzi. Quena, mosehuijtihualas ipan icone se burra tlen quimati tlamama.’ ” Quej nopa quiijcuilo nopa tiocamanalojquetl tlen huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Huan nopa ome imomachtijcahua Jesús yajque huan quichijque queja Jesús quinilhui. ");
INSERT INTO nheNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Huan quihualicaque nopa burra ihuaya icone. Huan tijtlalilijque totlaque ininpani huan Jesús tlejcoc. ");
INSERT INTO nheNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Huan itztoyaj tohuaya tlahuel miyac tlacame huan quisojque inintlaque ipan ojtli. Sequinoc quimapostejque ininmacuayo apachtli huan quitenque ipan ojtli para ma ipan nejnemi ipilburro Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Huan nochi nopa miyac tlacame tlen quiyacanayayaj Jesús huan nochi más tlen yohuiyayaj itepotzco chicahuac tlahuejchihuayayaj huan quiijtohuayayaj: “¡Timitzhueyichihuaj ta tlen tiiteipa ixhui Tlanahuatijquetl David! ¡Ma Toteco Dios mitztiochihua ta tlen tihuala ica itequihuejcayo Toteco! ¡Ma tijhueyichihuaca Toteco Dios tlen itztoc elhuicac ipampa tlen techchihuilijtoc!” ");
INSERT INTO nheNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Huan quema Jesús calajqui ipan altepetl Jerusalén, nochi hualajque quitlachilicoj tlachque panoyaya huan motlajtlaniyayaj: ―¿Ajqueya huala? ");
INSERT INTO nheNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Huan tlacame quiijtojque: ―Yajaya ne tiocamanalojquetl Jesús tlen ehua Nazaret ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Huan Jesús calajqui ipan nopa hueyi israelita tiopamitl huan quintotocac nochi tlen tlanamacayayaj huan tlacohuayayaj tiopan calijtic. Huan quintepehuili ininmesas tlen quipatlayayaj tomi tlen huala sejcoyoc. Nojquiya quintepehuili ininsiyas tlen tenamaquiltiyayaj palomas. ");
INSERT INTO nheNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Huan Jesús quinilhui: ―Ijcuilijtoc ipan Itlajtol Toteco campa yajaya quiijtohua: ‘Nochi tlacame quitocaxtise nochaj: Nopa Cali Campa Tlacame Momaijtohuaj.’ Pero inquichijtoque campa mosentilíaj tlaxtequini para quintlaxtequilise tlen hualahuij. ");
INSERT INTO nheNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Huan hualajque campa Jesús nepa tiopan calijtic tlen popoyotzitzi huan tlen metzcuachotzitzi, huan yajaya quinchicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero nopa tlayacanca totajtzitzi huan nopa tlamachtiani tlen itlanahuatil Moisés quiitaque nopa chicahualnescayotl tlen Jesús quichihuayaya huan nojquiya quinitaque nopa coneme tiopan calijtic tlen chicahuac quiijtohuayayaj: “Timitzhueyichihuaj ta tiiteipa ixhui David.” Huajca cualanque, ");
INSERT INTO nheNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","huan quiilhuijque Jesús: ―¿Ax tijcaqui tlen quiijtohuaj tlen ta? Huan Jesús quinilhui: ―Quena, nijcaqui. Huelis ax inquipojtoque ipan Itlajtol Toteco campa quiijtohua: ‘Toteco ta tijchijtoc para coneme huan pilconetzitzi ma mitzhueyichihuaca.’ ");
INSERT INTO nheNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Huan Jesús quincajtejqui huan yajqui altepetl Betania huan nepa tonilito. ");
INSERT INTO nheNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Huan hualmostla ica ijnaloc Jesús itztoya ipan ojtli mocuepayaya para Jerusalén huan mayantoya. ");
INSERT INTO nheNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Huan ojteno Jesús quiitac se higuera cuahuitl huan monechcahuito huan quiitac ax quipiyayaya itlajca. San ixihuiyo quipiyayaya. Huan Jesús quiilhui nopa cuahuitl: ―Cuahuitl, ayoc quema titemacas motlajca. Huan nimantzi huajqui nopa cuahuitl. ");
INSERT INTO nheNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Huan quema tiimomachtijcahua tiquitaque para huajqui nopa cuahuitl, timosentlachilijque huan tijtlajtlanijque: ―¿Quejatza elqui para nimantzi huajqui ni cuahuitl? ");
INSERT INTO nheNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Huan Jesús technanquili: ―Nelía nimechilhuía, monequi quema inquitlajtlaníaj Toteco se tlamantli, xijneltocaca para temachtli Toteco inmechmacas huan huajca inmechmacas. Intla san inmoilhuíaj huelis inmechmacas o huelis axtle, huajca ax tleno inmechmacas. Nojquiya huelis inquichihuase sequinoc tlamantli tlen más huejhueyi que nopa tlen nijchijtoc ica ni cuahuitl. Huelis inquiilhuise se tepetl: ‘Ximijcueni, tepetl, huan ximomajcahua ipan hueyi atl’, huan queja nopa panos. ");
INSERT INTO nheNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Huan nochi tlen inquitlajtlanise Toteco huan inquineltocase temachtli Toteco inmechmacas, inquiselise. ");
INSERT INTO nheNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Huan quema Jesús sampa ajsico ipan nopa hueyi tiopamitl huan tlamachtiyaya, hualajque nopa tlayacanca totajtzitzi huan nopa huehue tlacame tlen israelitame huan quiilhuijque: ―¿Tlachque tlanahuatili tijpiya para tijchihua nochi ni tlamantli tlen tijchijtinemi? ¿Ajqueya mitzmacatoc tlanahuatili? ");
INSERT INTO nheNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Huan Jesús quinilhui: ―Nojquiya nimechtlajtlanis se tlamantli. Intla xitlahuac innechnanquilise, huajca nojquiya nimechilhuis ajqueya nechmacac tlanahuatili para nijchihuas tlen nijchihua. ");
INSERT INTO nheNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ajqueya quititlanqui Juan para ma tecuaaltiqui? ¿Toteco quititlanqui o san tlacame? Huajca yajuanti pejque mocamahuíaj quejatza quinanquilisquíaj. Quiijtojque: ―Intla tiquijtose Toteco quititlanqui Juan, huajca Jesús techtlajtlanis para tlen ax tijneltocaque. ");
INSERT INTO nheNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Huan intla tiquijtose san tlacame quimacaque Juan tequihuejcayotl, huajca techchihuilise tlen fiero ni tlacame, pampa yajuanti quineltocaj para Juan eliyaya se itiocamanalojca Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huajca quiilhuijque Jesús: ―Tojuanti ax tijmatij ajqueya quititlanqui Juan. Huajca Jesús quinilhui: ―Ax innechnanquilijque xitlahuac, huajca na nojquiya ax nimechilhuis ajqueya nechmacatoc tlanahuatili para nijchihuas tlen nijchihua. ");
INSERT INTO nheNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús quinilhui: ―¿Tlachque inmoilhuíaj tlen ni huicaltili tlen nimechpohuilis? Se tlacatl quinpixtoya ome itelpocahua huan yajqui campa nopa achtohui ejquetl huan quiilhui: ‘Nocone, xiya ama xitequititi nepa ipan toxocomecamil.’ ");
INSERT INTO nheNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Huan yajaya quinanquili: ‘Axtle, Papá, ax nijnequi niyas.’ Pero teipa moyolpatlac huan yajqui tequitito. ");
INSERT INTO nheNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Huan teipa nopa tetat yajqui campa ne se itelpoca huan nojquiya quiilhui ma tequititi. Huan yajaya quiilhui: ‘Quena, Papá, niyas.’ Pero ax yajqui. ");
INSERT INTO nheNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Huajca, ¿ajqueya nopa ome iconehua quichijqui tlen itata quinequiyaya ma quichihua? Huan quinanquilijque: ―Nopa telpocatl tlen achtohui. Huan Jesús quinilhui: ―Nelía nimechilhuía nopa fiero tlacame tlen tlainamaj impuesto huan nopa tlacanenca sihuame inmechtlayacancuilise para calaquise nepa campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Pampa achtohui Juan tlen tecuaaltiyaya tlamachtico nopa ojtli tlen xitlahuac, huan ax inquineltocaque. Pero nopa tlacame tlen tlainamaj impuesto huan nopa sihuame tlen tlacanemij, quena, quineltocaque. Huan yonque inquiitaque queja quipatlaque ininnemilis, noja ax inmoyolcueptoque huan ax inquineltocase. ");
INSERT INTO nheNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Huan Jesús quinilhui: ―Xijtlacaquilica ni huicaltili tlen nimechpohuilis. Itztoya se tlacatl tlen quitojqui xocomecatl ipan imil huan quitzajtzajqui yahualtic huan tlacoyoni campa tepejpechtitla para ipan quipatzcas itlajca. Huan nojquiya quichijqui se tepancali tlen huejcapantic para ipan tlejcos para quimocuitlahuis nochi imil. Huan quincahuilijtejqui ininmaco sequinoc tlacame para ma quimocuitlahuica huan teipa ma quitlajcoitasquíaj itlajca nopa mili. Huan teipa nopa tecojtli quisqui huan yajqui huejca. ");
INSERT INTO nheNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Huan quema ajsic tonali para tlatequistli, nopa tecojtli quintitlanqui se ome itlatequipanojcahua para ma quinitatij nopa tlacame para ma quinmacaca tlen ya iaxca tlen nopa tlatequistli. ");
INSERT INTO nheNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero nopa tlacame tlen ininmaco eltoya nopa mili quinitzquijque itlatequipanojcahua; huan se quimaquilijque, huan seyoc quimictijque, huan seyoc quitepachojque ica tetl. ");
INSERT INTO nheNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Huan nopa tecojtli sampa quintitlanqui achi miyaqui itlatequipanojcahua huan nojquiya san se quinchihuilijque. ");
INSERT INTO nheNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Teipa nopa tecojtli quititlanqui itelpoca pampa moilhui temachtli quitlepanitase notelpoca. ");
INSERT INTO nheNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero quema nopa ax cuajcualme quiitaque itelpoca, moilhuijque se ica seyoc: ‘Yajaya ni tlen teipa quiselis ni xocomeca mili para iaxca. Huajca ma tijmictica huan teipa ni mili elis toaxca.’ ");
INSERT INTO nheNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Huajca quiitzquijque itelpoca ininteco huan quimajcajque xocomeca milteno huan quimictijque. ");
INSERT INTO nheNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Huajca, ¿tlachque inmoilhuíaj nopa tecojtli quinchihuilis nopa fiero tlacame quema yajaya mocuepas?” ");
INSERT INTO nheNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Huan nopa tlacame quinanquilijque Jesús: ―Nopa tecojtli quinmictis nopa fiero tlacame, niyon ax quintlasojtlas. Huan teipa quincahuilis sequinoc ma quimocuitlahuica ixocomecamil tlen nelía quicuepilise tlen iaxca quema oncas tlatequistli. ");
INSERT INTO nheNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Huan Jesús quinilhui: ―¿Ax inquipojtoque campa ijcuilijtoc ipan Itlajtol Toteco campa camati tlen na queja nieli se hueyi tetl? Queja ni quiijtohua: ‘Nopa hueyi tetl tlen calchihuani ax quinejque quitequihuise, huan quimajcajque, teipa elqui tlen más monequiyaya para yas calnacastla, huan ipan quiquetzase nopa cali. Elis yajaya Toteco tlen quichihua queja nopa ma pano, huan nelía yejyectzi tiquitaj tlen quichihua.’ ");
INSERT INTO nheNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Huajca nimechilhuía Toteco quichihuas queja nopa tecojtli huan ayoc inmechcahuilis incalaquise campa Toteco tlanahuatía pampa ax innechnequij, pero quincahuilis ma calaquica tlacame tlen nechselise huan quichihuase tlen cuali queja tlen quinamiqui para tlen itztoque ipan itlanahuatilis. ");
INSERT INTO nheNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Huan tlen ax nechnequi eltos queja se tlen huetzis ipan nopa hueyi tetl huan tlahuel mococos. Huan na nieli nopa hueyi tetl huan quema nijpanajsis tlen ax nechselía, nijchihuas xacualtic. ");
INSERT INTO nheNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Huan quema nopa tlayacanca totajtzitzi huan nopa fariseos quicajque ni eyi huicaltili, quimachilijque para Jesús camatiyaya tlen yajuanti. ");
INSERT INTO nheNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pero yonque quinequiyayaj quiitzquise Jesús para quitzacuase, quinimacasiyayaj nopa miyac tlacame tlen quitlepanitayayaj Jesús huan quiitayayaj para se itiocamanalojca Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Huan Jesús sampa pejqui quincamahuía nopa miyac tlacame ica huicaltili huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Campa tlanahuatis Toteco tlen itztoc ipan elhuicac, eltos queja se tlanahuatijquetl tlen quichijqui se hueyi tlacualistli tlen nenamictili quema mosihuajti itelpoca. ");
INSERT INTO nheNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Huan quintitlanqui itlatequipanojcahua ma quinyolmelahuatij nochi tlanotzalme ma hualaca campa nopa tlacualistli tlen nenamictili, pero nopa tlanotzalme ax quinejque hualase. ");
INSERT INTO nheNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Huajca sampa nopa tlanahuatijquetl quintitlanqui sequinoc itlatequipanojcahua ma yaca huan quinilhuitij: ‘Xiquinilhuica nopa tlanotzalme para ya nijsencajtoc ni tlacualistli. Niquinmictijtoc nohuacaxhua tlen más tomahuaque huan nochi eltoc para titlacuase. Xiquinilhuica ma hualaca campa ni tlacualistli tlen nenamictili.’ ");
INSERT INTO nheNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero nopa tlanotzalme ax quinchihuilijque cuenta inintlajtol huan nochi yajque ipan inintequi. Se yajqui imila huan seyoc yajqui tlanamacato. ");
INSERT INTO nheNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Huan hasta sequinoc quinitzquijque itlatequipanojcahua nopa tlanahuatijquetl. Sequin quincocojque huan sequin quinmictijque. ");
INSERT INTO nheNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Huajca nopa tlanahuatijquetl nelía cualanqui ininhuaya huan quintitlanqui isoldados huan quinmictijque nopa temictiani huan quitlati inialtepe. ");
INSERT INTO nheNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Teipa nopa tlanahuatijquetl quinilhui itlatequipanojcahua: ‘Ya eltojca ni hueyi tlacualistli tlen nenamictili, pero nopa tlanotzalme quinextijque para ax quinamiqui para hualase. ");
INSERT INTO nheNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Huajca xiyaca nepa ipan ojojtli huan nochi tlen inquinpantitij, xiquinnotzaca ma hualaca ipan ni tlacualistli tlen nenamictili.’ ");
INSERT INTO nheNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Huajca nopa tlatequipanohuani yajque campa hueli ojojtli huan quinsentilijque nochi tlen quinpantijque, sequin cuali tlacame huan sequin ax cuali. Huan huajca ichaj nopa tlanahuatijquetl temic ica tlanotzalme para nopa hueyi tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Huan nopa tlanahuatijquetl calajqui quitlachiliti nopa tlacualistli huan ajqueya yajuanti itztoyaj, huan quiitac se tlacatl tlen ax moquentijtoya iyoyo tlen quinamiqui para quema tlacame yohuij ipan se nenamictili. ");
INSERT INTO nheNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Huajca nopa tlanahuatijquetl quitlajtlani: ‘Tinohuampo, ¿ipan tlachque puerta ticalaquico nica? Ax ticalajqui campa notequipanojcahua teyoyontíaj ica se cuali yoyomitl tlen quinamiqui ipan ni nenamictili.’ Pero nopa tlacatl ax tleno huelqui tlananquili. ");
INSERT INTO nheNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Huajca nopa tlanahuatijquetl quinilhui itlatequipanojcahua: ‘Xiquilpica ipan iicxihua huan ipan ima ni tlacatl huan xijmajcahuaca calteno campa tzintlayohua huan campa tlacame chocase huan tlanhuehuechocase pampa tlahuel tlaijiyohuise.’ ");
INSERT INTO nheNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pampa niquinnotza miyac para ma hualaca, pero ax miyac niquintlapejpenijtoc.” ");
INSERT INTO nheNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Teipa yajque nopa fariseos huan quisencajque san sejco quejatza quimasiltise Jesús para ma quiijto se tlajtoli ax cuali para huelis quiteilhuise. ");
INSERT INTO nheNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Huajca quintitlanque sequin ininhuampoyohua tlen yajque ihuaya ihuampoyohua Tlanahuatijquetl Herodes campa Jesús huan quiilhuijque: ―Tlamachtijquetl, tijmatij tiquijtohua tlen melahuac. Titlamachtía tlen nelía iojhui Toteco huan tlen quinequi ma tijchihuaca. Ax tiquinimacasi tlacame huan tlen quiijtose tlen ta, niyon axaca tijchicoicnelía. ");
INSERT INTO nheNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Huajca xitechilhui ya ni. ¿Tiquita cuali titlaxtlahuase nopa tomi tlen techtlajtlanía totlanahuatijca César, o axtle? ");
INSERT INTO nheNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús quimachili para ax cuali inintlalnamiquilis nopa tlacame huan san quinequiyayaj quicajcayahuase. Huajca quinilhui: ―¿Para tlen inquinequij innechcajcayahuase? Inquipiyaj ome imoxayac. ");
INSERT INTO nheNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xinechnextilica se tomi ica tlen intlaxtlahuasquíaj nopa tlen ne tlanahuatijquetl tlajtlani. Huan yajuanti quinextilijque se tepos tomi. ");
INSERT INTO nheNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Huan Jesús quinilhui: ―¿Ajqueya iixcopinca eltoc ipan ni tomi? Huan ¿ajqueya itoca ijcuilijtoc ipani? ");
INSERT INTO nheNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Huan yajuanti quiilhuijque: ―Iixcopinca huan itoca tlanahuatijquetl César. Huan Jesús quinilhui: ―Xijmacaca César tlen ya iaxca huan nojquiya xijmacaca Toteco Dios tlen Toteco iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Huan quema nopa fariseos quicajque itlajtol, mosentlachilijque pampa ax huelque quicajcayahuaj huan quistejque. ");
INSERT INTO nheNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ipan nopa tonali yajque sequin saduceos quicamahuitoj Jesús. Saduceos tlamachtíaj para ax quema hueli moyolcuise mijcatzitzi sampa. Huan yajuanti quitlajtlanijque Jesús: ");
INSERT INTO nheNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Tlamachtijquetl, itlanahuatil Moisés quiijtohua intla se tlacatl miquis huan ax quicajtejtoc niyon se conetl, huajca itlaca icni nopa tlacatl tlen mijqui monequi mosihuajtis ihuaya nopa cahualtzi para quipiyase se conetl tlen elis queja icone yajaya tlen mijqui huan queja nopa tlen mijqui quinpiyas iteipa ixhuihua. ");
INSERT INTO nheNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Se tonal itztoyaj chicome icnime ipan totlal, huan nopa tlen achtohui ejquetl mosihuajti, huan teipa mijqui huan ax quipixqui se conetl. Huajca itlaca icni tlen iteipa ejca mosihuajti ihuaya nopa cahualtzi. ");
INSERT INTO nheNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Huan nojquiya mijqui huan ax quipixqui coneme. Huajca nopa sequinoc iteipa icnihua mosihuajtijque ihuaya nopa sihuatl hasta ajsic chicome icnime tlen mosihuajtijque ihuaya nopa sihuatl, huan sesen yajuanti mijque. ");
INSERT INTO nheNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Teipa nopa sihuatl nojquiya mijqui. ");
INSERT INTO nheNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Huajca ipan nopa tonal quema moyolcuise nochi tlen mictoque, ¿ajqueya tlen nopa chicome tlacame quipiyas nopa sihuatl para iaxca pampa nochi quipixque para ininsihua? ");
INSERT INTO nheNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Pero Jesús quinilhui: ―Inmocajcayajtoque pampa ax inquimatij Itlajtol Toteco huan ax inquimachilíaj para nelía hueyi ichicahualis. ");
INSERT INTO nheNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Quema moyolcuise nochi tlacame tlen mictoque, ayoc mosihuajtise, niyon monamictise, niyon quisencahuase para iniichpocahua monamictise. Nochi itztose para nochipa queja ielhuicac ejcahua Toteco tlen itztoque nepa elhuicac tlen ax miquij huan yeca ax monequi monamictise para quinpiyase ininconehua. ");
INSERT INTO nheNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero quena, tlacame sampa moyolcuise. ¿Ax inquipojtoque tlen Toteco quiijto quema ya mijque tohuejcapan tatahua? Yajaya quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Na niiTeco Abraham, Isaac huan Jacob.’ Huan pampa Toteco quiijto yajaya ininTeco Abraham, Isaac huan Jacob quema yajuanti ya mictoyaj nica, huajca tijmatij yajuanti noja yoltoque nepa elhuicac iixtla Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Huan quema nochi nopa miyac tlacame quicajque quejatza Jesús quinnanquili, nelía mosentlachilijque. ");
INSERT INTO nheNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Huan nopa fariseos quicajque para Jesús quintlanqui nopa saduceos ica itlajtol, huajca quisencajque seyoc tlamantli para quitlajtlanise. ");
INSERT INTO nheNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Huan se tlen yajuanti tlen eliyaya se tlayacanca tlamachtijquetl tlen itlanahuatil Moisés tlahuel quinequiyaya quimasiltis Jesús. Huajca quitlajtlani: ");
INSERT INTO nheNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tlamachtijquetl, ¿tlachque tlanahuatili ipan itlanahuatilhua Moisés achi más monequi tijchihuase? ");
INSERT INTO nheNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Huan Jesús quinanquili: ―Nopa tlanahuatili tlen quiijto: ‘Xiquicneli Toteco Dios ica nochi moyolo, huan ica nochi moalma, huan ica nochi motlalnamiquilis.’ ");
INSERT INTO nheNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ya ni nopa tlanahuatili tlen más hueyi huan tlen más monequi tijchihuase. ");
INSERT INTO nheNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Huan nopa ompa tlanahuatili no ihuical elisnequi: ‘Xiquinicneli sequinoc queja timoicnelía moselti.’ ");
INSERT INTO nheNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Intla se quichihuas ni ome tlanahuatili, ya quichijtos nochi sequinoc tlanahuatili tlen ijcuilijtoc ipan itlanahuatilhua Moisés huan ipan iniama itiocamanalojcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Huan quema nopa fariseos noja quiyahualohuayaya, ");
INSERT INTO nheNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús quintlajtlani: ―Inquimatij Toteco techilhui quititlanis nopa Cristo ipan ni tlaltepactli. ¿Tlachque inmoilhuíaj? ¿Ajqueya icone elis Cristo? Huan yajuanti quinanquilijque: ―Yajaya elis se iteipa ixhui Tlanahuatijquetl David tlen huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Huan Jesús quintlajtlani: ―Huajca, ¿para tlen Tlanahuatijquetl David quinotzqui Cristo ‘noTeco’? Pampa huejcajquiya Itonal Toteco quichihuili David ma quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Toteco Dios quicamahui noTeco Cristo, huan quiijto: Ximosehui nica ipan nonejmatl hasta nimitzmactilis mocualancaitacahua para xiquinnahuati.’ ");
INSERT INTO nheNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Huajca intla Tlanahuatijquetl David quinotzqui Cristo ‘noTeco’ huan technextili para Cristo elisquía Dios, ¿quejatza nojquiya elisquía ya iteipa ixhui? ");
INSERT INTO nheNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Huajca axaca quimatiyaya quejatza quinanquilis. Huan yeca ipan nopa tonal huan teipa nochi majmahuiyayaj para más quitlajtlanisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Teipa Jesús quincamahui nopa miyac tlacame tlen quitoquiliyayaj huan techcamahui tiimomachtijcahua huan techilhui: ");
INSERT INTO nheNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nopa fariseos huan tlamachtiani tlen itlanahuatil Moisés quipiyaj tlanahuatili ihuical queja Moisés para tlamachtise tlachque quiijtosnequij itlanahuatil. ");
INSERT INTO nheNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huajca amo xiquilcahuaca xijchihuaca tlen inmechilhuíaj xijchihuaca. Pero amo xijtoquilica iniojhui tlen fiero pampa yajuanti ax quichihuaj tlen tlamachtíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pampa yajuanti inmechmacaj miyac tlanahuatili tlen yajuanti quisencahuaj para inmochihuasquíaj incuajcualme, pero axaca hueli quintlamichihuas. Eltoc queja inmechilpilíaj tlamamali tlen tlahuel etic para inquimamajtiyase, pero nopa tlamachtiani ax quinequij quinpalehuise tlen tlamamajtiyohuij niyon ica se ininmacpil. ");
INSERT INTO nheNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nochi tlen nopa tlamachtiani huan fariseos quichihuaj, san quichihuaj para tlacame ma quinitaca. Para nesis tlatzejtzeloltique yajuanti moilpilíaj ipan ininma huan ipan inincuajtoltipa nopa piltlajcuiloltzitzi ica Itlajtol Toteco. Nojquiya quinpactía quipiyase ininyoyo itenhuaxo nelhuehueyac para ma ajsi tlalchi para nochi quiitase. ");
INSERT INTO nheNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Quinequij mosehuise ipan nopa siyas campa achtohui quintequilise tlacuali ipan se tlacualistli. Huan quinequij mosehuise ipan nopa siyas tlen más cuali ipan tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Quinpactía quema tlacame quintlajpalohuaj ica cuali ipan tianquis. Quinpactía quema tlacame quintocaxtíaj ‘Tlamachtijquetl’. ");
INSERT INTO nheNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pero imojuanti amo xijnequica para inmohueyichihuase huan para sequinoc ma inmechnotzaca ‘Rabí’ o ‘Tlamachtijquetl’ pampa san na niCristo niimotlamachtijca, huan nochi imojuanti san sejco initztoque queja inicnime. ");
INSERT INTO nheNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Huan axaca ipan ni tlaltepactli xijhueyimatica huan xijtocaxtica ‘Totata’ pampa iyojtzi itztoc imoTata huan yajaya Totata Dios tlen itztoc elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Huajca amo xijcahuilica sequinoc ma inmechnotzaca ‘Tlayacanquetl’ pampa san na niCristo tlen Toteco nechtitlanqui ipan tlaltepactli niimotlayacanca. ");
INSERT INTO nheNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Huan ajqueya tlen imojuanti quinequi mochihuas tlen más hueyi, ma mochihua imotequipanojca. ");
INSERT INTO nheNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pampa nochi tlen mohueyimatij ama, teipa Toteco quinpinahualtis, pero nochi tlen ama moicnonequij, teipa Toteco quinhueyimatis. ");
INSERT INTO nheNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Inteicneltique infariseos huan intlamachtiani tlen itlanahuatil Moisés, pampa Toteco hueyi inmechtlatzacuiltis! Ome imoxayac. Inquintzacuilíaj tlacame para ma ax calaquica campa Toteco tlen itztoc elhuicac tlanahuatía. Ax inquinequij incalaquise imojuanti, niyon ax inquincahuilíaj ma calaquica sequinoc tlen quinequij. ");
INSERT INTO nheNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Inteicneltijque infariseos huan intlamachtiani tlen itlanahuatil Moisés, pampa Toteco hueyi inmechtlatzacuiltis! Ome imoxayac. Huejcahua inmomaijtohuaj ica Toteco tlamiyacapa para intlacajcayahuaj, pero iyoca inquinquixtilíaj ininchajchaj cahual toahuime. Huajca nopa tlatzacuiltili tlen inquiselise elis más hueyi que sequinoc quiselise. ");
INSERT INTO nheNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Inteicneltique infariseos huan intlamachtiani tlen itlanahuatil Moisés, pampa Toteco hueyi inmechtlatzacuiltis! Ome imoxayac. Campa hueli ipan tlaltepactli inyohuij. Inquipanotinemij hueyi atl huan hasta campa hueli tlali para inquintemohuaj ajqueya yancuic quitoquilis nopa tlajtoli tlen intlamachtíaj. Huan quema ya inquiyolpatlatoque se tlacatl para ma quitoquilis imotlajtol, inquichihuilíaj ma eli noja más fiero que imojuanti. Huajca nopa tlitl nepa mictla quichiya, queja nojquiya inmechchiya imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Inteicneltique imojuanti, Toteco hueyi inmechtlatzacuiltis! Initztoque queja popoyotzitzi tlen tenextilíaj catlía ojtli ma quitoquilica. Inquiijtohuaj: ‘Intla se quitestigojquetzas tiopamitl para quichihuas se tlamantli, ax monequi quichihuas tlen quiijto quichihuasquía. Pero intla se quitestigojquetzas nopa oro tlen eltoc tiopan calijtic, huajca, quena, monequi quichihuas tlen quiijto.’ ");
INSERT INTO nheNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¿Quejatza huelis inmoilhuíaj más ipati nopa oro que nopa tiopamitl tlen quitlatzejtzelolchihua nopa oro? ");
INSERT INTO nheNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Huan nojquiya inquiijtohuaj: ‘Aqui quitestigojquetzas nopa tlaixpamitl para quichihuase se tlamantli, ax monequi quichihuas tlen quitencahuilijtoc quichihuas, pero intla se quitestigojquetzas nopa tlacajcahualistli tlen eltoc ipan tlaixpamitl, huajca quena, monequi quichihuas tlen quitencahuili quichihuas.’ ");
INSERT INTO nheNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Inhuihuitique pampa ax tleno inquimachilíaj! Initztoque queja inpopoyotzitzi. ¿Huelis más hueyi nopa tlacajcahualistli tlen tlacame quihualicaque que nopa tlaixpamitl tlen quitlatzejtzelolchihua nopa tlacajcahualistli? ¡Ax cuali imotlalnamiquilis! ");
INSERT INTO nheNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nelía yajaya tlen quitestigojquetza nopa tlaixpamitl nojquiya quitestigojquetza nochi tlen eltoc nopano. ");
INSERT INTO nheNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Huan se tlen quitestigojquetzas nopa tiopamitl, nojquiya quitestigojquetza nopa tiopamitl huan Toteco tlen nopano itztoc. ");
INSERT INTO nheNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Huan yajaya tlen quitestigojquetzas elhuicactli, nojquiya quitestigojquetzas isiyaj yejyectzi campa Toteco mosehuía huan nojquiya quitestigojquetza Toteco tlen mosehuía nopano. ");
INSERT INTO nheNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Inteicneltijque infariseos huan intlamachtiani tlen itlanahuatilhua Moisés, pampa Toteco hueyi inmechtlatzacuiltis! ¡Ome imoxayac! Inquimacaj Toteco majtlactli por ciento tlen nochi tlen inquipiyaj hasta nopa alojhueno, anís huan cominos, pero tlen más ipati tlen itlanahuatilhua Moisés techilhuíaj ma tijchihuaca, ax inquitoquilíaj. Itlanahuatilhua quiijtohuaj ma tijchihuaca tlen xitlahuac iixtla Toteco, huan ma titetlasojtlaca huan ma tiitztoca titemachme. Ni tlamantli achi más monequi xijchihuaca, huan nojquiya monequi ax inquicahuase inquimacase Toteco se majtlactli por ciento tlen nochi tlen inquipiyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Initztoque queja popoyotzitzi tlen tenextilíaj catlía ojtli ma quitoquilica. Inquitoquilíaj nopa tlajtoli tlen pilquentzi ipati, pero nopa tlajtoli tlen hueyi ipati, ax inquichihuilíaj cuenta. ");
INSERT INTO nheNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Inteicneltique infariseos huan intlamachtiani tlen itlanahuatil Moisés, pampa Toteco hueyi inmechtlatzacuiltis! Ome imoxayac. Imopani innesij queja incuajcualme, pero ipan imoyolo san inmoilhuíaj nochi tlen intlachtectoque huan tlen fiero inquichijtoque. ");
INSERT INTO nheNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Inteicneltijque infariseos! Achtohui ximoyolpajpacaca, huan huajca nelía inelise intlapajpacme ipan imoyolo huan imopani queja se vaso tlen tlapajpactic iijtico huan ipan itejteno. ");
INSERT INTO nheNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Inteicneltijque infariseos huan intlamachtiani tlen itlanahuatil Moisés, pampa Toteco hueyi inmechtlatzacuiltis! ¡Ome imoxayac! Initztoque queja panteones tlen nesij yejyectzitzi ininpani pampa quinnexhuijtoque, pero iijtic nelía fiero pampa temitoc ica iniojomiyo mijcatzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Imojuanti innesij para incuajcualme para tlacame ma inmechtlachilica, pero ax neli incuajcualme, pampa fiero inmoyolo. San inquichihuaj ome imoxayac. ");
INSERT INTO nheNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Inteicneltique infariseos huan intlamachtiani tlen itlanahuatil Moisés, pampa Toteco hueyi inmechtlatzacuiltis. ¡Ome imoxayac! Inquinchihuilíaj panteones campa quintoctoque itiocamanalojcahua Toteco tlen quinmictijque huejcajquiya. Huan inquinxochitemíaj ininpanteones nopa tlacame tlen itztoyaj huejcajquiya huan eliyayaj xitlahuaque iixtla Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Huan inquiijtohuaj para intla initztosquíaj huejcajquiya quema tohuejcapan tatahua itztoyaj, ax inquinpalehuijtosquíaj para quinmictijtosquíaj itiocamanalojcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Huajca ica imotlajtol intenextilíaj para inelij inininteipa ixhuihua nopa tlacame tlen quinmictijque itiocamanalojcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Huan san polihui para nojquiya inquichihuase queja yajuanti quichijque huan intemictise para inquipiyase miyac tlajtlacoli iixtla Toteco queja imotatahua quipixtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Initztoque queja miyac cohuame ipan san se tepasoli. Ax huelis incholose. Temachtli inyase ipan tlitl nepa mictla campa intlaijiyohuise. ");
INSERT INTO nheNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Huajca nimechtitlanilis tiocamanalohuani, huan tlalnamijca tlacame, huan tlamachtiani. Sequin inquinmictise, sequin inquincuamapeloltise huan sequin inquinhuitequise tiopan calijtic, huan sequin inquintotocatinemise tlen se altepetl hasta seyoc para inquintlatzacuiltise. ");
INSERT INTO nheNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Huajca queja nopa inmechajsis nopa hueyi tlatzacuiltilistli tlen quinamiqui, huan inquihuicase tlajtlacoli pampa inquinmictijque nochi cuajcualme hasta quema mijqui Abel achtohui huan hasta teipa quema inquimictijque Zacarías icone Berequías tlatlajco tiopamitl huan tlaixpamitl. ");
INSERT INTO nheNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nelía nimechilhuía nochi ni tlatzacuiltilistli inmechajsis imojuanti tlen ama initztoque. ");
INSERT INTO nheNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Inteicneltijque inJerusalén ehuani! Inquinmictíaj itiocamanalojcahua Toteco huan inquintepachohuaj tlen Toteco inmechtitlanilía. Nelía miyac huelta nijnequiyaya nimechsentilis nomaco queja se tenanpiyo quinsentilía ipilconehua huan quinpachohua ica ieltlapal, pero ax inquinejque. ");
INSERT INTO nheNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Huajca xijtlachilica imotiopa eltoc queja se cali tlen tlatzitzica pampa Toteco ayoc itztoc nopano. ");
INSERT INTO nheNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Huan nelía nimechilhuía ayoc innechitase hasta nopa tonal quema innechilhuise: ‘Ma Toteco quitiochihua ya ni tlen huala ipan itoca .’ ” ");
INSERT INTO nheNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Huan quema Jesús quisayaya ipan nopa hueyi tiopamitl para yas, tiimomachtijcahua timonechcahuitoj huan tijmanextijque nopa huejhueyi caltini tlen iaxca tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Huan Jesús techilhui: ―Inquiitaj nochi ni huejhueyi tiopan caltini tlen eltoc nica. Nelía nimechilhuía, ajsis se tonal quema tlacame quixolehuase nochi huan niyon se tetl ax mocahuas campa eltoya. ");
INSERT INTO nheNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Teipa Jesús mosehuito ipan nopa tepetl tlen itoca Olivos iixmelac tiopamitl. Huan iyoca tiimomachtijcahua timonechcahuitoj huan tiquilhuijque: ―Xitechilhui quema quixolehuase nopa tiopamitl. Huan xitechilhui tlachque tlanescayotl oncas quema timocuepas huan nechcatitos para tlamis ni tonali. ");
INSERT INTO nheNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Huan Jesús techilhui: ―Ximotlachilica para axaca ma inmechcajcayahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pampa miyac tlacame hualase huan quiijtose: ‘Na niCristo.’ Huan quincajcayahuase miyac. ");
INSERT INTO nheNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Huan inquicaquise para onca tlatehuijcayotl o inquicaquise para nechca pehuas se tlatehuijcayotl. Pero amo ximajmahuica pampa monequi panos nochi ni tlamantli. Pero ya ni ax quiijtosnequi para itlamiya. ");
INSERT INTO nheNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tlacame ipan tlaltini campa hueli motlalanase huan motehuise tlacame ipan sequinoc tlaltini. Tlanahuatiani huan ininsoldados tlatehuise ininhuaya sequinoc tlanahuatiani huan ininsoldados. Oncas cocolistli tlen fiero, huan hueyi mayantli huan campa hueli mojmolinis tlali. ");
INSERT INTO nheNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pero ica nochi ni tlamantli sanoc pehua nopa fiero tlamantli tlen tlacame quiijiyohuise. ");
INSERT INTO nheNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Huan huajca, quena, inmechtemactilise para sequinoc ma inmechtlatzacuiltica huan inmechmictise. Tlacame tlen nochi tlaltini inmechcocolise pampa innechneltocaj . ");
INSERT INTO nheNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Huan ipan nopa tonali miyac tlen nechneltocaj, nechcajtehuase huan pehuase mococolise huan motemactilise ica ax cuajcualme. ");
INSERT INTO nheNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","“Huan motlalanase miyac tlen quiijtose para yajuanti elij itiocamanalojcahua Toteco, pero ax neli, huan quincajcayahuase miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Momiyaquilise tlacame tlen ax quintlepanitase tlen quipiya tlanahuatili huan tlahuel miyac tlajtlacolchihuase. Huan miyac tlacame tlen quineltocaj Toteco ayoc quiicnelise queja achtohui. ");
INSERT INTO nheNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ajqueya quiijiyohuis nochi tlen panotihualas hasta itlamiya tonali, nijmaquixtis. ");
INSERT INTO nheNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huan tlacame tlacamahuitij ni cuali tlamachtili tlen quejatza eltos quema Toteco tlanahuatía. Huan quihuicase hasta campa hueli techaj ipan nochi tlaltini ipan ni tlaltepactli para nochi tlacame ma quimatica. Huan teipa hualas itlamiya nochi tlen onca. ");
INSERT INTO nheNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Huan ajsis se tonal quema inquiitase panos tlen nopa tiocamanalojquetl Daniel quiijto panosquía. Yajaya quiijto quiquetzase tlen tlahuel fiero ipan nopa cuarto tlen Más Tlatzejtzeloltic ipan nopa hueyi tiopan calijtic para quitlamiijtlacos huan quichihuas tlahuel ax tlapajpactic nepa. (Imojuanti tlen inquipohuaj ya ni, xijmachilica tlachque quiijtosnequi.) ");
INSERT INTO nheNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Huajca quema panos ya ni, nochi tlen itztose ipan estado Judea ma choloca ipan tepetini. ");
INSERT INTO nheNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huan tlen itztos icalpani ma amo calaquis sampa ipan ichaj para quicuis se tlenijqui, san ma temos huan ma cholos nimantzi. ");
INSERT INTO nheNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Huan tlen tequiti imila, ma ax mocuepas para quicuiti itlaque, san ma moisihuilti para cholos. ");
INSERT INTO nheNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Pero teicneltzitzi sihuame tlen conehuejque huan tlen quinchichitíaj coneme ipan nopa tonali! ");
INSERT INTO nheNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xijtlajtlanica Toteco para ma ax panos ni tlamantli quema tlaseseya o ipan se tonal para timosehuise pampa más ohui incholose. ");
INSERT INTO nheNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Pampa oncas se hueyi tlaijiyohuilistli queja tlen ax quema oncatoc hasta quema pejqui tlaltepactli. Huan ax quema oncas seyoc quej ni. ");
INSERT INTO nheNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Intla Toteco ax quichihuasquía cototzi nopa tonali tlen tlaijiyohuilistli, nochi miquisquíaj. Pero yajaya quichihuas nopa tonali ma eli cototzi pampa quinicnelía nopa tlacame tlen quintlapejpenijtoc. ");
INSERT INTO nheNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Huajca intla inmechilhuise: ‘Nica itztoc Cristo’, o quiijtose: ‘Nepa itztoc’, amo xiquinneltocaca. ");
INSERT INTO nheNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pampa hualase miyac tlacajcayahuani tlen quiijtose yajuanti Cristo, o yajuanti tiocamanalohuani. Huan quichihuase huejhueyi tlanescayotl huan chicahualnescayotl para intla huelisquía quincajcayahuasquíaj. Hasta quincajcayahuasquíaj yajuanti tlen Toteco quintlapejpenijtoc intla huelis. ");
INSERT INTO nheNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Xiquitaca, ya nimechilhuijtoc ama nochi tlen panos teipa. ");
INSERT INTO nheNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Huajca intla inmechilhuise: ‘Xiquitatij Cristo itztoc ipan huactoc tlali’, amo xiyaca. Huan intla inmechilhuise: ‘Xiquitatij Cristo itztoc calijtic’, amo xiquinneltocaca. ");
INSERT INTO nheNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pampa quema na tlen niMocuepqui Tlacatl nihualas, nochi nechitase. Eltos queja quema onca se chicahuac tlapetlanilotl tlen quisa campa quisa tonati huan yohui hasta campa oncalaqui tlen nochi huelij quiitaj. Huan ihuical elis ipan nopa tonal quema nihualas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Queja nochi quiitaj quema mosentilíaj tzopilome campa huetztoc se mijcatzi, nochi quiitase quema nihualasoc. ");
INSERT INTO nheNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Huan nimantzi quema panotos nopa hueyi tlaijiyohuilistli, tonati tzintlayohuas huan metztli ayoc tlahuis. Huan sitlalime huetzise tlen elhuicac, huan nochi chicahualistli tlen eltoc ipan elhuicactli huihuipicase. ");
INSERT INTO nheNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Huajca ipan elhuicactli monextis notlanextilis para na tlen niMocuepqui Tlacatl nihuala. Huan nochi tlacame tlen camatij nochi tlamantli tlajtoli ipan tlaltepactli tlahuel chocase quema nechitase. Huan nihualajtihualas ipan mixtli tlen elhuicactli ica nohueyi chicahualis huan ica notlatlanex. ");
INSERT INTO nheNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Huan na niquintitlanis noelhuicac ejcahua ica tlapitzali huan yajuanti quinsentilise tlen Toteco quintlapejpenijtoc tlen campa hueli ipan tlaltepactli huan elhuicactli. ");
INSERT INTO nheNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Xijmachilica tlen nimechilhuía ipan ni huicaltili. Quema moseliltía se higuera cuahuitl huan pehua quisa ixihuiyo, huajca inquimatij para monechcahuía tonali para tlatotoniyas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Huajca nojquiya quema inquiitase nochi ni tlamantli, xijmachilica monechcahuía nopa tonal para nimocuepas. Huan ya nimonechcahuijtos campa puerta. ");
INSERT INTO nheNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nelía nimechilhuía, tlacame tlen quiitase panos ni tlamantli tlen nimechilhuía, ax miquise hasta nihualas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Elhuicactli huan tlaltepactli panotehuas, pero notlajtol nochipa motlamichijtiyas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Pero axaca quimati tlachque tonal, niyon tlachque hora nimocuepas. Ax quimatij nopa elhuicac ehuani tlen elhuicac, huan niyon na niIcone ax nijmati, san noTata, quena. San yajaya quimati. ");
INSERT INTO nheNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Pampa quema na tlen niMocuepqui Tlacatl nihualas, nochi eltos queja eltoya ipan nopa tonali quema Noé itztoya huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pampa ipan nopa tonali quema aya hualayaya nopa tlahuelatl, tlacame tlacuayayaj huan tlaiyayaj. Sequin mosihuajtiyayaj huan sequinoc quisencahuayayaj para iniichpocahua ma monamictica. Nochi quichihuayayaj tlen ipa quichihuaj hasta nopa tonal quema Noé calajqui ipan nopa cuacanahua. ");
INSERT INTO nheNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ax tleno quimatiyayaj tlen ininpantisquía hasta quema hualajqui nopa tlahuelatl huan quinhuicac. Quej nopa axaca quimatis achtohui quema na tlen niMocuepqui Tlacatl, nimocuepas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ome tlacame tequititose ipan se mili huan Toteco tlatitlanis ma quihuicaca se tlen nopa ome huan nopa seyoc quicajtehuas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ome sihuame tistose san sejco campa tisij huan Toteco tlatitlanis ma quihuicaca se, huan nopa seyoc quicajtehuas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Huajca xitlachixtoca pampa ax inquimatij ipan tlachque tonal niimoTeco sampa nihualasoc. ");
INSERT INTO nheNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ximoilhuica tlen ni tlacatl ipan ichaj. Intla quimajtosquía ipan tlachque hora ica tlayohua hualasquía nopa tlaxtejquetl, huajca tlachixtosquía huan ax quicahuilisquía ma calaqui ipan ichaj para tlaxtequis. ");
INSERT INTO nheNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Huajca imojuanti nojquiya, xitlachixtoca pampa na tlen niMocuepqui Tlacatl nihualasoc ipan se hora quema ax innechchiyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ximoilhuica catlía itlatequipanojca se tecojtli quitequimacas para quinyacanas nochi sequinoc ipan ichaj huan para quintlamacas quema ajsis hora. Quema quisas para huejca yas, quitequimacas se tlalnamijca tlatequipanojquetl tlen nelía temachtli. ");
INSERT INTO nheNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Huan nelía paquis nopa tlatequipanojquetl tlen iteco quipantis tequiti cuali quema mocuepas. Huan san se Toteco quitiochihuas tlen quinpantis tequiti cuali quema nimocuepas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nelía nimechilhuía, quitequimacas para ma quimocuitlahuis nochi tlen iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero fiero elis para se tlayacanca tlatequipanojquetl tlen pehua moilhuía ipan iyolo tlen ax cuali huan quiijtos para huejcahuas iteco para mocuepas. ");
INSERT INTO nheNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Huelis pehuas quinmaquilis nopa sequinoc tlatequipanohuani huan pehuas tlacuajtinemis huan tlaitinemis ininhuaya ihuintini. ");
INSERT INTO nheNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Huan teipa iteco mocuepas ipan se tonal quema nopa ax cual tlatequipanojquetl ax quichiya huan ipan se hora quema ax moilhuía. ");
INSERT INTO nheNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Huan iteco tlahuel quitlatzacuiltis huan quihuicas campa itztoque tlen ome ininxayac. Nepa chocas huan tlanhuehuechocas pampa tlahuel tlaijiyohuis. Huan quema nimocuepas, na nojquiya nijchihuas ica tlen ax temachme queja nopa tecojtli quichijqui. ");
INSERT INTO nheNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Huelis tiquinhuicaloltise tlacame tlen quinequij calaquise campa tlanahuatía Toteco tlen itztoc elhuicac ica tlen ininpantis ni ichpocame. Itztoyaj majtlacme ichpocame tlen quicuique inintlahuil huan yajque ihuaya nopa ichpocatl para quichiyase hasta quema hualasquía itlaijtlanil huan quihuicasquía para monamictise. ");
INSERT INTO nheNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Huan macuilti eliyayaj tlalnamijca ichpocame huan macuilti huihuitique. ");
INSERT INTO nheNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Huan nopa macuilti tlen huihuitique quihuicaque inintlahuil, pero ax quihuicaque aceite para sampa quitemitise para ma tlahuijtos seyohual. ");
INSERT INTO nheNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero nopa macuilti tlen motlalnamictijque, quena. Quihuicaque inintlahuil, pero nojquiya iyoca quihuicaque más aceite. ");
INSERT INTO nheNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Huan nopa mosihuajtijquetl ax hualajqui nimantzi huan nochi nopa ichpocame cochisnejque huan pejque cochij. ");
INSERT INTO nheNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Huan tlajco yohual quicajque tzajtzi tlen quiyacanayaya nopa mosihuajtijquetl, quiijtohuayaya: ‘Ya hualahua ne mosihuajtijquetl, xihualaca xijnamiquica.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Huajca nochi nopa ichpocame mejque, huan tlen quihualicaque más aceite quitemitijque inintlahuil huan quicualtlalijque imechajyo nopa tlahuiltini para yase ipan tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Huan nopa ichpocame tlen huihuitique quinilhuijque tlen tlalnamiquini: ‘Xitechmacaca quentzi imoaceite pampa totlahuil sehuisnequi.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Pero nopa tlalnamijca ichpocame quinilhuijque: ‘Axtle, pampa ax techaxilis para tojuanti huan imojuanti hasta tlanesis intla timechmacase. Más cuali xiyaca xijcohuatij tlen inquitequihuise.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Huajca yajuanti yajque quicohuatoj. Huan ipan nopa tlalochtli ajsico nopa telpocatl huan nopa ichpocame tlen mocualtlalijtoyaj yajque ihuaya. Huan nochi calaquitoj ipan nopa tlacualistli tlen nenamictili huan caltzajque. ");
INSERT INTO nheNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Teipa nopa sequinoc ichpocame tlen ax quipixtoyaj aceite tlanojnotzque: ‘Tate, tate, xitechcaltlapo.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Pero nopa mosihuajtijquetl quinnanquili: ‘Nelía nimechilhuía, ax nimechixmati.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Quej nopa nojquiya elis quema nimocuepas, huajca xitlachixtoca pampa ax inquimatij tlachque tonal, niyon tlachque hora, na tlen niMocuepqui Tlacatl nihualas. ");
INSERT INTO nheNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Huelis tijhuicalotise itlanahuatilis Toteco tlen itztoc elhuicac, ica ni tlacatl tlen nimechpohuilis. Se tlacatl mocualtlaliyaya para quisas para yas huejca. Huan quinnotzqui itlatequipanojcahua huan quinmacac itomi para ma quitequihuise quema yajaya ax aquisquía. ");
INSERT INTO nheNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","“Huan nopa tecojtli quinmacac sesen nopa tomi queja moilhui iniyajatil para huelis quitequihuisquíaj. Se quimacac macuili bolsas tlen tomi, huan seyoc quimacac ome bolsas tlen tomi, huan seyoc quimacac se bolsa. Teipa quisqui huan yajqui huejca. ");
INSERT INTO nheNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Huan nopa tlatequipanojquetl tlen quiselijtoya macuili bolsas tlen tomi nimantzi yajqui quitequihuito nopa tomi para tlacohuas huan tlanamacas. Huan quema panotiyajqui tonali, quitlanqui seyoc macuili bolsas. ");
INSERT INTO nheNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Huan nopa tlatequipanojquetl tlen quiselijtoya ome bolsas tlen tomi nojquiya quitequihui nopa tomi para tlacohuas huan tlanamacas huan quema panotiyajqui tonali, quitlanqui seyoc ome bolsas. ");
INSERT INTO nheNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero nopa tlen san quiselijtoya se bolsa tlen tomi, ax ya nopa quichijqui. Yajaya yajqui tlaxahuato huan quitlalpacho nopa tomi tlen iteco quimacatoya. ");
INSERT INTO nheNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Huan quema ya panotoya miyac tonali, nopa tecojtli mocuepqui para quichihuas cuentas ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Huan hualajqui nopa tlacatl tlen quiselijtoya macuili bolsas tlen itomi huan quimacac nopa tomi huan nojquiya quimacac nopa seyoc macuili tlen ya quitlantoya. Huan ne tlatequipanojquetl quiilhui: ‘Noteco, tinechcahuilijtejqui macuili bolsas motomi, huan xiquita ya nijtlantoc seyoc macuili bolsas.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Huan nopa tecojtli quiilhui: ‘Nelía cuali. Ta tinotlatequipanojca tlen temachtli. Cuali tinechtequipano ica nopa quentzi tlen nimitzmacac. Huajca ama miyac más nimitzcahuilis momaco. Xicalaqui nochaj nohuaya huan nochipa ma tipaquica san sejco.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Huan hualajqui nopa tlacatl tlen quiselijtoya ome bolsas tlen tomi huan quiilhui: ‘Noteco, tinechmacac ome bolsas motomi huan ya nijtlanqui seyoc ome bolsas.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Huan iteco quiilhui: ‘Nelía cuali. Tinotlatequipanojca tlen temachtli. Cuali tinechtequipano ica nopa quentzi tlen nimitzmacac. Huajca ama miyac más nimitzcahuilis momaco. Xicalaqui nochaj nohuaya huan nochipa ma tipaquica san sejco.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Huan yajaya tlen quiselijtoya se bolsa itomi iteco hualajqui huan quiilhui nopa tecojtli: ‘Noteco, na nijmatqui para chicahuac titlanahuatía. Timoaxcatía tomi tlen ax tijtlantoc huan tijpixca campa ax tijtoctoc. ");
INSERT INTO nheNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Yeca nimitzimacasqui huan niyajqui nijtlalpachoto motomi. Xiquita nica eltoc motomi.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Huan iteco quiilhui: ‘Ta tifiero tlatequipanojquetl. Nelía titlatzihui. Tijmatqui nimoaxcatía tomi tlen ax nijtlantoc huan nipixca campa ax nijtoctoc. ");
INSERT INTO nheNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Huajca tijtlalijtosquía notomi ipan se banco para nechmacatosquíaj itlapanca quema nimocuepqui.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Huajca nopa tecojtli quiilhui seyoc: ‘Xijquixtili nopa bolsa notomi tlen nijcahuilijtejqui imaco huan xijmaca yajaya tlen quipiya majtlactli bolsas. ");
INSERT INTO nheNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Pampa se tlen cuali quitequihuía nopa tlen quipiya yonque miyac, iteco quimacas más. Huan se tlen ax quitequihuía cuali tlen quipiya, yonque quentzi quipiya, iteco quiquixtilis nopa quentzi tlen quipixtoya. ");
INSERT INTO nheNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Huan ni tlatequipanojquetl tlen ax quitequihui tlen quipixqui, xijmajcahua campa tlahuel onca tzintlayohuilotl, campa tlacame chocaj huan tlanhuehuechocaj pampa tlahuel tlaijiyohuíaj.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Na tlen niMocuepqui Tlacatl sampa nihualas ipan tlaltepactli ipan tlatlanextli huan nohuaya hualase nochi nopa tlatzejtzeloltijca elhuicac ehuani. Huan quema nihualas, nimosehuis ipan nosiya tlen yejyectzi huan nitetlajtolsencahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Huan mosentilise noixtla nochi tlacame tlen nochi tlaltini. Huan na niquiniyocatlalis tlen cualme huan tlen ax cualme queja se tlamocuitlahuijquetl quiniyocatlalía borregojme huan chivojme. ");
INSERT INTO nheNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Huan nopa borregojme niquintlalis ipan nonejmatl huan nopa chivojme ipan noarraves. ");
INSERT INTO nheNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Huan na nitlanahuatijquetl niquinilhuis nopa tlacame tlen itztose ipan nonejmatl: ‘Xihualaca imojuanti tlen noTata inmechtiochijtoc. Xicalaquica campa tlanahuatía noTata, pampa huejcajquiya quema aya oncayaya tlaltepactli, quisencajqui nopa cuajcuali tlamantli tlen para teipa inquiselise. ");
INSERT INTO nheNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pampa nimayanayaya huan innechtlamacaque. Huan niamiquiyaya huan innechamacaque. Huan niitztoya se tlen ax moaltepe ejca, pero innechselijque ipan imochajchaj. ");
INSERT INTO nheNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ax nijpiyayaya tlen nimoquentis huan innechmacaque noyoyo. Nimococohuayaya huan innechmocuitlahuitoj. Niitztoya ipan tlatzactli huan inyajque innechitatoj.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Huan teipa nopa tlen xitlahuaque iixtla Toteco nechtlajtlanise: ‘Toteco, ¿quemaya timitzitaque timayanayaya huan timitztlamacaque, o quema tiamiquiyaya huan timitzamacaque? ");
INSERT INTO nheNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Huan ¿quemaya timitzpantijque queja se tlen ax toaltepe ejca, pero timitzselijque ipan tochajchaj, o ax tijpiyayaya moyoyo huan timitzyoyontijque? ");
INSERT INTO nheNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Huan ¿quemaya timococohuayaya o tiitztoya ipan tlatzactli huan timitzitatoj?’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Huan na niTlanahuatijquetl niquinilhuis: ‘Nelía nimechilhuía, quema inquipalehuiyayaj se tlen ni noicnihua tlen teicneltzitzi, niquitac queja elisquía para na innechpalehuiyayaj.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Huan teipa niquinilhuis yajuanti tlen itztoque ipan noarraves: ‘Xinechtlalcahuica inaxcuajcualme. Xiyaca ipan nopa tlitl tlen ax quema sehuis tlen Toteco quisencajtoc para Axcualtlacatl huan iajacahua. ");
INSERT INTO nheNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pampa nimayanayaya huan ax tleno innechmacaque ma nijcua, huan niamiquiyaya huan ax innechamacaque. ");
INSERT INTO nheNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Huan niitztoya se tlen ax innechixmatiyayaj, huan ax innechselijque ipan imochajchaj. Innechitaque quema ax nijpiyayaya noyoyo para nimoquentis, huan ax innechmacaque noyoyo. Nimococohuayaya huan niitztoya ipan tlatzactli huan ax innechpalehuijque.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Huan yajuanti nojquiya nechtlajtlanise: ‘Toteco, ¿quemaya timitzitaque timayana, o tiamiqui, o ax timitzixmati, o ax tijpiya moyoyo? ¿Quemaya timitzitaque timococohua o ipan tlatzactli huan ax timitzpalehuijque?’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Huan na niquinnanquilis: ‘Nelía nimechilhuía, pampa ax inquinpalehuijque ni noicnihua tlen teicneltzitzi, huajca niquita queja elisquía ax innechpalehuijque na.’ ");
INSERT INTO nheNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Huan nopa tlacame yase campa Toteco quintlatzacuiltis para nochipa, pero nopa tlacame tlen xitlahuaque iixtla Toteco yase elhuicac campa itztose para nochipa.” ");
INSERT INTO nheNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Quema Jesús tlanqui quiijtohua nochi ni tlajtoli, techilhui tiimomachtijcahua: ");
INSERT INTO nheNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Inquimatij san polihui ome tonali para nopa ilhuitl tlen itoca Pascua campa nechtemactilise na tlen niMocuepqui Tlacatl para ma nechcuamapeloltica. ");
INSERT INTO nheNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Huan ipan nopa tonal nojquiya nopa tlayacanca totajtzitzi huan nopa huehue tlacame tlen israelitame mosentilijque ipan ichaj Caifás, nopa hueyi totajtzi. ");
INSERT INTO nheNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Huan san sejco quisencajque quejatza huelis quicajcayahuase huan quiitzquise Jesús para quimictise. ");
INSERT INTO nheNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero quiijtohuayayaj: ―Ma ax tiquitzquica ipan ni ilhuitl pampa huelis moajcomanase nopa miyac tlacame huan techtehuise. ");
INSERT INTO nheNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Huan Jesús mocajtoya ipan altepetl Betania ipan ichaj Simón tlen achtohuiya tlacayo palantoya. ");
INSERT INTO nheNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Huan Jesús tlacuayaya campa mesa huan ajsico se sihuatl tlen quihualicayaya se tlaajhuiyacayotl tlen tlahuel patiyo ipan se lemete tlen quicoyonijtoya tlen se tetl itoca alabastro. Huan quitequili ipan itzonteco Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Huan quema tiimomachtijcahua tiquitaque, ticualanque huan tiquijtojque: ―¿Para tlen quinenpolohua ne tlaajhuiyacayotl tlen tlahuel patiyo? ");
INSERT INTO nheNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Hueltosquía tijnamacatosquíaj para miyac tomi huan tiquinmacatosquíaj tlen teicneltzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Huan Jesús quimatqui tlen tiquijtojque, huajca techilhui: ―Amo xijcuatotonica ni sihuatl pampa nechchihuilijtoc se cuali tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mojmostla itztose tlen teicneltzitzi imohuaya, pero na axtle. Ayoc huejcahuas niitztos imohuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ni sihuatl nechtequili ni tlaajhuiyacayotl pampa queja nopa quisencahua notlacayo para quema nechtlalpachose. ");
INSERT INTO nheNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nelía nimechilhuía, campa hueli ipan tlaltepactli campa tlacame tlacamanalose itlajtol Toteco, nojquiya teilhuise tlen ni sihuatl nechchihuilijtoc para nochi quiilnamiquise. ");
INSERT INTO nheNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Huan se tlen tojuanti tiimomachtijcahua Jesús tlen quitocaxtiyayaj Judas Iscariote, yajqui quinitato nopa tlayacanca totajtzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Huan quintlajtlani: ―¿Quesqui innechmacase intla nimechmactilis Jesús? Huan nopa tlayacanani quimacaque Judas treinta plata tomi. ");
INSERT INTO nheNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Huan ipan nopa hora Judas pejqui quitemolía quema huelis quitemactilis Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ipan nopa achtohui tonal tlen nopa ilhuitl, quema nochi quicuaj pantzi tlen ax quipiya tlasonejcayotl, tiimomachtijcahua tihualajque campa Jesús itztoya huan tijtlajtlanijque: ―¿Canque tijnequi ma tijsencahuaca nopa Pascua tlacualistli para nochi tijcuase? ");
INSERT INTO nheNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Huan Jesús techilhui: ―Xiyaca ne altepetl huan inquipantise se tlacatl huan inquiilhuise para niimotlamachtijca niquijtohua ya monechcahuía nohora. Xiquilhuica monequi nijcuas nopa Pascua tlacualistli nepa ichaj ihuaya nomomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Huan tiimomachtijcahua Jesús tiyajque campa Jesús techilhui huan tijsencajque nopa Pascua tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Huan quema tlayohuac, Jesús mosehui campa mesa tohuaya timajtlacme huan ome tiimomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Huan quema titlacuayayaj, yajaya techilhui: ―Nelía nimechilhuía, se tlen imojuanti nechtemactilis. ");
INSERT INTO nheNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Huan nochi tojuanti tlahuel timocuesojque huan pejqui tijtlajtlaníaj: ―¿Huelis na, noTeco? ");
INSERT INTO nheNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huan Jesús technanquili: ―Nechtemactilis yajaya tlen nohuaya quixolonía ipantzi ipan noplato. ");
INSERT INTO nheNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Melahuac monequi na tlen niMocuepqui Tlacatl nimiquis queja ijcuilijtoc ipan Itlajtol Toteco, pero teicnelti yajaya tlen nechtemactilis. Tlahuel hueyi nopa tlatzacuiltilistli tlen quiselis. Más cuali eltosquía para nopa tlacatl ax tlacajtosquía. ");
INSERT INTO nheNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Huan Judas tlen quitemactilisquía quitlajtlani Jesús: ―¿Huelis na, Tlamachtijquetl? Huan Jesús quinanquili: ―Quena, ta. ");
INSERT INTO nheNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Huan quema titlacuayayaj, Jesús quiitzqui se pantzi huan quitlascamatqui Itata huan quitlapanqui, huan techmajmacac tiimomachtijcahua huan techilhui: ―Xijcuica ni pantzi huan xijcuaca. Ni notlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Teipa quicuic se taza ica xocomecatl iayo huan quitlascamatqui Itata huan techmajmacac, techilhui: ―Nochi imojuanti xiquica ipan ni taza, ");
INSERT INTO nheNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","pampa ni noeso tlen nijtoyahuas para nijpehualtis nopa yancuic tlajtolsencahuali tlen Toteco quichihua ica tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Huan nimechilhuía, ayoc niquis xocomecatl iayo hasta nopa tonal quema san sejco yancuic tiquise nepa campa noTata tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Teipa quema titlanque tihuicaj se tiohuicatl, tiquisque huan tiyajque campa nopa tepetl tlen itoca Olivos. ");
INSERT INTO nheNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Huan Jesús techilhui: ―Nochi innechcajtehuase ni tlayohua pampa ijcuilijtoc ipan Itlajtol Toteco campa noTata quiijto: ‘Nijmictis nopa tlamocuitlahuijquetl huan iborregojhua mosemanase.’ Quej nopa quiijtohua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero teipa quema ya nimoyolcuitos, nimechtlayacancuilis hasta estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Huan Pedro quinanquili huan quiilhui: ―Yonque nochi sequinoc mitzcajtehuase, na ax quema nimitzcajtehuas. ");
INSERT INTO nheNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Huan Jesús quiilhui: ―Nelía nimitzilhuía, ni yohuali quema aya tzajtzi se cuapelech, tiquinilhuis tlacame expa para ax tinechixmati. ");
INSERT INTO nheNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Huan Pedro sampa quiilhui: ―Yonque monequi nimiquis mohuaya, ax quema niquijtos para ax nimitzixmati. Huan nochi tiimomachtijcahua no ya nopa tiquilhuijque. ");
INSERT INTO nheNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Huan Jesús techhuicac hasta campa itoca Getsemaní huan techilhui tiimomachtijcahua: ―Ximosehuica nica huan na niya nimomaijtoti. ");
INSERT INTO nheNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Huan Jesús quinhuicac Pedro huan nopa ome imomachtijcahua tlen eliyayaj itelpocahua Zebedeo. Huan yajaya pejqui tlahuel miyac mocuesohua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huan quinilhui nopa eyi: ―Tlahuel nimoyolcuesohua hasta nijmachilía huelis nimiquis amantzi san ica cuesoli. Ximocahuaca nica. Xitlachixtoca nohuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Huan Jesús yajqui se quentzi iniixmelac huan motlancuaixtlapacho tlalchi huan pejqui momaijtohua huan quiijto: “Papá, intla tihuelisquía, xinechquixtilis ni tlaijiyohuilistli tlen hualas para ma ax nechajsi. Pero amo xijchihua tlen na nijnequi, san xijchihua tlen ta mopaquilis.” ");
INSERT INTO nheNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Huan quema tlanqui momaijtohua ica Itata, mocuepqui campa itztoyaj nopa eyi imomachtijcahua huan quinpanti cochtoque. Huajca Jesús quiilhui Pedro: ―¿Ax inhuelque intlachixque nohuaya para se hora? ");
INSERT INTO nheNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xitlachixtoca huan ximomaijtoca para ma ax inmechyoltilana tlajtlacoli. Imotonal quinequi quichihuas tlen nimechnahuatía, pero imotlacayo ax quipiya tetili. ");
INSERT INTO nheNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Huan Jesús sampa yajqui se quentzi. Huan momaijto huan quiijto: “Papá, intla ax tihueli tinechijcuenilis ni tlaijiyohuilistli huan monequi nitlaijiyohuis, xijchihua tlen ta mopaquilis.” ");
INSERT INTO nheNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Huan sampa mocuepqui Jesús campa nopa eyi imomachtijcahua huan quinpanti cochtoque pampa nelía cochisnequiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Huan sampa quincajtejqui huan sampa yajqui momaijtoto ica expa. Huan sampa quiilhui Itata tlen quiilhui achtohuiya. ");
INSERT INTO nheNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Huan sampa mocuepqui campa imomachtijcahua, huan quinilhui: ―¿Noja incochtoque huan inmosiyajcahuaj? Xiquitaca, ya ajsic hora para tlacame nechtemactilise na tlen niMocuepqui Tlacatl ininmaco ax cuajcualme. ");
INSERT INTO nheNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ximoquetzaca huan ma tiyacajya. Xiquitaca, ya huala yajaya tlen nechtemactilía. ");
INSERT INTO nheNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Huan quema Jesús noja camatiyaya, ajsico Judas se tlen timajtlacme huan ome tiimomachtijcahua. Yajaya hualajqui ininhuaya miyac tlacame tlen quihualicayayaj machetes huan cuahuitl tlen quintitlantoyaj nopa tlayacanca totajtzitzi huan nopa huehue tlacame tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Huan Judas tlen quitemactiliyaya Jesús, ya quinmacatoya nopa tlacame se tlanextili para ajqueya quitzoponisquía, yajaya elisquía Jesús tlen quitemohuayayaj, huajca ma quiitzquica. ");
INSERT INTO nheNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Huajca Judas nimantzi monechcahuico campa Jesús huan quiilhui: ―Ya tlapoyahui, Tlamachtijquetl. Huan quitzoponi. ");
INSERT INTO nheNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Huan Jesús quiilhui: ―Nohuampo, xijchihua tlen tihualajtoc para tijchihuas. Huan nopa tlacame monechcahuijque huan quiitzquijque Jesús, huan quihuicaque. ");
INSERT INTO nheNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Huan se imomachtijca Jesús tlen itztoya ihuaya quiquixti imachete, huan quimaquili itlatequipanojca nopa hueyi totajtzi huan quitzontequili inacas. ");
INSERT INTO nheNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Huajca Jesús quiilhui: ―Xijcalaqui momachete ipan icuetlaxo pampa tlen tlatehuíaj ica machete, nojquiya quinmictise ica machete. ");
INSERT INTO nheNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¡Huelis ax inquimatij! Na nihuelisquía nimomaijtosquía ica noTata huan yajaya nimantzi nechtitlanilisquía pano setenta mil ielhuicac ejcahua para nechmanahuise. ");
INSERT INTO nheNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero intla queja nopa nijchihuas, ax panos queja ijcuilijtoc ipan Itlajtol Toteco. Huan monequi ma pano tlen quiijtohua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Huan teipa Jesús quinilhui nopa tlacame tlen hualajtoyaj: ―¿Para tlen inhualajtoque nica para innechitzquise ica machetes huan ica cuahuitl queja nielisquía se tlaxtejquetl? Mojmostla nitlamachtiyaya ipan nopa hueyi tiopamitl huan ax quema innechitzquijque. ");
INSERT INTO nheNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Yonque ax inquimatij pano nochi ni tlamantli tlen inquichihuaj ipan ni tonali para ma motlamichihua tlen itiocamanalojcahua Toteco quiijcuilojque huejcajquiya ipan Itlajtol Toteco para panos. Huan nochi tiimomachtijcahua tijcajtejque huan ticholojque. ");
INSERT INTO nheNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Huan nopa tlacame tlen quiitzquijque Jesús quihuicaque ichaj Caifás, nopa hueyi totajtzi. Huan mosentilijtoyaj nopano nopa tlamachtiani tlen itlanahuatil Moisés huan nopa huehue tlacame tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Huan Pedro nojquiya quinhuejcatoquilijtiyajqui hasta ajsitoj campa puerta tlen calaqui ipan icalixpa Caifás. Huan Pedro nojquiya calajqui, mosehuito ininhuaya tlatequipanohuani para quiitas tlachque panosquía. ");
INSERT INTO nheNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Huan nopa tlayacanca totajtzitzi huan huehue tlacame tlen israelitame huan nochi nopa tlasentilistli tlen tequihuejme tlen más hueyi quitemohuayayaj se para tlatestigojquetzas ica se istlacaticayotl para ica huelis quiteilhuisquíaj Jesús. Huan queja nopa huelisquía quitemactilisquíaj para ma miqui. ");
INSERT INTO nheNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Huan ax tleno quipantijque tlen ica huelis quiteilhuisquíaj yonque miyac testigos quiijtojque para quiistlacahuisquíaj, pero ax san se elqui inintlajtol huajca ax ipati eliyaya. Pero teipa ome tlacame moquetzque, ");
INSERT INTO nheNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","huan quiijtojque: ―Ni tlacatl Jesús quiijto para huelis quixolehuas itiopa Toteco huan sampa quichihuas ica eyi tonali. ");
INSERT INTO nheNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Huan nopa hueyi totajtzi moquetzqui huan quitlajtlani Jesús: ―¿Ax tleno titlananquilía? ¿Tiquijto tlen ica mitzteilhuíaj o ax tiquijto? ");
INSERT INTO nheNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Huan Jesús ax molini. Huan nopa hueyi totajtzi quiilhui: ―Nimitznahuatía xijtestigojquetza Toteco Dios tlen itztoc. Huan xitechilhui intla tiIcone Toteco huan intla tiCristo tlen Toteco quiijto techtitlanilisquía. ");
INSERT INTO nheNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Huan Jesús quiilhui: ―Quena, na niCristo. Huan nojquiya nimitzilhuía, teipa innechitase na tlen niMocuepqui Tlacatl quema nimosehuijtos inejmatl Toteco Dios tlen quipiya nochi chicahualistli. Huan innechitase quema nihualasoc ipan mixtli tlen elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Huajca nopa hueyi totajtzi quitzayanqui iyoyo para quinextilis para tlahuel temajmati ica tlen Jesús quiijto. Huajca quinilhui nopa sequinoc: ―Xijcaquica, yajaya mochihua queja Toteco Dios pampa niyon quentzi ax quipatiita. ¿Para tlen monequi más testigos? Inquicactoque para mochihua yajaya Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Tlachque tlatzacuiltilistli inmoilhuíaj quinamiqui para quiselis? Huan quinanquilijque: ―Monequi ma miqui. ");
INSERT INTO nheNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Huajca quiixchajchaque, huan quimaquilijque ica ininmaolol. Huan sequinoc quiixtlajtlatzinijque ");
INSERT INTO nheNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","huan quiilhuijque: ―Intla nelía ta tiCristo, xicamati queja se tiocamanalojquetl huan xitechilhui ajqueya mitzmaquilía. ");
INSERT INTO nheNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Huan Pedro noja mosehuijtoya calixpa huan se ichpoca tlatequipanojquetl quinechcahuico huan quiilhui: ―Ta nojquiya tiitztoya ihuaya Jesús nopa estado Galilea ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Huan Pedro istlacatqui iniixtla nochi tlen itztoyaj nepa. Quiijto: ―Axtle, ax nijmati tlachque tiquijtohua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Huan Pedro yajqui calteno campa puerta huan seyoc ichpoca tlatequipanojquetl quiitac huan quinilhui nochi tlen mosehuijtoyaj nopano: ―Nojquiya ni tlacatl itztoya ihuaya Jesús, nopa altepetl Nazaret ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huan Pedro sampa quiijto para axtle, huan quitestigojquetzqui Toteco huan quiijto: ―Ax niquixmati ne tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Huan quentzi teipa monechcahuicoj campa Pedro nopa tlacame tlen itztoyaj nopano huan quiilhuijque: ―Nelía ta tiitztoya se tiimomachtijca pampa queja ticamati mitznextía canque tiehua. ");
INSERT INTO nheNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Huan Pedro pejqui tlatelchihua huan quitestigojquetza Toteco huan quiijto: ―Ax niquixmati ne tlacatl. Huan nimantzi tzajtzic se cuapelech. ");
INSERT INTO nheNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Huajca Pedro quiilnamijqui tlen Jesús quiilhui para quema aya tzajtzi se cuapelech, Pedro quinilhuisquíaj tlacame expa para ax quiixmati. Huajca Pedro quisqui huan tlahuel chocac. ");
INSERT INTO nheNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Huan quema tlanesqui, nochi nopa tlayacanca totajtzitzi huan huehue tlacame tlen israelitame quisencajque quejatza quichihuasquíaj para quifuerzajhuise nopa hueyi tequihuejquetl ma tlanahuatis para monequi miquis Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huan nopa soldados quiilpijque Jesús huan quihuicaque iixtla gobernador Poncio Pilato. ");
INSERT INTO nheNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Huan quema Judas tlen quitemactilijtoya quiitac para yajuanti quitemactiliyayaj Jesús para ma miqui, tlahuel mocueso ica tlen quichijtoya. Huan quihuicac nopa treinta plata tomi, huan quincuepili nopa tlayacanca totajtzitzi huan huehue tlacame tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Huan quinilhui: ―Nitlajtlacolchijtoc pampa nimechtemactilijtoc yajaya tlen ax quipiya tlajtlacoli. Pero yajuanti quinanquilijque: ―Para tojuanti ax tocuenta. Ta tijmati. ");
INSERT INTO nheNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Huan Judas quitepejqui nopa plata tomi tiopan calijtic. Teipa quistejqui huan yajqui mocuahuiyonito hasta mijqui. ");
INSERT INTO nheNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Huan nopa tlayacanca totajtzitzi quicuique nopa plata tomi huan quiijtojque: ―Ax cuali para tijmanelose ni tomi ihuaya ne seyoc ipan tiopan caja pampa ica ni tomi tijtlaxtlahuijque tlen techtemactili Jesús para ma miquis, huajca ni tomi quihuica estli. ");
INSERT INTO nheNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Teipa quisencajque tlachque quichihuasquíaj ica nopa tomi huan quicojque itlal se chachapalchijquetl para nopano quintlalpachosquíaj tlen seyoc tlali ehuani. ");
INSERT INTO nheNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Huajca nopa tlali quitocaxtijque Tlali tlen Estli. Huan queja nopa itoca hasta ama. ");
INSERT INTO nheNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Huajca ya ni quitlamilti tlen nopa tiocamanalojquetl Jeremías huejcajquiya quiijcuilo para teipa panos. Yajaya quiijto: “Nopa israelita tlacame quipatitlalise ica treinta plata tomi para ya nopa quiixtlahuasquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Teipa quicuise nopa tomi huan ica quicohuase itlal se chachapalchijquetl pampa queja nopa Toteco quinnahuatis ma quichihuaca.” ");
INSERT INTO nheNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Huan Jesús moquetztoya iixtla gobernador huan yajaya quitlajtlani: ―¿Ta tiinintlanahuatijca israelitame? Huan Jesús quinanquili: ―Quena, na. ");
INSERT INTO nheNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Huan quema nopa tlayacanca totajtzitzi huan nopa huehue tlacame tlen israelitame quiteilhuiyayaj Jesús iixtla nopa gobernador, yajaya ax molini. ");
INSERT INTO nheNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Huajca Pilato quitlajtlani Jesús: ―¿Ax tijcaqui ica quesqui tlamantli mitzteilhuíaj? ");
INSERT INTO nheNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero noja Jesús ax tleno tlananquili, huan yeca nelía quisentlachili nopa gobernador. ");
INSERT INTO nheNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sesen xihuitl ipan nopa Pascua ilhuitl, Gobernador Pilato momajtoyaya quiquixtía se tlen tzactoc ipan tlatzactli para quimajcahuas. Huan quiquixtisquíaj ajqueya nopa miyac tlacame quitlapejpenisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Huan ipan nopa tonali itztoya ipan tlatzactli se tlacatl tlen nochi quiixmatiyayaj para fiero iyolis huan itoca eliyaya Barrabás. ");
INSERT INTO nheNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Huajca mosentilijque nopa miyac tlacame, huan Pilato quintlajtlani: ―¿Ajqueya inquinequij ma nimechmalacanilis para yas ichaj? ¿Nimechtojtomilis Barrabás o ni Jesús tlen tlacame quitocaxtíaj nopa Cristo? ");
INSERT INTO nheNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato quiijto ya ni pampa quinequiyaya quimalacanis Jesús. Quimatqui nopa tlayacanani san quihualiquilijque pampa moxicohuayayaj ica ya pampa nochi tlacame quitoquiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Huan quema Pilato mosehuijtoya ipan isiyaj ipan nopa lugar para tetlajtolsencahuas, isihua quititlanili se tlajtoli huan quiilhui: “Amo tleno xijchihuili Jesús pampa yajaya se tlacatl xitlahuac. Tlayohua niquitac tlamantli fiero tlen ya ipan se temictli.” ");
INSERT INTO nheNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero nopa tlayacanca totajtzitzi huan nopa huehue tlacame tlen israelitame quinchihualtijque nopa miyac tlacame tlen itztoyaj nepa ma tlajtlanica para ma quinmalacanili Barrabás huan ma quimicti Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Huajca nopa gobernador sampa quintlajtlani: ―¿Ajqueya nimechmactilis tlen ne ome tlacame? Huan nopa tlacame quiilhuijque: ―Barrabás. ");
INSERT INTO nheNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Huan Pilato quintlajtlani: ―Huajca ¿tlachque nijchihuas ica Jesús tlen quitocaxtíaj nopa Cristo? Huan quinanquilijque: ―Xijcuamapelolti. ");
INSERT INTO nheNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Huan Pilato quintlatzintoquili sampa: ―Pero ¿para tlen? ¿Tlachque tlajtlacoli quichijtoc? Pero nopa tlacame más tzajtziyayaj: ―Xijcuamapelolti. ");
INSERT INTO nheNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Huan Pilato quiitac para ax huelis quimanahuis Jesús pampa nopa miyac tlacame ya pejque más mosisiníaj. Huajca tlajtlanqui se achi atl para momajtequis. Huan momajtejqui iniixtla nochi nopa tlacame huan quinilhui: ―Na ax nijhuica tlajtlacoli para ma miquis ni tlacatl tlen cuali. Inquihuicase tlajtlacoli imojuanti intla inquimictise. ");
INSERT INTO nheNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huan nochi nopa tlacame quinanquilijque huan quiilhuijque: ―Ma tijhuicaca tlajtlacoli tojuanti huan toconehua para ma miqui. ");
INSERT INTO nheNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Huajca quinmalacanili Barrabás, pero tlanahuati ma quihuitequica Jesús huan quinmactili para quicuamapeloltise. ");
INSERT INTO nheNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Huan nopa soldados quihuicaque Jesús ipan nopa hueyi cali tlen iaxca gobernador, huan queja seiscientos soldados mosentilijque huan quiyahualojque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Huan quiquixtilijque iyoyo huan quiquentijque se yoyomitl tlen chichiltic queja tlanahuatiani momatij moquentíaj. ");
INSERT INTO nheNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Huan quinsencajque se huitzcorona huan quitlalilijque ipan itzonteco Jesús. Huan quitlalilijque se ojtla cuahuitl ipan inejmatl queja quipiya se tlanahuatijquetl huan pejque quihuihuiitaj. Motlancuaquetzque iixtla huan quiilhuijque: ―¡Ma itzto miyac tonali ni inintlanahuatijca israelitame! ");
INSERT INTO nheNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Huan teipa quichajchaque huan quiquixtilijque nopa ojtla cuahuitl huan pejque ica quimaquilíaj ipan itzonteco. ");
INSERT INTO nheNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Huan teipa quema tlanque quihuihuiitaj, quiquixtilijque nopa yoyomitl tlen huehueyac huan quiquentijque tlen ipa iyoyo huan quihuicaque quicuamapeloltitij. ");
INSERT INTO nheNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Huan quema yajuanti ya quistoyaj ipan altepetl Jerusalén, quipantijque se tlacatl itoca Simón tlen ehua tlali Cirene huan quichihualtijque ma quiquechpano icuamapel Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Huan teipa ajsitoj ipan nopa lugar tlen itoca Gólgota (tlen quinequi quiijtos “Campa Onca Mijcatzontecomitl”). ");
INSERT INTO nheNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Huan nepa nopa soldados quimacaque Jesús vinagre ihuaya se pajtli tlen chichic ma quii para ma tlapolo. Pero Jesús quiyeco huan quema quimachili tlachque quipixtoya, ax quiic. ");
INSERT INTO nheNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Huan quema nopa soldados quimalavoshuijque Jesús ipan icuamapel, momajmacaque iyoyo huan mahuiltijque ica piltetzitzi para quiitase ajqueya quihuicasquía. Huajca quitlamiltijque itlajtol nopa tiocamanalojquetl tlen quiijcuilo huejcajquiya campa quiijtohua: “Yajuanti momajmacase noyoyo huan mahuiltise para quiitase ajqueya quihuicas tlen nimoquentía.” ");
INSERT INTO nheNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Huan teipa nopa soldados mosehuijque para tlamocuitlahuise quema Jesús ya itztoya ipan icuamapel. ");
INSERT INTO nheNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Huan quitlalijque se tlajcuiloli itzonpac Jesús campa nesiyaya tlachque ica quiteilhuijtoyaj. Huan nopa tlajcuiloli quiijto: NI JESÚS, YAJAYA ININTLANAHUATIJCA ISRAELITAME. ");
INSERT INTO nheNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Huan quincuamapeloltijque ome tlaxtequini ipan inincuamapelhua nechca Jesús. Se ipan inejmatl huan seyoc ipan iarraves. ");
INSERT INTO nheNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Huan nochi tlacame tlen panoyayaj nepa nojquiya quihuihuiitayayaj. Quiojoliniyayaj inintzonteco, ");
INSERT INTO nheNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","huan quiilhuiyayaj: ―Ta tiquijto tijxolehuasquía nopa tiopan cali huan sampa tijsencahuas ica eyi tonali. Huajca ximomaquixti. Intla ta tiIcone Toteco, xitemo ipan nopa cuamapeli. ");
INSERT INTO nheNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nojquiya quihuihuiitayayaj nopa tlayacanca totajtzitzi, nopa tlamachtiani tlen itlanahuatil Moisés, nopa fariseos huan nopa huehue tlacame tlen israelitame. Huan quiijtohuayayaj: ");
INSERT INTO nheNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Yajaya quinmaquixti sequinoc pero ax hueli momaquixtía iselti. Intla nelía yajaya nopa tlanahuatijquetl tlen tiisraelitame, huajca ma temo nimantzi ipan icuamapel huan huajca, quena, tijneltocase. ");
INSERT INTO nheNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yajaya nochipa motemachi ipan Toteco, huajca ma Toteco quimanahui amantzi, intla nelía quiyolpactía. Pampa yajaya quiijto para Icone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Huan nopa tlachtequini tlen itztoyaj inechca ipan inincuamapel, nojquiya quihuihuiitayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Huan ica tlajco tona tzintlayohuac campa hueli ipan tlaltepactli hasta las tres ica tiotlac. ");
INSERT INTO nheNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huan nechca las tres Jesús camatqui chicahuac huan quiijto: “Elí, Elí, ¿lama sabactani?” Ni tlajtoli quinequi quiijtos: “NoTeco, noTeco, ¿para tlen tinechtlahuelcajtoc?” ");
INSERT INTO nheNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Huan sequin tlacame tlen moquetztoyaj nechca quicajque itlajtol pero ax quimachilijque tlen quiijto, huan yajuanti quiijtojque: ―Ni tlacatl quinotza tiocamanalojquetl Elías. ");
INSERT INTO nheNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Huan nimantzi se tlen yajuanti motlalo, huan quicuito se tlamantli tlen tzotzoltic huan quiapacho ipan xocomecatl iayo tlen xococ. Huan quitlali ipan se ojtla cuahuitl huan quitentoquilti Jesús para ma quichichina. ");
INSERT INTO nheNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero nopa sequinoc tlacame quiijtojque: ―Xijcahua. Ma tiquitase intla hualas Elías para quimanahuis o axtle. ");
INSERT INTO nheNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Huan Jesús sampa camatqui chicahuac huan quimactili Itonal imaco Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huan ipan nopa tlalochtli, tzayanqui nopa hueyi cortina tlen ica quitzactoya nopa cuarto campa Más Tlatzejtzeloltic tiopan calijtic. Tzayanqui ica ome tlen huejcapa hasta tlatzintla. Huan mojmolini tlali huan huejhueyi tetini motlajcoitaque. ");
INSERT INTO nheNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huan ipan campo santo motlapojque campa quintlalpachojtoyaj mijcatzitzi huan moyolcuique miyac mijcatzitzi tlen iaxcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Quisque ipan iniostohua huan teipa quema Jesús ya moyolcuitoya, yajuanti calajque ipan altepetl Jerusalén huan miyac tlacame quinitaque. ");
INSERT INTO nheNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Huan se capitán huan isoldados tlen ihuaya quimocuitlahuiyayaj Jesús quiitaque quema mojmolini tlali huan quiitaque nochi más tlen panoyaya. Huan tlahuel momajmatijque huan quiijtojque: ―Nelía ni tlacatl elqui Icone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Huan itztoyaj nopano miyac sihuame tlen quitlachiliyayaj Jesús ica huejca. Yajuanti quitoquilijtoyaj Jesús tlen estado Galilea para quipalehuise ica tlen monejqui. ");
INSERT INTO nheNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Huan ipan nopa sihuame itztoyaj María Magdalena, María ininnana Jacobo huan José, huan nojquiya ininnana itelpocahua Zebedeo. ");
INSERT INTO nheNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Huan quema tiotlaquixqui, ajsico se tominpixquetl tlen quitocaxtiyayaj José. Yajaya ejqui altepetl Arimatea huan quitoquili Jesús queja se imomachtijca. ");
INSERT INTO nheNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yajaya yajqui quiitato gobernador Pilato huan quitlajtlani ma quicahuili quicuis itlacayo Jesús. Huajca Pilato tlanahuati para ma quimacaca. ");
INSERT INTO nheNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Huan José quicuic itlacayo Jesús huan quipijqui ica se hueyi yoyomitl tlen yancuic. ");
INSERT INTO nheNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Huan quitlali ipan se tlacacahuaya yancuic tlen quicoyonijtoya ipan se hueyi tepexitl para ya iselti quema miquis. Huan quimimilo se hueyi tetl para ica quitzajqui, huan teipa quisqui. ");
INSERT INTO nheNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Huan María Magdalena huan nopa seyoc María mosehuijtoyaj imelac nopa tlacacahuaya quitlachiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Huan hualmostla quema ya panotoya nopa tonali para tlacualtlalise para nopa ilhuitl, mosentilijque nopa tlayacanca totajtzitzi huan fariseos iixtla Pilato, ");
INSERT INTO nheNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","huan quiilhuijque: ―Tate, tiquilnamiquij quema noja itztoya nopa tlacajcayajquetl Jesús, yajaya quiijto para quema miquis, ica eyi tonali moyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Huajca xiquintitlani soldados ma cuali quitzacuaca nopa tlacacahuaya huan quimocuitlahuise hasta panos eyi tonali para ma ax hualaca imomachtijcahua huan quihuicase itlacayo huan teipa nochi tlacame quiijtose para moyolcuitoc. Quej nopa achi más tlacajcayahuase teipa que achtohui quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Huajca Pilato quinilhui: ―Nica itztoque nosoldados. Xiquinhuicaca huan xijchihuaca nochi tlen inquimatij inquichihuaj para ma mocahua neltemachtli. ");
INSERT INTO nheNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Huajca quinhuicaque nopa soldados huan quitzajque nopa tetl ipan tepexitl huan cuali quipepechojque huan quitlali se sello para quimatisquíaj intla se tlacatl calaquisquía. Huan nopa soldados mocajque tlamocuitlahuiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Huan teipa panoc sábado, nopa tonal para ma mosiyajcahuaca. Huan quema aya quisayaya tonati ipan domingo nopa achtohui tonal ipan samano, María Magdalena huan nopa seyoc María yajque quiitato nopa tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Huan quema itztoyaj ipan ojtli, chicahuac mojmolini tlaltepactli pampa se ielhuicac ejca Toteco hualtemoc tlen elhuicac, huan quiijcueni nopa hueyi tetl huan ipan mosehui. ");
INSERT INTO nheNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Huan yajaya tlahuiyaya queja quema tlapetlani, huan iyoyo eliyaya nelchipahuac queja nextli. ");
INSERT INTO nheNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Huan nopa soldados pejque huihuipicaj pampa tlahuel quiimacasiyayaj. Teipa tlapolojque huan huetzque queja mictoque. ");
INSERT INTO nheNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Huan nopa elhuicac ejquetl quinilhui nopa sihuame tlen ajsiyayaj: ―Amo ximomajmatica. Nijmati inquitemohuaj Jesús tlen quicuamapeloltijque. ");
INSERT INTO nheNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ax aqui nica. Ya moyolcuic queja quiijto quichihuas. Xihualaca, xijtlachiliquij campa quitejque itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Huan teipa xiyajtihuetzica huan xiquinilhuitij imomachtijcahua para yajaya tlen mijqui ama moyolcuitojca. Huan inmechtlayacancuilis hasta estado Galilea huan nepa inquiitase. San ya ni nochiya tlen monequi nimechyolmelahuas. ");
INSERT INTO nheNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Huan nopa sihuame nimantzi quisque ipan tlacacahuaya huan achi momajmatiyayaj huan tlahuel paquiyayaj huan motlalojtejque para quinyolmelahuatij imomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Huan quema nopa sihuame yohuiyayaj ipan ojtli para tlayolmelahuatij, nimantzi quinamijque Jesús huan yajaya quintlajpalo huan quinilhui: ―¡Ya tlanesqui! Huan nopa sihuame monechcahuitoj huan quiitzquijque iicxi huan quihueyimatque. ");
INSERT INTO nheNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Huan Jesús quinilhui: ―Amo ximomajmatica. Xiyaca, xiquinyolmelahuatij noicnihua para ma yaca estado Galilea huan nepa timopantise. ");
INSERT INTO nheNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Huan quema nopa sihuame yohuiyayaj ipan iniojhui, nojquiya sequin nopa soldados yajque altepetl Jerusalén huan quinilhuitoj nopa tlayacanca totajtzitzi tlen panotoya. ");
INSERT INTO nheNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Huajca yajuanti mosentilijque ica nopa huehue tlacame tlen israelitame huan quisencajque san sejco para quinmacasquíaj miyac tomi nopa soldados para ma istlacatica. ");
INSERT INTO nheNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Quinilhui: ―Monequi inquiijtose para imomachtijcahua Jesús hualajque tlayohua huan quicuitoj itlacayo quema incochtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Huan intla nopa gobernador quicaquis para incochtoyaj huan cualanis imohuaya, huajca tijsencahuase para ax tleno imopantis. ");
INSERT INTO nheNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Huajca nopa soldados quiselijque nopa tomi huan quinilhuijque tlacame queja nopa tlayacanani quinilhuijtoyaj ma quiijtoca. Huan hasta ama ya ni nopa tlajtoli tlen momati campa israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Huan teipa timajtlacme huan se tiimomachtijcahua Jesús tiyajque estado Galilea hasta ipan nopa tepetl campa Jesús technahuati ma timosentilica. ");
INSERT INTO nheNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Huan quema tiquitaque Jesús ijcatoc nopano, tijhueyichijque, pero para sequin achi ohui para quineltocaque para nelía eliyaya Jesús tlen itztoya tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Huan Jesús technechcahuico huan techilhui: ―Toteco nechmacatoc nochi tlanahuatili ipan elhuicac huan ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Huajca xiyaca ipan nochi tlaltini huan xiquinmachtica tlacame ma elica nomomachtijcahua. Huan xiquincuaaltica ica itoca Totata, huan ica na niIcone notoca , huan ica itoca Itonal Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Xiquinmachtica ma quichihuaca nochi tlen nimechilhuijtoc. Huan xijmatica ya ni, na niitztos imohuaya nochi tonali hasta tlamis tlaltepactli. San ya nopa.");
INSERT INTO nheNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quej ni pejqui nopa cuali tlamachtili tlen Jesucristo, Icone Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Huejcajquiya Isaías, itiocamanalojca Toteco, quiijcuilo tlen Toteco quiilhui Jesús. Quiijcuilo: “Xiquita nijtitlanis notlayolmelajca ma mitzyacanas. Yajaya quicualtlalis ininyolo tlacame para ma mitzselica. ");
INSERT INTO nheNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Notlayolmelajca camatis chicahuac ipan nopa huactoc tlali campa ax tleno eli, huan quinilhuis tlacame: ‘Xijcualtlalica imoyolo pampa hualas Tohueyiteco. Xijxitlahuaca imonemilis queja inquisencahuasquíaj se ojtli para hualas se hueyi tequihue.’ ” ");
INSERT INTO nheNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ni tlayolmelajquetl tlen Toteco quititlanqui ma tlayacana elqui Juan tlen tecuaaltiyaya ipan nopa huactoc tlali. Quinilhuiyaya tlacame ma mocuaaltica para quipannextise moyolcueptoque huan quicajtejtoque tlajtlacoli. Huan Toteco quintlapojpolhuiyaya inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Miyac tlacame tlen estado Judea huan tlen altepetl Jerusalén yohuiyayaj para quicaquise Juan. Huan quema quiilhuijque Toteco inintlajtlacolhua, Juan quincuaaltiyaya ipan atemitl Jordán. ");
INSERT INTO nheNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan moquentiyaya iyoyo tlen itzoncal camello huan quipixqui se itzinquechilpica tlen cuetlaxtli. Quicuayaya pilchapoltzitzi huan nectli tlen onca ipan nopa huactoc tlali. ");
INSERT INTO nheNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Quincamahuiyaya tlacame tlen Jesús huan quinilhuiyaya: “Teipa hualas se tlacatl tlen quipiyas miyac más itequihuejcayo huan ax quej na. Na ax nihueyi queja ya. Ax nicaxilía para nielis niitequipanojca, niyon para nijquixtilis itecac. ");
INSERT INTO nheNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na nimechcuaaltía san ica atl, pero yajaya inmechmacas Itonal Toteco ipan imoyolo.” ");
INSERT INTO nheNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ipan nopa tonali Jesús quisqui altepetl Nazaret ipan estado Galilea huan yajqui campa Juan itztoya, huan Juan quicuaalti ipan atemitl Jordán. ");
INSERT INTO nheNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Huan teipa, quema Jesús quisayaya ipan atl, quiitac tlapojtoya elhuicactli huan Itonal Toteco hualtemoc ipan ya queja se paloma. ");
INSERT INTO nheNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Huan quicajqui Toteco Dios camatqui tlen elhuicac huan quiijto: “Ta tiNocone, nimitzicnelía miyac huan nijpiya miyac paquilistli ica tlen tijchihua.” ");
INSERT INTO nheNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Teipa Itonal Toteco quiyacanqui Jesús ma yohui hasta nopa tlali huactoc campa ax tleno eli. ");
INSERT INTO nheNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Huan Jesús itztoya nepa para cuarenta tonali huan Axcualtlacatl quiyejyecohuayaya ma tlajtlacolchihua. Nopano itztoyaj tecuanime tlen mosisiníaj huan nojquiya itztoyaj elhuicac ehuani tlen quitequipanohuayayaj Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Quema nopa tlanahuatijquetl quitzajqui Juan tlen tecuaaltiyaya, Jesús ajsito ipan estado Galilea para quinixtomilis tlacame nopa cuali tlamachtili tlen quejatza tlacame huelis calaquise campa tlanahuatía Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Huan quinilhuiyaya tlacame: “Ya ajsic nopa tonal huan ama, ax huejcahuas pehuas tlanahuatis Toteco. Xijpatlaca imoyolo huan xijneltocaca itlajtol Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Teipa Jesús nentinemiyaya iteno nopa hueyi atl Galilea huan quinitac Simón ihuaya iicni, Andrés. Yajuanti eliyayaj michtlajtlamani huan quimajcahuayayaj se matlatl atitla. ");
INSERT INTO nheNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Huan Jesús quinilhui: ―Xinechtoquilica. Ama inmichtlajtlamani, pero na nimechnextilis quejatza inquinnojnotzase tlacame ma nechtoquilica. ");
INSERT INTO nheNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Huan quicajtejque ininmatla huan yajque ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Teipa Jesús nejnenqui se quentzi huan quinitac Jacobo ihuaya iicni, Juan. Yajuanti eliyaya iconehua Zebedeo, huan itztoyaj ipan se cuacanahua quiijtzomayayaj ininmatla. ");
INSERT INTO nheNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Huan nimantzi Jesús quinnotzqui. Huan quicajtejque inintata Zebedeo ipan cuacanahua ininhuaya itequipanojcahua huan quitoquilijque. ");
INSERT INTO nheNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Teipa Jesús huan tlen itztoyaj ihuaya ajsitoj altepetl Capernaum. Huan ipan nopa tonal para ma mosiyajcahuaca israelitame, Jesús calajqui ipan nopa israelita tiopamitl huan pejqui tlamachtía. ");
INSERT INTO nheNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Huan tlacame san quisentlachiliyayaj ica itlamachtil pampa quinmachtiyaya queja se tlen quipixqui tequihuejcayotl. Ax quinmachtiyaya queja tlamachtiani tlen itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nojquiya ipan tiopamitl itztoya se tlacatl tlen quipixqui se iajaca Axcualtlacatl tlen calactoya ipan itlacayo. Yajaya quiitac Jesús huan chicahuac quiijto: ");
INSERT INTO nheNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","―Jesús ta tiNazaret ejquetl, ¿tlachque tinechchihuilis? ¿Tihualajtoc para tinechtzontlamiltis? Na nimitzixmati. Ta tlen titlatzejtzeloltic tlen Dios quititlantoc nica. ");
INSERT INTO nheNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Huan Jesús quiajhuac nopa iajaca Axcualtlacatl huan quiilhui: ―Ayoc ximolini. Xiquisa ipan ni tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Huajca iajaca Axcualtlacatl quichijqui nopa tlacatl ma huetzi ica se ajaca cocolistli. Huan tzajtzitejqui chicahuac huan quisqui ipan itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Huan nochi momajmatijque huan moilhuijque: ―¿Tlachque panoc? ¿Huelis ya ni se yancuic tlamachtilistli? ¡Ni tlacatl Jesús quipiya tequihuejcayotl para quinnahuatis iajacahua Axcualtlacatl huan yajuanti quineltoquilíaj! ");
INSERT INTO nheNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Huajca nimantzi nochi tlacame campa hueli ipan estado Galilea quimatque tlen quichijqui Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Quema ya quistoyaj ipan tiopamitl, Jesús yajqui ihuaya Jacobo ihuaya Juan hasta ininchaj Simón huan Andrés. ");
INSERT INTO nheNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Huan imona Simón Pedro huetztoya ipan cocolistli pampa totoniyayaya. Huan nimantzi quiilhuijque Jesús para mococohua. ");
INSERT INTO nheNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Huajca Jesús quinechcahui nopa sihuatl huan quimaitzqui. Quitlalanqui huan nimantzi quicajqui nopa cocolistli. Huan nopa sihuatl pejqui quintlamaca. ");
INSERT INTO nheNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Quema ya calajqui tonati huan tlayohuatoya, tlacame pejque quinhuicaj campa Jesús nochi tlen mococohuayayaj huan tlen quipixque iajacahua Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Huan nochi tlacame tlen nopa altepetl mosentilijque calteno. ");
INSERT INTO nheNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Huan Jesús quinchicajqui miyac cocoyani tlen quipixque miyac tlamantli cocolistli. Huan quinquixtili miyac iajacahua Axcualtlacatl. Pero Jesús ax quincahuiliyaya iajacahua Axcualtlacatl ma camatica pampa quiixmatiyayaj para yajaya eliyaya nopa Cristo tlen Toteco Dios quititlantoya. ");
INSERT INTO nheNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Huan hualmostla ijnaltzi quema noja tlatlayohuayaya, Jesús mejtejqui huan yajqui campa tlatzitzicaya para momaijtos ica Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Huan teipa Simón ihuaya ihuampoyohua yajque quitemotoj. ");
INSERT INTO nheNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Huan quipantijque Jesús huan quiilhuijque: ―Nochi tlacame mitztemohuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Pero Jesús quinilhui: ―Ma tiyaca ipan nopa pilaltepetzitzi tlen nechca para nitepohuilis itlajtol Toteco nepa nojquiya pampa yeca nihualajtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Huajca Jesús panotinenqui campa hueli ipan nochi estado Galilea huan tepohuiliyaya itlajtol Toteco ipan sesen israelita tiopamitl. Huan quema quinpantiyaya tlacame tlen quipixque iajacahua Axcualtlacatl, Jesús quinchihualtiyaya ma quisaca. ");
INSERT INTO nheNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Huan quinechcahuico Jesús se tlacatl tlen tlacayo palaniyaya ica se cocolistli tlen itoca lepra. Huan motlancuaquetzqui iixtla Jesús huan quiilhui: ―Jesús, intla tijnequi, huelis tinechchicahuas. ");
INSERT INTO nheNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Huan Jesús quitlasojtlac, huan quitlali ima ipani huan quiilhui: ―Quena, nijnequi. Ximochicahua amantzi. ");
INSERT INTO nheNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Huan ipan nopa tlalochtli, nopa cocolistli quicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Huajca Jesús quinahuati: ");
INSERT INTO nheNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Amo aca xiquilhui. San xiya ximonextiti iixtla nopa israelita totajtzi huan xijmaca Toteco nopa tlacajcahualistli tlen Moisés tlanahuati ma quimacaca tlen ayoc quipiyaj inintlacayo palantoc para queja nopa nochi quimatise ya timochicajtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero nopa tlacatl yajqui huan pejqui quinilhuía nochi tlacame tlachque ipantic huan nelía momajqui itlajtol. Yeca Jesús ayoc huelqui calaqui tonaya ipan altepetini. San nejnemiyaya campa tlatzitzica huan nepa nojquiya quipantiyayaj miyac tlacame tlen hualajque tlen campa hueli pilaltepetzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Quema panotoya se ome tonali, Jesús sampa yajqui hasta altepetl Capernaum, huan nochi quimatque para itztoya ipan se cali. ");
INSERT INTO nheNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Huan nimantzi mosentilijque miyac tlacame huan yeca ayoc aca huelqui calaqui, niyon ayoc aca huelqui monechcahuía calteno. Huan Jesús quinilhuiyaya itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Huan teipa ajsicoj sequin tlacame tlen quihualicayayaj campa Jesús se cocoxquetl tlen ax huelqui mojmolinía tlen nahui tlacame quiquechpanojtihualayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Huan ax huelque ajsique campa Jesús pampa itztoyaj tlahuel miyac tlacame, huajca tlejcoque calpani huan quiijcuenijque sequin tejas itzonpac nopa cali. Teipa quitemohuijque nopa cocoxquetl huetztoc ipan itlapech. ");
INSERT INTO nheNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Huan Jesús quiitac para quineltocayayaj, huajca quiilhui nopa cocoxquetl: ―Nohuampo nimitztlapojpolhuía motlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Huan sequin tlamachtiani tlen itlanahuatil Moisés tlen mosehuijtoyaj calijtic moyolilhuijque: ");
INSERT INTO nheNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Para tlen camati Jesús queja nopa? Mochihua queja elisquía Toteco pampa axaca hueli tetlapojpolhuía tlajtlacoli, san Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Huan Jesús nimantzi quimatqui tlen moyolilhuiyayaj huan quinilhui: ―¿Para tlen inmoyolilhuíaj queja nopa? ");
INSERT INTO nheNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Tlen hueli tlajtoli tlen niquijtohua mochihuas yonque niquilhuis ni cocoxquetl: ‘Nimitztlapojpolhuía motlajtlacolhua’, o niquilhuis: ‘Ximehua, xijtlalana motlapech huan xinejnemi.’ ");
INSERT INTO nheNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pero pampa nijnequi xijmatica na, tlen niMocuepqui Tlacatl, nijpiya tequihuejcayotl ipan tlaltepactli para melahuac nitetlapojpolhuis tetlajtlacolhua, huajca nimechnextilis para panos tlen niquijtohua. Huan nimantzi Jesús quiilhui nopa cocoxquetl: ");
INSERT INTO nheNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Nimitzilhuía, ximehua, xijtlalana motlapech huan xiya mochaj. ");
INSERT INTO nheNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Huajca mejqui huan quitlalantejqui itlapech iniixtla huan quisato. Huan nochi tlen quiitaque san quisentlachilijque huan quihueyichijque Toteco Dios huan quiijtojque: ―Ax quema tiquitztoque se tlamantli queja ni. ");
INSERT INTO nheNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Teipa Jesús sampa yajqui iteno hueyi atl, huan quinechcahuijque miyac tlacame huan yajaya quinmachti. ");
INSERT INTO nheNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Huan teipa Jesús panotinemiyaya campa tequicali, huan nepa ipan mesa mosehuiyaya se tlacatl tlen itoca eliyaya Leví tlen elqui icone Alfeo. Tequihuejme quitequitlalijtoyaj ma quiseli nopa tomi tlen nochi monequiyaya tlaxtlahuase para impuestos. Huan Jesús quiilhui: ―Xinechtoquili. Huajca Mateo moquetztiquisqui huan quitoquili Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Teipa Jesús tlacuayaya ichaj Mateo huan ajsicoj nepa miyac tlacame tlen tlainanque impuesto huan tlen miyac tlajtlacoli quichihuayayaj. Nopa tlacame nojquiya tlacuayayaj ihuaya Jesús huan imomachtijcahua pampa miyac tlen yajuanti quitoquiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Huan nojquiya itztoyaj nepa sequin fariseos huan tlamachtiani tlen itlanahuatil Moisés. Huan quema quiitaque Jesús tlacuayaya ininhuaya nopa ax cuajcualme, quintlatzintoquilijque imomachtijcahua: ―¿Para tlen tlacua huan atli Jesús ininhuaya tlacame tlen tlainamaj impuesto huan ininhuaya tlen miyac tlajtlacoli quichihuaj? ");
INSERT INTO nheNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Huan Jesús quicajqui inintlajtol huan quinilhui: ―Se tetica tlacatl ax quinequi se tepajtijquetl, pero se cocoxquetl, quena. Na ax nihualajtoc para niquinnotzas tlen moilhuíaj para ya cuajcualme iixtla Toteco Dios. Nihualajtoc para niquinnotzas tlacame tlen quimatij para quipiyaj inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Se tonal imomachtijcahua Juan huan inintlatoquilijcahua fariseos mosahuayayaj para momaijtose ica Toteco Dios. Huajca yajque tlacame campa Jesús huan quitlajtlanijque: ―¿Para tlen mosahuaj itlatoquilijcahua Juan huan inintlatoquilijcahua fariseos, pero momomachtijcahua ax mosahuaj? ");
INSERT INTO nheNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Huan Jesús quinnanquili: ―¿Quejatza huelis mosahuase ihuampoyohua se mosihuajtijquetl ipan nopa tlalochtli quema tlacuaj ihuaya ipan nenamictili? Intla itztoque iixtla nopa mosihuajtijquetl, ax quinamiqui para mosahuase. San se eltoc quema na niitztoc ininhuaya nomomachtijcahua, ax quinamiqui mosahuase. ");
INSERT INTO nheNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero ajsis hora quema hualase nocualancaitacahua huan nechhuicase. Nopa tonal, quena, mosahuase nomomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Axaca quitlatlamanía se yoyomitl tlen sosoltic ica se yoyomitl tlen yancuic pampa nopa tlen yancuic motzocoyolos huan nimantzi tzayanis nopa yoyomitl tlen sosoltic huan achi más fiero nesis. ");
INSERT INTO nheNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nojquiya axaca quitequilía xocomeca atl tlen yancuic ipan bolsas tlen cuetlaxtli sosoltic, pampa quema nopa yancuic xocomeca atl xocoyas, momiyaquilis. Quej nopa tzayanis nopa cuetlaxtli sosoltic huan nenpolihuis nopa xocomeca atl huan nopa cuetlaxtli. Huajca monequi quitequilise xocomeca atl tlen yancuic ipan bolsas tlen cuetlaxtli yancuic. ");
INSERT INTO nheNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ipan sábado, nopa tonal para ma mosiyajcahuaca israelitame, Jesús nejnemiyaya ipan se mili campa quitoctoyaj trigo, huan imomachtijcahua pejque quiquechcocototzaj trigo huan quicuaj iyol. ");
INSERT INTO nheNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Huajca nopa fariseos quiilhuijque Jesús: ―Xiquita, momachtijcahua quichihuaj tlen ax monequi ipan ni tonal para ma timosiyajcahuaca, yeca tlajtlacolchihuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Huan Jesús quinilhui: ―¿Ax inquipojtoque tlen quichijqui David huejcajquiya quema yajaya ihuaya ihuampoyohua nelía mayanayayaj huan ax quipixque tlen quicuase? ");
INSERT INTO nheNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David calaquito ipan ichaj Toteco quema Abiatar elqui hueyi totajtzi, huan quicuajqui nopa pantzi tlen eltoya ipan mesa iixtla Toteco. Teipa David quinmajmacac nopa pantzi nopa tlacame tlen itztoyaj ihuaya yonque itlanahuatil Moisés ax quincahuilía sequinoc ma quicuaca nopa pantzi. San eltoya para totajtzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Huan nojquiya Jesús quinilhui: ―Toteco Dios quisencajtoc ni tonal para tlacame ma mosiyajcahuaca para quinpalehuis. Ax quinsencajtoc tlacame para ma quihueyitlalica nopa tonal. ");
INSERT INTO nheNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na tlen niMocuepqui Tlacatl, nijpiya tequihuejcayotl para niquinilhuis tlacame tlachque huelis quichihuase ipan sábado, ni tonal para ma timosiyajcahuaca. ");
INSERT INTO nheNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús sampa calajqui ipan se israelita tiopamitl huan nopano itztoya se tlacatl tlen mahuactoya. ");
INSERT INTO nheNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Huan nopa fariseos san quitlachiliyayaj intla Jesús quichicahuasquía para quiteilhuise pampa elqui se tonal para ma timosiyajcahuaca tiisraelitame. ");
INSERT INTO nheNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Huajca Jesús quiilhui nopa tlacatl tlen mahuactoya: ―Ximoquetza huan xihuala nica tlatlajco ni tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Huan nimantzi Jesús quintlajtlani nopa fariseos, quinilhui: ―¿Ipan ni tonal para timosiyajcahuase inquiitaj quinamiqui ma tijchihuaca tlen cuali o tlen ax cuali? ¿Ma tiquinpalehuica tlacame o ma tiquinmictica? Pero nopa fariseos ax molinijque. ");
INSERT INTO nheNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Huajca Jesús quintlachili huan cualanqui. Mocueso pampa nopa fariseos tlahuel yoltetique. Huajca Jesús quiilhui nopa tlacatl: ―¡Xijxitlahua moma! Huan quixitlajqui ima huan cuali mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Huajca quisque nopa fariseos huan nimantzi pejque motlajtolmacaj ica sequinoc tlacame tlen quitoquiliyayaj Herodes quejatza huelis quimictise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Huan Jesús quisqui ihuaya imomachtijcahua huan yajque iteno hueyi atl. Huan quintoquilijque tlahuel miyac tlacame tlen ejque estado Galilea huan estado Judea. ");
INSERT INTO nheNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Nojquiya itztoyaj tlacame tlen altepetl Jerusalén, huan tlen estado Idumea huan tlen nopa tlali tlen mocahua ipan seyoc nali nopa atemitl Jordán. Nojquiya hualajque tlacame tlen ejque nechca altepetini Tiro huan Sidón. Miyaqui tlacame quicactoyaj nochi tlen Jesús quichihuayaya huan yeca yohuiyayaj campa yajaya itztoya. ");
INSERT INTO nheNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huan Jesús quinilhui imomachtijcahua ma quichiyaca ica se cuacanahua para ipan tlejcos para ma ax quitetzopaca nopa tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pampa Jesús quinchicajtoya miyac cocoyani huan nochi tlen mococohuayayaj nochipa quicuatopejtiyohuiyayaj chicahuac para quiitzquise. ");
INSERT INTO nheNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Huan quema tlacame tlen quipiyayayaj se iajaca Axcualtlacatl quiitayayaj Jesús, motlancuaquetzayayaj iixtla huan chicahuac nopa ajacame quiijtohuayayaj: ―¡Ta tiIcone Dios! ");
INSERT INTO nheNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero Jesús chicahuac quinnahuatiyaya ma ax quinilhuica tlacame ajqueya yaja. ");
INSERT INTO nheNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Teipa Jesús tlejcoc ipan se tepetl huan quinnotzqui san nopa tlacame tlen quinequiyaya ma yaca ihuaya, huan yajuanti yajque campa ya. ");
INSERT INTO nheNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Huan Jesús quintlapejpeni majtlactli huan ome imomachtijcahua para ma itztoca ihuaya huan para quintitlanis ma teilhuitij itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nojquiya Jesús quintlapejpeni para ma quipiyaca tequihuejcayotl quinchicahuase cocoyani huan quinquixtilise iajacahua Axcualtlacatl tlen calactoyaj ipan tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Huajca nicani eltoc inintoca nopa tlacame tlen quintlapejpeni: Simón, tlen Jesús quitocaxtlali Pedro, ");
INSERT INTO nheNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo ihuaya iicni, Juan, tlen eliyayaj iconehua Zebedeo. Jesús quintocaxtiyaya nopa ome Boanerges, tlen quinequi quiijtos tlacame tlen itztoque queja se tlatomonilotl pampa mosisiniyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nojquiya quintlapejpeni Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo icone Alfeo, Tadeo huan Simón tlen moiyocatlaliyaya ica nopa partido cananista. ");
INSERT INTO nheNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Huan quitlapejpeni Judas Iscariote tlen teipa quitemactili Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Teipa Jesús ihuaya imomachtijcahua mocuepque huan sampa calajque ipan se cali. Huan sampa mosentilijque miyac tlacame, huan yeca Jesús ihuaya imomachtijcahua ax quipiyayayaj niyon se tlalochtli para tlacuase. ");
INSERT INTO nheNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Huan quema quicajque iteixmatcahua Jesús para ax quipixqui se tlalochtli para tlacuas, hualajque para quihuicase pampa quiijtohuayayaj: “Molocojchijtoc.” ");
INSERT INTO nheNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero ajsicoj tlen Jerusalén sequin tlamachtiani tlen itlanahuatil Moisés. Yajuanti teilhuiyayaj para Jesús quipixqui Axcualtlacatl yajaya tlen quinyacana nochi ajacame, huan yeca quimacatoya Jesús chicahualistli quinquixtis ajacame tlen calactoque ipan sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Huajca Jesús quinnotzqui nopa tlamachtiani tlen itlanahuatil Moisés huan quinilhui ica huicalotl, quiijto: “¿Quejatza huelis Axcualtlacatl quinquixtis ajacame tlen iaxcahua? ");
INSERT INTO nheNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Intla se tlali ica san se tlanahuatijquetl motlajcoxelohua, ax huejcahuas pampa seyoc tlali quitlanis nimantzi. ");
INSERT INTO nheNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Huan intla ichampoyohua se tlacatl ipan se cali motlajcoxelohuaj, ax hueli mocahuase san sejco. ");
INSERT INTO nheNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Huan intla Axcualtlacatl mocualanía ica iaxcahua, huan motlajcoxelohuaj, ax huejcahuas pampa yajaya iselti quintzontlamiltis tlen iaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Axaca huelis calaquis ichaj se tlen tetixtoc queja Axcualtlacatl huan quiquixtilis tlen iaxca intla achtohui ax quiilpis. Huajca quena, huelis quiquixtilis tlen iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nelía nimechilhuía noTata huelis quintlapojpolhuis nochi inintlajtlacolhua tlacame huan nochi tlen fiero camatij, ");
INSERT INTO nheNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","pero ajqueya quitlaijilhuis itequi Itonal Toteco huan quiijtos para tlen yajaya quichijtoc eltoc se tlamantli tlen fiero, Toteco ax quema quitlapojpolhuis. Nopa tlacatl quihuicas nopa tlajtlacoli para nochipa.” ");
INSERT INTO nheNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesús quiijto ya ni pampa yajuanti quiijtohuayayaj para yajaya quipixtoya se iajaca Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Teipa ajsico inana ihuaya iicnihua Jesús, pero mocajque calteno huan tlatitlanque ma quinotzatij Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Huan nopa tlacame tlen mosiyajcahuayayaj huan quiyahualohuayayaj Jesús, quiilhuijque: ―Xiquita, monana huan moicnihua itztoque calteno huan mitztemohuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero Jesús quinnanquili: ―¿Ajqueya nonana? huan ¿ajqueya noicnihua? ");
INSERT INTO nheNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Huan quintlachili nopa tlacame tlen quiyahualohuayayaj huan quinilhui: ―Xiquitaca ni tlacame tlen itztoque nica, yajuanti niquinita para nonana huan noicnihua, ");
INSERT INTO nheNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","pampa ajqueya quichihua tlen Toteco Dios quinequi, yajaya niquita queja noicni huan nonana. ");
INSERT INTO nheNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesús sampa pejqui tlamachtía iteno hueyi atl, huan mosentilijque miyac tlacame tlen quiyahualocoj. Huajca Jesús calajqui ipan se cuacanahua ipan hueyi atl huan mosehui, huan nochi tlacame mocajque xalixco nechca iteno hueyi atl. ");
INSERT INTO nheNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Huan Jesús tlamachtiyaya miyac tlamantli ica huicalotl huan huicaltili huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“¡Xijtlacaquilica! Se tlacatl yajqui quiijtzeloto trigo. ");
INSERT INTO nheNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Huan quema quiijtzelohuayaya, sequin xinachtli huetzqui ipan ojtli huan hualajque totome huan quicuajque. ");
INSERT INTO nheNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sequinoc xinachtli huetzqui temajcajya campa ax oncayaya miyac tlali. Nopa xinachtli nimantzi ixhuac pampa ax huejcatla nopa tlali. ");
INSERT INTO nheNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero quisqui tonati, huan tonal tlatlac huan nimantzi huajqui pampa ax huelqui motlatzquilía inelhuayo. ");
INSERT INTO nheNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Sequinoc xinachtli huetzqui huitzijtic huan nopa huitztli quiijiyomicti nopa tlatoctli, yeca nopa xinachtli ax temacac itlajca. ");
INSERT INTO nheNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero sequinoc xinachtli huetzqui ipan cuali tlali. Tlaixhuac cuali, huan moscalti huan cuali temacac itlajca. Sequin nopa tlatoctli trigo temacac treinta xinachtli, huan sequinoc tlatoctli temacac sesenta xinachtli huan sequinoc tlatoctli temacac se ciento xinachtli.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Huan teipa Jesús quinilhui: “Nochi imojuanti ya innechcactoque. Huajca xijneltocaca tlen nimechilhuía.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Teipa quema quistoyaj nopa miyac tlacame, Jesús huan nopa majtlactli huan ome imomachtijcahua huan sequinoc tlen itztoyaj ihuaya quinechcahuijque huan pejque quitlatzintoquilíaj tlachque quiijtosnequi nopa huicaltili. ");
INSERT INTO nheNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Huan Jesús quinilhui: “Toteco Dios inmechcahuilijtoc xijmachilica quejatza yajaya tlanahuatía yonque achtohuiya axaca quicahuiliyaya ma quimachili. Huan ama nojquiya ica tlacame tlen nechhuejcamajcahuaj, niquinilhuía nochi tlamantli ica huicalotl. ");
INSERT INTO nheNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Quej nopa yonque quiitase tlen nijchihua, ax quimatise tlachque quinequi quiijtos. Huan yonque quicaquise notlajtol, ax quimachilise. Huan quej ni ax moyolcuepase, huan ax quipantise tlapojpolhuili para inintlajtlacolhua.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Huan Jesús quinilhui nojquiya: “¿Intla ax inquimachilíaj ni huicalotl, quejatza huelis inquimachilise sequinoc huicalotl? ");
INSERT INTO nheNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nopa tlacatl tlen quisemanqui nopa xinachtli quichihua queja se tlacatl tlen quinilhuía tlacame itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Sequin tlacame itztoque queja nopa xinachtli tlen huetzqui ojtipa. Quicaquij itlajtol Toteco, pero nimantzi huala Axcualtlacatl huan quinquixtilía tlen Toteco quitlalijtoc ipan ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui temajcajya. Quicaquij itlajtol Toteco huan nimantzi quiselíaj ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero queja nopa xinachtli tlen ax hueli motlatzquilía inelhuayo, ax quipiyaj chicahualistli. San itztoque para se tlalochtli, pampa quema huala trabajojyotl huan sequinoc quintlatzacuiltíaj pampa quiselijtoque itlajtol Toteco, nimantzi quicajtehuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui ipan huitztli. Quicaquij itlajtol Toteco, ");
INSERT INTO nheNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero mocuatotoníaj miyac ica nochi tlamantli tlen onca ipan ni tonal. Mocajcayajtoque pampa moilhuíaj paquise intla quipiyase miyac tomi. Tlahuel quinequij miyac tlamantli tlen onca. Huan nochi ni tlamantli tlen quinequij quiijiyomictíaj itlajtol Toteco, huan yeca ax temaca itlajca. ");
INSERT INTO nheNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui ipan cuali tlali. Yajuanti, quena, quicaquij itlajtol Toteco, huan quiselíaj huan temacaj inintlajca. Sequin tlen yajuanti itztoque queja se trigo tlatoctli tlen temaca treinta xinachtli, huan sequinoc queja tlen temaca sesenta xinachtli, huan sequinoc itztoque queja se trigo tlatoctli tlen temaca se ciento xinachtli.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nojquiya Jesús quinilhui: “Axaca quitlatía se tlahuili huan quitlalía cajon tzala, niyon ax quitlalis tlapech tzala. Nochi quimatij quitlalise se tlahuili huejcapa ipan se tlaquetzali para ma tlatlanexti. ");
INSERT INTO nheNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Quej nopa nojquiya ica nochi tlamantli tlen ama motlatijtoc. Teipa mocahuas tlanempa huan nochi inquimachilise. Huan tlamantli tlen tlacame ax hueli quimachilíaj ama pampa nimechmachtía ica huicalotl, teipa nochi campa hueli quimatise. ");
INSERT INTO nheNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Nochi imojuanti ya innechcactoque, huajca xijneltocaca tlen nimechilhuía.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nojquiya Jesús quinilhui: “Xijpiyaca cuidado quejatza inquicaquij. Intla inquicaquij huan inquineltocaj quentzi, huajca inquimachilise san quentzi. Pero intla inquicaquij cuali huan inquineltocaj nochi, huajca cuali inquimachilise. Huan hasta noja más Toteco inmechpalehuis xijmachilica. ");
INSERT INTO nheNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pampa se tlacatl tlen quipiya itlalnamiquilis para quicaquis notlajtol, Toteco quimacas más tlalnamiquistli. Pero se tlacatl tlen ax quinequi quicaquis notlajtol, Toteco quiquixtilis tlen quentzi quicactoc.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nojquiya Jesús quinilhui: “Moscaltía ininmiyaca nopa tlacame tlen Toteco quinnahuatía yonque axaca momaca cuenta. Eltoc queja se tlacatl tlen quiijtzelohua xinachtli ipan tlali. ");
INSERT INTO nheNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Yajaya cochis ica tlayohua huan mehuas ica ijnaloc. Panos se ome tonali huan teipa nopa xinachtli ixhuas huan moscaltis, pero nopa tlacatl ax quimati quejatza moscalti. ");
INSERT INTO nheNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Achtohui sesen tlatoctli panquisa, huan quisa ixihuiyo. Teipa panquisa ipiloloyo huan teipa itlancoch ipan ioloyo. ");
INSERT INTO nheNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Huan quema nopa simolotl ya chicajtos, nopa tlacatl pehuas quipixcas pampa cuali quimacatoc itlajca.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nojquiya Jesús quiijto: “¿Quejatza huelis nimechilhuis quejatza pehua tlanahuatía Toteco Dios ipan ininyolo tlacame ipan se yancuic lugar? ¿Ica tlachque nijhuicalotis para inquimachilise? ");
INSERT INTO nheNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Quema yajaya tlanahuatía, pehua queja se ixinajcho mostaza tlen se tlacatl quitoca. Nopa xinachtli eltoc más pilsiltzi tlen nochi xinachtli tlen onca ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero quema se tlacatl quitoca nopa xinachtli mostaza, moscaltía huan mochihua más hueyi tlen nochi xihuitzontli huan mochihua se cuahuitl. Huan imacuayo moscaltía huan moxacalohua huan ipani totome hueli mosehuise pampa cuali itlaacahuilo.” ");
INSERT INTO nheNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Huan Jesús quinmachtiyaya tlacame itlajtol Toteco ica miyac huicalotl quej ni. Quinilhui nochi tlen huelque quimachilíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Huan nochi nopa tlamachtilistli quinilhuiyaya ica huicalotl. Pero quema itztoya san ica imomachtijcahua, quinixtomiliyaya tlachque quiijtosnequiyaya sesen huicalotl. ");
INSERT INTO nheNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Quema tlatlayohuac nopa tonal, Jesús quinilhui imomachtijcahua: ―Ma tiquixcotonaca ne hueyi atl hasta ne seyoc nali. ");
INSERT INTO nheNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Huajca quincajtejque nopa miyac tlacame tlen itztoyaj tlalpani huan imomachtijcahua quihuicaque ipan cuacanahua ica Jeús mosehuiyaya campa ipa itztoya huan yajque para seyoc nali. Huan nojquiya itztoyaj sequinoc tlacame tlen yajque ininhuaya ipan tlen yajuanti inincuacanahua. ");
INSERT INTO nheNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Huan nimantzi hualajqui se ajacatl tlen tlahuel chicahuac. Huan motlalanqui hueyi atl huan pejqui acalaqui inincuacanahua hasta temisnequiyaya. ");
INSERT INTO nheNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Huan Jesús cochtoya iica ipan nopa cuacanahua, motzontectoya ipan se piltzontetontzi. Huajca imomachtijcahua quiixitijque huan quiilhuijque: ―¡Tlamachtijquetl! ¿Ax timomaca cuenta para timisahuijtinemij? ");
INSERT INTO nheNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Huajca Jesús mejtiquisqui huan quitlacahualti nopa ajacatl huan quiilhui hueyi atl: ―Amo ximolini, san xielto. Huan nopa ajacatl moquetzqui huan nopa hueyi atl ayoc mojmolini. ");
INSERT INTO nheNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Huajca Jesús quinilhui imomachtijcahua: ―¿Para tlen nelía inmajmahuij? ¿Ax inquineltocaj tlen hueli nijchihua? ");
INSERT INTO nheNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Huan nelía imomachtijcahua pejque momajmatijque huan moilhuijque se ica seyoc: ―¿Ajqueya nelía ni Jesús? Hasta nopa ajacatl huan hueyi atl quineltocaj itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ajsitoj Jesús huan imomachtijcahua nopa seyoc nali hueyi atl campa tlali Gadara. ");
INSERT INTO nheNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Huan Jesús quisqui ipan cuacanahua huan nimantzi ajsico se tlacatl campa ya tlen quisqui ipan campo santo huan quipixqui iajacahua Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nopa tlacatl mocahuayaya nochi tonal ipan campo santo, huan axaca hueliyaya quiilpía para quihuicas, yonque quiilpisquía ica tepos cadena. ");
INSERT INTO nheNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Miyac huelta quiilpitoyaj ica tepos cadena ipan iicxi huan ipan ima, pero quicocototzayaya nopa tepos cadena, huan san cuechtic quichihuayaya. Huajca axaca huelqui quitlani. ");
INSERT INTO nheNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tonali yohuali nopa tlacatl tzajtzitinemiyaya ipan campo santo huan campa tepetini huan iselti mococohuayaya ica tetl. ");
INSERT INTO nheNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pero quema quiitac Jesús ica huejca, motlalo huan motlancuaquetzqui iixtla. ");
INSERT INTO nheNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Huan Jesús quiilhui: ―Iniajacahua Axcualtlacatl, xiquisaca ipan ni tlacatl. Huan nopa tlacatl quiijto chicahuac: ―¿Tlachque tijpiya noca na? TiJesús, tiIcone Dios Tlen Más Quipiya Tlanahuatili. Xijtestigojquetza Dios para ax titechtlaijiyohuiltis. ");
INSERT INTO nheNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Huan Jesús quitlajtlani: ―¿Quejatza motoca? Huan quinanquili: ―Notoca, Miyac, pampa nelía timiyaqui tiajacame. ");
INSERT INTO nheNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huan nopa ajacame quitlajtlanijque Jesús chicahuac para ma ax quintitlanis hasta sejcoyoc. ");
INSERT INTO nheNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Huan nepa nechca itztoyaj miyac pitzome tlen tlacuayayaj ipan se lado se tepetl. ");
INSERT INTO nheNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Huan iajacahua Axcualtlacatl quitlajtlanijque: ―Xitechtitlani ma ticalaquica ipan ne pitzome. ");
INSERT INTO nheNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Huajca Jesús quincahuili. Huan nochi nopa iajacahua Axcualtlacatl quisque ipan nopa tlacatl huan calajque ipan nopa pitzome. Huan itztoyaj nechca ome mil pitzome nopano. Huan nopa pitzome motlalojtejque campa se tlaixtemolis, huan huetzque ipan hueyi atl huan nimantzi misahuijque. ");
INSERT INTO nheNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Huajca nopa tlacame tlen quinmocuitlahuiyayaj nopa pitzome motlalojtejque huan quinpohuilitoj tlen panotoya nopa tlacame tlen itztoyaj ipan nopa altepetl huan ipan ranchos nechca. Huan nopa altepetl ehuani quisque quitlachilicoj tlachque ininpantic nopa pitzome. ");
INSERT INTO nheNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Huan quema ajsicoj campa Jesús, quiitaque nopa tlacatl tlen achtohuiya quinpixtoya nopa miyac iajacahua Axcualtlacatl. Huan ama nopa tlacatl san locotzijtoya, huan moyoyontijtoya huan quipixtoya cuali itlalnamiquilis. Huan nopa tlacame momajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Huan nopa tlacame tlen quiitztoyaj tlen panoc sampa quinpohuilijque tlen ajsiyayaj nochi tlen panotoya ica nopa tlacatl tlen quinpixtoya ajacame. Huan nojquiya quinpohuilijque tlen panoc ica nopa pitzome. ");
INSERT INTO nheNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Huajca nopa tlacame pejque quitlajtlaníaj Jesús ma quisa ipan inintlal. ");
INSERT INTO nheNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Huan Jesús calajqui ipan nopa cuacanahua para quisas, huan nopa tlacatl tlen achtohui quinpiyayaya iajacahua Axcualtlacatl quitlajtlani ma quicahuili yas ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús ax quicahuili. Quiilhui: ―Xiya mochaj, xiquinpohuili moteixmatcahua nopa hueyi tlamantli tlen Toteco mitzchihuilijtoc huan queja mitzicnelía. ");
INSERT INTO nheNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Huajca nopa tlacatl quisqui huan pejqui quinpohuilía tlacame ipan nochi altepetini tlen Decápolis nopa huejhueyi tlamantli tlen Jesús quichihuilijtoya. Huan nochi tlen quicajque san quisentlachiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús sampa quiixcotonqui hueyi atl ipan cuacanahua hasta seyoc nali. Huan mosentilijque miyac tlacame tlen quiyahualojque huan yajaya mocahuayaya ateno. ");
INSERT INTO nheNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Huan ajsico se tequihue tlen nopa israelita tiopamitl tlen itoca eliyaya Jairo. Huan quema Jairo quiitac Jesús, motlancuaquetzqui, ");
INSERT INTO nheNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","huan ica nochi iyolo, quiilhui: ―Nosihuapil miquinequiya. Xiya, xijtlaliliti moma para mochicahuas huan yolis. ");
INSERT INTO nheNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Huajca Jesús yajqui ihuaya, huan miyac tlacame quintoquiliyayaj huan quicuatetzopayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Huan itztoya nopano se sihuatl tlen mojmostla esotemoyaya para majtlactli huan ome xihuitl. ");
INSERT INTO nheNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Quiijiyohuijtihualajtoya miyac tlamantli ininmaco miyac tepajtiani para quichicahuasquíaj pero san quiyaltijtoya nochi tomi tlen quipixtoya, huan ax tleno quipalehui. San achi más motlahueltiyaya. ");
INSERT INTO nheNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Huan quema nopa sihuatl quicajqui tlen Jesús, hualajqui huan monechcahui iica ininhuaya nopa tlacame huan quiajsic iyoyo. ");
INSERT INTO nheNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Pampa nopa sihuatl moilhuiyaya: “Intla san huelisquía nicajsis iyoyo, nimochicahuas.” ");
INSERT INTO nheNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Huan nimantzi huajqui icocolis huan quimatqui para ya mochicajtoya. ");
INSERT INTO nheNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Huan Jesús nimantzi quimachili para quistoya chicahualistli ipan ya huan quichicajtoya se tlacatl. Huajca moicanitac, huan quintlachili nopa miyac tlacame huan quintlajtlani: ―¿Ajqueya quiajsic noyoyo? ");
INSERT INTO nheNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Huan imomachtijcahua quiilhuijque: ―Ta tiquita ni tlacame mitzcuatetzopaj, ¿para tlen titlatzintoca, ajqueya quiajsic moyoyo? ");
INSERT INTO nheNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Jesús moicancueptoya huan tlachiyayaya campa hueli para quiitas ajqueya quiajsitoya. ");
INSERT INTO nheNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Huajca nopa sihuatl tlen quimatqui ya mochicajtoya momajmatiyaya huan huihuipicayaya. Huan yajqui motlancuaquetzato iixtla Jesús huan quiilhui xitlahuac tlen quichijqui. ");
INSERT INTO nheNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Huan Jesús quiilhui: ―Nane, timochicajqui pampa tinechneltocatoc. Xiya ica paquilistli pampa ayoc tijpiya mococolis. ");
INSERT INTO nheNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesús noja quiilhuiyaya nopa sihuatl quema ajsicoj sequin tlacame tlen hualajque tlen ichaj nopa hueyi tequihue ipan nopa israelita tiopamitl. Quiilhuijque itata nopa sihuapil: ―Mosihuapil ya mijqui. Ayoc xijcuatotoni ni tlamachtijquetl. ");
INSERT INTO nheNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús quicajqui tlen quiilhuijque huan quiilhui nopa tequihue tlen tiopamitl: ―Amo ximomajmati, san xinechneltoca. ");
INSERT INTO nheNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Huan Jesús ax quincahuili sequinoc ma yaca ihuaya. San quincahuili Pedro, Jacobo huan iicni, Juan. ");
INSERT INTO nheNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Huan quema ajsitoj ichaj nopa hueyi tequihue tlen tiopa, quinpanti tlacame tlahuejchihuayayaj, chocayayaj huan tzajtziyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Huajca Jesús calaquito campa nopa mijcatzi huan quinilhui: ―¿Para tlen intlahuejchihuaj huan inchocaj? Ni sihuapil ax mictoc, yajaya san cochtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero nopa tlacame san quihuetzquilijque Jesús. Huajca Jesús quinquixti nopa tlacame. Teipa quinhuicac itata huan inana nopa sihuapil, huan nopa eyi imomachtijcahua huan calajque campa quitectoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Huan Jesús quimaitzqui nopa sihuapil huan quiilhui: ―Talita, cumi (quiijtosnequi: ‘Sihuapil, nimitzilhuía: ximehua.’) ");
INSERT INTO nheNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Huan ipan nopa tlalochtli nopa sihuapil tlen quipixtoya majtlactli huan ome xihuitl, mejqui huan pejqui nejnemi, huan nochi tlen itztoyaj ihuaya nelía momajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Huan Jesús quinnahuati chicahuac ma axaca quiilhuica. Huan quinilhui ma quitlamacaca nopa sihuapil. ");
INSERT INTO nheNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús quisqui nepa huan mocuepqui ialtepe huan imomachtijcahua yajque ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ipan sábado, nopa tonal para israelitame ma mosiyajcahuaca, Jesús pejqui tlamachtía ipan israelita tiopamitl. Huan miyac tlacame tlen quicajque quisentlachilijque huan quiijtojque: ―¿Ajqueya quimachtijtoc nochi ya ni? ¿Canque quicuic nochi ni tlalnamiquistli? ¿Quejatza hueli quichihua ni huejhueyi chicahualis nescayotl? ");
INSERT INTO nheNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yajaya se cuaxinquetl. Yajaya icone María huan iicni Jacobo, José, Judas, huan Simón. Isihua icnihua nojquiya itztoque nica tohuaya. Huan yeca tlen san sejco ehuani ica Jesús ax quinejque quichihuilise cuenta. ");
INSERT INTO nheNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Huan Jesús quinilhui: ―Nochipa tlacame tlen san sejco ehuaj se tiocamanalojquetl ax quitlepanitaj. Niyon ax quitlepanitaj iteixmatcahua huan ichampoyohua, pero sejcoyoc ehuani, quena, quitlepanitaj. ");
INSERT INTO nheNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yeca Jesús ax huelqui quichijqui niyon se chicahualis nescayotl ipan ialtepe. San quitlali ima ipan se ome cocoyani huan quinchicajqui. ");
INSERT INTO nheNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Huan Jesús san quinsentlachili nopa tlacame tlen ehuayaya ipan ialtepe pampa ax quineltocaque. Teipa Jesús panotinenqui ipan miyac pilaltepetzitzi tlen nejnechca para tlamachtis. ");
INSERT INTO nheNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Teipa Jesús quinnotzqui nopa majtlactli huan ome imomachtijcahua huan pejqui quintitlani ma yaca ojome para teilhuitij itlajtol Toteco. Huan quinmacac tequihuejcayotl ica iajacahua Axcualtlacatl tlen calactoya ipan tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Huan Jesús quinnahuati para ax tleno ma quihuicaca ipan ojtli. Ma ax quihuicaca se yoyon coxtali, niyon pantzi, niyon tomi. Ma quihuicaca san setzi cuatopili huan ax tleno más. ");
INSERT INTO nheNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Quinilhui huelis motlalilise tecactli, pero ma ax quihuicaca yoyomitl tlen ica mopatlase. ");
INSERT INTO nheNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Huan Jesús quinilhui: ―Quema inajsise ipan se altepetl huan se inmechnotzas para ximocahuaca ichaj, ximocahuaca ipan ichaj hasta inquisase ipan nopa altepetl. ");
INSERT INTO nheNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Huan intla inajsitij ipan se altepetl, huan ax inmechselíaj huan ax inmechtlacaquilíaj; xiquisaca nepa huan ximotecactzejtzeloca para inquiquixtilise nopa tlalpotectli. Ica nopa tlanescayotl inquinextise para ipan nopa tonal quema Toteco tetlajtolsencahuas, nopa tlacame ipan nopa altepetl tlen ax inmechselijque quipantise se tlatzacuiltilistli tlen más hueyi que altepetini Sodoma huan Gomorra. ");
INSERT INTO nheNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Huajca imomachtijcahua quisque huan teilhuitoj para tlacame ma moyolcuepaca huan quicahuaca inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Huan quinquixtijque miyac iajacahua Axcualtlacatl tlen calactoyaj ipan tlacame, huan quitlalijque aceite ipan miyac cocoyani huan quinchicajque. ");
INSERT INTO nheNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nopa Tlanahuatijquetl Herodes Ántipas quicajqui tlen Jesús pampa nochi tlacame campa hueli quimatiyayaj tlen quichihuayaya. Huan Herodes quiijto para Jesús elqui Juan tlen mijqui, huan ama moyolcuitoya huan yeca huelqui quichihua huejhueyi chicahualis nescayotl. ");
INSERT INTO nheNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sequinoc quiijtohuayayaj para Jesús eliyaya nopa tiocamanalojquetl Elías. Huan sequinoc quiijtohuayayaj para Jesús eliyaya se tiocamanalojquetl queja nopa tiocamanalohuani tlen itztoyaj huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero quema quicajqui Tlanahuatijquetl Herodes tlen Jesús quichihuayaya, quiijto para Jesús eliyaya Juan tlen tecuaaltiyaya huan tlen ya iselti tlanahuati ma quiquechtzontequica. Moilhui para ama Juan ya moyolcuitoya. ");
INSERT INTO nheNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tlanahuatijquetl Herodes Ántipas achtohui quintitlanqui isoldados ma quiitzquica Juan huan ma quitzacuaca. Quichijqui ya nopa para ma paqui Herodías tlen eltoya isihua. Nopa sihuatl Herodías eltoya isihua Herodes Felipe I tlen eli iicni Tlanahuatijquetl Herodes Ántipas, pero teipa Tlanahuatijquetl Herodes Ántipas mocuili para isihua. ");
INSERT INTO nheNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Huan yeca Juan quiilhuijtoya Tlanahuatijquetl Herodes para ax cuali mocuilijtoya ihuejpol. ");
INSERT INTO nheNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huajca yeca nopa sihuatl, Herodías, quicualancaitayaya Juan. Quinequiyaya quimictis, pero ax hueliyaya. ");
INSERT INTO nheNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Tlanahuatijquetl Herodes quiimacasiyaya Juan pampa quimatiyaya eliyaya se tlacatl tlen xitlahuac huan tlatzejtzeloltic, yeca quimocuitlahuiyaya para ax tleno ipantisquía. Quema Herodes quicajqui itlamachtil Juan, ax quimachili. San moyolilhuiyaya miyac tlen nochi tlen quiijtohuayaya. Pero nochipa quicaquiyaya ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero se tonal nopa sihuatl Herodías quipanti quejatza huelis quimictis Juan quema nopa Tlanahuatijquetl Herodes quichijqui se ilhuitl pampa quiaxiti ixihui. Quipixqui se tlacualistli huan quinnotzqui itequihuejcahua ihuaya itlanahuatijcahua huan tlen tominpixque ipan itlal. ");
INSERT INTO nheNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Huan hualajqui iichpoca nopa sihuatl Herodías huan mijtotijqui iselti iniixtla nopa tlanotzalme. Huan quinpacti Tlanahuatijquetl Herodes huan nopa tlacame tlen tlacuayayaj ihuaya. Huajca Herodes quiilhui nopa ichpocatl: ―Xinechtlajtlani tlen tijnequis huan nimitzmacas. ");
INSERT INTO nheNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Huan Herodes tlatestigojquetzqui chicahuac iniixtla nochi itlanotzalhua huan quiilhui nopa ichpocatl: ―Nimitzmacas nochi tlen tinechtlajtlanis yonque tinechtlajtlanis tlajco ni tlaltini campa nijpiya tlanahuatili. ");
INSERT INTO nheNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Huan nopa ichpocatl quisqui huan quiilhuito Herodías, tlen eliyaya inana, huan quitlajtlani tlachque cuali quitlajtlanis. Huan inana quinanquili: ―Xiquilhui tijnequi itzonteco Juan tlen tecuaaltía. ");
INSERT INTO nheNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Huan nimantzi mocuepqui nopa ichpocatl ipan nopa ilhuitl campa itztoya Herodes huan quiilhui: ―Nijnequi amantzi xinechmaca itzonteco Juan, nopa tecuaaltijquetl. Xinechmaca ipan se hueyi plato. ");
INSERT INTO nheNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Huajca nelía mocueso nopa tlanahuatijquetl. Pero tlatestigojquetztoya huan quicactoyaj itlanotzalhua ipan nopa tlacualistli huan yeca ax quinejqui quiilhuis para ax quimacas. ");
INSERT INTO nheNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Huajca nimantzi quititlanqui se isoldado, huan quinahuati ma quihualica itzonteco Juan. ");
INSERT INTO nheNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Huajca yajqui isoldado Herodes campa tzactoya Juan huan quiquechtzontequito. Huan quihualicac ipan se hueyi plato, huan quimacac nopa ichpocatl, huan nopa ichpocatl quimacac inana. ");
INSERT INTO nheNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Huan quema quimatque itlatoquilijcahua Juan para quimictijtoyaj, hualajque quitlalanque itlacayo huan quitlalpachojque. ");
INSERT INTO nheNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Teipa imomachtijcahua Jesús mocuepque tlen campa hueli nejnentoyaj huan mosejcotilijque ihuaya Jesús. Huan quipohuilijque nochi tlen quichijtoyaj huan tlen tlamachtijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Huan Jesús quinilhui imomachtijcahua: ―Xihualaca nohuaya ma timosiyajcahuatij quentzi campa tlatzitzica. Quinilhui ya ni pampa ajachica miyac tlacame hualayayaj huan yohuiyayaj, huan Jesús ihuaya imomachtijcahua ax quipiyayayaj niyon se tlalochtli para tlacuase. ");
INSERT INTO nheNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Huajca Jesús ininhuaya imomachtijcahua yajque san sejco ipan se cuacanahua hasta campa ax oncayaya caltini. ");
INSERT INTO nheNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero miyac tlacame quinitaque quema yajque ipan cuacanahua huan quiixmatque para eliyaya Jesús. Huan quisque tlen nopa altepetini huan motlalojque hasta campa Jesús huan imomachtijcahua ajsisquíaj, huan yajuanti achtohui ajsitoj nepa. ");
INSERT INTO nheNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Huan quema Jesús temoc ipan cuacanahua huan quiitac para ya ajsitoyaj nopa miyac tlacame, quintlasojtlac pampa itztoyaj queja borregojme tlen ax quipiyayayaj se tlamocuitlahuijquetl. Huan Jesús pejqui quinmachtía miyac tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Huan quema tlatlayohuatinemiyaya, imomachtijcahua monechcahuijque huan quiilhuijque: ―Ya tiotlaquixqui huan nica ax tleno onca. ");
INSERT INTO nheNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xiquinnahuati ni tlacame ma yaca ipan ranchos huan ipan pilaltepetzitzi tlen nechca ma mocohuitij pantzi pampa ax tleno quipiyaj para quicuase. ");
INSERT INTO nheNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero Jesús quinnanquili huan quinilhui: ―Xiquintlamacaca imojuanti. Huan imomachtijcahua quiilhuijque: ―¿Tijnequi tiquijtos ma tiyaca huan tijcohuatij pantzi tlen ome ciento tonali tequitl para tiquintlamacase nochi ni tlacame? ");
INSERT INTO nheNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Huan Jesús quinilhui: ―¿Quesqui pantzi inquipiyaj? Xijtlachilitij. Huan quema quimatque, quiilhuijque: ―Macuili pantzi huan ome michime. ");
INSERT INTO nheNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Huajca quinnahuati imomachtijcahua ma quinilhuica nopa tlacame ma mosehuica ica pamitl ipan nopa xoxohuic sacapetlatl. ");
INSERT INTO nheNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Huan mosehuijque ica pamitl tlen cien huan tlen cincuenta tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Huajca Jesús quiitzqui nopa macuili pantzi huan nopa ome michime. Huan ajcoitac elhuicac huan quitlascamatqui Toteco. Huan quitlajcotlapanqui nopa pantzi huan quinmacac imomachtijcahua para ma quinmajmacaca nochi nopa tlacame. Nojquiya Jesús quinmajmacac nopa ome michime nochi tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Huan nochi tlacuajque huan cuali ixhuique. ");
INSERT INTO nheNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Huan teipa quisentilijque nopa panpayaxtli huan michpayaxtli tlen mocajtoya huan quitemitijque majtlactli huan ome chiquihuitl. ");
INSERT INTO nheNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Huan nopa tonal tlacuajque macuili mil san tlacame huan ax quinpojque nopa sihuame huan coneme. ");
INSERT INTO nheNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Huan nimantzi Jesús quinilhui imomachtijcahua ma calaquica ipan cuacanahua huan ma moachtohuica para quiixcotonase nopa hueyi atl hasta seyoc nali campa altepetl Betsaida. Huan yajaya mocajqui para tenahuatijtehuas. ");
INSERT INTO nheNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Huan teipa quema Jesús tlanqui quinnahuatijtehua, yajqui ipan se tepetl para momaijtos. ");
INSERT INTO nheNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Huan quema tlayohuixqui, nopa cuacanahua ica imomachtijcahua sanoc nejnentoya tlajco hueyi atl, huan Jesús mocajtoya iselti ipan tlali. ");
INSERT INTO nheNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Huan quiitac para imomachtijcahua tlaxicojtoyaj pampa tequitiyayaj chicahuac para quinejnemiltise inincuacanahua ipan atl huan chicahuac quinilpitzayaya ajacatl. Huajca queja las tres ica tlayohua, Jesús monechcahui campa imomachtijcahua, nejnemiyaya aixco. Quinequiyaya quinpanos para quintlayacancuilis. ");
INSERT INTO nheNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero quema imomachtijcahua quiitaque nejnemiyaya aixco, moilhuijque huala se animajtzi huan tzajtzique, ");
INSERT INTO nheNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","pampa nochi quiitaque huan momajmatiyayaj. Huajca nimantzi Jesús quincamahui huan quinilhui: ―Ximosemacaca. Na niJesús. Amo ximomajmatica. ");
INSERT INTO nheNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huan Jesús calajqui ipan cuacanahua ininhuaya imomachtijcahua huan nimantzi moquetzqui ajacatl, huan nelía quisentlachilijque. ");
INSERT INTO nheNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aya quimachiliyayaj ichicahualis Jesús tlen quinnextili quema quimiyaquili nopa pantzi pampa noja yoltetixtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús huan imomachtijcahua quiixcotonque nopa hueyi atl huan ajsitoj ateno ipan altepetl Genesaret. Huan nepa quiilpijque inincuacanahua. ");
INSERT INTO nheNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Huan quema quisque ipan cuacanahua, nimantzi tlacame nepa quiixmatque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Huajca nopa tlacame motlalojtiyajque ipan nochi inintlal huan pejque quinquechpanojtihualahuij nochi cocoyani ipan inintlapech hasta campa quicaquiyayaj para Jesús itztoya. ");
INSERT INTO nheNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Huan campa hueli quema Jesús calaquiyaya ipan ranchos o ipan altepetini o campa caltini, tlacame quintecayayaj nochi cocoyani campa panosquía. Huan nopa cocoyani quitlajtlaniyayaj ma quincahuili san quiajsisquíaj iyoyo, huan nochi tlen quiajsique iyoyo, mochicajque. ");
INSERT INTO nheNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Huajca mosentilijque campa Jesús nopa fariseos huan sequin tlamachtiani tlen itlanahuatil Moisés tlen hualajtoyaj tlen altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Huan quiitaque para sequin imomachtijcahua Jesús tlacuayayaj huan ax momajtequijtoyaj miyac huelta queja momajtoyaj israelitame para motlapajpacchihuase, huajca quinteilhuijque. ");
INSERT INTO nheNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nopa fariseos huan nochi israelitame quitoquilijque tlen quiijtojque tohuejcapan tatahua. Moilhuiyayaj intla ax momajtequíaj miyac huelta, ax hueli tlacuase. ");
INSERT INTO nheNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Huan nojquiya moilhuiyayaj quema mocuepaj ica tianquis, monequi momajtequise achtohui huan teipa tlacuase. Huan quitoquilijque miyac tlamachtili tlen huejcajquiya. Quipajpacayayaj inintazas, ininxarro huan inintepospaila queja quiijtojque tohuejcapan tatahua. ");
INSERT INTO nheNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Huajca nopa fariseos huan tlamachtiani tlen itlanahuatil Moisés quitlajtlanijque Jesús: ―¿Para tlen momomachtijcahua ax quitoquilíaj inintlamachtil tohuejcapan tatahua? Yajuanti tlacuaj yonque ax momajtequijtoque queja quiijtohua nopa tlanahuatili. ");
INSERT INTO nheNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Huan Jesús quinnanquili: ―¡Inquipiyaj ome imoxayac! Melahuac nopa tlajtoli tlen Toteco quimacac nopa tiocamanalojquetl Isaías ma quiijcuilo tlen imojuanti campa Toteco quiijto: ‘Ni tlacame quiijtohuaj nechtlepanitaj, pero ax neli. Ipan ininyolo ax quema nechilnamiquij. ");
INSERT INTO nheNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Huajca san tlapic nechhueyichihuaj, pampa tlamachtíaj inintlajtol tlacame queja eltosquía notlajtol.’ ");
INSERT INTO nheNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Imojuanti nojquiya inquitlahuelcajtoque itlanahuatil Toteco para inquitoquilise inintlamachtil tlacame. Inquitoquilíaj nopa tlanahuatili para quejatza monequi inquipajpacase xarros huan tazas tlen ipan inatlise huan inquitoquilíaj miyac más tlamantli queja nopa. ");
INSERT INTO nheNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Huan Jesús nojquiya quinilhui: ―Inquinilcajtoquejya itlanahuatil Toteco pampa inquinequij inquitoquilise inintlamachtil tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pampa Moisés quiijto: ‘Xijtlepanita motata huan monana’, huan nojquiya quiijto: ‘Intla se quitelchihuas itata o inana, ma miqui.’ ");
INSERT INTO nheNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero inquiijtohuaj se tlacatl huelis quiilhuis itata o inana para ax huelis quinpalehuis ica tlen monequi para ica panose pampa nochi tlen quipiyaj mocahua Corbán o tlaiyocatlalili para quimactilise Toteco, yonque ax neli nopa tlajtoli. ");
INSERT INTO nheNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Huajca ayoc inquincahuilíaj tlacame ma quinpalehuica inintatahua huan ininnanahua. ");
INSERT INTO nheNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Huajca queja nopa inquitlahuelcajtoque itlajtol Toteco para inquitoquilise inintlamachtil tlacame. Huan inquichihuaj miyac tlamantli quej ni tlen ax xitlahuac. ");
INSERT INTO nheNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sampa Jesús quinnotzqui nopa miyac tlacame nepa huan quinilhui: ―Xinechtlacaquilica nochi imojuanti, huan xijmachilica tlen nimechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ax tleno tlen quicua se tlacatl hueli quiijtlacohua iixtla Toteco Dios. Pero tlen quisa ipan iyolo se tlacatl queja tlen ax cuali quiijtohua huan quichihua, ya nopa quena quiijtlacohua iixtla Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Nochi innechtlacaquilijque, huajca xijneltocaca tlen nimechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huan teipa quema Jesús quincajtejtoya nopa miyac tlacame huan calactoya ipan se cali, imomachtijcahua quitlajtlanijque tlachque quiijtosnequi nopa huicalotl. ");
INSERT INTO nheNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Huan Jesús quinilhui: ―¿Para tlen imojuanti nojquiya ax inquimachilíaj? ¿Ax inquimatij ax tleno tlen se tlacatl quicuas huelis quiijtlacos iixtla Toteco? ");
INSERT INTO nheNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pampa itlacualis ax calaquis ipan iyolo. San calaquis iijtico huan teipa quisas ipan itlacayo. Quej nopa Jesús quinilhui para tlapajpactic iixtla Toteco nochi tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pero Jesús quinilhui: ―Ax tlapajpactique tlacame iixtla Toteco Dios pampa ipan ininyolo quisa tlen ax cuali. ");
INSERT INTO nheNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ax tlapajpactique iixtla Toteco pampa quipiyaj inintlalnamiquilis tlen fiero, o quichihuaj tlen hueli ica ichpocame, o tlaxtequij, o temictíaj o momecatíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","O pampa tlahuel quinequij tlen iniaxca sequinoc, o se fiero ojtli quihuicaj, o tlacajcayahuaj o quinequij tlen ax cuali. Ax tlapajpactique iixpa pampa techicoitaj, o teistlacahuíaj, o mohueyimatij o mohuihuinequij. ");
INSERT INTO nheNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochi ni tlajtlacoli quinijtlacohua tlacame iixtla Toteco. Pero tlen quicua se tlacatl ax hueli quiijtlacos iixtla. ");
INSERT INTO nheNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesús quisqui nepa huan yajqui nechca altepetini Tiro huan Sidón huan calajqui ipan se cali. Ax quinequiyaya tlacame ma quimatica intla itztoya nopano, pero ax huelqui motlatía. ");
INSERT INTO nheNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Itztoya se sihuatl tlen quipixqui se isihuapil tlen quipiyayaya iajaca Axcualtlacatl. Huan nopa sihuatl quicajqui para itztoya Jesús nepa. Huan nimantzi hualajqui huan motlancuaquetzqui iixtla Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pero nopa sihuatl ax eliyaya se israelita. Yajaya camatqui griego huan ehua se lugar tlen itoca Fenicia ipan tlali Siria. Huan nopa sihuatl hualajqui huan quitlajtlani Jesús ma quiquixti nopa ajacatl tlen quipixtoya isihuapil. ");
INSERT INTO nheNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús quiilhui: ―Achtohui niquinpalehuis israelitame. Teipa niquinpalehuis tlen hualahui sejcoyoc tlaltini. Intla axtle, elis queja niquinmaca pilchichitzitzi inintlacualis coneme. ");
INSERT INTO nheNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Huan nopa sihuatl quinanquili: ―Quena, Toteco, pero quema coneme tlacuaj, huetzi se quentzi panpayaxtli mesajtzala huan pilchichitzitzi quipejpenaj. ");
INSERT INTO nheNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Huan Jesús quiilhui: ―Cuali tinechnanquili, huajca xiya mochaj; nopa ajacatl ya quistejqui ipan mosihuapil. ");
INSERT INTO nheNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Huan quema nopa sihuatl ajsito ichaj, quipanti isihuapil ayoc quipiyayaya nopa ajacatl, san mosiyajcahuayaya ipan itlapech. ");
INSERT INTO nheNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Huan Jesús quisqui campa itztoya nechca altepetl Tiro huan panoc altepetl Sidón. Teipa ajsico hueyi atl Galilea huan teipa panoc hasta tlali Decápolis. ");
INSERT INTO nheNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nopano tlacame quihualicaque se tlacatl tlen nacastzactoya huan nonotzi, huan quitlajtlanijque Jesús ma quitlali ima ipan nopa cocoxquetl para ma quichicahua. ");
INSERT INTO nheNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Huan Jesús quihuicac nopa tlacatl iyoca campa axaca aquiyaya, huan quinacasmayahuili. Teipa chajchac huan quitlalili ichajcha ipan inenepil nopa tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Huan Jesús ajcoitac elhuicac huan mijnelti huan quiilhui nopa nonotzi: “¡Efata!” (quinequi quiijtos: “¡Xitlapohui!”) ");
INSERT INTO nheNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Huajca ipan nopa tlalochtli tlapojqui inacas huan mochicajqui inenepil huan huelqui camati cuali. ");
INSERT INTO nheNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Huan Jesús quinnahuati nopa tlacame ma axaca quiilhuica. Pero yonque chicahuac quinnahuati, achi más tepohuiliyayaj tlen Jesús quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Huan nopa tlacame nelía quisentlachiliyayaj Jesús huan moijilhuiyayaj: “Yajaya quichihua nochi tlen cuali. Quinchihua ma tlacaquica tlen nacastapaltique huan ma camatica tlen nonome.” ");
INSERT INTO nheNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ipan nopa tonal sampa mosentilijtoyaj tlahuel miyac tlacame campa itztoya Jesús. Huan ax quipiyayayaj tlachque quicuase, huajca Jesús quinnotzqui imomachtijcahua huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Niquintlasojtla ni tlacame pampa quipiya eyi tonali itztoque nohuaya huan ax quipiyaj tlachque quicuase. ");
INSERT INTO nheNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Intla niquinmacahuas ma yaca ininchajchaj huan ax tlacuajtoque, huelis tlapolose ipan ojtli pampa sequin huejca hualajtoque. ");
INSERT INTO nheNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Huan imomachtijcahua quiilhuijque: ―¿Canque huelis tijpantise tlacualistli para huelis tiquintlamacase nochi ni tlacame nica ipan ni huactoc tlali campa ax tleno onca? ");
INSERT INTO nheNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Huan Jesús quintlajtlani: ―¿Quesqui pantzi inquipiyaj? Huan quiilhuijque: ―Chicome. ");
INSERT INTO nheNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Huajca Jesús quinnahuati nopa tlacame ma mosehuica tlalchi. Huan quiitzqui nopa chicome pantzi huan quitlascamatqui Toteco. Teipa quitlajcotlapanqui huan quinmacac imomachtijcahua para ma quinmajmacaca nopa miyac tlacame. Huan quinmajmacaque. ");
INSERT INTO nheNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Huan nojquiya quipixtoyaj se ome pilmichtzitzi, huan Jesús sampa quitlascamatqui Toteco huan nojquiya quinnahuati ma temajmacaca. ");
INSERT INTO nheNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Huan nopa miyac tlacame tlacuajque huan cuali ixhuique. Teipa quisentilijque nopa panpayaxtli huan michpayaxtli tlen mocajqui huan quitemitijque chicome chiquihuitl. ");
INSERT INTO nheNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Huan nopa tlacame tlen tlacuajtoyaj eliyayaj nechca nahui mil. Huan teipa Jesús quinnahuatijtejqui. ");
INSERT INTO nheNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Huan nimantzi calajqui ipan cuacanahua ihuaya imomachtijcahua, huan yajqui se tlali tlen itoca Dalmanuta. ");
INSERT INTO nheNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Huan hualajque nopa fariseos huan pejque quitlajtlaníaj Jesús para quimasiltise ica inintlajtol. Huan para quiyejyecose Jesús, quitlajtlanijque ma quinnextili ichicahualis ica se tlanescayotl tlen huala tlen elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Huan Jesús mijnelti chicahuac huan quiijto: ―¿Para tlen tlacame tlen ama itztoque tlajtlanij para ma niquinnextili se tlanescayotl? Melahuac nimechilhuía ax niquinnextilis niyon se tlanescayotl. ");
INSERT INTO nheNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huan Jesús quincajtejqui nopa tlacame, huan sampa calajqui ipan cuacanahua huan yajqui hasta nopa seyoc nali hueyi atl. ");
INSERT INTO nheNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Huan imomachtijcahua Jesús quiilcajtejtoyaj tlen quicuase, huan san quihuicayayaj setzi pantzi ipan cuacanahua. ");
INSERT INTO nheNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Huan Jesús quinilhui: ―Xijpiyaca cuidado para amo xijselica inintlasonejcayo Tlanahuatijquetl Herodes huan nopa fariseos. ");
INSERT INTO nheNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Huan imomachtijcahua pejque moilhuíaj se ica seyoc: “Techilhuía ya ni pampa ax tijhualicaque pantzi.” ");
INSERT INTO nheNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Huan Jesús quimatqui tlachque quiijtohuayayaj huan quinilhui: ―¿Para tlen inquiijtohuaj nimocuesohua pampa ax inquihualicaj pantzi? ¿Aya inquimachilíaj nochicahualis? ¿Noja tetic imoyolo? ");
INSERT INTO nheNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Ax inquiitaj ica imoixtiyol? ¿Ax inquicaquij ica imonacas? ¿Ax inquiilnamiquij tlachque nijchijqui quema techpolohuayaya pantzi? ");
INSERT INTO nheNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Quema niquintlamacac macuili mil tlacame ica macuili pantzi, ¿quesqui chiquihuitl panpayaxtli huan michpayaxtli inquisentilijque tlen mocajtoya? Huan quinanquilijque: ―Majtlactli huan ome. ");
INSERT INTO nheNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Huan Jesús quiijto: ―Huan quema niquintlamacac nahui mil tlacame ica chicome pantzi, ¿quesqui chiquihuitl panpayaxtli huan michpayaxtli inquisentilijque tlen mocajtoya? Huan quiilhuijque: ―Chicome. ");
INSERT INTO nheNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Huajca quinilhui: ―¿Aya inquimachilíaj tlen nihueli nijchihua? ");
INSERT INTO nheNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Teipa Jesús huan imomachtijcahua ajsitoj altepetl Betsaida. Huan quihualicaque campa Jesús se tlacatl popoyotzi. Huan quitlajtlaniyayaj ma quitlalili ima para ma quichicahua. ");
INSERT INTO nheNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Huan Jesús quiitzqui ima nopa popoyotzi huan quihuicac altepeteno. Huan quialaxo iixtiyol ica ichajcha huan quitlali ima ipan nopa popoyotzi huan quitlajtlani intla hueli tlachiya quentzi. ");
INSERT INTO nheNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Huan nopa popoyotzi tlachixqui huan quiijto: ―Niquinita tlacame tlen nesij queja cuatini, pero nejnemij. ");
INSERT INTO nheNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Huan Jesús sampa quitlali ima ipan iixtiyol huan quichijqui ma tlachiya. Huan nopa tlacatl mochicajqui huan tlachixtejqui. Cuali quiitayaya nochi. ");
INSERT INTO nheNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Huajca Jesús quinahuati ma yohui ichaj huan quiilhui: ―Amo xicalaqui ama ipan ni altepetl niyon axaca xiquilhui nepa. ");
INSERT INTO nheNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Teipa Jesús yajqui ininhuaya imomachtijcahua ipan pilaltepetzitzi nechca altepetl Cesarea tlen Filipo. Huan ipan ojtli quintlajtlani imomachtijcahua: ―¿Ajqueya quiijtohuaj tlacame para na? ");
INSERT INTO nheNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Huan quinanquilijque: ―Sequin quiijtohuaj ta tiJuan tlen tecuaaltiyaya. Sequinoc quiijtohuaj titiocamanalojquetl Elías. Sequinoc quiijtohuaj ta seyoc titiocamanalojquetl tlen huejcajquiya mijqui. ");
INSERT INTO nheNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Huajca Jesús quintlajtlani: ―Huan imojuanti, ¿ajqueya inquiijtohuaj para na? Huan Pedro quinanquili: ―Ta tiCristo tlen Toteco Dios techilhui techtitlanilisquía. ");
INSERT INTO nheNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Huan Jesús quinnahuati para axaca ma quiilhuica. ");
INSERT INTO nheNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Huajca Jesús pejqui quinmachtía imomachtijcahua quejatza tlaijiyohuis. Quiijto: ―Na tlen niMocuepqui Tlacatl monequi nitlaijiyohuis miyac. Ax nechselise nopa huehue israelitame, huan nopa tlayacanca totajtzitzi, huan nopa tlamachtiani tlen itlanahuatil Moisés. Nechmictise, pero ica eyi tonali nimoyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Quej nopa Jesús quinilhui xitlahuac tlen ipantisquía. Huajca Pedro quiiyocaquixti huan pejqui quitlacahualtía. ");
INSERT INTO nheNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero Jesús moicancuepqui huan quintlachili imomachtijcahua. Huan quiajhuac Pedro huan quiilhui: ―Xinechtlalcahui, Axcualtlacatl. Ta ax tijtemohua tlen Toteco quinequi ma pano, tijnequi ma pano san tlen tlacame quinequij. ");
INSERT INTO nheNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Huan Jesús quinnotzqui imomachtijcahua ininhuaya nopa miyac tlacame huan quinilhui: ―Intla se quinequi nechtoquilis, monequi quitlahuelcahuas tlen yaja quinequi. Ma quitlalana icuamapel huan nechtoquilis mocualtlalijtoc para miquis nopampa na. ");
INSERT INTO nheNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pampa ajqueya quinequi momanahuis para itztos, quema miquis, quipolos nochi. Pero ajqueya nechtoquilis yonque monequi miquis pampa nechneltoca na huan itlajtol Toteco, yajaya quimaquixtis iyoltzi huan itztos para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pampa ax tleno huelis quipalehuis se tlacatl tlen quipolos iyoltzi huan yas mictla. Ax quipalehuis yonque quipiyas nochi tlen onca ipan ni tlaltepactli para iaxca. ");
INSERT INTO nheNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Pampa ax onca tleno tlen ica se tlacatl huelis tlaxtlahuas para quimanahuis iyoltzi. ");
INSERT INTO nheNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Huan intla se tlacatl mopinahuas para quiijtos nechixmati na huan notlajtol, pampa itztoc ininhuaya ni tlajtlacolchijca tlacame tlen ama itztoque, huajca na tlen niMocuepqui Tlacatl nojquiya niquijtos ax niquixmati ipan nopa tonal quema nihualas ica itlatlanex noTata, huan nohuaya hualase nopa tlatzejtzeloltijca elhuicac ehuani. ");
INSERT INTO nheNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nojquiya Jesús quinilhui: ―Nelía nimechilhuía, sequin imojuanti tlen initztoque nica ax inmiquise hasta inquinitase hualase ica chicahualistli tlen itztoque nepa campa tlanahuatía Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Quema panotoya chicuase tonali, Jesús quinhuicac Juan, Pedro huan Jacobo huan tlejcoc ipan se huejcapantic tepetl. Nepa quipatlac itlachiyalis iniixtla. ");
INSERT INTO nheNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Huan iyoyo mocuepqui cahuantic huan nelchipahuac. Axaca se tlachicuenijquetl ipan tlaltepactli tlen hueli quichipahualtía yoyomitl queja nopa. ");
INSERT INTO nheNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Huan nopano iniixtla monextijque Elías huan Moisés huan quicamahuiyayaj Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Huajca Pedro quiilhui Jesús: ―Tlamachtijquetl, cuali para tiitztose nica. Ma tijchihuaca eyi pilxajcaltzitzi: se para ta, se para Moisés, huan seyoc para Elías. ");
INSERT INTO nheNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Imomachtijcahua momajmatiyayaj huan Pedro quiijto ya ni pampa ax quimatqui tlachque quiijtos. ");
INSERT INTO nheNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Teipa temoc se mixtli ininpani huan quintzajqui. Huan ipan nopa mixtli quicajque itos Toteco Dios huan yajaya quiijto: “Ya ni Nocone tlen niquicnelía, xijtlacaquilica tlen quiijtohua.” ");
INSERT INTO nheNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huan ipan nopa tlalochtli imomachtijcahua quitlachilijque huan ayoc aca quiitaque, san Jesús iselti. ");
INSERT INTO nheNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Huan quema ixtemoyayaj ipan nopa tepetl, Jesús quinnahuati ma axaca quipohuilica tlen quiitztoyaj hasta yajaya tlen Mocuepqui Tlacatl miquisquía huan moyolcuisquía. ");
INSERT INTO nheNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Huajca axaca quiilhuijque, pero motlajtlaniyayaj tlachque quiijtosnequi para moyolcuis tlen campa mijcatzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Huan imomachtijcahua quitlajtlanijque Jesús: ―¿Para tlen quiijtohuaj nopa tlamachtiani tlen itlanahuatil Moisés para achtohui monequi hualas nopa tiocamanalojquetl Elías huan teipa hualas nopa Cristo? ");
INSERT INTO nheNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Huan Jesús quinnanquili huan quinilhui: ―Melahuac ijcuilijtoc ipan Itlajtol Toteco para Elías monequi hualas achtohui huan quicualtlalis nochi tlamantli. Pero yonque ya nopa quichihua, xijmachilica para nojquiya ijcuilijtoc ipan Itlajtol Toteco para na tlen niMocuepqui Tlacatl nitlaijiyohuis miyac huan nechhuejcamajcahuase tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Huan nimechilhuía ya hualajqui nopa tlacatl tlen eliyaya queja Elías huan tlacame quichihuilijque nochi tlen ax cuali tlen yajuanti quinejque. Quichijque senquistoc queja ijcuilijtoc ipan Itlajtol Toteco para quichihuilisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Teipa Jesús, Juan, Pedro huan Jacobo mocuepque campa itztoyaj nopa sequinoc imomachtijcahua. Huan quinitaque tlahuel miyac tlacame ininhuaya. Nojquiya nepa itztoyaj tlamachtiani tlen itlanahuatil Moisés tlen mocamaijixnamiquiyayaj ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Huan nimantzi nopa tlacame quitlachilijque Jesús, huan san quisentlachilijque huan motlalojtejque para quitlajpalotij. ");
INSERT INTO nheNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Huajca Jesús quintlajtlani: ―¿Tlachque tlamantli inmonajnanquilíaj ihuaya nomomachtijcahua? ");
INSERT INTO nheNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Huan se tlacatl tlen itztoya nepa quinanquili: ―Tlamachtijquetl, nica nijhualica nooquichpil. Quipiya se iajaca Axcualtlacatl tlen quinonotilijtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Huan campa hueli quema nopa ajacatl quiitzquía, quimajcahua tlalchi huan camaposoni. Huan motlancochhuehuechotza huan huapahuía. Niquintlajtlani momomachtijcahua ma quiquixtilica nopa ajacatl, pero ax huelque. ");
INSERT INTO nheNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Huan Jesús quinnanquili: ―¡Nelnelía intlacame tlen ama initztoque! ¡Ax innechneltocaj! ¿Quesqui tonali monequi niitztos imohuaya? ¿Quesqui tonali monequi nimechijiyohuis huan ax innechneltocaj? ¡Xinechhualiquilica nopa oquichpil! ");
INSERT INTO nheNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Huan quihualicaque. Huan quema nopa ajacatl quiitac Jesús, nimantzi quimaquili se ajaca cocolistli nopa oquichpil. Huan huetzqui tlalchi, huan pejqui momimilohua huan camaposoni. ");
INSERT INTO nheNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Huajca Jesús quitlatzintoquili itata: ―¿Quemaya pejqui quipiya ni cocolistli? Huan itata quiijto: ―Pejqui quema conetzi eltoya. ");
INSERT INTO nheNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huan miyac huelta nopa ajacatl quimajcajtoc tlixijco huan atitla para quimictis. Huajca intla tihueli, xitechtlasojtla huan xitechpalehui. ");
INSERT INTO nheNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Huan Jesús quiilhui: ―¿Para tlen tinechtlajtlanía intla hueli nimitzpalehuis? Nochi hueli mochihua para se tlen nechneltoca. ");
INSERT INTO nheNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Huan nimantzi itata nopa oquichpil camatqui chicahuac huan quiilhui: ―¡Nijneltoca! ¡xinechpalehui para más ma nijneltocas! ");
INSERT INTO nheNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Huan Jesús quiitac para mosentiliyayaj miyac tlacame, huajca quiajhuac iajaca Axcualtlacatl, huan quiilhui: ―Tiajacatl tlen tiquinchihua tlacame ma nacastapalihuica huan ma nonotiyaca, nimitznahuatía xiquisa ipan ni oquichpil huan ayoc xicalaqui ipan ya. ");
INSERT INTO nheNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Huan nopa ajacatl tzajtzic, huan quimacac nopa oquichpil seyoc ajaca cocolistli tlen chicahuac, huan quisqui. Huan nopa oquichpil mocajqui queja mictoc. Huan miyac quiijtohuayayaj para ya mictoc. ");
INSERT INTO nheNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús quimaitzqui huan quitlalanqui huan nopa oquichpil moquetzqui. ");
INSERT INTO nheNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Teipa Jesús calaquito ipan se cali huan ixtacatzi imomachtijcahua quitlajtlanijque: ―¿Para tlen ax tihuelque tijquixtilijque nopa ajacatl? ");
INSERT INTO nheNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Huan ya quinilhui: ―Ni tlamantli ajacatl ax quisaj intla ax timomaijtose huan timosahuase. ");
INSERT INTO nheNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jesús huan imomachtijcahua quisque nepa huan panotiyajque ipan estado Galilea. Huan Jesús ax quinequiyaya tlacame ma quimatica campa itztoya, ");
INSERT INTO nheNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","pampa quinmachtiyaya imomachtijcahua. Quinilhuiyaya: ―Nechtemactilise na tlen niMocuepqui Tlacatl ininmaco tlacame. Yajuanti nechmictise, pero quema nimiquis, ica eyi tonali nimoyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero imomachtijcahua ax quimachiliyayaj itlajtol huan momajmatiyayaj quitlajtlanise tlachque quiijtosnequi. ");
INSERT INTO nheNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Teipa Jesús huan imomachtijcahua ajsitoj altepetl Capernaum. Huan quema itztoyaj calijtic, Jesús quintlatzintoquili: ―¿Tlachque inmonajnanquiliyayaj ipan ojtli? ");
INSERT INTO nheNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ax tleno quiijtojque pampa ipan ojtli monajnanquiliyayaj ajqueya tlen yajuanti quipixqui achi más tequihuejcayotl. ");
INSERT INTO nheNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Huajca Jesús mosehui huan quinnotzqui nopa majtlactli huan ome imomachtijcahua, huan quinilhui: ―Intla se tlacatl quinequi elis tlen más quipiya tequihuejcayotl iixpa Toteco Dios, ma mochihua queja ax quipiya tequihuejcayotl huan ma quintequipano nochi sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Huan Jesús quiitzqui se conetl huan quitlali tlatlajco campa yajuanti. Huan quicuanajnahuajqui huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Intla se tlacatl quiselis se conetl queja ya ni pampa nechneltoca , huajca yajaya nechselía. Huan ajqueya nechselía, ax san na nechselía, pero nojquiya quiselía noTata tlen nechtitlanqui ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Huan Juan quiilhui Jesús: ―Tlamachtijquetl, tiquitaque se tlacatl tlen quinquixtiyaya iajacahua Axcualtlacatl ica ichicahualis motoca. Tiquilhuijque ma ayoc quichihua pampa ax tohuaya nemi huan ax techtoquilía. ");
INSERT INTO nheNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero Jesús quinilhui: ―Amo xijtzacuilica, pampa axaca hueli quiijtos notoca huan quichihua se chicahualis nescayotl huan teipa camatis fiero tlen na. ");
INSERT INTO nheNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pampa intla se tlacatl ax techcocolía, huajca yajaya itztoc tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ajqueya inmechmacas se quentzi atl pampa quimati innechtoquilíaj na niCristo, nimechilhuía para temachtli noTata quitlaxtlahuis cuali. ");
INSERT INTO nheNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Intla acajya quinextilis ma tlajtlacolchihua se tlen ni coneme tlen nechneltocaj, Toteco nelía quitlatzacuiltis. Más cuali intla achtohui quiquechilpilisquíaj nopa tlacatl se hueyi metlatl huan quimajcahuasquíaj ipan hueyi atl para ma misahuis para ma ax quichihua nopa hueyi tlajtlacoli. ");
INSERT INTO nheNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Intla tijnequi titlajtlacolchihuas ica se moma, más cuali xijtzontequi. Pampa achi cuali ticalaquis elhuicac ica san setzi moma, huan ax tiyas ica ome moma campa nopa tlitl tlen ax quema sehuis. ");
INSERT INTO nheNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nepa nopa ocuilime ax miquij huan ax quema sehuis nopa tlitl. ");
INSERT INTO nheNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Huan intla moicxi mitzhuicas para titlajtlacolchihuas, más cuali xijtzontequi. Pampa achi cuali ticalaquis elhuicac timetzcototic, huan ax mitzmajcahuase ica ome mometz ipan mictla campa nopa tlitl tlen axaca hueli quisehuis. ");
INSERT INTO nheNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nepa ocuilime ax miquij huan ax quema sehuis nopa tlitl. ");
INSERT INTO nheNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Huan intla moixtiyol quinequi mitztlajtlacolchihualtis, achi cuali xijquixti. Pampa más cuali ticalaquis campa tlanahuatía Toteco ica san setzi moixtiyol huan ax mitzmajcahuase mictla ica ome moixtiyol. ");
INSERT INTO nheNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nepa ax miquise nopa ocuilime huan ax quema sehuis nopa tlitl. ");
INSERT INTO nheNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Queja quicualtlalíaj se tlacajcahualistli para Toteco ica istatl huan ica tlitl, nojquiya monequi nochi tlacame quipanose tlaohuijcayotl pampa Toteco quincualtlalía para ma quitequipanoca. ");
INSERT INTO nheNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Istatl nelía cuali, pero intla quipolohua ipoyeca, axaca huelis quipoyeltis sampa. Xiitztoca queja se tlacualistli tlen cuali poyec pampa initztoque ica cuali se ica seyoc.” ");
INSERT INTO nheNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Teipa Jesús quisqui nepa huan yajqui estado Judea. Teipa yajqui seyoc nali atemitl Jordán, huan miyac tlacame sampa mosentilijque campa itztoya. Huan Jesús sampa pejqui quinmachtía queja momajtoya. ");
INSERT INTO nheNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Huan hualajque sequin fariseos para quimasiltise Jesús ica tlajtoli. Huan quitlajtlanijque intla cuali para se tlacatl quicahuas isihua. ");
INSERT INTO nheNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Huajca Jesús quinilhui: ―¿Tlachque inmechnahuati Moisés? ");
INSERT INTO nheNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Quiilhuijque: ―Moisés quicahuili se tlacatl ma quimaca isihua se amatlajcuiloli tlen quiijto para nopa sihuatl ayoc iaxca. Quej nopa se tlacatl huelqui quicahua isihua. ");
INSERT INTO nheNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Pero Jesús quinilhui: ―Moisés quinmacac nopa tlanahuatili pampa ipan nopa tonali tlacame nelía eliyayaj yoltetique, ");
INSERT INTO nheNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","pero achtohuiya quema Toteco quichijqui tlaltepactli, ya quichijqui ‘tlacatl huan sihuatl para ma mocahuaca san sejco.’ ");
INSERT INTO nheNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yeca se tlacatl quicahuas itata huan inana huan mosejcotilis ihuaya isihua. ");
INSERT INTO nheNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Huan nopa ome mochihuase san se inintlacayo. Yeca ayoc itztoque ome, mochihuase san se inintlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Huajca tlen Toteco Dios quinsejcotilijtoc, ma amo aca quiiyocatlalis. ");
INSERT INTO nheNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Huan calijtic imomachtijcahua sampa quitlajtlanijque Jesús tlen quiijtojtoya tlen tlacame huan sihuame tlen mocahuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Huan Jesús quinilhui: ―Intla se tlacatl quicahua isihua huan mosejcotilis ica seyoc, huajca nopa tlacatl momecatía pampa quiixpano isihua tlen achtohui. ");
INSERT INTO nheNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Huan intla se sihuatl quicahuas ihuehue huan mosejcotilis ica seyoc tlacatl, yajaya nojquiya momecatía. ");
INSERT INTO nheNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Teipa quinhualicaque coneme campa Jesús para ma quintlalili ima para ma quintiochihua, pero imomachtijcahua quinajhuayayaj tlen quinhualicayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Huan Jesús quiitac tlen panoyaya, huan cualanqui huan quinilhui imomachtijcahua: ―Xiquincahuaca ni coneme ma hualaca campa na. Amo xiquintzacuilica pampa Toteco quinselía tlacame ipan itlanahuatilis tlen nechselíaj queja ni coneme nechselíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nelía nimechilhuía, intla se tlacatl ax nechselía huan nechcahuilía ma nijnahuati ipan iyolo queja se conetl quichihua, ax quema huelis calaquis campa tlanahuatía Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huan Jesús quincuanajnahuajqui nopa coneme, huan quitlali ima ininpani huan quintiochijqui. ");
INSERT INTO nheNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Quema Jesús quistehuayaya para yas ipan iojhui, ajsico se tlacatl tlen motlalojtihualajqui huan motlancuaquetzqui iixtla. Huan nopa tlacatl quitlajtlani: ―Ticuali tlamachtijquetl, ¿tlachque monequi nijchihuas para Toteco nechmacas yolistli yancuic para nochipa? ");
INSERT INTO nheNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Huan Jesús quiilhui: ―¿Para tlen tinechnotzqui nicuali? ¿Ta tijmachilía para axaca cuali, san Dios? ");
INSERT INTO nheNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ta tijmati itlanahuatil Toteco: ‘Amo xitemicti; amo ximomecati; amo xitlaxtequi; amo xiteistlacahui quema tiitztoc se testigo; amo xitlacajcayahua; xijtlepanita motata huan monana.’ ");
INSERT INTO nheNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Huan nopa tlacatl quiilhui: ―Tlamachtijquetl, nochi ni tlanahuatili nijneltoquilijtihualajtoc hasta quema nieltoya nioquichpil. ");
INSERT INTO nheNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Huan Jesús quitlachili nopa tlacatl, quiicneli huan quiilhui: ―Se tlamantli mitzpolohua. Xiya, xijnamacati nochi tlen tijpiya huan xiquinmajmaca tlen teicneltzitzi. Huan Toteco mitztlaxtlahuis nepa elhuicac. Teipa xihuala, xinechtoquili queja se tlacatl tlen quihuica icuamapel mocualtlalijtoc para ipan ma quimictica. ");
INSERT INTO nheNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero quema nopa tlacatl quicajqui itlajtol, quiyolcoco huan mocuesojtiyajqui pampa nelía quipixtoya miyac tlamantli tlen pajpatiyo. ");
INSERT INTO nheNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Huajca Jesús moicancuepqui huan quintlachili imomachtijcahua huan quinilhui: ―¡Nelía ohui para tlacame tlen tominpiyaj calaquise campa tlanahuatía Toteco! ");
INSERT INTO nheNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Huan imomachtijcahua quisentlachilijque ica nopa tlajtoli. Huan Jesús sampa quinilhui: ―Nohuampoyohua, nelía ohui para calaquise campa tlanahuatía Toteco tlacame tlen motemachíaj ipan ininricojyo. ");
INSERT INTO nheNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ohui para se hueyi tlapiyali queja se camello ma pano ipan iixtiyol se huitzmalotl, pero noja más ohui para se tlacatl tlen quipiya miyac tomi calaquis campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Huan imomachtijcahua achi más quisentlachilijque huan quitlajtlanijque: ―Huajca ¿ajqueya huelis momaquixtis tlen itlajtlacolhua? ");
INSERT INTO nheNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Huan Jesús quintlachili huan quinilhui: ―Tlacame ax hueli momaquixtise, pero Toteco, quena, huelis quinmaquixtis pampa Toteco nochi hueli quichihua. ");
INSERT INTO nheNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Huan Pedro quiilhui: ―Xiquita, tojuanti tijcajtejtoque nochi tlen tijpixtoyaj para timitztoquilise. ");
INSERT INTO nheNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Huan Jesús quinilhui: ―Nelía nimechilhuía, intla se tlacatl quicajtejtoc ichaj, o itlaca icnihua, o isihua icnihua, o itata, o inana, o isihua, o iconehua, o imilhua, pampa nechneltoca na huan itlajtol Toteco, Toteco quitlaxtlahuis. ");
INSERT INTO nheNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Quena, Toteco quimacas ama ipan ni tlaltepactli cien huelta imiyaca más ichaj, itlaca icnihua, isihua icnihua, inanahua, iconehua huan imilhua, yonque tlaijiyohuis nopampa na. Huan ipan nopa tlaltepactli tlen huala, nopa tlacatl itztos para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero miyac tlen ama quipiyaj tequihuejcayotl, ax tleno quipiyase teipa; huan miyac tlen ama itztoque hasta tlateipa, quipiyase miyac tequihuejcayotl nepa. ");
INSERT INTO nheNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús huan imomachtijcahua nejnemiyayaj ipan ojtli ixtlejcoyayaj para altepetl Jerusalén huan Jesús quinyacanayaya. Huan imomachtijcahua quisentlachiliyayaj ica tlen quinilhuiyaya. Huan nopa tlacame tlen quintoquiliyayaj momajmatiyayaj. Huan sampa Jesús quinnotzqui iyoca nopa majtlactli huan ome imomachtijcahua huan pejqui quinilhuía tlachque ipantisquía. ");
INSERT INTO nheNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Quinilhui: “Xiquitaca, ama titlejcotiyohuij para altepetl Jerusalén. Nepa nechtemactilise ininmaco nopa tlayacanca totajtzitzi huan nopa tlamachtiani tlen itlanahuatil Moisés. Huan yajuanti quiijtose para monequi para na tlen niMocuepqui Tlacatl ma nimiqui, huan teipa nechtemactilise ica tlacame tlen ax israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Huan yajuanti nechhuihuiitase huan nechixchajchase. Teipa nechhuitequise huan nechmictise. Pero ica eyi tonali, nimoyolcuis.” ");
INSERT INTO nheNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Huajca Jacobo ihuaya Juan, nopa ome iconehua Zebedeo, monechcahuijque campa Jesús huan quiilhuijque: ―Tlamachtijquetl, tijnequij titechchihuilis se favor. ");
INSERT INTO nheNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Huajca quinilhui: ―¿Tlachque inquinequij ma nimechchihuili? ");
INSERT INTO nheNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Huan quiilhuijque: ―Xitechcahuilis para quema titlanahuatis nepa campa tlahuel tlayejyejca, ma timosehuise se ipan monejmatl huan seyoc ipan moarraves. ");
INSERT INTO nheNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Huajca Jesús quinilhui: ―Ax inquimatij tlachque innechtlajtlaníaj. ¿Huelis intlaijiyohuise queja na? ¿Huelis inquipanose miyac cuesoli queja na nijpanos? ");
INSERT INTO nheNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Huan yajuanti quiilhuijque: ―Quena, tihuelise. Huan Jesús quinilhui: ―Nelía intlaijiyohuise queja na. Huan nelía inquipanose miyac cuesoli queja na nijpanos. ");
INSERT INTO nheNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ax notequi para niquijtos ajqueya mosehuise campa nonejmatl huan campa noarraves. San mosehuise nepa tlen Toteco quintlapejpenijtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Huan quema nopa sequinoc majtlacme imomachtijcahua quicajque tlen quitlajtlanijtoyaj, pejque cualanij ica Jacobo huan Juan. ");
INSERT INTO nheNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Huan Jesús quinnotzqui huan quinilhui: ―Inquimatij para tlacame tlen tlayacanaj ipan nochi tlaltini tlanahuatíaj chicahuac, huan huejhueyi tlacame quipiyaj nochi tequihuejcayotl para quinchihuilíaj inintlacajhua tlen quinequij. ");
INSERT INTO nheNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero ax quej nopa elis ica imojuanti. Pampa ica imojuanti, ajqueya quinequi mochihuas hueyi, monequi inmechtequipanos. ");
INSERT INTO nheNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Huan ajqueya quinequi inmechyacanas, monequi ma mochihua queja imotequipanojca tlen inquicojtoque para imoaxca. ");
INSERT INTO nheNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Pampa niyon na tlen niMocuepqui Tlacatl, ax nihualajtoc para sequinoc ma nechtequipanoca. Nihualajtoc para niquintequipanos sequinoc, huan para nitemactilis noyolis queja se tlaxtlahuili para niquintojtomas miyac tlacame tlen inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesús huan imomachtijcahua ajsitoj altepetl Jericó. Huan teipa quema quisayayaj, quintoquiliyayaj miyac tlacame. Huan mosehuijtoya ojteno se popoyotzi tlen itoca eliyayaj Bartimeo tlen elqui icone Timeo huan yajaya motlaejehuiliyaya para se quentzi para ica panos. ");
INSERT INTO nheNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Huan quema Bartimeo quicajqui para monechcahuiyaya Jesús tlen Nazaret, pejqui tlahuelchihua huan quiijto: ―¡Jesús, ta tiiteipa ixhui David, xinechtlasojtla! ");
INSERT INTO nheNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Huan miyac tlacame quiajhuaque nopa popoyotzi ma ayoc tlahuelchihua, pero yajaya achi más tlahuelchijqui: ―¡Jesús, tiiteipa ixhui David, xinechtlasojtla! ");
INSERT INTO nheNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Huajca quema Jesús quicajqui, moquetzqui huan quiijto: ―Xiquilhui ma huala nopa tlacatl. Huajca quinotzque nopa popoyotzi huan quiilhuijque: ―Ximotemachi huan ximoquetza pampa Jesús mitznotza. ");
INSERT INTO nheNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Huajca Bartimeo quicuamajcajqui ipantzajca, huan moquetztiquisqui huan quinechcahuico Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Huan Jesús quiilhui: ―¿Tlachque tijnequi ma nimitzchihuili? Huan nopa popoyotzi quinanquili: ―Tlamachtijquetl, nijnequi nitlachiyas sampa. ");
INSERT INTO nheNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Huan Jesús quiilhui: ―Xiya mochaj. Ya timochicajqui pampa tinechneltocac. Huan ipan nopa tlalochtli nopa tlacatl tlachixtejqui cuali huan quitoquili Jesús ipan ojtli. ");
INSERT INTO nheNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Teipa Jesús ininhuaya imomachtijcahua ajsitoj nechca Jerusalén campa nopa altepetini Betfagé huan Betania, tlen mocahua iixmelac nopa tepetl tlen itoca Olivos. Huan nepa Jesús quintitlanqui ome imomachtijcahua, ");
INSERT INTO nheNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","huan quinilhui: ―Xiyaca nopa pilaltepetzi tlen mocahua imoixmelac huan quema inajsitij nepa, inquipantise se pilburrojtzi ilpitoc tlen axaca ipan tlejcotoc. Xijtojtomaca huan xinechhualiquilica. ");
INSERT INTO nheNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Huan intla acajya inmechtlajtlanis para tlen inquichihuaj ya nopa, xiquilhuica: ‘Tohueyiteco quinequi quitequihuis huan nimantzi quicuepas.’ ");
INSERT INTO nheNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Huajca imomachtijcahua yajque huan quipantitoj nopa pilburrojtzi ilpitoc puertajteno imelac ojtli huan quitojtonque. ");
INSERT INTO nheNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Huan nopa tlacame tlen itztoyaj nepa quintlajtlanijque: ―¿Tlachque inquichihuaj? ¿Para tlen inquimalacaníaj nopa pilburrojtzi? ");
INSERT INTO nheNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Huajca imomachtijcahua quinnanquilijque queja Jesús quinilhuijtoya. Huan nopa tlacame quincahuilijque ma quihuicaca. ");
INSERT INTO nheNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Huajca quihuicaque nopa pilburrojtzi campa Jesús huan quitlalilijque ininyoyo icuitlapa huan Jesús tlejcoc ipani. ");
INSERT INTO nheNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Huan miyac tlacame quisosojque ininyoyo ipan ojtli, huan sequinoc quitzontejque imacuayo apach cuatini huan quitlalijque ipan ojtli. ");
INSERT INTO nheNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Huan tlacame tlen tlayacanayayaj huan tlen nojquiya tlen hualayayaj tlaica pejque tlahuelchihuaj tlen Jesús, huan quiijtohuayayaj: ―¡Ma tijhueyichihuaca Toteco! Ma Toteco Dios mitztiochihua ta tlen tihuala ica itequihuejcayo. ");
INSERT INTO nheNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Hueyi tlatiochihualistli tijpiyase quema titlanahuatis ipan totlal queja tohuejcapan tata David tlanahuati huejcajquiya! ¡Ma tijhueyichihuaca Toteco Dios tlen itztoc elhuicac! ");
INSERT INTO nheNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Huan Jesús calajqui ipan altepetl Jerusalén huan yajqui ipan nopa hueyi israelita tiopamitl. Huan nepa quitlachili nochi tlamantli tlen oncayaya calijtic. Teipa mocuepqui altepetl Betania ininhuaya nopa majtlactli huan ome imomachtijcahua pampa tlayohuatinemiyaya. ");
INSERT INTO nheNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huan hualmostla quema Jesús huan imomachtijcahua quisque Betania, mayanque. ");
INSERT INTO nheNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Huan Jesús quihuejcaitac se higuera cuahuitl tlen quipixqui ixihuiyo. Huan yajqui quitlachilito intla quipiyayaya itlajca. Pero quema ajsito, ax tleno quipantili, san quipixqui ixihuiyo pampa aya eliyaya ipohual para tlaquis. ");
INSERT INTO nheNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Huajca Jesús quiilhui nopa cuahuitl: ―Ma axaca sampa quicuas motlajca. Huan imomachtijcahua quicajque tlen quiijto. ");
INSERT INTO nheNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Teipa ajsitoj Jerusalén huan Jesús calajqui ipan nopa hueyi israelita tiopamitl. Huan nepa pejqui quintotoca nopa tlacame tlen tlanamacayayaj o tlacohuayayaj tiopan calijtic. Quincuamajcahuili ininmesas tlen tominpatlayayaj huan ininsiyas yajuanti tlen quinamacayayaj palomas. ");
INSERT INTO nheNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Huan Jesús quintzacuili tlacame tlen panoyayaj tlatlajco nopa hueyi tiopan calijtic ica inintlamamal huan ayoc quincahuili ma panoca. ");
INSERT INTO nheNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huan Jesús pejqui quinmachtía tlacame huan quinilhui: ―Ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Nochaj eltoc nopa cali campa tlacame tlen ehuaj nochi tlaltini huelis momaijtose’, pero inquichijtoque campa mosejcotilíaj tlaxtequini para tlaxtequise. ");
INSERT INTO nheNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Huan nopa tlayacanca totajtzitzi huan nopa tlamachtiani tlen itlanahuatil Moisés quicajque tlen quichijqui Jesús huan pejque quitemohuilíaj quejatza quimictisquíaj. Quiimacasiyayaj pampa nochi tlacame san quisentlachiliyayaj tlen Jesús quinmachtiyaya. ");
INSERT INTO nheNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Pero quema tlayohuac, Jesús ininhuaya imomachtijcahua quisque tlen nopa altepetl. ");
INSERT INTO nheNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hualmostla ica ijnaloc Jesús huan imomachtijcahua panoque campa nopa higuera cuahuitl huan quiitaque cuali huactoya hasta ipan inelhuayo. ");
INSERT INTO nheNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Huajca Pedro quiilnamijqui huan quiilhui Jesús: ―Tlamachtijquetl, xiquita ne higuera cuahuitl tlen tijtelchijqui para ma ayoc quema temacas itlajca, cuali huactoc. ");
INSERT INTO nheNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Huan Jesús quinnanquili: ―Ximotemachica ipan Toteco, ");
INSERT INTO nheNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","huan melahuac aqui hueli tlacatl tlen quiilhuis ni tepetl: ‘Ximijcueni huan ximomajcahua ipan hueyi atl’, intla quineltocas para panos tlen quiijtojtoc, Toteco quichihuilis. ");
INSERT INTO nheNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yeca nimechilhuía, nochi tlen inquitlajtlanise Toteco quema inmomaijtohuaj, xijneltocaca para inquiselise huan Toteco inmechmacas. ");
INSERT INTO nheNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Huan quema inmomaijtohuaj ica Toteco, xijtlapojpolhuica aqui hueli tlen ica incualanij para queja nopa imoTata tlen itztoc elhuicac nojquiya inmechtlapojpolhuis imotlaixpanolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Pampa intla ax inquintlapojpolhuíaj sequinoc, huajca Toteco imoTata tlen itztoc elhuicac nojquiya ax inmechtlapojpolhuis imotlaixpanolhua. ");
INSERT INTO nheNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Huan yajuanti sampa ajsicoj ipan altepetl Jerusalén. Huan teipa quema Jesús nejnemiyaya tiopan calijtic, quinechcahuijque nopa tlayacanca totajtzitzi, huan nopa tlamachtiani tlen itlanahuatil Moisés huan nopa huehue tlacame tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Huan quitlajtlanijque: ―¿Tlachque tequihuejcayotl tijpiya para tijchihua nochi ni tlamantli? ¿Ajqueya mitzmacatoc tlanahuatili? ");
INSERT INTO nheNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Huan Jesús quinnanquili: ―Na nojquiya nimechtlajtlanis se tlamantli. Intla xitlahuac innechnanquilise, huajca nimechilhuis ajqueya nechmacatoc tequihuejcayotl para nijchihua ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ajqueya quititlanqui Juan para tecuaaltis? ¿Toteco quititlanqui o san tlacame? Xinechnanquilica. ");
INSERT INTO nheNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Huajca pejque moijilhuíaj huan moijilhuijque: “Intla tiquijtose Toteco quititlanqui Juan, yajaya technanquilis: ‘Huajca, ¿para tlen ax inquineltocaque?’ ");
INSERT INTO nheNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Huan intla tiquijtose san tlacame quititlanque Juan, huajca mahuilili, pampa nochi ni tlacame toca cualanise, pampa nochi quineltocaj para Juan eliyaya se tiocamanalojquetl.” ");
INSERT INTO nheNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Huajca quiilhuijque Jesús: ―Tojuanti ax tijmatij ajqueya quititlanqui Juan. Huan Jesús quinilhui: ―Huajca na nojquiya ax nimechilhuis ajqueya nechmacatoc tequihuejcayotl para nijchihua ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Huajca Jesús pejqui quincamahuía ica se ome huicalotl. Quinilhui: “Itztoya se tecojtli tlen quitojqui xocomecatl ipan imil. Huan quitzajtzajqui ica se tepamitl huan tlacoyoni huan quitepejpechti para ipan quipatzcas xocomecatl. Nojquiya quichijqui se huejcapantic tecali para ipan quimocuitlahuis ixocomeca mil. Huan quintlanejti ixocomeca mil sequinoc tlacame ma quimocuitlahuica huan teipa moajachihuisquíaj tlen temacasquía. Huan huajca nopa tecojtli quincahuilijtejqui ininmaco huan huejca yajqui paxaloto. ");
INSERT INTO nheNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Huan teipa ajsic tonali para tlatequistli, huan nopa tecojtli quititlanqui se itequipanojca ma quinitati nopa tlacame para ma quimacaca tlen eli iaxca tlen nopa tlatequistli. ");
INSERT INTO nheNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero nopa tlacame tlen ininmaco eltoya nopa mili quiitzquijque, huan quimaquilijque huan quimajcajque san imacajya. ");
INSERT INTO nheNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Huajca nopa tecojtli sampa quititlanqui seyoc itequipanojca, pero nopa tlacame quitepachojque, huan quicuacocojque, huan tlen fiero quichihuilijque huan quititlanque ma yohui. ");
INSERT INTO nheNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Teipa nopa tecojtli sampa quititlanqui seyoc itequipanojca huan quimictijque. Teipa quintitlanqui miyac más itequipanojcahua, pero nopa ax cuajcualme quinmaquilijque sequin huan sequinoc quinmictijque. ");
INSERT INTO nheNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Huajca nopa tecojtli quipixtoya san setzi para quititlanis, eltoya itelpoca tlen quiicneli. Huajca teipa nojquiya quititlanqui campa ixocomeca miltitla, pampa nopa tecojtli moilhuiyaya para quitlepanitasquíaj itelpoca. ");
INSERT INTO nheNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero nopa tlacame tlen ininmaco eltoya nopa mili moilhuijque se ica seyoc: ‘Ya ni tlen teipa quiselis ni xocomeca mili. Ma tijmictica huan teipa ni mili elis toaxca.’ ");
INSERT INTO nheNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Huajca quiitzquijque, huan quimictijque huan quimajcajque itlacayo xocomeca milteno.” ");
INSERT INTO nheNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Huan Jesús quintlajtlani: “¿Tlachque inquiitaj quichihuas nopa tecojtli tlen iaxca nopa xocomeca mili ica nopa ax cuajcualme? Nimechilhuis, yajaya hualas, huan quinmictis nopa fiero tlacame huan quicahuas imil ininmaco sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Ax inquipojtoque campa ijcuilijtoc ipan Itlajtol Toteco campa camati tlen na queja nise hueyi tetl? Quej ni quiijtohua: ‘Nopa hueyi tetl tlen calchihuani quicuamajcajque pampa ax quinejque quitequihuise, teipa elqui tlen más monequiyaya para yas calnacastla, huan ipan quiquetzase nopa cali. ");
INSERT INTO nheNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Toteco quichijqui ma pano queja nopa huan nelía tiquitaj cuajcualtzi tlen quichijqui.’ ” ");
INSERT INTO nheNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Huajca nopa tlayacanani tlen israelitame quinequiyayaj quiitzquise Jesús pampa quimatiyayaj ni huicalotl tlen quinpohuili quiijtosnequiyaya yajuanti itztoyaj nopa fiero tequihuejme. Pero ax huelque quiitzquise pampa quinimacasiyayaj nochi nopa tlacame tlen quitoquiliyayaj. Yeca quicajtejque Jesús huan yajque. ");
INSERT INTO nheNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Teipa nopa tlayacanani quintitlanque campa Jesús sequin fariseos huan sequinoc tlen quitoquilijque Herodes para quimasiltise Jesús ica itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Huan monechcahuijque huan quiilhuijque: ―Tlamachtijquetl, tojuanti tijmatij ta se titlacatl tlen tixitlahuac huan ax tiquimacasi tlen niyon se tlacatl quiijtohua. Axaca tijchicoicnelía huan titlamachtía nelxitlahuac tlen Toteco quinequi ma tijchihuaca. ¿Ta tiquita cuali titlaxtlahuase tlen techtlajtlanía Tlanahuatijquetl César, o axtle? ¿Titlaxtlahuase o ax titlaxtlahuase? ");
INSERT INTO nheNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero Jesús quimatiyaya para quipiyayayaj ome ininxayac ica tlen quitlajtlanijque. Huajca quinilhui: ―¿Para tlen inquinequij innechcajcayahuase? Xinechhualiquilica se tomi para niquitas. ");
INSERT INTO nheNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Huan quihualiquilijque se tomi, huan Jesús quintlajtlani: ―¿Ajqueya iixcopinca quipiya ni tomi huan ajqueya itoca ijcuilijtoc ipani? Huan quinanquilijque: ―Quipiya iixcopinca Tlanahuatijquetl César. ");
INSERT INTO nheNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Huajca Jesús quinilhui: ―Xijmacaca César tlen César iaxca, huan xijmacaca Toteco tlen Toteco iaxca. Huan san quisentlachilijque ica tlen Jesús quinnanquili. ");
INSERT INTO nheNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Teipa hualajque campa Jesús sequin saduceos. Saduceos tlamachtíaj para ax quema moyolcuise tlacame tlen mictoque. Huan nopa saduceos pejque quitlajtlaníaj Jesús, quiilhuijque: ");
INSERT INTO nheNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tlamachtijquetl, Moisés techtlajcuilhui se tlanahuatili tlen quiijtohua intla miquis se tlacatl tlen quipiya isihua huan ax quinpixque yon se inincone, huajca iicni monequi mosihuajtis ihuaya nopa cahuali huan quipiyase se conetl para quiselis itlal iicni. ");
INSERT INTO nheNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Itztoyaj chicome icnime. Yajaya tlen achtohui ejquetl mosihuajti huan teipa mijqui huan ax quicajtejqui iconehua. ");
INSERT INTO nheNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Teipa iicni tlen teipa ejquetl mosihuajti ihuaya nopa cahuali. Nojquiya yajaya mijqui huan ax quicajtejqui iconehua. Huan teipa san se ipantic seyoc iicni. ");
INSERT INTO nheNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Huan queja nopa nochi chicome icnime mosihuajtijque ihuaya huan ax quicajtejque inincone. Teipa mijqui nopa sihuatl. ");
INSERT INTO nheNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Huajca, quema moyolcuise nochi tlacame tlen mictoque, ¿ajqueya tlen nopa icnime elis ihuehue nopa sihuatl pampa nochi chicome mosihuajtijque ihuaya? ");
INSERT INTO nheNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Huan Jesús quinilhui: ―Inmocuapolojtoque pampa ax inquimatij Itlajtol Toteco, niyon ax inquimatij Toteco ichicahualis. ");
INSERT INTO nheNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Quema moyolcuise nochi tlacame tlen mictoque, ayoc monequis mosihuajtise, niyon monamictise para quicahuase ininconehua. Nochi itztose para nochipa queja elhuicac ehuani ipan elhuicac huan ax miquise. ");
INSERT INTO nheNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero nelía moyolcuise tlacame tlen mictoque. ¿Ax inquipojtoque nopa amatlajcuiloli tlen quiijcuilo Moisés tlen quiijtohua quejatza Toteco quinotzqui tlen nopa xihuitzontli tlen tlatlayaya? Toteco quiilhui Moisés quej ni: ‘Na niiTeco Abraham, huan niiTeco Isaac, huan niiTeco Jacob.’ ");
INSERT INTO nheNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pampa Toteco quiijto para yajaya noja itztoya ininTeco Abraham, Isaac huan Jacob quema ya mictoyaj, tijmatij noja itztoque nepa elhuicac iixpa ya yonque huejcajquiya mijque ipan tlaltepactli. Yeca insaduceos nelía inmocuapolojtoque quema inmoilhuíaj axaca moyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Itztoya nepa se tlamachtijquetl tlen itlanahuatil Moisés tlen quicactoya Jesús quema quincamahuiyaya saduceos. Huan quimatqui para Jesús cuali tlananquilijtoya. Huajca monechcahui huan quitlajtlani: ―¿Tlachque tlanahuatili ipan itlanahuatil Moisés tlen más monequi tijchihuase? ");
INSERT INTO nheNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Huan Jesús quinanquili: ―Nopa tlanahuatili tlen más monequi tijchihuase eltoc ya ni: ‘Xitlacaquica israelitame, san Toteco itztoc Dios huan axaca seyoc. ");
INSERT INTO nheNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huan monequi xiquicneli Toteco Dios ica nochi moyolo huan ica nochi moalma, huan ica nochi motlalnamiquilis huan ica nochi mochicahualis.’ ");
INSERT INTO nheNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Huan nopa ompa tlanahuatili tlen nojquiya monequi eltoc ya ni: ‘Xiquinicneli sequinoc queja timoicnelía.’ Ax onca seyoc tlanahuatili tlen Toteco quimacatoc tlen más monequi que ni ome. ");
INSERT INTO nheNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Huan nopa tlamachtijquetl tlen itlanahuatil Moisés quiilhui: ―Cualtitoc tlamachtijquetl. Xitlahuac tlen tiquijtohua. Toteco Dios san yajaya iyojtzi tlen itztoc Dios, huan axaca seyoc. ");
INSERT INTO nheNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Huan monequi tiquicnelise Toteco ica nochi toyolo, huan ica nochi totlalnamiquilis, huan ica nochi toalma huan ica nochi tochicahualis. Huan monequi tiquinicnelise sequinoc queja timoicnelíaj. Huan intla titeicnelíaj queja nopa, ipati más iixtla Toteco quej nochi tlacajcahualistli tlatlatili huan nochi tlapiyalime tlen tlacame quimacaj Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Huan Jesús quicajqui nopa tlacatl quinanquili xitlahuac huan quiilhui: ―Ax miyac mitzpolohua para huelis ticalaquis campa tlanahuatía Toteco. Huajca teipa axaca moneltlali para más quitlajtlanis Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús tlamachtiyaya ipan hueyi tiopan calijtic huan quiijto: ―¿Para tlen quiijtohuaj nopa tlamachtiani tlen itlanahuatil Moisés para nopa Cristo tlen tlajcuilojtoc para hualas elis se iteipa ixhui David? ");
INSERT INTO nheNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David iselti quinotzqui Cristo iTeco ica ichicahualis Itonal Toteco pampa David quiijcuilo ni tlajtoli ipan Itlajtol Toteco: ‘Toteco Dios quiilhui noTeco Cristo ni tlajtoli: Ximosehui nica nonejmatl hasta nimitzmactilis mocualancaitacahua para tiquinnahuatis.’ ");
INSERT INTO nheNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Huajca Tlanahuatijquetl David iselti quinotzqui nopa Cristo iTeco. Ya ni technextilía Cristo elisquía Dios. Huajca ¿quejatza huelisquía para yajaya nojquiya elis se iteipa ixhui David? Huan nopa miyac tlacame quicaquiyayaj Jesús ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús quinmachtiyaya tlacame itlamachtil huan quinilhui: “Xijpiyaca cuidado para ax inquintoquilise inintlamachtil nopa tlamachtiani tlen itlanahuatil Moisés. Yajuanti quinpactía nentinemise ica ininyoyo huehueyac. Quinequij nochi tlacame ipan tianquis ma quintlajpaloca ica tlatlepanitacayotl. ");
INSERT INTO nheNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Quinequij mosehuise campa tlacualca ipan israelita tiopantini. Nojquiya quinequij mosehuise campa más cuali ipan hueyi tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pero ax mopinahuaj quinquixtilíaj ininchajchaj cahual toahuime. Huejcahuaj momaijtohuaj ica Toteco para tlacajcayahuase pampa quinequij para tlacame ma quinitaca huan ma quintlepanitaca. Huajca Toteco quintlatzacuiltis más quej sequinoc.” ");
INSERT INTO nheNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Teipa Jesús mosehuiyaya tiopan calijtic iixmelac nopa pilcajatzitzi campa nochi quitemayayaj inintomi. Quintlachiliyaya nopa miyac tlacame tlen quitlaliyayaj tomi nopano. Huan miyaqui tlacame tlen tominpixtoyaj temacayayaj miyac tomi. ");
INSERT INTO nheNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Huan hualajqui se cahual toahui teicneltzi huan quitenqui ome cahuani tomi tlen pilsiltzitzi tlen ipati queja macuili centavo. ");
INSERT INTO nheNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Huan Jesús quinnotzqui imomachtijcahua huan quinilhui: ―Nelía nimechilhuía, ni cahual toahui teicneltzi quitlalijtoc más tlen nochi sequinoc tlen quitlalijtoque tomi ipan nopa pilcajatzitzi. ");
INSERT INTO nheNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pampa nochi sequinoc quitemayayaj tlen san mocahuayaya, pero yaja tlahuel teicneltzi, quitenqui nochi tlen iyojtzi quipixtoya. Temacatoc nochi tlen quitequihuisquía para itlacualis. ");
INSERT INTO nheNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús quisayaya ipan hueyi israelita tiopamitl huan se tlen imomachtijcahua quiilhui: ―¡Tlamachtijquetl, xiquita! Nelía yejyectzitzi ni huejhueyi tetl ipan tepamitl huan nelyejyectzitzi ni caltini tlen iaxca tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Huan Jesús quiilhui: ―Quena, xijtlachili ni huejhueyi tiopan caltini tlen eltoc nica. Teipa ax mocahuas niyon se tetl campa eltoya pampa tlacame quixolehuase nochi. ");
INSERT INTO nheNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Teipa Jesús mosehui ipan nopa tepetl tlen itoca Olivos iixmelac nopa hueyi israelita tiopamitl, huan Pedro, Juan, Jacobo huan Andrés quitlajtlanijque ixtacatzi: ");
INSERT INTO nheNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xitechilhui, ¿quema hualase tlaxolehuani? ¿Tlachque tlanescayotl oncas quema nechcatitos para panos nochi nopa tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Huan Jesús quinilhui: ―Xijpiyaca cuidado ma axaca inmechcajcayahuas. ");
INSERT INTO nheNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Miyac tlacame hualase ica notoca huan quiijtose para yajuanti Cristo huan quincajcayahuase miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Huan inquicaquise para onca tlatehuijcayotl nica huan neca, pero amo ximomajmatica, pampa nochi ni monequi panos. Pero ax nimantzi hualas itlamiya tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Se tlali motlalanase huan motehuise ica sejcoyoc ehuani. Se tlanahuatijquetl ica isoldados motlalanas huan motehuis ica seyoc tlanahuatijquetl. Mojmolinis tlali campa hueli huan oncas huejhueyi mayantli. Huan campa hueli tlacame moajcomanase. Ica ni tlamantli sanoc pejtos tlen tlacame quiijiyohuijtiyase. ");
INSERT INTO nheNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Quema pehuas pano ni tlamantli, xijpiyaca cuidado pampa tlacame inmechtemactilise campa tequicali, huan inmechcuartajhuise ipan toisraelita tiopahua. Huan pampa innechneltocaj, inmechtemactilise campa gobernadores huan tlanahuatiani. Quej ni huelis inquinilhuise notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero achtohui monequi tlacame teixtomilise Itlajtol Toteco ipan nochi tlaltini. ");
INSERT INTO nheNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Huan quema inmechhuicase huan inmechtemactilise campa tequicali, amo ximocuesoca ica tlen inquiijtose para inmomanahuise. Amo ximoyolilhuica. San xiquijtoca tlen Toteco inmechilhuis ipan nopa tlalochtli pampa ax elis imojuanti tlen incamatise imojuanti, pero elis Itonal Toteco tlen camatis. ");
INSERT INTO nheNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Huan sequin tlacame quintemactilise iniicnihua ma miquica. Nojquiya sequin tetatme quintemactilise ininconehua. Sequin coneme motlalanase huan quintemactilise inintatahua huan ininnanahua huan quichihuase para tlacame ma quinmictica. ");
INSERT INTO nheNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nochi tlacame tlahuel inmechcocolise pampa intechneltocaj, pero intla intlaijiyohuise hasta itlamiya, Toteco Dios inmechmaquixtis. ");
INSERT INTO nheNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pero ajsis se tonal inquiitase panos tlen nopa tiocamanalojquetl Daniel huejcajquiya quiijto panos, pampa tlen fiero moquetzas Campa Más Tlatzejtzeloltic ipan nopa hueyi israelita tiopamitl campa ax quinamiqui itztos. Huan tlahuel quiijtlacos nopa tiopa. (Tlen quipohuaj ya ni, ma quimachilica tlen quiijtosnequi.) Huajca quema panos ya ni, nochi tlen itztose ipan estado Judea ma choloca ipan tepetini. ");
INSERT INTO nheNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Huan tlen itztose calpani ma choloca nimantzi; ma temoca huan ma choloca nimantzi; ma ax calaquica ininchajchaj para quiquixtise se tlajquía. ");
INSERT INTO nheNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Huan tlen itztose ipan ininmil ma ax mocuepaca para quicuitij más iyoyo. ");
INSERT INTO nheNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Pero teicneltique nopa sihuame tlen nechcatitoc para conepiyase huan nopa sihuame tlen tlachichitise ipan nopa tonali! ");
INSERT INTO nheNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xijtlajtlanica Toteco ma ax huala ni tequipacholi quema tlaseseyas, ");
INSERT INTO nheNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","pampa ipan nopa tonali oncas tlaijiyohuilistli queja ax quema oncatoc hasta quema Toteco quichijqui tlaltepactli huan niyon hasta ama. Huan ax quema oncasoc seyoc cuesoli queja nopa. ");
INSERT INTO nheNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Huan intla Toteco ax quichihuasquía cototzi nopa tonali, nochi miquisquíaj. Pero yajaya quichihuas nopa tonali ma eli cototzi pampa quinicnelía tlen quintlapejpenijtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Huajca intla se acajya inmechilhuis para nica itztoc Cristo, o Cristo itztoc nepa huan monequi inquiitatij, amo xijneltocaca. ");
INSERT INTO nheNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pampa motlalanase tlacajcayahuani tlen quiijtose para yajuanti Cristo, huan sequinoc quiijtose para yajuanti itiocamanalojcahua Toteco. Yajuanti quinextise miyac tlanescayotl huan huejhueyi chicahualis nescayotl para ica quincajcayahuase tlacame. Huan intla huelisquía, hasta nojquiya quincajcayahuasquíaj tlacame tlen Toteco quintlapejpenijtoc. ");
INSERT INTO nheNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero xijpiyaca cuidado, ya nimechilhui achtohui nochi tlen panos teipa. ");
INSERT INTO nheNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Pero ipan nopa tonali, quema tlantos nopa tlaijiyohuilistli, tzintlayohuas tonati, huan metztli ayoc tlatlanextis. ");
INSERT INTO nheNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Sitlalime huetzise tlen elhuicac, huan sequinoc tlamantli tlen eltoc ipan elhuicactli chicahuac mojmolinis. ");
INSERT INTO nheNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Teipa tlacame nechitase na tlen niMocuepqui Tlacatl quema nihualas ipan mixtli ica hueyi chicahualistli huan ica notlatlanex. ");
INSERT INTO nheNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Huan huajca niquinnahuatis noelhuicac ejcahua ma quinsentilica nopa tlacame tlen Toteco quintlapejpenijtoc tlen campa hueli ipan tlaltepactli huan elhuicactli. ");
INSERT INTO nheNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Xijmachilica ni huicalotl tlen se higuera cuahuitl. Quema pehua moseliltía imacuayo huan quisa ixihuiyo, inquimatij monechcahuía tlatotonilotl. ");
INSERT INTO nheNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","San se ica imojuanti nojquiya quema inquiitase ni tlamantli tlen nimechilhuijtoc, xijmatica ya nechca para nihualas. Ya nimonechcahuijtos ipan cuapuerta. ");
INSERT INTO nheNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nelía nimechilhuía, ni xinachtli tlacame tlen ama itztoque ax miquise hasta quema panos nochi ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Elhuicactli huan tlaltepactli panotehuas, pero notlajtol nochipa motlamichijtiyas. ");
INSERT INTO nheNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Pero axaca quimati tlachque tonal huan tlachque hora sampa nihualas ipan ni tlaltepactli. Ax quimatij nopa elhuicac ehuani ipan elhuicac, niyon na niIcone ax nijmati. San yajaya Totata, quena quimati. ");
INSERT INTO nheNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Xijpiyaca cuidado, xitlachixtoca cuali huan ximomaijtoca pampa ax inquimatij quema ajsis nopa tonal quema sampa nihualas. ");
INSERT INTO nheNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na niyas huan sampa nihualas queja ni tlacatl tlen yajqui paxaloto. Yajaya achtohui quinmacac tequihuejcayotl itequipanojcahua huan quimacac sesen itequi. Huan quinnahuati ma quimocuitlahuica cuapuerta. Huan quisqui ichaj huan yajqui paxaloto, pero itequipanojcahua monejqui mojmostla tlachixtose pampa ax quimatiyayaj tlachque tonal mocuepasquía. ");
INSERT INTO nheNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Huajca xitlachixtoca cuali ihuical quej nopa tequipanohuani tlen quichiyaj nopa caltecojtli pampa imojuanti nojquiya, ax inquimatij quema nimocuepas. Huelis nihualas tlayohua, o tlajco yohual, o quema tzajtzis cuapelech o ica ijnaloc. ");
INSERT INTO nheNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Intla nihualas nimantzi, ma ax nimechpantiqui incochtoque. ");
INSERT INTO nheNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Huan tlen nimechilhuía imojuanti, nojquiya niquinilhuía nochi tlacame: ¡Xitlachixtoca cuali para quema nihualas!” ");
INSERT INTO nheNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Polihuiyaya ome tonali para nopa israelita ilhuitl tlen itoca Pascua quema israelitame quicuaj pantzi tlen ax quipiya tlasonecajyotl. Huan nopa tlayacanca totajtzitzi ininhuaya tlamachtiani tlen itlanahuatil Moisés quitemohuiliyayaj quejatza huelisquíaj quicajcayahuasquíaj Jesús para quiitzquise huan quimictise. ");
INSERT INTO nheNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero moilhuiyayaj ax huelis quiitzquisquíaj ipan nopa ilhuitl para nopa tlacame ma ax moajcomanaca huan quintehuisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús itztoya ipan nopa altepetl Betania ipan ichaj Simón tlen achtohui tlacayo palaniyaya ica nopa cocolistli tlen itoca lepra. Huan Jesús mosehuijtoya campa mesa, huan ajsico se sihuatl tlen quihualicayaya se lemete tlen quicoyonijtoya tlen se tetl itoca alabastro. Nopa tlaajhuiyacayotl elqui tlahuel patiyo. Eliyaya senquistoc nardo huan ica nopa tlaajhuiyacayotl momajtoyaj quinpolohuaj mijcatzitzi. Huan nopa sihuatl quiquechpostejqui nopa frasco huan quitequili ipan itzonteco Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Huan sequin tlen itztoyaj nepa cualanque huan moilhuijque: ―¿Para tlen san quinenpolohua ne tlaajhuiyacayotl? ");
INSERT INTO nheNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Hueltosquía quinamacatosquía para miyac tomi queja tlaxtlahuaj para eyi ciento tonali tequitl huan nopa tomi hueltosquía quinmacatosquíaj tlen teicneltzitzi. Quej nopa quiajhuayayaj nopa sihuatl. ");
INSERT INTO nheNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero Jesús quiijto: ―Xijcahuaca, ¿para tlen inquicuatotoníaj? Ni sihuatl nechchihuilía tlen cuali. ");
INSERT INTO nheNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nochipa itztose tlacame tlen teicneltzitzi imohuaya huan huelis inquinpalehuise quema inquinequise, pero na, ax niitztos nica miyac más tonali. ");
INSERT INTO nheNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ni sihuatl quichijqui tlen huelqui. Nechpolo ni tlaajhuiyacayotl para quicualtlalis notlacayo para quema nimiquis huan nechtlalpachose, yonque noja polihui. ");
INSERT INTO nheNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nelía nimechilhuía, campa hueli ipan nochi tlaltepactli campa tlacame teixtomilise itlajtol Toteco, nojquiya tepohuilise tlen nechchihuili ni sihuatl para nochi tlacame ma quiilnamiquica. ");
INSERT INTO nheNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Teipa Judas Iscariote, se tlen nopa majtlactli huan ome imomachtijcahua Jesús, yajqui quinitato nopa tlayacanca totajtzitzi para quisencahuas quejatza quitemactilis. ");
INSERT INTO nheNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Huan quema nopa tlayacanca totajtzitzi quicajque, nelía paquiyayaj huan quiilhuijque para quitlaxtlahuise. Huajca Judas pejqui quitemohua se hora huan se lugar tlen cuali para quiitzquise Jesús para huelis quitemactilis ininmaco. ");
INSERT INTO nheNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ajsico nopa achtohui tonal tlen nopa ilhuitl quema tiisraelitame tijcuaj pantzi tlen ax quipiya tlasonejcayotl huan monequi tijmictise nopa pilborregojtzi para tiquilnamiquise nopa Pascua. Huan imomachtijcahua Jesús quitlajtlanijque: ―¿Canque tijnequi ma tijcualtlalitij nopa Pascua tlacualistli para ta? ");
INSERT INTO nheNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Huajca Jesús quintitlanqui ome imomachtijcahua ma yaca, quinilhui: ―Xiyaca ipan nopa altepetl huan inmechnamiquis se tlacatl tlen quihuica atl ipan se comitl. Xijtoquilica. ");
INSERT INTO nheNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Xiquilhuica tlen iaxca nopa cali campa yajaya calaquis para nopa tlamachtijquetl quinequi quimatis campa eltoc nopa hueyi calijtic campa huelis quicuas nopa Pascua tlacualistli ininhuaya imomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Huan inmechnextilis se hueyi cuarto tlen ya tlacualtlalili ipan se cali tlen moicpahuijtoc. Nepa xijcualtlalica nopa tlacualistli para nochi tojuanti. ");
INSERT INTO nheNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Huajca yajque imomachtijcahua huan calajque ipan nopa altepetl huan quipantijque nochi queja Jesús quinilhuijtoya. Huan nepa quisencajque nopa Pascua tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Huan quema tlayohuac, Jesús ininhuaya nopa majtlactli huan ome imomachtijcahua yajque nepa. ");
INSERT INTO nheNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Huan yajuanti mosehuiyayaj campa mesa tlacuayayaj huan Jesús quinilhui: ―Nelía nimechilhuía, se tlen imojuanti tlen tlacua nohuaya nechtemactilis. ");
INSERT INTO nheNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Huajca pejque mocuesohuaj huan sesentzitzi yajuanti pejque quitlajtlaníaj Jesús: ―¿Huelis na? Huan seyoc nojquiya quiijto: ―¿Huelis na? ");
INSERT INTO nheNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Huan Jesús quinilhui: ―Yajaya se tlen imojuanti inmajtlactli huan ome. Yajaya tlen tlacua huan quiapachohua ipantzi nohuaya ipan ni plato. ");
INSERT INTO nheNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nelía na tlen niMocuepqui Tlacatl nimiquis queja ijcuilijtoc ipan Itlajtol Toteco huejcajquiya, pero nopa tlacatl tlen nechtemactilis quipantis se hueyi tlatzacuiltilistli. Más cuali eltosquía para ax tlacajtosquía. ");
INSERT INTO nheNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Huan quema tlacuayayaj, Jesús quiitzqui pantzi, huan quitlascamatqui iTata huan quitlajcotlapanqui. Teipa quinmajmacac imomachtijcahua huan quinilhui: ―Xijcuaca, ni notlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Huan Jesús quiitzqui se taza huan quitlascamatqui iTata. Teipa quinmacac imomachtijcahua huan nochi quiique ipan nopa taza. ");
INSERT INTO nheNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Huan Jesús quinilhui: ―Ya ni noeso tlen nijtoyahuas para miyac tlacame quema nimiquis. Ica ya ni pehuas itequihuejcayo nopa yancuic tlajtoli tlen Toteco Dios quichihua ica tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Melahuac, ayoc niquis xocomecatl iayo hasta nopa tonal quema sampa niquis campa tlanahuatía Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Huan teipa quema huicaque se tiohuicatl, yajque ipan nopa tepetl Olivos. ");
INSERT INTO nheNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Huan Jesús quinilhui: ―Ni yohuali nochi imojuanti inmomajmatise huan innechtlahuelcahuase, pampa ijcuilijtoc ipan Itlajtol Toteco: ‘Nijmictis nopa tlamocuitlahuijquetl, huan iborregojhua motlalose.’ ");
INSERT INTO nheNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero quema nimoyolcuis, teipa nitlayacanas hasta estado Galilea, huan nepa timopantise. ");
INSERT INTO nheNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Huajca Pedro quiilhui Jesús: ―Yonque nochi sequinoc mitztlahuelcahuase, pero na, ax quema. ");
INSERT INTO nheNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Huan Jesús quiilhui: ―Melahuac nimitzilhuía, ipan ni tlayohua quema noja polihui para tzajtzis se cuapelech ica ompa, ta tiquinilhuis tlacame expa para ax tinechixmati. ");
INSERT INTO nheNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero Pedro noja más chicahuac quiijto: ―Yonque monequi nimiquis mohuaya, ax quema niquijtos para ax nimitzixmati. Huan nochi yajuanti nojquiya ya nopa quiijtojque. ");
INSERT INTO nheNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Teipa nochi ajsitoj campa se xochimili tlen itoca Getsemaní huan Jesús quinilhui imomachtijcahua: ―Ximosehuica nica huan nimomaijtoti ica noTata. ");
INSERT INTO nheNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Huan Jesús quinhuicac Pedro, Jacobo ihuaya Juan huan pejqui mocuesohua miyac. ");
INSERT INTO nheNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Huan quinilhui: ―Nelía tlahuel nimocuesohua hasta nijmati nimiquis amantzi san ica cuesoli. Ximocahuaca nica huan xitlachixtoca. ");
INSERT INTO nheNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Huajca Jesús moquixti se quentzi huan motlancuaquetzqui tlalchi. Huan pejqui momaijtohua ica Itata huan quitlajtlani intla huelis, ma ax quipanos nopa fiero tlaijiyohuilistli tlen hualayaya. ");
INSERT INTO nheNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Quiilhui: “Papá, ta nochi tihueli tijchihua. Xinechquixtili ni tlaijiyohuilistli tlen huala, pero amo xijchihua tlen na nijnequi, san xijchihua tlen ta mopaquilis.” ");
INSERT INTO nheNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Teipa Jesús mocuepqui campa itztoyaj imomachtijcahua, huan quinpantito cochtoque huan quiilhui Pedro: ―Simón, ¿ticochtoc? ¿Ax huelqui titlachixtoya niyon se hora? ");
INSERT INTO nheNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xitlachixtoca huan ximomaijtoca para ma ax inmechyoltilanas tlajtlacoli. Nelía imotonaltzi quinequi quichihuas tlen Toteco quinequi, pero imotlacayo tlaxicohua. ");
INSERT INTO nheNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huan Jesús sampa yajqui huan momaijtoto. Quiilhui Itata ihuical quej achtohui quiilhui. ");
INSERT INTO nheNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Teipa sampa mocuepqui campa imomachtijcahua huan sampa quinpantito cochtoque, pampa ax huelque quiijiyohuise para ax cochise. Huan imomachtijcahua ax quimatiyayaj quejatza quinanquilise. ");
INSERT INTO nheNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sampa ica expa Jesús yajqui momaijtoto. Teipa mocuepqui campa imomachtijcahua huan quinilhui: ―¿Noja incochtoque huan inmosiyajcajtoque? San ya ni. Ya ajsic ni hora para nechtemactilise na tlen niMocuepqui Tlacatl ininmaco tlajtlacolchihuani. ");
INSERT INTO nheNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ximoquetzaca, ma tiyacajya. Xiquitaca, nepa huala tlen nechtemactilis. ");
INSERT INTO nheNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Huan nimantzi quema Jesús noja camatiyaya, ajsico Judas, se tlen nopa majtlactli huan ome imomachtijcahua. Huan ihuaya hualayayaj miyac tlacame tlen quihualicayayaj machetes huan cuahuitl. Quintitlantoyaj nopa tlayacanca totajtzitzi, ininhuaya nopa tlamachtiani tlen itlanahuatil Moisés, ininhuaya nopa huehue tlacame tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Huan Judas tlen quitemactiliyaya Jesús quinmacatoya se tlanescayotl pampa quinilhuijtoya para tlen quitzoponis, yaja Jesús. Huajca ma quiitzquica huan ma quihuicaca cuali ilpitoc. ");
INSERT INTO nheNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Huan nimantzi quema Judas ajsico, quinechcahuico Jesús huan quiilhui: ―¡Tlamachtijquetl! Huan quitzoponi. ");
INSERT INTO nheNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Huajca nopa tlacame quiitzquijque Jesús huan quihuicaque. ");
INSERT INTO nheNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero se tlacatl tlen itztoya nepa quiquixti imachete, huan quimaquili itequipanojca nopa hueyi totajtzi huan quitzontequili se inacas. ");
INSERT INTO nheNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Huan Jesús quinilhui: ―¿Para tlen inhualajtoque nica para innechitzquise ica machetes huan ica cuahuitl queja nielisquía se nitlaxtejquetl? ");
INSERT INTO nheNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mojmostla nitlamachtiyaya ipan nopa hueyi tiopamitl campa initztoyaj huan ax quema innechitzquijque. Pero ya ni monequi ma pano para mochihuas tlen huejcajquiya ijcuilijtoc ipan Itlajtol Toteco para panos. ");
INSERT INTO nheNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Huan nimantzi nochi imomachtijcahua quicajtejque Jesús huan cholojque. ");
INSERT INTO nheNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huan quitoquiliyaya se telpoca tlacatl tlen motzactoya san ica se hueyi yoyomitl. Huan nopa tlacame quiitzquijque, ");
INSERT INTO nheNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","pero nopa telpocatl quicajtejqui iyoyo ininmaco huan cholojqui xolotic. ");
INSERT INTO nheNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Teipa quihuicaque Jesús campa nopa hueyi totajtzi. Huan mosentilijque nochi tlayacanca totajtzitzi, nopa huehue tlacame tlen israelitame huan nopa tlamachtiani tlen itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Huan Pedro quitoquili Jesús ica huejca huan calajqui ipan icalixpa nopa hueyi totajtzi. Teipa Pedro mosehuijtoya ininhuaya tlen quimocuitlahuiyayaj nopa cali huan nochi yajuanti mototoniyayaj tliteno. ");
INSERT INTO nheNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nopa tlayacanca totajtzitzi ininhuaya nochi nopa tlasentilistli tlen tequihuejme quintemohuayayaj ome tlacame para quiteilhuise Jesús ica tlen ax cuali quiitztoyaj quichihua para huelis quimictise, pero ax quinpantijque. ");
INSERT INTO nheNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Miyaqui istlacatiyayaj ica ya para quichijtoya tlamantli tlen ax neli quichijqui, pero ax elqui san se inintlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sequin moquetzque huan quiijistlacahuijque Jesús, huan quiijtojque: ");
INSERT INTO nheNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Tojuanti tijcajque quema quiijto para quixolehuasquía ni tiopamitl tlen tlacame quichijtoque huan ica eyi tonali quichihuas seyoc tiopamitl tlen ax tlamachijchihuali. ");
INSERT INTO nheNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero niyon ica ya nopa, ax elqui san se inintlajtol. ");
INSERT INTO nheNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Huan nopa hueyi totajtzi moquetzqui huan monechcahui campa Jesús huan quitlajtlani: ―¿Ax tleno tiquinnanquilía tlen ica mitzteilhuíaj? ¿Quejatza timomanahuis? ");
INSERT INTO nheNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero Jesús ax molini huan ax tleno quinanquili. Huajca sampa nopa hueyi totajtzi quiilhui: ―¿Ta tiCristo, tiIcone Toteco tlen nochi tijhueyichihuaj? ");
INSERT INTO nheNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Huan Jesús quiilhui: ―Quena, najaya. Huan innechitase na tlen niMocuepqui Tlacatl nimosehuijtos inejmatl Toteco Dios tlen quipiya nochi chicahualistli. Huan innechitase quema nihualas ipan nopa mixtli ipan elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Huajca nopa hueyi totajtzi motzayanili iyoyo pampa quiitac para se hueyi tlaixpanoli tlen quiijto Jesús. Huan quiijto: ―¿Para tlen tiquintemose sequinoc tlacame ma techilhuica tlachque quichijtoc ni tlacatl? ");
INSERT INTO nheNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya inquicajque para tlahuel ax quitlepanita Toteco pampa mochihua queja yajaya elisquía Toteco Dios. ¿Tlachque inquiijtohuaj ma tijchihuaca? Huan nochi quiilhuijque quinamiqui ma miqui. ");
INSERT INTO nheNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Huajca sequin pejque quiixchajchaj Jesús. Teipa quiixtzajque huan pejque quiixtlatziníaj huan quiilhuíaj: ―¡Xitechilhui ajqueya mitzixtlatzini! Huan nopa soldados quimaquiliyayaj ipan ixayac. ");
INSERT INTO nheNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Huan Pedro itztoya calixpa nepa tlatzintla huan ajsico nepa se ichpocatl tlen tlatequipanohuayaya ichaj nopa hueyi totajtzi. ");
INSERT INTO nheNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Huan nopa ichpocatl quiitac Pedro mototoniyaya tliteno huan quitlachili huan quiilhui: ―Ta nojquiya tinemiyaya ihuaya Jesús, nopa Nazaret ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero Pedro ax mocahuili para quiixmatiyaya, huan quiijto: ―Ax niquixmati, niyon ax nijmachilía tlen tinechilhuía. Huan Pedro quisqui calteno huan nimantzi tzajtzic se cuapelech. ");
INSERT INTO nheNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Huan nopa ichpoca tlatequipanojquetl quitlachili sampa huan pejqui quinilhuía tlen itztoyaj nopano: ―Ni tlacatl itztoc se tlen yajuanti tlen nejnemiyayaj ihuaya Jesús Nazaret ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero Pedro sampa quiijto para ax quiixmati. Huan quentzi teipa, nopa tlacame tlen itztoyaj nepa sampa quiilhuijque: ―Nelía ta tiitztoc se tlen yajuanti. Nesi tiehua estado Galilea pampa ticamati queja tlen nepa ehuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Huajca Pedro pejqui tlatelchihua huan pejqui quitestigojquetza Toteco Dios huan quinilhui: ―Ax niquixmati ne tlacatl tlen innechcamahuíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Huan ipan nopa tlalochtli se cuapelech tzajtzic ica ompa. Huajca Pedro quiilnamijqui tlen Jesús quiilhuijtoya. Quiijto para quema noja polihui para tzajtzis se cuapelech ica ompa, Pedro quiijtosquía expa para ax quiixmati Jesús. Huan Pedro moilhui tlen quichijqui huan pejqui choca. ");
INSERT INTO nheNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Huan hualmostla cualca nopa tlayacanca totajtzitzi, nopa huehue tlacame tlen israelitame huan nopa tlamachtiani tlen itlanahuatil Moisés, mosentilijque ica nochi nopa tlasentilistli tlen tequihuejme para mocamahuise tlachque quichihuase. Teipa quiilpijque Jesús huan quihuicaque. Quitemactilijque imaco Pilato pampa quipixqui tequihuejcayotl ipan estado Judea. ");
INSERT INTO nheNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Huan Pilato quitlatzintoquili Jesús: ―¿Ta tiinintlanahuatijca israelitame? Huan Jesús quinanquili: ―Quena. Melahuac tlen tiquijtohua. ");
INSERT INTO nheNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Huan nopa tlayacanca totajtzitzi quiteilhuijque Jesús ica miyac tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Huajca Pilato sampa quitlatzintoquili Jesús huan quiilhui: ―¿Ax tleno tiquinnanquilis? Xiquita, mitzteilhuijtoque ica miyac tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero Jesús ax tleno quinanquili, huan Pilato quisentlachili miyac. ");
INSERT INTO nheNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Sesen xihuitl ipan nopa ilhuitl Pilato momajtoya quimajcahua se tlacatl tlen tzactoc para ma yohui ichaj. Momatqui quimalacanis tlen nopa miyac tlacame quitlajpejpenisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Itztoya se tlacatl ipan tlatzactli tlen itoca eliyaya Barrabás. Barrabás huan ihuampoyohua temictijtoyaj quema motehuiyayaj ica nopa gobierno ipan nopa tlali. ");
INSERT INTO nheNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huan nopa miyac tlacame ajsicoj iixpa Pilato huan pejque quitlajtlaníaj ma quimalacanis se tlacatl queja nochipa quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Huan Pilato quinnanquili: ―¿Inquinequij ma nimechmajcahuilis Jesús, imotlanahuatijca inisraelitame? ");
INSERT INTO nheNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato quimatiyaya nopa tlayacanca totajtzitzi san quitemactilijtoyaj Jesús pampa quichicoitayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero nopa tlayacanca totajtzitzi quinchihualtijque tlacame para ma quitlajtlanica Pilato ma quimalacanis Barrabás, huan ax Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Huajca Pilato sampa quintlatzintoquili: ―¿Huajca tlachque inquinequij ma nijchihua ica Jesús tlen inquitocaxtíaj nopa tlanahuatijquetl tlen israelitame? ");
INSERT INTO nheNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Huan chicahuac quiijtojque: ―¡Xijcuamapelolti! ");
INSERT INTO nheNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pero Pilato quintlajtlani: ―¿Para tlen? ¿Tlachque tlamantli ax cuali quichijtoc? Pero nopa tlacame sampa tlahuejchijque más chicahuac: ―¡Xijcuamapelolti! ");
INSERT INTO nheNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Huajca pampa Pilato quinequiyaya cuali mocahuas ininhuaya nopa miyac tlacame, quimalacani Barrabás. Huan tlanahuati ma quicuartajhuica Jesús, huan teipa quinmactili soldados tlen altepetl Roma ehuani para ma quicuamapeloltica. ");
INSERT INTO nheNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Huajca nopa soldados quihuicaque Jesús campa icalixpa nopa hueyi tequicali, huan nepa mosentilijque nochi soldados. ");
INSERT INTO nheNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Huan quiquentijque Jesús se yoyomitl huehueyac tlen itlachiyalis moradojtic queja momatque quitequihuíaj tlanahuatiani. Huan quisencajque se huitzcorona huan quitlalilijque itzontecontipa Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Huan pejque quitlaijilhuíaj huan quiilhuijque: ―¡Ma itzto miyac tonali ni inintlanahuatijca israelitame! ");
INSERT INTO nheNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Huan quimaquiliyayaj Jesús ipan itzonteco ica se ohuatl, huan quiixchajchayayaj. Motlancuaquetzayayaj iixpa queja quihueyichihuasquíaj, pero axtle. ");
INSERT INTO nheNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Quema tlanque quitlaijilhuíaj, quiquixtilijque iyoyo tlen moradojtic huan quiquentijque tlen ya iyoyo. Teipa quihuicaque para quicuamapeloltitij. ");
INSERT INTO nheNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Huan san panoyaya se tlacatl tlen itoca eliyaya Simón pampa ajsitihualayaya tlen itlal. Huan nopa soldados quinahuatijque ma quihuica icuamapel Jesús. Simón ejqui altepetl Cirene huan elqui inintata Alejandro huan Rufo. ");
INSERT INTO nheNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Huan nopa soldados quihuicaque Jesús campa se lugar tlen itoca Gólgota. (Gólgota quinequi quiijtos Campa Onca Mijcatzontecomitl.) ");
INSERT INTO nheNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Huan quisencajque xocomecatl iayo maneltic ihuaya se tlamantli tlen chichic tlen itoca mirra para quimacase Jesús, pero yajaya ax quiic. ");
INSERT INTO nheNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Huan quema quicuamapeloltijtoyaj Jesús, nopa soldados momajmacaque iyoyo. Huan mahuiltijque ica piltetzitzi tlen yejyectzitzi para quimatise tlachque quihuicas sesen yajuanti. ");
INSERT INTO nheNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ica ijnaloc a las nueve quicuamapeloltijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Huan quitlalijque se tlajcuiloli ipan itzonpac icuamapel para ma nesi tlen ica quiteilhuijtoyaj para ma miqui. Huan nopa tlajcuiloli quiijto: NI ININTLANAHUATIJCA ISRAELITAME. ");
INSERT INTO nheNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Huan quincuamapeloltijque ome tlaxtequini ihuaya Jesús, se ica inejmatl, huan seyoc ipan iarraves. ");
INSERT INTO nheNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Quej nopa panoc pampa queja nopa ya ijcuilijtoya ipan Itlajtol Toteco campa quiijto: “Quichihuilise queja elisquía se tlaixpanoquetl.” ");
INSERT INTO nheNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Huan tlacame tlen panoyayaj quihuetzquiliyayaj. Quiojoliniyayaj inintzonteco huan quiilhuiyayaj: ―¡Ya nopa tlen monequi! Ta tiquijto tijxolehuasquía nopa tiopamitl huan ica eyi tonali tijchihuasquía sampa. ");
INSERT INTO nheNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Huajca ama ximomaquixti huan xitemo ipan mocuamapel, intla tihueli. ");
INSERT INTO nheNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Quej nopa nojquiya nopa tlayacanca totajtzitzi huan nopa tlamachtiani tlen itlanahuatil Moisés quitlaijilhuiyayaj Jesús. Quiijtohuayayaj: ―Yajaya quinmaquixti sequinoc, pero ama ax hueli momaquixtía. ");
INSERT INTO nheNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Intla nelía tiCristo tlen Toteco techtitlanisquía huan nelía titlanahuatijquetl tlen israelitame, xitemo nimantzi tlen nopa cuamapeli, huan tiquitase huan tijneltocase. Huan nopa tlaxtequini tlen quincuamapeloltijtoyaj ihuaya, no quitlaijilhuiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Huan ica tlajco tona tzintlayohuac nochi nopa tlali hasta las tres ica tiotlac. ");
INSERT INTO nheNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Huan a las tres Jesús chicahuac quiijto: “Eloi, Eloi, ¿lama sabactani?” (Ya ni quinequi quiijtos: “NoTeco, noTeco, ¿para tlen tinechtlahuelcajtoc?”) ");
INSERT INTO nheNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sequin tlen itztoyaj nepa quicajque camati, pero ax quimachilijque itlajtol. Huan quiijtojque: ―¡Xijcaquica! Yajaya quinotza nopa tiocamanalojquetl Elías. ");
INSERT INTO nheNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Huan se tlacatl motlalo huan quixoloni se tlamantli tzotzoltic ica xocomecatl iayo tlen xococ. Teipa quitlali ipan se ojtla cuahuitl huan quimacac Jesús ma quichichina. Quiijto: ―Ma tiquitaca intla hualas Elías quitemohuiqui. ");
INSERT INTO nheNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Huan Jesús tzajtzic chicahuac huan mijqui. ");
INSERT INTO nheNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huan ipan nopa tlalochtli tzayanqui nopa hueyi cortina tlen ica quitzactoyaj Campa Más Tlatzejtzeloltic ipan nopa hueyi israelita tiopamitl. Nopa yoyomitl motlajcoitac pejtejqui huejcapa hasta tlazintla tlamito. ");
INSERT INTO nheNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Huan nopa tlayacanquetl tlen soldados tlen itztoya iixpa Jesús quiitac quejatza mijqui huan quiijto: ―Nelía ni tlacatl Icone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nojquiya itztoyaj nepa sequin sihuame tlen quitlachiliyayaj Jesús ica huejca. Ininhuaya itztoyaj María Magdalena, Salomé huan María ininnana José huan Jacobo tlen teipa ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ni sihuame quitoquiliyayaj Jesús huan quipalehuiyayaj quema itztoya ipan estado Galilea. Teipa yajuanti huan miyac más sihuame ajsicoj ihuaya Jesús ipan altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Eltoya nopa tonal para quicualtlalise nochi para nopa seyoc tonal quema israelitame mosiyajcahuaj. Huan quema tlayohuac, ");
INSERT INTO nheNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","hualajqui José se Arimatea ejquetl. Yajaya elqui se tequihue ipan nopa hueyi tlasentilistli huan nochi tlacame quitlepanitayayaj. Huan yajaya nojquiya quichiyayaya ma tlanahuati Toteco ipan tlaltepactli. Huajca José mosemacac huan calaquito campa Pilato huan quitlajtlanito itlacayo Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Huan Pilato ax huelqui quineltoca para nelía ya mictoya Jesús. Huajca quinotzqui nopa inintlayacanca soldados huan quitlajtlani intla ya mictoya. ");
INSERT INTO nheNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Huan nopa tlayacanquetl quiilhui para quena. Huajca Pilato quicahuili José ma quihuica itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Huan José quicojqui se yoyomitl tlen cuali huan tlen hueyi, huan quitemohuito itlacayo Jesús ipan cuamapeli huan quiquimilo ica nopa yoyomitl. Teipa quitlali itlacayo ipan se tlacacahuaya tlen quicoyonijtoya ipan tetl huan quimimilo se hueyi tetl para quitzacuas nopa tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Huan María Magdalena ihuaya María inana José quitlachiliyayaj campa quitlalijque itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ipan sábado ica tiotlac quema ya tlantoya nopa tonal quema tiisraelitame timosiyajcahuaj, María Magdalena, María inana Jacobo, huan Salomé quicojque tlaajhuiyacayotl para quitlalilise itlacayo Jesús. ");
INSERT INTO nheNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Huan ijnaltzi ipan domingo, nopa achtohui tonal ipan samano, yajque campa tlacacahuaya quema quistihualayaya tonati. ");
INSERT INTO nheNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Huan motlatzintoquiliyayaj: ―¿Ajqueya techijcuenilis nopa hueyi tetl tlen ica quitzactoque nopa tlacacahuaya? ");
INSERT INTO nheNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero quema ajsitoj nepa, quitlachilijque huan quiitaque para ya quiijcuenijtoyaj nopa tetl yonque nelía hueyi. ");
INSERT INTO nheNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Huan calajque ipan nopa tlacacahuaya, huan nepa ica ininnejmatl quiitaque mosehuijtoya se telpoca tlacatl tlen moquentijtoya iyoyo chipahuac huan huehueyac. Huan nopa sihuame momajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero nopa telpoca tlacatl quinilhui: ―Amo ximomajmatica. Nijmati inquitemohuaj Jesús, nopa Nazaret ejquetl tlen quicuamapeloltijque. Pero axaca itztoc nica, ya moyolcuitoc. Xijtlachilica campa quitectoyaj. ");
INSERT INTO nheNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Huan xiyaca, xiquinilhuitij imomachtijcahua ihuaya Pedro para Jesús inmechyacanas hasta nepa estado Galilea. Nepa inquiitase queja yajaya inmechilhui achtohui. ");
INSERT INTO nheNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Huajca nopa sihuame motlalojtejque tlen nopa tlacacahuaya, huan huihuipicayayaj huan momajmatiyayaj. Huan axaca quiilhuijque tleno pampa tlahuel majmahuiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Huan quema Jesús moyolcuic cualca ipan domingo nopa achtohui tonal ipan samano, achtohui monexti campa María Magdalena tlen achtohuiya quinpiyayaya chicome iajacahua Axcualtlacatl huan yaja quinquixtilijtoya. ");
INSERT INTO nheNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Huan María Magdalena yajqui quinyolmelahuato imomachtijcahua tlen nejnentoyaj ihuaya Jesús. Huan quema ajsito, quinpantito mocuesohuayayaj huan chocayayaj. ");
INSERT INTO nheNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Huan imomachtijcahua ax quineltocaque quema quinilhui para ya moyolcuitojca Jesús huan ya quiitztoya. ");
INSERT INTO nheNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Teipa Jesús monexti achi moixpatlatoc queja elisquía seyoc tlacatl quema ome imomachtijcahua nemiyayaj ipan se ojtli huejca tlen campa caltini. ");
INSERT INTO nheNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Huan nopa ome tlacame yajque huan quinyolmelahuatoj nopa sequinoc, pero nojquiya yajuanti ax quinneltocaque. ");
INSERT INTO nheNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Huan teipa Jesús monexti campa nopa majtlactli huan se imomachtijcahua quema tlacuayayaj. Huan Jesús quinajhuac pampa nelía yoltetique. Huan ax quineltocaque para moyolcuitojca. Niyon ax quinneltocatoyaj inintlajtol tlen quiitztoyaj para ya moyolcuitoc. ");
INSERT INTO nheNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Huan Jesús quinilhui: “Xiyaca ipan nochi tlaltepactli huan xiteilhuitij itlajtol Toteco ica nochi tlacame. ");
INSERT INTO nheNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ajqueya quineltocas huan mocuaaltis, Toteco quimaquixtis. Pero ajqueya ax quineltocas, Toteco quitlatzacuiltis. ");
INSERT INTO nheNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Huan tlen quineltocase quipantijtiyase ni tlanescayotl: Ica notoca quinquixtise iajacahua Axcualtlacatl. Camatise ica yancuic tlajtoli. ");
INSERT INTO nheNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Intla quinitzquise cohuame o quiise se tlamantli tlen pajyo, ax tleno quinchihuilis. Nojquiya quitlalise ininma ipan cocoyani huan mochicahuase.” ");
INSERT INTO nheNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Huajca quema Tohueyiteco Jesús tlanqui quincamahuía, tlejcotejqui elhuicac huan mosehuito inejmatl Toteco. ");
INSERT INTO nheNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Huan imomachtijcahua yajque, huan quiixtomatoj Itlajtol Toteco campa hueli techaj. Huan Tohueyiteco quinpalehuiyaya huan tenextiliyaya para melahuac inintlajtol pampa ica yajuanti quichihuayaya huejhueyi tlanescayotl. San ya nopa.");
INSERT INTO nheNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Noicni Teófilo, miyac tlacame quichijtoque campeca quiijcuilose nochi nopa tlamantli tlen panotiyajque toixtla ipan inemilis Jesucristo. ");
INSERT INTO nheNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Quiijcuilojtoque tlen nopa tlacame tlen quiixtonque itlajtol techilhuijque para quiitztiyajque hasta quema pejque nejnemij ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Huan huajca na nojquiya nimoilhui cuali para nimitztlajcuilhuis nochi tlen panoc tlen quema tlacatqui Jesús huan quejatza panotiyajqui hasta itlamiya pampa ica yolic nijtemojtoc tlen melahuac ica nochi ni tlamantli. Huajca noicni Teófilo tlen nochi mitztlepanitaj miyac, ama nimitztlajcuilhuis nochi ");
INSERT INTO nheNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","para tijmachilis nelía temachtli nopa tlamantli tlen tlacame mitzmachtijtoquejya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ipan nopa tonali quema tlanahuatiyaya Herodes el Grande ipan estado Judea, itztoya se totajtzi tlen itoca eliyaya Zacarías tlen tequitqui ipan nopa Abías pamitl tlen totajtzitzi. Zacarías quipixqui isihua tlen itoca eliyaya Elisabet huan nochi ome eliyayaj iteipa ixhuihua nopa totajtzi Aarón tlen huejcajquiya itztoya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías huan Elisabet itztoyaj xitlahuaque iixtla Toteco. Quintoquilijque itlanahuatilhua Toteco huan nochi tlen yajaya quinnahuati ma quichihuaca. Yeca axaca huelqui quinteilhui ica niyon se tlamantli fiero. ");
INSERT INTO nheNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero ax quipiyayayaj niyon se conetl pampa Elisabet ax hueliyaya conecui huan inijuanti ya huehuejtixtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Huan se tonal Zacarías quichihuayaya itequi nepa tiopan calijtic iixtla Toteco, pampa quitocaro se ipan nopa Abías pamitl tlen totajtzitzi ma tequiti. ");
INSERT INTO nheNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Huan queja momatque quichihuaj totajtzitzi, mahuiltijque ica piltetzitzi para quiitase ajqueya tlen inijuanti Toteco quitlapejpenis para quitlatis nopa copali iixtla Toteco ipan nopa hueyi israelita tiopamitl. Huan quitocaro Zacarías ma quitlati. ");
INSERT INTO nheNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Huan ipan nopa hora quema Zacarías quitlatiyaya nopa copali tiopan calijtic, moquetzayayaj calteno miyac tlacame tlen momaijtohuayayaj ica Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Huan nimantzi monexti se ielhuicac ejca Toteco iixtla Zacarías. Moquetzaco ica inejmatl nopa tlaixpamitl campa quitlatiyaya copali. ");
INSERT INTO nheNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Huan Zacarías tlahuel momajmati quema quiitac nopa elhuicac ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero nopa elhuicac ejquetl quiilhui: ―Zacarías, amo ximomajmati. Toteco quicactoc tlen tijtlajtlaniyaya, huan mosihua Elisabet quipiyas se piloquichpiltzi huan tijtocajtis Juan. ");
INSERT INTO nheNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tlahuel inpaquise quema tlacatis huan paquise imohuaya miyac tlacame, ");
INSERT INTO nheNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","pampa yajaya quipiyas se hueyi tequitl iixtla Toteco. Ax quiis xocomeca atl, niyon ax quiis se tlaili nelcococ. Yajaya elis temitoc ica Itonal Toteco hasta quema noja itztos ipan inana. ");
INSERT INTO nheNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Huan yajaya quichihuas para miyac israelitame ma moyolcuepaca huan ma quitoquilica Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Juan quipiyas itlalnamiquilis huan ichicahualis queja nopa tiocamanalojquetl Elías huejcajquiya quipixtoya. Huan yajaya tlayacanas huan quincualtlalilis ininyolo tlacame ma quiselica Tohueyiteco. Quichihuas para tetatme ma moyoltlalica huan ma itztoca ica cuali ica ininconehua. Huan quichihuas para tlacame tlen ax tleno quitlepanitaj, ma tlatlepanitaca. ");
INSERT INTO nheNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Huan Zacarías quitlajtlani nopa elhuicac ejquetl: ―¿Quejatza huelis nijmatis para temachtli tlen tinechilhuía? Nosihua huan na tihuehuentzitzijya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Huan nopa elhuicac ejquetl quinanquili: ―Na niGabriel. Nochipa nimoquetza iixtla Toteco. Yajaya nechtitlanqui ma nimitzcamahuiqui huan ma nimitzyolmelahuaqui tlen itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero pampa ax tijneltocac notlajtol, tinonotiyas huan ax huelis ticamatis hasta tlacatis mocone. Huan nochi ni tlamantli panos quema ajsis nopa tonal tlen Toteco quitlalijtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Huan nopa miyac tlacame noja quichiyayayaj calteno quema ielhuicac ejca Toteco quicamahuiyaya Zacarías. Moilhuiyayaj para tlen Zacarías huejcahuayaya tiopan calijtic. ");
INSERT INTO nheNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Huan quema Zacarías quisqui, ax hueliyaya camati. Huajca quimatque para quiitztoya se tlanextili tlen Toteco quinextilijtoya tiopan calijtic. Huan Zacarías san tlamanexti pampa nonotixtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Teipa tlanqui nopa tonali tlen quitocaro Zacarías para tequitis queja totajtzi, huan yajaya mocuepqui ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Huan isihua Elisabet conecuic. Huan teipa senitztoya calijtic huan ax cana yajqui para macuili metztli. Huan isihua moilhuiyaya: ");
INSERT INTO nheNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Toteco nechtiochijtoc miyac, pampa ama niconehue huan ayoc nimopinahuas iniixtla sequinoc pampa ax nijpixtoya se nocone.” ");
INSERT INTO nheNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet ya quipixtoya icone ipan itlacayo se chicuase metztli quema Toteco quititlanqui ielhuicac ejca tlen itoca Gabriel ma yohui hasta altepetl Nazaret ipan estado Galilea ");
INSERT INTO nheNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","para quimacas se tlajtoli se ichpocatl tlen itoca eliyaya María. Huan María eliyaya se cuali ichpocatl tlen ax quema quiixmajtoya se tlacatl huan ya quiijtlantoya se telpocatl tlen itoca eliyaya José tlen eliyaya iteipa ixhui Tlanahuatijquetl David tlen huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Huan Gabriel calajqui campa María itztoya huan quiilhui: ―Xipaqui ta tlen Toteco mitzcualita. Toteco itztoc mohuaya huan achi más mitztiochijtoc que sequinoc sihuame. ");
INSERT INTO nheNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Pero quema María quiitac nopa elhuicac ejquetl, quisentlachili huan moilhui tlaque quiijtosnequi para queja nopa quitlajpalohua. ");
INSERT INTO nheNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Huan nopa elhuicac ejquetl quiilhui: ―Amo ximomajmati María. Toteco mitztlapejpenijtoc para mitztiochihuas tlahuel miyac. ");
INSERT INTO nheNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nimantzi ticonehue tielis huan teipa tijtlacatiltis se oquichpil huan tijtocajtlalis Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Yajaya elis hueyi iixtla Toteco. Huan tlacame quiixmatise para Icone Toteco Dios Tlen Más Quipiya Tlanahuatili. Huan Toteco quichihuas ma mosehuis huan tlanahuatis campa tlanahuatiyaya ihuejcapan tata David. ");
INSERT INTO nheNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Huan quipiyas tequihuejcayotl ica israelitame para nochipa huan ax quema tlamis itlanahuatilis. ");
INSERT INTO nheNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Huajca María quitlajtlani nopa elhuicac ejquetl: ―¿Quejatza niconehue nielis intla ax quema niitztoya ihuaya se tlacatl? ");
INSERT INTO nheNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Huan nopa elhuicac ejquetl quinanquili: ―Itonal Toteco hualas mopani, huan ichicahualis Toteco Dios Tlen Más Quipiya Tlanahuatili mitztlapachos huan ticonehue tielis. Huan yeca mocone elis nelía tlatzejtzeloltic, huan tlacame quiixmatise para Icone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Huan momachicni Elisabet nojquiya quipiyas icone yonque ya nanatzi. Huan yonque tlacame quiijtohuaj ax hueli conepiya, ya quipixtoc icone ipan itlacayo chicuase metztli. ");
INSERT INTO nheNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ax onca niyon se tlamantli tlen Toteco ax hueli quichihuas. Yajaya nochi hueli. ");
INSERT INTO nheNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Huajca María quiijto: ―Na niiaxca Toteco. Nica niitztoc para nijchihuas nochi tlen nechnahuatis ma nijchihua. Ma nochi panos queja tinechilhuijtoc. Huajca ica ni, yajqui nopa elhuicac ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Teipa María mocualtlali huan moisihuilti yajqui se altepetl ipan estado Judea campa onca miyac tepetini ");
INSERT INTO nheNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","campa ichaj Zacarías. Huan calaquito huan quitlajpalo Elisabet. ");
INSERT INTO nheNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Huan quema Elisabet quicajqui para María quinojnotzqui, icone Elisabet mojmolini iijtico. Huan Itonal Toteco quitemiti Elisabet, ");
INSERT INTO nheNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","huan chicahuac Elisabet quiilhui María: ―Toteco más mitztiochijtoc, María, que sequinoc sihuame huan nojquiya quitiochijtoc mocone. ");
INSERT INTO nheNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nelía se hueyi tlatlepanitacayotl para na, pampa ta tiinana nohueyiTeco tinechpaxaloco. ");
INSERT INTO nheNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quema tinechnojnotzqui, nimantzi nocone mojmolini ica paquilistli noijtico. ");
INSERT INTO nheNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Toteco mitztiochijtoc pampa tijneltocac para temachtli quichihuas tlen quiijtojtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Huan María quiijto: “Tlahuel nijhueyichihua Tohueyiteco ipan noyolo. ");
INSERT INTO nheNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Quena, nipaqui miyac ipan Toteco Dios, yajaya tlen notemaquixtijca. ");
INSERT INTO nheNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Pampa yonque san niitlatequipanojca, huan san niteicneltzi, yajaya nechilnamijqui, huan ama tlacame tlen tlacajtiyase para nochipa quiijtose para Toteco nechtiochijtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Quena, Toteco Tlen Quipiya Nochi Chicahualistli nechchihuilijtoc huejhueyi tlamantli. Tlahuel tlatzejtzeloltic ya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Toteco quintlasojtla nochi tlacame tlen quitlepanitaj ama, huan nochi tlen teipa tlacajtiyase huan quitlepanitase. ");
INSERT INTO nheNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Quena, quichijtoc huejhueyi tlamantli ica ihueyi chicahualis. Quintzontlamiltijtoc tlen mohueyimatiyayaj ipan ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Toteco quinquixtilijtoc inintequihuejcayo tlacame tlen tlanahuatiyayaj, huan quinhueyitlalijtoc inijuanti tlen moicnonejque iixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Miyac tlatiochihualistli Toteco quinmacatoc inijuanti tlen mayanayayaj, pampa quinixhuiti. Huan inijuanti tlen quipixque miyac tomi quinmajcajqui san ininmacajya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Miyac techpalehuijtoc tiisraelitame pampa tiitlatequipanojcahua. Techtlasojtlatoc huan ax techilcajtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Quitencahuili Abraham, tohuejcapan tata, para quitlasojtlasquía ya ininhuaya iteipa ixhuihua para nochipa, huan yeca techtlasojtlatoc tojuanti.” Quej nopa quiijto María. ");
INSERT INTO nheNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Huan María mocajqui ihuaya Elisabet nechca eyi metztli huan teipa mocuepqui ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Teipa ajsic hora para Elisabet conepiyas huan quitlacatilti se oquichpil. ");
INSERT INTO nheNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Huan nochi icalnechcahua huan ichampoyohua quicajque queja Toteco hueyi quitlasojtlatoya Elisabet huan quimacatoya icone huan huajca nochi paquiyayaj ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Huan quema nopa piloquichpiltzi quipixqui chicueyi tonali, nochi hualajque para quipiltequilise nopa tlanescayotl tlen itoca circuncisión ipan ipiltlacayo queja momajtoyaj quichihuaj. Huan nochi quinequiyayaj quitocajtlalise Zacarías queja itata. ");
INSERT INTO nheNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero inana quiijto: ―Axtle, ax tijtocajtise Zacarías, tijtocajtise Juan. ");
INSERT INTO nheNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Huan quiilhuijque: ―¿Para tlen? Niyon se imotatahua ax quipixqui itoca Juan. ");
INSERT INTO nheNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Huan quimanextilijque itata para quimatise tlaque itoca quinequiyaya quitlalilis. ");
INSERT INTO nheNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Huan Zacarías quintlajtlani ma quihualiquilica tlen ipan tlajcuilos. Huan Zacarías quiijcuilo: “Itoca elis Juan.” Huan nochi ininhuampoyohua san quisentlachilijque. ");
INSERT INTO nheNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Huan nimantzi pejqui quiolinía inenepil Zacarías, huan pejqui camati huan quipaquilismaca Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Huan inincalnechcahua quiitaque tlen panoc, huan nochi tlahuel momajmatijque. Huan teipa nochi tlacame tlen itztoyaj campa hueli tepetini nepa ipan estado Judea mocamahuiyayaj se ica seyoc tlen panoc. ");
INSERT INTO nheNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Huan nochi tlen quicajque tlen panoc moilhuiyayaj: “¿Tlaque elis ni piloquichpiltzi quema moscaltis?” Quej nopa quiijtohuayayaj pampa quiitayayaj para Toteco nelía quitlalijtoya ima ipan nopa oquichpil para quitiochihuas. ");
INSERT INTO nheNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Huan nimantzi Itonal Toteco ajsic ipan Zacarías, itata nopa pilconetzi, huan yajaya pejqui quiijtohua ni tlajtoli tlen Toteco quimacac. Quiijto: ");
INSERT INTO nheNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ma tijhueyichihuaca Toteco Dios tlen tiisraelitame, pampa hualajtoc techmaquixtis tiitlacajhua. ");
INSERT INTO nheNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Techtitlanilía se Temaquixtijquetl tlen quipiyas hueyi chicahualistli. Yajaya elis se iteipa ixhui Tlanahuatijquetl David tlen huejcajquiya eliyaya itlatequipanojca. ");
INSERT INTO nheNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Queja Toteco techtencahuili huejcajquiya ica itiocamanalojcahua tlen tlatzejtzeloltique, ");
INSERT INTO nheNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ama yajaya techmaquixtis ica tocualancaitacahua huan ica inijuanti tlen ax quinequij techitase. ");
INSERT INTO nheNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Quintlasojtlac tohuejcapan tatahua, huan quiilnamijqui nopa tlajtoli tlatzejtzeloltic tlen quitencahuili Abraham. ");
INSERT INTO nheNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Quena, Toteco Dios motestigojquetzqui huan melahuac quitlajtolcahuili Abraham, tohuejcapan tata, ");
INSERT INTO nheNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","para melahuac techmanahuisquía ica tocualancaitacahua para huelis tijtequipanose Toteco huan ax timajmahuise. ");
INSERT INTO nheNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Huelis tiitztose titlatzejtzeloltique iixtla huan tijchihuase tlen cuali hasta timiquise.” ");
INSERT INTO nheNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Huan teipa Zacarías quiilhui ipiloquichpil: “Tinopilcone, Toteco Tlen Más Quipiya Tlanahuatili mitztequitlalijtoc tiitiocamanalojca, huan ta titlayacanas huan tijcualtlalijtiyas iojhui Tohueyiteco tlen hualas teipa. ");
INSERT INTO nheNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Tiquinyolmelahuas iisraelita tlacajhua para yajaya tlen hualas quinmaquixtis, pampa quintlapojpolhuis inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Quena, Toteco techtlasojtla miyac, huan yeca techtitlanilijtoc yajaya tlen techtlahuilis, yajaya tlen itztoya elhuicac hualas. ");
INSERT INTO nheNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Quintlahuilis ipan ininyolo nochi tlacame tlen nemij ipan tzintlayohuilotl huan campa onca miquistli. Huan quinnextilis quejatza quipiyase tlasehuilistli ihuaya Toteco.” Quej nopa Zacarías quiijto. ");
INSERT INTO nheNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huan nopa piloquichpiltzi Juan moscaltijtiyajqui huan motlacachijqui huan Toteco quimacac chicahualistli ipan itonal. Huan teipa yajaya itztoya ipan nopa tlali huactoc campa ax tleno elqui hasta ajsic tonal para monextis huan para israelitame ma quiixmatica. ");
INSERT INTO nheNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ipan nopa tonali itztoya se hueyi tlanahuatijquetl tlen itoca eliyaya Augusto César huan yajaya tlanahuati para nochi tlacame ipan tlaltepactli ma moijcuiloca para tlaxtlahuase impuesto. ");
INSERT INTO nheNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ipan nopa xihuitl Cirenio itztoya gobernador ipan tlali Siria huan ya ni eltoya iniachtohui censo ipan nopa tonali. ");
INSERT INTO nheNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Huan monequiyaya nochi tlacame ma yaca campa inialtepe para moijcuilose. ");
INSERT INTO nheNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Huajca José quisqui altepetl Nazaret ipan estado Galilea huan yajqui altepetl Belén ipan estado Judea pampa nepa tlacatqui Tlanahuatijquetl David tlen huejcajquiya huan José eltoya se iteipa ixhui. ");
INSERT INTO nheNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Huan María, tlen ya quiijtlantoya, yajqui ihuaya para moijcuilose, huan ya tlanemiltiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Huan quema noja itztoyaj nepa Belén, ajsic hora para conepiyas María. ");
INSERT INTO nheNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Huan quitlacatilti iachtohui ejca cone, se piloquichpiltzi huan quipijqui ica pesetini huan quitejqui ipan se cuacajo campa tlacuaj tlapiyalime pampa ax quipantijque campa cochise ipan se cali para paxalohuani. ");
INSERT INTO nheNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Huan ipan nopa tlayohua itztoyaj sequin tlamocuitlahuiani tlen quinmocuitlahuiyayaj ininborregojhua campa potrero nechca Belén. ");
INSERT INTO nheNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Huan nimantzi se ielhuicac ejca Toteco monexti iniixtla huan itlatlanex Toteco yahualtic quintlahuili huan inijuanti tlahuel momajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero nopa elhuicac ejquetl quinilhui: “Amo ximomajmatica. Nihualajtoc para nimechyolmelahuas se cuali tlajtoli tlen quinmacas hueyi paquilistli nochi tlacame ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Amantzi nepa ipan Belén, ialtepe David, ya tlacatqui imotemaquixtijca. Yajaya nopa Cristo tlen Toteco Dios quiijto techtitlanilisquía. Yajaya Tohueyiteco. ");
INSERT INTO nheNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Huan ica ni tlanescayotl inquiixmatise. Inquipantise nopa piloquichpiltzi pictoc ica pesetini huan quitectoque ipan se cuacajo campa tlacuaj tlapiyalime.” ");
INSERT INTO nheNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Huan nimantzi monextijque tlahuel miyac elhuicac ehuani ihuaya ya tlen achtohui hualajqui, huan nochi inijuanti quipaquilismacayayaj Toteco huan quiijtohuayayaj: ");
INSERT INTO nheNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ma tijhueyichihuaca Toteco tlen itztoc elhuicac. Huan ipan tlaltepactli ma onca tlasehuilistli ipan ininyolo nochi tlacame tlen quichihuaj tlen Toteco quipactía.” ");
INSERT INTO nheNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Huan nopa elhuicac ehuani mocuepque elhuicac, huan nopa tlamocuitlahuiani moilhuijque: ―Ma tiyacajya Belén nimantzi. Ma tiquitatij tlen panotoc tlen Toteco techyolmelahuaco. ");
INSERT INTO nheNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Huan nopa tlamocuitlahuiani moisihuiltijtiyajque huan quipantijque María ihuaya José ica nopa pilconetzi tlen quitectoyaj ipan cuacajo. ");
INSERT INTO nheNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Huan quema quiitaque, quisque huan quinpohuilijque nochi tlacame tlen ielhuicac ejca Toteco quinilhuijtoya tlen nopa pilconetzi. ");
INSERT INTO nheNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Huan nochi tlacame tlen quicajque tlen quiijtojque san quinsentlachilijque. ");
INSERT INTO nheNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Pero María quiajcojqui nochi inintlajtol ipan iyolo huan moyolilhui nochi tlen quiijtojque. ");
INSERT INTO nheNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Huan teipa nopa tlamocuitlahuiani mocuepque quihueyichijtiyajque, huan quipaquilismacatiyajque Toteco ipampa nochi tlen quicactoyaj huan quiitztoyaj, pampa nelía quipantijque nochi queja ielhuicac ejca Toteco quinilhuijtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Quema Jesús quipixtoya chicueyi tonali, quipiltequilijque nopa tlanescayotl tlen itoca eliyaya circuncisión ipan ipiltlacayo. Huan quitocajtlalijque Jesús queja quitocajti nopa elhuicac ejquetl quema quipaxaloto María huan noja aya conehue eliyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Huan quema tlanqui nopa tonali tlen monejqui para María mocahuas ichaj para motlapajpacchihuas queja quiijtojque itlanahuatilhua Moisés, José huan María quihuicaque Jesús hasta altepetl Jerusalén para quinextitij iixtla Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pampa ijcuilijtoc ipan itlanahuatilhua Tohueyiteco campa quiijtohua: “Nochi oquichpilme tlen achtohui ehuani elise tlaiyocatlalilme para iaxcahua Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Huajca José huan María yajque para quicahuatij nopa tlacajcahualistli tlen quiijtojque itlanahuatilhua Toteco para queja quicohuasquíaj ininpilcone sampa ica inintlacajcahualis. Monequi quincahuasquíaj ome piltototzitzi o ome palomas. ");
INSERT INTO nheNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Huan itztoya nepa Jerusalén se cuali tlacatl itoca eliyaya Simeón tlen quinneltocac nochi itlanahuatilhua Toteco huan quichiyayaya ma ajsi inintemaquixtijca israelitame. Huan Itonal Toteco mocahuayaya ipan Simeón. ");
INSERT INTO nheNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Huan Itonal Toteco quinextilijtoya para ax miquisquía hasta quiitasquía nopa Cristo tlen Toteco quititlanisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Huajca Itonal Toteco quititlanqui Simeón ma yohui ipan nopa hueyi israelita tiopamitl ipan nopa tonal quema itatahua pilconetzi Jesús quihuicaque ipan nopa hueyi israelita tiopamitl para ma quinextise iixtla Toteco huan quichihuase nochi tlen quiijtojque itlanahuatilhua Moisés. ");
INSERT INTO nheNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Huan Simeón quiitac nopa pilconetzi, huan quinahuajqui huan quihueyimatqui Toteco huan quiilhui: ");
INSERT INTO nheNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“NoTeco, ama ya hueli nimiquis ica tlasehuilistli ipan noyolo, pampa ya niquitztoc ya ni tlen tinechtencahuili para niquitasquía. ");
INSERT INTO nheNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Niquitztoc ica noixtiyol yajaya tlen titechtitlanilijtoc para techmaquixtis tlen totlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Yajaya ni tlen tijtlalijtoc iniixtla nochi tlacame ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Yajaya elis queja se tlahuili tlen quintlahuilis nochi tlacame huan quinnextilis Toteco, yonque ax israelitame huan itztoque campa tlen hueli tlali. Yajaya elis tohuextilis timoisraelita tlacajhua.” ");
INSERT INTO nheNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Huan José huan María quisentlachiliyayaj tlen quiijtohuayaya Simeón tlen nopa pilconetzi Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Huan Simeón quintiochijqui huan quiilhui María: ―Xiquita, Toteco quitlalijtoc ni oquichpil para elis queja se tlanescayotl tlen Toteco tlen miyac tlacame quihuejcamajcahuase huan yeca inijuanti huetzise. Pero sequinoc miyac tlacame tlahuel paquise ica ya huan Toteco quinhueyitlalis. ");
INSERT INTO nheNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Huan queja nopa nempa nesis tlen moilhuíaj tlacame ipan ininyolo. Huan pampa yajaya mocone, tijpantis se hueyi cuesoli huan tijmachilis queja mitzyolquechilisquíaj ica se machete. ");
INSERT INTO nheNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nojquiya tiopan calijtic itztoya se sihua tiocamanalojquetl tlen itoca eliyaya Ana. Ana eliyaya iichpoca Fanuel, tlen itztoya se iteipa ixhui Aser tlen huejcajquiya. Huan quema noja eliyaya se ichpocatl, Ana monamicti, huan itztoya ihuaya ihuehue san chicome xihuitl huan ihuehue mijqui. ");
INSERT INTO nheNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Huan ama Ana ya quipixqui ochenta y cuatro xihuitl para cahualtixqui. Huan ax cana yajqui, senitztoya hueyi tiopan calijtic. Quitequipanohuayaya Toteco tonaya huan tlayohua, mosahuayaya huan momaijtoyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Huan ipan nopa tlalochtli quema Simeón quitlachiliyaya Jesús, ajsico Ana huan pejqui quitlascamati Toteco ipampa nopa piloquichpiltzi. Huan pejqui camati tlen ya ica nochi nopa tlacame ipan Jerusalén tlen quichiyayayaj ma ajsi nopa israelita Temaquixtijquetl huan quinilhuiyaya para ya tlacatqui nopa pilconetzi. ");
INSERT INTO nheNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Huan quema José huan María ya quichijtoyaj nochi nopa tlamantli tlen itlanahuatilhua Toteco quinilhuijque ma quichihuaca, mocuepque inialtepe Nazaret ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Huan nopa piloquichpiltzi Jesús moscaltijtiyajqui huan quipixtiyajqui chicahualistli. Huan quipixtiyajqui miyac itlalnamiquilis huan Toteco Dios quipixqui hueyi iyolo ihuaya huan quitiochijqui miyac. ");
INSERT INTO nheNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Huan itatahua Jesús momatque yahuij altepetl Jerusalén sesen xihuitl ipan nopa ilhuitl tlen itoca Pascua . ");
INSERT INTO nheNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Huan quema Jesús quipixtoya majtlactli huan ome xihuitl, yajqui ipan ilhuitl ininhuaya itatahua queja momatque quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Huan quema tlantoya nochi tonali tlen nopa ilhuitl, Jesús mocajqui ipan altepetl Jerusalén. Huan itatahua quisque huan mocuepayayaj ininchaj huan ax quimatque para mocajtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inijuanti moilhuiyayaj hualayaya ica nopa miyac tlacame tlen nejnemiyayaj san sejco. Huan quema ya nejnentoyaj se tonal, pejque quitemohuaj campa ininteixmatcahua huan ininhuampoyohua, ");
INSERT INTO nheNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pero ax quipantijque. Yeca mocuepque Jerusalén para quitemotij. ");
INSERT INTO nheNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Huan ica eyi tonali itatahua quipantijque Jesús hueyi tiopan calijtic, mosehuiyaya tlatlajco tlen nopa huejhueyi tlamachtiani tlen más momachtijtoyaj itlanahuatilhua Moisés. Huan Jesús quintlacaquiliyaya huan quintlatzintoquiliyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Huan nochi tlacame tlen quicaquiyayaj tlen Jesús quiijtohuayaya quisentlachiliyayaj ica itlalnamiquilis huan ica itlajtol pampa nelía cuali quinnanquiliyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Huan quema itatahua quipantijque, quisentlachilijque. Huan inana quitlatzintoquili: ―Nocone, ¿para tlen titechchihuili ya ni? Na ihuaya motata nelía timocuesojque huan timitztemojtinentoque. ");
INSERT INTO nheNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Huajca Jesús tlananquili: ―¿Para tlen innechtemojque? ¿Ax inquimatij para monequi nimotequihuis ica itequi Notata? ");
INSERT INTO nheNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero itatahua ax quimachilijque tlen yajaya quinilhui. ");
INSERT INTO nheNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Huan Jesús mocuepqui ininhuaya hasta altepetl Nazaret, huan quinneltoquilijtiyajqui nochi tlen inijuanti quinahuatiyayaj. Huan inana Jesús quiajcojqui nochi ni tlamantli tlen panoc ipan iyolo. ");
INSERT INTO nheNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Huan Jesús tlalnamictiyajqui huan motlacachijtiyajqui, huan Toteco Dios quipacti nochi tlen quichijqui huan nojquiya quinpactiyaya tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Toteco quinotzqui Juan quema Tiberio César yohuiyaya para caxtoli xihuitl tlanahuatía ipan Roma huan ipan nochi tlaltini tlen Roma iaxcahua. Huan Poncio Pilato eltoya gobernador ipan estado Judea, huan Herodes Ántipas ipan estado Galilea. Huan iicni Herodes tlen itoca eliyaya Herodes Felipe II eltoya gobernador ipan estados Iturea huan Traconite. Huan Lisinias eltoya gobernador ipan tlali Abilinía. ");
INSERT INTO nheNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Huan Anás huan teipa Caifás eltoyaj huejhueyi totajtzitzi. Huan ipan ni tonali Toteco quinotzqui Juan, itelpoca Zacarías, huan quimacac itlajtol para tlayolmelahuas quema yajaya itztoya ipan nopa huactoc tlali campa ax tleno eli. ");
INSERT INTO nheNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Huajca Juan pejqui nejnemi campa hueli ipan nopa tlali nechca atemitl Jordán. Huan tlacamanalojtinemiyaya itlajtol Toteco. Quinilhuiyaya tlacame ma moyolcuepaca, huan ma quicahuaca inintlajtlacolhua huan ma mocuaaltica para Toteco quintlapojpolhuis. ");
INSERT INTO nheNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tlen Juan quichihuayaya quitlamilti tlen nopa tiocamanalojquetl Isaías huejcajquiya quiijcuilo para quichihuasquía. Isaías quiijto: “Tlacame quicaquise se tlen camatis chicahuac ipan nopa huactoc tlali campa ax tleno eli. Quiijtos: ‘Xijcualtlalica imoyolo pampa hualas Tohueyiteco. Xijsencahuaca huan xijxitlahuaca iojhui para ipan nemis. ");
INSERT INTO nheNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Xijtemitica nochi campa tlalcoyoctli. Xijsepanoca campa tlafiero, huan xijxitlahuaca nochi ojhuijhuicoli, huan xicalaxoca nochi tlalcojcomoli. ");
INSERT INTO nheNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Pampa hualas yajaya tlen Toteco Dios techtitlanilijtoc para techmaquixtis tlen totlajtlacolhua, huan nochi tlacame quiitase.’ ” Quej nopa quiijcuilo Isaías huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Huan miyac tlacame ajsiyayaj campa Juan para ma quincuaalti, huan yajaya quinilhuiyaya: ―Initztoque queja incohuame. ¿Ajqueya inmechilhuijtoc para Toteco ax inmechtlatzacuiltis teipa intla inmocuaaltise? ");
INSERT INTO nheNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ax quej nopa. Monequi xijchihuaca tlen cuali para nochi quimatise intla nelía ya inmoyolpatlatoque huan inquicajtejtoque imotlajtlacolhua. Amo ximoilhuica para ax tleno inmechajsis pampa inielij ininteipa ixhuihua tohuejcapan tata Abraham pampa Toteco hueli quincuepas ni tetini queja iteipa ixhuihua Abraham intla quinequi quichihuas. ");
INSERT INTO nheNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Queja tlacame quitzontequij cuatini tlen ax temacaj inintlajca huan quintlatíaj, Toteco nojquiya ya mocualtlalijtoc para inmechtzontlamiltis huan inmechcuamajcahuas ipan tlitl. ");
INSERT INTO nheNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Huan nopa tlacame quitlajtlanijque: ―Huajca, ¿tlaque monequi tijchihuase? ");
INSERT INTO nheNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Huajca Juan quinilhui: ―Xijchihuaca tlen cuali. Aqui quipiya ome iyoyo ma quimaca se tlen ax tleno quipiya. Huan tlen quipiya tlacualistli nojquiya ma temajmaca. ");
INSERT INTO nheNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Huan nojquiya hualajque para mocuaaltise sequin tlacame tlen tlainanque impuesto. Nochi quimatque para nopa tlainamani tlahuel tlacajcayajque. Huan nopa tlainamani quitlajtlanijque: ―Tlamachtijquetl, ¿tlaque monequi tijchihuase tojuanti? ");
INSERT INTO nheNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Huajca Juan quinilhui: ―San xiquininamaca tlacame tlen quiijtohua tlanahuatili. ");
INSERT INTO nheNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Huan hualajtoyaj sequin soldados tlen quitlajtlanijque: ―Huan tojuanti, ¿tlaque monequi tijchihuase? Huajca Juan quinilhui: ―Amo xiquinfuerzajhuica tlacame ma inmechtlamajmacaca. Axaca xijteilhuica ica tlen ax neli huan xipaquica san ica tlen inquitlanij. ");
INSERT INTO nheNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Huan ax molinijque nopa tlacame tlen itztoyaj nepa. Nochi san quichiyayayaj huan moyolilhuiyayaj intla huelis Juan elisquía nopa Cristo tlen Toteco quitencajqui techtitlanilisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Huajca Juan quinilhui nochi nopa tlacame: ―Na nimechcuaaltía san ica atl, pero yajaya tlen hualas teipa quipiyas más chicahualistli que na. Nimechilhuijtojca tlen ya. Ax nicaxilía para nijtequipanos, niyon ax quinamiqui para nijquixtilis itecac. Yajaya inmechmacas sequin imojuanti Itonal Toteco huan sequinoc inmechtlatzacuiltis ica tlitl. ");
INSERT INTO nheNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Yajaya quiniyocatlalis tlacame tlen iaxcahua ica inijuanti tlen ax iaxcahua. Quena, Toteco quichihuas queja se tlacatl tlen quitequihuía itlaajacapehuilol para quiyejyectis trigo. Quinhuicas tlacame tlen iaxcahua queja se tlacatl quitlalis itrigo ipan icuacalhua. Huan nopa sequinoc tlacame quintlatis ipan tlitl tlen ax quema sehuis queja se tlacatl quitlatis itlasolo trigo. ");
INSERT INTO nheNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Quej nopa, Juan quinyolmelajqui nochi nopa tlacame miyac tlamantli quema quincamahuiyaya itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Huan teipa Juan quiteilhui Gobernador Herodes Ántipas pampa mocuili ihuejpol tlen itoca eliyaya Herodías para ma eli isihua. Herodías eliyaya isihua iicni tlen itoca eliyaya Herodes Felipe II. Nojquiya Juan quiteilhui Herodes Ántipas ica sequinoc tlamantli tlen fiero quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Huajca nopa Gobernador Herodes Ántipas noja más fiero quichijqui huan quitzajqui Juan. ");
INSERT INTO nheNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pero quema aya quitzactoyaj Juan, quincuaaltiyaya miyac tlacame, huan Jesús nojquiya hualajqui campa itztoya huan mocuaalti. Huan ipan nopa tlalochtli quema mocuaaltiyaya, Jesús momaijtohuayaya huan tlapojqui elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Huan hualtemoc Itonal Toteco ipan ya. Huan Itonal Toteco nesiyaya queja se paloma. Huan Toteco Dios camatqui tlen elhuicac huan quiilhui Jesús: ―Ta tiNocone tlen nimitzicnelía huan nipaqui miyac ica tlen tijchihua. ");
INSERT INTO nheNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Huan Jesús quipixtoya queja treinta xihuitl quema quipehualti itequi huan pejqui nentinemi para tepohuilis itlajtol Toteco. Huan tlacame moilhuiyayaj para eliyaya icone José. Huan José eliyaya icone Elí, ");
INSERT INTO nheNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","tlen eliyaya icone Matat, tlen eliyaya icone Leví, tlen eliyaya icone Melqui, tlen eliyaya icone Jana, tlen eliyaya icone José, ");
INSERT INTO nheNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","tlen eliyaya icone Matatías, tlen eliyaya icone Amós, tlen eliyaya icone Nahum, tlen eliyaya icone Esli, tlen eliyaya icone Nagai, ");
INSERT INTO nheNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","tlen eliyaya icone Maat, tlen eliyaya icone Matatías, tlen eliyaya icone Semei, tlen eliyaya icone José, tlen eliyaya icone Judá, ");
INSERT INTO nheNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","tlen eliyaya icone Joana, tlen eliyaya icone Resa, tlen eliyaya icone Zorobabel, tlen eliyaya icone Salatiel, tlen eliyaya icone Neri, ");
INSERT INTO nheNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","tlen eliyaya icone Melqui, tlen eliyaya icone Adi, tlen eliyaya icone Cosam, tlen eliyaya icone Elmodam, tlen eliyaya icone Er, ");
INSERT INTO nheNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","tlen eliyaya icone Josué, tlen eliyaya icone Eliezer, tlen eliyaya icone Jorim, tlen eliyaya icone Matat, ");
INSERT INTO nheNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","tlen eliyaya icone Leví, tlen eliyaya icone Simeón, tlen eliyaya icone Judá, tlen eliyaya icone José, tlen eliyaya icone Jonán, tlen eliyaya icone Eliaquim, ");
INSERT INTO nheNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","tlen eliyaya icone Melea, tlen eliyaya icone Mainán, tlen eliyaya icone Matata, tlen eliyaya icone Natán, ");
INSERT INTO nheNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","tlen eliyaya icone David, tlen eliyaya icone Isaí, tlen eliyaya icone Obed, tlen eliyaya icone Booz, tlen eliyaya icone Salmón, tlen eliyaya icone Naasón, ");
INSERT INTO nheNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","tlen eliyaya icone Aminadab, tlen eliyaya icone Aram, tlen eliyaya icone Esrom, tlen eliyaya icone Fares, tlen eliyaya icone Judá, ");
INSERT INTO nheNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","tlen eliyaya icone Jacob, tlen eliyaya icone Isaac, tlen eliyaya icone Abraham, tlen eliyaya icone Taré, tlen eliyaya icone Nacor, ");
INSERT INTO nheNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","tlen eliyaya icone Serug, tlen eliyaya icone Ragau, tlen eliyaya icone Peleg, tlen eliyaya icone Heber, tlen eliyaya icone Sala, ");
INSERT INTO nheNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","tlen eliyaya icone Cainán, tlen eliyaya icone Arfaxad, tlen eliyaya icone Sem, tlen eliyaya icone Noé, tlen eliyaya icone Lamec, ");
INSERT INTO nheNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","tlen eliyaya icone Matusalén, tlen eliyaya icone Enoc, tlen eliyaya icone Jared, tlen eliyaya icone Mahalaleel, tlen eliyaya icone Cainán, ");
INSERT INTO nheNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","tlen eliyaya icone Enós, tlen eliyaya icone Set, tlen eliyaya icone Adán, tlen eliyaya icone Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Huan Jesús quisqui atemitl Jordán temitoc ica Itonal Toteco. Huan Itonal Toteco quihuicac hasta nopa huactoc tlali campa ax tleno eli. ");
INSERT INTO nheNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Huan mocajqui nepa para cuarenta tonali huan Axcualtlacatl quiyoltilanayaya ma tlajtlacolchihuasquía. Huan ipan nochi nopa tonali ax tleno quicuajqui. Huan quema tlanqui nopa tonali, nelía mayanayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Huan hualajqui Axcualtlacatl quiilhuico: ―Intla nelía tiIcone Toteco, xijnahuati ni tetl ma mocuepa pantzi. ");
INSERT INTO nheNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Huan Jesús quinanquili: ―Ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Ax san ica pantzi yoltose tlacame. Nojquiya monequi quitoquilijtinemise nochi Itlajtol Toteco.’ ");
INSERT INTO nheNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Huan Axcualtlacatl quihuicac Jesús ipan se tepetl huejcapantic, huan ipan nopa tlalochtli quinextili ininricojyo nochi tlanahuatiani ipan tlaltepactli huan nochi tlaltini tlen iniaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Huan Axcualtlacatl quiilhui: ―Nimitzmacas tequihuejcayotl tijnahuatis nochi ni tlaltini ipan nochi tlaltepactli huan nimitzmacas nochi ininricojyo, pampa nochi nechmacatoque na huan huelis nijmacas ajqueya nijnequis. ");
INSERT INTO nheNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Huan nochi nimitzmacas ta intla san timotlancuaquetzas huan tinechhueyichihuas. ");
INSERT INTO nheNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Huan Jesús quinanquili: ―Xinechtlalcahui, Axcualtlacatl, pampa ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Xijhueyimati san Toteco Dios huan san ya xijtequipano.’ ");
INSERT INTO nheNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Huan Axcualtlacatl quihuicac Jesús altepetl Jerusalén huan quiquetzqui hasta itzonpac nopa hueyi israelita tiopamitl huan quiilhui: ―Intla nelía tiIcone Toteco Dios, xitzicuini nica para tlatzintla, ");
INSERT INTO nheNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","pampa ijcuilijtoc ipan Itlajtol campa quiijtohua: ‘Toteco quinnahuatis ielhuicac ejcahua ma mitzmocuitlahuica. ");
INSERT INTO nheNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Inijuanti mitzmatzacuilise para ax timoicxicocos ica niyon se tetl.’ ");
INSERT INTO nheNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Huan Jesús quinanquili: ―Nojquiya Itlajtol Toteco quiijtohua: ‘Amo xijyejyeco Toteco Dios san para tiquitas tlaque quichihuas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Huan quema Axcualtlacatl ya quichijtoya fuerza para quiyoltilanas Jesús ma tlajtlacolchihua, quicajtejqui hasta seyoc huelta. ");
INSERT INTO nheNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Teipa Jesús mocuepqui ipan estado Galilea temitoc ica ichicahualis Itonal Toteco. Huan campa hueli ipan nochi nopa tlali nochi tlacame quicaquiyayaj tlen ya. ");
INSERT INTO nheNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Huan yajaya pejqui quinmachtía tlacame ipan israelita tiopantini campa hueli huan nochi quihueyimatiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Huan Jesús ajsito pilaltepetzi Nazaret campa moscalti huan ipan sábado, nopa tonal para ma mosehuica israelitame, yajaya calajqui ipan israelita tiopamitl queja momajtoya quichihua. Huan moquetzqui ipan tlasentilistli para quipohuas Itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Huan quimacaque nopa amatlajcuiloli tlen huejcajquiya quiijcuilo nopa tiocamanalojquetl Isaías. Huan Jesús quitlapo huan quipanti campa ijcuilijtoc ni tlajtoli huan pejqui quipohua: ");
INSERT INTO nheNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Itonal Toteco itztoc nohuaya, pampa Toteco nechtequimacatoc para ma niquinilhui tlacame tlen teicneltzitzi itlajtol Toteco. Nechtitlantoc ma niquinchicahuas tlacame tlen mocuesohuaj, huan para ma niquinyolmelahua tlacame tlen Axcualtlacatl quinilpitoc para nihueli niquintojtomas. Nechtequimacac para niquinchicahuas popoyotzitzi para huelise tlachiyase. Huan niquinmaquixtis nochi tlen tlaijiyohuíaj ininmaco tlen quintlaijiyohuiltíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nechtitlantoc ma niquinyolmelahua nochime para ya ajsic nopa tonali, quema Toteco quinchihuilis tlacame se hueyi favor.” ");
INSERT INTO nheNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Huan Jesús quitzajqui nopa momimilojtoc amatlajcuiloli huan quimacac nopa tiopan tlapalehuijquetl, huan mosehui para tlamachtis. Huan nochi nopa tlacame tlen itztoyaj ipan nopa tlasentilistli quitlachiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Huan Jesús pejqui quincamahuía huan quinilhui: ―Ni tlajtoli tlen nijpojqui moijcuilo huejcajquiya huan camati tlen na tlen nimoquetza imoixtla. Huajca ama motlamichijtoc tlen quiijtohua. ");
INSERT INTO nheNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Huan nochi nopa tlacame camatiyayaj cuali tlen Jesús huan mosentlachiliyayaj ica itlajtol tlen nelía yejyectzi, pero motlatzintoquiliyayaj: ―¿Ax ya ni icone José? ");
INSERT INTO nheNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Huan Jesús quinilhui: ―Nijmati se tonal innechilhuise ni tlajtoli: ‘Tepajtijquetl, ximopajti, huan timitzneltocase.’ Inquiijtose para inquicactoque tlen nopa tiochicahualnextili tlen nijchijtoc ipan altepetl Capernaum, huajca ihuical ma nijchihua nica ipan imoaltepe. ");
INSERT INTO nheNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Pero tlacame tlen san sejco ehuani ihuaya se tiocamanalojquetl ax quiselíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Huan quema itztoya Elías, nopa tiocamanalojquetl tlen huejcajquiya, itztoyaj miyac israelita cahual toahuime ipan tlali Israel campa yajaya ejqui. Huan nochi nopa cahual toahuime quinpolohuayaya inintlacualis pampa ax tlaahuetzqui para eyi xihuitl huan tlajco ipan tlali Israel huan oncac se hueyi mayantli. ");
INSERT INTO nheNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Toteco ax quititlanqui Elías ma yahui ica se israelita cahual toahui tlen san sejco ehuaj. Quititlanqui ma quipalehuiti nopa cahual toahui ipan pilaltepetzi Sarepta ipan seyoc tlali tlen itoca Sidón. ");
INSERT INTO nheNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Huan itztoyaj miyac tlacame ipan tlali Israel tlen palaniyayaj inintlacayohua ica lepra quema itztoya tiocamanalojquetl Eliseo, pero Eliseo niyon se inijuanti ax quichicajqui. San quichicajqui Naamán tlen hualajqui ipan seyoc tlali tlen itoca Siria. ");
INSERT INTO nheNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Huajca nelía cualanque nochi nopa israelitame tlen quicaquiyayaj Jesús ipan nopa israelita tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Huan motlalanque huan quiquixtijque Jesús tlen inialtepe. Teipa quihuicaque hasta se tepexico tlen ipan quiquetztoyaj nopa altepetl. Quinequiyayaj quicuamimilose, ");
INSERT INTO nheNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","pero Jesús san panotiquisqui tlatlajco inijuanti huan yajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Huan Jesús ajsito altepetl Capernaum ipan estado Galilea huan pejqui quinmachtía ipan israelita tiopamitl sesen sábado, nopa tonal para israelitame ma mosehuica. ");
INSERT INTO nheNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Huan nochi tlen quitlacaquiliyayaj san quitlachiliyayaj ica itlamachtil pampa itlajtol quipixqui tequihuejcayotl. ");
INSERT INTO nheNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Huan itztoya se tlacatl ipan nopa israelita tiopamitl tlen quipixqui ipan itlacayo se iajaca Axcualtlacatl. Huan yajaya tzajtzic chicahuac huan quiilhui Jesús: ");
INSERT INTO nheNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Jesús, tiNazaret ejquetl, xitechcahua. Ax huelis timomatise mohuaya. ¿Tihualajtoc para titechtzontlamiltis? Tojuanti timitzixmatij ajqueya ta. Ta titlatzejtzeloltic. Ta tiIcone Dios. ");
INSERT INTO nheNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Huan Jesús quitlacahualti iajaca Axcualtlacatl huan quiilhui: ―Amo ximolini. Xiquisa ipan ni tlacatl. Huan nopa ajacatl quimajcajqui nopa tlacatl tlalchi iniixtla nochi nopa tlacame, huan teipa quisqui ipan itlacayo huan ax tleno más quichihuili. ");
INSERT INTO nheNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Huan nochi nopa tlacame quisentlachiliyayaj huan pejque motlajtlaníaj se ica seyoc: ―¿Tlaque tlamantli tlajtoli camati ni Jesús? Nempa itlajtol Jesús quipiya tlanahuatili huan chicahualistli pampa quema quinnahuatía iajacahua Axcualtlacatl, nopa ajacame quineltoquilíaj huan quisaj. ");
INSERT INTO nheNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Huan campa hueli ipan nopa tlali nechca altepetl Capernaum nochi tlacame quimatque tlen Jesús quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Huan Jesús moquetzqui huan quisqui ipan tiopamitl huan yajqui ichaj Simón Pedro. Huan quipanti imona Pedro mococohuayaya pampa chicahuac totoniyaya. Huan nochi tlen itztoyaj nepa quitlajtlanijque Jesús ma quichicahua. ");
INSERT INTO nheNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Huajca Jesús mopacho campa huetztoya huan quinahuati nopa tlatotonilotl ma quisa. Huan nopa tlatotonilotl quicajtejqui, huan nimantzi moquetzqui nopa sihuatl huan pejqui quintlamaca. ");
INSERT INTO nheNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Huan ica tiotlac nochi tlacame tlen quinpixtoyaj cocoyani ipan ininchajchaj quinhualicaque campa Jesús. Huan itztoyaj cocoyani tlen quipixtoya miyac tlamantli cocolistli. Huan Jesús quitlali ima ipan sesen nopa cocoyani huan quinchicajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Huan miyac tlacame nepa quinpixtoyaj iajacahua Axcualtlacatl. Huan inijuanti quisayayaj huan chicahuac quiijtohuayayaj tlen Jesús: ―Ta tiIcone Dios. Pero Jesús quinnahuati nopa ajacame ma ayoc camatica pampa inijuanti quiixmatiyayaj yajaya itztoya nopa Cristo tlen Toteco quiijto quititlanisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Huan quema tlanestihualayaya, Jesús quisqui nopona, huan yajqui ipan nopa huactoc tlali campa ax tleno eli. Huan miyac tlacame quitemohuayayaj. Huan quema quipantijque, quiilhuijque ma mocahua ipan inintlal. ");
INSERT INTO nheNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesús quinilhui: ―Monequi nojquiya niyas ipan sequinoc altepetini para niquinilhuis tlacame itlajtol Toteco huan niquinnotzas ma calaquica campa yajaya tlanahuatía, pampa ya nopa nechtitlantoc ma nijchihua. ");
INSERT INTO nheNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Huan Jesús tlaixtontinenqui itlajtol Toteco ipan israelita tiopantini ipan campa hueli altepetl ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Huan nopa miyac tlacame nelía quicuatetzopayayaj Jesús pampa quinequiyayaj quicaquise itlajtol Toteco. Huan Jesús moquetzayaya iteno hueyi atl tlen itoca Genesaret , ");
INSERT INTO nheNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","huan quiitac ome cuacanahua ateno tlen nopa michtlajtlamani quincajtejtoyaj pampa quipajpacayayaj ininmatla. ");
INSERT INTO nheNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Huajca Jesús tlejcoc ipan icuacanahua Simón Pedro huan quiilhui ma quinejnemilti nopa cuacanahua quentzi ipan atl. Huan Jesús mosehui ipan cuacanahua huan pejqui quinmachtía nopa miyac tlacame tlen mocahuayayaj ateno huan nochi huelque quitlachilíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Huan teipa quema tlanqui quincamahuía nopa tlacame, Jesús quiilhui Simón: ―Xijnejnemilti ni cuacanahua hasta campa achi huejcatla huan nepa xijmajcahuaca imomatlahua para inmichitzquise. ");
INSERT INTO nheNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Huan Simón quinanquili huan quiilhui: ―Tlamachtijquetl, timichtemojque seyohual huan niyon se michi ax tiquitzquijque. Pero intla queja nopa titechilhuía ma tijchihuaca, huajca sampa tijmajcahuase tomatla. ");
INSERT INTO nheNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Huan quimajcajque ininmatla, huan quinitzquijque tlahuel miyac michime hasta quinequiyaya tzayanis ininmatla. ");
INSERT INTO nheNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Huan quinmanotzque ininhuampoyohua tlen itztoyaj ipan nopa seyoc cuacanahua para ma quinpalehuiquij. Huan hualajque huan quitemitijque nochi ome cuacanahua ica michime hasta san quentzi misahuiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Huan quema Simón Pedro quiitac tlen panotoya, motlancuaquetzqui iixtla Jesús huan quiilhui: ―Toteco, xinechtlalcahui pampa na nieli se nitlajtlacolchijca tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Simón quiilhui Jesús ya ni pampa yajaya huan nochi ihuampoyohua mosentlachiliyayaj pampa quiitaque nopa miyac michime tlen quinitzquijque. ");
INSERT INTO nheNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Huan nojquiya quisentlachilijque Jacobo huan Juan tlen eliyaya itelpocahua Zebedeo huan eliyayaj ihuampoyohua Simón. Huan Jesús quiilhui Simón: ―Amo ximomajmati. Ama timichtlajtlamajquetl, pero na nimitznextilis quejatza tiquinnotzas tlacame ma nechtoquilica. ");
INSERT INTO nheNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Huan quinejnemiltijque inincuacanahua hasta iteno nopa hueyi atl, huan quicajtejque nochi tlen quipixtoyaj huan quitoquilijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Huan Jesús itztoya ipan se altepetl, huan hualajqui se tlacatl tlen palaniyaya itlacayo ica nopa cocolistli lepra. Huan quema quiitac Jesús, motlancuaixtlapacho iixtla huan chicahuac quiilhui: ―Toteco, intla tijnequi, huelis tinechchicahuas. ");
INSERT INTO nheNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Huajca Jesús quitlali ima huan quiilhui: ―Quena, nijnequi. Ximochicahua amantzi. Huan nimantzi icocolis quicajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Huan Jesús quinahuati ma ax tepohuili tlen panoc, quiilhui: ―San xiya ximonextiti ica nopa totajtzi huan xijmaca Toteco nopa tlacajcahualistli tlen Moisés tlanahuati ma quimacaca para ma motlapajpacchihuaca tlen ayoc tlacayo palantoque. Quej nopa quimatise timochicajquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero campa hueli miyac más tlacame quicaquiyayaj tlen ichicahualis Jesús huan huajca miyac mosentilijque campa itztoya para quicaquise itlajtol huan para ma quinchicahua tlen inincocolis. ");
INSERT INTO nheNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero miyac huelta Jesús moiyocaquixti iselti huan yajqui campa axaca aquiyaya para huelis momaijtos ica Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Se tonal Jesús quinmachtiyaya tlacame ipan se cali, huan itztoyaj nepa sequin fariseos huan huejhueyi tlamachtiani tlen itlanahuatilhua Moisés tlen hualajque ipan nochi ranchos ipan estados Galilea huan Judea huan tlen hueyi altepetl Jerusalén. Huan Jesús quipixqui ichicahualis Toteco para quinchicahuas cocoyani. ");
INSERT INTO nheNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huan hualajque sequin tlacame tlen quihualicayayaj se cocoxquetl tlen ax hueliyaya mojmolinía. Huan quinequiyayaj calaquise calijtic campa itztoya Jesús para quitlalise nopa cocoxquetl iixtla, ");
INSERT INTO nheNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","pero ax oncac campa calaquise pampa motetzoptoyaj tlahuel miyac tlacame. Huajca nopa tlacame tlejcoque calpani huan quiijcuenijque se ome tejas. Teipa quitemohuijque nopa cocoxquetl ipan itlapech tlatlajco nochi nopa tlacame huan quitlalijque iixtla Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Huan Jesús quiitac para nopa tlacame quineltocayayaj huan quiilhui nopa cocoxquetl: ―Nohuampo, nimitztlapojpolhuía motlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Huan nopa tlamachtiani tlen itlanahuatil Moisés huan nopa fariseos pejque moyolilhuíaj: “¿Ajqueya nelía ni Jesús? Yajaya niyon quentzi ax quitlepanita Toteco Dios pampa mochihua queja ya elisquía Toteco. Axaca hueli tetlapojpolhuía tlajtlacoli, san Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero Jesús quimatiyaya tlen inijuanti moyolilhuiyayaj huan quinilhui: ―¿Para tlen inmoilhuíaj ax nijtlepanita Toteco Dios? ");
INSERT INTO nheNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Intla niquilhuis ni cocoxquetl: ‘Ximehua huan xinejnemi’ huan mochihuas notlajtol, nojquiya motlapojpolhui quema niquilhui: ‘Nimitztlapojpolhuía motlajtlacolhua.’ ");
INSERT INTO nheNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nijnequi xijmatica na tlen niMocuepqui Tlacatl nijpiya tequihuejcayotl ipan tlaltepactli para nitetlapojpolhuis, huajca nimechnextilis para mochihuas tlen niquijtohua. Huan nimantzi Jesús quiilhui nopa cocoxquetl: ―Nimitzilhuía, ximehua huan xijtlalana motlapech huan xiya mochaj. ");
INSERT INTO nheNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Huan nimantzi nopa cocoxquetl moquetzqui huan quitlalantejqui itlapech huan yajqui ichaj, quihueyichijtiyajqui Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Huan nochi nopa tlacame mosentlachilijque huan momajmatijque. Huan teipa pejque quihueyichihuaj Toteco huan quiijtojque: ―Nelía se hueyi chicahual nescayotl tiquitztoque ama. ");
INSERT INTO nheNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Teipa quema Jesús quisayaya ipan nopa altepetl, quiitac se tlacatl tlen tlainanqui impuesto. Yajaya itoca eliyaya Mateo huan nojquiya itoca eliyaya Leví, huan mosehuijtoya campa nopa mesa para quiselis impuesto. Huan Jesús quiilhui: ―Xinechtoquili. ");
INSERT INTO nheNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Huan Mateo quicajtejqui nochi tlen quipixtoya. Huan moquetztiquisqui huan yajqui ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Huan Mateo quichijqui se hueyi ilhuitl nepa ichaj. Huan tlacuayayaj ihuaya Jesús campa mesa miyac tlacame tlen tlainanque impuesto huan momajtoyaj tlacajcayahuaj. Huan nojquiya itztoyaj sequinoc tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Huan hualajque fariseos huan tlamachtiani tlen itlanahuatil Moisés huan quiitaque. Huajca pejque quiteilhuíaj Jesús iniixtla imomachtijcahua huan quinilhuijque: ―¿Para tlen intlacuaj huan inatlij ininhuaya ni tlacame tlen tlainamaj impuesto huan tlacajcayahuaj? Huan ¿ininhuaya ni sequinoc tlen miyac tlajtlacoli quichihuaj? ");
INSERT INTO nheNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Huan Jesús quinnanquili nopa fariseos huan quinilhui: ―Se tetica tlacatl ax quinequi se tepajtijquetl, pero se cocoxquetl, quena. ");
INSERT INTO nheNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na ax nihualajtoc para niquinnotzas tlacame tlen moilhuíaj para cuajcualme iixtla Toteco. Nihualajtoc para niquinnotzas tlacame tlen quimatij quipiyaj inintlajtlacolhua para ma moyolcuepaca. ");
INSERT INTO nheNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Huan hualajque sequin tlacame tlen quiilhuijque Jesús: ―Imomachtijcahua Juan tlen tecuaaltía ajachica mosahuaj para momaijtose ica Toteco Dios. Huan ihuical quichihuaj tlen quitoquilíaj inintlamachtil nopa fariseos, pero momomachtijcahua axtle. Nochipa tlacuaj huan atlij. ");
INSERT INTO nheNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Huan Jesús quinilhui: ―Ax quinamiqui ma mosahuaca ihuampoyohua se mosihuajtijquetl ipan nopa tlalochtli quema tlacuaj ihuaya ipan nenamictili. Ihuical eltoc quema na niitztoc ininhuaya nomomachtijcahua, inijuanti ax huelij mosahuaj pampa itztoque nohuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero ajsis tonali quema hualase nocualancaitacahua huan nechhuicase huan huajca quena, nomomachtijcahua mosahuase. ");
INSERT INTO nheNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Huan nojquiya quinpohuili se huicaltili , quinilhui: ―Axaca quitequi se quentzi yoyomitl yancuic para quitlatlamanis se yoyomitl tlen sosoltic pampa tzocoyolihuis nopa quentzi tlen yancuic huan ayoc quinamiquis tlen sosoltic. ");
INSERT INTO nheNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Huan axaca quitequilía xocomeca atl tlen yancuic ipan bolsas tlen cuetlaxtli sosoltic. Pampa nopa yancuic xocomeca atl xocoyas, huan momiyaquilis huan tzayanis nopa cuetlaxtli sosoltic. Quej nopa toyahuis nopa xocomeca atl huan nojquiya quinenpolos nopa bolsas tlen cuetlaxtli. ");
INSERT INTO nheNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Monequi tijtecas xocomeca atl tlen yancuic ipan bolsas tlen cuetlaxtli tlen yancuic. ");
INSERT INTO nheNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Huan axaca tlen quiitoc xocomeca atl tlen achtohui tlasencahuali quinequis tlen yancuic pampa nochi quiijtohuaj: ‘Achi cuali nopa tlen achtohui tlasencahuali.’ ");
INSERT INTO nheNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ipan se sábado, nopa tonal para ma mosehuica israelitame, Jesús huan imomachtijcahua panoyayaj ipan se mili campa quitoctoyaj trigo. Huan imomachtijcahua pejque quiquechcocototzaj, huan quimaoyaj quentzi trigo tlancochtli huan quicuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Huajca nopa fariseos moilhuijque para tlaixpanoyayaj huan quitlajtlanijque Jesús: ―¿Para tlen tequitij momomachtijcahua ipan ni tonal para ma timosehuica? Inijuanti tlajtlacolchihuaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Huan Jesús quinilhui: ―¿Ax inquipojtoque tlen quichijqui David quema yajaya huan ihuampoyohua mayanayayaj? ");
INSERT INTO nheNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Calajqui ichaj Toteco huan quicuic nopa pantzi tlen totajtzitzi quitentoyaj iixtla Toteco. Huan David quicuajqui huan no quinmajmacac nopa tlacame tlen itztoyaj ihuaya. Huan nojquiya quicuajque. Huan itlanahuatil Moisés quiijtohua san totajtzitzi hueli quicuase nopa pantzi. ");
INSERT INTO nheNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Huan nojquiya Jesús quinilhui: ―Na tlen niMocuepqui Tlacatl nijpiya tequihuejcayotl para niquinilhuis tlacame tlaque huelis quichihuase ipan sábado, ni tonal para ma timosehuica tiisraelitame. ");
INSERT INTO nheNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ipan seyoc sábado, nopa tonal para ma mosehuica israelitame, Jesús calajqui ipan se israelita tiopamitl huan pejqui tlamachtía. Huan itztoya tiopan calijtic se tlacatl tlen huactoya ima nejmatl. ");
INSERT INTO nheNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Huan nopa fariseos huan tlamachtiani tlen itlanahuatil Moisés ajachica quitlachiliyayaj intla quichicahuasquía nopa tlacatl ipan ni tonal para ma mosehuica israelitame para quipiyasquíaj ica tlaque quiteilhuisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús quimatqui tlaque moilhuiyayaj huan quiilhui nopa tlacatl tlen mahuactoc: ―Ximoquetza huan xihuala nica tlatlajco tojuanti. Huan yajaya moquetzqui huan yajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Huan Jesús quinilhui nopa fariseos: ―Nimechchihuilis se tlatzintoquili: ¿Tlaque quiijtohuaj nopa tlanahuatili o tlaque quinamiqui para ma tijchihuaca ipan sábado? ¿Ma tijchihuaca tlen cuali o tlen fiero? ¿Ma tiquinmaquixtica tlacame o ma tiquinmictica? ");
INSERT INTO nheNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Huan Jesús quintlachili nopa tlacame tlen quiyahualojtoyaj, pero axaca molini. Huajca Jesús quiilhui nopa tlacatl: ―Xijxitlahua moma. Huan yajaya quixitlajqui ima huan nimantzi mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Huan tlahuel cualanque nopa fariseos huan nimantzi pejque mocamahuíaj tlaque huelis quichihuilise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Huan ipan nopa tonali Jesús yajqui iselti ipan se tepetl huan mocajqui nopona seyohual para momaijtos ica Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Huan quema tlanesqui, quinnotzqui imomachtijcahua ma hualaca campa ya huan quintlapejpeni majtlactli huan ome tlen inijuanti huan quintocajti itlayolmelajcahua. ");
INSERT INTO nheNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Quitlapejpeni Simón tlen nojquiya quitocajti Pedro, huan Andrés tlen eliyaya iicni. Nojquiya quintlapejpeni Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO nheNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo huan Tomás. Quitlapejpeni Jacobo icone Alfeo huan nopa Simón tlen moiyocatlali ica partido cananista. ");
INSERT INTO nheNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Huan quitlapejpeni Judas, iicni Jacobo huan Judas Iscariote tlen teipa quitemactili. ");
INSERT INTO nheNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Huan teipa Jesús temoc ipan tepetl ininhuaya imomachtijcahua, huan moquetzque campa se tlamayamitl. Huan mosentilijque miyac tlacame tlen quitoquiliyayaj. Hualajtoyaj tlen campa hueli pilaltepetzitzi ipan estado Judea, huan ipan altepetl Jerusalén huan tlen tlaltini Tiro huan Sidón nechca hueyi atl. Nochi nopa tlacame hualajtoyaj para quicaquise itlajtol Jesús huan para ma quinchicahua tlen inincocolis. ");
INSERT INTO nheNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Huan nojquiya quinchicajqui tlen quinpixtoyaj ajacame tlen quintlaijiyohuiltiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Huan nochi nopa tlacame quinequiyayaj monechcahuise campa Jesús para quiitzquise, pampa ichicahualis quinajsiyaya tlen quiitzquiyayaj huan quinchicahuayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Huan Jesús quintlachili imomachtijcahua huan quinilhui: “Xipaquica imojuanti tlen inteicneltzitzi, pampa incalaquise campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Xipaquica imojuanti tlen inmayanaj ama, pampa inixhuise. Xipaquica imojuanti tlen inchocaj ama, pampa inhuetzcase. ");
INSERT INTO nheNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Xipaquica quema tlacame inmechcocolíaj huan inmechtotocaj. Xipaquica quema inmechtelchihuaj huan inmechtocajtíaj ax incuajcualme, pampa innechtoquilíaj na tlen niMocuepqui Tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Xipaquica, quena, xijpiyaca hueyi paquilistli quema queja nopa imopantis, pampa Toteco miyac inmechtlaxtlahuis nepa elhuicac. Pampa san se ininhuejcapan tatahua quichihuayayaj huejcajquiya ica itiocamanalojcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero tlahuel inteicneltique imojuanti tlen miyac intominpiyaj, pampa ya inquipiyaj nochi tlen cuali tlen inmechtocaros. ");
INSERT INTO nheNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tlahuel inteicneltique tlen inixhuij ama, pampa teipa inmayanase. Tlahuel inteicneltique tlen inhuetzcaj ama, pampa teipa inchocase huan intlahuejchihuase. ");
INSERT INTO nheNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tlahuel inteicneltique quema nochi tlacame camatij cuali tlen imojuanti. Inintatahua nojquiya camatque cuali tlen nopa istlacatica tiocamanalohuani huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Pero nimechilhuía imojuanti tlen innechtlacaquilíaj: Xiquinicnelica imocualancaitacahua. Xiquinchihuilica tlen cuali inijuanti tlen inmechcocolíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xijtlajtlanica Toteco ma quintiochihua tlen inmechtelchihuaj. Ximomaijtoca ica Toteco para inijuanti tlen inmechtlaijilhuíaj ica tlen fiero. ");
INSERT INTO nheNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Intla se acajya mitzmaquilis ipan mocampa, xijnextili ne seyoc mocampa para nojquiya ma mitzmaquilis nopona. Intla se mitzquixtilis motlaque, xijcahua ma quihuica mocamisa nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Intla se acajya mitztlajtlanía se tlenijqui, xijmaca. Intla se acajya mitzquixtilía se tlenijqui, amo xiquilhui ma mitzcuepili. ");
INSERT INTO nheNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xiquinchihuilica sequinoc queja inquinequij sequinoc ma inmechchihuilica. ");
INSERT INTO nheNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Intla san inquinicnelíaj tlacame tlen inmechicnelíaj, Toteco ax quiita para inquichihuaj tlen cuali. Hasta ax cuajcualme quinicnelíaj tlen nojquiya quinicnelíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Intla san inquinchihuilíaj tlen cuali tlacame tlen inmechchihuilíaj cuali, ax tleno ipati iixtla Toteco. Ax cuajcualme nojquiya ihuical quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Huan intla san inquintlanejtíaj tomi tlacame tlen inquimatij temachtli inmechtlaxtlahuise, ax tleno ipati iixtla Toteco. Ax cuajcualme nojquiya quintlanejtíaj tomi tlen quincuepilise teipa. ");
INSERT INTO nheNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Na nimechilhuía, xiquinicnelica imocualancaitacahua. Xiquinchihuilica nochi tlen cuali. Xiquintlanejtica yonque ax inquimatij intla inmechcuepilise. Huan Toteco hueyi inmechtlaxtlahuis. Huan queja nopa inquichijtose queja quichihua Toteco Tlen Más Quipiya Tlanahuatili pampa yajaya quinchihuilía cuali nochi tlacame, yonque ax cuajcualme o ax motlascamatij. ");
INSERT INTO nheNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Huajca xitetlasojtlaca queja imoTata, Toteco Dios, tetlasojtla. ");
INSERT INTO nheNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Amo xiquintequitlachilica sequinoc campa ax imocuenta, huan sequinoc ax inmechtequitlachilise. Amo xitetlateilhuica, huan sequinoc ax inmechtlateilhuise. Xitetlapojpolhuica, huan sequinoc inmechtlapojpolhuise. ");
INSERT INTO nheNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xitemacaca huan inquiselise. Quena, Toteco inmechmacas miyac intla intemacaj miyac. Yajaya quichihuas queja se cuali tlanamacaquetl tlen quitemas se tlayejyecoli sintli, huan cuali quiayacachos, huan más quitemas hasta motzontis. Monequi imojuanti no xiquinmacaca sequinoc tlen cuali tlayejyecoli, pampa sequinoc inmechchihuilise queja inquinchihuilíaj.” ");
INSERT INTO nheNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Huan Jesús quinilhui se huicaltili: “Se popoyotzi ax hueli quiyacana seyoc tlen popoyotzi pampa nochi ome huetzise tlacoyoc ijtic. ");
INSERT INTO nheNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Se momachtijquetl ax quimati más que itlamachtijca, pero nochi momachtiani tlen tlamimomachtíaj elise queja inintlamachtijca. ");
INSERT INTO nheNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Para tlen inquiitaj nochi piltlajtlacoltzitzi tlen quichihuaj imohuampoyohua huan ax inquimatij para achi más miyac tlajtlacoli inquichihuaj? Eltoc queja tiquita se piltejtzi ipan iixtiyol moicni, pero ax tijmati para ta tijpiya hasta se cuatetomitl moixtiyol ijtic. ");
INSERT INTO nheNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Quejatza huelis tiquilhuis seyoc: ‘Nohuampo, nimitzquixtilis nopa piltejtzi ipan moixtiyol’, quema tijpiya se cuatetomitl moixtiyol ijtic? Tijpiya ome moxayac. Timoilhuía ax cuali tlen yajaya quipiya, pero cuali tlen ta tijpiya. Achtohui ximoquixtili nopa cuatetomitl, huan queja nopa titlachiyas cuali para tijquixtilis nopa piltejtzi tlen quipiya iixtiyol ijtic mohuampo. ");
INSERT INTO nheNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Se cuali cuahuitl temaca itlajca tlen cuali, huan tlen ax cuali, axtle. Niyon se cuahuitl tlen ax cuali ax temaca itlajca tlen cuali. ");
INSERT INTO nheNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Huajca nochi tlacame quiixmatij se cuahuitl ipampa itlajca. Se huitzcuahuitl ax temaca tlen cuali para tijcuase. Huan se sahuamecatl ax temaca xocomecatl. ");
INSERT INTO nheNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ihuical elis nojquiya ica se cuali tlacatl, quisas tlen cuali ipan iyolo. Huan intla ax cuali se tlacatl, quisas tlen ax cuali ipan iyolo. Pampa se tlacatl camati tlen eltoc ipan iyolo huan tlen más moilhuía. ");
INSERT INTO nheNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Para tlen inquiijtohuaj niimoTeco huan ax inquichihuaj tlen nimechilhuía? ");
INSERT INTO nheNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nochi tlen hualahuij campa na huan quicaquij notlajtol huan quichihuaj tlen niquijtohua, itztoque queja ni tlalnamijca tlacatl tlen nimechpohuilis. ");
INSERT INTO nheNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Se tlacatl quinequiyaya quichihuas ichaj huan tlaxajqui huejcatla. Quitzinpehualti ica tetl huan quiquetzqui. Huan teipa huetzqui miyac atl huan tlatemic hasta quiajsic ichaj, pero ax tleno ipantic nopa cali pampa nopa tlacatl quiquetztoya ipan tetl. ");
INSERT INTO nheNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero tlacame tlen quicaquij notlajtol huan ax quichihuaj tlen niquijtohua, quichihuaj quej ni huihui tlacatl. Yajaya quichijqui ichaj ipan tlali huan ax tleno ica quitzinpehualti. Teipa tlatemic, huan nopa atl quiajsic ichaj, huan nimantzi huetzqui huan tlamixolejqui.” ");
INSERT INTO nheNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Huan Jesús tlanqui quinmachtía nochi nopa tlacame huan yajqui altepetl Capernaum. ");
INSERT INTO nheNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Huan nopona itztoya se capitán tlen soldados tlen quipixtoya se itequipanojca tlen quiicneli. Huan itequipanojca mococohuayaya huan ya motlahueltijtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Huan nopa capitán quicajqui para ajsico Jesús, huajca quintitlanqui nopa huehue israelita tlacame ma quitlajtlanitij ma huala quichicahuaqui itequipanojca. ");
INSERT INTO nheNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Huan nopa tlacame yajque campa Jesús huan ica nochi ininyolo quitlajtlanijque ma quichicahuati. Huan quiilhuijque: ―Cuali para tijchihuilis se cualtlacayotl ni capitán, ");
INSERT INTO nheNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","pampa nelía techicnelía tiisraelitame. Huan tlaxtlajqui nopa gastos huan techsencahuili se toisraelita tiopa. ");
INSERT INTO nheNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Huajca Jesús quisqui ininhuaya para yas ichaj nopa capitán. Pero quema monechcahuiyaya, nopa capitán quintitlanqui ihuampoyohua ma quicamahuica Jesús huan ma quiilhuica: ―NoTeco, amo ximocuatotoni más. Nopa capitán quiijtohua para yajaya ax hueyi queja ta huan ax quinamiqui para ticalaquis ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nojquiya yajaya quimati ax quinamiqui mitznechcahuis, niyon mitzcamahuis. Pero yajaya quiijtohua, san xiquijto se tlajtoli huan xijnahuati para mochicahuas itequipanojca huan nimantzi mochicahuas. ");
INSERT INTO nheNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quiijtohua yajaya quimati tlen ta tiquijtos, ya nopa mochihuas, pampa yajaya nojquiya quipiya iteco tlen quinahuatía. Huan nojquiya quinpiya soldados tlen yajaya quinnahuatía. Huan intla yajaya quiilhuis se soldado ma yas nopona, yajaya nimantzi yas. Huan intla quiilhuis seyoc ma huala nica, yajaya nimantzi hualas. Huan intla quiilhuis itequipanojca ma quichihua se tequitl, yajaya quichihuas. Huan nopa capitán quimati ta nojquiya tijpiya san se tequihuejcayotl para nimantzi mochihuas motlajtol. ");
INSERT INTO nheNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Huan quema Jesús quicajqui itlajtol nopa capitán tlen ihuampoyohua quiilhuicoj, quisentlachili. Huan Jesús moicancuepqui huan quinilhui nopa miyac tlacame tlen quitoquiliyayaj: ―Nelía nimechilhuía, ax niquitztoc niyon se israelita tlen nechneltoca nelcuali queja ni capitán tlen seyoc tlali ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Huan ihuampoyohua nopa capitán mocuepque ichaj huan ya mochicajtoya itequipanojca. ");
INSERT INTO nheNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Huan teipa Jesús yohuiyaya se altepetl tlen itoca eliyaya Naín huan imomachtijcahua huan miyac tlacame yohuiyayaj ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Huan quema Jesús monechcahui campa ipuerta nopa altepetl, quisayayaj nepa miyac tlacame huan quiquechpanojtiyohuiyayaj se mijcatzi. Huan nopa mijcatzi eliyaya iyojtzi icone se cahual toahui. ");
INSERT INTO nheNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Huan Jesús quiitac nopa cahual toahui, huan quitlasojtlac huan quiilhui: ―Amo xichoca. ");
INSERT INTO nheNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Huan Jesús yajqui campa nopa mijcatzi huan quiitzqui nopa caja huan inijuanti tlen quihuicayayaj moquetzque. Huan Jesús quiilhui nopa mijcatzi: ―Telpocatl, naja nimitzilhuía, ximehua. ");
INSERT INTO nheNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Huan nopa telpocatl tlen mictoya mosehui huan pejqui camati. Huan Jesús quimactili inana. ");
INSERT INTO nheNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Huan nochi nopa tlacame tlen quiitaque quisentlachilijque, huan pejque quihueyichihuaj Toteco Dios huan quiijtojque: ―Ni Jesús tlen itztoc tohuaya, se hueyi tiocamanalojquetl. Huan nojquiya quiijtojque: ―Toteco Dios hualajtoc para techpalehuis tiisraelitame pampa tiiaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Huan nochi tlacame tlen itztoyaj ipan estado Judea huan ipan sequinoc tlaltini nechca quicajque para Jesús quiyolcuitoya nopa mijcatzi. ");
INSERT INTO nheNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Huan imomachtijcahua Juan tlen tecuaaltiyaya quiilhuijque nochi tlen Jesús quichihuayaya. Huajca Juan quinnotzqui ome imomachtijcahua, ");
INSERT INTO nheNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","huan quintitlanqui ma yaca quitlajtlanitij Jesús intla nelía yajaya nopa Cristo tlen Toteco Dios quiijto hualasquía o monequi noja quichiyase ma huala. ");
INSERT INTO nheNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Huan ajsicoj campa Jesús huan quiilhuijque: ―Juan tlen tecuaaltía techtitlantoc ma timitztlajtlaniquij intla ta tiCristo tlen Toteco quiijto hualasquía o monequi noja tijchiyase ma hualas. ");
INSERT INTO nheNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Huan ipan nopa hora quema imomachtijcahua Juan itztoyaj ihuaya Jesús, yajaya quinchicajqui miyac tlen mococohuayayaj ica miyac tlamantli cocolistli. Quinchihuili ma quisaca iajacahua Axcualtlacatl tlen calactoyaj ipan tlacame huan quintlachiyalti miyac popoyotzitzi. ");
INSERT INTO nheNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Huajca Jesús quinilhui imomachtijcahua Juan: ―Xijyolmelahuatij Juan tlen inquiitztoque huan inquicactoque. Xiquilhuitij inijuanti tlen itztoyaj popoyotzitzi, ama tlachiyaj. Huan tlen itztoyaj metzcuachotique, ama nejnemij cuali. Inijuanti tlen palaniyaya inintlacayo ica nopa cocolistli tlen itoca lepra mochicajtoque, huan inijuanti tlen ax tlacaquiyaya, ama tlacaquijya. Tlacame tlen mictoyaj moyolcuitoquejya huan tlen teicneltzitzi quicaquij itlajtol Toteco pampa niquinixtomilía. ");
INSERT INTO nheNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Xiquilhuitij para paquij nopa tlacame tlen nechselíaj huan nechneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Huajca quistejque nopa tlacame tlen quintitlantoya Juan tlen tecuaaltía. Huan teipa Jesús pejqui quincamahuía nopa miyac tlacame tlen Juan. Huan quintlajtlani: “¿Tlaque inmoilhuiyayaj inquiitasquíaj quema inyajque inquiitatoj Juan ipan nopa huactoc tlali campa ax tleno eli? ¿Inmoilhuiyayaj Juan elisquía se tlacatl tlen ax temachtli queja se ohua cuahuitl tlen huihuixca quema quentzi tlaajaca? ");
INSERT INTO nheNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¡Ximoilhuica! ¿Tlaque inmochiyayayaj inquiitase? ¿Inquichiyayayaj para Juan elisquía se tlacatl ica iyoyo nelcuali? ¡Axtle! Ya inquimatij tlacame tlen motlalilíaj ininyoyo nelcuali, tominpíaj huan itztoque ipan ininchaj tlanahuatiani. ");
INSERT INTO nheNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Huajca, ¿tlaque inyajque inquiitatoj? ¿inyajque pampa inquiitasnequiyayaj se itiocamanalojca Toteco? Huan nimechilhuía Juan itztoc más hueyi que nochi sequinoc tiocamanalohuani, ");
INSERT INTO nheNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","pampa ipan Itlajtol Toteco ijcuilijtoc tlen Toteco Dios nechilhui tlen Juan huan queja ni quiijto: ‘Xiquita, na nijtitlanis notlayolmelajca ma mitzyacanas. Yajaya quicualtlalis ininyolo tlacame para ma mitzselise.’ ");
INSERT INTO nheNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Huan nimechilhuía axaca seyoc tlen tlacajtoc ipan ni tlaltepactli itztoc más hueyi iixtla Toteco que Juan tlen tecuaaltía, pero aqui hueli tlacatl tlen itztoc ipan itlanahuatilis Toteco elis más hueyi que Juan.” ");
INSERT INTO nheNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Huan quema nochi nopa miyac tlacame huan nopa tlacame tlen tlainanque impuesto quicajque itlajtol Juan, quinejque ma quincuaalti pampa quiitztoyaj para xitlahuac tlen Juan quiijto tlen Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero nopa fariseos huan tlamachtiani tlen itlanahuatilhua Moisés ax quicualcajque tlen Toteco quinequiyaya ma quichihuaca, huan san mohueyimatiyayaj, huan yeca Juan ax quincuaaltijtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Huan sampa Jesús quinilhui: “¿Ica tlaque niquinhuicalotis tlacame tlen ama itztoque? ");
INSERT INTO nheNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tlen ama itztoque mochihuaj queja coneme tlen mosehuíaj tianquis huan ax paquij pampa nochi ax pano queja quinequij ma pano. Quinnotzaj ininhuampoyohua huan quinilhuíaj: ‘Titlapitzque para ximijtotica, huan ax inmijtotijque. Tihuicaque se huicatl tlen cuesoli quej se mictoya, pero ax inchocaque.’ ");
INSERT INTO nheNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Juan tlen tecuaaltiyaya hualajqui huan ax quicuajqui pantzi huan ax quiic xocomeca atl, huan inquiijtojque para quipixtoya se iajaca Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Huan na tlen niMocuepqui Tlacatl nihualajqui huan nijcua huan niqui tlen onca, huan inquiijtohuaj nineltlacuajquetl huan nineltlaiquetl. Inquiijtohuaj san ninemi ininhuaya tlacajcayahuani tlen tlainamaj impuesto huan tlacame tlen hueyi tlajtlacoli quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ax ipati tlen inquiijtohuaj. Nochi tlacame tlen tlalnamictoque quimachilíaj na ihuaya Juan tijchihuaj tlen xitlahuac.” ");
INSERT INTO nheNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Monechcahui se fariseo campa Jesús huan quitlajtlani ma tlacuati ichaj. Yeca Jesús yajqui ichaj huan mosehui campa mesa. ");
INSERT INTO nheNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Huan ajsico se sihuatl tlen tlacanenqui tlen nojquiya ehuayaya nopa altepetl. Huan quicajqui para Jesús tlacuayaya ipan ichaj nopa fariseo huan quihualicac se ajhuiyacayotl ipan se frasco tlen quicoyonijtoyaj tlen se tetl itoca alabastro. ");
INSERT INTO nheNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Huan moquetzqui chocayaya iicxiteno Jesús. Huan pejqui quixolonía iicxi ica iixayo tlen huetziyaya. Huan quihuatzayaya ica itzoncal. Quitzoponili iicxi huan quitequili nopa ajhuiyacayotl tlen quihualicac. ");
INSERT INTO nheNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Huan nopa fariseo tlen quinotzqui ma tlacuati ichaj quiitac nochi ya ni huan moilhui: “Intla ni Jesús nelía elisquía se itiocamanalojca Toteco, quimatisquía para ax cuali ni sihuatl tlen quiitzquía iicxi. Quimatisquía miyac tlajtlacolchijtoc.” ");
INSERT INTO nheNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Huan yeca Jesús quinanquili tlen Simón moyolilhuiyaya huan quiilhui: ―Simón, nijpiya se huicaltili tlen nijnequi nimitzilhuis. Huan Simón quiilhui: ―Cualtitoc, Tlamachtijquetl, xinechilhui. ");
INSERT INTO nheNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Huan Jesús quiilhui: ―Itztoya se tlacatl tlen momatqui tetlanejtía tomi. Huan ome tlacame quitlahuiquiliyayaj. Se quitlahuiquiliyaya tomi para san cincuenta tonali tlen tequitl, pero nopa seyoc quitlahuiquiliyaya tomi para quinientos tonali. ");
INSERT INTO nheNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Huan nopa ome ax huelque quicuepilíaj nopa tomi. Huajca nopa tecojtli ica ipaquilis quintlapojpolhui tlen sesen quitlahuiquiliyayaj. Huan quiijto ax tleno monequi quitlaxtlahuise. Huajca Simón, ¿catlía tlen ni ome tlacame achi más quiicneliyaya nopa tecojtli? ");
INSERT INTO nheNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Huan Simón quinanquili: ―Huelis yajaya tlen más quitlahuiquiliyaya. Huan Jesús quiilhui Simón: ―Quena, melahuac tlen tiquijto. ");
INSERT INTO nheNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Huan Jesús quitlachili nopa sihuatl huan quiilhui Simón: ―¿Ta tiquita tlen quichihua ni sihuatl? Quema nicalajqui ipan mochaj, ax tinechmacac atl para nimoicxipajpacas queja ipa tijchihuaj, pero yajaya nechxolonili noicxihua ica iixayo huan quihuatzqui ica itzoncal. ");
INSERT INTO nheNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ta ax tinechtzoponi queja timomajtoque titeselíaj, pero hasta quema nicalaquico, yajaya ax quicajtoc nechtzoponilía noicxihua. ");
INSERT INTO nheNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ta ax tinechtequili aceite ipan notzonteco queja timomajtoque, pero yajaya quitequili ajhuiyacayotl hasta ipan noicxihua. ");
INSERT INTO nheNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Yeca nimitzilhuía, yonque miyac itlajtlacolhua, nochi nijtlapojpolhuijtoc, huajca ama miyac nechicnelía. Pero seyoc tlen quipanti tlapojpolhuili ica san pilquentzi tlen tlahuicayaya, san pilquentzi quiicnelía yajaya tlen quitlapojpolhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Huan Jesús quiilhui nopa sihuatl: ―Nimitztlapojpolhuijtoc nochi motlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Huan tlacame tlen mosehuiyayaj ipan mesa ihuaya Jesús pejque moilhuíaj: ―¿Ajqueya nelía ni tlacatl Jesús tlen moilhuía quipiya tequihuejcayotl para tetlapojpolhuis inintlajtlacolhua? ");
INSERT INTO nheNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Huan Jesús quiilhui nopa sihuatl: ―Pampa tinechneltocac, nimitzmaquixtijtoc tlen motlajtlacolhua. Hueli tiyas mochaj ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Teipa Jesús nejnemiyaya campa hueli ipan altepetini huan ranchos tlayolmelajtinemiyaya itlajtol Toteco huan tenotzayaya ma calaquica ipan itlanahuatilis Toteco. Huan nopa majtlactli huan ome imomachtijcahua yohuiyayaj ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Huan nojquiya nemiyayaj ininhuaya Jesús sequin sihuame tlen achtohui mococohuayayaj huan sequin tlen quipiyayaya iajacahua Axcualtlacatl, huan quinchicajtoya. Se tlen nopa sihuame tlen nejnenqui ihuaya Jesús itoca eliyaya María Magdalena. Achtohuiya quinpixtoya chicome iajacahua Axcualtlacatl huan Jesús quinquixti. ");
INSERT INTO nheNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Huan seyoc sihuatl itoca eliyaya Juana. Yajaya elqui isihua Chuza tlen quitequipano Tlanahuatijquetl Herodes. Huan nojquiya nejnenqui ininhuaya se sihuatl itoca eliyaya Susana, huan miyac más sihuame tlen quimacayayaj inintomi para quipalehuise Jesús ica tlen monequiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Huan mosentilijque miyac tlacame tlen ehuaj campa hueli altepetini para quiitase Jesús. Huan yajaya quincamahui ica se huicaltili huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Se tlacatl quisemanato xinachtli huan quema quisemanayaya, sequin xinachtli huetzqui ojtipa. Huan tlacame ipan moquejquetzque huan totome quitlamicuajque. ");
INSERT INTO nheNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sequinoc xinachtli huetzqui temajcajya campa ax onca miyac tlali. Nopa xinachtli ixhuac, pero nimantzi huajqui pampa ax quiajsiyaya atl. ");
INSERT INTO nheNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Huan sequinoc xinachtli huetzqui huitzijtic, huan nopa huitztli moscalti ihuaya huan quiijiyomicti. ");
INSERT INTO nheNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Sequinoc xinachtli huetzqui ipan cuali tlali, huan moscalti huan temacac cien hueltas más tlen quitoctoya.” Huan quema Jesús tlantoya quinilhuía ni huicaltili, achi chicahuac quinilhui: “Nochi inquipiyaj imonacas, huajca xijcaquica tlen nimechilhuía.” ");
INSERT INTO nheNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Huan imomachtijcahua Jesús quitlajtlanijque tlaque quiijtosnequi nopa huicaltili. ");
INSERT INTO nheNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Huan Jesús quinnanquili: “Toteco inmechcahuilijtoc xijmachilica queja yajaya tlanahuatía. Achtohuiya axaca quimatiyaya ya ni huan ama noja ax quincahuilía ne sequinoc ma quimachilica. Yeca niquincamahuía ica huicaltili para yonque inijuanti quiitaj tlen nijchihua, mochihuase queja ax tleno quiitaj. Huan inijuanti yonque quicaquij notlajtol, ax hueli quimachilíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Ya ni tlen quiijtosnequi ne huicaltili tlen nopa tlacatl tlen quisemanato xinachtli. Nopa xinachtli quiijtosnequi itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Sequin tlacame itztoque queja nopa xinachtli tlen huetzqui ojtipa. Inijuanti quicaquij itlajtol Toteco, huan nimantzi Axcualtlacatl huala huan quinquixtilía itlajtol Toteco tlen eltoc ipan ininyolo para ma ax quineltocaca huan ma ax momaquixtica tlen inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Sequinoc itztoque queja nopa xinachtli tlen huetzqui temajcajya. Inijuanti quicaquij itlajtol Toteco huan quiselíaj ica paquilistli. Pero itztoque queja nopa xinachtli tlen ax hueli motlatzquilía campa temajcajya. Nopa tlacame san quineltocaj itlajtol para se tlalochtli. Huan quema huala tlaohuijcayotl, nimantzi quicajtehuaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui campa huitztli. Quicaquij itlajtol Toteco, pero mojmostla ipan ininnemilis motequipachohuaj miyac, huan quinequij moricojchihuase ipan ni tlaltepactli huan quinequij quipiyase nochi tlen quinyolpactía. Huan nochi ni tlamantli quiijiyomictía itlajtol Toteco para ax hueli moscaltía cuali huan quipiyas itlajca. ");
INSERT INTO nheNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Pero sequinoc tlacame itztoque queja nopa xinachtli tlen huetzqui ipan cuali tlali. Nopa tlacame quicaquij itlajtol Toteco huan ica paquilistli quiselíaj ica nochi ininyolo. Quiicnelíaj itlajtol huan mojmostla quitoquilijtinemij tlen quiijtohua. Inijuanti, quena, quipiyaj inintlajca. ");
INSERT INTO nheNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Axaca quitlatía se tlahuili huan quitlalis cajontzala o tlapechtzala. ¡Axtle! Intla se acajya quitlatis se tlahuili, quitlalía ipan se tlahuil quetzali para nochi tlen calaquise nopona huelis tlachiyase. ");
INSERT INTO nheNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Quej nopa ica notlajtol. Nochi tlen motlatijtoc ama, nempa nesis teipa. Huan nochi tlen eltoc ixtacatzi ama, nochi quimatise huan cuali quimachilise teipa. ");
INSERT INTO nheNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Huajca xijpiyaca cuidado quejatza inquicaquij notlajtol, pampa nochi tlacame tlen quimachilíaj, Toteco quinpalehuis para ma quimachilica más. Huan ica tlen ax quimachilíaj, hualas se tlen quinquixtilis tlen quentzi inijuanti moilhuiyayaj quimachiliyayaj.” ");
INSERT INTO nheNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Huan hualajque inana huan iicnihua Jesús huan ax huelque monechcahuíaj campa itztoya pampa nelmiyac tlacame quiyahualojtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Huan hualajqui se tlacatl huan quiilhui Jesús: ―Monana huan moicnihua mitzchiyaj calteno huan quinequij mitzcamahuise. ");
INSERT INTO nheNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Huan Jesús tlananquili: ―Ni tlacame tlen itztoque nicani tlen quicaquij itlajtol Toteco huan quichihuaj tlen quiijtohua, inijuanti niquinita queja nonana huan noicnihua. ");
INSERT INTO nheNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Se tonal Jesús huan imomachtijcahua tlejcoque ipan se cuacanahua, huan Jesús quinilhui: ―Ma tiyaca hasta ne seyoc nali hueyi atl. Huan yeca quisque. ");
INSERT INTO nheNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Huan imomachtijcahua quinejnemiltiyayaj nopa cuacanahua para seyoc nali, huan Jesús cochqui. Huan nimantzi pejqui tlaajaca chicahuac ipan hueyi atl, huan calaquiyaya atl ipan cuacanahua hasta san quentzi misahuisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Huan imomachtijcahua hualajque campa Jesús, quiixitijque, huan quiilhuijque: ―Tlamachtijquetl, xiquita, timisahuijtinemij. Huajca Jesús mejqui huan quiajhuac ne ajacatl huan ne hueyi atl. Huan nimantzi moquetzqui huan ayoc mojmolini. ");
INSERT INTO nheNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Huan Jesús quinilhui imomachtijcahua: ―¿Para tlen nelquentzi innechneltoquilíaj? Huan imomachtijcahua momajmatiyayaj, huan quisentlachilijque huan moilhuijque se ica seyoc: ―¿Ajqueya nelía ni tlacatl Jesús? Yajaya hueli quinnahuatía ajacatl huan hueyi atl, huan inijuanti quineltoquilíaj itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Huan teipa Jesús huan imomachtijcahua ajsique tlali Gadara ipan inincuacanahua. Gadara mocahua iixmelac estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Huan quema inincuacanahua ajsiyaya ateno, hualajqui quinnamiquico se tlacatl tlen ehuayaya nopa altepetl tlen ya huejcajtoya quinpixtoya iajacahua Axcualtlacatl ipan itlacayo. Huan ax tleno moquentiyaya huan ax mocahuayaya ichaj. Senitztoya ipan campo santo ipan tlacacahuaya campa quintlalíaj mijcatzitzi. ");
INSERT INTO nheNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Huan quema quiitac Jesús, motlancuaquetzqui iixtla huan quiijto chicahuac: ―¿Tlaque nijpiya mohuaya? TiJesús. TiIcone Dios Tlen Más Quipiya Tlanahuatili. Nimitztlajtlanía, amo xitechtlaijiyohuilti. ");
INSERT INTO nheNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Quiijto ni pampa Jesús quinnahuatiyaya nopa ajacame ma quisaca ipan nopa tlacatl. Ajachica nopa ajacame quiitzquiyayaj para tlen hueli quichihuilise. Huan yonque tlacame quiilpiyayaj ima huan iicxihua ica tepos cadena para quimocuitlahuisquíaj, san quicocototzayaya nochi tepos cadena. Huan nopa ajacame quinejnemiltiyayaj hasta campa nopa tlahuel huactoc tlali campa ax tleno eli. ");
INSERT INTO nheNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Huan Jesús quitlajtlani: ―¿Tlaque motoca? Huan yajaya quinanquili: ―Notoca Miyac. Queja ni quiijto pampa miyac ajacame calactoyaj ipan itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Huan nopa ajacame quitlajtlanijque Jesús ma ax quintitlani ipan nopa tlalcoyoctli tlen tlahuel huejcatla. ");
INSERT INTO nheNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Huan nopona nechcatzi itztoyaj miyac pitzome tlen tlacame quinhualicaque para ma tlacuajtinemica. Huan yeca nopa ajacame quitlajtlanijque Jesús ma quincahuili calaquise ipan nopa pitzome. Huan yajaya quincahuili. ");
INSERT INTO nheNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Huan nopa ajacame quisque ipan nopa tlacatl huan calajque ipan pitzome. Huan nochi nopa miyac pitzome motlalojtejque campa tlaixtemolis huan huetzque ipan nopa hueyi atl huan misahuijque. ");
INSERT INTO nheNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Huan nopa tlacame tlen quinmocuitlahuiyayaj nopa pitzome quiitaque tlen panoc, huan yajque huan quinyolmelahuatoj nochi tlacame ipan nopa altepetl huan campa hueli ipan nopa tlali. ");
INSERT INTO nheNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Huan nochi nopa tlacame hualajque quiitacoj tlen panotoya. Huan quema ajsicoj campa Jesús, quiitaque nopa tlacatl tlen achtohui quinpixtoya iajacahua Axcualtlacatl ama mosehuijtoya iixtla Jesús. Ya moquentijtoya iyoyo huan quipixtoya cuali itlalnamiquilis. Huan nopa tlacame momajmatijque, ");
INSERT INTO nheNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ica tlen quiitztoyaj. Huan inijuanti tlen quiitaque quinpohuilijque tlen ajsiyayaj quejatza Jesús quichicajtoya nopa tlacatl tlen quinpixtoya ajacame. ");
INSERT INTO nheNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Huan yeca nochi nopa miyac tlacame tlen ejque ipan tlali Gadara huan nopona nechcatzi quitlajtlanicoj Jesús ma quisa inintlal, pampa nelía momajmatijque. Huajca Jesús tlejcoc ipan cuacanahua para mocuepas. ");
INSERT INTO nheNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Huan nopa tlacatl tlen achtohui quinpixtoya ajacame, quitlajtlani Jesús ica nochi iyolo ma quicahuili ma yohui ihuaya, pero Jesús ax quicahuili. San quiilhui: ");
INSERT INTO nheNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ximocuepa mochaj huan xiquinilhuiti tlacame nochi ni hueyi tlamantli tlen Toteco mitzchihuilijtoc. Huan quistejqui nopa tlacatl huan ipan nochi nopa altepetl quinpohuiliyaya nochi tlacame tlen Jesús quichihuilijtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Quema Jesús mocuepqui seyoc nali nopa hueyi atl, miyac tlacame quiselijque ica paquilistli pampa quichiyayayaj ma ajsi. ");
INSERT INTO nheNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Huan hualajqui se tlacatl tlen itoca eliyaya Jairo, se tequihue tlen israelita tiopamitl. Huan yajaya motlancuaquetzqui iicxiteno Jesús huan chicahuac quitlajtlani ma yahui ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Quipixtoya se isihuapil, huan yajaya quipixqui majtlactli huan ome xihuitl huan tlahuel mococohuayaya. Huan quema Jesús itztoya ipan ojtli para ichaj, miyac tlacame quicuatetzopayayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Huan itztoya nopona se sihuatl tlen quipixtoya se cocolistli para majtlactli huan ome xihuitl. Mojmostla esotemoyaya. Huan quitlamiltijtoya nochi tlen quipixtoya ica tepajtiani huan niyon se ax huelqui quipalehui para ma mochicahua. ");
INSERT INTO nheNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Huan nopa sihuatl monechcahui iica Jesús huan quitoxonqui iyoyo itenhuaxo huan nimantzi mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Huan Jesús quiijto: ―¿Ajqueya quitoxonqui noyoyo? Huan nochi tlacame quiijtohuayayaj para ax quichijtoyaj. Huan Pedro quiilhui Jesús: ―Tlamachtijquetl, nochi ni miyac tlacame tlen mitzyahualohuaj mitzcuatetzopaj. ");
INSERT INTO nheNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero Jesús quiijto: ―Se acajya nechitzqui pampa nijmachili se mochicajqui ica nochicahualis. ");
INSERT INTO nheNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Huan quema nopa sihuatl quimatqui para Jesús quimatiyaya tlen panoc, hualajqui huihuipicayaya huan motlancuaquetzqui iixtla Jesús. Huan iniixtla nochi nopa tlacame quipohuili Jesús para tlen quitoxonqui iyoyo huan quiilhui para nimantzi mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Huan Jesús quiilhui: ―Nane, ya timochicajtoc pampa tinechneltoquili. Xiya ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Huan quema noja camatiyaya Jesús, ajsico se tlatequipanojquetl tlen hualayaya ichaj nopa tequihue tlen tiopamitl, huan quiilhui: ―Mosihuapil ya mijqui. Ayoc xijcuatotoni ni tlamachtijquetl. ");
INSERT INTO nheNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero Jesús quicajqui tlen nopa tlatequipanojquetl quiijto huan quiilhui nopa tequihue: ―Amo ximajmahui, san xinechneltoca huan mosihuapil mochicahuas. ");
INSERT INTO nheNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Huan quema nochi inijuanti ajsitoj ichaj, Jesús san quincahuili Juan, Pedro, Jacobo huan inana huan itata nopa sihuapil ma itztoca calijtic ihuaya, pero sequinoc ax quincahuili ma panoca. ");
INSERT INTO nheNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Huan nochi chocayayaj huan tlahuejchihuayayaj pampa ya mictoya nopa sihuapil, pero Jesús quinilhui: ―Ayoc xichocaca. Pampa ax mictoc, san cochtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Huan nopa tlacame pejque quihuetzquilíaj pampa quimatque para ya mictoya. ");
INSERT INTO nheNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Pero Jesús quimaitzqui nopa sihuapil huan quiilhui: ―Sihuapil, ximehua. ");
INSERT INTO nheNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Huan itonal mocuepqui ipan itlacayo huan nopa sihuapil mejtiquisqui. Huan Jesús quinnahuati ma quitlamacaca. ");
INSERT INTO nheNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Huan inana huan itata nelía quisentlachilijque, pero Jesús quinilhui axaca ma quiilhuica tlen panotoc. ");
INSERT INTO nheNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús quinnotzqui nopa majtlactli huan ome imomachtijcahua ma mosentilica. Huan quinmacac chicahualistli huan tequihuejcayotl para quinquixtise ajacame ipan tlacame huan para quinchicahuase cocoyani ica tlen hueli cocolistli. ");
INSERT INTO nheNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Teipa quintitlanqui ma quinchicahuaca tlen mococohuaj huan ma teyolmelahuacaj quejatza tlanahuatía Toteco ipan ininyolo tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Quinilhui: ―Amo tleno xijhuicaca ipan ojtli. Amo xijhuicaca cuatopili, niyon yoyoncoxtali, niyon pantzi, niyon tomi. Huan amo xijhuicaca yoyomitl tlen ica inmopatlase. ");
INSERT INTO nheNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Huan quema incalaquise ipan se cali para inmocahuase, ximocahuaca nepa hasta inquisase tlen nopa altepetl. ");
INSERT INTO nheNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Huan intla inyase ipan se rancho campa tlacame ax inmechselise, huajca quema inquisase nepa, ximotecactzejtzeloca para inquiquixtilise nopa tlalpotectli. Huan ica nopa inquinnextilise inquintlahuelcahuaj nopa pilaltepetzi ehuani para ma quiselica se hueyi tlatzacuiltilistli. ");
INSERT INTO nheNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Huajca imomachtijcahua Jesús quisque huan nejnenque campa hueli ipan nochi ranchos. Huan tlayolmelahuayayaj itlajtol Toteco huan quejatza Toteco temaquixtía tlen inintlajtlacolhua. Huan campa hueli quinchicahuayayaj tlacame tlen mococohuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nopa Gobernador Herodes Ántipas quicajqui nochi tlen Jesús quichihuayaya huan ax quimatiyaya tlaque moilhuis pampa sequin quiijtohuayayaj Jesús elqui Juan tlen achtohui tecuaaltiyaya pero ama moyolcuitoya. ");
INSERT INTO nheNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Huan sequinoc quiijtohuayayaj sampa monextijtoya nopa tiocamalojquetl Elías tlen huejcajquiya. Huan sequinoc quiijtohuayayaj moyolcuitoya se tlen nopa tiocamanalojquetl tlen huejcajquiya mijqui. ");
INSERT INTO nheNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero Herodes quiijto: ―Juan ya mictoc pampa nitlanahuati ma quiquechtzontequica, pero ¿ajqueya ni tlacatl tlen ama nijcaqui quichijtinemi huejhueyi tiochicahual nescayotl? Huan Herodes quitemohuayaya quejatza huelis quiitas Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Huan mocuepque itlayolmelajcahua Jesús huan quipohuilijque nochi tlen quichijtoyaj huan campa yajtoyaj. Huan Jesús quiniyocaquixti itlayolmelajcahua tlen nopa miyac tlacame huan quinhuicac hasta huactoc tlali nechca altepetl Betsaida. ");
INSERT INTO nheNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero nopa miyac tlacame quimatque canque yohuiyayaj huan quintoquilijque. Huan Jesús quinseli ica cuali huan quinilhui quejatza tlanahuatía Toteco ipan teyolo. Huan Jesús quinchicajqui tlen mococohuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Huan ica tiotlac monechcahuijque itlayolmelajcahua Jesús huan quiilhuijque: ―Xiquintitlani ni tlacame ma yaca ipan ranchos nechca quitemotij campa cochise huan tlen quicuase pampa nica campa tiitztoque ax tleno onca. ");
INSERT INTO nheNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús quinilhui: ―Imojuanti xiquintlamacaca. Huan imomachtijcahua quiilhuijque: ―San tijpiyaj macuili pantzi huan ome michime, o ¿tijnequi ma tijcohuatij tlen quicuase nochi ni tlacame? ");
INSERT INTO nheNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Itztoyaj nepa nechca macuili mil tlacame. Huan Jesús quinilhui imomachtijcahua: ―Xiquinilhuitij ni tlacame ma mosehuica ica pamitl, ica cincuenta ipan sesen pamitl. ");
INSERT INTO nheNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Huan imomachtijcahua quinilhuijque huan nopa tlacame queja nopa mosehuijque. ");
INSERT INTO nheNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Huan Jesús quicuic nopa macuili pantzi huan nopa ome michime, huan tlachixqui elhuicac huan quitlascamatqui iTata. Teipa quintlajcotlapanqui huan pejqui quinmajmaca imomachtijcahua ma quinmajmacaca nopa miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Huan nochi nopa miyac tlacame tlacuajque huan cuali ixhuique. Huan quisentilijque nochi panpayaxtli tlen mocajtoya huan quitemitijque majtlactli huan ome chiquihuitl. ");
INSERT INTO nheNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Se tonal Jesús huan imomachtijcahua moiyocaquixtijtoyaj, huan Jesús yajqui momaijtoto iselti. Huan teipa mocuepqui campa imomachtijcahua huan quintlajtlani: ―¿Ajqueya quiijtohuaj tlacame para naja? ");
INSERT INTO nheNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Huan imomachtijcahua quiilhuijque: ―Sequin quiijtohuaj ta tiJuan tlen tecuaaltiyaya, pero sequinoc quiijtohuaj ta tiElías. Huan sequinoc quiijtohuaj ta tieli se tiocamanalojquetl tlen huejcajquiya itztoya huan ama timoyolcuitoc. ");
INSERT INTO nheNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Huan Jesús quintlajtlani: ―Huan, ¿imojuanti? ¿Ajqueya inmoilhuíaj para na? Huan Pedro quinanquili: ―Ta tiCristo tlen Toteco Dios techilhui techtitlanilisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Huan Jesús quinnahuati ma axaca quipohuilica, ");
INSERT INTO nheNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","huan quinilhui: ―Monequi para na tlen niMocuepqui Tlacatl nitlaijiyohuis miyac. Ax nechselise nopa tlayacanani tlen tiopanpiyani, huan nopa tlamachtiani tlen itlanahuatil Moisés huan nopa huehue tlacame tlen tlali Israel. Huan tlacame nechmictise, pero ica eyi tonali nimoyolcuis sampa. ");
INSERT INTO nheNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Huan nojquiya quinilhui: ―Intla se quinequi nechtoquilis, monequi quiilcahuas tlen ya quinequi huan nechtoquilis mojmostla mocualtlalijtoc para tlaijiyohuis huan miquis pampa nechneltoca. Monequi elis queja se tlacatl tlen quihuica icuamapel para ipan miquis. ");
INSERT INTO nheNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pampa tlen quinequi momanahuis huan ax quinequi tlaijiyohuis pampa nechneltoca, quema miquis quipolos nochi. Pero intla se tlaijiyohuis o miquis pampa nechneltoca, momaquixtis itonal huan itztos nepa elhuicac para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Huan ax ipati yonque se tlacatl quipiyasquía para iaxca nochi tlen onca ipan ni tlaltepactli, pampa ax tleno huelis quipalehuis quema miquis huan polihuis nepa mictla. ");
INSERT INTO nheNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Intla se tlacatl pinahua nopampa na huan ipampa notlajtol huan quiijtos ax nechixmati, huajca na tlen niMocuepqui Tlacatl nimopinahuas ica ya huan niquijtos ax niquixmati quema nimocuepasanoc ipan tlaltepactli ica notlatlanex huan ica itlatlanex noTata, Toteco Dios huan inintlatlanex nopa tlatzejtzeloltijca elhuicac ehuani. ");
INSERT INTO nheNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pero nimechilhuía, sequin imojuanti nica ax inmiquise hasta inquiitase quejatza elis nepa campa tlanahuatía Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesús quiijto ya ni huan hualchicuextic quinhuicac Juan, Jacobo huan Pedro huan tlejcoque ipan se tepetl para momaijtose. ");
INSERT INTO nheNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Huan quema Jesús momaijtohuayaya, ixayac mopatlac huan iyoyo mocuepqui chipahuac huan cahuaniyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Huan nesque ome tlacame tlen quicamahuiyayaj, huan eliyayaj Moisés huan Elías. ");
INSERT INTO nheNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Huan quinyahualohuayaya se tlatlanextli tlen tlahuel cahuaniyaya, huan quicamahuiyayaj Jesús tlen panosquía ipan altepetl Jerusalén huan quejatza miquisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Achtohui Pedro huan ihuampoyohua tlahuel cochmiquiyayaj, pero teipa cuali tlachixque huan quiitaque itlatlanex Jesús huan nopa ome tlacame tlen moquetzayayaj ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Huan quema nopa ome ya itztoyaj para quisase, Pedro quiilhui Jesús: ―Tlamachtijquetl, cuali tiitztose nicani. Ma tijchihuaca eyi pilxajcaltzitzi. Se para ta, seyoc para Moisés huan seyoc para Elías. Pero Pedro nelía ax quimatiyaya tlen quiijtohuayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Huan quema Pedro quiijtohuayaya ya ni, temoc se mixtli, huan quintzajqui huan nelía momajmatijque pampa quiitaque temoyaya nopa mixtli ipan inijuanti. ");
INSERT INTO nheNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Huan quicajque se tlen quincamahui ipan nopa mixtli huan quiijto: “Ya ni Nocone tlen niquicnelía. Xijcaquica tlen quiijtohua.” ");
INSERT INTO nheNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Huan quema Toteco Dios tlanqui camati, quiitaque Jesús itztoya iselti. Huan para miyac tonali nopa eyi imomachtijcahua ax tleno quiijtojque huan axaca quiilhuijque tlen quiitztoyaj ipan nopa tepetl. ");
INSERT INTO nheNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Hualtonili Jesús huan nopa eyi imomachtijcahua temoque ipan nopa tepetl huan quinnamijque tlahuel miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Huan camatqui chicahuac se tlacatl tlen itztoya campa nopa miyac tlacame huan quiijto: ―Tlamachtijquetl, xinechchihuili se cualtlacayotl huan xijtlachiliqui nooquichpil pampa piliyojtzi. ");
INSERT INTO nheNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Se iajaca Axcualtlacatl quiitzquía, huan tzajtzi, huan nimantzi quimajcahua ica se ajaca cocolistli. Huan quichihua ma huihuipica chicahuac huan ma camaposoni. Quitlaijiyohuiltía nocone miyac huan ax quema quicahua. ");
INSERT INTO nheNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Huan niquintlajtlani momomachtijcahua ma quiquixtilica huan ax huelque. ");
INSERT INTO nheNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Huan Jesús quinanquili huan quiijto: ―¡Intlacame para tlen ax innechneltocaj! ¿Quesqui tonali monequi nimocahuas imohuaya? ¿Quesqui tonali monequi nimechxicos? Xinechhualiquili mooquichpil. ");
INSERT INTO nheNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huan quema monechcahuiyaya ioquichpil, nopa ajacatl quimajcajqui tlalchi, huan quimacac se ajaca cocolistli huan yajaya pejqui chicahuac huihuipica. Pero Jesús quiajhuac nopa iajaca Axcualtlacatl huan yajaya quisqui huan nimantzi mochicajqui nopa oquichpil huan Jesús sampa quimactili itata. ");
INSERT INTO nheNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Huan nochi san quisentlachiliyayaj quema quiitaque ihueyi chicahualis Toteco. Pero quema nochi noja quisentlachiliyayaj ica tlen Jesús quichijtoya, yajaya quinilhui imomachtijcahua: ");
INSERT INTO nheNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Xijtlacaquilica cuali ni tlajtoli tlen nimechilhuía ama huan amo xiquilcahuaca. Nechtemactilise na tlen niMocuepqui Tlacatl ininmaco ax cuajcualme. ");
INSERT INTO nheNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero imomachtijcahua ax quimachilijque tlen quiijto pampa ax quincahuili ma quimachilica cuali. Huan majmahuiyayaj para quitlajtlanise tlaque quiijtosnequi. ");
INSERT INTO nheNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Huan imomachtijcahua Jesús pejque monajnanquilíaj catlía tlen inijuanti quipiyas más tequihuejcayotl. ");
INSERT INTO nheNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Huan Jesús quimatiyaya tlaque moilhuiyayaj ipan inintlalnamiquilis, huan yeca quihualicac se conetl huan quiquetzqui inechca. ");
INSERT INTO nheNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Huan quinilhui: ―Ajqueya quiselía se conetl queja ni pampa nechneltoca, yajaya nechselía. Huan ajqueya nechselía, nojquiya quiselía noTata tlen nechtitlantoc. Huan aqui hueli tlen imojuanti tlen más moicnonequis, yajaya más quipiyas tequihuejcayotl. ");
INSERT INTO nheNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Huan teipa Juan quiilhui: ―Tlamachtijquetl, tiquitaque se tlen quiijtohuayaya motoca huan quinquixtiliyaya iajacahua Axcualtlacatl ica motoca, huan tiquilhuijque ma ayoc quichihua pampa ax nemi tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús quiilhui: ―Amo xijtzacuilica pampa se tlen ax techcualancaita itztoc tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Huan quema nechca eltoya para Jesús yasquía elhuicac, motemacac para yas Jerusalén huan quistejqui. ");
INSERT INTO nheNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Huan quintitlanqui se ome tlacame ma tlayacanaca para quitemotij campa mocahuasquíaj ipan ojtli. Huan inijuanti calajque se rancho ipan estado Samaría para quisencahuasquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero tlacame tlen nopona ehuani ax quinselijque pampa quimatque Jesús motlalijtoya para yas altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Huan quema quiitaque Juan huan Jacobo para ax quinselijque, quiilhuijque Jesús: ―Toteco, ¿tijnequi ma tijnahuatica tlitl ma huetzi tlen elhuicac queja quichijqui Elías huan ma quintlamitlati ni tlacame? ");
INSERT INTO nheNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Huan Jesús moicancuepqui huan quinajhuac: ―Imojuanti ax inquimachilíaj para elqui se ajacatl tlen inmechchihuili xicualanica. ");
INSERT INTO nheNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Na tlen niMocuepqui Tlacatl nihualajtoc para niquinmaquixtis tlacame. Ax nihualajtoc para niquinxolehuilis ininyolis. Huan nochi inijuanti yajque seyoc rancho. ");
INSERT INTO nheNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Huan quema nochi yohuiyayaj ipan ojtli, se tlacatl quiilhui Jesús: ―Toteco, nimitztoquilis campa hueli tiyas. ");
INSERT INTO nheNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Huan Jesús quiilhui: ―Cayochime quipiyaj ininchaj huan totome quipiyaj inintepasol, pero na tlen niMocuepqui Tlacatl ax cana nijpiya campa nimotzontecas. ");
INSERT INTO nheNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Huan Jesús quiilhui seyoc: ―Xinechtoquili. Pero yajaya quiilhui: ―NoTeco, achtohui xinechcahuili ma nijtlalpachos notata quema miquis. ");
INSERT INTO nheNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero Jesús quiilhui: ―Xiquincahuili inijuanti tlen mictoque iixtla Toteco ma quintlalpachoca ininmijcatzitzi, huan ta xiya huan xiquinyolmelahuati tlacame quejatza Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Huan seyoc tlacatl quiilhui Jesús: ―Nimitztoquilis, noTeco, pero achtohui xinechcahuili niyas niquinnahuatiti tlen itztoque nocalijtic. ");
INSERT INTO nheNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Huan Jesús quiilhui: ―Se tlacatl tlen tlapoxahua ica tlapiyalime huan moicanita quichihua isurco huijcoltic. Huan nojquiya se tlen pehua quitoquilía iojhui Toteco huan ajachica moilhuía tlen quicajtejtoc, ax quinamiqui calaquis campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Huan teipa Jesús quintequimacac seyoc setenta tlacame huan quintitlanqui ma yaca ojome para tlayacanase ipan nochi altepetini huan ranchos campa yajaya ajsisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Huan yajaya quinilhui: “Itztoque miyaqui tlen quichiyaj para quicaquise notlajtol, pero ax miyaqui para yase huan quinilhuitij. Eltoc queja onca se hueyi pixquistli huan san itztoque se o ome tlacame para quisentilise. Xijtlajtlanica Toteco Dios ma quintitlani más tequipanohuani para ma tepohuilica itlajtol pampa nopa pixquistli iaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Imojuanti inelise queja borregojme tlen mopantíaj ica tepechichime ipan nopa tequitl campa nimechtitlanis. ");
INSERT INTO nheNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Amo xijhuicaca se morral, niyon se payo para inmotominpiquise. Amo xijhuicaca seyoc inmotecac huan amo ximoquetztiyaca ipan ojtli para intetlajpalose. ");
INSERT INTO nheNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Huan quema incalaquise ipan se cali, xiquijtoca: ‘Ma Toteco inmechmaca tlasehuilistli nochi tlen initztoque nicani.’ ");
INSERT INTO nheNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Huan intla itztoc nopona tlen quinequi itlasehuilis Toteco, huajca Toteco quitiochihuas huan quimacas tlasehuilistli, huan intla ax quinequi itlasehuilis Toteco ax quitiochihuas. ");
INSERT INTO nheNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Huan ximocahuaca ipan nopa cali campa inmechselíaj, huan xijcuaca huan xiquica tlen inmechmacase pampa quinamiqui se tlatequipanojquetl quiselis itlaxtlahuil tlen itequi. Ximocahuaca ipan san se cali ipan sesen altepetl, huan ax san campa hueli xicochtinemica. ");
INSERT INTO nheNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Huan quema inajsitij ipan se altepetl campa inmechselíaj, xijcuaca tlen inmechmacase. ");
INSERT INTO nheNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Huan xiquinchicahuaca tlen mococohuaj huan xiquinilhuica: ‘Toteco Dios tlen tlanahuatía ipan ininyolo tlacame inmechnechcahuijtoc ama.’ ");
INSERT INTO nheNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Huan quema incalaquise ipan se altepetl huan tlacame nepa ax inmechselise, xiyaca ipan ojtli huan xiquijtoca: ");
INSERT INTO nheNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Nochi ni tlalpotectli tlen imoaltepe tlen tlatzquijtoc ipan totecac tijtzejtzelohuaj para quinextis nopa tlatzacuiltilistli tlen inmechajsis pampa ax inquiselijque. Pero xijmatica para melahuac ama Toteco inmechnechcahuijtoc para inmechnotzas xicalaquica campa yajaya tlanahuatía.’ ");
INSERT INTO nheNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Huan nimechilhuía, quema Toteco tetajtolsencahuas, nopa tlacame ipan nopa altepetl tlen ax inmechselise, quiselise se tlatzacuiltili tlen más hueyi huan amo queja tlen quiselijque tlacame tlen itztoyaj ipan altepetl Sodoma huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Inteicneltijque inCorazín ehuani pampa Toteco inmechtlatzacuiltis. Inteicneltique inBetsaida ehuani, pampa ax innechneltocaque quema nijchijqui huejhueyi chicahual nescayotl imoixtla. Intla nopa tlacame tlen huejcajquiya itztoyaj ipan altepetini Tiro huan Sidón quiitztosquíaj tlen nijchijqui imoixtla, moyolcueptosquíaj nimantzi, huan nochi tlacame quimajtosquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Huajca quema Toteco tetlajtolsencahuas, más chicahuac inmechtlatzacuiltis que nopa ax cuajcualme tlen itztoyaj ipan Tiro huan Sidón huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Imojuanti inCapernaum ehuani inmohueyimatij huan inmoilhuíaj inmotlalanase hasta elhuicac, pero ax neli. Intemose hasta mictla pampa ax inmoyolpatlatoque.” ");
INSERT INTO nheNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Huan Jesús sampa quinilhui imomachtijcahua: “Tlacame tlen quicaquise imotlajtol ica cuali, cuali nechtlacaquilise, huan tlen inmechhuejcamajcahuase, nojquiya nechhuejcamajcahuase huan quihuejcamajcahuase yajaya tlen nechtitlantoc.” ");
INSERT INTO nheNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Huan teipa nopa setenta tlen Jesús quintitlantoya mocuepque ica paquilistli huan quiilhuijque: ―Toteco, hasta iajacahua Axcualtlacatl techneltoquilijque quema tiquinnahuatijque ipan motoca . ");
INSERT INTO nheNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Huan Jesús quinilhui: ―Quena, niquitac Axcualtlacatl huetzqui tlen elhuicac queja quema huetzi se tlixochitl quema tlapetlani. ");
INSERT INTO nheNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xiquitaca, nimechmacatoc tequihuejcayotl para ipan inmoquejquetzase ipan cohuame huan colome, huan para inquitlanise nochi ichicahualis Axcualtlacatl, huan ax tleno huelis inmechchihuilise. ");
INSERT INTO nheNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero amo xipaquica miyac pampa ajacame inmechchihuilíaj imotlajtol. Más xipaquica pampa ya ijcuilijtoc imotoca ipan iama Toteco nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Huan ipan nopa tlalochtli Itonal Toteco quimacac Jesús miyac paquilistli huan Jesús quiilhui ITata: “Nimitzpaquilismaca, Papá, ta tiToteco Dios tlen titlanahuatía ipan elhuicac huan tlaltepactli. Ta Tijtlatijtoc motlalnamiquilis para ma amo quimachilica tlacame tlen mohueyimatij huan tlen moilhuíaj tlalnamiquij. Pero ama tiquinnextilía motlalnamiquilis tlacame tlen moicnonequij queja coneme moixtla. Quena, Papá, queja nopa tijchijqui pampa queja nopa mopaquilis.” ");
INSERT INTO nheNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Huan Jesús quinilhui nopa tlacame: “Notata nechmacatoc tequihuejcayotl ica nochi tlamantli. Axaca cuali nechixmati na tlen niIcone Toteco, san Notata, quena, cuali nechixmati. Huan axaca cuali quiixmati noTata, san na niIcone huan ajqueya nijnequi nijnextilis ajqueya ya.” ");
INSERT INTO nheNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Huan teipa moicancuepqui Jesús huan quintlachili imomachtijcahua huan iyoca quinilhui: “Xijpiyaca miyac paquilistli para inquiitaj tlaque nijchihua queja ama inquiitaj. ");
INSERT INTO nheNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nimechilhuía, miyac tiocamalohuani huan tlanahuatiani tlen huejcajquiya itztoyaj quinequiyaya quiitase tlen ama inquiitaj, pero ax quiitaque. Inijuanti quinequiyayaj quicaquise tlen ama inquicaquij, pero ax huelque.” ");
INSERT INTO nheNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Huan se tlamachtijquetl tlen itlanahualtilhua Moisés moquetzqui para quimasiltis Jesús ica itlajtol huan quitlajtlani: ―Tlamachtijquetl, ¿tlaque monequi nijchihuas para nijselis nopa yolistli yancuic tlen ax quema tlamis? ");
INSERT INTO nheNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Huan Jesús quiilhui: ―¿Tlaque ijcuilijtoc ipan itlanahuatilhua Moisés? ¿Quejatza tijmachilía ta? ");
INSERT INTO nheNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Huan yajaya quinanquili: ―Xiquicneli Toteco Dios ica nochi moyolo, huan ica nochi moyoltzi, huan ica nochi mochicahualis, huan ica nochi motlalnamiquilis. Huan xiquinicneli sequinoc queja timoicnelía. ");
INSERT INTO nheNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Huan Jesús quiilhui: ―Cuali tinechnanquilijtoc. Huajca xijchihua nochi ya ni huan tiitztos. ");
INSERT INTO nheNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero nopa tlacatl quinequiyaya monextis cuali iniixtla nopa tlacame, huajca quitlajtlani Jesús: ―¿Ajqueya inijuanti ne sequinoc tlen monequi niquinicnelis queja nimoicnelía? ");
INSERT INTO nheNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Huan Jesús quinanquili: ―Se tlacatl quisqui altepetl Jerusalén huan temoyaya ipan nopa tlaixtemolis tlen ajsi altepetl Jericó. Huan tlaxtequini quipantijque, huan quiquixtilijque iyoyo huan nochi tlen quipixqui. Huan teipa quihuitejque huan quicajtejque queja mictoc. ");
INSERT INTO nheNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Huan panoc se totajtzi ipan ojtli huan quiitac nopa tlacatl huilantoc, pero quitlalcahui huan ax quichihuili cuenta. ");
INSERT INTO nheNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Huan nojquiya hualajqui se levita tlen tlapalehui ipan israelita tiopamitl. Huan yajaya ajsico campa huilantoya huan quiitac, pero nojquiya san quipanoc huan ax quichihuili cuenta. ");
INSERT INTO nheNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero hualayaya ipan ojtli se Samaría ejquetl , huan ajsico nopona huan quema quiitac nopa tlacatl huilantoc, quitlasojtlac. ");
INSERT INTO nheNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Quinechcahuito huan quipajpaquili campa cocojtoya ica xocomeca atl, huan teipa quitequili aceite. Huan quipijqui ica se yoyomitl. Huan quitlejcolti ipan iburro huan quihuicac ipan se cali campa cochij paxalohuani huan quimocuitlahui. ");
INSERT INTO nheNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Huan itonilijcapa quiquixti tomi para ome tonati tequitl, huan quimacac nopa tlacatl tlen quinmocuitlahuía ajsini huan quiilhui: ‘Xijmocuitlahui ni cocoxquetl huan intla tijyaltis más tomi para tijmocuitlahuis, huajca quema nimocuepas, nimitztlaxtlahuis.’ Huajca Jesús quitlajtlani nopa tlamachtijquetl tlen itlanahuatilhua Moisés: ");
INSERT INTO nheNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","―¿Catlía tlen ni eyi tlacame tlen hualajque ipan ojtli quiicneli tlen huilantoya queja moicnelía? ");
INSERT INTO nheNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Huan nopa tlamachtijquetl tlen itlanahuatilhua Moisés quiijto: ―Yajaya tlen quitlasojtlac. Huan Jesús quiilhui: ―Quena, nelía. Xiya ta huan queja nopa nojquiya xijchihua. ");
INSERT INTO nheNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Teipa Jesús yajqui ipan ojtli hasta se rancho, huan se sihuatl itoca eliyaya Marta quiseli ipan ichaj ica yejyectzi. ");
INSERT INTO nheNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Yajaya quipixtoya se iicni tlen itoca María tlen mosehuico iicxitla Jesús huan quitlacaquiliyaya itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Huan Marta quipixtoya miyac tequitl pampa quinequiyaya quisencahuas miyac tlacualistli para Jesús. Marta quinechcahuico huan quiilhui: ―Toteco, ¿ax tiquita noicni nechcajtejtoc para noselti ma nijsencahua nochi tlen tijcuase? Xiquilhui ma nechpalehuiqui. ");
INSERT INTO nheNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero Tohueyiteco Jesús quinanquili: ―Marta, Marta, timocuesohua huan timocuatotonía ica miyac tlamantli tlen tijchihua, ");
INSERT INTO nheNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","pero san se tlamantli achi más ipati. María quitlapejpenijtoc para quicaquis notlajtol, huan nopa achi cuali, huan axaca huelis quiquixtilis. ");
INSERT INTO nheNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Se tonal Jesús moiyocaquixti huan momaijto campa momatqui yohui huan quema tlanqui, se imomachtijca quinechcahuico huan quiilhui: ―Tohueyiteco, xitechmachti quejatza ma timomaijtoca queja Juan quinmachti imomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Huan Jesús quinilhui: ―Quema inmomaijtose ica Toteco Dios, xiquilhuica: Toteco Totata, ta tlen tiitztoc nepa elhuicac. Nochi tlacame ma mitzhueyichihuaca . Xihuala xitlanahuatiqui nicani. Ma nochi tlacame quichihuaca tlen ta tijnequi nicani ipan ni tlaltepactli, queja nochi quichihuaj mopaquilis nepa elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Xitechmaca nopa tlacualistli tlen monequi mojmostla. ");
INSERT INTO nheNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Huan xitechtlapojpolhui totlajtlacolhua, queja nojquiya tiquintlapojpolhuíaj tlen techixpanoj. Axaca xijcahuili ma techyoltilanas para titlajtlacolchihuase. Xitechmanahui ica nochi tlen ax cuali. ");
INSERT INTO nheNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Huan Jesús quinilhui nojquiya: ―Ximoilhuica intla tlajco yohual se tlen imojuanti yas ichaj se imohuampo huan quiilhuis: ‘Nohuampo, xinechtlanejti se ome pantzi, ");
INSERT INTO nheNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","pampa se nohuampo ajsico huan huejca huala, huan ax tleno nijpiya para nijmacas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Huan huelis mohuampo mitznanquilis nicaltzajtoca huan mitzilhuis: ‘Amo xinechcuatotoni. Ya nimocaltzactoc, huan noconehua ya motectoque nohuaya ipan tlapechtli. Ax hueli nimehuas para nimitzmacas tlen tijnequi.’ ");
INSERT INTO nheNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nimechilhuía, huelis yajaya ax mehuas para mitzmacas tlen tijtlajtlanía pampa tiihuampo, pero intla ax tijcahua tijtlajtlanía tlen tijnequi, yajaya mehuas huan mitzmacas nochi tlen tijtlajtlanía san pampa ayoc quinequis xijcuatotoni más. ");
INSERT INTO nheNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Huajca nimechilhuía, xijtlajtlanica Toteco para tlen inmechpolohua huan yajaya inmechmacas. Xijtemoca tlen inmechpolohua huan inquipantise. Xijnotzaca Toteco huan yajaya inmechcaltlapos. ");
INSERT INTO nheNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pampa nochi tlen tlajtlanij, quiselíaj. Huan nochi tlen quitemohuaj tlen quinpolohua, quipantíaj. Huan nochi tlen quinotzaj Toteco, yajaya quincaltlapohua huan quinmaca tlen quitlajtlaníaj. ");
INSERT INTO nheNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Huan imojuanti tlen inquinpiyaj imoconehua, intla se mocone mitztlajtlanis se pantzi para quicuas, ax tijmacas se tetl. Huan intla mocone mitztlajtlanis se michi para quicuas, ax tijmacas se cohuatl. ");
INSERT INTO nheNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Huan intla mocone mitztlajtlanis se tejquistli, ax tijmacas se colotl ma quicua. ");
INSERT INTO nheNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pampa yonque intlajtlacolchihuani, inquimatij inquinmacase imoconehua tlen cuali. Huajca achi más Totata tlen itztoc elhuicac quimati quinmacas iconehua tlen cuali. Huan yajaya quinmacas Toteco Itonal nochi tlen quitlajtlanise.” ");
INSERT INTO nheNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Huan Jesús quiquixti se iajaca Axcualtlacatl ipan se tlacatl tlen quichijtoyaj ma nonotiya. Huan quisqui nopa ajacatl, huan nopa tlacatl camatqui huan nochi nopa tlacame quisentlachilijque. ");
INSERT INTO nheNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero sequin inijuanti quiijtojque: “Axcualtlacatl, yajaya tlen quinyacana nochi ajacame quimaca chicahualistli ni Jesús para ma quinquixti ajacame.” ");
INSERT INTO nheNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Huan sequinoc tlacame quinequiyayaj quiyejyecose Jesús huan quitlajtlaniyayaj ma quichihua se tlanescayotl tlen huala elhuicac para ma quinnextili ichicahualis. ");
INSERT INTO nheNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Huan Jesús quimatqui inintlalnamiquilis huan quinilhui: “Intla tlacame ipan se tlali motlajcoxelohuaj, huajca ax hueli huejcahuas inintlal. Intla tlacame ipan se cali motlajcoxelohuaj, ax hueli itztose san sejco. ");
INSERT INTO nheNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Huan intla Axcualtlacatl motehuis ica ajacame tlen iaxcahua, ¿quejatza huelis huejcahuas itlanahuatil? Inquiijtohuaj niquinquixtía ajacame ica chicahualistli tlen Axcualtlacatl nechmaca. ");
INSERT INTO nheNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero intla niquinquixtisquía ajacame ica ichicahualis, huajca ¿ica ajqueya ichicahualis quinquixtíaj ajacame nopa tlacame tlen inmechtoquilíaj? Inijuanti nojquiya inmechilhuise para se huihuiyotl tlen inmoilhuíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero xijmachilica, intla yajaya Toteco Dios tlen nechmaca ichicahualis para niquinquixtis ajacame, huajca Toteco tlen tlanahuatía ipan ininyolo tlacame ya ajsico imohuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Intla se tlacatl tlen tetixtoc queja Axcualtlacatl quipiya tepostli huan cuali quimocuitlahuía ichaj, huajca nochi tlen quipiya eltoc temachti imaco pampa axaca huelis quitlacuijcuilis. ");
INSERT INTO nheNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero intla hualasquía seyoc queja na tlen más tetixtoc que ya huan quitlanis. Huajca quena, huelis quicuilis nochi itepos ipan tlen motemachía, huan huelis quihuicas nochi tlen quipixtoya huan quixelos ica sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Tlen ax quinequi nechpalehuis, yajaya nocualancaitacahua. Huan se tlen ax quinsentilía tlacame campa na, quinsemana. ");
INSERT INTO nheNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Quema quisa se ajacatl ipan se tlacatl, nemi ipan huactoc tlali quitemojtinemi campa mosehuis, huan intla ax tleno quipantis, moilhuis: ‘Nimocuepas nochaj ipan nopa tlacatl campa niitztoya.’ ");
INSERT INTO nheNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Huan quema mocuepas, quipantis iyolo nopa tlacatl eltos queja se cali tlen tlaxpantli huan tlen quipiya nochi cuali tlacualtlalili. ");
INSERT INTO nheNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Huajca nopa ajacatl yas huan quinhuicas chicome ajacame tlen más fiero que ya huan nochi nopa ajacame itztotij ipan nopa tlacatl. Huan nopa tlacatl mocahuas más fiero que achtohuiya.” ");
INSERT INTO nheNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Huan quema Jesús tlamachtiyaya ya ni, camatqui se sihuatl tlen itztoya ica nopa miyac tlacame, huan chicahuac quiijto: ―Cuali quipanti nopa sihuatl tlen mitztlacatilti huan mitzchichiti. ");
INSERT INTO nheNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Jesús quinanquili: ―Más cuali quipantíaj nopa tlacame tlen quicaquij itlajtol Toteco huan quineltoquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Huan nopa tlacame pejque momiyaquilíaj huan Jesús quinilhui: ―Intlacame tlen ama initztoque ax incuajcualme. Inquinequij ma nimechchihuili se tlanescayotl para ma nimechnextili ajqueya na. Pero ax nijchihuas. San Jonás eltoc queja se tlanescayotl para imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pampa queja Jonás eltoya se tlanescayotl para tlacame ipan altepetl Nínive huejcajquiya, na tlen niMocuepqui Tlacatl nielis se tlanescayotl para intlacame tlen ama initztoque. ");
INSERT INTO nheNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ipan nopa tonal quema Toteco tetlajtolsencahuas, nopa sihua tlanahuatijquetl tlen Sur moyolcuis huan inmechteilhuis tlen ama initztoque. Yajaya hualajqui tlahuel huejca quema itztoya ipan tlaltepactli pampa quinejqui quicaquis itlalnamiquilis Tlanahuatijquetl Salomón. Pero na más nihueyi que Salomón huan ax innechchihuilíaj cuenta. ");
INSERT INTO nheNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Huan quema Toteco tetlajtolsencahuas, tlacame tlen huejcajquiya itztoyaj ipan altepetl Nínive moyolcuise huan inmechtlateilhuise, pampa inijuanti moyolcuepque quema Jonás quincamahui itlajtol Toteco, pero na más nihueyi que Jonás huan ax innechcaquij. ");
INSERT INTO nheNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Axaca quitlatía se tlahuili huan quitlalía campa ax nesi. Axaca quitlalis cajontzala. Intla se tlacatl quitlatía se tlahuili, quitlalía ipan se tlahuil quetzali para nochi tlen calaquise ma quiitaca. ");
INSERT INTO nheNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Moixtiyol eltoc queja itlahuil motlacayo. Intla cuali moixtiyol, hueli tiquita tlen tijchihua. Pero intla ax cuali moixtiyol, tiitztoc queja se tlen tzactoc iyolo. Ax hueli tijmachilía notlajtol huan motlalnamiquilis mocahua ipan tzintlayohuilotl. ");
INSERT INTO nheNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Huajca ximotlachili tlen tijchihua ica nopa tlahuili tlen tijpiya pampa tijcactoc tlen melahuac. Xijcahua ma mitzyolpatla para ax timocuepas ipan tzintlayohuilotl. ");
INSERT INTO nheNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pero intla nelía senquistoc tijselía notlajtol, huajca nochi motlacayo huan motlalnamiquilis quipiyas tlahuili huan ax oncas tzintlayohuilotl mopan ta. Quena, elis queja se tlahuili tlen mitztlahuilijtos ipan motlalnamiquilis.” ");
INSERT INTO nheNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Huan quema Jesús tlanqui tlamachtía, itztoya nopona se fariseo tlen quinotzqui ma yohui tlacuati ichaj. Huan Jesús yajqui huan mosehui campa mesa. ");
INSERT INTO nheNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Huan nopa fariseo quisentlachili quema Jesús ax momajtequi miyac huelta queja quiijtojque itlanahuatilhua Moisés ma quichihuaca tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero Tohueyiteco quiilhui: ―Infariseos inquipajpacaj imotlacayo, pero imoyolo ax inquipajpacaj. Ipan imoyolo san inmoilhuíaj quejatza intlaxtequise huan tlen ax cuali hueli inquichihuase. ");
INSERT INTO nheNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Inhuihuitique! Toteco quichijqui imotlacayo, pero nojquiya quichijqui imoyolo. ");
INSERT INTO nheNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Xijchijtinemica tlen cuali ica nochi imoyolo huan imoyolo elis senquistoc tlapajpactic. ");
INSERT INTO nheNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Inteicneltijque infariseos! Toteco tlahuel inmechtlatzacuiltis. Inquimacaj Toteco majtlactli por ciento tlen nochi tlen inquipiyaj hasta nopa alojhueno huan ruda huan nochi xihuitini tlen más pilsiltzi ipan imoxochimil, pero ax inquichihuaj tlen xitlahuac huan ax inquichihuilíaj cuenta quejatza Toteco quinicnelía tlacame. Ni tlamantli achi más ipati iixtla Toteco. Huajca monequi xijchihuaca tlen más ipati huan nojquiya amo xijcahuaca xijmacaca Toteco se majtlactli por ciento. ");
INSERT INTO nheNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Inteicneltijque infariseos! Toteco tlahuel inmechtlatzacuiltis. Inmechpactía inmosehuise campa cuali siyaj campa onca más tlatlepanitacayotl ipan tiopamitl. Inmechpactía para tlacame ma inmechtlajpaloca ica cuali ipan tianquis. ");
INSERT INTO nheNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Inteicneltijque infariseos huan intlamachtiani tlen itlanahuatil Moisés! Toteco tlahuel inmechtlatzacuiltis. Initztoque queja nopa mijca tlacoyoctini tlen ax nesi intla mijca campo santo, huan yeca tlacame nemij ipani huan ax quimatij intla ipan moquejquetzaj.” ");
INSERT INTO nheNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Huan se tlacatl tlen tlamachtía tlen quiijtosnequi itlanahuatilhua Moisés quiilhui Jesús: ―Tlamachtijquetl, quema tiquinteilhuía fariseos, nojquiya titechteilhuía tojuanti tlen titlamachtíaj tlen quiijtosnequi itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Huan Jesús quinanquili: ―Nojquiya inteicneltique tlen intlamachtíaj itlanahuatilhua Moisés. Toteco tlahuel inmechtlatzacuiltis. Axaca huelis quitoquilis nochi tlanahuatili tlen inquiijtohuaj monequi quitoquilise. Eltoc queja inquinmamaltíaj tlacame tlen etic, pero ax inquinequij inquinpalehuise ica niyon se imomacpil. ");
INSERT INTO nheNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Inteicneltique! Toteco tlahuel inmechtlatzacuiltis. Inquinchihuilíaj panteones itiocamanalojcahua Toteco para sequinoc ma moilhuica inquintlepanitaj, pero imotatahua quinmictijque, ");
INSERT INTO nheNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","huan inpaquij ica tlen quichijque. Quena, imohuejcapan tatahua quinmictijque huan ama inquinchihuilíaj ininpanteón. ");
INSERT INTO nheNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Yeca Toteco tlen quipiya nochi tlalnamiquistli huejcajquiya quiijto tlen imojuanti: ‘Niquintitlanilis notiocamanalojcahua huan notlayolmelajcahua. Huan sequin quinmictise huan sequinoc quintlaijiyohuiltise.’ ");
INSERT INTO nheNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Huan yeca Toteco inmechita intlacame tlen ama initztoque huan quiijtohua para inquihuicaj tlajtlacoli ipampa inieso nochi nopa tiocamanalohuani tlen tlacame quinmictijque hasta quema pejqui tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Quena, imojuanti san sejco inquihuicaj tlajtlacoli para nochi tlen mijque hasta quema mijqui Abel huan hasta amanoc quema tlacame quimictijque Zacarías tlatlajco tlen nopa tlaixpamitl huan nopa hueyi tiopa. Nochi ni tlajtlacoli inquihuicaj tlen ama initztoque. ");
INSERT INTO nheNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Inteicneltique intlamachtiani tlen itlanahuatilhua Moisés! Toteco tlahuel inmechtlatzacuiltis. Inquintzacuilíaj tlen quinequij quimatise itlalnamiquilis Toteco. Ax inquimachilíaj itlalnamiquilis huan ax inquincahuilíaj ma quimachilica sequinoc tlen quinequij quimachilise.” ");
INSERT INTO nheNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Huan quema Jesús tlanqui quiijto ya ni, nopa fariseos huan tlamachtiani tlen itlanahuatil Moisés tlahuel cualanque ihuaya huan pejque quitlajtlaníaj miyac tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Quitemoliyayaj ma quiijto se tlenijqui tlen ica huelis quiteilhuise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Quema Jesús quiijtohuayaya nochi ni tlajtoli, mosentilijtoyaj miyac miles tlacame huan tlahuel mocuatetzopayayaj. Huan Jesús quincamahui imomachtijcahua iniixtla nopa miyac tlacame huan quinilhui: “Ximotlachilica para ax inquiselise inintlasonejcayo fariseos pampa inijuanti quipiyaj ome ininxayac huan huelis inmechchihuilise nojquiya xijpiyaca ome imoxayac. ");
INSERT INTO nheNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nochi tlen tlacame quichihuaj ixtacatzi ama, teipa monextis. Huan nochi tlen ama ax nesi, teipa nochi quimatise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Huan nochi tlen inquiijtojtoque quema tlayohua, nochi quicaquise tonaya. Huan tlen ixtacatzi inmoilhuijtoque ipan imocalijtic, teipa tlacame moquetzase huejcapa huan chicahuac quiijtose. ");
INSERT INTO nheNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nohuampoyohua ya ni nimechilhuía. Amo xiquinimacasica tlacame. Inijuanti san hueli inmechmictise, pero ax tleno más hueli inmechchihuilise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero nimechilhuis ajqueya monequi xiquiimacasica. Xiquimacasica Toteco, pampa yajaya huelis inmechmictis huan nojquiya quipiya tequihuejcayotl para quititlanis imoalma nepa mictla. Quena, nimechilhuía, yajaya tlen monequi inquimacasise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Yonque quinnamacaj macuili piltototzitzi para ome centavos, Toteco ax quiilcahua niyon se tlen inijuanti. ");
INSERT INTO nheNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Huan ica imojuanti, miyac más Toteco inmechmocuitlahuía hasta quimati quesqui imotzoncal inquipiyaj. Huajca amo ximomajmatica. Achi más imopati iixtla Toteco que miyac totome. ");
INSERT INTO nheNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Huan nimechilhuía, nochi tlacame tlen nechneltocaj huan tepohuilíaj para nechneltocaj, na tlen niMocuepqui Tlacatl, niquinilhuis ielhuicac ejcahua Toteco para inijuanti noaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero intla se teilhuía para ax nechneltoca, huajca na nojquiya niquinilhuis ielhuicac ejcahua Toteco para yajaya ax noaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Intla se nechtlaijilhuía na tlen niMocuepqui Tlacatl ica tlen ax cuali, Toteco huelis quitlapojpolhuis. Pero intla se quitlaijilhuis Itonal Toteco, ax quema oncas tlapojpolhuili. ");
INSERT INTO nheNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Huan quema tlacame inmechhuicase iniixtla tlayacanani ipan toisraelita tiopa huan iniixtla sequinoc tlanahuatiani huan tequihuejme, amo ximocuesoca tlaque inquiijtose huan quejatza inmomanahuise, ");
INSERT INTO nheNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","pampa Itonal Toteco inmechnextilis ipan nopa tlalochtli tlaque monequi inquiijtose.” ");
INSERT INTO nheNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Huan se tlen nopa miyac tlacame quiilhui Jesús: ―Tlamachtijquetl, xiquilhui noicni ma nechmaca tlen nechtocarohua tlen totata techcahuilijtejtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Huan Jesús quiilhui: ―Tate, axaca nechtequimacatoc para ma nieli imojuez huan ma nijtlajcoxelos tlen inquipiyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Huan teipa Jesús quinilhui nopa miyac tlacame: ―Xijpiyaca cuidado para amo xijnequica nochi tlamantli tlen onca, pampa axaca quipantis yolistli tlen yancuic pampa quipiya miyac tlamantli para iaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Huan Jesús quinilhui se huicaltili: “Imil se tlacatl tlen tominpixqui nelnelía temacac miyac itlajca. ");
INSERT INTO nheNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Huan nopa tlacatl moilhui: ‘¿Tlaque nijchihuas? Ax nijpiya más cuescontini para ipan nicajcocuis ni pixquistli.’ ");
INSERT INTO nheNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Huan teipa quiijto: ‘Nijmajtojca tlaque nijchihuas. Nijxolehuas nocuesconhua huan nepa nijchihuas tlen más hueyi huan ipan nicajcocuis nochi ni pixquistli huan nochi tlen nijpiya.’ ");
INSERT INTO nheNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Huan teipa nimoyolilhuis: ‘Nijpiya miyac tomi huan tlacualistli tlen nechaxilis para miyac xihuitl, huajca san nimosehuis, huan nitlacuas huan nitlais queja nijnequis huan nitlamahuisos.’ Quej nopa moilhuiyaya nopa tlacatl tlen tominpixqui. ");
INSERT INTO nheNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Toteco Dios quiilhui: ‘Tlacatl ta tihuihuitic. Ama ni yohuali timiquis, huan ¿ajqueya quiselis nochi tlen timoajcocuilijtoc?’ ");
INSERT INTO nheNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Queja nopa eltoc ica tlacame tlen quiajcocuij miyac tlamantli para iniaxca ipan ni tlaltepactli, pero ax quipiyaj ininricojyo nopona iixtla Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Huan Jesús quinilhui imomachtijcahua: “Yeca nimechilhuía, amo ximocuesoca ica tlen inpanose. Amo ximocuesoca tlen inquicuase huan inquiise huan ica tlaque inmoyoyontise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Toteco inmechmacatoc yolistli huan ya nopa más ipati huan inmechmacas tlacualistli nojquiya. Yajaya inmechmacatoc imotlacayo tlen más ipati huan inmechmacas nojquiya tlen ica inmoyoyontise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xiquintlachilica totome. Ax momiltíaj, huan ax pixcaj huan ax quipiyaj inincuesconhua para ipan quiajcocuise inintlacualis, pero Toteco quintlamaca. Huan Toteco nojquiya inmechtlamacas pampa más imopati iixtla que totome. ");
INSERT INTO nheNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","San tlapic para inmotequipachohuaj. Intla inmocuesohuaj pampa ax inhuejcapantique, ¿huelis inmoscaltise seyoc ome mistitl san pampa miyac inmocuesohuaj? Ax inhuelij. ");
INSERT INTO nheNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Huan intla ax inhuelij inquichihuaj se tlamantli pilsiltzi, ¿para tlen inmocuesohuaj ica sequinoc tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Xijtlachilica nopa xochitl tlen moscaltíaj campa hueli. Ax tequitij huan ax tlajtzomaj, pero nimechilhuía, nopa hueyi Tlanahuatijquetl Salomón ica nochi iricojyo ax quipixqui iyejca que se xochitl. ");
INSERT INTO nheNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Toteco quinmacatoc xochitl iniyejca yonque san yoltoque se tlalochtli, huan tonilía pilintoc huan tlacame quitlatise. Huan miyac más Toteco inmechyoyontis yonque quentzi inquineltocaj. ");
INSERT INTO nheNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Huajca amo ximocuesojtinemica tlaque inquicuase huan tlaque inquise, ");
INSERT INTO nheNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","pampa queja nopa motequipachohuaj tlacame tlen ax quiixmatij Toteco, pero Toteco imoTata quimati monequi nochi ni tlamantli para ica inmopanoltise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Achtohui xijtemoca para incalaquise ipan itlanahuatilis Toteco huan yajaya no inmechmacas nochi ni tlamantli tlen monequi para inpanose. ");
INSERT INTO nheNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Amo ximomajmatica yonque ax inmiyaqui tlen innoaxcahua, pampa ica paquilistli Toteco inmechcalaquis campa yajaya tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Huajca xijnamacaca tlen imoaxca huan xiquinmajmacaca teicneltzitzi para inquiajcocuise tlen ipati nepa elhuicac. Tlen inquiajcocuise nepa ax ijtlacahuis huan ax quicuase cuatzipime, niyon tlaxtequini ax huelis quihuicase. ");
INSERT INTO nheNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Huan intla inquimatij tlen yejyectzi inmechchiya ipan elhuicac, huajca ipan imoyolo inquinequise initztose nepa. ");
INSERT INTO nheNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ximocualtlalijtoca huan xijpixtoca imotlahuilhua tlatlatoque para quema nihualas yonque niajsis tonaya o tlayohua. ");
INSERT INTO nheNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Xiitztoca queja tlatequipanohuani tlen quichiyaj ininteco ma mocuepa tlen itlacualis tlen nenamictili. Inijuanti ax cochij para huelis quicaltlapose nimantzi quema yajaya ajsis huan quinnotzas. Huan queja nopa nijnequi ximocualtlalijtoca huan xitlachixtoca para quema nihualas. ");
INSERT INTO nheNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Cuali quipantise nopa tlatequipanohuani tlen tlachixtoque quema mocuepas ininteco. Nelía nimechilhuía, ininteco moyoyontis queja se tlatequipanojquetl huan quinsehuis campa mesa huan quintlamacas. ");
INSERT INTO nheNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Huan yonque ininteco mocuepas tlajcoyohual o tlanestihuala, nopa tlatequipanohuani tlachixtoque, cuali inijuanti quipantise. ");
INSERT INTO nheNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Inquimatij intla se tlacatl quimatisquía ipan tlaque hora ajsisquía se tlaxtejquetl, huajca tlachixtosquía huan ax quicahuilisquía ma calaqui para tlaxtequis ipan ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Huajca imojuanti nojquiya ximocualtlalijtoca pampa na tlen niMocuepqui Tlacatl nimocuepas ipan se hora quema ax innechchiyaj.” ");
INSERT INTO nheNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Huan Pedro quitlajtlani Jesús: ―Tohueyiteco, ¿titechilhuijtoc ni huicaltili para tojuanti timomomachtijcahua ma timitzchiyaca o para nochi ni tlacame nojquiya ma mitzchiyaca? ");
INSERT INTO nheNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Huan Tohueyiteco quiilhui: “Nicamati tlen aqui hueli tlayacanca tequipanojquetl tlen temachtli huan tlalnamiqui tlen se tecojtli quitlalis para quinmocuitlahuis itequipanojcahua huan mojmostla quintlamacas tlen itztoque ipan ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Cuali quipantis nopa tlatequipanojquetl intla quema iteco mocuepas, quipantis ya quitlamichijtoc nochi tlen quiilhui. ");
INSERT INTO nheNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nimechilhuía iteco quitequitlalis ma quimocuitlahuis hasta nochi tlen iaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero intla se tlayacanquetl quiijtohua: ‘Noteco huejcahuas.’ Huan intla pehuas quinhuitequis nopa sequinoc tlatequipanohuani, huan pehuas neltlacuas, huan neltlais huan ihuintis, ");
INSERT INTO nheNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","huajca iteco nimantzi mocuepas ipan se tonal quema nopa tlayacanca tlatequipanojquetl ax quichiya huan ipan se hora quema ax quimati. Huan nopa tecojtli chicahuac quitlatzacuiltis itlayacanca tequipanojca huan quiquixtis huan quitlalis campa quinamiqui para inijuanti tlen ax tlaneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Huan se tlayacanca tlatequipanojquetl tlen quimatqui tlen iteco quinequiyaya huan ax mocualtlali huan ax quineltocac, huajca iteco quihuitequi nelchicahuac. ");
INSERT INTO nheNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero seyoc tlatequipanojquetl tlen ax quimatqui tlen iteco quinequiyaya, huan quichijqui tlen ax cuali, huajca quiselis se tlatzacuiltilistli tlen ax más hueyi. Pampa nochi tlen Toteco miyac quintlamajmaca, quintlajtlanía ma quichihuaca miyac tlen cuali. Huan intla Toteco quicahua miyac tequitl imaco se itequipanojca, miyac tequitl monequi quichihuas. ");
INSERT INTO nheNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nihualajtoc ipan ni tlaltepactli para nijlemenaltis se tlitl. Huan nijnequisquía ma ajsiya nopa tonal. ");
INSERT INTO nheNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nijpiya se tlaijiyohuilistli tlen monequi nijxicos huan nitlaijiyohuis hasta panos. ");
INSERT INTO nheNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Amo ximoilhuica nihualajtoc para ma onca tlasehuilistli ipan ni tlaltepactli. ¡Axtle! Nopampa, moxelose tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Para ama huan teipa campa itztoque macuilme tlacame ipan se cali, moxelose. Eyi mocualanise ica nopa ome, huan nopa ome ica nopa eyi. ");
INSERT INTO nheNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Moxelose tetatme ica inintelpocahua huan tename ica iniichpocahua. Yeyojme moxelose ininhuaya iniyejnahua huan yenajme ica iniyeyojhua.” ");
INSERT INTO nheNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Huan Jesús nojquiya quinilhui nopa miyac tlacame: “Quema inquiitaj se mixtli tlen tlejcos campa temo tonati, nimantzi inquiijtohuaj: ‘Tlaahuetzis’, huan queja nopa pano. ");
INSERT INTO nheNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Huan quema inquimachilíaj huala se ajacatl tlen sur, inquiijtohuaj: ‘Nelía tlatotoniyas ama.’ Huan queja nopa eli. ");
INSERT INTO nheNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Imojuanti inquipiyaj ome imoxayac. Inquimatij tlen quiijtosnequi tlen nesi ipan tlaltepactli huan elhuicactli, pero ax inquimachilíaj tlen pano ipan ni tonali ica ni tlanescayotl tlen nijchihua. ");
INSERT INTO nheNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Huan, ¿para tlen ax inmomacaj cuenta para monequi inquichihuase tlen xitlahuac? ");
INSERT INTO nheNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quema mocualancaitaca mitzteilhuía ica se juez huan noja initztoque ipan ojtli para inajsitij, achi cuali xijcamahui para inquisencahuase nopa tlamantli san imojuanti. Pampa intla axtle, yajaya mitzhuicas iixtla juez huan nopa juez mitztemactilis ica policías, huan nopa policías mitztlalise ipan tlatzactli. ");
INSERT INTO nheNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huan intla queja nopa panos, ax tiquisas hasta titlaxtlahuas nochi tlen monequi.” ");
INSERT INTO nheNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sequin tlacame tlen itztoyaj nopona ipan nopa tonal quiilhuijque Jesús para Pilato quinmictijtoya sequin Galilea ehuani quema nopa Galilea ehuani quinmictiyayaj tlapiyalime para tlacajcahualistli. Huan yeca inieso momanelo ica inieso nopa tlacajcahualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Huan Jesús quinnanquili: “¿Inmoilhuíaj nopa Galilea ehuani quipixtoyaj más tlajtlacoli que sequinoc Galilea ehuani pampa quej nopa ininpantic? ");
INSERT INTO nheNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nimechilhuía, axtle. Ax más tlajtlacoli quipixtoyaj, huan inmopolose nojquiya intla ax inmoyolcuepaj. ");
INSERT INTO nheNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Huan quema nopa huejcapantic cali ipan Siloé huetzqui ipan dieciocho tlacame huan inijuanti mijque, huelis inmoilhuíaj inijuanti quipixtoyaj más tlajtlacoli que nochi sequinoc ipan altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nimechilhuía, axtle. Ax más tlajtlacoli quipixtoyaj que sequinoc, huan nochi imojuanti nojquiya inmopolose, intla ax inmoyolcuepaj.” ");
INSERT INTO nheNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Huan Jesús pejqui quinilhuía ni huicaltili: “Se tlacatl quipixtoya se higuera cuahuitl tlen quitojqui ipan ixocomeca mil. Huan se tonal quitemoco itlajca, pero ax tleno quipixqui. ");
INSERT INTO nheNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Huan quiilhui tlen quimocuitlahuía ixocomeca mil: ‘Quipixtojca eyi xihuitl nijhualtemohua higos ipan ni cuahuitl, huan niyon se ax quipiya, huajca xijtzontequi pampa san tlapic ijcatoc.’ ");
INSERT INTO nheNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Huan tlen quimocuitlahuiyaya ixocomeca mil quinanquili: ‘Noteco, xijcahua para ni xihuitl huan nijtzinxahuas huan nijtlalilis yamanic tlali, ");
INSERT INTO nheNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","huan intla quipiyas itlajca ipan se xihuitl, cualtitoc, huan intla axtle, huajca quena, tijtzontequise.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Huan Jesús tlamachtiyaya ipan se israelita tiopamitl ipan sábado nopa tonal para mosehuise israelitame, ");
INSERT INTO nheNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","huan hualajqui se sihuatl tlen quipixtoya se ajacatl para dieciocho xihuitl tlen quicuitlapantomotzchijtoya huan ayoc huelqui momelahua. ");
INSERT INTO nheNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Huan quema Jesús quiitac, quinojnotzqui huan quiilhui: ―Nane, nimitzquixtilía mococolis. ");
INSERT INTO nheNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Huan Jesús quitlalili ima huan nimantzi nopa sihuatl huelqui momelajqui huan pejqui quihueyichihua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Huan nelía cualanqui nopa tiopan tlayacanquetl pampa Jesús quichicajtoya ipan sábado, nopa tonal para israelitame ma ax tequitica. Huajca nopa tlayacanquetl quinilhui nopa miyac tlacame: ―Onca chicuase tonali ipan se samano para ma titequitica, huajca xihualaca ipan seyoc tonal intla inquinequij para Jesús ma inmechchicahua, huan ayoc xihualaca ipan sábado. ");
INSERT INTO nheNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Huan Tohueyiteco Jesús quinanquili: ―Ta tijpiya ome moxayac. Se sen imojuanti inquitojtomaj imohuacax o imoburro quema ilpitoc ipan sábado, huan inquihuicaj ma atliti. ");
INSERT INTO nheNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Para dieciocho xihuitl Axcualtlacatl quipixtoya ilpitoc ni sihuatl tlen nojquiya se iteipa ixhui tohuejcapan tata Abraham. ¿Ax tiquita cuali nojquiya nijmacahuas tlen icocolis ipan sábado? ");
INSERT INTO nheNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Huan quema Jesús quiilhui ya ni, nochi icualancaitacahua mopinajque iniixtla nopa miyac tlacame, pero nopa tlacame nelía paquiyayaj ica nopa huejhueyi tlamantli tlen quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Huan Jesús quiijto: “¿Quejatza huelis nimechilhuis quejatza eltoc ipan itlanahuatilis Toteco? ");
INSERT INTO nheNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eltoc queja se ixinajcho mostaza tlen se tlacatl quitoca. Huan nopa xinachtli ixhuas huan moscaltis hasta mochihuas se cuahuitl campa totome quichihuase inintepasol ipan imacuayo.” ");
INSERT INTO nheNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nojquiya Jesús quiijto: “¿Ica tlaque huelis niquinhuicalotis quejatza momiyaquilía tlacame tlen quicahuilíaj Toteco ma tlanahuati ipan ininyolo? ");
INSERT INTO nheNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Inijuanti momiyaquilise queja mosonehua pantzi quema se sihuatl quitlalía se quentzi tlasonejcayotl ipan eyi kilos harina huan teipa nopa tlasonejcayotl quisonehuas nochi nopa pantzi.” ");
INSERT INTO nheNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús noja nejnemiyaya ipan ojtli hasta altepetl Jerusalén huan quinpanotiyajqui altepetini huan ranchos huan tlamachtijtiyohuiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Huan se quiilhui: ―Tohueyiteco, ¿nelquentzi tlacame Toteco quinmaquixtis tlen inintlajtlacolhua? Huan Jesús quinanquili: ");
INSERT INTO nheNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―Xijchihuaca campeca xicalaquise ipan nopa pitzahuac puerta tlen yohui elhuicac, pampa miyac tlacame quinequise calaquise nopona huan ax huelise. ");
INSERT INTO nheNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Pampa ajsis tonali quema motzacuas puerta nepa elhuicac. Huan na nielis queja se tetat tlen quitzacua puerta ipan ichaj ica tlayohua huan ayoc aqui quicahuilis ma calaqui. Huan inmoquetzase calteno, huan innechnotzase huan innechilhuise: ‘Toteco, xitechcaltlapo’, huan na nimechnanquilis: ‘¡Axtle! Ax nimechixmati, niyon ax nijmati canque inehuaj.’ ");
INSERT INTO nheNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Huan yonque innechilhuise: ‘Titlacuajque huan tiatlique mohuaya, huan titlamachti ipan toaltepe’, ");
INSERT INTO nheNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","pero na nimechilhuis: ‘Nelía nimechilhuía, ax nimechixmati huan ax nijmati canque inehuaj. Xinechtlalcahuica imojuanti tlen inquichihuaj tlen ax cuali.’ ");
INSERT INTO nheNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Huan imojuanti inchocase huan intlanhuehuechocase ica nopa tlatzacuiltili pampa inquiitase Abraham, Isaac, Jacob ihuaya nochi tiocamanalohuani nopona campa Toteco tlanahuatía, huan inmocahuase calteno. ");
INSERT INTO nheNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Huan tlacame hualase campa quisa tonati huan campa oncalaqui, huan hualase tlen norte huan tlen sur huan mosehuise para tlacuase nopona campa Toteco Dios tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Huan sequin tlen ama teicneltique, Toteco quinachtohuis ipan nopa tonal, huan sequin tlen tlayacanaj ama, Toteco quintlalis hasta teipa. ");
INSERT INTO nheNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Huan ipan nopa tlalochtli hualajque sequin fariseos huan quiilhuijque Jesús: ―Xiquisa nica huan xiya intla tijnequi tiitztos pampa Tlanahuatijquetl Herodes Ántipas quinequi mitzmictis. ");
INSERT INTO nheNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Huan Jesús quinilhui: ―Xiquilhuitij nopa cayochi Herodes para ama huan mostla niquinquixtis iajacahua Axcualtlacatl huan niquinchicahuas tlacame, huan huiptla nijtlamiltis notequi. ");
INSERT INTO nheNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Huajca ama, mostla huan huiptla niitztos ipan ojtli para niajsis Jerusalén huan ax mahuilili, pampa san ipan altepetl Jerusalén quinmictíaj itiocamanalojcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“¡Inteicneltijque inJerusalén ehuani! Inquinmictíaj itiocamanalojcahua Toteco huan inquintepachohuaj inijuanti tlen yajaya inmechtitlanilijtoc. Miyac huelta nijnequiyaya nimechsentilis ica imoconehua para nimechnajnahuas queja se tenanpiyo quinsentilía ipilconehua ieltlapaltzala, pero ax inquinejque. ");
INSERT INTO nheNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xiquita, Toteco Dios ayoc mocahua ipan imotiopa, huan nimechyolmelahua ax innechitase sampa hasta ajsis hora quema innechilhuise: ‘Ma Toteco Dios mitztiochihua Ta tlen tihuala ipan itoca .’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Huan se sábado nopa tonal quema israelitame mosehuíaj, Jesús yajqui tlacuato ichaj se inintlayacanca fariseos, huan nopa fariseos quitlachiliyayaj ajachica. ");
INSERT INTO nheNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Huan itztoya nopona iixtla Jesús se tlacatl tlen tejtemiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Huan Jesús quintlajtlani nopa tlamachtiani tlen itlanahuatilhua Moisés huan nopa fariseos: ―¿Itlanahuatilhua Moisés techcahuilíaj ma tiquinchicahuaca tlacame ipan ni tonal para ma timosehuica o ma ax tiquinchicahuaca? ");
INSERT INTO nheNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Huan inijuanti ax molinijque. Huan Jesús quimaitzqui nopa tlacatl huan quichicajqui. Huan quiilhui ma yohui. ");
INSERT INTO nheNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Huan teipa Jesús quinilhui: ―Intla imoburro o imotoro tlen tlaxahua huetzisquía ipan se tlacoyoctli, ¿ax inquiquixtisquíaj nimantzi yonque ipan sábado? ");
INSERT INTO nheNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Huan inijuanti ax tleno quinanquilijque. ");
INSERT INTO nheNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Huan Jesús quiitac nopa tlacame quitlapejpeniyayaj nopa siyas tlen más quipixqui tlatlepanitacayotl campa mesas, huajca pejqui quinpohuilía se huicaltili tlen se tlacatl tlen quinnotztoya tlacame ipan se tlacualistli. Quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Quema se inmechnotzas ipan se tlacualistli tlen nenamictili, amo xijtemoca nopa siya campa quipiya más tlatlepanitacayotl pampa huelis teipa ajsis seyoc tlacatl tlen no quinotztoque tlen achi más monequi quitlepanitase. ");
INSERT INTO nheNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Huan huelis monequis para yajaya tlen inmechnotztoc hualas campa ta huan mitzilhuis: ‘Xijmaca mosiya ni tlacatl tlen ajsico.’ Huan nelía timopinahuas huan monequis tijtemoti tlen hueli siya para ipan timosehuis. ");
INSERT INTO nheNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Quema se inmechnotzas xiyaca ipan se tlacualistli, achi cuali ximosehuica campa ax más cuali huan teipa huelis hualas yajaya tlen mitznotzqui huan mitzilhuis: ‘Nohuampo, ximosehuiqui ipan nopa siya tlen achi cuali.’ Huan queja nopa mitzhueyitlalis iniixtla nochi tlen mosehuíaj campa mesa. ");
INSERT INTO nheNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pampa tlacame tlen mohueyimatij ica ininselti ama, teipa Toteco quinpinahualtis. Huan tlen moicnonequij ama, Toteco teipa quinhueyitlalis. ");
INSERT INTO nheNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Huan nojquiya Jesús quiilhui nopa tlacatl tlen quinnotztoya para ma tlacuatij ichaj: ―Quema titemaca se tlacualistli, amo xiquinnotza mohuampoyohua, o moicnihua, o mocalnechcahua tlen más quipiyaj tomi, pampa inijuanti teipa mitznotzase ipan se tlacualistli para mitzcuepilise nopa tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero quema tijpiya se tlacualistli, xiquinnotza tlen teicneltzitzi huan tlen macototique huan tlen metzcuachotique huan tlen popoyotzitzi, ");
INSERT INTO nheNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","pampa inijuanti ax hueli mitzcuepilise. Huan Toteco mitztiochihuas huan mitztlaxtlahuis quema moyolcuise nochi tlacame tlen itztoque xitlahuaque iixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Huan se tlacatl tlen mosehuiyaya campa mesa ihuaya Jesús quicajqui tlen quiijto huan quiilhui: ―Cuali quipantis tlen mosehuis huan tlacuas nepa campa Toteco Dios tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Huan Jesús quiilhui: ―Se tlacatl temacayaya se hueyi tlacualistli huan quinnotzqui miyac ma tlacuatij. ");
INSERT INTO nheNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Huan quema cualtitoyaya nochi tlacualistli, huajca quititlanqui itequipanojca ma yohui ma quinilhuiti nopa tlanotzalme: ‘Xihualaca pampa nochi ya tlacuajtlalili.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Huan nochi nopa tlanotzalme pejque motechtíaj. Nopa tlen achtohui quiilhui nopa tlatequipanojquetl: ‘Nijcojqui se tlali huan monequi niyas niquitati. Xinechtlapojpolhui, pero ax huelis niyas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Huan seyoc quiilhui: ‘Niquincojtoc macuili pares torojme para tlapoxahuase huan monequi niyas niquinyejyecoti intla tequitij cuali. Xinechtlapojpolhui, pero ax huelis niyas campa nopa tlacualistli.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Huan seyoc quiilhui: ‘Nel amanoc nimosihuajti huan yeca ax huelis niyas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Huan nopa tlatequipanojquetl mocuepqui huan quiyolmelajqui iteco nochi tlen quinanquilijque. Huan nopa tlanotzquetl cualanqui pampa axaca hualajqui. Huajca quiilhui itequipanojca: ‘Nimantzi xiya tianquis huan xiya ipan nochi callejtipa ipan toaltepe, huan xiquinhualica nochi tlen teicneltzitzi, huan tlen macototique, huan tlen metzcuachotique huan tlen popoyotzitzi para ma hualaca ipan totlacualis.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Huan nopa tlatequipanojquetl yajqui huan teipa mocuepqui huan quiilhui: ‘Noteco, ya nijchijqui tlen tinechnahuati huan miyac niquinhualicac, pero noja mocahua siyas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Huan nopa tecojtli quiilhui itequipanojca: ‘Xiya ipan ojoteno huan ipan miltini huan xiquinfuerzajhuiti tlacame ma hualaca para ma temi nochaj. ");
INSERT INTO nheNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Huan nimitzilhuía, niyon se inijuanti tlen achtohui niquinnotzqui ax quiyecos notlacualis.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Huan tlahuel miyac tlacame nejnemiyayaj ihuaya Jesús ipan ojtli, huan yajaya moicancuepqui huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Intla se quinequi nechtoquilis, monequi nechicnelis miyac huan ax queja quiicnelía itata, huan inana, huan isihua, huan iconehua huan iicnihua. Quena, monequi tlahuel nechicnelis más miyac huan ax queja ya moicnelía, pampa intla ax queja nopa nechicnelía, ax huelis elis nomomachtijca. ");
INSERT INTO nheNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nomomachtijca monequi elis queja se tlacatl tlen quihuica icuamapel para ipan miquis. Intla ax queja nopa nechtoquilía mocualtlalijtoc para miquis pampa nechneltoca na, ax hueli elis nomomachtijca. ");
INSERT INTO nheNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Intla se tlen imojuanti quinequi quichihuas se hueyi cali, huajca achtohui mosehuis huan quipohuas quesqui tomi monequis para quimatis intla quiaxilía para quitlamiltis. ");
INSERT INTO nheNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pampa intla ax moilhuía quesqui ipati achtohui, huelis san quitzinpehualtis nopa cali huan tlamis itomi. Huan nochi quiitase para ax huelqui quitlamilti huan quihuihuiitase. ");
INSERT INTO nheNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Quiijtose: ‘Ne tlacatl pejqui quichihua ichaj, pero ax huelqui quitlamilti.’ ");
INSERT INTO nheNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Huan intla itztoc se tlanahuatijquetl tlen quinequi motehuis ihuaya seyoc, ¿ax mosehuis huan moilhuis achtohui intla nopa diez mil soldados tlen quinpiya huelis quitlanise nopa seyoc tlanahuatijquetl tlen quinpixtoc veinte mil soldados? ");
INSERT INTO nheNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Huan intla quiitas para ax huelis quintlanise, quema quihuejcaitas nopa tlanahuatijquetl huala ica isoldados, nimantzi quintitlanis tlacame ma quicamahuitij, huan mosencahuase quejatza huelis mosejseltise inincualancayo. ");
INSERT INTO nheNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Huajca axaca huelis elis nomomachtijca intla ax quicahua nochi tlen quipiya para iaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Istatl nelía cuali, pero intla ayoc poyec, ¿quejatza huelis tlapoyeltisoc sampa? ");
INSERT INTO nheNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Intla ayoc poyec ax hueli tijtequihuise para tlacualistli. Niyon ax hueli tijtequihuise ipan tlali, o ipan yamanic tlali para toctli. San monequi tijtepehuase. Nochi imojuanti inquipiyaj imonacas, huajca xijtlacaquilica tlen nimechilhuía.” ");
INSERT INTO nheNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Huan monechcahuiyayaj campa Jesús para quitlacaquilise nochi nopa tlacame tlen tlainanque impuesto huan tlen miyac tlajtlacoli quichijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Huajca nopa fariseos huan tlamachtiani tlen itlanahuatil Moisés pejque quiteilhuíaj huan quiijtojque: ―Ni tlacatl Jesús quinselía tlacame tlen huejhueyi tlajtlacolchihuaj huan hasta tlacua ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Huajca Jesús quinpohuili ni huicaltili: ");
INSERT INTO nheNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Intla se tlen imojuanti quinpiyasquía cien borregojme huan se polihuisquía, ¿ax quicahuasquía nopa noventa y nueve campa potrero huan contemosquía nopa se tlen polijtoc hasta quipantis? ");
INSERT INTO nheNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Huan quema quipantis, quiajcolpantlalis ica paquilistli huan quihuicas ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Huan quema ajsiti ichaj, quinnotzas ihuampoyohua huan icalnechcahua huan quinilhuis: ‘Xipaquica nohuaya pampa ya nijpanti nopilborrego tlen mocuapolojtoya.’ ");
INSERT INTO nheNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nimechilhuía, ihuical eltoc nepa elhuicac. Nepa onca más paquilistli ica se tlajtlacolchijquetl tlen moyolcuepa huan quicahua itlajtlacolhua, huan ax queja ica noventa y nueve tlen moilhuíaj ya itztoque xitlahuaque iixtla Toteco huan ax monequi moyolcuepase. ");
INSERT INTO nheNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Huan intla se sihuatl quipiyasquía majtlactli huejhueyi plata tomi huan quipolosquía se, ¿ax quitlatisquía se tlahuili, huan tlachpanasquía cuali calijtic huan quitemosquía cuali hasta quipantis? ");
INSERT INTO nheNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Huan quema quipantis, huajca quinnotzas ihuampoyohua huan icalnechcahua huan quinilhuis: ‘Xipaquica nohuaya pampa ya nijpanti nopa tomi tlen nijpolojtoya.’ ");
INSERT INTO nheNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Huan nimechilhuía, queja nopa paquij ielhuicac ejcahua Toteco quema se tlajtlacolchijquetl moyolcuepa huan quicajtehua itlajtlacolhua.” ");
INSERT INTO nheNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Huan Jesús quinilhui: “Se tlacatl quinpixtoya ome itelpocahua, ");
INSERT INTO nheNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","huan yajaya tlen teipa ejquetl quiilhui itata: ‘Papá, xinechmaca ama nochi tlen elis noaxca quema timiquis.’ Huajca nopa tetat quitlajcoxelo tlen quipixtoya, huan quimacac tlen quiaxcatisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Huan ax huejcajqui nopa telpocatl tlen teipa ejquetl quisentili nochi tlen iaxca huan quistejqui para yas huejca ipan seyoc tlali. Huan nepa san quinenpolo nochi itomi ica tlamantli tlen fiero. ");
INSERT INTO nheNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Huan quema ya quitlamiltijtoya nochi itomi, ajsico se hueyi mayantli ipan nopa tlali, huan nopa telpocatl ax quipixqui tomi para itlacualis. ");
INSERT INTO nheNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Huan quitemoto tequitl ica se tlen nopona ehuayaya, huan yajaya quititlanqui ma quintlamacati ipitzohua. ");
INSERT INTO nheNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huan nopa telpocatl nelía mayanayaya hasta quinequiyaya quicuas nopa epetlatl tlen quicuayayaj pitzome, pampa axaca quimacayaya tlen quicuas. ");
INSERT INTO nheNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Pero quema pejqui motejtemo, quiilnamijqui quejatza eltoya nepa ichaj itata huan moilhui: ‘Nochi itequipanojcahua notata quipiyaj hasta mocahua tlen quicuase, huan na nica nimayancamictinemi. ");
INSERT INTO nheNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Niquisas nica huan niyas campa notata huan niquilhuis: Papá, na nitlajtlacolchijtoc iixtla Toteco Dios huan moixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ayoc quinamiqui para tinechitas queja nimocone. San xinechcahuili ma nimitztequipano.’ Queja nopa moilhui para quiilhuis itata. ");
INSERT INTO nheNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Huan yajaya quisqui huan yajqui ichaj itata. Pero quema aya onajsiyaya ichaj, itata quihuejcaitac huan quitlasojtlac. Huan itata motlalojtejqui, huan quicuanajnahuajqui huan quitzoponi. ");
INSERT INTO nheNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Huan nopa telpocatl quiilhui: ‘Papá, nitlajtlacolchijtoc iixtla Toteco Dios huan moixtla, huan ayoc quinamiqui para tinechitas queja nimocone.’ ");
INSERT INTO nheNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Pero itata quinnotzqui itequipanojcahua huan quinilhui: ‘Nimantzi, xijhualicaca nopa yoyomitl tlen achi cuali para ma moquenti notelpoca. Huan xijhualicaca se anillo para ima huan xijhualicaca tecactli para ma motlalili. ");
INSERT INTO nheNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Huan xijhualicaca nopa pilhuacaxtzi tlen achi más tomahuac huan xijmictica. Ma titlacuaca huan ma tiilhuichihuaca, ");
INSERT INTO nheNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","pampa ni nocone eltoya queja mictoya, huan ama queja moyolcuitoc. Polijtoya huan ama ya tijpantijque.’ “Huajca inijuanti pejque ilhuichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Huan iachtohui ejca cone tequitiyaya mila. Huan quema monechcahuico ichaj, quicajqui tlatzotzonayayaj huan mijtotiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Huan quinotzqui se itequipanojca huan quitlajtlani tlaque oncayaya ipan ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Huan itequipanojca quiilhui: ‘Moicni mocuepqui huan motata quimicti nopa pilhuacaxtzi tlen achi más tomahuac pampa mocuepquiya ica cuali huan ax tleno más fiero ipantic.’ ");
INSERT INTO nheNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Huan nopa achtohui ejquetl nelía cualanqui huan ax quinequiyaya calaquis ichaj. Huan itata hualajqui huan quiilhui ica cuali ma calaqui. ");
INSERT INTO nheNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero nopa achtohui ejquetl quiilhui itata: ‘Xiquita, nimitztequipanojtoc para miyac xihuitl huan nochipa nijchijtoc tlen tinechnahuatijtoc, pero ax quema tinechmacac se chivo para ma niilhuichihua ica nohuampoyohua. ");
INSERT INTO nheNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero quema mocuepqui ne motelpoca tlen quiahuiloto nochi motomi ica ahuilnenca sihuame, ta tijselía ica cuali. Huan tijmictijtoc nopa pilhuacaxtzi tlen achi tomahuac para ma quicua.’ ");
INSERT INTO nheNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Huan itata quiilhui: ‘Nocone, nochi tonali tiitztoc nohuaya huan nochi tlen nijpiya moaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero monequi tiilhuichihuase huan tijpiyase paquilistli pampa eltoya queja ya mictoya moicni huan ama eltoc queja moyolcuitoc sampa, huan polijtoya huan ama ya tijpantijque.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Huan Jesús nojquiya quincamahui imomachtijcahua huan quinilhui: “Itztoya se tominpixquetl tlen quipixtoya se itlayacanca tlatequipanojca ipan ichaj tlen quimocuitlahui nochi tlen iaxca. Huan sequinoc quiyolmelajque para itlayacanca tlatequipanojca san quiahuilpolohuayaya nochi tlen quipixqui. ");
INSERT INTO nheNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Huajca nopa tominpixquetl quinotzqui itlayacanca tlatequipanojca huan quiilhui: ‘¿Tlaque ya ni tlen ica mitzteilhuíaj tlacame? Xinechsencahuili se amatl ica nochi cuentas huan ica nochi tlen tijchijtoc pampa ayoc huelis tinechtequipanos ipan nochaj.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Huajca nopa tlayacanca tequitiquetl moilhui: ‘¿Tlaque nijchihuas para ica nimopanoltis? Noteco ayoc nechcahuilis ma nijtequipanos. Ayoc nijpiya fuerza para nitequitis chicahuac huan nimopinahua para nimotlaejehuis. ");
INSERT INTO nheNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nijmajtojca tlaque nijchihuas. Nijsencahuas para tlacame ma nechselica queja niininhuampo quema ayoc huelis nijtequipanos noteco.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Huan nopa tlayacanquetl quinnotzqui sesen nopa tlacame tlen quitlahuiquiliyayaj iteco huan pejqui ica yajaya tlen achtohui. Huan quiilhui: ‘¿Quesqui tijtlahuiquilía noteco?’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Huan quiijto: ‘Nitlahuica cien tambores tlen aceite.’ Huan nopa tlayacanquetl quiilhui: ‘Xijhuica nopa mocuenta ama huan nimantzi xijsencahua seyoc mocuenta tlen quiijtos san tijtlahuiquilía cincuenta tambores.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Huan nopa tlayacanquetl quiilhui seyoc: ‘¿Quesqui tijtlahuiquilía noteco?’ Huan quiijto: ‘Nijtlahuiquilía cien tlayejyecoli tlen trigo.’ Huan nopa tlayacanquetl quiilhui: ‘Xijhuica nopa mocuenta huan xijsencahua seyoc mocuenta tlen quiijtos san tijtlahuiquilía ochenta tlayejyecoli.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Huan teipa iteco quimatqui tlen quichijtoya huan quiijto para itlayacanca nelía monexti tlalnamiqui para tlacajcayahuas para huelis mohuicas cuali ica sequinoc. Huan ama nojquiya sequinoc tlacame monextíaj más tlalnamiquij ica tlen quichihuilíaj sequinoc que imojuanti intlacame tlen inquipiyaj tlahuili. ");
INSERT INTO nheNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Huan nimechilhuía achi cuali xijtequihuica imotomi nicani ipan ni tlaltepactli para xiquinpalehuica tlen quinpolohuaj tlen ica panose huan queja nopa mochihuase imohuampoyohua. Huan teipa quema tlamis imotomi, inijuanti inmechselise ipan caltini tlen huejcahuas para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Pero nimechilhuía intla se tlacatl eli temachtli ica pilquentzi tlen seyoc quicahua imaco, nojquiya elis temachtli quema se quicahuas miyac imaco. Huan intla se tlaxtequis quema seyoc quicahua quentzi imaco, nojquiya tlaxtequis quema se quicahuas miyac imaco. ");
INSERT INTO nheNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Huan intla ax intemachme para cuali inquitequihuíaj nopa tomi tlen inquipiyaj ipan ni tlaltepactli, Toteco ax inmechcahuilis imomaco tlamantli tlen nelía ipati. ");
INSERT INTO nheNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Huan intla ax intemachme quema inquitequihuíaj tomi tlen iaxca seyoc, huajca axaca inmechaxcatis se tlamantli para xijtequihuica. ");
INSERT INTO nheNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Axaca huelis quintequipanos ome itecojhua pampa quicocolis se huan quiicnelis ne se. Huan ica se elis temachtli, pero ica ne se quitlahuelcahuas. Nojquiya ax huelis inquitequipanose Toteco Dios huan tomi.” ");
INSERT INTO nheNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Huan quicaquiyayaj itlajtol nopa fariseos tlen tlahuel quinejque moricojchihuase huan inijuanti pejque quihuihuiitaj. ");
INSERT INTO nheNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Huan Jesús quinilhui: “Iniixtla tlacame infariseos inmochihuaj queja incuajcualme, pero Toteco quimati para fiero imoyolo. Onca tlamantli tlen tlacame quitlepanitaj, pero Toteco quielihuishuía. ");
INSERT INTO nheNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Itlanahuatil Moisés huan tlen quiijcuilojque itiocamanalojcahua Toteco quipixque tequihuejcayotl hasta quema hualajqui Juan tlen tecuaaltiyaya. Pero Juan pejqui tepohuilía queja Toteco tlanahuatía huan hasta ama noja ya nopa tepohuilíaj. Huan eltoc queja nochi tlacame mocuatetzopaj pampa tlahuel quinequij calaquise campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Pero ya nopa ax quinequi quiijtos para itlanahuatilhua Moisés ayoc quipiya inintequi. Noja quisas melahuac sesen piltlamantzitzi tlen quiijtohua itlanahuatil yonque panotehuas elhuicac huan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Intla se tlacatl quicahua isihua o amaxolehua ihuaya huan teipa mosejcotilía ica seyoc, huajca nopa tlacatl momecatía. Huan intla se tlacatl mosejcotilis ica se sihuatl tlen quicajtejtoc ihuehue, huajca nopa tlacatl nojquiya momecatía. ");
INSERT INTO nheNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Itztoya se tlacatl tlen nelía quipiyayaya tomi huan mojmostla moquentiyaya iyoyo tlen nelía yejyectzi huan tlen moradojtic queja elisquía se tlanahuatijquetl. Huan mojmostla quipiyayaya se hueyi tlacualistli ica nochi tlen ajhuiyac quinequiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Huan nojquiya itztoya se motlaejehuijquetl teicneltzi tlen itoca eliyaya Lázaro tlen mojmostla mosehuiyaya icalteno nopa tominpixquetl. Huan Lázaro quipixtoya miyac cocome ipan itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Huan tlahuel mayanayaya huan quinequiyaya quicuas nopa panpayaxtli tlen huetziyaya imesa tzala nopa tominpixquetl. Huan hualayayaj chichime huan quipipitzohuayayaj icocohua. ");
INSERT INTO nheNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Huan quema ajsic hora, Lázaro tlen teicneltzi mijqui huan hualajque elhuicac ehuani huan quihuicaque campa tlayejyejca campa Abraham itztoc. Huan nojquiya mijqui nopa tominpixquetl huan tlacame quitlalpachojque. ");
INSERT INTO nheNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Huan teipa ipan tlitl nepa mictla, nopa tominpixquetl tlahuel tlaijiyohuiyaya. Huan quihuejcaitac Abraham ihuaya Lázaro. ");
INSERT INTO nheNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Huajca camatqui chicahuac nopa tominpixquetl huan quiilhui: ‘Notata Abraham, xinechtlasojtla, huan xijtitlani Lázaro ma quixoloni imacpilyacapa huan ma quiseseliqui nonenepil pampa nelnelía nitlaijiyohuía miyac ipan ni tlitl.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero Abraham quiilhui: ‘Nocone, xiquilnamiqui quema tiitztoya ipan tlaltepactli tijpixtoya miyac tlamantli tlen cuali huan Lázaro quipanoc miyac tlaohuijcayotl. Ama yajaya quipiya tlen cuali huan ta titlaijiyohuía. ");
INSERT INTO nheNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nojquiya onca se hueyi tlalcoyoctli tlatlajco tojuanti huan intla se tlen nicani quinequisquía yas campa tiitztoc, ax huelis. Huan axaca tlen itztoc nopona huelis hualas nica campa tojuanti tiitztoque.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Huan nopa tominpixquetl nepa mictla quiilhui: ‘Huajca, notata, nimitztlajtlanía ica nochi noyolo, xijtitlani Lázaro nepa ichaj notata. ");
INSERT INTO nheNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Pampa niquinpiya macuilti noicnihua. Ma quinilhuiti quejatza eltoc nica para ma ax hualaca campa tlacame tlaijiyohuíaj miyac.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham quiilhui: ‘Moicnihua quipiyaj nopa libros tlen Itlajtol Toteco tlen Moisés huan itiocamanalojcahua quiijcuilojque. Ma quichihuilica cuenta tlen quiijtohua.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Pero nopa tominpixquetl quiilhui: ‘¡Axtle! Notata Abraham, ax quichihuilíaj cuenta. Pero intla se tlen mictoc moyolcuis huan quincamahuis, huajca moyolcuepase huan quicahuase inintlajtlacolhua.’ ");
INSERT INTO nheNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero Abraham quiilhui: ‘Intla inijuanti ax quitlacaquilíaj tlen Moisés huan itiocamanalojcahua tlajcuilojque, nojquiya ax quichihuilise cuenta itlajtol se tlen ya mictoc huan moyolcuis.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Huan Jesús quinilhui imomachtijcahua: “Nochipa oncas tlamantli tlen quinyoltilanas tlacame ma tlajtlacolchihuaca. Pero se hueyi tlatzacuiltili quichiyas nopa tlacatl tlen quiyoltilanas seyoc. ");
INSERT INTO nheNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más cuali quema aya quichihua nopa hueyi tlajtlacoli, ma moquechilpi imetl huan ma moisahuiti ipan hueyi atl para ax quichihuilis ma tlajtlacolchihua se tlen noaxca tlen ax quipiya fuerza. ");
INSERT INTO nheNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ximomocuitlahuica ica tlen inquichihuaj. “Intla moicni mitzixpanos, huajca xiquilhui tlen quichijtoc. Huan intla yajaya moyolcuepa ica tlen quichijtoc, huajca xijtlapojpolhui. ");
INSERT INTO nheNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Huan intla yajaya mitzixpanos chicome hueltas ipan se tonal huan sesen huelta mocuepas huan quiijtos: ‘Xinechtlapojpolhui tlen ax cuali nimitzchihuilijtoc’, huajca sesen huelta xijtlapojpolhui.” ");
INSERT INTO nheNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Huan itlayolmelajcahua Tohueyiteco Jesús quiilhuijque: ―Xitechpalehui para más ma timitzneltoquilica. ");
INSERT INTO nheNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Huan Tohueyiteco quinilhui: ―Se mostaza xinachtli eltoc nelía pilsiltzi pero teipa mochihua hueyi. Huan intla queja nopa mohueyilis imotlaneltoquilis, huajca huelis inquiilhuise ni hueyi cuahuitl: ‘Ximoquixti huan ximotoca ipan hueyi atl’, huan ni cuahuitl inmechneltoquilis. ");
INSERT INTO nheNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Intla itequipanojca se tlacatl tlamehua ipan imil o quinmocuitlahuía iborregojhua, huan teipa quitlamiltis itequi huan mocuepas ichaj, iteco ax quiilhuis: ‘Xihuala huan ximosehui para titlacuas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¡Axtle! Quema yajaya hualas, iteco quiilhuis: ‘Xijsencahua tlen nijcuas huan xinechtequili notlacualis huan teipa ta titlacuas.’ ");
INSERT INTO nheNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Huan teipa iteco ax monequi quitlascamatis pampa quichijqui tlen quinahuati ma quichihua pampa quejnopa itequi para quichihuas mojmostla. ");
INSERT INTO nheNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Huan queja nopa eltoc ica imojuanti pampa initequipanojcahua Toteco, huan quema inquichihuaj nochi tlen yajaya inmechnahuatía, xiquilhuica: ‘Toteco, ax quinamiqui titechtlascamatis pampa tojuanti timoaxcahua huan san tijchijtoque tlen quinamiqui tijchihuase.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Huan Jesús noja nejnemiyaya ipan ojtli para altepetl Jerusalén huan panotinenqui nopa inepantipa estado Galilea huan estado Samaría. ");
INSERT INTO nheNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Huan calajqui ipan se rancho huan hualajque quinamiquicoj majtlactli tlacame tlen palaniyayaj inintlacayo. Inijuanti mohuejcaquetzque queja monequiyaya ipampa inincocolis, ");
INSERT INTO nheNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","huan inijuanti quitzajtzilijque: ―Jesús, titlamachtijquetl, xitechtlasojtla huan xitechchicahua. ");
INSERT INTO nheNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Huan quema Jesús quinitac, quinilhui: ―Xiyaca ximonextitij iixtla nopa totajtzi para quimatis inmochicajtoque. Huan quema yohuiyayaj ipan ojtli campa totajtzi, nochi mochicajque tlen inincocolis yonque eltoya nelfiero. ");
INSERT INTO nheNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Huan se tlen nopa tlacame momacac cuenta para Jesús ya quichicajtoya, huajca mocuepqui, tlahuel quihueyichijtihualayaya Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Huan yajaya motlancuaquetzqui iicxitla Jesús huan quitlascamatqui. Huan nopa tlacatl eliyaya se Samaría ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Huan Jesús quiijto: ―¿Ax niquinchicajqui majtlactli tlacame? ¿Canque itztoque nopa seyoc chicnahui? ");
INSERT INTO nheNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Axaca más quinequiyaya mocuepas para quihueyichihuas Toteco, san ni sejcoyoc ejquetl? ");
INSERT INTO nheNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Huan Jesús quiilhui nopa tlacatl: ―Ximoquetza huan xiya mochaj. Timochicajqui pampa tinechneltocac. ");
INSERT INTO nheNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Huan sequin fariseos quitlajtlanijque Jesús quema hualas Toteco para tlanahuatis ipan ni tlaltepactli. Huan Jesús quinnanquili huan quinilhui: ―Quema Toteco tlanahuatis, ax oncas tlanescayotl tlen huelis inquiitase. ");
INSERT INTO nheNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Huan axaca quiijtos: ‘Xiquitaca, nicani Toteco tlanahuatía’ o ‘Nepa Toteco tlanahuatía’, pampa Toteco tlanahuatía ipan ininyolo tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Huan Jesús quinilhui imomachtijcahua: ―Ajsis tonali quema inquinequise innechitase na tlen niMocuepqui Tlacatl huan inquinequise sampa initztose nohuaya, pero ax huelis innechitase. ");
INSERT INTO nheNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Huan tlacame inmechilhuise: ‘Xijtlachilitij nepa itztoc’ o ‘Xijtlachiliquij nica itztoc’, pero amo xiyaca xinechtemotij. ");
INSERT INTO nheNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Queja nochi hueli quiitaj quema tlapetlani ipan elhuicactli huan tlahuía campa hueli, queja nopa nojquiya nochi nechitase na tlen niMocuepqui Tlacatl ipan nopa tonal quema nimocuepas ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero achtohui monequi para tlahuel nitlaijiyohuis, huan tlacame tlen ama itztoque nechhuejcamajcahuase. ");
INSERT INTO nheNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Quema na tlen niMocuepqui Tlacatl nimocuepas ipan tlaltepactli elis queja eltoya quema Noé itztoya. ");
INSERT INTO nheNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ipan nopa tonali quema Noé itztoya, tlacame tlacuayayaj, tlaiyayaj, mosihuajtiyayaj huan quisencahuayayaj para iniichpocahua ma monamictica. Quichihuayayaj nochi tlen ipa momajtoyaj quichihuaj hasta nopa tonal quema Noé calajqui ipan cuacanahua. Huan nopa tonal pejqui tlaahuetzi huan tlatemic campa hueli hasta quintlamimicti nochi tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Huan ihuical panoyaya quema Lot itztoya ipan tlaltepactli. Tlacame tlacuayayaj, tlaiyayaj, tlacohuayayaj, tlanamacayayaj, tlatojtocayayaj huan quichihuayayaj ininchaj. ");
INSERT INTO nheNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero ipan nopa tonal quema Lot quisqui altepetl Sodoma, huetzqui tlitl ihuaya azufre huan quintlamitlati nochi nopa tlacame tlen itztoyaj nopona. ");
INSERT INTO nheNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Huan ihuical elis nojquiya ipan nopa tonal quema na tlen niMocuepqui Tlacatl nimonextis, ax oncas tlanescayotl para inmechilhuis intla se tlajquía panos. ");
INSERT INTO nheNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ipan nopa tonal intla se itztos icalpani, ma cholo nimantzi. Ma ax temos huan calaquis calijtic para quihuicas se tlenijqui. Huan inijuanti tlen itztose ipan ininmil ma ax mocuepase ininchajchaj. ");
INSERT INTO nheNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xiquilnamiquica tlen ipantic isihua Lot. ");
INSERT INTO nheNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nojquiya nimechilhuía intla se momanahuisnequi para ax miquis nopampa, quipolos ialma. Huan ajqueya ax majmahui miquis nopampa, quimaquixtis ialma. ");
INSERT INTO nheNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Huan nimechilhuía, ipan nopa tlayohua, ome itztose ipan se tlapechtli, huan nijnahuatis notequipanojca ma quihuica se huan ne se ma quicajtehua nopona. ");
INSERT INTO nheNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Huan intla itztose ome sihuame tlen tisij san sejco, yajaya quihuicas se huan ne seyoc quicajtehuas. ");
INSERT INTO nheNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Huan ome tlacame tequititinemise ipan mili, huan notequipanojca no quihuicas se huan nopa seyoc quicajtehuas.” ");
INSERT INTO nheNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Huan inijuanti quitlajtlanijque: ―Tohueyiteco, ¿canque panos nochi ya ni? Huan Jesús quinnanquili: ―Queja nochi quiitaj quema mosentilíaj tzopilome campa huetztoc se mijcatzi, nochi quiitase ya ni. ");
INSERT INTO nheNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Huan Jesús quinilhui imomachtijcahua se huicaltili para quinnextilis cuali ma quisenhuiquilica momaijtoca ica Toteco hasta yajaya quinmacas tlen quitlajtlaníaj. ");
INSERT INTO nheNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Huan quinilhui: “Ipan se altepetl itztoya se juez tlen ax quitlepanitayaya Toteco huan ax quinchihuiliyaya cuenta tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nojquiya itztoya se cahual toahui ipan nopa altepetl huan yajaya ajachica quitlajtlaniyaya ma quitlajtolsencahua ica tlen fiero icualancaitacahua quichihuilijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Huan miyac huelta quitlajtlani nopa juez huan ax quinequiyaya quipalehuis, pero teipa nopa juez moilhui: ‘Yonque ax nijtlepanita Dios huan ax niquinchihuilía cuenta tlacame, ");
INSERT INTO nheNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","monequi nijchihuas tlen xitlahuac. Monequi nijtlajtolsencahuas queja tlen quinamiqui para ni cahual toahui. Yajaya tlahuel nechcuatotonía pampa ajachica huala nechtlajtlanía huan ya nechpastlami.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Huan Tohueyiteco quinilhui: “Xijmachilica quejatza nopa ax cual juez moilhui quema quiijto quipalehuis nopa cahual toahui. ");
INSERT INTO nheNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Huan Toteco achi más nimantzi quintlajtolsencahuas itlacajhua tlen quintlapejpenijtoc intla inijuanti momaijtohuaj tonaya huan yohuali. Yajaya ax quinilcahuas huan quiijtos para mostla quichihuas. ");
INSERT INTO nheNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nimechilhuía, nimantzi quinpalehuis. Pero quema na tlen niMocuepqui Tlacatl nimocuepas, ¿quesqui tlacame noja nechneltoquilise huan momaijtojtose ipan ni tlaltepactli?” ");
INSERT INTO nheNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Huan Jesús quinilhui ni huicaltili para tlacame tlen mohueyimatiyayaj. Moilhuiyayaj ya itztoyaj xitlahuaque iixtla Toteco, huan yeca quincocoliyayaj sequinoc pampa quinitayayaj para ax cuajcualme. Huan Jesús quiijto: ");
INSERT INTO nheNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ome tlacame yajque ipan hueyi tiopamitl para momaijtotij ica Toteco. Se eliyaya se fariseo huan seyoc se tlacatl tlen tlainanqui impuesto huan momatqui tlacajcayahua. ");
INSERT INTO nheNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Huan nopa fariseo moquetzqui huan momaijto huan quiijto: ‘Toteco Dios, nimitztlascamati pampa ax niitztoc queja sequinoc. Inijuanti tlaxtequij, momecatíaj huan quichihuaj tlen ax cuali. Nojquiya nipaqui pampa ax niitztoc queja ni tlacatl tlen nonechca itztoc tlen tlainama impuesto huan tlacajcayahua. ");
INSERT INTO nheNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Na nimosahua ompa ipan se samano huan nimitzmaca majtlactli por ciento tlen nochi tlen nijpiya.’ ");
INSERT INTO nheNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero nopa tlacatl tlen tlainanqui impuesto moquetzqui ica huejca huan mohuijtzonqui pampa mopinahuayaya quitlalanas itzonteco para quitlachilis elhuicac. Huan yajaya moyoltejtejtzonayaya ica cuesoli huan quiijto: ‘Toteco xinechtlasojtla pampa miyac nijhuica tlajtlacoli moixtla.’ ");
INSERT INTO nheNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Na nimechilhuía, Toteco quitlapojpolhui nopa tlacatl tlen tlainanqui impuesto huan yajaya yajqui ichaj xitlahuac iixtla Toteco, pero nopa fariseo, axtle. Pampa nochi tlen mohueyimatij, Toteco quinpinahualtis huan nochi tlen moicnonequij iixtla Toteco, Toteco quinhueyitlalis.” ");
INSERT INTO nheNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Huan sihuame quinhualicayayaj campa Jesús ininpilconehua para ma quintlalili ima ininpani para ma quintiochihua. Huan imomachtijcahua Jesús quinitaque huan quinajhuaque. ");
INSERT INTO nheNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús quinnotzqui imomachtijcahua huan quinilhui: ―Xiquincahuilica coneme ma hualaca campa na. Amo xiquintzacuilica, pampa Toteco quinnahuatis ipan ininyolo tlacame tlen nechselíaj queja ni coneme nechselíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Huan nelía nimechilhuía ajqueya ax quiselía Toteco huan ax quicahuilía ma quinnahuati ipan iyolo queja ni coneme quichihuaj, ax calaquis campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Huan hualajqui se tominpixquetl huan quitlajtlani Jesús: ―Ticuali tlamachtijquetl, ¿tlaque cuali monequi nijchihuas para Toteco ma nechmacas yolistli yancuic para nochipa? ");
INSERT INTO nheNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Huan Jesús quiilhui: ―¿Tijmati tlaque quiijtosnequi para tinechnotza nicuali? San Toteco Dios itztoc cuali. ");
INSERT INTO nheNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tijmati itlanahuatil Toteco: ‘Amo ximomecati, amo xitemicti, amo xitlaxtequi huan ax quema xiteistlacahui. Xiquintlepanita motata huan monana.’ ");
INSERT INTO nheNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Huan yajaya quiilhui Jesús: ―Nochi ya ni nijchijtihualajtoc hasta quema niconetzi nieliyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Huan quema Jesús quicajqui ni, quiilhui: ―Intla melahuac tlen tiquijtohua, san se tlamantli noja mitzpolohua. Xijnamacati nochi tlen moaxca huan xiquinmaca nopa tomi tlen teicneltzitzi huan queja nopa tijpiyas tlen ipati para moaxca nepa elhuicac. Huan teipa xihuala huan xinechtoquili. ");
INSERT INTO nheNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero quema nopa tlacatl quicajqui tlen Jesús quiilhui, pejqui mocuesohua pampa nelía quipixtoya tomi. ");
INSERT INTO nheNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Huan Jesús quitlachili huan quiijto: ―Nelía ohui para tlacame tlen tominpiyaj quicahuilise Toteco ma quinnahuati ipan ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ohui para se hueyi tlapiyali queja se camello ma pano ipan iixtiyol se huitzmalotl, pero noja más ohui para se tlacatl tlen tominpiya calaquis campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Huan inijuanti tlen quicajque quiilhuijque: ―Huajca ¿ajqueya huelis momaquixtis tlen itlajtlacolhua? ");
INSERT INTO nheNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Huan Jesús quinilhui: ―Nopa tlen tlacame ax hueli quichihuaj, Toteco quena, hueli quichihua. ");
INSERT INTO nheNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Huan Pedro quiilhui: ―Xiquita, tojuanti tijcajtejtoque nochi tlen tijpixtoyaj para timitztoquilise. ");
INSERT INTO nheNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Huan Jesús quinilhui: ―Nelía nimechilhuía nochi tlen quicajtejtoc ichaj, o isihua, o iicnihua, o itatahua o iconehua para quichihuas tlen Toteco quinahuatía, ");
INSERT INTO nheNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","quiselis miyac más ipan ni tonali huan ipan nopa tonali tlen huala, quipiyas yolistli tlen yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Huan Jesús quinhuicac nopa majtlactli huan ome imomachtijcahua iyoca huan quinilhui: “Xiquitaca, amantzi tiyohuij altepetl Jerusalén campa panos nochi tlen nopa tiocamanalohuani huejcajquiya tlajcuilojque para nopantis na tlen niMocuepqui Tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tlacame nechtemactilise ininmaco sejcoyoc ehuani huan nechhuihuiitase huan nechchihuilise tlen fiero. Nechchajchase, ");
INSERT INTO nheNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","huan nechhuijhuitequise huan nechmictise, pero ica eyi tonali nimoyolcuis.” ");
INSERT INTO nheNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Huan imomachtijcahua ax quimachilijque tlen quinilhuiyaya pampa Toteco quitlatiyaya tlen Jesús quiijtohuayaya para ma ax quimachilica. ");
INSERT INTO nheNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Huan quema Jesús monechcahuiyaya altepetl Jericó, itztoya nepa se popoyotzi tlen mosehuiyaya ojteno motlaejehuiyaya tlen ica panos. ");
INSERT INTO nheNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Huan quema nopa popoyotzi quincajqui nochi nopa miyac tlacame tlen panohuayayaj ihuaya Jesús, huajca quintlajtlani ajqueya huala. ");
INSERT INTO nheNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Huan tlacame quiilhuijque para hualayaya Jesús tlen ehua altepetl Nazaret. ");
INSERT INTO nheNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Huan huajca nopa popoyotzi chicahuac quiijto: ―¡Jesús, tiiixhui Tlanahuatijquetl David tlen huejcajquiya, xinechtlasojtla! ");
INSERT INTO nheNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Huan nopa tlacame tlen tlayacanayayaj quiajhuaque huan quiilhuijque ma ayoc molini, pero yajaya achiyoc chicahuac tzajtzic: ―¡Jesús tiiixhui David, xinechtlasojtla! ");
INSERT INTO nheNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Huan Jesús moquetzqui huan quinahuati se ma quihualiquili nopa popoyotzi. Huan quema ajsico, Jesús quitlajtlani: ");
INSERT INTO nheNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Tlaque tijnequi ma nimitzchihuili? Huan nopa tlacatl quiilhui: ―NohueyiTeco, nijnequi nitlachiyas sampa. ");
INSERT INTO nheNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Huan Jesús quiilhui: ―¡Xitlachiya! Ya timochicajtoc pampa tinechneltocac. ");
INSERT INTO nheNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Huan nimantzi huelqui tlachiya cuali, huan quitoquili Jesús ipan ojtli, quihueyichijtiyajqui Toteco Dios. Huan nochi nopa tlacame tlen quiitaque tlen panoc nojquiya quipaquilismacayayaj Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Huan Jesús calajqui ipan altepetl Jericó, pero san panotiquisato. ");
INSERT INTO nheNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Huan itztoya nopona se tlacatl tlen itoca eliyaya Zaqueo. Yajaya eliyaya se inintlayacanca nopa tlacame tlen tlainamayayaj impuesto huan quipixqui miyac tomi. ");
INSERT INTO nheNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Huan Zaqueo quichihuayaya campeca para quiitas Jesús, pero ax huelqui pampa itztoyaj miyac tlacame tlen quiyahualojtoyaj, huan Zaqueo eliyaya tlalchipantic. ");
INSERT INTO nheNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Huajca Zaqueo motlalo huan tlayacanqui huan tlejcoto ipan se cuahuitl para huelis quiitas Jesús quema panosquía ojtipa. ");
INSERT INTO nheNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Huan quema Jesús ajsico nopona, ajcotlachixqui ipan nopa cuahuitl huan quiitac Zaqueo huan quiilhui: ―Zaqueo, ximoisihuilti huan xitemo, pampa ama nimocahuas mochaj. ");
INSERT INTO nheNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Huajca moisihuilti huan nimantzi temoc, huan ica paquilistli quiseli Jesús ipan ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Huan quema tlacame quiitaque tlen panoc, pejque quitlaijilhuíaj Jesús pampa yajqui quipaxaloto se tlacatl tlen miyac tlajtlacoli quipixtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Huan teipa Zaqueo moquetzqui iniixtla nochi huan quiilhui Tohueyiteco: ―Xiquita, Tohueyiteco, ama nimoyolpatlatoc. Niquinmacas tlajco tlen nijpiya ica inijuanti tlen teicneltzitzi. Huan ica nochi tlen niquincajcayajtoc huan niquinquixtili más tomi tlen monequiyaya, niquincuepilis nahui huelta tlen niquinquixtili. ");
INSERT INTO nheNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Huan Jesús quinilhui nopa tlacame nopona: ―Ama nijmaquixti ni tlacatl tlen itlajtlacolhua pampa nechneltoquili queja nojquiya Abraham nechneltoquili. ");
INSERT INTO nheNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Na tlen niMocuepqui Tlacatl nihualajtoc ipan ni tlaltepactli para niquintemos huan niquinmaquixtis tlacame tlen mocuapolojtoyaj ipan inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Huan nochi nopa tlacame quicaquiyayaj. Huan Jesús quinilhui se tlatenpohualistli pampa monechcahuiyaya Jerusalén, huan miyac tlacame moilhuiyayaj monextis itlanahuatilis Toteco huan nimantzi Jesús pehuasquía tlanahuatis ipan ni tlaltepactli. Huan nopa tlacame quicaquiliyayaj tlen Jesús quiijtohuayaya huan yeca quinilhui se huicaltili. ");
INSERT INTO nheNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Huan Jesús quiijto: “Se tlacatl tlen itztoya ipan se familia tlen tlanahuatiani quisayaya para yas ipan seyoc tlali tlen huejca para quiselis tequihuejcayotl para tlanahuatis, huan teipa mocuepasquía. ");
INSERT INTO nheNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Huan achtohui quinnotzqui majtlactli itequipanojcahua huan quinmacac se sen imiyaca tomi queja se tlacatl quitlanis ipan eyi metztli tlen tequitl. Quinilhui ma tlacohuaca huan ma tlanamacaca para quitlanilise más tomi hasta yajaya mocuepas. ");
INSERT INTO nheNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero miyac tlacame nepa campa quisqui quicualancaitac nopa tlanahuatijquetl huan quititlanque se amatl tlasencahuali campa ajsiti huan nopa amatl quiijto: ‘Ax tijnequij para ni tlacatl ma technahuati.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Pero yonque ya nopa panoc, nopa tlanahuatijquetl quiseli tequihuejcayotl para tlanahuatis campa yajqui. Huan teipa se tonal mocuepqui itlal huan quinnahuati ma mosentilica nopa tlatequipanohuani tlen quintominmacatoya para quimatis quejatza quitequihuiyayaj itomi. ");
INSERT INTO nheNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Huan nopa tlatequipanojquetl tlen achtohui monexti, quiilhui: ‘Noteco, ica nopa tomi tlen tinechmacac ya nijtlantoc majtlactli huelta más imiyaca tomi.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Huan iteco quiilhui: ‘Cualtitoc, tinocual tlatequipanojca. Temachtli tiitztoya ica pilquentzi tomi tlen nimitzmacac, huan ama nimitztlalis xijnahuati majtlactli altepetini.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Huan nopa ompa tlatequipanojquetl monexti huan quiilhui: ‘Noteco, ica nopa tomi tlen tinechmacac, ya nijtlantoc macuili hueltas más imiyaca tomi.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Huan ihuical quiilhui nopa ompa tlatequipanojquetl huan nojquiya quiilhui: ‘Nimitztlalis xijnahuati macuili altepetini.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Huan seyoc itequipanojca hualajqui huan quiilhui: ‘Noteco, nicani eltoc nopa tomi tlen tinechmacac. Nicajcojqui ipan se payo. ");
INSERT INTO nheNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nimitzimacasiyaya intla nijpolojtosquía motomi ica tlanamaquilistli, pampa nijmati chicahuac titlanahuatía. Tijcui tomi tlen ax tijtlantoc huan tipixca campa ax titoctoc.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Huan iteco quiilhui: ‘Ta tifiero tlatequipanojquetl, nimitztlajtolsencahuas ica tlen tiquijtojtoc. Tijmatqui chicahuac nitlanahuatía. Nijcui tomi tlen ax nijtlantoc huan nipixca campa ax nitoctoc. ");
INSERT INTO nheNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Para tlen ax tijtlali notomi ipan se banco, huan quema nihualasquía, nopa banco nechtlaxtlahuijtosquía se quentzi itlapanca pampa quitequihuiyaya notomi?’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Huan nojquiya nopa tecojtli quinilhui nopa tlacame tlen ijcatoyaj nechca: ‘Xijquixtilica nopa tomi tlen nijmacac, huan xijmacaca yajaya tlen quitlanqui majtlactli huelta tlen quipixtoya.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Huan nopa tlacame quiilhuijque: ‘Toteco, yajaya quipixtojca majtlactli huelta más tomi.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Pero ininteco quinilhui: ‘Nimechilhuía, nochi tlen cuali quimati quejatza quitequihuise tlen quipiyaj, niquinmacas más, huan tlen ax quitequihuía tlen quipiyaj, yonque pilquentzi quipixque, niquinquixtilis nopa pilquentzi tlen quipixtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Huan nocualancaitacahua tlen ax quinequiyayaj ma niquinnahuatiqui, ama xiquinhualicaca huan xiquinmictica nica noixtla.’ ” ");
INSERT INTO nheNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Quema Jesús quinilhuijtoya ni huicaltili, sampa quiitzqui iojhui para Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Huan quema monechcahuiyaya altepetini Betfagé huan Betanía huan nopa tepetl tlen itoca Olivos, quintitlanqui ome imomachtijcahua ipan se tequitl, ");
INSERT INTO nheNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","quinilhui: ―Xiyaca nopa rancho tlen mocahua imoixmelac huan quema incalaquise nepa inquipantise se pilburrojtzi ilpitoc tlen aya aca tlejcotoc ipani. Xijtojtomaca huan xinechhualiquilica. ");
INSERT INTO nheNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Huan intla se acajya inmechtlajtlanis para tlen inquitojtomaj, nopa pilburrojtzi, huajca xiquilhuica: ‘Toteco quinequi quitequihuis.’ ");
INSERT INTO nheNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Huan nopa ome imomachtijcahua yajque huan nelía quipantijque nopa pilburrojtzi queja Jesús quinilhuijtoya. ");
INSERT INTO nheNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Huan quema quitojtomayayaj, nopa tecojtli quintlajtlani: ―¿Para tlen inquitojtomaj nopa pilburrojtzi? ");
INSERT INTO nheNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Huan inijuanti quiilhuijque: ―Toteco quinequi quitequihuis. ");
INSERT INTO nheNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Huan inijuanti quihuicaque campa Jesús huan quitlalilijque inintlaque ipan nopa burro huan Jesús ipan tlejcoc. ");
INSERT INTO nheNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Huan miyac tlacame quisohuayayaj inintlaque ipan ojtli campa Jesús nejnemiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Huan quema monechcahuijque campa itlaixtemolis nopa tepetl Olivos, nochi nopa miyac tlacame tlen quitoquiliyayaj pejque quipaquilismacaj Toteco ipampa nochi nopa chicahualnescayotl tlen quiitztoyaj Jesús quichihuayaya. Huan ica paquilistli, ");
INSERT INTO nheNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","inijuanti tlahuejchihuayayaj huan quiijtohuayayaj: “¡Ma Toteco Dios quitiochihua ni tlanahuatijquetl tlen huala ipan itoca ! Oncasa tlasehuilistli ica tojuanti huan Toteco tlen itztoc elhuicactli. ¡Ma tijhueyichihuaca Toteco Dios hasta tlacaquistis ipan elhuicac campa más huejcapa!” ");
INSERT INTO nheNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Huan sequin nopa fariseos tlen nejnemiyayaj ica nopa miyac tlacame quiilhuijque Jesús: ―Tlamachtijquetl, xiquinajhua momachtijcahua pampa quiijtohuaj tlamantli tlen ax quinamiqui. ");
INSERT INTO nheNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Huan Jesús quinnanquili: ―Nimechilhuía intla nomomachtijcahua ax molinisquíaj para nechhueyitlalisquíaj, huajca ni tetini camatisquíaj para nechhueyichihuasquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Huan quema Jesús monechcahui nepa Jerusalén, quitlachili nopa altepetl huan chocac ininpampa nopa tlacame tlen nopona itztoyaj, ");
INSERT INTO nheNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","huan quiijto: “InJerusalén ehuani, intla inquimachilisquíaj tlen pano ama ni tonali, inhueltosquíaj inquipantisquíaj tlasehuilistli. Pero tzactoc imoixtiyol. ");
INSERT INTO nheNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Huajca se tonal imocualancaitacahua hualase huan inmechyahualose huan inmechojtzacuase para axaca huelis cholos. ");
INSERT INTO nheNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Huan inijuanti quixolehuase imoaltepe huan inmechmictise nochi imojuanti tlen initztoque nica. Huan ax tleno mocahuas queja eltoya pampa ax inquichihuilijque cuenta quema nimechpaxaloco.” ");
INSERT INTO nheNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Huan Jesús calajqui ipan nopa hueyi israelita tiopamitl huan pejqui quintotoca nopa tlanamacani tlen itztoyaj calijtic. ");
INSERT INTO nheNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Huan quinilhui: ―Ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: ‘Nochaj eltoc nopa cali campa tlacame momaijtose ica Toteco.’ Pero inquichijtoque campa inquintlaxtequilíaj tlacame tlen hualahuij. ");
INSERT INTO nheNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Huan Jesús tlamachti mojmostla ipan nopa hueyi tiopamitl, pero quinequiyayaj quimictise nopa tlayacanca totajtzitzi, huan tlamachtiani tlen itlanahuatilhua Moisés, huan inijuanti tlen quihuicayayaj tequitl. ");
INSERT INTO nheNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero ax quimatiyayaj quejatza quichihuasquíaj pampa nochi tlacame nelía quisentlacaquiliyayaj ica tlen quiijtohuayaya. ");
INSERT INTO nheNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Se tonal Jesús tlamachtiyaya huan quiixtomayaya icual tlajtol Toteco ipan nopa hueyi israelita tiopamitl, huan hualajque nopa tlayacanca totajtzitzi, huan tlamachtiani tlen itlanahuatil Moisés huan nopa huehue tlacame tlen israelitame para quitlajtlanise. ");
INSERT INTO nheNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Huan quiilhuijque: ―Xitechilhui ica tlaque tequihuejcayotl tijchihua ni tlamantli. ¿Ajqueya mitzmacatoc tequihuejcayotl? ");
INSERT INTO nheNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Huan Jesús quinnanquili: ―Na nojquiya nimechtlajtlanis se tlamantli. Xinechnanquilica ya ni. ");
INSERT INTO nheNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ajqueya quititlanqui Juan para tecuaaltis? ¿Toteco quititlanqui o san tlacame quititlanque? ");
INSERT INTO nheNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Huajca inijuanti iyoca pejque mocamahuíaj quejatza quinanquilisquíaj. Quiijtojque: “Intla tiquijtose Toteco quititlanqui Juan, huajca technanquilis ¿para tlen ax tijneltocaque itlajtol? ");
INSERT INTO nheNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Pero intla tiquijtose san tlacame quititlanque, nochi ni tlacame techtepachose pampa inijuanti quineltocaj para Juan eliyaya se itiocamanalojca Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Huan yeca inijuanti quinanquilijque, huan quiilhuijque ax quimatiyayaj ajqueya quititlanqui Juan. ");
INSERT INTO nheNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Huan Jesús quinilhui: ―Huajca na nojquiya ax nimechilhuis ajqueya nechmacatoc tequihuejcayotl para nijchihuas nochi ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Huan Jesús pejqui quinilhuía ni huicaltili, quiijto: “Itztoya se tlacatl tlen quitojqui xocomecatl ipan imil huan quincahuilijtejqui ininmaco sequin tlacame para ma quimocuitlahuica huan teipa moajachihuisquíaj tlen temacasquía nopa mili. Huan teipa nopa tlacatl yajqui huejca. ");
INSERT INTO nheNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Huan teipa quema ajsic tonali para tlatequistli, nopa tecojtli quititlanqui se itequipanojca ma quinitati nopa tlacame para ma quimacaca tlen ya iaxca tlen nopa tlatequistli. Pero nopa tlacame tlen ininmaco eltoya nopa mili quimaquilijque itequipanojca huan san imacajya quimacajque. ");
INSERT INTO nheNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Huajca nopa tlacatl tlen iaxca nopa mili sampa quititlanqui seyoc itequipanojca, huan nojquiya quimaquilijque, huan fiero quichihuilijque huan ax tleno quimacaque. ");
INSERT INTO nheNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Huan ica expa nopa tlacatl sampa quititlanqui seyoc itequipanojca, huan nopa tlacame quicocojque huan quitotocaque. ");
INSERT INTO nheNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Huan nopa tlacatl tlen iaxca nopa xocomeca mili moilhui: ‘Nijmajtojca tlaque nijchihuas. Nijtitlanis notelpoca tlen niquicnelía huan temachtli quitlepanitase.’ ");
INSERT INTO nheNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero quema nopa tlacame tlen ininmaco eltoya nopa mili quiitaque nopa telpocatl, huajca moilhuijque se ica seyoc: ‘Yajaya ni tlen teipa quiselis ni xocomeca mili. Ma tijmictica huan teipa ni mili elis toaxca.’ ");
INSERT INTO nheNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Huajca inijuanti quihuahuatatzque xocomeca milteno huan quimictijque. “Huajca ¿tlaque inmoilhuíaj quichihuas nopa tlacatl tlen iaxca nopa xocomeca mili ica nopa fiero tlacame? ");
INSERT INTO nheNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Yajaya hualas huan quinmictis huan quicahuas imil ininmaco sequinoc.” Huan quema nopa fariseos quicajque ni, quimatque para inijuanti eliyayaj nopa fiero tlacame ipan nopa huicaltili, huajca quiilhuijque Jesús: ―¡Toteco ma amo quicahuili ma pano ya nopa! ");
INSERT INTO nheNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Huan Jesús quintlachili huan quintlajtlani: ―Huajca ¿tlaque quiijtosnequi tlen ijcuilijtoc ipan Itlajtol Toteco campa camati tlen na queja nieli se hueyi tetl? Queja ni quiijtohua: ‘Calchihuani ax quinejque quitequihuise se hueyi tetl, huan quimajcajque. Pero teipa nopa hueyi tetl tlen quimajcajtoyaj, elqui tlen más monequiyaya para yas calnacastla huan ipan quiquetzase nopa cali.’ ");
INSERT INTO nheNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Na nieli nopa hueyi tetl huan nochi tlen ax nechnequij itztoque queja tlen motilose huan huetzise ipan nopa hueyi tetl, huan tlahuel mococose. Huan quema niquinpanajsis tlen ax nechselíaj, huajca niquinchihuas xacualtic. ");
INSERT INTO nheNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Huan ipan nopa tonali nopa tlamachtiani tlen itlanahuatil Moisés huan nopa tlayacanca totajtzitzi quimachilijque para inijuanti nopa fiero tlacame ipan nopa tlatenpohualistli. Huan yeca quinequiyayaj quiitzquise Jesús, pero quinimacasiyayaj nopa miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Huajca san quintitlanque tlacame para ma quitlachilijtinemica para quicaquisquíaj se tlajtoli tlen ica quiteilhuisquíaj Jesús iixtla nopa gobernador. ");
INSERT INTO nheNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Huan se tlen inijuanti quitlajtlani Jesús: ―Tlamachtijquetl, tojuanti tijmatij tiquijtohua huan titlamachtía tlen xitlahuac huan axaca tijchicoicnelía. San titlamachtía tlen melahuac quinequi Toteco Dios ma tijchihuaca. ");
INSERT INTO nheNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Huajca ¿tiquita cuali tiquixtlahuase tlen techtlajtlanía totlanahuatijca César o axtle? ");
INSERT INTO nheNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Huan Jesús momacac cuenta quinequiyayaj quimasiltise ica itlajtol, huajca quinilhui: ―¿Para tlen inquinequij innechcajcayahuase? ");
INSERT INTO nheNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Xinechnextilica se tomi ica tlen intlaxtlahuasquíaj nopa impuesto. ¿Ajqueya iixcopinca eltoc ipan ni tomi? Huan ¿ajqueya itoca ijcuilijtoc ipani? Huan inijuanti quinanquilijque: ―Iixcopinca huan itoca Tlanahuatijquetl César. ");
INSERT INTO nheNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Huan Jesús quinilhui: ―Huajca xijmacaca César tlen iaxca huan nojquiya xijmacaca Toteco tlen Toteco iaxca. ");
INSERT INTO nheNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Huan ax huelque quicajcayajque Jesús o quimasiltise ica tlen quiijto iniixtla nopa tlacame. San mosentlachilijque, huan ayoc molinijque. ");
INSERT INTO nheNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Huan hualajque campa Jesús sequin saduceos. Inijuanti ax quineltocaj para sampa moyolcuise mijcatzitzi. ");
INSERT INTO nheNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Huan nopa saduceos quiilhuijque: ―Tlamachtijquetl, Moisés quiijcuilo huejcajquiya intla se tlacatl miquis huan ax quicajtehuas niyon se conetl, huajca iteipa ejca icni nopa mijcatzi monequi mosihuajtis ihuaya ihuejpol para quipiyase se conetl tlen elis queja icone yajaya tlen mijqui huan quimacas iteipa ixhuihua. ");
INSERT INTO nheNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Itztoyaj chicome icnime huan nopa tlen achtohui ejquetl mosihuajti huan teipa mijqui, huan ax quipixqui niyon se conetl. ");
INSERT INTO nheNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Huan nopa ompa tlacatl mosihuajti ica nopa toahui huan nojquiya mijqui huan ax quinpixqui coneme. ");
INSERT INTO nheNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Huan nopa expa tlacatl mosihuajti ihuaya huan queja nopa panotiyajqui hasta nochi chicome icnime mosihuajtijque ihuaya nopa sihuatl huan ax quipixtoyaj ininconehua. ");
INSERT INTO nheNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Huan teipa nojquiya mijqui nopa sihuatl. ");
INSERT INTO nheNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Huajca ipan nopa tonali quema moyolcuise nochi tlen mictoque, ¿ajqueya tlen inijuanti quipiyas nopa sihuatl para iaxca? pampa nochi chicome quipixtoyaj para ininsihua. ");
INSERT INTO nheNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Huan Jesús quinilhui: ―Ipan ni tonali nica ipan ni tlaltepactli tlacame mosihuajtíaj, huan quisencahuaj para iniichpocahua ma monamictica. ");
INSERT INTO nheNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero quema tlacame moyolcuise huan inijuanti tlen quinamiqui calaquise elhuicac, ayoc mosihuajtis huan ayoc quisencahuase para iniichpocahua ma monamictica para quintlacatiltise coneme, ");
INSERT INTO nheNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","pampa nepa ayoc aca miquis. Nochi itztose queja ielhuicac ejcahua Toteco, tlen ax miquij huan ax monamictíaj. Huan itztose iconehua Toteco tlen yajaya quinyolcuic para itztose para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero quena, mijcatzitzi moyolcuij pampa Moisés technextili para noja yoltoque tlen mictoyaj campa quiijcuilo queja quiitac nopa xihuitzontli tlen tlatlayaya huan Toteco quiilhui: ‘Na niininteco Abraham, Isaac huan Jacob.’ ");
INSERT INTO nheNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Huan pampa Toteco quiijto yajaya noja eliyaya ininTeco Abraham, Isaac huan Jacob yonque inijuanti ya mictoyaj huejcajquiya quema quiijto nopa tlajtoli, huajca tijmatij inijuanti noja yoltoque nepa elhuicac iixtla Toteco, pampa iixtla Toteco nochi yoltoque. ");
INSERT INTO nheNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Huan sequin nopa tlamachtiani tlen itlanahuatilhua Moisés quiilhuijque: ―Tlamachtijquetl, nelía cuali tijnanquili. ");
INSERT INTO nheNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pero axaca mosemacac para más quitlajtlanis. ");
INSERT INTO nheNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Huajca Jesús quintlajtlani: ―¿Para tlen tlacame quiijtohuaj para nopa Cristo tlen Toteco quiijto hualasquía elis se iteipa ixhui Tlanahuatijquetl David tlen huejcajquiya? ");
INSERT INTO nheNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pampa David iselti quinotzqui Cristo ‘noTeco’ ipan Salmos campa quiijcuilo: ‘Toteco Dios quicamahui noTeco Cristo huan quiilhui: Ximosehui nica nonejmatl, ");
INSERT INTO nheNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta nimitzmactilis mocualancaitacahua para tiquinnahuatis.’ ");
INSERT INTO nheNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Huajca Tlanahuatijquetl David quinotzqui Cristo ‘noTeco’ huan ya nopa technextilía Cristo yajaya Tecojtli, yonque nelía yajaya nojquiya se iixhui David. ");
INSERT INTO nheNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Huan quema nochi nopa tlacame quitlacaquiliyayaj, Jesús quinilhui imomachtijcahua: ");
INSERT INTO nheNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ximomocuitlahuica ica nopa tlamachtiani tlen itlanahuatilhua Moisés tlen quinpactía moquentise ininyoyo huejhuehueyac. Quinpactía quema tlacame quintlajpalohuaj ica cuali ipan tianquis. Huan inijuanti quinequij mosehuise ipan nopa sillas tlen más quipiya tlatlepanitacayotl huan quinequij tlacuase achtohui ipan se tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pero iyoca inijuanti quinquixtilíaj ininchajchaj cahual toahuime. Huejcahuaj quema momaijtohuaj ica Toteco para sequinoc ma quintlepanitaca, pero san tlacajcayahuaj, huajca achi más Toteco quintlatzacuiltis que sequinoc.” ");
INSERT INTO nheNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Huan nopona tiopan calijtic Jesús quintlachiliyaya quejatza tlacame tlen tominpixque quitlaliyayaj inintomi ipan nopa caja para quimacase Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Huan nojquiya quiitac se cahual toahui tlen nelteicneltzi quitenqui ome centavos. ");
INSERT INTO nheNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Huan Jesús quiijto: ―Nelía nimechilhuía ni cahual toahui tlen teicneltzi quimacatoc Toteco más tlen nochi ne sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pampa nochi inijuanti quimacaque tlen ax quitequihuíaj, pero yajaya nelía teicneltzi, huan quimacatoc Toteco nochi tlen quipixtoya para ica mopanoltisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Huan itztoyaj sequin tlen camatiyayaj tlen iyejyejca nopa hueyi tiopamitl huan tlen nopa yejyectzi tetl tlen quipixtoya huan nochi más tlen tlacame temacatoyaj para ma quisencahuaca. Huan Jesús quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Ajsis se tonal quema tlacame quixolehuase nochi ni tlamantli yejyectzi tlen ama inquitlachilíaj, huan niyon se tetl ax mocahuas campa eltoya. ");
INSERT INTO nheNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Huan inijuanti quitlajtlanijque: ―Tlamachtijquetl, ¿quema panos nopa tlamantli? ¿Tlaque tlanescayotl quiitase tlacame para quimatise monechcahuía para panos ni tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Huan Jesús quinilhui: “Ximomocuitlahuica. Ma axaca inmechcajcayahuas pampa miyac tlacame hualase huan quiijtose para najaya. Quiijtose: ‘Na niCristo’, huan ‘Ya ajsic hora’, pero amo xiquintoquilica. ");
INSERT INTO nheNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Huan inquicaquise para oncas tlatehuijcayotl huan para miyac tlahuel mosentlanchihuaj, pero amo ximajmahuica pampa achtohui monequi panos nochi ni tlamantli, pero noja polihuiyoc para tlamis tlaltepactli.” ");
INSERT INTO nheNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Huan Jesús noja quincamahui huan quinilhui: “Tlacame ipan se tlali motlalanase huan quintehuise tlen itztoque ipan seyoc tlali. Tlanahuatiani motehuise ininhuaya sequinoc tlanahuatiani huan ininsoldados. ");
INSERT INTO nheNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Huan campa hueli tlahuel mojmolinis tlali, huan oncas hueyi mayantli, huan huejhueyi cocolistli. Huan ipan elhuicac tlacame quiitase hueyi tlanescayotl huan tlamantli tlen quinmajmatis. ");
INSERT INTO nheNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pero achtohui, quema noja polihui nochi ni tlamantli, tlacame inmechitzquise huan inmechtlaijiyohuiltise. Huan inmechtemactilise iniixtla tequihuejme ipan tiopantini, huan inmechtzacuase. Huan inmechhuicase iniixtla tlanahuatiani huan gobernadores para inmechteilhuise pampa innechneltoquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Huan queja nopa huelis inquinpohuilise tlen na. ");
INSERT INTO nheNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Huan amo ximoilhuica quejatza inquinnanquilise o quejatza inmomanahuise, ");
INSERT INTO nheNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","pampa ipan nopa hora na nimechmacas tlalnamiquistli huan nimechmacas nopa tlajtoli tlen monequi inquinilhuise, huan niyon se imocualancaitaca ax huelis inmechnanquilis. ");
INSERT INTO nheNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Huan hasta imotatahua, o imoicnihua, o imochampoyohua o imohuampoyohua inmechtemactilise ica ax cuajcualme. Huan inijuanti quinmictise sequin tlen imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Huan nochi tlacame inmechcualancaitase pampa innechneltoquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero ax tleno huelis inmechchihuilise, niyon ax inquipolose niyon se imotzoncal. ");
INSERT INTO nheNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Huan intla inquipiyase imoyolo huan inquiijiyohuise, inmomaquixtise. ");
INSERT INTO nheNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Pero quema inquiitase soldados tlen miyac tlaltini quiyahualojtose ni altepetl Jerusalén, huajca ximomacaca cuenta ya ajsico hora para quixolehuase. ");
INSERT INTO nheNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Huajca ipan nopa hora, inijuanti tlen itztoque ipan estado Judea ma choloca ipan tepetini. Huan inijuanti tlen itztoque ipan altepetl Jerusalén ma quisaca. Huan inijuanti tlen itztoque ipan mili ma ax mocuepaca para calaquise ipan nopa altepetl, ");
INSERT INTO nheNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","pampa ipan nopa tonali Toteco nelía quintlatzacuiltis tlacame icualancayo. Huan nochi panos queja ijcuilijtoc ma pano. ");
INSERT INTO nheNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Teicneltique sihuame tlen tlanemiltise huan tlen quinchichitise coneme ipan nopa tonali pampa ohui cholose. Huan oncas hueyi tlaijiyohuilistli ipan ni tlali, huan Toteco quintlatzacuiltis tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Huan tlacame quinmictise sequin ica machetes huan sequinoc quinhuicase hasta tlen hueli tlaltini ipan tlaltepactli para ma quintequipanose san tlapic. Huan tlen ax israelitame ipan moquejquetzase altepetl Jerusalén. Huan quichihuilise tlen quinequise hasta tlamis nopa tonali tlen Toteco quitlalijtoc para sejcoyoc ehuani ma tlatlanica. ");
INSERT INTO nheNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Huan teipa oncas tlanescayotl ipan tonati huan ipan metztli huan ipan sitlalime huan ipan tlaltepactli. Huan tlacame ax quimatise tlaque quichihuase pampa nelnelía momajmatise. Huan tlahuel majmahuise pampa nelajcahuacas huan motlalanas hueyi atl huan chicahuac mojmolinis. ");
INSERT INTO nheNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Huan tlacame tlapolose pampa tlahuel majmahuise ica nochi tlen quiitase huala ipan ni tlaltepactli, pampa quiitase para huihuipicas tonati, metztli huan sitlalime huan nochi tlen eltoc ipan elhuicactli. ");
INSERT INTO nheNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Huan huajca quena, nechitase na tlen niMocuepqui Tlacatl nihualasoc ipan se mixtli, huan nijpiyas hueyi chicahualistli, huan ica notlatlanex tlen tlahuel yejyectzi. ");
INSERT INTO nheNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Huajca quema pehuas mochihuas nochi ni tlamantli, ximoyolchicahuaca huan xiajcotlachiyaca ica paquilistli pampa nechcatzi para nihualas huan nimechmaquixtis.” ");
INSERT INTO nheNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Huan nojquiya Jesús quinilhui se huicaltili: “Ximoilhuica queja pano ica se higuera cuahuitl huan nochi sequinoc cuatini. ");
INSERT INTO nheNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Quema nopa cuatini moseliltía, huajca nimantzi inquimatij ajsisa tlatotonilotl. ");
INSERT INTO nheNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Huajca nojquiya quema inquiitase panotos nochi ni tlamantli, xijmatica nechcatitoc para Toteco tlanahuatis ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Huan nimechilhuía para ax miquise nopa tlacame tlen quiitase ni tlanextili hasta nihualas. ");
INSERT INTO nheNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Elhuicactli huan tlaltepactli panotehuas, pero notlajtol nochipa motlamichijtiyas. ");
INSERT INTO nheNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ximomocuitlahuica. Nopa tonal ma ax inmechpantiqui ipan tlajtlacoli. Niyon ma ax nimechpantiqui inihuintitoque, yon ma nimechpantiqui inmocuatotonijtoque ica tlamantli tlen ni nemilistli nica, pampa intla san ya nopa inmoilhuíaj, ax inmocualtlalijtose, huan nopa tonal nimantzi inmechajsis queja se tlaquetztli. ");
INSERT INTO nheNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Huan nopa tonal nimantzi quinajsis nochi tlacame tlen itztose campa hueli ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pero ximocualchijchijtoca mojmostla para quema nihualas. Xijtlajtlanica Toteco Dios para ax monequi inpanose ipan nochi nopa tlamantli tlen hualas huan para huelis inmoquetzase noixpa na tlen niMocuepqui Tlacatl.” ");
INSERT INTO nheNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Huan mojmostla quema tonaya Jesús tlamachtiyaya ipan hueyi israelita tiopamitl huan ica tlayohua quisayaya para toniliti ipan nopa tepetl tlen itoca Olivos. ");
INSERT INTO nheNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Huan tlahuel miyac tlacame mehuayayaj cualca para yase ipan nopa hueyi israelita tiopamitl para quitlacaquilise. ");
INSERT INTO nheNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Huan monechcahuiyaya nopa ilhuitl tlen itoca Pascua quema quicuaj pantzi tlen ax quipiya tlasonejcayotl. ");
INSERT INTO nheNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Huan nopa tlayacanca totajtzitzi huan tlamachtiani tlen itlanahuatil Moisés quitemoliyayaj quejatza huelis quimictise Jesús, pero quinimacasiyayaj nopa miyac tlacame tlen quitoquiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Huan Axcualtlacatl calajqui ipan iyolo Judas Iscariote tlen eltoya se tlen nopa majtlactli huan ome imomachtijcahua Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Huan Judas yajqui quincamahuito nopa tlayacanca totajtzitzi huan ininteco nopa soldados ipan tiopamitl, huan quisencajqui ininhuaya quejatza huelis quinmactilis Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Huan inijuanti paquiyayaj ica itlapalehuil Judas huan quiijtojque quitlaxtlahuise. ");
INSERT INTO nheNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Huan Judas quipacti tlen quiijtojque huan yajaya pejqui quitemohua quejatza huelis quinmactilis Jesús quema ax aquise miyac tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Huan ajsic nopa tonal para quicuase pantzi tlen ax quipiya tlasonejcayotl, huan para quimictise nopa pilborregojtzi para Pascua. ");
INSERT INTO nheNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Huan Jesús quintitlanqui Juan ihuaya Pedro huan quinilhui: ―Xiyaca huan xijsencahuaca nopa Pascua tlacualistli para nochi tojuanti titlacuatij. ");
INSERT INTO nheNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Huan inijuanti quiilhuijque: ―¿Canque tijnequi ma tijsencahuatij? ");
INSERT INTO nheNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Huan Jesús quinilhui: ―Xiquitaca, quema incalaquise ipan nopa altepetl, inquinamiquise se tlacatl tlen quihuica iajcolpa se comitl atl. Xijtoquilijtiyaca hasta nopa cali campa calaquis. ");
INSERT INTO nheNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Huan nepa inquiilhuise tlen iaxca nopa cali: ‘Nopa tlamachtijquetl quiijtohua ma timitztlajtlaniquij, ¿canque eltoc nopa hueyi cuarto campa quicuas nopa Pascua tlacualistli ihuaya imomachtijcahua?’ ");
INSERT INTO nheNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Huan yajaya inmechnextilis se cali tlen itzonpac eltoc se hueyi cuarto, huajca nepa xijsencahuaca nopa tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Huan inijuanti quisque huan quipantijque nochi queja Jesús quinilhuijtoya huan nopona quisencajque nopa Pascua tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Huan quema ajsic hora, Jesús ajsico ica nochi imomachtijcahua huan mosehuijque campa mesa. ");
INSERT INTO nheNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Huan Jesús quinilhui: ―Nelía miyac nijnequiyaya nijcuas ni Pascua tlacualistli imohuaya pampa ayoc miyac polihui para nitlaijiyohuis huan nimiquis. ");
INSERT INTO nheNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nimechilhuía, ax nijcuas sampa hasta tiitztose nepa campa Toteco tlanahuatía huan ya panotos nochi tlen quinextía ni tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Huan Jesús quicuic se taza ica xocomecatl iayo huan quitlascamatqui Toteco huan quiijto: ―Xiquica ipan ni taza huan ximomajmacaca nochi imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Pampa nimechilhuía, ax niquis xocomeca atl sampa hasta nopa tonali quema tlanahuatis Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Huan quiitzqui se pantzi huan quitlascamatqui Itata Dios. Huan quitlapanqui huan quinmajmacac imomachtijcahua huan quinilhui: ―Ni notlacayo tlen nitemactilis imopampa. Xijchihuaca ya ni para inquinescayotise innechilnamiquij. ");
INSERT INTO nheNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Huan quema tlacuajtoyajya, sampa quichijqui san se huan quiitzqui se taza huan quinilhui: ―Ni noeso. Ica noeso tlen nijtoyahuas imopampa nijpehualtis itequihuejcayo nopa yancuic tlajtolsencahuali ica tlacame huan Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero xiquitaca, yajaya tlen nechtemactilis tlacua nohuaya ipan ni mesa. ");
INSERT INTO nheNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Quena, na tlen niMocuepqui Tlacatl nimiquis pampa queja nopa Toteco quitlalijtoc, pero teicneltic nopa tlacatl tlen nechtemactilis pampa tlahuel tlaijiyohuis. ");
INSERT INTO nheNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Huan imomachtijcahua pejque mocamahuíaj ajqueya quitemactilisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Huan imomachtijcahua Jesús nojquiya pejque monajnanquilíaj ajqueya elisquía más hueyi iixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Huan Jesús quinilhui: “Tlanahuatiani nica ipan ni tlaltepactli tlahuel tlanahuatíaj chicahuac huan yonque ya nopa quichihuaj inintlacajhua monequi quinnotzaj ‘cuali tecojme’. ");
INSERT INTO nheNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero ax queja nopa inmochihuase inhuejhueyi iixpa Toteco. Aqui tlen imojuanti tlen quinequi elis más hueyi, monequi mochihuas queja se tlen más telpocatl tlen nochi. Huan ajqueya quinequi elis imotlayacanca, ma eli inmotequipanojca. ");
INSERT INTO nheNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ajqueya inquiitaj para más hueyi, yajaya tlen mosehuía campa mesa o yajaya tlen quintequipanohua? Inmoilhuíaj yajaya tlen mosehuía achi hueyi. Pero xiquitaca na ax nimohueyimati. Huan na niitztoc imohuaya queja niimotequipanojca. ");
INSERT INTO nheNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Imojuanti initztoque tlen inmocajtoque nohuaya quema nijpanotoc tlaohuijcayotl. ");
INSERT INTO nheNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huan yeca nimechmacas tequihuejcayotl para intlanahuatise queja Notata nechmacatoc tequihuejcayotl nitlanahuatis. ");
INSERT INTO nheNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Huan intlacuase nohuaya campa na nitlanahuatis huan nimechsehuis ipan siyas tlen yejyectzi para inquintlajtolsencahuase nopa majtlactli huan ome huejhueyi familias tlen israelitame.” ");
INSERT INTO nheNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Huan nojquiya Toteco quiilhui Pedro: ―Simón, Simón, ximomocuitlahui. Axcualtlacatl ya tlajtlanqui mano para mitzyejyecos huan mitztzejtzelos queja se tlen quitzejtzelohua trigo, ");
INSERT INTO nheNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pero nimomaijtojtoc ica Toteco para ax tijcahuas tinechneltoquilis. Huan teipa quema timoyolpatlas ica tlen ax cuali tijchijtoc, xiquinyolchicahua ni moicnihua huan xiquinmaca tetili. ");
INSERT INTO nheNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Huan Simón Pedro quiilhui: ―Tohueyiteco, nimocahuas mohuaya yonque nechtzacuase o nechmictise. ");
INSERT INTO nheNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Huan Jesús quiilhui: ―Nimitzilhuía Pedro, ax tzajtzis se cuapelech ica ijnaloc hasta expa tiquijtos para ax tinechixmati. ");
INSERT INTO nheNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Huan Jesús quinilhui nochi imomachtijcahua: ―Quema nimechtitlanqui huan nimechilhui amo xijhuicaca tomi, niyon morral, niyon tecactli, ¿tlaque inmechpolo? Huan quinanquilijque: ―Ax tleno techpolo. ");
INSERT INTO nheNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Huan Jesús quinilhui: ―Pero ama, nimechilhuía intla inquipiyaj tomi, xijhuicaca. Huan nojquiya xijhuicaca se morral. Huan intla se ax quipiya se machete, ma quinamaca itlaque huan ma quicohua. ");
INSERT INTO nheNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pampa nimechilhuía, ama tlamis tlen quiijcuilojque huejcajquiya tlen na campa quiijtohua: ‘Tlacame quiitase queja se tlen ax cuali pampa quitlalise ininhuaya ax cuajcualme.’ ");
INSERT INTO nheNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Huan inijuanti quiijtojque: ―Tohueyiteco, xiquita nica tijpiyaj ome machetes. Huan Jesús quiijto: ―Ya cuali. ");
INSERT INTO nheNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Huan Jesús quisqui huan yajqui campa nopa tepetl tlen itoca Olivos queja ya momajtoya, huan imomachtijcahua quitoquilijque. ");
INSERT INTO nheNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Huan quema ajsitoj nepa, quinilhui: ―Ximomaijtoca ica Toteco para ax inmechyoltilanas tlajtlacoli. ");
INSERT INTO nheNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Huan yajaya sampa moiyocaquixti, huan motlancuaquetzqui, huan pejqui momaijtohua, ");
INSERT INTO nheNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","huan quiijto: “Papá, intla ta mopaquilis, xinechquixtili ni hueyi tlaijiyohuilistli tlen huala, pero amo xijchihua tlen na nijnequi, san xijchihua tlen ta mopaquilis.” ");
INSERT INTO nheNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Huan hualajqui se elhuicac ejquetl tlen elhuicac huan quimacac fuerza. ");
INSERT INTO nheNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús nelía tlaijiyohuiyaya huan chicahuac momaijtohuayaya. Mitoniyaya miyac huan iitonal elqui queja estli tlen chipiniyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Huan quema tlantoya momaijtohua, moquetzqui huan mocuepqui campa itztoyaj imomachtijcahua. Huan quinpantito cochtoque pampa tlahuel tlaxicohuayayaj pampa tlahuel mocuesohuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Huan Jesús quinilhui: ―¿Para tlen incochtoque? Ximoquetzaca huan ximomaijtoca para ax intlajtlacolchihuase. ");
INSERT INTO nheNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Huan quema Jesús noja quincamahuiyaya, ajsicoj miyac tlacame. Huan Judas se imomachtijca quinyacanayaya. Huan yajaya monechcahui campa Jesús huan quitzoponi. ");
INSERT INTO nheNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Huan Jesús quiilhui: ―Judas, ¿ta tinechtzoponi para tinechtemactilis na tlen niMocuepqui Tlacatl? ");
INSERT INTO nheNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Huan inijuanti tlen itztoyaj ihuaya Jesús quiitaque tlen panoyaya huan huajca quitlajtlanijque: ―Tohueyiteco, Tohueyiteco, ¿tijnequi ma titlatehuica ica tomachete? ");
INSERT INTO nheNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Huan se tlen itztoya ihuaya Jesús, quimaquili itequipanojca nopa hueyi totajtzi huan quitequili inacas tlen inejmatl. ");
INSERT INTO nheNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Huan Jesús quinilhui: ―¡Xijcahua! Ayoc xitlatehui. Huan Jesús quiitzqui inacas huan quichicajqui. ");
INSERT INTO nheNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Huan hualajtoyaj nopa tlayacanca totajtzitzi huan inintecohua nopa soldados ipan nopa hueyi israelita tiopamitl huan nopa huehue tlacame tlen israelitame. Huan Jesús quinilhui: ―¿Para tlen inhualajtoque nica para innechitzquise ica machetes huan ica cuahuitl queja nielisquía se nitlaxtejquetl? ");
INSERT INTO nheNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mojmostla niitztoya imohuaya ipan nopa hueyi tiopamitl, huan ax quema innechitzquijque. Pero nelía ni hora imoaxca huan iaxca Axcualtlacatl tlen quipiya chicahualistli para tlanahuatis ipan tzintlayohuilotl. ");
INSERT INTO nheNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Huan inijuanti quiitzquijque Jesús, huan quihuicaque hasta ichaj nopa hueyi totajtzi huan Pedro quitoquili ica huejca. ");
INSERT INTO nheNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Huan tlacame tlipitztoyaj tlajco calixpa pampa tlaseseyayaya huan mosehuijque san sejco. Huan Pedro nojquiya mosehuito ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Huan se sihua tlatequipanojquetl quiitac Pedro mosehuiyaya tliteno huan quitlachili huan quiijto: ―Ni tlacatl nojquiya itztoya ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Huan Pedro quiijto para axtle. Quiilhui: ―Nane, ax niquixmati. ");
INSERT INTO nheNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Huan quentzi teipa seyoc quiitac huan quiijto: ―Ta tiitztoya se tlen quitoquili Jesús. Huan Pedro quiijto: ―¡Axtle, Tate! ¡Ax na! ");
INSERT INTO nheNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Huan panoc se hora huan seyoc tlacatl quiijto: ―Temachtli ni tlacatl nejnenqui ihuaya pampa yajaya se Galilea ejquetl nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Huan Pedro quiijto: ―Tate, ax nijmati tlaque tiquijtohua. Huan nimantzi quema noja camatiyaya Pedro, tzajtzic se cuapelech. ");
INSERT INTO nheNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Huan Tohueyiteco moicancuepqui huan quitlachili. Huan Pedro quiilnamijqui tlen Tohueyiteco quiilhuijtoya: “Ax tzajtzis se cuapelech ica ijnaloc hasta tiquijtos expa para ax tinechixmati.” ");
INSERT INTO nheNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Huan Pedro quisqui calteno huan tlahuel mochoquili. ");
INSERT INTO nheNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Huan nopa soldados tlen quimocuitlahuiyayaj Jesús quihuihuiitayayaj huan quimaquiliyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Huan quiixtzajque huan quitlajtlanijque: ―Ta tiocamanalojquetl, xitechilhui, ¿catlía tlen tojuanti timitzmaquilíaj? ");
INSERT INTO nheNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Huan quiilhuiyayaj miyac tlamantli tlen fiero. ");
INSERT INTO nheNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Huan quema tlanesqui, mosentilijque nopa huehue tlacame tlen quihuicayayaj tequitl ipan tlali Israel, huan nopa tlayacanca totajtzitzi huan nopa tlamachtiani tlen itlanahuatil Moisés. Huan quihuicaque Jesús iniixtla nopa tlasentilistli tlen más quipixqui tlanahuatili. Huan nopa tlacame quitlajtlanijque: ");
INSERT INTO nheNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Intla ta tiCristo tlen Toteco techilhui techtitlanilisquía, huajca xitechilhui. Huan Jesús quinilhui: ―Intla nimechilhuisquía, ax innechneltoquilisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Huan intla nimechtlajtlanis se tlamantli para ica nimomanahuis, ax innechnanquilisquíaj, niyon ax innechmajcahuasquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero ama, ax huejcahuas para na tlen niMocuepqui Tlacatl nimosehuiti inejmatl Toteco Dios tlen quipiya nochi chicahualistli. ");
INSERT INTO nheNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Huan inijuanti quitlajtlanijque: ―Huajca ¿ta tiIcone Toteco Dios? Huan Jesús quinilhui: ―Quena, najaya niIcone. ");
INSERT INTO nheNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Huan inijuanti moilhuijque se ica seyoc: ―Huajca axaca más monequi quiteilhuis, pampa tojuanti ya tijcajque tlen yajaya quiijto. San ya nopa monequi. ");
INSERT INTO nheNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Huajca nochi inijuanti moquetzque huan quihuicaque Jesús iixtla Pilato. ");
INSERT INTO nheNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Huan pejque quiteilhuíaj huan quiilhuijque Pilato: ―Tijpantijque ni tlacatl quincajcayahuayaya tlacame ipan totlal huan quinilhuiyaya ma ax tlaxtlahuaca impuesto tlen Tlanahuatijquetl César techtlajtlanía. Huan quinilhuiyaya tlacame para yajaya nopa Cristo huan yajaya se tlanahuatijquetl. ");
INSERT INTO nheNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Huan Pilato quitlajtlani Jesús: ―¿Ta tiinintlanahuatijca israelitame? Huan Jesús quinanquili: ―Quena, na niinintlanahuatijca queja tiquijtohua. ");
INSERT INTO nheNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Huan Pilato quinilhui nopa tlayacanca totajtzitzi huan nochi nopa miyac tlacame: ―Ax nijpantilía tlen ax cuali quichijtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero inijuanti achi más tlahuejchijque huan quiilhuijque: ―Yajaya quinajcomantinemi tlacame campa hueli ica itlamachtil. Pejqui ipan estado Galilea huan hualajtoc hasta nica ipan Judea. ");
INSERT INTO nheNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Huan quema Pilato quicajqui ya ni, quintlajtlani intla Jesús ehuayaya estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Huan quema quicajqui para quena, quimatqui para elqui itequi Herodes Ántipas para quitlajtolsencahuas pampa yajaya quipixqui tlanahuatili ipan Galilea. Huajca quititlanqui Jesús para Herodes ma quitlajtolsencahua, huan Herodes paxalohuayaya ipan altepetl Jerusalén ipan nopa tonali. ");
INSERT INTO nheNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Huan quema Herodes quiitac Jesús, nelía paquiyaya pampa miyac tonali quinequiyaya quiitas. Quicactoya miyac tlamantli tlen ya huan quinequiyaya para Jesús ma quichihua se chicahualnescayotl iixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Huajca Tlanahuatijquetl Herodes quitlajtlani Jesús miyac tlamantli, pero Jesús ax quinanquili. ");
INSERT INTO nheNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Huan nopa tlayacanca totajtzitzi huan tlamachtiani tlen itlanahuatil Moisés moquetzayayaj nepa, huan chicahuac quiteilhuiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Huajca Herodes huan isoldados pejque quihuihuiitaj huan ica pajque. Huan quiyoyonti ica se yoyomitl tlen yejyectzi queja moquentíaj tlanahuatiani, huan sampa quititlanqui ica Pilato. ");
INSERT INTO nheNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Huan ipan nopa tonali Herodes huan Gobernador Pilato moyoltlalijque pampa nelía mocualanijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Huan Pilato quinnotzqui nopa tlayacanca totajtzitzi, huan nopa tequihuejme, huan nopa miyac tlacame ");
INSERT INTO nheNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","huan quinilhui: ―Innechhualiquilijque ni tlacatl huan innechilhuíaj para quinyacana tlacame ma motlalanaca. Pero nijtlajtlani nochi tlen ica inquiteilhuijtoque imoixtla, huan ax nijpanti niyon se tlajtlacoli tlen quichijtoc. ");
INSERT INTO nheNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Huan nojquiya Herodes ax tleno quipantili, huan yeca nechtitlanili sampa. Ax tleno quichijtoc para ma tijmictica. ");
INSERT INTO nheNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Huajca nijtlatzacuiltis huan nijmajcahuas para ma yohui. ");
INSERT INTO nheNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Huan sesen xihuitl ipan nopa Pascua ilhuitl Pilato monejqui quimajcahuas se tlen itztoya ipan tlatzactli. ");
INSERT INTO nheNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero nochi nopa tlacame chicahuac quiijtojque: ―¡Xijmicti Jesús! ¡Xitechmajcahuili Barrabás! ");
INSERT INTO nheNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Huan Barrabás quitzactoyaj pampa quintlalanqui tlacame ma tlatehuica ica gobierno, huan nojquiya pampa temicti. ");
INSERT INTO nheNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Huan Pilato sampa quincamahui nopa tlacame pampa quinequiyaya quimalacanis Jesús, ");
INSERT INTO nheNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","pero nopa miyac tlacame achi más tzajtziyayaj: ―¡Xijcuamapelolti! ¡Xijcuamapelolti! ");
INSERT INTO nheNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Huan Pilato ica expa quinilhui: ―¿Para tlen? ¿Tlaque ax cuali quichijtoc? Ax tleno nijpantili tlen quichijtoc para ma tijmictica. San nijtlatzacuiltis huan teipa nijmalacanis ma yohui. ");
INSERT INTO nheNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero nopa miyac tlacame huan tlayacanca totajtzitzi achi más tlahuejchijque. Quitlajtlaniyayaj ma quicuamapelolti huan yeca quifuerzajhuijque Pilato. ");
INSERT INTO nheNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Huajca Pilato mosemacac para quichihuas tlen inijuanti quinequiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Huan quinmajcahuili nopa tlacatl tlen tzactoya pampa tlatehui ica gobierno huan temicti pampa yajaya tlen quitlajtlanijque. Huan quinmactili Jesús ininmaco para ma quichihuaca ica ya tlen inijuanti quinequiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Huan nopa soldados quihuicaque Jesús. Teipa quiitzquijque se tlacatl tlen itoca eliyaya Simón tlen ejqui tlali Cirene. Yajaya ajsitinemiyaya tlen itlal huan nopa soldados quiquechpanoltijque nopa cuamapeli para ma quihuica iica Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Huan tlahuel miyac tlacame quitoquiliyayaj. Huan miyac sihuame chocayayaj huan tlahuejchihuayayaj pampa quicuamapeloltise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Huan Jesús moicancuepqui huan quinilhui: ―Naname tlen inehuaj Jerusalén. Amo xichocaca nopampa, pero ximochoquilica para imojuanti huan ipampa imoconehua. ");
INSERT INTO nheNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pampa ajsis tonali quema tlacame tlahuel tlaijiyohuise huan quiijtose para cuali ininpantis sihuame tlen ax tlatlacatiltijque huan ax quinchichitijque coneme. ");
INSERT INTO nheNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Huan ipan nopa tonali tlacame quiilhuise tepetini ma huetzi ininpani huan ma quintlatis. ");
INSERT INTO nheNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Pampa intla monequi nitlaijiyohuis queja ni, huan ax nitlajtlacolchijtoc, ¿quejatza monequi tlaijiyohuise tlacame tlen hueyi tlajtlacoli quihuicaj? ");
INSERT INTO nheNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Huan no quinhuicayayaj ome tlaxtequini para ma quincuamapeloltise ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Huan nochi ajsitoj nopa lugar campa itoca Mijcatzontecomitl, huan quicuamapeloltijque Jesús ica nopa tlaxtequini, se ipan inejmatl huan seyoc ipan iarraves. ");
INSERT INTO nheNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pero Jesús momaijto huan quiilhui iTata: ―Papá, xiquintlapojpolhui pampa ax quimatij tlaque quichihuaj. Huan nopa soldados momajmacaque iyoyo Jesús huan mahuiltijque ica piltetzitzi tlen yejyectzi para quimatise tlaque iyoyo quihuicas sesen soldado. ");
INSERT INTO nheNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Huan nopa miyac tlacame moquetzayayaj nepa huan quitlachiliyayaj. Huan nojquiya nopa tequihuejme quihuihuiitayayaj Jesús huan quiijtohuayayaj tlen ya: ―Quinmaquixti sequinoc, huajca ma momaquixti intla nelía yajaya nopa Cristo tlen Toteco quitlapejpenijtoc para techtitlanilis. ");
INSERT INTO nheNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Huan nopa soldados nojquiya quihuihuiitayayaj. Monechcahuijque campa ya huan quitenamiquiltijque xocomeca atl tlen ya xocoxtoya, ");
INSERT INTO nheNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","huan quiilhuijque: ―Intla nelía ta tiinintlanahuatijca israelitame, huajca ximomaquixti. ");
INSERT INTO nheNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Huan nojquiya quitlalijque se tlajcuiloli ipan cuamapeli itzonpac Jesús huan quiijto: NI JESÚS ININTLANAHUATIJCA ISRAELITA TLACAME. ");
INSERT INTO nheNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Huan se tlen nopa tlaxtequini tlen quicuamapeloltijtoyaj nojquiya ica paquiyaya Jesús huan quiilhui: ―Intla nelía ta tiCristo tlen Toteco techtitlanilijtoc, huajca ximomaquixti huan xitechmaquixti nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Huan ne se tlaxtejquetl quiajhuac ica tlen quiijto. Huan quiilhui: ―¿Ax tiquimacasi Toteco, yonque nimantzi timiquis? ");
INSERT INTO nheNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Quinamiqui para ta huan na ma timiquica pampa ax cuali tlen tijchijtoque, pero ni Jesús ax tleno quichijtoc tlen ax cuali. ");
INSERT INTO nheNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Huan teipa nopa tlaxtejquetl quiilhui Jesús: ―Jesús, xinechilnamiqui quema tihualas para titlanahuatis. ");
INSERT INTO nheNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Huan Jesús quiilhui: ―Nelía nimitzilhuía para temachtli, ama ni tonal tiitztoti nohuaya nepa campa tlahuel tlayejyeca. ");
INSERT INTO nheNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Huan queja tlajco tona, tzintlayohuac campa hueli ipan tlaltepactli huan queja nopa mocajqui hasta las tres ica tiotlac. ");
INSERT INTO nheNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Huan tonati ayoc tlahuiyaya. Huan tlajco tzayanqui nopa hueyi cortina tlen quitzacuayayaj nopa cuarto Campa Más Tlatzejtzeloltic ipan nopa hueyi tiopan calijtic. ");
INSERT INTO nheNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Huan Jesús camatqui chicahuac, huan quiilhui iTata: ―Papá, nimitzmactilía notonal momaco. Huan quema Jesús quiijto ya ni, mijqui. ");
INSERT INTO nheNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Huan nopa capitán tlen soldados quiitac tlen Jesús quichijqui, huan pejqui quihueyichihua Toteco Dios huan quiijto: ―Nelía ni Jesús eltoya se tlacatl tlen xitlahuac. ");
INSERT INTO nheNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Huan nochi nopa miyac tlacame tlen mosentilijtoyaj para quimatise tlaque ipantis Jesús, quiitaque nochi tlen panoc huan mocuepque ininchajchaj moyoltejtejtzontiyajque pampa tlahuel mocuesohuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Huan nochi iteixmatcahua Jesús huan nopa sihuame tlen hualajtoyaj ihuaya tlen estado Galilea moquetzayayaj ica huejca, quitlachiliyayaj nochi ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Huan itztoya se tlacatl tlen itoca eliyaya José tlen ehuayaya altepetl Arimatea ipan estado Judea. Yajaya nojquiya eliyaya se tequihue ipan nopa tlasentilistli tlen más quipixqui tlanahuatili campa quitlajtlanijque Jesús huan quiijtojque para monequi miquis. José eliyaya se cuali tlacatl huan xitlahuac iyolo iixtla Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yajaya quichiyayaya para Toteco Dios ma tlanahuatis, ipan tlaltepactli huan yeca ax quiyolpacti quema ihuampoyohua ipan nopa tlasentililistli quiteilhuijtoyaj Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Huan ni José yajqui quiitato Pilato huan quitlajtlani ma quimaca itlacayo Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Huan quitemohuito itlacayo huan quiquimilo ica se hueyi yoyomitl. Huan quitejqui ipan se tlacacahuaya tlen yancuic quicoyonijtoya ipan se tepetl huan aya quitlalijtoyaj yon se mijcatzi. ");
INSERT INTO nheNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Huan eltoya nopa tonal para mocualtlalise para ne seyoc tonal quema nochi israelitame mosiyajcahuasquíaj, huan ya ajsiyaya nopa hora para pehuas nopa tonali quema israelitame mosehuisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Huan nopa sihuame tlen hualajque tlen estado Galilea ihuaya Jesús quitoquilijque José huan quiitaque nopa tlacacahuaya huan quejatza quitlalijtoya itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Huan mocuepque ininchaj huan quisencajque tlaajhuiyacayotl. Huan ipan nopa tonal para mosehuise israelitame, inijuanti mosiyajcajque queja quiijto nopa tlanahuatili. ");
INSERT INTO nheNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ipan domingo, nopa achtohui tonal ipan samano, nelía cualca nopa sihuame yajque campa tlacacahuaya huan quihuicaque nopa tlaajhuiyacayotl tlen quisencajtoyaj. Huan sequinoc sihuame nojquiya yajque ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Huan quema ajsicoj, quiitaque ya quiijcuenijtoyaj nopa hueyi tetl tlen quiixtzacuayaya nopa tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Huan calajque, pero ax quipantijque itlacayo Tohueyiteco Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Huan mosentlachilijque huan san moilhuiyayaj tlaque panotoya. Huan nimantzi moquetzque ininnechca ome tlacame tlen moquentijtoyaj ininyoyo tlen nelía cahuaniyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Huan tlahuel momajmatijque huan mohuijtzonque huan nopa tlacame quinilhuijque: ―¿Para tlen inquitemohuaj se tlen yoltoc nicani campa quincahuaj mijcatzitzi? ");
INSERT INTO nheNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesús ax aqui nicani. Moyolcuijca. Xiquilnamiquica quema noja itztoya ipan Galilea inmechilhui para moyolcuisquía. ");
INSERT INTO nheNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Inmechilhui para monequi quitemactilise yajaya tlen Mocuepqui Tlacatl ininmaco tlajtlacolchijca tlacame huan quicuamapeloltise huan ica eyi tonati moyolcuisquía sampa. ");
INSERT INTO nheNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Huajca nopa sihuame quiilnamijque tlen quiijtojtoya, ");
INSERT INTO nheNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","huan quisque ipan tlacacahuaya huan quinyolmelahuatoj nopa majtlactli huan se imomachtijcahua huan nochi sequinoc ihuampoyohua Jesús tlen quiitztoyaj. ");
INSERT INTO nheNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Huan nopa sihuame tlen quinyolmelahuatoj itlayolmelajcahua Jesús tlen quiitztoyaj inintoca eliyaya María Magdalena, Juana huan María inana Jacobo huan nojquiya itztoyaj sequinoc sihuame ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero nopa tlacame moilhuijque huihuitiyayaj huan ax quineltocaque tlen quinilhuicoj. ");
INSERT INTO nheNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero Pedro moquetztiquisqui huan motlalojqui hasta nopa tlacacahuaya. Huan quitlachili iijtic huan quiitac san eltoya nopa hueyi yoyomitl tlen ica quipijque itlacayo Jesús. Huan nelía mosentlachilijqui ica tlen panotoya, huan mocuepqui ichaj. ");
INSERT INTO nheNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Huan ipan nopa tonal itztoyaj ome ihuampoyohua Jesús tlen nejnemiyayaj ipan ojtli hasta se rancho tlen itoca Emaús tlen mocajqui nechca once kilómetros ihuejcaca altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Huan inijuanti mocamahuiyayaj se ica seyoc ica nochi tlen panotoya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Huan quema mocamahuiyayaj, Jesús monechcahuico huan pejqui ininhuaya nejnemi. ");
INSERT INTO nheNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero Toteco ax quincahuili ma quiixmatica intla ya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Huan Jesús quintlajtlani: ―¿Tlaque inmocamahuijtiyohuij ipan ojtli? ¿Para tlen tlahuel inmocuesohuaj? ");
INSERT INTO nheNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Huan se tlen inijuanti tlen itoca eliyaya Cleofas quinanquili Jesús: ―¿Huelis san ta ipan nochi altepetl Jerusalén ax tijmati nochi tlamantli tlen panotoc nica ipan ni tonali? ");
INSERT INTO nheNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Huan Jesús quintlajtlani: ―¿Tlaque tlamantli? Huan quiilhuijque: ―Nopa tlamantli tlen panoc ica Jesús tlen ehua Nazaret. Yajaya eltoya se tiocamanalojquetl tlen quipixqui chicahualistli quichihuas huejhueyi tiochicahualnescayotl. Tlamachti ica miyac chicahualistli huan quiyolpacti Toteco Dios huan nojquiya quinyolpacti tlacame. ");
INSERT INTO nheNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Huan nopa tlayacanani tlen totajtzitzi huan nopa tequihuejme quitemactilijque para ma quimictica. Huan quicuamapeloltijque. ");
INSERT INTO nheNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Huan tojuanti timotemachiyayayaj ipan ya para techmaquixtis tiisraelitame. Huan quipiya eyi tonati quicuamapeloltijque. ");
INSERT INTO nheNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ama nojquiya timosentlachilijque pampa sequin sihuame yajque cualca hasta campa tlacacahuaya, ");
INSERT INTO nheNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","huan ax quipantijque itlacayo. Techilhuicoj quinitaque se tlanextili ica elhuicac ehuani tlen quinilhuijque para Jesús yoltojca. ");
INSERT INTO nheNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Huan sequinoc tlen itztoyaj tohuaya nojquiya yajque campa tlacacahuaya huan quipantijque nochi queja nopa sihuame quiijtojtoyaj, pero ax quiitaque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Huan Jesús quinilhui: ―¿Ax inquimachilíaj? Nelía ohui para inquineltocaj nochi tlen quiijtojque itiocamanalojcahua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Toteco quitlalijtoya para na ninopa Cristo ma nitlaijiyohuis huan nimiquis huan teipa niyas elhuicac campa nijpiyas notlatlanex. ");
INSERT INTO nheNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Huan Jesús pejqui ica tlen quiijcuilo Moisés huan panoc inintlajcuilol nochi sequinoc itiocamanalojcahua Toteco, huan quinixtomili nochi tlen ijcuilijtoc tlen ya ipan Itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Huan quema monechcahuiyayaj nopa rancho campa ajsisquíaj, Jesús mochijqui queja achi más huejca yohuiyaya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Huan nopa ome tlacame ica nochi ininyolo quitlajtlanijque: ―Ximocahua tohuaya pampa tlayohuaya huan temojca tonati. Huan Jesús yajqui para mocahuas ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Huan quema mosehuiyaya ininhuaya campa mesa, quiitzqui pantzi huan quitlajtlani Toteco ma quitiochihua, teipa quitlajcoitac huan quinmajmacac. ");
INSERT INTO nheNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Huajca elqui queja tlapojque iniixtiyolhua huan inijuanti quiixmatque, huan nimantzi Jesús ayoc monexti iniixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Huan inijuanti quiijtojque se ica seyoc: ―¿Ax tijmachiliyaya queja yejyectzi eliyaya ipan toyolo quema yajaya techcamahuiyaya ipan ojtli huan techilhuiyaya tlen quiijtosnequi Itlajtol Toteco? ");
INSERT INTO nheNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Huan nopa ome tlacame moquetzque nimantzi huan mocuepque Jerusalén. Huan quinpantijque nopa majtlactli huan se imomachtijcahua Jesús mosentilijtoyaj ininhuaya sequinoc ");
INSERT INTO nheNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","tlen quiijtohuayayaj para Tohueyiteco nelía moyolcuitoc huan monextijtoya ica Simón Pedro. ");
INSERT INTO nheNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Huajca nopa ome nojquiya pejque quinyolmelahuaj tlen ininpantic ipan ojtli huan queja quiixmatque Jesús quema quitlajcoitac nopa pantzi. ");
INSERT INTO nheNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Huan quema noja quinilhuiyayaj ni tlamantli, Jesús moquetzqui tlatlajco tlen inijuanti huan quinilhui: ―Ma Toteco inmechmaca tlasehuilistli. ");
INSERT INTO nheNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Huan inijuanti quisentlachilijque huan momajmatijque huan moilhuijque quiitayayaj se animajtzi. ");
INSERT INTO nheNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Huan Jesús quinilhui: ―¿Para tlen inmajmahuij huan inmoilhuíaj ipan imoyolo queja nopa? ");
INSERT INTO nheNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xiquitaca noma huan noicxihua campa calactoya lavos. Nelía najaya. Xinechitzquica huan xijmachilica. Se animajtzi ax quipiya inacayo huan iomiyo queja inquiitaj nijpiya. ");
INSERT INTO nheNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Huan quema quiijtohuayaya ni tlajtoli, quinnextili ima huan iicxihua. ");
INSERT INTO nheNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Huan ax quineltocayayaj pampa tlahuel paquiyayaj huan quisentlachiliyayaj. Huan yeca Jesús quinilhui: ―¿Ax tleno inquipiyaj nica para nijcuas? ");
INSERT INTO nheNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Huan inijuanti quimacaque se michi tlacacatzoli huan se quentzi nectli. ");
INSERT INTO nheNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Huan quiitzqui huan quicuajqui iniixtla. ");
INSERT INTO nheNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Huan quinilhui: ―Quema noja niitztoya imohuaya, nimechilhui monequiyaya para ma panos nochi tlen ijcuilijtoc tlen na ipan itlanahuatilhua Moisés, huan ipan Salmos, huan ipan iniama nopa tiocamanalohuani. ");
INSERT INTO nheNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Huan Jesús quintlapohuili inintlalnamiquilis para ma quimachilica Itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Huan quinilhui: ―Queja ni ijcuilijtoc para nopantisquía na niCristo. Monejqui nitlaijiyohuis huan nimiquis huan ica eyi tonali monejqui nimoyolcuis sampa huan queja nopa panotoc. ");
INSERT INTO nheNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Huan ama monequi imojuanti xijpehualtica nica Jerusalén huan xitepohuilica ni tlajtoli ica notequihuejcayo para tlacame ma moyolpatlaca huan ma quicahuaca inintlajtlacolhua huan Toteco quintlapojpolhuis. Huan teipa xitepohuilica ni tlajtoli ipan nochi tlaltini ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Imojuanti inquiitztoque ni tlamantli huan ama monequi inteyolmelahuase tlen inquiitztoque. ");
INSERT INTO nheNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Huan xiquitaca, nechca para nijtitlanis Itonal Toteco ipan imojuanti queja noTata inmechtencahuilijtoc inmechmacas. Huajca ximocahuaca ipan altepetl Jerusalén hasta yajaya ajsis huan inmechtemitis ica chicahualistli tlen elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Huan Jesús quinhuicac imomachtijcahua hasta Betanía huan momatlalanqui huan quintiochijqui. ");
INSERT INTO nheNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Huan quema noja quintiochihuayaya, quistejqui huan tlejcoc elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Huan imomachtijcahua quihueyichijque huan teipa mocuepque altepetl Jerusalén ica hueyi paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Huan mojmostla itztoyaj ipan nopa hueyi israelita tiopamitl quipaquilismacayayaj huan quihueyichihuayayaj Toteco Dios. Queja nopa ma eli.");
INSERT INTO nheNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cristo, yajaya tlen tenextilía Toteco Dios, ya ipa itztoya quema aya oncayaya nochi tlen onca. Cristo senitztoya ihuaya Toteco Dios huan yajaya nojquiya Dios. ");
INSERT INTO nheNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yajaya itztoya ihuaya Toteco ipan ipejya nochi tlen onca. ");
INSERT INTO nheNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cristo quichijchijqui nochi tlamantli huan niyon se tlamantli tlen onca ax yolqui iselti. ");
INSERT INTO nheNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yajaya tlen quipiya yolistli ipan ya huan quinmaca yolistli nochi tlen itztoque. Yajaya nopa tlahuili tlen quintlahuilía tlacame ipan ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ni tlahuili tlahuía campa onca tzintlayohuilotl huan nopa tzintlayohuilotl ax hueli quisehuía. ");
INSERT INTO nheNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Itztoya se tlacatl tlen Toteco Dios quititlantoya tlen itoca eliyaya Juan. ");
INSERT INTO nheNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Juan hualajqui quipannextico Cristo tlen itztoc nopa tlahuili para nochi tlacame ma quineltocaca Cristo quema quicaquisquíaj tlen Juan quinilhuisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan ax ya nopa tlahuili. San hualajqui quipannextico nopa tlahuili. ");
INSERT INTO nheNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo yajaya nopa tlahuili tlen nelía temachtli huan hualajqui ipan tlaltepactli para techtlahuiliqui nochi titlacame ipan toyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo itztoya ipan tlaltepactli huan yajaya quichijqui tlaltepactli, pero tlacame nica ax quiixmatque ajqueya ya. ");
INSERT INTO nheNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Yajaya hualajqui ica tojuanti tiisraelita tlacajhua, pero miyac tlen tojuanti ax tijselijque. ");
INSERT INTO nheNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero nochi tlacame tlen quiselijque Cristo, quinequi quiijtos nochi tlen quineltocaque , yajaya quinmacac tequihuejcayotl para elise iconehua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Inijuanti ax mochijque iconehua Toteco pampa tlacatque ipan se cuali xinachtli tlacame. Niyon ax iconehua queja tiiconehua totatahua, niyon ax iconehua pampa quinejqui se tlacatl. Inijuanti iconehua Toteco Dios pampa Toteco quinejqui ma elica. ");
INSERT INTO nheNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Huan Cristo tlen tenextilía Toteco Dios mocuepqui tlacatl ica itlacayo queja tojuanti huan itztoya tohuaya nica para se tlalochtli. Huan tiquitaque ihueyitilis huan tiquixmatque para yajaya iyojtzi Icone Toteco Totata. Nelía hueyi iyolo tohuaya huan yajaya senquistoc melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan teyolmelajqui tlen Cristo huan quiijto: “Yajaya tlen nimechilhuiyaya quema niquijto para teipa hualas se tlen quipiya más itequihuejcayo que na. Pampa quema aya nitlacatiyaya, yajaya ya ipa itztoc.” ");
INSERT INTO nheNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nochi tojuanti tijselijtoque miyac tlatiochihuali tlen iricojyo Cristo pampa hueyi iyolo tohuaya. Huan mojmostla más techtiochihua. ");
INSERT INTO nheNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Quena, Toteco techmacac itlanahuatil ica Moisés, pero ica Jesucristo technextilijtoc para hueyi iyolo ica tojuanti. Huan ica ya techmachti tlen nelía temachtli. ");
INSERT INTO nheNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Axaca quiitztoc Toteco Dios, pero Jesucristo, iyojtzi Icone tlen mocahua inechca, technextilico nochi tlen ya. ");
INSERT INTO nheNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Huan ya ni tlen Juan quinyolmelajqui nopa israelitame tlen ehuaj altepetl Jerusalén quema quintitlanque israelita totajtzitzi huan levitame tlen tlapalehuijque ipan tiopamitl para ma quitlajtlanitij Juan ajqueya ya. ");
INSERT INTO nheNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juan quinilhui xitlahuac: ―Na ax niCristo. ");
INSERT INTO nheNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Huan inijuanti quitlajtlanijque: ―¿Huajca ajqueya ta? ¿Ta tiElías? Huajca Juan quiijto: ―Na ax niElías. Huan quitlajtlanijque: ―¿Ta tiitztoc nopa tiocamanalojquetl tlen Toteco techilhui techtitlanilisquía? Juan quinnanquili: ―¡Axtle! ");
INSERT INTO nheNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Huajca inijuanti quiilhuijque: ―Xitechilhui ajqueya ta para huelis tiquinyolmelahuase tlen techtitlantoque. ¿Tlaque motequi? ");
INSERT INTO nheNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Huajca Juan quinnanquili ica ni tlajtoli tlen tiocamanalojquetl Isaías quiijcuilo huejcajquiya. Quinilhui: ―Na san nieli se tlacatl tlen Toteco quitequihuía para nicamatis chicahuac ipan nopa huactoc tlali campa ax tleno eli huan niquijtohua: ‘Xijpatlaca imoyolo pampa hualas Tohueyiteco. Xijsencahuaca huan xijxitlahuaca iojhui para ipan nemis.’ ");
INSERT INTO nheNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Huan nopa tlacame tlen fariseos quintitlantoyaj, ");
INSERT INTO nheNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","quiilhuijque: ―Huajca, ¿para tlen titecuaaltía intla ax tiCristo huan ax tiElías, huan ax ta nopa tiocamanalojquetl tlen hualasquía? ");
INSERT INTO nheNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Huajca Juan quiijto: ―Na san nitecuaaltía ica atl, pero itztoc seyoc tlatlajco campa imojuanti tlen aya inquiixmatij. ");
INSERT INTO nheNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yajaya hualas teipa huan yajaya quipiya más tequihuejcayotl que na. Na ax nicaxilía para nielis niitequipanojca, niyon para nijquixtilis itecac. ");
INSERT INTO nheNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Nochi ya ni panoc campa Juan tecuaaltiyaya ipan altepetl Betábara ipan ne seyoc nali atemitl Jordán ica campa quisa tonati. ");
INSERT INTO nheNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Huan tonili Juan quiitac Jesús hualayaya campa itztoya huan yeca quinilhui nopa tlacame: “Ne tlacatl yajaya tlen Toteco techtitlanilijtoc. Yajaya itoca ipilborregojtzi Toteco pampa elis nopa tlacajcahualistli tlen techquixtilis nochi totlajtlacolhua nochi titlacame ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nimechilhuiyaya tlen ya quema nimechilhui para teipa hualas se tlacatl tlen quipiya más tequihuejcayotl que na pampa quema aya nitlacatiyaya, yajaya ipa itztoya. ");
INSERT INTO nheNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Achtohui ax nijmatiyaya catlía ya, pero nihualajqui para nitecuaaltis pampa nijnequiyaya niquinpannextilis nochi israelitame.” ");
INSERT INTO nheNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nojquiya Juan quinyolmelajqui: “Niquitac Itonal Toteco hualtemoc tlen elhuicac queja se paloma huan mocahuaco ipan ya. ");
INSERT INTO nheNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Huan ax nijmajtosquía intla ya, pero Toteco Dios tlen nechtitlanqui para nitecuaaltis nechilhuijtoya para quema niquitas Itonal hualtemos huan mocahuas ipan se tlacatl, huajca yajaya tlen temacas Itonal. ");
INSERT INTO nheNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Huajca ya nopa niquitac huan yeca nimechyolmelahua para ni tlacatl, yajaya Icone Toteco Dios.” ");
INSERT INTO nheNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huan tonili sampa moquetzayaya Juan ihuaya ome imomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Huan quiitac Jesús quema panoyaya nechca huan quiijto: ―Xiquitaca, ne tlacatl yajaya ipilborregojtzi Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Huan nopa ome imomachtijcahua Juan quicajque tlen quiijto huan quitoquilijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Huan Jesús moicancuepqui, huan quinitac quitoquiliyayaj huan quinilhui: ―¿Tlaque inquinequij? Huan quiijtojque: ―Tlamachtijquetl, ¿canque tiitztoc? ");
INSERT INTO nheNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Huan quinilhui: ―Xihualaca, xiquitaquij canque nimocahua. Huajca yajque huan quiitatoj campa mocahuayaya huan mocajque ihuaya pampa eliyaya las cuatro ica tiotlac. ");
INSERT INTO nheNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Se tlen nopa ome tlen quicajqui tlen Juan quiijto huan yeca quitoquili Jesús, yajaya itoca eliyaya Andrés. ");
INSERT INTO nheNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Huan Andrés yajqui xitlahuac quitemoto iicni, Simón, huan quiilhui: ―Tijpantijque nopa Mesías. (Pampa ipan inintlajtol quitocajtijque nopa Cristo tlen Toteco quiijto para quititlanisquía: ‘Mesías’.) ");
INSERT INTO nheNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Huan Andrés quihuicac Simón campa Jesús. Huan Jesús quitlachili huan quiijto: ―Ta tiSimón, tiicone Jonás, pero nimitztocajtlalis tiCefas. (Cefas ica totlajtol quiijtosnequi Pedro.) ");
INSERT INTO nheNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huan tonili Jesús quinejqui yas estado Galilea. Huajca quipanti Felipe huan quiilhui: ―Xinechtoquili. ");
INSERT INTO nheNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe elqui se altepetl Betsaida ejquetl campa nojquiya ehuayayaj Andrés huan Pedro. ");
INSERT INTO nheNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Huan Felipe quipantito Natanael huan quiilhui: ―Tijpantijtoque nopa tlacatl tlen ica Moisés quiijcuilo huejcajquiya ipan itlanahuatil. Yajaya tlen ica quiijcuilojque itiocamanalojcahua Toteco huejcajquiya para teipa hualasquía. Yajaya Jesús icone José huan ehua altepetl Nazaret. ");
INSERT INTO nheNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Huan Natanael quiijto: ―¿Quejatza huelis? Axaca tlen cuali huelis hualas tlen altepetl Nazaret. Pero Felipe quiijto: ―Xihuala, xiquitaqui. ");
INSERT INTO nheNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Huan quema Jesús quiitac Natanael ajsiyaya, quiijto tlen ya: ―Xiquitaca, ya huala se israelita tlen temachtli huan tlen ax quema tlacajcayahua. ");
INSERT INTO nheNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Huajca Natanael quitlajtlani Jesús: ―¿Quejatza tinechixmati? Huan Jesús quinanquili: ―Quema noja tiitztoya itzintla nopa higuera cuahuitl huan aya mitznotzayaya Felipe, na nimitzitac. ");
INSERT INTO nheNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Huan Natanael quiilhui: ―Tlamachtijquetl, ta tiIcone Toteco. Ta titotlanahuatijca tlen titechnahuatis tiisraelitame ipan ni totlal. ");
INSERT INTO nheNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Huan Jesús quinanquili: ―¿Tinechneltoca ajqueya na san pampa nimitzilhui nimitzitac quema noja tiitztoya itzintla nopa higuera cuahuitl? Tiquitas tlamantli tlen noja más huejhueyi que ni. ");
INSERT INTO nheNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nelía nimitzilhuía, tiquitas motlapos elhuicac huan tiquinitas ielhuicac ejcahua Toteco tlen tlejcotinemise hasta elhuicac huan temotinemise hasta tlaltepactli campa na tlen niMocuepqui Tlacatl para nechtequipanose. ");
INSERT INTO nheNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Huan hualhuiptlatic oncac se tlacualistli tlen nenamictili ipan altepetl Caná ipan estado Galilea huan yajqui inana Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Huan nojquiya quinotzque Jesús huan technotzque tiimomachtijcahua. Huan nochi tiyajque. ");
INSERT INTO nheNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Huan tlanqui xocomeca atl huan inana Jesús quiilhui: ―Ayoc quipiyaj xocomeca atl. ");
INSERT INTO nheNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Huan Jesús quiilhui: ―Nane, ¿para tlen tinechilhuía na? Aya ajsi nohora para nimonextis. ");
INSERT INTO nheNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Huan inana yajqui quinilhuito nopa tlatequipanohuani ipan nopa tlacualistli: ―Xijchihuaca nochi tlen Jesús inmechilhuis. ");
INSERT INTO nheNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Huan nepa eltoya chicuase huejhueyi comitl tlen quicoyonijtoyaj tlen tetl huan ipan atecayayaj para tlacame ma momajtequica queja toisraelita tlanahuatilhua quiijtohuaj. Huan sesen nopa comitl huelis quicuisquía ochenta hasta cien litros atl. ");
INSERT INTO nheNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Huajca Jesús quinilhui nopa tlatequipanohuani: ―Xijtemitica nochi ne contini ica atl. Huan cuali quintejtemitijque. ");
INSERT INTO nheNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Huan Jesús quinilhui: ―Ama xijcuica quentzi huan xijhuiquilica nopa ilhuichijquetl. Huajca quihuiquilijque. ");
INSERT INTO nheNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Huan nopa ilhuichijquetl quiyeco nopa atl tlen ya mocueptoya xocomeca atl huan moilhui nelía se cuali xocomeca atl, pero ax quimatqui canque quicuitoyaj. San nopa tlatequipanohuani, quena, quimatque canque quiquixtijtoyaj. Huajca nopa ilhuichijquetl quinotzqui nopa mosihuajtijquetl, ");
INSERT INTO nheNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","huan quiilhui: ―Nochi tlen temacaj se tlacualistli achtohui temacaj xocomeca atl tlen cuali. Huan teipa quema nochi tlanotzalme achi tlaitoquejya, quinmacaj xocomeca atl tlen ax nelía cuali. Pero ta, ax tijchijtoc ya nopa. Ta ticajcojqui ni xocomeca atl tlen más cuali para titetlailtis amantzi. ");
INSERT INTO nheNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesús quichijqui ni tlanescayotl ipan altepetl Caná ipan estado Galilea. Huan ya ni elqui nopa achtohui tlanescayotl tlen quichijqui para technextilis ihueyitilis. Huan tiimomachtijcahua más tijneltocaque para yajaya nopa Cristo tlen Toteco techtitlanilisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Teipa Jesús temoc hasta altepetl Capernaum ihuaya inana, iicnihua teipa ehuani huan tiimomachtijcahua. Huan timocajque nepa se quentzi tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ya nechca eliyaya nopa ilhuitl tlen itoca Pascua huan Jesús yajqui hueyi altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Huan nepa quinpantito tlacame tlen mosentilijtoyaj nopa hueyi tiopan calijtic huan quinnamacayayaj huacaxme, borregojme huan palomas para ma quimacaca Toteco tlacajcahualistli. Huan nojquiya mosehuiyayaj tiopan calijtic tlacame tlen quipatlayayaj sejcoyoc tlali tomi ica israelita tomi para quitlanilisquíaj se quentzi. ");
INSERT INTO nheNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Huajca Jesús quichijqui se cuarta tlen cuetlaxtli huan ica quinquixti nochi nopa tlacame ininhuaya ininborregojhua huan ininhuacaxhua. Huan quintepehuili inintomi nopa tomin patlani huan quincuamajcahuili inincuamesas. ");
INSERT INTO nheNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Huan quinilhui tlen quinamacayayaj palomas: ―Xijhuicaca nochi tlen moaxcahua. Ayoc xijchihuaca imotianquis tiopan calijtic pampa ni tiopamitl ichaj noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Huan tiimomachtijcahua tiquilnamijque tlen ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua para Cristo quitlepanitas itiopa iTata ica nochi iyolo, yonque ica ya nopa monequi miquis. ");
INSERT INTO nheNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Huan nopa tlayacanca israelitame quitlajtlanijque Jesús: ―¿Tlaque tlanescayotl hueli tijchihuas para titechnextilis tijpiya itequiticayo Toteco Dios para tiquintotocac tlen itztoyaj ipan ni tiopamitl? ");
INSERT INTO nheNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Huan Jesús quinnanquili: ―Xijxolehuaca ni tiopamitl huan ica eyi tonali sampa nijsencahuas queja ipa eltoya. ");
INSERT INTO nheNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Huan nopa israelitame quiilhuijque: ―Miyac tlacame tequitique para cuarenta y seis xihuitl para quichijque ni tiopamitl; ta ax huelis tijchihuas sampa ica eyi tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero quema Jesús quiijto eyi tonali, quincamahuiyaya tlen itlacayo tlen eliyaya se tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Huan teipa quema panotoya miyac metztli huan Jesús mijqui huan ica eyi tonali sampa moyolcuic, tiimomachtijcahua tiquilnamijque nopa tonal quema quiijto ni tlen itlacayo. Huajca tijneltocaque tlen ijcuilijtoc ipan Itlajtol Toteco huan tijneltocaque tlen yajaya techilhuijtoya. ");
INSERT INTO nheNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Huan Jesús itztoya ipan altepetl Jerusalén ipan nopa Pascua Ilhuitl. Huan quiitaque miyac tlacame nopa huejhueyi tlanescayotl tlen quichihuayaya huan quineltocaque para nelía yajaya nopa Mesías. ");
INSERT INTO nheNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús ax motemachi ipan nopa tlacame pampa cuali quiixmatiyaya quejatza eltoya ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Huan ax monequiyaya seyoc ma quiilhui quejatza itztoc se tlacatl pampa yajaya cuali quimatqui tlen eltoc ipan ininyolo nochi tlacame. ");
INSERT INTO nheNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Itztoya se tlacatl tlen itoca eliyaya Nicodemo huan elqui se fariseo huan se tlayacanquetl tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yajaya hualajqui ica tlayohua quiitaco Jesús huan quiilhui: ―Tlamachtijquetl, tojuanti tijmatij Toteco Dios mitztitlanqui nica para xitechmachtis pampa axaca hueli quichihua huejhueyi tlanescayotl tlen technextilía ichicahualis Toteco queja tijchihua intla Toteco ax itztosquía mohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Huan Jesús quiilhui: ―Nelía nimitzilhuía, intla se tlacatl ax tlacatis sampa huan quipiyas yolistli tlen yancuic, ax quema huelis yas campa tlanahuatía Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Huan Nicodemo quiilhui Jesús: ―¿Quejatza hueli se tlacatl tlen ya quipiya miyac xihuitl calaquis ipan inana para tlacatis sampa? ");
INSERT INTO nheNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Huan Jesús quinanquili: ―Nelía nimitzilhuía, intla se tlacatl ax sampa tlacatis ica atl huan ica Itonal Toteco, ax huelis yas campa Toteco tlanahuatía. ");
INSERT INTO nheNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Se conetl tlen inana quitlacatiltía quipiya inacayo huan iomiyo queja inana quipiya. Pero Itonal Toteco quitlacatiltía itonal se tlacatl. Huan elis itonal nopa tlacatl tlen quiselis yolistli yancuic. ");
INSERT INTO nheNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Amo xinechsentlachili quema nimitzilhuía monequi yancuic titlacatis. ");
INSERT INTO nheNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Xiquita queja eltoc ica ajacatl. Tojuanti tijcaquij nopa ajacatl tlen pano, pero ax tijmatij canque quistejqui, niyon ax tijmatij canque ajsiti. Nojquiya quema Itonal Toteco quitlacatiltía se tlacatl, tijmatij quipiya yolistli yancuic, pero ax hueli tijmachilíaj quejatza elqui. ");
INSERT INTO nheNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Huan Nicodemo quiilhui Jesús: ―Ax nijmachilía tlen tinechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Huan Jesús quiilhui: ―Tiitztoc se hueyi tlamachtijquetl tlen Itlajtol Toteco ipan ni tlali Israel. ¿Para tlen ax tijmachilía tlen niquijtohua? ");
INSERT INTO nheNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nelía nimitzilhuía, nimitzyolmelahua tlen nijmati huan tlen niquitztoc, pero ax tijneltoca notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Intla nimitzilhuijtoc tlen pano nica ipan tlaltepactli huan ax tinechneltoca, ¿quejatza huelis tinechneltocas quema nimitzilhuis tlen eltoc elhuicac? ");
INSERT INTO nheNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Axaca yajtoc elhuicac huan mocueptoc nica para inmechilhuiqui quejatza eltoc. San na tlen niMocuepqui Tlacatl tlen nihualtemoc tlen elhuicac hueli nimitzilhuía tlen eltoc nepa. ");
INSERT INTO nheNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tiquilnamiquij queja Moisés huejcajquiya quiquetzqui se tlaquetzali ipan nopa huactoc tlali campa ax tleno eli huan ipani quitlalanqui se tepos cohuatl. Huan nochi tlacame tlen quintzacanijtoyaj cohuame hueliyayaj quitlachilise nopa tepos cohuatl huan mochicahuase. Quej nopa nojquiya noca na. Tlacame nechtlalanase na tlen niMocuepqui Tlacatl ipan se cuamapeli. ");
INSERT INTO nheNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Huan nochi tlen nechneltocase quiselise yolistli yancuic para nochipa.” ");
INSERT INTO nheNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Toteco nelía miyac quinicnelía nochi tlacame ipan ni tlaltepactli huan yeca quititlanqui Icone iyojtzi para miquis ininpampa. Huan queja nopa nochi tlen quineltocase, ax polihuise, pero quipiyase yolistli tlen yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Toteco ax quititlanqui Icone ipan ni tlaltepactli para tetlatzacuiltis. Quititlanqui para temaquixtis. ");
INSERT INTO nheNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Toteco ax quitlatzacuiltis tlen quineltoca Icone. Pero tlen ax quineltoca, quena, Toteco ya quitlalijtoc para quitlatzacuiltis pampa ax quineltoca itoca Icone iyojtzi. ");
INSERT INTO nheNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Huan quitlatzacuiltis pampa Icone hualajqui ipan tlaltepactli para quitlahuilis inintlalnamiquilis tlacame, pero tlacame quiicnelíaj más tzintlayohuilotl que tlahuili pampa fiero tlen quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nochi tlacame tlen quichihuaj tlen ax cuali quicocolíaj tlahuili huan ax quinequij monechcahuise campa tlahuili pampa quimatij nesis para ax cuali tlen quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero tlacame tlen quichihuaj tlen cuali hualahui campa nopa tlahuili ica paquilistli para monextis para Toteco quinpalehuía ica nochi nopa cuali tlamantli tlen quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Teipa Jesús huan tiimomachtijcahua tiyajque ipan estado Judea huan nepa timocajque más tonali pampa tlacame hualayayaj para mocuaaltise. ");
INSERT INTO nheNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Huan ipan nopa tonali Juan tecuaaltiyaya nechca altepetl Enón tlen mocajqui nechca altepetl Salim pampa nepa oncayaya miyac atl. Huan tlacame yohuiyayaj campa ya para ma quincuaalti. ");
INSERT INTO nheNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ya ni panoc quema aya quitzacuayayaj Juan. ");
INSERT INTO nheNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Huan sequin itlatoquilijcahua Juan pejque mocamaijixnamiquij ininhuaya sequin tlayacanani tlen israelitame ica catlía tlacuaaltilistli achi cuali para tetlapajpacchihua iixpa Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Huajca imomachtijcahua Juan yajque campa ya huan quiilhuijque: ―Tlamachtijquetl, ¿tiquilnamiqui nopa tlacatl Jesús tlen itztoya mohuaya ipan nopa seyoc nali atemitl Jordán campa quisa tonati? Tiquinilhuiyaya nochi para yajaya nopa Cristo. Ama nochi tlacame yohuij campa ya para mocuaaltise. ");
INSERT INTO nheNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Huajca Juan quinnanquili: ―Toteco Dios quimaca sesen tlacatl nopa tequitl tlen quinequi ma quichihua. ");
INSERT INTO nheNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Inquimatij nimechilhui xitlahuac para ax na nopa Cristo, pero Toteco nechtitlantoc achtohui para nitlayacanas huan teipa yajaya hualas. ");
INSERT INTO nheNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Quema onca se nenamictili, nopa ichpocatl yohui campa nopa mosihuajtijquetl, pero ihuampo nopa mosihuajtijquetl quicaqui quema quinotza nopa ichpocatl ma huala, huan nelía paqui nojquiya. Na niitztoc queja ihuampo nopa mosihuajtijquetl. Na ninelpaqui pampa tlacame yohuij ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Monequi yajaya elis más hueyi huan na, axtle. ");
INSERT INTO nheNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Cristo hualajqui tlen huejcapa huan yajaya más hueyi que nochi sequinoc. Na san niehua ipan ni tlaltepactli huan san nijmati tlen eltoc ipan ni tlaltepactli. Pero yajaya hualajqui tlen elhuicac huan quipiya tlanahuatili ica nochi tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Huan yajaya tlayolmelahua tlen quiitztoc huan quicactoc nepa elhuicac, pero miyac tlacame ax quineltocaj tlen quinilhuía. ");
INSERT INTO nheNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero ajqueya quineltoca tlen Cristo quiijtohua, quipannextía para Toteco quiijtohua tlen melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Pampa Toteco quititlanqui huan yajaya camati itlajtol Toteco. Pampa Toteco quimacatoc Jesús Itonal huan ax quimacac san se quentzi. Quimacatoc Itonal ica nochi ichicahualis. ");
INSERT INTO nheNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Toteco Dios quiicnelía Icone huan quimacatoc tequihuejcayotl ica nochi tlen onca. ");
INSERT INTO nheNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Intla se tlacatl quineltoca Icone Toteco, yajaya quipiya yolistli para nochipa. Pero intla se ax quineltoca Icone Toteco, ax quipiyas nopa yolistli huan temachtli Toteco quitlatzacuiltis.” ");
INSERT INTO nheNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Huan teipa Jesús quisqui estado Judea pampa quicajqui para nopa fariseos quimatiyayaj para nelía momiyaquiliyayaj imomachtijcahua huan para tojuanti tiquincuaaltiyayaj más tlacame que Juan. ");
INSERT INTO nheNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nelía Jesús axaca quicuaalti, pero tojuanti tiimomachtijcahua tiquincuaaltiyayaj tlen ajsiyayaj campa ya. ");
INSERT INTO nheNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Huan yeca tiquisque Judea campa itztoyaj nopa fariseos huan tiyohuiyayaj para estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Huan ipan ojtli monequiyaya tijpanose estado Samaria. ");
INSERT INTO nheNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Huan Jesús ajsito se altepetl tlen itoca Sicar ipan Samaria tlen mocajqui nechca nopa mili tlen tohuejcapan tata Jacob huejcajquiya quicahuilijtejqui icone José. ");
INSERT INTO nheNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Huan nepa eltoya se ameli tlen Jacob quixajqui huejcajquiya. Huajca Jesús mosehui amelteno pampa tlaxicojtoya pampa nejnentoya huejca huan eliyaya tlajco tona. ");
INSERT INTO nheNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Huan tiimomachtijcahua tiyajtoyaj ipan nopa altepetl para tijcohuatij tlen tijcuasquíaj. Huan atlacuico se sihuatl tlen ejqui tlali Samaria huan Jesús quiilhui: ―Xinechmaca se achi moa para niquis. ");
INSERT INTO nheNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero tiisraelitame ax timomajtoque tiquinnojnotzaj Samaria ehuani. Huajca nopa sihuatl Samaria ejquetl quisentlachili huan quiilhui Jesús: ―¿Para tlen ta tiisraelita tinechtlajtlanía ma nimitzamaca huan na niSamaria ejquetl? ");
INSERT INTO nheNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Huan Jesús quinanquili: ―Intla tijmatisquía tlen Toteco Dios quinequi mitzmacas huan ajqueya na tlen nimitzatlajtlanía, ta tinechtlajtlanisquía huan nimitzmacasquía atl tlen temaca yolistli yancuic. ");
INSERT INTO nheNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Huan nopa sihuatl quiilhui: ―Tate, ax tleno tijpiya para ica tijquixtis atl huan huejcatla ni ameli. ¿Canque tijcuis atl tlen temaca yolistli yancuic? ");
INSERT INTO nheNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Ta tiitztoc más hueyi que tohuejcapan tata Jacob tlen huejcajquiya quiic atl tlen ni ameli, huan nojquiya quiique iconehua huan itlapiyalhua, huan teipa techcahuilijtejqui? ");
INSERT INTO nheNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Huan Jesús quinanquili: ―Nochi tlen quiij atl ipan ni ameli sampa amiquise. ");
INSERT INTO nheNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero aqui quiis nopa atl tlen na nitemaca, ayoc quema amiquis pampa nopa atl tlen nitemaca elis queja se ameli tlen meyas ipan iyolo huan quimacas yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Huajca nopa sihuatl quiilhui: ―Tate, xinechmaca nopa atl para ayoc niamiquis huan ayoc niatlacuiqui hasta ni ameli. ");
INSERT INTO nheNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Huan Jesús quiilhui: ―Xiya, xijnotzati mohuehue ma huala. ");
INSERT INTO nheNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Huan nopa sihuatl quinanquili: ―Ax nijpiya nohuehue. Huan Jesús quiilhui: ―Melahuac tlen tinechilhuijtoc, ax tijpiya mohuehue. ");
INSERT INTO nheNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pampa tiquinpixqui macuilme mohuehuejhua huan yajaya tlen ama mohuaya itztoc, ax mohuehue. Huajca tinechilhuijtoc tlen melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Huan nopa sihuatl quiilhui Jesús: ―Tate, nimoilhuía ta tise tiocamanalojquetl. ");
INSERT INTO nheNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Huajca xinechilhui ya ni. Tohuejcapan tatahua tlen ejque ni tlali Samaria quiijtojque monequi ma tijhueyichihuaca Toteco ipan ni tepetl, pero inisraelitame inquiijtohuaj monequi tlacame quihueyichihuatij Toteco hasta altepetl Jerusalén. ¿Ajqueya quiijtohua tlen melahuac? ");
INSERT INTO nheNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Huan Jesús quiilhui: ―Nane, xijneltoca tlen nimitzilhuía. Ajsis tonali quema ayoc monequis inhualase ipan ni tepetl, niyon ayoc monequis inyase Jerusalén para inquihueyichihuase Toteco Totata. ");
INSERT INTO nheNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","InSamaria ehuani ax inquiixmatij ajqueya inquihueyichihuase. Pero tiisraelitame tiquixmatij Toteco Dios huan tijhueyichihuaj. Huan Toteco temaquixtis ica se tlen israelita. ");
INSERT INTO nheNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ajsis tonali, quena, ya ajsico nopa tonali, quema nochi tlen nelía quinequij quihueyichihuase Toteco Totata quihueyichihuase ipan ininyolo huan inintonal huan quiilhuise tlen melahuac pampa queja nopa Totata quinequi para nochi tlacame ma quihueyichihuaca. ");
INSERT INTO nheNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Toteco Dios yajaya se tonaltzi tlen axaca hueli quiita, huan tlacame tlen quinequij quihueyichihuase monequi quihueyichihuase ica inintonal huan monequi quiilhuise tlen melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Huan nopa sihuatl quiilhui: ―Nijmati hualas nopa Mesías, yajaya tlen quitocajtíaj Cristo tlen Toteco techtitlanilis. Huan quema yajaya hualas, techmachtis nochi tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Huan Jesús quiilhui: ―Na tlen nimitzcamahuía, na niitztoc nopa Cristo. ");
INSERT INTO nheNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Huan quema Jesús noja quicamahuiyaya nopa sihuatl, tiimomachtijcahua tiajsicoj huan san tijsentlachilijque pampa quicamahuiyaya se sihuatl Samaria ejquetl, pero axaca quitlajtlani: “¿Tlaque tijtemohua?” o “¿para tlen tijcamahuía?” ");
INSERT INTO nheNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Huajca nopa sihuatl quicajtejqui ico amelteno huan yajqui ipan nopa altepetl huan quinilhuito tlacame: ");
INSERT INTO nheNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xihualaca nohuaya, xiquitatij se tlacatl tlen nechilhuijtoc nochi tlen nijchijtoc. Xiquitatij intla ax ya nopa Cristo. ");
INSERT INTO nheNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Huan nopa tlacame quisque ipan altepetl huan hualajque campa tiitztoyaj. ");
INSERT INTO nheNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Huan quema aya ajsiyayaj nopa tlacame, tiimomachtijcahua tiquilhuijque Jesús: ―Tlamachtijquetl, xitlacuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Huan Jesús technanquili: ―Nijpiya notlacualis tlen ax inquimatij. ");
INSERT INTO nheNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Huan timoilhuijque se ica seyoc: ―¿Huelis se acajya quihualiquili itlacualis? ");
INSERT INTO nheNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero Jesús techilhui: ―Quema nijchihua ipaquilis noTata tlen nechtitlanqui huan quema nijtlamichihua itequi, nechmaca chicahualistli queja tlacualistli nechmacasquía. ");
INSERT INTO nheNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Inquiijtohuaj polihui nahui metztli para pixquistli. Pero xiquitaca ama ne miyac tlacame tlen hualahuij. Nimechilhuía, inijuanti itztoque queja se pixquistli tlen cualtitojca. Nechneltocase intla tiquinnotzase para ma nechneltocaca. ");
INSERT INTO nheNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Tlacame tlen quinpalehuíaj sequinoc para ma nechneltocaca quiselise inintlaxtlahuil. Huan nopa pixquistli tlen quisentilise elise tlacame tlen itztose para nochipa. Quema oncas pixquistli, paquise san sejco tlen quitojqui xinachtli ipan se mili huan yajaya tlen quipixcas. Quej nopa nojquiya se tlen achtohui quiilhuis se tlacatl notlajtol, yajaya paquis ihuaya ne seyoc tlen teipa quipalehuis para nechneltocas. ");
INSERT INTO nheNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Quej ni quisas melahuac nopa tlajtoli tlen quiijtohua: ‘Se quitoca xinachtli huan seyoc quisentilis nopa pixquistli.’ ");
INSERT INTO nheNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nimechtitlanqui xiquinpixcaca tlacame para nechneltocase, pero ax imojuanti tlen achtohui inquinilhuijque notlajtol. Sequinoc quitojque notlajtol ipan ininyolo achtohui huan inquipixcase tlen elqui inintequi. ");
INSERT INTO nheNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Huan nopa sihuatl tlen quicamahui Jesús amelteno quinilhuijtoya miyac Samaria ehuani ipan altepetl Sicar para Jesús quiilhuijtoya nochi tlen quichijtoya ipan iyolis. Huan miyac inijuanti quineltocaque para Jesús eliyaya nopa Cristo pampa nopa sihuatl quiijto para Jesús quiilhuijtoya nochi tlen quichijqui ipan iyolis. ");
INSERT INTO nheNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Huajca miyac Samaria ehuani ajsicoj campa tiitztoyaj huan chicahuac quitlajtlanijque Jesús ma mocahuas ininhuaya. Huan yeca mocajqui ininhuaya ome tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Huan miyac más quineltocaque Jesús ica tlen quinilhui iselti. ");
INSERT INTO nheNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Huan inijuanti quiilhuijque nopa sihuatl: ―Ayoc tijneltocaj Jesús san pampa tlen ta titechilhui pampa tojuanti toseltitzi tijcactoque tlen yajaya techilhui, huan tijmatij yajaya nelía nopa Cristo tlen huelis quinmaquixtis nochi tlacame ipan tlaltepactli tlen inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Huan hualhuiptlatic, Jesús quisqui estado Samaria huan yajqui ipan Galilea nopa estado campa ejqui. ");
INSERT INTO nheNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Huan yonque Jesús quiijtojtoya para tlacame tlen san sejco ehuaj se tiocamanalojquetl ax quitlepanitaj, ");
INSERT INTO nheNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","nochi Galilea ehuani quiselijque Jesús ica paquilistli quema ajsito inintlal, pampa inijuanti yajtoyaj nopa Pascua Ilhuitl ipan altepetl Jerusalén huan ya quiitztoyaj nochi nopa huejhueyi tlamantli tlen Jesús quichijtoya nepa. ");
INSERT INTO nheNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Huan teipa Jesús mocuepqui altepetl Caná ipan estado Galilea campa achtohuiya quicuepqui atl ica xocomeca atl. Huan nechca Caná ipan altepetl Capernaum itztoya se hueyi tequihuejquetl tlen quitequitlalijtoya nopa hueyi tlanahuatijquetl ipan altepetl Roma. Huan nopa tequihue quipixqui se icone tlen mococohuayaya. ");
INSERT INTO nheNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Huan quema nopa tlacatl quicajqui para Jesús quistoya estado Judea huan ajsico ipan estado Galilea, yajqui campa Jesús huan quitlajtlani ma yohui ichaj ma quichicahuati ioquichpil pampa miquisnequiyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Huan Jesús quiilhui: ―¿Monequi ajachica nijchihuas tlanescayotl huan chicahualnescayotl para huelis innechneltocase ajqueya na? ");
INSERT INTO nheNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Huan itequihue nopa tlanahuatijquetl quiijto: ―Tate, ma tiyaca nimantzi pampa nocone miquis. ");
INSERT INTO nheNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Huan Jesús quiilhui: ―Xiya mochaj. Ya mochicajqui mooquichpil. Huan nopa tlacatl quineltocac tlen Jesús quiilhui huan quistejqui. ");
INSERT INTO nheNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Huan tonili ipan ojtli quinnamijqui itlatequipanojcahua huan quiilhuijque: ―Ya mochicajqui mocone. ");
INSERT INTO nheNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Huajca nopa tequihue quintlajtlani tlaque hora pejqui caxani nopa cocolistli, huan quiilhuijque: ―Yalhuaya quema panotoya tlajco tona caxanqui nopa tlatotonilotl. ");
INSERT INTO nheNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Huan itata nopa oquichpil quimatqui mochicajqui ipan nopa hora quema Jesús quiilhui para ya mochicajqui icone, yeca yajaya huan nochi ichampoyohua quineltocaque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Huajca Jesús quichijqui ni iompaca tlanescayotl quema quistoyaya estado Judea huan ajsitoya ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Teipa tiisraelitame tijpixque se ilhuitl huan Jesús yajqui altepetl Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Huan eltoya se hueyi ameli ipan Jerusalén tlen temitoya ica atl huan quitocajtiyayaj Betesda ipan tlajtoli hebreo. Nopa ameli eltoya nechca nopa puerta para Borregojme ipan nopa tepamitl tlen quiyahualtzajqui nopa altepetl. Huan nopa ameli quipixtoya macuili icalmapanyo. ");
INSERT INTO nheNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Huan ipan nochi nopa calmapamitl itztoyaj miyac cocoyani; sequin popoyotzitzi, sequin metzcuachotique huan sequin tlacame tlen ax huelque mojmoliníaj, san huajhuapahuixtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Quineltocayayaj para quemantzi hualayaya se elhuicac ejquetl huan quioliniyaya nopa atl. Huan moilhuijque san mochicahuasquía nopa achtohui cocoxquetl tlen calaquisquía ipan nopa atl. ");
INSERT INTO nheNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Huan nepa itztoya se tlacatl tlen quipixqui treinta y ocho xihuitl para huetztoc ica icocolis. ");
INSERT INTO nheNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Huan Jesús quiitac huetztoc huan quimatqui quipixtoya nopa cocolistli miyac xihuitl, huan quiilhui: ―¿Tijnequi timochicahuas? ");
INSERT INTO nheNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Huan nopa tlacatl quinanquili: ―Tate, axaca nijpiya para nechpalehuis nicalaquis ipan ni ameli quema mojmolinía nopa atl. Huan yonque nijchihua campeca nicalaquis, seyoc nechpano nimantzi huan calaqui achtohui. ");
INSERT INTO nheNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Huan Jesús quiilhui: ―Ximoquetza, xijtlalana mopetl huan xinejnemi. ");
INSERT INTO nheNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Huan nimantzi nopa tlacatl mochicajqui, huan quitlalanqui ipetl huan pejqui nejnemi. Huan eltoya sábado, nopa tonal para tiisraelitame ma timosiyajcahuaca. ");
INSERT INTO nheNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Huajca nopa tlayacanca israelitame quiilhuijque nopa tlacatl tlen mochicajtoya: ―Ama sábado huan itlanahuatil Moisés ax mitzcahuilía xijhuica mopetl. ");
INSERT INTO nheNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Huan yajaya quinnanquili: ―Nopa tlacatl tlen nechchicajqui nechilhui ma nijtlalana nopetl huan ma ninejnemi. ");
INSERT INTO nheNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Huajca quitlajtlanijque: ―¿Ajqueya mitzilhui xijtlalana mopetl huan xinejnemi? ");
INSERT INTO nheNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero yajaya tlen mococohuayaya ax quimatiyaya ajqueya quichicajtoya pampa Jesús quistejtoya huan nejnemiyaya ininhuaya nopa miyac tlacame tlen itztoyaj nepa. ");
INSERT INTO nheNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pero teipa Jesús quipanti nopa tlacatl ipan tohueyi israelita tiopa huan quiilhui: ―Xiquita, ya tiitztoc cuali. Huajca ayoc xitlajtlacolchihua para ax mitzajsis tlen más fiero. ");
INSERT INTO nheNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Huan nopa tlacatl yajqui huan quinilhui nopa tlayacanca israelitame para elqui Jesús tlen quichicajtoya. ");
INSERT INTO nheNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Huan yeca nopa tlayacanca israelitame pejque quitoquilijtinemij Jesús para quimictise pampa quichihuayaya tlamantli queja nopa ipan sábado quema tiisraelitame san timosiyajcahuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Huan Jesús quinnanquili: ―NoTata, Toteco Dios noja tequiti hasta ama, huajca quinamiqui para na noja nitequitis. ");
INSERT INTO nheNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ica ya ni nopa tlayacanca israelitame más quinequiyayaj quimictise Jesús, pampa ax san quichicajtoya se tlacatl ipan sábado, pero ama quinotzqui Toteco Dios: “NoTata”, queja yajaya elisquía san se ica Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Huajca Jesús quinilhui: “Nelía nimechilhuía, na tlen niIcone ax tleno hueli nijchihua noselti. Nijchihua san tlen niquita noTata quichihua. Nochi tlamantli tlen noTata quichihua, ya nopa na niIcone nojquiya nijchihua, ");
INSERT INTO nheNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","pampa noTata nechicnelía huan nechnextilía nochi tlen yajaya quichihua. Huan noTata nechnextilis tlamantli tlen noja más huejhueyi que ya ni tlen nijchijqui ama huan nelía inquisentlachilise. ");
INSERT INTO nheNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Pampa queja noTata quintlalana huan quinyolitía tlacame tlen mictoque, na niIcone nojquiya niquinyolitis nopa tlacame tlen nijnequi. ");
INSERT INTO nheNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pero noTata ax quintlajtolsencahuas tlacame. Nechmacatoc na nopa tequitl para nitetlajtolsencahuas. ");
INSERT INTO nheNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Quichijqui queja ni para nochi ma nechtlepanitaca ihuical queja quitlepanitaj noTata. Tlacame tlen ax nechtlepanitaj na niIcone, ax quitlepanitaj noTata tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Nelía nimechilhuía, intla se tlacatl quicaqui notlajtol huan quineltoca yajaya tlen nechtitlanqui, quipiyas yolistli yancuic para nochipa. Huan Toteco ax quema quitlatzacuiltis pampa yajaya ayoc yolmictoc. Ya panotoc tlen campa nochi mictoque hasta campa nochi quipiyaj yolistli para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nelía nimechilhuía, ajsis tonali, quena, ama ya ajsico nopa tonal quema tlacame tlen mictoque nechcaquise na tlen niIcone Toteco Dios. Huan inijuanti tlen nechtlacaquilise, yoltose. ");
INSERT INTO nheNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Pampa queja noTata quipiya yolistli ipan ya huan hueli quinyolitis tlacame, nojquiya nechmacatoc ma nijpiya yolistli ipan na huan para niquinyolitis. ");
INSERT INTO nheNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Huan nechmacatoc tequihuejcayotl para nitetlajtolsencahuas pampa na niitztoc niIcone tlen niMocuepqui Tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Amo xinechsentlachilica ica tlen nimechilhuía. Ajsis se tonal nojquiya quema nochi tlacame tlen mictoque huan tlen quintlalpachojtoque, nechcaquise huan panquisase. ");
INSERT INTO nheNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Tlacame tlen quichijtoque tlen cuali niquinyolitis huan itztose para nochipa, pero tlen quichijque tlen ax cuali niquinyolitis para quiselise tlatzacuiltilistli para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Noselti ax tleno hueli nijchihua. Queja noTata nechnahuatía, niquintlajtolsencahua tlacame. Na nitetlajtolsencahua xitlahuac pampa ax nijchihua san tlen na nijnequi, nijchihua ipaquilis noTata tlen nechtitlantoc nica. ");
INSERT INTO nheNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Intla san na nimechyolmelahua tlen na noselti, ax inquimatise intla melahuac notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero itztoc seyoc tlen inmechyolmelahua ajqueya na huan nijmati para melahuac tlen ya quiijtohua tlen na. ");
INSERT INTO nheNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Inquintitlanque tlacame ma yaca campa Juan para inquitlajtlanise tlen na. Huan yajaya inmechilhui tlen melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero ax nel hueyi ipati para se tlen san se tlacatl ma inmechilhui ajqueya na. Nimechilnamiquiltía tlen Juan inmechilhui para xijneltocaca tlen yajaya quiijto huan para queja nopa inmomaquixtise tlen imotlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan itztoya queja se tlahuili tlen tlahuiyaya huan tlatlanextiyaya. Huan para se tlalochtli inpaquiyayaj ica tlen inmechnextiliyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero na nijchijtoc tlanescayotl tlen más inmechnextilis ajqueya na que itlajtol Juan, pampa noTata nechmacac para ma nijchihua huejhueyi tlanescayotl para nimechnextilis melahuac ya nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nojquiya noTata tlen nechtitlantoc teyolmelahua para cuali tlen nijchihua. Pero ax quema inquiitztoque, niyon ax quema inquicactoque tlen ya quiijtohua. ");
INSERT INTO nheNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ax inquipiyaj itlajtol ipan imoyolo pampa ax innechneltocaj. Huan na niitztoc tlen ya inmechtitlanilijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Inmomachtíaj Itlajtol Toteco pampa inmoilhuíaj inquipiyase yolistli yancuic pampa inquipiyaj nopa amatl. Pero Itlajtol Toteco inmechilhuía tlen na. ");
INSERT INTO nheNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Huan ax inquinequij innechneltocase para nimechmacasquía nopa yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Para na, ax ipati intla imojuanti intlacame innechhueyichihuaj o axtle, ");
INSERT INTO nheNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","pampa nijmati ax inquiicnelíaj Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yonque na nihualajtoc ica itequihuejcayo noTata, ax innechselijque. Pero intla seyoc hualas ica san ya itequihuejcayo, quena, inquiselise. ");
INSERT INTO nheNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","¿Quejatza huelis innechneltocase? San inquitemohuaj para imohuampoyohua ma inmechtlepanitaca. Ax quema inmoilhuíaj tlaque monequi inquichihuase para ma inmechtlepanita Toteco huan itztoc san setzi Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Amo ximoilhuica nimechteilhuis iixpa noTata. Itlanahuatilhua Moisés tlen ipan inmotemachíaj para inmechmaquixtise, nopa tlanahuatili inmechteilhuise. ");
INSERT INTO nheNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Pampa intla nelía inquineltocasquíaj itlajtol Moisés, innechneltocasquíaj na nojquiya pampa yajaya quiijcuilo tlen na. ");
INSERT INTO nheNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero ax neli inquineltocaj tlen Moisés quiijcuilo, huajca ¿quejatza huelis inquineltocase tlen nimechilhuía?” ");
INSERT INTO nheNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Teipa Jesús apanoc nopa Hueyi Atl Galilea o Hueyi Atl Tiberias huan ajsito neca nali. ");
INSERT INTO nheNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Huan quitoquilijque miyac tlacame pampa ya quiitztoyaj nopa chicahualnescayotl tlen quichijqui quema quinchicajqui cocoyani. ");
INSERT INTO nheNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Huan Jesús huan tiimomachtijcahua titlejcoque ipan se tepetl huan yajaya mosehui tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Huan monechcahuiyaya nopa israelita ilhuitl tlen itoca Pascua. ");
INSERT INTO nheNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Huan yajaya quiitac nelmiyac tlacame ajsitihualayayaj campa tiitztoyaj huan huajca quitlajtlani Felipe: ―¿Canque tijcohuase tlen quicuase nochi ni tlacame? ");
INSERT INTO nheNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesús quiijto ya ni san para quimatis tlaque quiijtosquía Felipe pampa ya quimatiyaya tlaque quichihuasquía para quintlamacas. ");
INSERT INTO nheNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Huajca Felipe quinanquili: ―Intla se quipiyasquía itlaxtlahuil para ome ciento tonali tequitl, ax quiaxilisquía para ica tijcohuasquíaj pantzi para sesen inijuanti quicuasquíaj se quentzi. ");
INSERT INTO nheNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Huajca Andrés, iicni Simón Pedro, tlen nojquiya eliyaya imomachtijca Jesús quiijto: ");
INSERT INTO nheNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nica itztoc se oquichpil tlen quipiya ome pilmichtzitzi huan macuili pantzi, pero ya ni neltlahuel pilquentzi para nochi ni tlacame. ");
INSERT INTO nheNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Huajca Jesús quiijto: ―Xiquinilhuica nochi ni tlacame ma mosehuica tlalchi. Huan nopona oncayaya miyac sacapetlatl huan nochi nopa miyaqui tlacame mosehuijque. Huan san nopa tlacame tlen itztoyaj nopona eliyaya macuili mil. ");
INSERT INTO nheNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Huan Jesús quiitzqui nopa macuili pantzi huan quitlascamatqui Toteco. Teipa techmajmacac tojuanti tiimomachtijcahua para ma tiquinmajmacaca ica nochi tlen mosehuijtoyaj. Huan nojquiya quichijqui ihuical ica nopa michime. Huan nochi nopa tlacame quicuajque nochi tlen quinequiyayaj. ");
INSERT INTO nheNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Huan quema nochi ixhuitoyaj, Jesús techilhui tiimomachtijcahua: ―Xijsentilica nochi ne panpayaxtli huan ne michpayaxtli tlen mocajqui para ax tleno nenpolihuis. ");
INSERT INTO nheNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Huajca tijpejpenque nochi panpayaxtli huan tijtemitijque majtlactli huan ome chiquihuitl ica tlen mocajqui tlen nopa macuili pantzi. ");
INSERT INTO nheNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Huajca quema nopa tlacame quiitaque ni hueyi tlanextili quema Jesús quimiyaquili nopa pantzi, quiijtojque para nelía yajaya nopa tiocamanalojquetl tlen Toteco quiijto quititlanisquía ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Huan Jesús quimatqui para sequin inijuanti quinequiyayaj quiitzquise ica chicahualistli huan quitlalise queja inintlanahuatijca. Huajca sampa tlejcoc achi más huejcapa ipan tlamimili para itztos iselti. ");
INSERT INTO nheNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Huan quema tlayohuatinemiyaya, tiimomachtijcahua Jesús titemoque hasta campa hueyi atl, ");
INSERT INTO nheNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","huan ticalajque ipan cuacanahua huan pejque tiapano ipan nopa hueyi atl para tiajsitij altepetl Capernaum. Ya tlayohuatoya huan Jesús aya ajsitoya campa tiitztoyaj. ");
INSERT INTO nheNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Huan pejqui mojmolinía nopa hueyi atl pampa tlaajacayaya chicahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Huan quema ya tijnejnemiltijtoyaj tocuacanahua queja se macuili o chicuase kilómetros ipan hueyi atl, tiquitaque ajsitihualayaya Jesús nejnemiyaya aixco huan timomajmatijque. ");
INSERT INTO nheNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero yajaya techilhui: ―Najaya, amo ximomajmatica. ");
INSERT INTO nheNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Huajca ica paquilistli tijselijque Jesús ipan tocuacanahua huan quema tlejcoc, nimantzi tiquitaque tiajsitoyaj ipan nopa tlali campa tijnequiyayaj tiajsitij. ");
INSERT INTO nheNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Huan tonili nochi nopa tlacame sampa mosentilijque ipan ne seyoc nali campa achtohui tiitztoyaj pampa quimatiyayaj tiimomachtijcahua tiquisque nopona san toseltitzi ipan cuacanahua huan Jesús ax quisqui tohuaya. Nojquiya quimatque ax oncayaya seyoc cuacanahua nepa para ipan quisas Jesús. Huajca quitemohuayayaj Jesús ipan ne nali campa tiquistejque. ");
INSERT INTO nheNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Teipa ajsitoj nopona sequinoc pilcuacanahuajtzitzi tlen hualajtoyaj tlen altepetl Tiberias. Huan ajsitoj nechca campa Jesús quitlascamatqui iTata para nopa pantzi huan tetlamacac. ");
INSERT INTO nheNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Huajca quema nopa tlacame quiitaque ax aquiyaya Jesús neca nali huan ax tiaquiyayaj tiimomachtijcahua, inijuanti tlejcoque ipan nopa pilcuacanahuajtzitzi tlen ajsitoyaj huan hualajque hasta nica nali campa altepetl Capernaum campa tiitztoyaj para quitemose Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Huan quema inijuanti ajsicoj ni nali hueyi atl, quipantijque Jesús huan quitlajtlanijque: ―Tlamachtijquetl, ¿quemaya tiajsico nicani? ");
INSERT INTO nheNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Huan Jesús quinnanquili: ―Nelía nimechilhuía, san innechtemohuaj pampa inquicuajque pantzi huan inixhuique cuali. Ax innechtemohuaj pampa inquimachilijque nimechnextiliyaya ajqueya na ica nopa huejhueyi tlanescayotl. ");
INSERT INTO nheNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Amo tlahuel ximocuatotonica san para inquitlanise tlacualistli tlen inquicuase mojmostla huan tlen nimantzi tlami. Más cuali ximocuatotonica para inquipantise nopa tlacualistli tlen huejcahuas huan tlen inmechmacas yolistli yancuic para nochipa tlen na tlen niMocuepqui Tlacatl huelis nimechmacas. Pampa noTata, Toteco Dios, nechtequimacatoc ya nopa ma nijchihua. ");
INSERT INTO nheNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Huajca quitlajtlanijque: ―¿Tlaque monequi tijchihuase intla tijnequij tijchihuase tlen Toteco quinequi? ");
INSERT INTO nheNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Huan Jesús quinnanquili: ―Ya ni tlen Toteco quinequi xijchihuaca. Quinequi xinechneltocaca pampa yajaya nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","Huan inijuanti sampa quiilhuijque: ―Quema tijchihuas más tlanescayotl para tiquitase, huajca timitzneltocase. ¿Huelis titechtlamacas queja Moisés huejcajquiya quintlamacayaya tohuejcapan tatahua mojmostla ipan nopa huactoc tlali campa ax tleno eli? Pampa ijcuilijtoc ipan nopa amatl para ya quinmacac tlacualistli tlen huetzqui tlen elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Huan Jesús quinilhui: ―Nelía nimechilhuía, ax yajaya Moisés tlen quinmacac nopa tlacualistli tlen huetzqui tlen elhuicac. NoTata, quena, ya quinmacac. Quena, yajaya temaca nopa tlacualistli tlen nelía temachtli huan tlen huala elhuicac. ");
INSERT INTO nheNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Pampa nopa tlacualistli tlen Toteco temaca eltoc na tlen nitemoc tlen elhuicac huan niquinmaca yolistli yancuic tlen itztoque ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Huajca inijuanti quiilhuijque: ―Tate, xitechmaca nopa tlacualistli mojmostla. ");
INSERT INTO nheNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Huan Jesús quinilhui: ―Na nieltoc nopa tlacualistli tlen nitemaca yolistli yancuic para nochipa. Aqui hualas campa na huan nechneltocas, ax tleno más quitemos pampa ipan iyolo ayoc mayanas, niyon ayoc amiquis. ");
INSERT INTO nheNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero queja nimechilhui, yonque inquiitztoque tlen nihueli nijchihua, ax innechneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nochi tlacame tlen noTata quintlapejpenijtoc para nechmacas, hualase campa na, huan tlen hualase campa na, na ax quema niquincuepas. ");
INSERT INTO nheNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ax nihualtemoc tlen elhuicac para nijchihuas nopaquilis. Nihualtemoc para nijchihuas tlen noTata quinequi pampa ya nechtitlanqui. ");
INSERT INTO nheNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Huan ya ni ipaquilis noTata tlen nechtitlantoc, quinequi para axaca ma nijpolos tlen nechmacatoc. Yajaya quinequi para nochi ma niquinyolitis quema ajsis itlamiya tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Huan ya ni ipaquilis noTata. Quinequi nochi tlacame tlen quimachilise para na niIcone huan nechneltocase, ma quipiyaca yolistli yancuic para nochipa. Huan quinequi ma niquinyolitis quema ajsis itlamiya tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Quema Jesús quinilhui para yajaya nopa tlacualistli tlen hualtemoc tlen elhuicac, miyac israelitame pejque quiijilnamiquij, ");
INSERT INTO nheNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","huan quiijtojque: ―¿Quejatza hueli quiijtohua hualtemoc tlen elhuicac? Yajaya Jesús, icone José. Tiquixmatij itata huan inana nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Huajca Jesús quinilhui: ―Amo xinechijilnamiquica se ica seyoc. ");
INSERT INTO nheNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Axaca hueli nechtoquilis ica iselti. San noTata tlen nechtitlanqui huelis quiyoltilanas se tlacatl para ma nechtoquili. Huan tlen nechtoquilis, nijyolitis ipan itlamiya tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ijcuilijtoc ipan nopa amatl tlen itiocamanalojcahua Toteco quiijcuilojque campa quiijtohua: ‘Toteco quinmachtis nochi inijuanti.’ Huan huajca nochi inijuanti tlen quicaquij tlen noTata quinilhuía ipan ininyolo huan quimachilíaj, nechtoquilise. ");
INSERT INTO nheNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Axaca quiitztoc noTata, Toteco Dios, san na tlen nihualtemoc tlen campa itztoc. ");
INSERT INTO nheNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nelía nimechilhuía, intla se tlacatl nechneltocas, quipiyas yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na niitztoc nopa tlacualistli tlen temaca yolistli. ");
INSERT INTO nheNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Inmohuejcapan tatahua mijque yonque quicuajque nopa tlacualistli tlen huetzqui tlen elhuicac ipan nopa huactoc tlali. ");
INSERT INTO nheNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Na niitztoc nopa tlacualistli tlen hualtemoc tlen elhuicac huan intla se nechselis na queja niitlacualis, yajaya quipiyas yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na niitztoc nopa tlacualistli tlen yoltoc huan tlen temaca yolistli yancuic para nochipa huan nihualtemoc tlen elhuicac. Intla se quicuas ni tlacualistli, yajaya itztos para nochipa. Huan ni tlacualistli eltoc notlacayo tlen nitemacas para tlacame ipan ni tlaltepactli ma yoltojca para nochipa.” ");
INSERT INTO nheNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Huajca nopa israelitame pejque moijilhuíaj huan quiijtohuaj se ica seyoc: ―¿Quejatza huelis techmacas itlacayo para tijcuase? ");
INSERT INTO nheNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Huajca Jesús quinilhui: ―Nelía nimechilhuía na niMocuepqui Tlacatl. Huan intla ax innechselise queja elisquía inquicuase nonacayo huan inquiise noeso, ax inquipiyase nopa yolistli tlen yancuic. ");
INSERT INTO nheNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yajaya tlen nechselis queja se tlen quicuas nonacayo huan quiis noeso quipiyas yolistli yancuic para nochipa huan nijyolitis ipan itlamiya tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Pampa nonacayo eltoc nopa tlacualistli tlen nelnelía huan noeso nopa tlaili tlen nelía. ");
INSERT INTO nheNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Huan ajqueya quicuas nonacayo huan quiis noeso huan nechselis queja niitlacualis, yajaya senitztos ipan noyolo huan na nisenitztos ipan iyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","NoTata tlen yoltoc nechtitlantoc huan na niyoltoc pampa nechmaca ichicahualis. Quej nopa nojquiya ajqueya nechselis queja niitlacualis, yoltos pampa nijmacas nochicahualis. ");
INSERT INTO nheNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Na niitztoc nopa tlacualistli tlen hualtemoc tlen elhuicac. Ax nieltoc queja nopa tlacualistli tlen imohuejcapan tatahua quicuajque huan ax quipantijque nopa yolistli para nochipa. Nochi tlen nechselise queja niinintlacualis, quena, itztose para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Huan Jesús tlamachti ya ni ipan israelita tiopamitl ipan altepetl Capernaum. ");
INSERT INTO nheNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Huajca sequin imomachtijcahua Jesús quicajque tlen quinilhuijtoya, huan quiijtojque para nelía ohui itlajtol huan axaca hueli quimachilía. ");
INSERT INTO nheNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Huajca Jesús quimatqui para sequin imomachtijcahua quiijilnamiquiyayaj huan quinilhui: ―¿Ama inquiohuimatij para inquimachilise tlen niquijtohua? ");
INSERT INTO nheNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Miyac más inquiohuimatise quema innechitase na, tlen niMocuepqui Tlacatl, nitlejcos elhuicac campa niitztoya achtohuiya. ");
INSERT INTO nheNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Niquijto para san Itonal Toteco huelis temacas yolistli yancuic tlen ax quema tlamis. Intla se quicuasquía tlen nelía nonacayo, ax quimacas yolistli. Nimechilhuijtoc ni tlajtoli para xijmachilica ipan imotonaltzitzi pampa ipan imotonaltzitzi notlajtol inmechmacas yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero sequin imojuanti aya innechneltocaj. Ipan ipejya Jesús ipa quimatiyaya ajqueya ax quineltocasquía huan ajqueya quitemactilisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Huan Jesús quinilhui: ―Ya nimechilhuijtoc axaca huelis nechtoquilis intla noTata ax quiyoltilanas para ma nechneltoca. ");
INSERT INTO nheNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Huan yeca miyac tlacame tlen nejnemiyayaj ihuaya Jesús quistejque huan ayoc yajque ihuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Huajca Jesús techtlajtlani nochi timajtlactli huan ome tiimomachtijcahua: ―¿Nojquiya inquinequij innechtlahuelcahuase imojuanti? ");
INSERT INTO nheNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Huan Simón Pedro quinanquili: ―Tohueyiteco, san tlapic elisquía intla seyoc tijtoquilisquíaj. San ta titlamachtía nopa tlajtoli tlen hueli quinmaca yolistli yancuic para nochipa nopa tlacame tlen quineltocaj. ");
INSERT INTO nheNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Huan timitzneltocatoque huan cuali tijmatij ta tlen titlatzejtzeloltic. TiIcone Toteco Dios, yajaya tlen itztoc para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Huan Jesús quinnanquili: ―Na nimechtlapejpenijtoc inmajtlactli huan ome, pero se tlen imojuanti nelía iaxca Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesús techcamahuiyaya tlen Judas Iscariote icone Simón pampa teipa quitemactilis yonque Judas itztoya se tlen timajtlactli huan ome tiimomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Teipa Jesús nejnemiyaya campa hueli ipan estado Galilea campa ejqui. Ax quinejqui yas estado Judea pampa nepa nopa tlayacanca israelitame quinequiyayaj quimictise. ");
INSERT INTO nheNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ya ajsitihualayaya nopa israelita ilhuitl quema nochi tiisraelitame tijsencahuaj pilxajcaltzitzi para ipan tiitztose huan tijtlascamatij Toteco para nopa pixquistli tlen techmacac. ");
INSERT INTO nheNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Huan iicnihua Jesús quihuihuiitaque huan quiilhuijque: ―Amo ximocahua nica. Xiya estado Judea para motlatoquilijcahua nopona huelis quiitase nopa tlanescayotl tlen tijchihua. ");
INSERT INTO nheNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Axaca mocahua campa ixtacatzi intla quinequi nochi tlacame ma quiixmatica queja ta tijnequi. Intla nelnelía tihueli tijchihua huejhueyi chicahualnescayotl, ximonextiti iniixpa nochi nopa miyac tlacame tlen itztose ipan nopa ilhuitl. ");
INSERT INTO nheNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Iicnihua quiijtojque ya ni pampa niyon inijuanti, ax quineltocayayaj. ");
INSERT INTO nheNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Huajca Jesús quinilhui: ―Aya ajsi nopa tonal tlen Toteco quiixtlalijtoc para nimonextiti nepa. Para imojuanti, hueli inyase tlen hueli tonal. ");
INSERT INTO nheNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tlacame tlen ni tlaltepactli ax inmechcocolíaj. Pero tlen ax quiixmatij Toteco nechcocolíaj pampa niquinyolmelahua tlen ax cuali quichihuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xitlayacanaca campa nopa ilhuitl pampa aya ajsi hora para niyas na. ");
INSERT INTO nheNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Quema Jesús quinilhuijtoya iicnihua ya ni, noja mocajqui quentzi más ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Huan quema iicnihua ya yajtoyaj, Jesús nojquiya quisqui para yas ipan nopa ilhuitl. Pero ax yajqui ininhuaya nopa miyac tlacame, san ixtaca yajqui. ");
INSERT INTO nheNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Huan nopa israelita tlayacanani quitemohuayayaj Jesús ipan ilhuitl huan tetlajtlaniyayaj: ―¿Canque itztoc nopa tlacatl? ");
INSERT INTO nheNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Huan miyac tlacame quiijilnamictinemiyayaj Jesús se ica seyoc. Sequin quiijtohuayayaj: “Yajaya se cuali tlacatl.” Sequinoc quiijtohuayayaj: “Yajaya ax cuali, san tlacajcayahua.” ");
INSERT INTO nheNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Huan axaca quinequiyaya camatis cuali tlen Jesús tlamiyacapa, pampa quinimacasiyayaj nopa tlayacanani tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Huan quema noja polihuiyaya tlajco nopa ilhuitl, Jesús tlejcoc tlachiquiltipa hasta campa nopa hueyi tiopamitl huan pejqui tlamachtía. ");
INSERT INTO nheNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Huan nopa tlayacanca israelitame san quisentlachiliyayaj huan quiijtohuayayaj se ica seyoc: ―¿Quejatza más tlalnamiqui ni Jesús que sequinoc huan ax momachtijtoc? ");
INSERT INTO nheNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Huan Jesús quinnanquili: ―Ax nitlamachtía san tlen na nimoilhuía. Nitlamachtía tlen quiijtohua noTata tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Intla se tlacatl quinequi quichihuas ipaquilis noTata, quimatis intla nitlamachtía tlen Toteco itlajtol o san na notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Se tlen san camati tlen ya moilhuía iselti quinequi para sequinoc ma quihueyichihuaca. Pero na nijnequi nijhueyichihuas yajaya tlen nechtitlantoc. Huan niquijtohua tlen melahuac huan ax quema niistlacati. ");
INSERT INTO nheNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moisés inmechmacac nopa tlanahuatili, pero niyon se imojuanti ax inquitoquilíaj nopa tlanahuatili pampa inquinequij innechmictise.” ");
INSERT INTO nheNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Huan nopa tlacame quinanquilijque: ―Ta tijpiya se iajacayo Axcualtlacatl. Axaca quinequi mitzmictis. ");
INSERT INTO nheNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Huan Jesús quinilhui: ―Quema nijchicajqui nopa tlacatl ipan sábado nopa tonal para timosiyajcahuase, innechsentlachilijque pampa inquiijtojque nitequitiyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero Moisés inmechmachti para xijtequica nopa tlanescayotl tlen itoca circuncisión ipan ipiltlacayo se piloquichpiltzi quema quipiya chicueyi tonali tlacajtoc. (Yonque ax pejqui ni tlamantli ica Moisés pampa tohuejcapan tatahua ya ipa quichihuayayaj quema Moisés aya tlacatiyaya.) ");
INSERT INTO nheNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Huan quema ajsis ichicueyi tonal se oquichpil ipan sábado, nojquiya intequitij pampa inquitequilíaj nopa tlanescayotl. Huan queja nopa monequi para inquitoquilise itlanahuatil Moisés, pero ¿para tlen innechcocolíaj pampa nijchicajqui nopa tlacatl ipan sábado? ");
INSERT INTO nheNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amo nimantzi xijteilhuica se tlacatl pampa san nesi quichijtoc tlen ax cuali. Achtohui xijmatica cuali intla melahuac para queja nopa huelis inquitlajtolsencahuase xitlahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sequin nopa tlacame tlen ejque altepetl Jerusalén pejque quiijtohuaj: ―¿Ax ya ne Jesús tlen nopa israelita tequihuejme quinequij quimictise? ");
INSERT INTO nheNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xiquitaca, moquetza nepa huan camati iniixpa nochi ni tlacame. ¿Para tlen ax tleno quiijtohuaj nopa tequihuejme? ¿Huelis inijuanti ya quimatij para yajaya nopa Cristo tlen Toteco quiijto techtitlanilisquía? Huan sequinoc quiijtohuayayaj: ");
INSERT INTO nheNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","―Pero tojuanti tijmatij campa ejqui ni Jesús. Huan quema Cristo hualas tlen Toteco techtitlanilis, axaca quimatis campa hualajqui. ");
INSERT INTO nheNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Huajca Jesús tlen tlamachtiyaya ipan nopa hueyi tiopamitl camatqui chicahuac huan quinilhui: ―Inquiijtohuaj innechixmatij huan inquimatij campa niejqui. Pero ax nihualajqui san pampa na nijnejqui. Yajaya tlen nelía temachtli nechtitlantoc, huan imojuanti ax inquiixmatij. ");
INSERT INTO nheNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na quena, niquixmati pampa niitztoya ihuaya huan yajaya nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Huajca sequin nopa tlacame quinequiyayaj quiitzquise Jesús para quitzacuase, pero axaca huelqui quiitzqui pampa noja aya ajsiyaya nopa hora tlen Toteco quiixquetztoya para quiitzquise. ");
INSERT INTO nheNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Huan miyac nopa tlacame tlen itztoyaj nepa quineltocaque para Jesús eliyaya nopa Cristo huan yeca quiijtojque: ―Ijcuilijtoc para quema nopa Cristo hualas quichihuas huejhueyi tlanescayotl. Pero axaca huelis quichihuas chicahualnescayotl tlen más huejhueyi que ni Jesús quichihua. Huajca nelía ni Jesús yajaya Cristo. ");
INSERT INTO nheNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Quema nopa fariseos quicajque tlen nochi tlacame quiijtohuayayaj tlen Jesús, inijuanti huan nopa tlayacanca totajtzitzi quinnahuatijque ma yaca policías tlen nopa tiopamitl para ma quiitzquitij huan ma quitzacuatij. ");
INSERT INTO nheNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Huan Jesús noja quincamahuiyaya nopa tlacame huan quinilhui: ―Noja nimocahuas imohuaya se quentzi más tonali huan teipa nimocuepas campa itztoc yajaya tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Innechtemose pero ax huelis innechpantise. Huan campa na niitztoti ax huelis inyase. ");
INSERT INTO nheNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Huajca nopa israelitame pejque quiijtohuaj se ica seyoc: ―¿Canque yas huan ax huelis tiyase, niyon ax tijpantise? ¿Huelis yas campa nopa israelitame tlen mosemantoque huejca campa tlacame camatij griego? ¿Huelis quinmachtiti nojquiya nopa griego tlacame? ");
INSERT INTO nheNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Tlaque quiijtosnequi quema yajaya quiijtohua para tijtemose, pero ax huelis tijpantise? ¿Campa itztoti ax huelis tiyase? Ax tijmachilíaj tlaque quiijtosnequi. ");
INSERT INTO nheNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ipan itlamiya tonal nopa ilhuitl, nopa tonal tlen más hueyi, Jesús moquetzqui tlatlajco nochi nopa tlacame huan camatqui chicahuac. Huan quinilhui: ―Intla se amiqui ipan iyolo, ma huala campa na ma atliqui. ");
INSERT INTO nheNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Yajaya tlen nechneltocas quipiyas miyac atemitl ipan iyolo campa quisas atl tlen temacas yolistli yancuic para nochipa. Quej nopa ijcuilijtoc ipan Itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesús quiijto ya ni pampa moilhuiyaya tlen teipa panosquía quema Itonal Toteco calaquisquía ipan tlacame tlen quineltocasquíaj. Pero quiijto ya ni quema noja polihuiyaya para ajsis Itonal Toteco ipan tlaltepactli pampa Jesús aya mocuepayaya elhuicac campa Toteco quihueyitlalisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sequin nopa tlacame tlen quicajque tlen quiijto Jesús quiijtohuayayaj para yajaya temachtli eliyaya nopa tiocamanalojquetl tlen Toteco techtitlanilisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Huan sequinoc quiijtohuayayaj para Jesús eliyaya nopa Cristo tlen Toteco quiijto techtitlanilisquía. Pero sequinoc quiijtohuayayaj para Jesús ax huelis elis nopa Cristo pampa nopa Cristo ax hualasquía ipan estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Quiijtohuayayaj para Itlajtol Toteco quiijtohua Cristo elis se iteipa ixhui nopa hueyi tlanahuatijquetl David tlen huejcajquiya itztoya huan Cristo tlacatis ipan Belén, ialtepe David. ");
INSERT INTO nheNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Huajca queja ni tlacame moxejxelojque ica tlen moilhuijque tlen Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huan sequin quinequiyayaj quiitzquise huan quitzacuase, pero ax quichijque. ");
INSERT INTO nheNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Huan nopa policías tlen tiopamitl mocuepque campa itztoyaj nopa fariseos huan nopa tlayacanca totajtzitzi. Huan nopa tequihuejme quintlajtlanijque nopa policías: ―¿Para tlen ax inquihualicaque Jesús? ");
INSERT INTO nheNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Huan nopa policías tlen tiopa quiijtojque: ―Ax quema tijcactoque se tlacatl tlen camati nelía cuali queja ya camati. ");
INSERT INTO nheNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Huajca nopa fariseos quiijtojque: ―¿Yajaya inmechcajcayajtoc nojquiya? ");
INSERT INTO nheNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Niyon se israelita tequihue huan niyon se fariseo ax quineltoca. ");
INSERT INTO nheNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero ni miyac tlacame tlen quitoquilíaj, ax tleno quimatij tlen itlanahuatil Moisés. Huajca nochi ma mocuapoloca. ");
INSERT INTO nheNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Huan Nicodemo tlen achtohuiya quicamahuito Jesús ica tlayohua itztoya se tlen nopa fariseos huan quinilhui nopa sequinoc: ");
INSERT INTO nheNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Totlanahuatil ax techcahuilíaj ma tijtlatzacuiltica se tlacatl intla ax tijtlacaquilise tlen quiijtohua para tijmatise intla nelía quipiya tlajtlacoli. ");
INSERT INTO nheNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Huajca nopa sequinoc quiilhuijque: ―Nesi queja ta nojquiya tiehua estado Galilea campa itztoque tlacame tlen huihuitique. Xijpohua Itlajtol Toteco huan tiquitas ax quema motlalantoc se tiocamanalojquetl tlen ehua Galilea. ");
INSERT INTO nheNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Huan sesen inijuanti yajque ininchajchaj. ");
INSERT INTO nheNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero Jesús yajqui ipan se tepetl tlen itoca Olivo, ");
INSERT INTO nheNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","huan tonili ijnaltzi mocuepqui campa nopa hueyi tiopamitl ipan Jerusalén. Huan hualajque miyac tlacame campa Jesús huan ya mosehui huan pejqui quinmachtía. ");
INSERT INTO nheNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Huajca nopa tlamachtiani tlen itlanahuatil Moisés huan nopa fariseos quihualicaque se sihuatl tlen quipantijque quichihuayaya tlen hueli ihuaya se tlacatl tlen ax ihuehue. Huan quiquetzque nopa sihuatl tlatlajco nopa tlacame iixpa Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Huan quiilhuijque Jesús: ―Tlamachtijquetl, tijpantijque ni sihuatl quichihuayaya tlen hueli ica se tlacatl tlen ax ihuehue. ");
INSERT INTO nheNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Itlanahuatilhua Moisés technahuatía ma tiquinmictica ni tlamantli sihuame ica tetl. Huan ta, ¿quejatza tiquijtohua? ");
INSERT INTO nheNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Quitlajtlanijque Jesús ya ni para quimasiltise huan para huelis quiteilhuise intla ax quineltocasquía itlanahuatil Moisés. Huajca Jesús molocotzsehui huan tlajcuilo ipan tlali ica se imacpil. ");
INSERT INTO nheNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero inijuanti noja quitlajtlaniyayaj quejatza quiijtosquía. Huajca Jesús moquetzqui huan quiijto: ―Cualtitoc. Nopa tlacatl tlen ax quema tlajtlacolchijtoc achtohui ma quimajcahuili se tetl. ");
INSERT INTO nheNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Huan sampa molocotzsehui huan tlajcuilo ipan tlali. ");
INSERT INTO nheNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Huan quema inijuanti tlen quiteilhuiyayaj nopa sihuatl quicajque tlen Jesús quiijto, pejque yajtiyohuij sesentzitzi. Achtohui yajqui tlen más huehuentzi huan teipa sesentzitzi yajtiyajque hasta san nopa sihuatl mocajqui iixpa Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Huajca Jesús moquetzqui huan quiilhui: ―¿Canque itztoque tlen mitzteilhuiyayaj? ¿Axaca tlen quinequi mitztepachos? ");
INSERT INTO nheNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Huan nopa sihuatl quiijto: ―Axtle, tate, axaca aqui. Huajca Jesús quiijto: ―Niyon na ax nimitzteilhuía. Xiya huan ayoc xitlajtlacolchihua. ");
INSERT INTO nheNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sampayano Jesús quincamahui nopa tlacame tlen quiyahualojtoyaj huan quinilhui: ―Na niitztoc queja nopa tlahuili ipan ni tlaltepactli huan nitetlahuilía ipan teyolo. Tlen nechtoquilise ayoc quipiyase tzintlayohuilotl ipan ininyolo pampa quipiyase nopa tlahuili tlen temaca yolistli tlen yancuic. ");
INSERT INTO nheNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Huajca nopa fariseos quiilhuijque: ―Ticamati tlen ta moselti huan huajca ax melahuac motlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero Jesús quinnanquili: ―Yonque nimechilhuía tlen na, melahuac tlen niquijtohua pampa nijmati campa nihualajqui huan campa niyas. Pero ax inquimatij campa nihualajqui huan campa niyas teipa. ");
INSERT INTO nheNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Intetlajtolsencahuaj queja momajtoque tlacame. Na axaca nijtlajtolsencahua amantzi. ");
INSERT INTO nheNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero intla nitetlajtolsencahuasquía, nijchihuasquía xitlahuac pampa ax san na nijchihua, pero nitetlajtolsencahuasquía ihuaya noTata tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ipan imotlanahuatil ijcuilijtoc intla itztoque ome tlen quiitztoque tlen panoc huan quiijtohuaj san se tlamantli, huajca xiquitaca para temachtli tlen quiijtohuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ama nimechilhuía tlen na huan nojquiya noTata tlen nechtitlantoc inmechilhuía tlen na, huajca temachtli tlen tiome timechyolmelahuaj. ");
INSERT INTO nheNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Huan inijuanti quitlajtlanijque: ―¿Canque itztoc motata? Huan Jesús quinnanquili: ―Imojuanti ax innechixmatij huan ax inquiixmatij noTata. Intla innechixmatisquíaj, nojquiya inquiixmatisquíaj noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nochi ni tlajtoli Jesús quinmachti ipan nopa hueyi tiopan calijtic nechca campa tlacame temacaj inintomi para tiopamitl. Huan axaca quiitzqui pampa aya ajsiyaya ihora para quiitzquise. ");
INSERT INTO nheNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Huan Jesús sampa quinilhui: ―Na niyas huan teipa innechtemose. Huan quema inmiquise, noja inquipiyase imotlajtlacolhua pampa axaca inmechtlapojpolhuijtos. Campa na niyas, imojuanti ax huelis inyase. ");
INSERT INTO nheNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Huajca nopa tlayacanani tlen israelitame pejque motlajtlaníaj se ica seyoc: ―¿Para tlen quiijto para ax huelis tiyase campa yas? ¿Huelis san momictis? ");
INSERT INTO nheNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Huan Jesús quinilhui: ―Inehuaj nica tlatzintla, na niehua huejcapa ipan elhuicac. Inehuaj ipan ni tlaltepactli, pero na ax niehua ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Huajca nimechilhuía inmiquise huan noja inquipiyase imotlajtlacolhua huan inyase campa tlitl. Pampa intla ax innechneltocase para na niCristo, huajca inmiquise ipan imotlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Huajca inijuanti quiilhuijque: ―¿Ajqueya ta? ¿Tlaque tequihuejcayotl tijpiya? Huan Jesús quinilhui: ―Niitztoc senquistoc tlen nimechilhuiyaya nochi ni tonali hasta quema nipejqui nitlamachtía. ");
INSERT INTO nheNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Onca miyac más tlajtoli tlen huelisquía nimechilhuisquía huan onca miyac tlamantli tlen ica nihuelis nimechtlajtolsencahuas. Pero san niquinilhuía tlacame ipan ni tlaltepactli tlen yajaya tlen nechtitlantoc nechilhuijtoc ma niquinilhui. Huan yajaya nelía temachtli. ");
INSERT INTO nheNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Huan nopa israelita tequihuejme ax quimachiliyayaj para quincamahuiyaya tlen iTata, Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Huajca Jesús quinilhui: ―Quema innechcuamapeloltise na tlen niMocuepqui Tlacatl, huajca inquimachilise niitztoc tlen nimechilhuía. Huan inquimachilise ax tleno nijchihua noselti, pero nimechilhuijtoc tlen noTata nechmachtijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Huan noTata tlen nechtitlantoc itztoc nohuaya huan ax nechcajtejtoc pampa mojmostla nijchihua tlen quipactía. ");
INSERT INTO nheNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Quema Jesús quiijto ni tlamantli, miyac israelitame quineltocaque para yajaya nopa Cristo. ");
INSERT INTO nheNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Huajca Jesús quinilhui nopa israelitame tlen quineltocaque: ―Intla mojmostla inquichijtiyase tlen nimechilhuía, huajca nelía initztose innomomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Huan inquimatise tlen melahuac, huan nopa tlen melahuac inmechtojtomas para huelis innemise inmajcajtoque. ");
INSERT INTO nheNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Huan nopa tlayacanca israelitame quinanquilijque: ―Tojuanti tiiteipa ixhuihua Abraham huan ax quema techcojtoc se tecojtli para tiiaxcahua. ¿Para tlen titechilhuía titechtojtomas para tiyase timalacantoque? ");
INSERT INTO nheNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Huan Jesús quinnanquili: ―Nimechilhuía, yajaya tlen tlajtlacolchihua melahuac monamacatoc ica tlajtlacolotl huan tlajtlacolotl iteco. ");
INSERT INTO nheNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Se tlatequipanojquetl tlen iaxca iteco ax quipiya tequihuejcayotl para mocahuas para nochipa ipan ifamilia iteco, intla iteco ayoc quinequis; pero icone nopa caltecojtli, quena, quipiya tlanahuatili para mocahuas nochipa pampa ya icone. ");
INSERT INTO nheNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Na niIcone Toteco huan intla nimechtojtomas tlen tlajtlacoli, nelía inelise senquistoc inmajcajtoque. Huan ayoc monequis inquichihuase tlen tlajtlacoli inmechnahuatis xijchihuaca. ");
INSERT INTO nheNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Cuali nijmati initztoque initeipa ixhuihua tohuejcapan tata Abraham, pero yonque initztoque initeipa ixhuihua, inmoilhuíaj quejatza huelis innechmictise pampa ax inquiselíaj notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nimechilhuía tlen niquitztoc nepa iixpa noTata. Huan inquichihuaj tlen imotata inmechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Huan quinanquilijque: ―Abraham yajaya totata. Huan Jesús quinilhui: ―Intla nelía initztosquíaj iniconehua Abraham, huajca inquichihuasquíaj tlen cuali queja Abraham quichijqui. ");
INSERT INTO nheNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero inquinequij innechmictise, huan nimechilhuijtoc tlen melahuac. Huan tlen Toteco nechilhuijtoc. Abraham ax quichijqui tlamantli queja nopa. ");
INSERT INTO nheNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inquichihuaj queja tlen nelía imotata quichihua. Huan nopa tlayacanca israelitame quiilhuijque: ―Amo xiquijto para san tiicno coneme. Tijpiyaj se totata, yajaya Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Huan Jesús quinilhui: ―Intla Toteco Dios nelía elisquía imotata, huajca innechicnelisquíaj pampa nihualajqui iixpa. Ax nihualajqui pampa san nijnejqui, pero yajaya nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ax inquinequij inquitlacaquilise notlajtol, huajca ax hueli inquimachilíaj tlen nimechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Imotata yajaya Axcualtlacatl huan inquinequij inquichihuase tlen ya ipaquilis. Nopa Axcualtlacatl ipa eliyaya se temictijquetl hasta ipejya huan quicocolía nochi tlen melahuac huan ax hueli quiijtohua tlen melahuac. Senquistoc istlacatitinemi pampa queja nopa iyolo. Yajaya se istlacatiquetl huan nochi istlacayotl pehua ica ya. ");
INSERT INTO nheNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nimechilhuía senquistoc tlen melahuac, huajca ¿para tlen ax innechneltocaj? ");
INSERT INTO nheNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Niyon se tlen imojuanti hueli nechteilhuis ica se tlajtlacoli. Huajca intla nimechilhuía tlen melahuac, ¿para tlen ax innechneltocaj? ");
INSERT INTO nheNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tlacame tlen iconehua Toteco quitlacaquilíaj itlajtol, pero ax inquinequij inquitlacaquilise itlajtol pampa ax initztoque iconehua Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Huajca nopa tlayacanani tlen israelitame quinanquilijque Jesús huan quiilhuijque: ―Melahuac tlen tojuanti tiquijtojque tlen ta. Tiitztoc se tlacatl tlen ax cuali queja tlen ehua estado Samaria huan tijpiya se iajacayo Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Huan Jesús quinnanquili: ―Na ax nijpiya se iajacayo Axcualtlacatl. Na nijtlepanita noTata huan ax innechtlepanitaj. ");
INSERT INTO nheNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pero ax nijtemohua tlacame ma nechhueyimatica. NoTata, quena, quinequi tlacame ma nechhueyimatica huan yajaya tlen quitlajtolsencahuas ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nelía nimechilhuía, ajqueya quichihuas tlen niquilhuía, ax quipantis miquistli. ");
INSERT INTO nheNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Huan nopa israelitame quiilhuijque: ―Amantzi tijmatij tijpiya se iajacayo Axcualtlacatl pampa Abraham mijqui huan nopa tiocamanalohuani nojquiya. Huan ta tiquijtohua ajqueya quichihuas tlen tiquilhuía, ax quipantis miquistli. ");
INSERT INTO nheNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ta timoilhuía tiitztoc más hueyi que totata Abraham. Yajaya mijqui huan nopa tiocamanalohuani nojquiya. ¿Ajqueya timoilhuía para tiitztoc ta? ");
INSERT INTO nheNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Huajca Jesús quinnanquili: ―Intla san na nimohueyimati, huajca ax tleno ipati tlen niquijtohua. Pero noTata, Toteco Dios, nechhueyimati huan inquiijtohuaj yajaya imoTeco. ");
INSERT INTO nheNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Nelía ax inquiixmatij noTata. Pero na, quena, niquixmati. Intla niquijtosquía ax niquixmati, huajca niistlacatisquía queja inistlacatij. Pero, quena, na niquixmati huan nijchihua tlen nechilhuía. ");
INSERT INTO nheNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Huejcajquiya tohuejcapan tata Abraham pajqui quema quimatqui para teipa nihualasquía, huan yajaya nechitac quema nihualajqui huan nelía quipixqui paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Huan nopa tlayacanca israelitame quiilhuijque: ―Ta ax quema tiquitztoc Abraham. Aya tijpiya niyon cincuenta xihuitl. ");
INSERT INTO nheNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Huan Jesús quinilhui: ―Melahuac ya ni tlen nimechilhuía, quema polihuiyaya para tlacatis Abraham, na ipa niitztoya. ");
INSERT INTO nheNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Huajca inijuanti quitlalanque sesen tetl para quitepachosquíaj, pero Jesús ixtaca quistejqui ipan nopa hueyi tiopamitl huan panotiyajqui tlatlajco inijuanti. ");
INSERT INTO nheNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús nejnemiyaya ipan ojtli, huan quiitac se tlacatl tlen popoyotzi tlen queja nopa tlacatqui. ");
INSERT INTO nheNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Huan tiimomachtijcahua tijtlajtlanijque: ―Tlamachtijquetl, ¿ajqueya itlajtlacol para elqui popoyotzi ne tlacatl? ¿Itlajtlacol inana o itata o san ya itlajtlacol? ");
INSERT INTO nheNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Huan Jesús techilhui: ―Ax tlacatqui popoyotzi pampa itlajtlacol, niyon pampa itlajtlacol inana, niyon itata. Tlacatqui queja nopa para ma monextis ipan ya tlen Toteco ica ihueyi chicahualis hueli quichihua. ");
INSERT INTO nheNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Monequi nijchihuas nopa tequitl tlen Toteco nechtitlantoc ma nijchihua quema noja tona huan onca hora, pampa san quentzi polihui para tlayohuas huan ayoc aca huelis tequitis. ");
INSERT INTO nheNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ama quema noja niitztoc ipan ni tlaltepactli, niitztoc itlahuil ni tlaltepactli huan niquintlahuilijtos tlacame ipan inintlalnamiquilis. ");
INSERT INTO nheNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Huan quema quiijtojtoya ni tlajtoli, Jesús chajchac huan quichijqui soquitl ica ichajcha huan quitlalili nopa soquitl ipan iixtiyol nopa tlacatl tlen popoyotzi. ");
INSERT INTO nheNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Huan quiilhui: ―Xiya, ximoixtiyolpajpacati ipan nopa ameli tlen itoca Siloé. (Siloé quinequi quiijtos: ‘Tlatitlanili’.) Huajca nopa popoyotzi yajqui moixtiyolpajpacato huan quema mocuepqui, cuali hueliyaya tlachiya. ");
INSERT INTO nheNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Huajca nochi icalnechcahua huan nochi tlen quiixmatiyayaj quema noja itztoya popoyotzi moilhuijque: ―¿Ax ni tlacatl yajaya tlen mosehuiyaya ojtipa huan motlaejehuiliyaya? ");
INSERT INTO nheNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Huan sequin quiijtojque: ―Quena, yajaya. Sequinoc quiijtojque: ―Ax ya, pero elisnequi queja ya. Pero nopa tlacatl iselti quiijto: ―Quena, na tlen achtohuiya nieltoya nipopoyotzi. ");
INSERT INTO nheNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Huajca quitlajtlanijque: ―¿Quejatza huelqui titlachixqui? ");
INSERT INTO nheNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Huan quinnanquili: ―Se tlacatl tlen itoca Jesús quichijqui soquitl huan nechtlalili ipan noixtiyol huan nechilhui ma niya nimoixtiyolpajpacati ipan nopa ameli tlen itoca Siloé. Huajca niyajqui huan nimoixtiyolpajpajqui huan huajca huelqui nitlachixqui. ");
INSERT INTO nheNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Huan quitlajtlanijque: ―¿Canque itztoc nopa tlacatl Jesús? Huan nopa tlacatl tlen eltoya popoyotzi quinilhui: ―Ax nijmati. ");
INSERT INTO nheNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Huan quihuicaque nopa tlacatl tlen eltoya popoyotzi iniixpa nopa fariseos. ");
INSERT INTO nheNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Huan eltoya sábado nopa tonal quema tiisraelitame ax titequitij quema Jesús quichijqui soquitl huan quichicajqui nopa tlacatl. Huan nopa fariseos moilhuijque eltoya se tequitl. ");
INSERT INTO nheNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Huajca inijuanti nojquiya quitlajtlanijque quejatza huelqui tlachiya. Huan quinilhui: ―Nechtlalili soquitl ipan noixtiyol, huan nimoixtiyolpajpacato huan huajca nitlachixtejqui. ");
INSERT INTO nheNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Huajca sequin nopa fariseos quiijtojque: “Toteco ax quititlantoya ni tlacatl tlen quichijqui ya ni pampa tequitqui ipan sábado quema monequi timosiyajcahuase.” Pero sequinoc moilhuiyayaj para se tlaixpanoquetl ax huelis quichihuas se hueyi tlanescayotl queja ya ni. Huajca motlajcoxelojque. ");
INSERT INTO nheNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Huan sampa nopa fariseos quitlajtlanijque nopa tlacatl tlen mochicajtoya: ―¿Tlaque tiquijtohua ta tlen yajaya tlen mitztlachiyalti? Huan nopa tlacatl quiijto: ―Yajaya se tiocamanalojquetl. ");
INSERT INTO nheNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nopa israelita tlayacanani ax quineltocayayaj intla nelía nopa tlacatl eliyaya tlen achtohuiya eltoya popoyotzi huan ama hueli tlachiya, huajca quinnotzque inana huan itata. ");
INSERT INTO nheNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Huan nojquiya quintlajtlanijque: ―¿Nelía, ni imotelpoca? ¿Nelía tlacatqui popoyotzi? Huajca ¿quejatza hueli tlachiya ama? ");
INSERT INTO nheNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Huan inana huan itata quinnanquilijque: ―Tojuanti tiquixmatij ni totelpoca huan tijmatij tlacatqui popoyotzi. ");
INSERT INTO nheNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero ax tijmatij quejatza hueli tlachiya ama, niyon ax tijmatij ajqueya quichicajqui iixtiyol. Xijtlajtlanica ya pampa ya tlacatl huan yajaya huelis inmechilhuis tlen panoc. ");
INSERT INTO nheNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Inana huan itata quiijtojque ya ni pampa quinimacasiyayaj nopa israelitame pampa nopa tlayacanani tlen israelitame ya teyolmelajtoyaj intla se tlacatl quiijtosquía para Jesús eltoya nopa Cristo tlen Toteco quiijto para quititlanisquía, huajca ayoc quicahuilisquíaj ma calaqui ipan tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Huajca inana huan itata quiijtojque: ―Xijtlajtlanica ya pampa ya tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Huajca ica ompa quinotzque nopa tlacatl tlen achtohuiya eltoya popoyotzi huan quiilhuijque: ―Xijhueyichihua Toteco Dios, huan xitechilhui yajaya mitzchicajqui huan ax ya Jesús, pampa tojuanti tijmatij nopa Jesús se tlajtlacolchijquetl. ");
INSERT INTO nheNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Huajca nopa tlacatl quinnanquili: ―Ax nijmati intla yajaya se tlajtlacolchijquetl o axtle. San ya ni nijmati. Achtohuiya niitztoya nipopoyotzi huan ama hueli nitlachiya. ");
INSERT INTO nheNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yeca inijuanti sampa quitlajtlanijque: ―¿Tlaque mitzchihuili? ¿Quejatza mitztlachiyalti? ");
INSERT INTO nheNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Huan nopa tlacatl quinilhui: ―Ya nimechilhui huan ax innechcajque. ¿Para tlen inquinequij ma nimechilhui sampa? ¿Huelis inquinequij inquitoquilise nojquiya? ");
INSERT INTO nheNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Huan nopa tlayacanani quiajhuaque nopa tlacatl tlen achtohuiya eltoya popoyotzi huan quiilhuijque: ―Ta tijtoquilía Jesús, pero tojuanti tijtoquilíaj Moisés. ");
INSERT INTO nheNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Tijmatij Toteco quicamahui Moisés, pero nopa Jesús ax tijmatij campa hualajtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Huajca nopa tlacatl quinilhui: ―¿Tlaque ya ni? Ax inquimatij canque hualajqui, pero yajaya nechtlachiyalti. ");
INSERT INTO nheNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nochi tijmatij Toteco ax quinpalehuía ax cuajcualme, pero intla se tlacatl quitlepanita Toteco huan quichihua ipaquilis Toteco, huajca quena, Toteco quitlacaquilis tlen quitlajtlanis. ");
INSERT INTO nheNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Hasta quema pejqui tlaltepactli huan hasta ama, axaca quicactoc tlen se acajya tlen hueli quitlachiyaltía se tlen tlacatqui popoyotzi. ");
INSERT INTO nheNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Intla Toteco ax quititlantosquía ni Jesús, huajca ax hueltosquía nechchicajtosquía. ");
INSERT INTO nheNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Huajca nopa israelita tlayacanani quiilhuijque: ―¡San tiicno conetl! ¿Tijnequi techmachtis tojuanti? Huan quicuatopejtiyajque tiopan calteno. ");
INSERT INTO nheNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Huan Jesús quicajqui para quiquixtijtoyaj ipan tiopamitl nopa tlacatl tlen eltoya popoyotzi, huajca yajqui quitemoto huan quiilhui: ―¿Tijneltoca Icone Toteco? ");
INSERT INTO nheNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Huan nopa tlacatl quitlajtlani: ―Tate, ¿ajqueya ya? Xinechilhui pampa nijnequi nijneltocas. ");
INSERT INTO nheNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Huan Jesús quiilhui: ―Amantzi tiquita ajqueya pampa na tlen nimitzcamahuía, niIcone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Huan ni tlacatl quiijto: ―NohueyiTeco, nimitzneltoca. Huan nopa tlacatl motlancuaquetzqui huan quihueyimatqui Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Huan Jesús quiilhui: ―Nihualajtoc ipan tlaltepactli para nijsencahuas nochi para ma eli xitlahuac. Nihualajqui para tlacame tlen eliyayaj queja popoyotzitzi ma quiitaca tlen melahuac. Huan para inijuanti tlen moilhuíaj ya quimachilíaj nochi tlamantli ma mocahuaca popoyotzitzi ipan inintlalnamiquilis. ");
INSERT INTO nheNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Huan sequin fariseos tlen itztoyaj ihuaya quicajque tlen quiijto huan quitlajtlanijque: ―Huajca timoilhuía para tojuanti tiitztoque queja tipopoyotzitzi ipan totlalnamiquilis. ¿Ax que? ");
INSERT INTO nheNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Huan Jesús quinilhui: ―Intla nelía initztosquíaj inpopoyotzitzi huan ax inquiitztosquíaj huan inquimachilijtosquíaj nochi tlen nijchijtoc, huajca ax inquihuicatosquíaj tlajtlacoli. Pero inquiijtohuaj inquimachilíaj tlen nijchijtoc, huajca nelía inquihuicaj tlajtlacoli pampa ax innechselijtoque. ");
INSERT INTO nheNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Huan Jesús quiijto: “Nelía nimechilhuía, tlaxtequini ax calaquij campa puerta para tlaxtequise ipan se corral campa cochi borregojme. Inijuanti ixtacatzi tlejcoj huan panoj iixco nopa tepamitl pampa quinequij tlaxtequise. ");
INSERT INTO nheNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero se tlamocuitlahuijquetl ax queja nopa calaqui. Yajaya calaqui ipan cuapuerta. ");
INSERT INTO nheNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Huan tlen quimocuitlahuía nopa cuapuerta quitlapos, huan nopa tlamocuitlahuijquetl quinnotzas iborregojhua ica sesen inintoca para quisase. Huan iborregojhua quitoscaquise huan quitoquilijtiyase. ");
INSERT INTO nheNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Huan quema nopa tlamocuitlahuijquetl tlamis quinnotzas nochi nopa borregojme tlen iaxcahua, quinyacantiyas huan inijuanti quitoquilise pampa quitoscaquise. ");
INSERT INTO nheNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero nopa borregojme ax quitoquilise se tlacatl tlen ax quiixmatij, san cholose pampa ax quitoscamachilíaj.” ");
INSERT INTO nheNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesús quinilhui ni huicalotl pero ax quimachilijque tlaque quiijtosnequi. ");
INSERT INTO nheNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Huajca Jesús sampa quinilhui: “Nelía nimechilhuía na niitztoc nopa cuapuerta campa tlacame huelis calaquise san se queja borregojme calaquij corral ijtic campa temachtli. ");
INSERT INTO nheNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nochi tlen hualajque achtohuiya huan quinequiyayaj tlacame ma quintoquilica itztoyaj queja tlaxtequini huan tlacajcayahuani, pero tlacame tlen noaxcahua ax quintoquilijque. ");
INSERT INTO nheNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na niitztoc nopa cuapuerta. Nochi tlen calaquij corral ijtic ica notlapalehuil, niquinmaquixtis. Se tlamocuitlahuijquetl quinyacana iborregojhua ma calaquica ica tlayohua huan ma quisaca tonaya para yase campa yajaya quinpantilía tlacualistli. Quej nopa nojquiya niquinmocuitlahuis notlacajhua huan niquinmacas nochi tlen monequi. ");
INSERT INTO nheNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Se tlaxtejquetl hualas para tlaxtequiqui huan temictiqui huan tlaxolehuas. Na nihualajqui para nitemacas yolistli yancuic huan para mojmostla quipiyase nelpano nochi tlen monequi ipan ininnemilis. ");
INSERT INTO nheNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na niitztoc nopa cuali tlamocuitlahuijquetl tlen nimotemactilía ininpampa noborregojhua. Nimotemactilis huan nimiquis ininpampa tlen noaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero ax san se elis ica se tlatequipanojquetl tlen san quinmocuitlahuía borregojme para quitlanis tomi. Quema yajaya quiitas ajsitihuala se tepechichi, nimantzi cholos huan quincajtehuas nopa borregojme ininseltitzi pampa ax iaxcahua. Huan nopa tepechichi quincuas sequin borregojme huan nopa sequinoc mosemantiyase, cholojtehuase huan campa hueli yase. ");
INSERT INTO nheNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cholos nopa tlatequipanojquetl pampa san tequiti para se tlaxtlahuili. Ax quinicnelía nopa borregojme. ");
INSERT INTO nheNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Na niitztoc nopa cuali tlamocuitlahuijquetl. Na niquinixmati tlen itztoque noaxcahua huan inijuanti nechixmatij, ");
INSERT INTO nheNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","san queja noTata nechixmati huan na niquixmati noTata. Huan nimotemactilis huan nimiquis ipampa tlen noaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Itztoque sequinoc tlacame tlen nojquiya noaxcahua tlen ax aquij nica. Nojquiya monequi niquinnotzati ma nechtoquilica huan nechtoscaquise. Huan huajca nochi noaxcahua itztose san sejco huan nochi san na niquinmocuitlahuijtos. ");
INSERT INTO nheNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“NoTata nechicnelía pampa nimotemactilis para nimiquis huan teipa nimoyolcuis sampa. ");
INSERT INTO nheNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Axaca huelis nechmictis intla ax nimotemactilis. Pero ica nopaquilis nimotemactilis huan nimiquis. Nijpiya tlanahuatili para nimiquis huan nijpiya tlanahuatili para nimoyolcuis sampa pampa noTata queja nopa nechnahuatijtoc ma nijchihua.” ");
INSERT INTO nheNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Huan nopa tlayacanani tlen israelitame quicajque tlen Jesús quiijto huan pejque monajnanquilíaj huan sampa mosemanque. ");
INSERT INTO nheNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Sequin quiijtohuayayaj: ―Yajaya quipiya se iajacayo Axcualtlacatl huan tlapolohua. ¿Para tlen inquicaquij itlajtol? ");
INSERT INTO nheNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero sequinoc quiijtohuayayaj intla quipiyasquía se iajaca Axcualtlacatl ax huelisquía camatisquía nelcuali queja camati. Huan se tlen quipiya iajaca Axcualtlacatl ax hueli quitlachiyaltis se popoyotzi. ");
INSERT INTO nheNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ipan nopa metztli quema onca tlasesecayotl, Jesús itztoya ipan altepetl Jerusalén ipan nopa ilhuitl para tiquilnamiquise quema tohuejcapan tatahua sampa quiyancuilijque huan quimactilijque Toteco nopa hueyi tiopamitl tlen achtohui sequinoc quixolejtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Huan Jesús nemiyaya ipan hueyi tiopan tlamapa tlen quitocajtiyayaj Salomón. ");
INSERT INTO nheNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Huan nopa tlayacanani tlen israelitame quiyahualojque huan quiilhuijque: ―¿Hasta quema timochiyase para nelía tijmatise tlen ta? Intla ta tiCristo tlen hualasquía, xitechilhui xitlahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Huan Jesús quinnanquili: ―Ya nimechilhui huan ax innechneltocaque. Nopa huejhueyi tlanescayotl tlen nijchihua ica itequiticayo noTata inmechnextilía ajqueya na. ");
INSERT INTO nheNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero ax innechneltocaj para na niCristo tlen Toteco quititlanqui pampa ax innoaxcahua queja ya nimechilhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noborregojhua nechtosmachilíaj huan niquinixmati huan inijuanti, quena, nechtoquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Huan tlen noaxcahua niquinmaca yolistli yancuic para nochipa huan ax quema polihuise; niyon axaca huelis nechquixtilis pampa itztoque nomaco. ");
INSERT INTO nheNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","NoTata nechmacatoc inijuanti tlen noaxcahua huan yajaya quipiya más chicahualistli que nochi sequinoc. Huan axaca huelis quiquixtilis tlen noaxcahua pampa itztoque imaco nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Na ihuaya noTata san se tiitztoque. ");
INSERT INTO nheNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Huajca nopa israelita tlayacanani quiitzquijque tetl para quitepachose. ");
INSERT INTO nheNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Huan Jesús quinilhui: ―Nijchijtoc imoixpa miyac cuali tlanescayotl tlen tepalehuía tlen noTata nechilhuijtoc ma nijchihua. ¿Tlaque tlanescayotl ax cuali nimechnextilijtoc para innechtepachosnequij? ");
INSERT INTO nheNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Huan nopa tlayacanani tlen israelitame quiilhuijque: ―Ax timitztepachosnequij pampa tijchijtoc tlen cuali. Timitztepachosnequij pampa tiquijtohua tiToteco Dios. Huajca tlahuel tiquixpano Toteco pampa nelía ta san tieli tlen hueli tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Huan Jesús quinilhui: ―Ipan imotlanahuatil ijcuilijtoc: ‘Niquijtohua para indioses.’ ");
INSERT INTO nheNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Huajca intla Toteco quintocajti ‘dioses’ nopa tlacame tlen quiseliyayaj itlajtol huan axaca huelis quixolehuas tlen ijcuilijtoc ipan Itlajtol, ");
INSERT INTO nheNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿para tlen inquiijtohuaj para na tlen noTata nechiyocacajqui para se tequitl tlatzejtzeloltic, huan nechtitlani ipan tlaltepactli para nijchihuas, ax nijtlepanita Toteco Dios pampa niquijto para niIcone Toteco? ");
INSERT INTO nheNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Intla ax nihueli nijchihua huejhueyi tlanescayotl queja noTata quichihua, huajca amo xinechneltocaca. ");
INSERT INTO nheNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero intla melahuac nijchihua huejhueyi tlanescayotl queja noTata, huajca xinechneltocaca ipampa nopa tlamantli tlen nijchihua yonque ax hueli innechneltocaj san ica notlajtol. Intla inquineltocase tlen nijchihua, inquimachilise noTata itztoc san se nohuaya huan na niitztoc san se ica ya. ");
INSERT INTO nheNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Huajca nopa tlayacanani sampa quinequiyayaj quiitzquise Jesús para quitzacuase, pero mochololti. ");
INSERT INTO nheNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Huan Jesús sampa quiixpanoc nopa atemitl Jordán huan yajqui hasta ne nali campa quisa tonati campa achtohuiya Juan tecuaaltiyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Huan miyac tlacame yajque nepa para itztose ihuaya. Huan quiijtohuayayaj se ica seyoc: ―Nelía Juan ax quichijqui huejhueyi tlanescayotl queja ni Jesús quichihua, pero nochi tlen Juan techilhui tlen Jesús elqui melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Huan miyac tlacame quineltocaque Jesús nepa. ");
INSERT INTO nheNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ipan altepetl Betania itztoya se tlacatl tlen itoca eliyaya Lázaro tlen san sejco itztoya ininhuaya isihua icnihua, María huan Marta. Huan Lázaro pejqui mococohua. ");
INSERT INTO nheNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(María, iicni Lázaro, eliyaya nopa sihuatl tlen teipa quitequilis tlaajhuiyacayotl ipan iicxihua Jesús huan quihuachili ica itzoncal.) ");
INSERT INTO nheNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Huajca quema Lázaro mococo, isihua icnihua tlatitlanque ma quiilhuitij Jesús: ―Toteco, mococohua mohuampo Lázaro tlen tiquicnelía. ");
INSERT INTO nheNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Huan quema Jesús quicajqui ya ni, quiijto: ―Nopa cocolistli ax quiajsic para ma miquis. Quiajsic para tenextilis ihueyitilis Toteco Dios huan nojquiya nohueyitilis na niIcone. ");
INSERT INTO nheNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Huan Jesús nelía quinicneli Lázaro, María huan Marta. ");
INSERT INTO nheNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pero quema quicajqui mococohua Lázaro, mocajqui seyoc ome tonali campa itztoya. ");
INSERT INTO nheNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Huan teipa techilhui tiimomachtijcahua: ―Ma tiyaca sampa estado Judea. ");
INSERT INTO nheNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Huan tiimomachtijcahua tiquilhuijque: ―Tlamachtijquetl, nopa israelita tlayacanani nepa quinequiyayaj mitztepachose. ¿Para tlen sampa tiyase? ");
INSERT INTO nheNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Huan Jesús technanquili: ―Ama ax tleno nopantis. Pampa onca majtlactli huan ome horas quema tlatlanestoc ipan se tonal. Se tlen nejnemi quema tonaya ax tleno ipanti pampa quitlahuilía nopa tlahuili tlen ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero intla se nejnemi quema tzintlayohua, motepotlamis pampa ax onca tlahuili. Huan quena, ajsis hora tlen tzintlayohuilotl quema oncas tlen nopantis. ");
INSERT INTO nheNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesús quiijto ya ni huan teipa techilhui: ―Tohuampo Lázaro cochtoc, pero niyas niquixititi. ");
INSERT INTO nheNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Huan tiimomachtijcahua tiquilhuijque: ―Toteco, intla cochtoc, cualtitoc, pampa quema isas, huajca mochicahuas. ");
INSERT INTO nheNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero Jesús nelía techilhuiyaya Lázaro ya mictoya, pero timoilhuiyayaj san cochtoya. ");
INSERT INTO nheNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Huajca Jesús techilhui xitlahuac: ―Lázaro ya mictoc. ");
INSERT INTO nheNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Huan na nipaqui ax niyajqui nimantzi pampa ama más cuali para imojuanti pampa más innechneltoquilise. Ma tiyaca tiquitatij. ");
INSERT INTO nheNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Huan Tomás tlen nojquiya quitocajtiyaya “Cuate” huan tlen itztoya se tlen tojuanti tiimomachtijcahua Jesús, techilhui: ―Ma tiyaca ihuaya para nojquiya ma techmictica intla quimictise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Huan quema Jesús ajsito altepetl Betania, ya quipixtoya nahui tonali quitlalijtoyaj itlacayo Lázaro ipan tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Huan Betania mocahua nechca Jerusalén, huelis se eyi kilómetro ihuejcaca. ");
INSERT INTO nheNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Huan miyac israelitame quistoyaj Jerusalén para quinseseltise Marta huan María pampa mijqui iniicni. ");
INSERT INTO nheNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Huan quema Marta quicajqui para hualayaya Jesús, yajqui quinamiquito ipan ojtli, pero María mocajqui calijtic. ");
INSERT INTO nheNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Huan Marta quiilhuito Jesús: ―NoTeco, intla tihualajtosquía quema mococohuayaya, noicni ax mictosquía. ");
INSERT INTO nheNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Huan yonque ya mictoc, nijmati Toteco mitzchihuilis nochi tlen tijtlajtlanis. ");
INSERT INTO nheNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Huan Jesús quiilhui: ―Moicni sampa moyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Huan Marta quiijto: ―Quena, nijmati moyolcuis sampa quema nochi mijcatzitzi moyolcuise ipan itlamiya tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Huan Jesús quiilhui Marta: ―Na tlen niquinyolitía tlacame tlen mictoque huan sampa niquinmaca yolistli. Yonque miquis itlacayo se tlen nechneltoca, quipiyas yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Huan nochi tlacame tlen itztoque huan nechneltocaj ax miquise para nochipa. ¿Tijneltoca tlen nimitzilhuía? ");
INSERT INTO nheNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Huan Marta quiilhui: ―Quena, noTeco nijneltoca ta tiCristo, tiIcone Toteco. Tajaya tlen timitzchiyayayaj xiajsi ipan totlaltepac. ");
INSERT INTO nheNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Huan quema Marta tlanqui quiijto ya ni, yajqui quinotzato María huan quiixtacailhui: ―Totlamachtijca ya ajsico huan mitznotza. ");
INSERT INTO nheNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Huan quema María quicajqui ni, yajqui nimantzi para quinamiquiti. ");
INSERT INTO nheNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Huan Jesús noja aya ajsiyaya campa altepetl pampa mocajtoya campa Marta quinamiquito. ");
INSERT INTO nheNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Huan nopa israelitame tlen itztoyaj calijtic para quiyolchicahuase María quiitaque quema quisqui nimantzi huan quitoquilijque pampa moilhuiyayaj yohuiyaya quichoquiliti iicni campa quitoctoyaj. ");
INSERT INTO nheNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pero María yajqui campa itztoya Jesús huan quema quiitac, motlancuaquetzqui iicxitla huan quiilhui: ―NoTeco, noicni ax mictosquía intla tihualajtosquía quema mococohuayaya. ");
INSERT INTO nheNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Huan Jesús quiitac chocayaya María, huan nojquiya nopa israelitame tlen hualajque ihuaya nojquiya chocayayaj. Huan yajaya nojquiya moyolpitzahuili huan mocueso. ");
INSERT INTO nheNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Huan quintlajtlani: ―¿Canque inquitoctoque? Huan quiilhuijque: ―Xihuala, Toteco, ma tijtlachilitij. ");
INSERT INTO nheNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Huan Jesús chocac. ");
INSERT INTO nheNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Huan nopa israelitame quiijtojque: ―Xiquitaca, Jesús nelía quiicneli Lázaro. ");
INSERT INTO nheNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Huan sequin quiijtojque: ―Yajaya quichicajqui nopa popoyotzi. ¿Ax hueltosquía nojquiya quichicajtosquía Lázaro para ax mictosquía? ");
INSERT INTO nheNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Huan sampa Jesús moyolpitzahuili huan yajqui campa quitoctoyaj. Quitlalijtoyaj itlacayo Lázaro ipan se tlacajcahuaya huan quiixtzajque ica se hueyi tepatlactli. ");
INSERT INTO nheNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Huan Jesús quiijto: ―Xijquixtilica ne tetl tlen ica quitzactoque. Huan Marta, iicni Lázaro, quiilhui Jesús: ―Pero ya quipiya nahui tonali tijtojque huan huelis ya potehuía. ");
INSERT INTO nheNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Huan Jesús quiilhui: ―¿Ax nimitzilhuijtoc, intla tijneltocas, nimitznextilis ihueyitilis Toteco? ");
INSERT INTO nheNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Huan quema quiquixtilijque nopa tetl tlen nopa tlacajcahuaya campa quitlalijtoyaj nopa mijcatzi, Jesús ajcoitac huan quiijto: ―Papá, nimitztlascamati pampa tinechtlacaquilijtoc huan tinechchihuilía tlen nimitztlajtlanía. ");
INSERT INTO nheNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nijmati nochipa tinechtlacaquilía, pero nimitzcamahuía ama tlamiyacapa para nochi tlen nechyahualojtoque nica huelis nechneltocase para tinechtitlantoc ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Huan quema tlanqui quicamahuía iTata, camatqui chicahuac huan quiijto: ―Lázaro, xiquisa tlen nopa tlacajcahuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Huan Lázaro tlen mictoya quistihualajqui huijcontoc nejmajtic ica yoyomitl imaco hasta nochi iicxico. Huan se payo quiixtzacuayaya. Huan Jesús quinilhui nopa tlacame: ―Xijtojtomaca para huelis yas. ");
INSERT INTO nheNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Huan miyac israelitame tlen itztoyaj ihuaya María quiitaque tlen Jesús quichijqui huan quineltocaque para yajaya nopa Cristo tlen hualasquía. ");
INSERT INTO nheNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero sequinoc israelitame tlen ax quineltocaque yajque quinilhuitoj nopa fariseos tlaque Jesús quichijtoya. ");
INSERT INTO nheNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Huajca nopa tlayacanca totajtzitzi huan fariseos mosentilijque ica nopa hueyi tlasentilistli tlen tequihuejme huan quiijtojque: ―¿Tlaque tijchihuase? Pampa ni tlacatl Jesús quichihua miyac tlanescayotl. ");
INSERT INTO nheNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Intla tijcahuilise ma quichihuas más, huajca nochi quineltocase. Huan nopa tequihuejme ipan altepetl Roma quicaquise huan techtitlanilise soldados para techxolehuiliquij totiopa huan techmictise nochi tiisraelitame ipan totlal. ");
INSERT INTO nheNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Huan Caifás tlen eliyaya nopa hueyi israelita totajtzi ipan nopa xihuitl quinilhui: ―Ax tleno inquimatij. ");
INSERT INTO nheNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿Ax inquimachilíaj más cuali quisas para ma miquis san se tlacatl ipampa nochi tlacame huan ax timiquise nochi tiisraelitame? ");
INSERT INTO nheNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Huan Caifás ax quiijto ya ni pampa iselti moilhuijtoya. Elqui pampa yajaya itztoya nopa hueyi israelita totajtzi ipan nopa xihuitl huan Itonal Toteco quimacac nopa tlajtoli para tenextilis achtohui tlaque panos teipa quema Jesús miquisquía ipampa nochi tlacame ipan totlal. ");
INSERT INTO nheNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Huan ax san miquisquía Jesús ipampa tlacame ipan totlal. Miquisquía para ma mosentilise iconehua Toteco tlen mosemantoyaj ipan campa hueli tlali. ");
INSERT INTO nheNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Huajca nopa tonal huan teipa nopa tlayacanca israelitame pejque quisencahuaj quejatza huelis quimictise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Huajca Jesús ayoc huelqui nejnemi campa nopa tlayacanca israelitame huelis quiitase. Yajaya quisqui huan yajqui ica tojuanti tiimomachtijcahua ipan se pilaltepetzi tlen itoca Efraín nechca nopa huactoc tlali campa ax tleno eli. ");
INSERT INTO nheNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Huan ajsitihualayaya nopa tonal para nopa Pascua Ilhuitl. Huan miyac tlacame hualayayaj tlen campa hueli pilaltepetzitzi huan yohuiyayaj hasta altepetl Jerusalén quema noja polihuiyaya para pehuas nopa ilhuitl pampa monequiyaya mopajpacase queja quiijtohuaj totlanahuatil para teipa quiilnamiquise nopa Pascua Ilhuitl. ");
INSERT INTO nheNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Huan nopa tlacame tlen hualajtoyaj campa hueli quitemohuayayaj Jesús huan motlajtlaniyayaj se ica seyoc tlen moquetzayayaj hueyi tiopan calijtic: ―¿Quejatza tiquita? ¿Hualas Jesús ipan ni ilhuitl o axtle? ");
INSERT INTO nheNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Huan nopa tlayacanca totajtzitzi huan nopa fariseos ya quinilhuijtoyaj tlacame intla se quimatisquía canque itztoya Jesús, ma quinyolmelahuatij para huelise quiitzquitij. ");
INSERT INTO nheNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Quema polihuiyaya chicuase tonali para pehuas nopa ilhuitl tlen itoca Pascua, Jesús sampa yajqui Betania campa itztoya Lázaro tlen quiyoliti quema ya mictoya. ");
INSERT INTO nheNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Huan inijuanti quichihuilijque Jesús se tlacualistli. Huan itztoyaj Lázaro huan sequinoc ihuaya Jesús campa mesa. Huan Marta quinmacayaya inintlacualis. ");
INSERT INTO nheNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Huan María quihualicac tlajco litro aceite tlen tlahuel ajhuiyac eliyaya tlasencahuali ica nopa xochitl tlen itoca nardo. Nelía eliyaya patiyo nopa tlaajhuiyacayotl. Huan María quitequili ipan iicxihua Jesús huan quihuachili iicxihua ica itzoncal. Huan nelía ajhuiyac mijmiyotiyaya calijtic. ");
INSERT INTO nheNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Huan nopona nojquiya itztoya Judas Iscariote, icone Simón, se tlen tojuanti tiimomachtijcahua Jesús. Yajaya tlen teipa quitemactili para ma quimictica. Huan Judas quiijto: ");
INSERT INTO nheNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―¿Para tlen quinenpolo ne tlaajhuiyacayotl? Hueltosquía quinamacatosquía para miyac tomi queja tlaxtlahuaj para eyi ciento tonali tequitl huan quinmacatosquía nopa tomi tlacame tlen pilteicneltzitzi. ");
INSERT INTO nheNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas ax quiijto ya ni pampa nelía quinicneliyaya tlen teicneltzitzi. Quiijto pampa yajaya elqui se tlaxtejquetl. Yajaya quipixqui nopa tequitl para quihuicas nopa bolsa ica totomi nochi tiimomachtijcahua Jesús huan ajachica quiixtacacuiyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Huajca Jesús quiilhui: ―Amo xijcuatotoni ni sihuatl. Yajaya quiajcoctoc ni tlaajhuiyacayotl hasta ama para quicualtlalis notlacayo para quema nimiquis huan nechtocase. ");
INSERT INTO nheNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nochipa itztose imohuaya tlen pilteicneltzitzi para inquinpalehuise, pero na ayoc nihuejcahuas niitztos imohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Huan miyac israelitame quicajque para Jesús itztoya ichaj Lázaro huan yeca hualajque quitlachilicoj. Ax san quinequiyayaj quiitase Jesús. Nojquiya quinequiyayaj quiitase Lázaro tlen mictoya huan Jesús sampa quiyoliti. ");
INSERT INTO nheNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pero nopa tlayacanca totajtzitzi quisencahuayayaj quejatza huelis quimictise Lázaro nojquiya, ");
INSERT INTO nheNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","pampa miyac israelitame ayoc quinneltocaque inintlajtol. Pejque quineltocaj Jesús pampa quiyoliti Lázaro. ");
INSERT INTO nheNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Huan tonili nopa miyac tlacame tlen ajsitoyaj para nopa Pascua Ilhuitl quicajque para Jesús monechcahuiyaya Jerusalén. ");
INSERT INTO nheNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Huan quitejque huejhueyi apachtli imacuayo huan yajque quinamiquitoj. Huan pejque quiilhuíaj chicahuac: “¡Timitzhueyichihuaj! ¡Ma Toteco mitztiochihua ta tlen tihuala ipan itoca ! ¡Ta titotlanahuatijca tiisraelitame!” ");
INSERT INTO nheNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Huan Jesús quipanti se cone burro huan ipan tlejcoc queja ijcuilijtoc ipan Itlajtol Toteco para quichihuasquía. Ijcuilijtoc: ");
INSERT INTO nheNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Amo ximomajmatica inJerusalén ehuani. Xiquitaca imotlanahuatijca ya huala ipan se cone burro.” ");
INSERT INTO nheNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Achtohuiya tojuanti tiimomachtijcahua ax tijmachilijque para Jesús quitlamiltiyaya tlen ijcuilijtoc ipan Itlajtol Toteco para panosquía. Pero quema Jesús mocueptoya elhuicac huan Toteco quihueyitlalijtoya, tiquilnamijque quesqui tlamantli panotoya tlen ijcuilijtoc ipan Itlajtol Toteco para yajaya quichihuasquía o para tlacame ma quichihuilica. ");
INSERT INTO nheNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Huan nojquiya nochi nopa tlacame tlen itztoyaj ihuaya Jesús quema quinotzqui Lázaro ma quisa campa tlacacahuaya ajachica quinilhuiyayaj sequinoc tlen panotoya. ");
INSERT INTO nheNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Huajca yeca mosentilijque miyac tlacame para quinamiquitij Jesús ipan ojtli. ");
INSERT INTO nheNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Huan nopa fariseos moilhuijque se ica seyoc: ―Xiquitaca, ax tleno hueli tijchihuase. Nochi tlacame tlen campa hueli ehuaj ipan tlaltepactli ya quitoquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Huan itztoyaj sequin tlacame tlen ehuaj tlali Grecia tlen nojquiya yajque Jerusalén para quihueyimatise Toteco ipan nopa ilhuitl. ");
INSERT INTO nheNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Huan inijuanti yajque campa Felipe tlen ehua altepetl Betsaida ipan estado Galilea huan quiilhuijque: ―Tate, tijnequij tiquixmatise Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Huan Felipe hualajqui quiilhuico Andrés tlen quiilhuijtoyaj. Huan san sejco Felipe huan Andrés quiilhuijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Huan Jesús quiijto: ―Ya ajsic hora para na tlen niMocuepqui Tlacatl nimiquis huan noTata nechhueyitlalis. ");
INSERT INTO nheNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nelía nimechilhuía, intla axaca quitocas se xinachtli, nopa xinachtli mocahuas san se xinachtli. Pero intla se quitocas tlaltitla queja quitocaj se tlen mictoc, iyoltzi nopa xinachtli ixhuas huan temacas miyac pixquistli. ");
INSERT INTO nheNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Aqui quinequi quichihuas san tlen quipactía, quipolos nochi quema miquis. Pero ajqueya quicahuas tlen yajaya quinequi ipan iyolis ipan ni tlaltepactli huan nechtoquilis, quipiyas se yolistli yancuic para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Intla ni griegos o tlen hueli tlacame quinequij elise notequipanojcahua, ma nechtoquilica. Huan campa na niitztos, nojquiya itztose notequipanojcahua. Huan intla se nechtequipanos, noTata quitlepanitas. ");
INSERT INTO nheNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ama tlahuel nimocuesohua, pero ax nijtlajtlanis noTata ma nechmanahui tlen ni tlaijiyohuilistli tlen hualas. Na nihualajtoc ipan ni tlaltepactli san para nitlaijiyohuis huan nimiquis ipan ni tonali.” ");
INSERT INTO nheNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Huajca Jesús quiilhui iTata: “Papá, xijchihua para nochi tlacame ma mitzhueyitlalica ipampa tlen nijchihua na.” Huan Toteco Dios tlen itztoc elhuicac quiilhui Jesús: “Ya nijchijtoc para ma nechhueyitlalica huan sampa nijchihuas.” ");
INSERT INTO nheNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Huan nopa miyac tlacame tlen moquetzayayaj nepa quitoscajque. Huan sequin quiijtojque tlatomonqui huan sequinoc quiijtojque: ―Se elhuicac ejquetl quinojnotzqui Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Pero Jesús techilhui: ―NoTata ax camatqui para na ma nijmati nechcajqui. Yajaya camatqui para imojuanti xijmachilica yajaya quicajqui tlen niquilhui. ");
INSERT INTO nheNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ama ajsitoc hora para Toteco quintlajtolsencahuas tlen itztoque ipan ni tlaltepactli. Ama nijquixtilis itequihuejcayo Axcualtlacatl tlen tlanahuatía ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Huan quema nechtlejcoltise ipan cuamapeli, niquinyoltilanas nochi tlacame para ma hualaca campa na. ");
INSERT INTO nheNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Techilhui ya ni para ma tijmatica quejatza miquisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Huan nopa miyac tlacame quitlajtlanijque: ―Tojuanti tijcactoque ipan Itlajtol Toteco campa quiijtohua nopa Cristo tlen hualasquía itztos para nochipa. Pero tiquijtohua ta tlen tiMocuepqui Tlacatl, mitztlejcoltise ipan cuamapeli para timiquis. ¿Ta tlen tiMocuepqui Tlacatl tiitztoc san se ica nopa Cristo tlen hualasquía o axtle? ");
INSERT INTO nheNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Huajca Jesús quinilhui: ―Na tlen niquintlahuilía tlacame ipan ininyolo san niitztos imohuaya se ome tonali. Xinejnemica ipan notlahuil ama quema noja inhuelij huan xinechneltocaca para ax inpolihuise. Pampa huala tzintlayohuilotl quema ayoc niitztos imohuaya. Tlacame tlen nejnemij ipan tzintlayohuilotl huan ax nechcahuilíaj ma niquintlahuili, ax quimachilíaj canque yohuij, niyon ax quimatij intla polihuise para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xinechneltocaca ipan ni tonali quema na tlen nitlahuili noja niitztoc imohuaya para inelise innoconehua huan para huelis innejnemise ipan notlahuil. Huan quema Jesús quiijto ya ni, quisqui huan motlatito tlen inijuanti. ");
INSERT INTO nheNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Huan yonque Jesús quichijtoya miyac huejhueyi tlanescayotl iniixpa tlacame tlen quinnextili ichicahualis, nopa tlayacanca israelitame ax quineltocayayaj. ");
INSERT INTO nheNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Quej ni panoc para quitlamiltis tlen nopa tiocamanalojquetl Isaías quiijcuilo huejcajquiya campa quiijto: “Toteco, ax miyaqui tlacame quineltocaj tlen tiquinilhuíaj. ¿Tiquinnextilijtoc san se ome mohueyi chicahualis?” ");
INSERT INTO nheNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Huajca ax huelque quineltoquilíaj pampa eltoc queja Isaías quiijtohua ipan iama: ");
INSERT INTO nheNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Toteco quinixtzactoc huan quinyoltetilijtoc. Quej nopa ax hueli quiitase huan quimachilise tlen na, huan ax moyolcuepase para huelis niquinmaquixtis.” ");
INSERT INTO nheNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Huan Isaías quiijto ya ni pampa quiitztoya ihueyitilis Cristo huan techyolmelahuayaya tlen ya. ");
INSERT INTO nheNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero yonque queja nopa quiijtohua, miyac tlacame quineltocaque Jesús para yajaya nopa Cristo. Huan hasta sequin tlayacanca israelitame nojquiya quineltocaque, pero axaca quiilhuiyayaj pampa quinimacasiyayaj nopa fariseos. Quimatiyayaj ayoc quincahuilisquíaj ma calaquica ipan israelita tiopamitl. ");
INSERT INTO nheNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Mohuihuichijque pampa más quinequiyayaj quinpaquilismacase tlacame, huan ax Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Huan Jesús pejqui camati tlamiyacapa ipan nopa ilhuitl huan chicahuac quiijto: “Yajaya tlen nechneltoca, ax san na nechneltoca. Nojquiya quineltoca noTata tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Aqui nechita, nojquiya quiita noTata tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nihualajtoc ipan ni tlaltepactli queja se tlahuili. Niquintlahuilía ininyolo nochi tlen nechneltocaj para ayoc itztose ipan tzintlayohuilotl. ");
INSERT INTO nheNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero tlacame tlen quicaquij notlajtol huan ax nechneltocaj, ax niquintlajtolsencahuas. Ax nihualajtoc ama ipan tlaltepactli para nitetlajtolsencahuas. Nihualajtoc para niquinmaquixtis tlen inintlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero ajqueya nechhuejcamajcahua huan ax quiselía notlajtol quipiyas tlen quitlajtolsencahuas ipan itlamiya tonali. Pampa ni tlajtoli tlen niquijtojtoc ipan tlaltepactli quiteilhuis ipan itlamiya tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Pampa ax nicamati san ica na notequihuejcayo. NoTata tlen nechtitlantoc nechnahuatijtoc tlaque ma niquijto huan tlaque ma nitlamachti. ");
INSERT INTO nheNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Huan nijmati ajqueya quineltocas notlajtol tlen noTata nechnahuatijtoc ma niteilhui, yajaya quipiyas yolistli tlen yancuic para nochipa. Pampa nochi tlen niquijtohua eltoc tlen noTata nechilhuijtoc ma niquijto.” ");
INSERT INTO nheNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aya pehuayaya nopa Pascua Ilhuitl huan Jesús quimatiyaya ya monechcahuiyaya nopa hora para quisas tlen ni tlaltepactli huan mocuepas campa itztoc iTata. Mojmostla technextilijtoya tojuanti tlen tiiaxcahua ipan ni tlaltepactli para techicnelía huan nopa tonal technextili para neltlahuel techicnelía. ");
INSERT INTO nheNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Eltoya hora para nopa Pascua tlacualistli huan Axcualtlacatl ya quitlalilijtoya ipan itlalnamiquilis Judas Iscariote, icone Simón, para quitemactilis Jesús ininmaco ax cuajcualme. ");
INSERT INTO nheNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús quimatiyaya Itata quimacatoya tequihuejcayotl para quinahuatis nochi tlamantli. Huan quimatiyaya para hualajqui tlen campa Toteco huan ica se ome tonali mocuepasquía iixtla. ");
INSERT INTO nheNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pero yonque nochi nopa tequihuejcayotl quipixtoya, ipan nopa tlacualistli moquetzqui Jesús, huan quiquixti iyoyo huehueyac huan motzinquechilpi ica se toalla. ");
INSERT INTO nheNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Huan quitequili atl se tina huan pejqui techicxipajpaca huan techicxihuatza ica nopa toalla queja quichihua se tlatequipanojquetl. ");
INSERT INTO nheNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Huan quema Jesús pejqui quiicxipajpaca Simón Pedro, yajaya quiilhui: ―NoTeco, ¿para tlen tijnequi tinechicxipajpacas? ");
INSERT INTO nheNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Huan Jesús quinanquili: ―Amantzi ax tijmachilía tlaque quinequi quiijtos tlen nijchihua, pero teipa tijmachilis. ");
INSERT INTO nheNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Huan Pedro quiijto: ―Ax quema nimitzcahuilis xinechicxipajpacas. Huan Jesús quinanquili: ―Intla ax nimitzicxipajpacas, huajca ax tleno tijpiyas noca na. ");
INSERT INTO nheNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Huajca Simón Pedro quiilhui: ―Huajca, noTeco, ax san noicxi xinechpajpaquili, nojquiya xinechpajpaquili notzonteco huan noma. ");
INSERT INTO nheNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Huan Jesús quiilhui: ―Se tlacatl tlen maltijtoc san monequi quiicxipajpacas pampa ya tlapajpactic itlacayo. Imojuanti intlapajpactique, pero ax nochi imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Huan Jesús quiijto: “Ax nochi intlapajpactique” pampa quimatiyaya ajqueya quitemactilisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Quema tlanqui techicxipajpaca nochi tojuanti, sampa moquenti iyoyo huehueyac huan mosehui nechca mesa. Huan techilhui: ―Huelis ax inquimachilíaj tlen nimechchihuilijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Innechnotzaj niimotlamachtijca huan niimoTeco. Huan quinamiqui tlen inquiijtohuaj pampa melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pero intla na tlen niimotlamachtijca huan niimoTeco nimechicxipajpactoc, monequi san se inmotequipanose huan inmoicxipajpacase se ica seyoc. ");
INSERT INTO nheNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Pampa nimechnextilijtoc para inquichihuase queja na nimechchihuilijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nelía nimechilhuía, se tlatequipanojquetl ax itztoc más hueyi que iteco. Huan se tlatitlanquetl ax itztoc más hueyi que yaja tlen quititlanqui. Innotlatequipanojcahua huan innotlayolmelajcahua huan ax más inhuejhueyi que na. ");
INSERT INTO nheNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ya inquimachilíaj para nimechilhuijtoc ximotequipanoca se ica seyoc, huajca xijchihuaca huan inmechmacas miyac paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Ax nicamati tlen nochi imojuanti. Cuali nimechixmati inquesqui tlen nimechtlapejpenijtoc. Ijcuilijtoc ipan Itlajtol Toteco campa quiijto para se tlen quipalohua ipantzi nohuaya ipan notlacualis, mochijtoc nocualancaitaca. Huan ni tlajtoli nimantzi quisas melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nimechilhuía ya ni ama quema noja polihui para panos para teipa quema panos, inquineltocase para na niitztoc nopa Cristo tlen hualasquía. ");
INSERT INTO nheNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nelía nimechilhuía, ajqueya inmechselis imojuanti o tlen hueli tlacatl tlen nijtitlani, nojquiya nechselía. Huan tlen nechselía, quiselía noTata tlen nechtitlantoc.” ");
INSERT INTO nheNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Quema Jesús tlanqui quiijto ya ni, moyolpitzajqui huan techilhui tiimomachtijcahua: ―Nelía nimechilhuía, se tlen imojuanti nechtemactilis ica nocualancaitacahua. ");
INSERT INTO nheNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Huan tiimomachtijcahua pejque timoixtlachilíaj se ica seyoc pampa ax tijmatiyayaj ajqueya quichihuasquía. ");
INSERT INTO nheNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Na nitlacuayaya inechca Jesús pampa miyac nechicneli. ");
INSERT INTO nheNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Huan Simón Pedro nechtlamanextili ma nijtlajtlani Jesús ajqueya quitemactilisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Huajca na nimonechcahui achi más huan niquilhui: ―Toteco, ¿ajqueya mitztemactilis? ");
INSERT INTO nheNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Huan Jesús nechnanquili: ―Na nijpalos ni pantzi ipan tlacuali huan nijmacas ma quicua yajaya tlen nechtemactilis. Huajca quipalo nopa pantzi huan quimacac Judas, itelpoca Simón Iscariote. ");
INSERT INTO nheNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Huan quema Judas quiselijtoya nopa pantzi, Axcualtlacatl calajqui ipan iyolo. Huan Jesús quiilhui: ―Nopa tlen tijchihuas, xijchihua nimantzi. ");
INSERT INTO nheNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Huan niyon se tlen tojuanti tlen tiitztoyaj ihuaya campa mesa ax tijmatiyayaj para tlen quiilhui ya nopa. ");
INSERT INTO nheNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sequin san moilhuiyayaj Jesús quiilhuiyaya Judas ma quicohuati tlen monequi para nopa ilhuitl o quiilhuiyaya ma quinmacas tomi tlen pilteicneltzitzi pampa Judas quimocuitlahuiyaya totomin bolsa. ");
INSERT INTO nheNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Huajca Judas quiseli nopa pantzi tlen Jesús quimacac huan nimantzi quistejqui. Huan ya tlayohuatoya. ");
INSERT INTO nheNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Quema ya quistoya Judas, Jesús techilhui: ―Ama monextis nohueyitilis na tlen niMocuepqui Tlacatl. Huan monextis ihueyitilis noTata ipampa tlen nijchihuas. ");
INSERT INTO nheNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Quema nitenextilis ihueyitilis noTata, ax huejcahuas nopa tonal teipa quema noTata nechhueyitlalis. ");
INSERT INTO nheNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Noconehua, san niitztos imohuaya seyoc tlalochtli huan monequi niquistehuas. Yonque innechtemose, queja niquinilhui nopa israelita tlayacanani, ax huelis innechtoquilise campa niyas. ");
INSERT INTO nheNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Huajca nimechmaca se yancuic tlanahuatili para xijchihuaca: Ximoicnelica se ica seyoc queja na nimechicnelía. Quena, queja nopa monequi ximoicnelica. ");
INSERT INTO nheNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nochi tlacame quimachilise para nelía innomomachtijcahua intla nelía inmoicnelise. ");
INSERT INTO nheNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Huan Simón Pedro quitlajtlani: ―NoTeco, ¿canque tiyas? Huan Jesús quinanquili: ―Amantzi ax huelis tinechtoquilis campa niyas, pero teipa quena, tinechtoquilis. ");
INSERT INTO nheNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Huan Pedro quiilhui: ―NoTeco, ¿para tlen ax huelis nimitztoquilis amantzi? Nimotemacasquía para nimiquis mopampa ta. ");
INSERT INTO nheNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Huan Jesús quinanquili: ―Tinechilhuía timotemacasquía para ma mitzmictica pampa tinechneltoca. Pero nelía nimitzilhuía, ipan ni tlayohua quema noja polihuis para tzajtzis se cuapelech, ta tiquijtojtos expa para ax tinechixmati. ");
INSERT INTO nheNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Amo ximocuesoca. Xijneltocaca Toteco huan xinechneltocaca nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nepa elhuicac campa ichaj noTata onca miyac caltini para ipan initztose. Intla ax melahuac, nimechilhuijtosquía. Na niyas nepa nimechchijchihuiliti imochajchaj campa initztose. ");
INSERT INTO nheNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Huan quema ya nimechsencahuilijtos imochajchaj, huajca sampa nihualasoc huan nimechhuicas para initztose nohuaya nepa campa niitztos. ");
INSERT INTO nheNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Inquimatij canque niyas huan inquimatij nopa ojtli tlen ipan inyase.” ");
INSERT INTO nheNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Huan Tomás quiilhui: ―NoTeco, ax tijmatij canque tiyas, huajca ¿quejatza huelis tijmatise nopa ojtli para ipan tiyase? ");
INSERT INTO nheNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Huan Jesús quiilhui: ―Na niojtli, nitehuicas elhuicac. Na niitztoc tlen melahuac huan nitemacas yolistli yancuic para nochipa. Axaca huelis ajsis campa itztoc noTata nepa elhuicac intla ax nechneltoca. ");
INSERT INTO nheNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Intla nelía innechixmajtosquíaj, nojquiya inquiixmajtosquíaj noTata. Pero para ama huan teipa xijmachilica ya inquiixmajtoque noTata huan ya inquiitztoque. ");
INSERT INTO nheNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Huan Felipe quiilhui: ―NoTeco, xitechnextili moTata, san ya nopa tijnequij. ");
INSERT INTO nheNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Huan Jesús quiilhui: ―Felipe, ya quipiya miyac tonali niitztoc imohuaya. ¿Ax innechixmatij? Yajaya tlen nechitztoc, ya quiitztoc noTata. Huajca, ¿para tlen tiquijtohua ma nimechnextili noTata? ");
INSERT INTO nheNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Ax inquineltocaj niitztoc ipan noTata huan noTata itztoc nopan na? Nopa tlajtoli tlen nimechilhuía, ax san na notlajtol. Tlen nimechilhuía huala tlen noTata tlen itztoc nopan na. Huan yajaya quichihua itequi noca na. ");
INSERT INTO nheNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xinechneltoquilica notlajtol quema nimechilhuía niitztoc ipan noTata huan yajaya itztoc nopan na. Huan intla ax hueli innechneltocaj ipampa tlen niquijtohua, xinechneltocaca ipampa nopa huejhueyi chicahualnescayotl tlen nijchijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nelía nimechilhuía, se tlacatl tlen nechneltocas quichihuas huejhueyi tequitl queja nijchijtoc. Huan noja más huejhueyi tequitl quichihuas pampa nimocuepas campa itztoc noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Huan nochi tlamantli tlen inquitlajtlanise noTata ipan notoca , nimechchihuilis pampa na niIcone nijchihua ma quihueyitlalis noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Quena, nochi tlen intlajtlanise ica notequihuejcayo, nimechchihuilis. ");
INSERT INTO nheNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Intla innechicnelíaj, xijchihuaca nopa tlanahuatili tlen nimechmacatoc. ");
INSERT INTO nheNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Huan nijtlajtlanis noTata ma inmechtitlanilis seyoc Tlayoltlalijquetl huan yajaya mocahuas imohuaya para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nopa Tlayoltlalijquetl yajaya Itonal Toteco tlen tlamachtía tlen melahuac. Pero tlacame tlen ni tlaltepactli tlen ax noaxcahua ax huelis quiselise Itonal Toteco pampa ax huelis quiitase huan ax quiixmatise. Pero imojuanti inquiixmatij Itonal Toteco pampa ama itztoc imohuaya huan teipa mocahuas ipan imoyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Ax nimechcajtehuas queja inicnotzitzi. Nimocuepas niitztos imohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ayoc huejcahuas para tlacame tlen ni tlaltepactli tlen ax noaxcahua ayoc nechitase. Pero imojuanti, quena, innechitase. Huan pampa niyoltos, inyoltose para nochipa. ");
INSERT INTO nheNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Quema hualas Itonal Toteco, inquimachilise na niitztoc ipan noTata, huan initztoque nopan na huan na niitztoc ipan imojuanti. ");
INSERT INTO nheNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tlacame tlen quimatij notlanahuatil huan nelía quichihuaj, inijuanti tlen nelía nechicnelíaj. Huan noTata quinicnelis tlen nechicnelíaj, huan na nojquiya niquinicnelis huan nimonextis ica sesen inijuanti.” ");
INSERT INTO nheNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Huan nopa seyoc Judas (ax Judas Iscariote) quiilhui Jesús: ―NoTeco, ¿para tlen timonextis ica tojuanti, pero ica tlacame tlen ax mitzneltocaj, axtle? ");
INSERT INTO nheNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Huan Jesús quinanquili: ―Tlen nechicnelía quichihuas tlen niquijtohua. Huan noTata quiicnelis huan na ihuaya noTata tihualase para timochantise ipan iyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tlen ax nechicnelía ax quichihua tlen niquijtohua. Huan ni tlajtoli tlen nimechilhuía ax san na notlajtol, pero noTata tlen nechtitlantoc nechilhuijtoc tlen monequi niquijtos. ");
INSERT INTO nheNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Na nimechilhuía nochi ni quema noja niitztoc imohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pero Itonal Toteco, nopa Tlayoltlalijquetl, tlen noTata inmechhualtitlanilis ipan notoca yajaya inmechmachtis nochi tlamantli huan inmechilnamiquiltis nochi tlen nimechilhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nimechcahuilijtehua tlasehuilistli ipan imoyolo. Huan notlasehuilis tlen nimechmaca ax queja temacaj tlen itztoque ipan ni tlaltepactli. Amo ximocuesoca huan amo ximomajmatica. ");
INSERT INTO nheNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Inquicactoque quema nimechilhui para niyas huan teipa sampa nihualas niitztos imohuaya. Intla nelía innechicnelíaj, inpaquisquíaj pampa niyas campa itztoc noTata pampa noTata itztoc más hueyi queja na. ");
INSERT INTO nheNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nimechilhuía niyas ama quema noja aya niyajtoc para quema niyas, inquineltocase notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Ayoc miyac huelis nimechcamahuis pampa ya hualas Axcualtlacatl tlen quinnahuatía tlacame tlen ni tlaltepactli. Yajaya ax quipiya niyon quentzi tequihuejcayotl noca na. ");
INSERT INTO nheNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero nijnequi nochi tlacame ipan ni tlaltepactli ma quimachilica niquicnelía noTata. Huan tlen noTata nechnahuatía, ya nopa nijchihuas. Ximoquetzaca, ma tiyacajya. ");
INSERT INTO nheNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Na niitztoc queja se xocomeca tzontli tlen melahuac huan noTata itztoc queja nopa xocomeca mocuitlahuijquetl. ");
INSERT INTO nheNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nochi tlen nechneltocaj itztoque queja noxocomeca macuayohua tlen motlatzquilijtoque nopan na. Intla se tlen nechneltoca ax quipiya itlajca, noTata quimatzontequis. Huan nochi noxocomeca macuayohua tlen temacaj inintlajca, noTata quinyejyectis para huelis temacase más inintlajca. ");
INSERT INTO nheNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Imojuanti initztoque queja se nomacuayo tlen noTata ya quiyejyectijtoc, pampa ya intlapajpactique ica nopa tlajtoli tlen nimechmachtijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ximocahuaca intlatzquitoque nopan na huan na nimocahuas nitlatzquitoc ipan imojuanti. Se xocomeca macuayotl ax hueli tlaqui intla ax mocahuas tlatzquijtoc ipan nopa xocomeca tzontli. Huan imojuanti ax hueli inquichihuase ipaquilis noTata intla ax inmocahuase intlatzquijtoque ipan na. ");
INSERT INTO nheNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Na niitztoc queja nopa xocomeca tzontli huan initztoque queja noxocomeca macuayohua. Intla inmocahuase intlatzquijtoque nopan na huan nimocahuas nitlatzquitoc ipan imojuanti, huajca quena, intemacase miyac imotlajca. Pero intla ax nimechpalehuis, ax tleno huelis inquichihuase. ");
INSERT INTO nheNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tlacame tlen ax mocahuaj tlatzquijtoque nopan na, noTata quinchihuilis queja se xocomeca mocuitlahuijquetl quinchihuili nopa xocomeca macuatini tlen ax tlaqui. Quitzontequilis huan quicahuilis ma huaqui. Huan quinsentilis huan quinmajcahuas ipan tlitl para tlatlase. ");
INSERT INTO nheNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Intla inmocahuase intlatzquijtoque nopan na huan notlajtol mocahuas ipan imoyolo, huajca inquitlajtlanise tlen inquinequij huan inquiselise. ");
INSERT INTO nheNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Huan quema intemacaj miyac imotlajca huan inquichihuaj miyac tlamantli tlen ipaquilis noTata, nesis más ihueyitilis noTata huan nesis nelía innomomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Queja noTata nechicnelía miyac, na nojquiya nimechicnelía. Ximocahuaca ipan notlateicnelilis. ");
INSERT INTO nheNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Intla inquichihuase tlen nimechnahuatía, inmocahuaj ipan notlaicnelilis queja nojquiya quema nijchihua tlen noTata nechnahuatía, nimocahua ipan itlaicnelilis. ");
INSERT INTO nheNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Nimechilhuijtoc ni tlajtoli para huelis inquipiyase nopaquilis huan inpactose tlahuel hasta nelmiyac. ");
INSERT INTO nheNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Huan ya ni nimechnahuatía, ximoicnelica se ica seyoc queja na nimechicnelía. ");
INSERT INTO nheNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Se tlen motemactilis huan miquis ipampa ihuampoyohua, yajaya más teicnelía que nochi tlacame. ");
INSERT INTO nheNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Initztoque innohuampoyohua intla inquichihuaj tlen nimechnahuatía. ");
INSERT INTO nheNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Huajca ayoc nimechnotzas innotlatequipanojcahua, pampa se tecojtli ax quinilhuía itlatequipanojcahua tlen quichihua. Pero nimechnotzas innohuampoyohua, pampa nochi tlen noTata nechilhuijtoc nojquiya nimechilhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Imojuanti ax innechtlapejpenijque, pero na tlen nimechtlapejpeni imojuanti. Huan nimechtequitlalijtoc para inquipiyase imotlajca pampa inyase inquichihuase itequi Toteco. Huan nopa tequitl tlen inquichihuase mocahuas. Huan nochi tlen inquitlajtlanise noTata ipan notoca yajaya inmechmacas. ");
INSERT INTO nheNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Huajca ya ni nimechnahuatía: ximoicnelica se ica seyoc. ");
INSERT INTO nheNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Intla tlacame ipan ni tlaltepactli tlen ax quiixmatij Toteco inmechcocolíaj, xiquilnamiquica achtohuiya na nechcocolijque. ");
INSERT INTO nheNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Intla ineltosquíaj iniaxcahua ni tlaltepactli, inijuanti inmechicnelisquíaj. Pero ax iniaxcahua ni tlaltepactli pampa na nimechtlapejpenijtoc huan nimechiyocacajtoc tlen tlacame tlen ni tlaltepactli tlen ax quiixmatij Toteco, huan yeca inmechcocolíaj. ");
INSERT INTO nheNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xiquilnamiquica tlen nimechilhuijtoc. Se tlatequipanojquetl ax más hueyi que iteco. Inijuanti tlen nechtlatzacuiltise, nojquiya inmechtlatzacuiltise pampa innoaxcahua. Huan tlen quineltocatoque notlajtol nojquiya inmechneltoquilise imotlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Tlen inmechcocolíaj pampa innechneltocatoque, queja nopa quichihuaj pampa ax quiixmatij Toteco tlen nechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Intla ax nihualajtosquía huan niquinmachtijtosquía, axaca quinteilhuijtosquía. Pero ama ax quipiyase tleno tlen ica huelise motechtise iixpa Toteco pampa ax quineltocaque notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Se tlen nechcocolía, nojquiya quicocolía noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Intla ax nijchijtosquía nopa huejhueyi tlanescayotl iniixpa tlen axaca seyoc hueltoc quichihua, ax quipiyasquía inintlajtlacol. Pero ya quiitztoque ajqueya na huan nechcocolijtoque huan nojquiya quicocolijtoque noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Yeca inijuanti quitlamiltijtoque tlen ijcuilijtoc ipan itlanahuatil campa camati tlen na huan quiijtohua: ‘Nechcocolijtoque yonque ax tleno tlen ax cuali nijchijqui.’ ");
INSERT INTO nheNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Pero quema ajsis nopa Tlayoltlalijquetl tlen nimechtitlanilis quema niajsiti ichaj noTata, yajaya inmechmachtis nochi tlen na. Yajaya Itonal Toteco tlen tlamachtía tlen melahuac huan hualas tlen campa itztoc noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Huan teipa inquinyolmelahuase sequinoc tlen na pampa initztoyaj nohuaya hasta quema nipejqui nitlamachtía. ");
INSERT INTO nheNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Nimechilhuijtoc nochi ya ni achtohui para ax inquitlahuelcahuase notlajtol ica nopa tlamantli tlen hualas. ");
INSERT INTO nheNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Pampa teipa ayoc inmechcahuilise xicalaquica ipan israelita tiopamitl. Huan ajsis se tonal quema tlacame tlen inmechmictise moilhuise quitequipanohuaj Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ya nopa quichihuase pampa ax quiixmatij noTata, niyon ax nechixmatij. ");
INSERT INTO nheNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amantzi nimechilhuía nochi ya ni para inquiilnamiquise tlen niquijto quema nochi ni tlamantli inmechpanotiyas. “Achtohuiya ax nimechilhui ni tlamantli tlen inmechpanos pampa nijmatiyaya niitztosquía imohuaya más tonali. ");
INSERT INTO nheNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero ama niyas campa itztoc Toteco tlen nechtitlantoc. Huan axaca tlen imojuanti nechtlajtlanía canque niyas. ");
INSERT INTO nheNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","San inmocuesohuaj pampa nimechilhuía niyas. ");
INSERT INTO nheNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero nimechilhuía tlen melahuac. Más cuali para imojuanti intla niyas. Pampa intla ax niyas, ax hualas nopa Tlayoltlalijquetl. Pero quema nimocuepas campa nihualajqui, nimechhualtitlanilis. ");
INSERT INTO nheNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Huan quema ajsiqui nopa Tlayoltlalijquetl, quinmatiltis sesen tlacatl ipan ni tlaltepactli para quihuica tlajtlacoli iixpa Toteco. Huan quimatiltis para monequi sesen ma itztoca xitlahuaque iixpa Toteco. Huan nojquiya quinyolmelahuas quejatza Toteco tetlajtolsencahuas. ");
INSERT INTO nheNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nopa Tlayoltlalijquetl quinmatiltis tlacame tlen ni tlaltepactli para ya quihuicaj tlajtlacoli pampa ax nechneltocatoque. ");
INSERT INTO nheNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Quinnextilis para huelis mochihuase xitlahuaque iixpa Toteco pampa niya campa itztoc noTata huan ayoc innechitase. ");
INSERT INTO nheNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Quinmatiltis tlacame para Toteco quintlajtolsencahuas queja ya quitlajtolxitlajtoc Axcualtlacatl tlen tlanahuatía ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nijpiya más tlajtoli tlen nimechilhuisquía, pero elis miyac para inquimachilise amantzi. ");
INSERT INTO nheNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero quema hualas Itonal Toteco tlen tlamachtía tlen melahuac, yajaya inmechyacanas hasta inquimatise nochi tlen melahuac. Ax inmechilhuis tlen ya itlalnamiquilis, pero inmechmachtis nochi tlen quicactoc tlen noTata, huan nojquiya inmechnextilis tlen panos teipa. ");
INSERT INTO nheNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Itonal Toteco nechhueyitlalis imoixpa pampa quicuis tlen niquijtojtoc na huan tlen nijchijtoc, huan inmechnextilis tlen quiijtosnequi. ");
INSERT INTO nheNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nochi nopa tlamantli tlen quipiya noTata huan tlen yajaya quichijtiya nojquiya noaxca huan nijchijtiyajtoc. Huajca nimechilhuía Itonal Toteco quicuis tlen na nijchijtoc huan inmechnextilis tlen quinequi quiijtos. ");
INSERT INTO nheNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ica se ome tonali niyas huan ayoc innechitase. Pero teipa ica seyoc se ome tonali, sampa innechitase pampa niyas campa itztoc noTata.” ");
INSERT INTO nheNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Huan sequin tiimomachtijcahua timotlajtlaniyayaj: ―¿Tlaque quiijtosnequi quema Jesús techilhuía ica se ome tonali ayoc tiquitase, huan teipa ica seyoc se ome tonali sampa tiquitase? ¿Para tlen techilhuía elis queja ni pampa yas campa itztoc iTata? ");
INSERT INTO nheNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Tlaque quiijtosnequi ‘ica se ome tonali’? Ax tijmachilíaj tlen techilhuía. ");
INSERT INTO nheNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Huan Jesús quimachili tijnequiyayaj tijtlajtlanise ica tlen techilhuijtoya, huajca techilhui: ―¿Para tlen inmotlajtlaníaj tlaque quiijtosnequi quema nimechilhui ica se ome tonali na niyas huan ayoc innechitase, huan teipa ica seyoc se ome tonali sampa innechitase? ");
INSERT INTO nheNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nelía nimechilhuía inchocase huan inmocuesose, pero tlacame tlen ni tlaltepactli tlen ax nechneltocaj, paquise. Pero yonque achtohui inmocuesose, teipa imocuesol mocuepas paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Quema se sihuatl quinequi quitlacatiltis icone, tlaijiyohuía pampa ajsic nopa hora para tlacuajcualocayotl, pero quema ya tlacatqui icone, ayoc moilhuis intla tlaijiyohui pampa nelía paqui para quiitas icone tlen tlacatqui. ");
INSERT INTO nheNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ihuical elis ica imojuanti. Ama inmocuesohuaj, pero sampa timoitase huan nelía inyolpaquise. Huan axaca huelis inmechquixtilis imopaquilis. ");
INSERT INTO nheNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Quema ajsis nopa tonali quema niitztos ihuaya Toteco, ayoc tleno monequis innechtlajtlanise. Nelía nimechilhuía ipan nopa tonali ya huelis inyase xitlahuac ica noTata huan nochi tlen inquitlajtlanise ipan notoca , yajaya inmechmacas. ");
INSERT INTO nheNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta ama aya tleno inquitlajtlanijtoque noTata ipan notoca . Pero ama xijtlajtlanica huan inquiselise para nelía inyolpactose. ");
INSERT INTO nheNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Nochi ni tlamantli nimechilhuijtoc ica huicalotl tlen achi ohui para inquimachilise. Pero ajsis se tonal quema ayoc tleno nimechilhuis ica huicalotl, san nimechilhuis xitlahuac tlen noTata. ");
INSERT INTO nheNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ipan nopa tonali inquitlajtlanise noTata tlen inquinequise ica notequihuejcayo. Huan ax nimechilhuía nijtlajtlanis noTata ma inmechmaca tlen inquitlajtlaníaj, ");
INSERT INTO nheNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","pampa noTata nojquiya inmechicnelía pampa innechicnelijtoque. Huan inquineltocatoque nihualajqui tlen campa itztoc Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na niquisqui tlen campa itztoc noTata huan niajsico ipan ni tlaltepactli. Huan ama niquisas tlen ni tlaltepactli. Huan nimocuepas campa itztoc noTata.” ");
INSERT INTO nheNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Huajca tiimomachtijcahua tiquilhuijque: ―Ama ticamati xitlahuac huan tojuanti tijmachilíaj. Ayoc ticamati ica huicalotl tlen ohui. ");
INSERT INTO nheNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Huajca ama nelía tijmachilíaj ta tijmati nochi tlamantli. Niyon ax monequi timitztlajtlanise tlen tijnequij tijmatise pampa titechilhuía quema aya timitztlajtlaníaj, huan huajca tijneltocaj Toteco Dios mitztitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Huan Jesús techilhui: ―¿Hasta ama nelía innechneltocaj? ");
INSERT INTO nheNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ama nechca nopa hora, quena, ya ajsico nopa hora quema nochi inmosemanase para sesen quitemos campa mochololtis. Huan innechcajtehuase noselti. Pero nelía ax niitztos noselti pampa noTata itztoc nohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nimechilhuijtoc ama nochi ya ni para inquipiyase tlasehuilistli nopan na. Ipan ni tlaltepactli inquipiyase tlaijiyohuilistli huan cuesoli, pero ximosemacaca pampa nijtlantoc ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Quema Jesús tlanqui quiijtohua nochi ya ni, ajcoitac elhuicac huan quiijto: “Papá, ya ajsico nohora para nitlaijiyohuis. Xijnexti nohueyitilis, na nimocone, para huelis nijchihuas tlen tenextilis mohueyitilis ta. ");
INSERT INTO nheNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tinechmacatoc tequihuejcayotl huan chicahualistli ica nochi tlacame para niquinmacas yolistli yancuic para nochipa nochi inijuanti tlen tinechmacatoc para noaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Inijuanti quipiyaj yolistli yancuic para nochipa intla mitzixmatij ta tlen melahuac tiDios huan axaca seyoc, huan nojquiya nechixmatij na niJesucristo tlen tinechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Na nimitzhueyitlalijtoc ipan ni tlaltepactli pampa nijchijtoc nochi tlen tinechilhuijtoc ma nijchihua. ");
INSERT INTO nheNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ama, Papá, sampa xinechmaca nopa hueyitilistli tlen nijpixtoya achtohuiya quema aya oncayaya tlaltepactli huan niitztoya nepa mohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Niquinpannextili ajqueya ta ica ni tlacame tlen tinechmacatoc ipan ni tlaltepactli para nechneltocase. Inijuanti ipa eliyayaj moaxcahua huan tinechmacac huan ya quichijtinentoque motlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ama inijuanti quimachilíaj para elqui ta tlen tinechmacac nopa tlamantli tlen niquinilhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Pampa nochi tlajtoli tlen tinechilhuijtoc, niquinilhuijtoc huan inijuanti quiselijtoque motlajtol. Ama quimachilíaj para temachtli nihualajtoc tlen nepa campa tiitztoc huan quineltocaj para tinechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Huajca, Papá, nimitztlajtlanía xiquinpalehui ni tlacame tlen tinechmacatoc pampa inijuanti moaxcahua. Ax nimitztlajtlanía xiquinpalehui inijuanti tlen quitoquilíaj san tlen eltoc ipan ni tlaltepactli huan ax nechneltocaj. ");
INSERT INTO nheNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pero nochi ni tlacame tlen noaxcahua nojquiya itztoque moaxcahua. Huan inijuanti tlen moaxcahua nojquiya itztoque noaxcahua huan nohueyitilis monextijtoc ipan inijuanti. ");
INSERT INTO nheNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Ama, na ayoc niitztos ipan ni tlaltepactli, pero inijuanti noja itztose nica. Na niyas sampa niitztoti mohuaya ta, Papá, ta tlen titlatzejtzeloltic, huajca nimitztlajtlanía xiquinmocuitlahui ica motequihuejcayo ni tlacame tlen tinechmacatoc. Xiquinpalehui ma itztoca san se queja tojuanti tiitztoque san se. ");
INSERT INTO nheNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Quema niitztoya nica ininhuaya ipan tlaltepactli, niquinmocuitlahuiyaya ica motequihuejcayo. Huan niyon se ax polijqui, san yajaya tlen ipa quinejqui monenpolos. Huan queja nopa panoc para ma quitlamiltis tlen ijcuilijtoc ipan motlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Papá, ax huejcahuas para nimocuepas niitztoti nepa campa ta, pero ama, quema noja niitztoc ipan ni tlaltepactli, nimitztlajtlanía para ni tlacame tlen noaxcahua ma quipiyaca se paquilistli tlen ajsitoc ipan ininyolo queja na nijpiya. ");
INSERT INTO nheNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ya niquinmacatoc motlajtol huan yeca tlacame tlen quitoquilíaj tlen eltoc ipan ni tlaltepactli quincocolíaj pampa inijuanti ax iaxcahua ni tlaltepactli queja na nojquiya ax niiaxca. ");
INSERT INTO nheNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ax nimitztlajtlanía xiquinquixti tlen nechneltocaj ipan ni tlaltepactli, pero nimitztlajtlanía xiquinmanahui tlen nopa Axcualtlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Inijuanti ax iaxcahua ni tlaltepactli queja na nojquiya ax niiaxca. ");
INSERT INTO nheNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Xiquiniyocatlali huan xiquinchihua tlatzejtzeloltique ica motlajtol tlen nelía melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Queja ta tinechtitlantoc ma nihuala nica ica tlacame ipan ni tlaltepactli para nijchihuas mopaquilis, ama na niquintitlantoc ma yaca ininhuaya tlacame ipan ni tlaltepactli para quichihuase nopaquilis. ");
INSERT INTO nheNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Huan ininpampa inijuanti nimotemaca moca ta para nijchihuas tlen tijnequi ama para inijuanti ma elica senquistoc tlaiyocatlalilme huan tlatzejtzeloltique ipampa motlajtol tlen nelía melahuac. ");
INSERT INTO nheNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ax nimitztlajtlanía xiquinpalehui san inijuanti tlen nechneltocaj ama, pero nojquiya xiquinpalehuis nochi tlen teipa nechneltocase quema ni tlacame yase quinilhuitij notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Xiquinpalehui para nochi inijuanti itztose san se queja niitztoc mopan ta huan ta tiitztoc nopan na. Inijuanti ma itztoca san se ipan tojuanti. Quej nopa tlacame ipan ni tlaltepactli quineltocase para tinechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Huan nopa hueyitilis tlen tinechmacac na, nojquiya niquinmacatoc para inijuanti ma itztoca san se queja tojuanti tiitztoque san se. ");
INSERT INTO nheNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na niitztos ipan inijuanti huan ta tiitztoc ipan na para inijuanti ma itztoca senquistoc san se. Huan yeca nochi tlacame ipan ni tlaltepactli quimachilise para ta tinechtitlantoc huan para tiquinicnelijtoc tlen nechneltocaj queja ta tinechicnelijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Papá, nojquiya nijnequi inijuanti tlen tinechmacatoc ma itztose nohuaya campa niitztos. Nijnequi ma quiitase nohueyitilis tlen tinechmacac pampa tinechicnelijtoc hasta quema aya oncayaya tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Papá, ta senquistoc tixitlahuac. Yonque tlacame tlen ax nechneltocaj ipan ni tlaltepactli ax mitzixmatij, na quena, nimitzixmati. Huan ni tlacame tlen noaxcahua ya quimachilijtoque para ta tinechtitlantoc. ");
INSERT INTO nheNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Na niquinilhuijtoc ajqueya ta huan noja más niquinilhuis para inijuanti ma moicnelica queja ta tinechicnelía pampa na niitztos ipan ininyolo.” ");
INSERT INTO nheNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Huan Jesús tlanqui momaijtohua ica iTata huan yajqui tohuaya tiimomachtijcahua hasta seyoc nali nopa atlajtli tlen itoca Cedrón campa eltoya se cuamili tlen olivo cuatini. Huan ticalajque nepa. ");
INSERT INTO nheNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Huan Judas tlen quitemactilisquía Jesús nojquiya cuali quiixmatiyaya nopa olivo cuamili pampa Jesús huan tiimomachtijcahua miyac huelta timosentiliyayaj nepa. ");
INSERT INTO nheNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Huan Judas ajsico quinyacanayaya se pamitl tlen seis cientos soldados. Nojquiya nopa tlayacanca totajtzitzi huan nopa fariseos quititlanque nopa policías tlen quimocuitlahuijque tiopamitl. Huan nochi quihualicayayaj tlahuili, huan tlicualelemectli huan machetes. ");
INSERT INTO nheNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Pero Jesús ya quimatiyaya nochi tlen quipanosquía huan yeca yajqui quinnamiquito. Huan quinilhui: ―¿Ajqueya inquitemohuaj? ");
INSERT INTO nheNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Huan inijuanti quiilhuijque: ―Tijtemohuaj Jesús tlen ehua altepetl Nazaret. Huan quinilhui: ―Na niJesús. Huan Judas tlen quitemactiliyaya Jesús ijcatoya ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Huan quema quinilhui: “Na niJesús”, motzinquixtijque nochi inijuanti huan ajquetzhuetzque. ");
INSERT INTO nheNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Huajca sampa Jesús quinilhui: ―¿Ajqueya inquitemohuaj? Huan sampa quiilhuijque: ―Tijtemohuaj Jesús tlen ehua Nazaret. ");
INSERT INTO nheNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Huan Jesús quinilhui: ―Nimechilhui na niJesús. Huajca intla innechtemohuaj, xiquincahuaca ma yaca ni tlacame tlen itztoque nohuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Quej ni tlamisquía tlen Jesús quiilhui iTata achtohuiya para ax quipolojtoya niyon se tlacatl tlen quimacatoya. ");
INSERT INTO nheNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Huan Simón Pedro tlen quihuicayaya imachete, quiquixti huan quitzontequili inacas tlen inejmatl se tlacatl tlen quitocajtiyayaj Malco. Yajaya elqui itlatequipanojca nopa hueyi totajtzi. ");
INSERT INTO nheNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Huajca Jesús quiilhui Pedro: ―Xijcalaqui momachete ipan icuetlaxo. Monequi nijselis nopa tlaijiyohuilistli tlen noTata nechmacatoc. ");
INSERT INTO nheNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Huajca nopa soldados, huan inintlayacanca huan israelita policías tlen tiopamitl quiitzquijque Jesús huan quiilpijque. ");
INSERT INTO nheNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Huan achtohui quihuicaque hasta ichaj Anás tlen eliyaya imontat Caifás. Huan Caifás yancuic calactoya para elis hueyi totajtzi para nopa xihuitl. ");
INSERT INTO nheNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Huan elqui Caifás tlen achtohuiya quinilhuijtoya israelitame para quinamiqui san setzi tlacatl miquisquía ininpampa nochi tlacame. ");
INSERT INTO nheNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Huan Simón Pedro huan na tijtoquiliyayaj Jesús. Huan nechixmatiyaya nopa hueyi totajtzi, yeca nechcahuili ma nicalaqui icalixpa ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero Pedro mocajqui calteno nechca cuapuerta. Huajca niyajqui nijcamahuito se ichpoca tlatequipanojquetl tlen quimocuitlahuiyaya cuapuerta. Huan quicahuili Pedro ma calaqui. ");
INSERT INTO nheNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Huan nopa ichpocatl quiilhui Pedro: ―Ta nojquiya tiimomachtijca ne tlacatl. ¿Ax que? Huan Pedro quinanquili: ―Na, axtle. ");
INSERT INTO nheNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Huan moquetzayayaj nepa nopa tlatequipanohuani huan nopa policías. Huan tlipitztoyaj huan mototoniyayaj pampa tlaseseyayaya. Huan Pedro nojquiya itztoya ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Huan Anás tlen onquistoya queja hueyi totajtzi quitlajtlani Jesús tlaque inintoca nochi imomachtijcahua huan tlaque tlamachtiyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Huan Jesús quinanquili: ―Nicamatiyaya tlamiyacapa ica nochi tlacame. Mojmostla nitlamachtiyaya ipan israelita tiopantini ipan campa hueli pilaltepetzitzi huan ipan nopa hueyi tiopamitl nica ipan Jerusalén campa mosentilíaj nochi israelitame. Ax tleno niquijtojtoc ixtacatzi. ");
INSERT INTO nheNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Para tlen tinechtlajtlanía tlaque nitlamachti? Xiquintlajtlanica tlen nechtlacaquilijque quema nitlamachti. Inijuanti quimatij tlaque niquinilhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Quema Jesús quiijto ya ni, se policía tlen israelita tiopamitl quiixtejtzonqui huan quiilhui: ―Ax cuali tijnanquilía ni hueyi totajtzi queja nopa. ");
INSERT INTO nheNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Huan Jesús quinanquili: ―Intla niquijto tlen ax cuali, xijnexti tlaque ax cuali niquijto, huan intla niquijto tlen xitlahuac, ax quinamiqui tinechixtejtzonas. ");
INSERT INTO nheNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Huajca Anás quititlanqui Jesús ilpitoc campa Caifás nopa hueyi totajtzi tlen yancuic calactoya. ");
INSERT INTO nheNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Huan Pedro ijcatoya nechca campa tlitl mototoniyaya huan quiilhuijque: ―Ta tiitztoc se imomachtijca nojquiya. Huan Pedro ax monexti, quiijto: ―Na, axtle. ");
INSERT INTO nheNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Huan itztoya nepa se itlatequipanojca nopa hueyi israelita totajtzi huan nopa tlatequipanojquetl eliyaya iteixmatca nopa tlacatl tlen Pedro quitzontequilijtoya inacas. Huajca yajaya quiilhui Pedro: ―Nimitzitac yehuaja ipan nopa olivo cuamili ihuaya Jesús. ¿Ax que? ");
INSERT INTO nheNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Huan Pedro sampayanoc ax monexti, huan nima tzajtzic se cuapelech. ");
INSERT INTO nheNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Huan quema tlanestihualayaya quisque ichaj Caifás huan quihuicaque Jesús hasta campa hueyi tequicali campa mocahua Gobernador Pilato. Pero nopa israelitame tlen quiteilhuiyayaj Jesús ax calajque ichaj Pilato. Pampa toisraelita tlanahuatil ax techcahuilía tiisraelitame ma ticalaquica ichaj se tlen ax israelita. Huan intla se calaquisquía, ayoc eli tlapajpactic iixpa Toteco huan ax huelis quicuas nopa tlacualistli ipan Pascua Ilhuitl. ");
INSERT INTO nheNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Huan Pilato quisqui calteno huan quintlajtlani: ―¿Ica tlaque inquiteilhuíaj ni tlacatl? ");
INSERT INTO nheNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Huan quinanquilijque: ―Intla yajaya ax elisquía se tlaixpanoquetl, ax timitzhualiquilijtosquíaj. ");
INSERT INTO nheNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Huan Pilato quinilhui: ―Xijhuicaca imojuanti huan xijtlajtolsencahuaca queja quiijtohuaj imotlanahuatilhua tlen inquitoquilíaj. Huan nopa tlayacanca israelitame quinanquilijque: ―Ax tijpiyaj tequihuejcayotl para tijcuamapeloltise se tlacatl, pero ta, quena. ");
INSERT INTO nheNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Huajca ica ni tlajtoli elqui melahuac tlen Jesús quiijtojtoya quema quiijto para tlacame quitlejcoltisquíaj ipan cuamapeli huan quimictisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Huan Pilato sampa calajqui ichaj huan quinotzqui Jesús huan quitlajtlani: ―¿Ta tiinintlanahuatijca israelitame? ");
INSERT INTO nheNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Huan Jesús quinanquili: ―¿Tijmachilía niinintlanahuatijca o tinechtlajtlanía ya ni pampa sequinoc mitzilhuijtoque para nitlanahuatijquetl? ");
INSERT INTO nheNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Huan Pilato quiilhui Jesús: ―Tijmati na ax niisraelita. Elque moisraelita tlacajhua tlen san se imoeso huan imotlayacanca totajtzitzi tlen mitztemactilicoj nomaco. ¿Para tlen? ¿Tlaque tijchijtoc? ");
INSERT INTO nheNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Huajca Jesús quinanquili: ―Notlanahuatilis campa na nitlanahuatía ax mocahua ipan ni tlaltepactli. Intla niitztosquía nitlanahuatijquetl nica, notlacajhua ipan notlanahuatilis tlatehuijtosquíaj para ma ax nechtemactilijtosquíaj ica ni israelita tlayacanani. Pero ax nitlanahuatía nica. ");
INSERT INTO nheNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Huan Pilato quiilhui: ―¿Huajca melahuac titlanahuatijquetl? Huan Jesús quiilhui: ―Quena, nitlanahuatijquetl. Yeca nitlacatqui ipan ni tlaltepactli. Nihualajqui nica para nitlamachtis tlen melahuac huan nochi tlen quinequij quimatise tlen melahuac nechtlacaquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Huan Pilato quiilhui: ―¿Tlaque eltoc melahuac? Huan quema Pilato quiijto ya ni, yajqui calteno campa nopa miyaqui israelitame itztoyaj huan quinilhui: ―Niyon se itlajtlacol ax nijpantilía. ");
INSERT INTO nheNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero inmomajtoquejya ica sesen xihuitl ipan ni Pascua Ilhuitl, innechtlajtlaníaj ma nijcahuili ma yohui ichaj se tlen tzactoc. Huajca, ¿inquinequij ma nimechmajcahuili imotlanahuatijca inisraelitame? ");
INSERT INTO nheNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Huan inijuanti tlahuejchijque chicahuac: ―¡Axtle! ¡Ax tijnequij! Xitechmajcahuili Barrabás. Huan nopa Barrabás eltoya se fiero tlaixpanoquetl. ");
INSERT INTO nheNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Huajca Pilato tlanahuati ma quicuartajhuica Jesús ica se cuarta tlen iyecapa quipixtoya piltepostzitzi tlen tlatequi. ");
INSERT INTO nheNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Huan nopa soldados quisencajque se huitzcorona huan quiicpohuiltijque Jesús. Huan quipantzajque ica se yoyomitl tlen moradojtic queja motlalilíaj tlanahuatiani. ");
INSERT INTO nheNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Huan pejque quitlaijilhuíaj queja quitlepanitasquíaj, pero axtle. Huan quiilhuiyayaj: ―¡Ma itzto miyac tonali ni inintlanahuatijca israelitame! Huan quiixtejtejtzonque. ");
INSERT INTO nheNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Huan teipa Pilato yajqui calixpa iniixpa nochi israelitame huan quinilhui: ―Xijtlachilica ni tlacatl quesqui tlaijiyohuijtoc. Nijnequi xijmatica na ax nijpantili niyon se itlajtlacol. ");
INSERT INTO nheNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Huan Jesús quisqui calteno iniixpa quiicpohuijti nopa huitzcorona huan iyoyo tlen moradojtic. Huajca Pilato quiijto: ―Xijtlachilica ni tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Huan quema quiitaque nopa tlayacanca totajtzitzi huan nopa policías tlen tiopamitl, tlahuejchijque huan chicahuac quiijtojque: ―¡Xijcuamapelolti! ¡Xijcuamapelolti! Huan Pilato quinilhui: ―Imojuanti xijhuicaca huan xijcuamapeloltitij, pero na ax nijpantili niyon se itlajtlacol. ");
INSERT INTO nheNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero nopa tlayacanca israelitame quinanquilijque: ―Tijtoquilíaj se tlanahuatili tlen tiisraelitame tijpiyaj tlen quiijtohua monequi miquis pampa quiijto para yajaya Icone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Huan quema quicajqui Pilato para Jesús teilhuijtoya para itztoya Icone Toteco, achi más momajmati. ");
INSERT INTO nheNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Huan sampa calaquito tequicalco huan quitlajtlani Jesús: ―¿Canque nelía tiehua? Pero Jesús ax quinanquili. ");
INSERT INTO nheNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Huan Pilato quiilhui: ―¿Para tlen ax tinechnanquilía? ¿Ax tijmati nijpiya tequihuejcayotl para nimitzcuamapeloltis o para nimitzmajcahuas para tiyas mochaj? ");
INSERT INTO nheNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Huan Jesús quinanquili: ―Niyon se tequihuejcayotl ax tijpiyasquía noca na intla Toteco Dios ax mitzmacatosquía. Huajca yajaya tlen nechtemactilijtoc momaco más quipiya tlajtlacoli que ta. ");
INSERT INTO nheNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Quema Pilato quicajqui ya ni, pejqui moyolilhuía quejatza huelisquía quimajcahuas Jesús para ma yas ichaj, pero nopa israelitame chicahuac tlahuejchihuayayaj huan quiijtohuayayaj: ―Intla tijmajcahuas ni tlacatl ma yohui, ayoc tiihuampo nopa hueyi tlanahuatijquetl César ipan altepetl Roma. Pampa se tlen mochihua tlanahuatijquetl queja mochihua ni Jesús, yajaya icualancaitaca César. ");
INSERT INTO nheNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Quema Pilato quicajqui ya ni, mosehui campa monequi para tetlajtolsencahuas ipan nopa tepejpechtli campa itoca Enlosado huan ica tlajtoli hebreo itoca Gabata. Huan tlanahuati ma quihualicaca Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Huan eliyaya ijnaloc ipan nopa tonal para quicualtlalise nochi tlen monequi para nopa Pascua tlacualistli. Huan Pilato quinilhui nopa miyac israelitame: ―Xiquitaca nica itztoc imotlanahuatijca. ");
INSERT INTO nheNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Huan nopa israelitame chicahuac quiijtojque: ―¡Xijquixti, xijquixti, xijcuamapeloltiti! Huan Pilato quinilhui: ―¿Inquinequij ma nijmicti imotlanahuatijca? Huan nopa tlayacanca totajtzitzi quiilhuijque: ―Axaca seyoc totlanahuatijca, san César. ");
INSERT INTO nheNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Huajca Pilato quinmactili Jesús para ma quicuamapeloltica huan quihuicaque. ");
INSERT INTO nheNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Huan quichijque Jesús ma quihuica icuamapel huan ma quisa para se lugar campa itoca “Mijcatzontecomitl” (ipan tlajtoli hebreo itoca Gólgota). ");
INSERT INTO nheNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nepa quicuamapeloltijque Jesús huan nojquiya quincuamapeloltijque sequinoc ome tlacame, se ipan inejmatl huan seyoc ipan iarraves huan Jesús tlatlajco mocajqui. ");
INSERT INTO nheNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Huan Pilato quichijqui se tlajcuiloli huan quitlatzquiltijque ipan cuamapeli itzonpac Jesús. Huan nopa tlajcuiloli quiijto: NI JESÚS TLEN EHUA NAZARET, YAJAYA ININTLANAHUATIJCA ISRAELITAME. ");
INSERT INTO nheNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Huan miyac israelitame quipojque nopa tlajcuiloli pampa quicuamapeloltijque Jesús nechca altepetl Jerusalén. Huan quiijcuilojtoyaj nopa tlajcuiloli ica eyi tlajtoli; hebreo, griego huan latín. ");
INSERT INTO nheNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Huan nopa tlayacanca totajtzitzi quiilhuijque Pilato: ―Amo xiquijcuilo: ‘Inintlanahuatijca israelitame.’ Achi cuali xiquijcuilo: ‘Yajaya motocajti inintlanahuatijca israelitame.’ ");
INSERT INTO nheNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Huan Pilato quinilhui: ―Tlen niquijcuilojtoc, ya nopa mocahuas. ");
INSERT INTO nheNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Huan nopa nahui soldados tlen quicuamapeloltijque Jesús quicuilijque iyoyo huan quichijque nahui tlamontomitl huan sesen soldado quihuicac se para iaxca. Nojquiya quicuilijque iyoyo huehueyac tlen ax tlatectli. Quisencajtoyaj nopa yoyomitl coxtaltic, ax tlajtzontli tlen iquechtla hasta iicxico. ");
INSERT INTO nheNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Huajca nopa soldados moilhuijque: ―Ma ax tijtzayanaca. Más cuali ma tijrifarose para tiquitase ajqueya quitlanis huan quihuicas. Huan ica tlen inijuanti quichijque quitlamiltiyayaj tlen huejcajquiya quiijcuilo nopa tiocamanalojquetl para quichihuasquíaj. Quiijcuilo: “Momajmacaque sequin noyoyo huan noyoyo tlen huehueyac, quirifarojque.” Huajca queja nopa quichijque nopa soldados. ");
INSERT INTO nheNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Huan iicxitla icuamapel Jesús moquetzayayaj inana, huan iicni inana, huan María isihua Cleofas huan María Magdalena. ");
INSERT INTO nheNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Huan quema Jesús quiitac inana huan inechca nechitac na tlen niimomachtijca tlen más nechicneli, huajca quiilhui inana: ―Nane, ni tlacatl elis queja mocone. ");
INSERT INTO nheNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Huan nechilhui: ―Xijchihua nonana queja monana. Huajca ipan nopa tlalochtli quema tiquisque, nijhuicac inana nochaj para nijmocuitlahuis. ");
INSERT INTO nheNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Teipa Jesús quimatqui ya tlantoya nochi itequi. Huajca para quitlamiltis tlen ijcuilijtoc ipan Itlajtol Toteco, yajaya quiijto: ―Niamiqui. ");
INSERT INTO nheNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Huan eltoya nopona se xalo temitoc ica xocomeca atl tlen xococ. Huan quixolonijque se tlamantli tlen tzotzoltic huan quitlalijque iyecapa se huehueyac cuahuitl tlen itoca hisopo. Huan quitentoquiltijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Huan quema Jesús quimachili nopa xocomeca atl tlen xococ, quiijto: ―Ya tlanqui notequi tlen noTata nechmacac ma nijchihua. Huajca Jesús mohuijtzonqui huan quitemactili itonal imaco Toteco huan mijqui. ");
INSERT INTO nheNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Huan Jesús mijqui ipan nopa tonal quema tiisraelitame timomatque titlacualtlalíaj nochi tlen monequi para nopa Pascua Ilhuitl pampa hualmostla elisquía se tonal para timosiyajcahuase. Huajca axaca quinequiyaya ma mocahuaca nopa eyi mijcatzitzi ipan inincuamapel hasta tonilis pampa elisquía nopa hueyi tonal tlen toilhui huan monequi timosiyajcahuase ica miyac tlatlepanitacayotl. Huajca yajque nopa tlayacanani tlen israelitame huan quitlajtlanitoj Pilato ma tlanahuati para ma quintlapanilise ininmetzomiyo tlen itztoyaj ipan cuamapeli para nimantzi ma miquica para huelis quinhuicase. ");
INSERT INTO nheNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Huajca hualajque soldados huan quintlapanilijque ininmetzomiyo tlen quincuamapeloltijtoyaj inejmatl Jesús huan nojquiya nopa tlen iarraves. ");
INSERT INTO nheNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero quema ajsitoj campa icuamapel Jesús, quiitaque ya mictoya, huajca ax quitlapanilijque imetzomiyo. ");
INSERT INTO nheNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Huajca se soldado quitlapohuili ielchiquicanahuiya ica icuatlami tlen huehueyac huan quisqui estli maneltic ica atl. ");
INSERT INTO nheNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Huan na niJuan nochi niquitac, huan nimechilhuía tlen nelía panoc pampa nijmati para melahuac tlen nimechilhuía huan huelis inquineltocase notlajtol. ");
INSERT INTO nheNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nochi ya ni panoc para ma quitlamilti tlen ijcuilijtoc ipan Itlajtol Toteco campa quiijtohua: “Ax quitlapanilise niyon se iomiyo.” ");
INSERT INTO nheNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Huan sejcoyoc ipan Itlajtol Toteco quiijtohua: “Quitlachilise yajaya tlen quitlapohuilijque ielchiquicanahuiya.” ");
INSERT INTO nheNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Teipa ajsico José tlen ehua altepetl Arimatea. Yajaya quitoquili Jesús ixtacatzi pampa quinimacasiyaya nopa tlayacanca israelitame. Pero quema nochi ni panoc, José yajqui huan quitlajtlani Pilato ma quicahuili quihuicas itlacayo Jesús. Huan Pilato quicahuili. Huajca nimantzi José yajqui huan quitemohuito itlacayo ipan icuamapel. ");
INSERT INTO nheNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Huan nojquiya hualajqui Nicodemo tlen achtohuiya yajqui quicamahuito Jesús ica tlayohua. Yajaya quihualicayaya nechca treinta kilos tlen se pajtli tlen ajhuiyac maneltic ihuaya seyoc tlaajhuiyacayotl tlen tlatixtic. ");
INSERT INTO nheNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Huan José ihuaya Nicodemo quihuicaque itlacayo Jesús, huan quipolojque nopa tlaajhuiyacayotl huan quipijque ica se yoyomitl queja tiisraelitame timomatque tijchihuaj quema tijtocaj se mijcatzi. ");
INSERT INTO nheNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Huan nechca campa quimictijque Jesús ipan icuamapel eltoya se cuamili. Huan ipan nopa cuamili eltoya se yancuic tlacacahuaya para ipan quintlalise mijcatzitzi. Huan niyon se mijcatzi aya quema quitlalijtoyaj nopona. ");
INSERT INTO nheNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Huajca quitlalitoj itlacayo Jesús nepa pampa nopa tlacajcahuaya eltoya nechcatzi. Huan ya nechca las seis ica tiotlac tlen eliyaya quema pehua nopa tonal tlen Pascua huan monequi israelitame ma mosiyajcahuaca. ");
INSERT INTO nheNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ipan domingo nopa achtohui tonal ipan samano yajqui María Magdalena ijnaltzi campa nopa tlacacahuaya quema noja tlatlayohua. Huan quiitac nopa hueyi tetl ayoc quiixtzactoya nopa tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Huajca nimantzi motlalojtejqui hasta campa Simón Pedro huan na tlen Jesús miyac nechicneli. Huan María techilhui: ―Quiquixtijque itlacayo Tohueyiteco ipan tlacacahuaya huan quihuicaque huan ax tijmatij canque quicahuatoj. ");
INSERT INTO nheNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Huan Pedro huan na timotlalojtejque chicahuac para tijtlachilitij nopa tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","San sejco timotlalojque, pero achi más nimoisihuilti nimotlalo queja Pedro huan achtohui niajsito campa tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Huan nimopacho huan nijtlachili tlacacahuaya ijtic. Huan niquitac quicajtejtoya nopa yoyomitl tlen ica quihuijcontoyaj itlacayo, pero ax nicalajqui tlacacahuaya ijtic. ");
INSERT INTO nheNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Teipa Simón Pedro tlen nechtoquiliyaya, nojquiya ajsico. Huan yaja, quena, calaquico tecacahua ijtic huan quiitac quicajtejtoya nopa yoyomitl tlen ica quihuijcontoyaj itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Huan nojquiya quiitac nopa payo tlen ica quiixtzactoyaj, quiquimilojtoyaj huan quicajtoya iyoca tlen nopa hueyi yoyomitl. ");
INSERT INTO nheNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Huajca na nojquiya tlen niajsico achtohui nicalajqui huan niquitac quejatza nopa tlamantli. Huan nijneltocac para ayoc aquiyaya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pampa noja aya tijmachiliyayaj queja ijcuilijtoc ipan Itlajtol Toteco para monejqui moyolcuis. ");
INSERT INTO nheNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Huajca tiimomachtijcahua tiquisque huan tiyajque tochajchaj. ");
INSERT INTO nheNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Huan María Magdalena mocajqui nopona huan moquetztoya iteno tlacacahuaya chocayaya. Huan quema noja chocayaya, mopacho huan tlachixqui iijtic tlacacahuaya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Huan quinitac ome elhuicac ehuani ica chipahuac ininyoyo tlen mosehuijtoyaj campa achtohuiya eltoya itlacayo Jesús. Se mosehuijtoya campa eltoya itzontla huan seyoc campa iicxitla. ");
INSERT INTO nheNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Huan quiilhuijque: ―Nane, ¿para tlen tichoca? Huan María quinilhui: ―Pampa sequin quiquixticoj itlacayo nohueyiTeco huan ax nijmati canque quicahuatoj. ");
INSERT INTO nheNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Huan quema quiijto ya ni, moicancuepqui María huan quiitac Jesús moquetztoya nopona, pero ax quiixmatqui intla Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Huan Jesús quiilhui: ―Nane, ¿para tlen tichoca? ¿Ajqueya tijtemohua? Huan María moilhuiyaya elqui tlen quimocuitlahuiyaya nopa cuamili, huajca quiilhui: ―Tate, intla ta tijhuicatoc itlacayo, xinechilhui canque tijtlalito huan niyas nijcuiti. ");
INSERT INTO nheNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Huan Jesús quiilhui: ―¡María! Huan María moicancuepqui huan quiilhui: ―¡Raboni! (Ni tlajtoli quinequi quiijtos: ‘Tlamachtijquetl’.) ");
INSERT INTO nheNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Huan Jesús quiilhui: ―Amo xinechitzqui pampa aya nitlejcotoc campa itztoc noTata. Pero xiya campa noicnihua huan xiquinilhuiti nitlejcos campa itztoc noTata tlen nojquiya imoTata huan yajaya tlen noTeco huan nojquiya imoTeco. ");
INSERT INTO nheNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Huan María Magdalena quisqui techyolmelahuaco tiimomachtijcahua para quiitztoya Tohueyiteco. Huan techilhui nochi tlen Jesús quiilhuijtoya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Huan quema tlayohuac nopa domingo, nopa achtohui tonal ipan samano tiimomachtijcahua timosentilijtoyaj ipan se cali. Huan cuali tijtzactoyaj nopa cuapuerta campa tiitztoyaj para axaca ma calaqui pampa tiquinimacasiyayaj nopa tlayacanani tlen israelitame. Huan Jesús san tlalochtli monextico, moquetztoc tlatlajco tojuanti huan techilhui: ―Xijpiyaca tlasehuilistli ipan imoyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Huan quema quiijto ya ni, technextili nochi ome ima campa quimalavoshuijque huan technextili ielchiquicanahuiya. Huan tiimomachtijcahua nelía tipaquiyayaj quema sampa tiquitaque Tohueyiteco. ");
INSERT INTO nheNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Huan Jesús techilhui sampa: ―Xijpiyaca tlasehuilistli ipan imoyolo. Ihuical queja noTata nechtitlantoc ma nijchihuas ipaquilis, na nojquiya nimechtitlani imojuanti para inquichihuase nopaquilis. ");
INSERT INTO nheNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Huan quema quiijto ya ni, techilpitzqui huan techilhui: ―Ama xijselica Itonal Toteco. ");
INSERT INTO nheNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Intla inquitlapojpolhuise se tlacatl itlajtlacolhua, huajca Toteco quitlapojpolhuis. Huan intla ax inquitlapojpolhuise se tlacatl, huajca noja quihuicas tlajtlacoli. ");
INSERT INTO nheNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero ax aquiyaya Tomás quema Jesús ajsico ipan nopa tlasentilistli. Yajaya eliyaya se tlen timajtlactli huan ome tiimomachtijcahua Jesús huan tijtocajtijque Cuate. ");
INSERT INTO nheNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Huan teipa tiquilhuijque para tiquitztoyaj Tohueyiteco. Pero Tomás techilhui: ―Intla ax niquitas ima, huan nijcalaquis nomacpil campa lipintic ica nopa lavos huan nijcalaquis noma ipan ielchiquicanahuiya campa quitlapohuilijque, ax nijneltocas intla nelía ya. ");
INSERT INTO nheNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Huan hualchicueyiijqui ipan seyoc domingo tiimomachtijcahua timosentilijtoyaj huan cuali tijtzactoyaj nopa cuapuerta huan Jesús sampa san tlalochtli monextico, moquetztoc tlatlajco tojuanti. Huan techilhui: ―Xijpiyaca tlasehuilistli ipan imoyolo. ");
INSERT INTO nheNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Huan nimantzi quiilhui Tomás: ―Xijcalaqui momacpil nica huan xijtlachili nomaixco huan xijcalaqui moma campa noelchiqui. Ayoc más xijchiya para tijneltocas. Xijneltoca para temachtli nimoyolcuitoc. ");
INSERT INTO nheNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Huan Tomás quiilhui: ―Ta tinohueyiTeco huan tinoDios. ");
INSERT INTO nheNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Huan Jesús quiilhui Tomás: ―Pampa tinechitac, tinechneltocac. Más paquilistli quipiyase tlacame tlen nechneltocase yonque ax nechitase. ");
INSERT INTO nheNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Huan miyac más tlanescayotl Jesús quichijqui toixpa tiimomachtijcahua tlen ax ijcuilijtoc ipan ni amatl. ");
INSERT INTO nheNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ni huejhueyi tlanescayotl tlen ijcuilijtoc ipan ni amatl, niquijcuilojtoc para xijneltocaca para Jesús itztoc nopa Cristo tlen hualasquía huan yajaya Icone Toteco Dios. Huan pampa inquineltocase, inquipiyase yolistli yancuic para nochipa ipan itoca. ");
INSERT INTO nheNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Teipa Jesús sampa monextico ica tojuanti tiimomachtijcahua nechca campa nopa hueyi atl tlen itoca Tiberias o Galilea huan queja ni panoc. ");
INSERT INTO nheNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nochi tojuanti tiitztoyaj san sejco: Simón Pedro, Tomás tlen tijtocajtijque Cuate, Natanael tlen ejqui Caná ipan estado Galilea huan na ihuaya noicni tlen tiiconehua Zebedeo. Huan nojquiya tohuaya itztoyaj seyoc ome imomachtijcahua. ");
INSERT INTO nheNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Huan Simón Pedro techilhui: ―Na niyas nimichtlajtlamati. Huajca tiquilhuijque: ―Nojquiya tiyase mohuaya. Huan tiyajque ateno huan titlejcoque ipan se cuacanahua. Huan timichtlajtlamajque seyohual, pero niyon se michi ax tiquitzquijque. ");
INSERT INTO nheNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Huan quema tlanestihualayaya, san tlalochtli monextico Jesús, moquetztoc xalixco, pero ax tiquixmatque intla Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Huajca technojnotzqui: ―Nohuampoyohua, ¿inquinitzquitoque michime? Huan tiquilhuijque: ―Axtle, ax tleno. ");
INSERT INTO nheNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Huan techilhui: ―Xijmajcahuaca imomatla ipan inejmatl imocuacanahua huan inquinitzquise. Huan tijchijque huan ax tihueliyayaj tijquixtíaj tomatla ipan atl pampa nelía miyac michime tiquinmasiltijque. ");
INSERT INTO nheNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Huajca na tlen Jesús nechicneli niquilhui Pedro: “Yajaya Tohueyiteco.” Huajca quema Pedro quicajqui para eliyaya Tohueyiteco, moquenti icamisa pampa moquixtilijtoya, huan tzicuinqui ipan hueyi atl huan ajquitiyajqui hasta campa itztoya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Huan teipa tisequinoc imomachtijcahua tiajsicoj ateno ipan tocuacanahua pampa ax huejca tiitztoyaj tlen tlali, huelis san cien metros. Huan tijhuahuatatztihualajque tomatla tlen temitoya ica michime. ");
INSERT INTO nheNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Huan quema tiajsicoj campa tlalixco, tiquitaque para Jesús ya tlipitztoya huan quicacatzohuayaya se michi ipan tlicoli. Huan nojquiya eltoya pantzi. ");
INSERT INTO nheNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Huan techilhui: ―Xinechhualiquilica se ome michime tlen inquinitzquijque. ");
INSERT INTO nheNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Huan Simón Pedro tlejcoc ipan cuacanahua huan quiitzqui nopa matlatl huan iselti quihuahuatatzqui hasta tlalpani. Huan nopa matlatl quinpixtoya 153 huejhueyi michime. Pero yonque nelía miyac quinpixtoya, ax tzayanqui tomatla. ");
INSERT INTO nheNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Huan Jesús techilhui: ―Xihualaca, ma titlacuaca. Huan niyon se tlen tojuanti tiimomachtijcahua ax monejqui tijtlajtlanijque intla nelía eliyaya Tohueyiteco pampa nochi tiquixmatque para yaja. ");
INSERT INTO nheNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Huajca Jesús quicuito pantzi huan michime, huan techmacac ma tijcuaca. ");
INSERT INTO nheNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ica ni mochijqui eyi hueltas para Jesús monexti ica tojuanti tiimomachtijcahua quema ya mictoya huan sampa moyolcuitoya. ");
INSERT INTO nheNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Huan quema titlanque titlacuaj, Jesús quiilhui Simón Pedro: ―Simón, tiicone Jonás, ¿tinechicnelía más queja ne sequin? Huan Pedro quiilhui: ―Quena, noTeco, tijmati na nimitzicnelía. Huan Jesús quiilhui: ―Xiquinmachti notlacajhua notlajtol. Itztoque queja pilborregojtzitzi. ");
INSERT INTO nheNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Huan Jesús ica ompa quitlajtlani: ―Simón, tiicone Jonás, ¿tinechicnelía? Huan Simón Pedro quiilhui: Quena, noTeco, tijmati nimitzicnelía. Huajca Jesús quiilhui: ―Xiquinmocuitlahui notlacajhua queja se quinmocuitlahuía iborregojhua. ");
INSERT INTO nheNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Huan Jesús ica expa quitlajtlani: ―Simón, tiicone Jonás, ¿tinechicnelía? Huan Pedro mocueso pampa expa quitlajtlanijtoya intla quiicnelía. Huajca quiilhui Jesús: ―NoTeco, ta tijmati nochi tlamantli. Tijmati nimitzicnelía. Huan Jesús quiilhui: ―Xiquinmachti notlacajhua notlajtol queja se quintlamaca iborregojhua. ");
INSERT INTO nheNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nelía nimitzilhuía, quema tiitztoya titelpocatl, timoyoyonti, timotlajcoilpi huan tiyajqui campa tijnequiyaya, pero quema tihuehuejtiyas, tijxitlahuas moma huan seyoc mitzyoyontis huan mitzhuicas campa ax tijnequi tiyas. ");
INSERT INTO nheNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ica ni tlajtoli, Jesús techilhuiyaya queja Pedro miquisquía ipan cuamapeli nojquiya, huan ica imiquilis más quinextisquía ihueyitilis Toteco. Huan teipa Jesús quiilhui Pedro: ―¡Xinechtoquili! ");
INSERT INTO nheNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Huan Pedro moicancuepqui huan nechitac na tlen Jesús más nechicneli niquintoquiliyaya. Niitztoc tlen nimosehuijtoya inechca Jesús ipan nopa tiotlac quema nochi titlacuayayaj san sejco huan nijtlajtlani Jesús ajqueya quitemactilisquía. ");
INSERT INTO nheNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Huan quema Pedro nechitac niquintoquiliyaya, quitlajtlani Jesús: ―NoTeco, ¿tlaque panos ica ya? ");
INSERT INTO nheNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Huan Jesús quiilhui Pedro: ―Intla nijnequisquía para ma itztosquía hasta nimocuepas, ax mocuenta Pedro. Ta xinechtoquili. ");
INSERT INTO nheNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Huajca ica tlacame tlen quineltocatoyaj Jesús momoyajqui nopa tlajtoli para ax nimiquisquía. Pero Jesús ax quiilhui Pedro ax nimiquisquía. San quiilhui para intla quinequisquía ma niitztosquía hasta ya mocuepas, ax icuenta. ");
INSERT INTO nheNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Huan na nieli nopa tlayolmelajquetl tlen niquijcuilojtoc nochi ni tlamantli tlen niquitac. Huan nijmati para melahuac nochi tlen nimechilhuijtoc. ");
INSERT INTO nheNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Huan onca miyac más tlamantli tlen Jesús quichijqui tlen ax niquijcuilojtoc nica. Intla niquijcuilojtosquía senquistoc nochi tlen Jesús quichijqui, nimoilhuía para ipan nochi tlaltepactli ax quicuisquía nochi amatini. San ya nopa.");
INSERT INTO nheNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Noicni Teófilo, achtohui nimitztlajcuilhui huan nimitzilhui nochi tlen Jesús quichijtiyajqui huan nochi tlen tlamachtijtiyajqui tlen pejqui itequi, ");
INSERT INTO nheNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta nopa tonal quema tlejcoc elhuicac. Nimitzilhui quejatza quintlapejpeni nopa tlacame para elise itlayolmelajcahua huan quejatza quinnahuati ica ichicahualis Itonal Toteco tlaque tequitl monequi ma quichihuaca. ");
INSERT INTO nheNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús nelía tlaijiyohui huan mijqui, pero teipa monextiyaya yoltoc iniixtla itlayolmelajcahua miyac hueltas para cuarenta tonali para quinnextilis para yoltoc. Huan yonque inijuanti quitlalilijque miyac tlayejyecoli para quimatise intla nelía yoltoc, yajaya cualquisqui ipan nopa tlayejyecoli huan yeca inijuanti quimatque temachtli para nelía moyolcuitoya. Huan ipan nopa cuarenta tonali Jesús quinilhuiyaya quejatza elis quema Toteco tlanahuatis. ");
INSERT INTO nheNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Huan quema Jesús noja itztoya ininhuaya itlayolmelajcahua, quinnahuati ma mocahuaca ipan altepetl Jerusalén hasta hualas Itonal Toteco. Quinilhui: ―Ximochiyaca nica hasta hualas Itonal Toteco tlen Notata inmechtencahuili inmechtitlanilis. Xiquilnamiquica na nojquiya nimechilhuijtoc tlen ya. ");
INSERT INTO nheNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan nelía tecuaalti ica atl, pero ica se ome tonal Toteco inmechmacas Itonal ipan imoyolo. ");
INSERT INTO nheNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Huan quema itlayolmelajcahua noja itztoyaj ihuaya Jesús, quitlajtlanijque: ―Tohueyiteco, ¿ipan ni tonali titechtojtomas tiisraelitame tlen altepetl Roma tlen ama technahuatía? ¿Sampa tijchihuas ma tijpiyaca toisraelita tlanahuatijca para technahuatis ipan nochi ni totlal queja tijpixque huejcajquiya? ");
INSERT INTO nheNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Huan Jesús quinnanquili: ―Ax monequi inquimatise tlaque hora, niyon tlaque tonali noTata quichihuas nochi ni tlamantli tlen san yajaya quipiya tequihuejcayotl para quichihuas. ");
INSERT INTO nheNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero quema ajsis Itonal Toteco ipan imoyolo, inquipiyase chicahualistli huan inyase intlayolmelahuatij tlen na ipan ni altepetl Jerusalén, huan ipan estados Judea huan Samaria. Huan teipa intlayolmelahuatij tlen na hasta campa más huejhuejca pilaltepetzitzi ipan ni tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Huan Jesús tlanqui quincamahuía huan tlejcoc elhuicac. Huan itlayolmelajcahua san quitlachilijtoyaj quema hualajqui se mixtli tlen quitlamitzacuaco, huan ayoc quiitaque. ");
INSERT INTO nheNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Huan itlayolmelajcahua noja tlachixtoyaj elhuicac campa tlejcotoya huan nimantzi monextijque ome elhuicac ehuani tlen quipixtoyaj ininyoyo nelchipahuac. ");
INSERT INTO nheNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Huan quinilhuijque: ―Xijtlacaquilica inGalilea ehuani, ax monequi inmoquetztose nica intlachixtoque elhuicac. Yajaya ni Jesús tlen ama tlejcoc elhuicac teipa hualasoc san se queja inquiitztoque yajqui. ");
INSERT INTO nheNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Huajca nopa tlayolmelahuani quisque campa nopa tepetl tlen itoca Olivos, huan mocuepque altepetl Jerusalén. Jerusalén mocahua queja se kilómetro ihuejcanca tlen tepetl Olivos, huan eliyaya queja ihuejcanca itlanahuatil Moisés quincahuilíaj israelitame ma nejnemica ipan se tonal para mosehuise. ");
INSERT INTO nheNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Huan itlayolmelajcahua ajsitoj ipan Jerusalén huan tlejcoque ipan se cali tlen quipixqui ome pisos campa mocahuayayaj. Itztoyaj nepa Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo huan Jacobo icone Alfeo. Nojquiya itztoya Simón tlen moiyocanequiyaya ica partido cananista, huan itztoya Judas, iicni Jacobo. ");
INSERT INTO nheNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Huan nojquiya itztoyaj sihuame huan María, inana Jesús, huan iteipa icnihua Jesús. Huan nochi inijuanti ajachica momaijtohuayayaj san sejco ica san se ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Huan se tonal quema mosentilijtoyaj queja 120 tlaneltocani, Pedro moquetzqui tlatlajco inijuanti huan quiijto: ");
INSERT INTO nheNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Noicnihua, monequiyaya panos nochi tlen tiquitztoque ica Judas para ma quitlamiltis tlen ijcuilijtoc ipan Itlajtol Toteco huejcajquiya para teipa panos. Pampa Itonal Toteco huejcajquiya quiilhui tohuejcapan tata David ma quiijcuilo nochi tlen Judas quichihuasquía, yajaya tlen quinyacanqui nopa tlacame tlen quiitzquijque Jesús para ma quimictica. ");
INSERT INTO nheNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas itztoya se tlen tojuanti tlen tiimomachtijcahua Jesús huan tequitic tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ica nopa tomi tlen tlacame quitlaxtlahuijque Judas para quitemactilis Jesús, yajaya quicojqui se tlali huan huetzqui nepa ica itzonteco. Huan tzayanqui iijti huan quisqui nochi icuitlaxcol. ");
INSERT INTO nheNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Huan quema nochi Jerusalén ehuani quicajque tlen panoc, quitocajtijque nopa tlali ‘Acéldama’, ica inintlajtol tlen quinequi quiijtos, ‘Tlali tlen Estli’. ");
INSERT INTO nheNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Quej nopa panoc pampa ya ijcuilijtoc ipan nopa amatl Salmos ipan Itlajtol Toteco campa quiijtohua: ‘Ichaj nopa tlacatl ma mocuepa tlatzitzicatoc huan ma axaca itzto nepa.’ Nojquiya quiijtohua: ‘Ma seyoc tlacatl quihuica itequi.’ ");
INSERT INTO nheNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Huajca ma tijtlapejpenica seyoc tlacatl para quichihuas itequi. Ma elis se tlen nejnentoc tohuaya nochi tonali quema Tohueyiteco Jesús itztoya tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Ma tijtlapejpenica se tlacatl tlen itztoya tohuaya tlen quema Juan quicuaalti Jesús hasta teipa quema Jesús tlejcoc elhuicac. Huan yajaya tlen tijtlapejpenise tequitis tohuaya para teilhuis para nelía moyolcuitoc Jesús.” ");
INSERT INTO nheNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Huan quintlalijque ome tlacame. Se tlacatl quipixqui eyi itoca. Itoca José, Barsabás, huan Justo. Nojquiya quitlalijque seyoc tlacatl tlen itoca eliyaya Matías. ");
INSERT INTO nheNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Huan momaijtojque huan quiijtojque: “Tohueyiteco, cuali tiquinixmati ininyolo nochi tlacame. Xitechnextili catlía ni ome tlacame tijtlapejpenijtoc ta, ");
INSERT INTO nheNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","para quichihuas ni tequitl queja motlayolmelajca ipatlaca Judas tlen huetzqui ipan tlajtlacoli huan tlen yajqui campa quinamiqui ma yas.” ");
INSERT INTO nheNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Huan teipa mahuiltijque ica piltetzitzi tlen yejyectzitzi para quimatise ajqueya Toteco quinequiyaya ma quichihua nopa tequitl. Huan quinexti para Toteco quinejqui Matías. Huajca Matías pejqui tequiti ininhuaya nopa majtlactli huan se tlayolmelahuani. ");
INSERT INTO nheNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Huan teipa ajsic nopa tonal para nopa israelita ilhuitl tlen itoca Pentecostés. Huan nochi tlaneltocani mosentilijtoyaj san sejco. ");
INSERT INTO nheNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Huan nimantzi nochi quicajque tlen elqui queja se tlatomonilotl tlen hualajqui tlen elhuicac. Elqui queja se ajacatl tlen tlapitzqui tlahuel chicahuac. Huan chicahuac caquistic calijtic campa mosehuijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Huan monexti tlen elqui queja miyac piltlitzitzi tlen moxejxelojqui huan quinajsic inintzonpac sesen inijuanti. ");
INSERT INTO nheNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Huan Itonal Toteco calajqui ipan ininyolo nochi nopa tlaneltocani huan quintemiti. Huan pejque camatij ica sequinoc tlamantli tlajtoli tlen ax momachtijtoyaj pampa Itonal Toteco quinmacayaya ichicahualis ma camatica. ");
INSERT INTO nheNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ipan nopa tonali paxalohuayayaj ipan altepetl Jerusalén miyac israelitame tlen quitlepanitaque Toteco. Inijuanti hualajtoyaj tlen nochi tlaltini ipan tlaltepactli. ");
INSERT INTO nheNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Huan quema nochi inijuanti quicajque nopa tlahuelchihuali queja tlatomonilotl, nimantzi mosentilicoj campa itztoyaj nopa tlaneltocani. Huan ax quimatiyayaj tlaque panoc, pampa quicajque sesen nopa tlaneltocani camatiyayaj sesen inintlajtol tlen sesen inintlal campa nopa paxalohuani hualajtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Huan nopa tlacame san quinsentlachilijque huan moilhuijque se ica seyoc: ―Xiquitaca, nochi ni tlacame tlen camatij ehuaj estado Galilea. ");
INSERT INTO nheNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Quejatza hueli tiquincaquij camatij ica sesen totlajtol tlen sesen totlal campa tiejque? ");
INSERT INTO nheNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Tojuanti tihualajtoque campa hueli tlaltini. Itztoque nica tlacame tlen hualahuij: Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia, ");
INSERT INTO nheNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto huan altepetini tlen tlali Libia nechca altepetl Cirene. Nojquiya itztoque nica paxalohuani tlen hualajque nopa hueyi altepetl Roma. Sequin ni tlacame tlen ajsicoj nica itztoque israelitame, huan sequinoc san quiselijtoque nopa israelita tiotlajtoli. ");
INSERT INTO nheNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Nojquiya itztoque tohuaya tlacame tlen hualahuij tlali Creta huan Arabia. Huan nochi tijcaquij ni tlacame tlen camatij sesen totlajtol. Techilhuíaj miyac huejhueyi tlamantli tlen Toteco quichijtoc. ¿Quejatza huelis quimatij totlajtol? ");
INSERT INTO nheNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Huan nochi san quinsentlachiliyayaj huan ax quimatiyayaj tlaque quiijtose. Motlajtlaniyayaj: ―¿Tlaque quinequi quiijtos nochi ya ni tlen ama pano? ");
INSERT INTO nheNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero sequin tlacame nopona quintlaijilhuiyayaj nopa tlaneltocani huan quiijtohuayayaj para quiitoyaj miyac xocomeca atl tlen xococ, huan yeca ihuintitoyaj. ");
INSERT INTO nheNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Huajca Pedro moquetzqui ininhuaya nopa sequinoc majtlactli huan se tlayolmelahuani, huan camatqui chicahuac huan quinilhui nopa tlacame: “Noisraelita icnihua huan nochi imojuanti tlen inpaxalohuaj ipan ni altepetl Jerusalén, xinechtlacaquilica huan xijneltocaca tlen nimechilhuis. ");
INSERT INTO nheNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ni tlacame tlen nohuaya itztoque ax ihuintitoque queja inmoilhuíaj, pampa sanoc las nueve ica ijnaloc. ");
INSERT INTO nheNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pero mochijtoc ama tlen nopa tiocamanalojquetl Joel huejcajquiya quiijcuilo para teipa panos. Yajaya quiijto: ");
INSERT INTO nheNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ipan itlamiya tonali, Toteco quiijtohua, nijtitlanis Notonal ipan nochi tlacame. Niquinmacas imotelpocahua huan imoichpocahua notlajtol para teilhuise tlen panos teipa. Huan nijchihuas para imotelpocahua ma quiitaca tlanextili queja temictli tlen na niquinnextilis, huan nopa huehue tlacame campa imojuanti, niquinnextilis tlamantli ipan temictli. ");
INSERT INTO nheNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Huan ipan nopa tonali nijtlalis Notonal para itztos ipan notequipanojcahua, tlacame huan sihuame, huan inijuanti teilhuise tlajtoli tlen niquinmacas. ");
INSERT INTO nheNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Huan nijchihuas huejhueyi tlamantli ipan elhuicactli. Huan ipan tlaltepactli nijchihuas tlanescayotl. Oncas estli, tlitl huan poctli. ");
INSERT INTO nheNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Tonati tzintlayohuilis huan metztli mocuepas chichiltic queja estli. Nochi ya ni mochihuas, huan teipa ajsis nopa tonal tlen itoca “itonal Toteco” quema sampa hualas Tohueyiteco ipan tlaltepactli. Nelía hueyi huan nelía temajmati elis nopa tonal. ");
INSERT INTO nheNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Huan nochi tlacame tlen quinotzase Tohueyiteco para ma quinmaquixtis, yajaya, quena, quinmaquixtis.’ Quej nopa quiijcuilo nopa tiocamanalojquetl Joel. ");
INSERT INTO nheNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Noisraelita icnihua, xijtlacaquilica tlen nimechilhuía. Toteco Dios quinexti imoixtla nochi imojuanti para yajaya itztoya ihuaya Jesús, nopa Nazaret ejquetl, huan para quipacti tlen quichijqui. Ica Jesús, Toteco quichijqui miyac huejhueyi tlamantli para tlacame ma quisentlachilica huan quichijqui miyac tlanescayotl huan miyac chicahualnescayotl, queja ya inquimatij. ");
INSERT INTO nheNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Huan imojuanti inquichijque sesen tlamantli tlen Toteco Dios ya quitlalijtoya huan ya quimatqui para inquichihuasquíaj. Inquiitzquijque Jesús huan inquitemactilijque ica ax cuajcualme para ma quimictica, huan inijuanti quicuamapeloltijque. ");
INSERT INTO nheNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero Toteco Dios quiyoliti. Quena, quitlamilti nopa tlaijiyohuilistli tlen miquistli pampa miquistli ax quipixqui chicahualistli para quipixtos Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nopa hueyi tlanahuatijquetl David huejcajquiya quiijcuilo tlen Jesús quema quiijto: ‘Toteco, mojmostla nimitzita noixteno. Ta tiitztoc nohuaya campa nonejmatl para axaca huelis nechmajmatis. ");
INSERT INTO nheNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Huajca nelía niyolpaqui huan chicahuac nimitzpaquilismacas ica nocamac. Huan quema nimiquis, ica paquilistli notlacayo mitzchiyas. ");
INSERT INTO nheNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Pampa ax nechtlahuelcahuas campa mijcatzitzi, niyon ax tijcahuas ma palani itlacayo yajaya tlen moaxca tlen tlatzejtzeloltic. ");
INSERT INTO nheNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Tinechnextilijtoc nopa ojtli tlen quipiya yolistli tlen yancuic, huan tlahuel miyac paquilistli tinechmacas quema niajsiti nopona moixtla.’ Quej nopa ijcuilijtoc ipan itlajtol Toteco.” Huan Pedro quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Noicnihua, nimechilhuía tlen xitlahuac. Tohuejcapan tata David mijqui huan quitlalijque ipan tlacacahuaya huan nopa tlacacahuaya noja eltoc nica nechca hasta ama. Huajca David ax camatiyaya tlen ya iselti. ");
INSERT INTO nheNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero David nelía eliyaya se tiocamanalojquetl tlen camatqui tlen panos teipa. Huan David quimatiyaya para Toteco tlatestigojquetzqui huan quicajqui itlajtol para se iteipa ixhui elisquía Cristo ica itlacayo queja se tlacatl. Huan nopa Cristo quipiyasquía tlanahuatili ica israelitame huan mosehuis para tlanahuatis campa David mosehuiyaya huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Huajca David huejcajquiya quiitayaya para nochi ya ni panosquía teipa huan yeca quiijcuilo queja Toteco Dios quiyolitisquía Cristo. Quiijto Toteco ax quitlahuelcahuasquía ialma Cristo campa mijcatzitzi, huan ax quicahuilisquía para palanis itlacayo. ");
INSERT INTO nheNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Huajca Toteco Dios quiyoliti Jesús, huan nochi tojuanti tiquitaque quema ya moyolcuitoya huan huelis timechilhuise tlen melahuac panoc. ");
INSERT INTO nheNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Huan Jesús ama mosehuijtoc nepa elhuicac ipan inejmatl Toteco campa quipiya nopa tlanahuatili tlen más hueyi. Huan queja ya quitencahuilijtoya, Itata quimacac Jesús Itonal para Jesús ma techmaca tojuanti. Huan Itonal Toteco quichijtoc nochi ni tlamantli tlen inquiitaj huan inquicaquij ama. ");
INSERT INTO nheNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pampa ax David tlen tlejcoc elhuicac, pero elqui David tlen quiijto: ‘Toteco Dios quiilhui noTeco Cristo: Ximosehui nica ipan nonejmatl, ");
INSERT INTO nheNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta quema niquintlanis nochi mocualancaitacahua, huan nimitzmactilis para ipan ma mosehuis moicxihua.’ ");
INSERT INTO nheNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Huajca xijmatica ya ni, nochi inisraelitame, Toteco quitequimacac ni Jesús tlen inquicuamapeloltijque para yajaya elis Tohueyiteco huan yajaya elis nopa Cristo tlen Toteco quiijto techtitlanilisquía.” ");
INSERT INTO nheNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Quema nopa tlacame quicajque nopa tlajtoli, moyolcuesojque ica tlen quichijtoyaj, huan quitlajtlanijque Pedro huan nopa sequinoc tlayolmelahuani: ―Tlacame, ama ¿tlaque monequi tijchihuase? ");
INSERT INTO nheNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Huan Pedro quinnanquili: ―Ximoyolcuepaca huan xijcahuaca tlajtlacoli huan ximocuaaltica sesen imojuanti ipan itoca Jesucristo, huan Toteco inmechtlajtlacolquixtis huan queja se regalo inmechmacas Itonal tlen tlatzejtzeloltic. ");
INSERT INTO nheNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Toteco quitencajtoc inmechmacas Itonal huan nojquiya quinmacas imoconehua, huan hasta quinmacas tlacame tlen ax israelitame tlen huejca ehuaj. Quinmacas nochi tlacame tlen yajaya quinnotztoc ma elica iaxcahua. ");
INSERT INTO nheNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Huan ica miyac más tlajtoli Pedro quinilhui nopa tlacame tlen Jesús huan quinyolchicajqui ma quiselica, quinilhui: ―Ximomaquixtica tlen nopa tlatzacuiltilistli tlen quinajsis ni ax cuajcualme tlen ama itztoque. ");
INSERT INTO nheNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Huajca miyac tlen nopa tlacame quineltocaque tlen Pedro quinilhui, huan yajque mocuaaltitoj. Huan ipan nopa tonal nechca eyi mil más tlacame quineltocaque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Huan mojmostla nochi nopa tlaneltocani quitlacaquiliyayaj nochi tlen nopa tlayolmelahuani quinmachtiyayaj huan nochi moilhuiyayaj san se tlamantli. Huan san sejco nopa tlaneltocani momaijtohuayayaj huan quitlajcotlapanayayaj nopa pantzi para quiilnamiquise queja Jesús mijqui topampa. ");
INSERT INTO nheNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Huan nochi nopa tlaneltocani quisentlachiliyayaj tlen Toteco quichihuayaya. Huan nopa tlayolmelahuani quichihuayayaj miyac tlanescayotl huan huejhueyi tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Huan nochi tlacame tlen quineltocatoyaj Jesús itztoyaj san sejco. Huan momajmacayayaj nochi tlamantli tlen quipixtoyaj sesen inijuanti ica sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Huan pejque quinamacaj inintlal huan tlamantli tlen iniaxca huan quinmajmacaque nopa tomi sequinoc queja quinpoloyaya tlen ica panose. ");
INSERT INTO nheNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Mojmostla nopa tlaneltocani mosentiliyayaj ipan nopa hueyi israelita tiopamitl ica san se ininyolo. Huan ipan caltini quitlajcotlapanayayaj pantzi, huan tlacuayayaj ica iniicnihua ipan Cristo ica miyac paquilistli huan ica san se ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mojmostla quipaquilismacayayaj Toteco, huan nochi sequinoc tlacame quintlepanitayayaj. Huan mojmostla Tohueyiteco quinmaquixtiyaya sequinoc tlacame tlen quintlapejpenijtoya. Huan queja nopa momiyaquilijtiyohuiyayaj tlen itztoyaj ipan itiopa tlen tlaneltocani. ");
INSERT INTO nheNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Se tonal Pedro huan Juan yajque nopa hueyi israelita tiopa a las tres ica tiotlac. Eltoya nopa hora quema tlacame momajtoyaj momaijtohuaj ica Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Huan nepa itztoya se tlacatl metzcototzi tlen queja nopa tlacatqui. Sequin tlacame mojmostla quihuicayayaj huan quisehuiyayaj campa tiopan puerta tlen itoca Yejyectzi huan quintlajtlaniyaya tomi para ica panos tlen inijuanti tlen calaquiyayaj tiopa. ");
INSERT INTO nheNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Huan quema quinitac Pedro huan Juan hualayayaj para calaquise tiopan calijtic, quintlajtlani tomi. ");
INSERT INTO nheNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Huan Pedro huan Juan quitlachilijque nopa tlacatl tlen metzcuachotic huan Pedro quiilhui: ―Xitechtlachili. ");
INSERT INTO nheNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Huan nopa tlacatl quintlachili pampa mochixtoya para ma quimacaca se tomi. ");
INSERT INTO nheNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero Pedro quiilhui: ―Ax nijpiya tomi, niyon plata, niyon oro, pero nimitzmacas tlen nijpixtoc. Ica itoca Jesucristo tlen Nazaret, ximoquetza huan xinejnemi. ");
INSERT INTO nheNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Huan nimantzi Pedro quimaitzqui ica inejmatl huan quitlalanqui. Ipan nopa tlalochtli moxijxitlajqui iicxihua huan iicxi acayo. ");
INSERT INTO nheNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Huan nopa tlacatl tzicuintejqui, huan moquetztiquisqui huan pejqui nejnemi. Calaquito tiopan calijtic ininhuaya, huan nejnentinemiyaya, huan tzicuintiyajqui huan quipaquilismacayaya Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Huan nochi tlacame tlen itztoyaj nepa quiitaque nopa tlacatl nejnemiyaya huan quipaquilismacayaya Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Huan quiixmatque para yajaya tlen mosehuiyaya huan tlajtlaniyaya tomi campa tiopan puerta tlen itoca Yejyectzi. Huajca san quisentlachilijque hasta momajmatijque ica tlen ipantic nopa tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Huan nopa tlacatl tlen eltoya metzcuachotic quinitzquitoya Pedro ihuaya Juan huan ax quinequiyaya quincajtehuas. Huan nochi nopa tlacame motlalojque, huan mosentilijque campa inijuanti huan noja san quisentlachiliyayaj ica tlen panotoya. ");
INSERT INTO nheNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Huan Pedro quinitac nopa miyac tlacame, quinilhui: “Inisraelitame, ¿para tlen inquisentlachilíaj ni tlamantli? ¿Para tlen intechtlachilíaj? ¿Inmoilhuíaj ni tlacatl mochicajqui ica tochicahualis tojuanti o inmoilhuíaj titlatzejtzeloltique pampa tihuelque tijchijque ma nejnemi? ¡Axtle! ");
INSERT INTO nheNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Toteco Dios, yajaya tlen nojquiya ininTeco Abraham, Isaac, Jacob huan nochi sequinoc tohuejcapan tatahua, yajaya tlen quichijtoc para ma monextis ihueyitilis Icone, Jesús, ica tlen quichijtoc nica. Huan elqui san se ni Jesús tlen inisraelitame inquitemactilijque ininmaco tequihuejme. Huan quema Pilato quinequiyaya quimajcahuas Jesús, ax inquinejque. ");
INSERT INTO nheNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Inquihuejcamajcajque Jesús tlen tlatzejtzeloltic huan tlen senquistoc xitlahuac. Huan intlajtlanque ma inmechmajcahuili se temictijquetl. ");
INSERT INTO nheNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Huan inquimictijque Jesús, yajaya tlen hueli temaca yancuic yolistli tlen ax quema tlamis. Pero Toteco Dios quiyoliti quema ya mictoya. Huan tojuanti tiquitaque huan ama timechyolmelahuaj para nelía moyolcuitoc. ");
INSERT INTO nheNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Huan pampa tijneltocaj itoca Jesús, yajaya quimacatoc chicahualistli ma nejnemi ni tlacatl tlen inquiitaj nica huan tlen inquiixmatij. Huan pampa tijneltocaj, ni tlacatl tlen itztoc nica imoixtla ya senquistoc mochicajtoc queja inquiitaj. ");
INSERT INTO nheNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nohuampoyohua, na nijmati quema imojuanti huan imotlanahuatijcahua inquimictijque Jesús, nelía ax inquimatiyayaj tlaque inquichihuayayaj. ");
INSERT INTO nheNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero huejcajquiya Toteco Dios quiijto ica nochi itiocamanalojcahua para Cristo monequi tlaijiyohuis, yeca queja nopa tlaijiyohui, pampa Toteco quichijqui ma pano tlen ijcuilijtoc ipan Itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Huajca ama monequi ximoyolpatlaca huan ximocuepaca ica Toteco Dios. Huan yajaya inmechtlapojpolhuis imotlajtlacolhua huan tlen nepa iixtla inmechtitlanilis yancuic tonali tlen quipiyas miyac paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Huan nojquiya sampa inmechtitlanilis Jesús, nopa Cristo tlen huejcajquiya inmechyolmelajque para hualasquía. ");
INSERT INTO nheNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero ipan ni tonali monequi Jesucristo itztos nepa elhuicac hasta quema Toteco yancuic quicualtlalis nochi tlamantli queja quinilhui itiocamanalojcahua tlen tlatzejtzeloltique ma quiijcuiloca huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Eltoc queja Moisés quinilhui tohuejcapan tatahua: ‘Toteco quitlalanas se tiocamanalojquetl campa imojuanti. Yajaya elis se israelita tlen Toteco quitlapejpenis huan quitequimacas queja nechtlapejpeni na niMoisés huan nechtequimacac. Huan monequi inquitlacaquilise cuali nochi tlen yajaya inmechilhuis. ");
INSERT INTO nheNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Huan nochi tlen ax quitoquilíaj itlajtol nopa tiocamanalojquetl, Toteco quiniyocaquixtis tlen itlacajhua huan quintlamiltis.’ ");
INSERT INTO nheNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Huan nochi tiocamanalohuani tlen teyolmelajque itlajtol Toteco tlen huejcajquiya quema Samuel itztoya huan hasta teipa, quiijtojque tlaque panosquía ipan ni tonali. ");
INSERT INTO nheNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Huan nelía inininteipa ixhuihua nopa tiocamanalohuani. Huan quema Toteco quinmacac itlajtol ica imohuejcapan tatahua eltoya para imojuanti nojquiya. Pampa Toteco quiilhui Abraham: ‘Na niquintiochihuas nochi tlacame ipan ni tlaltepactli ica moteipa ixhui.’ ");
INSERT INTO nheNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Huajca quema Toteco quiyoliti Icone, Jesús, quititlanqui achtohui para inisraelitame. Inmechtitlanili para Jesús ma inmechtiochihuas huan ma inmechchihua ximoyolcuepaca huan xijcajtehuaca imotlajtlacolhua.” ");
INSERT INTO nheNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro huan Juan noja quincamahuiyayaj nopa tlacame, huan hualajque sequin totajtzitzi, huan nopa tlayacanquetl tlen nopa soldados tlen quimocuitlahuijque nopa israelita tiopamitl huan sequin saduceos. ");
INSERT INTO nheNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Inijuanti cualaniyayaj pampa Pedro huan Juan quinmachtiyayaj tlacame huan quinilhuiyayaj para tlacame tlen mictoque sampa moyolcuise pampa Jesús moyolcuic. ");
INSERT INTO nheNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Huajca quinitzquijque Pedro huan Juan huan quintzajque hasta seyoc tonal pampa ya tzintlayohuatoya. ");
INSERT INTO nheNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero miyac tlen quitlacaquilijtoyaj tlen Pedro quincamahuiyaya, quineltocaque. Huajca ica inijuanti, nopa tlaneltocani momiyaquilijtoyaj hasta san tlaca tlaneltocani mochijque macuili mil. ");
INSERT INTO nheNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Huan tonili mosentilijque nepa altepetl Jerusalén nopa israelita tequihuejme, ininhuaya huehue tlacame huan nopa tlamachtiani tlen itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nojquiya itztoyaj nepa Anás, nopa hueyi totajtzi, huan Caifás, Juan, Alejandro huan nochi ininchampoyohua nopa tlayacanca totajtzitzi. ");
INSERT INTO nheNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Huan quinquetzque Pedro huan Juan tlatlajco inijuanti huan quintlajtlanijque: ―¿Ajqueya inmechmacatoc chicahualistli para inquichicajque ni tlacatl metzcuachotic? ¿Ica ajqueya itequihuejcayo inquichijtoque ni tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Huajca Pedro temitoc ica Itonal Toteco, quinilhui: ―Tequihuejme huan huehue tlacame tlen israelitame, ");
INSERT INTO nheNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ama innechtlajtlaníaj ica nopa tlamantli cuali tlen tijchihuilijtoque ni tlacatl tlen mococohuayaya. Inquinequij inquimatise quejatza mochicajqui. ");
INSERT INTO nheNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Huajca nimechilhuis xitlahuac para ma quimatica nochi tlacame tlen tlali Israel. Ni tlacatl tlen itztoc nica imohuaya mochicajtoc ipan itoca Jesucristo tlen ejqui altepetl Nazaret. Yajaya tlen inquicuamapeloltijque, pero Toteco quiyoliti quema ya mictoya. ");
INSERT INTO nheNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesús yajaya nopa hueyi tetl tlen incalchihuani ax inquinejque inquitequihuise ipan imochaj. Pero teipa yajaya elqui tlen senquistoc cuali para yas calnacastla huan ipan quiquetzase nopa cali tlen Toteco quichihua. Huan ama imoixtla Toteco quimacatoc Jesús nopa tlanahuatili tlen más hueyi. ");
INSERT INTO nheNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Axaca seyoc tlen huelis techmaquixtis tlen totlajtlacolhua, pampa Toteco Dios ax quitlalijtoc seyoc tlen quipiya tequihuejcayotl ipan ni tlaltepactli para techmaquixtis, san Jesucristo. ");
INSERT INTO nheNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Huajca nopa tequihuejme quiitaque quejatza Pedro huan Juan moneltlaliyayaj para camatise ica chicahualistli iniixtla nochi tlen itztoyaj nepa huan quimatque ax momachtijtoyaj, huan san eliyayaj tlacame teicneltzitzi; huajca san quinsentlachilijque. Huan momacaque cuenta para inijuanti itztoyaj tlacame tlen nejnentoyaj ihuaya Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nojquiya nopa tequihuejme quiitaque moquetzayaya nepa nopa tlacatl tlen mochicajtoya, huajca yeca ax huelque quinteilhuíaj. ");
INSERT INTO nheNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pero quinnahuatijque Pedro huan Juan ma quisaca calteno ipan nopa tlasentilistli para se tlalochtli huan nopa tequihuejme pejque monajnanquilíaj. ");
INSERT INTO nheNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Quiijtohuayayaj: ―¿Tlaque tijchihuase ica ni tlacame? Nochi tlen ehuaj ni altepetl Jerusalén quimatij quichijtoque se hueyi chicahualnescayotl huan ax hueli tiquijtohuaj para ax neli mochicajtoc nopa tlacatl. ");
INSERT INTO nheNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero para ma ayoc momahuas ni tlamantli, ma tiquinmajmatica para ma ayoc aca quiilhuica tlen Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Huajca nopa tequihuejme sampa quinnotzque Pedro huan Juan huan quinnahuatijque ma ayoc camatica tlen itequihuejcayo Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero Pedro huan Juan quinnanquilijque: ―Ximoyolilhuica intla cuali para timechneltocase o intla achi más cuali tijneltocase Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Pero para tojuanti ax tihuelij tijcahuase tiquinpohuilise tlacame tlen tiquitztoque huan tlen tijcactoque quema Jesús itztoya tohuaya. ");
INSERT INTO nheNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Huajca nopa tequihuejme sampa quintemajmatijque Pedro huan Juan ica tlen huelis quinchihuilise huan quinmajcajque ma yaca. Ax huelque quintlatzacuiltijque, pampa nochi tlacame quipaquilismacayayaj Toteco Dios ica tlen quichijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Huan nopa tlacatl tlen mochicajqui quipixtoya pano cuarenta xihuitl. ");
INSERT INTO nheNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Huan nopa tlasentilistli quinmajcajque Pedro huan Juan, huan inijuanti yajque campa itztoyaj nopa sequinoc tlaneltocani. Huan quinpohuilitoj nochi tlen quinilhuijtoyaj nopa tlayacanca totajtzitzi huan nopa huehue tlacame tlen israelitame. ");
INSERT INTO nheNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Huan quema nopa tlaneltocani quicajque tlen quiijtojque, nochi san sejco momaijtojque ica Toteco Dios huan quiilhuijque: “Toteco, ta nelía tijchijchijqui elhuicactli, huan tlaltepactli, huan nochi hueyi atl huan nochi tlamantli tlen onca. ");
INSERT INTO nheNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ta, ica Motonal, ticamatqui huejcajquiya ica tohuejcapan tata David tlen elqui motequipanojca huan tiquilhui tlen ma quiijcuilo huan yeca yajaya quiijcuilo: ‘San tlapic motlalanase tlacame ipan nochi altepetini. San tlapic moilhuise tlen ax quema huelis quichihuase. ");
INSERT INTO nheNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Huejhueyi tlanahuatiani tlen ni tlaltepactli mocualanise, huan tequihuejme ipan altepetini mosentilise para motehuise ica Toteco Dios huan ica Cristo tlen yajaya quitlapejpenijtoc.’ ");
INSERT INTO nheNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Huan panotoc ipan ni tonali nopa tlamantli tlen huejcajquiya quiijto David. Pampa nelía amanoc mosentilijque Herodes, Poncio Pilato, israelitame huan tlen ax israelitame huan cualanque ica mocone Jesús tlen tlatzejtzeloltic tlen ta, Toteco, tijtzonalti huan tijtequimacac queja totemaquixtijca. ");
INSERT INTO nheNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Huan quichihuilijque mocone Jesús nochi tlen huejcajquiya ta tiquijtojtoya para teipa quichihuilisquíaj. ");
INSERT INTO nheNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Huan ama, Toteco, xijcaqui tlen nopa tequihuejme quiijtohuaj para techmajmatise huan xitechmaca fuerza timotlatequipanojcahua para ma ax timajmahuica ticamatise motlajtol. ");
INSERT INTO nheNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Huan nojquiya, Toteco, ica mochicahualis huan ica itequihuejcayo mocone Jesús tlen tlatzejtzeloltic, xiquinchicahua cocoyani, huan xijchihua tlanescayotl huan chicahualnescayotl.” ");
INSERT INTO nheNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Huan quema Pedro huan Juan tlanque momaijtohuaj, mojmolini nopa cali campa mosentilijtoyaj. Huan Itonal Toteco quinajsic nochi inijuanti huan quintemiti. Huan achi más moneltlalijque teyolmelahuase itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Huan nochi nopa miyac tlacame tlen quineltocatoyaj Jesús quipiyayayaj san se ininyolo huan san se inintlalnamiquilis. Axaca quiitayaya para iaxca nochi tlamantli tlen quipiyayayaj achtohuiya. Pero moxejxelhuiliyayaj nochi tlamantli tlen iniaxca ica sequinoc. ");
INSERT INTO nheNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Huan ica hueyi chicahualistli nopa tlayolmelahuani teilhuiyayaj para quiitztoyaj para nelía moyolcuic Tohueyiteco Jesús. Huan Toteco tlahuel miyac quintiochihuayaya nochi nopa tlaneltocani pampa nelía quipixqui hueyi iyolo ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Huan ayoc aca quipolohuayaya tlen ica panose. Pampa nochi tlen quipixtoyaj inintlal o caltini quinnamacayayaj, ");
INSERT INTO nheNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","huan quinmacayayaj nopa tomi nopa tlayolmelahuani. Huan inijuanti quinxejxelhuiliyayaj nochi tlaneltocani queja tlen quinpolohuayaya sesen inijuanti para quipiyase ajsitoc tlen ica panose. ");
INSERT INTO nheNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Huan itztoya se tlacatl tlen itoca eliyaya José, tlen ejqui nepa tlali Chipre. Yajaya elqui se iteipa ixhui nopa totajtzi Leví tlen huejcajquiya. Huan nopa tlayolmelahuani quitocajtlalijque nojquiya Bernabé, tlen quiijtosnequi “tlayoltlalijquetl”. ");
INSERT INTO nheNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Huan José quinamacac se tlali tlen quipixtoya huan quihualicac nochi nopa tomi huan quinmacac nopa tlayolmelahuani. ");
INSERT INTO nheNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero itztoya seyoc tlacatl tlen itoca eliyaya Ananías huan isihua itoca Safira tlen nojquiya quinamacaque se tlali. ");
INSERT INTO nheNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Huan Ananías quiajcojqui achi nopa tomi para inijuanti, huan quihuicac tlen mocajqui huan quinmacac nopa tlayolmelahuani queja eltosquía nochi nopa tomi. Huan isihua quimatqui nochi tlen quichijqui. ");
INSERT INTO nheNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Huajca Pedro quiilhui: ―Ananías, ¿para tlen tijcahuilijtoc Axcualtlacatl ma quitemiti moyolo ica itlalnamiquilis huan tiistlacatitoc ica Itonal Toteco? Ticajcojqui achi tomi tlen mitztlaxtlahuijque para momilcahual. ");
INSERT INTO nheNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Huan ¿para tlen timoilhui tijchihuas ya ni? Achtohui nopa tlali eltoya moaxca. Huan quema tijnamacac, nopa tomi nojquiya eltoya moaxca ta. ¿Para tlen timoilhuijtoc para tiistlacatis? Ax san titechistlacahuijtoc titlacame, pero ta tiquistlacahuijtoc Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Huan quema quicajqui Ananías tlen Pedro quiilhui, huetzqui huan mijqui. Huan nelía momajmatijque nochi tlen quimatque tlen ipantic. ");
INSERT INTO nheNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Huan hualajque se ome telpoca tlacame tlen quiquimilojque nopa mijcatzi ica se yoyomitl, huan quiquixtijque huan quitlalpachotoj. ");
INSERT INTO nheNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Teipa panoc eyi hora huan hualajqui isihua Ananías. Yajaya ax quimatiyaya tlaque ipantitoya ihuehue. ");
INSERT INTO nheNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Huan Pedro quitlajtlani: ―Xinechilhui, ¿inquinamacaque imotlal queja intechilhuijque ipati? Huan nopa sihuatl quiilhui: ―Quena, queja nopa tijnamacaque. ");
INSERT INTO nheNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Huajca Pedro quiilhui: ―¿Quejatza inmoyolilhuijque inquiyejyecose Itonal Toteco para inquiitase intla inmechtlatzacuiltisquía? Xiquita, amantzi nepa hualahuij ne tlacame tlen quitlalpachotoj mohuehue. Huan inijuanti mitzhuicase nojquiya. ");
INSERT INTO nheNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Huan nimantzi, huetzqui Safira huan mijqui iixpa Pedro. Huan nopa telpoca tlacame sampa calajque huan quiitaque ya mictoya, huajca quihuicaque quitlalpachotoj nechca ihuehue. ");
INSERT INTO nheNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Huan nelía momajmatijque nochi nopa tlaneltocani ipan nopa tiopamitl. Huan nojquiya momajmatijque nochi sequinoc tlacame tlen quimatque tlen panoc. ");
INSERT INTO nheNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Huan nopa tlayolmelahuani quichijque miyac tlanescayotl huan chicahualnescayotl iniixtla tlacame. Huan nochi tlaneltocani momatque mojmostla mosentilíaj campa nopa israelita tiopamitl icalmapa tlen itoca Portal tlen Salomón. ");
INSERT INTO nheNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Huan nochi tlacame quintlepanitayayaj miyac, pero momajmatiyayaj mosentilise ininhuaya. ");
INSERT INTO nheNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Huan tlahuel momiyaquilijtinemiyayaj nopa tlaneltocani pampa tlahuel miyac tlacame huan sihuame quineltocayayaj Tohueyiteco. ");
INSERT INTO nheNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Huan tlacame quinhuicayayaj inincocoxcahua ojtipa huan quintecayayaj ipan tlapechtli o ipan petlatl para quema panosquía Pedro, ma quinajsisquía ica iecahuil. Huan san ica nopa mochicahuasquíaj. ");
INSERT INTO nheNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Nojquiya miyac tlacame tlen ejque pilaltepetzitzi tlen nechcatzi ajsiyayaj altepetl Jerusalén, quinhualicayayaj cocoyani, huan tlacame tlen quinpiyayayaj iajacahua Axcualtlacatl huan nochi mochicajque. ");
INSERT INTO nheNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Huajca nopa hueyi totajtzi huan nochi ihuampoyohua tlen eliyayaj saduceos pejque quinchicoitaj nopa tlayolmelahuani. ");
INSERT INTO nheNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Huan quinitzquijque huan quintzajque ipan nopa hueyi tlatzactli ipan nopa altepetl. ");
INSERT INTO nheNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Pero Tohueyiteco quititlanqui se ielhuicac ejca Toteco ica tlayohua huan quitlapo tepos puertas ipan nopa tlatzactli. Huan quinquixti nopa tlayolmelahuani huan quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Xiyaca ximoquetzatij ipan nopa hueyi israelita tiopamitl huan xiquinilhuica tlacame quejatza huelis quipantise yancuic yolistli ipan Jesucristo.” ");
INSERT INTO nheNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Huan nopa tlayolmelahuani quicajque itlajtol huan yajque ipan nopa hueyi tiopamitl quema tlanestihualayaya, huan pejque tlamachtíaj. Huan ica ijnaloc ajsico nopa hueyi totajtzi huan nochi tlen itztoyaj ihuaya, huan quinnotzque ma mosentilica ipan nopa tlasentilistli tlen tequihuejme tlen quipixque más tequihuejcayotl ininhuaya nopa huehue tlacame tlen israelitame. Huan tlanahuatijque ma quincuitij nopa tlayolmelahuani campa tlatzactli. ");
INSERT INTO nheNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Huan yajque nopa soldados tlen quimocuitlahuijque tiopamitl, pero axaca quipantijque. Huajca mocuepque, ");
INSERT INTO nheNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","huan quinilhuicoj: ―Tijpantitoj cuali tzactoc nopa tlatzactli, huan nopa soldados moquetztoyaj tlamocuitlahuijtoyaj campa tepos puerta, pero tijtlapojque huan niyon se ax tijpantijque. ");
INSERT INTO nheNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Huajca quema quicajque ni tlajtoli, nopa hueyi totajtzi huan nopa tlayacanquetl tlen soldados tlen tiopa ax quimatiyayaj tlaque quiijtose. Huan moyolilhuiyayaj tlaque panos teipa ica ni tlamantli. ");
INSERT INTO nheNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Huan nimantzi ajsico se tlacatl tlen quinyolmelajqui: ―Xiquitaca nopa tlacame tlen inquintzactoyaj, amantzi itztoque ipan hueyi tiopamitl, quinmachtíaj tlacame. ");
INSERT INTO nheNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Huajca nopa tlayacanquetl tlen soldados yajqui ininhuaya isoldados tlen quimocuitlahuijque nopa hueyi israelita tiopamitl huan quinhualicaque nopa tlayolmelahuani. Pero ax quinmaquilijque pampa quinimacasiyayaj nopa miyac tlacame tlen mosentilijtoyaj nepa. Moilhuijque para huelis quintepachosquíaj. ");
INSERT INTO nheNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Huan quinhuicaque nopa tlayolmelahuani huan quinnextijque iniixtla nopa hueyi tlasentilistli tlen tequihuejme. Huan teipa nopa hueyi totajtzi quinilhui: ");
INSERT INTO nheNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","―Tojuanti timechnahuatijque ayoc xitlamachtica tlen Jesús. Pero ama imotlamachtil momajquiya ipan nochi ni altepetl Jerusalén. Huan intechcahuilíaj para tijmictijque Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Huajca Pedro ininhuaya nopa tlayolmelahuani quinnanquilijque: ―Monequi tijneltoquilise Toteco Dios achtohui huan ax tlacame. ");
INSERT INTO nheNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Pampa Toteco tlen tohuejcapan tatahua quineltocaque quiyoliti Jesús tlen inquimictijque quema inquicuamapeloltijque, ");
INSERT INTO nheNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Huan Toteco Dios quihueyitlalijtoc Jesús huan quisehuijtoc nepa inejmatl campa más onca tlatlepanitacayotl pampa yajaya Tohueyiteco huan Totemaquixtijca. Toteco quichijqui ni para inisraelitame huelis inmoyolcuepase huan inquipantise tlapojpolhuili ipampa imotlajtlacolhua. ");
INSERT INTO nheNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Huan tiquinilhuíaj tlacame para melahuac nochi ni tlamantli tlen tiquitztoque huan nojquiya Itonal Toteco teyolmelahua para melahuac. Huan Toteco Dios quinmacas Itonal nochi tlacame tlen quichihuaj itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Huan quema quicajque tlen Pedro quiijto, tlahuel cualanque, huan quinequiyayaj quinmictise nopa tlayolmelahuani. ");
INSERT INTO nheNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero moquetzqui se fariseo tlen itoca eliyaya Gamaliel ipan nopa hueyi tlasentilistli tlen tequihuejme. Yajaya eltoya se tlamachtijquetl tlen más ajsitoc momachtijtoya itlanahuatil Moisés tlen nochi sequinoc; huan nochi tlacame quitlepanitayayaj miyac. Huan Gamaliel quinnahuati ma quisaca nopa tlayolmelahuani se tlalochtli, ");
INSERT INTO nheNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","huan pejqui quinilhuía nopa tequihuejme: ―Noisraelita icnihua, ximotlachilica ica tlen inquinchihuilise ni tlacame. ");
INSERT INTO nheNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Inquiilnamiquij ya quipiya tonali itztoya se tlacatl Teudas tlen quiijtohuayaya quipixtoya tequihuejcayotl, huan se 400 tlacame mosentilijque ihuaya. Huan sequinoc quimictijque Teudas, huan nopa tlacame tlen quitoquiliyayaj mosemanque, huan nochi itequi tlantiyajqui. ");
INSERT INTO nheNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Teipa ipan nopa tonali quema quichihuayayaj nopa censo, motlalanqui se tlacatl Judas tlen ejqui estado Galilea, huan miyac tlacame quitoquiliyayaj. Pero nojquiya sequinoc quimictijque Judas, huan nochi tlen quitoquiliyayaj mosemanque. ");
INSERT INTO nheNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Yeca nimechilhuía, xiquincahuaca ni tlacame huan amo xiquincuatotonica más, pampa intla tlacame quinmacatoque inintlamachtil, nimantzi tlantiyas. ");
INSERT INTO nheNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero intla Toteco quinnahuatía huan quinmacatoc inintlamachtil, ax huelis inquitlamiltise inintequi. Huan intla ni eli itequi Toteco, ximotlachilica imojuanti para amo ximotehuica ihuaya Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Huan nochi tequihuejme quitlacaquilijque tlen quiijto. Huan quinnotzque nopa tlayolmelahuani huan quinhuijhuitejque huan quintemajmatijque chicahuac para ma ayoc más camatica tlen Jesús. Huan teipa quinmajcajque ma yaca. ");
INSERT INTO nheNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Huan nopa tlayolmelahuani quisque ipan nopa hueyi tlasentilistli tlen tequihuejme yolpactoque pampa Toteco quincahuilijtoya tlaijiyohuise ipampa quineltocaj itequihuejcayo Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Huan mojmostla nopa tlayolmelahuani tlamachtijtinenque ipan nopa hueyi israelita tiopamitl huan ipan caltini para Jesús itztoya nopa Cristo tlen Toteco Dios quiijto huejcajquiya para quititlanisquía. ");
INSERT INTO nheNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ipan nopa tonali momiyaquilijtiyohuiyayaj nopa tlaneltocani huan achi mocualanijque nopa israelitame tlen camatiyayaj griego ica ne sequinoc israelitame tlen camatiyayaj hebreo. Quiijtohuayayaj nopa cahual toahuime tlen camatij griego ax quiseliyayaj ajsitoc tlen ica panose queja cahual toahuime tlen israelitame tlen camatij hebreo quema nopa tlaneltocani quinmajmacayayaj tlacualistli mojmostla. ");
INSERT INTO nheNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Huajca nopa majtlactli huan ome tlayolmelahuani mosentilijque ininhuaya nochi tlaneltocani huan quinilhuijque: ―Ax cuali tijtlahuelcahuase titepohuilise Itlajtol Toteco san para tiquintlamacase toicnihua. ");
INSERT INTO nheNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Huajca, noicnihua, xiquintlapejpenica chicome toicnihua tlen nochi quintlepanitaj. Xiquintlapejpenica tlacame tlen temitoque ica Itonal Toteco huan tlen quipiyaj cuali inintlalnamiquilis. Huan tiquintlalise ma quiyacanaca ni tequitl para temajmacase tlacualistli. ");
INSERT INTO nheNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Huan tojuanti titlayolmelahuani, noja timomaijtose ica Tohueyiteco huan titlamachtise Itlajtol. ");
INSERT INTO nheNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Huan nochi nopa tlaneltocani quinpacti tlen quiijtojque. Huan quitlapejpenijque Esteban tlen chicahuac motemachiyaya ipan Tohueyiteco huan itztoya temitoc ica Itonal. Nojquiya quintlapejpenijque Felipe, Prócoro, Nicanor, Timón huan Parmenas. Huan nojquiya quitlapejpenijque Nicolás se tlacatl tlen ehuayaya altepetl Antioquía huan yajaya ax eliyaya israelita. Achtohui quiselijtoya inintiotlajtol israelitame huan ama quineltocatoya Jesucristo. ");
INSERT INTO nheNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Huan nopa tlaneltocani quinnextijque nopa chicome iniixtla nopa tlayolmelahuani. Huan nopa tlayolmelahuani momaijtojque ipan Toteco huan quitlalijque ininma ininpani para ma quipehualtica inintequi. ");
INSERT INTO nheNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Huan más momoyajqui itlajtol Toteco huan tlahuel más momiyaquilijtiyohuiyayaj tlaneltocani nepa ipan altepetl Jerusalén. Huan nojquiya miyac israelita totajtzitzi quineltocaque Jesucristo. ");
INSERT INTO nheNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Tlahuel hueyi iyolo Toteco ica Esteban huan quimacac miyac chicahualistli para quichihuas chicahualnescayotl huan tlanescayotl iniixtla tlacame. ");
INSERT INTO nheNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero se tonal sequin tlacame tlen nopa israelita tiopamitl tlen inintoca eliyaya Tlatequipanohuani Tlen Malacantoque monechcahuijque campa Esteban huan pejque quinajnanquilíaj. Inijuanti eliyayaj israelitame tlen ehuayayaj altepetini Cirene, Alejandría, Cilicia huan campa hueli ipan tlali Asia. ");
INSERT INTO nheNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Huan Esteban camatiyaya ica miyac tlalnamiquilistli tlen Itonal Toteco quimacayaya huan inijuanti ax huelque quitlanij. ");
INSERT INTO nheNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Huajca quintemojque tlacame huan quintlaxtlahuijque para ma quiistlacahuica. Huan nopa istlacatini quiijtojque para quicactoyaj quema Esteban quintlaijilhuijtoya Moisés huan Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Huan quinajcomanque nopa israelitame, huan nopa huehue tlacame huan tlamachtiani tlen itlanahuatil Moisés. Huan quiitzquijque Esteban huan quihuicaque iniixtla nopa hueyi tlasentilistli tlen israelita tequihuejme. ");
INSERT INTO nheNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Huan quintlalijque nopa istlacatini para ma quiteilhuica huan quiijtojque: ―Ni tlacatl Esteban ajachica quitlaijilhuía ni hueyi tiopamitl huan itlanahuatil Moisés. ");
INSERT INTO nheNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nojquiya tijcactoque quema Esteban quiijto Jesús tlen ejqui altepetl Nazaret quixolehuasquía ni hueyi tiopamitl huan quipatlasquía nopa tlamachtilistli tlen Moisés techcahuilijtejqui huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Huan ipan nopa tlalochtli nochi nopa tlacame ipan nopa tlasentilistli tlen tequihuejme quisentlachilijque ixayac Esteban, huan quiitaque nesiyaya queja ixayac se se elhuicac ejquetl. ");
INSERT INTO nheNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Huajca camatqui nopa hueyi totajtzi huan quitlajtlani Esteban: ―¿Nelía tiquijtojtoc nochi ni tlamantli? ");
INSERT INTO nheNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Huan Esteban quinanquili: “Noicnihua huan notatahua, xinechtlacaquilica. Toteco Dios, yajaya tlen quipiya ihueyitilis, monexti huejcajquiya iixtla tohuejcapan tata Abraham quema itztoya ipan tlali Mesopotamia, quema aya yajtoya altepetl Harán. ");
INSERT INTO nheNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Huan Toteco quiilhui Abraham: ‘Xiquisa ipan ni motlal huan xiquincajtehua mochampoyohua. Xiya ipan nopa tlali campa nimitznextilis para tiitztos.’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Huajca Abraham quisqui ipan nopa tlali tlen itoca Caldea, huan yajqui altepetl Harán. Huan nepa mijqui itata, huan Toteco Dios quihualicac Abraham hasta ni tlali campa tiitztoque ama. ");
INSERT INTO nheNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Huan Toteco ax quimacac Abraham se tlali para iaxca, niyon se pilquentzi. Pero Toteco quitencahuili quinmacasquía ni tlali iteipa ixhuihua Abraham yonque Abraham noja aya quipiyayaya niyon se icone. ");
INSERT INTO nheNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Huan Toteco nojquiya quiilhui Abraham para iteipa ixhuihua itztose ipan sejyoc tlali para nahui ciento xihuitl huan ax quema huelis mochihuase queja se tlen nepa ehuani. Huan quiijto para tlacame tlen ehuaj nopa tlali quintequihuisquíaj chicahuac queja elisquía tlatequipanohuani tlen iniaxcahua. Huan quiilhui tlen nopona ehuani tlahuel quintlaijiyohuiltise. ");
INSERT INTO nheNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero nojquiya Toteco quiilhui Abraham: ‘Niquintlatzacuiltis tlen ehuaj nopa tlali, huan teipa sampa quisase moteipa ixhuihua tlen nopa tlali huan inijuanti nechhueyichihuaquij nica.’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Huan Toteco Dios quichijqui se tlajtolsencahuali ica Abraham huan quimacac se tlamachtili tlen itoca circuncisión para ma quitequi icuetlaxo ininpiltlacayo nochi ioquichpilhua. Nopa machiyotl quinextis para inijuanti quineltocaj tlen Toteco quintencahuilijtoya. Huajca quema tlacatqui Isaac, icone Abraham, huan quipixtoya chicueyi tonali, quitequili nopa tlanescayotl tlen itoca circuncisión ipan ipiltlacayo. Huan quema Isaac motlacachijqui, tlacatqui icone, Jacob. Huan quema Jacob motlacachijqui, tlacatque majtlactli huan ome iconehua. Huan inijuanti tohuejcapan tatahua nochi tiisraelitame. ");
INSERT INTO nheNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Huan iconehua Jacob quichicoitayayaj José, se iniicni, huan quinnamaquiltijque sequin tlacame tlen quihuicaque tlali Egipto. Pero Toteco Dios itztoya ihuaya José, ");
INSERT INTO nheNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","huan quimanahui quema tlaijiyohuiyaya huan quimacac miyac itlalnamiquilis. Huan Toteco quichijqui para nopa Tlanahuatijquetl Faraón, tlen tlanahuatiyaya ipan nochi nopa tlali Egipto, ma quicualita José. Huan nopa tlanahuatijquetl quitlali José para ma eli gobernador ipan nopa tlali Egipto hasta nojquiya quinnahuati nochi tlen itztoyaj ipan ichaj Faraón. ");
INSERT INTO nheNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Teipa pejqui se hueyi mayantli ipan tlali Egipto huan tlali Canaán, huan nochi tlaijiyohuiyayaj. Huan tohuejcapan tatahua ax huelque quipantijque tlaque quicuase. ");
INSERT INTO nheNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Pero Jacob quicajqui oncayaya tlacualistli ipan tlali Egipto, huan quintitlanqui itelpocahua, inijuanti tlen tohuejcapan tatahua, para ma yaca nopona. Ya nopa elqui quema yajque tlali Egipto nopa achtohui huelta. ");
INSERT INTO nheNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Huan teipa inijuanti sampa yajque ica ompa. Huan José quinilhui para yajaya iniicni huan quinnexti iixtla Tlanahuatijquetl Faraón para yajaya ma quinixmati iicnihua. ");
INSERT INTO nheNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Huan José quinilhui iicnihua ma quinotzatij inintata huan nochi ichampoyohua para ma hualaca tlali Egipto. Huan setenta y cinco tlacame hualajque. ");
INSERT INTO nheNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yeca queja nopa tohuejcapan tata Jacob yajqui huan mocajqui ipan tlali Egipto. Huan teipa Jacob mijqui nepa. Huan nojquiya teipa mijque nepa nochi tohuejcapan tatahua tlen eliyayaj iconehua Jacob. ");
INSERT INTO nheNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Huan teipa nopa israelitame quihuicaque nochi iniomiyo hasta altepetl Siquem. Nepa quintlalijque ipan se mijca tlacajcahuaya tlen eltoya iaxca Abraham pampa quincohuili iconehua Hamor. ");
INSERT INTO nheNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Huan monechcahuiyaya nopa tonali para Toteco quichihuas tlen huejcajquiya quitencahuilijtoya Abraham para quichihuasquía huan quinquixtis nopa tlacame ipan Egipto. Huan nopa israelitame nelía itztoyaj miyaqui pampa momiyaquilijtoyajya tlahuel miyac ipan Egipto. ");
INSERT INTO nheNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Huan pejqui tlanahuatía seyoc tlanahuatijquetl ipan Egipto tlen ax quema quicactoya tlen José pampa ya quipixtoya miyac xihuitl para mijqui José. ");
INSERT INTO nheNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Huan nopa yancuic tlanahuatijquetl quincajcayajqui nopa israelitame tlen eliyayaj tohuejcapan tatahua huan quintlaijiyohuilti miyac. Quinnahuati ma quintlahuelcahuaca ininpiloquichpilhua para ma miquica. ");
INSERT INTO nheNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Huan ipan nopa tonali tlacatqui Moisés tlen quiyolpacti Toteco. Huan inana huan itata quiiscaltijque eyi metztli ipan ininchaj. ");
INSERT INTO nheNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Huan quema inana Moisés monejqui quitlahuelcahuas ioquichpil para ma miqui, iichpoca nopa yancuic tlanahuatijquetl Faraón quipanti huan quihuicac ichaj huan quiiscalti queja icone. ");
INSERT INTO nheNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Yeca Moisés momachti nochi tlalnamiquilistli tlen nopa egipcios quimatiyayaj. Huan Moisés hueliyaya camati cuali huan quipixqui chicahualistli quichihuas miyac tlamantli tequitl. ");
INSERT INTO nheNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Pero quema Moisés quiaxiti 40 xihuitl, quinequiyaya quinpaxaloti iisraelita icnihua. ");
INSERT INTO nheNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Huan quiitac se egipcio tlacatl quihuitequiyaya se tlacatl israelita. Huan Moisés quimanahui nopa israelita huan quimicti nopa tlacatl egipcio. ");
INSERT INTO nheNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Huan Moisés moilhuiyaya para nopa israelitame quimachilisquíaj para Toteco quititlantoya para quinquixtisquía campa tlatequipanohuayayaj san tlapic, pero inijuanti ax quimachilijque. ");
INSERT INTO nheNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Huan tonili Moisés yajqui quinpaxaloto nopa israelitame sampa. Huan quinpantito ome israelita tlacame motehuiyayaj. Huan quinequiyaya quinyoltlalis huan quinilhui: ‘Tlacame, inicnime, ¿para tlen inmotehuíaj?’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Pero nopa tlacatl tlen quimaquiliyaya ihuampo quicuatopejqui Moisés huan quiilhui: ‘¿Ajqueya mitztequimacatoc para xitechnahuatiqui huan xitechtlajtolsencahuaqui? ");
INSERT INTO nheNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Tijnequi tinechmictis queja yalhuaya tijmicti nopa egipcio?’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Huan quema Moisés quicajqui tlen nopa tlacatl quiijto, cholojtejqui tlahuel huejca hasta tlali Madián. Mocajqui ipan nopa tlali queja se sejcoyoc ejquetl, huan mosihuajti huan nepa tlacatque ome iconehua. ");
INSERT INTO nheNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Huan quema Moisés quipixtoya 40 xihuitl ipan tlali Madián, se tonal nejnemiyaya ipan nopa huactoc tlali nechca nopa tepetl tlen itoca Sinaí. Huan monexti se elhuicac ejquetl iixtla ipan ixochiyo se tlitl ipan se xihuitzontli tlen tlatlayaya. ");
INSERT INTO nheNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Huan quema Moisés quiitac, quisentlachili huan monechcahui para cuali quitlachilis. Huan nimantzi quicajqui itos Toteco tlen quiilhui: ");
INSERT INTO nheNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na niininTeco mohuejcapan tatahua. Na niininTeco Abraham, Isaac huan Jacob.’ Huan Moisés pejqui huihuipica pampa nelía momajmati huan ayoc quinejqui quitlachilis. ");
INSERT INTO nheNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Huan Toteco Dios quiilhui: ‘Xijquixti motecac pampa ni tlali campa timoquetztoc tlatzejtzeloltic, pampa nica nojquiya niitztoc. ");
INSERT INTO nheNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Na niquinita queja tlaijiyohuíaj notlacajhua nepa ipan tlali Egipto, huan nijcactoc quema chocaj huan nitemotoc tlen elhuicac para niquinmanahuis. Huajca xiquita, ama nimitztitlanis ipan tlali Egipto para tiquinmaquixtis.’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Huajca Toteco sampa quititlanqui ni Moisés ma yohui Egipto tlen nopa israelitame achtohui ax quinejque quiitase huan quiilhuijtoyaj: ‘¿Ajqueya mitztequimacatoc para xitechnahuati huan xitechtlajtolsencahua?’ Quena, ica ielhuicac ejca Toteco tlen monexti iixtla ipan nopa xihuitzontli, Toteco quititlanqui Moisés ma yohui Egipto, pero ama elqui queja se tlanahuatijquetl huan se tlamanahuijquetl. ");
INSERT INTO nheNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Huan Moisés quichijqui chicahualnescayotl huan tlanescayotl ipan nopa tlali Egipto, huan ipan nopa Hueyi Atl Chichiltic huan ipan nopa huactoc tlali para 40 xihuitl. Huan quinyacanqui nopa israelitame ma quisaca. ");
INSERT INTO nheNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Huan ni Moisés quinilhui nopa israelitame huejcajquiya: ‘Toteco inmechtitlanilis se tiocamanalojquetl queja na nechtitlantoc huan yajaya elis se toisraelita icni.’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Yajaya ni Moisés nojquiya tlen itztoya ipan nopa tlasentilistli tlen tohuejcapan tatahua ipan nopa huactoc tlali campa ax tleno eli. Huan motlajcoquetzqui ica nopa elhuicac ejquetl tlen quicamahui ipan tepetl Sinaí huan tohuejcapan tatahua. Huan Moisés quiseli tlajtoli para ma techpanoltili nochi tojuanti para ma techmaca nemilistli. ");
INSERT INTO nheNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Pero tohuejcapan tatahua ax quinejque quitlacaquilise Moisés huan moilhuijque cuali mocuepasquíaj ipan tlali Egipto. ");
INSERT INTO nheNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Huajca tohuejcapan tatahua quiilhuijque Aarón: ‘Xitechsencahuili totiotzitzi para ma techyacanaca ipan ojtli, pampa tojuanti ax tijmatij tlaque ipantitoc nopa Moisés tlen techquixti ipan tlali Egipto.’ ");
INSERT INTO nheNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Huajca quichijque se tlamantli tlen oro para quihueyichihuase huan quipixqui itlachiyalis queja se pilhuacaxtzi. Huan quimacaque tlacajcahualistli iixtla nopa teteyotl huan quinpacti tlen mosencahuilijtoyaj. ");
INSERT INTO nheNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Huajca Toteco quintlahuelcajqui huan quincahuili ma quinhueyichihuaca nopa sitlalime tlen elhuicactli. Eltoc queja itiocamanalojcahua Toteco quiijcuilojque ipan nopa libro campa Toteco quinilhui: ‘Quema inisraelitame inquinmictiyayaj tlapiyalime, huan intemacayayaj tlacajcahualistli para cuarenta xihuitl ipan nopa huactoc tlali, ax na tlen innechmacayayaj. ");
INSERT INTO nheNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tlen achi más inquiicnelijque elqui imotlaixcopincayo tlen itoca Moloc tlen inquinejnemiltijque imohuaya ipan ipilchaj. Huan inquihuicayayaj se sitlali tlen inmoilhuijque eliyaya iaxca imoteteyo Renfán. Pero san elque tlaixcopincayome tlen inquichijque ica imoma para inquinhueyichihuase. Huajca nimechquixtis ipan imotlal huan nimechcahuati ipan ne seyoc lado altepetl Babilonia.’ ” ");
INSERT INTO nheNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Huan Esteban noja camatiyaya iniixpa nopa tequihuejme huan quinilhui: “Tohuejcapan tatahua quipixtoyaj nopa yoyon tiopamitl tlen quihuicaque ininhuaya ipan nopa huactoc tlali. Quisencajtoyaj nopa tiopamitl senquistoc queja nopa iixcopinca tlen Toteco quinextili Moisés para ma quichihua. ");
INSERT INTO nheNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Huan teipa mijqui Moisés huan tohuejcapan tatahua quiselijque nopa yoyon tiopamitl. Huan inijuanti quihualicaque quema Josué quinyacanqui ma moaxcatica ni tlali. Huan Toteco quintotocac nopa tlacame tlen ax israelitame tlen itztoyaj nica. Huan Toteco quinmacac ni tlali tohuejcapan tatahua. Huan quipixtoyaj nopa yoyon tiopamitl hasta nopa tonali quema tlanahuatiyaya David. ");
INSERT INTO nheNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Huan Toteco quicualitac David, huan David quinejqui quichihuas se hueyi cali para ma ipan itzto Toteco, tlen iDios tohuejcapan tata Jacob. ");
INSERT INTO nheNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero elqui Salomón, icone David, tlen quichijqui nopa cali para Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero tijmatij nelía Toteco Tlen Más Hueyi ax mocahua ipan se tiopamitl tlen tlacame quisencajtoque ica ininma. Eltoc queja quiijto se tiocamanalojquetl tlen huejcajquiya quiijcuilo ni tlajtoli tlen Toteco quiijto: ");
INSERT INTO nheNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Na nijtemitía elhuicac huan tlaltepactli. Ax quema oncas se cali tlen nechaxilis para ipan niitztos pampa ninelhueyi. ¿Quejatza huelis inquichihuase se cali para ipan nimosehuis? ");
INSERT INTO nheNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Na ica noma nijchijqui nochi tlamantli ipan elhuicactli huan tlaltepactli.’ Quej nopa quiijto Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Huan Esteban quinilhui nopa tequihuejme: “¡Inyoltetique! Ipan imoyolo ax inquiixmatij Toteco. Ax inquinequij inquicaquise tlen melahuac. Nochipa inquihuejcamajcahuaj Itonal Toteco. San se inquichihuaj tlen ax cuali queja tohuejcapan tatahua quichijque huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tohuejcapan tatahua quintlaijiyohuiltijque nochi itiocamanalojcahua Toteco. Quinmictijque nopa tiocamanalohuani tlen quinyolmelajque para teipa hualasquía Yajaya Tlen Xitlahuac tlen Toteco techtitlanilisquía. Huan quema nopa Cristo ajsico, inquitemactilijque ica fiero tlacame huan inquimictijque. ");
INSERT INTO nheNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ax inquinequij inquitoquilise itlanahuatil Moisés yonque techmacaque nopa tlanahuatili elhuicac ehuani.” ");
INSERT INTO nheNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Huan quema quicajque nopa tequihuejme tlen Esteban quiijto, tlahuel cualanque hasta motlanhuehuechotzque. ");
INSERT INTO nheNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero Esteban temitoc ica Itonal Toteco, tlachixqui elhuicac. Huan quiitac ihueyitilis Toteco Dios huan quiitac Jesús ijcatoya ica inejmatl Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Huajca Esteban quiijto: ―¡Xijtlachilica! Na niquita tlapojtoc elhuicac huan Jesús tlen Mocuepqui Tlacatl ijcatoc inejmatl Toteco Dios. ");
INSERT INTO nheNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Pero nopa tlacame tzajtzique chicahuac huan monacastzajque para ayoc quicaquise tlen Esteban quiijtohuayaya. Huan nochi motlalojque huan quiitzquijque. ");
INSERT INTO nheNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Huan quihuicaque Esteban altepeteno huan quicuatepachojque. Huan nopa tlacame tlen quiteilhuijtoyaj para ma miqui quicajtejque ininyoyo ica se telpoca tlacatl tlen itoca eliyaya Saulo para ma quimocuitlahui. ");
INSERT INTO nheNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Huan noja quitepachohuayayaj quema Esteban quinotzqui Tohueyiteco huan quiilhui: “Tohueyiteco Jesús, xijseli notonaltzi.” ");
INSERT INTO nheNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Huan teipa Esteban motlancuaquetzqui huan chicahuac quiijto: “Tohueyiteco, xiquintlapojpolhui ni tlajtlacoli tlen nechchihuilíaj.” Huan quema Esteban tlanqui camati, mijqui. ");
INSERT INTO nheNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Huan Saulo quicualitac quema nopa tlacame quimictijque Esteban. Huajca ipan nopa tonal miyac tlacame pejque quintlaijiyohuiltíaj tlen itztoyaj ipan nopa tiopamitl tlen tlaneltocani ipan altepetl Jerusalén. Huajca nopa tlaneltocani mosemantiyajque campa hueli ipan nopa estado Judea huan ipan estado Samaria. Huan mocajque ipan altepetl Jerusalén san nopa tlayolmelahuani. ");
INSERT INTO nheNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Huan sequin tlacame tlen quiicnelíaj Toteco quitlalpachojque Esteban huan chocaque miyac pampa mijqui. ");
INSERT INTO nheNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Pero Saulo pejqui chicahuac quintlaijiyohuiltía nochi tlaneltocani ipan itiopa Toteco. Yajaya calaquiyaya ipan sesen cali campa mosentiliyayaj huan quinquixtiyaya. Huan quinhuahuatatzayaya tlacame huan sihuame huan quintzacuayaya. ");
INSERT INTO nheNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Huan nopa tlaneltocani tlen mosejsemantoyaj tlen Jerusalén, yajque campa hueli altepetini huan teilhuijque itlajtol Toteco huan quejatza Jesús temaquixtía. ");
INSERT INTO nheNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Huan Felipe yajqui altepetl Samaria huan quincamahui miyac tlacame para Jesús itztoya nopa Cristo tlen Toteco quititlantoya. ");
INSERT INTO nheNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Huan Felipe tlamachtiyaya huan quichihuayaya miyac huejhueyi tlanescayotl. Huan miyac tlacame mosentiliyayaj para quicaquise tlen quiijtohuayaya huan quitlachilise tlen quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Huan quinchicahuayaya miyac tlen quinpixtoyaj iajacahua Axcualtlacatl. Huan nopa ajacame tzajtziyayaj chicahuac quema quisayayaj ipan inintlacayo tlacame. Huan quinchicajqui miyac tlacame tlen huajhuapahuixtoyaj huan tlen metzcuachotique. ");
INSERT INTO nheNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Huan yeca oncac se hueyi paquilistli ipan nopa altepetl. ");
INSERT INTO nheNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Huan itztoya nepa se tlacatl tlen itoca eliyaya Simón tlen huejcajquiya momajtoya tetlajchihuía ipan nopa altepetl. Huan quincajcayajtoya miyac tlacame ipan nopa estado Samaria. Teilhuiyaya para quipixqui hueyi chicahualistli. ");
INSERT INTO nheNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Huan nochi tlacame huan sihuame nepa yonque teicneltzitzi o tominpiyayayaj momatque quitlacaquilíaj Simón huan quiijtohuayayaj tlen ya: “Ni Simón quipiya ihueyi chicahualis Toteco.” ");
INSERT INTO nheNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Huan nochi quitoquilijque Simón pampa para miyac xihuitl quincajcayajtoya ica itetlajchihuil. ");
INSERT INTO nheNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero Felipe ajsico, nochi tlacame quicajque nopa cuali tlajtoli tlen Jesucristo huan itequihuejcayo huan quicajque quejatza Toteco tlanahuatis, huan yeca miyac tlacame quineltocaque. Huan miyac mocuaaltijque, tlacame huan sihuame. ");
INSERT INTO nheNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Huan Simón nojquiya quineltocac huan nojquiya mocuaalti huan pejqui nemi ihuaya Felipe. Huan Simón san quisentlachiliyaya nopa tlanescayotl huan huejhueyi chicahualnescayotl tlen Felipe quichihuayaya. ");
INSERT INTO nheNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Huan quema nopa tlayolmelahuani ipan altepetl Jerusalén quicajque para miyac tlacame ipan estado Samaria quiselijtoyaj itlajtol Toteco, quintitlanque Pedro huan Juan ma yaca nepa. ");
INSERT INTO nheNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Huan Pedro huan Juan ajsitoj huan momaijtojque para nopa tlaneltocani ma quiselica Itonal Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aya ajsitoya Itonal Toteco ipan ininyolo, pampa san mocuaaltijque ica itequihuejcayo Jesús para quitoquilise ya. ");
INSERT INTO nheNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Huajca Pedro huan Juan pejque quintlalilíaj ininma ininpani huan nopa tlaneltocani quiseliyayaj Itonal Toteco ipan ininyolo. ");
INSERT INTO nheNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Huan Simón quiitac quejatza nopa tlayolmelahuani quintlaliliyayaj ininma ininpani tlacame huan quiseliyayaj Itonal Toteco, huan nojquiya quinejqui quichihuas. Huajca quintencahuili tomi Pedro huan Juan para ma quimacaca nopa chicahualistli. ");
INSERT INTO nheNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Quinilhui: ―Xinechmacaca ni chicahualistli nojquiya para huelis nijtlalis noma ipan tlen hueli tlacatl huan yajaya quiselis Itonal Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Huan Pedro quiilhui: ―Ma Toteco mitztzontlamilti ihuaya motomi pampa timoilhuía huelis tijcohuas nopa tlen san Toteco hueli temaca huan yajaya temaca queja se regalo. ");
INSERT INTO nheNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ax tleno tijpiya ihuaya ni tequitl pampa ax cuali moyolo iixpa Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Huajca xijpatla moyolo huan xijcahua nopa tlajtlacoli. Huan xijtlajtlani Toteco ica nochi moyolo intla huelis mitztlapojpolhuis ica tlen timoyolilhuijtoc, ");
INSERT INTO nheNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","pampa niquita tlahuel tiyolquentzi huan tlajtlacoli motlatzquilijtoc ipan moyolo. ");
INSERT INTO nheNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pero Simón quiilhui Pedro: ―Xijtlajtlanica Toteco ma nechtlapojpolhui para ax nechtzontlamiltis queja tiquijtojtoc. ");
INSERT INTO nheNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Huan nopa tlayolmelahuani tepohuilijque itlajtol Toteco huan teilhuijque tlen quiitztoyaj. Huan teipa mocuepque altepetl Jerusalén. Huan ipan ojtli quipanotiyajque miyac pilaltepetzitzi ipan estado Samaria huan nepa nojquiya tlayolmelahuayayaj itlajtol Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Teipa ajsico se ielhuicac ejca Toteco huan quiilhui Felipe: “Xiya ica tlani hasta nopa ojtli tlen onquisa Jerusalén huan pano ipan nopa huactoc tlali huan yohui hasta Gaza.” ");
INSERT INTO nheNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Huajca Felipe nima quistejqui. Huan nepa quipanti se eunuco tlacatl tlen elqui se ihueyi tequitica nopa sihua tlanahuatijquetl, Candace, ipan tlali Etiopía. Quimocuitlahui nochi itomi nopa hueyi tlali. Nopa tlacatl yajtoya Jerusalén para quihueyichihuas Toteco, ");
INSERT INTO nheNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","huan mocuepayaya itlal ipan se cuacarro tlen cahuajme quitilanayayaj. Huan ipan ojtli quipohuayaya nopa amatl tlen quiijcuilo tiocamanalojquetl Isaías huejcajquiya. ");
INSERT INTO nheNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Huan Itonal Toteco quiilhui Felipe: ―Xiya, xijnechcahuiti nopa cuacarro. ");
INSERT INTO nheNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Huan Felipe quinechcahui huan quicajqui quipohuayaya iama Isaías. Huan Felipe quitlajtlani: ―¿Tijmachilía tlen tijpohua? ");
INSERT INTO nheNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Huan nopa tlacatl quiilhui: ―Ax huelis nijmachilis intla axaca nechixtomilis. Huan quiilhui Felipe ma tlejco huan ma mosehui ihuaya ipan icuacarro. ");
INSERT INTO nheNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Huan yajaya quipohuayaya ipan Itlajtol Toteco campa quiijtohua: “Tlacame quihuicase queja quihuicaj se borrego para quimictise. Huan queja se pilborregojtzi ax tzajtzi quema tlacame quiximaj, nojquiya ax tleno quiijtos quema quihuicase para quimictise. ");
INSERT INTO nheNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Quipinahualtise huan ax quichihuilise tlen xitlahuac. Axaca huelis camatis tlen iteipa ixhuihua, pampa ax quinpiyas. Quimictise huan yajaya quisas ipan totlaltepac.” ");
INSERT INTO nheNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Huan nopa eunuco tlacatl quitlajtlani Felipe: ―Xinechilhui intla nopa tiocamanalojquetl camatiyaya tlen ya ipantisquía, o camatiyaya tlen seyoc ipantis. ");
INSERT INTO nheNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Huajca Felipe pejqui campa quipohuayaya ipan Itlajtol Toteco huan quiyolmelajqui nopa cuali tlajtoli tlen Jesús. ");
INSERT INTO nheNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Huan yajtiyohuiyayaj ipan ojtli, huan ajsitoj campa mantoya atl huan nopa tlacatl quiilhui Felipe: ―Xiquita, nica onca atl. ¿Huelis tinechcuaaltis? ");
INSERT INTO nheNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Huan Felipe quiilhui: ―Intla tijneltoca ica nochi moyolo, nimitzcuaaltis. Huan nopa tlacatl quiijto: ―Nijneltoca para Jesucristo yajaya Icone Toteco. ");
INSERT INTO nheNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Huajca Felipe quiilhui ma quiquetza icuacarro. Huan temoque nochi ome san sejco huan calajque ipan nopa atl huan Felipe quicuaalti. ");
INSERT INTO nheNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Huan quema inijuanti quisayayaj ipan atl, Itonal Toteco quihuicac Felipe, huan nopa tlacatl ayoc quiitac, pero yajqui ipan iojhui ica paquilistli. ");
INSERT INTO nheNT_vpl VALUES ("AC8_40","